﻿USE sofia;
DROP TABLE IF EXISTS sofia.mfo_vpl;
CREATE TABLE mfo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mfo_vpl WRITE;
INSERT INTO mfo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","K'ittẹwọr, Ibinọkpaabyi osi ẹrọng ọmaana irerek. ");
INSERT INTO mfo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","M'ogbe nwuma ọttọhk manda vani kode, ọyagbin ode idukhi, ibe kpenamkpen ipyi erungi bi kaang. Egwugwuma ch'Ibinọkpaabyi erenga ẹbaabha asi. ");
INSERT INTO mfo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Mẹ wọ osi, Ibinọkpaabyi, oben bi, “Tte iyaan iwobha.” Wa iyaan iwobha. ");
INSERT INTO mfo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ibinọkpaabyi ore bi, iyaan ikk'ijibha, Ibinọkpaabyi ọbhaangi iyaan ide ngọmi ttara ipyerungi. ");
INSERT INTO mfo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Mẹ wọ osi, Ibinọkpaabyi oyeri iyaan nnuma, ẹya, obiro oyeri ipyerungi, erungi. Wa ekpebha ọmaana ẹchọhkha bọ asi echedenwu m'ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ibinọkpaabyi oben bi, “Tte ọrọngkpakpa oyin k'ottem kw'asi. Tte ọbhaangi asi p'ẹrọng ọmaana asi p'irekh-irek.” ");
INSERT INTO mfo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Mẹ wọ osi, Ibinọkpaabyi osi ọrọngkpakpa ọbhaangi asi. Asi bani awobha k'ọrọngkpakpa ebir-ebir, bani awobha k'ọrọngkpakpa irekh-irek. Iwa kwẹ ode mando. ");
INSERT INTO mfo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ibinọkpaabyi oyeri ẹrọng, ọrọngkpakpa. Wa ekpebha ọmaana ẹchọhkha bọ asi ottong iwu ifa m'oyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ibinọkpaabyi obiro oben bi, “Tte asi p'awobh k'ọrọngkpakpa irekh-irek atzobha ibe rani, ifha ogbin oyin.” Iwa kwẹ ode mando. ");
INSERT INTO mfo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ibinọkpaabyi oyeri irerek, ogbin, obiro oyeri asi p'atzobh ibe rani, araanga p'ideden. Ibinọkpaabyi ore bi, okk'ojibha. ");
INSERT INTO mfo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ibinọkpaabyi oben bi, “Tte irerek imen ekpo k'adem-k'adem: araraari p'áwọm amọma p'ámen ka ngera sabẹ ọmaana nchi si ńwọm aduk p'ási amọma pabẹ, k'odem kwa sẹ nde.” Iwa kwẹ ode mando. ");
INSERT INTO mfo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Irerek imen araraari k'adem-k'adem, araraari awọm amọma p'afon k'amọma pabẹ ka for, nchi nwọm aduk p'afon k'amọma p'achiduk pabẹ ka for. Ibinọkpaabyi ore bi, okk'ojibha. ");
INSERT INTO mfo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Wa ekpebha ọmaana ẹchọhkha bọ asi ottong iwu ittaan m'oyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ibinọkpaabyi oben bi, “Tte mkpon nwobha k'ọrọngkpakpa, sa ḿmaangi ẹya k'ipyerungi, tte sẹ nde ẹkhọhkha ch'igbe s'ọdadaami, ch'iwu ọmaana cha cho. ");
INSERT INTO mfo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Tte mkpon nnuma mmaani k'ọrọngkpakpa, ifha sẹ ńnang iyaan k'irerek.” Iwa kwẹ ode mando. ");
INSERT INTO mfo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ibinọkpaabyi osi mkpon mfa sa ndeden. Wa osi ch'ẹbar-ọbar bi ẹkhaama ẹfa k'ẹya, ch'ẹkhar-ọkhara bi ekkeri erungi. Wa obiro osi ndodori. ");
INSERT INTO mfo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ibinọkpaabyi ohok mkpon nwobha k'ọrọngkpakpa bi, sẹ nnang iyaan k'irerek, ");
INSERT INTO mfo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ọmaana bi, sẹ nkkeri ẹya ọmaana erungi, ọmaana bi sẹ mmaangi iyaan k'ipyerungi. Ibinọkpaabyi ore bi, okk'ojibha. ");
INSERT INTO mfo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Iwa ekpebha ọmaana ẹchọhkha bọ asi ottong iwu inna m'ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ibinọkpaabyi oben bi, “Tte nden k'adem-k'adem mfu k'asi, sa nhaabh-ọhaabh, nwobha akpen. Tte ọnọhn f'ẹrọng okhur k'iwokhi s'ọyagbin k'ọrọngkpakpa.” ");
INSERT INTO mfo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Mando wọ kw'Ibinọkpaabyi osi nden sa ndeden s'asi, ọmaana ọttọhk kpenamkpen f'orukhi akpen, obiro orenga k'asi, ọmaana ọnọhn k'adem-k'adem f'ọkhaam mbabaang. Ibinọkpaabyi ore bi, okk'ojibha. ");
INSERT INTO mfo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ibinọkpaabyi odo nden nnuma biphyir s'ọkk'ọsa, oben sẹ bi, “Bọng maan ayok k'ọhaabh abira afu k'asi p'araanga. Tte ọnọhn ọn-ọhaabh k'ọyagbin.” ");
INSERT INTO mfo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Wa ekpebha ọmaana ẹchọhkha bọ asi ottong iwu izen m'ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ibinọkpaabyi obiro oben bi, “Tte irerek itzima nden sa nnukhi akpen k'adem pabẹ iyin, nden s'otzer, ọmaana ọttọhk kpenamkpen f'oreng k'irerek ttara nden s'ẹtzam otzor k'adem pabẹ.” Iwa kwẹ ode mando. ");
INSERT INTO mfo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Mando wọ kw'iwa Ibinọkpaabyi osi nden s'ẹtzam, ọmaana nden s'otzer otzor k'adem pabẹ, ttara ọttọhk kpenamkpen f'oreng k'irerek otzor k'adem pabẹ. Ibinọkpaabyi ore bi, okk'ojibha. ");
INSERT INTO mfo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Mẹ wọ, Ibinọkpaabyi oben bi, “Tte mosi anọngẹya ka ngera saman, p'akher man. Tte bẹ abaabha nden s'asi, ọmaana ọnọhn f'ẹrọng, ọmaana nden s'otzer, ọmaana irerek biphyir ttara ọttọhk kpenamkpen f'oreng k'irek.” ");
INSERT INTO mfo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Mẹ wọ, wa Ibinọkpaabyi oyok anọngẹya, oyok bẹ ka ngera sẹ. Wa oyok bẹ, ojinọng ọmaana kwanọng. ");
INSERT INTO mfo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ibinọkpaabyi odo bẹ, oben bẹ bi, “Bọng maan ayok, abira ahaabh, tte va pabọng afu ọyagbin, abira abaabha ọyagbin, ọmaana nden s'asi, ọmaana ọnọhn f'ẹrọng, ttara ọttọhk kpenamkpen f'owobh akpen, f'oreng k'irerek.” ");
INSERT INTO mfo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Mẹ wọ osi, Ibinọkpaabyi oben bẹ bi, “Bọng kkeri, nkk'bọng achiduk ttara achimọma kpenamkpen p'awobh k'irerek nnanga, nchi biphyir sa nwọm aduk p'amọma awobh k'ẹtzaanga bi, sẹ ńde ọchattọhk fabọng. ");
INSERT INTO mfo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Onode nden biphyir si nnukhi akpen k'irerek, ọmaana ọnọhn f'ẹrọng biphyir, ttara ọttọhk kpenamkpen f'oreng k'irerek, obiro oruk akpen, nkk'bẹ akwongitzọhng p'ẹtzam nnanga bi, bẹ achi, mach'ọchattọhk fabẹ.” Iwa kwẹ ode mando. ");
INSERT INTO mfo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Iwa Ibinọkpaabyi ore bi, ọttọhk kpenamkpen f'ọkk'ọsa okk'ojibha kpọng-kpọng. Wa ekpebha ọmaana ẹchọhkha bọ asi ottong iwu izadani. ");
INSERT INTO mfo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Iwa Ibinọkpaabyi okyera ọtzọhm f'ẹrọng, ọmaana irerek osisi, ttara ọttọhk kpenamkpen f'owobh k'ẹtzaanga kwabẹ. ");
INSERT INTO mfo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ottong iwu izenamfa, Ibinọkpaabyi okk'ọtzọhm okyera f'om-osi, m'ewu ch'ettong iwu izenamfa okwokha ọwọhng k'ọtzọhm f'ọkk'ọm-ọsa. ");
INSERT INTO mfo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ibinọkpaabyi odo ewu nda ch'ettong izenamfa, ohok chẹ mach'ewu ch'ewur-owur, okhuri bi, m'ewu nda dọ ch'okwok ọwọhng, k'ọtzọhm f'ọyagbin osisi. ");
INSERT INTO mfo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ma wọ ode odem kw'iwa Ọvaar Ibinọkpaabyi oreng oyok ẹrọng ọmaana irek. K'ogbe kw'Ọvaar Ibinọkpaabyi osi ẹrọng ọmaana irerek, ");
INSERT INTO mfo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","iwa echi manda dani kemeni, ọraraari manda wani kobiro ommen, okhuri da Ọvaar Ibinọkpaabyi oni ẹrọng otzim ọsa bi, etzebh k'irerek, ttara bi, iwa ọnọng kw'ọyaabh irerek kode. ");
INSERT INTO mfo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Yina, asi am-ayin k'irerek, asi irerek biphyir idiri. ");
INSERT INTO mfo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Mẹ wọ, Ọvaar Ibinọkpaabyi otzima idọdọhbh ọbanga ojinọng, oji ọwọhng kw'akpen ọkhẹ-ẹ k'ahungmma, ojinọng nwa on-oruk akpen. ");
INSERT INTO mfo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ọvaar Ibinọkpaabyi osi owoni, kẹ da ewuchen em-eyin, k'Iden. Ọtzọkha ojinọng nwa kw'ọkk'ọbanga okhe mẹ. ");
INSERT INTO mfo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ọvaar Ibinọkpaabyi osi irerek imen nchi kpenamkpen k'adem-k'adem, nchi si njibhi ka chen, mbiri njibh k'ọchattọhk. Nchi mfa mbe k'ewonittem, echi dani ede ch'akpen, ndonggo ede ch'etzim-nonga ch'ejibha ọmaana epyibha. ");
INSERT INTO mfo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Kẹ kw'ọraanga, kw'ofon k'Iden obhobhi ọkwọbha, obiro ọkhe asi m'ewonittem nduma, mẹ kw'ọraanga nwuma, obiro ọbhaangi k'araanga anna. ");
INSERT INTO mfo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ọraanga kw'ocheden okpen Pishọn, kẹ wọ obhobhi ochina k'irek sa Havila biphyir, kẹ da gol owobh. ");
INSERT INTO mfo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Gol kw'irerek nnuma ode ọkkakkakwẹ. Wa ibe nnuma ibiri ikhaama ana p'adaami eruk, ọmaana atza p'ọniks. ");
INSERT INTO mfo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ọraanga kw'ottong afa okpena Gihọn, kẹ wọ obhobhi ọkhọri irek sa Kush biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ọraanga kw'ottong attaan okpena Tigiris, kẹ wọ obhobhi k'okhubha kw'ewuchen em-eyin k'Asiriya. Ọraanga kw'ottong anna okpena Yupharetes. ");
INSERT INTO mfo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ọvaar Ibinọkpaabyi ọtzọkha ojinọng nwa ohok k'owoni kw'Iden, ifha ọyaabha owoni nwa obiro okker-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ọvaar Ibinọkpaabyi ọn-ọsana ojinọng nwa bi, “Kọ akhaam ọphaangi kẹ bi, achi achiduk kpenamkpen pa nchi si mbe m'owoni nwa. ");
INSERT INTO mfo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Onode echi ch'etzim-nonga ch'ejibha ọmaana epyibha, kọ kàkhaambi, achi. Ewu ch'achi chẹ, akhaambi da ápe.” ");
INSERT INTO mfo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Mẹ wọ, Ọvaar Ibinọkpaabyi on-oben bi, “Kojibhi bi, ojinọng nwa owobha mancheni, kaam ńsi oyok-ẹkhaan kw'ọ́baan-ẹ nnang-ẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ode ch'Ọvaar Ibinọkpaabyi okk'idọdọhbh otzima ọbanga nden kpenamkpen s'ẹtzam, ọmaana ọnọhn f'ẹrọng. Ọtzọkha pyẹ biphyir ochena ojinọng nwa, ifha ore che-dema p'okpe pyẹ. Che ch'ojinọng nwa okpe ọttọhk kpenamkpen f'orukhi akpen, mando kwa fẹ okpen. ");
INSERT INTO mfo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Mẹ wọ osi, ojinọng nwa okpe nden s'otzer biphyir che, ọmaana ọnọhn f'ẹrọng ttara nden s'ẹtzam biphyir. Yina, onode ojinọng oyok-ẹkhaan, kw'ọbaan-ẹ kode. ");
INSERT INTO mfo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Mẹ wọ osi, Ọvaar Ibinọkpaabyi osi ojinọng nwa ọttaabha ẹdadim. Mada ojinọng otzim ọttaabh-ọttaabha, ọrọbh-ẹ ọtzẹtzẹngchikpa wani, obiro ọraakha ibe nnuma s'ọrọhbh ọtzẹtzẹngchikpa nwa ttara etzen-yaara. ");
INSERT INTO mfo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Mẹ wọ osi, Ọvaar Ibinọkpaabyi ọtzọkha ọtzẹtzẹngchikpa kw'ọkk'ọrọbha k'ojinọng, otzima osi kwanọng, ọtzọkh-ẹ ochena ojinọng. ");
INSERT INTO mfo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ojinọng nwa oben bi, “Ma wọ on-ode ọkhọbhi kw'akhọbhi paam, ẹyaara ch'ẹyaara chaam. Kẹ bẹ áyer-ẹ, kwanọng, okhuri da bẹ arọbh-ẹ k'ojinọng ka for.” ");
INSERT INTO mfo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ofona mẹ, ojinọng óbina oji otte ttara ọkka, ọn-ọgbakha for sẹ ttara kwanọng kwẹ, ifha bẹ anọng afa an-ade ọnọng wani. ");
INSERT INTO mfo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Wa ojinọng nwa ọmaana kwanọng kwẹ awobh irinikhum, bẹ mgbar karọbhi. ");
INSERT INTO mfo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Iwa jọhk dọ edongi, ẹyọhnga nden s'ẹtzam biphyir, s'Ọvaar Ibinọkpaabyi ọkk'ọsa. Wa jọhk ẹtza ẹbọbh kwanọng nwa bi, “Ode odik-ọkka bi, Ibinọkpaabyi obeni bi, bọng aningi echi kpenamkpen m'owoni nwa achi o?” ");
INSERT INTO mfo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Kwanọng nwa oben jọhk bi, “Nnh, nnh! Kwẹ mando kode! Ibinọkpaabyi obeni man bi, mofho ochi achiduk pa nchi si mbe mowoni ochi e, ");
INSERT INTO mfo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","yina, Ibinọkpaabyi on-obiro oben man bi, man kọ̀khaambi, ochi achiduk p'echi nduma ch'ebe m'ewonittem, man kọ̀khaambi ọttọhmi chẹ, oni mando ode, mópope.” ");
INSERT INTO mfo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Jọhk nda eben kwanọng nwa bi, “Bọng kápe e, ");
INSERT INTO mfo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","okhinggẹ ode bi, Ibinọkpaabyi orong bi, idikha bọng achi achiduk mba, bọng are idik ittaani bọng bi ttaaan, bọng an-abira ade mach'Ibinọkpaabyi kw'orong ejibha ọmaana epyibha.” ");
INSERT INTO mfo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mẹ wọ, mada kwanọng nwa ore bi, achiduk p'echi nda ajibh-ojibh k'ọchattọhk, bẹ abira anyu-onyu ka chen, ttara bi, bẹ afha anang ọnọng etzim-nonga, ọtzọkha bani ochi, obiro ọtzọkha ọnang odim kwẹ, kw'owobh mẹ ttara kẹ, odim obiro ọtzọkha ochi. ");
INSERT INTO mfo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Mẹ ẹbaa nduma, chen attaani bẹ anọng afa, bẹ atzin bi, bẹ an-awobh irinikhum. Mẹ wọ, bẹ an-atzọkha akwongitzọhng p'echi cha fig, akhum ekpo abubha irinikhum sabẹ. ");
INSERT INTO mfo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Okwu opyiri ma nchọhkha-bọhk, ojinọng ọmaana kwanọng kwẹ, an-abhaanga da Ọvaar Ibinọkpaabyi om-orenga m'owoni. Ofona mẹ, bẹ an-achubha Ọvaar Ibinọkpaabyi k'ottem kwa nchi s'owoni nwa. ");
INSERT INTO mfo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Yina, Ọvaar Ibinọkpaabyi ogwon ojinọng, ọbọbh-ẹ bi, “Awobh man o?” ");
INSERT INTO mfo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Kẹ obhina bi, “Kaam mmaang ndọkhi sọ, da am-arenga m'owoni, ojora osi-m, okhuri da ndim irinikhum, kẹ wọ osi nchubha e.” ");
INSERT INTO mfo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ọvaar Ibinọkpaabyi ọn-ọbọbh-ẹ bi, “Kọ anyi wọ ọgbaakh-ọ bi, atzim irinikhum? Akk'achiduk p'echi cha nsan-ọ, acha o?” ");
INSERT INTO mfo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ojinọng nwa obhin-ẹ bi, “Kwanọng kw'anang-m wọ ọnang-m achiduk p'afon m'echi nduma, yina kaam nchi e.” ");
INSERT INTO mfo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Mẹ wọ osi, Ọvaar Ibinọkpaabyi ọn-ọbọbh kwanọng bi, “Bọng odik kw'asi ma?” Kwanọng nwa obhin-ẹ bi, “Jọhk dọ ẹbọhr-m, yina kaam ndọkha achiduk mbuma nchi e.” ");
INSERT INTO mfo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Mẹ wọ, Ọvaar Ibinọkpaabyi oben jọhk bi, “Okhuri odik nwa kw'asi ma, ópyibh-ópyibh ọnang-ọ, ọyọhnga nden s'otzer biphyir ọmaana nden s'ẹtzam biphyir, kọ átzọr ẹbhọr k'irek, ábira áchi ọkpọhm k'akpen pọ biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Kaam ńge ittattaanga k'ottem kwa kọ ọmaana kwanọng nwa, ttara k'ottem kwa va pọ ọmaana va pẹ, bẹ awobha k'ittattaanga ttara ayok. Nnwa kwẹ ótzukhi eho chọ, kọ ákhimi ibhokhọkhọri sẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ibinọkpaabyi on-oben kwanọng nwa bi, “Kaam ńttar-ọ ihem s'ideden, k'ogbe kpenamkpen kw'ám-amaan nnwa. Kaambi mẹ wọ, kọ ọm-ọdaakh-ọ bi, tte awobha abaanga odim kwọ, yina, odim wọ ọbaabh-ọ.” ");
INSERT INTO mfo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Obiro oben Adam bi, “Kọ ayong kwanọng kwọ itzọhng, achi ochiduk kw'echi cha nsaan-ọ bi, aninga achi, kaam ńnang irerek ẹmma okhuri kọ. Kọ ám-are ihem s'ọtzọhm, yina áchi ọttọhk m'irek nna, k'akpen pọ biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Afhodima ọmaana akkaangi ámen m'irerek. Kọ abira achi araraari p'owoni. ");
INSERT INTO mfo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kọ ám-asi ọtzọhm maa arunga, yina ákhaama ọchattọhk f'áchi, ttẹwọr ma maa atza apyiri k'ogbe kw'ákpa nnam k'irerek, okhuri bi, bẹ atzim idọdọhbh asọ-ọ, m'idọdọhbh nnuma rani rọ s'ábira ábhakhi akpa nnam.” ");
INSERT INTO mfo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Wa Adam okpe kwanọng kwẹ Iv, okhuri bi, kẹ wọ óde ọkka kw'anọng biphyir p'arukhi akpen. ");
INSERT INTO mfo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Wa Ọvaar Ibinọkpaabyi ọtzọkha ndenkpa, otzima osi ekpo ẹfhọrapyẹ, ọnang Adam ọmaana kwanọng kwẹ, ifha bẹ afhọra, atzima abubha irinikhum sabẹ. ");
INSERT INTO mfo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Mẹ wọ osi, Ọvaar Ibinọkpaabyi oben bi, “Ojinọng nwa ọkk'ọn-ọda macha man, okk'ejibha ọmaana epyibha on-oronga. Kẹ kọ̀khaambi, onemi ọbọhk ọpha ochiduk m'echi ch'akpen ochi, oni mando ode, kẹ oruk akpen maa ogbe ode.” ");
INSERT INTO mfo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Mẹ wọ osi, Ọvaar Ibinọkpaabyi okhubh Adam k'owoni kw'Iden, ifha ọyaabha irerek s'otzim ọbang-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Mada Ibinọkpaabyi okhubhi Adam, ohok achẹrubim k'okhubha kw'ewuchen em-eyin k'owoni kw'Iden, ọmaana ọkkangkkaang kw'ode mach'okpondaak kw'ọwọm bi wuruwuru, ọbhakhi iriring okkeri k'ibe kpenamkpen, ifha bẹ akpa eden ch'echin k'echi nduma ch'ẹnangi akpen. ");
INSERT INTO mfo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Iwa Adam oyima kwanọng kwẹ Iv abẹ, Iv otzima ibhọr ọmaan Ken. Iv oben bi, “K'ẹkkaana ch'Ọvaar Ibinọkpaabyi ọnang-m, kaam nkk'nnwa kw'ijinọng mmaana.” ");
INSERT INTO mfo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Wa Iv obiro otzima ibhọr ọmaan ọgbaanọkka kwa Ken, kw'ode Ebẹl. Iwa Ebẹl ode okkeri arukhimaan. Ken ode ọnọng kw'ọyaabh owoni. ");
INSERT INTO mfo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Okwu otzuma k'ogbe mẹ, Ken otzima achiduk p'owoni kwẹ, osi ẹnanga ọnang Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ebẹl ọtzọkha acheden-va p'arukhimaan pẹ p'ajibhi for, otzima osi ẹnanga. Ọvaar Ibinọkpaabyi ọdaam ettem ttara Ebẹl ọmaana ẹnanga chẹ. ");
INSERT INTO mfo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Onode Ken ọmaana ẹnanga chẹ, Ibinọkpaabyi ettem kẹ kẹdaami. Mẹ wọ osi, Ken ettem epyibh-ẹ, on-obhor itzitzikha. ");
INSERT INTO mfo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ọvaar Ibinọkpaabyi ọbọbh Ken bi, “Ode yan kw'ettem epyibh-ọ? Osi yan kw'abhori itzitzikha? ");
INSERT INTO mfo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Idikha ira kọ akk'ejibha asa, ira kaam ettem kindaam ttar-ọ o? Yina, da ani ejibha asi, epyibha ẹm-ẹbaami bi, ẹbọkh-ọ. Kọ akhaambi, akhema chẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Wa Ken okwu ọkhaama nttọhna ttara ọgbaanọkka Ebẹl, oben-ẹ bi, “Tte moyin k'ẹtzam.” Mada abẹ awobh k'ẹtzam, Ken ottum ọgbaanọkka Ebẹl ofhu. ");
INSERT INTO mfo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Mẹ wọ osi, Ọvaar Ibinọkpaabyi ọbọbh Ken bi, “Agbaanakka Ebẹl ko o?” Ken obhina bi, “Kaam kinnong, kaam wọ mminkkeri ọgbaanọkka kwaam o?” ");
INSERT INTO mfo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ọvaar Ibinọkpaabyi oben bi, “Bọng odik kw'asi ma? Izi s'agbaanakka im-ibhomi iyer-m k'irek, mach'ẹmọng ch'ebhomi eror ẹkkaana. ");
INSERT INTO mfo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Mẹ wọ osi, nnang-ọ ẹmma, mbiri ngwubh-ọ k'irerek s'igwong ẹmma igwo izi s'agbaanakka kw'afhu. ");
INSERT INTO mfo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kọ ayaabh irerek, ekpo dọk kéjibh ẹnang-ọ. Kọ ẹwọr k'ibe rani kábọkha, án-ade ottettena-nọng m'ọyagbin.” ");
INSERT INTO mfo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ken oben Ọvaar Ibinọkpaabyi bi, “Ihem saam ibari iyọhng-m bi ndọhkha. ");
INSERT INTO mfo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Mayina akk'aam akhubha m'irerek nna, ọmaana k'itzitzikha sọ, kaam nna nnọbh ebhon, mbiri nde ottettena-nọng m'ọyagbin, ọnọng kpenamkpen kw'óre-m ófhu-m ofhu.” ");
INSERT INTO mfo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yina, Ọvaar Ibinọkpaabyi on-oben Ken bi, “Ọnọng kpenamkpen kw'ọfhọ-ọ, ọ́tzọkha ọmmamma kw'ọ́yọhnga kwọ, igbe izenamfa.” Mẹ wọ osi, Ọvaar Ibinọkpaabyi okhe Ken ebhora ka for, ifha ọnọng kpenamkpen kw'ọ́rẹ-ẹ oning-ẹ ófhu. ");
INSERT INTO mfo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ken obina k'itzitzikha s'Ọvaar Ibinọkpaabyi ottena, otza oruk k'irek sa Nọd, k'okhubha kw'ewuchen em-eyin k'Iden. ");
INSERT INTO mfo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Wa Ken oyima kwanọng kwẹ abẹ, kwanọng otzima ibhọr ọmaan Ẹnọk. M'ogbe nwa, wa Ken om-osi obhon. Che cha nnwa kwẹ Ẹnọk, ch'ọtzọk okpe obhon nwa. ");
INSERT INTO mfo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Wa Ẹnọk obhoni Irad. Irad obhon Mehujayẹl, Mehujayẹl obhon Metusayẹl Metusayẹl obiro obhon Lamẹk. ");
INSERT INTO mfo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Wa Lamẹk ọtzọk panọng afa; wani okpen Ada, nwonggo okpena Zila. ");
INSERT INTO mfo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Wa Ada ọmaan Jabal, kẹ wọ iwa ode otte kw'anọng p'iwa am-aruk k'okhira, abira atzir nden. ");
INSERT INTO mfo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ọgbaanọkka kwẹ okpena Jubal, kẹ wọ ode otte kw'anọng p'abhaa ogim-ogim okhikhir, am-abira agyi ophoropho. ");
INSERT INTO mfo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila, obiro ọmaan Tubal-Ken, kw'om-oduk brons ọmaana akkonga otzima osi ekpo k'adem-k'adem. Ọgbaanọkka kwa Tubal-Ken kw'ikwanọng ode Naama. ");
INSERT INTO mfo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Wa Lamẹk on-oben panọng pẹ bi, “Ada ọmaana Zila, Bọng panọng paam, bọng bhaanga atzim paam. Kaam nkk'ọnọng mfha, kw'omumum-m ọttọhk, odikkobh, kw'orim-m abẹ, kẹ wọ kwa mfhu. ");
INSERT INTO mfo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Idikha ọnọng manda wani ofhu Ken, kẹ óre ihem s'iyọhnga sa Ken igbe izenamfa, Yina, idikha ọnọng ofhu kaam Lamẹk, okhuri odikkobh kw'akaam mfhu, kẹ óre ihem s'iyọhnga s'ọnọng kw'ofhu Ken, igbe arọbh attaan obhiri chi obhiri afa.” ");
INSERT INTO mfo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Wa Adam obiro oyima kwanọng kwẹ abẹ, kwanọng otzima ibhọr ọmaan nnwa kw'ijinọng, ọkpẹ-ẹ Sẹt, oben bi, “Ibinọkpaabyi ọkk'aam nnwa ọdọdọk ọnanga kw'otzer eho ch'Ebẹl, kwa Ken ofhu.” ");
INSERT INTO mfo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sẹt obiro obhon nnwa kw'ijinọng, ọkpẹ-ẹ Ẹnọs. Wa k'ogbe kw'Ẹnọs wọ kw'anọng attẹwọr akpobha che ch'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ma wọ ode nnwẹr kw'odem kw'efonamma ch'Adam. Mada iwa Ibinọkpaabyi oyokhi anọngẹya, wa osi bẹ ka ngera sẹ. ");
INSERT INTO mfo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Wa oyokhi bẹ, ojinọng ọmaana kwanọng, odo bẹ, oyeri bẹ, Anọngẹya. ");
INSERT INTO mfo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Wa Adam okk'cho arọbh azadani obhiri jobh orukha, yina on-obhoni nnwa kw'ijinọng ka ngera sẹ, ọkpẹ-ẹ Sẹt. ");
INSERT INTO mfo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Mada Adam okk'Sẹt obhona, wa obiro oruk cho nnọhna mfa, obiro obhon ajinọng ọmaana panọng adọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Biphyir-phyir, wa Adam orukhi cho nnọhna mfa obhiri arọbh azadani obhiri jobh, yina on-ope. ");
INSERT INTO mfo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Mada Sẹt okk'cho arọbh azen obhiri azen orukha, obhon Ẹnọs. ");
INSERT INTO mfo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Mada Sẹt okk'Ẹnọs obhona, wa obiro oruk cho nnọhna mfa obhiri azenamfa, obiro obhon ajinọng ọmaana panọng adọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Biphyir-phyir, wa Sẹt orukhi cho nnọhna mfa obhiri arọbh azen obhiri jobh obhiri afa, yina on-ope. ");
INSERT INTO mfo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Mada Ẹnọs okk'cho arọbh anna obhiri jobh orukha, obhon Kenan. ");
INSERT INTO mfo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Mada okk'Kenan obhona, wa obiro oruk cho nnọhna mfa obhiri chi, obiro obhon ajinọng ọmaana panọng adọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Biphyir-phyir, wa Ẹnọs orukhi cho nnọhna mfa obhiri arọbh azen obhiri azen, yina on-ope. ");
INSERT INTO mfo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Mada Kenan okk'cho arọbh attaan obhiri jobh orukha, obhon Mahalalẹl. ");
INSERT INTO mfo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mada okk'Mahalalẹl obhona, wa obiro oruk cho nnọhna mfa obhiri arọbh afa, obiro obhon ajinọng ọmaana panọng adọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Biphyir-phyir, wa Kenan orukhi cho nnọhna mfa obhiri arọbh azen obhiri jobh, yina on-ope. ");
INSERT INTO mfo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mada Mahalalẹl okk'cho arọbh attaan obhiri azen orukha, obhon Jarẹd. ");
INSERT INTO mfo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mada Mahalalẹl okk'Jarẹd obhona, wa obiro oruk cho nnọhna mfa obhiri ẹrọbh obhiri jobh, obiro obhon ajinọng ọmaana panọng adọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Biphyir-phyir, wa Mahalalẹl orukhi cho nnọhna mfa obhiri arọbh anna obhiri chi, yina on-ope. ");
INSERT INTO mfo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Mada Jarẹd okk'cho arọbh azenanttaan obhiri afa orukha, obhon Ẹnọk. ");
INSERT INTO mfo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Mada Jarẹd okk'Ẹnọk obhona, obiro oruk cho nnọhna mfa, obiro obhon ajinọng ọmaana panọng adọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Biphyir-phyir, wa Jarẹd orukhi cho nnọhna mfa obhiri arọbh azenanttaan obhiri afa, yina on-ope. ");
INSERT INTO mfo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Mada Ẹnọk okk'cho arọbh attaan obhiri azen orukha, obhon Mẹtusẹla. ");
INSERT INTO mfo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Mada okk'Mẹtusẹla obhona, Ẹnọk ochina ororo ọtzọn Ibinọkpaabyi abẹ ka cho arọbh chi adọdọk, obiro obhon ajinọng ọmaana panọng adọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Biphyir-phyir, wa Ẹnọk orukhi cho arọbh chi obhiri arọbh attaan obhiri azen. ");
INSERT INTO mfo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Wa Ẹnọk ochina ororo ọtzọn Ibinọkpaabyi abẹ, mẹ wọ, Ibinọkpaabyi otzim-ẹ ofona m'oyagbin nwa. ");
INSERT INTO mfo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mada Mẹtusẹla okk'cho arọbh ọhawani kwa jobh obhiri azenamfa orukha, obhon Lamẹk. ");
INSERT INTO mfo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Mada okk'Lamẹk obhona, wa Mẹtusẹla obiro oruk cho ẹnọhna obhiri arọbh chi obhiri azenanttaan obhiri afa, obiro obhon ajinọng ọmaana panọng adọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Biphyir-phyir, wa Mẹtusẹla orukhi cho nnọhna mfa obhiri arọbh azenattaan obhiri ọhawani kwa jobh, yina on-ope. ");
INSERT INTO mfo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Mada Lamẹk okk'cho arọbh ọhawani obhiri afa orukha, obhon nnwa kw'ijinọng, ");
INSERT INTO mfo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ọkpẹ-ẹ Noa. Lamẹk on-oben bi, “Nnwa nwa ótzima ẹwọhngkwokha ochena man, k'ọtzọhm faman, ọmaana k'ihem saman, s'ifon k'irerek s'Ọvaar Ibinọkpaabyi ọkk'ẹmma ọnanga.” ");
INSERT INTO mfo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Mada Lamẹk okk'Noa obhona, wa obiro oruk cho ẹnọhna obhiri arọbh ọhawani obhiri chi, obiro obhon ajinọng ọmaana panọng adọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Biphyir-phyir, wa Lamẹk orukhi cho ẹnọhna obhiri arọbh chi obhiri attaan obhiri chi obhiri afa, yina on-ope. ");
INSERT INTO mfo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Mada Noa okk'cho ẹnọhna obhiri arọbh azen ọda, obhon va p'ijinọng attaan, p'ade Shẹm, ọmaana Ham, ọmaana Japhẹt. ");
INSERT INTO mfo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Iwa anọngẹya attẹwọr ahaabh m'ọyagbin, bẹ abira amaan va p'ipanọng anang bẹ, ");
INSERT INTO mfo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","va p'Ibinọkpaabyi are bi, va mba p'ipanọng p'anọngẹya ajibh-ojibh. Mẹ wọ osi, bẹ an-atzekha ayok bani, atzọkha bẹ macha panọng pabẹ. ");
INSERT INTO mfo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Mẹ wọ osi, Ọvaar Ibinọkpaabyi oben bi, “Egwugwuma chaam ch'esi anọng aruk akpen, ttara ọnọngẹya dọk kewobha matzẹmaa ikhina ogbe ode, okhuri bi, ọnọngẹya ode ọkpakpa. Ttẹwọr madeden, anọngẹya akpen dọk káruk ayongi cho arọbh azadani.” ");
INSERT INTO mfo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","K'ogbe nwuma, ttara kw'oyongi mẹ, wa aNẹphilim awobh m'ọyagbin, mada va p'Ibinọkpaabyi ayim aminava p'anọngẹya abẹ, aminava mba atzima ọbhọr, amaan bẹ va. Va mba bọ iwa ade afa-nọng, bẹ abira ade ajinọng p'atza che. ");
INSERT INTO mfo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ọvaar Ibinọkpaabyi ore bi, itzama s'anọngẹya ikk'ibara kpọng-kpọng m'ọyagbin, ttara bi, achibhi p'anọngẹya biphyir an-ade epyibha, k'ogbe kpenamkpen. ");
INSERT INTO mfo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Wa Ibinọkpaabyi for sẹ isẹ-ẹ nkwo, ettem ebire ẹmmẹ-ẹ, k'anọngẹya p'ọkk'ọsa m'ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Mẹ wọ osi, on-oben for sẹ bi, “Kaam ńdimi anọngẹya biphyir pa nkk'nsa, manda wani m'ọyagbin kórik. Kaam mbiri ńdimi nden biphyir, ọmaana ọnọhn f'ẹrọng biphyir, ọmaana ekpo py'ereng k'irerek biphyir. For saam isi-m nkwo bi, kaam nkk'pyẹ nyokha.” ");
INSERT INTO mfo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Yina, iwa Noa ọtzọk ọphyaam k'itzitzikha s'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ma wọ ode odem kw'okhuri Noa. Wa Noa ode ọnọng kw'otzor-otzor, oponga-pyibha kobiro ọkhaama mach'anọng p'ogbe kwẹ. Kẹ wa ọtzọni Ibinọkpaabyi abẹ. ");
INSERT INTO mfo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Wa Noa obhoni ajinọng attaan p'ade Shẹm, ọmaana Ham ttara Japhẹt. ");
INSERT INTO mfo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Wa Ibinọkpaabyi on-ore bi, ọyagbin okk'okhibhi, obiro ore bi, ọyagbin on-ofu ttara ọgbaan. ");
INSERT INTO mfo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ibinọkpaabyi ore odem kw'ọyagbin okk'okhibhi opyiri, da anọngẹya biphyir k'ọyagbin akk'akpen pa bẹ akhibhi. ");
INSERT INTO mfo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Mẹ wọ osi, Ibinọkpaabyi oben Noa bi, “Kaam nkk'ochibhi nsa bi, ńdimi anọngẹya biphyir, da ọyagbin on-ofu ttara ọgbaan, okhuri ọnọngẹya. Kker e, kaam ńdimi anọngẹya odimi biphyir ttara ọyagbin nwa. ");
INSERT INTO mfo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kọ Noa, tzima agbaakhakpa p'echi ch'ẹgaang-ọgaangi, amun ọkpaar kw'ideden anang for sọ. Si mmanggọ k'ọkpaar nwa ẹtzaanga, atzima ẹbaanttim akpa aphaangi pẹ k'iyaan, ọmaana k'ẹtzaanga, ifha asi aningi k'ọkpaar ẹtzaanga adimi. ");
INSERT INTO mfo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Manda wọ kw'arenga amun ọkpaar nwa. Adum pẹ áde ndọkhi ẹnọhna obhiri arọbh afa obhiri jobh, ẹ̀kpá chẹ éde ndọkhi arọbh attaan obhiri chi, ebe chẹ éde ndọkhi arọbh afa obhiri nzen. ");
INSERT INTO mfo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Si ittakhọhnga abubh-ẹ, ttẹwọr k'amma-kpabem pyiri k'ittakhọhnga, ahok ọphaangi kw'óde ẹtzọkhi k'obungi ọmaana igbokha makhọra. Si ọmma k'ẹbhabhaanga ch'okhubha wani kw'ọkpaar nwa, asi nyọng nttaan, dani k'irekh-irek, dani m'ottem, ndongo k'ẹrọng. ");
INSERT INTO mfo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Kaam ńdọhm asi p'áchi ọttọhk kpenamkpen m'ọyagbin, ọttọhk kpenamkpen f'orukhi akpen. Ọttọhk kpenamkpen m'ọyagbin óbiro ópope. ");
INSERT INTO mfo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Onode kọ, kaam ńsi echekhi chaam nnang kọ ọmaana va pọ, ttara kwanọng kwọ, ọmaana panọng pa va pọ, bọng biphyir adim k'ọkpaar nwa ẹtzaanga. ");
INSERT INTO mfo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Kọ átzọkha adem afa-afa p'ọttọhk kpenamkpen f'orukhi akpen, ojinọng ọmaana kwanọng, adim k'ọkpaar nwa ẹtzaanga, ifha pyẹ eruk akpen ttara kọ k'ọkpaar. ");
INSERT INTO mfo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Adem afa-afa p'ọnọhn kpenamkpen, ọmaana pa nden kpenamkpen, ttara p'ọttọhk kpenamkpen f'oreng k'irerek, ékwu ifha ahok pyẹ akpen. ");
INSERT INTO mfo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Kọ tzobha ọttọhk kpenamkpen f'ode ọchattọhk ọnang bọng, f'obiro ode ọchattọhk ọnang nden nnonggo biphyir, aye k'ọkpaar.” ");
INSERT INTO mfo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noa osi odik kpenamkpen mach'Ibinọkpaabyi ọtzọhn-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Mẹ wọ osi, Ọvaar Ibinọkpaabyi oben Noa bi, “Kọ tzima ẹhọhmmọr chọ adim k'ọkpaar, okhuri bi, kaam nkk'nna bi, kọ wọ ade ọnọng kw'otzor-otzor m'ọgbọ nwa e. ");
INSERT INTO mfo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","K'ottem kwa nden sa mbaan bi, anọng atzima afọhni ẹja, k'adem kpenamkpen pabẹ, tọkha mfa-mfa, k'obe ozenamfa, odim ọmaana kwa, ayikha k'ọkpaar nwa. Onode nden sa nni k'ẹjafọhni mbaan, k'adem kpenamkpen pabẹ, tọkha odim ọmaana kwa, ");
INSERT INTO mfo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","abira atzọkha ọnọhn ozenamfa-ozenamfa, k'adem kpenamkpen pabẹ, odim ọmaana kwa, ifha fẹ oruk akpen obiro ohok adem pabẹ m'ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","K'iwu izenamfa k'itzitzikha, kaam ńsi ẹrọng etzebh m'ọyagbin, k'iwu arọbh afa ọmaana ka nnungiwu arọbh afa, ńdima chẹ ńdimi ekpo kpenamkpen pya nkk'nsa, py'erukhi akpen m'ọyagbin.” ");
INSERT INTO mfo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Iwa Noa osi odik kpenamkpen kw'Ọvaar Ibinọkpaabyi ọtzọhn-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Wa Noa ode ojinọng kw'ode cho ẹnọhna obhiri arọbh jobh, mada asi anwa achi ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Wa Noa otzima va pẹ ttara kwanọng kwẹ ọmaana panọng pa va pẹ, bẹ adim k'ọkpaar nwa, ifha bẹ arọbh anaanga asi p'anwa. ");
INSERT INTO mfo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Nden mfa-mfa sa mbaan k'ẹjafọhni, ọmaana sa nni k'ẹjafọhni mbaan, ọmaana ọnọhn, ttara ekpo biphyir py'ereng k'irerek, ");
INSERT INTO mfo_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","odim ọmaana kwa, nnenga nkhebha Noa, mbiri ndim k'ọkpaar nwa, mach'Ibinọkpaabyi okk'Noa ọtzọhna. ");
INSERT INTO mfo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Mada iwu nnuma izenamfa ikk'ikwọbha, asi anwa achi ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","K'ogbe kw'iwa Noa okk'akpen orukha opyiri cho ẹnọhna obhiri arọbh jobh, k'iwu chi obhiri ifa s'ophe kw'ottong afa, m'ewu nduma akhekhaho amaam asi haabhada k'irerek, bẹ abira akwunga amma p'asi p'ọrọngkpakpa. ");
INSERT INTO mfo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Wa ẹrọng etzebh m'ọyagbin k'iwu arọbh afa ọmaana ka nnungiwu arọbh afa. ");
INSERT INTO mfo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","M'ewu nduma dani, Noa ọmaana va pẹ p'ade Shẹm, ọmaana Ham, ọmaana Japhẹt ttara kwanọng kwa Noa ọmaana panọng pa va pẹ, adim k'ọkpaar nwa. ");
INSERT INTO mfo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Wa bẹ awobh k'ọkpaar nwa ttara nden s'ẹtzam biphyir, atzor k'adem pabẹ, ọmaana nden s'otzer biphyir, atzor k'adem pabẹ, ọttọhk kpenamkpen f'oreng k'irerek, otzor k'odem kwẹ, ọmaana ọnọhn biphyir atzor k'adem pabẹ, ttara ọttọhk kpenamkpen f'ọkhaam mbabaang. ");
INSERT INTO mfo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ekpo ẹfa-ẹfa biphyir py'erukhi akpen, ẹtza ekhebha Noa, edim k'ọkpaar nwa. ");
INSERT INTO mfo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Wa nden sa mmindim k'ọkpaar nwa nde odim ọmaana kwa, f'ọttọhk kpenamkpen f'orukhi akpen, atzor mach'Ibinọkpaabyi okk'Noa ọtzọhna. Mẹ wọ e, Ọvaar Ibinọpkaabyi obhen ọmma okpori Noa k'ẹtzaanga. ");
INSERT INTO mfo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Asi achina ororo achi ọyagbin k'iwu arọbh afa, asi achina ororo anwa maa bẹ ayebh ọkpaar nwa anana k'asi ebir-ebir. ");
INSERT INTO mfo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Asi anwa k'ọhaabh, bẹ achina ororo afu k'ọyagbin bi pyẹrrr, ọkpaar on-obiro obhobh k'asi ebir-ebir. ");
INSERT INTO mfo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Asi anwa maa bẹ abhọri mgbegbeho si ngor-ogori biphyir m'ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Asi anwa abhọri mgbegbeho maa ododong kw'asi ọyọhnga ndọkhi ẹrọbh. ");
INSERT INTO mfo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ọttọhk kpenamkpen f'oreng m'irerek ope, ọnọhn, ọmaana nden s'otzer, ọmaana nden s'ẹtzam ọmaana ekpo biphyir py'efu m'ọyagbin, ttara anọngẹya biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ọttọhk kpenamkpen k'ogbin f'oji ọwọhng kw'akpen k'ahungmma, ope. ");
INSERT INTO mfo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Mando kw'Ibinọkpaabyi odimi ekpo kpenamkpen py'erukhi akpen k'ọyagbin, anọngẹya ọmaana nden, ọmaana ekpo py'ereng k'irerek, ttara ọnọhn f'ẹrọng odimi pyẹ biphyir. Wa on-orik Noa ttara ọttọhk kpenamkpen f'owobh k'ọkpaar nwa ttar-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Wa asi anwa achi ọyagbin k'iwu arọbh azenamfa obhiri jobh. ");
INSERT INTO mfo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","M'ogbe nwuma kw'iwa asi akk'oyagbin acha, wa Ibinọkpaabyi Noa kọraam. Wa nden biphyir s'otzer ọmaana s'ẹtzam sa nwobh k'ọkpaar ẹtzaanga ttara Noa, kobiro ọraama. Ọn-ọtzọhm ọphapha ogwuma k'ọyagbin, kw'osi asi awọhri. ");
INSERT INTO mfo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Akhekhaho p'irerek akka, bẹ akk'amma p'asi p'ọrọngkpakpa abira akpa, ẹrọng ẹkk'ẹkwọbha otze-tzebh k'ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Asi achina ororo awọhri k'ọyagbin. Okwu ottonga iwu arọbh azenamfa obhiri jobh, asi akk'an-awọhri. ");
INSERT INTO mfo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ottong iwu chi obhiri ifa, s'aphe azenamfa, ọkpaar ọtza ottima ka mgbegbeho s'Ararat. ");
INSERT INTO mfo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Asi achina ororo awọhri maa opyiri echedenwu ch'aphe jobh, mgbegbeho ngọhkha. ");
INSERT INTO mfo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Mada iwu arọbha afa ikk'ikwọbha, Noa okwunga ọphapha-mma kw'ọkpaar kw'ọkk'ọsa. ");
INSERT INTO mfo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ọtzọhm ẹtzọrikhukhu, ch'ekhuri echina ororo ẹkpa nnam, matzẹmaa opyiri k'ogbe kw'asi akk'akka k'ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Obiro ọtzọhm igbegbaa, ifha oronga idikha asi akk'akka k'irerek. ");
INSERT INTO mfo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Yina, wa igbegbaa ibe s'ibe mmo kire, okhuri da asi atzima awobh k'irerek. Sẹ ikhuna itzor Noa k'ọkpaar. Noa onemi ọbọhk ọbọkha sẹ, okhe k'ọkpaar. ");
INSERT INTO mfo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noa owobha iwu izenamfa ọdọdọk, obiro ọtzọhm igbegbaa nnuma iyin k'ọkpaar. ");
INSERT INTO mfo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Mada igbegbaa ikhun itzor-ẹ k'ẹchọhkha, itzima ikwongitzọhng s'oliv s'idẹkh-ọdẹkhi k'ẹmma. Mẹ wọ, Noa oronga bi, asi akk'awọhri k'ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Owobha iwu izenamfa idọdọk, obiro ọtzọhm igbegbaa. Yina, m'ogbe nwa sẹ kikhun. ");
INSERT INTO mfo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","K'echedenwu ch'ophe kw'ocheden, ch'esi Noa cho ẹnọhna obhiri arọbh jobh obhiri wani, asi akk'akka k'ọyagbin. Noa ogbe ẹpaho ch'ọkpaar, okkeri, ore bi, irerek ikk'ittẹwọr igwu. ");
INSERT INTO mfo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","K'iwu ẹrọbh obhiri izenamfa s'ophe kw'ottong afa, irerek ikk'in-igwa biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Mẹ wọ osi, Ibinọkpaabyi on-oben Noa bi, ");
INSERT INTO mfo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Tzima kwanọng kwọ, ọmaana va pọ, ọmaana panọng pa va pọ, bọng ayin k'iyaan. ");
INSERT INTO mfo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kọ biri tzima ọttọhk kpenamkpen f'orukhi akpen k'adem-k'adem, f'owobh ttar-ọ, ọnọhn, ọmaana nden ttara ekpo py'ereng k'irerek, ifha py'ẹhaabh k'irerek, py'ebire ẹ́maan ayok, ébire ẹ́haabh-ọhaabh k'obhik.” ");
INSERT INTO mfo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Mẹ wọ, Noa oyin k'iyaan ọmaana va pẹ p'ijinọng, ọmaana kwanọng kwẹ, ttara panọng pa va pẹ. ");
INSERT INTO mfo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nden biphyir, ọmaana ekpo biphyir py'ereng k'irerek, ọmaana ọnọhn biphyir, ttara ọttọhk kpenamkpen f'oreng k'irerek oyin k'ọkpaar nwa, k'adem pabẹ. ");
INSERT INTO mfo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Mẹ wọ osi, Noa osi ijafọhnibe ọnang Ọvaar Ibinọkpaabyi, ọtzọkha etzen dani-dani k'adem pa nden sa mbaan k'ẹjafọhni, ọmaana ọnọhn f'ọbaan k'ẹjafọhni, otzima osi ẹjafọhni ch'ẹnanga ẹkwọmichẹ m'ijafọhnibe nna. ");
INSERT INTO mfo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ọvaar Ibinọkpaabyi ọbhaang eruk damandaam ch'ẹja nda, on-oben k'ettem chẹ bi, “Kaam ikhina ọyagbin ẹmma dọk kińnang, okhuri ọnọngẹya, kaambi ode bi, ettem ch'ọnọngẹya en-efu ttara itzama ttẹwọr k'ẹvava. Yina rang ọdọk kwa kaam ndimi ekpo py'erukhi akpen biphyir, macha ndimi m'ogbe nwa. ");
INSERT INTO mfo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ttẹwọr madẹdẹn maa apyiri k'okpong kw'ọyagbin, ogbe kw'ekpo ọyayaabha, ọmaana ogbe kw'ipha, ogbe kw'etzetzebhi ttara iyoma, ogbe kw'ẹya ttara erungi, idik nna biphyir okpong kíkhaama, íchina ororo matzẹmaa ogbe ode.” ");
INSERT INTO mfo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Mẹ wọ osi, Ibinọkpaabyi odo Noa ttara va pẹ, oben bẹ bi, “Bọng mon va, tte va pabọng ahaabh-ọhaabh, abira anyaami, aruk k'ibe kpenamkpen m'ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nden s'ẹtzam biphyir, ọmaana ọnọhn f'okhuri k'ẹrọng, ttara ekpo py'ereng k'irerek biphyir, ọmaana nden s'asi biphyir, pyẹ biphyir éruk ẹkhaama ojora fabọng. Kaam nhokhi pyẹ biphyir k'irekh-irek kwọ bi, akkeri. ");
INSERT INTO mfo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ọttọhk kpenamkpen f'orukhi akpen obiro oreng-orenga óde ọchattọhk ọnang bọng. Mach'iwa nnangi bọng araraari, nna mbiri nnang bọng ọttọhk kpenamkpen mach'ọchattọhk. ");
INSERT INTO mfo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Yina, ọkhaam ọttọhk f'án-achi. Kọ etzen ch'etzim ẹkhaam izi kachi, okhuri bi, izi rọ ide akpen. ");
INSERT INTO mfo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Idikha ọnọng ofhu oyok ọnọngẹya, kaam ńnor akpen p'oyok mbọbh-ẹ. Etzen ch'efhu ọnọngẹya, ńnang chẹ ettuma. Ọnọng kw'ofhu oyok, ńnang-ẹ ettuma ch'ẹbaan-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ọnọng kpenamkpen kw'ofhu oyok ọnọngẹya, mando wọ kw'ọnọng óbiro ófhu kẹ, okhuri bi, kẹ Ibinọkpaabyi osi ọnọngẹya ka ngera sẹ. ");
INSERT INTO mfo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Bọng mon va, tte va pabọng ahaabh-ọhaabh, anyaami aruk k'ibe kpenamkpen m'ọyagbin.” ");
INSERT INTO mfo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Mẹ wọ osi, Ibinọkpaabyi oben Noa ọmaana va pẹ bi, ");
INSERT INTO mfo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Kker e, kaam nsi echekhi nnang bọng, ttara va pa va pabọng. ");
INSERT INTO mfo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Echekhi nda ewobh ẹnang ọttọhk kpenamkpen f'orukhi akpen, ọmaana ọnọhn, ọmaana nden s'otzer, ttara nden s'ẹtzam, nnuma biphyir sa nyini k'ọkpaar ttara bọng, sa nnukhi akpen m'ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Kaam nsi echekhi nnang bọng bi, ogbe dọk kóde kw'asi an-abira achi ekpo py'erukhi akpen biphyir, ogbe dọk kóde kw'asi abira akhibhi ọyagbin.” ");
INSERT INTO mfo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ibinọkpaabyi obiro oben bi, “Ma wọ ode ẹkhọhkha ch'Echekhi chaam, cha mmingaama ttara bọng ọmaana ekpo py'erukhi akpen biphyir, echekhi nda éwobha ẹnang igbọ s'ikwu k'ogbe ororo. ");
INSERT INTO mfo_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Kaam nkk'esididibha chaam nhokha k'eboni, ch'éde ẹkhọhkha ch'Echekhi cha kaam ngaam ttara bọng, ọmaana ọyagbin biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ogbe kwa ndọhmi eboni k'ọyagbin, esididibha eyini, ");
INSERT INTO mfo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","kaam ńjima echekhi chaam, ttara bọng ọmaana odem kpenamkpen kw'ekpo biphyir py'erukhi akpen. Ogbe dọk kode kw'asi ánwa adimi ekpo biphyir py'erukhi akpen. ");
INSERT INTO mfo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Mẹ wọ osi, ogbe kpenamkpen kw'esididibha eyini k'eboni, ńne chẹ, mbiri ńjima echekhi nduma ch'Ibinọkpaabyi ọkhaam ọmaana ekpo biphyir py'erukhi akpen m'ọyagbin, k'adem-k'adem, py'ewobha m'ọyagbin maa ipemanitzor.” ");
INSERT INTO mfo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Mẹ wọ osi, Ibinọkpaabyi oben Noa bi, “Esididibha dọ ede ẹkhọhkha ch'Echekhi cha kaam nsi nnang ẹkpo kpenamkpen py'erukhi akpen k'ọyagbin.” ");
INSERT INTO mfo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Iwa va p'ijinọng pa Noa p'ayini k'ọkpaar nwa ade; Shẹm, ọmaana Ham, ttara Japhẹt. Ham wọ iwa ode otte kwa Kenaan. ");
INSERT INTO mfo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Iwa ofon ma va mba attaan pa Noa, ọmaana va pabẹ, anọngẹya anyaami afhu ọyagbin bi pyẹrrr. ");
INSERT INTO mfo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Wa Noa ode ọnọng kw'ọyaabh owoni. Kẹ wọ iwa ode ocheden-nọng kw'ọttẹwọr ogbon nchi si mminwọm aduk p'agrep. Nchi nna s'agrep mminwọm aduk pa bẹ am-atzima asi atzuk. ");
INSERT INTO mfo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","K'ogbe wani, wa Noa ogwo atzuk p'achiduk mbuma matzẹmaa obumma, oyima irinikhum k'ikhira sẹ. ");
INSERT INTO mfo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Mẹ wọ, Ham otte kwa Kenaan, ore irinikhum s'otte, ọtza ọgbaak abagbaanọkka k'iyaan. ");
INSERT INTO mfo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Mẹ wọ osi, Shẹm ọmaana Japhẹt atzọkha ibara s'ideden anana ka mbabaang sabẹ, bẹ arenga nnama-nnam, akpa nnam abọra otte, abubh-ẹ irinikhum, ifha bẹ aningi irinikhum s'otte are. ");
INSERT INTO mfo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Mada Noa ọn-ọphyọbh, da atzuk akk'ẹ attoni, oronga odik kwa Ham, kw'ode nnwa kwẹ kw'ikhakhari ọkk'ọsa, ọnang-ẹ ẹmma oben bi, ");
INSERT INTO mfo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","“Ẹmma ẹbọkha Kenaan! Kẹ óde obira kw'owobha k'irekh-irek kw'abira pa vọkka pẹ biphyir.” ");
INSERT INTO mfo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Wa obiro oben bi, “Tte ẹtzọhnga ewobha ẹnang Ọvaar Ibinọkpaabyi kwa Shẹm okpobh, tte Kenaan obiro ode obira kwa Shẹm. ");
INSERT INTO mfo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Tte Ibinọkpaabyi ọmmẹma nnem sa Japhẹt, tte Japhẹt oruk k'okhira fa Shẹm, tte Kenaan ode obira kwa Japhẹt.” ");
INSERT INTO mfo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Mada asi p'achi ọyagbin akk'akka biphyir, Noa obiro oruk cho arọbh-chi-obhiri-afa obhiri jobh. ");
INSERT INTO mfo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Mẹ wọ oyini bi, biphyir-phyir, wa Noa orukhi cho nnọhna mfa obhiri arọbh azenamfa obhiri jobh. ");
INSERT INTO mfo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ma wọ ode odem kw'efonamma cha Noa ch'ede Shẹm, ọmaana Ham, ttara Japhẹt. Wa va mba akk'abhakhi abhon ayok, k'ogbe kw'iwa asi p'achi ọyagbin akk'akka. ");
INSERT INTO mfo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Va pa Japhẹt p'ijinọng wa bẹ ade: Goma, ọmaana Magọg, ọmaana Madai, ọmaana Javan, ọmaana Tubal, ọmaana Mẹshẹk, ttara Tiras. ");
INSERT INTO mfo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Wa va p'ijinọng pa Goma ade: Askenaz, ọmaana Riphat, ttara Togama. ");
INSERT INTO mfo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Va p'ijinọng pa Javan ade: Elisha, ọmaana Tarshish, ọmaana Kitim, ttara Dodanim. ");
INSERT INTO mfo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Wa va pa va p'anọng mba, bọ iwa arukhi k'araanga akhaan-ọkhaan, an-abhaangi aruk k'orerek fabẹ, ka mfonamma sabẹ, ọmaana k'ibhon k'ibhon, anọng-ọnọng agbaak ebhon chabẹ. Ma wọ iwa ode ẹnọmma cha Japhẹt. ");
INSERT INTO mfo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Va pa Ham p'ijinọng bẹ ade: Kush, ọmaana Ijip, ọmaana Put, ttara Kenaan. ");
INSERT INTO mfo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kush ọn-ọbhakhi obhon: Seba, ọmaana Havila, ọmaana Sabata, ọmaana Rama, ttara Sabateka. Wa va pa Rama ade: Sheba, ọmaana Dedan. ");
INSERT INTO mfo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kush wọ iwa obiro ode otte kwa Nimrọd, kw'iwa ode okkenggitza kw'ideden k'ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nimrọd wa ode ọgbaajijaa kw'ideden k'itzitzikha s'Ọvaar Ibinọkpaabyi. Kwẹ kwọ osi bẹ am-aben bi, “Macha Nimrọd, kw'ode ogbaajijaa kw'ideden kw'Ibinọkpaabyi ọkk'ọwọbh ọnanga.” ");
INSERT INTO mfo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ichedenmon s'iwa kẹ ọdabhi ẹvaar ide ibhon sa Babẹl, ọmaana Ẹrẹk, ọmaana Akad, ttara Kalnẹ. Ibhon nna biphyir wa s'iwobh k'okhubha kwa Shina. ");
INSERT INTO mfo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ma kw'iwa on-obin ochina k'okhubha kw'Asiriya, otza osi ibhon sa Ninevẹ, ọmaana Rehobot-Ir, ọmaana Kala, ");
INSERT INTO mfo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ọmaana Resen, kw'owobh k'ottem kwa Ninevẹ, ttara odedenmon kwa Kala. ");
INSERT INTO mfo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Wa Ijip ọbhakhi obhon abaLud, ọmaana abAnam, ttara abaLehab, ọmaana abaNaphatu, ");
INSERT INTO mfo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ọmaana abaPatarus, ọmaana abaKasalu, ttara abaKaphatọr. AbaKasalu bọ iwa an-abira abhakhi abhon ẹkhọma cha Philistiya. ");
INSERT INTO mfo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenaan, kẹ wa ocheden obhon Sidọn, obiro obhon abaHet. ");
INSERT INTO mfo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Wa ngọma sa mfon ka Kenaan nde: abaJẹbus, ọmaana abAmọr, ọmaana abaGirgash, ");
INSERT INTO mfo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ọmaana abaHiv ọmaana Ak, ọmaana abaSin, ");
INSERT INTO mfo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ọmaana abAvad, ọmaana abaZẹma, ttara abaHamat. Wa nnọmma nna biphyir sẹ mfon ka Kenaan, nnyaami ");
INSERT INTO mfo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Wa ẹkhọma cha Kenaan etzim maa epyiri Sidọn, ebir etzima ka Gẹra maa etzuma ka Gaza, ebir etzima echina ka Sodom, ọmaana Gomora, ọmaana Adama, ọmaana Zeboyim, maa apyiri ka Lasha. ");
INSERT INTO mfo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ma wọ iwa ode ẹnọmma cha Ham, ka mfonamma sabẹ, ọmaana ka mmon sabẹ, ọmaana k'orerek fabẹ ttara k'ibhon sabẹ. ");
INSERT INTO mfo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shẹm, kw'iwa Japhẹt otzori nnam, wa obhoni Ẹbẹr, ttara va p'Ẹbẹr obhoni biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Wa Shẹm obiro obhon va adọdọk p'ade: Ẹlam, ọmaana Ashur, ọmaana Arphaksad, ọmaana Lud, ttara Aram. ");
INSERT INTO mfo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Wa va p'Aram ọbhakhi obhon ade Uz, ọmaana Hul, ọmaana Gẹta, ttara Mash. ");
INSERT INTO mfo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arphaksad obhon Shẹla, kw'obiro ọbhakhi obhon Ẹbẹr. ");
INSERT INTO mfo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ẹbẹr, wa obhoni va p'ijinọng afa: Ocheden okpen Pẹlẹg, kw'oyini, ẹbhaangi. K'ogbe kwẹ wọ kw'iwa anọng abhaangi k'ọyagbin, bẹ anyaami aruk k'ibe kpenamkpen; ọgbaanọkka kwa Pẹlẹg okpena Jọktan. ");
INSERT INTO mfo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Jọktan wa obhoni Almodad, ọmaana Shẹlẹph, ọmaana Hazamavẹt, ọmaana Jẹra, ");
INSERT INTO mfo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ọmaana Hadoram, ọmaana Uzal, ọmaana Dikala, ");
INSERT INTO mfo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ọmaana Ọbal, ọmaana Abimayẹl, ọmaana Sheba, ");
INSERT INTO mfo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ọmaana Ophir, ọmaana Havila, ttara Jobab. Anọng mba biphyir wa bẹ ade va pa Jọktan. ");
INSERT INTO mfo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Wa ẹkhọma ch'anọng mba arukhi ẹttẹwọr ka Mẹsha maa achina ka Sẹphar, ka mgbegbeho sa nwobh k'okhubha kw'ewuchen em-eyin. ");
INSERT INTO mfo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ma wọ iwa ode ẹnọmma cha Shẹm ka mfonamma sabẹ, ọmaana ka mmon sabẹ, ọmaana k'orerek fabẹ, ttara k'ibhon sabẹ. ");
INSERT INTO mfo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ma wọ iwa ode mfonamma sa va pa Noa, atzor ka va pa va k'idibhon sabẹ. Wa ofon k'anọng mba, idibhon s'ọyagbin biphyir in-inyaami, k'ogbe kw'asi p'iwa achi ọyagbin akk'akka. ");
INSERT INTO mfo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Iwa anọng m'ọyagbin biphyir akhaam ebhon dani, bẹ am-abira agbaak odik wani. ");
INSERT INTO mfo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Mada anọng areng achina k'okhubha kw'ewuchen em-eyin, bẹ akwu are ẹttẹri dani k'okhubha kwa Shina, bẹ atzima mẹ asi oruk kwabẹ. ");
INSERT INTO mfo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Mẹ wọ ofon, bẹ an-aben ayok bi, “Bọng kwu ifha mọbanga idọdọhbh k'apyi, mọyaan sẹ maa, sẹ igwu igaangi bi kpọkhọdọ.” Mẹ wọ ofon, bẹ abanga adọdọhbh-pyi atzima atzera atza p'ihọhm, bẹ atzima ana p'abang-ọbanga abira pyi bi kaang, atzima atzera idọdọhbh idukhasẹ. ");
INSERT INTO mfo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Mẹ wọ osi, bẹ aben bi, “Bọng kwu mosi odedenmon ttara ẹnyọhng ch'egori bi kotoong maa, epyiri k'ọrọngkpakpa, ifha mosi che ọnang for sa man. Oni mando ode, mọraam-ọraami m'ọyagbin.” ");
INSERT INTO mfo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Mẹ wọ ofon, Ọvaar Ibinọkpaabyi ọhakha okwu ore obhon nwa, ọmaana ẹnyọhng gorang-gor cha va p'anọngẹya am-asi. ");
INSERT INTO mfo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ọvaar Ibinọkpaabyi, oben bi, “Ojemi da bẹ atzima ade anọng p'ẹkhọma dani, p'agbaakhi ebhon dani, bẹ attẹwọr afha asi ọttọhk-dema mva, kw'oyini bi, ọttọhk fa bẹ ákham bi bẹ asi, fa bẹ án-afha asi kóde. ");
INSERT INTO mfo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Bọng kwu mọhakha, mọtza ọdama ebhon chabẹ, ifha bẹ aningi ayok dọk abhaang.” ");
INSERT INTO mfo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Mẹ wọ osi, Ọvaar Ibinọkpaabyi osi anọng mba araami k'ibe kpenamkpen m'ọyagbin, obiro ọkwọbha bẹ odedenmon nwuma osisi. ");
INSERT INTO mfo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Kwẹ kwọ osi bẹ ayeri ibe nnuma Babẹl, okhuri bi, m'ibe nna rọ s'iwa Ọvaar Ibinọkpaabyi ọdam ebhon ch'ọyagbin biphyir. Ttẹwọr mẹ wọ kw'Ọvaar Ibinọkpaabyi opfuri bẹ, bẹ araami makhọra ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ma wọ ode ẹnọmma cha Shẹm. Wa cho afa akk'akwọbha kw'asi achi ọyagbin, k'ogbe kwa Shẹm on-ode cho arọbh azen, mẹ kw'obhoni Arphaksad. ");
INSERT INTO mfo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Mada okk'Arphaksad obhona, wa Shẹm obiro oruk cho ẹnọhna obhiri arọbh azen, obiro obhon ajinọng ọmaana panọng adọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Mada Arphaksad okk'cho ẹrọbh obhiri chi orukha, obhon Shẹla. ");
INSERT INTO mfo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Mada okk'Shẹla obhona, wa Arphaksad obiro oruk cho ẹnọhna obhiri attaan, obiro obhon ajinọng ọmaana panọng adọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Mada Shẹla okk'cho ẹrọbh obhiri jobh orukha, wa obhon Ẹbẹr. ");
INSERT INTO mfo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Mada okk'Ẹbẹr obhona, wa Shẹla obiro oruk cho ẹnọhna obhiri attaan, obiro obhon ajinọng ọmaana panọng adọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Mada Ẹbẹr okk'cho ẹrọbh obhiri ọhawani-kwa-chi orukha, obhon Pẹlẹg. ");
INSERT INTO mfo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Mada okk'Pẹlẹg obhona, wa Ẹbẹr obiro oruk cho ẹnọhna obhiri ẹrọbh obhiri jobh, obiro obhon ajinọng ọmaana panọng adọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Mada Pẹlẹg okk'cho ẹrọbh obhiri jobh orukha, obhon Rewu. ");
INSERT INTO mfo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Mada okk'Rewu obhona, wa Pẹlẹg obiro oruk cho arọbh jobh obhiri ọhawani, obiro obhon ajinọng ọmaana panọng adọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Mada Rewu okk'cho ẹrọbh obhiri jobh obhiri afa orukha, obhon Serug. ");
INSERT INTO mfo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Mada okk'Serug obhona, wa Rewu obiro oruk cho arọbh jobh obhiri azenamfa, obiro obhon ajinọng ọmaana panọng adọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Mada Serug okk'cho ẹrọbh obhiri jobh orukha, obhon Nahọr. ");
INSERT INTO mfo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Mada okk'Nahọr obhona, wa Serug obiro oruk cho arọbh jobh, obiro obhon ajinọng ọmaana panọng adọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Mada Nahọr okk'cho ẹrọbh obhiri ọhawani orukha, obhon Tẹra. ");
INSERT INTO mfo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Mada okk'Tẹra obhona, wa Nahọr obiro oruk cho arọbh azen obhiri ọhawani-kw'ẹrọbh, obiro obhon ajinọng ọmaana panọng adọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Mada Tẹra okk'cho arọbh attaan obhiri jobh orukha, obhon Abram, ọmaana Nahọr ttara Haran. ");
INSERT INTO mfo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ma wọ ode ẹnọmma cha Tẹra. Tẹra obhoni Abram, ọmaana Nahọr ttara Haran. Haran obiro obhon Lọt. ");
INSERT INTO mfo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Wa Haran ocheden ope, oji otte. M'ogbe nwuma, wa bẹ awobh ka Ur k'okhubha kw'abaKaldi kw'ode obhon kw'iwa Haran ọmaan. ");
INSERT INTO mfo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Wa Abram ọmaana Nahọr an-abira atzọkha panọng. Kwanọng kw'Abram wa okpen Sarai. Yina, wa Nahọr ọtzọkha kwanọng kw'okpen Milka. Milka ọkhaam ọgbaanọkka kw'okpen Iska, Haran wọ iwa obhoni bẹ anọng afa. ");
INSERT INTO mfo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Yina, Sarai wa ode ojididima, wa kẹ nnwa kọmaani. ");
INSERT INTO mfo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Wa Tẹra ọtzọkha Abram kw'ode nnwa kwẹ, ọmaana Lọt kw'ode nnwa kwa Haran, ttara Sarai, kw'ode kwanọng kwa nnwa kwẹ Abram, bẹ biphyir abina orenga achina kw'okhubha kw'Ur kw'abaKaldi, ifha bẹ achina k'ẹkhọma cha Kenaan. Yina, mada bẹ areng maa aphyiri ka Haran, bẹ an-aruk mẹ. ");
INSERT INTO mfo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Wa Tẹra okwu ope ma Haran da ode cho arọbh jobh obhiri azen. ");
INSERT INTO mfo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Wa k'ogbe wani, Ọvaar Ibinọkpaabyi obeni Abram bi, “Bina ji ẹkhọma chọ, ọmaana anọng pọ, ttara ẹhọhmmọr ch'atte, achina k'ẹkhọma ch'akhaam ńdim-ọ nda. ");
INSERT INTO mfo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Kaam ńsọ-ọ ade otte kw'ẹkhọma ch'ideden. Kaam ńdọ-ọ, mbiri ńsọ-ọ atza che. Kaam ńnenga ka kọ ndo anọng haabhada. ");
INSERT INTO mfo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ọnọng kpenamkpen kw'ọdọ-ọ, kaam mbiri ńdẹ-ẹ. Ọnọng kpenamkpen kw'ọrọ-ọ ọkhara, kaam ndim-ẹ m'ebubuni. Ayagbin bi waam arenga ma kọ, atzọkha ẹdaa.” ");
INSERT INTO mfo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Mẹ wọ ofon, Abram obina ọttẹwọr orenga mach'Ọvaar Ibinọkpaabyi ọkk'ẹ obena, Lọt obiro ọtzọhn-ẹ abẹ. Wa Abram ode cho arọbh attaan obhiri chi, mada obin k'obhon kwa Haran. ");
INSERT INTO mfo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram otzima kwanọng kwẹ Sarai, ọmaana Lọt kw'ode nnwa kw'ọgbaanọkka, ọmaana ẹkhakhaama chabẹ biphyir, ttara anọng pa bẹ akk'akhaama ka Haran, bẹ abina orenga achina k'ẹkhọma cha Kenaan maa, bẹ apyiri kẹ. ");
INSERT INTO mfo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Wa abAbram arenga ma Kenaan maa, bẹ apyiri kẹ da echi ch'ideden cha Morẹ ebe, ka Shẹkẹm. M'ogbe nwuma wa anọng pa Kenaan atzima am-aruk m'ẹkhọma nduma. ");
INSERT INTO mfo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ọvaar Ibinọkpaabyi oyin oben Abram bi, “Ńtte ẹkhọma nda ọbọhk ńnang efonamma chọ.” Mẹ wọ, Abram osi ijafọhnibe mẹ, ọnang Ọvaar Ibinọkpaabyi, kw'ọkk'ẹ abẹ oyina. ");
INSERT INTO mfo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Mada Abram obin ka Shẹkẹm ochina ororo orenga maa opyiri ka mgbegbeho sa nwobh ka Bẹtẹl, osi ikhira sẹ mẹ, k'ottem kw'Ayi kẹ da ewuchen em-eyin ọmaana Bẹtẹl kẹ da ewuchen em-edimi. Mẹ kw'Abram osi ijafọhnibe ọnang Ọvaar Ibinọkpaabyi, om-obiro owobha mẹ okpobha Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Mẹ wọ, Abram obina orenga, ochina ororo okkeri itzitzikha k'okhubha kwa Nẹgẹv. ");
INSERT INTO mfo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","M'ogbe nwuma, wa okwo f'ideden owobh m'ẹkhọma nduma. Mẹ wọ, Abram obina, ochina k'Ijip ọtza oruk kẹ k'igbegbaa bi kọbh, okhuri okwo f'ideden. ");
INSERT INTO mfo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Mada bẹ an-akkekkeni apyiri k'Ijip, Abram oben kwanọng kwẹ bi, “Sarai, kaam nkk'nnonga bi, kọ ajibhi kwanọng. ");
INSERT INTO mfo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Idikha anọng p'Ijip arong bi, kọ ade kwanọng kwaam, mada bẹ áre ajibhada pọ, bẹ áfhu-m ofhu. Yina, bẹ átte kọ ọbọhk otte aruk. ");
INSERT INTO mfo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Kọ gbaak bi, ade ọgbaanọkka kwaam, ifha bẹ atzim-m k'eden-ọkka o, ifha ńwobha akpen okhuri kọ.” ");
INSERT INTO mfo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Mada Abram opyiri k'Ijip, anọng p'Ijip are bi, Sarai ode kwanọng kw'ojibh kpọng-kpọng. ");
INSERT INTO mfo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Mada akhaan-nọng pa Phero, abira are kwanọng nwa, bẹ atzọhnga ajibhada pẹ anang ọvaarnọng. Bẹ atzim-ẹ achina k'ẹvaar-ttọhmma. ");
INSERT INTO mfo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Wa Phero oreng ka nnam sa Sarai, ojibh idik otzima otzor Abram. Mẹ wọ osi, ọnang Abram nnanga sa nhaabh-ọkhaabh mach'arukhimaan, ọmaana abhaam, ọmaana anyanyaang-dim, ọmaana anyanyaang-papẹ, ttara abira p'ijinọng, ọmaana p'ipanọng, ọmaana akamẹl. ");
INSERT INTO mfo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mẹ wọ osi, Ọvaar Ibinọkpaabyi osi ikhọhmana s'ideden idim k'ẹhọhmmọr cha Phero, ibọkha kẹ ọmaana anọng p'ẹhọhmmọr chẹ biphyir, okhuri Sarai kw'ode kwanọng kw'Abram. ");
INSERT INTO mfo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Mando kwa Phero ọtzọhmi bẹ ayeri Abram, ọbọbh-ẹ bi, “Bọng odik kw'asi ma? Osi yan kw'asi-m k'ọgbaan? Osi yan kaam kagbaakhi bi, Sarai ode kwanọng kwọ? ");
INSERT INTO mfo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Areng mbọng-apfẹ agbaakh-m bi, kọ ọmaana kẹ bọng ade agbaanakka, abira akhera bi, kaam ndọkh-ẹ k'ọbada? Kkeri kwanọng kwọ mẹ e. Kọ tzọkh-ẹ, atzima arọhng e!” ");
INSERT INTO mfo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Phero ọnang anọng pẹ ndọhna bi, bẹ atza atzọkha Abram atza arik k'enem ch'irek s'Ijip. Mẹ wọ, Abram obina oji Ijip, otzima kwanọng kwẹ ttara ekpo pyẹ biphyir ofona. ");
INSERT INTO mfo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Mẹ wọ ofon, Abram obina orenga k'obhon ebira kw'Ijip, otzima kwanọng kwẹ ọmaana ekpo pyẹ biphyir, ochina k'ẹkhọma cha Nẹgẹv, wa Lọt ọtzọn-ẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Wa Abram ọkk'ọkkọkkaa ọn-ọda, kw'ọkhaam etzirakpo, ọmaana silva ttara gol k'ọhaabh. ");
INSERT INTO mfo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ttẹwọr ma Nẹgẹv, Abram ochina ororo k'orenga kwẹ, om-obhing k'obe-k'obe matzẹmaa okwu opyiri ka Bẹtẹl, obiro owobha m'ibe nna s'iwobh k'ottem kwa Bẹtẹl ọmaana Ayi, kw'ode ibe s'iwa ikhira sẹ ichi eden iwobha, ");
INSERT INTO mfo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","kw'ode ibe s'iwa ọkk'eden ọcha osi ijafọhnibe. Ma wọ kw'iwa Abram owobh okpobha che ch'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Iwa Lọt kw'ọm-ọtzọn Abram abẹ, obiro ọkhaama arukhimaan, ọmaana abhaam, ttara okhira f'atzọhmnọng arukhi. ");
INSERT INTO mfo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Yina, wa araraari p'abira abenga etzirakpo pyabẹ m'ibe nna dọk kade, da iwa ẹkhakhaama chabẹ ẹn-ẹhaabhi ẹyọhnga irek sa bẹ arukhi, maa bẹ ibe rani dọk kafha aruk. ");
INSERT INTO mfo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Wa ẹkhọhr etto k'ottem kw'akkeri-etzirakpo py'Abram ttara akkeri-etzirakpo pya Lọt. M'ogbe nwa, aKenaan ọmaana aPẹriz bẹ atzọn aruk m'ẹkhọma nda dani. ");
INSERT INTO mfo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Mẹ wọ osi, Abram on-oben Lọt bi, “Kọ ttara kaam mode votte. Tte ẹkhọhr eningi k'ottem kwaman anọng afa eyini, tte akkeri-etzirakpo pọ ttara paam aningi ẹkhọhr abira akhaama. ");
INSERT INTO mfo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Irerek nna biphyir s'iwobh ma, iwobh ka maan ka mbọhk. Tte mọkhọm ayok ẹkhaan. Kọ tzekha okhubha kw'ọdaakh-ọ, ifha aruk. Idikha kọ atzọk okhubha kw'odimbọhk, kaam ńdọkha okhubha kwa kwabọhk. Idikha atzọk okhubha kwa kwabọhk, kaam ńdọkha okhubha kw'odimbọhk.” ");
INSERT INTO mfo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Mẹ wọ ofon, Lọt otzini chen okkeri irek s'ẹttẹri cha Jọrdan, ore bi, sẹ ijibh-ojibh, okhuri da sẹ ihaabhi asi mach'owoni kw'Ọvaar Ibinọkpaabyi, ibiri ijibh mach'irek s'Ijip k'okhubha kwa Zoar. (M'ogbe nwa, wa Ọvaar Ibinọkpaabyi ibhon sa Sodom ọmaana Gomora otzima odimi.) ");
INSERT INTO mfo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Mẹ wọ osi, Lọt otzekha ẹttẹri cha Jọrdan k'okhubha kw'ewuchen em-eyin ọnang for sẹ. Mando wọ kwa Lọt ọmaana Abram areng akhọm ayok ẹkhaan. ");
INSERT INTO mfo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Wa Abram, orukhi k'ẹkhọma cha Kenaan, k'ogbe kwa Lọt orukhi k'ibhon s'ideden k'ẹttẹri, ottima ikhira sẹ ọbaanga Sodom. ");
INSERT INTO mfo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Wa anọng pa Sodom ade anọng p'asi ọmmaana-tzama, bẹ am-abira asi ẹkhọngkwuri ayong-oyongi k'itzitzikha s'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Mada Abram ọmaana Lọt akk'ayok ẹkhaan akhọma, Ọvaar Ibinọkpaabyi okwu oben Abram bi, “Tzini chen ttẹwọr mẹ da abe, akkeri k'ebir-ebira, ttara k'ẹrakha-ẹrakha, abira akkeri kẹ da ewuchen em-eyin, ọmaana kẹ da ewuchen em-edimi. ");
INSERT INTO mfo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ẹkhọma nduma ch'are mẹ biphyir, kaam ńdọkha chẹ nnang kọ, ọmaana va pọ, ttara va pa va pọ, maa ogbe ode. ");
INSERT INTO mfo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Kaam ńsi va pa va pọ ahaabh, akher oyeyeng kw'irerek kw'ọnọng on-ofha obhik. ");
INSERT INTO mfo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Bina, arenga akhọri ẹkhọma nda k'adum ọmaana ẹ̀kpá chẹ biphyir, okhuri bi, chẹ dọ cha kaam ńnang-ọ.” ");
INSERT INTO mfo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Mẹ wọ osi, Abram, orenga ọkhọri ẹkhọma nda maa opyiri ka Hẹbrọn. Okwu osi oruk kwẹ ọbaanga nchi sa ndeden sa Mamrẹ. M'ibe nna rọ s'iwa obiro osi ijafọhnibe ọnang Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","M'ogbe nwa, wa Amaraphẹl wọ ode ọvaarnọng kwa Shina, Ariyok ode ọvaarnọng kw'Ẹlasa, Kedor-laomer ode ọvaarnọng kw'Ẹlam, Tidal ode ọvaarnọng kwa Goyim. ");
INSERT INTO mfo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Wa avaarnọng mba anna biphyir an-akwu abhuna ẹfa, atza arima egbong ttara avaarnọng azen adọdọk. Avaarnọng mba azen p'iwa ayok atza arima abẹ akpen: Bera, ọvaarnọng kwa Sodom, Birasha, ọvaarnọng kwa Gomora, Shinab, ọvaarnọng kw'Adama, Shemebẹr, ọvaarnọng kwa Zeboyim, ttara ọvaarnọng kwa Bẹla, kw'obiro okpena Zoar. ");
INSERT INTO mfo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Wa avaarnọng mba azen biphyir akwu abhuna ẹfa, bẹ atza arima egbong ọmaana Kedor-laomer k'Ẹttẹri cha Sidim, ch'ede ẹttẹri ch'Ọraanga kw'Onung. ");
INSERT INTO mfo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Wa avaarnọng mba asi ọtzọhm anang Kedor-laomer ka cho jobh obhiri afa. Yina, ka cho kw'ottong jobh obhiri attaan, bẹ an-abhum ẹvaar chẹ. ");
INSERT INTO mfo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Okwu opyiri cho ọhawani kwa chi, Kedor-laomer ọmaana avaar mbongo p'abhun for ọmaana kẹ, bẹ akwu arima egbong ọmaana avaarnọng mbongo p'ani dọk akher bi, awobha k'irekh-irek kwẹ. Bẹ akhema ẹkhọma cha Rephayim, ch'ewobh k'okhubha kw'Ashtẹrọt-Karnayim, bẹ abira akhema ẹkhọma cha Zuz ch'ewobh ka Ham, ttara ẹkhọma ch'Ẹm k'okhubha kwa Shavẹ-Kiriyatayim. ");
INSERT INTO mfo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Bẹ abira atza akhema anọng p'ẹkhọma cha Họr p'arukhi ka mgbegbeho sa Seir, bẹ akhubh bẹ maa bẹ apyiri ka Ẹl-Paran kw'ọbaang k'ebherede. ");
INSERT INTO mfo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Mada bẹ apyiri mẹ, bẹ akpa nnam k'Ẹn-Mishphat kw'obiro ode Kadẹsh, bẹ abira atza akhema anọng p'ẹkhọma ch'Amalẹk, ttara anọng p'ẹkhọma ch'Amọr ch'erukhi k'okhubha kwa Hazazọn-Tama. ");
INSERT INTO mfo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Mẹ wọ osi, avaarnọng mba azen p'adabhi Sodom, ọmaana Gomora, ọmaana Adama ọmaana Zeboyim ttara Bẹla kw'obiro ode Zoar, abina ayin k'iyaan atza abe egbong k'Ẹttẹri cha Sidim, ");
INSERT INTO mfo_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","arima avaarnọng mbongo anna abẹ, p'ade ọvaar Kedor-laomer kw'ọdabhi Ẹlam, ọmaana ọvaar Tidal kw'ọdabhi Goyim, ọmaana ọvaar Amaraphẹl kw'ọdabhi Shina, ttara ọvaar Ariyok kw'ọdabhi Ẹlasa. Kw'oyini bi avaarnọng anna an-abe k'okhubha wani, avaarnọng mbongo azen abe k'okhubha nwonggo bi, bẹ arima ayok abẹ. ");
INSERT INTO mfo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Wa Ẹttẹri nda cha Sidim, ẹkhaam ape p'afu ttara ana p'abang-ọbanga abira apyi bi kaang. Mẹ wọ ofon, mada iwa avaarnọng pa Sodom ọmaana Gomora an-arọbhi, ayok bani atto m'ape mba ẹtzaanga. Ayok mbongo arọbh achina ka mgbegbeho. ");
INSERT INTO mfo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Wa avaarnọng mba anna, abọkha ayok ẹkhakhaama chabẹ kpenamkpen, ọmaana ọchattọhk fabẹ biphyir ka Sodom ọmaana ka Gomora ana, bẹ atzima afona. ");
INSERT INTO mfo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Wa bẹ abira abọkha Lọt, kw'ode nnwa kw'ọgbaanọkka kw'Abram, ọmaana ẹkhakhaama chẹ. Wa obiro ode ọnọng wani kw'iwa bẹ abọk k'ẹmmọri, okhuri bi, kẹ wa orukhi ka Sodom k'ogbe kw'iwa egbong nda etto. ");
INSERT INTO mfo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Yina, ojinọng wani kw'iwa ọrọbhi egbong ọnaanga, okwu ọgbaak Abram, kw'ode oHiburu-nọng bi, bẹ akk'Lọt abọkha k'ẹmmọri. M'ogbe nwa, wa Abram orukhi ọbaanga nchi sa Mamrẹ kw'ofon Amọr, ttara vọkka pẹ anọng afa, p'akpen Ẹshkol ọmaana Anẹr, p'iwa ade ayokh-ẹkhaan pẹ. ");
INSERT INTO mfo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Mada Abram ọbhaang bi, bẹ akk'Lọt kw'ode nnwa kw'ọgbaanọkka abọkha k'ẹmmọri atzima afona, oyeri agbongnọng pẹ p'akk'arima-bọhk akpebhi, p'ade anọng p'amaan m'ọhọhm kwẹ, abira aruk ttar-ẹ. Wa agbongnọng mba ade anọng arọbh chi obhiri chi obhiri attaan. Wa otzima agbongnọng mba pẹ eden, okhubh anọng p'abọk Lọt, maa bẹ apyiri ka Dan. ");
INSERT INTO mfo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Okwu opyiri m'erungi, Abram ọbhaangi ajinọng pẹ ka ngaan ka ngaan, bẹ akhọri attattaanga-nọng pabẹ akhe k'ottem. Mada bẹ akk'bẹ akhọri, bẹ arima bẹ abẹ, bẹ akhubh bẹ maa apyiri k'ẹkhọma cha Hoba, k'okhubha kwa Damaskọs. ");
INSERT INTO mfo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Mẹ wọ, Abram ọbọkha anọng mba ekpo pya bẹ atzọk ka Sọdọm ọmaana Gọmọra ọna, obiro otzima Lọt, ọmaana ẹkhakhaama chẹ biphyir, ọmaana panọng pa bẹ abọk k'ẹmmọri, ttara anọng adọdọk pa bẹ abira abọkha k'ẹmmọri, okhuna. ");
INSERT INTO mfo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Mada Abram on-okhun-okhuna da okk'ọvaar Kedor-laomer ọmaana avaarnọng mbongo p'awobh ttar-ẹ okhema k'egbong, ọvaarnọng kwa Sodom ofon otza okhebh-ẹ, k'Ẹttẹri cha Shavẹ, ch'ebire ekpena “Ẹttẹri ch'Ọvaarnọng.” ");
INSERT INTO mfo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Mẹ wọ osi, Mẹlkizẹdẹk, kw'ode ọvaarnọng kwa Salẹm, obiro ode ọfọhnẹja kw'Ibinọkpaabyi kw'Ọyọhng, wa otzim brẹd ọmaana atzuk ochena Abram. ");
INSERT INTO mfo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Kẹ Mẹlkizẹdẹk, osi Abram ittabọhng, obiro oben bi, “Tte Ibinọkpaabyi kw'Ọyọhng, kw'ọdabhi idik biphyir, kw'osi ẹrọng ọmaana irerek, odo kọ Abram. ");
INSERT INTO mfo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Tte ẹtzọhnga ewobha ẹnang Ibinọkpaabyi kw'Ọyọhng kw'ọdabhi idik biphyir, kw'ọkk'ọ ẹfa ọnanga ch'atzim akhema attattaanga-nọng pọ.” Mẹ wọ osi, Abram ọtzọkha ekpo kpenamkpen py'otzim k'egbong okhuna, okkema k'akhung jobh, ọtzọkha okhung wani k'akhung jobh, ọnang Mẹlkizẹdẹk. ");
INSERT INTO mfo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mẹ wọ osi, ọvaarnọng kwa Sodom on-oben Abram bi, “Kọ tzọkha ekpo kpenamkpen biphyir py'atzim k'egbong akhuna, yina, tte anọngẹya biphyir p'atzim k'egbong akhuna ọbọhk anang-m.” ");
INSERT INTO mfo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram obhina ọvaarnọng kwa Sodom bi, “Kaam nkk'mbọhk saam ndini k'ẹrọng ndena Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'Ọyọhng, kw'osi ẹrọng ọmaana irerek. Kaam nkk'mbiri nchekhi bi, ");
INSERT INTO mfo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","kaam ọttọhk manda vani f'ode fọ, fa kaam ńdọkh-otzọkha kode, ttẹwọr k'ẹnaanga-dik maa, apyiri ka ndik s'ekpo-pya-mmo, ifha kọ aninga abeni bi, ojibhada kw'Abram ofon ka mbọhk sọ e. ");
INSERT INTO mfo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Kaam ọttọhk kpenamkpen fọ, fa kaam ńdọkh-ọtzọkha kode, oyongi ọchattọhk f'ajinọng paam akk'acha, ttara ekkema ch'ajinọng p'atzor-m arima egbong. Tte Anẹr, ọmaana Ẹshkol ttara Mamrẹ, atzọkha ekkema chabẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ayongi mẹ, Ọvaar Ibinọkpaabyi oyin Abram abẹ k'idachen, ọgbaakh-ẹ atzim, oben-ẹ bi, “Abram, oning-ọ ojor, kaam wọ nde ọkhọhnkpa kw'ókker-ọ, ńnang-ọ echora ch'ideden.” ");
INSERT INTO mfo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Mada Abram ọbhaang idik nna, obhina bi, “O Ọvaar Ibinọkpaabyi kw'Ẹfa biphyir, mbọng fa kọ asi anang-m, da kaam nni nnwa mmoni, ọnọng kw'óchi-m obo ode Eliyeza kw'ofon Damaskọs.” ");
INSERT INTO mfo_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram oben bi, “Kọ kaam va atzima ananga; mẹ wọ, obira k'ẹhọhmmọr chaam wọ óchi-m obo.” ");
INSERT INTO mfo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Mẹ wọ ofon, Ọvaar Ibinọkpaabyi ọgbaak Abram atzim, oben-ẹ bi, “Mma e, kwẹ mando kode. Obira nwa araang ọ́chọ-ọ obo, nnwa kw'ofon k'adima pọ, wọ ọ́chọ-ọ obo e.” ");
INSERT INTO mfo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Mẹ wọ ofon, Ibinọkpaabyi otzim-ẹ oyin k'iyaan, ọkhọhkh-ẹ ndodori sa nwobh k'ọrọngkpakpa, oben-ẹ bi, “Akk'ara odem kwa ndodori nhaabhi, idikha afha abhik sẹ, mando kwa va pa va pọ ikhina bẹ áhaabh.” ");
INSERT INTO mfo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram okhera idik nna s'Ọvaar Ibinọkpaabyi ọgbaakh-ẹ, k'odik-ọkka. Mẹ wọ, Ọvaar Ibinọkpaabyi ọtzọkh-ẹ mach'ọnọng kw'otzor-otzor k'itzitzikha sẹ. ");
INSERT INTO mfo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ọvaar Ibinọkpaabyi obiro oben Abram bi, “Kaam nde Ọvaarnọng kwọ, kaam wọ iwa ndọkh-ọ k'obhon kw'Ur k'ẹkhọma ch'anọng pa Kaldi, ndim-ọ nkwu nnang irerek nna, ifha atzọkha sẹ mach'ekkema chọ.” ");
INSERT INTO mfo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram obhin-ẹ bi, “O Ọvaar Ibinọkpaabyi kw'Ẹfa biphyir, yan kwa kaam ńdima ńnonga bi, kaam ndọkha irek nna mach'ekkema chaam o?” ");
INSERT INTO mfo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ọvaar Ibinọkpaabyi obhin-ẹ bi, “Kọ rọhng, atza aror ọbhaamnwa-kwakwẹ, ọmaana ovu-gbokha, ttara erukhimaan-dim, p'ade cho attaan-attaan, ọmaana igbegbaa ttara ikpomikha, atzima akwu.” ");
INSERT INTO mfo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram ọtzọkha nden nnuma biphyir otzima okwu, ọbhaakha kpenamkpen k'obe ọfa, ohok igbokha kpenamkpen ikkeri oyok. Yina, ọnọhn fẹ-fẹ f'oni agbokha afa ọbhaak. ");
INSERT INTO mfo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Mada opyiri k'ogbe kw'attẹrẹ ahak bi akwu achi abukhi p'ekpo mbya, Abram okhubh bẹ. ");
INSERT INTO mfo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Mada opyiri k'ẹchọhkha k'ogbe kw'ewu ẹn-ẹhak, ọda osi Abram, ọttaabha maa ọmọm, ipyerungi bi kaang ibubha Abram maa ojora f'ideden ọsẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Abram bi, “Ronga k'odik-ọkka bi, va pa va pọ áde akhekhen-nọng k'obhon kw'oni kwabẹ ode. Bẹ áruk mẹ mach'abira, anọng ahok bẹ k'ebira, bẹ ábira anang bẹ ihem, ọttọhk ka cho ẹnọhna. ");
INSERT INTO mfo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Yina, kaam ńnang ẹkhọma nda ch'ekhe bẹ k'ebira ettuma. Ogbe kw'ebira ọkk'ọkwọbha, bẹ atzima ojibhada kw'ideden anaanga ebira ch'obhon nwuma. ");
INSERT INTO mfo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Onode kọ, ma for sọ, áruk akpen matzẹmaa atzam, yina aning ape bẹ anọhng-ọ atzor abatte k'odidiri. ");
INSERT INTO mfo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ottong igbọ inna sa va pa va pọ, bẹ ákhuna m'irerek nna, okhuri bi, ogbe otzim opyiri, kwa kaam ńgwubh anọng p'Amọr m'ibe nna, okhuri itzama sabẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Mada okwu opyiri ogbe kw'ewuchen ekk'edimi, erungi epyi bi kaang. Abram ore irọhkha s'irorong s'ekpon ewobh k'ẹtzaanga, ttara ikhebh sa iwọm ekpon, ch'ereng k'ottem kwa nden nna sa bẹ ajọhkhi k'abiri-biri, ẹkwọbha efona. ");
INSERT INTO mfo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mẹ ewu nda, Ọvaar Ibinọkpaabyi osi echekhi oben Abram bi, “Va pa va pọ bọ, pa kaam ńdọkha irerek nna ttẹwọr k'ọraanga kw'Ijip, maa apyiri k'ọraanga kwa Yupharetes ńnang, bẹ akhaama. ");
INSERT INTO mfo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Anọng p'arukhi m'irerek nna ade: abaKen, ọmaana abaKeniz, ọmaana abaKadamọn, ");
INSERT INTO mfo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ọmaana abaHet, ọmaana abaPẹriz, ọmaana abaRephayim, ");
INSERT INTO mfo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ọmaana abAmọr, ọmaana abaKenaan, ọmaana abaGirgash, ttara abaJẹbus.” ");
INSERT INTO mfo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Wa Sarai kw'ọba Abram, nnwa kọmaani. Ayongi mẹ, kẹ wa ọkhaam obira kw'ikwanọng kw'ofon Ijip kw'okpen Hagar. ");
INSERT INTO mfo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Mẹ wọ osi, on-oben Abram bi, “Mada Ọvaar Ibinọkpaabyi ọni kaam ọmaan ọnangi, kaam mben bi mphyem-ọ bi, atzọkha obira nwa kwaam ayima abẹ. Asi mẹ, kaam mfha nnenga ma ndaak sẹ ngaama nnwa.” Abram okhera bi osi macha Sarai obeni. ");
INSERT INTO mfo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Mada Abram okk'orukha k'ẹkhọma cha Kenaan ka cho jobh, Sarai ọtzọkha Hagar kw'ode obira kwẹ kw'ofon k'Ijip ọnang Abram bi, oyim-ẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram oyima Hagar abẹ, okwu otzima ibhọr. Mada Hagar orong bi, okk'ibhọr otzima, ọttẹwọr ore ọkka kw'orukhi abẹ ọkhara. ");
INSERT INTO mfo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Mẹ wọ ofon, Sarai ọdọkh-ẹ maa, on-oben Abram bi, “Ọmmamma kwaam ofon ka kọ e. Kaam wọ ndọk obira kwaam nnang-ọ bi, ayim-ẹ abẹ, yina, mada orong bi okk'ibhọr otzima, ọttẹwọr ore-m ọkhara. Tte Ọvaar Ibinọkpaabyi ọttọhna aponga pa kaam ọmaana kọ.” ");
INSERT INTO mfo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Mẹ wọ ofon, Abram oben Sarai bi, “Kker e, ominanwa nwa ode obira kwọ, kọ sẹ-ẹ mach'ọdaakh-ọ.” Mẹ wọ osi, ttẹwọr mẹ, Sarai, Hagar k'eden ọkkakka dọk kotzim, ofona mẹ, Hagar ọrọbh. ");
INSERT INTO mfo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Mada Hagar ọkk'ọrọbha, orenga-eden kw'Ọvaar Ibinọkpaabyi ọrẹ-ẹ k'esipe ch'ewobh k'ebherede, esipe ch'ewobh k'ọkkadeden kw'achin ka Shur. ");
INSERT INTO mfo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Mẹ wọ osi, orenga-eden nwa oben Hagar bi, “Hagar, obira kwa Sarai, kọ afon maan o? Am-atza maan?” Hagar obhin-ẹ bi, “Kaam mminnọbh-ọrọbh k'inna kwaam ka mbọhk ma e.” ");
INSERT INTO mfo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Orenga-eden kw'Ọvaar Ibinọkpaabyi, oben-ẹ bi, “Kọ kpa nnam atzor akka, abira ahakha eho anang-ẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Orenga-eden nwa kw'Ọvaar Ibinọkpaabyi obiro oben-ẹ bi, “Kaam ńsi va pa va pọ ahaabh-ọhaabh. Bẹ ahaabh k'odem kw'ọnọng ọni bẹ ofha obhik.” ");
INSERT INTO mfo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Orenga-eden kw'Ọvaar Ibinọkpaabyi obiro oben-ẹ bi, “Kọ akk'ibhọr atzima, ámaan ojinọng, Kọ ákpẹ-ẹ Ishimayẹl, okhuri bi Ọvaar Ibinọkpaabyi okk'ẹmọng ch'ihem sọ ọbhaanga. ");
INSERT INTO mfo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Kẹ ọ́raari mach'ẹnyanyaang ch'ẹtzam cha bẹ ani otzitzir atziri. Kẹ óde ọnọng kw'ọ́wọhngi akpen p'anọng biphyir, anọng biphyir ábira awọhngi akpen pẹ, kẹ óruk k'ittattaanga ttara votte pẹ biphyir.” ");
INSERT INTO mfo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Mẹ wọ osi, Hagar on-oben for sẹ bi, “Ode bi, Ọvaar Ibinọkpaabyi wọ kwa kaam nne ma, yina ndimi nnukhi akpen ma o?” Mẹ wọ ofon, oyer-ẹ che ch'ikpokpobha bi, Ẹl-Roi. On-oben bi, “Kaam nkk'Ibinọkpaabyi kw'Okker-m nna.” ");
INSERT INTO mfo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Mẹ wọ ofon, anọng am-ayeri esipe nda, Beer-Lahai-Roi, kw'oyini “Esipe cha kẹ kw'orukhi akpen, kw'ore-m.” Esipe nda ewobh k'ottem kwa Kadẹsh ọmaana Bẹrẹd. ");
INSERT INTO mfo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Iwa Hagar ọmaan nnwa kw'ijinọng ọnang Abram. Abram ọkpẹ-ẹ Ishimayẹl. ");
INSERT INTO mfo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","K'ogbe kw'Abram ode cho arọbh anna obhiri azadani, Hagar ọmaan-ẹ Ishimayẹl. ");
INSERT INTO mfo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","K'ogbe kw'iwa Abram on-ode cho arọbh anna obhiri ọhawani kw'ẹrọbh, Ọvaar Ibinọkpaabyi oyin Abram abẹ, oben-ẹ bi, “Kaam wọ nde Ibinọkpaabyi kw'Ẹfa biphyir, kọ hok aphaangi paam, abira aruk akpen p'atzor-otzor. ");
INSERT INTO mfo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Kaam ńsi mach'iwa nkk'nchekhi nnang-ọ bi, va pa va pọ, ikhina bẹ áhaabh-ọhaabh.” ");
INSERT INTO mfo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Mada Abram ọbhaang idik nna, ọrakha ottima itzitzikha k'irerek. Mẹ wọ, Ibinọkpaabyi oben-ẹ bi, ");
INSERT INTO mfo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ma wọ ode odik kwa kaam nchekhi nnang-ọ: kọ áde otte kwa ngọma haabhada. ");
INSERT INTO mfo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Kaam mbiri ńnang-ọ che ẹbhachẹ, Abram dọk kàkpena, kọ án-akpena Abraham, kw'oyini otte kw'idibhon k'ọhaabh. ");
INSERT INTO mfo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Kaam ńsọ-ọ abhon va k'ọhaabh, ngọma sa nhaabh-ọhaabh ḿfona ma kọ, ọmaana avaar p'ideden. ");
INSERT INTO mfo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Kaam ńsi echekhi nda cha kaam ttara kọ ebire ede echekhi cha va pa va pọ, k'igbọ s'ikwu k'ogbe ororo m'ipemanitzor. Kaam ńde Ibinọkpaabyi kwọ, ọmaana Ibinọkpaabyi kwa va pa va pọ. ");
INSERT INTO mfo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Kaam ńdọkha irek sa Kenaan biphyir sa kọ arukhi mach'okhekhennọng madẹdẹn nnang kọ, ọmaana efona chọ, bọng akhaama sẹ m'ipemanitzor. Kaam wọ ńde Ibinọkpaabyi kwabẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Mẹ wọ, Ibinọkpaabyi oben Abraham bi, “Onode kọ, akhaambi ahok echekhi nda chaam, kọ ọmaana va pa va ttara igbọ s'ikwu k'ogbe ororo. ");
INSERT INTO mfo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ma wọ ode echekhi cha kaam ttara kọ, ọmaana va pa va pọ, echekhi cha bọng áhok ede bi, ojinọng kpenamkpen kw'owobh ttara bọng ósi ọkpakkọrikkọ. ");
INSERT INTO mfo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Bọng ási ọkpakkọrikkọ kw'ẹkpakpa, kw'óde ẹkhọhkha ch'Echekhi cha kaam ttara bọng. ");
INSERT INTO mfo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","K'igbọ s'íkwu k'ororo, ijinọnọnga kpenamkpen kw'ode iwu izenanttaan, bẹ akhaambi asẹ-ẹ ọkpakkọrikkọ. Ajinọng biphyir, p'amaan ka bọng k'ọhọhm, ọmaana ayok pa bọng adebhi k'agbukha p'ani va pa bọng ade, bẹ akhaambi asi ọkpakkọrikkọ. ");
INSERT INTO mfo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Kaambi p'amaan kabọng k'ihọhm bọ, obiro ode pa bọng adebhi k'agbukha o, bọng akhaambi, asi bẹ ọkpakkọrikkọ. Mando wọ kw'echekhi chaam ch'éde ebhora ka bọng ka for, éde echekhi ch'ipemanitzor. ");
INSERT INTO mfo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ojinọng kpenamkpen kw'oni ọkpakkọrikkọ kw'ẹkpakpa osi, bọng kọm-ẹ ẹkhaan, okhuri bi, kẹ okk'echekhi chaam obhuma ohohok.” ");
INSERT INTO mfo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ibinọkpaabyi obiro oben Abraham bi, “Onode kwanọng kwọ, Sarai, kẹ Sarai dọk kokpena, kẹ ón-okpena Sara. ");
INSERT INTO mfo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Kaam ńdẹ-ẹ, mbiri ńsẹ-ẹ ọmaan-ọ nnwa kw'ijinọng. Kaam ńdo Sara bi, óde ọkka kwa ngọma sa nhaabh-ọhaabh. Avaar p'ideden ábira afona ka ndaak sẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Mẹ wọ, Abraham otto okhubha itzitzikha sẹ m'irerek, ọnang Ibinọkpaabyi ikpokpobha, ọmma aha k'ettem oben bi, “Na ọnọng kw'on-ode cho arọbh azen macha kaam, obiro obhon nnwa o? Na Sara, kw'on-obiro ode cho arọbh anna obhiri jobh, obiro ọfha ọmaan nnwa dọkh o?” ");
INSERT INTO mfo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Mẹ wọ, Abraham oben Ibinọkpaabyi bi, “Ira ode bi na ọdaakh-ọ, ira Ishimayẹl oruk ttara ẹdaa chọ.” ");
INSERT INTO mfo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Mẹ wọ, Ibinọkpaabyi oben bi, “Mma e! Sara kw'ode kwanọng kwọ, wọ ọ́maan nnwa kw'ijinọng ọnang-ọ. Kọ ákpẹ-ẹ Isaak. Kaam ńttima echekhi chaam ttara kẹ aranga. Éde echekhi ch'ewobha ẹnang va pa va pẹ, m'ipemanitzor. ");
INSERT INTO mfo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Onode odik kw'okhuri Ishimayẹl, kaam nkk'ọ mmaanga e, k'odik-ọkka kaam ńdẹ-ẹ odo e, kaam ńsẹ-ẹ obhon va, mbiri nttaar-ẹ ọhaabh. Kẹ óbhon avaar-va jobh obhiri afa. Kaam ḿbiri nsẹ-ẹ ode ẹkhọma ch'ideden. ");
INSERT INTO mfo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Yina, kaam ńgaama echekhi chaam ttara Isaak, kwa Sara ọ́maan ọnang-ọ ikhina cho nnamanda.” ");
INSERT INTO mfo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Mada Ibinọkpaabyi okk'odik nwa ọgbaakha okyera, ofona oji Abraham mẹ. ");
INSERT INTO mfo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","M'ewu nduma dani, Abraham osi mach'Ibinọkpaabyi ọkk'ẹ ọgbaakha bi, osi. Ọtzọkha nnwa kwẹ Ishimayẹl, ọmaana ajinọng biphyir p'amaan m'ọhọhm kwẹ, ttara ayok p'odebhi k'agbukha, ojinọng kpenamkpen k'ọhọhm kwẹ, osi ọkpakkọrikkọ kw'ẹkpakpa. ");
INSERT INTO mfo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Wa Abraham ode cho arọbh anna obhiri ọhawani kw'ẹrọbh, k'ogbe kwa bẹ asẹ-ẹ ọkpakkọrikkọ. ");
INSERT INTO mfo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Nnwa kwẹ, Ishimayẹl, ode cho jobh obhiri attaan, mada bẹ asẹ-ẹ ọkpakkọrikkọ. ");
INSERT INTO mfo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Wa bẹ asi Abraham ọmaana nnwa kwẹ Ishimayẹl ọkpakkọrikkọ, m'ewu nduma dani. ");
INSERT INTO mfo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Wa Abraham ọmaana ojinọng kpenamkpen kw'owobh k'ọhọhm kwẹ, ọmaana ayok p'amaan m'ọhọhm kwẹ, ttara ayok p'odebhi k'agbukha ka mbọhk s'okhekhennọng, bẹ abira asi bẹ ọkpakkọrikkọ. ");
INSERT INTO mfo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Wa Ọvaar Ibinọkpaabyi oyini Abraham abẹ k'ogbe kw'owobh ẹwọr k'ẹhọhmma ch'ikhira sẹ, ọbaanga kẹ da nchi sa Mamrẹ mbe, k'ọyakpattem kw'ewu ẹkhọmi bi gbaang. ");
INSERT INTO mfo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Mada Abraham otzini chen ore da ajinọng attaan abe abaang-ẹ, obina k'ẹhọhmma ch'ikhira sẹ, otzini mmo m'ẹbhar-ẹbhar ọtza okhebha bẹ, ọrakha ottima itzitzikha k'irerek orima bẹ. ");
INSERT INTO mfo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Oben bi, “Itta kwaam, idikha kaam nkk'ọphyaam ngaama k'itzitzikha sọ, kọ kaam ọtzọhmnọng kwọ, kakwọbha. ");
INSERT INTO mfo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Tte bẹ atzima asisaa akwu, ifha bọng agbobhi mmo, bọng abira akwokha ọwọhng m'echi nda irekhirek. ");
INSERT INTO mfo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Tte ndima ichattọhk-ttọhkha nkwu bọng achi, ifha bọng akhaama ẹfa cha bọng achina ororo k'orenga kwabọng, mada bọng akk'apyiri m'ibe sa kaam ọtzọhmnọng kwabọng.” Bẹ abhin-ẹ bi, “Ojibhi kẹ, si mach'ettem chọ ẹpaan-ọ.” ");
INSERT INTO mfo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Mẹ wọ ofon, Abraham obina ẹbhar-ẹbhar ọtza okhebha Sara k'ikhira ẹtzaanga, oben bi, “Kọ yoma agbobhi-mbọhk attaan p'abubuma atzima asi brẹd ẹbhar-ẹbhar.” ");
INSERT INTO mfo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Mẹ wọ osi, Abraham ọrọbh ochina k'ivukwuri, ọtza otzekha ọbhaam-nwa ọkkakka ọnang nnwa wani kw'orukh-ẹ abẹ, ofhu chẹ m'ẹbhar-ẹbhar otzima osi ọchattọhk. ");
INSERT INTO mfo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Yina on-obiro ọtzọkha abasi p'abang-ọbanga, ọmaana abasi ttara etzen ẹbhabhachẹ ch'ọbhaam-nwa, obera bẹ. Mada bẹ am-achi ọchattọhk mva, kẹ Abraham obe m'echi nduma irekhirek, cha bẹ awobh achi ọchattọhk. ");
INSERT INTO mfo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Anọng mba an-abọbh Abraham bi, “Kwanọng kwọ, Sara khi?” Obhina bẹ bi, “Owobh k'ikhira ẹtzaanga e.” ");
INSERT INTO mfo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Mẹ wọ ofon, ọnọng wani k'ottem kw'anọng mba, oben bi, “K'odik ọkkọkka, ikhina cho nnamanda kaam mbiri mkpa nnam nkwu ndibh bọng m'ibe nna. Sara kw'ode kwanọng kwọ, ọmaan nnwa kw'ijinọng.” Wa Sara owobh k'ekhiramma ẹtzaanga, ọkpa nnam ọbọra, om-oyonga bẹ itzọhng. ");
INSERT INTO mfo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Iwa Abraham ọmaana Sara akk'an-atzama kpọng maa, Sara ọkwọbha ọphaangi kwa for ottotto. ");
INSERT INTO mfo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Mẹ wọ ofon, Sara ọmma aha, oben for sẹ bi, “Mada nkk'ndama, itta kwaam ọtzam, na kaam mbiri mfha ngaama idadaakha s'ojinọng, sa mobiro ọtzọn oyima o?” ");
INSERT INTO mfo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Mẹ wọ osi, Ọvaar Ibinọkpaabyi ọbọbh Abraham bi, “Sara oreng mbọng apfẹ ọmma aha, oben for sẹ bi, ‘Na kaam, mbiri mfha mmaan nnwa, m'atzam mba dọkh o?’ ");
INSERT INTO mfo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Odik owobh kẹ, kw'Ọvaar Ibinọkpaabyi on-ofha oso o? Ikhina cho nnamanda kaam ḿbiri mkpa nnam nkwu ndibh bọng, Sara, ọ́maan nnwa kw'ijinọng.” ");
INSERT INTO mfo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Mada Sara ọbhaang odik nwa, ojor-ẹ. Mẹ wọ, okhona, oben bi, “Kaam aha kimma.” Ọvaar Ibinọkpaabyi oben-ẹ bi, “K'odik ọkkakka, kọ akk'aha amma e.” ");
INSERT INTO mfo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Mada anọng mba attaan abin bi, bẹ afona, bẹ atzini chen akkeri k'obhon kwa Sodom. Wa Abraham ọtzọn bẹ abẹ, ọtza orik bẹ k'eden. ");
INSERT INTO mfo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Mẹ wọ, Ọvaar Ibinọkpaabyi oben for sẹ bi, “Odik nwa kwa mbeni bi nsi ma, kọbaan bi, ndubha Abraham. ");
INSERT INTO mfo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ode odik ọkkakka bi, va pa va p'Abraham akwuma akwu ade afanọng ọmaana ẹkhọma ch'ideden, on-orenga ma kẹ, idibhon s'ọyagbin ikhaama ẹdaa. ");
INSERT INTO mfo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Da kaam nkk'ẹ ndekha bi, ọtzọhn va pẹ ọmaana ẹhọhmmọr chẹ bi, bẹ ahok abhaangi p'Ọvaar Ibinọkpaabyi, obiro oruk akpen p'atzori k'eden ch'Ọvaar Ibinọkpaabyi, ifha osi ẹjaakhi k'echekhi ch'ọkk'ọsa ọnang Abraham.” ");
INSERT INTO mfo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Mẹ wọ, Ọvaar Ibinọkpaabyi oben bi, “Obhoma kw'okhuri idik-ttama sa Sodom ọmaana sa Gomora ọbari kpọng: ẹkhọngkwuri chabẹ ebire epyibh eyong-oyongi, ");
INSERT INTO mfo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","kw'osi kaam ńhakha, ifha nda ńne, s'itzama sa bẹ akk'asa ipyibhi ipyiri obhoma kwa kaam mmaang. Kwẹ oni mando obiro ode, kaam ńnonga-oronga.” ");
INSERT INTO mfo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Mẹ wọ, ajinọng mba abhakhi nnam akkeri itzitzikha k'okhubha kwa Sodom. Yina, Abraham ochina ororo obe Ọvaar Ibinọkpaabyi k'itzitzikha. ");
INSERT INTO mfo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham orenga otzor Ọvaar Ibinọkpaabyi ka for, ọbọbh-ẹ bi, “Ma, na kọ atzọkha anọng p'asi ẹmmaana ọkkakka, afhu attara k'anọng p'asi ẹmmaana-tzama o? ");
INSERT INTO mfo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Idikha ira kọ are, anọng arọbh afa obhiri jobh, p'asi ẹmmaana ọkkakka m'obhon nwa, na ira kọ akhọkha anọng mba nkwu-osisi, atte obhon nwa ọbọhk o? ");
INSERT INTO mfo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Tzọmi-tzọmi okponga k'idachen bi, kọ atzọkha anọng p'asi ẹmmaana ọkkakka attara k'ayok p'asi ẹmmaana-tzama afhu. Ka yan wọ kw'ira ọkpaar-aponga kw'ọyagbin biphyir, oni odik kw'otzor-otzor osi o?” ");
INSERT INTO mfo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Mẹ wọ, Ọvaar Ibinọkpaabyi obhin-ẹ bi, “Idikha kaam nne anọng arọbh afa obhiri jobh, p'asi ẹmmaana ọkkakka m'obhon nwa, kaam ńnenga anọng mba abẹ, ńtte obhon nwa ọbọhk.” ");
INSERT INTO mfo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Mẹ wọ, Abraham obhin-ẹ, oben bi, “Tzotzokhaan, Ọvaar Ibinọkpaabyi kwaam, kaambi, ode bi, nde idọdọhbh, mbiri nde itzọtzọhng macha nde ma, kaam mbar ettem mgbaak atzim nnang-ọ. ");
INSERT INTO mfo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Idikha on-ode bi, anọng azen kade k'anọng arọbh afa obhiri jobh ma obhon nwa, p'asi ẹmmaana ọkkakka khi, ma na ira kọ adimi obhon nwa, okhuri anọng azen o?” Ọvaar Ibinọkpaabyi obhin-ẹ bi, “Mma e, idikha kaam nne anọng arọbh afa obhiri azen, p'atzor-otzor, kaam ngọkha bẹ nkwu-osisi ọkhọkha, ńtte obhon nwa ọbọhk.” ");
INSERT INTO mfo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham ochina ororo ọbọbh-ẹ bi, “Idikha ira on-ode bi, kọ are anọng arọbh afa, p'asi ẹmmaana ọkkakka, ma na ira kọ adimi obhon nwa o?” Ọvaar Ibinọkpaabyi obhin-ẹ bi, “Mma e, okhuri anọng mba arọbh afa, kaam ńgọhkha bẹ nkwu-osisi ọkhọkha, ńtte obhon nwa ọbọhk.” ");
INSERT INTO mfo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Mẹ wọ, Abraham obhin-ẹ bi, “Tzotzokhaan Itta, oning-ọ obhemi, tte nchina ororo mphyem-ọ. Idikha ira on-ode bi, kọ an-are anọng ẹrọbh obhiri jobh ma obhon nwa khi?” Ọvaar Ibinọkpaabyi obhin-ẹ bi, “Mma e, idikha kaam nne anọng ẹrọbh obhiri jobh, kaam ira ntte obhon nwa ọbọhk otte.” ");
INSERT INTO mfo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Mẹ wọ, Abraham oben bi, “Mada kaam nkk'ettem mbara bi, mphyem-ọ, tte mbiri mbọbh-ọ. Idikha ira on-ode bi, anọng ẹrọbh bẹ-bẹ bọ p'are ma khi?” Ọvaar Ibinọkpaabyi obhin-ẹ bi, “K'odik ọkkakka, ira nne ọnọngmik-dema nwa, ka nho s'anọng mba ẹrọbh, kaam ira ntte obhon nwa ọbọhk otte.” ");
INSERT INTO mfo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Mẹ wọ, Abraham oben bi, “Tzotzokhaan Itta, tte oning-ọ obhemi, tte nna mphyem ogbe nwa wani. Idikha ira bẹ an-ade anọng jobh bẹ-bẹ khi?” Obiro obhin-ẹ bi, “K'odik ọkkakka, ira nne ọnọngmik-dema nwa, ka nho s'anọng mba jobh, kaam ira ntte obhon nwa ọbọhk otte.” ");
INSERT INTO mfo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mada Ọvaar Ibinọkpaabyi okk'atzim ọgbaakha biphyir ttara Abraham, ofona. Abraham obiro ọkpa nnam k'ikhira sẹ. ");
INSERT INTO mfo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Okwu opyiri k'ẹchọhkha, arenga-eden mbuma afa p'Ibinọkpaabyi p'ahak Abraham, apyiri ka Sodom. M'ogbe nwa, Lọt owobh ẹwọr k'ẹbaakhamma cha Sodom. Mada ore bẹ, obina orenga otzor bẹ ka for, obiro ọrakha ottima itzitzikha k'irerek orima bẹ. ");
INSERT INTO mfo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Oben bẹ bi, “Abitta paam, tzotzokhaan bọng kwu hakha k'ọhọhm kw'ọtzọhmnọng kwabọng, ifha kaam nnang bọng asi, pa bọng agbobhi mmo sabọng, bọng ayima ma m'erungiwu nda, ewu ekk'ehobha, k'ekpekpebha, bọng achina ororo k'orenga kwabọng.” Abẹ abhin-ẹ bi, “Mma e, maman ọtza oyima k'ipha.” ");
INSERT INTO mfo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Yina, Lọt ochina ororo ọgbana bẹ maa, yina bẹ an-akher bi, atzọn-ẹ abẹ adim k'ọhọhm kwẹ. Osi brẹd kw'oni yist ọkhaam, ọnang bẹ, bẹ achi. ");
INSERT INTO mfo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Yina Lọt ọmaana akhekhennọng pẹ, aninga yima, ajinọng biphyir adikkobh ttara adedennọng, p'obhon kwa Sodom akk'ọhọhm kwẹ akhọri akhe k'ottem. ");
INSERT INTO mfo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Mando kwa bẹ agwoni Lọt abọbh-ẹ bi, “Akhekhen-nọng mbuma p'ahakh-ọ m'erungiwu cha mayina khi? Tzima bẹ yin k'iyaan, moyima bẹ abẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lọt oyin k'iyaan ọtza okhebha bẹ, obhen ọmma okpori akhekhen-nọng pẹ k'ẹtzaanga, ");
INSERT INTO mfo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","oben bẹ bi, “Mma e, abayi, bọng itzama-dema nna kasi. ");
INSERT INTO mfo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Bọng kker e, kaam ngaam aminava afa, p'ani ajinọng atzima aronga. Tte ntte bẹ ọbọhk nnang bọng, ifha bọng atzima bẹ asi, odik kpenamkpen kw'ọdaakhi bọng. Onode ajinọng mba, bọng bẹ itzama-dema nna kasi: kkeri bẹ awobh k'irekh-irek kw'ẹfa chaam.” ");
INSERT INTO mfo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Bẹ an-abhina bi, “Kebh man eden, okhekhen-nọng macha kọ wọ ira on-okwu ode ọsi-aponga kwaman o? Ani man eden akhebhi mọkwọbha, itzama sa mọsọ-ọ iyọhnga s'ira mosi bẹ.” Anọng mba achina ororo ayak Lọt atzim maa, bẹ aben bi avọhkhi ọmma. ");
INSERT INTO mfo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Yina, ajinọng mbuma p'awobh k'ọhọhm ẹtzaanga an-anemi mbọhk sabẹ, atzọr Lọt atzima adim k'ọhọhm ẹtzaanga, bẹ abhen ọmma. ");
INSERT INTO mfo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Mẹ wọ e, bẹ asi ajinọng mba biphyir p'abe k'iyaan adikkobh ọmaana adeden-nọng akpa chen, ọn-ọkhọn bẹ, bẹ ẹhọhmma ọdọk kare. ");
INSERT INTO mfo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Mẹ wọ, akhekhen-nọng mba abọbh Lọt bi, “Kọ akhaam, anọng adọdọk kẹ o? Rọhng atza atzọkha adim pa va pọ, ọmaana va pọ p'ijinọng, ttara p'ipanọng, ọmaana ọnọng kpenamkpen kw'ode kwọ, atzima bẹ biphyir abina m'obhon nwa, ");
INSERT INTO mfo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","okhuri bi, mon-odimi obhon nwa e. Itzama s'anọng p'obhon nwa akk'asa, ikk'ihaabha kpọng-kpọng k'itzitzikha s'Ọvaar Ibinọkpaabyi, kẹ wọ osi ọtzọhm man bi mokwu odimi obhon nwa e.” ");
INSERT INTO mfo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Mẹ wọ, Lọt oyin k'iyaan ọtza ọgbaak ajinọng p'akk'for ada bi atzọkha va pẹ p'ipanọng k'ọbada. Oben bẹ bi, “Bọng s'ẹbhar-ẹbhar abina aji obhon nwa, kkeri Ọvaar Ibinọkpaabyi on-odimi obhon nwa e.” Chibhi da okk'bẹ ọgbaakha mẹ, adim pa va atzọkha kwẹ mach'okhiri-dik. ");
INSERT INTO mfo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Mada ewu en-ehobh, arenga-eden mba adukha Lọt aben bi, “Tzima kwanọng kwọ ọmaana va pọ p'ipanọng p'awobh ma ttar-ọ, abina m'obhon nwa ẹbhar-ẹbhar. Oni mando ode, kọ abira atzọkha ekkema k'ọmmamma kw'ótto okhebha odedenmon nwa.” ");
INSERT INTO mfo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Chibhi da arenga-eden mba adukh-ẹ, Lọt osi ma for bi zẹmẹnẹ. Mando kw'arenga-eden mba aji Lọt ọmaana kwanọng kwẹ ttara aminava pẹ afa mbọhk bi kpẹẹbh, atzima ayin k'obhon nwa, da Ọvaar Ibinọkpaabyi ọkhaam inọngkwo ttara bẹ. ");
INSERT INTO mfo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Mada bẹ akk'ayina k'iyaan m'obhon nwa, ọnọng wani k'ottem kw'arenga-eden mba oben bẹ bi, “Bọng nọbh k'odem kwa bọng akkaana akpen pabọng o. Bọng nnam kàbhakh o, bọng k'ẹttẹri manda dani kàbira abe o. Bọng nọbh achina k'ibe sa mgbegbeho nwobh. Oni mando ode, bọng ápe-ope.” ");
INSERT INTO mfo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Mẹ wọ, Lọt oben bẹ bi, “Mma e, abitta paam, tte nsi bọng nkwo. ");
INSERT INTO mfo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Bọng akk'aam ọphyaam akhọkha, bọng akk'ejibha ch'ideden abira asa anang-m, akkaana akpen paam. Yina, ẹfa kaam kede cha mfha nnọbh nchina k'ibe sa mgbegbeho nwobh, okhuri bi itzama nna íkhọhbh-m ọkhọhbha, kaam ḿbiri mpe-ope. ");
INSERT INTO mfo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Bọng kkeri obhon nwana kw'owobh ọbaanga ma, bina ma pyiri kẹ kpọng kobhiri. Ode ibhobhona, tte mọrọbh ochina kẹ ifha moruk akpen.” ");
INSERT INTO mfo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Iwa orenga-eden nwa obhin-ẹ bi, “Kaam ńsi-osi mach'aphyem-m. Kaam ńtte obhon nwa ọbọhk otte, kẹ kíndimi. ");
INSERT INTO mfo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kọ rọbh ẹbhar-ẹbhar achina kẹ, okhuri bi, kaam odik manda wani kinkponga nsi ma kọ apyiri kẹ.” Kẹ wọ osi bẹ ayeri obhon nwuma Zoar. ");
INSERT INTO mfo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lọt ọmaana anọng pẹ apyiri ka Zoar k'ogbe kw'ewu ẹkk'ẹnyaana. ");
INSERT INTO mfo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Wa Ọvaar Ibinọkpaabyi ọtzọhm atza p'awọm ekpon p'afon k'ẹrọng atzebh ka Sodom ọmaana Gomora. ");
INSERT INTO mfo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Mando kw'iwa Ibinọkpaabyi oreng odimi ibhon nna, ọmaana ibhon biphyir s'egbegbeho nda, ttara anọng biphyir p'arukhi m'ibhon nna, ttara ekpo py'emeni m'irek nna. ");
INSERT INTO mfo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Yina, kwanọng kwa Lọt ọbhakhi nnam, on-orengi ọtza kw'onung kw'obe bi gbẹẹng. ");
INSERT INTO mfo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Mada ewu en-ehọbh, k'ekpekpebha, Abraham obina ochina k'ibe s'iwa obe k'itzitzikha s'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Mada ọhak chen okkeri ka Sodom ọmaana Gomora, k'irek s'ẹttẹri biphyir, ore ororong-bina kw'om-oyin k'okhubha nwuma, mach'irorong s'ekpon cha nkwukha. ");
INSERT INTO mfo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Mẹ wọ, mada iwa Ọvaar Ibinọkpaabyi odimi ibhon nna biphyir s'iwobh k'ẹttẹri, ojima Abraham. Ofona mẹ, ọrọbha Lọt ka mbọhk s'itzama s'itto ikhebha ibhon nna s'iwa Lọt orukhi. ");
INSERT INTO mfo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Wa ojora osi Lọt bi, ọtza oruk ka Zoar, on-otzima va pẹ p'ipanọng afa ọtza oruk k'okhubha kwa mgbegbeho. Wa kẹ ọmaana va pẹ afa arukhi k'ọmma kw'itzakpa. ");
INSERT INTO mfo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ewu dani, ochedennwa kwa Lọt, oben ọgbaanọkka bi, “Otte kwaman ọkk'ọtzama; akker-okkeri ojinọng ma ibe nna kode kw'oyima man abẹ mach'ẹmaana ch'ọnọngẹya ede, makhọra ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Tte mọnang otte kwaman atzuk ogwo obuma, ifha moyim-ẹ abẹ, morenga k'otte kwaman osi echimma chaman eningi edimi.” ");
INSERT INTO mfo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","M'erungiwu nduma, bẹ anang otte atzuk ogwo obuma, ochedennwa ọtza oyima otte abẹ. Otte ogbe kwa nnwa okwu oyima mẹ, ọmaana ogbe kw'obiro obina korong. ");
INSERT INTO mfo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ewu ehobh mẹ, ochedennwa oben ọgbaanọkka kw'ikhakhari bi, “Erungiwu ch'ikhena, kaam nkk'otte kwaman abẹ nyima e. Mobiro ọnang-ẹ atzuk ogwo mach'ikhena, m'erungiwu cha mayina, kọ rọhng abira atza ayim-ẹ abẹ, ifha morenga k'otte kwaman mosi echimma chaman eningi edimi.” ");
INSERT INTO mfo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","M'erungiwu nduma, bẹ anang otte atzuk ogwo obuma. Ọgbaanọkka kw'ikhakhari obiro ọtza oyima otte abẹ. Otte ogbe kwa nnwa okwu oyima mẹ, ọmaana ogbe kw'obiro obina korong. ");
INSERT INTO mfo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Mẹ wọ, va mba pa Lọt afa p'ipanọng atzima ọbhọr anang otte kwabẹ. ");
INSERT INTO mfo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ochedennwa ọmaan ojinọng, ọkpẹ-ẹ Moab, kẹ wọ ode otte kw'ẹkhọma cha Moab maa apyiri ma. ");
INSERT INTO mfo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ọgbaanọkka kw'ikhakhari obiro ọmaan ojinọng, ọkpẹ-ẹ Bẹn-Ammi, kẹ wọ ode otte kw'ẹkhọma ch'Ammọn ma apyiri ma. ");
INSERT INTO mfo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham obina ochina k'ẹkhọma cha Nẹgẹv, oruk k'ottem kw'ibhon sa Kadẹsh ọmaana Shur. Ayongi mẹ, wa obiro obhing ka Gẹra k'igbegbaa. ");
INSERT INTO mfo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Mẹ wọ kw'iwa Abraham ọgbaakhi anọng bi, kwanọng kwẹ, Sara, ode ọgbaanọkka kwẹ. Mẹ wọ, Abimẹlẹk kw'ode ọvaarnọng kwa Gẹra ọtzọhm anọng bi, bẹ atzima Sara akwu k'ọvaar-dimpa kwẹ, ọtzọkh-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Yina, erungiwu dani Ibinọkpaabyi oyin Abimẹlẹk abẹ k'idachen, osi ẹjaakhi ọnang-ẹ bi, “Kọ an-ape e, okhuri bi, kwanọng nwa kw'atzọk ahok m'ọhọhm kwọ, ode kwanọng kw'ọkhaam odim e.” ");
INSERT INTO mfo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Yina, wa Abimẹlẹk ọmaana Sara bẹ ayok for atzima aronga. Mẹ wọ, Abimẹlẹk ọbọbh Ibinọkpaabyi bi, “Itta, ma na kọ atzọkha ọnọng kw'oni itzama otzima ọsa afhu-o? ");
INSERT INTO mfo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham ma for sẹ wọ ọgbaakh-m bi, Sara ode ọgbaanotte kwẹ. Sara ọkhaam ma for sẹ obiro ọgbaakh-m bi, Abraham ode ọgbaanotte kwẹ. Ettem chaam ttara achibhi paam bẹ m'odik nwa kapyibhi.” ");
INSERT INTO mfo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Mẹ wọ, Ibinọkpaabyi oben Abimẹlẹk k'idachen bi, “K'odik ọkkakka, kaam nkk'nnonga bi, odik nwa k'ọgbaan kasi, kẹ wọ osi kaam mkpọ-ọ eden ifha aningi ẹkhọngkwuri k'itzitzikha saam asi, mbiri mkpọ-ọ eden ifha bọng aningi ayok abẹ ayim. ");
INSERT INTO mfo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Mẹ wọ, tte kwanọng nwuma ọbọhk anang odim kwẹ. Kkeri odim kwẹ ode ọsẹjaakhi, kẹ ózi njọhm ọnang-ọ áruk akpen. Yina, idikha anẹ-ẹ ọbọhk atte, kọ ronga k'odik ọkkakka bi, kọ ọmaana ẹhọhmmọr chọ biphyir ápe-ope.” ");
INSERT INTO mfo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Mẹ wọ, k'ekpekpebha ch'ewu ehobh mẹ, Abimẹlẹk oyeri akhaan-nọng pẹ biphyir akwu, ọtzọkha odik kpenamkpen ọgbaak bẹ. Ojora f'ideden osi bẹ. ");
INSERT INTO mfo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Mẹ wọ, Abimẹlẹk oyeri Abraham, ọbọbh-ẹ bi, “Bọng odik-dema kw'asi anang man ma? Yan wọ kwa kaam nkk'ntta ka kọ k'itzitzikha o, kw'ira arenga kwẹ abẹ anang kaam ttara ọvaarbhon kwaam ettuma-dema nda o? Odik nwa kw'asi anang-m ma, kọbaan.” ");
INSERT INTO mfo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimẹlẹk ochina ororo ọbọbh Abraham bi, “Bọnga nttak kw'atzim asi odik nwa?” ");
INSERT INTO mfo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham obhin-ẹ bi, “Nsi mando da nchibhi bi, anọng p'obhon nwa ojora Ibinọkpaabyi kakhaam, bẹ afha afhu-m okhuri kwanọng kwaam. ");
INSERT INTO mfo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ayongi mẹ, kwanọng nwa ode ọgbaanotte kwaam, kw'otte wani obhoni man, yina, mọkhọmi abakka. Kaam mbiri ndọkh-ẹ macha kwanọng kwaam. ");
INSERT INTO mfo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","K'ogbe kw'iwa Ibinọkpaabyi osi-m mbina nji ẹhọhmmọr ch'otte kwaam, nnenga nchina k'obe-k'obe. Wa kaam mbeni Sara bi, k'ibe kpenamkpen sa mọtza, kọ gbaak anọng bi, kaam nde ọgbaanotte kwọ, ifha atzima mẹ akhọkh-m idadaakha.” ");
INSERT INTO mfo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Iwa Abimẹlẹk ọtzọkha arukhimaan ọmaana abhaam, ttara abira p'ijinọng ọmaana p'ipanọng, ọnang Abraham. Ọtzọkha Sara ọkpa nnam ọnang Abraham. ");
INSERT INTO mfo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimẹlẹk on-oben bi, “Kker e, irerek sa kaam ndabhi biphyir iwobh-ọ m'itzitzikha, kọ ruk k'ibe kpenamkpen s'idaakh-ọ.” ");
INSERT INTO mfo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Abimẹlẹk on-obiro oben Sara bi, “Kker e, kaam nnaangi agbaanatte kwọ ashẹkẹl pa silva nnọhna mfa obhiri arọbh jobh. Ma wọ ode ẹkhọhkha bi, odik nwa ọkk'ọha e, ttara bi mbọhk sọ m'odik nwa kinde.” ");
INSERT INTO mfo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Mẹ wọ, Abraham ozi njọhm ọnang Ibinọkpaabyi. Ibinọkpaabyi orenga ma njọhm nna osi Abimẹlẹk, ọmaana kwanọng kwẹ, ttara abira p'ipanọng bi, bẹ abira akhaama va, ");
INSERT INTO mfo_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","okhuri da iwa Abimẹlẹk ọtzọk Sara kw'ode kwanọng kw'Abraham, wa Ọvaar Ibinọkpaabyi okk'panọng p'ẹhọhmmọr ch'Abimẹlẹk biphyir ọkpaana. ");
INSERT INTO mfo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Wa Ọvaar Ibinọkpaabyi odo Sara, mach'iwa okk'ochekhi. ");
INSERT INTO mfo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara okwu otzima ibhọr, ọmaan nnwa kw'ijinọng ọnang Abraham k'atzam. Wa nnwa nwa ọmaan otzor k'ogbe kw'iwa Ibinọkpaabyi okk'ochekhi bi ọmaana. ");
INSERT INTO mfo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Mẹ wọ, Abraham okpe nnwa nwa kwa Sara ọmaani, Isaak. ");
INSERT INTO mfo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Okwu opyiri iwu izenanttaan sa nnwa nwa kwẹ Isaak ọmaan, Abraham ọsẹ-ẹ ọkpakkọrikkọ otzor k'odem kw'Ibinọkpaabyi ọkk'ẹ ọtzọhna. ");
INSERT INTO mfo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Wa Abraham ode cho arọbh azen, k'ogbe kwa nnwa kwẹ Isaak, ọmaan. ");
INSERT INTO mfo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Mẹ wọ, Sara oben bi, “Ibinọkpaabyi ọkk'aam ọsa bi mma aha. Ọnọng kpenamkpen kw'ọbhaang odik nwa kw'Ibinọkpaabyi osi ọnang-m, obiro otzor-m ọmma aha.” ");
INSERT INTO mfo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ochina ororo oben bi, “Anyi wọ ira ọgbaak Abraham bi, na kaam Sara mfha nnọk nnwa? Yina, kaam nkk'nnwa kw'ijinọng mmaana nnang Abraham k'atzam pẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nnwa nwa ọbar, ọkka otzim-ẹ ẹba, okwu opyiri k'ewu ch'ọkka otzimi Isaak ẹba, Abraham osi ọdadaami kw'ideden. ");
INSERT INTO mfo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Wa Sara ore da nnwa nwa kwa Hagar kw'ofon Ijip ọmaani ọnang Abraham, om-osi ẹyaanga-tzama ttara Isaak. ");
INSERT INTO mfo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Mẹ wọ, Sara oben Abraham bi, “Khubh obira-kwanọng nwa ttara nnwa kwẹ, bẹ arọhng afona. Nnwa nwa kw'obira-kwanọng kọbaan bi ọkhaama ekkema k'ojibhada kwọ, kwa nnwa kwaam Isaak ọ́tzọkha.” ");
INSERT INTO mfo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Wa odik nwa ọyakhi Abraham atzim k'ettem kpọng-kpọng, da ore bi, Ishimayẹl obiro ode nnwa kwẹ. ");
INSERT INTO mfo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Yina, Ibinọkpaabyi oben Abraham bi, “Ettem ening-ọ atzim ẹyakhi okhuri nnwa nwa ọmaana obira-kwanọng kwọ. Si odik kpenamkpen kwa Sara oben-ọ bi, asi, okhuri bi, orenga ma Isaak va pa va pọ, áhaabh-ọhaabh atzor k'echekhi ch'iwa nkk'nnanga. ");
INSERT INTO mfo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Kaam ńsi nnwa kw'obira-kwanọng nwa obiro ọkhaama ẹkhọma chẹ, okhuri da kẹ obiro ode nnwa kwọ.” ");
INSERT INTO mfo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Mẹ wọ e, Abraham obina k'ekpekpebha ọtzọkha ọchattọhk, obiro ọtzọkha asi, okhe k'ẹkpa ch'ede etzenkpa, ọnang Hagar. Abraham ọtzọkha pyẹ ọnan-ẹ ka mbabaang, okhubh-ẹ ọmaana nnwa kwẹ. Mẹ wọ, Hagar obina ochina k'ebherede, k'okhubha kwa Bẹrshẹba. ");
INSERT INTO mfo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Mada asi mba p'awobh k'ẹkpa ch'ede etzenkpa akk'an-aha, Hagar ọtzọkha nnwa oruri k'ochi-gbagba wani. ");
INSERT INTO mfo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ọn-ọpaangi owobha ẹwọr k'oden-mir, oben for sẹ bi, “Kaam ettem kingaama nwobha ma nne nnwa kwaam ope.” Mada otzim owobh ẹwọr mẹ, nnwa kwẹ osẹ-ẹ nkwo, on-obhom ẹmọng k'ẹrọng. ");
INSERT INTO mfo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Wa Ibinọkpaabyi ọbhaanga ẹmọng cha nnwa nwa obhomi. Orenga-eden kw'Ibinọkpaabyi kw'ẹrọng oben Hagar bi, “Bọng odik wọ o? Oning-ọ ojor, mada nnwa kwọ oyim mẹ, Ibinọkpaabyi okk'ẹmọng chẹ ch'obhomi, ọbhaanga. ");
INSERT INTO mfo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Bina atza atzini nnwa kwọ, kkeri kaam ńsẹ-ẹ ode otte kw'ẹkhọma ch'ideden.” ");
INSERT INTO mfo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Mẹ wọ, Ibinọkpaabyi osi Hagar ore esipe. Otzima ẹkpa ch'ede etzenkpa, ọtza ọkhaabha asi maa chẹ efhu, ọnang nnwa ogwo. ");
INSERT INTO mfo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Wa Ibinọkpaabyi owobha ttara nnwa nwa mada ọm-ọbar. Wa nnwa nwa oruk k'ebherede, ode ọgbajijaa kw'ideden. ");
INSERT INTO mfo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Mada iwa nnwa nwa orukhi k'ebherede ka Paran, ọkka kwẹ ọtza ọtzọkha ominanwa kw'ofon Ijip, ọnang-ẹ k'ọbada. ");
INSERT INTO mfo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","K'ogbe nwuma, Abimẹlẹk otzim Phikol kw'ode oho kw'agbongnọng pẹ, ọtza oben Abraham bi, “Ibinọkpaabyi owobh ttara kọ k'odik kpenamkpen kw'asi. ");
INSERT INTO mfo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Mẹ wọ, kọ chekhi anang-m m'itzitzikha s'Ibinọkpaabyi bi, kaam kàbọhra ọmaana va paam, ttara va pa va paam. Kọ si ẹmmaana ọkkakka atzima atzor-m, ọmaana ẹkhọma nda cha kọ arukhi mach'okhekhen-nọng, atzor macha kaam nsi nnang-ọ.” ");
INSERT INTO mfo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham oben bi, “Kaam nkk'nchekhi.” ");
INSERT INTO mfo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mẹ wọ e, Abraham ọgbaak Abimẹlẹk odik okhuri esipe chẹ, ch'atzọhmnọng pa kẹ Abimẹlẹk akk'ẹ abọhkha ana. ");
INSERT INTO mfo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Yina, Abimẹlẹk obhin-ẹ bi, “Kaam ọnọng kw'osi odik nwa kinnong, kọ kaam odik-dema nwa atzima am-agbaakha, mayina wọ kwa kaam nna mmaang kwẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Mẹ wọ, Abraham ọtzọkha arukhimaan ọmaana abhaam, ọnang Abimẹlẹk, bẹ anọng mba afa asi echekhi anang ayok. ");
INSERT INTO mfo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham ọtzọkha arukhimaan-papẹ azenamfa k'etzirakpo pyẹ, ọkhọm ohok. ");
INSERT INTO mfo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimẹlẹk ọn-ọbọbh Abraham bi, “Arukhimaan-papẹ mba azenamfa p'akhọmi ahok ka, ayini yan o?” ");
INSERT INTO mfo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham obhin-ẹ bi, “Kọ khera bi, atzọkha arukhimaan-papẹ mba azenamfa pa kaam nnang-ọ, mando wọ ọkhọkha bi, kọ akk'akhera bi, kaam wọ ndumi esipe nda.” ");
INSERT INTO mfo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Mẹ wọ, anọng ayeri ibe nna Bẹrshẹba, okhuri bi, mẹ wọ kw'ajinọng mba afa awobh asi echekhi anang ayok. ");
INSERT INTO mfo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Mada bẹ akk'echekhi nda asa ka Beershẹba, Abimẹlẹk otzima Phikol nwa kw'ode oho kw'arim-egbong pẹ, ọkpa nnam abhana k'ẹkhọma cha Philistiya. ");
INSERT INTO mfo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Wa Abraham ogboni echi cha tamaris ka Bẹrshẹba. M'ibe nna rọ sa kẹ, om-owobha okpobha Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'ipemanitzor. ");
INSERT INTO mfo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Wa Abraham oruk m'ẹkhọma nda cha Philistiya k'ogbe-bhirada. ");
INSERT INTO mfo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","K'ogbe wani mẹ, Ibinọkpaabyi oyom nnam-ophephe kw'Abraham, oyer-ẹ bi, “Abraham!” Abraham obhina bi, “Kkeri kaam ma e.” ");
INSERT INTO mfo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Mẹ wọ, Ibinọkpaabyi oben Abraham bi, “Kọ tzọkha nnwa kwọ Isaak, nnwa nwuma kwọ wani kw'ọdaakh-ọ ọdaak, achina k'ẹkhọma cha Moriya. Tzim-ẹ asi ẹnanga ẹkwọmichẹ k'ottem kwa mgbegbeho sa ńdibh-ọ.” ");
INSERT INTO mfo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ewu ehobh mẹ k'ekpekpebha, Abraham obina ọmaana atzọhmnọng pẹ afa, ttara nnwa kwẹ Isaak, ọtzọkha ekpo ọdabh k'ẹnyanyaang chẹ. Mada okk'ommen ọkpaara f'obenga ẹnanga ẹkwọmichẹ nda, obina orenga ochina k'ibe nnuma s'Ibinọkpaabyi ọkk'ẹ otzibha. ");
INSERT INTO mfo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ottong iwu ittaan s'orenga nwa, Abraham otzini chen, ore ibe nnuma k'ororo. ");
INSERT INTO mfo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ofona mẹ, Abraham on-oben atzọhmnọng pẹ bi, “Bọng wobha ma ttara ẹnyanyaang atzik man, da kaam ttara Isaak, mochina k'ororo, mótza okpobha Ibinọkpaabyi. Mokyerkyer, mọ́kpa nnam ọkpa okhebha bọng m'ibe nna.” ");
INSERT INTO mfo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Wa Abraham otzini ommen fa bẹ atzima abaanga ekpon ch'ẹnanga ẹkwọmichẹ, ọnana nnwa kwẹ Isaak. Kẹ Abraham otzima ekpon, ọmaana imaana k'ọbọhk. Mada bẹ anọng afa areng m'eden, ");
INSERT INTO mfo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaak, oben otte bi, “Itta kwaam.” Abraham okhera bi, “Nnwa kwaam.” Isaak ochina ororo oben bi, kaam mben bi, mbọbh-ọ bi, “Mada ommen owobh ma, ekpon ewobha, orukhimaan kw'am-otzima osi ẹnanga ẹkwọmichẹ kho o?” ");
INSERT INTO mfo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Mẹ wọ, Abraham obhin-ẹ bi, “Nnwa kwaam, Ibinọkpaabyi ọkhaam ma for sẹ wọ, ọ́nang man orukhimaan kw'ẹnanga ẹkwọmichẹ nda e.” Mando wọ kwa bẹ anọng afa achin ororo arenga afona. ");
INSERT INTO mfo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Mada bẹ apyiri k'ibe s'Ibinọkpaabyi ọkk'ẹ ọgbaakha, Abraham osi ijafọhnibe mẹ, ọtzọkha ommen otzobha nkwukha. Yina ọn-ọtzọk nnwa kwẹ Isaak, ọdabh ndik biphyir, otzin-ẹ ọnana k'ommen nvuma ebir-ebir. ");
INSERT INTO mfo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Mẹ wọ, Abraham onemi ọbọhk ọtzọkha imaana bi, ofhu nnwa kwẹ. ");
INSERT INTO mfo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Yina, orenga-eden kw'Ọvaar s'Ibinọkpaabyi owobha k'ẹrọng oyer-ẹ bi, “Abraham! Abraham!” Abraham obhin-ẹ bi, “Kkeri kaam ma e.” ");
INSERT INTO mfo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Orenga-eden nwa oben bi, “Nnwa nwuma ọbọhk kàtọhmi, kẹ ọttọhk kàsi o! Kaam nkk'nna nnonga bi, kọ akhaam ojora f'Ibinọkpaabyi, okhuri da kọ akher bi, atzima nnwa kwọ wani kẹ-khẹ afọhni ẹja anang-m.” ");
INSERT INTO mfo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Mẹ wọ, Abraham otzini chen ore erukhimaan-dim ch'etzim abhik ẹdama k'ọran, ofona ọtza ọtzọkha chẹ, otzima osi ẹnanga ẹkwọmichẹ k'eho cha nnwa kwẹ. ");
INSERT INTO mfo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Mẹ wọ e, Abraham oyeri ibe nnuma bi, “Ọvaar Ibinọkpaabyi ọ́nang-ọnang.” Maa apyiri mayina, anọng an-ayeri ibe nnuma, “K'egbegbeho ch'Ọvaar Ibinọkpaabyi ọ́nang-ọnang.” ");
INSERT INTO mfo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Wa orenga-eden kw'Ọvaar Ibinọkpaabyi owobha k'ẹrọng oyeri Abraham ottong igbe ifa, ");
INSERT INTO mfo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","oben bi, “Ọvaar Ibinọkpaabyi ochekhi ka che chẹ bi, okhuri da kọ akher bi atzima nnwa nwa wani kwọ afọhni ẹja anang-m, ");
INSERT INTO mfo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","k'odik-ọkka kaam ńdọ-ọ, mbiri ńsi va pọ bẹ ahaabh macha ndodori sa nwobh k'ọrọngkpakpa, ọmaana opfong kw'owobh k'ọraanga. Mẹ wọ, va pa va pọ abira atzọkha idedenmon s'iwobh m'ẹkhọma nduma ch'attattaanga-nọng pọ. ");
INSERT INTO mfo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Órenga ka nnam sa va pa va pọ, ngọma s'ọyagbin biphyir ńdọkha ẹdaa, ọkhuri da, kọ ahak eho anang ndọhna saam.” ");
INSERT INTO mfo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Mando kw'Abraham ọkpa nnam ọtza okhebha atzọhmnọng pẹ kẹ da bẹ atzikh-ẹ. Bẹ biphyir abina abhana ka Bẹrshẹba. Wa Abraham osi oruk kwẹ mẹ. ");
INSERT INTO mfo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Wa k'ogbe wani, bẹ agbaakhi Abraham bi, “Milka, kw'ode kwanọng kw'agbaanakka, Nahọr, okk'va p'ijinọng obiro ọmaana ọnang-ẹ. Wa va pa Milka ọmaani ọnang Nahọr bẹ ade: ");
INSERT INTO mfo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz, kw'ode ocheden-nwa. Wa Uz ọkhaam agbaanọkka p'akpen Buz, ọmaana Kẹmuẹl. Kẹmuẹl kẹ wa ode otte kw'Aram, ");
INSERT INTO mfo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","obiro ode otte kwa Kẹsẹd, ọmaana Hazọr, ọmaana Pildash, ọmaana Jidlaph ttara Bẹtuẹl.” ");
INSERT INTO mfo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bẹtuẹl, ode otte kwa Rẹbẹka. Wa Milka ọmaani va azenanttaan ọnang Nahọr kw'ode ọgbaanọkka kw'Abraham. ");
INSERT INTO mfo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Wa ọkkọra-kwanọng kwa Nahọr kw'okpen Reuma obiro ọmaan-ẹ va p'ade: Tẹba, ọmaana Gaham, ọmaana Tahash ttara Maaka. ");
INSERT INTO mfo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Wa Sara orukhi akpen ka cho arọbh azadani obhiri azenamfa. ");
INSERT INTO mfo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ope ka Kiriyat-Arba, kwa bẹ abira ayeri Hẹbrọn, k'ẹkhọma cha Kenaan. Wa Abraham ọtzọkha ogbe, obhom Sara kw'ọkk'ọpa. ");
INSERT INTO mfo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Mẹ wọ, Abraham obina oji obukhi kwa kwanọng kwẹ ọtza okhebha anọng pa Het, oben bẹ bi, ");
INSERT INTO mfo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Kaam nde okhekhennọng ma bọng k'obhon. Bọng kpe-m irerek sa ndima nsi inọhng-anọng, ifha ode mẹ, ńnọhnga obukhi kwaam.” ");
INSERT INTO mfo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Iwa anọng pa Het abhina Abraham bi, ");
INSERT INTO mfo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Itta, yonga man itzọhng, kọ ade ọvaar-nwa kw'ideden ma man k'ottem e, nọhnga kwanọng kwọ k'epekhubh kpenamkpen ch'ẹdaakh-ọ ọtzam, ma mpekhubh nna sa man. Ọnọng mada wani kw'ọraam-ọ ibe sa anọhnga kwanọng ma kode e.” ");
INSERT INTO mfo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Mẹ wọ, Abraham obina ochunga eho k'ikpokpobha ọnang anọng pa Het. ");
INSERT INTO mfo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Oben bẹ bi, “Idikha ọdaakhi bọng kẹ bi, kaam nnọhnga kwanọng kwaam manya bọng k'irerek, tte mphyem bọng odik wani bi, bọng aphyem Ẹphrọn, nnwa kwa Zoha anang-m, ");
INSERT INTO mfo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ifha okpe-m ọmma kw'itzakpa, kw'owobh ka Makpẹla k'ikpiho s'owoni kwẹ. Bọng ben-ẹ bi, okpe-m sẹ k'ẹphya ch'ẹdaakh-ẹ, ifha ndima sẹ nsi inọhng-anọng ma bọng k'obhon.” ");
INSERT INTO mfo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Iwa Ẹphrọn kw'ofon Het owobh ẹwọr mẹ ttara anọng pa Het, k'ogbe kw'Abraham ọm-ọgbaak odik nwa. Obina m'ottem kw'ayok, ọnang Abraham ebhina k'odik kw'ophyemi. Wa ọnọng kpenamkpen kw'owobh m'ẹbaakhamma ch'obhon ọbhaanga ebhina ch'Ẹphrọn kw'ofon Het ọnangi Abraham. ");
INSERT INTO mfo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Wa Ẹphrọn on-obhina bi, “Mma e, itta kwaam yong-m itzọhng, kaam nnang-ọ irerek nna biphyir ttara ọmma nwa kw'itzakpa kw'owobh mẹ. Kaam nsi mando k'itzitzikha s'anọng mba paam biphyir, ifha kọ anọhnga obukhi kwọ.” ");
INSERT INTO mfo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Iwa Abraham obiro ochunga eho ọkhọkha ikpokpobha k'itzitzikha s'anọng p'obhon nwa. ");
INSERT INTO mfo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","On-oben Ẹphrọn k'itzitzikha s'anọng mba bi, “Yong-m itzọhng, idikha ọdaakh-ọ, kaam ndebh irerek nna odebh. Kọ tzọkha agbukha pa kaam ńnang-ọ m'irerek nna, ifha nnọhnga kwanọng kwaam.” ");
INSERT INTO mfo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Mẹ wọ, Ẹphrọn on-obhina Abraham, oben bi, ");
INSERT INTO mfo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Itta kwaam, yong-m itzọhng, irerek nna ipe ashẹkẹl ẹnọhna pa silva, yina, bẹ ape mbọng k'ottem kwaman anọng afa o? Nọnhga kwanọng kwọ k'irerekh e.” ");
INSERT INTO mfo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Wa Abraham okhera mach'Ẹphrọn obeni, ọnang Ẹphrọn ogbukhabhik m'itzitzikha s'anọng pa Het otzor k'ẹphya ch'ọgbaakhi. Wa ọnang-ẹ ashẹkẹl ẹnọhna pa silva otzor k'ẹphya ch'aphya-phyaa. ");
INSERT INTO mfo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Mẹ wọ, Ẹphrọn ọtzọkha irerek s'iwobh ka Makpẹla ọbaanga Mamrẹ, ọmaana ọmma kw'itzakpa ttara nchi kpenamkpen sa mbe m'ibe nnuma okpe pyẹ biphyir ");
INSERT INTO mfo_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ọnang Abraham, en-ede py'Abraham k'itzitzikha s'anọng pa Het biphyir, p'awobh m'ẹbaakhamma ch'obhon nwa. ");
INSERT INTO mfo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Mada ntọhna s'irerek nna nkk'nha, Abraham ọnọhnga kwanọng kwẹ, Sara, k'ọmma kw'itzakpa kw'owobh ka Makpẹla, ọbaanga Mamrẹ kw'ode Hẹbrọn, k'ẹkhọma cha Kenaan. ");
INSERT INTO mfo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Mẹ wọ e, anọng pa Het atzọkha irerek nnuma, ttara ọmma nwuma kw'itzakpa, akpe anang Abraham, otzima osi inọhng-anọng. ");
INSERT INTO mfo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","K'ogbe kw'iwa Abraham ọkk'ọn-ọtzama, obiro ọhaabh cho. Iwa Ọvaar Ibinọkpaabyi ọkk'ẹ ọda ttara idik biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Wa Abraham oben oho kw'atzọhmnọng p'ẹhọhmmọr chẹ, ọmaana odik kpenamkpen kw'ode kwẹ bi, “Kọ khe ọbọhk kwọ ka ọtzaak kwaam irekhirek. ");
INSERT INTO mfo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Kaam nnori bi anwọhngi ka che ch'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'ẹrọng ọmaana kw'irerek bi, kọ kwanọng k'ottem kw'aminava p'anọng pa Kenaan, pa kaam nnukhi ma ttara, kátzọkha anang nnwa kwaam. ");
INSERT INTO mfo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Yina, kọ áchina k'ẹkhọma chaam, k'anọng paam, atza atzọkha kwanọng anang nnwa kwaam, Isaak.” ");
INSERT INTO mfo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ọtzọhmnọng nwa kwẹ, ọbọbh-ẹ bi, “Idikha kwanọng nwuma onokher bi, ọtzọn-m abẹ okwu m'irek nna khi? Ode bi kaam ńdima nnwa kwọ mkpa nnam k'ẹkhọma chọ o?” ");
INSERT INTO mfo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham oben-ẹ bi, “K'eden kpenamkpen kọ kàkhaambi, atzima nnwa kwaam akpa nnam kẹ. ");
INSERT INTO mfo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ọvaar Ibinọkpaabyi, ode Ibinọkpaabyi kw'ẹrọng. Kẹ wọ otzim-m obina k'ẹhọhmmọr ch'otte kwaam, ọmaana k'ọmmaana-bhon kwaam. Kẹ ọgbaakh-m atzim obiro ọnwọhngi ọnang-m, oben bi, ‘Kaam ńnang va pa va pọ irerek nna.’ Kẹ ọ́tzọhm orenga-eden kwẹ, kw'otzibh-ọ eden ch'arenga ifha atzọkha kwanọng kẹ anang nnwa kwaam. ");
INSERT INTO mfo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Idikha kwanọng nwa on-okher bi ọtzọn-ọ abẹ, ọnwọhngi nwa kọ kọ́bọkha. Yina, kọ nnwa kwaam kàtzima akpa nnam kẹ o.” ");
INSERT INTO mfo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Mando wọ kw'ọtzọhmnọng nwa, okhe ọbọhk kwẹ k'ọtzaak kw'itta kwẹ, Abraham, ọnwọhngi bi kẹ osi-osi mach'itta kwẹ obeni. ");
INSERT INTO mfo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Iwa ọtzọhmnọng nwa ọtzọkha akamẹl jobh p'itta kwẹ, obiro ọtzọkha ekpo ọkkakka k'adem-k'adem p'itta kwẹ, ọnana akamẹl mba. Obina orenga ochina k'Aram-Naharayim, orenga opyiri k'obhon kw'iwa Nahọr orukhi. ");
INSERT INTO mfo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Okwu opyiri ma nchọhkha-bọhk, m'ogbe kwa panọng am-atza akhaabha asi, mando wọ kw'osi akamẹl mba attima ndudungi abaanga esipe ch'ewobh k'obhon ọkhaan-ọkhaan. ");
INSERT INTO mfo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Mẹ wọ, on-ozi njọhm, oben bi, “O Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'itta kwaam, Abraham, si kaam ngaama ọwọbh k'ewu cha mayina, abira asi ọphyaam anang itta kwaam, Abraham. ");
INSERT INTO mfo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Kker e, kaam mbe m'esipe nda ọkhaan-ọkhaan, da aminava p'obhon nwa am-akwu akhaabha asi. ");
INSERT INTO mfo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Tte kwẹ ode bi, isaa mbeni ominanwa bi, ‘Tzotzokhaan, kọ nang-m asi ibebaa m'isi-rọhkha sọ ngwo,’ oben-m bi, ‘Gwo, ifha mbiri ńnang akamẹl pọ,’ tte ode bi, kẹ wọ kw'akk'atzekha anang ọtzọhmnọng kwọ Isaak. Ofona mẹ kaam ńnonga bi, kọ akk'ọphyaam asa anang itta kwaam.” ");
INSERT INTO mfo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Yina okyera njọhm ozizi, Rẹbẹka oyin ka ttara isi-rọhkha ka mbabaang sẹ. Kẹ wa ode ominanwa kwa Bẹtuẹl kw'ode nnwa kw'ijinọng kwa Milka ọmaani ọnang Nahọr, kw'ode ọgbaanọkka kw'Abraham. ");
INSERT INTO mfo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Wa kẹ ojibhi ominanwa, ojinọng otzim oronga. Mando kw'iwa ọhak k'esipe, otzima isi-rọhkha ọkhaabha asi maa sẹ ifu, otzima ovura. ");
INSERT INTO mfo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Iwa ọtzọhmnọng kw'Abraham odukha ọtza okhebh-ẹ, oben bi, “Tzotzokhaan, kebh-m asisaa p'isi-rọhkha sọ, ngwo.” ");
INSERT INTO mfo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Rẹbẹka oben-ẹ bi, “Itta kwaam, tọkha asi agwo.” Ọhakha isi-rọhkha m'ẹbhar-ẹbhar otzima ka mbọhk, ọnang-ẹ asi ogwo. ");
INSERT INTO mfo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Mada ọkk'ẹ asi ọnanga ogwo, on-oben bi, “Kaam ḿbiri ńgaabha nnang akamẹl pọ, bẹ agwo maa bẹ abenga bẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","M'ẹbhar-ẹbhar, ọtza ọwọna asi p'isi-rọhkha k'ọgbaakha, obiro ọrọbh ọkpa nnam k'esipe ọtza ọkhaabha asi ọnang akamẹl pẹ, bẹ agwo maa bẹ abenga bẹ. ");
INSERT INTO mfo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Odik okkoni ojinọng nwa, ọn-ọkhẹ-ẹ otzum, ifha ore s'Ọvaar Ibinọkpaabyi okk'ejibha ọsa, k'orenga kw'ọtza. ");
INSERT INTO mfo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Mada akamẹl akk'asi akyera, ọtzọhmnọng nwa ọtzọkha ẹbaanga cha gol ch'ahung ch'ẹdọhbhi epyiri ẹdọhbh ch'ishẹkẹl-gbokha, obiro ọtzọkha agimma afa pa gol pa mbọhk, p'adọbhi apyiri ẹdọhbh ch'ashẹkẹl jobh. ");
INSERT INTO mfo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ọbọbh-ẹ bi, “Kọ ade ominanwa kw'anyi o? Tzotzokhaan gbaakh-m, na iyimabe iwobha k'ọhọhm kw'atte, sa kaam mfha nyima ttara anọng paam k'erungiwu cha mayina o?” ");
INSERT INTO mfo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rẹbẹka obhin-ẹ bi, “Kaam nde nnwa kwa Bẹtuẹl, kwa Milka ọmaani ọnang Nahọr. ");
INSERT INTO mfo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Maman ọkhaam araraari-bukhi ọmaana ọchattọhk fa nden kẹ k'ọhaabh, fa nden sọ nchi, ọmaana iyimabe sa bọng ayima k'erungiwu cha mayina.” ");
INSERT INTO mfo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Iwa ọtzọhmnọng nwa kw'Abraham ochunga eho, ọnang Ọvaar Ibinọkpaabyi ikpokpobha, ");
INSERT INTO mfo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","oben bi, “Ẹtzọhnga ewobh ẹnang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'itta kwaam, Abraham. Kẹ itta kwaam ọphyaam ọmaana idadaakha sẹ kọrami. Onode kaam, Ọvaar Ibinọkpaabyi ọkk'aam eden otzima bi bẹẹm, nkwu ndim k'ọhọhm kw'anọng p'itta kwaam.” ");
INSERT INTO mfo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Iwa ominanwa nwa ọrọbh ọtza ọgbaak ẹhọhmmọr ch'ọkka idik nna biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Wa Rẹbẹka ọkhaam ọgbaanọkka kw'ijinọng kw'okpen Laban, kw'obin m'ẹbhar-ẹbhar oyin k'iyaan, otza okhebha ojinọng nwa k'esipe. ");
INSERT INTO mfo_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Mada Laban ore ẹbaanga ch'ahung ọmaana agimma p'ọgbaanọkka okhe ka mbọhk, akwu attara k'idik s'ọkk'ọbhaanga sa Rẹbẹka ọgbaakhi okhuri ojinọng nwa, on-obina otza okhebha ojinọng nwa kẹ da obe ttara akamẹl, ọbaanga esipe. ");
INSERT INTO mfo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Oben bi, “Kọ kwu, kọ kw'Ọvaar Ibinọkpaabyi ọkk'ọda, ode yan kw'atzima abe k'iyaan o? Kwu mofona, kkeri kaam nkk'ibe nda nhokh-ọ, ọmaana ibe s'akamẹl abira awobha.” ");
INSERT INTO mfo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Mẹ wọ, ojinọng nwa ochina k'ọhọhm, bẹ achaari akamẹl ndọhkha, bẹ anang bẹ araraari-bukhi ọmaana ọchattọhk fa nden, bẹ abira anang ojinọng nwa ttara anọng p'atzọn-ẹ abẹ asi, bẹ agbobhi mmo sabẹ. ");
INSERT INTO mfo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Bẹ abera bẹ ochattọhk, yina oben bi, “Kaam ọchattọhk kinchi maa, mgbaak bọng odik kwa ngaam bi, mgbaak.” Laban oben-ẹ bi, “Kọ gbaak man.” ");
INSERT INTO mfo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Mẹ wọ, oben bi, “Kaam nde ọtzọhmnọng kw'Abraham. ");
INSERT INTO mfo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ọvaar Ibinọkpaabyi okk'itta kwaam ẹdaa ch'ideden ọnanga maa, on-ode ọkkọkkaa. Ọvaar Ibinọkpaabyi ọkk'ẹ arukhimaan, ọmaana abhaam, ọmaana silva, ọmaana gol, ọmaana atzọhmnọng p'ijinọng ttara p'ipanọng, ọmaana akamẹl ttara nnyanyaang ọnanga. ");
INSERT INTO mfo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara kw'ode kwanọng kw'itta kwaam, okk'ẹ nnwa kw'ijinọng ọmaana k'atzam. Itta kwaam okk'ẹkhakhaama chẹ biphyir ọtzọkha ọnang nnwa nwa. ");
INSERT INTO mfo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Itta kwaam osi-m ndọkha ọnwọhngi, oben bi, ‘Kọ kàkhaambi atzọkha kwanọng k'aminava p'anọng pa Kenaan, pa kaam nnukhi ma ttara, anang nnwa kwaam. ");
INSERT INTO mfo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Yina, kọ rọhng k'efona chaam, ọmaana k'ẹnọmma chaam, atza atzọkha kwanọng anang nnwa kwaam.’ ");
INSERT INTO mfo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Mẹ wọ, kaam mbọbh itta kwaam bi, ‘Kaam nsi yan, idikha kwanọng nwa onokher bi, ọtzọn-m abẹ?’ ");
INSERT INTO mfo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Itta kwaam obhin-m bi, ‘Ọvaar Ibinọkpaabyi kwa kaam nkk'mkpobha k'eden ọkkakka, ọ́tzọhm orenga-eden kwẹ otzim-ọ eden, ọnang-ọ owujibha k'orenga kwọ, ifha kọ afha atzọkha kwanọng k'efona ch'otte kwaam, k'ẹnọmma chaam, anang nnwa kwaam. ");
INSERT INTO mfo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ọnwọhngi nwa kọ kọ́bọkha, idikha achin k'ẹnọmma chaam, kaambi ode bi, bẹ kọ ominanwa nwa kanangi, ọnwọhngi nwa kọ kọ́bọkha e.’ ");
INSERT INTO mfo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Mẹ wọ e, mada mpyiri m'esipe nda mayina, mben bi, ‘O Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'itta kwaam, Abraham, idikha ode ochibhi kwọ, tzotzokhaan, nang-m owujibha m'orenga nwa kwa nkk'nkwa ma o. ");
INSERT INTO mfo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Kker e, kaam mbe m'esipe nda ọkhaan-ọkhaan, idikha ominanwa kw'obhon nwa okwu bi okwu akhaabha asi, mben-ẹ bi, “Tzotzokhaan kọ nang-m asi m'isi-rọhkha sọ ngwo ibebaa,” ");
INSERT INTO mfo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","idikha oben-m bi, “Kọ gwo, kaam ḿbiri ńgaabha nnang akamẹl pọ,” tte kẹ ode ominanwa nwuma kw'Ọvaar Ibinọkpaabyi okk'otzekha ọnang nnwa kw'itta kwaam.’ ");
INSERT INTO mfo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Yina nkyera njọhm ozizi k'ettem chaam, Rẹbẹka oyin ka ttara isi-rọhkha sẹ k'ẹbabaang, ọhakha k'esipe, ọtza ọkhaabha asi. Kaam mben-ẹ bi, ‘Tzotzokhaan nang-m asi ngwo.’ ");
INSERT INTO mfo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“M'ẹbhar-ẹbhar, ọhakha isi-rọhkha k'ẹbabaang, oben bi, ‘Kọ gwo, mbiri ńgaabha nnang akamẹl pọ.’ Mẹ wọ, kaam ngwo, obiro ọkhaabha ọnang akamẹl paam. ");
INSERT INTO mfo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Kaam mbọbh-ẹ bi, ‘Kọ ade ominanwa kw'anyi o?’ “Obhina bi, ‘Kaam nde nnwa kwa Bẹtuẹl, kwa Nahọr obhoni ka ndaak sa Milka.’ “Mẹ wọ, kaam ngẹ-ẹ ẹbaanga ka hung, mbiri ngẹ-ẹ agimma ka mbọhk sẹ. ");
INSERT INTO mfo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Nchunga eho mkpobha Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'itta kwaam, Abraham, kw'ọkk'aam eden otzima k'eden-ọkkakka maa, nkwu ndọkha nnwa-mmona kw'ọgbaanọkka kw'itta kwaam, nnang nnwa kwẹ-ẹ k'ọbada. ");
INSERT INTO mfo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Mẹ wọ, idikha ási ọphyaam f'odik-ọkka osi anang itta kwaam, gbaakh-m. Idikha án-asi, gbaakh-m, ifha nnonga eden cha ńsi.” ");
INSERT INTO mfo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban ọmaana Bẹtuẹl abhina bi, “Mada idik nna biphyir ifon k'Ọvaar Ibinọkpaabyi, maman odik kw'ojibh-ojibh ttara kw'opyibh-opyibh kọkhaam kwa mọfha ọgbaak. ");
INSERT INTO mfo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Kkeri Rẹbẹka manya, tzọkh-ẹ atzima rọhng. Tte kẹ on-ode kwanọng kwa nnwa kw'itta kwọ, mach'Ọvaar Ibinọkpaabyi obeni.” ");
INSERT INTO mfo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Mada ọtzọhmnọng kw'Abraham ọbhaang odik kwa bẹ agbaakhi, ochunga eho k'irerek, ọnang Ọvaar Ibinọkpaabyi ikpokpobha. ");
INSERT INTO mfo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Mẹ wọ, ọtzọhmnọng nwa ọrọbha ẹfanginẹkpo pya gol ọmaana pya silva, okwu ọttara k'ọbara k'adem-k'adem, ọnang Rẹbẹka. Obiro tzọkha ekpo py'epe agbukha ọnang ọgbaanọkka kw'ijinọng ọmaana ọkka kwa Rẹbẹka. ");
INSERT INTO mfo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Kẹ ọmaana anọng p'atzọn-ẹ abẹ achi ọchattọhk abira agwo atzuk, bẹ abira ayima mẹ maa, ewu ehobha. Mada bẹ aphyọbh k'ekpebha, oben bi, “Bọng dọhm-m mmana, ifha mkpa nnam ndor itta kwaam.” ");
INSERT INTO mfo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Yina, ọgbaanọkka kwa Rẹbẹka ọmaana ọkka an-abhina bi, “Tte ominanwa nwa owobha ttara man k'iwu jobh yina bọng atzọn afona.” ");
INSERT INTO mfo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Yina, ọtzọhmnọng nwa obhina bẹ bi, “Bọng kaam ka bọkha akhok manya, da Ọvaar Ibinọkpaabyi okk'orenga kwaam ọsa ojibh. Bọng dọhm-m mmana ifha mkpa nnam ndor itta kwaam.” ");
INSERT INTO mfo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Mẹ wọ, bẹ an-aben bi, “Tte moyeri ominanwa ọkhaam, ifha mọbhaanga ka kẹ dọk.” ");
INSERT INTO mfo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Wa bẹ ayeri Rẹbẹka abọbh-ẹ bi, “Na ọdaakh-ọ bi átzọn ojinọng nwa abẹ afona o?” Obhina bi, “Kaam ọdaakh-m kẹ bi, ndọn-ẹ abẹ mfona e.” ");
INSERT INTO mfo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Mẹ wọ, bẹ atza arik ọgbaanọkka kwabẹ, Rẹbẹka k'eden, ọmaana ọrọrọkha kwẹ, ọmaana ọtzọhmnọng nwa kw'Abraham, ttara anọng p'atzọn-ẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Bẹ abira asi Rẹbẹka ittabọhng, aben-ẹ bi, “Ọgbaanọkka kwaman, tte ọmaan ojibh-ọ, amaan va k'ọhaabh. Tte va pa va pọ ade nnọhna nabhik. Tte va pa va pọ atzọkha idedenmon s'attattaanga-nọng pabẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Mẹ wọ, Rẹbẹka ọmaana aminava p'arukh-ẹ abẹ, ado for avura akamẹl, atzọn ọtzọhmnọng kw'Abraham abẹ. Mando kw'ọtzọhnmnọng nwa otzim abaRẹbẹka ofona. ");
INSERT INTO mfo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Iwa Isaak kw'orukhi k'okhubha kwa Nẹgẹv okk'ofona ka Beer-Lahai-Roi okhuna. ");
INSERT INTO mfo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Wa k'ẹchọhkhawu dani, Isaak ofona ochina k'owoni bi, ọtza ọtzọkha ọphapha. Mada otzini chen okkeri k'ororo, ore da akamẹl am-akwu. ");
INSERT INTO mfo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rẹbẹka obiro otzini chen okkeri k'ororo ore Isaak, mando kw'ọhak ka kamẹl kwẹ, ");
INSERT INTO mfo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ọbọbh ọtzọhnmnọng nwa bi, “Bọng ojinọng wọ kana kw'om-orenga otzor man ka o?” Ọtzọhmnọng nwa obhina bi, “Itta kwaam wọ ẹ.” Mando kwa Rẹbẹka ọtzọk ọphyọhng kwẹ obubha k'itzitzikha sẹ. ");
INSERT INTO mfo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Mẹ wọ, ọtzọhmnọng nwa ọgbaak Isaak idik s'ọkk'ọsa biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaak otzim-ẹ odim k'ikhira s'ọkka kwẹ Sara, kw'ọkk'ọpa. Rẹbẹka on-ode kwanọng kw'Isaak. Isaak ọkhọhkha Rẹbẹka idadaakha, otzima mẹ odini for sẹ ettem k'obo kw'ọkka kwẹ. ");
INSERT INTO mfo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Wa Abraham okwu ọtzọkha kwanọng ọdọdọk kw'okpen Kẹtura. ");
INSERT INTO mfo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Kẹ wọ ọmaan-ẹ Zimran, ọmaana Jọkshan, ọmaana Medan, ọmaana Midiyan, ọmaana Ishbak ttara Shua. ");
INSERT INTO mfo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jọkshan wa ode otte kwa Sheba ọmaana Dedan; va pa va pa Dedan ade abAshur, ọmaana abaLẹtush, ttara abaLeum. ");
INSERT INTO mfo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Va p'ijinọng pa Midiyan ade Ẹpha, ọmaana Ẹphẹr, ọmaana Hanọk, ọmaana Abida, ttara Ẹlda. Va mba biphyir wa bẹ ade va pa va pa Kẹtura. ");
INSERT INTO mfo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Wa Isaak ọtzọk ekkema k'ẹkhakhaama chẹ biphyir ch'Abraham ope oji. ");
INSERT INTO mfo_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Yina, Abraham ọn-ọbhaangi va mbonggo pẹ biphyir, p'akkọra-panọng oruk, ttara ekpo pyẹ ẹdọdọk, oben bẹ akhọm aruk achina k'okhubha kw'ewuchen em-eyin, abhir Isaak eden. ");
INSERT INTO mfo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Biphyir-phyir wa Abraham orukhi cho arọbh azenanttaan obhiri chi. ");
INSERT INTO mfo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Mẹ wọ, wa Abraham oji ikponga-nnam-wọhng sẹ, ope k'atzam, bẹ anọhng-ẹ otzor anọng pẹ p'akk'apa. ");
INSERT INTO mfo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Wa nnwa kwẹ Isaak ọmaana Ishimayẹl, anọhnga otte kwabẹ, k'ọmma kw'itzakpa kw'owobh ka Makpẹla, ọbaanga Mamrẹ, k'irerek s'iwa ide s'Ẹphrọn, kw'ode nnwa kwa Zoha kw'ofon Het. ");
INSERT INTO mfo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Wa Abraham odebhi irerek nna ka mbọhk s'anọng pa Het. Wa bẹ anọhnga Abraham m'ibe nna rani s'iwa bẹ anọhng kwanọng kwẹ, Sara. ");
INSERT INTO mfo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Mada Abraham ọkk'ọpa, Ibinọkpaabyi odo nnwa kwẹ Isaak, kw'iwa on-orukhi ọbaanga Beer-Lahai-Roi. ");
INSERT INTO mfo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ma wọ ode efonamma ch'Ishimayẹl, kw'ode nnwa kw'Abraham obhoni ka ndaak sa Hagar kw'ofon Ijip, kw'iwa ode obira kwa Sara. ");
INSERT INTO mfo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ma wọ ode che pa va p'Ishimayẹl k'odem kw'obhoni bẹ: Nẹbayọt kw'ode ocheden-nwa, ọmaana Kẹda, ọmaana Adbẹl, ọmaana Mibsam, ");
INSERT INTO mfo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ọmaana Mishma, ọmaana Duma, ọmaana Masa, ");
INSERT INTO mfo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ọmaana Hadad, ọmaana Tẹma, ọmaana Jetur, ọmaana Naphish, ttara Kẹdẹma. ");
INSERT INTO mfo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ma wọ iwa ode va p'ijinọng p'Ishimayẹl p'adabhi ngọma jobh obhiri mfa, sa mkpen che mmina bẹ, atzor k'aruk pabẹ ọmaana k'obhingabe fabẹ. ");
INSERT INTO mfo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Biphyir-phyir wa Ishimayẹl orukhi cho arọbh azadani obhiri chi obhiri afa, ope, bẹ anọhng-ẹ otzor anọng pẹ p'akk'apa. ");
INSERT INTO mfo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Wa va pa va pẹ arukhi ttẹwọr k'okhubha kwa Havila maa, apyiri k'okhuba kwa Shur, kw'owobh ọbaanga k'enem ch'Ijip, kẹ da achin k'okhubha kw'Ashur. Wa bẹ arukhi k'ittattaanga ttara votte pabẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ma wọ ode efonamma ch'Isaak, kw'ode nnwa kw'Abraham. Abraham wọ iwa obhoni Isaak. ");
INSERT INTO mfo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Iwa Isaak ode cho arọbh afa, k'ogbe kw'ọtzọk Rẹbẹka k'ọbada. Rẹbẹka ode nnwa kwa Bẹtuẹl kw'ofon Aram, kwa Padan-Aram, obiro ode ọgbaanọkka kwa Laban kw'ofon Aram. ");
INSERT INTO mfo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Wa Rẹbẹka ọkpaan-ọkpaana, mẹ wọ, Isaak ozi njọhm ọnang Ọvaar Ibinọkpaabyi k'eho chẹ. Ọvaar Ibinọkpaabyi ọbhaanga njọhm sẹ, osi Rẹbẹka otzima ibhọr. ");
INSERT INTO mfo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Wa va afa p'awobh-ẹ k'ẹbhọr am-arima ayok abẹ. Mẹ wọ, Rẹbẹka ọbọbh bi, “Bọng odik wọ om-okhebh-m ma o?” Mando kw'orori odik nwa ọbọbh Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ọvaar Ibinọkpaabyi obhin-ẹ bi, “Ngọma mfa rọ nwobh-ọ mẹ ẹbhọr, ngọma nna mfa s'iwobh-ọ m'ẹbhọr, ikhina sẹ ḿmaangi ayok, ẹkhọma dani ẹ́khaama ẹfa ẹyọhnga oyok. Ẹkhọma ch'echi eden ẹmmaana, ési ọtzọhm ẹnang ẹkhọma ch'ekpong nnam.” ");
INSERT INTO mfo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Mada ogbe opyiri kw'ọmaan, va p'ijinọng afa bọ awobh-ẹ k'ẹbhọr. ");
INSERT INTO mfo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Nnwa kw'ochi eden oyin okhor-okhor, ttara iphyubha ka for mach'ẹnọhmakpa ch'ede iphyubha-iphyubha. Mẹ wọ, bẹ akpẹ-ẹ Ẹsau. ");
INSERT INTO mfo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Mada ocheden okk'oyina, ọgbaanọkka obiro oyin, ọbọkha Ẹsau k'ibhokhọkhọri. Mẹ wọ, bẹ an-akpẹ-ẹ Jekọb. Wa Isaak on-ode cho arọbh attaan, k'ogbe kwa Rẹbẹka ọmaani va mba. ");
INSERT INTO mfo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Mada va mba akk'abara, Ẹsau okwu ode ọgbaajijaa kw'ideden, obiro ode ọnọng kw'orukhi k'ọyaankpa. Yina, Jekọb kẹ ode ọnọng kw'odiri akpen, kw'om-okwora k'ẹttọhmma. ");
INSERT INTO mfo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Wa Isaak kẹ ọdaakhi ẹgbatzen ochichi, ofona mẹ, Ẹsau kw'ode ọgbaajijaa ọdaakh-ẹ idik. Yina, wa Jekọb wọ ọdaakhi Rẹbẹka. ");
INSERT INTO mfo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","K'ogbe wani kw'iwa Jekọb ọm-ọwọhn ọchattọhk, Ẹsau ofona k'ẹgbaaji okhuna, ttara okwo f'ọkk'ẹ ọkhaama maa, for imọm-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Mẹ wọ, oben Jekọb bi, “Kebh-m ẹbọhnga nduma ch'ekhor-okhor nchi ẹbhar-ẹbhar, kkeri ẹfa ẹkk'aam ẹha itzam-itzama!” (Mẹ wọ ofon bẹ am-ayer-ẹ Edom). ");
INSERT INTO mfo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jekọb obhin-ẹ bi, “Kọ chi eden anang-m ededen chọ ch'ocheden-nwa.” ");
INSERT INTO mfo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ẹsau on-obhin-ẹ bi, “Bọng ejibha ch'ededen ẹnang-m o, kwa kaam nwobha ma, okwo ofhu-m o?” ");
INSERT INTO mfo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yina, Jekọb oben bi, “Kọ chi eden chekhi bi, anang-m ededen chọ ọnang.” Mẹ wọ, Ẹsau ọtzọkha ọnwọhngi kw'ọnangi Jekọb ededen chẹ. ");
INSERT INTO mfo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Mando kwa Jekọb ọtzọk brẹd ọttara k'ẹbọhnga ch'achen-meni ọnang Ẹsau, Ẹsau ochi obiro ọttaakhi ẹbọhnga, obina ofona. Mando wọ kw'iwa Ẹsau oreng olukhi ededen chẹ ch'ocheden-nwa. ");
INSERT INTO mfo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","M'ogbe nwa, wa okwo f'ideden owobh m'irek nna akhiri okwo f'ideden f'iwa ochi eden owobha k'ogbe kw'Abraham. Wa Isaak obina ochina ka Gẹra ọtza okhebha Abimẹlẹk kw'ode ọvaarnọng kw'ẹkhọma cha Philistiya. ");
INSERT INTO mfo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Mẹ wọ, Ọvaar Ibinọkpaabyi oyin Isaak abẹ, oben-ẹ bi, “Kọ k'Ijip kahakha o. Kọ ruk m'irek nna sa mben ọ bi, aruk. ");
INSERT INTO mfo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Kọ ruk m'irek nna k'igbegbaa bi kọbh, kaam Ibinọkpaabyi ńwobha ttar-ọ, ḿbiri ndọ-ọ. Kaam ńdọkha irerek nna biphyir ńnang kọ, ọmaana va pa va pọ. Ḿbiri nsi idik s'iwa nchekhi nnang atte kwọ, Abraham. ");
INSERT INTO mfo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Kaam Ibinọkpaabyi ńsi va pa va pọ ahaabh macha ndodori s'ọrọngkpakpa, ḿbiri nnang bẹ irerek nna biphyir. Orenga ka nnam sa va pa va pọ, idibhon biphyir íkhaama ẹdaa, ");
INSERT INTO mfo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","okhuri da, Abraham ọhak eho ọnang-m, osi odik kpenamkpen mach ndọhn ẹ. Obiro ohok asana paam, ọmaana akpebhi paam, ndọhna saam ttara aphaangi paam.” ");
INSERT INTO mfo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Mẹ wọ, Isaak owobha ka Gẹra. ");
INSERT INTO mfo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Mada ajinọng p'obhon nwuma an-abọbh-ẹ odik okhuri kwanọng kwẹ, okhuri ojora, ọn-ọgbaak bẹ bi, “Kẹ ode ọgbaanọkka kwaam.” Ochibhi k'ettem bi, “Ajinọng p'obhon nwa afha afhu-m, okhuri ajibhada pa Rẹbẹka.” ");
INSERT INTO mfo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Mada Isaak okk'orukha mẹ k'ogbe-bhirada, Abimẹlẹk kw'ode ọvaarnọng kw'ẹkhọma cha Philistiya orenga k'ọphapha-mma, ore da Isaak om-osi idadaakha ttara kwanọng kwẹ, Rẹbẹka. ");
INSERT INTO mfo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Mando kw'Abimẹlẹk oyeri Isaak oben-ẹ bi, “K'odik-ọkka, kwanọng kwọ wọ manya e. Kọ areng mbọng afẹ agbaakh-m bi, kẹ ode ọgbaanọkka kwọ o?” Isaak obhin-ẹ bi, “Nchibhi bi, bẹ afha afhu-m ofhu, okhuri kẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Iwa Abimẹlẹk ọbọbh-ẹ bi, “Osi yan kw'asi odik-dema nwa? Idikha ira ọnọng wani k'ottem kw'ajinọng p'obhon nwa, okk'kwanọng kwọ abẹ oyima, ira akk'man oponga-pyibha anana k'eho.” ");
INSERT INTO mfo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Mando kw'Abimẹlẹk ọnangi ọsana makhọra obhon bi, “Ọnọng manda wani kw'osi ojinọng nwa ttara kwanọng kwẹ ọttọhk m'obhon nwa, bẹ akhaambi, afhẹ-ẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ma cho nwuma wani, Isaak ọyaabha owoni m'irerek nna, ọpha ekpo p'ọyaabh k'ọhaabh, okhuri da Ọvaar Ibinọkpaabyi ọdẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Wa okwu ọkhaama ẹkhakhaama. Ojibhada kwẹ ochina ororo ọbar maa, ọn-ọkhaama ikkọ k'ọhaabh. ");
INSERT INTO mfo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Wa ọkhaam etzirakpo k'ọhaabh, ọmaana atzọhmnọng k'ọhaabh maa, ettem ẹmma anọng pa Philistiya etzima etzor-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Mẹ wọ, nsipe s'iwa atzọhmnọng p'otte akk'atzuma, k'ogbe kw'otte Abraham owobh k'akpen, anọng pa Philistiya akpa sẹ biphyir ttara idọdọhbh. ");
INSERT INTO mfo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Iwa Abimẹlẹk oben Isaak bi, “Bina, aji obhon kwaman, akk'ẹfa an-akhaama kpọng-kpọng ayọhnga man.” ");
INSERT INTO mfo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Mẹ wọ, Isaak obina mẹ, ọtza oruk k'Ẹttẹri cha Gẹra. ");
INSERT INTO mfo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Obiro otzum nsipe nnuma s'anọng pa Philistiya akk'akpa, k'ogbe kw'Abraham ọkk'ọpa. Okpe sẹ che p'iwa otte Abraham okk'sẹ ọtzam ọnanga. ");
INSERT INTO mfo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Yina, mada atzọhmnọng p'Isaak, abira atzum esipe ọdọdọk k'ẹttẹri maa, bẹ ayin k'esipe ch'asi akkakka p'abhobh-obhobh, ");
INSERT INTO mfo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","akkeri-etzirakpo p'obhon kwa Gẹra, attẹwọr asi ẹtta ọmaana akkeri-nden p'Isaak, bẹ aben bi, “Asi mba ade paman!” Ofona mẹ, okpe ẹsipe nda Ẹsẹk, okhuri da bẹ akkaan esipe nda ttara kẹ. ");
INSERT INTO mfo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Bẹ abira atzum ẹsipe ẹdọdọk, yina, bẹ abira asi ẹkhọhr okhuri esipe nda. Isaak okpe chẹ Sitina. ");
INSERT INTO mfo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Obina mẹ, ọtza otzum esipe ẹdọdọk, ọnọng kw'osi ẹkhọhr kode. On-okpe chẹ Rehobot, oben bi, “Ọvaar Ibinọkpaabyi okk'man ọphaangi ọnanga. M'irerek nna rọ sa mówobha mosi ikkọ.” ");
INSERT INTO mfo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Isaak on-obina mẹ ochina k'obhon kwa Bẹrshẹba. ");
INSERT INTO mfo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","M'erungiwu nduma, Ọvaar Ibinọkpaabyi oyin-ẹ abẹ, oben-ẹ bi, “Kaam wọ nde Ibinọkpaabyi kw'atte Abraham. Oning-ọ ojor, kaam nwobh ma ttar-ọ, kaam ndọ-ọ, mbiri nsi va pa va pọ ahaabh, okhuri echekhi cha ngaam ttara ọtzọhmnọng kwaam, Abraham.” ");
INSERT INTO mfo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Iwa Isaak osi ijafọhnibe mẹ, owobha mẹ okpobha Ọvaar Ibinọkpaabyi obiro ottima ikhira sẹ mẹ, atzọhmnọng pẹ abira atzum esipe mẹ. ");
INSERT INTO mfo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","M'ogbe nwa, Abimẹlẹk okk'Ahuzat kw'ọm-ọtzọhn-ẹ atzim ọmaana Phikol kw'ode odenho kw'agbong-nọng, otzima obina ka Gẹra okwu. ");
INSERT INTO mfo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaak ọbọbh bẹ bi, “Ode yan kwa bọng am-aror-m, kw'iwa bọng attaang-m maa bọng akhubh-m k'obhon kwabọng o?” ");
INSERT INTO mfo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Bẹ abhina bi, “Mọkk'ọra k'odik-ọkka bi, Ọvaar Ibinọkpaabyi owobh ttar-ọ. Ofona mẹ, moben bi, ọbaan bi, echekhi ewobha k'ottem kwa kọ ọmaana maman. Tte mosi echekhi ttar-ọ ");
INSERT INTO mfo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","bi, kọ man itzama kási, mach'iwa maman ọnọ-ọ itzama osi, yina, mojibh akpen ttar-ọ maa, mottọ-ọ ọbọhk abina k'odidiri. Manya, Ọvaar Ibinọkpaabyi ọkk'ọ ọda.” ");
INSERT INTO mfo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Mẹ wọ, Isaak ohok bẹ ewobha ch'ọdadaami, bẹ achi, abira agwo. ");
INSERT INTO mfo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","K'ekpekpebha ch'ewu ekhobh mẹ, bẹ atzọkha ọngwọhngi ttara ayok. Mẹ wọ, Isaak ọtza orik bẹ k'eden, bẹ akpa nnam abhana k'odidiri. ");
INSERT INTO mfo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","M'ewu nduma, atzọhmnọng p'Isaak akwu agbaakh-ẹ odik kw'okhuri esipe cha bẹ akk'atzuma. Bẹ aben bi, “Mokk'asi ọra e” ");
INSERT INTO mfo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Mẹ wọ, Isaak oyeri esipe nda Shiba, ttẹwọr mẹ ewu nduma obhon nwuma on-okpena Beershẹba. ");
INSERT INTO mfo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Mada Ẹsau on-ode cho arọbh afa, ọtzọk kwanọng kw'okpen Judit kw'ode ominanwa kwa Beeri kw'ode ojinọng kw'ofon Het, ọmaana Basemat kw'ode ominanwa kw'Ẹlọn kw'obiro ofona Het. ");
INSERT INTO mfo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Panọng mba afa, asi akpen akhọhn Isaak ọmaana Rẹbẹka. ");
INSERT INTO mfo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","K'ogbe kw'iwa Isaak ọkk'ọn-ọtzama, owonikpa dọk kore, wa oyeri ocheden-nwa kwẹ, Ẹsau, oben-ẹ bi, “Nnwa kwaam.” Ẹsau obhina bi, “Itta kwaam, kkeri kaam ma e.” ");
INSERT INTO mfo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaak oben bi, “Kaam nnande ọtzaminọng, ebowu chaam kimbiri nnonga. ");
INSERT INTO mfo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Mẹ wọ, kọ tzọkha ẹgbaajikpo pyọ py'ede ọkhọhn-pa kwọ ọmaana oyuk kwọ, atzima ayin ẹgbaaji, atza afhu nden achen-m. ");
INSERT INTO mfo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Si ọchattọhk f'ọdaam-ọdaam f'ọdaakh-m, achen-m nchi, ifha nsọ-ọ ittabọhng yina ḿpe.” ");
INSERT INTO mfo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Wa Rẹbẹka om-oyonga itzọhng ọbhaanga idik s'Isaak ọm-ọgbaak nnwa kwẹ, Ẹsau. Mada Ẹsau okk'ẹgbaaji oyina bi ọtza ofhu nden otzima okhuna, ");
INSERT INTO mfo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rẹbẹka ọbhakhi kẹ ọtza oben nnwa kwẹ Jekọb bi, “Kker e, mfhu mmaang da atte om-oben agbaanakka Ẹsau mẹ bi, ");
INSERT INTO mfo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Rọhng atza afhu nden, atzima asi ọchattọhk f'ọdaam-ọdaam anang-m nchi, ifha nsọ-ọ ittabọhng k'itzitzikha s'Ọvaar Ibinọkpaabyi, yina ḿpe.’ ");
INSERT INTO mfo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Nnwa kwaam, tzọkha ogbe ayong-m itzọhng, asi odik kwa mgbaakh-ọ. ");
INSERT INTO mfo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Rọhng kẹ da avu awobh, atzekha avu adem akkakka manda afa p'ajibhi for, ifha ndima nsi ọchattọhk f'ọdaam-ọdaam, nnang atte mach'ọm-ọdaakh-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Kọ tzọkha fẹ chena atte ochi, ifha ọsọ-ọ ittabọhng yina ópe.” ");
INSERT INTO mfo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jekọb on-oben ọkka bi, “Ọgbaanọkka kwaam Ẹsau ọkhaam iphyubha s'ihaabh-ọhaabh ka for, yina, kaam nkwọhng ẹkpakpa. ");
INSERT INTO mfo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Idikha otte kwaam ọn-ọttọhm-m ki? Okher mana kaam mbọhr-ẹ ọbọhra, kw'ọsẹ-ẹ ọn-ọnang-m ẹmma ottu kw'osi-m ittabọhng.” ");
INSERT INTO mfo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ọkka on-oben-ẹ bi, “Nnwa kwaam, tte ẹmma ch'atte ọnang-ọ ẹbọkha kaam e. Si macha mben-ọ, rọhng, atza atzọkha avu pa ndọhm-ọ, achen-m.” ");
INSERT INTO mfo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Mẹ wọ e, Jekọb ofona ọtza tzọkha avu ochena ọkka. Ọkka otzima bẹ osi ọchattọhk f'ọdaam-ọdaam macha fẹ ọm-ọdaak otte. ");
INSERT INTO mfo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rẹbẹka ọtzọkha nnya nkkakka s'ocheden-nwa kwẹ kw'ode Ẹsau, ọfọra Jekọb kw'ode okponga-nnam-nwa kwẹ. ");
INSERT INTO mfo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","On-obiro ọtzọkha ndenkpa s'avu k'adem-k'adem sa ngaam ophyubha obubh-ẹ ka mbọhk, ọmaana k'obe vani f'ọkwọhng-ọkwọhnga f'ẹdọhngi chẹ. ");
INSERT INTO mfo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Mẹ wọ, ọn-ọtzọkha ọchattọhk daama-ndaam mvuma, ọttara ka brẹd kw'ọkk'ọsa, ọnang nnwa kwẹ Jekọb. ");
INSERT INTO mfo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Mando kwa Jekọb ofon ochina k'otte, oben bi, “Itta kwaam.” Otte obhina bi, “O o! Nnwa kwaam, kọ anyi wọ o?” ");
INSERT INTO mfo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jekọb obhin-ẹ bi, “Kaam ocheden-nwa kwọ Ẹsau wọ e, nkk'nsa mach'aben-m bi, nsi e. Tzotzokhaan, bina wobha ẹwọr achi ọchattọhk, ifha asi-m ittabọhng, sọ e.” ");
INSERT INTO mfo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaak ọbọbh nnwa bi, “Nnwa kwaam, areng yan are etzen ẹbhar-ẹbhar mando?” Jekọb obhina bi “Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwọ, kẹ wọ ọnang-m owujibha e.” ");
INSERT INTO mfo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Mẹ wọ, Isaak oben Jekọb bi, “Rọkhi atzor-m ka for ifha nttọhm-ọ, ifha mbiri nnonga k'odik-ọkka s'ode kọ nnwa kwaam Ẹsau wọ.” ");
INSERT INTO mfo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Mẹ wọ, Jekọb ọrọkhi otzor otte Isaak ka for, kw'ọttọm-ẹ, oben bi, “K'ọwọhng akheri Jekọb, yina, mbọhk sọ nde macha mbọhk s'Ẹsau.” ");
INSERT INTO mfo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Wa Isaak, Jekọb kotzini, okhuri bi, wa mbọhk sẹ nde ophyubh-ophyubha macha s'Ẹsau. Ofona mẹ, Isaak ọsẹ-ẹ ittabọhng. ");
INSERT INTO mfo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","On-obiro ọbọbh-ẹ bi, “Kọ nnwa kwaam Ẹsau wọ, k'odik-ọkka o?” Jekọb obhin-ẹ bi, “Itta, kaam wọ e.” ");
INSERT INTO mfo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Mẹ wọ e, on-oben bi, “Nnwa kwaam, chen-m ọchattọhk fọ nchi, ifha nsọ-ọ ittabọhng saam.” Jekọb ochen-ẹ ọchattọhk ochi, obiro ọnang-ẹ atzuk ogwo. ");
INSERT INTO mfo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Mando kw'Isaak oben-ẹ bi, “Nnwa kwaam, kwu baakh-m.” ");
INSERT INTO mfo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Jekọb ọrọkhi otzor otte ka for, ọbaakh-ẹ. Mada Isaak ọbhaang eruk ch'ẹnya ch'ọfọr ka for, on-okhera bi, Ẹsau wọ, ọsẹ-ẹ ittabọhng, oben bi, “K'odik ọkkakka eruk cha nnwa kwaam ede mach'eruk ch'owoni kw'Ọvaar Ibinọkpaabyi ọkk'ọda. ");
INSERT INTO mfo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Tte Ibinọkpaabyi osi ẹrọng etzebh, obiro osi irek s'ayaabh ekpo ijibh, tte kẹ ọnang-ọ ọchattọhk ọmaana atzuk k'ọhaabh. ");
INSERT INTO mfo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Tte idibhon biphyir isi ọtzọhm inang-ọ, anọng biphyir ahakha nho anang-ọ. Kọ wọ áde ọvaarnọng kwa vọkka pọ, tte echimma chọ ẹhakha eho ẹnang-ọ. Tte ẹmma ẹbhakhi ẹbọkha anọng p'anang-ọ ẹmma, tte ẹdaa ebire éwobha ẹnang anọng p'adọ-ọ.” ");
INSERT INTO mfo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Mada Isaak okk'Jekọb ittabọhng ọsa okyera, Jekọb ofona. Obin k'otte k'itzitzakha bi kpaarr, ọgbaanọkka Ẹsau okhuna ẹgbaaji. ");
INSERT INTO mfo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Wa Ẹsau obiro osi ọchattọhk f'ọdaam-ọdaam ọtzọkha ochena otte. Mẹ wọ, oben-ẹ bi, “Itta, tzotzokhaan bina achi ọttọhk fa nnwa kwọ, ifha asi-m ittabọhng sọ.” ");
INSERT INTO mfo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Otte Isaak ọbọbh-ẹ bi, “Kọ anyi wọ?” On-obhina bi, “Kaam nnwa kwọ Ẹsau kw'ode ocheden-nwa kwọ wọ e.” ");
INSERT INTO mfo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaak ọfhọni ka for bi tzikhi-tzikhi, oben bi, “Anyi wọ ọn-ọtza ofhu nden otzima osi ọchattọhk ọnang-m o? Nchi fẹ, yina an-adimi ma e, nkk'ẹ ittabọhng mbiri nsa e. K'odik-ọkka, kẹ ójibh-ẹ ojibh e!” ");
INSERT INTO mfo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Mada Ẹsau ọbhaang idik s'otte ọgbaakhi, otzini adimmọng obhom k'idọdọkhi, oben otte kwẹ bi, “Itta kwaam, si-m ittabọhng, biri si kaam ittabọhng!” ");
INSERT INTO mfo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Yina, otte obhin-ẹ bi, “Agbaanakka ọkk'ọkwa, ọkwu ọbọhr-m, nsẹ-ẹ ittabọhng sọ e.” ");
INSERT INTO mfo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ẹsau on-oben bi, “Bẹ atzor-otzor akpẹ-ẹ Jekọb. Igbe ifa rọ ma s'okk'aam chen ọsa. K'ochedengbe, ọtzọk ededen chaam ch'ocheden-nwa. Manya, kẹ okk'ittabọhng saam obiro ọtzọkha.” Mẹ wọ ofon, Ẹsau ọn-ọbọbh otte bi, “Ode bi, kọ kaam ittabọhng manda rani karikh o?” ");
INSERT INTO mfo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaak obhina Ẹsau bi, “Kaam nkk'ẹ ittabọhng nsa bi, ode oho kw'idibhon biphyir, ọmaana bi, anọng pẹ biphyir ade atzọhmnọng anang-ẹ. Nkk'ẹ mbiri nda ọmaana ọchattọhk k'ọhaabh ttara atzuk. Nnwa kwaam, bọng odik ọdọdọk kwa kaam mbiri ifha nsi nnang-ọ?” ");
INSERT INTO mfo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ẹsau ọbọbh otte bi, “Itta kwaam, ode bi kọ akhaam ittabọhng rani sẹ-sẹ o? Itta kwaam, biri si kaam ittabọhng!” Ofona mẹ, Ẹsau obhom adimmọng k'ẹrọng. ");
INSERT INTO mfo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isaak, obhin-ẹ bi, “Kker e, oruk kwọ k'irerek s'im-ijibh ekpo kówobha, ówobha kẹ da ẹrọng en-emetzebh. ");
INSERT INTO mfo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kọ áruk agbong-kpen, ábira asi ọtzọhm anang agbaanakka. Yina, atzim ọmmakkakkari aruk akpen, árọbha ọyak kwẹ, k'ẹdọhngi chọ ọrọbha.” ");
INSERT INTO mfo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ẹsau ọdọkhi ettem, okhuri ittabọhng s'otte okk'Jekọb ọsa, on-oben for sẹ bi, “Iwu sa nkwu-osisi s'obo kw'otte kwaam im-ifor e. Ọkk'ọpa, mosẹ-ẹ obo, kaam ḿfhu ọgbaanọkka kwaam Jekọb.” ");
INSERT INTO mfo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Mada bẹ agbaakhi Rẹbẹka odik kwa nnwa kwẹ Ẹsau ọm-ọkham okhuri Jekọb, oyeri nnwa kwẹ Jekọb okwu, oben-ẹ bi, “Kker e, agbaanakka Ẹsau ọkhami bi ọfhọ-ọ, otzima odini for sẹ nttem. ");
INSERT INTO mfo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Mẹ wọ, nnwa kwaam, ogbe kàkhibhi, si macha mgbaakh-ọ. Bina do for ẹbhar-ẹbhar arọbh achina k'ọgbaanọkka kwaam Laban, kw'orukhi ka Haran. ");
INSERT INTO mfo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Kọ wobha mẹ ttar-ẹ maa, idọdọkhi s'agbaanakka iha. ");
INSERT INTO mfo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ikhina agbaanakka okk'odik kwa sẹ ọraama, idọdọkhi ibiri ihẹ-ẹ k'ettem, mẹ kwa kaam ńdọhm ẹkkaabha nnang-ọ akhuna. Okhuri yan kwa bọng anọng afa an-adim-m k'ewu dani o?” ");
INSERT INTO mfo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Mẹ wọ e, Rẹbẹka ọgbaak Isaak bi, “Akpen akk'aam abenga, okhuri panọng mba p'afon Het. Idikha Jekọb obiro ọtza ọtzọkha kwanọng k'anọng pa Het, yan kw'akpen paam án-ade o?” ");
INSERT INTO mfo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Mẹ wọ, Isaak oyeri Jekọb ọsẹ-ẹ ittabọhng, ọtzọr-ẹ itzọhng, oben-ẹ bi, “Kwanọng kpenamkpen kw'ofon m'ẹkhọma cha Kenaan kàtzọkha o. ");
INSERT INTO mfo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kọ rọhng ka Padan-Aram atza atzokha kwanọng k'obhon k'echimma cha Bẹtuẹl, kw'ode otte kw'akka, k'ottem kw'aminava p'agbaanakka kw'akka, kw'ode Laban. ");
INSERT INTO mfo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Tte Ibinọkpaabyi kw'Ẹfa biphyir, ọdọ-ọ ttara va k'ọhaabh, obiro osi va pa va pọ bẹ ahaabh maa, bẹ an-asi ngọma sa nhaabh-ọhaabh. ");
INSERT INTO mfo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Tte kẹ ọnang kọ ọmaana va pa va pọ ẹdaa ch'iwa ọnangi Abraham, ifha kọ afha atzọkha irerek nna s'arukhi mẹ mach'okhekhennọng, irerek nna s'iwa Ibinọkpaabyi ọnangi Abraham.” ");
INSERT INTO mfo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Mẹ wọ, Isaak ọtzọhm Jekọb, ochina ka Padan-Aram, okhebha Laban kw'ode nnwa kwa Bẹtuẹl kw'ofon Aram, kw'obiro ode ọgbaanọkka kwa Rẹbẹka, kw'ode ọkka kwa Jekọb ọmaana Ẹsau. ");
INSERT INTO mfo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Mada Ẹsau orong bi, otte kwabẹ Isaak, okk'Jekọb ittabọhng ọsa, obiro ọtzọhm-ẹ bi, ọrọhng ka Padan-Aram ọtza ọtzọkha kwanọng kẹ, obiro ọtzọr-ẹ itzọhng bi, “Kwanọng kw'ofon Kenaan kàtzọkha o.” ");
INSERT INTO mfo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Obiro oronga bi, Jekọb okk'atzim p'otte ọmaana p'ọkka ọbhaanga, ochina ka Padan-Aram. ");
INSERT INTO mfo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Wa Ẹsau on-otzin bi, panọng pa Kenaan bẹ otte Isaak kadaakhi. ");
INSERT INTO mfo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Mando kw'Ẹsau obin ochina k'Ishimayẹl, ọtza ọtzọkha kwanọng ọdọdọk kw'okpen Mahalat, kw'ode ọgbaanọkka kw'ikwanọng kwa Nẹbayọt, kw'obiro ode nnwa kw'Ishimayẹl, kw'ode nnwa kw'Abraham. ");
INSERT INTO mfo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Mada Jekọb obin ka Bẹrshẹba, ochina ka Haran. ");
INSERT INTO mfo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Okwu opyiri k'ibe rani, ọtzọkha ọtza oji, oyima ọnana eho mẹ ọttaabha, okhuri da erungi ẹkk'ẹpya. ");
INSERT INTO mfo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Wa ọttaara idachen s'ore ọgbaakha kw'ottim ttẹwọr k'irerek, maa ebir-ebir ọttọhmi k'ọrọngkpakpa, obiro ore da arenga-eden p'Ibinọkpaabyi am-arenga m'ọgbaakha nwuma avura, abira am-arenga ahakha. ");
INSERT INTO mfo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Obiro ore da Ọvaar Ibinọkpaabyi obe k'ebir-ebir kw'ọgbaakha nwa oben bi, “Kaam wọ nde Ibinọkpaabyi kw'abatte, Abraham ttara Isaak akpobh. Kaam ńnang kọ ọmaana va pa va pọ irerek nnuma s'ayim mẹ. ");
INSERT INTO mfo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Va pa va pọ áhaabh akher oyeyeng kw'irerek, bẹ abira anyaami k'ibe kpenamkpen, kẹ da ewuchen em-eyin, ttara kẹ da ewuchen em-edimi, ọmaana k'ebira-ebira ttara k'ẹrakha-ẹrakha. Orenga ma kọ ttara va pa va pọ, ọyagbin biphyir, ọkhaama ẹdaa. ");
INSERT INTO mfo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Kaam ńwobha ttar-ọ, mbiri ḿbaabh-ọ, k'ibe kpenamkpen s'áchina, ḿbiri ndim-ọ mkpa nnam m'irek nna. Kaam kọ ọbọhk kintte maa, nsi ẹjaakhi m'odik nwa kwa nkk'nchekhi nnang-ọ.” ");
INSERT INTO mfo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Mada Jekọb ọphyọbh k'ọda, oben bi, “K'odik-ọkkakka, Ọvaar Ibinọkpaabyi owobh m'ibe nna, yina, kaam ira kinnong.” ");
INSERT INTO mfo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Wa opoma ọsẹ-ẹ, on-oben bi, “Bọng ibe rọ ijor manda! Ibe nna idọdọk kifha ide iyongi ọhọhm kw'Ibinọkpaabyi; ma wọ ode ẹbaakhamma ch'ọvaarbhon kw'Ibinọkpaabyi.” ");
INSERT INTO mfo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","K'ekpekpebha ch'ewu ehobh, Jekọb otzini ọtza nwuma kw'ira oyim ọnana eho, ọfhẹ-ẹ iduduma k'irerek, ọtzọkha ana obyengi m'ọtza nwuma. ");
INSERT INTO mfo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Kaambi ode bi iwa obhon nwa ochi eden okpena Luz, wa Jekọb on-oyer-ẹ Bẹtẹl. ");
INSERT INTO mfo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Iwa Jekọb osi echekhi k'itzitzikha s'Ọvaar Ibinọkpaabyi, oben bi, “M'orenga nwa kwa nda ma, idikha Ibinọkpaabyi owobh ttar-m, okker-m, ọnang-m ọchattọhk fa nchi, ọmaana ọbara fa mfọra, ");
INSERT INTO mfo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","maa ikhina ngwuna k'otte kwaam k'ọhọhm k'odidiri, kẹ Ọvaar Ibinọkpaabyi wọ óde Ibinọkpaabyi kwa kaam ḿkpobha. ");
INSERT INTO mfo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ọtza nwa kwa nkk'mfha mach'ekpọmmachi, óde ọhọhm kw'Ibinọkpaabyi. Ọttọhk kpenamkpen f'anang-m, kaam mbiri ńkkema fẹ k'obe jobh, ńdọkha rani nnang-ọ.” ");
INSERT INTO mfo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Wa Jekọb ochina ororo k'orenga kwẹ, matzẹmaa opyiri k'anọng p'arukhi k'okhubha kw'ewuchen em-eyin. ");
INSERT INTO mfo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ọtza opyiri m'ibe nnuma, ore esipe ch'ewobh mẹ, cha bẹ atzim ẹtzakpa ch'ẹbari ẹkpa abubha, obiro ore ngaan nttaan s'etzirakpo, py'eyim m'esipe nduma ọkhaan-ọkhaan, cha bẹ akhaabh asi anang bẹ. ");
INSERT INTO mfo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","K'ogbe kpenamkpen kw'akker-arukhimaan an-anang etzirakpo pyabẹ asi, bẹ am-abingi ẹtzakpa nduma ch'ebubh m'ẹmma ch'esipe ebir-ebir, ahok ọkhaan-ọkhaan, akhaabha asi anang arukhimaan, yina bẹ an-abira abingi chẹ abubha. ");
INSERT INTO mfo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Mẹ wọ, Jekọb ọbọbh akkeri-arukhimaan mba bi, “Abayi paam, bọbọng afon man o?” Bẹ abhina bi, “Maman ofon ka Haran e.” ");
INSERT INTO mfo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Obiro ọbọbh bẹ bi, “Bọng arong ojinọng kwa bẹ ayeri Laban ma, kwa Nahọr obhon o?” Bẹ abhin-ẹ bi, “O o, morong-ẹ ma e.” ");
INSERT INTO mfo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Mẹ wọ, Jekọb ọn-ọbọbh bẹ bi, “For igaang-ẹ khẹ?” Bẹ abhin-ẹ bi, “K'odik ọkkakka, for igaang-ẹ khẹ e. Nnwa kwẹ kw'ikwanọng kw'okpen Rachẹl, kẹ wọ om-otzima arukhimaan okwu kana.” ");
INSERT INTO mfo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jekọb oben bi, “Kker e, ekpekhira etzim ẹkhọhm-ọkhọhm; ogbe otzim obenga kw'atzobha arukhimaan mba k'ibe rani, anang bẹ asi, ifha bọng atzima bẹ atza anang ọchattọhk.” ");
INSERT INTO mfo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Iwa bẹ abhina bi, “Mma e, man kofha osi e, mọkhaambi otzobha arukhimaan biphyir k'ibe rani, yina mon-obingi ẹtzakpa ch'ebubh m'ẹmma ch'esipe. Mosisi mando, man biphyir mọ́nang arukhimaan paman asi e.” ");
INSERT INTO mfo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Mada Jekọb, otzim ọm-ọgbaak atzim ttara akkeri-arukhimaan mba, Rachẹl otzima arukhimaan p'otte opyiri m'esipe nda. ");
INSERT INTO mfo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Mada Jekọb ore Rachẹl kw'ode nnwa kwa Laban, kw'ode ọgbaanọkka kw'ọkka kwa Jekọb ttara arukhimaan pa Laban. Jekọb, ọrọbh otzor Rachẹl, ọtza obingi ẹtzakpa ch'ebubh m'ẹmma ch'esipe, ọkhaabha asi ọnang arukhimaan p'ọgbaanọkka kw'ọkka. ");
INSERT INTO mfo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Mada Jekọb okk'mando ọsa, ọtza ọbaakha Rachẹl, obiro obhom ẹmọng k'ẹrọng. ");
INSERT INTO mfo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Obiro ọgbaak Rachẹl bi, kẹ ode ochimmanọng kw'otte, Laban, obiro ode nnwa kw'ijinọng kwa Rẹbẹka. Mẹ wọ, Rachẹl ọrọbh ọtza ọgbaak otte. ");
INSERT INTO mfo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Mada Laban ọbhaang idik nna s'ikhuri Jekọb kw'ode nnwa kw'ọgbaanọkka kwẹ, obina m'ẹbhar-ẹbhar otza okhebh-ẹ kẹ da owobh. Mada bẹ are ayok, Laban ọbaakh-ẹ, obiro otzim-ẹ ochina k'ọhọhm kwẹ. K'ọhọhm wọ kwa Jekọb ọn-ọgbaakhi Laban idik biphyir s'ikk'itta. ");
INSERT INTO mfo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Mẹ wọ, Laban obhin-ẹ bi, “K'odik ọkkakka, kọ ade ochimmanọng kwaam e, mode izi rani e.” Mẹ wọ, mada Jekọb okk'ophe wani owobha k'ọhọhm kwa Laban, ");
INSERT INTO mfo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban on-oben-ẹ bi, “Kaambi ode bi, kaam ọmaana kọ mode anọng bani, mando rang osi, kọ an-asi ọtzọhm anang-m k'idukhi. Kọ gbaakh-m agbukha p'ọtzọhm fọ ope.” ");
INSERT INTO mfo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Wa Laban ọkhaam va p'ipanọng afa, ocheden-nwa okpen Lea, ottong afa, okpena Rachẹl. ");
INSERT INTO mfo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Wa Lea ọkhaam adadaakha-chen, yina, Rachẹl wọ ode ominnanwa kw'ojibhi for obiro ojibh ikkekkeri. ");
INSERT INTO mfo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Wa Jekọb ọkhaam idadaakha ttara Rachẹl, oben bi, “Kaam ńsi ọtzọhm nnang-ọ ka cho azenamfa, k'eho cha Rachẹl kw'ode nnwa kwọ kw'ikwanọng kw'ikhakhari.” ");
INSERT INTO mfo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Mẹ wọ, Laban oben bi, “Ode odik kw'ojibh-ojibh bi, ndọkh-ẹ nnang kọ, ọyọhnga bi, ndọkh-ẹ nnang ọnọng ọdọdọk. Kọ wobha ma ttar-m.” ");
INSERT INTO mfo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Wa Jekọb osi ọtzọhm ka cho azenamfa, k'eho cha Rachẹl. Yina, okhuri idadaakha sa Jekọb ọkhaam ttara Rachẹl, wa cho azenamfa an-akher-ẹ awuwa. ");
INSERT INTO mfo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Iwa Jekọb okwu oben Laban bi, “Cho p'ọtzọhm faam akk'attonga, kọ na nnang-m kwanọng kwaam, ifha nyim-ẹ abẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban obher anọng p'ibe nnuma biphyir atzobha, bẹ asi ọdadaami kw'ọbada. ");
INSERT INTO mfo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Yina, okwu opyiri m'ẹchọhkha, Laban ọn-ọtzọkha nnwa kwẹ, Lea, ọnang Jekọb. Jekọb oyim-ẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Wa Laban ọtzọkha ọtzọhmnọng kwẹ Zilpa, ọnang nnwa kwẹ Lea bi, orukh-ẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Mada ewu en-ehobh, Jekọb on-ore bi, Lea wọ oyim kẹ. Ofona mẹ, Jekọb ọbọbh Laban bi, “Itta, ode yan kw'asi-m manda o? Kaam nsi ọtzọhm k'eho cha Rachẹl, mando arang o? Kọ an-asi yan abọhr-m?” ");
INSERT INTO mfo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Mẹ wọ, Laban obhin-ẹ bi, “K'ẹmmaana cha man, kọbaan bi, otte kw'ọnọng ọtzọkha nnwa kwẹ kw'ikhakhari, ọnang k'ọbada, k'ogbe kw'ocheden oni odim otzim ọba. ");
INSERT INTO mfo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Kọ kyera ẹphyawu dani chọ ch'ọdadaami kw'ọbada, akk'akyera, mobiro ọ́tzọkha oyok kw'ikhakhari ọnang-ọ. Yina, kọ abira asi ọtzọhm ka cho azenamfa adọdọkh e.” ");
INSERT INTO mfo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Wa Jekọb okhera ttar-ẹ. Mada okk'ẹphyawu dani ch'ọdadaami okyera ttara Lea, Laban obiro ọtzọkha nnwa kwẹ Rachẹl ọnang-ẹ k'ọbada. ");
INSERT INTO mfo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Wa Laban ọtzọkha ọtzọhmnọng kwẹ kw'ikwanọng, kw'okpen Bilha, ọnang Rachẹl bi, orukh-ẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jekọb obiro oyima Rachẹl abẹ. Wa Rachẹl ọdaakh-ẹ ọtzam ọyọhnga Lea. Mẹ wọ, wa osi ọtzọhm ka cho azenamfa adọdọk ọnang Laban. ");
INSERT INTO mfo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Mada iwa Ọvaar Ibinọkpaabyi ore bi, Lea Jekọb idik kọdaakhi, on-odo Lea ttara ọmaan. Yina, osi Rachẹl ọkpaana. ");
INSERT INTO mfo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Iwa Lea okwu otzima ibhọr, ọmaan nnwa kw'ijinọng, ọkpẹ-ẹ Reubẹn, oben bi, “Ofon da Ọvaar Ibinọkpaabyi ọkk'ọmmamma kwaam ọra. K'odik-ọkka, yina wọ kwa kaam nna ńdaak odim kwaam e.” ");
INSERT INTO mfo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lea obiro otzima ibhọr, ọmaan nnwa kw'ijinọng, ọkpẹ-ẹ Simeọn, on-oben bi, “Okhuri da, Ọvaar Ibinọkpaabyi ọbhaang bi, kaam odim kwaam kindaakhi, okk'kaam nnwa obiro ọnanga.” Mẹ wọ, Lea okpe nnwa kwẹ, Simeọn. ");
INSERT INTO mfo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Lea obiro otzima ibhọr ọmaan nnwa kw'ijinọng oben bi, “Kaam nkk'odim kwaam va p'ijinọng attaan mmaana, yina wọ kwa kaam nna ndaak odim kwaam.” Mẹ wọ, ọkpẹ-ẹ Lẹvi. ");
INSERT INTO mfo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lea otzima ibhọr ottong igbe inna ọmaan ojinọng, oben bi, “M'ogbe nwa, kaam ńnang Ọvaar Ibinọkpaabyi ẹtzọhnga.” Mẹ wọ, ọn-ọkpẹ-ẹ Juda. Mada okk'nnwa kw'ottong anna ọmaana, ọn-ọkwọbha ọmaan. ");
INSERT INTO mfo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Mada Rachẹl ore bi, ibhọr igaang-ẹ ọgaangi, ọn-ọkhaama ottem-mamma otzima otzor ọgbaanọkka Lea. Mẹ wọ, on-oben Jekọb bi, “Nang-m va oni mando ode ḿpe-ope.” ");
INSERT INTO mfo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jekọb ọdọkhi ettem ttara Rachẹl, ọbọbh bi, “Kaam wọ nde Ibinọkpaabyi, kw'ọkpọ-ọ bi, aningi va amaan o?” ");
INSERT INTO mfo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rachẹl oben bi, “Ode mando, kkeri Bilha kw'ode ọtzọhmnọng kwaam mẹ. Kọ tzọkh-ẹ ayima abẹ ifha ọmaan va ọnang-m, mbiri nnenga ma ndaak sẹ, nsi echimma chaam.” ");
INSERT INTO mfo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Mando kw'ọtzọk ọtzọhmnọng kwẹ Bilha, ọnang Jekọb oyim-ẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha okwu otzima ibhọr ọmaan nnwa kw'ijinọng ọnang Jekọb. ");
INSERT INTO mfo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rachẹl okpe nnwa nwa Dan, oben bi, “Ibinọkpaabyi okk'aponga paam ọba, obiro ọbhaanga njọhm saam, ọnang-m nnwa kw'ijinọng.” ");
INSERT INTO mfo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Iwa Bilha kw'ode ọtzọhmnọng kwa Rachẹl obiro otzima ibhọr, ọmaan nnwa kw'ijinọng kw'ottong afa ọnang Jekọb. ");
INSERT INTO mfo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachẹl oben bi, “Kaam nkk'ẹfa ndima nsi erima ttara ọgbaanọkka kwaam Lea, mbiri ngem-ẹ.” Mẹ wọ, okpe nnwa nwa Naphtali. ");
INSERT INTO mfo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Mada Lea ore bi, ọkk'ọmaan ọkwọbha, ọn-ọtzọkha ọtzọhmnọng kwẹ Zilpa ọnang Jekọb macha kwanọng kwẹ. ");
INSERT INTO mfo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpa ọmaan nnwa kw'ijinọng ọnang Jekọb. ");
INSERT INTO mfo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Mẹ wọ, Lea oben bi, “Ma wọ ode ojibhaada ọkkakka.” Wa okpe nnwa nwa Gad. ");
INSERT INTO mfo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Wa Zilpa kw'ode ọtzọhmnọng kwa Lea, obiro ọmaan nnwa kw'ijinọng kw'ottong afa ọnang Jekọb. ");
INSERT INTO mfo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Mẹ wọ e, Lea okpe nnwa nwa Ashẹr, oben bi, “Ettem ẹdaam-m o, da ayokhi-panọng an-ayer-m, idadaama.” ");
INSERT INTO mfo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","K'ọphagbe kw'awit, Reubẹn oyin k'iwoni otza ore asitzen-kwongi otzima ochena ọkka kwẹ, Lea. Mẹ wọ, Rachẹl oben Lea bi, “Tzotzokhaan kebh-m akwọngitzọhng bani pa nnwa kwọ, otzim okhuna.” ");
INSERT INTO mfo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Yina, Lea ọbọbh Rachẹl bi, “Kw'oyini bi, odim kwaam kw'atzọk kọ kobeng? Kw'bira akwu bi, akwu atzọkha asitzen-kwongi pa nnwa kwaam o?” Rachẹl oben bi, “Ojibhi kẹ, ode mando, kọ tzọkha eyimawu cha mayina, anang-m asitzen-kwongi pa nnwa kwọ otzim okhuna.” ");
INSERT INTO mfo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Mada Jekọb okhun eyina k'ẹchọhkha, Lea ọtza okhebh-ẹ, ọgbaakh-ẹ bi, “Mayina on-ode eyimawu chaam e, okhuri bi, kaam nkk'asitzen-kwongi pa nnwa kwaam ndima ndebh chẹ. Mẹ wọ, Jekọb oyima ọmaana Lea m'erungiwu nduma.” ");
INSERT INTO mfo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ibinọkpaabyi ọbhaanga njọhm sa Lea, otzima ibhọr, ọmaan nnwa kw'ijinọng kw'ottong azen ọnang Jekọb. ");
INSERT INTO mfo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea oben bi, “Ibinọkpaabyi ọkk'aam ochora, okhuri da nnangi odim kwaam ọtzọhmnọng kwaam bi, oyima abẹ.” Wa okpe nnwa nwa Isaaka. ");
INSERT INTO mfo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea obiro otzima ibhọr ọmaan nnwa kw'ijinọng kw'ottong azadani ọnang Jekọb. ");
INSERT INTO mfo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Mẹ wọ, Lea oben bi, “Ibinọkpaabyi ọkk'aam ẹnanga ch'ideden obiro ọnanga, yina kwa kaam nna mbar odim kwaam odik, okhuri bi, nkk'ẹ va p'ijinọng azadani mmaana.” Mẹ wọ, okpe nnwa nwa Zẹbulun. ");
INSERT INTO mfo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ayongi mẹ, Lea obiro ọmaan nnwa kw'ikwanọng, ọkpẹ-ẹ Daina. ");
INSERT INTO mfo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Mẹ wọ, Ibinọkpaabyi okwu ojima Rachẹl ọbhaanga njọhm sẹ, okwung-ẹ ẹbhọr. ");
INSERT INTO mfo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Rachẹl okwu otzima ibhọr ọmaan nnwa kw'ijinọng, oben bi, “Ibinọkpaabyi ọkk'aam ka mgbar ọrọbha.” ");
INSERT INTO mfo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Okpe nnwa nwa Josẹph, oben bi, “Tte Ọvaar Ibinọkpaabyi obiro ọttar-m nnwa kw'ijinọng ọdọdọk.” ");
INSERT INTO mfo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","K'ogbe kwa Rachẹl okk'Josẹph ọmaana, Jekọb oben Laban bi, “Tte-m ọbọhk mmaana ka man k'obhon. ");
INSERT INTO mfo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Kọ nang-m panọng paam ttara va paam pa nkk'ọtzọhm nsa nnang-ọ, ndima mfona. Kọ arong ọtzọhm-dema fa kaam nkk'nsa nnang-ọ kẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Yina, Laban oben-ẹ bi, “Idikha kaam nkk'ọphyaam ndọkha k'itzitzikha sọ, tzọtzọkhaan kọ kàfona, kkeri kaam nkk'ose mmari, nnonga bi, Ọvaar Ibinọkpaabyi ọkk'aam ọda okhuri kọ.” ");
INSERT INTO mfo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Laban obiro ọttara bi, “Kọ gbaak-m ekkema ch'ọtzọhm fọ, kkeri kaam ńnang-ọnang.” ");
INSERT INTO mfo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jekọb obhin-ẹ bi, “Kọ arong ọtzọhm fa nkk'nsa nnang-ọ kẹ, abira aronga eden cha nneng nkkeri etzirakpo pyọ, ejibh ẹnang-ọ. ");
INSERT INTO mfo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Yina iwa kaam nkwu, wa etzirakpo pyọ kẹhaabhi macha pyẹ ẹn-ẹhaabhi madẹdẹn. Ọvaar Ibinọkpaabyi ọkk'ọ ọda k'ọtzọhm kpenamkpen fa nkk'nsa nnang-ọ. Yina, kọbaan bi abira atte kaam ọbọhk, mbiri nda nnor f'ẹhọhmmọr chaam, ebire etzima eruk akpen o?” ");
INSERT INTO mfo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban ọbọbh-ẹ bi, “Mbọng f'áror bi, nsi nnang-ọ?” Jekọb on-obhina bi, “Kaam echora manda dani ka mbọhk sọ kinnori. Odik obungikwẹ kwa kaam nnori ode bi, kọ abira atte etzirakpo pyọ ọbọhk, anang-m nkkeri. ");
INSERT INTO mfo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Tte nnenga k'ottem kwa arukhimaan-va pọ pa kaam mmi nkkeri, ndekha arukhimaan p'ade akkẹr-ankkẹr, ọmaana avu p'asi attẹttẹr, mach'echora chaam. ");
INSERT INTO mfo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Mada ópyiri k'ogbe kwa kọ akwu akkeri etzirakpo pyọ, tte odik ọkkakka kwaam ọkhaama ẹjaakhi bi, idikha kọ are orukhimaan-nwa kpenamkpen kw'oni akkẹr-ankkẹr ode, ọmaana evu kpenamkpen ch'eni attẹttẹr esi k'ottem kwa nden saam, kọ tzọkha bi, mfhu-ofhu.” ");
INSERT INTO mfo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban oben bi, “Kaam nkk'nkhera k'odik ọkkakka bi, kwẹ ode mach'agbaakhi.” ");
INSERT INTO mfo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","M'ewu nduma dani, Laban orenga ọrọbha avu-dim p'ade akkẹr-ankkẹr, ọmaana p'asi attẹttẹr, ọmaana avu-gbokha biphyir p'ade akkẹr-ankkẹr, ọmaana p'asi attẹttẹr, ttara arukhimaan-bina biphyir, ọtzọkha ọnang va pẹ bi, bẹ akkeri. ");
INSERT INTO mfo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Mẹ wọ, otzima va pẹ obina orenga kw'iwu ittaan, bẹ aji Jekọb kẹ da okkeri etzirakpo mbyonggo pya Laban. ");
INSERT INTO mfo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Mando kwa Jekọb ọtzọk achi-bọhnga abhapẹ p'echi cha pọpula ọmaana, abọhnga p'echi ch'almọn, ọmaana p'echi ch'ede bi waaar obori akpakpa, osi bẹ an-awur bi gwaang. ");
INSERT INTO mfo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Mẹ wọ, Jekọb ọtzọkha achi-bọhnga p'okk'akpakpa obori, ohok m'agbaakha biphyir p'etzirakpo em-ekwu egwo asi, ttara nttak bi, idikha pyẹ eyim ayok abẹ m'ibe nnuma sa pyẹ em-egwo asi, ");
INSERT INTO mfo_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","pyẹ ekkeri achi-bọhnga mba itzitzikha, pyẹ ẹmaan akkẹr-ankkẹr. ");
INSERT INTO mfo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Mẹ wọ, Jekọb ọbhaangi arukhimaan-va ohok ngọmi, yina on-osi mbonggo p'arikhi bi, bẹ akkeri akkẹr-ankkẹr pa Laban itzitzikha. Mẹ wọ, kẹ ọn-ọkhaama etzirakpo pya kẹ ọkhaam, py'oni ka pya Laban dọk attar. ");
INSERT INTO mfo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ogbe kpenamkpen nwa kwa Jekọb ore bi, etzirakpo py'ipanọng py'egwengi for en-eyima ayok abẹ, ọtzọkha achi-bọhnga p'okk'akpakpa obori ohok m'agbaakha k'itzitzikha s'etzirakpo, ifha pyẹ eyima ayok abẹ ẹbaanga mẹ. ");
INSERT INTO mfo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Yina, etzirakpo py'eni egwengi, pyẹ achi-bọhnga mbuma kọkpa. Mẹ wọ, mbuma py'egweng-ogwengi en-ede pya kẹ Jekọb. Py'eni egwengi ede pya Laban. ");
INSERT INTO mfo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Mando wọ kw'iwa Jekọb otzim okpena ọkkọkkaa kw'okhaam etzirakpo k'ọhaabh, ọmaana atzọhmnọng p'ipanọng ttara p'ijinọng, ọmaana akamẹl ọttara nnyanyaang. ");
INSERT INTO mfo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","K'ogbe wani, wa Jekọb okwu ọbhaanga bi, va pa Laban an-am-aben bi, “Ọnyẹ kwaman Jekọb, ọkk'ọttọhk kpenamkpen f'otte kwaman ọtzọkha biphyir ọkhaama. Ẹkhakhaama chẹ biphyir efon k'otte kwaman e.” ");
INSERT INTO mfo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jekọb on-obiro ore bi, Laban kẹ itzitzikha ọkkakka dọk kọm-ọnang. ");
INSERT INTO mfo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Jekọb bi, “Kọ rọhng abhana atzor anọng pọ, ttara ẹhọhmmọr ch'atte. Kaam ńwobha ttar-ọ, mbiri ńkkaan-ọ.” ");
INSERT INTO mfo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Iwa Jekọb ọtzọhm ọnọng bi, bẹ ayeri panọng pẹ, Rachẹl ọmaana Lea, ifha bẹ akhebh-ẹ kẹ da om-okkeri etzirakpo pyẹ. ");
INSERT INTO mfo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Mada bẹ akk'apyiri, oben bẹ bi, “Kaam nkk'nna bi, atte kwabọng kaam itzitzikha ọkkakka dọk om-okkeri m'iwu nna. Yina, kaam nnong bi, Ibinọkpaabyi kw'otte kwaam okpobh okk'owobha ttar-m. ");
INSERT INTO mfo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Bọng anọng afa arong bi, kaam nkk'ọtzọhm nsa ttara ettem-obungichẹ nnang atte kwabọng. ");
INSERT INTO mfo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Yina, atte ọkk'aam echora ch'ọtzọhm faam ọbọhra k'igbe jobh. Kaambi mẹ wọ, Ibinọkpaabyi kẹ ọbọhk kotte bi, osi-m itzama manda rani. ");
INSERT INTO mfo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Idikha obeni bi, ‘Etzirakpo py'esi akkẹr-ankkẹr bọ éde echora chọ,’ etzirakpo biphyir ẹn-ẹmaan ayok p'asi akkẹr-ankkẹr. Yina, obeni bi, ‘Etzirakpo py'esi attẹttẹr byọ éde echora chọ,’ etzirakpo biphyir ẹn-ẹmaan ayok p'asi attẹttẹr. ");
INSERT INTO mfo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Mẹ wọ, Ibinọkpaabyi okk'etzirakpo py'atte kwabọng ọtzọkha ọnang-m. ");
INSERT INTO mfo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Wa ewu dani, k'ogbe kw'etzirakpo em-eyima ayok abẹ, nttaar idachen. K'idachen, ndini chen nne da, avu-dim p'am-avura avugbokha bẹ asi attẹttẹr, bẹ abira asi akkẹr-ankkẹr. ");
INSERT INTO mfo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","K'idachen, orenga-eden kw'Ibinọkpaabyi oyer-m bi, ‘Jekọb.’ Kaam nkhera bi, ‘O o, kkeri kaam ma e.’ ");
INSERT INTO mfo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Kẹ on-oben-m bi, ‘Kọ tzini chen akkeri k'ẹrọng, are bi, avu-dim p'avur ayok biphyir asi attẹttẹr, abira asi akkẹr-ankkẹr. Kaam nsi kwẹ ode mando okhuri da nkk'odik kpenamkpen kwa Laban ọkk'ọsa nna e. ");
INSERT INTO mfo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Kaam wọ nde Ibinọkpaabyi kwa Bẹtẹl, kẹ da abyengi ọtza ana k'eho, abira asi echekhi ọnang-m. Kọ na bina aji obhon nwa, akpa nnam abhana k'ọmmaana-bhon kwọ.’ ” ");
INSERT INTO mfo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Mando kwa Rachẹl ọmaana Lea an-abhin odim kwabẹ, Jekọb bi, “Ọttọhk fa maman obiro ochi otte kwaman obo k'ẹkhakhaama chẹ biphyir dọk kode. ");
INSERT INTO mfo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Otte kwaman ọn-ọtzọk man mach'akhekhennọng, okpe-okpe kẹ-khẹ arang kw'okpe man, okk'amina-gbukha paman obiro ọcha mancheni. ");
INSERT INTO mfo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","K'odik ọkkakka, kọ si odik kpenamkpen kw'Ibinọkpaabyi okk'obena bi asi, k'eden bi, Ibinọkpaabyi okk'ẹkhakhaama ch'otte kwaman ọtzọkha, ọn-ọnang maman, ttara va paman.” ");
INSERT INTO mfo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Mẹ wọ, Jekọb obina ọtzọkha va pẹ ọmaana panọng pẹ afa, ọnanna k'akamẹl, ");
INSERT INTO mfo_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","on-otzima etzirakpo pyẹ biphyir, ọmaana ẹkhakhaama chẹ biphyir ch'ọkk'ọkhaama ka Padan-Aram obina orenga, okhuna otzor otte kwẹ, Isaak k'ẹkhọma cha Kenaan. ");
INSERT INTO mfo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Mada Laban okk'ofona bi, ọtza ophyiri ophyubha f'arukhimaan pẹ, kwanọng kwẹ, Rachẹl ofona ọtza ofhu agbatza p'ẹhọhmmọr ch'otte. ");
INSERT INTO mfo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ayongi mẹ, wa Jekọb ọbọhr Laban kw'ofon Aram ọbọhra, kẹ kọgbaakhi bi, ọn-ọrọbh ofona. ");
INSERT INTO mfo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Mẹ wọ, wa Jekọb ọtzọkha ẹkhakhaama chẹ biphyir, ojekha ọraanga kwa Yupharetes, okkeri itzitzikha k'okhuba kw'egbegbeho cha Gilead, ọrọbh ofona. ");
INSERT INTO mfo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ottong iwu ittaan sa Jekọb ọkk'ọrọbha ofona, mẹ kwa Laban on-orong bi, Jekọb ọkk'ọrọbha. ");
INSERT INTO mfo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Mẹ wọ, Laban otzima vọkka pẹ p'atzọn-ẹ abẹ, akhubh Jekọb k'eden k'iwu izenamfa, matzẹmaa bẹ akwu abọkh-ẹ ka mgbegbeho sa Gilead. ");
INSERT INTO mfo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Mẹ wọ, Ibinọkpaabyi oyin Laban kw'ofon Aram abẹ k'erungi k'idachen, oben-ẹ bi, “Ndọr-ọ itzọhng bi, aningi Jekọb atzim p'agaang-ọgaangi agbaakhi.” ");
INSERT INTO mfo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Mada Laban okhebh Jekọb, Jekọb okk'ikhira sẹ ọsa ka mgbegbeho sa Gilead, wa Laban ọmaana vọkka pẹ akwu asi ibhingabe sabẹ abaanga mẹ dọk. ");
INSERT INTO mfo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Mada bẹ akhebh ayok, Laban ọbọbh Jekọb bi, “Osi yan kwa kọ abọhr-m, atzima aminava paam afona mach'anọng p'abẹ abọhk k'ẹmmọri ch'egbong. ");
INSERT INTO mfo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Okhuri yan kw'abọhr-m, afhu-ofhu arọbh afona o? Osi yan kaam kagbaakhi bi, an-afona ifha kaam nsi ọdadaami kwa ndima ọkkọhna, ọmaana achachaak ttara ogim-ogim mben-ọ bi, yima o? ");
INSERT INTO mfo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Kọ kaam ọbọhk katte bi, mbaakha va pa va paam ttara aminava paam da bẹ afon. Odidingi-dik wọ kw'asi ma e. ");
INSERT INTO mfo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Kaam ngaam ẹfa kẹ ch'ira nsọ-ọ itzama e. Yina, erungiwu ch'ikhena Ibinọkpaabyi kw'atte ọtzọr-m itzọhng bi, ‘Kọ bọkh-ọ for, odik manda wani kagbaak anang Jekọb o, ode bi kw'ejibh-ojibh obiro ode bi kwẹ opyibh-opyibh.’ ");
INSERT INTO mfo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Kaam nnong odem kw'oyibh-ọ bi, abhana k'atte k'obhon kẹ e, yina, kọ asi yan afhu agbatza paam atzima arọbh o?” ");
INSERT INTO mfo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Iwa Jekọb obhina Laban bi, “Kaam mfon mando okhuri ojora f'osi-m, nna nchibhi bi, kọ afha abọkh-m aminava pọ ana k'ẹfa. ");
INSERT INTO mfo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Yina, idikha kọ are ọnọng manda wani k'ottem kwaman kw'otzim agbatza pọ, tte ọnọng nwuma oningi akpen orukhi. M'itzitzikha s'anọng paman, kọ ọkhaam kkeri, idikha atzini ọttọhk kpenamkpen f'ode fọ, tọkha.” Wa Jekọb korong bi, Rachẹl ọkk'agbatza p'otte ọfha. ");
INSERT INTO mfo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Mẹ wọ e, Laban odim k'ikhira sa Jekọb, ọmaana sa Lea ttara s'atzọhmnọng p'ipanọng afa oror agbatza pẹ. Yina, ọttọhk manda vani kore. Mada oyini k'ikhira sa Lea, on-odim k'ikhira sa Rachẹl. ");
INSERT INTO mfo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Wa Rachẹl ọkk'agbatza p'otte ọtzọkha okhe k'ẹkpa ch'ebubh ẹwọr-wobha cha kamẹl ka nnam, owobha ẹwọr obubha. Laban ọfọhngi k'ikhira biphyir, agbatza pẹ kore. ");
INSERT INTO mfo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Mando kwa Rachẹl oben otte bi, “Itta kwaam, tte oning-ọ ọdọkhi da kaam nnimfha mbina mbe k'itzitzikha sọ, okhuri bi, kaam ndim for e.” Laban ọfọhngi k'ibe kpenamkpen biphyir, agbatza pẹ kore. ");
INSERT INTO mfo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jekọb ọdọkhi ettem, oyin Laban abẹ, ọbọbh-ẹ bi, “Kaam nji bọng odikh o? Ottotto kwaam ode yan, kw'areng abẹ akhubh-m ẹkhọm-ẹkhọma manda o? ");
INSERT INTO mfo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Mada akk'ọttọhk kpenamkpen f'ode faam afọhngi biphyir, mbọng f'are f'ode fọ ọ? Ji pyẹ m'itzitzikha s'anọng paman, ifha bẹ are ọnọng kw'otzor-otzor k'ottem kwa man anọng afa. ");
INSERT INTO mfo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Kaam nkk'ọtzọhm nsa nnang-ọ ka cho ẹrọbh. Ma cho mbuma biphyir, arukhimaan-kwa ọmaana avu pọ p'ibhọhr iyini kade. Arukhimaan-dim pọ pa ndim nsi ọchattọhk nchi kade. ");
INSERT INTO mfo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Etzen cha nden s'ẹtzam ifhu, cha ndim nchen-ọ kede. Ọttọhk kpenamkpen fa bẹ afhu ka mbọhk saam, ode k'erungi obiro ode k'ẹya f'arori, fa kaam nnọ-ọ ndukhi kode. ");
INSERT INTO mfo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Kaam wa akpen paam ade p'ekpikhira ẹmaani k'ẹya, ekhokhokhi esi-m k'erungi, chen abira akhur-m. ");
INSERT INTO mfo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Kaam nnukh-ọ abẹ ka cho ẹrọbh biphyir. Nsi ọtzọhm nnang-ọ ka cho ọhawani kwa chi, ifha ndọkha aminava pọ afa k'ọbada, mbiri nkkeri nden sọ nnang-ọ ka cho azadani. Nkyera e, abọhr-m echora ch'ọtzọhm faam k'igbe jobh. ");
INSERT INTO mfo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Idikha ira Ibinọkpaabyi kw'otte kwaam, kw'ode Ibinọkpaabyi kw'Abraham ttara Ojora f'Isaak, on-owobh ttar-m, ira kọ akk'aam mbọhk-mbọhk akhubha. Yina, Ibinọkpaabyi okk'ọmmamma kwaam ọra, obiro ore ihem saam, kẹ wọ osi ọkpọ-ọ eden ihena k'erungi.” ");
INSERT INTO mfo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ofona mẹ, Laban on-obhina Jekọb bi, “Panọng mba ade va paam, va mba biphyir ade va pa va paam, nden nna biphyir mbiri nde saam. Ọttọhk kpenamkpen f'are bi akhaam ma ode faam. Akker-okkeri, yina wọ kwa kaam mbiri ndọkha va paam, ttara va pa va paam amaani ka mbọhk sọ o? ");
INSERT INTO mfo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Mẹ wọ, tte mosi echekhi ọnang ayok, ch'ebe macha nttẹsẹ kwa kaam ttara kọ.” ");
INSERT INTO mfo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Mẹ wọ, Jekọb ọtzọkha ọtza, ọfhẹ-ẹ ebebe mach'ẹkpọmmachi. ");
INSERT INTO mfo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Jekọb on-oben anọng pẹ bi, “Bọng dobha atza.” Bẹ atzọkha atza atzobha k'okhung, bẹ an-abira awobha abaanga ọtza-khung nwuma achi ọchattọhk. ");
INSERT INTO mfo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Wa Laban oyeri ọtza-khung Jega-Sahaduta, Jekọb oyer-ẹ Galeed. ");
INSERT INTO mfo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban on-oben bi, “K'ewu cha mayina, ọtza-khung nwa obe macha nttẹsẹ kwa kaam ọmaana kọ.” Kẹ wọ osi, bẹ ayeri ibe nna Galeed. ");
INSERT INTO mfo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Wa Laban obiro oyeri ibe nna Mizpa, oben bi, “Tte Ọvaar Ibinọkpaabyi okkeri man mada motte ayok ọbọhk, ọnọng-ọnọng ofona kwẹ. ");
INSERT INTO mfo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Idikha kọ atzim va paam k'ihem, ode bi kọ an-abira atza atzọkha panọng adọdọk p'ayongi va paam, kaambi ode bi ọnọng man kore, jima bi, Ibinọkpaabyi wọ ode nttẹsẹ kwa kaam ọmaana kọ.” ");
INSERT INTO mfo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Mẹ wọ, Laban oben Jekọb bi, “Manya wọ ode ọtza-khung, manya wọ obiro ode ẹkpọmmachi cha kaam nkk'nttima k'ottem kwa kaam ttara kọ. ");
INSERT INTO mfo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ọtza-khung nwa ode nttẹsẹ, ẹkpọmmachi nda ebire ede macha nttẹsẹ bi, ogbe dọk kode kwa kaam mbiri njekha ibe nna nkwu nsọ-ọ itzama, ọmaana bi, ogbe dọk kode kwa kọ abira ajekha k'okhubha kwaam akwu asi-m itzama. ");
INSERT INTO mfo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Tte Ibinọkpaabyi kw'Abraham, ọmaana Nahọr, Ibinọpkaabyi kw'otte kwabẹ okpobh, osi ochibhi kwẹ m'echekhi nda cha kaam ọmaana kọ.” Mẹ wọ, Jekọb on-ọtzọkha ọnwọhngi ka che ch'ojora f'otte kwẹ, Isaak. ");
INSERT INTO mfo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jekọb ọtzọkha orukhimaan ofhu otzima osi ẹjafọhni ọnang Ibinọkpaabyi k'okhubha kwa mgbegbeho, obiro oyeri anọng pẹ bẹ akwu achi ọchattọhk mẹ. Mada bẹ akk'ọchattọhk acha akyera, bẹ an-ayima mẹ maa, ewu ehobha. ");
INSERT INTO mfo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Mada ewu ekk'ehobha, Laban obina odo for s'ofona, ọtzọkha va pa va pẹ, ọmaana aminava pẹ ọbaakha, obiro osi bẹ ittabọhng. Laban obina ọbhana ka kẹ k'obhon. ");
INSERT INTO mfo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Iwa Jekọb obina orenga, arenga-eden p'Ibinọkpaabyi ayin-ẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Mada Jekọb ore arenga-eden mba p'Ibinọkpaabyi, oben bi, “Ibe nna ide ibhingabe s'Ibinọkpaabyi.” Mẹ wọ, oyeri sẹ Mahanayim. ");
INSERT INTO mfo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jekọb ọtzọhm akkaabh-nkkaabha pẹ bi, bẹ acheden atza akhebha ọgbaanọkka Ẹsau k'ẹkhọma cha Seir, k'okhuba kw'Edom. ");
INSERT INTO mfo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ọnang bẹ ẹkkaabha, oben bẹ bi, “Bọng gbaak itta kwaam Ẹsau bi, ‘Kaam ọtzọhmnọng kwọ, Jekọb, mbeni bi, nkk'nwobha ttara Laban ttẹwọr mada mfofon maa apyiri ma. ");
INSERT INTO mfo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Kaam nkk'abhaam, ọmaana nnyanyaang, ọmaana arukhimaan, ọmaana avu, ọmaana atzọhmnọng p'ijinọng ttara p'ipanọng ngaama. Kaam nna ndọhmi ẹkkaabha nda nchena itta kwaam, ifha ndọkha ọphyaam k'itzitzikha sọ.’ ” ");
INSERT INTO mfo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Mada akkaabh-nkkaabha pa Jekọb akhun atzor-ẹ, bẹ agbaakh-ẹ bi, “Mokk'agbaanakka Ẹsau ọtza ọra, kẹ oreng k'eden okwuma bi, okwu ọrọ-ọ e. Kẹ ọkhaam anọng ẹnọhna p'atzọn-ẹ abẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Wa Jekọb ojor-ẹ, ettem ẹyakh-ẹ atzim. Mẹ wọ, ọbhaangi anọng p'otzim ka ngaan mfa, obiro ọbhaangi arukhimaan, ọmaana abhaam, ttara akamẹl. ");
INSERT INTO mfo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Jekọb on-oben for sẹ bi, “Idikha Ẹsau orim ẹkhaan dani abẹ, ẹkhaan ndonggo ch'erikhi ẹrọbh-ọrọbh ẹnaanga.” ");
INSERT INTO mfo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Iwa Jekọb ozi njọhm, oben bi, “Ọvaar Ibinọkpaabyi kw'itta kwaam Abraham, ọmaana kw'otte kwaam Isaak, Ọvaar Ibinọkpaabyi kw'oben-m bi, rọhng abhana k'ẹkhọma chọ, atzor anọng pọ, obiro ochekhi bi, kaam nsi idik ijibh inang-ọ. ");
INSERT INTO mfo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Kaam ọtzọhmnọng kwọ k'ọphyaam fọ, ọmaana k'idadaakha sọ biphyir, kimbaan. Wa kaam ndim ochikhura kwaam kẹ-khẹ njekha ọraanga kwa Jọrdan, manya, kaam nkk'ẹkhakhaama nsa, matzẹmaa nna mmaangi chẹ ka ngaan mfa. ");
INSERT INTO mfo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Tzotzokhaan, kkaan-m, arọbh-m ka mbọhk s'ọgbaanọkka kwaam Ẹsau, okhuri bi, ojora faam ode bi, kẹ ófha okwu ofhu man biphyir, ttara va ọmaana abọkka. ");
INSERT INTO mfo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Yina, kọ akk'achekhi anang kaam bi, asi-m ńgaama ẹkhakhaama, abira ási va pa va paam ahaabh mach'oyeyeng kw'ọraanga ọkhaan-ọkhaan, kw'ọnọng on-ofha obhik.” ");
INSERT INTO mfo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Iwa Jekọb oyima m'ibe nna m'erungiwu nduma. Otzekha ẹnanga k'ottem kw'ekpo py'ọkhaam ọnang ọgbaanọkka Ẹsau. ");
INSERT INTO mfo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Obhik kw'ekpo py'otzek bi ọnang-ẹ ode: avu-gbokha arọbh jobh, ọmaana abhumkpẹ ẹrọbh, ọmaana arukhimaan-kwa arọbh jobh, ttara arukhimaan-dim ẹrọbh, ");
INSERT INTO mfo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ọmaana akamẹl-papẹ ẹrọbh obhiri jobh ttara va pabẹ p'atzima ajaabh ẹba, ọmaana abhaam-papẹ arọbh afa, ọmaana abhaam-dim jobh, ọmaana anyanyaang-papẹ ẹrobh, ttara anyanyaang-dim jobh. ");
INSERT INTO mfo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Jekọb ọtzọkha sẹ ohok ka ngaan, ka ngaan. Ọtzọkha ẹkhaan kpenamkpen ọnang ọtzọhmnọng wani bi okkeri, oben bẹ bi, “Bọng chi kaam eden arọhng, bọng abira anang ayok ọphaangi k'orenga kwabọng.” ");
INSERT INTO mfo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ọn-ọtzọr oyok kw'ochi eden itzọhng, oben bi, “Idikha ọgbaanọkka kwaam Ẹsau ottem-ọ abẹ, ọbọbh-ọ bi, ‘Kọ ade kw'anyi? Kọ am-atza maan ma? Nden s'anyi rọ sa kọ am-akkeri?’ ");
INSERT INTO mfo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Kọ abhin-ẹ bi, ‘Itta kwaam, ekpo mbya biphyir ede py'ọtzọhmnọng kwọ, Jekọb. Pyẹ ede ẹnanga ch'ọtzọhmi ochena itta kwaam Ẹsau, kẹ ọkhaam oreng k'eden okwuma e.’ ” ");
INSERT INTO mfo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Wa Jekọb obiro oben ẹkhaan ch'ettong mfa, ọmaana ch'ettong nttaan, ttara ayok mbonggo biphyir p'atzori etzirakpo nnam bi, “Mada bọng akhebha Ẹsau, bọng gbaakh-ẹ odik nwuma wani kwa mgbaakhi ochedennọng. ");
INSERT INTO mfo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Bọng jima bi agbaakh-ẹ bi, ọtzọhmnọng kwọ, Jekọb, otzori man nnam okwuma k'eden e.” Da kẹ, Jekọb ochibhi bi, “Kaam ncheden ndọhm ẹnanga nda bi, ndima ndir-ẹ nttem, ifha sa on-ore-m, asi mẹ, okhera bi ọtzọkh-m.” ");
INSERT INTO mfo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Mẹ wọ, atzọhmnọng pa Jekọb acheden atzima ẹnanga akwọbha, yina, kẹ ọkhaam oyima m'ibhingabe sẹ m'erungiwu nduma. ");
INSERT INTO mfo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","M'erungiwu nduma dani, Jekọb obina ọtzọkha panọng pẹ afa, ọmaana atzọhmnọng pẹ p'ipanọng afa, ttara va pẹ p'ijinọng jobh obhiri wani, ọtzọhm bẹ arenga k'okhubha kw'ogbin-ogbini ajekha ọraanga kwa Jabọk. ");
INSERT INTO mfo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Mada ọkk'anọng mba biphyir ọtzọhma ajekha ekhekha, obiro okwu ọtzọhm anọng ttara ẹkhakhaama chẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Mẹ wọ e, Jekọb on-owobha mancheni. Ojinọng wani oyin-ẹ abẹ, osi erima ttar-ẹ, matzẹmaa ewu ehobha. ");
INSERT INTO mfo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Mada ojinọng nwa ore bi, Jekọb mkpaan kofha ọyọhnga, on-obun-ẹ ọttọhk k'ogbok osi ọkhọbhi kw'ogbok ọkpara eho, da bẹ atzima asi erima osi. ");
INSERT INTO mfo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Mẹ wọ, ọnọng nwa oben Jekọb bi, “Tte kaam ọbọhk mfona, kkeri ewu em-ehobh.” Yina, Jekọb obhin-ẹ bi, “Kaam kọ ọbọhk kintte, kw'oyongi bi ado-m.” ");
INSERT INTO mfo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Mẹ wọ, ọnọng nwa ọbọbh-ẹ bi, “Kọ akpen yan?” Obhin-ẹ bi, “Kaam mkpen Jekọb.” ");
INSERT INTO mfo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ọnọng nwuma on-oben-ẹ bi, “Ttẹwọr mayina, kọ Jekọb dọk kàkpena, an-akpena Israẹl, okhuri bi, kọ akk'erima asa ttara Ibinọkpaabyi, ọmaana anọngẹya, yina, kọ akk'akhema.” ");
INSERT INTO mfo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Iwa Jekọb on-oben bi, “Tzotzokhaan, kọ gbaak-m che chọ.” Ọnọng nwa ọbọbh-ẹ bi, “Osi yan kw'abọbh-m che chaam?” Mando kw'ọnọng nwa odo Jekọb m'ibe nnuma. ");
INSERT INTO mfo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Wa Jekọb on-oyeri ibe nna Pẹniẹl, oben bi, “Kaam nkk'Ibinọkpaabyi nna itzitzikha ttara itzitzikha, yina, kaam kimpe, ndimi nnukhi akpen.” ");
INSERT INTO mfo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","K'ogbe kw'ewuchen eyini wọ kwa Jekọb om-ogbekhi ọkwọbha Pẹniyẹl, okhuri ọkhọbhi kwẹ kw'ogbok kw'ọkpar eho. ");
INSERT INTO mfo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Kẹ wọ osi, mapyiri k'ewu cha mayina, anọng p'Israẹl bẹ ayara p'abọk eje ch'ogbok kachi, okhuri eje ch'ogbok kwa Jekọb ch'iwa ọnọng obuni ọttọhk. ");
INSERT INTO mfo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Mada Jekọb otzini chen, ore ọgbaanọkka Ẹsau da om-otzima anọng pẹ ẹnọhna okwu. Mando kw'ọtzọk va pẹ okkema ọnang abọkka. Ọtzọkha ọnang Lea, ọmaana Rachẹl, obiro ọtzọkha ọnang atzọhmnọng pabẹ p'ipanọng afa. ");
INSERT INTO mfo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Wa ọtzọkha atzọhmnọng mba p'ipanọng ttara va pabẹ otzima ochi eden, Lea ttara va pẹ atzor bẹ nnam, yina Rachẹl ttara Josẹph an-akponga nnam. ");
INSERT INTO mfo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Wa Jekọb ma for sẹ ochi eden orenga otzor ọgbaanọkka ka for. Mada ọbaang-ẹ ka for, ọrakha ottima itzitzikha k'irerek igbe izenamfa. ");
INSERT INTO mfo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Yina, Ẹsau ọrọbh ọtza ọgọhma Jekọb, ọkhaar-ẹ mbọhk k'ekhokhora, obira ọbaakh-ẹ. Bẹ anọng afa abhom. ");
INSERT INTO mfo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Mada Ẹsau otzini chen ore panọng ttara va, ọn-ọbọbh bi, “Bọng anọng bọ bọng atzọni kẹ-ẹ?” Jekọb obhin-ẹ bi, “Va p'Ibinọkpaabyi ọkk'ọtzọhmnọng kwọ ọnanga k'ọphyaam, bọ mẹ e.” ");
INSERT INTO mfo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Mẹ wọ, atzọhmnọng p'ipanọng ọmaana va pabẹ arenga atzor-ẹ ka for, bẹ arakha attima otzitzikha k'irerek anang-ẹ ikpokpobha. ");
INSERT INTO mfo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lea ttara va pẹ ajema, bẹ abira attima otzitzikha k'irerek, yina Rachẹl ttara Josẹph an-akpong nnam akwu attima itzitzikha k'irerek anang-ẹ ikpokpobha. ");
INSERT INTO mfo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ẹsau ọn-ọbọbh bi, “Anọng mba p'ira ngebh, ttara ngaan s'etzirakpo pya bẹ atzima akwu, atzọhmi bẹ bi, bẹ akwu asi yan o?” Jekọb oben bi, “Itta kwaam, ndim pyẹ bi ndọkha ọphyaam k'itzitzikha sọ e.” ");
INSERT INTO mfo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Yina, Ẹsau on-oben bi, “Mma e, ọgbaanọkka kwaam, kọ khaama ekpo pyọ, kaam nkk'ekpo ngaama k'ọhaabh py'ebeng-m e.” ");
INSERT INTO mfo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jekọb, obhin-ẹ bi, “Mma o, ngwukh-ọ okhukhi. Kọ tzọkha ẹnanga cha nnang-ọ, idikha ọphyaam f'asi anang-m, ofon-ọ k'ettem. Ẹra cha kaam nnọ-ọ ma, okheri macha nne itzitzikha s'Ibinọkpaabyi e, da kọ atzọkh-m k'ọphyaam. ");
INSERT INTO mfo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Tzotzokhaan, khera bi atzọkha ẹnanga nda cha nnang-ọ, da Ibinọkpaabyi okk'aam ọda ttara ọttọhk kpenamkpen fa kaam nnori.” Mada Jekọb ochin ororo ọgbana bi, ọgbaanọkka ọtzọkha ẹnanga cha ọnang-ẹ, Ẹsau okhera ọtzọkha. ");
INSERT INTO mfo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Mando kw'Ẹsau on-obeni bi, “Tte mofona, kaam ńchọ-ọ eden.” ");
INSERT INTO mfo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yina, Jekọb oben-ẹ bi, “Itta kwaam, kọ arong kẹ bi, va paam atzima akhar-ọkhara, bẹ ẹfa kakhaam, ttara bi, etzirakpo pyaam etzim ẹrọkhi ayok p'ikhakhari ọrọk. Idikha motzim pyẹ orenga m'ẹbhar-ẹbhar, k'ewu dani chẹ-chẹ, pyẹ épe-ope biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mẹ wọ, tte itta kwaam ochi ọtzọhmnọng kwẹ eden, ifha kaam ndima etzirakpo mbya ọmaana va mba, mfumetzen nnenga, matzẹmaa mokhebha ayok ka Seir.” ");
INSERT INTO mfo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Mẹ wọ, Ẹsau on-oben bi, “Tte ntte anọng paam bani ọbọhk, bẹ atzọn-ọ abẹ.” Jekọb on-obhin-ẹ bi, “Sam e, itta kwaam, okhuri yan kw'abira ayak for sọ atzim o? Tte kaam ndọkha ọphyaam fọ fẹ-fẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","M'ewu nduma dani, Ẹsau obina orenga okhuna ka Seir. ");
INSERT INTO mfo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yina, Jekọb ochina ka Sukọt. Kẹ wọ kw'iwa osi ọhọhm kw'owobh, obiro osi okhira f'etzirakpo pyẹ. Kẹ wọ osi bẹ ayeri ibe nnuma Sukọt. ");
INSERT INTO mfo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Wa k'ekponga-nnam, Jekọb ofon ka Padan-Aram orenga maa okwu opyiri k'odedenmon kwa Shẹkẹm, k'ẹkhọma cha Kenaan, osi ibhingabe mẹ ọbaanga odedenmon nwa. ");
INSERT INTO mfo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Wa Jekọb okwu odebh okhubha kw'irerek kw'ottim ikhira, ka mbọhk sa va pa Hamọr, kw'ode otte kwa Shẹkẹm, k'asilva arọbh azen. ");
INSERT INTO mfo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","M'ibe nna rọ sa Jekọb osi ijafọhnibe, obiro oyeri ibe nna Ibinọkpaabyi ode Ibinọkpaabyi kw'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Wa k'ogbe wani, Daina, kw'ode nnwa kw'ikwanọng kwa Lea ọkk'ọmaana ọnang Jekọb, oyini k'iyaan ọtza odibh panọng p'obhon nwuma. ");
INSERT INTO mfo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Mada Shẹkẹm kw'ode nnwa kwa Hamọr, kw'ode ọvaarnọng kw'anọng pa Hiv ore Daina, ọbọkh-ẹ k'ẹfa oyima abẹ. ");
INSERT INTO mfo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Mando kwa Shẹkẹm ọtzọkha ettem chẹ biphyir ọgbana ka Daina, kw'ode ominanwa kwa Jekọb. Wa Daina ọdaakh-ẹ oyong-oyongi, on-okhonga bi, ọsẹ-ẹ okhera eyonga chẹ. ");
INSERT INTO mfo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Mẹ wọ, Shẹkẹm oben otte kwẹ Hamọr bi, “Itta, kọ tzọkha ominanwa nwa anang-m, mọba ayok.” ");
INSERT INTO mfo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Iwa va pa Jekọb p'ijinọng atzim awobh k'owoni, da bẹ atza anang etzirakpo pyẹ ọchattọhk, k'ogbe kwa Jekọb ọbhaang bi, bẹ akk'ominanwa kwẹ, Daina, ọgbasadik asa. Mando kw'omyi odik nwa maa va pẹ akhuna. ");
INSERT INTO mfo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Iwa Hamọr kw'ode otte kwa Shẹkẹm ofona bi ọtza ọttọhna odik nwa ttara Jekọb. ");
INSERT INTO mfo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Mada va pa Jekọb an-afon kẹ da bẹ akkeri etzirakpo akhuna, bẹ abhaanga odik kw'otto da bẹ anade. For ipe bẹ, nttem mbiri mpyibh bẹ okhuri ọgbasa-dik kwa Shẹkẹm ọkk'ọsa k'Israẹl bi, ọbọkha ominanwa kwa Jekọb oyima abẹ k'ẹfa, odik kw'oni ọbabaana ọbaan. ");
INSERT INTO mfo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Yina, Hamọr oben bẹ bi, “Tzotzokhaan, bọng tte nnwa kwaam Shẹkẹm ọbọhk ọtzọkha ominanwa kwabọng, ettem chẹ biphyir ẹn-ẹgban ma kẹ e. ");
INSERT INTO mfo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Bọng mọtzọkha ayok k'ọbada, tte ajinọng paman atzọkha aminava pabọng, ifha bọbọng abira atzọkha aminava paman. ");
INSERT INTO mfo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Bọng afha aruk ma ttara man, irerek iyim mẹ maa arọhng bi, bọng aruk abira arenga mphya kpenamkpen, ttara bi bọng abira afha akhaama orerek fabọng ọkhaam.” ");
INSERT INTO mfo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Mẹ wọ, Shẹkẹm oben otte ttara agbaanatte pa Daina bi, “Bọng tte kaam ndọkha ọphyaam kabọng k'itzitzikha, kaam ndo for bi, nnang bọng ọttọhk kpenamkpen fa bọng aben bi, ńnang k'eho ch'ominanwa kwabong. ");
INSERT INTO mfo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Bọng gbaakh-m ẹphya ch'imina sẹ, ọmaana ekpo kpenamkpen biphyir py'ẹbari macha kọ, pya kaam mbaan bi idima nkwu, k'odem kw'ọdaakhi bọng. Kaam ńnang bọng ọnang, bọng kinggẹ nang-m ominanwa nwa ndọkh-ẹ k'ọbada.” ");
INSERT INTO mfo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Wa va pa Jekọb arenga ọgbasa-dik kw'ọkk'ọtta okhebha ọgbaanotte kwabẹ Daina abẹ, abọhra Shẹkẹm ttara otte kwẹ Hamọr. ");
INSERT INTO mfo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Bẹ aben bi, “Man odik-dema nwa kofha osi. Ode ọgbasa-dik ọnang man bi, mọtzọkha ọgbaanotte kwaman ọnang ọnọng kw'oni ọkpakkọrikkọ osi, k'ọbada. ");
INSERT INTO mfo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Eden obungichẹ cha mókhera ttara bọng ede bi, bọng an-ade macha man, ojinọng kpenamkpen k'ottem kwabọng ọkhaambi osi ọkpakkọrikkọ. ");
INSERT INTO mfo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Mẹ wọ kwa maman ótzima okhera ttara bọng bi, ajinọng pabọng átzọkha panọng paman, maman obiro okhera bi mọ́tzọkha panọng pabọng. Mẹ kwa móbiro oruk ttara bọng, man biphyir món-ode wani, macha bọng aphyemi. ");
INSERT INTO mfo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Yina, idikha bọng ánakhera bi, asi ọkpakkọrikkọ, man kokhera bi, bọng atzọkha ominanwa kwaman k'ọbada, mótzim-ẹ otzima ofona e.” ");
INSERT INTO mfo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Wa Hamọr, ttara nnwa kwẹ Shẹkẹm are bi, ochibhi kwa va pa Jekọb asi ojibh-ojibh. ");
INSERT INTO mfo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Wa Shẹkẹm ode ojinọng kw'efona chẹ biphyir ẹm-ẹnang ikpokpobha, okhuri da ominanwa kwa Jekọb ọkk'ẹ ọdaakha, ogbe dọk kokhibhi, okhera bi, osi ọkpakkọrikkọ. ");
INSERT INTO mfo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Mẹ wọ, Hamọr ọmaana nnwa kwẹ Shẹkẹm afona achina k'ipha s'obhon bi, bẹ atza agbaak anọng pabẹ ochibhi nwa. ");
INSERT INTO mfo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Bẹ agbaak ajinọng p'obhon nwa bi, “Ajinọng mba ajibhi ẹmmaana atzima atzor man. Tte bẹ aruk m'irerek saman, bẹ abira arenga mphya, mgba irerek ibar-ọbar s'ibenga be. Mọfha ọtzọkha aminava pabẹ, bẹ abira afha atzọkha aminava paman. ");
INSERT INTO mfo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ajinọng mba akhera bi, aruk ttara man mach'anọng bani ka nttak bi, mọkhaambi osi ajinọng paman ọkpakkọrikkọ, macha bẹ-bẹ asi. ");
INSERT INTO mfo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Mokker-okkeri, ẹkhakhaama chabẹ biphyir, ọmaana etzirakpo pya bẹ biphyir éde pyaman. Mẹ wọ, tte mokhera ttara bẹ, mosi mando, ifha bẹ an-aruk ttara man.” ");
INSERT INTO mfo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Wa anọng mba biphyir p'awobh m'ipha akhera ttara Hamọr ọmaana nnwa kwẹ Shẹkẹm. Ofona mẹ, ojinọng kpenamkpen kw'obhon nwa, ofona ochina k'ipha s'obhon bi, bẹ asẹ-ẹ ọkpakkọrikkọ. ");
INSERT INTO mfo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Mada iwu ittaan ikk'ikwọbha sa bẹ asi bẹ ọkpakkọrikkọ, da bẹ atzima awobh k'ọmmamma, va pa Jekọb afa kw'ode Simeọn ttara Lẹvi, vọkka pa Daina, atzini akkangkkaang pabẹ, k'ogbe kw'anọng p'obhon ani chen ahokhi, bẹ afhu ajinọng biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Bẹ atzima akkangkkaang pabẹ afhu Hamọr ọmaana nnwa kwẹ, Shẹkẹm. Bẹ abira adim k'ọhọhm kwa Shẹkẹm, atzọkha Daina atzima afona. ");
INSERT INTO mfo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Mada va mbonggo pa Jekọb akwu are bi, ajinọng p'obhon an-ayim abukhi-abukhi biphyir, bẹ an-adim k'obhon kw'anọng p'asi ọgbaanotte kwabẹ ọgbasadik, achi ọgbọm. ");
INSERT INTO mfo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Bẹ atzọkha etzirakpo, ọmaana abhaam, ọmaana nnyanyaang, ttara ekpo kpenamkpen m'obhon nwa, atzima afona. ");
INSERT INTO mfo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Bẹ achi ọgbọm k'ọttọhk kpenamkpen fa bẹ are m'obhon nwa, ẹkhakhaama kpenamkpen, ọmaana panọng biphyir, ttara va pabẹ k'ihọhm, atzima afona. ");
INSERT INTO mfo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Mẹ wọ, mada Jekọb okwu oronga odik nwa, oben Simeọn ttara Lẹvi bi, “Bọng akk'aam akha ka dama-dama, bọng abira asi-m mkpukhi anọng pa Kenaan idik, ọmaana anọng pa Pẹriz p'ade anọng p'arukhi m'irek nna. Bọng akk'ara bi, ọnọng-mik ajinọng paman kọhaabi. Anọng mba agbak mbọhk bi, arim-m abẹ, bẹ adim-m ttara ẹhọhmmọr chaam biphyir.” ");
INSERT INTO mfo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Yina, bẹ abhin-ẹ bi, “Shẹkẹm wọ ira ọn-ọtzọk ọgbaanotte kwaman mach'ọzaza o?” ");
INSERT INTO mfo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Iwa Ibinọkpaabyi oben Jekọb bi, “Vura achina ka Bẹtẹl, asi oruk kwọ mẹ, abira asi ijafọhnibe mẹ anang Ibinọkpaabyi kw'oyin-ọ abẹ k'ogbe kw'iwa arọbhi ka mbọhk s'agbaanakka, Ẹsau.” ");
INSERT INTO mfo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Mando kwa Jekọb obeni ẹhọhmmọr chẹ, ọmaana anọng biphyir p'awobh ttar-ẹ bi, “Bọng nọbha agbatza p'ikhekhenmon p'awobh k'ottem kwabọng, bọng ahok for sabọng iwur-owur, bọng abira abhona ẹmmaana chabọng. ");
INSERT INTO mfo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Mẹ wọ, bọng kwu movura ochina ka Bẹtẹl, kẹ da kaam ńsi ijafọhnibe nnang Ibinọkpaabyi, kw'ọbhaang-m k'ogbe kw'ọmmamma, kw'okk'obiro owobha ttar-m k'ibe kpenamkpen sa nkk'nda.” ");
INSERT INTO mfo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Mando kwa bẹ ọtzọk agbatza p'ikhekhenmon biphyir pa bẹ akhaam, ọmaana ekpo py'itzọhng pya bẹ akhe, atte ọbọhk anang Jekọb. Jekọb ọtzọkha pyẹ ọnọhnga k'echirin ch'oak ka Shẹkẹm. ");
INSERT INTO mfo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Mẹ wọ, bẹ abina orenga, ojora f'ideden f'Ibinọkpaabyi ọnwa ibhon biphyir s'ibaang bẹ, maa ọnọng kw'ọfha okhubh va pa Jekọb kode. ");
INSERT INTO mfo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jekọb ọmaana anọng pẹ biphyir apyiri ka Luz, kw'obiro okpena Bẹtẹl, k'ẹkhọma cha Kenaan. ");
INSERT INTO mfo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Mẹ wọ kwa Jekọb osi ijafọhnibe, okpe ibe nna, Ẹl-Bẹtẹl, okhuri bi, mẹ wọ kw'iwa Ibinọkpaabyi osi ẹjaakhi cha for sẹ ọnang-ẹ, k'ogbe kw'iwa ọrọbhi oji ọgbaanọkka Ẹsau. ");
INSERT INTO mfo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Wa Dẹbọra kw'ode ọrọrọkha kwa Rẹbẹka ope. Bẹ anọhng-ẹ k'echirin ch'oak ch'ewobh k'ebhonho cha Bẹtẹl. Mẹ wọ, bẹ ayeri ibe nnuma “Oak kw'Obhoma.” ");
INSERT INTO mfo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Mada Jekọb ofon ka Padan-Aram okhuna, Ibinọkpaabyi obiro oyin-ẹ abẹ, ọdẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ibinọkpaabyi oben-ẹ bi, “Kọ akpen Jekọb, yina, Jekọb dọk kakpena, án-akpena Israẹl.” Mẹ wọ, Ibinọkpaabyi ọkpẹ-ẹ Israẹl. ");
INSERT INTO mfo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ọvaar Ibinọkpaabyi oben-ẹ bi, “Kaam wọ nde Ibinọkpaabyi kw'Ẹfa biphyir; kọ bhon va k'ọhaabh. Ẹkhọma, ọmaana obhon kwa ngọma mfona ma ndaak sọ, avaar abira áfona ka va pa va pọ. ");
INSERT INTO mfo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Irek s'iwa nnangi Abraham ọmaana Isaak, rọ sa kaam ńnang-ọ, sẹ rọ sa kaam mbiri ńnang va pa va pọ.” ");
INSERT INTO mfo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Mẹ wọ, Ibinọkpaabyi obina oji Jekọb m'ibe nnuma s'okk'atzim ọgbaakha ttar-ẹ, ofona. ");
INSERT INTO mfo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jekọb ọtzọkha ọtza ofhu m'ibe nnuma s'Ibinọkpaabyi okk'atzim ọgbaakha ọnang-ẹ, osi ẹnanga-ebyengichẹ mẹ, obiro osi ẹnanga ch'etzuk-byengi m'ọtza nwa. ");
INSERT INTO mfo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Wa Jekọb oyeri ibe nnuma s'ibinọkpaabyi okk'atzim ọgbaakha ttar-ẹ, Bẹtẹl. ");
INSERT INTO mfo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Wa bẹ abin orenga ka Bẹtẹl, am-achina k'ẹkhọma ch'Ẹphrat. Mada bẹ abhiri eden k'Ẹphrat, ọmaan f'ọgaang-ọgaangi ọttẹwọr osi Rachẹl. ");
INSERT INTO mfo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Mada ọm-ọtzọkha ọmmamma bara-mbar kw'ọmaan, kwanọng kw'om-okkeri ọmaan oben-ẹ bi, “Oning-ọ ojor, kkeri kọ akk'nnwa kw'ijinọng abira amaana.” ");
INSERT INTO mfo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Mada oji ikponga-nnam-wọhng s'on-ope, okpe nnwa kwẹ Bẹn-Oni. Yina, otte Jekọb ọkpẹ-ẹ, Bẹnjamin. ");
INSERT INTO mfo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Mẹ wọ, Rachẹl ope, bẹ anọhng-ẹ k'eden ch'echin k'Ẹphrat, kw'ode Bẹtẹlẹhẹm. ");
INSERT INTO mfo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jekọb ọtzọkha ọtza ofhu ebebe k'epekhubh cha Rachẹl. Maa pyiri ma, ọtza nwuma wọ ode ẹkhọhkha ch'epekhubh cha Rachẹl. ");
INSERT INTO mfo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Jekọb kw'on-okpen Israẹl ochina ororo k'orenga kwẹ, obiro osi ikhira oyongi k'okhubha kwa Migdal-Eder. ");
INSERT INTO mfo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Mada Israẹl orukhi m'ẹkhọma nduma, wa Reubẹn odim kẹ oyima Bilha kw'ode ọkkọra-kwanọng kw'otte abẹ, iwa Israẹl okwu ọbhaanga odik nwa. Iwa Jekọb obhoni va p'ijinọng jobh obhiri afa: ");
INSERT INTO mfo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Va p'ijinọng pa Lea ade: Reubẹn kw'ode ocheden nnwa kwa Jekọb, ọmaana Simeọn, ọmaana Lẹvi, ọmaana Juda, ọmaana Isaaka, ttara Zẹbulun. ");
INSERT INTO mfo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Va pa Rachẹl ade: Josẹph, ọmaana Bẹnjamin. ");
INSERT INTO mfo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Va p'ijinọng pa Bilha kw'ode ọtzọhmnọng kwa Rachẹl bẹ ade: Dan, ọmaana Naphtali. ");
INSERT INTO mfo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Va p'ijinọng pa Zilpa kw'ode ọtzọhmnọng kwa Lea bẹ ade: Gad, ọmaana Ashẹr. Ma wọ ode va p'ijinọng p'iwa Jekọb obhoni ka Padan-Aram. ");
INSERT INTO mfo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Wa Jekọb ọkpa nnam otzor otte Isaak ka Mamrẹ, kw'ọbaang Kiriyat-Arba (kwa bẹ abira ayeri Hẹbrọn), kẹ da Abraham ọmaana Isaak akk'arurukha. ");
INSERT INTO mfo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Biphyir-phyir wa Isaak orukhi cho arọbh ọhawani. ");
INSERT INTO mfo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Mẹ wọ, wa Isaak ope k'atzam otzor anọng pẹ p'akk'apa. Wa va pẹ Ẹsau ọmaana Jekọb, anọhng-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ma wọ ode efonamma ch'Ẹsau, kw'obiro okpena Edom. ");
INSERT INTO mfo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Wa Ẹsau ọtzọk panọng p'afon Kenaan. Oyok wani okpen Ada, kw'ode nnwa kw'Ẹlọn kw'ofon Het. Ottong panọng afa okpena Oholibama, kw'ode nnwa kw'Ana. Ana wa ode nnwa kwa Zibeọn kw'ofon Hiv. ");
INSERT INTO mfo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ottong panọng attaan okpena Basemat kw'ode nnwa kw'Ishimayẹl, obiro ode ọgbaanọkka kwa Nẹbayọt. ");
INSERT INTO mfo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Wa Ada ọmaani Ẹliphaz ọnang Ẹsau, Basemat ọmaan Reuẹl, ");
INSERT INTO mfo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama ọmaan Jeush, ọmaana Jalam, ttara Kora. Ma wọ ode va p'iwa bẹ amaani anang Ẹsau k'ẹkhọma cha Kenaan. ");
INSERT INTO mfo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ẹsau ọtzọkha panọng pẹ, ọmaana va pẹ, ọmaana anọng p'ọhọhm kwẹ biphyir, ọmaana etzirakpo pyẹ ttara nden sẹ, ttara ẹkhakhaama ch'ọkk'ọsa ka Kenaan biphyir, obina oji ọgbaanọkka Jekọb, ọtza oruk k'ibe s'ibhir-obhiri. ");
INSERT INTO mfo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Wa irerek sa bẹ anọng afa arukhi bẹ dọk kibeng, okhuri etzirakpo pyabẹ, da ẹkhakhaama chabẹ ẹkk'ẹn-ẹhaahba maa, eyongi k'odem kwa bẹ anọng afa abira aruk ibe rani. ");
INSERT INTO mfo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Mẹ wọ, Ẹsau kw'obiro okpena Edom ọtza osi oruk kwẹ k'okhubha kwa mgbegbeho sa Seir. ");
INSERT INTO mfo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ma wọ ode efonamma ch'Ẹsau kw'ode otte kw'ideden kw'anọng p'Edom k'okhubha kwa mgbegbeho sa Seir. ");
INSERT INTO mfo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ma wọ ode che pa va p'ijinọng p'Ẹsau: Ẹliphaz, nnwa kw'Ada ọmaani Reuẹl, nnwa kwa Basemat ọmaani. ");
INSERT INTO mfo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Va p'ijinọng p'Ẹliphaz obhoni ade: Teman, ọmaana Ọma, ọmaana Zepho, ọmaana Gatam, ttara Kenaz. ");
INSERT INTO mfo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ẹliphaz kw'ode nnwa kw'Ẹsau wa obiro ọkhaama ọkkọra-kwanọng kw'okpen Timna, kw'ọmaan-ẹ nnwa kw'okpen Amalẹk. Ada kw'iwa ode kwanọng kw'Ẹsau wọ iwa ode ọkka kw'ideden kwa va mba biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Va pa Reuẹl bẹ ade: Nahat, ọmaana Zẹra, ọmaana Shama, ttara Miza. Basemat kw'ode kwanọng kw'Ẹsau wọ iwa ode ọkka kw'ideden kwa va mba biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Va p'Oholibama kw'ode nnwa kw'Ana, kwa Zibeọn obhoni, p'iwa ọmaani ọnang Ẹsau bẹ ade: Jeush, ọmaana Jalam, ọmaana Kora. ");
INSERT INTO mfo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ma wọ ode avaar-efona p'efonamma ch'Ẹsau p'afon k'ẹnọmma ch'Ẹliphaz, kw'ode ocheden nnwa kw'Ẹsau obhoni. Va mba wa bẹ ade: Teman, ọmaana Ọma, ọmaana Zepho, ọmaana Kenaz, ");
INSERT INTO mfo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ọmaana Kora, ọmaana Gatam, ttara Amalẹk. Anọng mba bọ iwa atzim mvaar k'ẹnọmma ch'Ẹliphaz k'Edom. Ada wọ wa ode ọkka kw'ideden kw'avaar-efona mba biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Avaar-efona p'afon k'ẹnọmma cha Reuẹl kw'ode nnwa kw'Ẹsau obhoni k'ẹkhọma ch'Edom ade: Nahat, ọmaana Zẹra, ọmaana Shama, ttara Miza. Basemat wọ wa ode ọkka kw'ideden kw'avaar-efona mba biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Avaar-efona p'afon ka ndaak s'Oholibama kw'ode kwanọng kw'Ẹsau, obiro ode nnwa kw'Ana, bẹ ade: Jeush, ọmaana Jalam, ttara Kora. ");
INSERT INTO mfo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ma wọ ode va p'Ẹsau kw'obiro okpena Edom, ttara avaar-efona pa nnọmma sabẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ma wọ ode va p'ijinọng pa Seir kw'ofon Họr, p'iwa arukhi m'ẹkhọma nda: Lotan, ọmaana Shobal, ọmaana Zibeọn ttara Ana, ");
INSERT INTO mfo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ọmaana Dishọn, ọmaana Ẹzẹr, ttara Dishan. Ma wọ ode avaar-efona p'abaHọr, p'afon k'ẹnọmma cha Seir k'Edom. ");
INSERT INTO mfo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Wa va pa Lotan ade: Hori, ọmaana Homam. Timna kẹ wọ iwa ode ọgbaanọkka kw'ikwanọng kwa Lotan. ");
INSERT INTO mfo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Wa va pa Shobal bẹ ade: Alvan, ọmaana Manahat, ọmaana Ebal, ọmaana Shepho, ttara Ọnam. ");
INSERT INTO mfo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Wa Zibeọn obhoni Aiya, ttara Ana. Wa Ana nwa wọ ocheden ọtza ore ngekha s'asi akhọm-ọkhọm, k'ebherede, mada otzim nnyanyaang s'otte Zibeọn, ọtza ọnang ọchattọhk. ");
INSERT INTO mfo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Wa Ana obhoni Dishọn kw'ode ojinọng, ttara Oholibama kw'ode nnwa kw'ikwanọng. ");
INSERT INTO mfo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Va pa Dishọn wa bẹ ade: Hẹmdan, ọmaana Ẹshban, ọmaana Itiran, ttara Keran. ");
INSERT INTO mfo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Va p'Ẹzẹr ade: Bilhan, ọmaana Zaavan, ttara Akan. ");
INSERT INTO mfo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Va pa Dishan ade: Uz, ttara Aran. ");
INSERT INTO mfo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ma wọ ode avaar-efona p'abaHọr: Lotan, ọmaana Shobal, ọmaana Zibeọn, ọmaana Ana, ");
INSERT INTO mfo_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ọmaana Dishọn, ọmaana Ẹzẹr, ttara Dishan. Ma wọ ode avaar-efona p'abaHọr atzor ka ngọma sabẹ k'irek sa Seir. ");
INSERT INTO mfo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ma wọ ode avaar-efona p'iwa adabhi Edom yina iwa ọvaarnọng kpenamkpen ọn-ọdabhi anọng p'Israẹl: ");
INSERT INTO mfo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bẹla kw'ode nnwa kw'ijinọng kwa Beọr, wa okwu ode ọvaarnọng kw'Edom. Wa odedenmon kwẹ okpen Dinhaba. ");
INSERT INTO mfo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Mada Bẹla ope, Jobab kw'ode nnwa kwa Zẹra kw'ofon Bozra, on-okwu ode ọvaarnọng. ");
INSERT INTO mfo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Mada Jobab ope, Husham kw'ofon k'okhubha kwa Teman, on-okwu ode ọvaarnọng. ");
INSERT INTO mfo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Mada Husham ope, Hadad kw'ode nnwa kwa Bedad on-okwu ode ọvaarnọng. Hadad nwa wọ iwa orim anọng pa Midiyan abẹ k'ẹkhọma cha Moab, okhema bẹ. Wa odedenmon kwẹ okpen Avit. ");
INSERT INTO mfo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Mada Hadad ope, Samla kw'ofon Masareka, on-okwu ode ọvaarnọng. ");
INSERT INTO mfo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Mada Samla ope, Shaul kw'ofon Rehobot kw'owobh ọbaanga ọraanga, on-okwu ode ọvaarnọng. ");
INSERT INTO mfo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Mada Shaul ope, Baal-Hanan kw'ode nnwa kw'Akbọ, on-okwu ode ọvaarnọng. ");
INSERT INTO mfo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Mada Baal-Hanan kw'ode nnwa kw'Akbọ ope, Hadad on-okwu ọdabh. Wa odedenmon kwẹ okpen Pau. Wa kwanọng okpen Mehetabẹl kw'ode nnwa kw'ikwanọng kwa Matarẹd. Matarẹd wa ode nnwa kw'ikwanọng kwa Me-Zahab. ");
INSERT INTO mfo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ma wọ ode avaar-efona p'ẹnọmma ch'Ẹsau atzor ka che pabẹ, ọmaana ka nnọmma sabẹ, ttara ka ngọma sabẹ: Timna, ọmaana Alva, ttara Jetẹt, ");
INSERT INTO mfo_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ọmaana avaar Oholibama, ọmaana Ẹla ttara Pinọn, ");
INSERT INTO mfo_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ọmaana avaar Kenaz, ọmaana Teman, ttara Mibzar, ");
INSERT INTO mfo_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ọmaana Magdiyẹl, ttara Iram. Ma wọ ode avaar-efona p'Edom, atzor k'odem kw'iwa bẹ arukhi k'irerek sa bẹ asi oruk kwabẹ. Wa Ẹsau wọ ode itta kw'ideden kw'anọng p'Edom. ");
INSERT INTO mfo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Wa Jekọb orukhi k'obhon kw'otte okk'orurukha, kw'ode irek sa Kenaan. ");
INSERT INTO mfo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ma wọ ode odem kw'ẹhọhmmọr cha Jekọb. K'ogbe kw'iwa Josẹph ode odikkobh kw'ode cho chi obhiri afa, iwa ọm-ọtzọn votte pẹ abẹ, va pa Bilha ọmaana pa Zilpa am-akkeri etzirakpo py'otte. Wa Josẹph okwu ọpọhra osisi kw'ayok ọnang otte. ");
INSERT INTO mfo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","K'ottem kwa va pa Jekọb biphyir, Josẹph wọ iwa ọdaakhi otte ọtzam ọyọhnga va mbonggo, okhuri da iwa obhon-ẹ k'atzam. Mẹ wọ, okhum ọnọhma-baba kw'ọkkẹri adem ọnang-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Mada votte are bi, Josẹph ọdaakhi otte kwabẹ idik ọyọhnga bẹ, bẹ an-attaang-ẹ maa, bẹ atzim p'amọm-ọmọm dọk kakhaam pa bẹ agbaakhi anang-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Wa Josẹph okwu ọttaara idachen, mada ọgbaakhi votte pẹ idachen nna, bẹ an-adẹ-ẹ attaanga-ọttaanga. ");
INSERT INTO mfo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Oben bẹ bi, “Tzotzokhaan, bọng yonga itzọhng abhaanga idachen sa kaam nttaar e. ");
INSERT INTO mfo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","K'idachen, kaam nttaar da mowobh k'owoni ọm-ọdabh abarli-khe, nna ngen-okheni nne da ekhe chaam en-ebe idumsẹ, egori ẹyọhnga akhe pabọng. Akhe pabọng an-akhọri chaam akhe k'ottem, bẹ abira arakha nho anang ekhe chaam k'ikpokpobha.” ");
INSERT INTO mfo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Votte pẹ abhin-ẹ bi, “Ode bi kọ am-achibhi bi, maman owobha k'irekh-irek kwọ o? Kọ achibhi k'odik ọkkakka bi, kọ wọ áde man ọvaarnọng o?” Mẹ wọ, bẹ an-adẹ-ẹ attaanga-ọttaanga, okhuri idachen sẹ ọmaana idik s'okk'bẹ ọgbaakha. ");
INSERT INTO mfo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Wa Josẹph obiro okwu ọttaara idachen idọdọk, ọtzọkha sẹ ọgbaak votte pẹ, oben bi, “Bọng yong-m itzọhng, kaam nkk'idachen idọdọk mbiri nttaara e. Nttaar da ewuchen, ọmaana ophe, ttara ndodori jobh obhiri wani nchung nnang-m ikpokpobha.” ");
INSERT INTO mfo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Mada Josẹph obiro ọgbaak otte idachen s'ọttaar, otte ọkpẹ-ẹ eden bi, tte oningi odik-dema nwa dọk ọgbaakhi, oben bi, “Bọng idachen-dema s'attaar mẹ? Ode bi kọ ahokhi k'odik ọkkakka bi, kaam ọmaana akka, ttara votte pọ mochunga nho k'irerek ọnang-ọ ikpokpobha o?” ");
INSERT INTO mfo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Mẹ wọ, wa votte pa Josẹph an-akhaama ottemmama ttar-ẹ. Yina, Jekọb kw'ode otte kwẹ on-okhe idik nna k'ettem. ");
INSERT INTO mfo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Wa ewu dani votte pa Josẹph an-atzima etzirakpo py'otte kwabẹ, atza anang ọchattọhk kẹ ọbaanga Shẹkẹm. ");
INSERT INTO mfo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Iwa Jekọb oben Josẹph bi, “Kọ arong kẹ bi votte pọ awobh kẹ da bẹ anangi etzirakpo ọchattọhk kẹ ọbaanga Shẹkẹm. Kaam nna ndọhm-ọ kẹ da bẹ awobh.” Josẹph obhina bi, “Iya itta, tzọhm-m e.” ");
INSERT INTO mfo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Iwa Israẹl ttara Josẹph awobh k'Ẹttẹri cha Hẹbrọn, mẹ wọ, Israẹl ọtzọhm Josẹph bi, ọtza oror votte pẹ ọmaana etzirakpo, kẹ da bẹ awobh abaanga Shẹkẹm. Mada Josẹph opyiri ka Shẹkẹm, ");
INSERT INTO mfo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ojinọng wani ọrẹ-ẹ kẹ da om-ottena k'iwoni, ọbọbh-ẹ bi, “Mbọng f'am-aror o?” ");
INSERT INTO mfo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Josẹph obhin-ẹ bi, “Kaam mminnor votte paam e, tzotzokhaan na afha agbaakh-m ibe sa bẹ am-anang etzirakpo ọchattọhk o?” ");
INSERT INTO mfo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ojinọng nwa obhina bi, “Bẹ akk'abina manya e. Kaam mmaang da bẹ abeni ayok bi, ‘Tte mochina ka Dọtan.’ ” Mando kwa Josẹph ofon ọtza okhebha votte pẹ ka Dọtan. ");
INSERT INTO mfo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Yina, bẹ arẹ-ẹ da om-orenga okwu k'odenmir. Yina ọbaanga kẹ da bẹ awobh, bẹ akk'nttọhna akyera sa bẹ afhẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Wa bẹ aben ayok bi, “Bọng kker e, ọttaar-ọdachen nwuma wọ om-okwu kana e. ");
INSERT INTO mfo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Bọng kwu, tte mọfhẹ-ẹ ọbhari k'ipekhuma rani mẹ, ifha mọkk'ọbhana, mọtza ọgbaak otte kwaman bi, etzen ch'ẹtzam dani dọ ẹfhẹ-ẹ, ifha mowobha ma ore, odem kw'ọdachen mvuma fẹ obiro okwu ode mach'ochibhi.” ");
INSERT INTO mfo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Yina, mada Reubẹn ọbhaang odik nwa, okhonga bi, ọkkaan-ẹ ka mbọhk sa bẹ, oben bẹ bi, “Tte moning-ẹ ofhufhu-ofhu e. ");
INSERT INTO mfo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Tte mokhinggẹ ọbhar-ẹ m'ipekhuma nna s'ebherede. Bọng ọnọng kàfhu.” Iwa Reubẹn ọgbaakhi odik nwa ifha ọkkaana akpen pa Josẹph, ifha obiro otzim-ẹ ochena otte kwabẹ. ");
INSERT INTO mfo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Mada Josẹph opyiri kẹ da votte awobh, bẹ abọkh-ẹ awọra ọnọhma-baba jibh-anjibh kw'ọfọr ka for. ");
INSERT INTO mfo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Bẹ atzọkh-ẹ abhari k'ipekhuma s'asi anade. ");
INSERT INTO mfo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Mada bẹ an-awobh ẹwọr bi bẹ achi ọchattọhk, bẹ atzini chen akkeri k'ororo, are da ẹkhaan ch'aphyaphyaa p'Ishimayẹl p'am-atza orenga, am-afona k'obhon kwa Gilead ahakha, ttara akamẹl pabẹ p'atzọhk ekpo py'ẹdaami eruk, ọmaana ana p'adaami eruk k'adem-k'adem, pa bẹ atzim am-ahakha achina k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Mẹ wọ, Juda ọbọbh votte pẹ bi, “Mbọng vọ óde iru saman idikha mofhu ọgbaanotte kwaman modubha obo kwẹ o? ");
INSERT INTO mfo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Tte mọkpẹ-ẹ ọnang anọng mba p'Ishimayẹl. Tte mọning-ẹ ofhu, mgba kẹ ode ọgbaanotte kwaman kwa mofon k'izi rani.” Mẹ wọ, bẹ biphyir akhera odik kwa Juda ọgbaakhi. ");
INSERT INTO mfo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Mada aphyaphyaa mba p'Ishimayẹl p'abira ade anọng pa Midiyan abembi akwọbha, votte pa Josẹph arọbh-ẹ k'ipekhuma sa bẹ akk'ẹ abhari. Bẹ akpẹ-ẹ anang aphyaphyaa mba k'ashẹkẹl p'asilva ẹrọbh, bẹ atzima Josẹph afona k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Mada Reubẹn ọkpa nnam k'ipekhuma nnuma s'ira abẹ abhari Josẹph, ore bi kẹ dọk kode, ọjaakhi ọbara f'ọfọr. ");
INSERT INTO mfo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ofona otza okhebha votte kẹ da bẹ awobh, ọgbaak bẹ bi, “Nnwa nwuma kẹ dọk kode! Ma kaam nna nsi yan ma o?” ");
INSERT INTO mfo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Mẹ wọ, bẹ atzọkha evu dani afhu, bẹ atzọkha ọnọhma kwa Josẹph arana k'izi s'evu cha bẹ afhu. ");
INSERT INTO mfo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Bẹ atzima ọnọhma-baba nwuma abhana atza akhọhkha otte kwabẹ, agbaakh-ẹ bi, “Itta, kkeri ọnọhma-baba kw'am-ore. Kwa nnwa kwọ wọ o?” ");
INSERT INTO mfo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Otte otzin ọnọhma nwa, oben bi, “Ọnọhma kwa nnwa kwaam wọ ma e! Etzen ch'etzam dani ẹkk'ẹfha, k'odik ọkkakka bẹ akk'Josẹph achikhi k'abir-ibiri.” ");
INSERT INTO mfo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Mẹ wọ, Jekọb ọjaakhi ọbara f'ọfọr ka for, ọtzọkha abara-bina ọfọra, on-owobha ka nkwu-osisi sa nnwa kwẹ k'iwu haabhada. ");
INSERT INTO mfo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Va pẹ p'ijinọng ọmaana p'ipanọng biphyir akwu adema ttar-ẹ, ifha bẹ adin-ẹ nttem. Yina, Jekọb kokher bi va ndin-ẹ nttem, on-oben bi, “Mma e, kaam nwobha ka nkwu-osisi sa nnwa kwaam maa, mpe ndor-ẹ.” Mẹ wọ, otte obhom! ");
INSERT INTO mfo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ayongi mẹ, anọng mba pa Midiyan akk'Josẹph akpa k'Ijip anang Pọtipha, kw'ode ọkhaan-nọng wani kwa Phero, obiro ode oho kw'anọng p'am-abaabh-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","K'ogbe nwuma, Juda obina oji votte pẹ, ọtza oruk ọbaanga ojinọng wani kw'okpen Hira, kw'ofon Adulam. ");
INSERT INTO mfo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Kẹnya Adulam wọ kw'iwa Juda okhebh ominanwa wani kw'okpen Shua kw'otte ofon Kenaan. Ọtzọk ominanwa nwa k'ọbada, obiro oyim-ẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ominanwa nwa okwu otzima ibhọr, ọmaan nnwa kw'ijinọng, kwa bẹ akpe Ẹr. ");
INSERT INTO mfo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ominanwa nwa obiro okwu otzima ibhọr, ọmaan ojinọng, ọkka ọkpẹ-ẹ Ọnan. ");
INSERT INTO mfo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","K'ogbe kw'iwa Juda owobh ka Kezib, wa ominanwa nwa obiro okwu otzima ibhọr, ọmaan nnwa kw'ijinọng ọdọdọk, ọkpẹ-ẹ Shẹla. ");
INSERT INTO mfo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Mada va mba abari, otte kwabẹ Juda ọtzọkha kwanọng kw'okpen Tamar ọnang ocheden-nwa kwẹ Ẹr, k'ọbada. ");
INSERT INTO mfo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Yina, Ẹr kw'ode ocheden-nwa kwa Juda osi ẹmmaana-tzama k'itzitzikha s'Ọvaar Ibinọkpaabyi. Mando kw'Ọvaar Ibinọkpaabyi ọtzọkha akpen pẹ, ope. ");
INSERT INTO mfo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Mada Ẹr ọkk'ọpa, Juda oben Ọnan bi, “Kọ akhaambi asi mach'ẹmmaana chaman ede. Rọhng atza ayima ttara kwanọng kw'agbaanakka opfunọng, ifha orenga ma kọ, agbaanakka ọkhaama va.” ");
INSERT INTO mfo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Yina, mada Ọnan orong bi, nnwa kpenamkpen kw'obhon ma ndaak sa kwanọng kw'ọgbaanọkka, kwẹ kode. Ogbe kpenamkpen kw'oyim kwanọng ọgbaanọkka abẹ, ọm-ọja adima ọbhari k'iyaan ifha kwanọng nwa oningi ibhọr otzim, ọmaan va ọnang ọgbaanọkka kw'ọkk'ọpa. ");
INSERT INTO mfo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Wa odik nwa ode odik-ttama k'itzitzikha s'Ọvaar Ibinọkpaabyi. Mẹ wọ, Ọvaar Ibinọkpaabyi ọtzọkha akpen p'Ọnan. ");
INSERT INTO mfo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Mẹ wọ, Juda oben ọnyẹ kwẹ Tamar bi, “Kọ rọhng atza awobha epopa k'atte k'ọhọhm, matzẹmaa nnwa kwaam Shẹla opyiri k'odem kw'ọtzọkh-ọ k'ọbada e.” Wa obeni mando okhuri da ojor-ẹ bi, “Bẹ afha afhu Shẹla ofhu macha bẹ afhu ayok.” Wa Tamar obina ọkpa nnam k'otte k'ọhọhm. ");
INSERT INTO mfo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Okwu otzuma k'ogbe mẹ, kwanọng kwa Juda, kw'ode nnwa kwa Shua okwu ope. K'ogbe kwa Juda okk'ottem-dini k'obo kwa kwanọng ọn-ọkhaama, obina ochina ka Timna, kẹ da bẹ am-aphyiri arukhimaan pẹ ophyubha, oyokh-odikkobh kwẹ Hira kw'ofon Adulam ọtzọn-e abẹ. ");
INSERT INTO mfo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Mada bẹ agbaakhi Tamar bi, “Otte kw'odim kwọ oreng k'eden okwuma k'obhon kwa Timna bi, ọtza ophyiri arukhimaan pẹ ophyubha.” ");
INSERT INTO mfo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamar ọtza ọwọra epopa-nya, ọtzọkha ibara s'ide ọphyọhng-ọphyọhng obubha itzitzikha sẹ, ọtza owobha ẹwọr k'ẹbaakhamma ch'obhon kw'Ẹnayim, kw'owobh k'eden ch'achin k'obhon kwa Timna. Wa Tamar ore bi, Shẹla ọkk'ọn-ọbara k'odem kw'ira ọn-ọtzọkh-ẹ k'ọbada, wa mando kosi. ");
INSERT INTO mfo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Mada Juda ọrẹ-ẹ, ochibhi bi ọzaza-kwanọng wọ, da ọkk'ọphyọhng otzima obubha itzitzikha sẹ. ");
INSERT INTO mfo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Wa Juda korong bi, kwanọng kwa nnwa kwẹ wọ, on-ojekha okhebh-ẹ k'eden okhubha, oben bi, “Kọ kwu, tte nyim-ọ abẹ.” Kwanọng kwa nnwa ọbọbh-ẹ bi, “Kọ ánang-m mbọng idikha kaam nkher bi, nyim-ọ abẹ o?” ");
INSERT INTO mfo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Juda oben bi, “Kaam ńnọbha ovu-nwa k'avu paam ńdọhm ńchen-ọ.” Ọn-ọbọbh-ẹ bi, “Kọ na abhikha ọttọhk kpenamkpen fọ, fa kaam nhok maa, atzima ovu-nwa nwuma akwu o?” ");
INSERT INTO mfo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Mẹ wọ, Juda ọben bi, “Mbọng fa kaam mfha mmikha ma o?” Kwanọng nwa obhin-ẹ bi, “Kọ bhikha ogimma kwọ kw'ẹdọhngi kw'otzim che chọ, ọmaana ochikhura kw'atzim k'ọbọhk.” Mẹ wọ, ọtzọkha ekpo mbya otte ọbọhk ọnang-ẹ. Mada ọkk'ọsa mando, kwanọng nwa okhera oyim-ẹ abẹ, mẹ wọ, Tamar otzima ibhọr sa Juda ọkhẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Mẹ wọ, Tamar ofona ọtza obhona ọbara, obiro ọtzọkha ẹnya chẹ ch'epopa, ọfọra. ");
INSERT INTO mfo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Mada Juda ọn-ọtzọhmi oyokh-odikkobh kwẹ Hira kw'ofon Adulam, ttara ovu-nwa kw'otzima obhek ekpo pyẹ py'obhik ka kwanọng nwa ka mbọhk, ọtza opyiri, kwanọng nwa kokhebh. ");
INSERT INTO mfo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Iwa Hira ọn-ọbọbh ajinọng bani p'obhon nwa bi, “Ọzaza-kwanọng nwa kw'ira owobh m'ọkkadeden ọkhaan-ọkhaan kw'Ẹnayim, ko o?” Bẹ abhin-ẹ bi, “Ọzaza-kwanọng manda wani ma otzim-om-owobha.” ");
INSERT INTO mfo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Mẹ wọ, Hira ofona ọkpa nnam kẹ da Juda owobh, ọgbaakh-ẹ bi, “Kaam kẹ kinne e. Ayongi mẹ, ajinọng p'arukhi abaanga mẹ agbaakh-m bi, ọzaza-kwanọng manda wani m'ibe nnuma otzim-om-owobha.” ");
INSERT INTO mfo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Mẹ wọ, Juda oben bi, “Tte kẹ otzima ekpo mbyuma ọrọhng, oni mando ode, mon-óde ọhamma-dik k'anọng k'itzitzikha e. Kaam arang nna mbiri nsi, mgba nkk'ọ ovu-nwa nnanga bi achen-ẹ, kẹ kare.” ");
INSERT INTO mfo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Okwu opyiri ọttọhk k'aphe attaan, Juda okwu ọbhaanga bi, “Tamar kw'ode kwanọng kwa nnwa kwọ osi azaza-kpen maa, okk'ibhọhr otzima.” Iwa Juda ọn-ọnang ẹfa bi, “Bẹ atzim-ẹ ayin k'iyaan, ifha bẹ akwọm-ẹ ekhekhebhi.” ");
INSERT INTO mfo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Mada bẹ atzim-ẹ ayin k'iyaan bi bẹ akwọmi, Tamar ọtzọhm ẹkkaabha ọnang otte kw'odim, oben bi, “Kaam ndim ibhọr nnang ojinọng kw'ọkhaam ekpo mbya e. Kọ kkeri ogimma nwa kw'ẹdọhngi, ọmaana ochikhura nwa s'ode na afha atzin pyẹ ka more.” ");
INSERT INTO mfo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Mada Juda ore ekpo mbyuma, otzin pyẹ, oben bi, “Kẹ wọ otzor-otzor e, kaam nkk'ntta k'osisi kwaam da nnẹ-ẹ ndọk, nnang nnwa kwaam Shẹla.” Wa Juda Tamar abẹ dọk koyim. ");
INSERT INTO mfo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Mada ogbe on-opyiri kw'ọmaan, wa va afa p'ijinọng bọ awobh-ẹ k'ẹbhọr. ");
INSERT INTO mfo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Mada om-okhonga bi ọmaan, nnwa wani oyin ọbọhk k'iyaan, kwanọng kw'okker-ẹ ọmaan ọtzọkha ididikha ọkpẹ-ẹ k'ọbọhk oben bi, “Oyok nwa wọ ochi eden oyin.” ");
INSERT INTO mfo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mada nnwa nwa on-obiro ọkpa nnam okhe ọbọhk k'ẹtzaanga, ọgbaanọkka on-ochi eden oyin, kwanọng kw'okker-ẹ ọmaan on-oben bi, “Manda wọ kwa kọ an-areng ayin o!” Mẹ wọ, bẹ kpẹ-ẹ Pẹrẹz. ");
INSERT INTO mfo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ayongi mẹ, ọgbaanọkka obiro oyin ttara edik ch'ekhori-ihiho k'ọbọhk, bẹ akpẹ-ẹ Zẹra. ");
INSERT INTO mfo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Mada iwa anọng p'Ishimayẹl akk'Josẹph atzima achina k'Ijip, wa Pọtipha kw'ode ọkhaan-nọng wani kwa Phero, obiro ode oho kw'anọng p'abaabh-ẹ, odebh Josẹph ka mbọhk anọng mba. ");
INSERT INTO mfo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mada Josẹph orukhi k'ọhọhm kw'itta kwẹ kw'ofon Ijip, wa Ọvaar Ibinọkpaabyi owobh ttar-ẹ, obiro osi idik ijibh inang-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Mada itta kwẹ on-ore bi, Ọvaar Ibinọkpaabyi owobh ttara Josẹph, obiro ore bi, Ọvaar Ibinọkpaabyi ọnang-ẹ owujibha k'idik kpenamkpen s'osi, ");
INSERT INTO mfo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","wa Josẹph ọtzọkha ọphyaam k'itzitzikha sẹ, ọn-ọtzọkh-ẹ mach'ọtzọhmnọng kwẹ. Mẹ wọ, Pọtipha ọn-ọtzọkha ọttọhk kpenamkpen f'ọkhaam ọnang-ẹ bi, okkeri. ");
INSERT INTO mfo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ttẹwọr k'ogbe kw'iwa otte ẹhọhmmọr chẹ ọmaana ọttọhk kpenamkpen f'ọkhaam ọbọhk ọnang Josẹph bi okkeri, wa Ọvaar Ibinọkpaabyi oreng Josẹph abẹ odo ẹhọhmmọr ch'Ojipnọng nwa. Wa ẹdaa ch'Ọvaar Ibinọkpaabyi en-ewobh k'ọttọhk kpenamkpen f'ọkhaam k'ọhọhm ttara k'iwoni sẹ. ");
INSERT INTO mfo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Mẹ wọ, odik kw'iwa obiro ọkpakha Pọtipha oyongi ọchattọhk f'ochi kode, da okk'idik biphyir s'ọkhaam ọbọhk ọtta ọnang Josẹph bi, okkeri. Wa Josẹph ojibhi odikkobh obiro ode ọnọng kw'ofhu ka for bi gbuk. ");
INSERT INTO mfo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Okwu opyiri k'ogbe mẹ, kwanọng kw'itta kwẹ om-otzini chen okkeri Josẹph adadaakha-chen, oben-ẹ bi, “Kwu yim-m abẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yina, Josẹph obhum, oben kwanọng nwa bi, “Itta kwaam okk'idik sẹ s'ọkhaam biphyir ọbọhk ọtta ọnang-m bi, nkkeri. Odik manda wani kw'obiro ọkpakh-ẹ dọk kode. ");
INSERT INTO mfo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","M'ọhọhm nwa, ọnọng ọdọdọk kw'ọkhaam ẹfa ọyọhnga kaam kode. Odik manda wani kw'itta kwaam obiro ọram-m, kw'oyongi kọ kw'ade kwanọng kwẹ, kode. Kaam nna nnenga yan nsi itzama, ttara ọkhọngkwuri-dik-dema nwa, mpyibh k'itzitzikha s'Ibinọkpaabyi o?” ");
INSERT INTO mfo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Chibhi da kwanọng nwa ọyakhi Josẹph atzim k'ewu kpenamkpen bi, oyim-ẹ abẹ, Josẹph kokher. ");
INSERT INTO mfo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Wa ewu dani, Josẹph ọtza odim k'ọhọhm bi, otza osi itzọhmbọhk sẹ, k'ogbe kw'ọtzọhmnọng ọdọdọk manda wani oni k'ọhọhm ode. ");
INSERT INTO mfo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Kwanọng nwa ọbọkha Josẹph k'ittọhk-kwuma s'ọpaabh k'erin, ọben bi, “Kwu yim-m abẹ!” Yina, Josẹph otte ittọhk-kwuma sẹ ọbọhk ọnang-ẹ, ọrọbh oyin k'iyaan. ");
INSERT INTO mfo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Mada kwanọng nwa ore bi, ọkk'ọrọbha ọjẹ-ẹ ittọhk-kwuma sẹ ka mbọhk sẹ oyin k'iyaan, ");
INSERT INTO mfo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","on-oyeri atzọhmnọng pẹ p'ọhọhm, oben bẹ bi, “Bọng akk'ara, odim kwaam otzim oHiburu-nọng nwa okwu ma bi, okwu ọnang man che-tzama! Odimi okhebh-m k'ọhọhm bi, okwu oyim-m abẹ, yina, kaam nna mkpẹbhi ẹmọng k'ẹrọng e. ");
INSERT INTO mfo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Mada ọbhaang ẹmọng cha mkpẹbhi nnor ẹkkaana, mẹ kw'ọn-ọrọbhi oji ittọhk-kwuma sẹ ma oyin k'iyaan e.” ");
INSERT INTO mfo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ọn-ọtzọkha ittọhk-kwuma nna ohok maa, itta kwa Josẹph okhuna. ");
INSERT INTO mfo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Mẹ wọ, ọtzọkha odik nwa ọgbaakh-ẹ bi, “Obira nwa kw'ode oHiburu-nọng, kw'atzim achena man ma, odimi okhebh-m k'ọhọhm bi, okwu oyim-m abẹ ọnang-m che-tzama. ");
INSERT INTO mfo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Mada ọn-ọbhaang ẹmọng cha kaam mkpẹbhi nnor ẹkkaana, ọn-ọrọbh oyin k'iyaan oji ittọhk-kwuma sẹ ma ttar-m.” ");
INSERT INTO mfo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Mada itta kwa Josẹph ọbhaang odik kwa kwanọng kwẹ ọgbaakh-ẹ, oben bi, “Manda wọ kw'obira kwọ osi-m e”, ettem ẹdọkh-ẹ k'idendama. ");
INSERT INTO mfo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Mẹ wọ, itta kwa Josẹph, ọbọkha Josẹph ọtzọhm mgbakkọhbh, k'ibe sa bẹ agbakhi agbakkọkkọhbha p'ọvaarnọng. Wa bẹ ahokh-ẹ kẹ. Yina, mada Josẹph owobh ka mgbakkọhbh, ");
INSERT INTO mfo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","wa Ọvaar Ibinọkpaabyi owobh ttara Josẹph, osi ejibha ọnang-ẹ, obiro ọsẹ-ẹ ọtzọkha ọphyaam k'itzitzikha s'oho kw'akker-agbakkọkkọhbha. ");
INSERT INTO mfo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Mẹ wọ, oho nwa kw'akker-agbakkọkkọhbha ọtzọkha Josẹph osi oho kw'agbakkọkkọhbha biphyir, obiro ọnang-ẹ ẹfa ch'odik kpenamkpen k'ọgbakkọbh-họhm. ");
INSERT INTO mfo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Wa oho kw'akker-agbakkọkkọhbha ọn-ọrọbha mbọhk sẹ k'odik kpenamkpen kw'oyim ọnang Josẹph bi okkeri, okhuri da Ọvaar Ibinọkpaabyi owobh ttara Josẹph, obiro ọnang-ẹ owujibha k'odik kpenamkpen kw'osi. ");
INSERT INTO mfo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","K'ogbe wani, wa ọnọng kw'ọm-ọnang ọvaarnọng kw'Ijip atzuk, ọmaana ọnọng kw'om-osi ọchattọhk fẹ, akhaam ottotto ttara itta kwabẹ, kw'ode Phero, ọvaarnọng kw'Ijip. ");
INSERT INTO mfo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Wa Phero ọdọkh-ẹ ttara atzọhmnọng mba pẹ afa, p'ade oho kw'anọng p'am-anang ọvaarnọng atzuk, ọmaana oho kw'anọng p'am-asi ọchattọhk anang ọvaarnọng. ");
INSERT INTO mfo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Wa ọtzọkha bẹ ọgbak k'ọhọhm kw'oho kw'akker-agbakkọkkọhbha, k'ọgbakkọhbh-họhm nwuma wani kwa bẹ agbakhi Josẹph. ");
INSERT INTO mfo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Mando kw'oho kw'akker-agbakkọkkọhbha ọtzọk bẹ otte ọbọhk anang Josẹph, Josẹph okkeri bẹ. Mada anọng mba afa akk'mgbakkọhbh ayima k'ogbe mẹ, ");
INSERT INTO mfo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","k'erungiwu dani, ajinọng mba afa, oyok kw'om-okhe atzuk ọnang ọvaarnọng kw'Ijip, ọmaana oyok kw'om-osi ọchattọhk, pa bẹ agbakhi k'ọgbakkọhbh-họhm, ọnọng-ọnọng ọttaara idachen sẹ s'ikhaam ẹjaakhi ch'ede ngọmi ka s'oyok ọttaar. ");
INSERT INTO mfo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Mada Josẹph okwu k'ekpebha, on-ore bi, bẹ awobh nkwu-osisi. ");
INSERT INTO mfo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Mẹ wọ, ọn-ọbọbh akhaan-nọng pa Phero pa bẹ atzọni ayima mgbakkọhbh, k'ọhọhm kw'itta kwẹ bi, “Ode yan kwa nttem ibhemi bọng mando mayina o?” ");
INSERT INTO mfo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Bẹ abhin-ẹ bi, “Man anọng afa ọttaar ọdachen. Yina, ọnọng kw'osi ẹjaakhi ch'ọdachen mva ọnang man kode.” Josẹph on-oben bẹ bi, “Tzotzokhaan bọng gbaakh-m ọdachen fabọng, Ibinọkpaabyi wọ ọm-ọnang ẹjaakhi ch'ọdachen biphyir e.” ");
INSERT INTO mfo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Mẹ wọ, oho kw'anọng p'am-anang ọvaarnọng atzuk, ọgbaak Josẹph idachen sẹ, oben-ẹ bi, “Kaam nttaar idachen da echi cha grep ebe-m k'itzitzikha. ");
INSERT INTO mfo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Echi nda cha grep ẹkhaam abọhnga attaan. Mada abọhnga mba ayini agbok bi kpaar, bẹ attẹwọr asi adodo, an-awọm aduk p'agrep bẹ abira akhor. ");
INSERT INTO mfo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","K'ọbọhk kwaam, ndima nkkọbh kw'ọvaar Phero, kwa myaan aduk mba p'agrep ngẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Mẹ wọ, Josẹph ọgbaakh-ẹ bi, “Ẹjaakhi ch'idachen sọ ede bi, abọhnga mba attaan, abe anang iwu ittaan. ");
INSERT INTO mfo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","K'iwu ittaan k'itzitzikha, Phero ọ́rọbh-ọrọbha ka mgbakkọhbh, obiro ọkpa nnam ọ́nang-ọ ewobha chọ. Kọ ábira ákhẹ-ẹ nkkọbh ka mbọhk, mach'iwa am-akkekkeni asi. ");
INSERT INTO mfo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Yina, mada idik ijibh inang-ọ, k'ọphyaam fọ, tzotzokhaan kaam karaama o. Gbaak Phero bi, kaam nwobh ka o, ifha akkaan-m nyin ma mgbakkọhbh nna. ");
INSERT INTO mfo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kaam iwa bẹ abọkh-m k'ẹfa k'irek s'aHiburu atzima akwu ma. Kaambi ma wọ, kaam odik manda wani kinji kw'ira on-orenga mẹ nyima mgbakkọhbh nna.” ");
INSERT INTO mfo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Mẹ wọ, mada oho kw'anọng p'am-asi ọchattọhk f'ọvaarnọng ore bi, ẹjaakhi ch'idachen s'oyok ekk'ejibha ẹnang-ẹ, on-oben Josẹph bi, “Kaam mbiri nttaara idachen e. K'idachen, ndọhk okhiriba ọttaan fa brẹd k'eho. ");
INSERT INTO mfo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","K'ikhiriba s'inan k'ebir-ebir kw'ayok, ẹchakpo k'adem-k'adem pya Phero om-ochi pya bẹ akk'asa ewobha kẹ. Yina, ọnọhn f'ẹrọng om-okwu ochi ẹchakpo mbya pya ndọhk k'eho.” ");
INSERT INTO mfo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Josẹph oben bi, “Ẹjaakhi ede bi, okhiriba mva ọttaan, obe ọnang iwu ittaan. ");
INSERT INTO mfo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","K'iwu ittaan k'itzitzikha, Phero ọ́rọbh-ọrọbha ka mgbakkọhbh, obiro ọ́nang ẹfa bi, bẹ akpaar-ọ eho, bẹ abira ádabh obukhi kwọ k'echi, ọnọhn mach'attẹrẹ áchi ayaara pọ biphyir.” ");
INSERT INTO mfo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","M'ewu nduma ch'ettong ittaan, Phero obher atzọhmnọng pẹ biphyir, osi ọdadaami kw'otzim ojima ewu ch'ọmaan. Ọnang ẹfa bẹ atza arọbha oho kw'anọng p'am-anang ọvaarnọng atzuk, ọmaana oho kw'anọng p'am-asi ọchattọhk anang ọvaarnọng, obe bẹ k'ottem kw'ayok: ");
INSERT INTO mfo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ọkpa nnam ọnang oho kw'anọng p'am-anang-ẹ atzuk ewobha chẹ maa, om-obiro okhe Phero atzuk ka mbọhk, mach'iwa om-okkekkeni osi. ");
INSERT INTO mfo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Yina, ọn-ọnang ẹfa bi, bẹ akpaara eho ch'oho kw'anọng p'am-asi ọchattọhk anang ọvaarnọng, bẹ abira adabh obukhi kwẹ k'echi atzor macha Josẹph ọkk'ẹjaakhi ọtzam ọsa. ");
INSERT INTO mfo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Yina, oho kw'anọng p'am-anang ọvaarnọng atzuk, ọn-ọraama bi ọgbaak ọvaarnọng odik okhuri Josẹph kw'iwa otzim owobh ka mgbakkọhbh. ");
INSERT INTO mfo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Mada cho afa akk'akwọbha, Phero ọttaara idachen: k'idachen ọttaar da obe k'ọraanga kwa Nile ọkhaan-ọkhaan, ");
INSERT INTO mfo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ore da abhaam azenamfa p'ajibhi for, abira ade bi dọrọdọrọ ayini k'ọraanga kwa Nile akwu achi araraari p'ameni m'ọraanga ọkhaan-ọkhaan. ");
INSERT INTO mfo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ayongi mẹ, abhaam azenamfa adọdọk p'akkokh-okkokhi abira apyibh ka for, ayin abaanga mbonggo p'ajibhi for p'awobh m'ọraanga kwa Nile ọkhaan-ọkhaan. ");
INSERT INTO mfo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Abhaam mba p'akkokh-okkokhi abira apyibh ka for achi p'ajibhi ka for. Wa Phero ọphyọbha k'ọda. ");
INSERT INTO mfo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Iwa Phero obiro ọtza oyima, ọn-ọttaara idachen idọdọk. Ore ẹbọkparin dani ch'etzim abhọra azenamfa p'abari ẹfa, abira ajibh-ojibh. ");
INSERT INTO mfo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ayongi mba, abọkpa-bhọra azenamfa adọdọk p'akkokh-okkokhi, p'ọphapha kw'ofon k'okhubha kw'ewuchen em-eyin ogwum, abira ayin. ");
INSERT INTO mfo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Mẹ wọ, abọkpa-bhọra mba azenamfa p'akkokh-okkokhi amyi azenamfa p'ajibhi for biphyir. Mada Phero ọkk'ọda ọphyọbha, mẹ kw'on-orong bi, idachen s'ọttaar. ");
INSERT INTO mfo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Mada ewu en-ehobh, achibhi ayak Phero atzim, ofona mẹ, ọtzọhm anọng bi, bẹ ayeri anọng p'am-asi mbọhng biphyir, ọmaana atzim-nọnga-nọng kpenamkpen makhọra Ijip. Mada bẹ akwu apyiri, ọgbaak bẹ ọdachen f'ọttaar. Yina, ọnọng manda wani kw'ofha osi ẹjaakhi ch'ọdachen fa Phero kode. ");
INSERT INTO mfo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Mẹ wọ, oho kw'anọng p'am-anang Phero atzuk, oben bi, “Mayina kaam nkk'ottotto kwaam njima. ");
INSERT INTO mfo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Wa ọkhaam ogbe kwa Phero ọdọkhi ettem ttara atzọhmnọng pẹ, wa ọtzọhm kaam, ọmaana oho kw'anọng p'am-asi ọchattọhk mgbakkọhbh, k'ọhọhm kw'oho kw'akker-agbakkọkkọhbha. ");
INSERT INTO mfo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Wa k'erungiwu dani, man anọng afa mọttaar ọdachen ngọmi-ngọmi, idachen kpenamkpen ikhaama ẹjaakhi chẹ. ");
INSERT INTO mfo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Wa mọtzọkha ọdachen mva ọgbaak oHiburu-dikkobh wani kw'ode ọtzọhmnọng kw'oho kw'akker-agbakkọkkọhbha. Wa mọgbaakh-ẹ ọdachen faman, kẹ obiro osi ẹjaakhi ch'ọdachen mva ọnang man. ");
INSERT INTO mfo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Wa idik nnuma iyini itzor mach'osi ẹjaakhi. Kaam wa bẹ ọkpa nnam ọnang-m ewobha chaam, yina, wa bẹ arena oyok k'edik.” ");
INSERT INTO mfo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Iwa Phero ọtzọhm anọng bi, bẹ atzima Josẹph akwu. Mẹ ẹba mẹ, bẹ atza arọbh-ẹ k'ọgbakkọhbh-họhm atzima akwu. Mada Josẹph okk'agbaphyubha pẹ ophyiri, obiro obhona ọbara f'ọfọr ka for, ofona ọtza okhebha Phero. ");
INSERT INTO mfo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Phero oben Josẹph bi, “Kaam nttaar idachen, s'ọnọng manda wani oni ẹjaakhi ọfha ọnang. Yina, kaam nkk'mmaanga bi, kọ am-asi ẹjaakhi ch'ọdachen anang anọng.” ");
INSERT INTO mfo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Josẹph obhina Phero bi, “Kaam ẹfa kingaam bi, mminsi ẹjaakhi ch'ọdachen nnang anọng e. Yina, Ibinọkpaabyi wọ ọ́nang ebhina ẹkkakka e.” ");
INSERT INTO mfo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Phero ọgbaak Josẹph bi, “Kaam nttaar idachen da mbe k'ọraanga kwa Nile ọkhaan-ọkhaan. ");
INSERT INTO mfo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Nne da abhaam azenamfa p'ajibhi for ayini k'ọraanga kwa Nile, akwu achi araraari m'ọraanga ọkhaan-ọkhaan. ");
INSERT INTO mfo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ogbe k'obhiri, abhaam azenamfa adọdọk p'akkokh-okkokhi abira aphyibh ka for, ayin m'ọraanga. Kaam mada ogbe odede e, abhaam p'akkokhi ka for mando ndimi mminna m'irek nna s'Ijip. ");
INSERT INTO mfo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Abhaam mba p'akkokh-okkokhi, abira aphyibh ka for an-achi p'ajibhi ka for p'ira achi eden ayin. ");
INSERT INTO mfo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Chibhi da bẹ akk'ayok acha biphyir, bẹ atzima akkeri ka for macha bẹ adede. Mando kwa mgbe mphyọbha k'ọda. ");
INSERT INTO mfo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“K'idachen ọdọdọk, kaam nne da abọkpa-bhọra azenamfa p'ajibhi for ameni k'erin dani. ");
INSERT INTO mfo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ayongi mbuma, abọkpa-bhọra azenamfa adọdọk p'akkokh-okkokhi abira amen k'ebọkparin dani, ọphapha kw'iyoma kw'ofon kẹ da ewuchen em-eyin ogwuma bẹ. ");
INSERT INTO mfo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Mẹ wọ, abọkpa-bhọra mba azenamfa p'akkokh-okkokhi amyi azenamfa p'ajibhi for biphyir. Kaam ndọkha idik nna biphyir mgbaak anọng p'am-asi mbọhng biphyir, yina, ọnọng kw'ọfha osi ẹjaakhi ọnang-m kode.” ");
INSERT INTO mfo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Mẹ wọ, Josẹph ọgbaak Phero bi, “Ọdachen mva ode odem wani, fẹ obiro ọkhaama ẹjaakhi dani. Ibinọkpaabyi ọkk'ẹjaakhi ọsa ọnang Phero k'odik kw'ọkhami bi osi. ");
INSERT INTO mfo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ọdachen mva ọkhaam ẹjaakhi dani, ch'ede bi: Abhaam mbuma azenamfa p'ajibhi for, abe anang cho azenamfa. Abọkpa-bhọra mbuma azenamfa p'ajibhi for, abira abe anang cho azenamfa. ");
INSERT INTO mfo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Abhaam mbuma azenamfa p'akkokh-okkokhi p'akpong-nnam ayin, ọmaana abọkpa-bhọra mbuma azenamfa p'ani for ajibhi, p'ọphapha kw'ofon k'okhubha kw'ewuchen em-eyin, abe anang cho azenamfa p'okwo f'ideden. ");
INSERT INTO mfo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Itta, ode macha mgbaakh-ọ bi, Ibinọkpaabyi ọkk'ẹjaakhi ọsa ọnang Phero k'odik kw'ọkhami bi, osi. ");
INSERT INTO mfo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ka cho azenamfa k'itzitzikha, irek s'Ijip ikhaama ọchattọhk k'ọhaabh. ");
INSERT INTO mfo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Yina, cho azenamfa p'okwo f'ideden án-atzor cho p'ọhaabh nnam. Mẹ wọ, anọng áraama ọhaabh f'Ijip ọraama, okwo f'ideden obiro ọ́nyaami ochi irek nna. ");
INSERT INTO mfo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","“Anọng ogbe kw'ọhaabh f'irek nna dọk ájima, okhuri da okwo mva f'ideden ọ́n-ọgaangi oyong-oyongi. ");
INSERT INTO mfo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Wa Phero ọttaar idachen nna rani k'adem afa, okhuri da iwa Ibinọkpaabyi okk'ochibhi ọtzam ọsa. Ogbe kobhir, Ibinọkpaabyi osi kwẹ osi. ");
INSERT INTO mfo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Mẹ wọ, tte Phero oror ojinọng wani kw'ọkhaam etzina, ọmaana ekkoji, ifha ọnang ojinọng nwa ẹfa ch'otzima okkeri irek s'Ijip. ");
INSERT INTO mfo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Tte Phero otzekha atzọhmnọng p'akkeri irek nna bi, bẹ atzọkha ọchattọhk k'Ijip, okhung wani k'akhung azen ahok, ka cho azenamfa mba p'ọhaabh. ");
INSERT INTO mfo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Tte ofona k'ẹfa cha Phero bi, ka cho azenamfa mba p'ọhaabh p'akwu, anọng mba atzọkha ọchattọhk ahok k'idedenmon. ");
INSERT INTO mfo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Bẹ aye ọchattọhk mva anang anọng p'ẹkhọma nda, ifha bẹ atzima fẹ ka cho azenamfa mba p'okwo f'ideden okwu k'Ijip, ifha okwo mva f'ideden oningi ẹkhọma nda odimi.” ");
INSERT INTO mfo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Iwa Phero ọmaana akhaan-nọng pẹ biphyir are bi, kwẹ okk'ojibha. ");
INSERT INTO mfo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Mẹ wọ, Phero ọbọbh atzọhmnọng pẹ bi, “Na mofha ore ọnọng kw'ode mach'ojinọng nwa, kw'ọkhaam ekkoji ch'efon k'Ibinọkpaabyi o?” ");
INSERT INTO mfo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Mẹ wọ, Phero oben Josẹph bi, “Mada Ibinọkpaabyi ọkk'ọ ẹjaakhi ch'idik nna biphyir ọnanga, ọnọng ọdọdọk kw'ọkhaam etzina ọmaana ekkoji cha kọ akhaam kode. ");
INSERT INTO mfo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Kọ án-ade oho k'ọvaar-dimpa kwaam, anọng paam biphyir an-ahakha eho anang ndọhna sọ. Orenga k'ikpokpobha s'ẹvaar sẹ-sẹ s'akhaam ńna ndima mbar nyọhng-ọ.” ");
INSERT INTO mfo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Iwa Phero oben Josẹph bi, “Kaam nkk'ọ ọbọhk k'eho nnana bi, adabh irek s'Ijip makhọra.” ");
INSERT INTO mfo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Mando kwa Phero ọwọr ẹbaanga chẹ ch'ẹnọhna, okhe Josẹph. Ọtzọkha ẹnya cha bẹ atzim ndik-nyokhasẹ ọkkakka asi, ọfọr-ẹ, yina ọn-ọtzọk ogimma kwa gol ọkhẹ-ẹ k'ẹdọhngi. ");
INSERT INTO mfo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ọtzọkh-ẹ ọnana k'ọkpaar kwa nnyanyaang mmindọr, bẹ ayaar-ẹ mach'ojukwa kwẹ, anọng arenga k'itzitzikha am-awuri amọng aben bi, “Bọng kebh-ẹ eden!” Mẹ wọ, Phero ọnang Josẹph ẹfa ch'ọdabh irek s'Ijip biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Phero obiro oben Josẹph bi, “Kaam Phero wọ nde ọvaarnọng, yina, ẹfa eni ka kọ efon, ọnọng kw'ọ́khaama ẹfa ch'oyebh ọbọhk kwẹ obiro ode obho kwẹ o, makhọra irek s'Ijip kode.” ");
INSERT INTO mfo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Phero on-okpe Josẹph, Zaphenat-Panea. Obiro ọtzọkha ominanwa kw'okpen Asenat kw'ode nnwa kwa Potiphera, ọnang-ẹ k'ọbada. Wa Potiphera ode ọfọhnẹja kwa On. Wa Josẹph orenga ọkhọri irek s'Ijip bi waam. ");
INSERT INTO mfo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Mando kwa Josẹph obin k'itzitzikha sa Phero, orenga ọkpaanga irek s'Ijip biphyir. Wa Josẹph ode ojinọng kw'ode cho ẹrọbh obhiri jobh, k'ogbe kw'ọttẹwọr osi ọtzọhm ọmaana Phero, kw'ode ọvaarnọng kw'Ijip. ");
INSERT INTO mfo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ma cho mba azenamfa p'ọhaabh, wa irerek ihak for ijibh ekpo. ");
INSERT INTO mfo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Josẹph ọtzọkha ọchattọhk k'Ijip biphyir, ma cho mba azenamfa p'ọhaabh, ohok k'ideden-mon. K'odedenmon kpenamkpen, wa ohokhi ọchattọhk-dem fa bẹ ayaabh m'obhon nwuma. ");
INSERT INTO mfo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Mando kwa Josẹph oye ẹchakpo mach'abọkpa k'ọhaabh mach'oyeyeng kw'ọraanga kw'ideden. Wa ọchattọhk mva ọhaabhi maa, ọkwọbha obhik ohohok, da bẹ ani dọk afha abhik. ");
INSERT INTO mfo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Yina ogbe kw'okwo mva f'ideden opyiri, wa Asenat kw'ode ominanwa kwa Potiphera kw'ode ọfọhnẹja kwa On, okk'va afa p'ijinọng ọmaana ọnang Josẹph. ");
INSERT INTO mfo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Josẹph okpe ocheden-nwa kwẹ, Manasẹ, oben bi, “Ofon da Ibinọkpaabyi ọkk'ọsa bi, kaam nnaama ihem saam biphyir, ọmaana efonamma ch'otte kwaam biphyir.” ");
INSERT INTO mfo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Okpe nnwa kw'ottong afa Ephraim, oben bi, “Ofon da Ibinọkpaabyi ọkk'aam ọsa bi, ngaama va m'irek nna s'ihem saam.” ");
INSERT INTO mfo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Mada cho azenamfa mba p'ọhaabh k'irek s'Ijip akk'akwa akwọbha, ");
INSERT INTO mfo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","cho mbonggo azenamfa p'okwo f'ideden attẹwọr, mach'iwa Josẹph ọkk'ẹjaakhi ọtzam ọsa. Wa okwo f'ideden owobh makhọra idibhon biphyir. Yina, wa ọchattọhk owobh k'ọhaabh makhọra Ijip. ");
INSERT INTO mfo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","K'ogbe kw'okwo ọn-ọttẹwọr ọkhaama anọng p'Ijip, bẹ atza abhom amọng p'ọchattọhk akpẹkhi Phero. Ofona mẹ, Phero oben anọng p'Ijip biphyir bi, “Bọng nọhng ka Josẹph, bọng asi odik kpenamkpen kw'oben bi, bọng asi.” ");
INSERT INTO mfo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","K'ogbe kw'okwo mva f'ideden ọkk'ọn-ọnyaami k'ẹkhọma nda biphyir, Josẹph okwunga ihọhm s'iwa bẹ aye ọchattọhk, okpe ọchattọhk anang anọng p'Ijip, okhuri bi, wa okwo f'ideden owobh k'Ijip makhọra. ");
INSERT INTO mfo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Wa anọng abina k'idibhon biphyir atza adebh ọchattọhk ka mbọhk sa Josẹph k'Ijip, okhuri bi, wa okwo f'ideden ọgaang-ọgaangi makhọra. ");
INSERT INTO mfo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Mada Jekọb ọbhaang bi, ọchattọhk owobh k'Ijip, ọbọbh va pẹ p'ijinọng bi, “Ode yan kwa bọng atzima am-abe akkeri ayok k'ikkokkon o?” ");
INSERT INTO mfo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","On-ochina ororo oben bẹ bi, “Kaam nkk'mmaanga bi, ọchattọhk owobh k'ẹkhọma ch'Ijip. Bọng hakha atza adebh ọchattọhk atzima akwu mochi, ifha moning ope k'okwo.” ");
INSERT INTO mfo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Mẹ wọ, votte pa Josẹph anọng-ho jobh abina achina k'Ijip bi, bẹ atza adebh ọchattọhk. ");
INSERT INTO mfo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yina, wa Jekọb Bẹnjamin kw'ode ọgbaanọkka kwa Josẹph ọbọhk kotte bi, ọtzọn abọgbaanotte abẹ, okhuri da ojor-ẹ bi, itzama ifha itto ikhebh-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Mẹ wọ, wa va pa Jekọb attar k'ẹkhaan ch'anọng p'achin k'Ijip bi, bẹ atza adebh ọchattọhk, okhuri da iwa okwo f'ideden obiro owobha k'ẹkhọma cha Kenaan. ");
INSERT INTO mfo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","M'ogbe nwuma, wa Josẹph on-otzim ededen k'Ijip, obiro ode ọnọng kw'om-okpe ọchattọhk ọnang anọng biphyir. Mẹ wọ, mada votte pa Josẹph apyiri k'Ijip, bẹ arakha attima otzitzikha fabẹ k'irerek k'ikpokpobha. ");
INSERT INTO mfo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Mada Josẹph ore votte pẹ bi kpaar otzin bẹ. Yina, wa osi nkkari bi bẹ kotzini, on-otzima ọwọhng kw'ọgaang-ọgaangi ọgbaak bẹ atzim, ọbọbh bẹ bi, “Bọng afon man akwu ma?” Bẹ abhina bi, “Mofon k'ẹkhọma cha Kenaan okwu bi, mokwu odebh ọchattọhk e.” ");
INSERT INTO mfo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Kaambi ode bi wa Josẹph okk'votte pẹ otzina, wa bẹ kẹ katzini. ");
INSERT INTO mfo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Mẹ wọ, Josẹph ojima ọdachen f'iwa ọkk'ọttaara okhuri bẹ, on-oben bẹ bi, “Bọng ade nttọ, bọng akk'akwa bi, akwu arom obhon kwaman, ifha bọng aronga irinikhum s'irerek saman.” ");
INSERT INTO mfo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Bẹ abhina bi, “Mma e, itta kwaman, kwẹ mando kode. Atzọhmnọng pọ akwu bi, akwu adebh ọchattọhk. ");
INSERT INTO mfo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Man biphyir mode ajinọng p'afon k'otte wani. Atzọhmnọng pọ agbaakhi odik-ọkka e, man nttọ kode e.” ");
INSERT INTO mfo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Josẹph oben bẹ bi, “Ibhora! Bọng akwu bi, akwu aronga irinikhum s'irerek saman.” ");
INSERT INTO mfo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Bẹ an-abhina bi, “Itta, iwa maman atzọhmnọng pọ mode anọng jobh obhiri afa, p'otte wani kw'orukhi ka Kenaan obhoni e. Okpong-nnam kwaman owobh kẹ ttara otte kwaman e, yina, oyok wani k'ottem kwa man anọng jobh obhiri afa, k'akpen dọk kode.” ");
INSERT INTO mfo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Josẹph ochina ororo oben bẹ bi, “Odik nwa ode macha mgbaakhi bọng bi, bọng ade nttọ! ");
INSERT INTO mfo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ifha ode mẹ moronga odik-ọkka, eyoma chabọng éde bi, bọng atza atzima okpong-nnam kwabọng atzima akwu. Kaam nwọhngi ttara akpen pa Phero bi, kw'oyongi bi bọng asi mando, bọng kábhana e. ");
INSERT INTO mfo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Bọng dọhm ọnọng wani k'ottem kwabọng ọkpa nnam, ọtza otzima okpong-nnam nwuma kwabọng okwu, ayok mbangga awobha ka mgbakkọhbh maa bẹ akhuna akhebha bọng ma, ifha moyoma bọng ore sa bọng am-agbaak odik-ọkkakka. Idikha oni mando ode, nwọhngi ttara akpen pa Phero bi, bọng ade nttọ!” ");
INSERT INTO mfo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Mando kw'ọtzọk bẹ biphyir ọgbak k'iwu ittaan. ");
INSERT INTO mfo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ottong iwu ittaan nnuma, Josẹph oben bẹ bi, “Kaam ngaam ojora f'Ibinọkpaabyi e. Bọng si macha mgbaakhi, ifha bọng aruk akpen. ");
INSERT INTO mfo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Idikha bọng ade anọng p'am-agbaak odik-ọkka, bọng tte ọnọng wani k'ottem kwabọng owobha mgbakkọhbh ma, ifha ayok atzọkha ọchattọhk fa bọng akk'adebha, achena anọng pabọng ka nhọhmmọr, p'ayim okwo kẹ. ");
INSERT INTO mfo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Yina nkhera bi, bọng ibhora kasi, ifha bọng aning abira ape, bọng akhaambi atza atzima okpong-nnam kwabọng achen-m.” Wa bẹ akhera asi mach'obeni bẹ. ");
INSERT INTO mfo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Bẹ an-abhakhi aben ayok bi, “K'odik ọkkọkka, oponga-pyibha nwa kw'am-ọtzọk ma, ofon k'itzama s'iwa mosi ọnang ọgbaanọtte kwaman e. Mojim odem kw'iwa odik nwuma ọmmẹ-ẹ kẹ, ọmaana odem kw'iwa om-okhukhi man bi, mọkkaan-ẹ. Yina, wa ọnọng kw'oyong-ẹ itzọhng kode, kẹ wọ osi mokk'ọmmamma ọtzọkha.” ");
INSERT INTO mfo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reubẹn obhina bẹ bi, “Wa bọng itzọhng kindọri bi, bọng aningi nnwa nwa itzama asi? Yina, ọnọng kw'iwa oyong-m itzọhng kode. Bọng na tzọkha mẹ ttaakhi khi, mọkhaambi da more ọmmamma k'eho cha nnwa nwa.” ");
INSERT INTO mfo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Mada bẹ am-agbaak idik nna mẹ biphyir, bẹ karong bi Josẹph ọm-ọbhaang bẹ, okhuri da iwa om-otzima ọbhakh-ebhon ọgbaak bẹ atzim. ");
INSERT INTO mfo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Wa Josẹph on-obina oji bẹ mẹ da bẹ awobh, ọtza obhom ẹmọng, yina ọn-ọkpa nnam okhebha bẹ k'ibe sa bẹ awobh, obiro ọgbaak bẹ atzim. Ọbọkha Simeọn m'ottem kw'ayok ọdabh ndik m'itzitzikha sabẹ. ");
INSERT INTO mfo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Mẹ wọ, Josẹph ọnang anọng pẹ ẹfa bi, bẹ atza akhe anọng mba abọkpa ka mkpa sabẹ atzim akwu, bẹ abira akpa nnam arik agbukha p'ọnọng-ọnọng otzim odebh abọkpa k'ẹkpa chẹ, bẹ abira attara ọchattọhk f'anọng mba achi k'eden. Mada bẹ akk'mando asa, ");
INSERT INTO mfo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","anọng mba atzọkha ọchattọhk fa bẹ akk'bẹ ananga adabh ka nnyanyaang sabẹ abhana. ");
INSERT INTO mfo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Mada abẹ apyiri k'ibe sa bẹ abhingi da erungi epyi, oyok wani ọchaari ẹkpa chẹ ifha ọnang ẹnyanyaang chẹ ọchattọhk, on-ore asilva pẹ k'ẹkpa chẹ ẹtzaanga. ");
INSERT INTO mfo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ọgbaak ayok bi, “Bẹ akk'asilva paam arikha e, kkeri bẹ k'ẹkpa chaam e.” Mada bẹ abhaang odik kw'oyok ọgbaakhi bẹ, nttem iyọhn bẹ, ojora osi bẹ, bẹ afọhni abọbh ayok bi, “Ma bọng odik wọ kw'Ibinọkpaabyi osi man ma o?” ");
INSERT INTO mfo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Mada abẹ akwu apyiri k'ẹkhọma cha Kenaan, bẹ agbaak otte kwabẹ Jekọb, odik kpenamkpen kw'ọkk'ọtta okhebha bẹ k'orenga kwa bẹ atza, aben bi, ");
INSERT INTO mfo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ojinọng kw'ọdabhi obhon nwuma ọkkaam-ọkkaam, obiro ọtzọkha man macha nttọ, sa nkwu bi, nkwu nnom irek nnuma. ");
INSERT INTO mfo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Yina, mọgbaakh-ẹ bi, ‘Mode anọng ọkkọkka, man nttọ kode. ");
INSERT INTO mfo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Wa mode votte jobh obhiri afa e, va p'otte wani obhoni. Yina, oyok wani k'ottem kwa man anọng-ho jobh obhiri afa, k'akpen dọk kode. Okpong-nnam kwaman wọ on-owobh k'ẹkhọma cha Kenaan ttara otte kwaman.’ ");
INSERT INTO mfo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Mẹ wọ, ojinọng kw'otzim ededen ch'irek nnuma, oben man bi, ‘Odem kwa kẹ otzima oronga sa mode anọng ọkkọkka ode bi, bọng tte ọnọng wani ọbọhk k'ottem kwabọng, owobha ma ttar-m, ifha ayok mbangga atzọkha ọchattọhk achena anọng pa nhọhmmọr sabẹ, s'iwobh k'okwo f'ideden. ");
INSERT INTO mfo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Kw'oyongi bi motzim okpong-nnam kwaman ochen-ẹ, kẹ kókhera bi, man nttọ kode, kóbiro okhera bi, mode anọng ọkkọkka. Amokk'mando ọsa, kẹ ótte ọgbaanọtte kwaman ọbọhk otte ọnang man, ifha mobiro ofha órenga mphya m'irek nnuma.’ ” ");
INSERT INTO mfo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Mada abẹ an-awọhn ekpo py'ewobh ka mkpa sa bẹ atzim akhuna, ọnọng-ọnọng on-ore ikwa sẹ sa silva s'ira otzim odebh abọkpa k'ẹkpa chẹ ẹtzaanga. Mada bẹ biphyir ọmaana otte kwabẹ an-abira are ọkwa fa silva fa bẹ arọbh ka mkpa sabẹ, ojora osi bẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Mẹ wọ, otte kwabẹ Jekọb oben bẹ bi, “Bọng akk'aam va paam arama. Josẹph ọmaana Simeọn k'akpen dọk kade, ma, bọng an-abira akwu bi akwu atzọkha Bẹnjamin atzima afona. Idik nna biphyir itto ikhebha kaam mancheni!” ");
INSERT INTO mfo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Mẹ wọ e, Reubẹn oben otte bi, “Tte Bẹnjamin ọbọhk anang-m, kaam ndima va paam afa, ndera eho chẹ, idikha kaam nnẹ-ẹ ndim ngwuna nchen-ọ. Ọttọhk kpenamkpen f'ọdaakh-ọ bi asi va paam, si bẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yina, Jekọb obhina bi, “Kaam nnwa kwaam, ọbọhk kintte nnang bọng, okhuri bi, ọgbaanọkka kwẹ ọkk'ọpa, on-orik kẹ-khẹ. Idikha itzama kpenamkpen itto ikhebh-ẹ k'orenga kwa bọng átza, mẹ wọ ode bi, bọng ánọhng-m m'atzam mba ka nkwu-osisi.” ");
INSERT INTO mfo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Wa okwo f'ideden otzim owobh k'ẹkhọma cha Kenaan. ");
INSERT INTO mfo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Mada Jekọb ọmaana ẹhọhmmọr chẹ akk'abọkpa p'iwa bẹ adebhi k'Ijip acha biphyir akyera, otte oben bẹ bi, “Bọng kpa nnam k'Ijip atza adebh ichattọhk-ttọhkha atzima akwu.” ");
INSERT INTO mfo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yina, wa Juda oben otte bi, “Ojinọng nwuma kw'ọdabhi Ijip, ọtzọri man itzọhng k'eden ọkkakka bi, ‘Bọng kaam k'itzitzikha kàbe, kw'oyongi bi, bọng atzim ọgbaanọtte nwuma kwabọng akwu.’ ");
INSERT INTO mfo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Idikha akher bi, ọgbaanọtte kwaman ọtzọn man abẹ, mọhakha-ọhakha otza odebh ọchattọhk ochen-ọ. ");
INSERT INTO mfo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Yina, idikha annẹ-ẹ ọbọhk atte bi ọtzọn man abẹ, man kọtza, okhuri bi, ojinọng nwuma obeni man bi, ‘Bọng kaam k'itzitzikha kàbe, kw'oyongi bi, bọng atzim ọgbaanọtte nwuma kwabọng akwu.’ ” ");
INSERT INTO mfo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Iwa Jekọb kw'obiro okpena Israẹl, ọbọbh bi, “Ka yan kwa bọng anang-m ọmmamma-dem nwa k'ettem, bi, bọng agbaak ojinọng nwuma bi, bọng akhaam ọgbaanotte ọdọdọk ka o?” ");
INSERT INTO mfo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Bẹ abhina bi, “Ojinọng nwuma ọbọbhi man idik haabhada s'ikhuri for saman ttara ẹhọhmmọr chaman bi, otte kwabọng otzim orukhi akpen kẹ o? Bọng akhaam ọgbaanotte ọdọdọk kẹ? Odik obungikwẹ kw'am-osi ode bi, mọgbaakh-ẹ idik s'ọbọbhi man biphyir. Yan wọ kw'ira motzima oronga bi, kẹ oben man motzima ọgbaanotte kwaman okwu o?” ");
INSERT INTO mfo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Mẹ wọ, Juda on-oben Israẹl bi, “Tte nnwa nwa ọbọhk anang kaam, ifha ode mẹ, mofona eden dani, ọtza odebh abọkpa otzima okwu, ifha kọ, ọmaana maman, ttara va paman moning ope k'okwo. ");
INSERT INTO mfo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Kaam ọkhaam wọ nkker-ẹ, ọttọhk manda vani ọsẹ-ẹ, ror-ẹ bọbh-m. Tte kaam ndima akpen paam ndera eho chẹ, idikha nnẹ-ẹ ndim ngwuna nchen-ọ. ");
INSERT INTO mfo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Idikha ira oni egbekhibhi nda ode, nnamanda ira mokk'igbe ifa ọtza okhuna.” ");
INSERT INTO mfo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Mẹ wọ, otte Jekọb on-oben bẹ bi, “Ah ho, ode mando, bọng dekha ẹnanga k'ekpo ẹkkakka mbyuma pya m'ọkhaam m'irek nna, mach'ana p'adaami eruk ibebaa, ọmaana akhọkhọhnana, ọmaana amọma pa kashu, ttara amọma p'almọn achena ojinọng nwuma. ");
INSERT INTO mfo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Bọng biri tzọkha asilva p'ade igbe ifa ka mbuma p'ewunda bọng are ka mkpa sabọng. Bọng apyiri kẹ, bọng nik asilva mbuma pa bọng are ka mma sa mkpa sabọng. Kkeri, asi mẹ, bẹ asi epina akhe bẹ mẹ. ");
INSERT INTO mfo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Bọng biri tzima ọgbaanotte kwabọng anemi eden arọhng k'ojinọng nwuma. ");
INSERT INTO mfo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Tte njọhm saman ide bi, Ọvaar Ibinọkpaabyi kw'Ẹfa biphyir, ọsi ojinọng nwuma ọkhọkha bọng inọngkwo, ifha ótte ọgbaanotte nwonggo kwabọng ọbọhk, ttara Bẹnjamin bẹ atzọn bọng abẹ akhuna. On-ode kaam, idikha va paam adim-m odimi, tte bẹ adim-m ko o.” ");
INSERT INTO mfo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Mẹ wọ, ajinọng mba atzọkha nnanga nnuma, attara asilva p'ade igbe ifa ka p'iwa bẹ atzim, akwu attara ka Bẹnjamin, atzima afona. Bẹ arenga m'ẹbhar k'ẹbhar apyiri k'Ijip, anemi eden achina ka Josẹph. ");
INSERT INTO mfo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Mada, Josẹph ore Bẹnjamin ọmaana bẹ, oben ọtzọhmnọng kwẹ kw'ọhọhm bi, “Kọ tzima ajinọng mba achina k'ọhọhm kwaam, bọng fhu etzen atzima asi ọchattọhk, kkeri sa bẹ áchi ọchattọhk ttar-m k'ẹya.” ");
INSERT INTO mfo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Wa ọtzọhmnọng nwa osi macha Josẹph ọgbaakh-ẹ, otzima ajinọng mba ochina k'ọhọhm kwa Josẹph. ");
INSERT INTO mfo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Mada bẹ apyiri k'ọhọhm kwa Josẹph, ajinọng mba ojora bẹ, bẹ achibhi bi, “Asi mẹ asilva mba p'ewunda bẹ akpa nnam akhe ka mkpa saman bọ, pa bẹ areng abẹ atzima man akwu m'ibe na e. Kẹ oben bi, órima man abẹ, óbiro ọna man ẹfa, óbiro ọbọkha man nnyanyaang saman ọna, óbiro otzima man osi abira pẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Mẹ wọ, bẹ afona atza akhebha ọtzọhmnọng kwa Josẹph k'ẹbaakhamma ch'ọhọhm nwuma, agbaakh-ẹ atzim. ");
INSERT INTO mfo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Bẹ aben bi, “Tzotzokhaan itta kwaman, wa mokwu odebh ọchattọhk ma k'ochedengbe. ");
INSERT INTO mfo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Mada mopyiri k'ibe sa mobhingi, ọnọng-ọnọng on-ore obhik nwuma wani kw'asilva pa otzim odebh ọchattọhk k'ẹmma ch'ẹkpa chẹ ẹtzaanga. Mẹ wọ, motzim bẹ ma bi, morikh e. ");
INSERT INTO mfo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Mada mọni ọnọng orong kw'iwa okhe asilva mbonggo ka mkpa saman, motzim asilva adọdọk okwu p'amotzima odebh ọchattọhk ma e.” ");
INSERT INTO mfo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ọtzọhmnọng nwa oben bi, “Tte oningi bọng ojor, odik m'ẹtzaanga kode. Ibinọkpaabyi kwabọng, kw'ode Ibinọkpaabyi kw'otte kwabọng, okk'bọng agbukha ọnanga ka mkpa sabọng. Kaam wa nkk'asilva pabọng atzim adebh ọchattọhk ndọkha.” Mẹ wọ, ọtzọkha ọgbaanotte kwabẹ Simeọn otzima oyin kanya iyaan, ọnang bẹ. ");
INSERT INTO mfo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ọtzọhmnọng nwa otzima ajinọng mba odim k'ọhọhm kwa Josẹph, ọnang bẹ asi pa bẹ atzim agbobhi mmo mach'ẹmaana chabẹ ede, obiro ọnang nnyanyaang sabẹ ọchattọhk. ");
INSERT INTO mfo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Bẹ ado for ttara nnanga sabẹ atzima atzik ogbe kwa Josẹph opyiri, da bẹ akk'abhaanga bi, sa bẹ awobha mẹ achi ọchattọhk. ");
INSERT INTO mfo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Mada Josẹph opyiri k'ọhọhm, bẹ atzọkha nnanga nnuma sa bẹ akk'atzima akwu m'ọhọhm, anang-ẹ. Bẹ abira arakha attima otzitzikha fabẹ k'irerek, akhọkha Josẹph ikpokpobha. ");
INSERT INTO mfo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ọbọbh bẹ bi, “Osi bọng yan o? Itta kw'ewunda bọng agbaakh-m odik okhuri, otzim orukhi akpen kẹ o? Ọsẹ-ẹ yan?” ");
INSERT INTO mfo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Bẹ abhina bi, “Ọtzọhmnọng kwọ kw'ode otte kwaman otzim orukhi akpen kẹ e, for ibiri igaang-ẹ kẹ e.” Mẹ wọ, bẹ achunga ahokpadim, abira aruri for sabẹ k'irerek, anang Josẹph ikpokpobha. ");
INSERT INTO mfo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Mada Josẹph otzini chen ore ọgbaanọkka Bẹnjamin, kw'ọkka wani ọmaani bẹ, ọn-obọbh bi, “Agbaanatte nwuma kwabọng kw'ikhakhari kw'ewunda bọng agbaakh-m odik okhuri wọ ma o?” On-oben bi, “Nnwa kwaam, tte Ibinọkpaabyi, ọkhọkh-ọ ọphyaam.” ");
INSERT INTO mfo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Mada Josẹph ore ọgbaanọkka kwẹ bi kpaar, ẹmọng ebir-ẹ ttara inọngkwo s'ifẹ-ẹ k'ettem. Obina m'ẹbhar-ẹbhar oji bẹ mẹ, oyin k'iyaan oror ibe s'obhom ẹmọng. On-ochina k'ẹmaanggọ chẹ ẹtzaanga, ọtza obhom ẹmọng. ");
INSERT INTO mfo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Mada okk'itzitzikha oruma, ofona k'ẹmaanggọ oyin k'iyaan, ọbọkha for sẹ, oben bi, “Bọng bera bẹ ọchattọhk.” ");
INSERT INTO mfo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Wa bẹ abera Josẹph ọchattọhk fẹ ngọmi, bẹ abera abọgbaanotte ngọmi, bẹ abira abera anọng p'Ijip p'awobh ttara Josẹph ọchattọhk fabẹ ngọmi. Wa kwẹ ode mando okhuri da, anọng p'Ijip atzọk bi, ode ọbhaangi bi, bẹ achi ọchattọhk ibe rani ttara anọng pa Hiburu. ");
INSERT INTO mfo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Wa bẹ ahokhi votte mba ẹwọr atzor k'ọgbọ kwa bẹ ade, ttẹwọr k'ocheden maa apyiri k'okpong-nnam kwabẹ. Wa bẹ an-abhakhi akkeri ayok, odik okkoni bẹ k'odem kwa bẹ areng ahok bẹ ẹwọr, atzor k'ọgbọ. ");
INSERT INTO mfo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","K'ogbe kwa bẹ akkem ọchattọhk f'ofon k'okpokkoro kwa Josẹph, ekkema cha Bẹnjamin ẹhaabh igbe izen ẹyọhnga ch'ayok biphyir. Wa bẹ biphyir achi ọchattọhk, abira agwo atzuk ttara Josẹph, maa ettem ẹdaam ọnọng kpenamkpen. ");
INSERT INTO mfo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Wa Josẹph otzọhn ọtzọhmnọng kw'ọhọhm kwẹ bi, “Yikha ọchattọhk k'ajinọng mba ka mkpa k'odem kwa bẹ afha atzọhkha, biri khe asilva p'ọnọng-ọnọng ọkk'ọnanga k'ẹmma ch'ẹkpa chẹ. ");
INSERT INTO mfo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Atzọkha nkkọbh kwaam kwa silva akhe k'ẹmma ch'ẹkpa ch'oyok kw'ikhakhari, abira atzọkha asilva p'otzim odebh ọchattọhk akhẹ-ẹ k'ẹkpa.” Wa ọtzọhmnọng nwa osi macha Josẹph ọtzọhn-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Okwu otzuma m'owuhobha, bẹ atzọhm ajinọng mba abhana ttara nnyanyaang sabẹ. ");
INSERT INTO mfo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Mada bẹ an-atzima afona aji obhon k'ibe s'ibhir-obhir, ogbe k'obhiri Josẹph oben ọtzọhmnọng kwẹ bi, “Rọhng akhubh ajinọng mbuma k'eden. Akhebh bẹ, bọbh bẹ bi, ode yan kwa bọng an-atzim itzama, achora ejibha cha bẹ asi anang bọng o? ");
INSERT INTO mfo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Okhuri yan kwa bọng afhu nkkọbh kw'itta kwaam kw'om-otzima ogwo asi, om-obiro otzima ọbhari ose o? Odik-ttama wọ kwa bọng asi ma e.” ");
INSERT INTO mfo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Mada okhebh bẹ k'eden, ọmọnga atzim mba bani agbaak bẹ. ");
INSERT INTO mfo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Yina, bẹ aben-ẹ bi, “Tzọmi-tzọmi okponga k'idachen! Yan kw'itta kwaman ochibhi bi, maman atzọhmnọng pẹ ofha osi odik-dema nwa o? ");
INSERT INTO mfo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Motzer otzima asilva p'ewunda more ka mma sa mkpa saman ẹtzaanga, ttẹwọr k'irek sa Kenaan okwu orik ma. Mbọng vọ ira on-otzima man mofhu silva obiro ode gol, k'ọhọhm kw'itta kwabọng o? ");
INSERT INTO mfo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Idikha are ọnọng m'ottem kw'atzọhmnọng pọ kw'otzim nkkọbh nwuma, ọnọng-dema nwuma ópe-ope, maman ka biphyir mon-obiro ode abira p'itta kwọ.” ");
INSERT INTO mfo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ọtzọhmnọng nwa on-oben bi, “Odik-jibhada kwa bọng agbaakhi. Tte ode macha bọng abeni. Ọnọng kpenamkpen kw'am-ore nkkọbh nwuma k'ẹkpa chẹ, kẹ ón-ode obira kwaam. Yina, ayok kẹ biphyir ánaanga oponga-pyibha kw'odik nwa ọnaanga.” ");
INSERT INTO mfo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Mando kw'ọnọng-ọnọng ọhak ẹkpa chẹ k'irerek m'ẹbhar-ẹbhar, obiro ọchari ẹkpamma chẹ. ");
INSERT INTO mfo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Mando kw'ọtzọhmnọng nwa ọttẹwọr ka mkpa s'adeden-nọng ọm-ọfọhngi, maa okwu opyiri ch'oyok kw'ikhakhari. Wa okwu ore nkkọbh nwuma k'ẹkpa cha Bẹnjamin. ");
INSERT INTO mfo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ofona mẹ, votte an-abọkha ọbara fabẹ afọr ajaakhi, bẹ atzini ndọhkha sabẹ anana ka nnyanyaang sabẹ, abhakhi eho akpa nnam k'obhon kw'ira bẹ afon. ");
INSERT INTO mfo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Iwa Josẹph otzim owobh k'ọhọhm mada Juda ọmaana votte apyiri. Bẹ atto abaangi m'irerek, abhom amọng m'itzitzikha sẹ. ");
INSERT INTO mfo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Mẹ wọ, Josẹph oben bẹ bi, “Bọng odik-dema kwa bọng asi ma? Bọng karong bi, ọnọng macha kaam mmindima ose nnonga idik s'ítto k'ororo o?” ");
INSERT INTO mfo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda on-obhina bi, “Bọng odik kwa mobiro ọfha ọgbaak itta kwaman o? Bọng odik kwa mọgbaakh-ẹ o? Yan kwa mọkhọkha bi, mbọhk saman iwur-owur m'odik nwa o? Ibinọkpaabyi okk'oponga-pyibha kw'atzọhmnọng pọ ọjaakhi k'ọyaankpa. Mon-ode abira p'itta kwaman ma e, maman ma for saman magbakha oyok kwa bẹ are nkkọbh k'ẹkpa chẹ.” ");
INSERT INTO mfo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yina, Josẹph oben bi, “Tzọmi-tzọmi okponga k'idachen bi, kaam nsi odik-dema nwa. Ọnọng kw'ira bẹ are nkkọbh k'ẹkpa chẹ, wọ óde obira kwaam. Bọbọng kẹ biphyir, bọng nọhng abhana atza akhebha atte kwabọng k'odidiri.” ");
INSERT INTO mfo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Mẹ wọ, Juda ofona ọtza okhebha Josẹph, oben-ẹ bi, “Itta kwaam, ngaam atzim pa mben bi mgbaak nnang-ọ abhaanga. Tzotzokhaan, oning-ọ ọdọkhi ọmaana kaam ọtzọhmnọng kwọ. Kaam nnong kẹ bi, ẹfa chọ ede ebengambọhk ttara Phero ọkhaam ma for sẹ. ");
INSERT INTO mfo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","“Wa itta kwaam ọbọbhi atzọhmnọng pẹ bi, ‘Bọng akhaam atte ttara ọgbaanọkka ọdọdọk kẹ o?’ ");
INSERT INTO mfo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Wa mobhin bi, ‘Mọkhaam otte kẹ kw'ọkk'ọtzama, mobiro ọkhaama ọgbaanọtte kw'otte kwaman obhoni k'atzam. Ọgbaanọkka kwa bẹ ade ọkka wani, wa ọkk'ọpa, kẹ-khẹ wọ on-orikhi k'ọkka kwabẹ e, kẹ ọdaakhi otte idik kpọnkpọng e.’ ");
INSERT INTO mfo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Mẹ wọ, wa aben atzọhmnọng pọ bi, ‘Bọng nọhng atza atzim-ẹ akwu, ifha nnẹ ttara chen paam.’ ");
INSERT INTO mfo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Wa mọgbaakh-ọ bi, otte kwaman kókhera bi otte nnwa nwa ọbọhk ofona ọjẹ-ẹ e, okhuri bi, ofon ọjẹ-ẹ, otte ópe-ope. ");
INSERT INTO mfo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Yina, wa aben atzọhmnọng pọ bi, ‘Bọng itzitzikha saam dọk kínnang, bọng ani agbaanatte kw'ode bọng okpong-nnam atzim akwu bi, nnẹ-ẹ.’ ");
INSERT INTO mfo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Mada mọkpa nnam ọtza okhebha ọtzọhmnọng kwọ, kw'ode otte kwaman, mọgbaakh-ẹ eden cha kọ, itta kwaam, akk'man agbaakha. ");
INSERT INTO mfo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Mẹ wọ, mada otte kwaman obeni bi, ‘Bọng nọhng abira atza adebh ọchattọhk ibebaa.’ ");
INSERT INTO mfo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Yina, wa moben bi, ‘Man kọfha ọtza idikha an-akher bi, motzima ọgbaanotte kwaman ọtza. Man itzitzikha s'ojinọng nwuma kw'om-okpe ọchattọhk kofha ore, idikha ọgbaanotte kwaman kw'ikhakhari oni man abẹ ọtzọni otza odebh ọchattọhk.’ ");
INSERT INTO mfo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Otte kwaman kw'ode ọtzọhmnọng kwọ obeni man bi, ‘Bọng akk'aronga bi, wa kwanọng kwaam ọmaan-m va afa p'ijinọng. ");
INSERT INTO mfo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Oyok wani k'akpen dọk kode. K'odik-ọkka nden nkk'ẹ nchikhi k'abir-ibiri. Ttẹwọr kẹ maa apyiri ma, kaam kẹ ka chen kinne. ");
INSERT INTO mfo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Idikha bọng abira atzima oyok nwa afona, itzama kpenamkpen ikhebh-ẹ k'eden, nnam kọkpa, kw'oyini bi, bọng ánọhng-m k'atzam ttara nkwu-osisi.’ ");
INSERT INTO mfo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Mẹ wọ ode bi, idikha nnwa nwa oni man abẹ ọtzọni, mada mkpa nnam k'otte kwaam kw'ode ọtzọhmnọng kwọ, kw'ettem chẹ biphyir ẹgban ma nnwa nwa, ");
INSERT INTO mfo_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","on-ore bi nnwa nwa man abẹ kọtzọni, kẹ ópe-ope e. Atzọhmnọng pọ án-awọhkhi otte kwaman ope k'atzam, mọnọhng-ẹ ttara izen ka chen e. ");
INSERT INTO mfo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Kaam ọtzọhmnọng kwọ wọ nnwọhngi k'itzitzikha s'otte kwaam, mben-ẹ bi, ‘Tte kaam ndima akpen paam ndera eho chẹ, idikha nnẹ-ẹ ndim ngwuna nchen-ọ!’ ");
INSERT INTO mfo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Mẹ wọ, itta kwaam, kaam ngwukhọ-okhukhi, tzima kaam ọtzọhmnọng kwọ mach'obira atzer eho cha nnwa nwa, ifha attẹ-ẹ ọbọhk ọtzọn votte pẹ abẹ ọbhana. ");
INSERT INTO mfo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Kaam eden kinnong cha kaam mmana ndor otte kwaman, idikha nnwa nwa oni kaam abẹ ọtzọni ọbhana. Mma e! Kaam ọbọhk katte bi, nda nne ọmmamma kw'odik nwa ọnang otte kwaam e.” ");
INSERT INTO mfo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Mada Josẹph oni for sẹ dọk ọfha ọbọkha k'itzitzikha s'atzọhmnọng pẹ, ọhọbhi ẹmọng obhom, “Ọnọng kpenamkpen obina k'itzitzikha saam!” Mẹ wọ, wa okkekkeminọng ọdọdọk kw'owobh mẹ kode, k'ogbe Josẹph osi ẹjaakhi cha for sẹ ọnang votte pẹ. ");
INSERT INTO mfo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Wa Josẹph on-obhom ẹmọng k'ẹrọng maa anọng p'Ijip abhaanga, maa ẹhọhmmọr cha Phero ebire ẹbhaanga ẹmọng ch'obhomi. ");
INSERT INTO mfo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Josẹph oben votte pẹ bi, “Kaam wọ nde Josẹph e! Otte kwaam otzim orukhi akpen kẹ o?” Yina, wa votte kẹ ebhina kafha anang, okhuri opoma-dem f'ọbọk bẹ k'itzitzikha sẹ. ");
INSERT INTO mfo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Josẹph oben votte bi, “Bọng nọkhi baang-m ka for.” Mada bẹ akk'mando asa, on-oben bi, “Kaam wọ nde Josẹph, ọgbaanọtte kwabọng, kw'iwa bọng akpe anang aphyaphya p'Ijip. ");
INSERT INTO mfo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Nttem nningi bọng atzim iyakhi. Bọng ayok kabira apyima bi, bọng akpe-m anang ma, okhuri bi, Ibinọkpaabyi ochi eden ọtzọhm kaam ma bi, ifha orenga ka nnam saam ọkkaana akpen p'anọng. ");
INSERT INTO mfo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Onode cho afa ma p'okwo f'ideden owobh m'irek nna e, ka cho azen p'am-akwu k'itzitzikha anọng bẹ ekpo káyaabha, bẹ kabira apha. ");
INSERT INTO mfo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Yina, wa Ibinọkpaabyi ochi eden ọtzọhm kaam ma bi, nkkaana nhok bọng ayok bani akpen m'ọyagbin, ifha mbiri nnang bọng ẹnaanga ch'ideden. ");
INSERT INTO mfo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Mẹ wọ, bọbọng arang asi, Ibinọkpaabyi wọ iwa ọtzọhm-m ma e. Osi-m bi, nde ọvaar kw'ajukwa pa Phero biphyir, ọmaana itta kw'ọhọhm kwẹ, ttara ọdabhi kw'anọng p'Ijip makhọra. ");
INSERT INTO mfo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","M'ẹbhar-ẹbhar, bọng kpa nnam k'otte kwaam atza agbaakh-ẹ bi, ‘Nnwa kwọ Josẹph ọtzọhmi ẹkkaabha ochen-ọ bi, Ibinọkpaabyi ọkk'aam ẹvaar ch'Ijip biphyir ọnanga. Kọ ogbe kàkhibhi, jekha akwu akhebh-m ka da nwobh. ");
INSERT INTO mfo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Kọ otte kwaam, ọmaana va pọ, ọmaana va pa va pọ, ọmaana etzirakpo pyọ, ọmaana abhaam pọ, ttara ọttọhk kpenamkpen fọ biphyir, an-aruk k'okhubha kwa Goshẹn, ifha moruk ọbaanga ayok. ");
INSERT INTO mfo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ka Goshẹn wọ kwa kaam nkker-ọ, okhuri bi, cho azen p'okwo f'ideden awobh k'itzitzikha. Oni mando ode, kọ ọmaana ẹhọhmmọr chọ, ọmaana etzirakpo pyọ biphyir, bọng awobha k'ogbor.’ ");
INSERT INTO mfo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Bọng biphyir akk'ara, ọgbaanọkka kwaam Bẹnjamin obiro ore bi, k'odik-ọkka kaam wọ mimgbaak bọng atzim ma e. ");
INSERT INTO mfo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Bọng gbaak otte kwaam abarada pa kaam ngaam k'Ijip, bọng biri gbaakh-ẹ odik kpenamkpen kwa bọng akk'ara. M'ẹbhar-ẹbhar, bọng nọhng atza atzima otte kwaam akwu.” ");
INSERT INTO mfo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Mẹ wọ, Josẹph ọkhaara ọgbaanọkka Bẹnjamin mbọhk, bẹ abaakha ayok, abira abhom. ");
INSERT INTO mfo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Wa Josẹph obhom ẹmọng nduma otzima ọbaakha votte pẹ biphyir. Mada okk'mando ọsa, mẹ wọ kwa votte pẹ an-akhaam ottembara bi, bẹ agbaak atzim ttar-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Mada ẹgọmi nda epyiri k'ọvaar-dimpa kwa Phero bi, votte pa Josẹph akk'akwa m'Ijip, wa ettem ẹdaam Phero ọmaana akhaan-nọng pẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Phero oben Josẹph bi, “Ben votte pọ bi, ‘Odik kwa bọng asi ode bi, bọng dọkha ekpo pyabọng anana etzirakpo pyabọng, ifha bọng abhana k'ẹkhọma cha Kenaan, ");
INSERT INTO mfo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","bọng biri tzima atte kwabọng, ọmaana nhọhmmọr sabọng akwu k'Ijip. Kaam ńnang bọng okhubha kw'irerek s'ijibhi ọtzam, ifha bọng akhaama ekpo k'ọhaabh py'efona mẹ.’ ");
INSERT INTO mfo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Kọ biri gbaak bẹ bi, ‘Odik kwa bọng asi ode bi: Bọng dọkha akpaar p'ideden pa nnyanyaang mmindọr m'Ijip, atzima atza atzọkha va pabọng, ọmaana panọng pabọng, ttara atte kwabọng atzima akwu. ");
INSERT INTO mfo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Bọng ẹkhakhaama chabọng kare mach'odik kw'ọyak bọng atzim, okhuri bi, okhubha kw'irerek s'ijibhi ọtzam k'Ijip, ọkhaam bọbọng.’ ” ");
INSERT INTO mfo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Mẹ wọ, wa va pa Jekọb asi odik kpenamkpen kwa bẹ atzọni bẹ. Josẹph ọnang votte pẹ akpaar p'ẹbhar p'ideden otzor k'ẹfa ch'ọvaar Phero ọkk'ọnanga, obiro ọnang bẹ ọchattọhk fa bẹ achi k'eden. ");
INSERT INTO mfo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ọnang ọnọng-ọnọng ọbara ọbhapfẹ, oyongi Bẹnjamin kw'ọnangi ashẹkẹl arọbh chi pa silva ọmaana ọbara adem azen ọdọdọk. ");
INSERT INTO mfo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Wa Josẹph ọtzọkha anyanyaang-dim jobh p'atzọhk ekpo ẹkkakka py'Ijip, ọmaana anyanyaang-papẹ jobh p'atzọhk abọkpa ttara brẹd, ttara ọchattọhk ọdọdọk f'otte otzima orenga k'eden. ");
INSERT INTO mfo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Mẹ wọ, mada okk'bẹ ekpo mbya okkema biphyir, oben bẹ arọhng. Mada bẹ an-abina orenga, oben bẹ bi, “Bọng ẹkhọhr k'eden kasi o!” ");
INSERT INTO mfo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Mẹ wọ, bẹ abina k'Ijip akwu akhebha otte kwabẹ Jekọb k'ẹkhọma cha Kenaan. ");
INSERT INTO mfo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Mada bẹ akwu apyiri, bẹ agbaak otte bi, “Josẹph otzim orukhi akpen kẹ e! Kẹ wọ ode ọvaarnọng kw'irek s'Ijip biphyir.” Jekọb okkon-ẹ, odik nwa k'odik-ọkka kọtzọk. ");
INSERT INTO mfo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Yina, mada bẹ an-agbaakh-ẹ odik kpenamkpen kwa Josẹph okk'bẹ ọgbaakha, obiro ore akpaar p'ideden pa nnyanyaang mmindọr pa Josẹph ọkk'ọtzọhma bi, bẹ atzima akwu atzin-ẹ atzima achina k'Ijip, ẹfa ebire ewobha Jekọb. ");
INSERT INTO mfo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Mẹ wọ, Jekọb oben bi, “Kwẹ ode odik ọkkakka e, nnwa kwaam Josẹph otzim orukhi akpen kẹ e. Kaam ngaam bi, ńda k'Ijip nda nnẹ-ẹ yina kaam ḿpe e.” ");
INSERT INTO mfo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Mando kwa Jekọb obin orenga ttara ọttọhk kpenamkpen f'ode fẹ. Mada okwu opyiri ka Bẹrshẹba, osi njafọhni mẹ ọnang Ibinọkpaabyi kw'otte kwẹ Isaak okpobh. ");
INSERT INTO mfo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Okwu opyiri k'erungi, Ibinọkpaabyi oyin Jekọb abẹ k'idachen, oyer-ẹ bi, “Jekọb! Jekọb!” Jekọb okhera bi, “Kkeri kaam ma e.” ");
INSERT INTO mfo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Mẹ wọ, oben bi, “Kaam wọ nde Ibinọkpaabyi, Ibinọkpaabyi kw'atte kwọ okpobh, oning-ọ ojor bi achina k'Ijip, okhuri bi, kẹ wọ kwa kaam ńsọ-ọ bi, ade ẹkhọma ch'ideden. ");
INSERT INTO mfo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Kaam ńdọn-ọ abẹ nchina k'Ijip, mbiri ńdim-ọ mkpa nnam. Josẹph wọ óde ọnọng kw'obubh-ọ chen k'obo.” ");
INSERT INTO mfo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Iwa Jekọb obina ka Bẹrshẹba, va pẹ atzima kẹ kw'ode otte kwabẹ, ọmaana va pabẹ, ttara panọng pabẹ, ayikha k'akpaar p'ideden pa nnyanyaang mindọr, pa Phero ọkk'ọtzọhma bi, bẹ atzima atzini otte. ");
INSERT INTO mfo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Wa Jekọb, ọmaana va pa va pẹ biphyir atzima etzirakpo pyabẹ, ọmaana ẹkhakhaama cha bẹ akk'asa k'ẹkhọma cha Kenaan, achina k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Jekọb otzima va pẹ p'ijinọng ọmaana va pabẹ, ttara va pẹ p'ipanọng ọmaana va pabẹ, ẹhọhmmọr chẹ biphyir, ochina k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ma wọ ode che pa va p'ijinọng pa Jekọb, p'achin k'Ijip. Reubẹn kw'ode ocheden-nwa kwa Jekọb. ");
INSERT INTO mfo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Va p'ijinọng pa Reubẹn ade, Hanọk, ọmaana Palu, Hẹzrọn, ttara Karmi. ");
INSERT INTO mfo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Va p'ijinọng pa Simeọn ade: Jemuyẹl, ọmaana Jamin, ọmaana Ọhad, ọmaana Jakin, ọmaana Zoha, ọmaana Shaul kw'ode nnwa kw'ijinọng kwa kwanọng kwẹ kw'ofon Kenaan ọmaani. ");
INSERT INTO mfo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Va p'ijinọng pa Lẹvi ade: Gẹrshọn, ọmaana Kohat ọmaana Mẹrari. ");
INSERT INTO mfo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Va p'ijinọng pa Juda ade: Ẹr, ọmaana Ọnan, ọmaana Shẹla, ọmaana Pẹrẹz ttara Zẹra (yina, wa Ẹr ọmaana Ọnan akk'apa k'irek sa Kenaan). Va p'ijinọng pa Pẹrẹz ade: Hẹzrọn ọmaana Hamul. ");
INSERT INTO mfo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Va p'ijinọng pa Isaaka ade: Tola, ọmaana Pua, ọmaana Jashub ọmaana Shimrọn. ");
INSERT INTO mfo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Va p'ijinọng pa Zẹbulun ade: Sẹrẹd, ọmaana Ẹlọn, ọmaana Jalẹl. ");
INSERT INTO mfo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ma wọ ode va p'ijinọng p'iwa Lea ọmaani ọnang Jekọb k'obhon kwa Padan-Aram, akhiri ominanwa kwẹ Daina ájì. Wa va mba pẹ biphyir, adikkobh ọmaana aminava ade ẹrọbh obhiri jobh obhiri attaan. ");
INSERT INTO mfo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Va p'ijinọng pa Gad ade: Ziphon, ọmaana Hagi, ọmaana Shuni, ọmaana Ẹzbọn, ọmaana Ẹri, ọmaana Arodi, ttara Areli. ");
INSERT INTO mfo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Va p'ijinọng p'Ashẹr ade: Imna, ọmaana Ishva, ọmaana Ishvi, ttara Beriya. Ọgbaanọkka kwabẹ kw'ikwanọng wa ode Sẹra. Va pa Beriya p'ijinọng ade: Hebẹr, ọmaana Malkiyẹl. ");
INSERT INTO mfo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Wa va chi obhiri wani bọ pa Zilpa ọmaani ọnang Jekọb. Zilpa wa ode obira kwa Laban ọkk'ọtzọkha ọnang ominanwa kwẹ Lea bi, oruk Lea abẹ. ");
INSERT INTO mfo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ajinọng pa Jekọb obhoni ka kwanọng kwẹ Rachẹl ade, Josẹph ọmaana Bẹnjamin. ");
INSERT INTO mfo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Asenat kw'ode ominanwa kwa Potiphera, kw'ode ọfọhnẹja k'obhon kw'On, ọmaani Manasẹ ttara Ephraim ọnang Josẹph k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Va p'ijinọng pa Bẹnjamin ade: Bẹla, ọmaana Bẹkẹr, ọmaana Ashbẹl, ọmaana Gẹra, ọmaana Naaman, ọmaana Ehi, ọmaana Rosh, ọmaana Mupim, ọmaana Hupim, ttara Ard. ");
INSERT INTO mfo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Va p'ijinọng biphyir pa Rachẹl ọmaani ọnang Jekọb ade ọhawani kwa chi. ");
INSERT INTO mfo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan obhoni ojinọng kw'okpen Hushim. ");
INSERT INTO mfo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Va p'ijinọng pa Naphtali ade: Jazẹl, ọmaana Guni, ọmaana Jẹzẹr ttara Shilẹm. ");
INSERT INTO mfo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Biphyir-phyir Bilha kw'ode obira kw'iwa Laban ọtzọk ọnang ominanwa kwẹ Rachẹl, ọmaani va azenamfa ọnang Jekọb. ");
INSERT INTO mfo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Wa ọnọng-mik kw'ọtzọni Jekọb abẹ ochina k'Ijip, ode arọbh attaan obhiri azadani akhiri panọng pa va aji, anọng mba biphyir wa bẹ afon k'ẹnọmma cha Jekọb. ");
INSERT INTO mfo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","An-atzọk va afa p'ijinọng pa Josẹph obhoni k'Ijip attara, biphyir-phyir ọnọng-mik kw'ẹhọhmmọr cha Jekọb kw'ochin k'Ijip ode: anọng arọbh attaan obhiri jobh. ");
INSERT INTO mfo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Mẹ wọ, Jekọb ọtzọhm Juda bi, ochi eden ọkwọbha ọtza okhebha Josẹph, ọbọbh ibe sa Goshẹn owobh. Mada bẹ apyiri k'okhubha kwa Goshẹn, ");
INSERT INTO mfo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Josẹph ọnang ẹfa bi, bẹ atzọkha akpaar p'ideden pa nnyanyaang mmindọr atzima akwu, ifha otza ore otte Israẹl kw'opyiri ka Goshẹn. Mada Josẹph ore otte bi kpaar ọkhaara otte mbọhk k'ekhokhora, obiro obhom ẹmọng k'ogbe-bhirada. ");
INSERT INTO mfo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Jekọb oben Josẹph bi, “Mada kaam nkk'nna k'odik-ọkka bi, kọ atzima arukhi akpen ka, kaam nna mpe yina e.” ");
INSERT INTO mfo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Mẹ wọ, Josẹph oben votte pẹ ọmaana ẹhọhmmọr ch'otte kwẹ bi, “Kaam ńchina ka Phero nda ḿgbaakh-ẹ bi, ‘Votte paam ọmaana ẹhọhmmọr ch'otte kwaam, p'iwa arukhi k'irek sa Kenaan, akk'aam atzora ka e. ");
INSERT INTO mfo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ajinọng mba ade akkeri-arukhimaan, bẹ akk'akwa ttara nden sabẹ, ọmaana ọttọhk kpenamkpen fabẹ biphyir.’ ");
INSERT INTO mfo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ọn-ọbhakhi oben votte pẹ bi, Phero oyeri bọng, ọbọbh bọng bi, ‘Mbọng vọ ode ọtzọhmbọhk fabọng?’ ");
INSERT INTO mfo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Bọng abhina bi, ‘Itta, maman atzọhmnọng pọ mọttẹwọr k'ẹvava chaman om-otzir nden, mach'abatte paman e.’ Mẹ kẹ-khẹ wọ kwa bẹ atzima átte bọng ọbọhk, bọng aruk ka Goshẹn, okhuri bi, anọng p'akkeri-arukhimaan akpukhi anọng p'Ijip idik k'eden dama.” ");
INSERT INTO mfo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Wa Josẹph obina ọtza ọgbaak Phero bi, “Otte kwaam ọmaana votte paam akk'etzirakpo pyabẹ, ọmaana abhaam, ttara ọttọhk kpenamkpen fabẹ akhaam, atzima abina k'irek sa Kenaan apyiri ma Goshẹn.” ");
INSERT INTO mfo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Josẹph otzekha votte pẹ anọng azen, otzima bẹ ọtza ọkhọhkha Phero. ");
INSERT INTO mfo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Phero ọbọbh votte pa Josẹph bi, “Mbọng vọ ode ọtzọhmbọhk fabọng?” Bẹ abhin-ẹ bi, “Itta, maman atzọhmnọng pọ mode akkeri-arukhimaan e, mach'iwa abatte paman ade e.” ");
INSERT INTO mfo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Bẹ abira aben Phero bi, “Maman ọkk'ọkwa bi, mokwu oruk m'irek nna k'igbegbaa bi kọbh, okhuri bi, okwo f'ideden owobh ka Kenaan, ttara bi, araraari kẹ dọk kade p'etzirakpo py'atzọhmnọng pọ echi. Mẹ wọ, tzotzokhaan, tte maman atzọhmnọng pọ oruk k'irek sa Goshẹn.” ");
INSERT INTO mfo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Iwa Phero oben Josẹph bi, “Mada atte ọmaana votte pọ akk'ọ akwa akhebha ka, ");
INSERT INTO mfo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","irek s'Ijip biphyir iwobh ka mbọhk sọ, kọ tzekha ibe s'arong bi, ijibh-ojibh anang bẹ, bẹ wobha. Tte bẹ aruk k'okhubha kwa Goshẹn. Idikha arong anọng k'ottem kwabẹ p'akhaam emengkka ch'ọtzọhm, kọ tzọkha etzirakpo pyaam anang bẹ, akkeri.” ");
INSERT INTO mfo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Mẹ wọ, Josẹph obiro otzima otte Jekọb ọtza ọkhọhkha Phero. Wa Jekọb osi Phero ittabọhng, ọdẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Phero ọn-ọbọbh Jekọb bi, “Kọ an-ade cho aphaang o?” ");
INSERT INTO mfo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jekọb obhina Phero bi, “Kaam nkk'cho arọbh azadani obhiri jobh nnukha. Cho pa kaam nkk'nnukha kahaabhi, bẹ abira ayakh-ọyak. Bẹ macha cho p'iwa abatte paam arukhi kapyiri.” ");
INSERT INTO mfo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Mẹ wọ, Jekọb obiro osi Phero ittabọhng, ọdẹ-ẹ, yina on-obin ofona. ");
INSERT INTO mfo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Iwa Josẹph ọtzọkha irerek ọkkọkka nnuma s'okk'otzekha k'Ijip, k'ẹkhọma cha Rameses, ọnang otte ttara votte pẹ bi bẹ aruk, macha Phero ọtzọhn-ẹ bi, ọsi. ");
INSERT INTO mfo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Josẹph obiro ọtzọkha ọchattọhk f'obenga otte, ọmaana votte pẹ, ttara ẹhọhmmọr ch'otte biphyir ekkema, ọnang bẹ otzor k'obhik kwa va pabẹ. ");
INSERT INTO mfo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Iwa ọchattọhk mebubuni kode, okhuri da okwo f'ideden ochin ororo owobha m'ẹkhọma nda biphyir. Wa anọng p'Ijip, ọmaana anọng pa Kenaan an-are ihem okhuri okwo f'ideden. ");
INSERT INTO mfo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Wa Josẹph otzobha agbukha p'awobh k'Ijip biphyir ọmaana agbukha p'anọng pa Kenaan am-adebh ọchattọhk, otzima ochina k'ọvaar-họhm kwa Phero. ");
INSERT INTO mfo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","K'ogbe kw'agbukha akk'anọng p'Ijip ọmaana anọng pa Kenaan aha ka mbọhk, anọng p'Ijip biphyir abina atza akhebha Josẹph aben bi, “Agbukha akk'man aha ka mbọhkh e. Ka yan kw'akkeri man ma mope k'okwo o? Nang man ọchattọhk.” ");
INSERT INTO mfo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Mẹ wọ, Josẹph obhina bẹ bi, “Mada agbukha akk'bọng ka mbọhk aha, bọng dima etzirakpo pyabọng akwu, ifha mosi obhona ttara ọchattọhk.” ");
INSERT INTO mfo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Mando kw'anọng mba afon atza atzọkha etzirakpo pyabẹ py'ede nnyanyaang, ọmaana arukhimaan, ọmaana avu, ọmaana abhaam, ttara nnyanyaang dọk, atza anang Josẹph. Wa ọnang bẹ ọchattọhk ma cho nwuma biphyir, k'obhona kw'etzirakpo pyabẹ. ");
INSERT INTO mfo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mada cho nwuma ọkwọbh, anọng mba afona atza aben Josẹph bi, “Odik kode kwa modubha itta kwaman, odik ode bi, mada agbukha paman ahaha, etzirakpo pyaman en-ede pyọ. Ayongi for saman, ttara irerek saman, ọttọhk fa mobiro ọnang-ọ, itta kwaman dọk kode. ");
INSERT INTO mfo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Man ọbọhk katte, ttara irerek saman mope k'okwo k'itzitzikha sọ. Debh man ttara irerek saman, anang man ọchattọhk. Maman ttara irerek saman okk'for ọda bi, mowobha k'ebira cha Phero. Kọ nang man akpo-mọma pa mọyaabha otzima oruk akpen, ifha irerek saman iningi idukhi ibiri iwobha.” ");
INSERT INTO mfo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Mando kwa Josẹph odebhi irerek s'Ijip biphyir ọnang Phero. Anọng p'Ijip biphyir atzọkha iwoni sabẹ akpe, okhuri da okwo f'ideden ọn-ọgaangi kpọng ọnang bẹ. Wa irerek s'Ijip biphyir in-ide sa Phero. ");
INSERT INTO mfo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Wa Josẹph on-osi anọng mba ade abira, ttẹwọr k'ebhonho dani ch'Ijip maa, apyiri k'okpong. ");
INSERT INTO mfo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Kaambi mẹ wọ, wa irerek s'afọhnẹja kodebhi, okhuri ekkema cha bẹ am-atzọkha ka mbọhk sa Phero, f'osi bẹ abira akhaama ọchattọhk k'ọhaabh f'ofon k'ekkema cha Phero ọnangi bẹ. Kẹ wọ osi wa bẹ irerek sabẹ kakpe e. ");
INSERT INTO mfo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Wa Josẹph on-oben anọng mba bi, “Bọng akk'ara bi, kaam nkk'bọng ndebha ọmaana irerek sabọng biphyir mayina, nnang ọvaar Phero. Bọng na tzọkha achimọma mba atza ayaabha. ");
INSERT INTO mfo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Yina, mada bọng asi ipha, bọng kkema ọchattọhk mva k'obe ozen, bọng atzọkha okhung wani ahok Phero. Bọng dọkha ahung mbonggo anna ahok k'ọyayaabha, ọmaana k'ọchattọhk fa bọng, ọmaana nhọhmmọr sabọng, ttara va pabọng.” ");
INSERT INTO mfo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Mẹ wọ, bẹ an-aben bi, “Iyaa, kọ akk'akpen paman akkaana e. Tte mọtzọkha ọphyaam k'itzitzikha s'itta kwaman, mokk'okhera bi, móde abira pa Phero.” ");
INSERT INTO mfo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Iwa Josẹph on-otzini odik nwa ohok mach'ọphaangi kw'okhuri irerek s'Ijip bi, tzọni m'ewu nduma maa apyiri mayina, bẹ am-anang Phero okhung wani k'akhung azen, k'ekpo pya bẹ apha. Oyongi irerek s'afọhnẹja sẹ-sẹ rọ, s'iwa ini sa Phero ide. ");
INSERT INTO mfo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Wa anọng p'Israẹl aruk k'okhubha kwa Goshẹn k'Ijip. Akpen ajibh bẹ, bẹ akhaama ẹkhakhaama k'ọhaabh, abira amaan ayok k'ọhaabh, obhik kwabẹ obiro ọhaabh. ");
INSERT INTO mfo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Wa Jekọb orukhi k'irek s'Ijip cho chi obhiri afa. Biphyir-phyir wa Jekọb orukhi cho arọbh azenamfa obhiri azenamfa. ");
INSERT INTO mfo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Mada ebowu ch'Israẹl ẹm-ẹbaang, oyeri nnwa kwẹ Josẹph, oben-ẹ bi, “Idikha nkk'ọphyaam ndọkha ka kọ k'itzitzikha, kẹ ọbọhk kwọ ka ndaak saam achekhi bi, kọ akhọhkh-m ejibha k'odik-ọkka bi, kaam m'Ijip kánọhnga. ");
INSERT INTO mfo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Yina, mada ḿpe ndor abitta paam, kọ tzini obukhi kwaam m'Ijip atza anọhnga kẹ da bẹ anọhng bẹ.” Mẹ wọ, Josẹph oben bi, “Kaam ńsi-osi mach'abeni.” ");
INSERT INTO mfo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Jekọb on-oben bi, “Kọ chekhi anang-m.” Mẹ wọ e, Josẹph ochekhi ọnang-ẹ. Wa Jekọb, kw'obiro okpena Israẹl ọrakha eho ọnana k'ochikhura kwẹ, ọnang Ibinọkpaabyi ikpokpobha. ");
INSERT INTO mfo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Mada ogbe nwuma ọkk'ọkwọbha, bẹ agbaak Josẹph bi, “Atte ọmmẹ-ẹ ọmma.” Mẹ wọ, Josẹph obina ttara va pẹ p'ijinọng afa p'ade; Manasẹ ttara Ephraim, otza ore otte. ");
INSERT INTO mfo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Mada bẹ agbaakhi Jekọb bi, “Nnwa kwọ Josẹph ọkk'ọkwa bi, okwu ọrọ-ọ e,” Jekọb okhonga obina k'ebin ch'oyim, owobha ẹwọr. ");
INSERT INTO mfo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jekọb on-oben Josẹph bi, “Ibinọkpaabyi kw'Ẹfa biphyir oyin-m abẹ obiro odo-m ka Luz, k'irerek sa Kenaan, ");
INSERT INTO mfo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","obiro oben-m bi, ‘Kaam ńdọ-ọ ttara ọhaabh, mbiri nttar-ọ ọnọng-mik. Kaam ńsọ-ọ ade obhon k'obungi, mbiri ńdọkha irerek nnang va pa va pọ mach'ekkema chabẹ maa, ogbe ode.’ ");
INSERT INTO mfo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Mẹ wọ, va mba afa p'ade Manasẹ ọmaana Ephraim p'abhoni k'irek s'Ijip yina kaam nna nkwu, bẹ áde va paam, macha Reubẹn, ọmaana Simeọn ade. ");
INSERT INTO mfo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Va adọdọk p'an-abhon bọ án-ade va pọ. Ekkema cha va mba p'án-ade pọ, éfona ka ngọma s'Ephraim, ọmaana Manasẹ. ");
INSERT INTO mfo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Wa ode odik kwa nkwu-osisi s'ideden bi, mada mfon ka Padan-Aram ngwuna, wa Rachẹl okwu ope k'eden kẹ da motzim om-orenga k'ẹkhọma cha Kenaan, kw'ọbaang Ẹphrat. Mẹ wọ, wa kaam nnọhng-ẹ k'eden ch'echin Ẹphrat (kw'ode Bẹtẹlẹhẹm).” ");
INSERT INTO mfo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Mẹ wọ, mada Jekọb ore va pa Josẹph, ọbọbh bi, “Bọng anọng bọ kẹ o?” ");
INSERT INTO mfo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Josẹph obhina otte bi, “Va p'Ibinọkpaabyi akk'aam ọnanga bọ ma e.” Mẹ wọ, Jekọb on-oben bi, “Tzima bẹ akwu, ifha nsi bẹ ittabọhng.” ");
INSERT INTO mfo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","M'ogbe nwa, wa Jekọb owonikpa bi kpaar dọk komo-ore okhuri atzam. Mẹ wọ, wa Josẹph otzima va mba pẹ afa ọrọkhi otzor otte ka for, otte ọbaakha bẹ. ");
INSERT INTO mfo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Mada okk'bẹ ọbaakha, Israẹl on-oben Josẹph bi, “Kaam chen kinkhokhi bi, na mbiri nne itzitzikha sọ. Yina, itzitzikha sọ sẹ-sẹ arang sa kaam nna mbiri nne, Ibinọkpaabyi ọkk'ọsa bi, mbiri nne va pọ.” ");
INSERT INTO mfo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Mẹ wọ, Josẹph ọn-ọrọbha va mba ka ndaak s'otte, ọrakha ottima itzitzikha k'irerek ọnang Jekọb ikpokpobha. ");
INSERT INTO mfo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Mẹ wọ, Josẹph ọbọkha Ephraim k'odimbọhk kwẹ kw'ode kwabọhk kwa Jekọb, obiro ọbọkha Manasẹ ka kwabọhk kwẹ, kw'ode k'odimbọhk kwa Jekọb, ọrọkhi bẹ ọbaanga otte ka for. ");
INSERT INTO mfo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Yina, wa Jekọb otzini mbọhk sẹ ọnana va mba ka nho. Ọnana Ephraim kw'ode nnwa-nnwa, odimbọhk, ọnana Manasẹ kw'ode ocheden-nwa, kwabọhk. ");
INSERT INTO mfo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Mẹ wọ, osi Josẹph ittabọhng oben bi, “Tte Ọvaar Ibinọkpaabyi kw'abatte paam Abraham, ọmaana Isaak akpobh, Ibinọkpaabyi kw'ọkk'aam okkeri k'akpen paam biphyir maa, apyiri ma, ");
INSERT INTO mfo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","tte Orenga-eden, kw'ọkk'aam ọkkaana, k'itzama kpenamkpen, odo va mba. Tte va mba akpena che pabẹ abhina kaam, tte bẹ abira akpena che pabẹ abhina, abatte paam Abraham ọmaana Isaak. Tte bẹ ahaabh ayong-oyongi m'ọyagbin.” ");
INSERT INTO mfo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Mada Josẹph ore bi, odimbọhk kw'otte ọnan Ephraim k'eho, ettem ebhem-ẹ. Mẹ wọ e, ọtza bi otza otzini ọbọhk kw'otte ọnan Ephraim k'eho bi, ọnana Manasẹ. ");
INSERT INTO mfo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Josẹph oben otte bi, “Mma e itta kwaam, nana oyok nwa kw'ode ocheden odimbọhk kwọ k'eho e.” ");
INSERT INTO mfo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Yina, otte obhum, oben bi, “Nnwa kwaam, nnong ọttọhk fa minsi kẹ e, kaam nnong kẹ bi va pa va pa Manasẹ áde ẹkhọma ch'ideden, ch'ebire ẹtza che. Ayongi mẹ, Ephraim ọ́khaama ẹfa ọyọhnga Manasẹ, va pa va pẹ áde idibhon s'ihaabh-ọhaabh.” ");
INSERT INTO mfo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Mando kwa Jekọb osi va mba ittabọhng m'ewu nduma, oben bi, “Anọng p'Israẹl átzima che chọ asi ayok ittabọhng. Tte Ibinọkpaabyi ọsọ-ọ ade mach'Ephraim ọmaana Manasẹ.” Mẹ wọ, osi Ephraim ode odedennọng ọnang Manasẹ. ");
INSERT INTO mfo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Mẹ wọ e, Jekọb on-oben Josẹph bi, “Ebowu chaam em-efor, yina, Ibinọkpaabyi ówobha ttara bọng, obiro ótzim bọng ọkpa nnam k'irerek s'abatte. ");
INSERT INTO mfo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Onode kọ, kaam nnang-ọ irerek nnuma s'egbegbeho, s'iwa kaam ndim ọkkangkkaang kwaam, ọmaana oyuk kwaam mbọkha anọng p'Amọr nna.” ");
INSERT INTO mfo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Iwa Jekọb oyeri va pẹ, oben bi, “Bọng dobha ibe rani, ifha mfha mgbaak bọng eden ch'akpen pabọng áde, k'ogbe ororo. ");
INSERT INTO mfo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Bọng va pa Jekọb, bọng dobha ma, ayonga itzọhng, bọng yonga itzọhng anang kaam atte kwabọng Jekọb, kw'obiro okpena Israẹl. ");
INSERT INTO mfo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Reubẹn, kọ wọ ade ocheden-nwa kwaam, abira ade ẹfa chaam, kọ wọ ade ẹkhọhkha ch'ejinọng chaam, abira ade ọnọng kwa kaam ndim nkkaara ẹmma. ");
INSERT INTO mfo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Kọ áde mach'asi p'abobh-obobh, kọ ojibhada dọk kàre, da kọ atzam ọtta, arẹkhi eyima ch'atte, ayima ọkkọra-kwanọng kwẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeọn ọmaana Lẹvi asi ẹmmaana dani, akkangkkaang pabẹ ade egbongkpo py'ọgbaan. ");
INSERT INTO mfo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Tte kaam nningi ẹkhaan chabẹ ndọni, tte kaam nningi wani k'ottem kw'ewobha chabẹ nde, okhuri bi, bẹ akk'ittemdọkhiji sabẹ atzima afhu anọng haabhada. Bẹ abira am-asi abhaam ọgbaan, abọkha pyẹ aphyakhi mmo mach'ọdaakhi bẹ. ");
INSERT INTO mfo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Opyibh-opyibh ọnang ittemdọkhiji sabẹ, ottem-gọma otzim bẹ ofhu anọng ẹgagaangi. Opyibh-opyibh ọnang ottem-gọma kwabẹ, kw'otzim bẹ osi ọgbaan. Kaam ńsi va pa va aningi k'ibẹ rani arukhi k'ẹkhọma cha Jekọb. Mbiri ńsi bẹ an-akhọmikha aruk, makhọra Israẹl. ");
INSERT INTO mfo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Onode kọ Juda, votte pọ ánang-ọ ikpokpobha. Attattaanga-nọng pọ ábira awobha irekh-irek kwọ, votte pọ biphyir áhakha nho anang-ọ. ");
INSERT INTO mfo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Kọ Juda, nnwa kwaam, ade okye-nwa; kw'ofhu etzen ochi, ofona ọbhana k'ibe s'ofon okwu, mach'okye-dim, kw'oyim ọkpẹ-ọkpẹ, mach'okye-kwa, ọnọng kw'ofha ogbikh-ọ kode. ");
INSERT INTO mfo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ọnọng kw'ọfha ọtzọkha ẹfa ka mbọhk s'ẹkhọma cha Juda kode e, ẹfa échina ororo ewobha ka mbọhk sa va pa va pa Juda, matzẹmaa opyiri k'ogbe kw'idibhon ichen-ẹ ndumma, ngọma biphyir awobha irekh-irek kwẹ. ");
INSERT INTO mfo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Kẹ ọgbana ẹnyanyaang chẹ k'echi cha grep, ọgbana nnwa kw'ọnyanyaang-kwakwẹ k'echibọhnga ch'ẹdaakh-ẹ. Kẹ ọ́khaama atzuk matzẹmaa on-otzima bẹ ogbobhi anọhma-baba pẹ, otzima asi-khora pa grep ogbobhi ọbara fẹ. ");
INSERT INTO mfo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Kẹ ókhor chen okhuri atzuk haabha p'ọgwo, aha pẹ áwur ayong-oyongi okhuri abasi haabha p'ogwo. ");
INSERT INTO mfo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zẹbulun ósi obhon kwẹ k'ẹraangakha, ẹkha ch'éde ibe s'anzurikkaang am-attima akwokha ọnwọhng. Enem chẹ étzima maa, etzuma k'okhubha kwa Sidọn. ");
INSERT INTO mfo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isaaka ode ẹnyanyaang ch'ẹkhaam ẹfa, ch'eyim k'ottem kw'avukwuri. ");
INSERT INTO mfo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Mada ore odem kw'iwọhngkwokhabe sẹ ijibhi, omaana odem kw'irerek sẹ ibiri ijibh ewobha, ọ́hakha ẹbabaang chẹ ọtzọkha ẹtzọhkha, obiro ókhera bi, osi ọtzọhm f'ihem mach'obira. ");
INSERT INTO mfo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan ọ́nang anọng pẹ eponga-ttọhna ẹkkakka, mach'efonamma dani ch'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan ójora macha jọhk ch'ewobh k'eden ọkhaan-ọkhaan, mach'ọfhọfhọbhi kw'oyim k'eden, mach'ọfhọfhọbhi kw'okhimi ẹnyanyaang k'abhokhọkhọri, ch'esi ọyaar-ẹnyanyaang ogina otto nnama-nnam. ");
INSERT INTO mfo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“O Ọvaar Ibinọkpaabyi, kaam nwobh ndik ẹnaanga chọ. ");
INSERT INTO mfo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Ẹkhaan ch'ariribha erima Gad abẹ, yina, kẹ ómuma bẹ ekpo k'abhokhọkhọri da bẹ arọbh mkpaana-kpaana. ");
INSERT INTO mfo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Ashẹr ọ́khaam ọchattọhk ọkkakka f'ọdaam-ọdaam, kẹ ósi ọchattọhk ọkkakka f'ọbaana bi, bẹ anang ọvaarnọng ochi. ");
INSERT INTO mfo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naphtali ode mach'ojibh-kwa, kw'oreng ka for sẹ, ojibh-kwa, kw'ọmaani va p'ajibh-ojibh. ");
INSERT INTO mfo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Josẹph ode mach'echi cha grep ch'ebe ẹbaanga ekhekha, va pẹ ade mach'abọhnga p'anyaami avura k'egbegbeho. ");
INSERT INTO mfo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Atta-ayuk átzima idọdọkhi arim-ẹ abẹ, bẹ am-arim-ẹ abẹ ttara ittattaanga s'ideden. ");
INSERT INTO mfo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Yina, kọ akhema bẹ achina ororo, okhuri da kọ abọk oyuk kwọ, m'ejinọng-ejinọng. Ofona k'ẹfa ch'Ibinọkpaabyi kw'Ẹfa biphyir, kwa Jekọb okpobh, osi mbọhk sọ ngaang-ọgaangi. Okkeri-arukhimaan kw'ode Ẹtzakpa ch'Israẹl, ");
INSERT INTO mfo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","kw'ode Ibinọkpaabyi kw'atte okpobh kw'ọkkaan-ọ, ode Ibinọkpaabyi kw'Ẹfa biphyir kw'ọdọ-ọ ttara ẹdaa ch'ẹrọng ẹnangi, ttara ẹdaa ch'asi p'awobha k'irerek ẹtzaanga, ttara ẹdaa ch'ọmaan ọmaana abasi k'ọhaabh. ");
INSERT INTO mfo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ojibhada kw'atzọk k'atte kwọ, ode ojibhada kw'ofon ka mgbegbeho s'iwa kẹ-khẹ, Ọyọhnga idik ọkkakka s'ifon ka mgbegbeho ndamsẹ. Tte Josẹph ọtzọkha ojibhada nwa biphyir ọkhaama, tte kẹ ode oho kwa bẹ akk'atzekha k'ottem kwa votte pẹ. ");
INSERT INTO mfo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Bẹnjamin ode mach'etzen ch'ẹkkaam-ọkkaam, ch'echin ororo echi ayok k'ekpebha, ebire ekkema ọgbọm f'echi k'ẹchọhkha.” ");
INSERT INTO mfo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Anọng mba biphyir bọ iwa asi mfonamma jobh obhiri mfa s'Israẹl. Ma wọ ode idik s'iwa otte ọgbaakhi k'ogbe kw'osi bẹ ittabọhng. Wa osi ọnọng-ọnọng ittabọhng sẹ s'ibaan-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Mẹ wọ, ọn-ọtzọhn bẹ bi, “Ebowu chaam em-efor cha mpe ndor abitta e. Bọng nọhng-m kẹ da abitta paam anọhng, k'ọmma kw'itzakpa kw'owobh k'owoni kw'Ẹphrọn kw'ofon Het. ");
INSERT INTO mfo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","K'ọmma kw'itzakpa kw'owobh ka Makpẹla, ọbaanga Mamrẹ k'irek sa Kenaan, kw'iwa Abraham odebhi ttara k'owoni ka mbọhk s'Ẹphrọn kw'ofon Het, otzima osi inọhng-anọng. ");
INSERT INTO mfo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Mẹ wọ kw'iwa bẹ anọhng Abraham, ttara kwanọng kwẹ, Sara. M'ibe nna rani rọ s'iwa bẹ abira anọhng Isaak, ttara kwanọng kwẹ, Rẹbẹka. Mẹ wọ kw'iwa kaam mbiri nnọhnga Lea. ");
INSERT INTO mfo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Wa Abraham odebhi owoni nwa, ọmaana ọmma kw'itzakpa kw'owobh mẹ, ka mbọhk s'anọng pa Het.” ");
INSERT INTO mfo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Mada Jekọb okk'va pẹ ndọhna ọnanga biphyir, oyebh mmo sẹ ọnana k'ebin, ope otzor anọng pẹ. ");
INSERT INTO mfo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Josẹph otto ọkpẹkhi obukhi kw'otte, obhom obiro ọbaakh-ẹ. ");
INSERT INTO mfo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Mẹ wọ, Josẹph ọtzọhn akkeri-akhọkhọma p'atzọhmnọng pẹ bi, bẹ atzini obukhi kw'otte Jekọb atza aye, bẹ abira akker-ẹ ifha oningi ochu. ");
INSERT INTO mfo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Wa bẹ ayẹ-ẹ k'iwu arọbh afa biphyir mach'ẹmmaana ch'apfura oyeye ede k'Ijip. Wa anọng p'Ijip awobh ka nkwu-osisi k'iwu arọbh attaan obhiri jobh. ");
INSERT INTO mfo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Mada iwu nna sa nkwu-osisi ikk'ittonga, Josẹph oben akhaan-nọng pa Phero bi, “Idikha kaam nkk'ọphyaam ndọkha ka bọng k'itzitzikha, bọng kkaan-m agbaak Phero atzim anang-m bi, ");
INSERT INTO mfo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","wa otte kwaam osi-m ndọkha ọnwọhngi da oben-m bi, ‘Ebowu chaam em-efor, mpe, rọhng atza anọhng-m k'epekhubh cha ndumi k'ẹkhọma cha Kenaan nnang for saam.’ Mẹ wọ, tte nda nnọhnga otte kwaam, nkk'ẹ nnọhnga, kaam ńkhun-okhuna e.” ");
INSERT INTO mfo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Mẹ wọ, Phero oben-ẹ bi, “Kọ rọhng atza anọhnga atte, atzor k'ọnwọhngi kw'iwa atte ọkk'ọsa atzọkha.” ");
INSERT INTO mfo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Mando kwa Josẹph ofon bi, ọtza ọnọhnga otte. Wa akhaan-nọng pa Phero biphyir, ọmaana adedennọng p'ọvaar-dimpa kwa Phero, ọmaana adedennọng p'irek s'Ijip biphyir, ");
INSERT INTO mfo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","akwu attara k'ẹhọhmmọr cha Josẹph biphyir, ọmaana votte pẹ, ttara anọng p'ẹhọhmmọr ch'otte Jekọb, atzọni Josẹph abẹ. Wa va bẹ-bẹ, ọmaana etzirakpo bọ an-arikhi ka Goshẹn. ");
INSERT INTO mfo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Wa akpaar p'ideden pa nnyanyaang mindọr, ọmaana ayaari-nnyanyaang abira atzọn-ẹ abẹ. Wa ode ẹkhaan ch'ẹhaabh-ọhaabh. ");
INSERT INTO mfo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Mada bẹ apyiri k'ibe sa bẹ am-awobha akhaani abarli-mọma k'Atad, ka Jọrdan okhubha, bẹ abhom abomọng p'adọkhi bẹ ọdọkhi k'ẹrọng. M'ibe nna rani rọ s'iwa Josẹph owobh ka nkwu-osisi s'obo kw'otte k'iwu izenamfa. ");
INSERT INTO mfo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Wa anọng pa Kenaan p'arukhi m'ibe nna sa bẹ am-akhaani abarli-mọma k'Atad, p'are obo kwa Josẹph osi kw'otte, an-ayeri ibe nnuma s'iwobh k'okhubha kwa Jọrdan, Abẹl-Mizrayim, aben bi, “Anọng p'Ijip awobh ka nkwu-osisi s'obo!” ");
INSERT INTO mfo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Mẹ wọ, wa va pa Jekọb asi mach'otte okk'bẹ ọtzọhna. ");
INSERT INTO mfo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Iwa va pẹ atzini obukhi kw'otte achina k'irek sa Kenaan, atza anọhnga k'ọmma kw'itzakpa kw'owobh ka Makpẹla, ọbaanga Mamrẹ. Wa Abraham ọkk'ọmma nwa kw'itzakpa odebha ttara owoni kw'owobh mẹ, ka mbọhk s'Ẹphrọn kw'ofon Het, otzima osi inọhng-anọng. ");
INSERT INTO mfo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Mada Josẹph okk'otte ọnọhnga, kẹ ọmaana votte pẹ, ttara anọng p'akhubhi bẹ obo biphyir, akpa nnam abhana k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Mada bẹ akk'obo akhuna, votte pa Josẹph atzin bi, otte kwabẹ k'akpen dọk kode. Bẹ an-abọbh for sabẹ bi, “Idikha Josẹph on-obe mayina ochibhi bi otzukha itzama kpenamkpen sa mọkk'ẹ ọsa khi?” ");
INSERT INTO mfo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Mẹ wọ, bẹ atzọhm ẹkkaabha anang Josẹph bi, “Wa atte ọnangi man ndọhna yina on-ope e: ");
INSERT INTO mfo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Wa oben bi, ‘Bọng gbaak Josẹph bi, kaam mbeni bi, tte obina ọnang bọng k'itzama kpenamkpen sa bọng akk'ẹ asa.’ Mẹ wọ, mokhukh-ọ okhukhi bi, tte obina ọnang ottotto kw'atzọhmnọng p'Ibinọkpaabyi kw'iwa atte kwọ okpobh.” Mada ẹkkaabha nda epyiri Josẹph k'itzọhng, obhom. ");
INSERT INTO mfo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Mẹ wọ, votte afona atza akhebh-ẹ, atto abangi m'irerek abhom amọng m'itzitzikha sẹ, aben bi, “Maman ode abira pọ e.” ");
INSERT INTO mfo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yina, Josẹph oben bẹ bi, “Ojora oningi bọng osi. Kaam wọ nde Ibinọkpaabyi o? ");
INSERT INTO mfo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Wa bọng achibhi bi, bọng asi kaam itzama. Yina, wa Ibinọkpaabyi otzim ochibhi ọkkọkka otte odik nwa ọbọhk bi, kwẹ ode, ifha ọkkaana akpen p'anọng haabhada, macha kwẹ ode ma. ");
INSERT INTO mfo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Mẹ wọ, ojora oningi bọng osi. Kaam ńkkeri bọng okkeri ttara va pa bọng.” Josẹph ochina ororo ọnang votte pẹ ottembara, obiro ọgbaak bẹ attem-dinitzim. ");
INSERT INTO mfo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Wa Josẹph ọmaana ẹhọhmmọr ch'otte biphyir achina ororo aruk k'Ijip. Wa Josẹph orukhi cho arọbh azen obhiri jobh, ");
INSERT INTO mfo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","matzẹmaa ore va pa va p'Ephraim. Wa Josẹph obiro otzin bi, va p'afon ka ndaak sa Makir kw'ode nnwa kwa Manasẹ, abira ade va pẹ. ");
INSERT INTO mfo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Iwa Josẹph ọgbaak votte pẹ bi, “Kaam ebowu chaam em-efor e, yina, mpe, Ibinọkpaabyi óhok echekhi chẹ ohok bi, otzima bọng obina m'irerek nna, ọtza ọnang bọng irerek s'iwa ọnwọhngi bi, ọnang Abraham, ọmaana Isaak, ttara Jekọb.” ");
INSERT INTO mfo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Mẹ wọ, Josẹph osi votte pẹ p'ade va p'Israẹl atzọkha ọnwọhngi k'itzitzikha sẹ, aben bi, “K'odik ọkkọkka, Ibinọkpaabyi ọ́nang bọng ẹkkaana ọnang, bọng akhaambi atzini akhọbhi paam m'irek nna atzima afona.” ");
INSERT INTO mfo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Mẹ wọ e, wa Josẹph ope da ode cho arọbh azen obhiri jobh. Mada anọng akk'obukhi kwẹ aya, bẹ atzin-ẹ akhe k'Ẹkkọhbhi k'Ijip.");
INSERT INTO mfo_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ma wọ ode che pa va p'ijinọng p'Israẹl, kw'obiro okpena Jekọb, p'iwa achin k'Ijip, ọnọng-ọnọng ttara ẹhọhmmọr chẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Wa bẹ ade: Reubẹn, ọmaana Simeọn, ọmaana Lẹvi, ọmaana Juda, ");
INSERT INTO mfo_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ọmaana Isaaka, ọmaana Zẹbulun, ọmaana Bẹnjamin, ");
INSERT INTO mfo_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ọmaana Dan, ọmaana Naphtali, ọmaana Gad, ttara Ashẹr. ");
INSERT INTO mfo_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Josẹph kẹ wa okkekkeni oruk k'Ijip. Biphyir-phyir wa efonamma cha Jekọb ede, anọng arọbh attaan obhiri jobh p'iwa otzim ochina k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Wa Josẹph ọmaana efonamma chẹ biphyir, ọmaana ọgbọ nwa biphyir ape. ");
INSERT INTO mfo_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Yina, efonamma cha Jekọb ẹn-ẹbhakhi ebhon ayok maa, ch'ẹhaabh, ebire ekwu ẹbar, ẹnyaami maa, efu irek nnuma. ");
INSERT INTO mfo_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Wa ọvaarnọng ọbhakwẹ kw'oni Josẹph orong on-okwu ọdabh Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Wa obeni anọng pẹ bi, “Bọng kker o! Anọng mba p'Israẹl akk'ahaabha kpọng, abira akhaama ẹfa ayọhnga man. ");
INSERT INTO mfo_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Bọng kwu motzima ekkoji ọkwọbha bẹ ọhaabh mva, oni mando ode, egbong etto ma, bẹ attara attattaanga-nọng paman arima man abẹ, ifha bẹ arọbh aji irek nna.” ");
INSERT INTO mfo_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Mẹ wọ e, anọng p'Ijip arọbha akker-atzọhmnọng p'afon Ijip, bẹ anang ebhonmọr ch'Israẹl ọtzọhm f'ihem bi, bẹ asi. Anọng p'Israẹl asi ideden-mon sa Pitọm, ọmaana Rameses mach'ọkhaanga-họhm anang Phero. ");
INSERT INTO mfo_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Yina, odem nwa kw'anọng p'Ijip ado anọng p'Israẹl ihem anang, mando kw'anọng p'Israẹl areng ahaabh, abira ado anyaami maa, ojora ọnwa anọng p'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Anọng p'Ijip an-anang anọng p'Israẹl ọtzọhm k'ihem s'ideden. ");
INSERT INTO mfo_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Bẹ an-asi akpen abenga anọng p'Israẹl, okhuri ọtzọhm gaang-angaang f'idọdọhbh ọbhabhakhi ọmaana f'atza ọbabanga, ttara owoni-tzọhm kpenamkpen. Chibhi da anọng p'Israẹl asi itzọhm gaang-agaang anang bẹ, anọng p'Ijip nkwu-osisi kakhaam ttara bẹ. ");
INSERT INTO mfo_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mẹ wọ, ọvaarnọng kw'Ijip oben panọng p'am-akkeri aHiburu-panọng ọmaan p'akpen Shiphra, ọmaana Pua bi, ");
INSERT INTO mfo_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Mada bọng am-akkeri aHiburu-panọng ọmaan, bọng dọkha ogbe akkeri k'ọmaanpa, idikha nnwa ode ojinọng, bọng fhẹ-ẹ. Yina, idikha ode kwanọng, tte kẹ oruk akpen.” ");
INSERT INTO mfo_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Yina, da panọng p'am-akker-anọng ọmaan akhaam ojora f'Ibinọkpaabyi, bẹ ndọhna s'ọvaarnọng kw'Ijip ọnangi bẹ kahokhi. Bẹ atte va p'ijinọng ọbọhk, aruk akpen. ");
INSERT INTO mfo_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Mẹ wọ, ọvaarnọng kw'Ijip oyeri akkeri-panọng-ọmaan mba, ọbọbh bẹ bi, “Okhuri yan kwa bọng asi odik dema nwa? Mbọng vọ osi bọng atte va p'ijinọng ọbọhk bẹ aruk akpen?” ");
INSERT INTO mfo_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Akkeri-panọng-ọmaan mba abhina Phero bi, “AHiburu-panọng macha panọng p'Ijip kade. Bẹ akhaam ettem ch'ọmaan. Bẹ am-amaan k'ọmọmmọm, yina akkeri-panọng-ọmaan an-apyiri.” ");
INSERT INTO mfo_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Mẹ wọ, Ibinọpkaabyi on-osi ọphyaam ọnang akkeri-panọng-ọmaan mba, anọng p'Israẹl achina ororo ahaabh, bẹ abira akhaama ẹfa. ");
INSERT INTO mfo_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ibinọkpaabyi ọn-ọnang akkeri-panọng-ọmaan mba nhọhmmọr sabẹ ọkhaam, okhuri da bẹ akhaam ojora f'Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Mẹ wọ e, Phero ọnang anọng pẹ biphyir ẹfa bi, “Bọng dọkha nnwa kw'ijinọng kpenamkpen kw'oHiburu-kwanọng ọ́maan, abhari k'ọraanga kwa Nile, yina, bọng tte nnwa kw'ikwanọng ọbọhk oruk akpen.” ");
INSERT INTO mfo_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Wa ojinọng wani kw'efona cha Lẹvi, ọtza ọtzọkha kwanọng kw'efona cha Lẹvi k'ọbada. ");
INSERT INTO mfo_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Wa kwanọng nwa otzima ibhọr, ọmaan ojinọng. Mada ore bi, nnwa nwa ojibh-ojibh, odubh-ẹ k'aphe attaan. ");
INSERT INTO mfo_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Mada ọnẹ-ẹ dọk ofha odubha, ọtzọkha nnwa nwa okhe k'ikhiriba s'otzim ettimma osi. Otzima ẹbaanttim ọkpa aphaangi p'ikhiriba nna. Ọtzọkha ikhiriba nna, ttara nnwa k'ẹtzaanga, ọnana k'araraari p'ameni k'asi, p'awobh k'ẹraangakha ch'ọraanga kwa Nile. ");
INSERT INTO mfo_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ọgbaanọkka kw'ikwanọng kwa nnwa nwa ọtza ọpaangi obe, ifha ore ọttọhk f'osi nnwa nwa. ");
INSERT INTO mfo_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Wa nnwa kwa Phero kw'ikwanọng otzima aminava p'ade atzọhmnọng pẹ ọtza bi, otza ogbobha asi k'ọraanga kwa Nile. Mada aminava mba am-arenga m'ẹraangakha, nnwa kwa Phero on-ore ikhiriba k'ottem kw'araraari p'ameni k'ẹraangakha, ọtzọhm ọtzọhmnọng wani kwẹ bi, ọtza ọtzọkha sẹ otzima okwu. ");
INSERT INTO mfo_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Mada ogwong sẹ, ore nnwa k'ẹtzaanga kw'om-obhom ẹmọng. Ọkhaama nkwu-osisi ọmaan-ẹ. Oben bi, “Nnwa nwa ofha ode oHiburu-nwa wani.” ");
INSERT INTO mfo_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Mẹ wọ, ọgbaanọkka kwa nnwa nwa ọbọbh nnwa kwa Phero kw'ikwanọng bi, “Na mfha nda nyeri oHiburu-kwanọng wani, kw'ọfha ọrọk nnwa nwa ọnang-ọ o?” ");
INSERT INTO mfo_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Nnwa kwa Phero oben ọgbaanọkka kwa nnwa nwa bi, “Ojibhi kẹ, rọhng!” Mẹ wọ, otza otzima ọkka kwa nnwa nwa okwu. ");
INSERT INTO mfo_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Nnwa kwa Phero oben ọkka kwa nnwa nwa bi, “Kọ tzọkha nnwa nwa arọk anang-m. Kaam ńnang-ọ agbukha k'ọtzọhm fọ.” Mẹ wọ, ọkka kwa nnwa nwa ọtzọkh-ẹ ọrọk. ");
INSERT INTO mfo_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","K'ogbe kwa nnwa nwa ọkk'ọn-ọbara, ọtzọkh-ẹ ochena nnwa kwa Phero kw'on-ode ọkka kwa nnwa nwa. Ọkpẹ-ẹ Mosẹs, oben bi, “Nwong nnwa nwa k'asi.” ");
INSERT INTO mfo_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Iwa ewu dani, k'ogbe kw'iwa Mosẹs ọkk'ọn-ọbara, wa ofon otza odibh anọng pẹ p'Israẹl. Ore ọtzọhm gaang-agaang f'ihem f'anọng pẹ am-asi, obiro ore da ojinọng wani kw'ofon Ijip om-ottum oHiburu-jinọng, kw'ode obhon-nọng kwa kẹ Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mada Mosẹs ọbhakhi okkeri, ọnọng kore, ofhu ojinọng nwa kw'ofon Ijip, ọtzọkha obukhi kwẹ ọnọhnga k'oyeyeng. ");
INSERT INTO mfo_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","K'ewu ch'ejem mẹ, Mosẹs on-oyin k'iyaan, otza ore aHiburu-jinọng afa p'am-arima erima, ọbọbh oyok kw'aponga apyibhi bi, “Areng mbọng afẹ am-attum oyokh-oyok o?” ");
INSERT INTO mfo_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ojinọng nwa obhin-ẹ bi, “Anyi wọ ọsọ-ọ oho ọmaana ọttọhn-aponga kwaman o? Am-asi achibhi bi abira afhu-m mach'afhu oJipnọng o?” Mẹ wọ, ojora ọnwa Mosẹs, on-ochibhi bi, “K'odik-ọkka odik nwa ọkk'ọjaakh e.” ");
INSERT INTO mfo_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Mada Phero ọbhaang odik nwa, oror nden s'otzima ofhu Mosẹs. Ofona mẹ, Mosẹs ọrọbh ka Phero k'itzitzikha otza oruk ka Midiyan, otza owobha ẹwọr ọbaanga esipe dani. ");
INSERT INTO mfo_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Wa ọkhaam ọfọhnẹja wani kwa Midiyan, kw'iwa ọkhaam va p'ipanọng azenamfa. Ewu dani, aminava mba azenamfa akwu akhaabha asi k'esipe akhe k'ọgbaakha, ifha bẹ anang etzirakpo py'otte kwabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Yina, akker-arukhimaan bani akwu akhubh aminava mba, mẹ wọ, Mosẹs obina bi bik ọtza ọkkaana bẹ, ọnang etzirakpo pyabẹ asi. ");
INSERT INTO mfo_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Mada aminava mba abhan, otte kwabẹ kw'okpen Reuẹl ọbọbh bẹ bi, “Kaambi bọng akk'ẹbhar-ẹbhar akhuna. Ode yan mayina?” ");
INSERT INTO mfo_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Bẹ abhin-ẹ bi, “Ọnọng wani kw'ofon Ijip wọ ọkkaan man ka mbọhk s'akker-arukhimaan, obiro ọkkaana ọnang etzirakpo pyaman asi.” ");
INSERT INTO mfo_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Reuẹl ọbọbh aminava pẹ bi, “Bọng asi yan afona ajẹ ẹ? Bọng nọhng atza ayer-ẹ okwu ochi ọttọhk.” ");
INSERT INTO mfo_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mẹ wọ, Mosẹs okhera bi, okwu oruk k'ọhọhm kwa Reuẹl. Wa Reuẹl okwu ọtzọkha ominanwa wani kwẹ kw'okpen Zipọra, ọnang Mosẹs k'ọbada. ");
INSERT INTO mfo_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zipọra ọmaan Mosẹs nnwa kw'ijinọng, Mosẹs ọkpẹ-ẹ Gẹrshọm, oben bi, “Kaam nkk'okhekhen-nọng nna nda m'okhekhen-mon nwa.” ");
INSERT INTO mfo_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","M'ogbe-bhirada nwuma, ọvaarnọng kw'Ijip okwu ope. Anọng p'Israẹl abhom ẹmọng ch'ẹkkaana anang Ibinọkpaabyi, okhuri ebira cha bẹ awobh k'Ijip. Ọvaar Ibinọkpaabyi ọbhaanga ẹmọng chabẹ, cha bẹ abhomi k'ihem. ");
INSERT INTO mfo_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Wa Ibinọkpaabyi ọbhaanga ẹmọng chabẹ, obiro ojima echekhi ch'ọkhaam ttara Abraham mọgbakha Isaak, ọmaana Jekọb. ");
INSERT INTO mfo_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Wa Ibinọkpaabyi ore bi, anọng p'Israẹl awobh k'ihem, on-obiro ọkpakh-ẹ bi, ọkkaana bẹ. ");
INSERT INTO mfo_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Wa ewu dani, Mosẹs om-okkeri arukhimaan p'otte kwa kwanọng kwẹ kw'okpen Jẹtro. Jẹtro wa ode ọfọhnẹja k'ẹkhọma cha Midiyan. Mosẹs otzima arukhimaan mba eden orenga m'ibe s'anọng an-arukhi maa, okwu opyiri k'egbegbeho cha Horẹb ch'ede egbegbeho ch'Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Mẹ wọ kw'orenga-eden kw'Ọvaar Ibinọkpaabyi oreng k'akpondaak p'awọm k'echi, oyin Mosẹs abẹ. Wa Mosẹs odo okkeri ore bi chibhi da ekpon ẹm-ẹwọm, echi nda kẹkwọmi. ");
INSERT INTO mfo_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Mosẹs oben k'ettem chẹ bi, “Kaam ngaambi nnenga mbaanga kẹ, ifha nne ọttọhk f'osi yina ekpon ẹm-ẹwọma m'echi nda, yina, chẹ kẹkwọmi.” ");
INSERT INTO mfo_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mada Ọvaar Ibinọkpaabyi on-ore bi Mosẹs okk'orenga ọbaanga kẹ, on-oyer-ẹ k'ottem kw'echi nda bi, “Mosẹs! Mosẹs!” Mosẹs oben bi, “Itta, kkeri kaam ma e.” ");
INSERT INTO mfo_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ibinọkpaabyi oben-ẹ bi, “Kọ dọk kàrenga abaanga ka, wọra ekpo pya mmo pyọ, kkeri ibe nna s'abe mẹ ide irerek s'awurada.” ");
INSERT INTO mfo_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Obiro oben-ẹ bi, “Kaam wọ nde Ibinọkpaabyi kw'abatte Abraham, ọmaana kw'Isaak, ttara kwa Jekọb.” Mẹ wọ, Mosẹs on-ochubha itzitzikha sẹ, okhuri ojora f'on-orori bi, ore Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Mẹ wọ, Ọvaar Ibinọkpaabyi oben bi, “K'odik ọkkakka, kaam nkk'ọmmamma kw'anọng paam awobh k'Ijip nna e. Kaam nkk'ẹmọng ch'ẹkkaana mmaanga, cha bẹ abhomi, okhuri ihem s'akker-atzọhmnọng am-anang bẹ. Kaam nnong ihem sabẹ am-are kẹ. ");
INSERT INTO mfo_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Mẹ wọ, nkk'nkwa bi, nkwu nkkaana, nnọbha bẹ ka mbọhk s'anọng p'Ijip, mbiri nnọbha bẹ m'irek nnuma, ndima bẹ nchina k'irerek s'ijibh-ojibh ibiri iwoni-owoni. Irerek ọkkakka s'abasi ọmaana akhọkhọnana ahaabh-ọhaabh, obhon kw'abaKenaan, ọmaana abaHet, ọmaana ab'Amọr, ọmaana abaPẹriz, ọmaana abaHiv, ttara abaJẹbus. ");
INSERT INTO mfo_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","K'odik ọkkakka, kaam nkk'ẹmọng ch'anọng p'Israẹl abhomi mmaanga e, kaam nkk'ihem-dem s'anọng p'Ijip am-anang bẹ mbiri nna e. ");
INSERT INTO mfo_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Mẹ wọ, kọ rọhng, kaam nna ndọhm-ọ ka Phero bi, atza atzima anọng paam p'Israẹl abina k'Ijip.” ");
INSERT INTO mfo_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Yina, Mosẹs oben Ibinọkpaabyi bi, “Kaam nde macha bọng ọnọng bi, nyin Phero k'itzitzikha, mbiri ndima anọng p'Israẹl bẹ abina k'Ijip o?” ");
INSERT INTO mfo_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ibinọkpaabyi on-oben bi, “Kaam ńwobha ttar-ọ. Ma wọ óde ẹkhọhkha ọnang-ọ bi, kaam wọ ndọhm-ọ. Akk'anọng p'Israẹl atzima abina k'Ijip, bọng án-akpobha Ibinọkpaabyi m'egbegbekho nda.” ");
INSERT INTO mfo_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mẹ wọ, Mosẹs oben Ibinọkpaabyi bi “Idikha kaam nna nda k'anọng p'Israẹl, mgbaak bẹ bi, ‘Ibinọkpaabyi kw'abatte wọ ọtzọhm-m ka bọng e,’ bẹ an-abọbh-m bi, ‘Ibinọkpaabyi nwa okpen yan?’ Kaam mgbaak bẹ yan o?” ");
INSERT INTO mfo_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ibinọkpaabyi on-oben Mosẹs bi, “KAAM WỌ NDE NWUMA KWA NDE. Kọ gbaak anọng p'Israẹl bi: ‘KAAM WỌ NDE wọ ọtzọhm-m ka bọng.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ibinọkpaabyi obiro oben Mosẹs bi, “Kọ gbaak anọng p'Israẹl bi, Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'abatte Abraham, ọmaana Isaak, ọmaana Jekọb akpobh, wọ ọtzọhm-m ka bọng. Ma wọ ode che chaam, che ch'igbọ biphyir k'ororo iyer-m maa ogbe ode. ");
INSERT INTO mfo_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Kọ rọhng atza atzobha adeho p'Israẹl, aben bẹ bi, ‘Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'abatte Abraham, ọmaana kw'Isaak, ttara Jekọb akpobh, oyin-m abẹ oben bi, kaam nkk'ogbe ndọkha nkkeri, nne odem kwa bẹ asi bọng k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Kaam nkk'nchekhi bi, ńnọbha bọng k'ihem s'Ijip, ndima bọng nchina k'irerek ọkkakka s'abasi ọmaana akhọkhọnana ahaabh-ọhaabh s'abaKenaan, ọmaana abaHet, ọmaana abAmọr, ọmaana abaPẹriz, ọmaana abaHiv, ttara abaJẹbus.’ ");
INSERT INTO mfo_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Adeho mba p'Israẹl ayong-ọ itzọhng oyonga. Mẹ wọ, kọ ọmaana adeho p'Israẹl akhaambi achina k'ọvaarnọng kw'Ijip atza aben-ẹ bi, Ọvaar Ibinọpkaabyi, kw'ode Ibinọpkaabyi kw'abaHiburu okk'man abẹ ottema. Mẹ wọ, tte man ọbọhk mosi orenga kw'iwu ittaan mochina k'ibe s'anọng an-arukhi, ifha mosi njafọhni ọnang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwaman. ");
INSERT INTO mfo_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Yina, kaam nnong kẹ bi, ọvaarnọng kw'Ijip bọng ọbọhk kótte bọng afona, kw'oyongi bi ẹfa ch'ideden ẹkwẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Mẹ wọ, kaam ńdima ẹfa chaam nnang anọng p'Ijip ettuma, kaam ńsi idik kpenamkpen s'ipe anọng for k'ottem kwabẹ. K'ekponga-nnam, kẹ otte bọng ọbọhk otte, bọng afona. ");
INSERT INTO mfo_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Kaam mbiri ńsi anọng p'Ijip asi ọphyaam anang bọng, ifha mada bọng ábina orenga, bọng aningi mbọhk-mbọhk afon. ");
INSERT INTO mfo_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Kwanọng kpenamkpen ochina k'ojip-kwanọng kw'orukhi ọbaang-ẹ, ọmaana k'ojip-kwanọng kw'orukhi k'ọhọhm kwẹ, ọ́bọbh-ẹ agimma pa gol, ọmaana p'asilva, ttara ọbara fa for fa bọng áfhọra va pa bọng p'ijinọng ọmaana p'ipanọng. M'eden nda dọ cha bọng arenga achi anọng p'Ijip ọgbọm.” ");
INSERT INTO mfo_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mẹ wọ, Mosẹs obhina bi, “Kaam ńsi yan, idikha bẹ ani kaam k'odik-ọkka atzọk, bẹ itzọhng kabira ayonga anang-m, bẹ an-aben bi, Ọvaar Ibinọkpaabyi kọ abẹ koyini khi?” ");
INSERT INTO mfo_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Mẹ wọ, Ọvaar Ibinọkpaabyi ọbọbh-ẹ bi, “Mbọng vọ fa kọ atzim k'ọbọhk kwọ o?” Mosẹs obhina bi, “Ochikhura e.” ");
INSERT INTO mfo_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ọvaar Ibinọkpaabyi oben-ẹ bi, “Kọ bhari ochikhura nwuma k'irerek.” Mosẹs ọbhari chẹ k'irek, ochikhura nwa oreng jọhk, Mosẹs ọrọbh oji chẹ. ");
INSERT INTO mfo_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Mẹ wọ, Ọvaar Ibinọkpaabyi oben-ẹ bi, “Nemi ọbọhk kwọ abọkha jọhk nda k'ẹsara.” Mẹ wọ, Mosẹs onemi ọbọhk ọbọkha jọhk nda k'ẹsara, jọhk en-ebiri ẹbhakhi ochikhura k'ọbọhk kwẹ. ");
INSERT INTO mfo_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ọvaar Ibinọkpaabyi oben bi, “Si mando, ifha bẹ akhera bi, Ọvaar Ibinọkpaabyi kw'abatte Abraham, ọmaana Isaak, ttara Jekọb akpobh, ọkk'ọ abẹ oyina.” ");
INSERT INTO mfo_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Mẹ wọ e, Ọvaar Ibinọkpaabyi obiro oben bi, “Kọ khe ọbọhk kwọ k'ọphaangi kw'ittemmọma kw'ọnọhma-baba kwọ ẹtzaanga.” Mosẹs osi mando. Mada ọn-ọrọbh ọbọhk, ọbọhk on-ode okkim-okkima kw'owuri bi gwaang. ");
INSERT INTO mfo_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","“Kọ biri kpa nnam akhe ọbọhk kwọ k'ọphaangi kw'ittemmọma kw'ọnọhma-baba kwọ ẹtzaanga.” Mosẹs osi mando. Mada ọn-ọrọbh ọbọhk, ọbọhk on-obiro ọkpa nnam ode mach'ira okkekkeni ode. ");
INSERT INTO mfo_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Mẹ wọ, Ọvaar Ibinọkpaabyi oben bi, “Idikha anọng ani kọ itzọhng ayong, bẹ k'echeden-kọhkha kabira akhera, bẹ afha akhera k'ẹkhọhkha ch'ettong mfa. ");
INSERT INTO mfo_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Yina, idikha bẹ ani kọ itzọhng akher ayonga, bẹ ka ngọhkha nna mfa kabira akhera, kọ rọhng atza akhaabha asi k'ọraanga kwa Nile, akwu abyengi k'ogbin. Asi mba p'akhaabha k'ọraanga án-areng izi m'irerek.” ");
INSERT INTO mfo_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mosẹs oben Ọvaar Ibinọkpaabyi bi, “O Ọvaar Ibinọkpaabyi, akk'aronga bi, ttẹwọr k'ittẹwọr maa, apyiri mada am-agbaak ọtzọhmnọng kwọ atzim mba ma, kaam mgbagbaakha kimkpo. Kaam mgbagbaakha igaang-m ọgaangi, mbiri nyek atzim.” ");
INSERT INTO mfo_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ọvaar Ibinọkpaabyi on-oben-ẹ bi, “Anyi wọ ọnangi ọnọngẹya ẹmma ch'otzim ọgbaak atzim o? Anyi wọ osi ọnọngẹya ọkpa itzọhng ttara ẹmma? Anyi wọ osi ọnọngẹya ore iyaan, obiro ọsẹ-ẹ ọkpa chen o? Kaam Ọvaar Ibinọkpaabyi arang na a? ");
INSERT INTO mfo_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Mẹ wọ, kọ rọhng, kaam ńdaakh-ọ atzim ọtzaakhi, mbiri ḿkpebh-ọ atzim okpebhi p'agbaak.” ");
INSERT INTO mfo_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Yina, Mosẹs oben bi, “O Ọvaar Ibinọkpaabyi, tte mphyem-ọ bi, ira atzọhm ọnọng ọdọdọk.” ");
INSERT INTO mfo_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Mẹ wọ, ettem ebhem Ọvaar Ibinọkpaabyi, on-oben Mosẹs bi, “Agbaanakka Aarọn kw'ofon k'ẹnọmma cha Lẹvi owobh mẹ. Kaam nnong-ẹ bi ode ọnọng kw'okpo mgbagbaakha k'eden ọkkakka. Kẹ oreng k'eden okwuma bi okwu okhebh-ọ e, sa kẹ obiro owobha k'ottemdaamiji mada ọrọ-ọ. ");
INSERT INTO mfo_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Kọ gbaakh-ẹ atzim p'ọgbaak. Kaam ńdaakhi bọng anọng afa atzim ọtzaakhi, mbiri mbgaak bọng odem kwa bọng akhaambi asi. ");
INSERT INTO mfo_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Aarọn wọ ọ́gbaak anọng mba atzim k'eho chọ. Kẹ wọ óde mach'igbaakhi sọ, kọ abira ade mach'Ibinọkpaabyi anaang-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Yina, kọ tzọkha ochikhura kwọ atzima k'ọbọhk, ifha kọ afha atzima chẹ asi ngọhkha s'ipe anọng for.” ");
INSERT INTO mfo_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mẹ wọ, Mosẹs ọkpa nnam ka Jẹtro kw'ode otte kwa kwanọng kwẹ, oben-ẹ bi, “Tte mkpa nnam k'anọng paam k'Ijip, ifha nda nne s'ọnọng manda wani otzima orukhi kẹ.” Jẹtro oben bi, “Phyaa, do renga o.” ");
INSERT INTO mfo_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Wa Ọvaar Ibinọkpaabyi okk'Mosẹs obena ka Midiyan bi, “Kọ kpa nnam k'Ijip, kkeri anọng mba p'iwa abeni bi, afhọ-ọ, akk'apa e.” ");
INSERT INTO mfo_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Mando kwa Mosẹs ọtzọk kwanọng kwẹ, ọmaana va pẹ p'ijinọng ọnana bẹ k'ẹnyanyaang, obiro ọtzọkha ochikhura kw'Ibinọkpaabyi oben-ẹ bi, otzima k'ọbọhk, obina orenga ọkpa nnam k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Mada akpa nnam k'Ijip, kọ akhaambi ado for bi, asi ikkokkoni-dik nna biphyir sa nkk'ọ ẹfa nnanga bi, asi k'itzitzikha sa Phero. Yina, kaam ńsi Phero ọbar ettem, oningi anọng mba ọbọhk otte bẹ afona. ");
INSERT INTO mfo_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Mẹ wọ, ben Phero bi, ‘Ọvaar Ibinọkpaabyi obeni bi, Israẹl wọ ode ocheden-nwa kwaam kw'ijinọng. ");
INSERT INTO mfo_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Kaam mben-ọ bi, “Tte nnwa kwaam ọbọhk ofona otza okpobh-m.” Yina, kọ abhum bi attẹ-ẹ ọbọhk ofona. Mẹ wọ, kaam ḿfhu ocheden-nwa kwọ kw'ijinọng.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Wa Ọvaar Ibinọkpaabyi oyin Mosẹs abẹ k'ibe s'otzim anọng pẹ obhing, ọkham bi, ọfhẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Yina, Zipọra kw'ode kwanọng kwa Mosẹs ọtzọkha ọtza kw'ọjaabhi mach'imaana, osi nnwa kwẹ ọkpakkọrikkọ, ọtzọkha ẹkpakpa ch'ọkk'ọkpaara ọttọhmi Mosẹs ka mmokpatzọkhi, oben bi, “K'odik ọkkakka, oreng m'izi nna kọ an-ade odim kwaam.” ");
INSERT INTO mfo_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Mẹ wọ, Ọvaar Ibinọkpaabyi otte Mosẹs ọbọhk oruk akpen. M'ogbe nwa wọ kwa Zipora obeni bi, “Odim kwaam kw'oreng k'izi, okhuri ọkpakkọrikkọ.” ");
INSERT INTO mfo_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Wa Ọvaar Ibinọkpaabyi oben Aarọn bi, “Rọhng atza akhebha Mosẹs k'ibe s'anọng an-arukhi.” Mando kw'Aarọn ofon otza okhebha Mosẹs k'egbegbeho ch'Ibinọkpaabyi owobh, ọbaakh-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mẹ wọ, Mosẹs ọgbaak Aarọn odik kpenamkpen kw'Ọvaar Ibinọkpaabyi ọkk'ẹ ọgbaakha bi, ọgbaakh-ẹ. Wa obiro ọgbaakh-ẹ odik kpenamkpen kw'okhuri ngọhkha sa mpe ọnọng for s'Ọvaar Ibinọkpaabyi ọtzọhn-ẹ bi osi. ");
INSERT INTO mfo_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Wa Mosẹs ttara Aarọn atza ayeri adeden-nọng p'anọng p'Israẹl biphyir atzobha. ");
INSERT INTO mfo_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Wa Aarọn ọgbaak bẹ odik kpenamkpen kw'Ọvaar Ibinọkpaabyi okk'Mosẹs ọgbaakha, obiro osi ngọhkha nna k'itzitzikha s'anọng mba. ");
INSERT INTO mfo_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Wa anọng mba akhera. Mada anọng mba abhaang bi Ọvaar Ibinọkpaabyi okk'ihem-dema s'anọng p'Israẹl awobh ọra, ọmaana bi, om-ochibhi odik okhuri bẹ, bẹ achunga nho anang-ẹ ikpokpobha. ");
INSERT INTO mfo_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ayongi mẹ, Mosẹs ọmaana Aarọn atza akhebha Phero, aben bi, “Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'Israẹl, obeni bi, ‘Tte anọng paam ọbọhk afona, ifha bẹ atza asi ọdadaami kw'ikpokpobha k'ibe s'anọng an-arukhi, anang-m.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Mẹ wọ, Phero oben bi, “Anyi wọ ode Ọvaar Ibinọkpaabyi, kwa kaam nnọbh ka chen maa, ntte anọng p'Israẹl ọbọhk bẹ afona? Kaam Ọvaar Ibinọkpaabyi kinnong! Anọng p'Israẹl ọbọhk kíntte bẹ afona.” ");
INSERT INTO mfo_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Iwa Mosẹs ọmaana Aarọn, aben bi, “Ibinọkpaabyi kw'abaHiburu okk'man abẹ ottema. Mẹ wọ, tte mobina orenga kw'iwu ittaan mochina k'ibe s'anọng an-arukhi, ifha mọtza osi njafọhni ọnang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwaman. Oni mando ode, kẹ ọfha ọnang man ihem k'adem-k'adem, ayongi mẹ, ofha ofhu man ttara ọkkangkkaang.” ");
INSERT INTO mfo_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Yina, ọvaarnọng kw'Ijip ọn-ọbọbh Mosẹs ọmaana Aarọn bi, “Ode yan kwa bọng akwọbh anọng mba ọtzọhm fa bẹ am-asi o? Bọng kpa nnam k'itzọhm sabọng!” ");
INSERT INTO mfo_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Mẹ wọ, Phero oben bi, “Bọng kker e, anọng p'irek nna akk'an-ahaabha, yina, bọng am-akwọbha bẹ ọtzọhm osisi.” ");
INSERT INTO mfo_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","M'ewu nduma dani, Phero ọnang akker-atzọhmnọng ọmaana akkeri-itzọhm ẹfa bi: ");
INSERT INTO mfo_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Bọng anọng mba araraari-bukhi pa bẹ am-atzima abanga atza dọk kànang. Tte bẹ areng-mmo atza aror araraari-bukhi pa bẹ am-aztima abanga atza. ");
INSERT INTO mfo_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Yina, bọng si bẹ abanga ọtzabhik kwa bẹ am-akkekkeni abanga, bọng kàjekhi. Bẹ akpọhr-ọkpọhra e, kwẹ gwọ osi bẹ am-abhom bi, ‘Tte mofona, mọtza osi ẹjafọhni ọnang Ibinọkpaabyi kwaman.’ ");
INSERT INTO mfo_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Bọng si ọtzọhm mva fẹ ọgaang-ọgaangi ọnang ajinọng mba, ifha bẹ am-asi ọtzọhm, bẹ aningi ogbe akhaam kwa bẹ ayonga itzọhng k'ibhora manda rani.” ");
INSERT INTO mfo_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Mẹ wọ, akker-atzọhmnọng ọmaana akkeri-itzọhm p'Israẹl, afona atza agbaak anọng mba bi, “Ma wọ ode odik kwa Phero ọgbaakhi: ‘Kaam bọng araraaribukhi pa bẹ am-atzima abanga atza dọk kinnang. ");
INSERT INTO mfo_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Bọng nọhng atza aror araraari-bukhi, pa bẹ am-atzima abanga atza k'ibe sa bọng aroror, yina, ọtzọhm fabọng kòjekhi mebubuni.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Mẹ wọ, anọng mba an-akpaanga makhọra Ijip, aror araraari-bukhi pa bẹ atzima abanga atza. ");
INSERT INTO mfo_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Akker-atzọhmnọng mba achina ororo anyuni bẹ k'ẹfa, aben bi, “Bọng kyera ọtzọhm fabọng f'ewu, macha bọng am-akkekkeni asi, k'ogbe kwa bẹ am-anang bọng araraari-bukhi.” ");
INSERT INTO mfo_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Akker-atzọhmnọng pa Phero otzek, abọkha akkeri-itzọhm p'Israẹl attum ngwur, abira abọbh bẹ bi, “Okhuri yan kw'ọtzabhik kwa bọng abang ikhena ttara mayina, oni obhik kwa bọng am-akkekkeni abanga opyir o?” ");
INSERT INTO mfo_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Mẹ wọ, akkem-itzọhm p'Israẹl afona atza abhom akpẹkhi Phero, aben-ẹ bi, “Itta, okhuri yan kwa kọ am-asi atzọhmnọng pọ manda o? ");
INSERT INTO mfo_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Bẹ atzọhmnọng pọ araraari-bukhi pa bẹ am-atzima abanga atza dọk kanangi. Yina, bẹ am-aben man bi, ‘Bọng banga atza!’ Bẹ am-attum atzọhmnọng pọ, kaambi ode bi ottotto ode kw'anọng pọ.” ");
INSERT INTO mfo_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Phero obhina bẹ bi, “Ọkpọra e, bọng akpọr-ọkpọra e! Kwẹ wọ osi bọng am-aben bi, ‘Tte mofona, motza osi ẹjafọhni ọnang Ọvaar Ibinọkpaabyi.’ ");
INSERT INTO mfo_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Bọng kpa nnam k'ọtzọhm. Bẹ bọng araraari-bukhi pa bẹ am-atzima abanga atza kánang, yina, bọng akhaambi abanga ọtzabhik kwa bọng am-akkekkeni abanga.” ");
INSERT INTO mfo_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Akkeri-itzọhm p'Israẹl akwu atzin bi, odik wọ om-otto mẹ, da bẹ abeni bi, “Bọng ọtzabhik kwa bọng am-abanga kw'ewu kàkhaambi ajekhi.” ");
INSERT INTO mfo_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Mada bẹ abin ka Phero, bẹ are Mosẹs ọmaana Aarọn p'am-atzik bẹ, ");
INSERT INTO mfo_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","bẹ aben bi, “Tte Ọvaar Ibinọkpaabyi kw'ore bọng, ọkpaara aponga pabọng! Bọng akk'asa mopyibh k'itzitzikha sa Phero, ọmaana akhaan-nọng pẹ, bọng abira khe bẹ ọkkangkkaang k'ọbọhk bi, bẹ afhu man.” ");
INSERT INTO mfo_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mẹ wọ e, Mosẹs ọkpa nnam k'Ọvaar Ibinọkpaabyi, oben bi, “O Itta, okhuri yan kwa akhe anọng mba ka dama-dama o? Kwẹ wọ osi atzọhm-m o? ");
INSERT INTO mfo_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Tzọni k'ogbe kwa ndim che chọ nda mgbaak Phero atzim, ọkk'anọng mba ọkha ka dama-dama, kọ bẹ kabira akkaana mebubuni.” ");
INSERT INTO mfo_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Kọ án-are ọttọhk fa ńsi Phero, okhuri bi, ófona k'ẹfa chaam, kẹ ótte anọng paam ọbọhk, bẹ afona. Ófona k'ẹfa chaam, kẹ ọkhaam ma for sẹ ókhubh bẹ, k'ẹkhọma chẹ.” ");
INSERT INTO mfo_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ibinọkpaabyi oben Mosẹs bi, “Kaam wọ nde Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Wa kaam nyini Abraham, ọmaana Isaak, ttara Jekọb abẹ, mach'Ibinọkpaabyi kw'Ẹfa biphyir. Yina, kaam che chaam ch'ede Ọvaar Ibinọkpaabyi, kinjaakhi nnang bẹ. ");
INSERT INTO mfo_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Wa kaam mbiri nchekhi bi, nnang bẹ irerek sa Kenaan, nnuma s'iwa bẹ arukhi mach'akhekhennọng. ");
INSERT INTO mfo_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Kaam nkk'ẹmọng ch'anọng p'Israẹl abhomi k'ebira cha bẹ awobh k'Ijip mmaanga, kaam nkk'echekhi chaam mbiri njima. ");
INSERT INTO mfo_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Mẹ wọ, gbaak anọng p'Israẹl bi, ‘Kaam wọ nde Ọvaar Ibinọkpaabyi. Kaam wọ ńnọbha bọng k'ọyak kw'ihem s'anọng p'Ijip. Kaam ḿbiri nnọbha bọng k'ebira cha bẹ akhe bọng. Kaam ndima ẹfa chaam mmek bọng, ḿbiri ndima chẹ ńsi aponga adaam bọng. ");
INSERT INTO mfo_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Kaam ńdọkha bọng mach'anọng paam, ḿbiri nde Ibinọkpaabyi kwabọng. Órenga mẹ, bọng áronga bi, kaam wọ nde Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, kw'ọrọbh bọng k'ọyak kw'ihem s'anọng p'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Kaam ḿbiri ndima bọng ma mpyiri k'irerek nnuma, s'iwa nchekhi ttara ọmmakkakkari bi, nnang Abraham, ọmaana Isaak, ttara Jekọb. Kaam ńnang bọng irerek nnuma bi, in-ide sabọng. Kaam wọ nde Ọvaar Ibinọkpaabyi.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Wa Mosẹs ọtzọkha idik nna ọgbaak anọng p'Israẹl, yina, bẹ kẹ itzọhng kayong, okhuri akpen p'akk'bẹ abenga ọmaana ihem barambar sa bẹ awobh. ");
INSERT INTO mfo_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, ");
INSERT INTO mfo_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Rọhng atza agbaak Phero kw'ode ọvaarnọng kw'Ijip bi, tte otte anọng p'Israẹl ọbọhk bẹ abina aji ẹkhọma chẹ.” ");
INSERT INTO mfo_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Yina, Mosẹs ọbọbh Ọvaar Ibinọkpaabyi bi, “Idikha anọng p'Israẹl an-itzọhng ayong anang-m, Phero on-osi yan oyong-m itzọhng o, da kaam nyekhi atzim o?” ");
INSERT INTO mfo_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Wa Ọvaar Ibinọkpaabyi ọgbaak Mosẹs ọmaana Aarọn odik kw'okhuri anọng p'Israẹl ọmaana ọvaar Phero kw'Ijip, ọnang ẹfa bi, bẹ atzima anọng p'Israẹl abina aji Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ma wọ ode aho pa mfona sabẹ: Va p'ijinọng pa Reubẹn, kw'ode ocheden-nwa kw'ijinọng kwa Israẹl ade: Hanọk, ọmaana Palu, ọmaana Hẹzrọn, ttara Karmi. Ma wọ iwa ode efona cha Reubẹn. ");
INSERT INTO mfo_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Wa Simeọn obhoni va p'ijinọng pa ade: Jemuyẹl, ọmaana Jamin, ọmaana Ọhad, ọmaana Jakin, ọmaana Zoha, ttara Shaul, kw'ode nnwa kw'oKenaan-kwanọng ọmaani ọnang-ẹ, Ma wọ iwa ode efona cha Simeọn. ");
INSERT INTO mfo_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ma wọ ode che pa va p'ijinọng pa Lẹvi obhoni atzor ka ndori sabẹ; Gẹrshọn, ọmaana Kohat ttara Mẹrari. Biphyir-phyir wa Lẹvi orukhi cho arọbh azadani obhiri chi obhiri afa. ");
INSERT INTO mfo_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Wa va p'ijinọng pa Gẹrshọn obhoni ka nnọmma sabẹ ade: Libni ttara Shimeyi. ");
INSERT INTO mfo_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Wa va p'ijinọng pa Kohat obhoni ade: Amram, ọmaana Izha, ọmaana Hẹbrọn, ttara Uziyẹl. Biphyir-phyir wa Kohat orukhi cho arọbh azadani obhiri jobh obhiri attaan. ");
INSERT INTO mfo_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Wa Mẹrari obhon va p'ijinọng p'ade: Mali ọmaana Mushi. Ma wọ ode nnọmma sa Lẹvi atzor ka ndori sabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Wa Amram ọtzọk Jokẹbẹd kw'ode ọgbaanọkka kw'otte kwẹ, k'ọbada, kw'ọmaan-ẹ Aarọn ọmaana Mosẹs. Biphyir-phyir wa Amram orukhi cho arọbh azadani obhiri chi obhiri afa. ");
INSERT INTO mfo_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Wa Izha obhon va p'ijinọng p'ade: Kọra ọmaana Nẹphẹg, ttara Zikiri. ");
INSERT INTO mfo_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Wa Uziyẹl obhon va p'ijinọng p'ade: Mishayẹl, ọmaana Ẹlzaphan, ttara Sitri. ");
INSERT INTO mfo_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Wa Aarọn ọtzọk Ẹlisheba kw'ode ominanwa kw'Aminadab k'ọbada, kw'obiro ode ọgbaanọkka kwa Nashọn, ọmaan-ẹ Nadab ọmaana Abihu, ọmaana Ẹleyaza, ttara Itamar. ");
INSERT INTO mfo_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Va p'ijinọng pa Kọra ade Asir, ọmaana Ẹlkana, ttara Abiyasaph. Ma wọ iwa ode nnọmma sa Kọra. ");
INSERT INTO mfo_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Wa Ẹleyaza kw'Aarọn obhoni ọtzọk ominanwa kwa Putiyẹl k'ọbada, ọmaan-ẹ Phinẹhas. Ma wọ iwa ode aho pa nhọhmmọr sa Lẹvi, k'ẹnọmma-k'ẹnọmma. ");
INSERT INTO mfo_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aarọn nwa ttara Mosẹs bọ p'iwa Ọvaar Ibinọkpaabyi obeni bi, “Bọng dima anọng p'Israẹl abina aji Ijip, ka ngaan sabẹ.” ");
INSERT INTO mfo_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Bẹ anọng mba afa kw'ode Aarọn ọmaana Mosẹs bọ iwa agbaakhi ọvaar Phero kw'Ijip atzim, okhuri ebina ch'anọng p'Israẹl k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Mada Ọvaar Ibinọkpaabyi ọgbaakhi Mosẹs atzim k'Ijip, ");
INSERT INTO mfo_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","oben Mosẹs bi, “Kaam wọ nde Ọvaar Ibinọkpaabyi. Gbaak ọvaar Phero kw'Ijip idik nna biphyir sa mgbaakh-ọ.” ");
INSERT INTO mfo_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Yina, Mosẹs oben Ọvaar Ibinọkpaabyi bi, “Mada kaam nde ọnọng kw'oyekhi atzim, Phero on-osi yan oyong-m itzọhng o?” ");
INSERT INTO mfo_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Kker e, kaam nkk'ọ nsa bi, ade mach'Ibinọkpaabyi k'itzitzikha sa Phero e, agbaanakka Aarọn wọ óde ọsẹjaakhi kwọ. ");
INSERT INTO mfo_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Kọ gbaak agbaanakka Aarọn odik kpenamkpen kwa kaam mgbaakh-ọ, ifha kẹ ọgbaak Phero otte anọng p'Israẹl ọbọhk, bẹ bina k'ẹkhọma chẹ. ");
INSERT INTO mfo_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Yina, kaam ńsi Phero ọbar ettem, chibhi da nsi ngọhkha haabhada, ọmaana idik s'ipe anọng for k'Ijip, ");
INSERT INTO mfo_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Phero kọ itzọhng kóyonga. Mẹ wọ, kaam nsi ijoradik k'Ijip, mbiri ndima ẹfa chaam nnang anọng p'Ijip ettuma ch'ideden, ńdima ngaan s'anọng paam p'Israẹl mbina k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Anọng p'Ijip áronga bi, kaam wọ nde Ọvaar Ibinọkpaabyi, k'ogbe kwa nsi ijoradik k'Ijip, mbiri ndima anọng p'Israẹl mbina.” ");
INSERT INTO mfo_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mosẹs ọmaana Aarọn asi mach'Ọvaar Ibinọkpaabyi ọtzọhni bẹ. ");
INSERT INTO mfo_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Wa Mosẹs ode cho arọbh anna, Aarọn ode cho arọbh anna obhir attaan, mada bẹ agbaakhi Phero idik nna. ");
INSERT INTO mfo_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Wa Ọvaar Ibinọkpaabyi oben Mosẹs ọmaana Aarọn bi, ");
INSERT INTO mfo_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Idikha Phero obeni bọng bi, bọng si odik kw'ope ọnọng fọr, ben Aarọn bi, ‘Tzọkha ochikhura kwọ bhari m'irerek, m'itzitzikha sa Phero,’ ochikhura nwuma on-oreng jọhk.” ");
INSERT INTO mfo_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mando kwa Mosẹs ọmaana Aarọn afona atza akhebha Phero, bẹ asi mach'Ọvaar Ibinọkpaabyi ọtzọhni bẹ. Aarọn ọtzọkha ochikhura kwẹ ọbhari k'irerek m'itzitzikha sa Phero ọmaana akhaan-nọng pẹ, ochikhura nwuma on-oreng jọhk. ");
INSERT INTO mfo_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Mẹ wọ, Phero oyeri ajinọng p'akhaam eronga ọmaana abọhnga-nọng, anọng p'am-asi mbọhng k'Ijip, bẹ akwu asi odem nwuma wani ttara mfhọna sabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ọnọng-ọnọng ọbhari ochikhura kwẹ, achikhura mba an-areng jọhk. Yina, ochikhura kw'Aarọn on-omyi pabẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Kaambi mẹ wọ, Phero odo ettem ọbar, itzọhng koyong ọnang bẹ, mach'Ọvaar Ibinọkpaabyi ọkk'ọgbaakha. ");
INSERT INTO mfo_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Iwa Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Ettem cha Phero k'ebhon e, kẹ otzim obhum-obhum bi, otte anọng paam ọbọhk bẹ afona. ");
INSERT INTO mfo_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Rọhng atza akhebha Phero mada ọtza asi k'ekpebha. Kọ wobha m'ẹraangakha cha Nile atzikh-ẹ, atzima ochikhura nwuma kw'ira orengi jọhk atzima k'ọbọhk. ");
INSERT INTO mfo_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Mẹ wọ, gbaakh-ẹ bi, ‘Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'aHiburu, wọ ọtzọhm-m bi mgbaakh-ọ bi, atte anọng pẹ ọbọhk bẹ afona, ifha bẹ atza akpobh-ẹ k'ibe s'anọng an-arukhi. Yina, ma apyiri ma kakher bi, ayonga itzọhng. ");
INSERT INTO mfo_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ma wọ ode odik kw'Ọvaar Ibinọkpaabyi obeni bi, on-ofona ma kọ aronga bi, kẹ wọ ode Ọvaar Ibinọkpaabyi: Kaam ndima ochikhura nwa kwa ndim m'ọbọhk mbun m'ọraanga kwa Nile, ọ́n-ọbhakhi ode izizi. ");
INSERT INTO mfo_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Nden sa nwobh ka Nile ḿpe, ọraanga kwa Nile ón-obiro ohom eruk maa, anọng p'Ijip asi pẹ dọk kafha agwo.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Ben Aarọn bi, tzima ochikhura nwuma kw'atzim k'ọbọhk kwọ atzena k'ọraanga kw'Ijip, ọmaana ka ngekha, ọmaana mmen, ọmaana ka nsipe, ttara k'asi pa bẹ aye-oye, ifha bẹ an-abhakhi ade izizi. Izi in-iwobha k'ibe kpenamkpen k'Ijip, kaambi k'agbere pa bẹ atzim nchi, ttara atza asi bọ.” ");
INSERT INTO mfo_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mosẹs ọmaana Aarọn asi mach'Ọvaar Ibinọkpaabyi okk'bẹ ọtzọhna. M'itzitzikha sa Phero, ọmaana akhaan-nọng pẹ, Aarọn otzini ochikhura kwẹ obun m'ọraanga kwa Nile, asi biphyir an-ade izi-izi. ");
INSERT INTO mfo_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Nden s'ọraanga kwa Nile mpe, asi an-ahom eruk maa anọng p'Ijip asi pẹ dọk kafha agwo. Ijip biphyir on-ode izi-izi. ");
INSERT INTO mfo_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Yina, anọng p'am-asi mbọng k'Ijip asi idik nnuma rani ttara mfhọhna sabẹ. Mẹ wọ, Phero ochina ororo ọbar ettem, itzọhng kokher oyonga ọnang Mosẹs ọmaana Aarọn, mach'Ọvaar Ibinọkpaabyi ọkk'ọgbaakha. ");
INSERT INTO mfo_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Phero ọkpa nnam ochina k'ọvaar-dimpa kwẹ, idik nna k'ettem kokhe. ");
INSERT INTO mfo_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Mẹ wọ, anọng p'Ijip biphyir atza atzum ọkhaan-ọkhaan kw'ọraanga kwa Nile, ifha bẹ are asi pa bẹ afha agwo, okhuri da bẹ ani asi p'ọraanga nwa dọk afha agwo. ");
INSERT INTO mfo_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Wa iwu izenamfa ikwu ikwọbha, mada Ọvaar Ibinọkpaabyi ọbhakhi ọraanga kwa Nile ode izi-izi. ");
INSERT INTO mfo_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Rọhng atza gbaak Phero bi, ‘Kaam Ọvaar Ibinọkpaabyi mbeni bi, tte otte anọng paam ọbọhk bẹ afona ifha bẹ akwu akpobh-m. ");
INSERT INTO mfo_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Idikha obhumi bi, otte bẹ ọbọhk bẹ afona, kaam ndọhm awọribọhk k'ọhaabh makhọra ẹkhọma chẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Ọraanga kwa Nile on-ofu ttara awọribọhk. Awọribọhk mba an-abira anyaami k'ọvaar-dimpa kwẹ maa, apyiri k'ẹmaanggọ chẹ ọmaana k'iyimabe sẹ, ttara k'ihọhm s'akhaan-nọng pẹ, ọmaana k'ihọhm s'anọng pẹ maa, apyiri k'ibe sa bẹ am-asi ọchattọhk fẹ. ");
INSERT INTO mfo_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Awọribọhk mba ágbe anan-ẹ, ọmaana anọng pẹ, ttara akhaan-nọng pẹ ka for.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Gbaak Aarọn bi, onemi ọbọhk kwẹ ttara ochikhura kwẹ k'ọraanga, ọmaana ka mmen ttara ka nsipe, ifha awọribọhk ayin makhọra irek s'Ijip.” ");
INSERT INTO mfo_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Mando kw'Aarọn onemi ọbọhk kwẹ otzena k'asi p'Ijip biphyir, awọribọhk ayin makhọra Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Yina, anọng p'am-asi mbọhng k'Ijip abira akwu asi mfhọna sabẹ, awọribọhk ayin makhọra irek s'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Mẹ wọ, Phero oyeri Mosẹs ọmaana Aarọn, oben bi, “Bọng nzi njọhm akhukhi Ọvaar Ibinọkpaabyi, ifha ọrọbha awọribọhk mba k'ọhọhm kwaam, ọmaana k'ihọhm s'anọng paam, kaam ńtte anọng mba ọbọhk otte bẹ afona atza asi ẹjafọhni anang Ọvaar Ibinọkpaabyi kwabẹ.” ");
INSERT INTO mfo_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mosẹs oben Phero bi, “Kaam ntte odik kpenamkpen ọbọhk nnang-ọ bi, akhe ogbe kwa kaam nzi njọhm k'eho chọ, ọmaana ch'akhaan-nọng pọ, ttara anọng pọ bi, ayongi awọribọhk p'an-arik k'ọraanga kwa Nile, awọribọhk atte ẹhọhmmọr chọ, ọmaana nhọhmmọr s'anọng pọ ọbọhk, otte.” ");
INSERT INTO mfo_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Mẹ wọ, Phero oben bi, “Ophyin e.” Mosẹs obhina bi, “Kwẹ óde-ode mach'abeni, ifha aronga bi, ọnọng kode kwa ode mach'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwaman. ");
INSERT INTO mfo_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Awọribọhk átte kọ, ọmaana ebhonmọr chọ ọbọhk otte, ọmaana akhaan-nọng pọ, ttara anọng pọ, k'ọraanga kwa Nile wọ kwa bẹ an-arik.” ");
INSERT INTO mfo_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mada Mosẹs ọmaana Aarọn abin aji Phero, Mosẹs ozi njọhm, ọgbaak Ọvaar Ibinọkpaabyi odik kwa okhuri awọribọhk p'ọkk'ọtzọhma ọnang Phero. ");
INSERT INTO mfo_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Mẹ wọ, Ọvaar Ibinọkpaabyi ọbhaanga njọhm sa Mosẹs ophyemi, awọribọhk mba ape k'ihọhm, ọmaana ka ntọhmma-ttem, ttara k'iwoni. ");
INSERT INTO mfo_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Wa bẹ atzobha awọribọhk mba k'akhung-k'akhung maa, ephyok ch'awọribọhk mba ẹtzọkha irek nna biphyir. ");
INSERT INTO mfo_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Yina, mada Phero ore bi awọribọhk dọk kade, odo ettem ọbar, itzọhng dọk koyong ọnang Mosẹs ọmaana Aarọn, mach'iwa Ọvaar Ibinọkpaabyi okk'obena. ");
INSERT INTO mfo_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Ben Aarọn bi, onemi ochikhura kwo otzim k'ọbọhk kwẹ obun k'ọkpọm k'irek, ifha irerek s'Ijip biphyir, ín-ide abubuni-abubuni.” ");
INSERT INTO mfo_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Mosẹs ọmaana Aarọn asi mach'Ọvaar ọtzọhni bẹ. Mada Aarọn onemi ọbọhk ttara ochikhura kwẹ obun k'ọkpọm k'irek, abubuni ayin abẹ anọng ka for ọmaana nden. Mẹ wọ, ọkpọhm kw'irerek s'Ijip biphyir on-ode abubuni-abubuni. ");
INSERT INTO mfo_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Chibhi da anọng p'am-asi mbọhng k'Ijip, akhong bi asi mfhọna sabẹ, ifha abubuni abira ayin, bẹ kafha asi. Mẹ wọ, abubuni mba achina ororo abubha anọngẹya ọmaana nden. ");
INSERT INTO mfo_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Anọng mba p'am-asi mbọhng an-aben Phero bi, “Ọbọhk kw'Ibinọkpaabyi owobh m'odik nwa e.” Yina, Phero ochina ororo ọgaangi eho, itzọhng kokher oyonga m'idik nna, mach'iwa Ọvaar Ibinọkpaabyi okk'obena. ");
INSERT INTO mfo_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Bina k'ekpekpebha, atza akwunga Phero ọmma da ọtza asi k'ọraanga, agbaakh-ẹ bi, ‘Ọvaar Ibinọkpaabyi obeni bi: Tte anọng paam ọbọhk bẹ afona, ifha bẹ atza akpobh-m. ");
INSERT INTO mfo_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Idikha ani anọng paam ọbọhk atte bẹ afona, kaam ńdọhm araraang k'ọhaabh nchen kọ, ọmaana akhaan-nọng pọ, ọmaana anọng pọ, ttara k'ihọhm sabọng. Araraang áfhu ihọhm s'anọng p'Ijip, bẹ abira abubha k'irerek biphyir. ");
INSERT INTO mfo_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘Yina, m'ewu nduma, kaam ńgọm ẹkhọma cha Goshẹn, ch'anọng paam arukhi nhok, araraang kẹ káde, ifha áronga bi kaam Ọvaar Ibinọkpaabyi nwobh m'irerek nna. ");
INSERT INTO mfo_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Kaam nsi odengọmi owobha k'anọng paam ọmaana pọ. Ẹkhọhkha nda ch'épe ọnọng for, étto ophyini.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Mẹ wọ, Ọvaar Ibinọkpaabyi osi mach'ọgbaakhi, ọtzọhm araraang k'ọhaabh adim k'ọvaar-dimpa kwa Phero, ọmaana k'ihọhm s'akhaan-nọng pẹ. Araraang afhu k'irerek s'Ijip biphyir. ");
INSERT INTO mfo_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Mẹ wọ, Phero oyeri Mosẹs ọmaana Aarọn, oben bi, “Bọng nọhng atza asi njafọhni anang Ibinọkpaabyi kwabọng m'irerek nna.” ");
INSERT INTO mfo_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Yina, Mosẹs oben bi, “Mma, kwẹ mando kotzor e. Njafọhni s'am-amosi anang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwaman, mkpukhi anọng p'Ijip okpukhi. Idikha mon-osi njafọhni sa mkpukhi bẹ, bẹ man atza kátzọbh o? ");
INSERT INTO mfo_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Mẹ wọ, maman ọkhaambi obina orenga kw'iwu ittaan mochina k'ibe s'anọng an-arukhi, ifha mosi njafọhni ọnang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwaman, mach'ọtzọhni man.” ");
INSERT INTO mfo_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Mẹ wọ, Phero oben bi, “Kaam ntte bọng ọbọhk otte bọng atza asi njafọhni anang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng k'ibe s'anọng an-arukhi. Yina, bọng kakhaambi afona k'ibe s'ibhir-obhir. Bọng ńzi njọhm anang-m.” ");
INSERT INTO mfo_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mosẹs obhina bi, “Kaam mbin ma, ńzi njọhm ozi nnang Ọvaar Ibinọkpaabyi. Ophyini araraang mba atte kọ, ọmaana akhaan-nọng pọ, ttara anọng pọ ọbọhk otte. Kọ re bi, Phero bọng dọk kọbọra bi, ọkpa anọng mba eden bi, bẹ aningi njafọhn atza asi anang Ọvaar Ibinọkpaabyi.” ");
INSERT INTO mfo_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mẹ wọ, Mosẹs obina oji Phero, otza ozi njọhm ọnang Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ọvaar Ibinọkpaabyi ọbhaanga njọhm nna sa Mosẹs ophyemi bi, araraang mba atte Phero ọmaana akhaan-nọng pẹ, ttara anọng pẹ ọbọhk. Ẹraraang mada dani ch'ebire erik kede. ");
INSERT INTO mfo_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Yina, Phero obiro okhebha mẹ ọgaangi eho, anọng mba ọbọhk kokher otte, bẹ afona. ");
INSERT INTO mfo_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Wa Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Rọhng ka Phero, atza agbaakh-ẹ bi, Ọvaar Ibinọkpaabyi kw'abaHiburu obeni bi, ‘Tte anọng paam ọbọhk bẹ afona, ifha bẹ atza akpobh-m. ");
INSERT INTO mfo_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Idikha abhumi bi atte bẹ ọbọhk, achin ororo abọkha bẹ ahok, ");
INSERT INTO mfo_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","kaam Ọvaar Ibinọkpaabyi ńgọhkha bọng nkwuri s'ideden k'etzirakpo py'ewobh k'owoni, py'ede: nnyanyaang, ọmaana abhaam, ọmaana akamẹl, ọmaana andaamogbodo, ọmaana arukhimaan ttara avu. ");
INSERT INTO mfo_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Yina, kaam Ọvaar Ibinọkpaabyi ńgọmi etzirakpo py'anọng p'Israẹl ewobha, k'etzirakpo py'anọng p'Ijip. Otzirattọhk manda vani f'anọng p'Israẹl kópe.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Mando kw'Ọvaar Ibinọkpaabyi okhe ogbe, oben bi, “Ophyini wọ kwa kaam Ọvaar Ibinọkpaabyi ńsi odik nwa m'irek nna.” ");
INSERT INTO mfo_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ewu ehobh mẹ, Ọvaar Ibinọkpaabyi osi mach'obeni. Etzirakpo py'anọng p'Ijip epe biphyir, yina, otzirattọhk manda vani f'anọng p'Israẹl f'ope kode. ");
INSERT INTO mfo_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Mẹ wọ ofon, Phero ọtzọhm ajinọng bani bẹ atza adọhn odik nwa, bẹ are bi, ode odik-ọkka bi, otzirattọhk manda vani f'anọng p'Israẹl f'ọkk'ọpa, kode. Kaambi mẹ wọ, Phero ochina ororo ọgaangi eho, obhum bi, otte anọng p'Israẹl ọbọhk bẹ afona. ");
INSERT INTO mfo_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs ọmaana Aarọn bi, “Bọng kpokhi ọtzọtzọhng-khọhma ka nkwukha ka mbọhkpattem sabọng, tte Mosẹs okwuri ọtzọtzọhng-khọhma nwa k'iwokhi, Phero obe mẹ ore. ");
INSERT INTO mfo_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Itzọtzọhng nna íyaami mach'ọkpọm makhọra irerek s'Ijip, sẹ ín-itzima aphyi p'anwa ibhan ikwu, p'asi anọngeya, ọmaana nden makhọra irek nna.” ");
INSERT INTO mfo_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Mẹ wọ, bẹ akpokhi ọtzọtzọhng-khọhma ka nkwukha, akwu abe Phero k'itzitzikha. Mosẹs ọtzọkha sẹ okwuri k'iwokhi, aphyi p'anwa ibhan abhona anọngẹya ọmaana etzirakpo bi wooii. ");
INSERT INTO mfo_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Wa anọng p'am-asi mbọhng, bẹ Mosẹs k'itzitzikha kafha abe, okhuri aphyi p'asi bẹ, ọmaana anọng p'Ijip biphyir. ");
INSERT INTO mfo_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Yina, Ọvaar Ibinọkpaabyi osi Phero odo eho ọgaangi, itzọhng koyong ọnang Mosẹs ọmaana Aarọn, mach'Ọvaar Ibinọkpaabyi okk'Mosẹs ọgbaakha. ");
INSERT INTO mfo_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Bina atza akwunga Phero okpebhamma, aben-ẹ bi, Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'abaHiburu obeni bi, ‘Tte anọng paam ọbọhk bẹ afona, ifha bẹ atza akpobh-m. ");
INSERT INTO mfo_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Oni mando ode, m'ogbe nwa, kaam nna ngọhkha kọ ọmaana akhaan-nọng pọ nkwuri s'ideden, ifha kọ aronga bi, ọnọng kw'ode macha kaam, makhọra ọyagbin, kode. ");
INSERT INTO mfo_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ọban bi, nnamanda ira nkk'ettuma ndọhma nnang kọ ọmaana anọng pọ, ttara nkwuri s'ira nkk'bọng ifha, mbiri ndimi bọng m'ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Yina, odik kw'osi nttọ-ọ ọbọhk, awobha akpen ode bi, ifha are ẹfa chaam, ọmaana bi, bẹ afha asi ẹjaakhi cha che chaam makhọra ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Kọ atzima am-age-oge anang anọng paam bi, atte bẹ ọbọhk, bẹ afona. ");
INSERT INTO mfo_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Mẹ wọ, ophyini k'ogbe-dema nwa, kaam ndebh arọngda p'apyibhi ọtzam ayọhnga arọngda p'akk'atta ttẹwọr kẹ da Ijip ọmaan maa, apyiri ma. ");
INSERT INTO mfo_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Tzọhm ẹkkaabha bẹ atzima etzirakpo pyọ, ọmaana ọttọhk kpenamkpen fọ f'owobh k'owoni atzima adim k'ikhira, okhuri bi, arọngda mba atzebhi, anọngeya ọmaana etzirakpo py'eni k'ikhira ewobh, épe-ope.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Mẹ wọ, akhaan-nọng pa Phero p'akhaam ojora f'atzim p'Ọvaar Ibinọkpaabyi, afona m'ẹbhar-ẹbhar atza atzọkha atzọhmnọng pabẹ, ọmaana etzirakpo pyabẹ, atzima adim k'ẹtzaanga. ");
INSERT INTO mfo_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Yina, ayok mbuma p'asi itzimabhaang k'atzim p'Ọvaar Ibinọkpaabyi, atte atzọhmnọng pabẹ, ọmaana etzirakpo pyabẹ ọbọhk k'owoni. ");
INSERT INTO mfo_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Mẹ wọ e, Ọvaar Ibinọkpaabyi on-oben Mosẹs bi, “Nemi ọbọhk kwọ atzena k'ẹrọng, ifha arọngda atzebh anọngeya ọmaana etzirakpo, ttara ọttọhk kpenamkpen f'omeni k'iwoni s'anọng p'Ijip.” ");
INSERT INTO mfo_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mada Mosẹs onemi ochikhura kwẹ otzena k'ẹrọng, Ọvaar Ibinọkpaabyi ọtzọhm ẹbhaangkpon ọmaana arọngda, ẹbhaangkpon ẹmani k'irek. Mẹ wọ, Ọvaar Ibinọkpaabyi otzebh arọngda k'obhon kw'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Arọngda atzebh, ẹbhaangkpon ẹmani edimi, ẹmani edimi, arọngda mba bọ iwa apyibhi ọtzam ayọhnga p'akk'atta ttẹwọr kẹ da Ijip ọmaan maa, okwu ode obhon. ");
INSERT INTO mfo_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Arọngda mba afhu anọngẹya ọmaana etzirakpo k'Ijip, ọmaana nchi ttara ọttọhk kpenamkpen f'omeni k'iwoni. ");
INSERT INTO mfo_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ibẹ ibungisẹ s'iwa arọngda mba an-atzebhi ide ka Goshẹn, kẹ da iwa anọng p'Israẹl arukhi. ");
INSERT INTO mfo_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Mando kwa Phero oyeri Mosẹs ọmaana Aarọn ọgbaak bẹ bi, “Kaam nkk'ẹkhọhngkwuri nsa m'ogbe nwa, Ọvaar Ibinọkpaabyi wọ otzor-otzor, kaam ọmaana anọng paam bọ mọkhaam ottotto. ");
INSERT INTO mfo_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Bọng zi njọhm anang Ọvaar Ibinọkpaabyi bi, ọkwọbha ẹbhaangkpon ttara arọngda, kkeri py'ẹkk'ẹhaabha kpọng. Kaam ńtte bọng ọbọhk otte bọng afona, bọng kakhaambi, abira achina ororo awobha ma.” ");
INSERT INTO mfo_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mosẹs obhin-ẹ bi, “Idikha nkk'obhon ọbọhk ntta mfona, kaam ḿmẹma mbọhk saam ńzi njọhm nang Ọvaar Ibinọkpaabyi, mmaangkpon ńkwọbha ọtta-ọtta, arọngda abira ákwọbha otzetzebh. Mẹ kw'atzima aronga bi, Ọvaar Ibinọkpaabyi wọ ọkhaam ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Yina, kaam nnong kẹ bi, kọ ọmaana akhaan-nọng pọ, ojora f'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi atzima am-akhaama.” ");
INSERT INTO mfo_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Wa ngwugwuma ọmaana abarli akhibhi, da iwa abarli akk'akhora, ngwugwuma mbiri nwọm. ");
INSERT INTO mfo_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Yina, awit kàkhibhi okhuri da iwa bẹ ani akhori m'ogbe nwa). ");
INSERT INTO mfo_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mando kwa Mosẹs obin oji Phero, otte obhon ọbọhk, ọtza ọmẹma mbọhk otzena Ọvaar Ibinọkpaabyi ozi njọhm, mmaangkpon nkwọbha ọtta-ọtta, arọngda akwọbha ottotto, ẹrọng ebire ẹkwọbha otzetzebh. ");
INSERT INTO mfo_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Mada Phero ore bi ẹrọng, ọmaana arọngda, ttara mmaangkpon ikk'ikwọbha, obiro osi ẹkhọngkwuri. Kẹ ttara akhaan-nọng pẹ abira achina ororo agaangi eho. ");
INSERT INTO mfo_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Mẹ wọ e, Phero ochina ororo ọbar ettem, anọng p'Israẹl ọbọhk kokher otte bẹ afona, mach'Ọvaar Ibinọkpaabyi okk'Mosẹs otzima ọgbaak. ");
INSERT INTO mfo_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Wa Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Kọ rọhng atza akhebha Phero, kkeri kaam nkk'kẹ, ọmaana akhaan-nọng pẹ nsa bi, bẹ agaangi eho, ifha nsi idik s'ipe anọng for kabẹ k'ottem. ");
INSERT INTO mfo_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Órenga mẹ, ikhina kọ ágbaak va pọ, ọmaana va pa va pọ, eden cha kaam ńneng nnang anọng p'Ijip ihem, ọmaana idik s'ipe anọng for sa kaam nsi kabẹ k'ottem. Bọng biphyir aronga bi, kaam wọ nde Ọvaar Ibinọkpaabyi.” ");
INSERT INTO mfo_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Mando kwa Mosẹs ọmaana Aarọn afona atza akhebha Phero, agbaakh-ẹ bi, “Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'abaHiburu, obeni bi, ‘Ogbe obhir otzuma yan, yina ahakha for sọ k'itzitzikha saam o? Tte anọng paam ọbọhk bẹ afona, ifha bẹ atza akpobh-m. ");
INSERT INTO mfo_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Idikha abhumi bi, atte bẹ ọbọhk bẹ afona, ophyini, kaam ńdọhm agwuribhebhe ọtzọhm k'ẹkhọma chọ. ");
INSERT INTO mfo_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Agwuribhebhe mba abubha irerek biphyir maa ọnọng sẹ dọk ore. Bẹ ábira akhibhi ekpo py'iwa arọngda akk'akhibhi arik, ọmaana echi kpenamkpen ch'emeni k'iwoni sabọng. ");
INSERT INTO mfo_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Bẹ abira afhu k'ihọhm sọ, ọmaana k'ihọhm s'akhaan-nọng pọ, ttara k'ihọhm s'anọng p'Ijip biphyir. Kwẹ óde odik kw'abatte, ttara abatte p'atte an-atzima amara, ttẹwọr kẹ da obhon kw'Ijip ọmaan maa, apyiri ma.’ ” Mẹ wọ, Mosẹs ọbhakhi nnam, obina oji Phero. ");
INSERT INTO mfo_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Iwa akhaan-nọng mba abọbh Phero bi, “Ogbe obhir otzuma yan, yina ojinọng nwa ọkwọbha man k'eyoma okhe-khe o? Tte bẹ ọbọhk bẹ afona, ifha bẹ afha atza akpobha Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabẹ. Ode bi, kọ atzima ara bi, Ijip owobh k'ihem o?” ");
INSERT INTO mfo_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Mẹ wọ, Phero ọtzọhm bẹ atza ayeri Mosẹs ọmaana Aarọn akpa nnam, oben bẹ bi, “Bọng nọhng atza akpobha Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng. Yina, bọng anọng bọ ade anọng p'áfon-ofona o?” ");
INSERT INTO mfo_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mosẹs obhina bi, “Maman ófona ttara igbọ, ọmaana adeden-nọng, ọmaana va paman p'ijinọnọng, ọmaana p'ipanọnọng, ttara etzirakpo pyaman, okhuri bi, maman ọkhaam bi, mosi ọdadaami kw'ikpokpobha ọnang Ọvaar Ibinọkpaabyi kwaman.” ");
INSERT INTO mfo_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Yina, Phero on-oben bẹ bi, “Bọng achibhi bi, Ọvaar Ibinọkpaabyi owobha kẹ ttara bọng o? K'odik-ọkka, kaam panọng pabọng ọmaana va pabọng ọbọhk kintte bẹ afona. K'odik-ọkka, bọng achibhi itzama. ");
INSERT INTO mfo_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Mma e! Tte ajinọng bẹ-bẹ afona atza akpobha Ọvaar Ibinọkpaabyi, mada ode odik kw'am-aphyem-m wọ mẹ.” Mẹ wọ, bẹ akhubh Mosẹs ọmaana Aarọn, k'itzitzikha sa Phero. ");
INSERT INTO mfo_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Nemi ọbọhk kwọ atzena k'Ijip ifha agwuribhebhe k'ọhaabh atzọkha ibe kpenamkpen, bẹ abira akhibhi ọttọhk kpenamkpen f'omeni k'iwoni, ọmaana ọttọhk kpenamkpen f'arọngda akk'akhibhi arik.” ");
INSERT INTO mfo_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Mando kwa Mosẹs onemi ochikhura kwẹ otzena k'Ijip. Ọvaar Ibinọkpaabyi osi ọbhabha ọttẹwọr kẹ da ewuchen em-eyin ogwuma makhọra obhon, m'ẹyawu ttara erungiwu nduma biphyir. Yina ewu ehobha, ọphapha nwa okk'agwuribhebhe otzima okwu. ");
INSERT INTO mfo_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Agwuribhebhe mba anyaami k'ọhaabh makhọra Ijip. Mada ogbe odede itzama-dema nna s'agwuribhebhe itzimi-mitta k'Ijip, sẹ dọk kíbiri itto, kaambi k'ogbe ororo wọ. ");
INSERT INTO mfo_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Agwuribhebhe mba abubha irerek biphyir maa, sẹ ipyi erungi bi kaang Bẹ achi ọttọhk kpenamkpen f'arọngda akhibhi arik, ọmaana ekpo py'emeni k'iwoni, ttara achiduk pa nchi. Wa echi, obiro ode ọraraari manda wani kw'obiro otzen-otzeni k'irerek s'Ijip, dọk kode. ");
INSERT INTO mfo_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","M'ẹbhar-ẹbhar, Phero oyeri Mosẹs ọmaana Aarọn, oben bi, “Kaam nkk'ẹkhọngkwuri nsa k'itzitzikha s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwọ, ọmaana k'itzitzikha sọ. ");
INSERT INTO mfo_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Kọ bina anang ẹkhọngkwuri chaam m'ogbe nwa dọk, azi njọhm anang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwọ, ifha ọrọbh-m k'itzama-barada nna.” ");
INSERT INTO mfo_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mosẹs obina oji Phero, ọtza ozi njọhm ọnang Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ọvaar Ibinọkpaabyi ọbhakhi ọphapha nwa ọgaangi maa, on-ode mach'ọphapha kw'okhubha kw'ewuchen em-edimi. Wa ọphapha nwa ogwuma agwuribhebhe mba biphyir ọbhari k'Ẹraanga-khora. Ogwuribhebhe manda wani kw'obiro arik k'Ijip kode. ");
INSERT INTO mfo_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Yina, Ọvaar Ibinọkpaabyi osi Phero ochina ororo ọgaangi eho bi, otte anọng p'Israẹl ọbọhk bẹ afona. ");
INSERT INTO mfo_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Yaangi ọbọhk kwọ atzena k'ẹrọng, ifha orungibanga kw'ọttọmi ọnọng, óyin obubha Ijip biphyir.” ");
INSERT INTO mfo_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mẹ wọ, Mosẹs ọyangi ọbọhk kwẹ otzena k'ẹrọng, orungibanga kw'opyi bi kaang oyin obubha Ijip biphyir, k'iwu manda ittaan. ");
INSERT INTO mfo_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ọnọng manda wani kw'ore oyok, yina on-obiro obina oji ibe sẹ k'iwu ittaan kode. Yina, wa anọng p'Israẹl k'ipyerungi k'awobh k'obe fa bẹ arukhi. ");
INSERT INTO mfo_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Mẹ wọ, Phero oyeri Mosẹs ọmaana Aarọn oben bẹ bi, “Bọng nọhng atza akpobha Ọvaar Ibinọkpaabyi. Bọng afha tzima panọng pabọng kaambi va pabọng bọ, arọng afona. Bọng kingẹ tte etzirakpo pyabọng ọbọhk ewobha ka.” ");
INSERT INTO mfo_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Yina, Mosẹs oben bi, “Kọ akhaambi atte man ọbọhk, mọtza osi njafọhni, mobiro osi nnanga nkwọmisẹ ọnang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwaman. ");
INSERT INTO mfo_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Etzirakpo pyaman ẹkhaambi ẹtzọn man abẹ efona, man manda vani kofona oji. Mọkhaambi otzima byani mẹ okpobha Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi. Koyongi bi, mokk'opyiri kẹ, yina moronga ọttọhk fa motzima okpobha Ọvaar Ibinọkpaabyi e.” ");
INSERT INTO mfo_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Yina, Ọvaar Ibinọkpaabyi ochina ororo osi Phero ọgaangi eho, for kobiro odo bi, otte anọng p'Israẹl ọbọhk bẹ afona. ");
INSERT INTO mfo_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Mando kwa Phero obeni Mosẹs bi, “Bin-m k'itzitzikha! Aningi dọk ayom bi, abe-m k'itzitzikha o! Kkeri ewu ch'abira are itzitzikha saam ápe-ope.” ");
INSERT INTO mfo_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mosẹs obhina bi, “A o, tte kwẹ ode mach'abeni, kaam kọ k'itzitzikha dọk kímbe.” ");
INSERT INTO mfo_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Kaam ḿbiri ntte Phero ọmaana anọng p'Ijip ọbọhk bẹ are nkwuri rani. Nsisi mando, kẹ ótte bọng ọbọhk otte bọng afona. Mada otte bọng ọbọhk, okhubh bọng okhubh biphyir-phyir. ");
INSERT INTO mfo_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Gbaak anọng p'Israẹl, ajinọng ọmaana panọng bi, bẹ atza aben anọng p'Ijip anang bẹ ekpo pya gol ọmaana silva.” ");
INSERT INTO mfo_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Ọvaar Ibinọkpaabyi osi bi, anọng p'Ijip asi ọphyaam anang anọng p'Israẹl. Ayongi mẹ, akhaan-nọng pa Phero, ọmaana anọng p'Ijip biphyir anang Mosẹs ikpokpobha s'ideden). ");
INSERT INTO mfo_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Mẹ wọ, Mosẹs oben bi, “Ọvaar Ibinọkpaabyi obeni bi, ‘M'orungittem, kaam ńnenga k'obhon kw'Ijip makhọra. ");
INSERT INTO mfo_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ocheden-nwa kpenamkpen kw'ijinọng k'Ijip ópe-ope, ttẹwọr k'ocheden-nwa kw'ijinọng kwa Phero maa, apyiri k'ocheden-nwa kw'ijinọng kw'obira-kwanọng kw'om-ohok ekpo, ọmaana acheden-va p'abhaam biphyir. ");
INSERT INTO mfo_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Obhoma kw'ówobha k'Ijip opyibh ọyọhnga kw'iwa okk'owobha, ttara kw'óbiro owobha. ");
INSERT INTO mfo_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Yina, ọttọhk manda vani f'ósi anọng p'Israẹl kóde, kaambi ẹpfa dọ, anọngẹya ọmaana nden kẹ́gbọ.’ Mẹ wọ kwa bọng árọnga bi, Ọvaar Ibinọkpaabyi ọkhọmi anọng p'Israẹl ewobha k'anọng p'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Akhaan-nọng mba pọ biphyir ákpa nnam ọkpa, akwu ahakha nho anang-m, aben bi, ‘Tzotzokhaan, kọ ọmaana anọng p'atzọn-ọ abẹ biphyir, bọng nọhng!’ Ogbe nwuma ọkk'ọkwọbha, kaam ńttọ-ọ ọbọhk otte.” Mẹ wọ, Mosẹs obina ttara idọdọkhi oji Phero. ");
INSERT INTO mfo_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ọvaar Ibinọkpaabyi okk'Mosẹs obena bi, “Phero kọ itzọhng koyonga, ifha idik saam s'ipe anọng for ihaabh k'Ijip.” ");
INSERT INTO mfo_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mosẹs ọmaana Aarọn asi idik nna s'ipe anọng for biphyir m'itzitzikha sa Phero. Yina, Ọvaar Ibinọkpaabyi osi Phero ọgaangi eho, anọng p'Israẹl ọbọhk kokher otte bi, bẹ abina aji ẹkhọma chẹ. ");
INSERT INTO mfo_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Wa Ọvaar Ibinọkpaabyi oben Mosẹs, ọmaana Aarọn k'Ijip bi, ");
INSERT INTO mfo_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ophe nwa on-ode ochedenphe, ochedenphe kwabọng kwa cho. ");
INSERT INTO mfo_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Gbaak anọng p'Israẹl biphyir bi, k'iwu jobh s'ophe nwa, ojinọng kpenamkpen, otzima orukhimaan-nwa wani okwu k'eho ch'ẹhọhmmọr chẹ, ẹhọhmmọr kpenamkpen, orukhimaan-nwa wani. ");
INSERT INTO mfo_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Idikha ẹhọhmmọr ẹn-ẹbari ebenga k'odem kwa bẹ afha achi, orukhimaan-nwa wani akyera, tte ẹhọhmmọr nduma ebhuna ttara ayokh-ẹbaanga, atzor k'ọnọngmik kwa bẹ ade. Bọng dekha orukhimaan-nwa kw'obenga ọnọng-mik, atzor k'ekkema ch'ọnọng-ọnọng óchi. ");
INSERT INTO mfo_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Nden sa bọng átzima, sẹ ngaambi nde adimpẹ p'ade cho wani, sa nni ekhem mbiri ndima. Bọng afha atzekha k'arukhimaan, ayongi mẹ, bọng dekha k'avu. ");
INSERT INTO mfo_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Bọng kkeri sẹ maa, opyiri k'ẹchọhkha ch'ewu ch'ettonga ọhawani kwa chi ch'ophe nwa, kw'anọng p'Israẹl biphyir akhaambi ayẹk sẹ ndọngi. ");
INSERT INTO mfo_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Mẹ wọ, bẹ átzọkha izi rani áphyokha k'akhaan-akhaan, ọmaana k'ebir-ebir kwa mkpọmmachi s'amma p'ihohm sa bẹ áwobha áchi, nden nna. ");
INSERT INTO mfo_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","M'erungiwu nduma dani, bẹ atzima akwọngitzọhng p'ajobh-ojobhi, achi nden nnuma sa bẹ abhaabhi k'ekpon. Tte bẹ achi ttara brẹd kwa bẹ ani yist akhe. ");
INSERT INTO mfo_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Bọng chẹ ekhekhebhi kàchi, bọng chẹ kàbira awọhn ttara asi. Yina, bọng mabh eho, ọmaana mmo, ttara ettongakpo k'ekpon. ");
INSERT INTO mfo_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Bọng chi chẹ akyera yina ewu ehobha. Idikha kpenamkpen emung, ewu ewobh, bọng akhaambi akwọmi chẹ ọkwọmi. ");
INSERT INTO mfo_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ma wọ ode odem kwa bọng áchi chẹ; bọng kpaama odikpa ka nwura sabọng, bọng akhe ekpo pya mmo, bọng atzima achikhura pa bọng ka mbọhk. Bọng chi chẹ k'ẹbhar-k'ẹbhar. Ma wọ ode ọdadaami kwa Pasova kw'ọnang kaam Ọvaar Ibinọkpaabyi ikpokpobha. ");
INSERT INTO mfo_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“M'erungiwu nduma dani, kaam ńnenga k'Ijip mfhu acheden-va p'anọngẹya biphyir, ọmaana acheden pa nden kpenampken. Kaam ḿkpaara aponga p'apyibh akha p'Ijip biphyir. Kaam wọ nde Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Izi nna íde ẹkhọhkha ẹnang bọng k'ihọhm sa bọng awobh. Mada nne izi nnuma, kaam ńjekha bọng ojekha. Nkwuri sa ńgebha bọng kíde, mada ńsi anọng p'Ijip itzama. ");
INSERT INTO mfo_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Ma wọ óde ewu ch'ojima, ch'igbọ s'íkwu k'ororo itzima isi ọdadaami inang Ọvaar Ibinọkpaabyi ikpokpobha. Ẹdadaami-wu nda ewohba ka cho kpenamkpen maa ogbe ode. ");
INSERT INTO mfo_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","K'iwu izenamfa, bọng áchi brẹd kwa bẹ ani yist akhe. Bọng nọbha yist kabọng k'ihọhm m'echedenwu, okhuri bi, idikha ọnọng kpenamkpen ochi ọchattọhk fa bẹ akhe yist, ttẹwọr m'ewu dani maa apyiri iwu izenamfa nna, bẹ akhaambi akhubh-ẹ k'ebhonmọr ch'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","M'echedenwu, ttara ewu ch'ettong nzenamfa, bọng hok ewobha ch'ikpokpobha s'Ọvaar Ibinọkpaabyi. Bọng ọtzọhm m'iwu nna biphyir kasi, oyongi ọchattọhk fẹ-fẹ, fa bọng afha asi anang ọnọng kpenamkpen bi, ochi. ");
INSERT INTO mfo_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Bọng si ọdadaami nwa kwa brẹd kwa bẹ ani yist akhe, okhuri bi, m'ewu nda dọ cha kaam ndim bọng ka ngaan sabọng mbina k'Ijip. Bọng si ọdadaami nwa mach'ọdadaami kw'owobha ọnang igbọ s'íkwu k'ororo. ");
INSERT INTO mfo_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ttẹwọr k'ẹchọhkha ch'iwu ọhawani kwa chi s'ocheden-phe, bọng am-achi brẹd kwa bẹ ani yist akhe maa, apyiri k'ẹchọhkha ch'ewu ch'ettong iwu ẹrọbh obhiri dani. ");
INSERT INTO mfo_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","K'iwu manda izanamfa, bọng yist k'ihọhm sabọng kahok. Ọnọng kw'ochi ọchattọhk fa bẹ akhe yist, ode ọmaana, obiro ode okhekhennọng, bẹ akhaambi, akhubh-ẹ k'ebhonmọr ch'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Bọng ọttọhk fa bẹ akhe yist kàchi. K'ibe kpenamkpen sabọng arukhi, bọng akhaambi achi brẹd kwa bẹ ani yist akhe.” ");
INSERT INTO mfo_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Mẹ wọ, Mosẹs oyeri adeden-nọng p'Israẹl biphyir oben bẹ bi, “Bọng nọhng madẹdẹnwa, atza atzekha orukhimaan-nwa wani-wani, anang nhọhmmọr sabọng, bọng fhu arukhimaan-va atzima asi ọdadaami kwa Pasova. ");
INSERT INTO mfo_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Bọng dọkha ẹraraari-pyi cha hisobh, arana k'izi sa bọng akhe k'ọkwakkama, bọng atzọkha izi rani abọra k'ebir-ebir ọmaana k'akhaan-akhaan pa mkpọmmachi s'amma. Ọnọng manda wani oningi k'iyaan oyini matzẹmaa, ewu ehobha. ");
INSERT INTO mfo_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Mada isa Ọvaar Ibinọkpaabyi órenga m'irek nna bi, ofhu anọng p'Ijip, óre izi nna k'ebir-ebir ọmaana k'akhaan-akhaan pa mkpọmmachi s'amma. Orenga-eden kw'obo ọbọhk kótte bi, odim k'ihọhm sabọng bi, ofhu bọng. ");
INSERT INTO mfo_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Bọbọng ọmaana va pa va pabọng, akhaambi ahok ndọhna nna mach'ọphaangi kw'owobha maa, ogbe ode. ");
INSERT INTO mfo_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Bọng apyiri k'irerek nnuma s'Ọvaar Ibinọkpaabyi ochekhi bi, ọ́nang bọng, bọng si ọdadaami nwa. ");
INSERT INTO mfo_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ikhina va pabọng abọbhi bọng bi, ‘Ọdadaami nwa oyini yan o?’ ");
INSERT INTO mfo_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Bọng gbaak bẹ bi, ‘Ode ọdadaami kw'ẹjafọhni cha Pasova anang Ọvaar Ibinọkpaabyi, kw'iwa ojek ihọhm s'anọng p'Israẹl k'Ijip, ọkkaana nhọhmmọr saman k'ogbe kw'iwa ofhu anọng p'Ijip.’ ” Mẹ wọ e, anọng mba arakha attima otzitzikha k'irerek, akpobha Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Wa anọng p'Israẹl asi mach'Ọvaar Ibinọkpaabyi okk'Mosẹs ọmaana Aarọn ọtzọhna. ");
INSERT INTO mfo_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","M'orungittem, Ọvaar Ibinọkpaabyi ofhu achedenva biphyir k'Ijip, ttẹwọr k'ocheden-nwa kwa Phero, kw'ọdabhi ẹvaar, maa atza apyiri k'achedenva p'agbakkọbh-kkọhbha p'awobh k'ẹgbakkọhbh-ttọmma, ttara achedenva p'etzirakpo biphyir. ");
INSERT INTO mfo_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Mada Phero ọmaana akhaan-nọng pẹ, ttara anọng p'Ijip biphyir aphyọbh m'erungi, wa obhoma kw'ideden owobh k'Ijip, da iwa ẹhọhmmọr en-ebekhi ch'ọnọng oni ope. ");
INSERT INTO mfo_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","M'erungi, Phero oyeri Mosẹs ọmaana Aarọn, oben bi, “Bọng bina! Bọng dima anọng p'Israẹl abina aji anọng paam. Bọng nọhng atza akpobha Ọvaar Ibinọkpaabyi macha bọng akk'aphyema. ");
INSERT INTO mfo_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Bọng dima etzirakpo pyabọng atzima arọhng, macha bọng akk'abena. Bọng biri si-m ittabọhng.” ");
INSERT INTO mfo_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Mẹ wọ, anọng p'Ijip aben anọng mba bi, bẹ asi ẹbhar-ẹbhar abina aji ẹkhọma nda, “Oni mando ode, bẹ ápope biphyir.” ");
INSERT INTO mfo_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Mẹ wọ, anọng mba atzini abubuma pabẹ, yina bẹ an-atzini yist atzọhkha ka mbabaang sabẹ, k'agbanggbang pa bẹ am-atzima asi brẹd, pa bẹ abhọri k'ọbara. ");
INSERT INTO mfo_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Wa anọng p'Israẹl asi macha Mosẹs okk'bẹ ọtzọhna, bẹ atza abọbh anọng p'Ijip asilva, ọmaana gol, ttara ọbara. ");
INSERT INTO mfo_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Wa Ọvaar Ibinọkpaabyi ọkk'ọsa bi, anọng p'Ijip asi ọphyaam anang anọng p'Israẹl. Wa bẹ anang anọng p'Israẹl ọttọhk kpenamkpen fa bẹ abọbhi bẹ. Mẹ wọ e, bẹ achi anọng p'Ijip ọgbọm. ");
INSERT INTO mfo_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Wa anọng p'Israẹl abina orenga ka Rameses apyiri ka Sukọt. Akhiri panọng ọmaana vava aji, ajinọng p'iwa asi orenga nwa apyiri anọng nnọhna ẹnọhna obhiri arọbh jobh. ");
INSERT INTO mfo_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Wa anọng adọdọk k'ọhaabh, ọmaana etzirakpo k'ọhaabh, arukhimaan ọmaana avu abira atzọn bẹ abẹ m'orenga nwa. ");
INSERT INTO mfo_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Wa bẹ atzọkha abubuma pa bẹ akk'atzima bina k'Ijip asi brẹd kwa bẹ ani yist akhe. Wa abubuma mba yist kakhaam, okhuri da iwa bẹ an-akhubhi bẹ okhubh k'Ijip, bẹ ogbe dọk kakhaam kwa bẹ atzim awọhn ọchattọhk fabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Biphyir-phyir wa anọng p'Israẹl arukhi cho ẹnọhna obhiri ẹrọbh obhiri jobh k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Mẹ ewu nduma ch'ettong cho ẹnọhna obhiri ẹrọbh obhiri jobh, wa anọng p'Ọvaar Ibinọkpaabyi ka ngaan sabẹ, abina aji Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Da iwa Ọvaar Ibinọkpaabyi okkeri erungiwu nduma, ifha otzima bẹ obina k'Ijip, erungiwu nda dọ ch'anọng p'Israẹl biphyir ám-akkeri, atzima anang Ọvaar Ibinọkpaabyi ikpokpobha, k'igbọ kpenamkpen s'íkwu k'ororo. ");
INSERT INTO mfo_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ọvaar Ibinọkpaabyi oben Mosẹs ọmaana Aarọn bi, “Ma wọ ode ndọhna s'ikhuri ọchattọhk f'ọdadaami kwa Pasova. “Tte okhekhennọng manda wani oningi fẹ ochi. ");
INSERT INTO mfo_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Obira kpenamkpen kwa bọng akk'adebha ofha ochi fẹ ochi, bọng akk'ẹ ọkpakkọrikkọ asa. ");
INSERT INTO mfo_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Yina, okhekhennọng kw'orukhi mẹ, ọmaana ọtzọhmnọng kwa bẹ abheri ọtzọhm, bẹ kakhaambi ochi fẹ. ");
INSERT INTO mfo_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Bọng akhaambi achi fẹ k'ọhọhm ẹtzaanga, bọng etzen manda dani katzima ayin k'iyaan. Bọng ọkhọbhi manda wani kavọhkhi. ");
INSERT INTO mfo_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Ebhonmọr ch'Israẹl biphyir ẹkhaambi esi ọdadaami nwa. ");
INSERT INTO mfo_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Okhekhennọng kw'orukhi ttara bọng, kw'ọdaakh-ẹ bi, ira osi Ọdadaami nwa ọnang Ọvaar Ibinọkpaabyi, ọkhaambi osi ajinọng p'ọhọhm kwẹ biphyir ọkpakkọrikkọ. Mẹ wọ, kẹ ofha osi ọdadaami nwa mach'ọnọng wani kw'ode ọmaana kw'irek nna. Tte ọnọng kwa bẹ ani ọkpakkọrikkọ asi oningi ochi. ");
INSERT INTO mfo_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Aphaangi mba awobh anang ammaana, ttara akhekhennọng p'arukhi ttara bọng.” ");
INSERT INTO mfo_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Wa anọng p'Israẹl biphyir asi mach'Ọvaar Ibinọkpaabyi okk'Mosẹs ọmaana Aarọn ọtzọhna. ");
INSERT INTO mfo_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Mẹ ewu nduma dani, wa Ọvaar Ibinọkpaabyi otzima anọng p'Israẹl ka ngaan sabẹ obina k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Iwa Ọvaar Ibinọkpaabyi oben Mosẹs bi, ");
INSERT INTO mfo_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Tte ocheden-nwa kpenamkpen kw'ijinọng ọbọhk anang-m. Ocheden-nwa kw'ẹbhọr kpenamkpen k'ottem kw'anọng p'Israẹl, ode ọnọngẹya o, obiro ode etzen o, ode kwaam.” ");
INSERT INTO mfo_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mẹ wọ, Mosẹs oben anọng mba bi, “Bọng jima ewu nda, ewu ch'iwa bọng abin k'Ijip, k'obhon kw'ebira, okhuri bi, Ọvaar Ibinọkpaabyi ọrọbh bọng kẹ ttara ẹfa. Bọng ọttọhk kpenamkpen fa bẹ akhe yist kàchi. ");
INSERT INTO mfo_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Mayina, k'ophe kw'Abib wọ kwa bọng abin. ");
INSERT INTO mfo_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Mada Ọvaar Ibinọkpaabyi ótzima bọng opyiri k'irek s'abaKenaan, ọmaana s'abaHet, ọmaana s'ab'Amọr, ọmaana abaHiv, ttara s'ab'aJẹbus, irerek s'iwa ochekhi ọnang abatte pabọng bi, ọnang bọng irerek ọkkakka s'abasi, ọmaana akhọkhọnana ahaabh-ọhaabh, bọng ám-asi ọdadaami nwa m'ophe nwa. ");
INSERT INTO mfo_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","K'iwu izenamfa, bọng chi brẹd kwa bẹ ani yist akhe. K'ewu ch'ettonga izenamfa, bọng si ọdadaami anang Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Bọng chi brẹd kwa bẹ ani yist akhe, k'iwu nnuma izenamfa. Tte ọttọhk kpenamkpen fa bẹ akhe yist, oningi k'ottem kwabọng ode. Tte bẹ iningi yist orere are, ka nnem sabọng. ");
INSERT INTO mfo_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","M'ewu nduma, bọng gbaak va pabọng bi, ‘Nsi mando okhuri odik kw'iwa Ọvaar Ibinọkpaabyi osi ọnang man, mada mobin k'Ijip.’ ");
INSERT INTO mfo_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ọdadaami nwa óde mach'ẹkhọhkha cha bọng akhe ka mbọhk sabọng, abira akpa k'otzitzikha-ttem fa bọng mach'ojima bi, ọphaangi kw'Ọvaar Ibinọkpaabyi owobha ka mma sabọng, okhuri bi, Ọvaar Ibinọkpaabyi otzim bọng obina k'Ijip, k'ẹfa chẹ ch'ideden. ");
INSERT INTO mfo_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Cho kpenamkpen, bọng akhaambi ahok ndọhna nna, k'ogbe kwẹ. ");
INSERT INTO mfo_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Mada Ọvaar Ibinọkpaabyi ótzima bọng opyiri k'irek s'abaKenaan, ọtzọkha sẹ ọnang bọng, mach'iwa ochekhi ọnang bọng, ọmaana abatte pabọng. ");
INSERT INTO mfo_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Bọng dọkha achedenva p'ẹbhọhr kpenamkpen adibha anang Ọvaar Ibinọkpaabyi. Achedenva p'ijinọng p'etzirakpo pyabọng ade p'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Bọng dima arukhimaan-dim abhek ocheden-nwa kw'ẹnyanyaang, yina, idikha bọng ani chẹ abhekhi, phyakh-ẹ ekhokhora. Kẹ wọ osi, bọng akhaambi abhek achedenva pabọng p'ijinọng kpenamkpen. ");
INSERT INTO mfo_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Ikhina va pabọng p'ijinọng abọbhi bọng bi, ‘Ọdadaami nwa oyini yan o?’ Gbaak bẹ bi, ‘Iwa Ọvaar Ibinọkpaabyi otzim man obina k'Ijip, k'irerek s'ebira, k'ẹfa chẹ ch'ideden. ");
INSERT INTO mfo_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Mada Phero otzim oho-gaangi obhum bi, otte man ọbọhk mofona, wa Ọvaar Ibinọkpaabyi ofhu achedenva p'anọngẹya, ọmaana pa etzirakpo p'Ijip. Odik nwa wọ motzima yina ndima ocheden-nwa kw'ijinọng kw'otzirattọhk kpenamkpen, nsi ẹjafọhni nnang Ọvaar Ibinọkpaabyi, ifha motzima obhek achedenva paman kpenamkpen p'ijinọng.’ ");
INSERT INTO mfo_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ma wọ óde mach'ẹkhọhkha ọnang bọng bi, wa Ọvaar Ibinọkpaabyi otzim ẹfa chẹ ch'ideden, ọrọbha man k'ebira ch'Ijip.” ");
INSERT INTO mfo_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Mada Phero on-otte anọng mba ọbọhk bẹ afona, wa Ibinọkpaabyi bẹ kotzim orenga k'ẹkhọma cha Philistiya, kw'eden ekhum-okhuma, da iwa Ibinọkpaabyi ochibhi bi, “Idikha bẹ attem egbong abẹ k'eden, bẹ afha abhona achibhi pabẹ, akpa nnam k'Ijip.” ");
INSERT INTO mfo_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Mẹ wọ, wa Ibinọkpaabyi otzima bẹ ọkhọri k'eden ch'ibe s'anọng an-arukhi, s'ikkeri itzitzikha k'Ẹraanga-khora. Wa anọng p'Israẹl ado for s'egbong atzima abina k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Iwa Mosẹs okpokhi akhọbhi pa Josẹph, okhuri da iwa Josẹph okk'va p'Israẹl ọsa bẹ atzọkha anwọhngi. Kẹ Josẹph okk'obena bi, “K'odik ọkkọkka Ibinọkpaabyi ọ́kkaana bọng ọkkaana e. Bọng akhaambi akpokhi akhọbhi paam m'ibe nna, atzima afona.” ");
INSERT INTO mfo_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Mada bẹ abin ka Sukọt, bẹ abhingi k'Ẹtam k'ọkhaan-ọkhaan kw'ibe s'anọng an-arukhi. ");
INSERT INTO mfo_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Wa Ọvaar Ibinọkpaabyi otzim eboni ch'ebe iduduma ochi bẹ eden k'ẹya, obiro otzima ekpon ch'ebe iduduma ọnang bẹ iyaan k'erungi, ifha bẹ afha asi orenga nwa k'ẹya, ọmaana k'erungi. ");
INSERT INTO mfo_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Wa eboni nda ch'ebe iduduma k'ẹya, ọmaana ekpon ch'ebe iduduma k'erungi, bẹ k'itzitzikha s'anọng p'Israẹl, kabin. ");
INSERT INTO mfo_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, ");
INSERT INTO mfo_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Gbaak anọng p'Israẹl bi, bẹ akpa nnam atza abhing abaanga Pi-Hahirọt kw'owobh k'ottem kwa Migdol, ọmaana ọraanga kw'ideden. Tte bẹ abhing k'ọraanga kw'ideden ọkhaan-ọkhaan, akkeri Baal-Zẹphọn itzitzikha. ");
INSERT INTO mfo_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Phero ón-ochibhi bi, anọng p'Israẹl am-awen akhọri irerek nna k'ikkokkoni, s'ikpori bẹ imaana k'ibe s'anọng an-arukhi. ");
INSERT INTO mfo_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Kaam ńsi Phero ọgaangi eho, okhubh bẹ ka nnam. Yina, kaam ńnenga ka Phero ọmaana k'agbongnọng pẹ, ńdọkha abarada ka for saam. Anọng mba p'Ijip áronga bi, kaam wọ nde Ọvaar Ibinọkpaabyi.” Mẹ wọ, anọng p'Israẹl asi mando. ");
INSERT INTO mfo_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Mada Phero kw'ode ọvaarnọng kw'Ijip ọbhaang bi, anọng p'Israẹl akk'arọbha afona, Phero ọmaana akhaan-nọng pẹ abhona achibhi pabẹ, aben bi, “Bọng odik kw'amosi ma? Mokk'anọng mba ọbọhk ọtta bẹ afona, ọtzọhm fabẹ okk'man obiro odimi.” ");
INSERT INTO mfo_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Mẹ wọ, odo akpaar pẹ pa nnyanyaang mindọr ewobha, obiro otzima agbongnọng pẹ bi, bẹ atzọn-ẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Otzima akpaar akkakka pẹ pa nnyanyaang mindọr, ẹnọhna obhiri arọbh jobh, ttara k'akpaar pa nnyanyaang mindọr p'Ijip biphyir, ttara adeho p'atzim bẹ biphyir eden. ");
INSERT INTO mfo_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Ọvaar Ibinọkpaabyi osi Phero kw'ode ọvaarnọng kw'Ijip ọgaangi ettem, okhubh anọng p'Israẹl ka nnam p'am-arenga ekkengitza, afona. ");
INSERT INTO mfo_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Anọng p'Ijip, ọmaana nnyanyaang sa Phero, ọmaana akpaar pẹ pa nnyanyaang mindọr, ọmaana ayaari-nnyanyaang, ttara agbongnọng pẹ biphyir, akhubh anọng p'Israẹl ka nnam, agwora bẹ kẹ da bẹ abhingi k'ọraanga kw'ideden, ọbaanga Pi-Hahirọt kw'okkeri Baal-Zẹphọn itzitzikha. ");
INSERT INTO mfo_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Mada anọng p'Israẹl atzini chen are bi, Phero ttara anọng p'Ijip areng akwuma ka nnam, ojora osi bẹ. Bẹ abhom amọng ayeri Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Bẹ an-aben Mosẹs bi, “Ma da mpekhubh nni k'Ijip nde, kẹ wọ osi atzima man akwu m'ibe s'anọng an-arukhi bi, mope o? Bọng odik wọ kw'asi man ma bi, atzima man abina k'Ijip o? ");
INSERT INTO mfo_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Wa man kọ kobeni bi, ‘Atte man ọbọhk mowobha, mosi itzọhm ọnang anọng p'Ijip?’ Ira ojibh ọtzam bi mosi itzọhm ọnang anọng p'Ijip, ọyọhnga bi, mokwu ope m'ibe nna s'anọng an-arukhi!” ");
INSERT INTO mfo_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mosẹs obhina bẹ bi, “Tte oningi bọng ojor. Bọng do abe, kkeri mayina, bọng áre ẹnaanga ch'Ọvaar Ibinọkpaabyi ọ́nang bọng. Anọng mba p'Ijip pa bọng are mayina ma, bọng bẹ dọk káre e. ");
INSERT INTO mfo_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Ọvaar Ibinọkpaabyi wọ ósi erima chabọng, bọbọng kingẹ wobha bi sẹẹbh.” ");
INSERT INTO mfo_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Ode yan kwa kọ am-abhom ayer-m o? Ben anọng p'Israẹl achina ororo k'orenga. ");
INSERT INTO mfo_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Tzini ochikhura kwọ, anemi ọbọhk atzena k'ọraanga kw'ideden ifha asi abhaangi, anọng p'Israẹl arenga k'irerek ajekha. ");
INSERT INTO mfo_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Kaam ńsi anọng p'Ijip agaangi nho, ifha bẹ ákhubh bẹ ka nnam. Kaam mbiri ńnenga ka Phero, ọmaana agbongnọng pẹ biphyir, ọmaana akpaar pẹ pa nnyanyaang mindọr, ttara ayaari-nnyanyaang pẹ, ńdọkha abarada. ");
INSERT INTO mfo_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Anọng p'Ijip árọnga bi, kaam wọ nde Ọvaar Ibinọkpaabyi, mada nnenga ka Phero, ọmaana akpaar pẹ pa nnyanyaang mindọr, ttara k'ayaari nnyanyaang pẹ ndọkha abarada.” ");
INSERT INTO mfo_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Mẹ wọ, itzọhmi s'Ibinọkpaabyi s'ikk'arim-egbong p'Israẹl eden im-icha, in-ikpa nnam itza iwobha bẹ ka nnam. Eboni ch'ebe iduduma ebere ebina bẹ k'itzitzikha, ọtza ebe bẹ ka nnam, ");
INSERT INTO mfo_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","kw'ode ottem kw'agbongnọng p'Ijip ọmaana p'Israẹl. M'erungi biphyir eboni nda etzima ipyerungi ekwu k'okhubha wani, ọmaana iyaan k'okhubha nwonggo. Mẹ wọ, ọnọng kw'ofha orenga ọbaanga oyok m'erungiwu nduma biphyir kode. ");
INSERT INTO mfo_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mẹ wọ, Mosẹs onemi ọbọhk kwẹ otzena k'ọraanga kw'ideden, m'erungiwu nduma biphyir Ọvaar Ibinọkpaabyi otzima ọphapha kw'ọgaang-ọgaangi kw'ofon kẹ da ewuchen em-eyin, okpena asi maa ogbin oyin. Asi mba abhaangi. ");
INSERT INTO mfo_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Wa anọng p'Israẹl arenga k'ogbin m'ẹraangattem, ttara asi p'abe mach'echumi k'odimbọhk, ttara ka kwabọhk kwabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Anọng p'Ijip, ọmaana nnyanyaang sa Phero, ọmaana akpaar pa pẹ nnyanyaang mindọr, ttara ayaari-nnyanyaang pẹ biphyir, akhubh bẹ ka nnam adim k'ẹraangattem ch'ọraanga kw'ideden. ");
INSERT INTO mfo_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Mẹ ekpekpebha, Ọvaar Ibinọkpaabyi orenga k'ekpon ch'ebe iduduma, ọmaana k'eboni ore agbongnọng p'Ijip, mẹ wọ, okhe bẹ ka dama-dama. ");
INSERT INTO mfo_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Osi ndọkhi s'akpaar pa nnyanyaang mindọr irọbha, maa orenga ọyak bẹ. Mẹ wọ e, anọng p'Ijip an-aben bi, “Tte motte anọng p'Israẹl ọbọhk! Kkeri Ọvaar Ibinọkpaabyi wọ om-orima Ijip abẹ ma, ka eho chabẹ.” ");
INSERT INTO mfo_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Nemi ọbọhk kwọ atzena k'ọraanga kw'ideden, ifha asi akpa nnam anwa akpori anọng p'Ijip, ọmaana akpaar pabẹ pa nnyanyaang mindọr, ttara ayaari nnyanyaang pabẹ.” ");
INSERT INTO mfo_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mosẹs e onemi ọbọhk kwẹ otzena k'ọraanga kw'ideden. M'owukhobha ọraanga nwa akpa nnam owobha mach'ira owobh. Anọng p'Ijip am-akhonga ọrọrọbh, Ọvaar Ibinọkpaabyi okpena bẹ biphyir okhe k'ọraanga kw'ideden. ");
INSERT INTO mfo_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Asi mba abhobh abhori akpaar pa nnyanyaang mindọr, ọmaana ayaari nnyanyaang, ttara agbongnọng pa Phero biphyir p'akk'anọng p'Israẹl akhubha ka nnam, anwa k'ọraanga kw'ideden. Ọnọng manda wani kw'ọnang kode. ");
INSERT INTO mfo_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Yina, wa anọng p'Israẹl areng k'ogbin m'ẹraangattem, ch'asi abe mach'echumi k'odimbọhk ttara ka kwabọhk kwabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","M'ewu nduma, Ọvaar Ibinọkpaabyi ọkkaana anọng p'Israẹl ka mbọhk s'anọng p'Ijip. Wa anọng p'Israẹl an-are da anọng p'Ijip an-ayim abukh-abukhi k'ọraanga ọkhaan-ọkhaan. ");
INSERT INTO mfo_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Mẹ wọ e, mada anọng p'Israẹl are ẹfa ch'ideden ch'Ọvaar Ibinọkpaabyi otzim okhema anọng p'Ijip, bẹ akhaama ojora f'Ọvaar Ibinọkpaabyi, bẹ abira akhaama nnam-ophephe ka kẹ, ọmaana ka ọtzọhmnọng kwẹ Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Mẹ wọ, Mosẹs ọmaana anọng p'Israẹl akkọhn ẹmọng nda anang Ọvaar Ibinọkpaabyi aben bi, “Kaam ńkkọhn nnang Ọvaar Ibinọkpaabyi okhuri k'ekhema-barada chẹ. Kẹ okk'ẹnyanyaang, ọmaana ọyaar-ẹnyanyaang, otzini otzem k'ọraanga kw'ideden. ");
INSERT INTO mfo_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“Ọvaar Ibinọkpaabyi wọ ode ẹfa chaam, ọmaana ẹmọng cha kaam nkkọhni, Kẹ wọ ode ẹnaanga chaam. Kẹ wọ ode Ibinọkpaabyi kwaam. Kaam ńnang-ẹ ẹtzọhnga, kaam ńdini Ibinọkpaabyi kw'otte kwaam okpobh k'ẹrọng. ");
INSERT INTO mfo_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Ọvaar Ibinọkpaabyi wọ ode okkenggitza, kẹ okpen Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Kẹ okk'akpaar pa Phero pa nnyanyaang mindọr, ọmaana agbongnọng pẹ, ọtzọkha otzem k'ọraanga kw'ideden. Ọtzọkha akhaan-nọng pa Phero p'abari odik ọtzam, odimi k'Ẹraanga-khora. ");
INSERT INTO mfo_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Asi donga-dong mba akk'bẹ abhọri, bẹ atzem k'esiwọr mach'ọtza. ");
INSERT INTO mfo_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“O Ọvaar Ibinọkpaabyi, odimbọhk kwọ, ode ẹfa ch'ideden. O Ọvaar Ibinọkpaabyi, atzim ẹfa ch'odimbọhk kwọ asi, ọttattaanga-nọng araami. ");
INSERT INTO mfo_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“K'ededen ch'ẹvaar chọ, akhem anọng p'attaang anang-ọ. Kọ atte ittemdọkhiji sọ ọbọhk, ikwọmi attattaanga-nọng pọ mach'araraari-bukhi. ");
INSERT INTO mfo_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Agwum ọwọhng kwọ, asi atzobha, abe bi pyir, asi p'abhobh-obhobh an-arimi agaangi, mach'echumi, k'esittem asi an-abhakhi arim-orimi. ");
INSERT INTO mfo_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“Ọttattaanga-nọng ọsi ẹmma, oben bi, ‘Kaam ńgubh bẹ ka nnam, mbiri ńgọbha bẹ. Kaam ńchi ọgbọm k'ekpo pyabẹ; Kaam ńchi pyẹ ttara agwọriji paam. Ọkkangkkaang kwaam wọ kwa ńdima mfhu bọng, ńdima ọbọhk kwaam ńdimi bẹ.’ ");
INSERT INTO mfo_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Agwum ọwọhng kwọ, asi anwa akpori bẹ, bẹ atzem k'esiwọr, mach'opo otzemi k'esiwọr. ");
INSERT INTO mfo_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“O Ọvaar Ibinọkpaabyi, k'ottem kw'idik s'anọng akpobh biphyir, mbọng vọ obeng-ọ abẹ? Anyi wọ obeng-ọ abẹ? K'ẹvaar, awurada pọ ayọhng bẹ biphyir, bẹ akhaam ojora fọ, k'ikpokpobha sa bẹ anang-ọ, kọ asi idik s'ipe anọng for. ");
INSERT INTO mfo_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Kọ anemi odimbọhk kwọ kw'ẹfa, irerek imyi attattaanga-nọng pọ. ");
INSERT INTO mfo_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“K'idadaakha sọ s'ini ottotto ikhaam, átzima anọng pa kọ akk'abhekha eden, átzima bẹ eden k'ẹfa chọ, achina k'irukhabe sọ s'awurada. ");
INSERT INTO mfo_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Idibhon íbhaanga idik nna, opoma osi bẹ, ojora ọ́bọkha anọng pa Philistiya. ");
INSERT INTO mfo_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ojora ọ́bọkha avaarnọng p'obhon kw'Edom, opoma ọ́nwa adabhi pa Moab. Ẹfa ẹha avaarnọng pa Kenaan; ");
INSERT INTO mfo_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","opoma ttara ojora ọ́nwa bẹ. K'ẹfa chọ, bẹ amun k'ibe rani, mach'ẹtzakpa matzẹmaa anọng p'akk'akkaana, akwọbha afona, O Ọvaar Ibinọkpaabyi, matzẹmaa anọng p'akk'abhekha akwọbha afona. ");
INSERT INTO mfo_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Kọ átzima anọng mba adim kẹ, abira attima bẹ aranga k'egbegbeho ch'ede chọ. O Ọvaar Ibinọkpaabyi, ibe sa kọ asi mach'irukhabe sọ, ide owurada-họhm kw'asi ttara mbọhk sọ, o Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Ẹvaar ch'Ọvaar Ibinọkpaabyi éwobha, matzẹmaa ogbe ode.” ");
INSERT INTO mfo_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Mada nnyanyaang sa Phero, ọmaana akpaar pẹ pa nnyanyaang mindọr, ọmaana ayari-nnyanyaang pẹ adimi k'asi, Ọvaar Ibinọkpaabyi osi asi p'ọraanga kw'ideden anwa akpori bẹ. Yina, osi anọng p'Israẹl arenga k'irerek k'ottem kw'ọraanga. ");
INSERT INTO mfo_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Mẹ wọ, Miriyam, kw'iwa ode ọsẹ-jaakhi kw'Ibinọkpaabyi, obiro ode ọgbaanọkka kw'Aarọn, ọtzọkha ebin ekhirachẹ, otzima panọng p'Israẹl eden bẹ akhir mbin, abira atzubh. ");
INSERT INTO mfo_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriyam ọkkọhn ọnang bẹ, oben bi; “Bọng kkọhn anang Ọvaar Ibinọkpaabyi, okhuri ekhema-barada chẹ, Kẹ okk'ẹnyanyaang, ọmaana ọyaar-ẹnyanyaang, otzini otzem k'ọraanga kw'ideden.” ");
INSERT INTO mfo_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Mẹ wọ, Mosẹs otzima anọng p'Israẹl eden bẹ abina aji Ẹraanga-khora, achina k'ibe s'anọng an-arukhi sa Shur. Bẹ arenga k'iwu ittaan k'ibe s'anọng an-arukhi, bẹ asi kare. ");
INSERT INTO mfo_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Mada bẹ apyiri ka Mara, bẹ asi pa Mara kafha agwo, okhuri da asi mba ajobh-ojobhi. Kẹ wọ iwa osi bẹ ayeri ibe nna Mara. ");
INSERT INTO mfo_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Mẹ wọ, anọng p'Israẹl anwọhni anang Mosẹs, aben bi, “Mbọng fa mogwo o?” ");
INSERT INTO mfo_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mẹ wọ, Mosẹs obhom ọkpẹkhi Ọvaar Ibinọkpaabyi, Ọvaar Ibinọkpaabyi ọkhọhkh-ẹ ommenkpakpa, kwa Mosẹs odungi ọbhari k'asi, asi p'ajobh-ojobhi an-abhakhi adam-ọdam. Ma Mara, Ọvaar Ibinọkpaabyi ọnang anọng p'Israẹl aphaangi, ọmaana ndọhna k'odem kwa bẹ aruk, obiro oyoma bẹ, ifha ore s'ode na bẹ afha ahok aphaangi pẹ. ");
INSERT INTO mfo_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Oben bi, “Idikha bọng afha átzọhkha ogbe áyong-m itzọhng, asi idik s'itzor-otzor ka chen paam, bọng abira ahok aphaangi paam, kaam bọng ikhọmmana sa nnangi anọng p'Ijip kínang. Kaam wọ nde Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, kw'obin bọng k'ikhọmmana.” ");
INSERT INTO mfo_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Mẹ wọ, anọng p'Israẹl atte Mara ọbọhk achina k'Elim. M'Elim, akhekhaho jobh obhiri afa, ọmaana aji arọbh attaan obhiri jobh awobh mẹ. Wa anọng p'Israẹl akwu abhing abaanga ngekha nnuma. ");
INSERT INTO mfo_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Wa k'iwu chi s'ophe kw'ottong afa, mada anọng p'Israẹl akk'abina k'Ijip, bẹ biphyir abina orenga k'Elim apyiri k'ibe s'anọng an-arukhi sa Sin, s'iwobh k'ottem kw'Ẹlim, ọmaana Sinai. ");
INSERT INTO mfo_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","M'ibe nna s'anọng an-arukhi rọ s'ebhonmọr ch'Israẹl biphyir ẹnwọhni, ẹttaanga anang Mosẹs ọmaana Aarọn. ");
INSERT INTO mfo_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Anọng p'Israẹl aben bẹ bi, “Ira ojibh ọtzam bi, mope ka mbọhk s'Ọvaar Ibinọkpaabyi k'Ijip, kẹ da mowobh ẹwọr ochi nden, ọmaana ẹchakpo ọdọdọk biphyir mach'ọdaakhi man. Yina, bọng akk'man atzima akwu m'ibe nna s'anọng an-arukhi bi, okwo ofhu anọngeya mba biphyir.” ");
INSERT INTO mfo_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Kaam ńdọhm brẹd kw'ótzebh mach'ẹrọng ch'efon k'ọrọngkpakpa nnang bọng. K'ewu kpenamkpen anọng mba ám-ayin k'iyaan atza akpokhi f'obenga bẹ. Kaam ńnenga m'eden nda ńyoma bẹ, ifha nne ode na bẹ átzor ka ndọhna saam.” ");
INSERT INTO mfo_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ottong iwu izadani, bẹ asi ọchattọhk fa bẹ akpokhi, f'ode igbe ifa ka fa bẹ am-akkekkeni akpokhi, k'iwu ọdọdọk. ");
INSERT INTO mfo_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mẹ wọ, Mosẹs ọmaana Aarọn aben anọng p'Israẹl biphyir bi, “Sa k'ẹchọhkha, bọng árong-oronga bi, Ọvaar Ibinọkpaabyi wọ otzim bọng obina k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Bọng abira áre abarada p'Ọvaar Ibinọkpaabyi ore k'ekpebha, okhuri bi, kẹ ọkk'ẹnwọhni cha bọng attaanga anang-ẹ ọbhaanga. Maman ode macha bọng anọng, pa bọng anwọhni, attaanga anang o?” ");
INSERT INTO mfo_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mosẹs obiro oben bi, “Bọng árong-oronga bi, Ọvaar Ibinọkpaabyi wọ, mada ọnang bọng nden sa bọng achi k'ẹchọhkha, ọmaana brẹd kwa bọng aror bi, achi k'ekpebha, okhuri bi, kẹ ọkk'ẹnwọhni cha bọng attaang anang-ẹ ọbhaanga. Maman ode macha bọng anọng, pa bọng anwọhni, attaanga anang o? K'odik ọkkakka, bọng am-anwọhni, attaanga anang Ọvaar Ibinọkpaabyi e, maman arang e.” ");
INSERT INTO mfo_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mẹ wọ, Mosẹs oben Aarọn bi, “Kọ gbaak anọng p'ebhonmọr ch'Israẹl biphyir bi, bẹ arenga ayin Ọvaar Ibinọkpaabyi k'itzitzikha, okhuri bi, kẹ okk'ẹnwọhni chabọng ọbhaanga.” ");
INSERT INTO mfo_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Mada Aarọn ọm-ọgbaak anọng p'ebhonmọr ch'Israẹl biphyir atzim, bẹ akkeri k'ibe s'anọng an-arukhi, are abarada p'Ọvaar Ibinọkpaabyi p'ayini k'eboni. ");
INSERT INTO mfo_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ọvaar Ibinọkpaabyi oben Mosẹs bi, ");
INSERT INTO mfo_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Kaam nkk'ẹnwọhni ch'anọng p'Israẹl mmaanga e. Kọ gbaak bẹ bi, ‘K'ẹchọhkha bọng áchi etzen, k'ekpebha, bọng áchi brẹd maa bọng adọbh. Mẹ wọ kwa bọng átzima áronga bi, kaam wọ nde Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Mẹ wọ, m'ẹchọhkha nduma, ọnọhn oyin k'ọhaabh maa obubha ibhingabe bi waam. K'ekpebha, odiri-bẹrẹbẹrẹ otzebh ọkhọri ibhingabe biphyir. ");
INSERT INTO mfo_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Mada odiri-bẹrẹbẹrẹ okk'odimi, ekpo mach'abubuma eyin ebubha m'irerek bi gbii. k'ibe s'anọng an-arukhi. ");
INSERT INTO mfo_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Mada anọng p'Israẹl are fẹ, bẹ fẹ karong, mẹ wọ, bẹ an-abọbh ayok bi, “Bọng ọttọhk-dema vọ ma?” Mosẹs oben bẹ bi, “Brẹd kw'Ọvaar Ibinọkpaabyi ọnangi bọng bi, bọng achi wọ e. ");
INSERT INTO mfo_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ma wọ ode ndọhna s'Ọvaar Ibinọkpaabyi ọkk'ọnanga bi, ‘Ọnọng-ọnọng okpokhi fẹ mach'ọdaakh-ẹ e. Ọnọng-ọnọng okpokhi ogbobhimbọhk, atzor k'ọnọngmik kw'ikhira sọ.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Wa anọng p'Israẹl asi macha bẹ agbaakhi bẹ. Anọng bani akpokhi k'ọhaabh, bani akpokhi ibebaa. ");
INSERT INTO mfo_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Mada bẹ an-ayom k'agbobhimbọhk, bẹ an-are bi, ayok p'akpokhi k'ọhaabh bẹ kpọng kakpokhi. Ayok p'abira akpokhi ibebaa, bẹ f'ọkhar kpọng kabira akpokhi. Ọnọng-ọnọng okpokhi macha fẹ obeng-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mẹ wọ, Mosẹs oben bẹ bi, “Ọnọng manda wani oningi ọchattọhk mva ohokhi maa ewu ehobha o.” ");
INSERT INTO mfo_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Yina, bẹ ayok bani Mosẹs itzọhng kayong. Bẹ ahok ọchattọhk mva maa ewu ehobha. K'ekpebha fẹ ochu ọnwa nniri, obiro ọttẹwọr ohom. Mẹ wọ e, ettem ẹkhọm Mosẹs etzima etzor bẹ. ");
INSERT INTO mfo_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ekpebhawu kpenamkpen, ọnọng-ọnọng okpokhi macha fẹ obeng-ẹ. Yina, ekpikhira ẹkhọmi, fa bẹ akpokhi arik oyona biphyir. ");
INSERT INTO mfo_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Kẹ ewu ch'ettong izadani, bẹ akpokhi f'ode igbe ifa, ọnọng-ọnọng agbobhi-mbọhk afa. Wa adeho p'obhon atzọkha odik nwa atza agbaak Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Mosẹs oben bẹ bi, “Ma wọ ode ndọhna s'Ọvaar Ibinọkpaabyi ọnangi bi, ‘Ophyini ode ẹwọhngkwokhawu, ẹwọhngkwokhawu ch'awurada ẹnang Ọvaar Ibinọkpaabyi. Mẹ wọ, bọng bọm ọchattọhk kpenamkpen fa bọng abọm, bọng awọhn kpenamkpen fa bọng awọhn. Bọng hok kpenamkpen f'orik maa opyiri ekpebha.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Mẹ wọ, bẹ asi macha Mosẹs ọtzọhni bẹ, bẹ ahok f'orikhi maa ewu ehobha. Wa fẹ kohomi, nniri kobiro ọnwa. ");
INSERT INTO mfo_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mosẹs oben bi, “Bọng chi fẹ mayina, okhuri bi, mayina ode ẹwọhngkwokhawu ọnang Ọvaar Ibinọkpaabyi. Bọng manda vani k'irerek mayina, káre e. ");
INSERT INTO mfo_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Bọng am-akpokhi fẹ k'iwu izadani, yina, ottong iwu izenamfa, kw'ode ẹwọhngkwokhawu, manda vani kóde.” ");
INSERT INTO mfo_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Kaambi mẹ wọ, ottong iwu izenamfa, anọng bani ayin k'iyaan bi bẹ atza akpokhi ọchattọhk, bẹ manda vani kare. ");
INSERT INTO mfo_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Ogbe obhir otzuma yan, kwa bọng ábhum asana paam, ọmaana aphaangi paam ohohok o? ");
INSERT INTO mfo_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Bọng jima bi, Ọvaar Ibinọkpaabyi okk'bọng ẹwọhngkwokhawu ọnanga, kẹ wọ osi ottong iwu izadani, ọm-ọnang bọng brẹd kw'iwu ifa. Ottong iwu izenamfa, ọnọng-ọnọng owobha k'ibe s'owobh. Ọnọng oningi k'iyaan oyini.” ");
INSERT INTO mfo_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Mẹ wọ, anọng mba akwokha ọwọhng k'ewu ch'ettong izenamfa. ");
INSERT INTO mfo_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Wa anọng p'Israẹl ayeri brẹd nwa Mana. Wa fẹ owuri mach'echimọma cha koriyanda, fẹ ọdaam mach'obubhkpa kwa bẹ atzim akhọkhọnana asi. ");
INSERT INTO mfo_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mosẹs oben bi, “Ma wọ ode ndọhna s'Ọvaar Ibinọkpaabyi, ‘Bọng kpokhi ogbobhimbọhk kwa Mana ahok igbọ s'íkwu k'ororo, ifha bẹ are brẹd kw'iwa nnangi bọng achi k'ibe s'anọng an-arukhi, mada ndim bọng mbina k'Ijip.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Mosẹs oben Aarọn bi, “Tọkha ogbobhimbọhk kwa mana awọna k'ogbere. Atzọkha ogbere nwa abera k'itzitzikha s'Ọvaar Ibinọkpaabyi, owobha otzik igbọ s'íkwu k'ororo.” ");
INSERT INTO mfo_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Aarọn osi macha Ọvaar Ibinọkpaabyi okk'Mosẹs ọtzọhna, ọtzọkha ogbere nwa obera k'itzitzikha s'Ẹkkọhbhi cha Echekhi, ifha owobha mẹ. ");
INSERT INTO mfo_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Wa anọng p'Israẹl achi Mana ka cho arọbh afa, maa bẹ apyiri k'irerek s'anọng arukhi. Bẹ achi Mana maa bẹ apyiri k'enem cha Kenaan. ");
INSERT INTO mfo_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Omer ode ogbobhimbọk wani k'agbobhimbọhk jobh p'asi ẹpha kw'ode ọkwakkama. ");
INSERT INTO mfo_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Wa anọng p'ebhonmọr ch'Israẹl biphyir abina k'ibe s'anọng an-arukhi sa Sin, arenga k'obe k'obe mach'Ọvaar Ibinọkpaabyi ọtzọhni bẹ. Bẹ asi ibhingabe ka Rẹphidim, yina, wa asi p'anọng mba agwo, kade. ");
INSERT INTO mfo_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Mẹ wọ, wa bẹ achi Mosẹs akkaam aben bi, “Nang man asi mogwo.” Mosẹs obhina bi, “Bọng am-achi-m akkaam pa mbọng o? Okhuri yan kwa bọng am-akhe Ọvaar Ibinọkpaabyi k'eyoma o?” ");
INSERT INTO mfo_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Yina, wa asi adaak anọng mba maa, bẹ anwọhni attaanga anang Mosẹs, aben bi, “Okhuri yan kw'atzim man, ọmaana va paman, ttara etzirakpo pyaman abina k'Ijip bi, mokwu ope ma k'isi-dadaakha o?” ");
INSERT INTO mfo_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Mẹ wọ, Mosẹs obhom ọkpẹkhi Ọvaar Ibinọkpaabyi, oben bi, “Kaam ńsi yan ọmaana anọng mba o? Ma, bẹ an-ado for sa bẹ atzọbh-m atza.” ");
INSERT INTO mfo_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ọvaar Ibinọkpaabyi obhina Mosẹs bi, “Chi anọng mba eden. Kọ tzima adeho bani p'Israẹl, atzọkha ochikhura kw'atzim abun k'ọraanga kwa Nile, arọhng. ");
INSERT INTO mfo_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Kaam ḿbọ-ọ k'itzitzikha k'itzakpa sa Horẹb. Bun ochikhura kwọ m'itzakpa nna, asi áyin-oyin mẹ p'anọng mba agwo.” Mẹ wọ, wa Mosẹs osi mando, m'itzitzikha s'adeho mba p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Wa Mosẹs oyeri ibe nna Masa, ọmaana Mẹriba, okhuri bi, mẹ wọ kw'anọng p'Israẹl achẹ-ẹ akkaam, bẹ abira ayoma Ọvaar Ibinọkpaabyi aben bi, “Ma Ọvaar Ibinọkpaabyi owobh ma ttara man ma o?” ");
INSERT INTO mfo_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Wa ab'Amalẹk akwu arima anọng p'Israẹl abẹ ka Rẹphidim. ");
INSERT INTO mfo_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mẹ wọ e, Mosẹs oben Joshua bi, “Tzekha ajinọng bani paman, atza arima ab'Amalẹk abẹ. Ophyini kaam ḿbe k'egbegbeho ebir-ebir, ttara ochikhura kw'Ibinọkpaabyi k'ọbọhk kwaam.” ");
INSERT INTO mfo_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Mẹ wọ, Joshua orima ab'Amalẹk abẹ macha Mosẹs ọkk'ẹfa ọnanga. Mosẹs, ọmaana Aarọn, ttara Hur afona achina k'egbegbeho ebir-ebir. ");
INSERT INTO mfo_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ogbe kpenamkpen kwa Mosẹs ọyaangi mbọhk sẹ k'ẹrọng, anọng p'Israẹl akhema. Yina ogbe kpenamkpen kw'ọhak mbọhk sẹ, ab'Amalẹk akhema. ");
INSERT INTO mfo_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","K'ogbe kwa mbọhk nkwok Mosẹs, bẹ atzini ọtza ahokh-ẹ owobha ẹwọr. Aarọn, ọmaana Hur, abọkha mbọhk sẹ atzima k'ẹrọng, ọnọng-ọnọng k'ọbọhk kwẹ. Wa mbọhk sẹ nwobh mando maa ẹchọhkha-kpikhira edimi. ");
INSERT INTO mfo_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Mẹ wọ, wa Joshua otzima ọkkangkkaang okhema agbong-nọng p'Amalẹk. ");
INSERT INTO mfo_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Kọ kkẹr idik nna ka nnwẹr, mach'odik kw'ejima. Akhaambi asi Joshua ọbhaanga kwẹ, okhuri bi, kaam ńdimi che ch'Amalẹk k'ọyagbin biphyir-phyir.” ");
INSERT INTO mfo_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mẹ wọ e, Mosẹs osi ijafọhnibe, oyeri sẹ, “Ọvaar Ibinọkpaabyi wọ ode Okhem kwaam.” ");
INSERT INTO mfo_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Oben bi, “Okhuri da bẹ atzini mbọhk k'ẹrọng atzena k'ẹvaarchi ch'Ọvaar Ibinọkpaabyi. Ọvaar Ibinọkpaabyi wọ órima ab'Amalẹk abẹ k'igbọ k'igbọ.” ");
INSERT INTO mfo_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Wa Jẹtro kw'ode ọfọhnẹja kwa Midiyan, obiro ode otte kwa kwanọng kwa Mosẹs, ọbhaanga odik kpenamkpen kw'Ibinọkpaabyi ọkk'ọsa ọnang Mosẹs, ttara anọng p'Israẹl, ọmaana eden ch'Ọvaar Ibinọkpaabyi okk'orenga ọrọbha anọng p'Israẹl k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Mada Mosẹs okk'kwanọng kwẹ Zipọra ọtzọhma bi, otza ebhinga k'otte Jẹtro, wa otte ọtzọkh-ẹ, ");
INSERT INTO mfo_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ọmaana va pẹ afa. Wa Mosẹs okpe oyok wani Gẹrshọm, oben bi, “Kaam nkk'okhekhenọng nna nda k'irerek s'anọng.” ");
INSERT INTO mfo_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Okpe oyok nwonggo Eliyeza, oben bi, “Ibinọkpaabyi kw'otte kwaam okpobh, wọ iwa ode ọkkaan kwaam. Kẹ wọ ọkkaan-m, ọrọbh-m ka mbọhk sa Phero.” ");
INSERT INTO mfo_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Wa Jẹtro, otte kwa kwanọng kwa Mosẹs otzima va mba afa, ttara kwanọng kwa Mosẹs otza okhebh-ẹ k'ibe s'anọng an-arukhi, kẹ da iwa obhingi, ọbaanga egbegbeho ch'Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Wa okk'ẹkkaabha ọtzọhma ọnang Mosẹs bi, “Kaam Jẹtro, otte kwa kwanọng kwọ, ndim kwanọng kwọ, ttara va pẹ p'ijinọng afa, nkwuma nkwu ngebh-ọ e.” ");
INSERT INTO mfo_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mẹ wọ, Mosẹs okhubh bẹ k'eden, ọrakha ọkhọhkha ikpokpobha, ọbaakha otte kwa kwanọng kwẹ. Bẹ arima ayok, bẹ abira adim k'ikhira. ");
INSERT INTO mfo_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mosẹs ọgbaak otte kwa kwanọng kwẹ odik kpenamkpen kw'Ọvaar Ibinọkpaabyi okk'Phero, ọmaana anọng p'Ijip ọsa ọnang anọng p'Israẹl. Wa obiro ọgbaakh-ẹ ihem sa bẹ akk'are k'eden biphyir, ttara eden ch'Ọvaar Ibinọkpaabyi okk'bẹ ọkkaana. ");
INSERT INTO mfo_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Wa ettem ẹdaam Jẹtro k'idik-jibhada biphyir s'Ọvaar Ibinọkpaabyi ọkk'ọsa, otzima ọrọbha anọng p'Israẹl ka mbọhk s'anọng p'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Oben bi, “Ẹtzọhnga ewobha ẹnang Ọvaar Ibinọkpaabyi kw'ọrọbh bọng ka mbọhk s'anọng p'Ijip ọmaana sa Phero, kw'obiro ọrọbha anọng mba ka mbọhk s'anọng p'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Kaam nkk'nna nnonga bi, Ọvaar Ibinọkpaabyi ọbaari ọyọhnga idik biphyir s'anọng akpobh, osi odik nwa otzima otzor anọng p'age for asi anọng p'Israẹl ọgbaan.” ");
INSERT INTO mfo_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Mẹ wọ, Jẹtro, kw'ode otte kwa kwanọng kwa Mosẹs, otzima ẹnanga ẹkwọmichẹ, ọmaana njafọhni ndọdọk ọnang Ibinọkpaabbyi. Wa Aarọn obiro otzima adeden-nọng p'Israẹl biphyir, ọtza ochi ọchattọhk ttara otte kwa kwanọng kwa Mosẹs k'itzitzikha s'Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Mada ewu en-ehobh, Mosẹs otza owobha ẹwọr bi, ọttọhna aponga p'anọng mba. Anọng mba abe akhọri Mosẹs akhe k'ottem, ttẹwọr k'ekpebha maa ẹchọhkha etto. ");
INSERT INTO mfo_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Mada otte kwa kwanọng ore idik biphyir sa Mosẹs om-osi ọnang anọng mba, ọn-ọbọbh bi, “Mbọng f'am-asi anang anọng mba ma o? Mbọng vọ osi am-attọhna aponga mancheni, anọng mba biphyir am-abir abe akhọr-ọ ttẹwọr k'ekpebha maa ẹchọhkha etto o?” ");
INSERT INTO mfo_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mosẹs obhin-ẹ bi, “Okhuri da anọng am-akwu akhebh-m bi, mphyem ochibhi kw'Ibinọkpaabyi nnang bẹ e. ");
INSERT INTO mfo_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ogbe kpenamkpen kwa bẹ akhaam ngọhr, bẹ am-atzima akwu bi, nttọhna nnang bẹ, mbiri mgbaak bẹ akpebhi, ọmaana aphaangi p'Ibinọkpaabyi.” ");
INSERT INTO mfo_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Otte kwa kwanọng kwa Mosẹs obhina bi, “Kọbaan bi asi mando. ");
INSERT INTO mfo_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ọ́khọn kọ, ọmaana anọng mba p'am-akwu akhebh-ọ ọkhọn e. Ọtzọhm mva ọbari ọyọhng-ọ e, fẹ mancheni kafha asi e. ");
INSERT INTO mfo_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Kọ yong-m itzọhng, ka ndọhna sa kaam ńnang-ọ, tte Ibinọkpaabyi owobha ttara bọng. Kọ akhaambi atzera eho ch'anọng mba, abira atzima ngọhr sabẹ ayin Ibinọkpaabyi k'itzitzikha. ");
INSERT INTO mfo_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Kpebhi bẹ akpebhi ọmaana aphaangi mba, abira akhọkha bẹ eden ch'ẹbaan bi bẹ aruk, ọmaana itzọhmbọhk-dema sa bẹ abaan bi asi. ");
INSERT INTO mfo_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Yina, kọ tzekha ajinọng p'abaan-ọbaana k'ottem kw'anọng mba biphyir, ajinọng p'akhaam ojora f'Ibinọkpaabyi, p'ayok ahokhi k'odik-ọkka, p'attaanga anang ibhora, asi bẹ adeho p'ayok, ka nnọhna nnọhna, ọmaana arọbh azen azen, ọmaana arọbh afa obhiri jobh, ttara ka jobh jobh. ");
INSERT INTO mfo_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Tte bẹ ade attọhn-aponga p'anọng mba k'ogbe kpenamkpen. Tte bẹ atzima aponga kpenamkpen p'agaangi-ọgaangi achen-ọ, yina, tte bẹ akpara aponga p'ikhakhari ka for sabẹ. Mẹ wọ osi ọtzọhm obhekh-ọ, da bẹ an-atzor-ọ ọtzọhm. ");
INSERT INTO mfo_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Idikha asi mando, mach'Ibinọkpaabyi obiro ọtzọhn-ọ, kọ ábe ọtzọhm mva abẹ obe, anọng mba biphyir abira abhana ttara ottemdamiji.” ");
INSERT INTO mfo_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mẹ wọ, Mosẹs oyonga itzọhng ọnang otte kwa kwanọng, osi odik kpenamkpen kw'ọtzọhn-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Mosẹs ọrọbha ajinọng p'abaan-ọbaana k'ottem kw'anọng p'Israẹl biphyir, osi bẹ aho p'anọng mba ka ngaan sa nnọhna nnọhna, ọmaana s'arọbh azen azen, ọmaana s'arọbh afa obhiri jobh, ttara sa jobh jobh. ");
INSERT INTO mfo_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Anọng mba an-ade attọhn-aponga p'ayok k'ogbe kpenamkpen. Anọng atzima aponga p'agaang-ọgaangi achena Mosẹs, yina, bẹ am-akpaara p'ikhakhari ka for sabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Mẹ wọ e, Mosẹs otza orik otte kwa kwanọng kwẹ k'eden. Jẹtro ọbhana ka kẹ k'ekhọma. ");
INSERT INTO mfo_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","K'ophe kw'ottong attaan, mada anọng p'Israẹl akk'abina k'Ijip, m'ewu nduma dani, bẹ apyiri k'ibe s'anọng an-arukhi sa Sinai. ");
INSERT INTO mfo_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Mada bẹ abin ka Rẹphidim, bẹ arenga apyiri k'ibe s'anọng an-arukhi sa Sinai. Wa anọng p'Israẹl abhing mẹ, k'itzitzikha s'egbegbeho nda. ");
INSERT INTO mfo_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mẹ wọ, Mosẹs ovura otza okhebha Ibinọkpaabyi, Ọvaar Ibinọkpaabyi oyer-ẹ k'egbegbeho, oben bi, “Ma wọ ode odik kw'ágbaak va pa va pa Jekọb, ọmaana anọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Bọbọng ọkhaam akk'idik ara sa nnsi Ijip, ọmaana eden cha ndini bọng k'ẹrọng mach'ikyenọhn itzini va pẹ ka mbabaang, ndima nkwu ma da kaam nwobh. ");
INSERT INTO mfo_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Mẹ wọ, idikha bọng akhakha eho k'ettem obungichẹ, bọng abira ahok echekhi chaam, k'ottem kw'idibhon biphyir, bọng áde anọng pa kaam nhokhi ettem, kaambi ode bi oyagbin biphyir ọkhaam kaam. ");
INSERT INTO mfo_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Bọng áde obhon kwaam kw'afọhni-nja, ọmaana obhon kw'awurada.’ Ma wọ ode atzim p'agbaak anang anọng p'Israẹl.” ");
INSERT INTO mfo_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mẹ wọ, Mosẹs ọkpa nnam okwu otzobha adeden-nọng p'anọng mba, ọtzọkha atzim biphyir p'Ọvaar Ibinọkpaabyi ọkk'ẹ ọtzọhna bi ọgbaak, ọgbaak bẹ. ");
INSERT INTO mfo_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Anọng mba biphyir an-abhina k'ogbe wani bi, “Ḿosi odik kpenamkpen ósi mach'Ọvaar Ibinọkpaabyi okk'obena.” Mẹ wọ e, Mosẹs ọkpa nnam ọtza ọgbaak Ọvaar Ibinọkpaabyi ebhina chabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Kaam nhakha ndor-ọ k'eboni ch'epyi bi kaang, ifha anọng mba ábhaanga da mgbaak atzim ttar-ọ, bẹ áphennam ka kọ.” Mẹ wọ, Mosẹs ọn-ọgbaak Ọvaar Ibinọkpaabyi ebhina ch'anọng mba akk'ananga. ");
INSERT INTO mfo_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Kpa nnam atza akhebha anọng mba, hok bẹ awur-owur mayina ttara ophyini. Tte bẹ agbobhi ọbara fabẹ fa for, ");
INSERT INTO mfo_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","bọng ado for k'ewu ch'ettong ittaan, okhuri bi, Ọvaar Ibinọkpaabyi ọ́hakha k'egbegbeho cha Sinai m'ewu nduma k'ibe s'anọng biphyir arẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Kọ khe enem akhọri egbegbeho nda, abira agbaak bẹ bi, ‘Bọng tọkha ogbe kwabọng o, ọnọng oningi egbegbeho nda ovur o, yina ira ọn-ọttọhmi chẹ ọttọhmi. K'odik-ọkka, onong kpenamkpen kw'ọttọhmi egbegbeho nda, bẹ áfhẹ-ẹ ofhu. ");
INSERT INTO mfo_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Kẹ bẹ átzọbh-ẹ atza, asi mẹ bẹ akhum-ẹ akhọhn, bẹ kẹ ọbọhk kabun. Ode ọnọngẹya, obiro ode etzen o, kọbaan bi, bẹ attẹ-ẹ ọbọhk oruk akpen.’ Oyongi bi, bẹ agyi ẹha ch'erukhimaan-dim k'ogbe-bhirada, mẹ kwa bẹ afha arenga abaanga egbegbeho nda.” ");
INSERT INTO mfo_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mẹ wọ, mada Mosẹs okk'm'egbegbekho nda ọhakha, okwu osi anọng mba awur, bẹ abira agbobhi ọbara fabẹ fa for. ");
INSERT INTO mfo_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","On-oben bẹ bi, “Bọng do for atzik ottong iwu nttaan. Bọng ayok abẹ kayima.” ");
INSERT INTO mfo_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","K'ekpebha ch'ewu ch'ettong ittaan, ẹbhaangkpon ẹtta, ebira ẹmani, eboni ch'epyi bi kaang ebubha egbegbeho ebir-ebir, obukpọhng obiro ogyi k'ẹrọng bi pooom, opoma osi ọnọng kpenamkpen k'ibhingabe. ");
INSERT INTO mfo_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mẹ wọ, Mosẹs otzima anọng mba obina k'ibhingabe, bẹ atza akhebha Ibinọkpaabyi, bẹ abe k'egbegbeho-rin. ");
INSERT INTO mfo_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Irorong ibubha egbegbeho cha Sinai, okhuri bi, Ọvaar Ibinọkpaabyi ọhak m'egbegbeho nda k'ekpon. Irorong nna ivura k'ẹrọng mach'irorong s'ekpon ch'ẹwọm-ọwọma, egbegbeho nda biphyir enyingi itzama-itzama. ");
INSERT INTO mfo_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ẹmọng ch'obukpọhng en-edo ẹtza-ọtza. Mẹ wọ e, Mosẹs ọgbaak atzim, Ibinọkpaabyi otzima ẹbhaangkpon obhin-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ọvaar Ibinọkpaabyi ọhakha k'egbegbekho cha Sinai ebir-ebir, oyeri Mosẹs bi, ovura okhebh-ẹ kẹ. Mẹ wọ, Mosẹs ovura, ");
INSERT INTO mfo_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Kọ hakha atza atzọr anọng mba itzọhng, ifha bẹ aningi eden arori cha bẹ akwu are Ọvaar Ibinọkpaabyi, ofona mẹ, haabhada ape. ");
INSERT INTO mfo_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Kaambi afọhnẹja p'areng afora Ọvaar Ibinọkpaabyi bọ, bẹ akhaambi ahok for sabẹ, iwur-owur, oni mando ode, Ọvaar Ibinọkpaabyi ọ́nang bẹ ettuma.” ");
INSERT INTO mfo_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mosẹs oben Ọvaar Ibinọkpaabyi bi, “Anọng mba k'egbegbeho cha Sinai kafha arenga abaanga, okhuri bi, kọ ọkhaam wọ atzọri man itzọhng bi, ‘Kẹ enem akhori egbegbeho nda, ahok chẹ ewur-owur.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ọvaar Ibinọkpaabyi obhina bi, “Kọ hakha atza atzima Aarọn akwu. Yina, afọhnẹja, ọmaana anọng mba kakhaambi atzima ẹkhaari avura akwu k'Ọvaar Ibinọkpaabyi, oni mando ode, kẹ ọnang bẹ ettuma.” ");
INSERT INTO mfo_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mẹ wọ e, Mosẹs ọhakha okwu okhebha anọng mba, ọgbaak bẹ idik s'Ọvaar Ibinọkpaabyi okk'obena. ");
INSERT INTO mfo_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Mẹ wọ, Ibinọkpaabyi ọgbaak atzim mba biphyir, oben bi: ");
INSERT INTO mfo_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Kaam wọ nde Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, kw'otzim bọng obina k'Ijip, k'irerek s'ebira. ");
INSERT INTO mfo_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Bọng idik ọdọdọk kàkpobha, kw'oyongi kaam. ");
INSERT INTO mfo_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Bọng ọgbatza kàgwa kw'ókher ọttọhk kpenamkpen f'owobh k'ẹrọng, ode bi fẹ owobh k'irerek, fẹ obiro owobha k'asi ẹtzaanga. ");
INSERT INTO mfo_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Bọng nho kàhakha anang agbatza mba, bọng bẹ kàbira akpobha, okhuri bi, kaam Ọvaar Ibinọkpaabyi, kwa nde Ibinọkpaabyi kwabọng, nde Ibinọkpaabyi kw'ọkhaam ottem-mamma, kw'ọm-ọnang va ọmmọmma k'itzama s'ab'otte, maa apyiri mgbọmma nttaan, ọmaana mgbọmma nna s'anọng p'attaang-m. ");
INSERT INTO mfo_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Yina, kaam mingọhkha idadaakha nnang mgbọmma nnọhna-nnabhik sa ngaam idadaakha ttar-m, mbiri nhok asana paam. ");
INSERT INTO mfo_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Bọng che ch'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng k'elulukhiden kàtzima, okhuri bi, Ọvaar Ibinọkpaabyi kóbina ọnang, ọnọng kw'olukhi che chẹ. ");
INSERT INTO mfo_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Bọng jima Ẹwọhngkwokhawu bi, bọng ahok chẹ mach'ewuradawu anang Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Bọng dima iwu izadani asi itzọhm sabọng biphyir, ");
INSERT INTO mfo_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","yina, ottong iwu izenamfa, ode Ẹwọhngkwokhawu ch'ikpokpobha anang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng. M'ewu nda, ọnọng manda wani, kaambi kọ wọ, ode nnwa kwọ kw'ijinọng, ode kw'ikwanọng, ode ọtzọhmnọng kwọ kw'ijinọng, ode ọtzọhmnọng kw'ikwanọng, ode etzirakpo pyabọng, obiro ode okhekhennọng kw'orukhi k'ottem kwa bọng, oningi ọtzọhm osi. ");
INSERT INTO mfo_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ọvaar Ibinọkpaabyi otzim iwu izadani osi ẹrọng ọmaana irerek, ọmaana ọraanga kw'ideden, ttara ọttọhk kpenamkpen f'owobh k'ẹtzaanga kwabẹ, yina, ottong iwu izenamfa okwokha ọwọhng. Mẹ wọ, Ọvaar Ibinọkpaabyi odo Ẹwọhngkwokhawu nda, ohok chẹ mach'ewuradawu. ");
INSERT INTO mfo_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Bọng kpobha abatte, ọmaana abakka, ifha bọng aruk akpen p'adum-odum k'irerek s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọ́nang bọng. ");
INSERT INTO mfo_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Bọng ọnọng kàfhu. ");
INSERT INTO mfo_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Bọng ọtta kàtzam. ");
INSERT INTO mfo_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Bọng oribh kàfhu. ");
INSERT INTO mfo_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Bọng nttẹsẹ kw'ibhora kàbe. ");
INSERT INTO mfo_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Bọng ihọhm s'ayok, ọmaana panọng p'ayok, kaambi ode ọtzọhmnọng kwẹ kw'ijinọng, obiro ode kw'ikwanọng, ode ẹbhaam chẹ, ode ẹnyanyaang, obiro ode ọttọhk kpenamkpen f'oyok, k'ẹfa kàtzọkha.” ");
INSERT INTO mfo_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Mada anọng mba are da ẹbhaangkpon ẹmani, ebire ẹtto etzum, bẹ abhaanga da obukpọhng ogyi, bẹ abira are irorong k'egbegbeho ebir-ebir, opoma osi bẹ, bẹ afọni. Mẹ wọ, bẹ an-abe k'odenmir, ");
INSERT INTO mfo_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","aben Mosẹs bi, “Kọ ọkhaam ma for sọ, gbaak atzim anang man, kkeri m'oyong-ọ itzọhng oyonga. Yina, Ibinọkpaabyi ọbọhk kàtte ọgbaak atzim ọnang man, na mókwu ope.” ");
INSERT INTO mfo_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mosẹs oben anọng mba bi, “Ojora oningi bọng osi, kkeri Ibinọkpaabyi ọkk'ọkwa bi okwu oyoma bọng, ifha bọng akhaama ojora fẹ, f'ósi bọng arọbh aji ẹkhọngkwuri osisi.” ");
INSERT INTO mfo_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Anọng mba awobha k'odenmir, mada Mosẹs oreng ọbaanga eboni ch'epyi bi kaang, kẹ da Ibinọkpaabyi owobh. ");
INSERT INTO mfo_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Kọ gbaak anọng p'Israẹl bi, ‘Bọng akk'ara ka bọng ọkhaam ka for bi, kaam nkk'k'ẹrọng nwobha mgbaak bọng atzim. ");
INSERT INTO mfo_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Bọng gol, ọmaana silva kàtzima agwa agbatza pa bọng akpobha, ebengambọhk ttara kaam. ");
INSERT INTO mfo_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“‘Bọng dima idọdọhbh asi ijafọhnibe, bọng asi ẹjafọhni ẹkwọmichẹ mẹ, ọmaana ẹnanga ch'odidiri, ch'arukhimaan, ọmaana ch'avu, ttara ch'andaamogbodo anang-m. K'ibe kpenamkpen sa kaam ńsi bi ide ikpokpobhabe ka che chaam, kaam ńhakha ńkwu nkebha bọng, ḿbiri ńdo bọng. ");
INSERT INTO mfo_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Idikha atzim atza asi ijafọhnibe anang-m, atza pa bẹ akk'adokha kàtzima, okhuri bi, atzim atza pa bẹ adokh-odokha, akk'sẹ akhibhi. ");
INSERT INTO mfo_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Bọng ka mbarimmo kàrenga avura k'ijafọhnibe saam ebir-ebir, ifha bọng aningi sẹ irinikhum sabọng akhọk.’ ");
INSERT INTO mfo_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Ma wọ ode aphaangi p'ánang anọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Idikha adebhi obira kw'ode oHiburu-nọng, kẹ ósi ọtzọhm k'irekh-irek kwọ ka cho azadani. Yina, ottong cho azenamfa, kẹ ọ́naanga ebira, ọttọhk kpenamkpen kọ́nang. ");
INSERT INTO mfo_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Idikha okwu mancheni, ọ́kpa nnam mancheni. Yina, otzim kwanọng kwẹ okwu, kẹ obiro ọ́kpa nnam ttara kwanọng kwẹ. ");
INSERT INTO mfo_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Idikha itta kwẹ ọnang-ẹ obira wani kwẹ kw'ikwanọng bi, ọtzọkha, ọmmaan-ẹ va p'ijinọng, ttara p'ipanọng, kwanọng nwuma ttara va pẹ án-ade p'itta kwẹ, ojinọng kẹ-khẹ wọ ófona ọbhana. ");
INSERT INTO mfo_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Yina, idikha obira nwuma osi ẹjaakhi bi, ‘Kaam itta kwaam, ọmaana kwanọng kwaam, ttara va paam adaakh-m ọdaak, kokher bi ọnaanga ebira,’ ");
INSERT INTO mfo_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","itta kwẹ ọkhaambi otzim-ẹ ọtza ọkhọkha akpaar-aponga. Kẹ ótzim-ẹ ochina k'ẹkpọmmachi ch'ẹhọmma, ọ́ju-ẹ itzọhng ttara ejum. Mẹ wọ, ón-ode kwẹ k'akpen pẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Idikha ọnọng ọtzọk nnwa kwẹ kw'ikwanọng okpe k'ebira, ominanwa nwa mach'obira kw'ijinọng om-ofona k'idukhi, kófona. ");
INSERT INTO mfo_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Idikha ominanwa nwa oni itta kwẹ idik ọdaakhi, tte kẹ ọttẹ-ẹ ọbọhk, bẹ abhekh-ẹ k'ebira. Itta kwẹ ẹfa kọkhaam bi, ọkpẹ-ẹ ọnang okhekhennọng, okhuri bi, itta nwa kwẹ, echekhi ch'ọnangi obira nwa kohokhi. ");
INSERT INTO mfo_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Idikha ọtzọhk ominanwa nwa ọnang nnwa kwẹ kw'ijinọng, kẹ ósi macha bẹ am-asi anang va p'ipanọng. ");
INSERT INTO mfo_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Mẹ wọ, obiro ọtzọkha kwanọng ọdọdọk, kẹ kọ̀khaambi ọrọbha ocheden kwanọng chen, ọnang-ẹ ọchattọhk, ọnang-ẹ ọbara fa for, ttara eyima. ");
INSERT INTO mfo_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Idikha kẹ oni kwanọng nwa ekpo mbya ẹttaan ọnangi, kwanọng nwa ọbaan bi, ọbhana k'idukhi, ogbukha manda wani kọ̀nang k'ẹnaanga chẹ. ");
INSERT INTO mfo_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Ọnọng kpenamkpen kw'obuni oyok ọttọhk, ọfhẹ-ẹ, kẹ bẹ abira áfhẹ-ẹ ofhu. ");
INSERT INTO mfo_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Yina, idikha oni k'ọgbaan otzim ọfhẹ-ẹ, da kwẹ ode bi, Ibinọkpaabyi wọ otte kwẹ ọbọhk otto, tte kẹ ọrọbh otza ochubha k'ibe sa kaam ńdekha. ");
INSERT INTO mfo_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Yina, ọnọng on-obiro ọkham oyok, ọfhẹ-ẹ k'ọgbaan, bọng dim-ẹ abina aji ijafọhnibe saam, atza afhẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Ọnọng kpenamkpen kw'ofhu otte, oyongi mẹ, obiro ofhu ọkka, bẹ akhaambi afhẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Ọnọng kpenamkpen kw'ofu ọnọngẹya, ode bi okpẹ-ẹ okpe, obiro ode bi, bẹ akhebh-ẹ ttara ọnọng nwuma ka mbọhk, bẹ akhaambi afhẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Ọnọng kpenamkpen kw'ọnangi otte ẹmma, obira ode bi ọnangi ọkka ẹmma, bẹ akhaambi afhẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Idikha anọng afa asi ẹkhọhr, oyok wani ọtzọbh oyok ọtza, oyongi mẹ obun-ẹ ẹbọhkduk, maa oyok oyima ọkhọhmmana, ");
INSERT INTO mfo_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","kẹ kw'obuni oyok ẹbọhkduk ọmmamma kọ̀tzọkha, idikha oyok ọnang ẹbọhkduk nduma, obina orenga ttara ochikhura kwẹ, kẹ ọ́mọnga agbukha ọnang oyok, k'ogbe kw'okk'oyok okhibhi, obiro ókker-ẹ maa, for igaang-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Idikha ọnọng ottumi obira kwẹ kw'ijinọng, obir ode kw'ikwanọng ttara ochinnwa, maa ope ka mbọhk sẹ, bẹ akhaambi bẹ anang ọnọng-dema nwuma ọmmamma. ");
INSERT INTO mfo_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Yina, idikha obira nwuma ọnang ngwur nnuma, ode ewu dani o, obiro ode iwu ifa o, ọkhaam-obira nwa ọmmamma kọ̀tzọkha, da obira nwa ode agbukha pẹ. ");
INSERT INTO mfo_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Idikha ajinọng afa arim-erima, bẹ atza abun kwanọng kw'otzim ibhọr ọttọhk, ofona mẹ, ibhọr nna iyin, da ogbe kwẹ on-otzim obenga, yina, ọttọhk f'ọbar-ọbar komum, otzukha kpenamkpen kw'odim kwa kwanọng nwa ọkpaar, esobh ebire ekhera, mando kw'ótzuk. ");
INSERT INTO mfo_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Yina, idikha kwanọng nwa omum ekpo k'idendama, tzima akpen atzera akpen, ");
INSERT INTO mfo_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ọju-ẹ chen, bẹ aju-ẹ chen, ọkpaar-ẹ ọbọhk, bẹ akpaar-ẹ ọbọhk, ọrọbh-ẹ ẹha, bẹ arọbh-ẹ ẹha, ọkpaar-ẹ obho, bẹ akpaar-ẹ obho, ");
INSERT INTO mfo_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ọkwọm-ẹ ekpon, bẹ akwọm-ẹ ekpon, omum-ẹ ọttọhk, bẹ amum-ẹ ọttọhk, owong-ẹ owonga, bẹ atzukha ttara ewonga. ");
INSERT INTO mfo_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Idikha ọnọng ottumi obira kwẹ kw'ijinọng, kaambi obiro ode kw'ikwanọng ka chen, ọju-ẹ chen, kẹ ọkhaambi otte obira nwa ọbọhk ofona k'idukhi, okhuri chen ch'oju-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Idikha ọnọng ottumi obira kwẹ, kw'ijinọng, kaambi obiro ode kw'ikwanọng, ọrọbh-ẹ ẹha, kẹ ọkhaambi otte obira nwa ọbọhk ofona k'idukhi, okhuri ẹha chẹ ch'ọkk'ọrọbha. ");
INSERT INTO mfo_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Idikha ọbhaamdim okhumi ọnọng abhik, ode ojinọng, obiro ode kwanọng maa ope, bẹ akhaambi atzọbh ọbhaamdim-dema nwa atza maa ope, etzen chẹ k'ẹchaa kẹ̀baan. Kaambi mẹ wọ, ọkhaam-ọbhaamdim nwa, odik koji. ");
INSERT INTO mfo_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Yina, idikha ọbhaamdim nwa okk'anọng abhik om-okhuma, bẹ atzọr ọkhaam itzọhng, yina, chẹ kọ̀bọhk okhe k'ikwuri, maa chẹ efhu ọnọng, bẹ atzọbh ọbhaamdim nwa atza maa ope, bẹ abira afhu ọkhaam-ẹbhaamdim. ");
INSERT INTO mfo_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Mẹ wọ, idikha bẹ akpaar otzukha anang-ẹ, kẹ ọkhaambi da otzuk kpenamkpen fa bẹ akpaar anang-ẹ, ifha otzima obhek akpen pẹ. ");
INSERT INTO mfo_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ọphaangi nwa obiro obe ọnang bi, idikha ọbhaamdim okhumi nnwa kw'ijinọng, obiro ode nnwa kw'ikwanọng obhik, ọfhẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Idikha ọbhaamdim okhumi obira kw'ijinọng, obiro ode obira kw'ikwanọng obhik, ọkhaam-ọbhaamdim ọkhaambi ọnang ọkhaam-obira, ashẹkẹl ẹrọbh obhiri jobh p'asilva, bẹ akhaambi abira atzọbh ọbhaamdim nwa atza maa ope. ");
INSERT INTO mfo_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Idikha ọnọng otzumi ipekhuma otte eje, ode ẹbhaam, ode bi ẹnyanyaang dọ, etto k'ẹtzaanga, ");
INSERT INTO mfo_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ọnọng kw'otzumi ipekhuma nna, ọkhaambi ọtzuk ọnang ọkhaam-ẹbhaam, kẹ ọ́tzọkha otzen-bukhi. ");
INSERT INTO mfo_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Idikha ọbhaamdim kw'ọnọng omum ọbhaamdim kw'oyok ọttọhk ọfhẹ-ẹ, bẹ akhaambi akpe ọbhaamdim kw'owobh akpen, akkema agbukha, bẹ abira akkema otzenbukhi ebengambọhk. ");
INSERT INTO mfo_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Yina, idikha anọng arong bi, ọbhaamdim nnwa okk'anọng abhik om-okhuma, yina, ọkhaam-ẹbhaam chẹ kọ̀bọk okhe k'ikwuri, ọkhaam-ẹbhaam ótzima ẹbhaam otzuk ẹbhaam, ọbhaam-bukhi ón-ode kwẹ. ");
INSERT INTO mfo_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Idikha ọnọng ofhu ẹbhaam, obiro ode orukhimaan, ọfhẹ-ẹ, ode bi okpẹ-ẹ okpe o, kẹ ọkhaambi otzuk abhaam azen k'ẹbhaam dani, arukhimaan anna k'orukhimaan wani. ");
INSERT INTO mfo_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Idikha bọng abọk oriribha da ọm-ọvọkhi ibe k'erungi, attum-ẹ maa ope, ọnọng kw'ottum-ẹ, iponga s'ẹnọngmon kẹ kípyibh. ");
INSERT INTO mfo_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Yina, idikha ọfhẹ-ẹ da ewu ekk'ekhobha, aponga p'ẹnọngmon akk'ẹ ipyibha e. “Oriribha ọkhaambi orik ọttọhk kpenamkpen f'ofhu, idikha ọn-ọttọhk ọkhaam, bẹ akhaambi akpẹ-ẹ atzima atzera eho ch'ọttọhk f'ofhu. ");
INSERT INTO mfo_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Idikha bẹ are etzen ch'ofhu da etzim erukhi akpen ka mbọhk sẹ, ode ẹbhaam, ode ẹnyanyaang, obiro ode orukhimaan o, kẹ ọkhaambi otzuk chẹ k'igbe ifa. ");
INSERT INTO mfo_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Idikha ọnọng otzim etzirakpo pyẹ bi, ọtza ọnang ọchattọhk, ettena ẹtza echi owoni, obiro ode owoni kw'ọnọng kwa grep o, kẹ ọkhaambi da otzuk ekpo py'ọnọng nwa, ttara ekpo ọkkakka py'efon k'owoni kwẹ kw'agrep. ");
INSERT INTO mfo_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Idikha ọnọng okhumi owoni kwẹ, kw'ọwọhm maa ojekha k'owoni kw'oyok, ekpon ẹkwọmi ekpo py'oyok ọyaabh, obiro ode py'oyok ọkk'ọpha otzobha, ọnọng kw'okhe ekpon nda, ọkhaambi otzuk oyok ekpo pyẹ py'ẹkwọmi. ");
INSERT INTO mfo_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Idikha ọnọng ọnangi oyok asilva, obiro ode ekpo ẹdọdọk bi, oye, bẹ akhebha pyẹ k'ọhọhm kw'oyok afhu, bẹ abọk oriribha nwuma, oriribha nwuma ọkhaambi bi ótzuk pyẹ k'igbe ifa. ");
INSERT INTO mfo_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Yina, idikha bẹ ani oriribha nwuma abọk, ọkhaam-ọhọhm ọkhaambi obe k'itzitzikha s'Ibinọkpaabyi, ifha ọgbaak s'okk'ekpo py'oyok ọfha. ");
INSERT INTO mfo_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","K'aponga biphyir p'akhuri oribh f'ẹbhaam, ọmaana f'ẹnyanyaang, ọmaana f'orukhimaan, ttara f'ibara, obiro ode f'ọttọhk kpenamkpen f'ọnọng obeni bi, ‘Faam vọ’, anọng mba afa p'akkaan ọttọhk mva, akhaambi abe k'itzitzikha akpaar-aponga. Ọnọng kw'aponga apyibhi, ọkhaambi otzuk k'igbe ifa ọnang oyok. ");
INSERT INTO mfo_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Idikha ọnọng otziri oyok ẹnyanyaang, ode ẹbhaam, ode orukhimaan, obiro ode otzirattọhk kpenamkpen, fẹ ope, ode bi, bẹ amum fẹ ọttọhk, obiro ode bi, fẹ odim-odimi o, da bẹ ani otzum akhe, ");
INSERT INTO mfo_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","bẹ anọng afa atzọkha ọnwọhngi k'itzitzikha s'Ọvaar Ibinọkpaabyi bi, oyok ọttọhk fẹ ọbọhk kọttọhmi. Ọkhaam-ọttọhk ọkhaambi okhera mando, otzukha ma kode. ");
INSERT INTO mfo_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Yina, idikha bẹ an-abira afhu otzirattọhk mva ofhu, oyok kw'oyok otziri ọttọhk ọkhaambi otzuk fẹ, ọnang ọkhaam. ");
INSERT INTO mfo_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Idikha ode bi etzen ch'ẹtzam dọ ẹfhu otzirattọhk mva, ẹjaakhi fẹ k'abir-ibiri, oyok kw'oyok otziri ọttọhk, ọ́tzọkha abiri-biri p'etzen nda p'arikhi mach'ẹkhọhkha, bẹ kẹ kábọkha bi, ótzuk otzirattọhk f'ọkk'ọpa. ");
INSERT INTO mfo_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Idikha ọnọng ọyaami otzirattọhk f'oyok, bẹ amum fẹ ọttọhk, ode bi fẹ opope, k'ogbe kw'ọkhaam on-ode, ọnọng kw'ọyaami fẹ, ọkhaambi otzuk ọnang ọkhaam. ");
INSERT INTO mfo_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Yina, ọkhaam owobh mẹ ttara otzirattọhk mva, ọnọng kw'ọyaami fẹ kótzuk. Idikha ọyaami otzirattọhk mva k'agbukha, agbukha p'otzim ọyaam fẹ, atzera otzirattọhk mva f'odimi. ");
INSERT INTO mfo_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Idikha ojinọng ọbọhr ominanwa kw'oni ojinọng otzim oronga, oyim-ẹ abẹ k'ẹfa, ọkhaambi osi imina sẹ, ominanwa nwa ón-ode kwanọng kwẹ. ");
INSERT INTO mfo_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Idikha otte kw'ominanwa nwa obhumi biphyir-phyir bi, ọnang-ẹ nnwa kwẹ k'ọbada, ojinọng nwa ọkhaambi da osi imina otzor k'ominanwa kw'oni ojinọng otzim oronga. ");
INSERT INTO mfo_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Bọng kwanọng kw'osi mbọng ọbọhk kàtte oruk akpen. ");
INSERT INTO mfo_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Ọnọng kpenamkpen kw'oyim etzen abẹ, ọbaan bi, bẹ afhẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Ọnọng kpenamkpen kw'ọfọhni ẹja ọnang ọkhak, okhiri Ọvaar Ibinọkpaabyi oji, ọbaan bi, bẹ adim-ẹ mebubuni. ");
INSERT INTO mfo_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Bọng okhekhennọng ọgbaan kàsi, bọng kẹ ihem kabira kanang, okhuri bi, wa bọbọng akk'akhekhennọng ada k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Bọng opopa kwanọng, ọmaana opfu-nwa chen kàsi. ");
INSERT INTO mfo_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Idikha bọng asi bẹ chen, bẹ abhom ayer-m, k'odik-ọkka kaam ḿmaanga ẹmọng chabẹ ọbhaanga. ");
INSERT INTO mfo_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Mbiri ńgọhkha ittemdọkhiji saam, mbiri ḿfhu bọng ttara ọkkangkkaang. Panọng pabọng án-ade apopa, va pa bọng abira áde apfu-va. ");
INSERT INTO mfo_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Idikha bọng abhori ọnọng kpenamkpen kwaam, kw'owobh k'owora ka bọng kw'ottem agbukha, bọng iru kàkhe mach'ọnọng kw'om-obhor anọng agbukha om-osi. ");
INSERT INTO mfo_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Idikha atzọk owura-baba kw'oyokh-ẹbaanga kwọ mach'ebhikha, rik chẹ yina ẹchọhkha etto, ");
INSERT INTO mfo_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","okhuri bi, chẹ-chẹ dọ ch'om-otzima obubha for e. Mada oyima, mbọng f'obubha, ani chẹ arikh o? Mada obhom oyer-m, kaam ḿmaang-ẹ ọbhaanga, okhuri da kaam ngaam inọngkwo. ");
INSERT INTO mfo_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Bọng Ibinọkpaabyi kàlukhi. Bọng ọbaabhi kw'anọng pabọng, ẹmma kabira anang. ");
INSERT INTO mfo_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Bọng ẹnanga ch'ọhọhm kw'ọchattọhk fabọng, obiro ode kw'atzuk pabọng kàbọkha atzima. “Bọng akhaambi anang-m achedenva pabọng p'ijinọng. ");
INSERT INTO mfo_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Eden nduma dani dọ cha bọng asi ttara abhaam, ọmaana arukhimaan pabọng. Tte bẹ awobha ttara abọkka k'iwu izenamfa, yina, ottong iwu izenanttaan, bọng dọkha bẹ anang-m. ");
INSERT INTO mfo_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Bọng bọ áde anọng paam p'awur-owur. Mẹ wọ, bọng etzen cha nden s'ẹtzam mfhu, njaakhi k'abirbiri kàchi, bọng dọkha abhari anang mpfa. ");
INSERT INTO mfo_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Bọng ibhora kàkpaanga agbaak. Bọng kakhaambi abe obibyanọng ka nnam bi, an-ade nttẹsẹ kw'ibhora. ");
INSERT INTO mfo_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Bọng ọhaabh abẹ kàtzọn asi odik kw'on-otzori. Ogbe kwa bẹ abe nttẹsẹ k'opongahọhm, bọng ọhaabh abẹ kàtzọn asi ibhora, atzima abhakhi aponga ewobha. ");
INSERT INTO mfo_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Bọng nkwu-osisi abẹ kàrenga atza abe nttẹsẹ kw'ogbogbora k'esobh, k'ogbe kw'osi odik kw'oni ojibhi. ");
INSERT INTO mfo_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Idikha ọnọng ore ẹbhaam, obiro ode ẹnyanyaang ch'ọttattaanga-nọng kwẹ ch'etten eden, bọkha chẹ achena ọkhaam. ");
INSERT INTO mfo_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Idikha ọnọng are ẹnyanyaang ch'ọttattaanga-nọng kwẹ, ch'en-etto ttara ẹtzọhkha, chẹ ọbọhk kàtte. Kọ re bi akkaana ẹ, ọmaana ẹnyanyaang chẹ. ");
INSERT INTO mfo_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Aponga p'ajibhi agbogbora kàbọkha abhakhi k'esobh. ");
INSERT INTO mfo_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Kọ ọnọng odik kàbubha, ọnọng kw'ọgbaakhi odik ọkkakka kàfhu, kkeri kaam ọnọng kw'aponga apyibhi, ọbọhk kíntte. ");
INSERT INTO mfo_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Ọnọng oningi ngwu ochi, okhuri bi, ngwu mkpa ọnọng chen bi, oningi odik ọkkakka ore, mbiri mbọkha ọwọhng kw'ọnọng kw'otzor-otzor mmakhi. ");
INSERT INTO mfo_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Bọng okhekhennọng ihem kànang, okhuri bi, bọbọng arong odem kw'ekhekhen ẹmma epyiri kẹ, da iwa bọng akk'akhekhennọng ada k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Bọng ayaabha iwoni sabọng ka cho azadani, bọng abira apha ekpo pya bọng ayaabh. ");
INSERT INTO mfo_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Yina, ottong cho azenamfa bọng tte ẹtzam ọbọhk ekhuri, bọng ọttọhk kpenamkpen mẹ kàsi, ifha ekpo py'émen mẹ éde ọchattọhk ẹnang agbogbora p'arukhi ttara bọng. Nden s'ẹtzam mbiri chi ekpo pya bẹ atzọk arik. Bọng ási mando ttara iwoni sabọng s'agrep, ọmaana s'oliv. ");
INSERT INTO mfo_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Bọng si ọtzọhm k'iwu izadani. Yina, ottong iwu izenamfa bọng ọtzọhm kàsi, ifha abhaam pabọng, ọmaana nnyanyaang sabọng, ọmaana abira p'am-asi ọtzọhm anang bọng, ọmaana akhekhennọng p'arukhi ttara bọng afha akwokha for. ");
INSERT INTO mfo_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Bọng dọkha ogbe ahok odik kpenamkpen kwa kaam nkk'bọng mgbaakha. Bọng che p'akha kàyeri, tte ọnọng oningi che p'akha mba k'ẹmma chabọng ọbhabhaanga-ọbhaang. ");
INSERT INTO mfo_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Igbe ittaan ka cho kpenamkpen, bọng ám-asi ẹyaanga ch'ọdadaami, anang-m. ");
INSERT INTO mfo_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Bọng si Ọdadaami kwa Brẹd kwa bẹ ani yist akhe anang-m. K'iwu izenamfa bọng chi brẹd kwa bẹ ani yist akhe, macha ndọhni bọng. Bọng si ọdadaami nwa k'ogbe kw'ọbaan bi bọng asi, k'ophe kw'Abib, kkeri m'ophe nwuma wọ kw'iwa bọng abin k'Ijip. “Ọnọng manda wani oning-m k'itzitzikha oyini, ttara abọhk-kpakpa. ");
INSERT INTO mfo_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Bọng si Ọdadaami kw'Ipha ttara acheden-chiduk py'ekpo pya bọng ayaabh k'iwoni sabọng. “Bọng si Ọdadaami nwa kw'Ipha s'ikpong nnam ka cho, mada bọng apha iwoni sabọng. ");
INSERT INTO mfo_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Igbe ittaan ka cho, ajinọng biphyir áyin Itta Ọvaar Ibinọkpaabyi k'itzitzikha. ");
INSERT INTO mfo_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Bọng kaam izi s'ifon k'ẹjafọhni kànang, ttara ọttọhk kpenamkpen fa bẹ akhe yist. “Iyaak s'ẹnanga ch'ọdadaami kwaam kàhok maa ewu ehobha. ");
INSERT INTO mfo_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Bọng dima acheden-chiduk akkakka pa bọng ayaabh k'iwoni sabọng, atzima akwu k'ọhọhm kw'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng. “Bọng abasi p'evu kàtzima awọhn ovu-nwa. ");
INSERT INTO mfo_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Kkeri e, kaam ndọhm orenga-eden ichi bọng eden, ibaabha bọng, ibiri itzima bọng ikwu m'ibe nna sa nkk'nda. ");
INSERT INTO mfo_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Bọng yong-ẹ itzọhng e, abira aha eho anang-ẹ. Bọng sẹ oho-gaangi kànang, kkeri bọng kóbina ọnang k'oho-gaangi kwabọng, da che chaam ewobh mẹ ttar-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","“Idikha bọng atzọk ogbe ayonga itzọhng anang-ẹ k'idik s'ọgbaakhi, bọng abira asi odik kpenamkpen kwa mgbaakhi, kaam ńde ọttattaanga-nọng kw'attattaanga-nọng pabọng, kaam kímbe ttara anọng p'anabe ttara bọng. ");
INSERT INTO mfo_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Itzọhmi saam íchi bọng eden, itzima bọng idim k'irek s'ab'Amọr, ọmaana abaHet, ọmaana abaPẹriz, ọmaana abaKenaan, ọmaana abaHiv, ttara abaJẹbus. Kaam ḿbiri ńdimi bẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Bọng eho kàhakha anang akha pabẹ, bọng bẹ kàkpobha, bọng bẹ abẹ kàtzọn asi idik sa bẹ asi. Bọng akhaambi avọhkhi bẹ, bọng atzukhi agbatza pabẹ k'abir-ibiri. ");
INSERT INTO mfo_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Bọng akpobha kaam Ọvaar Ibinọkpaabyi, kwa nde Ibinọkpaabyi kwabọng, kaam ńdo ọchattọhk fabọng, ọmaana asi pabọng. Kaam mbiri ńnọbha ọkhọhmana ka bọng k'ottem. ");
INSERT INTO mfo_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Kwanọng manda wani kw'ibhọr íyin, kw'obiro ókpaana k'irek sabọng kóde. Kaam ńnang bọng akpen p'adum-odum. ");
INSERT INTO mfo_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Kaam ńdọhm ojora faam ochi bọng eden, mbiri ńnge ẹkhọma kpenamkpen cha bọng attema abẹ ka dama-dama. Kaam ńsi attattaanga-nọng biphyir akpa nnam arọbh. ");
INSERT INTO mfo_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Kaam ńdọhm abhingiho achi bọng eden atza akhubh abaHiv, ọmaana abaKenaan, ttara abaHet ka bọng k'itzitzikha. ");
INSERT INTO mfo_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Kaam anọng mba ka cho wani kínkwubh, oni mando ode, irek nna in-ide idukhi, nden s'ẹtzam nna mbiri nhaabh nyọhnga bọng. ");
INSERT INTO mfo_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Kaam ńkwubh bẹ ibeba-ibeba, maa opyiri k'ogbe kwa bọng akk'ahaabha k'odem kwa bọng atzọkha irek nnuma. ");
INSERT INTO mfo_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Kaam ńnge nnem sabọng ttẹwọr k'Ẹraanga-khora, maa apyiri k'Ọraanga kw'ideden kw'abaPhilistiya, ọmaana ttẹwọr k'ibe s'anọng an-arukhi, maa apyiri k'ọraanga kwa Euphrates. Kaam ńtte anọng p'arukhi m'irek nna ọbọhk nnang bọng, bọng ákhubh bẹ, bẹ abina bọng k'itzitzikha. ");
INSERT INTO mfo_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Bọng echekhi kasi ttara anọng mba, ọmaana akha pabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Bọng bẹ ọbọhk kàtte bẹ aruk k'irerek sabọng, oni mando ode, bẹ ási bọng asi ẹkhọngkwuri k'itzitzikha saam, okhuri bi, k'odik-ọkka ekpobha ch'akha pabẹ ede ọgbagbara ọnang bọng.” ");
INSERT INTO mfo_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Mẹ wọ, Ọvaar Ibinọkpaabyi, oben Mosẹs bi, “Kọ tzima Aarọn, ọmaana Nadab, ọmaana Abihu, ttara adeho arọbh attaan obhiri jobh p'Israẹl, akwu. Bọng awobha k'odenmir akpobh-m. ");
INSERT INTO mfo_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Yina, kọ Mosẹs mancheni wọ arenga abaanga kaam Ọvaar Ibinọkpaabyi. Ayok mbonggo kàkhaambi abaanga ka. Anọng mba kakhaambi avura ttar-ẹ.” ");
INSERT INTO mfo_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mada Mosẹs ofon ọtza ọgbaak anọng p'Israẹl atzim biphyir p'Ọvaar Ibinọkpaabyi ọgbaakhi, ọmaana aphaangi pẹ, bẹ abhina k'ogbe wani bi, “Mósi odik kpenamkpen osi kw'Ọvaar Ibinọkpaabyi okk'obena.” ");
INSERT INTO mfo_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mẹ wọ, Mosẹs ọn-ọkkẹr odik kpenamkpen kw'Ọvaar Ibinọkpaabyi ọkk'ọgbaakha. Ewu ehobh mẹ, obina k'ekpekpebha, ọtza osi ijafọhnibe k'egbegbeho-rin, obiro ọtzọkha mkpọmmachi s'atza jobh obhiri mfa ofhu iduduma, sa mbe nnang ngọma jobh obhiri mfa s'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Mẹ wọ, Mosẹs ọtzọhm adikkobh p'Israẹl bi, bẹ atza anang Ọvaar Ibinọkpaabyi ẹnanga ẹkwọmichẹ, bẹ abira atzima abhaamva asi ẹjafọhni ch'ẹnanga ch'odidiri anang Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mosẹs ọtzọkha izi nna rani okhe k'agbanggbang, ọtzọkha s'irikhi opyakhi k'ijafọhnibe. ");
INSERT INTO mfo_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Mẹ wọ, ọtzọkha Nnwẹr kw'Echekhi oyeri ọnang anọng p'Israẹl. Bẹ abhina bi, “Mọ́si odik kpenamkpen osi kw'Ọvaar Ibinọkpaabyi okk'obena. Móhakha eho ọhakha ọnang-ẹ.” ");
INSERT INTO mfo_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Mẹ wọ, Mosẹs ọtzọkha izi nnuma ọpyakhi anọng mba. Oben bi, “Ma wọ ode izi s'echekhi ch'Ọvaar Ibinọkpaabyi ọkk'ọsa ttara bọng, otzor k'atzim mba biphyir.” ");
INSERT INTO mfo_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mẹ wọ, Mosẹs ọmaana Aarọn, ọmaana Nadab, ọmaana Abihu, ttara adeho arọbh attaan obhiri jobh p'Israẹl, afona ");
INSERT INTO mfo_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","atza are Ibinọkpaabyi kw'Israẹl. Ibe s'ọbari mmo ide mach'ibhokhi sa bẹ atzim atza pa saphiya asi, s'ittaani mach'ọrọngkpakpa. ");
INSERT INTO mfo_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Yina, Ibinọkpaabyi adeho mba p'Israẹl itzama kosi. Bẹ are Ibinọkpaabyi, bẹ achi, abira agwo. ");
INSERT INTO mfo_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ọvaar Ibinọkpaabyi on-oben Mosẹs bi, “Kọ vura akwu k'egbegbeho, awobha ma. Kaam ńnang-ọ atza-gbẹgbẹri pa nkk'aphaangi, ọmaana asana nkkẹra p'ade ndọhna sabẹ.” ");
INSERT INTO mfo_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mẹ wọ, Mosẹs ttara Joshua kw'om-otzor-ẹ ọtzọhm, afona. Mosẹs ovura k'egbegbeho ch'Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Mosẹs oben adeho mba bi, “Bọng wobha ma, atzik man maa mọkpa nnam. Aarọn ọmaana Hur awobh ma ttara bọng. Ọnọng kpenamkpen kw'ọkhaam ikhakhaanga ttara oyok, ọfha ọtza okhebha bẹ, bẹ attọhna.” ");
INSERT INTO mfo_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mada Mosẹs ovur k'egbegbeho nduma, eboni ẹbhọri chẹ. ");
INSERT INTO mfo_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Abarada p'Ọvaar Ibinọkpaabyi ahakha m'egbegbeho cha Sinai. Eboni nda ẹbhọri egbegbeho k'iwu izadani. Ottonga iwu izenamfa, Ọvaar Ibinọkpaabyi oyeri Mosẹs m'eboni ẹtzaanga. ");
INSERT INTO mfo_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Abarada p'Ọvaar Ibinọkpaabyi k'egbegbeho ebir-ebir, an-akher anọng p'Israẹl ekpon ch'ẹkwọmi ọttọhk maa fẹ odimi. ");
INSERT INTO mfo_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mẹ wọ e, Mosẹs odim k'eboni nda ẹtzaanga, mada ovur k'egbegbeho ebir-ebir. Wa owobha kẹ iwu arọbh afa, ọmaana nnungiwu arọbh afa. ");
INSERT INTO mfo_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Ọvaar Ibinọkpaabyi oben Mosẹs bi, ");
INSERT INTO mfo_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Kọ gbaak anọng p'Israẹl bi, bẹ achen-m ẹnanga. Kọ wọ atzọkha ẹnanga ch'ọnọng kpenamkpen kw'osi ochibhi bi, ọnang-m ẹnanga. ");
INSERT INTO mfo_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Ma wọ ode nnanga s'atzọkha k'anọng mba: gol, ọmaana silva, ọmaana brons, ");
INSERT INTO mfo_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ọmaana ndik sa nde adem blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ọmaana ndik-nyokhasẹ nkkakka, ọmaana avu-phyubha, ");
INSERT INTO mfo_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ọmaana ndenkpa s'erukhimaan-dim sa bẹ aphyok asi-khora, ọmaana ndenkpa nkkakka s'avu, ttara mgbaakha s'akasiya, ");
INSERT INTO mfo_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ọmaana ana p'oliv p'attwikkaang, ọmaana ekpo pya bẹ am-atzima asi ana pa bẹ am-abyengi anọng k'eho, ttara insẹns, ");
INSERT INTO mfo_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ọmaana atza pa oniks, atza akkakka adọdọk pa bẹ agbana k'ẹphọd, ọmaana k'ẹbarakpa ch'ittemmọma. ");
INSERT INTO mfo_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Mẹ wọ, tte bẹ asi irukhabe anang-m, ofona mẹ, kaam ńnuk k'ottem kwabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Si irukhabe nna, ọmaana effaangin-ẹkpo pyẹ, atzor bi hyẹẹr k'odem kwa kaam ńgọhkh-ọ. ");
INSERT INTO mfo_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Tte bẹ atzima mgbaakha s'akasiya asi ẹkkọhbhi ch'adum pẹ áde ndọkhi nttaan ọmaana akpamma ọhawani, ẹkpa chẹ ede ndọkhi mfa ọmaana akpaama attaan, ebe chẹ ede ndọkhi mfa ọmaana akpamma attaan. ");
INSERT INTO mfo_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Tzima gol ọkkakka abhọri chẹ k'ẹtzaanga ọmaana k'iyaan, abira atzima gol abaanga ammakpabem pẹ, adokha akhọri. ");
INSERT INTO mfo_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Tzima gol arabha ariring anna, akhe bẹ ka ndọkhi nna s'ẹkkọhbhi nda. Ariring afa k'okhubha wani, afa k'okhubha nwonggo. ");
INSERT INTO mfo_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Tzima mgbaakha s'akasiya asi nneremmachi, abhọri sẹ ttara gol. ");
INSERT INTO mfo_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Kọ khe nneremmachi nna k'ariring mba p'awobh k'ẹbhabhaanga ch'ẹkkọhbhi nda, ifha bẹ atzima atzini chẹ. ");
INSERT INTO mfo_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Nneremmachi nna ngaambi nwobha m'ariring p'ẹkkọhbhi nda, bẹ kàkhaambi arọbha sẹ. ");
INSERT INTO mfo_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Kọ khe aphaangi pa kaam ńnang-ọ m'Ẹkkọhbhi nda ch'Echekhi ẹtzaanga. ");
INSERT INTO mfo_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Tzima gol ọkkakka asi ẹkkọhbhikpa ch'ephyokhi. Adum pẹ áde ndọkhi nttaan ọmaana akpamma ọhawani, ẹkpa chẹ éde ndọkhi mfa ọmaana akpamma attaan. ");
INSERT INTO mfo_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Kọ tzima gol aduk achẹrubim afa, abera k'ikpiho s'ẹkkọhbhi nda. ");
INSERT INTO mfo_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Si cherub wani ahok k'eho dani, abira asi ọdọdọk ahok k'eho ndonggo. Kọ si achẹrubim mba ọmaana ẹkkọhbhikpa nda agbakha ayok, ka nho mfa s'ẹkkọhbhi nda. ");
INSERT INTO mfo_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Tte achẹrubim mba akhaama mbabaang sa mmẹma k'ẹrọng mbubha ẹkkọhbhikpa ch'ẹkkọhbhi nda, tte achẹrubim mba akkeri ayok itzitzikha, bẹ akkeri itzitzikha kẹ ẹkkọhbhikpa nda. ");
INSERT INTO mfo_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Kọ tzọkha ẹkkọhbhikpa nda akhubha k'ebir-ebir kw'Ẹkkọhbhi ch'Echekhi, atzọkha aphaangi pa kaam ńnang-ọ akhe m'ẹtzaanga. ");
INSERT INTO mfo_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","M'ebir-ebir kw'ẹkkọhbhi-kpa nda, ọmaana k'ottem kw'achẹrubim mba p'awobh k'ebir-ebir kw'Ẹkkọhbhi ch'Echekhi nda, wọ kwa kaam ńgebh-ọ, mbiri nnang-ọ asana paam biphyir p'ánang anọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Tzima mgbaakha s'akasiya asi okpokkoro. Adum pẹ áde ndọkhi nttaan, ẹkpa chẹ ede ẹtzọkhi dani ọmaana akpamma azadani, ebe chẹ ede ndọkhi mfa ọmaana akpaama attaan. ");
INSERT INTO mfo_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Kọ tzima gol ọkkakka abhọri okpokkoro nwa, abira atzima gol abanga ammakpabem adokh-ẹ akhọri. ");
INSERT INTO mfo_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Kọ biri si ammakpabem p'ẹkpa ebenga mach'ẹbọhkpattem, atzima gol adokha chẹ akhọri. ");
INSERT INTO mfo_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Tzima gol asi ariring anna p'okpokkoro nwa, adabh bẹ ma nnyọnga nna s'okpokkoro nwa, mẹ da mmo sẹ nna nwobh. ");
INSERT INTO mfo_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ariring mba awobha abaanga m'ammakpabem p'ẹkkọhbhi nda, p'abọkha nneremmachi sa bẹ am-atzima atzini okpokkoro nwa. ");
INSERT INTO mfo_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Tzima mgbaakha s'akasiya asi nneremmachi nna, abhọri sẹ ttara gol, ifha bẹ am-atzima atzini okpokkoro nwa. ");
INSERT INTO mfo_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Tzima gol ọkkakka asi agbang-gbang, ọmaana nnengakpa, ọmaana akọbh, ttara agbere pa bọng átzima asi nnanga mbyengisẹ. ");
INSERT INTO mfo_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Nana brẹd kw'awurada m'okpokkoro nwa k'itzitzikha saam, k'ogbe kpenamkpen. ");
INSERT INTO mfo_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Kọ duk gol ọkkakka atzima asi ettwikkaang-chi. Orin kwẹ, ọmaana abọhnga, ọmaana akọbh, ọmaana agbok, ttara adodo pẹ, pyẹ éde echi nda dani. ");
INSERT INTO mfo_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Abọhnga azadani átzọhnga k'ẹbhabhaanga ch'ettwikkaang-chi, attaan awobha k'okhubha wani, attaan awobha k'okhubha nwonggo. ");
INSERT INTO mfo_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Akọbh attaan p'ade mach'adodo p'almọn, ttara agbok ọmaana adodo áwobha k'ẹbọhnga dani, attaan k'ẹbọhnga ẹdọdọk, ábira ade odem nwa wani ttara abọhnga mba azadani biphyir, p'ettwikkaang-chi nda. ");
INSERT INTO mfo_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Etwikhikkaang-chi nda ẹkhaama akọbh anna p'ade mach'adodo p'almọn ttara agbok, ọmaana adodo. ");
INSERT INTO mfo_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ogbok wani owobha k'irekh-irek kw'abọhnga-gbakha p'acheden p'atzọhnga m'etwikkaang-chi nda, ogbok kw'ottong afa obiro owobha k'irekh-irek kw'abọhnga-gbakha p'attong afa, ottong agbok attaan, owobha k'irekh-irek kw'abọhnga-gbakha p'attong attaan. Biphyir-phyir bẹ ade abọhnga azadani. ");
INSERT INTO mfo_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Agbok ọmaana abọhnga mba biphyir áde echi nda dani, ọmaana etwikkaang-chi nda, cha bẹ atzima gol ọkkakka aduk. ");
INSERT INTO mfo_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Mẹ wọ, si atwikkaang azenamfa, anana bẹ k'etwikkaang-chi nda, ifha bẹ amaani k'ottem kw'itzitzikha sẹ. ");
INSERT INTO mfo_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Tzima gol ọkkakka asi afhẹngbẹ, ọmaana nnengakpa s'ekpon okkikkibha. ");
INSERT INTO mfo_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Tzima gol ọkkakka asi etwikkaang-chi ch'ẹdọhbh chẹ ede talẹn wani, ọmaana idik kpenamkpen sẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Kọ re bi asi ọttọhk kpenamkpen atzor k'eden cha kaam ngọhkh-ọ k'egbegbeho. ");
INSERT INTO mfo_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Tzima mkpekhe jobh sa bẹ atzim ọbara ọkkakka ayok, ọmaana ndik sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ttara achẹrubim p'omengkkakkaa osi, asi irukhabe nna. ");
INSERT INTO mfo_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Mkpekhe nna biphyir nde mbengabọhk, adum pabẹ ade ndọkhi arọbh afa obhiri mfa, ẹkpa chabẹ ede ndọkhi nzadani. ");
INSERT INTO mfo_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Kọ khọma mkpekhe nzen atzima si dani, abira akhọma mvonggo ozen atzima si dani. ");
INSERT INTO mfo_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Si ager p'ade blu akhe k'akhaan-akhaan p'ekpekhe nda dani ch'akhọm, abira asi mando k'ekpekhe ndonggo ch'akhọm. ");
INSERT INTO mfo_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Si ager arọbh afa obhiri jobh akhe k'ekpekhe dani, abira asi ager arọbh afa obhiri jobh akhe k'ekpekhe ndonggo. Ager mba akkeri ayok itzitzikha. ");
INSERT INTO mfo_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Mẹ wọ, kọ tzima gol asi agbak arọbh afa obhiri jobh p'abọkha mkpekhe nna atzima k'ibe rani, ifha irukhabe nna ide ibe rani. ");
INSERT INTO mfo_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Kọ tzima avu-phyubha asi mkpekhe jobh obhiri wani, sa nde ikhira sa mbubha irukhabe nna. ");
INSERT INTO mfo_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Mkpekhe nna jobh obhiri wani biphyir nde mbenga-mbọhk. Adum ade ndọkhi arọbh afa obhiri azen, ẹkpa ede ndọkhi nzadani. ");
INSERT INTO mfo_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Kọ khọma mkpekhe nzen atzima asi dani, abira akhọma nnonggo nzadani atzima asi dani. Kọni ekpekhe ch'ettong nzadani k'igbe ifa k'ẹhọhmma ch'irukhabe nna. ");
INSERT INTO mfo_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Si ager arọbh afa obhiri jobh akhe k'ekpekhe dani ch'akhọm, abira akhe ager arọbh afa obhiri jobh k'ekpekhe ndonggo dani ch'akhọm. ");
INSERT INTO mfo_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Kọ tzima brons asi agbak arọbh afa obhiri jobh, akhe bẹ k'ager mba, atzima atzọhnga mkpekhe nna, ifha ẹbọkha ikhira nna k'ibe rani. ");
INSERT INTO mfo_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Onode k'adum p'attar-ọttara ka mkpekhe s'ikhira nna, igbokha s'ekpekhe s'irikhi ilẹbhi ibubha k'ẹpannam ch'irukhabe nna. ");
INSERT INTO mfo_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Adum pa mkpekhe s'ikhira nna áde, ẹtzọkhi dani ọmaana igbokha k'okhubha wani, ẹtzọkhi dani ọmaana igbokha k'okhubha nwonggo. S'irikhi ílẹbhi k'okhubha kpenamkpen, ifha ibhubha irukhabe nna. ");
INSERT INTO mfo_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Tzima erukhimaandim-kpakpa cha bẹ aphyok asi-khora, abubha ikhira nna. K'ebir-ebir kw'erukhimaandim-kpakpa nda, bubha evu-kpakpa. ");
INSERT INTO mfo_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Tzima mgbaakha s'akasiya asi mkpọmmachi sa mbe-obe k'irukhabe nna. ");
INSERT INTO mfo_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Adum p'ẹkpọmmachi kpenamkpen áde ndọkhi chi, ẹkpa éde, ndọkhi mfa ọmaana akpamma attaan, ");
INSERT INTO mfo_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ttara mmo sa njer aho mbenga-mbọhk, nkkeri ayok itzitzikha. Si mkpọmmachi nna biphyir s'irukhabe nna odem nwuma wani. ");
INSERT INTO mfo_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Si mkpọmmachi ẹrọbh sa nkkeri k'ẹrakha-ẹrakha kw'irukhabe nna, ");
INSERT INTO mfo_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","abira atzima asilva asi nnana arọbh afa, s'akhe k'irekh-irek kwa mkpọmmachi nna, nnana mfa k'ẹkpọmmachi kpenamkpen, ẹnana dani k'eho dani. ");
INSERT INTO mfo_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","K'okhubha kw'ebir-ebira kw'irukhabe nna, si mkpọmmachi ẹrọbh, ");
INSERT INTO mfo_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ọmaana nnana arọbh afa sa silva, nnana mfa k'ẹkpọmmachi kpenamkpen. ");
INSERT INTO mfo_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Si mkpọmmachi nzadani k'okhubha k'irukhabe nna kw'ewuchen em-edimi, ");
INSERT INTO mfo_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","abira asi mkpọmmachi mfa ka nyọhnga s'ẹrakha-ẹrakha kw'irukhabe nna. ");
INSERT INTO mfo_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Kọ akhaambi agbakha mkpọmmachi nna mfa sa nyọhnga s'irukhabe nna, ttẹwọr k'awọr maa apyiri k'aho pabẹ. Akhe bẹ k'oriring wani, bẹ afa áde odem wani. ");
INSERT INTO mfo_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Mẹ wọ, sẹ ńde mkpọmmachi nzenanttaan, ọmaana nnana s'asilva chi obhiri wani, nnana mfa k'irekh-irek kw'ẹkpọmmachi dani. ");
INSERT INTO mfo_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Kọ biri tzima mgbaakha s'akasiya asi nneremachi, si nzen sa mkpọmmachi s'okhubha wani kw'irukhabe nna, ");
INSERT INTO mfo_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","abira asi nneremachi nzen k'okhubha nwonggo, asi nzen k'okhubha kw'ewuchen em-edimi ka nnam-annam kw'irukhabe nna. ");
INSERT INTO mfo_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ereremachi ch'ottem ẹttẹwọr k'eho dani ẹbọkha k'eho ndonggo k'ottem kwa mkpọmmachi. ");
INSERT INTO mfo_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Tzima gol abhọri mkpọmmachi nna, abira atzima gol asi ariring, p'abọkha nneremachi nna, abira atzima gol abhọri nneremachi nna. ");
INSERT INTO mfo_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Kọ mun irukhabe nna atzor k'odem kwa ngọhkh-ọ k'egbegbeho. ");
INSERT INTO mfo_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Tzima ndik sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ọmaana ndik nkkakka sa bẹ ayokh-oyok asi ekpekhe, ttara achẹrubim p'omengkkakkaa osi. ");
INSERT INTO mfo_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Rena sẹ k'agbak pa gol ka mkpọmmachi nna nna sa mgbaakha s'akasiya, abhọri sẹ ttara gol, abe sẹ ka nnana nna s'asilva. ");
INSERT INTO mfo_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Rena ekpekhe nda k'agbak, atzọkha Ẹkkọhbhi ch'Echekhi ahok ka nnam-annam kw'ekpekhe nda. Ekpekhe nda ẹbhaangi Ibe s'Awurada k'ibe s'Awurada p'ayọhng Awurada. ");
INSERT INTO mfo_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Kọ áhok ẹkkọbhikpa ch'ephyokhi ch'Ẹkkọhbhi ch'Echekhi, k'ibe s'Awurada p'ayọhng Awurada. ");
INSERT INTO mfo_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Hok okpokkoro k'iyaan s'ekpekhe nda, k'ebir-ebira kw'irukhabe nna, abira ahok etwikkaang-chi ekker-ẹ itzitzikha k'okhubha kw'ẹrakha-ẹrakha. ");
INSERT INTO mfo_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“K'ọmma kw'ikhira nna, tzima ndik sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi ttara ndik nkkakka sa bẹ ayokh-oyok, ọtzọhm f'odokh-ọbara. ");
INSERT INTO mfo_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Tzima gol asi agbak p'ekpekhe nda, ọmaana mkpọmmachi nzen sa mgbaakha s'akasiya, abhọri ttara gol. Atzima brons aduk nnana nzen sabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Tzima mgbaakha s'akasiya asi ijafọhnibe s'ikhaama akhubha anna. Ebe chẹ éde ndọkhi nna ọmaana igbokha, adum pẹ áde ndọkhi nzenamfa ọmaana igbokha, ẹkpa chẹ éde ndọkhi nzenamfa ọmaana igbokha. ");
INSERT INTO mfo_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Gwa obhik ka nyọhnga nna nna, ifha abhik mba ọmaana ijafọhnibe nna ade ọttọhk mvuma vani. Atzima brons abhọri ijafọhnibe nna. ");
INSERT INTO mfo_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Kọ tzima brons asi ẹtzọhmkpo pyẹ biphyir, atzima si ọrọkha f'itzọtzọhng okpokpokhi, ọmaana asọvẹl, ọmaana agbobhi-mbọhk, ọmaana adaakpa p'akhaam aha, ttara nnengakpa. ");
INSERT INTO mfo_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Kọ tzima brons asi otzekpa, atzima brons asi ibuni, abira atzima brons asi ariring mba anna biphyir p'otzekpa nwa. ");
INSERT INTO mfo_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Kẹ otzekpa nwa k'irekh-irek kw'ijafọhnibe, k'odem kw'ibuni nna, ittẹwọr m'ibhaang-ifa s'ijafọhnibe. ");
INSERT INTO mfo_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Kọ tzima mgbaakha s'akasiya asi mkpọmmachi s'ijafọhnibe nna, abira atzima brons abhọri sẹ. ");
INSERT INTO mfo_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Kọ ánọhma mkpọmmachi nna k'ariring mba, ifha sẹ ńwobha k'akhubha mba afa p'ijafọhnibe, k'ogbe kwa bẹ atzini. ");
INSERT INTO mfo_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Tzima agbaakhakpa asi ijafọhnibe nna itte eje. Kọ si sẹ atzor k'odem kw'iwa ngọhkh-ọ k'egbegbeho. ");
INSERT INTO mfo_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Si ẹttọmmattem ch'irukhabe nna. Tzima ndik nkkakka sa bẹ ayokh-oyok, asi mkpekhe sa ńde ndọkhi arọbh azenamfa obhiri jobh, arena sẹ k'ẹrakha-ẹrakha, ");
INSERT INTO mfo_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ọmaana mkpọmmachi ẹrọbh, ọmaana nnana sa brons ẹrọbh, ọmaana agbak p'asilva, ttara abarakpa ka mkpọmmachi. ");
INSERT INTO mfo_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Okhubha kw'ebir-ebira óbiro ode ndọkhi arọbh azenamfa obhiri jobh, ọkhaama mkpọmmachi ẹrọbh, ọmaana nnana sa brons ẹrọbh, ọmaana agbak p'asilva, ttara abarakpa ka mkpọmmachi. ");
INSERT INTO mfo_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Okhubha kw'ewuchen em-edimi kw'ẹttọhmmattem nda, óde ndọkhi arọbh attaan obhiri chi, obiro ọkhaama mkpekhe, ọmaana mkpọmmachi jobh, ttara nnana jobh. ");
INSERT INTO mfo_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Okhubha kw'okkeri kẹ da ewuchen em-eyin, ẹkpa ch'ẹttọmmattem nda ébire ede ndọkhi arọbh attaan obhiri chi. ");
INSERT INTO mfo_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Adum pa mkpekhe ade ndọkhi ẹrọbh obhiri mfa ọmaana igbokha, sẹ nwobha k'okhubha wani kw'ọmma, ngaama mkpọmmachi nttaan, ttara nnana nttaan, ");
INSERT INTO mfo_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","mkpekhe sa nde ndọkhi ẹrọbh obhiri mfa ọmaana igbokha k'adum, ngaama mkpọmmachi nttaan, ttara nnana nttaan mbiri nwobha k'okhubha nwonggo. ");
INSERT INTO mfo_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“M'ọmma kw'ẹttọhmmattem, si ekpekhe ch'ede ndọkhi ẹrọbh obhiri jobh k'adum, adem pẹ ade blu ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ttara ndik nkkakka sa bẹ ayọkh-oyok, kw'óde ọtzọhmbọhk f'odokh-ọbara, obiro ọkhaama mkpọmmachi nna, ttara nnana nna. ");
INSERT INTO mfo_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Mkpọmmachi biphyir sa mbe ngọri ẹttọmmattem nda, ngaama abarakpa p'asilva, ọmaana agbak, ttara nnana sa brons. ");
INSERT INTO mfo_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ẹttọmmattem nda éde, ndọkhi arọbh azenamfa obhiri jobh k'adum, ndọkhi arọbh attaan obhiri chi k'ẹkpa, ẹkhaama mkpekhe sa ndik nkkakka sa bẹ ayokh-oyok sa ngori mpyiri ndọkhi nzenamfa ọmaana igbokha, ttara nnana sa brons. ");
INSERT INTO mfo_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ẹtzọhmkpo ẹdọdọk biphyir pya bẹ atzima k'irukhabe nna, ọtzọhm kpenamkpen f'ẹtzọhmkpo mbya, ttara abhing pẹ biphyir p'ikhira, ttara abhing p'ẹttọhmmattem, áde brons. ");
INSERT INTO mfo_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Ben anọng p'Israẹl bi, bẹ atzima ana p'atto bi ttaan pa bẹ amyan k'achiduk p'oliv p'anang iyaan, ifha atwikkaang am-ayeni k'ogbe kpenamkpen. ");
INSERT INTO mfo_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","K'irukhabe s'iwobh k'iyaan-iyaan kw'ekpekhe ch'ewobh k'itzitzikha s'Ẹkkọhbhi ch'Echekhi, Aarọn ọmaana va pẹ p'ijinọng am-ohok atwikkaang mba ayeni k'itzitzikha s'Ọvaar Ibinọkpaabyi, ttẹwọr k'ẹchọhkha maa ewu ehobha. Ndọhna nna nde s'anọng p'Israẹl maa opyiri k'igbọ s'íkwu k'ororo. ");
INSERT INTO mfo_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Yeri agbaanakka Aarọn, ọmaana va pẹ p'ijinọng p'ade Nadab, ọmaana Abihu, ọmaana Ẹleyaza, ttara Itamar k'ottem kw'anọng p'Israẹl, ifha bẹ asi ọtzọhm f'afọhnẹja. ");
INSERT INTO mfo_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Khum nnya s'awurada anang agbaanakka Aarọn, ifha kẹ ọkhaama ikpokpobha ttara abarada. ");
INSERT INTO mfo_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ben ajinọng biphyir p'asi emengkka, pa kaam nkk'ekkoji ch'itzọhmbọhk-dema nna nnanga bi, bẹ akhum nnya anang Aarọn, k'ẹbọhk-nana chẹ, ifha osi ọtzọhm f'ọfọhnẹja. ");
INSERT INTO mfo_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ma wọ ode nnya sa bẹ ákhum, ẹbarakpa ch'ittemmọma, ọmaana ẹphọd, ọmaana ọnọhma kw'okhum mbọhk, ọmaana ọnọhma-baba, ọmaana ẹbarakpa ch'eho ọdadabh, ttara odikpa kw'erin. Bẹ akhum nnya nna s'awurada anang agbaanakka Aarọn, ọmaana va pẹ p'ijinọng, ifha bẹ asi ọtzọhm f'afọhnẹja. ");
INSERT INTO mfo_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Tte bẹ atzima ndik sa gol, ọmaana sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ttara ndik nkkakka sa bẹ ayokh-oyok. ");
INSERT INTO mfo_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Tte amengkkakkaa otzima ndik sa gol, ọmaana sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ttara ndik nkkakka sa bẹ ayokh-oyok, okhum ẹphọd. ");
INSERT INTO mfo_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Ch'ẹ́khaama mbarakpa mfa ka mbabaang, pa bẹ akhum araakha ka nyọhnga sẹ mfa, ifha ẹbọkha ayok. ");
INSERT INTO mfo_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Odikpa kwẹ kwa bẹ átzima emengkka ayok, óde odem wani ttara ẹphọd nda, bẹ ayokh-ẹ ttara ndik sa gol, ọmaana sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ttara ndik nkkakka sa bẹ ayokh-oyok. ");
INSERT INTO mfo_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Tzọkha atza afa p'oniks, akkẹr che pa va p'Israẹl p'ijinọng mẹ. ");
INSERT INTO mfo_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Kkẹr che azadani k'ọtza wani, abira akkẹr che mbonggo azadani k'ọtza nwonggo, kkẹr che mba atzor k'igbọ sabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Kkẹr che pa va p'Israẹl p'ijinọng m'atza mba afa, mach'ira omengkkakkaa ọkkẹr ọttọhk k'atza. Bẹ gol akhọri ammakpabem p'atza mba afa, ");
INSERT INTO mfo_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","abira akpa bẹ k'abarakpa mba pa mbabaang s'ẹphọd, mach'atza p'ojima anang va p'Israẹl p'ijinọng. Aarọn om-otzima che mba ka mbabaang sẹ mach'ojima k'itzitzikha s'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Bẹ gol akhọri ammakpabem p'atza mba afa, ");
INSERT INTO mfo_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ọmaana mgbakkọhbh mfa sa gol mach'edik, agbana sẹ k'atza mba. ");
INSERT INTO mfo_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Khum ẹbarakpa ch'ittemmọma ch'ochibhi kw'Ibinọkpaabyi ororor, kw'ode ọtzọhm f'omengkkakkaa. Tzima ndik sa gol, ọmaana sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ttara ndik nkkakka sa bẹ ayokh-oyok, akhum chẹ mach'ẹphọd. ");
INSERT INTO mfo_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Éde akhubha anna, idikha anyọhng chẹ ọnyọhnga, adum pẹ ọmaana ẹkpa chẹ áde mbenga-mbọhk, ayom ẹbọhkpattem. ");
INSERT INTO mfo_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Bẹ adik anna p'atza p'ajibh-ojibh mẹ. M'odik kw'ocheden, ábẹ ọtza kwa ruby, ọmaana kwa topaz, ttara kwa bẹryl, ");
INSERT INTO mfo_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","k'odik kw'ottong afa bẹ ọtza kwa tọkwọis, ọmaana kwa saphira, ttara kw'ẹmẹral; ");
INSERT INTO mfo_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","k'odik kw'ottong attaan bẹ ọtza kwa jasin, ọmaana kw'agate, ttara kw'amẹtist, ");
INSERT INTO mfo_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","k'odik kw'ottong anna bẹ ọtza kwa krisolita, ọmaana kw'oniks, ttara kwa jasper. Bẹ gol akhọri ammakpabem p'atza mba. ");
INSERT INTO mfo_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Bẹ áde atza jobh obhiri afa, kpenamkpen otzera che cha nnwa wani kw'Israẹl kw'ijinọng, kpenamkpen obe mach'ẹkhọhkha, ttara che ch'efonamma dani ch'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Tzima gol kwa bẹ ayokh-oyok mach'edik, asi mgbakkọhbh. ");
INSERT INTO mfo_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Tzima gol asi ariring afa, atzima akpa bẹ ka nyọhnga s'ẹbarakpa nda ch'ittemmọma. ");
INSERT INTO mfo_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Kpa mgbakkọhbh nna mfa sa gol k'ariring mba pa nyọhnga s'ẹbarakpa nda ch'ittemmọma, ");
INSERT INTO mfo_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","abira akpa aho mbonggo afa pa mgbakkọhbh k'atza mba afa, amaana k'abarakpa pa mbabaang, k'itzitzikha s'ẹphọd. ");
INSERT INTO mfo_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Si ariring pa gol afa, agbana bẹ ka nyọhnga nnonggo mfa k'ẹtzaanga kw'ẹbarakpa ch'ittemmọma abaanga ẹphọd. ");
INSERT INTO mfo_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Biri tzima gol asi ariring afa, agbana bẹ k'irekhirek kw'abarakpa pa mbabaang k'itzitzikha s'ẹphọd, ọbaanga ibe sa bẹ atzọhng k'ebir-ebir kwa mkpansin kw'ẹphọd. ");
INSERT INTO mfo_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Tzima edik blu, akpa ariring p'ẹbarakpa ch'ittemmọma ọmaana ariring p'ẹphọd, agbana ka mkpansin, ifha ẹbarakpa ch'ittemmọma eningi ẹ́wọkhi k'ẹphọd. ");
INSERT INTO mfo_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“K'ogbe kpenamkpen kw'Aarọn ọ́nwa k'Ibe s'Awurada, óm-otzima che pa va p'Israẹl p'ijinọng m'ittemmọma sẹ, pa bẹ abẹ k'ẹbarakpa ch'ittemmọma ch'ochibhi kw'Ibinọkpaabyi ororor, mach'ojima kw'ochina ororo k'itzitzikha s'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Biri bẹ ose kw'Urim ọmaana Tumim k'ẹbarakpa ch'ittemmọma, ifha bẹ am-afha awobha m'ittemmọma s'Aarọn, k'ogbe kpenamkpen kw'oyini Ọvaar Ibinọkpaabyi k'itzitzikha. Mẹ wọ, Aarọn óm-otzima ekpo mbya k'ittemmọma sẹ, obe k'ọphaangi kw'achibhi osisi, k'eho ch'anọng p'Israẹl, k'itzitzikha s'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Tzima ibara s'ide blu biphyir akhum ọnọhma-baba kw'ẹphọd, ");
INSERT INTO mfo_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ahok ọmma k'ottem kw'ókhe eho. Bẹ abhọri ọmma nwa kw'eho ẹmma, mach'ẹnọhma-khokhora, ifha chẹ eningi ẹjaakhi. ");
INSERT INTO mfo_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Tzima ndik sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ayok aduk pa pomegranet, agbana akkaningkka pa gol k'ottem kwabẹ. Tzima ndik nna abhọri ẹmma ch'inọhmakhuma nna, ttara akkaningkka pa gol k'ottem kwabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Akkaningkka mba pa gol, ọmaana apomegrenet awobha ayok k'ottem, akhọri ẹbaramma ch'ọnọhma-baba nwa. ");
INSERT INTO mfo_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aarọn ọkhaambi ọfọra chẹ k'ogbe kw'ọsi ọtzọhm f'ọfọhnẹja. Bẹ ábhaanga amọng p'akkaningkka mba, k'ogbe kw'odim k'Ibe s'Awurada k'itzitzikha s'Ọvaar Ibinọkpaabyi, ọmaana k'ogbe kw'óyin k'iyaan, ifha oningi ópe. ");
INSERT INTO mfo_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Tzima gol ọkkakka asi ẹchachaangkpa, akkẹr mẹ mach'ẹkhọhkha bi, AWURADA AWOBH ANANG ỌVAAR IBINỌKPAABYI. ");
INSERT INTO mfo_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Atzima edik blu akpẹ-ẹ amaana k'ibara s'eho ọdadabh; ch'éwobha k'itzitzikha s'ibara nna s'eho ọdadabh. ");
INSERT INTO mfo_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Chẹ éwobha Aarọn k'itzitzikha-ttem, Aarọn ọ́tzọkha oponga-pyibha kw'owobh ka nnanga s'awurada s'anọng p'Israẹl atte ọbọhk anang-m, odem kpenamkpen kwa nnanga sabẹ nde. Mando kw'echina ororo ewobha Aarọn m'itzitzikha-ttem, ifha Ọvaar Ibinọkpaabyi ókhera ọtzọkha nnanga nna. ");
INSERT INTO mfo_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Tzima ndik nkkakka sa bẹ ayokh-oyok ayok ọnọhma-baba nwa, abira atzima ndik nkkakka sa bẹ ayokh-oyok ayok ibara nna s'eho ọdadabh. Tte odikpa kw'erin óde ọtzọhmbọhk f'odokh-ọbara. ");
INSERT INTO mfo_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Biri khum ọnọhma-baba, ọmaana ẹbarakpadik, ttara abarakpa p'eho anang va p'Aarọn p'ijinọng, ifha bẹ akhaama ikpokpobha ttara abarada. ");
INSERT INTO mfo_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Akk'agbaanakka Aarọn ọmaana va pẹ p'ijinọng nnya nna afọra, abyengi bẹ ana k'eho, abira anana bẹ ọbọhk k'eho. Si bẹ awur, ifha bẹ afha asi ọtzọhm f'afọhnẹja anang-m. ");
INSERT INTO mfo_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Tzima ndik sa bẹ ayokh-oyok akhum akpokhuma p'ẹtzaanga, p'afona k'erin apyiri ka ndaak, pa bẹ am-atzima abubha for. ");
INSERT INTO mfo_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aarọn ọmaana va pẹ p'ijinọng akhaambi, afọra pyẹ k'ogbe kpenamkpen kwa bẹ adim k'irukhabe, obiro ode bi bẹ areng achina k'ijafọhnibe bi, bẹ asi ọtzọhm k'Ibe s'Awurada, ifha bẹ aningi oponga-pyibha atzọk, abira ape. “Ma wọ ode ndọhna sa ńwobha nnang Aarọn, ọmaana va pa va pẹ, maa ogbe ode. ");
INSERT INTO mfo_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Ma wọ ode odik kw'ási, ifha asi bẹ awur, ifha bẹ afha asi ọtzọhm f'afọhnẹja. Tzọkha ọbhaamnwa-dim, ọmaana arukhimaan-dim afa p'ani ekhem atzim. ");
INSERT INTO mfo_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Biri tzima abubuma akkakka pa wit, asi brẹd kwa bẹ ani yist akhe, ttara ekpo ẹkkaanga-pyẹ pya bẹ akhe ana, ttara brẹd kwa bẹ ani yist akhe, bẹ abira ayaang ana p'oliv. ");
INSERT INTO mfo_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Yikha pyẹ k'ikhiriba atzima akwu, ọmaana ẹbhaam nduma, ttara arukhimaan-dim mba afa. ");
INSERT INTO mfo_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","An-atzima Aarọn, ọmaana va pẹ p'ijinọng abira akwu k'ẹhọhmma ch'irukhabe nna, atzima asi agbobhi bẹ for. ");
INSERT INTO mfo_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Tzọkha nnya nna afọra Aarọn, ọmaana ọnọhma-baba, ọmaana ọnọhma kw'okhum mbọhk kw'ẹphọd, ọmaana ẹphọd ọkhaam, ttara ẹbarakpa ch'ittemmọma. Akpẹ-ẹ mkpansin kwa bẹ atzim emengkka ayok, atzima abọkha ẹphọd nda m'erin. ");
INSERT INTO mfo_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Dabh-ẹ ẹbarakpa ch'eho ọdadabh m'eho, abira afọr-ẹ ikpo s'awuruda amaana m'ẹbarakpa nda ch'eho ọdadabh. ");
INSERT INTO mfo_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Atzọkha ana pa bẹ am-abyengi ọnọng k'eho, abyeng-ẹ k'eho. ");
INSERT INTO mfo_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Atzima va pẹ p'ijinọng akwu, afọra bẹ anọhma-baba, ");
INSERT INTO mfo_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","abira adabh bẹ abarakpa p'eho ọdadabh. Akpa Aarọn ọmaana va pẹ p'ijinọng ẹbarakpadik. Ndọhna nna s'ọfọhnẹja ńde sabẹ, maa ogbe ode. M'eden nda dọ ch'ánana Aarọn, ọmaana va pẹ p'ijinọng ọbọhk k'eho. ");
INSERT INTO mfo_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Tzima ọbhaamdim akwu k'itzitzikha s'irukhabe nna, Aarọn ọmaana va pẹ p'ijinọng ánan-ẹ mbọhk k'eho. ");
INSERT INTO mfo_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Yẹk ọbhaamdim nwa ẹdọhngi m'itzitzikha s'Ọvaar Ibinọkpaabyi, m'ọmma kw'irukhabe. ");
INSERT INTO mfo_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Tzima ẹnọhna chọ, agberi izi rani s'ọbhaamdim nwa, achọkhi k'abhik p'ijafọhnibe, abira atzọkha izi s'irikhi abyengi m'orin kw'ijafọhnibe nna. ");
INSERT INTO mfo_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Atzọkha iyaak biphyir s'ibhọri abhọri, ọmaana s'ibubh anaang, ttara iyaak s'ibubh ndọdọri, akwọmi pyẹ m'ijafọhnibe. ");
INSERT INTO mfo_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Yina, tzima ekpon akwọmi ayara p'ọbhaamdim nwa, ọmaana ẹkpakpa chẹ, ttara afu k'iyaan-iyaan s'ibhingabe. Ma wọ ode ẹnanga ch'ẹkhọngkwuri ogbogbobhi. ");
INSERT INTO mfo_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Kọ tzọkha erukhimaan-dim dani ma mbuma afa, Aarọn, ọmaana va pẹ p'ijinọng ánana chẹ mbọhk k'eho. ");
INSERT INTO mfo_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Yẹk erukhimaan-dim nda ẹdọhngi, atzọkha izi sẹ apyakhi k'akhaan-akhaan biphyir p'ijafọhnibe nna. ");
INSERT INTO mfo_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Jọhkhi erukhimaan-dim nda k'abir-ibiri, abira agbobhi abhọri pẹ, ọmaana mmo, atzọkha eho attara, ọmaana abiri-biri mbonggo. ");
INSERT INTO mfo_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","An-akwọmi erukhimaan-dim nda biphyir m'ijafọhnibe nna. Ma wọ ode ẹnanga ẹkwọmichẹ anang Ọvaar Ibinọkpaabyi, ch'ẹdaami eruk, ebere ede ẹnanga cha bẹ areng k'ekpon akwọmi anang Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Kọ tzọkha erukhimaan-dim ndongo, Aarọn ọmaana va pẹ p'ijinọng ánana chẹ mbọhk k'eho. ");
INSERT INTO mfo_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Yẹk chẹ ẹdọhngi, atzọkha izi rani sẹ abọra k'atzọhngkpa p'odimbọhk kw'Aarọn, ọmaana pa va pẹ p'ijinọng, ọmaana ka nnọhnadim s'adimbọhk pabẹ, ọmaana ka nnọhnadim s'adimmo pabẹ. An-apyakhi izi k'akhaan-akhaan biphyir p'ijafọhnibe nna. ");
INSERT INTO mfo_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Biri tzọkha izi rani k'ijafọhnibe, attara k'ana pa bẹ am-abyengi ọnọng k'eho apyakhi Aarọn, ọmaana ka nnya sẹ, abira apyakhi va pẹ p'ijinọng, ọmaana ka nnya sabẹ. Mẹ wọ, kẹ ọmaana va pẹ p'ijinọng, ọmaana nnya sabẹ án-ade anọng pa bẹ akk'asa awur. ");
INSERT INTO mfo_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Kọ tzọkha iyaak s'erukhimaan-dim nda, ọmaana iyaak s'ẹsara, ọmaana iyaak s'ibubh abhọri, ọmaana s'ibubh anaang, ọmaana iyaak sa ndọdọri, ttara ọtzaak kw'odimmo. Ma wọ ode erukhimaan-dim ch'ẹbọhk-nana. ");
INSERT INTO mfo_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","M'ikhiriba nna sa brẹd kwa bẹ ani yist akhe, s'iwobh m'itzitzikha s'Ọvaar Ibinọkpaabyi, kọ tzọkha brẹd wani, wani kw'ọdọhni-ọdọhni kwa bẹ akhe ana, ttara wani kw'oyor-oyori. ");
INSERT INTO mfo_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Kọ tzọkha pyẹ biphyir akhe Aarọn, ọmaana va pẹ p'ijinọng ka mbọhk, awokhi pyẹ mach'ẹnanga ch'ẹbar-odik k'itzitzikha s'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","An-atzọkha pyẹ ka mbọhk sabẹ, akwọmi k'ijafọhnibe, ttara ẹnanga ẹkwọmichẹ, ch'ẹdaami Ọvaar Ibinọkpaabyi eruk, ẹnanga cha bẹ areng k'ekpon akwọmi anang Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","K'ogbe kw'akk'ẹba ch'erukhumaan-dim nda atzima asi ẹbọhk-nana ch'Aarọn, mach'ẹnanga ch'ẹbar-odik k'itzitzikha s'Ọvaar Ibinọkpaabyi, ch'éde ekkema chọ. ");
INSERT INTO mfo_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Kọ tzọkha nden nna s'erukhimaan-dim ch'ẹbọhk-nana, s'Aarọn ọmaana va pẹ p'ijinọng, aba p'ira bẹ awokhi, ọmaana ọtzaak kw'ira bẹ anangi, asi sẹ nwur. ");
INSERT INTO mfo_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ma wọ ode ekkema cha anọng p'Israẹl am-anang Aarọn ọmaana va pẹ p'ijinọng k'ogbe kpenamkpen. Ma wọ ode ọtzabha kw'anọng p'Israẹl am-asi anang Ọvaar Ibinọkpaabyi, kw'ofona k'ẹnanga chabẹ ch'odidiri. ");
INSERT INTO mfo_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Nnya s'awurada s'Aarọn ngaam va pa va pẹ, ifha bẹ afha abyengi bẹ ana k'eho, ọmaana bi bẹ abira anana bẹ mbọhk k'eho. ");
INSERT INTO mfo_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Nnwa kw'ijinọng kw'ọtzọk ewobha ch'otte mach'ọfọhnẹja, okwu bi okwu osi ọtzọhm k'irukhabe k'Ibe s'Awurada, ọm-ọfọra nnya nna k'iwu izenamfa. ");
INSERT INTO mfo_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Kọ tzọkha erukhimaan-dim ch'ẹbọhk-nana, awọhn chẹ m'ibe s'awurada. ");
INSERT INTO mfo_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","M'ẹhọhmma ch'irukhabe, Aarọn ọmaana va pẹ p'ijinọng awobha mẹ achi nden s'erukhimaan-dim nda, ọmaana brẹd kw'owobh m'ikhiriba nna. ");
INSERT INTO mfo_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Bẹ áchi nnanga nna s'egbobhi ch'ephyokhi, cha bẹ asi k'ẹbọhk-nana chabẹ, ọmaana owuwur kwabẹ. Yina, ọnọng ọdọdọk oningi pyẹ ochi, okhuri bi, pyẹ ewur-owur. ");
INSERT INTO mfo_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Kpenamkpen f'ohobh ewu, ode etzen, obiro ode brẹd, bọng kwọmi chẹ k'ekpon, ọnọng kọ̀khaambi ochi fẹ, okhuri bi, fẹ owur-owur. ");
INSERT INTO mfo_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Si odik kpenamkpen kwa nkk'ndọhna anang Aarọn ọmaana va pẹ p'ijinọng, atzima iwu izenamfa anana bẹ ọbọhk k'eho. ");
INSERT INTO mfo_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ewu kpenamkpen tzima ọbhaamdim asi ẹjafọhni, ch'ede mach'ẹnanga ch'ẹkhọngkwuri ogbogbobhi. Gbobhi ephyok atzima asi ijafọhnibe iwur, abira abyengi sẹ ana, ifha asi sẹ iwur. ");
INSERT INTO mfo_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Tzima iwu izenamfa agbobhi ephyok ch'ijafọhnibe, abira asi sẹ iwur. Mẹ wọ, ijafọhnibe nna in-ide ibe s'awurada, ọttọhk kpenamkpen f'ọttọhmi sẹ ón-owur-owur. ");
INSERT INTO mfo_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Ma wọ ode ẹnanga ch'am-anang k'ijafọhnibe k'ewu kpenamkpen, arukhimaanva afa p'ade cho wani. ");
INSERT INTO mfo_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Nang wani k'ekpebha, abira anang wani k'ẹchọhkha. ");
INSERT INTO mfo_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","K'ocheden-rukhimaan-nwa, yoma ogbobhimbọhk wani k'agbobhimbọhk jobh p'abubuma pa wit, attara ẹna-gbomma dani ch'ana p'olive, ọmaana etzuk-gbomma dani atzima mach'ẹnanga ch'etzuk-byengi. ");
INSERT INTO mfo_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Kọ tzima orukhimaan-nwa nwonggo asi ẹjafọhni k'ẹchọhkha, ttara ẹnanga ch'abọkpa, ọmaana ẹnanga ch'etzuk-byengi mach'ira asi k'ekpebha, ch'ẹdaami eruk, cha bẹ areng k'ekpon akwọmi anang Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Igbọ s'ikwu k'ororo im-isi ẹnanga ẹkwọmichẹ nda k'ogbe kpenamkpen, k'ẹhọhmma ch'irukhabe, k'itzitzikha s'Ọvaar Ibinọkpaabyi. Mẹ wọ kwa kaam ńgebh-ọ, mbiri mgbaak atzim nnang-ọ; ");
INSERT INTO mfo_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","mẹ wọ kwa kaam mbiri ńgebha anọng p'Israẹl, ńdima abarada paam nsi ibe nna iwur. ");
INSERT INTO mfo_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Mẹ wọ, kaam ńsi irukhabe nna ọmaana ijafọhnibe nna iwur, mbiri ńsi Aarọn ọmaana va pẹ p'ijinọng awur, ifha bẹ asi ọtzọhm f'afọhnẹja. ");
INSERT INTO mfo_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Mẹ wọ, kaam ńwobha k'ottem kw'anọng p'Israẹl, mbiri nde Ibinọkpaabyi kwabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Bẹ áronga bi, kaam wọ nde Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabẹ, kw'otzim bẹ obina k'Ijip, ifha nnuk ttara bẹ. Kaam wọ nde Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Bọng dima mgbaakha s'akasiya asi ijafọhnibe sa bọng am-akwọmi insẹns. ");
INSERT INTO mfo_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Si sẹ ikhaama akhubha anna. Adum pẹ ọmaana ẹkpa chẹ áde ebenga-mbọhk kw'ode ẹtzọkhi ọmaana igbokha, ebe chẹ éde ndọkhi nttaan, abhik pẹ afona m'ẹgbaakha nduma dani. ");
INSERT INTO mfo_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Tzima gol ọkkakka abubha ebir-ebir kwẹ, ọmaana akhaan-akhaan pẹ biphyir, ttara abhik. Abira atzima gol abhọri ammakpabem pẹ akhori. ");
INSERT INTO mfo_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Tzima gol asi ariring afa, akhe bẹ akkeri ayok itzitzikha m'ijafọhnibe nna, k'irekh-irek kw'ammakpabem mba pa gol, ifha bẹ abọkha mkpọmmachi sa bẹ am-atzima atzini ijafọhnibe nna. ");
INSERT INTO mfo_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Tzima mgbaakha s'akasiya asi mkpọmmachi, atzima gol abhọri sẹ. ");
INSERT INTO mfo_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Hok ijafọhnibe nna k'itzitzikha s'ekpekhe ch'ewobh k'itzitzikha s'Ẹkkọhbhi ch'Echekhi, k'itzitzikha s'ẹkkọhbhikpa ch'ephyokhi ch'ewobh k'ebir-ebir kw'Ẹkkọhbhi ch'Echekhi, kẹ da kaam ńgebh-ọ. ");
INSERT INTO mfo_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“K'ekpebha kpenamkpen, Aarọn ọkhaambi ọkwọmi insẹns kw'ọdaami eruk m'ijafọhnibe nna, k'ogbe kw'ọm-ọtza okkeri attwikkaang. ");
INSERT INTO mfo_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Kẹ ọkhaambi obiro ọkwọmi insẹns, mada oyeni attwikkaang k'ẹchọhkha, mẹ wọ, insẹns ákwọmi k'ogbe kpenamkpen k'itzitzikha s'Ọvaar Ibinọkpaabyi, maa apyiri k'igbọ s'ikwu k'ororo. ");
INSERT INTO mfo_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Bọng insẹns adọdọk kàtzima akwu m'ijafọhnibe nna, ode ẹnanga ẹkwọmichẹ kpenamkpen, obiro ode ẹnanga ch'abọkpa o, ode etzuk-byengi o, bọng m'ijafọhnibe nna kàsi. ");
INSERT INTO mfo_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aarọn om-osi ẹjafọhni nda ch'ephyokhi ogbe wani ka cho, k'abhik p'ijafọhnibẹ nna. Kẹ ọkhaambi otzima izi s'etzen osi ẹjafọhni nda ch'ephyokhi cha cho, ch'éde ẹnanga ch'ẹkhọngkwuri ogbogbobhi, ch'igbọ s'ikwu k'ororo. Ẹjafọhni nda ede ch'ewur-owur ẹnang Ọvaar Ibinọkpaabyi.” ");
INSERT INTO mfo_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, ");
INSERT INTO mfo_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Mada atzọkha obhik kw'anọng p'Israẹl, ọnọng kpenamkpen ọkhaambi osi ẹtzabha ch'ebhekha ch'akpen pẹ ọnang Ọvaar Ibinọkpaabyi, mada bẹ abhikh-ẹ. Mẹ wọ, itzama s'ítto ikhebha bẹ kíde, mada abhik bẹ. ");
INSERT INTO mfo_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ọnọng kpenamkpen kwa bẹ akk'abhikha, ọnang ishẹkẹl-bhakha otzor ka shẹkẹl kw'ọhọhm kw'awurada, kw'ọdọhbhi opyiri agẹra ẹrọbh. Ishẹkẹl-bhakha nna ide ẹnanga ẹnang Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Anọng biphyir pa bẹ akk'abhikha p'ade cho ẹrọbh obhir-obhiri, ánang Ọvaar Ibinọkpaabyi ẹnanga. ");
INSERT INTO mfo_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Mada bọng ási ẹnanga ch'ephyokhi anang Ọvaar Ibinọkpaabyi, tte akkọkkaa aningi anangi ayongi ishẹkẹl-bhakha, agbogbora aningi abira anang f'ọkhar ọyọhnga ishẹkẹl-bhakha. ");
INSERT INTO mfo_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Kọ tzọkha ọtzabha kw'ẹjafọhni ch'ephyokhi k'anọng p'Israẹl, atzima asi ọtzọhm f'irukhabe s'Ọvaar Ibinọkpaabyi. Odik nwa ode ojima ọnang anọng p'Israẹl k'itzitzikha s'Ọvaar Ibinọkpaabyi, obiro óde ẹjafọhni ch'ephyokhi ọnang for sabọng ọkhaam.” ");
INSERT INTO mfo_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, ");
INSERT INTO mfo_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Tzima brons asi ọkwakkama kwa mbọhk ttara mmo ogbogbobhi, abira atzima brons asi ẹnana chẹ. Kẹ asi m'ọkwakkama nwa, aber-ẹ k'ottem kw'irukhabe ttara ijafọhnibe. ");
INSERT INTO mfo_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Tte Aarọn ọmaana va pẹ p'ijinọng agbobhi mbọhk, ọmaana mmo sabẹ, ttara asi p'ọkwakkama nwa. ");
INSERT INTO mfo_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","K'ogbe kpenamkpen kwa bẹ adim m'irukhabe nna, bẹ ágbobhi mbọhk ọmaana mmo, ifha bẹ aningi ápe. Bẹ abira asi mando k'ogbe kwa bẹ arenga afora ijafọhnibe nna bi, bẹ atza asi ẹnanga ch'ọchattọhk anang Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Bẹ ágbobhi mbọhk, ọmaana mmo sabẹ, ifha bẹ aningi ápe. Ọphaangi nwa owobha ọnang Aarọn, ọmaana va pẹ p'ijinọng, ttara va pa va pẹ, maa apyiri k'igbọ s'íkwu k'ororo.” ");
INSERT INTO mfo_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, ");
INSERT INTO mfo_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Tzọkha adem mba p'ekpo ọkkakka py'em-esi ọttọhk ọdaam eruk: mach'ashẹkẹl ẹnọhna obhiri arọbh azen pa myrrh kw'ode asi-asi, ọmaana ashẹkẹl arọbh jobh obhiri afa obhiri jobh pa sinamọn, ọmaana ashẹkẹl arọbh jobh obhiri afa obhiri jobh pa kalamus, ");
INSERT INTO mfo_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ọmaana ashẹkẹl ẹnọhna obhiri arọbh azen pa kasiya. Bẹ biphyir atzor k'ẹnanga ch'ọhọhm kw'awurada, ttara ẹna-gbomma ch'ana p'oliv. ");
INSERT INTO mfo_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Kọ tzima pyẹ asi ana p'ẹbọhk-nana ch'awurada, p'adaami eruk, ọtzọhmbọhk f'osi-ekpo py'ẹm-ẹdaam eruk, osi. Bẹ áde ana p'ẹbọhk-nana ch'awurada. ");
INSERT INTO mfo_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Mẹ wọ, byengi bẹ k'irukhabe, ọmaana k'Ẹkkọhbhi ch'Echekhi, ");
INSERT INTO mfo_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ọmaana k'okpokkoro ttara ekpo py'ẹnan mẹ biphyir, ettwikkaang-chi ttara ekpo pyẹ biphyir, ọmaana k'ijafọhnibe s'insẹns, ");
INSERT INTO mfo_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ọmaana ijafọhnibe s'ẹnanga ẹkwọmichẹ ttara ekpo pyẹ biphyir, ọmaana ọkwakkama ttara ẹnana chẹ. ");
INSERT INTO mfo_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Kọ ási pyẹ ewur, ifha pyẹ en-edo ewur-owur, ọttọhk kpenamkpen f'ọtọhmi pyẹ, fẹ on-owur-owur. ");
INSERT INTO mfo_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Kọ si Aarọn ọmaana va pẹ p'ijinọng awur, ifha bẹ afha asi ọtzọhm f'afọhnẹja. ");
INSERT INTO mfo_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Gbaak anọng p'Israẹl bi, ‘Ana mba ade ana paam p'ẹbọhk-nana ch'awurada, maa apyiri k'igbọ s'íkwu k'ororo. ");
INSERT INTO mfo_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ọnọng ana mba ka for kàbyengi, ana adọdọk kabira asi m'eden nda ch'asi mba, okhuri bi, ana mba ade ana p'awurada, bọng abira atzọkha bẹ bi, be ade ana p'awurada. ");
INSERT INTO mfo_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ọnọng kpenamkpen kw'on-osi ana p'adaami eruk macha mba, ode bi, ọnọng on-obiro obyengi ọnọng ọdọdọk ana mba kw'oyongi ọfọhnẹja, bẹ akhaambi akhubh-ẹ k'obhon.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Tzọkha ekpo py'em-esi ekpo ẹdaam eruk macha resin, onicha, ọmaana galbanum, ttara insẹns ọkkakka, ayoma pyẹ mbengana, ");
INSERT INTO mfo_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","abhuna pyẹ atzima asi insẹns, ode ọtzọhmbọhk f'osi-ekpo py'ẹdaami eruk. Insẹns nwa ode abubuma, ode ọkkakka kwẹ, obiro ode kw'awurada. ");
INSERT INTO mfo_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Tzọkha byani akhok k'abubuma, atzọkha abera k'itzitzikha s'Ẹkkọhbhi ch'Echekhi, k'irukhabe, kẹ da kaam ńgebh-ọ. Sẹ íde ibe s'in-ido iwur-owur inang bọng. ");
INSERT INTO mfo_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Kọ insẹns ọdọdọk manda wani m'eden nda kàsi anang for sọ. Kọ re bẹ mach'ana p'awurada anang Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ọnọng manda wani kw'osi ana p'akheri mba, ifha ọbhaanga eruk-daamada chẹ, bẹ akhaambi akhubh-ẹ k'obhon.” ");
INSERT INTO mfo_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Iwa Ọvaar Ibinọkpaabyi oben Mosẹs bi, ");
INSERT INTO mfo_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Kker e, kaam nkk'Bẹzalẹl nnwa kw'ijinọng kw'Uri, kw'ode nnwa kwa Hur k'efona cha Juda ndekha. ");
INSERT INTO mfo_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Kaam nkk'ẹ Egwugwuma ch'Ibinọkpaabyi nnanga, ọmaana ekkoji, ọmaana eronga, ttara otzitzin kw'emengkka kpenamkpen osisi, ");
INSERT INTO mfo_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ifha osi ọtzọhm f'otzetzekha fa gol, ọmaana silva, ttara brons, ");
INSERT INTO mfo_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","f'ọkpaara atza obiro odokha bẹ, ọmaana nchi ọgwagwa, ttara omengkka-tzọhm kpenamkpen osisi. ");
INSERT INTO mfo_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ayongi mẹ, kaam nkk'Oholiyab nnwa kw'ijinọng kw'Ahisamak, k'efona cha Dan ndekha bi, ọkhẹ-ẹ ọbọhk. Kaam nkk'amengkkakkaa biphyir emengkka nnanga, cha bẹ atzima asi ọttọhk kpenamkpen fa nkk'ọ ndọhna: ");
INSERT INTO mfo_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","mach'irukhabe, ọmaana Ẹkkọhbhi ch'Echekhi, ọmaana ẹkkọhbhikpa ch'ephyokhi, ttara ekpo py'ẹnya ẹdọdọk biphyir py'ikhira nna, ");
INSERT INTO mfo_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","mach'okpokkoro ttara ekpo py'ẹnana mẹ biphyir, ọmaana ettwikkaang-chi cha gol ọkkakka ọmaana ekpo pyẹ biphyir, ọmaana ijafọhnibe s'insẹns, ");
INSERT INTO mfo_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ọmaana ijafọhnibe s'ẹnanga ẹkwọmichẹ ọmaana ekpo biphyir py'ẹtzọni chẹ abẹ, ọmaana ọkwakkama ttara ẹnana chẹ, ");
INSERT INTO mfo_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ọmaana nnya nyokhasẹ, nnya s'awurada s'Aarọn kw'ode ọfọhnẹja, ọmaana nnya sa va pẹ p'ijinọng k'ogbe kwa bẹ asi ọtzọhm f'afọhnẹja, ");
INSERT INTO mfo_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ọmaana ana pa bẹ am-abyengi ọnọng k'eho, ttara insẹns kw'ọdaami eruk kwa bẹ ahok k'Ibe s'Awurada. Tte bẹ asi idik nna atzor k'eden cha ndọhn-ọ.” ");
INSERT INTO mfo_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, ");
INSERT INTO mfo_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Ben anọng p'Israẹl bi, bọng akhaambi ahok Nwọhngkwokhawu saam. Ma wọ óde ẹkhọhkha k'ottem kwa kaam ọmaana bọbọng, ttara igbọ s'íkwu k'ororo, ifha bọng aronga bi, kaam wọ nde Ọvaar Ibinọkpaabyi, kw'om-osi bọng awur. ");
INSERT INTO mfo_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“Bọng hok Ẹwọhngkwokhawu nda, okhuri bi, ch'ede ewu ch'awurada ẹnang bọng. Ọnọng kpenamkpen kw'olukhi ewu nda, bẹ akhaambi afhẹ-ẹ; ọnọng kpenamkpen kw'osi ọtzọhm manda vani m'ewu nda, bẹ akhaambi afhẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Iwu izadani rọ sa bọng asi ọtzọhm, yina, ewu nda ch'ettonga izenamfa, ede Ẹwọhngkwokhawu ch'awurada ẹnang Ọvaar Ibinọkpaabyi. Ọnọng kpenamkpen kw'ọsi ọtzọhm m'ewu nda, bẹ akhaambi afhẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Mẹ wọ, anọng p'Israẹl ahok Ẹwọhngkwokhawu nda, bẹ ahok ewu nda k'igbọ s'íkwu k'ororo mach'echekhi ch'ewobha maa, ogbe ode. ");
INSERT INTO mfo_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ewu nda éde ẹkhọhkha k'ottem kwa kaam ọmaana anọng p'Israẹl maa ipemanitzor, okhuri bi, Ọvaar Ibinọkpaabyi otzim iwu izadani osi ẹrọng ọmaana irerek, yina, k'ewu ch'ettong izenamfa ọn-ọkwọbha ọtzọhm, okwokha ọwọhng.” ");
INSERT INTO mfo_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Mada Ọvaar Ibinọkpaabyi okk'Mosẹs idik nna ọgbaakha okyera k'egbegbeho cha Sinai, ọn-ọtzọkha atza-gbẹgbẹri afa p'asana pa kẹ Ibinọkpaabyi otzima ẹnọhna chẹ ọkkẹr, ọnang Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mada anọng mba p'Israẹl are bi, Mosẹs okk'ogbe on-okhibhi kpọng k'egbegbeho bi, okhuna, bẹ afona atza akhọri Aarọn, aben bi, “Kwu si akha anang man p'atzima man eden. Onode ayi Mosẹs kw'otzim man obina k'Ijip, modik korong kw'ọkk'ọtta okhebh-ẹ.” ");
INSERT INTO mfo_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Mẹ wọ, Aarọn obhina bẹ bi, “Bọng wọra ekpo py'itzọhng pya gol pya panọng pabọng, ọmaana pya va pabọng p'ijinọng ttara p'ipanọng akhe, atzọkha achen-m.” ");
INSERT INTO mfo_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Mẹ wọ, anọng mba biphyir awọra ekpo pyabẹ p'itzọhng pya gol achena Aarọn. ");
INSERT INTO mfo_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ọtzọkha ekpo pya bẹ akk'ẹ achena, otzima oduk ọgbatza kw'okheri ọbhaamnwa, odokh-ẹ ttara ọtzọhm-ttọhk. Mẹ wọ, bẹ aben bi, “O Israẹl, ma wọ ode akha pa bọng, p'atzim bọng abina k'Ijip e.” ");
INSERT INTO mfo_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Mada Aarọn ore odik nwa, osi ijafọhnibe m'itzitzikha s'ọbhaam-nwa nwa, ogwon ẹmọng oben bi, “Ophyini, mósi ọdadaami ọnang Ọvaar Ibinọkpaabyi e.” ");
INSERT INTO mfo_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Mẹ wọ, ewu ehobh mẹ, anọng mba aphyọbha k'ekpekpebha, asi nnanga nkwọmisẹ, bẹ abira atzima nnanga s'odidiri akwu. Mada bẹ akk'mando asa, bẹ an-awobha ẹwọr achi abira agwo, yina bẹ an-abin attubha k'ọdadaami kw'ebyibya. ");
INSERT INTO mfo_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Kọ hakha, okhuri bi, anọng pọ p'atzim abina k'Ijip akk'an-akhibhi. ");
INSERT INTO mfo_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Bẹ akk'idudukha atzima akpa nnam abọra asana pa nnangi bẹ, bẹ akk'ọgbatza abira adukha kw'ode mach'ọbhaam-nwa. Bẹ akk'nho ahakha anang-ẹ, bẹ akk'ẹjafọhni abira asa anang-ẹ, bẹ aben bi, ‘Israẹl o, ma wọ ode akha pabọng e, p'atzim bọng abina k'Ijip e.’ ");
INSERT INTO mfo_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","“Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Kaam nkk'anọng mba nna, bẹ ade anọng p'agaangi eho e.” ");
INSERT INTO mfo_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Na tte-m ọbọhk ngọhkha bẹ ittemdọkhiji saam, ifha mbiri ndimi bẹ. Mẹ wọ, kaam nna ńsọ-ọ ẹkhọma ch'ideden.” ");
INSERT INTO mfo_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Yina, Mosẹs ophyem Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwẹ ọphyaam, oben bi, “O Ọvaar Ibinọkpaabyi, ode yan kw'an-adọkhi ettem ttara anọng pọ p'atzim abina k'Ijip, ttara ẹfa chọ ch'ideden ọmaana ekhema o? ");
INSERT INTO mfo_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Okhuri yan kw'anọng p'Ijip an-aben bi, ‘Wa akhaam ochibhi-tzama yina atzima anọng mba abina k'Ijip bi, akwu afhu bẹ ma mgbegbeho nna, abira adimi che chabẹ m'ọyagbin o?’ Mkpa nnam abọra ittemdọkhiji sọ, hakha ettem, anọng pọ itzama kasi. ");
INSERT INTO mfo_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Kọ jima atzọhmnọng pọ Abraham, ọmaana Isaak, ttara Jekọb, p'achekhi anang for sọ bi, ‘Kaam ńsi va pa va pabọng ahaabh macha ndodori k'ọrọngkpakpa. Kaam mbiri ńnang va pa va pabọng irerek nna biphyir sa kaam nchekhi nnang bẹ. Sẹ ibiri íde ekkema chabẹ maa ogbe ode.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Mẹ wọ, Ọvaar Ibinọkpaabyi ọhakha ettem chẹ, itzama s'iwa ọkk'ọkhama bi osi anọng pẹ, bẹ dọk kosi. ");
INSERT INTO mfo_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mosẹs ọbhakhi nnam ọhakha k'egbegbeho, otzima atza-gbẹgbẹri afa ka mbọhk sẹ, pa bẹ akkẹri asana ka nnam mfa, k'itzitzikha ttara ka nnam. ");
INSERT INTO mfo_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Iwa atza-gbẹgbẹri mba ade ọtzọhmbọhk f'Ibinọkpaabyi, ọkkẹra kw'owobh m'atza-gbẹgbẹri mba ode ọkkẹra kw'Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Mada Joshua ọbhaang amọng p'anọng am-awuri, oben Mosẹs bi, “Agbong-mọng awobh k'ibhingabe.” ");
INSERT INTO mfo_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mosẹs obhina bi, “Ẹmọng ch'ekhema arang mẹ, ẹbomọng arang mẹ, ẹmọng ch'ọkkọhna dọ cha kaam mmaang.” ");
INSERT INTO mfo_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mada Mosẹs oreng ọbaanga k'ibhingabe, on-ore ọbhaamnwa, ttara otzubha, ọdọkhi ettem ọbhari atza-gbẹgbẹri p'otzim ka mbọhk, ọvọhkhi bẹ k'abir-ibiri m'orin kw'egbegbeho nda. ");
INSERT INTO mfo_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","On-obiro ọtzọkha ọbhaamnwa nwa kwa bẹ akk'asa ọbhabh k'ekpon, yina ọn-ọtzọkh-ẹ okhok k'abubuma, ọtzọkha abubuma mba ọnyaani k'asi, oben anọng p'Israẹl agwo bẹ. ");
INSERT INTO mfo_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Mosẹs oben Aarọn bi, “Anọng mba asọ-ọ yan kw'atzim bẹ asi ẹkhọngkwuri ch'ẹbari manda o?” ");
INSERT INTO mfo_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aarọn obhina bi, “Itta kwaam, tte oning-ọ ọdọkhi, kọ arong odem kw'itzama ikpaang anọng mba osisi khẹ. ");
INSERT INTO mfo_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Bẹ-bẹ bọ aben-m bi, ‘Si akha anang man p'atzima man eden. Onode ayi Mosẹs kw'otzim man obina k'Ijip, modik korong kw'ọkk'ọtta okhebh-ẹ.’ ");
INSERT INTO mfo_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Mẹ wọ, mben bẹ bi, ‘Ọnọng kpenamkpen kw'ọkhaam gol, tte ọwọra.’ Mẹ wọ, bẹ awọra anang-m, ndini mmari k'ekpon, ofona mẹ, ọbhaamnwa nwa oyin!” ");
INSERT INTO mfo_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mosẹs okwu ore bi, anọng mba an-asi itzimabhaang s'ideden, ttara bi, Aarọn okk'bẹ ọbọhk ọtta bẹ attena akwọbha eden, maa bẹ an-ade ọhamma-dik anang attattaanga-nọng pabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Mẹ wọ, Mosẹs on-obe k'ẹbaakhamma ch'ibhingabe, oben bi, “Ọnọng kpenamkpen kw'obe ttara Ọvaar Ibinọkpaabyi, tte orenga otzor-m.” Mẹ wọ, abaLẹvi biphyir amun atzor-ẹ khẹ. ");
INSERT INTO mfo_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Mẹ wọ, oben bẹ bi, “Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'Israẹl obeni bi, ‘Tte ọnọng-ọnọng ọkpa ọkkangkkaang kwẹ k'erin. Bọng nnenga achina itzitzikha akpa nnam, akhọri abobongi p'ibhingabe nna. Tte ọnọng-ọnọng ofhu ọgbaanọkka kwẹ, ọmaana oyokhẹkhaan, ttara oyokh-ẹbaanga kwẹ.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","AbaLẹvi asi macha Mosẹs obeni bẹ, m'ewu nduma, anọng nnọhna nzenamfa obhiri arọbh jobh, ape. ");
INSERT INTO mfo_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Mẹ wọ, Mosẹs oben bi, “Ọvaar Ibinọkpaabyi okk'bọng otzekha mayina, da bọng attaang anang osisi kwa va pabọng p'ijinọng, ọmaana votte pabọng, mẹ wọ, kẹ okk'bọng ọda m'ewu cha mayina.” ");
INSERT INTO mfo_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ewu ehobh mẹ, Mosẹs oben anọng mba bi, “Bọng akk'ẹkhọngkwuri ch'ideden asa. Yina, kaam nna ńda k'Ọvaar Ibinọkpaabyi, asi mẹ kaam mfha nsi ephyokhi ch'egbobhi ẹkhọngkwuri chabọng osi.” ");
INSERT INTO mfo_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mẹ wọ, Mosẹs ọkpa nnam k'Ọvaar Ibinọkpaabyi, oben bi, “Anọng mba akk'ẹkhọngkwuri ch'ideden asa! Bẹ akk'gol atzima asi akha anang for sabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Yina, tzotzokhaan bina anang ngọngkwuri sabẹ, ani bẹ afha bina anang, rọbha che chaam ka nnwẹr kw'akk'akkẹra.” ");
INSERT INTO mfo_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ọvaar Ibinọkpaabyi obhina Mosẹs bi, “Ọnọng kpenamkpen kw'okk'ẹkhọngkwuri ọsa k'itzitzikha saam, che chẹ dọ cha kaam ńnọbha ka nnwẹr kwaam. ");
INSERT INTO mfo_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Kọ rọhng madẹdẹn, atzima anọng mba eden achina k'ibe sa ira mgbaakh-ọ, itzọhmi saam rọ íchi bọng eden. Yina, ogbe opyipyiri kwa kaam ńnang ettuma, kaam ńnang bẹ ettuma ọnang k'ẹkhọngkwuri chabẹ.” ");
INSERT INTO mfo_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Mẹ wọ, Ọvaar Ibinọkpaabyi ọtzọhm itzama ochena anọng mba, okhuri ọttọhk fa bẹ asi ttara ọgbatza nwa kw'okheri ọbhaamnwa, kw'Aarọn ọkk'odukha. ");
INSERT INTO mfo_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Kọ ọmaana anọng mba p'atzim abina k'Ijip, bọng bina aji irerek nna. Bọng china k'irerek sa kaam nkk'nchekhi k'ọnwọhngi nnang Abraham, ọmaana Isaak, ttara Jekọb, mben bi, ‘Kaam ńnang va pa va pabọng irerek nna.’ ");
INSERT INTO mfo_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Kaam ńdọhm itzọhmi saam ichi bọng eden, bọng akhubh abaKenaan, ọmaana abAmọr, ọmaana abaHet, ọmaana abaPẹriz, ọmaana abaHiv, ttara abaJẹbus. ");
INSERT INTO mfo_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Bọng nọhng k'irerek nna s'abasi ọmaana akhọkhọnana ahaabh-ọhaabh. Yina, kaam bọng abẹ kíndọn, okhuri bi, bọng ade anọng p'agaangi eho, kaam mfha ndimi bọng odimi k'eden.” ");
INSERT INTO mfo_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Mada anọng mba abhaang ẹkkaabha-tzama nda, bẹ an-awobha ka nkkwosisi, ọnọng kw'obiro ọfọra ẹfhanginẹ-kpo manda byani kode. ");
INSERT INTO mfo_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Da Ọvaar Ibinọkpaabyi okk'Mosẹs obena bi, “Gbaak anọng p'Israẹl bi, ‘Bọng ade anọng p'agaangi eho. Idikha ira kaam ndọni bọng abẹ mfona k'igbegbaa m'orenga nwa, ira kaam mfha ndimi bọng odimi. Mẹ wọ, bọng wọra ẹfhanginẹ-kpo pyabọng, ifha ńnonga ọttọhk fa kaam ńsi ttara bọng.’ ” ");
INSERT INTO mfo_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Mẹ wọ e, anọng p'Israẹl awọra ẹfhanginẹ-kpo pyabẹ k'egbegbeho cha Horẹb. ");
INSERT INTO mfo_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mẹ wọ, wa Mosẹs ọm-ọtza ottima ikhira k'iyaan-iyaan, s'ororo kw'ibhingabe, oyeri sẹ “Ikhira s'etzobha.” Ọnọng kpenamkpen kw'orori Ọvaar Ibinọkpaabyi, om-ochina k'ikhira s'etzobha s'iwobh k'iyaan-iyaan s'ibhingabe. ");
INSERT INTO mfo_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ogbe kpenamkpen kwa Mosẹs ochin k'ikhira nnuma, anọng biphyir abina abe ka nhọhmma s'okhira fabẹ, am-akkeri Mosẹs maa odim k'ikhira nna ẹtzaanga. ");
INSERT INTO mfo_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mada Mosẹs odimi k'ikhira ẹtzaanga, eboni ch'ebe iduduma ẹm-ẹhakha, ekwu ewobha m'ehọhmma, da Ọvaar Ibinọkpaabyi ọm-ọgbaak atzim ttara Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","K'ogbe kpenamkpen kw'anọng mba are da eboni ebe k'ẹhọhmma ch'ikhira nna, bẹ biphyir abina abe k'ikpokpobha, ọnọng-ọnọng k'ẹhọhmma ch'ikhira sẹ. ");
INSERT INTO mfo_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Wa Ọvaar Ibinọkpaabyi ọm-ọgbaak atzim ọnang Mosẹs itzitzikha ttara itzitzikha, mach'ọnọng ọgbaakhi oyok-ẹkhaan kwẹ atzim. Mẹ wọ, Mosẹs ọkpa nnam ochina k'ibhingabe. Yina, Joshua, kw'ode odikkobh kw'ọm-ọtzọn-ẹ abẹ, obiro ode nnwa kwa Nun, k'ikhira nna kobin. ");
INSERT INTO mfo_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mosẹs oben Ọvaar Ibinọkpaabyi bi, “Kọ akk'aam am-abena bi, ndima anọng mba eden, yina, kaam ọnọng atzima am-atzibha kw'ọtzọn-m abẹ. Kọ akk'abena bi, ‘Kaam nnọng che chẹ khẹ, kọ ọkk'ọphyaam faam atzọkha.’ ");
INSERT INTO mfo_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Idikha kaam nkk'ọphyaam ndọkha k'itzitzikha sọ, tzibh-m nden sọ, ifha kaam nnong-ọ, mbiri china ororo ndọkha ọphyaam fọ. Jima bi ẹkhọma nda ede anọng pọ o.” ");
INSERT INTO mfo_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ọvaar Ibinọkpaabyi obhina bi, “Kaam ọkhaam ńdọn-ọ bẹ mofona, mbiri nnang-ọ ẹwọhngkwokha ọnang.” ");
INSERT INTO mfo_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mẹ wọ, Mosẹs oben-ẹ bi, “Idikha kọ ọkhaam ani man abẹ atzọn mofona, man ọbọhk katte mobina ma ibe nna. ");
INSERT INTO mfo_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Yan wọ kw'ọnọng otzima oronga bi, ettem ẹdaam-ọ kẹ ttar-m, ọmaana anọng pọ, idikha ani man abẹ atzọni? Mbọng vọ ode odengọmi kwa kaam ttara anọng pọ, k'itzitzikha s'anọng adọdọk p'arukhi m'ọyagbin o?” ");
INSERT INTO mfo_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ọvaar Ibinọkpaabyi obhina Mosẹs bi, “Kaam nsi osi macha akk'aphyema, okhuri bi ettem ẹkk'aam ẹdaama ttara kọ, kaam mbiri nnong-ọ ka che.” ");
INSERT INTO mfo_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mẹ wọ e, Mosẹs oben bi, “Kọ na khọkh-m abarada pọ.” ");
INSERT INTO mfo_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ọvaar Ibinọkpaabyi oben bi, “Kaam ńsi ajibhada paam biphyir achi bọng eden, m'itzitzikha sabọng, kaam ḿbiri ńsi ẹjaakhi cha che chaam, ch'ede Ọvaar Ibinọkpaabyi. Kaam ńgaama nkwu-osisi ttara ọnọng kw'ọdaakh-m, mbiri ńsi ejibha nnang ọnọng kwa kaam ńsi ejibha. ");
INSERT INTO mfo_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Yina, kọ itzitzikha saam kafha are, okhuri bi, ọnọng kw'ofha ore kaam oruk akpen kode.” ");
INSERT INTO mfo_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Mẹ wọ, Ọvaar Ibinọkpaabyi oben bi, “Ọkhaam ibe rani s'ibaang-m, s'afha abe k'ẹtzakpa. ");
INSERT INTO mfo_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Mada abarada paam akwọbha, kaam ndọkh-ọ nge k'ọtzakpa-mma, mbubh-ọ ttara ọbọhk kwaam maa nkwọbha. ");
INSERT INTO mfo_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Mẹ wọ, kaam ńnọbha ọbọhk kwaam, kọ án-are nnam saam, yina, itzitzikha saam kafha are.” ");
INSERT INTO mfo_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Kpaara atza afa macha mbonggo p'echeden, kaam mbiri nkkẹr atzim mba p'iwa awobh k'atza-gbẹgbẹri mba p'echeden p'avọhkhi. ");
INSERT INTO mfo_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Kọ do for k'ekpebha avura akhebh-m k'egbegbeho cha Sinai. Kebh-m k'egbegbeho ebira. ");
INSERT INTO mfo_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Tte ọnọng manda wani oning-ọ abẹ ọtzọni okwu, ọnọng oningi k'ibe kpenamkpen m'egbegbeho nda ode, kaambi etzirakpo pyọ, tte eningi araraari m'egbegbeho nda echi.” ");
INSERT INTO mfo_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Mẹ wọ, Mosẹs ọkpaara atza-gbẹgbẹri afa macha p'echeden, otzima bẹ k'ekpebha ovura egbegbeho cha Sinai, mach'Ọvaar Ibinọkpaabyi ọkk'ẹ ọtzọhna, obiro otzima atza-gbẹgbẹri mba afa ka mbọhk sẹ. ");
INSERT INTO mfo_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Mẹ wọ, Ọvaar Ibinọkpaabyi ọhakha k'eboni, obe Mosẹs m'ẹbhabhaanga, ọsi ẹjaakhi cha che chẹ, ch'ede Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ọkwọbha Mosẹs k'itzitzikha osi ẹjaakhi bi, “Ọvaar Ibinọkpaabyi, Ọvaar Ibinọkpaabyi nwa, ode Ibinọkpaabyi kw'inọngkwo, ọmaana ọphyaam, kw'ọm-ọtzọkha ogbe yina ọn-ọdọkh-ẹ, kw'ofu ttara idadaakha, ọmaana ekhera, ");
INSERT INTO mfo_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","kw'ọkhọhk idadaakha sẹ ọnang anọng nnọhna nnabhik, obiro obina ọnang itzama, ọmaana oho gaangi, ttara ẹkhọngkwuri. Yina, kẹ ọnọng kw'aponga apyibhi ọbọhk kotte, kẹ obiro ọnang va ọmaana va pa va pabẹ ettuma, ka ngọngkwuri s'ab'otte, maa apyiri mgbọmma nttaan ọmaana nna.” ");
INSERT INTO mfo_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","M'ẹbaa mẹ, Mosẹs ọrakha eho k'ikpokpobha. ");
INSERT INTO mfo_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Oben bi, “O Ọvaar Ibinọkpaabyi, idikha kaam nkk'ọphyaam ndọkha k'itzitzikha sọ, tte kọ Ọvaar Ibinọkpaabyi arenga ttara man. Kaambi ode bi anọng mba ade atzimabhaang-nọng, bina anang man k'itzama saman, abira atzọkha man mach'anọng pọ.” ");
INSERT INTO mfo_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Mẹ wọ, Ọvaar Ibinọkpaabyi oben bi, “Kaam na ndọkha echekhi ttara kọ. Anọng pọ biphyir atzima chen pabẹ are íkkokkonidik sa kaam ńsi, sa nindimi minsa k'ẹkhọma manda dani k'ọyagbin biphyir. Anọng p'arukhi ọmaana bọng ábira are ijoradik sa kaam Ọvaar Ibinọkpaabyi ńsi nnang bọng. ");
INSERT INTO mfo_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Hakha eho anang idik sa mben-ọ bi, asi mayina. Kaam ńgwubh abAmọr, ọmaana abaKenaan, ọmaana abaHet, ọmaana abaPẹriz, ọmaana abaHiv, ttara abaJẹbus. ");
INSERT INTO mfo_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Bọkh-ọ for o, echekhi kpenamkpen kàkhaama ọmaana anọng mba p'arukhi m'irerek nna sa bọng am-achina o, oni mando ode, bẹ áde agbagbara anang bọng. ");
INSERT INTO mfo_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Bọng vọhkhi ọjafọhnibe fabẹ, ọmaana atza pabẹ p'akha, bọng abira avọhkhi mkpọmmachi s'Ashẹra pabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Bọng ọttọhk ọdọdọk kàkpobha, kkeri, Ọvaar Ibinọkpaabyi, kwa che chẹ ede ottemmamma, ode Ibinọkpaabyi kw'ottemmamma. ");
INSERT INTO mfo_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Bọng bọkha bọng for o, bọng echekhi kpenamkpen kàkhaama ọmaana anọng mba p'arukhi m'irerek nna, okhuri bi, mada be asi ẹzaza ọmaana akha pabẹ bi, bẹ afọhni ẹja anang bẹ, bẹ ábher bọng obher bi, bọng átza achi ẹchakpo pya njafọhni sabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Mada bọng atzọkha aminava pabẹ anang adikkobh pabọng k'ọbada, aminava mba ási ẹzaza anang akha pabẹ, bẹ atzima adikkobh mba pabọng eden otzima, bẹ asi idik nnuma rani. ");
INSERT INTO mfo_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Bọng agbatza kàduk. ");
INSERT INTO mfo_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Bọng si ọdadaami kwa brẹd kwa bẹ ani yist akhe. Bọng chi brẹd kwa bẹ ani yist akhe k'iwu izenamfa, macha nkk'bọng mbena. Bọng si mando k'ogbe kw'ọbaan bi bọng asi, k'ophe kw'Abib, okhuri bi, mophe nwa wọ kw'iwa bọng abin k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Va kpenamkpen p'ichedenmọr ade paam, ttara acheden-va adimpẹ biphyir p'etzirakpo, ode arukhimaan o, obiro ode abhaam. ");
INSERT INTO mfo_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Kọ tzima orukhimaan-nwa abhek ocheden nnwa kw'ẹnyanyaang, yina, idikha ani chẹ abhekhi, phyakhi chẹ ekhokhora. Bhek acheden-va pabọng biphyir. “Ọnọng manda wani oningi mbọhk-mbọhk oreng oyin-m k'itzitzikha. ");
INSERT INTO mfo_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Bọng ási itzọhm k'iwu izadani, yina, bọng akwokha ọwọhng k'ewu ch'ettong izenamfa. Kaambi k'ogbe kw'ekpo ọyayaabha ttara ọphagbe wọ, bọng akhaambi akwokha ọwọhng. ");
INSERT INTO mfo_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Bọng si Ọdadaami kw'Ipha ttara acheden-chiduk py'ekpo pya bọng ayaabh k'iwoni sabọng, ttara acheden-chiduk p'ipha sa wit, ọmaana Ọdadaami kw'Ipha s'ikpong nnam ka cho. ");
INSERT INTO mfo_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Ajinọng pabọng biphyir, akhaambi ayin k'itzitzikha s'Ọvaar Ibinọkpaabyi kw'Ẹfa, kw'ode Ibinọkpaabyi kw'Israẹl, igbe ittaan ka cho. ");
INSERT INTO mfo_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Kaam ńgwubh idibhon ka bọng k'itzitzikha, mbiri mmẹma nnem sabọng. Ọnọng manda wani kw'ọ́bọkha bọng irerek sabọng k'ẹfa ọna kode, m'igbe nna ittaan sa cho sa bọng áyin k'itzitzikha s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng. ");
INSERT INTO mfo_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Bọng kaam izi s'ifon k'ẹjafọhni ch'efon k'ọttọhk kpenamkpen f'ọkhaam yist kanang, bọng katte bi etzen manda dani ch'ẹjafọhni ch'Ọdadaami kwa Pasova, ewobha epyiri k'ekpebhawu ẹdọdọk. ");
INSERT INTO mfo_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Bọng dima acheden-chiduk akkakka k'irerek sabọng, akwu k'ọhọhm kw'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng. Bọng abasi p'evu kàtzima awọhn ovu-nwa.” ");
INSERT INTO mfo_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Mẹ wọ, Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Kkẹr atzim mba, okhuri bi, kaam nkk'echekhi ndọkha ttara kọ ọmaana anọng p'Israẹl ndor m'atzim mba.” ");
INSERT INTO mfo_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Wa Mosẹs owobh ttara Ọvaar Ibinọkpaabyi ka nyawu arọbh afa, ọmaana nnungiwu arọbh afa ọchattọhk kochi, asi kobiro ogwo. Ọkkẹr atzim p'ade Echekhi ch'Asana Jobh m'atza-gbẹgbẹri mba. ");
INSERT INTO mfo_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mada Mosẹs ọhak k'egbegbeho cha Sinai, ttara atza-gbẹgbẹri mba afa p'Echekhi ch'Asana ka mbọhk sẹ, korong bi itzitzikha sẹ in-innọnna, okhuri da kẹ okk'idik ọgbaakha ttara Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","K'ogbe kw'Aarọn ọmaana anọng p'Israẹl an-are Mosẹs, itzitzikha sẹ in-innọnna, mẹ wọ, ojora bẹ bi bẹ arenga abaang-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Yina, Mosẹs oyeri bẹ, mẹ wọ, Aarọn ọmaana adeho p'obhon akpa nnam atzor-ẹ, ọgbaak bẹ atzim. ");
INSERT INTO mfo_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ayongi mẹ, anọng p'Israẹl biphyir arenga abaang-ẹ, Mosẹs ọgbaak bẹ asana biphyir p'Ọvaar Ibinọkpaabyi ọkk'ẹ ọnanga k'egbegbeho cha Sinai. ");
INSERT INTO mfo_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mada Mosẹs okyer atzim ọgbagbaak ttara bẹ, ọtzọkha ẹbarakpa obubha itzitzikha sẹ. ");
INSERT INTO mfo_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Yina, ogbe kpenamkpen kwa Mosẹs oyini Ọvaar Ibinọkpaabyi k'itzitzikha bi, ọgbaak atzim ttar-ẹ, ogwonga ẹbarakpa nda k'itzitzikha. Mada oyini k'iyaan, okwu ọgbaak anọng p'Israẹl idik s'Ọvaar Ibinọkpaabyi ọkk'ẹ ọgbaakha, ");
INSERT INTO mfo_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","anọng p'Israẹl an-are bi, itzitzikha sẹ innọnna. Mẹ wọ, Mosẹs obiro ọtzọkha ẹbarakpa nda obubha k'itzitzikha sẹ, yina on-odimi kẹ bi, ọgbaak atzim ttara Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Wa Mosẹs ogwon ọkwa k'obhon kw'Israẹl biphyir, oben bẹ bi, “Ma wọ ode idik s'Ọvaar Ibinọkpaabyi, okk'bọng obena bi bọng asi: ");
INSERT INTO mfo_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Bọng ási ọtzọhm k'iwu izadani, yina, ewu ch'ettong izenamfa éde ewu ch'awurada, ch'éde Ẹwọhngkwokhawu ẹnang Ọvaar Ibinọkpaabyi. Ọnọng kpenamkpen kw'osi ọtzọhm m'ewu nda, bẹ akhaambi afhẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Bọng ekpon k'orukhabe fabọng kpenamkpen m'Ẹwọhngkwokhawu nda kàbaanga.” ");
INSERT INTO mfo_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mosẹs ọgbaak anọng p'obhon kw'Israẹl biphyir bi, “Ma wọ ode odik kw'Ọvaar Ibinọkpaabyi okk'obena bi bọng asi: ");
INSERT INTO mfo_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Bọng nọbha ẹnanga k'ekpo pya bọng akhaam, anang Ọvaar Ibinọkpaabyi ẹnanga. Ọnọng kpenamkpen kw'ọdaakh-ẹ, tte otzima ẹnanga cha gol, ọmaana asilva, ttara cha brons ochena Ọvaar Ibinọkpaabyi, ");
INSERT INTO mfo_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ọmaana ndik sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ọmaana ndik nkkakka sa bẹ ayoyok, ọmaana avu-phyubha, ");
INSERT INTO mfo_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ọmaana ndenkpa s'erukhimaan-dim sa bẹ aphyok ademkora, ọmaana ndenkpa s'avu, ttara mgbaakha s'akasiya, ");
INSERT INTO mfo_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ọmaana ana p'oliv p'ekpon eyenichẹ, ọmaana ekpo py'ẹdaami eruk pya bẹ am-atzima asi ana pa bẹ abyengi ọnọng k'eho, ttara insẹns kw'ọdaami eruk; ");
INSERT INTO mfo_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ọmaana atza p'oniks, ttara atza adọdọk pa bọng agbana k'ẹphọd, ttara k'ẹbarakpa ch'ittemmọma. ");
INSERT INTO mfo_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Tte amengkkakkaa biphyir p'awobh k'ottem kwabọng ayin ka, akwu asi ọttọhk kpenamkpen f'Ọvaar Ibinọkpaabyi okk'obena bi, mosi: ");
INSERT INTO mfo_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","irukhabe nna ttara ikhira sẹ, ọmaana ittakhọnga sẹ, ọmaana agbak pẹ, ọmaana nchi s'amma, ọmaana nneremachi, ọmaana mkpọmmachi, ttara nnana; ");
INSERT INTO mfo_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Ẹkkọhbhi nda ch'Echekhi ttara nneremachi sẹ, ọmaana ẹkkọhbhikpa ch'ephyokhi ttara ekpekhe ch'ẹkpa chẹ ẹmmaana k'ẹtzaanga; ");
INSERT INTO mfo_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ọmaana okpokkoro ttara nneremachi sẹ, ttara ekpo biphyir py'ẹnan mẹ, ọmaana brẹd kw'awurada, ");
INSERT INTO mfo_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ọmaana etwikkaang-chi ch'ekpon oyeyeni ttara ekpo pyẹ, atwikkaang ttara ana p'ekpon eyenichẹ, ");
INSERT INTO mfo_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ijafọhnibe s'insẹns ttara nneremachi sẹ, ọmaana ana pa bẹ am-abyengi ọnọng k'eho, ọmaana insẹns p'adaami eruk, ttara ekpekhe ch'ẹhọhmma ch'ọmma kw'irukhabe; ");
INSERT INTO mfo_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ọmaana ijafọhnibe s'ẹnanga ẹkwọmichẹ, ttara otzekpa kwẹ kwa brons, ọmaana nneremachi sẹ ttara ekpo pyẹ biphyir, ọmaana ọkwakkama kwa brons ttara ẹnana chẹ, ");
INSERT INTO mfo_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ọmaana mkpekhe s'ẹttọhmmattem ttara mkpọmmachi ọmaana nnana sẹ, ọmaana ekpekhe ch'ọmma kw'ẹttọhmmattem, ");
INSERT INTO mfo_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ọmaana abhing p'irukhabe ọmaana p'ẹttọhmmattem, ttara ndik sabẹ, ");
INSERT INTO mfo_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ọmaana nnya nyokhasẹ s'ọtzọhm f'ọhọhm kw'awurada sa nde; nnya s'awurada s'Aarọn kw'ode ọfọhnẹja, ttara nnya sa va pẹ p'ijinọng am-afọra, k'ogbe kwa bẹ asi ọtzọhm mach'afọhnẹja.” ");
INSERT INTO mfo_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Mẹ wọ, anọng p'obhon kw'Israẹl biphyir abina aji Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ọnọng kpenamkpen kw'ọdaakh-ẹ, obiro ogbikh-ẹ k'ettem, otzima ẹnanga ochena Ọvaar Ibinọkpaabyi, k'ọtzọhm f'irukhabe, ọmaana itzọhmbọhk sẹ biphyir, ttara nnya s'awurada. ");
INSERT INTO mfo_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Anọng biphyir ajinọng ọmaana panọng, p'ọdaakhi bẹ ọdaak, atzima ẹfanginẹkpo pya gol k'adem-k'adem akwu: bẹ atzim ekpo pya hung, ọmaana ekpo py'itzọhng, ọmaana mbaanga sa nnọhna, ọmaana ẹfanginẹkpo, akwu. Bẹ biphyir atzima agol pabẹ akwu, mach'ẹnanga ch'ẹbar-odik achena Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ọnọng kpenamkpen kw'okhaam ndik sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ode ndik sa bẹ ayokh-oyok o, obiro ode avu-phyubha o, ode ndenkpa s'erukhimaan-dim cha bẹ aphyok asi-khora, obiro ode ndenkpa s'avu o, bẹ atzima akwu. ");
INSERT INTO mfo_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ayok p'asi ẹnanga ch'asilva, obiro ode brons o, bẹ atzima achena Ọvaar Ibinọkpaabyi. Ọnọng kpenamkpen kw'ọkhaam mgbaakha s'akasiya, sa bẹ afha atzima asi ọtzọhm kpenamkpen, obiro otzima okwu. ");
INSERT INTO mfo_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Omengkka-kwanọng kpenamkpen otzima mbọhk sẹ oyok ọttọhk, otzima ọttọhk f'okk'oyokha f'ode blu, ọmaana f'ode ihiho, ọmaana f'ode izizi, ttara ndik nkkakka sa bẹ ayoyok, okwu. ");
INSERT INTO mfo_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Panọng biphyir p'ọdaakhi bẹ ọdaak, abira atzima emengkka chabẹ ch'ekpo oyoyok, ayok avu-phyubha. ");
INSERT INTO mfo_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Adeho atzima atza p'oniks, ọmaana atza adem adọdọk pa bẹ agbana k'ẹphọd, ttara k'ẹbarakpa ch'ittemmọma. ");
INSERT INTO mfo_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Bẹ abira atzima ekpo py'em-esi ọttọhk ọdaam eruk, ọmaana ana p'oliv p'ekpon eyenichẹ, ọmaana ana pa bẹ am-abyengi ọnọng k'eho, ttara insẹns kw'ọdaami eruk, akwu. ");
INSERT INTO mfo_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Anọng p'Israẹl biphyir, ajinọng ọmaana panọng p'ọdaakhi bẹ ọdaak, atzima nnanga s'ifon bẹ ka nttem achena Ọvaar Ibinọkpaabyi, s'okk'orenga ka Mosẹs oben bẹ bi, bẹ asi. ");
INSERT INTO mfo_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mẹ wọ, Mosẹs oben anọng p'Israẹl bi, “Bọng kker e, Ọvaar Ibinọkpaabyi okk'Bẹzalẹl nnwa kw'ijinọng kw'Uri, kw'ode nnwa kwa Hur, kw'ofon k'ẹfona cha Juda, otzekha e. ");
INSERT INTO mfo_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Kẹ Ibinọkpaabyi ọkk'ẹ Egwugwuma chẹ ọnanga, ọmaana emengkka, ọmaana otzitzin, ttara eronga, ch'emengkka kpenamkpen, ");
INSERT INTO mfo_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ifha osi omengkka-tzọhm fa gol, ọmaana fa silva, ttara fa brons, ");
INSERT INTO mfo_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ọmaana bi, ọkpaara atza otzobha, ọmaana nchi ọgwagwa, obira osi omengkka-tzọhm kpenamkpen f'omengkkakkaa. ");
INSERT INTO mfo_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Kẹ okk'Bẹzalẹl ọmaana Oholiyab kw'ode nnwa kw'ijinọng kw'Ahisamak, kw'ofon k'efona cha Dan, etzina ọnanga bi bẹ akpebhi anọng adọdọk mmengkka sabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Kẹ okk'bẹ emengkka ch'omengkka-tzọhm kpenamkpen ọnanga, mach'amengkkakkaa, ọmaana odokh-ọbara, ọmaana adokh-ọbara f'ode blu, ọmaana f'ode-ihiho, ọmaana f'ode-izizi ọmaana ndik nkkakka sa bẹ ayoyok, ttara ayokh-ekpo biphyir, ade abitta p'emengkka, ttara abitta p'ekpo ododokha. ");
INSERT INTO mfo_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Mẹ wọ, iwa Ọvaar Ibinọkpaabyi okk'Bẹzalẹl ọmaana Oholiyab, ttara omengkkakkaa kpenamkpen, emengkka ọmaana otzitzin kw'eronga ch'ọtzọhm kpenamkpen f'ibe s'awurada osisi ọnanga. Anọng mba bọ asi ọtzọhm mva atzor mach'Ọvaar Ibinọkpaabyi okk'bẹ ọtzọhna.” ");
INSERT INTO mfo_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mẹ wọ, Mosẹs oyeri Bẹzalẹl ọmaana Oholiyab, ttara amengkkakkaa biphyir p'Ọvaar Ibinọkpaabyi okk'etzina ọnanga, ọmaana ayok p'ọdaakh-ọdaak bi, bẹ akwu asi ọtzọhm mva. ");
INSERT INTO mfo_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Wa bẹ atzọkha nnanga biphyir s'anọng p'Israẹl akk'atzima akwu ka mbọhk sa Mosẹs, ifha bẹ atzima asi ọtzọhm f'ibe s'awurada. Wa k'ekpebhawu kpenamkpen, anọng mba achina ororo atzima nnanga s'ifon bẹ ka nttem, akwu. ");
INSERT INTO mfo_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Mẹ wọ, amengkkakkaa mba biphyir, p'am-asi ọtzọhm mva f'ọhọhm kw'awurada abina aji ọtzọhm fabẹ, ");
INSERT INTO mfo_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","atza aben Mosẹs bi, “Anọng mba am-atzim ekpo py'ẹhaabhi kpọng, ẹyọhnga ọtzọhm f'Ọvaar Ibinọkpaabyi ọtzọhni man bi, mosi akwu e.” ");
INSERT INTO mfo_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Mẹ wọ, Mosẹs ọnang ẹfa, bẹ atzọhm ẹmọng k'ibhingabe bi waam aben bi, “Tte ojinọng, obiro ode kwanọng oningi ẹnanga kpenamkpen ch'ọhọhm kw'awurada osisi, dọk otzim okwu.” Mẹ wọ, wa bẹ akwọbha anọng mba ẹnanga nda osisi, ");
INSERT INTO mfo_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","okhuri bi, ekpo pya bẹ akk'atzama akhaama ẹkk'ẹhaabha ẹyọhnga ọtzọhm biphyir fa bẹ asi. ");
INSERT INTO mfo_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Amengkkakkaa biphyir k'ottem kw'atzọhmnọng mba atzima mkpekhe jobh sa bẹ atzim ndik nkkakka sa bẹ ayoyok asi. Iwa ndik sa bẹ atzim nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi asi irukhabe nna, bẹ attara achẹrubim mẹ, p'omengkkakkaa osi. ");
INSERT INTO mfo_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Mkpekhe nna biphyir nde mbenga-mbọhk, adum ade ndọkhi arọbh afa obhiri mfa, ẹkpa ede ndọkhi nzadani. ");
INSERT INTO mfo_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Bẹ atzọkha mkpekhe nzen atzọhnga ibe rani, bẹ abira atzọkha mkpekhe nnonggo nzen atzọhnga ibe rani. ");
INSERT INTO mfo_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Mẹ wọ, bẹ aduk ager p'ade blu m'ẹbaramma ch'ekpekhe nda dani cha bẹ akk'atzọhnga, bẹ asi mando k'ekpekhe ndonggo cha bẹ akk'abira atzọhnga. ");
INSERT INTO mfo_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Bẹ aduk ager arọbh afa obhiri jobh agbana k'ekpekhe nda dani cha bẹ akk'atzọhnga, bẹ abira agbana ager arọbh afa obhiri jobh k'ekpekhe ndonggo cha bẹ akk'atzọhnga. ");
INSERT INTO mfo_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Mẹ wọ, bẹ atzima gol asi agbak arọbh afa obhiri jobh, bẹ atzima abọkha mkpekhe nna mfa sa bẹ akk'atzọhnga k'ibe rani, ifha irukhabe nna in-ide rani. ");
INSERT INTO mfo_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Bẹ atzima avu-phyubha asi mkpekhe jobh obhiri wani, atzima abubha ebir-ebir kw'ikhira s'irukhabe. ");
INSERT INTO mfo_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Mkpekhe nna jobh obhiri wani biphyir nde ebenga-mbọhk, adum ade ndọkhi arọbh afa obhiri nzen, ẹkpa ede ndọkhi nzadani. ");
INSERT INTO mfo_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Bẹ atzọkha mkpekhe nzen atzọhnga k'ibe rani, bẹ abira atzọkha nnonggo nzadani atzọhnga k'ibe rani. ");
INSERT INTO mfo_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Mẹ wọ, bẹ aduk ager arọbh afa obhiri jobh agbana k'ekpekhe nda dani cha bẹ akk'atzọhnga, bẹ abira agbana ager arọbh afa obhiri jobh k'ekpekhe ndonggo cha bẹ akk'atzọhnga. ");
INSERT INTO mfo_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Mẹ wọ, bẹ atzima brons asi agbak arọbh afa obhiri jobh, bẹ atzima abọkha ikhira nna in-ide rani. ");
INSERT INTO mfo_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Mẹ wọ, bẹ abira atzima erukhimaan-kpakpa cha bẹ aphyok asi-khora abubha ikhira nna, yina bẹ abira atzima ndenkpa s'avu abubha k'ebir-ebir. ");
INSERT INTO mfo_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Bẹ atzima echi ch'akasiya asi nneremachi sa mbe-obe iduduma k'irukhabe nna. ");
INSERT INTO mfo_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Adum p'ereremachi kpenamkpen ade ndọkhi chi, ẹkpa ede ẹtzọkhi ọmaana igbokha, ");
INSERT INTO mfo_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","bẹ abira asi nho mfa sa nde mbenga-mbọhk, ibiri ikkeri ayok itzitzikha. M'eden nda dani dọ ch'iwa bẹ abira asi nneremachi biphyir s'irukhabe nna. ");
INSERT INTO mfo_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Bẹ asi nchi s'amma ẹrọbh p'akkeri k'ẹrakha-ẹrakha kw'irukhabe s'Ibinọkpaabyi, ");
INSERT INTO mfo_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","wa bẹ abira atzima silva asi nnana arọbh afa, akhe k'irekh-irek kwabẹ, ereremachi kpenamkpen ẹkhaam nnana mfa, eho kpenamkpen k'ẹnana chẹ. ");
INSERT INTO mfo_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","K'okhubha kw'ebir-ebira kw'irukhabe nna, bẹ asi nneremachi ẹrọbh, ");
INSERT INTO mfo_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","nnana arin arọbh afa, nnana mfa k'irekh-irek kw'ereremachi kpenamkpen. ");
INSERT INTO mfo_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ka nnam-annam kw'irukhabe, k'okhubha kw'ewuchen em-edimi, bẹ asi nchi nzadani, ");
INSERT INTO mfo_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ọmaana nneremachi mfa ka nyọhnga sa nnam-annam kw'irukhabe nna. ");
INSERT INTO mfo_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ma nyọhnga nna, bẹ agbak nneremachi sa ngeri ayok ọgbakha, ttẹwọr k'irekh-irek maa apyiri k'ebir-ebir; bẹ akhe sẹ k'oriring wani. ");
INSERT INTO mfo_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Mẹ wọ, wa ode nneremachi nzenanttaan, ọmaana nnana sa silva chi obhiri wani, nnana mfa k'ereremachi dani. ");
INSERT INTO mfo_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Bẹ atzima echi ch'akasiya asi nneremachi, atzima nzen ka nchi nna s'amma k'okhubbha wani, kw'irukhabe nna, ");
INSERT INTO mfo_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","nzen k'okhubha nwonggo, nzen ka mkpọmmachi s'amma k'okhubha kw'ewuchen em-edimi k'irukhabe nna. ");
INSERT INTO mfo_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Bẹ an-asi ereremachi ch'ottem ẹttẹwọr k'eho dani, maa ẹbọkha k'eho ndonggo k'ottem kwa mkpọmmachi. ");
INSERT INTO mfo_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Bẹ atzima gol abhọri mkpọmmachi nna, abira atzima gol asi ariring, p'abọk nneremachi nna. ");
INSERT INTO mfo_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Bẹ atzima ndik sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ttara ndik ọkkakka sa bẹ ayokh-oyok m'ekpekhe nda, attara ka chẹrubim p'omengkkakkaa osi. ");
INSERT INTO mfo_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Bẹ atzima echi ch'akasiya asi mkpọmmachi s'ekpekhe nda, abhọri ttara gol. Bẹ atzima gol asi agbak pa mkpọmmachi nna, abhọri ttara gol, abira atzima silva asi nnana sabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Bẹ atzima ndik sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ttara ndik nkkakka sa bẹ ayokh-oyok, kw'ode ọtzọhmbọhk f'odokh-ọbara, osi ekpekhe ch'ẹhọhmma ch'irukhabe nna. ");
INSERT INTO mfo_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Wa bẹ abira asi mkpọmmachi nzen ttara agbak pabẹ. Bẹ atzima gol abhọri aho pa mkpọmmachi nna, ọmaana abarakpa pabẹ, bẹ abira atzima brons asi nnana azen sabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Wa Bẹzalẹl otzim agbaakhakpa p'akasiya osi Ẹkkọhbhi ch'Echekhi. Adum pẹ ade ndọkhi nttaan ọmaana akpaama ọhawani, ẹkpa chẹ ede ndọkhi mfa ọmaana akpaama attaan, ebe chẹ ede ndọkhi mfa ọmaana akpaama attaan. ");
INSERT INTO mfo_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Otzima gol ọkkakka ọbhọri k'ẹtzaanga ttara k'iyaan, obiro ọbanga gol ọbaak chẹ ọkhọri. ");
INSERT INTO mfo_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Otzima gol ọrabha ariring anna, tzọkha ọdaabh bẹ okhe ka ndọkhi nna s'ẹkkọhbhi nda. Ariring afa k'okhubha wani, afa k'okhubha nwonggo. ");
INSERT INTO mfo_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Otzima echi ch'akasiya osi nneremmachi, obiro ọbhọri sẹ ttara gol. ");
INSERT INTO mfo_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Okhe nneremmachi nna k'ariring p'awobh k'akhaan-akhaan p'ẹkkọhbhi nda, ifha bẹ am-abọkha mẹ atzini chẹ. ");
INSERT INTO mfo_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Otzima gol ọkkakka osi ẹkkọhbhikpa ch'ephyokhi, adum pẹ ade ndọkhi nttaan ọmaana akpaama ọhawani, ẹkpa chẹ ede ndọkhi mfa ọmaana akpaama attaan. ");
INSERT INTO mfo_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Mẹ wọ, otzima gol oduk achẹrubim ohok k'ikpiho s'ẹkkọhbhi nda. ");
INSERT INTO mfo_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Wa osi cherub wani obera k'eho dani, obiro osi ọdọdọk obera k'eho ndonggo. Wa osi achẹrubim mba k'ikpiho bẹ ade odem wani ttara ẹkkọhbhikpa ch'ephyokhi. ");
INSERT INTO mfo_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Wa achẹrubim mba akhaam mbabaang sa mmẹm k'ẹrọng ibubha ẹkkọhbhikpa ch'ephyokhi nda. Achẹrubim mba awobha akkeri ayok itzitzikha, arọn ẹkkọhbhikpa nda. ");
INSERT INTO mfo_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Bẹ atzima mgbaakha s'akasiya asi okpokkoro nwa. Adum pẹ ade ndọkhi nttaan, ẹkpa chẹ ede ndọkhi ọmaana akpaama azadani, ebe chẹ ede ndọkhi mfa ọmaana akpaama attaan. ");
INSERT INTO mfo_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Mẹ wọ, bẹ atzima gol ọkkakka abhọri okpokkoro nwa, abira abanga gol abhọri ammakpabem pẹ akhọri. ");
INSERT INTO mfo_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","K'ọkhaan-ọkhaan bẹ akhe ammakpabem p'abeng mach'ẹbọhkpattem, bẹ abanga gol atzima akhọr-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Bẹ atzima gol arabha ariring anna p'okpokkoro nwa, atzọkha bẹ adabh amaana ma nnyọhnga nna, mẹ da mmo sẹ nna nwobh. ");
INSERT INTO mfo_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ariring mba awobha abaanga ammakpabem ifha bẹ abọkha nneremmachi nna, sa bẹ atzima atzini okpokkoro nnwa. ");
INSERT INTO mfo_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Wa bẹ atzim mgbaakha s'akasiya asi nneremmachi, sa bẹ am-atzima atzini okpokkoro nwa, bẹ abira atzima gol abhọri sẹ. ");
INSERT INTO mfo_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Wa bẹ abira atzima gol ọkkakka asi ekpo py'okpokkoro nwa, agbang-gbang ọmaana agbaangari, ọmaana nnengakpa, ttara akọbh, pa bẹ am-atzima asi nnanga mbyengisẹ. ");
INSERT INTO mfo_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Bẹ atzima gol ọkkakka aduk ettwikkaang-chi nda, ọmaana ẹnana chẹ, ọmaana owom kwẹ, ọmaana akọbh p'adodo, ọmaana agbok, ttara adodo. Wa pyẹ biphyir ede odem nwuma wani. ");
INSERT INTO mfo_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Etwikkaang-chi nda ẹkhaam abọhnga azadani k'akhaan-akhaan pẹ afa, attaan awobh k'okhubha wani, attaan abira awobha k'okhubha nwonggo. ");
INSERT INTO mfo_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Akọbh p'ade mach'agbok ọmaana adodo p'almọnd awobh k'ẹbọhnga dani, attaan k'ẹbọhnga ch'ejem mẹ. Wa ode odem nwuma wani k'abọhnga mba azadani biphyir p'ettwikkaang-chi nda. ");
INSERT INTO mfo_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Etwikkaang-chi nda wa ẹkhaam akọbh anna p'ade mach'agbok ọmaana adodo p'almọnd. ");
INSERT INTO mfo_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ogbok wani owobh k'irekh-irek kw'abọhnga afa p'afon k'etwikkaang-chi nda. Ogbok nwonggo owobha k'irekh-irek kw'abọhnga mbonggo afa, ogbok kw'ottong attaan owobha k'abọhnga p'attong attaan, p'asi abọhnga azadani biphyir-phyir. ");
INSERT INTO mfo_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Wa bẹ atzima gol aduk agbọk, ọmaana abọhnga, bẹ ade odem wani ttara ettwikkaang-chi nda cha bẹ adukhi ttara gol ọkkakka aduk. ");
INSERT INTO mfo_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Bẹ atzima gol ọkkakka asi attwikkaang azenamfa, ọmaana afhẹngbẹ p'attwikkaang-dik ọkpa-kpaara, ttara nnengakpa. ");
INSERT INTO mfo_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Bẹ atzima talẹn wani kwa gol ọkkakka asi ettwikkaang-chi nda, ọmaana ekpo kpenamkpen pyẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Wa bẹ atzima mgbaakha s'akasiya asi ijafọhnibe s'insẹns, ebe ttara ẹkpa chẹ ade mbenga-mbọhk; adum pẹ ade ẹtzọkhi dani ọmaana igbokha, ẹkpa chẹ ede ẹtzọkhi dani ọmaana igbokha, ebe chẹ ede ndọkhi nttaan. Bẹ atzima echi nda dani asi abhik pẹ. ");
INSERT INTO mfo_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Atzima gol ọkkakka abhọri ehoho ọmaana k'okhubha kpenamkpen, abira atzima gol abanga ammakpabem adokha akhọri sẹ. ");
INSERT INTO mfo_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Wa bẹ atzima gol asi ariring afa m'ammakpabem, afa k'okhubha wani, afa k'okhubha nwonggo, ifha bẹ abọkha nneremmachi sa bẹ am-atzima atzini sẹ. ");
INSERT INTO mfo_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Bẹ atzima echi ch'akasiya asi nneremmachi, atzima gol abhọri sẹ. ");
INSERT INTO mfo_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Bẹ abira asi ana p'awurada pa bẹ am-abyengi ọnọng k'eho, ọmaana insẹns ọkkakka kw'ọdaami eruk, kw'ode ọtzọhmbọhk f'osi-ana. ");
INSERT INTO mfo_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Wa bẹ atzima mgbaakha s'akasiya asi ijafọhnibe s'ẹnanga ẹkwọmichẹ. Adum pẹ ade ndọkhi nzenamfa ọmaana akpaama azadani, ẹkpa ede ndọkhi nzenamfa ọmaana akpaama azadani, ebe ede ndọkhi nna ọmaana akpaama azadani. Wa ijafọhnibe nna ikhaam akhubha anna. ");
INSERT INTO mfo_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Wa bẹ asi abhik ka nnyọhnga nna. Bẹ atzima mgbaakha nna rani asi abhik mba anna ọmaana ijafọhnibe nna. Bẹ atzima brons abhọri ijafọhnibe nna. ");
INSERT INTO mfo_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Bẹ abira atzima brons asi ekpo ijafọhnibe nna biphyir mach'ọrọhkha, ọmaana asọvẹl, ọmaana agbang-gbang, ọmaana adaakpa p'akhaam aha attaan, ttara nnengakpa. ");
INSERT INTO mfo_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Bẹ ayok otzekpa kw'ijafọhnibe nna, atzima brons ayok ibuni, ahok k'irekh-irek kw'otzekpa nwa, m'ibhaang-ifa s'ijafọhnibe nna. ");
INSERT INTO mfo_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Bẹ atzima brons aduk ariring anna, p'abọkha nneremmachi ka nnyọhnga nna nna, s'otzekpa nwa kwa brons. ");
INSERT INTO mfo_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Bẹ atzima mgbaakha s'akasiya asi nneremmachi, atzima brons abhọri sẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Wa bẹ anọhma nneremmachi nna m'ariring mba, ifha sẹ nwobha k'akhaan-akhaan p'ijafọhnibe nna, ifha bẹ am-abọkha mẹ atzini. Bẹ asi ijafọhnibe nna itto eje k'ottem mach'ẹkkọhbhi. ");
INSERT INTO mfo_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Bẹ atzima abazẹkhubh pa panọng p'asi ọtzọhm k'ẹhọhmma ch'irukhabe s'Ibinọkpaabyi, asi ọkwakkama kwa brons, ọmaana ẹnana cha brons ch'ọkwakkama nwa. ");
INSERT INTO mfo_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Wa bẹ abira asi ẹttọmmattem. Adum pẹ k'ẹrakha-ẹrakha ade ndọkhi arọbh azenamfa obhiri jobh, bẹ abira atzima ndik nkkakka sa bẹ ayokh-oyok, ayok mkpekhe sẹ, ");
INSERT INTO mfo_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ọmaana mkpọmmachi ẹrọbh, ọmaana arin pa brons ẹrọbh, ọmaana agbak pa silva, ttara mbarakpa ka mkpọmmachi. ");
INSERT INTO mfo_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","K'ebir-ebira, adum ade ndọkhi arọbh azenamfa obhiri jobh, obiro ọkhaama mkpọmmachi ẹrọbh, ọmaana arin pa brons ẹrọbh, ọmaana agbak pa silva, ttara mbarakpa ka mkpọmmachi. ");
INSERT INTO mfo_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ẹkpa ch'okhubha kw'ewuchen em-edimi, ede ndọkhi arọbh attaan obhiri chi, ẹkhaama mkpekhe ọmaana mkpọmmachi jobh, ọmaana arin pa brons jobh, ọmaana agbak pa silva, ttara mbarakpa ka mkpọmmachi. ");
INSERT INTO mfo_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","K'okhubha kw'ewuchen em-eyin, ẹkpa chẹ ede ndọkhi arọbh attaan obhiri chi. ");
INSERT INTO mfo_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Wa mkpekhe sa nde ndọkhi ẹrọbh obhiri mfa ọmaana igbokha k'adum, nwobh k'okhubha wani kw'ẹhọhmma, ọmaana mkpọmmachi nttaan, ttara arin attaan, ");
INSERT INTO mfo_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","mkpekhe sa nde ndọkhi ẹrọbh obhiri mfa ọmaana igbokha k'adum, nwobha k'okhubha nwonggo kw'ẹhọhmma ch'ẹttọmmattem, ọmaana mkpọmmachi nttaan, ttara arin attaan. ");
INSERT INTO mfo_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Wa bẹ atzim ndik nkkakka sa bẹ ayokh-oyok asi mkpekhe nna biphyir akhọri ẹttọmmattem. ");
INSERT INTO mfo_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Bẹ atzima brons asi arin pa mkpọmmachi nna. Bẹ abira atzima silva asi agbak, ọmaana mbarakpa sa mkpọmmachi. Bẹ atzima silva abhọri aho pabẹ, mẹ wọ, mkpọmmachi nna biphyir s'ẹttọhmmattem ngaama mbarakpa sa silva. ");
INSERT INTO mfo_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Bẹ atzima ndik sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ttara ndik nkkakka sa bẹ ayokh-oyok, asi ekpekhe ch'ẹhọhmma ch'ẹttọmmattem, f'ode ọtzọhmbọhk f'odokh-ọbara. Wa adum p'ekpekhe nda ade ndọkhi ẹrọbh obhiri jobh, ebe chẹ ede ndọkhi nzenamfa ọmaana igbokha, macha mkpekhe s'ẹttọhmmattem, ");
INSERT INTO mfo_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ọmaana mkpọmmachi nna, ttara arin anna pa brons. Bẹ atzima silva asi agbak ọmaana mbarakpa pabẹ, bẹ abira abhọri aho pabẹ ttara silva. ");
INSERT INTO mfo_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Wa bẹ atzima brons asi abhing p'ikhira nna s'irukhabe, ọmaana ẹttọmmattem chẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ma wọ ode obhik kw'ekpo pya bẹ atzim asi irukhabe, kw'ode irukhabe s'Ẹkkọhbhi ch'Asana p'abaLẹvi p'iwa awobh k'irekh-irek kw'ẹfa ch'Itamar, akkẹri atzor k'odem kwa Mosẹs obeni. Itamar wa ode nnwa kw'ijinọng kw'Aarọn, kw'ode ọfọhnẹja. ");
INSERT INTO mfo_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bẹzalẹl kw'ode nnwa kw'ijinọng kw'Uri, Uri kw'ode nnwa kw'ijinọng kwa Hur, kw'ofon k'ẹkhọma cha Juda, osi odik kpenamkpen mach'Ọvaar Ibinọkpaabyi ọtzọhni Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ọnọng ọdọdọk kw'iwa ọttar mẹ, wa ode Oholiyab kw'ode nnwa kw'ijinọng kw'Ahisamak kw'ofon k'ẹkhọma cha Dan. Oholiyab nwa, wa ode omengkkakkaa, ọmaana odokh-ekpo, ttara odokh-ọbara fa blu, ọmaana f'okhor-ihiho, ọmaana f'okhor-izizi, ttara ndik iyokhasẹ nkkakka. ");
INSERT INTO mfo_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Biphyir-phyir gol kw'ofon k'ẹnanga ch'ẹbar-odik kw'iwa bẹ atzim asi ọtzọhm biphyir f'irukhabe s'awurada ode, atalent ẹrọbh obhiri ohawani kwa jobh, ọmaana ashẹkẹl ẹnọhna obhiri arọbh chi obhiri wani obhiri jobh, atzor ka shẹkẹl kw'irukhabe s'awurada. ");
INSERT INTO mfo_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Asilva pa bẹ atzọk k'abhonnọng, p'iwa bẹ abhikhi k'ogbe kw'ẹnọngmikha, ade atalent arọbh azen, ọmaana ashẹkẹl nnọhna nna obhiri arọbh azenanttaan obhiri chi, atzor ka shẹkẹl kw'ọhọhm kw'awurada, ");
INSERT INTO mfo_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","bẹka wani, kw'ode ishẹkẹl-ibhakha k'ọnọng-ọnọng, atzor ka shẹkẹl kw'irukhabe s'awurada. Wa ọnọng kpenamkpen kw'ọttar k'ọnọngmik kwa bẹ akk'abhikha biphyir, ttẹwọr ka cho ẹrọbh ọmaana-ọmaana ode, ajinọng nnọhna-nabhik. ");
INSERT INTO mfo_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Wa bẹ atzim atalent mba arọbh azen pa silva aduk arin p'irukhabe s'awurada ọmaana ekpekhe. Bẹ atzima atalent arọbh azen asi arin arọbh azen, talẹn wani k'orin wani. ");
INSERT INTO mfo_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Bẹ atzima ashẹkel nnọhna nna obhiri arọbh azenanttaan obhiri chi, asi agbak pa mkpọmmachi, abira atzima abhọri aho pa mkpọmmachi nna, ttara mbarakpa sabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Wa brons kw'ofon k'ẹnanga ch'ẹbar-odik ode atalent arọbh attaan obhiri jobh, ọmaana ashẹkẹl nnọhna nzadani. ");
INSERT INTO mfo_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Wa bẹ atzima brons nwa asi arin p'ẹhọhmma ch'irukhabe nna, ọmaana ijafọhnibe, ttara otzekpa kwẹ kwa brons, ttara ekpo pyẹ biphyir, ");
INSERT INTO mfo_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ọmaana arin p'ẹttọhmmattem ttara p'ọmma kwẹ, ọmaana abhing p'ikhira s'irukhabe, ttara p'ettọhmmattem. ");
INSERT INTO mfo_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Wa bẹ atzima ndik sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ayok nnya s'ọtzọhm f'ọfọhnẹja k'irukhabe s'awurada. Bẹ abira ayok nnya s'awurada anang Aarọn, mach'Ọvaar Ibinọkpaabyi okk'Mosẹs obena. ");
INSERT INTO mfo_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Wa bẹ atzima ndik sa gol, ọmaana sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ttara ndik nkkakka sa bẹ ayokh-oyok, asi ẹphọd. ");
INSERT INTO mfo_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Bẹ aduk gol-kpa p'ayor-oyori, abira akpaara bẹ k'anaanga, atzima asi ndik sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ttara ndik nkkakka sa bẹ ayokh-oyok, kw'ode ọtzọhmbọhk f'omengkkakkaa. ");
INSERT INTO mfo_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Wa bẹ ayok mkpa mfa ma mbabaang sa nwobh k'akhaan-akhaan afa p'ẹphọd, ifha sẹ mbọkha ẹphọd nda. ");
INSERT INTO mfo_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Odikpa kwa bẹ atzim ndik sa gol, sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ttara ndik nkkakka sa bẹ ayokh-oyok, wa ode ọtzọhm f'emengkka. Iwa obiro ode odem nwuma wani ttara ẹphọd, mach'Ọvaar Ibinọkpaabyi okk'Mosẹs obena. ");
INSERT INTO mfo_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Bẹ abẹ atza p'oniks k'ẹnana cha gol, bẹ akkẹr che pa va p'Israẹl p'ijinọng m'atza mba, mach'ẹkhọhkha. ");
INSERT INTO mfo_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Mẹ wọ, bẹ agbana bẹ ka mkpa nna sa mbabaang s'ẹphọd, mach'atza p'ojima anang anọng p'Israẹl, mach'Ọvaar Ibinọkpaabyi okk'Mosẹs obena. ");
INSERT INTO mfo_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Bẹ ayok ẹbarakpa ch'ittemmọma, kw'ode ọtzọhmbọhk f'omengkkakkaa. Bẹ atzima ndik sa gol, sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ttara ndik nkkakka sa bẹ ayokh-oyok, ayok sẹ odem nwuma wani macha bẹ ayokhi ẹphọd. ");
INSERT INTO mfo_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ẹkpa chẹ ttara adum pẹ, bẹ ade mbenga-mbọhk, adum ọmaana ẹkpa ade ẹbọhkpattem dani, akhọni igbe ifa. ");
INSERT INTO mfo_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Mẹ wọ, bẹ abẹ adik anna p'atza p'ajibh-ojibh mẹ. M'odik kw'ocheden, bẹ abẹ ọtza kwa ruby, ọmaana kwa topaz, ttara kwa bẹril. ");
INSERT INTO mfo_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","K'odik kw'ottong afa bẹ abẹ ọtza kwa tọkwọis, ọmaana kwa saphira, ttara ẹmẹral. ");
INSERT INTO mfo_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","K'odik kw'ottong attaan bẹ abẹ ọtza kwa jasint, ọmaana kw'agate, ttara amẹtist. ");
INSERT INTO mfo_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","K'odik kw'ottong anna bẹ abẹ ọtza kwa krisolita, ọmaana kw'oniks, ttara kwa jaspa, atzima gol akhọri abem pabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Wa atza mba ade jobh obhiri afa, kpenamkpen otzera che cha nnwa wani kw'Israẹl, kpenamkpen obe mach'ẹkhọhkha, ttara che ch'efonamma dani ch'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Bẹ atzima gol asi mgbakkọhbh sa bẹ ayokh-oyok, sa nde mach'edik. ");
INSERT INTO mfo_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Bẹ abira atzima gol asi abem afa, ọmaana ariring afa. Bẹ agbana ariring mba afa ka nnyọhnga mfa, s'ẹbarakpa nda ch'ittemmọma. ");
INSERT INTO mfo_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Bẹ agbana mgbakkọhbh nna mfa sa gol k'ariring mba afa ka nnyọhnga s'ẹbarakpa ch'ittemmọma, ");
INSERT INTO mfo_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","abira agbana nho nnonggo mfa sa mgbakkọhbh nna k'abem mba afa, bẹ abẹ sẹ ka mbarakpa sa mbabaang k'itzitzikha s'ẹphọd. ");
INSERT INTO mfo_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Bẹ atzima gol asi ariring afa, agbana bẹ ka nnyọhnga mfa s'ẹbarakpa nda ch'ittemmọma, k'ẹtzaanga kw'ammakpabem p'abaang ẹphọd. ");
INSERT INTO mfo_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Bẹ abira asi ariring afa adọdọk pa gol, bẹ agbana bẹ k'irekh-irek kwa mbarakpa sa mbabaang, k'itzitzikha s'ẹphọd, abaanga ebir-ebir kw'ẹtzọhnga cha odikpa kw'erin kw'ẹphọd. ");
INSERT INTO mfo_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Bẹ atzima edik ch'ede blu agbana ariring mba p'ẹbarakpa ch'ittemmọma ka ariring p'ẹphọd. Bẹ akpa chẹ k'odikpa kw'erin, ifha ẹbarakpa nda ch'ittemmọma eningi ẹchari ẹrọbha k'ẹphọd, mach'Ọvaar Ibinọkpaabyi okk'Mosẹs obena. ");
INSERT INTO mfo_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Wa bẹ atzima ibara s'ide blu biphyir, ayok ọnọhma-baba kw'ẹphọd, kw'ode ọtzọhmbọhk f'oyokh-ekpo osi, ");
INSERT INTO mfo_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ọkhaama ọmma m'ottem mach'ẹnọhma-khokhora, cha bẹ abhọri ẹmma ifha eningi ẹjaakhi. ");
INSERT INTO mfo_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Bẹ atzima ndik sa nde blu, ọmaana sa ngor-ihiho, ọmaana sa ngor-izizi, ttara ndik nkkakka sa bẹ ayokh-oyok, ayok apomegrenet akhọri ammakpabem p'ọnọhma-baba nwa. ");
INSERT INTO mfo_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Bẹ abira atzima gol ọkkakka asi akkaningkka, agbana akhọri ammakpabem k'ottem apomegrenet. ");
INSERT INTO mfo_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Akkaningkka ọmaana apomegrenet mba awobh ayok k'ottem, akhọri ammakpabem p'ọnọhma-baba nwa kw'ọtzọhm, mach'Ọvaar Ibinọkpaabyi okk'Mosẹs obena. ");
INSERT INTO mfo_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Bẹ atzima ndik nkkakka ayok ọnọhma-khum-mbọhk kw'odumi opyiri ka ndudungi anang Aarọn, ọmaana va pẹ p'ijinọng kw'ode, ọtzọhmbọhk f'oyokh-ekpo, ");
INSERT INTO mfo_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","abira atzima ndik nkkakka ayok ibara s'eho ọdadabh, ọmaana adikpa p'eho, ttara akpokhuma p'ẹtzaanga pa bẹ atzim ndik nkkakka ayok. ");
INSERT INTO mfo_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Bẹ atzima ndik sa bẹ ayokh-oyok, ọmaana sa nde blu, ọmaana sa ngor-ihiho, ttara sa ngor-izizi, kw'ode ọtzọhmbọhk f'odokh-ọbara osi, mach'Ọvaar Ibinọkpaabyi okk'Mosẹs obena. ");
INSERT INTO mfo_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Bẹ atzima gol ọkkakka asi ẹchachaangkpa, kw'ode ivaar-kpo s'awurada, akkẹr mẹ mach'ẹkhọhkha bi, AWURADA AWOBH ANANG ỌVAAR IBINỌKPAABYI. ");
INSERT INTO mfo_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Mẹ wọ, bẹ akpa edik ch'ede blu agbana k'ibara s'eho ọdadabh, mach'Ọvaar Ibinọkpaabyi okk'Mosẹs obena. ");
INSERT INTO mfo_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Mẹ wọ, wa ọtzọhm kpenamkpen f'irukhabe, kw'ode irukhabe s'Ibinọkpaabyi, ọkwu ọha. Anọng p'Israẹl asi odik kpenamkpen atzor k'odem kw'Ọvaar Ibinọkpaabyi okk'Mosẹs obena. ");
INSERT INTO mfo_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Mẹ wọ, wa bẹ atzini irukhabe nna achena Mosẹs: ikhira sẹ ttara ekpo pyẹ biphyir, ọmaana agbak pẹ, ọmaana nchi s'ẹhọhmma, ọmaana nneremachi, ọmaana mkpọmmachi, ttara arin, ");
INSERT INTO mfo_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ẹkpa cha ndenkpa s'erukhimaan-dim cha bẹ aphyok asi-khora, ọmaana ẹkpa cha ndenkpa s'avu, ttara ekpekhe ch'ẹkpa ẹkkọhbhi ẹmmaana k'ẹtzaanga, ");
INSERT INTO mfo_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ọmaana Ẹkkọhbhi ch'Echekhi ttara nneremachi sẹ, ọmaana ẹkkọhbhikpa ch'ephyokhi, ");
INSERT INTO mfo_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ọmaana okpokkoro ttara ekpo pyẹ biphyir, ọmaana brẹd kw'awurada, ");
INSERT INTO mfo_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ọmaana ettwikkaang-chi cha gol ọkkakka ttara attwikkaang pẹ ọmaana ekpo pyẹ biphyir, ttara ana p'ekpon oyeyeni, ");
INSERT INTO mfo_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ọmaana ijafọhnibe sa gol, ọmaana ana pa bẹ am-abyengi ọnọng k'eho, ọmaana insẹns kw'ọdaami eruk, ttara ekpekhe ch'ẹhọhmma ch'ikhira nna; ");
INSERT INTO mfo_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ọmaana ijafọhnibe sa brons ttara otzekpa kwa brons, ọmaana nneremachi sẹ ttara ekpo pyẹ biphyir, ọmaana ọkwakkama ttara ẹnana chẹ; ");
INSERT INTO mfo_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ọmaana mkpekhe s'ẹttọhmmattem ttara mkpọmmachi sẹ, ttara nnana, ọmaana ekpekhe ch'ẹhọhmma ch'ettọmmattem; ndik ọmaana abhing p'ikhira s'ẹttọhmmattem, ọmaana ekpo py'ẹnya py'irukhabe nna, s'ide irukhabe s'Ibinọkpaabyi; ");
INSERT INTO mfo_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ọmaana nnya nyokhasẹ s'ọtzọhm f'irukhabe s'awurada, ọmaana nnya s'awurada s'Aarọn kw'ode ọfọhnẹja, ọmaana nnya sa va pẹ p'ijinọng, k'ogbe kwa bẹ am-asi ọtzọhm f'afọhnẹja. ");
INSERT INTO mfo_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Wa anọng p'Israẹl akk'ọtzọhm kpenamkpen asa, mach'Ọvaar Ibinọkpaabyi okk'Mosẹs obena. ");
INSERT INTO mfo_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mosẹs e okkeri ọtzọhm, obiro ore bi bẹ akk'fẹ asa mach'Ọvaar Ibinọkpaabyi okk'bẹ obena. Mẹ wọ, Mosẹs on-odo anọng mba. ");
INSERT INTO mfo_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Mẹ wọ, wa Ọvaar Ibinọkpaabyi oben Mosẹs bi: ");
INSERT INTO mfo_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“K'echedenwu ch'ocheden-phe, tzima irukhabe, s'ide irukhabe s'ewobha ttara Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Hok Ẹkkọhbhi nda ch'Echekhi k'ẹtzaanga, atzima ekpekhe akpa chẹ amaana k'ẹtzaanga. ");
INSERT INTO mfo_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Tzima okpokkoro nwa adim k'ẹtzaanga, ahok ekpo py'ẹbaan bi, ẹnana mẹ. Atzima ettwikkaang-chi adim k'ẹtzaanga, abira atzọkha ottwikkaang anana mẹ. ");
INSERT INTO mfo_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Hok ijafọhnibe sa gol s'insẹns, k'itzitzikha s'Ẹkkọhbhi nda ch'Echekhi, abira agbana ekpekhe k'ẹhọhmma ch'irukhabe nna. ");
INSERT INTO mfo_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Hok ijafọhnibe s'ẹnanga ẹkwọmichẹ k'itzitzikha s'ẹhọhmma ch'irukhabe nna, kw'ode irukhabe s'ewobha ttara Ibinọkpaabyi; ");
INSERT INTO mfo_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ahok ọkwakkama k'ottem kw'irukhabe nna ọmaana ijafọhnibe, akhe asi m'ọkwakkamma nwa. ");
INSERT INTO mfo_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Tzima ẹttọmmattem akhori sẹ, abira agbana ekpekhe k'ẹhọhmma ch'ẹttọmmattem nda. ");
INSERT INTO mfo_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Tzọkha ana pa bẹ am-abyengi ọnọng k'eho, abyengi m'irukhabe nna ọmaana k'ọttọhk kpenamkpen f'owobh k'ẹtzaanga; si sẹ ọmaana ekpo pyẹ biphyir ewur, mando kwa sẹ íwur. ");
INSERT INTO mfo_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Mẹ wọ, biri tzọkha ana pa bẹ am-abyengi ọnọng k'eho, abyengi k'ijafọhnibe s'ẹnanga ẹkwọmichẹ, ọmaana ekpo pyẹ biphyir, sẹ ide ibe s'awurada p'ayọhng awurada. ");
INSERT INTO mfo_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Biri byengi ana mba k'ọkwakkamma ọmaana k'ẹnana chẹ, asi pyẹ ewur. ");
INSERT INTO mfo_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Tzima Aarọn ọmaana va pẹ p'ijinọng akwu k'ẹhọhmma ch'irukhabe nna, atzima asi agbobhi bẹ for. ");
INSERT INTO mfo_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Mẹ wọ, fọra Aarọn nnya nna s'awurada, abyeng-ẹ ana k'eho, abira asẹ-ẹ owur, ifha kẹ ofha osi ọtzọhm f'ọfọhnẹja. ");
INSERT INTO mfo_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Biri tzima va pẹ p'ijinọng akwu, afọra bẹ ọnọhma-khum-mbọhk kw'odumi opyiri ka ndudungi. ");
INSERT INTO mfo_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Byengi bẹ ana k'eho, mach'iwa abyengi otte kwabẹ, ifha bẹ afha asi ọtzọhm mach'afọhnẹja. M'eden nda dọ cha bẹ achina ororo áde afọhnẹja k'igbọ s'íkwu k'ogbe ororo. ");
INSERT INTO mfo_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Wa Mosẹs osi odik kpenamkpen mach'Ọvaar Ibinọkpaabyi oben-ẹ. ");
INSERT INTO mfo_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Mẹ wọ, wa bẹ attima irukhabe nna k'echedenwu ch'ocheden-phe, ka cho kw'ottong afa. ");
INSERT INTO mfo_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mada Mosẹs ottim irukhabe nna, obera arin pẹ bi gbuk, obiro okhe nchi s'ọmma, okhe nneremachi sẹ, obiro ottima mkpọmmachi. ");
INSERT INTO mfo_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ọn-ọmẹma ekhirakpa nda obubha k'ebir-ebir kw'irukhabe nna, obiro obubha ebir-ebir kw'ikhira nna mach'Ọvaar Ibinọkpaabyi obeni Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ọtzọkha atza-gbẹgbẹri p'Asana okhe k'Ẹkkọhbhi ch'Echekhi, ọtzọkha nneremmachi ọnọhma m'Ẹkkọhbhi ch'Echekhi, obiro obubha chẹ ttara ẹkkọhbhikpa ch'ephyokhi. ");
INSERT INTO mfo_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Mẹ wọ, otzima Ẹkkọhbhi ch'Echekhi odim k'irukhabe ẹtzaanga, ọgbana ekpekhe ọkpa chẹ ọmaana k'ẹtzaanga, obiro ọkpa Ẹkkọhbhi ch'Echekhi ọmaana kẹ, mach'Ọvaar Ibinọkpaabyi obeni Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Wa Mosẹs obera okpokkoro k'ẹtzaanga kw'irukhabe, k'okhubha kw'okkeri k'ebir-ebira, k'iyaan-iyaan s'ekpekhe nda, ");
INSERT INTO mfo_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ọtzọkha brẹd ọnana m'okpokkoro nwa ebir-ebir, k'itzitzikha s'Ọvaar Ibinọkpaabyi, mach'Ọvaar Ibinọkpaabyi oben Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ohok ettwikkaang-chi k'irukhabe ewobha ekkeri okpokkoro itzitzikha k'ẹrakha-ẹrakha kw'irukhabe nna, ");
INSERT INTO mfo_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","obiro otzini attwikkaang mba obera m'itzitzikha s'Ọvaar Ibinọkpaabyi, mach'Ọvaar Ibinọkpaabyi obeni Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Mosẹs ottima ijafọhnibe sa gol k'irukhabe ẹtzaanga k'itzitzikha s'ekpekhe, ");
INSERT INTO mfo_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","obiro ọkwọmi insẹns kw'ọdaami eruk mẹ, mach'Ọvaar Ibinọkpaabyi obeni Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Mẹ wọ, ọgbana ekpekhe nda k'ẹhọhmma ch'irukhabe nna. ");
INSERT INTO mfo_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ottima ijafọhnibe s'ẹnanga ẹkwọmichẹ ọbaanga ẹhọhmma ch'irukhabe, s'ide irukhabe s'ewobha ttara Ibinọkpaabyi. Osi ẹnanga ẹkwọmichẹ, ttara ẹnanga ch'abọkpa mẹ, mach'Ọvaar Ibinọkpaabyi, oben Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Obera ọkwakkama nwa k'ottem kw'irukhabe s'ewobha ttara Ibinọkpaabyi, ọmaana ijafọhnibe nna, okhe asi m'ọkwakkamma nwa pa mbọhk ọmaana mmopatzọkhi ogbogbobhi, ");
INSERT INTO mfo_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","mẹ kwa Mosẹs ọmaana Aarọn, ttara va p'Aarọn p'ijinọng, am-agbobhi mbọhk, ọmaana mmopatzọkhi sabẹ. ");
INSERT INTO mfo_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ogbe kpenamkpen kwa bẹ adimi k'irukhabe nna, obiro ode bi bẹ areng atzuma k'ijafọhnibe, bẹ am-agbobhi mbọhk ọmaana mmopatzọkhi sabẹ, mach'Ọvaar Ibinọkpaabyi obeni Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Mẹ wọ e, Mosẹs ottima ẹttọmmattem ọkhọri irukhabe nna, ọmaana ijafọhnibe nna, ọgbana ekpekhe k'ẹhọhmma ch'ẹttọmmattem. Wa Mosẹs okyera ọtzọhm osisi. ");
INSERT INTO mfo_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Mẹ wọ, eboni ebubha irukhabe nna, abarada p'Ọvaar Ibinọkpaabyi abira ahakha afu irukhabe nna bi pyẹẹr. ");
INSERT INTO mfo_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Wa Mosẹs k'irukhabe nna ẹtzaanga dọk kofha odim, okhuri da eboni nda ẹkk'ẹhakha ewobha mẹ, abarada p'Ọvaar Ibinọkpaabyi abira afu m'irukhabe nna. ");
INSERT INTO mfo_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","K'orenga kw'anọng p'Israẹl asi biphyir, ogbe kpenamkpen kwa bẹ are da eboni eyebhi k'irukhabe, bẹ abina orenga; ");
INSERT INTO mfo_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","yina, idikha eboni en-eyebhi, bẹ orenga kabin, maa opyiri k'ewu cha ch'eyebh. ");
INSERT INTO mfo_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Mẹ wọ, wa eboni nda ch'Ọvaar Ibinọkpaabyi em-ebubha irukhabe nna k'ẹya, ekpon ẹm-ẹwọma mẹ k'erungi. Wa anọng p'Israẹl biphyir am-are odik nwa k'orenga kwabẹ biphyir.");
INSERT INTO mfo_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Ma wọ ode atzim pa nnwẹr nwa, pa Mosẹs ọgbaakhi ọnang anọng p'Israẹl bi waam, k'ebherede k'okhubha kw'ewuchen em-eyin ka Jọrdan, kw'ode okhubha kw'Araba kw'okkeri Suph itzitzikha, k'ottem kwa Paran ọmaana Tophẹl, ọmaana Laban, ọmaana Hazerọt ttara Dizahab. ");
INSERT INTO mfo_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(Ode orenga kw'iwu jobh obhiri wani da afon ka Họrẹb arenga k'eden ch'egbegbeho cha Seir achina ka Kadẹsh-Barnea.) ");
INSERT INTO mfo_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","K'echedenwu ch'ophe kw'ottong jobh obhiri wani, ka cho kw'ottong arọbh afa, Mosẹs osi ẹjaakhi ch'odik kpenamkpen kw'Ọvaar Ibinọkpaabyi ọkk'ẹ ẹfa ọnanga bi, ọgbaak okhuri anọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Wa osi ẹjaakhi nda k'ogbe kw'okk'Sihon kw'ode ọvaarnọng kw'anọng p'Amọr kw'ọdabhi Hẹshbọn, okhema, ọmaana Og kw'ode ọvaarnọng kw'anọng pa Bashan kw'ọdabhi Ashtọrẹt, kwa kẹ obiro okhema k'Edreyi. ");
INSERT INTO mfo_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","K'okhubha kw'ewuchen em-eyin ka Jọrdan, k'irerek sa Moab wọ kwa, Mosẹs ọttẹwọr osi ẹjaakhi ch'aphaangi mba, oben bi: ");
INSERT INTO mfo_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwamaan ọgbaakhi man ka Họrẹb bi, “Bọng akk'm'okhubha nwa kw'egbegbeho nda awobha kpọhng e. ");
INSERT INTO mfo_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Bọng bina orenga achina k'okhubha kw'ẹkhọma cha mgbegbeho ch'anọng p'Amọr; bọng nọhng k'ayokh-ibaanga biphyir k'okhubha kw'Araba, ọmaana k'okhubha kwa mgbegbeho sa ngori-ngori, ọmaana k'okhubha kwa mgbegbeho sa ndẹri-ọtzẹri k'okhubha kw'ewuchen em-edimi, ọmaana k'okhubha kwa Nẹgẹv ọmaana k'ọraanga ọkhaan-ọkhaan, ọmaana k'irerek s'anọng pa Kenaan ttara Lẹbanọn maa, apyiri k'ọraanga kw'ideden kwa Yupharetes. ");
INSERT INTO mfo_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Bọng kker e, kaam nkk'bọng irerek nna nnanga. Bọng dim kẹ atza atzọkha irerek s'iwa Ọvaar Ibinọkpaabyi ochekhi bi, ọnang ab'atte Abraham, ọmaana Isaak, ọmaana Jekọb ttara va pa va pabẹ.” ");
INSERT INTO mfo_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Iwa mben bọng m'ogbe nwuma bi, “Ọtzọhm fa ndim bọng eden ọkk'ọbara ọyọhng-m bi nsi manchen e. ");
INSERT INTO mfo_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, okk'bọng ọhaabh ọttara maa, mayina, bọng an-ahaabhi macha ndodori s'ọrọngkpakpa. ");
INSERT INTO mfo_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Tte Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kw'ab'atte, ọttara bọng ọhaabh k'igbe nnọhna mfa obhiri arọbh jobh, obiro odo bọng otzor k'echekhi chẹ! ");
INSERT INTO mfo_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Kaam dama-dama kwabọng, ọmaana ẹtzọhkha chabọng ttara ikhakhaanga sabọng biphyir, mancheni kimfha ndọhkh e. ");
INSERT INTO mfo_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Bọng dekha akkoji-nọng p'akhaam etzina, p'anọng abira arọbh-ọrọbh k'ẹnọmma kpenamkpen, ifha kaam nsi bẹ atzim-eden pabọng.” ");
INSERT INTO mfo_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Iwa bọng abhin-m bi, “Odik nwa kw'achibhi bi asi ojibhi kẹ.” ");
INSERT INTO mfo_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Mando kw'iwa kaam Mosẹs, ndọk anọng mba ka nnọmma sabọng p'akhaam ekkoji, p'anọng abira arọbh-ọrọbh nnang bẹ ẹfa bi, bẹ atzima bọng eden ka ngaan sa nnọhna mfa obhiri arọbh jobh, ọmaana s'arọbh azen, ọmaana s'arọbh afa obhiri jobh, ọmaana ẹkhaan ch'anọng jobh ttara aho pa nnọmma. ");
INSERT INTO mfo_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Wa mbiri nnang asi-aponga pabọng p'ogbe nwuma ẹfa bi, “Bọng mmaanga ikhakhaanga s'anọng pabọng, bọng asi aponga akkakka. Kaambi ode bi, ode aponga p'ọnọng kw'ofon Israẹl ọmaana ayokh-ammaana pabọng, obiro ode aponga p'ọnọng kw'ofon Israẹl ọmaana okhekhenọng kw'orukhi ttara bọng wọ. ");
INSERT INTO mfo_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Bọng mmaanga aponga p'odedennọng ọmaana pa nnwanwa ebenga-mbọhk; bọng ọnọng ka nnam kabe da bọng asi aponga. Ojora oningi bọng osi, okhuri bi, eponga-ttọhna ẹkhaam Ibinọkpaabyi e. Bọng dima iponga kpenamkpen s'igaangi iyọhnga bọng achen-m, ifha ńttọhna. ");
INSERT INTO mfo_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Wa kaam mgbaakhi bọng idik biphyir sa bọng asi m'ogbe nwuma. ");
INSERT INTO mfo_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","K'odem kw'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwaman ọtzọhni man, mobina orenga ka Horẹb orenga k'ebherede biphyir cha bọng akk'ara, ch'ẹbar-ọbar ebere ejor-ojora, mochina k'owubha kwa mgbegbeho s'Amọr, opyiri ka Kadẹsh Barnea. ");
INSERT INTO mfo_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Mẹ wọ ofon kaam mben bọng bi, “Bọng akk'apyiri k'okhubha kwa mgbegbeho s'anọng p'Amọr, kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaman, ọnangi man. ");
INSERT INTO mfo_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Bọng kker e, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng okk'bọng irerek nna ọnanga e. Bọng nnọhng atza atzọkha sẹ akhaama, atzor k'odem kw'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'ab'atte ọgbaakhi bọng. Ojora oningi bọng osi, ẹfa eningi bọng ebire ẹha.” ");
INSERT INTO mfo_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Iwa bọng biphyir akwu aben-m bi, “Tte mọtzọhm nttọ sa ncheden nda nnom nden sa morenga, ọmaana ibhon sa mopyiri, ifha sẹ mkpa nnam nkwu mgbaak man.” ");
INSERT INTO mfo_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Iwa ochibhi nwa akwu ọdaakh-m, ndekha bọng anọng jobh obhiri afa, ojinọng wani k'ẹkhọma. ");
INSERT INTO mfo_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Wa bẹ avura achina k'okhubha kwa mgbegbeho, yina bẹ an-achin k'Ittolim s'Ẹshkol, arenga arom sẹ. ");
INSERT INTO mfo_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Ajinọng apha achiduk p'irerek nna, atzima akhuna achena man aben bi, “Irerek ikkakka rọ s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaman, obeni bi, ọnang man.” ");
INSERT INTO mfo_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“Yina, bọng asi irẹrẹkhi anang ndọhna s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, bọng kavur achina k'irerek nnuma. ");
INSERT INTO mfo_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Bọng awobha k'okhira fabọng attakhi aben bi, ‘Ọvaar Ibinọkpaabyi ọttaang man ọttaanga e, kẹ wọ osi otzima man obina k'Ijip bi, ọtzọkha man ọnang anọng p'Amọr bi, bẹ adimi. ");
INSERT INTO mfo_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Mon-ochina man o? Ẹkkaabha cha votte paman ẹha man ẹfa. Bẹ agbaakhi man bi, ‘Anọng p'irerek nna adumi ọtzam ayọhnga man, bẹ akhaama ẹfa ayọhnga man, ibhon sabẹ ibari ẹkpa, bẹ atzima abaakha p'agori-ogori maa, apyiri k'ẹrọng akhọri sẹ! More va pa va p'Anak kẹ, p'adumi agori k'ẹrọng bi kottoong!’ ” ");
INSERT INTO mfo_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","“Yina, kaam mben bọng bi, ‘For iningi bọng ipe, anọng mbuma aningi bọng ojor! ");
INSERT INTO mfo_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng wọ ochi bọng eden e. Kẹ wọ orima erima chabọng, mach'iwa bọng arẹ-ẹ da osi k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Wa bọng akk'ara odem kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi, okkeri bọng k'orenga kwabọng k'ebherede, mach'otte kwa nnwa okkeri nnwa kwẹ. Ma, okk'bọng otzima okwu m'ibe nna.’ ");
INSERT INTO mfo_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","“Yina, chibhi da kẹ Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng okk'mando ọsa wọ, bọng abhum bi aphe nnam ka kẹ, ");
INSERT INTO mfo_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","nwuma kw'ochi bọng eden om-oror ibe ọkkakka sa bọng abhing, om-otzima ẹkpọmmachi ch'ekpon otzima bọng eden k'erungi, obiro otzima ẹkpọmmachi ch'eboni otzima bọng eden k'ẹya. ");
INSERT INTO mfo_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“K'ogbe kw'Ọvaar Ibinọkpaabyi ọbhaang idik sa bọng am-agbaak, ọdọhkhi ettem k'eden ọkka. Mẹ wọ ofon, ochibhi bi, ");
INSERT INTO mfo_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘Ọnọng manda wani m'ottem kw'ọgbọ-tzama nwa kwabọng kóde, kw'óruk akpen ore irerek-jibhada s'iwa nchekhi nnang ab'atte pabọng, ");
INSERT INTO mfo_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","oyongi Kalẹb kw'ode nnwa kwa Jephunẹ. Kẹ óre irerek nna ore okhuri bi, kẹ okk'ettm-obungichẹ otzima ọtzọn Ọvaar Ibinọkpaabyi abẹ. Kaam Ọvaar Ibinọkpaabyi ńnang kẹ ọmaana va pa va pẹ, okhubha wani kw'irerek nna s'iwa ọtza ọkpaanga, k'ogbe kw'iwa bẹ aromi sẹ.’ ");
INSERT INTO mfo_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","“Iwa Ọvaar Ibinọkpaabyi oreng bọng abẹ obiro ọdọkhi ettem ọmaana kaam. Wa oben-m bi, ‘Mosẹs o, kaambi kọ wọ, m'irerek nna s'echekhi kádim e! ");
INSERT INTO mfo_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Ottu kwa kọ adim mẹ, nnwa kwa Nun kw'ode Joshua kw'ojem-ọ mbọhk ka nnam wọ, ótzima anọng mba eden odim m'irerek nna. Kọ kẹ-ẹ ẹfa, kkeri kẹ wọ ótzima anọng p'Israẹl eden da bẹ atzọkha irerek nna, akhaama. ");
INSERT INTO mfo_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Kaam ndọkha irerek nna ńnang va pabọng, va pabọng p'ani oponga-phyibha akhaam e. Wa ojor bọng bi, na attattaanganọng abọkha bẹ atzima afona, yina, bẹ-bẹ bọ atza atzọkha irerek nna arukh e. ");
INSERT INTO mfo_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Yina, bọbọng na bhakhi akpa nnam atza arenga k'ebherede akkeri itzitzikha k'Ẹraanga-hora.’ ");
INSERT INTO mfo_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“Iwa bọng asi ẹjaakhi bi, ‘Mokk'ẹkhọngkwuri ọsa k'itzitzikha s'Ọvaar Ibinọkpaabyi! Modim-odim m'irerek nna orima anọng mba abẹ ọtzọkha sẹ, mach'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaman, okk'man ẹfa ọnanga.’ Mando kw'ajinọng pọ adabhi ekpo, da osi bẹ bi ode odik kw'ọmọm-ọmọm bi, bẹ atza arima ẹkhọma ch'okhubha kwa mgbegbeho abẹ. ");
INSERT INTO mfo_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","“Yina, Ọvaar Ibinọkpaabyi ọgbaakh-m bi, mgbaak bọng bi, ‘Bọng bẹ abẹ kàrima, okhuri bi, kaam kimbe ttara bọng. Idikha bọng atza arima bẹ abẹ kabọng ọkhaam ka for, attattaanganọng pabọng ákhema bọng okhema.’ ");
INSERT INTO mfo_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Ma wọ ode odik kwa mgbaakhi bọng, yina, bọng itzọhng kayong. Yina, bọng abira anang ndọhna s'Ọvaar Ibinọkpaabyi irẹrẹkhi, bọng abina ttara for-ogege kwabọng, atza arima anọng p'okhubha kwa mbgegbeho abẹ. ");
INSERT INTO mfo_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Yina, anọng p'Amọr p'arukhi mẹ ayin k'iyaan mach'ẹkhaan ch'akhọkhọna. Bẹ akhubh bọng abira attum bọng ngwur ttẹwọr ka Seir maa, atza apyiri ka Horma. ");
INSERT INTO mfo_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Bọng akpa nnam akhuna atza abhom ayeri Ọvarr Ibinọkpaabyi, yina, bọng itzọhng koyong. ");
INSERT INTO mfo_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Mando kwa bọng awobh ma Kadẹsh, k'ogbe-bhirada. ");
INSERT INTO mfo_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","“Mando kw'iwa am-ọbhakhi ọkpa nnam ọtza orenga k'ebherede ochina k'okhubha kw'Ẹraanga-hora, mach'Ọvaar Ibinọkpaabyi ọkk'aam ọtzọhna. K'ogbe-bhirada, morenga ọkhọri okhubha kw'egbegbeho cha Seir. ");
INSERT INTO mfo_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","“K'ekponga-nnam, Ọvaar Ibinọkpaabyi oben-m bi, ");
INSERT INTO mfo_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Bọng akk'arenga k'okhubha kwa mgbegbeho k'ogbe kw'obhiri kpọhng e: bọng makhi achina k'obhon ebira. ");
INSERT INTO mfo_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Kọ nang anọng mba ndọhna nna: ‘Bọng arenga k'ẹkhọma ch'anọng p'Edom p'ade agbanaatte pabọng, p'ade va pa va p'Esau p'arukhi ka Seir. Ojora ósi anọng p'Edom osi e, mẹ wọ, bọng bọkha bọng for o. ");
INSERT INTO mfo_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Bọng anọng p'Edom atzim kàyak, okhuri bi, kaam nkk'bẹ okhubha kwa mgbegbeho maa, akhọri k'egbegbeho cha Seir nnang bi, bẹ akhaama. Kaam bọng ibebaa kaambi ẹtzọkhi dani chẹ-chẹ dọ, m'irerek nna kínang. ");
INSERT INTO mfo_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Bọng arori ọchattọhk obiro ode asi, bọng debh-odebh ka bẹ ka mbọhk.’ ” ");
INSERT INTO mfo_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng okk'itzọhm-bọhk sabọng biphyir oda. Kẹ Ọvaar Ibinọkpaabyi okk'bọng okkeri ka cho arọbh afa, k'orenga kwabọng m'ebherede-barẹkpa nda biphyir. Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi okk'owobha ttara bọng, ọttọhk f'owori bọng kode. ");
INSERT INTO mfo_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Mando kwa moreng ọkwọbha va pa va p'Esau, p'ade agbanaatte paman p'arukhi ka Seir. Mọbhakhi ọkpa nnam ọbọra eden ch'Araba, ch'efon k'ebir-ebira kw'Elat ọmaana Geber, morenga k'eden ch'ebherede cha Moab. ");
INSERT INTO mfo_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Ọvaar Ibinọkpaabyi oben-m bi, “Bọng anọng pa Moab kàgbọri, bọng bẹ kànyuni bi bẹ arima egbong, okhuri bi, kaam bọng ibe manda rani k'irerek sabẹ kínang. Kaam nkk'irerek s'anọng p'Ar ndọkha nnang va pa va pa Lọt bi bẹ akhaama.” ");
INSERT INTO mfo_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(Anọng p'Emim bọ iwa am-aruk k'Ar. Wa bẹ ade anọng p'ahaabh-ọhaabh, p'akhaam ẹfa abira adum ebe mach'anọng p'Anak. ");
INSERT INTO mfo_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Odem nwa kw'iwa bẹ atzọk anọng p'Anak, wa anọng abira atzọkha anọng mba p'Emim bi bẹ ade anọng pa Rephayim, yina, anọng pa Moab ayeri bẹ anọng p'Emim. ");
INSERT INTO mfo_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Wa anọng pa Họr arukhi ka Seir, yina, wa va pa va p'Esau akhubh bẹ. Bẹ adimi anọng pa Họr, atzọkha ibe nna aruk, mach'iwa anọng p'Israẹl asi k'irerek s'Ọvaar Ibinọkpaabyi ọtzọk ọnang bẹ mach'ekkema chabẹ). ");
INSERT INTO mfo_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Iwa Ọvaar Ibinọkpaabyi oben bi, “Kọ bina k'ẹrọng ajekha ittolim sa Zẹrẹd.” Mando kwa mojek ittolim nna. ");
INSERT INTO mfo_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Iwa cho ẹrọbh obhiri chi obhiri attaan akwu akwọbha, ttẹwọr k'ogbe kwa mobin ka Kadẹsh Barnea maa, mokwu ojekha ittolim sa Zẹrẹd. M'ogbe nwa, arim-egbong biphyir p'ọgbọ nwa akk'apa k'ibhingabe, atzor k'odem kw'iwa Ọvaar Ibinọkpaabyi okk'ochekhi. ");
INSERT INTO mfo_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Wa Ọvaar Ibinọkpaabyi ọttaang ọnang anọng mba maa, odimi bẹ k'ibhingabe biphyir-phyir. ");
INSERT INTO mfo_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","K'ogbe kw'okponga-nnam-nọng kw'arim-egbong k'ottem kw'anọng mba ọkk'ọpa, ");
INSERT INTO mfo_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Ọvaar Ibinọkpaabyi oben-m bi, ");
INSERT INTO mfo_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Bọng arenga k'okhubha kwa Moab k'Ar, mayina e. ");
INSERT INTO mfo_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Bọng apyiri k'anọng p'Ammọn, bọng bẹ kàgbọri, bọng bẹ kànyuni bi, bẹ arima egbong okhuri bi, kaam bọng ibe manda rani k'irerek s'anọng p'Ammọn kínang. Kaam nkk'sẹ ndọkha nnang va pa va pa Lọt bi, bẹ akhaama e.” ");
INSERT INTO mfo_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Iwa bẹ atzọk irerek nnuma bi, ide s'anọng pa Rephayim p'iwa arukhi mẹ; yina, anọng p'Ammọn ayeri bẹ aZamzumim. ");
INSERT INTO mfo_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Wa anọng mba p'Zamzumim ahaabh-ọhaabh, bẹ akhaam ẹfa abira adum ebe mach'anọng p'Anak. Wa Ọvaar Ibinọkpaabyi odimi bẹ k'itzitzikha s'anọng p'Ammọn, p'akhubhi be atzọkha irerek sabẹ aruk. ");
INSERT INTO mfo_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Wa Ọvaar Ibinọkpaabyi okk'odik-dema nwa ọsa ọnang va pa va p'Esau p'arukhi ka Seir, k'ogbe kw'odimi anọng pa Họr k'itzitzikha sabẹ. Wa bẹ akhubhi bẹ, atzọkha irerek sabẹ aruk maa, apyiri k'ewu cha mayina. ");
INSERT INTO mfo_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Onode anọng p'Avim p'arukhi k'ibhon s'iwobh k'odenmir macha Gaza, ọmaana anọng pa Kaphtor bọng dimi bẹ odimi, atzọkha ibe sabẹ aruk.) ");
INSERT INTO mfo_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Bọng bina orenga ajekha Ittolim s'Arnọn. Bọng kker e, kaam nkk'Sihon kw'ofon Amọr ode ọvaarnọng kwa Hẹshbọn ọmaana ẹkhọma chẹ ndọkha nge bọng ka mbọhk. Bọng ttẹwọr arim-ẹ abẹ abira atzọkha irerek sẹ. ");
INSERT INTO mfo_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Ttẹwọr k'ewu cha mayina, kaam ńdima bọng nge idibhon biphyir s'ọyagbin opoma ọmaana ojora. Sẹ ífhọni ibiri iwobha k'ojora k'ogbe kwa sẹ íbhaanga idik okhuri bọng.” ");
INSERT INTO mfo_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Nwobh k'ebherede cha Kẹdẹmot ndọhm akkaabh-nkkaabha, ẹkkaabha ch'ẹmẹm bi, bẹ achena ọvaar Sihon kw'ọdabhi Hẹshbọn, mben bi, ");
INSERT INTO mfo_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“Tte morenga m'ẹkhọma chọ. Mórenga k'ọkkadeden kẹ-kẹ; man k'odimbọhk obiro ode ka kwabọhk kóchina. ");
INSERT INTO mfo_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Bọng kpe man ọchattọhk mochi, bọng akpe man asi k'asilva, mogwo. Odik obungikwẹ kwa morori ode bi, atte man ọbọhk mokhinggẹ orenga ma ọkwọbha, ");
INSERT INTO mfo_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","macha va pa va p'Esau p'arukhi ka Seir, ọmaana anọng pa Moab p'arukhi k'Ar, atte man ọbọhk maa, mojekha Jọrdan odim k'irerek s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwaman ọnangi man.” ");
INSERT INTO mfo_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Yina, ọvaar Sihon kw'ọdabhi Hẹshbọn obhum bi, otte man ọbọhk mọkwọbha. Da Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi ọkk'ẹ ọsa ọbar ettem, obiri ọsẹ-ẹ bi ọkhaama irẹrẹkhi, ifha ọtzọkh-ẹ okhe bọng ka mbọhk mach'ọkk'ọsa ma. ");
INSERT INTO mfo_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Ọvaar Ibinọkpaabyi oben-m bi, “Kker e, kaam nkk'ẹwọr ntta ntte ọvaar Sihọn ọmaana ẹkhọma chẹ ọbọhk ntta nnang bọng. Bọng ttẹwọr akhema chẹ abira atzọkha chẹ akhaama.” ");
INSERT INTO mfo_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","K'ogbe kw'ọvaar Sihọn ọmaana arim-egbong pẹ biphyir, ayin akwu akhebha man k'egbong ka Jahaz, ");
INSERT INTO mfo_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","mando kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaman ọttẹ-ẹ ọbọhk ọnang man, mọfhẹ-ẹ, ọmaana va pẹ p'ijinọng ttara arim-egbong pẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","M'ogbe nwuma mọbọhk-ẹ ibhon sẹ biphyir ọna, mobiri odimi sẹ, modimi ajinọng, ọmaana panọng ttara va. Mọnọng manda wani kohokhi oruk akpen. ");
INSERT INTO mfo_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Yina, wa mọtzọk etzirakpo ọmaana ọgbọm fa mọkk'ọcha k'ibhon nna, otzima ofona ọtza ọkhaama. ");
INSERT INTO mfo_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Ttẹwọr k'Aroer k'ọkhaan-ọkhaan kw'Ittolim s'Arnọn, ttẹwọr mobhon nwuma kw'ittolim maa, atza opyiri ka Gilead kw'owobh k'odenmir, obhon kw'iwa ọgaangi kpọhng ọyọhnga man kode. Wa Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaman, ọtzọk ibhon nna biphyir otte ọbọhk ọnang man. ");
INSERT INTO mfo_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Kaambi mẹ wọ, bọng atzori ka ndọhna s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaman, bọng k'irerek s'anọng p'Ammọn, ode s'ọraanga kwa Jabọk, obiro ode irerek s'ikhọri ibhon s'okhubha kwa mgbegbeho, kajek. ");
INSERT INTO mfo_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Iwa mokpannma orenga ovura k'eden ch'echin ka Bashan, wa Og kw'ode ọvaarnọng kwa Bashan ttara arim-egbong pẹ biphyir, arenga ayin ka akwa akhebha man ka Edrei bi arima man abẹ. ");
INSERT INTO mfo_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Wa Ọvaar Ibinọkpaabyi oben-m bi, “Tte kẹ oningi bọng ojor, kkeri kaam nkk'kẹ ọmaana arim-egbong pẹ biphyir ttara irerek sẹ, ndọkha nge bọng ka mbọhk. Bọng sẹ-ẹ mach'iwa bọng asi Sihon, kw'ode ọvaarnọng kwa Amọr, kw'iwa ọdabhi ẹvaar ka Heshbọn.” ");
INSERT INTO mfo_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Mẹ wọ, wa Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaman, obiro ọtzọkha Og kw'ode ọvaarnọng kwa Bashan ọmaana arim-egbong pẹ biphyir, okhe man ka mbọhk. wa mofhu bẹ biphyir, man ọnọng manda wani korikhi. ");
INSERT INTO mfo_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","M'ogbe nwuma, wa mọtzọkha idedenmon sẹ biphyir. Wa k'idedenmon arọbh attaan biphyir, idedenmon kide sa mon-ọtzọkh, k'ẹkhọma cha Argọb, kw'ode ọvaarbhon kwa Og ka Bashan. ");
INSERT INTO mfo_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Wa idedenmon nna biphyir, ikhaam abaakha p'agaangi-ọgaangi ọmaana mbakhamma s'akkonga, bẹ abira akhaama ibhon s'ihaabh-ọhaabh s'ini abaakha akhaam. ");
INSERT INTO mfo_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Wa modimi bẹ biphyir-phyir mach'iwa modimi Sihọn kw'ode ọvaarnọng kwa Hẹshbọn, wa modimi odedenmon kpenamkpen, ajinọng ọmaana panọng ttara vava pabẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Yina, wa mọtzọkha etzirakpo ọmaana ọgbọm fa mochi bẹ k'idedenmon sabẹ, ọtzọkha ọkhaama. ");
INSERT INTO mfo_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","M'ogbe nwuma, wa mọtzọkha irerek s'iwobh k'okhubha kw'ewuchen em-eyin ka Jọrdan, ttẹwọr k'ittolim s'Arnọn maa, apyiri k'egbegbeho cha Hẹrmọn ka mbọhk sa avaar mba afa p'Amọr. ");
INSERT INTO mfo_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Wa anọng pa Sidọn am-ayeri Hẹmọn Siriyọn, anọng p'Amọr ayeri sẹ Sẹnir.) ");
INSERT INTO mfo_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Iwa mọtzọkha ibhon s'iwọbh k'ẹgbegbeho, ọmaana Gilead biphyir ttara Bashan biphyir maa, apyiri ka Salẹka ttara Edrei, s'ide ivaarbhon s'ọvaar Og kwa Bashan. ");
INSERT INTO mfo_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Wa Og kw'ode ọvaarnọng kwa Bashan wọ ode okponganam-nọng, kw'ofon k'ẹkhọma cha Rephayim kw'ope. Wa bẹ atzim akkonga adokha ẹkkọbhi chẹ, adum p'ẹkkọhbhi chẹ apyiri ndọkhi ọhawani kwa chi, ẹ̀kpá chẹ epyiri ndọkhi nzadani. Ch'etzim ewobh k'ẹkhọma cha Raba kw'anọng p'Ammọn.) ");
INSERT INTO mfo_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Iwa k'ogbe nwuma mọtzọk irerek nnuma s'ẹkhọma ch'ewobh k'ebira kw'Aroẹr ọbaanga ittolim s'Arnọn, ọmaana ibhakha rani s'ibhon s'egbegbeho cha Gilẹad ttara ibhon sẹ, ọnang anọng pa Reubẹn ọmaana anọng pa Gad. ");
INSERT INTO mfo_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Ndọkha okhubha kwa Gilẹad kw'on-orikhi ọmaana okhubha Bashan biphyir ttara odedenmon kw'ọvaar Og, nnang ibhakha rani sa Manasẹ. (Wa anọng arong bi ẹkhọma ch'Argọb ka Bashan, ede irerek s'anọng pa Rephayim. ");
INSERT INTO mfo_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Wa Jair kwa ode nwa-mmona kwa Manasẹ, ọtzọkha ẹkhọma cha Argọb biphyir, ttẹwọr k'enem cha Geshur ọmaana Maakat. Wa bẹ akpe ibe nna abhina Jair. Mẹ wọ maa apyiri k'ewu cha mayina, Bashan on-okpena Havot-Jair.) ");
INSERT INTO mfo_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Kaam ndọkha Gilẹad nnang Makir. ");
INSERT INTO mfo_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Yina, wa ndọkha irerek s'ittẹwọr ka Gilẹad maa, ipyiri k'ottem kw'ittolim s'Arnọn (kw'ode enem) itzima mẹ maa, ipyiri k'ọraanga kwa Jabọk kw'ode enem cha Ammọn, ndọkha nnang anọng pa Reubẹn ọmaana anọng pa Gad. ");
INSERT INTO mfo_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Enem ch'okhuba kw'ewuchen em-edimi ede Jọrdan k'Araba, ttẹwor ka Kinẹrẹt maa epyiri k'ọraanga kw'ideden kw'Araba, k'ẹrakha-ẹrakha kw'iwona sa Pisga. ");
INSERT INTO mfo_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Iwa mgbaakhi bọng m'ogbe nwuma bi, “Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng okk'bọng irerek nna ọnanga bi, bọng atzọkha mach'ekkema chabọng. Yina, ajinọng biphyir p'ade afa-nọng, p'akk'egbong-for adabha, akhaambi ajekha k'okhubha nwongo kw'anọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Ayongi mẹ, tte panọng pabọng, ọmaana va pabọng, ttara etzirakpo pyabọng (kaam nnọng kẹ bi bọng akhaam etzirakpo py'ehaabh-ọhaabh e) ewobha k'ibhon sa nkk'bọng nnanga maa, ");
INSERT INTO mfo_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Ọvaar Ibinọkpaabyi ọnang ayok-obhon p'Israẹl ẹwọngkwokha mach'okk'bọng ọnanga, ifha bẹ abira atzọkha irerek s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng onangi bẹ k'okhubha kwa Jọrdan. Yina bọng an-akpannam k'irerek sa nkk'bọng nnanga.” ");
INSERT INTO mfo_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Iwa k'ogbe nwuma kaam mbeni Joshua bi, “Kọ akk'odik kpenamkpen ara kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọkk'ọsa ọnang avaar mba afa. Ọvaar Ibinọkpaaabyi óbiro ósi mando ónang ivaarbhon biphyir, s'iwobh k'okhubha nwongo kwa bọng ájekha áchina. ");
INSERT INTO mfo_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Tte ojora oningi bọng osi okhuri bẹ. Da Ọvaar Ibinọkpaabyi ọkhaam ma for sẹ kw'ode Ibinọkpaabyi kwabọng, órima erima chabọng orima.” ");
INSERT INTO mfo_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Wa kaam mphyem Ọvaar Ibinọkpaabyi bi: ");
INSERT INTO mfo_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“O Ọvaar Ibinọkpaabyi kw'Ọyọhng, kọ akk'ẹwọr atta akhọkha ọtzọhmnọng kwọ abarada pọ ọmaana ọfabọhk kwọ. Bọng ọkha vọ owobh k'ẹrọng ọmaana irek fa ófho osi idik-barada nna sa kọ am-asi o? ");
INSERT INTO mfo_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Tte kaam njekha nda nne irerek, irerek-jibhada nna s'iwobh k'okubha kwa Jọrdan, s'ide obhon-jibhada kw'egbegbeho ọmaana Lẹbanọn.” ");
INSERT INTO mfo_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Yina, okhuri bọbọng wa Ọvaar Ibinọkpaabyi ọdọkh-ẹ ttara kaam, itzọhng kobiro oyonga ọnang-m. Ọvaar Ibinọkpaabyi oben-m bi “Kwọbha ọdik nwuma, kaam odik okhuri odik nwa dọk kàgbaak. ");
INSERT INTO mfo_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Kọ vura ebira kwa Pisga, atzini chen akkeri k'okhuba kw'ewuchen em-edimi ọmaana kẹ ebir-ebira ọmaana k'ẹrakha-ẹrakha ttara k'okhubha kw'ewuchen em-eyin. Ko re irerek nnuma ttara chen pọ, da kọ ani Jọrdan ájekha. ");
INSERT INTO mfo_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Yina, kọ rọbha Joshua anang-ẹ ottem-bara abira akhẹ-ẹ ẹfa, da ode kẹ wọ otzima anọng mba eden ojekha k'okhubha, obiro osi bẹ atzọkha irerek nnuma, sa kọ áre.” ");
INSERT INTO mfo_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Mẹ wọ e, m'owobha k'ittolim s'ibaang Bet-Peor. ");
INSERT INTO mfo_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Anọng p'Israẹl o, bọng maanga asana ọmaana aphaangi pa kaam mben bi mkpebhi bọng. Bọng hok bẹ ifha bọng afha aruk atza atzọkha irerek s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'ab'atte obeni bi ọnanga bọng akhaama. ");
INSERT INTO mfo_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Bọng odik ọdọdọk kàttara m'idik nna sa nnangi bọng, bọng odik m'idik nna kàbira arọbha, yina, bọng hok asana pa nnangi bọng p'ade p'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng. ");
INSERT INTO mfo_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Iwa bọng atzim chen pabọng ọkhaam are odik kw'Ọvaar Ibinọkpaabyi osi ka Baal Pẹọr. Wa Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ofhu anọng k'ottem kwabọng, p'akpobh Baal kwa Pẹọr, ");
INSERT INTO mfo_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Yina bọng biphyir p'aphe nnam k'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng atzima arukhi akpen mayina. ");
INSERT INTO mfo_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Bọng kker e, kaam nkk'bọng asana ọmaana aphaangi biphyir mkpebhi mach'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaam ọtzọhn-m, ifha bọng ahok bẹ k'irerek nnuma sa bọng adim atza atzọkha. ");
INSERT INTO mfo_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Bọng dọkha ogbe ahok bẹ, kkeri mẹ kw'idibhon íronga ekkoji chabọng ọmaana etzimnonga, da bẹ abhaanga odik okhuri asana mba biphyir bẹ aben bi, “K'odik-ọkka anọng mba ade ẹkhọma ch'ideden ch'etzimnonga.” ");
INSERT INTO mfo_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Ma, bọng ẹkhọma ch'ideden ẹdọdọk dọ ch'ọkha fabẹ ofor bẹ mach'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwaman ofor man, k'ogbe kpenamkpen kwa m'oyer-ẹ o? ");
INSERT INTO mfo_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Bọng ẹkhoma ẹdọdọk ch'ideden dọ ẹkhaam asana ọmaana aphaangi p'atzor-otzor macha mba pa nji bọng, k'itzitzikha mayina o? ");
INSERT INTO mfo_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Bọng bọkha bọng for, bọng akkeri osisi kwabọng ifha bọng aningi idik nna araam, sa bọng akk'ara ttara chen pabọng, bọng kàbira akhera bi idik nna irọbha k'achibhi pabọng, odem nwa kwa bọng arukhi akpen achina ororo. Bọng kpebhi va pabọng idik nna ọmaana va pabẹ p'akwu k'ogbe ororo. ");
INSERT INTO mfo_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Bọng jima ewu ch'iwa abọng abe k'egbegbekho cha Horẹb k'itzitzikha s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, k'ogbe kw'oben-m bi, “Tzobha anọng mba anang-m ifha mgbaak bẹ atzim, bẹ akpebhi odem kwa bẹ akpobh-m, odem nwa kwa bẹ achin ororo aruk m'irerek nna, ifha bẹ abira akpebhi va pabẹ.” ");
INSERT INTO mfo_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Wa bọng abe abaanga k'orin kw'egbegbekho nda k'ogbe kwa chẹ ẹm-ẹwọma akpondaak p'avur k'ọrọngkpakpa, ttara irorong-bina ọmaana ipyerungi s'ipyi bi kang. ");
INSERT INTO mfo_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Mẹ wọ Ọvaar Ibinọkpaabyi orenga k'ekpon nda ọgbaak bọng atzim. Bọng abhaanga ọwọhng kw'atzim pẹ, yina, bọng kẹ kare; ọwọhng kẹ-khẹ kwa bọng abhaang. ");
INSERT INTO mfo_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Osi ẹjaakhi ch'echekhi chẹ ọnang bọng, ch'ede asana jobh p'ọkkẹri k'atzakpa afa ọnang bọng bi bọng ahok. ");
INSERT INTO mfo_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","M'ogbe nwuma kẹ Ọvaar Ibinọkpaabyi oben-m bi, mkpebhi bọng asana mba ọmaana aphaangi pa bọng ahok k'irerek nna sa bọng ajekha Jọrdan atza atzọkha. ");
INSERT INTO mfo_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Iwa bọng ngera s'ọttọhk manda vani kare, m'ewu nduma ch'Ọvaar Ibinọkpaabyi oreng k'ekpon ọgbaak bọng atzim, k'egbegbekho cha Horẹb. Mẹ wọ, bọng kkeri bọng for o, ");
INSERT INTO mfo_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","ifha bọng aningi for sabọng itzama asi, atza aduk ọgbatza kw'ode ngera s'ọttọhk kpenamkpen, f'ode mach'ojinọng obiro ode macha kwanọng, ");
INSERT INTO mfo_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","ode etzen kpenamkpen ch'ereng m'irek, ode inọhn kpenamkpen s'ikhuri k'ẹrọng, ");
INSERT INTO mfo_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","ode mach'ekyikyirikpo kpenamkpen py'ẹtzọri m'irek, yina ira on-ode etzen kpenamkpen ch'asi. ");
INSERT INTO mfo_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Mada bọng ayaangi chen akkeri k'ọrọngkpakpa are ewuchen ọmaana ophe, ọmaana ndodori, ttara ọttọhk kpenamkpen f'owobh k'ọrọngkpakpa, ọnọng oningi bọng ọbọr bi bọng attima ndudungi anang pyẹ, bọng abira akpobha ekpo py'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọkk'ọbọhk ọtta, ọnang idibhon idọdọk biphyir bi bẹ akpobha k'ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Yina, on-ode bọbọng, Ọvaar Ibinọkpaabyi ọrọbh bọng k'obhon kw'Ijip kwa bọng awobh k'ikhem s'ideden, ifha bọng ade anọng p'ohokhi ettem, macha bọng an-ade ma. ");
INSERT INTO mfo_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Wa Ọvaar Ibinọkpaabyi ọdọkhi ettem ttara kaam okhuri bọng, ochekhi ttara ettem obungichẹ bi, kaam Jọrdan kinjekha ndim k'irerek nnuma s'ijibh-ojibh, s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọ́nang bọng mach'ekkema chabọng. ");
INSERT INTO mfo_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Kaam ḿpe m'irerek nna; kaam Jọrdan kinjekha; yina, bọbọng an-ajekha k'okhubha atza atzọkha irerek nnuma s'ijibh-ojibh. ");
INSERT INTO mfo_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Bọng kkeri bọng for o, bọng aningi echekhi ch'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng osi ttara bọng araam o; bọng ọgbatza manda wani kàsi anang for sabọng, kw'ọtzọkha ngera s'ọttọhk kpenamkpen f'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ọkk'ọsana. ");
INSERT INTO mfo_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Da Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ode ekpon ch'ẹwọm ọjake, kẹ ode Ibinọkpaabyi kw'odik ọm-ọmma ettem. ");
INSERT INTO mfo_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Kaambi ode k'ogbe kwa bọng akk'va abhona, abira akhaama va mmona da bọng akk'arukha m'irerek nna k'ogbe-bhirada, an-asi ọmmaana-tzama asi ọgbatza kpenamkpen, mẹ wọ ode bi bọng akk'itzama asa k'itzitzikha s'Ọvaar Ibinọkpaabyi atzima ajemi idọdọkhi sẹ, ");
INSERT INTO mfo_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","mẹ wọ, kaam ndọk ẹrọng ọmaana irek macha nttẹsẹ kwabọng k'ewu cha mayina, bi bọng ápe ẹbhar-ẹbhar k'irerek nnuma sa bọng ajekha Jọrdan atzọkha. Bọng karuk k'ogbe kw'obhir-obhir m'irerek nna, k'odik-ọkka bọng ápe-ope. ");
INSERT INTO mfo_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Ọvaar Ibinọkpaabyi ọraami bọng k'ottem kw'idibhon, bọng an-arik anọnọnga k'ottem kw'idibhon s'Ọvaar Ibinọkpaabyi ókhubh. ");
INSERT INTO mfo_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Mẹ wọ kwa bọng ákpobha agbatza p'ọnọngẹya otzim echi ọgwa, ttara p'otzim atza ọbanga. Agbatza p'ani iyaan am-are, bẹ k'itzọhng kabhaang, bẹ ọttọhk kàmachi, bẹ ka khung kamabhaanga. ");
INSERT INTO mfo_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Yina, idikha bọng an-attẹwọr mẹ, atzin bi ọbaan bi bọng akpobha Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, bọng akpobh-ẹ ttara ettem obungichẹ ọmaana agbagba pabọng. ");
INSERT INTO mfo_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Ogbe kwa bọng awobh ka damadama da idik nna biphyir ikk'itta ikhebha bọng, k'ekponga-nnam bọng ákpa nnam ọkpa atzor Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, bọng akpobh-ẹ. ");
INSERT INTO mfo_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Da Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ode Ibinọkpaabyi kw'inọngkwo; kẹ bọng ọbọhk kótte, bọng kóbiro ofhu, echekhi ch'osi ttara ab'atte ch'otzim ọnwọhngi osi ẹjaakhi ọnang bẹ k'ọraama. ");
INSERT INTO mfo_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Mosẹs ochina ororo oben anọng p'Israẹl bi, bọng chibhi odik okhuri ọtzamagbe, tzọni kẹ da bọng an-atzim-ammaana, ttẹwọr k'ewu ch'Ibinọkpaabyi oyokhi ọnọngẹya m'ọyagbin; bọng bọbh tzọni k'ittẹwọr s'ọrọngkpakpa ma apyiri k'okpong. Okk'odik ọkhaama kw'otto kw'ọbari mach'odik nwa o, odik obiro owobh kẹ kw'ode manda kw'anọng akk'abhaanga o? ");
INSERT INTO mfo_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Ọkhaam anọng kẹ p'abhaang atzim p'Ibinọkpaabyi oreng k'ekpon ọgbaak, macha bọbọng abhaang, abira aruk akpen o? ");
INSERT INTO mfo_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Ọkha manda vani owobh kẹ fa okk'okhonga bi ọrọbha anọng k'ottem kw'obhon ọdọdọk otzima osi obhon kwẹ, f'oreng ka nyoma, obiro orenga ka ngọhkha, ọmaana ikkokkonidik, ode bi oreng k'egbong, orenga k'odim-bọhk kw'ẹfa, obiro ode bi oreng k'ijoradik s'ideden, s'ide mach'idik s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, osi ọnang anọng p'Ijip sa bọng are ka chen pabọng o? ");
INSERT INTO mfo_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Wa bẹ akhọhk bọng idik nna, ifha ode mẹ bọng aronga bi Ọvaar Ibinọkpaabyi wọ ode Ibinọkpaabyi kw'ode iyọhng; ọdọdọk kw'ọyọhng kẹ kode. ");
INSERT INTO mfo_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Kẹ osi bọng abhaanga ẹmọng chẹ ch'efon k'ọrọngkpakpa, ifha ọnang bọng ndọhna. K'ọyagbin ọkhọhkha bọng abarada p'ekpon chẹ ch'awurada, bọng abhaanga ọwọhng kw'atzim pẹ p'afon k'ekpon. ");
INSERT INTO mfo_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Da kẹ ọkhaam idadaakha ttara ab'atte, kẹ wọ osi otzekha bọbọng va p'abẹ bi bọng ade anọng pẹ, p'otzim k'ẹfa chẹ ch'ideden obina k'Ijip, ");
INSERT INTO mfo_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","okhubh idibhon s'ideden s'igaangi iyọhnga bọng, ifha ọnang bọng irerek sabẹ bọng akhaama, mach'ode ma pyiri mayina. ");
INSERT INTO mfo_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Mẹ wọ bọng nonga mayina abira asi ojima ka nttem sa bọng bi, Ọvaar Ibinọkpaabyi wọ ode Ibinọkpaabyi kw'ẹrọng ọmaana irek, ọdọdọk kẹ kode. ");
INSERT INTO mfo_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Bọng hok aphaangi ọmaana asana pẹ p'akhaam nnangi bọng mayina, ifha ojibh ọnang bọng ttara va pabọng, ifha bọng aruk akpen-okpen m'irerek nnuma, s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ọnang bọng maa, ogbe ode. ");
INSERT INTO mfo_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Mẹ wọ, Mosẹs otzekha idedenmon ittaan s'iwobh k'okhubha kw'ewuchen em-eyin ka Jọrdan ");
INSERT INTO mfo_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","kw'anọng p'arọbhi ebhon, ifha ọnọng kpenamkpen kw'oni oyokhibaanga k'ọgban ofhu, ọfha ọrọbh ochina kẹ bẹ aning-ẹ afhu. Bẹ afha rọbh achina k'obhon wani m'idedenmon nna, ifha bẹ akkaana akpen pabẹ. ");
INSERT INTO mfo_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Wa idedenmon nna ide: Bẹzẹr kw'owobh k'egbegbeho ch'ebherede, kw'ode obhon kw'anọng pa Reubẹn; Ramọt-Gilead ode obhon kw'anọng pa Gad; Golan kw'owobh ka Bashan ode obhon kw'anọng pa Manasẹ. ");
INSERT INTO mfo_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Ma wọ ode ọphaangi kwa Mosẹs oji anọng p'Israẹl k'itzitzikha. ");
INSERT INTO mfo_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Ma wọ ode njina ọmaana asana ttara aphaangi pa Mosẹs ọnangi anọng p'Israẹl bi bẹ ahok mada bẹ abin k'Ijip ");
INSERT INTO mfo_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","da bẹ awobh k'ittolim s'ibaang Bẹt-Pẹọr k'okhubha kw'ewuchen em-eyin ka Jọrdan, k'irerek sa Sihon kw'ode ọvaarnọng kw'Amọr, kw'ọdabhi ẹvaar ka Hẹshbọn, wa Mosẹs ọmaana anọng p'Israẹl akhem-ẹ mada bẹ abin k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Wa Mosẹs ọmaana anọng p'Israẹl atzọkha irerek sẹ ọmaana sa Og kw'wode ọvaarnọng kwa Bashan, p'ade avaar afa p'anọng p'Amọr k'okhubha kw'ewuchen em-eyin ka Jọrdan. ");
INSERT INTO mfo_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Irerek nna ittẹwọr k'obhon kw'Aroer itzima ipyiri k'Arnọn Gorge, ibiri itzima ichina k'Egbegbekho cha Siriọn (kw'ode Hẹrmọn), ");
INSERT INTO mfo_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","ttara Araba biphyir k'okhubha kw'ewuchen em-eyin ka Jọrdan maa, apyiri k'Ọraanga kw'Obo, k'irekhirek kw'igbegbe-wọna sa Pisga. ");
INSERT INTO mfo_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Iwa Mosẹs oyeri anọng p'Israẹl biphyir, oben bẹ bi: Anọng p'Israẹl o, bọng yonga itzọng abhaanga akpebhi ọmaana aphaangi pa kaam nsi ẹjaakhi nnang bọng manyina e. Bọng dọkha ogbe akpebhi bẹ, abira asi macha bọng akpebhi. ");
INSERT INTO mfo_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Iwa Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaman osi echekhi ọnang man ka Horẹb. ");
INSERT INTO mfo_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Abitta paman arang p'iwa Ọvaar Ibinọkpaabyi osi echekhi nda ọnang, iwa osi ọnang maman p'otzima orukhi akpen maa, apyiri ma. ");
INSERT INTO mfo_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Wa Ọvaar Ibinọkpaabyi oreng k'ekpon-ẹwọmachẹ ọgbaak atzim ọmana bọng itzitzikha ttara itzitzikha k'egbegbeho. ");
INSERT INTO mfo_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Mẹ wọ kw'iwa kaam mbe mach'oreng-eden kw'Ọvaar Ibinọkpaabyi ttara kwabọng, okhuri da iwa bọng an-akher avura k'egbegbeho okhuri ojora f'ekpon-ẹwọmachẹ. Wa oben bi: ");
INSERT INTO mfo_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“Kaam wọ nde Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, kw'otzim bọng obina k'Ijip, k'irerek s'ebira. ");
INSERT INTO mfo_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Bọng idik ọdọdọk kàkpobha, kw'oyongi kaam. ");
INSERT INTO mfo_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Bọng ọgbatza kàgwa kw'ókher ọttọhk kpenamkpen f'owobh k'ẹrọng, ode bi fẹ owobh k'irerek, fẹ obiro owobha k'asi ẹtzaanga. ");
INSERT INTO mfo_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Bọng nho kàhakha anang agbatza mba, bọng bẹ kàbira akpobha, okhuri bi, kaam Ọvaar Ibinọkpaabyi, kwa nde Ibinọkpaabyi kwabọng, nde Ibinọkpaabyi kw'ọkhaam ottem-mamma, kw'ọm-ọnang va ọmmọmma k'itzama s'ab'otte maa, apyiri mgbọmma nttaan, ọmaana mgbọmma nna s'anọng p'attaang-m. ");
INSERT INTO mfo_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Yina, kaam mingọhkha idadaakha nnang mgbọmma nnọhna-nnabhik sa ngaam idadaakha ttar-m, mbiri nhok asana paam. ");
INSERT INTO mfo_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“Bọng che ch'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng k'ilulukhi-den kàtzima, okhuri bi, Ọvaar Ibinọkpaabyi kóbina ọnang, ọnọng kw'olukhi che chẹ. ");
INSERT INTO mfo_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“Bọng jima Ẹwọhngkwokhawu, ahok chẹ mach'ewu ch'ewur-owur, mach'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng okk'bọng ọtzọhna. ");
INSERT INTO mfo_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Bọng dima iwu izadani asi itzọhm sabọng biphyir, ");
INSERT INTO mfo_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","yina, ottong iwu izenamfa, ode Ẹwọhngkwokhawu ch'ikpokpobha anang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng. M'ewu nda, ọnọng manda wani ode bọbọng, ode va pabọng p'ijinọng ọmaana p'ipanọng, ode atzọhmnọng pabọng p'ijnọng ọmaana p'ipanọng, ode abhaam pabọng, ode nnyanyaang ttara etzirakpo pyabọng biphyir, obiro ode okhekhennọng kw'orukhi kabọng k'ibhon ọtzọhm kási, ifha atzọhmnọng pabọng p'ijinọng ọmaana p'ipanọng akwokha macha bọbọng akwok. ");
INSERT INTO mfo_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Bọng jima bi, wa bọng ade abira k'Ijip. Wa Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, otzima ọbọhk kwẹ kw'ẹfa otzima bọng obina kẹ. Mẹ wọ ofon, Ọvaar Ibinọkpaabyi ọtzọhn bọng bi, bọng ahok Ẹwọhngkwokhawu nda ch'ikpokpobha. ");
INSERT INTO mfo_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“Bọng kpobha ab'atte, ọmaana ab'akka, ifha bọng aruk akpen p'adum-odum k'irerek s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọ́nang bọng. ");
INSERT INTO mfo_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“Bọng ọnọng kàfhu. ");
INSERT INTO mfo_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","“Bọng ọtta kàtzama ");
INSERT INTO mfo_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“Bọng oribh kàfu ");
INSERT INTO mfo_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","“Bọng nttẹsẹ kw'ibhora kàbe. ");
INSERT INTO mfo_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","“Bọng panọng p'ayok chen kàkkeri, kaambi ihọhm sabẹ rọ, ode irerek, obiro ode atzọhmnọng pabẹ p'ijinọng ọmaana p'ipanọng, ode abhaam pabẹ, ode ẹnyanyaang, kaambi ọttọhk kpenamkpen vọ.” ");
INSERT INTO mfo_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Ma wọ ode asana p'iwa Ọvaar Ibinọkpaabyi oreng k'ekpon, ọmaaana k'eboni, ttara k'ipyerungi s'ipyi bi kaang osi ẹjaakhi k'ẹrọng ọnang anọng p'iwa atzobh k'egbegbeho, wa odik ọdọdọk mẹ kọttar. Iwa ọkkẹr bẹ k'atza-gbẹgbẹri afa, ọnang-m. ");
INSERT INTO mfo_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Mada bọng abhaang ẹmọng ch'eyini k'ipyerungi, da egbegbeho ẹm-ẹwọma ekpon, wa adedennọng biphyir ọmaana adeho pa ngọma sabọng akwu akhebh-m. ");
INSERT INTO mfo_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Bọng aben bi, “Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaman, okk'man abarada pẹ ọmaana ẹvaar chẹ ọkhọhkha. Wa mokk'atzim pẹ p'oreng k'ekpon-ẹwọmachẹ ọgbaak, ọbhaanga. Mayina, mokk'oronga bi ọnọngẹya ọfha ọgbaak atzim ọgbaak ọmaana Ibinọkpaabyi, obiro aruk akpen. ");
INSERT INTO mfo_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Mon-ope okhuri yan? Ekpon-barada nda échi man ochi maa, mópe e, idikha mochin ororo ọbhaanga atzim p'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaman ọgbaakhi. ");
INSERT INTO mfo_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Bọng ọnọngẹya kw'orukhi akpen, wọ ọkk'atzim p'Ibinọkpaabyi oreng k'ekpon ọgbaak obhaanga macha man, obiro oruk akpen o? ");
INSERT INTO mfo_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Mosẹs, kọ rọkhi abaanga kẹ, atza abhaanga idik biphyir s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwaman ọgbaakh e, ifha akpannam akwu agbaak man odik kpenamkpen kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaman ọgbaakh-ọ. Maman óyonga itzọhng oyonga, móbiro ọhakha nho.” ");
INSERT INTO mfo_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Ọvaar Ibinọkpaabyi okk'idik sa bọng agbaakh-m ọbhaanga e. Ọvaar Ibinọkpaabyi oben-m bi, “Kaam nkk'odik kw'anọng mba agbaakh-ọ, mmanga. Odik kpenamkpen kwa bẹ agbaakhi otzori kẹ e. ");
INSERT INTO mfo_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Ira kwẹ ójibh-ojibh bi, bẹ akhaama ojora faam ka nttem sabẹ, bẹ abira ahok asana paam k'ogbe kpenamkpen, ifha idik ijibh inang bẹ, ọmaana va pa va pabẹ maa, ogbe ode! ");
INSERT INTO mfo_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","“Kọ rọhng, atza agbaak bẹ bi, bẹ akpa nnam k'okhira fabẹ. ");
INSERT INTO mfo_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Yina, kọ wobha ma ttara kaam, ifha nnang-ọ asana, ọmaana akpebhi ttara aphaangi pa kọ ákpebhi bi, bẹ ahok, k'irerek sa kaam ńnang bẹ bi bẹ akhaama. ");
INSERT INTO mfo_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Mẹ wọ, bọng dọkha ogbe asi odik kpenamkpen kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, okk'bọng ọtzọhna. Bọng kàttena achina odimbọhk, obiro ode ka kwabọhk. ");
INSERT INTO mfo_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Bọng hakha nho asi idik nna biphyir s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng okk'bọng ọtzọhna, ifha bọng aruk akpen p'ojibhada ọmaana akpen p'adum-eden, k'irerek sa bọng atzọkha mach'ekkema chabọng. ");
INSERT INTO mfo_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Ma wọ ode asana ọmaana akpebhi ttara aphaangi p'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng oben-m bi, mkpebhi bọng ifha bọng ahok bẹ k'irerek sa bọng ajekha Jọrdan, atza atzọkha mach'ekkema chabọng, ");
INSERT INTO mfo_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","ifha bọbọng ọmaana va pabọng ttara va pa va pabọng, akhaama ojora f'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, k'odem nwa kwa bọng achina ororo aruk atzor k'akpebhi ọmaana k'asana pa kaam nnangi bọng, ifha bọng abira afha aruk akpen p'adum-eden. ");
INSERT INTO mfo_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Anọng p'Israẹl o, bọng maanga abira atzọkha ogbe ahok idik nna ifha ode mẹ ojibh ọnang bọng, ọmaana bi bọng abira ahaabh attara-ọttara k'irerek ọkkakka s'abasi ọmaana akhọkhọnana ahaabh-ọhaabh, mach'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kw'ab'atte, ochekhi ọnang bọng. ");
INSERT INTO mfo_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Anọng p'Israẹl o, bọng maanga e, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaman, kẹ-kẹ wọ ode Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Bọng akhaambi Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọdaak bọng ttara nttem obungisẹ, ọmaana agbagba pabọng biphyir ttara ẹfa chabọng biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Bọng hok asana mba pa nnangi bọng mayina, ka nttem sabọng. ");
INSERT INTO mfo_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Bọng akpebhi va pabọng asana mba. Bọng kpebhi bẹ asana k'ogbe kwa bọng awobh k'ihọhm, ọmaana k'ogbe kwa bọng areng ka nden, ọmaana k'ogbe kwa bọng ayim-oyima, ttara k'ogbe kwa bọng aphyọbh. ");
INSERT INTO mfo_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Bọng kpa va pabọng asana mba ka mbọhk mach'ẹkhọhkha, bọng akpaama bẹ k'otzitzikha-ttem fabọng mach'ojima. ");
INSERT INTO mfo_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Bọng kkẹr bẹ ka mkpọmmachi s'ihọhm sabọng, ọmaana ka mbaakhamma sabọng. ");
INSERT INTO mfo_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","K'ogbe kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ótzima bọng opyiri k'irerek s'iwa ochekhi bi ọnang ab'atte Abraham, ọmaana Isaak magbakha Jekọb, bi ọnang bọng irerek s'ibar-ọbar ikhaama ibhon s'ijibh-ojibh s'iwa bọng ana asi, ");
INSERT INTO mfo_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","ọmaana ihọhm sa bọng ani asi, s'ifhu ttara ẹkkọ-kpo k'adem-k'adem, ọmaana nsipe sa bọng ana atzumi, ọmaana iwoni sa vine ọmaana s'oliv sa bọng ana ayaabh. K'ogbe kwa bọng akk'acha adọhbh, ");
INSERT INTO mfo_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","bọng bọkha bọng for, bọng aningi Ọvaar Ibinọkpaabyi araam, kw'otzim bọng obina k'Ijip k'irerek s'ẹmmọri. ");
INSERT INTO mfo_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Bọng gaama ojora f'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, bọng kpobha kẹ-kẹ, bọng abira atzọkha ọnwọhngi ka che chẹ. ");
INSERT INTO mfo_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Bọng ikha kàkpobha, ikha s'anọng p'arukhi akhọri bọng; ");
INSERT INTO mfo_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","da Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng kw'owobh k'ottem kwabọng, ode Ibinọkpaabyi kw'ọkhaam ottem-mamma, kẹ ọ́dọkhi ettem otzima otzor bọng, obiro odimi bọng m'irerek nna. ");
INSERT INTO mfo_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Bọng Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng kàyoma, mach'iwa bọng asi ka Masa. ");
INSERT INTO mfo_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Bọng dọkha ogbe ahok asana, ọmaana ndọhna ttara akpebhi, p'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng okk'bọng ọnanga. ");
INSERT INTO mfo_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Bọng si idik s'itzor-otzor ibiri ijibh-ojibh k'itzitzikha s'Ọvaar Ibinọkpaabyi, ifha ojiibh ọnang bọng, k'odem kwa bọng afha atza atzọkha irerek-jibhada nnuma s'Ọvaar Ibinọkpaabyi ọnwọhngi osi ochekhi bi ọnang ab'atte pabọng, ");
INSERT INTO mfo_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","kẹ ókhubh attattaanganọng pabọng biphyir, k'itzitzikha sabọng macha kẹ Ọvaar Ibinọkpaabyi obeni. ");
INSERT INTO mfo_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Mada va pabọng abọbh bọng k'ogbe ororo bi, “Akpebhi ọmaana asana ttara aphaangi mba p'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaman ọkk'ọ ọnanga ayini yan o?” ");
INSERT INTO mfo_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Bọng gbaak bẹ bi, “Wa mode abira pa Phero kw'ode ọvaarnọng kw'Ijip, yina, wa Ọvaar Ibinọkpaabyi otzima odimbọhk kwẹ kw'ẹfa otzima man obina k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Wa motzima chen paman ore ngọhkha, ọmaana ikkokkoni-dik s'ibar-ọbar ibiri ijor-ojora, sỌvaar Ibinọkpaabyi osi k'Ijip ọmaana k'itzitzikha s'ọvaar Phero, ọmaana ẹhọhmmọr chẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Yina, kẹ otzima man obina k'Ijip, ọtza ọnang man irerek nnuma s'iwa ọnwọhngi ocheckhi bi, ọnang ab'atte paman. ");
INSERT INTO mfo_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Wa Ọvaar Ibinọkpaabyi oben man bi, mohok akpebhi mba biphyir, mobiro ọkhaama ojora f'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaman, ifha idik ijibh inang man, mobiro oruk akpen macha kwẹ ode mayina. ");
INSERT INTO mfo_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Idikha mọtzọk ogbe ohok aphaangi mba biphyir k'itzitzikha s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaman mach'okk'man obena, mẹ wọ óde ejibha chaman.” ");
INSERT INTO mfo_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","K'ogbe kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ótzima bọng odim k'irerek nnuma, kẹ okhubh idibhon khaabhada, kw'ode anọng pa Hit, ọmaana anọng pa Girgash, ọmaana anọng p'Amọr, ọmaana anọng pa Kenan, ọmaana anọng pa Pẹriz, ọmaana anọng pa Hiv, ttara anọng pa Jẹbus, kw'ode idibhon izenamfa s'ibar-ọbar, ibiri ikhaama ẹfa iyọhnga bọng. ");
INSERT INTO mfo_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Idikha Ọvaar Ibinọkpabyi kw'ode Ibinọkpaabyi kwabọng, okk'ibhon nna ọtzọkha okhe bọng ka mbọhk, bọng akhema bẹ, bọng fhu bẹ biphyir. Bọng echekhi kpenamkpen kàsi ọmaana anọng mba, bọng bẹ nkwo kàbira are. ");
INSERT INTO mfo_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Bọng bẹ k'ọbada kàtzọkha, bọng aminava pabọng kàtzọkha anang ajinọng pabẹ k'ọbada, bọng aminava pabẹ kàtzọkha anang ajinọng pabọng k'ọbada, ");
INSERT INTO mfo_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","oni mando ode, bẹ ábhakhi nttem sa va pabọng ọbhakhi, bẹ kaam dọk kakpobha, da bẹ an-akpobha ikha. Mẹ wọ osi, Ọvaar Ibinọkpaabyi ọ́dọkhi ettem ttara bọng, óbiri ódimi bọng ẹbhar-ẹbhar. ");
INSERT INTO mfo_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Ma wọ ode odik kwa bọng ási bẹ: bọng vọhkhi ọja-fọhnibe fabẹ, ọmaana ndur sabẹ, bọng abira avọhkhi mkpọmmachi s'Ashẹra pabẹ. Bọng kwọmi agbatza pabẹ k'ekpon. ");
INSERT INTO mfo_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Da bọng ade anọng p'awur-owur p'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng. Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng okk'bọng otzekha k'ottem kw'anọngẹya m'itzitzikha s'ọyagbin bi, bọng ade anọng pẹ p'ohokhi ettem. ");
INSERT INTO mfo_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Kode bi da iwa bọng ahaabhi ayọhnga idibhon idọdọk wọ osi, yina iwa Ọvaar Ibinọkpaabyi ọkhaama idadaakha ọmaana bọng, obiro otzekha bọng, okhuribi bọbọng bọ akhar ọtzam ayọhnga idibhon biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Yina, wa ofon k'idadakha s'Ọvaar Ibinọkpaabyi ọkhaam ọmaana bọng, ọmaana da iwa obiro ohok echekhi ch'ọkhaam ọmaana ab'atte, wa otzima ọbọhk kwẹ kw'ẹfa obhek bọng k'irerek s'ebira, ka mbọhk sa Phẹro kw'ode ọvaarnọng kw'Ijip. ");
INSERT INTO mfo_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Bọng nonga bi, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, wọ ode Ibinọkpaabyi. Kẹ wọ ode Ibinọkpaabyi kw'oni ottotto ọkhaam, kw'om-ohok ch'echekhi chẹ ch'idadaakha s'ọkhaam maa, opyiri nnọhna mfa obhiri arọbh jobh maa, ayong-oyongi, kw'anọng p'akhaam idadaakha ttara kẹ, bẹ abira ahok asana pẹ. ");
INSERT INTO mfo_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Yina, kẹ odimi anọng p'attaang-ẹ odimi, kẹ ogbe kokhibhi bi, ochora anọng mbuma p'attaang-ẹ. ");
INSERT INTO mfo_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Mẹ wọ osi, bọng dọkha ogbe ahok asana, ọmaana akpebhi, ttara aphaangi pa nnangi bọng, mayina. ");
INSERT INTO mfo_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Idikha bọng átzọhkha ogbe áyonga itzọhng, ahok aphaangi mba, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ohok echekhi ch'idadaakha s'ọkhaam ttara bọng, mach’iwa okk'ochekhi ọnang ab'atte pabọng. ");
INSERT INTO mfo_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Kẹ ọ́khaama idadakha ọ́khaama ọmaana bọng, óbiro ódo bọng, obiro ọttara bọng ọhaabh. Kẹ ódo va pabọng, ọmaana ekpo pya bọng ayaabh mach'abọkpa, ọmaana atzuk abhapẹ ttara ana p'oliv. Ọ́ttara obhik k'abhaam ọmaana k'arukhimaan pabọng, k'irerek s'iwa ochekhi ọnang ab'atte bi, ọnang bọng. ");
INSERT INTO mfo_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Ójibh bọng ọyọhnga idibhon kpenamkpen, ọnọng manda wani k'ottem kwa va pabọng, ode ojinọng obiro ode kwanọng kw'oni nnwa ọkhaama kóde. Otzirattọhk manda vani f'oni ọmaan osi kóde. ");
INSERT INTO mfo_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Ọvaar Ibinọkpaabyi ọkpa ọkhọmana kpenamkpen eden f'ira ọmma bọng. Akhọmana-tzama pa bọng arong k'Ijip, ọbọhk kótte bẹ amma bọng. Yina, kẹ otte ikhọmana nna ọbọhk imma attattaanganọng pabọng. ");
INSERT INTO mfo_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Bọng akhaambi adimi idibhon kpenamkpen s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọtzọkha okhe bọng ka mbọhk. Bọng bẹ nkwo kàre, bọng ikha sabẹ kàbira akpobha, kkeri sẹ íde agbagbara inang bọng. ");
INSERT INTO mfo_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Bọng afha achibhi bi, “Idibhon nna igaangi iyọhnga man, ma yan kwa morenga okhubh sẹ?” ");
INSERT INTO mfo_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Yina, tte anọng p'idibhon aningi bọng ajor; bọng jima odik kw'iwa Ọvaar Ibinọkpaabyi kw'ode Ibinọkpabyi kwabọng, osi Phẹro ọmaana anọng p'Ijip biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Wa bọng akk'chen atzima are nyoma-barada, ọmaana ngọhkha, ọmaana ikkokkonidik, ọmaana ẹfa ch'odimbọhk ch'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, otzim ọkkaana bọng. Mando kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, óbiro ósi anọng mba p'am-ajora bọng. ");
INSERT INTO mfo_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Ayongi mẹ, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọ́tzima abhingiho ofhu bẹ maa, ore bi ayok p'iwa arọbhi bọng achubha, akk'apa. ");
INSERT INTO mfo_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Tte bẹ aningi bọng ajor, kkeri Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, kw'owobh ttara bọng, ode Ibinọkpaabyi kw'ọbar-ọbar, obiro ojor-ojora. ");
INSERT INTO mfo_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ófhumi-etzen ókhubh idibhon nna okhubh ka bọng k'ottem. Bọng ọbọhk k'otte bi, bọng akhubh bẹ eden dani, oni mando ode nkkakkama-tzen ḿmaan k'ohaabh ngọri bọng. ");
INSERT INTO mfo_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Yina, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọtzọkha bẹ ọtzọkha okhe bọng ka mbọhk, ọbhari bẹ ka damadama kw'ideden maa, bọng afhu bẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Kẹ ọ́tzọkha avaarnọng pabẹ okhe bọng ka mbọhk, bọng ábira ádimi che pabẹ m'ọyagbin. Ọnọng kw'ọfha obe bọng abẹ kóde, bọng ádimi bẹ odimi. ");
INSERT INTO mfo_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Bọng kwọmi agbatza p'ikha sabẹ k'ekpon. Bọng asilva ọmaana gol pabẹ katzọkha akhaama, ifha bẹ aningi agbagbara ade anang bọng, da ekpo mbya ekpukhi Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ekpukhi. ");
INSERT INTO mfo_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Bọng agbatza p'ikha nna kàtzima akwu k'ihọhm sabọng. Oni mando ode, bọng an-owobha k'ekhibhi, macha bẹ awobh. Bọng nne pyẹ mach'ekpo pya bọng attaang-ọttaanga, ebere ekpukhi bọng okpukhi, da bẹ akk'pyẹ atzekha ahok k'ekhibhi. ");
INSERT INTO mfo_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Bọng dọkha ogbe ahok ọsana kpenamkpen kwa nnangi bọng mayina, ifha bọng aruk abira ahaabh, abira atza atzọkha irerek s'iwa Ọvaar Ibinọkpaabyi ọnwọhngi ocheckhi bi, ọnang ab'atte. ");
INSERT INTO mfo_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Bọng jima odem kw'iwa Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, otzim bọng eden k'ebherede ka cho arọbh afa, ifha okhoma bọng obiro oyoma bọng, obiro orenga mẹ oronga achibhi pabọng, sa ode na bọng afha ahok asana pẹ. ");
INSERT INTO mfo_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Wa kẹ okhom bọng, otte okwo ọbọhk ọkhaama bọng, ọbhakhi mẹ ọnang bọng ọchattọhk fa bọng ayeri mana, kwa bọbọng ọmaana ab'atte ani arong, ifha bọng aronga bi, ọchattọhk fẹ-fẹ arang ohokhi ọnọng akpen. Yina, akpen p'ọnọng afon k'atzim kpenamkpen p'ayini Ọvaar Ibinọkpaabyi k'ẹmma. ");
INSERT INTO mfo_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Ọbara fa bọng afọr ka for kọtzami, mmo sabọng kimbiri mbir ma cho mba arọbh afa. ");
INSERT INTO mfo_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Bọng nonga ka nttem sabọng bi, odem nwa kw'otte ọm-ọnang nnwa kwẹ ettuma k'ogbe kw'osi odik kw'on-ojibhi, mando kw'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọm-ọnang bọng ettuma, k'ogbe kwa bọng asi odik kw'on-ojibhi. ");
INSERT INTO mfo_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Bọng hok asana p'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, bọng ahakha eho anang-e, abira akhaama ojora fẹ. ");
INSERT INTO mfo_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Da Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng otzima bọng otzima ochina k'irerek nnuma s'ijibh ekpo, ibiri ikhaama araanga, ọmaana akhekhaho ttara ngekha sa ndong-odong sa mobhi ntto ka nttẹri ọmaana ka mgbegbeho; ");
INSERT INTO mfo_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","irerek s'ikhaam wit ọmaana barli, ọmaana vain ọmaana fig, ọmaana pomegranates, ọmaana ana p'oliv ttara akhọkhọnana; ");
INSERT INTO mfo_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","irerek s'ọchattọhk on-owori, ọttọhk kpenamkpen kibiri iwor; irerek s'atzakpa pẹ ade akonga-akonga ibiri ikhaama opo kw'ọnọng ofho otzum ka mgbegbekho. ");
INSERT INTO mfo_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","K'ogbe kw'idik ikk'bọng ijibha, bọng dọhnga Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, k'irerek-jibhada s'okk'bọng ọnanga. ");
INSERT INTO mfo_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Bọng bọkha bọng for, ifha bọng aningi Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng araam o, bọng echuni kakhaama bi, ahok asana pẹ, ọmaana aphaangi pẹ ttara akpebhi pẹ pa kaam nnangi bọng, k'ewu cha mayina. ");
INSERT INTO mfo_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Oni mando ode, bọng akhaama ọchattọhk fa bọng achi obenga bọng, bọng asi ihọhm ikkakka sa bọng aruk, ");
INSERT INTO mfo_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","abhaam pabọng ọmaana arukhimaan pabọng ẹmaan k'ọhaabh, asilva ọmaana gol pabọng abira ahaabh, ekpo biphyir pya bọng akhaam ebire ẹhaabh ẹttar-ọttara, ");
INSERT INTO mfo_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","bọng án-age for bọng araama Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, kw'otzim bọng obina k'Ijip, k'irerek s'iwa bọng awobh k'ẹmmọri. ");
INSERT INTO mfo_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Wa kẹ otzim bọng orenga k'ebherede ch'ẹbarẹkpa ebire ejor-ojora, irerek s'asi anade pa bọng agwo, ibiri ikhaama jọhk p'akkaam-ọkkaam ttara aninang. Wa kẹ ọnangi bọng asi p'afon k'itzakpa s'igaang-ọgaangi. ");
INSERT INTO mfo_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Ọnang bọng ọchattọhk fa bọng ayeri mana bọng achi k'ebherede, ọchattọhk f'iwa ab'atte an-arong, okhoma bọng obiro oyoma bọng, ifha ojibh inang bọng k'ekponga-nnam. ");
INSERT INTO mfo_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Wa osi mando ifha bọng aningi for sabọng abọr bi, “Ojibhada kwaman afon k'ẹfa chaman ọmaana agbọhkhiji paman.” ");
INSERT INTO mfo_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Yina, bọng jima bi, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, wọ ọnangi bọng ẹfa cha bọng atzim asi ikkọ, ifha otzima mẹ osi ẹjaakhi ch'echekhi chẹ, ch'iwa osi ọnang ab'atte, mach'ode mayina. ");
INSERT INTO mfo_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Idikha k'ogbe manda wani bọng akpa nnam abọra Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, bọng an-atzọn ikha abẹ, bọng akpobha sẹ abira achunga nho anang sẹ, kaam nsi ẹjaakhi nnang bọng k'ewu cha mayina bi, k'odik-ọkka ńdimi bọng odimi. ");
INSERT INTO mfo_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Odem nwa kw'iwa Ọvaar Ibinọkpaabyi odimi idibhon, mando kwa bẹ ádimi bọng, idikha bọng ani nho ahak anang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng. ");
INSERT INTO mfo_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Anọng p'Israẹl o, bọng maanga e: bọbọng an-ajekha ọraanga kwa Jọrdan atza atzọkha idibhon s'ibari iyọhnga bọng, ibiri igaangi ọtzam iyọhnga bọng, ttara idedenmon s'ikhaam abaakha pa nchumi sa ngor-ogori. ");
INSERT INTO mfo_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Anọng mba ade anọng p'Anak, bẹ ade anọng p'agaang-ọgaangi, bẹ abira ade anọng-dum! Bọbọng arong bẹ kẹ, bọng abira abhaanga da bẹ abeni bi, “Anyi wọ ọfha obe arima-bọhk ọmaana anọng p'Anakh o?” ");
INSERT INTO mfo_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Yina, bọng nnonga mayina bi, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng wọ, ochi bọng eden ojekha mach'ekpon ch'ọjake. Kẹ ódimi bẹ; kẹ ọ́hakha bẹ ewobha k'itzitzikha sabọng. Bọng ákhubh bẹ abira ádimi bẹ m'ẹbhar-ẹbhar, mach'Ọvaar Ibinọkpaabyi okk'ochekhi ọnang bọng. ");
INSERT INTO mfo_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","K'ogbe kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, okk'bẹ okhubha k'itzitzikha sabọng, bọng for sabọng kàben bi, “Ọvaar Ibinọkpaabyi okk'man otzima okwu ma bi mọtzọkha irerek nna okhuri da osisi kwaman otzor-otzor.” Mma e, kwẹ mando kode, ofon k'itzama s'idibhon nna isi yina Ọvaar Ibinọkpaabyi órenga abẹ okhubh bẹ k'itzitzikha sabọng e. ");
INSERT INTO mfo_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Osisi kwabọng kw'otzor-otzor arang, ẹfa chabọng arang cha bọng atzim atzọkha irerek sabẹ; yina, ofon k'itzama s'idibhon nna isi yina Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng okhubh bẹ k'itzitzikha sabọng, ifha kwẹ ode ẹjaakhi ch'echekhi ch'iwa osi ọnang ab'atte, p'ade Abraham ọmaana Isaak magbakha Jekọb. ");
INSERT INTO mfo_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Mẹ wọ, tte kwẹ ọttaani bọng bi, k'osisi kwabọng kw'otzor-otzor arang kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, oreng ọnang bọng irerek nna s'ijibh-ojibh bi bọng akhaama, okhuribi bọng ade arẹrẹkhi-nọng. ");
INSERT INTO mfo_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Bọng kàraama bi ajima odem kw'iwa bọng ajemi ittem-dọkhiji s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng k'ebherede. Tzọni k'ewu cha bọng abin k'Ijip maa, bọng apyiri ma, bọng am-anang Ọvaar Ibinọkpaabyi irẹrẹkhi. ");
INSERT INTO mfo_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Kaambi k'egbegbeho cha Sinai dọ, wa bọng ajemi ittem-dọkhiji s'Ọvaar Ibinọkpaabyi kw'osi ettem epyibh-ẹ maa, ofhu bọng. ");
INSERT INTO mfo_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Mada kaam mvur k'egbegbeho bi nda ndọkha atza-gbẹgbẹri pa bẹ akkeri atzim p'echekhi ch'Ọvaar Ibinọkpaabyi ọkk'ọsa ọmaana bọng, wa kaam nwobh k'egbegbeho k'iwu arọbh afa, ọmaana nnungiwu arọbh afa; ọchattọhk kinchi asi kimbiri ngwo. ");
INSERT INTO mfo_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọnang-m atza-gbẹgbẹri afa, pa kẹ Ibinọkpaabyi okk'ẹnọhna chẹ otzima ọkkẹr atzim kpenanmkpen, p'okk'orenga k'ekpon-ẹwọmachẹ ọgbaak, k'ogbe kwa bọng atzobh k'egbegbeho. ");
INSERT INTO mfo_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","K'ekponganamwu ch'iwu arọbh afa ọmaana nnungiwu arọbh afa, Ọvaar Ibinọkpaabyi ọnang-m atzakpa afa, p'ade atzakpa p'echekhi. ");
INSERT INTO mfo_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Wa Ọvaar Ibinọkpaabyi oben-m bi, “Bina madẹdẹn ahakha, atza akhebha bẹ okhuri bi, anọng pọ p'atzim abina k'Ijip akk'an-akhibhi. Bẹ akk'nnam akpa abọra ndọhna sa nnangi bẹ, atza aduk agbatza anang for sabẹ.” ");
INSERT INTO mfo_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Ọvaar Ibinọkpaabyi oben-m bi, “Kaam nkk'anọng mba nna, kodik-ọkka bẹ ade anọng pa agaangi eho. ");
INSERT INTO mfo_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Tte-m ọbọhk ifha ndimi bẹ, mbiri mpfuri che chabẹ m'ọyagbin. Mẹ wọ osi kaam ńdima, va pa va pọ nsi ẹkhọma ch'ẹgaang-ọgaangi, ebire ẹkhaama ẹfa ẹyọhnga odem kw'iwa bẹ akhaam.” ");
INSERT INTO mfo_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Mando kwa kaam mfon k'egbegbeho ch'etzim ẹwọm ekpon, nhakha. Wa ndimin-dim gbẹgbẹri mba afa p'echekhi ka mbọhk saam. ");
INSERT INTO mfo_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Mada kaam nkkeri, nne bi bọng akk'ẹkhọngkwuri asa k'itzitzikha s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng; bọng akk'ọgbatza kw'okheri ọbhaamnwa adukha anang for sabọng. Bọng akk'naam akpa abọra ndọhna s'Ọvaar Ibinọkpaabyi okk'bọng ọnanga. ");
INSERT INTO mfo_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Mẹ wọ ofon, kaam mmari gbẹgbẹri mba afa pa ndim ka mbọhk, mvọhkhi bẹ k'abiri-biri m'itzitzikha sabọng. ");
INSERT INTO mfo_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Iwa kaam mbiri ntto ngwubha m'irerek m'itzitzikha s'Ọvaar Ibinọkpaabyi, k'iwu arọbh afa ọmaana ka nungiwu arọbh afa; ọchattọhk manda vani kinchi, asi kimbiri ngwo, okhuri ngọngkwuri biphyir sa bọng akk'asa, k'ibibyadik sa bọng am-asi k'itzitzikha s'Ọvaar Ibinọkpaabyi, atzima ajemi ittem-dọkhiji sẹ. ");
INSERT INTO mfo_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Ittem-dọkhiji ọmaan ottem-pyibha kw'Ọvaar Ibinọkpaabyi akhe kaam ojora. Wa kẹ ọdọkh-ẹ ọmaana bọng maa, ochibhi bi ira odimi bọng, yina, wa Ọvaar Ibinọkpaabyi obiro oyonga itzọhng ọnang-m. ");
INSERT INTO mfo_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Wa Ọvaar Ibinọkpaabyi ọdokh-ẹ ọmaana Aarọn maa, ochibhi bi ira ọfhẹ-ẹ. Yina, wa nzi njọhm m'ogbe nwa k'eho ch'Aarọn. ");
INSERT INTO mfo_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Wa kaam mbiri ndọkha ọkhọngkwuri-ttọhk mvuma fabọng, f'ode ọgbatza nwuma kwa bọng akk'adukha, nkwọm-ẹ k'ekpon. Mvọhkh-ẹ ndọkh-ẹ ngok maa, ọyọhri mach'abubuma. Nna ndọhkha abubuma mba nyaani k'ekhekha ch'ẹttẹwọr k'egbegbekho ebhobh ẹhakha. ");
INSERT INTO mfo_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","Wa bọng abira asi ettem ẹdọkhi Ọvaar Ibinọkpaabyi ka Tabera, ọmaana Masa ttara ka Kibiro-Hatava. ");
INSERT INTO mfo_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Mada Ọvaar Ibinọkpaabyi obeni bọng abina ka Kades-Barnea, obeni bi, “Bọng vura atza atzọkha irerek nnuma s'akhaam nkk'bọng nnanga bi, bọng akhaama.” Yina, bọng asi irẹrẹkhi anang k'ọsana kw'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng. Bọng nnam-ophephe ka kẹ kakhaam, bọng eho kabira ahakha anang-ẹ. ");
INSERT INTO mfo_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Bọng akk'irẹrẹkhi am-asa anang Ọvaar Ibinọkpaabyi, tzọni kẹ da kaam nnong bọng. ");
INSERT INTO mfo_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Kaam ntto nnuri k'itzitzikha s'Ọvaar Ibinọkpaabyi, k'iwu nnuma arọbh afa, ọmaana ka nnungiwu arọbh afa, da Ọvaar Ibinọkpaabyi okk'obena bi, kẹ odimi bọng odimi. ");
INSERT INTO mfo_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","Kaam nzi njọhm nnang Ọvaar Ibinọkpaabyi, mben bi, “O Ọvaar Ibinọkpaabyi kw'Ọyọhng o, anọng pọ kadim e, anọng p'ade ekkema chọ, pa atzim ẹfa chọ ch'ideden abhek, abira atzima ẹfa ch'odimbọhk kwọ atzima bẹ abina k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Kọ jima atzọhmnọng pọ p'ade Abraham ọmaana Isaak ttara Jekọb. Oho-gaangi kw'anọng mba kasaana, itzama sabẹ ọmaana ẹkhọngkwuri chabẹ, kabira asaana e. ");
INSERT INTO mfo_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Oni mando ode, anọng p'ẹkhọma nda ch'atzim man abina áben-oben bi, ‘Okhuri da Ọvaar Ibinọkpaabyi oni bẹ ọfha otzima opyiri k'irerek nnuma s'okk'ochekhi bi ọnang bẹ, ọmaana bi da ọttaang bẹ ọttaanga, kẹ wọ osi otzima bẹ okwu ma bi, okwu ofhu k'ebherede. ");
INSERT INTO mfo_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Yina, anọng mba ade anọng pọ, p'ade ekkema chọ ch'atzim ẹfa chọ ch'ideden ọmaana ẹfa ch'odimbọhk kwọ abina kẹ.” ");
INSERT INTO mfo_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","K'ogbe nwuma, Ọvaar Ibinọkpaabyi oben-m bi, “Rọhng atza akpaara atza-gbegberi afa, p'ade macha p'echeden atzima avura akhebh-m k'egbegbeho. Abira asi ẹkkọhbhi cha mgbaakha. ");
INSERT INTO mfo_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","Kaam ńkkẹr atzim ọkkẹr m'atzagbẹgberi mba, p'iwa nchi eden nkkẹr k'atzagbẹgbẹri mbonggo p'iwa avọhkhi, ifha atzọkha bẹ akhe k'ẹkkọhbhi nda.” ");
INSERT INTO mfo_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Mando kwa kaam ndim echi ch'akasiya nsi ẹkkọhbhi, mbiri mkpaara atza-gbẹgbẹri afa p'ade macha p'echeden, mvura k'egbegbekho ttara atza-gbẹgbẹri mba afa ka mbọhk saam. ");
INSERT INTO mfo_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Wa Ọvaar Ibinọkpaabyi ọkkẹr atzim mbuma bani m'atza-gbẹgbẹri mach'iwa okk'ocheden ọkkẹr. Wa atzim ade Asana Jobh p'iwa ọnangi bọng k'ogbe kw'iwa oreng k'ekpon ọgbaak atzim ọnang bọng k'egbegbeho. Ọvaar Ibinọkpaabyi ọtzọkha bẹ ọnang-m. ");
INSERT INTO mfo_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Mẹ wọ ofon, kaam mfona k'egbegbekho nhakha, ndọkha atza-gbẹgbẹri mba nge k'ẹkkọhbhi cha nkk'nsa, mach'Ọvaar Ibinọkpaabyi oben-m, nhok bẹ mẹ. ");
INSERT INTO mfo_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","(Iwa anọng p'Israẹl asi orenga ttẹwọr ka nsipe sa Bẹnẹ-Jakan maa, apyiri Mosera. Mẹ kw'iwa Aarọn ope bẹ anọhng-ẹ, Eleaza kw'ode nnwa kwẹ ọtzọkha ewobha chẹ mach'ọfọhnẹja. ");
INSERT INTO mfo_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Bẹ attẹwọr mẹ asi orenga maa, apyiri Gudgoda ọmaana Jotbata, kw'ode ibe s'ikhaam ngekha. ");
INSERT INTO mfo_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","K'ogbe nwuma wa Ọvaar Ibinọkpaabyi otzek ẹnọmma cha Levi bi, bẹ ade anọng p'atzini Ẹkkọhbhi ch'Echekhi ch'Ọvaar Ibinọkpaabyi, abe k'itzitzikha s'Ọvaar Ibinọkpaabyi agbaak ẹkkaabha chẹ anang anọng, bẹ abira anang anọng ẹdaa ka che chẹ, macha bẹ atzima asi-osi maa, apyiri mayina. ");
INSERT INTO mfo_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Kẹ wọ osi ẹnọmma cha Levi ekkema kẹkhaam k'ottem kw'ayok-obhon p'Israẹl; Ọvaar Ibinọkpaabyi wọ ode ekkema chabẹ, mach'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ọgbaakhi bẹ.) ");
INSERT INTO mfo_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Ma kaam nkk'nwobha k'egbegbekho k'iwu arọbh afa ọmaana nnungiwu arọbh afa, mach'iwa nsi k'ocheden-gbe, Ọvaar Ibinọkpaabyi obiro ọbhaang-m m'ogbe nwa. Wa ochibhi kwẹ kode bi odimi bọng. ");
INSERT INTO mfo_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Ọvaar Ibinọkpaabyi oben-m bi, “Kọ rọhng, atza atzima anọng mba eden, bẹ adim k'irerek s'iwa nchekhi bi anang ab'otte, ifha bẹ atzọkha sẹ akhaama.” ");
INSERT INTO mfo_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Anọng p'Israẹl o, mbọng f'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng orori ka bọng ka for, oyongi bi bọng akhaama ojora fẹ o, ọmaana bi bọng ahakha eho anang-ẹ, bọng akhaama idadaakha ttar-ẹ, bọng abira akpobha Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ttara ettem obungichẹ ọmaana agbagba pabọng biphyir, ");
INSERT INTO mfo_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","ọmaana bi bọng ahok asana ọmaana akpebhi p'Ọvaar Ibinọkpaabyi pa kaam nnangi bọng mayina, ifha ojibh ọnang bọng. ");
INSERT INTO mfo_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng wọ ọkhaam ẹrọng, kaambi ọrọnkpakpa kw'ogori ọtzam wọ, obiro ọkhaama irerek ttara ọttọhk kpenamkpen f'owobh mẹ. ");
INSERT INTO mfo_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Yina, ab'atte adaakhi Ọvaar Ibinọkpaabyi idik, kẹ ọkhaama idadaakha ttara bẹ, okwu otzekha bọbọng p'ade va pa va pabẹ bi, bọng ade pẹ k'ottem kw'idibhon bi waam macha kwẹ ode mayina. ");
INSERT INTO mfo_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Mẹ wọ, bọng do nttem sabọng, bọng eho dọk kagaangi. ");
INSERT INTO mfo_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Da Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ọbari ọtzam ọyọhnga ikha, obiro ode Ọvaar kw'ọbari ọyọhnga avaar. Kẹ wọ ode Ibinọkpaabyi kw'ideden kw'Ẹfa biphyir, kw'ọban bi anọngẹya biphyir arọbh, kw'oni ọnọng otzek, ngwu kobiro ochi. ");
INSERT INTO mfo_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Kẹ wọ om-orima erima ch'anọng p'ani ob'otte akhaam, ọmaana apopa, obiro ọkhaama idadaakha ttara akhekhennọng p'arukhi ka bọng k'ottem, ọnang bẹ ọchattọhk ọmaana ọbara fa for. ");
INSERT INTO mfo_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Mẹ wọ, bọng gaama idadaakha ttara akhekhennọng p'arukhi ka bọng k'ottem, okhuri bi wa bọbọng abira ade akhekhennọng k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Bọng kpobha Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, bọng abira akhaama ojora fẹ. Bọng abe bi pyir ka kẹ, bọng abira atzọkha ọnwọhngi ka che chẹ. ");
INSERT INTO mfo_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Kẹ wọ kwa bọng anang ẹtzọhnga; kẹ wọ ode Ibinọkpaabyi kwabọng kw'osi ikkokkoni-dik-barada nnuma s'ipe anọng for, sa bọng atzim chen pabọng are. ");
INSERT INTO mfo_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Biphyir-phyir wa ab'atte p'achin k'Ijip ade anọng arọbh attaan obhiri jobh, mayina Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, okk'bọng ọhaabh ọttara macha ndodori s'ọrọngkpakpa. ");
INSERT INTO mfo_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Tte Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ọdaak bọng, bọng ahok ndọhna sẹ, ọmaana akpebhi pẹ, ọmaana aphaangi pẹ, ttara asana pẹ, k'ogbe kpenamkpen. ");
INSERT INTO mfo_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Bọng jima mayina bi, va pa va pabọng arang iwa are abira aronga idik nna, s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng osi; ẹvaar chẹ, ọmaana ẹfa chẹ ch'ideden ttara ẹfa ch'odimbọhk kwẹ; ");
INSERT INTO mfo_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","ngọhkha s'osi ọmaana idik s'osi k'ottem kw'anọng p'Ijip, ọmaana Phero kw'ode ọvaarnọng kw'Ijip ttara ẹkhọma chẹ biphyir; ");
INSERT INTO mfo_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","odem kw'odimi arim-egbong p'Ijip, ọmaana nnyanyaang sabẹ ọmaana akpaar pa nnyanyaang mmindọr, odem kw'otzim asi p'Eraagnakhora ọna bẹ ẹfa k'ogbe kwa bẹ am-akhubh bọng, ọmaana odem kw'Ọvaar Ibinọkpaabyi otte itzama s'idumi eden ọbọhk, itto ikhebha bẹ. ");
INSERT INTO mfo_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","Va pabọng arang iwa are idik nna s'osi ọnang bọng k'ebherede maa, bọng apyiri m'ibe nna, ");
INSERT INTO mfo_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","ọmaana idik s'osi Dathan ọmaana Abiram p'ade va p'Ẹliyab, kw'ofon k'ẹkhọma cha Reubẹn, k'ogbe kw'irerek igwong ẹmma k'ottem kw'anọng p'Israẹl biphyir immyi bẹ ttara nhọhmmọr sabẹ, ọmaana okhira fabẹ ttara ọttọhk kpenamkpen f'ode fabẹ. ");
INSERT INTO mfo_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Yina, bọbọng ọkhaam bọ ade anọng p'iwa are idik-barada nna biphyir, s'Ọvaar Ibinọkpaabyi ọkk'ọsa. ");
INSERT INTO mfo_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Mẹ wọ, bọng hok asana mba biphyir p'akhaam nnangi bọng mayina, ifha bọng afha akhaama ẹfa cha bọng atza atzọkha irerek nnuma s'iwobh ka Jọrdan okhuba akhaama, ");
INSERT INTO mfo_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","ttara bi bọng afha aruk akpen p'adum-odum k'irerek nna, s'Ọvaar Ibinọkpaabyi ochekhi bi ọnang ab'atte ọmaana va pa va pabẹ, irerek ọkkakka s'ifu ttara abasi ọmaana akhọkhọnana. ");
INSERT INTO mfo_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Irerek nna sa bọng am-aben bi adim atza atzọkha ma, k'ide mach'irerek s'Ijip kẹ da bọng afon, kẹ da iwa bọng atzim agbọhkhiji ayaabh ekpo, abira aphaakhi agbaari atzima anang pyẹ asi. ");
INSERT INTO mfo_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","Yina, irerek nna sa bọng am-ajekha Jọrdan bi atza atzọkha ma, ide ẹkhọma ch'ẹkhaam mgbegbeho sa ngor-ogori ọmaana ottolim f'ober arọng-si. ");
INSERT INTO mfo_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","Sẹ ide irerek s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng okkeri; k'ittẹwọr sa cho maa, atza apyiri k'okpong, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ochin ororo okkeri sẹ. ");
INSERT INTO mfo_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Mẹ wọ e, idikha bọng atzọk ogbe ahakha eho anang asana mba pa kaam minnangi bọng mayina, bọng akhaama idadaakha ttara Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, bọng abira akpobh-ẹ ọmaana nttem sabọng ttara agbagba pabọng biphyir, ");
INSERT INTO mfo_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","mẹ wọ kwa kaam ntte ẹrọng ọbọhk etzebh k'irerek sabọng k'ogbe kwẹ, kw'ode echeden-nọng ọmaana ekponganm-nọng, ifha bọng apha ọchattọhk ọmaana atzuk abhapẹ, ttara ana p'oliv. ");
INSERT INTO mfo_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","Kaam ńsi araraari amen k'iwoni, ifha abhaam pabọng achi, bọbọng abira achi maa, adọhbh. ");
INSERT INTO mfo_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Bọng bọhkha bọng for, oni mando ode, bẹ ábọhra bọng ọbọhra bi, bọng akpobha ekpo ẹdọdọk, bọng abira ahakha nho anang pyẹ. ");
INSERT INTO mfo_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Mẹ wọ osi, Ọvaar Ibinọkpaabyi ọ́dọkhi ettem otzima otzor bọng, kẹ ọ́kpa amma p'ọrọngkpakpa ifha ẹrọng eningi etzebhi, irerek iningi ọttọhk manda vani ibiri imen, bọng ábira adimi m'irerek ọkkakka nna s'Ọvaar Ibinọkpaabyi ọnangi bọng. ");
INSERT INTO mfo_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Bọng dọkha atzim mba paam akhe ka nttem sabọng ọmaana k'achibhi pabọng; bọng kpa atzim mba ka mbọhk sabọng mach'ẹkhọhkha, ọmaana k'otzitzikha-ttem fabọng. ");
INSERT INTO mfo_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Bọng kpebhi va pabọng atzim mba, bọng kpebhi bẹ k'ogbe kwa bọng awobh k'ihọhm, ọmaana k'ogbe kwa bọng areng k'eden, ọmaana ogbe kwa bọng an-ayim-oyima ttara k'ogbe kwa bọng aphyọbh. ");
INSERT INTO mfo_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Bọng kkẹr bẹ ka mkpọmmachi s'ihọhm sabọng, ọmaana ka mbaakhamma sabọng, ");
INSERT INTO mfo_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","ifha bọbọng ọmaana va pabọng aruk akpen p'adum-odum m'irerek nna, s'iwa Ọvaar Ibinọkpaabyi ochekhi bi ọnang ab'atte, atzor k'iwu s'ọrọngkpakpa ogori ọyọhnga irerek. ");
INSERT INTO mfo_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Bọng dọkha ogbe ahok asana mba pa minnang bọng bi, bọng ahok bi, bọng akhaama idadaakha ttara Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, bọng ahakha nho anang-ẹ, bọng abira abọkh-ẹ atzima. ");
INSERT INTO mfo_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","Mẹ wọ osi, Ọvaar Ibinọkpaabyi ókhubh idibhon biphyir k'itzitzikha sabọng, bọng ábira átzọkha idibhon s'ibari ibiri igaangi iyọhnga bọng, akhaama. ");
INSERT INTO mfo_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Ibe kpenamkpen nna sa bọng abari mmo, íde sabọng: enem chabọng ẹttẹwọr k'ebherede maa, etza epyiri ka Lebanọn, etzima mẹ maa, etza epyiri k'Ọraanga kw'Euphrates, etzima etza etto k'Ọraanga kw'ideden kwa Mẹditeraniya. ");
INSERT INTO mfo_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ókhe anọng p'obhon nwa k'ojora f'ideden k'ibe kpenamkpen sa bọng achin, mach'ochekhi ọnang bọng. Ọnọng kw'ófha obe bọng abẹ kóde. ");
INSERT INTO mfo_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Bọng kker e, kaam nji bọng ẹdaa ọmaana ẹmma ọnanang k'itzitzikha, k'ewu cha mayina. ");
INSERT INTO mfo_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Ode ẹdaa, idikha bọng ahak nho anang k'asana mba p'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, pa kaam nnangi bọng k'ewu cha mayina; ");
INSERT INTO mfo_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","ode ẹmma ọnanang ọnang bọng, idikha bọng ani eho ahak, bọng an-akpa nnam abọra asana p'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, pa kaam ndọhni bọng mayina, bọng atza akpobha ikha sa bọng anarong. ");
INSERT INTO mfo_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","K'ogbe kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, okk'bọng otzima opyiri k'irerek nnuma s'obeni bi, bọng atza atzọkha akhaam, bọng si ẹjaakhi ch'ẹdaa k'Egbegbeho cha Gerizim, bọng asi ẹjaakhi ch'ẹmma ọnanang k'Egbegbeho ch'Ebal. ");
INSERT INTO mfo_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Macha bọng arorong, mgbegbeho nna nwobh ka Jọrdan okhubha, da achin k'okhubha kw'ẹchọhkha-kpikhira kẹ da ewuchen em-edimi, ọbaanga nchi sa ndeden sa More, k'ẹkhọma ch'anọng pa Kenaan p'arukhi k'Araba, k'okhubha kwa Gilgal. ");
INSERT INTO mfo_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Bọng an-ajekha ka Jọrdan okhubha atza atzọkha irerek nnuma s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, ọnangi bọng. Idikha bọng akk'sẹ atzọkha, bọng abira aruk mẹ, ");
INSERT INTO mfo_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","bọng jima bi, bọng ahok akpebhi ọmaana aphaangi mba pa nji bọng k'itzitzikha, mayina o. ");
INSERT INTO mfo_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Ma wọ ode akpebhi ọmaana aphaangi pa bọng akhaambi ahok m'irerek nnuma, s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kw'ab'atte, okk'bọng ọnanga odem nwa kwa bọng achin ororo aruk k'irerek nna. ");
INSERT INTO mfo_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Bọng vọhkhi akhapa p'anọng mba biphyir-phyir, p'anọng mba am-awobha ka mgbegbekho sa ngor-ogori, ọmaana ka mgbegbekho sa ndẹri-ọtzẹri ttara k'ochi-gbagba kpenamkpen, kw'idibhon nna sa bọng akhubhi im-iwobha ikpobha ikha sabẹ. ");
INSERT INTO mfo_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Bọng vọhkhi okpokpobhabe fabẹ, bọng avọhkhi ndur sabẹ, bọng abira akwọmi mkpọmmachi s'Ashẹra pabẹ; bọng avọhkhi agbatza p'ikha sabẹ, bọng apfuri che pabẹ, m'obe mvuma. ");
INSERT INTO mfo_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Bọng kakhaambi akpobha Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, mach'idibhon nna im-ikpobha ikha sabẹ. ");
INSERT INTO mfo_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Yina, bọng akhaambi achina k'ibe s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ótzekha k'ottem kwa ngọma sabọng biphyir, s'ide irukhabe sa che chẹ. K'ibe nnuma rọ sa bọng akhaambi achina; ");
INSERT INTO mfo_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","k'ẹnya wọ kwa bọng atzima nnanga nkwọmisẹ atza, ọmaana njafọhni sabọng, sa nde wani k'ekpo jobh pya bọng akhaam, ọmaana nnanga ndọdọk sa bọng atzek ahok ngọmi, nnanga sa bọng akk'achekhi bi anang, ọmaana nnanga s'ifon k'achibhi pabọng, ọmaana acheden va p'abhaam pabọng ttara p'etzirakpo pyabọng. ");
INSERT INTO mfo_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","M'itzitzikha s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng rọ, sa bọng atzima nhọhmmọr sabọng áchi ọchattọhk mva, ettem ebire ẹdaam bọng k'ọttọhk kpenamkpen fa bọng akk'asa, da Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, okk'bọng ọda. ");
INSERT INTO mfo_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Bọng idik kàsi macha mom-osi ma mayina, bi ọnọng-ọnọng om-osi mach'ọdaakh-ẹ, ");
INSERT INTO mfo_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","da bọng ani k'ibe s'ẹwọhngkwokha atzima apyiri s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọnangi bọng, mach'ekkema chabọng. ");
INSERT INTO mfo_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Bọng ájekha Jọrdan atza aruk k'irerek nnuma, s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọnangi bọng mach'ekkema chabọng. Kẹ óbiro ọ́baabha bọng ọbaabha, k'ottem kw'attattaanganọng biphyir p'akhọri bọng ọkhọri, ifha bọng aruk k'odidiri. ");
INSERT INTO mfo_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","Ibe s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ótzekha bi bọng awobha akpobha che chẹ rọ, sa bọng átzima nnanga sabọng s'ọttọhk kpenamkpen fa dọhni bọng akwu: macha nnanga nkwọmisẹ, ọmaana njafọhni, ọmaana ẹnanga ch'ọttọhk vani k'ekpo jobh, ọmaana nnanga sa mbari bọng odik, ttara nnanga nkkakka biphyir sa bọng akk'achekhi, anang Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Bọng si ọdadaami m'ibe nna, kwa bọng atzima va pabọng p'ijinọng ọmaana p'ipanọng, ttara atzọhmnọng pabọng p'ijinọng ọmaana p'ipanọng, ttara abaLevi p'ibhon sabọng, p'ani ekkema ch'ede chabẹ akhaam. ");
INSERT INTO mfo_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Bọng bọkha bọng for, ifha bọng aningi njafọhni nkwọmisẹ sabọng k'ibe kpenamkpen s'idaakhi bọng asi. ");
INSERT INTO mfo_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","Ibe obungisẹ sa bọng awobha asi nnanga nna biphyir sa ndọhni bọng, ide ibe s'Ọvaar Ibinọkpaabyi ótzekha k'ẹkhọma dani chabọng. ");
INSERT INTO mfo_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Ayongi mẹ, bọng afha afhu etzirakpo pyabọng k'obhon kpenamkpen kw'ode ibhon sabọng, bọng achi nden nnuma maa, sẹ mbenga bọng, ode otzenwuri obiro ode bi ochimi wọ, atzor k'odem kw'ẹdaa ch'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọnangi bọng. Kaambi anọng p'an-awuri atzor k'immaanadik ttara anọng p'awur-owur bọ, afha achi nden nna. ");
INSERT INTO mfo_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Yina, bọng izi sa nden nna kàchi; bọng byengi sẹ k'irek mach'asi. ");
INSERT INTO mfo_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","K'ibhon sabọng, bọng ọttọhk vani f'ofon k'ekpo jobh k'ẹchakpo pya bọng kàchi, ọmaana k'atzuk abhapẹ ttara ana p'olive, obiro ode achedenva p'abhaam pabọng ọmaana etzirakpo pyabọng, obiro ode ọttọhk kpenamkpen fa bọng akk'achekhi bi anang, obiro ode nnanga s'ifon k'ochibhi kwabọng ttara nnanga sa bọng atzek-otzekha ahok. ");
INSERT INTO mfo_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Bọbọng ọmaana va pabọng ọmaana atzọhmnọng pabọng ttara aLevi p'arukhi kabọng k'ibhon, bọ achi nnanga nna k'itzitzikha s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, k'ikpokpobhabe nnuma rani s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng otzek. Mẹ wọ kw'ettem ẹdaam bọng k'odik kpenamkpen kwa bọng akk'asa. ");
INSERT INTO mfo_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Odem nwa kwa bọng achin ororo aruk m'irerek nna sabọng, bọng aLevi karaama. ");
INSERT INTO mfo_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","K'ogbe kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng okk'enem chabọng ọmmẹmma mach'ochekhi ọnang bọng, bọng afhu nden aben bi, “Odaakhi man bi mochi etzen,” mẹ wọ, bọng afha achi sẹ ma sẹ mbenga bọng. ");
INSERT INTO mfo_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Idikha ibe s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng otzek ọnang che chẹ ibhiri eden kpọhng k'ibe sa bọng arukhi, bọng afha afhu nden k'abhaam ọmaana arukhimaan pabọng, p'Ọvaar Ibinọkpaabyi okk'bọng ọnanga, mach'nkk'bọng ndọhna, mẹ wọ bọng afha achi sẹ ka bọng k'ibhon ma sẹ mbenga bọng. ");
INSERT INTO mfo_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Bọng chi sẹ mach'ọdaakhi bọng, ode otzenwuri obiro ode ochimi. Kaambi anọng p'an-awuri atzor k'immaanadik ttara anọng p'awur-owur bọ, afha achi nden nna. ");
INSERT INTO mfo_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Yina, bọng izi sa nden nna kàchi; okhuribi izi rọ ide akpen, mẹ wọ bọng kakhaambi achi etzen ttara akpen pẹ. ");
INSERT INTO mfo_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Bọng izi sa nden nna kàchi; bọng byengi sẹ k'irerek mach'asi. ");
INSERT INTO mfo_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Bọng sẹ kàchi, ifha ode mẹ ojibh ọnang bọng ttara va pabọng p'ákwu k'ogbe ororo, okhuri bi kwẹ wọ ode odik kw'otzor-otzor kwa bọng ási k'itzitzikha s'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Yina, bọng dọkha ekpo kpenamkpen pya bọng akk'atzekha, ọmaana ọttọhk kpenamkpen fa bọng akk'echekhi asa bi anang, atzima achina k'ibe s'Ọvaar Ibinọkpaabyi ótzekha. ");
INSERT INTO mfo_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","Bọng nang nnanga nkwọmisẹ sabọng k'ijafọhnibe s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, sa nde etzen ọmaana izi sẹ. Bọng akhaambi abyengi izi sa njafọhni sabọng k'ẹbhabhaanga ch'ijafọhnibe s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, yina, bọng afha achi nden nna ochi. ");
INSERT INTO mfo_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Bọng dọkha ogbe ahok asana mba biphyir pa nnangi bọng, ifha ode mẹ idik ichina ororo ijibh inang bọng ttara va pabọng p'ákwu k'ogbe ororo, mando wọ óde bi bọng asi odik kw'ojibh-ojibh obiro otzor-otzor k'itzitzikha s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng. ");
INSERT INTO mfo_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng wọ ókhubh idibhon sa bọng abeni bi atza arima abẹ k'itzitzikha sabọng, bọng atzọkha irerek sabẹ. Yina, mada bọng akk'bẹ akhubha abira atzọkha irerek sabẹ, ");
INSERT INTO mfo_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","ttara bi k'ogbe kwa bẹ akk'bẹ adimi k'itzitzikha sabọng, bọng kkeri bọng for o, ifha bọng aningi atto k'agbagbara pabẹ bi bọng atza adọhn odik okhuri ikha sabẹ abọbh bi, “Yan wọ kw'idibhon nna im-ikpobha ikha sabẹ e? Ifha maman obiro ọtzọn bẹ abe, osi macha bẹ am-asi. ");
INSERT INTO mfo_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Bọng kakhaambi akpobha Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, mach'anọng mba am-akpobha ikha sabẹ, okhuribi odem kwa bẹ am-akpobha ikha sabẹ, bẹ am-asi adik-ttama kpenamkpen p'ani Ọvaar Ibinọkpaabyi adaakhi, bẹ am-akwọmi va pabẹ p'ijinọng ọmaana p'ipanọng k'ekpon atzima asi njafọhni anang ikha sabẹ. ");
INSERT INTO mfo_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","Bọng dọkha ogbe asi odik kpenamkpen kwa ndọhni bọng; bọng odik m'idik nna kàttara, bọng odik m'idik nna kàbira arọbha. ");
INSERT INTO mfo_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","Idikha ọsẹjaakhi kw'idik, obiro ode ọsẹjaakhi f'ọdachen m'ottem kwabọng, obin osi ẹjaakhi ch'ẹkhọhkha, obiro ode ẹjaakhi ch'okkokkoni-dik, ");
INSERT INTO mfo_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","kwẹ ode bi, ẹjaakhi nda ch'ẹkhọhkha ọmaana ch'okkokkoni-dik ede mach'ọsẹjaakhi ọgbaakhi, oben bi, “Tte mọtzọn ekpo ẹdọdọk abẹ,” (kw'ode ikha sa bọng an-arong), ");
INSERT INTO mfo_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","bọng itzọhng kàyonga anang m'atzim mba p'ọsẹjaakhi-dema nwa, obiro ode ọsẹjaakhi f'ọdachen. Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, wọ om-oyoma bọng mẹ, ifha ore sa kẹ ọdaakhi bọng kẹ, ka nttem sabọng ọmaana k'agbagba pabọng biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng wọ, kwa bọng akpobha, kẹ-kẹ wọ kwa bọng akhaambi arọbh. Bọng ahok asana pẹ, bọng abira ahakha nho anang-ẹ; bọng akpobh-ẹ abira abọkh-ẹ atzima. ");
INSERT INTO mfo_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","Bẹ akhaambi afhu ọsẹjaakhi nwuma, obiro ode ọsẹjaakhi f'ọdachen, k'irẹrẹkhi s'ọchọhm anọng otzima otzor Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, kw'otzim bọng obina k'Ijip obiro obhek bọng k'irerek s'ebira. Ọsẹjaakhi nwa obiro ode ọsẹjaakhi f'ọdachen, okhong bi osi bọng akpa nnam abọra ndọhna s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ọnangi bọng bi, bọng ahok. Bọng akhaambi arọbha ebibya kabọng k'ottem abhari. ");
INSERT INTO mfo_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","Idikha agbaanakka, ode nnwa kwọ kw'ijinọng obiro ode kw'ikwanọng, ode kwanọng kwọ kw'ọdaakh-ọdaak, ode oyokh-ẹkhaan kwọ kw'ettem wọ oben bi ọbọhr-ọ k'idaffa, ọben bi, “Tte mọtza okpobha ekpo ẹdọdọk” (kw'ode ikha sa kọ obiro ode ab'atte an-arong, ");
INSERT INTO mfo_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","ikha s'anọng p'arukhi akhọri bọng, ode bi bẹ abaang bọng ode bi bẹ arukhi k'odenmir, tzọni k'ittẹwọr s'obhon nwa maa, apyiri k'okpong), ");
INSERT INTO mfo_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","bọng k'atzim pabẹ kàkhera, bọng bẹ itzọhng kàbira ayonga. Bọng nkwosisi kàkhaama ttara bẹ, bọng bẹ k'ottem kwabọng kàhok. ");
INSERT INTO mfo_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","Bọng akhaambi afhu bẹ. Bọng de achedennọng p'atzima mbohk sabọng afhu bẹ, yina mbọhk s'anọng mbonggo biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Bọng dọbh bẹ atza maa, bẹ ape, okhuri da bẹ akhong bi asi bọng akpa nnam abọra Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, kw'otzim bọng obina k'Ijip, k'irerek s'ẹmmọri. ");
INSERT INTO mfo_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","Mẹ wọ, anọng p'Israẹl biphyir ábhaanga kwẹ ojora osi bẹ, ọnọng manda wani k'ottem kwabọng kw'óbiro osi ọkhọhngkwuri-dik dema nwa kode. ");
INSERT INTO mfo_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","Idikha bọng abhaang odik okhuri ibhon rani s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwbọng okk'bọng ọnanga bi bọng aruk ");
INSERT INTO mfo_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","bi akhọkhọhra bani akk'bina k'ottem kwabọng, bẹ akk'anọng p'arukhi k'obhon kwabẹ atzima attena eden, aben bi, “Tte mofona otza okpobha ikha” (ikha sa bọng an-arong), ");
INSERT INTO mfo_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","bọng akhaambi abọbh, bọng aronga kwẹ, abira ado kwẹ adọhn. Idikha odik nwa ode odik-ọkka, da bẹ akk'kwẹ arora are bi, bẹ akk'obibya-dik asa kottem kwabọbọng, ");
INSERT INTO mfo_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","bọng akhaambi atzima ọkkangkkaang afhu anọng biphyir, p'arukhi m'obhon nwa. Bọng akhaambi adimi obhon nwa biphyir-phyir, bọng dimi anọngẹya omaana etzirakpo py'obhon nwa. ");
INSERT INTO mfo_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","Bọng akhaambi atzobha ọgbọm kpenamkpen fa bọng achi k'ottem kw'ipha s'obhon, bọng akwọmi obhon nwa biphyir-phyir ọmaana ọgbọm biphyir fa bọng achi, mach'ẹnanga ẹkwọmichẹ anang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng. Obhon nwa on-ode ahọhm-gbigbini maa, ogbe ode, bẹ khẹ dọk kábira asi. ");
INSERT INTO mfo_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","Tte ọttọhk manda vani f'ofon m'ekpo mbya pya bẹ akhibhi, oningi ka mbọhk sabọng ode. Mẹ wọ osi, Ọvaar Ibinọkpaabyi ọ́kpa nnam ọbọra idọdọkhi-barada sẹ, ón-ore bọng nkwo, óbiro ọkhaama nkwosisi ttara bọng. Kẹ ọ́ttara bọng ọhaabh, mach'iwa ọnwọhngi ochekhi ọnang ab'atte, ");
INSERT INTO mfo_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","okhuri da bọng ahak nho anang Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ahok asana pẹ biphyir pa kaam nnangi bọng mayina, da bọng asi idik s'itzor-otzor k'itzitzikha sẹ. ");
INSERT INTO mfo_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","Bọng ade va p'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng. Bọng for sabọng abhaak kàbhir, bọng nho s'anọng ape bọng, kàgba, kaambi isisaa s'itzitzikha rọ, ");
INSERT INTO mfo_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","okhuri bi bọng ade anọng p'awur-owur anang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng. Ọvaar Ibinọkpaabyi okk'bọng otzekha k'ottem kw'idibhon s'ọyagbin bi wam bi, bọng ade anọng p'ohokhi ettem. ");
INSERT INTO mfo_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","Bọng ọttọhk kpenamkpen f'Ọvaar Ibinọkpaabyi ọkk'ọsaana ọkha kàchi. ");
INSERT INTO mfo_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","Ma wọ ode nden sa bọng afha achi: ẹbhaam ọmaana orukhimaan ọmaana evu, ");
INSERT INTO mfo_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","omaana ochimi-bina ọmaana otzen-wuri, ọmaana ochimi-khora ọmaana ettubha ọmaana ejibh. ");
INSERT INTO mfo_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","Bọng afha achi etzen kpenamkpen ch'ẹtzọkhi chẹ ẹbhaangi k'obe ọfa ọmaana ch'ẹm-ẹbhọbha ọchattọhk k'ibem. ");
INSERT INTO mfo_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","Yina, nden nnuma sa mmọbh ọchattọhk k'ibem, obiro ode nnuma s'ẹtzọkhi ẹbhaangi k'obe ọfa, bọng sẹ kàchi. Bọng akamẹl kàchi, ode ẹfha obiro ode akwubh. Kaambi ode bi sẹ mminchi ekpo pya sẹ mmọbh k'ibem, sẹ ndọkhi s'mmaang-ọbhaangi kingaam; atzori k'immaana-dik, sẹ kimbaan bi bọng achi. ");
INSERT INTO mfo_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","Akwubh ode etzen ch'ẹn-ẹbaan bi bọng achi; kaambi ọkhaam ẹtzọkhi ch'ẹbhaangi k'obe ọfa, ọttọhk k'ibem kọbhọbh f'ọtzaakhi. Bọng kakhaambi achi etzen chẹ, yina ira bọng an-attọhmi akhọbhi pẹ ọttọhmi. ");
INSERT INTO mfo_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","On-ode nden biphyir sa nwobh k'asi, bọng afha achi nnuma sa ngaam mkpakpa ttara oger kwa nnam. ");
INSERT INTO mfo_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","Yina, kpenamkpen ch'eni mkpakpa ọmaana oger kwa nnam ekhaam, chẹ kẹbaan bi bọng achi. ");
INSERT INTO mfo_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","Bọng afha achi inọhn kpenamkpen s'iwur-owur. ");
INSERT INTO mfo_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","Yina, fa bọng án-achi ode; ikyenọhn ọmaana ọttẹrẹ ttara ọttẹrẹ-bina, ");
INSERT INTO mfo_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","ọmaan ebem-gora ọmaana ebem-bina ọmaana inọhn kpenamkpen s'iwobh m'ẹkhaan nduma, ");
INSERT INTO mfo_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","ọmaana ẹtzọrikhukhu kpenamkpen, ");
INSERT INTO mfo_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","ọmaana ẹgbaafhu ch'ẹkhaam abhik, ọmaana ẹgbaafhu ch'ekhum itzọhng, ọmaana ọgọhng, ọmaana akpabhaang kpenamkpen, ");
INSERT INTO mfo_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","ọmaana ẹgbaafhu ch'ẹkhar-ọkhara, ọmaana ẹgbaafhu ch'ideden, ẹgbaafhu ch'ewur-owur, ");
INSERT INTO mfo_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","ọmaana ẹgbaafhu ch'ebherede, ọmaana ọttẹrẹ binna, ọmaana isinọhn, ");
INSERT INTO mfo_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","ọgọhng ọmaana isinọhn kpenamkpen ọmaana ọgẹr ttara ọgbangbang. ");
INSERT INTO mfo_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","Ekyikyirikpo biphyir py'emeni mbabaang ke ewuri ẹnang bọng, bọng pyẹ kàchi. ");
INSERT INTO mfo_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","Yina, bọng afha achi okyikyiri-ttọhk kpenamkpen f'omeni mbabaang obiro owur-owur. ");
INSERT INTO mfo_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","Bọng ọttọhk kpenamkpen f'orengmmo ope kàchi. Bọng afha atzọkha fẹ anang okhekhennọng kpenamkpen kw'orukhi kabọng k'ibhon bi bẹ achi, ayongi mẹ bọng afha akpe fẹ anang okhekhennọng ọdọdọk. Yina, bọbọng ade anọng p'awur-owur p'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng. Bọng ovu-nnwa kw'otzim ọjaabh ẹba kàwọhn achi. ");
INSERT INTO mfo_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","Bọng jima bi ahok ọttọhk vani ngọmi, k'ekpo jobh py'efon k'iwoni biphyir sa bọng asi aphaa ka cho. ");
INSERT INTO mfo_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","Bọng chi ọttọhk vani f'ofon k'ekpo jobh py'ẹchakpo pyabọng, py'ede azuk abhapẹ ọmaana ana p'oliv, ọmaana acheden p'arukhimaan ọmaana etzirakpo pyabọng k'itzitzikha s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, k'ibe s'íde mach'irukhabe s'otzek ọnang che chẹ, ifha ode mẹ bọng akpebhi eden cha bọng anang Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ikpokpobha k'ogbe kpenamkpen. ");
INSERT INTO mfo_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","Yina, idikha ibe nnuma ibhiri eden kpọhng, bi bọng atzọkha ọttọhk vani k'ekpo jobh mbya, da ẹdaa ch'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ọnangi bọng ẹbari kpọhng bi bọng atzọkha, ");
INSERT INTO mfo_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","mẹ wọ, bọng si obhona kw'ekpo jobh mbya atzọkha silva, bọng atzọkha silva nwa atzima achina k'ibe s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ótzekha. ");
INSERT INTO mfo_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","Bọng dima silva nwuma adebh ọttọhk kpenamkpen f'ọdaakhi bọng macha ẹbhaam ọmaana orukhimaan ode azuk obiro ode abhinga-zuk o, bọng debh ọttọhk kpenamkpen f'ọdaakh-ọ bọng. Mẹ wọ, bọng dima nhọhmmọr sabọng achi pyẹ ttara ọdadaami k'itzitzikha s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng. ");
INSERT INTO mfo_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","Bọng anọng p'ẹkhọma cha Levi p'arukhi kabọng k'ibhon nnam-annam kàhok, da bẹ-bẹ ani ekkema ch'ede chabẹ akhaam. ");
INSERT INTO mfo_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","K'okpong kpenamkpen kwa cho attaan, bọng dima wani k'ekpo jobh pyabọng ma cho nwuma, atzima akwu ahok k'ọkhaanga-họhm kpenamkpen k'ibhon sabọng, ");
INSERT INTO mfo_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","ifha ode mẹ, anọng p'ẹkhọma cha Levi (pani ekkema akhaam ch'ede chabẹ) ọmaana akhekhennọng ọmaana anọng pani otte dọk akhaam ttara panọng p'adim pabẹ akkapa p'arukhi k'ibhon sabọng, bẹ afha akwu achi maa, obenga bẹ, ifha ode mẹ Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ofho odo bọng k'itzọhm-bọhk kpenamkpen sa bọng asi. ");
INSERT INTO mfo_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","K'okpong kwa cho atzenamfa kpenamkpen, bọng akhaambi atte ibhori sa bọng atzim ayok ọbọhk. ");
INSERT INTO mfo_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","Odem kwa bọng asi odik nwa ode bi: Ọnọng kpenamkpen ọkhaambi otte obhori kw'oyok-ọmmaana kw'Israẹl otzim-ẹ, ọbọhk. Bọng kakhaambi abọbh ayok-ammaana obhori kpenamkpen, okhuribi Ọvaar Ibinọkpaabyi okk'ẹjaakhi ch'ogbe kwa bọng atte ibhori nna ọbọhk osa. ");
INSERT INTO mfo_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","Bọng afha abọbh akhekhennọng p'arukhi kabọng k'ottem ibhori ọbọbh, yina, bọng akhaambi atte obhori kpenamkpen ọbọhk, kw'oyok-ọmmaana kw'Israẹl otzim bọng. ");
INSERT INTO mfo_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","Yina, tte ọnọng manda wani oningi ogbor osi kabọng k'ottem, okhuribi Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng odo bọng odo k'eden ọkkakka k'irerek nnuma s'ochekhi bi ide ekkema chabọng. ");
INSERT INTO mfo_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","Idikha bọng atzọk ogbe ahakha nho anang Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, bọng abira atzọkha ogbe ahok asana mba biphyir p'akhaam nnangi bọng mayina, ");
INSERT INTO mfo_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng odo bọng odo mach'okk'ochekhi. Bọbọng ábhor idibhon ekpo, yina, bọng ekpo ka bẹ kábhor. Bọng ádabh idibhon s'ihaabh-ọhaabh, yina, obhon manda wani kw'ọdabh bọng kóde. ");
INSERT INTO mfo_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","Idikha oyok-ọmmaana kwabọng kw'ofon Israẹl osi ogbor k'obhon manda wani m'irerek nna s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ọnangi bọng, bọng ẹrama kasi atzima atzor bẹ. ");
INSERT INTO mfo_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","Yina, bọng si ọphyaam anang bẹ, bọng atzima ettem obungichẹ anang bẹ ọttọhk kpenamkpen fa bẹ arori. ");
INSERT INTO mfo_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","Bọng ochibhi-tzama dema nwa kàkhaama o: “Cho nwa kw'ottong azenamfa, kw'ode cho kwa bọng akwọbha ayok ibhori ọbọbọbh ọkk'ọbaanga,” bọng ochibhi kw'oni otzori kakhaama atzima atzor ayok-ammaana p'Israẹl p'arukhi k'owora, bọng bẹ ọttọhk kpenamkpen kàram. Da bẹ afha abhom osisi kwabọng kw'ẹkhọngkwuri, anang Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","Bọng si ọphyaam anang bẹ, ettem eningi bọng ẹmma; mẹ wọ ósi Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng odo bọng k'ọtzọhm kpenamkpen fa bọng asi, ọmaana ọttọhk kpenamkpen fa bọng atzim mbọhk sabọng asi. ");
INSERT INTO mfo_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","Agbogbora m'irerek nna káwor. Mẹ wọ ofon, kaam mbeni bọng bi bọng asi ọphyaam anang ayok-ammaana p'Israẹl p'asi ogbor abira aruk k'owora m'irerek sabọng. ");
INSERT INTO mfo_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","Idikha oyokh-oyok oHiburu-nọng ode ojinọng obiro ode kwanọng, okpe for sẹ ọnang bọng k'ebira, osi ọtzọhm ọnang bọng k'acho azaadani, on-ottong cho atzenamfa bọng akhaambi attẹ-ẹ ọbọhk ofona k'idukhi. ");
INSERT INTO mfo_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","Mada bọng attẹ-ẹ ọbọhk, bọng kẹ mbọhk-mbọhk kàkhubh. ");
INSERT INTO mfo_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","Bọng kkema etzirakpo pyabọng anang bẹ, bọng atzọkha ẹchakpo k'ibe sa bẹ am-wobha akhok abọkpa, bọng atzọkha atzuk k'ibe sa bẹ am-amyana atzuk anang bẹ k'ọphyaam. Bọng nang bẹ atzor k'odem kw'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabóng, okk'bọng ọda. ");
INSERT INTO mfo_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","Bọng jima bi, iwa bọng ade abira k'Ijip, yina, wa Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, obhek bọng. Kẹ wọ osi kaam nnang bọng ndọhna nna, k'ewu cha mayina. ");
INSERT INTO mfo_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","Yina, idikha ọtzọhmnọng kwọ, on-obeni bi, “Kaam kọdaakhi bi mbina ka mbọhk sọ,” okhuri da ọkhaam idadaakha ttara kọ ọmaana ẹhọhmmọr chọ, ttara bi da ewobha ejibha ka mbọhk sọ, ");
INSERT INTO mfo_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","kọ tzima ọtzọhmnọng nwa atza abe m'ẹgbaakha ch'ẹhọhmma, abikh-ẹ itzọhng mẹ, aju, ifha kẹ on-ode ọtzọhmnọng kwọ k'akpen pẹ biphyir. M'eden nduma dani dọ ch'ási ọtzọhmnọng kwọ kw'ikwanọng. ");
INSERT INTO mfo_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","Bọng kwẹ kàtzọkha mach'odik kw'ọkhar-ọkhaara bi, bọng atte atzọhmnọng pabọng afona k'idukhi, okhuri bi, ọtzọhm fa bẹ akk'asa ka cho azadani ode igbe ifa k'ọtzọhm f'ira bọng abher anọng. Mẹ wọ osi, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, odo bọng k'ọttọhk kpenamkpen fa bọng asi. ");
INSERT INTO mfo_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","Bọng dekha acheden va p'ijinọng p'abhaam pabọng omaana p'arukhimaan pabọng, anang Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng. Bọng acheden va p'andaamogbo pabọng kàtzima asi itzọhm, bọng acheden va p'arukhimaan pabọng ophyibha kàphyiri. ");
INSERT INTO mfo_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","Ka cho kpenamkpen bọng am-atzima nhọhmmọr sabọng achi nden nna k'itzitzikha s'Ovaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, k'ibe sa kẹ ótzekha. ");
INSERT INTO mfo_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","Idikha etzen manda dani etzim ekhem, ode bi chẹ ẹphyakhi mgbẹtzẹ, obiro ode bi chẹ ẹkpa chen, ode bi chẹ etzim ọkhọhmana f'ideden o, bọng kàkhaambi atzima chẹ asi ẹjafọhni anang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng. ");
INSERT INTO mfo_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","Bọng akhaambi achi nden nna ka bọng k'ibhon. Bọng ayok p'an-awuri atzor k'immaana-dik ọmaana ayok p'awur-owur afha achi sẹ, mach'ira bọng achi otzenwuri ọmaana ochimi. ");
INSERT INTO mfo_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","Yina, bọng kàkhaambi achi izi sa nden nna; bọng tte sẹ ọbọhk ibyengi k'irerek, mach'asi. ");
INSERT INTO mfo_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","Bọng si ọdadaami kwa Pasova k'ophe kw'Aviv, anang Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ikpokpobha, okhuri bi, m'ophe kw'Aviv wọ kw'otzim bọng k'erungi obina k'irerek s'Ijip. ");
INSERT INTO mfo_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","Bọng nọbha orukhimaan wani, obiro ode ẹbhaam o, atzima asi ẹjafọhni cha Pasova anang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, k'ibe s'Ọvaar Ibinọkpaabyi ótzekha bi, s'íde ikpokpobhabe sa che chẹ. ");
INSERT INTO mfo_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","Bọng brẹd kwa bẹ akhe yist katzima achi nden s'ẹjafọhni nda. Yina, bọng chi brẹd kwa bẹ ani yist akhe, kw'ode brẹd kw'ihem, okhuri bi, wa bọng abin k'Ijip k'idudukha, ifha k'akpen pabọng biphyir bọng am-afha ajima ogbe kw'iwa bọng abin k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","Tte yist kpenamkpen oningi k'ihọhm sabọng ode, makhọra ẹkhọma chabọng biphyir k'iwu izenamfa. Bọng yist kabọng k'irerek biphyir kakhok, k'iwu izenamfa. Bọng etzen nda cha bọng atzim asi ẹjafọhni k'ẹchọhkha ch'echedenwu kakhok maa, ewu ehobha. ");
INSERT INTO mfo_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","Bọng ẹjafọhni cha Pasova k'obhon manda wani kw'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọnang bọng, kàsi, ");
INSERT INTO mfo_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","oyongi k'ibe sa kẹ ótzekha mach'ikpokpobhabe sa che chẹ. M'ibe nna rọ sa bọng asi ẹjafọhni nda cha Pasova k'ẹchọkha, da ewuchen en-edimi, atzima asi ojima kw'ebina chabọng k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","Bọng wobha k'ibe s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ótzekha, abhaabh ezen nda achi. Ewu ekhobh bọng abina abhana k'orukhabe fabọng. ");
INSERT INTO mfo_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","Bọng chi brẹd kwa bẹ ani yist akhe k'iwu izadani, ottong iwu izenamfa, bọng akhaama ewobha atzima anang Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ikpokpobha, ọnọng oningi ọtzọhm osi. ");
INSERT INTO mfo_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","Bọng mik mphyawu nzenamfa nkwọbha, k'ogbe kwa bọng attẹwor ipha s'abọkpa, ");
INSERT INTO mfo_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","asi Ọdadaami kwa Mphyawu anang ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, bọng tzima nnanga s'ifon bọng ka nttem akwu, atzor ka ndaa s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, okk'bọng ọnanga. ");
INSERT INTO mfo_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","Bọbọng ọmaana va pabọng p'ijinọng ọmaana p'ipanọng, ọmaana abira pabọng p'ijinọng ọmaana p'ipanọng, ọmaana ab'aLẹvi p'ibhon sabọng, ọmaana akhekhennọng, ọmaana apfuva ttara apopa p'arukhi ọmaana bọng, asi ọdadaami m'itzitzikha s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, k'ibe s'ótzekha bi bọng awobha akpobha che chẹ. ");
INSERT INTO mfo_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","Bọng jima bi, wa bọng ade abira k'Ijip, bọng abira ajima bi, atzọkha ogbe ahok akpebhi mba. ");
INSERT INTO mfo_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","Bọng akk'ekpo pya bọng apha azobha biphyir, bọng na tzima iwu izenamfa asi ọdadaami kw'ibhingabe. ");
INSERT INTO mfo_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","Bọng wobha k'ọdadaami, bọbọng ọmaana va pabọng p'ijinọng ttara p'ipanọng, ọmaana abira pabọng p'ijinọng ttara p'ipanọng, ọmaana aLevi k'idibhon sabọng, ọmaana akhekhennọng, ọmaana anọng p'abatte akk'apa ttara anọng p'abadim akk'apa bọng si ọdadaami m'itzitzikha s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng k'ibe s'ótzekha bi ide irukhabe sẹ, otzor k'odem kwa che chẹ ede. ");
INSERT INTO mfo_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","K'iwu izenamfa bọng si ọdadaami nwa anang Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng k'ibe s'ótzekha. Okhuri bi, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, osi bọng akhaama ẹdaa k'ipha sabọng, ọmaaana itzọhmbọhk kpenamkpen sabọng, ttara ottemdaamiji ọkkakka. ");
INSERT INTO mfo_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","Igbe ittaan ka cho kpenamkpen, ajinọng pabọng biphyir am-ákwu ma ibe nna s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, okk'ótzekha. Asi Ọdadaami kwa Brẹd kwa bẹ ani yist akhe, ọmaana Ọdadaami kwa Mphyawu, ttara Ọdadaami kwa Okhira. Ọnọng manda wani kọkhaambi ọtza mẹ ttaara abọhk-kpakpa. ");
INSERT INTO mfo_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","Ọnọng kpenamkpen ọkhaambi otzima ẹnanga ch'etzor k'ẹdaa ch'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọkk'ẹ ọnanga. ");
INSERT INTO mfo_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","Bọng dekha asi-aponga, ọmaana adeho k'ẹkhọma kpenamkpen ch'ibhon sabọng, s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọnangi bọng, anọng mba bọ asi aponga anang anọng k'eden-ọkka. ");
INSERT INTO mfo_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","Bọng aponga ewobha kabhakhi, bọng anọng k'itzitzikha kàbira akkeri asi aponga. Bọng ngwu kàchi, kkeri ngwu mimkpa okkoji-nọng chen, mbiri mbọkha atzim p'ọnọng kw'otzor-otzor mmakhi. ");
INSERT INTO mfo_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","Bọng si aponga p'atzor-otzor, bẹ atzor-otzor, ifha bọng aruk akpen atzọkha ekkema ch'irerek s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọnangi bọng. ");
INSERT INTO mfo_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","Bọng ẹkpọmmachi ch'Ashẹra kàttima abaanga ijafọhnibe sa bọng asi anang Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ");
INSERT INTO mfo_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","bọng ndur s'ikha kàttima, okhuri bi, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọttaang ekpo mbya ọttaanga e. ");
INSERT INTO mfo_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","Andaam-ogbodo obiro ode orukhimaan kw'otzim ekhem, ode bi otzim ọkhọhmana o, bọng kàtzima asi ẹjafọhni anang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, kkeri pyẹ ekpubh-ẹ okpukhi. ");
INSERT INTO mfo_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","Idikha bẹ abọhk ọnọng ode ojinọng, obiro ode kwanọng kw'orukhi ttara bọng k'ibhon s'Ọvaar Ibinọkpaabyi ọnangi bọng, da osi ebibya, otto ọphaangi k'itzitzikha s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ");
INSERT INTO mfo_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","on-otto k'asana paam ottima itzitzikha k'irerek okpobha ekpo ẹdọdọk, ode ekpikhira obiro ode ophe ọmaana ndodori k'ọrọngkpakpa, ");
INSERT INTO mfo_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","bẹ agbaakh-ọ odik-dema nwa, kọ akhaambi adọhn kwẹ ejibh-ejibha. Akwẹ ode odik-ọkka bi, bẹ akk'kwẹ adọhna are bi bẹ akk'odik-ttama nwa asa k'Israẹl, ");
INSERT INTO mfo_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","bọng dọkha ojinọng nwa, obiro ode kwanọng kw'osi odik-ttama nwa atzima achina k'ẹbaakhama ch'odedenmon, atzọbh-ẹ atza maa, ope. ");
INSERT INTO mfo_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","K'itzitzikha sa nttẹsẹ afa obiro ode attaan p'achekhi bi, odik nwa ode odik-ọkka, be akhaambi afhu ọnọng nwa. Yina, idikha nttẹsẹ ode ọnọng wani kẹ-kẹ, bẹ aningi ọnọng manda wani afhu. ");
INSERT INTO mfo_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","Nttẹsẹ mba bọ ade acheden-nọng p'atzima mbọhk sabẹ afhu ọnọng nwa, yina anọng kanya biphyir an-attara mbọhk bẹ afhẹ-ẹ. Bọng akhaambi agbobhi ebibya nda k'ottem kwabọng, abhari. ");
INSERT INTO mfo_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","Idikha anọng atzim aponga p'ayakh-ọyak akwu akhebh-ọ bi, attọhna, ode aponga p'ẹnọng-fha, obiro ode p'ọnọng otto ọphaangi, ode p'ọnọng ọrẹkhi oyok, bọng dima aponga mba achina k'ibe s'Ovaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ótzekha. ");
INSERT INTO mfo_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","Bọng nọhng atza akhebha afọhnẹja p'ẹnọmma cha Lẹvi, ọmaana asi-aponga p'ogbe nwuma, ifha bọng adọhn bẹ m'odik nwa, bẹ abira anang bọng ochibhi kwabẹ. ");
INSERT INTO mfo_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","Bọng akhaambi ási atzor ka ndọhna sa bẹ anang bọng k'ibe s'Ovaar Ibinọkpaabyi, ótzekha. Bọng dọkha ogbe, asi odik kpenamkpen kwa bẹ atzọhn-ọ bi, asi. ");
INSERT INTO mfo_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","Bọng si atzor k'odem kpenamkpen kwa bẹ akpebhi bọng, ọmaani k'ochibhi kpenamkpen kwabẹ. Bọng nnam kàkpa abọra idik sa bẹ atzọhn bọng, bọng kàbira akke akkeri k'odimbọhk kaambi kwabọhk wọ. ");
INSERT INTO mfo_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","Ọnọng kpenamkpen kw'osi irẹrẹkhi ọnang osi-aponga, obiro ode bi osi irẹrẹkhi ọnang ọfọhnẹja kw'osi ọtzọhm mẹ anang Ọvaar Ibinokpaabyi, kw'ode Ibinọkpaabyi kwabọng, bẹ akhaambi afhẹ-ẹ. Bọng akhaambi agbobhi ebibya nda k'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","Anọng biphyir ábhaanga-ọbhaanga, ojora ósi bẹ, bẹ irẹrẹkhi mando dọk kasi. ");
INSERT INTO mfo_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","Mada bọng ápyiri k'irerek nnuma s'Ọvaar Ibinọkpaabyi, kw'ode ibinọkpaabyi kwabọng ọnangi bọng, bọng abira atzọkha sẹ akhaama aruk mẹ, an-aben bi, “Tte mọkhaama ọvaarnọng kw'ọdabh man, mach'idibhon idọdọk biphyir s'ikhọri man ọkhọri,” ");
INSERT INTO mfo_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","bọng akhaambi atzekha ọvaarnọng kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, otzek. Ọnọng nwa ọkhaambi ode oyokh-ọmmaana kw'Israẹl. Bọng kàkhaambi asi okhekhennọng, kw'oni ọmmaana kw'Israẹl ode ọvaarnọng. ");
INSERT INTO mfo_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","Kẹ ọvaarnọng nwa kọ̀khaambi ọkhaama nnyanyaang k'ọhaabh. Kẹ kọ̀khaambi obiro ọtzọhm anọng akpa nnam k'Ijip bi, bẹ atza adebh nnyanyaang akwu attara ka s'okkekkeni ọkhaama, da Ọvaar Ibinọkpaabyi okk'bọng obena bi, “Bọng kàkhaambi abira akpa nnam k'Ijip.” ");
INSERT INTO mfo_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","Ọvaarnọng nwa kọ̀khaambi, ọtzọkha panọng k'ọhaabh, oni mando ode, bẹ atzima achibhi pẹ atten-ottena. Kẹ kọ̀khaambi ọkhaama asilva ọmaana gol k'ọhaabh. ");
INSERT INTO mfo_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","Idikha okk'ẹvaar ch'obhon kwẹ ọdabha, kẹ ọkhaambi ọkkẹr aphaangi p'ọtzọk k'afọhnẹja p'ẹnọmma cha Lẹvi ka nnwẹr, ọnang for sẹ. ");
INSERT INTO mfo_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","Kẹ ohok nnwẹr nwa kw'aphaangi mba, kẹ ọkhaaambi oyeri aphaangi mba k'akpen pẹ biphyir, ifha kẹ okpebhi bi ọnang Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwẹ ikpokpobha, obiro ọtzọkha ogbe ọtzọn atzim biphyir p'aphaangi ọmaana akpebhi pẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","Kẹ kọ̀khaambi for sẹ ibar-ẹ odik, iyọhnga ayokh-ammana p'Israẹl, kọ̀khaambi ọkpa nnam ọbọra aphaangi mba, okke okkeri k'odimbọhk kaambi kwabọhk wọ. Mẹ wọ osi, kẹ ọmaana va pa va ádabh ẹkhọma ch'Israẹl k'ogbe-bhirada. ");
INSERT INTO mfo_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","K'odik-ọkka, afọhnẹja p'ẹnọmma cha Lẹvi biphyir, kàkhaambi akhaama ọttọhk f'ode fabẹ, abira atzọkha ekkema k'irerek s'anọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","Bẹ ekkema ch'irerek s'ayokh-ammaana pabẹ p'Israẹl, kákhaama. Ọvaar Ibinọkpaabyi wọ ode ekkema chabẹ, mach'okk'ochekhi ọnang bẹ. ");
INSERT INTO mfo_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","K'ogbe kpenamkpen kw'anọng atzim adaam-ogbodo, obiro ode orukhikmaan asi ẹjafọhni, ekkema ch'afọhnẹja ede: amaanggọ, ọmaana akpabhọri ttara atzen-yara p'eho. ");
INSERT INTO mfo_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","Bọng akhaambi anang bẹ icheden-pha s'ekpo pya bọng ayaabh, atzuk abhapẹ ọmaana ana p'oliv, ọmaana icheden-phyubha sa bọng aphyiri k'arukhimaan pabọng. ");
INSERT INTO mfo_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","Da Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng okk'bẹ otzekha ọmaana va pa va pabẹ, ka ngọma sabọng biphyir bi, bẹ atzera nho sabọng, abira asi ọtzọhm ka che ch'Ovaar Ibinọkpaabyi k'ogbe kpenamkpen. ");
INSERT INTO mfo_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","Idikha oLẹvi-nọng kw'orukhi k'obhon manda wani kwabọng m'Israẹl, otzim ettem obungichẹ obina kẹ da orukhi, ochina k'ibe kpenamkpen s'Ovaar Ibinọkpabyi ótzekha, ");
INSERT INTO mfo_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","kẹ ọfha osi ọtzọhm f'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi mach'ayokh-ayok aLẹvi p'am-asi ọtzọhm mẹ, k'itzitzikha s'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","Kẹ ọkhaambi ọtzọkha ekkema ebenga-mbọhk ttara ayokh-oyok aLẹvi, kaambi ode kẹ okk'ekkema ọtzọkha k'agbikha pa bẹ akpe efonakpo. ");
INSERT INTO mfo_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","“Mada bọng apyiri k'irerek nna s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ọnangi bọng, bọng kàkhaambi atzaam akha-tzama p'idibhon nnuma. ");
INSERT INTO mfo_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","Tte ọnọng manda wani oningi k'ottem kwabọng ode, kw'ọtzọkha nnwa kwẹ kw'ijinọng obiro ode kw'ikwanọng otzima ọfọhni ẹja k'ekpon ẹwọmachẹ. Ọnọng kw'ọbhari abọhkpakpa, kaambi ose wọ, obiro ode mbọng, ọmaana itzatzaana-dik, ");
INSERT INTO mfo_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","kaambi ọnọng kw'ọm-ọbhari anọng ikhọmana wọ, obiro ode ochikpakpaa, obiro ode ọnọng kw'ọm-ọdọhn apfuranọng, oningi k'ottem kwabọng ode. ");
INSERT INTO mfo_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Ọnọng kw'osi idik nna, okpukhi Ọvaar Ibinọkpaabyi idik. Idik nna rani rọ isi Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ókhubh idibhon nnuma kẹ da bọng akkeri itzitzikha. ");
INSERT INTO mfo_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","Bọng akhaambi akhonga aruk akpen p'abari ayọhnga ottotto k'itzitzikha s'Ọvaar Ibinọkpaabyi, kwode Ibinọkpaabyi kwabọng. ");
INSERT INTO mfo_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Kaambi ode bi, idibhon sa bọng átza abọkha obe ana, im-iyonga itzọnhg inang abọhnga-nọng ọmaana anọng p'abhari abọhkpakpa, Ọvaar Ibinọkpaabyi kwode Ibinọkpaabyi kwabọng, bọbọng ẹfa dema nduma kọnangi. ");
INSERT INTO mfo_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Ọvaar Ibinọkpaabyi kwode Ibinọkpaabyi kwabọng, ọ́rọbha ọsẹjaakhi ọrọbha ka bọng k'ottem, kw'óde macha kaam kw'obiro ofona m'ottem kwa bọbọng anọng p'Israẹl. Bọng akhaambi ayonga itzọhng anang-ẹ. ");
INSERT INTO mfo_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Odik kw'iwa bọng aphyemi Ọvaar Ibinọkpaabyi, kwode Ibinọkpaabyi kwabọng ka Horẹb wọ ma, k'ewu ch'iwa bọng atzobh, abhom aben bi, “Tte moningi ẹmọng ch'Ọvaar Ibinọkpaabyi kwode Ibinọkpaabyi kwaman, dọk ọbhaang e, moningi ekpon-barada nda dọk ore e, oni mando ode, mópe-ope e.” ");
INSERT INTO mfo_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Wa Ọvaar Ibinọkpaabyi oben-m bi, “Odik kwabẹ aphyemi ojibhi kẹ. ");
INSERT INTO mfo_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Kaam nnọbha ọsẹjaakhi k'ottem p'anọng p'Israẹl ọrọbha, kw'ode macha kọ nnang bẹ. Kaam mbiri ńge atzim paam k'ẹmma chẹ p'ọgbaak. Kẹ ósi ẹjaakhi ch'odik kpenamkpen kwa ndọhn-ẹ, ọ́nang bẹ. ");
INSERT INTO mfo_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Kaam ọkhaam wọ nttọhna aponga p'ọnọng kpenamkpen kw'oni itzọhng oyong ọnang atzim paam, p'ọsẹjaakhi otzim che chaam ọgbaak bẹ. ");
INSERT INTO mfo_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Yina, ọsẹjaakhi kw'otzim che chaam ọgbaak odik kwa kaam nnẹ-ẹ mgbaakhi, obiro ode ọsẹjaakhi kw'otzim che p'ikha osi ẹjaakhi, bẹ akhaambi afhẹ-ẹ.” ");
INSERT INTO mfo_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","Asi mẹ, bọng am-abọbh bi, “Mosi yan oronga ẹkkaabha ch'eni k'Ovaar Ibinọkpaabyi efon o?” ");
INSERT INTO mfo_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Idikha odik nwuma kw'ọsẹjaakhi otzim che ch'Ọvaar Ibinọkpaabyi osi ẹjaakhi on-otto, ode bi kwẹ kobiro ode mach'ọgbaakhi, kw'oyini bi, Ọvaar Ibinọkpaabyi odik nwuma kọgbaakhi. Ọsẹjaakhi nwuma otzim ẹfa osi ẹjaakhi nduma  e, mẹ wọ, opoma oningi bọng osi. ");
INSERT INTO mfo_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","K'ogbe kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọkk'anọng p'idibhon nna s'ikhaam irerek s'ọtzọkh ọnang bọng odimi, k'ogbe kwa bọng akk'idibhon nna akhubha, abira atzọkha ibhon sabẹ ọmaana ihọhm sabẹ aruk, ");
INSERT INTO mfo_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","bọng dekha ibhon ittaan m'ibhon nna s'Ovaar Ibinọkpaabyi ọnang bọng bi, bọng akhaama. ");
INSERT INTO mfo_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","Bọng yoma irerek nna s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọ́nang bọng mach'ekkema chabọng, bọng akkema sẹ k'obe ọttaan, ifha ọnọng oni oyok k'ọgbaan ofhu, ọfha ọrọbh ọtza ochubha k'odedenmon nwa wani. ");
INSERT INTO mfo_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","Ma wọ ode ọphaangi kw'okhuri ọnọng kpenamkpen kw'ofhu oyok, ọrọbh ọtza ochubha mẹ oror ẹkkaana. Mando kw'ọnọng kw'oni ọkhami bi ofhu oyok k'ọgbaan, da bẹ ani ẹkhọhr akkekkeni akhaama, óbiro ọ́robh ọtza ochubha oror ẹkkaana. ");
INSERT INTO mfo_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","Kwẹ ọfha ode bi, anọng afa atza ommen k'ẹtzam, mada bẹ am-akkọhbh omen, ẹbar-ho ch'oyok wani ẹfha ẹrọbha ebun oyok, ẹfhẹ-ẹ. Ojinọng nwuma ọfha ọrọbh ochina k'odedenmon wani kw'idedenmon nna ittaan, ọkkaana akpen pẹ. ");
INSERT INTO mfo_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","Oni mando ode, otzukha-ẹnọngmon okhubh-ẹ, eden ebhiri kpọhng, ọfha ọkhọbh-ẹ, ọfhẹ-ẹ, kaambi ode bi ira k'ọbaan bi ope, da oni ọkhami bi ofhu oyok k'ọgbaan, da bẹ ani ẹkhọhr akkekkeni asi. ");
INSERT INTO mfo_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","Kẹ wọ osi mben bọng bi, bọng atzekha idedenmon ittaan anang for sabọng. ");
INSERT INTO mfo_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","Idikha Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, ọmmẹm nnem sabọng mach'ọnwọhngi ochekhi ọnang ab'atte, ọtzọkha irerek biphyir s'ochekhi ọnang bẹ, ọnang bọng, ");
INSERT INTO mfo_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","okhuri da bọng atzọk ogbe ahok aphaangi mba pa kaam nnangi bọng mayina bi, Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọdaak bọng, bọng abira ahakha nho anang-ẹ, mẹ wọ osi, bọng atzekha ibhon ittaan idọdọk ahok. ");
INSERT INTO mfo_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","Bọng asi mando ifha bọng aningi izi s'ẹnọngmon k'irerek sabọng abyengi, s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ọnangi bọng mach'ekkema chabọng, ifha bọng aningi oponga-pyibha kw'ẹnọng-fha abira atzọkha. ");
INSERT INTO mfo_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","Yina, idikha ofon k'ittattaanga, ọnọng on-ochubha otzik oyok ọfhẹ-ẹ k'ọgbaan, ọrọbh ochina k'odedenmon wani kw'idedenmon nna ittaan, ");
INSERT INTO mfo_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","adedenọng p'obhon átzọhm bẹ atzima ọnọng nwa kw'ọrọbhi ebhon ochina k'odedenmon atzima akwu, bẹ atzọkha ọnọng kw'ọrọbhi ebhon atte ọbọhk anang ọnọng kw'om-otzukha ẹnọngmon bi, ọfhẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","Bọng ọnọng nwa inọngkwo kàkhọhkha o. Bọng akhaambi agbobhi ephyok ch'izi s'ẹnọngmon k'Israẹl abhari, ifha ojibh ọnang bọng. ");
INSERT INTO mfo_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","Bọng tte atza p'enem p'iwa ab'itta pabọng akhe awobha, k'irerek s'Ọvaar Ibinọkpaabyi kw'ode, Ibinọkpabyi kwabọng ọnangi bọng bi bọng akhaama. ");
INSERT INTO mfo_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","Bọng atzim pa nttẹsẹ wani katzima akpaara aponga p'ọnọng kw'oji odik, kaambi ira bẹ abubh-ẹ odik obubha. Bọng akhaambi abhaanga atzim ka nttẹsẹ afa, kaambi attaan bọ, yina bọng akpaara aponga. ");
INSERT INTO mfo_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","Idikha nttẹsẹ kw'ibhora obe bi pyir bi obhubha oyok odik, ");
INSERT INTO mfo_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","bẹ anọng afa p'abe aponga akhaambi ayin Ọvaar Ibinọkpaabyi k'itzitzikha, kw'oyini bi, bẹ abe k'itzitzikha s'afọhnẹja ọmaana asi-aponga p'awobha m'ogbe nwuma. ");
INSERT INTO mfo_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","Asi-aponga akhaambi adọhn odik nwa ejibh-ejibha. Idikha kwẹ ode bi, nttẹsẹ nwa osi ibhora ọnana oyok, obubha oyokh-ọmmaana kw'Israẹl odik, ");
INSERT INTO mfo_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","bọng asi nttẹsẹ nwa kw'ibhora odik kw'ira ọkhami bi, bẹ asi oyok. Bọng akhaambi agbobhi ebibya nda k'ottem kwabọng abhari. ");
INSERT INTO mfo_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","Anọng ójora bẹ ojora da bẹ abhaanga odik nwa, ebibya dema nda k'ottem kwabọng dọk kéde. ");
INSERT INTO mfo_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","Bọng inọngkwo kàkhaama: ọnọng kw'ófhu oyok bọng fhẹ-ẹ; óju oyok chen bọng juẹ-ẹ chen; ọ́rọbh oyok ẹha bọng nọbh-ẹ ẹha; ọ́kpaar oyok ọbọhk bọng kpaara ọbọhk; ọ́kpaar oyok ebhokpa-tzọkhi bọng kpaara ebhokpa-tzọkhi chẹ. ");
INSERT INTO mfo_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","K'ogbe kwa bọng atza bi, bọng atza arima attattaanga-nọng pabọng abẹ, bọng are odem kwa nnyanyaang ọmaana akpaar pa nnyanyaang mmindọr, ttara arim-egbong ahaabhi agaangi ayọhnga bọng, tte oningi bọng ojor. Kkeri Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, kw'otzim bọng obina k'Ijip, ówobh-owobha ọmaana bọng. ");
INSERT INTO mfo_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","K'ogbe kwa bọng akk'for ada bi atza egbong, ọfọhnẹja óbe arim-egbong k'itzitzikha, ọgbaak bẹ atzim. ");
INSERT INTO mfo_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","Ọfọhnẹja óben bẹ bi, “Anọng p'Israẹl o, bọng yonga itzọhng, bọng an-atza arima attattaanga-nọng pabọng abẹ, k'ewu cha mayina e. Tte ẹfa eningi bọng ẹha, ojora oningi bọng osi; opoma oningi bọng obiro osi, ettem iningi bọng atzim ẹyakhi. ");
INSERT INTO mfo_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","Kkeri, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, wọ ode ọnọng kw'orima attattaanga-nọng pabọng abẹ, ọnang bọng ekhema.” ");
INSERT INTO mfo_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","Adenho akwu abọbh arim-egbong bi, “Ọnọng owobh ma kw'osi ọhọhm ọbhakwẹ kw'on-otzima orukha o? Tte kẹ ọkpa nnam obhana, oni mando ode, ope k'egbongdam, ọnọng ọdọdọk ọ́tzọkha ọhọhm kwẹ ọ́tzọkha oruk. ");
INSERT INTO mfo_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","Ọkhaam ọnọng ma kw'ọyaabh owoni kwa grep kw'oni otzim ọpha o? Tte kẹ ọbhana, oni mando ode, kẹ ope k'egbongdam, ọnọng ọdọdọk on-ochi ikhem sẹ. ");
INSERT INTO mfo_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","Ọjinọng owobh ma kw'ọkhaami bi ọtzọkha kwanọng, tte kẹ ọkpa nnam ọbhana k'ọhọhm, oni mando ode idikha ope, ọnọng ọdọdọk wọ on-ọtzọkha kwanọng kwẹ.” ");
INSERT INTO mfo_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","Ofona mẹ, adenho mba abira abọbh bi, “Ọnọng owobh ma kw'ọkhaam opoma obiro ode ojora o? Tte kẹ ọkpa nnam ọbhana ifha oningi ayok arim-egbong opoma ọmaana ojora okwu okhe ka nttem.” ");
INSERT INTO mfo_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","Idikha adenho mba akk'arim-egbong atzim agbaakha okpo, tte bẹ atzekha arim-egbong bani p'áde aho p'ayok. ");
INSERT INTO mfo_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","Bọng apyiri k'obhon kwa bọng abeni bi arima abẹ, bọng bọbh anọng p'obhon nwuma sa bẹ arori ẹmẹm. ");
INSERT INTO mfo_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","Bẹ akher bi akwunga ebaakhama ch'obhon kwabẹ anang bọng, kw'oyini bi, bẹ biphyir m'obhon nwuma akhaambi awobha k'irekhirek kwabọng, bẹ asi itzọhm s'igaangi-ọgaangi anang bọng. ");
INSERT INTO mfo_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","Idikha bẹ an-ẹmem arori, bẹ an-atzer ado for s'erima, bọng gọri obhon nwa akhe k'ottem. ");
INSERT INTO mfo_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","K'ogbe kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, okk'obhon nwa ọtzọkha okhe bọng ka mbọhk, bọng dima ọkkangkkaang afhu ajinọng biphyir m'obhon nwa. ");
INSERT INTO mfo_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","Onode panọng, ọmaana va pabẹ, ọmaana nden s'otzer, ttara ọttọhk kpenamkpen for ode fabẹ m'obhon nwa ẹtzaanga, bọng chi ọgbọm atzọkha akhaama. Okk'bọng ọdaakha bọng atzọkha ọgbọm f'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng okk'ọtzọkha k'attattaang-nọng pabọng ọnang bọng. ");
INSERT INTO mfo_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","Ma wọ ode odem kwa bọng asi ibhon biphyir s'iwobh bọng k'odenmir, bọng ofor-gbakha kabira akhaama ttara idibhon s'ibaang bọng. ");
INSERT INTO mfo_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","Yina, bọng apyiri m'ibhon nna s'Ọvaar Ibinọkpaabyi ọnangi bọng macha ekkema chabọng, bọng ọttọhk manda vani f'oji iwọng ọbọhk kàtte oruk akpen. ");
INSERT INTO mfo_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","Bọng fhu anọng mba biphyir-phyir p'ade; anọng pa Hit, anọng p'Amor, anọng pa Kenan, anọng pa Pẹriz, anọng pa Hiv ttara anọng pa Jẹbus. ");
INSERT INTO mfo_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","Oni mando ode bẹ akpebhi bọng adik-ttama pa bẹ am-asi da bẹ am-akpobha ikha sabẹ, ofona mẹ, bọng átto k'itzitzikha s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng. ");
INSERT INTO mfo_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","Idikha bọng akhọri obhon akhe k'ottem k'ogbe kw'obhir-obhir, am-arima bẹ abẹ, bọng ẹbar katzima afhu nchi, okhuri bi bọng afha are achiduk mẹ achi, idikha okwo ọkhaam bọng. Bọng sẹ kakpaara abhari, nchi rọ nde anọngẹya, kwa bọng an-atza arima sẹ abẹ o? ");
INSERT INTO mfo_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","Yina, bọng afha akpaara nchi sa nni aduk mminwọm, bọng atzima asi ogbongttọhk maa, bọng are bi, bọng akk'obhon nwa akhema. ");
INSERT INTO mfo_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","Bọng are ọnọng kwa bẹ afhu abhari k'owoni, m'irerek nnuma s'Ọvaar ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọnangi bọng mach'ekkkema chabọng, da bọng ani ọnọng kw'ọfhẹ-ẹ arong, ");
INSERT INTO mfo_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","tte adenho ọmaana asi-aponga pabọng, atza ayoma ibe s'ẹnọng-bukhi nda eyim maa, atza apyiri k'ibhon s'ibaang mẹ. ");
INSERT INTO mfo_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","Mẹ wọ, adenho p'obhon kw'ọbaang ibe s'ẹnọng-bukhi nda eyim, atzima ọbhaam-nwa akwu kwa bẹ ani atzim-atzima asi ọtzọhm, bẹ kẹ ọyak atzima akha ");
INSERT INTO mfo_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","tte bẹ atzim ọbhaam-nwa nwa ahakha k'ittolim sa bẹ an-atzima ayaabha, ekpo bẹ kabira agbon, kw'ode ibe s'ekhekha em-ebhobh. Tte bẹ aphyakhi ọbhaam-nwa nwa, ekhokhora. ");
INSERT INTO mfo_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","Tte afọhnẹja p'ẹnọmma cha Lẹvi abe k'itzitzikha, okhuri bi Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, okk'bẹ otzekha bi, bẹ asi ọtzọhm, abira ado anọng ka che ch'Ọvaar Ibinọkpaabyi, bẹ abira attọhna aponga biphyir p'ikhakhaanga ọmaana p'irẹrẹkhi. ");
INSERT INTO mfo_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","Adeho biphyir p'obhon kw'ẹnọng-bukhi nda eyim ẹbaanga, agbobhi mbọhk sabẹ k'ebir-ebir kw'ọbhaam-nwa nwa, kwa bẹ aphyakhi ekhokhora k'ittollim, ");
INSERT INTO mfo_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","adeho mba abira asi ẹjaakhi aben bi, “Maman arang ofhu ọnọng nwa, man chen paman kotzim ore da bẹ afhẹ-ẹ. ");
INSERT INTO mfo_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","O Ọvaar Ibinọkpaabyi, kọ bina anang anọng pọ p'Israẹl p'akk'abhekha. Anọng pọ oponga-pyibha kanang okhuri izi s'ọnọng kw'oni odik orong.” Manda wọ kw'Ibinọkpaabyi obina ọnang bọng k'izi s'ọnọng kw'oni odik orong, ");
INSERT INTO mfo_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","mẹ wọ obiro ode bi, bọng akk'mbọhk sabọng arọbha k'oponga-pyibha kw'ẹnọng-fha, ch'ọnọng kw'oni odik orong. Da bọng akk'odik kw'otzor-otzor asa k'itzitzikha s'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","Bọng atza egbong bi, bọng atza arima attattaang-nọng pabọng abẹ, Ọvaar Ibinọkpaabyi otte bẹ ọbọhk ọnang bọng, bọng abira abọkha bẹ k'ẹmmọri, ");
INSERT INTO mfo_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","idikha bọng an-are panọng p'ajibh-ojibh, da bẹ akk'bọng adaakha, bọng afha atzọkh bẹ k'ọbaada. ");
INSERT INTO mfo_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","Bọng atzim bẹ akwu k'ihọhm sabọng, bọng gba bẹ nho, akpaara bẹ amyikpa, ");
INSERT INTO mfo_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","awọra bẹ ekpo py'ira bẹ afọr k'ogbe kwa bọng abọk bẹ. Bẹ akk'arukha ka bọng k'ihọhm, bẹ abhom ab'otte ttara ab'ọkka k'ophe wani, mẹ kwa bọng an-atzọkha bẹ, bẹ an-ade panọng pabọng, bọbọng abira ade adim pabẹ. ");
INSERT INTO mfo_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","Ọnọng kw'ettem ẹn-ẹdaami ọmaana kwanọng kwẹ, tte ọttẹ-ẹ ọbọhk ọrọhng ofona k'ibe kpenamkpen s'idaakh-ẹ. Bọng kàkhaambi akpe bẹ, yina ira bọng an-ahokhi bẹ k'ebira, da bọng akk'bẹ abẹ ayima. ");
INSERT INTO mfo_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","Idikha ojinọng ọtzọk panọng afa, wani ọdaakh-ẹ ọyọhnga oyok, yina, bẹ panọng mba afa ammaan-ẹ va p'ijinọng, akwẹ ode bi, kwanọng kw'ọnẹ-ẹ ọdaakhi wọ ọmmaani ocheden-nwa, ");
INSERT INTO mfo_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","mada okkema ẹkhakhaama chẹ ọnang va p'ijinọng, kẹ kọkhaambi ọtzọkha ekkema ch'ocheden-nwa ọnang nwa kwa kwanọng kw'ọdaakh-ẹ ọtzam. ");
INSERT INTO mfo_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","Kẹ ọkhaambi ọnang nnwa kwa kwanọng kw'ọnẹ-ẹ ọdaakhi kw'ode ocheden-nwa, ekkema ch'ede igbe ifa k'ẹkhakhaam chẹ biphyir. Ocheden-nwa nwa wọ ode echeden-gọhkha ch'ẹfa ch'otte. Ekkema ch'ocheden-nwa ẹkhaam ocheden-nwa nwa. ");
INSERT INTO mfo_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","Idikha nwa ọgaangi eho otzima otzor otte ọmaana ọkka, itzọhng kokher oyonga ọnang bẹ, chibhi da bẹ akpẹm-ẹ, ");
INSERT INTO mfo_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","tte otte ọmaana ọkka atzim-ẹ achena adedennọng p'obhon p'awobh k'ipha s'obhon. ");
INSERT INTO mfo_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","Bẹ akhaambi agbaak adedennọng mba bi, “Nnwa nwa kwaman kw'ijinọng ọgaangi eho, obiro osi irẹrẹkhi. Kẹ eho kọhak ọnang man. Kẹ ọbari ọcha, om-obiro obuma atzuk.” ");
INSERT INTO mfo_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","Mẹ wọ osi, tte ajinọng k'obhon kwẹ biphyir atzọbh-ẹ atza, afhẹ-ẹ. Bọng akhaambi arọbha itzama nna kabọng k'ottem. Anọng p'Israẹl biphyir abhaang kwẹ, ojora osi bẹ. ");
INSERT INTO mfo_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","Idikha ọnọng otto ọphaanagi kw'ochin k'obo, bẹ afhẹ-ẹ, atzọkha obukhi kwẹ arena k'echi, ");
INSERT INTO mfo_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","bọng kakhaambi atte obukhi nwa ọbọhk orena m'echi nda maa, ewu ehobha. Bọng akhaambi anọhng-ẹ m'ewu nduma dani, okhuri bi, obukhi kpenamkpen kwa bẹ aren k'echi, ode ọnọng kw'ẹmma ch'Ibinọkpaabyi ẹbọhk. Bọng kàkhaambi, akhibhi irerek s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọnangi bọng mach'ekkema chabọng. ");
INSERT INTO mfo_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","Idikha bọng are ẹbhaam, obiro ode orukhimaan kw'oyokh-ọmmaana kw'Israẹl da otten eden, chẹ ọbọhk mẹ kàtte afona, yina, konga k'odem kw'abọkha chẹ achena ọkhaam. ");
INSERT INTO mfo_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","Idikha ọnọng kw'ọkhaam etzen nda bọng an-arukhi abaanga ayok, obiro ode bi ọnọng kw'ọkhaam chẹ karong, tzima chẹ abhana, ahok chẹ maa, ọkhaam oror chẹ okwu, atte chẹ ọbọhk anang-ẹ. ");
INSERT INTO mfo_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","Bọng si odem nwuma wani idikha bọng are ẹnyanyaang, ode ibara, obiro ode ọttọhk kpenamkpen f'odimi ayok, bọng fẹ ọbọhk kàtte. ");
INSERT INTO mfo_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","Idikha bọng are ẹnyanyaang ch'oyokh-ọmmaana kw'Israẹl, obiro ode ẹbhaam da etto eyima k'eden, bọng chẹ ọbọhk mẹ kàtte. Bọng kkaana ọkhaam, atzini chẹ abe. ");
INSERT INTO mfo_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","Panọng kàkhaambi afọra ejinọng-kpo, ajinọng kàkhaambi afọra ẹpanọng-kpo, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọttaang anọng kpenamkpen p'asi idik nna. ");
INSERT INTO mfo_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","Idikha are ẹgbara ch'inọnọhna k'eden ọkhaan-ọkhaan, ode ch'ewobh k'echi, obiro ode bi ewobh k'irerek, bọng are bi ọkka okhubh va mẹ, obiro ode bi okhubh ka nzi, bọng ọkka ọmaana va kàbọkha atzima afona. ");
INSERT INTO mfo_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","Bọng afha bọkha va, yina, bọng akhaambi atte ọkka ọbọhk ofona, ifha ojibh ọnang bọng, bọng abira aruk akpen p'adum-odum. ");
INSERT INTO mfo_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","Mada bọng asi ihọhm ibhasẹ, bọng si achumi-khuma atzima abubha ammakpabem p'akhọnakpasi pabọng, ifha bọng aningi oponga-pyibha kw'ẹnọngfha atzọk, idikha ọnọng ọphaar k'ọhọhm kw'ọnọng otto, ope. ");
INSERT INTO mfo_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","Bọng achi-mọma adem afa k'iwoni sabọng sa grep kàgbon; oni mando ode, ekpo pya bọng agboni ọmaana achiduk pa grep, ákhaama Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","Bọng ẹbhaam, ọmaana ẹnyanyaang, k'ibe rani kàgbana atzima asi ọtzọhm. ");
INSERT INTO mfo_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","Bọng ọbara kàfọra, fa bẹ atzim avu-phyibha asi, yina bẹ an-atzọk ọbara fa bẹ atzim ndik-nyokhasẹ ọkkakka asi akhum attara. ");
INSERT INTO mfo_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","Bọng ge mbaradik k'abem anna p'awurababa pa bọng afọr. ");
INSERT INTO mfo_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","Idikha ojinọng ọtzọk kwanọng, ọkk'ẹ abẹ oyima, on-okpukh-ẹ, ");
INSERT INTO mfo_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","otzima che cha kwanọng nwa ọkpaanga, obiro ọnang kwanọng che-tzama, oben bi, “Iwa kaam ndọk kwanọng nwa, k'ogbe kwa moyim ayok abẹ, kaam nna nne bi, okk'ojinọng oronga,” ");
INSERT INTO mfo_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","otte ọmaana ọkka kw'ominanwa nwa akhaambi atzima ẹkhọhkha ch'ẹjaakhi bi ominanwa kwabẹ ojinọng otzim oronga, atza akhọhkha adedennọng p'obhon k'ẹbaakhamma ch'obhon. ");
INSERT INTO mfo_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","Otte kw'ominanwa nwa ọ́gbaak adedennọng p'obhon bi, “Iwa kaam nnangi ojinọng nwa ominanwa kwaam k'ọbada, yina, kẹ dọk kọdaakhi. ");
INSERT INTO mfo_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","Ma, kẹ okk'ibhora ọsa ọnana nnwa kwaam, oben bi, ‘Kaam nnwa kwọ kinne mach'ọnọng kw'oni ojinọng otzim oronga.’ Yina, ma wọ ode ẹkhọhkha chẹkhọhk bi nnwa kwaam ojinọng otzim oronga.” Mẹ wọ, otte ọmaana ọkka akhaambi atzọkha ibara s'ide ẹkhọhkha bi, ominanwa nwa ojinọng otzim oronga, aruri m'itzitzikha s'adedennọng p'obhon. ");
INSERT INTO mfo_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","Mẹ wọ osi, adedennọng mba p'obhon atzọkha ojinọng nwa anang-ẹ ettuma. ");
INSERT INTO mfo_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","Bẹ ákpara otzukha anang ojinọng nwa, kw'ashẹkẹl pa silva arọbh azen. Bẹ atzọkha ashẹkẹl mba anang otte kw'ominanwa nwa, okhuri bi, ojinọng nwa okk'ominanwa kw'Israẹl kw'on-ojinọng otzim-oronga che-tzama, ọnanga. Ominanwa nwa ochina ororo ode kwanọng kw'ojinọng nwa, kẹ kọ̀khaambi okhubh k'ọbada k'akpen pẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","Yina, kwẹ ode odik-ọkka bi, ẹkhọhkha kebire ede bi ominanwa nwa ojinọng otzim oronga, ");
INSERT INTO mfo_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","bẹ akhaambi atzima ominannwa nwa akwu k'ẹhọhmma ch'ọhọhm kw'otte. Mẹ wọ kw'ajinọng p'obhon átzọhbh-ẹ atza maa, ope. Ominanwa nwa okk'obibya-dik ọsa k'Israẹl k'azaaza-kpen p'osi, k'ogbe kw'iwa orukhi k'otte k'ọhọhm. Bọng akhaambi agbobhi ebibya k'ottem kwabọng, abhari. ");
INSERT INTO mfo_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","Idikha bọng abọk ojinọng kw'oyim kwanọng kw'oyok abẹ, bẹ akhaambi afhu ojinọng nwa, ọmaana kw'anọng kw'oyim abẹ. Bọng akhaambi agbobhi ebibya k'ottem kwabọng abhari. ");
INSERT INTO mfo_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","Idikha ojinọng on-okhebh ominanwa kw'oni ojinọng otzim oronga k'obhon, kw'ojinọng ọdọdọk ochekhi bi ọtzọkha k'ọbada, yina, oyima ominanwa nwa abẹ, ");
INSERT INTO mfo_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","bọng akhaambi atzima bẹ achina k'ẹbaakhamma ch'obhon nwuma azọbh bẹ atza, maa bẹ ape, da ominannwa nwa oni amọng ọkpẹbhi ifha anọng akkaan-ẹ, ọmaana ojinọng da ọtzam ọsana oyima kwanọng ọdọdọk abẹ. Bọng akhaambi agbobhi ebibya k'ottem kwabọng abhari. ");
INSERT INTO mfo_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","Yina, idikha ode k'ẹkhọma ẹdọdọk dọ ch'ojinọng okhebh kwanọng kw'oyokhi-jinọng okk'ochekhi bi ọtzọkha k'ọbada, ọbọkh-ẹ oyima abẹ k'ẹfa, ojinọng nwa kw'osi odik nwa kẹ-kẹ wọ ope. ");
INSERT INTO mfo_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","Bọng kwanọng nwa ọttọhk kàsi, kkeri kẹ ottotto manda wani kw'ọbaan k'obo, kọkhaam. Aponga mba ade mach'aponga p'ọnọng orim oyokh-ibaanga abẹ, ọfhẹ-ẹ, ");
INSERT INTO mfo_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","okhuri bi, ojinọng nwa ore ominanwa nwa k'ẹhọhma ẹdọdọk, kaambi ode bi, ominanwa kwa bẹ akk'echekhi asa bi atzọkha, okk'amọng ọkpẹbha oror ẹkkaana, ọnọng kw'ọkkaan-ẹ kode. ");
INSERT INTO mfo_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","Idikha ojinọng ore ominanwa kw'oni ojinọng otzima oronga, kwa bẹ ani eyonga atzima abọbha bi atzọkh-ẹ k'ọbada, ọbọkh-ẹ k'ẹfa oyima abẹ, anọng arong odik nwa, ");
INSERT INTO mfo_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","kẹ ojinọng nwa ọnang otte kwa ominannwa nwa ashẹkẹl pa silva arọbh afa obhiri jobh, k'ẹrẹkhi ch'ọrẹkhi ominanwa nwa. Ojinọng nwa ominannwa nwa k'ọfha okhubh k'akpen pẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","Ọnọng kọ̀khaambi ọtzọkha kwanọng kw'otte kwẹ k'ọbada, kẹ kọ̀khaambi oyima kwanọng kw'otte abẹ. ");
INSERT INTO mfo_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","Ojinọng kwa bẹ abhaar-ọbhaar, obiro ode bi, bẹ arọbh-ẹ ijinọng for, kọ̀khaambi owobha k'ottem kw'anọng p'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","Nnwa kwa bẹ amaani da otte ọmaana ọkka ani ayok k'ọbada atzọk, obiro ode va pa va pabẹ, k'ẹkhaan ch'anọng p'Ọvaar Ibinọkpaabyi kafha attara, kaambi k'igbọ jobh s'íkwu k'ororo rọ. ");
INSERT INTO mfo_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","Anọng p'Amọn obiro ode pa Moab, yina ira on-ode va pa va pabẹ k'ẹkhaan ch'anọng p'Ọvaar Ibinọkpaabyi kafha attara, kaambi k'igbọ jobh s'íkwu k'ororo rọ. ");
INSERT INTO mfo_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","Okhuri bi, wa bẹ bọng ọchattọhk ọmaana asi k'ọkkadeden kànangi, mada bọng abin k'Ijip akhuna. Wa bẹ atza abher Balam kw'ode nnwa kwa Beor kw'ofon Pẹtọr k'ẹkhọma ch'Aram-Naharayim bi, ọnang bọng ẹmma. ");
INSERT INTO mfo_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","Kaambi mẹ wọ, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, itzọhng koyong ọnang Balam, ọn-ọbhakhi ẹmma nduma bi en-ede ẹdaa ẹnang bọng, okhuri da bọng adaakhi Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng idik. ");
INSERT INTO mfo_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","Bọng echekhi ch'iyok kàsi ọmaana bẹ, odem nwa kwa bọng achin ororo aruk akpen. ");
INSERT INTO mfo_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","Bọng k'ittattaanga kàruk ọmaana anọng p'Edom, okhuri da anọng p'Edom ade votte pabọng. Bọng k'ittattaanga kàruk ọmaana anọng p'Ijip, okhuri bi wa bọng arukhi k'ẹkhọma chabẹ mach'akhekhennọng. ");
INSERT INTO mfo_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","Igbọ ittaan sa va p'ámmaana kabẹ k'ottem, afha attar-ọttara k'ẹkhaan ch'anọng p'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","K'ogbe kwa bọng atza bi atza arima attattaanganọng pabọng abẹ, bọng tte ibibyadik biphyir s'isi bọng aningi awuri ọbọhk. ");
INSERT INTO mfo_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","Idikha ojinọng manda wani k'ottem kwabọng on-owuri otzor k'immaanadik, da ọttaabh ọda ọja adima, tte kẹ obina oji ibhingabe ọtza owobha k'iyaan. ");
INSERT INTO mfo_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","Yina, otzim bi opyiri ma nchọhkha-bọhk, kẹ ọkhaambi ogbobha asi, otzik ogbe kw'ewchen edimi, yina ọfha ọkpa nnam k'ibhingabe. ");
INSERT INTO mfo_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","Bọng dekha ibe rani k'iyaan-iyaan s'ibhingabe asi ewuchi, ifha ọnọng kw'obeni bi ọtza k'ẹpannam ochina kẹ. ");
INSERT INTO mfo_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","Bọng dima ẹtzọhmkpo pya bọng akhaam atzum ọmma, bọng akk'kẹpannam atzokpo, bọng abubha. ");
INSERT INTO mfo_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","Da Ọvaar Ibinọkpaabyi kw'ode Ibinọkpabyi kwabọng, om-orenga ọkhọri ibhingabe sabọng, ifha ọttọhk oningi bọng osi, obiro otte attattaanganọng pabọng ọbọhk ọnang bọng. Bọng akhaambi aruk akpen p'awur-owur k'ibhingabe sabọng, ifha kẹ oningi odik manda wani kw'opyibhi-opyibh kabọng k'ottem ore, kw'ọsẹ-ẹ ọkpa nnam ọbọra bọng. ");
INSERT INTO mfo_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","Idikha obira ọrọbhi okwu ojena bọng, bọng kẹ kàkhubh anang itta kwẹ. ");
INSERT INTO mfo_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","Tte kẹ oruk ọmaana bọng, k'ibe kpenamkpen s'idaakh-ẹ bi oruk, obiro ode k'obhon kpenamkpen kw'odaakh-ẹ. Bọng kẹ k'ihem kàhok. ");
INSERT INTO mfo_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","Ojinọng manda wani kw'ofon Israẹl, obiro ode kwanọng, kọkhaambi ode ọzaaza kw'ikha ọkpakpaanga. ");
INSERT INTO mfo_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","Bọng enanga ch'efon k'ọzaaza-kwanọng, obiro ode ọzaaza-jinọng kàtzima akwu k'ọhọhm kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, atzima atzuk ọnwọhngi kwa bọng atzọk, okhuri bi, nnanga dema nna mkpukhi Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, okpukhi. ");
INSERT INTO mfo_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","Bọng iru kàkhe k'ekpo pya bọng abhori ayokh-ammaana p'Israẹl, kaambi ode agbukha ode ọchattọhk, obiro ode ọttọhk kpenamkpen f'ira bọng afha achi iru. ");
INSERT INTO mfo_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","Yina, bọng afha atzọkha iru k'ekpo pya bọng abhori akhekhennọng, k'ayokh-ammaana p'Israẹl arang, ifha Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, odo bọng k'ọttọhk kpenamkpen fabọng atzim mbọhk sabọng asi, k'irerek nnuma sa bọng am-atza bi atza atzọkha akhaama. ");
INSERT INTO mfo_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","Idikha bọng atzọk ọwọhngi k'itzitzikha s'Ovaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, bọng ogbe kàkhibhi bi atzuk. Da Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, oni echuni ọkhaama bi, ọbọbh bọng, kw'ósi bọng akhaama ottotto kw'ẹkhọhngkwuri. ");
INSERT INTO mfo_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","Yina, bọng ani ọnwọhngi atzọk, bọng ottotto kákhaama. ");
INSERT INTO mfo_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","Odik kpenamkpen nwa kwa bọng atzim ẹmma chabọng anwọhngi, bọng akhaambi asi, okhuri bi bọng atzim ẹmma chabọng atzọkha ọnwọhngi nwa anang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng. ");
INSERT INTO mfo_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","Idikha bọng adimi k'iwoni sa grep s'ayokh-ibaanga pabọng, bọng afha achi agrep maa, bẹ abenga bọng, yina, bọng kàpha akhe k'okhiriba atzima afona. ");
INSERT INTO mfo_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","Idikha bọng adimi k'iwoni s'ayokh-ibaanga pabọng, bọng afha adungi achiduk, yina, bọng kàkhaambi atzima imaana s'ikọhng eho, akpaara ekpo py'ayok agboni. ");
INSERT INTO mfo_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","Idikha ojinọng obhumi kwanọng kw'ọtzọk k'ọbada, da ọnẹ-ẹ dọk ọdaakhi okhuri osisi kwẹ, ojinọng nwa ọkkẹr ẹnwẹrkpa ọnang kwanọng nwa ch'ẹkhọhk bi ọkk'ẹ obhuma, oben-ẹ obina k'ọhọhm kwẹ, ");
INSERT INTO mfo_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","idikha kwanọng nwa obin, ọn-ọtza ọba ojinọng ọdọdọk, ");
INSERT INTO mfo_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","osisi kwẹ ojinọng nwa kobiro ọdaak, ojinọng nwa obiro ọkkẹr ẹnwẹrkpa ọnang kwanọng nwa, ch'ẹkhọhk bi ọkk'ẹ obhuma, oben-ẹ obina k'ọhọhm kwẹ, obiro ode bi ojinọng nwa, ope-ope, ");
INSERT INTO mfo_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","mẹ wọ, ojinọng nwa kw'ode ocheden-dim kwẹ kw'obhum-ẹ, dọk kọkhaam bi obiro ọkpa-nnam ọtzọkha kwanọng nwa, da kwanọng nwa okk'ojinọng ọdọdok abẹ oyima. Odik nwa ode ọkhọhngkwuri-dik k'itzizikha s'Ọvaar Ibinọkpaabyi. Bọng ẹkhọhngkwuri kàtzima akwu k'irerek s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọnangi bọng mach'ekkema chabọng. ");
INSERT INTO mfo_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","Idikha ojinọng ọrami ọbada ọsa, bọng kàkhaambi atzọhm-ẹ egbọng, yina ira bọng ana anang-ẹ ọtzọhm kpenamkpen bi osi. Kẹ ọkhaambi owobha cho wani k'ọhọhm kwẹ, bọng kàkhaambi anang-ẹ ọtzọhm manda vani k'obhon bi, osi. Bọng akhaambi attẹ-ẹ ọbọhk, owobha k'ọhọhm osi ọdadaami ọnang kwanọng kwẹ ka cho wani. ");
INSERT INTO mfo_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","Idikha bọng abhori ọnọng ọttọhk, bọng atza pa bẹ am-atzima okhok abọkpa-mọma, kàtzọkha abhikha k'ọttọhk fabẹ abhori bọng, okhuri bi kwẹ on-ode mach'ọnọng ọtzọk akpen p'ọnọngẹya, obhikha k'ọttọhk f'obhori. ");
INSERT INTO mfo_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","Idikha bọng abọhk ọnọng kw'ofhu oyokh-ọmaana kw'Israẹl bi, ọsẹ-ẹ ọgbaan obiro ode bi ọkpẹ-ẹ ọnang k'ebira, kẹ nwuma kw'ofhu oyok ọkhaambi ope. Bọng akhaambi agbobhi ebibya k'ottem kwabọng abhari. ");
INSERT INTO mfo_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","Odik okhuri okkima, bọng dọkha ogbe asi mach'afọhnẹja p'ẹnọmma cha Lẹvi atzohni bọng. Bọng akhaambi atzọkha ogbe ahok ndọhna sa kaam nkk'bọng nnanga. ");
INSERT INTO mfo_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","Bọng jima odem kw'iwa Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, osi Miriyam k'okkadeden, k'ogbe kwa bọng akk'k'Ijip abina. ");
INSERT INTO mfo_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","Idikha abhori oyokh-ibaanga kwọ ọttọhk kpenamkpen, k'ọhọhm kwẹ kàdim bi, atza atzọkha ọttọhk f'otzim obhikha k'ọttọhk f'obhor-ọ. ");
INSERT INTO mfo_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","Be k'iyaan, ifha kẹ nwuma kw'abhori ọttọhk, otzima ọttọhk f'otzim obhikha k'ọttọhk f'abhor-ẹ, ọnang-ọ. ");
INSERT INTO mfo_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","Idikha oyokh-ibaanga nwuma osi ogbor, owura-baba kwẹ kw'otzim obhikha k'ọttọhk f'obhor-ọ kàhok maa, ewu ehobha. ");
INSERT INTO mfo_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","Kọ rik owura-baba nwa kwẹ k'ẹchọhkha, ifha oyokh-ibaanga kwọ otzim-ẹ obubha ka for da oyima. Mẹ wọ osi, bẹ árim-ọ, kwẹ óbiro óde ẹmmaana ch'etzor-otzor k'itzitzikha s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng. ");
INSERT INTO mfo_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","Ọnọng oningi ọnọng kw'obheri ọtzọhm kw'osi ogbor, ọbiro oruk k'owora ọkhara ore, ode bi ọtzọhm-nọng nwa ode oyokh-ọmaana kw'Israẹl, kaambi obiro ode okhekhennọng kw'orukhi k'obhon wani kwabọng. ");
INSERT INTO mfo_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","Kọ nang ọtzọhmnọng nwa agbukha pẹ p'ewu yina ewu ẹha, okhuri da osi ogbor, obiro ohok chen pẹ mẹ biphyir. Oni mando ode, bẹ afha abhom anang Ọvaar Ibinọkpaabyi k'osisi kwọ, kọ án-abira akhaama oponga-pyibha kw'ẹkhọngkwuri. ");
INSERT INTO mfo_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","Bọng ab'otte ttara ab'ọkka ka nho sa va kàfhu. Bọng va ka nho s'ab'otte ttara ab'ọkka kàbira afhu; kkeri ọnọng-ọnọng ópe k'ekhọhngkwuri chẹ. ");
INSERT INTO mfo_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","Bọng akhenkhennọng obiro ode apfu-va eponga-ttọhna ch'etzor-otzor kàbhum, bọng owura-baba kw'apopa-kwanọng kàtzọkha atzima abhikha k'ọttọhk fabẹ abhori. ");
INSERT INTO mfo_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","Bọng jima bi iwa bọng ade abira k'Ijip, yina, wa Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng obhek bọng ka mbọhk s'ebira. Kẹ wọ osi, kaam nnang bọng ndọhna nna bi, bọng ahok. ");
INSERT INTO mfo_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","K'ogbe kwa bọng asi ipha, bọng araama ekpo byani k'owoni, bọng nnam kàkpa bi abira atza apha pyẹ. Bọng tte pyẹ ọbọhk anang akhekhennọng, ọmaana apfu-va ttara apopa, ifha Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, odo itzọhm-bọhk sabọng biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","K'ogbe kwa bọng apha achiduk p'oliv k'iwoni sabọng, bọng nnam kàkpa bi abira atza apha achiduk p'arikhi. Bọng tte achiduk mba p'arikhi ọbọhk, anang akhekhennọng ọmaana apopa. ");
INSERT INTO mfo_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","K'ogbe kwa bọng asi ipha sa grep k'iwoni sabọng, bọng nnam k'iwoni kàkpa bi abira atza apha agrep p'arikhi. Bọng tte agrep p'arikhi anang akhekhennọng, ọmaana apfu-va ttara apopa. ");
INSERT INTO mfo_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","Bọng jima bi iwa bọng ade abira k'Ijip. Kẹ wọ osi, kaam nnang bọng ndọhna nna bi bọng ahok. ");
INSERT INTO mfo_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","Ogbe kw'anọng akhaam aponga, bẹ akhaambi atzima aponga mba achina k'osobh-họhm, ifha asi-aponga áttọhna anang bẹ, ọnọng kw'aponga an-apyibhi, bẹ attẹ-ẹ ọbọhk, ọnọng kw'aponga apyibh-ẹ bẹ abọkh-ẹ. ");
INSERT INTO mfo_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","Idikha ọnọng kw'aponga apyibhi ọbaan ka ngwur, ọsi-aponga oben bẹ akpẹ-ẹ k'irerek, attum-ẹ achiva m'itzitzikha sa kẹ ọsi-aponga, atzọr k'ọphaangi kw'ọnọng kw'aponga apyibhi, otto. ");
INSERT INTO mfo_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","Yina, ọsi-aponga kọkhaambi oben anọng bẹ attum ọnọng kw'aponga apyibhi achiva ayongi arọbh afa. Idikha bẹ attumi ọnọng kw'apong apyibhi achiva ayongi arọbh afa, mẹ wọ oyini bi, bẹ álukhi oyokh-ọmmaana kw'Israẹl olukhi. ");
INSERT INTO mfo_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","Bọng kàkhaambi adaabh ẹbhaam ẹmma, k'ogbe kwa chẹ em-ehok abọkpa-mọma. ");
INSERT INTO mfo_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","Idikha votte afa p'ijinọng arukhi k'ibe rani, oyok wani ope oji kwanọng kwẹ da oni nnwa kw'ijinọng otzima obhona, opopa kw'ope oji kọkhaambi ọtza ọba odim k'ẹhọhmmọr ẹdọdọk. Ọgbaanotte kw'orukhi akpen ọkhaambi ọ́tzọkha opopa nwa ọba, ifha orenga mẹ obhon nnwa otzera eho ch'ọgbaanotte, obiro okker-ẹ macha kwanọng kw'ọgbaanọtte. ");
INSERT INTO mfo_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","Ocheden-nwa kw'ijinọng kwa kwanọng nwa ọ́mmaan, ókpena che obhina ọgbaanotte kw'ọkk'ọpa, ifha che ch'oyok kw'ọkk'ọpa eningi k'Israẹl edimi. ");
INSERT INTO mfo_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","Idikha ọgbaanotte kw'orukhi akpen on-okher bi ọtzọkha opopa-kwanọng kw'ọgbaanotte ope oji, tte kwanọng nwa ọtza okhebha adedennọng k'ẹbakhama ch'obhon, ọgbaak bẹ bi, “Ọgbaanotte kw'odim kwaam kokher bi osi che ch'ọgbaanotte echina ororo k'Israẹl. Kẹ kokher bi ọtzọkh-m k'ọbada, macha kwanọng kw'ọgbaanotte.” ");
INSERT INTO mfo_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","Mẹ wọ, adedennọng p'obhon kwẹ áyeri ojinọng nwa, agbaakh-ẹ atzim. Idikha ochin ororo oben bi, “Kaam kinnori bi ndọkh-ẹ k'ọbada,” ");
INSERT INTO mfo_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","tte opopa-kwanọng nwa kw'ọgbaanotte órenga ọtza okhebh-ẹ m'itzitzikha s'adedennọng p'obhon, ọwọra ojinọng nwa ọkpaikkobho, obiro ọpyakh-ẹ attabọhng k'itzitzikha, oben bi, “Ma wọ ode odik kwa bẹ ási anang ọnang kw'ón-okhera bi, osi ẹhọhmmọr ch'ọgbaanotte echina ororo.” ");
INSERT INTO mfo_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","Anọng án-aronga ẹhọhmmọr ch'ojinọng nwa k'Israẹl, mach'ẹhọhmmọr ch'ojinọng kwa bẹ awọr ọkpaikkobho. ");
INSERT INTO mfo_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","Idikha ajinọng afa arim erima, kwanọng kw'oyok wani okwu bi okwu ọkkaana odim, onemi ọbọhk kwẹ ọbọkha ojinọng nwonggo k'ijinọng for sẹ, ");
INSERT INTO mfo_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","bọng akhaambi ákpaara kwanọng nwa ọbọhk. Bọng nkwosisi kàkhaama ttar-ẹ. ");
INSERT INTO mfo_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","Bọng ekpo adem afa pya bọng am-atzima ayoma ekpo ka mkpa sabọng, kàtzima, vani f'ọdọhbh-ọdọhbh, mvonggo f'obhekh-obhekhi. ");
INSERT INTO mfo_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","Bọng ekpo adem afa pya bọng am-atzima ayoma ekpo k'ihọhm sabọng, kàkhaama, vani f'ọbar-ọbar, mvonggo f'ọkhar-ọkhara. ");
INSERT INTO mfo_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","Bọng akhaambi akhaama ekpo pya bọng am-atzima ayoma ekpo ẹkkakka py'etzor-otzor, ifha bọng afha aruk akpen p'adumi eden k'irerek s'Ọvaar Ibinọkpaabyi, kwọde Ibinọkpaabyi kwabọng ọnangi bọng. ");
INSERT INTO mfo_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","Da anọng p'am-asi idik nna atzima asi ayok chen, akpukhi Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng idik okpukhi. ");
INSERT INTO mfo_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","Bọng jima odik kw'iwa anọng p'Amalẹk asi bọng k'okkadeden, k'ogbe kwa bọng abin k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","K'ogbe kw'iwa okk'bọng ọkhọna ẹfa ebire ẹha bọng, wa bẹ ayin bọng abẹ k'orenga kwabọng asi, abira arima bọng ayok bani p'iwa ẹfa ẹkk'ẹha p'awobh ayok ka nnaam-anaam abẹ. Wa bẹ ojora f'Ibinọkpaabyi kakhaam. ");
INSERT INTO mfo_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","K'ogbe kwa Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ónang bọng ẹwọhngkhwokha k'attattaang-nọng p'arukhi akhọri bọng k'irerek s'ọnangi bọng bi, bọng akhaama mach'ekkema chabọng, bọng akhaambi ádimi che ch'anọng p'Amalẹk m'ọyagbin. Bọng kàraama o! ");
INSERT INTO mfo_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","K'ogbe kwa bọng akk'apyiri k'irerek s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọnangi bọng, mach'ekkema chabọng, bọng akk'sẹ atzọkha akhaama abira aruk mẹ, ");
INSERT INTO mfo_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","bọng dọkha icheden-pha s'ọttọhk kpenamkpen fa bọng ayaabh k'irerek nna s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọnangi bọng, akhe k'ikhiriba. Bọng akk'mando asa, bọng dini ekpo mbya m'ikhiriba atzima achina k'ibe s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ótzekha mach'ibe sa bọng awobha akpobha che chẹ. ");
INSERT INTO mfo_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","Bọng aben ọfọhneja kw'ogbe nwuma bi, “Kaam nkk'nkwa bi nkwu nsi ẹjaakhi nang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng bi, kaam nkk'mpyiri k'irerek nna s'iwa Ọvaar Ibinọkpaabyi ochekhi bi, ọnang ab'atte pamaan bi ọnang man.” ");
INSERT INTO mfo_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","Ọfọhnẹja nwuma ọ́tzọkha ikhiriba nnuma ka mbọhk sọ obera k'irerek, m'itzitzikha s'ijafọhnibe s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng. ");
INSERT INTO mfo_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","Mẹ wọ osi, bọng ási ẹjaakhi m'itzitzikha s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng bi, “Iwa otte kwaam ode ọnọng kw'ofon Aram, wa kẹ otzim anọnọnga mẹ bi kọbh ochina k'Ijip ọtza oruk kẹ, bẹ an-ade ẹkhọma ch'ideden, ch'ẹkhaam ẹfa ebire ẹhaabh anọng. ");
INSERT INTO mfo_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","Yina, wa anọng p'Ijip asi man ọgbaan, atzọkha man akhe k'ihem am-anang man itzọhm s'igaang-ọgaangi. ");
INSERT INTO mfo_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","Mando kw'am-obhomi oyeri Ọvaar Ibinọkpaabyi, kw'ọde Ibinọkpaabyi kw'ab'otte paman, wa Ọvaar Ibinọkpaabyi ọbhaanga ẹmọng cha m'obhomi, ore ọmmamma ttara ikhem saman. ");
INSERT INTO mfo_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","Wa Ọvaar Ibinọkpaabyi orenga k'ẹfa ch'ọbọhk kwẹ, otzima man mobina k'Ijip, k'ikkokkoni-dik ọmaana k'ijora-dik s'ideden, ọmaana ka ngọhkha ttara k'idik s'ipe anọng fọr. ");
INSERT INTO mfo_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","Wa otzima man okwu m'ibe nna, ọnang man irerek nna s'ifhu ttara abasi ọmaana akhọkhọnana; ");
INSERT INTO mfo_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","ma, mon-otzim icheden-pha s'ekpo py'irerek nna, sa kọ Ọvaar Ibinọkpaabyi akk'man ananga, ochen-ọ.” Bọng bera ikhiriba nna m'itzitzikha s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabong, attima ndudungi mẹ. ");
INSERT INTO mfo_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","Bọng biphyir ọmaana ab'aLẹvi ttara akhekhenọng p'arukhi ọmaana bọng, ási ọdadaami k'idik-jibhada biphyir s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, okk'bọng ọnanga ọmaana nhọhmmọr sabọng. ");
INSERT INTO mfo_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","Bọng akk'akyera bi, bọng atzekha ọttọhk vani k'ekpo jobh k'ipha sabọng ka cho kw'ottong attaan ahok, kw'ode cho kw'ẹnanga ch'ọttọhk vani k'ekpo jobh, bọng átzọkha pyẹ ánang ab'aLẹvi, ọmaana akhekhennọng ọmaana apfu-va ttara apopa, ifha bẹ afha akhaama ọchattọhk fa bẹ achi adọhbh ka bọng k'ibhon. ");
INSERT INTO mfo_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","Mẹ wọ kọ aben Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwọ bi, “Kaam nkk'ẹnaanga ch'ede chọ nnọbha, ndọkha nnang abaLẹvi ọmaana akhekennọng ọmaana afu-va ttara apopa, ndor k'odem kw'akk'aam abena. Kaam nkk'asana pọ biphyir nkhokha, manda wani kwa nnaam kode. ");
INSERT INTO mfo_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","Kaam ẹnaanga manda dani kinchi mada nwobh ka nkwosisi, yina ira nna nnọbh ọttọhk manda vani k'ekpo mbyuma, mada kaam nni nwuri ndor k'immaana-dik, yina ira kaam nna mbiri ndọkha pyẹ nnang apfura-nọng. Kaam nkk'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaam ikpokpobha nnanga; kaam nkk'ọttọhk kpenamkpen fa aben-m bi nsi, nsa. ");
INSERT INTO mfo_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","Wobha k'ẹrọng kw'ode irukhabe sọ s'iwur-owur, ado anọng pọ p'Israẹl, abira ado irerek s'akk'man ananga s'ifhu ttara abasi ọmaana akhọkhọnana, mach'iwa anwọhngi achekhi anang ab'otte paman.” ");
INSERT INTO mfo_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng okk'bọng ọtzọhna k'ewu cha mayina bi, bọng ahakha nho anang akpebhi ọmaana aphaangi mba, bọng dọkha ogbe ahok bẹ, ttara nttem sabọng ọmaana agbagba pabọng biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","Bọng akk'ẹjaakhi asa k'ewu cha mayina bi, Ọvaar Ibinọkpaabyi wọ ode Ibinọkpaabyi kwabọng, bọng abira akhera bi bọng eho k'agangi atzima atzor-ẹ, ọmaana bi bọng áhakha eho ọhakha anang asana omaana akpebhi ttara aphaangi pẹ, ttara bi bọng ábira ayonga itzọhng oyonga anang-ẹ. ");
INSERT INTO mfo_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","K'ewu cha mayina, Ọvaar Ibinọkpaabyi okk'ẹjaakhi ọsa bi, bọng ade anọng pẹ, bọng ade ekkema chẹ ch'ohokhi ettem, mach'iwa okk'ochekhi, ọmaana bi, bọng ahok asana pẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","Kẹ okk'ẹjaakhi ọsa bi, kẹ ọtzini bọng k'ẹrọng k'ikpokpobha ọmaana k'abarada ttara ẹtzọhnga, ayọhnga idibhon sa kẹ ọkk'ọsa, ọmaana bi, bọng áde anọng p'okk'otzekha ọnang for sẹ, mach'iwa kẹ okk'ochekhi. ");
INSERT INTO mfo_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","Iwa Mosẹs ọmaana adedennọng p'Israẹl atzọhni anọng mba bi, “Bọng hok asana mba biphyir pa nnangi bọng mayina. ");
INSERT INTO mfo_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","Bọng akk'ọraanga kwa Jọrdan ajekha apyiri k'irerek nna s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ọnangi bọng, bọng attima atza bani p'ideden, bọng atzima idọdọhbh akpan bẹ. ");
INSERT INTO mfo_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","Bọng akk'ajekha apyiri k'irerekh s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọnangi, s'ide irerek s'ifhu ttara abasi ọmaana akhọkhọnana, bọng kkẹr atzim p'aphaangi mba biphyir k'atza mba, atzor k'odem kw'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kw'ab'atte, ochekhi ọnang bọng. ");
INSERT INTO mfo_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","K'ogbe kwa bọng akk'ọraanga kwa Jọrdan ajekha, bọng ttima atza mba k'egbegbeho ch'Ẹbal, macha kaam ndọhni bọng mayina, bọng abira atzima idọdọhbh akpan bẹ. ");
INSERT INTO mfo_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","Bọng dima atza asi ijafọhnibe mẹ anang Ọvaar Ibinokpaabyi, kw'ode kw'ode Ibinọkpaabyi kwabọng. Bọng ọtzọhm-ttọhk manda vani f'ode okkonga kàtzima agwa atza mba. ");
INSERT INTO mfo_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","Bọng dima atza pa bẹ ani ọkpakpaar-akpaar, asi ijafọhnibe s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, bọng si nnaanga-kwọmisẹ mẹ, anang Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng. ");
INSERT INTO mfo_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","Bọng si njafọhni sa nnanga s'odidiri abira achi sẹ mẹ. Bọng asi ọdadaami mẹ, k'itzitzikha s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng. ");
INSERT INTO mfo_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","Bọng akkẹr atzim p'aphaangi mba biphyir bẹ atto bi taaan, m'atza mba pa bọng akk'attima.” ");
INSERT INTO mfo_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","Iwa Mosẹs omaana afọhnẹja p'ẹnọmma cha Lẹvi, agbaak anọng biphyir p'Israẹl atzim, aben bi, “Anọng p'Israẹl o, bọng myi bi sẹẹbh, ayonga itzọhng abhaanga e! Bọng akk'anọng p'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ada, k'ewu cha mayina. ");
INSERT INTO mfo_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","Mẹ wọ ofon, bọng akhaambi ahakha nho anang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, bọng ahok asana ọmaana akpebhi biphyir, pa kaam nnangi bọng k'ewu cha mayina.” ");
INSERT INTO mfo_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","Mẹ ewu nduma dani, Mosẹs ọtzọhn anọng mba bi, ");
INSERT INTO mfo_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","K'ogbe kwa bọng akk'ọraanga kwa Jọrdan ajekha, nnọmma sa mbe k'egbegbe cha Gerizim ndo anọng nde: Simeọn ọmaana Lẹvi ọmaana Juda ọmaana Isaaka ọmaana Josẹph ttara ẹnọmma cha Bẹnjamin. ");
INSERT INTO mfo_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","Nnọmma sa mbe k'egbegbeho ch'Ẹbal nnang anọng ẹmma nde: Reubẹn ọmaana Gad ọmaana Ashẹr ọmaana Zẹbulun ọmaana Dan ttara ẹnọmma cha Naphtali. ");
INSERT INTO mfo_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","Anọng p'ẹnọmma cha Lẹvi asi ẹjaakhi k'ẹrọng anang anọng p'Israẹl biphyir, aben bi: ");
INSERT INTO mfo_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","“Opyibh-opyibh ọnang ọnọng kpenamkpen kw'ọgwa ọgbatza kw'ode emengkka ch'otzetzekha, obiro ode ọttọhk f'okpukhi Ọvaar Ibinọkpaabyi okpukhi, ọtzọkh-ẹ ottima k'ichubha.” ");
INSERT INTO mfo_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","“Opyibh-opyibh ọnang ọnọng kpenamkpen kw'ọrẹkhi otte ọmaana ọkka.” ");
INSERT INTO mfo_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","“Opyibh-opyibh ọnang ọnọng kpenamkpen kw'ọrokhi ọtza kw'enem kw'oyokh-ibaanga kwẹ.” ");
INSERT INTO mfo_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","“Opyibh-opyibh ọnang ọnọng kpenamkpen kw'otzim okpa-chechena ottena eden.” ");
INSERT INTO mfo_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","“Opyibh-opyibh ọnang ọnọng kpenamkpen kw'ọrami okhekhennọng ọmaana opfu-nwa ttara opopa, eponga-ttọhna ch'etzor-etzor. ");
INSERT INTO mfo_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","“Opyibh-opyibh ọnang ọnọng kpenamkpen kw'oyim kwanọng kw'otte kwẹ abẹ.” ");
INSERT INTO mfo_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","“Opyibh-opyibh ọnang ọnọng kpenamkpen kw'oyim etzen kpenamkpen abẹ.” ");
INSERT INTO mfo_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","“Opyibh-opyibh ọnang ọjinọng kpenamkpen kw'oyim ọgbaanotte kw'ikwanọng abẹ, ode nnwa kw'otte kw'ikwanọng, obiro ode nnwa kw'ọkka kw'ikwanọng.” ");
INSERT INTO mfo_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","“Opyibh-opyibh ọnang ojinọng kpenamkpen kw'oyim ọkka kwa kwanọng kwẹ, abẹ.” ");
INSERT INTO mfo_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","“Opyibh-opyibh ọnang ọnọng kpenamkpen kw'ofhu oyokh-ibaanga kwẹ k'ichubha.” ");
INSERT INTO mfo_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","“Opyibh-opyibh ọnang ọnọng kpenamkpen kw'ochi ngwu bi, ofhu ọnọng kw'aponga ajibhi.” ");
INSERT INTO mfo_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","“Opyibh-opyibh ọnang ọnọng kpenamkpen kw'oni atzim p'aphaangi mba ọbọk otzim bi, osi macha bẹ abeni.” ");
INSERT INTO mfo_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","Idikha bọng ahak nho sabọng biphyir-phyir anang Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, bọng abira atzọkha ogbe ahok asana pẹ biphyir, pa nnangi bọng mayina. Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ósi bọng abar ayọhnga idibhon s'ọyagbin biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","Idikha bọng ahak nho sabọng anang Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ndaa nna biphyir ńde sabọng, sẹ mbiri nwobha ttara bọng: ");
INSERT INTO mfo_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","Ẹdaa éwobha ẹnang bọng k'odeden-mon kwabọng, ọmaana k'ẹkhọma chabọng. ");
INSERT INTO mfo_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","Bọng ákhaama ẹdaa cha va, ọmaana ch'ekpo pya bọng ayaabh k'irerek sabọng, ọmaana k'etzirakpo pyabọng, va p'abhaam ọmaana va p'arukhimaan pabọng an-ahaabh-ọhaabh. ");
INSERT INTO mfo_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","Ẹdaa éwobha ọmaana okhiriba fabọng f'achiduk, ọmaana ọgbaakha kwa bọng am-atzima abhakhi brẹd. ");
INSERT INTO mfo_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","Ẹdaa éwobha ọmaana bọng k'ogbe kwa bọng atza itzọhm sabọng, ọmaana k'ogbe kwa bọng akhun itzọhm. ");
INSERT INTO mfo_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","Ọvaar Ibinọkpaabyi ósi bi, bọng akhema attattaanga-nọng p'abin bi, arima bọng abẹ. Bẹ árenga k'eden dani akwu erima, an-arenga ka nden nzenamfa arọbh afona. ");
INSERT INTO mfo_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","Ọvaar Ibinọkpaabyi ódo ọkhaanga-họhm fabọng ọttara ọchattọhk, ọmaana ọtzọmbọhk kpenamkpen fabọng asi. Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ódo bọng k'irerek s'ọnangi bọng. ");
INSERT INTO mfo_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","Idikha bọng ahokhi asana p'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, bọng abira ahakha nho anang-ẹ, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ottima bọng aranga mach'anọng pẹ p'awur-owur mach'ọnwọhngi ochekhi ọnang bọng. ");
INSERT INTO mfo_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","Mẹ wọ osi, anọng p'idibhon s'ọyagbin biphyir áre bi, bọng ade anọng p'Ọvaar Ibinọkpaabyi okk'otzekha, órenga mẹ, bọng áde anọng pa ájora bẹ. ");
INSERT INTO mfo_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","Ọvaar Ibinọkpaabyi ódo bọng ttara ẹkhakhaama k'ọhaabh. Ódo mmọr sa panọng pabọng, ọmaana mmọr s'etzirakpo pyabọng, óbiro ódo ekpo pya bọng áyaabh k'irerek sabọng, s'iwa kẹ Ọvaar Ibinọkpaabyi ochekhi bi, ọnang ab'atte. ");
INSERT INTO mfo_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","Ọvaar Ibinọkpaabyi ókwunga amma p'ọkhaanga-họhm kwẹ kw'ikkọ k'ẹrọng, otzebh ẹrọng k'irerek sabọng k'ọrọng-gbe, óbiro ódo itzọhmbọhk sabọng biphyir. Bọng ábhor idibhon haabhada ekpo, yina, bọng k'obhon manda wani k'abhor. ");
INSERT INTO mfo_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","Idikha bọng ayong itzọhng anang k'asana mba pa kaam nnangi bọng k'ewu cha mayina, p'ade asana p'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, bọng abira atzọkha ogbe ahakha nho anang bẹ, Ọvaar Ibinọkpaabyi ósi bọng ade aho p'idibhon, bọng awọr-ẹwọr káde. ");
INSERT INTO mfo_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","Bọng nnam kàkpa abọra asana kpenamkpen pa kaam nnangi bọng mayina, bi bọng atten achina k'odimbọhk obiro ode ka kwabọhk, bi bọng an-átzọn ikha abẹ abira akpobha sẹ. ");
INSERT INTO mfo_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","Yina, idikha bọng ani eho ahak anang Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, bọng itzọhng kabira ayonga anang asana ọmaana akpebhi pa kaam nnangi bọng mayina, idik nna biphyir ítto íkhebha bọng. ");
INSERT INTO mfo_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","Ọ́pyibh-opyibh ọ́nang bọng k'odeden-mon kwabọng ọmaana k'ẹkhọma chabọng. ");
INSERT INTO mfo_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","Ópyibh-opyibh ọnang okhiriba f'achiduk pabọng ọmaana ọgbaakha kwabọng kwa brẹd. ");
INSERT INTO mfo_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","Ópyibh-opyibh ọnang va pabọng ọmaana ekpo pya bọng ayaabh k'irerek sabọng, ọmaana va p'abhaam ttara p'arukhimaan pabọng. ");
INSERT INTO mfo_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","Ópyibh-opyibh ọnang bọng k'ogbe kwa bọng abin k'ihọhm sabọng, ọmaana k'ogbe kwa bọng akpa nnam k'ihọhm sabọng. ");
INSERT INTO mfo_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","Ọvaar Ibinọkpaabyi ọ́tzọhm itzama ochena bọng, ọmaana damadama ttara ọmmamma k'ọttọhk kpenamkpen fa bọng atzim mbọhk sabọng asi maa, bọng adimi ẹranga biphyir-phyir, k'epyibya cha bọng akk'asa, da bọng akpa nnam abọr-ẹ. ");
INSERT INTO mfo_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","Ọvaar Ibinọkpaabyi ótte ikhọmana s'ideden ọbọhk imma bọng maa, odimi bọng emeni k'irerek nnuma sa bọng am-achina bi atza atzọkha mach'ekkema chabọng. ");
INSERT INTO mfo_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","Ọvaar Ibinọkpaabyi ótte ikhọmana-tzama obọhk imma bọng, ọmaana otzikhi-tzikhi ọmaana abira-kpo ọmaana owu-khọma kw'óyin bọng ajaabhi ka fọr, ọmaana ekpekhira ch'ẹgaangi-ọgaangi, ch'efhu ekpo pya bọng bọng ayaabh k'iwoni sabọng. Kẹ ótte idik nna ọbọhk itto ikhebha bọng maa, bọng adimi biphyir-phyir. ");
INSERT INTO mfo_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","Ẹrong ẹ́kwọbha k'irerek sabọng otzetzebh, mẹ wọ ósi, irerek sabọng in-igaangi mach'okkonga. ");
INSERT INTO mfo_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","Ọvaar Ibinọkpaabyi ọn-ọ́bhakhi ẹrong ch'ira etzebh k'ẹkhọma chabọng en-ede ọkpọhm ọmaana oyeyeng. kw'ófona k'ọrọngkpakpa otzebh bọng maa, bọng adimi emeni biphyir-phyir. ");
INSERT INTO mfo_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","Ọvaar Ibinọkpaabyi otte attattaanga-nọng pabọng ọbọhk, bẹ akhema bọng. Bọng árenga eden dani atza arima bẹ abẹ, yina, bọng an-arenga ka nden nzenamfa arọbh afona. Mẹ wọ́ osi, bọng án-ade ojora-dik k'ọtzitzikha f'idibhon s'ọyagbin bi waam. ");
INSERT INTO mfo_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","Abukhi pabọng án-ade ọchattọhk anang ọnọhn f'erọng ọmaana nkkakkaama-tzen, ọnọng manda wani kw'ókhubh pyẹ kóde. ");
INSERT INTO mfo_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","Ọvaar Ibinọkpaabyi ótte aphyi p'iwa amma anọng p'Ijip ọbọhk bẹ amma bọng, ọmaana ndem s'ikhomi eruk ọmaana ajaabhi p'ikhina an-aha. ");
INSERT INTO mfo_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","Ọvaar Ibinọkpaabyi ósi bọng ade atzubh-etzetzena ọmaana akpa-chechena ttara anọng p'awori achibhi. ");
INSERT INTO mfo_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","Bọng áttena k'ọyakpattem mach'ọnọng kw'okpa chen otten k'erungi. Ọttọhk mada vani fa bọng ási, f'ọbaanga bọng efu kóde, k'iwu k'iwu anọng ahok bọng k'ikhem, bẹ abira ábọkha bọng ekpo ana, ọnọng kw'okkaana bọng k'óde. ");
INSERT INTO mfo_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","Kọ ádo for bi atzọkha kwanọng, yina, ojinọng ọdọdọkh ọ́tzọkh-ẹ oyima abẹ k'ẹfa. Kọ ási ọhọhm, yina, k'ọhọhm kw'asi káyima. Kọ áyaabh owoni kw'agrep, yina, ochiduk kw'ofon m'owoni nwuma káchi. ");
INSERT INTO mfo_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","Bẹ áyẹk ẹbhaam chọ ekhokhora m'itzitzikha sọ, yina, etzen chẹ manda dani ch'ẹttọhm-ọ k'ẹmma kede. Bẹ abọkh-ọ ẹnyanyaang chọ k'ẹfa ana, bẹ kárik. Bẹ átzọkha arukhimaan pọ anang attattaanga-nọng pọ, ọnọng kw'ọ́kkaana bẹ ọnang-ọ kóde. ");
INSERT INTO mfo_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","Bẹ ábọkha va pọ p'ijinọng ọmaana p'ipanọng anang obhon ọdọdọk. Am-átzima chen-chen akke aror bẹ k'ewu kpenamkpen, yina bẹ kàre. ");
INSERT INTO mfo_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","Anọng p'an-arong bọ áchi ekpo py'owoni kwọ, kọ ọttọhk manda vani dọk kàkhaama, oyongi ikhem-barada s'an-awobha k'akpen pọ biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","Idik s'ikhebh-ọ, ísọ-ọ akher otzubh-etzennọng. ");
INSERT INTO mfo_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","Ọvaar Ibinọkpaabyi ótte aphyi ọbọhk bẹ ammọ-ọ ttẹwọr ka ndudungi ma apyiri ka mmo maa, akhọra for biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","Ọvaar Ibinọkpaabyi ọ́tzọhm bọbọng omaana ọvaarnọng kwa bọng atzek bi odaabh bọng, k'ẹkhọma cha bọng an-arọng, kaambi ab'atte bọ. Kẹ kwa bọng ákpobha ikha, ikha sa bẹ atzim nchi ọmaana atza agwa. ");
INSERT INTO mfo_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","Ka ngọma nnuma s'Ọvaar Ibinọkpaabyi okhubh bọng ochina, bọng án-ade ọhammadik k'anọng mba k'itzitzikha da okkoni bẹ k'idik s'itto ikhebha bọng. ");
INSERT INTO mfo_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","Bọng ágbon ekpo k'ọhaabh k'iwoni sabọng, yina, ipha sabọng k'eden kìyin, ọkhuri da agwuribhebhe achi pyẹ. ");
INSERT INTO mfo_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","Bọng áyaabha iwoni sa grep, yina, bọng atzuk pẹ kàgwo yina ira bọng an-abira adungi aduk pẹ, okhuri bi afhoni áchi bẹ ochi. ");
INSERT INTO mfo_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","Bọng ákhaama nchi s'oliv makhọra ẹkhọma chabọng, yina, bọng anna p'oliv kàkhaama, okhuri bi aduk pẹ ákkini-okkini biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","Bọng ábhon va p'ijinọng ọmaana p'ipanọng, yina, bọng bẹ kàkhaama, anọng ábọkha bẹ biphyir k'ẹmọri, atzima afona. ");
INSERT INTO mfo_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","Ẹkhaan ch'agwuribhebhe échi nchi ọmaana achiduk pabọng biphyir, ọmaana ekpo pya bọng ayaabh k'iwoni sabọng. ");
INSERT INTO mfo_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","Akhekhen-nọng p'arukhi k'ottem kwabọng, án-akhaama ikkọ ayọhnga bọng, yina, bọbọng am-china ororo ahakha irekhirek. ");
INSERT INTO mfo_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","Bẹ ábhor bọng ekpo, yina, bẹ ekpo kabọng kàbhor. Bẹ áde bọng aho, yina, bọng áde bẹ awọr-ẹwọr. ");
INSERT INTO mfo_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","Idikha bọng abhumi bi ayonga itzọhng anang Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọmaana bi bọng nho kahak anang asana pẹ, ọmaana akpebhi pẹ, idik nna biphyir ítto ikhebha bọng. Sẹ itzọn bọng abẹ k'ibe kpenamkpen sa bọng atza maa, sẹ idimi bọng biphyir-phyir. ");
INSERT INTO mfo_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","Idik nna íde ẹkhọhkha ọmaana okkokkoni-dik, inang bọng ọmaana va pa va pabọng maa, ogbe ode. ");
INSERT INTO mfo_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","Bọng Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng kakpobh k'ettem obungichẹ k'ogbe kw'ojibhi bọng. ");
INSERT INTO mfo_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","Mẹ wọ osi, bọng átzima okwo ọmaana isi-dadakha ọmaana irinikhum ttara ogbor, asi obira-tzọhm anang attattaanga-nọng p'Ọvaar Ibinọkpaabyi ọtzọhmi ọnang bọng. Kẹ óhok bọng k'ikhem maa, bọng adimi biphyir-phyir. ");
INSERT INTO mfo_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","Ọvaar Ibinọkpaabyi ótzọhm ekhọma ẹdọdọk ch'efon k'odenmir erima bọng abẹ, tzọni k'okpong kw'ọyagbin, mach'ikye-nọhn ihak, ẹkhọma ch'ẹmmaana chabẹ eni bọng ẹttaani, ");
INSERT INTO mfo_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","ẹkhọma nduma ch'ikkekkeri sẹ ijor-ojora ch'eni anọng p'atzami-ọtzam ikpokpobha ẹnangi, inọngkwo k'ẹkhaam ẹnang igbọ. ");
INSERT INTO mfo_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","Bẹ áchi va p'etzirakpo pyabọng ọmaana ekpo pya bọng ayaabh k'irerek sabọng maa, bẹ adimi bọng. Bẹ átzọkha abọkpa pabọng ọmaana atzuk abhapẹ ttara ana p'oliv ọmaana abhaam ttara arukhimaan pabọng k'ọhaabh maa, bọng adimi biphyir-phyir. ");
INSERT INTO mfo_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","Bẹ áyima ákhọri idedenmon sabọng biphyir makhọra irerek sabọng maa, abaakha gaang-angaang pa bẹ aphe nnam atto. Bẹ áyima akhọri idedenmon biphyir s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng okk'bọng ọnanga. ");
INSERT INTO mfo_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","Ofona k'ihem s'attattaanga-nọng pabọng ánang bọng, k'ogbe kwa bẹ akhọri ibhon sabọng akhe k'ottem, bọng áchi va pabọng p'ijinọng ọmaana p'ipanọng, p'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọkk'bọng ọnanga. ");
INSERT INTO mfo_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","Kaambi ojinọng kw'odiri ẹmmaana ọbiro ode kw'idik ikk'ttaani k'ottem kwabọng wọ, nkwosisi kọ́khaama ọmaana ọgbaanọkka kwẹ, kaambi kwanọng kwẹ kw'ọdakh-ẹ ọdaak wọ, ttara va pẹ p'atzima arukhi akpen, ");
INSERT INTO mfo_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","kẹ ayaara pa nden s'ifon ka va pẹ s'om-ochi, nnwa manda wani kw'ọ́nang kóde. da ode va mba bẹ-bẹ p'ọn-ọkhaam k'ọyagbin, okhuri k'ikhem s'attattanganọng pabọng, ánang bọng k'ogbe kwa bẹ akhori idedenmon sabọng biphyir akhe k'ottem. ");
INSERT INTO mfo_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","Kaambi kw'anọng kw'odiri ẹmmaana ọbiro ode kw'idik ikk'ttaani k'ottem kwabọng wọ, idik ittaan-ẹ obiro odiri ẹmmaana maa, ebhokpatzọkhi chẹ k'irerek k'ẹttọhmi, kẹ ọ́ttaanga ọnang odim kwẹ kw'ọdaakh-ẹ ọdaak ttara va pẹ p'ijinọng ọmaana p'ipanọng, ");
INSERT INTO mfo_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","om-ochi va p'ọkk'ọmmaana ọmaana p'ọrami ọmmaan k'ichubha okhuri okwo. Kẹ ósi odik nwa k'adubhama, okhuri ikhem s'attattaanganọng ánang bọng k'ogbe kwa bẹ akhọri bọng akhe k'ottem. ");
INSERT INTO mfo_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","Idikha bọng ani ogbe atzọkh atzọhn atzim p'aphaangi mba abẹ p'awobh ma nnwẹr nwa, idikha bọng ani ẹvaar ọmaana ikpokpobha-che ch'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng akpobh, ");
INSERT INTO mfo_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","kẹ Ọvaar Ibinọkpaabyi ọ́tzọhm itzama s'ijor-ojora ọnang kọ ọmaana va pa va pọ, itzama s'ifu ttara ọmmaamma kw'odumi eden, ọmaana ikhọmama s'ideden ọmaana s'idumi eden. ");
INSERT INTO mfo_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","Kẹ obiro ótte ikhọhmana jor-anjor nna s'iwa imma anọng p'Ijip ọbọhk, ibiri imma bọng. ");
INSERT INTO mfo_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","Kẹ Ọvaar Ibinọkpaabyi óbiro otte ikhọhmana k'adem-k'adem ọbọhk imma bọng, ọmmamma kw'oni ma Nnwẹr nwa kw'Aphaangi ode maa, bẹ adimi bọng biphyir-phyir. ");
INSERT INTO mfo_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","Bọbọng p'iwa akk'ahaabha macha ndodori sa nwobh k'ọrọngkpakpa, an-arik anọnọnga, okhuri da bọng ani nho ahak anang Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng. ");
INSERT INTO mfo_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","Odem nwa kw'ọdaakhi Ọvaar Ibinọkpaabyi k'ettem bi osi bọng ayin k'eden, ttara bi obiro osi bọng ahaabh-ọhaabh, mando kwa kwẹ óbiro ọdaakh-ẹ bi, odimi bọng biphyir-phyir. Kẹ ódimi bọng emeni biphyir-phyir k'irerek nnuma sa bọng am-adim bi atza atzọkha mach'ekkema chabọng. ");
INSERT INTO mfo_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","Mẹ wọ osi, Ọvaar Ibinọkpaabyi ósi bọng araami makhọra idibhon, tzọni k'íttẹwọr s'ọyagbin maa, apyiri k'okpong. Mẹ kwa bọng akpobha ikha, ikha sa bẹ atzim nchi ọmaana atza agwa, sa bọbọng yina ira on-ode ab'atte an-arong. ");
INSERT INTO mfo_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","Bọbọng ẹmẹm kákhaama m'idibhon nnuma, bọng iwọhng-kwokhabẹ kákhaama. Mẹ kw'Ọvaar Ibinọkpaabyi osi nttem nnyak bọng atzim, chen-ohokhok kwabọng odimi, bọng ẹwọhngkwokha ka nttem kábira akhaama. ");
INSERT INTO mfo_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","Akpen pabọng an-ayaak ọyaak, bẹ an-afu ttara ojora k'ẹya ọmaana k'erungi, bọng ororo ochichina k'akpen dọk kakhaama. ");
INSERT INTO mfo_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","K'ekpebha bọng am-aben bi, “Idikha ira ode ẹchọhkha, opyiri k'ẹchọhkha, bọng aben bi, idikha ira ode ekpebha.” Okhuri ojora fa ofhu bọng ka nttem, ọmaana idik sa chen pabọng áre. ");
INSERT INTO mfo_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","Ọvaar Ibinọkpaabyi ọ́tzọhm bọng k'anzurikkaang bọng akpa nnam k'Ijip, orenga kw'iwa mbeni bi, bọng aningi dọk asi. Mẹ kwa bọng ákpe for sabọng ánang attattaanga-nọng pabọng, mach'abira p'ipanọng, yina, ọnọng kw'ódebh bọng kóde., kóde. ");
INSERT INTO mfo_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","Ma wọ ode atzim p'echekhi ch'Ọvaar Ibinọkpaabyi ọtzọhni Mosẹs bi, osi ọmaana anọng p'Israẹl k'ẹkhọma cha Moab, attar k'echekhi ch'iwa Ọvaar Ibinọkpaabyi ọkk'ọsa ọmaana bẹ k'egbegbeho cha Horẹb. ");
INSERT INTO mfo_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","Iwa Mosẹs oyeri anọng p'Israẹl biphyir otzobha, oben bẹ bi: Bọng akk'chen pabọng atzima are idik biphyir s'iwa Ọvaar Ibinọkpaabyi osi Phero kw'ode ọvaarnọng kw'Ijip ọmaana akhaan-nọng pẹ biphyir ttara ẹkhọma chẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","Bọng atzima chen pabọng ọkhaam are nyoma-barada, ọmaana ngọhkha ttara ikkokkoni-dik s'ideden s'iwa Ọvaar Ibinọkpaabyi osi. ");
INSERT INTO mfo_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","Yina, ma apyiri k'ewu cha mayina, Ọvaar Ibinọkpaabyi bọng achibhi pa bọng atzin idik nna otzima ọnanga, ode chen bi bọng atzima are idik nna, kaambi ọtzọhng fabọng atzima abhaang idik rọ, bọng kọnangi. ");
INSERT INTO mfo_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","Kaambi mẹ wọ, Ọvaar Ibinọkpaabyi oben bi, “Ka cho arọbh afa p'iwa ndim bọng nnenga k'ebherede, wa ọbara fabọng afor kọjaakhi, ekpo-pya-mmo pyabọng kebire ekhibhi. ");
INSERT INTO mfo_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","Wa bọng brẹd kachi, bọng atzuk p'agaang-ọgaangi kabira agwo. Wa kaam nsi idik nna ifha bọng aronga bi, kaam wọ nde Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng.” ");
INSERT INTO mfo_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","Mada iwa bọng apyiri m'irerek nna, ọvaar Sihọn kw'ode ọvaarnọng kwa Hẹshbọn, ọmaana ọvaar Ọg kw'ode ọvaarnọng kwa Bashan, ayin k'iyaan bi bẹ akwu arima man abẹ, yina, wa mokhema bẹ. ");
INSERT INTO mfo_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","Wa mọbọkha bẹ irerek sabẹ ọna, ọtzọkha sẹ ọnang ẹkhọma cha Reubẹn, ọmaana cha Gad ttara ibhakha rani s'ẹkhọma cha Manasẹ, mach'ekkema chabẹ. ");
INSERT INTO mfo_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","Bọng dọkha ogbe atzọn ndori s'echekhi nda abẹ, ifha kwẹ ọfha ojibh-ọnang bọng, k'ọttọhk kpenamkpen fa bọng asi. ");
INSERT INTO mfo_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","10","Mayina, bọng biphyir abe k'itzitzikha s'Ọ́vaar Ibinọkpaabyi, kwode Ibinọkpaabyi kwabọng, ọmaana k'itzitzikha s'adeho pabọng ọmaana avaarvara, ọmaana atzọhmnọng ttara ajinọng adọdọk p'Israẹl biphyir, ");
INSERT INTO mfo_vpl VALUES ("DT29_11","006_29_11","DEU","29","11","11","ọmaana vava pabọng, ọmaana panọng pabọng ọmaana akhekhennọng p'arukhi k'obhingabe fabọng, p'am-akpaara nchi sabọng, am-abira akhaabha asi. ");
INSERT INTO mfo_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","Bọbọng abe ma bi, bọng akhaama echekhi ọmaana Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, echekhi ch'Ọvaar Ibinọkpaabyi osi omaana bọng mayina, obiro otzima ọnwọhngi ottima ẹnọhna m'echekhi nda, ");
INSERT INTO mfo_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","ifha osi ẹjaakhi mayina bi, bọng ade anọng pẹ, ifha kẹ Ọvaar Ibinọkpaabyi obiro ode Ibinọkpaabyi kwabọng, mach'iwa ochekhi ọnang ab'atte p'ade: Abraham ọmaana Isaak ttara Jekọb. ");
INSERT INTO mfo_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","Echekhi nda cha ndim ọnwọhngi nsi, kinsi ọmaana bọbọng bẹ-bẹ, ");
INSERT INTO mfo_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","p'abe ma mayina k'itzitzikha s'Ọvaar Ibinọkpabbyi, kw'ode Ibinọkpaabyi kwaman, yina, mbiri nsi chẹ nnang igbọ s'íkwu k'ogbe ororo. ");
INSERT INTO mfo_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","Bọbọng ọkhaam arong akpen-dem p'iwa morukhi k'Ijip kẹ, bọng aronga odem kw'iwa moreng ka ngọhma nna ọkwọbha maa, mopyiri ma. ");
INSERT INTO mfo_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","Wa bọng are ikha sabẹ s'ikpukhi anọng okpukhi k'ottem kwabẹ. Bọng abira are agbatza pa bẹ atzim nchi ọmaana atza agwa, agbatza pa bẹ atzim asilva ọmaana gol, asi. ");
INSERT INTO mfo_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","Bọng nne kwẹ bi, k'ewu cha mayina, ọnọng manda wani, ode ojinọng obiro ode kwanọng ka nnọmma ọmaana ka ngọma sabọng, kw'ọ́kpa nnam ọbọra Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng k'ettem chẹ bi, ọ́tza okpobha ikha s'idibhon nnuma. Bọng nne kwẹ bi, ọnọng manda wani k'ottem kwabọng kóde, kw'ọwọm achiduk-ttama dema mba o. ");
INSERT INTO mfo_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","Ogbe kw'anọng p'abhaang atzim p'ọnwọhngi nwa abọhr for sabẹ, achibhi bi, “Kaambi mochin ororo motzima oho-gaangi osi idik s'ifon man k'achibhi, mọkhaama ẹnaanga ọkhaama.” Anọng dema mba atzima itzama akwu, s'ímyi asi p'adiri irerek naa ọmaana iyoma s'igwu irerek nna. ");
INSERT INTO mfo_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","Ọvaar Ibinọkpaabyi kóbina ọnang bẹ, kẹ ọdọkh-ettem obiro obhem-ẹ itzama-itzima otzima otzor bẹ. Ẹmma kpenamkpen cha bẹ akk'akkera ma nnwẹr nwa, ẹbọkha bẹ, Ọvaar Ibinọkpaabyi óbirọ opfuri che pabẹ m'ọyagbin. ");
INSERT INTO mfo_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","Ọvaar Ibinọkpaabyi ótsekha bẹ ka ngọma s'Israẹl biphyir, ọnang bẹ ettuma, otzor k'nttuma biphyir ch'echekhi cha bẹ akhẹri ka Nwẹr nwa kwa aphaangi. ");
INSERT INTO mfo_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","Igbọ s'íkwu k'ogbe ororo ọmaana akhekhennọng p'afon k'idibhon s'ibhir eden, áre itzama s'itto íkhebha obhon nwa, ọmaana ikhọmmana s'Ọvaar Ibinọkpaabyi ótzim ónang obhon nwa ettuma. ");
INSERT INTO mfo_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","sọlfọ ọmaana onung óchi irerekh sabọng bibhyir, ọttọhk manda vani f'omen mẹ kóde kaambi araraari bọ. Irerek sabong in-íde macha Sodom ttara Gomora, ọmaana mach'Adama ttara Zeboyim, s'iwa Ọvaar Ibinọkpaabyi otzim ittemdọkhiji sẹ odimi. ");
INSERT INTO mfo_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","Ofona mẹ, idibhon biphyir ín-ibọbh bi “Bọng odik gwọ osi Ọvaar Ibinọkpaabyi osi odik dema nwa ọnanag irerekh nna o? Bọng odikh gwọ ọse-ẹ, ọdọkh-e itzama-itzama manda o?” ");
INSERT INTO mfo_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","Ebhina cha mbọmma nwa ede bi “Okhuri da anọng mba akpa nnam abọra echekhi ch'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwa ab'otte ch'iwa osi ọmaana bẹ, k'ogbe kw'otzim bẹ obina k'obhon kw'Ijip. ");
INSERT INTO mfo_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","Bẹ akpa nnam atza akpobha agbatza, bẹ abira achunga nho anang bẹ, agbatza pa bẹ an-arong, agbatza p'Ibinọkpaabyi oni bẹ ọnangi. ");
INSERT INTO mfo_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","Mẹ wọ osi, wa Ọvaar Ibinọkpaabyi ọdọkh-ẹ itzama-itzama, otzima otzor irerek nna maa, otte ẹmma nda cha bẹ akkẹri ma nnwẹr nwa biphyir ọbọhk, ẹbọkha bẹ. ");
INSERT INTO mfo_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","Mẹ wọ, Ọvaar Ibinọkpaabyi otzima ittem-dọkhiji ọmaana ottem-pyibha kw'ideden odimi bẹ emeni k'irerek s'ọnangi bẹ, obiro otte bẹ ọbọhk ọnang idibhon idọdọk, mach'ode mayina.” ");
INSERT INTO mfo_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","Ndubhama ngaam Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwaman, yina, idik s'iwobh ijan-ijan ide saman ọmaana va paman maa, ogbe ode, ifha m'okhera k'atzim p'aphaangi mba biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","K'ogbe kwa bọng are ndaa nna biphyir, ọmaana ẹmma cha nnangi, mbọkha bọng, bọng abira akhe idik nna ka nttem k'ibe kpenamkpen s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng okhubhi bọng ọbhari k'ottem kw'idibhon. ");
INSERT INTO mfo_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","K'ogbe kwa bọbọng ọmaana va pabọng akk’nnam akpa atzor Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, abira atzima nttem sabọng ọmaana agbagba pabọng ahakha nho anang-ẹ, atzor ka ndọhna kpenamkpen sa kaam nnangi bọng mayina. ");
INSERT INTO mfo_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","Mẹ wọ osi, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọ́khaama nkwosisi ọmaana bọng, otzima ojibhada kwabọng ọkpa nnam, obiro otzima bọng k'idibhon biphyir s'iwa okhubhi bọng ọbhari, ọkpa nnam. ");
INSERT INTO mfo_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","Kaambi ode bi wa bẹ akk'bọng okhubha ọbhari k'odenmir kw'ọyagbin, kẹ Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, otzobha bọng, obiro otzima bọng kẹ, ọkpa nnam obiro otzobha bọng. ");
INSERT INTO mfo_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","Kẹ ótzima bọng ọkpa nnam k'irerek s'ide s'ab'atte, bọbọng abira átzọkha sẹ akhaama. Kẹ ọ́nang bọng ojibhada obiro osi bọng ahaabh ayọhnga ab'atte. ");
INSERT INTO mfo_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ógbobhi nttem sabọng ọmaana sa va pabọng nwur, ifha kẹ ọfha ọdaak bọng ka nttem sabọng ọmaana k'agbagba pabọng, ifha bọng aruk akpen. ");
INSERT INTO mfo_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọ́nang attattaanga-nọng pabọng ẹmma kpenamkpen, p'attaang bọng abira anang bọng ihem. ");
INSERT INTO mfo_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","Bọng ábira achina ororo ahakha nho anang Ọvaar Ibinọkpaabyi, abira ahok asana pẹ biphyir, pa kaam nnangi bọng, mayina. ");
INSERT INTO mfo_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","Mẹ wọ osi, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, ọ́nang bọng ojibhada k'itzọhmbọhk sabọng biphyir, obiro odo mmọr sa panọng pabọng, ọmaana va p'etzirakpo pyabọng ttara ekpo pya bọng ayaabh k'irerek sabọng. Ọvaar Ibinọkpaabyi ọ́daam ettem otzima otzor bọng, ọnang bọng ojibhada, mach'iwa ọdaami ettem otzima otzor ab'atte. ");
INSERT INTO mfo_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","Kwẹ óde mando, idikha bọng ahak nho anang Ọvaar Ibinọkpaabyi, bọng ahok asana pẹ ọmaana akpebhi pa bẹ akkẹri ma nnwẹr nwa, bọng abira atzima nttem sabọng biphyir ọmaana agbagba pabọng biphyir, akpa nnam atzor Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng. ");
INSERT INTO mfo_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","Ndọhna nna sa kaam nnangi bọng k'ewu cha mayina, sẹ kpọhng kingaangi nnang bọng, sẹ eden kpọhng kimbiri mmir bi, bọng ahok. ");
INSERT INTO mfo_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","Ndọhna nna k'ọvaarbhon kw'ẹrọng kinwobh, k'odem kw'ira bọng abọbh bi, “Anyi wọ óvura k'ọvaarbhon kw'ẹrọng ọtza ọtzọkha sẹ, ifha okwu osi ẹjaakhi chẹ ọnang man, mọfha ọhakha nho ọnang sẹ o?” ");
INSERT INTO mfo_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","Ndọhna nna k'ọraanga kw'ideden-okhubha kiwobh, k'odem kw'ira bọng an-abọbh bi, “Anyi wọ ójekha k'ọraanga kw'ideden-okhubha, ọtza ọtzọkha sẹ, ifha okwu osi ẹjaakhi chẹ ọnang man, mọfha ọhakha nho ọnang sẹ o?” ");
INSERT INTO mfo_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","Mma e, atzim mba awobh abaanga bọng ma e, bẹ awobh ma mma sabọng, bẹ awobha bọng ka nttem, ifha bọng afha ahakha nho anang sẹ. ");
INSERT INTO mfo_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","“Bọng kker e, kaam nji bọng akpen ọmaana obo, ejibha ọmaana itzama m'itzitzikha sabọng mayina e. ");
INSERT INTO mfo_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","Kaam nnangi bọng ndọhna mayina bi, tte Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ọdaak bọng, bọng ahakha nho anang-ẹ, bọng abira ahok asana pẹ ọmaana akpebhi ttara aphaangi pẹ. Mẹ wọ osi, bọng aruk akpen abira ahaabh, Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, obiro ódo bọng k'irerek sa bọng am-adim bi, atza atzọkha. ");
INSERT INTO mfo_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","Yina, idikha bọng abhakhi nttem sabọng, bọng nho kabira ahakha, bọng an-abira atte for sabọng ọbọhk anang k'ikha okpokpobha, bọng atza attima ahokpadim anang sẹ, ");
INSERT INTO mfo_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","kaam nsi ẹjaakhi nnang bọng mayina bi, k'odik-ọkka, bẹ adimi bọng odimi. Bọng akpen p'adum-eden karuk k'irerek nna, sa bọng am-ajekha Jọrdan bi, adim atza atzọkha akhaama. ");
INSERT INTO mfo_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","Mayina, kaam ndọk ẹrọng ọmaana irek macha nttẹsẹ kwabọng, kaam nkk'akpen ọmaana obo ọmaana ndaa ọmaana ẹmma ọnanang, ndọkha nji bọng k'itzitzikha. Mẹ wọ, bọng dekha akpen ifha bọbọng ọmaana va p'abọng afha aruk akpen, ");
INSERT INTO mfo_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","ọmaana bi Ọvaar Ibinokpaabyi kw'ode Ibinọkpaabyi kwabọng ọdaak bọng ttara ettem obungichẹ, bọng abira ayonga itzọhng k'atzim pẹ, bọng abira abọkh-ẹ atzima. Okhuribi Ọvaar Ibinọkpaabyi wọ ode akpen pabọng, kẹ ọ́nang bọng akpen p'adum-eden k'irerek nna s'okk'ochekhi ọnang ab'atte, p'ade Abraham ọmaana Isaak ttara Jekọb. ");
INSERT INTO mfo_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","Iwa Mosẹs oyin k'iyaan ọtza ọgbaak anọng p'Israẹl biphyir bi, ");
INSERT INTO mfo_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","“Kaam nna nde cho arọbh azadani, kaam ẹfa dọk kingaam cha mbiri ndima bọng eden. Ọvaar Ibinọkpaabyi ọkk'aam obena bi, ‘Kọ ọraanga kwa Jọrdan kájekha.’ ");
INSERT INTO mfo_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","Kẹ Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, wọ óchi bọng eden ojekha. Kẹ ótzima bọng eden bọng adimi idibhon nna, bọng atzọkha irerek sabẹ akhaama. Joshua óbiro óchi bọng eden ojekha, mach'Ọvaar Ibinọkpaabyi obeni. ");
INSERT INTO mfo_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","Ọvaar Ibinọkpaabyi ósi anọng p'idibhon nna mach'iwa osi Sihọn ọmaana Og, p'ade avaarnọng p'Amọr, p'iwa odimi ttara ẹkhọma chabẹ. ");
INSERT INTO mfo_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","Ọvaar Ibinọkpaabyi ọtzọkha bẹ okhe bọng ka mbọhk, bọng akhaambi akhema bẹ atzor k'oden kpenamkpen cha kaam nkk'bọng ndọhna. ");
INSERT INTO mfo_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","Bọng be bi pyiir abira abar ettem. Tte ojora, obiro ode opoma oningi bọng osi, okhuri anọng mba, da ode Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng wọ owobh ttara bọng; kẹ bọng ọbọhk kótte, nnam kóbiro ọkpa ọbọra bọng.” ");
INSERT INTO mfo_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Mẹ wọ osi, Mosẹs oyeri Joshua oben-ẹ m'itzitzikha s'anọng p'Israẹl bi, “Kọ be bi pyiir abira abar ettem, kkeri kọ wọ átzima anọng mba eden, adim k'irerek nna s'iwa Ọvaar Ibinọkpaabyi ochekhi bi, ọnang ab'atte. Kọ akhaambi akkema irerek nna, anang ọnọng-ọnọng mach'ekkema chẹ. ");
INSERT INTO mfo_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Kẹ Ọvaar Ibinọkpaabyi ọkhaam wọ otzima bọng eden, óbiro ówobha ttara bọng; kẹ bọng ọbọhk kótte, nnam kóbiro ọkpa ọbọra bọng. Tte oningi bọng ojor; ẹfa eningi bọng ẹha.” ");
INSERT INTO mfo_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","Iwa Mosẹs ọkkẹr aphaangi mba, ọtzọkha bẹ ọnang afọhnẹja p'ẹnọmma cha Lẹvi, p'atzini ẹkkọhbhi ch'echekhi ch'Ọvaar Ibinọkpaabyi, obiro ọnang adedennọng biphyir p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","Mẹ wọ ofon, Mosẹs ọtzọhn anọng mba bi, “K'okpong kwa cho azenamfa kpenamkpen, kw'ode cho kw'obhori ọbọhk ottette, k'ogbe kw'ọdadaami kw'obhingabe, ");
INSERT INTO mfo_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","mada anọng biphyir p'Israẹl akwu bi, akwu atzobha k'itzitzikha s'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, k'ibe sa kẹ ótzekha bi bọng atzọbha, kọ áyeri aphaangi mba m'itzitzikha sabẹ, bẹ abhaanga. ");
INSERT INTO mfo_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","Kọ yeri anọng mba atzobha, ajinọng ọmaana panọng, va-va ttara akhekhennọng p'arukhi k'ibhon sabọng, ifha bẹ áfha ayonga itzọhng, abira akhaama ojora f'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng. Bọng biri tzọkha ogbe ahok aphaangi mba. ");
INSERT INTO mfo_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","Va pa va pabẹ p'ani aphaangi mba arong, akhaambi abhaanga abira akpebhi bi, bẹ akhaama ojora f'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, atzor k'odem kwa bọng aruk akpen, k'irerek nna sa bọng am-ajekha ọraanga kwa Jọrdan bi, atza atzọkha akhaama.” ");
INSERT INTO mfo_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","Iwa Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Ebowu chọ ẹm-ẹtzọri emyi e. Kọ yeri Joshua bọng atzọn ẹkhaan atza k'ikhira s'etzobha, kẹ da kaam nnan-ẹ ọbọhk k'eho, mẹ wọ kwa kaam mbiri nnang-ẹ ọtzọhm f'osi.” Mando kwa Mosẹs ọmaana Joshua atzọni ẹkhaan atza k'ikhira s'etzobha. ");
INSERT INTO mfo_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","Iwa Ọvaar Ibinọkpaabyi orenga k'ẹkpọmmachi ch'eboni, oyin obe m'ikhira s'etzobha, eboni nda ebe m'ẹhọhmma ch'ikhira s'etzobha. ");
INSERT INTO mfo_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","Wa Ọvaar Ibinọkpaabyi oben Mosẹs bi, “Ogbe okk'obenga kw'án-atza akwokha ọwọhng ttara ab'atte e. Ogbe k'obhir, anọng mba áttẹwọr ẹzaaza otto, cha bẹ atza akpobha ikha s'iwobh k'irerek nna sa bẹ am-aben bi, atza adim e. Bẹ ákpa nnam ọkpa abọr-m, bẹ ábira ávọhkhi echekhi ch'iwa ngaam ttara bẹ, ọvọhkhi. ");
INSERT INTO mfo_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","M'ogbe nwuma, ódọkh-m ọdọkhi ttara bẹ, kaam ḿbiri ḿkpa nnam mbọra bẹ. Kaam ńdubha bẹ itzitzikha saam, bẹ abira adimi bẹ. Adik-ttama átto akhebha bẹ k'ọhaabh, bẹ abira awobha k'ọmmọmma. M'ogbe nwuma, bẹ án-abọbh bi, ‘Ode bi adik-ttama-haabhada mba atto akhebha man, okhuri da Ibinọkpaabyi kwaman oni dọk owobh ọmaana man o? ");
INSERT INTO mfo_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","K'odik-ọkka, kaam ńdubha itzitzikha saam odubha e, okhuri itzama sabẹ, sa bẹ akpa nnam abọr-m atza akpobha ekpo ẹdọdọk. ");
INSERT INTO mfo_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","“Kọ kkẹr ẹmọng nda abira akpebhi anọng p'Israẹl bi, bẹ akkọhn chẹ, ifha ẹmọng nda ede nttẹnsẹ kwaam ẹttaanga ẹnang bẹ. ");
INSERT INTO mfo_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","K'ogbe kwa nkk'bẹ ndima mpyiri k'irerek nna s'ifu ttara abasi ọmaana akhọkhọnana, s'ide irerek s'iwa nwọhngi nchekhi bi nnang ab'otte. Mada bẹ áchi adọhbh k'irerek nna, bẹ ákpa nnam ọkpa abọr-m atza akpobha ekpo ẹdọdọk. Bẹ ábhum-m, ábira ávọhkhi echekhi chaam. ");
INSERT INTO mfo_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","K'ogbe kw'adik-ttama-haabhada paam ọmaana ọmmọmma kwaam, átto akhebha bẹ, ẹmọng nda dọ ebe macha nttẹsẹ ẹttaanga ẹnang bẹ, okhuri bi va pa va pabẹ ẹmọng nda káraama. Yina iwa kaam ndima bẹ mpyiri k'irerek sa nwọhngi nchekhi bi nnang bẹ, kaam iwa nnong idik sa bẹ am-achibhi ka nttem bi, bẹ asi kẹ.” ");
INSERT INTO mfo_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","M'ewu nduma dani, wa Mosẹs ọkkẹr ẹmọng nda, obiro okpebhi anọng p'Israẹl chẹ. ");
INSERT INTO mfo_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","Iwa Ọvaar Ibinọkpaabyi ọnang Joshua, kw'ode nnwa kw'ijinọng kwa Nun ndọhna nna bi, “Kọ be bi pyiir abira abar ettem, kkeri kọ wọ átzima anọng p'Israẹl áchina k'irerek, sa kaam nwọhngi nchekhi bi nnang bẹ. Kaam ọkhaam wọ ḿbiri ńwobha ttara kọ.” ");
INSERT INTO mfo_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","K'ogbe kwa Mosẹs, okk'atzim p'aphaangi mba okyera ọkkẹr-kkẹr ka nnwẹr, tzọni k'ittẹwọr maa, apyiri k'okpong, ");
INSERT INTO mfo_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","ọn-ọnang ab'aLẹvi p'atzọk ẹkkọhbhi ch'echekhi ch'Ọvaar Ibinọkpaabyi ndọhna nna bi: ");
INSERT INTO mfo_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","“Bọng dọkha nnwẹr nwa kw'aphaangi, ahok m'ọkhaan-ọkhaan kw'ẹkkọhbhi ch'echekhi ch'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng. Nnwẹr nwa ówobha mẹ macha nttẹsẹ ọttaanga ọnang bọng. ");
INSERT INTO mfo_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","Da kaam nnong odem kwa bọng agaangi eho, abira asi irẹrẹkhi apyiri kẹ. Ojemi ma da ndimi nnukhi akpen, mbiri nwobha ma ọmaana bọng, bọng Ọvaar Ibinọkpabyi karọbhi, kwẹ ópyibh-opyibh ọyọhnga idikha nkk'mpa e. ");
INSERT INTO mfo_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","Bọng yeri adedennọng ọmaana adabhi pa ngọma sabọng biphyir ayin-m k'itzitzikha, ifha kaam mfha mgbaak atzim mba bẹ abhaanga. Kaam mbiri nyeri idik s'ọrọngkpakpa, ọmaana irerek s'ibe macha nttẹsẹ ittaanga inang bẹ. ");
INSERT INTO mfo_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","Da kaam nnong kẹ bi, ńkk'mpa, bọng án-asi ọmmaana-tzama ọkhaam-ọkhaam bi, bọng akpa nnam abọra aphaangi pa kaam nkk'bọng ndọhna. K'iwu s'ikwu k'ororo, itzama ítto ikhebha bọng, okhuri bi bọng ási ebibya k'itzitzikha s'Ọvaar Ibinọkpaabyi, bọng ábira átzima ekpo pya bọng ágwa, ájemi ittem-dọkhiji sẹ.” ");
INSERT INTO mfo_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","Iwa Mosẹs oyeri atzim p'ẹmọng nda tzọni k'ittẹwọr maa, opyiri k'okpong ọnang anọng p'ẹkhọma ch'Israẹl biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","Ọrọngkpakpa o, yong-m itzọhng ifha mgbaak atzim e; irerek o, bhaanga atzim p'ayin-m k'ẹmma e. ");
INSERT INTO mfo_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","Tte okpebhi kwaam ọtzebh mach'ẹrọng e, tte atzim ahakha mach'abonisi, mach'asi atzebhi k'araraari abhapẹ, mach'ẹrọng ch'ẹnyẹngi k'ararari p'arami amena. ");
INSERT INTO mfo_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","Kaam ńsi ẹjaakhi cha che ch'Ọvaar Ibinọkpaabyi. Bọng nang Ibinọkpaabyi kwaman ẹtzọhnga ka abarada pẹ! ");
INSERT INTO mfo_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","Kẹ wọ ode itzakpa s'ibaabhi bọng, itzọhmbọhk sẹ ittong-ottonga, nden sẹ biphyir mbiri ndor-otzor Kẹ ode Ibinọkpaabyi kw'odik-ọkka kw'oni ottotto ọkhaam, kẹ otzor-otzor, obiro ojibh-ojibh. ");
INSERT INTO mfo_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","Bẹ ẹmmaana ọkkọkka kakhaam, bẹ va Ibinọkpaabyi dọk kade, Bẹ ade ọgbọ kw'afhọra ọmaana kw'ibhora. ");
INSERT INTO mfo_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","Etzọhnga ch'ẹbaan bi, bọng anang Ọvaar Ibinọkpaabyi dọ ma? bọng ade anọng p'awori achibhi, abira ade adidingi-nọng, Kẹ rang ode otte kwabọng o, kw'osi bọng, kw'osi bọng obiro ọbanga bọng o? ");
INSERT INTO mfo_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","Bọng jima ọtzama-gbe, bọng chibhi idik okhuri igbọ s'iwa kẹ́kẹ́. Bọng bọbh ab'atte, ifha bẹ agbaak bọng, bọng bọbh adedennọng pabọng, ifha bẹ asi kwẹ ọttaani bọng. ");
INSERT INTO mfo_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","K'ogbe kw'Ọvaar Ibinokpaabyi kw'Ọyọhng ọnangi idibhon nkkema sabẹ, k'ogbe kw'osi ọnọng-ọnọng owobha k'okhubha kwẹ, okhe nnem ọnang idibhon, otzor k'ọnọng-mik kw'atzọhmi p'Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","Da ode anọng p'Ọvaar Ibinọkpaabyi bọ ade ekkema chẹ, Jekọb wọ ode ekkema chẹ ch'otzek ọnang for sẹ. ");
INSERT INTO mfo_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","Wa ọrẹ-ẹ k'ebherede, k'irerek s'ọchattọhk on-ode ọmaana owora. Kẹ ọbaabh-ẹ obiro okker-ẹ, okker-ẹ mach'ira okkeri chen pẹ, ");
INSERT INTO mfo_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","kẹ okker-ẹ mach'ikye-nọhn ikkeri va pẹ k'ẹgbara, ibiri ikpebhi bẹ ekhura, imẹma mbabaang ikkibha va, ibiri itzini bẹ ka mbabaang ikhur, ifha bẹ aningi atto. ");
INSERT INTO mfo_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","Ọvaar Ibinọkpaabyi mancheni wọ otzim bẹ eden, ọkha f'okhekhenmon f'iwa otzor-ẹ kode. ");
INSERT INTO mfo_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","Wa osi bẹ arenga k'obe f'ogor-ogori k'irerek nna, otzima achiduk p'iwoni, ọnang bẹ ọchattọhk. Otzima akhọkhọnana p'afon k'atzakpa ọrọk bẹ, obiro otzima ana p'oliv p'afon k'irerek s'ikhaam atzakpa, ọrọk bẹ. ");
INSERT INTO mfo_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","otzima abasi p'abang-ọbanga, ttara abasi p'abhaam, ọmaana arukhiman ọmaana avu, abhaam-ọkkakka pa Bashan, ttara awit ọkkakka. Bọng agwo atzuk ọkkọkka pa grep. ");
INSERT INTO mfo_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","Anọng pa Jẹshurun asi ikkọ, bẹ an-agaangi eho, da bẹ akk'acha adọhbh, for ibiri ijibh bẹ. Bẹ an-akpa nnam abọra Ibinọkpaabyi kw'oyokhi bẹ, bẹ abira abhum Itzakpa s'ide ọkkaan kwabẹ. ");
INSERT INTO mfo_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","Bẹ atzima ikha s'ikhekhenmon, asi ettem ẹmma Ibinọkpaabyi, bẹ abira atzima agbatza p'akpukhi anọng okpukhi, asi ettem ẹdọkh-ẹ. ");
INSERT INTO mfo_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","Bẹ afọhni nja anang ikha s'ibhora, s'ini Ibinọkpaabyi ide, ikha sa bẹ ani atzima aronga, ikha ibhasẹ s'irami oyiyin, ikha s'iwa ab'atte ani nho ahak anang. ");
INSERT INTO mfo_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","Bọng arọbh aji Itzakpa s'ide otte kwabọng, bọng araama Ibinokpaabyi kw'obhoni bọng. ");
INSERT INTO mfo_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","Ọvaar Ibinọkpaabyi ore odik nwa, kẹ obiro obhum bẹ, da va pẹ p'ijinọng ọmaana p'ipanọng, akk'asa ettem ẹdọkh-ẹ. ");
INSERT INTO mfo_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","Ọvaar Ibinọkpaabyi on-oben bi, “Kaam bẹ itzitzikha saam kíngọhkha, ifha kaam nne odem kw'okpong kwabẹ ode, da bẹ ade ọgbọ kw'ọkhaam oho-ọgaangi, bẹ ade va p'ani nnam-ophephe akhaam. ");
INSERT INTO mfo_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","Bẹ atzim ikha asi ettem ẹmma-m, abira atzima ekpo pye k'eden eyini, nsi ettem ẹdọkh-m. Kaam ńdima idibhon s'ini k'eden iyini, ńsi ettem ẹmma bẹ, kaam ńdima anọng p'obhon p'ani atzim arong, ńsi ettem ẹdọkhi bẹ. ");
INSERT INTO mfo_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","Idọdọkhi saam íwọma mach'ekpon ẹwọmachẹ, ch'ẹkwọmi maa, epyiri k'opfura-bhon. Chẹ ẹ́kwọmi ọyagbin ọmaana ọttọhk kpenamkpen f'owobh k'ọyagbin, ebire ekhe ekpon k'orin kwa mgbegbeho. ");
INSERT INTO mfo_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","“Kaam ndọhm ọmmamma k'adem-k'adem otto okhebha bẹ, ḿbiri ḿmari akhọhn paam ngwum bẹ ");
INSERT INTO mfo_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","Kaam ńdọhm bẹ okwo f'ideden, ńdọhm bẹ ọmmamma ọmaana ikhọhmana s'ideden, Kaam ńdọhm bẹ nkkakkaama-tzen s'irima bẹ abẹ, ḿbiri ńdọhm bẹ jọhk-ttama p'akhimi bẹ. ");
INSERT INTO mfo_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","Akkangkkaang áfhu va pabẹ ka mkpaanga-den, bẹ va dọk kakhaam, ojora f'ideden ọbọkha bẹ, k'ihọhm sabẹ. Adikkobh ọmaana aminava ápe-ope atzami-nọng ọmaana va-va ábira ápe-ope. ");
INSERT INTO mfo_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","Kaam Ibinọkpaabyi mbeni bi, nyaani bẹ makhọra, ḿbiri mpfuri che pabẹ k'achibhi p'anọngẹya, ");
INSERT INTO mfo_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","yina, kaam mphaangi ilulukhi s'attattaanga-nọng, oni mando ode, kwẹ attattaanga-nọng kọttaani, p'an-aben bi, ‘M'ọkk'ẹfa chaman otzima okhema e, Ọvaar Ibinọkpaabyi arang osi idik nna biphyir.’ ” ");
INSERT INTO mfo_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","Anọng mba ade ẹkhọma ch'eni etzim-nonga ẹkhaam, bẹ etzina ch'odik manda wani kakhaam. ");
INSERT INTO mfo_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","Ira bẹ afha akhaama ekkoji e, ifha bẹ atzin idik nna, abira atzin okpọng kwabẹ! ");
INSERT INTO mfo_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","Ọnọng wani on-orenga yan, okhubh anọng nnọhna mfa obhiri arọbh jobh o? Orenga yan kw'anọng afa, akhubh anọng nnọhna ẹrọbh obhiri azen o? K'oyongi bi, itzakpa sabẹ ikk'bẹ iraama, k'oyongi bi, ẹfa ekk'Ọvaar Ibinọkpaayi ẹha. ");
INSERT INTO mfo_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","Kaambi attattaanga-nọng paman bọ, bẹ kọttaani bi, Itzakpa s'ibaabh man iyọhng, itzakpa sabẹ. ");
INSERT INTO mfo_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","Agrep pabẹ afon k'agrep pa Sodom, bẹ abira afona k'iwoni sa Gomora. Agrep pabẹ ade agrep-ttama, agwọk p'agrep pabẹ ajobh-ojobhi. ");
INSERT INTO mfo_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","Atzuk pabẹ ade mach'attabọhng-dama pa jọhk, bẹ akheri attabọhng-dama p'ewom. ");
INSERT INTO mfo_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","“Kaam nkk'idik nna s'attattaanga-nọng nhokha, nhokhi sẹ k'ogbe kwabẹ. ");
INSERT INTO mfo_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","kaam wọ ndukha sẹ, kaam wọ nńang bẹ echora. Bẹ arọri-ọrọri atto ogbe obebeng, ewu ch'ọmmamma kwabẹ en-ebe ma, okpong kwabẹ okk'bẹ ọbaanga.” ");
INSERT INTO mfo_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","Ọvaar Ibinọkpaabyi ọ́kkaana anọng pẹ ọkkaana, obiro ọkhaama inọhngkwo ttara atzọhmnọng pẹ, k'ogbe kw'ore bi ẹfa ekk'bẹ eha, ọnọng manda wani kw'ode obira, obiro ode bi obira kode, korikhi. ");
INSERT INTO mfo_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","Ọvaar Ibinọkpaabyi ọn-ọ́bọbh bi, “Ma ikha nnuma sabe, s'ide itzakpa nnuma s'iwa bẹ am-atza achubha ko o? ");
INSERT INTO mfo_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","Ma ikha nnuma s'iwa bẹ am-anang njafọhni nkkakkasẹ, ibiri igwo atzuk p'afon k'ẹnanga ch'atzuk pabẹ ko o?, Tte pyẹ ebina k'ẹrọng ekwu ẹkkaana bọng! Tte pyẹ ekwu ẹbaabha bọng! ");
INSERT INTO mfo_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","“Bọng na re bi kaam mancheni wọ nde Ibinọkpaabyi e! Ọdọdọk kode, oyongi kaam. Kaam wọ ngaam ẹfa cha nnangi akpen, mbiri ndọkha akpen, Kaam wọ ngaam ẹfa cha mmum anọng ekpo, mbiri nkkeri bẹ ndem sa nkk'bẹ ekpo mmumma, ọnọng kw'ofho ọrọbh ọnaanga ka mbọhk saam kode. ");
INSERT INTO mfo_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","“Kaam nkk'ọbọhk kwaam ndini k'ẹrọng ndọhkha ọwọhngi bi, ọdem nwa kwa kaam nchin ororo nnuk maa ogbe ode, ");
INSERT INTO mfo_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","mada kaam ḿbọhnga ọkkangkkaang kwaam, mbiri mbọhk-ẹ ttara ọbọhk kwaam bi nttọhna aponga, kaam ndukha idik s'attattaanga-nọng paam asi, mbiri nnang anọng p'attaang-m echora. ");
INSERT INTO mfo_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","Kaam ndima akhọhn paam ńgum attattaanga-nọng, ndima ọkkakkaang kwaam nkwuri ayara. ọnọng manda wani kwa ngọkha nkwo kode, kaambi ayok p'akk'epko amuma ọmaana ayok pa be abọkh k'ẹmori bọ, pẹ ápe-ope. ");
INSERT INTO mfo_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","Tte idibhon itzọhn anọng p'Ibinọkpaabyi abẹ isi ọdadaami, kkeri kẹ ótzukha obo kw'atzọhmnọng pẹ otzukha, kẹ ọkpa nnam ọ́nang anọng mbuma p'attaang-ẹ ettuma, obiro ogbobhi itzama s'irerek s'anọng pẹ. ");
INSERT INTO mfo_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","Iwa Mosẹs ọmaana Joshua kw'ode nwa kwa Nun, agbaak atzim mba biphyir p'ẹmọng nda, anang anọng p'Israẹl abhaanga. ");
INSERT INTO mfo_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","K'ogbe kwa Mosẹs okk'anọng p'Israẹl atzim mba biphyir ọgbaakha, ");
INSERT INTO mfo_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","oben bẹ bi, “Bọng nne kwẹ bi, akpebhi mba biphyir pa nkk'bọng mkpebhi mayina awobha bọng ka nttem, ifha bọng ábira afha akpebhi va pabọng bi, bẹ abira ahakha nho anang atzim p'abhaangi mba. ");
INSERT INTO mfo_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","Atzim mba bẹ atzim p'idukhi kade anang bọng, bẹ ade atzim p'akpen anang bọng. Ófona m'atzim mba bọng aruk akpen p'adumi-eden k'irerek nna sa bọng am-ajekha Jọrdan bi, atza atzọkha akhaama.” ");
INSERT INTO mfo_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","Mẹ ewu nduma dani, Ọvaar Ibinọkpaabyi oben Mosẹs bi, ");
INSERT INTO mfo_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","“Kọ vura achina k'Abarim, k'egbegbeho cha Nebo ka Moab ch'ekkeri Jeriko itzitzikha, abe mẹ are Kenaan, kw'ode irerek sa kaam nnang anọng p'Israẹl mach'ekkema chabẹ. ");
INSERT INTO mfo_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","M'egbegbeho nduma ch'akk'avura dọ cha kọ ápe, bẹ anọhng-ọ atzor ab'atte, mach'iwa agbaanatte Aarọn ope k'egbegbeho cha Họr, bẹ anọhng-ẹ otzor ab'otte. ");
INSERT INTO mfo_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","Ode mando okhuri bi, bọng anọng afa anang-m irẹrẹkhi, k'itzitzikha s'anọng p'Israẹl k'ekhekhaho cha Mẹriba-Kadẹsh, k'ebherede cha Zin ọmaana bi da bọng an'aam ikpokpobha anangi k'ottem kw'anọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","Mẹ wọ, kọ akhingẹ are irerek nna k'oden-bhir, kọ mmo sọ m'irerek nna sa nnangi anọng p'Israẹl kábari.” ");
INSERT INTO mfo_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","Ma wọ ode ittabọhng s'iwa Mosẹs, kw'ode ọtzọhm-nọng kw'Ibinọkpaabyi osi anọng p'Israẹl, yina on-ope. ");
INSERT INTO mfo_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","Iwa oben bi, “Ọvaar Ibinọkpaabyi ofon k'egbegbeho cha Sinai okwu, obiro ọttẹwọr ka Seir ọmaani man iyaan sẹ, ọttẹwọr k'egbegbeho cha Paran ọmaani. Kẹ ọtzọni kẹ otzima atzọhmi nnọhna-nabhik okwu, ọmaana ekpon-ẹwọmachẹ k'odimbọhk kwẹ. ");
INSERT INTO mfo_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","K'odik-ọkka, kọ wọ kw'anọng mba adaakh-idik, anọng biphyir p'awur-owur awobh kọ ka mbọhk. Bẹ achunga ahokpadim pabẹ ma ndọkhi sọ, anang-ọ ikpokpobha, bẹ abira atzọhka ndọhna s'ifon ka kọ, ");
INSERT INTO mfo_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","aphanngi pa Mosẹs ọnangi man, bẹ ade ẹkkọkpo py'ẹkhọma ch'anọng pa Jekọb, kw'ode anọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","Wa kẹ ode ọvaarnọng kw'ọdabhi Jẹshurun, k'ogbe kw'adedennọng p'anọng mba atzobh ọmaana anọng pa ngọma s'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","“Tte Reubẹn óchina ororo oruk akpen, oningi ope, tte anọng pẹ achina ororo ahaabh, bẹ aningi ọkhakhara akhar.” ");
INSERT INTO mfo_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","Odik okhuri Juda, oben bi: “O Ọvaar Ibinọkpaabyi, kọ bhaanga ẹmọng cha Juda obhomi e, kọ tzim-ẹ achena anọng pẹ e. Kẹ otzim mbọhk sẹ orima erima cha kẹ ọkhaam. O itta, kọ nang-ẹ ẹkkaana ka mbọhk s'attattaang-pẹ! ");
INSERT INTO mfo_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","Odik okhuri anọng p'ẹnọmma cha Lẹvi, oben bi, “Ose kwabọng kw'Urim ọmaana kwa Tumim, akhaam atzọhmnọng pabọng p'odik-ọkka. Wa bọng ayom bẹ ka Masa; wa bọng asi ẹkhọhr ọmaana bẹ k'asi pa Mẹriba. ");
INSERT INTO mfo_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","Kẹ oben otte ọmaana ọkka bi, ‘Kaam ikpokpobha kingaam nnang bọng.’ Kẹ votte pẹ kotzini, kaambi va pa kẹ ọkhaam bọ, bẹ kobiro otzin, yina, kẹ ọhak eho ọnang k'atzim pọ, obiro ohok echekhi chọ. ");
INSERT INTO mfo_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","Kẹ okpebhi anọng pa Jekọb akpebhi pọ, obiro okpebhi anọng p'Israẹl aphaangi pọ. Kẹ ọkwọmi insens k'itzitzikha sọ, obiro osi njafọhni nkwọmisẹ k'ijafọhnibe sọ. ");
INSERT INTO mfo_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","O Ọvaar Ibinọkpaabyi, do emengkka kpenamkpen chẹ, atzọkha ottem-daamiji k'itzọhmbọhk sẹ. Kọ dimi attattaanga-nọng p'abin, attaanga anang-ẹ, adimi attattaanga-nọng pẹ maa, bẹ aningi dọk afha abina.” ");
INSERT INTO mfo_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","Odik okhuri ẹkhọma cha Bẹnjamin oben bi: “Tte ẹkhọma ch'ẹdaakhi Ọvaar Ibinọkpaabyi idik, iwobha k'odidiri kwa kẹ Ibinọkpaabyi, da kẹ Ibinọkpaabyi ọm-ọbaabha bẹ k'ogbe kpenamkpen, kẹ nwuma kw'ọdaakhi Ọvaar Ibinọkpaabyi idik, ochubha k'ottem kwa mbabaang sẹ.” ");
INSERT INTO mfo_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","Odik okhuri ẹkhọma ch'anọng pa Josẹph, oben bi: “Tte Ọvaar Ibinọkpaabyi odo irerek sabọng, tte otzima abonisi akkakka p'efona k'ọrọngkpakpa, ọmaana asi p'afon k'irerek ẹtzaanga; ");
INSERT INTO mfo_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","tte odo bọng ọmaana ekpikhira ch'etzima ipha ọkkakka ikwu, obiro odo ophe kw'otzima ipha ọkkakka okwu, ");
INSERT INTO mfo_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","odo nnanga ọkkakka s'ifon ka mgbegbeho s'ọtzama-gbe sa ngor-ogori, obiro odo bọng ọmaana ọhaabh f'ofon ka mbegbeho s'iwa kẹ́kẹ́, ");
INSERT INTO mfo_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","ọmaana nnanga s'ifọn m'ọyagbin ọmaana idik s'ọyagbin ọmaana ọphyaam f'ofon ka kẹ, kw'iwa owobh k'echi nduma ch'iwa ẹwọm ekpon. Tte ẹdaa nda biphyir ewobha ẹnang anọng pa Josẹph, ewobha ẹnang kẹ nwuma kw'iwa ode oho kwa votte pẹ. ");
INSERT INTO mfo_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","Kẹ ọkhaam ẹfa ch'erima ch'ekheri ẹfa ch'ocheden-nwa kw'ọbhaam-dim, abhik pẹ p'ẹfa ade mach'abhik p'andamogbodo kw'ọkkaam-ọkkaam. Kẹ ótzima abhik mba orima idibhon abẹ, kaambi idibhon s'iwobh k'okpong kw'ọyagbin nọ. Anọng mba ade mach'anọng nnọhna ẹrọbh obhiri azen p'Ephraim, bẹ ade mach'anọng nnọhna-nabhik sa Manasẹ.” ");
INSERT INTO mfo_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","Odik okhuri ẹkhọma cha Zebulun ọmaan ch'Isaka, oben bi: “Anọng pa Zebulun o, bọng wobha k'ottem-daamiji k'ogbe kwa bọng ayini k'iyaan, anọng p'Isaaka o, bọng biri wobha k'ottem-daamiji, k'ogbe kwa bọng awobh k'okhira fabọng. ");
INSERT INTO mfo_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","Bẹ áyeri anọng p'idibhon akwu atzobha k'egbegbeho, kẹ wọ kwa mowobha osi njafọhni s'anọng p'atzor-otzor. Bẹ achi ndaami k'ọhaabh sa nfon k'araanga p'ideden, ọmaana k'ẹkhakhaama ch'echubh k'oyeyeng ẹtzaanga.” ");
INSERT INTO mfo_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","Odik okhuri anọng p'ẹkhọma cha Gad, oben bi, “Ẹdaa ewobha ẹnang ọnang nwuma kw'ọmmẹm nnem s'anọng pa Gad! Anọng pa Gad arukhi mẹ mach'ekye bi bẹ afhu anọng p'atto bẹ ka mbọhk. ");
INSERT INTO mfo_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","Kẹ otzek irerek ikkakkasẹ ọnang fọr sẹ, bẹ atzekha ekkema ch'avaar ahok kẹ. K'ogbe kw'adeho p'anọng mba atzobh, kẹ ọtzọni ochibhi kw'otzor-otzor kw'Ọvaar Ibinọkpaabyi abẹ, ọmaana eponga-ttọhna ch'ekhuri anọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","Odik okhuri anọng p'ẹkhọma cha Dan, oben bi: “Dan ode mach'okye-nwa, kw'ofon ka Bashan.” ");
INSERT INTO mfo_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","Odik okhuri anọng p'ẹkhọma cha Naphtali, oben bi: “Naphtali owobh k'ọphyaam f'ideden f'Ọvaar Ibinọkpaabyi, kẹ ofhu ọmaana ẹdaa ch'Ọvaar Ibinọkpaabyi: kẹ ofon k'okhubha kw'ewuchen em-edimi, ọmaana k'okhubha kw'esipe ch'ideden.” ");
INSERT INTO mfo_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","Okhuri ẹkhọma cha Ash, oben bi, ẹdaa ewobha ttara va pa Ash, Tte ẹdaa nda biphyir ewobha ttara bẹ, tte ogbobhi mmo sẹ k'anna. ");
INSERT INTO mfo_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","Abọk pa mbaakhamma sabọng áde akkonga ọmaana brọns, odem nwa kw'iwu s'arukhi akpen ide mando kw'ẹfa chọ épyiri. ");
INSERT INTO mfo_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","“Ọnọng kode kw'ode mach'Ibinọkpaabyi kwa Jẹshurun, kw'oreng k'ọphapha ofona k'ẹrọng ọmaana ẹvaar chẹ, okwu bi okwu ọkkaan-ọ. ");
INSERT INTO mfo_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","Kẹ Ibinọkpaabyi nwuma kw'orukhi akpen maa, ogbe ode, wọ ode ichubhabe sabọng, ka mbọhk sẹ rọ, sa bọng aphe nnam. Kẹ ókhubh attattaanga-nọng pabọng k'itzitzikha sabọng, oben bi, ‘Bọng dimi bẹ!’ ");
INSERT INTO mfo_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","Ofona mẹ, anọng p'Israẹl áruk k'odidiri. Jekọb óruk k'ẹmẹm k'irerek s'ikhaam abọkpa ọmaana atzuk abhapẹ, kẹ da ọrọngkpakpa om-otzebh eboni. ");
INSERT INTO mfo_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","Anọng p'Israẹl o, ojibh-ojibh ọnang bọng! Anyi wọ ode macha bọng, p'Ọvaar Ibinọkpaabyi ọkk'ọkkaana o? Kẹ wọ ode ọkhọhnkpa kwabọng ọmaana ọkkaan kwabọng, obiro ode okhem-egbong kwabọng. Attattaanga-nọng pabọng áwobha irekhirek kwabọng, bọng ábira abari bẹ mmo. ");
INSERT INTO mfo_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","Iwa Mosẹs ovura k'egbegbeho cha Nebo, ttẹwọr ka mgbegbeho sa Moab maa, opyiri k'ebir-ebir kwa Pisga, kw'okkeri Jẹrikọ itzitzikha. Mẹ wọ kw'owobh yina Ọvaar Ibinọkpaabyi ọkhọhkh-ẹ irerek nnuma biphyir, ttẹwọr ka Gilead maa, apyiri ka Dan, ");
INSERT INTO mfo_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","ọmaana ẹkhọma cha Naphtali biphyir, ọmaana ekhọma ch'Ephriam ọmaana cha Manasẹ, ttara irerek sa Juda biphyir maa, atza apyiri k'ọraanga kw'ideden kwa Mẹditeraniya, ");
INSERT INTO mfo_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","ọmaana ka Nẹgẹv ttara ẹkhọma biphyir ch'ẹttẹwọr k'ittolim sa Jẹriko, ọmaana odedenmon kw'Aji, atzima atza apyiri ka Zoar. ");
INSERT INTO mfo_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Wa Ọvaar Ibinọkpaabyi ọben-ẹ bi, “Ma wọ ode irerek s'iwa ndọk ọnwọhngi nchekhi bi nnang, Abraham ọmaana Isaak ttara Jekọb, k'ogbe kw'iwa mbeni bi, ‘Kaam ńnang va pa va pabọng irerek nna.’ Kaam nkk'ọ ọbọhk ntta are sẹ ttara chen pọ, yina, kọ m'irerek nnuma kádim.” ");
INSERT INTO mfo_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Iwa Mosẹs kw'ode ọtzọhmnọng kw'Ọvaar Ibinọkpaabyi, ọpe ka Mọab mach'iwa Ọvaar Ibinọkpaabyi okk'ọgbaakha. ");
INSERT INTO mfo_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Wa Ọvaar Ibinọkpaabyi ọnọhnga Mosẹs ka Moab, k'ittolim s'ikkeri Bẹt-Pẹor itzitzikha. Yina, tzọni k'ewu nduma maa, apyiri ma, onong kw'orong ibe s'epekhubh cha Mosẹs ewobh, kode. ");
INSERT INTO mfo_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Wa Mosẹs ope da ode, cho arọbh azadani, kaambi mẹ wọ, wa Mosẹs otzim om-ore owonikpa bi ttaan, obiro obe ka nchi sẹ bi gbuuk. ");
INSERT INTO mfo_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Iwa anọng p'Israẹl awọbha ka nkwosisi s'obo kwa Mosẹs ka mgbegbeho sa Moab, k'iwu ẹrọbh obhiri jobh maa, ogbe kw'obhoma ọmaana nkwosisi ọha. ");
INSERT INTO mfo_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Iwa Joshua kw'ode nnwa kwa Nun, ọkk'ọfha ttara egwugwuma ch'ekkoji, da iwa Mosẹs ọkk'ẹ ọbọhk ọnana k'eho. Wa anọng p'Israẹl ayonga itzọhng anang-ẹ Joshua, bẹ asi idik s'Ọvaar Ibinọkpaabyi okk'Mosẹs ọtzọhna. ");
INSERT INTO mfo_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","Tzọni k'ogbe nwuma maa, apyiri ma, ọsẹjaakhi manda wani kw'ode macha Mosẹs k'Israẹl, kw'iwa Ọvaar Ibinọkpaabyi ọgbaakhi atzim, itzitzikha ttara itzitzikha kode. ");
INSERT INTO mfo_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","Wa osi ikkokkoni-dik ọmaana idik s'ipe anọng for biphyir, s'iwa Ọvaar Ibinọkpaabyi ọtzọhm-ẹ bi ọtza osi k'Ijip, ọnang Phero ọmaana akhaannọng pẹ ttara anọng p'ẹkhọma nduma biphyir. ");
INSERT INTO mfo_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","Ọnọng manda wani kode kw'okk'ẹfa-barada nda ọkhọhkha, kaambi ikkokkoni-dik nna s'iwa Mosẹs ọsi k'itzitzikha s'anọng p'Israẹl biphyir rọ.");
INSERT INTO mfo_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","K'ogbe kw'iwa Mosẹs kw'ode ọtzọhmnọng kw'Ọvaar Ibinọkpaabyi ọkk'ọpa, Ọvaar Ibinọkpaabyi oben Joshua kw'ode nnwa kwa Nun, obiro ode ọnọng kw'ojem Mosẹs mbọhk ka nnam bi: ");
INSERT INTO mfo_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“Mosẹs kw'ode ọtzọhmnọng kwaam ọkk'ọpa. Kọ do for madẹdẹn, atzima anọng mba eden bọng ajekha Ọraanga kwa Jọrdan, achina k'irerek sa mbeni bi nnang bẹ-bẹ anọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Kaam ńnang bọng ibe kpenamkpen sa bọng abari ẹtzọkhi, atzor k'echekhi ch'iwa nsi nnang Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Ẹkhọma chọ ẹ́ttẹwọr k'íbe s'anọng an-arukhi maa, epyiri ka Lẹbanọn, efona maa, epyiri k'Ọraanga kw'ọbari ẹkpa kw'Euphrates, epyiri k'ẹkhọma ch'anọng pa Het maa, atza epyiri k'Ọraanga kw'ideden kwa Mediteraniya k'okhubha kw'ewuchen em-edimi. ");
INSERT INTO mfo_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Ọnọng manda wani kw'ọ́fha ọ́bọ-ọ abẹ k'akpen pọ biphyir, kóde. Odem nwa kw'iwa nwobh ttara Mosẹs, mando kwa ńwobha ttara kọ. Kaam k'ọbọhk kíntte, nnam kímbiri mkpa mbọr-ọ. ");
INSERT INTO mfo_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Kọ be bi pyiir abira abar ettem, okhuri bi, kọ wọ atzima anọng mba eden, bẹ atzọkha ekkema ch'irerek s'iwa nkk'nchekhi bi, nnang abotte. ");
INSERT INTO mfo_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Kọ be bi pyiir abira ado ettem abar. Kọ tzọkha ogbe ahakha eho anang aphaangi pa Mosẹs kw'ode ọtzọhmnọng kwaam ọnang-ọ; nnam kàkpa abọra bẹ, attena achina k'odimbọhk obiro ode kwabọhk, ifha kọ akhaama ẹnaanga k'ibe kpenamkpen s'achina. ");
INSERT INTO mfo_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Tte atzim pa Nnwẹr nwa kw'Aphaangi anning-ọ k'ẹmma aha; chibhi odik okhuri bẹ k'erungi ọmaana k'ẹya, ifha afha atzọkha ogbe asi odik kpenamkpen kwa bẹ akkeri mẹ. Mẹ wọ osi, kọ ákhaama ojibhada ọmaana ẹnaanga. ");
INSERT INTO mfo_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Kaam nkk'ọ mbena bi, abe bi pyiir abira abar ettem. Ojora oning-ọ osi, kọ bar ettem, ẹfa ening-ọ ẹha, okhuri bi, kaam Ọvaar Ibinọkpaabyi kwa nde Ibinọkpaabyi kwọ, nwobha-owobha k'ibe kpenamkpen sa bọng atza.” ");
INSERT INTO mfo_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Iwa Joshua ọnang adeho p'anọng p'Israẹl ẹfa bi bẹ agbaak bẹ bi: ");
INSERT INTO mfo_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“Bọng nenga makhọra ibhingabe, ‘Bọng do for atzobha ekpo pyabọng. Da k'iwu ittaan k'itzitzikha bọng ájekha Jọrdan ojekha, atza atzọkha irerek nna s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọnangi bọng bi, bọng akhaama.’ ” ");
INSERT INTO mfo_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Mẹ wọ osi, iwa Joshua oben anọng p'ẹkhọma cha Reubẹn, ọmaana anọng pa Gad, ttara ibhaakha rani s'anọng pa Manasẹ bi, ");
INSERT INTO mfo_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“Bọng jima atzim pa Mosẹs kw'ode ọtzọhmnọng kw'Ọvaar Ibinọkpaabyi ọgbaakhi bọng bi, ‘Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng órenga m'irerek nna s'ọ́nang bọng, ọnang bọng ẹwọhngkwokha.’ ");
INSERT INTO mfo_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Panọng pabọng, ọmaana va pabọng, ọmaana etzirakpo pyabọng, afha awobha m'irerek nna sa Mosẹs okk'bọng ọnanga k'okhubha kw'ewuchen em-eyin ka Jọrdan. Yina, arim-egbong pabọng biphyir p'akk'for ada k'egbong, akhaambi achi anọng p'Israẹl eden ajekha. Kọ wọ akkaana bẹ ");
INSERT INTO mfo_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","maa, Ọvaar Ibinọkpaabyi ọnang bẹ ẹwọhngkwokha maa, bẹ-bẹ abira atzọkha irerek nna akhaama s'Ọvaar Ibinọkpyaabyi, kw'ode Ibinọkpaabyi kwabọng ọnangi bọng. Abọng akk'mando asa, bọng afha akpa nnam abhana atza atzọkha irerek sabọng, sa Mosẹs kw'ode ọtzọhmnọng kw'Ọvaar Ibinọkpaabyi okk'bọng ọnanga, k'okhubha kwa Jọrdan kw'okkeri itzitzikha k'okhubha kw'ewuchen em-eyin.” ");
INSERT INTO mfo_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Mẹ wọ ofon, anọng mba abhina Joshua bi, “Odik kpenamken nwa kw'akk'man ẹfa ananga, mósi-osi, ibe kpenamkpen s'atzọhmi man, mọtza-ọtza” ");
INSERT INTO mfo_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Odem nwa kw'iwa mọhak eho ọnang Mosẹs, mando kwa mọ́hakha eho ọnang-ọ. Tte Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwọ owobha ttar khọ, mach'iwa owobh ọmaana Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Ọnọng kpenamkpen kw'osi irẹrẹkhi otzima otzor atzim pọ, eho kọhak ọnang bẹ, odik kpenamkpen kw'anangi bẹ ẹfa bi bẹ asi, bẹ ásẹ-ẹ osi. Kọ khinggẹ be bi pyiir abira abar ettem!” ");
INSERT INTO mfo_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Iwa Joshua kw'ode nnwa kwa Nun ọtzọhm nttọ mfa sa mfon Shitim ka ndubhama, oben bi, “Bọng nọhng atza rom ẹkhọma nduma, kpọng-kpọng e, Jeriko.” Mando kwa bẹ afon atza adim k'ọhọhm kw'ọzaza-kwanọng kw'okpen Rahab, awobha mẹ. ");
INSERT INTO mfo_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Iwa bẹ atza agbaak ọvaarnọng kwa Jeriko bi, “Kker e, ajinọng bani p'afon Israẹl akk'akwa m'erungiwu nda bi, bẹ akwu arom ẹkhọma nda e.” ");
INSERT INTO mfo_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Mẹ wọ ofon ọvaarnọng kwa Jeriko ọtzọhm ẹkkaabha ochena Rahab, oben bi, “Kọ tzima ajinọng mba p'akwu adim m'ọhọhm kwọ akwu, kkeri, bẹ akwu bi bẹ akwu arom ẹkhọma nda biphyir.” ");
INSERT INTO mfo_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Ode cha kwanọng nwa okk'ajinọng mba afa ọtzọkha odubha. Yina, obhina ọvaarnọng bi, “K'odik-ọkka, ajinọng afa akk'aam akwu akhebha mando e. Yina, kaam ibe sa bẹ afon akwu kinnong e. ");
INSERT INTO mfo_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Ira bẹ afon ka nchọhkha-bọhk, yina ira bẹ an-agbakhi ẹbaakhamma ch'obhon e. Kaam ibe sa bẹ areng afona kinnong e. Bọng nọhng ẹbhar-ẹbhar akhubh bẹ k'eden, asi mẹ, bọng ákhebha bẹ okhebha.” ");
INSERT INTO mfo_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","(Yina, okk'ajinọng mba afa otzima ovura k'ẹnyọhng, otza odubha k'abọhnga pa ngwugwuma p'ọyaani k'ọhọhm ebir-ebir.) ");
INSERT INTO mfo_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Mando kw'anọng mba akhubhi nttọ nna ka nnam k'eden ch'echin ka Jọrdan. K'ogbe kw'ajinọng p'akhubhi nttọ nna akk'ayina k'iyaan, bẹ abhen ẹbaakhamma ch'obhon. ");
INSERT INTO mfo_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Yina nttọ nna nttaabha m'erungi nduma, kwanọng nwa ovura k'ẹnyọhng, ");
INSERT INTO mfo_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","ọtza oben bẹ bi, “Kaam nnong kẹ bi, Ọvaar Ibinọkpaabyi okk'bọng ẹkhọma nda ọnanga e. Bọng ajor man kpọng-kpọng e. Maman anọng p'ẹkhọma nda mon-orukhi k'ojora f'ideden. ");
INSERT INTO mfo_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Da mọkk'ọbhaanga odem kw'Ọvaar Ibinọkpaabyi osi asi akka k'Ẹraanga-khora, k'ogbe kwa bọng abin k'Ijip. Mobiro ọbhaanga odem kwa bọng asi ọvaar Sihọn ọmaana ọvaar Og, p'ade avaarnọng p'anọng p'Amọr pa bọng adimi biphyir-phyir, k'okhubha kwa Jọrdan kw'ewuchen em-eyin. ");
INSERT INTO mfo_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Mada mọbhaang kwẹ, nttem iyọhn man, ẹfa ebire ẹha man okhuri bọng. Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng, wọ ọdabhi ẹrọng ọmaana irerek. ");
INSERT INTO mfo_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","“Bọng na chekhi ka che ch'Ọvaar Ibinọkpaabyi bi, bọng asi ejibha osi anang ẹhọhmmọr chaam, okhuri ejibha cha kaam nsi nnang bọng. Bọng nang-m ẹkhọhkha ");
INSERT INTO mfo_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","cha ndima nkhera bi, bọng atte otte kwaam ọmaana ọkka kwaam, ọmaana vọkka paam p'ijinọng ọmaana p'ipanọng ttara anọng pabẹ biphyir, ọbọhk otte. Tzotzokhaan, bọng kkaana man.” ");
INSERT INTO mfo_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Mẹ wọ ofon, ajinọng mba aben-ẹ bi, “Idikha bọng ape, tte maman obiro ope ọdọk. Abọng ani anọng odik kw'am-omosi ma agbaakhi, k'odik-ọkka, mosi ejibha osi ọnang-ọ, k'ogbe kw'Ọvaar Ibinọkpaabyi ọnang man ẹkhọma nda e.” ");
INSERT INTO mfo_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Mando kw'ọnangi ajinọng mba edik, cha bẹ atzim arenga k'ọphaphamma atto k'ọbaakha okhubha, okhuri da iwa ọhọhm kwa Rahab ọkwọhkhi k'echumi ch'ọbaakha kw'obhon. ");
INSERT INTO mfo_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","On-oben ajinọng mba bi, “Bọng nnọbh achina k'okhubha kwa mgbegbeho, ifha anọng p'am-akhubbh bọng, aningi bọng are. Bọng chubha mẹ k'iwu ittaan maa, bẹ akhuna k'obhon yina bọng an-afona o.” ");
INSERT INTO mfo_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Mẹ wọ ofon, ajinọng mba aben-ẹ bi, “Maman ohok echekhi nda ohok ch'am-ọkk'ọtzọkha ");
INSERT INTO mfo_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","ttara nttak bi, kọ akpa ọbarakpa-khora m'edik nda ch'am-otzim orenga m'ọphaphamma ọhakha k'ọbaakha-okhubha, ọmaana bi, kọ ayeri atte ọmaana akka, ọmaana vọkka pọ p'ijinọng ọmaana p'ipanọng ttara anọng pọ biphyir, atzima adim k'ọhọhm kwọ. ");
INSERT INTO mfo_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Idikha ọnọng manda wani ofon k'ọhọhm kwọ oyin k'ẹkpaangaden, akpen pẹ abhakhi anan-ẹ k'eho, odik kwa man arang mẹ. Onode anọng p'awobh k'ọhọhm kwọ ẹtzaanga, ọttọhk manda vani osi bẹ, akpen pabẹ akpekhi man ka nho. ");
INSERT INTO mfo_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Yina, idikha kọ an-ajaakhi odik kw'am-omosi ma, echekhi nda ch'atzim man mosi, man kẹ́bọkha.” ");
INSERT INTO mfo_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Kwanọng nwa obhina bi, “Kaam nkk'nkhera. Tte kwẹ ode macha bọng abeni.” Mando kw'otte bẹ ọbọhk, bẹ afona. Ọtzọkha ọbarakpa-khora ọkpa m'edik nduma ch'ọphaphamma. ");
INSERT INTO mfo_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Mada bẹ afon, bẹ achubha k'okhubha kwa mgbegbeho kw'iwu ittaan maa, ajinọng p'am-akhubh bẹ afona akhuna mbọhk-mbọhk. ");
INSERT INTO mfo_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Mando kw'ajinọng mba afa abin orenga akpa nnam. Bẹ ahakha abina ka mgbegbeho, awọna atza ajekha ọraanga akhebha Joshua kw'ode nnwa kwa Nun, atzọkha odik kpenamkpen kw'ọkk'ọtta okhebha bẹ, agbaakh-ẹ. ");
INSERT INTO mfo_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Bẹ aben Joshua bi, “K'odik-ọkka, Ọvaar Ibinọkpaabyi okk'irerek nnuma biphyir ọtzọkha ọnang man. Anọng biphyir ayọhni nttem k'ojora okhuri man e.” ");
INSERT INTO mfo_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Iwa Joshua ọmaana anọng p'Israẹl biphyir abina k'ekpekpebha ka Shitim achina ka Jọrdan, kẹ da bẹ abhingi yina bẹ an-ajek k'ọraanga okhubha. ");
INSERT INTO mfo_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Mada iwu ittaan ikk'ikwọbha, adeho p'Israẹl arenga akhọri ibhingabe, ");
INSERT INTO mfo_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","am-agbaak anọng bi: “Idikha bọng are da afọhnẹja atzini Ẹkkọhbhi ch'Echekhi ch'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, bọng bina m'ẹbaa k'obe fabọng atzọn chẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Mẹ wọ kwa bọng aronga eden cha bọng árenga. Da bọng ani k'okhubha nwa atzima am-arenga. Yina, bọng dima ndọkhi nnọhna nzen anang Ẹkkọhbhi ch'Echekhi ọphaangi; bọng chẹ kàbira abaanga.” ");
INSERT INTO mfo_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Mẹ wọ ofon, Joshua oben anọng mba bi, “Bọng do nttem sabọng ewobha, kkeri ophyini Ọvaar Ibinọkpaabyi ósi ikkokkoni-dik osi kabọng k'ottem.” ");
INSERT INTO mfo_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Joshua oben afọhnẹja mba bi, “Bọng dini Ẹkkọhbhi ch'Echekhi atzima achi anọng eden.” Wa bẹ atzini chẹ atzima achi anọng eden. ");
INSERT INTO mfo_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Iwa Ọvaar Ibinọkpaabyi oben Joshua bi, “Mayina kwa kaam nttẹwọr ndin-ọ k'ẹrọng k'itzitzikha s'anọng p'Israẹl, ifha bẹ afha aronga bi, kaam nwobh ttar-ọ mach'iwa nwobh ttara Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Gbaak afọhnẹja p'am-atzini Ẹkkọhbhi ch'Echekhi bi: ‘Bọng apyiri m'ọraanga-ọkhaan-ọkhaan kwa Jọrdan, bọng hakha k'asi ẹtzaanga abe mẹ.’ ” ");
INSERT INTO mfo_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Mando kwa Joshua obeni anọng p'Israẹl bi, “Bọng nenga akwu ayonga itzọhng, abhaanga atzim p'Ọvaar Ibinọkpaabyi kw'ode Ibinọkpaabyi kwabọng ọgbaakhi. ");
INSERT INTO mfo_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Odem kwa bọng átzima aronga bi, Ọvaar Ibinọkpaabyi owobh m'ottem kwabọng, ọmaana bi, k'odik-ọkka kẹ ókhubh anọng pa Kenaan okhubh, ọmaana anọng pa Het, ọmaana pa Hiv, ọmaana pa Pẹriz, ọmaana pa Girgash, ọmaana p'Amọr ttara pa Jẹbus ka bọng k'itzitzikha. ");
INSERT INTO mfo_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Bọng nne kwẹ bi, afọhnẹja p'atzini Ẹkkọhbhi ch'Echekhi ch'Ọvaar Ibinọkpaabyi kw'ọyagbin bi waam, bọ achi bọng eden ahakha k'asi. ");
INSERT INTO mfo_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Bọng dekha ajinọng jobh obhiri afa, ka mfonamma s'Israẹl. Efonamma kpenamkpen ọnọng wani. ");
INSERT INTO mfo_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Mada afọhnẹja p'atzim Ẹkkọhbhi ch'Echekhi ch'Ọvaar Ibinọkpaabyi kw'ọyagbin bi waam, ábari mmo k'ọraanga kwa Jọrdan bi kpaar, asi p'am-abhobh ahakha ákpaara-ọkpaara, an-abira abe mach'echumi e.” ");
INSERT INTO mfo_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Mada anọng mba abin orenga atte ibhingabe ọbọhk bi, bẹ ajekha ọraanga kwa Jọrdan, afọhnẹja p'atzim Ẹkkọhbhi ch'Echekhi atza achi bẹ eden. ");
INSERT INTO mfo_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Wa ọraanga kwa Jọrdan ọm-ọnwa m'ọphagbe biphyir. Kaambi mẹ wọ, afọhnẹja p'atzim Ẹkkọhbhi ch'Echekhi apyiri ma Jọrdan bi kpaar, abari mmo sabẹ m'asi ọkhaan-ọkhaan. ");
INSERT INTO mfo_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","Asi akwọbha obhobhobh k'ebira-ebira. Bẹ an-agaangi mach'echumi, ttẹwọr mẹ maa, atza apyiri k'odedenmon kw'okpen Adam, k'ẹkhọma cha Zarẹtan, asi p'irekhirek p'abhobhi atza anwa k'Ọraanga kw'Ideden kw'Araba (kw'ode Ọraanga kw'Ideden kw'Onung) akpaara biphyir-phyir. Ofona mẹ, wa anọng mba ajekha k'okhubha kw'okkeri Jẹriko itzitzikha. ");
INSERT INTO mfo_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Wa afọhnẹja p'atzim Ẹkkọhbhi ch'Ẹchekhi ch'Ọvaar Ibinọkpaabyi abe k'ogbin, m'ottem kw'ọraanga kwa Jọrdan, anọng biphyir p'Israẹl am-arenga m'ogbin ajekha maa, ẹkhọma nda biphyir ejekha. ");
INSERT INTO mfo_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Mada ẹkhọma ch'Israẹl biphyir ẹkk'ọraanga kwa Jọrdan ejekha, Ọvaar Ibinọkpaabyi on-oben Joshua bi, ");
INSERT INTO mfo_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“Tzekha ajinọng jobh obhiri afa k'ottem kw'anọng mba, wani k'ẹkhọma kpenamkpen, ");
INSERT INTO mfo_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","aben bẹ bi, bẹ adungi atza jobh obhiri afa k'odimbọhk kw'afọhnẹja abe, m'ottem kw'ọraanga kwa Jọrdan, bọng atzima bẹ ajekha atza ahok k'ibe sa bọng awobha m'erungiwu cha mayina.” ");
INSERT INTO mfo_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Mando kwa Joshua oyeri ajinọng mba jobh obhiri afa p'okk'otzekha k'ottem kw'anọng p'Israẹl, wani k'efonamma kpenamkpen, ");
INSERT INTO mfo_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","oben bẹ bi, “Bọng nọng k'ottem kw'ọraanga kwa Jọrdan, k'itzitzikha Ẹkkọhbhi ch'Echekhi ch'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng. Tte ọnọng-ọnọng otzini ọtza wani-wani ọnana k'ẹbabaang, atzor k'odem kwa mfonamma s'Israẹl nde, ");
INSERT INTO mfo_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","ifha ode mach'ẹkhọhkha k'ottem kwabọng. Ikhina va pa va pabọng abọbhi bọng bi, ‘Atza mba ayini yan anang mbọng o?’ ");
INSERT INTO mfo_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","Bọng gbaak bẹ bi, wa ọraanga kwa Jọrdan ọkpaar k'itzitzikha s'Ẹkkọhbhi ch'Echekhi ch'Ọvaar Ibinọkpaabyi. K'ogbe kw'Ẹkkọhbhi nda ejek ọraanga kwa Jọrdan, asi p'ọraanga kwa Jọrdan akpaara. Atza mba áde ojima anang anọng p'Israẹl maa, ikhina ogbe ode. ");
INSERT INTO mfo_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Mando kw'anọng p'Israẹl asi macha Joshua ọtzọhni bẹ. Bẹ atzini atza jobh obhiri afa m'ottem kw'ọraanga kwa Jọrdan, atzor k'obhik kwa mfonamma s'Israẹl, mach'iwa Ọvaar Ibinọkpaabyi okk'Joshua ọgbaakha; wa anọng p'Israẹl atzima atza mba ajekha atza ahok k'ibhingabe sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Joshua oben anọng mba atzọkha atza mba jobh obhiri afa, k'ottem kw'ọraanga kwa Jọrdan, attima k'ibe s'ira afọhnẹja p'am-atzini Ẹkkọhbhi ch'Echekhi abe. Atza mba an-abe mẹ maa, apyiri k'ewu cha mayina. ");
INSERT INTO mfo_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Iwa afọhnẹja p'atzini Ekkọhbhi ch'Echekhi abe m'ẹraanga-ttem cha Jọrdan maa, anọng p'Israẹl, asi odik kpenamkpen kw'Ọvaar Ibinọkpaabyi okk'orenga ka Joshua ọtzọhn bẹ, atzor k'odem kw'iwa Mosẹs ọkk'Joshua ọtzọhna. Wa anọng mba adukha ajekha. ");
INSERT INTO mfo_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Mada bẹ biphyir akk'ajekha, Ẹkkọhbhi ch'Echekhi ch'Ọvaar Ibinọkpaabyi, ọmaana afọhnẹja an-arenga atza abe anọng mba k'ororo, anọng mba am-abe akkeri bẹ. ");
INSERT INTO mfo_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Wa ajinọng p'efonamma cha Reuben, ọmaana cha Gad ttara ibhaakha rani s'anọng p'efonamma cha Manasẹ ajekha k'okhubha ado for s'egbong, k'itzitzikha s'anọng p'Israẹl, macha Mosẹs okk'bẹ ọtzọhna. ");
INSERT INTO mfo_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Wa arim-egbong p'apyiri nnọhna arọbh azen bọ ajek k'okhubha k'itzitzikha s'Ọvaar Ibinọkpaabyi, achina ka mgbegbeho sa Jeriko bi, atza arima egbong. ");
INSERT INTO mfo_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","M'ewu nduma Ọvaar Ibinọkpaabyi ọnang Joshua abarada k'itzitzikha s'anọng p'Israẹl biphyir. Tzọni m'ewu nduma anọng p'Israẹl an-anang Joshua ikpokopbha k'akpen pẹ biphyir, mach'iwa bẹ akk'Mosẹs ananga. ");
INSERT INTO mfo_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Mẹ wọ ofon, Ọvaar Ibinọkpaabyi oben Joshua bi, ");
INSERT INTO mfo_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“Nang afọhnẹja p'am-atzini Ẹkkọhbhi ch'Echekhi ch'Aphaangi ẹfa bi, bẹ avura k'ogbin kw'ọraanga kwa Jọrdan.” ");
INSERT INTO mfo_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Joshua ọnang afọhnẹja mba ẹfa oben bi, “Bọng vura k'ogbin kw'ọraanga kwa Jọrdan.” ");
INSERT INTO mfo_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Mando kwa afọhnẹja mba atzini Ẹkkọhbhi ch'echekhi ch'Ọvaar Ibinọkpaabyi avura k'ogbin kw'ọraanga kwa Jọrdan. Bẹ abari mmo k'ogbin bi kpaar, asi p'ọraanga kwa Jọrdan abira abhuna, bẹ abhobh mach'iwa bẹ am-akkekkeni abhobh. ");
INSERT INTO mfo_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","K'iwu jobh s'ocheden-phe, anọng p'Israẹl abina ka Jọrdan atza abhing ka Gilgal, k'okhubha kw'ewuchen em-eyin k'enem cha Jeriko. ");
INSERT INTO mfo_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Ma Gilgal wọ kwa Joshua ọtzọk atza mba jobh obhiri afa otttima, pa bẹ akk'atzọkha k'ọraanga kwa Jọrdan. ");
INSERT INTO mfo_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Oben anọng p'Israẹl bi, “Ikhina va pa va pabọng abọbhi ab'atte bi, ‘Atza mba ayini yan o?’ ");
INSERT INTO mfo_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","Bọng gbaak bẹ bi, ‘Wa anọng p'Israẹl areng k'ogbin ajekha ọraanga kwa Jọrdan.’ ");
INSERT INTO mfo_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Da Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng wa osi ogbin oyin k'ọraanga kwa Jọrdan k'itzitzikha sabọng maa, bọng ajekha k'okhubha. Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng osi odik nwa k'ọraanga kwa Jọrdan, mach'iwa ọkk'ọsa k'Ẹraanga-khora, k'ogbe kw'iwa ọsẹ-ẹ ọphaangi m'itzitzikha saman maa, mojekha k'okhubha. ");
INSERT INTO mfo_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Wa osi idik nna ifha idibhon s'ọyabgin biphyir ironga ẹfa ch'Ọvaar Ibinọkpaabyi, ttara bi, bọng abira akhaama ojora f'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng.” ");
INSERT INTO mfo_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","K'ogbe kw'avaar biphyir p'adabhi anọng p'Amọr p'arukhi k'okhubha kw'ewuchen em-edimi ka Jọrdan, ọmaana avaar biphyir p'adabhi anọng pa Kenaan p'arukhi k'ọraanga ọkhaan-ọkhaan kw'Ọraanga kw'ideden kwa Mediteraniya, abhaang eden ch'Ọvaar Ibinọkpaabyi ọkk'ọraanga kwa Jọrdan ọphaangi k'itzitzikha s'anọng p'Israẹl, wa bẹ ajekha k'okhubha. Wa ojora f'ideden osi bẹ maa, bẹ ẹfa dọk kakhaam cha bẹ abira afha abe bẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","M'ogbe nwuma, Ọvaar Ibinọkpaabyi oben Joshua bi, “Si mkpẹr atzima asi anọng p'Israẹl ọkpakkọrikkọ.” ");
INSERT INTO mfo_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Mando kwa Joshua osi mkpẹr otzima osi anọng p'Israẹl ọkpakkọrikkọ ka Gibeat-Haralot. ");
INSERT INTO mfo_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","Odik kw'osi yina iwa osi ọkpakkọrikkọ nwa ode bi: Wa ajinọng biphyir p'abin k'Ijip p'ade ọgbọ kw'arim-egbong, ape k'ọkkadeden k'ibe s'anọng an-arukhi, k'ogbe kwa bẹ akk'abina k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","Wa ajinọng biphyir p'abin k'Ijip akk'ọkpakkọrikkọ asa. Yina, ajinọng biphyir p'iwa an-amaan k'ogbe kwa bẹ asi orenga nwa k'ibe s'anọng an-arukhi, bẹ bẹ ọkpakkọrikkọ atzima asa. ");
INSERT INTO mfo_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","Wa anọng p'Israẹl akk'arenga akhọri ibe s'anọng an-arukhi ka cho arọbh afa maa, ajinọng p'iwa ade ọgbọ kw'arim-egbong p'abin k'Ijip ape biphyir. Da iwa bẹ ani eho ahak anang Ọvaar Ibinọkpaabyi. Wa Ọvaar Ibinọkpaabyi okk'ochekhi ọnang bẹ bi, bẹ irerek ọkkakka nnuma káre s'abasi ọmaana akhọkhọnana ahaabh-ọhaabh, s'iwa okk'ochekhi ttara ettem chẹ biphyir bi, ọnang ab'otte. ");
INSERT INTO mfo_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Mẹ wọ ofon, wa Ibinọkpaabyi otzima va pabẹ p'ijinọng otzera bẹ, va mba bọ iwa ade anọng pa Joshua osi ọkpakkọrikkọ, da iwa bẹ ani bẹ ọkpakkọrikkọ asi k'ọkkadeden. ");
INSERT INTO mfo_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Mada ajinọng p'ẹkhọma biphyir akk'ọkpakkọrikkọ ẹsa, bẹ an-awobha m'ibhingabe maa, for igaangi bẹ. ");
INSERT INTO mfo_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Mẹ wọ ofon, Ọvaar Ibinọkpaabyi oben Joshua bi, “Mayina, kaam nkk'bọng nnọbha k'ọgbarsa-dik kw'anọng p'Ijip.” Mẹ wọ osi, bẹ ayeri ibe nnuma Gilgal maa, apyiri k'ewu cha mayina. ");
INSERT INTO mfo_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","K'ẹchọhkha ch'iwu ọhawani kwa chi s'ophe, mada bẹ abhingi ka Gilgal ka mgbegbeho sa Jeriko, anọng p'Israẹl asi ọdadaami kwa Pasova. ");
INSERT INTO mfo_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Mada ewu nduma cha Pasova ẹkwọbh, m'ewu nduma, bẹ achi ẹchakpo byani py'irerek nnuma py'ede: brẹd kwa bẹ ani yist akhe, ọmaana abọkpa-bhaabha. ");
INSERT INTO mfo_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Wa ọchattọhk f'okpen manna ọkwọhbh oyiyin m'ẹwu nduma cha bẹ achi ọchattọhk f'ofon m'irerek nnuma; wa anọng p'Israẹl manna dọk kare kwa bẹ achi, da bẹ achi ọchattọhk f'ẹkhọma cha Kenaan. ");
INSERT INTO mfo_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Mada Joshua okk'Jeriko ọbaanga, otzini chen okkeri k'ororo ore ojinọng kw'ọbẹ-ẹ k'itzitzikha, ttara ọkkangkkaang kw'ọrọbh k'ọpa otzima k'ọbọhk. Joshua ọtza okhebh-ẹ ọbọbh bi, “Da maman owobh, attattaanganọng paman awobha, man kwa kọ abe?” ");
INSERT INTO mfo_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Ojinọng nwa obhina bi, “Kaam ka nnam s'ọnọng manda wani kimbe e. Yina, kaam nkk'nkwa mach'odenho kw'arim-egbong p'Ọvaar Ibinọkpaabyi.” Mando kwa Joshua otto okhubha itzitzikha k'irek k'ikpokpobha, ọbọbh-ẹ bi, “Bọng ẹkkaabha dọ ch'itta kwaam ọkhaam bi, ọnang kaam ọtzọhmnọng kwẹ o?” ");
INSERT INTO mfo_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Odenho nwa kw'arim-egbong p'Ọvaar Ibinọkpaabyi, obhina bi, “Wọra ekpo pya mmo pyọ; kkeri ibe nna sa be ma ide ibe s'iwur-owur.” Wa Joshua e, osi mando. ");
INSERT INTO mfo_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","M'ogbe nwa wa bẹ agbakhi mbaakhamma sa Jeriko k'eden-ọkka okhuri anọng p'Israẹl. Wa ọnọng kw'ofon k'iyaan odim k'obhon ẹtzaanga, kode. Ọnọng kw'obiro ofona k'obhon ẹtzaanga oyin k'iyaan, kode. ");
INSERT INTO mfo_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Mando kw'Ọvaar Ibinọkpaabyi obeni Joshua bi, “Kker e, kaam nkk'Jeriko ndọkha ngọ-ọ ka mbọhk, ọmaana ọvaarnọng kwabẹ ttara arim-egbong pabẹ bi, akhema. ");
INSERT INTO mfo_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Kọ tzima arim-egbong pọ biphyir arenga akhọri odedenmon nwa ogbe wani k'ewu. Si mando k'iwu izadani. ");
INSERT INTO mfo_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Kọ rọbha afọhnẹja azenamfa p'atzim abukpọhng p'arukhimaanha abe k'itzitzikha s'Ẹkkọhbhi ch'Echekhi. K'ewu ch'ettong iwu izenamfa, tzima arim-egbong pọ, ọmaana afọhnẹja p'am-agyi abukpọhng, bọng arenga akhọri odedenmon nwa igbe izenamfa. ");
INSERT INTO mfo_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Ogbe kwa bọng abhaang da bẹ agyi abukpọhng mba, ben arim-egbong pọ biphyir bẹ awuri ẹmọng k'ẹrọng; k'odem kw'echumi ch'ọbaakha kw'odedenmon nwa etto, ifha arim-egbong biphyir adim k'odedenmon ẹtzaanga.” ");
INSERT INTO mfo_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Mando kwa Joshua kw'ode nnwa kwa Nun oyeri afọhnẹja, oben bẹ bi, “Bọng dọkha Ẹkkọhbhi ch'Echekhi ch'Ọvaar Ibinọkpaabyi, ọmaana afọhnẹja azenamfa p'atzim abukpọhng p'abe Ẹkkọhbhi nda k'itzitzikha. ");
INSERT INTO mfo_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Mando kw'ọnangi arim-egbong mba ẹfa bi, “Bọng china ororo! Bọng nenga akhọri odedenmon nwa, tte abaabhi p'ade arim-egbong achi Ẹkkọhbhi ch'Echekhi ch'Ọvaar Ibinọkpaabyi eden.” ");
INSERT INTO mfo_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Mada Joshua ọkk'anọng mba idik nna ọgbaakha, afọhnẹja mba azenamfa p'atzim abukpọhng azenamfa k'itzitzikha s'Ọvaar Ibinọkpaabyi, akwọbha k'ororo, am-agyi abukpọhng pabẹ, Ẹkkọhbhi ch'Echekhi ch'Ọvaar Ibinọkpaabyi ebire etzor bẹ nnam. ");
INSERT INTO mfo_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Abaabhi p'ade arim-egbong acheden, afọhnẹja p'agyi abukpọhng ajema, yina ọkhaana kw'abaabhi on-otzori Ẹkkọhbhi ch'Echekhi nnam. M'ogbe nwa biphyir bẹ achina ororo agyi abukpọhng. ");
INSERT INTO mfo_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Yina, ode cha Joshua okk'arim-egbong ẹfa ọnanga bi, “Bọng agbong-mọng kàkkọhn, bọng iyọkhi kàsi, bọng ẹmọng manda dani kàkpẹbh maa, opyiri ewu cha mben bọng bi, bọng akpẹbh. Mẹ kwa bọng akpẹbh!” ");
INSERT INTO mfo_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Mando kw'obeni bẹ atzini Ẹkkọhbhi ch'Echekhi ch'Ọvaar Ibinọkpaabyi atzima akhọri odedenmon. Bẹ atzima chẹ akhọri ogbe wani, yina arim-egbong an-abhan k'ibhingabe atza attaabha m'erungi nduma. ");
INSERT INTO mfo_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Joshua e, ọphyọbha k'ekpekpebha ch'ewu ehobh mẹ, afọhnẹja atzini Ẹkkọhbhi ch'Echekhi ch'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Afọhnẹja mba azenamfa p'atzim abukpọhng azenamfa akwọbha am-agyi abukpọhng mba, yina Ẹkkọhbhi ch'Echekhi ch'Ọvaar Ibinọkpaabyi en-ejem. Arim-egbong achi bẹ eden k'ororo, yina ọkhaana kw'abaabhi on-otzori Ẹkkọhbhi ch'Echekhi ch'Ọvaar Ibinọkpaabyi nnam. Bẹ am-achina ororo agyi abukpọhng. ");
INSERT INTO mfo_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Ottong iwu ifa bẹ abira arenga akhọri odedenmon ogbe wani, yina bẹ an-abhan k'ibhingabe. Wa bẹ asi mando k'iwu azadani. ");
INSERT INTO mfo_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Ottong iwu izenamfa, bẹ abina m'owuhobha akhọri odedenmon nwa igbe izenamfa macha bẹ am-akkekkeni asi. Ode ngọmi kwẹ on-ode bi, wa bẹ an-akhọri odedenmon nwa igbe izenamfa m'ewu nduma. ");
INSERT INTO mfo_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Okwu ottonga igbe izenamfa sa bẹ akk'akhọri, afọhnẹja agyi abukpọhng. Mando kwa Joshua ọnangi arim-egbong ẹfa oben bi, “Bọng kpẹbh! Kkeri Ọvaar Ibinọkpaabyi okk'bọng odedenmon nwa ọnanga! ");
INSERT INTO mfo_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Odedenmon nwa ọmaana idik biphyir s'iwobh k'ẹtzaanga iwobh inang Ọvaar Ibinọkpaabyi bi, okhibhi. Oyongi Rehab kw'ode ọzaaza-kwanọng, ọmaana ọnọng kpenamkpen kw'owobh k'ọhọhm kwẹ bọ ákhaama ẹnaanga, okhuri da iwa ọkkaan odubha nttọ sa mọtzọhmi. ");
INSERT INTO mfo_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Yina, bọng ọttọhk kpenamkpen f'ofon m'obhon nwa kàtzọkha, ifha bọng aningi oponga-pyibha atzọk. Oni mando ode, bọng áwọkhi anọng p'Israẹl atzọkha oponga-pyibha, bọng ábira átzima ọmmamma achena bẹ. ");
INSERT INTO mfo_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Asilva ọmaana gol, ọmaana ẹfhanginẹkpo pya brọns ttara akkonga biphyir ade py'Ọvaar Ibinọkpaabyi py'ewur-owur, pya mọkhaambi mọtza ohok k'ọkkọ-họhm kwẹ.” ");
INSERT INTO mfo_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Mada bẹ agyi abukpọhng, arim-egbong p'Israẹl awuri amọng k'ẹrọng, mada bẹ awuri amọng mba, echumi ch'ọbaakha kwa Jeriko etto, arim-egbong biphyir adim kẹ atzọkha odedenmon nwa. ");
INSERT INTO mfo_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Bẹ atte odedenmon nwa ọbọhk anang Ọvaar Ibinọkpaabyi, bẹ atzima ọkkangkkaang afhu ọttọhk kpenamkpen f'orukhi akpen, ajinọng ọmaana panọng akhar-ọkhara, abar-ọbar, abhaam, ọmaana arukhimaan ttara nnyanyaang. ");
INSERT INTO mfo_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Mando kwa Joshua obeni ajinọng mba afa p'iwa akk'obhon nwa atza aroma bi, “Bọng dim k'ọhọhm kw'ọzaaza-kwanọng nwa, atzim-ẹ ayin k'iyaan ọmaana ọnọng kpenamkpen kw'owobh ttar-ẹ, atzor k'echekhi ch'iwa bọng akhaam ttar-ẹ.” ");
INSERT INTO mfo_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Mando kw'ajinọng mba p'iwa atza arom obhon nwa adimi kẹ bẹ atzima Rehab ayin k'iyaan, ttara otte ọmaana ọkka, ọmaana vọkka p'ijinọng ttara ọnọng kpenamkpen kw'ode kwẹ. Wa bẹ atzima echimma cha Rehab biphyir ayin k'iyaan atza ahok k'iyaan-iyaan s'ibhingabe s'anọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Mada bẹ akk'mando asa, bẹ atza akwọmi odedenmon nwa biphyir ttara ọttọhk kpenamkpen f'owobh kẹ. Yina, wa bẹ atzọkha silva ọmaana gol, ọmaana ẹfhanginẹkpo pya brọns ttara akkonga atza aye k'ọkkọ-họhm kw'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Yina, wa Joshua otte Rehab kw'ode ọzaaza-kwanọng ọbọhk, ọmaana echimma chẹ ttara ọnọng kpenamkpen kw'ode kwẹ, okhuri da iwa odubh ajinọng pa Joshua ọkk'ọtzọhma macha nttọ bi, bẹ atza arom Jeriko. Wa anọng mba an-aruk ttara anọng p'Israẹl maa, apyiri k'ewu cha mayina. ");
INSERT INTO mfo_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","M'ogbe nwuma, Joshua ọtzọr anọng p'Israẹl itzọhng oben bi, “Ọvaar Ibinọkpaabyi ọ́nang ọnọng kpenamkpen ẹmma kw'óben bi, obiro okwu osi odedenmon nwa kwa Jeriko: k'eho ch'ocheden nnwa kwẹ kw'ijinọng dọ cha kẹ ọphaakhi ọgbaari kwẹ; k'eho cha nnwa kwẹ kw'ọkhar ọtzam dọ, cha kẹ ómmun mbaakhamma sẹ.” ");
INSERT INTO mfo_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Mando wọ kw'iwa Ọvaar Ibinọkpaabyi owobh ttara Joshua, obiro osi che chẹ ẹnyaami makhọra ẹkhọma nda. ");
INSERT INTO mfo_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Yina, wa anọng p'Israẹl ẹtzọhng-dọra nda katzọk bi, bẹ akhibhi ọttọhk kpenamkpen f'owobh m'obhon nwa. Wa Akan kw'ode nnwa kwa Karmi, obiro ode nnwa-mona kwa Zimri, kw'ode nnwa kwa Zera, kw'ofon k'ẹkhọma cha Juda, ọtzọkha ekpo byani odubha. Ofona mẹ, Ọvaar Ibinọkpaabyi ọdọkhi ettem itzama-itzama otzima otzor anọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Mada anọng p'Israẹl atzima awobh kẹ da bẹ abhingi ọbaanga Jeriko, Joshua ọtzọhm ajinọng bani bi, bẹ atza arom ẹkhọma cha Ayi, kw'ọbaang Bẹt-Avẹn k'okhubha kw'ewuchen em-edimi ka Bẹtẹl, oben bẹ bi, “Bọng vura atza arom ẹkhọma nda.” Mando kw'ajinọng mba afon atza arom Ayi. ");
INSERT INTO mfo_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","Mada bẹ abhan atza akhebha Joshua, bẹ aben bi, “Arim-egbong biphyir arang p'atzọhm bi, bẹ atza arima Ayi abẹ, afha atzọhm ajinọng nnọhna nzen, obiro ode nnọhna nzenamfa obhiri arọbh jobh o. Arim-egbong biphyir k'ọyayaakhi-dema nwa kàkhe, kkeri anọng p'arukhi m'obhon nwuma kahaabhi.” ");
INSERT INTO mfo_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Mẹ wọ ofon, arim-egbong p'apyiri nnọhna nzenamfa obhiri arọbh jobh avura atza arima Ayi abẹ. Yina, ajinọng p'Ayi an-akhubh anọng p'Israẹl maa, ");
INSERT INTO mfo_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","bẹ afhu bẹ anọng p'apyiri ẹrọbh attaan obhiri azadani. Wa bẹ akhubhi anọng p'Israẹl ttẹwọr k'ẹbaakhamma ch'odedenmon maa, apyiri k'ibe sa bẹ am-atzum atza, bẹ afhu bẹ k'igbegbewọna. Ofona mẹ, ojora osi anọng p'Israẹl maa, ẹfa ebire ẹha bẹ itzama-itzama. ");
INSERT INTO mfo_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Mẹ wọ ofon, Joshua ọjaakhi ọbara f'ọfọr, otto okhubha itzitzikha k'irerek, m'itzitzikha s'Ẹkkọhbhi ch'Echekhi ch'Ọvaar Ibinọkpaayi, owobha mẹ maa, opyiri ẹchọhkha. Wa adedennọng p'Israẹl abira asi odem nwuma wani, bẹ abira agbobha itzọtzọhng kabẹ ka nho. ");
INSERT INTO mfo_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Joshua oben bi, “O Ọvaar Ibinọkpaabyi kw'Ọyọhng, ode yan kw'atzim man ajekha ọraanga kwa Jọrdan, akwu atte man ọbọhk anang anọng p'Amọr bi, bẹ akhema o? Mbeni da iwa ewobha ekk'man ejibha k'okhubha nwonggo kwa Jọrdan. ");
INSERT INTO mfo_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","O Ọvaar Ibinọkpaabyi, bọng odik kwa kaam ngaam bi, mgbaak mada attattaanga-nọng akk'arim-egbong p'Israẹl akhema o? ");
INSERT INTO mfo_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Anọng pa Kenaan ọmaana anọng adọdọk p'ẹkhọma nda ábhaanga odik nwa, bẹ akwu akhọri man akhe k'ottem, abira adimi man emeni m'ọyagbin. M'ogbe nwuma, yan kwa kọ ási ttara che-barada chọ o?” ");
INSERT INTO mfo_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Mẹ wọ ofon, Ọvaar Ibinọkpaabyi oben Joshua bi, “Ode yan kw'am-akhubha itzitzikha k'irerekh o? Bina k'irerek! ");
INSERT INTO mfo_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Anọng p'Israẹl akk'ẹkhọhngkwuri asa. Bẹ akk'echekhi cha nnangi bẹ bi, bẹ ahok avọhkhi. Bẹ akk'ekpo byani pya mbeni bẹ bi, bẹ akhibhi atzọkha; bẹ akk'pyẹ atzọkha atza attara k'ekpo pyabẹ akhaama, bẹ akk'oribh afha, bẹ abira akpa nnam asi ibhora. ");
INSERT INTO mfo_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Odik nwa wọ osi yina anọng p'Israẹl attattaanga-nọng pabẹ kafha akhema; bẹ abhakhi nnam arọbh okhuri da bẹ an-ade p'ekhibhi. Kaam ttara bọng dọk kímbe, kw'oyongi bi, bọng akhibhi ọttọhk kpenamkpen f'owobh k'ottem kwabọng f'ọbaan k'ekhibhi. ");
INSERT INTO mfo_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","“Kọ rọhng atza aben anọng p'Israẹl bi, ‘‘Ophyini bọng akhaambi ayin Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng k'itzitzikha. Mẹ wọ, bọng do nttem sabọng ewobha. Kkeri Ọvaar Ibinọkpaabyi obeni bi, bọng akk'ekpo pya bọng abaan bi, akhibhi atzọkha. Mẹ wọ osi, bọng attattaanga-nọng pabọng kafha akhema, kw'oyongi bi, bọng akhibhi ekpo mbyuma k'ottem kwabọng. ");
INSERT INTO mfo_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","“ ‘Ewu ehobh k'ekpebha, bọng be ka mfonamma-ka mfonamma. Efonamma kpenamkpen ch'Ọvaar Ibinọkpaabyi otzek, éyin ebe ka nnọmma-ka nnọmma; ẹnọmma kpenamkpen ch'Ọvaar Ibinọkpaabyi otzek, éyin ebe k'ẹhọhmmọr-k'ẹhọhmmọr; ẹhọhmmọr kpenamkpen ch'Ọvaar Ibinọkpaabyi otzek, éyin ebe k'ojinọng-k'ojinọng. ");
INSERT INTO mfo_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","Ọnọng kpenamkpen nwa kwa bẹ ọbọhk ttara ekpo py'ẹbaan k'ekhibhi, bẹ akhaambi akwọm-ẹ k'ekpon ttara ọttọhk kpenamkpen f'ode fe. Ọnọng nwuma ọkk'ọsana kw'Ọvaar Ibinọkpaabyi ọtzama, obiro osi ọgbarsa-dik k'ebhonmọr ch'Israẹl!’ ” ");
INSERT INTO mfo_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Mada ewu ehobh k'ekpekpebha, Joshua oyeri anọng p'Israẹl ka mfonamma-ka mfonamma bẹ ayin ka, otzekha efonamma cha Juda. ");
INSERT INTO mfo_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Mando kwa nnọmma sa Juda nyini k'iyaan, otzekha ẹnọmma cha Zera. On-oben ẹnọmma cha Zera eyin ka nhọhmmọr-ka nhọhmmor, yina on-otzek ẹhọhmmọr cha Zimri. ");
INSERT INTO mfo_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Mando kwa Joshua oyeri ẹhọhmmọr cha Zimri k'ajinọng-k'ajinọng, yina on-otzek ẹhọhmmọr ch'Akan kw'ode nnwa kwa Karmi, kw'ode nnwa kwa Zimri, kw'ode nnwa kwa Zera, kw'ofon k'efonamma cha Juda. ");
INSERT INTO mfo_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Mẹ wọ ofon, Joshua oben Akan bi, “Nnwa kwaam, kọ anang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'Israẹl abarada ọmaana ikpokpobha. Kọ gbaak-m odik kw'akk'asa; kaam odik kàdubha.” ");
INSERT INTO mfo_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Mẹ wọ ofon, Akan obhina bi, “Kwẹ ode odik-ọkka e! Kaam nkk'ẹkhọhngkwuri nsa nnang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'Israẹl. Ma wọ ode odik kwa nkk'nsa: ");
INSERT INTO mfo_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Mada nnẹ ọgbọm f'ọnọhma-baba jibhada kw'ofon Babilọn, ọmaana ashẹkẹl arọbh jobh pa silva, ọmaana gol kw'ẹdọhbh ch'epyiri ashẹkẹl arọbh afa obhiri jobh, nnọri pyẹ oror kẹ wọ osi ndọkha pyẹ. Kaam ndumi irerek ndọkha pyẹ ndubha k'ọhọhm kwaam ẹtzaanga, ndọkha silva nhok k'irekhirek.” ");
INSERT INTO mfo_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Mẹ wọ ofon, Joshua ọtzọhm akkaabh-nkkaabha, p'afon atza adim k'ọhọhm kwa Akan, bẹ atza are ekpo mbyuma py'odubh k'ọhọhm kwẹ, ọtzọkha silva ohok k'irekhirek. ");
INSERT INTO mfo_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Bẹ atzọkha ekpo mbya k'ọhọhm, atzima achena Joshua ọmaana anọng p'Israẹl biphyir. Bẹ atzọkha ekpo mbya aji m'itzitzikha s'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Mando kwa Joshua ọmaana anọng p'Israẹl biphyir, atzọk Akan kw'ode nnwa kwa Zera, ọmaana silva, ọmaana ọnọhma-baba, ọmaana gol, ọmaana va pẹ p'ijinọng ttara p'ipanọng, ọmaana abhaam pẹ, ọmaana nnyanyaang, ọmaana arukhimaan, ọmaana ọhọhm kwẹ ttara ọttọhk kpenamkpen f'ọkhaam, atzima achina k'Ittolim s'Akor. ");
INSERT INTO mfo_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Mẹ wọ osi, Joshua ọbọbh bi, “Ode yan kw'akhe man ka dama-dama o? Ọvaar Ibinọkpaabyi ọ́khọ-ọ ka dama-dama, mayina.” Mando kw'anọng p'Israẹl biphyir atzọbhi kẹ, ọmaana va pẹ atza. Mada bẹ akk'bẹ biphyir atza atzọbha, bẹ atzọkha bẹ akwọmi k'ekpon. ");
INSERT INTO mfo_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Bẹ atzọkha ọtza-khung atzer m'ibe nnuma s'Akan oyim. Ọtza-khung nwa otzim owobh kẹ maa, apyiri k'ewu cha mayina. Mando kw'Ọvaar Ibinọkpaabyi ọkpa nnam ọbọra idọdọkhi sẹ. Mẹ wọ ofon, ttẹwọr mẹ, ibe nnuma ikpena Ittolim s'Akor. ");
INSERT INTO mfo_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Iwa Ọvaar Ibinọkpaabyi oben Joshua bi, “Tte ojora oning-ọ osi; tte ẹfa ening-ọ ẹha. Tzima arim-egbong biphyir abina avura atza arima odedenmon kw'Ayi abẹ. Kkeri kaam nkk'ọvaarnọng kw'Ayi, ọmaana anọng pẹ, ọmaana odedenmon kwẹ, ttara ẹkhọma chẹ ndọkha ngọ-ọ ka mbọhk. ");
INSERT INTO mfo_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Kọ akhaambi ási ọbhon kw'Ayi ọmaana ọvaarnọng kwẹ, odem kw'iwa asi obhon kwa Jeriko ọmaana ọvaarnọng kwẹ. Bọng áchi ọgbọm f'ekpo, bọng ábira átzọkha etzirakpo akhaama. Bọng áchubha ka mpa-nnam s'odedenmon atzik.” ");
INSERT INTO mfo_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","Mando kwa Joshua ọmaana arim-egbong biphyir afon atza arima Ayi abẹ. Wa otzekha arim-egbong pẹ akkakka p'apyiri nnọhna arọbh attaan obhiri chi, ọtzọhm bẹ k'erungi ");
INSERT INTO mfo_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","ttara ẹtzọhngdọra bi: “Bọng dọkha ogbe ayonga itzọhng e. Bọng akhaambi achubha ka mpa-nnam s'odeenmon atzik. Bọng k'ibe s'ibhiri eden kàtza o. Bọng biphyir bọng for sabọng kàraama. ");
INSERT INTO mfo_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Kaam ọmaana anọng biphyir p'awobh ttar-m, móchina ororo ọnwa k'odedenmon nwa. Mada ajinọng mba ayin k'iyaan bi, akwu arima man abẹ, mach'iwa bẹ achi eden asi, maman ọ́rọbh-ọrọbh oji bẹ. ");
INSERT INTO mfo_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","Bẹ akhubh man maa, more bi mokk'bẹ ọbọhra bẹ abina aji odedenmon, da bẹ aben bi, ‘Bẹ atzima arọbhi man ọrọbh, mach'iwa bẹ achi eden arọbh man e.’ Mada mọrọbh oji bẹ, ");
INSERT INTO mfo_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","bọng abina kẹ da bọng achubha atzik, atza achi odedenmon nwa. Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọttẹ-ẹ ọbọhk otte ọnang bọng. ");
INSERT INTO mfo_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Idikha bọng akk'odedenmon nwa acha, bọng gẹ-ẹ ekpon. Bọng si atzor k'odem kw'Ọvaar Ibinọkpaabyi okk'bọng ọgbaakha. Bọng nne kwẹ bi, kaam nkk'bọng ẹfa nnanga.” ");
INSERT INTO mfo_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Mẹ wọ ofon, Joshua ọtzọhm bẹ afona. Wa bẹ afona atza achubha k'ibe s'iwobh k'ottem kwa Bẹtẹl ọmaana Ayi, k'okhubha kw'ewuchen em-edimi k'Ayi. Yina, wa Joshua oyima ọmaana anọng mba m'erungiwu nduma. ");
INSERT INTO mfo_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","K'ekpekpebha ch'ewu ehobh mẹ, Joshua otzobha arim-egbong pẹ, kẹ ọmaana adedennọng p'Israẹl arenga anọng mba k'itzitzikha, atzima bẹ afona achina k'Ayi. ");
INSERT INTO mfo_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Mando kw'arim-egbong mba biphyir p'awobh ttar-ẹ atzọn-ẹ abẹ avura k'odedenmon nwa, atza abe k'itzitzikha s'obhon. Be attima ibhingabe k'ebir-ebira kw'Ayi, bẹ akhe ittolim k'ottem kwa bẹ ọmaana odedenmon ");
INSERT INTO mfo_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","Ode ch'iwa Joshua okk'ajinọng nnọhna jobh obhiri mfa obhiri arọbh jobh, ọtzọkha ohok bẹ ochubha k'ottem kwa Bẹtẹl ọmaana Ayi maa, apyiri k'okhubha kw'ewuchen em-edimi k'odedenmon. ");
INSERT INTO mfo_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Mando kw'arim-egbong mba atzọk ewobha k'obe fabẹ. Ayok p'awobh k'ibhingabe awobha k'ebir-ebira kw'odedenmon, ayok p'achubbh-ochubha awobha k'okhubha kw'ewuchen em-edimi k'odedenmon. M'erungiwu nduma, Joshua ofona ọhakha k'ittolim. ");
INSERT INTO mfo_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Mada ọvaarnọng kw'Ayi ore odik nwa, kẹ ọmaana ajinọng p'odedenmon biphyir adukha ayin k'iyaan k'ekpekpebha, atza arima anọng p'Israẹl abẹ k'ibe rani s'irọni Araba. Yina, wa kẹ korong bi, anọng akk'achubha ka mpa-nnnam s'odedenmon atzikh-ẹ. ");
INSERT INTO mfo_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","Wa Joshua ọmaana anọng p'Israẹl biphyir atte for sabẹ ọbọhk bi, ayok akhubh bẹ akpa nnam, bẹ arọbh achina k'okhubha kw'ibe s'anọng an-arukhi. ");
INSERT INTO mfo_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","Wa bẹ abeni ajinọng p'Ayi biphyir bi, bẹ akhubh bẹ. Bẹ akhubh Joshua k'ibe s'ibhir-obhir maa, bẹ arọbh aji odedenmon. ");
INSERT INTO mfo_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","Wa ojinọng manda wani kw'orikhi k'Ayi obiro ode Bẹtẹl kode, kw'oni anọng p'Israẹl okhubhi. Wa anọng mba atte odedenmon eje, bẹ akhubh anọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Ọvaar Ibinọkpaabyi oben Joshua bi, “Nemi ọkhọhn nwuma kw'owobh-ọ m'ọbọhk atzena k'okhubha kw'Ayi, kkeri kọ wọ kwa kaam ńtte odedenmon nwa ọbọhk nnang e.” Mando kwa Joshua onemi ọkhọhn kwẹ otzena ka Ayi. ");
INSERT INTO mfo_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Otzena ọkhọhn nwa bi kpaar, ajinọng mba p'ira achubh-ochubha abina m'ẹbhar-k'ẹbhar k'obe f'ira bẹ achubh, arọbh akwu. Bẹ adim k'odedenmon, abọkh-ẹ abira akhẹ-ẹ ekpon m'ẹbhar-k'ẹbhar. ");
INSERT INTO mfo_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","Mada ajinọng p'Ayi abhakhi nnam akkeri, bẹ an-are irorong k'iwokhi s'im-iyin k'odedenmon. Yina, bẹ ọphaangi manda wani kwa bẹ areng arọbh kare; wa anọng p'Israẹl pa bẹ akk'akhubha achina k'okhubha kw'ibe s'anọng an-arukhi, an-abhakhi akhubh anọng mba. ");
INSERT INTO mfo_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","Mada Joshua ọmaana anọng p'Israẹl biphyir are bi, ajinọng mba p'ira achubh-ochubha akk'odedenmon abọkha, bẹ abira are irorong s'im-iyin k'odedenmon, bẹ abhakhi arima ajinọng p'Ayi abẹ. ");
INSERT INTO mfo_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Ajinọng mba p'ira achubh-ochubha abira ayin k'odedenmon akhubh bẹ maa, bẹ an-akhe bẹ k'ottem, da anọng p'Israẹl awobh bẹ k'itzitzikha ọmaana ka nnam. Mando kw'anọng p'Israẹl afhu bẹ maa, bẹ ọnọng manda wani karikhi kw'orukhi akpen, ọnọng kw'obiro ọrọbh ọnaanga kode. ");
INSERT INTO mfo_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","Yina, wa bẹ atzima ọvaarnọng kw'Ayi ekhekhebhi achena Joshua. ");
INSERT INTO mfo_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","K'ogbe kw'anọng p'Israẹl akk'ajinọng p'Ayi afha okpo k'iwoni, ọmaana k'ibe s'anọng an-arukhi, kẹ da ira bẹ akk'bẹ akhubha. K'ogbe kwa bẹ akk'ọkkangkkaang atzima afhu ọnọng kpenamkpen, anọng p'Israẹl biphyir akpa nnam k'Ayi, atza afhu anọng p'awobh kẹ. ");
INSERT INTO mfo_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","Anọng p'Ayi biphyir p'iwa ape m'ewu nduma, ajinọng ọmaana panọng ade: nnọhna ẹrọbh obhiri jobh. ");
INSERT INTO mfo_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","Da iwa Joshua oni ọbọhk kw'otzim ọkhọhn ọtzọri maa, odimi anọng p'arukhi k'Ayi emeni biphyir. ");
INSERT INTO mfo_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Yina, anọng p'Israẹl atzọkha etzirakpo py'anọng mba akhaama, bẹ abira achi ọgbọm k'odedenmon nwa atzima afona, atzor k'odem kw'Ọvaar Ibinọkpaabyi okk'Joshua ọtzọhna. ");
INSERT INTO mfo_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Mando kwa Joshua okhe obhon kwa Ayi ekpon, ọsẹ-ẹ on-ode ahọhm-gbigbini maa, apyiri mayina. ");
INSERT INTO mfo_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","Ọtzọkha ọvaarnọng kwa Ayi ọgbana edik k'echi, ọtte ọbọhk mẹ maa, opyiri k'ẹchọhkha. Ma nchọhkha-bọhk, Joshua ọnang anọng mba ẹfa bi, bẹ ahanga obukhi kwẹ k'echi atza abhari k'ẹbaakhamma ch'odedenmon. Bẹ atzọkha ọtza-khung abubhẹ-ẹ, kw'otzima owobh kẹ maa, apyiri mayina. ");
INSERT INTO mfo_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","Iwa Joshua osi ijafọhnibe k'egbegbeho ch'Ebal ọnang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'Israẹl, ");
INSERT INTO mfo_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","macha Mosẹs kw'ode ọtzọhmnọng kw'Ọvaar Ibinọkpaabyi, ọkk'anọng p'Israẹl ọtzọhna. Osi ijafọhnibe nna otzor macha bẹ akkẹri ka Nnwẹr kw'Aphaangi pa Mosẹs. Wa bẹ atzim atza pa bẹ an-ọphaphaakhi-aphaakhi atzima asi ijafọhnibe nna, bẹ ọtzọhmttọhk f'okkonga kabira atzima asi sẹ. M'ijafọhnibẹ nna rọ s'iwa bẹ asi nnanga nkwọhmisẹ, ọmaana nnanga s'odidiri anang Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","M'itzitzikha s'anọng p'Israẹl, Joshua ọtzọkha aphaangi pa Mosẹs ọkk'ọkkẹra, ọkkẹr k'atza mba. ");
INSERT INTO mfo_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","Wa anọng p'Israẹl biphyir, ọmaana adedennọng pabẹ, ọmaana akhaan-nọng ttara asi-aponga abe k'odimbọhk ttara kw'abọhk kw'Ẹkkọhbhi ch'Echekhi ch'Ọvaar Ibinọkpaabyi, am-akkeri afọhnẹja itzitzikha, p'iwa ade ẹnọmma cha Lẹvi p'atzini ẹkkọhbhi nda. Iwa akhekhennọng p'arukhi ọmaana ammaana awobh mẹ. Ibhaakha rani s'anọng abe akkeri itzitzikha k'egbegbeho cha Gerizim. Ibhaakha nnonggo ibe ikkeri itzitzikha k'egbegbho ch'Ebal, mach'iwa Mosẹs kw'ode ọtzọhmnọng kw'Ọvaar Ibinọkpaabyi ọkk'ọgbaakha, k'ogbe kw'iwa ọnangi ndọhna s'otzim odo anọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","Ayongi mẹ, wa Joshua oyeri atzim p'aphaangi biphyir ọnang bẹ, aphaangi p'ẹdaa ọmaana ẹmma ọnanang, atzor k'odem kwa bẹ akkẹri ka Nnwẹr kw'Aphaangi. ");
INSERT INTO mfo_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","Atzim manda bani kade p'iwa Mosẹs ọkk'ọkkẹra, pa Joshua on-oyeri ọnang ebhonmor ch'Israẹl biphyir, attar panọng ọmaana va ttara akhekhennọng p'iwa arukhi k'ottem kwabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","K'ogbe kw'avaar biphyir p'okhubha kw'ewuchen em-edimi ka Jọrdan k'okhubha kwa mgbegbeho sa ngori-ogori, ọmaana k'okhubha kwa mgbegbeho sa ndẹri-ọtzẹri, akwu attara k'okhubha kwa mgbegbeho s'Ọraanga kw'ideden kwa Mẹditeraniya maa, apyiri k'ebira-ebira kwa Lẹbanọn, abhaang odik kwa ngema s'anọng p'Israẹl, (avaarnọng pa Het, ọmaana p'Amọr, ọmaana pa Kenaan, ọmaana pa Periz, ọmaana pa Hiv ttara pa Jẹbus), ");
INSERT INTO mfo_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","bẹ akwu abhuna achibhi pabẹ bi, bẹ arima Joshua ọmaana anọng p'Israẹl abẹ. ");
INSERT INTO mfo_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Yina, k'ogbe kw'anọng pa Gibeọn abhaang odik kwa Joshua, ọkk'anọng pa Jeriko ọmaana p'Ayi ọsa, ");
INSERT INTO mfo_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","bẹ an-akhera bi, bẹ asi ibhora: Bẹ arenga k'ẹkhaan cha nnyanyaang sa ndọhk mkpa sa nkk'ndama ọmaana mkpa sa nden-kpa sa nkk'ndama mbiri njaakhi, bẹ abira araakha. ");
INSERT INTO mfo_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","Wa anọng mba akhe ekpo pya mmo py'ekk'ekhibhi, bẹ araakha. Bẹ abira ọfhọra ọbara f'ọkk'ọtzama. Brẹd kwabẹ biphyir kw'ọchattọhk ogwu bi haakhada obiro ọgaangi bi kpọkhọdọ. ");
INSERT INTO mfo_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","Bẹ afona atza akhebha Joshua, ọmaana anọng p'Israẹl k'ibhingabe sa bẹ awobh ka Gilgal, aben bẹ bi, “Mokk'ofona k'ẹkhọma ch'ebhir-eden okwu; bọng si echekhi ttara man.” ");
INSERT INTO mfo_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","Iwa anọng p'Israẹl aben anọng pa Hiv bi, “Osi man bi, bọng arukhi abaanga man o. Ka yan kwa maman on-osi echekhi ttara bọng o?” ");
INSERT INTO mfo_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","Bẹ aben Joshua bi, “Maman ode atzọhmnọng pabọng.” Mẹ wọ ofon, Joshua ọbọbh bi, “Bọng ade bọng anọng? Bọng afon maan?” ");
INSERT INTO mfo_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","Bẹ abhina bi, “Atzọhmnọng pọ afon k'obhon kw'obhiri eden akwu ma, okhuri che-barada ch'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwọ. Maman okk'idik s'osi ọbhaanga: idik nnuma biphyir s'osi m'akhọra Ijip, ");
INSERT INTO mfo_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","ọmaana idik biphyir s'osi ọnang avaar afa p'adabhi anọng p'Amọr k'okhubha kw'ewuchen em-eyin kw'okhubha kwa Jọrdan p'ade; ọvaar Sihọn kwa Heshbọn, ọmaana ọvaar Og kwa Bashan kw'ọdabhi Ashtarọt. ");
INSERT INTO mfo_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","Kẹ wọ osi, adedennọng paman, ọmaana anọng biphyir p'arukhi k'ẹkhọma chaman, aben man bi, “Bọng dima ọchattọhk k'ornga kw'abọng; bọng nọhng atza akhebha bẹ, aben bẹ bi, “Maman ode atzọhnọng pabọng; Bọng si echekhi ttara man.” ’ ");
INSERT INTO mfo_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","Wa brẹd nwa kwaman ọpọhkh-ọpọhkha k'ewu ch'iwa mobin orenga okwu ma. Yina, kkeri odem kw'ọkk'ọgwa ka bi hakhada, obiro ọgaangi bi kpọkhọdọ. ");
INSERT INTO mfo_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","Wa ndenkpa nna sa mokhe ekpo nde mmasẹ. Yina, bọng kkeri odem kwa sẹ nkk'njaakhi ka. Ọbara faman ọmaana ekpo pya mmo pyaman ebire ẹtzam, okhuri odenmir kw'orenga nwa.” ");
INSERT INTO mfo_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","Mando kw'anọng p'Israẹl atzọk ọchattọhk f'anọng mba, bẹ Ọvaar Ibinọkpaabyi kadọhni. ");
INSERT INTO mfo_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","Mẹ wọ ofon, Joshua osi echekhi ch'ẹmẹm ttara bẹ, ch'ette anọng mba ọbọhk aruk ttara anọng p'Israẹl. Mando kw'adedennọng p'Israẹl atzọk ọnwọhngi akhera echekhi nda. ");
INSERT INTO mfo_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","Mada iwu ittaan ikk'ikwọbha s'anọng p'Israẹl asi echekhi nda ttara anọng pa Gibeọn, anọng p'Israẹl an-abhaanga bi, anọng mba ade ayokhibaanga, p'arukhi abaanga bẹ. ");
INSERT INTO mfo_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Mẹ wọ ofon, anọng p'Israẹl abina orenga, k'ewu ch'ettong iwu ittaan, bẹ apyiri k'idedenmon sabẹ s'ide: Gibeọn, ọmaana Kephira, ọmaana Berot ttara Kiriyat-Jearim. ");
INSERT INTO mfo_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","Yina, wa anọng p'Israẹl anọng mba abẹ karim, okhuri da iwa adedennọng p'Israẹl akk'echekhi asa ttara anọng mba, abira anwọhngi ka che ch'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'Israẹl. Wa ebhonmọr ch'Israẹl biphyir ẹnwọhni odik nwa, ẹttaanga ẹnang adedennọng pabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","Mẹ wọ ofon, adedennọng p'Israẹl biphyir aben bi, “Maman okk'bẹ echekhi chaman ọnanga ka che ch'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'Israẹl. Mẹ wọ osi, man bẹ ọbọhk kọttọhmi. ");
INSERT INTO mfo_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Ma wọ ode odik kwa mósi bẹ: Mótte bẹ ọbọhk bẹ aruk, ifha opohnga-pyibha oningi kwaman ode bi, mọvọhkhi echekhi ch'iwa mọkk'ọnwọhngi ọtzọkha ttara bẹ. ");
INSERT INTO mfo_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","Bẹ achina ororo aben bi, “Tte bẹ aruk ttara man. Yina, tte bẹ ade anọng p'am-akpaara nchi, ọmaana p'am-akhaabha asi anang ebhonmọr chaman makhọra.” Mando kw'anọng mba akher bi ahok echekhi nda ch'adedennọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","Mẹ wọ, Joshua oyeri anọng pa Gibeọn otzobha, ọbọbh bi, “Okhuri yan kwa bọng abọhr man aben bi, ‘Morukhi k'odenmir,’ k'ogbe kwa bọng arukhi abaanga man ma o? ");
INSERT INTO mfo_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","Mẹ wọ ofon, bẹ anang bọng ẹmma ch'ẹ́raakhi bọng: Bọbọng k'ọtzọhm f'echi-kpaara ọmaana ẹsi-khaabha kánaanga, k'ọhọhm kw'Ibinọkpaabyi kwaam.” ");
INSERT INTO mfo_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Mando kw'anọng mba abhin Joshua bi, “Wa bẹ akk'ẹjaakhi nda asa anang maman atzọhmnọng pọ, eden ch'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwọ, ọkk'ọtzọhmnọng kwẹ Mosẹs ọgbaakha bi, ọnang bọng irerek nna biphyir, obira odimi ọnọng kpenamkpen kw'orukhi mẹ, k'itzitzikha sabọng. Kẹ wọ osi akpen paman asi man nkwo okhuri kọ, kwẹ gwọ obiro osi, mosi odik nwa. ");
INSERT INTO mfo_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Maman on-owobh ka mbọhk sabọng. Bọng si man k'odem kpenamkpen kw'ọpaani bọng, ojibh-ojibh o obiro ode bi, opyibh-opyibh o.” ");
INSERT INTO mfo_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Mando kwa Joshua ọkkaan anọng mba ka mbọhk s'anọng p'Israẹl, anọng p'Israẹl bẹ anọng mba kafhu. ");
INSERT INTO mfo_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","M'ewu nduma, Joshua on-osi anọng pa Gibeọn ade akpaar-nchi ọmaana akhaabh-asi k'ebhonmọr ch'Israẹl, ọmaana k'ijafọhnibe s'Ọvaar Ibinọkpaabyi, k'ibe s'Ọvaar Ibinọkpaabyi ótzekha. Mando kw'anọng mba an-ade maa, apyiri k'ewu cha mayina. ");
INSERT INTO mfo_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Iwa Adoni-Zedek kw'ode ọvaarnọng kwa Jẹrusalẹm ọbhaang bi, Joshua okk'obhon kw'Ayi ọbọkha obiro odim-ẹ biphyir-phyir. Wa obiro ọbhaanga odem kwa Joshua osi obhon kw'Ayi ọmaana ọvaarnọng kwẹ, mach'iwa ọkk'Jeriko ọsa ọmaana ọvaarnọng kwẹ, ọmaana eden ch'anọng pa Gibeọn akk'echikhi ch'ẹmẹm asa ttara anọng p'Israẹl maa, bẹ an-aruk k'ottem kw'anọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Ojora osi kẹ ọmaana anọng pẹ, okhuri bi, wa Gibeọn ode odedenmon kw'ọbari odik, obiro ode mach'ivaar-bhon. Wa obhon nwa ọbari ọtzam ọyọhnga Ayi, ajinọng pẹ biphyir abira ade arim-egbong akkakka. ");
INSERT INTO mfo_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Mẹ wọ ofon, Adoni-Zedek kw'ode ọvaarnọng kwa Jẹrusalẹm ọtza oben Hoham, kw'ode ọvaarnọng kwa Hẹbrọn, ọmaana Piram kw'ode ọvaarnọng kwa Jarmut, ọmaana Japhia kw'ode ọvaarnọng kwa Lakish, ttara Debir kw'ode ọvaarnọng kw'Eglon bi, ");
INSERT INTO mfo_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“Bọng kwu tzor-m, mọtza orima obhon kwa Gibeọn abẹ, okhuri bi, bẹ akk'afona atza asi ẹmẹm ttara Joshua, ọmaana anọng p'Israẹl.” ");
INSERT INTO mfo_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Mando kw'avaarnọng mba azen p'anọng p'Amọr p'ade: avaar pa Jẹrusalẹm, ọmaana pa Hẹbrọn, ọmaana pa Jarmut, ọmaana pa Lakish ttara p'Eglon abhuna ẹfa. Bẹ afona ttara arim-egbong pabẹ biphyir, avura atza arima obhon kwa Gibeọn abẹ. ");
INSERT INTO mfo_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Mando kw'anọng pa Gibeọn atzọhmi ẹkkaabha achena Joshua k'ibhingabe ka Gilgal, aben bi: “Atzọhmnọng pọ ọbọhk kàtte. Kwu ẹbhar-ẹbhar akwu akkaana man! Kọ kkaana man okhuri bi, avaar p'anọng p'Amọr biphyir k'okhubhba kwa mgbegbeho akk'mfa abhuna akwu arima man abẹ.” ");
INSERT INTO mfo_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Mando kwa Joshua obin ka Gilgal ttara arim-egbong pẹ biphyir, okwu ọttara k'arim-egbong pẹ akkakka. ");
INSERT INTO mfo_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Ọvaar Ibinọkpaabyi oben Joshua bi, “Ojora oning-ọ osi okhuri anọng mba; kaam nkk'bẹ ndọkha ngọ-ọ ka mbọhk. Ọnọng manda wani kw'ọfha ọbọ-ọ mbọhk-rima kóde.” ");
INSERT INTO mfo_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Mada bẹ abin ka Gilgal, Joshua ọmaana arim-egbong pẹ, arenga m'erungi nduma biphyir, atza aju anọng pa Gibeọn ẹfha. ");
INSERT INTO mfo_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Ọvaar Ibinọkpaabyi okhe bẹ ka dama-dama m'itzitzikha s'anọng p'Israẹl. Wa anọng p'Israẹl akhubh bẹ k'ọkkadeden kw'ochina ka Bet-Horon, anọng p'Israẹl attẹwọr mẹ afhu bẹ maa, apyiri k'Azeka ọmaana Makeda. Mẹ wọ ofon, Joshua ọmaana anọng p'Israẹl akhema anọng pa Gibeọn biphyir-phyir. ");
INSERT INTO mfo_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Mada bẹ arọbhi m'itzitzikha s'anọng p'Israẹl k'ọkkadeden, da afon ka Bet-Horon achina k'Azeka. Ọvaar Ibinọkpaabyi otzebh bẹ arọngda p'ideden, haabhada ape m'arọngda mba p'atzebhi bẹ, ayọhnga anọng p'anọng p'Israẹl atzim akkangkkaang afhu. ");
INSERT INTO mfo_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","M'ewu nduma, Ọvaar Ibinọkpaabyi otte anọng p'Amọr ọbọhk ọnang anọng p'Israẹl bẹ akhema, Joshua oben Ọvaar Ibinọkpaabyi m'itzitzikha s'anọng p'Israẹl bi: “Ekpekhira, be bi sẹẹbh ka Gibeọn, kọ ophe, be ibe rani k'ittolim s'Aijalọn.” ");
INSERT INTO mfo_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Wa ekpekhira ebe bi sẹẹbh, ophe obiro obe k'ibe rani maa, anọng p'Israẹl akhema attattaanga-nọng pabẹ, macha bẹ akkẹri ka Nnwẹr kwa Jashar. Ekpekhira ebe k'ibe rani k'ottem kw'ọrọngkpakpa, ebire ekpen ọhahakha ọttọhk k'ewu obungichẹ. ");
INSERT INTO mfo_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Ewu etzim ẹm-ẹda ch'ede mach'ewu nda, ch'ede ewu ch'Ọvaar Ibinọkpaabyi oyong itzọhng ọnang ọnọngẹya. K'odik-ọkka wa Ọvaar Ibinọkpaabyi wọ om-orima erima ọnang anọng p'Israẹl! ");
INSERT INTO mfo_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Iwa Joshua otzima anọng p'Israẹl biphyir ọkpa nnam ọbhana k'ibhingabe ka Gilgal. ");
INSERT INTO mfo_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","Iwa avaar mba azen p'Amọr akk'arọbha atza achubha k'ọmma kw'itzakpa kw'owobh ka Makeda. ");
INSERT INTO mfo_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","K'ogbe kwa bẹ agbaakhi Joshua bi, bẹ akk'avaar mba azen ara p'achubh k'ọmma kw'itzakpa kw'owobh ka Makeda, ");
INSERT INTO mfo_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","oben bi, “Bọng bingi atzakpa p'ideden abubha m'ọmma kw'itzakpa, bọng ahok ajinọng bani mẹ p'abaabh-ẹ. ");
INSERT INTO mfo_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","Yina, bọng attattaanga-nọng pabọng kàkwọhbha okhukhubh! Bọng nima bẹ abẹ ka nnam-annam, bọng bẹ ọbọhk kàtte bẹ apyiri k'idedenmon sabẹ, kkeri Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, okk'bẹ ọbọhk ọtta ọnang bọng.” ");
INSERT INTO mfo_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","Mando kwa Joshua, ọmaana anọng p'Israẹl akhem bẹ bipyir-phyir, yina, wa anọnọnga p'arikhi akk'akhonga apyiri k'idedenmon sabẹ, sa bẹ atzim abaakha asi. ");
INSERT INTO mfo_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","Wa arim-egbong biphyir abhana k'odidiri akhebha Joshua k'ibhingabe ka Makeda. Wa ọnọng manda wani kw'obiro ọgbaak atzim-dama ọnang anọng p'Israẹl kode. ");
INSERT INTO mfo_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","Mẹ wọ ofon, Joshua oben bi, “Bọng bingi itzakpa s'ibubh ọmma kw'itzakpa, atzima avaar mba azen ayin ka achen-m.” ");
INSERT INTO mfo_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","Mando kwa bẹ atzima avaar mba azen p'ade avaar pa Jẹrusalẹm, ọmaana Hẹbrọn, ọmaana Jarmut, ọmaana Lakish ttara Eglọn ayin k'ọmma kw'itzakpa. ");
INSERT INTO mfo_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","Mada bẹ akk'avaar mba atzima achena Joshua, oyeri ajinọng p'Israẹl biphyir otzobha, oben adeho p'arim-egbong p'akk'bẹ atzọna akwu bi, “Bọng bari avaar mba mmo k'ẹdọhngi.” Mando kwa bẹ afon akwu abari bẹ mmo ka ndọhngi. ");
INSERT INTO mfo_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","Iwa Joshua oben bẹ bi, “Ojora oningi bọng osi; ẹfa eningi bọng ẹha; bọng be bi pyiir, bọng abira abar ettem. Ma wọ ode odik kw'Ọvaar Ibinọkpaabyi ósi ọnang attattaanga-nọng pabọng biphyir pa bọng árima abẹ.” ");
INSERT INTO mfo_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","Mando kwa Joshua ofhu avaar mba ọtzọkha abukhi pabẹ ọgbana ka mkpọmmachi nzen, bẹ agbana ka mkpọmmachi nna maa, opyiri k'ẹchọhkha. ");
INSERT INTO mfo_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","Okwu opyirir ma nchọhkha-bọhk, Joshua ọnang ẹfa bi, bẹ ahakha avaar mba ka mkpọmmachi sa be agban bẹ, atzini bẹ abhari k'ọmma kw'itzakpa nwa kw'ira bẹ achubh. K'ẹmma ch'ọmma kw'itzakpa nwa, bẹ atzọkha atzakpa p'abari ẹkpa abubha, p'atzim awobh kẹ maa, apyiri ma. ");
INSERT INTO mfo_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","Iwa m'ewu nduma, Joshua ọbọkha obhon kwa Makeda. Otzima ọkkangkkaang ofhu anọng p'obhon nwa ttara ọvaarnọng kwabẹ, obiro odimi ọnọng kpenamkpen kw'owobh m'obhon nwa emeni. Wa ọnọng manda wani ọbọhk kotte oruk akpen. Osi ọvaarnọng kwa Makeda mach'iwa osi ọvaarnọng kwa Jeriko. ");
INSERT INTO mfo_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","Mando kwa Joshua obin ka Makeda ttara anọng biphyir, ọtza orima obhon kwa Libna abẹ. ");
INSERT INTO mfo_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","Ọvaar Ibinọkpaabyi obiro ọtzọkha odedenmon nwa, ọmaana ọvaarnọng kwẹ okhe anọng p'Israẹl ka mbọhk. Joshua odimi ọttọhk kpenamkpen f'owobh m'odedenmon nwa, obiro otzima ọkkangkkaang ofhu ọnọng kpenamkpen kw'owobh m'obhon nwa. Ọnọng manda wani kw'iwa otte ọbọhk oruk akpen kode. Obiro osi ọvaarnọng kw'obhon nwa mach'iwa ọkk'ọvaarnọng kwa Jeriko ọsa. ");
INSERT INTO mfo_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","Mẹ wọ ofon, Joshua otzima anọng p'Israẹl biphyir p'atzọn-ẹ abẹ, obina ka Libna ochina ka Lakish; bẹ ayima k'obe-k'obe atzik obhon nwa, arim-ẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","Ọvaar Ibinọkpaabyi otte obhon kwa Lakish ọbọhk ọnang anọng p'Israẹl, Joshua orima obhon nwa abẹ k'iwu ifa. Odimi obhon nwa, obiro otzima ọkkangkkaang ofhu ọnọng kpenamkpen kw'owobh m'obhon nwa, mach'iwa ọkk'Libna ọsa. ");
INSERT INTO mfo_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","Ayongi mẹ, Horam kw'ode ọvaarnọng kwa Gẹzẹr okk'ofona bi, ọtza ọkkaana Lakish. Yina, wa Joshua okhem-ẹ ttara arim-egbong pẹ maa, ọnọng manda wani kw'ọnaang kode. ");
INSERT INTO mfo_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","Mẹ wọ ofon, Joshua ọmaana anọng p'Israẹl biphyir p'atzọn-ẹ abẹ, abina ka Lakish achina k'obhon kw'Eglọn; bẹ atza ayima k'obe-k'obe atzik anọng p'obhon nwa, arima bẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","Bẹ abọkha obhon nwa m'ewu nduma dani, bẹ afhu ọnọng kpenamkpen kw'obhon nwa, mach'iwa bẹ akk'asa ka Lakish. ");
INSERT INTO mfo_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","Mẹ wọ ofon, Joshua ọmaana anọng p'Israẹl biphyir p'atzọn-ẹ abẹ, abina k'obhon kw'Eglọn achina k'obhon kwa Hẹbrọn, atza arim-ẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","Bẹ abọkha odedenmon nwa, atzima ọkkangkkaang afhu ọvaarnọng ttara anọng p'obhon nwa biphyir, bẹ abira afhu anọng p'arukhi k'abhobhona biphyir. Wa bẹ ọnọng manda wani ọbọhk katte oruk akpen, mach'iwa kwẹ ode ttara obhon kw'Eglọn. ");
INSERT INTO mfo_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","Iwa Joshua ọmaana anọng p'Israẹl biphyir p'atzọn-ẹ abẹ, abhakhi arima obhon kwa Debir abẹ. ");
INSERT INTO mfo_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","Bẹ abọkha odedenmọn nwa, ọmaana ọvaarnọng kwẹ ttara abhobhona pẹ, bẹ atzima ọkkangkkaang afhu ọnọng kpenamkpen kw'orukhi m'ibhon nna. Wa bẹ ọnọng manda wani ọbọhk katte oruk akpen. Bẹ asi Debir ọmaana ọvaarnọng kwẹ, mach'iwa bẹ akk'asa k'obhon kwa Libna, ọmaana ọvaarnọng kwẹ ttara ka Hẹbrọn. ");
INSERT INTO mfo_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","Mando kwa Joshua okhem ẹkhọma nda biphyir, attar k'ibhon s'iwobh k'okhubha kwa mgbegbeho, ọmaana Nẹgẹv, ọmaana okhubha kwa mgbegbeho sa ndẹri-ọtzẹri k'okhubha kw'ewuchen em-edimi, ọmaana ottolim fa mgbegbeho ttara avaar pabẹ biphyir. Wa ọnọng manda wani ọbọhk kotte oruk akpen, wa ofhu bẹ biphyir otzor mach'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'Israẹl ọkk'ọgbaakha. ");
INSERT INTO mfo_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","Joshua okhema bẹ ttẹwọr ka Kadẹsh-Barnea maa, apyiri Gaza ọmaana k'ẹkhọma cha Goshẹn biphyir maa, apyiri ka Gibeọn. ");
INSERT INTO mfo_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","Wa Joshua okhem avaar pa ngọma biphyir m'egbong nduma dani, obiro ọtzọkha orerek fabẹ. Wa Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'Israẹl orim egbong nda ọnang anọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","Iwa Joshua otzima anọng p'Israẹl biphyir okhuna k'ibhingabe sa Gilgal. ");
INSERT INTO mfo_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","K'ogbe kwa Jabin kw'ode ọvaarnọng kwa Hazọr obhaang odik nwa, ọtzọhm ẹkkaabha ochena Jobab, kw'ode ọvaarnọng kwa Madọn, obiro ọtzọhm ochena avaar pa Shimrọn, ọmaana p'Akshaph, ");
INSERT INTO mfo_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","ttara avaar p'adabhi idibhon s'ebir-ebira s'irukhi k'okhubha kwa mgbegbeho, ọmaana k'Araba k'ẹrakh-ẹrakha kwa Kinẹrẹt, k'okhubha kwa mgbegbeho sa ndẹri-ọtzẹri k'okhubha kw'ewuchen em-edimi, ttara ka Naphot-Dor k'okhubha kw'ewuchen em-edimi; ");
INSERT INTO mfo_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","wa obiro ọtzọhm ẹkkaabha nda ọnang anọng pa Kenaan k'okhubha kw'ewuchen em-eyin, ọmaana k'okhubha kw'ewuchen em-edimi maa, achina k'ibhon s'anọng p'Amọr, ọmaana anọng pa Het, ọmaana anọng pa Periz, ọmaana anọng pa Jẹbus k'ẹkhọma cha mgbegbeho; ttara anọng pa Hiv p'awobh k'ẹrakha-ẹrakha kwa Hermọn k'ẹkhọma cha Mizpa. ");
INSERT INTO mfo_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","Avaar mba abina ttara ngaan sabẹ, ọmaana nnyanyaang k'ọhaabh, ọmaana akpaar pa nnyanyaang mmindọr k'ọhaabh, ttara arim-egbong p'ahaabhi mach'oyeyeng kw'ọraanga ọkhaan-ọkhaan. ");
INSERT INTO mfo_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","Wa avaar mba biphyir abhuna ẹfa asi ibhingabe kẹnya okhekhaho kwa Merom, ifha bẹ arima anọng p'Israẹl abẹ. ");
INSERT INTO mfo_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","Iwa Ọvaar Ibinọkpaabyi oben Joshua bi, “Ojora oning-ọ osi okhuri anọng mba, okhuri bi, ophyini m'ogbe-dema nwa, kaam ńdọkha bẹ biphyir ńge anọng p'Israẹl ka mbọhk bẹ afhu. Bọng akhaambi arẹkhi nnyanyaang sabẹ mmo, bọng abira akwọmi akpaar pabẹ pa nnyanyaang mmindọr.” ");
INSERT INTO mfo_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","Mando kwa Joshua ọmaana arim-egbong pẹ biphyir abin atza aju anọng mba ẹfha, kẹnya okhekhaho kwa Merom, bẹ arima bẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","Ọvaar Ibinọkpaabyi otte bẹ ọbọhk ọnang anọng p'Israẹl, akhema. Anọng p'Israẹl ana bẹ ẹfa, bẹ akhubh anọng mba ttẹwọr k'ọkkadeden kw'ochin ka Sidọn kw'Ideden maa, apyiri Misrephọt-Mayim, ọmaana k'Ittolim sa Mizpa k'okhuba kw'ewuchen em-edimi. Wa ọnọng manda wani kw'ọnaang kode. ");
INSERT INTO mfo_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","Wa Joshua osi anọng mba mach'Ọvaar Ibinọkpaabyi ọtzọhn-ẹ: Orẹkhi nnyanyaang sabẹ biphyir, obiro ọkwọmi akpaar pabẹ pa nnyanyaang mmindọr. ");
INSERT INTO mfo_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","Iwa Joshua ọkpa nnam ọbọkha obhon kwa Hazọr, otzima ọkkangkkaang ofhu ọvaarnọng kwabẹ. (Wa Hazọr okk'ọfabhon kwa ngọma nna biphyir ọda.) ");
INSERT INTO mfo_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","Wa bẹ atzim ọkkangkkaang afhu ọnọng kpenamkpen kw'orukhi m'obhon nwa. Wa bẹ adimi ọnọng mba biphyir-phyir, ọnọng manda wani kwa bẹ atte ọbọhk oruk akpen kode, obiro ọkwọmi obhon kwa Hazọr ọkhaam. ");
INSERT INTO mfo_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","Joshua ọtzọkha ivaar-bhon nna biphyir ttara avaarnọng pabẹ ofhu k'ọkkangkkaang. Odimi bẹ emeni odimi biphyir-phyir, mach'iwa Mosẹs kw'ode ọtzọhmnọng kw'Ọvaar Ibinọkpaabyi ọkk'bẹ ọtzọhna. ");
INSERT INTO mfo_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","Yina, wa anọng p'Israẹl odedenmon manda wani kwa bẹ asi k'ahọhm-gbigbini kakwọmi, kw'oyongi obhon kwa Hazọr kwa Joshua ọkwọmi. ");
INSERT INTO mfo_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","Anọng p'Israẹl atzọkha ọgbọm biphyir f'abẹ achi, ọmaana etzirakpo py'idedenmon nna atzima afona. Yina, wa bẹ atzima ọkkangkkaang afhu anọng mba biphyir. Ọnọng manda wani kwa bẹ atte ọbọhk oruk akpen kode. ");
INSERT INTO mfo_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","Odem nwuma kw'iwa Ọvaar Ibinọkpaabyi ọtzọhni Mosẹs kw'ode ọtzọhmnọng kwẹ, mando kw'iwa Mosẹs ọtzọhni Joshua; wa Joshua osi odik kpenamkpen otzor, mach'Ọvaar Ibinọkpaabyi ọtzọhni Mosẹs. ");
INSERT INTO mfo_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","Iwa Joshua ọtzọkha ẹkhọma nda biphyir: wa ọtzọk okhubha kw'egbegbeho, ọmaana okhubha kwa Nẹgẹv biphyir, ọmaana ẹkhọma cha Goshẹn biphyir, ọmaana okhubha kwa mgbegbeho sa ndẹri-ọtzẹri k'okhubha kw'ewuchen em-edimi, ọmaana Araba ttara ka mgbegbeho s'Israẹl, ọmaana mgbegbeho sabẹ sa ndẹri-ọtzẹri, ");
INSERT INTO mfo_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","ttẹwọr k'egbegbho cha Halak ch'etzim echina ka Seir, ọmaana Baal-Gad k'Ittolim sa Lebanọn k'irekhirek kwa Hẹrmọn. Wa ọbọkha avaar pabẹ biphyir, ofhu. ");
INSERT INTO mfo_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","Wa Joshua orim avaar mba biphyir abẹ k'ogbe-bhirada. ");
INSERT INTO mfo_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","Wa odedenmon manda wani kw'okher bi, osi ẹmẹm ttara anọng p'Israẹl p'abọk bẹ biphyir k'egbong kode, ayongi anọng pa Hiv p'arukhi ka Gibeọn. ");
INSERT INTO mfo_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","Wa Ọvaar Ibinọkpaabyi ọkhaam ma for sẹ, wọ iwa odini bẹ nttem bi, bẹ atza arima anọng p'Israẹl abẹ, ifha orenga mẹ, odimi bẹ emeni biphyir-phyir. Wa odimi bẹ emeni biphyir-phyir inọngkwo kọkhaam ttara bẹ, atzor mach'iwa Ọvaar Ibinọkpaabyi ọkk'Mosẹs ọtzọhna. ");
INSERT INTO mfo_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","Wa k'ogbe nwuma Joshua ofon ọtza odimi anọng p'ẹkhọma ch'Anak p'arukhi k'okhubha kwa mgbegbeho: ttẹwọr ka Hẹbrọn, ọmaana Debir, ọmaana Anab, ọmaana okhubha kwa mgbegbeho biphyir ka Juda, ttara k'okhubha kwa mgbegbeho biphyir k'Israẹl. Wa Joshua odimi bẹ ttara idedenmon sabẹ biphyir-phyir. ");
INSERT INTO mfo_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","Wa ọnọng manda wani kw'ofon Anak kw'orikhi k'ẹkhọma ch'Israẹl kode; oyongi ka Gaza, ọmaana ka Gat tttara ka Ashdọd. ");
INSERT INTO mfo_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","Mando kw'iwa Joshua ọtzọk ẹkhọma nda biphyir, mach'iwa Ọvaar Ibinọkpaabyi okk'Mosẹs obena. Ọtzọkha chẹ ọnang anọng p'Israẹl, en-ede chabẹ, otzor ka ngọma sa bẹ ade. Mando kw'anọng p'ẹkhọma nda akwọhbh egbong oririma. ");
INSERT INTO mfo_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","Ma wọ ode avaarnọng p'ẹkhọma ch'iwa anọng p'Israẹl akk'akhema, abira abọkha bẹ ẹkhọma nda ana, k'okhubha kw'ewuchen em-eyin ka Jọdan, ttẹwọr k'Arnọn-Gọrge maa, apyiri k'egbegbeho cha Hẹrmọn, ttara k'okhubha kw'ewuchen em-eyin k'Araba biphyir: ");
INSERT INTO mfo_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","Sihon kw'ode ọvaarnọng kw'anọng p'Amọr, kw'ọdabhi ẹvaar ka Hẹshbọn. Wa ọdabhi ẹvaar k'Aroer, k'enem ch'Arnọn-Gọrge, ttẹwọr k'ottem kw'ittolim maa, apyiri k'Ọraanga kwa Jabọk, kw'ode enem ch'anọng p'Ammọn, ttara okhubha wani kw'ẹkhọma cha Gilẹad. ");
INSERT INTO mfo_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","Wa obiro ọdabh k'okhubha kw'ewuchen em-eyin k'Araba, ttẹwọr k'Ọraanga kw'ideden kwa Galilee maa, apyiri k'Ọraanga kw'ideden kw'Araba (kw'ode Ọraanga kw'Onung), obiro ọdabh Bẹt-Jẹshimọt maa, apyiri k'ẹrakha-ẹrakha achin k'irekhirek kw'ottolim fa mgbegbeho sa Pisga. ");
INSERT INTO mfo_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","Iwa bẹ abira akhema okhubha kwa Og kw'ode ọvaarnọng kwa Bashan. Wa Og ode ọnọng wani k'ottem kw'anọng pa Rẹphayi p'akpong nnam adabh ẹvaar k'Ashtarọt ọmaana Edrei. ");
INSERT INTO mfo_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","Wa kẹ ọdabhi ẹvaar k'okhubha kw'egbegbeho cha Hẹrmọn, ọmaana ka Salẹka, ọmaana Bashan biphyir maa, apyiri k'enem ch'anọng pa Gẹshur ọmaana Maaka, ttara okhubha wani kw'ẹkhọma cha Gilẹad maa, apyiri k'enem ch'iwa Sihon kw'ode ọvaarnọng kwa Hẹshbọn ọdabhi. ");
INSERT INTO mfo_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","Iwa Mosẹs, kw'ode ọtzọhmnọng kw'Ọvaar Ibinọkpaabyi, ọmaana anọng p'Israẹl akhema bẹ. Mosẹs kw'ode ọtzọhmnọng kw'Ọvaar Ibinọkpaabyi, ọtzọkha ẹkhọma chabẹ ọnang anọng pa Reuben, ọmaana pa Gad, ọmaana ibhaakha rani s'anọng pa Manasẹ bi, bẹ akhaama. ");
INSERT INTO mfo_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","Ma wọ ode obhik kw'avaarnọng p'ẹkhọma ch'iwa Joshua ọmaana anọng p'Israẹl akhem, k'okhubha kw'ewuchen em-edimi ka Jọrdan, ttẹwọr ka Baal-Gad k'Ittolim sa Lẹbanọn maa, apyiri k'egbegbeho cha Halak ch'ekkeri itzitzikha ka Seir. Wa Joshua ọtzọkha ẹkhọma chabẹ ọnang anọng mba mach'ekkema cha mfonamma s'Israẹl, atzor ka mfonamma sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","Wa ẹkhọma nda ẹttar okhubha kwa mgbegbeho, ọmaana okhubha kwa mgbegbeho sa ndẹri-ọtzẹri k'okhubha kw'ewuchen em-edimi, ọmaana Araba, ọmaana ottolim fa mgbegbeho, ọmaana ibe s'anọng an-arukhi ttara Nẹgẹv. Wa ẹkhoma nda ede ch'anọng pa Het, ọmaana p'Amọr, ọmaana pa Kenaan, ọmaana pa Pẹriz, ọmaana pa Hiv ttara anọng pa Jẹbus. Wa avaarnọng mba ade: ");
INSERT INTO mfo_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","Ọvaarnọng kwa Jẹriko, ọnọng wani; ọvaarnọng kw'Ayi (kẹ ọbaanga Bẹtẹl), ọnọng wani; ");
INSERT INTO mfo_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","ọvaarnọng kwa Jẹrusalẹm ọnọng wani; ọvaarnọng kwa Hẹbrọn ọnọng wani; ");
INSERT INTO mfo_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","ọvaarnọng kwa Jarmut ọnọng wani; ọvaarnọng kwa Lakish ọnọng wani; ");
INSERT INTO mfo_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","ọvaarnọng kw'Eglọn ọnọng wani; ọvaarnọng kwa Gezẹr ọnọng wani; ");
INSERT INTO mfo_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","ọvaarnọng kwa Debir ọnọng wani; ọvaarnọng kwa Gedẹr ọnọng wani; ");
INSERT INTO mfo_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","ọvaarnọng kwa Horma ọnọng wani; ọvaarnọng kw'Arad ọnọng wani; ");
INSERT INTO mfo_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","ọvaarnọng kwa Libna ọnọng wani; ọvaarnọng kw'Adulam ọnọng wani; ");
INSERT INTO mfo_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","ọvaarnọng kwa Makeda ọnọng wani; ọvaarnọng kwa Bẹtẹl ọnọng wani; ");
INSERT INTO mfo_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","ọvaarnọng kwa Tapau ọnọng wani; ọvaarnọng kwa Hephẹr ọnọng wani; ");
INSERT INTO mfo_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","ọvaarnọng kw'Aphẹk ọnọng wani; ọvaarnọng kwa Lasharọn ọnọng wani; ");
INSERT INTO mfo_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","ọvaarnọng kwa Madọn ọnọng wani; ọvaarnọng kwa Hazọr ọnọng wani; ");
INSERT INTO mfo_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","ọvaarnọng kwa Shimrọn-Merọn ọnọng wani; ọvaarnọng kw'Akshaph ọnọng wani; ");
INSERT INTO mfo_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","ọvaarnọng kwa Megido ọnọng wani; ");
INSERT INTO mfo_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","ọvaarnọng kwa Kadẹsh ọnọng wani; ọvaarnọng kwa Jokneyam ka Karmẹl ọnọng wani; ");
INSERT INTO mfo_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","ọvaarnọng kwa Dor ka Naphot-Dọr ọnọng wani; ọvaarnọng kwa Goyim ka Gilgal ọnọng wani; ");
INSERT INTO mfo_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","ọvaarnọng kwa Tirza ọnọng wani. Biphyir-phyir wa bẹ ade avaarnọng ẹrọbh obhiri jobh obhiri wani. ");
INSERT INTO mfo_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","K'ogbe kw'iwa Joshua ọkk'ọn-ọtzama, wa Ọvaar Ibinọkpaabyi oben-ẹ bi, “Kọ akk'an-atzama, yina, irerek itzim ibari-ọbar sa bọng atzọkha. ");
INSERT INTO mfo_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","“Irerek s'irikhi ide: Ngọma s'anọng pa Philistiya biphyir ọmaana s'anọng pa Geshur, ");
INSERT INTO mfo_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","ttẹwọr k'Ọraanga kwa Shihor k'okhubha kw'ẹwuchen em-eyin k'Ijip maa, apyiri k'ebira-ebira kw'Ẹkrọn. Wa bẹ atzọk okhubha nwa biphyir bi, ode ẹkhọma cha Kenaan, kaambi ode bi, wa avaar azen pa Philistiya bọ adabhi Gaza, ọmaana Ashdọd, ọmaana Ashkelọn, ọmaana Gat ttara Ẹkrọn, kw'ode okhubha kw'anọng p'Avit ");
INSERT INTO mfo_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","k'ẹrakha-ẹrakha; okhubha kw'anọng pa Kanaan biphyir, ttẹwọr k'Arah kw'anọng pa Sidọn maa, apyiri k'Aphẹk ọmaana k'enem ch'anọng p'Amọr; ");
INSERT INTO mfo_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","k'okhubha kw'anọng pa Gebal; ọmaana Lebanọn biphyir achin k'okhubha kw'ewuchen em-eyin maa, ttẹwọr ka Baal-Gad, k'irekhirek kw'egbegbeho cha Hẹrmọn maa, atza apyiri ka Lebo-Hamat. ");
INSERT INTO mfo_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","“Anọng biphyir p'okhubha kwa mgbegbeho, ttẹwọr ka Lebanọn maa, apyiri ka Misrephọt-Mayim, kw'ode anọng pa Sidọn biphyir, kaam ọkhaam wọ ngwubh bẹ k'itzitzikha s'anọng p'Israẹl. Kọ tzor ka ndọhna sa nkk'ọ nnanga, akkema irerek nna anang anọng p'Israẹl, ");
INSERT INTO mfo_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","akkema sẹ mach'ekkema cha ngọma nna ọhawani, ọmaana ibhaakha rani s'anọng p'efonamma cha Manasẹ.” ");
INSERT INTO mfo_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","Ibhaakha nnongo s'efonamma cha Manasẹ, ọmaana anọng pa Reubẹn ttara anọng pa Gad akk'ekkema chabẹ atzọkha, cha Mosẹs kw'ode ọtzọhmnọng kw'Ọvaar Ibinọkpaabyi okk'bẹ ọnanga, atzor k'odem kw'iwa okk'bẹ ọnanga. ");
INSERT INTO mfo_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","Iwa enem chabẹ ẹttẹwọr k'Aroer maa, apyiri k'enem ch'Arnọn-Gorge, ọmaana obhon kw'owobh k'ottem kw'ittolim, attar egbegbeho biphyir cha Medeba maa, apyiri ka Dibọn. ");
INSERT INTO mfo_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","Ebire etzima epyiri k'ibhon biphyir sa Sihon kw'ode ọvaarnọng kw'anọng p'Amọr kw'iwa ọdabhi ẹvaar ka Hẹshbọn, ẹtza ekponga k'enem ch'anọng p'Ammọn. ");
INSERT INTO mfo_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","Wa ọttar ẹkhọma cha Gilẹad, ọmaana okhubha kwa anọng pa Gẹshur ọmaana Maaka, ọmaana anọng biphyir p'egbegbeho cha Hẹrmọn ttara anọng pa Bashan maa, apyiri ka Salẹka ");
INSERT INTO mfo_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","kw'ode ẹkhọma cha Og ka Bashan, kw'iwa ọkk'ẹvaar ọdabha k'Ashtarọt ọmaana Ẹdrei. (Wa Og ode ọnọng wani k'ottem kw'anọng pa Rẹphayi p'akpong nnam adabh ẹvaar). Wa Mosẹs okk'bẹ okhema, ọtzọkha irerek sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","Yina, wa anọng p'Israẹl anọng pa Geshur ọmaana Maaka kakhubhi, bẹ achina ororo aruk ttara anọng p'Israẹl maa, apyiri k'ewu cha mayina. ");
INSERT INTO mfo_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","Yina, wa kẹ efonamma cha Lẹvi ekkema manda dani kọnangi, okhuri bi, nnanga nkwọmisẹ sa bẹ anangi Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'Israẹl rọ nde ekkema chabẹ, mach'iwa okk'ochekhi ọnang bẹ. ");
INSERT INTO mfo_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","Ma wọ ode ekkema ch'iwa Mosẹs okk'efonamma cha Reubẹn ọnanga, atzori ka nnọmma sabẹ: ");
INSERT INTO mfo_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","Wa k'okhubha nwa, enem nda etzim maa, epyiri k'Aroer k'ọkhaan-ọkhaan kw'Arnọn-Gọrge, ttẹwọr k'ottem kw'ittolim maa, apyiri k'egbegbeho biphyir akk'Medeba akwọbha, ");
INSERT INTO mfo_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","achina ka Hẹshbọn ọmaana k'ibhon s'iwobh k'egbegbeho biphyir, attar obhon kwa Dibon, ọmaana Bamọt-Baal, ọmaana Bẹt-Baal-Meon, ");
INSERT INTO mfo_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","ọmaana Jahaz, ọmaana Kedẹmọt, ttara Mephat, ");
INSERT INTO mfo_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","ọmaana Kiriyatayim, ọmaana Sibmat, ọmaana Zerẹt-Shahar kw'owobh k'egbegbeho ch'ittolim, ");
INSERT INTO mfo_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","ọmaana Bẹt-Peor, ọmaana ottolim fa mgbegbeho sa Pisgah, ttara Bẹt-Jeshimọt, ");
INSERT INTO mfo_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","ọmaana ibhon s'egbegbeho ebir-ebir biphyir ttara okhubha kwa Sihon biphyir, kw'ode ọvaarnọng kw'anọng p'Amọr ka Hẹshbọn. Wa Mosẹs ọkk'ẹ okhema ttara avaarnọng p'anọng pa Midiyan, ọmaana avaar-va p'ade: Ẹvi, ọmaana Rekem, ọmaana Zur, ọmaana Hur, ttara Reba p'iwa abe ttara Sihon kw'iwa orukhi m'ẹkhoma nda. ");
INSERT INTO mfo_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","Attar ayok pa bẹ afhu k'egbong, wa anọng p'Israẹl akk'ọkkankkaang atzima afhu Balam kw'ode nnwa kwa Beor, kw'ọbhari abọhkpakpa. ");
INSERT INTO mfo_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","Wa ẹkha ch'Ọraanga kwa Jọrdan dọ ede enem ch'anọng p'ẹkhọma cha Reubẹn. Ibhon nna ọmaana abhobhona pabẹ, bọ iwa ade ekkema ch'anọng p'ẹkhọma cha Reubẹn, atzori ka mfonamma sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","Ma wọ ode ekkema cha iwa Mosẹs ọkk'ẹkhọma cha Gad ọnanga, atzori ka nnọmma sẹ: ");
INSERT INTO mfo_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","Iwa okhubha kwa Jazer, ọmaana ibhon sa Gilead biphyir, ọmaana ibhaakha rani s'anọng p'Amon maa, apyiri k'Aroer, ọbaanga Rabah; ");
INSERT INTO mfo_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","abira attẹwọr ka Hẹshbọn maa, apyiri Ramat-Mizpa ọmaana Betonim, attẹwọr ka Mahanayim maa apyiri k'okhubha kwa Debir; ");
INSERT INTO mfo_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","ọmaana k'ittolim, ọmaana Bẹt-Nimra, ọmaana Sukọt ọmaana Zaphon ttara okhubha kwa Sihon biphyir, kw'ọvaarnọng kwa Hẹshbọn ọdabhi ẹvaar (k'okhubha kw'ewuchen em-eyin ka Jọrdan maa, atza apyiri k'okpong kw'Ọraanga kw'ideden kwa Galilee). ");
INSERT INTO mfo_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","Wa ibhon nna ọmaana abhobhona pabẹ, bọ iwa ade ekkema ch'anọng p'efonamma cha Gad, atzori ka nnọmma sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","Ma wọ ode ekkema ch'iwa Mosẹs okk'ibhaakha rani s'anọng p'efonamma cha Manasẹ ọnanga, kw'ode ibhaakha rani sa va pa va pa Manasẹ, atzori ka nnọmma sabẹ: ");
INSERT INTO mfo_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","Iwa ẹkhọma nda ẹttẹwọr ka Mahanayim maa, ẹkwu ẹttara k'anọng pa Bashan biphyir, ọmaana okhubha kwa Og kw'ode ọvaarnọng kwa Bashan, ttara ibhon arọbh attaan biphyir sa Jair ka Bashan, ");
INSERT INTO mfo_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","ibhaakha rani s'anọng pa Gilẹad, ọmaana Ashtarọt ttara Edrei (s'ide ivaar-bhon sa Og ka Bashan). Ma wọ ode ekkema ch'iwa ẹnọmma cha Makir, kw'ode nnwa kwa Manasẹ ọtzọk ọnang ibhaakha rani sa va pa va pa Makir, atzori ka nnọmma sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","Ma wọ ode ekkema ch'iwa Mosẹs ọkk'ọnanga, k'ogbe kw'owobh ka mgbegbeho sa Moab ka Jọrdan, k'okhubha kw'ewuchen em-eyin ka Jẹriko. ");
INSERT INTO mfo_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","Yina, wa Mosẹs ẹnọmma cha Lẹvi ekkema manda dani kọnangi; wa Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'Israẹl wọ ode ekkema chabẹ, mach'iwa ochekhi ọnang bẹ. ");
INSERT INTO mfo_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","Ma wọ ode obe f'anọng p'Israẹl atzọk mach'ekkema chabẹ k'irerek sa Kenaan, s'iwa Eleaza kw'ode ọfọhnẹja, ọmaana Joshua kw'ode nnwa kwa Nun ttara adeho pa ngọma s'Israẹl akkem anang bẹ. ");
INSERT INTO mfo_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","Wa bẹ abhari ose, atzima akkema ngọma nna ọhawani ọmaana ibhaakha, mach'Ọvaar Ibinọkpaabyi okk'Mosẹs ọtzọhna. ");
INSERT INTO mfo_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","Ode ch'iwa Mosẹs okk'ngọma mfa ọmaana ibhaakha ekkema chabẹ ọnanga k'okhubha kw'ewuchen em-eyin ka Jọrdan. Yina, wa efonamma cha Lẹvi ekkema kọnangi, ");
INSERT INTO mfo_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","da va pa va pa Josẹph akk'ngọma mfa, sa nde Manasẹ ọmaana Ephraim ada. Wa ẹnọmma cha Lẹvi ekkema k'irerek nnuma kẹtzọk, ayongi ibhon sa bẹ arukhi sẹ-sẹ, ọmaana iwoni s'araraari s'arukhimaan ọmaana abhaam pabẹ am-achi ọttọhk. ");
INSERT INTO mfo_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","Mando kw'anọng p'Israẹl akkem irerek nna atzor mach'Ọvaar Ibinọkpaabyi okk'bẹ ọtzọhna. ");
INSERT INTO mfo_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","Iwa anọng pa Juda afona atza akhebha Joshua ka Gilgal, Kalẹb kw'ode nnwa kwa Jephunẹ kw'ofon Keniz oben Joshua bi, “Kọ arong odik kw'iwa Ọvaar Ibinọkpaabyi ogbaakhi Mosẹs kw'ode ọtzọhmnọng kw'Ibinọkpaabyi, ka Kadẹsh Barnea kw'okhuri kaam ọmaana kọ kẹ. ");
INSERT INTO mfo_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","Wa kaam nde cho arọbh afa k'ogbe kwa Mosẹs kw'ode ọtzọhmnọng kw'Ọvaar Ibinọkpaabyi, ọtzọhm-m ka Kẹdẹsh Barnea, bi nda nnom irerek nnuma. Wa ndor k'ekhera chaam, ndima ẹkkaabha ọkkakka nchen-ẹ. ");
INSERT INTO mfo_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","Yina, wa ayokh-obhon paam p'Israẹl, pa mọtzọni ovura kẹ, atzima ẹkkabha-tzama, ch'iwa ekhe anọng ojora ka nttem. Kaam ndim ettem obungichẹ chaam ndọn Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwaam abẹ. ");
INSERT INTO mfo_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","Mẹ wọ ofon, wa Mosẹs ochekhi ọnang-m m'ewu nduma bi, ‘Irerek nna s'akk'mmo sọ abari íde ekkema chọ, ọmaana ekkama cha va pa va pọ maa, ikhina ogbe ode, okhuri bi, kọ akk'ettem obungichẹ chọ atzima atzọn Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwaam abẹ.’ ");
INSERT INTO mfo_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","“Mẹ wọ ofon, odem nwa kw'iwa Ọvaar Ibinọkpaabyi ochekhi, okk'aam akpen ohokha ka cho arọbh afa obhiri azen, ttẹwọr k'ogbe kw'ọgbaakhi Mosẹs odik nwa, mada anọng p'Israẹl am-akpaanga akhọri ibe s'anọng an-arukhi. Ma mayina kaam nna nde cho arọbh anna obhiri azen! ");
INSERT INTO mfo_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","Kaam ndimi mingaama ẹfa mayina, mach'ewu ch'iwa Mosẹs ọtzọhm-m bi nda orenga nwuma. Ẹfa ch'egbong etzim ewobh-m ka mach'iwa. ");
INSERT INTO mfo_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","Kọ nang-m okhubha nwa kwa mgbegbeho, kw'iwa Ọvaar Ibinọkpaabyi okk'ochekhi m'ewu nduma ọnang-m. Wa kọ ọkhaam akk'abhaanga bi, anọng p'Anak bọ iwa arukhi mẹ, ọmaana bi, wa ibhon sabẹ ibari-ọbar, ibiri ikhaama mbaakhamma. Yina, k'ẹfa ch'Ọvaar Ibinọkpaabyi, kaam ńgwubh bẹ okhwubh mach'iwa kẹ ọgbaakhi.” ");
INSERT INTO mfo_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","Wa Joshua osi Kalẹb kw'ode nnwa kwa Jephunẹ ittabọhng, obiro ọnang-ẹ obhon kwa Hẹbrọn mach'ekkema chẹ. ");
INSERT INTO mfo_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","Ttẹwọr mẹ, wa Hẹbrọn on-ode ekkema cha Kalẹb, kw'ode nnwa kwa Jephunẹ kw'ofon Keniz, da iwa kẹ otzim ettem obungichẹ, ọtzọn Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'Israẹl abẹ. ");
INSERT INTO mfo_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","(Wa bẹ am-ayeri Hẹbrọn, Kiriyat-Arba abhina Arba kw'iwa ode okkengitza k'ottem kw'anọng p'Anak.) Mẹ wọ ofon, wa anọng p'ẹkhọma nda egbong dọk karim. ");
INSERT INTO mfo_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","Iwa ekkema ch'efonamma cha Juda, atzori ka nnọmma sẹ etzim epyiri k'ẹkhọma ch'Edom maa, etza epyiri k'ibe s'anọng an-arukhi ka Zin k'okpong kw'okhubha kw'ẹrakha-ẹrakha. ");
INSERT INTO mfo_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","Enem chabẹ k'ẹrakha-ẹrakha ẹttẹwọr m'ẹraangakha ch'Ọraanga kw'ideden kw'Onung, ");
INSERT INTO mfo_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","epyiri k'ẹrakha-ẹrakha kw'Eden ch'Ininaang, etzima echina ka Zin, ẹkwọbha echina k'ẹrakha-ẹrakha kwa Kadẹsh-Barnea. Ejekha Hẹzrọn echina k'Adar, yina ẹn-ẹkhọri echina ka Karka. ");
INSERT INTO mfo_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","Yina ẹn-ẹkwọbh echina Azmon ẹtza ẹjaakhi k'Ittolim s'Ijip, yina ẹn-ẹtza ekponga k'Ọraanga kw'ideden kwa Mediteraniya. Ma wọ ode enem chabẹ k'ẹrakha-ẹrakha. ");
INSERT INTO mfo_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","K'okhubha kw'ewuchen em-eyin, enem ewobha m'Ọraanga kw'ideden kw'Onung etzima epyiri kẹ da ọraanga kwa Jọrdan ọjaakhi k'ọraanga kw'ideden. Enem nda k'ebira-ebira ẹttẹwọr m'ibhakhi s'ọraanga kw'ideden kẹ da ọraanga kwa Jọrdan ọjaakhi k'ọraanga kw'ideden, ");
INSERT INTO mfo_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","etzima epyiri ka Bẹt-Hogla, etzima epyiri k'ebira-ebira kwa Bẹt-Araba maa, epyiri k'Ọtza kwa Bohan. Wa Bohan ode nnwa kwa Reubẹn. ");
INSERT INTO mfo_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","Enem nda en-evura echina ka Debir, ẹttẹwọr k'Ittolim s'Achọr, ẹtza ẹbhakhi echina k'ebira-ebira da achin ka Gilgal kw'okkeri Eden ch'Adumim itzitzikha, k'ẹrakha-ẹrakha kw'ittolim. Echina ororo maa, epyiri ka ngekha s'Ẹn-Shẹmẹsh ẹtza eyin k'Ẹn-Rogẹl. ");
INSERT INTO mfo_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","En-erenga evura k'Ittolim sa Bẹn-Hinom echina k'ittolim ẹrakha-ẹrakha kw'odedenmon kw'anọng pa Jẹbus (kw'ode Jẹrusalẹm). Ttẹwọr mẹ en-evura echina k'egbegbeho k'okhubha kw'ewuchen em-edimi k'Ittolim sa Hinom k'okpong kw'okhubha kw'ebira-ebira kw'Ittolim sa Rephayim. ");
INSERT INTO mfo_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","Ttẹwọr k'egbegbeho ebira, enem nda en-echina k'okhubha kw'okhekhaho kwa ngekha sa Nẹphtoa, eyin m'ibhon s'egbegbeho ch'Ẹphrọn, ẹn-ẹhakha echina Bala (kw'ode Kiriyat-Jẹarim). ");
INSERT INTO mfo_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","Ẹn-ẹbhakhi echina k'okhubha kw'ewuchen em-edimi, ka Bala echina k'egbegbeho cha Seir, erenga k'ebira-ebira kw'Ittolim ka Jẹarim (kw'ode Kẹsalọn), echina ororo maa, ẹtza ẹhakha ka Bẹt-Shẹmẹsh, ejekha echina Timna. ");
INSERT INTO mfo_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","Erenga echina k'ebira-ebira kw'Ittolim s'Ẹkrọn, ẹbhakhi echina Shikerọn, erenga ẹkwọbha egbegbeho cha Bala epyiri ka Jabnel. Enem nda ekponga k'ọraanga kw'ideden. ");
INSERT INTO mfo_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","Ọraanga kw'ideden kwa Mediteraneya wọ ode enem k'okhubha kw'ewuchen em-edimi. Ma wọ ode nnem sa ngọri anọng pa Juda, atzori ka nnọmma sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","Iwa Joshua ọnangi Kalẹb kw'ode nnwa kwa Jẹphunẹ, Kirayat Arba kw'ode Hẹbrọn mach'ekkema chẹ k'ẹkhọma cha Juda, otzor k'odem kw'Ọvaar Ibinọkpaabyi ọkk'ẹ ọtzọhna bi osi. (Wa Arba wọ ode otte kw'ideden kw'anọng p'Anak.) ");
INSERT INTO mfo_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","Wa Kalẹb okhubh va p'Anak, p'ade Shẹshayi ọmaana Ahiman ttara Talmayi ka Hẹbrọn. ");
INSERT INTO mfo_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","Wa obina mẹ ọtza orima anọng pa Debir abẹ (Debir kw'iwa bẹ ayeri Kiriyat-Sẹphẹr). ");
INSERT INTO mfo_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","Mẹ wọ ofon, wa Kalẹb oben bi, “Ojinọng kw'orim Kiriyat-Sẹpher abẹ obiro okhem-ẹ, kaam ńnang-ẹ Aksa, kw'ode nnwa kwaam kw'ikwanọng, k'ọbada.” ");
INSERT INTO mfo_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","Wa Otniyẹl kw'ode nnwa kwa Kenaz, kw'ode ọgbaanotte kwa Kalẹb, okhema obhon nwa; mẹ wọ osi, wa Kalẹb ọnang-ẹ nnwa kwẹ kw'ikwanọng kw'okpen Aksa k'ọbada. ");
INSERT INTO mfo_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","Iwa ewu dani, mada kwanọng nwa ofon kẹ okwu okhebha Otniyẹl, kwanọng nwa oben-ẹ bi, ophyem otte irerek. Mada ọhak k'ẹnyanyaang chẹ, Kalẹb ọbọbh-ẹ bi, “Mbọng f'aror bi, ira nsi nnang-ọ?” ");
INSERT INTO mfo_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","Kwanọng nwa obhina bi, “Kọhkh-m ọphyaam bi gbengene. Mada akk'aam irerek ananga ka Nẹgẹv, biri nang-m akhekhaho pa ngekha.” Wa Kalẹb ọnang-ẹ akhekhaho p'ebira-ebira ọmaana p'ẹrakha-ẹrakha. ");
INSERT INTO mfo_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","Ma wọ ode ekkema ch'ẹkhọma cha Juda atzori ka nnọmma sabẹ: ");
INSERT INTO mfo_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","Iwa ibhon s'iwobh k'ẹrakha-ẹrakha kwa Juda ka Nẹgẹv, da akkeri k'okhubha kw'enem ch'Edom ide: Kabzel, ọmaana Eder, ọmaana Jagur, ");
INSERT INTO mfo_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","ọmaana Kina, ọmaana Dimona, ọmaana Adada, ");
INSERT INTO mfo_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","ọmaana Kedẹsh, ọmaana Hazọr, ọmaana Itnan, ");
INSERT INTO mfo_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","ọmaana Ziph, ọmaana Telem, ọmaana Bealot, ");
INSERT INTO mfo_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","ọmaana Hazọr-Hadata, ọmaana Keriot-Hẹzrọn (kw'ode Hazọr), ");
INSERT INTO mfo_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","ọmaana Amam, ọmaana Shema, ọmaana Molada, ");
INSERT INTO mfo_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","ọmaana Hazar-Gada, ọmaana Heshmon, ọmaana Bẹt-Pẹlẹt, ");
INSERT INTO mfo_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","ọmaana Hazar-Shual, ọmaana Beershẹba, ọmaana Biziotiya, ");
INSERT INTO mfo_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","ọmaana Bala, ọmaana Iyim, ọmaana Ezem, ");
INSERT INTO mfo_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","ọmaana Eltolad, ọmaana Kesil, ọmaana Horma, ");
INSERT INTO mfo_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","ọmaana Ziklag, ọmaana Madmana, ọmaana Sansana, ");
INSERT INTO mfo_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","ọmaana Lebayot, ọmaana Shilhim, ọmaana Ayin ttara Rimọn. Biphyir-phyir wa ode idedenmon ẹrọbh obhiri ọhawani, ọmaana abhonbhona pabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","K'okhubha kwa mgbegbeho sa ndẹri-ọtzẹri, kẹ da ewuchen em-edimi, wa ode: Ẹshtaol, ọmaana Zora, ọmaana Ashna, ");
INSERT INTO mfo_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","ọmaana Zanoa, ọmaana Ẹn-Ganim, ọmaana Tapua, ọmaana Enam, ");
INSERT INTO mfo_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","ọmaana Jarmut, ọmaana Adulam, ọmaana Soko, ọmaana Azeka, ");
INSERT INTO mfo_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","ọmaana Sharayim, ọmaana Aditayim ttara Gedera (kw'ode Gederotayim), kw'osi idedenmon ọhawani kwa chi ọmaana abhobhona pabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","Iwa obiro ode ibhon sa Zenan, ọmaana Hadasha, ọmaana Migdal-Gad, ");
INSERT INTO mfo_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","ọmaana Dilean, ọmaana Mizpa, ọmaana Joktẹl, ");
INSERT INTO mfo_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","ọmaana Lakish, ọmaana Bozkat, ọmaana Ẹglọn, ");
INSERT INTO mfo_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","ọmaana Kabon, ọmaana Lahmas, ọmaana Kitlish, ");
INSERT INTO mfo_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","ọmaana Gederọt, ọmaana Bẹt-Dagọn, ọmaana Nama ttara Makeda, kw'osi idedenmon chi obhiri wani ọmaana abhobhona pabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","Iwa obiro ode ibhon sa Libna, ọmaana Eter, ọmaana Ashan, ");
INSERT INTO mfo_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","ọmaana Iphta, ọmaana Ashna, ọmaana Nezib, ");
INSERT INTO mfo_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","ọmaana Keila, ọmaana Akzib ttara Maresha, kw'osi idedenmon ọhawani ọmaana abhobhona pabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","Ẹkrọn, ọmaana ibhon s'irukhi ikhọr-ẹ ttara abhobhona pabẹ; ");
INSERT INTO mfo_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","k'okhubha kw'ewuchen em-edimi k'Ẹkrọn, ọmaana ibhon biphyir s'iwobh k'okhubha kw'Ashọd, ọmaana abhobhona pabẹ; ");
INSERT INTO mfo_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","Ashọd ọmaana ibhon s'ikhọr-ẹ ọmaana abhobhona pabẹ maa, apyiri k'Ittolim s'Ijip ttara k'okhubha kw'Ọraanga kw'ideden kwa Mediteraniya. ");
INSERT INTO mfo_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","K'okhubha kwa mgbegbeho ode: Shamir, ọmaana Jatir, ọmaana Soko, ");
INSERT INTO mfo_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","ọmaana Dana, ọmaana Kiriyat-Sana (kw'ode Debir), ");
INSERT INTO mfo_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","ọmaana Anab, ọmaana Eshtemọ, ọmaana Anim, ");
INSERT INTO mfo_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","ọmaana Goshen, ọmaana Holon ttara Gilo, kw'osi idedenmon jobh obhiri wani ọmaana abhobhona pabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","Iwa obiro ode ibhon s'Arab, ọmaana Duma, ọmaana Eshan, ");
INSERT INTO mfo_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","ọmaana Janim, ọmaana Bẹt-Tapua, ọmaana Apheka, ");
INSERT INTO mfo_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","ọmaana Humta, ọmaana Kiriyat-Arba (kw'ode Hẹbrọn) ttara Zior, kw'osi idedenmon ọhawani ọmaana abhobhona pabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","Iwa obiro ode ibhon sa Maon, ọmaana Karmẹl, ọmaana Ziph, ọmaana Juta, ");
INSERT INTO mfo_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","ọmaana Jezrel, ọmaana Jokdeam, ọmaana Zanoa, ");
INSERT INTO mfo_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","ọmaana Kain, ọmaana Gibea ttara Timna, kw'osi idedenmon jobh ọmaana abhobhona pabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","Iwa obiro ode ibhon sa Halhul, ọmaana Bẹt-Zur, ọmaana Gedor, ");
INSERT INTO mfo_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","ọmaana Maarat, ọmaana Bẹt-Anot ttara Eltekon, kw'osi idedenmon izadani ọmaana abhobhona pabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","Iwa obiro ode ibhon sa Kiriyat-Baal (kw'ode Kiriyat-Jearim) ọmaana Raba kw'ode idedenmon ifa ọmaana abhobhona pabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","K'ibe s'iwa anọng an-arukhi ode: Bẹt-Araba, ọmaana Midin, ọmaana Sekaka, ");
INSERT INTO mfo_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","ọmaana Nibshan, ọmaana odedenmon kw'Onung ọmaana Ẹn-Gẹdi kw'osi idedenmon izadani ọmaana abhobhona pabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","Wa anọng p'ẹkhọma cha Juda bẹ anọng pa Jẹbus p'arukhi ka Jẹrusalẹm kafha akhubh; anọng mba pa Jẹbus atzima arukhi ttara anọng pa Juda maa, apyiri k'ewu cha mayina. ");
INSERT INTO mfo_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","Iwa ekkema ch'anọng pa Josẹph ẹttẹwọr ka Jọrdan, k'okhubha kw'ewuchen em-eyin k'akhekhaho pa Jeriko, ẹttẹwọr mẹ erenga evura k'ibe s'iwa anọng an-arukhi, etzima mẹ maa, epyiri k'ẹkhọma cha Bẹtẹl. ");
INSERT INTO mfo_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","Etzima ma Bẹtẹl (kw'ode Luz), ejekha echina k'ẹkhọma ch'anọng p'Ark k'Atarọt. ");
INSERT INTO mfo_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","Ẹn-ẹwọna echina k'okhubha kw'ewuchen em-edimi k'okhubha kw'anọng pa Japhlẹt maa, ẹtza epyiri k'irekhirek kw'ẹkhọma cha Bẹt-Họrọn etzima maa, epyiri ka Gẹzẹr. Yina ẹn-ẹtza ekponga k'Ọraanga kw'ideden kwa Mediteraneya. ");
INSERT INTO mfo_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","Mando kwa anọng pa Manasẹ ọmaana anọng p'Ephraim p'iwa ade va pa va pa Josẹph, atzọk ekkema chabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","Ma wọ ode okhubha kw'Ephraim atzori ka nnọmma sabẹ: Iwa enem ch'ekkema chabẹ ẹttẹwọr k'Atarọt-Adar k'okhubha kw'ewuchen em-eyin maa, epyiri k'ebira-ebira kwa Bẹt-Họrọn, ");
INSERT INTO mfo_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","etzima ẹtza epyiri k'Ọraanga kw'ideden kwa Mediteraneya. Ttẹwọr ka Mikmẹtat, ẹkhọri echina k'okhubha kw'ewuchen em-eyin ka Taanat-Shilo, ẹkwọbha echina ka Jonoa k'okhubha kw'ewuchen em-eyin. ");
INSERT INTO mfo_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","Ttẹwọr ka Janoa, ẹwọna echina k'Atarọt ọmaana Naara, ẹtza ẹkwọhkhi ka Jeriko, ẹtza eyin k'Ọraanga kwa Jọrdan. ");
INSERT INTO mfo_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","Ttẹwọr ka Tapua, enem nda echina k'okhubha kw'ewuchen em-edimi k'Ittolim sa Kana, ẹtza ekponga k'Ọraanga kw'ideden kwa Mediteraneya. Ma wọ ode ekkema ch'ẹkhọma ch'anọng p'Ephraim, atzori ka nnọmma sabẹ: ");
INSERT INTO mfo_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","Iwa ọttar idedenmon biphyir ọmaana abhobhona pabẹ akhọmi anọng p'Ephraim ahok, k'ottem kw'ekkema ch'anọng pa Manẹsẹ. ");
INSERT INTO mfo_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","Wa bẹ anọng pa Kenaan p'arukhi ka Gẹzẹr kakhubhi. Anọng mba pa Kenaan atzim am-aruk ttara anọng p'Ephraim maa, apyiri k'ewu cha mayina. Yina, anọng mba pa Kenaan bọ am-asi obira-tzọhm. ");
INSERT INTO mfo_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","Ma wọ ode ekkema ch'ẹkhọma ch'anọng pa Manasẹ, mach'ocheden-nwa kwa Josẹph, ch'iwa ede ekkema cha Makir, kw'ode ocheden-nwa kwa Manasẹ. Wa Makir wọ ode otte kw'ideden kw'anọng pa Gilead, p'akk'Gilead ọmaana Bashan atzọkha okhuri da iwa anọng pa Makir ade arim-egbong p'akhaam ẹfa. ");
INSERT INTO mfo_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","Mẹ wọ osi, wa ekkema nda ede ch'anọng pa Manasẹ p'ade ẹnọmma ch'Abiezer, ọmaana cha Helek, ọmaana ch'Asriyẹl, ọmaana cha Shẹkẹm, ọmaana cha Hephe ttara cha Shemida. Ma wọ ode va pa va p'ijinọng adọdọk pa Manasẹ kw'ode nnwa kwa Josẹph, atzori ka nnọmma sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","Iwa Zelophehad kw'ode nnwa kwa Hepher, kw'ode nnwa kwa Gilead, kwọde nnwa kwa Makir, kw'ode nnwa kwa Manasẹ, va p'ijinọng kokhaam, oyongi va p'ipanọng bẹ-bẹ, pa akpen Mahla, ọmaana Noa, ọmaana Hogla, ọmaana Milka ttara Tirza. ");
INSERT INTO mfo_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","Iwa bẹ afona atza akhebha Eleazer kw'ode ọfọhnẹja, ọmaana Joshua kw'ode nnwa kwa Nun ttara adeho, aben bi, “Wa Ọvaar Ibinọkpaabyi obeni Mosẹs bi, ọnang man ekkema k'ottem kwa votte paman e.” Mando kw'iwa Joshua ọnangi bẹ ekkema mẹ ọbaanga votte pabẹ, otzor ka ndọhna s'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","Wa ekkema ch'anọng pa Manasẹ ede irerek k'obe jobh, akhiri Gilead ọmaana Bashan aji, k'okhubha kw'ewuchen em-eyin ka Jọrdan, ");
INSERT INTO mfo_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","okhuri da iwa va p'ipanọng p'ẹkhọma cha Manasẹ abira atzọkha ekkema k'ottem kwa va p'ijinọng. Wa ẹkhọma cha Gilead ẹn-ẹkhaam va pa va pa Manasẹ biphyir. ");
INSERT INTO mfo_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","Iwa enem ch'ẹkhọma cha Manasẹ ẹttẹwọr k'Ashẹr etzima maa, epyiri ka Mikmetat k'okhubha kw'ewuchen em-eyin ka Shẹkẹm. Enem nda etzim echina k'ẹrakha-ẹrakha maa, ẹtza ẹttara anọng p'arukhi k'Ẹn-Tapua. ");
INSERT INTO mfo_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","(Wa Manasẹ wọ ọkhaam irerek sa Tapua, yina, Tapua ma for sẹ k'enem cha Manasẹ, ode obhon kw'anọng p'Ephraim). ");
INSERT INTO mfo_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","Wa enem nda etzim echina k'ẹrakha-ẹrakha kw'Ittolim sa Kana. Wa ọkhaam ibhon sa ide s'anọng p'Ephraim s'iwobh k'ottem kw'ibhon s'anọng pa Manasẹ. Yina, wa enem cha Manasẹ ewobh k'ebira-ebira kw'ittolim, ẹtza ekponga k'Ọraanga kw'ideden kwa Mẹditeraneya. ");
INSERT INTO mfo_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","Wa Ephraim ọkhaam ẹrakha-ẹrakha, Manasẹ ọkhaama ebira-ebira. Ẹkhọma cha Manasẹ etzim epyiri k'Ọraanga kwa Mẹditeraneya, ẹtza epyiri k'ẹbira-ebira kw'ẹkhọma ch'Ashẹr, ọmaana k'okhubha kw'ewuchen em-eyin k'ẹkhọma k'Isaaka. ");
INSERT INTO mfo_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","M'ottem kw'ẹkhọma ch'Isaaka ọmaana ẹkhọma ch'Ashẹr, wa Manasẹ obiro ọkhaama ibhon sa Bẹt-Shan, ọmaana Ibleam ttara anọng pa Dor, ọmaana anọng p'Ẹn-Dor, ọmaana pa Taanak, ọmaana pa Megido, ttara ibhon s'ikhọri bẹ ikhe k'ottem (ottong ibhon ittaan on-ode obhon kwa Naphot). ");
INSERT INTO mfo_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","Yina, wa anọng pa Manasẹ bẹ m'ibhon nna kafha aruk; da iwa anọng pa Kenaan akk'nttem sabẹ asa bi, bẹ aruk m'ẹkhọma nda. ");
INSERT INTO mfo_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","Ayongi, k'ogbe kw'anọng p'Israẹl akk'ẹfa an-akhaama, kaambi ode bi, wa bẹ anọng pa Kenaan biphyir kakhubhi, wa bẹ an-akhe anọng pa Kenaan k'obira-tzọhm. ");
INSERT INTO mfo_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","Wa anọng pa Josẹph aben Joshua bi, “Ode yan kw'anangi man ẹkhọma dani chẹ-chẹ, abira anang man ekkema dan o? Maman ọhaabh-ọhaabh, Ọvaar Ibinọkpaabyi okk'man obiro ọda ejibha-ejibha.” ");
INSERT INTO mfo_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","Mẹ wọ ofon, Joshua obhina bi, “Idikha bọng ahaabhi kpọng, okhubha kwa mgbegbeho s'Ephraim ọkhar kpọng bi obiro obenga bọng, bọng nọng atza attem ibe k'irerek s'anọng pa Pẹriz ọmaana anọng pa Rephayit anang for sabọng.” ");
INSERT INTO mfo_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","Iwa anọng pa Josẹph abhina bi, “Okhubha kwa mgbegbeho man kobeng. Anọng pa Kenaan p'arukhi k'egbegbeho, p'ade anọng p'arukhi ka Bẹt-Shan ọmaana anọng p'arukhi k'Ittolim sa Jẹzrẹl, akhaam akpaar pa nnyanyaang mmindọr pa bẹ agban k'akkonga.” ");
INSERT INTO mfo_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","Mẹ wọ ofon, wa Joshua oben ngọma sa Josẹph sa ndẹ anọng p'Ephraim ọmaana anọng pa Manasẹ bi, “Bọbọng ahaabhi kpọng e, bọng abira akhaama ẹfa. Bọng ẹkhọma dani chẹ-chẹ kákhaama e. ");
INSERT INTO mfo_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","Yina, bọng dọkha ẹtzam ch'okhubha kwa mgbegbeho attara. Bọng nọng atza attem chẹ. Ibe sa bọng attemi apyiri biphyir ide sabọng. Kaambi ode bi, anọng pa Kenaan akhaam akpaar pa nnyanyaang mmindọr pa bẹ atzim akkonga asi, bẹ abira akhaama ẹfa, bọng afha akhubh bẹ okhubh.” ");
INSERT INTO mfo_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","Iwa anọng p'ebhonmọr ch'Israẹl biphyir atzobha ka Shilo. Bẹ attima ikhira s'etzobha ch'Ibinọkpaabyi mẹ. Wa ẹkhọma nda biphyir en-ewobha k'irekhirek kw'ẹfa chabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","Yina, wa ngọma nzenamfa s'anọng p'Israẹl ekkema chabẹ ndimi ndọkha. ");
INSERT INTO mfo_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","Mẹ wọ ofon, Joshua oben anọng p'Israẹl bi: “Ogbe óbhir otzuma yan, yina bọng atzọkha ekkema ch'irerek s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'ab'atte okk'bọng ọnanga o? ");
INSERT INTO mfo_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","Bọng dekha ajinọng attaan k'ẹkhọma kpenamkpen. Kaam ńdọhm bẹ atza aronga ẹkhọma nda, ifha bẹ abira akkeri odem kwa chẹ ede, atzor k'odem kw'ekkema ch'ẹkhọma kpenamkpen ede. ");
INSERT INTO mfo_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","Bọng ákkema ẹkhọma nda k'obe ozenamfa. Juda owobha k'ẹrakha-ẹrakha kẹ da okkekkeni owobha. Ngọma sa Josẹph nwobha k'ebira-ebira kw'ode kwabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","Bọng akk'odem kw'obe mva ozenamfa ode akkẹra, bọng chen-m ifha kaam ḿmari ose nnang bọng, m'itzitzikha s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwaman. ");
INSERT INTO mfo_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","Ayongi mẹ, anọng p'efonamma cha Lẹvi ekkema k'ottem kwabọng kakhaam, okhuri bi, ọtzọhm f'ẹja ọfọfọhni f'Ọvaar Ibinọkpaabyi vọ ode ekkema chabẹ. Gad, ọmaana Reubẹn ttara ibhaakha rani s'anọng p'ẹkhọma cha Manasẹ, akk'ekkema chabẹ atzam atzọkha k'okhubha kw'ewuchen em-eyin ka Jọrdan. Wa Mosẹs kw'ode ọtzọhmnọng kw'Ọvaar Ibinọkpaabyi, wọ ọnangi bẹ chẹ.” ");
INSERT INTO mfo_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","Mada ajinọng mba attẹwọr bi, abẹ atza akhe nnem s'irerek nna, Joshua oben bẹ bi, “Bọng nọhng atza aronga irerek nna, bọng akkẹr odem kwa chẹ ede. Bọng chen-m, ifha kaam ḿmari ose nnang bọng ma Shilo, m'itzitzikha s'Ọvaar Ibinọkpaabyi.” ");
INSERT INTO mfo_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","Mando kw'ajinọng mba afon, atza arenga akhọri irerek nna. Bẹ akkẹr ka nnwẹr odem kwa chẹ ede, atzọr k'ibhon-k'ibhon k'obe ozenamfa. Wa bẹ akpa nnam atzor Joshua k'ibhingabe ka Shilo. ");
INSERT INTO mfo_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","Mando kwa Joshua obhari ose ọnang bẹ ma Shilo, m'itzitzikha s'Ọvaar Ibinọkpaabyi. Mẹ wọ kw'owobh okkema irerek nna ọnang anọng p'Israẹl, otzor ka ngọma sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","Iwa ekkema ch'echi eden ede ch'ẹkhọma cha Bẹnjamin, atzori k'nnọmma sabẹ. Wa ekkema chabẹ ewobh k'ottem kwa ẹkhọma cha Juda ọmaana cha Josẹph: ");
INSERT INTO mfo_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","Enem chabẹ k'ebira-ebira, ẹttẹwọr ka Jọrdan, ẹkwọbha ittolim s'ebira-ebira kwa Jeriko, echina k'okhubha kw'ewuchen em-edimi, edim k'okhubha kwa mgbegbeho, yina en-eyini k'ibe s'iwa anọng an-arukhi sa Bẹt-Avẹn. ");
INSERT INTO mfo_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","Efona mẹ ejekha echina k'ittolim s'ẹrakha-ẹrakha sa Luz (kw'ode Bẹtẹl). Etzima echina k'Atarọt-Adar k'ẹrakha-ẹrakha kw'egbegbeho cha Bẹt-Horọn kw'irekhirek. ");
INSERT INTO mfo_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","Ttẹwọr k'egbegbeho ch'ekkeri Bẹt-Horọn itzitzikha k'ẹrakha-ẹrakha, enem nda ẹbhakhi ẹrakha-ẹrakha echina k'okhubha kw'ewuchen em-edimi, ẹtza eyin ka Kiriyat-Baal (kw'ode Kiriyat-Jẹarim), kw'ode obhon kw'anọng pa Juda. Iwa ode okhubha kw'ewuchen em-edimi. ");
INSERT INTO mfo_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","Okhubha kw'ẹrakha-ẹrakha ọttẹwọr k'ebhonho cha Kiriyat-Jẹarim k'okhubha kw'ewuchen em-edimi. Enem nda ẹtza eyin k'okhekhaho kwa ngekha sa Nephtoa. ");
INSERT INTO mfo_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","Enem nda etzima ẹhakha k'egbegbeho-rin, ch'ekkeri Ittolim sa Bẹn-Hinọm itzitzikha, k'ebira-ebira kw'Ittolim sa Rẹphayim. Etzima echina k'Ittolim sa Hinọm, k'ẹrakha-ẹrakha kw'igbegbe-wọna s'odedenmon kw'anọng pa Jẹbus maa, epyiri k'Ẹn-Rogẹl. ");
INSERT INTO mfo_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","Ẹn-ẹbhakhi echina k'ebira-ebira kw'Ẹn-Shẹmẹsh, ẹkwọbha echina ka Gelilọt kw'okkeri Eden ch'Adumim itzitzikha maa, epyiri k'Ọtza kwa Bohan. Wa Bohan ode nnwa kwa Reubẹn. ");
INSERT INTO mfo_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","Etzima mẹ ẹtza etto k'ittolim k'ebira-ebira kwa Bẹt-Araba maa, ẹtza ẹhakha k'Araba. ");
INSERT INTO mfo_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","Etzima mẹ echina k'ebira-ebira kw'Ittolim sa Bẹt-Hogla, ẹtza eyin k'ebira-ebira kw'ẹraangakha ch'Ọraanga kw'ideden kw'Onung, k'ẹrakha-ẹrakha kw'ẹraangama cha Jọrdan. Ma wọ iwa ode enem ch'okhubha kw'ẹrakha-ẹrakha. ");
INSERT INTO mfo_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","Iwa ọraanga kwa Jọrdan wọ ode enem ch'okhubha kw'ewuchen em-eyin. Ma wọ ode nnem s'ikhọhk ekkema cha nnọmma s'ẹkhọma cha Bẹnjamin, k'okhubha kpenamkpen. ");
INSERT INTO mfo_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","Iwa ẹkhọma cha Bẹnjamin, atzori ka nnọmma sabẹ, ede: Jeriko, ọmaana Bẹt-Hogla, ọmaana Emek-Keziz, ");
INSERT INTO mfo_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","ọmaana Bẹt-Araba, ọmaana Zemarayim, ọmaana Bẹtẹl, ");
INSERT INTO mfo_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","ọmaana Avim, ọmaana Para, ọmaana Ọphra, ");
INSERT INTO mfo_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","ọmaana Kephar-Amoni, ọmaana Ophni ttara Geba, kw'osi idedenmon jobh obhiri ifa ọmaana abhobhona pabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","Iwa obiro ode ibhon sa Gibeon, ọmaana Rama, ọmaana Berọt, ");
INSERT INTO mfo_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","ọmaana Mizpa, ọmaana Kephira, ọmaana Moza, ");
INSERT INTO mfo_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","ọmaana Rekem, ọmaana Irpel, ọmaana Tarala, ");
INSERT INTO mfo_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","ọmaana Zela, ọmaana Haelẹph, ttara odedenmon kwa Jẹbus (kw'ode Jẹrusalẹm), ọmaana Gibea ttara Kiriyat, kw'osi idedenmon ọhawani kwa chi ọmaana abhobhona pabẹ. Ma wọ iwa ode ekkema ch'anọng p'ẹkhọma cha Bẹnjamin, atzori ka nnọmma sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","Wa ose kw'ottong afa ode kw'ekkema ch'anọng p'ẹkhọma cha Simeọn, atzori ka nnọmma sabẹ. Wa ekkema chabẹ ewobh k'ottem kw'ẹkhọma cha Juda. ");
INSERT INTO mfo_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","Wa ch'ẹttar: Beershẹba (kw'obiro okpena Sheba), ọmaana Molada, ");
INSERT INTO mfo_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","ọmaana Hazar-Shual, ọmaana Bala, ọmaana Ezem, ");
INSERT INTO mfo_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","ọmaana Eltolad, ọmaana Betul, ọmaana Họrma, ");
INSERT INTO mfo_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","ọmaana Ziklag, ọmaana Bet-Markabot, ọmaana Hazar-Susa, ");
INSERT INTO mfo_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","ọmaana Bet-Lebaot, ọmaana Sharuhen, kw'osi idedenmon jobh obhiri ittaan, ttara abhobhona pabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","Iwa obiro ode ibhon s'Ayin, ọmaana Rimọn, ọmaana Ẹtẹr, ọmaana Ashan, kw'osi idedenmon inna ttara abhobhona pabẹ, ");
INSERT INTO mfo_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","ọmaana abhobhona biphyir p'akhọri ibhon nna maa, apyiri Baalat-Beer (kw'ode Rama kw'okhubha kwa Nẹgẹv). Ma wọ iwa ode ekkema ch'anọng p'ẹkhọma cha Simeọn, atzori ka nnọmma sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","Wa ekkema ch'anọng p'ẹkhọma cha Simeọn, efon k'ekkema ch'anọng pa ẹkhọma cha Juda, okhuri da iwa ekkema ch'anọng pa Juda ebari ẹyọhnga k'odem kwa bẹ arori. Mando kw'iwa anọng p'ẹkhọma cha Simeọn atzọk ekkema chabẹ k'ottem kw'ẹkhọma cha Juda. ");
INSERT INTO mfo_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","Iwa ose kw'ottong attaan ode kw'ekkema ch'ẹkhọma cha Zebulun, atzori ka nnọmma sabẹ: Wa enem ch'ekkema chabẹ etzim maa, epyiri ka Sarid. ");
INSERT INTO mfo_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","Achin k'okhubha kw'ewuchen em-edimi, chẹ etzim maa, epyiri ka Marala ẹtza ẹkwọhkhi ka Dabeshet, etzima epyiri k'ittolim s'ibaang Jokneam. ");
INSERT INTO mfo_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","Wa chẹ ẹbhakhi k'okhubha kw'ewuchen em-eyin ka Sarid ekkeri ekpebha-kpikhira itzitzikha, k'okhubha kwa Kislọt-Tabor, etzima echina ka Daberat, yina en-evur echina ka Japhiya. ");
INSERT INTO mfo_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","Ebire etzima mẹ echina k'okhubha kw'ewuchen em-eyin ka Gat-Hepher, ọmaana Et-Kazin; yina en-eyini ka Rimọn ẹbhakhi echina ka Nea. ");
INSERT INTO mfo_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","Enem nda ẹkhọri echina k'ebir-ebira kwa Hanaton, etza ekponga k'Ittolim s'Iphta-Ẹl. ");
INSERT INTO mfo_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","Ibhon s'ittar mẹ ide Katat, ọmaana Nahalal, ọmaana Shimrọn, ọmaana Idala ttara Bẹtẹlẹhẹm, kw'osi idedenmon jobh obhiri ifa ọmaana abhobhona pabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","Iwa idedenmon nna ọmaana abhobhona pabẹ, bọ ade ekkema cha Zebulun, atzori ka nnọmma sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","Iwa ose kw'ottong anna ode kw'ekkema ch'anọng p'ẹkhọma ch'Isaaka, atzori ka nnọmma sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","Nnem sabẹ nttar: Jẹzrẹl, ọmaana Kesulọt, ọmaana Shunẹm, ");
INSERT INTO mfo_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","ọmaana Hapharayim, ọmaana Shiyọn, ọmaana Anaharat, ");
INSERT INTO mfo_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","ọmaana Rabit, ọmaana Kishiyọn, ọmaana Ebez, ");
INSERT INTO mfo_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","ọmaana Remet, ọmaana Ẹn-Ganim, ọmaana Ẹn-Hada ttara Bet-Pazez. ");
INSERT INTO mfo_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","Wa enem nda etzim ẹtza ẹkwọhkhi ka Tabọr, ọmaana Shahazuma ttara Bẹt-Shẹmẹsh, ẹtza ekponga ka Jọrdan, kw'osi idedenmon chi obhiri wani ttara abhobhona pabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","Iwa idedenmon nna ọmaana abhobhona pabẹ, bọ ade ekkema ch'anọng p'ẹkhọma ch'Isaaka, atzori ka nnọmma sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","Iwa ose kw'ottong azen ode kw'ekkema ch'anọng p'ẹkhọma ch'Ashẹr, atzori ka nnọmma sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","Wa okhubha kwabẹ ọttar: Helkat, ọmaana Hali, ọmaana Beten, ọmaana Akshaph, ");
INSERT INTO mfo_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","ọmaana Alamẹlẹk, ọmaana Amad ttara Mishal. Wa enem nda k'okhubha kw'ewuchen em-edimi, etzim ẹtza ẹkwọhkhi ka Karmẹl ọmaana ka Shihor-Libnat. ");
INSERT INTO mfo_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","Chẹ ẹtza ẹbhakhi k'okhubha kw'ewuchen em-eyin, da achin ka Bẹt-Dagọn, ẹtza ẹkwọhkhi ka Zebulun ọmaana k'Ittolim s'Iphta-Ẹl, etzima echina k'ebir-ebira kwa Bẹt-Emek ọmaana Neiyẹl, akwọbh Kabul ka kwabọhk. ");
INSERT INTO mfo_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","Etzima echina k'Abdọn, ọmaana Rehob, ọmaana Hamọn ttara Kana maa, epyiri ka Sidọn kw'ideden. ");
INSERT INTO mfo_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","Wa enem nda ebire ẹbhakhi ẹkpa nnam echina ka Rama, ebire etzima echina k'ọfha-bhon kwa Tyrẹ, ẹbhakhi echina ka Hosa ẹtza eyin k'Ọraanga kw'ideden kwa Mediteraneya k'ẹkhọma ch'Akzib ");
INSERT INTO mfo_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","ọmaana Uma, ọmaana Aphek ttara Rehob, kw'osi idedenmon ẹrọbh obhiri ifa ttara abhobhona pabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","Iwa idedenmon nna ọmaana abhobhona pabẹ, bọ ade ekkema ch'anọng ẹkhọma ch'Ashẹr, atzori ka nnọmma sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","Iwa ose kw'ottong azadani ode kw'ekkema ch'anọng p'ẹkhọma cha Naphtali, atzori ka nnọmma sabẹ: ");
INSERT INTO mfo_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","Iwa enem chabẹ ẹttẹwọr ka Heleph, ọmaana k'echi ch'ideden ka Zananim, akwọbh Adami-Nekeb, ọmaana Jabnẹl da achin ka Lakum, ẹtza ekponga ka Jọrdan. ");
INSERT INTO mfo_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","Wa enem nda etzim echina k'okhubha kw'ewuchen em-edimi k'Aznot-Tabor, ẹtza eyin ka Hukok. Wa ẹkwọhkhi k'ẹrakh-ẹrakha kwa Zebulun, ọmaana k'okhubha kw'ewuchen em-edimi k'Ashẹr, ttara k'okhubha kw'ewuchen em-eyin ka Jọrdan. ");
INSERT INTO mfo_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","Wa idedenmon sa bẹ atzim abaakha akhọri ide Zidim, ọmaana Zer, ọmaana Hamat, ọmaana Rakat, ọmaana Kineret, ");
INSERT INTO mfo_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","ọmaana Adama, ọmaana Rama, ọmaana Hazọr, ");
INSERT INTO mfo_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","ọmaana Kẹdẹsh, ọmaana Edreyi, ọmaana Ẹn-Hazọr, ");
INSERT INTO mfo_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","ọmaana Irọn, ọmaana Migdal-Ẹl, ọmaana Horẹm, ọmaana Bet-Anat ttara Bet-Shẹmẹsh, kw'osi idedenmon ọhawani kw'ẹrọbh, ọmaana abhobhona pabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","Iwa idedenmon nna ọmaana abhobhona pabẹ, bọ ade ekkema ch'anọng p'ẹkhọma cha Naphtali, atzori ka nnọmma sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","Iwa ose kw'ottong azenamfa ode kw'ekkema ch'anọng p'ẹkhọma cha Dan, atzori ka nnọmma sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","Ekkema chabẹ ẹttar: Zora, ọmaana Ẹshtaol, ọmaana Ir-Shemes, ");
INSERT INTO mfo_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","ọmaana Shalabin, ọmaana Aijalọn, ọmaana Itla, ");
INSERT INTO mfo_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","ọmaana Elọn, ọmaana Timna, ọmaana Ekrọn, ");
INSERT INTO mfo_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","ọmaana Elteke, ọmaana Gibeton, ọmaana Balat, ");
INSERT INTO mfo_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","ọmaana Jehud, ọmaana Bene-Berak, ọmaana Gat-Rimọn, ");
INSERT INTO mfo_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","ọmaana Me-Jarkon ttara Rakon, ttara k'okhubha kw'okkeri Jọpa. ");
INSERT INTO mfo_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","(K'ogbe kw'iwa attattaanga-nọng p'anọng pa Dan akk'bẹ irerek sabẹ abọkha ana, anọng pa Dan afona atza arima anọng pa Leshem abẹ. Bẹ atzima akkangkkaang afhu bẹ, atzọkha obhon kw'anọng pa Leshem aruk. Wa bẹ an-atzọkha obhon kwa Leshem akpẹ-ẹ abhina Dan, kw'ode che ch'otte kwabẹ kw'ideden). ");
INSERT INTO mfo_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","Iwa idedenmon nna ọmaana abhobhona pabẹ, bọ ade ekkema ch'anọng p'ẹkhọma cha Dan, atzori ka nnọmma sabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","K'ogbe kwa bẹ akk'ekkema ch'irerek nna ka ngọma sabẹ akyera, anọng p'Israẹl an-anang Joshua kw'ode nnwa kwa Nun ekkema chẹ k'ottem kwabẹ, ");
INSERT INTO mfo_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","mach'iwa Ọvaar Ibinọkpaabyi okk'obena. Wa bẹ anang-ẹ obhon kwa Timnat-Sera kw'ophyemi bẹ, k'okhubha kwa mgbegbeho s'Ephraim. Wa Joshua osi obhon mẹ, oruk. ");
INSERT INTO mfo_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","Ma wọ ode ibhon s'iwa Eleazar kw'ode ọfọhnẹja, ọmaana Joshua kw'ode nnwa kwa Nun ttara adeho pa ngọma s'Israẹl, areng k'ose atzọkha ka Shilo, k'itzitzikha s'Ọvaar Ibinọkpaabyi, k'ẹbaakhamma ch'ikhira s'etzobha ch'Ibinọkpaabyi. Iwa bẹ akyera irerek nna okkekkema. ");
INSERT INTO mfo_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","Iwa Ọvaar Ibinọkpaabyi oben Joshua bi: ");
INSERT INTO mfo_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","“Gbaak anọng p'Israẹl bi, bẹ atzekha ibhon s'ichubhabe mach'iwa nneng ka Mosẹs mgbaakh-ọ, ");
INSERT INTO mfo_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","ifha ọnọng manda wani ọn-ọkhami bi ofhu oyok, ọnọng k'ọgbaan kobiro ofhu, ọfha ọrọbh ebhon ọtza ochubha mẹ. ");
INSERT INTO mfo_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","Idikha bẹ arọbhi ebhon atza achubha k'obhon kpenamkpen m'ibhon nna, bẹ akhaambi abe m'ẹbaakhama ch'obhon agbaak adedennọng p'obhon nwa odik kwa bẹ aji. Adedennọng p'obhon nwa átzọkh-ẹ, ábira ánang-ẹ ibe s'óruk kabẹ k'obhon. ");
INSERT INTO mfo_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","Idikha otzukh-odik ọkhubhi ọnọng kw'ọrubhi ebhon bi ọfhẹ-ẹ, adedennọng p'obhon kakhaam bi atte ọnọng kw'ọrọbhi-ebhon ọbọhk anang-ẹ, okhuri bi, ọnọng kw'ọrubhi ebhon, oyokh-ibaanga kwẹ ọkhakham-kokhami, kẹ k'ọgbaan kobiro ofhu. ");
INSERT INTO mfo_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","Bẹ akhaambi, aruk m'odedenmon nwa maa, bẹ abe aponga pabẹ k'itzitzikha s'obhon, ọmaana bi, oho kw'afọhnẹja m'ogbe nwuma ọkk'ọpa. Mẹ wọ kwa bẹ afha akpa nnam abhana k'ihọhm sabẹ k'ibhon sa bẹ arọbhi.” ");
INSERT INTO mfo_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","Mẹ wọ ofon, bẹ atzekha Kadẹsh ka Galilee k'okhubha kwa mgbegbeho k'ẹkhọma cha Naphtali, ọmaana ka Shẹkẹm k'okhubha kwa mgbegbeho s'Ephraim ttara ka Kiriyat-Arba (kw'ode Hẹbrọn) k'okhubha kwa mgbegbeho sa Juda. ");
INSERT INTO mfo_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","K'okhubha kw'ewuchen em-eyin, ka Jọrdan (k'okhubha nwonggo kwa Jẹriko), bẹ atzekha Bezer k'ibe s'anọng an-arukhi k'egbegbeho k'ẹkhọma cha Reubẹn, ọmaana Ramọt ka Gilead k'ẹkhọma ch'anọng pa Gad, ttara Golan ka Bashan k'ẹkhọma ch'anọng pa Manasẹ. ");
INSERT INTO mfo_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","Ọnọng kpenamkpen kw'ofon Israẹl, obiro ode okhekhennọng kw'orukhi k'ottem kwabẹ, kw'on-ọnọng k'ọgbaan ofhu, ọfha ọrọbh ochina k'idedenmon nna sa bẹ akk'atzekha, ifha otzukh-odik oning-ẹ ofhu, yina obe aponga k'itzitzikha s'obhon. ");
INSERT INTO mfo_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","Iwa adeho pa nnọmma sa Lẹvi afona achina ka Shilo ka Kenaan, atza akhebha Eleazar kw'ode ọfọhnẹja ọmaana Joshua kw'ode nnwa kwa Nun ọmaana adeho pa mfonamma ndọdọk sa nnọmma s'Israẹl, ");
INSERT INTO mfo_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","aben bẹ bi, “Iwa Ọvaar Ibinọkpaabyi ọnangi Mosẹs ẹfa bi, kọ anang man ibhon sa moruk, ttara iwoni s'etzirakpo pyaman echi ọchattọhk.” ");
INSERT INTO mfo_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","Mẹ wọ ofon, iwa anọng p'Israẹl atzọkha ibhon nnani ọmaana iwoni rani anang anọng pa efonamma cha Lẹvi mach'ekkema chabẹ, atzor k'odem kw'iwa Ọvaar Ibinọkpaayi ọkk'ọgbaakha. ");
INSERT INTO mfo_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","Iwa ose kw'ochi eden, ode ekkema ch'anọng p'ẹnọmma cha Kohat, atzori ka nnọmma sabẹ. Wa bẹ anangi anọng pa Lẹvi p'iwa ade va pa va p'Aarọn kw'ode ọfọhnẹja, ibhon jobh obhiri ittaan k'ẹkhọma cha Juda, ọmaana cha Simeọn ttara cha Bẹnjamin. ");
INSERT INTO mfo_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","Iwa bẹ atzọkha ibhon jobh k'ẹkhọma ch'Ephraim ọmaana cha Dan ttara k'ibhaakha rani sa Manasẹ anang va pa va pa Kohat p'an-arikhi. ");
INSERT INTO mfo_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","Iwa bẹ atzọkha ibhon jobh obhiri ittaan ka nnọmma k'ẹkhọma ch'Isaaka ọmaana ch'Ashẹr ọmaana cha Naphtali ttara k'ibhaakha rani s'anọng pa Manasẹ ka Bashan, anang va pa va pa Gershon. ");
INSERT INTO mfo_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","Iwa va pa va pa Mẹrari, atzori ka nnọmma sabẹ, atzọkha ibhon jobh obhiri ifa k'ẹkhọma cha Reubẹn ọmaana cha Gad ttara cha Zẹbulun. ");
INSERT INTO mfo_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","Mando wọ kw'iwa anọng p'Israẹl atzọk ibhon nna ọmaana iwoni s'etzirakpo em-echi ọttọhk, anang anọng p'efọnamma cha Lẹvi, atzor k'odem kw'iwa Ọvaar Ibinọkpaabyi okk'orenga ka Mosẹs ọgbaak. ");
INSERT INTO mfo_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","Iwa bẹ anangi anọng p'ẹkhọma cha Juda ọmaana p'ẹkhọma cha Simeọn ibhon atzor ka che, ");
INSERT INTO mfo_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","(ma wọ ode ibhon s'iwa bẹ anangi va pa va p'Aarọn p'afon k'efonamma cha Kohat, okhuri da ode ekkema chabẹ dọ iwa echi eden): ");
INSERT INTO mfo_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","Iwa bẹ anangi bẹ Kiriyat-Arba (kw'ode Hẹbrọn), ọmaana iwoni s'iwobh ikhọr-ẹ, k'okhubha kwa mgbegbeho ka Juda. (Wa Arba wọ ode otte kw'ideden kw'Anak). ");
INSERT INTO mfo_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","Ode cha iwa bẹ akk'iwoni ọmaana abhobhona p'akhọri odedenmon atzọkha anang Kalẹb kw'ode nnwa kwa Jẹphunẹ, mach'ekkama chẹ. ");
INSERT INTO mfo_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","Iwa bẹ anang va pa va p'Aarọn kw'ode ọfọhnẹja obhon kwa Hẹbrọn (kw'ode odedenbhon kw'ichubhabe ọnang ọnọng kw'ọrọbhi ebhon), ọmaana obhon kwa Libna, ");
INSERT INTO mfo_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","ọmaana kw'Ẹshtemoa ");
INSERT INTO mfo_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","ọmaana Holon ọmaana Debir ");
INSERT INTO mfo_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","ọmaana Ayin ọmaana Juta ọmaana Bẹt-Shẹmẹsh akwu attara k'iwoni s'etzirakpo pyabẹ em-echi ọttọhk. Wa ibhon ọhawani rọ ifon ma ngọma nna mfa. ");
INSERT INTO mfo_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","Iwa bẹ anang bẹ ibhon k'ẹkhọma cha Bẹnjamin s'ide Gibeọn ọmaana Geba ");
INSERT INTO mfo_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","ọmaana Anatọt ọmaana Almọn akwu attara k'iwoni s'etzirakpo pyabẹ em-echi ọttọhk, osi ibhon inna. ");
INSERT INTO mfo_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","Biphyir-phyir ibon s'iwa bẹ anangi afọhnẹja, p'ade va pa va p'Aarọn ide jobh obhiri ittaan, attar iwoni s'etzirakpo pyabẹ em-echi ọttọhk. ");
INSERT INTO mfo_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","Iwa bẹ atzọkha ibhon k'ẹkhọma ch'Ephraim anang nnọmma s'anọng pa nnọmma sa Kohat p'anọng pa Lẹvi, p'an-arikhi: ");
INSERT INTO mfo_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","Iwa bẹ anangi bẹ Shẹkẹm k'okhubha kwa mgbegbeho k'Ephraim (kw'ode odedenmon kw'ichubhabe s'ọnọng kw'ọrọbhi ebhon) ọmaana obhon kwa Gezer ");
INSERT INTO mfo_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","ọmaana Kibzayim ọmaana Bẹt-Horọn, ttara iwoni s'etzirakpo pyabẹ em-echi ọttọhk, kw'osi ibhon inna. ");
INSERT INTO mfo_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","Iwa bẹ atzọkha ibhon inna k'ẹkhọma cha Dan s'ide Elteke, ọmaana Gibeton, ");
INSERT INTO mfo_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","ọmaana Aijalọn ọmaana Gat-Rimọn akwu attara k'iwoni s'etzirakpo pyabẹ em-echi ọttọhk. ");
INSERT INTO mfo_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","Iwa bẹ atzọkha ibhon ifa k'ibhaakha rani sa Manasẹ anang Taanak ọmaana Gat-Rimọn akwu attara k'iwoni s'etzirakpo pyabẹ em-echi ọttọhk. ");
INSERT INTO mfo_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","Iwa bẹ atzọk ibhon nna jobh ọmaana iwoni s'etzirakpo pyabẹ em-echi ọttọhk, anang nnọmma s'efonamma cha Kohat, p'an-arikhi. ");
INSERT INTO mfo_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","Wa bẹ anangi nnọmma sa Lẹvi s'anọng pa Gershọn: ttẹwọr k'ibhaakha rani s'anọng pa Manasẹ, ọmaana Golan ka Bashan (kw'ode odedenmon kw'ichubhabe s'ọnọng kw'ọrọbhi ebhon) ọmaana Bẹ-Ẹshtera, akwu attara k'iwoni s'etzirakpo pyabẹ em-echi ọttọhk, kw'osi ibhon ifa; ");
INSERT INTO mfo_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","k'ẹkhọma ch'Isaaka bẹ atzọkha ibhon sa Kishiyon, Daberat ");
INSERT INTO mfo_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","Jarmut ọmaana Ẹn-Ganim akwu attara k'iwoni s'etzirakpo pyabẹ em-echi ọttọhk, kw'osi ibhon inna; ");
INSERT INTO mfo_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","k'ẹkhọma ch'Ashẹr bẹ abhaangi ibhon ina s'ide Mishal, ọmaana Abdon ");
INSERT INTO mfo_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","ọmaana Helkat ttara Rehob, akwu attara k'iwoni s'etzirakpo pyabẹ em-echi ọttọhk, kw'osi ibhon inna. ");
INSERT INTO mfo_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","K'ẹkhọma cha Naphtali bẹ atzọkha Kadẹsh ka Galilee (kw'ode odedenmon kw'ichubhabe s'ọnọng kw'ọrọbhi ebhon), ọmaana Hamọt-Dọr ọmaana Kartan, akwu attara k'iwoni s'etzirakpo pyabẹ em-echi ọttọhk, kw'osi ibhon ittaan. ");
INSERT INTO mfo_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","Biphyir-phyir wa ibhon sa nnọmma sa Gẹrshọn ide ibhon jobh obhiri ittaan, akwu attara k'iwoni s'etzirakpo pyabẹ em-echi ọttọhk. ");
INSERT INTO mfo_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","Iwa bẹ anangi nnọmma sa efonamma cha Mẹrari (p'ade anọng pa Lẹvi p'arikhi): ttẹwọr k'ẹkhọma cha Zẹbulun, Jokneyam, Karta ");
INSERT INTO mfo_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","Dimna ọmaana Nahalal, akwa attara k'iwoni s'etzirakpo pyabẹ em-echi ọttọhk, kw'osi ibhon inna. ");
INSERT INTO mfo_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","K'ẹkhọma cha Reubẹn bẹ atzọkha ibhon inna s'ide, Bezer ọmaana Jahaz, ");
INSERT INTO mfo_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","ọmaana Kedemot ttara Mephaat, akwu attara k'iwoni s'etzirakpo pyabẹ em-echi ọttọhk, kw'osi ibhon inna; ");
INSERT INTO mfo_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","k'ẹkhọma cha Gad wa bẹ atzọkha ibhon inna s'ide Ramot-Gilead (kw'ode odedenmon kw'ichubhabe s'ọnọng kw'ọrọbhi ebhon) ọmaana Mahanayim, ");
INSERT INTO mfo_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","ọmaana Hẹshbọn ọmaana Jazer, akwu attara k'iwoni s'etzirakpo pyabẹ em-echi ọttọhk. ");
INSERT INTO mfo_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","Biphyir-phyir wa bẹ akkem ibhon jobh obhiri ifa anang nnọmma sa Mẹrari s'iwa nde anọng pa Lẹvi. ");
INSERT INTO mfo_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","Biphyir-phyir wa anọng pa Lẹvi akhaam ibhon arọbh afa obhiri izenanttaan k'ẹkhọma ch'iwa anọng p'Israẹl arukhi akwu attara k'iwoni s'etzirakpo pyabẹ em-echi ọttọhk. ");
INSERT INTO mfo_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","Iwa obhon kpenamkpen ọkhaam iwoni s'etzirakpo em-echi ọttọhk s'ikhọr-ẹ. Wa kwẹ ode mando m'ibhon nna biphyir. ");
INSERT INTO mfo_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","Mando wọ kw'iwa Ọvaar Ibinọkpaabyi ọnangi anọng p'Israẹl ẹkhọma nda biphyir ch'iwa okk'ochekhi ọnang ab'otte pabẹ. Wa bẹ atzọkha ẹkhọma nda mach'ekkema chabẹ, aruk. ");
INSERT INTO mfo_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","Wa Ọvaar Ibinọkpaabyi ọnang bẹ ẹwọhngkwokha k'eden kpenamkpen, mach'iwa okk'ochekhi ọnang ab'otte pabẹ. Wa ọttattaanga-nọng kwabẹ manda wani kw'ọfha obe bẹ abẹ kode; da iwa Ọvaar Ibinọkpaabyi otte attattaanganọng pabẹ biphyir ọbọhk ọnang bẹ. ");
INSERT INTO mfo_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","Wa nchekhi nkkakka biphyir s'Ọvaar Ibinọkpaabyi osi ọnang anọng p'Israẹl ngaama ẹjaakhi, manda dani ch'ẹkhaam echuna kede. ");
INSERT INTO mfo_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","Iwa Joshua oyeri anọng p'ẹkhọma cha Reubẹn, ọmaana cha Gad, ọmaana ibhaakha rani s'anọng pa Manasẹ otzobha, ");
INSERT INTO mfo_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","oben bẹ bi, “Bọng akk'idik biphyir sa Mosẹs kw'ode ọtzọhmnọng kw'Ọvaar Ibinọkpaabyi okk'bọng ọtzọhna, asa. Bọng akk'eho abira ahakha anang idik biphyir sa kaam nkk'bọng mgbaakha. ");
INSERT INTO mfo_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","Bọng ayokh-obhon p'Israẹl kabhumi m'ogbe nwa biphyir maa, apyiri k'ewu cha mayina. Bọng akk'ọtzọhm f'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọtzọhni bọng asa akyera. ");
INSERT INTO mfo_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","Ma, Ọvaar Ibinọkpaabyi okk'ayokh-obhon pabọng p'Israẹl odidiri ọnanga, mach'iwa ochekhi. Bọng na kpa nnam abhana kabọng k'ihọhm, k'ẹkhọma ch'iwa Mosẹs kw'ode ọtzọhmnọng kw'Ovaar Ibinọkpaabyi, okkem ọnang bọng k'okhubha kw'ewuchen em-eyin ka Jọrdan. ");
INSERT INTO mfo_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","Yina, bọng dọkha ogbe ahok asana ọmaana aphaangi p'iwa Mosẹs kw'ode ọtzọhmnọng kw'Ọvaar Ibinọkpaabyi ọnangi bọng. Tte Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọdaak bọng, bọng nnuk akpen atzor ka ndọhna sẹ, bọng ahakha eho anang asana pẹ, bọng aphe nnam ka kẹ, bọng akpobh-ẹ ttara nttem ọmaana agbagba pabọng biphyir!” ");
INSERT INTO mfo_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","Mẹ wọ ofon, wa Joshua osi bẹ ittabọhng, ọtzọhm bẹ akpa nnam abhana ka bẹ k'ihọhm. ");
INSERT INTO mfo_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","(Wa Mosẹs okk'ibhaakha rani s'anọng p'ẹkhọma cha Manasẹ, irerek ọnanga ka Bashan; wa Joshua ọnang ibhaakha nnonggo irerek k'okhubha kw'ewuchen em-edimi ka Jọrdan, ọbaanga ayokh-obhon pabẹ p'Israẹl). Wa Joshua osi bẹ ittabọhng mada ọtzọhmi bẹ akpa nnam abhana kabẹ k'ihọhm, ");
INSERT INTO mfo_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","oben bi, “Bọng dọkha ẹkhakhaama k'ọhaabh, ọmaana abhaam k'ọhaabh, ọmaana silva, ọmaana gol, ọmaana brọns, ọmaana mgbakha ttara ọbọra k'ọhaabh. Bọng kkema ọgbọm fa bọng achi k'attattaanga-nọng pabọng, anang votte pabọng.” ");
INSERT INTO mfo_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","Mẹ wọ ofon, anọng p'ẹkhọma cha Reubẹn, ọmaana cha Gad ttara ibhaakha rani sa Manasẹ, abina aji anọng p'Israẹl ka Shilo k'ékhọma cha Kenaan. Bẹ akpa nnam abhana k'irerek sabẹ ka Gilead, kw'ode irerek sa bẹ akk'atzọkha akhaama, atzor k'odem kw'Ọvaar Ibinọkpaabyi okk'orenga ka Mosẹs ọtzọhn bẹ. ");
INSERT INTO mfo_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","K'ogbe kwa bẹ apyiri ka Gẹlilọt ọbaanga ka Jọrdan k'ẹkhọma cha Kenaan, anọng p'ẹkhọma cha Reubẹn ọmaana cha Gad, ttara ibhaakha rani s'anọng pa Manasẹ asi ijafọhnibe s'ijibhi-ojibh, ma Jọrdan ọkhaan-ọkhaan. ");
INSERT INTO mfo_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","Mada anọng p'Israẹl abhaang bi, bẹ akk'ijafọhnibe asa k'enem ch'ẹkhọma cha Kenaan ka Gẹlilọt ọbaanga ka Jọrdan k'okhubha kw'anọng p'Israẹl, ");
INSERT INTO mfo_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","obhon kw'Israẹl biphyir atzobha ka Shilo bi, bẹ atza arima anọng mba abẹ. ");
INSERT INTO mfo_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","Mando kw'anọng p'Israẹl atzọhmi Phinehas kw'ode nnwa kw'Eleaza, kw'ode ọfọhnẹja kw'ẹkhọma cha Gilead ka Reubẹn, ọmaana Gad ttara ibhaakha rani s'anọng pa Manasẹ. ");
INSERT INTO mfo_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","Bẹ atzọhm adeho anọng jobh atzọn-ẹ abẹ. Wa ẹkhọma ch'Israẹl kpenamkpen ẹtzọhmi odeho wani, kw'ode oho kw'ẹhọhmmọr cha nnọmma s'anọng p'Israẹl. ");
INSERT INTO mfo_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","Mada bẹ atza ka Gilead ka Reubẹn, ọmaana ka Gad ttara ibhaakha rani s'anọng pa Manasẹ, bẹ aben bẹ bi: ");
INSERT INTO mfo_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","“Anọng biphyir p'ebhonmọr nda ch'Ọvaar Ibinọkpaabyi abeni bi: ‘Okhuri yan kwa bọng arẹkhi Ibinọkpaabyi kw'Israel manda o? Bọng an-asi yan akpa nnam abọra Ọvaar Ibinọkpaabyi, atza asi ijafọhnibe anang for sabọng atzima anang-ẹ oho-gaang o? ");
INSERT INTO mfo_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","Ode bi, wa ẹkhọngkwuri cha Poer man k'ebeng o? Man ephyok ch'ẹkhọngkwuri nduma ka for saman otzim ogbobhi maa, apyiri k'ewu cha mayina, chibhi da iwa itzama itto k'obhon kw'Ọvaar Ibinọkpaabyi! ");
INSERT INTO mfo_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","Bọng nnam kakpa abọra Ọvaar Ibinọkpaabyi madẹdẹn nwa e. “ ‘Idikha bọng anangi Ọvaar Ibinọkpaabyi oho-gaangi mayina, ophyini, kẹ ọdọkhi ettem otzima otzor ebhonmọr ch'Israẹl biphyir. ");
INSERT INTO mfo_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","Idikha irerek sa bọng arukhi in-ijibhi, bọng jekha k'irerek s'Ọvaar Ibinọkpaabyi, kẹ da irukhabe s'Ọvaar Ibinọkpaabyi iwobh, akwu aruk ka ttara man. Yina, bọng eho kàgaangi atzima atzor Ọvaar Ibinọkpaabyi ọmaana maman o bi, bọng an-asi ijafọhnibe idọdọk anang for sabọng, oyongi ijafọhnibe s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwaman o. ");
INSERT INTO mfo_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","Mada iwa Akan kw'ode nnwa kwa Zera ọkhaam ottotto, okhuri ẹtzọhmkpo py'Ibinọkpaabyi, wa ebhonmọr ch'Israẹl makhọra ettuma kẹtzọkh o? Wa kẹ mancheni arang ope k'ẹkhọngkwuri chẹ e.’ ” ");
INSERT INTO mfo_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","Mẹ wọ osi, ẹkhọma cha Reubẹn ọmaana cha Gad, ttara ibhaakha rani s'anọng pa Manasẹ, abhina adeho pa nnọmma s'Israẹl bi, ");
INSERT INTO mfo_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","“Ibinọkpaabyi kw'Ọyọhng, kw'ode Ọvaar Ibinọkpaabyi! Ibinọkpaabyi kw'Ọyọhng, kw'ode Ọvaar Ibinọkpaabyi! Kẹ wọ orong f'osi! Tte anọng p'Israẹl abira aronga! Idikha odik nwa ode oho-gaangi, obiro ode irẹrẹkhi ọnang Ọvaar Ibinọkpaabyi, bọng man ọbọhk kàtte moruk akpen. ");
INSERT INTO mfo_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","Idikha mokk'ijafọhnibe ọsa ọnang for saman bi motzima mẹ ọkpa nnam ọbọra Ọvaar Ibinọkpaabyi, ọmaana bi, mosi nnanga nkwọmisẹ ttara nnanga s'abọkpa, obiro ode bi, mọfọhni ẹja cha nnanga s'odidiri m'ibe nna, tte Ọvaar Ibinọkpaabyi ọkhaam ma for sẹ, ọnaang man ettuma ch'ẹdaakh-ẹ. ");
INSERT INTO mfo_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","“Mma e, mosi ijafọhnibe nna ttara nttak bi, ikhina ewu dani va pa va pabọng, aben va pa va paman oben bi, ‘Bọng ofor-gbakha kwa bọng akhaam ttara Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'Israẹl o? ");
INSERT INTO mfo_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","Ọvaar Ibinọkpaabyi ọkk'ọsa bi, Jọrdan ode enem cha maman ttara bọbọng anọng p'ẹkhọma cha Reubẹn, ọmaana ch'anọng p'ẹkhọma cha Gad! Bọng ekkema k'Ọvaar Ibinọkpaabyi kakhaam.’ Ofona mẹ, va pa va pabọng afha asi va pa va paman aningi ojora f'Ọvaar Ibinọkpaabyi, dọk akhaam. ");
INSERT INTO mfo_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","“Kẹ wọ osi moben bi, ‘Tte modo for osi ijafọhnibe e. Yina, man ijafọhnibe sa nnanga nkwọmisẹ, obiro ode sa njafọhni kosi.’ ");
INSERT INTO mfo_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","K'eden ndonggo, ijafọhnibe nna ide macha nttẹsẹ k'ottem kwa maman ttara bọbọng, ọmaana igbọ s'íkwu k'ororo bi, motzima nnanga kwọmisẹ saman, ọmaana njafọhni ttara nnanga s'odiriri, mokpobha Ọvaar Ibinọkpaabyi k'irukhabe sẹ. Mẹ wọ osi, va pa va pabọng, bẹ va pa va paman káben bi, ‘Bọng ekkema k'Ọvaar Ibinọkpaabyi, kakhaam. ");
INSERT INTO mfo_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","Iwa moben bi, ‘Idikha ewu dani bẹ abeni man, obiro ode bi, bẹ abeni va pa va paman, móbhina bi: Bọng kkeri ngeri s'ijafọhnibe s'Ọvaar Ibinọkpaabyi ma, s'iwa abotte paman asi. Wa bẹ sẹ kasi bi, bẹ am-asi nnanga nkwọhmisẹ mẹ, kaambi njafọhni rọ. Yina, wa bẹ asi sẹ bi, ide nttẹsẹ k'ottem kwa maman ttara bọng.’ ");
INSERT INTO mfo_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","Tzọtzọmi okponga k'idachen bi, mọnang Ọvaar Ibinọkpaabyi oho-gaangi, mobiro ọkpa nnam ọbọr-ẹ k'ewu cha mayina bi, mosi ijafọhnibe sa nnanga nkwọmisẹ ọmaana nnanga s'abọkpa ttara njafọhni, oyongi ijafọhnibe s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwaman s'ibe k'itzitzikha s'irukhabe s'Ọvaar Ibinọkpaabyi.” ");
INSERT INTO mfo_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","Mada Phinehas kw'ode ọfọhnẹja ọmaana adeho p'obhon p'ade; aho pa nnọmma s'anọng p'Israẹl abhaang atzim p'anọng p'ẹkhọma cha Reuben, ọmaana pa Gad ttara p'anọng pa Manasẹ agbaakhi, ettem ẹdaam bẹ. ");
INSERT INTO mfo_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","Wa Phinehas kw'ode nnwa kw'Eleaza, kw'ode ọfọhnẹja oben anọng p'ẹkhọma cha Reuben, ọmaana pa Gad ttara pa Manasẹ bi, “Mokk'oronga mayina bi, Ọvaar Ibinọkpaabyi owobh ma ttara man, okhuri da bọng ani Ọvaar Ibinọkpaabyi irẹrẹkhi ahọk m'odik nwa. Bọng akk'anọng p'Israẹl akkaana arọbha ka mbọkh s'Ọvaar Ibinọkpaabyi e.” ");
INSERT INTO mfo_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","Iwa Phinehas kw'ọde nnwa kw'Eleazar, kw'ọde ọfọhnẹja ọmaana adeho mba, abina k'ewobha cha bẹ akk'akhaama ttara anọng p'ẹkhọma cha Reuben ọmaana pa Gad ka Gilead, atza agbaak anọng p'Israẹl odik kwa bẹ abhaang. ");
INSERT INTO mfo_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","Iwa odik nwa kwa bẹ abhaang ọdaam anọng mba ettem, bẹ an-arima Ibinọkpaabyi. Mẹ wọ ofon, wa bẹ odik okhuri egbong cha bẹ atzima adimi ẹkhọma nda ch'anọng pa Reubẹn ọmaana pa Gad arukhi, dọk kagbaakhi. ");
INSERT INTO mfo_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","Iwa ẹkhọma ch'anọng pa Reubẹn ọmaana pa Gad anang ijafọhnibe nna che nda: Nttẹsẹ kw'owobh k'ottem kwaman ode bi, Ọvaar Ibinọkpaabyi, wọ ode Ibinọkpaabyi kwaman. ");
INSERT INTO mfo_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","K'ogbe-bhirada kw'Ọvaar Ibinọkpaabyi ọkk'anọng p'Israẹl ẹmẹm ọnanga k'attattaanga-nọng pabẹ biphyir, wa Joshua kw'ọkk'ọtzama kpọng, ");
INSERT INTO mfo_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","oyeri anọng p'Israẹl biphyir, adedennọng, ọmaana adeho, ọmaana asi-aponga ttara akhaan-nọng, ọben bẹ bi, “Kaam nkk'ndama kpọng e. ");
INSERT INTO mfo_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","Bọbọng ọkhaam akk'idik kpenamkpen ara s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọkk'ọsa ka nho sabọng; iwa Ọvaar Ibinọkpaabyi wọ orim ẹrima ka nho sabọng. ");
INSERT INTO mfo_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","Bọng jima odem kwa kaam nkk'irerek s'ẹkhọma ch'idibhon s'irikhi, s'ide idibhon sa kaam ngem k'ottem kwa Jọrdan ọmaana Ọraanga kw'ideden kwa Mẹditeraneya k'okhubha kw'ewuchen em-edimi, nkkema nnang ngọma sabọng mach'ekkema chabẹ. ");
INSERT INTO mfo_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","Ọvaar Ibinọkpaabyi ma for sẹ, kw'ode Ibinọkpaabyi kwabọng wọ orenga bọbọng abẹbẹ, ókhubh anọng mba. Kẹ ókhubh bẹ kabọng k'itzitzikha. Bọng ábira átzọkha irerek sabẹ akhaama mach'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, ochekhi ọnang bọng. ");
INSERT INTO mfo_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","“Bọng gaangi for; bọng atzọkha ogbe ahakha eho anang atzim kpenamkpen pa bẹ akk'akkẹra ka Nnwẹr kwa Aphaangi pa Mosẹs, bọng nnam kakpa abọra bẹ k'odimbọhk ttara ka kwabọhk. ");
INSERT INTO mfo_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","Bọng for kàbhuna ttara idibhon nna s'irikhi k'ottem kwabọng. Bọng che p'akha pabẹ kàyeri, bọng che pabẹ kàtzima asi echekhi. Bọng kakhaambi akpobha bẹ, bọng kakhaambi abira arakha eho anang bẹ. ");
INSERT INTO mfo_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","Yina, bọng akhaambi abọkha Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng atzima, macha bọng am-asi ma. ");
INSERT INTO mfo_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","“Ọvaar Ibinọkpaabyi okk'idibhon s'igaangi-ọgaangi ibiri ikhaama ẹfa okhubha kabọng k'itzitzikha, ọnọng kw'ọfha obe bọng abẹ maa, apyiri ma kode. ");
INSERT INTO mfo_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","Ọnọng wani om-okhubh anọng nnọhna mfa obhiri arọbh jobh, okhuri da Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng orim erima chabọng, mach'iwa okk'ochekhi. ");
INSERT INTO mfo_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","Mẹ wọ osi, bọng hakha for atzọkha ogbe bi, Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng ọdaak bọng. ");
INSERT INTO mfo_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","“Yina, idikha bọng an-abhakhi atza attara anọng p'idibhon nna p'arukhi akpen abira arik k'ottem kwabọng, bọng aba bẹ abira arenga iyok ttara bẹ, ");
INSERT INTO mfo_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","mẹ kwa bọng atzima aronga bi Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, idibhon nna dọk kokhubh kabọng k'itzitzikha. Yina, bẹ án-ade agbagbara, ọmaana amma amunapẹ anang bọng. Bẹ abira áde mach'achiva p'aphyori bọng ka nnam, ttara mach'ere ka bọng ka chen maa, bọng adimi m'irerek nna ọkkakka s'Ọvaar Ibinọkpaabyi okk'bọng ọnanga. ");
INSERT INTO mfo_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“Kaam ebowu chaam em-efor. Bọng arong ka nttem sabọng ttara k'agbagba pabọng kẹ bi, nchekhi nkkakka s'Ọvaar Ibinọkpaabyi biphyir ngaama ẹjaakhi, manda dani ch'ẹkhaam echuna kede. ");
INSERT INTO mfo_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","Yina, odem nwa kw'idik ọkkakka biphyir s'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng okk'ochekhi ọnang bọng ikhaam ẹjaakhi, mando wọ kw'obiro ọtzọhm itzama s'ọkk'ọkhama maa, kẹ Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng, odimi bọng k'irerek ọkkakka nna s'okk'bọng ọnanga. ");
INSERT INTO mfo_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","Idikha bọng atto k'echekhi ch'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwabọng okk'bọng ọnanga, bọng afona atza akpobha ekpo ẹdọdọk, bọng abira ahakha eho anang pyẹ, Ọvaar Ibinọkpaabyi, ódókhi ettem otzima otzor bọng, kẹ obiro odimi bọng m'ẹbhar-ẹbhar, m'irekirek ọkkakka nna s'okk'bọng ọnanga.” ");
INSERT INTO mfo_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Iwa Joshua oyeri ngọma s'Israẹl biphyir otzobha ka Shẹkẹm. Wa obiro oyeri adedennọng, ọmaana adeho, ọmaana asi-aponga ttara akhaan-nọng p'Israẹl, bẹ atza ayin Ọvaar Ibinọkpaabyi k'itzitzikha. ");
INSERT INTO mfo_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Wa Joshua oben anọng mba biphyir bi, “Ma wọ ode odik kw'Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'Israẹl ọgbaakhi bi: ‘Iwa ab'atte pabọng attar Tẹra kw'ode otte kw'Abraham ọmaana Nahor, arukhi k'okhubha kw'Ọraanga kw'Euphrates am-akpobha ikha. ");
INSERT INTO mfo_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Yina, wa kaam ndọkha Abraham kw'ode otte kwabọng, k'okhubha kw'Euphrates ndim-ẹ nchina k'ẹkhọma cha Kenaan. Nnang-ẹ va ọmaana va pa va k'ọhaabh. Nnang-ẹ Isaak, ");
INSERT INTO mfo_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","mbiri nnang Isaak, Jekọb ttara Ẹsau. Wa nnang Ẹsau okhubha kwa mgbegbeho ka Seir. Yina, wa Jekọb ọmaana ẹhọhmmọr chẹ afona achina k'Ijip. ");
INSERT INTO mfo_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","“ ‘Mẹ wọ ofon, wa ndọhm Mọses omanna Aarọn kẹ, nnenga k'idik sa nsi nnang anọng p'Ijip ọmmamma, yina, nnang bọbọng ẹkkaana. ");
INSERT INTO mfo_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","K'ogbe kw'iwa ndim anọng pọ mbina k'Ijip, bọng akwu apyiri k'ọraanga kw'ideden, wa anọng p'Ijip atzima akpaar pa nnyanyaang mmindọr ọmaana ayaari-nnyanyaang, akhubh bẹ maa, apyiri k'Ẹraanga-khora. ");
INSERT INTO mfo_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Yina, wa bẹ abhom ẹkkaana anang Ọvaar Ibiọnkpaabyi, wa ọtzọhm ipyerungi k'ottem kwabọng ttara anọng p'Ijip. Otzima asi p'ọraanga kw'ideden obubha bẹ. Wa bọng atzim chen pabọng are odem kw'iwa nsi anọng p'Ijip. Wa bọng aruk k'ibe s'anọng an-arukhi k'ogbe-bhirada. ");
INSERT INTO mfo_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","“ ‘Iwa ndima bọng mpyiri k'irerek s'anọng p'Amọr, p'arukhi k'okhubha kw'ewuchen em-eyin, ka Jọrdan. Wa bẹ arima bọng abẹ, yina, wa kaam ngema bẹ nnang bọng. Wa ndimi bẹ m'itzitzikha sabọng, bọng atzọkha irerek sabẹ akhaama. ");
INSERT INTO mfo_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Kọgbe kwa Balak kw'ode nnwa kwa Zipor, kw'ode Ọvaarnọng kwa Moab, odo for bi orima anọng p'Israẹl abẹ, kẹ ọtzọhm Balaam kw'ode nwa kwa Beor bi, ọtza ọnang bọng ẹmma. ");
INSERT INTO mfo_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Yina, wa kaam Balaam itzọhng kinyong. Mẹ wọ ofon, wa Balaam on-odo bọng igbe k'ẹkhaan. Wa nkkaana nnọbha bọng ka mbọhk sẹ. ");
INSERT INTO mfo_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","“ ‘Iwa bọng ajekha Ọraanga kwa Jọrdan, achina ka Jeriko. Wa anọng pa Jeriko arima bọng abẹ, mach'iwa anọng p'Amọr asi, ọmaana anọng pa Pẹriz, ọmaana pa Kenaan, ọmaana pa Het, ọmaana pa Girgash, ọmaana pa Hiv ttara pa Jẹbus. Yina, wa ngema bẹ nnang bọng. ");
INSERT INTO mfo_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Wa kaam nchi eden ndọhm abhingi-nho, p'akhubhi bẹ, ttara avaarnọng p'Amọr afa k'itzitziha sabọng. Wa bọng akkangkkaang ọmaana ayuk katzim akhema erima nda. ");
INSERT INTO mfo_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Wa kaam nnangi bọng irekrek sa bọng ani ikhem arẹ, ọmaana idedenmon sa bọng ani asi. Yina, bọng aruk mẹ, abira achi achiduk pa grep ọmaana p'oliv, pa bọng ani agboni.’ ");
INSERT INTO mfo_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","“Mẹ wọ, bọng gaama ojora f'Ọvaar Ibinọkpaabyi, bọng abira akpobh-ẹ ttara nnam-ophephe biphyir. Bọng mmari ikha s'iwa ab'atte pabọng akpobh k'okhubha kw'Ọraanga kw'Euphrates ọmaana k'Ijip. Bọng an-akpobha Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Yina, idikha bọng achibhi bi, Ọvaar Ibinọkpaabyi bọng ẹja kochi bi, bọng akpobha, bọng si ochibhi k'ewu cha mayina atzekha ọttọhk fa bọng akpobha, s'ode ikha s'iwa ab'atte akpobh k'okhubha kw'Ọraanga kw'Euphrates, obiro ode ikha s'anọng p'Amọr kwa bọng arukhi k'irerek sabẹ o. Onode kaam ọmaana ẹhọmmọr chaam, mókpobha Ọvaar Ibinọkpaabyi e.” ");
INSERT INTO mfo_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Mẹ wọ ofon, anọng mba abhina bi, “Tzọmi-tzọmi okponga k'idachen bi, maman ọkpa nnam ọbọra Ọvaar Ibinọkpaabyi, motza okpobha ikha. ");
INSERT INTO mfo_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Iwa Ọvaar Ibinọkpaabyi ọkhaam, kw'ode Ibinọkpaabyi kwaman, wọ otzim man ọmaana ab'otte paman obina k'Ijip, k'irerek nnuma s'ebira, obiro osi ikkokkonidik-barada k'itzitzikha saman. Wa okkeri man k'orenga kwaman biphyir, obiro ọbaabha man k'ottem kw'idibhon s'am-om-orenga ọkwọbha k'eden. ");
INSERT INTO mfo_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Iwa Ọvaar Ibinọkpaabyi okhubh idibhon biphyir k'tzitzikha saman, attar anọng p'Amọr p'iwa arukhi m'ẹkhọma nda. Maman obiro ókpobha Ọvaar Ibinọkpaabyi okpobha, okhuri bi, kẹ wọ ode Ibinọkpaabyi kwaman.” ");
INSERT INTO mfo_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Jọshua oben anọng mba bi, “Bọng Ọvaar Ibinọkpaabyi kafha akpobha e. Kẹ ode Ibinọkpaabyi kw'owur-owur; kẹ ode Ibinọkpaabyi kw'anọng am-amẹ-ẹ ettem. Bọng kóbina ọnang k'oho-gaangi kwabọng ọmana k'ẹkhọngkwuri cha bọng. ");
INSERT INTO mfo_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Idikha bọng akpa nnam abọra Ọvaar Ibinọkpaabyi, an-akpobha ikha s'ikhekhenmon, kẹ ọ́bhakhi ọnang bọng ọmmamma, obiro odimi bọng emeni, chibhi da iwa okk'idik ojibha ttara bọng.” ");
INSERT INTO mfo_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Yina, anọng mba abhina Joshua bi, “Mma e! Maman ókpobha Ọvaar Ibinọkpaabyi.” ");
INSERT INTO mfo_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Jọshua oben bi, “Bọng ade nttẹsẹ pa bọng ọkhaam ka for bi, bọng asi achibhi bi, akpobha Ọvaar Ibinọkpaabyi e.” Anọng mba abhina bi, “O o, maman ode nttẹsẹ pa man ọkhaam e.” ");
INSERT INTO mfo_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Joshua oben bi, “Bọng mmari ikha s'ikhehenmon s'iwobh ka bọng k'ottem, bọng atzọkha nttem sabọng anang Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kw'Israel.” ");
INSERT INTO mfo_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Iwa anọng mba abhina Joshua bi, “Maman ókpobha Ọvaar Ibinọkpaabyi, kw'ode Ibinọkpaabyi kwaman, mobiro ọhakha eho ọnang-ẹ.” ");
INSERT INTO mfo_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","M'ewu nduma, Joshua osi echekhi ọnang anọng mba, obiro ochenga aphaangi ọmaana asana, ọnang bẹ ka Shẹkẹm. ");
INSERT INTO mfo_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Iwa Joshua ọtzọkha idik nna ọkkẹr ka Nnwẹr kw'Aphaangi p'Ọvaar Ibinọkpaabyi. Wa ọtzọkha ọtza kw'ideden ohok k'irekhirek kw'echi cha oak ọbaanga ibe s'iwur-owur s'Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Joshua oben anọng mba biphyir bi, “Bọng kkeri! Ọtza nwa wọ óde nttẹsẹ kw'ọ́ttaanga ọnang man. Okk'idik biphyir ọbhanga s'Ọvaar Ibinọkpaabyi ọkk'ọgbaakha ọnang man. Óde nttẹsẹ kw'ọ́ttaanga ọnang bọng, idikha bọng abhumi Ibinọkpaabyi kwabọng.” ");
INSERT INTO mfo_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Mando kwa Joshua ọgbakhi ewobha nda, ọnọng kpenamkpen ọbhana ochina k'ekkema ch'obhon kwẹ. ");
INSERT INTO mfo_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","K'ogbe kw'idik nna ikk'itta ikwọbha, Joshua kw'ode nnwa kwa Nun, obiro ode ọtzọhmnọng kw'Ọvaar Ibinọkpaabyi, ope da ode cho arọbh azen obhiri jobh. ");
INSERT INTO mfo_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Wa bẹ anọhng-ẹ k'irerek s'ide ekkema chẹ, ka Timnat-Sẹra k'okhubha kwa mgbegbeho s'Ephraim, k'ebira-ebira kw'egbegbeho cha Gaash. ");
INSERT INTO mfo_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","K'ogbe kw'iwa Joshua orukhi akpen biphyir, ọmaana k'ogbe kw'iwa adeho p'iwa arukhi akpen da Joshua ọkk'ọpa, bẹ abira are odik kpenamkpen kw'iwa Ọvaar Ibinọkpaabyi ọkk'ọsa ọnang anọng p'Israẹl, wa anọng p'Israẹl akpobha Ọvaar Ibinọkpaabyi. ");
INSERT INTO mfo_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Iwa bẹ anọhng akkhọbhi pa Josẹph pa bẹ atzim abina k'Ijip, ka Shẹkẹm k'irerek sa Jekọb odebhi ka silva arọbh azen ka mbọhk sa nnwa kwa Hamọr, kw'ode otte kwa Shẹkẹm. Wa ibe nna in-ide ekkema cha va pa va pa Josẹph. ");
INSERT INTO mfo_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Iwa Eleaza kw'ode nnwa kw'Aarọn ope, bẹ anọhng-ẹ ka Gibea, kw'iwa ode ekkema cha bẹ anangi nnwa kwẹ Phinehas k'okhubha kwa mgbegbeho s'Ephraim.");
INSERT INTO mfo_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","K'ogbe kw'iwa Joshua ọkk'ọpa, anọng p'Israẹl abọbh Ọvaar Ibinọkpaabyi bi, “Bọng ẹkhọma chaman dọ échi eden ẹtza erima anọng pa Kenaan abẹ o?” ");
INSERT INTO mfo_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","Iwa Ọvaar Ibinọkpaabyi obhina bi, “Ẹkhọma cha Juda dọ échi eden; kaam nkk'irerek na ndọkha nge ka mbọhk sabẹ.” ");
INSERT INTO mfo_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","Mẹ wọ ofon, anọng p'ẹkhọma cha Juda aben anọng p'ẹkhọma cha Simeọn p'ade ayokh-obhon pabẹ p'Israẹl bi, “Bọng kwu tzọn man abẹ, mochina k'ẹkhọma cha bẹ akkem anang man, ifha mọtza orima anọng pa Kenaan abẹ. Maman óbiro ọ́tzọn bọng abẹ ochina k'okhubha kwa bọng.” Mando kw'anọng pa Simeọn atzọni bẹ abẹ. ");
INSERT INTO mfo_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","Mando kw'anọng pa Juda atza arim egbong nda. Ọvaar Ibinọkpaabyi osi anọng pa Juda akhema anọng pa Kenaan ọmaana anọng pa Pẹriz. Wa bẹ afhu anọng nnọhna ẹrọbh obhiri nzen ka Bẹzẹk. ");
INSERT INTO mfo_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","Mẹ wọ kw'iwa bẹ are Adoni-Bẹzẹk kw'ode ọvaarnọng kwa Bẹzẹk abira arim-ẹ abẹ, bẹ abira akhema anọng pa Kenaan ọmaana anọng pa Pẹriz. ");
INSERT INTO mfo_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","Wa Adoni-Bẹzẹk ọrọbh. Bẹ akhubh-ẹ abira abọkh-ẹ, bẹ akpaar-ẹ nnọnna-dim sa mbọhk ọmaana sa mmo. ");
INSERT INTO mfo_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","Mẹ wọ ofon, Adoni-Bẹzẹk oben bi, “Avaarnọng arọbh attaan obhiri jobh pa bẹ akpaar nnọnna-dim sa mbọhk ọmaana sa mmo, akk'abiribiri p'ẹchakpo adungi k'okpokkoro kwaam irekhirek. Ma, Ibinọkpaabyi ọkk'aam ọsa mach'iwa nsi bẹ.” Wa bẹ atzin-ẹ atzima achina ka Jẹrusalẹm, ọtza ope kẹ. ");
INSERT INTO mfo_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","Iwa ajinọng p'ẹkhọma cha Juda abira arima anọng pa Jẹrusalẹm abẹ, akhema bẹ. Wa bẹ atzima ọkkaangkkaang afhu anọng p'odedenmon nwa, bẹ abira akhe obhon ekpon. ");
INSERT INTO mfo_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","Ayongi mẹ, anọng p'ẹkhọma cha Juda ahakha atza arima anọng pa Kenaan abẹ, p'arukhi k'okhubha kwa mgbegbeho ka Nẹgẹv ọmaana k'okhubha kwa mgbegbeho sa ndẹr-ọtzẹri, k'okhubha kw'ewuchen em-eyin. ");
INSERT INTO mfo_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","Wa anọng pa Juda atza arima anọng pa Kenaan p'arukhi ka Hẹbrọn (kw'iwa okpen Kiriyat-Arba). Bẹ abira akhema Shẹshayi ọmaana Ahiman ttara Talmayi. ");
INSERT INTO mfo_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","Bẹ afona mẹ atza arima anọng p'arukhi ka Dẹbir (kw'iwa okpen Kiriyat-Sẹphẹr). ");
INSERT INTO mfo_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","Iwa Kalẹb oben bi, “Ojinọng kpenamkpen kw'orim Kiriyat-Sẹphẹr abẹ, obiro okhem-ẹ, kaam ńnang-ẹ Aksa kw'ode ominanwa kwaam k'ọbada.” ");
INSERT INTO mfo_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","Wa Otniyẹl kw'ode nnwa kw'ijinọng kwa Kẹnaz, kw'iwa ode ọgbaanotte kw'ikhakhari kwa Kalẹb, okhema obhon nwa. Mando kwa Kalẹb ọtzọk ominanwa kwẹ Aksa ọnang-ẹ k'ọbada. ");
INSERT INTO mfo_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","Iwa ewu dani, Aksa okwu okhebha Otniyẹl, ọchọhma Otniyẹl bi ọtza ophyem otte kwa kẹ Aksa irerek. Mada Aksa ọhak k'ẹnyanyaang chẹ, Kalẹb ọbọbh-ẹ bi, “Mbọng f'áror bi nsi nnang-ọ o?” ");
INSERT INTO mfo_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","Mẹ wọ ofon, Aksa obhina bi, “Kọ si-m ittabọhng. Mada akk'aam irerek ananga ka Nẹgẹv, kọ biri nnang-m akhekhaho.” Mando kwa Kalẹb ọnang-ẹ akhekhaho p'ebira-ebira ọmaana p'ẹrakha-ẹrakha. ");
INSERT INTO mfo_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","Iwa va pa va pa Ken kw'ode otte kwa kwanọng kwa Mosẹs, ttara anọng pa Juda abina k'Odedenmon kw'Aji, atza aruk k'ottem kw'anọng p'arukhi k'ebherede cha Juda, ka Nẹgẹv ọbaanga Arad. ");
INSERT INTO mfo_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","Iwa ajinọng p'ẹkhọma cha Juda atzọn anọng p'ẹkhọma cha Simeọn p'ade ayokh-ibhon p'Israẹl, bẹ atza arima anọng pa Kenaan p'arukhi ka Zephat abẹ. Bẹ adimi obhon kwa Zephat biphyir-phyir. Mẹ wọ ofon, bẹ an-ayeri obhon nwa Horma. ");
INSERT INTO mfo_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","Wa anọng pa Juda abira akhema ibhon sa Gaza ọmaana Ashkẹlọn ttara Ẹkrọn. Wa bẹ abọk odedenmon kpenamkpen ttara enem chẹ. ");
INSERT INTO mfo_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","Iwa Ọvaar Ibinọkpaabyi owobh ttara ajinọng p'ẹkhọma cha Juda. Bẹ akhema okhubha kwa mgbegbeho, yina, wa bẹ anọng p'arukhi k'ittolim kafha akhubh, da iwa bẹ akhaam akpaar pa nnyanyaang mmindọr p'ade akkonga-akkonga. ");
INSERT INTO mfo_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","Wa bẹ atzọkha Hẹbrọn anang Kalẹb, kw'okhubhi va pa va p'ijinọng attaan p'Anak, mach'iwa Mosẹs okk'ochekhi. ");
INSERT INTO mfo_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","Wa anọng p'ẹkhọma cha Bẹnjamin, anọng pa Jẹbus p'arukhi ka Jẹrusalẹm kakhubhi; anọng pa Jẹbus atzim arukhi k'ottem kwa anọng pa Bẹnjamin maa, apyiri k'ewu cha mayina. ");
INSERT INTO mfo_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","Ọvaar Ibinọkpaabyi owobh ttara ẹkhọma cha Josẹph, bẹ atza arima obhon kwa Bẹtẹl abẹ. ");
INSERT INTO mfo_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","Mada bẹ atzọhmi nttọ s'ẹhọhmmọr cha Josẹph ka Bẹtẹl (kw'iwa okpen Luz). ");
INSERT INTO mfo_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","Nttọ nna nne ojinọng wani kw'om-ofona k'odedenmon oyin ka, bẹ aben-ẹ bi, “Kọ tzibh man eden cha mórenga odim k'obhon ẹtzaanga, maman óbiro ore kwẹ ore bi, mosi ejibha osi ọnang-ọ.” ");
INSERT INTO mfo_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","Mẹ wọ ofon, wa ojinọng nwa otzibh bẹ eden, bẹ atzima ọkkangkkaang afhu anọng p'odedenmon. Yina, wa bẹ ojinọng nwa ọmaana ẹhọhmmọr chẹ kafhu. ");
INSERT INTO mfo_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","Wa on-ochina k'irerek s'anọng pa Het osi odedenmon mẹ, oyer-ẹ Luz, kw'on-ode che ch'ibe nna maa, apyiri k'ewu cha mayina. ");
INSERT INTO mfo_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","Yina, wa anọng p'ẹkhọma cha Manasẹ, anọng pa Bet-Shan ọmaana pa Taanak ọmaana pa Dor ọmaana pa Ibleam ọmaana pa Mẹgido ọttaara abhobhona pabẹ biphyir kakhubhi, da iwa ofon anọng pa Kenaan ka nttem bi, bẹ aruk ka ngọma nna. ");
INSERT INTO mfo_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","K'ogbe kw'iwa anọng p'Israẹl akk'ẹfa an-akhaama, bẹ an-asi anọng pa Kenaan asi obira-tzọhm. Yina, wa bẹ anọng mba biphyir kakhubhi. ");
INSERT INTO mfo_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","Wa anọng p'ẹkhọma ch'Ephraim anọng pa Kenaan p'arukhi ka Gẹzẹr kabira akhubh, yina, wa anọng pa Kenaan achin ororo aruk ttara bẹ. ");
INSERT INTO mfo_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","Wa anọng p'ẹkhọma cha Zebulun anọng pa Kanaan p'arukhi ka Kitron ọmaana ka Nahalol kakhubhi. Mẹ wọ ofon, wa anọng pa Kenaan achina ororo aruk k'ottem kwabẹ. Yina, wa anọng p'ẹkhọma cha Zebulun an-asi anọng pa Kenaan asi obira-tzọhm. ");
INSERT INTO mfo_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","Wa anọng p'ẹkhọma ch'Ashẹr anọng pa Kenaan p'arukhi k'Ako ọmaana ka Sidọn, ọmaana k'Ahlab ọmaana, k'Akzib ọmaana ka Helba, ọmaana k'Aphẹk ọttaara ka Rohob kakhubhi. ");
INSERT INTO mfo_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","Ofona mẹ, wa anọng p'ẹkhọma ch'Ashẹr achina ororo aruk ttara anọng pa Kenaan, okhuri da iwa bẹ ani bẹ akhubhi. ");
INSERT INTO mfo_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","Anọng p'ẹkhọma cha Naphtali anọng p'arukhi ka Bet-Shẹmẹsh ọmaana ka Bet-Anat kakhubhi, wa bẹ achina ororo abira aruk ttara anọng pa Kenaan. Yina, wa anọng pa Naphtali an-asi anọng pa Kenaan p'arukhi ka Bet-Shẹmẹsh ọmaana ka Bet-Anat asi obira-tzọhm. ");
INSERT INTO mfo_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","Wa anọng p'Amọr akpa anọng p'ẹkhọma cha Dan amaana k'okhubha kwa mgbegbeho, bẹ anọng pa Dan ọbọhk katte ahakha akwu k'ittolim. ");
INSERT INTO mfo_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","Wa anọng p'Amọr abira asi achibhi bi, bẹ aruk k'egbegbeho cha Heres, ọmaana k'Aijalọn ọmaana ka Shalbim. Yina, mada iwa anọng p'ẹkhọma cha Josẹph akk'ẹfa an-akhaama, bẹ an-asi anọng p'Amọr asi obira-tzọhm. ");
INSERT INTO mfo_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","Wa enem ch'ẹkhọma ch'Amọr ẹttẹwọr k'Eden ch'Ininaang, etzima ẹtza epyiri ka Sẹla maa, ẹkwọbh