﻿USE sofia;
DROP TABLE IF EXISTS sofia.mfm_vpl;
CREATE TABLE mfm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mfm_vpl WRITE;
INSERT INTO mfm_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Lǝkakaɗǝ tsǝtsǝfǝ ar kǝra Yesu Kǝrsiti zǝr Dawuda, kǝra tsu zǝr Ibrahimu ngau. ");
INSERT INTO mfm_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahimu ngǝ yabiya Ishaku, kǝ Ishaku yabiya Yakubu, kǝ Yakubu yabiya Yahuda ǝnga zamǝ nyiˈyar. ");
INSERT INTO mfm_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda tsu ngǝ yabiya Parisu ǝnga Zara, kǝra mǝr nda ngǝ Tamaru. Parisu ngǝ yabiya Hesaruna, kǝ Hesaruna yabiya Aramu, ");
INSERT INTO mfm_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","kǝ Aramu yabiya Aminadaɓǝu, kǝ Aminadaɓǝu yabiya Nashanu, kǝ Nashanu yabiya Salmonu. ");
INSERT INTO mfm_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonu ngǝ yabiya Buˈaza, kǝra mǝnyi ngǝ Rahapǝu. Buˈaza ngǝ yabiya Obida, kǝra mǝnyi ngǝ Ruthlu. Obida ngǝ yabiya Jesi, ");
INSERT INTO mfm_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ǝnga Jesi ngǝ yabiya tǝl Dawuda. Dawuda ngǝ yabiya Solomanu, kǝra mǝnyi ɗǝɗǝmǝ mala Yuraya ngau. ");
INSERT INTO mfm_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomanu ngǝ yabiya Rahubwamu, kǝ Rahubwamu yabiya Abijanu, kǝ Abijanu yabiya Asa, ");
INSERT INTO mfm_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","kǝ Asa yabiya Jahwashafatu, kǝ Jahwashafatu yabiya Jahwaramu, kǝ Jahwaramu yabiya Uziya. ");
INSERT INTO mfm_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziya ngǝ yabiya Jothlamu, kǝ Jothlamu yabiya Ahazu, kǝ Ahazu yabiya Hezikaya, ");
INSERT INTO mfm_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","kǝ Hezikaya yabiya Manasa, kǝ Manasa yabiya Amonu, kǝ Amonu yabiya Josaya, ");
INSERT INTO mfm_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ǝnga Josaya ngǝ yabiya Jakoniya ǝnga zamǝ nyiˈyar. Ar pǝci kǝra nji faˈar nda a vu mafakur a vu ˈyiˈyir Babilanu. ");
INSERT INTO mfm_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ayukuɗa nji faˈar nda a vu Babilanu, kǝ Jakoniya yabiya Shaltiyalu, kǝ Shaltiyalu yabiya Zarubabelu, ");
INSERT INTO mfm_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","kǝ Zarubabelu yabiya Abiyadu, kǝ Abiyadu yabiya Eliyakimu, kǝ Eliyakimu yabiya Azoru. ");
INSERT INTO mfm_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoru ngǝ yabiya Zadoku, kǝ Zadoku yabiya Akimu, kǝ Akimu yabiya Eludu, ");
INSERT INTO mfm_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","kǝ Eludu yabiya Eliyaza, kǝ Eliyaza yabiya Matanu, kǝ Matanu yabiya Yakubu, ");
INSERT INTO mfm_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ǝnga Yakubu ngǝ yabiya Yusufu, saliya Maryamu, mala kǝra yabiya Yesu, ndǝra nju ngga ǝnga Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abangǝ ngǝ patǝkura zamana nyiˈyar, dzǝgwar Ibrahimu baˈanǝ Dawuda zaman kumo apǝ foɗǝu, dzǝgwar Dawuda baˈanǝ mafakur wu ˈyiˈyir Babilanu zaman kumo apǝ foɗǝu, dzǝgwar mafakur wu ˈyiˈyir Babilanu baˈanǝ shilǝr Kǝrsiti zaman kumo apǝ foɗǝu. ");
INSERT INTO mfm_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kǝja ǝnggǝra nji ya Yesu Kǝrsiti. Mǝnyi kǝra nju ngga ǝnga Maryamu a mbiyari alkawal nǝ hǝdzǝ ǝnga Yusufu. Ama kadivira nda hǝrdzau, ba nji thlǝwa nyi ǝnga huɗǝ sara ara Mambǝl Cicau. ");
INSERT INTO mfm_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ara sal mǝmba nyi Yusufu ndǝ tsapǝ ngau ǝnga ǝtsu naju yiwu ja hǝna sǝli nyi wu pama nji mai, kǝ ji gwu ɗǝnga lagu kǝra ja sǝn sǝya nyi ɗǝɗǝwa. ");
INSERT INTO mfm_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ama tsu ju ɗǝnga sǝ kau, kǝ waladi Thlagǝ cabiya nyi kǝr wu shuni. Ji na anǝ nyi, “Yusufu zǝr Dawuda, a sara ga hivǝr hǝ Maryamu aga ja ɗa mala ngǝ mai, ara huɗǝ kǝra ara ja sara ara Mambǝl Cici nga nyi. ");
INSERT INTO mfm_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ju nda yabiya zǝr sal, ba ga fiya nyi thlǝmǝ Yesu, arya ju nda mbǝɗana nji gǝ nda sara ara bikǝr nda.” ");
INSERT INTO mfm_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Patǝkura sǝˈyar kǝ ɗarkǝr aga ja nyabiya sǝra Thlagǝ nana lagu miya nabi abǝr, ");
INSERT INTO mfm_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kwapǝliyagǝ kǝra gǝra sǝn ndǝ sal, wu nda hǝr huɗǝu, ju nda yabiya zǝsal, nju nda fiya nyi thlǝmǝ Emanuwelu,” kǝra ca ngǝ, “Hyal ǝnga mǝn.” ");
INSERT INTO mfm_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ənggǝra Yusufu hyaˈari sara wu ghanyi, kǝ ji mǝliya sǝra waladi Thlagǝ nar nyi ja mǝl, ca ngǝ, ba ji hǝri Maryamu aga mala nyi. ");
INSERT INTO mfm_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ama nandǝ nggya ndǝ sal ǝnga mala mai, kǝl ayukuɗa ji yabiya zǝr nyi. Ba Yusufu fiya nyi thlǝmǝ Yesu. ");
INSERT INTO mfm_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ayukuɗa nji yabiya Yesu wu mǝlmǝ Bayitalahami wu ˈyiˈyir Yahudi, ar pǝcir tǝlkur nǝ Hirudusu, kǝ alenyi njir sǝn sau ar kǝra shashilga sara wu Sǝbiyar Pǝci shili wu Urshalima, ndǝ sa yiwa, ");
INSERT INTO mfm_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Əmani ngǝ tǝl mafǝliyangǝ nǝ njir Yahudiya kǝra nji yabiya ka? Arya ˈyi lari shashilga nyi wu Sǝbiyar Pǝci, ca nga, ˈyi shili aga ˈya sa dlǝvǝ nyi.” ");
INSERT INTO mfm_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ənggǝra tǝl Hirudusu nggari sǝ kau, kǝ hangǝkal nyi hyaˈari, abangǝ tsu ngǝ patǝkura njir Urshalima. ");
INSERT INTO mfm_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kǝ ji nggari patǝr pubu dǝdǝgalˈyar ǝnga malǝmǝ dlaɗǝˈyar, ji yiwa nda vira nju nda ya Kǝrsiti ari. ");
INSERT INTO mfm_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ndǝ na anǝ nyi, “Wu mǝlmǝ Bayitalahami ngau, wu ˈyiˈyir Yahudi, ara abangǝ ngǝ sǝra nabi tsǝfǝri: ");
INSERT INTO mfm_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Nagǝ Bayitalahami wu ˈyiˈyir Yahudi, aˈyi nagǝ nga ndiya ǝnga kushu wu pama njir sǝm tǝlkur nǝ Yahudi mai. Ara sara wu gǝ ngǝ vanyi ndǝr sǝm tǝlkur wu sǝbiya, ndǝra wu nda tǝɗǝmwa anǝ nji ɗa njir Izirayila.’ ” ");
INSERT INTO mfm_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kǝ Hirudusu nggar njir sǝn sǝ kǝ ɗǝɗǝwa aga ja sǝnbiya kakalǝ pǝci kǝra ndǝ lari shashilga nyi. ");
INSERT INTO mfm_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kǝ ji sǝwa nda a vu Bayitalahami, ji na, “Maˈya mau hya vuwa zhigǝɗǝbiya ɗa ar kǝra zǝr kǝ ǝnga hangǝkal. Ma hya nǝr nyi ri, hya sha shili hya sa nar ɗa, aga nayi tsu, ya sa maˈyi ya vuwa dlǝvǝ nyi.” ");
INSERT INTO mfm_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ayukuɗa ndǝ nggari sǝra tǝl nana, ba ndǝ gwu lagu ndu maˈyi. Shashilga kǝra ndǝ lari wu Sǝbiyar Pǝci ta, ɓǝ wu mwar nda ǝnga ndu nu nyi kǝl ta ji sa taˈyi ar vira zǝra nyi ari. ");
INSERT INTO mfm_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ar pǝci kǝra ndǝ lari shashilga kau ba ndǝ nyau ǝnga huɗǝ pipida gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ənggǝra ndǝ vu kiya nyi ba ndǝ vuwa lar zǝr kau ǝnga mǝnyi Maryamu. Ndǝ vuwa ɓǝliya undi wu mwa nyi, ndǝ dlǝvǝ nyi. Ənggau kǝ ndǝ pahǝna mbǝlǝr nda, ba ndǝ nǝ nyi ǝndzau ǝnga ɓurdi dǝdǝgǝ kǝra nju ɗǝzau ba ǝnga ɓurdi dza wu. ");
INSERT INTO mfm_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ndǝ sha a ndu ˈyiˈyir nda vanyi lagu pamǝu, ara Hyal kughiya nda wu shuni a sara nda sha a ndǝgya Hirudusu mai. ");
INSERT INTO mfm_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ayukuɗa ndǝ maˈyi, kǝ waladi Thlagǝ canǝ nyi kǝr anǝ Yusufu wu shuni, ji na, “Hyaˈari, ga hǝr zǝr kau ǝnga mǝnyi hya nggwaɗǝnakǝr ǝnga ja a vu ˈyiˈyir Masaru. Hya vuwa nggya a vuna, kǝl yi nda nar hyi hya sha shili, ara Hirudusu a vǝr gal zǝra nyi, ju yiwu ja tsǝya nyi.” ");
INSERT INTO mfm_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kǝ Yusufu hyaˈari, ji hǝri zǝra nyi ǝnga mǝnyi ǝvuˈyi, ba ndǝ maˈyi a vu ˈyiˈyir Masaru. ");
INSERT INTO mfm_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ji vuwa nggya a vuna kǝl ta Hirudusu tau. Najakǝ tsu ɗarkǝr aga nyabiya sǝra Thlagǝ nana lagu miya nabi abǝr, “Sara wu Masaru nga yi nggar zǝr ɗa.” ");
INSERT INTO mfm_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ənggǝra Hirudusu nggari abǝr njir sǝn sǝ ka shanggǝr nyi ri kǝr, ba ɗǝfuwa ja ndzǝ gagaɗau. Ba ji sǝwa aga nja dlǝdlǝna patǝr wazha shili kǝra wu Bayitalahami ǝnga ˈyiˈyi kǝra zǝwar nyi, mbari wazha fa mǝthlǝ baˈanǝ kǝra a gya banga nda, kakalǝ ǝnga pǝci kǝra njir sǝn sǝ ta na anǝ nyi ar kǝra yar zǝr ta. ");
INSERT INTO mfm_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ar pǝci kǝ nga nji nyabiya sǝra nabi Irimiya nana, abǝr, ");
INSERT INTO mfm_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Nji nggar ɗahǝ wu Rama, a vǝr tiwi ǝnga huɗǝ ndzǝndzǝ gagaɗau, Rahila nga vǝr tiwi arya wazha nyi, ji tini mbiya ɗǝfu ara ǝnggǝra nji dlǝna wazha nyi.” ");
INSERT INTO mfm_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ayukuɗa tǝr Hirudusu, kǝ waladi Thlagǝ canǝ nyi kǝr anǝ Yusufu wu shuni wu Masaru, ji na, ");
INSERT INTO mfm_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Ga hyaˈari, ga hǝri zǝr kau ǝnga mǝnyi ga sha ǝnga nda a vu ˈyiˈyir Izirayila, ara njira vǝr gal aga nda tsǝya zǝr kau, a kuɗǝr nda.” ");
INSERT INTO mfm_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kǝ ji hyaˈari, ji hǝri zǝra nyi daɓǝ ǝnga mǝnyi ba ndǝ maˈyi a vu ˈyiˈyir Izirayila. ");
INSERT INTO mfm_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ama ǝnggǝra ji nggari abǝr Arkilayusu nga vǝr sǝm tǝlkur wu ˈyiˈyir Yahudi ar viya dǝnyi Hirudusu ba hivǝr mbari nyi ara vwau. Ənggǝra nji kughiya nyi wu shuni, kǝ ji sha a vu ˈyiˈyir Galili. ");
INSERT INTO mfm_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kǝ ji maˈyi ji vuwa nggya wu vanyi mǝlmǝ kǝra nju ngga ǝnga Nazǝratu, aga nja nyabiya sǝra nabiˈyar nana, abǝr, “Nju nda ngga nyi ndǝr Nazǝratu.” ");
INSERT INTO mfm_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ayukuɗa fa gangǝ tǝrabiya, ngǝ Yahwana ndǝr mǝl Baɓǝtizǝma shili, ja vǝr tǝtǝlna ndǝr Hyal ar tagǝ nǝ ˈyiˈyir Yahudi, ");
INSERT INTO mfm_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ju na, “Hya tubi, ara tǝlkur Hyal a ɗari lǝhǝu.” ");
INSERT INTO mfm_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Naja ngǝ ndǝra nabi Əshaya ndǝr ar kǝri, ji na, “Ɗahǝ a vǝr ngga a gwar tagǝu, ja vǝr na, ‘Hya pabǝri nyi lagu anǝ Thlagǝu, hya mǝliya lagu tataˈyi pir wu mwa nyi.’ ” ");
INSERT INTO mfm_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Lǝgutǝ ha nǝ Yahwana ǝnga shisha dlǝgwam nga nji mǝliya. Sǝr mba sar nyi ca ngǝ takulagǝ ci. Sǝr sǝm nyi tsu ca ngǝ ndzǝkwa ǝnga ˈyimir ciɗi tagǝu. ");
INSERT INTO mfm_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Njira maˈyi a ndǝgya ja nji sara wu Urshalima ngau ǝnga patǝr ˈyiˈyir Yahudi ǝnga patǝkura ˈyiˈyir dǝl Urdǝnu. ");
INSERT INTO mfm_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ndu nana bikǝr nda, kǝ ji mǝliya nda baɓǝtizǝma wu dǝl Urdǝnu. ");
INSERT INTO mfm_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ama ǝnggǝra Yahwana lari njir Farisi ǝnga njir Sadusi gangǝu, a vǝr shili aga ja sa mǝliya nda baɓǝtizǝma, kǝ ji na anǝ nda, “Nahyi wazha mǝtsapa! Wa ngǝ kughiya hyi, aga hya hwi sara ara numa nǝ huɗǝ ndzǝndzǝ Hyal kǝra a vǝr shili ka? ");
INSERT INTO mfm_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Hya mǝl thlǝr kǝra mǝnahǝu wu nggyabiyar hyi kǝra wu cabiya abǝr a tubir hyi. ");
INSERT INTO mfm_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","A sara hya fiya wu ɗǝfuwa hyi tsu, abǝr, ‘Ibrahimu ngǝ dǝrˈya.’ Yu na anǝ hyi, abǝr Hyal aˈyi ja ǝnga dǝnama nǝ shabiya tsǝkaˈyar kau, aga wazha anǝ Ibrahimu. ");
INSERT INTO mfm_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","A fiyar nji hira kǝm ar nggyilanga wu. Kalar wu kǝra gǝra pǝ wazha mǝnahǝu, nju nda gǝmna nyi ba nja vakuwa nyi a gwu uˈu. ");
INSERT INTO mfm_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nayau, ya vǝr mǝl baɓǝtizǝma anǝ hyi ǝnga ˈyimi kǝra wu cabiya abǝr a tubir hyi. Ama ndǝra wu ndiya ɗa ǝnga dǝgalǝu, wu shili wu yukuɗǝ ɗa, ndǝra alaga ɓiɓi nyi nayi aˈyi yi ɗa tsaˈa aga ya hǝ mai. Ju sa mǝliya hyi baɓǝtizǝma ǝnga Mambǝl Cicau ba ǝnga uˈu. ");
INSERT INTO mfm_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Cala pi nyi wu tsa ja nga nyi, ju pina uhi ba ja tsǝkǝna lara nyi ba ja dzǝgwa faˈana uhi a su tsam. Ama kufu ǝnga cacangǝ ba ja nggyina nda ǝnga uˈu kǝra gǝra tau.” ");
INSERT INTO mfm_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ar pǝci kǝ ngǝ Yesu shili sara wu Galili, ji maˈyi a gwu dǝl Urdǝnu aga Yahwana a gwa hǝr nyi baɓǝtizǝma. ");
INSERT INTO mfm_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ama Yahwana wu yiwu ja kari nyi, ju na, “Nayi kǝra lari a ɗari tsaˈa ga hǝr ɗa baɓǝtizǝma, abari nga gu sǝn shili ara ya?” ");
INSERT INTO mfm_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ama kǝ Yesu shaɗǝwa nyi, ji na, “Bǝgǝ ja ɗa abangǝ kabangǝkau, kakalǝ nga nyi anǝ mǝn mǝna mǝl abangau, aga mǝna nyabiya sǝra tsaˈa.” Ənggau, kǝ Yahwana hǝnggǝri, ba ji hǝr nyi baɓǝtizǝma. ");
INSERT INTO mfm_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ənggǝra Yahwana hǝr nyi baɓǝtizǝma anǝ Yesu, kǝ ji biya sara wu ˈyimiya nyi. Ar pǝci ta, kǝ dǝmǝlmǝ pahau, ba ji lari Mambǝl Hyal a vǝr shida a papa mbǝthla, ka sa ndzafau ar ja. ");
INSERT INTO mfm_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kǝ ɗahǝ sara dǝmǝlmǝ na, “Najakǝ zǝr ɗa ngau, yu yiwu nyi, huɗa yi pipida ǝnga ja.” ");
INSERT INTO mfm_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kǝ Mambǝl Cici lǝbiya Yesu a gwar tagǝu, aga shatan a gwa dzǝbiya nyi. ");
INSERT INTO mfm_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ayukuɗa Yesu hǝr zǝmǝtsini nǝ pida foɗǝ kumunyi vuˈyi ǝnga pǝci, kǝ wuɓǝ mbari nyi. ");
INSERT INTO mfm_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kǝ shatan shili ji sa na anǝ nyi, “Ma nagǝ ngǝ zǝr Hyal, ga nar nyi anǝ tsǝkaˈyar kau, aga nda sha aga macikǝl.” ");
INSERT INTO mfm_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kǝ Yesu shaɗǝwa, ji na, “Tsǝtsǝfǝ nga nyi wu ndǝr Hyal abǝr, ‘Aˈyi ǝnga sǝr sǝm wacu ngǝ ndǝ wu nggya ǝnga pi mai, ama ǝnga kalar ndǝr kǝra wu biya sara wu miya Hyal.’ ” ");
INSERT INTO mfm_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kǝ shatan hǝri nyi a vu Urshalima mǝlmǝ cicau ba ji hǝri nyi a dar kǝra ki Hyal a dar vira ndiya ǝnga dzǝgamǝu. ");
INSERT INTO mfm_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kǝ ji na anǝ nyi, “Ma nagǝ ngǝ zǝr Hyal, ga vǝl a gyiwu ˈyi sara ǝnggau, arya tsǝtsǝfǝ nga nyi: “ ‘Ju sǝwa waladi nyiˈyar aga nda ɓǝlar ngau. Ndu sǝɓiya ngǝ wu tsa nda ara ga sara dǝgǝri hiya gǝ ar tsǝka.’ ” ");
INSERT INTO mfm_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Kǝ Yesu na anǝ nyi, “Tsǝtsǝfǝ nga nyi tsu, abǝr, ‘Ga sara dzǝ Hyal Thlagǝ ngǝ mai!’ ” ");
INSERT INTO mfm_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kǝ shatan ɓǝra hǝri nyi a dar kǝra vanyi mǝ kǝra dzǝgamǝ gagaɗau, kǝ ji canǝ nyi patǝkura tǝlkur nǝ duniya ǝnga kadakadarkur nda. ");
INSERT INTO mfm_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kǝ ji na anǝ nyi, “Patǝkura sǝˈyar kǝ yu nǝ ngau, ma gǝ ɓǝliya ɗa undi ba ga dlǝvǝ ɗa.” ");
INSERT INTO mfm_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kǝ Yesu na anǝ nyi, “Kwaya wu dzǝr ɗa shatan! Arya tsǝtsǝfǝ nga nyi: ‘Ga dlǝvǝ Hyal Thlagǝ ngau, ǝnga anǝ nyi zhizhi nyi nga ga mǝl thlǝr wacu.’ ” ");
INSERT INTO mfm_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ənggau, kǝ shatan piyari nyi, ba waladiˈyar shili ndǝ sa dlǝwar nyi. ");
INSERT INTO mfm_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ənggǝra Yesu nggari abǝr a fuwar nji Yahwana wu fursǝna, ba ji sha a vu Galili. ");
INSERT INTO mfm_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ji piyari Nazǝratu ba ji maˈyi a vuwa nggya wu mǝlmǝ Kafarnahumu, kǝra a miya dǝl, kǝra wu kǝla ˈyiˈyir Zabulanu ǝnga Nafǝtali, ");
INSERT INTO mfm_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","aga ja nyabiya sǝra nabi Əshaya nana: ");
INSERT INTO mfm_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“ˈYiˈyir Zabulanu ǝnga ˈyiˈyir Nafǝtali, lagur gwu dǝl, a biyar ya dǝl Urdǝnu, ǝnga Galili nǝ nji kǝra aˈyi njir Yahudiya mai, ");
INSERT INTO mfm_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","njira vǝr nggya wu kuthlǝu a lar nda mbǝmbǝl kǝra dǝgal gagaɗau. Njira a vǝr nggya ar ˈyiˈyi nǝ shangguɗa tǝ tsu mbǝmbǝl a shiliri anǝ nda.” ");
INSERT INTO mfm_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mbari ar pǝci ta, ngǝ Yesu dzǝguya tǝtǝlna ndǝr Hyal, ju na, “Hya tubi ara tǝlkur Hyal a ɗari lǝhǝu.” ");
INSERT INTO mfm_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ənggǝra Yesu a vǝr tǝrabiya ar thlǝrpa dǝl Galili, ba ji lari ndǝ ǝnga zamǝ nyi, Simanu kǝra nju ngga ǝnga Biturusu ǝnga zamǝ nyi Andǝrawusu. Nda vǝr sǝ litagǝr nda a gwar dǝl, ara nanda njir tǝm ngau. ");
INSERT INTO mfm_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Əngwar Yesu anǝ nda, “Anda mau, hya nu ɗa, aga ya shabiya hyi hya ɗa njir tǝm nji.” ");
INSERT INTO mfm_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ənggǝrna, kǝ ndǝ piyari litagǝr nda ba ndǝ nu nyi. ");
INSERT INTO mfm_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ənggǝra ji ɓar dzǝ a dumwa kushu, kǝ ji ɓǝra lar vanyi ndǝ ǝnga zamǝ nyi tsu, nanda ngǝ Yakubu zǝr Zabadi ǝnga Yahwana zamǝ nyi. Wu kwambwal nga nda ǝkkǝˈyi dǝrnda Zabadi, nda vǝr ɓathlǝ litagǝr nda. Kǝ Yesu ngga nda. ");
INSERT INTO mfm_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ənggǝrna, kǝ ndǝ piyari kwambwalǝr nda ba dǝrnda, ba ndǝ nu nyi. ");
INSERT INTO mfm_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu ɓǝbiya ɓau wu patǝr ˈyiˈyir Galili, ja vǝr highiɓǝ wu umbwa daɓǝ dzǝˈyar, ja vǝr tǝtǝlna ndǝshigu ar kǝra tǝlkur Hyal. Ba ǝnga ja vǝr shilǝgǝbiya shilǝgǝu pampamǝu, ǝnga gǝra ngga pampamǝu. ");
INSERT INTO mfm_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ndǝr ar kǝra ja tǝtǝlnakǝr a ndu ˈyiˈyir Sǝriya patǝu. Nji hǝri nyi a shili patǝr njira ǝnga shilǝgǝ pamǝpamǝu ǝnga njira wu ɓwaɓwatǝ gagaɗau ǝnga njira shatan fǝnggǝr nda ɓwaɓwatǝu ǝnga njira sǝ tsatsa wu tǝ nda ǝnga njir tǝsǝkǝnǝu, ba ji shilǝgǝbiya nda. ");
INSERT INTO mfm_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Dlamir nji gangǝ sara wu ˈyiˈyi Galili ǝnga tsu nji sara wu ˈyiˈyi Dikapulusu ǝnga sara wu Urshalima ǝnga ˈyiˈyir Yahudi, tsaˈa a biya banga dǝl nǝ Urdǝnu nu nyi. ");
INSERT INTO mfm_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ənggǝra Yesu lari dlamir nji, kǝ ji maˈyi a dar kǝra mau, kǝ ji nda nggya gya. Ba zǝmbǝlma nyiˈyar shili ǝgya ja. ");
INSERT INTO mfm_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Kǝ ji dzǝguya highiɓau, ju na, ");
INSERT INTO mfm_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Barka anǝ njira tǝtǝwa wu mambǝl, ara tǝlkur Hyal nǝr nda ngau. ");
INSERT INTO mfm_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Barka anǝ njira wu sǝˈyinggu, ara nju nda pǝli anǝ nda. ");
INSERT INTO mfm_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Barka anǝ njira tina kǝr, ara ndu nda faˈabiya ki ǝnga duniya. ");
INSERT INTO mfm_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Barka anǝ njira ǝnga wuɓau ǝnga hilir nggya tsapǝu, ara nju nda nyabiya nda. ");
INSERT INTO mfm_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Barka anǝ njira ǝnga tǝhuɗǝu, arya nanda nju nda tǝhuɗǝ ǝgya nda. ");
INSERT INTO mfm_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Barka anǝ njira ɗǝfuwa nda cicau, arya ndu nda lari Hyal. ");
INSERT INTO mfm_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Barka anǝ njira mǝl thlǝr aga nggya jamǝu, arya nju nda ngga nda ǝnga wazha Hyal. ");
INSERT INTO mfm_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Barka anǝ njira nju ɗa nda arya mǝl sǝra tsapǝu, ara tǝlkur Hyal nǝr nda ngau. ");
INSERT INTO mfm_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Barka anǝ hyi ma nji nggǝl hyi, nji ɗa hyi ǝnga thla fati nǝ kurthlǝu ǝnga na patǝr sǝ ɗǝmwaˈyi ar kǝra hyi arya yau. ");
INSERT INTO mfm_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Hya caguli ǝnga hya nggya ǝnga huɗǝ pǝrtǝ ara hyu nda uya akkǝri gangǝ a dǝmǝlmau, arya abangǝ nga nji ɗa nabiˈyar kǝra tǝrabiya tsu. ");
INSERT INTO mfm_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nahyi ngǝ unau nǝ duniya. Ama ma unǝ caɓǝnakǝr, abar nga ju sǝn shabiya kǝrnyi a shila? Tsu ja sǝn ɗa mǝnahǝ mai, kǝl ba nja vakana nyi a biya ba nja biya cicina nyi. ");
INSERT INTO mfm_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nahyi mbǝmbǝl nǝ duniya ngau. Mǝlmǝ kǝra a dar madzigam a sǝn ɗǝwanakǝr mai. ");
INSERT INTO mfm_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nja sǝn mbǝbiya pitǝlla ba nja mbuya ǝgya kiɗa tǝm mai. Ama nja kyaga fiya a dar madzigam, ba ja dzǝgwa mbǝl anǝ kalar ndǝ kǝra a vu ki kau. ");
INSERT INTO mfm_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Abangǝ tsu, bǝgǝ mbǝmbǝlǝr hyi a mbǝl a dumwar nji, aga nda lari mǝnahǝkura thlǝrǝr hyi ba nda dzǝgwa dlǝvǝ dǝr hyi kǝra a dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“A sara hya ɗǝnga abǝr yi shili aga ya sa dazhina highiɓǝ nǝ dlaɗǝ Musa ǝnga highiɓǝ nǝ nabiˈyar mai. Nayi shili aga ya sa dazhina nda mai ama aga ya sa nyabiya nda. ");
INSERT INTO mfm_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ya nar hyi jiri, divira dǝmǝlmau ǝnga gyuˈyi a sanakǝr, alaga sǝ ǝnggǝr camwaɗi ba alaga sǝ kushu ǝnggǝr tsǝfǝ tafǝu, aˈyi wu nda sa wu dlaɗǝ nǝ Musa mai, kǝl kalar sǝ nyabiya dzau. ");
INSERT INTO mfm_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kalar ndǝ kǝra gǝra ɓǝlari pathlǝ wu kusha dlaɗǝˈyar kau ǝnga ji highiɓǝ anǝ alenyi nji aga nda mǝl abangǝ ngau, nju nda ngga nda njira kushu wu tǝlkur Hyal. Abangǝ tsu, kalar ndǝra wu mǝl thlǝr ǝnga dlaɗǝˈyar kau ǝnga ju highiɓǝ anǝ nji, ju nda ɗa dǝgal wu tǝlkur Hyal. ");
INSERT INTO mfm_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ya nar hyi jiri, ma tsapǝkur hyi aˈyi ndiya nǝ njir Farisi ǝnga nǝ malǝmǝ dlaɗǝˈyar mai, nahyi wu sǝn gwu tǝlkur Hyal mai. ");
INSERT INTO mfm_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“A nggari hyi ǝnggǝra nji na anǝ nji ɗǝɗǝmǝ, abǝr, ‘A sara hya tsa ndǝ mai ǝnga kalar ndǝra tsǝya ndau, nju nda mǝl numa anǝ nyi.’ ");
INSERT INTO mfm_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ama yu na anǝ hyi, abǝr kalar ndǝra ɗǝfu ǝnga zamǝ nyi, nju nda mǝl numa anǝ nyi. Ətsu, kalar ndǝr na anǝ zamǝ nyi, ‘Sǝ nga gǝ mai,’ ba nja hǝri nyi a dumwar njir pathla. Ama kalar ndǝra na anǝ zamǝ nyi ‘Nagǝ dza,’ a ɗar ja tsaˈa aga gwu uˈur kǝtsa. ");
INSERT INTO mfm_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Agabangau, ma ga vǝr lǝ sǝ a dumwar Hyal ba gǝ ɗǝngari abǝr huɗa zamǝ ngǝ ndzǝndzǝ nga nyi ǝnga gau, ");
INSERT INTO mfm_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ba ga fiya sǝr lǝ ngau, a dumwar Hyal kwatahǝu. Ba ga maˈyi, ga nda ɓasǝwa ǝnga zamǝ ngau, ǝnggau, ba ga dzǝgwa shili ga sa lǝri sǝr lǝ ngau. ");
INSERT INTO mfm_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ma ndǝ wulana ngǝ a ndumwar pathla, hya ɓasǝwa ǝnga ja tsu hyar lagu, aˈyi abangǝ mai, ba ja fuwa ngau a gu tsa ndǝr pathla, ba ndǝr pathla tsu a fuwa ngau a gu tsa dǝgala ndǝr fursǝna, ndǝr fursǝna tsu ba ja fuwa ngau a gu fursǝna. ");
INSERT INTO mfm_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ya nar ngǝ jiri, nagǝ wu biya mai, kǝl gǝ kina patǝr sǝra nju nu ngau. ");
INSERT INTO mfm_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“A nggari hyi ǝnggǝra nji na anǝ nda, abǝr, ‘A sara hya mǝl sǝsukur mai.’ ");
INSERT INTO mfm_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ama sǝra yu na anǝ hyi, ca ngǝ, ma ndǝ tsamǝ mala ǝnga ɗǝfu nǝ cim mǝl sǝsukur ǝnga ja, ja sǝni abǝr, a pidar ja ǝnga ja wu ɗǝfuwa ja. ");
INSERT INTO mfm_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ma liya gǝ nǝ mazǝm, wu sǝwa ngǝ aga ga mǝl bikau, ga tǝkuɗǝbiya nyi, ba ga sǝna nyi. Kuji ga tini pathlǝ wu pama dza gau, a ndiya dza gǝ patǝ a gwu uˈur kǝtsa. ");
INSERT INTO mfm_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma pǝla gǝ nǝ mazǝm, wu sǝwa ngǝ aga ga mǝl bikau, gǝmna ba ga vakana nyi. Kuji ga tini pathlǝ wu pama gashal dza gau, a ndiya dza gǝ patǝ a gu uˈur kǝtsa. ");
INSERT INTO mfm_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“A nar ndar nji tsu kaɗǝu, abǝr, ‘Kalar ndǝra kǝdlǝna mala nyi, a ɗar tsaˈa sal ja nǝ nyi lǝkakaɗǝ nǝ sakida kǝdlau.’ ");
INSERT INTO mfm_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ama yu na anǝ hyi, kalar ndǝra kǝdlǝna mala nyi, ma aˈyi ara nji mbar nyi a vǝr dlǝnga sal mai, a sǝwa nyir ja aga ja mǝl sǝsukur. Ətsu, kalar ndǝra hǝri mala kǝra nji kǝdlǝna, a ɗar ja ndǝ sǝsu. ");
INSERT INTO mfm_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ətsu, a nggari hyi nji na anǝ nji ɗǝɗǝmǝu, abǝr, ‘A sara hya sǝm fǝla ar kǝra fati mai, ama hya nyabiya alkawal kǝra hyi mǝliya nyi anǝ Thlagǝu.’ ");
INSERT INTO mfm_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ama yu na anǝ hyi, A sara hya sǝm fǝla mai, alaga ǝnga dǝmǝlmau ara vir nggya Hyal ngau, ");
INSERT INTO mfm_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","alaga ǝnga duniya, ara vir fǝ hiya ja ngau, alaga ǝnga Urshalima, ara mǝlmǝ Tǝl dǝgal ngau. ");
INSERT INTO mfm_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ənga tsu a sara ga sǝm fǝla ǝnga kǝra gǝ mai, ara naga sǝn shabiya zǝma shisha gau, ja sha aga pǝrtǝu ǝnga alaga kiyakiyar mai. ");
INSERT INTO mfm_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Sǝra hya kyaga na, ca ngǝ, ‘Angǝ’ ja ɗa ‘Angǝ’ ǝnga ‘Awau’ ja ɗa ‘Awau.’ Kalar sǝra a biya banga kau, sara ara shatan nga nyi shili. ");
INSERT INTO mfm_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“A nggari hyi ǝnggǝra nji na anǝ nda ɗǝɗǝmǝu, ‘Li ar viya li, hir tsu ar viya hir.’ ");
INSERT INTO mfm_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ama sǝra yu na anǝ hyi, ca ngǝ, a sara hya ka ndǝ ja sara ɗiya hyi mai. Ma ndǝ nǝ ngǝ tsǝbalma ar balma mazǝma gau, ba ga shabiya nyi zǝma nyi tsu. ");
INSERT INTO mfm_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma vanyi ndǝ wu yiwu aga ja wulana ngau ǝnga ja hǝri lǝgutǝ ngau, bǝgǝ ja hǝri patǝ ǝkkǝˈyi sǝr bakǝ ngau. ");
INSERT INTO mfm_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ma ndǝ ciwa ngǝ aga hya ɓǝ nǝ miyalu pathlǝu, maˈya mau nǝ miyalu mǝthlǝ ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nǝ nyi anǝ ndǝra kǝdiyau ara gau, ndǝra shili tsu, ji sa yiwa mǝl ara gau, a sara ga ka anǝ nyi mai. ");
INSERT INTO mfm_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“A nggari hyi nji na anǝ nda, abǝr, ‘Ga yiwu zamǝ ngau, ba ga piyari dawa ngau.’ ");
INSERT INTO mfm_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ama yu na anǝ hyi, hya yiwu dawar hyi ba hya kǝdi Hyal anǝ nda. ");
INSERT INTO mfm_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mǝl abangǝ nga hyu nda ɗa wazha dǝr hyi kǝra a dǝmǝlmau, ndǝra vǝr sǝwa pǝci ja mbǝl ar kǝra nji tsapǝu ǝnga nji batal ǝnga tsu ja tǝɗǝya par sara a dǝmǝlmǝ a gyar kǝra nji tsapǝu ǝnga nji ɗǝmwaˈyu. ");
INSERT INTO mfm_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ma njira vǝr yiwu hyi nga hyu yiwu wacu, wathlǝmǝ culi akkǝri kǝra hyu nda uya? Alaga njir dlǝwu budǝ ma tsu, ndu mǝl abangau. ");
INSERT INTO mfm_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ma tsu, zamǝr hyi nga hyu usa wacu, ya, mi ngǝ sǝra hyi mǝliya pamǝ a mwara alenyi nja? Mǝna sǝni alaga njira aˈyi njir Yahudiya mai, ndu mǝl abangau. ");
INSERT INTO mfm_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hya nggya nyinyi cipǝu, ǝnggǝr kǝra Dǝr hyi kǝra a dǝmǝlmǝ nyinyi cipǝu. ");
INSERT INTO mfm_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Hya hangǝkal ara mǝl ‘thlǝrǝr hyi nǝ tsapǝkur,’ ja sara ɗa sǝra nja lari ǝnga li wacu. Ara ma hyi mǝl abangau, nahyi wu nda uya akkǝri ara Dǝr hyi kǝra a dǝmǝlmǝ mai. ");
INSERT INTO mfm_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Agabangau, ma gu lǝ sǝ anǝ ndǝr gha, a sara ga hǝˈuna mai, ǝnggǝra kǝra njir ngguta vi wu mǝl wu umbwa daɓǝ dzǝˈyar ǝnga ar laguˈyar aga nja faliya nda. Ənga jiri nga yu na anǝ hyi, a uyar nda akkǝri nda cipǝu. ");
INSERT INTO mfm_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ama ma gu lǝ sau, a sara ga piyari pǝla gǝ nǝ matsal ja sǝnbiya sǝra pǝla gǝ nǝ mazǝm a vǝr mǝl mai, ");
INSERT INTO mfm_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","aga lǝ sǝ ngau ja ɗa ar ɗǝɗǝwa. Ba dǝngǝ tsu, kǝra wu lari kalar sǝra nju mǝl ɗǝɗǝwa patǝu, ba ja sa nǝ ngǝ akkǝri. ");
INSERT INTO mfm_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ənga tsu, ma hyu ndǝr ǝnga Hyal, a sara hya ɗa ǝnggǝr njir ngguta vi mai, njira wu yiwu kǝdi Hyal aˈyi taˈyi wu umbwa daɓǝ dzǝˈyar ǝnga ar laguˈyar aga nja daɓaga lar nda. Ənga jiri nga yu na anǝ hyi, a uyar nda akkǝri nda cipǝu. ");
INSERT INTO mfm_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ama ma hyu kǝdi Hyal, hya maˈyi a gwu umbwa hya gwa haɗiya miya nyi, ba hya dzǝgwa ndǝr ǝnga dǝr hyi, ndǝra nji gǝra lari. Ba dǝr hyi, kǝra wu lari sǝra nja mǝl ɗǝɗǝwa, wu nda nǝ hyi akkǝri. ");
INSERT INTO mfm_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ma hyu kǝdi Hyal, a sara hya ndǝr gangǝ ǝnggǝr njira gǝra sǝn Hyal mai, njira wu nggani abǝr ndǝr gangǝ ca ngǝ Hyal wu nggari. ");
INSERT INTO mfm_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","A sara hya ɗa ǝnggǝr nanda mai, ara Dǝr hyu sǝn sǝra hyu ghari divira hya dzǝgwa kǝdi nyi. ");
INSERT INTO mfm_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Kǝja, ǝnggǝra hya ndǝr ǝnga Hyal: “ ‘Dǝrˈya kǝra a dǝmǝlmau, thlǝmǝ ngǝ ja nggya cicau, ");
INSERT INTO mfm_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","tǝlkur ngau ja shili, sǝra gu yiwu taˈyi ja ɗa wu duniya, ǝnggǝr kǝra nja vǝr mǝl a dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ɗar ˈya sǝr sǝm nǝ ǝshina. ");
INSERT INTO mfm_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tǝfǝbiya ˈya bikǝr ˈya, ǝnggǝr kǝra ˈyi tǝfǝbiya njira mǝliya ˈya bikau. ");
INSERT INTO mfm_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","A sara ga hǝr ˈya a ndar vir dzǝ mai, ama ga kǝtiya ˈya ara shatan. Ara tǝlkur ǝnga dǝnama ǝnga kadakadarkur, nǝngau baˈanuwa. Amina.’ ");
INSERT INTO mfm_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ara ma hyi tǝfǝbiya njira mǝliya hyi bikau, Dǝr hyi kǝra a dǝmǝlmǝ tsu wu sa tǝfǝbiya hyi. ");
INSERT INTO mfm_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ama ma nahyi aˈyi tǝfǝbiya njira mǝliya hyi bikǝ mai, abangǝ tsu, Dǝr hyi kǝra a dǝmǝlmǝ wu nda tǝfǝbiya hyi bikǝr hyi mai. ");
INSERT INTO mfm_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ma hyu hǝ zǝmǝtsini a sara hya hashi bama hyi ǝnggǝr kǝra njir ngguta vi wu mǝl kǝ mai, ara ndu hashi bama nda aga ca anǝ nji abǝr wu zǝmǝtsini nga nda. Ənga jiri ya nar hyi a uyar nda akkǝrir nda cipǝu. ");
INSERT INTO mfm_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ama ma gu hǝ zǝmǝtsini ga cina bama gau ǝnga ga ɓǝsiya mal, ");
INSERT INTO mfm_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ara nja sara sǝni abǝr ga vǝr hǝ zǝmǝtsini. Dǝngǝ kǝra aˈyi ǝnga gau, ndǝra tsu wu lari sǝra nju mǝl ɗǝɗǝwa wu nda nǝ ngǝ akkǝri. ");
INSERT INTO mfm_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“A sara hya tsǝm gǝnna anǝ kǝrhyi wu duniya mai, vira kǝthla ǝnga vuyavuya wu sǝn ndzana, vira tsu njir hǝl wu sǝn pǝthlǝna ba nda vuwa faˈari. ");
INSERT INTO mfm_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ama hya tsǝmiya anǝ kǝrhyi gǝnnar hyi a dǝmǝlmau, vira kǝthla ǝnga vuyavuya a sǝn ndzana mai, vira tsu njir hǝl wu sǝn pǝthlǝna nda vuwa faˈari mai. ");
INSERT INTO mfm_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Arya vira gǝnna ngǝ ari, ǝna ngǝ ɗǝfuwa gǝ tsu. ");
INSERT INTO mfm_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Li ca ngǝ mbǝmbǝl nǝ dzau. Ma liya gǝ mǝnahǝu, dza gǝ patǝ wu nyabiya dzǝ ǝnga mbǝmbǝl. ");
INSERT INTO mfm_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ama ma liya gǝ aˈyi jamǝ mai, patǝkura dza gu tini mbǝmbǝlkur. Ma mbǝmbǝlǝr dza gu kuthlǝ nga nyi, kadzangǝ abar ngǝ kiyakiyarkura kuthlǝ ka! ");
INSERT INTO mfm_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ndǝr sǝn mafakur anǝ thlagǝr ki pamǝpamǝ mǝthlǝ aˈyi mai, ara ju nda yiwu vanyi ba ja piyari vanyi ǝnga ju nda hǝya kǝr anǝ vanyi ba ja diɗana vanyi. Nahya sǝn daɓǝri nu Hyal ǝnga gal gǝnna mai. ");
INSERT INTO mfm_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Agabangau, yu na anǝ hyi, a sara hya ghǝɗǝr kǝrhyi arya nggyabiyar ǝnga sǝra hyu sǝm ǝnga sǝra hyu sa mai, alaga ar kǝra kar dza hyi tsu mai. Arya piya ndau, aˈyi a ndiya sǝr sǝm wa, ǝnga dza ndǝ aˈyi a ndiya sǝr ha wa? ");
INSERT INTO mfm_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tsama mǝ ˈyagǝˈyar gǝyi, nandǝ wu thlǝka mai ǝnga nandǝ wu gǝm mai ǝnga tsu nandǝ wu pǝ sǝ wu val mai, alaga abangau, dǝr hyi kǝra a dǝmǝlmǝ nga vǝr sǝmǝna nda. Ya, aˈyi hyu ndiya nda ǝnga dudurkur wa? ");
INSERT INTO mfm_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wa ngu pama hyi ara ɓwakǝr nyi, ba ja sǝn cakǝri saka pathlǝu a dar kǝra piya ja? ");
INSERT INTO mfm_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ətsu mi ngǝ ɗa hyu ghǝɗǝr kǝrhyi ar kǝra sǝr ha? Tsama mǝ jigwal wu gǝyi, ǝnggǝra ndu hau. Nandǝ wu mǝl thlǝr alaga shi paˈwa mai. ");
INSERT INTO mfm_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Agabangau, yu nar hyi, alaga tǝl Solomanu ǝnga kadakadarkur nyi aˈyi saya har kari ǝnggǝr nǝr nda mai. ");
INSERT INTO mfm_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ma abangǝ ngǝ Hyal wu har nyi kar anǝ jigwal wu a gwar tagǝu, kǝra aˈyi nda ǝshina ama ǝzǝgǝu a fuwar nji a gu uˈu, aˈyi ju nda har hyi kar a ndiya nda wa? Nahyi njira ǝnga mbǝrsa kukushu. ");
INSERT INTO mfm_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Agabangau, hya sara ghǝɗǝr kǝrhyi, hyu na, ‘Mi nga ˈya wu nda sǝma’ ǝndǝga ‘Mi nga ˈya wu nda sa,’ alaga ‘Mi nga ˈya wu nda ha?’ ");
INSERT INTO mfm_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Arya njir duniya ngu gal sǝˈyar kau. Dǝrhyi kǝra a dǝmǝlmau, wu sǝni abǝr hyu yiwu sǝˈyar kau. ");
INSERT INTO mfm_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ama sǝ tanggǝrma, ca ngǝ hya gal tǝlkur Hyal ǝnga tsapǝkur nyi ba ja nǝ hyi sǝˈyar kǝ patǝ tsu. ");
INSERT INTO mfm_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Agabangau, hya sara ɓukǝr hyi arya sǝra ǝzǝgǝ mai, ara ǝzǝgǝ wu shili ǝnga ɓwaɓwatǝ nǝ kǝrnyi. Ɓwaɓwatǝ nǝ kalar pǝci tsaˈa aga pǝci ta nga nyi. ");
INSERT INTO mfm_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“A sara hya thla numa ar kǝra nji mai, nji tsu aˈyi ndu thla numa ar kǝra hyi mai. ");
INSERT INTO mfm_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Arya culi thla numa kǝra hyi mǝl anǝ nji, ca nga nju nda thla numa ǝni anǝ hyi. Cala tǝkǝ sǝ kǝra hyi tǝkǝ sǝ ǝni anǝ nji, ca nga nju nda tǝkǝ sǝ ǝni anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ara mi nga gu lari zǝr sar kǝra wu liya zamǝ ngau, ama na ga sǝn tsamiya gwalang kǝra ar liya gǝ kǝ maya? ");
INSERT INTO mfm_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Əndǝga, abari nga ga sǝn na anǝ zamǝ ngau, abǝr, ‘Taˈyau, ya hǝbiya ngǝ zǝr sar kǝra wu liya gau,’ ya, kǝja gwalang ngǝ ar liya ga? ");
INSERT INTO mfm_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nagǝ ndǝr ngguta vi, ga hǝbiya gwalang kǝra wu liya gǝ kwatahǝu, aga ga daɓaga lari mǝnahǝu, ba ga sǝn hǝbiya zǝr sar kǝra wu liya zamǝ ngǝ kau. ");
INSERT INTO mfm_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“A sara hya nǝ nyi anǝ hya sǝra cici mai ǝnga a sara hya vakar nyi anǝ fǝshiu tsǝka nǝ gǝnna gangǝ mai, ca ngǝ tsǝka wilwilu. Ara fǝshiu wu nda cicina nda ba nda shabiya dzǝ nda uya hyi ǝnga shilǝgǝu. ");
INSERT INTO mfm_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Hya dumwa ǝnga kǝdiyau, nju nǝ hyi. Hya dumwa ǝnga gal, hyu uya. Hya dumwa ǝnga tsatsa tsu, nju pahǝna hyi. ");
INSERT INTO mfm_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ara kalar ndǝra kǝdiyau, nju nǝ nyi, kalar ndǝra gal, ju uya, ndǝra tsa umbwa tsu, nju pahǝna nyi. ");
INSERT INTO mfm_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ndǝ aˈyi wu pama hyi kǝra ar viya tada, ma zǝr nyi kǝdi ɗǝfau ba ja nǝ nyi tsǝka ya? ");
INSERT INTO mfm_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Əndǝga ma zǝr nyi kǝdi kalfi, ba ja nǝ nyi pabǝ ya? ");
INSERT INTO mfm_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ma nahyi, nji ɗǝɗǝmwaˈyi wu sǝni nǝ nyi anǝ wazhar hyi sǝ mǝmǝnahǝu, abari ngǝ Dǝrhyi kǝra a dǝmǝlma? Ju sa nǝ nyi sǝ mǝmǝnahǝ anǝ njira wu kǝdi sǝ ara ja, a ndiya nǝ dǝrhyi. ");
INSERT INTO mfm_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kalar sǝra hyu yiwu nja mǝl anǝ hyi, nahyi tsu ca nga hya mǝl anǝ nda, arya kǝ ca ngǝ sǝra highiɓǝ nǝ dlaɗau ǝnga nabiˈyar aga nyi. ");
INSERT INTO mfm_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Hya gwu ki lagur miyar gwa kǝra ciciɗǝu, arya miyar gwa ndar vir sa balangǝ nga ja ǝnga lagur ndari tsu ɓatsǝ nga nyi, njir nu laguwa nyi tsu, gangǝ nga nda. ");
INSERT INTO mfm_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ama miyar gwa nǝ uya pi, ciciɗǝ nga nyi. Ənga lagur gwa gwa tsu dzadzau nga nyi. Njir nu laguwa nyi aˈyi nda gangǝ mai. ");
INSERT INTO mfm_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Hya hangǝkal ǝnga nabi fatiˈyar, kǝra a vǝr shili ǝgya hyi a papa tǝmahǝu, ama jirkura nyi ufwar vuwa nga nda. ");
INSERT INTO mfm_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Hyu nda sǝnbiya nda lagur sǝr mǝla nda. A sǝn uya nji yayar wur inabi sara ar dza wur shikǝɗi ya? Əndǝga a sǝn uya nji yayar kanda sara ar dza wu shishikǝɗi ya? ");
INSERT INTO mfm_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Abangǝ tsu, kalar wu mǝnahǝu, ju ya wazha mǝnahǝu, wu kǝra gǝra mǝnahǝ tsu, ju ya wazha kǝra gǝra mǝnahǝu. ");
INSERT INTO mfm_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Wu kǝra mǝnahǝu, a sǝn yabiya wazha kǝra gǝra mǝnahǝ mai, abangǝ tsu, wu kǝra gǝra mǝnahǝu, a sǝn yabiya wazha mǝnahǝ mai. ");
INSERT INTO mfm_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kalar wu kǝra gǝra sǝn yabiya wazha mǝnahǝu, ba nja gǝmna nyi ba nja vakuwa nyi a gwu uˈu. ");
INSERT INTO mfm_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Agabangau, hyu nda sǝnbiya nda lagur sǝr mǝla nda. ");
INSERT INTO mfm_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Aˈyi kalar ndǝra wu na anǝ ɗa, ‘Thlagǝu, Thlagǝu,’ ngu nda gwu tǝlkur Hyal mai, ama kǝl ndǝra wu mǝl sǝra Dǝɗa kǝra a dǝmǝlmǝ wu yiwu. ");
INSERT INTO mfm_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ar pǝci ta, nji gangǝ nda na anǝ ɗa, ‘Thlagǝu, Thlagǝu! Naˈya aˈyi tǝtǝlna ndǝr Hyal wu thlǝmǝ ngǝ wa? Aˈyi ˈyi kǝdlǝbiya shatan wu thlǝmǝ ngǝ wa? Ənga aˈyi ˈyi mǝlna sǝ dǝdǝgurˈyar gangǝ wu thlǝmǝ ngǝ wa?’ ");
INSERT INTO mfm_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Abangau, ama yu nda shaɗǝwa nda, ‘Nayi wu sǝni hyi mai. Hya tǝkǝ ǝnga yau, nahyi njir mǝl ɗǝmwaˈyikur!’ ");
INSERT INTO mfm_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Agabangau, kalar ndǝra nggari ndǝr ɗa kau, ba ji mǝl thlǝr ǝni, ja nda ɗa ǝnggǝr ndǝ tsǝtsǝl ndǝra hǝriya ki nyi ar pathlara mau. ");
INSERT INTO mfm_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ənggǝra par tǝɗau, dlǝlǝmǝ nyau, yambaɗǝ sau, ba ji tsaɓǝr ki kau, ama naji dla mai, ara nji hǝriya nyi ar vi mǝmau. ");
INSERT INTO mfm_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kalar ndǝra nggari ndǝr ɗa kǝ tsu ba ji nggǝl ara mǝl thlǝr ǝni, ju nda ɗa ǝnggǝr ndǝ dza kǝra hǝriya ki nyi ar vi mǝshiˈwa. ");
INSERT INTO mfm_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ənggǝra par tǝɗau, dlǝlǝmǝ nyau, yambaɗǝ shili ka sa tsar ki kau, ba kiya nyi dla, dla nyi ma, dla didiɗi.” ");
INSERT INTO mfm_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ənggǝra Yesu kuɗǝna nana sǝˈyar kau ba highiɓǝ nyi kǝ ɗa sǝ dǝdǝgur anǝ dlamir nji. ");
INSERT INTO mfm_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ara ji highiɓǝ anǝ nda ǝnga dǝnama, aˈyi ǝnggǝr nǝ malǝmǝ dlaɗǝr ndaˈyar mai. ");
INSERT INTO mfm_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ta Yesu shida sara dar ma nyi, ba nji gangǝ nu nyi. ");
INSERT INTO mfm_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kǝ ndǝr pibi shili, ji sa ɓǝliya undi a dumwa nyi, ji na, “Thlagǝu, ma gu yiwu, gu sǝn mǝliya ɗa jamǝu.” ");
INSERT INTO mfm_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kǝ Yesu har tsi ka tsǝkwar nyi, ji na, “A hǝnggǝr yau,” “Ga ɗa cicau!” Ənggǝrna, ba pibiya nyi piyari nyi. ");
INSERT INTO mfm_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kǝ Yesu na anǝ nyi, “Ga hangǝkal ga sara na sǝ kǝ anǝ ndǝ mai. Ama ga maˈyi a ndǝgya pubu ga nda canǝ nyi kǝrngau, ga dzǝgwa kǝbǝna sau ǝnggǝra dlaɗǝ Musa nana nja mǝl aga ci dzau. Ga mǝliya abangǝ aga ga cabiya nyi anǝ nji abǝr a ɗar gǝ jamǝu.” ");
INSERT INTO mfm_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ənggǝra Yesu vu Kafarnahumu, kǝ vanyi dǝgalǝr soja nǝ Roma shili ǝgya ja, ju kǝdi dlǝwa dzǝ ara ja. ");
INSERT INTO mfm_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Thlagǝu,” ji na, “Ndǝr mǝl thlǝr anǝ ɗa a yi pida nga ja a ndu ki, naja sǝn shabiya dzǝ mai, ɓwaɓwatǝ nga ja gwa gagaɗau.” ");
INSERT INTO mfm_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kǝ Yesu na anǝ nyi, “Yi wu maˈyi, aga ya nda shilǝgǝbiya nyi.” ");
INSERT INTO mfm_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kǝ dǝgalǝr soja nǝ Roma shaɗǝwa, ji na, “Thlagǝu, nayi ɗa tsaˈa aga ga shili wu ki ɗa mai, ama ga nana ndǝr wacu, ba ndǝr mǝl thlǝr anǝ ɗa kǝ a ɗa jamǝu. ");
INSERT INTO mfm_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Arya nayi ǝnga kǝrɗa ma ǝgya ndǝ dǝgal nga yau, ǝnga tsu sojaˈyar aˈyi kǝra ǝgya kiɗa yau, yu na anǝ ndǝ kau, ‘Maˈyi,’ ba ja maˈyi, anǝ vanyi ndǝ tsu yu na ‘Shili,’ ba ja shili. Ma yi na anǝ mafa ɗa, ‘Mǝliya abangau,’ ba ja mǝliya.” ");
INSERT INTO mfm_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ənggǝra Yesu nggar ndǝr kau, ba ɗa sǝ dǝdǝgur anǝ nyi, ji shabiya dzau, ba ji na anǝ nji kǝra a vǝr nu nyi, “Ya nar hyi, wu Izirayila nayi sayi uya ndǝra ǝnga mbǝrsa ǝnga dǝnama ǝnggǝr ndǝ kǝ mai. ");
INSERT INTO mfm_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yu na anǝ hyi, abǝr gangǝ njir mbǝrsa wu nda shili sara wu sǝbiyar pǝci ǝnga gwa tǝɗǝ pǝci ndu sa nggya ndu sǝm sǝr sǝm nǝ caguli ǝnga Ibrahimu ǝnga Ishaku ba Yakubu wu tǝlkur Hyal. ");
INSERT INTO mfm_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ama nju sa vakuwa a gwu kuthlǝ nǝ kyakyaru njira a kyau nda ɗa nji Hyal, ama ba ndǝ nggǝl, vira hyu nda tiwi ǝnga hyu ɗǝ hira hyi ari.” ");
INSERT INTO mfm_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kǝ Yesu na anǝ dǝgalǝr soja nǝ Roma, “Maˈyi, wu ɗa anǝ ngau, kakalǝ ǝnggǝra gǝ mbǝrsa.” Ənggǝrna, kǝ ndǝr mǝl thlǝr nyi ta ɗa jamǝu. ");
INSERT INTO mfm_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ənggǝra Yesu vu ki Biturusu, kǝ ji thlǝwa miya mala Biturusu gǝvǝu a yi pida, gyangǝ a vǝr tǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kǝ ji tsǝkwari pǝla ja, kǝ gyanga nyi piyari nyi ba ji hyaˈari ji mǝliya nda sǝr sǝm. ");
INSERT INTO mfm_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ta wagǝ ɗa, nji gangǝ njira ǝnga mambǝl ɗǝmwaˈyi wu dza nda nji shili ǝnga nda anǝ Yesu, kǝ ji kǝdlǝbiya mambǝla nyiˈyar ǝnga ndǝr nyi. Abangǝ tsu kǝ ji shilǝgǝbiya patǝr njira gǝra ngga. ");
INSERT INTO mfm_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ji mǝl abangau, aga nyabiya sǝra nabi Əshaya nana, abǝr, “Ji hǝri sǝra wu tǝ mǝn ǝnga ji faˈari shilǝgǝr mǝn.” ");
INSERT INTO mfm_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ta Yesu lari dlamir nji gangǝ zǝwar nyi, kǝ ji sǝwa nja tǝrabiya ǝnga ja a biyar ya dǝl. ");
INSERT INTO mfm_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kǝ vanyi malǝmǝ nǝ dlaɗǝ shili, ji sa nar nyi, “Malǝmǝ, yu nu ngau, kalar vira gu maˈyi a ndari.” ");
INSERT INTO mfm_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kǝ Yesu shabiya nyi ji na, “Thlahu ǝnga kaˈu nga nda, ˈyagǝˈyar tsu kir nda aˈyi, ama zǝr ndau, vira ja fiya kǝra ja ari aˈyi mai.” ");
INSERT INTO mfm_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Vanyi zǝmbǝlma na anǝ nyi, “Thlagǝu, taˈyi ya maˈyi ya nda haɗǝna dǝɗa kwatahǝu.” ");
INSERT INTO mfm_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ama Yesu na anǝ nyi, “Nu ɗa, piyari nji tǝtǝ nda haɗǝna nji tǝtǝr nda.” ");
INSERT INTO mfm_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ənggǝra ji gwu kwambwal, kǝ zǝmbǝlma nyiˈyar nu nyi. ");
INSERT INTO mfm_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Fǝɗǝngǝkǝr nda, kǝ majigwal ǝnga dǝnama shili ar dǝla nyi, ji sa kǝnggǝɗǝr ˈyimiya nyi, kǝl ta ˈyimiya nyi gwu kwambwala nyi, ama Yesu nǝ nyi wu ghanyi nga ja. ");
INSERT INTO mfm_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kǝ ndǝ hyaˈari ndǝ nda hyaˈana nyi, ndu na anǝ nyi, “Thlagǝu, kǝtiya mǝn, kǝja mǝnu sa!” ");
INSERT INTO mfm_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ji shaɗǝwa, “Nahyi njira ǝnga mbǝrsa kushu, ara mi nga hyu hivǝra?” Kǝ ji hyaˈari ji kughiya majigwala nyi daɓǝ ǝnga kǝnggǝɗǝr dǝla nyi, kǝ patǝkura vi bǝgǝ zǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ba sǝ kǝ ɗa sǝ dǝdǝgur anǝ nji kau, ndǝ yiwa, “Wathlǝmǝ culi najaka nda? Patǝ ǝkkǝˈyi majigwal ǝnga dǝl wu gǝnggǝr nyi sǝli ka?” ");
INSERT INTO mfm_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ənggǝra ji shili arya dǝl nǝ ˈyiˈyir nǝ Gadarasanu. Kǝ nji mǝthlǝ ǝnga mambǝl ɗǝmwaˈyi shili sara wu hulili ndǝ sa thlǝwa nyi. Arya sǝr mǝla nda, ndǝ ɗa sǝra nja hivǝr gagaɗau, ka ɗa ma tsu ndǝr yiwu nu lagu ta aˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ənggǝrna, kǝ nji kǝ gwu wau, ndu na, “Mi ngǝ dzau ngau ǝnga ˈya, nagǝ Zǝr Hyala? Əndǝga gǝ shili aga ga sa nǝ ˈya ɓwaɓwatǝ tsu pǝcir ˈya gǝra ɗa ya?” ");
INSERT INTO mfm_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Lǝhǝ a dzǝr vi ta, ɓǝla fǝshiu aˈyi gangǝu kǝra a vǝr ɓǝla ar dza mau. ");
INSERT INTO mfm_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mambǝl ɗǝmwaˈyiˈyar kǝ kǝdi Yesu, “Ma gu kǝdlǝ ˈya a biya, sǝwa ˈya a ndu fǝshiˈyar kau.” ");
INSERT INTO mfm_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kǝ ji na anǝ nda, “Yau, maˈya mau.” Kǝ ndǝ biya, kǝ ndǝ gwu fǝsha nyi, kǝ fǝgǝ fǝsha nyi patǝ aga zǝmǝ hyaˈari ndǝ maˈyi, kǝ ndǝ gwa pau a gwar dǝl, ba ndǝ kuɗǝ ar ˈyimiya nyi. ");
INSERT INTO mfm_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Njir ɓǝla fǝsha nyiˈyar hwinakǝr, ta ndǝ vu huɗa mǝlmau, ba ndǝ vuwa nar nyi anǝ nji sǝra ɗa patǝu ǝnga sǝra ɗa ǝnga njira ǝnga mambǝl ɗǝmwaˈyi kau. ");
INSERT INTO mfm_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kǝ patǝkura njir mǝlmǝ biya aga nda ɓǝ ǝnga Yesu. Ta ndǝ lari nyi, kǝ ndǝ kǝdi nyi aga ja piyari nda ˈyiˈyir nda. ");
INSERT INTO mfm_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kǝ Yesu gwu kwambwal, kǝ ji tǝrabiya a biyar ya dǝl, ba ji maˈyi a ndu mǝlmǝ kǝra ji hǝ a gwa. ");
INSERT INTO mfm_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kǝ nji hǝr nyi vanyi ndǝ a shili a yi pida ar caɗǝu. Ənggǝra Yesu lari mbǝrsar nda, kǝ ji na anǝ ndǝ tǝsǝkǝnǝ kau, “A sara ga tal mai, zǝr ɗa, a tǝfǝbiya ngǝr yi bikǝ ngau.” ");
INSERT INTO mfm_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ənggǝra njir sǝn dlaɗǝ nggar abangau, kǝ ndǝ na anǝ kǝrnda, “Ndǝ kau, ju diɗa thlǝmǝr Hyal!” ");
INSERT INTO mfm_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Arya Yesu wu sǝni sǝra nda vǝr ɗǝnga, kǝ ji na anǝ nda, “Ara mi nga hyu ɗǝnga ɗǝmwaˈyi wu ɗǝfuwa hyi abanga? ");
INSERT INTO mfm_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mani nga ndiya ǝnga ɓatsa? Nja na, ‘A tǝfǝbiya ngǝr nji bikǝ ngau,’ ǝndǝga, ‘Hyaˈari ga ɓǝ ya?’ ");
INSERT INTO mfm_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ama yu yiwu hya sǝni, abǝr Zǝr Ndǝ aˈyi ja ǝnga dǝnama nǝ tǝfǝbiya bikǝ wu duniya.” Kǝ ji na anǝ ndǝr tǝsǝkǝnǝ kau, “Hyaˈari, ga hǝri caɗǝ ngau, ba ga maˈyi a ndu ki.” ");
INSERT INTO mfm_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ba nda nyi hyaˈari tsu, ba ji maˈyi a ndu ki nyi. ");
INSERT INTO mfm_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ta dlamir nji lari abangau, kǝ hivǝr mbari nda, kǝ ndǝ dlǝvǝ Hyal kǝra lǝri culi najaka dǝnama anǝ nji. ");
INSERT INTO mfm_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ənggǝra Yesu dumwa ǝnga ɓau, kǝ ji lari vanyi ndǝ kǝra nju ngga ǝnga Matiwu, ja vǝr nggya ar vir tsǝm budau. Kǝ Yesu na anǝ nyi, “Nu ɗa.” Kǝ ji hyaˈari ba ji nu nyi. ");
INSERT INTO mfm_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ənggǝra Yesu a vǝr sǝm sǝr sǝm wu ki Matiwu, kǝ njir tsǝm budǝ gangǝu ǝnga “njir bikǝ” shili ndǝ sa sǝm sǝr sǝm ǝnga ja ba ǝnga zǝmbǝlma nyiˈyar. ");
INSERT INTO mfm_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ənggǝra njir Farisi lari sǝ kau, ba ndǝ yiwa miya zǝmbǝlma nyiˈyar, “Ara mi ngǝ malǝmǝr hyu sǝm sau ǝnga njir tsǝm budau ba ǝnga ‘njir bikǝ ka’?” ");
INSERT INTO mfm_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ənggǝra Yesu nggari sǝ kau, kǝ ji na, “Nji jamǝ wu yiwu ligǝta mai, kǝl njira gǝra ngga. ");
INSERT INTO mfm_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ama maˈya mau hya nda ɗǝnga tara mi ngǝ ndǝr kǝ a gǝri, ‘Tǝhuɗǝ nga ya yiwu, aˈyi saɗaka mai.’ Ara nayi shili aga sa ngga nji tsapǝ mai, ama aga sa ngga njir bikau.” ");
INSERT INTO mfm_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kǝ zǝmbǝlma Yahwana ˈyar shili ara Yesu, ndǝ sa yiwa nyi, “Mi ngǝ ɗa zǝmbǝlma Yahwana ǝnga nǝ Farisi wu hǝ zǝmǝtsini ama nǝngau, nandǝ wu hǝ maya?” ");
INSERT INTO mfm_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kǝ Yesu shaɗǝwa nda, ji na, “Bazhiya salkwanjili a sǝn hǝ zǝmǝtsini ma tsu nda ǝkkǝˈyi ja ya? Nanda sǝn hǝ mai, ma tsu nda ǝkkǝˈyi ja. Pǝci wu shili nja sa hǝna salkwanjili ara nda. Wu pǝci ta nga nda dzǝgwa hǝ zǝmǝtsini. ");
INSERT INTO mfm_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ndǝr ndǝɓǝ zhaɓi hahal ǝnga mafǝliyangǝ aˈyi mai. Ma ji mǝl abangau, ba mafǝliyangǝ nga nyi a tana hahala nyi, ta nyi a dzǝgwa ndiya nǝ ɗǝɗǝmǝ ǝnga ɗǝmwaˈyu. ");
INSERT INTO mfm_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ətsu ndǝr puwa ˈyimi inabi mafǝliyangǝ a gwu pǝla hahal aˈyi mai. Ma ji mǝl abangau, ba ˈyimir inabi mafǝliyangǝ kǝ a thlǝnakǝr ba ja pǝthlǝna nyi, ba ˈyimir inabi kǝ a pǝnakǝr ba pǝla ka ndzau. ˈYimir inabi mafǝliyangǝ kǝl pǝla mafǝliyangǝu.” ");
INSERT INTO mfm_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ənggǝra Yesu a vǝr na sǝˈyar kau, kǝ ndǝ dǝgal nǝ umbwa daɓǝ dzǝ njir Yahudiya shili, kǝ ji sa ɓǝliya undi a dumwa nyi, kǝ ji na, “Kajangǝkau, kwaɗa a tǝri, ama shili ga sa fǝr tsi ar ja, ba ja mbǝɗau.” ");
INSERT INTO mfm_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kǝ Yesu hyaˈari ǝnga zǝmbǝlma nyiˈyar, ba ndǝ nu nyi. ");
INSERT INTO mfm_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kǝ vanyi mala kǝra mǝliya fa kumo apǝ mǝthlǝ a vǝr ndzǝndzǝ mashi, shili lagu ya ja, kǝ ji sa tsǝkwari miya cira lǝgutǝ Yesu. ");
INSERT INTO mfm_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Arya ja vǝr na wu ɗǝfuwa ja, “Ma yi sǝn tsǝkwar alaga miya cira lǝgutǝ nyi, yu ɗa jamǝu.” ");
INSERT INTO mfm_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ənggǝra Yesu shabiya dzau, ba ji lari nyi, kǝ ji na, “A sara ga tal kwaɗa mai, mbǝrsa ngau, a mǝliya ngǝr yi jamǝu.” Ənggǝrna, ba ji ɗa jamǝu. ");
INSERT INTO mfm_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ta Yesu shili wu ki ndǝ dǝgala nyi, kǝ ji lari njir mbǝɗi mbǝlau ǝnga nji tǝzǝwuɗǝwuɗǝu. ");
INSERT INTO mfm_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kǝr kǝ ji na, “Kwaya mau ǝnggau! Kwa kǝ tǝ mai, wu ghanyi nga ja.” Kǝ ndǝ nggushina nyi nggushi nǝ diɗa. ");
INSERT INTO mfm_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ama ǝnggǝra ji kǝdlǝbiya nda a biya, kǝ ji gwa ji gwa mbar tsa kwa nyi, kǝ ji hyaˈari aˈyi nggya. ");
INSERT INTO mfm_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ndǝr kǝ tǝtǝlna dzǝ wu ˈyiˈya nyi patǝu. ");
INSERT INTO mfm_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ənggǝra Yesu a vǝr piyari vi ta, kǝ nji lǝfǝ mǝthlǝ ndu nu nyi, ndu ngga ǝnga dǝnama, “Tǝhuɗǝ ǝgya ˈya, zǝr Dawuda!” ");
INSERT INTO mfm_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ənggǝra Yesu vu vanyi ki, kǝ lǝfa nyiˈyar shili ǝgya ja, kǝ ji yiwa nda, “A mbǝrsar hyi abǝr yu sǝn mbǝɗana hyi ya?” Ndǝ shaɗǝwa, “Angǝ, Thlagǝu.” ");
INSERT INTO mfm_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ənggau kǝ ji tsǝkwar liya nda, ji na, “Bǝgǝ ja ɗa anǝ hyi ǝnggǝra hyi mbǝrsa.” ");
INSERT INTO mfm_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kǝ liya nda pahau. Ənggǝ tsu, kǝ Yesu tǝɗar himiya nda, ji na, “A sara hya na sǝ kǝ anǝ nji mai.” ");
INSERT INTO mfm_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ama ndǝ biya ndǝ tǝtǝlna ndǝra nyi baˈamani wu ˈyiˈya nyi. ");
INSERT INTO mfm_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ənggǝra nda vǝr maˈyi a biya, kǝ nji shili anǝ Yesu ǝnga vanyi ndǝra mambǝl ɗǝmwaˈyi kar nyi ara ndǝr. ");
INSERT INTO mfm_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ənggǝra ji kǝdlǝbiya mambǝl ɗǝmwaˈya nyi a biya, ba ndǝ mǝga nyi mbar ndǝr. Kǝ sǝ kǝ ɗa sǝ dǝdǝgur anǝ daɓǝr dlami, ndǝ na, “Sǝ aˈyi ǝnggǝr kǝ saya ɗa wu Izirayila nji lar mai.” ");
INSERT INTO mfm_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ama njir Farisi nǝr nda, ndǝ na, “Ənga dǝnama nǝ tǝl shatan nga ju kǝdlǝ wazha shatan kau.” ");
INSERT INTO mfm_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ənggau, Yesu ɓǝbiya ɓau wu patǝr ˈyiˈyir Galili, ja vǝr highiɓǝ wu umbwa daɓǝ dzǝˈyar, ja vǝr tǝtǝlna ndǝshigu ar kǝra tǝlkur Hyal. Ba ǝnga ja vǝr shilǝgǝbiya kalar shilǝgǝu ǝnga njira gǝra ngga. ");
INSERT INTO mfm_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ta ji lari nji gangǝ daɓau, kǝ ji tǝhuɗǝ ǝgya nda, ara nda vǝr lari ɓwaɓwatǝu, ba tsu dlǝwa dzǝ aˈyi mai, ǝnggǝr tǝmahǝ kǝra gǝra ǝnga ndǝr ɓǝla. ");
INSERT INTO mfm_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kǝ ji na anǝ zǝmbǝlma nyiˈyar, “Sǝr faˈa a su ki gangǝ nyi, ama njir mǝl thlǝr kushu nga nda. ");
INSERT INTO mfm_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Agabangau, hya kǝdi thlagǝr fa, ja sǝwa njir mǝl thlǝr aga nda sa faˈa sǝ a su ki.” ");
INSERT INTO mfm_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kǝ Yesu nggar zǝmbǝlma nyiˈyar kumo apǝ mǝthlǝu. Kǝ ji nǝ nda dǝnama aga nda kǝdlǝbiya mambǝl ɗǝmwaˈyu ǝnga nda shilǝgǝbiya kalar culi shilǝgǝu ǝnga nji gǝra ngga. ");
INSERT INTO mfm_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kǝja thlǝmǝr cama sǝsǝ kumo apǝ mǝthlǝ ˈyar kau. Tanggǝrma Simanu ndǝra nju ngga ǝnga Biturusu ǝnga zamǝ nyi Andǝrawusu ǝnga Yakubu zǝr Zabadi ǝnga zamǝ nyi Yahwana ");
INSERT INTO mfm_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ǝnga Fǝlipǝu ǝnga Bathlalomiyu ǝnga Toma ǝnga Matiwu ndǝr tsǝm budau ǝnga Yakubu zǝr Alfawusu ǝnga Tidiyawusu ");
INSERT INTO mfm_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ǝnga Simanu ndǝr Kanaˈana ba ǝnga Yahuda Isikarayoti ndǝra thlǝna hiya Yesu. ");
INSERT INTO mfm_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu sǝwa cama sǝsǝ kumo apǝ mǝthlǝu, ji na anǝ nda, “A sara hya ndǝgya njira aˈyi njir Yahudiya mai ǝnga ǝtsu a sara hya vu mǝlmǝ njir Samariya mai. ");
INSERT INTO mfm_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ama kǝl hya maˈyi a ndǝgya njir Izirayila kǝra ǝnggǝr tǝmahǝ sasa. ");
INSERT INTO mfm_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Hya maˈyi hya nda tǝtǝlna nda ndǝr Hyal abǝr, ‘Tǝlkur Hyal a ɗar lǝhǝu.’ ");
INSERT INTO mfm_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Hya shilǝgǝbiya njira gǝra ngga ǝnga hya hyaˈana nji tǝtau ǝnga hya shilǝgǝbiya njir pibi aga nda ɗa cicau, ǝtsu hya kǝdlǝbiya mambǝl ɗǝmwaˈyi wu dza nji. Kurthlǝ nga hyi dlǝwuri ǝnga hya lǝri kurthlǝ tsu. ");
INSERT INTO mfm_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ma hyu maˈyi, a sara hya sǝɓǝ gǝnna mai. ");
INSERT INTO mfm_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","A sara hya sǝɓǝ mbǝl mai, alaga zaɓǝkwa lǝgutǝu ǝnga ɓiɓi ǝnga zǝwa mai, ara ndǝr mǝl thlǝr a kyaga uya akkǝri nǝ thlǝr nyi. ");
INSERT INTO mfm_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kalar mǝlmǝ dǝdǝgalǝu, alaga mǝlmǝ kukushu kǝra hyu nda gwa, hya galǝri ndǝ ɗǝfu camǝu aga hya nggya ǝnga ja baˈanǝ pǝci kǝra hyu nda piyari viya nyi. ");
INSERT INTO mfm_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ma hyu vu ki kau, hya usar nda. ");
INSERT INTO mfm_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ma ki nji ɗǝfu camǝ ngau, hya kǝdi Hyal ja nǝ nda jamǝkur, ama ma kiya nyi aˈyi ki nji mǝnahǝ mai, bǝgǝ jamǝkur Hyal a sha shili ara hyi. ");
INSERT INTO mfm_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kalar ndǝra gǝra dlǝwur hyi ǝnga gǝra sǝya hyi himi, hya dlǝɗǝna bǝbǝr kǝra ar hiya hyi ma hyu biya sara wu kiya nyi ǝnga mǝlma nyi. ");
INSERT INTO mfm_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ənga jiri, yu na anǝ hyi, Hyal wu nda tǝhuɗǝ ǝgya njir Sodomu ǝnga njir Gwamwara a ndiya njir mǝlmǝ kau, ar pǝcir numa. ");
INSERT INTO mfm_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Kǝja yu sǝ hyi a biya ǝnggǝr tǝmahǝ kǝra wu pama ufwar vuwa ˈyar. Agabangǝ hya nggya hahangǝu ǝnga tsu hya nggya ǝnga kiˈwakur. ");
INSERT INTO mfm_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Hya hangǝkal ǝnga nji, ara ndu nda wulana hyi anǝ njir pathla ǝnga ndu nda dǝgǝ hyi ǝnga wuɗa wu umbwa daɓǝ dzǝˈyar. ");
INSERT INTO mfm_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Arya yi tsu, ndu nda hǝr hyi a ndumwar nji nggunggurǝm ǝnga tǝltǝlˈyar, aga hya nar nda ndǝshigu mǝsahǝu ǝnga anǝ njira aˈyi njir Yahudiya mai. ");
INSERT INTO mfm_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ar pǝci kǝra ndǝ mbari hyi, a sara hya tal sǝra hyu nda na mai ǝnga ǝnggǝra hyu nda na, ara Hyal wu nda nǝ hyi sǝra hyu nda na ar pǝci ta. ");
INSERT INTO mfm_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Arya aˈyi nahyi ngu nda ndǝr mai. Ama Mambǝl Dǝr hyi ngu nda ndǝr lagur hyi. ");
INSERT INTO mfm_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Zamǝ wu nda lǝri zamǝ nyi aga nja tsǝya nyi. Tada tsu wu nda lǝri zǝr nyi. Abangǝ tsu wazha ndu nda hyaˈana hangǝkala njir yar nda, ba ja tǝkǝri nja tsǝya nda. ");
INSERT INTO mfm_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nji patǝ wu nda piyari shishir dza hyi arya yau. Ama ndǝra cinapi baˈanǝ kuɗiya, ju uya mbǝɗau. ");
INSERT INTO mfm_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kalar pǝci kǝra nji lǝr ɓwaɓwatǝ anǝ hyi wu vanyi mǝlmǝ, hya hwi a ndu mǝlmǝ kǝra a ndumwar hyi. Ənga jiri yu nar hyi, abǝr divira hyi ɓǝbiya ɓǝ patǝ wu mǝlmǝ Izirayila, Zǝr Ndu ɓǝra shida. ");
INSERT INTO mfm_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Zǝmbǝlma aˈyi a sǝn ndiya malǝmǝ nyi mai ǝnga tsu mafa aˈyi a sǝn ndiya thlagǝr ki nyi mai. ");
INSERT INTO mfm_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","A ɗar tsaˈa anǝ zǝmbǝlma ja ɗa ǝnggǝr malǝmǝ nyi, mafa tsu ja ɗa ǝnggǝr thlagǝr ki nyi. Ma ndǝ ngga thlagǝr ki ǝnga Bilzabulu, abari nga ndu nda na ar kǝra njir ki ka? ");
INSERT INTO mfm_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Agabangau, a sara hya hivǝr nda mai, arya sǝ aˈyi kǝra ndu mǝl ɗǝɗǝwa kǝra gǝra nda biyar babal mai, ǝtsu sǝ aˈyi ɗǝɗǝwa kǝra nji gǝra nda sǝn mai. ");
INSERT INTO mfm_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sǝra yu na anǝ hyi ɗǝɗǝwa, hyu nda hǝˈuna ar babal. Sǝra yi cici a gwu himiya hyi, hyu nda hǝˈuna a dar dzaˈwu. ");
INSERT INTO mfm_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","A sara hya hivǝr ndǝra wu sǝn tsǝya kumǝr dza hyi mai, ama naji wu sǝn tsǝya mambǝlǝr hyi mai. Kǝl hya hivǝr ndǝra wu sǝn tsǝya kumǝr dza hyi ǝnga mambǝlǝr hyu uˈur kǝtsa. ");
INSERT INTO mfm_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Aˈyi nju ɗǝlna wazha ˈyagǝ mǝthlǝ ar kǝra peni pathlǝ wa? Ya, zǝma nda aˈyi sǝn tǝɗǝ a gyiwu ˈyi gǝra ǝnga sǝni Dǝr hyi mai. ");
INSERT INTO mfm_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Shishir kǝra hyi ma jijiga nga nda. ");
INSERT INTO mfm_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Agabangau, a sara hya hivǝr mai. A ndiyar hyi wazha ˈyagǝ ǝnga mǝnahǝ gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kalar ndǝra hǝnggǝr abǝr naja nǝɗa nga ja a dumwar nji, nayi tsu, yu nda hǝnggǝr abǝr nǝɗa nga ja a dumwar Dǝɗa kǝra a dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ama kalar ndǝra kǝpalna sǝn ɗa a dumwar nji, nayi tsu yu nda kǝpalna sǝni nyi a dumwar Dǝɗa kǝra a dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“A sara hya nggani abǝr yi shili ǝnga nggya jamǝ wu duniya mai. Aˈyi aga nggya jamǝ nga yi shili mai, ama aga sa pa. ");
INSERT INTO mfm_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","A shilir yi aga sa daɓǝ “ ‘tada ǝnga zǝr nyi ar pa, zǝr kwa tsu ǝnga mǝnyi, mala tsu ǝnga miya sal nyi. ");
INSERT INTO mfm_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Njir huɗa ki nyi tsu ngu nda ɗa dawa nyi.’ ");
INSERT INTO mfm_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Kalar ndǝra wu yiwu mǝnyi alaga dǝnyi a ndiya ɗa, aˈyi ja kyaga ɗa nǝɗa mai. Ətsu kalar ndǝra wu yiwu zǝr nyi alaga kwa nyi a ndiya ɗa, aˈyi ja kyaga ɗa nǝɗa mai. ");
INSERT INTO mfm_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kalar ndǝra gǝra hǝri wu dladlakǝ nyi, ja dzǝgwa nu ɗa, aˈyi ja kyaga ɗa nǝɗa mai. ");
INSERT INTO mfm_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kalar ndǝra wu yiwu piya ja, ju nda tini. Ndǝra gǝra yiwu piya ja arya yau, ju nda uya. ");
INSERT INTO mfm_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kalar ndǝra dlǝwuri hyi, a dlǝwuri ɗar ja, kalar ndǝra dlǝwuri ɗa tsu, a dlǝwuri ja ndǝra sǝwa ɗa. ");
INSERT INTO mfm_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kalar ndǝra dlǝwuri nabi ara naja nabi, ju nda uya akkǝri nǝ nabi. Ətsu kalar ndǝra dlǝwuri ndǝ tsapǝu ara naja ndǝ tsapǝu, ju nda uya akkǝri nǝ ndǝ tsapǝu. ");
INSERT INTO mfm_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kalar ndǝra lǝri anǝ pathlǝu wu pama wazha yiɗǝɗǝ kau, ˈyimi shishiˈwu kikiwa pathlǝu, arya naja ndǝr nu ɗa, ǝnga jiri yu nar hyi, aˈyi ju nda tini akkǝri nyi mai.” ");
INSERT INTO mfm_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ayukuɗa Yesu kuɗǝna highiɓǝ anǝ zǝmbǝlma nyiˈyar kumo apǝ mǝthlǝu, kǝ ji hyaˈari sara ndǝna, kǝ ji maˈyi ja vǝr highiɓau ǝnga tǝtǝlna ndǝr Hyal wu mǝlmǝ njir Yahudiya. ");
INSERT INTO mfm_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ar pǝci kǝra Yahwana tsu ja wu fursǝna, kǝ ji nggari sǝra Kǝrsiti a vǝr mǝl, kǝ ji sǝwa zǝmbǝlma nyiˈyar a ndǝgya ja ");
INSERT INTO mfm_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ndǝ nda yiwa, “Nagǝ ngǝ ndǝra wu shili ta ya, ǝndǝga ˈya sǝkǝ vanyi ndǝ pamǝ ya?” ");
INSERT INTO mfm_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Kǝ Yesu shaɗǝwa nda, ji na, “Sha mau hya nda nar nyi anǝ Yahwana sǝra hyi lari ǝnga hyi nggari. ");
INSERT INTO mfm_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nji lǝfǝ wu lar sau, nji kukurɓǝ wu ɓau, njir pibi wu uya jamǝkur, kulangǝˈyar tsu ndu nggar sau, nju hyaˈana nji tǝtau ǝnga nju tǝtǝlna ndǝshigu mǝsahǝ anǝ nji ɗaɗali. ");
INSERT INTO mfm_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Barka anǝ ndǝra gǝra tǝkǝkǝr ǝnga mbǝrsa nyi ar kǝra yau.” ");
INSERT INTO mfm_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ayukuɗa njira Yahwana sǝwa maˈyi, kǝ Yesu dzǝguya ndǝr anǝ nji ar kǝra Yahwana, ji na, “Mi nga hyi gwa tsamǝ a gwar tagǝ ta? Hyi maˈyi a gwa tsamǝ sar dzǝdzǝgamǝu, kǝra yambaɗǝ a vǝr kǝnggǝɗǝ ya? ");
INSERT INTO mfm_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ya, mi nga hyi maˈyi a gwa tsama? Ndǝra har kar mǝnahǝ ya? Awau, njir ha kar mǝmǝnahǝu, wu ki tǝl nga nda. ");
INSERT INTO mfm_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kar ɗǝm ya, mi nga hyi maˈyi a nda tsama? Nabi ya? Pakatu, yu nar hyi, ndǝra ndiya nabi. ");
INSERT INTO mfm_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Naja ngǝ ndǝra nji tsǝfǝri ar kǝri abǝr, “ ‘Kǝja yu sǝwa cama ɗa wu mwa ngau, ju nda fuwa sǝ wu lagu kadivira ga shili.’ ");
INSERT INTO mfm_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jiri nga yu na anǝ hyi, wu pama njira mathlǝkǝˈyi ngǝ ya patǝu, ndǝra ndiya Yahwana ǝnga dǝgal aˈyi mai. Ama alaga abangau, ndǝra ndiya ǝnga kushu wu tǝlkur Hyal a ndiya nyi ǝnga dǝgalǝu. ");
INSERT INTO mfm_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mbari ar pǝcir Yahwana ndǝr mǝl Baɓǝtizǝma baˈanǝ kabangǝkau, tǝlkur Hyal a vǝr lar ɓwaɓwatǝ ara nji, njir lǝ ɓwaɓwatǝ kǝ ngu yiwu nda dlǝwuri ǝnga dǝnama. ");
INSERT INTO mfm_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Arya patǝr ndǝr nabiˈyar ǝnga dlaɗǝ Musa a ndǝr nda ar kǝra sǝˈyar kau, kadivira Yahwana dzǝgwa shili. ");
INSERT INTO mfm_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ənga tsu, ma hyu hǝnggǝr ǝnga sǝra ndǝ na, naja ngǝ Iliya kǝra ndǝ na wu nda shili. ");
INSERT INTO mfm_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ndǝra ǝnga himi nggar sau, bǝgǝ ja nggari. ");
INSERT INTO mfm_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ya, ǝnga mi nga nja gǝla nji kabangǝka? Abari nga nda? Nanda ǝnggǝr wazha kǝra a vǝr nggya ar sugu, nda vǝr ngga kuvwar nda, ndu na: ");
INSERT INTO mfm_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ ‘ˈYi mbiɗiya hyi mbǝlau, kǝ hyi nggǝl ara fǝl. ˈYi thlǝ na nǝ tiwi, ba hyi nggǝl ara dlǝwu.’ ");
INSERT INTO mfm_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ta Yahwana shili, naji wu sǝm sǝr sǝm cumu mai ǝnga naji wu sa sǝ sasa mai, ǝngwar nda, ‘Naja ǝnga mambǝl ɗǝmwaˈyu.’ ");
INSERT INTO mfm_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Zǝr Ndǝ shili ju sǝm, ǝnga ju sa, ǝngwar hyi, ‘Ndǝr suna nga ja, bazhiya njir tsǝm budau ǝnga “njir bikau.” ’ Alaga abangau, patǝr njira hǝnggǝri ǝnga hahangǝkur nǝ Hyal, nda vǝr cabiya abǝr ǝnga jiri nga nyi.” ");
INSERT INTO mfm_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kǝ Yesu kughiya kughi anǝ mǝlmǝ pamǝpamǝ kǝra ji mǝlna badǝgala sǝ dǝdǝgurˈyar a gwa, ara njir mǝlma nyiˈyar aˈyi ndǝ tubi mai. ");
INSERT INTO mfm_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Sǝr tǝhuɗǝ anǝ ngau, Korazinu! Sǝr tǝhuɗǝ anǝ ngau, Bethlesaida! Maja abǝr sǝ dǝdǝgur kǝra nji mǝliya wu gau, nji mǝliya wu Taya ǝnga Sidonu, a tubir nda tsu kaɗǝ lagur hari lǝgutǝ sǝˈyinggu ǝnga tǝwa bǝbǝr wu kǝra nda. ");
INSERT INTO mfm_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ama yu na anǝ ngau, ar pǝcir numa nǝ Hyal ju nda tǝhuɗǝ ǝgya Taya ǝnga Sidonu a ndiya ngau. ");
INSERT INTO mfm_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nahyi tsu njir Kafarnahumu! Hya vǝr nggani abǝr nja nda faˈar hyi a dǝmǝlmǝ ya? Awau! Nahyi ma a gyiwu kaˈu ɗǝmwaˈyi nga nju nda puwa hyi. Maja abǝr sǝ dǝdǝgur kǝra nji mǝliya wu hyi, nji mǝliya wu Sodomu, tsu nda aˈyi baˈanǝ kabangǝkau. ");
INSERT INTO mfm_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ama yu na anǝ hyi, ar pǝcir numa nǝ Hyal ju nda tǝhuɗǝ ǝgya Sodomu a ndiya hyi.” ");
INSERT INTO mfm_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ar pǝci kǝ ngǝ Yesu na, “Dǝɗa, Thlagǝ kǝra a dǝmǝlmǝ ǝnga a gyiwu ˈyi, a usa ngǝr yau, arya gǝ ɗǝwana sǝˈyar kǝ anǝ nji hahangǝ ǝnga njir sǝn sau, ba gǝ dzǝgwa cabiya nyi anǝ njira ǝnggǝr wazha yiɗǝɗǝu. ");
INSERT INTO mfm_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Abangǝ nga nyi Tada, arya najakǝ ca ngǝ ɗa mǝnahǝu anǝ ngau. ");
INSERT INTO mfm_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Dǝɗa a nǝ ɗar sǝ patǝu, ndǝr sǝn sǝnbiya tara wa ngǝ zǝra nyi aˈyi mai, kǝl Dǝnyi wacu, abangǝ tsu ndǝr sǝn sǝnbiya tara wa ngǝ Tada nyi aˈyi mai, kǝl zǝr nyi ǝnga njira ju yiwu ja cabiya nda. ");
INSERT INTO mfm_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Shila mau ǝgya yau, patǝ hyi njira ǝnga kar tǝdǝɓǝu, nji hǝhǝɗa, ba ya nǝ hyi ɓǝlsar. ");
INSERT INTO mfm_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Dlǝwura mau danggal ɗa wu gyiwuliya hyi ǝnga hya highiɓǝri ara yau, ara nayi ndǝ hangǝkal ǝnga ndǝra wu hǝya kǝrngau, ba hya sa uya ɓǝlsar anǝ ɗǝfuwa hyi. ");
INSERT INTO mfm_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ara danggal ɗa kakafǝ nga nyi, kar ɗa tsu aˈyi tǝdǝɓǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ar pǝci ta, vanyi pǝcir Ɓǝlsar nǝ Yahudiya Yesu ǝnga zǝmbǝlma nyiˈyar nda vǝr tǝrabiya wu fa uhi. Nda vǝr ɓau kǝ zǝmbǝlma nyiˈyar kuratsiya kǝra uhi. ");
INSERT INTO mfm_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ənggǝra njir Farisi lari abangau, kǝ ndǝ na anǝ nyi, “Lari gǝyi, zǝmbǝlma ngǝˈyar nda vǝr mǝl sǝra dlaɗǝ kari nja mǝl pǝcir ɓǝlsar.” ");
INSERT INTO mfm_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kǝ ji shaɗǝwa nda, “Aˈyi hyi saya jigana sǝra Dawuda ǝnga njir ɓǝ nyi mǝliya ar pǝci kǝra wuɓǝ mbar nda ta wa? ");
INSERT INTO mfm_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ənggǝra ji gwu ki Hyal, naja ǝnga njir ɓǝ nyiˈyar, ǝnga ǝnggǝra ndǝ gwa sǝmku macikǝl cicau kǝra nandu kyaga sǝm mai, kǝl pubuˈyar wacu. ");
INSERT INTO mfm_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Əndǝga aˈyi hyi saya jigana wu dlaɗǝ Musa, ǝnggǝra ar pǝcir ɓǝlsar pubuˈyar ɓǝlna sǝra dlaɗǝ na nja ɓǝlari wu ki Hyal, lagur thla sǝ anǝ Hyal wa, ama aˈyi ɗa bikǝ anǝ nda mai wa? ");
INSERT INTO mfm_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yu na anǝ hyi ja, kǝja ndǝra wu ndiya ki Hyal ǝnga dǝgal ǝnggau. ");
INSERT INTO mfm_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ama, maja abǝr hyu sǝni sǝra ndǝr kǝ cabiya, ‘Tǝhuɗǝ nga ya yiwu, aˈyi saɗaka mai,’ nahyi aˈyi wu nǝ nyi bikǝ anǝ ndǝra gǝra ǝnga bikǝ mai. ");
INSERT INTO mfm_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ara Zǝr Ndau Thlagǝ nga ja ar kǝra pǝcir ɓǝlsar.” ");
INSERT INTO mfm_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kǝ Yesu piyari viya nyi, ba ji maˈyi a gwu umbwa daɓǝ dzǝ njir Yahudiya. ");
INSERT INTO mfm_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","A vuna vanyi ndǝ aˈyi ǝnga tsi ndzǝndzau. Ndu yiwu nda vazǝya Yesu, ba ndǝ yiwa nyi, “A ɗar tsaˈa nja shilǝgǝbiya ndǝ pǝcir ɓǝlsar ya?” ");
INSERT INTO mfm_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kǝ ji na anǝ nda, “Ma ɗa ndǝ aˈyi wu pama hyi kǝra ǝnga tǝmahǝ pathlǝu, ba ji tǝɗau a gu kaˈu pǝcir ɓǝlsar, thlagǝr tǝmahǝ kǝ aˈyi ju hǝbiya nyi a biya wa? ");
INSERT INTO mfm_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ya, kǝja ndǝ a ndiya tǝmahǝ ǝnga mǝnahǝ gagaɗau. Agabangau, a ɗar tsaˈa nja mǝl sǝra mǝnahǝ ar pǝcir ɓǝlsar.” ");
INSERT INTO mfm_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kǝ ji na anǝ nda nyi, “Ndiɗǝbiya tsa gǝ a dumwa ngau.” Aga zǝmǝ kǝ ji ndiɗǝbiya tsa ja a dumwa nyi, ba tsa ja ɗa jamǝ ǝnggǝr vanyi zǝma nyi ta. ");
INSERT INTO mfm_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ama ba njir Farisi maˈyi a biya ndǝ biya mbiya miya lagu kǝra nda sǝn tsǝya Yesu. ");
INSERT INTO mfm_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ənggǝra Yesu sǝnbiya abangau, ba ji piyari viya nyi. Kǝ nji gangǝ nu nyi, ba ji shilǝgǝbiya nda patǝu. ");
INSERT INTO mfm_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ji tǝɗǝr himiya nda ara nda sara na anǝ nji tara wa nga ja. ");
INSERT INTO mfm_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ji mǝl sǝˈyar kǝ aga nyabiya sǝra nabi Əshaya nana ngau, abǝr: ");
INSERT INTO mfm_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kǝja mafa ɗa kǝra nayi ngǝ caɗǝbiya nyi, yu yiwu nyi ara ji pina huɗa yau, yu nda nyana nyi ǝnga Mambǝl ɗa, ǝnga ju nda hǝˈuna abǝr yu nda numa nǝ jirkur anǝ nji patǝu. ");
INSERT INTO mfm_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Naja aˈyi wu nda pa ǝnga hyaˈa ɗahǝ mai, ǝnga ndǝr nda nggar ɗaha ja wu huɗa giwa aˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Naji wu nda ɓǝlna sǝra lǝhǝ ja ɓǝl mai, ǝnga pitǝlla kǝra a ɗar lǝhǝ ja tau, naji wu nda tsǝya mai, kǝl ji lari abǝr jirkur a sǝmkuri tǝlkur. ");
INSERT INTO mfm_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Njir duniya wu nda fiya fǝrkǝr nda wu thlǝmǝ nyi.” ");
INSERT INTO mfm_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kǝ ndǝ shili ǝnga vanyi ndǝr mǝga lǝfǝ kǝra nyinyau ǝnga mambǝl ɗǝmwaˈyu. Kǝ Yesu shilǝgǝbiya nyi, kǝl ta ju sǝn ndǝr ǝnga ju lar sau. ");
INSERT INTO mfm_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ba ɗa sǝ dǝdǝgur anǝ nji patǝu, kǝ ndǝ na, “Aˈyi zǝr Dawuda ta ngǝ kǝ wa?” ");
INSERT INTO mfm_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ama ǝnggǝra njir Farisi nggari abangau, ba ndǝ na, “Ənga dǝnama nǝ Bilzabulu tǝlǝr shatan ngǝ ndǝ kǝ wu kǝdlǝ mambǝl ɗǝmwaˈyi a biya.” ");
INSERT INTO mfm_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ta ɗa, Yesu wu sǝni sǝra ndu ɗǝnga, kǝ ji na anǝ nda, “Kalar tǝlkur kǝra tǝkǝbiya dzǝ mǝthlǝ wu taˈyi mai, ǝnga kalar mǝlmǝ ǝnga ki kǝra aˈyi hǝnggǝr ǝnga kuvwa nyi mai, nanda aˈyi wu sǝn taˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ma Shatan ngu kǝdlǝ Shatan, ya, a tǝkǝbiyar ja dzau. Ya, abari ngǝ tǝlkur nyi a sǝn taˈya? ");
INSERT INTO mfm_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ma ǝnga dǝnama nǝ Bilzabulu nga yu kǝdlǝ mambǝl ɗǝmwaˈyiˈyar, kar zǝmbǝlmar hyiˈyar tsu? Ənga mi nga ndu kǝdla? Agabangau, nanda ngu nda mǝl numa anǝ hyi ar kǝra sǝˈyar kau. ");
INSERT INTO mfm_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ama ma ɗa ǝnga dǝnama nǝ Hyal nga ya vǝr kǝdlǝ mambǝl ɗǝmwaˈyiˈyar kau, a ɗari abǝr tǝlkur Hyal a shiliri anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ənga jiri, ndǝr sǝn vu ki ndǝr dǝnama ja vuwa faˈana kar nyi aˈyi mai, kǝl tanggǝrma ji mbiya ndǝr dǝnama kau. Ja dzǝgwa sǝn faˈar kar nyi. ");
INSERT INTO mfm_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ndǝra gǝra ǝnga yau, dawa ɗa ngau, ǝnga ndǝra gǝra a vǝr kaɓǝ ǝnga yau, tǝtǝlna nga ja vǝr tǝtǝlna. ");
INSERT INTO mfm_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Agabangau, yu na anǝ hyi, kalar bikau ǝnga ndǝr diɗa Hyal ju nda tǝfǝbiya nyi anǝ nji. Ama ndǝra ndǝr diɗa ar kǝra Mambǝl Cicau, naji wu uya tǝfǝbiya dzǝ mai. ");
INSERT INTO mfm_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ma ndǝra ndǝr diɗa ar kǝra Zǝr Ndau, nju nda tǝfǝbiya nyi. Ama ndǝra ndǝr nǝ diɗa ar kǝra Mambǝl Cicau, naji wu uya nja tǝfǝbiya nyi mai, alaga kabangǝkau ǝnga zaman kǝra a vǝr shili. ");
INSERT INTO mfm_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Mǝliya wu mǝnahǝu ba yayar wa nyi a ɗa mǝnahǝu. Ga mǝliya wu ɗǝmwaˈyi tsu ba yayar wa nyi a ɗa ɗǝmwaˈyu, ara ar yayar wu nga nju tsamǝr wu. ");
INSERT INTO mfm_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nahyi daɓǝ mǝtsapaˈyar, lagu mani nga hyi, nahyi njira ɗǝmwaˈyi a sǝn nana sǝra mǝnaha? Ara sǝra wu ɗǝfu ca ngǝ miya wu nana. ");
INSERT INTO mfm_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ndǝ mǝnahǝu, ju biya ǝnga ndǝr mǝnahǝu sara ar vira ji ɗǝwana ari, ǝnga ndǝ ɗǝmwaˈyu, ju biya ǝnga ndǝr ɗǝmwaˈyu sara ar vira ji ɗǝwana nda ari. ");
INSERT INTO mfm_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ama yu na anǝ hyi, ar pǝcir numa kalar ndu nda lǝri sakida ar kǝra kalar ndǝr didiɗi kǝra biya sara wu miya ja. ");
INSERT INTO mfm_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ara arya ndǝr kǝra biya sara wu miya gau, nga nju nda mǝl numa anǝ ngau, tara nǝ pǝlna ngau ǝnga nǝ mbiya ngau.” ");
INSERT INTO mfm_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kǝ alenyi malǝmǝ dlaɗǝˈyar ǝnga njir Farisi na anǝ nyi, “Malǝmǝ, ˈyi wu yiwu ga mǝliya ˈya sǝ dǝdǝgur kǝra wu ɗa mǝtsamǝ sara ara gau.” ");
INSERT INTO mfm_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kǝ ji shaɗǝwa nda, ji na, “Nji nǝ zaman kau, nji ɗǝmwaˈyu, nji gǝra hivǝr Hyal. Ndu yiwu nda lari mǝtsamǝ nǝ sǝ dǝdǝgur. Ama mǝtsamǝ nǝ sǝ dǝdǝgur aˈyi kǝra yu ca anǝ nda mai, kǝl mǝtsamǝ ar kǝra nabi Yunana. ");
INSERT INTO mfm_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ara ǝnggǝra Yunana mǝliya pida makǝr vuˈyi ǝnga puci wu ta kalfi dǝgalǝu, abangǝ ngǝ Zǝr Ndu nda mǝliya a gyiwu huɗa ˈyiˈyi. ");
INSERT INTO mfm_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ara ar pǝcir numa, njir Niniva wu nda hyaˈari ǝnga njir zaman kau, ba nda canǝ nda abǝr nanda aˈyi mǝliya sǝra kakalǝ mai, arya nanda njir Niniva tubi ar pǝcira Yunana tǝtǝlna nda ndǝr Hyal. Ya, kǝja ndǝra ndiya Yunana aˈyi ǝnggau. ");
INSERT INTO mfm_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ar pǝcir numa, kwatam Shiba wu nda hyaˈari ǝnga njir zaman kau, ja cabiya nda abǝr nanda aˈyi mǝliya sǝra kakalǝ mai, ara ji hyaˈari sara ar kuɗiyar duniya vira naɗǝu aga ja sa nggar ndǝr tsǝtsǝlkur nǝ Tǝl Solomanu. Ya, kǝja ndǝra ndiya Solomanu aˈyi ǝnggau. ");
INSERT INTO mfm_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ma nji kǝdlǝbiya mambǝl ɗǝmwaˈyi a biya sara wu dza ndau, ma ji gal vir sǝ hǝɗa katini, ");
INSERT INTO mfm_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ju sǝn na, ‘Ya ɓǝra sha a ndu dza ndǝra yi biya sara a gwa.’ Ma ji ɓǝra sha shili, ba ji sa thlǝwa dzǝ kau, nji tsǝkǝbiya camǝu, ǝnga kalar sǝ wu lagu, ");
INSERT INTO mfm_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ba ja ɓǝra sha, ja nda faˈari mambǝlˈyar pamǝpamǝ mǝɗǝfǝ kǝra ndiya nyi ǝnga shishikur, ba nda maˈyi a vu ja nda vuwa nggya. Ba nggyabiya ndǝ kǝ nǝ yukuɗǝu, a ndiya nǝ tanggǝrma ǝnga ɗǝmwaˈyu. Abangǝ nga nyi wu nda ɗa anǝ nji zaman kau.” ");
INSERT INTO mfm_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tsu ja vǝr ndǝr ǝkkǝˈyi dlamir nji, kǝja mǝnyi ǝnga zamǝ nyiˈyar shili a biya ndu yiwu nda ndǝr anǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kǝ vanyi ndǝ na anǝ nyi, “Kǝja mǝngau ǝnga zamǝ ngǝˈyar a biya ndu yiwu nda ndǝr ǝnga gau.” ");
INSERT INTO mfm_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kǝ ji shaɗǝwa nyi anǝ ndǝ kau, ji na, “Wa ngǝ maɗa, ǝnga wa ngǝ zamǝɗaˈyara?” ");
INSERT INTO mfm_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kǝ ji ca zǝmbǝlma nyiˈyar ǝnga tsa ja, ji na, “Kǝja maɗa ǝnga zamǝɗaˈyar. ");
INSERT INTO mfm_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ara kalar ndǝra wu mǝl thlǝr ǝnga sǝra dǝɗa kǝra a dǝmǝlmǝ wu yiwu, naja ngǝ zamǝ ɗa ǝnga kwamǝ ɗa ba maɗa.” ");
INSERT INTO mfm_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ar pǝci ta Yesu biya sara wu ki, ji biya nggya ar miya dǝl. ");
INSERT INTO mfm_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Dlamir nji gangǝ kaɓau ba ndǝ zǝwari nyi, kǝl ta ji nda gwu kwambwal ji gwa nggya gya, ba dlamir nji nggya nǝr nda a miya dǝl. ");
INSERT INTO mfm_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kǝ ji nar nda sǝ pamǝpamǝ lagu karapau, ji na, “Vanyi ndǝr zǝwa maˈyi a gwar fa nyi, a gwa sǝ culi. ");
INSERT INTO mfm_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ənggǝra ja vǝr sǝ culi, kǝ alenyi pǝnakǝr ar lagu. Kǝ ˈyagǝˈyar shili ba ndǝ sa sǝmku nda. ");
INSERT INTO mfm_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kǝ alenyi pǝnakǝr ar vi cacathlǝu, vira ˈyiˈyi aˈyi gangǝ mai. Ba ndǝ tsau aga zǝmǝu, ara ˈyiˈyi kǝra ar kǝra nyi aˈyi tǝdǝɓǝ mai. ");
INSERT INTO mfm_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ama ǝnggǝra pǝci ɗa kwakwaɗǝ gagaɗau, ba ndǝ titiˈwa ba ndǝ ul ara nggyilangǝ aˈyi ara nda gagaɗǝ mai. ");
INSERT INTO mfm_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kǝ alenyi tǝɗǝ a gyiwu pama shikǝɗi, ndǝ hǝ ǝnga nda, ba shikǝɗi kar nda ara pǝli. ");
INSERT INTO mfm_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Alenyi culi tsu tǝɗǝ a gyiwu ˈyi kǝra mǝnahǝu, ndǝ hau, ba ndǝ puwa li gangǝ gagaɗau, alenyi gharu gharu, ǝnga alenyi kwakumunyi kwakumunyi ǝnga alenyi tsu makǝrkumunyi makǝrkumunyi. ");
INSERT INTO mfm_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ndǝra ǝnga himi nggar sau, bǝgǝ ja nggari.” ");
INSERT INTO mfm_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kǝ zǝmbǝlma nǝ Yesu ˈyar shili ndǝ sa yiwa nyi, “Mi ngǝ ɗa gu ndǝr anǝ nda ǝnga karapǝˈyar ka?” ");
INSERT INTO mfm_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kǝ ji shaɗǝwa nda, ji na, “Sǝnbiya sǝ kǝra ɗǝɗǝwa nǝ tǝlkur Hyal a nǝ hyir nji, ama aˈyi anǝ nda mai. ");
INSERT INTO mfm_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ndǝra ǝnga sau nju cakǝri nyi, aga ja uya gangǝu. Ama ndǝra gǝra ǝnga sau, alaga kǝra aˈyi ara ja kushu nju ɓǝra dlǝwuri. ");
INSERT INTO mfm_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Sǝra ɗa yu ndǝr anǝ nda ǝnga karapau. “Aga ndu tsamǝ ama nandǝ wu tsambiya mai, ndu sǝhimi ama nandǝ wu nggari mai ǝnga nandǝ wu nggabiya mai. ");
INSERT INTO mfm_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Lagu kǝ ngǝ ndǝr nabi Əshaya nyabiya dzǝ ar kǝra nda abǝr, “ ‘Hyu nda dumwa ǝnga ngga ama nahyi wu nggabiya mai, hyu nda tsamǝ ama nahyi wu tsambiya mai. ");
INSERT INTO mfm_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ara ɗǝfuwa nji kǝ a ɗar ɓaɓalu, himiya nda tsu wu nggar sǝ mai, ǝnga ndǝ haɗiya liya nda, ara nda sara lar sǝ ǝnga liya nda, nda nggari ǝnga himiya nda, ǝnga nda nggabiya ǝnga ɗǝfuwa nda, nda sha shili ǝgya yau, ya mbǝɗana nda.’ ");
INSERT INTO mfm_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nahyi nǝr hyi, barka anǝ liya hyi ara ndu lar sau, ǝnga himiya hyi ara ndu nggar sau. ");
INSERT INTO mfm_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yu nar hyi jiri, nabiˈyar gangǝu ǝnga nji cicau, a yiwur nda, nda lari sǝˈyar kǝ hyu lar kau, ama nandǝ lari mai. A yiwur nda, nda nggari sǝˈyar kǝ hya vǝr nggar kau, ama nandǝ nggari mai. ");
INSERT INTO mfm_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kǝja sǝra karapǝ ar kǝra ndǝr sǝ culi kǝ cabiya: ");
INSERT INTO mfm_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ma ndǝ nggar ndǝr nǝ tǝlkur Hyal ama naji nggabiya mai, ba Shatan a shili ja faˈabiya sǝra ji nggari kǝ sara wu ɗǝfuwa ja. Naja kǝ ngǝ cabiya culi kǝra pǝnakǝr ar lagu. ");
INSERT INTO mfm_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kǝra pǝnakǝr ar vi cacathlǝ ǝtsu, naja ngǝ nju gǝla ǝnga ndǝra nggari ndǝr Hyal, ba ji dlǝwuri aga zǝmǝ ǝnga huɗǝ pǝrtǝu. ");
INSERT INTO mfm_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ama ara naja aˈyi ǝnga nggyilangǝ mai, ba ji sǝkar nǝ pǝci kushu. Ənggǝra ɓwaɓwatǝ shili anǝ nyi arya ndǝr Hyal, ba ji sha a gyiwu yukuɗǝ ǝnga kusa. ");
INSERT INTO mfm_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Culi kǝra nji sǝna wu pama shikǝɗi kǝ tsu, naja ngǝ nju gǝla ǝnga ndǝra nggari ndǝr Hyal, ama kǝ nggyabiya duniya ǝnga gal gǝnna kari ndǝra nyi ara hau, kǝl ta ji ɗa gǝra ǝnga akkǝri. ");
INSERT INTO mfm_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Culi kǝra nji sǝna ar ˈyiˈyi mǝnahǝ kǝ tsu, naja nga nju gǝla ǝnga ndǝra nggari ndǝr Hyal ba ji nggabiya. Ju ɗa ǝnga akkǝri, ju puwali, alenyi gharu gharu, ǝnga alenyi kwakumunyi kwakumunyi ǝnga alenyi tsu makǝrkumunyi makǝrkumunyi.” ");
INSERT INTO mfm_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu ɓǝra nar nda vanyi karapau, ji na, “Kǝja sǝra nja sǝn gǝlabiya tǝlkur Hyal ǝni, ǝnggǝr vanyi ndǝ kǝra thlǝkana culi mǝnahǝu wu fa nyi. ");
INSERT INTO mfm_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ama pǝci kǝra nju ghanyi, ba dawa nyi shili ka sa thlǝkana hyanggili wu fa nyi a ndu pama uhi, ba ji maˈyi sǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ar pǝci kǝra uhi kǝra nji thlǝkana kǝ hau, ndǝ mǝliya kǝr, ba hyanggili hyaˈari tsu. ");
INSERT INTO mfm_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Mafa nyiˈyar shili ndǝ sa na anǝ nyi, ‘Thlagǝr ki, aˈyi culi mǝnahǝ nga gǝ thlǝkana wu fa ngǝ wa? Ya, lagu mani ngǝ hyanggiliˈyar kǝ tsǝ ari ka?’ ");
INSERT INTO mfm_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Kǝ ji na anǝ nda, ‘Dawa ngǝ mǝliya abangau.’ Kǝ mafaˈyar kǝ yiwa nyi, ‘Ya, gu yiwu ˈya maˈyi ˈya gwa kukucina nda ya?’ ");
INSERT INTO mfm_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ama kǝ ji shaɗǝwa nda, ‘Awau, ara a vǝr kuci hyanggila nyi, ba hya kucina daɓǝ ǝnga uhi. ");
INSERT INTO mfm_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Piyar nda mau nda hǝ gyapǝu kǝl pǝcir fwahǝu. Ar pǝci ta yu nar nyi anǝ njir mǝl thlǝr. Tanggǝrma, nda dzǝguya ǝnga hyanggila nyiˈyar, nja kaɓiya nja nggyina nda. Ba nja dzǝgwa gǝmna uhi ba nja faˈana a su tsamǝ.’ ” ");
INSERT INTO mfm_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu ɓǝra nar nda vanyi karapau, “Tǝlkur Hyal ǝnggǝr culi bǝla nga nyi, kǝra vanyi ndǝ hǝri ji thlǝkana wu fa nyi. ");
INSERT INTO mfm_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Naja nga ndiya patǝr culi ǝnga kushu, ama ma ji hau, ba ja ndiya patǝkura wu kǝra wu masǝmǝ ǝnga dǝgalǝu, ba ˈyagǝˈyar a liya kir nda ar tsa nyi.” ");
INSERT INTO mfm_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu ɓǝra nar nda vanyi karapau, ji na, “Tǝlkur Hyal ǝnggǝr thlǝlamǝ nga nyi, kǝra mala hǝri ji gwaɗǝbiya ǝpou tasaˈwu tǝkǝ sǝ makǝr ǝni, ba ja dzǝgwa thlǝthlǝ gagaɗau.” ");
INSERT INTO mfm_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu nar nyi najaka ndǝr patǝ anǝ daɓǝr dlami lagu karapau. Sǝ aˈyi ji nar nda zǝmǝ gǝra ǝnga karapǝ mai. ");
INSERT INTO mfm_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Lagu kǝ nga ji nyabiya sǝra nabi Əshaya nana abǝr, “Yu nda pahǝna miya, yu ndǝr ǝnga karapau, Yu nda cabiya nyi anǝ nji sǝra ɗǝɗǝwa mbar dzǝgwar duniya aga nda sǝnbiya.” ");
INSERT INTO mfm_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kǝ Yesu piyari dlamir nji, ji maˈyi a vu huɗa ki. Zǝmbǝlma nyiˈyar shili ǝgya ja ndǝ sa na anǝ nyi, “Nar ˈya sǝra hyanggili wu fa uhi kǝ aga nyi.” ");
INSERT INTO mfm_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kǝ ji shaɗǝwa nda, ji na, “Ndǝra thlǝkana culi mǝnahǝ naja ngǝ Zǝr Ndau. ");
INSERT INTO mfm_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Fa uhi kǝ ca ngǝ duniya, culi mǝnahǝ ca ngǝ wazha nǝ tǝlkur Hyal. Hyanggili kau, ca ngǝ wazha Shatan. ");
INSERT INTO mfm_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Dawa kǝra thlǝkana hyanggili kau, naja ngǝ Shatan ǝnga kǝrnyi. Pǝcir fwahǝu ca ngǝ kuɗiyar duniya. Njir gǝm uhi nanda ngǝ waladiˈyar. ");
INSERT INTO mfm_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Ənggǝr kǝra nju tsǝmiya jigwal nja nggyina, abangǝ nga nyi wu nda ɗa pǝcir kuɗiyar duniya. ");
INSERT INTO mfm_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Zǝr Ndu nda sǝwa waladi nyiˈyar aga nda faˈabiya kalar sǝra wu dla ǝnga bikau ǝnga njir mǝl sǝ ɗǝmwaˈyi sara wu tǝlkur nyi. ");
INSERT INTO mfm_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nda dzǝgwa vakuwa nda a gwu uˈur kǝtsa, a guna nda dzǝgwa wau ǝnga ɗǝ hira nda. ");
INSERT INTO mfm_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ar pǝci ta ngǝ njir mǝl thlǝr kǝra tsapǝ wu nda mbǝl ǝnggǝr pǝci wu tǝlkur dǝrnda. Njira ǝnga himi nǝ nggar sau, taˈyi nda nggari. ");
INSERT INTO mfm_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Tǝlkur Hyal ǝnggǝr bǝrba nga nyi kǝra nji ɗǝwana wu huɗa fa. Ta vanyi ndǝ nǝri, ba ji ɓǝra ɗǝwana wayu. Ara ǝnggǝra huɗa ji pida, ba ji maˈyi ji nda ɗǝlna patǝr sǝra ara ja, ba ji dzǝgwa ɗǝlbiya fa nyi. ");
INSERT INTO mfm_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ətsu, tǝlkur Hyal ǝnggǝr ndǝr ɗǝlna sǝ nga nyi kǝra a vǝr gal handzǝlkwa. ");
INSERT INTO mfm_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ta ji thlǝwa kǝra nju ɗǝl ǝnga gǝnna gangǝu, ba ji maˈyi ji nda ɗǝlna patǝr sǝra ara ja, ba ji sa ɗǝlbiya. ");
INSERT INTO mfm_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ətsu wayu, tǝlkur Hyal ǝnggǝr litagǝ kǝra nji fuwa a gwu dǝl nga nyi kǝra mbari culi kalfi pamǝpamǝ gangǝu. ");
INSERT INTO mfm_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ənggǝra ji nyau ǝnga kalfi, kǝ njir tǝm hǝbiya a biya miya dǝl. Kǝ ndǝ dzǝgwa nggya gya ndǝ ɗǝmbiya kalfi kǝra mǝnahǝu ndǝ puwa a gu bǝngǝ, ba ndǝ dzǝgwa pǝna ɗǝmwaˈya nyi. ");
INSERT INTO mfm_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Abangǝ nga nyi wu nda ɗa ar pǝcir kuɗiyar duniya. Waladiˈyar wu nda shili nda sa tǝkǝbiya nji ɗǝmwaˈyi ǝnga nji tsapǝu. ");
INSERT INTO mfm_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ba nja dzǝgwa vakuwa nda a gwu uˈur kǝtsa, a guna nda dzǝgwa wau ǝnga ɗǝ hira nda. ");
INSERT INTO mfm_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“A nggabiyar hyi sǝˈyar kǝ patǝ ya?” Yesu yiwar nda. “Angǝ,” ǝngwar nda. ");
INSERT INTO mfm_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kǝ ji na anǝ nda, “Agabangǝ kalar malǝmǝ dlaɗǝ kǝra nji highiɓǝr nyi sǝ ar kǝra tǝlkur Hyal, ǝnggǝr thlagǝr ki nga ja kǝra gwu umbwa nyi, ji gwa faˈabiya bǝrba mafǝliyangǝ ǝnga bǝrba hahal a biya.” ");
INSERT INTO mfm_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ənggǝra Yesu kuɗǝna na karapǝˈyar kau, ba ji piyari vi ta. ");
INSERT INTO mfm_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Shilir Yesu wu mǝlmǝ nyi, ba ji dzǝguya highiɓǝ anǝ nji wu umbwa daɓǝ dzǝ njir yahudiya. Ba ɗa sǝ dǝdǝgur anǝ nda, ndǝ na, “Əmani ngǝ ndǝ kǝ uya sǝnbiya sǝ ka, ǝnga dǝnama nǝ mǝl sǝ dǝdǝgurˈyar ka?” ");
INSERT INTO mfm_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Aˈyi zǝr ndǝr ta wu ta ngǝ wa? Aˈyi mǝnyi nga nju ngga ǝnga Maryamu ta wa? Aˈyi zamǝ nyiˈyar ngǝ Yakubu ǝnga Yusufu ǝnga Simanu ba ǝnga Yahuda wa? ");
INSERT INTO mfm_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kwamǝ nyiˈyar aˈyi nda ǝkkǝˈyi mǝn ǝnggǝ wa? Ya, sara mani nga ji uya patǝkura sǝˈyar ka?” ");
INSERT INTO mfm_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ba huɗa nda ndzǝ ǝnga ja. Ama kǝ Yesu na anǝ nda, “Kǝl wu mǝlmǝ nyi, ǝnga wu pama nji nyi, ba wu ki nyi nga nji gǝra ha kǝra nabi.” ");
INSERT INTO mfm_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Naji ɓǝra mǝl sǝ dǝdǝgurˈyar gangǝ wu pama nda mai, ara ghar mbǝrsar nda. ");
INSERT INTO mfm_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ar pǝci kǝ ngǝ tǝl Hirudusu nggari ndǝr ar kǝra Yesu. ");
INSERT INTO mfm_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kǝ ji na anǝ njir mǝl thlǝr nyi, “Ndǝ kau, Yahwana ndǝr mǝl Baɓǝtizǝma ngau, a hyaˈari ja sara vir tau, ca ngǝ sǝra ɗa ji uya dǝnama nǝ mǝl sǝ dǝdǝgurˈyar kau.” ");
INSERT INTO mfm_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Arya ɗǝɗǝmǝu Hirudusu mbari Yahwana, ba ji mbiya nyi, kǝ ji fuwa nyi wu fursǝna arya Hirudiyasu, mala zamǝ nyi Fǝlipǝu. ");
INSERT INTO mfm_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ara ɗǝɗǝmǝu Yahwana wu na anǝ Hirudusu abǝr a ɓǝlnar ja dlaɗau ara ji hǝri Hirudiyasu aga mala nyi.” ");
INSERT INTO mfm_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hirudusu wu yiwu ja tsǝya Yahwana, ama ju hivǝr ara nji, ara ndǝ hǝr Yahwana ar viya nabi. ");
INSERT INTO mfm_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ar pǝcir mini nǝ ɗǝngari pǝcir ya nǝ Hirudusu, ngǝ kwar Hirudiyasu fǝl anǝ nji, ba fǝl kǝ pina huɗa Hirudusu gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Arya kau, kǝ ji hǝr alkawal daɓǝ ǝnga sǝm fǝla, abǝr, ju nǝ nyi kalar sǝra ji yiwa ara ja. ");
INSERT INTO mfm_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kǝ mǝnyi nar nyi sǝra ja yiwa, kǝ ji na, “Nǝ ɗa nji kǝra Yahwana ndǝr mǝl Baɓǝtizǝma ar pǝli.” ");
INSERT INTO mfm_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kǝ sǝ kǝ ɓwanǝ nyi kǝr gagaɗau, ama arya alkawal ǝnga sǝm fǝla kǝra ji hǝri, ǝnga mǝthlǝpi nyiˈyar kǝra aˈyi ǝnga ja, naji wu yiwu ja kar nyi mai. ");
INSERT INTO mfm_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kǝ ji sǝwa a vu fursǝna aga nja vuwa thlana kǝra Yahwana. ");
INSERT INTO mfm_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ji shili ǝni ar pǝli, ji sa nǝ nyi anǝ zǝr kwa nyi, kǝ ji nǝ nyi anǝ mǝnyi. ");
INSERT INTO mfm_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kǝ zǝmbǝlma Yahwana ˈyar shili ndǝ sa hǝri dza ja. Ba ndǝ nda haɗǝna. Kǝ ndǝ maˈyi ndǝ nda nar nyi anǝ Yesu. ");
INSERT INTO mfm_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ənggǝra Yesu nggari abangau, ba ji hyaˈari ji gwu kwambwal. Kǝ ji tǝrabiya a ndar vira nji aˈyi ari mai aga ja nda nggya zhizhi nyi. Ama ǝnggǝra dlamir nji nggari abangau, ba ndǝ hyaˈari sara wu mǝlmǝ pamǝpamǝ ndǝ nu nyi ǝnga hi. ");
INSERT INTO mfm_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ənggǝra Yesu biya sara wu kwambwal, ba ji lari dlamir nji gangǝu. Ənggau, ba ji tǝhuɗǝ ǝgya nda, ba ji shilǝgǝbiya njira gǝra ngga wu pama nda. ");
INSERT INTO mfm_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ənggǝra wagǝ ɗa, kǝ zǝmbǝlma nyiˈyar shili ara ja, ndǝ na, “Vi kǝ nji aˈyi a gwa mai, ǝnga tsu vi a ɗar dlǝru. Tǝtǝlna nji kau, tara ba nda maˈyi a ndu huɗa giwa kǝra zǝwar vi kǝ nda ɗǝlbiya sǝr sǝm anǝ kǝrnda, aga nda sǝmku.” ");
INSERT INTO mfm_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kǝ Yesu na anǝ nda, “Aˈyi mbari kǝl nda maˈyi mai, nǝ nda mǝ sǝ kǝra nda daɓaga sǝn sǝm.” ");
INSERT INTO mfm_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kǝ ndǝ shaɗǝwa nyi, ndǝ na, “Sǝ aˈyi kǝra tsaˈa ˈya nǝ nda mai, kǝl lǝgu ɗǝfǝ tǝfu ǝnga kalfi mǝthlǝ ngǝ aˈyi wacu.” ");
INSERT INTO mfm_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kǝ ji na, “Shila mǝ ǝni.” ");
INSERT INTO mfm_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kǝ ji nar nyi anǝ nja nyi nda nggya gya ar sar. Ji hǝri lǝgu ɗǝfǝ tǝfu ǝnga kalfi mǝthla nyi, ba ji hyaˈanakǝr a dǝmǝlmau, kǝ ji usaku anǝ Hyal, ba ji ɓǝɓǝlǝwa nda. Kǝ ji dzǝgwa nǝ nyi anǝ zǝmbǝlma nyiˈyar, nanda tsu, kǝ ndǝ tǝkǝna nyi anǝ dlamir nji. ");
INSERT INTO mfm_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Patǝkura nda sǝm ndǝ nyau. Kǝ zǝmbǝlma nyiˈyar tsǝmiya tsǝla kumo apǝ mǝthlǝ ǝnga sǝra hiyau sara wu miya nda. ");
INSERT INTO mfm_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Njira sǝm sǝ kau, shili zhizhir nda nji dubu tǝfu ngau. Ama nji jiga mathlǝkǝˈyi ǝnga wazha mai. ");
INSERT INTO mfm_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ənggǝrna, kǝ Yesu fuwa zǝmbǝlma nyiˈyar a gwu kwambwal aga nda tǝrabiya wu mwa nyi a biyar ya dǝl. Naja nǝ nyi, kǝ ji taˈyi wu yukuɗǝ aga ja sǝwa dlamir nju lagu. ");
INSERT INTO mfm_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ayukuɗa ji sǝwa dlamir nji ndǝ maˈyi, ba ji maˈyi sǝ nyi a dar kǝra mau aga da ndǝr ǝnga Hyal. Ənggǝra wagǝ ɗa, tsu ja a dar kǝra mǝ zhizhi nyi. ");
INSERT INTO mfm_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ar pǝci kau, kwambwal a gwar hada dǝl nga nyi, kǝja dlǝgwamǝr ˈyimi wu tsatsa nyi ǝnga yambaɗǝ wu ka nyi ara ɓau. ");
INSERT INTO mfm_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ənggǝr saka makǝr nǝ vuˈyi, kǝja Yesu a vǝr ɓau, a ndǝgya nda a dar kǝra ˈyimi. ");
INSERT INTO mfm_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ənggǝra zǝmbǝlma nyiˈyar lari nyi a vǝr ɓǝ a dar kǝra ˈyimi, ba hivǝr mbar nda gagaɗau. “Dǝgur ngǝ canǝ mǝn kǝr,” ǝngwar nda, ba ndǝ mbar wau ara hivǝr. ");
INSERT INTO mfm_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ama ǝnggǝrna kǝ Yesu nar nda, “Hya sara ɓukǝr anǝ kǝrhyi mai! Nayi ngau. Hya sara hivǝr mai.” ");
INSERT INTO mfm_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Əngwar Biturusu anǝ nyi, “Thlagǝu, ma nagǝ ngau, nar ɗa ya ndara gau, a dar kǝra ˈyimi kau.” ");
INSERT INTO mfm_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“A ndau,” ǝngwar Yesu. Kǝ Biturusu biya sara wu kwambwal, ji mbar ɓǝ a ndǝgya Yesu. ");
INSERT INTO mfm_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ama ta ji lari yambaɗǝ a vǝr sǝ ǝnga dǝnama, ba hivǝr mbari nyi, ba ji mbar gya cau. Kǝ ji wau, ju na, “Thlagǝu, mbǝɗana ɗa!” ");
INSERT INTO mfm_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Aga zǝmǝ kǝ Yesu hari nyi tsi, ba ji mbari nyi. Əngwar ja, “Nagǝ ndǝ tǝtǝwa mbǝrsa, mi ngǝ ɗa gǝ tǝkǝ kǝra?” ");
INSERT INTO mfm_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ənggǝra ndǝ gwu kwambwala nyi, kǝ yambaɗǝ kǝ taˈyau. ");
INSERT INTO mfm_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kǝ njira gwu kwambwal dlǝvǝ Yesu, ndu na, “Ənga jiri nagǝ Zǝr Hyal ngau.” ");
INSERT INTO mfm_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ayukuɗa ndǝ tǝrabiya a biyar ya dǝl, ba ndǝ gya wu mǝlmǝ Janisaratu. ");
INSERT INTO mfm_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ta njir mǝlma nyi tsamǝri abǝr Yesu ngau, ba ndǝ sǝwa nja nar nyi anǝ njir ˈyiˈya nyi patǝu, aga nda shili ǝnga njira gǝra ngga anǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ndǝ sa kǝdi nyi aga nji gǝra ngga nda tsǝkwari alaga miya cira lǝgutǝ nyi. Patǝkura njira tsǝkwar nyi, ba ndǝ ɗa jamǝu. ");
INSERT INTO mfm_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kǝ alenyi njir Farisi ǝnga malǝmˈyar nǝ dlaɗau, shili ǝgya Yesu sara wu Urshalima ndǝ sa yiwa nyi, ");
INSERT INTO mfm_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mi ngǝ ɗa zǝmbǝlma ngǝˈyar wu ɓǝla kǝbǝkwatǝu nǝ njira nggurǝm nǝ mǝlmǝ maya? Nandǝ wu ci tsi divira nda sǝm sǝr sǝm mai.” ");
INSERT INTO mfm_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kǝ Yesu shaɗǝwa nda, ji na, “Mi ngǝ ɗa hyu ɓǝlna sǝra Hyal na nja ɓǝlari, aga hya ɓǝlari sǝra ǝjir hyu na? ");
INSERT INTO mfm_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ara Hyal nana wu ndǝr nyi, ‘Ga gǝnggǝr nyi sǝli anǝ dǝngau ǝnga mǝngau.’ Ənga tsu, ‘Ma ndǝra nggǝliya dǝnyi ǝnga mǝnyi kǝl nja tsǝya nyi.’ ");
INSERT INTO mfm_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ama hyu highiɓau, abǝr, ndu sǝn na anǝ dǝnyi ǝnga mǝnyi, ‘Kalar dlǝwa dzǝ kǝra hya kyaga uya ara yau, a nǝ nyir yau anǝ Hyal,’ ");
INSERT INTO mfm_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","naja aˈyi a sǝn ‘gǝnggǝr nyi sǝli anǝ dǝnyi’ ǝtsu mai. Agabangau, ba hyi mǝliya ndǝr Hyal ɗa sǝ kurthlǝu lagur sǝr cijir hyi. ");
INSERT INTO mfm_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nahyi nji batal! Jiri nga nyi ǝnggǝra nabi Əshaya nana ndǝr ar kǝra hyi abǝr, ");
INSERT INTO mfm_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘Nji kǝ ndu gǝnggǝr ɗa sǝli ǝnga miya nda wacu, ama ɗǝfuwa nda a maˈyiri naɗǝ ara yau. ");
INSERT INTO mfm_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ndu dlǝvǝ ɗa ar cicir miya nda, ndu highiɓǝ lagu dlaɗǝ kǝra ndǝ ngǝ mǝliya, abǝr ca ngǝ ndǝr Hyal.’ ” ");
INSERT INTO mfm_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kǝ Yesu ngga dlamir nji a shili wu dzǝ nyi, ji na anǝ nda, “Siya ɗa mǝ himi patǝ hyi, aga hya nggabiya sǝ kau. ");
INSERT INTO mfm_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sǝr sǝm kǝra ndu fuwa a gwu miya ja a sǝn mǝliya ndǝ ‘dedeɓǝ’ wu mwar Hyal mai, ama sǝra biya sara wu ndǝ ngu mǝliya ndǝ ‘dedeɓǝ’ wu mwar Hyal.” ");
INSERT INTO mfm_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kǝ zǝmbǝlmaˈyar shili ara ja ndǝ sa yiwa nyi, “A sǝni gǝ abǝr huɗa njir Farisi ndzǝndzǝ nga nyi ǝnga gau, ǝnggǝra ndǝ nggar ndǝr kǝ ya?” ");
INSERT INTO mfm_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kǝ Yesu shaɗǝwa, ji na, “Kalar sǝ thlǝthlǝka kǝra aˈyi dǝɗa kǝra a dǝmǝlmǝ ngǝ thlǝkana mai, ba nja kucina. ");
INSERT INTO mfm_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Piyari nda mau. Nanda ǝnggǝr nji lǝfǝ ngau a vǝr tǝɗǝmwa anǝ alenyi nji lǝfau. Patǝkura nda, ndu pǝpau a gu kaˈu.” ");
INSERT INTO mfm_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kǝ Biturusu na anǝ nyi, “Nar ˈya sǝra karapǝ kǝ cabiya.” ");
INSERT INTO mfm_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kǝ Yesu na, “Kar ya, tsu hyi dza ya?” ");
INSERT INTO mfm_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","“Aˈyi hyu sǝni abǝr sǝra gwu miya ndau wu tǝrabiya a gyiwu ta ja, ba ja dzǝgwa tǝrabiya a biya wa? ");
INSERT INTO mfm_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ama sǝra biya wu miya ndau, sara wu ɗǝfuwa ja nga nyi wu biya. Ca ngu mǝliya ndǝ ‘dedeɓǝu.’ ");
INSERT INTO mfm_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ara sara wu ɗǝfuwa ndǝ ngǝ ɗǝnga ɗǝmwaˈyi wu shili, sǝ ǝnggǝr tsa ndau ǝnga sǝsukur ǝnga hǝl ǝnga sakida nǝ fati ǝnga ndza thlǝmǝr ndau. ");
INSERT INTO mfm_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Sǝˈyar kǝ ngu mǝliya ndǝ ja ɗa ‘gǝra cicau,’ ama sǝm sǝr sǝm gǝra ǝnga tsi cicau a sǝn mǝliya ndǝ ja ɗa ‘gǝra cici’ mai.” ");
INSERT INTO mfm_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kǝ Yesu piyari vi ta, ba ji maˈyi a vu ˈyiˈyir Taya ǝnga Sidonu. ");
INSERT INTO mfm_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","A vuna kǝ mala kǝra aˈyi mala njir Yahudiya mai shili ara ja, ji na, “Thlagǝu, Zǝr Dawuda, tǝhuɗǝ ǝgya yau. Kǝja mambǝl ɗǝmwaˈyi a vǝr lǝ ɓwaɓwatǝ gagaɗǝ anǝ kwa ɗa.” ");
INSERT INTO mfm_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ama sǝ aˈyi kǝra Yesu shaɗǝwa nyi mai. Kǝ zǝmbǝlma nyiˈyar shili ara ja ndǝ kǝdi nyi, ndǝ na, “Kǝdlǝna nyi ja maˈyi, ara kǝ ju nu mǝn ju ɓwanǝ mǝn kǝr kau.” ");
INSERT INTO mfm_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kǝ ji shaɗǝwa, ji na, “Hyal sǝwa ɗa a shili anǝ njir Izirayila kǝra ǝnggǝr tǝmahǝ sasa wacu.” ");
INSERT INTO mfm_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ama kǝ mala kǝ shili, ji sa ɓǝliya undi wu mwa nyi, ji na, “Thlagǝu, dlǝwar ɗa.” ");
INSERT INTO mfm_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kǝ ji shaɗǝwa, ji na, “Aˈyi ɗa tsaˈa nja hǝri sǝr sǝm wazha nja vakana nyi anǝ hyaˈyar mai.” ");
INSERT INTO mfm_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kǝ ji na, “Jiri nga nyi Thlagǝu, ama alaga abangau, hyaˈyar ndu sǝm sǝra pǝpǝnakǝr sara wu miya wazha ma nda vǝr sǝm sau.” ");
INSERT INTO mfm_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kǝ Yesu shaɗǝwa, ji na, “Mala, dǝgal gagaɗǝ ngǝ mbǝrsa ngau. Bǝgǝ sǝra gu yiwu, ja ɗa.” Abangau, kǝ kwa ta ɗa jamǝ ar pǝci ta. ");
INSERT INTO mfm_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Sarar vi ta, kǝ Yesu maˈyi lagu dǝl Galili. Kǝ ji maˈyi a dar kǝra mau, kǝ ji da nggya gya. ");
INSERT INTO mfm_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Dlamir nji gangǝ shili ǝgya ja, ndu shili ǝnga nji pamǝpamǝ gangǝ kǝra gǝra ngga. Nanda ngǝ, nji tǝsǝkǝnǝu, ǝnga nji lǝfau, ǝnga nji kukurɓǝu, ǝnga njir mǝga, ǝnga njir shilǝgǝ pamǝpamǝ gangǝu, ba ndǝ sa pina nda ǝgya hiya Yesu. Kǝ Yesu shilǝgǝbiya nda. ");
INSERT INTO mfm_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kǝ sǝ kǝ ɗa sǝ dǝdǝgur anǝ nji, ǝnggǝra ndǝ nggar njir mǝga a vǝr ndǝr ǝnga ndǝ lari nji kukurɓǝ ɗa jamǝ ǝnga nji tǝsǝkǝnǝ a vǝr ɓau ba nji lǝfau wu lar sau. Kǝ patǝkura nda dlǝvǝ Hyal nǝ njir Izirayila. ");
INSERT INTO mfm_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kǝ Yesu nggari zǝmbǝlma nyiˈyar a shili ara ja, kǝ ji na anǝ nda, “Yi wu tǝhuɗǝ ǝgya nji kau, ara ǝshina pida makǝr nga nda ǝnga yau, nandǝ sǝm sǝ mai. Nayi wu yiwu ya sǝwa nda, nda maˈyi ǝnga wuɓǝ mai, nda sara nda shavǝr ar lagu.” ");
INSERT INTO mfm_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kǝ zǝmbǝlma nyiˈyar shaɗǝwa, ndǝ na, “Əmani nga mǝn wu nda uya sǝr sǝmǝna dlami kǝ ar tagǝ ka?” ");
INSERT INTO mfm_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“Lǝgu ɗǝfǝ yiɗawa nga ara hya?” Yesu yiwa nda. Kǝ ndǝ shaɗǝwa nyi, “Lǝgu ɗǝfǝ mǝɗǝfǝ ǝnga kalfi yiɗǝɗǝ yiɗawu.” ");
INSERT INTO mfm_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kǝ ji nar nyi anǝ dlamir nji, nda nggya a gyiwu ˈyi. ");
INSERT INTO mfm_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kǝ ji hǝri lǝgu ɗǝfǝ mǝɗǝfǝ ǝnga kalfiya nyi. Ayukuɗa ji usaku Hyal, kǝ ji ɓǝɓǝlǝwa, ba ji nǝ nyi anǝ zǝmbǝlma nyiˈyar. Nanda tsu, ba ndǝ tǝtǝkǝna nyi anǝ nji. ");
INSERT INTO mfm_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Patǝ nda ngǝ sǝm, ndǝ nyau. Ayukuɗa nyi zǝmbǝlma nyiˈyar tsǝmiya tsǝla nyinyi mǝɗǝfau ǝnga sǝra hiyau sara wu miya nda. ");
INSERT INTO mfm_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Njira nji sǝmǝna ca ngǝ shili zhizhir nda nji dubu foɗǝu, nji jiga mathlǝkǝˈyi ǝnga wazha mai. ");
INSERT INTO mfm_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ayukuɗa Yesu sǝwa dlamir nji nda maˈyi, kǝ ji gwu kwambwal, ba ji maˈyi a vu ˈyiˈyir Magadanu. ");
INSERT INTO mfm_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kǝ njir Farisi ǝnga njir Sadusi shili ǝgya Yesu, aga nda sa dzǝbiya nyi. Kǝ ndǝ na anǝ nyi, aga ja canǝ nda mǝtsamǝ sǝ dǝdǝgur sara dǝmǝlmau, kǝra wu cabiya abǝr sara ara Hyal nga ja. ");
INSERT INTO mfm_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kǝ ji shaɗǝwa nda, ji na, “Ma wagǝ ɗa, ba hyi lari ndǝla mǝlmǝ a ɗar dǝzǝu, ba hya na, ‘Vi wu sa ɗa jamǝ ǝzǝgǝu.’ ");
INSERT INTO mfm_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma mudlǝ tsu, ma hyi lari ndǝla mǝlmǝ dǝzǝu ǝnga zǝgutu, ba hya na, ‘Əshina nǝ nyi nju nda tǝɗǝ par.’ Nahyi, hyu sǝn tǝkǝbiya pamǝpamǝkura dlama, ama nahyi wu sǝn tǝkǝbiya pamǝpamǝkura sǝ dǝdǝgur kǝra wu ɗarkǝr kabangǝkǝ mai. ");
INSERT INTO mfm_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Njir nggyabiya kabangǝkǝ nji ɗǝmwaˈyu, njira gǝra nu Hyal wu yiwu nda lari sǝ dǝdǝgur. Ama sǝ dǝdǝgur aˈyi nju nda ca anǝ nda mai, kǝl nǝ nabi Yunana.” Kǝ Yesu piyari nda ba ji maˈyi. ");
INSERT INTO mfm_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ənggǝra zǝmbǝlma nyiˈyar tǝrabiya a biyar ya dǝl, ba ndǝ ɗǝngari nandǝ hǝri macikǝl mai. ");
INSERT INTO mfm_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kǝ Yesu na anǝ nda, “Hya hangǝkal, ǝnga hya tsamǝ ar kǝra thlǝlamǝ nǝ njir Farisi ǝnga njir Sadusi.” ");
INSERT INTO mfm_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kǝ ndǝ thla wu pama nda, ndǝ na, “Ji na abangau, ara kǝ mǝn gǝra hǝri macikǝl kǝ ngau.” ");
INSERT INTO mfm_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ta Yesu sǝnbiya sǝra ndu thla, kǝ ji na anǝ nda, “Nahyi njira ǝnga mbǝrsa kukushu, mi ngǝ ɗa hyu ndǝr wu pama hyi abǝr ara kǝ hyi gǝra hǝri macikǝl kǝ nga? ");
INSERT INTO mfm_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Baˈanǝ kabangǝkǝ nahyi nggabiya mai ya? A far hyi ǝnggǝra yi sǝmǝna nji dubu tǝfu ǝnga lǝgu ɗǝfǝ tǝfu ta ya? Ətsu a far hyi tara tsǝla yiɗau nga hyi nyana ǝnga sǝra hiyau wu miya nji ta ya? ");
INSERT INTO mfm_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Əndǝga a far hyi ǝnggǝra yi sǝmǝna nji dubu foɗǝ ǝnga lǝgu ɗǝfǝ mǝɗǝfǝ ǝnga tara tsǝla yiɗau nga hyi nyana ǝnga sǝra hiyau wu miya nji ta ya? ");
INSERT INTO mfm_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mi ngǝ ɗa nahyi nggabiya abǝr aˈyi ar kǝra macikǝl nga ya vǝr ndǝr maya? Ama yi na anǝ hyi aga hya hangǝkal ǝnga thlǝlamǝ nǝ njir Farisi ǝnga njir Sadusi.” ");
INSERT INTO mfm_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kǝ ndǝ nggabiya abǝr naja aˈyi a vǝr ndǝr anǝ nda, aga nda hangǝkal ǝnga thlǝlamǝ nǝ ta macikǝl mai, ama ar kǝra highiɓǝ nǝ njir Farisi ǝnga njir Sadusi. ");
INSERT INTO mfm_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ar pǝci kǝra Yesu shili wu ˈyiˈyir Kayisariya Fǝlipi, kǝ ji yiwa zǝmbǝlma nyiˈyar, ji na, “Wa nga nju na ǝnga ya, nayi Zǝr Nda?” ");
INSERT INTO mfm_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kǝ ndǝ shaɗǝwa nyi, “Alenyi nju na Yahwana ndǝr mǝl Baɓǝtizǝma, ǝnga alenyi nji Iliya, ǝnga alenyi nji tsu Irimiya ǝnga zǝmǝ wu pama nabiˈyar.” ");
INSERT INTO mfm_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Ama kar nahyi tsu, wa nga hyu na nga ya?” ji yiwa nda. ");
INSERT INTO mfm_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Kǝ Simanu Biturusu shaɗǝwa, ji na, “Nagǝ ngǝ Kǝrsiti, Zǝr Hyal kǝra ǝnga pi.” ");
INSERT INTO mfm_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kǝ Yesu na anǝ nyi, “Ndǝr barka nga gau, Simanu zǝr Yunana, arya aˈyi ndǝ ngǝ cabiya ngǝ sǝ kǝ mai, ama Dǝɗa kǝra a dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yu na anǝ ngau, nagǝ Biturusu tsǝka ngau, ar kǝra tsǝka kǝ nga yu hǝr daɓǝ dzǝ njir nu ɗa, daɓǝ njira sǝra ǝnga dǝnama nǝ tau, aˈyi a sǝn sǝm tǝlkur ar kǝra nda mai. ");
INSERT INTO mfm_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yu nǝ ngǝ sǝr pahǝ miya ki nǝ tǝlkur Hyal. Ətsu kalar sǝra gǝ mbiya wu duniya mbamba nga nyi a dǝmǝlmau, ǝnga kalar sǝra gǝ pǝlna wu duniya pǝpǝl nga nyi a dǝmǝlmǝ ǝtsu.” ");
INSERT INTO mfm_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kǝ Yesu tǝɗar himiya zǝmbǝlma nyiˈyar abǝr nda sara na sǝ kǝ anǝ kalar ndǝ abǝr naja ngǝ Kǝrsiti mai. ");
INSERT INTO mfm_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mbari ar pǝci kǝ ngǝ Yesu dzǝguya na anǝ zǝmbǝlma nyiˈyar, abǝr kǝl ji maˈyi a vu Urshalima. A vuna ju vuwa lar ɓwaɓwatǝ pamǝpamǝu. Nji nggunggurǝm nǝ mǝlmau, ǝnga pubu dǝdǝgalˈyar, ǝnga malǝmǝ dlaɗǝˈyar wu nda piyari nyi, ba nda tsǝya nyi, ama ayukuɗa pida makǝru, ba ja hyaˈari ǝnga pi. ");
INSERT INTO mfm_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kǝ Biturusu hǝr nyi a ndar batiti, ji nda kughiya nyi, ji na, “Wu ɗa mai Thlagǝu, Hyal a tsana sǝ ǝnggǝr kǝ a ɗa ǝnga gau.” ");
INSERT INTO mfm_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ama kǝ Yesu shabiya dzau, ji na anǝ Biturusu, “Tǝkǝ ǝnga yau, Shatan! A ɗar gǝ sǝr thlǝ hi anǝ ɗa, ara ɗǝnga ngau ǝnggǝr nǝ nji nga nyi, aˈyi nǝ Hyal mai.” ");
INSERT INTO mfm_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kǝ Yesu nar nyi anǝ zǝmbǝlma nyiˈyar, “Kalar ndǝra wu yiwu ja nu ɗa, kǝl ja piyari yiwu kǝrnyi, ba ja hǝri wu dladlakǝ nyi, ba ja nu ɗa. ");
INSERT INTO mfm_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ara kalar ndǝra wu yiwu piya ja, ju nda tini. Ndǝra gǝra yiwu piya ja arya yau, ju nda uya. ");
INSERT INTO mfm_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mi ngǝ akkǝri kǝra ndu uya ma nji nǝ nyi duniya patǝu, ba ja tini piya ja? Əndǝga mi ngǝ ndǝ a sǝn lǝri ar viya piya ja? ");
INSERT INTO mfm_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Arya nayi Zǝr Ndau, wu nda shili wu kadakadarkur nǝ Dǝɗa ǝnga waladi ɗaˈyar. Yu sa mǝliya nyi numa anǝ patǝr njir duniya ar lagu kǝra ndǝ mǝl thlǝrǝr nda ari. ");
INSERT INTO mfm_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yu nar hyi jirkura nyi, alenyi nji aˈyi ǝnggau tataˈyu, nandu nda tǝ mai, kǝl ndǝ lar Zǝr Ndau wu shili wu tǝlkur nyi.” ");
INSERT INTO mfm_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ayukuɗa pida kwa, kǝ Yesu hǝri Biturusu ǝnga Yakubu ǝnga Yahwana zamǝya Yakubu ba ji hǝr nda a ndar kǝra vanyi mau kǝra dzǝgamǝu, nanda zhizhir nda. ");
INSERT INTO mfm_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","A ndǝna, kǝ dza ja bǝlana dzǝ wu mwar nda. Bama ja wu mbǝl ǝnggǝr pǝci ǝnga lǝgutǝ nyi ɗa pǝrtǝ pwahǝu. ");
INSERT INTO mfm_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kukuthlǝ kǝ nabi Iliya ǝnga nabi Musa shili nda vǝr ndǝr ǝnga Yesu. ");
INSERT INTO mfm_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Biturusu na anǝ Yesu, “Thlagǝu, shilir mǝn ǝnggǝ kau, a ɗar mǝnahǝu. Ma gu yiwu, ya sǝn mǝliya kwapatǝ makǝr ǝnggau, pathlǝ anǝ ngau, pathlǝ anǝ Musa ǝnga pathlǝ anǝ Iliya.” ");
INSERT INTO mfm_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ma tsu ja vǝr ndǝr, kǝ mbǝmbǝl sara du dlama sa haɗiya nda, kǝ nji nggari ɗahǝu sara du dlama wu na, “Naja kau, Zǝr Ɗa ngau, yu yiwu nyi; huɗa yi pipida ǝnga ja gagaɗau. Hya sǝya nyi himi!” ");
INSERT INTO mfm_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ənggǝra zǝmbǝlma nyiˈyar nggari abangau, ba hivǝr mbar nda, kǝ ndǝ uzhiya bama nda a gyiwu ˈyi. ");
INSERT INTO mfm_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ama kǝ Yesu shili ji sa tsǝkwar nda, ji na “Hyaˈara mau. A sara hya hivǝr mai.” ");
INSERT INTO mfm_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ənggǝra ndǝ hyaˈanakǝr, nandǝ ɓǝra lar ndǝ mai kǝl Yesu zhizhi nyi. ");
INSERT INTO mfm_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ənggǝra nda vǝr shida sara dar ma nyi, Yesu kughiya nda, ji na, “A sara hya na anǝ kalar ndǝ sǝ kǝ hyi lar kǝ mai, kǝl ma Zǝr Ndǝ hyaˈari sara vir tau.” ");
INSERT INTO mfm_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kǝ zǝmbǝlma nyiˈyar yiwa nyi, ndǝ na, “Ya ara mi ngǝ malǝmǝ dlaɗǝˈyar na abǝr kǝl Iliya ɓǝra shili tanggǝrma ka?” ");
INSERT INTO mfm_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu shaɗǝwa, ji na, “Pakatǝ Iliya wu shili, ju sa fuwa sǝ patǝ wu lagu. ");
INSERT INTO mfm_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ama, yu nar hyi, abǝr, Iliya a shiliri tsu kaɗǝu, ama nandǝ tsamǝ ri nyi mai, kǝl ta ndǝ mǝliya nyi sǝra ndu yiwu. Abangǝ tsu ngǝ Zǝr Ndau, wu nda lari ɓwaɓwatǝ wu tsa nda.” ");
INSERT INTO mfm_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kǝ zǝmbǝlma nyiˈyar nggabiya abǝr ja vǝr ndǝr anǝ nda ar kǝra Yahwana ndǝr mǝl Baɓǝtizǝma. ");
INSERT INTO mfm_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ənggǝra ndǝ shili ǝgya daɓǝr dlami, ba vanyi ndǝ shili ara Yesu, kǝ ji sa uzhau wu mwa nyi, ji na, ");
INSERT INTO mfm_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Thlagǝu, tǝhuɗǝ ǝgya zǝr ɗa kau. Sǝ tsatsa ngǝ wu tsa nyi, ǝnga tsu ju lar ɓwaɓwatǝ gagaɗau. Aga gangǝ nga ju tǝɗǝ a gwu uˈu, ǝnga tsu a gwu ˈyimi. ");
INSERT INTO mfm_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yi shili ǝnga ja anǝ zǝmbǝlma ngǝˈyar, ama nandǝ sǝn shilǝgǝbiya nyi mai.” ");
INSERT INTO mfm_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu shaɗǝwa nda, ji na, “Nahyi nji kabangǝkau, nji gǝra mbǝrsa, nji ɗǝmwaˈyu, baˈanuwa nga ya nggya ǝnga hya? Baˈanuwa nga ya sǝsu hya? Shila mau ǝnga zǝra nyi anǝ ɗa.” ");
INSERT INTO mfm_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kǝ Yesu kughiya mambǝl ɗǝmwaˈya nyi, ba ji biya sara wu dza zǝra nyi. Ənggǝrna ba zǝra nyi ɗa jamǝu. ");
INSERT INTO mfm_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kǝ zǝmbǝlma nǝ Yesu ˈyar shila anǝ nyi ar ɗǝwa ndǝ sa yiwa nyi, “Mi ngǝ ɗa ˈyi tǝwa ara kǝdlǝbiya mambǝl ɗǝmwaˈyi ka?” ");
INSERT INTO mfm_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Kǝ Yesu shaɗǝwa nda, “Arya mbǝrsar hyi kushu nga nyi. Ənga jiri yu na anǝ hyi, ma mbǝrsar hyi aˈyi ǝnggǝr culi bǝla, culi kǝra ndiya ǝnga kushu wu culi patǝu, hyu sǝn na anǝ mǝ kau, ‘Hyaˈari ǝnggau ga maˈyi a ndǝna,’ ǝtsu ba ja hyaˈari, ba ja maˈyi. Agabangau, sǝr kar hyi kǝr aˈyi mai.” ");
INSERT INTO mfm_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Culi sǝˈyar kǝ aˈyi wu biya abangǝ mai, kǝl ǝnga kǝdi Hyal ba ǝnga hǝ zǝmǝtsini. ");
INSERT INTO mfm_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ənggǝra zǝmbǝlma nyiˈyar shili ar vi zǝmǝ wu ˈyiˈyir Galili, kǝ ji na anǝ nda, “Nji wu nda lǝr Zǝr Ndau a gwu tsa dawa nyiˈyar, ");
INSERT INTO mfm_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ba nda tsǝya nyi. Ar pǝci makǝrkura nyi ba ja hyaˈari ǝnga pi.” Ba sǝ kǝ fuwa zǝmbǝlma nyiˈyar wu ɗǝnga sǝ gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ənggǝra Yesu ǝnga zǝmbǝlma nyiˈyar shili wu mǝlmǝ Kafarnahumu, njir tsǝm budǝ nǝ umbwa Hyal thlǝwa Biturusu, kǝ ndǝ na anǝ nyi, “Malǝmǝr hyi aˈyi ju ki budǝ nǝ umbwa Hyal wa?” ");
INSERT INTO mfm_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Angǝ, wu ki ja,” ǝngwar ja. Ənggǝra Biturusu shili wu ki, Yesu ngǝ dzǝguya ndǝr anǝ nyi tanggǝrma, ji na. “Simanu, mi nga gwu ɗǝnga? Sara ara wa ngǝ tǝlˈyar nǝ duniya wu dlǝwu buda, sara ara wazhar nda ǝndǝga sara ara alenyi nji ya?” ");
INSERT INTO mfm_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Sara ara alenyi nji,” ǝngwar Biturusu. “Ma abangau, wazhar nda wu ki mai,” Yesu shaɗǝwa nyi. ");
INSERT INTO mfm_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","“Ama a sara mǝna ndzana ɗǝfuwa nda, maˈyi a gwu dǝl ga gwa sǝ dlir, ba ga pahǝna miya kalfi kǝra gǝ mbar tanggǝrma, gu uya gǝnna kǝra daɓaga kina budǝ ngau ǝnga nǝɗa.” ");
INSERT INTO mfm_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ar pǝci ta ngǝ zǝmbǝlma nyiˈyar shili ǝgya ja ndǝ sa yiwa nyi, “Wa nga ndiya ǝnga dǝgal wu tǝlkur Hyala?” ");
INSERT INTO mfm_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kǝ Yesu nggar vanyi zǝr kushu, kǝ ji sa taˈyina nyi wu mwar nji patǝu. ");
INSERT INTO mfm_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kǝ ji na anǝ nda, “Yu nar hyi jirkura nyi, kǝl hyi shabiya ɗǝfuwa hyi, hya ɗa ǝnggǝr wazha yiɗǝɗǝu, nahyi wu sǝn uya gwu tǝlkur Hyal mai. ");
INSERT INTO mfm_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ama kalar ndǝra hǝya kǝra ja, ji shabiya kǝrnyi ǝnggǝr zǝr kushu kau, naja nga ndiya ǝnga dǝgal wu tǝlkur Hyal. ");
INSERT INTO mfm_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Kalar ndǝra dlǝwuri zǝr kushu ǝnggǝr kǝ wu thlǝmǝ ɗa, nayi nga ji dlǝwuri. ");
INSERT INTO mfm_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ama tsu, kalar ndǝra mǝliya pathlǝu wu pama wazha yiɗǝɗǝ kau, kǝra hǝnggǝri ǝnga yau ja thlǝr hi, wu ndiya anǝ ndǝ kǝ nja mbiya bǝra ar fǝlanga ja, ba nja vakuwa nyi a gwar dǝl dǝgal kǝra dzǝgamǝu aga ja gya cau. ");
INSERT INTO mfm_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Sǝr tǝhuɗǝ anǝ duniya ara ju mǝliya nja thlǝ hi! Sǝr thlǝ hiˈyar kǝ a ɗari kǝl nda shili, ama sǝr tǝhuɗǝ anǝ njira sǝˈyar kǝ wu shili lagur nda. ");
INSERT INTO mfm_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ma tsa gau ǝndǝga hiya gǝ ngu fuwa ngǝ ga mǝliya bikau, kuji ga thlana ba ga vakana nyi naɗǝu. Wu ndiya anǝ ngǝ ga uya pi gǝra kuɗau ǝnga hi ǝndǝga tsi papathlǝu a mwara nja vakuwa ngǝ a gwu uˈur kǝtsa gǝra kuɗau ǝnga tsi ba hiya gǝ gyapǝu. ");
INSERT INTO mfm_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma tsu liya gu fuwa ngu bikau, tǝkuɗǝbiya ga vakana. A ndiya ǝnga mǝnahǝu anǝ ngau ga uya pi gǝra kuɗau ǝnga li zǝmǝu, a ndiya nja vakuwa ngau a gwu uˈur kǝtsa ǝnga li mǝthlǝu. ");
INSERT INTO mfm_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Hya hangǝkal hya sara diɗa alaga pathlǝu wu pama wazha yiɗǝɗǝ kau. Ara yu nar hyi abǝr waladir nda ˈyar wu nggya cumu wu mwar Dǝɗa kǝra a dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Arya Zǝr Ndǝ shili aga sa mbǝɗa nji sasa. ");
INSERT INTO mfm_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mi ngǝ ɗǝngar hyi ar kǝra ndǝr ka? Ma ndǝ ǝnga tǝmahǝ gharu, kǝ zǝma nyi sanakǝr, aˈyi ju piyari ǝdlǝkumunyi apǝ ǝdlǝ kau, a gwar tagǝu, ba ja maˈyi a nda gal pathlǝ kǝra sa kǝ wa? ");
INSERT INTO mfm_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Maja nǝr nyi ri, jiri nga yu na anǝ hyi, ju nyabiya dzǝ ǝnga caguli arya pathla tǝmahǝ kǝra ji nǝr kǝ a ndiya ǝdlǝkumunyi apǝ ǝdlǝ ta gǝra sa ta. ");
INSERT INTO mfm_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Abangǝ nga nyi tsu, dǝr hyi kǝra a dǝmǝlmau aˈyi wu yiwu pathlǝ wu pama wazha yiɗǝɗǝ kǝ a sanakǝr mai. ");
INSERT INTO mfm_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ma zamǝ ngǝ mǝliya ngǝ bikau, maˈyi ga nda thlǝwa nyi zhizhi nyi ba ga nar nyi bikǝ kǝra ji mǝliya wu pama hyi mǝthlǝ hyi. Ma ji sǝya ngǝ himi, a shabiya nyir gau. ");
INSERT INTO mfm_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ama ma naji sǝya ngǝ himi mai, nggari ndǝ pathlǝ alaga nji mǝthlǝ ba hya ɓǝra nda thlǝwa nyi. Aga sǝra gu na, nji mǝthlǝ alaga nji makǝru wu hǝnggǝri ǝni. ");
INSERT INTO mfm_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma ji nggǝl ara sǝhimi nda tsu, ba hya hǝr nyi a ndǝgya daɓǝ dzǝ njir nu. Ma naja aˈyi sǝhimi nda tsu mai, ba hya hǝri nyi ar viya ndǝra gǝra sǝni Hyal alaga ndǝr bikǝ ndǝra gǝra tubi. ");
INSERT INTO mfm_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Jiri nga yu na anǝ hyi, kalar sǝra hyi mbiya wu duniya mbamba nga nyi a dǝmǝlmau. Kalar sǝra gǝ mbiya wu duniya mbamba nga nyi a dǝmǝlmau, ǝnga kalar sǝra gǝ pǝlna wu duniya pǝpǝl nga nyi a dǝmǝlmǝ ǝtsu. ");
INSERT INTO mfm_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Yu ɓǝra na anǝ hyi, kalar sǝra nji mǝthlǝ alaga nji makǝr hǝnggǝri ndu kǝdiyau wu duniya, dǝɗa kǝra a dǝmǝlmau wu nda mǝliya nda. ");
INSERT INTO mfm_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ənga hya sǝni abǝr kalar vira nji mǝthlǝ alaga makǝr kaɓǝ ari wu thlǝmǝ ɗa, aˈyi yu pama nda.” ");
INSERT INTO mfm_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kǝ Biturusu shili ji sa yiwa Yesu, “Thlagǝu, aga yiɗawu nga ya kyaga tǝfǝbiya zamǝ ɗa ma ji ndzana ɗa huɗa ya? A ɗa aga mǝɗǝfǝ ya?” ");
INSERT INTO mfm_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Əngwar Yesu, “Awau, aˈyi aga mǝɗǝfǝ mai, ama mǝɗǝfǝ mǝɗǝfau, ar vi mǝɗǝfǝkumunyi. ");
INSERT INTO mfm_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Agabangau, nju gǝlabiya tǝlkur Hyal ǝnga vanyi tǝl kǝra ngga mafa nyiˈyar kǝra ǝnga gǝnna nyi patǝ wu tsa nda aga nda nar nyi sǝra wu tsa nda patǝu. ");
INSERT INTO mfm_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ənggǝra nja vǝr lǝ anǝ nyi sǝra ɓau, kǝ nji shili ǝnga vanyi ndǝ kǝra ǝnga mǝl gangǝ kǝra ji gǝra sǝn kina wu nggyabiya nyi. ");
INSERT INTO mfm_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ta ji tǝwa ara kina gǝnna nyi, kǝ tǝl kǝ sǝwa aga nja ɗǝlna sǝ nyi patǝu, ǝkkǝˈyi mala nyi ba wazha nyi aga ja kina mǝla nyi ǝni. ");
INSERT INTO mfm_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Kǝ mafa kǝ uzhau wu mwar tǝl kau, ju kǝdi nyi, ‘Usi Alvari, tǝhuɗǝ ǝgya yau, yu kina ngǝ patǝu.’ ");
INSERT INTO mfm_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kǝ tǝl kǝ tǝhuɗǝ ǝgya ja, ba ji tǝfǝbiya nyi mǝl kǝra ju nu nyi patǝ ba ji maˈyi. ");
INSERT INTO mfm_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ta ji biya sara wu mwar tǝl ta, ba ji thlǝwa kuvwa nyi mafa kǝra ju nu nyi mǝl nǝ gǝnna kushu. Ji mbar nyi ǝgya fǝlangǝ nga ja, ji na, ‘Kina ɗa mǝl ɗa kabangǝkau.’ ");
INSERT INTO mfm_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Kǝ kuvwa nyi mafa kǝ ɓǝliya undi ju kǝdi nyi, ‘Tǝhuɗǝ ǝgya yau, yu kina ngǝ mǝl ngǝ patǝu.’ ");
INSERT INTO mfm_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ama kǝ ndǝ kǝ nggǝl ara nggar kǝdi nyi, kǝl ta ji fuwa nyi wu fursǝna kǝl ma ji kina nyi mǝl nyi patǝu. ");
INSERT INTO mfm_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ta alenyi mafaˈyar nggari abangau, ba huɗa nda ndzǝ gagaɗau. Kǝ ndǝ maˈyi ka nda nar nyi anǝ tǝl ta, sǝra ɗarkǝr patǝu. ");
INSERT INTO mfm_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Kǝ tǝl kǝ nggar mafa nyi, ji na ‘Nagǝ mafa shishi,’ ‘Yi tǝfǝbiya ngǝ mǝl kǝra wu dza gǝ patǝu, arya gǝ kǝdi ɗa aga ya tǝfǝbiya ngau. ");
INSERT INTO mfm_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aˈyi ɗa tsaˈa ga tǝhuɗǝ ǝgya mafa kuvwa ngǝ wa, ǝnggǝr kǝra yi tǝhuɗǝ ǝgya gǝ ta wa?’ ");
INSERT INTO mfm_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kǝ sǝ kǝ ndzana huɗa tǝl kǝ gagaɗau, kǝ ji sǝwa nja fuwa nyi a gwu fursǝna aga nja nǝ nyi ɓwaɓwatǝu, kǝl ma ji kina gǝnna kǝra ju nu nyi patǝu. ");
INSERT INTO mfm_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Abangǝ tsu ngǝ dǝɗa kǝra a dǝmǝlmau wu nda mǝl anǝ kalar ndǝra wu pama hyi ma hyi gǝra tǝfǝbiya zamǝr hyi ǝnga kwamǝr hyi sara wu ɗǝfuwa hyi.” ");
INSERT INTO mfm_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu kuɗǝna ndǝr kau, kǝ ji piyari Galili, ba ji maˈyi a ndu ˈyiˈyi Yahudi kǝra a biyar ya dǝl Urdǝnu. ");
INSERT INTO mfm_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Dlamir nji gangǝ nu nyi, ba ji shilǝgǝbiya njira ǝnga shilgǝ a ndǝna. ");
INSERT INTO mfm_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ənggau, kǝ alenyi njir Farisi shili aga nda sa dzǝbiya Yesu, ndǝ yiwa nyi, ndǝ na, “Dlaɗǝ Musa na, abǝr a ɗar tsaˈa anǝ ndǝ ja tǝkǝbiya dzǝ ǝnga mala nyi ya?” ");
INSERT INTO mfm_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Kǝ Yesu shaɗǝwa nda, ji na, “Aˈyi hyi saya jigana wa, abǝr tanggǝrma Hyal kǝra mǝliya nda, ‘Ji mǝliya nda sal ǝnga mala’ wa? ");
INSERT INTO mfm_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kǝ ji ɓǝra na, abǝr ‘Arya abangau, ndǝ sal wu piyari dǝnyi ǝnga mǝnyi, nda ɗa sǝ zǝmǝ ǝnga mala nyi, nanda mǝthlǝ ndu ɗa ar viya ndǝ zǝmǝu.’ ");
INSERT INTO mfm_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tsu nda aˈyi nji pamǝpamǝ mǝthlǝ mai, ama kumǝr dzǝ zǝmǝu. Agabangǝ sǝra Hyal mbiya ndǝ a sara pǝlna mai.” ");
INSERT INTO mfm_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kǝ ndǝ na anǝ nyi, “Mi ngǝ ɗa Musa nana a gu lǝkakaɗǝ nyi, abǝr, a ɗar tsaˈa sal ja nǝ nyi lǝkakaɗǝ nǝ sakida kǝdlau anǝ mala ˈya?” ");
INSERT INTO mfm_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kǝ Yesu shaɗǝwa nda, “Ara ɓaɓalkura ɗǝfuwa hyi ngǝ Musa sǝya hyi lagu, ama aˈyi abangǝ ngǝ Hyal mǝliya tanggǝrma mai. ");
INSERT INTO mfm_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yu na anǝ hyi, kalar ndǝra kǝdlǝna mala nyi, ma aˈyi ji mbari nyi a vǝr dlǝnga sal mai, kǝ ji ɓǝra hǝri vanyi mala, a ɗar ja ndǝ sǝsu.” ");
INSERT INTO mfm_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kǝ zǝmbǝlma nyiˈyar na, anǝ nyi, “Ma abangǝ nga nyi wu pama sal ǝnga mala Thlagǝu, kuji kǝ ndǝ a nggya gǝra hǝ mala.” ");
INSERT INTO mfm_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kǝ Yesu shaɗǝwa nda, ji na, “Aˈyi patǝr nji ngu sǝn hǝnggǝri ǝnga culi ndǝr kǝ mai, kǝl njira Hyal dlǝwar nda. ");
INSERT INTO mfm_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Arya alenyi nji ɗa mǝciˈu sal ara nji yabiya nda abangau. Ama alenyi nji tsu, nji ngǝ mǝliya nda ndǝ ɗa mǝciˈu sal. Ənga alenyi nji tsu ngǝ mǝliya kǝrnda mǝciˈu sal arya ndu yiwu tǝlkur Hyal kǝra wu ɗǝfuwa nda. Kalar ndǝra wu sǝn mbar najaka highiɓau, bǝgǝ ja dlǝwuri.” ");
INSERT INTO mfm_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kǝ nji shili ǝnga wazha yiɗǝɗǝ anǝ Yesu aga ja sa fǝr tsa ja ar nda ǝnga ja kǝdi Hyal anǝ nda. Ama kǝ zǝmbǝlma nyiˈyar kughiya njira dla ǝnga wazha kau. ");
INSERT INTO mfm_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ama kǝ Yesu nar nda, “Hya piyari wazha yiɗǝɗǝ nda shili ǝgya yau, hya sara ka nda mai, ara tǝlkur Hyal nǝ culi nji kǝra ǝnggǝr nanda ngau.” ");
INSERT INTO mfm_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kǝ ji fǝr tsi nǝ barka ar nda, ba ji maˈyi. ");
INSERT INTO mfm_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kǝ vanyi ndǝ shili ara Yesu, ji sa yiwa nyi, “Malǝmǝ, mi ngǝ sǝ mǝnahǝu kǝra ya kyaga mǝl aga ya uya pi gǝra kuɗa?” ");
INSERT INTO mfm_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","“Kǝ Yesu na anǝ nyi, “Ara mi ngu yiwa ɗa ar kǝra sǝ mǝnaha? Ndǝ mǝnahǝ aˈyi mai kǝl Hyal wacu. Ma gu yiwu ga uya pi kǝra gǝra kuɗau, kǝl ga ɓǝlari dlaɗǝˈyar kau.” ");
INSERT INTO mfm_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Əngwar ja anǝ Yesu, “Dlaɗǝ mana wu liyanya?” Kǝ Yesu na anǝ nyi, “ ‘Ga sara tsa ndǝ mai. Ga sara mǝl sǝsukur mai. Ga sara hǝl mai. Ga sara thla fati ar kǝra ndǝ mai. ");
INSERT INTO mfm_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ga gǝnggǝr nyi sǝli anǝ dǝngau ǝnga mǝngau. Ga dzǝgwa yiwu kuvwa ngau ǝnggǝr kǝrngau.’ ” ");
INSERT INTO mfm_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kǝ zǝr baduwari ta na anǝ nyi, “A ɓǝlar yi sǝˈyar kǝ patǝ tsu yi zǝr kushu. Mi ngǝ sǝra hya?” ");
INSERT INTO mfm_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu nar nyi, “Ma gu yiwu ga ɗa ndǝ tsapǝu, ga maˈyi ga nda ɗǝlna patǝr sǝra ara gau, ba ga tǝkǝna gǝnna nyi anǝ nji ɗaɗali, gu uya akkǝri a dǝmǝlmau. Ba ga dzǝgwa shili aga ga sa nu ɗa.” ");
INSERT INTO mfm_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ənggǝra ji nggari abangau kǝ zǝr baduwari kǝ ndalǝr bama, kǝ ji maˈyi ǝnga huɗǝ kyakyaru, ara naja ndǝr bǝrba gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kǝ Yesu nar nyi anǝ zǝmbǝlma nyiˈyar, “Yi wu nar hyi jiri, dzadzau nga nyi anǝ ndǝr gǝnna ja gwu tǝlkur Hyal. ");
INSERT INTO mfm_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ətsu yu nar hyi abǝr a ndiya ǝnga ɓatsu anǝ dlǝgwam ja tǝrabiya wu liya libǝra a mwara ndǝr gǝnna ja uya gwu tǝlkur Hyal.” ");
INSERT INTO mfm_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ta zǝmbǝlma nyiˈyar nggari abangau, kǝ ɗa sǝ dǝdǝgur anǝ nda, kǝ ndǝ na, “Ya, ma abangau, wa ngu sǝn uya mbǝɗa?” ");
INSERT INTO mfm_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Kǝ Yesu tsamǝ nda, ji na, “Anǝ ndau, sǝra gǝra sǝn ɗa ngau, ama anǝ Hyal ɓatsu. Ara kalar sau, sǝr ɗa ngau, anǝ Hyal.” ");
INSERT INTO mfm_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kǝ Biturusu shaɗǝwa, ji na, “Kǝja ˈya piyari sǝ patǝ ˈyi nu ngau, mi ngǝ sǝra ˈyi wu nda uya?” ");
INSERT INTO mfm_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu shaɗǝwa nda, ji na, “Yi wu nar hyi jirkura nyi, ar pǝcir nggyabiya kǝra wu nda shili, pǝci kǝra zǝr ndu sa nggya ar tsǝkafǝ nǝ kadakadarkur nyi, nahyi njira wu nu ɗa patǝu, nahyi ngu nda nggya ar tsǝkafǝ nǝ tǝlkur kǝra kumo apǝ mǝthlǝu, hyu mǝl numa anǝ miya umbwa njir Izirayila kumo apǝ mǝthlǝu. ");
INSERT INTO mfm_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ənga tsu kalar ndǝra piyari ki ǝnga zamǝˈyar, ǝnga kwamǝˈyar, ǝnga tada ǝnga ama ba ǝkkǝˈyi wazha ǝnga fa arya yau, ju nda uya a ndiya kau, gharu gharu ǝnga pi kǝra gǝra kuɗau. ");
INSERT INTO mfm_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ama nji gangǝu kǝra tanggǝrma wu nda ɗa njir yukuɗu, ǝnga njir yukuɗǝ tsu ndu nda ɗa nji tanggǝrma. ");
INSERT INTO mfm_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Tǝlkur Hyal ǝnggǝr ndǝra ǝnga fa wu ngau. Vanyi pǝci ji biya kaɗǝ mudlau, ji maˈyi a nda gal njir mǝl thlǝr anǝ nyi wu fa nyi. ");
INSERT INTO mfm_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ta ndǝ dlǝwunggǝri aga ja kina nda gǝnna pǝkǝ nǝ ndǝ papathlǝu, ba ji sǝwa nda a gwar fa wa nyi. ");
INSERT INTO mfm_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ənggǝr saka ǝdlau nǝ mudlau, ba ji ɓǝra biya, kǝ ji lari alenyi nji tataˈyi ar hada sugu sǝ aˈyi ndu mǝl mai. ");
INSERT INTO mfm_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kǝ ji na anǝ nda, ‘Hya maˈyi tsu hya gwa mǝl thlǝr a gwar fa ɗa, ba ya nda sa kina hyi sǝra tsaˈa.’ Ba ndǝ maˈyi. ");
INSERT INTO mfm_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Kǝ ji ɓǝra biya ar pǝci taˈyikǝr ǝnga saka makǝr nǝ wagǝu, kǝ ji ɓǝra faˈari njir mǝl thlǝr. ");
INSERT INTO mfm_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ənggǝr saka tǝfu nǝ wagǝu, kǝ ji ɓǝra biya, ba ji thlǝwa alenyi nji tataˈyi kurthlǝ gǝra a vǝr mǝl thlǝr. Kǝ ji yiwa nda, ji na, ‘Mi ngǝ ɗa hyi pǝkǝ tataˈyi kurthlǝ gǝra mǝl sa?’ ");
INSERT INTO mfm_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“ Kǝ ndǝ shaɗǝwa nyi, ndǝ na, ‘Arya ndǝ aˈyi kǝra hǝr ˈya aga mǝl thlǝr anǝ nyi ǝshina mai.’ “Kǝ ji nar nda, ‘Nahyi tsu maˈya mau a gwar fa ɗa.’ ");
INSERT INTO mfm_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ta wagǝ ɗa, kǝ thlagǝr fa nar nyi anǝ ndǝr tsamǝ fa, ‘Nggar njir mǝl thlǝr kau, ga sa kina nda gǝnna mǝl thlǝrǝr nda, ga dzǝguya ar njira shili ǝwagǝu baˈanǝ njira shili ǝmudlau.’ ");
INSERT INTO mfm_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Njira gwa saka tǝfu nǝ wagǝ shili, ba nji kina nda gǝnna nǝ pǝkǝ papathlǝu. ");
INSERT INTO mfm_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ta njira nji ngga tanggǝrma shili aga nja sa kina nda, ndu nggani abǝr nju nda kina nda a ndiya gǝnna nǝ pǝkau. Ama kǝ nji sa kina nda gǝnna pǝkau, kakalǝ ǝnga njira nji ngga ǝwagǝ ta. ");
INSERT INTO mfm_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ta ndǝ dlǝwuri gǝnna nyi, ba ndǝ mbar jiga miya ar kǝra thlagǝr fa, ");
INSERT INTO mfm_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ndu na, ‘Njira nji ngga ǝwagǝu, njira mǝl thlǝr nǝ saka pathlǝ wacu, nga gǝ mǝliya ˈya kakalǝu, naˈya kǝra pǝkau dlǝm pǝci ar pǝci kwakwaɗǝ a vǝr mǝl thlǝr.’ ");
INSERT INTO mfm_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ama kǝ ji nar nyi anǝ zǝma nda, ‘Bazhi, nayi ɗiya ngǝ mai, aˈyi yi kina ngǝ sǝra mǝ thlana wa? Gǝnna nǝ pǝkǝ ndǝ pathlǝ wa? ");
INSERT INTO mfm_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Dlǝwuri sǝra nji kina ngau, ba ga maˈyi. Nayi ngǝ yiwu ya kina njira dla ǝwagǝu kakalǝ ǝnga hyi njira shili ǝmudlau. ");
INSERT INTO mfm_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Aˈyi ɗa tsaˈa ya mǝl sǝra yu yiwu ya mǝl ǝnga gǝnna ɗa wa? Əndǝga shishikur ngu tǝ ngau, arya nayi ǝnga tsi papahǝ ya?’ ");
INSERT INTO mfm_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Abangau, ngǝ nji nǝ tanggǝrma wu nda ɗa njir yukuɗu, ǝnga njir yukuɗǝ tsu ndu nda ɗa nji tanggǝrma.” ");
INSERT INTO mfm_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ənggǝra Yesu a vǝr maˈyi a du Urshalima ǝnga zǝmbǝlma nyiˈyar, ba ji nggari nanda kumo apǝ mǝthlǝ a ndar batiti, ba ji na anǝ nda, ");
INSERT INTO mfm_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kǝja maˈyi nga mǝna du Urshalima. A vuna nju vuwa nǝ nyi Zǝr Ndau a vu tsa malǝmǝ dlaɗǝˈyar, ba ǝnga pubu dǝdǝgalˈyar. Ndu vuwa thlana nyi numa nǝ tǝ a vuna. ");
INSERT INTO mfm_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","A vuna ndu vuwa nǝ nyi nyi anǝ njira aˈyi njir Yahudiya mai, ba nda dzǝgwa diɗana nyi, ǝnga nda dǝgǝ nyi ǝnga wuɗa, ǝtsu ba nda dzǝgwa dlakǝya nyi ar wu dladlakau. Ayukuɗa pida makǝru ba ja hyaˈari ǝnga pi!” ");
INSERT INTO mfm_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kǝ miya wazha Zabadi shili ara Yesu ǝnga wazha nyi, ji sa ɓǝliya undi wu mwa nyi, ju kǝdi mayiwakur anǝ nda. ");
INSERT INTO mfm_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kǝ ji na anǝ nyi, “Mi nga gu yiwa?” Kǝ ji nar nyi, “Ga mǝliya wazha ɗaˈyar kau, pathlǝu ja nggya ar tsi mazǝma gau ǝnga vanyi ar tsi matsala gau wu tǝlkur ngau.” ");
INSERT INTO mfm_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","“Nahyi wu sǝn sǝra hyu yiwa mai,” Yesu nar nda. “A sǝn nda tǝwari hyi culi ɓwaɓwatǝ kǝra yu nda sa kǝ ya?” “ˈYu nda tǝwari,” ǝngwar nda. ");
INSERT INTO mfm_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ji na anǝ nda, “Ənga jiri hyu nda tǝwari ɓwaɓwatǝ kǝra yu nda sa, ama nǝ nggya ar tsi mazǝma yau ǝnga tsi matsala yau, aˈyi nayi ngu nda lǝ anǝ nji mai. Najaka vi ngǝ dǝɗa pabǝri anǝ njira ji caɗǝbiya tsu ǝmudlau.” ");
INSERT INTO mfm_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ənggǝra alenyi zǝmbǝlma nyiˈyar kumo nggari sǝ kau, ba huɗa nda ndzǝ ǝnga nji kǝ ǝnga zamǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ama kǝ Yesu nggar nda shili ar vi zǝmǝu, ji na, “Hyu sǝni njira nggurǝm njira aˈyi njir Yahudiya mai, wu sǝm tǝlkur ar kǝra njir nda ǝnga njira nggurǝmǝr nda wu ca dǝgalkur anǝ njir nda tsu. ");
INSERT INTO mfm_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ama aˈyi abangǝ nga hyi mai. Kalar ndǝra wu yiwu ja ɗa dǝgal wu pama hyi, kǝl ji ɗa ndǝr mǝl thlǝr anǝ hyi patǝu. ");
INSERT INTO mfm_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ətsu, kalar ndǝra wu yiwu ja ɗa ndǝr tǝɗǝmwa anǝ hyi kǝl ji ɗa mafar hyi. ");
INSERT INTO mfm_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Abangǝ tsu ngǝ Zǝr Ndǝ shili, aˈyi aga nja sa mǝl thlǝr anǝ nyi mai, ama aga ja sa mǝl thlǝr anǝ nji, ba aga ja lǝr piya ja aga ja bǝliya nji gangǝu.” ");
INSERT INTO mfm_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ar pǝci kǝra Yesu ǝkkǝˈyi zǝmbǝlma nyiˈyar piyari Yariko, kǝ dlamir nji gangǝ nu nyi. ");
INSERT INTO mfm_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kǝja nji lǝfǝ mǝthlǝ a vǝr nggya a miya lagu, ta ndǝ nggari abǝr Yesu nga vǝr tǝrabiya, kǝ ndǝ sǝya wau, ndu na, “Thlagǝu, Zǝr Dawuda, tǝhuɗǝ ǝgya ˈya!” ");
INSERT INTO mfm_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kǝ dlamir nji kughiya nda, ndǝ na anǝ nda aga nda bǝgau. Ama kǝ ndǝ ɓǝra sǝya mala wau, ndǝ na, “Thlagǝu, Zǝr Dawuda, tǝhuɗǝ ǝgya ˈya!” ");
INSERT INTO mfm_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kǝ Yesu taˈyau, ji ngga nda, ji na, “Mi nga hyu yiwu ya mǝliya hya?” ");
INSERT INTO mfm_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kǝ ndǝ shaɗǝwa, ndǝ na, “Thlagǝu,” “ˈyi wu yiwu ˈya lar sau.” ");
INSERT INTO mfm_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu tǝhuɗǝ ǝgya nda, ba ji tsǝkwar liya nda. Ənggǝrna, ba liya nda pahau, ba ndǝ lar sau ba ndǝ nu nyi. ");
INSERT INTO mfm_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ənggǝra Yesu ǝnga zǝmbǝlma nyiˈyar vu mǝlmǝ Bethfaji, mǝlmǝ kǝra lǝhǝu wu dzǝr Urshalima, kǝra a dar kǝra mǝ zaitunu. Kǝ Yesu sǝwa zǝmbǝlma nyiˈyar mǝthlǝu, ");
INSERT INTO mfm_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kǝ ji na anǝ nda, “Maˈya mau a vu zǝr mǝlmǝ kǝ a ndumwar hyi kau. Ənggǝra hyi vwau, hyu vuwa thlǝwa vanyi kwara mbamba ar sǝˈyi, ǝnga zǝr nyi. Hya pǝlna nda hya hǝr ɗa nda a shili. ");
INSERT INTO mfm_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ma vanyi ndǝ yiwa hyi, mi nga hyu mǝla, ba hya na abǝr, ‘Thlagǝ ngu yiwu ja mǝl thlǝr ǝnga nda,’ ba ja piyari hyi, hya hǝr nda ǝnga kusa.” ");
INSERT INTO mfm_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Sǝ kǝ ɗarkǝr aga nyabiya sǝra nabi nana, abǝr, ");
INSERT INTO mfm_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Nar nya mau anǝ kwar Sǝhiyona, ‘Lara mau, tǝlǝr hyu shili ara hyi. Naja ndǝra ǝnga hǝkǝr, Kǝja tǝlǝr hyi a vǝr shili, aˈyi nggya a dar ya zǝr kwara.’ ” ");
INSERT INTO mfm_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kǝ zǝmbǝlma nyiˈyar maˈyi, ndǝ nda mǝlna ǝnggǝr kǝra Yesu nar nda nda mǝl. ");
INSERT INTO mfm_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kǝ ndǝ hǝr kwara nyi a shili ǝnga zǝr nyi, ndǝ fǝr lǝgutǝr nda a dar nda aga Yesu a nggya a dari. ");
INSERT INTO mfm_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Dlamir nji gangǝu sǝya lǝgutǝr nda ar lagu aga ja ɓǝ ari. Alenyi nji tsu ɓǝlǝr hyali ndǝ sǝya a gyar lagu. ");
INSERT INTO mfm_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Dlamir nji kǝra a dumwa nyi ǝnga kǝra a gyiwu yukuɗǝ nyi mbar wau, ndu na, “Fal anǝ Zǝr Dawuda!” “Barka anǝ ndǝra shili wu thlǝmǝr Thlagǝu!” “Fal anǝ ndǝra a dǝmǝlmau vira ndiya ǝnga dzǝgamǝu!” ");
INSERT INTO mfm_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ta Yesu vu Urshalima, kǝ hangǝkala mǝlmǝ patǝ hyaˈari, ndu dzǝgwa yiwa, “Wa ngǝ ndǝ ka?” ");
INSERT INTO mfm_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kǝ dlami shaɗǝwa, “Yesu ngau, nabi sara wu Nazǝratu wu ˈyiˈyir Galili.” ");
INSERT INTO mfm_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kǝ Yesu vu ki Hyal ji vuwa kǝdlǝbiya njira vǝr ɗǝl ǝnga ɗǝlna sǝ a vuna patǝu. Kǝ ji shashabiya tǝmbǝl kǝra ndu bǝbǝla gǝnnar nda ari ǝnga nggǝliyanggama nǝ njir ɗǝlna mbǝthla masar. ");
INSERT INTO mfm_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ji na anǝ nda, abǝr, “Tsǝtsǝfǝ nga nyi, “ ‘Nju ngga ki ɗa ǝnga vir kǝdi Hyal,’ ama kǝja hya shabiyari ji ɗa vir ɗǝwa njir ɗalagu.” ");
INSERT INTO mfm_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kǝ nji lǝfau ǝnga nji kadal shili ara ja wu ki Hyal, kǝ ji shilǝgǝbiya nda. ");
INSERT INTO mfm_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ama ta pubu dǝdǝgalˈyar ǝnga malǝmǝ dlaɗǝˈyar lari sǝ dǝdǝgur kǝra ji mǝliya, ǝnga wazha a vǝr wau wu ki Hyal, ndu na, “Fal anǝ Zǝr Dawuda,” ba ndzana huɗa nda. ");
INSERT INTO mfm_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ndǝ yiwa nyi, “Gǝ wu nggar sǝ kǝ wazha ka a vǝr na kǝ ya?” Əngwar Yesu anǝ nda, “Aˈyi hyi saya jigana wa, ‘Nagǝ ngǝ hwathliya wazha ǝnga wazha mamanji aga nda fal ngǝ’ wa?” ");
INSERT INTO mfm_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kǝ ji piyari nda, ji maˈyi a biyar ya mǝlmǝ a biyu Bethlani, vira ji thlalǝbiya vuˈyi ari. ");
INSERT INTO mfm_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Əmudlǝ kaɗǝu, ǝnggǝra Yesu ǝnga zǝmbǝlma nyiˈyar a vǝr sha a vu Urshalima, kǝ wuɓǝ mbar nyi. ");
INSERT INTO mfm_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ta ji lari vanyi wur kanda a miya lagu, ba ji maˈyi a ndǝgya wa nyi, ma ji nggani ju nda uya yaya a dari, ama sǝ aˈyi mai, kǝl hyali wacu. Kǝ ji shiˈwuna wu kau, ji na, “Tsu nju ɓǝra uya wazha a dar gǝ mai.” Ənggǝrna, kǝ wu ta ulǝnakǝr. ");
INSERT INTO mfm_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ta zǝmbǝlma nyiˈyar lari abangau, ba ɗa sǝ dǝdǝgur anǝ nda. Kǝ ndǝ yiwa, “Abari ngǝ wur kanda kǝ ul kukusa ka?” ");
INSERT INTO mfm_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Əngwar Yesu anǝ nda, “Yu nar hyi jiri, ma hyi mbǝrsa ǝnga gǝra tǝkǝkǝr wu ɗǝfuwa hyi, aˈyi hyu mǝliya sǝra ɗa ǝnga wur kanda kǝ wacu mai, ama hyu sǝn na anǝ mǝ kau, ‘Tǝsǝnakǝr ga tǝɗau a gwar dǝl dǝgalǝu,’ ba ja ɗa ǝnggǝr ta. ");
INSERT INTO mfm_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ma hyi mbǝrsa, kalar sǝra hyu kǝdi Hyal, hyu uya.” ");
INSERT INTO mfm_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu gwu huɗa ki Hyal, ma ja vǝr highiɓau, kǝ pubu dǝdǝgalˈyar ǝnga njira nggurǝm shili ara ja. Ndǝ sa yiwa nyi, “Ənga dǝnama wa nga gu mǝl sǝˈyar ka? Wa ngǝ nǝ ngǝ dǝnama nǝ mǝl sǝˈyar ka?” ");
INSERT INTO mfm_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kǝ Yesu shaɗǝwa, “Yi wu yiwa hyi sǝ pathlǝu tsu. Ma hyi shaɗǝwa ɗa, yu nar hyi tara ǝnga dǝnama wa nga yu mǝl sǝˈyar kau. ");
INSERT INTO mfm_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Baɓǝtizǝma nǝ Yahwana, sara mani nga nyi shila? Sara ara Hyal, ǝndǝga sara ara ndau?” Kǝ ndǝ thla su pama nda, ndǝ na, “Ma mǝn na abǝr, ‘Sara ara Hyal,’ ba ja yiwa, ‘Mi ngǝ ɗa nahyi hǝnggǝri ǝnga ja maya?’ ");
INSERT INTO mfm_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ama ma mǝn na, ‘Sara ara nji,’ hivǝr a gwa, arya kalar ndǝ a hǝnggǝr ri abǝr Yahwana nabi nga ja.” ");
INSERT INTO mfm_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kǝ ndǝ shaɗǝwa nyi anǝ Yesu, “ˈYu sǝnbiya mai.” Kǝ ji shaɗǝwa nda, ji na, “Yi wu na anǝ hyi tsu mai, tara ǝnga dǝnama wa nga yu mǝl sǝˈyar kǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mi ngǝ ɗǝngar hyi ar kǝra ndǝr ka? Vanyi ndǝ aˈyi ǝnga wazha shili mǝthlǝu. Ji ngga zǝr tanggǝrma, ji na, ‘Zǝɗa, maˈyi a gwar fa ǝshina.’ ");
INSERT INTO mfm_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Kǝ ji shaɗǝwa anǝ dǝnyi, ‘Nayi wu gwa mai.’ A sǝkari kushu, ba ji ɗǝnga sa gwa, ba ji maˈyi. ");
INSERT INTO mfm_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Kǝ dǝrnda ngga vanyi zǝr kau, ba ji nar nyi sǝra ji na anǝ zǝr tanggǝrma ta. Kǝ ji shaɗǝwa nyi, ‘Yi wu maˈyi tada,’ ama naji maˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Wu pama wazha kǝ ya, wa ngǝ ndǝra mǝliya sǝra dǝrnda wu yiwu wa?” “Zǝr tanggǝrma kau,” ndǝ shaɗǝwa. Kǝ Yesu na anǝ nda, “Ənga jiri nga yu na anǝ hyi, njir tsǝm budau ǝnga zawarˈyar wu nda gwu tǝlkur Hyal a mwara hyi. ");
INSERT INTO mfm_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Arya Yahwana shili aga ja sa canǝ hyi lagu tsapǝ nǝ Hyal, ama nahyi hǝnggǝri ǝnga ja mai, ama njir tsǝm budau ǝnga zawarˈyar hǝnggǝri ǝnga ja. Ayukuɗa hyi lari sǝˈyar kǝ patǝu, kǝ hyi nggǝl ara tubi ǝnga mbǝrsa ǝnga ja.” ");
INSERT INTO mfm_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Nggara mau vanyi karapau. Vanyi thlagǝr fa aˈyi kǝra thlǝkana fa wur inabi. Ji zǝwari fa kǝ wu masǝmǝ, ǝnga ji labiya kaˈu nǝ ɓǝci ˈyimir wur inabi. Kǝ ji liya dzaˈwu nǝ ɓǝla fa. Kǝ ji tǝtǝkǝna fa anǝ njir zǝwa, ba ji maˈyi a nda gǝ ndau. ");
INSERT INTO mfm_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ta pǝcir faˈa sǝ sara a gwa tagǝ ɗa, kǝ ji sǝwa mafa nyiˈyar aga nda dlǝwuri nyi yayar wur inabi kǝra njir dlǝwu fa tsǝmiya nyi. ");
INSERT INTO mfm_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ta njir dlǝwu fa kǝ kathlǝri mafaˈyar kau, kǝ ndǝ dǝgǝ vanyi, ndǝ tsǝya vanyi, nǝ makǝrkura nyi tsu, ba ndǝ tsǝya nyi ǝnga tsǝka vavaka. ");
INSERT INTO mfm_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kǝ ji ɓǝra sǝwa alenyi mafaˈyar a ndiya nǝ tanggǝrma ta, ama kǝ njir dlǝwu fa mǝliya nda tangǝ ǝnggǝr ta. ");
INSERT INTO mfm_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ayukuɗa kǝ patǝu, kǝ ji na, ‘Kabangǝkau, taˈyi ya sǝwa zǝr ɗa, tara ba nda gǝnggǝr nyi sǝli.’ ");
INSERT INTO mfm_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ama ta ndǝ lari zǝra nyi, kǝ ndǝ na wu pama nda, ‘Kǝja ndǝr faˈa ki nyi. Mǝna tsǝya nyi, ba sǝr faˈa ki nyi kǝ patǝ a ɗa nǝr mǝn.’ ");
INSERT INTO mfm_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kǝ ndǝ hǝr nyi, ndǝ vakana nyi a biyar ya masǝmǝ, ba ndǝ tsǝya nyi. ");
INSERT INTO mfm_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ya, ma thlagǝr fa kǝ shili, mi nga hyu nggani thlagǝr fa kau, wu sa mǝl ǝnga njir dlǝwu fa ka?” ");
INSERT INTO mfm_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kǝ ndǝ shaɗǝwa nyi, “Ju nda sana nji ɗǝmwaˈyi hangǝkal kau, ba ja dzǝgwa nǝ nyi fa kǝ anǝ alenyi njir ndzǝ fa pamǝu, njira wu nda nǝ nyi bamiyar nǝ nyi sǝra ndu uya wu fa kǝ patǝ ayukuɗa nji far sǝ a su ki.” ");
INSERT INTO mfm_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kǝ Yesu yiwa nda, “Aˈyi hyi saya jigana wu ndǝr Hyal wa? “ ‘Tsǝka kǝra njir hǝr diɗana ca ngǝ ɗa tsǝka ɓǝlkǝr. Hyal ngǝ mǝliya abangau, ǝnga ja ɗa sǝ dǝdǝgur wu liya mǝn.’ ” ");
INSERT INTO mfm_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Agabangau, yu nar hyi, abǝr, tǝlkur Hyal nju sa hǝna ara hyi, ba nja nǝ nyi anǝ njira wu nda mǝl sǝra Hyal wu yiwu. ");
INSERT INTO mfm_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ndǝra tǝɗau a gyar tsǝka kau, ju ɓǝɓǝl, ama ndǝra tsǝka kǝ tǝɗǝ a gyar ja, ju ǝya dzǝ huhutǝu.” ");
INSERT INTO mfm_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ta pubu dǝdǝgalˈyar ǝnga njir Farisi nggari karapǝˈyar kau, kǝ ndǝ sǝni, abǝr, ar kǝra nda ngǝ Yesu wu ndǝr kau. ");
INSERT INTO mfm_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ndu gal lagu kǝra nda sǝn mbari nyi ari, ama kǝ hivǝr mbar nda ara dlamir nji, ara a hǝnggǝr nda, abǝr, Yesu nabi ngau. ");
INSERT INTO mfm_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu ɓǝra ndǝr anǝ nda ǝnga karapǝˈyar, ji na, ");
INSERT INTO mfm_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Tǝlkur Hyal ǝnggǝr vanyi tǝl kǝra pabǝri nyi mini nǝ hǝ mala anǝ zǝr nyi nga nyi. ");
INSERT INTO mfm_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ji sǝwa mafa nyiˈyar aga nda nda nggari njira nji nggǝya a shili wu mini kau, ama ba ndǝ nggǝl ara shili. ");
INSERT INTO mfm_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Kǝ ji ɓǝra sǝwa alenyi njir mǝl thlǝr nyiˈyar a nda nǝ njira ji nggǝya, ji na, ‘Nar nda mau, abǝr, sǝ aˈyi kǝra shiwangǝ mai, a fuwar yi sǝ patǝ wu lagu. A tsiyar yi gyaliˈyar ǝnga thla pamǝpamǝ nggǝnggǝthlau, sǝr sǝm tsu a tari. Shila mau, patǝ a shili wu mini kau.’ ");
INSERT INTO mfm_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ama nandǝ sǝya nyi himi mai. Kǝ kalar ndǝ maˈyi sǝ nyi a nda mǝl sǝr kǝrnyi. Vanyi ndǝ maˈyi a gwar fa nyi, ǝnga vanyi ndǝ tsu, a ndar sugu. ");
INSERT INTO mfm_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kǝ alenyi nji mbar mafa nyiˈyar, ba ndǝ dǝgǝ nda, kǝl ta ndǝ tsǝya nda. ");
INSERT INTO mfm_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kǝ huɗa tǝl kǝ ndzǝ gagaɗau. Kǝ ji sǝwa soja nyiˈyar aga nda nda sana njir tsa mafa nyiˈyar kau, ǝnga nda nggyina mǝlmǝr nda. ");
INSERT INTO mfm_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Kǝ ji nar nyi anǝ mafa nyiˈyar, ‘Kǝja pǝcir mini a shiliri, kǝja njira yi nggǝya a nggǝlǝr nda ara shili. ");
INSERT INTO mfm_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Maˈya mau a ndu huɗa giwa, kalar ndǝra hyi thlǝwa hya nggar nyi a shili wu mini kau.’ ");
INSERT INTO mfm_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kǝ mafa nyiˈyar biya ndǝ maˈyi a ndu huɗa giwa, ndǝ nda nggǝya kalar ndǝra ndǝ thlǝwa, nji ɗǝmwaˈyi ǝnga nji mǝnahǝu a shili ar vir mini kau. Kǝ vi kǝ nyi caɓǝu ǝnga mǝthlǝpi kǝra nji nggǝya. ");
INSERT INTO mfm_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ar pǝci kǝra tǝl shila tsamǝ mǝthlǝpi kǝra nji nggǝya, kǝ ji thlǝwa vanyi ndǝ kǝra gǝra ǝnga kar nǝ mini ar dza ja. ");
INSERT INTO mfm_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kǝ ji na anǝ nyi, ‘Bazhi, lagu mani nga gǝ shili ǝngga gǝra ǝnga lǝgutǝ nǝ mini ar dza ga?’ Ama sǝ aˈyi kǝra nda nyi wu sǝn na mai. ");
INSERT INTO mfm_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Kǝ tǝl nar nyi anǝ njir mǝl thlǝr nyi, ‘Mbiya nya mau tsi daɓǝ ǝnga hi, ba hya vakana nyi a biya a biyu kuthlǝu, vira nju vuwa tiwi ǝnga sǝlǝm ba ǝnga ɗǝ hir!’ ");
INSERT INTO mfm_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Arya njira nji ngga gangǝu, ama nji ɗǝɗǝmǝ yiɗawu.” ");
INSERT INTO mfm_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kǝ njir Farisi biya mbiya miya lagu kǝra nda sǝn mbari Yesu lagur sǝra ju na. ");
INSERT INTO mfm_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kǝ ndǝ sǝwa zǝmbǝlmar nda ˈyar ǝnga njira nju ngga nda njir nu Hirudusu. “Malǝmǝ,” ǝngwar nda, “ˈYu sǝni nagǝ ndǝ jijiri ngau, ǝnga gu highiɓǝ lagu Hyal kǝra jiri. Nagǝ wu tazhira mai, arya patǝr nji kakalǝ nga nda wu mwa ngau. ");
INSERT INTO mfm_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nar ˈya ja, a ɗar tsaˈa ˈya ki budau anǝ Kayisaru ǝndǝga awau?” ");
INSERT INTO mfm_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ama ara Yesu wu sǝn ɗǝnga ɗǝmwaˈyir nda, kǝ ji na, “Nahyi njir ngguta vi, ara mi nga hyu ngga lǝbam anǝ ɗa? ");
INSERT INTO mfm_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Canǝ ɗa mǝ gǝnna kǝra nju ki budǝ ǝni.” Kǝ ndǝ hǝbiya nyi kwaɓa, ");
INSERT INTO mfm_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","kǝ ji yiwa nda, “Bama wa ǝnga thlǝmǝr wa nga ar kwaɓa ka?” ");
INSERT INTO mfm_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Bama ǝnga thlǝmǝr Kayisaru,” ǝngwar nda. “Ma abangǝ ja,” ǝngwar ja, “Hya nǝ nyi anǝ Kayisaru sǝra nǝ Kayisaru, anǝ Hyal tsu sǝra nǝ Hyal.” ");
INSERT INTO mfm_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ta ndǝ nggari abangau, ba ɗa sǝ dǝdǝgur anǝ nda. Agabangau, ba ndǝ piyari nyi ba ndǝ maˈyi sǝr nda. ");
INSERT INTO mfm_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tsu ar pǝci ta, njir Sadusi, njira na abǝr hyaˈari sara vir tau aˈyi mai shili ara Yesu, ndǝ sa yiwa nyi. ");
INSERT INTO mfm_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Malǝmǝ,” ǝngwar nda, “Musa nar ˈya abǝr ma sal tau gǝra ya ǝnga mala nyi, ba zamǝ nyi a hǝri mala nyi kǝ aga ja yabiya nyi wazha a gwa. ");
INSERT INTO mfm_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kabangǝkǝ wu pama ˈya, zamǝˈyar aˈyi mǝɗǝfau. Nda dǝgala nda hǝr mala, ba ji tǝ gǝra ya zǝr. Kǝ ji piyari mala kǝ anǝ zamǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Abangǝ nga nyi ɗa ǝnga zamǝ nyi nǝ mǝthlǝkura nyi, ǝnga nǝ makǝrkura nyi, baˈanǝ nǝ mǝɗǝfǝkura nyi kau. ");
INSERT INTO mfm_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ayukuɗa nyi patǝu, kǝ mala nyi tǝ tsu. ");
INSERT INTO mfm_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ma nji hyaˈari sara vir tau, mala wa nga ju nda ɗa wu pama nda? Arya patǝkura nda a hǝri nyi ri nda aga mala.” ");
INSERT INTO mfm_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu shaɗǝwa nda, ji na, “Ɗǝngar hyi aˈyi tsatsaˈa mai ara nahyi wu sǝn sǝra tsǝtsǝfǝ wu ndǝr Hyal mai ǝnga nahyi wu sǝn dǝnama nǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ar pǝcir hyaˈara vir tau, shili wu hǝ mala mai, mathlǝkǝˈyi tsu nju lǝ anǝ shili mai, ama ndu nda ɗa ǝnggǝr waladiˈyar a dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ar kǝra hyaˈari sara vir tau aˈyi hyi jigana sǝra Hyal nana anǝ hyi wa? Ənggǝra nji tsǝfǝri abǝr, ");
INSERT INTO mfm_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nayi ngǝ Hyal nǝ Ibrahimu, ǝnga Hyal nǝ Ishaku ba ǝnga Hyal nǝ Yakubu.’ Aˈyi ja Hyal nǝ nji tǝtǝ mai ama Hyal nǝ njira ǝnga pi.” ");
INSERT INTO mfm_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ənggǝra dlamir nji nggari abangau, ba highiɓa nyi ɗa sǝ dǝdǝgur anǝ nda. ");
INSERT INTO mfm_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ta njir Farisi nggari abǝr Yesu a haɗiyari miya njir Sadusi, ba njir Farisi kaɓiya dzǝ ba ndǝ shili ǝgya Yesu. ");
INSERT INTO mfm_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Pathlǝu wu pama nda, ndǝra wu sǝn sǝ gagaɗau ar kǝra dlaɗau, sa dzǝ Yesu ǝnga najaka yiwa sau. ");
INSERT INTO mfm_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Malǝmǝ, dlaɗǝ mani nga ndiya patǝr dlaɗǝ ǝnga dǝgala?” ");
INSERT INTO mfm_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu shaɗǝwa nyi, ji na, “ ‘Ga yiwu Hyal Thlagǝ ngau ǝnga ɗǝfuwa gǝ papatǝu, ǝnga piya gǝ papatǝu, ba ǝnga ɗǝnga ngǝ papatǝu.’ ");
INSERT INTO mfm_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Najakǝ ngǝ dlaɗǝ nǝ tanggǝrma, naja nga ndiya ǝnga dǝgalǝu. ");
INSERT INTO mfm_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Minu nyi ǝnggǝr naja nga nyi, ‘Ga yiwu tǝwul ngau ǝnggǝr kǝrngau.’ ");
INSERT INTO mfm_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Patǝr dlaɗau ǝnga highiɓǝ nǝ Nabiˈyar ar dlaɗǝˈyar kǝ mǝthlǝ kǝ nga ndǝ taˈyau.” ");
INSERT INTO mfm_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ar pǝci kǝra njir Farisi daɓǝya dzǝ ar vi zǝmǝu, kǝ Yesu yiwa nda, ");
INSERT INTO mfm_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mi ngǝ ɗǝngar hyi ar kǝra Kǝrsiti ya? Zǝr wa nga ja?” “Zǝr Dawuda,” ǝngwar nda. ");
INSERT INTO mfm_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kǝ Yesu na anǝ nda, “Ya lagu mani ngǝ Dawuda wu ndǝr lagu Mambǝl, ju ngga nyi ǝnga ‘Thlaga’? Arya ji na, ");
INSERT INTO mfm_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Thlagǝ na anǝ Thlagǝ ɗa, “Nggya lagu mazǝma yau, kǝl yi fiya dawa ngau ǝgya kiɗa hiya gau.” ’ ");
INSERT INTO mfm_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ma Dawuda ngga nyi ǝnga ‘Thlagǝu,’ lagu mani nga ji ɓǝra ɗa zǝr nya?” ");
INSERT INTO mfm_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ndǝ aˈyi kǝra uya sǝr shaɗǝwa mai, mbari ar pǝci ta ndǝ aˈyi ǝnga ɗǝfu yiwa nyi sǝ mai. ");
INSERT INTO mfm_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kǝ Yesu nar nyi anǝ dlamir nji ǝnga zǝmbǝlma nyiˈyar, ");
INSERT INTO mfm_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Malǝmǝ dlaɗǝˈyar ǝnga njir Farisi nanda ngǝ ǝnga dǝnama nǝ highiɓǝ dlaɗǝ nǝ Musa. ");
INSERT INTO mfm_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Agabangǝ hya nggya njir ɓǝla kalar sǝra ndu na. Ama hya sara mǝl sǝra ndu mǝl mai, arya nandǝ wu ɓǝlari sǝra ndu highiɓǝ mai. ");
INSERT INTO mfm_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ndu mbiya kar tǝdǝɓǝu kǝra dzadzau ara hau ba nda fǝr nyi ar papadla nji, ama nanda ǝnga kǝrnda nandǝ wu fǝ alaga zǝr tsa nda aga dlǝwa nda mai. ");
INSERT INTO mfm_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ndǝ wu mǝl sǝr mǝla nda patǝ aga nja na. Ndu mbǝ pǝrki nǝ fǝ ndǝr Hyal dlaɓǝ ǝnga takulagǝu ba ǝnga nggusǝri nǝ ha ǝgya fǝlangǝ dzǝgamǝu. ");
INSERT INTO mfm_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","“Ndu yiwu nja nǝ nda vir nggya kadakadarkur wu mini, ǝnga sǝr nggya kǝra ndiya ǝnga mǝnahǝu wu umbwa daɓǝ dzǝˈyar. ");
INSERT INTO mfm_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ndu yiwu nja usa nda ar sugu, ǝnga ndu yiwu tsu nja ngga nda ǝnga ‘Malǝmǝ.’ ");
INSERT INTO mfm_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ama nja kyaga ngga hyi ǝnga ‘Malǝmǝ’ mai, arya Malǝmǝ zǝmǝ nga ja ara hyi wacu, ǝnga zamǝ nga hyi patǝu. ");
INSERT INTO mfm_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Hya sara ngga ndǝr duniya ǝnga ‘Tada’ mai, arya Tada zǝmǝ nga ja ara hyi, naja ngǝ ndǝra a dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ətsu, nju kyaga ngga hyi ǝnga ‘Tarki’ mai, arya Tarki zǝmǝ nga ja ara hyi, naja ngǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Gau wur hyi, ja ɗa ǝnggǝr ndǝr mǝl thlǝr anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kalar ndǝra wu fǝ kǝrnyi nju nda tina nyi, ama ndǝra tina kǝrnyi tsu nju nda hana nyi. ");
INSERT INTO mfm_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Sǝr tǝhuɗǝ anǝ hyi malǝmǝ dlaɗǝ Musa ˈyar ǝnga njir Farisi, njir ngguta vi! Hyi dari nyi lagur vu tǝlkur Hyal anǝ nji. Nahyi ǝnga kǝrhyi nahyi vu mai, ǝnga nahyi piyari nyi lagu tsu anǝ njira vǝr yiwu nda vu mai. ");
INSERT INTO mfm_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Sǝr tǝhuɗǝ anǝ hyi malǝmǝ dlaɗǝˈyar ǝnga njir Farisi, nahyi njir ngguta vi! Hyu mbǝtǝbiya kar mathlǝkǝˈyi tǝsal ǝnga hya dzǝgwa mǝliya kǝdi Hyal tugu aga nja na. Agabangau, Hyal wu nda nǝ hyi ɓwaɓwatǝ gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Sǝr tǝhuɗǝ anǝ hyi malǝmǝ dlaɗǝˈyar ǝnga njir Farisi, njir ngguta vi! Hyu maˈyi baˈa a biyar ya mǝlmǝ ǝnga a biyar ya dǝl, aga hya kǝzǝya alaga zǝmbǝlma pathlǝu kǝra wu nu hyi. Ama tsu ndǝra hyi uya, ba hya mǝliya nyi fǝrkafǝrka a ndiya hyi, nahyi wazha uˈur kǝtsa. ");
INSERT INTO mfm_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Sǝr tǝhuɗǝ anǝ hyi, nji lǝfǝ nǝ tǝɗǝmwa. Kǝ hyu na, ‘Ma ndǝra sǝm fǝla ǝnga ki Hyal, naji ndzana sǝ mai, ama ndǝra sǝm fǝla ǝnga ǝndzau nǝ ki Hyal, sǝm fǝla nyi a mbar nyi ri.’ ");
INSERT INTO mfm_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nji thlǝkǝlǝmǝu, nji lǝfau! Mani nga ndiya ǝnga dǝgala, ǝndzau ǝndǝga Ki Hyal kǝra mǝliya ǝndzǝ kǝ cica? ");
INSERT INTO mfm_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Hya vǝr na tsu, ‘Ma ndǝra sǝm fǝla ǝnga bagadi nǝ nggyi sau, naji ndzana sǝ mai, ama ndǝra sǝm fǝla ǝnga sǝra nji lǝri, sǝm fǝla nyi a mbari nyi ri.’ ");
INSERT INTO mfm_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nji lǝfau! Mani nga ndiya? Sǝra nji lǝri ǝndǝga bagadi kǝra mǝliya sǝra nji lǝri kǝ cica? ");
INSERT INTO mfm_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nggara mǝ ja, kalar ndǝra sǝm fǝla ǝnga bagadi nǝ Hyal, a sǝmkur ja fǝla ǝni ba sǝra a dari patǝu. ");
INSERT INTO mfm_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kalar ndǝra sǝm fǝla ǝnga Ki Hyal tsu, a sǝmkur ja fǝla ǝni ǝnga ndǝra vǝr nggya a gwa. ");
INSERT INTO mfm_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kalar ndǝra sǝm fǝla ǝnga dǝmǝlmau, a sǝmkur ja fǝla ǝnga tsǝkafǝ Hyal ǝnga ndǝra vǝr nggya a dari. ");
INSERT INTO mfm_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Sǝr tǝhuɗǝ anǝ hyi, malǝmǝ dlaɗǝˈyar ǝnga njir Farisi, njir ngguta vi! Hyu hǝbiya nyi anǝ Hyal pathlǝu wu sǝ kumo nǝ kwanjaɗi, ǝnga nggajiji, ba culi kanggǝranggahyiu. Ama kǝ hyi piyari dlaɗǝ kǝra ndiya ǝnga mǝnahǝu, ca ngǝ mǝl sǝra tsaˈa, ba tǝhuɗǝu, ba taˈyi ar jirkur. Hyu kyaga mǝl thlǝr ǝnga sǝˈyar kau, aˈyi kǝl hya piyari alenyi sǝ mai. ");
INSERT INTO mfm_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nahyi njir tǝɗǝmwa lǝfau, hyu tsǝbiya favǝ wu ˈyimi a sara hya tasiya, ama kǝja hya dzǝgwa tasiya ri dlǝgwamǝu. ");
INSERT INTO mfm_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Sǝr tǝhuɗǝ anǝ hyi, malǝmǝ dlaɗǝˈyar ǝnga njir Farisi, njir ngguta vi! Hyi cina dagǝrya cala ǝnga cala wu, ama huɗa nyi nyinyi ǝnga dlǝrbau ǝnga kasali. ");
INSERT INTO mfm_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nahyi Farisi nji lǝfau! Hya kyaga cina huɗa cala ǝnga cala wu kwatahǝu, kadivira ya nyi a ɗa camǝ tsu. ");
INSERT INTO mfm_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Sǝr tǝhuɗǝ anǝ hyi, malǝmǝ dlaɗǝˈyar ǝnga njir Farisi, njir ngguta vi! Ənggǝr hu kǝra nji pabǝri ya nyi pǝrtǝ nga hyi, sara biya nju lari nyi gumaguma, ama a vu huɗa nyi, nyinyi nga nyi ǝnga ɗǝhi nji ɗiɗiya ǝnga kalar sǝ diyadiyaɓǝu. ");
INSERT INTO mfm_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Lagu zǝmǝ nga hyi, nju lari a biya ǝnggǝr nji tsapǝu, ama a vu huɗa hyi njir ngguta vi ǝnga njira gǝra ɓǝla ndǝr Hyal nga hyi. ");
INSERT INTO mfm_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Sǝr tǝhuɗǝ anǝ hyi, malǝmǝ dlaɗǝˈyar ǝnga njir Farisi, nahyi njir ngguta vi! Hyi hǝriya nyi hu anǝ nabiˈyar ǝnga hyi ɓathlǝya dza hu nji tsapǝu. ");
INSERT INTO mfm_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ənga hyu na, ‘Maja abǝr aˈyi ˈya ar pǝcir ǝjir ˈya, ˈyi wu nda fuwa tsi wu pǝ mashi nǝ nabiˈyar mai.’ ");
INSERT INTO mfm_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Lagu kǝ nga hyi cabiya abǝr nahyi ngǝ culi njira tsǝya nabiˈyar. ");
INSERT INTO mfm_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hya nyabiya tsǝla bikǝ nǝ ǝjir hyi kǝja! ");
INSERT INTO mfm_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Nahyi pabǝˈyar! Wazha mǝtsapa! Lagu mani nga hyu nda kǝtiya kǝrhyi ara numa nǝ uˈur kǝtsa? ");
INSERT INTO mfm_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Agabangau, yu sǝwa hyi nabiˈyar ǝnga njir sǝn sau ba malǝmˈyar. Wu pama nda hyu nda tsǝya, ǝnga hyu dlakǝya alenyi njir nda ar wu dladlakau. Alenyi nji tsu hyu nda dǝgǝ nda ǝnga wuɗa wu umbwa daɓǝ dzǝˈyar, ǝnga hyu nǝ nda ɓwaɓwatǝ ǝnga hya kǝdlǝbiya nda sara wu mǝlmǝ pamǝpamǝu. ");
INSERT INTO mfm_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Agabangau, a dar kǝra hyi ngǝ mashi nji tsapǝu patǝ kǝra nji tsǝya wu duniya, mbari ar mashi Habila ndǝ tsapǝu baˈa shili ar mashi Zakariya zǝr Berikiya, ndǝra hyi tsǝya wu pama vi cici wu Ki Hyal ǝnga bagadi. ");
INSERT INTO mfm_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yu nar hyi ǝnga jiri, numa nǝ sǝˈyar kǝ patǝu wu ɗa ǝnga njir zaman ǝshina kau.” ");
INSERT INTO mfm_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Əm, Urshalima, Urshalima! Ndǝr tsa nabiˈyar, ǝnga ndǝr vavaka njira Hyal sǝwa ngǝ a shili ǝnga tsǝka kǝl ta gǝ dlǝna nda! Aga yiɗau nga yu yiwu ya fǝri tsa yi ar dza nji ngǝ pata, ǝnggǝr kǝra miya tǝka wu tsǝm wazha nyi ǝgya ja, ama nahyi piyari ɗa mai! ");
INSERT INTO mfm_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lara mǝ gǝyi, kǝja kir hyi a nggyari huɗǝfi. ");
INSERT INTO mfm_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yu na anǝ hyi, tsu hyu ɓǝra lari ɗa mai, kǝl hyi nda na, ‘Barka anǝ ndǝra wu shili wu thlǝmǝr Thlagǝu.’ ” ");
INSERT INTO mfm_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kǝ Yesu piyari huɗa ki Hyal ja vǝr maˈyi, kǝ zǝmbǝlma nyiˈyar shili ǝgya ja ndu caca anǝ nyi hǝhǝrˈyar nǝ ki Hyal. ");
INSERT INTO mfm_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","“Hyu lari sǝˈyar kǝ patǝ ya?” ji shaɗǝwa nda. “Yi wu nar hyi jirkura nyi, tsǝka hǝr kiˈyar kau, aˈyi ǝnggau kǝra gǝra dlana mai, nju nda dlana nda papatǝu, nju piyari tsǝka zǝmǝ ar kǝra kuvwa nyi mai.” ");
INSERT INTO mfm_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ma Yesu a vǝr nggya a dar mǝ zaitunu, kǝ zǝmbǝlma nyiˈyar thlǝwa nyi zhizhir nda. Əngwar nda, “Nar ˈya, ǝnuwa ngǝ pǝci kǝra sǝˈyar kǝ wu nda ɗar kǝra, ǝnga mi ngu nda ɗa mǝtsamǝ nǝ shili nga, ǝnga kuɗiyar najaka duniya?” ");
INSERT INTO mfm_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu shaɗǝwa nda, ji na, “Hya nggya hya tsamǝ ǝnga hangǝkal nja sara nggutana hyi.” ");
INSERT INTO mfm_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Arya nji gangǝu wu nda shili wu thlǝmǝ ɗa, ndu na ǝnga kǝrnda, “Nayi ngǝ Kǝrsiti,” ba nda nggutana nji gangǝu. ");
INSERT INTO mfm_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Hyu nda nggari ar kǝra papa ǝnga ndǝr ǝngwa ǝngwa ar kǝra papa, hangǝkalǝr hyi ja sara hyaˈari mai. Kǝl ma sǝˈyar kǝ nyabiya dzau, ama tsu kuɗǝr duniya naɗǝu. ");
INSERT INTO mfm_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ˈYiˈyi wu dlǝɗǝ ˈyiˈyi, ǝnga tǝlkur wu nda par tǝlkur. Wuɓau ǝnga kǝnggǝɗǝr ˈyiˈyi wu nda ɗarkǝr ar vi pamǝpamǝ gangǝu. ");
INSERT INTO mfm_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sǝˈyar kǝ patǝ dzǝgwar ɓwaɓwatǝ ngǝ wacu. ");
INSERT INTO mfm_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Nji wu nda lǝr hyi aga nja nǝ hyi ɓwaɓwatǝ ǝnga tsu nja tsǝtsǝya hyi. Nji patǝ wu nda piyari shishir dza hyi arya yau. ");
INSERT INTO mfm_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ar pǝci ta nji gangǝu wu nda piyari mbǝrsar nda, ǝnga ndu nda thlǝna hiya kuvwar nda, ba tsu nda piyari shishir dza kuvwar nda. ");
INSERT INTO mfm_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nabi fatiˈyar tsu wu nda shili, ba nda sa nggutana nji gangǝu. ");
INSERT INTO mfm_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Arya ɗǝmwaˈyikur wu nda cakau, yiwukur nǝ badǝgala nju nda ɗa shishiˈwu. ");
INSERT INTO mfm_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ama ndǝra cinapi baˈanǝ kuɗiya, ju uya mbǝɗau. ");
INSERT INTO mfm_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ətsu ndǝshigu nǝ tǝlkur Hyal nju nda tǝtǝlna baˈamani wu duniya, aga ja ɗa sakida anǝ njir duniya patǝu, kadivira kuɗiyar duniya wu shili. ");
INSERT INTO mfm_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ma hyi lari sǝ zhizhigǝr wu ki Hyal kǝra cicau, ǝnggǝr kǝra nabi Daniyalu nana ta, bǝgǝ ndǝr jiga ja nggabiya. ");
INSERT INTO mfm_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Bǝgǝ njira vǝr nggya wu Yahudi nda hwi a du mau. ");
INSERT INTO mfm_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ndǝra a dar kǝra umbwa, ja sara gya ja vu ki aga vuwa hǝ sǝ mai, ara ja sara sana pǝci. ");
INSERT INTO mfm_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ndǝra a gwa tagǝ tsu, ja sara sha a su ki aga sa hǝ kar ha nyi mai. ");
INSERT INTO mfm_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pǝci ta wu nda ɗa sǝr tǝhuɗǝ anǝ mathlǝkǝˈyi kǝra ǝnga huɗǝu ǝnga kǝra a vǝr lǝ uˈwa ar pǝci ta! ");
INSERT INTO mfm_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Hya kǝdi Hyal sǝ ka sara ɗa pǝcir fwahǝu ǝnga alaga ar pǝcir ɓǝlsar. ");
INSERT INTO mfm_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ar pǝci ta ɓwaɓwatǝ wu nda ɗa gagaɗau kǝra nji gǝra saya ɗahari mbari ar dzǝgwar duniya, ǝnga tsu culiya nyi wu ɓǝra nda ɗarkǝr mai. ");
INSERT INTO mfm_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Maja aˈyi Thlagǝ gǝnna dzǝgamǝkura pǝci kǝ mai, ndǝr uya mbǝɗau aˈyi mai. Ama arya nji cacaɗǝ nǝ Hyal, a gǝnnar ja dzǝgamǝkura pǝci kau. ");
INSERT INTO mfm_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ar pǝci ta, ma nji nar hyi abǝr, ‘Kǝja Kǝrsiti ǝnggau!’ alaga, ‘Wata ja a ndǝna!’ hya sara hǝnggǝri ǝnga nda mai. ");
INSERT INTO mfm_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Arya Kǝrsiti nǝ fati ǝnga nabiˈyar nǝ fati wu nda shili ndu sa mǝl sǝ dǝdǝgur nǝ ngguta nji alaga nji cacaɗǝ nǝ Hyal ma, ma sǝn ɗa nju nda nggutana nda. ");
INSERT INTO mfm_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nggara mau ja, a nar hyir yi sǝˈyar kǝ tsu kaɗǝu. ");
INSERT INTO mfm_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Agabangau, ma vanyi ndǝ nar hyi, ‘Wata ja a gwar tagǝu,’ hya sara biya sǝhimi nyi mai; alaga ji na anǝ hyi, ‘Kǝja ja ǝnggau ar vir mbwau,’ hya sara hǝnggǝri ǝni mai. ");
INSERT INTO mfm_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Arya shilǝr Zǝr Ndau, nju nda lari patǝ ǝnggǝr kǝra par wu sǝm sara wu sǝbiyar pǝci ba nju lari patǝ wu gwa tǝɗǝ pǝci. ");
INSERT INTO mfm_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ma vira sǝ tǝtau ari ǝna ngǝ kwadǝgǝu wu kaɓau. ");
INSERT INTO mfm_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ayukuɗa pǝcir ɓwaɓwatǝ kǝ tǝrabiya shiˈuɗǝu, “ ‘Pǝci wu nda vu kuthlǝu, ba hya wu nda nggǝl ara mbǝl shashilga wu nda tǝɗau sara dǝmǝlmau, ǝnga tsu dǝnamaˈyar nǝ sǝɓǝ dǝmǝlmau, wu nda kǝnggǝɗǝr dzau.’ ” ");
INSERT INTO mfm_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ar pǝci ta mǝtsamǝ nǝ Zǝr Ndau wu nda cabiya dzǝ a dǝmǝlmau. Njir duniya papatǝu wu nda gwu sǝˈyinggu. Ndu nda lari Zǝr Ndau wu shida sara dǝmǝlmau wu dlama ǝnga dǝnama ba ǝnga kadakadarkur nyi gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ju nda sǝwa waladi nyiˈyar ǝnga nja mbǝɗiya madiya tǝlǝmǝ ǝnga ɗahǝ ngga, ba nda dzǝgwa kaɓiya nji cacaɗǝ nyi sara wu ndǝla mǝlmǝ baˈa ndar vanyi. ");
INSERT INTO mfm_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Highiɓǝra mau sǝ sara ara wur kanda. Ma tsa nyiˈyar dzǝguya dlǝɗau ǝnga hyali wu thlau, hya sǝni abǝr biyargwa a shiliri. ");
INSERT INTO mfm_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Abangǝ tsu, ma hya lar sǝˈyar kǝ a ɗari, hya nggya ǝnga sǝni abǝr pǝci a ɗar lǝhǝu, lǝhǝ ar yir hiya hyi. ");
INSERT INTO mfm_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yu nar hyi jirkura nyi, najaka zamanǝu, aˈyi wu tǝrabiya mai, kǝl sǝˈyar kǝ patǝ nyabiya dzau. ");
INSERT INTO mfm_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Dǝmǝlmau ǝnga gyiwu ˈyi wu nda tǝrabiya, ama ndǝr ɗa nǝ nyi wu tǝɗau a gyiwu ˈyi mai.” ");
INSERT INTO mfm_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ndǝr sǝni pǝci ǝnga saka kǝra sǝˈyar kǝ wu ɗarkǝr aˈyi mai, alaga waladiˈyar kǝra a dǝmǝlmau, ǝnga alaga Zǝra nyi, ama kǝl Tada zhizhi nyi. ");
INSERT INTO mfm_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ənggǝr kǝra ɗarkǝr wu pǝcir Nǝhu, abangǝ nga nyi wu nda ɗa ar pǝcir shilǝr Zǝr Ndau. ");
INSERT INTO mfm_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kadivira pǝlimba sana duniya, nji kǝl sǝm sǝr sǝm ǝnga sa sǝ sasa, ndu faˈa mathlǝkǝˈyi ǝnga ndu lǝ kuˈyi anǝ shili, baˈanǝ shili ar pǝci kǝra Nǝhu gwu kwambwal dǝgal ta ari. ");
INSERT INTO mfm_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Fǝɗǝngǝkǝr nda abǝr sǝ ǝnggǝr kǝ wu ɗa, ya, kǝja pǝlimba a shiliri ka sa kwafǝna nda. Tangǝ ǝnggǝr ta nga nyi wu nda ɗa ar pǝcir shilǝr Zǝr Ndau. ");
INSERT INTO mfm_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ar pǝci ta, shili mǝthlǝ a vǝr mǝl thlǝr ar fa, ba nja hǝr ndǝ pathlǝu ba nja piyari pathlǝu. ");
INSERT INTO mfm_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ar pǝci ta, mathlǝkǝˈyi mǝthlǝ a vǝr awau ar bǝra, ba nja hǝr ndǝ pathlǝu ba nja piyari pathlǝu. ");
INSERT INTO mfm_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Agabangau, hya tsamǝ ǝnga hangǝkal arya nahyi wu sǝnbiya tara pǝci mani ngǝ Thlagǝ wu nda shili mai. ");
INSERT INTO mfm_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nggabiya mau, maja abǝr thlagǝr ki wu sǝni pǝci kǝra ndǝr hǝl wu shili wu ki nyi, ju nggya liliˈu, naji wu piyari ndǝr hǝl a sa pǝthlǝ ki nyi mai. ");
INSERT INTO mfm_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Agabangau, kǝl hya nggya papabau, arya nahyi wu sǝni tara ǝnuwa ngǝ Zǝr Ndau wu nda shili ari mai. ");
INSERT INTO mfm_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Wa ngǝ mafa kǝra tsaˈa miya ɗǝfuwa ǝnga ndǝr mǝl thlǝr kǝra hahanga? Naja ngǝ ndǝ kǝra tarki nyi wu fiya nyi dǝgal ar kǝra njir mǝl thlǝr nyiˈyar, aga ja nǝ nda sǝr sǝm ar pǝci kǝra tsatsaˈa. ");
INSERT INTO mfm_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mafa kǝra thlagǝr ki nyi shili ji sa thlǝwa nyi ja vǝr mǝl thlǝr nyi kakalǝu, ju ɗa ǝnga caguli. ");
INSERT INTO mfm_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yu nar hyi jiri, tarki nyi wu nda fiya nyi dǝgal ar kǝra sǝ nyi patǝu. ");
INSERT INTO mfm_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ama ma ji ɗa, mafa kǝra ɗǝmwaˈyi ngau, ju nda na anǝ kǝrnyi, ‘Kǝja tarki ɗa a nggyari ara shili kaɗǝu.’ ");
INSERT INTO mfm_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ba ji nggya aga dǝgǝ njir mǝl thlǝr kuvwa nyiˈyar, ǝnga ju sǝm ǝnga sa sǝ sasa ǝnga njir sa sǝ sasa. ");
INSERT INTO mfm_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ma ji mǝl abangau, tarki nyi wu nda shili kukuthlǝu ar pǝci kǝra ji gǝra nggani ju shili. ");
INSERT INTO mfm_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tarki wu sa takasiya nyi ba ja sǝwa nja vakuwa nyi a vu pama njir ngguta vi, vira ndu vuwa nggya ndu tiwi ǝnga sǝlǝm ba ǝnga ɗǝ hir.” ");
INSERT INTO mfm_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kǝ Yesu dumwa ǝnga ndǝr, ji na, “Ar pǝci ta, nju nda gǝla tǝlkur Hyal ǝnga kuˈyi kumo kǝra gǝra sǝn ndǝ sal kǝra hǝri pitǝllar nda, aga nda nda sǝkǝ shilǝr salkwanjili. ");
INSERT INTO mfm_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tǝfu wu pama nda dza nga nda, ǝnga tǝfu wu pama nda tsu hahangǝ nga nda. ");
INSERT INTO mfm_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Dza nyiˈyar kǝ hǝri pitǝllar nda gǝra ǝnga mal zaɓǝkwa wu pǝla. ");
INSERT INTO mfm_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Hahanga nyiˈyar hǝri pitǝllar nda ǝnga mal zaɓǝkwa wu pǝla. ");
INSERT INTO mfm_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Salkwanjila nyi aˈyi shili kaɗǝ mai, kǝ ndǝ gwu ghanyi, kǝ ghanyi hǝna nda patǝu. ");
INSERT INTO mfm_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Hathlǝr vuˈyi, kǝ nji siya mala wau, abǝr, ‘Kǝja salkwanjili a shiliri! Sǝbiya mau hya sa dlǝwuri nyi.’ ");
INSERT INTO mfm_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Kǝ kuˈya nyiˈyar patǝ hyaˈari sara wu ghanyi, kǝ ndǝ mbǝmbǝwa uˈu wu pitǝllar nda. ");
INSERT INTO mfm_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kǝ dza nyiˈyar kǝ na anǝ kuˈyi hahangǝ kau, ‘Ɗar ˈya mau, malǝr hyi kǝ kukushu, kǝja pitǝllar ˈya a gwari wu tau.’ ");
INSERT INTO mfm_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Əngwar kuˈyi hahangǝ kǝ anǝ nda, ‘Awau, wu ɗa tsaˈa anǝ mǝn patǝ mai, sǝra hya mǝl ca ngǝ hya maˈyi a biya ara njir ɗǝlna mal aga hya biya ɗǝlbiya nǝr hyi.’ ");
INSERT INTO mfm_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ama ma tsu nda ar lagu a vǝr maˈyi a nda ɗǝl mala nyi, ba salkwanjili shili. Kuˈyi kǝra pabǝri kǝrnda maˈyi ǝkkǝˈyi ja a vwar vir mini nǝ hǝ dzau, kǝ nji haɗiya miya kiya nyi. ");
INSERT INTO mfm_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ayukuɗa ɓǝliya sar kushu kǝ alenyi kuˈyi ta shili, ndu na, ‘Tarki! Tarki! Pahǝna ˈya miya ki!’ ");
INSERT INTO mfm_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ama ju nda shaɗǝwa nda, ‘Nayi wu sǝni hyi mai.’ ");
INSERT INTO mfm_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Agabangau, hya nggya ǝnga hangǝkal arya nahyi wu sǝni pǝci ǝnga saka nǝ shili ɗa mai.” ");
INSERT INTO mfm_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Tǝlkur Hyal wu nda ɗa ǝnggǝr ndǝra wu nda maˈyi a nda gǝ ndǝ naɗǝu, kǝ ji ngga mafa mǝl thlǝr nyiˈyar, ba ji tǝkǝya nda gǝnna nyi. ");
INSERT INTO mfm_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ji nǝ nyi gǝnna dubu tǝfu anǝ vanyi ndau, anǝ vanyi ndau gǝnna dubu mǝthlǝ ǝnga gǝnna dubu pathlǝu tsu anǝ vanyi ndau. Anǝ kalar ndau, ba ji nǝ nyi sǝra tsaˈa aga dǝnama nyi. Kǝ ji dzǝgwa maˈyi a nda gǝ ndau. ");
INSERT INTO mfm_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ndǝra nji nǝ nyi dubu tǝfu maˈyi ǝnga kusa ji nda shafǝli ǝnga sǝra nji nǝ nyi, ba ji uya akkǝri dubu tǝfu a dar kǝri. ");
INSERT INTO mfm_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Abangǝ tsu ndǝra nji nǝ nyi dubu mǝthlǝ uya akkǝri dubu mǝthlǝ a dar kǝra nǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","“Ama ndǝra nji nǝ nyi dubu pathlǝu maˈyi, ji nda labiya kaˈu a gyiwu ˈyi, ba ji ɗǝwana gǝnna thlagǝr ki nyi a gwa. ");
INSERT INTO mfm_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ayukuɗa pida gangǝu, kǝ thlagǝr ki mafaˈyar kǝ sha shili, ji sa yiwa aga nda nar nyi ǝnggǝra ndǝ ɗa ǝnga gǝnna kǝra ji nǝ nda. ");
INSERT INTO mfm_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ndǝra dlǝwuri dubu tǝfu shili ǝnga dubu tǝfu a dar kǝra nyi, ji sa na, ‘Thlagǝr ki, gǝ nǝ ɗa dubu tǝfu, kǝja a ɓǝra uyari yi dubu tǝfu a dar kǝri.’ ");
INSERT INTO mfm_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Thlagǝr ki nyi shaɗǝwa, ‘Usi mafa tsapǝu ndǝr mǝl thlǝr tsaˈa miya ɗǝfu! Gǝ mǝl thlǝr ngǝ tsaˈa miya ɗǝfu ǝnga sǝ kushu kǝra nji nǝ ngau, agabangau, yu nda fiya ngau, ar kǝra sǝ gangǝu. Shili ga nyabiya dzǝ ǝnga caguli ǝnga yau!’ ");
INSERT INTO mfm_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ndǝra dlǝwuri dubu mǝthlǝ tsu shili, ji sa na, ‘Thlagǝr ki, gǝ nǝ ɗa dubu mǝthlǝu, ya, kǝja ya ɓǝra uyari akkǝri dubu mǝthlǝ a dar kǝri.’ ");
INSERT INTO mfm_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Thlagǝr ki nyi shaɗǝwa, ‘Usi mafa tsapǝu ndǝr mǝl thlǝr tsaˈa miya ɗǝfu! Gǝ mǝl thlǝr ngǝ tsaˈa miya ɗǝfu ǝnga sǝ kushu kǝra nji nǝ ngau, agabangau, yu nda fiya ngau, ar kǝra sǝ gangǝu. Shili ga nyabiya dzǝ ǝnga caguli ǝnga yau!’ ");
INSERT INTO mfm_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Kǝ ndǝra dlǝwuri dubu pathlǝu tsu shili, ji sa na, ‘Thlagǝr ki, a sǝni yau abǝr nagǝ ndǝ dzadzau ngau, gu faˈa sau ar vira gǝ gǝra thlǝkana, kǝja nagau ndǝr yiwu sǝ kurthlǝ ngau. ");
INSERT INTO mfm_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ca ngǝ mǝliya hivǝr mbar ɗa ara mǝl thlǝr ǝnga gǝnna ngau, ba yi labiya kaˈu a gyiwu ˈyi, ba yi ɗǝwana a gwa. Kǝja sǝ ngau tsu tsǝkaˈa.’ ");
INSERT INTO mfm_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Kǝ thlagǝr ki nyi shaɗǝwa, ‘Nagǝ mafa ɗǝmwaˈyi hangǝkal ndǝ kukufǝu! Əm, a sǝni gǝ abǝr yu sǝn faˈa sau ar vira yi gǝra thlǝkana ǝnga nayi ndǝr yiwu sǝ kurthlǝ ngǝ ya? ");
INSERT INTO mfm_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ma abangǝ ja, gu kyaga nda hǝri gǝnna ɗa a dar vir fǝ gǝnna aga ma yi shili ǝnggǝr kau, yu sa uya akkǝri a dar kǝri. ");
INSERT INTO mfm_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“ ‘Dlǝwura mau gǝnna dubu pathlǝu kǝra ara ja kau, ba hya nǝ nyi anǝ ndǝra ǝnga dubu kumou. ");
INSERT INTO mfm_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Arya ndǝra ǝnga sau, nju cakǝr nyi aga ja uya gangǝu. Ndǝra gǝra ǝnga sǝ tsu, alaga sǝra aˈyi ara ja kushu kau, ba nja ɓǝra dlǝwuri ara ja. ");
INSERT INTO mfm_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ba nja dzǝgwa vakana mafa didiɗi kǝ a biya, a vu kuthlǝu vira ju nda tiwi ǝnga sǝlǝm ba ja ɗǝ hira ja gagaɗau.’ ");
INSERT INTO mfm_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ar pǝci kǝra Zǝr Ndau wu nda shida wu kadakadarkur nyi, ǝnga waladiˈyar patǝ ǝkkǝˈyi ja, ju nda sa nggya ar tsǝkafǝ nǝ kadakadarkur. ");
INSERT INTO mfm_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nju nda sa kaɓiya patǝr njir duniya wu mwa nyi, ba ja dzǝgwa tǝkǝbiya nji patǝ bwata mǝthlǝ ǝnggǝr kǝra ndǝr ɓǝla wu tǝkǝbiya pama tǝmahǝˈyar ǝnga kuˈyar. ");
INSERT INTO mfm_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ba ja nda piya tǝmahǝˈyar lagu tsi mazǝma ja ǝnga kuˈyar lagu tsi matsala ja. ");
INSERT INTO mfm_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ba tǝl a dzǝgwa na anǝ njira ar mazǝma ja, ‘Shila mau nahyi njira Dǝɗa fǝnggǝr hyi barka; hya dlǝwuri sǝr faˈa kir hyi, ca ngǝ tǝlkur Hyal kǝra nji pabǝr hyi tsu kaɗǝ mudlau. ");
INSERT INTO mfm_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Arya ɗǝɗǝmǝu wuɓau a vǝr tǝ ɗa, ba hyi nǝ ɗa sǝr sǝm. Hili a vǝr tǝ ɗa, ba hyi nǝ ɗa sǝr sa, ǝnga tsu mǝthlǝpi yau, ba hyi hǝr ɗa a vu kir hyi. ");
INSERT INTO mfm_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Turusu yau, ba hyi har ɗa kar, kǝ yi ɗa gǝra ngga, ba hyi shilǝgǝbiya ɗa. Nji fuwa ɗa wu fursǝna, ba hyi sa tular ɗa.’ ");
INSERT INTO mfm_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ba nji tsapǝ ka na anǝ nyi, ‘Thlagǝu, a nuwa nga ˈyi lar ngǝ ǝnga wuɓau, ba ˈyi nǝ ngǝ sǝr sǝma, ǝnga ˈyi lar ngǝ ǝnga hili, ba ˈyi nǝ ngǝ sǝra ga sa ka? ");
INSERT INTO mfm_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ba a nuwa nga ˈyi lar ngǝ mǝthlǝpi, ba ˈyi nggar ngau a vu kir ˈya, ǝndǝga turusu, ba ˈyi nǝ ngǝ sǝra ga har ara? ");
INSERT INTO mfm_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ənga ǝtsu a nuwa nga ˈyi lar ngǝ gǝra ngga ǝnga wu fursǝna, ba ˈyi sa tular nga?’ ");
INSERT INTO mfm_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ba tǝl ka dzǝgwa shaɗǝwa nda, ja na, ‘Jiri nga yu na anǝ hyi, kalar sǝra hyi mǝliya nyi anǝ kusha zamǝɗaˈyar kau, anǝ ɗa nga hyi mǝliya.’ ");
INSERT INTO mfm_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ba tǝl ka dzǝgwa na anǝ njira ar matsala ja, ‘Kwaya mau a dzǝr ɗa, nahyi nji shishiˈwau, maˈya mau a ndu uˈur kǝtsa kǝra nji pabǝri nyi anǝ Shatan ǝnga waladi nyiˈyar. ");
INSERT INTO mfm_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Arya wuɓau a vǝr tǝ ɗa, nahyi nǝ ɗa sǝr sǝm mai. Hili tsu a vǝr tǝ ɗa, nahyi nǝ ɗa sǝr sa mai. ");
INSERT INTO mfm_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kǝ yi ɗa mǝthlǝpi anǝ hyi, nahyi nggar ɗa a vu kir hyi mai. Turusu yau, nahyi nǝ ɗa kar ha mai. Ənga gǝra ngga yau, ǝnga wu fursǝna, nahyi sa tulari ɗa mai.’ ");
INSERT INTO mfm_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Nanda tsu, ndǝ shaɗǝwa nyi, ‘Thlagǝu, a nuwa nga ˈyi lar ngǝ ǝnga wuɓau ǝnga hili a vǝr tǝ ngau, ǝnga mǝthlǝpi gau, ǝnga wu fursǝna, ǝnga gǝra ngga ba turusu, ama naˈyi dlǝwari ngǝ maya?’ ");
INSERT INTO mfm_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ba ja dzǝgwa shaɗǝwa nda, ‘Yi wu nar hyi jirkura nyi, kalar sǝra hyi gǝra mǝliya nyi anǝ kusha zamǝɗaˈyar kau, anǝ ɗa nga hyi nggǝl ara mǝl.’ ");
INSERT INTO mfm_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ba nda maˈyi a gwu ɓwaɓwatǝ gǝra kuɗau, ama nji tsapǝu nǝr nda a gwu pi gǝra kuɗau.” ");
INSERT INTO mfm_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ənggǝra Yesu kuɗǝna na patǝ sǝˈyar kau, kǝ ji na anǝ zǝmbǝlma nyiˈyar, ");
INSERT INTO mfm_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Hyu sǝni abǝr, lardur nǝ vǝlna a hyiri pida mǝthlǝ ǝnga tsu nju nda sa lǝri Zǝr Ndau aga nja dlakǝya nyi.” ");
INSERT INTO mfm_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kǝ pubu dǝdǝgalˈyar ǝnga njira nggurǝm nǝ mǝlmǝ kaɓiya dzǝ patǝ ar pathla nǝ pubu kǝra ndiya ǝnga dǝgalǝu, ndǝra nju ngga ǝnga Kayafasu. ");
INSERT INTO mfm_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ndǝ mba miya lagu kǝra nda sǝn uya nda mbar Yesu ari ɗǝɗǝwa aga nda tsǝya nyi. ");
INSERT INTO mfm_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ama kǝ ndǝ na, “Aˈyi pǝcir mini kǝ mai, ara ja sara hyaˈana hangǝkala nji.” ");
INSERT INTO mfm_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ma tsu Yesu wu Bethlani, wu ki Simanu ndǝra ɗǝɗǝmǝu ndǝr pibi, ");
INSERT INTO mfm_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kǝ vanyi mala shili ǝnga pǝla mal kisǝu kǝra nju ɗǝl ǝnga gǝnna gangǝ gagaɗau. Mala kǝ shili ji sa pǝnggǝr nyi mala nyi a gyar kǝra ja ar pǝci kǝra nda vǝr sǝm sǝr sǝm. ");
INSERT INTO mfm_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ta zǝmbǝlma nyiˈyar lari abangau, kǝ huɗa nda ndzau, ndu na anǝ kǝrnda, “Wathlǝmǝ culi najaka wira sa? ");
INSERT INTO mfm_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mal kau, nju sǝn ɗǝlna ǝnga gǝnna gangǝu, ba nja dlǝwari nji tǝtǝ dǝnama ǝnga gǝnna nyi.” ");
INSERT INTO mfm_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Arya Yesu wu sǝnbiya sǝra ndu na, kǝ ji na anǝ nda, “Aga mi nga hyu ɓwanǝ nyi kǝr anǝ mala ka? A mǝliya ɗar ja sǝra mǝnahǝu. ");
INSERT INTO mfm_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nji tǝtǝ dǝnama aˈyi nda ǝkkǝˈyi hyi parangǝu, ama nayau aˈyi yi ǝkkǝˈyi hyi parangǝ mai. ");
INSERT INTO mfm_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mal kisǝ kǝ ji pǝnggǝr ɗa kau, nǝ pabǝ dzǝ nǝ haɗǝ ɗa ngau. ");
INSERT INTO mfm_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yu nar hyi jirkura nyi, kalar vira nju nda tǝtǝlna ndǝshigu kǝ ari wu duniya patǝu, nju nda ndǝr ar kǝra sǝ kǝ ji mǝliya kau, aga ɗǝngari ǝnga ja.” ");
INSERT INTO mfm_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kǝ pathlǝu wu pama zǝmbǝlma nyi kumo apǝ mǝthlǝu, kǝra nju ngga ǝnga Yahuda Isikarayoti maˈyi a ndǝgya pubu dǝdǝgalˈyar, ");
INSERT INTO mfm_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ji nda yiwa nda, “Yiɗawu nga hyu kina ɗa ma yi sǝn lǝr hyi nya?” Kǝ ndǝ jigabiya gǝnna sulayi makǝrkumunyi ");
INSERT INTO mfm_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mbari ar pǝci kau, ngǝ Yahuda wu gal lagu kǝra ja sǝn lǝri Yesu ari. ");
INSERT INTO mfm_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ar pǝci nǝ tanggǝrma nǝ lardur nǝ macikǝl gǝra thlǝlamǝ, kǝ zǝmbǝlma nyiˈyar shili ndǝ sa yiwa nyi, “Əmani nga gu yiwu ˈya pabǝri ngǝ vir sǝm lardur nǝ vǝlna ka?” ");
INSERT INTO mfm_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kǝ ji shaɗǝwa, ji na, “Maˈya mau a vu huɗa mǝlmau, hyu vuwa thlǝwa vanyi ndǝ a vuna, ba hya nar nyi, ‘Malǝmǝ ngǝ na, abǝr, pǝci nyi a ɗar lǝhǝu. Ju sa sǝm lardur nǝ vǝlna ǝkkǝˈyi zǝmbǝlma nyiˈyar wu ki ngau.’ ” ");
INSERT INTO mfm_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kǝ zǝmbǝlma nyiˈyar mǝliya ǝnggǝra ji nar nda ta, ba ndǝ pabǝri vir sǝm lardur nǝ vǝlna nyi. ");
INSERT INTO mfm_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ənggǝra wagǝ ɗa, Yesu nggya aga ja sǝm sǝr sǝm ǝkkǝˈyi zǝmbǝlma nyiˈyar kumo apǝ mǝthlǝu. ");
INSERT INTO mfm_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ma tsu nda vǝr sǝm sǝr sǝm, kǝ Yesu na anǝ nda, “Jiri nga yu na anǝ hyi, pathlǝu wu pama hyu nda thlǝna hiya yau.” ");
INSERT INTO mfm_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kǝ ɗǝfuwa nda ndzǝ gagaɗau, kalar ndu dzǝgwa na anǝ nyi wu pama nda, “Ənga jiri, nayi ngǝ ya, Thlagǝu?” ");
INSERT INTO mfm_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kǝ Yesu shaɗǝwa, “Ndǝ ka a vǝr fǝ tsi wu cala ǝnga yi kau, ngu nda thlǝna hiya yau. ");
INSERT INTO mfm_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Zǝr Ndau, wu tǝ ǝnggǝra nji tsǝfǝri ar kǝra ja, ama sǝr tǝhuɗǝ anǝ ndǝra wu nda thlǝna hiya Zǝr Ndau. Wu ndiya anǝ ndǝ kau, kuji nji gǝra ya nyi.” ");
INSERT INTO mfm_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kǝ Yahuda ndǝra wu nda thlǝna hiya ja na, “Malǝmǝ, ǝnga jiri nayi ngǝ ya?” Yesu shaɗǝwa, ji na, “Angǝ, nagǝ ǝnga kǝrngǝ ma, a nabiyar gau.” ");
INSERT INTO mfm_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tsu nda vǝr sǝm sǝr sǝm, kǝ Yesu hǝri macikǝl, kǝ ji lǝr usaku anǝ Hyal, ba ji ɓǝɓǝlǝwa, kǝ ji nǝ nyi anǝ zǝmbǝlma nyiˈyar, ju na, “Dlǝwura mau hya sǝm, naja kǝ kumǝr dza yi ngau.” ");
INSERT INTO mfm_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kǝ ji hǝri kyakiwa nǝ ˈyimir wur inabi, kǝ ji lǝr usaku anǝ Hyal, kǝ ji nǝr nda, ju na, “Patǝkura hyi, hya sa. ");
INSERT INTO mfm_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Najakǝ mashi ɗa ngau nǝ nyabiya alkawal mafǝliyangǝ, kǝra nju nda pǝna aga tǝfǝbiya bikǝ nǝ nji patǝu. ");
INSERT INTO mfm_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yu nar hyi, tsu yu ɓǝra sa ˈyimir yayar wur inabi mai, kǝl pǝci kǝra yu nda sa mafǝliyangǝ ǝnga hyi wu tǝlkur nǝ Dǝɗa.” ");
INSERT INTO mfm_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ayukuɗa ndǝ kuɗǝna thlǝ na, kǝ ndǝ maˈyi a dar Mǝ nǝ wur Zaitunu. ");
INSERT INTO mfm_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kǝ Yesu na anǝ nda, “Vuˈyi ǝshina kau, patǝ hyi, hyu nda tǝtǝlnakǝr arya sǝra wu nda ɗa ǝnga yau. Ara tsǝtsǝfǝ nga nyi wu lǝkakaɗǝ nǝ Hyal, abǝr, “ ‘Yi wu nda tsar kǝra ndǝr ɓǝla, ba ɓǝla nǝ tǝmahǝu a tǝtǝlnakǝr.’ ");
INSERT INTO mfm_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ama ayukuɗa yi hyaˈari sara vir tau, yu tǝrabiya wu mwar hyi a vu Galili.” ");
INSERT INTO mfm_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Əngwar Biturusu anǝ nyi, “Alaga nji patǝ hwinakǝr ndǝ piyari ngau, nayi wu, piyari ngǝ nǝ ɗa mai.” ");
INSERT INTO mfm_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kǝ Yesu shaɗǝwa nyi, ji na, “Yu nar ngǝ jirkura nyi Biturusu, ǝshina vuˈyi kau, kadivira vǝgǝmǝ wu nda wau, gu kǝpalna sǝn ɗa ar kǝr ar kǝr makǝru.” ");
INSERT INTO mfm_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Kǝ Biturusu ɓǝra na, “Alaga nji tsǝya ɗa daɓǝ ǝnga gau, nayi wu kǝpal sǝni ngǝ mai.” Kǝ patǝkura alenyi zǝmbǝlma nyiˈyar nana abangǝ tsu. ");
INSERT INTO mfm_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kǝ Yesu ǝkkǝˈyi zǝmbǝlma nyiˈyar maˈyi a ndar vanyi vi kǝra nju ngga ǝnga Gyatsimani, kǝ ji nda na anǝ nda, “Nggya mǝ nǝr hyi ǝnggau, yu maˈyi a ndu mwa ya nda kǝdi Hyal.” ");
INSERT INTO mfm_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kǝ ji hǝri Biturusu ǝnga wazha Zabadi mǝthlǝ ǝnga ja, nanda ngǝ Yakubu ǝnga Yahwana, naja ǝnga huɗǝ kiyakiyar gagaɗau ǝnga ɓwaɓwatǝ ara sǝra ja a gwa. ");
INSERT INTO mfm_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kǝ ji na anǝ nda, “Huɗǝ ndzǝndzǝ kǝra ya gwa a sǝn tsǝya ɗa. Nahyi hya nggya liliˈu hya ɓǝla ǝnga yau.” ");
INSERT INTO mfm_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ji ɓar dzǝ kushu, ba ji dla lagu bama a gyiwu ˈyi, ja vǝr ndǝr ǝnga Hyal, ju na, “Tada, ma ja abǝr yiwu ca ngǝ uya, bǝgǝ ga hǝna najaka ɓwaɓwatǝ ar kǝra yau. Alaga abangau, aˈyi sǝra yu yiwu mai, ama sǝra gu yiwu.” ");
INSERT INTO mfm_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ba ji sha shili ara zǝmbǝlma nyiˈyar, ba ji sa thlǝwa nda wu ghanyi. “Mi nga ma? Aˈyi hyu sǝn nggya nǝ ɓǝla ǝnga yi alaga nǝ saka pathlǝ wa?” Ji yiwa Biturusu. ");
INSERT INTO mfm_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","“Hya nggya ǝnga ɓǝla ǝnga hya kǝdi Hyal ara hya sara tǝɗau a gu dzau. Mambǝl wu yiwu nǝ nyi, ama kumǝr dzǝ a tǝwari.” ");
INSERT INTO mfm_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kǝ ji ɓǝra maˈyi nǝ mǝthlǝkura nyi, ji nda ndǝr ǝnga Hyal, ji na, “Tada, Ma aˈyi ɗa tsaˈa aga ɓwaɓwatǝ ka hǝna kǝr mai, ama kǝl yi tǝwari, taˈyi sǝra gu yiwu patǝ ja ɗarkǝr.” ");
INSERT INTO mfm_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ənggǝra ji sha shili, kǝ ji ɓǝra thlǝwa nda wu ghanyi, ara ghanyi tǝdǝɓǝu ar liya nda. ");
INSERT INTO mfm_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kǝ ji piyari nda, ba ji maˈyi sǝ nyi nǝ makǝrkura nyi, kǝ ji nda ndǝr ǝnga Hyal, ji ɓǝra nana sǝˈyar ta. ");
INSERT INTO mfm_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ji ɓǝra sha shili ǝgya zǝmbǝlma nyiˈyar, ba ji thlǝwa nda wu ghanyi, kǝ ji na anǝ nda, “Tsu hyu ghanyi ya, hyu ɓǝlsar ya? Tsaˈa abangǝ ja! Pǝci a ɗari nju nǝ nyi Zǝr Ndau a gwu tsa njir bikau. ");
INSERT INTO mfm_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Hyaˈara mau, mǝna maˈyi! Kǝja ndǝr thlǝ hiya yi ta a shiliri!” ");
INSERT INTO mfm_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tsu Yesu a vǝr ndǝr, kǝja Yahuda, pathlǝu wu pama zǝmbǝlma nyiˈyar kumo apǝ mǝthlǝu, shili ǝnga nji gangǝu ǝnga katsakǝr ba zǝwa wu tsa nda. Njira pubu dǝdǝgalˈyar ǝnga njira nggurum nǝ mǝlmǝ sǝwa. ");
INSERT INTO mfm_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ndǝr thlǝ hiya ja kau, a dǝgar ndar ja mǝtsamǝ, “Ma ndǝra yi bǝrpiya nyi, naja ngau, mbari nya mau.” ");
INSERT INTO mfm_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ənggǝra ji dla, ba ji maˈyi tǝwar a ndǝra Yesu, kǝ Yahuda usar nyi, ji na, “Usi Malǝmǝ,” kǝ ji bǝrpiya nyi. ");
INSERT INTO mfm_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Əngwar Yesu anǝ nyi, “Bazhi ɗa, mǝliya sǝra hǝ nga shili.” Kǝ nja nyi shili ndǝ sa mbari Yesu, kǝ ndǝ sǝɓiya nyi ɓaɓalu. ");
INSERT INTO mfm_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ənggǝra ndǝ lari abangau, kǝ pathlǝ wu pama njir ɓǝ Yesu tǝsǝbiya katsakǝr nyi, ba ji thlana himiya mafa pubu kǝra ndiya ǝnga dǝgal ǝni. ");
INSERT INTO mfm_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Əngwar Yesu anǝ nyi, “Shabiya katsakǝr ngau a vu ki nyi, arya kalar ndǝra tsǝbiya katsakǝr, katsakǝr ngu nda tsa nyi. ");
INSERT INTO mfm_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Hyu nggani abǝr aˈyi yu sǝn ngga Dǝɗa, ba ja sǝwa ɗa alaga bwata waladiˈyar kumo apǝ mǝthlǝ wa? ");
INSERT INTO mfm_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ama lagu mani ngǝ sǝra tsǝtsǝfau wu lǝkakaɗǝ nǝ Hyal wu nyabiya dza, abǝr aˈyi ji ɗa lagu kǝ maya?” ");
INSERT INTO mfm_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ar pǝci ta, Yesu na anǝ dlamir nji, “Nayi ngǝ ndǝr tǝɗǝmwa anǝ njir gwaɗǝvi ya, ǝnga hyi sǝbiya katsakǝr ǝnga zǝwa aga hya sa mba ɗa ya? Parangǝu ya vǝr nggya ǝkkǝˈyi hyi wu ki Hyal ya vǝr highiɓau, ama nahyi sayi mbar ɗa mai. ");
INSERT INTO mfm_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sǝˈyar kǝ ɗa patǝ aga sǝra nabiˈyar tsǝfǝri a nyabiya dzau.” Kǝ patǝ zǝmbǝlma nyiˈyar tǝtǝlna dzau ba ndǝ piyari nyi wu tsa nda. ");
INSERT INTO mfm_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Njira mbari Yesu hǝri nyi a ndǝra Kayafasu dǝgala Pubu, vira malǝmǝ dlaɗǝˈyar ǝnga njira nggurǝm kaɓǝ ari. ");
INSERT INTO mfm_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Kǝ Biturusu nu nyi wu ndǝl wu ndǝl tsatsalǝu, tsaˈa vwar huɗa ki dǝgala Pubu. Ji vuwa nggya ǝkkǝˈyi njir sǝkǝ ki aga ja lari ǝnggǝra nju ɗa ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pubu dǝdǝgalˈyar ǝnga patǝr njir zǝwa a vǝr gal lagu kǝra nda sǝn vazǝya Yesu aga nda tsǝya nyi. ");
INSERT INTO mfm_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ama sǝ aˈyi ndǝ uya mai, alaga kǝ nji gangǝu shili ndu thla sakida nǝ fati ar kǝra Yesu. Ayukuɗa nyi patǝu, kǝ alenyi nji mǝthlǝ biyar babal, ");
INSERT INTO mfm_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ndǝ na, “Sal kǝ na, abǝr, ‘Yu sǝn dlana ki Hyal kau, ba ya ɓǝra hǝriya nyi wu pida makǝru.’ ” ");
INSERT INTO mfm_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pubu kǝra ndiya ǝnga dǝgal hyaˈari aˈyi taˈyau, ji na anǝ Yesu, “Mi ngǝ sǝ kǝ nja vǝr na a miya ndǝla gǝ ka? Sǝ aˈyi gu na a gǝri wa?” ");
INSERT INTO mfm_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ama kǝ Yesu nggya sǝ nyi ɗiyu. Kǝ pubu kǝra ndiya ǝnga dǝgal na anǝ nyi, “Yi wu daɓǝr ngǝ ǝnga thlǝmǝr Hyal kǝra a dǝmǝlmau, nar ˈya ma nagǝ ngǝ Kǝrsiti, Zǝr Hyal.” ");
INSERT INTO mfm_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu shaɗǝwa, “Angǝ, abangǝ nga nyi ǝnggǝr kǝra gǝ na kau. Ama taˈyi ya nar hyi patǝ hyi, mbar kabangǝkau, hyu sa lari Zǝr Ndau a vǝr nggya ar tsi mazǝma ndǝ dǝgal dǝnama, a vǝr shida wu dlama sara dǝmǝlmau.” ");
INSERT INTO mfm_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kǝ pubu kǝra ndiya ǝnga dǝgal tana lǝgutǝ kǝrnyi ǝnga huɗǝ ndzǝndzau, ju na, “A nanar ja ndǝr nǝ deɓa Hyal! Sakida mi mǝnu ɓǝra gala? Kǝja hya nggari ndǝr diɗa vi nyi ǝnga kǝrhyi. ");
INSERT INTO mfm_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mi nga hyu nggana?” “A ɗar tsaˈa nja tsǝya nyi,” ndǝ shaɗǝwa. ");
INSERT INTO mfm_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kǝ ndǝ tǝfuwa nyi tuli a vu bama ja, ǝnga alenyi nji tsu dǝdǝguwa nyi tsi. Alenyi nji nǝ nyi tsi balma ");
INSERT INTO mfm_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ndu dzǝgwa na, “Ma nagǝ ngǝ nabi, nana ˈya, Kǝrsiti, tara wa ngǝ dǝgǝr ngǝ ka?” ");
INSERT INTO mfm_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ar pǝci kǝra Biturusu a vǝr nggya a biyar huɗǝ ki, kǝ kwar ki kǝ shili ǝgya ja, ji sa na anǝ nyi, “Nagǝ ma, nahyi ngǝ shili ǝkkǝˈyi Yesu ndǝr Galili.” ");
INSERT INTO mfm_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ji kǝpalna nyi wu mwar nda patǝu, ji na, “Nayi wu sǝni sǝra gu na kǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ta ji maˈyi a biya miya kiya nyi, ba ji biya ɓǝ ǝnga vanyi kwar ki, kǝ kwa kǝ lar nyi, kǝ ji na anǝ njira tataˈyi a ndǝna, “Ndǝ kǝ ma, nanda ngǝ ǝkkǝˈyi Yesu ndǝr Nazǝratu.” ");
INSERT INTO mfm_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ji ɓǝra kǝpalna nyi daɓǝ ǝnga sǝm fǝla, “Yi wu sǝn ndǝ kǝ mai!” ");
INSERT INTO mfm_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ɓǝliya sar kushu, njira tataˈyi a ndǝna ndǝ maˈyi a ndǝgya Biturusu, ndǝ nda nar nyi, “Ənga jiri, pathlǝ gu pama nda, arya kiyara gau a nanar ndǝla gau.” ");
INSERT INTO mfm_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kǝ ji mbari shiˈwa kǝrnyi, ǝnga ji ɓǝra sǝm fǝla anǝ nda, abǝr, “Yi wu sǝn ndǝ kǝ mai!” Ənggǝrna kǝ vǝgǝmǝ wau. ");
INSERT INTO mfm_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ənggau kǝ Biturusu ɗǝngari ndǝr kǝra Yesu nar nyi, abǝr, “Divira vǝgǝmǝ a wau, gu kǝpalna sǝn ɗa ar kǝr ar kǝr makǝru.” Kǝ ji hwi a biya, ji biya tiwi ǝnga sǝlǝm gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Əmudlǝ kaɗǝu, kǝ pubu dǝdǝgalˈyar ǝnga njira nggurǝm mǝlmǝ patǝ mbiya miya tsu aga nda tsǝya Yesu. ");
INSERT INTO mfm_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ndǝ dzǝɓiya nyi, ba ndǝ maˈyi ǝnga ja, ndǝ nda lǝr nyi a ndu tsa gwamna Bilatusu. ");
INSERT INTO mfm_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ta Yahuda, ndǝra thlǝna hiya Yesu, lari abǝr a thlana nyir nji numa nǝ tǝ anǝ Yesu, ba ji tiwi ǝnga kǝrnyi, ba ji shabiya nda gǝnnar nda, a nda nǝ pubu dǝdǝgalˈyar ǝnga njira nggurǝm. ");
INSERT INTO mfm_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ji na, “A mǝliyar yi bikau, arya yi thlǝna hiya ndǝra gǝra ndzana sau.” Ndǝ shaɗǝwa nyi, “Mi dzawur ˈya ǝnga ka? A nǝngǝ ngǝ dzaˈwu.” ");
INSERT INTO mfm_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kǝ Yahuda vakǝ nggǝr nda gǝnna nyi a gwu huɗa Ki Hyal, kǝ ji maˈyi, ji nda hakǝya kǝrnyi. ");
INSERT INTO mfm_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pubu dǝdǝgalˈyar ɗǝmǝri gǝnna nyi, ndǝ na, “Aˈyi ɗa tsaˈa nja ɓǝra shabiya gǝnna kǝ a gu mbǝl mai, arya gǝnna mashi ngau.” ");
INSERT INTO mfm_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kǝ ndǝ mbiya miya aga nda ɗǝlbiya babal, ar vira nju ngga ǝnga Babal nǝ ndǝr Hǝr Tǝm. Aga ja ɗa hulili anǝ nji shishili. ");
INSERT INTO mfm_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ca ngǝ sǝra ɗa nju ngga vi kǝ ǝnga ˈYiˈyi Mashi baˈanǝ ǝshina. ");
INSERT INTO mfm_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lagu kǝ ngǝ sǝra Nabi Irimiya nana nyabiya dzau, “Kǝ ndǝ faˈari kwaɓa thladla makǝrkumunyi, gǝnna kǝra njir Izirayila thlana. ");
INSERT INTO mfm_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Kǝ ndǝ ɗǝlbiya babal nǝ ndǝr hǝr tǝm ǝni, ǝnggǝra Thlagǝ nar ɗa.” ");
INSERT INTO mfm_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kǝja Yesu taˈyi wu mwar gwamna, kǝ gwamna yiwa nyi, “Nagǝ ngǝ tǝl njir Yahudiya ya?” Kǝ Yesu shaɗǝwa nyi, “Nagǝ ngǝ na abangau.” ");
INSERT INTO mfm_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ar pǝci kǝra pubu dǝdǝgalˈyar ǝnga njira nggurǝm a vǝr nana ndǝr ar kǝra ja, naji shaɗǝwa anǝ nda mai. ");
INSERT INTO mfm_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kǝ Bilatusu yiwa nyi, “Aˈyi gu nggari sakida kǝra nda vǝr na a miya ndǝla gǝ kǝ wa?” ");
INSERT INTO mfm_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ama kǝ Yesu bǝgǝ sǝ nyi ɗiyu, sǝ aˈyi ji na alaga kushu ar kǝra sǝ kǝ mai, ba sǝ kǝ nǝ nyi ɗǝnga anǝ gwamna. ");
INSERT INTO mfm_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ar pǝcir mini nǝ lardur nǝ vǝlna, gwamna a tsǝliyari parangǝu, ju sǝya ndǝr fursǝna pathlǝu anǝ dlamir nji, ndǝra ndu yiwu. ");
INSERT INTO mfm_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ar pǝci ta vanyi ndǝr fursǝna aˈyi kǝra nju sǝni nyi patǝ nju ngga nyi ǝnga Barabasu. ");
INSERT INTO mfm_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ta dlami kaɓau, kǝ Bilatusu yiwa nda, “Wa nga hyu yiwu ya sǝya hya? Barabasu ǝndǝga Yesu kǝra nju ngga ǝnga Kǝrsiti ya?” ");
INSERT INTO mfm_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Arya ju sǝni abǝr arya shishikura nda nga ndǝ mbari Yesu ndǝ lǝr nyi anǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ma tsu Bilatusu a vǝr nggya ar tsǝkafǝ nyi, kǝ mala nyi sǝwa nyi cama, “Hǝbiya tsa gau wu ndǝr ndǝ gǝra ǝnga vazǝ kau, arya yi lar ɓwaɓwatǝ pamǝpamǝ arya ja ǝshina wu shuni.” ");
INSERT INTO mfm_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ama kǝ pubu dǝdǝgalˈyar ǝnga njira nggurǝm tsǝtsǝkuri dlamir nji aga nda na nja sǝya nda Barabasu, ba nja tsǝya Yesu. ");
INSERT INTO mfm_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gwamna ɓǝra yiwa nda, “Wa nga hyu yiwu ya sǝya hyu pama nji mǝthlǝ ka?” Əngwar nda, “Barabasu!” ");
INSERT INTO mfm_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kǝ Bilatusu ɓǝra yiwa nda, “Mi nga ya dzǝgwa mǝl ǝnga Yesu kǝra nju ngga ǝnga Kǝrsiti ka?” Əngwar nda, “Dlakǝya nyi nji!” ");
INSERT INTO mfm_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kǝ Bilatusu na anǝ nda, “Arya mi ya? Mi ngǝ bikǝ nya?” Kǝ ndǝ ɓǝra hyaˈana ɗahǝ tsu, ndǝ na, “Dlakǝya nya mau.” ");
INSERT INTO mfm_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ta Bilatusu lari abǝr sǝ aˈyi ju sǝn kari mai, kǝl cakǝ ngǝ gwaɗǝ vi wu cakau, kǝ ji gǝr ˈyimi, ji cina tsa ja ǝni wu mwar nji, ji na, “Kǝja tsa yau, kǝja tsa yau, bikǝ ɗa aˈyi wu mashi ndǝ kǝ mai, bikǝr hyi ngau!” ");
INSERT INTO mfm_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kǝ patǝkura nda shaɗǝwa, ndǝ na, “Taˈyi mashi nyi a nggya ar kǝra ˈya ǝnga wazhar ˈya patǝu.” ");
INSERT INTO mfm_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kǝ ji sǝya nda Barabasu. Ayukuɗa ji sǝwa, nji nǝ nyi wuɗa anǝ Yesu, kǝ ji nǝ nda nyi aga nda dlakǝya nyi. ");
INSERT INTO mfm_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Sara ǝnggau, kǝ sojaˈyar nǝ gwamna hǝr Yesu a vwar vira soja nggunggurǝmˈyar a nggya ari, ba ndǝ kaɓiya bwata sojaˈyar patǝ ndǝ zǝwar nyi. ");
INSERT INTO mfm_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ndǝ zǝɗǝna nyi turusu ba ndǝ dzǝgwa hari nyi kar dǝzǝu culi nǝ tǝlkur. ");
INSERT INTO mfm_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kǝ ndǝ tsagu nyi dara shikǝɗi nǝ tǝlkur, kǝ ndǝ hǝwa nyi a du kǝra ja. Ndǝ fuwa zǝwa tǝlkur wu tsa ja, ba ndǝ dzǝgwa ɓǝliya undi nǝ diɗa nyi, ndu na, “Alvari tǝl, tǝl nǝ njir Yahudiya!” ");
INSERT INTO mfm_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ndǝ tǝfǝnggǝr nyi tuli, ba ndǝ dlǝwuri zǝwa nǝ tǝlkur ta, ndǝ dzǝgwa pǝpǝthlǝwa nyi zǝwa nyi wu kǝra ja. ");
INSERT INTO mfm_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ayukuɗa ndǝ kuɗǝna diɗa nyi abangau, kǝ ndǝ zǝɗǝna lǝgutǝ tǝlkur ta, ndǝ ɓǝra har nyi nǝ nyi. Ndǝ dzǝgwa maˈyi ǝnga ja a biya aga nda biya dlakǝya nyi. ");
INSERT INTO mfm_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ənggǝra nda vǝr biya, ba ndǝ thlǝwa vanyi ndǝr Sayirini kǝra nju ngga ǝnga Simanu, kǝ ndǝ ciwa nyi aga ja hǝ wu dladlakǝ nǝ Yesu. ");
INSERT INTO mfm_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kǝ ndǝ shili ar vanyi vi kǝra nju ngga ǝnga Gwalgwathla, ca ngǝ vir papangǝkǝr. ");
INSERT INTO mfm_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","A ndǝna kǝ ndǝ nǝ nyi ˈyimir wur inabi kǝra nji gwaɗǝbiya ǝnga maɗǝwatǝu aga ja sa, ama ta ji ɗahari, kǝ ji piyari sa. ");
INSERT INTO mfm_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ta ndǝ dlakǝya nyi, ba ndǝ dzǝgwa tǝtǝkǝwa kar ha nyi lagur tǝɗǝ shiˈwu. ");
INSERT INTO mfm_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ayukuɗa kau, ba ndǝ nggya nggashiu ndu ɓǝla nyi a ndǝna. ");
INSERT INTO mfm_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Adabanga kǝra ja ndǝ tsǝfǝya sǝra wu cabiya sǝra ji ndzana: NDƏ KƏ NGƏ YESU, TƏLƏR NJIR YAHUDIYA. ");
INSERT INTO mfm_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nji dlakǝya nyi ǝnga njir ɗa lagu mǝthlǝu, pathlǝu ar tsi mazǝma ja ǝnga pathlǝu tsu ar matsala ja. ");
INSERT INTO mfm_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Njira a vǝr tǝrabiya ndu ndǝr nǝ diɗa nyi, ndu kǝnggǝɗǝ kǝra nda ndu nggushi, ǝnga ");
INSERT INTO mfm_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ndu na, “Nagǝ ndǝra na gu sǝn dlana ki Hyal, ba ga ɓǝra hǝriya wu pǝci makǝru, ga mbǝɗana kǝrngau! Ga shida sara dar wu kau, ma nagǝ Zǝr Hyal ngau!” ");
INSERT INTO mfm_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Abangǝ tsu ngǝ pubu dǝdǝgalˈyar ǝnga malǝmǝ dlaɗǝˈyar ǝnga njira nggurǝm wu ndǝr nǝ diɗa nyi. ");
INSERT INTO mfm_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Əngwar nda, “Ji mbǝɗana nji, ama naji wu sǝn mbǝɗana kǝrnyi mai! Naja ngǝ Tǝl nǝ njir Izirayila! Bǝgǝ ja gya sara dar wu kǝ aga mǝna lari, ba mǝna hǝnggǝri ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ji hǝnggǝri ǝnga Hyal, bǝgǝ Hyala nyi a kǝtiya nyi kabangǝkau, ma Hyala nyi wu yiwu, arya ju na, ‘Nayi Zǝr Hyal ngau.’ ” ");
INSERT INTO mfm_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tangǝ ǝnggǝr ta, njir ɗa lagu kǝra nji dlakǝya ǝnga ja ta nyabiya nyi ǝnga nggǝl. ");
INSERT INTO mfm_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mbari ar pǝci taˈyikǝr baˈanǝ saka makǝr nǝ wagǝ ngǝ kuthlǝu shida haɗiya ˈyiˈya nyi patǝu. ");
INSERT INTO mfm_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","A ndu wagǝu ǝnggǝr saka makǝru, Yesu hyaˈana ɗahǝu ǝnga dǝnama, ji na, “ˈYiloyi, ˈYiloyi, lama sabakǝtani?” Kǝra cabiya, “Hyal ɗa, Hyal ɗa, mi ngǝ ɗa gǝ shabiya ɗa ya?” ");
INSERT INTO mfm_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ta njira tataˈyi a ndǝna nggari abangau, kǝ ndǝ na, “Ja vǝr ngga Iliya.” ");
INSERT INTO mfm_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ənggǝrna pathlǝu wu pama nda hwi ka nda hǝri sasaˈwa. Ji ciwa a gu ˈyimir wur inabi kǝra mwamwalu, ji ciri a dar zǝwa ba ji nǝ nyi aga ja sa. ");
INSERT INTO mfm_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Alenyi nji wu pama nda wu na, “Piyari nya mau, bǝgǝ mǝna lari tara Iliya wu sa mbǝɗana nyi.” ");
INSERT INTO mfm_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kǝ Yesu ɓǝra hyaˈana ɗahǝ ǝnga dǝnama, kǝ piya ja biya. ");
INSERT INTO mfm_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ar pǝci kǝ ngǝ kadǝmbul nǝ huɗa ki Hyal tǝwa dzǝ bwata mǝthlǝu, mbari a du kǝr ba a gyiwu ndǝla nyi. Kǝ ˈyiˈyi kǝnggǝɗǝr dzǝ ba mǝ ndǝliya dzau. ");
INSERT INTO mfm_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Huˈyar papahǝnakǝr, kǝ nji cicau kǝra tau, hyaˈari ǝnga pi. ");
INSERT INTO mfm_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ayukuɗa Yesu hyaˈari sara vir tau, kǝ ndǝ maˈyi a vu huɗa mǝlmǝ cicau, ba ndǝ vuwa canǝ nyi kǝr anǝ nji pamǝpamǝ gangǝu. ");
INSERT INTO mfm_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ənggǝra soja kǝra ndiya ǝnga dǝgal ǝnga alenyi njir ɓǝla hu Yesu lari ǝnggǝra ˈyiˈyi kǝnggǝɗǝr dzǝ ǝnga patǝkura sǝra ɗarkǝr, ba hivǝr mbari nda gagaɗau, ndu na ǝnga ɗahǝu, “Pakatǝu, ndǝ kau, Zǝr Hyal ngau!” ");
INSERT INTO mfm_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mathlǝkǝˈyi gangǝu sara wu Galili nu Yesu, ndu mǝl thlǝr anǝ nyi. Ndǝ taˈyi tsalǝu ndu tsamǝ sǝra wu ɗa. ");
INSERT INTO mfm_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wu pama nda Maryamu Magǝdaliya aˈyi ǝnga Maryamu mǝya Yakubu ǝnga Yusufu ba mǝya wazha Zabadi. ");
INSERT INTO mfm_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ma lǝhǝ waga ɗa, kǝja vanyi ndǝr gǝnna a shiliri, thlǝmǝ nyi Yusufu ndǝr Arimatiya, ndǝra naja ǝnga kǝrnyi ma ndǝr nu Yesu ngau. ");
INSERT INTO mfm_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ji maˈyi a ndǝra Bilatusu aga ja nda yiwari dza Yesu aga ja nda haɗǝna. Kǝ Bilatusu sǝwa aga nja nǝ nyi nyi. ");
INSERT INTO mfm_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kǝ Yusufu hǝri dza Yesu, ba ji pǝɗǝwa wu sǝr haɗǝ ndǝ cici camǝu. ");
INSERT INTO mfm_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Kǝ ji nda fuwa nyi wu hu nyi kǝra mafǝliyangǝ kǝra ji gǝmbiya wu mau. Kǝ ji uya madiya tsǝka ba ji haɗiya miya huwa nyi ǝni ba ji maˈyi sǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Kǝ Maryamu Magǝdaliya ǝnga vanyi Maryamu ta nggya bama ǝnga bama ǝnga huwa nyi. ");
INSERT INTO mfm_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Əzǝgǝkura nyi, pida pathlǝu ayukuɗa Pǝcir Pabǝ Dzau, kǝ pubu dǝdǝgalˈyar ǝnga njir Farisi maˈyi a ndǝra Bilatusu. ");
INSERT INTO mfm_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ndǝ na, “Malǝmǝ, ˈyu ɗǝngari sǝra ndǝr ngguta vi kǝ sara a vǝr na tsu ja ǝnga pi, abǝr, ‘Ayukuɗa pida makǝr, yu ɓǝra hyaˈari ǝnga pi.’ ");
INSERT INTO mfm_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Agabangau, ga sǝwa njir ɓǝla hu aga nda ɓǝla hu kǝ mǝnahǝu, kǝl ayukuɗa pida makǝru. Ma aˈyi abangǝ mai, zǝmbǝlma nyiˈyar wu sǝn sa hǝlǝr dza ja ǝvuˈyi ba nda dzǝgwa nar nyi anǝ nji abǝr a hyaˈari ja sara vir tau. Najaka ngguta vi wu nda ndiya nǝ tanggǝrma ǝnga didiɗi.” ");
INSERT INTO mfm_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Əngwar Bilatusu anǝ nda, “Suwa mǝ njir ɓǝla, aga nda nda ɓǝlar miya huwa nyi mǝnahǝu ǝnggǝr kǝra hyu sǝn mbari.” ");
INSERT INTO mfm_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kǝ ndǝ maˈyi ndǝ nda ɓǝlari huwa nyi mǝnahǝu, ndǝ fǝri mǝtsamǝ nǝ tǝlkur ar tsǝka nyi ǝnga tsu ndǝ fiya sojaˈyar aga ɓǝla viya nyi. ");
INSERT INTO mfm_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ayukuɗa Pǝcir Ɓǝlsar nǝ (njir Yahudiya) tǝrabiya, ǝmudlǝ kaɗǝu pǝci nǝ tanggǝrma nǝ sugu, kǝ Maryamu Magǝdaliya nanda ǝnga vanyi Maryamu maˈyi a nda tsamǝ huwa nyi. ");
INSERT INTO mfm_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sǝni aˈyi mai kǝ mǝlmǝ kǝnggǝɗau, ara vanyi waladi nǝ Thlagǝ shida sara dǝmǝlmau, ji sa maˈyi a dar huwa nyi, ji nda jahǝna tsǝka kǝra nji haɗiya miya huwa nyi ǝni, ba ji nggya ari. ");
INSERT INTO mfm_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Dza ja wu mbǝl wilwilu ǝnga lǝgutǝ ha nyi pǝrtǝ pwahǝu ǝnggǝr ǝpur paˈwa. ");
INSERT INTO mfm_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ənggǝra njir ɓǝla huwa nyi lari nyi, ba hivǝr mbari nda gagaɗau, ǝnga dza nda wu tsǝdzau, kǝra mǝliya ndǝ ɗa ǝnggǝr nji tǝtau. ");
INSERT INTO mfm_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ama kǝ waladiya nyi na anǝ mathlǝkǝˈya nyi, “Hya sara hivǝr mai, arya yu sǝni abǝr Yesu nga hya vǝr gal, ndǝra nji dlakǝya ta. ");
INSERT INTO mfm_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Aˈyi ja ǝnggǝ mai, a hyaˈari ja ǝnggǝr kǝra ji saya nana. Anda mau hya sa lari vira nji saya pina nyi ari ta. ");
INSERT INTO mfm_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Maˈya mau ǝnga kusa aga hya nda nar nyi anǝ zǝmbǝlma nyiˈyar, ‘A hyaˈari ja sara vir tau, ju maˈyi wu mwar hyi a vu Galili. A vuna hyu vuwa lari nyi.’ Sǝra yi shili aga ya sa nar hyi ngau.” ");
INSERT INTO mfm_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kǝ mathlǝkǝˈya nyi hyaˈari ǝnga kusa, nyinyau ǝnga hivǝr ba huɗǝ pǝrtǝ gagaɗau, ndǝ hwi a ndǝra zǝmbǝlma nyiˈyar aga nda nda nar nda sǝra ɗarkǝr. ");
INSERT INTO mfm_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kukuthlǝ kǝ Yesu thlǝwa nda, ba ji nar nda, “Usa mau.” Ndǝ shili ǝgya ja, ndǝ mbari hiya ja ba ndǝ gǝnggǝr nyi sǝli. ");
INSERT INTO mfm_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kǝ Yesu nar nda, “Hya sara hivǝr mai, maˈya mau hya vuwa nar nyi anǝ zamǝɗaˈyar nda maˈyi a vu Galili, a vuna nga ndu vuwa lar ɗa.” ");
INSERT INTO mfm_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ma tsu mathlǝkǝˈyi ta ar lagu, kǝ alenyi njir ɓǝla hu maˈyi a ndu huɗa mǝlmǝ ndǝ nda nar nyi anǝ pubu dǝdǝgalˈyar sǝra ɗarkǝr patǝu. ");
INSERT INTO mfm_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ənggǝra pubu dǝdǝgalˈyar ɓǝ ǝkkǝˈyi njira nggurǝm ba ndǝ nggya ndǝ mbiya sǝra ndu mǝl, ba ndǝ nǝ nyi madiya gǝnna anǝ njir ɓǝla huwa nyi, ");
INSERT INTO mfm_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ndu na anǝ nda, “Hya nar nyi anǝ nji, abǝr, ‘Zǝmbǝlma nyiˈyar ngǝ shili ǝvuˈyi ba ndǝ sa hǝlǝr dza ja ma tsu ˈya wu ghanyi.’ ");
INSERT INTO mfm_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma ndǝr kǝ gwu himiya gwamna, ˈyu nar nyi ndǝr kǝra wu pina huɗa ja, ba ˈya hǝbiya hyi wu ɓwaɓwatǝu.” ");
INSERT INTO mfm_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kǝ sojaˈyar ta dlǝwuri gǝnna nyi, ba ndǝ mǝliya ǝnggǝra nji dǝgar nda. Kǝ najaka ndǝr tǝtǝlna dzǝ wu pama njir Yahudiya patǝ baˈanǝ ǝshina. ");
INSERT INTO mfm_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Zǝmbǝlma nyiˈyar kumo a sǝr tangǝ maˈyi a dar mǝ nǝ Galili vira Yesu nar nda, aga nda maˈyi a dari. ");
INSERT INTO mfm_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ta ndǝ lari nyi, kǝ ndǝ dlǝvǝ nyi, ama alenyi nji wu pama nda wu tǝkǝkǝr ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kǝ Yesu shili ǝgya nda, ji sa na, “Dǝnama a dǝmǝlmau ǝnga kǝra a gyiwu ˈyi a nǝ ɗar nji. ");
INSERT INTO mfm_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Agabangau, maˈya mau, hya nda mǝliya njir duniya patǝ aga nda ɗa zǝmbǝlma ɗa, hya hǝr nda baɓǝtizǝma wu thlǝmǝr Tada ǝnga Zǝr ba ǝnga Mambǝl Cicau. ");
INSERT INTO mfm_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Hya highiɓǝr nda ǝnggǝra ndu ɓǝla sǝr ɓǝla kǝra yi nar hyi. Pakatǝ aˈyi yi ǝnga hyi cumu baˈanǝ kuɗiyar duniya.”");
INSERT INTO mfm_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nji gangǝ ɗa aga nda tsǝfǝri, sǝra ndǝ nggari ɗarkǝr wu pama ˈya. ");
INSERT INTO mfm_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ndǝ tsǝfǝri sǝra ˈyi nggari sara ara njira sǝ kǝ ɗa wu liya nda tsu kaɗǝu, ǝnga ndǝ tǝtǝlna ndǝr Hyal tsu. ");
INSERT INTO mfm_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tiyafulusu ndǝ dǝgal, ǝnggǝra yi tsambiya sǝˈyar kǝ patǝu ǝnga hangǝkal, ca ngǝ ɗa yi lari a ɗar tsaˈa, ya tsǝfǝri ngǝ ǝnggǝra sǝˈyar kǝ ɓau, ");
INSERT INTO mfm_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","aga ga sǝnbiya jirkura sǝˈyar kǝ ǝnggǝra nji highiɓǝri ngau. ");
INSERT INTO mfm_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Wu pǝci kǝra Hirudusu a vǝr sǝm tǝlkur nǝr ˈyiˈyir Yahudi, vanyi pubu aˈyi kǝra nja ngga ǝnga Zakariya. Naja pubu nǝ miya umbwa nǝ Abijanu. Thlǝmǝr mala nyi ca ngǝ Alisabatu, ǝnga ji biya sara wu culi gǝ Haruna. ");
INSERT INTO mfm_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nanda gyapǝu, ndǝ nggya mǝnahǝu wu mwar Hyal, ndǝ ɓǝlari patǝkura sǝra Hyal na nja mǝl. ");
INSERT INTO mfm_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ama nandǝ uya ya mai, ara Alisabatu ciri nga ja, ǝnga ǝtsu nji hahal nga nda gyapǝu. ");
INSERT INTO mfm_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Vanyi pǝci, Zakariya vǝr mǝl thlǝr nyi nǝ pubu a gwu ki Hyal, ǝnggǝra pǝcir nǝ miya umbwar nda shili. ");
INSERT INTO mfm_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Wu pǝci kau, ǝnggǝra sǝr ciji nǝ pubu cabiya, Zakariya nga nji caɗǝbiya, aga ja gu ki Hyal aga gwa nggyi sǝ kisǝu. ");
INSERT INTO mfm_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kabangǝkǝ nji dadaɓau kǝra a biya, nda vǝr ndǝr anǝ Hyal wu pǝci kǝ ja vǝr nggyi sǝ kisǝ kau. ");
INSERT INTO mfm_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kukuthlǝu kǝ waladi Thlagǝ canǝ nyi kǝr, ji taˈyi lagu mazǝma vir nggyi sǝ kisǝ kau. ");
INSERT INTO mfm_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ənggǝra Zakariya lari waladi kau, kǝ hivǝr mbari nyi gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ama kǝ waladi kǝ na anǝ nyi, “Zakariya, a sara ga hivǝr mai! Hyal, a nggari kǝdi ngau, kabangǝkau, mala ngǝ Alisabatu wu nda yabiya ngǝ zǝr sal. Gu nda nǝ nyi thlǝmǝ Yahwana. ");
INSERT INTO mfm_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ma nji yabiya nyi, gu nda ɗa ǝnga ɗǝfu cicau ǝnga huɗǝ pipida gagaɗau, abangau ngǝ alenyi nji gangǝ tsu. ");
INSERT INTO mfm_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Zǝr kǝ ju nda ɗa ndǝ dǝgal wu mwar Hyal. Naji wu nda sa ˈyimir wur inabi mai. Nju nda nyana nyi ǝnga Mambǝl Cicau tsu ja wu ta mǝnyi. ");
INSERT INTO mfm_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Naja ngu nda shabiya njir Izirayila gangǝu a shili ara Hyal Thlagǝri nda. ");
INSERT INTO mfm_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ju tǝrabiya a dumwar Thlagǝu, ju mǝl thlǝr nyi wu mambǝl ǝnga dǝnama ǝnggǝr nabi Iliya. Ju shili ǝnga nggya jamǝ wu pama tadaˈyar ǝnga wazhar nda. Ju nda shabiya njira kǝra ɓǝlari sǝra tsaˈa, aga nda ɗa nji hangǝkal, lagu kǝ nga ju nda mǝliya nda tsaˈa anǝ Thlagǝr nda.” ");
INSERT INTO mfm_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kǝ Zakariya na anǝ waladi, “Abari nga ya nda sǝni abǝr sǝ kǝ gǝ na kǝ wu nda ɗa? Kǝja nayi ndǝ hahal nga yau, mala ɗa tsu abangǝ nga ja.” ");
INSERT INTO mfm_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Waladi na, “Nayi ngǝ Jibrayilu, ya vǝr taˈyi wu mwar Hyal. Hyal ngǝ sǝwa ɗa aga ya sa nar ngǝ ndǝr kǝ mǝsahǝ gagaɗǝ kau. ");
INSERT INTO mfm_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ama kǝja ga nggǝl ri ara hǝnggǝri ǝnga ndǝr kau, kǝra wu nda ɗa jiri ma pǝci ka ɗari. Agabangau, tsu gu ndǝr mai kǝl ma sǝ kǝ a nyabiyar dzau.” ");
INSERT INTO mfm_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nji kǝra a biya nda vǝr sǝkǝ biyar Zakariya, nda vǝr ɗǝnga mi ngǝ ɗa ji ɓǝliya sar a gwu ki Hyal abanga? ");
INSERT INTO mfm_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pǝci kǝra ji nda biya tsu ju sǝni ndǝr mai, ǝnggau, ba ndǝ sǝni abǝr a lari ja sǝ dǝdǝgur a gwu ki Hyal kau. Kǝ ji dumwa ǝnga ndǝr anǝ nda ǝnga tsi, ama naja sǝni ndǝr ǝnga miya ja mai. ");
INSERT INTO mfm_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ənggǝra pǝcir thlǝr nyi kuɗau, ba ji sha a ndu ki. ");
INSERT INTO mfm_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Aˈyi ɓǝliya sar mai, kǝ mala nyi Alisabatu hǝri huɗǝu, kǝ ji mbunakǝr nǝ hya tǝfu wu ki naji biya mai. ");
INSERT INTO mfm_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Alisabatu dzǝgwa na, “Thlagǝ a mǝliya ɗar sǝ dǝgal wu yukuɗu, ǝnga ji tǝhuɗǝ ǝgya yau, ji hǝna sǝ sǝsǝli kǝra ar kǝra yau wu pama nji.” ");
INSERT INTO mfm_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ənggǝra Alisabatu mǝliya hya kwa ǝnga huɗǝu, kǝ Hyal sǝwa waladi Jibrayilu a ndu vanyi mǝlmǝ wu Galili nja ngga ǝnga Nazǝratu. ");
INSERT INTO mfm_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ji sǝwa nyi ǝnga ndǝshigu mǝsahǝu a ndara kwapǝliyagǝ kǝra alkawal mbamba nǝ hǝ dzǝ aˈyi wu pama nda ǝnga vanyi ndǝ kǝra nja ngga ǝnga Yusufu, sara wu culi gǝ tǝl Dawuda. Thlǝmǝr kwapǝliyagǝ kǝ ca ngǝ Maryamu. ");
INSERT INTO mfm_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ənggǝra waladi kǝ shili ǝgya ja, kǝ ji na, “Nja vǝr usa ngau! Thlagǝ aˈyi ja ǝnga gau, naja tsu a fǝnggǝr ngǝr ja barka.” ");
INSERT INTO mfm_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ənggǝra Maryamu nggari usa dzǝ kau, kǝ sǝ kǝ ɓwanǝ nyi kǝr ba fuwa nyi wu ɗǝnga sǝ gagaɗau, ja vǝr ɗǝnga wa thlǝmǝ najaka usa dza. ");
INSERT INTO mfm_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kǝ waladi kǝ na anǝ nyi, “Maryamu, a sara ga hivǝr mai, arya nagǝ a uyar gǝ mayiwakur ara Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","“Kǝja gu nda hǝri huɗǝu, gu yabiya zǝr sal, gu nda nǝ nyi thlǝmǝ Yesu. ");
INSERT INTO mfm_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ju nda ɗa ndǝ dǝgalǝu, ǝtsu nju nda ngga nyi ǝnga Zǝr Hyal dǝgal gagaɗau. Hyal Thlagǝ wu nda nǝ nyi vir nggya nǝr tǝlkur nǝ ǝji nyi Dawuda. ");
INSERT INTO mfm_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ju nda sǝm tǝlkur nyi ar kǝra ki Yakubu baˈanuwa, tǝlkur nyi tsu aˈyi wu nda kuɗǝ mai!” ");
INSERT INTO mfm_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kǝ Maryamu na anǝ waladi, “Abari ngǝ sǝka sǝn ɗa, kǝja nayi saya sǝni ndǝ sal maya?” ");
INSERT INTO mfm_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kǝ waladi shaɗǝwa nyi, ji na, “Mambǝl Cicau wu nda gyar kǝra gau, dǝnama nǝ Hyal Kǝra Di wu nda mbuya ngǝ tsu. Agabangǝ zǝr kǝ gu nda ya kau, nju nda na anǝ nyi ndǝ cicau, naja ngǝ Zǝr Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Kǝja Alisabatu kwamǝ ngau, kǝra nji na, naji wu ya mai, kabangǝkǝ huɗǝ hya kwa ngǝ ara ja, wu hahalkur nyi kau, ");
INSERT INTO mfm_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ara sǝr kari nyi kǝr anǝ Hyal aˈyi mai.” ");
INSERT INTO mfm_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Əngwar Maryamu, “Nayau, mafa Hyal ngau, bǝgǝ ja ɗa anǝ ɗa ǝnggǝra gǝ na kau.” Ənggau, kǝ waladi kǝ maˈyi sǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ayukuɗa pǝci kushu, kǝ Maryamu pabǝri kǝrnyi, kǝ ji maˈyi ǝnga kusa, a ndu vanyi mǝlmǝ nǝr ˈyiˈyir Yahudi kǝra wu pama mau. ");
INSERT INTO mfm_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ənggǝra ji shili wu mǝlmǝ kau, kǝ ji vu ki Zakariya, ji vuwa usar Alisabatu. ");
INSERT INTO mfm_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ənggǝra Alisabatu nggari usa dzǝ kau, kǝ zǝr kǝra gwu ta Maryamu ɗa mumuɗǝu, ǝnggau, kǝ Alisabatu nyau ǝnga Mambǝl Cicau. ");
INSERT INTO mfm_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kǝ ji hyaˈana ɗahǝu ǝnga dǝnama ji na, “Nagǝ ǝnga barka wu pama mathlǝkǝˈyi, Zǝr kǝra gu nda ya kǝ tsu ǝnga barka nga ja! ");
INSERT INTO mfm_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Abari ngǝ mayiwakur kǝ sǝni shili anǝ ɗa, patǝ ǝkkǝˈyi miya Thlagǝ ɗa, a shili ǝgya ya? ");
INSERT INTO mfm_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ənggǝra yi nggari usa dzǝ ngau, ngǝ zǝr kǝra gwu ta yi ɗa mumuɗǝu ara huɗǝ pipida. ");
INSERT INTO mfm_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ndǝr barka nga gau ara gǝ hǝnggǝri abǝr sǝ kǝ Thlagǝ nana kǝ wu ɗa ǝnga jiri.” ");
INSERT INTO mfm_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maryamu na, “Ɗǝfuwa yau a vǝr fal Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Piya yi tsu a vǝr caguli ara Hyal ngǝ Ndǝr Mbǝɗa ɗa, ");
INSERT INTO mfm_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ara ji ɗǝngari ǝnga yau, nayi kǝra mafa nyi kǝra aˈyi vanyi sǝ mai! Mbari kabangǝkau, patǝr nji wu nda ngga ɗa ǝnga ndǝr barka, ");
INSERT INTO mfm_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","arya sǝ dǝdǝgalˈyar kǝ kǝra Hyal ndǝ dǝnama mǝliya ɗa. Thlǝmǝ nyi ndǝ cici ngau! ");
INSERT INTO mfm_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ciji baˈanǝ ciji ju nda tǝhuɗǝ ǝgya njira wu nǝ nyi dǝgalkur. ");
INSERT INTO mfm_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ənga tsi nǝ dǝnama nga ji mǝliya sǝ dǝdǝgalˈyar! Ji tǝtǝlna njir fǝkǝr nda ǝnga sǝra ndu fǝr kǝr ǝni wu ɗǝfuwa nda. ");
INSERT INTO mfm_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A hǝyari ja tǝltǝlˈyar sara wu tǝlkur nda, ǝnga ji hyaˈana nji didiɗi. ");
INSERT INTO mfm_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ji nǝ nyi sǝr sǝm mǝsahǝu anǝ njir wuɓau, kǝ ji mǝliya njir gǝnna ndǝ maˈyi ǝnga tsi kurthlǝu. ");
INSERT INTO mfm_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ji dlǝwari mafa nyiˈyar njir Izirayila ǝnga ji ɗǝngari ji cabiya tǝhuɗǝ anǝ nji nyi, ");
INSERT INTO mfm_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ǝnggǝra ji mǝliya alkawal anǝ ǝjir mǝn Ibrahimu ǝnga culi nyi baˈanuwa!” ");
INSERT INTO mfm_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maryamu nggya ǝnga Alisabatu ǝnggǝr hya makǝru, kadivira ji dzǝgwa sha a ndu ki gǝ nda. ");
INSERT INTO mfm_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ənggǝra pǝcir ya nyi ɗa, kǝ Alisabatu yabiya zǝr nyi. ");
INSERT INTO mfm_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tǝwul nyi ǝkkǝˈyi nji gǝ nda ndǝ nggari ǝnggǝra Thlagǝ canǝ nyi tǝhuɗǝ dǝdǝgal anǝ nyi, kǝ ndǝ daɓǝr dzǝ ndu caguli ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ənggǝra zǝr kǝ tǝkǝri pida cisu, kǝ ndǝ shili aga nda sa thlana nyi pǝlzha, ndu yiwu nda fiya nyi thlǝmǝr dǝnyi, Zakariya. ");
INSERT INTO mfm_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ama kǝ miya zǝr na, “Awau! Nja nda ngga nyi ǝnga Yahwana.” ");
INSERT INTO mfm_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Əngwar nda anǝ nyi, “Wu culir hyi wa ngǝ ǝnga culi thlǝmǝ ka?” ");
INSERT INTO mfm_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kǝ ndǝ yiwa dǝya zǝr ǝnga tsi, thlǝmǝ kǝra ja yiwu nja ngga zǝr kǝ ǝni. ");
INSERT INTO mfm_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kǝ ji yiwa, nja nǝ nyi lǝkakaɗau, kǝ ji tsǝfǝri, “Thlǝmǝ nyi Yahwana ngau.” Kǝ sǝ kǝ ɗa sǝ dǝdǝgur anǝ njira a ndǝna! ");
INSERT INTO mfm_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ənggǝ ngǝ miya Zakariya pahǝnakǝr, kǝ ji dzǝguya ndǝr ǝnga fal Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kǝ sǝ kǝ nǝ nyi hivǝr anǝ tǝwulǝr nda patǝu. Njir ˈyiˈyir Yahudi njir nggya wu pama mau tǝtǝlna sǝ kǝ ɗa kǝ baˈamani. ");
INSERT INTO mfm_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kalar ndǝra nggari sǝ kau, ba nǝ nyi ɗǝnga, ju na, “Mi ngǝ zǝr kǝ wu nda ɗa?” Ara a tsamǝr nji abǝr tsa Hyal aˈyi ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ənggǝra Mambǝl Cicau shida ar kǝra Zakariya dǝya Yahwana, kǝ ji dzǝguya ndǝr kǝra Hyal nǝ nyi, ji na, ");
INSERT INTO mfm_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Barka anǝ Thlagǝu, Hyal nǝr Izirayila! Ji shili aga sa dlǝwa nji gǝ nda, ja kǝtiya nda. ");
INSERT INTO mfm_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ji nǝ mǝn ndǝr Mbǝɗa nji ǝnga dǝnama sara wu ki mafa nyi Dawuda. ");
INSERT INTO mfm_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ənggǝr kǝra ji mǝliya alkawal tsu kaɗǝu lagu miya nabi nyiˈyar nǝ cicau. ");
INSERT INTO mfm_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ju sa hǝbiya mǝn sara wu tsa njira vǝr ca dawakur anǝ mǝn, ǝnga patǝr njira gǝra yiwu nda lari mǝna cakau. ");
INSERT INTO mfm_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ji mǝl abangǝ aga ja cabiya tǝhuɗǝ nyi anǝ ǝjir mǝnˈyar, ǝnga ji ɗǝngari alkawal nyi nǝ cicau, ");
INSERT INTO mfm_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","kǝra ji mǝliya daɓǝ ǝnga sǝm fǝla anǝ ǝjir mǝn Ibrahimu. ");
INSERT INTO mfm_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ju nda hǝbiya mǝn sara ara dawar mǝnˈyar, aga mǝna dzǝgwa nu nyi ǝnga jirkur gǝra ǝnga hivǝr ");
INSERT INTO mfm_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","wu cicikur ǝnga mǝnahǝkur wu mwar Hyal patǝr nggyabiyar mǝn. ");
INSERT INTO mfm_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nagǝ tsu zǝr kau, nju nda ngga ngǝ ǝnga nabi nǝ Hyal kǝra ndiya ǝnga dǝgalǝu. Gu nda tǝrabiya a dumwar Thlagǝu, aga ga mǝliya lagu nyi kakalǝu. ");
INSERT INTO mfm_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Aga ga nǝ nyi anǝ nji gǝ nda sǝnbiya sǝ ar kǝra mbǝɗǝ lagur tǝfǝbiya nda bikǝr nda, ");
INSERT INTO mfm_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ara gangǝkura tǝhuɗǝ dzǝ nǝ Hyalǝr mǝn, ca ngǝ mbǝmbǝl nǝ mbǝɗau sara a dǝmǝlmau wu nda shida, aga ja sa mbǝl ar kǝra mǝn, ");
INSERT INTO mfm_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ja mbǝl a gyar kǝra njira vǝr nggya wu kuthlǝu, ǝnga njira ǝgya kiɗa shangguɗi nǝ tau, aga ca lagur nggya jamǝ anǝ mǝn.” ");
INSERT INTO mfm_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kǝ Yahwana hau, ji cakǝri dzǝ wu mambǝl. Ji nggya a gwa tagǝ kǝl ta pǝcir biya nyi ar babal anǝ njir Izirayila ɗa. ");
INSERT INTO mfm_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wu pǝci ta, tǝl Kayisaru Agustusu nǝr Roma hyabiya cama abǝr nja tsǝfǝri thlǝmǝr nji patǝ wu kiɗa tǝlkur nyi. ");
INSERT INTO mfm_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kǝ ngǝ jiga nji nǝ tanggǝrma kǝra nji mǝl pǝci kǝra Kiriniyusu a vǝr sǝm Tǝlkur nyi wu ˈyiˈyir Sǝriya. ");
INSERT INTO mfm_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nji patǝ maˈyi a ndu mǝlmǝr nda aga nja nda jigabiya nda. ");
INSERT INTO mfm_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusufu tsu ji piyari Nazǝratu wu ˈyiˈyir Galili ji maˈyi a du Bayitalahami wu ˈyiˈyir Yahudi, mǝlmǝ kǝra nji ya tǝl Dawuda a gwa, ara naja culi zǝmǝ ǝnga Dawuda. ");
INSERT INTO mfm_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ji maˈyi ǝnga Maryamu kǝra alkawal mbamba nǝ hǝ dzǝ aˈyi wu pama nda, aga nja nda jigabiya nda. Wu pǝci ta, Maryamu ǝnga huɗǝ nga ja. ");
INSERT INTO mfm_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ma tsu nda wu Bayitalahami, kǝ pǝcir ya mbari nyi. ");
INSERT INTO mfm_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kǝ ji yabiya zǝr nyi nǝ tanggǝrma, ji pǝɗǝwa nyi wu gumbwara, ji dzǝgwa pina nyi wu nggaɓa, ara nandǝ uya umbwa wu ki dlǝwu mǝthlǝpi mai. ");
INSERT INTO mfm_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","A biyar ya mǝlmǝ kau, njir ɓǝla aˈyi, kǝra a vǝr pida a biyar babal uvuˈyi, nda vǝr tsamǝ tǝmahǝr nda. ");
INSERT INTO mfm_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kǝ waladi Thlagǝ canǝ nda kǝr, ǝnga kadakadarkur nǝ Thlagǝ mbǝl a gyar kǝra nda, kǝra nǝ nda hivǝr gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Əngwar waladi anǝ nda, “Hya sara hivǝr mai! Arya nayi ngǝ shili ǝnga ndǝshigu mǝnahǝ gagaɗau anǝ hyi, kǝra wu nda mǝliya patǝr nji ndu nda ɗa ǝnga huɗǝ pipida. ");
INSERT INTO mfm_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Əshina kau, wu mǝlmǝ gǝ Dawuda, a yabiya hyir nji ndǝr mbǝɗa hyi, naja ngǝ Kǝrsiti Thlagǝu! ");
INSERT INTO mfm_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kǝja sǝra wu nda canǝ hyi nyi, hyu nda thlǝwa zǝr mamanji nji pǝɗǝwa wu gumbwara, nji pina nyi wu nggaɓa.” ");
INSERT INTO mfm_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aˈyi nda ǝnga sǝni mai kǝ waladiˈyar gangǝu ǝnga waladi ta, sara a dǝmǝlmau shida nda vǝr fal Hyal nda vǝr na, ");
INSERT INTO mfm_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kadakadarkur anǝ Hyal kǝra a dǝmǝlmau! Wu duniya bǝgǝ huɗǝ pǝrtǝu a ɗa ara njira Hyal a vǝr nggar mǝsahǝkur nda!” ");
INSERT INTO mfm_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ənggǝra waladiˈyar piyari nda ndǝ maˈyi a dǝmǝlmau, ca ngǝ njir ɓǝla na anǝ kuvwar nda, abǝr, “Mǝn na maˈyi a vu Bayitalahami mǝn na vuwa tsamiya sǝ kǝ ɗa kau, kǝra Thlagǝ nar mǝn ar kǝri kau.” ");
INSERT INTO mfm_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ca nga ndǝ maˈyi ǝnga kusa, kǝ ndǝ vuwa thlǝwa Maryamu ǝnga Yusufu, ǝnga zǝr mamanji, kǝra nji pina wu nggaɓa. ");
INSERT INTO mfm_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ənggǝra ndǝ lari nyi ba ndǝ tǝtǝlna ɗahǝu sǝra waladi nar nda ar kǝra zǝr kau. ");
INSERT INTO mfm_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Patǝkura njira nggari ndǝr kau, ba ɗa sǝ dǝdǝgur anǝ nda sǝ kǝ njir ɓǝla nar nda kau. ");
INSERT INTO mfm_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ama kǝ Maryamu sǝɓiya sǝˈyar kǝ patǝu, ju dzǝgwa ɗǝnga nda wu ɗǝfuwa ja. ");
INSERT INTO mfm_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Njir ɓǝla dzǝgwa sha, nda vǝr thlǝna nǝr fal Hyal ǝnga dlǝvǝ nyi, ara sǝra ndǝ nggari, ǝnga ndǝ lari. Ara patǝr sǝ ɗa ǝnggǝra waladi ta nar nda. ");
INSERT INTO mfm_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ənggǝra zǝra nyi mǝliya pida cisu, ba nji thlana nyi pǝlzha, ba nji fiya nyi thlǝmǝ Yesu, thlǝmǝ kǝra waladi nǝ nyi kadivira nji dzǝgwa hǝ huɗǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kǝ pǝci shili kǝra Maryamu ǝnga Yusufu wu mǝl sǝra dlaɗǝ nǝ Musa nar nda nja mǝl aga nǝ nyi cicikur, ba ndǝ hǝri Yesu a vu Urshalima aga nda vuwa lǝr nyi anǝ Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Abangǝ nga nyi tsǝtsǝfau wu dlaɗǝ nǝ Thlagǝu, abǝr, “Kalar zǝr sal kǝra nji ya nǝ tanggǝrma, nju fiya nyi ja ɗa nǝ cicau nǝ Thlagǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nanda tsu ndu thla sau, ǝnggǝra dlaɗǝ nǝ Thlagǝ cabiya, ǝnga mbǝthla mǝthlǝ ǝnga wazha mbǝthla masar mǝthlǝu. ");
INSERT INTO mfm_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Wu pǝci kau, vanyi ndǝ aˈyi a vǝr nggya wu Urshalima kǝra nju ngga ǝnga Simiyanu. Naja ndǝ tsapǝu, ndǝr gǝnggǝr nyi sǝli anǝ Hyal, naja vǝr sǝkǝ pǝci kǝra nju sa hǝbiya njir Izirayila wu ɓwaɓwatǝu. Mambǝl Cici tsu a vǝr nggya ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mambǝl Cici cabiya nyi abǝr naji wu tǝ mai kǝl ji lari Kǝrsiti kǝra Thlagǝ mǝliya nyi alkawal. ");
INSERT INTO mfm_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ənggǝra Mambǝl lǝbiya nyi ba ji gwu vir pathla nǝ ki Hyal, ar pǝci kǝra njir ya Yesu hǝri nyi a shili wu ki Hyal aga nda mǝliya sǝra dlaɗǝ cabiya nja mǝl, ");
INSERT INTO mfm_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","kǝ Simiyanu dlǝwuri zǝr kǝ wu tsa ja, kǝ ji usa Hyal ji na, abǝr, ");
INSERT INTO mfm_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kabangǝkǝ Thlagǝu, lǝbiya mafa ngǝ ja maˈyi ǝnga huɗǝ pǝrtǝu, ǝnggǝra gǝ mǝliya alkawal, ");
INSERT INTO mfm_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","arya liya yau a lari mbǝɗǝ ngau, ");
INSERT INTO mfm_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","mbǝɗǝ kǝra gǝ mǝliya a dumwar nji patǝu. ");
INSERT INTO mfm_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mbǝmbǝl kǝra sa cabiya ngau anǝ njira aˈyi njir Yahudiya mai, kǝra tsu a sa cabiya kadakadarkur ngau anǝ nji ngau, njir Izirayila.” ");
INSERT INTO mfm_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Dǝya zǝr ǝnga mǝnyi nda vǝr tsamǝ sǝ dǝdǝgur sǝra Simiyanu a vǝr na ar kǝra ja. ");
INSERT INTO mfm_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyanu fǝnggǝr nda barka, ji na anǝ Maryamu miya zǝr, “Hyal a caɗǝbiyari zǝr kau, aga ja ɗa sǝr thlǝ hi anǝ nji ǝnga sǝr hyaˈana alenyi nji gangǝu wu Izirayila. Ja sa ɗa ǝnggǝr sǝra nja tsamǝ sǝ ari sara ara Hyal kǝra nji gangǝu a nda yiwu mai. ");
INSERT INTO mfm_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Agabangǝ sǝra ɗǝɗǝwa wu ɗǝfuwa nji a nda ɗa ar babal. Najaka sau, a sa ɗa kwakwaɗǝ anǝ ngau, ǝnggǝr hǝnggya nga nji tsaviya ɗǝfuwa gǝ ǝni.” ");
INSERT INTO mfm_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Vanyi madedegǝu aˈyi nabi mala thlǝmǝ nyi Hanatu kwar Fanuwalu nǝr culi Ashiru. Ji nggya ǝnga sal nyi nǝ fa mǝɗǝfǝ wacu ǝnggǝra ndǝ hǝri dzau. ");
INSERT INTO mfm_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ba sal nyi kǝ tau. Kabangǝkau, fa nyi cisu kumunyi apǝ foɗǝ nga nyi. Naji sayi piyari ki Hyal mai, ja vǝr dlǝkǝr anǝ Hyal vuˈyi ǝnga puci, ja vǝr ndǝr ǝnga Hyal ǝnga hǝ zǝmǝtsini. ");
INSERT INTO mfm_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kakalǝ wu pǝci kau, kǝ mala kǝ gwa ja vǝr usa Hyal, naja tsu ji ndǝr ar kǝra zǝr kǝ anǝ nji patǝu, njira vǝr sǝkǝ Hyal ja sa nǝ nyi nggya jamǝ anǝ Urshalima. ");
INSERT INTO mfm_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wu pǝci kǝra Yusufu ǝnga Maryamu kuɗǝna sǝˈyar kǝ patǝu, sǝra dlaɗǝ nǝ Thlagǝ na nja mǝl, ba ndǝ sha a vu mǝlmǝr nda Nazǝratu wu Galili. ");
INSERT INTO mfm_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Zǝr kǝ hau, ǝnga dǝnama, nyinyau ǝnga tsǝtsǝlkur. Tǝhuɗǝ Hyal tsu aˈyi ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kalar fa njir ya Yesu ndu vu Urshalima aga lardur nǝr vǝlna nǝ njir Izirayila. ");
INSERT INTO mfm_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ənggǝra Yesu tǝkǝri fa kumo apǝ mǝthlǝu ǝnga ya, ba ndǝ mai a ndu lardura nyi ǝnggǝra ndǝ tsǝliya. ");
INSERT INTO mfm_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ayukuɗa lardur kuɗau, ba ndǝ mbari lagu nda vǝr sha a ndu ki, ama ba ji taˈyi wu yukuɗǝ wu Urshalima, gǝra ǝnga sǝni njir ya nyi. ");
INSERT INTO mfm_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nanda tsu ndu nggani wu pama nji nga ja, agabangǝ kǝ ndǝ dumwa ǝnga ɓau nǝ pǝkǝ pathlǝu. Ənggau, kǝ ndǝ dzǝguya gal nyi a ndu pama njir nda ǝnga bazhir nda ˈyar. ");
INSERT INTO mfm_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ama nandǝ lari nyi mai. Agabangǝ kǝ ndǝ ɓǝra sha a vu Urshalima aga nda vuwa gal nyi a vuna. ");
INSERT INTO mfm_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pǝci nǝ pida makǝrkura nyi ba ndǝ thlǝwa nyi a vǝr nggya a gwu vir pathla nǝ ki Hyal wu pama malǝmˈyar. Ja vǝr sǝ himi nda, ǝnga ja vǝr yiwa nda sǝ pamǝpamǝu. ");
INSERT INTO mfm_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Patǝkura njira nggari nyi ndǝ sǝɓiya miya nda, ǝnggǝra sǝnbiya sǝ nyi ǝnga shaɗǝwa nyi ɗa sǝ dǝdǝgur anǝ nda. ");
INSERT INTO mfm_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Njir ya nyi ba ɗa sǝ dǝdǝgur anǝ nda ǝnggǝra ndǝ lari nyi ǝnggau, kǝ mǝnyi na anǝ nyi, “Zǝr ɗa ara mi nga gǝ mǝl anǝ ˈya abanga? Nayi ǝnga dǝngau anǝ ˈyar ɗǝnga sau ara naˈyi lari ngǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ji shaɗǝwa nda, ji na, “Mi ngǝ ɗa hyu gal ɗa ɗǝma? Nahyi aˈyi sǝni abǝr a ɗar tsaˈa ya nggya wu ki dǝɗa wa?” ");
INSERT INTO mfm_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ama nandǝ sǝni sǝra ndǝr kǝ aga nyi mai. ");
INSERT INTO mfm_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ba ji hyaˈari ji nu nda, ndǝ sha vu Nazǝratu ǝnga ja, ja vǝr dumwa ǝnga mǝl sǝra njir ya nyi a vǝr na anǝ nyi. Mǝnyi tsu ji sǝɓiya sǝˈyar kǝ patǝu, wu ɗǝfuwa ja. ");
INSERT INTO mfm_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu hau wu tsǝtsǝlkur ǝnga wu nǝ kumǝr dzau, ba ǝnga mayiwakur sara ara Hyal ǝnga nji. ");
INSERT INTO mfm_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Wu fa nǝ kumo apǝ tǝfu wu tǝlkur nǝ Kayisaru Tiberiyasu, Buntusu Bilatusu ca ngǝ gwamna nǝr Yahudi, Hirudusu tsu ca ngǝ tǝl nǝr Galili, Fǝlipǝu zamǝ nyi ca ngǝ tǝl nǝr ˈyiˈyir Ituriya ǝnga Tarakunitusu, Lisaniyasu tsu tǝl Abilinisu. ");
INSERT INTO mfm_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasu ǝnga Kayafasu nanda ngǝ pubu dǝdǝgalˈyar. Wu pǝci ta tsu ngǝ ndǝr Hyal shili anǝ Yahwana zǝr Zakariya a gwar tagǝ mashi. ");
INSERT INTO mfm_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kǝ Yahwana zǝwuya patǝkura ˈyiˈyi kǝra ar dza dǝl Urdǝnu. Ja vǝr tǝtǝlna ndǝr Hyal nǝ tubi anǝ nji, ja vǝr na, “Sha mau a shili wu lagu Hyal aga hya uya baɓǝtizǝma, Hyal tsu ju sa tǝfǝbiya hyi bikǝr hyi.” ");
INSERT INTO mfm_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ənggǝra nabi Əshaya tsǝfǝri wu lǝkakaɗǝ nǝ Hyal abǝr, ji na, “Ɗahǝ a vǝr ngga a gwar tagǝu, ja vǝr na, ‘Hya pabǝri nyi lagu anǝ Thlagǝu, hya mǝliya lagu tataˈyi pir wu mwa nyi. ");
INSERT INTO mfm_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nja sa nyanyana kalar dagǝu, kalar mǝ ǝnga gar nja hǝya a gya. Nju taˈyibiya lagu mbambalˈyar, lagu didiɗiˈyar tsu nju mǝliya mǝnahǝu. ");
INSERT INTO mfm_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ənga patǝr ndapi wu nda lari mbǝɗǝ nǝ Hyal.’” ");
INSERT INTO mfm_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kǝ dlamir nji maˈyi a ndǝra Yahwana aga nda uya baɓǝtizǝma ara ja. Kǝ Yahwana nar nda, “Nahyi wazha mǝtsapa! Wa ngǝ kughiya hyi, aga hya hwi sara ara numa nǝ huɗǝ ndzǝndzǝ Hyal kǝra a vǝr shili ka? ");
INSERT INTO mfm_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Hya mǝl thlǝr kǝra mǝnahǝu wu nggyabiyar hyi kǝra wu cabiya abǝr a tubir hyi. A sara hya fiya wu ɗǝfuwa hyi tsu, abǝr, ‘Ibrahimu ngǝ dǝrˈya.’ Yu na anǝ hyi, abǝr Hyal aˈyi ja ǝnga dǝnama nǝ shabiya tsǝkaˈyar kau, aga wazha anǝ Ibrahimu. ");
INSERT INTO mfm_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","A fiyar nji hira kǝm ar nggyilanga wu. Kalar wu kǝra gǝra pǝ wazha mǝnahǝu, nju nda gǝmna nyi, ba nja vakuwa a gwu uˈu.” ");
INSERT INTO mfm_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kǝ nji kǝ yiwa nyi, “Mi nga ˈya kyaga mǝla?” ");
INSERT INTO mfm_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yahwana shaɗǝwa nda, ji na, “Abǝr kalar ndǝra ǝnga lǝgutǝ mǝthlǝu, ja nǝ nyi pathlǝu anǝ ndǝra gǝra ǝni, kalar ndǝra ǝnga sǝr sǝm tsu ja mǝliya abangau.” ");
INSERT INTO mfm_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Njir tsǝm budǝ tsu ndǝ shili aga ja mǝliya nda baɓǝtizǝma, ndǝ yiwa nyi, ndǝ na, “Malǝmǝ, mi nga ˈya mǝla?” ");
INSERT INTO mfm_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Əngwar ja anǝ nda, “A sara hya dlǝwu a ndiya sǝra nji na hya tsǝm mai.” ");
INSERT INTO mfm_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Abangǝ tsu ngǝ alenyi sojaˈyar yiwa nyi, “Kar naˈya tsu, mi nga ˈya mǝla?” Kǝ ji na anǝ nda, “A sara hya canggǝr nyi anǝ nji aga nda nǝ hyi gǝnna ǝnga dǝnama mai, a sara hya thla fati ar kǝra nji mai, hya mbiya ɗǝfu ǝnga sǝra nji kina hyi ǝni.” ");
INSERT INTO mfm_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nji patǝ a vǝr sǝkǝ shilir Kǝrsiti, ndǝ lari Yahwana kǝ ndǝ dzǝguya ɗǝnga wu ɗǝfuwa nda tara Yahwana ngǝ Kǝrsiti kau. ");
INSERT INTO mfm_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kǝ Yahwana shaɗǝwa nda patǝu, “Nayau, ya vǝr mǝl baɓǝtizǝma anǝ hyi ǝnga ˈyimi. Ama vanyi ndǝra ndiya ɗa ǝnga dǝnama a vǝr shili, kǝra alaga sǝr mba ɓiɓi nyi nayi aˈyi ɗa tsa aga ya pǝlna mai. Ju sa mǝliya hyi baɓǝtizǝma ǝnga Mambǝl Cicau ba ǝnga uˈu. ");
INSERT INTO mfm_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Cala pi nyi wu tsa ja nga nyi, ju pina uhi ba ja batǝna lar nyi ba ja dzǝgwa faˈana uhi a su tsam. Kofu ǝnga cacangǝ ba ja nggyina nda ǝnga uˈu kǝra gǝra tau.” ");
INSERT INTO mfm_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ənga ɗahǝ pamǝpamǝ gangǝu ngǝ Yahwana tǝtǝlna ndǝshigu mǝsahǝ anǝ nji. ");
INSERT INTO mfm_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ama ǝnggǝra Yahwana kughiya kughi anǝ gwamna Hirudusu kǝra hǝri Hirudiyasu mala zamǝ nyi Fǝlipǝu ǝnga patǝkura alenyi sǝ ɗǝmwaˈyi kǝra ji mǝliya. ");
INSERT INTO mfm_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kǝ Hirudusu ɓǝra cakǝri ɗǝmwaˈyikur nyi ba ji fuwa Yahwana wu fursǝna. ");
INSERT INTO mfm_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ayukuɗa ji kuɗǝna mǝl baɓǝtizǝma anǝ nji patǝu, ba ji mǝliya nyi anǝ Yesu tsu, ǝnggǝra Yesu a vǝr ndǝr ǝnga Hyal ba dǝmǝlmǝ pahau, ");
INSERT INTO mfm_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","kǝ Mambǝl Cici shida ar kǝra ja a papa mbǝthla. Kǝ ɗahǝ sara a dǝmǝlmǝ na, “Nagǝ ngǝ zǝr ɗa, yu yiwu ngau, huɗa yi pipida ǝnga gau.” ");
INSERT INTO mfm_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ar pǝcira Yesu dzǝguya thlǝr nyi nǝ highiɓau, a tǝkǝr ja fa makǝr kumunyi wu duniya. Nji hǝri nyi abǝr naja zǝr Yusufu kǝra zǝr Hali. ");
INSERT INTO mfm_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hali zǝr Matata, Matata zǝr Lawi, Lawi zǝr Melci, Melci zǝr Yonna, Yonna zǝr Yusufu, ");
INSERT INTO mfm_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusufu zǝr Matatiyasu Matatiyasu zǝr Amosu, Amosu zǝr Nahumu, Nahumu zǝr Azaliya, Azaliya zǝr Nagayi, ");
INSERT INTO mfm_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi zǝr Maata, Maata zǝr Matatiyasu Matatiyasu zǝr Saminu, Saminu zǝr Joseku, Joseku zǝr Yahuda, ");
INSERT INTO mfm_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yahuda zǝr Yuwana, Yuwana zǝr Resa, Resa zǝr Zarubabelu, Zarubabelu zǝr Shaltiyalu, Shaltiyalu zǝr Neri, ");
INSERT INTO mfm_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri zǝr Melci, Melci zǝr Adi, Adi zǝr Kusam, Kusam zǝr Elmoda, Elmoda zǝr Eri, ");
INSERT INTO mfm_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri zǝr Jashuwa, Jashuwa zǝr Elezar, Elezar zǝr Jarimu, Jarimu zǝr Matata, Matata zǝr Lawi, ");
INSERT INTO mfm_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lawi zǝr Simiyanu, Simiyanu zǝr Yahuda, Yahuda zǝr Yusufu, Yusufu zǝr, Janamu, Janamu zǝr Eliyakimu, ");
INSERT INTO mfm_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakimu zǝr Meliya, Meliya zǝr Meyinna, Meyinna zǝr Matathla, Matathla zǝr Nathlanu, Nathlanu zǝr Dawuda, ");
INSERT INTO mfm_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawuda zǝr Jesi, Jesi zǝr Obida, Obida zǝr Buˈaza, Buˈaza zǝr Salmonu, Salmonu zǝr Nashanu, ");
INSERT INTO mfm_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashanu zǝr Aminadaɓǝu, Aminadaɓǝu zǝr Aramu, Aramu zǝr Hesaruna, Hesaruna zǝr Parisu, Parisu zǝr Yahuda, ");
INSERT INTO mfm_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda zǝr Yakubu, Yakubu zǝr Ishaku, Ishaku zǝr Ibrahimu, Ibrahimu zǝr Tera, Tera zǝr Nahoru, ");
INSERT INTO mfm_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahoru zǝr Seragu, Seragu zǝr Riyu, Riyu zǝr Pelegǝ, Pelegǝ zǝr Eberu, Eberu zǝr Shila, ");
INSERT INTO mfm_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shila zǝr Kayinanu, Kayinanu zǝr Arfashadu, Arfashadu zǝr Shemu, Shemu zǝr Nǝhu, Nǝhu zǝr Lameku, ");
INSERT INTO mfm_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameku zǝr Metusǝla, Metusǝla zǝr Enoku, Enoku zǝr Jaredu, Jaredu zǝr Mahalalelu, Mahalalelu zǝr Kenanu, ");
INSERT INTO mfm_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenanu zǝr Enoshu, Enoshu zǝr Shitu, Shitu zǝr Adamu, Adamu zǝr Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu piyari dǝl Urdǝnu nyinyau ǝnga Mambǝl Cicau, Kǝ Mambǝl Cici lǝbiya Yesu a gwar tagǝu, aga shatan a gwa dzǝbiya nyi. ");
INSERT INTO mfm_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ayukuɗa Yesu hǝr zǝmǝtsini nǝ pida foɗǝ kumunyi vuˈyi ǝnga pǝci, kǝ wuɓǝ mbari nyi. ");
INSERT INTO mfm_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kǝ Shatan na anǝ nyi, “Ma nagǝ ngǝ zǝr Hyal, ga nar nyi anǝ tsǝka kau, aga ja sha aga macikǝl.” ");
INSERT INTO mfm_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kǝ Yesu shaɗǝwa, ji na, “Tsǝtsǝfǝ nga nyi wu ndǝr Hyal abǝr, “ ‘Aˈyi ǝnga sǝr sǝm wacu ngǝ ndǝ wu nggya ǝnga pi mai.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kǝ Shatan hǝr nyi a dar vi kǝra dzǝgamǝ gagaɗau, ka canǝ nyi patǝkura tǝlkur nǝ duniya, ǝnga sǝra a gwa patǝ nǝ pǝci kushu. ");
INSERT INTO mfm_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kǝ ji na anǝ nyi, “Yi wu nǝ ngǝ dǝnama tǝlkur ǝnga kadakadarkur sǝˈyar kǝ patǝu, arya anǝ ɗar nji, yu sǝni nǝ nyi anǝ kalar ndǝra yu yiwu tsu. ");
INSERT INTO mfm_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ma gǝ nǝ ɗa dǝgalkur, sǝˈyar kǝ patǝ wu ɗa nǝngau.” ");
INSERT INTO mfm_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu na anǝ nyi, “Tsǝtsǝfǝ nga nyi abǝr, “ ‘Ga dlǝvǝ Hyal Thlagǝ ngau, ba tsu naja zhizhi nyi wacu nga ga mǝl sǝra ja yiwu.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Shatan ɓǝra hǝr nyi a vu Urshalima, ba ji hǝri nyi a dar kǝra ki Hyal a dar vira ndiya ǝnga dzǝgamǝu. Kǝ ji na anǝ nyi, “Ma nagǝ ngǝ zǝr Hyal, ga vǝl a gyiwu ˈyi sara ǝnggau, ");
INSERT INTO mfm_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","arya tsǝtsǝfǝ nga nyi wu ndǝr Hyal, abǝr, “ ‘Ju sǝwa waladi nyiˈyar aga nda ɓǝlar ngau. ");
INSERT INTO mfm_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ndu sǝɓiya ngu tsa nda ara ga sara dǝgǝri hiya gǝ ar tsǝka.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ama Yesu na nǝ nyi, “Tsǝtsǝfǝ nga nyi abǝr, “ ‘Ga sara dzǝ Hyal Thlagǝ ngǝ mai.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ənggǝra Shatan kuɗǝna dzǝ nyi wu lagu pamǝpamǝ patǝu, ba ji piyari nyi nǝ pǝci kushu ju sǝkǝ vanyi pǝci ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu sha a vu Galili, ǝnga dǝnama nǝr Mambǝl nga ja, ndǝr ar kǝra ja a tǝtǝlnar kǝr a ndu mǝlmǝ pamǝpamǝ patǝu, ");
INSERT INTO mfm_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ja vǝr highiɓau wu umbwa daɓǝ dzǝ njir Yahudi, nji patǝ a vǝr fal nyi. ");
INSERT INTO mfm_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ənggau, kǝ ji maˈyi a vu Nazǝratu, mǝlmǝ kǝra ji hau a gwa. Pǝcir Ɓǝlsar, ba ji maˈyi a gwu umbwa daɓǝ dzǝ njir Yahudi, ǝnggǝra ji tsǝliya. Ji hyaˈari aga jiga ndǝr Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kǝ nji nǝ nyi lǝkakaɗǝ nǝ Hyal nǝ tsǝfǝ Nabi Əshaya. Kǝ ji pahǝna ba ji uya vi kǝra nji tsǝfǝya abǝr, ");
INSERT INTO mfm_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Mambǝl Thlagǝ aˈyi ar kǝra yau, kǝra caɗǝbiya ɗa aga ya tǝtǝlna ndǝr mǝsahǝu anǝ njira ǝnga dǝnama tǝtǝwa. Ji sǝwa ɗa aga ya nar nyi anǝ njira wu fursǝna pǝcir pǝl nda a ɗari, nji lǝfau nda sa lar sau, ba tsu ya pǝlna nji mbamba. ");
INSERT INTO mfm_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ji sǝwa ɗa aga ya nar nyi anǝ kalar ndau, abǝr, pǝci kǝra Thlagǝ nana ja sa canǝ nyi mǝnahǝkur nyi anǝ nji patǝ a shiliri.” ");
INSERT INTO mfm_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ayukuɗa ji jigana, ba ji pǝɗiya lǝkakaɗa nyi ba ji dzǝgwa nǝ nyi anǝ ndǝr mǝl thlǝr wu umbwa daɓǝ dzǝ njir Yahudi, ba ji nggya gya. Patǝkura njira a gwu umbwa daɓǝ dzǝ njir Yahudi kau, ba ndǝ pǝnggǝri nyi li. ");
INSERT INTO mfm_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kǝ ji na anǝ nda, “Ndǝr Hyal kǝ tsǝtsǝfǝ kau, a nyabiyar dzǝ wu himiya hyi ǝshina.” ");
INSERT INTO mfm_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Patǝr njira ar vi ta nana ndǝr kǝra mǝnahǝu ar kǝra ja, ba ɓǝra ɗa sǝ dǝdǝgur anǝ nda ǝnga sǝra wu biya sara wu miya ja, ndǝ dzǝgwa yiwa, “Kar ndangǝ ya, aˈyi zǝr Yusufu ta ngǝ wa?” ");
INSERT INTO mfm_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kǝ Yesu na, “Anǝ nda a sǝni yau, hyu yiwu hya nar ɗa karapǝ kau, abǝr ‘Ligǝta, mbǝɗana kǝrngau.’ Mǝliya sǝ kǝra ˈyi nggari gǝ mǝliya wu Kafarnahumu, ǝnggau, wu mǝlmǝ ngǝ kǝ ɗǝm.” ");
INSERT INTO mfm_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ji ɓǝra na anǝ nda, “Jirkura nyi, ca ngǝ nabi naja aˈyi ndǝra nji dlǝwuri wu mǝlmǝ nyi mai.” ");
INSERT INTO mfm_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Ya nar hyi jiri, wu pǝcir nabi Iliya mathlǝkǝˈyi tǝsal aˈyi gangǝu wu ˈyiˈyir Izirayila, ǝnggǝra Hyal haɗiya mǝlmau, par aˈyi mai nǝ fa makǝru ǝnga hya kwa, wuɓau aˈyi wu ˈyiˈyi ta gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ama Hyal aˈyi sǝwa Iliya a ndǝra zǝma nda mai, ama a ndu mǝlmǝ Zarafatu wu ˈyiˈyir Sidonu, a ndǝra mala tǝsal kǝra wu mǝlmǝ ta. ");
INSERT INTO mfm_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Wu pǝcir nabi Elisha tsu, njir pibi aˈyi gangǝu wu ˈyiˈyir Izirayila, Zǝma nda aˈyi uya cicikur mai kǝl Naˈamanu ndǝr Suriya wacu.” ");
INSERT INTO mfm_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ta njira wu umbwa daɓǝ dzǝ njir Yahudi kǝ nggari ndǝr kau, ba ndzana huɗa nda gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ndǝ hyaˈari ndǝ tǝɗǝbiya nyi a biyar ya mǝlmau, ndǝ maˈyi ǝnga ja a dar kǝra mau kǝra ndǝ hǝriya mǝlmǝr nda a dari, aga nda vakana nyi a gyiwu ˈyi. ");
INSERT INTO mfm_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kǝ Yesu biya wu pama nda, ba ji mbari lagu nyi ba ji mai sǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Abangǝ tsu, kǝ Yesu sha shili wu Kafarnahumu, mǝlmǝ kǝra wu ˈyiˈyir Galili, ar Pǝcir Ɓǝlsar, kǝ ji dumwa ǝnga highiɓau, anǝ nji. ");
INSERT INTO mfm_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kǝ highiɓǝ kǝ ɗa sǝ dǝdǝgur anǝ nji patǝ ara ǝnggǝra ndǝr nyi wu biya ǝnga dǝnama. ");
INSERT INTO mfm_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Wu umbwa daɓǝ dzǝ njir Yahudi kau, vanyi ndǝ aˈyi ǝnga mambǝl ɗǝmwaˈyu, ba ji hyaˈana ɗahǝu ǝnga dǝnama ji na, ");
INSERT INTO mfm_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Wa yau! Yesu ndǝr Nazǝratu, mi dzǝ ngǝ ǝnga ˈya? Kari gǝ shili aga ga sa kuɗǝna ˈya ya? A sǝni ngǝ yau, nagǝ ngǝ ndǝ cici nǝ Hyal!” ");
INSERT INTO mfm_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Əngwar Yesu anǝ nyi ǝnga dǝnama, “Haɗiya miya gau! Biya wu dza ja!” Kǝ mambǝl ɗǝmwaˈyi kǝ mbilna ndǝ kau, a gyiwu ˈyi wu dzǝri nda patǝu, kǝ ji biya sara wu dza ja gǝra ɓǝra uya nyi ǝnga shilǝgǝu. ");
INSERT INTO mfm_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kǝ ɗa sǝ dǝdǝgur anǝ nji patǝu, ndǝ na wu pama nda, “Abari dur gǝ highiɓǝ ka? Ənga dǝgalkur, ǝnga dǝnama nga ja vǝr ndǝr anǝ mambǝl ɗǝmwaˈyiˈyar, ba nda biya!” ");
INSERT INTO mfm_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ənggǝ ngǝ ndǝr ar kǝra Yesu tǝtǝlnakǝr a ndu mǝlmǝ patǝ wu ˈyiˈyi kau. ");
INSERT INTO mfm_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu biya sara wu umbwa daɓǝ dzǝ njir Yahudi, ji maˈyi a vu ki Simanu. Sǝlkuya Simanu aˈyi ngga mai, gyangǝ nga vǝr tǝ nyi dǝdǝgalǝu. Kǝ ndǝ yiwa Yesu aga ja dlǝwari nyi. ");
INSERT INTO mfm_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu taˈyi ar kǝra ja, ji kughi anǝ gyangǝ kau, kǝ gyanga nyi biya ka piyari nyi. Fina dzǝ aˈyi mai kǝ ji hyaˈari ba ji mǝliya nda sǝr sǝm. ");
INSERT INTO mfm_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ənggǝra pǝci wu gya tǝɗau, kalar ndǝ kǝra ndǝ gǝra ngga ara ja, ndǝ shili ǝni anǝ Yesu, ba ji fǝri nda tsi patǝu, ba ndǝ ɗa jamǝu. ");
INSERT INTO mfm_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Patǝr njira ǝnga mambǝl ɗǝmwaˈyi wu dza nda ndu biya ndu wau anǝ nyi, ndu na, “Na gǝ ngǝ zǝr Hyal!” Kǝ Yesu kughi anǝ nda, ji kari nda ara ndǝr, ara ndu sǝni naja ngǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Əmudlǝkura nyi, kǝ Yesu hyaˈari ji maˈyi a biyar ya mǝlmau, a biyar vi kǝra nji aˈyi mai. Nji biya ga gal nyi ba ndǝ thlǝwa nyi, ndǝ ɗa aga nda kari nyi ara piyari mǝlmǝr nda. ");
INSERT INTO mfm_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ama Yesu na anǝ nda, “A ɗar thlǝr ɗa ya maˈyi a ndu alenyi mǝlmǝ aga ya nda tǝtǝlna ndǝshigu mǝsahǝu nǝ tǝlkur Hyal anǝ alenyi nji tsu. Agabangau, nga nji sǝwa ɗa a shili wu duniya.” ");
INSERT INTO mfm_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ənggau, Yesu ɓǝbiya ɓau wu patǝr ˈyiˈyir Yahudi, ja vǝr highiɓǝ wu umbwa daɓǝ dzǝˈyar, ja vǝr tǝtǝlna ndǝshigu ar kǝra tǝlkur Hyal. Ba ǝnga ja vǝr shilǝgǝbiya kalar shilǝgǝu ǝnga njira gǝra ngga. ");
INSERT INTO mfm_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Vanyi pǝci aˈyi Yesu taˈyi ar dza dǝl nǝr Janisaratu, nji gangǝu ndǝ ciɗǝ nyi ndu yiwu nda nggari ndǝr Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kǝ ji lari kwambwal mǝthlǝ a biyar dza dǝl kǝra njir tǝm fiya ndǝ maˈyi a nda ci litagǝr nda. ");
INSERT INTO mfm_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kǝ ji maˈyi a gwu kwambwal pathlǝu kǝra nǝ Biturusu ngau, ji dzǝgwa kǝdi nyi aga ja ɓari nyi kushu sara miya dǝl. Kǝ ji nggya a gwa ja vǝr highiɓǝ anǝ nji. ");
INSERT INTO mfm_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ənggǝra ji kuɗǝna ndǝr, kǝ ji na anǝ Biturusu, “Ga ɓǝra ɓari kwambwal kau a gwar vi kǝra dzǝgamǝu, ba hya sǝya litagǝr hyiˈyar, aga hya tǝɗǝbiya kalfi.” ");
INSERT INTO mfm_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Əngwar Biturusu, “Thlagǝr ki, a pidari ˈya ghǝmǝ a vǝr tǝm ama naˈya aˈyi mbari sǝ mai. Ama ˈyu sǝya litagǝr ˈya a gya, ma nagǝ ngǝ na.” ");
INSERT INTO mfm_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ənggǝra ndǝ sǝya litagǝr nda a gya, ba ndǝ mbari kalfi gangǝu, kǝl ta litagǝr nda mbar thlǝthlau. ");
INSERT INTO mfm_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ta ndǝ lari abangau, ba ndǝ ngga bazhi tǝmǝr nda sara wu vanyi kwambwal ta aga nda sa dlǝwari nda. Ba ndǝ shili ndǝ sa nyanyana kwambwalˈyar gyapǝ ǝnga kalfi. Ba kwambwalǝr nda mbar gya cau ara tǝdǝɓǝu. ");
INSERT INTO mfm_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ənggǝra Biturusu lari sǝ kau, kǝ ji ɓǝliya undi a dumwar Yesu, ji na, “Tǝkǝ ǝnga yau, Thlagǝu! Nayi ndǝr bikǝ ngau!” ");
INSERT INTO mfm_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ba sǝ kǝ ɗa sǝ dǝdǝgur anǝ nyi ǝnga bazhi nyiˈyar patǝu, ara gangǝkura kalfi kǝra ndǝ mbari, ");
INSERT INTO mfm_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","abangǝ tsu ngǝ Yakubu ǝnga Yahwana, wazha Zabadi, bazhi mǝl thlǝr Biturusu ˈyar. Əngwar Yesu anǝ Biturusu, “Ga sara hivǝr mai, mbari ǝshina, gu ɗa ndǝr tǝm nji ama aˈyi kalfi mai.” ");
INSERT INTO mfm_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kǝ ndǝ tǝɗǝbiya kwambwalǝr nda a biyar miya dǝl, ba ndǝ piyari litagǝr nda, ba ndǝ nu nyi. ");
INSERT INTO mfm_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ar pǝci kǝra Yesu wu vanyi mǝlmau, kǝ vanyi ndǝ kǝra pibi sǝmku dǝnama nyi shili ara ja. Ənggǝra ji lari Yesu, kǝ ji dla ǝnga bama ja a gyiwu ˈyi ja vǝr kǝdi nyi, ji na, “Thlagǝu, ma gu yiwu, gu sǝni cina ɗa aga ya ɗa jamǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kǝ Yesu har tsi ka tsǝkwar nyi, ji na anǝ nyi, “A hǝnggǝr yau, ɗa cicau.” Ənggǝrna, ba pibiya nyi piyari nyi. ");
INSERT INTO mfm_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kǝ Yesu nar nyi ǝnga ɗahǝu, “Ga hangǝkal ga sara na sǝ kǝ anǝ ndǝ mai. Ama ga maˈyi a ndǝgya pubu ga nda canǝ nyi kǝrngau, ga dzǝgwa kǝbǝna sau ǝnggǝra dlaɗǝ Musa nana nja mǝl aga ci dzau. Ga mǝliya abangǝ aga ga cabiya nyi anǝ nji abǝr a ɗar gǝ jamǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ama alaga abangau, kǝl dumwa ǝnga cakau, ngǝ ndǝr ar kǝra Yesu wu cakau. Nji gangǝ tsu a vǝr shili ǝgya ja aga nda nggari highiɓǝ nyi ba ji shilǝgǝbiya nda sara ara shilǝgǝr nda pamǝpamǝu. ");
INSERT INTO mfm_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ama Yesu, ju maˈyi a biyar ya mǝlmǝ a biyar vi kǝra nji aˈyi mai aga ja ndǝr ǝnga Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Vanyi pǝci ǝnggǝra ja vǝr dumwa ǝnga highiɓau, njir Farisi ǝnga malǝmǝ dlaɗǝ sara wu mǝlmǝ pamǝpamǝ nǝr ˈyiˈyir Galili, ǝnga ˈyiˈyir Yahudi ǝnga ˈyiˈyir Urshalima, a vǝr nggya ǝna. Dǝnama nǝ Thlagǝ aˈyi ǝnga ja, aga shilǝgǝbiya nji kǝra gǝra ngga. ");
INSERT INTO mfm_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kǝ alenyi nji shili ǝnga ndǝ tǝsǝkǝnu, nda vǝr hǝ ar sǝr pida. Ndu yiwu nda hǝri nyi a vu ki, aga nda vuwa pina nyi wu mwar Yesu. ");
INSERT INTO mfm_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ənggǝra ndǝ gal lagu katini ara gangǝkura nji, ba ndǝ maˈyi a dar kǝra umbwa ndǝ da pahǝna ba ndǝ dzǝgwa fuwa nyi a gya lagu kǝra umbwa a gyiwu hada dlami, kakalǝ wu mwar Yesu. ");
INSERT INTO mfm_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ənggǝra Yesu lari mbǝrsar nda, kǝ ji na, “Bazhi, a tǝfǝbiya ngǝr nji bikǝ ngau.” ");
INSERT INTO mfm_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Njir Farisi ǝnga malǝmǝ dlaɗǝˈyar nda vǝr ɗǝnga wu pama nda, “Wa ngǝ ndǝ kǝ wu ndǝr ɗǝmwaˈyi ar kǝra Hyal ka? Wa ngu sǝni tǝfǝbiya bika, aˈyi kǝl Hyal zhizhi nyi wa?” ");
INSERT INTO mfm_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ənggǝra Yesu wu sǝnbiya sǝra ndu ɗǝnga, kǝ ji na anǝ nda, “Mi ngǝ ɗa hyu ɗǝnga sǝˈyar kǝ wu ɗǝfuwa hya? ");
INSERT INTO mfm_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mani nga ndiya ǝnga ɓatsa? Nja na, ‘A tǝfǝbiya ngǝr nji bikǝ ngau,’ ǝndǝga, ‘Hyaˈari ga ɓǝ ya’? ");
INSERT INTO mfm_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ama yu yiwu hya sǝni, abǝr Zǝr Ndǝ aˈyi ja ǝnga dǝnama nǝr tǝfǝbiya bikau wu duniya.” Kǝ ji na anǝ ndǝr tǝsǝkǝnu, “Yu na anǝ ngau, hyaˈari, ga hǝr sǝr pida ngau ga maˈyi a ndu ki.” ");
INSERT INTO mfm_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ənggau, kǝ ji hyaˈari ǝnga kusa wu mwar nji patǝu, kǝ ji hǝri sǝra ja vǝr pida ar ta, ba ji maˈyi a vu ki ja vǝr fal Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ba sǝ ɗa sǝ dǝdǝgur anǝ nda patǝu. Ba ndǝ dzǝgwa nǝ nyi dlǝvǝ anǝ Hyal. Kǝ hivǝr mbari nda gagaɗau, ndu na, “A lari ˈya sǝ dǝdǝgur ǝshina.” ");
INSERT INTO mfm_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ayukuɗa kau, Yesu maˈyi a biya, kǝ ji lari ndǝr tsǝm budau kǝra nja ngga ǝnga Lawi a vǝr nggya ar vi tsǝm budǝ nyi. Əngwar Yesu anǝ nyi, “Nu ɗa.” ");
INSERT INTO mfm_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kǝ Lawi hyaˈari, ji piyari sǝra ja vǝr mǝl patǝu, ba ji nu nyi. ");
INSERT INTO mfm_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ayukuɗa nyi, kǝ Lawi mǝliya sǝr sǝm nǝr mini wu ki nyi, kǝ ji nggari Yesu ar viya mǝthlǝpi dǝgal, njir tsǝm budǝ gangǝu ǝnga alenyi mǝthlǝpiˈyar nda vǝr sǝm sǝr sǝm ar vi zǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kǝ njir Farisi ǝnga malǝmǝ dlaɗǝˈyar kǝra mbǝrsar nda zǝmǝ ndǝ dzǝguya jiga miya anǝ zǝmbǝlma nyiˈyar, “Mi ngǝ ɗa hyu sǝm hyu sa ǝnga njir tsǝm budǝ ǝnga njir bika?” ");
INSERT INTO mfm_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Əngwar Yesu anǝ nda, “Aˈyi nji jamǝ ngu yiwu ligǝta mai, ama nji kǝra gǝra ngga. ");
INSERT INTO mfm_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nayi aˈyi dla aga sa ngga nji cici mai ama njir bikau, aga nda tubi nda bǝlari nggyar nda.” ");
INSERT INTO mfm_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ndǝ na anǝ nyi, “Zǝmbǝlma nǝ Yahwana ndu hǝ zǝmǝtsini ar kǝr ar kǝr ǝnga ndu ndǝr ǝnga Hyal, abangǝ tsu ngǝ zǝmbǝlma nǝ njir Farisi, ama nǝngau ndu sǝm ǝnga sa parangǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kǝ Yesu na anǝ nda, “Abǝr a sǝni kari nji bazhiya salkwanjili sǝr sǝm ma tsu nda ǝnga ja ya? ");
INSERT INTO mfm_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ama pǝci wu shili kǝra nju sa hǝna salkwanjili kǝ ara nda. Ar pǝci ta ndu nda hǝ zǝmǝtsini.” ");
INSERT INTO mfm_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kǝ ji nar nda najaka karapau, ji na, “Ndǝr tar zhaɓi thlaɓǝu ar mafǝliyangǝ nga nyi, aga ja dzǝgwa ndaɓǝya ndǝɓǝ ǝni ar hahala nyi mai. Ma ji mǝl abangau, a ndzanar ja zhaɓi mafǝliyangǝ kau, ǝnga tsu ndǝɓǝ kau, wu ɗa didiɗi. ");
INSERT INTO mfm_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ətsu ndǝr puwa ˈyimir inabi mafǝliyangǝ a gu pǝla hahal aˈyi mai. Ma ji mǝl abangau, ba ˈyimir inabi mafǝliyangǝ kau, a thlǝnakǝr, ba ja pǝthlǝna nyi, ba ˈyimir inabi kau, a pǝnakǝr ba pǝla ka ndzau. ");
INSERT INTO mfm_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ˈYimir inabi mafǝliyangǝ a gu pǝla mafǝliyangǝ nga nja pau. ");
INSERT INTO mfm_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ətsu ndǝr nda yiwu sa ˈyimir inabi mafǝliyangǝ aˈyi ayukuɗa ji tuwari hahala nyi mai. Ju nda na, ‘Hahala nyi nga ndiya ǝnga mǝsahǝu.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Vanyi pǝcir Ɓǝlsar nǝ Yahudiya, Yesu ǝnga zǝmbǝlma nyiˈyar nda vǝr tǝrabiya wu fa uhi. Nda vǝr ɓau, kǝ zǝmbǝlma nyiˈyar kuratsiya kǝra uhi. ");
INSERT INTO mfm_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ənggǝra njir Farisi lari abangau, kǝ ndǝ na anǝ nyi, “Lari gǝyi, ara mi nga hyu mǝl sǝra dlaɗǝ kari nja mǝl pǝcir ɓǝlsar ra?” ");
INSERT INTO mfm_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu shaɗǝwa nda, “Aˈyi hyi saya jigana sǝra Dawuda ǝnga njir ɓǝ nyi mǝliya ar pǝci kǝra wuɓǝ mbar nda ta wa? ");
INSERT INTO mfm_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ənggǝra Dawuda gwu ki Hyal, naja ǝnga njir ɓǝ nyiˈyar, ǝnga ǝnggǝra ndǝ gwa sǝmku macikǝl cicau kǝra nandu kyaga sǝm mai, kǝl pubuˈyar wacu.” ");
INSERT INTO mfm_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kǝ Yesu na anǝ nda, “Zǝr Ndau Thlagǝ nga ja ar kǝra pǝcir Ɓǝlsar.” ");
INSERT INTO mfm_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ar vanyi pǝcir Ɓǝlsar nǝ njir Yahudiya tsu, kǝ Yesu maˈyi a gwu umbwa daɓǝ dzǝ njir Yahudiya ja vǝr highiɓau. Wu umbwa ta vanyi ndǝ aˈyi kǝra ǝnga tsi mazǝma ja ndzǝndzau. ");
INSERT INTO mfm_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Njir Farisi ǝnga malǝmǝ dlaɗǝˈyar a vǝr gal lagu kǝra nda sǝni vazǝya Yesu, ndǝ pǝnggǝri nyi li, nda vǝr tsamǝ tara ju mǝliya ndǝ kǝ jamǝ ar pǝcir Ɓǝlsar. ");
INSERT INTO mfm_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ama Yesu wu sǝni sǝra ndu ɗǝnga, kǝ ji na anǝ ndǝ kǝ ǝnga tsi ndzǝndzǝ kau, “Hyaˈari ga taˈyi wu mwar nji patǝu.” Kǝ ji hyaˈari, kǝ ji taˈyi ǝna. ");
INSERT INTO mfm_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ənggau, kǝ Yesu na anǝ nda, “Yi wu yiwa hyi, mi ngǝ tsaˈa nja mǝl pǝcir Ɓǝlsar ra? Sǝ mǝnahǝu, ǝndǝga sǝ ɗǝmwaˈyu? Nja mbǝɗana, ǝndǝga nja tsǝya?” ");
INSERT INTO mfm_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ji tsamǝ a ndu pama nda patǝu, kǝ ji dzǝgwa na anǝ ndǝ kau, “Ndiɗǝbiya tsa gǝ a dumwa ngau.” Aga zǝmǝ kǝ ji ndiɗǝbiya tsa ja a dumwa nyi, ba tsa ja ɗa jamǝ ǝnggǝr vanyi zǝma nyi ta. ");
INSERT INTO mfm_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ama kǝ huɗa nda ndzǝ gagaɗau, kǝ ndǝ dzǝgwa na anǝ kǝrnda, “Mi nga mǝna sǝni mǝl ǝnga Yesa?” ");
INSERT INTO mfm_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Vanyi pǝci, Yesu hyaˈari ba ji maˈyi a du mau, aga ja da ndǝr ǝnga Hyal a dǝna. Ji da pida ghǝmǝ ja vǝr ndǝr ǝnga Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ənggǝra vi sa kuɗau, kǝ ji nggari zǝmbǝlma nyiˈyar a shili wu dzǝ nyi, kǝ ji dzǝgwa ɗǝmbiya kumo apǝ mǝthlǝ sara wu pama nda, kǝra ji ngga ǝnga cama sǝsǝˈyar. Kǝja thlǝmǝr nda, ");
INSERT INTO mfm_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simanu kǝra ji nǝ nyi thlǝmǝ Biturusu, ǝnga zamǝ nyi Andǝrawusu, ǝnga Yakubu, ǝnga Yahwana, ǝnga Fǝlipǝu, ǝnga Bathlalomiyu, ");
INSERT INTO mfm_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ǝnga Matiwu, ǝnga Toma, ǝnga Yakubu zǝr Alfawusu, ǝnga Simanu ndǝra nju na ndǝ mǝlmǝ nyi, ");
INSERT INTO mfm_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ǝnga Yahuda zǝr Yakubu, ǝnga tsu Yahuda Isikarayoti ndǝra ɗǝlna Yesu anǝ dawa nyiˈyar. ");
INSERT INTO mfm_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ji maˈyi ǝnga zǝmbǝlma nyiˈyar a gyiwu ˈyi, kǝ ndǝ thlǝwa babalǝr vi, ba ndǝ taˈyi ǝna ǝnga zǝmbǝlma nyiˈyar gangǝu, ǝnga nji gangǝ gagaɗau sara wu Yahudi, ǝnga Urshalima, ǝnga ˈyiˈyir Taya ǝnga Sidonu njira ǝnga kir nda a miya dǝl dǝgalǝu, ");
INSERT INTO mfm_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","njira shili aga nda nggar highiɓǝ nyi ǝnga nja shilǝgǝbiya nda sara ara shilǝgǝr nda pamǝpamǝu. Njira ǝnga mambǝl ɗǝmwaˈyiˈyar wu lǝ ɓwaɓwatǝ anǝ nda, nanda tsu ndǝ uya jamǝkur, ");
INSERT INTO mfm_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ǝnga nji gangǝu a vǝr mǝl lagu kǝra nda sǝni tsǝkwar nyi, ara dǝnama kǝra wu biya sara wu dza ja vǝr shilǝgǝbiya nda patǝu. ");
INSERT INTO mfm_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ja vǝr tsamǝ zǝmbǝlma nyiˈyar, kǝ ji na, “Barka anǝ hyi nahyi nji kǝra gǝra sau, tǝlkur Hyal a ɗar nǝr hyi. ");
INSERT INTO mfm_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Barka anǝ hyi njira ǝnga wuɓau kabangǝkau, nju nda nyana hyi. Barka anǝ hyi njira vǝr tiwi kabangǝkau, hyu nda nggushi. ");
INSERT INTO mfm_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Barka anǝ hyi ma nji gǝra yiwu hyi, nda hǝbiya hyi a biya, ǝnga nda nggǝl hyi, ba ǝnga nda ndzana thlǝmǝr hyi, arya Zǝr Ndau.” ");
INSERT INTO mfm_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Abangǝ ngǝ ǝjir nda mǝl anǝ nabiˈyar kǝra tǝrabiya. Ga caguli ǝnga ga nggya ǝnga huɗǝ pǝrtǝu, ara gu nda uya akkǝri gangǝ a dǝmǝlmau.” ");
INSERT INTO mfm_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ama kawa anǝ hyi nahyi bǝrba, arya a dlǝwuri hyi nǝr hyi mǝsahǝkur kabangǝkau. ");
INSERT INTO mfm_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kawa anǝ hyi, nahyi kǝra nyinyau kabangǝkau, hyu nda nggya ǝnga wuɓau. Kawa anǝ hyi nahyi kǝra a vǝr nggushi kabangǝkau, hyu nda ɗa ǝnga huɗǝ ndzǝndzau hya ɓǝra tiwi. ");
INSERT INTO mfm_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kawa anǝ hyi ma nji patǝ a vǝr fal hyi, abangau nga ndǝ mǝl anǝ nabi fatiˈyar.” ");
INSERT INTO mfm_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ama ya nar hyi, nahyi kǝra wu nggari ndǝr ɗa, hya canǝ nyi yiwukur anǝ dawar hyi, hya mǝl mǝnahǝkur anǝ njira gǝra yiwu hyi. ");
INSERT INTO mfm_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Fǝnggǝr nyi barka anǝ njira wu shiˈwa hyi, hya ndǝr anǝ Hyal arya njira wu lǝ ɓwaɓwatǝ anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ma ndǝ nǝ ngǝ dǝgau ari balma gau, shabiya nyi vanyi balma tsu. Ma ndǝ mbǝliya nggamndǝ ngau, ga sara ka lǝgutǝ ha kǝra vuwa gwa anǝ nyi mai. ");
INSERT INTO mfm_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nǝ nyi anǝ kalar ndǝra kǝdi ara gau, ma tsu ndǝ mbǝliya sǝ ngau ga sara yiwa ja shabiya ngǝ a shili mai. ");
INSERT INTO mfm_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Sǝra hyu yiwu nja mǝl anǝ hyi, nahyi tsu ca nga hya mǝl anǝ nda. ");
INSERT INTO mfm_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ma njira vǝr yiwu hyi nga hyu yiwu wacu, wathlǝmǝ culi akkǝri kǝra hyu nda uya? Alaga njir dlǝwu budǝ ma tsu, ndu mǝl abangau. ");
INSERT INTO mfm_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma gu ca mǝnahǝkur anǝ njira wu ca mǝnahǝkur anǝ ngau, mi nga ju cakǝri nga? Əkkǝˈyi njir bikǝ ma ndu mǝl abangau. ");
INSERT INTO mfm_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma gǝ nǝ nyi mǝl anǝ njira gu sǝni ndu nda kina ngau, mi nga ju cakǝri nga? Alaga njir bikǝ ndu lǝ mǝl anǝ njir bikǝ kuvwar nda ǝnga sǝni ndu nda kina patǝu. ");
INSERT INTO mfm_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ama ga ca yiwukur anǝ dawa ngau, ga mǝl mǝnahǝkur anǝ nda, ga nǝ nda mǝl ǝnga sǝni abǝr nandǝ wu nda kina ngǝ mai. Mǝl abangǝ wu mǝliya hyu uya nubwa gangǝu, ǝnga hyu sa ɗa ǝnggǝr wazha Hyal kǝra a dǝmǝlmau, arya naja ǝnga tǝhuɗǝu, anǝ nji kǝra sǝni na usi ǝnga nji ɗǝmwaˈyu. ");
INSERT INTO mfm_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ga nggya ǝnga tǝhuɗǝ ǝnggǝr kǝra dǝngau kǝra a dǝmǝlmau ǝnga tǝhuɗǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“A sara hya thla numa ar kǝra nji mai, nji tsu aˈyi ndu thla numa ar kǝra hyi mai. A sara hya lǝ vazǝ anǝ ndǝ mai, nji tsu ndu nda lǝ vazǝ anǝ hyi mai. Tǝfǝbiya mǝ nji, Hyal tsu ju nda tǝfǝbiya hyi. ");
INSERT INTO mfm_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Hya lǝ sau, nahyi ma ba nja nǝ hyi sau, cala tǝkǝ sǝ nyinyi tsuyu, nja cicina a gya, nja ɓǝra favǝɗiya, ja dzǝgwa pǝpau a gyar dza nyi, nja dzǝgwa puwa ngau a gyar dza gau, arya a ɗar cala tǝkǝ sǝ kǝra hyi tǝkǝ sǝ ǝni anǝ nji, ca nga nju nda tǝkǝ sǝ ǝni anǝ hyi.” ");
INSERT INTO mfm_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kǝ ji ɓǝra nar nda najaka karapau, “Ndǝ lǝfau a sǝni lǝbiya ndǝ lǝfǝ ya? Ma ndǝ mǝl abangau, nanda gyapǝu, aˈyi ndu nda tǝɗau a gyiwu kaˈu wa? ");
INSERT INTO mfm_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ndǝra nju highiɓǝ anǝ nyi, aˈyi ju ndiya malǝmǝ nyi mai, ama kalar ndǝra nji highiɓǝri nyi mǝnahǝu, ju sǝni ɗa ǝnggǝr malǝmǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ara mi nga gu lari zǝr sar kǝra wu liya zamǝ ngau, ama na ga sǝn tsamiya gwalang kǝra ar liya gǝ kǝ maya? ");
INSERT INTO mfm_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Abari nga ga sǝn na anǝ zamǝ ngau, abǝr, zamǝ ɗa, ‘Taˈyau, ya hǝbiya ngǝ zǝr sar kǝra wu liya gau,’ ya, kǝja gwalang ngǝ ar liya ga? Nagǝ ndǝr ngguta vi, ga hǝbiya gwalang kǝra ar liya gǝ kwatahǝu, aga ga daɓaga lari mǝnahǝu, ba ga sǝn hǝbiya zǝr sar kǝra wu liya zamǝ ngǝ kau. ");
INSERT INTO mfm_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Abangǝ tsu, kalar wu mǝnahǝu, ju ya wazha mǝnahǝu, wu kǝra gǝra mǝnahǝ tsu, ju ya wazha kǝra gǝra mǝnahǝu. Wu kǝra mǝnahǝu, a sǝn yabiya wazha kǝra gǝra mǝnahǝ mai, abangǝ tsu, wu kǝra gǝra mǝnahǝu, a sǝn yabiya wazha mǝnahǝ mai. ");
INSERT INTO mfm_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ar yaya nyi nga nju tsamǝ ri wu. Nja sǝni ɗǝm bǝla ar wur shikǝɗi mai, alaga ndǝrma ar hudi mai. ");
INSERT INTO mfm_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ndǝ mǝnahǝu, ju biya ǝnga ndǝr mǝnahǝu sara ar vira ji ɗǝwana ari, ǝnga ndǝ ɗǝmwaˈyu, ju biya ǝnga ndǝr ɗǝmwaˈyu sara ar vira ji ɗǝwana nda ari.” ");
INSERT INTO mfm_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ara mi nga hyu ngga ɗa, ‘Thlagǝu, Thlagǝu,’ ama kǝ hyi nggǝl ara mǝl sǝra yu na anǝ hya? ");
INSERT INTO mfm_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kalar ndǝra shili ara yau, ba ji sǝya himi anǝ sǝra yu na, ǝnga ju mǝl thlǝr ǝni, yu nda nar hyi sǝra ju pa. ");
INSERT INTO mfm_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Naja ǝnggǝr ndǝr hǝr ki, kǝra labiya kaˈu dzǝgamǝ a gyiwu ˈyi, kǝ ji dzǝguya hǝr ǝnga fǝhi hǝr ar pathlara mau. Ənggǝra dǝl nyau, kǝ ˈyimi tsaɓǝri ki ta, ama naja aˈyi sǝni kǝnggǝɗǝr nyi mai arya nji fǝr hiya nyi ar pathlara mau. ");
INSERT INTO mfm_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ama ndǝra wu nggari ndǝr ɗa, ama naja aˈyi wu mǝl thlǝr ǝni mai, kakalǝ nga ja ǝnga ndǝr hǝr ki ar vi kǝra nji gǝra labiya kaˈu nǝ fǝ hiya hǝra nyi. Ənggǝra dǝl nyau, kǝ ˈyimi tsaɓǝri ki kau, kǝ ki kǝ dla, dla nyi tsu ɗǝmwaˈyi gagaɗau.” ");
INSERT INTO mfm_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ənggǝra Yesu kuɗǝna na sǝˈyar kǝ patǝ anǝ nji, ba ji maˈyi a vu Kafarnahumu. ");
INSERT INTO mfm_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","A vuna, kǝ ja vanyi dǝgalǝri soja nǝ Roma kǝra mafa nyi aˈyi gǝra ngga gagaɗau, kǝra a vǝr gal lagur tau. Soja dǝgal nǝ Roma kau, ja vǝr yiwu mafa nyi kǝ gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ənggǝra ji nggar ndǝr ar kǝra Yesu, ba ji sǝwa alenyi nji nggunggurǝm nǝ Yahudiya aga nda kǝdi nyi ja shili, ja sa mbǝɗana mafa nyi kau. ");
INSERT INTO mfm_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nji nggunggurǝmˈyar kǝ maˈyi a ndǝra Yesu ndǝ nda kǝdi nyi gagaɗau, nda vǝr na, “Ndǝ kau, ndǝ mǝnahǝu ngau, kakalǝ nga nyi ga dlǝwari nyi. ");
INSERT INTO mfm_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nda nyi a yiwu ja njir ˈya, ba ǝnga ji hǝriya ˈya umbwa daɓǝ dzau.” ");
INSERT INTO mfm_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ba Yesu maˈyi ǝnga nda. Ənggǝra ji shili lǝhǝu wu dzǝri ki nyi, kǝ dǝgalǝri soja nǝ Roma hyabiya bazhi nyiˈyar aga nda nar nyi anǝ Yesu, “Thlagǝu, ga sara hǝɗana kǝrngau aga yi mai, arya nayi aˈyi ɗa tsaˈa ga shili wu ki ɗa mai. ");
INSERT INTO mfm_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ca ngǝ mǝliya nayi aˈyi sǝni shili ǝgya gǝ mai, ama ga nana ndǝr sǝ nyi, ba zǝr ɗa uya jamǝkur. ");
INSERT INTO mfm_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Arya nayi ǝnga kǝrɗa ma ǝgya ndǝ dǝgal nga yau, ǝnga tsu sojaˈyar aˈyi kǝra ǝgya kiɗa yau, yu na anǝ ndǝ kau, ‘Maˈyi,’ ba ja maˈyi, anǝ vanyi ndǝ tsu yu na ‘Shili,’ ba ja shili. Ma yi na anǝ mafa ɗa, ‘Mǝliya abangau,’ ba ja mǝliya.” ");
INSERT INTO mfm_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ənggǝra Yesu nggar ndǝr kau, ba ɗa sǝ dǝdǝgur anǝ nyi, ji shabiya dzau, ji na, anǝ nji kǝra a vǝr nu nyi, “Ya nar hyi, wu Izirayila nayi sayi uya ndǝra ǝnga mbǝrsa ǝnga dǝnama ǝnggǝr ndǝ kǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ənggǝra njira ji sǝwa kǝ sha shili wu ki, ba ndǝ thlǝwa mafa nǝ dǝgalǝr soja Roma ta a ɗari jamǝu. ");
INSERT INTO mfm_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wu yukuɗa pǝci kushu, kǝ Yesu maˈyi a vu mǝlmǝ kǝra nja ngga ǝnga Nayin, zǝmbǝlma nyiˈyar ǝkkǝˈyi nji gangǝu maˈyi ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ənggǝra ndǝ shili lǝhǝu wu dzǝri miyar gwa nǝ mǝlma nyi, kǝja alenyi nja vǝr sǝbiya ǝnga zǝr tǝtau kǝra naja ngǝ zǝmǝ ara mǝnyi kǝra mǝnyi ya, sal nyi tsu a tǝri. Nji gangǝu, sara wu mǝlmǝ ta, nda vǝr lǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ənggǝra Thlagǝ lari mala kau, ba ji tǝhuɗǝ ǝgya ja, ba ji na anǝ nyi, “Ga sara tiwi mai.” ");
INSERT INTO mfm_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kǝ ji maˈyi ji nda tsǝkwar lǝkagau ndǝ tǝtǝ kau, ba njira vǝr hǝ nyi kǝ taˈyau. Kǝ Yesu na, “Zǝr baduwari, Yu na anǝ ngau hyaˈari!” ");
INSERT INTO mfm_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kǝ ndǝ tǝtǝ kǝ hyaˈari, ba ji nggya gya ji dzǝgwa ndǝr. Ba Yesu dzǝgwa lǝr nyi anǝ mǝnyi. ");
INSERT INTO mfm_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kǝ hivǝr mbari nda patǝu, ba ndǝ fal Hyal, nda vǝr na, “Jiri vanyi nabi dǝgal a shiliri wu pama mǝn, Hyal a shiliri aga ja sa dlǝwari nji gǝ nda.” ");
INSERT INTO mfm_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Sǝ kǝ Yesu mǝliya kǝ tǝtǝlnakǝr wu Yahudi ǝnga ˈyiˈyi kǝra zǝwar nyi. ");
INSERT INTO mfm_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ənggǝra zǝmbǝlmaˈyar nǝ Yahwana ndǝr mǝl Baɓǝtizǝma nar nyi sǝˈyar kǝ patǝu, ba ji nggari mǝthlǝ wu pama nda, ");
INSERT INTO mfm_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ji sǝwa nda a ndǝgya Thlagǝu, aga nda nda yiwar nyi abǝr, “Nagǝ nga vǝr shili kǝ ya, ǝndǝga ˈya fiya li aga vanyi ndǝ ya?” ");
INSERT INTO mfm_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ənggǝra njira nji sǝwa shili ǝgya Yesu, kǝ ndǝ na nǝ nyi, “Yahwana ndǝr mǝl Baɓǝtizǝma ngǝ sǝwa ˈya aga ˈya yiwar ngau, ‘Nagǝ nga vǝr shili kǝ ǝndǝga ˈya fiya li aga vanyi ndǝ ya?’ ” ");
INSERT INTO mfm_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kakalǝ ar pǝci ta, ngǝ Yesu mbǝɗana nji gangǝu kǝra gǝra ngga ǝnga shilǝgǝ pamǝpamǝu, ǝnga njira ǝnga mambǝl ɗǝmwaˈyiˈyar. Yesu mǝliya nji lǝfǝˈyar tsu ndǝ lari sau. ");
INSERT INTO mfm_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kǝ Yesu shaɗǝwa nda, ji na, “Sha mau hya nda nar nyi anǝ Yahwana sǝra hyi lari ǝnga hyi nggari. Nji lǝfǝ wu lar sau, nji kukurɓǝ wu ɓau, njir pibi wu uya jamǝkur, kulangǝˈyar tsu ndu nggar sau, nju hyaˈana nji tǝtau ǝnga nju tǝtǝlna ndǝshigu mǝsahǝ anǝ nji ɗaɗali. ");
INSERT INTO mfm_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Barka anǝ ndǝra gǝra tǝkǝkǝr ǝnga mbǝrsa nyi ar kǝra yau.” ");
INSERT INTO mfm_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ayukuɗa njira Yahwana sǝwa maˈyi, kǝ Yesu dzǝguya ndǝr anǝ nji ar kǝra Yahwana, ji na, “Mi nga hyi gwa tsamǝ a gwar tagǝ ta? Hyi maˈyi a gwa tsamǝ sar dzǝdzǝgamǝu, kǝra yambaɗǝ a vǝr kǝnggǝɗǝ ya? ");
INSERT INTO mfm_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ya, mi nga hyi maˈyi a gwa tsama? Ndǝra har kar mǝnahǝ ya? Awau, njir ha kar mǝmǝnahǝu, wu ki tǝl nga nda. ");
INSERT INTO mfm_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kar ɗǝm ya, mi nga hyi maˈyi a nda tsama? Nabi ya? Pakatu, yu nar hyi, ndǝra ndiya nabi. ");
INSERT INTO mfm_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ar kǝra Yahwana ngǝ ndǝr Hyal kǝra tsǝtsǝfǝ na, “ ‘Kǝja yu sǝwa cama ɗa wu mwa ngau, ju nda fuwa sǝ wu lagu kadivira ga shili.’ ");
INSERT INTO mfm_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Ya nar hyi, wu pama njira mathlǝkǝˈyi ngǝ ya patǝu, ndǝra ndiya Yahwana ǝnga dǝgal aˈyi mai. Ama alaga abangau, ndǝra ndiya ǝnga kushu wu tǝlkur Hyal a ndiya nyi ǝnga dǝgalǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Patǝr njira nggari ndǝr kau, ǝkkǝˈyi njir tsǝm budau, dlǝwunggǝri abǝr lagu Hyal ca ngǝ lagu kǝra kakalǝu, arya Yahwana ngǝ mǝliya nda baɓǝtizǝma. ");
INSERT INTO mfm_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ama njir Farisi ǝnga malǝmǝ sǝnbiya dlaɗǝ Musa ˈyar nggǝl ara dlǝwu sǝra Hyal wu yiwu ǝnga nda, ǝnga ndǝ nggǝl ara Yahwana sara mǝliya nda baɓǝtizǝma. ");
INSERT INTO mfm_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu dumwa ǝnga ndǝr ji na, “Ya, ǝnga mi nga nja gǝla nji kabangǝka? Abari nga nda? ");
INSERT INTO mfm_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nanda ǝnggǝr wazha kǝra a vǝr nggya ar sugu, nda vǝr ngga kuvwar nda, ndu na: “ ‘ˈYa vǝr mbiɗǝ mbǝlau anǝ hyi, kǝ hyi nggǝl ara fǝl, ˈyi thlǝ na nǝ tiwi ba hyi nggǝl ara dlǝwu.’ ");
INSERT INTO mfm_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Yahwana ndǝr mǝl Baɓǝtizǝma shili ja vǝr sǝm sǝr sǝm mai, naja tsu aˈyi a vǝr sa ˈyimi nǝr wur inabi ǝnggǝra nji tsǝliya mai, ‘Ama ǝngwar hyi naja ǝnga mambǝl ɗǝmwaˈyu!’ ");
INSERT INTO mfm_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Zǝr Ndǝ shili ju sǝm, ǝnga ju sa, ǝngwar hyi, ‘Ndǝr suna nga ja, bazhiya njir tsǝm budau ǝnga njir bikau!’ ");
INSERT INTO mfm_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Alaga abangau, patǝr njira hǝnggǝri ǝnga hahangǝkur nǝ Hyal, nda vǝr cabiya abǝr ǝnga jiri nga nyi.” ");
INSERT INTO mfm_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Vanyi ndǝr Farisi nggari Yesu a nda sǝm sǝr sǝm a ndu ki nyi, ba Yesu nda, ji nda nggya aga sǝm sǝr sǝm. ");
INSERT INTO mfm_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Wu mǝlmǝ kau, vanyi mala aˈyi ja vǝr mǝl zawarkur, kǝ ji nggari abǝr Yesu a vǝr sǝm sǝr sǝm wu ki ndǝr Farisi kau, kǝ ji shili ǝnga vanyi bǝlari kushu kǝra ǝnga mal kǝra wu shuni kisǝu, kǝra nju ɗǝl ǝnga kwaɓa gangǝu. ");
INSERT INTO mfm_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ji shili kǝ ji sa taˈyi wu yukuɗa Yesu, ar dza hiya ja, ja vǝr tiwi. Ta sǝlǝm nyi pau a gyar hiya ja, ba ji dzǝgwa kǝkǝɗǝna hiya ja ǝnga shishir kǝra ja, kǝ ji dzǝgwa dumwa ǝnga bǝrpǝ nyi nǝ yiwukur, ba ji ɓǝsiya nda ǝnga mal shuni mǝsahǝu kau. ");
INSERT INTO mfm_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ənggǝra ndǝr Farisi kǝ wu tsamǝ sǝra mala ka a vǝr mǝl kau, kǝ ji na wu ɗǝfuwa ja, “Maja abǝr ndǝ kǝ nabi ngau, a kyaga sǝni ja tara wa ngǝ mala ka a vǝr tsukwa nyi kau. Ja kyaga sǝni abǝr mala kǝ ndǝr bikǝ ngau.” ");
INSERT INTO mfm_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu na anǝ ndǝr Farisi kau, “Simanu, aˈyi yi ǝnga sǝr na anǝ ngau.” Kǝ Simanu na, “Nar ɗa, malǝmǝ.” ");
INSERT INTO mfm_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu na, “Vanyi ndu nu nji mǝthlǝ mǝl, ndǝ pathlǝu, gǝnna kǝra nja kyaga ki ndǝr mǝl thlǝr ǝni wu pǝkau, nǝ fa pathlǝ ǝnga reta, ndǝ mǝthlǝkura nyi tsu, gǝnna nǝ pǝkǝ nǝ ndǝr mǝl thlǝr kǝra ja kyaga uya wu pida tǝfu kumunyi. ");
INSERT INTO mfm_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ənggǝra ndǝ tini kina, ba ji yafǝna nda gyapǝu. Ya, wu tsamǝ ngau, wa nga kyaga ndiya ǝnga yiwu nyi wu pama nda?” ");
INSERT INTO mfm_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simanu na anǝ nyi, “Wu lari ɗa, ndǝ kǝ nji yafǝna nyi gǝnna gangǝ kau.” Ba Yesu na anǝ nyi, “Ənghǝng, a nabiyar gǝ kakalǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kǝ ji shabiya dzǝ ji tsamǝ mala ta, ba ji na anǝ Simanu, “A lari gǝ mala kǝ ya? Yi shili wu ki ngau, nagǝ aˈyi nǝ ɗa ˈyimi aga ya cina hiya yi ǝni mai, ama kǝ ji cina hiya yi ǝnga sǝlǝm nyi, ji kǝkǝɗǝna ǝnga shishir kǝra ja. ");
INSERT INTO mfm_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nagǝ dlǝwuri ɗa ǝnga bǝrpǝ dzǝ mai, ama ǝnggǝra ji shili wu ki kau, naja aˈyi taˈyi ǝnga bǝrpǝ hiya yi ǝnga miya ja mai. ");
INSERT INTO mfm_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nagǝ aˈyi ɓǝsiya mal ar kǝra yi mai, ama kǝ ji ɓǝsiya mal shuni kisǝ kau, ar hiya yau. ");
INSERT INTO mfm_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Agabangau, ya nar ngau, bikǝ nyi kǝra gangǝ kau, a tǝfǝbiya nyir nji arya ji cabiya yiwukur gangǝ gagaɗau. Ama ndǝra nji tǝfǝbiya nyi bikǝ kushu, yiwukur nyi kushu nga nyi tsu.” ");
INSERT INTO mfm_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Əngwar Yesu anǝ mala kau, “A tǝfǝbiya ǝnggǝr nji bikǝ ngau.” ");
INSERT INTO mfm_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Njira a vǝr sǝm sǝr sǝm ǝnga ja ar vi kau, dzǝgwa na anǝ kuvwar nda, “Wa ngǝ ndǝ kǝ a sǝni tǝfǝbiya bikǝ ka?” ");
INSERT INTO mfm_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Əngwar Yesu anǝ mala ta, “Mbǝrsa ngau, a mbǝɗana ngǝ ri, maˈyi sǝ ǝnga huɗǝ pǝrtǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","A sǝkari kushu, Yesu a vǝr ɓau a ndu mǝlmǝ dǝdǝgal ǝnga mǝlmǝ kukushu ja vǝr tǝtǝlna ndǝr mǝsahǝ nǝ tǝlkur Hyal. Zǝmbǝlma nyiˈyar kumo apǝ mǝthlǝ aˈyi nda ǝnga ja, ");
INSERT INTO mfm_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ǝnga alenyi mathlǝkǝˈyi kǝra nji kǝdlǝbiya mambǝl ɗǝmwaˈyi sara wu dza nda ǝnga njira ji shilǝgǝbiya nda. Wu pama nda mala aˈyi kǝra nja ngga ǝnga Maryamu Magǝdaliya kǝra mambǝl ɗǝmwaˈyi pamǝpamǝ mǝɗǝfǝ biya sara wu dza ja, ");
INSERT INTO mfm_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ǝnga Yuwana mala Kuza, ndǝ dǝgal wu ki Hirudusu ǝnga Suzana, ǝnga alenyi mathlǝkǝˈyi gangǝu kǝra a vǝr mǝl thlǝr anǝ nda ǝnga gǝnnar nda. ");
INSERT INTO mfm_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ənggǝra nji gangǝ sara wu mǝlmǝ pamǝpamǝ tsǝmiya dzau, aga nda nggari Yesu, kǝ ji nar nda najaka karapau. ");
INSERT INTO mfm_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ndǝr zǝwa aˈyi kǝra maˈyi a gwa thlǝka culi a gwar fa nyi. Ja vǝr uci culi kǝ alenyi tǝɗau ar lagu, kǝ nji cicina nda ǝnga hyi, ba ˈyagǝˈyar tsu sǝmku nda. ");
INSERT INTO mfm_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Alenyi culi tǝɗau a gyar vi kǝra mǝmau, ǝnggǝra ndǝ tsau, ba ndǝ ul ara lǝsǝ aˈyi ar vi ta mai. ");
INSERT INTO mfm_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kǝ alenyi tǝɗau, a gyiwu pama shikǝɗi, ndǝ hǝ ǝnga nda, ba shikǝɗi kar nda ara pǝli. ");
INSERT INTO mfm_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Alenyi culi tsu tǝɗau, a gyiwu ˈyi kǝra mǝnahǝu, ndǝ hau, ba ndǝ puwa li gangǝ gagaɗau.” Ənggǝra Yesu kuɗǝna ndǝr kau, ba ji hyaˈana ɗahǝu, ji na abǝr, “Ndǝra ǝnga himi ngga sau, bǝgǝ ja nggari.” ");
INSERT INTO mfm_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Zǝmbǝlma nyiˈyar yiwa nyi tara mi ngǝ najaka karapǝ cabiya. ");
INSERT INTO mfm_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ji na, “A yiwur nji hya sǝnbiya sǝra ɗǝɗǝwa nǝ tǝlkur Hyal, ama anǝ alenyi nji, yu ndǝr ǝnga karapǝ anǝ nda, aga, “ ‘Alaga ndu tsamǝ ama nanda wu lari mai, alaga ndu ngga ama nanda wu nggabiya mai.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Kǝja sǝra karapǝ kǝ cabiya. Culi ca ngǝ ndǝr Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kǝra tǝɗau ar lagu ca ngǝ cabiya nji kǝra wu nggar ndǝr Hyal, ama ba Shatan a shili ja sa hǝbiya ndǝr kǝ sara wu ɗǝfuwa nda ara nda sara mbǝrsa nda uya mbǝɗau. ");
INSERT INTO mfm_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Culi kǝra tǝɗau a gyar vir mǝmau, nanda ǝnggǝr njira wu nggar ndǝr kau, ndu dlǝwuri ǝnga huɗǝ pǝrtǝu ama nanda aˈyi ǝnga nggilang mai, ndǝ mbǝrsa nǝ pǝci kushu, ǝnggǝra ɓwaɓwatǝ shili, ba ndǝ piyari nu. ");
INSERT INTO mfm_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Culi kǝra tǝɗau a gyiwu shikǝɗi, ca ngǝ cabiya njira nggari, ama ǝnggǝra ndǝ dumwa ǝnga nu, kǝ ɗǝnga nǝr sǝr duniya, ǝnga gal gǝnna, ǝnga yiwu mǝsahǝkur kar nda ara pǝli. ");
INSERT INTO mfm_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Culi kǝra tǝɗau, a gyar ˈyiˈyi mǝnahǝu ca ngǝ njira nggari ndǝr kau, ndǝ dlǝwuri ǝnga huɗǝ zǝmǝ ndǝ sǝɓiya ndǝ sǝsǝˈwuri kǝl ta ndǝ piya wazha.” ");
INSERT INTO mfm_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Nja sǝn mbǝbiya pitǝlla ba nja mbuya ǝgya kiɗa tǝm ǝnga tǝmbǝl mai. Ama nja kyaga fiya a dar madzigam, ba ja dzǝgwa mbǝl anǝ kalar ndǝ kǝra a vu ki kau. ");
INSERT INTO mfm_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Arya kalar sǝ aˈyi kǝra ndu mǝl ɗǝɗǝwa kǝra gǝra nda biyar babal mai, ǝtsu sǝ aˈyi ɗǝɗǝwa kǝra nji gǝra nda sǝn mai. ");
INSERT INTO mfm_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Hya nggya ǝnga hangǝkal ǝnga sǝra hyu ngga, ara ndǝra ǝnga sau, nju nda sa cakǝri nyi, ama ndǝra gǝra ǝnga sau, sǝra ji nggani aˈyi ara ja kau, nju sa dlǝwuri.” ");
INSERT INTO mfm_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ənggau, miya Yesu ǝnga zamǝ nyiˈyar maˈyi a ndǝgya ja, ama nandǝ uya ndǝ thlǝwa nyi mai, ara gangǝkura nji. ");
INSERT INTO mfm_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kǝ vanyi ndǝ nar nyi anǝ Yesu, abǝr, “Kǝja mǝngau ǝnga zamǝ ngǝˈyar a biya ndu yiwu nda ndǝr ǝnga gau.” ");
INSERT INTO mfm_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Əngwar Yesu anǝ njira a ndǝ patǝu, “Njira wu nggar ndǝr Hyal, ba ndǝ mǝl thlǝr ǝni, nanda ngǝ maɗa ǝnga zamǝɗaˈyar.” ");
INSERT INTO mfm_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Vanyi pǝci Yesu ǝnga zǝmbǝlma nyiˈyar gwu kwambwal, ba ji na anǝ nda, “Mǝna maˈyi a biyar ya dǝl.” Kǝ ndǝ mbar lagu ndu maˈyi. ");
INSERT INTO mfm_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ənggǝra nda vǝr maˈyi ba ji ghanyi. Kukuthlǝu, kǝ majigwal shili ǝnga dǝnama ja vǝr sǝ a shili ar ˈyimi, ǝnggau, ba ndǝ ɗa tǝtǝwulu ara ǝnggǝra ˈyimi gwu kwambwalǝr nda. ");
INSERT INTO mfm_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Zǝmbǝlma nyiˈyar, hyabiya Yesu wu ghanyi, ndǝ na, “Thlagǝr ki! Thlagǝr ki! Kǝja mǝna sa!” Yesu hyaˈari kǝ ji kughiya majigwal ǝnga ˈyimi kǝra a vǝr thlǝkau, ba ndǝ bǝgǝ zǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kǝ ji na anǝ zǝmbǝlma nyiˈyar, “Əmani ngǝ mbǝrsar hya?” Kǝ hivǝr mbar nda gagaɗau, ndǝ na wu pama nda, “Wathlǝmǝ culi najaka nda? Patǝ ǝkkǝˈyi majigwal ǝnga dǝl wu gǝnggǝr nyi sǝli ka?” ");
INSERT INTO mfm_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu ǝnga zǝmbǝlma nyiˈyar nda vǝr maˈyi wu kwambwal ar ˈyimi, ba ndǝ dla wu ˈyiˈyi nǝ Garasina, kǝra a biyar ya dǝl Galili. ");
INSERT INTO mfm_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ənggǝra Yesu a vǝr gya sara du kwambwal, kǝ ji thlǝwa ndǝr mǝlmǝ kǝ kǝra ǝnga mambǝl ɗǝmwaˈyu. Ndǝ kǝ a ɓǝliyar ja sar ja vǝr ɓǝ turusu, ǝnga naji wu nggya wu ki mai, kǝl wu hulili nga ju nggya cumu. ");
INSERT INTO mfm_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ənggǝra ji lari Yesu, ba ji hyaˈana ɗahǝ ǝnga dǝnama, ba ji dla wu mwa nyi ju wau ju na, “Yesu zǝr Hyal Kǝra Di, mi dzau ngǝ ǝnga ˈya? Ya vǝr kǝdi ngau, ga sara nǝ ɗa ɓwaɓwatǝ mai!” ");
INSERT INTO mfm_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ji na abangau, ara Yesu a kughi ri anǝ mambǝl kau, aga nda biya sara wu ja. Arya pǝci gangǝ mambǝl ɗǝmwaˈyi kǝ wu mbilna nyi a gyiwu ˈyi. Vanyi pǝci nju mbar nyi ar gangǝ ama ba ja thlǝthlǝna ganga nyi, ǝkkǝˈyi ja sǝwa nyi a gwa tagǝu. ");
INSERT INTO mfm_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu yiwar nyi, “Wa thlǝmǝ nga?” Kǝ ji na, “Dlami,” ara mambǝl ɗǝmwaˈyi kǝ gangǝ nga nda wu ja. ");
INSERT INTO mfm_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kǝ ndǝ kǝdi nyi ar kǝr ar kǝr a sara ja kǝdlǝbiya nda a gyiwu kaˈu gǝra kuɗǝ mai. ");
INSERT INTO mfm_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Lǝhǝ a dzǝr vi ta, ɓǝla fǝshiu aˈyi gangǝu kǝra a vǝr ɓǝla ar dza mau. Mambǝl ɗǝmwaˈyiˈyar kǝ kǝdi Yesu, “Sǝwa ˈya a ndu fǝshiˈyar kau, piyar ˈya aga ˈya gwu nda.” Ji piyari nda, kǝ mambǝl ɗǝmwaˈyiˈyar kǝ biya ndǝ gwu fǝshiu. ");
INSERT INTO mfm_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ɓǝla fǝshiu kǝ a kar nda dubu mǝthlǝu, ndǝ hyaˈari ǝnga hwi a gwar dǝl a guna kǝ ˈyimi kuɗǝna nda patǝu. ");
INSERT INTO mfm_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ənggǝra njir ɓǝla fǝshiˈyar lari sǝra ɗarkǝr, ba ndǝ maˈyi ǝnga hwi a vu mǝlmǝ dǝdǝgal ǝnga kukusha nyi aga nda vuwa nar nyi anǝ nji. ");
INSERT INTO mfm_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kǝ nji kǝ biya aga nda biya lari sǝ kǝ ɗa kau. Ənggǝra ndǝ thlǝwa vi kǝra Yesu ari, ba ndǝ lari ndǝ ta mambǝl ɗǝmwaˈyi biya sara wu dza ja vǝr nggya lǝhǝ wu dzǝr Yesu, ǝnga lǝgutǝ ar dza ja wu hangǝkal nyi. Kǝ hivǝr mbari nda papatǝu. ");
INSERT INTO mfm_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Njira aˈyi ar vi ta pǝci kǝra sǝ kǝ ɗa wu liya nda, dumwa ǝnga na anǝ nji ǝnggǝra ndǝ kǝ uya jamǝkur. ");
INSERT INTO mfm_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ənggau, patǝr njira wu ˈyiˈyir Garasina kǝdi Yesu aga ja piyari mǝlmǝr nda ara hivǝr a mbar ndari gagaɗau. Kǝ Yesu gwu kwambwala nyi, ba ji maˈyi sǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kǝ ndǝ kǝ nji kǝdlǝbiya mambǝl ɗǝmwaˈyu, sara wu dza ja kǝ kǝdi Yesu, ji na, “Usi piyari ɗa ma maˈyi ǝnga gau, aga ya ɗa ndǝr nu ngau.” Ama kǝ Yesu nggǝl, ji na anǝ nyi, ");
INSERT INTO mfm_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Sha a ndu ki, ga nda nar nda sǝ kǝ Hyal mǝliya ngǝ kau.” Kǝ ndǝ kǝ maˈyi a vu huɗa mǝlmau, ja vǝr na anǝ nji sǝra Yesu mǝliya nyi. ");
INSERT INTO mfm_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ənggǝra Yesu sha shili sara ndǝna, kǝ nji gangǝ shili ndǝ dlǝwuri nyi, ara nda vǝr sǝkǝ shili nyi. ");
INSERT INTO mfm_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kǝja vanyi ndǝ thlǝmǝ nyi Yayirusu, naja ndǝ dǝgal wu umbwa daɓǝ dzǝ njir Yahudiya, ji shili ji sa ɓǝliya undi wu mwar Yesu, ja vǝr kǝdi nyi aga ja shili wu ki nyi, ");
INSERT INTO mfm_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","arya kwa nyi kǝra zǝmǝu, zǝr fa kumo apǝ mǝthlǝu, a lagur tau. Ənggǝra Yesu mbar lagu, nji gangǝ a vǝr nu nyi ndu ciɗǝ nyi lagu mazǝm ǝnga lagu matsal. ");
INSERT INTO mfm_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Vanyi mala aˈyi a ndǝna kǝra mǝliya fa kumo apǝ mǝthlǝu, ja vǝr ndzǝndzǝ mashi. Mala kǝ a lari ɓwaɓwatǝ ǝnga jirkur wu tsa njir kundzǝgǝ pamǝpamǝ gangǝu, ama kǝra aˈyi dlǝwari nyi mai. ");
INSERT INTO mfm_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ji shili wu pama nju yukuɗa Yesu, kǝ ji sa tsǝkwar miya lǝgutǝ nyi, ǝnggau, ba ndzǝndzǝ mashi kǝ taˈyau. ");
INSERT INTO mfm_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Əngwar Yesu, “Wa ngǝ tsǝkwar ɗa ka?” Kalar ndu na, “Nayi ngǝ mai.” Kǝ Biturusu na, “Malǝmǝ dǝgal, nji gangǝ ngǝ zǝwar ngǝ nda vǝr jajahǝ ngau.” ");
INSERT INTO mfm_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ama kǝ Yesu na anǝ nyi, “Vanyi ndǝ a tsǝkwar ɗa ri, arya dǝnama a biyari sara wu dza yau.” ");
INSERT INTO mfm_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ənggǝra mala kǝ lari naja sǝn ɗǝwanakǝr mai, kǝ ji sha shili ja vǝr tsǝdzau, ji ɓǝliya undi a gyiwu mwar Yesu. Kǝ ji nar nyi wu mwar nji patǝu, sǝra ɗa ji tsǝkwar nyi, ǝnga ǝnggǝra ji uya jamǝkur aga zǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kǝ ji na anǝ nyi, “Kwa ɗa, mbǝrsa ngau, a mǝliya ngǝ ri jamǝu, maˈyi wu jamǝkur.” ");
INSERT INTO mfm_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tsu ja gǝra kuɗǝna ndǝr, kǝja cama sara wu ki Yayirusu ndǝr ɓǝla umbwa daɓǝ dzǝ njir Yahudiya, a shiliri, ja vǝr na anǝ Yayirusu, abǝr, “A sara ga ɓǝra nǝ nyi ɓwaɓwatǝ anǝ malǝmǝ mai, arya kwa ngǝ a tǝri.” ");
INSERT INTO mfm_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ənggǝra Yesu nggari ndǝr kau, kǝ ji na anǝ Yayirusu, “Ga sara hivǝr mai, ga mbǝrsa wacu ju hyaˈari.” ");
INSERT INTO mfm_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ənggǝra ndǝ shili wu ki nyi, naja aˈyi piyari nja vu ki ǝnga ja mai, kǝl Biturusu ǝnga Yahwana ǝnga Yakubu ba dǝya kwa ǝnga mǝnyi. ");
INSERT INTO mfm_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Patǝkura njira a vu ki kau, kǝl tiwi nga nda vǝr tiwi, nda vǝr wau wu dǝrbǝ kwa nyi. Kǝ Yesu na anǝ nda, “Hya sara tiwi mai, kwa kǝ naji tǝ mai, ghanyi nga ja a gwa!” ");
INSERT INTO mfm_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kǝ ndǝ nggushi nǝ diɗa ndau, ara ndu sǝni abǝr kwa nyi a tǝri. ");
INSERT INTO mfm_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesu mbari tsa ja ji hyaˈana ɗahǝu, ji na, “Zǝr kwa, hyaˈari!” ");
INSERT INTO mfm_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kǝ piya ja ɓǝra sha shili wu ja, kǝ ji hyaˈari jamǝu, kǝ Yesu nar nda, nǝ nya mǝ sǝr sǝm. ");
INSERT INTO mfm_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kǝ njir ya nyi mbari miya nda, nda vǝr tsamǝ sǝ dǝdǝgur, ama kǝ Yesu tǝɗar himiya nda abǝr nda sara na sǝ kǝ ɗa kǝ anǝ nji mai. ");
INSERT INTO mfm_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ayukuɗa Yesu nggar zǝmbǝlma nyiˈyar kumo apǝ mǝthlǝ a shili ar vi zǝmǝu, kǝ ji nǝ nda dǝnama nǝr kǝdlǝ mambǝl ɗǝmwaˈyiˈyar ǝnga tsu nda shilǝgǝbiya njira gǝra ngga, ");
INSERT INTO mfm_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ǝnga ji hyabiya nda, aga nda maˈyi nda nda tǝtǝlna ndǝr mǝsahǝu ar kǝra tǝlkur Hyal ǝnga shilǝgǝbiya nji gǝra ngga. ");
INSERT INTO mfm_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ji na anǝ nda, “Hya sara hǝ sǝ aga ɓǝ kǝ mai, hya sara sǝɓǝ alaga zǝwa mai, alaga mbǝl, alaga sǝr sǝm, alaga kwaɓa mai. Ətsu hya sara hǝ alaga lǝgutǝ a ndiya kǝra ar dza hyi mai. ");
INSERT INTO mfm_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Wu kalar ki kǝra nji dlǝwuri hyi a gwa, hya nggya ǝna baˈanǝ pǝci kǝra hyu nda piyari mǝlmǝ kau. ");
INSERT INTO mfm_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kalar vi kǝra nji nggǝl ara dlǝwu hyi, ma hyu biya hyu maˈyi, hya dlǝɗǝna bǝbǝr kǝra ar hya hyi, aga ja ɗa sǝr sakida ar kǝra nda.” ");
INSERT INTO mfm_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kǝ ndǝ hyaˈari ndǝ maˈyi a ndu mǝlmǝ pamǝpamǝ nda vǝr tǝtǝlna ndǝr mǝsahǝu, nda vǝr shilǝgǝbiya njira ǝnga shilǝgǝ pamǝpamǝˈyar ar kalar vi. ");
INSERT INTO mfm_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ənggǝra Hirudusu ndǝr sǝm tǝlkur ar kǝra Galili nggari sǝra a vǝr ɗa, kǝ ji gwu ɗǝnga sǝ gagaɗau, ara alenyi nji na, abǝr, Yahwana ndǝr mǝl Baɓǝtizǝma ngǝ hyaˈari sara vir tau. ");
INSERT INTO mfm_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Alenyi nja vǝr na, abǝr, nabi Iliya ngǝ ɓǝra sha shili. Alenyi nji tsu a vǝr na, abǝr, zǝma nabi nǝ ɗǝɗǝmǝ ngǝ ɓǝra hyaˈari. ");
INSERT INTO mfm_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kǝ Hirudusu na, “Yahwana, nǝ nyi, a sǝwa ri yi nja thlana kǝra ja, kar wa ngǝ ndǝ kǝ yu nggari sǝ pamǝpamǝ ar kǝra ja ka?” Kǝ ji dzǝgwa mǝl ǝnggǝra ja sǝni lari nyi. ");
INSERT INTO mfm_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ənggǝra cama sǝsǝ nyiˈyar kǝ sha shili, kǝ ndǝ nar nyi anǝ Yesu sǝra ndǝ mǝliya patǝu. Kǝ Yesu hǝr nda, nanda zhizhir nda ndǝ maˈyi a ndu vanyi mǝlmǝ nja ngga ǝnga Bethlesaida. ");
INSERT INTO mfm_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ənggǝra nji nggari abǝr a ndǝna nga ja, kǝ ndǝ nu nyi a ndǝna. Ji dlǝwuri nda ǝnga huɗǝ zǝmǝu, ji dzǝgwa ndǝr anǝ nda ar kǝra tǝlkur Hyal, kǝ ji shilǝgǝbiya njira gǝra ngga. ");
INSERT INTO mfm_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ma lǝhǝ pǝci wu gya tǝɗau, kǝ nanda kumo apǝ mǝthlǝ kǝ shili ara ja ndǝ na, “Ara nji aˈyi ar vi kǝ mai, nar nda, nda maˈyi a ndu mǝlmǝ pamǝpamǝ aga nda uya sǝr sǝm ǝnga vir pida.” ");
INSERT INTO mfm_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ama, kǝ Yesu na anǝ nda, “Nahyi, nǝr nda mǝ sǝra nda sǝmku.” Kǝ ndǝ na anǝ nyi, “Patǝr sǝra aˈyi a ndiya lugu ɗǝfǝ tǝfu ǝnga kalfi mǝthlǝ mai. Kǝl naˈya nga maˈyi ˈya nda ɗǝlbiya sǝr sǝm anǝ nji kǝ patǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Arya shili zhizhir nda ma a kar nda dubu tǝfu. Yesu na anǝ zǝmbǝlma nyiˈyar, “Nar nyi anǝ nji kǝ nda nggya gya wu bwata tǝfu kumunyi tǝfu kumunyi.” ");
INSERT INTO mfm_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kǝ zǝmbǝlma nyiˈyar mǝliya ǝnggǝra ji na, ndǝ mǝliya nji kǝ nggya gya. ");
INSERT INTO mfm_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ənggau, kǝ Yesu hǝri lugu ɗǝfǝ tǝfu ǝnga kalfi mǝthlǝ ta, kǝ ji hyaˈanakǝr a dǝmǝlmau, ji usar Hyal, ji dzǝgwa kakadlǝwa nda, kǝ ji nǝ nyi anǝ zǝmbǝlma nyiˈyar, aga nda tǝtǝkǝna anǝ nji patǝu. ");
INSERT INTO mfm_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Patǝkura nda sǝm ndǝ nyau. Kǝ zǝmbǝlma nyiˈyar tsǝmiya tsǝla kumo apǝ mǝthlǝ ǝnga sǝra hiyau sara wu miya nda. ");
INSERT INTO mfm_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Vanyi pǝci Yesu ja vǝr ndǝr ǝnga Hyal zhizhi nyi, kǝ zǝmbǝlma nyiˈyar shili ǝgya ja. Kǝ ji yiwa nda ji na, “Wa nga nju na ǝnga ya?” ");
INSERT INTO mfm_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kǝ zǝmbǝlma nyiˈyar na, “Alenyi nju na abǝr, nagǝ ngǝ Yahwana ndǝr mǝl Baɓǝtizǝma, ǝngwar alenyi nji nagǝ ngǝ nabi Iliya. Abangǝ tsu, alenyi nja vǝr na, abǝr, pathlǝu, wu pama nabi ɗǝɗǝmˈyar ta ngǝ ɓǝra sha shili ǝnga pi.” ");
INSERT INTO mfm_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kǝ Yesu na anǝ nda, “Ama anǝ hyi tsu, wa nga ya?” Kǝ Biturusu na, “Nagǝ ngǝ Kǝrsiti nǝ Hyal.” ");
INSERT INTO mfm_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ənggau, kǝ Yesu tǝɗar himiya nda abǝr nda sara na sǝ kǝ anǝ kalar ndǝ mai. ");
INSERT INTO mfm_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kǝ ji ɓǝra nar nda, abǝr, “A ɗar tsaˈa zǝr nda lar ɓwaɓwatǝ pamǝpamǝu. Nji nggunggurǝm nǝ mǝlmau, ǝnga pubu dǝdǝgalˈyar, ǝnga malǝmǝ dlaɗǝˈyar wu nda piyari nyi, ba nda tsǝya nyi, ama ayukuɗa pida makǝru, ba ji hyaˈari sara vir tau.” ");
INSERT INTO mfm_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kǝ ji dzǝgwa nar nda patǝu, “Kalar ndǝra wu yiwu ja nu ɗa, kǝl ja piyari yiwu kǝrnyi, ba ja hǝri wu dladlakǝ nyi kalar pǝci, ba ja nu ɗa. ");
INSERT INTO mfm_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kalar ndǝra wu yiwu piya ja, ju nda tini. Ndǝra gǝra yiwu piya ja arya yau, ju nda uya. ");
INSERT INTO mfm_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mi ngǝ nubwa kǝra ndu uya, ma ji uya duniya patǝ ama kǝ ji tini piya ja? Sǝ aˈyi mai! ");
INSERT INTO mfm_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ma ndǝra sǝli ɗa sakida ɗa ǝnga ndǝr ɗa, Zǝr Ndu nda sa sǝli ara ja, ar pǝci kǝra ju shili wu kadakadarkur nyi, ǝnga dǝgalkur nǝ dǝnyi, ǝnga nǝ waladiˈyar kǝra cicau. ");
INSERT INTO mfm_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yu nar hyi jirkura nyi, alenyi nji aˈyi ǝnggau tataˈyu, nandu nda tǝ mai, kǝl ndǝ lari tǝlkur Hyal.” ");
INSERT INTO mfm_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ayukuɗa pida cisu, ǝnggǝra Yesu nana ndǝr kau, kǝ ji nggari Biturusu, ǝnga Yahwana, ǝnga Yakubu, ba ndǝ maˈyi a dar kǝra mau aga da ndǝr ǝnga Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ənggǝra ja vǝr ndǝr ǝnga Hyal, kǝ nggyar bama ja bǝlar dzau, ǝnga lǝgutǝ ha nyi ɗa pǝrtǝ pwahǝu ja sǝm ndu li. ");
INSERT INTO mfm_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kukuthlǝu, kǝja nji mǝthlǝu, a vǝr ndǝr ǝnga ja. Nji mǝthlǝ kǝ nanda ngǝ nabi Musa ǝnga nabi Iliya. ");
INSERT INTO mfm_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ndǝ dla wu kadakadarkur, nda vǝr ndǝr ǝnga Yesu ǝnggǝra ju nda nyabiya sǝra Hyal na ar kǝra tǝ nyi a vu Urshalima. ");
INSERT INTO mfm_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Biturusu ǝnga bazhi ɓǝ nyiˈyar wu ghanyi nga nda. Ənggǝra ndǝ hyaˈari wu ghanyi kǝ ndǝ lar kadakadarkur nǝ Yesu ǝnga nji mǝthlǝ kǝra ǝnga ja kau. ");
INSERT INTO mfm_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ənggǝra nji mǝthlǝ kǝ wu piyari Yesu, Biturusu na anǝ Yesu, “Tarki, shilir mǝn ǝnggǝ kau, a ɗar mǝnahǝu. Ma gu yiwu, ya sǝn mǝliya kwapatǝ makǝr ǝnggau, pathlǝ anǝ ngau, pathlǝ anǝ Musa ǝnga pathlǝ anǝ Iliya.” Ara ju sǝni sǝra ja vǝr na mai. ");
INSERT INTO mfm_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tsu ja gǝra haɗiya miya ja, kǝ dlama haɗiya nda. Ənggǝra dlama haɗiya nda, kǝ hivǝr mbari zǝmbǝlma nyiˈyar. ");
INSERT INTO mfm_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ənggau, kǝ ɗahǝ hyaˈari sara du dlama ja vǝr na, “Najakǝ Zǝr ɗa ngau, nayi ngǝ caɗǝbiya nyi. Hya sǝya nyi himi.” ");
INSERT INTO mfm_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ənggǝra ɗahǝ kǝ bǝgau, ba nji lari Yesu zhizhi nyi. Zǝmbǝlma nyiˈyar dzǝgwa haɗiya miya nda zǝmǝu. Wu pidaˈyar kau, nandǝ nar nyi anǝ nji sǝ kǝ ndǝ lari kǝ mai. ");
INSERT INTO mfm_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ənggǝra vi sa kuɗau, Yesu ǝnga zǝmbǝlma nyiˈyar makǝr kǝ shida sara dar mǝ ta. Ənggau, kǝ daɓǝr dlamir nji gangǝ thlǝwa nda. ");
INSERT INTO mfm_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kǝ ndǝ pathlǝu, wu daɓǝ dlamir nji kǝ ngga ǝnga ɗahǝ dǝgal, ji na, “Malǝmǝ! Yu kǝdi ngau, dlǝwar zǝr ɗa kau, naja ngǝ zǝr zǝmǝ ara yi wacu! ");
INSERT INTO mfm_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kǝja, mambǝl ɗǝmwaˈyi nga vǝr ɓwanǝ nyi kǝr, ju sǝni mǝliya nyi ja wau dǝdǝgal gǝra vanyi sǝ uya nyi. Mambǝl kǝ a sǝni mbilna nyi a gyiwu ˈyi ja tsǝdzau ja dzǝgwa pǝ mubo wu miya ja. Naja aˈyi wu piyari nyi mai, kǝl ji uya nyi ǝnga shilǝgǝ gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yi kǝdi zǝmbǝlma ngǝˈyar aga nda kǝdlǝbiya nyi a biya, ama nandǝ sǝni mbari mai.” ");
INSERT INTO mfm_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kǝ Yesu shaɗǝwa nda, ji na, “Nahyi nji kabangǝkau, nji gǝra mbǝrsa, nji ɗǝmwaˈyu, baˈanuwa nga ya nggya ǝnga hya? Baˈanuwa nga ya sǝsu hya? Shila mau ǝnga zǝra nyi anǝ ɗa.” ");
INSERT INTO mfm_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ənggǝra zǝr kǝ a vǝr shili, kǝ mambǝl kǝ mbilna nyi a gyiwu ˈyi, ja vǝr tsǝdzau ǝnga dǝnama. Kǝ Yesu kughiya mambǝl kau, ba ji mǝliya zǝra nyi jamǝu, ba ji dzǝgwa nǝ nyi zǝra nyi anǝ dǝnyi. ");
INSERT INTO mfm_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Patǝkura njira ar vi ta mbari miya nda, nda vǝr tsamǝ sǝ dǝdǝgur nǝ Hyal. Tsu nja vǝr tsamǝ sǝ dǝdǝgur kǝra Yesu a vǝr mǝl kau, kǝ ji na anǝ zǝmbǝlma nyiˈyar, ");
INSERT INTO mfm_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Hya sǝya himi hya nggar sǝra yu nda na anǝ hyi kau. Nju nda lǝr Zǝr Ndau, anǝ dawa nyiˈyar.” ");
INSERT INTO mfm_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ama zǝmbǝlma nyiˈyar aˈyi nggabiya sǝra ju ndǝr ar kǝri kǝ mai, nji ɗǝwana ara nda, nda sara sǝnbiya. Nanda tsu kǝ hivǝr kari nda ara yiwa nyi. ");
INSERT INTO mfm_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kǝ kǝpal hyaˈari wu pama zǝmbǝlma nyiˈyar abǝr tara wa nga ndiya ǝnga dǝgal wu pama nda. ");
INSERT INTO mfm_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu a sǝni biyari sǝra ndu ɗǝnga, kǝ ji hǝri zǝr kushu, kǝ ji taˈyina nyi a dzǝr nyi, ");
INSERT INTO mfm_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","kǝ ji na anǝ nda, “Kalar ndǝra dlǝwuri zǝr kǝ arya thlǝmǝ ɗa, a dlǝwuri ɗar ja, ǝtsu ma ndǝra dlǝwur ɗa ri a dlǝwuri ja ndǝra sǝwa ɗa. Agabangau, ndǝra nji diɗana wu pama hyi, naja nga ndiya ǝnga dǝgalkur.” ");
INSERT INTO mfm_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kǝ Yahwana na, “Ndǝ dǝgal, ˈyi lari vanyi ndǝ a vǝr kǝdlǝ mambǝl ɗǝmwaˈyi wu thlǝmǝ ngau, kǝ ˈyi kari nyi ara naja aˈyi ǝnga ˈya mai.” ");
INSERT INTO mfm_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu shaɗǝwa, ji na, “Hya sara ka nyi mai, ma ndǝ aˈyi cabiya hyi dawakur mai, nǝr hyi nga ja.” ");
INSERT INTO mfm_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ənggǝra pǝci ɗa lǝhǝ anǝ Yesu aga ja sha a dǝmǝlmau, kǝ ji fuwa kǝr ja vǝr maˈyi a vu Urshalima. ");
INSERT INTO mfm_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kǝ ji sǝwa njira ju sau, aga nda maˈyi wu mwa nyi, nanda tsu, kǝ ndǝ vu vanyi mǝlmǝ nǝ Samariya, aga nda vuwa fuwa alenyi sǝ wu lagu. ");
INSERT INTO mfm_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ama kǝ njir mǝlmǝ kǝ nggǝl ara dlǝwu nyi, ara vu Urshalima nga ja vǝr maˈyi. ");
INSERT INTO mfm_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ənggǝra zǝmbǝlma nyiˈyar Yakubu ǝnga Yahwana lari abangau, ba ndǝ na anǝ nyi, “Thlagǝu, gu yiwu ˈya ngga uˈu sara a dǝmǝlmǝ aga ja nggyina nda ya?” ");
INSERT INTO mfm_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ama kǝ Yesu shabiya dzau, ba ji kughi anǝ nda! ");
INSERT INTO mfm_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kǝ ndǝ dzǝgwa maˈyi a ndu vanyi mǝlmau. ");
INSERT INTO mfm_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ma tsu nda wu lagu, kǝ vanyi ndǝ na anǝ Yesu, “Thlagǝu, yu nu ngau kalar vi kǝra gu maˈyi a ndari.” ");
INSERT INTO mfm_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kǝ Yesu shabiya nyi ji na, “Thlahu ǝnga kaˈu nga nda, ˈyagǝˈyar tsu kir nda aˈyi, ama zǝr ndau, vira ja fiya kǝra ja ari aˈyi mai.” ");
INSERT INTO mfm_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Anǝ vanyi ndǝ tsu kǝ ji na, “Nu ɗa.” Ama kǝ ndǝ kǝ na, “Thlagǝu, piyari ɗa ya maˈyi ya nda haɗǝna dǝɗa kwatahǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu shaɗǝwa nyi, ji na, “Bǝgǝ nji tǝtǝ nda haɗǝna ndǝ tǝtǝr nda. Ama nagau, ga maˈyi ga nda tǝtǝlna ndǝr tǝlkur Hyal.” ");
INSERT INTO mfm_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Vanyi ndǝ tsu ji na, “Thlagǝu, yu nu ngau, ama ga piyari ɗa kwatahǝu, ya maˈyi ya nda nar nyi anǝ nji gǝ ˈya abǝr maˈyi nga yau.” ");
INSERT INTO mfm_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu shaɗǝwa nyi, “Kalar ndǝra fǝri tsa ja ar kul zǝwa thla, ba ji ɓǝra tsamǝ gyiwu yukuɗu, naji ɗa tsaˈa aga gwu tǝlkur Hyal mai.” ");
INSERT INTO mfm_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wu yukuɗa kau, Thlagǝ ɓǝra ɗǝmbiya alenyi zǝmbǝlma nyi mǝɗǝfǝkumunyi apǝ mǝthlǝu, ji sǝwa nda mǝmǝthlǝu, aga nda maˈyi a dumwa nyi a ndu patǝr mǝlmǝ pamǝpamǝ ǝnga alenyi viˈyar kǝra naja ǝnga kǝrnyi ju nda vuwa gwa. ");
INSERT INTO mfm_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kǝ ji na anǝ zǝmbǝlma nyiˈyar, “Sǝr faˈa a su ki gangǝ nyi, ama njir mǝl thlǝr kushu nga nda. Agabangau, hya kǝdi thlagǝr fa, ja sǝwa njir mǝl thlǝr aga nda sa faˈa sǝ a su ki.” ");
INSERT INTO mfm_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Maˈya mau, kǝja ya vǝr sǝ hyi a biya ǝnggǝr tǝmahǝ wu pama ufwar vwaˈyar. ");
INSERT INTO mfm_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","A sara hya hǝ pǝrki mai alaga mbǝl alaga ɓiɓi, a sara hya usa nji ar lagu ma hya vǝr maˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Kalar ki kǝra hyi vuwa gwa, hya dzǝguya na, abǝr, ‘Jamǝkur anǝ hyu ki kau!’ ");
INSERT INTO mfm_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ma ndǝ jamǝ aˈyi a vu ki kau, bǝgǝ usa dzǝr hyi nǝ jamǝkur kau, ja nggya ǝnga ja, ma tsu aˈyi mai, bǝgǝ usa dzǝr hyi nǝ jamǝkur kau, ja sha shili anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Hya nggya wu ki ta, kalar sǝra nji nǝ hyi hya sǝm hya sa, arya a ɗar tsaˈa nja kina ndǝr mǝl thlǝr gǝnna thlǝr nyi. A sara hya ɓǝ sara wu ki a ndu vanyi ki mai. ");
INSERT INTO mfm_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Kalar mǝlmǝ kǝra hyi vuwa gwa, ma nja dlǝwuri hyiri, kalar sǝra nji hǝr hyi a shili hya sǝm. ");
INSERT INTO mfm_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Hya shilǝgǝbiya njira gǝra ngga kǝra wu mǝlmǝ ta, hya ɓǝra na anǝ nja nyi, abǝr, ‘Tǝlkur Hyal a shiliri lǝhǝ wu dzǝr hyi.’ ");
INSERT INTO mfm_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ama kalar mǝlmǝ kǝra hyi vuwa gwa, nji aˈyi dlǝwuri hyi mai, hya maˈyi a ndar lagu dǝdǝgalǝu, hya dzǝgwa na, ");
INSERT INTO mfm_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Alaga bǝbǝr mǝlmǝr hyi kǝra mbari hya ˈya kau, ˈyi wu dlǝɗǝna hyi sǝr hyi aga ja ɗa sǝr sakida ar kǝra hyi. Ama hya sǝni ja, abǝr Tǝlkur Hyal a shiliri lǝhǝu!’ ");
INSERT INTO mfm_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ya vǝr na anǝ hyi pǝcir kuɗiya nǝ duniya, Hyal a nda tǝhuɗǝ ǝgya Sodomu a mwa ara mǝlmǝ kau. ");
INSERT INTO mfm_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Sǝr tǝhuɗǝ anǝ ngau, Korazinu! Sǝr tǝhuɗǝ anǝ ngau, Bethlesaida! Maja abǝr sǝ dǝdǝgur kǝra nji mǝliya wu gau, nji mǝliya wu Taya ǝnga Sidonu, a tubir nda tsu kaɗǝ lagur hari lǝgutǝ sǝˈyinggu ǝnga tǝwa bǝbǝr wu kǝra nda. ");
INSERT INTO mfm_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Wu pǝcir numa Hyal wu sa tǝhuɗǝ ǝgya njir Taya ǝnga njir Sidonu a ndiya hyi. ");
INSERT INTO mfm_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nahyi tsu njir Kafarnahumu! Hya vǝr nggani abǝr nja nda faˈar hyi a dǝmǝlmǝ ya? Awau! Nahyi ma a gyiwu kaˈu ɗǝmwaˈyi nga nju nda puwa hyi. ");
INSERT INTO mfm_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Kalar ndǝra sǝya hyi himi, nayi nga ji nggari, kalar ndǝra piyari hyi tsu nayi nga ji piyari. Ama ndǝra piyari ɗa tsu a piyari ja ndǝra sǝwa ɗa.” ");
INSERT INTO mfm_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Zǝmbǝlma nyiˈyar mǝɗǝfǝkumunyi apǝ mǝthlǝ kǝ sha shili ǝnga caguli, nda vǝr na, “Thlagǝu, patǝ ǝkkǝˈyi mambǝl ɗǝmwaˈyiˈyar nda vǝr mǝl thlǝr ǝnga sǝra ˈyi wu na wu thlǝmǝ ngau.” ");
INSERT INTO mfm_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ca ngǝ Yesu shaɗǝwa nda, ji na, “A lari yi shatan tǝɗǝ sǝra dǝmǝlmǝ ǝnggǝr sǝm nǝ par. ");
INSERT INTO mfm_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nggara mau! Anǝ hyir yi dǝnama hya ɓǝ ar kǝra pabǝˈyar ǝkkǝˈyi ǝdiˈyar, nahyi tsu hya sǝm tǝlkur ar kǝra patǝr dǝnama nǝ dawar hyi, sǝr uya hyi aˈyi tsu mai. ");
INSERT INTO mfm_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Agabangǝ, hya sara caguli arya mambǝl ɗǝmwaˈyiˈyar sǝya hyi himi mai, ama hya caguli arya thlǝmǝr hyi aˈyi tsǝtsǝfǝ a dǝmǝlmau.” ");
INSERT INTO mfm_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ar pǝci kau, Yesu nyinyau ǝnga huɗǝ pǝrtǝ sara ara Mambǝl Cicau, ji na, “Dǝɗa, Thlagǝ kǝra a dǝmǝlmǝ ǝnga a gyiwu ˈyi, a usa ngǝr yau, arya gǝ ɗǝwana sǝˈyar kǝ anǝ nji hahangǝ ǝnga njir sǝn sau, ba gǝ dzǝgwa cabiya nyi anǝ njira ǝnggǝr wazha yiɗǝɗǝu. Abangǝ nga nyi, Tada arya naja kǝ ca ngǝ ɗa mǝnahǝu anǝ ngau.” ");
INSERT INTO mfm_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Dǝɗa anǝ ɗar sǝ patǝu, ndǝr sǝn sǝnbiya tara wa ngǝ zǝra nyi aˈyi mai, kǝl Dǝnyi wacu, abangǝ tsu ndǝr sǝn sǝnbiya tara wa ngǝ Tada nyi aˈyi mai, kǝl zǝr nyi ǝnga njira ju yiwu ja cabiya nda.” ");
INSERT INTO mfm_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ba ji shabiya dzǝ a ndǝra zǝmbǝlma nyiˈyar, ji na anǝ nda zhizhir nda, “Barka anǝ hyi ara hyi lari sǝˈyar kǝ hyu lari kau. ");
INSERT INTO mfm_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ya nar hyi nabiˈyar gangǝu, ǝnga tǝltǝlˈyar a yiwur nda, nda lari sǝˈyar kǝ hyu lar kau, ama nandǝ lari mai. A yiwur nda, nda nggari sǝˈyar kǝ hya vǝr nggar kau, ama nandǝ nggari mai.” ");
INSERT INTO mfm_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Vanyi pǝci, kǝ malǝmǝ sǝnbiya dlaɗau, hyaˈari, ju yiwu ja dzǝbiya Yesu. Kǝ ji yiwa nyi, ji na, “Mi nga ya mǝl aga ya uya pi gǝra kuɗa?” ");
INSERT INTO mfm_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ca ngǝ Yesu na anǝ nyi, “Mi nga nji tsǝfǝri wu dlaɗǝ nǝ Musa? Lagu mani nga gu jiga?” ");
INSERT INTO mfm_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Əngwar ja, “ ‘Ga yiwu Hyal Thlagǝ ngau ǝnga ɗǝfuwa gǝ papatǝu, ǝnga piya gǝ papatǝu, ba ǝnga ɗǝnga ngǝ papatǝu.’ Mǝthlǝkura nyi, ga yiwu tǝwul ngau, ǝnggǝr kǝra gu yiwu kǝrngau.” ");
INSERT INTO mfm_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Əngwar Yesu anǝ nyi, “A nabiyar gǝ kakalǝu, ma gǝ mǝl abangau, ba ga uya pi.” ");
INSERT INTO mfm_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ndǝ kau, ju yiwu ja cabiya abǝr naja, ju sǝni sau. Əngwar ja, “Kar ndangǝ, wa ngǝ tǝwul ɗa ka?” ");
INSERT INTO mfm_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ca ngǝ Yesu shaɗǝwa nyi, ji na, “Vanyi ndǝ, hyaˈari wu Urshalima ja vǝr maˈyi a gyiwu Yariko, kǝ ji tǝɗǝ wu tsa njir ɗa lagu. Kǝ ndǝ zǝɗǝna zhaɓi nyi, ba ndǝ dǝgǝ nyi, ndǝ piyari nyi lǝha dzǝr tau. ");
INSERT INTO mfm_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Wu lagu ta, pubu a vǝr tǝrabiya, ǝnggǝra ji lari ndǝ kau, ba ji sha, ji tǝrabiya sǝ nyi ar dza lagu. ");
INSERT INTO mfm_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ɓǝliya sar kushu, ba ndǝr Lawi dla ar lagu ta tsu, kǝ ji taˈyau, ji tsamiya nyi, ba ji mbar lagu ji maˈyi sǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ɓǝra ɓǝliya sar kushu, kǝja ndǝr Samariya (njira njir Izirayila diɗana) a vǝr ɓǝ nyi, ta ji lar ndǝ kau, ba ji taˈyau....... Kǝ ji lǝnguɗiya lǝhǝ ja tau, kǝ ji tǝhuɗǝ ǝgya ja. ");
INSERT INTO mfm_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34",".Kǝ ji puwa a gu mbǝlgǝ nyi ˈyimi..r wur inabi, ǝnga mal, ba ji pǝɗiya mbǝlga nyi ǝnga takulagǝu, ji dzǝgwa fǝri nyi a dar ya kwara nyi, kǝ ji hǝri nyi a shili wu vanyi ki dlǝwu mǝthlǝpi, ji sa shilǝgǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ayukuɗa pida pathlǝu, ǝngwar ja anǝ thlagǝr .ki nǝ dlǝwu mǝthlǝpi kau, ‘Kǝja kwaɓa tsaˈa ga ki ndǝr mǝl thlǝr nǝ pǝkǝ mǝthlǝu, ga dumwa ǝnga tsamǝ nyi, yu maˈyi, ma sǝra gǝ tsǝya adabanga kau, ma yi ɓǝra sha shili, ba ya sa kina ngau.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kǝ Yesu ɓǝra yiwa nyi, ji na, “Wu pama nji makǝr kau, wa ngǝ cabiya abǝr naja ngǝ tǝwul ndǝ ka?” ");
INSERT INTO mfm_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Əngwar ja, “Ndǝ kǝ cabiya nyi yiwukur kau.” Kǝ Yesu na anǝ nyi, “Maˈyi ga nda mǝl abangǝ tsu.” ");
INSERT INTO mfm_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ənggǝra Yesu ǝnga zǝmbǝlma nyiˈyar, a vǝr dumwa ǝnga ɓau, ba ndǝ vu vanyi mǝlmǝ kǝra vanyi mala nja ngga ǝnga Marthla dlǝwuri nyi a vu ki nyi. ");
INSERT INTO mfm_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mala kau, kwamǝ nyi aˈyi kǝra nja ngga ǝnga Maryamu, naja ji nggya a gyiwu ˈyi lǝha dzǝr Thlagǝu, ja vǝr sǝ himi sǝra ju na. ");
INSERT INTO mfm_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ama Marthla nǝ nyi, mǝl thlǝr sǝr sǝm ngǝ hǝna ɗǝnga nyi. Kǝ ji maˈyi a ndǝra Yesu ji nda na anǝ nyi, “Thlagǝu, aˈyi ga lari ǝnggǝra kwamǝ ɗa piyari ɗa, ya vǝr mǝl thlǝr kǝ patǝ zhizhi ɗa wa? Usi nar nyi ja shili, aga ja sa dlǝwari ɗa.” ");
INSERT INTO mfm_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ama kǝ Thlagǝ shaɗǝwa nyi, “Marthla, Marthla, hangǝkala ga, a hyaˈari, kǝ ji hǝna ɗǝnga ngau, a dar sǝ gangǝu, ");
INSERT INTO mfm_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ama sǝ zǝmǝ wacu ca ngǝ mǝnahǝu, Maryamu nǝ nyi a caɗǝbiyari ja, agabangau, ndǝr sǝni mbǝliya ara ja aˈyi mai.” ");
INSERT INTO mfm_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Vanyi pǝci Yesu a vǝr kǝdi Hyal ar vanyi vi. Ənggǝra ji kuɗǝna, kǝ pathlǝ wu pama zǝmbǝlma nyiˈyar na anǝ nyi, “Thlagǝu, highiɓǝri ˈya ǝnggǝra ˈya kǝdi Hyal, ǝnggǝr kǝra Yahwana highiɓǝri nyi anǝ zǝmbǝlma nyiˈyar kǝ tsu.” ");
INSERT INTO mfm_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ba ji na anǝ nda, “Ma hyu kǝdi Hyal, hya na, “ ‘Dǝrˈya, thlǝmǝ ngǝ ja nggya cicau, tǝlkur ngau ja shili. ");
INSERT INTO mfm_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ɗar ˈya sǝr sǝm nǝ ǝshina, ǝnga nǝ kalar pǝci. ");
INSERT INTO mfm_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tǝfǝbiya ˈya bikǝr ˈya, ǝnggǝr kǝra ˈyi tǝfǝbiya njira mǝliya ˈya bikau. Tǝfǝbiya nyi anǝ kalar ndǝra mǝliya ˈya bikau. A sara ga hǝr ˈya a ndar vir dzǝ mai.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu ɓǝra na anǝ zǝmbǝlma nyiˈyar, “Ma ɗa abǝr pathla hyi ǝnga bazhi, ji shili ǝgya ja hathlǝr vuˈyi, ji na anǝ nyi, ‘Bazhi ɗa, ndzǝbiya ɗa sǝr sǝm. ");
INSERT INTO mfm_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kǝja vanyi bazhi ɗa kǝra hyaˈari sarar vi naɗǝ shili ǝgya yi kabangǝkau. Nayi tsu, sǝr sǝm kǝra ya sǝni nǝ nyi aˈyi mai.’ ");
INSERT INTO mfm_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ma ɗa bazhi kǝra ji nda gal ndzǝ ara ja kǝ shaɗǝwa sara gu mbwa ji na, ‘A sara ga ɓwanǝ ɗa kǝr mai. Kabangǝkau, a haɗiyar ˈya miya ɗǝvau, nayi ǝnga wazha ɗa patǝ a yi pida nga ˈya. Na ya ɓǝra sǝni hyaˈari aga ya nǝ ngǝ vanyi sǝ mai.’ ");
INSERT INTO mfm_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ya nar hyi, alaga naja gǝra hyaˈari ji nǝ nyi sau, arya nanda bazhi, ju hyaˈari ja nǝ nyi kalar sǝra ju yiwu arya bazhi nyi kǝ aˈyi sǝli ǝnga kǝdi kǝra ji mǝl mai. ");
INSERT INTO mfm_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ya vǝr na anǝ hyi, hya dumwa ǝnga kǝdiyau, nju nǝ hyi. Hya dumwa ǝnga gal, hyu uya. Hya dumwa ǝnga tsatsa tsu, nju pahǝna hyi. ");
INSERT INTO mfm_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ara kalar ndǝra kǝdiyau, nju nǝ nyi, kalar ndǝra gal, ju uya, ndǝra tsa umbwa tsu, nju pahǝna nyi. ");
INSERT INTO mfm_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ndǝ aˈyi wu pama hyi kǝra ar viya tada, ma zǝr nyi kǝdi kalfi, ba ja nǝ nyi pabǝ ya? ");
INSERT INTO mfm_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Əndǝga ma ji yiwa hihi, ba nja nǝ nyi ǝdi ya? ");
INSERT INTO mfm_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ma nahyi, nji ɗǝɗǝmwaˈyi wu sǝni nǝ nyi anǝ wazhar hyi sǝ mǝmǝnahǝu, abari ngǝ Dǝrhyi kǝra a dǝmǝlma? Ju sa nǝ nyi Mambǝl Cicau anǝ njira wu kǝdi ara ja.” ");
INSERT INTO mfm_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Vanyi pǝci Yesu kǝdlǝbiya mambǝl ɗǝmwaˈyi sara wu dza ndǝ mǝga. Ənggǝra mambǝl kǝ biya, ba nda nyi mbar ndǝr, sǝ kǝ ɗa sǝ dǝdǝgur anǝ daɓǝr nji. ");
INSERT INTO mfm_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ama alenyi nji na, “Ənghǝng! Ndǝ kau, Bilzabulu ngǝ nǝ nyi dǝnama kǝdlǝ mambǝl ɗǝmwaˈyiˈyar kau, a biya.” ");
INSERT INTO mfm_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Alenyi nji dzǝbiya Yesu, ndǝ na anǝ nyi, “Mǝliya sǝ dǝdǝgur kǝra cabiya abǝr Hyal ngǝ sǝwa ngau.” ");
INSERT INTO mfm_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ama Yesu wu sǝn ɗǝngar nda, kǝ ji na anǝ nda, “Kalar tǝlkur kǝra tǝkǝbiya dzǝ mǝthlǝ wu taˈyi mai, ǝnga kalar mǝlmǝ ǝnga ki kǝra aˈyi hǝnggǝr ǝnga kuvwa nyi mai, nanda aˈyi wu sǝn taˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ma tsu shatan tǝkǝbiya dzǝ pamǝpamǝ mǝthlǝu, abar ngǝ tǝlkur nyi wu sǝn taˈya? Ya na abangau ara ǝnggǝra hyi hǝri abǝr ǝnga dǝnama nǝr Bilzabulu nga ya vǝr kǝdlǝ mambǝl ɗǝmwaˈyiˈyar. ");
INSERT INTO mfm_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kabangǝkau, Ma ǝnga dǝnama nǝ Bilzabulu nga yu kǝdlǝ mambǝl ɗǝmwaˈyiˈyar, kar zǝmbǝlmar hyiˈyar tsu? Ənga mi nga ndu kǝdla? Agabangau, nanda ngu nda mǝl numa anǝ hyi ar kǝra sǝˈyar kau. ");
INSERT INTO mfm_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ama maɗa ǝnga dǝnama nǝ Hyal nga ya vǝr kǝdlǝ mambǝl ɗǝmwaˈyiˈyar kau, a ɗari abǝr tǝlkur Hyal a shiliri anǝ hyi.” ");
INSERT INTO mfm_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ma ndǝra ǝnga dǝnama pabǝri kǝrnyi ǝnga kar pa, ja vǝr ɓǝla ki nyi, kar ki nyi wu nggya jamǝkur. ");
INSERT INTO mfm_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ama ma ndǝra ndiya nyi ǝnga dǝnama hǝri nyi pa a shili, ba ji sa ndiya dǝnama nyi, ju sǝn faˈari kalar sǝr pa kǝra ju fǝr kǝr ǝni, ba ja dzǝgwa tǝtǝkǝna kar nyi kau, ǝkkǝˈyi kari ki nyi kǝra ji mbǝliya kau. ");
INSERT INTO mfm_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ndǝra gǝra ǝnga yau, dawa ɗa ngau, ǝnga ndǝra gǝra vǝr kaɓǝ ǝnga yau, tǝtǝlna nga ja vǝr tǝtǝlna. ");
INSERT INTO mfm_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ma nji kǝdlǝbiya mambǝl ɗǝmwaˈyi a biya sara wu dza ndau, ma ji gal vir sǝ hǝɗa katini, ju sǝn na, ‘Ya ɓǝra sha a ndu dza ndǝra yi biya sara a gwa.’ ");
INSERT INTO mfm_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ma ji ɓǝra sha shili, ba ji sa thlǝwa dzǝ kau, nji tsǝkǝbiya camǝu, ǝnga kalar sǝ wu lagu, ");
INSERT INTO mfm_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ba ja ɓǝra sha, ja nda faˈari mambǝlˈyar pamǝpamǝ mǝɗǝfǝ kǝra ndiya nyi ǝnga shishikur, ba nda maˈyi a vu ja nda vuwa nggya. Ba nggyabiya ndǝ kǝ nǝ yukuɗǝu, a ndiya nǝ tanggǝrma ǝnga ɗǝmwaˈyu.” ");
INSERT INTO mfm_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ənggǝra Yesu a vǝr na sǝˈyar kau, vanyi mala wu pama nji, hyaˈana ɗahǝu, ji na, “Hyal ja fǝnggǝr nyi barka anǝ mala kǝra yabiya ngau, ǝnga ji hǝr ngau.” ");
INSERT INTO mfm_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kǝ Yesu shaɗǝwa, ji na, “Barka a ndiya anǝ njira vǝr nggar ndǝr Hyal, ndǝ ɓǝlari.” ");
INSERT INTO mfm_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ənggǝra njira vǝr shili ǝgya Yesu cakau, kǝ ji na, “Nji kabangǝkau, nji ɗǝmwaˈyi ngau. Ndu gal aga ya cabiya nda mǝtsamǝ dǝdǝgur, ama vanyi mǝtsamǝ dǝdǝgur kǝra ya ca anǝ nda aˈyi mai, kǝl nǝ Yunana, ");
INSERT INTO mfm_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ǝnggǝra Yunana ɗa sǝ dǝdǝgur anǝ njir Niniva, abangǝ tsu ngǝ Zǝr Ndu nda ɗa anǝ nji kabangǝkau. ");
INSERT INTO mfm_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ar pǝcir numa, Kwatam Shiba wu nda sa hyaˈari ǝnga nji kabangǝkau, ba ja cabiya nda abǝr nanda aˈyi mǝliya kakalǝ mai, arya ji hyaˈari sarar kuɗiyar duniya aga ja sa sǝhimi highiɓǝ nǝ tsǝtsǝlkur nǝ Solomanu. Kǝja ndǝra ndiya Solomanu aˈyi ǝnggau. ");
INSERT INTO mfm_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ara ar pǝcir numa, njir Niniva wu nda hyaˈari ǝnga njir zaman kau, ba nda canǝ nda abǝr nanda aˈyi mǝliya sǝra kakalǝ mai, arya nanda njir Niniva tubi ar pǝcira Yunana tǝtǝlna nda ndǝr Hyal. Ya, kǝja ndǝra ndiya Yunana aˈyi ǝnggau. ");
INSERT INTO mfm_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Nja sǝn mbǝbiya pitǝlla ba nja mbuya ǝgya kiɗa tǝm mai. Ama nja kyaga fiya a dar madzigam, ar vi kǝra ja sǝn mbǝl anǝ kalar ndǝ kǝra a vu ki kau. ");
INSERT INTO mfm_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Li ca ngǝ mbǝmbǝl nǝ dzau. Ma liya gǝ mǝnahǝu, dza gǝ patǝ wu nyabiya dzǝ ǝnga mbǝmbǝl. Ama ma liya gau aˈyi jamǝ mai, patǝr dza gǝ tsu wu nda nyabiya dzǝ ǝnga kuthlǝu. ");
INSERT INTO mfm_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ga tsamǝ ga lari abǝr mbǝmbǝl kǝra wu gau aˈyi kuthlǝu mai. ");
INSERT INTO mfm_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ma patǝr dza gǝ aˈyi nyinyau ǝnga mbǝmbǝl, vi aˈyi kǝra ǝnga kuthlǝ mai, ba ja cabiya mbǝmbǝlkur patǝu, ǝnggǝr mbǝmbǝl nǝ pitǝlla a vǝr ca mbǝmbǝlkur nyi.” ");
INSERT INTO mfm_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ənggǝra Yesu kuɗǝna ndǝr, ba vanyi ndǝr Farisi nggar nyi a ndu ki nyi, aga nda nda sǝm sǝr sǝm. Kǝ ji maˈyi, ji nggya ar vi sǝm sǝr sǝm. ");
INSERT INTO mfm_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ama ǝnggǝra ndǝr Farisi lari Yesu aˈyi cina tsi, ji dzǝgwa sǝm sǝr sǝm mai, ba ɗa sǝ dǝdǝgur anǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kǝ Thlagǝ na anǝ nyi, “Nahyi njir Farisi, hyu sǝn cina ya cala miya ha ǝnga cala, ama ɗǝfuwa hyi nyinyi nga nyi ǝnga dlǝrbǝ ba ɗǝmwaˈyikur. ");
INSERT INTO mfm_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nahyi nji dza, aˈyi Hyal ngǝ mǝliya sǝra ar babal ǝnga sǝra gwu huɗa nyi wa? ");
INSERT INTO mfm_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Maja abǝr hyu lǝri sǝra ara hyu cala anǝ nji tǝtǝ dǝnama kalar sǝ wu ɗa cici anǝ hyi.” ");
INSERT INTO mfm_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Sǝr tǝhuɗǝ anǝ hyi njir Farisi arya hyu hǝbiya pathlǝ wu sǝ kumo anǝ Hyal alaga wu sǝ kukushu kǝra hyu uya patǝ ǝnggǝr sukwar hyali ǝnga sǝ kisǝu. Ama kǝ hyi dzǝgwa piyari nu sǝra tsaˈa hya mǝl ǝnga yiwu Hyal. Sǝˈyar kǝ nga hya kyaga mǝl aˈyi hya piyari alenyi sǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kawa mau, njir Farisi arya hya vǝr yiwu nja nǝ hyi vir gya tsapǝu wu umbwa daɓǝ dzǝ njir Yahudiya, ǝnga tsu nja usa hyi ar sugu. ");
INSERT INTO mfm_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kawa anǝ hyi njir Farisi arya a ɗar hyi ǝnggǝr hu kǝra ɗǝɗǝwa nja vǝr ɓǝ a dar ara gǝra ǝnga sǝnkur.” ");
INSERT INTO mfm_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kǝ pathlǝ wu pama malǝmǝ highiɓǝ nǝ dlaɗǝ Musa na anǝ Yesu, “Malǝmǝ ma gu na sǝˈyar kǝ abangau, naˈya ma a nggǝliya ˈyar gau.” ");
INSERT INTO mfm_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu shaɗǝwa, ji na, “Kawa anǝ hyi, nahyi malǝmǝ highiɓǝ nǝ dlaɗǝ nǝ Musa, arya nahyi fǝnggǝr nyi anǝ nji sǝ tǝdǝɓǝu kǝra ɗa dzadzau nda hau, ama nahyi ǝnga kǝrhyi a sǝn hǝri alaga zǝr tsa hyi zǝmǝ aga dlǝwa nda ǝni mai. ");
INSERT INTO mfm_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Sǝr tǝhuɗǝ anǝ hyi, arya hyi hǝriya hu mǝnahǝ nǝ nabiˈyar kǝra ǝjir hyi ˈyar ngǝ tsǝya nda. ");
INSERT INTO mfm_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Agabangau, a cabiyari abǝr a hǝnggǝr hyi ǝnga sǝra ǝjir ˈyar mǝliya abǝr kakalǝ nga nyi. Nanda ngǝ tsǝya nabiˈyar ba hyi hǝrna hur nda. ");
INSERT INTO mfm_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ara kǝ ngǝ Hyal wu tsǝtsǝlkur nyi nana, abǝr, ‘Yi wu nda sǝwa nda nabiˈyar ǝnga cama sǝsǝˈyar. Ndu nda tsǝya alenyi nju pama nda ǝnga nji ndu nda nǝ ɓwaɓwatǝ gagaɗau.’ ");
INSERT INTO mfm_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Agabangau, nju nda mǝliya nyi numa anǝ njir zaman kau, arya culi nabiˈyar kǝra ndǝ dlǝna mbar dzǝgwar duniya baˈanǝ kabangǝkau, ");
INSERT INTO mfm_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","mbari ar mashir Habila, ba shili ar nǝ Zakariya ndǝra nji tsǝya wu pama vir thla sǝ ǝnga vi cici nǝ ki Hyal. Yu na anǝ hyi, nju nda mǝlna nyi numa anǝ nji zaman kau, arya sǝˈyar kǝ patǝu. ");
INSERT INTO mfm_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Sǝr tǝhuɗǝ, anǝ hyi malǝmǝ highiɓǝ nǝ dlaɗǝ Musa arya hyi dana lagu kǝra nja sǝni Hyal ari, nahyi ǝnga kǝrhyi, nahyi gwa mai, ǝnga nahyi piyari njir yiwu gwa nda gwa tsu mai.” ");
INSERT INTO mfm_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ənggǝra Yesu piyari viya nyi, kǝ malǝmǝ dlaɗǝˈyar ǝkkǝˈyi njir Farisi dzǝgwa dumwa ǝnga ciɗǝ nyi ndu tsǝtsǝbwar ǝnga yiwa sǝ pamǝpamǝ gangǝu. ");
INSERT INTO mfm_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ndu gal lagu kǝra nda uya nda vazǝya nyi lagur sǝra ju na. ");
INSERT INTO mfm_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ar pǝci ta nji gangǝ kaɓau, kǝl ta gangǝkura nda cakǝ ndǝ dzǝgwa jajahǝ Kǝrnda aga nda lari Yesu. Kǝ Yesu dzǝguya na anǝ zǝmbǝlma nyiˈyar tanggǝrma, abǝr, “Hya hangǝkal ǝnga thlǝlam nǝ njir Farisi, kǝra cabiya ǝnggǝra ndu ngguta nji. ");
INSERT INTO mfm_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kalar sǝ aˈyi kǝra ndu mǝl ɗǝɗǝwa kǝra gǝra nda biyar babal mai, ǝtsu sǝ aˈyi ɗǝɗǝwa kǝra nji gǝra nda sǝn mai. ");
INSERT INTO mfm_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Agabangau, kalar sǝra hyi nana ɗǝɗǝwa, nju nda nggari ar babal. Ətsu, sǝra hyi nana a vu himiya ndǝ zǝmǝ a gu ndǝlmbwa kǝra hahaɗau, nju nda hǝˈuna sara dar kǝra umbwa.” ");
INSERT INTO mfm_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nahyi bazhi ɗaˈyar, yu na anǝ hyi, hya sara hivǝr njira wu sǝn tsǝya kumǝr dzau, ama ayukuɗa nyi, sǝ aˈyi ndu ɓǝra sǝn mǝliya tsu mai. ");
INSERT INTO mfm_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ama yu nar hyi ndǝra hya hivǝr nyi. Hya hivǝr Hyal, ndǝra ayukuɗa ji tsǝya ngau, ju ɓǝra sǝn vakuwa ngǝ a gwu uˈur kǝtsa. Jiri nga yu na anǝ hyi, naja nga hya kyaga hivǝr nyi! ");
INSERT INTO mfm_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Aˈyi nju ɗǝlna wazha ˈyagǝ mǝthlǝ ar kǝra peni pathlǝ wa? Alaga abangau, Hyal aˈyi faˈari ǝnga zǝma nda mai. ");
INSERT INTO mfm_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ənga jiri, shishir kǝra hyi ma jijiga nga nda. Agabangau, a sara hya hivǝr mai. A ndiyar hyi wazha ˈyagǝ ǝnga mǝnahǝ gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Yi wu na anǝ hyi ǝtsu, kalar ndǝra hǝnggǝr abǝr naja nǝɗa nga ja a dumwar nji, nayi tsu, yu nda hǝnggǝr abǝr nǝɗa nga ja a dumwar waladiˈyar nǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ama ndǝra piyari ɗa wu mwar nji, nayi tsu wu nda piyari nyi wu mwar waladiˈyar nǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Kalar ndǝra ndǝr nǝ diɗa Zǝr Ndau, nju nda tǝfǝbiya nyi, ama kalar ndǝra ndǝr nǝ diɗa Mambǝl Cicau, nju nda tǝfǝbiya nyi mai. ");
INSERT INTO mfm_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ma nji hǝri hyi a ndumwar njir umbwa daɓǝ dzau, ǝnga a ndumwar njir pathla, ǝnga tsu njira nggurǝm nǝ mǝlmau, hya sara ɗǝnga ǝnggǝra hyu nda hǝbiya kǝrhyi mai, ǝnga sǝra hyu nda na mai, ");
INSERT INTO mfm_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","arya Mambǝl Cici wu nda highiɓǝr hyi sǝra hyu nda na ar pǝci ta.” ");
INSERT INTO mfm_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kǝ vanyi ndǝ sara wu pama nji na anǝ Yesu, “Malǝmǝ, nar nyi anǝ zamǝ ɗa ja nǝ ɗa sǝr faˈa ki ɗa kǝra dǝrˈya tǝ ji piyari ˈya.” ");
INSERT INTO mfm_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu shaɗǝwa nyi, ji na, “Nagau! Wa ngǝ mǝliya ɗa ndǝr numa, ǝnga ndǝr tǝkǝ sǝra dǝr hyi tǝ ji piyari hya?” ");
INSERT INTO mfm_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kǝ ji dumwa ǝnga ndǝr anǝ nji, ji na, “Hya tsǝrpǝr kǝrhyi, hya nggya ǝnga hangǝkal ara suna sǝr duniya a sara mbar hyi, arya gangǝkura sǝr duniya aˈyi ca ngǝ uya pi mai.” ");
INSERT INTO mfm_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kǝ ji nar nda vanyi karapau, abǝr, “Vanyi ndǝr gǝnna saya ɗa, kǝra uya barka sǝ zǝzǝwa gangǝ gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kǝ ji mbar ɗǝnga wu ɗǝfuwa ja, ji na, ‘Kǝja vir fiya sǝ zǝzǝwa ɗa aˈyi mai. Mi nga ya mǝl kabangǝka?’ ");
INSERT INTO mfm_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Kǝ ji na anǝ kǝrnyi, ‘Ənghǝng! A sǝni yi sǝra ya mǝl. Ya tǝtǝlna tsamˈyar kau, ba ya dzǝgwa hǝriya nggunggurǝma nyi, kǝra sǝni hǝri sǝ zǝzǝwa ɗa ǝnga alenyi kar ɗa. ");
INSERT INTO mfm_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ya dzǝgwa nar nyi anǝ kǝrɗa, “Nagau!” Kǝja gǝ ǝnga sǝ zǝzǝwa gangǝu, kǝra ga sǝn mǝl thlǝr ǝni nǝ fa gangǝu. Ga ɓǝliya sar, ga sǝm, ga sa, ga dzǝgwa caguli.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ama kǝ Hyal na anǝ nyi, “Nagǝ ndǝ dza! Əshina vuˈyi kau, nga yu dlǝwuri piya gau. Ya dzǝgwa lari tara wa ngu nda sǝm sǝˈyar kǝ gǝ tsǝmiya anǝ kǝr ngǝ kau.” ");
INSERT INTO mfm_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu kuɗǝna ndǝr kau, ǝnga na, “Abangǝ nga nyi wu nda ɗa anǝ kalar ndǝra tsǝmiya sǝr duniya anǝ kǝrnyi, ama wu mwar Hyal naja aˈyi ndǝr gǝnna mai.” ");
INSERT INTO mfm_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kǝ Yesu na anǝ zǝmbǝlma nyiˈyar, “Agabangau, yu na anǝ hyi, a sara hya ghǝɗǝr kǝrhyi arya nggyabiyar ǝnga sǝra hyu sǝm ǝnga sǝra hyu sa mai, alaga ar kǝra kar dza hyi tsu mai. Arya piya ndau, aˈyi a ndiya sǝr sǝm wa, ǝnga dza ndǝ aˈyi a ndiya sǝr ha wa? ");
INSERT INTO mfm_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Arya pi a ndiya sǝr sǝm, dzǝ tsu a ndiya sǝr ha. ");
INSERT INTO mfm_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tsama mǝ ˈyagǝˈyar gǝyi, nandǝ wu thlǝka mai ǝnga nandǝ wu gǝm mai ǝnga tsu nandǝ wu pǝ sǝ wu val mai, alaga abangau, dǝr hyi kǝra a dǝmǝlmǝ nga vǝr sǝmǝna nda. Ya, aˈyi hyu ndiya nda ǝnga dudurkur wa? ");
INSERT INTO mfm_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wa ngu pama hyi ara ɓwakǝr nyi, ba ja sǝn cakǝri saka pathlǝu a dar kǝra piya ja? ");
INSERT INTO mfm_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ma nahyi aˈyi a sǝn mǝliya sǝ kushu ǝnggǝr kǝ mai, mi ngǝ ɗa hyu ɓwakǝr ǝnga alenyi sa? ");
INSERT INTO mfm_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Tsama mǝ jigwal wu gǝyi, ǝnggǝra ndu hau. Nandǝ wu mǝl thlǝr alaga shi paˈwa mai. Agabangau, yu nar hyi, alaga tǝl Solomanu ǝnga kadakadarkur nyi aˈyi saya har kari ǝnggǝr nǝr nda mai. ");
INSERT INTO mfm_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ma abangǝ ngǝ Hyal wu har nyi kar anǝ jigwal wu a gwar tagǝu, kǝra aˈyi nda ǝshina ama ǝzǝgǝu a fuwar nji a gu uˈu, aˈyi ju nda har hyi kar a ndiya nda wa? Nahyi njira ǝnga mbǝrsa kukushu. ");
INSERT INTO mfm_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Hya sara ghǝɗǝr kǝrhyi, hyu na, ‘Mi nga ˈya wu nda sǝma ǝnga mi nga ˈya wu nda sa,’ alaga ‘Mi nga ˈya wu nda ha mai.’ ");
INSERT INTO mfm_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Arya njir duniya njira gǝra sǝn Hyal ngu gal sǝˈyar kau. Dǝrhyi kǝra a dǝmǝlmau wu sǝni abǝr hyu yiwu sǝˈyar kau. ");
INSERT INTO mfm_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ama sǝ tanggǝrma, ca ngǝ hya gal tǝlkur Hyal ǝnga tsapǝkur nyi ba ja nǝ hyi sǝˈyar kǝ patǝ tsu. ");
INSERT INTO mfm_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nahyi kǝra kukushu njir nu ɗa ǝnga jiri, a sara hya hivǝr mai, arya dǝr hyu yiwu ja nǝ hyi tǝlkur nyi. ");
INSERT INTO mfm_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Hya ɗǝlna sǝra aˈyi ara hyi patǝu, hya nǝ nyi gǝnna nyi anǝ nji tǝtǝ dǝnama. Aga hya uya anǝ kǝrhyi gǝnna a dǝmǝlmau, vira kǝthla ǝnga vuyavuya a sǝn ndzana mai, vira tsu njir hǝl wu sǝn pǝthlǝna nda vuwa faˈari mai ");
INSERT INTO mfm_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Arya vira gǝnna ngǝ ari, ǝna ngǝ ɗǝfuwa gǝ tsu. ");
INSERT INTO mfm_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Hya tsǝrpǝr kǝrhyi, hya nggya ǝnga fǝr kǝr, ǝnga pitǝllar hyi mbǝmbau. ");
INSERT INTO mfm_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Hya ɗa ǝnggǝr mafaˈyar kǝra a vǝr sǝkǝ shilir thlagǝr kir nda sara wu mini nǝ hǝ dzau, aga ma ji shili, ji sa tsa miya ɗǝvau, ba nda nggari nda pahǝna nyi ǝnga kusa. ");
INSERT INTO mfm_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Wu nda ɗa sǝr caguli anǝ mafaˈyar kǝ ma thlagǝr kir nda shili ji thlǝwa nda liliˈu. Jiri nga yu na anǝ hyi, ju nda zǝɗǝna lǝgutǝ dǝgal kǝra ar dza ja, ja dzǝgwa hǝri nyi sǝr sǝm a nda nǝ mafaˈyar kau, ba ja dzǝgwa na anǝ nda nggya mau, hya sǝm sǝr sǝm. ");
INSERT INTO mfm_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Barka anǝ mafaˈyar kǝ kǝra thlagǝr kir nda thlǝwa nda liliˈu ar kalar pǝci kǝra ji shili tara hathlǝr vuˈyi ǝnga tara mudlǝ kaɗǝu, nda vǝr sǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nggabiya mau, ma ja abǝr thlagǝr ki wu sǝni pǝci kǝra ndǝr hǝl wu shili wu ki nyi, ju nggya liliˈu, naji wu piyari ndǝr hǝl a sa pǝthlǝ ki nyi mai. ");
INSERT INTO mfm_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Agabangau, kǝl hya nggya papabau, arya nahyi wu sǝni tara ǝnuwa ngǝ Zǝr Ndau wu nda shili ari mai.” ");
INSERT INTO mfm_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Kǝ Biturusu na, “Thlagǝu, karapǝ kau, ar kǝra ˈya nga nyi, ǝndǝga ar kǝra patǝr nji ya?” ");
INSERT INTO mfm_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kǝ Thlagǝ shaɗǝwa nyi, ji na, “Wa ngǝ ndǝr mǝl thlǝr kǝra nji fǝr kǝr ǝnga ja ǝnga ndǝ hahanga? Naja ngǝ ndǝ kǝra tarki nyi fiya nyi dǝgal ar kǝra njir mǝl thlǝr nyiˈyar, aga ja nǝ nda sǝr sǝm ar pǝci kǝra tsatsaˈa? ");
INSERT INTO mfm_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mafa kǝra thlagǝr ki nyi shili ji sa thlǝwa nyi ja vǝr mǝl thlǝr nyi kakalǝu, ju ɗa ǝnga caguli. ");
INSERT INTO mfm_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yu nar hyi jiri, tarki nyi wu nda fiya nyi dǝgal ar kǝra sǝ nyi patǝu. ");
INSERT INTO mfm_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ama ma ji ɗa, ndǝr mǝl thlǝr kǝra ɗǝmwaˈyi ngau, ju nda na anǝ kǝrnyi, ‘Kǝja tarki ɗa a nggyari ara shili kaɗǝu.’ Ba ji nggya aga dǝgǝ njir mǝl thlǝr kuvwa nyiˈyar ǝnga ju sǝm ǝnga sa sǝ sasa ǝnga njir sa sǝ sasa. ");
INSERT INTO mfm_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ma ji mǝl abangau, tarki nyi wu nda shili kukuthlǝu ar pǝci kǝra ji gǝra nggani ju shili. Tarki wu sa takasiya nyi ba ja sǝwa nja vakuwa nyi a vu pama njir ngguta vi, vira ndu vuwa nggya ndu tiwi ǝnga sǝlǝm ba ǝnga ɗǝ hir.” ");
INSERT INTO mfm_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Mafa kǝra wu sǝni sǝra wu huɗa thlagǝr ki nyi, ama kǝ ji nggǝl ara tsǝrpǝri kǝrnyi ǝnga naja aˈyi mǝl sǝra ju yiwu mai, nju nda sa dǝgǝ nyi gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ama mafa kǝra gǝra sǝni sǝra thlagǝr ki nyi wu yiwu ja mǝl, ba ji mǝliya sǝra tsaˈa nja dǝgǝ nyi, nju nda dǝgǝ nyi kushu. Kalar ndǝra nji nǝ nyi sǝ gangǝu, nju nda gal sǝ gangǝ ara ja. Ma ndǝra tsu nji nǝ nyi sǝ gangǝ gagaɗau, nju nda gal sǝ gangǝ gagaɗǝ sara ara ja. ");
INSERT INTO mfm_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Uˈu nga yi dla ǝni wu duniya. Cimǝ ɗa kabangǝkau, a mbǝbiyar nji uˈuwa nyi! ");
INSERT INTO mfm_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Aˈyi yi ǝnga baɓǝtizǝma nǝ ɓwaɓwatǝ kǝra nja mǝl anǝ ɗa, hangǝkal ɗa a hyaˈari kǝl ma nji mǝliya ɗa. ");
INSERT INTO mfm_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Hyu nggani abǝr nggya jamǝ nga yi shili ǝni anǝ duniya ya? Əman de! Yu nar hyi, tǝkǝ dzǝ nga yi shili ǝni. ");
INSERT INTO mfm_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mbar kabangǝkau, wu ki zǝmǝu, nji tǝfu wu nda tǝkǝbiya dzǝ pamǝpamǝ mǝthlǝu, nji makǝr ar kǝra nji mǝthlǝu, nji mǝthlǝ tsu ar kǝra nji makǝru. ");
INSERT INTO mfm_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tada aˈyi ǝnga zǝr mai, zǝr tsu aˈyi ǝnga dǝnyi mai. Ama aˈyi ǝnga kwa nyi mai, kwa tsu aˈyi ǝnga mǝnyi mai. Miya sal aˈyi ǝnga kwanjili nyi mai, kwanjili tsu aˈyi ǝnga miya sal nyi mai.” ");
INSERT INTO mfm_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu ɓǝra na anǝ nji, “Ma hyi lari dlama hyaˈari sara gyiwu Gwa Tǝɗǝ Pǝci, ba hya na, ‘Nda tǝɗǝ par nga nji,’ ba par a tǝɗau. ");
INSERT INTO mfm_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma tsu hyi nggari yambaɗǝ a vǝr sǝ sara wu lagu Dǝ Fwahǝu, ba hya na, ‘Wu nda ɗa kwakwaɗǝu,’ ba ja ɗa abangau. ");
INSERT INTO mfm_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Njir ngguta vi! Hyu sǝni tsamǝr sǝra wu duniya ǝnga a dǝmǝlmau, ama nahyi a sǝn tsamǝ ri sǝra nggyabiya kabangǝkǝ ar kǝri mai.” ");
INSERT INTO mfm_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Mi ngǝ ɗa nahyi ǝnga kǝrhyi a sǝni tsamiya sǝra mǝnahǝu hya mǝl maya? ");
INSERT INTO mfm_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ma ndǝ wulana ngau a mwar pathla, hya ɓasǝwa ǝnga ja tsu hyar lagu, aˈyi abangǝ mai, ba ja fuwa ngau a gu tsa ndǝr pathla ba ndǝr pathla tsu a fuwa ngau a gu tsa dǝgala ndǝr fursǝna, ndǝr fursǝna tsu ba ja fuwa ngau a gu fursǝna. ");
INSERT INTO mfm_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ya nar ngǝ jiri, nagǝ wu biya mai, kǝl gǝ kina patǝr sǝra nju nu ngau.” ");
INSERT INTO mfm_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kakalǝ ar pǝci kau, alenyi nji aˈyi kǝra ǝna, ndǝ nar nyi anǝ Yesu ar kǝra njir Galili kǝra Bilatusu na nja dlǝna nda ar pǝcir ngguɗǝ sǝ anǝ Hyal nda, kǝl ta mashir nda daɓǝr dzǝ ǝnga mashi sǝra nda vir thla anǝ Hyalǝr nda. ");
INSERT INTO mfm_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu shaɗǝwa nda, ji na, “Kǝ hyi nggani njir Galili kǝ nji tsǝya kǝ nga ndiya patǝr njir Galili ǝnga bikǝ ya? ");
INSERT INTO mfm_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ya nar hyi, Awau! Ma nahyi aˈyi tubi sara ara bikǝr hyi mai, patǝkura hyi, hyu nda kuɗǝna ǝnggǝr nanda. ");
INSERT INTO mfm_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Əndǝga, hyu nggani nji kumo apǝ cisu kǝ umbwa dzǝgamǝ dla a gyar kǝra nda wu Sǝliwamu, ba ndǝ tǝ kau, nanda nga ndiya patǝr njir Urshalima ǝnga bikǝ ya? ");
INSERT INTO mfm_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ya nar hyi, Awau! Ma nahyi tsu aˈyi tubi mai, nahyi ma hyu nda sanakǝr ǝnggǝr nanda.” ");
INSERT INTO mfm_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kǝ Yesu nar nda karapǝ kau, “Vanyi ndǝ aˈyi ǝnga wur ɓǝla wu fa nyi. Kǝ ji shili aga ja sa uya yaya nyi, ama naji uya alaga zǝmǝ mai. ");
INSERT INTO mfm_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kǝ ji nar nyi anǝ ndǝr sǝkǝ fa kau, ‘Tsamiya gǝyi, fa makǝr ǝshina nga ya vǝr shili aga ya sa uya wazha ar wur ɓǝla kau, ama nayi saya uya mai. Gǝmna nyi! Ara mi nga nja piyari nyi ja nyana vi kurthla?’ ");
INSERT INTO mfm_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ama kǝ ndǝr sǝkǝ fa na anǝ nyi, ‘Ndǝ dǝgal, cakǝri nyi nji fa pathlǝu, yu nda labiya dza nyi, ya pǝr nyi gwaɓa. ");
INSERT INTO mfm_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ma ji sǝni pǝ wazha wu fa kau, jamǝu! Ma naja aˈyi sǝn pǝ wazha tsu mai ba ga dzǝgwa gǝmna nyi.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Vanyi pǝci, Yesu ja vǝr highiɓǝ wu vanyi umbwa daɓǝ dzǝ njir Yahudiya pǝcir Ɓǝlsar, ");
INSERT INTO mfm_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","kǝja vanyi mala kǝra mambǝl ɗǝmwaˈyi nǝ nyi shilǝgǝ nǝ fa kumo apǝ cisu, ji nggǝya nyi naja sǝn taˈyi pir mai. ");
INSERT INTO mfm_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ənggǝra Yesu lari nyi kǝ ji ngga nyi ji na, “Mala, a mbǝɗana ngǝ ri nji ara shilǝgǝ ngau.” ");
INSERT INTO mfm_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ba ji fǝri tsa ja ar ja, ǝnggau, ba ji taˈyi pir, kǝ ji fal Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kǝ huɗa ndǝ dǝgal nǝ umbwa daɓǝ dzǝ njir Yahudiya ndzǝ ǝnga Yesu ara ji mǝliya mala kǝ jamǝ pǝcir Ɓǝlsar. Kǝ ji na anǝ njira ǝna, “Pǝci kwa aˈyi nǝ mǝl thlǝr, hya shili wu pǝciˈyar kǝ nja sa mbǝɗana hyi, ama aˈyi pǝcir Ɓǝlsar mai.” ");
INSERT INTO mfm_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ama kǝ Thlagǝ na anǝ nyi, “Nahyi njir ngguta nji! Aˈyi hyu pǝlna thlar hyi alaga kwarar hyi, hya maˈyi ǝnga nda a ndar vir sa ˈyimi ar pǝcir Ɓǝlsar wa? ");
INSERT INTO mfm_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mala kau, kwar Ibrahimu, kǝra shatan mbiya nyi nǝ fa kumo apǝ cisu, aˈyi ɗa tsaˈa nja mbǝɗana nyi wu pǝcir Ɓǝlsar wa?” ");
INSERT INTO mfm_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kǝ sǝli mbari patǝr dawa nyiˈyar, ara ndǝr kau. Ama caguli ǝnga huɗǝ pipida nga ara alenyi nji ara sǝ dǝdǝgur kǝra ja vǝr mǝl kau. ");
INSERT INTO mfm_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Əngwar Yesu, “Abari ngǝ tǝlkur Hyala? Ənga mi nga nja kyaga kakalǝ nya? ");
INSERT INTO mfm_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Naja ǝnggǝr culi bǝla nga nyi, kǝra vanyi ndǝ hǝri ji thlǝkana wu masǝmǝ nyi. Ji hau, ba ji ɗa wu kǝra ˈyagǝˈyar liya kir nda a dagwa.” ");
INSERT INTO mfm_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kǝ Yesu ɓǝra yiwa, “Ənga mi nga ya sǝn gǝla tǝlkur Hyala? ");
INSERT INTO mfm_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tǝlkur Hyal ǝnggǝr thlǝlamǝ nga nyi, kǝra mala hǝri ji gwaɗǝbiya ǝpou tasaˈwu tǝkǝ sǝ makǝr ǝni, ba ja dzǝgwa thlǝthlǝ gagaɗau.” ");
INSERT INTO mfm_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ənggǝra Yesu mbar lagu ja vǝr maˈyi a vu Urshalima, ba ji vu alenyi mǝlmǝ nggunggurǝm ǝnga mǝlmǝ kukushu pamǝpamǝu, ja vǝr highiɓǝ anǝ nji. ");
INSERT INTO mfm_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kǝ vanyi ndǝ yiwa nyi, ji na, “Thlagǝu, nji kushu wacu ngu nda uya mbǝɗǝ ya?” Yesu na anǝ nda, ");
INSERT INTO mfm_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Hya nǝrdzau aga hya gwa lagu miyar gwa kǝra ciciɗǝ nǝ tǝlkur Hyal, arya nji gangǝ wu nda yiwu nda gwa, ama nanda sǝn gwa mai. ");
INSERT INTO mfm_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ma thlagǝr ki hyaˈari ji haɗiya miya ki nyi, hyu nda taˈyi a biya, hyu tsa hyu kǝdiyau, hyu na, ‘Thlagǝr ki, pahǝna ˈya miya ki.’ Ama ju nda shaɗǝwa nda, ‘Nayi wu sǝni hyi mai ǝnga vi kǝra hyi dla sara ndari.’ ");
INSERT INTO mfm_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hya dzǝgwa na ja, ‘Namǝn ngǝ sǝm ǝnga sa ǝkkǝˈyi gǝ ta, ǝnga tsu a highiɓǝr gu mǝlmǝr ˈya.’ ");
INSERT INTO mfm_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ama ju ɓǝra na ja, ‘Nayi wu sǝni vi kǝra hyi dla sara ndar mai. Kwaya mǝ wu dzǝ ɗa, nahyi nji ɗǝmwaˈyi hangǝkal!’ ");
INSERT INTO mfm_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ar pǝci kǝra hyu nda lari Ibrahimu, ǝnga Ishaku, ǝnga Yakubu, ǝnga patǝr nabiˈyar wu tǝlkur Hyal, ama nahyi nǝr hyi a kǝdlǝna hyir nji, ǝnggau, nga hyu nda tiwi ǝnga hyu ɗǝ hira hyi. ");
INSERT INTO mfm_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nju nda shili sara wu lagu Sǝbiyar pǝci, ǝnga Gwa tǝɗǝ pǝci, ǝnga Gya vuya, ǝnga Dǝ Fwahǝu, ndu sa nggya nǝ sǝm sǝr sǝm nǝ mini wu tǝlkur Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ar pǝci ta, alenyi njira wu yukuɗǝ ndu nda sha a dumwa, nji nǝ tanggǝrma wu nda ɗa njir yukuɗu, ǝnga njir yukuɗǝ tsu ndu nda ɗa nji tanggǝrma.” ");
INSERT INTO mfm_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ar pǝci kǝ ngǝ alenyi njir Farisi shili ǝgya Yesu ndǝ na anǝ nyi, “Hyaˈari ga kwaya ǝnggau, arya Hirudusu ju yiwu ja tsǝya ngau.” ");
INSERT INTO mfm_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kǝ ji na anǝ nda, “Hya nar nyi anǝ hya tagǝ kǝ abǝr, ǝshina yu kǝdlǝ mambǝl ɗǝmwaˈyu, ya ɓǝra shilǝgǝbiya nji, ǝzǝgǝ ma abangau, caɓcikǝ zǝgǝu, nga yu sa kuɗǝna thlǝr ɗa. ");
INSERT INTO mfm_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ama yu dumwa ǝnga ɓǝ ǝshina, ǝzǝgǝu, ǝnga caɓcikǝ zǝgǝu, arya aˈyi ɗa tsaˈa anǝ nabi ja tǝ a biyar ya Urshalima mai. ");
INSERT INTO mfm_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Urshalima, Urshalima! Ndǝr tsa nabiˈyar, ǝnga ndǝr vavaka njira Hyal sǝwa ngǝ a shili ǝnga tsǝka kǝl ta gǝ dlǝna nda! Aga yiɗau nga yu yiwu ya fǝri tsa yi ar dza nji ngǝ pata, ǝnggǝr kǝra miya tǝka wu tsǝm wazha nyi ǝgya ja, ama nahyi piyari ɗa mai! ");
INSERT INTO mfm_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kǝ ja nju nda piyari hyi kir hyi dzafu! Yu na anǝ hyi tsu, nahyi tsu ɓǝra lar ɗa mai, kǝl pǝci kǝra hyu nda na, ‘Ndǝr barka ngǝ ndǝra dla wu thlǝmǝr Thlagǝu!’ ” ");
INSERT INTO mfm_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Vanyi pǝcir Ɓǝlsar, ǝnggǝra Yesu maˈyi a nda sǝm sǝr sǝm wu ki ndǝ dǝgal nǝr Farisi, nji gangǝu pǝnggǝri nyi li. ");
INSERT INTO mfm_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kǝ vanyi ndǝ kǝra ǝnga hyi ǝnga tsi fifi shili ǝgya Yesu. ");
INSERT INTO mfm_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kǝ Yesu yiwa malǝmǝ dlaɗǝˈyar ǝnga njir Farisi, ji na, “A ɗar tsaˈa nja shilǝgǝbiya ndǝ ar pǝcir Ɓǝlsar, ǝndǝga awau?” ");
INSERT INTO mfm_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ama kǝ ndǝ nggya zǝmǝu. Ənggau, kǝ Yesu fǝr tsa ja ar ndǝ kau, kǝ ji shilǝgǝbiya nyi, ji dzǝgwa na anǝ nyi ja maˈyi sǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ənggǝ ngǝ Yesu dzǝgwa yiwa nda, ji na, “Mi nga hyu mǝl ma kwara ǝndǝga thlar hyi tǝɗǝ a gu mǝla pǝcir Ɓǝlsar, aˈyi hyu hǝbiya nyi a biya ǝnga kusa wa?” ");
INSERT INTO mfm_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kǝ ndǝ tini sǝra nda na ar kǝra yiwa sǝ kau. ");
INSERT INTO mfm_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ənggǝra Yesu lari wu pama alenyi nji kǝra nji ngga aga sǝm sǝr sǝm a vǝr gal vir nggya nji dǝdǝgal anǝ Kǝrnda, kǝ Yesu nar nda najaka karapau, ");
INSERT INTO mfm_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ma nji ngga ngau a ndar vir hǝ dzau, a sara ga nda hǝ vir nggya nji dǝdǝgal tanggǝrma mai, ara ma vanyi a nggar nji ndǝra ndiya ngǝ ǝnga dǝgalǝu. ");
INSERT INTO mfm_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Naja ndǝra ngga hyi gyapǝu, ju sǝn na anǝ ngau, ‘Hyaˈari, ga nǝ nyi vir nggya anǝ ndǝ kau.’ Ənggau, sǝli wu mbari ngau, ara gu sha a gyar vir nggya kǝra a gya banga ta. ");
INSERT INTO mfm_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ama ma nji ngga ngau a ndar vir mini, ma gǝ shili, ga gal vi kǝra a biyar ya nji kǝra gǝra nji nǝ nyi dǝgalkur ba ga nggya ǝna, aga ma ndǝ kǝ ngga ngǝ kǝ shili, ju sǝni na anǝ ngau, ‘A ndau ǝnggau, bazhi ɗa, ga nggya ar vi kǝra nji fiya nyi anǝ nji dǝdǝgal kau.’ Kǝ ngu nda mǝliya alenyi nji kǝra nji ngga hyi ǝkkǝˈyi nda, nda nǝ ngǝ dǝgalkur. ");
INSERT INTO mfm_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Arya ndǝra hǝri kǝrnyi ar viya sǝ tsapǝu ba nja tina nyi a gya, ama ndǝra tina kǝrnyi a gya, ba nja hǝri nyi adabanga nji.” ");
INSERT INTO mfm_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kǝ Yesu na anǝ ndǝ kǝ ngga nyi kau, “Ma gǝ ngga nji aga sa sǝm sǝr sǝm, ǝnga shili wu mini, ga sara ngga bazhi ngǝˈyar, ǝnga zamǝ ngǝˈyar, ǝnga nji gǝ hyi, ǝnga tǝwul ngǝˈyar njira ǝnga gǝnna waci mai, aga vanyi pǝci nanda ma nda ngga ngǝ tsu. Agabangǝ ndu sǝn kina ngǝ sǝra gǝ mǝliya nda. ");
INSERT INTO mfm_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ama ma gu ngga nji aga mini, ngga nji tǝtǝ dǝnama, ǝnga nji kukurɓǝu, ǝnga nji tǝsǝkǝnu ǝnga lǝfǝˈyar. ");
INSERT INTO mfm_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Lagu kǝ nga gu uya barka, ara nandǝ wu sǝn kina ngǝ sǝra gǝ mǝliya nda mai. Hyal ǝnga kǝrnyi ngu nda kina ngau, ar pǝci kǝra njir mǝl thlǝr mǝnahǝu, ǝnga jirkur wu nda hyaˈari sarar vir tau.” ");
INSERT INTO mfm_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ənggǝra ndǝ nggari sǝ kau, kǝ pathlǝ wu pama njira vir nggya ǝnga Yesu ar vir sǝm sǝr sǝm na anǝ nyi, “Ndǝr barka ngǝ ndǝra wu nda sǝm sǝr sǝm nǝr mini nǝr tǝlkur Hyal.” ");
INSERT INTO mfm_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kǝ Yesu na anǝ nyi, “Vanyi ndǝ saya ɗa kǝra wu yiwu ja tsǝmiya nji aga sǝm sǝr sǝm nǝr mini dǝgalǝu, kǝ ji nggari nji gangǝu. ");
INSERT INTO mfm_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ənggǝra pǝcir mini kǝ ɗa, kǝ ji sǝwa mafa nyi aga ja maˈyi ja nda nar nyi anǝ nji kǝra ji ngga, ‘Anda mau, arya a fuwar nji kalar sau wu lagu!’ ");
INSERT INTO mfm_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ama kǝ patǝkura nda dzǝgwa na sǝra ɗa nanda aˈyi sǝni shili mai. Ndǝ tanggǝrma na, ‘Dzǝgwa ɗǝlbiya fa nga yau, a ɗar tsaˈa ya mai ya nda lari. Usi mǝliya ɗa mba ɗǝfu.’ ");
INSERT INTO mfm_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kǝ vanyi ndǝ na, ‘Dzǝgwa ɗǝlbiya nga yi thla zǝwa pamǝpamǝ tǝfu, ar lagu nga yi kabangǝkǝ aga ya nda dzǝguya thlǝr nga nda, yu kǝdi ngau, nǝ ɗa lagu.’ ");
INSERT INTO mfm_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Kǝ vanyi ndǝ ɓǝra na, ‘Dzǝgwa hǝ mala nga yau, agabangǝ na ya sǝni uya lagu shili mai.’ ");
INSERT INTO mfm_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Kǝ mafa kǝ sha shili ji sa nar nyi anǝ thlagǝri ki nyi sǝˈyar kǝ ndǝ na kau. Kǝ hu ɗa thlagǝri ki nyi ndzǝ gagaɗau, ji dzǝgwa na anǝ mafa nyi, ‘Maˈyi a ndu mǝlmǝˈyar kau kukusa, ga nu lagu dǝgal ǝnga lagu kushu ga nggari ɗa nji tǝtǝ dǝnama, ǝnga nji kukurɓǝu, ǝnga lǝfǝˈyar, ǝnga nji tǝtǝ dzau, ga shili ǝnga nda ǝnggau.’ ");
INSERT INTO mfm_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ənggǝrna, mafa nyi a shiliri ji na, ‘Thlagǝu, sǝra gǝ na patǝ a mǝliya ri nji, ama tsu vi gangǝu kǝra gǝra nyau.’ ");
INSERT INTO mfm_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kǝ thlagǝri ki ɓǝra nar nyi anǝ mafa nyi, ‘Ɓǝra maˈyi a biyar ya mǝlmǝ a ndar lagu dǝgalˈyar ǝnga kusha nyi ga nggari kalar ndǝra gǝ lari aga ki ɗa sa nyau. ");
INSERT INTO mfm_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ya nar hyi, alaga zǝma njira nji ngga tanggǝrma ta a nda uya nda ɗar sǝ kǝ nji mǝliya aga mini kǝ mai.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Vanyi pǝci nji gangǝu a vǝr nu Yesu, kǝ ji shabiya dzǝ ji na anǝ nda, ");
INSERT INTO mfm_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kalar ndǝra shili aga ja nu ɗa, ma naja aˈyi cabiya ɗa yiwukur a ndiya anǝ dǝnyi, ǝnga mǝnyi, ǝnga mala nyi, ǝnga wazha nyi, ǝnga zamǝ nyiˈyar ǝnga kwamǝ nyiˈyar, ǝkkǝˈyi piya ja ǝnga kǝrnyi mai, naja sǝni ɗa zǝmbǝlma ɗa mai. ");
INSERT INTO mfm_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kalar ndǝra gǝra hǝri wu dladlakǝ nyi, ja dzǝgwa nu ɗa, aˈyi ja kyaga ɗa nǝɗa mai. ");
INSERT INTO mfm_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Kǝja karapǝ, ma zǝma hyu yiwu ja hǝriya umbwa dzǝgamǝ a dǝmǝlmau, aˈyi ju nggya kwatahǝu, ja tsambiya sǝra hǝri kǝ wu mbari, aga ja tsamiya tara sǝra ara ja a sǝni kuɗǝna hǝra nyi wa? ");
INSERT INTO mfm_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ma naja aˈyi mǝl abangǝ mai, ma hǝri kǝ taˈyi wu lagura ghar gǝnna, patǝr njira wu nda tǝrabiya wu lagu ta ndu nda nggushi nyi, ");
INSERT INTO mfm_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","nda dzǝgwa na, ‘Lari ndǝ kǝ ji dzǝguya hǝri ama naji sǝni kuɗǝna mai.’ ");
INSERT INTO mfm_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Abangǝ tsu ma tǝl kǝra ǝnga njir pa nyi dubu kumou, ju yiwu ja hǝ pa a nda nǝ tǝl kǝra ǝnga njir pa nyi dubu mǝthlǝ kumunyi, aˈyi ju nggya kwatahǝu, ja tsamiya tara dǝnama nǝ pana nji kǝ aˈyi ara ja wa? ");
INSERT INTO mfm_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ma ji lari abǝr naja sǝni mbari mai, tsu nda naɗǝ ju sǝwa njir sǝ nyiˈyar aga nda ɓasǝwa nda nggya jamǝu. ");
INSERT INTO mfm_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Abangau nga nyi tsu ma ndǝra aˈyi piyari sǝra ara ja patǝ mai, naja sǝni ɗa zǝmbǝlma ɗa mai.” ");
INSERT INTO mfm_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Unau sǝ mǝsahǝu ngau, Ama ma unǝ caɓǝnakǝr, abar nga ju sǝn shabiya kǝrnyi a shila? ");
INSERT INTO mfm_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tsu ja sǝn ɗa mǝnahǝ mai, alaga aga gwaɓa, kǝl ba nja pǝna wacu. Ndǝra ǝnga himi ngga, ja nggari.” ");
INSERT INTO mfm_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ənggǝra njir tsǝm budau ǝnga alenyi “njir bikau” A vǝr shili aga nda ngga highiɓǝ nǝ Yesu, ");
INSERT INTO mfm_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","kǝ njir Farisi ǝnga malǝmǝ dlaɗǝˈyar dzǝguya jiga miya nda vǝr na, “Lari gǝyi! Ndǝ kǝ a shabiya ri ja kǝrnyi bazhiya njir bikau, ǝkkǝˈyi sǝr sǝm nga ju sǝm ǝnga nda.” ");
INSERT INTO mfm_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kǝ Yesu nar nda najaka karapau: ");
INSERT INTO mfm_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nja na zǝma hyi ǝnga tǝmahǝu gharu, kǝ zǝma nyi sanakǝr, aˈyi ju piyari ǝdlǝkumunyi apǝ ǝdlau ar vir ɓǝlari nda, ja maˈyi a nda gal kǝra sa kǝ wa? ");
INSERT INTO mfm_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Maja nǝr nyi ri, hu ɗa ja wu pida, ja dzǝgwa fǝri nyi ar papadla ja, ");
INSERT INTO mfm_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ja hǝri nyi a ndu ki, ja dzǝgwa ngga bazhi nyiˈyar ǝnga njira ju nggya ǝnga nda, ju na anǝ nda, ‘Dlǝwa ɗa mau ǝnga caguli ara a nǝr yau tǝmahǝu ɗa ta sa ta!’ ");
INSERT INTO mfm_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ya vǝr na anǝ hyi, abangau nga nju caguli a dǝmǝlmau ma ndǝ zǝmǝ tubi, a ndiya nji cicau ǝdlǝkumunyi apǝ ǝdlau, kǝra gǝra ɓǝra yiwu tubi.” ");
INSERT INTO mfm_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Nja na tsu, mala ǝnga kwaɓa nyi kumou, kǝ zǝma nyi sa, mi nga hyu nggani ju nda mǝla? Aˈyi ju mbǝbiya uˈu wu pitǝlla ja dzǝgwa tsǝkǝbiya ki kǝ ǝnga hangǝkal kǝl ji nǝr wa? ");
INSERT INTO mfm_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Maja nǝr kwaɓa kau, ju ngga bazhi nyiˈyar ǝnga tǝwul nyiˈyar, ju na, ‘Dlǝwa ɗa mau ǝnga caguli, ara a nǝr yau kwaɓa ɗa kǝra sa ta.’ ");
INSERT INTO mfm_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Abangǝ tsu yu nar hyi, sǝr caguli ngau anǝ waladiˈyar nǝ Hyal ma ndǝ zǝmǝ ndǝr bikau tubi.” ");
INSERT INTO mfm_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kǝ Yesu dumwa ǝnga ndǝr ji na, “Vanyi ndǝ aˈyi ɗǝɗǝmǝu kǝra ǝnga wazha mǝthlǝu. ");
INSERT INTO mfm_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Zǝr kǝra kushu wu pama nda na anǝ dǝrnda, ‘Tada, nǝ ɗa nji kabangǝkǝ sǝra wu ɗa nǝ ɗa ma ga tǝri.’ Kǝ dǝnyi tǝkǝya nda sǝr fa ki. ");
INSERT INTO mfm_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ayukuɗa pida kushu, kǝ zǝr kǝ faˈari sǝra ɗar nǝ nyi patǝu, ba ji piyari ki. Kǝ ji maˈyi a ndu vanyi mǝlmǝ kǝra a biyar ya ˈyiˈyir nda. A ndǝna kǝ ji tsǝya sǝra ara ja patǝ a ndu nggya nǝ pǝpǝltǝkur. ");
INSERT INTO mfm_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ayukuɗa a tsiyari ja sǝra ara ja patǝu, kǝ wuɓau ɗǝmwaˈyi gagaɗau shili wu mǝlmǝ kau, naja tsu a gwar ja wu ɓwaɓwatǝ ara tsu sǝ nyi aˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kǝ ji maˈyi a nda gal sǝr mǝl ara ndǝr mǝlmǝ kau, kǝ ndǝ kǝ sǝwa nyi a nda ɓǝla fǝshiu nyi. ");
INSERT INTO mfm_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ju gal sǝr sǝm fǝshiu kǝ aga ja sǝmku, ama ndǝr nǝ nyi aˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ənggǝra ji shili wu hangǝkal nyi, kǝ ji na, ‘Kǝja njir mǝl thlǝr anǝ dǝɗa a vǝr tǝtǝl ǝnga sǝr sǝm, nayau ǝtsu a vir tau ǝnga wuɓau ǝnggau! ");
INSERT INTO mfm_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yu hyaˈari yu sha a ndara dǝɗa ya nda nar nyi, “Tada, a mǝliya ri yau bikau anǝ Hyal, ǝnga anǝ ngau. ");
INSERT INTO mfm_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nayi ɓǝra ɗa tsaˈa nja ɓǝra ngga ɗa ǝnga zǝr ngǝ mai. Fiya ɗa ya ɗa ǝnggǝr pathlǝu wu pama njir mǝl thlǝr ngau.” ’ ");
INSERT INTO mfm_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kǝ ji hyaˈari ji maˈyi a ndara dǝnyi. “Ma tsu ja naɗǝu, kǝ dǝnyi tsamǝ ri nyi. Kǝ dǝnyi tǝhuɗǝ ǝgya ja, ji dzǝgwa hyaˈari ǝnga hwi, ji nda mbari zǝr nyi, ji dzǝgwa mbunggǝr nyi dzau. ");
INSERT INTO mfm_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kǝ zǝr nyi na, ‘Tada, a mǝliya ri yi bikau anǝ Hyal ǝnga anǝ ngau. Nayi ɓǝra ɗa tsaˈa nja ɓǝra ngga ɗa ǝnga zǝr ngǝ mai.’ ");
INSERT INTO mfm_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ama kǝ dǝnyi nggari mafa nyiˈyar, ji na, ‘Ənga kusa! Shila mau ǝnga lǝgutǝ mǝnahǝu, hya har nyi. Har nya mau shishiˈwu ǝnga ɓiɓi, ");
INSERT INTO mfm_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","nja ɓǝra dla ǝnga thla nggǝnggǝthlǝ ta aga nja tsǝya, aga mǝna sǝm, mǝna caguli. ");
INSERT INTO mfm_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Arya zǝr ɗa kǝ ɗǝɗǝmǝ tǝtǝ nga ja ama kabangǝkǝ a ɗar ja aˈyi ǝnga pi. Ɗǝɗǝmǝ sasa nga ja, ama kabangǝkǝ a nǝr nyir nji.’ Kǝ ndǝ gu caguli gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Wu pǝci kabangǝkau, zǝr dǝgal nyi kǝra maˈyi a gwa tagǝu, a vǝr si nga ja. Ənggǝra ji ɗa lǝhǝu, ba ji nggari nja vǝr tsa kangga, ǝnga nja vǝr fǝl. ");
INSERT INTO mfm_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kǝ ji nggari mafa ki kau, ji yiwa nyi sǝra a vǝr ɗa.” ");
INSERT INTO mfm_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Kǝ mafa kǝ na, ‘Mǝshikǝr ngǝ ta ngǝ shili, ca ngǝ dǝr hyi mǝliya nji tsǝya thla nggǝnggǝthlǝ ta ara zamǝ ngau sha shili wu ki jamǝu.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ama kǝ hu ɗa zamǝ nyi kǝ ndzǝ gagaɗau, kǝ ji nggǝl ara vu ki. Kǝ dǝrnda biya ji biya sǝsǝkuya nyi kǝr aga ja vu ki. ");
INSERT INTO mfm_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ama kǝ ji shaɗǝwa nyi anǝ dǝnyi ji na, ‘Lari gǝyi, wu patǝr faˈyar kau, ya vǝr mǝl thlǝr ǝnggǝr mafa, nayi saya nggǝl ara mǝl sǝra gǝ na mai, alaga abangau, nagǝ saya mbari alaga zǝr ku aga ya ngga bazhir ˈwa ɗaˈyar aga ˈya tsǝya ˈya sǝm mai! ");
INSERT INTO mfm_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ama ǝnggǝra zǝr ngǝ kǝ sha shili, ndǝra maˈyi ka nda tsǝya gǝnna ngau wu sǝsukur, kǝ gǝ dzǝgwa tsǝya nyi thla ta kǝra ndiya ǝnga nggǝnggǝthlau.’ ");
INSERT INTO mfm_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Kǝ dǝnyi na anǝ nyi, ‘Zǝr ɗa, alaga nuwa nga gǝ ǝnga yau, patǝr sǝra ara yau, nǝ ngǝ ngau. ");
INSERT INTO mfm_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","A ɗar tsaˈa mǝna caguli ǝnga huɗǝ pipida, ara zamǝ ngǝ kǝ a tǝri, kǝ ji ɓǝra sha shili ǝnga pi, ndǝ sasa nga ja, ama kabangǝkǝ a nǝr nyir nji.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu na anǝ zǝmbǝlma nyiˈyar, “Nji sayi mǝliya vanyi ndǝr bǝrba kǝra nǝ nyi kari nyi anǝ ndǝr dlǝwa nyi aga ja tsamǝ anǝ nyi. Wu yukuɗa nyi, kǝ nji shili ǝnga ɗahǝu anǝ nyi ǝnggǝra ndǝr dlǝwa nyi a vǝr ndza kari nyi. ");
INSERT INTO mfm_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kǝ thlagǝri ki kǝ ngga ndǝr dlǝwa nyi, ji na anǝ nyi, ‘Mi nga ya vǝr nggari ar kǝra gǝ ka? Shili ga nar ɗa ar kǝra sǝra gǝ mǝlna, ara tsu gu nda nggya ndǝr dlǝwa ɗa mai.’ ");
INSERT INTO mfm_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kǝ ndǝr dlǝwa nyi kǝ na wu ɗǝfuwa ja, ‘Thlagǝri ki ɗa wu nda kǝdlǝ na ɗa wu thlǝr, mi ya dzǝgwa mǝla? Kǝja na ya sǝni zǝwa mai, sǝli tsu wu tǝ ɗa ara kǝdiyau. ");
INSERT INTO mfm_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ənghǝng! A sǝni yi sǝra ya mǝl, aga nja nda dlǝwuri ɗa a vu kir nda, ma ji kǝdlǝ na ɗa wu thlǝr ɗa.’ ");
INSERT INTO mfm_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Kǝ ji ngga patǝr njira thlagǝri ki nyi a vǝr nu nda mǝl. Ji yiwa ndǝ tanggǝrma ji na, ‘Yiɗau ngǝ thlagǝri ki ɗa a vǝr nu nga?’ ");
INSERT INTO mfm_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ji na, ‘Tǝm nǝr mal gharu.’ “Kǝ ndǝr dlǝwa nyi kǝ na, ‘Hǝri lǝkakaɗǝ ngau, ǝnga kusa, ga tsǝfǝri tǝm tǝfu kumunyi.’ ");
INSERT INTO mfm_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kǝ ji nar nyi anǝ vanyi ndau, ‘Kari nagǝ tsu, yiɗau nga nju nu nga?’ Naja tsu kǝ ji na, ‘Kayiwa uhi gharu ngau.’ Ndǝr dlǝwa nyi kǝ na, ‘Hǝri lǝkakaɗǝ ngau, ga mǝliya ja ɗa buhu cisu kumunyi.’ ");
INSERT INTO mfm_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Kǝ thlagǝri ki ndǝr dlǝwa kǝra gǝra jirkur kǝ faliya nyi ara ji cabiya tsǝtsǝlkur. Arya njir najaka pǝci, a sǝni mǝl thlǝr ǝnga tsǝtsǝlkur nda a ndiya njir lagu mbǝmbǝl.” ");
INSERT INTO mfm_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu dumwa ji na, “Ya vǝr na anǝ hyi, hya mǝl thlǝr ǝnga gǝnnar hyi aga hya uya bazhi anǝ kǝrhyi. Lagu kǝ ngǝ ma thlǝr gǝnnar hyi a taˈyi ri, nju sa dlǝwuri hyi a vu ki nǝ kǝra gǝra kuɗau. ");
INSERT INTO mfm_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ma ndǝra nju sǝn fiyafǝ ǝnga ja wu sǝ kushu, nju sǝn fiyafǝ ǝnga ja wu sǝ dǝgal tsu. Ma ndǝ kǝra nji gǝra sǝn fiyafǝ ǝnga ja wu sǝ kushu, nju sǝn fiyafǝ ǝnga ja wu sǝ dǝgal tsu mai. ");
INSERT INTO mfm_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ma nahyi aˈyi mǝl thlǝr kǝra tsaˈa miya ɗǝfu ǝnga gǝnna nǝ duniya mai, wa ngǝ nda fǝr kǝr ǝnga hyi ja nǝ hyi gǝnna nǝ jirkura? ");
INSERT INTO mfm_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma tsu nahyi aˈyi mǝl thlǝr tsaˈa miya ɗǝfu ǝnga gǝnna ndǝ mai, wa nga nda nǝ hyi nǝr hya gǝnna?” ");
INSERT INTO mfm_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ndǝr sǝn mafakur anǝ thlagǝr ki pamǝpamǝ mǝthlǝ aˈyi mai, ara ju nda yiwu vanyi ba ja piyari vanyi ǝnga ju nda hǝya kǝr anǝ vanyi ba ja diɗana vanyi. Nahya sǝn daɓǝri nu Hyal ǝnga gal gǝnna mai.” ");
INSERT INTO mfm_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Njir Farisi njir yiwu gǝnna ngau, ǝnggǝra ndǝ nggari sǝra Yesu na ba ndǝ tsǝrauna nyi. ");
INSERT INTO mfm_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ama kǝ Yesu na anǝ nda, “Nahyi ngǝ njir yiwu hya canǝ nyi anǝ nji abǝr nji cici nga hyi. Ama Hyal ju sǝni ɗǝfuwa hyi. Sǝra nju lǝ dǝgalkur anǝ nda, nanda ngǝ didiɗi wu mwar Hyal.” ");
INSERT INTO mfm_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Kǝl ta Yahwana ndǝr mǝl Baɓǝtizǝma shili, highiɓǝ nǝ dlaɗǝ nǝ lagu Musa ǝnga nǝ nabiˈyar ca ngǝ ǝnga nju mǝl thlǝr ǝni. Ama dzǝguya ǝnga Yahwana ndǝr mǝl Baɓǝtizǝma, ǝnggǝra nji tǝtǝlna ndǝshigu mǝsahǝu nǝ tǝlkur Hyal, kalar ndau a vǝr gal lagu aga ja ɗa a gwa. ");
INSERT INTO mfm_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Dǝmǝlmau ǝnga gyuˈyi a sǝni sanakǝr, a ndiya sǝ ǝnggǝr camwaɗi wu ndǝr zǝmǝ sara wu dlaɗǝ nǝ lagu Musa a tǝɗau a gyuˈyi. ");
INSERT INTO mfm_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ndǝra kǝdlǝna mala nyi, kǝ ji hǝr vanyi mala, ndǝr dlǝnga mala ngau. Ənga tsu sal kǝra hǝri mala kǝra sal nyi kǝdlǝna ndǝr dlǝnga mala nga ja.” ");
INSERT INTO mfm_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Vanyi ndǝr gǝnna aˈyi kǝra wu ha kari nǝ gǝnna gangǝu pamǝpamǝu, ǝnga ju sǝm sǝr sǝm mǝsahǝu kalar pǝci. ");
INSERT INTO mfm_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","A biya miya ki nyi, vanyi ndǝr kǝdi aˈyi kǝra nja ngga ǝnga Liyazaru, ǝnga dza ja patǝ ǝnga mbǝlgǝu. Nju shili ǝnga ja, nja sa pina nyi ǝna kalar pǝci. ");
INSERT INTO mfm_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Naja tsu ǝnga huɗǝ pipida ma ji sǝni uya alaga sǝra tǝɗau sara dar vir sǝm sǝr sǝm nǝ ndǝr gǝnna kau, patǝ ǝkkǝˈyi hya wu sa naɗǝ mbǝlgǝ nyi kau.” ");
INSERT INTO mfm_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Pǝci shili ba ndǝr kǝdi kǝ tau, kǝ waladiˈyar hǝri nyi ka nda fiya nyi ar vir nggya mǝnahǝu ǝnga Ibrahimu. Ətsu ba ndǝr gǝnna kǝ tau ba nji haɗǝna nyi. ");
INSERT INTO mfm_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ji thlǝwa kǝrnyi wu uˈur kǝtsa, ja vǝr sa ɓwaɓwatǝu. Ənggǝra ji hyaˈanakǝr a dǝmǝlmau, kǝ ji lari Ibrahimu naɗǝ nanda ǝnga Liyazaru. ");
INSERT INTO mfm_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kǝ ji ngga nyi, ji na, ‘Tada Ibrahimu, tǝhuɗǝ ǝgya yau, ga sǝwa Liyazaru aga ja fuwa zǝr tsa ja a gwu ˈyimi aga ja fǝri ar kyara yau ya nggari shishiˈwu, arya ya vir lari ɓwaɓwatǝ wu uˈu kau!’ ");
INSERT INTO mfm_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ama kǝ Ibrahimu na, ‘Zǝr ɗa, ga ɗǝngari ja, pǝci kǝra gu duniya, nagǝ ǝnga sǝ mǝnahǝu papatǝu, ama Liyazaru nǝ nyi a lari ja ɓwaɓwatǝu. Ama kabangǝkǝ pǝcir nggari mǝsahǝkur nyi ngau, ama nagau wu ɓwaɓwatǝ nga ngau. ");
INSERT INTO mfm_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kǝ ma mai, wu pama ˈya ǝkkǝˈyi hyi kaˈu dǝgal ǝnga dzǝgamǝ aˈyi, kǝra nji mǝliya ara nja sara vǝlna sara ndara hyi a shili ngau, alaga sara ngau a ndara hyi.’ ");
INSERT INTO mfm_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kǝ ndǝr gǝnna kǝ na, ‘Tada, ma abangǝ ja, yu kǝdi ngau, sǝwa nyi a ndu ki dǝɗa, ");
INSERT INTO mfm_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","arya zamǝɗaˈyar aˈyi tǝfu, ja maˈyi ja nda kughiya nda, a sara nda ɓǝra shili ngǝ ǝtsu, a shili wu ɓwaɓwatǝu.’ ");
INSERT INTO mfm_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ibrahimu shaɗǝwa nyi, ‘Zamǝ ngǝˈyar aˈyi nda ǝnga highiɓǝ nǝ Musa ǝnga tsǝfǝ nǝ nabiˈyar, nda sǝ himi sǝra ndu na.’ ");
INSERT INTO mfm_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kǝ ndǝr gǝnna shaɗǝwa nyi, ji na, ‘Awau, tada Ibrahimu, ma ndǝ hyaˈari sara vir tau ji sha ndara nda, ndu tubi.’ ");
INSERT INTO mfm_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ama kǝ Ibrahimu na, ‘Ma tsu nanda aˈyi nggari highiɓǝ Musa ǝnga tsǝfǝ nabiˈyar kǝ mai, alaga vanyi ndǝ hyaˈari sara vir tau, nanda sa sǝ himi anǝ nyi mai.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu na anǝ zǝmbǝlma nyiˈyar, “Sǝra wu daɓaga mǝliya nji nda mǝliya bikau aˈyi cumu. Ama sǝr tǝhuɗǝ anǝ ndǝra ju shili lagu nyi. ");
INSERT INTO mfm_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kuji anǝ nyi, nja mbiya bǝra ar fǝlanga ja, ba nja vakuwa nyi a gwar dǝl dǝgal a ndiya ja mǝliya zǝmǝ wu wazha yiɗiɗǝˈyar kǝ njir nu ɗa mǝliya bikau. ");
INSERT INTO mfm_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Hya tsamǝ sǝra hya mǝl ja. “Ma zamǝ ngau mǝliya ngǝ bikau, ga kughiya nyi, ma ji na a tubir yau, tǝfǝbiya nyi. ");
INSERT INTO mfm_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ma ji mǝliya ngǝ bikau pamǝpamǝ mǝɗǝfǝ wu pǝkǝ pathlǝu, kǝ ji ɓǝra sha shili ja vǝr na, ‘A mǝliya ngǝ ri yi bikau yafa ɗa,’ ba ga tǝfǝbiya nyi.” ");
INSERT INTO mfm_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kǝ cama sǝsǝˈyar kǝ na anǝ Thlagǝu, “Cakǝri mbǝrsar ˈya ja ɗa ǝnga dǝnama!” ");
INSERT INTO mfm_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kǝ Thlagǝ shaɗǝwa nda, ji na, “Ma mbǝrsa hyi aˈyi ǝnggǝr culi bǝla, gu sǝni na anǝ wu dǝgal kau, ‘Kucina kǝr ǝnggau ga ciya kǝr a gu tsadau,’ ju nda mǝl sǝra gǝ na.” ");
INSERT INTO mfm_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ma mafa ngǝ si sara a gwar vi zǝwa ǝnga sara vir ɓǝla, gu nda na anǝ nyi, ‘Usi ǝnga si! A ndau ga nggya, ga sǝm sǝr sǝm ya?’ ");
INSERT INTO mfm_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Awau, ngu nda na anǝ nyi, ‘Mǝliya ɗa sǝr sǝm nǝ wagǝu kwatahǝu, ga dzǝgwa tsǝrpǝri kǝrngau ba ga hǝri ɗa a shili ya sǝm ya sa, kadivira ga dzǝgwa sǝm ga sa nǝ ngau’ ");
INSERT INTO mfm_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Gu nda na usi anǝ mafa ngau ara ji mǝliya sǝra tsaˈa ja mǝl ya? ");
INSERT INTO mfm_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Abangǝ nga hyi tsu, ma hya mǝliya ri sǝra thlagǝr kir hyi nar hyi hya mǝl, hyu nda na, ‘Naˈya mafa ngǝ wacu. A mǝliya ri ˈya sǝra nju yiwu ˈya mǝl.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ənggǝra Yesu mbari lagu ja vǝr maˈyi a vu Urshalima, ndǝ dzǝgwa ɓau wu kǝl kǝra wu pama Samariya ǝnga Galili. ");
INSERT INTO mfm_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ənggǝra ja vǝr vu mǝlmau, kǝ njir pibi kumo thlǝwa nyi. Ndǝ taˈyi tuwara tsalǝu, ");
INSERT INTO mfm_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ndǝ dzǝgwa ngga ǝnga ɗahǝu dǝgalǝu, “Yesu ndǝ dǝgalǝu! Ga tǝhuɗǝ ǝgya ˈya!” ");
INSERT INTO mfm_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ənggǝra Yesu lari nda, kǝ ji na anǝ nda, “Ma ˈya mau hya nda canǝ nyi kǝrhyi anǝ pubu.” Kǝ ndǝ maˈyi, ar lagu ba ndǝ ɗa jamǝu. ");
INSERT INTO mfm_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pathlǝ wu pama nda, lari abǝr a ɗar ja jamǝu, kǝ ji sha shili, ja vǝr fal Hyal ǝnga ɗahǝu dǝnama gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ji ɓǝliya undi a dumwar Yesu, ja vǝr usa nyi. Naja tsu ndǝr Samariya ngau ndǝra nji diɗana. ");
INSERT INTO mfm_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kǝ Yesu yiwa, “Aˈyi nji kumo nga nji mǝliya jamǝ wa? Əmani ngǝ alenyi nji ǝdlǝ ka? ");
INSERT INTO mfm_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mi ngǝ ɗa kǝl mǝthlǝpi kǝ ngǝ sha shili ja sa cabiya usaku nyi anǝ Hyala?” ");
INSERT INTO mfm_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesu dzǝgwa na anǝ nyi, “Hyaˈari ga maˈyi sǝ ngau, mbǝrsa ngau a mǝliya ngǝr jamǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Alenyi njir Farisi yiwa Yesu pǝci kǝra tǝlkur Hyal wu nda shili, kǝ ji na anǝ nda, “Shiliri tǝlkur Hyal aˈyi ǝnga li ǝnga nju nda tsamiya mai, ");
INSERT INTO mfm_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ndǝr nda na tsu, ‘Kǝja ja,’ ǝnga ‘Wa ta ja,’ aˈyi mai, arya tǝlkur Hyal wu pama hyi nga ja.” ");
INSERT INTO mfm_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kǝ Yesu dzǝgwa na anǝ zǝmbǝlma nyiˈyar, “Pǝci a vǝr shili kǝra gu nda yiwu ga lari zǝma pǝci nǝ Zǝr Ndau, ama na ga nda lari mai. ");
INSERT INTO mfm_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nju nda na anǝ hyi, ‘Wa ta ja a ndǝna,’ ǝnga tsu ‘Kǝja ja ǝnggau.’ Ama hya sara maˈyi hya nda tsamǝ nyi mai. ");
INSERT INTO mfm_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ənggǝr sǝm nǝ par kǝra wu cabiya mbǝl nyi ar kuɗiyar mǝlmǝ baˈanǝ vanyi kuɗiyar mǝlmǝ kǝra kalar ndau wu lari, abangǝ shiliri Zǝr Ndau wu nda ɗa. ");
INSERT INTO mfm_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ama tanggǝrma kǝl ji lari ɓwaɓwatǝ gagaɗau kwatahǝu ǝnga tsu nji kabangǝkǝ nda piyari nyi. ");
INSERT INTO mfm_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ənggǝra ji ɗa ar pǝcir Nǝhu, abangǝ nga nyi wu nda ɗa ar pǝcir shilǝr Zǝr Ndau. ");
INSERT INTO mfm_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nji nggya kǝl sǝm sǝr sǝm ǝnga sa sǝ sasa, ndu faˈa mathlǝkǝˈyi ǝnga ndu lǝ kuˈyi anǝ shili, baˈanǝ shili ar pǝci kǝra Nǝhu gwu kwambwal dǝgal ta ari. Kǝl ta dǝl shida ba ji kuɗǝna nji patǝu. ");
INSERT INTO mfm_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Abangǝ nga nyi ɗa tsu ar pǝcir Lotu. Nji kǝl sǝm, ǝnga sa, ndu ɗǝl ǝnga ɗǝlna, alenyi nji kǝl thlǝka sǝ pamǝpamǝ ǝnga hǝr ki. ");
INSERT INTO mfm_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ama pǝci kǝra Lotu piyari Sodomu, kǝ uˈu ǝnga hakil uˈu shida sara dǝmǝlmau ba ji dlǝna nda patǝu. ");
INSERT INTO mfm_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Tangǝ ǝnggǝr ta nga nyi wu nda ɗa ar pǝcir shilǝr Zǝr Ndau. ");
INSERT INTO mfm_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ar pǝci ta, ndǝra a dar kǝra umbwa, ja sara gya ja vu ki aga vuwa hǝ sǝ mai, ara ja sara sana pǝci.” “Ndǝra a gwa tagǝ tsu, ja sara sha a su ki aga sa hǝ kar ha nyi mai. ");
INSERT INTO mfm_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Hya ɗǝngari sǝra ɗa ǝnga mala Lotu! ");
INSERT INTO mfm_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kalar ndǝra wu yiwu piya ja, ju nda tini. Ndǝra gǝra yiwu piya ja arya yau, ju nda uya. ");
INSERT INTO mfm_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yu nar hyi ja, pǝci kǝra sǝ kǝ wu nda ɗa, nji mǝthlǝ a vǝr pida ar sǝr pida zǝmǝ ba nja hǝri zǝmǝ ba nja piyari vanyi. ");
INSERT INTO mfm_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mathlǝkǝˈyi mǝthlǝ a vǝr au ar ɓǝra, ba nja hǝri zǝmǝ ba nja piyari vanyi.” ");
INSERT INTO mfm_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kǝ zǝmbǝlma nyiˈyar yiwa nyi, ndǝ na, “Thlagǝu, ǝman na?” Kǝ ji shaɗǝwa nda, ji na, “Ma vi kǝra sǝ tǝtǝ ari ǝna ngǝ kwadǝgǝu wu daɓau.” ");
INSERT INTO mfm_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu nar nyi najaka karapǝ anǝ zǝmbǝlma nyiˈyar aga ja highiɓǝri nda aga nda dumwa ǝnga ndǝr anǝ Hyal parangǝ, a sara nda hǝɗa mai. ");
INSERT INTO mfm_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ji na, “Wu vanyi mǝlmǝ vanyi ndǝr pathla aˈyi kǝra gǝra hivǝr Hyal ǝnga kǝra gǝra tal nji. ");
INSERT INTO mfm_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wu mǝlmǝ kǝ vanyi malatǝsal aˈyi kǝra a vǝr shili parangǝ ǝgya ndǝr pathla ja vǝr kǝdi nyi ju na, ‘Dlǝwari ɗa ga nǝ ɗa sǝra tsaˈa aga nǝ ɗa a dumwar dawa ɗa.’ ");
INSERT INTO mfm_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tanggǝrma ba ji nggǝl, ama wu yukuɗǝ kǝ ji na wu ɗǝfuwa ja, ‘Alaga kǝ aˈyi yu hivǝr Hyal mai, nayi tsu wu tal nji mai, ");
INSERT INTO mfm_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ama ara ǝnggǝra mala kǝ ɓwanǝ ɗa kǝr ǝnga shili ar kǝr ar kǝr, yu nǝ nyi sǝra ju yiwu kau, a sara gangǝkura shili nyi kǝ a nda nǝ ɗa hǝɗa!’ ” ");
INSERT INTO mfm_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kǝ Thlagǝ na, “Nggara mǝ ja sǝra ndǝr pathla kǝra gǝra jirkur kǝ na! ");
INSERT INTO mfm_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kǝ hyi nggani, Hyal a yiwu nda nǝ nyi sǝra tsaˈa anǝ nji nyi kǝra ji ɗǝmbiya kǝra wu tiwi anǝ nyi vuˈyi ǝnga puci sǝra ndu kǝdi wa? Naja ˈyi wu nda dlǝwari nda ǝnga kusa wa? ");
INSERT INTO mfm_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yu na anǝ hyi, ju nda nǝ nda sǝ tsaˈa kǝra ndu kǝdi kukusa. Ama ma Zǝr Ndau wu nda sha shili, wu sa thlǝwa ja njir mbǝrsa wu duniya kǝ ya?” ");
INSERT INTO mfm_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu na najaka karapǝ anǝ njira hǝri Kǝrnda abǝr nji tsapǝu nga nda, nda dzǝgwa diɗana alenyi nji. ");
INSERT INTO mfm_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ji na, “Nji sayi mǝliya nji mǝthlǝ kǝra maˈyi a gwu ki Hyal aga nda gwa ndǝr ǝnga Hyal. Pathlǝ wu pama nda ndǝr Farisi, ǝnga vanyi ndǝ kǝ ndǝr tsǝm budau. ");
INSERT INTO mfm_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Kǝ ndǝr Farisi hyaˈari ji taˈyau, ji dzǝguya ndǝr anǝ Hyal ja vǝr na, ‘Hyal, a usa ngǝ ri yau ara nayau aˈyi ǝnggǝr alenyi nji mai, njir hǝl, njir dlǝrbau, nji sǝsu. Nayi tsu aˈyi ǝnggǝr ndǝr dlǝwu budǝ kǝ mai. ");
INSERT INTO mfm_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yu hǝ zǝmǝtsini mǝthlǝ wu sugu, yu hǝbiya pathlǝu wu sǝ kumo patǝ kǝra yi uya.’ ");
INSERT INTO mfm_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ama kǝ ndǝr dlǝwu budǝ kǝ taˈyu naɗǝu, naja aˈyi ɗa tsaˈa ja hyaˈana liya ja a dǝmǝlmǝ mai, kǝ ji cabiya tǝtǝwakur nyi, ja vǝr na, ‘Hyal, tǝhuɗǝ ǝgya yau, nayi ndǝr bikau!’ ” ");
INSERT INTO mfm_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu na, “Yi wu na nǝ hyi, ndǝr tsǝm budau, ji sha a ndu ki nyi gǝra bikau wu mwar Hyal, aˈyi ǝnggǝr ndǝr Farisi mai. Arya kalar ndǝra hǝri kǝrnyi, nju nda hǝya nyi. Ama ndǝra hǝya kǝrnyi, nju nda hyaˈana nyi.” ");
INSERT INTO mfm_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Alenyi nji shili ǝnga wazha aga Yesu a fǝnggǝr nda barka. Ənggǝra zǝmbǝlma nyiˈyar lari abangau, ba ndǝ tsa ar kǝra nda. ");
INSERT INTO mfm_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ama kǝ Yesu ngga wazha, ji na, “Piyara mau wazha yiɗǝɗǝ nda shili ǝgya yau. Hya sara ka nda mai. Arya, tǝlkur Hyal anǝ nji ǝnggǝr nanda nga nyi. ");
INSERT INTO mfm_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ənga jiri yu na anǝ hyi, kǝmir ndǝra gǝra dlǝwuri tǝlkur Hyal ǝnggǝra zǝr kushu wu dlǝwu, naji wu sǝn vwagwa mai.” ");
INSERT INTO mfm_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Vanyi ndǝr tǝɗǝmwa nǝ Yahudiya yiwa Yesu ji na, “Malǝmǝ, ndǝ mǝnahǝu, mi nga ya mǝl ya uya pi gǝra kuɗa?” ");
INSERT INTO mfm_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Kǝ Yesu na anǝ nyi, “Ara mi gu ngga ɗa ndǝ mǝnaha? Ndǝ mǝnahǝ aˈyi mai kǝl Hyal wacu. ");
INSERT INTO mfm_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A sǝni gau sǝra dlaɗau cabiya, ‘Ga sara tsa ndǝ mai. Ga sara mǝl sǝsukur mai. Ga sara hǝl mai. Ga sara thla fati ar kǝra ndǝ mai. Ga sara dlǝrbǝ ndǝ mai. Ga gǝnggǝr nyi sǝli anǝ dǝngǝ ǝnga mǝngau.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kǝ zǝr baduwari ta na anǝ nyi, “A ɓǝlar yi sǝˈyar kǝ patǝ tsu yi zǝr kushu. Mi ngǝ sǝra hya?” ");
INSERT INTO mfm_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu nar nyi, “Sǝ zǝm wacu ngǝ hyau anǝ ngau, ma gu yiwu ga ɗa ndǝ tsapǝu, ga maˈyi ga nda ɗǝlna patǝr sǝra ara gau, ba ga tǝkǝna gǝnna nyi anǝ nji ɗaɗali, gu uya akkǝri a dǝmǝlmau. Ba ga dzǝgwa shili aga ga sa nu ɗa.” ");
INSERT INTO mfm_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ənggǝra ji nggari abangau kǝ zǝr baduwari kǝ ndalǝr bama, kǝ ji maˈyi ǝnga huɗǝ ndzǝndzau, ara naja ndǝr bǝrba gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ənggǝra Yesu lari ɗǝfuwa ja a ndzǝ ri, kǝ ji na, “Wu nda ɗa dzadzau gagaɗau anǝ njir gǝnna nda gwu tǝlkur Hyal! ");
INSERT INTO mfm_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Arya wu nda ɗa ɓatsǝ anǝ dlǝgwam ja tǝrabiya wu liya libǝra, a ndiya ndǝr gǝnna ja vu tǝlkur Hyal.” ");
INSERT INTO mfm_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Njira nggari ndǝr kǝ ndǝ yiwa nyi, ndǝ na, “Ma abangǝ nga nyi, wa ngu sǝn uya mbǝɗa?” ");
INSERT INTO mfm_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu na, “Sǝra gǝra sǝn ɗa ngau, anǝ ndau, ama anǝ Hyal ɓatsu.” ");
INSERT INTO mfm_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kǝ Biturusu shaɗǝwa, ji na, “Kǝja ˈya piyari sǝ patǝ ˈyi nu ngau.” ");
INSERT INTO mfm_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu shaɗǝwa nyi, ji na, “Wu sǝn yau abangǝ, yu nar hyi jirkura nyi tsu, kalar ndǝra piyari ki ǝnga zamǝˈyar, ǝnga kwamǝˈyar, ǝnga tada ǝnga ama ba ǝkkǝˈyi wazha ǝnga fa arya tǝlkur Hyal ");
INSERT INTO mfm_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ju nda uya gangǝu a adabanga sǝˈyar kǝ ji piyari ǝnggau wu duniya kau, wu duniya kǝra wu shili kǝ tsu pi kǝra kuɗau.” ");
INSERT INTO mfm_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kǝ Yesu hǝri zǝmbǝlma nyiˈyar kumo apǝ mǝthlǝ a ndar batiti, ji na anǝ nda, “Kǝja, mǝn wu mai a vu Urshalima, vi kǝra sǝra nabiˈyar tsǝfǝri ar kǝra Zǝr Ndau wu nda nyabiya dzau. ");
INSERT INTO mfm_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nju nda lǝri nyi anǝ njira aˈyi njir Yahudiya mai, aga nda diɗana nyi, nda nǝ nyi ɓwaɓwatǝu, nda dzǝgwa tǝfǝri nyi tuli. ");
INSERT INTO mfm_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ndu nda dǝgǝ nyi ǝnga wuɗa, nda tsǝya nyi, ama pida makǝrkura nyi ba ja hyaˈari sara vir tau.” ");
INSERT INTO mfm_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ama zǝmbǝlma nyiˈyar nggabiya sǝ kǝ Yesu na kǝ mai. Ɗǝɗǝwa ngǝ sǝra ndǝr kǝ cabiya anǝ nda, ca ngǝ ɗa nandǝ sǝni nggabiya mai. ");
INSERT INTO mfm_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ənggǝra Yesu dla lǝhǝu wu dzǝri Yariko, kǝ ja ndǝ lǝfau a vǝr nggya ar thlǝr pa lagu, ja kǝdiyau. ");
INSERT INTO mfm_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ənggǝra ji nggari nji gangǝu a vǝr tǝrabiya, kǝ ji yiwa sau ji na, “Mi nga vǝr ɗa?” ");
INSERT INTO mfm_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kǝ ndǝ na anǝ nyi, abǝr, “Yesu ndǝr Nazǝratu nga vǝr tǝrabiya.” ");
INSERT INTO mfm_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kǝ ji hyaˈana ɗahǝu ji na, “Yesu! Zǝr Dawuda! Tǝhuɗǝ ǝgya yau!” ");
INSERT INTO mfm_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Njira a dumwa ndǝ kughi anǝ nyi aga ja haɗiya miya ja. Ama kǝ ji ɓǝra hyaˈana ɗahǝu gagaɗau ja vǝr na, “Na gǝ, Zǝr Dawuda, tǝhuɗǝ ǝgya yau!” ");
INSERT INTO mfm_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kǝ Yesu taˈyau, ji na, “Shila mau ǝnga ja ǝnggau.” Ənggǝra ji shili lǝhǝu, Yesu yiwa nyi, ");
INSERT INTO mfm_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Mi nga gu yiwu ya mǝliya nga?” Kǝ lǝfǝ kǝ shaɗǝwa, ji na, “Thlagǝu, ya yiwu ya lari sau.” ");
INSERT INTO mfm_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu na anǝ nyi, “Lari sau! Mbǝrsa ngau a pahǝnari liya gau.” ");
INSERT INTO mfm_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aga zǝmǝ kǝ liya ja lari sau, kǝ ji nu Yesu, ja vǝr dlǝvǝ Hyal. Ənggǝra nji lari sǝ kǝ ɗa kau, kǝ ndǝ patǝ fal Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu vu Yariko, ja vǝr tǝrabiya wu hu ɗa mǝlma nyi, ");
INSERT INTO mfm_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","kǝ ja vanyi ndǝ dǝgal nǝ njir tsǝm budau, kǝra nja ngga ǝnga Zakka. Naja tsu ndǝr gǝnna, ");
INSERT INTO mfm_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ji ɗa aga ja lari tara wa ngǝ Yesu, ama naji sǝni lari nyi mai ara naja ndǝ tashu, ǝnga tsu nji gangǝ gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Agabangǝ kǝ ji maˈyi a dumwa ǝnga hwi, kǝ ji thlǝwa wu bǝla kǝ ji dagwa, aga ja lari nyi, arya Yesu wu nda tǝrabiya lagu ta. ");
INSERT INTO mfm_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ənggǝra Yesu thlǝwa vi ta, kǝ ji hyaˈanakǝr a dǝmǝlmau ji na, “Zakka, kusa ga shida! Əshina yu ɗa mǝthlǝpi wu ki ngau.” ");
INSERT INTO mfm_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakka gya ǝnga kusa, ji dlǝwuri nyi ǝnga huɗǝ pipida. ");
INSERT INTO mfm_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ənggǝra nji lari abangau, kǝ ndǝ mbari ngwungwuni, nda vǝr na, “Kǝja! Wu ki ndǝr bikǝ nga ji ɗa mǝthlǝpi.” ");
INSERT INTO mfm_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kǝ Zakka hyaˈari aˈyi taˈyau, ji na anǝ Thlagǝu, “Nggari, ndǝ dǝgal, yu tǝkǝya sǝra ara yau bwata mǝthlǝu, ba ya tǝkǝna pathla nyi anǝ nji tǝtǝ dǝnama. Patǝkura njira nyi dlǝrbǝri, yu nda shabiya nda sǝr nda aga foɗǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kǝ Yesu na anǝ nyi, “Əshina ma, mbǝɗau a shiliri wu ki kau, naja ma culi Ibrahimu ngau. ");
INSERT INTO mfm_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Arya Zǝr Ndau ji shili aga sa gal nji sasa, ǝnga ja sa canǝ nda lagur mbǝɗau.” ");
INSERT INTO mfm_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tsu nda vǝr sǝ himi sǝˈyar kau, kǝ Yesu dumwa ǝnga na vanyi karapǝ anǝ nda, ara a ɗar lǝhǝu wu dzǝri Urshalima, ǝnga nja vǝr ɗǝnga abǝr tǝlkur Hyal wu cabiya dzǝ aga zǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kǝ ji na anǝ nda, “Nji sayi mǝliya vanyi ndǝ dǝgal kǝra maˈyi a ndu vanyi mǝlmǝ naɗǝ aga nja fiya nyi tǝl ja dzǝgwa sha shili. ");
INSERT INTO mfm_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kadivira ja mai, ji ngga kumo wu pama mafa nyiˈyar, ji nǝ nda pam papathlǝ ji dzǝgwa na anǝ nda, ‘Shafǝli mau ǝni kǝl yi sha shili.’ ");
INSERT INTO mfm_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Njir mǝlmǝ nyi wu yiwu nyi mai. Agabangau, kǝ ndǝ sǝwa cama ayukuɗa ji mai a ndu mǝlmǝ ta abǝr, ‘Naˈyu yiwu ndǝ kǝ ja ɗa tǝl ar kǝra ˈya mai.’ ");
INSERT INTO mfm_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Kǝ nji fiya ndǝ kǝ tǝl, ji dzǝgwa sha shili wu ki. Ənggǝra ji shili kǝ ji sǝwa nja nggari nyi mafa nyiˈyar ta, aga ja sǝni nubwa kǝra ndǝ uya ar kǝra sǝra ji nǝ nda. ");
INSERT INTO mfm_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ndǝ tanggǝrma shili ji na, ‘Thlagǝu, a uyari yau nubwa pam kumo a dar kǝra pam pathlǝu ta gǝ nǝ ɗa ta.’ ");
INSERT INTO mfm_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kǝ thlagǝri ki kǝ na anǝ nyi, ‘Usi mafa tsapǝu ndǝr mǝl thlǝr tsaˈa miya ɗǝfu! Gǝ mǝl thlǝr ngau, tsaˈa miya ɗǝfu ǝnga sǝ kushu kǝra nji nǝ ngau, yu mǝliya ga sǝm tǝlkur ar kǝra mǝlmǝ pamǝpamǝ kumou.’ ");
INSERT INTO mfm_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mafa nǝ mǝthlǝkura nyi shili ji na, ‘Thlagǝu, a uyari yau nubwa pamǝ tǝfu a dar kǝra pamǝ zǝmǝ ta gǝ nǝ ɗa ta.’ ");
INSERT INTO mfm_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Thlagǝr ki nyi shaɗǝwa anǝ ndǝ kau, ‘Gǝ wu sǝm tǝlkur ar kǝra mǝlmǝ pamǝpamǝ tǝfu.’ ");
INSERT INTO mfm_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Kǝ vanyi mafa shili ji na, ‘Thlagǝu, kǝ ja pamǝ zǝmǝ ngau. Yi pǝɗiya wu kukuzhal, yi ɗǝwana. ");
INSERT INTO mfm_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ara yu hivǝr ngau, arya na gǝ ndǝ dzadzau ngau. Kǝja ga fa sǝra kǝra nǝ gau, gu gǝm tsu sǝra gǝ kǝra thlǝka na.’ ");
INSERT INTO mfm_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kǝ ji na anǝ nyi, ‘Nagǝ mafa ɗǝmwaˈyi hangǝkal, yu mǝliya ngǝ numa ǝnga sǝra biya sara wu miya gau! Əngwar gau nayi ndǝra nji kǝra sǝni hangǝkal nyi, ndǝr fa sǝ nji kurthlǝu ǝnga yiwu gǝm ar vi kǝra yi kǝra thlǝka na. ");
INSERT INTO mfm_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tsaˈa nga nyi, ama mi ngǝ ɗa nagǝ fiya gǝnna ɗa ar vi fǝ gǝnna maya, aga maˈyi shili ya uya akkǝri ar kǝri mai ya?’ ");
INSERT INTO mfm_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Kǝ ji na anǝ nji ta taˈyi ǝkkǝˈyi ja, ‘Dlǝwura mau gǝnna dubu pathlǝu kǝra ara ja kau, ba hya nǝ nyi anǝ ndǝra ǝnga dubu kumou.’ ");
INSERT INTO mfm_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ama kǝ ndǝ shaɗǝwa nyi, ndǝ na, ‘Thlagǝu, pamǝ kumo nga ara ja.’ ");
INSERT INTO mfm_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ji shaɗǝwa, ji na, ‘Yi wu nar hyi, ndǝra aˈyi ǝnga sau nju nda cakǝri nyi. Ndǝra kǝra aˈyi ǝnga sau, alaga sǝ kushu kǝra aˈyi ara ja nju nda dlǝwuri. ");
INSERT INTO mfm_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Njira dawa ɗa kau, nji kǝra gǝra yiwu ya ɗa tǝl ar kǝra nda kau, faˈari nda mau a shili nja tsǝya nda wu mwa ɗa.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ənggǝra ji nana abangau, kǝ ji dumwa a vu Urshalima. ");
INSERT INTO mfm_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ənggǝra Yesu ǝnga zǝmbǝlma nyiˈyar vu mǝlmǝ Bethfaji ǝnga Bethlani, mǝlmǝ kǝra lǝhǝu wu dzǝr Urshalima, kǝra a dar kǝra mǝ zaitunu. Kǝ Yesu sǝwa zǝmbǝlma nyiˈyar mǝthlǝu, ");
INSERT INTO mfm_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ji na anǝ nda, “Maˈya mau a vu zǝr mǝlmǝ kǝ a ndumwar hyi kau, ǝnggǝra hyi vwau, hyu vuwa thlǝwa zǝr kwara mbamba ar sǝˈyi, kǝra nji gǝra saya dari, hya pǝlna nyi hya hǝr ɗa a shili. ");
INSERT INTO mfm_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ma nji yiwa hyi, ‘Mi ngǝ ɗa hyu mǝl abanga?’ Kǝl ba hya na, ‘Thlagǝ ngu yiwu ja mǝl thlǝr ǝni.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Njira nji sǝwa, ndǝ maˈyi, kǝ ndǝ thlǝwa kalar sau ǝnggǝra Yesu nar nda ta. ");
INSERT INTO mfm_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nda vǝr pǝl nyi ja, kǝ thlagǝri kwara nyi na anǝ nda, “Aga mi nga hyu pǝl nya?” ");
INSERT INTO mfm_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kǝ ndǝ na, “Thlagǝ ngu yiwu ja mǝl thlǝr ǝni.” ");
INSERT INTO mfm_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kǝ ndǝ hǝri nyi a shila nǝ Yesu. Ənggǝra ndǝ fǝr lǝgutǝr nda a dar kwara nyi, kǝ ndǝ dlǝwari Yesu ndǝ fǝri nyi a dar ya kwara nyi. ");
INSERT INTO mfm_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ənggǝra ja vǝr ɓau, kǝ nji dzǝgwa sǝya lǝgutǝr nda a gyar lagu. ");
INSERT INTO mfm_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ənggǝra ji shili lǝhǝu wu dzǝri Urshalima, mǝ tsa ga vi kǝra lagu sa gya ar dza gar nǝ wur Zaitunu, kǝ daɓǝr zǝmbǝlma nyiˈyar gangǝu daɓau nda vǝr usa Hyal, nda vǝr fal nyi tsu ǝnga ɗahǝu ǝnga dǝnama arya sǝ dǝdǝgur pamǝpamǝ kǝra ndǝ lari. ");
INSERT INTO mfm_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nda vǝr na! “Barka a nggyar anǝ tǝl kǝra wu dla wu thlǝmǝr Thlagǝu! Jamǝkur a nggyari a dǝmǝlmau, ǝnga kadakadarkur anǝ Hyal!” ");
INSERT INTO mfm_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kǝ alenyi njir Farisi kǝra wu pama nda na anǝ nyi, “Malǝmǝ, ga kughi anǝ zǝmbǝlma ngǝˈyar nda nggya zǝmǝu!” ");
INSERT INTO mfm_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ji shaɗǝwa nda, ji na, “Ya nar hyi,” “alaga ndǝ bǝgau, tsǝka ˈyar kǝ ǝnga kǝr nda ndu wau.” ");
INSERT INTO mfm_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ənggǝra ji shili lǝhǝu gagaɗau, ji tsamiya vu Urshalima, kǝ ji tiwi anǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ji na, “Kara nggǝrau, ma ja hyi nda sǝni sǝra wu nǝ hyi nggya jamǝu! Ama kǝ ja a ɗar ɗǝɗǝwa ara hyi. ");
INSERT INTO mfm_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pǝci a vǝr shili kǝra dawar hyu nda zǝwar hyu masǝmǝ nda dzǝgwa pa ǝnga hyi. Sojar nda ngu nda zǝwar hyi. ");
INSERT INTO mfm_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ndu nda hǝradlǝna ngau ǝnga nja dlǝna njira a gwa patǝu. Nandǝ wu nda piyari tsǝka zǝmǝ ar kǝra kuvwa nyi mai. Sǝˈyar kǝ wu nda ɗa ǝnga hyi ara nahyi aˈyi sǝnbiya abǝr Hyal shili aga mbǝɗa hyi mai.” ");
INSERT INTO mfm_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kǝ Yesu vu ki Hyal ji vuwa kǝdlǝbiya njira vǝr ɗǝl ǝnga ɗǝlna sǝ a vuna patǝu, ");
INSERT INTO mfm_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ji na anǝ nda, “Tsǝtsǝfǝ nga nyi, “ ‘Nju ngga ki ɗa ǝnga vir kǝdi Hyal,’ ama kǝja hya shabiyari ji ɗa vir ɗǝwa njir ɗalagu.” ");
INSERT INTO mfm_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Parangǝ ja vǝr highiɓau wu ki Hyal. Ama pubu dǝdǝgalˈyar, ǝnga malǝmǝ dlaɗǝˈyar, ǝnga nji dǝdǝgal nǝ mǝlmǝ ndu gal lagu kǝra nda daɓaga tsǝya nyi ari. ");
INSERT INTO mfm_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ama nandǝ uya lagu kǝra nda sǝni tsǝya nyi mai, ara ndǝr nyi a uyari vi wu ɗǝfuwa nji, ǝnga nandǝ wu yiwu ndǝr zǝmǝ a tǝɗau a gyiwu ˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Vanyi pǝci Yesu gwu ki Hyal ja vǝr highiɓau, ja vǝr tǝtǝlna ndǝshigu mǝsahǝu anǝ nji, kǝ pubu dǝdǝgalˈyar, malǝmǝ dlaɗǝˈyar ǝnga njira nggurǝm shili ara ja. Ndǝ sa yiwa nyi, ");
INSERT INTO mfm_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Ənga dǝnama wa nga gu mǝl sǝˈyar ka? Wa ngǝ nǝ ngǝ dǝnama nǝ mǝl sǝˈyar ka?” ");
INSERT INTO mfm_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu shaɗǝwa nda, ji na, “Nayi ma yu yiwari hyi. Nar ɗa mau, ");
INSERT INTO mfm_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","dǝnama kǝra Yahwana mǝl baɓǝtizǝma ǝni, Hyal ngǝ nǝ nyi ǝndǝga ndau?” ");
INSERT INTO mfm_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kǝ ndǝ ndǝr wu pama nda, ndǝ na, “Ma mǝn na, ‘Sara ara Hyal nga nyi dla,’ ju nda na, ‘Mi ngǝ ɗa nahyi hǝnggǝri ǝnga ja mai ya?’ ");
INSERT INTO mfm_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma tsu mǝn na, ‘Sara ara nji,’ gangǝkura nji kǝ ndu nda vavaka mǝn ǝnga tsǝka, arya patǝkura nda a hǝnggǝri abǝr Yahwana nabi nga ja.” ");
INSERT INTO mfm_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Agabangǝ kǝ ndǝ na anǝ nyi, “Naˈya sǝni vi kǝra dǝnama nyi dla sara ri mai.” ");
INSERT INTO mfm_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kǝ Yesu na anǝ nda, “Nayi ma, nayi wu na anǝ hyi, tara ǝnga dǝnama wa nga yu mǝl sǝˈyar kǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kǝ Yesu nar nyi najaka karapǝ anǝ nji, ji na, “Nggara mau vanyi karapau, Vanyi thlagǝr fa aˈyi kǝra thlǝkana fa wur inabi. Ji zǝwari fa kǝ wu masǝmǝ, ǝnga ji labiya kaˈu nǝ ɓǝci ˈyimir wur inabi. Kǝ ji liya dzaˈwu nǝ ɓǝla fa. Kǝ ji tǝtǝkǝna fa anǝ njir zǝwa, ba ji maˈyi a nda gǝ ndau. ");
INSERT INTO mfm_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ənggǝra pǝcir fwahǝu ɗa, kǝ ji sǝwa mafa nyi a nda nǝ njira hǝ fa, aga ja dlǝwuri nyi akkǝri nyi nǝ inabi sara wu fa wur inabi nyi. Ama kǝ njira hǝri fa kǝ dǝgǝna mafa kau, ka dzǝgwa sǝwa nyi ǝnga tsi kurthlǝu. ");
INSERT INTO mfm_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kǝ ji ɓǝra sǝwa vanyi mafa nyi, ama kǝ ndǝ ɓǝra dǝgǝna nyi ka hǝna sǝli nyi, ndǝ dzǝgwa shabiya nyi ǝnga tsi kurthlǝu. ");
INSERT INTO mfm_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kǝ ji ɓǝra sǝwa mafa nǝ makǝrkura nyi, kǝ ndǝ uya nyi ǝnga mbǝlgǝu, ndǝ vakana nyi a biya. ");
INSERT INTO mfm_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Kabangǝkau, ndǝ kǝ thlagǝri fa inabi kǝ na, ‘Mi nga ya mǝla? Yu sǝwa zǝr ɗa kǝ zǝmǝ kǝ yu yiwu kau, tara ba nda gǝnggǝr nyi sǝli.’ ");
INSERT INTO mfm_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ama ǝnggǝra njir hǝ fa kǝ lari nyi, kǝ ndǝ na wu pama nda, ǝnghǝng! ‘Kǝja ndǝr faˈa ki nyi. Mǝna tsǝya nyi, ba sǝr faˈa ki nyi kǝ patǝ a ɗa nǝr mǝn.’ ");
INSERT INTO mfm_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kǝ ndǝ tsǝya nyi ka vakana nyi a biyar ya kǝr ki. “Kabangǝkau, mi nga hyu nggani thlagǝri fa kǝ wu nda mǝl ǝnga njir hǝ fa ka? ");
INSERT INTO mfm_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ju nda shili ja sa dlǝna patǝr njir hǝ fa kau, ba ja dzǝgwa nǝ nyi fa anǝ nji pamǝ tsu.” Ənggǝra nji kǝ nggari abangau kǝ ndǝ na, “Hyal ja tsana!” ");
INSERT INTO mfm_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ama kǝ Yesu tsamǝ nda kǝ ji yiwa, “Mi ngǝ sǝ kǝ cabiya wu ndǝr Hyal kǝra tsǝtsǝfa? “ ‘Tsǝka kǝra njir hǝr diɗana ca ngǝ ɗa tsǝka ɓǝlkǝr.’ ");
INSERT INTO mfm_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kalar ndǝra tǝɗau a gyar tsǝka kau, ju ɓǝɓǝl, ama ndǝra tsǝka kǝ tǝɗǝ a gyar ja, ju ǝya dzǝ huhutǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ənggau ngǝ malǝmǝ dlaɗǝˈyar ǝnga pubu dǝdǝgalˈyar ndu yiwu nda mbari Yesu, arya ndǝ sǝnbiya abǝr karapǝ kǝ ji lǝ kǝ ar kǝra nda nga nyi, ama kǝ hivǝr mbar nda ara dlamir nji. ");
INSERT INTO mfm_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kǝ ndǝ dzǝgwa gal lagu, ndǝ kina alenyi nji aga nda ɗa ǝnggǝr nji tsapǝu, nji jiri. Ndǝ dzǝgwa sǝwa nda a ndǝgya Yesu aga nda ngǝ ya nyi lǝbam ǝnga sǝra ndu yiwa nyi, aga nda uya nda nǝ nyi Yesu anǝ ndǝr pathla kǝra ǝnga dǝnama nǝr ˈyiˈyir Roma. ");
INSERT INTO mfm_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nji kǝ nji sǝwa kǝ na anǝ Yesu, “Malǝmǝ, ˈyi wu sǝni abǝr ndǝr ngau ǝnga highiɓǝ ngau jiri nga nyi, ˈyi wu sǝni tsu na gu ca pamǝpamǝkur mai, ama gu highiɓǝ sǝra jiri nǝ lagu Hyal anǝ nji patǝu. ");
INSERT INTO mfm_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wu ɗǝnga ngau, a ɗar tsaˈa ˈya ki budau anǝ tǝl Kayisaru ǝndǝga awau?” ");
INSERT INTO mfm_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ama Yesu a sǝnbiya tsǝtsǝlkur nda, kǝ ji na anǝ nda, ");
INSERT INTO mfm_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Canǝ ɗa mau kwaɓa. Bama wa ǝnga thlǝmǝr wa nga ri ka?” ");
INSERT INTO mfm_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ndǝ shaɗǝwa nyi, “Nǝ Tǝl Kayisaru ngau.” Kǝ ji nar nda, “Ma abangau, hya nǝ nyi anǝ tǝl Kayisaru sǝra nǝ nyi, ba hya nǝ nyi anǝ Hyal sǝra nǝ Hyal.” ");
INSERT INTO mfm_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ənggau kǝ ndǝ tini mbari nyi ǝnga ndǝr wu mwar nji. Kǝ ndǝ nggya zǝmǝu, ara shaɗǝwa nyi ɗa sǝ dǝdǝgur anǝ nda. ");
INSERT INTO mfm_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kǝja alenyi njir Sadusi, njira na abǝr hyaˈari sara vir tau aˈyi mai, ndǝ dla ǝgya Yesu, ndǝ na, ");
INSERT INTO mfm_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Malǝmǝ, Musa tsǝfǝri ˈya najaka dlaɗau abǝr, ‘Ma ndǝ tau ji piyari mala nyi kǝra gǝra wazha, a kyau zamǝ nyi a hǝri mala kǝ aga ja uya wazha anǝ zamǝ nyi.’ ");
INSERT INTO mfm_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nji sayi mǝliya alenyi nji nanda mǝɗǝfau, nanda patǝ zamǝ nga nda. Kǝ dǝgala nda hǝri mala ba ji tau kǝra yabiya zǝr. ");
INSERT INTO mfm_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kǝ nǝ mǝthlǝkura nyi hǝri mala kau. ");
INSERT INTO mfm_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nǝ makǝrkura nyi abangau. Kǝ ɗa patǝkura nda mǝɗǝfǝ hǝri mala kau, ama ba ndǝ tǝ patǝ gǝra ya ǝnga mala kau. ");
INSERT INTO mfm_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Wu yukuɗa nyi, mala kǝ ma ba ji tau. ");
INSERT INTO mfm_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kabangǝkǝ ya, pǝcir hyaˈari sara vir tau, mala wa nga ju nda ɗa? Arya patǝkura nda a hǝri nyi ri nda aga mala.” ");
INSERT INTO mfm_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu na anǝ nda, “Nji kabangǝkǝ kǝl hǝ dzǝ nga ndu hau wu pamǝu, ");
INSERT INTO mfm_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ama njira wu nda ɗa tsaˈa aga hyaˈari sara vir tau nga ndu vu tǝlkur Hyal wu pǝci ta, nandǝ wu hǝ dzǝ mai. ");
INSERT INTO mfm_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ndu nda ɗa ǝnggǝr waladiˈyar, nandǝ wu ɓǝra tǝ mai. Ndu nda ɗa wazha Hyal ara a hyaˈari nda sara vir tau. ");
INSERT INTO mfm_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Musa ǝnga kǝrnyi a cabiyari ar babal abǝr njira tau ndu nda hyaˈari ǝnga pi. Wu ndǝr ar kǝra kǝdlǝl kǝra mbari uˈu, ji ndǝr ar kǝra Thlagǝ abǝr naja ngǝ, ‘Hyal nǝ Ibrahimu ǝnga Ishaku ǝnga nǝ Yakubu.’ ");
INSERT INTO mfm_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Naja aˈyi Hyal nǝ nji tǝtǝ mai ama nǝ njira ǝnga pi. Anǝ nyi kalar ndau ǝnga pi nga ja.” ");
INSERT INTO mfm_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kǝ alenyi malǝmǝ dlaɗǝˈyar ndǝ ndǝr ndǝ na, “Malǝmǝ, a nabiyar gǝ kakalǝu!” ");
INSERT INTO mfm_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ənggau nandǝ ɓǝra uya dǝnama nǝ yiwa nyi vanyi sǝ mai. ");
INSERT INTO mfm_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu yiwa nda ji na, “Abari nga nju sǝni na abǝr Kǝrsiti zǝr Dawuda? ");
INSERT INTO mfm_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawuda ǝnga kǝrnyi na wu lǝkakaɗǝ nǝ Zabura: “ ‘Thlagǝ na anǝ Thlagǝ ɗa, Nggya lagu mazǝma yau, ");
INSERT INTO mfm_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kǝl yi fiya dawa ngau ǝgya kiɗa hiya gau.” ’ ");
INSERT INTO mfm_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawuda ji na anǝ Kǝrsiti ‘Thlagǝu.’ Ya abari nga ja sǝni na anǝ nyi zǝr nya?” ");
INSERT INTO mfm_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ənggǝra nji patǝ a vǝr sǝ himi nyi, kǝ ji nar nyi anǝ zǝmbǝlma nyiˈyar abǝr, ");
INSERT INTO mfm_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Hya hangǝkal ǝnga malǝmǝ dlaɗǝˈyar. Ndu yiwu nda ɓau wu pama nji wu kar ha nggunggurǝm ǝnga nja dzǝgwa usa nda ar sugu. Ndu yiwu tsu nja nǝ nda vir nggya tsapǝ wu umbwa daɓǝ dzǝ njir Yahudiya, ǝnga vir nggya nǝ kadakadarkur ar vir mini. ");
INSERT INTO mfm_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nanda ngǝ njir sǝm kari nǝ mathlǝkǝˈyi tǝsal, nda dzǝgwa ndǝr ǝnga Hyal tugu aga nja lari abǝr aˈyi nda. Jiri, nanda ngu nda lari ɓwaɓwatǝ gagaɗau a ndiya nji patǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu hyaˈanakǝr kǝ ji lari alenyi njir gǝnna a vǝr fǝ gǝnnar nda a gwu cala tsǝm sau a gwu ki Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kǝ ji lari vanyi malatǝsal kǝra sǝ nyi aˈyi mai ji shili ǝnga kwaɓa nyi mǝthlǝ kǝ ji puwa a gwu cala. ");
INSERT INTO mfm_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kǝ Yesu na, “Jiri, nga yu na anǝ hyi,” “sǝra mala tǝtǝ dǝnama kǝ fuwa, a ndiya nǝ nji kǝ patǝu. ");
INSERT INTO mfm_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Arya patǝkura nda ndǝ fuwa sara wu gangǝkura nda ǝni, ama naja ǝnga tukur kǝra ja ǝni, kǝ ji fuwa sǝra ju nggya aga nyi patǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Alenyi zǝmbǝlma nyiˈyar dzǝguya ndǝr ar kǝra ki Hyal, ǝnga culi tsǝka mǝnahǝu kǝra nji hǝri ǝni, ǝnga sǝr ɓathlǝ umbwa mǝmǝnahǝ kǝra nji nǝ nyi anǝ Hyal. Ama kǝ Yesu na, ");
INSERT INTO mfm_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ma aga sǝˈyar kǝ hyu tsamǝ kau, pǝci wu shili nahyi wu nda thlǝwa tsǝka zǝmǝ ar kǝra kuvwa nyi mai, kalar zǝma nyi nju nda vakana a gyiwu ˈyi.” ");
INSERT INTO mfm_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ndǝ yiwa nyi, “Malǝmǝ,” nar ˈya, “ǝnuwa ngǝ pǝci kǝra sǝˈyar kǝ wu nda ɗar kǝra, ǝnga mi ngu nda ɗa mǝtsamǝ nǝ shili nga, ǝnga kuɗiyar najaka duniya?” ");
INSERT INTO mfm_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Kǝ ji shaɗǝwa nda, “Hya nggya hya tsamǝ ǝnga hangǝkal nja sara nggutana hyi. Arya nji gangǝu wu nda shili wu thlǝmǝ ɗa, ndu na ǝnga kǝrnda, ‘Nayi ngǝ Kǝrsiti,’ ǝnga, ‘Pǝci a ɗar lǝhǝu.’ Hya sara nu nda mai. ");
INSERT INTO mfm_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Hya sara hivǝr mai, ma hyi nggari ar kǝra papa ǝnga ndǝr ǝngwa ǝngwa ar kǝra papa, hangǝkalǝr hyi ja sara hyaˈari mai. Kǝl ma sǝˈyar kǝ nyabiya dzau, ama tsu kuɗǝr duniya naɗǝu. ” ");
INSERT INTO mfm_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ji dumwa ǝnga na, “ˈYiˈyi wu dlǝɗǝ ˈyiˈyi, ǝnga tǝlkur wu nda par tǝlkur. ");
INSERT INTO mfm_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Wuɓau ǝnga kǝnggǝɗǝr ˈyiˈyi wu nda ɗarkǝr ar vi pamǝpamǝ gangǝu, ǝnga shilǝgǝˈyar pamǝpamǝ ar kalar vi pamǝpamǝu. Nju nda lari sǝr lǝ hivǝr ǝnga sǝr dǝdǝgurˈyar sara dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ama kadivira sǝˈyar kǝ ɗa, nju nda mbari hyi nja nǝ hyi ɓwaɓwatǝu. Nju hǝri hyi a ndu umbwa daɓǝ dzǝ njir Yahudiya aga nja thlana hyi numa, nja ɓǝra fuwa hyu fursǝna. Nju hǝri hyi a dumwar tǝlˈyar ǝnga nji dǝdǝgal nǝ mǝlmǝ arya thlǝmǝ ɗa aga nda ɓǝra thlana hyi numa. ");
INSERT INTO mfm_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Sǝˈyar kǝ ngu nda nǝ hyi lagu nǝ tǝtǝlna ndǝshigu mǝsahǝu ar kǝra yau. ");
INSERT INTO mfm_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Agabangǝ hya fǝr kǝr ǝni tsu kaɗǝu abǝr nahyi wu nda ɓwakǝr ǝnggǝra hyu nda hǝbiya kǝrhyi mai. ");
INSERT INTO mfm_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Arya yu nda nǝ hyi sǝr na ǝnga sǝnbiya aga alaga zǝma dawar hyi a sǝni nda shabiya ndǝr hyi ǝnga kǝpalna sǝra hyu na mai. ");
INSERT INTO mfm_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Əkkǝˈyi dǝr hyi, ǝnga zamǝri hyi, ǝnga nji gǝ hyi, ǝnga bazhir hiˈyar wu nda lǝri hyi anǝ nji, ǝnga nju nda tsǝya alenyi nju pama hyi. ");
INSERT INTO mfm_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Patǝkura nju nda yiwu shishir dza hyi mai arya thlǝmǝ ɗa. ");
INSERT INTO mfm_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ama shishir kǝra hyi zǝmǝ wu nda sa mai. ");
INSERT INTO mfm_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ma hyu sǝni cinapi hyu uya mbǝɗau. ");
INSERT INTO mfm_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ma hyi lari sojaˈyar zǝwar Urshalima, hya sǝni abǝr pǝcir kuɗǝ nyi a ɗar lǝhǝu. ");
INSERT INTO mfm_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kǝ njira wu ˈyiˈyir Yahudi, nda hwi a du mau. Njira wu hu ɗa mǝlmǝ nda biya, njira a biyar ya mǝlmǝ nda sara vu hu ɗa mǝlmǝ mai. ");
INSERT INTO mfm_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Arya pǝci kǝ pǝcir pathla ngau, a ɗar tsaˈa nja nyabiya sǝra tsǝtsǝfau wu ndǝr Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sǝr tǝhuɗǝ anǝ mathlǝkǝˈyi kǝra ǝnga huɗǝu ǝnga kǝra a vǝr lǝ uˈwa ar pǝci ta! Ara ɓwaɓwatǝ ɗǝmwaˈyi wu nda vu ˈyiˈyi kau, ǝtsu huɗǝ ndzǝndzǝ nǝ Hyal wu nda gya ar kǝra nji kau. ");
INSERT INTO mfm_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nju nda tsǝya alenyi nja vǝr pa, nju nda mbari alenyi nji nja maˈyi ǝnga nda a ndu mafakur a ndu alenyi ˈyiˈyi. Njira aˈyi njir Yahudiya mai ndu nda sǝmku Urshalima, kǝl pǝcir nda nyabiya dzau.” ");
INSERT INTO mfm_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nji wu nda lari sǝ pamǝpamǝ nǝ lǝ hivǝr ar pǝci, ǝnga hya, ǝnga shashilga. Wu duniya tsu nju nda gwu ɓwaɓwatǝ ǝnga hivǝr ara par ˈyimi ar tsadau. ");
INSERT INTO mfm_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nju nda shavǝr ara hivǝr ǝnggǝra nda vǝr ɗǝnga ar kǝra sǝra a vǝr shili wu duniya, arya pǝci, hya ǝnga shashilgaˈyar nju nda kǝnggǝɗǝr nda. ");
INSERT INTO mfm_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Wu pǝci ta nju lari Zǝr Ndau ju shili wu dlama ǝnga dǝnama ǝnga kadakadarkur. ");
INSERT INTO mfm_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ma sǝˈyar kǝ a dzǝguyar ɗa, hya hyaˈari hya taˈyau ǝnga jirkur hyi ara pǝcir mbǝɗǝr hyi a ɗar lǝhǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kǝ ji nar nda najaka karapau, “Tsamiya mau wur ɓǝla ǝnga alenyi wuˈyar. ");
INSERT INTO mfm_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ma ndǝ dzǝguya thlǝ hyali, nahyi ǝnga kǝrhyi, hya sǝni abǝr biyargwa a shiliri. ");
INSERT INTO mfm_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Abangǝ tsu, ma hya lar sǝˈyar kǝ a ɗari, hya nggya ǝnga sǝni abǝr tǝlkur Hyal a ɗar lǝhǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Yu nar hyi jirkura nyi, najaka zamanǝu, aˈyi wu tǝrabiya mai, kǝl sǝˈyar kǝ patǝ nyabiya dzau. ");
INSERT INTO mfm_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Dǝmǝlmau ǝnga gyiwu ˈyi wu nda tǝrabiya, ama ndǝr ɗa nǝ nyi wu tǝɗau a gyiwu ˈyi mai.” ");
INSERT INTO mfm_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Hya hangǝkal ǝnga kǝrhyi. Hya sara piyari sǝm ǝnga sa sǝ sasa, ǝnga ɓwaɓwatǝ nǝ nggya biya duniya ja sara hǝna hangǝkalǝr hyi mai. A sara pǝci kǝ a shili ar kǝra hyi ǝnga kǝra sǝnkur hyi ");
INSERT INTO mfm_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ǝnggǝr lǝbam. Ara wu nda shili ar kǝra nji patǝ kǝra wu duniya pǝci ta. ");
INSERT INTO mfm_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Hya nggya ǝnga fǝr kǝr, hya ndǝr ǝnga Hyal parangǝ aga hya uya dǝnama nǝ tǝrabiya wu sǝˈyar kǝ nda ɗa kǝ aga ja daɓaga ɗa hya taˈyau wu mwar Zǝr Ndau.” ");
INSERT INTO mfm_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kalar pǝci, Yesu a vǝr dumwa ǝnga highiɓau wu ki Hyal, ama ma wagǝu ɗa ba ja maˈyi a ndar vi kǝra nja ngga ǝnga Gar mǝ Zaitunu ba ja pida a dǝna. ");
INSERT INTO mfm_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kaɗǝ kalar mudlǝ nji patǝ tsu ndu shili ǝgya ja nda sa sǝ himi nyi wu ki Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pǝcir mǝl lardur nǝr njir Yahudiya ǝnga macikǝl kǝra gǝra thlǝlam, kǝra nja ngga ǝnga lardur vǝlna a ɗar lǝhǝu, ");
INSERT INTO mfm_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","kabangǝkǝ pubu dǝdǝgalˈyar ǝnga malǝmǝ dlaɗǝˈyar nda vǝr gal lagu ǝnga dabar kǝra nda daɓaga tsǝya Yesu, ama hivǝr a vǝr tǝ nda ara nji. ");
INSERT INTO mfm_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kǝ Shatan gwu ɗǝfuwa Yahuda, kǝra nja ngga ǝnga Isikarayoti pathlǝu wu pama zǝmbǝlma nyi kumo apǝ mǝthlǝu. ");
INSERT INTO mfm_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kǝ Yahuda maˈyi a ndǝgya pubu dǝdǝgalˈyar ǝnga dǝgal njir ɓǝla ki Hyal aga ja nda nar nda ǝnggǝra ju sǝni pǝlna nyi pǝzhi anǝ Yesu. ");
INSERT INTO mfm_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kǝ ɗa sǝr caguli anǝ nda, ndǝ hǝnggǝri ndu nǝ nyi gǝnna. ");
INSERT INTO mfm_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yahuda tsu a hǝnggǝri ja ǝnga sǝra ndǝ na, ja vǝr gal lagu mǝnahǝu kǝra ja sǝni pǝlna nyi pǝzhi anǝ Yesu kǝra ja gǝra sǝni. ");
INSERT INTO mfm_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kǝ pǝcir lardur nǝr macikǝl kǝra gǝra thlǝlam shili, kǝra ɗa ca ngǝ pǝcir thla gamǝ nǝr lardur nǝr vǝlna. ");
INSERT INTO mfm_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu sǝwa Biturusu ǝnga Yahwana, ja vǝr na, “Maˈyi mau hya nda mǝliya mǝn vir sǝm sǝr sǝm nǝ vǝlna aga mǝna sǝm.” ");
INSERT INTO mfm_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kǝ ndǝ yiwa nyi ndǝ na, “Əmani nga gu yiwu ˈya pabǝra?” ");
INSERT INTO mfm_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ji na anǝ nda, “Ənggǝra hyu vu hu ɗa mǝlmau, ndǝ sal a vǝr hǝ tǝm ǝnga ˈyimi wu thlǝwa hyi. Nu nya mau a ndu ki kǝra ju nda vuwa gwa. ");
INSERT INTO mfm_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Hya nar nyi anǝ thlagǝr ki kau, ‘Malǝmǝr ˈya ngǝ sǝwa ˈya aga ˈya nar ngau, “Əmani ngǝ umbwa dlǝwu mǝthlǝpi kǝra nayi ǝnga zǝmbǝlma ɗaˈyar wu nda sǝm sǝr sǝm nǝr vǝlbiya a gwa?” ’ ");
INSERT INTO mfm_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ju nda canǝ hyi umbwa kǝra a dar kǝra umbwa kǝra dǝgal kǝra nja mǝliya ri. Ənggau hya mǝliya kalar sau, aga sǝm sǝr sǝm.” ");
INSERT INTO mfm_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kǝ ndǝ maˈyi ndǝ nda thlǝwa kalar sau ǝnggǝra Yesu nar nda ta, kǝ ndǝ dzǝgwa mǝliya vir sǝm sǝr sǝm nǝr lardur nǝ vǝlna. ");
INSERT INTO mfm_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ənggǝra pǝci ɗa, kǝ Yesu ǝnga cama sǝsǝ nyiˈyar nggya aga nda sǝm sǝr sǝm. ");
INSERT INTO mfm_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kǝ ji na anǝ nda, “A yiwur yau gagaɗau aga ya sǝm lardur nǝr vǝlbiya kǝ ǝnga hyi kadivira ya dzǝgwa lar ɓwaɓwatǝu! ");
INSERT INTO mfm_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Arya yu nar hyi, nayi tsu ɓǝra sǝm sǝ kǝ ǝnga hyi mai kǝl ma jirkura nyi nyabiya dzǝ wu tǝlkur Hyal.” ");
INSERT INTO mfm_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kǝ ji hǝri kyakiwa, kǝ ji usari Hyal ji na, “Hǝra mau hya tǝkǝya wu pama hyi. ");
INSERT INTO mfm_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ya vǝr na anǝ hyi abǝr, tsu yu ɓǝra sa ˈyimir yayar wur inabi mai, kǝl ma tǝlkur Hyal shili.” ");
INSERT INTO mfm_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Abangau, kǝ ji hǝri macikǝl, kǝ ji lǝr usaku anǝ Hyal, ba ji ɓǝɓǝlǝwa, kǝ ji nǝ nyi anǝ zǝmbǝlma nyiˈyar, ju na, “Dlǝwura mau hya sǝm, naja kǝ kumǝr dza yi ngau, hya mǝl abangau aga ɗǝngari ǝnga yau.” ");
INSERT INTO mfm_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Abangǝ tsu, ayukuɗa sǝr sǝm nǝ wagǝu, kǝ ji hǝri kyakiwa ta, ji na, “Kyakiwa kǝ ca ngǝ alkawal mbamba mafǝliyangǝ kǝra Hyal mǝliya ǝnga mashi ɗa kǝra nju nda pǝna arya hyi. ");
INSERT INTO mfm_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ama kǝja tsa ndǝra wu nda thlǝna hiyau wu cala ǝnga yau! ");
INSERT INTO mfm_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Zǝr Ndau wu nda tau ǝnggǝra Hyal nana, ama sǝr tǝhuɗǝ anǝ ndǝ kǝ pǝlna nyi pǝzhi kau!” ");
INSERT INTO mfm_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kǝ zǝmbǝlma nyiˈyar dzǝguya yiwa wu pama nda, tara wa ngu nda mǝl sǝ kau. ");
INSERT INTO mfm_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Abangau kǝ kǝpal hyaˈari wu pama zǝmbǝlma nyiˈyar abǝr tara wa ngu dǝgal wu pama nda. ");
INSERT INTO mfm_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu na anǝ nda, “Tǝlˈyar nǝr duniya vǝr cina njira ǝgya kiɗa nda, ǝnga tsu njira wu sǝm dǝgalkur wu na abǝr nanda ngǝ, ‘Njir dlǝwa nji.’ ");
INSERT INTO mfm_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ama ja sara ɗa abangau wu pama hyi mai. Ndǝra dǝgal wu pama hyi ja ɗa ǝnggǝr ndǝra ndiya ǝnga kushu, ndǝr sǝm tǝlkur tsu ja ɗa ǝnggǝr ndǝr mǝl thlǝr. ");
INSERT INTO mfm_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Wa nga ndiya ǝnga dǝgala, ndǝra nggya vǝr sǝm sǝr sǝm ǝndǝga ndǝra hǝri sǝr sǝm a shili? Aˈyi ndǝra vǝr sǝm wa? Ama nayau wu pama hyi ǝnggǝr ndǝr mǝl thlǝr anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nahyi ngǝ njira nggya ǝnga yau wu patǝr ɓwaɓwatǝ kǝra yi lari. ");
INSERT INTO mfm_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ənggǝra dǝɗa caɗǝbiya ɗa aga ya sǝm tǝlkur, abangǝ nga ya vǝr nǝ hyi tsu, ");
INSERT INTO mfm_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","abangǝ nga hyu nda sǝm, hya sa ǝnga yu tǝlkur ɗa. Ətsu hyu nda nggya ar vir sǝm tǝlkur, hya dzǝgwa sǝm tǝlkur ar kǝra culi kumo apǝ mǝthlǝ nǝ Izirayila. ");
INSERT INTO mfm_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simanu, Simanu, Shatan a dlǝwuri ja dǝnama aga ja dzǝbiya hyi patǝu, ja tǝkǝbiya hyi ǝnga yau ǝnggǝra ndǝr zǝwa wu tǝkǝ uhi ǝnga cacangǝ. ");
INSERT INTO mfm_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ama a kǝdi ri yi Hyal anǝ ngau, Simanu, a sara mbǝrsa ngau a tǝwa mai. Ayukuɗa ma ga sha ara shili ǝgya yau, ga sa cakǝri nyi dǝnama anǝ zamǝ ngǝˈyar.” ");
INSERT INTO mfm_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simanu shaɗǝwa, ji na, “Thlagǝu, a pabǝri yi kǝrɗa aga ya maˈyi a vu fursǝna nga gau, alaga tǝ ma.” ");
INSERT INTO mfm_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu shaɗǝwa, “Biturusu, yu nar ngau, kadivira vǝgǝm nda wau ǝshina ǝvuˈyi, gu nda na, na ga sǝni ɗa mai ar kǝr ar kǝr makǝru!” ");
INSERT INTO mfm_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kǝ Yesu yiwa nda, “Ənggǝra yi sǝwa hyi gǝra pǝrki, gǝra mbala ǝnga ɓiɓi, a tini ri hyi sǝ ya?” Əngwar nda, “Awau.” ");
INSERT INTO mfm_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kǝ ji dzǝgwa na anǝ nda, “Ama kabangǝkau, ma gǝ ǝnga pǝrki, ga hǝri, ǝnga mbǝl ɓǝ tsu, ma tsu katsakǝr aˈyi ara ngǝ mai, ɗǝlna lǝgutǝ ha ngau ga ɗǝlbiya zǝmǝ ǝni. ");
INSERT INTO mfm_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Yu nar hyi abǝr sǝ kǝ tsǝtsǝfǝ kǝ abǝr, ‘Nji jigabiya nyi wu pama njir bikau,’ ya nar hyi a ɗar kakalǝ sǝˈyar kǝ nda nyabiya dzǝ ar kǝra yau. Jiri, patǝr sǝra tsǝtsǝfau ar kǝra yau a vǝr nyabiya dzǝ samǝu.” ");
INSERT INTO mfm_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Zǝmbǝlma nyiˈyar na, “Thlagǝu, tsamiya, kǝ ja katsakǝr mǝthlǝu.” Yesu na, “Tsaˈa abangau.” ");
INSERT INTO mfm_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu piyari vi ta ji maˈyi a ndu mǝ zaitunu ǝnggǝra ji tsǝliya, kǝ zǝmbǝlma nyiˈyar nu nyi. ");
INSERT INTO mfm_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ənggǝra ndǝ thlǝwa vi ta, kǝ ji na anǝ nda, “Hya kǝdi Hyal hya sara tǝɗau a gu dzau.” ");
INSERT INTO mfm_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kǝ ji ɓana dzǝ tsalǝu sara wu dzǝri nda, ji ɓǝliya undi ju kǝdi Hyal, ");
INSERT INTO mfm_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tada, ma gu yiwu, hǝna ɗa ɓwaɓwatǝ kau, ama aˈyi sǝra yu yiwu mai, ama sǝra gu yiwu bǝgǝ ja ɗa.” ");
INSERT INTO mfm_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kǝ waladi sara dǝmǝlmau shida ǝgya ja, ja vǝr fǝ ɗǝfu anǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ənggǝra Yesu wu ɓwaɓwatǝ gagaɗau, kǝ ji dumwa ǝnga kǝdi Hyal ǝnga jirkur, ka dzǝgwa ɗa vitǝku kǝra a vǝr biya sara wu dza ja ǝnggǝr mashi nga vǝr tǝɗau a gyiwu ˈyi. ");
INSERT INTO mfm_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yesu hyaˈari sara a vǝr kǝdi Hyal, ji sha a ndǝra zǝmbǝlma nyiˈyar, ba ji thlǝwa nda wu ghanyi, ara hǝhǝɗakura nda ǝnga huɗǝ ndzǝndzau. ");
INSERT INTO mfm_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ji yiwa nda, “Mi ngǝ ɗa hyu ghanya? Hyara mau, hya kǝdi Hyal, hya sara tǝɗau a gu dzau.” ");
INSERT INTO mfm_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tsu ja vǝr ndǝr kǝ dlamir nji shili, Yahuda, pathlǝu wu pama kumo apǝ mǝthlǝu, naja ngǝ dumwa anǝ nda. Ji shili ǝgya Yesu aga ja bǝrpǝ nyi, ");
INSERT INTO mfm_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ama kǝ Yesu yiwa nyi, “Yahuda, ǝnga bǝrpǝ dzǝ nga ga pǝl pǝzhi anǝ Zǝr Ndǝ ya?” ");
INSERT INTO mfm_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ənggǝra njir nu Yesu lari sǝkǝ a vǝr yiwu ja ɗa kau, kǝ ndǝ na, “Thlagǝu, ˈya mǝl thlǝr ǝnga katsakǝr ˈya ya?” ");
INSERT INTO mfm_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Pathlǝ wu pama zǝmbǝlma nyiˈyar thlana himi nǝ mazǝma nǝ mafa nǝ pubu kǝra ndiya ǝnga dǝgal ǝnga katsakǝr. ");
INSERT INTO mfm_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ama kǝ Yesu shaɗǝwa, “Tsaˈa abangau!” Kǝ ji tsǝkwari himiya ndǝ kǝ ba ji mǝliya nyi jamǝu. ");
INSERT INTO mfm_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesu ndǝr anǝ pubu dǝdǝgalˈyar, ǝnga dǝgal nǝ ɓǝla ki Hyal ǝnga nji dǝdǝgal nǝ mǝlmau, njira dla aga mba nyi. Ji na, “Nayi ngǝ ndǝr tǝɗǝmwa anǝ njir gwaɗǝvi ya, ǝnga hyi sǝbiya katsakǝr ǝnga zǝwa aga hya sa mba ɗa ya? ");
INSERT INTO mfm_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Parangǝu ya vǝr nggya ǝkkǝˈyi hyu Ki Hyal ya vǝr highiɓau, ama nahyi sayi mbar ɗa mai. Sǝˈyar kǝ ɗa patǝ aga sǝra nabiˈyar tsǝfǝri a nyabiya dzau.” ");
INSERT INTO mfm_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ndǝ mbari Yesu ndǝ maˈyi ǝnga ja a vu ki pubu kǝra ndiya ǝnga dǝgalǝu. Biturusu nu nyi ama naɗǝ wu yukuɗǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Alenyi nji mbǝbiya uˈu ar hada vir thla sau, nda vǝr ɗaha uˈu, kǝ Biturusu shili ji sa nggya wu pama nda. ");
INSERT INTO mfm_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kǝ mafa zǝr kwa lari nyi a vǝr nggya wu pama nda a miya uˈu. Kǝ ji tsamǝ du liya ja, kǝ ji na, “Ndǝ kǝ tsu ǝnga Yesu nga ja.” ");
INSERT INTO mfm_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ama kǝ ji kǝpalna. Əngwar ja, “Mala, nayi wu sǝni nyi mai.” ");
INSERT INTO mfm_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ɓǝliya sar kushu kǝ vanyi ndǝ lari nyi ji na, “Na ngǝ ma pathlǝu wu pama nda.” Kǝ Biturusu shaɗǝwa, ji na, “Ndau, nayi ǝkkǝˈyi ja mai.” ");
INSERT INTO mfm_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ayukuɗa ǝnggǝr saka pathlǝu kǝ vanyi ndǝ hyaˈana ɗahǝ ji na, “Gǝra kǝpal a gwa ndǝ kǝ ma nanda ngau, arya naja ndǝr Galili.” ");
INSERT INTO mfm_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Biturusu shaɗǝwa nyi, “Ndau, nayi wu sǝni sǝra gu ndǝr ar kǝri kǝ mai!” Ənggǝra ja tsu a vǝr ndǝr, kǝ vǝgǝm wau. ");
INSERT INTO mfm_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kǝ Thlagǝ shabiya dzǝ ja vǝr tsamǝ Biturusu gǝra hǝna li. Ənggau kǝ Biturusu ɗǝngari ndǝr kǝra Yesu nar nyi, abǝr, “Divira vǝgǝmǝ a wau, gu kǝpalna sǝn ɗa ar kǝr ar kǝr makǝru.” Kǝ ji hwi a biya, ji biya tiwi ǝnga sǝlǝm gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kǝ ji maˈyi a biya ji biya tiwi gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Njira nji fiya aga ɓǝla Yesu ndǝ dzǝgwa nggushi nǝ diɗa nyi ǝnga ndǝ dǝgǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ndǝ mbiya liya ja nda dzǝgwa yiwa nyi, “Nar ˈya, tara wa ngu dǝgǝ ngǝ kau?” ");
INSERT INTO mfm_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ndǝ ɓǝra nar nyi alenyi ndǝr pamǝpamǝ nǝ diɗa nyi. ");
INSERT INTO mfm_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ənggǝra vi kuɗau, nji dǝdǝgal nǝ mǝlmau, ǝnga pubu dǝdǝgalˈyar ǝnga malǝmǝ dlaɗǝˈyar ndǝ kaɓau, nji dzǝgwa hǝri Yesu a shili wu mwar nda. ");
INSERT INTO mfm_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ndǝ na anǝ nyi, “Ma nagǝ ngǝ Kǝrsiti, nar ˈya.” Yesu shaɗǝwa nda, “Ma yi nar hyi, nahyi wu nda hǝnggǝri ɗa mai, ");
INSERT INTO mfm_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ma tsu yi nda yiwari hyi, nahyi wu nda shaɗǝwa ɗa mai. ");
INSERT INTO mfm_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ama mbari kabangǝkau, Zǝr Ndau wu nda nggya ar tsi mazǝm nǝ Hyal kǝra ǝnga dǝnama.” ");
INSERT INTO mfm_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Patǝu nda ndǝ yiwa nyi, “Abǝr nagǝ ngǝ zǝr Hyal ya?” Ji shaɗǝwa, ji na, “A nabiyar hyi kakalǝu, nayi ngau.” ");
INSERT INTO mfm_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kǝ ndǝ dzǝgwa naja, “Sakida mani nga mǝn ɓǝra gala? A nggari mǝn sara wu miya ja ǝnga kǝrnyi.” ");
INSERT INTO mfm_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Patǝkura nji dǝdǝgal nǝ mǝlmǝ Yahudiya lǝbiya Yesu a ndǝgya Bilatusu. ");
INSERT INTO mfm_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kǝ ndǝ dzǝgwa gǝm nyi nda vǝr na, “Naˈyi thlǝwa ndǝ kǝ ja vǝr yiwu ja sana njir ˈya, ǝnga ja vǝr na anǝ nda nda sara ki budau anǝ Kayisaru mai. Əngwar ja naja ngǝ Kǝrsiti, kǝra tǝl.” ");
INSERT INTO mfm_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kǝ Bilatusu yiwa nyi, ji na, “Nagǝ ngǝ tǝl nǝ njir Yahudiya ya?” Yesu na anǝ nyi, “Ənggǝra gǝ na kau.” ");
INSERT INTO mfm_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kǝ Bilatusu nar nyi anǝ pubu dǝdǝgalˈyar ǝnga dlamir nji abǝr, “Nayi nǝ ɗa, nayi thlǝwa ndǝ kǝ mǝliya sǝ ɗǝmwaˈyi mai.” ");
INSERT INTO mfm_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ndǝ ciɗǝ nyi ǝnga ndǝr nda vǝr na abǝr, “Ənga highiɓǝ nyi nga ji hyaˈana hangǝkala nju ˈyiˈyir Yahudi. Ji dzǝguya sǝ kǝ wu Galili, kǝ ja tsu a shiliri ja ǝnggau.” ");
INSERT INTO mfm_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ənggǝra Bilatusu nggari abangau, kǝ ji yiwa nda, ji na, “Naja ndǝr Galili ya?” ");
INSERT INTO mfm_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ənggǝra ji nggari abǝr Yesu sara wu vi kǝra Hirudusu a vǝr sǝm tǝlkur ar kǝri nga ji dla, kǝ ji sǝwa nyi a ndara Hirudusu, arya wu pǝci ta naja Hirudusu ma wu Urshalima nga ja. ");
INSERT INTO mfm_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ənggǝra Hirudusu lari Yesu kǝ hu ɗa ja pida, arya a sǝkari ja vǝr gal lagu kǝra ja lari Yesu, ara a nggari ja sǝ ar kǝra Yesu, ju cim Yesu a mǝliya nyi sǝ dǝdǝgur. ");
INSERT INTO mfm_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hirudusu yiwa nyi yiwa sau pamǝpamǝ gangǝu, ama Yesu shaɗǝwa nyi mai. ");
INSERT INTO mfm_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kǝ pubu dǝdǝgalˈyar ǝnga malǝmǝ dlaɗǝˈyar shili a dumwa nda vǝr fa hya ja ǝnga ndǝr ɗǝmwaˈyu. ");
INSERT INTO mfm_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hirudusu ǝnga soja nyiˈyar ndǝ diɗana Yesu, ndǝ nggǝl nyi, kǝ ndǝ har nyi nggamndǝ dǝgalǝu, ndǝ dzǝgwa ɓǝra shabiya nyi a ndara Bilatusu. ");
INSERT INTO mfm_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ar pǝci kǝ ngǝ Hirudusu ǝnga Bilatusu dzǝgwa ɗa bazhi, ara ɗǝɗǝmǝu dawa nga nda. ");
INSERT INTO mfm_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bilatusu nggari pubu dǝdǝgalˈyar ǝnga nji dǝdǝgal nǝ mǝlmǝ ǝnga nji patǝu, ");
INSERT INTO mfm_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ba ji na anǝ nda, “Hi hǝri ɗa ndǝ kǝ a shili, abǝr ja vǝr hya hangǝkala nji. Kabangǝkǝ a yubiya nyir yau wu dzǝri hyi patǝu, ama nayi thlǝwa sǝ kǝ hyu vazǝ nyi ǝni kǝ mai. ");
INSERT INTO mfm_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Abangǝ tsu ngǝ Hirudusu. Ca ngǝ ɗa ji ɓǝra shabiya nyi a shila nǝ mǝn. A cabiyari sǝ aˈyi ndǝ kǝ mǝliya kǝra ɗa tsaˈa nja tsǝya nyi mai. ");
INSERT INTO mfm_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Agabangǝ yu nda nǝ nyi wuɗa ba ya sǝya nyi.” ");
INSERT INTO mfm_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kabangǝkau, wu lardur nǝ vǝlbiya kau, a ɗar tsaˈa anǝ Bilatusu, ja sǝya nda ndǝr fursǝna pathlǝ kǝra ndu yiwu. ");
INSERT INTO mfm_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ama patǝkura nda hyaˈana ɗahǝ aga zǝmǝ ndǝ na, “Maˈya mau, ǝnga ja, hya sǝya ˈya Barabasu!” ");
INSERT INTO mfm_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Nji mbiya Barabasu wu fursǝna ara hya hangǝkala nji ǝnga tsa ndau.) ");
INSERT INTO mfm_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bilatusu ɓǝra ndǝr anǝ nda, arya ju yiwu ja sǝya Yesu. ");
INSERT INTO mfm_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ama kǝ ndǝ nggya kǝl hya ɗahǝu, “Dlakǝya nyi nji! Dlakǝya nyi nji!” ");
INSERT INTO mfm_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Bilatusu ɓǝra ndǝr anǝ nda nǝ makǝrkura nyi, “Ara mi ya? Wa thlǝmǝ sǝ ɗǝmwaˈyi kǝra ndǝ kǝ mǝliya? Nayi nǝ ɗa, nayi thlǝwa nyi ǝnga bikau kǝra ɗa tsaˈa nja tsǝya nyi mai. Yu sǝwa nja nǝ nyi wuɗa, ba nja sǝya nyi.” ");
INSERT INTO mfm_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ama kǝ ndǝ taˈyi nǝr nda abǝr kǝl nji dlakǝya nyi. Wu yukuɗu ba ndǝ ndiya dǝnama nyi. ");
INSERT INTO mfm_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kǝ Bilatusu mǝliya ǝnggǝra ndu yiwu. ");
INSERT INTO mfm_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kǝ ji sǝya nda ndǝ kǝ ndu yiwu kau, ndǝra nji fuwa wu fursǝna ara hya hangǝkala nji ǝnga tsa ndau. Kǝ ji nǝ nda Yesu aga nda mǝl sǝra ndu yiwu ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ənggǝra sojaˈyar a vǝr maˈyi ǝnga Yesu, Kǝ ndǝ ɓau ǝnga vanyi ndau nja ngga ǝnga Simanu, ndǝr Sayirini, ja vǝr si sara wu miya tagǝu. Ndǝ taˈyina nyi, ndǝ fǝri nyi wu dladlakau ar kǝra ja, ji dzǝgwa nu Yesu ǝni wu yukuɗu. ");
INSERT INTO mfm_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nji gangǝ gagaɗau a vǝr nu nyi, wu pama nda alenyi mathlǝkǝˈyi aˈyi kǝra a vǝr tiwi, nda vǝr wau ar kǝra ja. ");
INSERT INTO mfm_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kǝ Yesu shabiya dzǝ a nda kǝra nda, ji na, “Mathlǝkǝˈyi nǝ Urshalima! A sara hya tiwi ar kǝra yi mai, ama hya tiwi ar kǝra kǝrhyi ǝnga wazhar hyi. ");
INSERT INTO mfm_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Arya pǝci a vǝr shili kǝra nju sa na, ‘Sǝr caguli ngau anǝ mathlǝkǝˈyi ciri, njira gǝra vǝr ya, ǝnga njira gǝra sayi mbiya wazha Kǝrnda wu yi.’ ");
INSERT INTO mfm_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","A sa ɗa wu pǝci kau, “ ‘Nji wu nda na anǝ mau, “Dla mau a gyar kǝra ˈya!” Ənga anǝ garˈyar, “Mbuya ˈya!” ’ ");
INSERT INTO mfm_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Ma nji mǝl abangau anǝ wu nyanyaɓǝu, abari nga nyi wu nda ɗa anǝ wu uˈula?” ");
INSERT INTO mfm_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nji ɗǝmwaˈyi mǝthlǝ nji lǝbiya nda tsu aga nja tsǝya nda ǝnga Yesu. ");
INSERT INTO mfm_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ənggǝra ndǝ shili ar vi kǝra nja ngga ǝnga “papangǝkǝr,” kǝ nji dlakǝya nyi a ndǝna, ǝnga nji ɗǝmwaˈyi mǝthlǝ ta, pathlǝu lagu mazǝma ja ǝnga pathlǝu lagu matsala ja. ");
INSERT INTO mfm_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kǝ Yesu na, “Tada, tǝfǝbiya nda, arya nanda sǝni sǝra nda vǝr mǝl mai.” Kǝ ndǝ dzǝgwa tǝtǝkǝna kar ha nyi wu lagur tǝɗǝ shiˈwu. ");
INSERT INTO mfm_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nji gangǝu taˈyi nda vǝr tsamǝ ǝnggǝra nji dǝdǝgal a vǝr diɗa nyi, nda vǝr na, “Ji mbǝɗana alenyi nji, kabangǝkǝ ja mbǝɗana kǝrnyi, ma naja ngǝ Kǝrsiti kǝra Hyal caɗǝbiya.” ");
INSERT INTO mfm_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sojaˈyar tsu ndǝ diɗana nyi lagur nǝ nyi ˈyimir wur inabi kǝra ɗar mwamwalu. ");
INSERT INTO mfm_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nda vǝr na anǝ nyi, “Ma nagǝ ngǝ tǝl nǝ Yahudiya, ga mbǝɗana kǝrngau!” ");
INSERT INTO mfm_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Adabanga ja ndǝ tsǝfǝri vanyi tsǝfǝ kǝra na, “NDƏ KƏ NGƏ TƏL NƏ NJIR YAHUDIYA.” ");
INSERT INTO mfm_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pathlǝ wu pama nji ɗǝmwaˈyi kǝra nji dlakǝya ǝnga ja na ndǝr didiɗi anǝ nyi, “Aˈyi nagǝ ngǝ Kǝrsiti ndangǝ wa? Mbǝɗana kǝrngau ǝnga ˈya!” ");
INSERT INTO mfm_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ama kǝ nǝ mǝthlǝkura nyi kughi anǝ kuvwa nyi ji na, “Aˈyi gu hivǝr Hyal wa? Na ngǝ kǝra nji thlana hyi numa zǝmǝ ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nama nǝr ma, tsaˈa ngǝ sǝra nja vǝr mǝl anǝ ma ara sǝra mǝ mǝliya. Ama ndǝ kǝ nǝ nyi, mi ngǝ bikǝ nya?” ");
INSERT INTO mfm_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kǝ ji na, “Yesu, ga ɗǝngari ɗa ma gǝ vu tǝlkur ngau!” ");
INSERT INTO mfm_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu shaɗǝwa nyi, ji na, “Ya nar ngau jirkura nyi, ǝshina gu nda nggya ǝnga yau a du zarna.” ");
INSERT INTO mfm_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ma pǝci taˈyikǝr, kǝ kuthlǝu haɗiya patǝkura ˈyiˈyi, baˈa ndu saka makǝr nǝ wagǝu, ");
INSERT INTO mfm_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ara ǝnggǝra pǝci nggǝl ara mbǝl. Kadǝmbul kǝra a gwu ki Hyal tǝwa kǝr pamǝpamǝ mǝthlǝu. ");
INSERT INTO mfm_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu hyaˈana ɗahǝu ǝnga dǝnama ji na, “Tada, a vu pǝla gǝ nga yi fiya piya yau.” Ənggǝra ji nana abangau, ba ji sǝna pi nǝ tau. ");
INSERT INTO mfm_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ənggǝra soja dǝgal kǝra a ndǝna wu pǝci kǝ lari sǝ kǝ ɗa kau, kǝ ji fal Hyal ja vǝr na, “Pakatǝu, ndǝ kǝ ndǝ gǝra bikǝ ngau.” ");
INSERT INTO mfm_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ənggǝra njira daɓau aga tsamǝ sǝ tsatsamǝ, lari sǝ kǝ ɗarkǝr kau, kǝ ndǝ sha a ndu ki nda vǝr thlǝ nggǝrau ara huɗǝ ndzǝndzau. ");
INSERT INTO mfm_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Patǝkura njira sǝni Yesu, ǝnga mathlǝkǝˈyi kǝra nu nyi sara wu ˈyiˈyi Galili, ndǝ taˈyi tsalǝu nda vǝr tsamǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kabangǝkau, vanyi ndau aˈyi kǝra nja ngga ǝnga Yusufu, naja pathlǝu wu pama nji dǝdǝgal nǝ njir Yahudiya, naja ndǝ mǝnahǝu ǝnga ndǝ jiri, ");
INSERT INTO mfm_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","naja tsu aˈyi hǝnggǝri ǝnga sǝra nji mbiya ǝnga sǝra nji mǝl mai. Ji shili sara wu mǝlmǝ Arimatiya wu ˈyiˈyir Yahudiya. Naja tsu ja vǝr sǝkǝ shilir tǝlkur Hyal. ");
INSERT INTO mfm_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kǝ ji maˈyi a ndara Bilatusu aga ja nda kǝdi nja nǝ nyi dza Yesu. ");
INSERT INTO mfm_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kǝ ji hǝya dza ja nyi sara dar wu, ji pǝɗiya wu paˈwa, ji dzǝgwa fuwa nyi a gu hu kǝra nji labiya a vu mau, hu kǝ nji sayi haɗǝna ndau a gwa mai. ");
INSERT INTO mfm_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pǝcir fǝ sau wu lagu ngau, a hyiri kushu nja vu pǝcir Ɓǝlsar. ");
INSERT INTO mfm_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mathlǝkǝˈyi kǝra nu Yesu sara wu Galili maˈyi ǝnga Yusufu aga nda lari hu kau, ǝnga ǝnggǝra nju nda fǝ dza Yesu. ");
INSERT INTO mfm_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ndǝ dzǝgwa sha a ndu ki, ndǝ nda uya sǝ kisǝu ǝnga mal ɓǝsau. Kǝ ndǝ sǝbiya hǝɗa pǝcir Ɓǝlsar, ǝnggǝra dlaɗǝ nǝ lagu Musa nar nda. ");
INSERT INTO mfm_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Umudlǝ kaɗǝu pǝci tanggǝrma nǝ sugu mathlǝkǝˈyi ya nyi hyaˈari ndǝ hǝri sǝ kisǝu kǝra ndǝ mǝliya, ndǝ maˈyi ǝni a ndar hu. ");
INSERT INTO mfm_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kǝ ndǝ thlǝwa a jahǝnari nji tsǝka kǝra a miya huwa nyi. ");
INSERT INTO mfm_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ndǝ gu hu kau, ama nandǝ lari dza Thlagǝ Yesu mai. ");
INSERT INTO mfm_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ma tsu nda vǝr ɗǝnga sǝkǝ ɗa kau, kukuthlǝ kǝ ja nji mǝthlǝ tataˈyu lǝhǝu wu dzǝri nda, wu kari pǝr tǝ pwahǝu a vǝr mbǝl. ");
INSERT INTO mfm_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nyinyau ǝnga hivǝr, kǝ mathlǝkǝˈyi kǝ uzhau ǝnga kǝra nda a gyiwu ˈyi. Kǝ nja nyi na anǝ nda, “Ara mi nga hya gal ndǝra ǝnga pi wu pama nji tǝta? ");
INSERT INTO mfm_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Aˈyi ja ngǝ mai, a hyaˈari ja. Hya ɗǝngari sǝra ji na anǝ hyi tsu ja ǝnga hyu Galili. ");
INSERT INTO mfm_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ji na, ‘Pakatǝ nǝ nyi nju nǝ nyi Zǝr Ndau a ndu tsa njir bikau, ndu dlakǝya nyi, pǝcir pida makǝrkura nyi ju hyaˈari ǝnga pi.’ ” ");
INSERT INTO mfm_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ənggau kǝ ndǝ ɗǝngari sǝra ji na. ");
INSERT INTO mfm_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ənggǝra ndǝ sha shili sara ndǝr huwa nyi, kǝ ndǝ nar nyi anǝ zǝmbǝlma nyiˈyar kumo a sǝrtangǝ ta ǝnga alenyi nji sǝˈyar kǝ ɗa kǝ patǝu. ");
INSERT INTO mfm_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mathlǝkǝˈyi kǝra na sǝˈyar kǝ anǝ cama sǝsǝˈyar kau, nanda ngǝ, Maryamu Magǝdaliya ǝnga Yuwana, ǝnga Maryamu miya Yakubu, ǝnga alenyi mathlǝkǝˈyi kǝra nda ǝni. ");
INSERT INTO mfm_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ama nandǝ hǝnggǝri sǝra mathlǝkǝˈyi kǝ na mai, ara ma ndu nggani jiri aˈyi wu ndǝr kǝ mai. ");
INSERT INTO mfm_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ama kǝ Biturusu, hyaˈari maɗu ǝnga hwi a ndar huwa nyi, ji nda uzhau, ji tsambiya hu ɗa huwa nyi, kǝl paˈwa kǝra nji pǝɗiya nyi a gwa ca ngǝ baˈa ar dza huwa nyi. Kǝ ji sha a ndu ki ja vǝr ɗǝnga sǝ dǝdǝgur kǝ ɗa kau. ");
INSERT INTO mfm_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pǝci ta tsu njir nu Yesu aˈyi mǝthlǝ kǝra a vǝr maˈyi a ndu mǝlmǝ kǝra nja ngga ǝnga Imawusu, kǝra naɗǝkura nyi wu ɗa miyal mǝɗǝfǝ sara wu Urshalima. ");
INSERT INTO mfm_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nda vǝr ndǝr wu pama nda ar kǝra sǝˈyar kǝ ɗarkǝr kau. ");
INSERT INTO mfm_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ənggǝra nda vǝr ndǝr wu pamǝ nda nda vǝr thla sǝmana, kǝ Yesu ǝnga kǝrnyi lǝhǝn nda, ja vǝr ɓǝ ǝnga nda, ");
INSERT INTO mfm_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","a lari nyir nda, ama nandǝ tsamǝ ri nyi mai. ");
INSERT INTO mfm_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kǝ ji na anǝ nda, “Wa thlǝmǝ najaka sǝmana hya vǝr thla wu pama hya, hya vǝr ɓa?” Kǝ ndǝ taˈyi zǝmǝu, ǝnga huɗǝ ndzǝndzau. ");
INSERT INTO mfm_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Pathlǝ wu pama nda, kǝra nja ngga ǝnga Kǝliyopasu, yiwa nyi, ji na, “Na gǝ mǝthlǝpi wu Urshalima, kǝra na ngǝ sǝnbiya sǝra ɗarkǝr wu pidaˈyar kǝ mai ya?” ");
INSERT INTO mfm_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kǝ ji na anǝ nda, “Sǝr mi ˈyar ara?” Kǝ ndǝ na anǝ nyi, “Sǝra ɗa ǝnga Yesu ndǝr Nazǝratu. Naja nabi, kǝra ǝnga dǝnama wu sǝra ju na ǝnga mǝl wu mwar Hyal ǝnga nji patǝu, ");
INSERT INTO mfm_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","kǝ pubu dǝdǝgalˈyar ǝnga nji dǝdǝgal nǝr mǝn lǝri nyi aga nja tsǝya nyi, kǝ ndǝ dzǝgwa dlakǝya nyi ar wu dladlakau. ");
INSERT INTO mfm_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ɗǝɗǝmǝ ˈyi wu nggani abǝr naja ngu sa mbǝɗana njir Izirayila! Ama kǝ ja ǝshina ngǝ pida makǝrkura nyi ǝnggǝra sǝ kǝ ɗarkǝr. ");
INSERT INTO mfm_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kǝl kǝ zhizhi nyi mai, alenyi mathlǝkǝˈyi kǝra wu pama ˈya nar ˈya sǝ dǝdǝgur. Ara ndǝ maˈyi a ndar huwa nyi ǝmudlǝ kaɗǝu, ");
INSERT INTO mfm_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ama nandǝ thlǝwa dza ja wu hu mai, kǝ ndǝ sha shili, ndǝ nar ˈya, abǝr ndǝ lari waladi kǝra na anǝ ˈya abǝr ǝnga pi nga ja. ");
INSERT INTO mfm_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Alenyi nju pama ˈya ndǝ maˈyi a ndar hu ndǝ nda lari abangǝ nga nyi ǝnggǝra mathlǝkǝˈyi ta na, ama nanda ǝnga Kǝrnda nandǝ lari nyi mai.” ");
INSERT INTO mfm_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kǝ Yesu na anǝ nda, “Əm, nahyi nji kǝra gǝra ǝnga ɗǝnga, aˈyi ɓatsǝ anǝ hyi hya hǝnggǝri ǝnga sǝra nabiˈyar nana mai! ");
INSERT INTO mfm_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","A mbari anǝ Kǝrsiti ja sa ɓwaɓwatǝˈyar kau, ja dzǝgwa gu kadakadarkur nyi, aˈyi abangǝ wa?” ");
INSERT INTO mfm_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kǝ ji cabiya nda sǝra tsǝtsǝfǝ nǝ ndǝr Hyal na ar kǝra ja, mbari ar highiɓǝ Musa baˈanǝ tsǝfǝri nabiˈyar patǝu. ");
INSERT INTO mfm_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ənggǝra ndǝ dla lǝhǝu wu dzǝri mǝlmǝ kǝra nda vǝr maˈyi a vuwa gwa, kǝ Yesu mǝl ǝnggǝr tǝrabiya a ndumwar nda, ");
INSERT INTO mfm_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ama kǝ ndǝ ciɗǝ nyi nda vǝr na, “Nggya ǝnga ˈya, ara wagǝu a ɗari, kǝ ja pǝci a gya tǝɗǝri.” Kǝ ji nu nda ji nda nggya ǝnga nda. ");
INSERT INTO mfm_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ənggǝra ndǝ nggya aga sǝm sǝr sǝm, kǝ ji hǝri macikǝl ba ji fǝnggǝr barka, kǝ ji ɓǝɓǝlǝwa ba ji tǝkǝna nda. ");
INSERT INTO mfm_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ənggau kǝ liya nda pahau, ndǝ tsamǝ ri nyi. Ama kǝ ji sanakǝr wu liya nda. ");
INSERT INTO mfm_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ndǝ na anǝ kuvwar nda, “Ɗǝm ya, hu ɗa mǝn aˈyi nyinyau ǝnga caguli ar pǝci kǝra ja vǝr ndǝr anǝ mǝn ar lagu wa, ǝnggǝra ja vǝr cabiya mǝn sǝra tsǝtsǝfau wu ndǝr Hyal wa?” ");
INSERT INTO mfm_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kǝ ndǝ hyaˈari ǝnga kusa ndǝ sha a vu Urshalima. Ndǝ thlǝwa nanda kumo a sǝrtangǝ ta ǝkkǝˈyi alenyi nji a vu na, ");
INSERT INTO mfm_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","kǝ ndǝ nar nda, kadzangǝ, “Thlagǝ a hyaˈari! A canǝ nyi ja kǝrnyi anǝ Biturusu!” ");
INSERT INTO mfm_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ənga tsu nanda mǝthlǝ kǝ nar nda sǝra ɗa ǝnga nda wu lagu ǝnga ǝnggǝra ndǝ tsamǝ ri Yesu ayukuɗa ji ɓǝɓǝlǝwa nda macikǝl. ");
INSERT INTO mfm_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tsu nda vǝr ndǝr ar kǝra sǝ kau, kukuthlǝ kǝja Yesu taˈyu wu pama nda, kǝ ji na anǝ nda, “Jamǝkur ja nggya ǝnga hyi.” ");
INSERT INTO mfm_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ama kǝ ndǝ gǝrahǝ nda vǝr tsǝdzau, ma ndǝ nggani dǝgur ngǝ canǝ nda kǝr. ");
INSERT INTO mfm_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kǝ ji na anǝ nda, “Mi ngǝ ɗa hyi gǝrahǝ abanga, ǝnga hyu nggya ǝnga tǝkǝkǝr wu ɗǝfuwa hya? ");
INSERT INTO mfm_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tsamiya mau tsa yau ǝnga hya yau aga hya lari, nayi ǝnga kǝrɗa ngau. Tsǝkwar ɗa mau, aga hya sǝni abǝr dǝgur aˈyi ǝnga kum ǝnga ɗǝhi, ǝnggǝr kǝ hya vǝr lari ɗa kǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ayukuɗa ji nana abangau, kǝ ji canǝ nda tsa ja ǝnga hya ja. ");
INSERT INTO mfm_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tsu nda vǝr caguli ara sǝ dǝdǝgur kǝ ɗa kau, ama tsu nda ǝnga tǝkǝkǝr wu ɗǝfuwa nda, kǝ ji na anǝ nda, “Sǝr sǝm aˈyi ara hyi nga nyi ya?” ");
INSERT INTO mfm_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kǝ ndǝ nǝ nyi kalfi kukubwa. ");
INSERT INTO mfm_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kǝ ji dlǝwuri ji sǝmku, nanda kǝl tsamǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ji na anǝ nda, “Sǝˈyar kǝ ngǝ sǝra yi ndǝr anǝ hyi ar kǝri pǝci kǝra yi tsu ǝnga hyi, abǝr a mbari nja nyabiya sǝra nji tsǝfǝri ar kǝra yau wu dlaɗǝ nǝ lagu Musa, ǝnga tsǝfǝ nǝ nabiˈyar ǝnga Zabura tsu.” ");
INSERT INTO mfm_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kǝ ji mǝliya ndǝ sǝnbiya sǝra tsǝtsǝfau wu ndǝr Hyal, ");
INSERT INTO mfm_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ji nar nda, “Abangǝ nga nyi tsǝtsǝfau, abǝr a ɗar tsaˈa anǝ Kǝrsiti ja lari ɓwaɓwatǝu, pǝci makǝrkura nyi ba ja hyaˈari sara vir tau. ");
INSERT INTO mfm_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ətsu wu thlǝmǝ nyi nga nju nda tǝtǝlna ndǝr Hyal anǝ njir duniya patǝ aga nda tubi nda uya tǝfǝbiya bikǝr nda. Nju nda dzǝguya sǝ kǝ wu Urshalima. ");
INSERT INTO mfm_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nahyi ngǝ sakida sǝˈyar kau. ");
INSERT INTO mfm_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kǝja, yu nda sǝwa hyi sǝra dǝɗa mǝliya hyi alkawal abǝr ju sǝwa. Ama hya sǝkǝ wu mǝlmǝ kwatahǝu, kǝl nji nǝ hyi dǝnama sara dǝmǝlmau.” ");
INSERT INTO mfm_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kǝ ji hǝbiya nda a biyar ya mǝlmau, ndǝ maˈyi ba a vu Bethlani. A ndǝna, ji hyaˈana tsa ja dǝmǝlmau kǝ ji fǝnggǝr nda barka. ");
INSERT INTO mfm_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ənggǝra ja vǝr fǝ barka anǝ nda, kǝ ji tǝkǝbiya dzǝ ǝnga nda, ji maˈyi a dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nanda tsu ndǝ dzǝgwa dlǝvǝ nyi, ndǝ sha a vu Urshalima, nyinyau ǝnga huɗǝ pǝrtǝu gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ndu shili parangǝ tsu wu ki Hyal nda vǝr fal Hyal.");
INSERT INTO mfm_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kadivira Hyal dzǝguya duniya ndǝr aˈyi, ndǝr kǝ ǝnga Hyal nga ja, ǝnga tsu ndǝr kǝ Hyal ngau. ");
INSERT INTO mfm_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aˈyi ja ǝnga Hyal kadivira ja dzǝguya duniya. ");
INSERT INTO mfm_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Lagu nyi ngǝ Hyal mǝliya sǝ patǝu, ma aˈyi ǝnga ja mai, sǝ aˈyi kǝra Hyal mǝliya wu sǝra ji mǝlna mai. ");
INSERT INTO mfm_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Wu ja ngǝ pi, najaka pi tsu ca ngǝ mbǝmbǝl nǝ nji. ");
INSERT INTO mfm_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mbǝmbǝla nyi a vǝr mbǝl wu kuthlǝu, ama kuthla nyi aˈyi a sǝn ciya mbǝmbǝla nyi mai. ");
INSERT INTO mfm_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Vanyi ndǝ aˈyi kǝra Hyal sǝwa, thlǝmǝ nyi ca ngǝ Yahwana. ");
INSERT INTO mfm_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ji shili ar viya sakida ar kǝra mbǝmbǝl kau, aga patǝr nju nda mbǝrsa ǝnga ja lagu nyi. ");
INSERT INTO mfm_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Naja ǝnga kǝrnyi ngǝ mbǝmbǝl kǝ mai, ama ji shili ar viya sakida ar kǝra mbǝmbǝla nyi. ");
INSERT INTO mfm_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mbǝmbǝl kǝra jiri, kǝra wu nǝ nyi mbǝmbǝlkur anǝ kalar ndǝ a vǝr shili wu duniya. ");
INSERT INTO mfm_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ji shili wu duniya kǝra naja ngǝ mǝliya ǝnga kǝrnyi, ama alaga abangau, njir duniya aˈyi sǝnbiya nyi mai. ");
INSERT INTO mfm_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ji shili aga ˈyiˈyi kǝra nǝ nyi, ama nji nyi aˈyi dlǝwuri nyi mai. ");
INSERT INTO mfm_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ama anǝ patǝr njira dlǝwuri nyi, njira mbǝrsa ǝnga thlǝmǝ nyi, anǝ ndar ja dǝnama nǝ ɗa wazha Hyal. ");
INSERT INTO mfm_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Aˈyi wazha yaya wu ndǝkur mai, alaga lagur cim nǝ ndǝkur mai, ǝnga alaga lagur ɗǝnga nǝ salkur mai, ama yaya sara ara Hyal. ");
INSERT INTO mfm_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ndǝr kau, ba ji ɗa ndapi, ba ji nggya wu pama mǝn. Naˈya tsu lari kadakadarkur nyi, kadakadarkur nǝ Zǝr Zǝmǝ pathlǝ sara ara Tada, kǝra nyinyau ǝnga mayiwakur ba ǝnga jirkur. ");
INSERT INTO mfm_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yahwana ngǝ lǝr sakida ar kǝra ja, ji hyaˈana ɗahǝu, ji na, “Naja kǝ ngǝ ndǝra yi ndǝr ar kǝra ja ar pǝci kǝra yi na, ‘Ndǝra wu shili wu yukuɗǝ ɗa, naja ndiya ɗa, ara aˈyi ja kadivira nji ya ɗa.’ ” ");
INSERT INTO mfm_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Sara wu nyinyikur nǝ mayiwakur nyi nga mǝn uya barka, ju lǝ mayiwakur nyi ar kǝr ar kǝr. ");
INSERT INTO mfm_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Arya dlaɗǝ shili lagu tsa Musa, ama mayiwakur ǝnga jirkur shili lagu Yesu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ndǝ aˈyi kǝra saya fǝr li ar Hyal mai, ama kǝl Zǝr Hyal Zǝmǝ pathlǝu, kǝra a vǝr nggya ǝnga Tada, a cabiya mǝnǝr ja Hyal. ");
INSERT INTO mfm_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kǝja sakida kǝra Yahwana lǝri ar pǝci kǝra njira nggurǝm nǝ Yahudiya sara wu Urshalima sǝwa pubuˈyar ǝnga njir Lawi aga nda yiwabiya tara wa nga ja. ");
INSERT INTO mfm_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Naji nggǝl ara nar nda jiri mai, ama ji nana ar babal abǝr, “Nayi ngǝ Kǝrsiti mai.” ");
INSERT INTO mfm_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kǝ ndǝ yiwa nyi ndǝ na, “Ya, wa nga ga? Nagǝ ngǝ Iliya ya?” Kǝ ji shaɗǝwa nda, ji na, “Awau, nayi ngǝ mai.” Əngwar nda, “Ya, nagǝ ngǝ nabiya nyi ya?” Kǝ ji shaɗǝwa, “Awau.” ");
INSERT INTO mfm_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ayukuɗa nyi patǝu, kǝ ndǝ na, “Wa nga ga? Nar ˈya sǝra ˈya sha ˈya nda nar nyi anǝ njira sǝwa ˈya. Mi nga gu na ar kǝra kǝr nga?” ");
INSERT INTO mfm_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Kǝ Yahwana shaɗǝwa nda lagu ndǝr nabi Əshaya, ji na, “Nayi ngǝ ɗahǝ a vǝr ngga a gwar tagǝu, ja vǝr na, ‘Hya pabǝri nyi lagu anǝ Thlagǝu, hya mǝliya lagu tataˈyi pir wu mwa nyi.’ ” ");
INSERT INTO mfm_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kǝ alenyi njir Farisi, njira nji sǝwa ");
INSERT INTO mfm_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","yiwa nyi, “Ma nagǝ aˈyi Kǝrsiti mai, ǝnga nagǝ aˈyi Iliya mai, ba nagǝ tsu aˈyi nabiya nyi mai, mi ngǝ ɗa gu mǝl baɓǝtizǝma?” ");
INSERT INTO mfm_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Əngwar Yahwana, “Nayau, ya vǝr mǝl baɓǝtizǝma anǝ hyi ǝnga ˈyimi. Ama vanyi ndǝra ndiya ɗa ǝnga dǝnama a vǝr shili, kǝra alaga sǝr mba ɓiɓi nyi nayi aˈyi ɗa tsa aga ya pǝlna mai. ");
INSERT INTO mfm_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ju sa mǝliya hyi baɓǝtizǝma ǝnga Mambǝl Cicau ba ǝnga uˈu.” ");
INSERT INTO mfm_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Sǝˈyar kǝ patǝ ɗarkǝr wu Bethlani, a biyar ya dǝl Urdǝnu, vira Yahwana a vǝr mǝl baɓǝtizǝma ari. ");
INSERT INTO mfm_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Əzǝgǝkura nyi ba Yahwana lari Yesu a vǝr shili lagu nyi, kǝ ji na, “Kǝja, Zǝr Gamǝ nǝ Hyal, kǝra hǝna bikǝ nǝ njir duniya! ");
INSERT INTO mfm_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ndǝ kǝ nga ya vǝr ndǝr ar kǝri ta, ta yi na, abǝr ‘Ndǝ aˈyi a vǝr shili ayukuɗǝ ɗa, ama naja dǝgal a ndiya ɗa ara tsu ɗǝɗǝmǝ aˈyi ja kadivira nja ya ɗa.’ ");
INSERT INTO mfm_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nayi ǝnga kǝrɗa sayi sǝni nyi mai, ama yi shili, yi sa mǝl baɓǝtizǝma ǝnga ˈyimi anǝ nji aga ya cabiya nyi anǝ njir Izirayila.” ");
INSERT INTO mfm_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kǝ Yahwana lǝri najaka sakida abǝr, “Yi lari Mambǝl a vǝr shida sara dǝmǝlmau, a papa mbǝthla, ji sa ndzafau a dar kǝra ja. ");
INSERT INTO mfm_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nayi ǝnga kǝrɗa yu sǝni nyi mai, ama kǝl ta ndǝra sǝwa ɗa aga sa mǝl baɓǝtizǝma ǝnga ˈyimi nar ɗa abǝr, ‘Ndǝra gǝ lari Mambǝl ndzafau ar ja, naja ngu nda mǝl baɓǝtizǝma anǝ nji ǝnga Mambǝl Cicau.’ ");
INSERT INTO mfm_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nayi tsu a lar yi sǝkǝ nyabiya dzǝ ar kǝra ja, ca ngǝ ɗa yi lǝri sakida abǝr ndǝ kau, Zǝr Hyal ngau.” ");
INSERT INTO mfm_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Əzǝgǝkura nyi Yahwana ǝnga nji mǝthlǝ sara wu pama zǝmbǝlma nyiˈyar ar vi ta wayu. ");
INSERT INTO mfm_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kǝ Yahwana lari Yesu ja vǝr tǝrabiya, kǝ ji na, “Lara mau, Zǝr Gamǝ nǝ Hyal!” ");
INSERT INTO mfm_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ənggǝra zǝmbǝlmaˈyar kǝ mǝthlǝ nggari sǝra Yahwana na, kǝ ndǝ nu Yesu. ");
INSERT INTO mfm_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ta Yesu shabiya dzau, ba ji lari nda nda a vǝr nu nyi, kǝ ji yiwa nda, “Mi nga hyu gala?” Əngwar nda, “Rabi” kǝra cabiya Malǝmǝ ngau, “Əmani nga gu nggya?” ");
INSERT INTO mfm_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kǝ Yesu shaɗǝwa nda, ji na, “Anda mau hya sa lari.” A ndu saka foɗǝ nǝ wagǝu, kǝ ndǝ maˈyi ndǝ nda lari viya nyi, ba ndǝ hǝna pǝkǝ ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andǝrawusu, zamǝya Simanu Biturusu, aˈyi ja pathlǝ wu pama nji mǝthlǝ kǝra nu Yesu ayukuɗa Yahwana nana ndǝr ar kǝra Yesu. ");
INSERT INTO mfm_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Sǝ tanggǝrma kǝra Andǝrawusu mǝliya ca ngǝ, ji maˈyi ji nda thlǝwa zamǝ nyi Simanu, ba ji nar nyi, “A nǝr ˈya Ndǝ Cacaɗau” ndǝra nju ngga ǝnga Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kǝ ji shili ǝnga Simanu a shili ara Yesu. Yesu tsamǝ nyi, ba ji na, “Nagǝ ngǝ Simanu zǝr Yahwana. Nju nda ngga ngau ǝnga Kefasu,” kǝra ma nji shabiya ca ngǝ Biturusu. ");
INSERT INTO mfm_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Əzǝgǝkura nyi tsu kǝ Yesu biya ju maˈyi a vu Galili. Kǝ ji thlǝwa Fǝlipǝu, kǝ ji na anǝ nyi, “Nu ɗa.” ");
INSERT INTO mfm_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fǝlipǝu sara wu Bethlesaida nga ja, mǝlmǝr Andǝrawusu ǝnga Biturusu. ");
INSERT INTO mfm_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Fǝlipǝu maˈyi ji nda thlǝwa Nathlaniyalu, kǝ ji na anǝ nyi, “A nǝr ˈya ndǝra Musa tsǝfǝri sǝ ar kǝri wu lǝkakaɗǝ nǝ dlaɗau ǝnga nabiˈyar tsu tsǝfǝri, naja ngǝ Yesu ndǝr Nazǝratu, zǝr Yusufu.” ");
INSERT INTO mfm_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Kǝ Nathlaniyalu yiwa ji na, “Sǝ tsapǝu a sǝn biya sara wu Nazǝratu ya?” “A ndǝ ga sa lari ǝnga kǝrngau,” ǝngwar Fǝlipǝu. ");
INSERT INTO mfm_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ta Yesu lari Nathlaniyalu a vǝr shili ara ja, kǝ ji na ar kǝra ja, “Lara mau ndǝr Izirayila nǝ jijiri, ndǝra gǝra ǝnga nggyabiya fafati.” ");
INSERT INTO mfm_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Kǝ Nathlaniyalu yiwa ji na anǝ Yesu, “Lagu mani nga gǝ sǝn ɗa?” Əngwar Yesu, “Ar pǝci kǝra gǝ ǝgya kiɗa wur martǝndǝm ta nga yi lar ngau, kadivira Fǝlipǝu dzǝgwa ngga ngau.” ");
INSERT INTO mfm_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kǝ Nathlaniyalu na, “Malǝmǝ, nagǝ ngǝ Zǝr Hyal; nagǝ ngǝ Tǝl nǝ njir Izirayila!” ");
INSERT INTO mfm_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu nar nyi anǝ Nathlaniyalu, “Gǝ mbǝrsa ara yi nar ngǝ abǝr yi lar ngǝ ar pǝci kǝra gǝ ǝgya kiɗa wur martǝndǝm ta ya? Jiri, gu nda lari sǝra a ndiya kau.” ");
INSERT INTO mfm_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kǝ Yesu ɓǝra nar nyi, “Ənga jiri nga yu na anǝ hyi, hyu nda lari dǝmǝlmǝ a pahǝri, waladiˈyar nǝ Hyal a vǝr di ǝnga gya ar kǝra Zǝr Ndau.” ");
INSERT INTO mfm_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ar pǝci nǝ makǝrkura nyi, mini nǝ hǝ dzǝ aˈyi wu mǝlmǝ Kana nǝ ˈyiˈyir Galili. Miya Yesu aˈyi ja a ndǝna. ");
INSERT INTO mfm_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu ǝkkǝˈyi zǝmbǝlma nyiˈyar ma nji nggǝya nda a shili ar vir mini kau. ");
INSERT INTO mfm_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ənggǝra ˈyimir wur inabi kuɗau, kǝ miya Yesu na anǝ nyi, “ˈYimir wur inabir nda a kuɗǝri.” ");
INSERT INTO mfm_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu shaɗǝwa nyi, ji na, “Ama, mi ngǝ nǝr mǝn wu sǝ ka? Pǝci ɗa ma aˈyi ɗa kwatahǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kǝ miya Yesu nar nyi anǝ njir tǝkǝ sǝr sǝm, “Nahya mau, kalar sǝra ji na anǝ hyi, ca nga hya mǝl.” ");
INSERT INTO mfm_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Lǝha dzǝr viya nyi ha tsǝka aˈyi kwa, kǝra njir Yahudiya wu kǝbǝ kwatǝ ci dzǝ ǝni, ǝnggǝr kǝra mbǝrsar nda cabiya. Kalar ha nyi wu sǝn hǝri ǝgwa kwa kwa ǝnga ˈyimi. ");
INSERT INTO mfm_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kǝ Yesu nar nyi anǝ njir tǝkǝ sǝr sǝm, “Nyanyana mǝ haˈyar kǝ patǝ ǝnga ˈyimi.” Ba ndǝ nyanyana nda ba ar miya. ");
INSERT INTO mfm_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kǝ ji na anǝ nda, “Kabangǝkau, gǝri nya mau a nda nǝ tsahwaˈa.” Kǝ ndǝ gǝri ndǝ hǝr nyi a nda. ");
INSERT INTO mfm_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ta tsahwaˈa ɗahari ˈyimi hyalagǝ kǝra sha aga ˈyimir wur inabi, naji sǝnbiya vira nji uya nyi sara ar mai, ama njir tǝkǝ sǝr sǝm wu sǝni. Kǝ tsahwaˈa nggar salkwanjili a ndumwar sau, ");
INSERT INTO mfm_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","kǝ ji na anǝ nyi, “Kalar ndu shili ǝnga ˈyimir wur inabi kǝra ndiya ǝnga mǝsahǝu tsu kaɗǝu, ayukuɗa ndǝ sa, ndǝ nyau, ba nja shili ǝnga kǝra cacaɓǝu, ama, nǝ ngǝ kau, pamǝ nga nyi ara nji, gǝ piyari kǝra mǝsahǝu kǝl kabangǝkau!” ");
INSERT INTO mfm_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Najakǝ ngǝ sǝ dǝdǝgur nǝ tanggǝrma kǝra Yesu mǝliya, ji mǝliya sǝ kǝ wu mǝlmǝ Kana nǝ Galili. Najakǝ ngǝ cabiya kadakadarkur nyi, ǝnga ji mǝliya zǝmbǝlma nyiˈyar mbǝrsa ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ayukuɗa kǝ ngǝ Yesu ǝnga mǝnyi ǝnga zamǝ nyiˈyar ba ǝnga zǝmbǝlma nyiˈyar maˈyi a gyiwu Kafarnahumu. A gyina, ndǝ sǝkari nǝ pida ɗiyawu. ");
INSERT INTO mfm_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ta pǝcir lardur vǝlna nǝ njir Yahudiya ɗa lǝhǝu, kǝ Yesu maˈyi a du Urshalima. ");
INSERT INTO mfm_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Wu huɗa ki Hyal, ba ji thlǝwa nja vǝr ɗǝlna thla, ǝnga tǝmahǝu ǝnga mbǝthlaˈyar aga saɗaka, ba ji thlǝwa alenyi nji tsu nda vǝr bǝla bǝla gǝnnar nda. ");
INSERT INTO mfm_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kǝ Yesu lǝmiya kurpǝ sara wu ǝpa, ba ji kǝdlǝbiya nda patǝ sara wu Ki Hyal. Ji kǝdlǝbiya tǝmahǝ ǝkkǝˈyi thla, ba ji shashabiya tǝmbǝl bǝla bǝla gǝnnar nda a dǝmǝlmau, ǝnga ji tǝtǝlna gǝnnar nda. ");
INSERT INTO mfm_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kǝ Yesu nar nyi anǝ njira vǝr ɗǝlna mbǝthlaˈyar kau, “Faˈabiya mau sǝˈyar kǝ ǝnggau! Hya sara shabiya ki dǝɗa aga sugu mai.” ");
INSERT INTO mfm_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ənggǝra sǝ kǝ ɗarkǝr, kǝ zǝmbǝlma nyiˈyar ɗǝngari sǝra tsǝtsǝfau, wu lǝkakaɗǝ nǝ Hyal abǝr, “Huɗǝ hamǝ nǝ ki Hyal a vǝr mbǝ ɗa ǝnggǝr uˈu.” ");
INSERT INTO mfm_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kǝ njira nggurǝm nǝ Yahudiya yiwa Yesu, ndǝ na, “Ya, mi ngǝ sǝ dǝdǝgur kǝra gu sǝn mǝliya, kǝra wu cabiya ˈya abǝr aˈyi gǝ ǝnga dǝnama nǝ mǝliya sǝˈyar ka?” ");
INSERT INTO mfm_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Kǝ Yesu shaɗǝwa nda, ji na, “Hya dlana ki Hyal kau, ba ya sa hyaˈana wu pida makǝru.” ");
INSERT INTO mfm_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kǝ ndǝ shaɗǝwa nyi, ndǝ na, “Nji hǝri fa foɗǝ kumunyi apǝ kwa a vǝr hǝr ki Hyal kau, ya, abari nga gu sǝn hyaˈana nyi wu pida makǝr ka?” ");
INSERT INTO mfm_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ama ki Hyal kǝra Yesu wu ndǝr ar kǝri kau, dza ja ngau. ");
INSERT INTO mfm_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ayukuɗa Yesu hyaˈari sara vir tau, kǝ zǝmbǝlma nyiˈyar ɗǝngari sǝ kǝ Yesu nar nda kau. Kǝ ndǝ dzǝgwa mbǝrsa ǝnga sǝra tsǝtsǝfau wu lǝkakaɗǝ nǝ Hyal ǝnga sǝra Yesu nana. ");
INSERT INTO mfm_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ar pǝci kǝra Yesu wu lardur nǝ vǝlna wu Urshalima, nji gangǝu mbǝrsa ǝnga ja arya sǝ dǝdǝgur kǝra ndu lari ji mǝl. ");
INSERT INTO mfm_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ama Yesu aˈyi fiyafǝ ǝnga nda mai, ara ju sǝnbiya nji patǝu. ");
INSERT INTO mfm_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Naja aˈyi wu yiwu nja lǝr sakida ar kǝra nji anǝ nyi mai, arya ju sǝn sǝra wu ɗǝfuwa ndapi. ");
INSERT INTO mfm_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Saya ɗa vanyi ndǝr Farisi aˈyi kǝra nja ngga ǝnga Nikodimosu, naja pathlǝ wu pama njira nggurǝm nǝ Yahudiya. ");
INSERT INTO mfm_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ji shili ǝgya Yesu uvuˈyi, ji sa na, “Malǝmǝ, ˈyi wu sǝni abǝr nagǝ malǝmǝ ngau, sara ara Hyal, arya ndǝr sǝn mǝliya sǝˈyar kǝ ga vǝr mǝl kǝ aˈyi mai, kǝl ndǝra Hyal ǝnga ja.” ");
INSERT INTO mfm_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Kǝ Yesu shaɗǝwa nyi, ji na, “Yi wu nar ngau jirkura nyi, ndǝr sǝn gwu tǝlkur Hyal aˈyi mai kǝl ma nji ɓǝra yabiya nyi nǝ mǝthlǝkura nyi.” ");
INSERT INTO mfm_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Kǝ Nikodimosu yiwa nyi, ji na, “Lagu mani nga nja ɓǝra sǝn yabiya ndǝra a halǝr ka? Ja ɓǝra sǝn sha a vu huɗa mǝnyi aga nja ɓǝra yabiya nyi nǝ mǝthlǝkura nyi ya?” ");
INSERT INTO mfm_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu shaɗǝwa nyi, ji na, “Jiri nga yu na anǝ ngau, ndǝr sǝn gwu tǝlkur Hyal aˈyi mai, kǝl nji ɓǝra yabiya nyi nǝ ˈyimi ǝnga nǝ Mambǝl. ");
INSERT INTO mfm_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sǝra ndapi yabiya ndǝ ngau, ama sǝra Mambǝl yabiya tsu mambǝl ngau. ");
INSERT INTO mfm_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ja sara ɗa sǝ dǝdǝgur anǝ ngǝ mai, ara yi na, abǝr, ‘Kǝl nji ɓǝra yabiya ngǝ nǝ mǝthlǝkura nyi.’ ");
INSERT INTO mfm_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yambaɗǝ wu sǝ a ndar vira ju yiwu. Gu nggari ǝnggǝra ju sau, ama nagǝ wu sǝn nana vira ji hyaˈari sara ari ǝnga vira ju maˈyi a ndar tsu mai. Abangǝ nga nyi tsu ǝnga ndǝra nji yabiya nyi wu Mambǝl.” ");
INSERT INTO mfm_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kǝ Nikodimosu yiwa Yesu, ji na, “Abari ngǝ sǝkǝ wu sǝn ɗa?” ");
INSERT INTO mfm_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Kǝ Yesu shaɗǝwa nyi, ji na, “Ya, nagǝ malǝmǝ dǝgal ngau wu Izirayila, ama nagǝ wu nggabiya sǝˈyar kǝ mai ya? ");
INSERT INTO mfm_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Jiri nga yu na anǝ ngau, ˈyi wu ndǝr ar kǝra sǝra ˈyi wu sǝni, ǝnga ˈyi wu lǝr sakida ar kǝra sǝra ˈyi lari, ama alaga abangau nahyi aˈyi dlǝwuri sakidar ˈya kǝ mai. ");
INSERT INTO mfm_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ma yu ndǝr anǝ hyi ar kǝra sǝra wu duniya, nahyi mbǝrsa ǝni mai, abari nga hyu sǝn nda mbǝrsa ma yi ndǝr anǝ hyi ar kǝra sǝra a dǝmǝlma? ");
INSERT INTO mfm_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ndǝ aˈyi kǝra saya maˈyi a dǝmǝlmǝ mai, kǝl naja Zǝr Ndǝ kǝra shida sara dǝna. ");
INSERT INTO mfm_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ənggǝr kǝra Musa har pabau a dar wu tagǝ mashi ta, abangǝ tsu kǝl nji hyaˈana Zǝr Ndau a dar wu, ");
INSERT INTO mfm_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","aga kalar ndǝra mbǝrsa ǝnga ja wu uya pi gǝra kuɗau.” ");
INSERT INTO mfm_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Arya Hyal ca yiwukur anǝ njir duniya gagaɗau, ca ngǝ ɗa ji lǝri Zǝr nyi zǝmǝ pir, aga kalar ndǝra hǝnggǝri ǝnga ja, naji wu tǝ mai, ama ju uya pi gǝra kuɗau. ");
INSERT INTO mfm_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Arya Hyal aˈyi sǝwa Zǝr nyi a shida wu duniya aga ja sa mǝlna nyi numa anǝ duniya mai, ama aga njir duniya a uya mbǝɗau lagu nyi. ");
INSERT INTO mfm_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kalar ndǝra mbǝrsa ǝnga Zǝr Hyal, numa aˈyi wu sǝm nyi mai. Ama kalar ndǝra aˈyi mbǝrsa ǝnga ja mai, numa a sǝmku nyi ri tsu kaɗǝ ara naji mbǝrsa ǝnga thlǝmǝr Zǝr Hyal kǝra zǝmǝ pir mai. ");
INSERT INTO mfm_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kǝja sǝra ju nda mǝl numa ar kǝri, mbǝmbǝl shili wu duniya, ama njir duniya wu yiwu kuthlǝu a ndiya mbǝmbǝl ara sǝr mǝla nda ɗǝmwaˈyu. ");
INSERT INTO mfm_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kalar njira wu mǝl sǝ ɗǝmwaˈyu, shishir dza nda wu yiwu mbǝmbǝl mai, ara hivǝr sǝr mǝla nda a biyar babal. ");
INSERT INTO mfm_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ama njir mǝl sǝra tsaˈa ndu shili ar vi mbǝmbǝl, aga nja lari ar babal abǝr sǝra ndu mǝl sǝra Hyal wu yiwu ngau.” ");
INSERT INTO mfm_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ayukuɗa kau, kǝ Yesu ǝnga zǝmbǝlma nyiˈyar maˈyi a ndar ˈyiˈyir Yahudiya. A ndǝna ji nda ɓǝliya sar kushu, ju mǝl baɓǝtizǝma anǝ nji. ");
INSERT INTO mfm_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yahwana nǝ nyi tsu ja vǝr mǝl baɓǝtizǝma anǝ nju mǝlmǝ Ayinanu kǝra lǝhǝu wu dzǝr mǝlmǝ Salimu, ara ˈyimi aˈyi gangǝu a ndǝna. Nji kǝl shili nga ndu shili ju mǝl baɓǝtizǝma anǝ nda. ");
INSERT INTO mfm_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Sǝkǝ ɗarkǝr kadivira nji fuwa Yahwana wu fursǝna.) ");
INSERT INTO mfm_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kǝ zǝmbǝlmaˈyar nǝ Yahwana gu kǝpal ǝnga vanyi ndǝr Yahudiya ar kǝra ci dzǝ kǝra dlaɗǝ nana nja mǝl. ");
INSERT INTO mfm_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ndǝ shili ǝgya Yahwana, ndǝ sa na anǝ nyi, “Malǝmǝ, ndǝ ta ǝnga gǝ a biyar ya dǝl Urdǝnu ta, ndǝ ta gǝ lǝri sakida ar kǝr ta, kǝja ja vǝr mǝl baɓǝtizǝma anǝ nji ǝnga patǝr nja vǝr sha shili ara ja.” ");
INSERT INTO mfm_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kǝ Yahwana shaɗǝwa nda, ji na, “Ndǝr sǝn dlǝwuri sǝ aˈyi mai, kǝl sǝra Hyal nǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nahyi ǝnga kǝrhyi ngǝ sakida ɗa arya yi na anǝ hyi, ‘Nayi ngǝ Kǝrsiti mai, ama Hyal sǝwa ɗa wu mwa nyi.’ ");
INSERT INTO mfm_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ar pǝcir hǝ dzau, kwanjili nǝ sal kwanjili ngau. Bazhiya sal kwanjili kǝra shili ar vir hǝ dzǝ kau, kǝl sǝkǝ nga ja, aga ja nggari ɗaha sal kwanjili. Ju nyi ǝnga huɗǝ pipida ma ji nggari sal kwanjili a vǝr ndǝr. Lagu kǝ tsu ngǝ huɗǝ pipida ɗa a nyabiyar dzau. ");
INSERT INTO mfm_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","A ɗari tsaˈa ja cakau, nayi tsu ya gǝnna dzau. ");
INSERT INTO mfm_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ndǝra shida sara a dǝmǝlmau, naja nga adabanga nji patǝu. Patǝr njira wu duniya nǝ duniya ngau, ǝnga ndu ndǝr ar kǝra sǝr duniya. Ndǝra shida sara a dǝmǝlmau, naja nga adabanga nji patǝu. ");
INSERT INTO mfm_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ju lǝri sakida sǝra ji lari ǝnga ji nggari, alaga abangau, ndǝ aˈyi kǝra mbǝrsa ǝnga sakida nyi mai. ");
INSERT INTO mfm_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ama kalar ndǝra dlǝwuri sakida nyi a cabiyari abǝr Hyal ndǝ jijiri ngau. ");
INSERT INTO mfm_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ara ndǝra Hyal sǝwa, ndǝr Hyal nga ju na, arya Hyal nǝ nyi Mambǝl nyi nyinyau. ");
INSERT INTO mfm_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tada wu yiwu Zǝr nyi, ba ji fuwa patǝr sǝ wu tsa ja. ");
INSERT INTO mfm_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kalar ndǝra mbǝrsa ǝnga Zǝra nyi aˈyi ja ǝnga pi gǝra kuɗau. Ndǝra gǝra ɓǝla sǝra Zǝra nyi nana, naji wu uya pi mai, ama Hyal wu ɗǝfu ǝnga ja.” ");
INSERT INTO mfm_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Njir Farisi nggari abǝr Yesu a vǝr dumwa ǝnga uya nji, ǝnga mǝl baɓǝtizǝma anǝ zǝmbǝlma gangǝu a ndiya Yahwana. ");
INSERT INTO mfm_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Kwalaga kǝ aˈyi Yesu ǝnga kǝrnyi nga vǝr mǝl baɓǝtizǝma kǝ mai, ama zǝmbǝlma nyiˈyar ngau. ");
INSERT INTO mfm_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ənggǝra Yesu nggari abangau, kǝ ji piyari ˈyiˈyir Yahudi ba ji ɓǝra sha a vu ˈyiˈyir Galili. ");
INSERT INTO mfm_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kabangǝkǝ a mbari kǝl Yesu ja tǝrabiya wu Samariya. ");
INSERT INTO mfm_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kǝ ji dla wu vanyi mǝlmǝ wu ˈyiˈyir Samariya kǝra nja ngga ǝnga Sayika. Vi kau, lǝhǝ nga nyi a dzǝr vira Yakubu nǝ nyi anǝ zǝr nyi Yusufu. ");
INSERT INTO mfm_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ar vi kau, mǝla nǝ Yakubu aˈyi. Ar pǝci kǝra Yesu hǝɗa ǝnga ɓau, ba ji ɓǝliya sar a miya mǝla nyi. Sǝkǝ ɗarkǝr ǝnggǝr saka kumo apǝ mǝthlǝ nǝ puci. ");
INSERT INTO mfm_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kǝ vanyi mala nǝ Samariya shila gwa mǝla. Kǝ Yesu na anǝ nyi, “Usi, gǝr ɗa ˈyimi ya tǝwari.” ");
INSERT INTO mfm_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Zǝmbǝlma nyiˈyar tsu a maˈyir nda a vu huɗa mǝlmǝ aga nda vuwa ɗǝl sǝr sǝm.) ");
INSERT INTO mfm_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kǝ mala Samariya kǝ na anǝ Yesu, “Abari nagǝ ndǝr Yahudiya a sǝn yiwa ˈyimi ara ya, nayi mala Samariya?” (Ara sǝ aˈyi kǝra wu daɓǝri ndǝr Yahudiya ǝnga ndǝr Samariya mai.) ");
INSERT INTO mfm_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Əngwar Yesu, “Maja abǝr gu sǝni sǝ kurthlǝ nǝ Hyal kǝra ju lau, ǝnga ndǝra na anǝ ngau, ‘Gǝr ɗa ˈyimi ya tǝwari,’ gu sǝn yiwa nyi, ba ja nǝ ngǝ ˈyimi nǝr lǝ pi.” ");
INSERT INTO mfm_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kǝ mala kǝ na, “Malǝmǝ, kǝja sǝr gǝ ˈyimi aˈyi ara gǝ mai, ya, kǝja mǝla kǝ dzǝgamǝ nga nyi, lagu mani nga gu sǝn gǝr ɗa ˈyimi lǝ pi ka? ");
INSERT INTO mfm_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ɗǝm ya, naga ndiya dǝrˈya Yakubu, ndǝra labiya ˈya mǝla kǝ ya? Naja ǝnga kǝrnyi ma, ji sa ˈyimi sara a gwa, ǝnga wazha nyi ba maˈwi nyiˈyar.” ");
INSERT INTO mfm_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu na, “Kalar ndǝra sa ˈyimi kau, hili wu ɓǝra nda tǝ nyi wayu. ");
INSERT INTO mfm_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ama ndǝra sa ˈyimi kǝra yu lǝ kau, naji wu ɓǝra nggar hili mai baˈanuwa. ˈYimi kǝra yu lǝ kau, wu nda ɗa wu ja ǝnggǝr mandǝli ˈyimi kǝra wu huhwi sara wu dza ja kǝra wu nǝ nyi pi gǝra kuɗau.” ");
INSERT INTO mfm_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Əngwar mala kau, “Malǝmǝ, nǝ ɗa ˈyimi kau, ara ya sara ɓǝra nggari hili, ǝnga ya ɓǝra shili ǝnggau ya sa gǝ ˈyimi.” ");
INSERT INTO mfm_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Kǝ Yesu na, “Maˈyi ga nda shili ǝnga sal ngau.” ");
INSERT INTO mfm_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Əngwar ja, “Sal aˈyi ara yi mai.” Əngwar Yesu anǝ nyi, “A nabiyar gǝ jiri ǝnggǝra gǝ na abǝr, ‘Sal aˈyi ara yi mai.’ ");
INSERT INTO mfm_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Arya jirkura nyi ca ngǝ a hǝr gǝ shili pamǝpamǝ tǝfu, ǝnga ndǝ kǝ gǝ ǝni kabangǝkǝ kǝ sal ngǝ mai, a nabiyar gǝ jiri.” ");
INSERT INTO mfm_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Əngwar ja, “Ndǝ dǝgalǝu, maya nggani nagǝ nabi ngau. ");
INSERT INTO mfm_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Əjir ˈya dlǝvǝ Hyal ar mǝ kau. Ama ǝngwar hyi njir Yahudiya wu Urshalima ngǝ vira nja kyaga dlǝvǝ Hyal.” ");
INSERT INTO mfm_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Kǝ Yesu na, “Mala, mbǝrsa ǝnga sǝra yu na kau, arya pǝci a vǝr shili kǝra nji tsu wu nda dlǝvǝ Tada ar mǝ kǝ mai, alaga wu Urshalima mai. ");
INSERT INTO mfm_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nahyi njir Samariya nahyi wu sǝni ndǝra hyu dlǝvǝ mai, naˈya ˈyi wu sǝni ndǝra ˈyi wu dlǝvau, ara mbǝɗau shili sara ara njir Yahudiya. ");
INSERT INTO mfm_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ama pǝci a vǝr shili, pǝca nyi ma a shiliri, kǝra njir dlǝvǝ Tada ǝnga jiri wu nda dlǝvǝ nyi wu mambǝl ba ǝnga jirkur, ara Tada wu gal culi nji kǝ nga dlǝvǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Hyal Mambǝl ngau, njir dlǝvǝ nyi kǝl nda dlǝvǝ nyi wu mambǝl ba ǝnga wu jirkur tsu.” ");
INSERT INTO mfm_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mala kǝ na, “A sǝn yi abǝr Ndǝ Cacaɗau a vǝr shili ndǝra nju ngga nyi ǝnga Kǝrsiti. Ma ji shili ju sa cabiya ˈya patǝr sau.” ");
INSERT INTO mfm_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu na, “Nayi ndǝra vǝr ndǝr anǝ ngau nayi ngau.” ");
INSERT INTO mfm_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ar pǝci kǝ ngǝ zǝmbǝlma nyiˈyar sha shili, ba ɗa sǝ dǝdǝgur anǝ nda ǝnggǝra ndǝ thlǝwa nyi ja vǝr ndǝr ǝnga mala. Ama ndǝr sǝn yiwa, “Mi nga ga gal ǝnga mala ka?” Ənga ndǝr sǝn na anǝ nyi, “Mi ngǝ ɗa gu ndǝr ǝnga ja?” aˈyi tsu mai. ");
INSERT INTO mfm_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kǝ mala kǝ piyari tǝm gwa mǝla nyi, ba ji maˈyi a vu huɗa mǝlmau, ji vuwa nar nyi anǝ nji, ");
INSERT INTO mfm_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Shila mau, hya sa lari ndǝra nar ɗa sǝra yi saya mǝlna patǝu. Abǝr naja ngǝ Kǝrsiti ya?” ");
INSERT INTO mfm_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kǝ nji bibiya sara wu huɗa mǝlmau, kǝ ndǝ shili ǝgya Yesu. ");
INSERT INTO mfm_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ar pǝci kǝ ngǝ zǝmbǝlma nyiˈyar a vǝr kǝdi Yesu, “Malǝmǝ, sǝm sau.” ");
INSERT INTO mfm_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ama kǝ Yesu shaɗǝwa nda, ji na, “Sǝr sǝm aˈyi ara yi kǝra yu sǝn sǝm ama nahyi wu sǝn mai.” ");
INSERT INTO mfm_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kǝ zǝmbǝlma nyiˈyar yiwa kǝrnda, ndǝ na, “Abǝr vanyi ndǝ daɓaga shili ǝnga sǝr sǝm anǝ nyi ya?” ");
INSERT INTO mfm_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ama kǝ Yesu shaɗǝwa nda, ji na, “Sǝr sǝm ɗa ca ngǝ ya mǝl sǝra ndǝra sǝwa ɗa wu yiwu ǝnga ya nyabiya thlǝr nyi cipǝu. ");
INSERT INTO mfm_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Hyu na abǝr, ‘A hyiri hya foɗǝ aga fwaha ɗa.’ Ama yu na anǝ hyi, hya pahǝna liya hyi mǝnahǝu aga hya tsamǝ vu huɗa fa, ara a nǝr nda patǝ tsaˈa aga gǝm kabangǝkau. ");
INSERT INTO mfm_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ndǝr gǝm fa wu uya akkǝri nyi, ǝnga ju kaɓiya sǝ zǝzǝwa nyi, ca ngǝ cabiya njira ju kaɓiya aga nda uya pi gǝra kuɗau. Lagu kǝ ngǝ njir thlǝka ǝnga njir gǝm sǝr fa ndu nyabiya dzǝ ǝnga huɗǝ pipida aga zǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ənggǝ ngǝ karapǝ kǝ nyabiya dzǝ ǝnga jirkur, ‘Vanyi ndǝ thlǝr nyi ca ngǝ thlǝka, vanyi ndǝ tsu thlǝr nyi ca ngǝ gǝm.’ ");
INSERT INTO mfm_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yi sǝwa hyi aga hya gǝm sǝra hyi gǝra lari ɓwaɓwatǝ a vǝr thlǝka. Alenyi nji a lar nda ɓwaɓwatǝu, nahyi tsu a uyar hyi akkǝri nǝ thlǝr ɓwaɓwatǝr nda.” ");
INSERT INTO mfm_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Njir Samariya gangǝu sara wu mǝlmǝ kǝ mbǝrsa ǝnga Yesu arya ndǝr mala kǝ kǝra ji na, “Ji nar ɗa patǝr sǝra yi saya mǝliya.” ");
INSERT INTO mfm_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ənggǝra njir Samariya shili ǝgya Yesu, kǝ ndǝ sa kǝdi nyi ja nggya ǝkkǝˈyi nda, ba ji nggya ǝkkǝˈyi nda nǝ pida mǝthlǝu. ");
INSERT INTO mfm_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nji gangǝ tsu ɓǝra mbǝrsa ǝnga Yesu arya sǝra ji nar nda. ");
INSERT INTO mfm_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kǝ njir Samariya dzǝgwa na anǝ mala kau, “Kabangǝkau, a hǝnggǝr ˈya jiri, aˈyi ara sǝra gǝ na waci mai, ama ara naˈya ma a nggar ˈya sǝra ji na ǝnga kǝrˈya, ǝnga a dlǝwunggǝri ˈya ndǝ kǝ naja ngǝ ndǝr mbǝɗa duniya.” ");
INSERT INTO mfm_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ayukuɗa pida mǝthlǝu, kǝ Yesu piyari ˈyiˈyir Samariya ji maˈyi a vu ˈyiˈyir Galili. ");
INSERT INTO mfm_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Arya Yesu ǝnga kǝrnyi a nanari abǝr, “Nabi aˈyi wu uya hakǝr wu mǝlmǝ nyi mai.”) ");
INSERT INTO mfm_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ar pǝci kǝra ji vu Galili, kǝ njir Galili dlǝwuri nyi ǝnga huɗǝ zǝmǝ ara nanda ǝnga kǝrnda a lari nda sǝra Yesu mǝlna a vu Urshalima ar pǝcir lardur nǝ vǝlna kǝra nanda ma a vur nda. ");
INSERT INTO mfm_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kǝ Yesu ɓǝra sha a vu Kana wu Galili, vira ji shabiya ˈyimi a ndu ˈyimir wur inabi. A ndǝna vanyi ndǝ dǝgal nǝ ki tǝl aˈyi kǝra zǝr nyi gǝra ngga a vu Kafarnahumu. ");
INSERT INTO mfm_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ənggǝra ndǝ kǝ nggari abǝr Yesu a dlari wu Galili sara wu Yahudi, kǝ ji maˈyi a ndǝgya ja, ji nda kǝdi nyi aga ja shili wu ki nyi, ja sa mbǝɗana zǝr nyi kǝra citǝu a miya tau. ");
INSERT INTO mfm_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Kǝ Yesu shaɗǝwa nyi, ji na, “Kǝl ta hyi lari mǝtsamǝ ǝnga sǝ dǝdǝgur ara yau, ca ngǝ ɗa hyi mbǝrsa.” ");
INSERT INTO mfm_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kǝ ndǝ dǝgal nǝ ki tǝl ta na anǝ Yesu, “Ndǝ dǝgalǝu, shili ma maˈyi a ndu ki ɗa ara zǝr ɗa ka sara tau.” ");
INSERT INTO mfm_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kǝ Yesu na anǝ nyi, “Maˈyi sǝ ngau, zǝr ngǝ kǝ wu tǝ mai.” Ndǝ kǝ tsu, ba ji mbǝrsa ǝnga sǝra Yesu na anǝ nyi, ba ji maˈyi sǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tsu ja ar lagu ja vǝr maˈyi a ndu ki, ba ji ɓǝ ǝnga njir mǝl thlǝr nyi ar lagu, kǝ ndǝ na anǝ nyi, “Zǝr ngǝ ta a ɗari jamǝu.” ");
INSERT INTO mfm_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kǝ ji yiwa nda pǝci kǝra sǝ kǝ ɗarkǝr. Əngwar nda anǝ nyi, “Na, ǝnggǝr saka pathlǝ nǝ puci ngǝ gyangǝ kǝ siya nyi.” ");
INSERT INTO mfm_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kǝ dǝya zǝr kǝ tsamǝ ri abǝr ar pǝci kǝ ngǝ Yesu na anǝ nyi, “Maˈyi sǝ ngau, zǝr ngǝ kǝ wu tǝ mai.” Kǝ ndǝ kǝ ǝnga njir ki nyi mbǝrsa ǝnga Yesu. ");
INSERT INTO mfm_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Najakǝ ngǝ sǝ dǝdǝgur nǝ mǝthlǝkura nyi kǝra Yesu mǝliya ayukuɗa ji piyari Yahudi ji shili wu Galili. ");
INSERT INTO mfm_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ayukuɗa kau, kǝ Yesu maˈyi a du Urshalima aga mini nǝ njir Yahudiya. ");
INSERT INTO mfm_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","A du Urshalima tsu, vanyi dǝl faˈa aˈyi kǝra nji zǝwuya ǝnga sǝ ǝnggǝr dzaˈwu pamǝpamǝ tǝfu. Nju ngga faˈa kǝ ǝnga miya njir Yahudiya, Bethlesaida. Dǝl faˈa kǝ lǝhǝ nga nyi a dzǝr miya ki kǝra nju ngga ǝnga Miya Ki Tǝmahǝu. ");
INSERT INTO mfm_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Əgya kiɗa dzaˈwuˈyar kǝ ngǝ nji gǝra ngga, ǝnga nji lǝfau, ǝnga nji kadal ba ǝnga nji tǝsǝkǝnu gangǝu wu pida. ");
INSERT INTO mfm_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ndǝ wu sǝ kau aga nja gwazhiri ˈyimiya nyi. Arya ga pǝci ga pǝci ngǝ waladi nǝ Thlagǝ wu shida ja sa gwazhiri ˈyimi kau. Ndǝra a gwa tanggǝrma, ba ja uya jamǝkur sara ara shilǝgǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ənggǝ tsu vanyi ndǝ aˈyi kǝra mǝliya fa makǝrkumunyi apǝ cisu ǝnga tǝsǝkǝnu. ");
INSERT INTO mfm_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ta Yesu lari nyi aˈyi pida, ǝnga tsu ju sǝni abǝr ndǝ kǝ a ɓǝliyar sar ǝnga tǝsǝkǝnu kau, kǝ Yesu na anǝ nyi, “Gu yiwu ga ɗa jamǝ ya?” ");
INSERT INTO mfm_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Kǝ ndǝ tǝsǝkǝnu kǝ na, “Ndǝ dǝgalǝu, nayi aˈyi ǝnga ndǝr dlǝwa ɗa ma nji gwazhiri ˈyimiya nyi mai. Ma yi mǝl abǝr aga ya sǝn gwa ba vanyi nda gwa a mwa ara yau.” ");
INSERT INTO mfm_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kǝ Yesu na anǝ nyi, “Hyaˈari ga hǝri buci ngau, ba ga ɓǝ ga maˈyi.” ");
INSERT INTO mfm_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aga zǝmǝ ba nda nyi ɗa jamǝu, kǝ ji hǝri buci nyi ba ji ɓau. Sǝ kǝ ɗarkǝr ar pǝcir ɓǝlsar nǝ njir Yahudiya. ");
INSERT INTO mfm_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Agabangau, kǝ njira nggurǝm nǝ Yahudiya nar nyi anǝ ndǝ kǝra nji mǝliya jamǝ kau, “Əshina pǝcir ɓǝlsar ngau, naga kyaga mǝl thlǝr mai, dlaɗǝr mǝna kar ngǝ ri ara hǝ buci ngau.” ");
INSERT INTO mfm_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kǝ ndǝ kǝ shaɗǝwa nda, ji na, “Ndǝra mǝliya ɗa jamǝ ngǝ na anǝ ɗa, ‘Hǝri buci ngau ga ɓau.’ ” ");
INSERT INTO mfm_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kǝ ndǝ yiwa nyi, ndǝ na, “Wa ngǝ ndǝ kǝ na anǝ ngau, ga hǝr buci ngau, ga ɓǝ ka?” ");
INSERT INTO mfm_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ndǝ kǝ nji shilǝgǝbiya kǝ wu sǝni tara wa ngǝ mǝliya nyi jamǝ kǝ mai, arya Yesu a maˈyiri a vu pama dlamir nji kǝra a ndǝna. ");
INSERT INTO mfm_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ayukuɗa pǝci kushu, ba Yesu thlǝwa nyi wu ki Hyal, ba ji na anǝ nyi, “Lari, a ɗar gǝ jamǝu. Ga piyari mǝl bikau ara sǝ ɗǝmwaˈyi a ndiya kǝ a sara ɗa ǝnga gau.” ");
INSERT INTO mfm_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kǝ ndǝ kǝ maˈyi ji nda nar nyi anǝ njira nggurǝm nǝ Yahudiya abǝr Yesu ngǝ mǝliya nyi jamǝu. ");
INSERT INTO mfm_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ara abangau, ba ndǝ dzǝguya ndǝr papatagǝ anǝ Yesu, ara ju mǝl sǝˈyar kǝ Pǝcir Ɓǝlsar. ");
INSERT INTO mfm_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kǝ Yesu na anǝ nda, “Dǝɗa a vǝr mǝl thlǝr nyi baˈanǝ kabangǝkau, nayi tsu ya vǝr mǝl thlǝr.” ");
INSERT INTO mfm_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Arya ndǝr kau, ngǝ njir Yahudiya wu gal lagu kǝra nda tsǝya nyi ari. Əngwar nda, “Aˈyi wacu ara ji ɓǝlna sǝra dlaɗǝ na ar kǝra Pǝcir Ɓǝlsar mai, ama ara ju ngga Hyal ar viya dǝnyi, lagu ta nga ju gǝla kǝrnyi kakalǝ ǝnga Hyal.” ");
INSERT INTO mfm_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kǝ Yesu shaɗǝwa nda, ji na, “Ənga jiri nga yu na anǝ hyi, sǝ aˈyi kǝra Zǝr wu sǝn mǝliya ǝnga kǝrnyi mai, sǝra ji lari Dǝnyi a vǝr mǝl, ca nga ju mǝl. Ara kalar sǝra Dǝnyi a vǝr mǝl, ca ngǝ Zǝr wu mǝl tsu. ");
INSERT INTO mfm_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ara Tada wu yiwu Zǝra nyi, ca nga ju canǝ nyi kalar sǝra ju mǝl ǝnga kǝrnyi. Ba tsu ju canǝ nyi sǝra ndiya sǝ ǝnggǝr kǝ aga ja ɗa sǝ dǝdǝgur anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ənggǝr kǝra Tada sǝn hyaˈana nji tǝtǝ ja nǝ nda pi, abangǝ tsu Zǝr wu sǝn nǝ nyi pi anǝ kalar ndǝra ju yiwu. ");
INSERT INTO mfm_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tada wu mǝl numa anǝ nji mai, ara a nǝ nyir ja dǝnama nǝ mǝl numa anǝ Zǝr nyi, ");
INSERT INTO mfm_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","aga patǝr nji nda nǝ nyi dǝgalkur anǝ Zǝra nyi, ǝnggǝra ndu lǝ dǝgalkur anǝ Tada. Kalar ndǝra gǝra nǝ nyi dǝgalkur anǝ Zǝra nyi, naja aˈyi nǝ nyi dǝgalkur anǝ Dǝnyi kǝra sǝwa nyi mai. ");
INSERT INTO mfm_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ənga jiri nga yu na anǝ hyi, kalar ndǝra wu nggar ndǝr ɗa, kǝ ji mbǝrsa ǝnga ndǝra sǝwa ɗa, aˈyi ja ǝnga pi gǝra kuɗau. Nju nda mǝl numa anǝ nyi mai, ama a tǝrabiyar ja sara wu tau, a ndu pi. ");
INSERT INTO mfm_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ənga jiri nga yu na anǝ hyi, pǝci a vǝr shili, pǝca nyi ma a shiliri, kǝra nji tǝtǝ wu nda nggar ɗaha Zǝr Hyal, njira nggari ndu nda ɗa aˈyi ǝnga pi. ");
INSERT INTO mfm_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ənggǝr kǝra Tada ɗa thlagǝr pi, abangǝ tsu nga ji nǝ nyi dǝnama anǝ Zǝra nyi aga ja ɗa thlagǝr pi. ");
INSERT INTO mfm_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ənga tsu ji nǝ nyi dǝnama nǝ mǝl numa anǝ kalar ndau ara naja Zǝr Ndau. ");
INSERT INTO mfm_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ndǝr kǝ a sara ɗa sǝ dǝdǝgur anǝ hyi mai, ara pǝca vǝr shili kǝra patǝr njira a gu hu wu nda nggar ɗaha ja, ");
INSERT INTO mfm_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ba nda biya. Njira mǝliya sǝ mǝnahǝu ndu hyaˈari ǝnga pi gǝra kuɗau, ama njira mǝliya sǝ ɗǝmwaˈyi ndu hyaˈari ba nja mǝliya nda numa. ");
INSERT INTO mfm_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Sǝ aˈyi kǝra yu sǝn mǝliya ar kǝrɗa mai. Yu thla numa ǝnggǝr kǝra Hyal wu na anǝ ɗa. Agabangau, numa ɗa kakalǝ nga nyi, arya aˈyi sǝra yu yiwu nga yu mǝl mai, ama sǝra ndǝra sǝwa ɗa wu yiwu. ");
INSERT INTO mfm_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ma yi lǝri sakida ar kǝra kǝrɗa, sakida kǝ aˈyi dlǝdlǝwu mai. ");
INSERT INTO mfm_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ama vanyi ndǝ pamǝu aˈyi kǝra wu lǝ sakida ar kǝra yau, a sǝn yi abǝr sakida nyi jijiri nga nyi. ");
INSERT INTO mfm_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Hyi sǝwa nyi nji anǝ Yahwana, naja, ba ji lǝr hyi sakida kǝra jiri. ");
INSERT INTO mfm_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Alaga abangau, aˈyi yu nggya aga sakida nǝ ndapi mai. Ama yi nar hyi abangau aga hya uya mbǝɗau. ");
INSERT INTO mfm_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yahwana ǝnggǝr pitǝlla mbǝmbǝl nga ja kǝra lǝri mbǝmbǝl nyi, nahyi tsu, kǝ hyi caguli nǝ mbǝmbǝl nyi nǝ pǝci kushu. ");
INSERT INTO mfm_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ama aˈyi yau ǝnga sakida kǝra ndiya kǝra Yahwana lǝri ar kǝra yau. Sǝ kǝra ya vǝr mǝl kau, sǝ ngau kǝra dǝɗa nǝ ɗa aga ya mǝl ǝnga ja vǝr lǝ sakida ar kǝra yau, abǝr dǝɗa ngǝ sǝwa ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Dǝɗa tsu, ndǝra sǝwa ɗa, nga vǝr lǝ sakida ar kǝra yau. Nahyi saya nggar ɗaha ja mai, ǝnga tsu nahyi saya lari nyi ǝnga li tara wa nga ja mai. ");
INSERT INTO mfm_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ndǝr nyi tsu wu nggya wu ɗǝfuwa hyi mai, arya nahyi mbǝrsa ǝnga ndǝra ji sǝwa mai. ");
INSERT INTO mfm_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nahyi kǝl dumwa ǝnga jiga sǝra tsǝtsǝfau wu lǝkakaɗǝ Hyal, ara hyu nggani a gwa nga hyu uya pi gǝra kuɗau. Najaka sǝ kǝra nji tsǝfǝri wu lǝkakaɗǝ Hyal kau, nanda ngu lǝr sakida ar kǝra yau. ");
INSERT INTO mfm_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ama alaga abangau, kǝ hyi nggǝl ara shili ǝgya yi aga hya sa uya pi. ");
INSERT INTO mfm_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nayi wu gal fal sara ara nji mai, ");
INSERT INTO mfm_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ama yu sǝni hyi. Aˈyi hyi ǝnga yiwu Hyal a vu ɗǝfuwa hyi mai. ");
INSERT INTO mfm_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nayau, yi shili wu thlǝmǝr dǝɗa, ama nahyi dlǝwur ɗa mai, ama ma vanyi ndǝ shili wu thlǝmǝr kǝrnyi ba hya sa dlǝwuri nyi. ");
INSERT INTO mfm_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Abari nga hyu sǝn mbǝrsa ma hyu dlǝwu fal ara kuvwar hya, ama nahyi wu gal lagur dlǝwu fal sara ara Hyal zǝmǝ pir maya? ");
INSERT INTO mfm_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","A sara hya ɗǝnga abǝr yu nda wula hyi ara Tada mai. Ndǝr wula hyi aˈyi, naja ngǝ Musa, ndǝra hyu fǝ ɗǝfu ju nda dlǝwar hyi. ");
INSERT INTO mfm_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Maja abǝr hyi mbǝrsa ǝnga Musa, a hǝnggǝr hyi jiri ǝnga yau, arya Musa tsǝfǝri ar kǝra yau. ");
INSERT INTO mfm_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ama ma nahyi aˈyi mbǝrsa ǝnga sǝra ji tsǝfǝri mai, abari nga hyu sǝn mbǝrsa ǝnga sǝra yu na?” ");
INSERT INTO mfm_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ayukuɗa pǝci kushu, kǝ Yesu tǝrabiya naɗǝ a biyar ya dǝl Galili (najakǝ ngǝ dǝl Tiberiyasu). ");
INSERT INTO mfm_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ənggau, dlamir nji gangǝu wu nu nyi arya sǝ dǝdǝgur kǝra ndǝ lari ji mǝliya anǝ nji gǝra ngga, ǝnggǝra ji shilǝgǝbiya nda. ");
INSERT INTO mfm_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kǝ Yesu maˈyi a dar kǝra mau, a ndǝna ji da nggya ǝkkǝˈyi zǝmbǝlma nyiˈyar. ");
INSERT INTO mfm_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ar pǝci kǝ lardur nǝ vǝlna nǝ njir Yahudiya a ɗari lǝhǝu. ");
INSERT INTO mfm_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ənggǝra Yesu hyaˈanakǝr ba ji lari dlamir nji gangǝu a vǝr shili ǝgya ja, kǝ ji nar nyi anǝ Fǝlipǝu, “Əmani nga mǝna sǝn ɗǝlbiya sǝr sǝm kǝra wu sǝn sǝmǝna nji ka?” ");
INSERT INTO mfm_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu yiwa sǝ kǝ ara Fǝlipǝu, aga ja dzǝbiya nyi, arya naja ǝnga kǝrnyi ju sǝn sǝra ju nda mǝl. ");
INSERT INTO mfm_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Kǝ Fǝlipǝu shaɗǝwa nyi, ji na, “Alaga gǝnna nǝ ki ndǝr mǝl thlǝr nǝ zada fa a sǝn ɗǝlbiya sǝra nji ka sǝn fuwa wu miya nda mai!” ");
INSERT INTO mfm_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Kǝ pathlǝ wu pama zǝmbǝlma Yesu kǝra nju ngga ǝnga Andǝrawusu, zamǝya Simanu Biturusu, na anǝ Yesu, ");
INSERT INTO mfm_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kǝja vanyi zǝr kushu ǝnggau ǝnga macikǝl lugu ɗǝfǝ tǝfu ǝnga kalfi mǝthlǝu. Ama mi ngǝ sǝra ju sǝn mǝliya anǝ nji gangǝ ka?” ");
INSERT INTO mfm_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kǝ Yesu na anǝ zǝmbǝlma nyiˈyar, “Nar nya mau anǝ nji nda nggya gya.” Ar vi kǝ sar aˈyi gangǝu. Kǝ nji patǝ nggya gya, gangǝkura shili zhizhir nda a kari dubu tǝfu. ");
INSERT INTO mfm_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kǝ Yesu hǝri macikǝla nyi, kǝ ji usaku Hyal, ba ji tǝtǝkǝya nyi anǝ njira aˈyi nggya gya patǝr sǝra ndu yiwu. Abangǝ tsu nga ji mǝliya ǝnga kalfiya nyi. ");
INSERT INTO mfm_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ayukuɗa ndǝ sǝm ndǝ nyau, kǝ ji nar nyi anǝ zǝmbǝlma nyiˈyar, “Tsǝmiya mau kalar sǝra hiyau ara sǝ a sara wir.” ");
INSERT INTO mfm_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kǝ zǝmbǝlma nyiˈyar tsǝtsǝmiya kalar sǝra hiyau wu miya nda, ba ndǝ nyanyana tsǝla kumo apǝ mǝthlǝu sara wu macikǝl lugu tǝfu ta. ");
INSERT INTO mfm_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ənggǝra dlamir nji lari sǝ dǝdǝgur kǝra Yesu mǝliya, kǝ ndǝ na, “Gǝra ǝnga kǝpal, ndǝ ngǝ nabi kǝra duniya wu sǝkǝ shili nyi ta.” ");
INSERT INTO mfm_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ta Yesu lari ndu sha lagu fǝ nyi aga tǝlǝr nda, ba ji gwaɗǝna nda, ba ji maˈyi sǝ nyi a du mau. ");
INSERT INTO mfm_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ənggǝra wagǝ ɗa, kǝ zǝmbǝlma Yesu ˈyar maˈyi a gwu dǝl. ");
INSERT INTO mfm_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kǝ ndǝ gwa gwu kwambwal aga nda tǝrabiya a vu Kafarnahumu. Ar pǝci kǝra nda a vir maˈyi, kǝ vi ɗa zǝgutu, ama tsu Yesu gǝra shili ǝgya nda. ");
INSERT INTO mfm_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kǝ dǝl dzǝguya kǝnggǝɗǝ gagaɗau ara culi yambaɗǝ kǝra a vǝr sau ǝnga dǝnama. ");
INSERT INTO mfm_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ayukuɗa ndǝ ɓar ɓau a ɗa nǝ miyal makǝru, kukuthlǝ ba ndǝ lari Yesu a vǝr shili ǝgya kwambwalǝr nda, ja vǝr ɓau ar kǝra ˈyimi, ba sǝkǝ gǝrahǝya nda gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ama kǝ Yesu na anǝ nda, “Nayi ngau, hya sara hivǝr mai.” ");
INSERT INTO mfm_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ənggau kǝ ndǝ hǝnggǝri aga nda dlǝwuri nyi a gwu kwambwalǝr nda. Ənggǝrna kǝ kwambwalǝr nda thlǝwa miya dǝl vira nda a vǝr nu a ndari. ");
INSERT INTO mfm_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ənggǝra vi sa kuɗau, kǝ dlamir nji kǝra hiyau a biyar ya dǝl tsamǝ ri abǝr kwambwal zǝmǝ kǝra hiyau ca ngǝ zǝmbǝlma Yesu ˈyar maˈyi a gwa, ama kǝ ndǝ tsamǝ ri abǝr Yesu aˈyi maˈyi ǝkkǝˈyi nda mai. ");
INSERT INTO mfm_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kǝ alenyi kwambwalˈyar shili sara wu Tiberiyasu, ndǝ sa taˈyi lǝhǝu ar vira Thlagǝ sǝmǝna nji ǝnga macikǝl kǝra ji fǝnggǝri nyi barka. ");
INSERT INTO mfm_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ta nji lari abǝr Yesu ǝnga zǝmbǝlma nyiˈyar aˈyi ar vi ta mai, ba ndǝ gu kwambwalˈyar, ndǝ maˈyi a vu Kafarnahumu aga vuwa gal Yesu a vuna. ");
INSERT INTO mfm_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ənggǝra ndǝ biya thlǝwa nyi a biyar ya dǝl, kǝ ndǝ na anǝ nyi, “Malǝmǝ, ǝnuwa nga gǝ shili ǝnga?” ");
INSERT INTO mfm_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kǝ Yesu shaɗǝwa nda, ji na, “Ənga jiri nga yu na anǝ hyi, hyu gal ɗa aˈyi ara sǝ dǝdǝgur kǝra hyi lari yi mǝliya mai, ama arya macikǝl ta hyi sǝm hyi nyi ǝni ta. ");
INSERT INTO mfm_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Hya sara hǝɗa a vǝr gal sǝr sǝm kǝra wu sǝn dzǝ mai, ama hya mǝl thlǝr nǝ gal sǝr sǝm kǝra gǝra sǝn dzau, ǝnga tsu ju lǝri pi kǝra gǝra kuɗau. Naja kǝ ngǝ sǝr sǝm kǝra Zǝr Ndau, wu sǝn nǝr hyi. Arya naja Zǝr Ndau ngǝ Hyal Tada nǝ nyi dǝnama nǝ mǝl abangau.” ");
INSERT INTO mfm_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kǝ ndǝ yiwa nyi, ndǝ na, “Mi ngǝ sǝra Hyal wu yiwu ˈya mǝla?” ");
INSERT INTO mfm_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Kǝ Yesu shaɗǝwa nda, ji na, “Kǝja sǝra Hyal wu yiwu hya mǝl, hya mbǝrsa ǝnga ndǝra ji sǝwa.” ");
INSERT INTO mfm_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kǝ ndǝ yiwa nyi, “Mi ngǝ sǝ dǝdǝgur mǝtsamǝ kǝra gu sǝn mǝliya aga ˈya daɓaga lari ba ˈya hǝnggǝri ǝnga ga? Mi nga gu sǝn mǝliya? ");
INSERT INTO mfm_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Əjir ˈya sǝm sǝra nju ngga ǝnga mana a gwa tagǝu, ǝnggǝr kǝra tsǝtsǝfau abǝr, ‘Ji nǝ nda sǝr sǝm sara dǝmǝlmǝ aga nda sǝm.’ ” ");
INSERT INTO mfm_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kǝ Yesu shaɗǝwa nda, ji na, “Ənga jiri nga yu na anǝ hyi, aˈyi Musa ngǝ nǝ hyi sǝr sǝm sara dǝmǝlmǝ mai, ama dǝɗa ngǝ nǝr hyi sǝr sǝm nǝ jijiri sara dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Arya sǝr sǝm nǝ jiri nǝ Hyal ca ngǝ ndǝra shida sara dǝmǝlmǝ ju lǝ pi anǝ duniya.” ");
INSERT INTO mfm_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Əngwar nda anǝ nyi, “Malǝmǝ, mbar kabangǝkǝ ga dumwa ǝnga lǝ culi najaka sǝr sǝm anǝ ˈya.” ");
INSERT INTO mfm_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kǝ Yesu nar nda, “Nayi ngǝ macikǝl nǝ pi. Kalar ndǝra shili ǝgya yau, naja tsu ɓǝra nggari wuɓu mai, ǝnga kalar ndǝra hǝnggǝri ǝnga yau, naji wu ɓǝra nggari hili mai. ");
INSERT INTO mfm_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ama ǝnggǝra yi nar hyi ta, a lar ɗar hyi, ama alaga abangau nahyi hǝnggǝri ǝnga yi mai. ");
INSERT INTO mfm_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Patǝr njira Tada nǝ ɗa, ndu shili ara yau, ǝnga kalar ndǝra shili ara yau, nayi wu kǝdlǝ nyi mai. ");
INSERT INTO mfm_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Arya yi shida sara dǝmǝlmau, aˈyi aga ya sa mǝl sǝra yu yiwu mai, ama sǝra ndǝra sǝwa ɗa wu yiwu. ");
INSERT INTO mfm_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Sǝra ndǝra sǝwa ɗa wu yiwu, ca ngǝ alaga ndǝ zǝmǝ a sara sa wu tsa yau, wu njira ji nǝ ɗa mai, ama aga ya hyaˈana nda sara vir tau, ar pǝcir kuɗiya duniya. ");
INSERT INTO mfm_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Arya sǝra Dǝɗa wu yiwu ngau, ca ngǝ kalar ndǝra fǝr li ar Zǝr, ǝnga ji hǝnggǝri ǝnga Zǝra nyi, ju uya pi gǝra kuɗau, ǝnga tsu yu nda hyaˈana nyi sara vir tau, ar pǝcir kuɗiya duniya.” ");
INSERT INTO mfm_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Kǝ njir Yahudiya dzǝguya ngwungwuni wu pamǝ ar kǝra Yesu ara ji na, “Nayi ngǝ macikǝl kǝra shida sara dǝmǝlmau.” ");
INSERT INTO mfm_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kǝ ndǝ na, “Aˈyi Yesu ngǝ wa? Zǝr Yusufu, ndǝra ˈyi wu sǝni dǝnyi ǝnga mǝnyi ta wa? Ya, abari nga ju na abǝr, ‘Yi shida sara dǝmǝlma’?” ");
INSERT INTO mfm_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kǝ Yesu shaɗǝwa nda, ji na, “Piyara mau ngwungwuni wu pama hyi. ");
INSERT INTO mfm_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ndǝr sǝn shili ǝgya yi aˈyi mai, kǝl ma Tada kǝra sǝwa ɗa tǝɗǝr nyi a shili, nayi tsu yu nda hyaˈana nyi sara vir tau, ar pǝcir kuɗiya duniya. ");
INSERT INTO mfm_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nji tsǝfǝri wu lǝkakaɗǝ nǝ nabiˈyar abǝr, ‘Patǝkura nda Hyal ngu nda highiɓǝ anǝ nda.’ Kalar ndǝra sǝya nyi himi anǝ Tada ǝnga ji highiɓǝr sǝ ara ja, ju shili ǝgya yau. ");
INSERT INTO mfm_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ndǝ aˈyi kǝra saya lari Tada mai, kǝl ndǝra hyaˈari sara ara Hyal, naja ngǝ ndǝra saya lar Tada. ");
INSERT INTO mfm_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Jiri nga yu na anǝ hyi, kalar ndǝra mbǝrsa aˈyi ja ǝnga pi gǝra kuɗau. ");
INSERT INTO mfm_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nayi ngǝ macikǝl nǝ pi. ");
INSERT INTO mfm_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Əjiya ǝjir hyi sǝm sǝra nju ngga ǝnga mana wu tagǝu, ama ba ndǝ ɓǝra tau. ");
INSERT INTO mfm_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ama kǝja macikǝl kǝra shida sara dǝmǝlmau, kalar ndǝra sǝmku naji wu tǝ mai. ");
INSERT INTO mfm_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nayi ngǝ macikǝl nǝ pi kǝra shida sara dǝmǝlmau. Kalar ndǝra sǝm najaka macikǝl, ju nggya ǝnga pi nǝ baˈanuwa. Najaka macikǝl kumǝr dza yi ngau, kǝra yu lǝri aga duniya a uya pi.” ");
INSERT INTO mfm_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Kǝ njir Yahudiya gu kǝpal gagaɗau wu pama nda, ndu na, “Abari ngǝ ndǝ ka sǝn nǝ mǝn kumǝr dza ja aga mǝna sǝma?” ");
INSERT INTO mfm_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Əngwar Yesu anǝ nda, “Ənga jiri nga yu na anǝ hyi, kǝl ma hyi sǝm kumǝr dza Zǝr Ndau ǝnga hyi tǝwari mashi nyi, nahyi aˈyi ǝnga pi wu hyi mai. ");
INSERT INTO mfm_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kalar ndǝra sǝmku kumǝr dza yau ǝnga ji tǝwari mashi ɗa, aˈyi ja ǝnga pi gǝra kuɗau, ǝnga yu nda hyaˈana nyi sara vir tau, ar pǝcir kuɗiya duniya. ");
INSERT INTO mfm_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kumǝr dza yi ɗǝfǝ jijiri ngau, ǝnga mashi ɗa sǝr sa jijiri ngau. ");
INSERT INTO mfm_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kalar ndǝra sǝmku kumǝr dza yau ǝnga ju sa mashi ɗa, ju nggya wu yau ǝnga nayi tsu wu ja. ");
INSERT INTO mfm_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ənggǝr kǝra Tada mbǝmbǝɗau sǝwa ɗa, arya ja nga yi tsu ǝnga pi, agabangǝ kalar ndǝra fiya ɗa aga sǝr sǝm nyi, ju nda ɗa aˈyi ǝnga pi baˈanuwa arya yau. ");
INSERT INTO mfm_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Najakǝ ngǝ macikǝl kǝra shida sara dǝmǝlmǝ aˈyi ǝnggǝr kǝra ǝjiya ǝjir hyiˈyar sǝm mai. Əjiya ǝjir hyi ndǝ sǝm sǝra nju ngga ǝnga mana ba ndǝ tau, ama kalar ndǝra wu sǝm najaka macikǝl, aˈyi ja ǝnga pi gǝra kuɗau.” ");
INSERT INTO mfm_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu nana sǝˈyar kǝ patǝ ar pǝci kǝra ja vǝr highiɓau wu umbwa daɓǝ dzǝ njir Yahudiya wu Kafarnahumu. ");
INSERT INTO mfm_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ənggǝra ndǝ nggari abangau, kǝ gangǝu wu pama zǝmbǝlma nyiˈyar na, “Dzadzau ngǝ highiɓǝ kau, wa ngu sǝn dlǝwuri najaka sa?” ");
INSERT INTO mfm_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu ara ju sǝni wu ɗǝfuwa ja abǝr zǝmbǝlma nyiˈyar a vǝr ngwungwuni ar kǝra highiɓǝ kau, kǝ ji na anǝ nda, “Highiɓǝ kǝ ndzana huɗa hyi ya? ");
INSERT INTO mfm_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ya, abari nga hyu nda nggari wu ɗǝfuwa hyi ma hyi lari Zǝr Ndau a vǝr sha a dar vira ja ɗǝɗǝma? ");
INSERT INTO mfm_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mambǝl ngu lǝ pi, sǝ aˈyi kǝra kumǝr dzǝ aga nyi mai. Ndǝr kǝra yi nar hyi kau, nǝ Mambǝl ngau, ba ǝnga nǝ pi tsu. ");
INSERT INTO mfm_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ama alaga abangau, nji aˈyi kǝra gǝra hǝnggǝri.” Ara tsu kaɗǝu, Yesu wu sǝni wu pama nda njira gǝra hǝnggǝri ǝnga ndǝra wu nda thlǝna hya ja. ");
INSERT INTO mfm_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kǝ Yesu dumwa ji na anǝ nda, “Ca ngǝ sǝra ɗa yi na anǝ hyi abǝr ndǝr sǝn shili ǝgya yau, aˈyi mai, kǝl ma Dǝɗa nǝ nda lagu.” ");
INSERT INTO mfm_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ayukuɗa highiɓǝ kau, kǝ zǝmbǝlma nyiˈyar gangǝu sha ara ɓǝra nu nyi. ");
INSERT INTO mfm_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kǝ Yesu yiwa zǝmbǝlma nyiˈyar kumo apǝ mǝthlǝ kau, “Nahyi ma hyu yiwu hya sha ara nu ɗa ya?” ");
INSERT INTO mfm_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Kǝ Simanu Biturusu shaɗǝwa nyi, ji na, “Thlagǝu, a ndǝra wa nga ˈya sǝn maˈya? Nagǝ ngǝ ndǝra ǝnga ndǝr nǝ lǝ pi gǝra kuɗau. ");
INSERT INTO mfm_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","A hǝnggǝri ˈya ǝnga a sǝn ˈya abǝr nagǝ ngǝ ndǝ Cici nǝ Hyal.” ");
INSERT INTO mfm_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kǝ Yesu shaɗǝwa nyi, ji na, “Aˈyi yi caɗǝbiya hyi kumo apǝ mǝthlǝ wa? Ama pathlǝ wu pama hyi shatan ngau.” ");
INSERT INTO mfm_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ju ndǝr kǝ ar kǝra Yahuda zǝr Simanu Isikarayoti, ara naja ngu nda thlǝna hya ja, kwalaga kǝ, pathlǝ ja wu pama nanda kǝ kumo apǝ mǝthlǝ kau. ");
INSERT INTO mfm_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ayukuɗa kau, ngǝ Yesu ɓǝra ɓǝbiya ɓau wu ˈyiˈyir Galili, ara naji wu yiwu ja maˈyi a vu Yahudi mai, ara njir Yahudiya kǝra a vuna wu gal lagur tsa nyi. ");
INSERT INTO mfm_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ama ar pǝci kǝra mini nǝ nggya wu kwapatǝ nǝ njir Yahudiya ɗar lǝhǝu, ");
INSERT INTO mfm_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","kǝ zamǝya Yesu ˈyar na anǝ nyi, “A ɗar tsaˈa ga piyari vi kǝ ga maˈyi a vu Yahudi, aga zǝmbǝlma ngǝˈyar kǝra a vuna nda lari sǝ dǝdǝgurˈyar kǝra gu mǝl. ");
INSERT INTO mfm_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ndǝ aˈyi kǝra wu yiwu nja sǝnbiya nyi, ba ja nggya ar ɗǝwa mai. Ta ɗa gu mǝl sǝ dǝdǝgurˈyar kau, ga cabiya kǝrngau anǝ njir duniya.” ");
INSERT INTO mfm_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Arya alaga zamǝ nyiˈyar ǝnga kǝrnda aˈyi hǝnggǝri ǝnga ja mai. ");
INSERT INTO mfm_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kǝ Yesu shaɗǝwa nda, ji na, “Pǝcir vu ɗa aˈyi ɗa kwatahǝ mai, ama anǝ hyi kalar pǝci a sǝn vu hyi. ");
INSERT INTO mfm_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Njir duniya wu piyari shishir dza hyi mai, ama nayi nga ndǝ piyari shishir dza yau, ara yu nar nda sǝr mǝla nda ɗǝmwaˈyi nga nyi. ");
INSERT INTO mfm_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nahyi, maˈya mau a ndar vir mini kau. Nayi nǝɗa nayi wu maˈyi kwatahǝ mai, ara pǝci ɗa aˈyi nyabiya dzǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ayukuɗa Yesu nar nda abangau, ba ji ɓǝra sǝkari wu ˈyiˈyir Galili. ");
INSERT INTO mfm_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ama ayukuɗa zamǝ nyiˈyar maˈyi a ndar vir mini, kǝ Yesu maˈyi tsu ama ar ɗǝwa aˈyi ar babal mai. ");
INSERT INTO mfm_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Njir Yahudiya kǝl gal nyi ar vir miniya nyi, ndu yiwa, ndu na, “Əmani nga ja?” ");
INSERT INTO mfm_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ar vir mini kau, nji kǝl ndǝr wu pamǝ ar kǝra Yesu ar ɗǝwa. Əngwar alenyi nji, “Ndǝ mǝnahǝ nga ja.” Əngwar alenyi nji tsu, “Ndǝr ngguta vi nga ja.” ");
INSERT INTO mfm_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ama ndǝr sǝn ndǝr ar kǝra Yesu ar babal aˈyi mai, ara ndu hivǝr njira nggurǝm nǝ njir Yahudiya. ");
INSERT INTO mfm_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ta nja vuri wu hathla mini, kǝ Yesu maˈyi a gwu Ki Hyal, ji gwa mbar highiɓau. ");
INSERT INTO mfm_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kǝ sǝ kǝ ɗa sǝ dǝdǝgur anǝ njir Yahudiya, ba ndǝ yiwa, “Lagu mani ngǝ ndǝ kǝ highiɓǝr sǝˈyar ka, ya, kǝja naji uya highiɓǝ maya?” ");
INSERT INTO mfm_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kǝ Yesu shaɗǝwa nda, ji na, “Sǝˈyar kǝ ya vǝr highiɓǝ kau, aˈyi nǝ kǝrɗa ngǝ mai, ama nǝ ndǝra sǝwa ɗa ngau. ");
INSERT INTO mfm_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kalar ndǝra wu yiwu ja mǝl sǝra Hyal wu yiwu, ju nda sǝnbiya abǝr highiɓǝ ɗa sara ara Hyal nga nyi shili, ama aˈyi nǝ kǝrɗa mai. ");
INSERT INTO mfm_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Njira wu ndǝr aga kǝrnda, thlǝmǝ nga ndu gal anǝ kǝrnda. Ama kalar ndǝra wu ndǝr aga shili ǝnga dlǝvau anǝ ndǝra sǝwa nyi, ndǝ jiri nga ja. Sǝ fati aˈyi wu ja mai. ");
INSERT INTO mfm_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Aˈyi Musa ngǝ nǝ hyi dlaɗǝ wa? Ama alaga ndǝ zǝmǝ aˈyi wu pama hyi kǝra a vǝr ɓǝlari mai. Mi ngǝ ɗa hyu gal tsa ɗa?” ");
INSERT INTO mfm_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Əngwar nja nyi anǝ nyi, “Mambǝl ɗǝmwaˈyi pahǝna liya gǝ ya? Wa ngu gal tsa nga?” ");
INSERT INTO mfm_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Kǝ Yesu shaɗǝwa nda, ji na, “Nayau, yi mǝliya hyi sǝ dǝdǝgur zǝmǝ wacu, ya kǝja hangǝkala hyi a hyaˈari. ");
INSERT INTO mfm_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa nǝ hyi dlaɗau ar kǝra thla pǝlzha (alaga kǝ aˈyi naja ngǝ dzǝguya mai, ama ǝjir hyi ˈyar ngau). Kwalaga abangau kǝja hya ɓǝlnar dlaɗa nyi lagur thla pǝlzha anǝ zǝr Pǝcir Ɓǝlsar. ");
INSERT INTO mfm_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kabangǝkau, a lar hyi abǝr a ɗar tsaˈa nja thlana nyi pǝlzha anǝ zǝr pǝcir Ɓǝlsar aga nja nyabiya dlaɗǝ Musa ar kǝra thla pǝlzha. Ya, ara mi ngǝ ɗa hyu ɗǝfu ǝnga yi ara yi shilǝgǝbiya ndǝ valam pǝcir Ɓǝlsar ara? ");
INSERT INTO mfm_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Hya piyari mǝl numa ga li ga li, ama hya mǝl numa kǝra kakalǝu.” ");
INSERT INTO mfm_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ar pǝci kǝ ngǝ njir Urshalima wu yiwa kǝrnda, “Aˈyi ndǝ kǝ nga nju gal aga tsa ta wa, ǝndǝga? ");
INSERT INTO mfm_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ya kǝja ja ǝnggau ju ndǝr ar babal, ya nandǝ wu na sǝ anǝ nyi mai. Njira nggurǝmǝr nda ya, ǝndǝga, a hǝnggǝri nda abǝr naja ngǝ Kǝrsiti ya? ");
INSERT INTO mfm_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ama naja nǝ nyi mǝn wu sǝni vira ji shili sara ari, ama ar pǝci kǝra Kǝrsiti nǝ jiri wu nggura shili, ndǝr sǝni vira ju hyaˈari sara ari aˈyi mai.” ");
INSERT INTO mfm_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu tsu ja vǝr highiɓǝ wu ki Hyal, kǝ ji hyaˈana ɗahǝu, ji na, “Jijiri, hyu sǝn ɗa ǝnga vira yi hyaˈari sara ari ya? Nayi shili ar kǝrɗa mai, ama ndǝra sǝwa ɗa, ndǝ jijiri ngau, ama nahyi wu sǝni nyi mai. ");
INSERT INTO mfm_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ama nayi yiwu sǝni nyi ara nayi sara ara ja nga yau ǝnga naja ngǝ sǝwa ɗa.” ");
INSERT INTO mfm_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ənggǝra Yesu nana ndǝr kau, kǝ ndǝ gal lagu kǝra nda sǝn mbar nyi. Ama ndǝ aˈyi kǝra tsǝkwari nyi mai, ara pǝci nyi aˈyi ɗa kwatahǝ mai. ");
INSERT INTO mfm_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Alaga abangau, nji gangǝu wu pama nda hǝnggǝri ǝnga ja. Əngwar alenyi nju pama nda, “Ma Kǝrsiti shili ya, ju sǝn sa mǝliya sǝ dǝdǝgur a ndiya kǝra ndǝ kǝ a vǝr mǝl kǝ ya?” ");
INSERT INTO mfm_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ta njir Farisi nggari nja vǝr ndǝr tsǝtsǝkaˈa ar kǝra Yesu, ba pubu dǝdǝgalˈyar ǝnga njir Farisi sǝwa gaga nǝ Ki Hyal aga nda nda mbar Yesu. ");
INSERT INTO mfm_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kǝ Yesu nar nda, abǝr, “Pǝcira ya daɓaga nggya ǝkkǝˈyi hyi a hyiri kushu, ba ya dzǝgwa sha a ndǝgya ndǝra sǝwa ɗa a shili. ");
INSERT INTO mfm_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Hyu nda gal ɗa, ama nahyi wu sǝn nǝr ɗa mai, ǝnga vira yu maˈyi a ndari nahyi wu sǝn maˈyi a ndǝna mai.” ");
INSERT INTO mfm_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kǝ njir Yahudiya na wu pama nda, “Nǝma ngǝ ndǝ kǝ wu yiwu ja maˈya, kǝra mǝn gǝra nda lari nyi ka? Ju yiwu ja maˈyi a ndar ˈyiˈyi njir Gǝrikǝu vira njir Yahudiya tǝtǝlnakǝr a ndar ya? Aga tara ba ja nda highiɓǝ anǝ nda ya? ");
INSERT INTO mfm_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mi ngǝ ɗǝnga nyi ǝnga ndǝr ka, ‘Hyu nda gal ɗa, ama nahyi wu nǝr ɗa mai,’ ǝnga ‘Vira yu nda maˈyi a ndari, nahyi wu sǝn shili ari maya’?” ");
INSERT INTO mfm_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ar jomǝr ndǝla pǝcir mini, kǝra naja ngǝ pǝci kǝra ndiya ǝnga dǝgalǝu, Yesu hyaˈari ji hyaˈana ɗahǝu, ji na, “Ma ndǝra wu nggari hili, bǝgǝ ja shili ja sa tǝwari ˈyimi ara yau. ");
INSERT INTO mfm_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kalar ndǝra hǝnggǝri ǝnga yau, ǝnggǝr kǝra nji tsǝfǝri wu lǝkakaɗǝ Hyal, abǝr sara wu ta ja ngǝ mandǝli ˈyimir pi wu nda ndǝla.” ");
INSERT INTO mfm_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ar pǝci kǝra ja vǝr ndǝr ar kǝra mandǝli nǝ lǝ pi kau, Mambǝl Cici nga ja vǝr ndǝr ar kǝri, Mambǝl Cici kǝra njira mbǝrsa wu nda dlǝwuri. Ar pǝci kǝ Mambǝl Cici aˈyi shili kwatahǝ mai ara tsu kadakadarkur Yesu gǝra cabiya dzau. ");
INSERT INTO mfm_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ənggǝra nji nggari ndǝr Yesu, ba alenyi nji na, “Jijiri ndǝ kǝ naja ngǝ nabi ta mǝna vir sǝkǝ ta.” ");
INSERT INTO mfm_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Alenyi nji tsu wu na, “Ndǝ kǝ naja ngǝ Kǝrsiti.” Əngwar alenyi nji tsu, “Lagu mani ngǝ Kǝrsiti a sǝn shili sara wu Galili ya? ");
INSERT INTO mfm_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Lǝkakaɗǝ Hyal kǝra tsǝtsǝfǝ aˈyi nar mǝn abǝr Kǝrsiti wu nda biya sara wu culi gǝ Dawuda wa? Ənga aˈyi ji nar mǝn abǝr sara wu mǝlmǝ Bayitalahami nga ju biya, mǝlmǝ kǝra Dawuda nggya a gwa gwa wa?” ");
INSERT INTO mfm_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kǝ miya nja nyi tǝkǝbiya dzǝ arya Yesu. ");
INSERT INTO mfm_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Alenyi nji ma ndu yiwu nda mbar nyi, ama ndǝ aˈyi fǝr tsi ar dza ja mai. ");
INSERT INTO mfm_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ayukuɗa nyi, kǝ njir ɓǝla ki Hyal sha a ndǝgya pubu dǝdǝgalˈyar ǝnga njir Farisi, njira sǝwa nda, ka yiwa nda, ndǝ na, “Mi ngǝ ɗa nahyi shili ǝnga ja maya?” ");
INSERT INTO mfm_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Kǝ njir ɓǝla ki Hyal shaɗǝwa nda, ndǝ na, “Ndǝ aˈyi kǝra saya ndǝrbiya ndǝr ǝnggǝr ndǝ kǝ mai!” ");
INSERT INTO mfm_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Kǝ njir Farisi nar nyi anǝ njir ɓǝla ki Hyal, “Patǝ ǝkkǝˈyi nahyi tsu nga ji nggutana kǝ ya? ");
INSERT INTO mfm_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","A lar hyi njira nggurǝm ǝnga njir Farisi kǝra hǝnggǝri ǝnga ja ya? Awau! ");
INSERT INTO mfm_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ama daɓǝr nji kǝra gǝra sǝn sǝ ar kǝra dlaɗǝ Musa, Hyal a shiˈwuna ndar ja.” ");
INSERT INTO mfm_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimosu, ndǝra shili ǝgya Yesu tsu kaɗǝu ǝnga tsu pathlǝ ja wu pama nda, yiwa, ");
INSERT INTO mfm_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Mi ngǝ dlaɗǝr mǝn na, aˈyi kǝl nji nggari wu miya ndǝra nju vazau, sǝra ji mǝliya divira nja dzǝgwa mǝlna nyi numa wa?” ");
INSERT INTO mfm_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Əngwar nda anǝ nyi, “Nagǝ ma ndǝr Galili ya? Tsambiya a vu lǝkakaɗǝ nǝ Hyal, ba ga lari abǝr nabi aˈyi kǝra dla sara wu Galili mai.” ");
INSERT INTO mfm_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kǝ kalar ndǝ maˈyi a ndu ki nyi. ");
INSERT INTO mfm_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu maˈyi a dar mǝ nǝ wur Zayitunu. ");
INSERT INTO mfm_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kaɗǝ ǝmudlau kǝ Yesu ɓǝra maˈyi a gwu ki Hyal. Nji gangǝ kaɓau a shili ara ja. A guna ba ji gwa uya vir nggya, ji dzǝgwa highiɓǝ anǝ nji. ");
INSERT INTO mfm_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kǝ malǝmǝ dlaɗǝˈyar ǝnga njir Farisi shili ǝnga mala kǝra nji mbari nyi a vǝr mǝl sǝsukur. Ndǝ sa taˈyina nyi wu hada nda. ");
INSERT INTO mfm_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kǝ ndǝ na anǝ Yesu, “Malǝmǝ, mala kau, ˈyi mbar nyi a vǝr mǝl sǝsukur. ");
INSERT INTO mfm_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Wu dlaɗau, Musa nar ˈya, abǝr ˈya tsǝya culi mala kǝ ǝnga tsǝka vavaka. Mi nga gǝ na nǝ nga?” ");
INSERT INTO mfm_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ndu mǝl thlǝr ǝnga najaka yiwa sǝ aga nda nggǝya nyi lǝbam. Ndu yiwu aga nda uya lagu kǝra nda sǝn vazǝya nyi ari. Ama kǝ Yesu uzha gya, ba ji mbari tsǝfǝ sǝ ǝnga tsa ja a gyiwu ˈyi. ");
INSERT INTO mfm_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ənggǝra ndǝ dumwa ǝnga yiwa Yesu, ba ji hyaˈari ji na anǝ nda, “Ma ndǝ aˈyi kǝra gǝra ǝnga bikau wu pama hyi, bǝgǝ ja dzǝguya vaka nyi ǝnga tsǝka.” ");
INSERT INTO mfm_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kǝ Yesu ɓǝra uzha gya, ba ji ɓǝra dumwa ǝnga tsǝfǝ sǝ a gyiwu ˈyi. ");
INSERT INTO mfm_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ənggǝra ndǝ nggari abangau, ba ndǝ dzǝguya maˈyi zǝmǝ zǝmǝu, mbari ar njira nggurǝm baˈanǝ nji kukushu. Ənggau, ba ndǝ piyari Yesu zhizhi nyi ǝnga mala kǝ taˈyu wu mwa nyi a ndǝna. ");
INSERT INTO mfm_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kǝ Yesu hyaˈari aˈyi taˈyau, kǝ ji yiwa nyi, ji na, “Mala, ǝmani nga nda? Ndǝ aˈyi kǝra mǝliya ngǝ numa wa?” ");
INSERT INTO mfm_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kǝ ji shaɗǝwa nyi, ji na, “Malǝmǝ ndǝ aˈyi mai.” Kǝ Yesu na anǝ nyi, “Alaga nayi ma sǝ aˈyi yu na anǝ ngǝ mai. Maˈyi sǝ ngau, ama ga sara dumwa ǝnga mǝl bikǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ar pǝci kǝra Yesu ɓǝra ndǝr anǝ nja nyi, kǝ ji na, “Nayi ngǝ mbǝmbǝl nǝ duniya. Kalar ndǝra wu nu ɗa, naji wu ɓǝ wu kuthlǝ mai, ama ju uya mbǝmbǝl nǝ pi.” ");
INSERT INTO mfm_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kǝ njir Farisi nar nyi anǝ Yesu, “Gǝ wu lǝ sakida ar kǝra kǝrngau, sakida ngau a sǝn ɗa ǝnga jiri mai.” ");
INSERT INTO mfm_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Kǝ Yesu shaɗǝwa nda, ji na, “Alaga yi lǝr sakida ar kǝra kǝrɗa, sakida ɗa jiri nga nyi, ara yu sǝni vira yi hyaˈari sara ndari ǝnga vira yu maˈyi a ndari. Ama nahyi wu sǝni vira yi shili sara ndari ǝnga vira yu maˈyi a ndari mai. ");
INSERT INTO mfm_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Numar hyi nǝ ndǝndǝkur, ama nǝ ɗa aˈyi abangǝ mai. ");
INSERT INTO mfm_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ama alaga yu mǝl numa, numa ɗa jiri nga nyi, ara nayi aˈyi zhizhi ɗa mai, ama ndǝra sǝwa ɗa aˈyi ja ǝnga yau. ");
INSERT INTO mfm_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Əngwar dlaɗǝr hyi, ma nji mǝthlǝ lǝr sakida ar kǝra sau, sa nyi a ɗari jiri. ");
INSERT INTO mfm_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yu lǝ sakida ar kǝra kǝrɗa. Dǝɗa kǝra sǝwa ɗa tsu naja ngǝ nǝ mǝthlǝkura nyi.” ");
INSERT INTO mfm_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kǝ ndǝ yiwa nyi, ndǝ na, “Əmani ngǝ dǝnga?” Əngwar Yesu anǝ nda, “Nahyu sǝn ɗa ǝnga Dǝɗa mai, maja abǝr hyu sǝn ɗa, a sǝnǝr hyi Dǝɗa tsu.” ");
INSERT INTO mfm_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu nana ndǝr kǝ ar pǝci kǝra ja vǝr highiɓau a vu ki Hyal lǝhǝu ar vir ɗǝwa gǝnna kǝra nji tsǝmiya ari. Ndǝ aˈyi kǝra mbari nyi tsu mai ara pǝci nyi aˈyi ɗa kwatahǝ mai. ");
INSERT INTO mfm_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Kǝ Yesu ɓǝra na anǝ nda, “Kǝja yu maˈyi sǝ ɗa, ǝnga hyu nda gal ɗa, ba hya tǝ wu bikǝr hyi. Vira yu maˈyi a ndari, nahyi wu sǝn ndari mai.” ");
INSERT INTO mfm_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ba sǝ kǝ mǝliya njira nggurǝm nǝ Yahudiya wu yiwa kǝrnda, “Ju nda tsǝya kǝrnyi ya? Ca ngǝ mǝliya ju na, ‘Vira yu maˈyi a ndari nahyi wu sǝn nda mai kǝ ya’?” ");
INSERT INTO mfm_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ama kǝ Yesu ɓǝra dumwa, ji na, “Nahyi sara gyiwu ˈyi ngau, nayi tsu sara a dǝmǝlmau. Nahyi nǝ duniya ngau, ama nayi aˈyi nǝ duniya mai. ");
INSERT INTO mfm_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ca ngǝ sǝra ɗa yi na anǝ hyi, hyu nda tǝ wu bikǝr hyi. Ara ma nahyi aˈyi hǝnggǝri ǝnga sǝra yi na ar kǝra kǝrɗa kǝ mai, ǝnga jiri hyu nda tǝ wu bikǝr hyi.” ");
INSERT INTO mfm_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kǝ ndǝ yiwa nyi, “Wa nga ga?” Əngwar Yesu anǝ nda, “Kakalǝ ǝnggǝr kǝra yi nar hyi tsu kaɗǝ ta.” ");
INSERT INTO mfm_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Sǝ aˈyi gangǝu kǝra yu sǝn na ar kǝra hyi nǝ mǝl numa. Yu nar nyi anǝ nji sǝra ndǝra sǝwa ɗa wu na anǝ ɗa zhizhi nyi, ǝnga tsu sǝra ju na jiri nga nyi. ");
INSERT INTO mfm_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nandǝ nggabiya abǝr ar kǝra Dǝnyi nga ju ndǝr anǝ nda mai. ");
INSERT INTO mfm_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ca ngǝ sǝra mǝliya Yesu nar nda, abǝr, “Ar pǝci kǝra hyu nda hari Zǝr Ndau a di, ar pǝci ta nga hyu nda nggabiya abǝr nayi ndǝra yu na, nayi ngau. Nayi tsu yu mǝl sǝ kǝrɗa mai, ama yu highiɓǝ sǝra Dǝɗa highiɓǝr ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ndǝra sǝwa ɗa aˈyi ja ǝnga yau, naji piyari ɗa zhizhi ɗa mai, ara cumu yu mǝl sǝra wu pina huɗa ja.” ");
INSERT INTO mfm_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ar pǝci kǝra Yesu nana sǝˈyar kau, nji gangǝu hǝnggǝri ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kǝ Yesu nar nyi anǝ njir Yahudiya kǝra hǝnggǝri ǝnga ja, “Ma hyi dumwa ǝnga sǝɓǝ highiɓǝ ɗa ǝnga jiri, nahyi ngǝ zǝmbǝlma ɗaˈyar nǝ jijiri. ");
INSERT INTO mfm_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Hyu nda sǝnbiya jiri, jira nyi tsu wu nda pǝlna hyi.” ");
INSERT INTO mfm_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kǝ ndǝ shaɗǝwa nyi, ndǝ na, “Naˈya culi gǝ Ibrahimu ngau, naˈya sara vǝr ɗa mafa ndǝ mai. Ya, mi ngǝ ɗa gu na, ba nja pǝlna ˈya?” ");
INSERT INTO mfm_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Kǝ Yesu shaɗǝwa nda, ji na, “Jijiri nga yu na anǝ hyi, kalar ndǝr mǝl bikau, mafa bikǝ nga ja. ");
INSERT INTO mfm_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mafa aˈyi wu sǝn ɗa zǝr ki parangǝ mai, ama zǝr kǝra nji ya wu ki, zǝr kiya nyi nga ja baˈanuwa. ");
INSERT INTO mfm_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ma sǝn ɗa ba Zǝra nyi pǝlna hyi, a ɗar hyi pǝpǝl ǝnga jiri. ");
INSERT INTO mfm_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Wu sǝn yi abǝr nahyi culi gǝ Ibrahimu ngau, ama kǝja hyu gal lagur tsa ɗa, ara vir fiya ndǝr ɗa aˈyi wu ɗǝfuwa hyi mai. ");
INSERT INTO mfm_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yu na anǝ hyi sǝra yi lari ara Dǝɗa, ama nahyi, hyu mǝl sǝra hyi nggari ara dǝrhyi.” ");
INSERT INTO mfm_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Kǝ ndǝ shaɗǝwa nyi, ndǝ na, “Ibrahimu ngǝ dǝrˈya.” Kǝ Yesu shaɗǝwa nda, ji na, “Maja abǝr wazha Ibrahimu nga hyi, a mǝlǝr hyi sǝra Ibrahimu mǝlna. ");
INSERT INTO mfm_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nayi ndǝ ngau, ndǝr na sǝra jiri kǝra yu nggari sara ara Hyal, ama kǝja hyu yiwu hya tsǝya ɗa. Ya, kǝja Ibrahimu aˈyi mǝl culi sǝ ǝnggǝr kǝ mai. ");
INSERT INTO mfm_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Sǝra dǝrhyi mǝlna ca nga hya vǝr mǝl.” Ama kǝ njir Yahudiya na, “Naˈya aˈyi wazha mandzagwa mai, tada kǝra ara ˈya Hyal nga kǝrnyi wacu.” ");
INSERT INTO mfm_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Əngwar Yesu anǝ nda, “Maja abǝr Hyal ngǝ dǝrhyi, hyu cabiya ɗa yiwukur, ara yi shili sara ara Hyal. Ya kǝja yi ǝnggau, nayi shili ar kǝrɗa mai, ama naja ngǝ sǝwa ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ara mi nga hyi gǝra nggabiya ndǝr ɗa? Ara nahyi aˈyi wu nggari sǝra yu na mai. ");
INSERT INTO mfm_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nahyi nǝ dǝrhyi shatan ngau, ǝnga hyu yiwu hya mǝl sǝra dǝrhyi wu yiwu. Tsu mudlau naja ndǝr tsa ndǝ nga ja, ǝnga naji wu sǝɓǝ jiri mai, arya jiri aˈyi wu ja mai. Ar pǝci kǝra ji thlar fati, miya gǝ nda nga ji nana, ara naja ndǝr thla fati ngau, ǝnga dǝya fati. ");
INSERT INTO mfm_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ama ara ma yi nar hyi jiri, nahyi wu hǝnggǝri ǝnga yi mai! ");
INSERT INTO mfm_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wu pama hyi ya, wa ndǝra wu sǝn vazǝya ɗa ǝnga bika? Ma yi nar hyi jiri, mi ngu ɗa nahyi wu hǝnggǝri ǝnga yi maya? ");
INSERT INTO mfm_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kalar ndǝra nǝ Hyal ngau, ju sǝhimi sǝra Hyal wu na. Sǝra ɗa nahyi wu sǝhimi nyi mai, ara nahyi aˈyi nǝ Hyal mai.” ");
INSERT INTO mfm_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Njir Yahudiya shaɗǝwa nyi, ndǝ na, “Aˈyi jiri ǝnga ˈya, ǝnggǝra ˈyi na abǝr nagǝ ndǝr Samariya kǝra nyinyau ǝnga mambǝl ɗǝmwaˈyi wa?” ");
INSERT INTO mfm_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Əngwar Yesu anǝ nda, “Nayi aˈyi yi ǝnga mambǝl ɗǝmwaˈyi mai. Yu ha kǝra Dǝɗa, ama nahyi wu ha kǝra yi mai. ");
INSERT INTO mfm_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nayi ngu gal fal anǝ kǝrɗa mai, ama ndǝ aˈyi kǝra wu gal anǝ ɗa, naja ngǝ ndǝr mǝl numa. ");
INSERT INTO mfm_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Jijiri ǝnga yu na anǝ hyi, ma ndǝra sǝɓiya ndǝr ɗa, naji wu tǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ar kǝra ndǝr kau, ǝngwar njir Yahudiya anǝ nyi, “Kabangǝkǝ ja, a sǝn ˈya abǝr nagǝ aˈyi gǝ ǝnga mambǝl ɗǝmwaˈyu! Ibrahimu ǝnga kǝrnyi a tǝri ja ba nabiˈyar pamǝpamǝ tsu, ama ǝngwar gau, ‘Kalar ndǝra wu hǝnggǝri ǝnga ndǝr ɗa naji wu tǝ mai.’ ");
INSERT INTO mfm_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Naga ndiya dǝrˈya Ibrahimu ya? Naja ma a tǝr ja ǝnga tsu abangau ngǝ nabiˈyar. Ma gǝ nggani wa nga ga?” ");
INSERT INTO mfm_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Əngwar Yesu, “Ma yu lǝ kadakadarkur anǝ kǝrɗa, kadakadarkur ɗa aˈyi ar viya vanyi sǝ mai. Dǝɗa, kǝra hyu na abǝr Hyalǝr hyi ngau, naja ngu lǝ kadakadarkur anǝ ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kwalaga kǝ nahyi wu sǝn nyi mai kau, nayau, yu sǝn nyi. Ma yi na, nayi wu sǝn nyi mai, a ɗar yi ndǝr thla fati ǝnggǝr nahyi. Ama nayau, yu sǝn nyi ǝnga yu ɓǝlar ndǝr nyi. ");
INSERT INTO mfm_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Dǝrhyi Ibrahimu a cagulir ja gagaɗau aga ja lari pǝci ɗa, a lar ja ǝnga huɗǝ pipida gagaɗau.” ");
INSERT INTO mfm_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Əngwar njir Yahudiya anǝ nyi, “Nagǝ ndǝra gǝra kar fa tǝfukumunyi, gu na abǝr a lar gǝ Ibrahimu ya?” ");
INSERT INTO mfm_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Əngwar Yesu, “Jijiri nga yu na anǝ hyi, kadivira nja ya Ibrahimu aˈyi yau.” ");
INSERT INTO mfm_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ənggǝra ndǝ nggar ndǝr kau, ba ndǝ ɗǝɗǝmǝri tsǝka ndu yiwu nda vavakǝya nyi, ama kǝ Yesu gwaɗǝnakǝr. Ba ji biya sara wu ki Hyal. ");
INSERT INTO mfm_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ənggǝra Yesu a vǝr tǝrabiya, kǝ ji lari vanyi ndǝ kǝra nji yabiya nyi lǝfau. ");
INSERT INTO mfm_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kǝ zǝmbǝlma nyiˈyar yiwa nyi, “Malǝmǝ, bikǝ wa ngǝ mǝliya nji yabiya ndǝ kǝ lǝfa? Bikǝ nyi ǝndǝga nǝ njir ya nyi ya?” ");
INSERT INTO mfm_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Kǝ Yesu shaɗǝwa nda, “Aˈyi bikǝ nyi mai ǝnga aˈyi bikǝ njir ya nyi tsu mai, ama sǝ kǝ ɗarkǝr aga dǝnama nǝ Hyal a cabiya kǝr wu nggyabiya nyi. ");
INSERT INTO mfm_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","A ɗari tsaˈa mǝna dumwa ǝnga mǝl thlǝr nǝ ndǝra sǝwa ɗa, ma tsu puci, ara vuˈyi wu shili, kǝra ndǝ aˈyi kǝra sǝn mǝl thlǝr mai. ");
INSERT INTO mfm_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ma tsu yi aˈyi wu duniya, nayi ngǝ mbǝmbǝl nǝ duniya.” ");
INSERT INTO mfm_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ayukuɗa ji nana abangau, kǝ ji tǝfǝr tuli a gyiwu ˈyi, ba ji dzǝguri ˈyiˈya nyi, ba ji tǝɓǝri, ji ɓǝsiya ar liya nda nyi. ");
INSERT INTO mfm_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Əngwar ja anǝ nda nyi, “Maˈyi ga gwa cina bama gau a gu faˈa Sǝliwamu.” (Ca ngǝ Sǝsau). Kǝ ndǝ kǝ maˈyi ji gwa cina bama ja, kǝ ji sha shili ju lar sau. ");
INSERT INTO mfm_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kǝ tǝwul nyiˈyar ǝnga njira tsǝliya lari nyi a vǝr kǝdi ɗǝɗǝmǝu, na, “Aˈyi ndǝ kǝ ngu nggya ǝnggau, ju kǝdi ta wa?” ");
INSERT INTO mfm_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Əngwar alenyi nji, “Naja ngau.” Əngwar alenyi nji tsu, “Awau, ndǝr pa nyi ngau.” Ama, naja ǝnga kǝrnyi dumwa ǝnga na, “Nayi ngau pakatǝu!” ");
INSERT INTO mfm_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kǝ ndǝ yiwa nyi, ndǝ na, “Ya, lagu mani ngǝ liya gǝ kǝ paha?” ");
INSERT INTO mfm_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Əngwar ja, “Ndǝ kǝ nju ngga ǝnga Yesu kau, ngǝ dzǝgur ˈyiˈyi ǝnga tuli, kǝ ji ɓǝsiya ar liya yau. Kǝ ji na anǝ ɗa, ‘Maˈyi a gu faˈa Sǝliwamu ga gwa cina bama gau.’ Ba yi maˈyi, yi gwa cina bama, ba yi lar sau.” ");
INSERT INTO mfm_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Əngwar nda anǝ nyi, “Əmani ngǝ ndǝ ka?” Əngwar ja, “Nayi wu sǝni mai.” ");
INSERT INTO mfm_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kǝ ndǝ hǝri ndǝra nji yabiya lǝfǝ ta a ndǝra njir Farisi. ");
INSERT INTO mfm_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Arya pǝcir Ɓǝlsar ngǝ Yesu tǝfǝr tuli kǝra ji dzǝgur ˈyiˈyi ǝni, kǝ ji pahǝna liya ndǝ kau. ");
INSERT INTO mfm_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Agabangau, kǝ njir Farisi tsu yiwa nyi, lagu kǝra ji uya, ju lar sau. Əngwar ja anǝ nda, “Ji ɓǝsiya tsǝkwaɓǝ kǝra ji dzǝguri ar liya yau. Yi maˈyi yi gwa cina bama yau, ba yi lar sau.” ");
INSERT INTO mfm_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Əngwar alenyi njir Farisi, “Ndǝ kǝ aˈyi sara ara Hyal mai, arya naji wu ɓǝla pǝcir Ɓǝlsar mai.” Ama alenyi nju na, “Abari ngǝ ndǝr bikau a sǝn mǝliya najaka sǝ dǝdǝgura?” Kǝ ndǝ tǝkǝbiya dzau. ");
INSERT INTO mfm_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kǝ ndǝ ɓǝra shabiya dzǝ a ndǝgya ndǝ lǝfǝ ta, ndǝ na, “Mi sǝra gu na ar kǝra ndǝ ka, kǝja liya gǝ nga ji pahǝna?” Əngwar nda nyi, “Naja nabi ngau.” ");
INSERT INTO mfm_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Njira nggurǝm nǝ Yahudiya, aˈyi hǝnggǝri abǝr ndǝ kǝ ɗǝɗǝmǝ lǝfǝ nga ja mai, kǝl ta ndǝ sǝwa nja nggar nda njir ya nyi. ");
INSERT INTO mfm_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ndǝ sa yiwa nda, “Zǝr hyi ngǝ ndǝ kǝ ya? Naja nga hyi na nji ya nyi lǝfǝ ta ya? Ya, lagu mani nga ju lar sǝ kabangǝkǝ ka?” ");
INSERT INTO mfm_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Əngwar njir ya nyi anǝ nda, “ˈYi wu sǝni abǝr zǝr ˈya ngau, lǝfǝ nga nji ya nyi. ");
INSERT INTO mfm_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ama ǝnggǝra ju lar sǝ kabangǝkau, ǝnga tara wa ngǝ pahǝna liya ja, naˈyu sǝni mai. Yiwa nya mau, fa nyi a kari aga ja ndǝr ǝnga kǝrnyi.” ");
INSERT INTO mfm_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Njir ya nyi ndǝr abangau ara hivǝr njira nggurǝm nǝ Yahudiya, ara ndǝ mbiya miya abǝr kalar ndǝra hǝnggǝri abǝr Yesu ngǝ Kǝrsiti, ba nja kǝdlǝbiya nyi sara wu vir daɓǝ dzǝ njir Yahudiya. ");
INSERT INTO mfm_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ca ngǝ sǝra ɗa njir ya nyi na, “Fa nyi a kari, hya yiwa nyi.” ");
INSERT INTO mfm_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kǝ ndǝ ɓǝra ngga ndǝra nji yabiya lǝfau nǝ mǝthlǝkura nyi, ndǝ na anǝ nyi, “Nana sǝra jiri wu mwar Hyal. Naˈya ˈyi wu sǝni abǝr ndǝ kau, ndǝr bikǝ ngau.” ");
INSERT INTO mfm_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Kǝ ji shaɗǝwa, ji na, “Tara ndǝr bikǝ nga ja ǝnga ndǝr bikǝ nga ja mai, nayi wu sǝni mai. Sǝra yu sǝni ca ngǝ ɗǝɗǝmǝ lǝfǝ nga yau, ama kabangǝkǝ yu lar sau.” ");
INSERT INTO mfm_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kǝ ndǝ ɓǝra yiwa nyi, ndǝ na, “Mi nga ji mǝliya nga? Lagu mani nga ji pahǝna liya ga?” ");
INSERT INTO mfm_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Kǝ ji shaɗǝwa nda, ji na, “A nar hyir yi tsu kaɗǝu, ama nahyi sǝhimi mai. Mi ngǝ ɗa hyu ɓǝra yiwa ɗa? Hyu yiwu hya ɗa zǝmbǝlma nyiˈyar ǝtsu ya?” ");
INSERT INTO mfm_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kǝ ndǝ nggǝnggǝlna nyi, ndǝ na, “Nagǝ ngǝ zǝmbǝlma nyi sǝ ngau, ama naˈya zǝmbǝlma Musa nga ˈya. ");
INSERT INTO mfm_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Wu sǝn ˈya abǝr Hyal ndǝr ǝnga Musa, ama ndǝ kau, naˈyu sǝni vira ji shili sara ndari mai.” ");
INSERT INTO mfm_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kǝ ji shaɗǝwa nda, ji na, “Kǝja mǝ sǝ dǝdǝgur ja! Nahyi sǝni vira ji shili sara ndari mai, ama kǝja ja pahǝnar liya yau! ");
INSERT INTO mfm_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Namǝn wu sǝni abǝr Hyal aˈyi wu nggari kǝdi nǝ njir bikǝ mai. Ama ju sǝhimi kǝdi nǝ njira wu dlǝvǝ nyi ǝnga ndu mǝl sǝra ju yiwu nda mǝl. ");
INSERT INTO mfm_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mbar dzǝgwar duniya, ndǝ aˈyi kǝra saya nggari abǝr nji pahǝna liya ndǝra nji ya nyi lǝfǝ mai. ");
INSERT INTO mfm_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ma ndǝ kǝ aˈyi sara ara Hyal mai, sǝ aˈyi ju sǝn mǝliya mai.” ");
INSERT INTO mfm_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Kǝ ndǝ shaɗǝwa nyi, ndǝ na, “Nagǝ ndǝra nji yabiya wu bikau, gu yiwu ga highiɓau anǝ ˈya?” Ba ndǝ kǝdlǝbiya nyi a biya sara wu umbwa daɓǝ dzǝ njir Yahudiya. ");
INSERT INTO mfm_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu nggari abǝr ndǝ kǝdlǝbiya nda nyi a biya. Ba ji thlǝwa nyi, ji yiwa nyi, “A hǝnggǝr gǝ ǝnga Zǝr Ndǝ ya?” ");
INSERT INTO mfm_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Əngwar nda nyi anǝ nyi, “Wa nga ja, Malǝmǝ? Nar ɗa aga ya hǝnggǝr ǝnga ja.” ");
INSERT INTO mfm_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kǝ Yesu shaɗǝwa nyi, “A lar nyir gau, naja nga vǝr ndǝr ǝnga gǝ kau.” ");
INSERT INTO mfm_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kǝ ndǝ kǝ na, “Thlagǝu, a hǝnggǝr yau,” ba ji dlǝvǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Əngwar Yesu anǝ nyi, “Aga numa nga yi shili wu duniya, aga njira lǝfau nda lar sau ǝnga njira wu nggani ndu lar sǝ tsu nda ɗa lǝfau.” ");
INSERT INTO mfm_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ənggǝra alenyi njir Farisi kǝra ǝnga ja nggari abangau, kǝ ndǝ na anǝ nyi, “Mi? Gu yiwu ga na abǝr naˈya ma, nji lǝfǝ ya?” ");
INSERT INTO mfm_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Əngwar Yesu anǝ nda, “Maja abǝr lǝfǝ nga hyi wacu, nahyi aˈyi ǝnga bikǝ mai. Ama ta hyi na abǝr hyu lar sau, ca ngǝ ɗa bikǝr hyi a nggyari ǝnga hyi. ");
INSERT INTO mfm_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Jiri nga yu na anǝ hyi, kalar ndǝra aˈyi vu dlǝma lagu miyar gwa nyi mai, ama ji vu lagu ya dlǝma, naja ndǝr hǝl ngau ǝnga ndǝr ɗa lagu. ");
INSERT INTO mfm_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ndǝra vu lagu miyar gwa nǝ dlǝma, naja ngǝ ndǝr ɓǝla tǝmahǝu. ");
INSERT INTO mfm_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ndǝr ɓǝla dlǝma wu pahǝna nyi miyar gwa nǝ dlǝma, ba ja vwau. Tǝmahǝ tsu ndu sǝya nyi himi. Ju ngga tǝmahǝ nyi ǝnga thlǝmǝr nda, ba ja lǝbiya nda a biya. ");
INSERT INTO mfm_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ayukuɗa ji faˈabiya tǝmahǝ nyi a biya patǝu, ba ja maˈyi a dumwar nda, ba tǝmahǝ nyi a nu nyi ara ndu sǝn ɗaha ja. ");
INSERT INTO mfm_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ama nandǝ wu nu mǝthlǝpi mai, kǝl ma, nda hwi ara ja, ara nandǝ wu sǝn ɗaha mǝthlǝpi mai.” ");
INSERT INTO mfm_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu nar nda najaka karapau, ama nandǝ nggabiya sǝra ju na anǝ nda mai. ");
INSERT INTO mfm_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Agabangau, kǝ Yesu ɓǝra na anǝ nda, “Yi wu nar hyi jirkura nyi, nayi ngǝ miya lagu vu dlǝma tǝmahǝu. ");
INSERT INTO mfm_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Patǝr njira dla divira yi shili, njir hǝl ǝnga njir ɗa lagu ngau, ama tǝmahǝ aˈyi sǝya nda himi mai. ");
INSERT INTO mfm_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nayi ngǝ miya lagu vu dlǝma, kalar ndǝra vu lagu ɗa ju uya mbǝɗau. Ju vwau ǝnga ju biya, ba ja biya uya vir sǝm sǝr sǝm. ");
INSERT INTO mfm_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ndǝr hǝl wu shili wacu aga sa hǝl ǝnga sa tsa ba aga sa ndza sau. Ama nayi yi shili aga nda uya pi, pi kǝra nyinyi gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nayi ngǝ ndǝr ɓǝla kǝra mǝnahǝu. Ndǝr ɓǝla kǝra mǝnahǝu wu lǝr piya ja arya tǝmahǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ndǝra nji hǝri aga ɓǝla, naja aˈyi thlagǝr tǝmahǝ mai. Ma ji lari ufwar vuwa a vǝr shili, ba ja hwinakǝr ja piyari nda. Ba ufwar vuwa kakathlǝr tǝmahǝu ba ja tǝtǝlna kǝra nda. ");
INSERT INTO mfm_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ndǝra nji hǝr kau, ju hwinakǝr ara tǝmahǝ aˈyi nǝ nyi mai, ǝnga tsu dzaˈwu nyi aˈyi ǝnga nda mai. ");
INSERT INTO mfm_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Nayi ngǝ ndǝr ɓǝla kǝra mǝnahǝu, yu sǝn tǝmahǝ ɗa ǝnga tǝmahǝ ɗa wu sǝn ɗa tsu. ");
INSERT INTO mfm_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Kakalǝ ǝnggǝr kǝra Dǝɗa wu sǝn ɗa, nayi tsu yu sǝn Dǝɗa. Nayi tsu yu lǝri piya yau, arya tǝmahǝ ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Aˈyi yi ǝnga alenyi tǝmahǝ kǝra aˈyi nda wu dlǝma kǝ mai. Kǝl ya shili ǝnga nda tsu. Nanda ma ndu nda sǝhimi sǝra yu na, ǝnga ndu ɗa tsǝkǝˈyi zǝmǝu ǝnga ndǝr ɓǝla zǝmǝ pir. ");
INSERT INTO mfm_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Sǝra ɗa Dǝɗa wu yiwu ɗa ngau, ara yu lǝr piya yau, aga ya ɓǝra shabiya nyi a shili wayu. ");
INSERT INTO mfm_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ndǝr sǝn hǝbiya piya yi aˈyi mai, kǝl nayi nga sǝn lǝr sǝ ɗa. Dǝnama nǝ lǝri ǝnga shabiya nyi a shili aˈyi ara yau. Dlaɗǝ kǝra Dǝɗa lǝri anǝ ɗa ngau.” ");
INSERT INTO mfm_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Arya ndǝr kǝ ngǝ njir Yahudiya ɓǝra tǝkǝbiya dzǝ wayu. ");
INSERT INTO mfm_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Nji gangǝu wu pama nda wu na, abǝr, “Naja ǝnga mambǝl ɗǝmwaˈyu, ǝnga ju thlǝkau. Mi ngǝ ɗa hyu sǝya nyi himiya?” ");
INSERT INTO mfm_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ama ǝngwar alenyi nji, “Ndǝr kǝ aˈyi ndǝr nǝ ndǝra ǝnga mambǝl ɗǝmwaˈyi ngǝ mai. Ndǝra ǝnga mambǝl ɗǝmwaˈyi a sǝn pahǝna liya ndǝ lǝfǝ ya?” ");
INSERT INTO mfm_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kǝ pǝcir mini nǝ fǝ barka ar kǝra Ki Hyal shili, a vu Urshalima. Ar pǝcir fwahǝu ngǝ sǝkǝ ɗarkǝr. ");
INSERT INTO mfm_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","A gwu Ki Hyal kau, Yesu a vǝr ɓǝɓau ar vira nju ngga ǝnga dalaɓagǝu nǝ Solomanu. ");
INSERT INTO mfm_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Kǝ njir Yahudiya kǝra zǝwari nyi na, “Baˈanuwa nga gu piyari ˈya wu kuthla? Ma nagǝ ngǝ Kǝrsiti nar ˈya ar babal.” ");
INSERT INTO mfm_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Kǝ Yesu shaɗǝwa nda, ji na, “A nar hyir yau, ama nahyi hǝnggǝr nǝ mai. Sǝ dǝdǝgur kǝra ya vǝr mǝl wu thlǝmǝr Dǝɗa nga vǝr ndǝr ar kǝra yau. ");
INSERT INTO mfm_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ama nahyi hǝnggǝr ǝni mai ara nahyi aˈyi hyi tǝmahǝ ɗa mai. ");
INSERT INTO mfm_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tǝmahǝ ɗa ndu sǝhimi ɗaha yau. Yu sǝn nda ǝnga ndu nu ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yu nǝ nda pi gǝra kuɗau, ǝnga nandǝ wu sa mai. Ndǝr sǝn mbǝliya nda sara wu tsa yi aˈyi tsu mai. ");
INSERT INTO mfm_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Dǝɗa kǝra nǝ ɗa nda a ndiyar kalar ndǝ ǝnga dǝgalǝu. Ndǝr sǝn mbǝliya nda sara wu tsa ja aˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nayi ǝnga Dǝɗa nji zǝmǝ nga ˈya.” ");
INSERT INTO mfm_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kǝ njir Yahudiya ɓǝra faˈari tsǝka aga nda tsǝya nyi ǝnga tsǝka vavaka. ");
INSERT INTO mfm_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kǝ Yesu na anǝ nda, “A canǝ hyir yi sǝ dǝdǝgur gangǝ gagaɗau sara ara Dǝɗa, arya mani wu pama nda nga hyu gal tsa ɗa ǝnga tsǝka vavaka ka?” ");
INSERT INTO mfm_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Əngwar njir Yahudiya anǝ nyi, “Naˈyu gal tsa ngau ǝnga tsǝka vavaka arya sǝ mǝnahǝu kǝra gǝ mǝlna kǝ mai, ama arya ndǝr nǝ diɗa Hyal kǝra gu na. Nagǝ ndǝ ngǝ wacu, ama gu yiwu ga kakalǝr kǝrngau ǝnga Hyal.” ");
INSERT INTO mfm_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu shaɗǝwa nda, ji na, “Aˈyi tsǝtsǝfǝ nga nyi wu dlaɗǝr hyi, abǝr Hyal na, ‘Nayi na, nahyi hyalˈyar ngǝ’ wa? ");
INSERT INTO mfm_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Wu sǝn mǝn abǝr ndǝr tsǝtsǝfǝ nǝ Hyal wu thla fati mai. Ma Thlagǝ na abǝr njira dlǝwuri ndǝr nyi ‘hyalˈyar nga nda,’ ");
INSERT INTO mfm_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ara mi nga hyu ɗa ɗa abǝr yi ndǝr nǝ diɗa Hyal, arya yi na, ‘Zǝr Hyal nga ya’? Nayi ndǝra Tada caɗǝbiya, aga ja sǝwa ɗa a shili wu duniya. ");
INSERT INTO mfm_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ma aˈyi sǝra Dǝɗa wu mǝl nga yu mǝl mai, hya sara hǝnggǝri ǝnga yi mai. ");
INSERT INTO mfm_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ama ma sǝra Dǝɗa wu mǝl nga yu mǝl, alaga nahyi gǝra hǝnggǝri ǝnga yau, hya hǝnggǝri ǝnga sǝ dǝdǝgur kǝra yu mǝl. Lagu kau, nga hyu sǝni ǝnga nggabiya abǝr Dǝɗa wu yau ǝnga nayi wu Dǝɗa.” ");
INSERT INTO mfm_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kǝ ndǝ ɓǝra nǝrdzau aga nda mbar Yesu, ama kǝ ji mbǝliya dzǝ sara wu tsa nda. ");
INSERT INTO mfm_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kǝ Yesu ɓǝra sha a biyar ya dǝl Urdǝnu, a biyar vira Yahwana dzǝguya mǝl baɓǝtizǝma ari. A ndǝna nga ji nda nggya. ");
INSERT INTO mfm_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kǝ nji gangǝu nu nyi a shili. Kǝ ndǝ dumwa ǝnga na, “Alaga kǝ Yahwana aˈyi saya mǝliya sǝ dǝdǝgur kǝ mai kau, ama kalar sǝra ji nana ar kǝra ndǝ kǝ jiri nga nyi patǝu.” ");
INSERT INTO mfm_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ar vi kǝ tsu ngǝ nji gangǝ hǝnggǝri ǝnga Yesu. ");
INSERT INTO mfm_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Vanyi ndǝ aˈyi kǝra nja ngga ǝnga Liyazaru kǝra ɗa gǝra ngga. Naja sara wu mǝlmǝ Bethlani, mǝlmǝ gǝ Maryamu ǝnga kwamǝ nyi Marthla. ");
INSERT INTO mfm_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maryamu kau, kǝra zamǝ nyi Liyazaru gǝra ngga kau, naja ngǝ saya pǝnggǝr nyi mal kisǝ anǝ Thlagǝ ǝnga ji ɓǝsiya hya ja ǝnga shishir kǝra ja. ");
INSERT INTO mfm_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kǝ kwamǝ nyiˈyar sǝwa nyi cama anǝ Yesu, ndǝ na, “Thlagǝu, ndǝ ta gu yiwu ta aˈyi ngga mai.” ");
INSERT INTO mfm_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ənggǝra Yesu nggari abangau, ba ji na, “Shilǝgǝ kǝ wu tsǝya nyi mai, ama aga ja shili ǝnga kadakadarkur anǝ Hyal ǝnga anǝ Zǝr nyi.” ");
INSERT INTO mfm_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ara yiwu dzǝ aˈyi ara Yesu anǝ Maryamu ǝnga Marthla ba zamǝr nda Liyazaru. ");
INSERT INTO mfm_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ama alaga abangau ta ji nggari abǝr Liyazaru aˈyi ngga mai, kǝ ji ɓǝra nggya nǝ pida mǝthlǝ ar vi ta. ");
INSERT INTO mfm_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kǝ ji dzǝgwa na anǝ zǝmbǝlma nyiˈyar, “Bǝgǝ mǝna ɓǝra sha a vu ˈyiˈyir Yahudi.” ");
INSERT INTO mfm_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kǝ zǝmbǝlma nyiˈyar na anǝ nyi, “Malǝmǝ, aˈyi ɓǝliya sar mai ngǝ njir Yahudiya wu gal nda tsi ngau ǝnga tsǝka vavaka, ya, ga ɓǝra yiwu ga sha a vuna tsu ya?” ");
INSERT INTO mfm_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Kǝ Yesu shaɗǝwa nda, “Aˈyi saka kumo apǝ mǝthlǝ ngu pǝkǝ wa? Ndǝ a sǝn thlǝr hi ǝpuci ma ju ɓǝ mai, ara ju lar sǝ camǝ ara mbǝmbǝl nǝ pǝci. ");
INSERT INTO mfm_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kǝl ma ji ɓǝ ǝvuˈyi nga ju thlǝr hi, ara mbǝmbǝl aˈyi mai.” ");
INSERT INTO mfm_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ayukuɗa Yesu nana ndǝrˈyar kau, ba ji dumwa ji na, “Bazhir mǝn Liyazaru a gwari wu ghanyi, ama maˈyi nga yi aga ya nda hyabiya nyi sara wu ghanyi.” ");
INSERT INTO mfm_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Əngwar zǝmbǝlma nyiˈyar anǝ nyi, “Thlagǝu, ma ju ghanyi, ju nda ɗa jamǝu.” ");
INSERT INTO mfm_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Sǝra Yesu wu na abǝr Liyazaru a tǝri, ama ma zǝmbǝlma nyiˈyar wu nggani ghanyi nǝ ɓǝlsar nga ja a gwa. ");
INSERT INTO mfm_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kǝ ji dzǝgwa nar nda ar babal, abǝr, “Liyazaru a tǝri. ");
INSERT INTO mfm_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nyinyi nga yi ǝnga huɗǝ pipida arya aˈyi yi a ndǝna mai, aga hya mbǝrsa. Ama bǝgǝ mǝna maˈyi a ndǝgya ja.” ");
INSERT INTO mfm_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kǝ Toma, ndǝra nju ngga ǝnga ɓili, nar nyi anǝ alenyi zǝmbǝlmaˈyar, “Bǝgǝ mǝna maˈyi mǝna vuwa tǝ ǝnga ja.” ");
INSERT INTO mfm_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ənggǝra Yesu shili, ba ji sa nggari abǝr Liyazaru a pidar ja foɗǝ wu hu. ");
INSERT INTO mfm_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethlani lǝhǝ nga ja wu dzǝr Urshalima, aˈyi kari miyal mǝthlǝ mai. ");
INSERT INTO mfm_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Njir Yahudiya gangǝu ngǝ shili aga nda sa pǝlna pǝli anǝ Marthla ǝnga kwamǝ nyi Maryamu arya tǝr zamǝr nda Liyazaru. ");
INSERT INTO mfm_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ənggǝra Marthla nggari abǝr Yesu a vǝr shili, ba ji maˈyi, ji biya dlǝwuri nyi, ama Maryamu nǝ nyi, ba ji nggya wu ki. ");
INSERT INTO mfm_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Kǝ Marthla nar nyi anǝ Yesu, “Thlagǝu, ma ja abǝr gǝ nda ɗa aˈyi ǝnggau, zamǝ ɗa aˈyi tǝ mai. ");
INSERT INTO mfm_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Alaga kabangǝkau, yu sǝni, abǝr, Hyal wu sǝn nǝ ngau sǝra gu kǝdi ara ja.” ");
INSERT INTO mfm_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Əngwar Yesu anǝ nyi, “Zamǝ ngau wu ɓǝra hyaˈari.” ");
INSERT INTO mfm_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","“Angǝ,” kǝ Marthla shaɗǝwa nyi, “A sǝn yi ju nda hyaˈari ma nji tǝtau, wu nda hyaˈari ar kuɗiyar duniya.” ");
INSERT INTO mfm_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Əngwar Yesu anǝ nyi, “Nayi ngǝ hyaˈari sara vir tau ǝnga nayi ngǝ pi. Kalar ndǝra hǝnggǝri ǝnga yau, ju ɓǝra ɗa aˈyi ǝnga pi alaga ji tau. ");
INSERT INTO mfm_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ndǝra aˈyi ǝnga pi wu yau, ǝnga ji hǝnggǝri ǝnga yau, naji wu tǝ mai. Marthla, a hǝnggǝri gǝ abangǝ ya?” ");
INSERT INTO mfm_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marthla shaɗǝwa nyi, ji na, “Angǝ, Thlagǝu, a hǝnggǝri yi abǝr nagǝ ngǝ Kǝrsiti, Zǝr Hyal kǝra a vǝr shili wu duniya.” ");
INSERT INTO mfm_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ayukuɗa ji nana abangau, ba ji maˈyi a vu ki, ji vuwa nggar kwamǝ nyi Maryamu, ji na anǝ nyi ar ɗǝwa, “Kǝja Malǝmǝ a biya ja vǝr yiwa ngau.” ");
INSERT INTO mfm_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ənggǝra Maryamu nggari abangau, ba ji hyaˈari ǝnga kusa, ji maˈyi a ndǝra ja. ");
INSERT INTO mfm_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ar pǝci kau, tsu Yesu gǝra vu huɗa mǝlmau, tsu ja ar vira Marthla thlǝwa nyi ar ta. ");
INSERT INTO mfm_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ənggǝra njir Yahudiya kǝra a vu ki ǝnga Maryamu ndu fǝ ɗǝfu anǝ nyi lari ǝnggǝra ji biya ǝnga kusa, ba ndǝ nu nyi a biya ma ndu nggani ndar hu nga ja aga nda tiwi a ndǝna. ");
INSERT INTO mfm_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ənggǝra Maryamu biya thlǝwa vira Yesu ari, ba ji dla wu mwa nyi, ji na, “Thlagǝu, ma ja abǝr gǝ nda ɗa aˈyi ǝnggau, zamǝ ɗa aˈyi tǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ənggǝra Yesu lari nyi a vǝr tiwi ǝnga njir Yahudiya kǝra shili ǝnga ja vǝr tiwi tsu, kǝ sǝ kǝ tǝ Yesu wu ɗǝfuwa ja gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Əngwar ja, “Əmani, nga hyi haɗǝna nya?” Əngwar nda anǝ nyi, “Thlagǝu, a ndǝ ga sa lari.” ");
INSERT INTO mfm_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Kǝ Yesu pǝna sǝlǝm. ");
INSERT INTO mfm_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Agabangau, kǝ njir Yahudiya na, “Lara mau ǝnggǝra ju yiwu nyi!” ");
INSERT INTO mfm_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ama kǝ alenyi nju pama nda na, “Naja ndǝra pahǝna liya ndǝ lǝfǝ ta, aˈyi ja ǝnga dǝnama nǝ kar nyi ara tǝ wa?” ");
INSERT INTO mfm_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Kǝ sǝ kǝ ɗa tǝdǝɓǝ anǝ Yesu wu ɗǝfuwa ja, kǝ ji ɓar dzǝ a ndar huwa nyi. Hu kau, thlǝl ngau a vu mau, kǝra nji haɗiya miya nyi ǝnga tsǝka dǝgalǝu. ");
INSERT INTO mfm_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Əngwar Yesu, “Hǝna mǝ tsǝka kau.” Əngwar Marthla kwamiya ndǝ tǝtǝ anǝ nyi, “Ama Thlagǝu, kabangǝkǝ ju shuni kǝrakǝramǝu ara a mǝliyar ja pida foɗǝ wu hu kau.” ");
INSERT INTO mfm_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kǝ Yesu na anǝ nyi, “Aˈyi yi nar ngau abǝr ma gǝ mbǝrsa, gu lari kadakadarkur nǝ Hyal wa?” ");
INSERT INTO mfm_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kǝ ndǝ hǝna tsǝka nyi. Kǝ Yesu tsamǝ dǝmǝlmau, kǝ ji na, “Tada, yu usaku ngau ara a nggar ɗar gau. ");
INSERT INTO mfm_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Wu sǝn yi abǝr gu nggar ɗa cumu, ama yi na abangau aga nji kǝ tataˈyi wu dzǝ ɗa kau, nda hǝnggǝri abǝr nagǝ ngǝ sǝwa ɗa.” ");
INSERT INTO mfm_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ənggǝra ji nana abangau, kǝ Yesu hyaˈana ɗahǝu, ji ngga, “Liyazaru, ɓa sǝbiya!” ");
INSERT INTO mfm_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kǝ ndǝ tǝta nyi sǝbiya, tsa ja ǝnga hya ja mbamba ǝnga paˈwa haɗǝ ndau, ba paˈwa kǝra zǝwar bama ja. Kǝ Yesu na anǝ nda, “Pǝlna nya mau, ja maˈyi sǝ nyi.” ");
INSERT INTO mfm_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Arya sǝ kǝ ɗa kau, njir Yahudiya gangǝu kǝra shili ǝgya Maryamu lari sǝ kǝ Yesu mǝlna kau, ba ndǝ fuwa mbǝrsar nda wu ja. ");
INSERT INTO mfm_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ama kǝ alenyi nju pama nda maˈyi a ndǝgya njir Farisi, ndǝ nda nar nda sǝra Yesu mǝliya. ");
INSERT INTO mfm_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Agabangau, kǝ pubu dǝdǝgalˈyar ǝnga njir Farisi nggǝya daɓǝ nǝ njir pathla. Əngwar nda, “Mi nga mǝna vǝr mǝla? Kǝja ndǝ kau, kǝl dumwa nga mǝl sǝ dǝdǝgur pamǝpamǝ gangǝu. ");
INSERT INTO mfm_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ma mǝn piyari nyi ji dumwa abangau, kalar ndau, wu nda hǝnggǝri ǝnga ja. Njir Roma a dzǝgwa shili nda sa mbǝliya ki Hyalǝr mǝn ǝnga ˈyiˈyir mǝn.” ");
INSERT INTO mfm_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ama kǝ pathlǝ wu pama nda, ndǝra nja ngga ǝnga Kayafasu, ndǝra naja ngǝ pubu kǝra ndiya ǝnga dǝgal wu fa ta, ndǝr, ji na, “Nahyu sǝn sǝra hyu ndǝr ar kǝri mai. ");
INSERT INTO mfm_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","A ɗari tsaˈa vanyi nda tǝ arya nji patǝu, ara nji patǝ a sara sanakǝr, aˈyi hyi nggabiya abangǝ wa?” ");
INSERT INTO mfm_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ndǝr kau, Kayafasu aˈyi nana ǝnga yiwu kǝrnyi mai, ama ar viya pubu kǝra ndiya ǝnga dǝgal wu fa ta nga ji nana sǝra mambǝl cabiya nyi abǝr Yesu wu nda tǝ arya njir Yahudiya, ");
INSERT INTO mfm_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ǝnga aˈyi arya njir Yahudiya wacu mai, ama aga ja kaɓiya wazha Hyal kǝra tǝtǝlnakǝr a ndu duniya, aga nda ɗa nji zǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mbar ar pǝci ta nga ndu gal lagu kǝra nda sǝn tsǝya Yesu. ");
INSERT INTO mfm_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Agabangau, tsu Yesu wu ɓau ar babal wu pama njir Yahudiya mai. Ba ji biya ji maˈyi a ndar vira lǝhǝu wu dzǝr tagǝ mashi, a ndu vanyi zǝr mǝlmǝ kǝra nju ngga ǝnga Ifrayimu, a ndǝna ndǝ nggya ǝkkǝˈyi zǝmbǝlma nyiˈyar. ");
INSERT INTO mfm_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ənggǝra mini nǝ lardur nǝ vǝlbiya a ɗari lǝhǝu, kǝ nji gangǝu hyaˈari sara wu mǝlmǝ yiɗǝɗǝ a du Urshalima aga nda vuwa cina dzǝ ǝnggǝra dlaɗǝ nana kadivira lardur vǝlna. ");
INSERT INTO mfm_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","A vuna, ndǝ dumwa ǝnga gal Yesu, tataˈyi nda a vu ki Hyal, ndu yiyiwa kǝrnda, ndu na, “Mi nga hyu nggana? Ju shili wu mini kǝ ya?” ");
INSERT INTO mfm_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kabangǝkau, pubu dǝdǝgalˈyar ǝnga njir Farisi a fiyar nda ndǝr anǝ nji abǝr kalar ndǝra lari Yesu, nja nar nda ǝnga kusa aga nda mbar nyi. ");
INSERT INTO mfm_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Mini nǝ lardur vǝlbiya a hyiri pida kwa, ngǝ Yesu shili wu Bethlani, mǝlmǝ kǝra Liyazaru a gwa, ndǝra Yesu hyaˈana sara vir tǝ ta. ");
INSERT INTO mfm_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ənggau, nji mǝliya nyi sǝr sǝm nǝ wagǝu. Marthla ngǝ tǝkǝ sǝr sǝm kau, Liyazaru pathlǝ ja wu pama njira vǝr sǝm ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kǝ Maryamu hǝri pǝla nǝ mal kisǝ kǝra nji mǝl sara wu nardu, kǝra nju ɗǝl ǝnga gǝnna gangǝu. Ji sa pǝr nyi ar hya Yesu, kǝ ji ɓǝsiya nyi ǝnga shishir kǝra ja. Kǝ ki kǝra nda a gwa nyi ǝnga shuni ɓurdi kau. ");
INSERT INTO mfm_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ama kǝ pathlǝ sara wu pama zǝmbǝlma nyiˈyar kǝra nju ngga ǝnga Yahuda Isikarayoti, ndǝra wu nda sa thlǝna hya ja, na, ");
INSERT INTO mfm_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Mi ngǝ ɗa nji aˈyi ɗǝlna ɓurdi kǝ ǝnga gǝnna gangǝ (gǝnna nǝ pǝkǝ nǝ nji gharu makǝru) nja nǝ nyi gǝnna nyi anǝ nji ɗaɗali maya?” ");
INSERT INTO mfm_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yahuda na najaka ndǝr aˈyi ara ju yiwu nji ɗaɗali mai, ama ara naja ndǝr hǝl ngau. Naja ngǝ ndǝr sǝɓǝ pǝrki nǝ gǝnna, ǝnga ju dlǝwar kǝrnyi ǝnga sǝra a gwa. ");
INSERT INTO mfm_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Kǝ Yesu na, “Piyari nya mau, ji fiya ɓurdi kǝ aga pǝcir haɗǝ ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Aˈyi hyi ǝkkǝˈyi nji ɗaɗali cumu, ama aˈyi hyi ǝnga yi cumu mai.” ");
INSERT INTO mfm_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Aˈyi ɓǝliya sar mai, kǝ dlamir njir Yahudiya nǝri abǝr Yesu a ndǝna, ba ndǝ shili. Shilir nda aˈyi aga nda lar Yesu wacu mai, ama aga nda lari Liyazaru, ndǝra ji hyaˈana sara vir tǝ ta. ");
INSERT INTO mfm_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kǝ pubu dǝdǝgalˈyar gal lagu kǝra nda sǝn tsǝya Liyazaru ǝtsu. ");
INSERT INTO mfm_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ara arya sǝra ɗa ǝnga Liyazaru ngǝ njir Yahudiya gangǝu shabiya nda yi, ba ndǝ hǝnggǝri ǝnga Yesu. ");
INSERT INTO mfm_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Əzǝgǝkura nyi kǝ dlamir nji gangǝu kǝra dla wu mini kǝ nggari abǝr Yesu a mbar lagu a vu Urshalima. ");
INSERT INTO mfm_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ənggau, kǝ ndǝ ɓǝlǝr hyali hyifa ndǝ maˈyi a biya dlǝwu nyi, ndu wau ndu na, “Fal a ɗari anǝ Hyal!” “Barka anǝ ndǝra dla wu thlǝmǝr Thlagǝu!” “Barka anǝ tǝlǝr njir Izirayila!” ");
INSERT INTO mfm_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ta Yesu uya zǝr kwara, ba ji dari, ǝnggǝra nji tsǝfǝri abǝr, ");
INSERT INTO mfm_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ga sara hivǝr mai, nagǝ culi Sǝhiyona. Kǝja tǝlǝr hyi a vǝr shili, aˈyi nggya a dar ya zǝr kwara.” ");
INSERT INTO mfm_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tanggǝrma zǝmbǝlma nyiˈyar aˈyi nggabiya sǝˈyar kǝ kwatahǝ mai. Ama ayukuɗa kadakadarkur nǝ Yesu nyabiya dzǝ nga ndǝ ɗǝngari abǝr tsǝtsǝfǝ ngǝ sǝˈyar kǝ ar kǝra ja, ǝnga kalar sǝra nji mǝl anǝ nyi aga nyabiya sǝra tsǝtsǝfǝ nga nyi. ");
INSERT INTO mfm_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Njira aˈyi ǝnga ja, ar pǝci kǝra ji ngga Liyazaru sara wu hu ta, ǝnga ji hyaˈana nyi sara a vir tǝ ta, kǝ ndǝ dumwa ǝnga tǝtǝlna sǝra Yesu mǝliya. ");
INSERT INTO mfm_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ca ngǝ sǝra ɗa, nji gangǝu, ndǝ biya ndǝ biya thlǝwa nyi ara ndǝ nggari sǝ dǝdǝgur kǝra Yesu mǝlna. ");
INSERT INTO mfm_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kǝ njir Farisi na anǝ kuvwar nda, “Lara mau, namǝn sǝmku tǝlkur mai, alaga kushu, kǝja patǝr duniya a shari ndu nu nyi!” ");
INSERT INTO mfm_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Wu pama njira shili aga mini kau, alenyi nji aˈyi kǝra njir Gǝrikǝ ngau. ");
INSERT INTO mfm_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ndǝ shili ara Fǝlipǝu, ndǝr Bethlesaida wu Galili, ndǝ sa yiwa nyi, “Malǝmǝ, ˈyi wu yiwu ˈya lar Yesu.” ");
INSERT INTO mfm_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Kǝ Fǝlipǝu maˈyi ji nda nar nyi anǝ Andǝrawusu, nanda mǝthlǝ kǝ ndǝ maˈyi ndǝ nda nar nyi anǝ Yesu. ");
INSERT INTO mfm_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Kǝ Yesu shaɗǝwa nda, ji na, “Pǝci a ɗari kǝra nja kyaga lǝri kadakadarkur anǝ Zǝr Ndau. ");
INSERT INTO mfm_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ənga jiri nga yu na anǝ hyi, ma culi uhi aˈyi tǝɗǝ a gyiwu ˈyi ji ɗiya mai, ju nggya kǝl naja. Ama ma ji ɗiya, ju puwa li, ba ja hǝ kǝr dǝgalǝu. ");
INSERT INTO mfm_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kalar ndǝra wu yiwu piya ja, ju nda tini. Ndǝra gǝra yiwu piya ja wu duniya kau arya yau, ju nda uya pi gǝra kuɗau. ");
INSERT INTO mfm_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kalar ndǝra wu mǝl thlǝr anǝ ɗa, kǝl ja nu ɗa ǝnga jirkur. Vira ya ri a ndǝna ngǝ ndǝr mǝl thlǝr anǝ ɗa tsu. Dǝɗa wu nda nǝ nyi dǝgalkur anǝ ndǝra wu mǝl thlǝr anǝ ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Kabangǝkau, kǝja tǝdǝɓǝ ngǝ ɗǝfuwa yau. Ya, mi nga ya sǝn na? Ya na, ‘Tada, kǝtiya ɗa ara pǝci kǝ ya?’ Awau, aga culi pǝci kǝ nga yi shili ar pǝci kau. ");
INSERT INTO mfm_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tada, nǝ nyi kadakadarkur anǝ thlǝmǝ ngau.” Kǝ ɗahǝu shida sara dǝmǝlmau, “A nǝ nyir yi kadakadarkur anǝ thlǝmǝ ɗa, ǝnga yu ɓǝra nǝ nyi kadakadarkur wayu.” ");
INSERT INTO mfm_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ənggǝra njira tataˈyi a ndǝna nggar ɗahǝ kau, kǝ ndǝ na, “Dlǝɗǝ ngau.” Əngwar alenyi nji, “Waladi ngau, ngǝ ndǝr anǝ nyi.” ");
INSERT INTO mfm_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kǝ Yesu na anǝ nda, “Ɗahǝ kǝ shili aga hyi nga nyi, ama aˈyi aga yi mai. ");
INSERT INTO mfm_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kabangǝkǝ ngǝ pǝcir numa anǝ duniya, kabangǝkǝ nga nju kǝdlǝbiya ndǝr sǝm tǝlkur ar kǝra duniya a biya. ");
INSERT INTO mfm_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ama nayau, ayukuɗa nji hǝr ɗa sara gyiwu ˈyi a dǝmǝlmau, yu nda nggar nji a shili ara kǝrɗa.” ");
INSERT INTO mfm_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu nana abangau aga ja cabiya culi tǝ kǝra ju nda tau. ");
INSERT INTO mfm_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kǝ dlamir nji nar nyi anǝ Yesu, “ˈYi nggabiya wu dlaɗǝ abǝr Kǝrsiti wu ɗa ǝnga pi baˈanuwa. Ya, mi ngǝ ɗa gu na, ‘Kǝl nji hǝr Zǝr Ndau a diya?’ Wa ngǝ Zǝr Ndǝ ka?” ");
INSERT INTO mfm_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Kǝ Yesu shaɗǝwa nda, “Mbǝmbǝl kǝ wu nda nggya ǝnga hyi nǝ pǝci kushu wacu. Ɓa mau ǝnga mbǝmbǝl kǝra aˈyi ara hyi, kadivira kuthla shili. Kalar ndǝra wu ɓau wu kuthlǝu naji wu sǝn vira ju maˈyi a ndari mai. ");
INSERT INTO mfm_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ma mbǝmbǝl kǝ aˈyi tsu ǝnga hyi, hya fuwa mbǝrsar hyu mbǝmbǝla nyi, aga hya ɗa wazha mbǝmbǝl.” Ayukuɗa ji kuɗǝna ndǝr kau, ba ji maˈyi, ji nda mbunakǝr ara nda. ");
INSERT INTO mfm_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Alaga ayukuɗa sǝ dǝdǝgur pamǝpamǝ kǝra Yesu mǝlna wu mwar nda, nandǝ mbǝrsa ǝnga ja mai. ");
INSERT INTO mfm_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Najakǝ ɗarkǝr aga ja nyabiya sǝra nabi Əshaya nana, “Thlagǝu, wa ngǝ hǝnggǝri ǝnga sǝra mǝn nana, ǝnga anǝ wa, ngǝ dǝnama nǝ Thlagǝ cabiya dza?” ");
INSERT INTO mfm_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ca ngǝ mǝliya nandǝ sǝn mbǝrsa mai, ǝnggǝr kǝra nabi Əshaya nana ar vanyi vi, abǝr, ");
INSERT INTO mfm_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ji mǝliya nda ndǝ ɗa lǝfau, “Ji mǝliya ɗǝfuwa nda ɗa ɓaɓalu, Ara nda sara lari sǝ ǝnga liya nda, ǝnga nda nggabiya ǝnga ɗǝfuwa nda, kǝra wu sǝn shabiya nda a shili ara yau, aga ya shilǝgǝbiya nda.” ");
INSERT INTO mfm_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Nabi Əshaya nana abangau, ara ji lari kadakadarkur nǝ Yesu kǝra wu nda cabiya dzau, ǝnga ji ndǝr ar kǝra ja. ");
INSERT INTO mfm_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Alaga abangǝ ma, nji gangǝu mbǝrsa ǝnga Yesu, patǝ ǝkkǝˈyi alenyi njira nggurǝm nǝ Yahudiya. Ama nandǝ sǝn biyar babal mai, ara hivǝr njir Farisi nda sara kǝdlǝbiya nda sara wu umbwa daɓǝ dzǝ njir Yahudiya. ");
INSERT INTO mfm_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ara ndu yiwu fal sara wu miya nji a ndiya sara wu miya Hyal. ");
INSERT INTO mfm_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kǝ Yesu hyaˈana ɗahǝu ji na, “Kalar ndǝra mbǝrsa ǝnga yau, ǝnga yi nga ji mbǝrsa waci mai, ama ǝnga ndǝra sǝwa ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kalar ndǝra wu lar ɗa, ju lari ndǝra sǝwa ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yi shili wu duniya ǝnggǝr mbǝmbǝl, aga kalar ndǝra hǝnggǝri ǝnga yau, tsu ju nggya wu kuthlǝu mai. ");
INSERT INTO mfm_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Kalar ndǝra nggari highiɓǝ ɗa, ama naji ɓǝlari mai, aˈyi nayi ngu nda mǝl numa anǝ nyi mai. Ara nayi aˈyi shili aga sa mǝl numa anǝ duniya mai, ama aga duniya uya mbǝɗau lagu ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ndǝra piyari ɗa, ji nggǝl ara dlǝwu ndǝr ɗa, aˈyi ja ǝnga ndǝra wu nda mǝl numa anǝ nyi. Ndǝr ɗa, kǝra yi nana, naja ngu nda mǝl numa anǝ nyi ar pǝcir kuɗiyar duniya. ");
INSERT INTO mfm_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Sǝra yu na aˈyi sǝ kǝrɗa mai, ama Dǝɗa ndǝra sǝwa ɗa, naja ngǝ nar ɗa sǝra ya na ǝnga ndǝr kǝra yu ndǝr. ");
INSERT INTO mfm_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yu sǝni abǝr ndǝr nyi ngu shili ǝnga pi gǝra kuɗau. Agabangǝ sǝra yu na, sǝra Dǝɗa nar ɗa ya na ngau.” ");
INSERT INTO mfm_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pǝcir mini nǝ lardur nǝ Vǝlna a shiliri lǝhǝu ǝnga Yesu ǝnga kǝrnyi a sǝnbiyari abǝr pǝci nyi a ɗari lǝhǝu aga ja sha a dara dǝnyi. Yesu a cabiyar ja yiwukur nyi anǝ nji nyi wu duniya, kǝl ta ji cabiya nda yiwukur nyi baˈanǝ kuɗiyar piya ja. ");
INSERT INTO mfm_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ar pǝci kǝra Yesu ǝkkǝˈyi zǝmbǝlma nyiˈyar a vǝr sǝm sǝr sǝm nǝ wagǝu, shatan a fuwari wu ɗǝfuwa Yahuda Isikarayoti zǝr Simanu aga ja thlǝna hya Yesu. ");
INSERT INTO mfm_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu wu sǝni abǝr Tada a fuwari kalar sǝ wu tsa ja, ǝnga ju sǝni abǝr sara dǝgya Hyal nga ja, ǝnga tsu a dǝgya Hyal nga ju ɓǝra nda sha. ");
INSERT INTO mfm_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ar pǝci kǝra nda vǝr sǝm sǝr sǝm, kǝ Yesu hyaˈari ji zǝɗǝna lǝgutǝ nyi, ba ji hǝri sǝr bakǝ nyi, ba ji mbiya ar sara ja. ");
INSERT INTO mfm_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ayukuɗa kau, kǝ ji puwa ˈyimi a gwu cala ba ji dzǝguya ci hiya zǝmbǝlma nyiˈyar ǝni. Ju ɗa ɗa hiya nda ǝnga sǝr bakǝ kǝra ji mbiya wu sara ja. ");
INSERT INTO mfm_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kǝ Yesu shili ǝgya Simanu Biturusu, kǝ Biturusu na anǝ nyi, “Thlagǝu, nagǝ ngu ci hiya yi ya?” ");
INSERT INTO mfm_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Əngwar Yesu anǝ nyi, “Nagǝu nggabiya sǝra yu mǝl kabangǝkǝ mai, ama gu nda nggabiya a ndu mwa.” ");
INSERT INTO mfm_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Əngwar Biturusu anǝ nyi, “Awau, nagǝ wu ci hi anǝ ɗa ndangǝ mai.” Kǝ Yesu shaɗǝwa nyi, “Ma nayi aˈyi cina hya gǝ mai, nagǝ aˈyi nǝ ɗa mai.” ");
INSERT INTO mfm_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Əngwar Biturusu anǝ nyi, “Thlagǝu, ma abangǝ ja, aˈyi hiya yi nga ga ci waci mai, ama ga daɓǝri ǝnga tsa yau ba kǝra yau!” ");
INSERT INTO mfm_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Əngwar Yesu anǝ nyi, “Ndǝra a pǝrnar pǝr, a ɗar ja cicau, kǝl ci hi nga ju yiwu wacu ara dza ja patǝ cici nga nyi. Nahyi cici nga hyi, ama aˈyi patǝkura hyi mai.” ");
INSERT INTO mfm_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ara ju sǝni ndǝra wu nda thlǝna hiya ja. Ca ngǝ ɗa, ji na, “Aˈyi papatǝkura hyi ngǝ cici mai.” ");
INSERT INTO mfm_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ayukuɗa ji cina hiya nda patǝu, kǝ ji har lǝgutǝ nyi, ba ji ɓǝra sha a ndar vir nggya nyi. Kǝ ji yiwa nda, ji na, “A nggabiyar hyi sǝra yi mǝliya hyi kǝ ya?” ");
INSERT INTO mfm_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Hyu ngga ɗa Malǝmǝ ǝnga Thlagǝu, kakalǝ nga nyi, ara ca ngǝ sǝra ya ga nyi. ");
INSERT INTO mfm_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ma nayi kǝra Malǝmǝr hyi ǝnga Thlagǝr hyi cina hiya hyi, a kyau nahyi ma hya kyaga cina hiya kuvwar hyi. ");
INSERT INTO mfm_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","A cabiya hyir yi sǝra hya kyaga mǝl, nahyi tsu hya nu hiya yau. ");
INSERT INTO mfm_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Jiri nga yu na anǝ hyi, mafa aˈyi a sǝn ndiya tarki nyi mai, ǝnga ndǝra nji sau ǝnga cama aˈyi a sǝn ndiya ndǝra sǝ nyi mai. ");
INSERT INTO mfm_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ma hya sǝnbiyar najaka jiri, abari ngǝ cacagulikura hyu nda ɗa ma hyi mǝl thlǝr ǝni ya! ");
INSERT INTO mfm_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ar kǝra hyi patǝ nga yu ndǝr mai. Wu sǝn yi njira yi caɗǝbiya. Ama yi caɗǝbiya hyi aga ndǝr Hyal kǝra tsǝtsǝfau a nyabiya dzau, kǝra na, ‘Ndǝra vǝr sǝm sǝr sǝm ɗa ngu gal lagur thlǝ hiya yau.’ ");
INSERT INTO mfm_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nayi ngu na sǝˈyar kǝ kadivira ji ɗarkǝr, aga ma ji nda ɗarkǝr hya sǝni abǝr nayi ngǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Jiri nga yu na anǝ hyi, kalar ndǝra dlǝwuri ndǝra yi sǝwa, nayi nga ji dlǝwuri. Kalar ndǝra dlǝwuri ɗa tsu, ndǝra sǝwa ɗa nga ji dlǝwuri.” ");
INSERT INTO mfm_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ayukuɗa Yesu nana ndǝr kau, kǝ sǝ kǝ ɓwanǝ nyi kǝr wu ɗǝfuwa ja gagaɗau. Kǝ ji cabiya nda ar babal abǝr, “Ənga jiri pathlǝ wu pama hyu nda thlǝna hiya yau.” ");
INSERT INTO mfm_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kǝ zǝmbǝlma nyiˈyar mbar tsatsamǝ kǝrnda, ara nandǝ wu sǝni tara wa nga ju ndǝr ar kǝri kǝ mai. ");
INSERT INTO mfm_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pathlǝ wu pama zǝmbǝlma kǝra Yesu wu yiwu gagaɗau, nggashi ja ar thlǝrpa ja. ");
INSERT INTO mfm_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kǝ Simanu Biturusu guthlar nyi aga ja yiwabiya nda Yesu, “Wa nga ju ndǝr ar kǝri ka?” ");
INSERT INTO mfm_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Naja kǝra lǝha ar dzǝr nyi uzhiya kǝr ju yiwa Yesu, “Thlagǝu, wa nga ja?” ");
INSERT INTO mfm_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Kǝ Yesu shaɗǝwa, “Ndǝra yi kadlǝr macikǝl, yi fuwa a gwu cala, ba yi nǝ nyi, naja ngau.” Kǝ Yesu kadlǝri macikǝl ba ji fuwa a gwu cala ba ji nǝ nyi anǝ Yahuda zǝr Simanu Isikarayoti. ");
INSERT INTO mfm_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ənggǝra Yahuda dlǝwuri macikǝla nyi, ba shatan gu ja. Kǝ Yesu na anǝ nyi, “Sǝra gu yiwu ga mǝl, mǝl ǝnga kusa.” ");
INSERT INTO mfm_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ama wu pama nanda patǝ kǝra a vǝr sǝm sǝr sǝm, ndǝ aˈyi kǝra sǝnbiya sǝra ɗa Yesu na ndǝr kǝ anǝ nyi mai. ");
INSERT INTO mfm_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ta ndu sǝni abǝr naja ngǝ ǝnga mbǝl gǝnnar nda, ma ndu nggani abǝr sǝra Yesu na anǝ nyi, ca ngǝ, ja maˈyi ja nda ɗǝlbiya nda sǝra ndu yiwu aga mini. Ma aˈyi abangǝ tsu mai, ja nǝ nyi anǝ nji ɗaɗali sǝra aˈyi. ");
INSERT INTO mfm_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yahuda tsu, ǝnggǝra ji dlǝwuri macikǝla nyi, ba ji biya maˈyi. Ar pǝci kau, vuˈyi a ɗari. ");
INSERT INTO mfm_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ayukuɗa Yahuda maˈyi a biya, kǝ Yesu na, “Kabangǝkau, nga nju nda nǝ nyi kadakadarkur anǝ Zǝr Ndau, ǝnga Hyal ǝnga kǝrnyi wu nda uya kadakadarkur arya ja. ");
INSERT INTO mfm_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ma Hyal uya kadakadarkur lagu Zǝr nyi, Hyal ǝnga kǝrnyi ngu nda nǝ nyi kadakadarkur tsu anǝ Zǝr nyi ǝnga kusa.” ");
INSERT INTO mfm_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Əngwar ja anǝ nda, “Wazha ɗa, nǝ pǝci kushu nga yi ǝkkǝˈyi hyi wacu. Hyu nda gal ɗa, ama ǝnggǝra yi nar nyi anǝ njira nggurǝm nǝ Yahudiya, abangǝ nga yu na anǝ hyi kabangǝkau, abǝr, ‘Vira yu maˈyi a ndari, nahyi wu sǝn ndǝna mai.’ ");
INSERT INTO mfm_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Dlaɗǝ mafǝliyangǝ nga yu lǝ anǝ hyi, ca ngǝ, hya yiwu kǝrhyi. Ənggǝr kǝra yi yiwu hyi, abangǝ nga hya yiwu kuvwar hyi. ");
INSERT INTO mfm_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Lagu kau, ngǝ nji patǝ wu nda sǝni abǝr nahyi zǝmbǝlma ɗa nga hyi, ma hyu yiwu kuvwar hyi.” ");
INSERT INTO mfm_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simanu Biturusu yiwa nyi, “Thlagǝu, nǝma nga ga?” Yesu shaɗǝwa nyi, “Vira yu maˈyi a ndari, nagǝ wu sǝn nu ɗa kabangǝkǝ mai, ama gu nda nu ɗa a sǝkar kushu.” ");
INSERT INTO mfm_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Əngwar Biturusu anǝ nyi, “Thlagǝu, mi ngǝ ɗa nayi wu sǝn nu ngǝ kabangǝkǝ maya? Yu sǝn lǝri piya yau, arya gau.” ");
INSERT INTO mfm_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Kǝ Yesu shaɗǝwa, ji na, “Gǝ wu sǝn lǝri piya gau arya ya? Yu nar ngǝ jirkura nyi, kadivira vǝgǝmǝ a wau ǝshina, gu nda kǝpalna sǝn ɗa, ar kǝr ar kǝr makǝru.” ");
INSERT INTO mfm_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“A sara huɗa hya ndzǝ mai. Hya hǝnggǝri ǝnga Hyal, ba hya hǝnggǝri ǝnga yi tsu. ");
INSERT INTO mfm_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Wu ki dǝɗa vir nggya aˈyi gangǝu. Ma aˈyi nda ɗa abangǝ mai, yu nda nar hyi. Maˈyi nga ya a ndǝna aga ya da pabǝr hyi vi. ");
INSERT INTO mfm_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ma ya maˈyiri yi da pabǝr hyi vi, yu sha shida aga ya sa faˈari hyi a ndǝgya yau, aga vira ya ri, ǝna nga hyu nggya. ");
INSERT INTO mfm_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Vira yu maˈyi a ndari, hyu sǝn lagur ndǝna.” ");
INSERT INTO mfm_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Kǝ Toma na anǝ Yesu, “Thlagǝu, naˈyu sǝn vira gu maˈyi a ndar kǝ mai, ya abari nga ˈyi wu sǝni laguwa nya?” ");
INSERT INTO mfm_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu shaɗǝwa nyi, ji na, “Nayi ngǝ lagu, nayi ngǝ jiri ǝnga nayi pi. Ndǝr sǝn shili ǝgya Tada aˈyi mai, kǝl lagu ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Maja abǝr hyu sǝn ɗa, hyu sǝn Dǝɗa tsu. Ama mbar kabangǝkǝ hyu nda sǝni nyi ǝnga hyu nda lari nyi.” ");
INSERT INTO mfm_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kǝ Fǝlipǝu na, “Thlagǝu, canǝ ˈya Tada, ba huɗa ˈya pida.” ");
INSERT INTO mfm_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu shaɗǝwa nyi, “Fǝlipǝu, pǝci kǝ yi hǝri ǝnga hyi kau, baˈanǝ kabangǝkǝ nagǝ wu sǝn ɗa mai ya? Kalar ndǝra lar ɗa a lar ja Tada. Abar nga gu sǝn na, ‘Canǝ ˈya Tada ka’? ");
INSERT INTO mfm_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nahyi aˈyi hǝnggǝri abǝr nayi wu Tada, ǝnga Tada wu yi wa? Ndǝr kǝra yu na anǝ hyi, nǝ kǝrɗa ngǝ mai. Ama Tada kǝra a vǝr nggya wu yi nga vǝr mǝl thlǝr nyi. ");
INSERT INTO mfm_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Hya hǝnggǝri ǝnga yau, abǝr nayi wu Tada ǝnga Tada wu yau, aˈyi abangǝ mai hya hǝnggǝri ǝnga yi arya sǝ dǝdǝgur pamǝpamǝ gangǝ kǝra yi mǝlna. ");
INSERT INTO mfm_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Jiri nga yu na anǝ hyi, kalar ndǝra hǝnggǝri ǝnga yau, ju mǝliya thlǝr kǝra yu mǝl tsu. Ju nda mǝliya thlǝr kǝra ndiya kǝra yi mǝl, ara yu maˈyi a dǝgya Tada. ");
INSERT INTO mfm_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ənga yu nda mǝliya kalar sǝra hyu kǝdiyau wu thlǝmǝ ɗa, aga ja dla ǝnga kadakadarkur anǝ Tada lagu Zǝr. ");
INSERT INTO mfm_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kalar sǝra hyu kǝdi wu thlǝmǝ ɗa, yu mǝliya hyi. ");
INSERT INTO mfm_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Maja hyu yiwu ɗa, hyu ɓǝlari dlaɗǝ ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ba ya dzǝgwa kǝdi Tada, aga ja sǝwa hyi vanyi ndǝr dlǝwa dzǝ kǝra wu nggya ǝnga hyi baˈanuwa. ");
INSERT INTO mfm_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Naja ngǝ Mambǝl nǝ jiri, kǝra a vǝr cabiya jirkur ar kǝra Hyal. Duniya wu sǝn dlǝwuri nyi mai, ara nandǝ wu lari nyi mai ǝnga nandǝ wu sǝnbiya nyi mai. Ama nahyi nǝr hyi, hyu sǝnbiya nyi, ara aˈyi ja ǝnga hyi ba ǝnga wu ɗǝfuwa hyi. ");
INSERT INTO mfm_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nayi wu piyari hyi ǝnggǝr mǝsǝtǝ mai, yu sha shili ǝgya hyi. ");
INSERT INTO mfm_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ayukuɗa pǝci kushu, njir duniya wu ɓǝra nda lar ɗa mai, ama nahyi, hyu nda lar ɗa. Ara aˈyi yi ǝnga pi, nahyi ma, hyu ɗa ǝnga pi. ");
INSERT INTO mfm_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ar pǝci ta nga hyu nda sǝnbiya abǝr nayi wu Dǝɗa, nahyi wu yau ǝnga nayi wu hyi. ");
INSERT INTO mfm_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kalar ndǝra dlǝwuri dlaɗǝ ɗa, ba ji ɓǝlari, naja ngǝ ndǝra wu yiwu ɗa. Ndǝra wu yiwu ɗa tsu, Dǝɗa wu nda cabiya nyi yiwukur, nayi tsu yiwu nda yiwu nyi ǝnga yu cabiya kǝrɗa anǝ nyi.” ");
INSERT INTO mfm_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kǝ Yahuda (aˈyi Isikarayoti mai) na anǝ nyi, “Ama Thlagǝu, abar nga ga sǝn canǝ ˈya kǝr, ama aˈyi anǝ njir duniya patǝ maya?” ");
INSERT INTO mfm_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Kǝ Yesu shaɗǝwa nyi, ji na, “Kalar ndǝra wu yiwu ɗa, ju ɓǝlari highiɓǝ ɗa. Dǝɗa tsu ju nda yiwu nyi, ba ˈya shili ˈya sa nggya wu ja. ");
INSERT INTO mfm_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kalar ndǝra gǝra yiwu ɗa, naji wu ɓǝlari highiɓǝ ɗa mai. Ndǝr kǝra hyu nggari yu na, nǝ ɗa ngǝ mai, ama nǝ Dǝɗa ndǝra sǝwa ɗa ngau. ");
INSERT INTO mfm_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Patǝ sǝˈyar kau, yi nar hyi tsu yi ǝnga hyi. ");
INSERT INTO mfm_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ama ndǝr dlǝwa dzau, Mambǝl Cicau, kǝra Dǝɗa wu nda sǝwa wu thlǝmǝ ɗa, ju nda highiɓǝr hyi patǝr sau, ǝnga ju nda ɗǝngar hyi patǝr sǝra yi saya na anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Yu piyari hyi ǝnga huɗǝ pǝrtǝu. Huɗǝ pǝrtǝ ɗa nga yu nǝ hyi. Aˈyi ǝnggǝr kǝra njir duniya wu lǝ nga yu lǝ mai. A sara hya hivǝr mai, ǝnga hya sara piyari huɗa hyi a ndzǝ ǝnga hangǝkala hyi a hyaˈari mai. ");
INSERT INTO mfm_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“A nggar hyi ǝnggǝra yi na, abǝr, ‘Maˈyi nga yau, yu ɓǝra sha shili.’ Ma jiri nga hyu yiwu ɗa, hya caguli, ara yu maˈyi a dara Tada, arya Tada a ndiya ɗa ǝnga dǝgalǝu. ");
INSERT INTO mfm_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yi nar hyi abangau tsu ji gǝra ɗa, aga ma ji ɗarkǝr hya daɓaga hǝnggǝri. ");
INSERT INTO mfm_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Tsu yu ɓǝra nda ndǝr anǝ hyi gangǝ mai, ara ndǝra vǝr sǝm tǝlkur ar kǝra duniya wu shili. Naja aˈyi ǝnga dǝnama ar kǝra yi mai. ");
INSERT INTO mfm_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ya vǝr mǝl patǝr sǝra Tada na ya mǝl, aga njir duniya a sǝni abǝr yu yiwu Tada. Shili a mau, mǝna piyari vi kau.” ");
INSERT INTO mfm_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Nayi ngǝ wur ndǝrma nǝ jijiri, Dǝɗa ngǝ thlagǝr fa. ");
INSERT INTO mfm_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kalar tsa wu kǝra gǝra pǝ wazha ba dǝɗa thlana nyi. Ama kalar tsa wu kǝra wu pǝ wazha, ba dǝɗa tsatsaˈwuna nyi aga ja ɓǝra pǝ wazha gangǝu. ");
INSERT INTO mfm_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kabangǝkǝ cici nga hyi, arya ndǝr ɗa kǝra yi nar hyi. ");
INSERT INTO mfm_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Hya nggya wu yau, nayi tsu wu hyi. Tsa wu aˈyi a sǝn pǝ wazha ar kǝrnyi mai, kǝl ma ji nggya ar mamar wu. Abangǝ tsu nahya ma aˈyi hya sǝn pǝ wazha ar kǝrhyi mai, kǝl ma hyi nggya wu yau. ");
INSERT INTO mfm_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nayi ngǝ wur ndǝrma, nahyi ngǝ tsa nyiˈyar. Kalar ndǝra nggya wu yau ǝnga nayi wu ja, ju pǝ wazha gangǝu. Ma aˈyi wu yi nga hyi mai, sǝ aˈyi hyu sǝn mǝliya mai. ");
INSERT INTO mfm_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kalar ndǝra aˈyi wu nggya wu yi mai, kakalǝ nga ja ǝnga tsa wu kǝra nji thlana, ba ji ulǝnakǝr. Nju sǝn tsǝmiya nda, ba nja puwa a gwu uˈu, ba nja nggyina nda. ");
INSERT INTO mfm_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ma hyi nggya wu yau, ǝnga ndǝr ɗa nggya wu hyi tsu, hyu sǝn yiwa ɗa kalar sǝra hyu cim ba Hyal a nǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Sǝra wu shili ǝnga kadakadarkur anǝ Dǝɗa, ca ngǝ hya pǝ wazha gangǝu. Lagu kǝ nga hyu cabiya abǝr nahyi zǝmbǝlma ɗa ngau. ");
INSERT INTO mfm_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Ənggǝr kǝra Dǝɗa cabiya ɗa yiwukur, abangǝ nga yi cabiya hyi yiwukur tsu. Nahyi tsu hya nggya wu yiwukur ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ma hyi ɓǝlar dlaɗǝ ɗa, hyu nggya wu yiwukur ɗa, ǝnggǝr kǝra yi ɓǝlar dlaɗǝ Dǝɗa, ba yi nggya wu yiwukur nyi tsu. ");
INSERT INTO mfm_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Yi na anǝ hyi abangau aga caguli ɗa a nggya wu hyi, ǝnga aga cagulir hyi a nyabiya dzau. ");
INSERT INTO mfm_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Dlaɗǝ ɗa ca ngǝ, hya yiwu kǝrhyi, ǝnggǝr kǝra yi cabiya hyi yiwukur. ");
INSERT INTO mfm_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Yiwukur kǝra a ndiya patǝu, ca ngǝ nda lǝr piya ja arya bazhi nyiˈyar. ");
INSERT INTO mfm_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nahyi bazhi ɗa ngǝˈyar, ma hyi ɓǝlar dlaɗǝ ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Tsu yu ɓǝra ngga hyi ǝnga mafa mai, ara mafa aˈyi wu sǝn sǝra tarki nyi wu mǝl mai. Ama yu ngga hyi ǝnga bazhi, ara yi canǝ hyi patǝr sǝra yi nggari ara Dǝɗa. ");
INSERT INTO mfm_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nahyi ngǝ caɗǝbiya ɗa mai, ama nayi ngǝ caɗǝbiya hyi, ǝnga yi sǝwa hyi aga hya nda pǝ wazha kǝra wu nggya baˈanuwa. Ba Dǝɗa dzǝgwa nǝ hyi kalar sǝra hyu kǝdiyau wu thlǝmǝ ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kǝja, dlaɗǝ kǝra yi nǝ hyi, hya yiwu kuvwar hyi. ");
INSERT INTO mfm_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ma njir duniya piyari shishir dza hyi, hya sǝni abǝr nayi nga ndǝ piyari shishir dza nyi tanggǝrma. ");
INSERT INTO mfm_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Maja abǝr nǝ njir duniya nga hyi, njir duniya a cabiya hyiri yiwukur. Ama ara kǝ nahyi aˈyi nǝ duniya mai, ǝnga nayi ngǝ caɗǝbiya hyi sara wu duniya, ca ngǝ mǝliya njir duniya piyari shishir dza hyi. ");
INSERT INTO mfm_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Hya ɗǝngari ndǝr kǝra yi saya na anǝ hyi, abǝr, ‘Mafa a sǝn ndiya tarki nyi mai.’ Ma ndǝ nǝ ɗa ɓwaɓwatǝu, ndu nda nǝ hyi ɓwaɓwatǝ tsu. Ma ndǝ mǝl thlǝr ǝnga highiɓǝ ɗa, ndu nda mǝl thlǝr ǝnga nǝr hyi tsu. ");
INSERT INTO mfm_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ndu nda mǝl sǝˈyar patǝ anǝ hyi abangau, arya thlǝmǝ ɗa, ara nandǝ wu sǝni ndǝra sǝwa ɗa mai. ");
INSERT INTO mfm_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ma abǝr aˈyi yi shili, yi sa ndǝr anǝ nda mai, nanda aˈyi njir bikǝ mai. Ama kabangǝkǝ, sǝ aˈyi ndu uya nda na arya bikǝr nda mai. ");
INSERT INTO mfm_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kalar ndǝra piyari shishir dza yau, a piyari ja nǝ Dǝɗa tsu. ");
INSERT INTO mfm_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Maja abǝr aˈyi yi mǝliya wu pama nda sǝra ndǝ aˈyi saya mǝliya mai, nandǝ wu ɗa njir bikǝ mai. Ama kabangǝkau, a lar nda sǝ dǝdǝgur kǝra yi mǝlna, ama alaga abangau, kǝ ndǝ piyari shishir dza yau ǝnga nǝ Dǝɗa tsu. ");
INSERT INTO mfm_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ama sǝ kǝ ɗarkǝr aga ja nyabiya sǝra tsǝtsǝfǝ wu dlaɗǝr nda, abǝr, ‘Ndǝ piyari shishir dza yi gǝra ǝnga sǝra yi ndzana.’ ");
INSERT INTO mfm_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Yi wu nda sǝwa hyi ndǝr dlǝwa dzǝ sara dara Tada. Naja ngǝ Mambǝl jiri kǝra shida sara dara Tada, ju nda sa lǝr sakida ar kǝra yau. ");
INSERT INTO mfm_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nahyi ma, hyu nda lǝr sakida ar kǝra yau, ara tsu tanggǝrma ǝnga yi nga hyi. ");
INSERT INTO mfm_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Yi nar hyi sǝˈyar kǝ patǝu, ara hya sara pǝna mbǝrsar hyi. ");
INSERT INTO mfm_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ndu nda kǝdlǝbiya hyi sara wu umbwa daɓǝ dzǝ njir Yahudiya. Pǝca vǝr shili ma, kǝra ma ndǝ tsǝya hyi, ba nda nggani abǝr thlǝr Hyal nga nda vǝr mǝl. ");
INSERT INTO mfm_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ndu nda mǝl culi sǝˈyar kau, ara nandǝ wu sǝn Tada mai ǝnga nandǝ wu sǝn ɗa mai. ");
INSERT INTO mfm_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ama yi nar hyi sǝˈyar kau, aga ma ndǝ ɗarkǝr, hya daɓaga ɗǝngari abǝr a nar hyir yau. “Nayi nar hyi sǝˈyar kǝ tsu kaɗǝ mai, ara tsu yi ǝkkǝˈyi hyi.” ");
INSERT INTO mfm_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Kabangǝkau, maˈyi nga yi a dǝgya ndǝra sǝwa ɗa, ama wu pama hyi ndǝ aˈyi yiwar ɗa, ‘Nǝma nga gu maˈya?’ ");
INSERT INTO mfm_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Arya yi nar hyi sǝˈyar kau, kǝja hya nyabiyar dzǝ ǝnga huɗǝ ndzǝndzau. ");
INSERT INTO mfm_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ama ya nar hyi jirkura nyi, nahyi ngu ɗahar mǝsahǝkura maˈyi ɗa kau. Ma nayi aˈyi maˈyi mai, ndǝr dlǝwa dzǝ kau, wu shili mai. Ama ma yi maˈyi, yu nda sǝwa hyi nyi a shili ara hyi. ");
INSERT INTO mfm_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ar pǝci kǝra ndǝr dlǝwa dzǝ kǝ shili, ju sa cabiya nyi anǝ njir duniya abǝr ɗǝngar nda ar kǝra bikau, ǝnga tsapǝkur ǝnga numa aˈyi kakalǝ mai. ");
INSERT INTO mfm_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ɗǝngar nda ar kǝra bikau, aˈyi kakalǝ mai ara nandǝ hǝnggǝri ǝnga yi mai. ");
INSERT INTO mfm_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ɗǝngar nda ar kǝra tsapǝkur, aˈyi kakalǝ mai ara maˈyi nga yi a dǝgya Dǝɗa, vira tsu hyu ɓǝra nda lar ɗa mai. ");
INSERT INTO mfm_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ɗǝngar nda ar kǝra numa, aˈyi kakalǝ mai ara a mǝlnar nji numa anǝ ndǝr sǝm tǝlkur ar kǝra duniya. ");
INSERT INTO mfm_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Aˈyi yi ǝnga sǝr na gangǝ kǝra hiyau ya kyaga nar hyi kabangǝkau, ama nahya sǝn sǝsǝˈwuri nda kwatahǝ mai. ");
INSERT INTO mfm_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ama ar pǝci kǝra Mambǝl nǝ jiri shili, ju sa lǝbiya hyi a ndu sǝra jiri patǝu. Naji wu ndǝr wu dǝnamar kǝrnyi mai, sǝra ji nggari nga ju na, ǝnga ju nda nar hyi ar kǝra sǝra a vǝr shili. ");
INSERT INTO mfm_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ju nda shili ǝnga kadakadarkur anǝ ɗa, lagur nar hyi patǝr sǝra ji nggari ara yau. ");
INSERT INTO mfm_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Patǝr sǝra nǝ Dǝɗa, nǝ ɗa ngau. Ca ngǝ sǝra ɗa yi na, abǝr Mambǝl wu nda dlǝwuri sǝra ara yau, ba ja nǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ayukuɗa pida kushu nahyi wu ɓǝra lar ɗa mai, ayukuɗa pida kushu wayu ba hya ɓǝra lar ɗa.” ");
INSERT INTO mfm_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Əngwar alenyi zǝmbǝlma nyiˈyar anǝ kuvwar nda, “Mi nga ju ɗǝnga ǝnga ndǝr ka, ‘Ayukuɗa pida kushu nahyi wu ɓǝra lar ɗa mai, ǝnga ayukuɗa pida kushu ba hya ɓǝra lar ɗa wayu ka’? Ənga tsu mi ngǝ ɗǝnga nyi ǝnga ji na, ‘Ara maˈyi nga yi a dǝgya Dǝɗa ka’?” ");
INSERT INTO mfm_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ndǝ dumwa ǝnga yiwa kǝrnda, “Mi ngǝ ɗǝnga nyi ǝnga ‘ayukuɗa pida kushu ka?’ Namǝn aˈyi nggabiya sǝ kǝ ju na kǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu tsambiya abǝr zǝmbǝlma nyiˈyar ndu yiwu nda yiwa nyi ar kǝra sǝ kau, kǝ ji na anǝ nda, “Hyu yiwa kǝrhyi ar kǝra sǝra yi na, abǝr, ‘Ayukuɗa pida kushu tsu hyu lar ɗa mai, ǝnga ayukuɗa pida kushu ba hya ɓǝra lar ɗa wayu kǝ’ ya? ");
INSERT INTO mfm_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Jiri nga yu na anǝ hyi, hyu nda tiwi, hya pǝ sǝlǝm, ama njir duniya kǝl caguli nga ndu caguli. Hyu nda ndzǝ huɗǝ gagaɗau, ama ndzǝ huɗǝr hyu nda sha aga huɗǝ pipida. ");
INSERT INTO mfm_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ma mala ar tsǝkar ya, ɓwaɓwatǝ nga ja a gwa ara pǝci nyi a ɗari. Ama ma zǝr a biyari, ba ja faˈari ǝnga ɓwaɓwatǝ kǝra ji a gwa, ara huɗǝ pipida nǝ zǝr kǝra shili wu duniya. ");
INSERT INTO mfm_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Abangǝ ngǝ nga nyi ǝnga hyi. Kabangǝkau, pǝcir ndzǝ huɗǝr hyi ngau, ama yu ɓǝra nda lar hyi wayu, ba huɗa hyi a dzǝgwa pida. Huɗǝ pipidar hyi tsu, ndǝr sǝn dlǝwuri ara hyi aˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ar pǝci ta, tsu hyu yiwa sǝ ara yi mai. Yu nar hyi jiri, Dǝɗa wu nda nǝ hyi kalar sǝra hyi yiwa wu thlǝmǝ ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Baˈanǝ kabangǝkau, sǝ aˈyi kǝra hyi yiwa wu thlǝmǝ ɗa mai. Yiwa mau, ba nja nǝ hyi, aga huɗǝ pipidar hyi a nyabiya dzau. ");
INSERT INTO mfm_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Yi ndǝr anǝ hyi ǝnga karapǝ aga ya nar hyi sǝˈyar kau, ama pǝci wu shili tsu yu nda ndǝr ǝnga karapǝ mai ama yu ndǝr ar kǝra Dǝɗa ar babal. ");
INSERT INTO mfm_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Wu pǝci ta, hyu nda kǝdi sǝ wu thlǝmǝ ɗa. Nahyi ngu nda kǝdi Dǝɗa ǝnga kǝrhyi aˈyi nayi nga kǝdi anǝ hyi mai. ");
INSERT INTO mfm_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ara Dǝɗa ǝnga kǝrnyi wu yiwu hyi ara hyi cabiya ɗa yiwu dzǝ ǝnga hyi hǝnggǝri naja ngǝ sǝwa ɗa a shili. ");
INSERT INTO mfm_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yi shili wu duniya sara ara Tada, kabangǝkǝ piyari nga yi duniya, ya ɓǝra sha a dǝgya Tada.” ");
INSERT INTO mfm_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kǝ zǝmbǝlma nyiˈyar na anǝ nyi, “Ənghǝng! Kabangǝkau, nga gu ndǝr ar babal gǝra ǝnga karapau. ");
INSERT INTO mfm_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kabangǝkau, nga ˈyi wu sǝni abǝr sǝ aˈyi ɗǝɗǝwa anǝ ngǝ mai. Gu sǝn nar nyi anǝ ndau, sǝra ju yiwu ja yiwa ngau. Kau, a mǝliya ri ˈyi hǝnggǝri, ǝnga jiri sara ara Hyal nga gau.” ");
INSERT INTO mfm_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Kǝ Yesu shaɗǝwa nda, ji na, “Kabangǝkau, a hǝnggǝri hyi ǝnga nyi ya?” ");
INSERT INTO mfm_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pǝca vǝr shili, kǝja a ɗari, kǝra kalar ndu nda tǝtǝlnakǝr, ba kalar ndǝ a hwinakǝr a vu ki nyi, ba hya piyari ɗa zhizhi ɗa. Ama alaga abangau, aˈyi yi zhizhi ɗa jijiri mai, ara Tada aˈyi ja ǝnga yau. ");
INSERT INTO mfm_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Yi wu na sǝˈyar kǝ anǝ hyi ara wu yi nga hyu uya huɗǝ pǝrtǝu. Wu duniya kǝ hyu nda lar ɓwaɓwatǝu, ama hya sǝsǝˈwuri ara a sǝmkur yi tǝlkur ar kǝra duniya.” ");
INSERT INTO mfm_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ayukuɗa Yesu nana ndǝrˈyar kau, kǝ ji hyaˈanakǝr a dǝmǝlmǝ ji kǝdi Hyal, ji na, “Tada, pǝci a ɗari. Ga nǝ nyi kadakadarkur anǝ Zǝr ngau, aga naja tsu ja shili ǝnga kadakadarkur anǝ ngau. ");
INSERT INTO mfm_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ara gǝ nǝ nyi dǝnama anǝ Zǝr ngau ar kǝra nji patǝu, aga ja lǝr pi gǝra kuɗau anǝ patǝr njira gǝ nǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Pi gǝra kuɗau, ca ngǝ nja sǝn ngau, nagǝ kǝra Hyal nǝ jijiri wacu, ǝnga Yesu Kǝrsiti, ndǝra gǝ sǝwa a shili. ");
INSERT INTO mfm_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Yi dla ǝnga kadakadarkur anǝ ngau wu duniya lagur mǝlna thlǝr kǝra gǝ nǝ ɗa aga ya mǝl. ");
INSERT INTO mfm_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kabangǝkau, Tada, nǝ ɗa kadakadarkur kabangǝkǝ wu mwa ngau, culi kadakadarkur kǝra aˈyi yi ǝni ǝnga gǝ ta kadivira duniya ɗarkǝr. ");
INSERT INTO mfm_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“A cabiya ngǝr yi abǝr wa nga ga anǝ njira gǝ nǝ ɗa wu duniya. Njira ɗǝɗǝmǝ nǝ ngǝ nga nda, ama ba gǝ nǝ ɗa nda, nanda tsu a ɓǝlar nda ndǝr ngau. ");
INSERT INTO mfm_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kabangǝkau, wu sǝn nda abǝr kalar sǝra aˈyi ara yau, sara ara gǝ nga nyi. ");
INSERT INTO mfm_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ara kalar ndǝr kǝra gǝ nar ɗa, a nar ndar yau, ba ndǝ dlǝwuri. Ənga jiri ndu sǝni abǝr sara ara gǝ nga yau, ǝnga a hǝnggǝr nda abǝr nagǝ ngǝ sǝwa ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ya vǝr kǝdiyau, arya nda. Nayau, aˈyi a vǝr kǝdiyau, arya duniya patǝ mai, ama arya njira gǝ nǝ ɗa, ara nǝ ngǝ nga nda. ");
INSERT INTO mfm_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Patǝr njira ara yau, nǝ ngǝ ngau, ǝnga tsu patǝr njira ara gau nǝ ɗa ngau. A uyar yi kadakadarkur lagur nda. ");
INSERT INTO mfm_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kabangǝkau, ya vǝr sha a da ara gau, ara pǝcir nggya ɗa wu duniya a kuɗǝri, ama nanda, tsu nda wu duniya. Tada, Ndǝ Cicau, ga kǝtiya nda ǝnga dǝnamar thlǝmǝ ngau, thlǝmǝ ngau kǝra gǝ nǝ ɗa, aga nda ɗa zǝmǝ ǝnggǝr kǝra ma ǝnga gau. ");
INSERT INTO mfm_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ar pǝci kǝra yi tsu ǝnga nda, yi kǝtiya lagur dǝnamar thlǝmǝ ngau, thlǝmǝ ngau kǝra gǝ nǝ ɗa. A ɓǝlar ndar yau, ndǝ aˈyi kǝra sa wu pama nda mai, kǝl ndǝ sasa ta aga ndǝr Hyal a nyabiya dzau. ");
INSERT INTO mfm_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Kabangǝkau, kǝja ya vǝr sha a da ara gau, ama yu na sǝˈyar kǝ tsu yu duniya aga njir nu ɗa nda nyabiya dzǝ ǝnga caguli wu ɗǝfuwa nda. ");
INSERT INTO mfm_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","A nǝ ndar yi cama ngau, ba njir duniya piyari shishir dza nda, ara nanda aˈyi nǝ duniya mai, ǝnggǝr kǝ nayau, aˈyi yi nǝ duniya mai. ");
INSERT INTO mfm_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nayi kǝdiyau, aga ga faˈabiya nda sara wu duniya mai, ama aga ga kǝtiya nda ara ndǝ ɗǝmwaˈyi kau. ");
INSERT INTO mfm_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nanda aˈyi nǝ duniya mai, ǝnggǝr kǝ nayi aˈyi yi nǝ duniya mai kau. ");
INSERT INTO mfm_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ga cina nda lagur jiri, ndǝr ngau jiri ngau. ");
INSERT INTO mfm_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ənggǝr kǝra gǝ sǝwa ɗa a shili wu duniya, abangǝ nga yi sǝwa nda a ndu duniya tsu. ");
INSERT INTO mfm_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Arya nda nga yi lǝr kǝrɗa, aga thlǝr cici kau, aga nanda tsu nda ɗa cicau lagu jirkur. ");
INSERT INTO mfm_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Kǝdi ɗa aˈyi anǝ nda waci mai, ama anǝ kalar njira wu nda hǝnggǝri ǝnga yi lagur camar nda. ");
INSERT INTO mfm_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tada, kǝdi ɗa, bǝgǝ nda ɗa zǝmǝu, ǝnggǝr kǝra ma ǝnga gau. Bǝgǝ nda ɗa zǝmǝ wu ma, aga njir duniya a sǝni abǝr nagǝ ngǝ sǝwa ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","A nǝ ndar yi kadakadarkur kǝra gǝ nǝ ɗa, aga nda ɗa zǝmǝ ǝnggǝr kǝra ma zǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yu nda nggya wu nda, ǝnga nagǝ tsu wu yau, aga nda ɗa zǝmǝ ǝnga jiri. Lagu kǝ ngǝ njir duniya wu nda sǝni abǝr nagǝ ngǝ sǝwa ɗa, ǝnga nda sǝni gu yiwu nda ǝnggǝr kǝra gu yiwu ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tada, cim ɗa, ca ngǝ njira gǝ nǝ ɗa, nda nggya ǝnga yi ar vira ya ri. Yu cim nda lari kadakadarkur ɗa, kadakadarkur kǝra gǝ nǝ ɗa arya gu yiwu ɗa kadivira gǝ mǝliya duniya. ");
INSERT INTO mfm_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tada, ndǝ tsapǝu, njir duniya wu sǝni ngǝ mai, ama nayau, yu sǝn ngau ǝnga nanda nǝr nda, ndu sǝni abǝr nagǝ ngǝ sǝwa ɗa. ");
INSERT INTO mfm_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","A cabiya ngǝr yi anǝ nda ǝnga yu nda dumwa ǝnga ca ngau anǝ nda. Lagu kǝ ngǝ yiwu kǝra gu yiwu ɗa wu nda nggya wu nda ar babal, ǝnga nayi ǝnga kǝrɗa wu nda nggya wu nda.” ");
INSERT INTO mfm_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ayukuɗa Yesu kuɗǝna kǝdi Hyal, ba ji tǝrabiya ǝkkǝˈyi zǝmbǝlma nyiˈyar a biyar ya dagǝ Kiduronu. A biyar ya dagǝ kau, vanyi masǝmǝ aˈyi, ba Yesu ǝkkǝˈyi zǝmbǝlma nyiˈyar maˈyi a vuwa gwa. ");
INSERT INTO mfm_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yahuda, zǝmbǝlma Yesu kǝra thlǝna hiya ja wu sǝn vi kau, ara Yesu ǝkkǝˈyi zǝmbǝlma nyiˈyar wu yiɗaga daɓǝ dzǝ a gwa. ");
INSERT INTO mfm_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kǝ Yahuda shili wu masǝmǝ kau, ji dumwa ji ca lagu anǝ bwata sojaˈyar, ǝnga njir ɓǝla ki Hyal kǝra pubu dǝdǝgalˈyar ǝnga njir Farisi sǝwa. Ndǝ shili ǝnga uˈur tǝsǝ ba pitǝlla ǝnga kar pa. ");
INSERT INTO mfm_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu, ara ju sǝni sǝra wu nda ɗa ǝnga ja, ba ji biya, ji biya yiwa nda, “Wa nga hyu gala?” ");
INSERT INTO mfm_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kǝ ndǝ shaɗǝwa nyi, ndǝ na, “Yesu ndǝ sara wu Nazǝratu.” Əngwar Yesu anǝ nda, “Nayi ngau.” Yahuda ndǝra thlǝna hiya Yesu aˈyi ja tataˈyi ǝkkǝˈyi nda. ");
INSERT INTO mfm_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ənggǝra Yesu na, “Nayi ngau,” ba ndǝ sha dǝ ndǝl dǝ ndǝl, ba ndǝ dlanakǝr a gyiwu ˈyi. ");
INSERT INTO mfm_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kǝ Yesu ɓǝra yiwa nda, ji na, “Wa nga hyu gala?” Əngwar nda, “Yesu ndǝr Nazǝratu.” ");
INSERT INTO mfm_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Əngwar Yesu anǝ nda, “A nar hyir yi abǝr nayi ngau. Ma nayi nga hyu gal, hya piyari nji kau, nda maˈyi.” ");
INSERT INTO mfm_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Sǝkǝ ɗarkǝr aga ja nyabiya ndǝr kǝra ji nana, “Nayi aˈyi tini alaga ndǝ zǝmǝ wu njira gǝ nǝ ɗa mai.” ");
INSERT INTO mfm_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simanu Biturusu ndǝra aˈyi ǝnga katsakǝr ara ja, ba ji tsǝbiya katsakǝr nyi, ba ji thlana himi mazǝma mafa nǝ pubu kǝra ndiya ǝnga dǝgalǝu. Thlǝmǝr mafa kǝ ca ngǝ Malkusu. ");
INSERT INTO mfm_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kǝ Yesu nar nyi anǝ Biturusu, “Shabiya katsakǝr ngau a gwu ki nyi. Aˈyi kyau ya tǝwari sara wu kyakiwa nǝ ɓwaɓwatǝ kǝra dǝɗa nǝ ɗa kǝ wa?” ");
INSERT INTO mfm_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kǝ bwata sojaˈyar ta ǝnga dǝgalǝr nda, daɓǝ ǝnga njir ɓǝla ki Hyal mbar Yesu, ba ndǝ mbiya nyi. ");
INSERT INTO mfm_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tanggǝrma, ba ndǝ hǝr nyi a ndǝgya Anasu, ara naja sǝlku sal nǝ Kayafasu. Wu fa ta, Kayafasu ngǝ pubu kǝra ndiya ǝnga dǝgalǝu. ");
INSERT INTO mfm_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafasu ngǝ lǝr sawara anǝ njira nggurǝm nǝ Yahudiya abǝr a ɗari tsaˈa ndǝ zǝmǝ a tǝ arya nji. ");
INSERT INTO mfm_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Kǝ Simanu Biturusu ǝnga pathlǝ wu pama zǝmbǝlma nǝ Yesu ndu nu Yesu wu ndǝl wu ndǝl. Ara pubu kǝra ndiya ǝnga dǝgal wu sǝni najaka zǝmbǝlma nǝ Yesu, ba ji piyari nyi aga ja vu huɗǝ ki nǝ pubu kǝra ndiya ǝnga dǝgal ǝnga Yesu. ");
INSERT INTO mfm_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ama Biturusu nǝ nyi ba ji taˈyi a biya miya ki, a biya. Kǝ zǝmbǝlma kǝra pubu kǝra ndiya ǝnga dǝgal kǝ wu sǝni kau, biya ji biya ndǝr anǝ kwa kǝra a vǝr ɓǝla miya ki, ba ji vu ǝnga Biturusu. ");
INSERT INTO mfm_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kǝ kwa ɓǝla miya kiya nyi, na anǝ Biturusu, “Nagǝ ma, pathlǝ gau wu pama zǝmbǝlma nyi, ǝndǝga?” Kǝ ji shaɗǝwa, ji na, “Awau, nayi a gwa mai.” ");
INSERT INTO mfm_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ara shishiˈwu kǝra vi, agabangǝ kǝ mafaˈyar ǝkkǝˈyi njir ɓǝla ki Hyal mbǝbiya uˈu tataˈyi nda, ndu ɗaha. Biturusu tsu aˈyi ja wu pama nda taˈyu ju ɗaha uˈu. ");
INSERT INTO mfm_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kǝ pubu kǝra ndiya ǝnga dǝgal yiwa miya Yesu ar kǝra zǝmbǝlma nyiˈyar ǝnga highiɓǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Kǝ Yesu shaɗǝwa nyi, ji na, “Ndǝr ɗa, ar babal nga yi na anǝ nji patǝu, yi highiɓǝ wu umbwa daɓǝ dzǝ njir Yahudiya ǝnga wu ki Hyal vira daɓǝ nǝ njir Yahudiya ari ar babal. Sǝ aˈyi kǝra yi na ɗǝɗǝwa mai. ");
INSERT INTO mfm_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mi ngǝ ɗa gu yiwa miya ya? Yiwa miya njira nggar sǝra yi na. A nggabiyar nda sǝra yi nana.” ");
INSERT INTO mfm_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ənggǝra Yesu nana abangau, kǝ vanyi ndǝr ɓǝla ki Hyal kǝra lǝha dzǝr nyi nǝ nyi tsǝbalma, ǝngwar ja anǝ nyi, “Abangǝ nga nju ndǝr anǝ pubu kǝra ndiya ǝnga dǝgal ya?” ");
INSERT INTO mfm_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu shaɗǝwa nyi, ji na, “Ma yi nana sǝra aˈyi tsaˈa mai ba ga cabiya ɗa, ama ma yi nana sǝra tsaˈa, mi ngǝ ɗa gǝ dǝgǝ ɗa?” ");
INSERT INTO mfm_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kǝ Anasu sǝwa nyi mbamba a ndǝgya Kayafasu ndǝra naja ngǝ pubu kǝra ndiya ǝnga dǝgalǝu. ");
INSERT INTO mfm_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ma tsu Simanu Biturusu taˈyi ar vi ta, ja vǝr ɗaha uˈu, kǝ nji yiwa nyi, “Nagǝ ma pathlǝ gu pama zǝmbǝlma nyi ya, ǝndǝga?” Kǝ ji kǝpalna, ji na, “Nayi a gwa mai.” ");
INSERT INTO mfm_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pathlǝ wu pama mafa nǝ pubu kǝra ndiya ǝnga dǝgalǝu, kǝra zamǝya ndǝ ta Biturusu thlana himiya ja ta, ka na anǝ nyi, “Mi nga gu na ka? Aˈyi gǝ pathlǝ wu pama njira yi lari nyi ǝnga ja wu masǝmǝ ta wa?” ");
INSERT INTO mfm_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kǝ Biturusu ɓǝra kǝpalna, ǝnggǝrna kǝ vǝgǝmǝ wau. ");
INSERT INTO mfm_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Əmudlǝ kaɗǝ kǝ njira nggurǝm nǝ Yahudiya lǝbiya Yesu sara wu ki Kayafasu a ndar pathla nǝ gwamna nǝ Roma. Kǝ ndǝ nggǝl ara vu pathla nyi ara nda sara ɗa diyadiyaɓǝu ba ja kar nda ara sǝm lardur nǝ vǝlna. ");
INSERT INTO mfm_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Agabangau, kǝ Bilatusu biya thlǝwa nda a biya, ba ji yiwa, “Mi ngǝ vazǝ kǝra hyi shili ǝni a miya ndǝla ndǝ ka?” ");
INSERT INTO mfm_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kǝ ndǝ shaɗǝwa nyi, ndǝ na, “Maja abǝr ndǝ kau, aˈyi ndǝ vavazǝ mai, naˈyu shili ǝnga ja ǝnggǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Əngwar Bilatusu anǝ nda, “Hǝr nya mau hya nda mǝliya nyi numa ar kǝrhyi ǝnggǝra dlaɗǝr hyi nana.” Əngwar njir Yahudiya anǝ nyi, “Nji aˈyi nǝ ˈya dǝnama nǝ thla numa nǝ tǝ anǝ ndǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Sǝkǝ ɗarkǝr aga ja nyabiya sǝra Yesu nana ar kǝra culi tǝ kǝra ju nda tau. ");
INSERT INTO mfm_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kǝ Bilatusu sha a vu pathla, kǝ ji ngga Yesu, ji yiwa nyi, “Ɗǝm ya, nagǝ ngǝ tǝl nǝ njir Yahudiya ya?” ");
INSERT INTO mfm_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu shaɗǝwa nyi, ji na, “Sara ara gau ngǝ ndǝr kǝ hyaˈari ya, ǝndǝga nji ngǝ ndǝr anǝ ngau ar kǝra yi ya?” ");
INSERT INTO mfm_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Əngwar Bilatusu anǝ nyi, “Ndǝr Yahudiya yi ya? Aˈyi nji gǝ hyi ǝnga pubu dǝdǝgalˈyar ngǝ shili ǝnga gǝ ǝnggǝ wa? Mi gǝ mǝliya?” ");
INSERT INTO mfm_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu shaɗǝwa nyi, “Tǝlkur ɗa, aˈyi ǝnggǝr nǝ duniya mai. Maja abǝr tǝlkur ɗa ǝnggǝr nǝ duniya, njir mǝl thlǝr ɗa ndu pa ba nda kar njir Yahudiya ara mbar ɗa. Ama pakatǝu, tǝlkur ɗa sara ar vi pamǝ nga nyi.” ");
INSERT INTO mfm_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Əngwar Bilatusu anǝ nyi, “Ɗǝm ya, tǝl nga gǝ ya?” Kǝ Yesu shaɗǝwa, ji na, “Kakalǝ nga nyi, ǝnggǝr kǝra gǝ na, tǝl nga yau. Sǝra ɗa nji yabiya ɗa, ǝnga sǝra yi shili wu duniya aga nyi, aga ya nana sǝra jiri. Kalar ndǝra wu yiwu jiri, ju sǝ himi sǝra yu na.” ");
INSERT INTO mfm_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Bilatusu yiwa miya Yesu, ji na, “Mi ngǝ jira nya?” Kǝ Bilatusu ɓǝra biya a biya ǝgya njir Yahudiya, ji biya na anǝ nda, “Nayi thlǝwa nyi ǝnga vazǝ mai. ");
INSERT INTO mfm_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ama a ɗari sǝr cijir hyi aga ya sǝya hyi ndǝr fursǝna pathlǝ wu lardur vǝlna kau. Hyu yiwu ya sǝya hyi ‘Tǝlǝr njir Yahudiya’ ya?” ");
INSERT INTO mfm_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kǝ ndǝ ɓǝra shaɗǝwa nyi, ndu wau ndu na, “Awau, naja mai. Sǝya ˈya Barabasu.” (Ama ja hya sǝni, Barabasu ndǝr ɗalagu ngau.) ");
INSERT INTO mfm_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kǝ Bilatusu sǝwa nji nǝ nyi wuɗa anǝ Yesu. ");
INSERT INTO mfm_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kǝ sojaˈyar mǝliya dara shikǝɗi nǝ tǝlkur ba ndǝ har nyi anǝ Yesu. Kǝ ndǝ har nyi lǝgutǝ tuwara dǝzǝu kǝra ǝnggǝr nǝ tǝlkur. ");
INSERT INTO mfm_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ndǝ shili ǝgya ja, ar kǝr ar kǝr ndu na anǝ nyi, “Ənga barka ngau, ciwar, tǝlǝr njir Yahudiya!” Ba ndǝ nǝ nyi tsǝbalma. ");
INSERT INTO mfm_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Kǝ Bilatusu ɓǝra biya a biya ǝgya njir Yahudiya, ji biya na anǝ nda, “Kǝja yu biya ǝnga ja, ara yu yiwu hya sǝni abǝr nayi thlǝwa nyi ǝnga vazǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ənggǝra Yesu biya ǝnga dara tǝlkur nǝ shikǝɗi a dar kǝra ja ǝnga lǝgutǝ tuwara dǝzǝu, kǝ Bilatusu na anǝ nda, “Kǝja nda nyi!” ");
INSERT INTO mfm_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ta pubu dǝdǝgalˈyar ǝnga njir ɓǝla ki Hyal lari nyi, ba ndǝ hyaˈana ɗahǝu, ndu na, “Dlakǝya nyi! Dlakǝya nyi!” Ama kǝ Bilatusu shaɗǝwa nda, ji na, “Hǝr nya mau hya nda dlakǝya nyi sǝr hyi, arya nayi lari bikǝ nyi mai.” ");
INSERT INTO mfm_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Əngwar njir Yahudiya anǝ nyi, “Dlaɗǝr ˈya aˈyi, kǝra na a ɗar tsaˈa nja dlakǝya ndǝ kau, ja tau, ara ji hǝr kǝrnyi ar viya Zǝr Hyal.” ");
INSERT INTO mfm_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ənggǝra Bilatusu nggar ndǝr kau, ba hivǝr nyi cakau. ");
INSERT INTO mfm_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ba ji ɓǝra sha a vu huɗa pathla, ji vuwa yiwa Yesu, ji na, “Sara mani nga gǝ shila?” Ama Yesu aˈyi shaɗǝwa nyi mai. ");
INSERT INTO mfm_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Agabangau, ǝngwar Bilatusu anǝ nyi, “Gǝ nggǝl ara ndǝr anǝ ɗa ya? Aˈyi gu sǝni abǝr aˈyi yi ǝnga dǝnama nǝ sǝya ngau, ǝnga nǝ dlakǝya ngǝ wa?” ");
INSERT INTO mfm_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Kǝ Yesu shaɗǝwa nyi, ji na, “Dǝnama kǝra aˈyi ara gǝ ar kǝra yau, dǝnama kǝra Hyal nǝngǝ ngǝ wacu. Agabangau, ndǝra fuwa ɗa wu tsa gǝ nga ndiya ngǝ ǝnga bikau.” ");
INSERT INTO mfm_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ar kǝra ndǝr kǝ ngǝ Bilatusu wu yiwu ja sǝya Yesu, ama kǝ njir Yahudiya hyaˈana ɗahǝu ndu na, “Ma gǝ sǝya nyi ji maˈyi, nagǝ aˈyi bazhiya Kayisaru mai. Kalar ndǝra wu yiwu ja mǝliya kǝrnyi ar viya tǝl, dawa Kayisaru nga ja.” ");
INSERT INTO mfm_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ənggǝra Bilatusu nggari ndǝr kau, ba ji hǝbiya Yesu a biya, ji biya nggya ar sǝr nggya nǝ pathla ar vira nji pǝdlǝya ǝnga tsǝka. Kǝra nju ngga ǝnga miya njir Yahudiya Gabathla. ");
INSERT INTO mfm_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pǝci kau, pǝci taˈyi kǝr, pǝci kǝra nju fǝ sǝ wu lagu nju vu sugu nǝ lardur nǝ vǝlbiya. Əngwar Bilatusu anǝ njir Yahudiya, “Kǝja mǝ tǝlǝr hyi!” ");
INSERT INTO mfm_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ama kǝ ndǝ hyaˈana ɗahǝu ndu na, “Tsǝya nyi! Tsǝya nyi! Dlakǝya nyi!” Kǝ Bilatusu yiwa nda, ji na, “Ya dlakǝya hyi tǝlǝr hyi ya?” Kǝ pubu dǝdǝgalˈyar shaɗǝwa, ndǝ na, “Vanyi tǝl aˈyi ara ˈya mai, kǝl tǝl Kayisaru.” ");
INSERT INTO mfm_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Agabangau, kǝ Bilatusu hǝri Yesu ji nǝr nyi anǝ njir Yahudiya aga nda dlakǝya nyi. Kǝ sojaˈyar maˈyi ǝnga Yesu. ");
INSERT INTO mfm_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu biya sara wu huɗa mǝlmǝ ja vǝr hǝ wu dladlakǝ nyi a ndar vira nja ngga ǝnga vir papangǝkǝr. Ənga miya njir Yahudiya nju ngga viya nyi ǝnga Gwalgwathla. ");
INSERT INTO mfm_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ar vi kǝ nga nji dlakǝya Yesu, ǝnga nji mǝthlǝu, pathlǝ lagu mazǝma ja, ǝnga vanyi ndǝ lagu matsala ja. ");
INSERT INTO mfm_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bilatusu tsǝfǝr sau, ba ji pathlǝri ar wu dladlakau. Kǝja sǝra ji tsǝfǝri, “Yesu ndǝr Nazǝratu, Tǝlǝr njir Yahudiya.” ");
INSERT INTO mfm_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ara ji dlakǝya Yesu lǝhǝu wu dzǝr mǝlmau, ba mǝliya njir Yahudiya gangǝu jigana sǝra nji tsǝfǝri kau. Sǝra ji tsǝfǝri, ji tsǝfǝri wu miya njir Yahudiya, ǝnga miya njir Roma ba ǝnga miya njir Gǝrikǝu. ");
INSERT INTO mfm_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kǝ pubu dǝdǝgalˈyar nǝ njir Yahudiya nar nyi anǝ Bilatusu, “Ga sara tsǝfǝ Tǝlǝr Njir Yahudiya mai, ama ga na, ǝngwar ndǝ kau, naja ǝngwa ngǝ Tǝlǝr njir Yahudiya.” ");
INSERT INTO mfm_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Əngwar Bilatusu anǝ nda, “Sǝra yi tsǝfǝri a tsǝfǝr yau.” ");
INSERT INTO mfm_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ayukuɗa sojaˈyar kǝ dlakǝya Yesu, ba ndǝ faˈari kar ha nyi, ndǝ tǝkǝya bwata foɗǝu, kǝ kalar soja hǝri bwata pathlǝu. Ndǝ ɓǝra hǝri lǝgutǝ dzǝgamǝ nyi kǝra aˈyi nji mbǝ mai, ama tsa nga nji tsa mbari a du kǝr baˈa a gyiwu ndǝl. ");
INSERT INTO mfm_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kǝ ndǝ na wu pama nda, “Mǝna sara ta lǝgutǝ kǝ mai, ama mǝna tǝɗǝ shiˈwu a miya ndǝla nyi mǝna lari ndǝra wu sǝmku.” Sǝˈyar kǝ ɗarkǝr aga ja nyabiya sǝra tsǝtsǝfau wu lǝkakaɗǝ nǝ Hyal kǝra na abǝr, “Ndǝ tǝkǝya kar ha ɗa wu pama nda, ndǝ tǝɗǝ shiˈwu ar kǝra lǝgutǝ ha ɗa.” Ya kǝja sǝra sojaˈyar kǝ mǝliya ngau. ");
INSERT INTO mfm_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tataˈyi lǝha dzǝr wu dladlakǝ nǝ Yesu, ca ngǝ mǝnyi ǝnga kwamǝ nyi ǝnga Maryamu mala Kǝliyopasu ba Maryamu Magǝdaliya. ");
INSERT INTO mfm_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ənggǝra Yesu lari mǝnyi a ndǝna ǝnga zǝmbǝlma kǝra ju yiwu ta tataˈyi lǝha dzǝr nyi, kǝ ji na anǝ mǝnyi, “Ama, kǝja zǝr ngau.” ");
INSERT INTO mfm_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Əngwar ja anǝ zǝmbǝlma kau, “Kǝja mǝ ngau.” Ənggǝ ngǝ zǝmbǝlma kǝ hǝr nyi a ndu ki nyi. ");
INSERT INTO mfm_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu, ayukuɗa ji sǝnbiya abǝr kalar sǝ a kuɗǝri, aga sǝra tsǝtsǝfau a nyabiya dzau, kǝ ji na, “Hili wu tǝ ɗa.” ");
INSERT INTO mfm_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ar pǝci kau, bǝlari aˈyi ǝna kǝra nyinyau ǝnga ˈyimi mwamwalu. Kǝ ndǝ ciwa sasaˈu a gwu ˈyimi mwamwala nyi, ba ndǝ ciri ar zǝwa ba ndǝ fuwa a du miya Yesu. ");
INSERT INTO mfm_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ənggǝra ji tǝwari, ǝngwar Yesu “A kuɗǝri.” Ayukuɗa kǝ ba ji uzhiya kǝr, ba ji tau. ");
INSERT INTO mfm_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pǝci kau, pǝcir fǝ sǝ wu lagu nǝ pǝcir Ɓǝlsar ngau, ǝnga ǝzǝgǝkura nyi tsu pǝcir Ɓǝlsar kǝra pamǝ ara alenyi ngau. Agabangau, njir Yahudiya aˈyi wu yiwu nda piyari dza nda a dar wu dladlakǝ ar pǝci ta mai. Ba ndǝ yiwa Bilatusu aga ja piyari nda, nda ɓǝɓǝlna hiya nda aga kusar tǝr nda, ba nda hǝya dza nda sara dar wu dladlakǝr nda, ba ji nǝ nda lagu. ");
INSERT INTO mfm_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kǝ sojaˈyar shili ndǝ sa ɓǝɓǝlna hiya ndǝ tanggǝrma kǝra nji dlakǝya ǝnga Yesu, ba ndǝ mǝliya nyi anǝ ndǝ nǝ mǝthlǝkura nyi tsu. ");
INSERT INTO mfm_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ama ǝnggǝra ndǝ shili ǝgya Yesu, nandǝ ɓǝɓǝlna hiya ja mai, ara divira nda shili a tǝr ja. ");
INSERT INTO mfm_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kǝ pathlǝu, wu pama sojaˈyar kǝ tsaviya Yesu ar thlǝrpa ja ǝnga katsakǝr, ba mashi daɓǝ ǝnga ˈyimi ndzǝndzǝ sara a gwa. ");
INSERT INTO mfm_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ndǝra sǝkǝ ɗa wu liya ja, ngǝ lǝr sakida kau, sakida nyi jiri nga nyi. Naja ǝnga kǝrnyi wu sǝni abǝr sǝra ju na, jiri nga nyi, ǝnga ji lǝri sakida kau, aga nahyi tsu hya hǝnggǝri. ");
INSERT INTO mfm_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Sǝˈyar kǝ ɗarkǝr aga nyabiya sǝra tsǝtsǝfau wu lǝkakaɗǝ Hyal, “Alaga ɗǝhiya ja zǝmǝu, nju ɓǝlna mai.” ");
INSERT INTO mfm_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Vanyi ndǝr Hyal kǝra tsǝtsǝfǝ na, “Ndǝ wu nda tsamǝ ndǝra ndǝ tsaviya.” ");
INSERT INTO mfm_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","A yukuɗu, kǝ Yusufu ndǝr Arimatiya naja ma zǝmbǝlma Yesu ngau, ama ar ɗǝwa, ara hivǝr njira nggurǝm nǝ Yahudiya. Ji sa yiwa Bilatusu aga ja nǝ nyi dza Yesu, kǝ ji nǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Yusufu maˈyi ǝnga Nikodimosu, ndǝra sǝ aˈyi shili ǝgya Yesu uvuˈyi ta. Nikodimosu maˈyi ǝnga muru gwagwaɗau ǝnga alosu kǝra sǝ kisǝ ar viya tsǝla pathlǝu. ");
INSERT INTO mfm_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kǝ nanda kǝ mǝthlǝ kau, maˈyi ka nda hǝri, kǝ ndǝ pǝɗiya dza Yesu wu sǝr haɗǝ ndau, daɓǝ ǝnga sǝ kisǝ kau, ǝnggǝra njir Yahudiya wu haɗǝ ndau. ");
INSERT INTO mfm_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Lǝha dzǝr vira nji dlakǝya nyi ar kau, vanyi fa wu aˈyi. Wu fa wu kau, hu mafǝliyangǝ aˈyi kǝra nji gǝra sǝ aˈyi haɗǝna ndǝ a gwa. ");
INSERT INTO mfm_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ta ɗa pǝcir fǝ sǝ wu lagu nǝ njir Yahudiya ngau, ba tsu huwa nyi lǝhǝ nga nyi, ba ndǝ haɗǝna dza Yesu wu huwa nyi. ");
INSERT INTO mfm_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kaɗǝ ǝmudlau, ma tsu vi dlǝdlǝrǝu, ar pǝci nǝ tanggǝrma nǝ sugu, kǝ Maryamu Magǝdaliya maˈyi a nda tsamǝ huwa nyi. Ma ji nda ba ji lari kǝja nja jahǝnar tsǝka haɗǝ miya huwa nyi. ");
INSERT INTO mfm_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kǝ ji sha ǝnga hwi a ndǝgya Simanu Biturusu ǝnga vanyi zǝmbǝlma kǝra Yesu wu yiwu ta. Kǝ ji na anǝ nda, “A hǝr nji dza Thlagǝ sara wu huwa nyi, kǝja naˈya sǝni vira nji fiya nyi ari mai.” ");
INSERT INTO mfm_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kǝ Biturusu ǝnga vanyi zǝmbǝlma ta biya ndǝ mbar lagu ndar huwa nyi. ");
INSERT INTO mfm_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Gyapǝ nda mbar hwi, ama kǝ vanyi zǝmbǝlma ta ndiya Biturusu ǝnga hwi a ndar huwa nyi. ");
INSERT INTO mfm_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ji nda uzhiya dzau, ju tsamǝ gwu huɗa huwa nyi, ba ji lari kar haɗǝ ndau a gwu huwa nyi, ama naji gwu huwa nyi mai. ");
INSERT INTO mfm_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kǝ Simanu Biturusu ndǝra a gyiwu yukuɗǝ nyi shili a miya huwa nyi, ba ji tǝrabiya a gwu huwa nyi, ba ji gwa lari kar haɗǝ ndau a guna. ");
INSERT INTO mfm_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Kǝ ji ɓǝra lari zhaɓi kǝra nji mbuya bama Yesu ǝni a gwu huwa nyi pǝpǝɗau lagu batiti. ");
INSERT INTO mfm_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kǝ zǝmbǝlma ta shili a miya huwa nyi a ndiya Biturusu ta maˈyi a gwu huwa nyi tsu. Ənggǝra ji gwa lari ba ji hǝnggǝri abǝr jiri nga nyi. ");
INSERT INTO mfm_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Baˈanǝ kabangǝkǝ nanda aˈyi nggabiya sǝra tsǝtsǝfau wu lǝkakaɗǝ abǝr kǝl Yesu hyaˈari sara vir tǝ mai. ");
INSERT INTO mfm_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kǝ zǝmbǝlmaˈyar kǝ sha a ndu ki. ");
INSERT INTO mfm_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maryamu nǝ nyi taˈyi a miya huwa nyi ja vǝr tiwi. Tsu ja vǝr tiwi, ba ji uzhau, ju tsamǝ gwu huɗa huwa nyi. ");
INSERT INTO mfm_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Maja vǝr tsamǝ, ba ji lari waladiˈyar mǝthlǝ wu kar pǝrtǝ ngganggashiu ar vira nji pina dza Yesu ar ta. Waladi pathlǝ a vǝr nggya a dar vir kǝra ja ǝnga vanyi tsu a gyar vir hiya ja. ");
INSERT INTO mfm_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kǝ waladiya nyiˈyar yiwa nyi ndǝ na, “Mala, mi ngǝ ɗa gwu tiwi ya?” Əngwar ja, “A hǝnar nda Thlagǝ ɗa sara ǝnggau, ya, nayi wu sǝni vira ndǝ hǝna nyi a ndar mai.” ");
INSERT INTO mfm_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ənggǝra ji kuɗǝna na abangau, ba ji shabiya dzau, ba ji lari Yesu taˈyi a ndǝna, ama naji tsamǝ ri abǝr Yesu ngǝ mai. ");
INSERT INTO mfm_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Kǝ Yesu yiwa nyi, ji na, “Mala, mi ngǝ ɗa gwu tiwi ya? Wa nga gu gala?” Ma ju nggani abǝr ndǝr mǝl thlǝr wu fa wu ta ngau, ǝngwar ja anǝ nyi, “Malǝmǝ, ma nagǝ ngǝ hǝr nyi sara ǝnggau, nar ɗa vira gǝ fiya nyi ari, aga ya nda hǝr nyi.” ");
INSERT INTO mfm_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Kǝ Yesu ngga nyi, ji na, “Maryamu.” Ji shabiya dzǝ a ndara ja, ji na ǝnga miya njir Yahudiya, “Rabwani!” (Kǝra ca ngǝ Malǝmǝ.) ");
INSERT INTO mfm_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Əngwar Yesu anǝ nyi, “Ga sara mba ɗa mai, ara tsu yi gǝra sha a da ara Tada kwatahǝu. Ama ga maˈyi a ndara zamǝɗaˈyar ga nda nar nda, sha nga yi a dara Dǝɗa ǝnga Dǝrhyi, ba a dǝgya Hyal ɗa ǝnga Hyalǝr hyi.” ");
INSERT INTO mfm_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kǝ Maryamu Magǝdaliya maˈyi, ji nda nar nyi anǝ zǝmbǝlma nyiˈyar, “A lar yi Thlagǝu!” Kǝ ji nar nda sǝra Yesu nar nyi. ");
INSERT INTO mfm_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Əwagǝu pǝci tanggǝrma nǝ sugu, ar pǝci kǝra zǝmbǝlmaˈyar nǝ Yesu kaɓau ar vi zǝmǝu. Ndǝ haɗiya miya ki ara hivǝr njira nggurǝm nǝ Yahudiya. Ma tsu nda a vuna, kǝja Yesu taˈyu wu hada nda, ji na, “Jamǝkur ja nggya ǝnga hyi.” ");
INSERT INTO mfm_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ayukuɗa ji nana ndǝr kau, kǝ ji canǝ nda tsa ja ǝnga thlǝrpa ja. Kǝ zǝmbǝlma nyiˈyar nyabiya dzǝ ǝnga huɗǝ pipida ara ndǝ lari Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kǝ Yesu ɓǝra na anǝ nda, “Jamǝkur ja nggya ǝnga hyi! Ənggǝr kǝra Tada sǝwa ɗa, abangau ǝnga yu sǝ hyi.” ");
INSERT INTO mfm_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ənggǝra ji nana abangau, ba ji sǝna pi a nda gǝra nda, ji na, “Dlǝwara mau Mambǝl Cicau. ");
INSERT INTO mfm_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kalar ndǝra hyi tǝfǝbiya nyi bikǝ nyi a tǝfǝbiya nyir nji bikǝ nyi, abangǝ tsu, kalar ndǝra hyi nggǝl ara tǝfǝbiya nyi bikǝ nyi a nggyari abangau.” ");
INSERT INTO mfm_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toma (ndǝra nju ngga ǝnga ɓili), pathlǝ wu pama nda kumo apǝ mǝthlǝu, aˈyi ja ma Yesu shili ara zǝmbǝlma nyiˈyar mai. ");
INSERT INTO mfm_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kǝ alenyi zǝmbǝlmaˈyar kǝ na anǝ nyi, “A lar ˈya Thlagǝu!” Ama ǝngwar Toma anǝ nda, “Ma nayi aˈyi lari mǝcavǝɗi nǝ kusa ar tsa ja mai, ǝnga yi fuwa tsa yi a vu vira kusa ar ta mai, ǝnga yi fuwa tsa yi a vu thlǝrpa ja mai, nayi wu hǝnggǝri ǝni mai.” ");
INSERT INTO mfm_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ayukuɗa sugu pathlǝ ǝtsu, zǝmbǝlma nyiˈyar ɓǝra tsǝmiya dzǝ wu ki, ar pǝci kǝ Toma aˈyi ja ǝkkǝˈyi nda. Miya ki dǝdǝl nga nyi, ama kǝ Yesu shili ji sa taˈyi wu pama nda ji na, “Jamǝkur ja nggya ǝnga hyi.” ");
INSERT INTO mfm_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kǝ ji na anǝ Toma, “Fǝr kuˈyir tsa gǝ ǝnggau, ga tsamiya tsa yau. Hǝr tsa gau ga fiya a vu thlǝrpa yau. Piyari tǝkǝkǝr ga ɗa ndǝra ǝnga mbǝrsa.” ");
INSERT INTO mfm_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Əngwar Toma anǝ nyi, “Thlagǝ ɗa ǝnga Hyal ɗa!” ");
INSERT INTO mfm_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu shaɗǝwa nyi, “Ara gǝ lar ɗa nga gǝ hǝnggǝri ya? Njir barka ngǝ njira gǝra lar ɗa ama kǝ ndǝ hǝnggǝri ǝnga yau.” ");
INSERT INTO mfm_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu mǝliya sǝ dǝdǝgurˈyar pamǝpamǝ gangǝu wu liya zǝmbǝlma nyiˈyar, kǝra nji aˈyi tsǝfǝri wu lǝkakaɗǝ kǝ mai. ");
INSERT INTO mfm_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ama nji tsǝfǝri najakau, aga hya hǝnggǝri abǝr Yesu ngǝ Kǝrsiti, Zǝr Hyal, ǝnga tsu aga ja ɗa lagur mbǝrsa ba hya uya pi lagur thlǝmǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ayukuɗa sǝˈyar kau, kǝ Yesu ɓǝra canǝ nyi kǝr anǝ zǝmbǝlma nyiˈyar ar miya dǝl Tiberiyasu. Kǝja ǝnggǝra ji ɗarkǝr. ");
INSERT INTO mfm_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simanu Biturusu ǝnga Toma (ndǝra nju ngga ǝnga ɓili) ǝnga Nathlaniyalu sara wu mǝlmǝ Kana wu Galili ǝnga wazha Zabadi ǝnga alenyi zǝmbǝlma mǝthlǝ ngǝ a ndǝna. ");
INSERT INTO mfm_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Əngwar Biturusu anǝ nda, “Maˈyi nga ya nda tǝm.” Əngwar alenyi nji kau, “Naˈya ma ˈyi wu maˈyi ǝnga gau.” Kǝ ndǝ biya ndǝ biya gwu kwambwal ba ndǝ maˈyi. Ama pǝci ta vuˈyi sǝ aˈyi ndǝ mbar mai. ");
INSERT INTO mfm_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kaɗǝ mudlǝ ǝnggǝra vi kuɗau, kǝja Yesu taˈyi a miya dǝl, ama zǝmbǝlma nyiˈyar tsamǝ ri abǝr naja ngǝ mai. ");
INSERT INTO mfm_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kǝ Yesu na anǝ nda, “Bazhi ɗaˈyar, aˈyi hyi ǝnga kalfi wa?” Əngwar nda anǝ nyi, “Awau.” ");
INSERT INTO mfm_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kǝ Yesu na anǝ nda, “Vakuwa mǝ litagǝr hyi a ndar lagu mazǝma kwambwal kau, ba hya uya nda.” Ta ndǝ mǝliya ǝnggǝra ji na, ba ndǝ mbar kalfi gangǝ gagaɗau, kǝra ɗa dzadzau anǝ nda, nda tǝɗǝbiya a du kwambwala nyi. ");
INSERT INTO mfm_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kǝ zǝmbǝlma ta Yesu wu yiwu ta na anǝ Biturusu, “Thlagǝ ngau!” Ənggǝra Simanu Biturusu nggari ndǝr kau, abǝr, “Thlagǝ ngau,” kǝ ji hǝri lǝgutǝ nyi ji hari ara ɗǝɗǝmǝu tursǝ nga ja. Kǝ ji dzǝgwa vǝl a gwu ˈyimiya nyi. ");
INSERT INTO mfm_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Alenyi zǝmbǝlma nyiˈyar maˈyi a ndar dza dǝl a gwu kwambwalǝr nda, nda a vǝr tǝtǝɗǝ litagǝr nda nyinyau ǝnga kalfi. Ar pǝci ta nanda aˈyi naɗǝ sara miya dǝl mai. Pama nda wu ɗa ǝnggǝr hyi gharu makǝru. ");
INSERT INTO mfm_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ənggǝra ndǝ biya a miya dǝl, ba ndǝ thlǝwa ǝvunyi mbǝmbǝ ǝnga uˈu ǝnga kalfi a dari ba ǝnga macikǝl tsu. ");
INSERT INTO mfm_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Əngwar Yesu anǝ nda, “Gǝri a mau kalfi kǝra hyi mbari a shili ǝnggau.” ");
INSERT INTO mfm_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kǝ Simanu Biturusu maˈyi a dar kwambwal, ju tǝɗǝ litagǝu a biya miya dǝl. Litagǝ kǝ nyinyi nga nyi ǝnga kalfi nggunggurǝm gharu ǝnga tǝfu kumunyi apǝ makǝru. Ama alaga kǝ litaga nyi nyinyi ǝnga kalfi, aˈyi tanakǝr mai. ");
INSERT INTO mfm_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Kǝ Yesu na anǝ nda, “Shili a mau hya sa sǝm sǝr sǝm nǝ mudlau.” Wu pama zǝmbǝlma nyiˈyar ndǝ aˈyi kǝra cinapi ji yiwa nyi, ji na, abǝr, “Wa nga ga” mai, ara ndu sǝni abǝr Thlagǝ ngau. ");
INSERT INTO mfm_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ba Yesu hyaˈari ji hǝri macikǝla nyi, ba ji nǝ nda ǝnga kalfiya nyi tsu. ");
INSERT INTO mfm_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Najakǝ ngǝ nǝ makǝrkura nyi, ǝnggǝra Yesu canǝ kǝr anǝ zǝmbǝlma nyiˈyar ayukuɗa ji hyaˈari sara vir tau. ");
INSERT INTO mfm_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ənggǝra ndǝ kuɗǝna sǝm sǝr sǝm nǝ mudlau, kǝ Yesu nar nyi anǝ Simanu Biturusu, “Simanu zǝr Yahwana, ǝnga jiri nga gu yiwu ɗa a ndiya sǝˈyar kǝ ya?” Kǝ Biturusu shaɗǝwa nyi, ji na, “Angǝ, Thlagǝu, gu sǝni yu yiwu ngau.” Əngwar Yesu anǝ nyi, “Sǝmǝna wazha tǝmahǝ ɗaˈyar kau.” ");
INSERT INTO mfm_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kǝ Yesu ɓǝra na anǝ nyi, “Simanu zǝr Yahwana, ǝnga jiri nga gu yiwu ɗa ya?” Kǝ ji shaɗǝwa, ji na, “Angǝ, Thlagǝu, gu sǝni abǝr yu yiwu ngau.” Əngwar Yesu anǝ nyi, “Ɓǝla tǝmahǝ ɗaˈyar.” ");
INSERT INTO mfm_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu ɓǝra na anǝ nyi nǝ makǝrkura nyi, “Simanu zǝr Yahwana, gu yiwu ɗa ya?” Ba sǝ kǝ ndzana huɗa Biturusu arya Yesu yiwa nyi ar kǝr ar kǝr makǝru, “Ənga jiri gu yiwu ɗa ya?” Əngwar ja anǝ nyi, “Thlagǝu, gu sǝn sǝ patǝu. Gu sǝni abǝr yu yiwu ngau.” Əngwar Yesu anǝ nyi, “Sǝmǝna tǝmahǝ ɗaˈyar. ");
INSERT INTO mfm_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Jiri nga yu na anǝ ngau, pǝci kǝra gǝ tsu zǝr, nagǝ ngu ha kar anǝ kǝrngau, ba ga maˈyi a ndar vira gu yiwu. Ama ma gǝ nda hal, gu nda ha tsi anǝ nji aga nda har ngǝ kar ba nda dzǝgwa hǝr ngau a ndar vira gǝ gǝra yiwu.” ");
INSERT INTO mfm_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu nana abangau aga cabiya culi tǝ kǝra Biturusu wu nda tau, kǝra wu dla ǝnga kadakadarkur anǝ Hyal. Kǝ ji na anǝ nyi, “Nu ɗa.” ");
INSERT INTO mfm_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Biturusu shabiya dzǝ ji tsamǝ gyiwu yukuɗu, ba ji lari zǝmbǝlma ta Yesu wu yiwu ta a vǝr nu nda. Najakǝ ngǝ zǝmbǝlma ta tǝghǝr dzǝ ar dza Yesu pǝci kǝra nda a vǝr sǝm sǝr sǝm nǝ lardur nǝ vǝlna ǝnga ji na anǝ Yesu, “Thlagǝu, wa ngu nda thlǝna hiya ga?” ");
INSERT INTO mfm_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ənggǝra Biturusu lari nyi, kǝ ji yiwa Yesu, ji na, “Thlagǝu, kar ndǝ kǝ tsu, mi ngǝ nǝ nya?” ");
INSERT INTO mfm_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Kǝ Yesu shaɗǝwa nyi, “Ma yu yiwu ja ɗa aˈyi ǝnga pi kǝl yi sha shili, mi ngǝ dzau nga? Nagǝ, kǝl ga nu ɗa?” ");
INSERT INTO mfm_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Agabangau, kǝ ndǝr kǝ tǝtǝlnakǝr wu pama njir nu Yesu, abǝr zǝmbǝlma kǝ wu tǝ mai. Ama Yesu aˈyi na abangǝ mai. Sǝra ji na ca ngǝ, “Ma yu yiwu ja nggya ǝnga pi kǝl yi shili, mi ngǝ dzau nga?” ");
INSERT INTO mfm_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Najakǝ ngǝ zǝmbǝlma kǝra lǝri sakida ar kǝra sǝˈyar kǝ patǝu, ǝnga ji tsǝfǝr nda. Mǝn wu sǝni abǝr sakida nyi jiri nga nyi. ");
INSERT INTO mfm_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ama alenyi sǝ pamǝpamǝ gangǝ aˈyi kǝra Yesu mǝlna. Maja abǝr nji tsǝfǝri patǝr sǝra ji mǝlna, duniya ǝnga kǝrnyi a sǝn hǝri lǝkakaɗa nyi mai.");
INSERT INTO mfm_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Cama tsǝtsǝfǝ sara ara Bulusu, ndǝra Hyal ngga aga ja ɗa cama sǝsǝ nǝ Kǝrsiti Yesu lagur yiwu huɗa nǝ Hyal, ǝnga zamǝr mǝn Sosithlanisu, ");
INSERT INTO mfm_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","a nda nǝ daɓǝ dzǝ njir nu kǝra a vu Kwaranthli, njira nji ngga aga nda ɗa nji cici wu Kǝrsiti Yesu, ǝnga njira nji thlǝbiya wu Kǝrsiti Yesu, daɓǝ ǝnga kalar nji kǝra ar kalar vi kǝra wu ngga thlǝmǝr Thlagǝ Yesu Kǝrsitir mǝn, Thlagǝr nda ǝnga Thlagǝr mǝn. ");
INSERT INTO mfm_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Bǝgǝ mayiwakur ǝnga huɗǝ pǝrtǝu sara ara Hyal Dǝrmǝn ǝnga Thlagǝ Yesu Kǝrsiti nda nggya ǝnga hyi. ");
INSERT INTO mfm_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Parangǝ nga ya vǝr lǝ usaku anǝ Hyal arya hyi, arya mayiwakur nyi kǝra ji lǝr hyi wu Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Arya wu ja a ɗar hyi njir bǝrba wu kalar sau, kalar sǝra hyu na ǝnga kalar sǝnbiya sǝr hyi. ");
INSERT INTO mfm_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Arya najaka bǝrbakur, a cabiyari abǝr, kalar sakida kǝra ˈyi lǝri arya Kǝrsiti jiri nga nyi. ");
INSERT INTO mfm_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Agabangau, nahyu ghari sǝ lǝlǝ nǝ Mambǝl mai, ǝnggǝr kǝra hya vǝr nggyar tsatsam lagu nǝ sǝkǝ shilǝr Thlagǝr mǝn Yesu Kǝrsiti kǝra wu nda cabiya dzau. ");
INSERT INTO mfm_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Yesu wu nda sǝɓiya ngǝ aga ga ɗa nǝnau baˈanǝ shili ar jomǝ ndǝl, aga ga ɗa ndǝ gǝra vazau ar pǝcir shidar Thlagǝr mǝn Yesu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Hyal, naja ndǝra ngga hyi a shili wu nggya nǝ daɓǝ dzǝ ǝnga zǝr nyi Yesu Kǝrsiti Thlagǝr mǝn, naja ndǝ tsaˈa miya ɗǝfu ngau. ");
INSERT INTO mfm_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Ya vǝr kǝdi hyi wazha ama wu thlǝmǝr Thlagǝr mǝn Yesu Kǝrsiti, hya sara ca pamǝpamǝkur mai, ama hya dlunggǝri ǝnga kuvwar hyi, aga miya hyi ǝnga ɗǝngar hyi a ɗa zǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Yu na anǝ hyi abangǝ wazha ama, arya alenyi nji sara wu ki Kǝlowusu nar ɗa abǝr hyu pǝpa wu pamǝ. ");
INSERT INTO mfm_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Sǝra yu na, ca ngǝ alenyi nji wu pama hyu na, “Nayi nǝɗa yu nu Bulusu,” alenyi nju na, “Nayi nǝɗa yu nu Apolusu,” alenyi nji tsu ndu na, “Nayi nǝɗa yu nu Kefasu,” ǝnga alenyi nji tsu ndu na, “Naˈya nǝr ˈya ˈyu nu Kǝrsiti.” ");
INSERT INTO mfm_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Karya, Kǝrsiti a tǝkǝbiyar dzǝ ya? Əndǝga nji dlakǝya Bulusu arya hyi ya? Əndǝga nji hǝr hyi baɓǝtizǝma wu thlǝmǝr Bulusu ya? ");
INSERT INTO mfm_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Yu usaku anǝ Hyal, ara aˈyi nayi ngǝ hǝ baɓǝtizǝma anǝ ndaliya hyi mai, kǝl anǝ njir ki Kǝrispusu ǝnga Gayisu. ");
INSERT INTO mfm_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Kabangǝkau, ndǝr sǝn na abǝr yi hǝr nyi baɓǝtizǝma wu thlǝmǝ ɗa aˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Jiri, a ɓǝra ɗǝngar yi vanyi sau, abǝr a hǝr nyir yi baɓǝtizǝma anǝ njir ki Sǝtifanusu. Ayukuɗa nyi tsu nayi ɓǝra ɗǝngari ndǝra yi ɓǝra hǝr nyi baɓǝtizǝma mai. ");
INSERT INTO mfm_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Ara Kǝrsiti aˈyi sǝwa ɗa aga ya hǝ baɓǝtizǝma anǝ nji mai, ama aga ya tǝtǝlna ndǝshigu nyi, aˈyi ǝnga ndǝr nǝ hahangǝkur ndǝndǝkur ɗa mai, a sara dǝnama nǝ wu dladlakǝ nǝ Kǝrsiti a ɗa sǝ tǝtǝwa. ");
INSERT INTO mfm_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Arya cama nǝ ndǝr nǝ mbǝɗau lagu wu dladlakau, dzakur ngau anǝ njira sasa, ama anǝ mǝn njira uya mbǝɗau, dǝnama nǝ Hyal ngau. ");
INSERT INTO mfm_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Arya tsǝtsǝfǝ nga nyi, “Yu nda sana hahangǝkur nǝ nji hahangǝu, ǝnga sǝnbiya sǝ nǝ njir sǝn sǝ tsu, yu nda mǝliya wu ɗa sǝ kurthlǝu.” ");
INSERT INTO mfm_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Əmani ngǝ nji hahanga? Əmani ngǝ njir sǝnbiya sa? Ənga ǝmani ngǝ njir jigadǝma? Hyal aˈyi mǝliya hahangǝkur nǝ njir duniya ɗa aga dzakur wa? ");
INSERT INTO mfm_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Arya Hyal lagu hahangǝkur nyi nga ji mǝliya njir duniya gǝra sǝnbiya nyi lagu hahangǝkurǝr nda. Ama ba ji mǝliya lagu dzakur nǝ tǝtǝlna ndǝr Hyal ca ngǝ njira hǝnggǝri uya mbǝɗau. ");
INSERT INTO mfm_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Njir Yahudiya wu gal lar sǝ dǝdǝgur, njir Gǝrikǝu nǝr nda, ndu gal hahangǝkur. ");
INSERT INTO mfm_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Ama naˈya ˈyu tǝtǝlna ndǝr Kǝrsiti ndǝra nji dlakǝya, kǝra ɗa sǝr thlǝ hi anǝ njir Yahudiya, ǝnga sǝ dzakur anǝ njira aˈyi njir Yahudiya mai. ");
INSERT INTO mfm_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Ama anǝ nji kǝra Hyal ngga, tara njir Yahudiya ǝnga tara njir Gǝrikǝu, Kǝrsiti ca ngǝ dǝnama nǝ Hyal ǝnga hahangǝkur nǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Ara dzakur nǝ Hyal a ndiya hahangǝkur nǝ ndau, kukufǝkur nǝ Hyal tsu a ndiya nǝnǝkur nǝ ndau. ");
INSERT INTO mfm_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Wazha ama, hya ɗǝngari sǝra hyi aga nyi ar pǝcira nji ngga hyi, aga hya ɗa njir nu, aˈyi patǝkura hyi ngǝ nji hahangǝ lagur sǝnbiya sǝ nǝ ndǝndǝkur mai, aˈyi patǝkura hyi ngǝ njira ǝnga dǝnama mai, ǝnga aˈyi patǝkura hyi ngǝ yirma mai. ");
INSERT INTO mfm_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Ama Hyal ngǝ hǝbiya sǝ dzakur nǝ duniya aga ja hǝna sǝli nǝ nji hahangǝu. Ənga ji hǝbiya kukufǝkur nǝ duniya aga ja hǝna sǝli njira nǝnau. ");
INSERT INTO mfm_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Ji hǝbiya sǝra nji diɗana wu duniya ǝnga sǝra gǝra ar viya vanyi sǝ wu duniya aga nda ndzana sǝra dǝdur. ");
INSERT INTO mfm_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Hyal mǝliya abangǝ aga nja sara ɓwadzǝ wu mwa nyi. ");
INSERT INTO mfm_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Ama Hyal ngǝ hǝr hyi a shili wu Kǝrsiti Yesu, ǝnga Hyal a mǝliyari Kǝrsiti ɗa hahangǝkur nǝr mǝn. Lagu nyi nga mǝn ɗa nji tsapǝu, nji cici nyi ǝnga njira ji bǝliya. ");
INSERT INTO mfm_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Agabangau, ǝnggǝr kǝra ja tsǝtsǝfau, “Taˈyi njir ɓwadzau nda ɓwadzǝ ǝnga Thlagǝu.” ");
INSERT INTO mfm_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Ənggǝra yi shili ǝgya hyi wazha ama, aga ya sa nar hyi ar kǝra jirkur nǝ sǝ ɗǝɗǝwa nǝ Hyal, nayi aˈyi shili ǝnga ca sǝnbiya ndǝr ǝnga madiya hahangǝkur mai. ");
INSERT INTO mfm_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Ara yi hǝri wu ɗǝfuwa yau, abǝr vanyi sǝ aˈyi yu sǝn ar pǝcira yi ǝkkǝˈyi hyi mai, kǝl Yesu Kǝrsiti ǝnga dlakǝkur nyi. ");
INSERT INTO mfm_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Tanggǝrma shili ɗa ǝgya hyi, yi shili wu kukufǝkur ɗa ǝnga hivǝr ba ǝnga tsǝdzǝ gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Cama ɗa ǝnga tǝtǝlna ndǝr Hyal ɗa aˈyi ǝnga shakǝr ba hahangǝkur nǝ ndǝndǝkur ɗa mai, ama ǝnga thlǝr kǝra cabiya dǝnama Mambǝl. ");
INSERT INTO mfm_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Sǝ kǝ ɗarkǝr aga mbǝrsar hyi a sara tǝghǝr dzau ar kǝra hahangǝkur nǝ nji mai, ama kǝl ar kǝra dǝnama nǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Alaga abangau, ˈyu ndǝr, ndǝr nǝ hahangǝkur anǝ njira a hǝri wu mbǝrsar nda, ama aˈyi culi hahangǝkur nǝ zaman ǝshina kǝ mai, ǝnga tsu aˈyi culi hahangǝkur tǝltǝlˈyar kǝra wu sa tǝrabiya nǝ zaman kǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Ama ˈyu ndǝr ar kǝra hahangǝkur nǝ Hyal kǝra ɗǝɗǝwa kǝra nji ɗǝwana, hahangǝkur nǝ Hyal kǝra ji pǝpǝdlǝya kadivira dzǝgwar duniya, aga ja ɗa sǝra wu shili ǝnga kadakadarkur anǝ mǝn. ");
INSERT INTO mfm_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Ndǝ aˈyi wu pama njir sǝm tǝlkur nǝ zaman ǝshina kǝ kǝra nggabiya sǝ kǝ mai. Maja abǝr ndǝ nggabiya, nanda aˈyi dlakǝya Thlagǝ ndǝ kadakadarkur mai. ");
INSERT INTO mfm_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Ama ǝnggǝr kǝra ja tsǝtsǝfau, abǝr, “Sǝra Hyal pabǝri anǝ njir yiwu nyi ndǝ aˈyi kǝra saya lari mai, ndǝ aˈyi tsu kǝra saya nggar mai, ǝnga tsu ndǝ aˈyi kǝra saya ɗǝngabiya mai,” ");
INSERT INTO mfm_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","ama Hyal a cabiya mǝn ri sǝˈyar kǝ lagu Mambǝl. Arya Mambǝl nga vǝr walbiya kalar sau, patǝ ǝkkǝˈyi sǝra ɗǝɗǝwa wu nggabiya sǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Ara wa ngǝ ndǝra wu sǝni sǝra ndǝ wu ɗǝnga ma aˈyi kǝl mambǝl kǝra wu ja waci maya? Abangǝ tsu ndǝ aˈyi kǝra wu sǝnbiya sǝra Hyal wu ɗǝnga mai, kǝl Mambǝl kǝra wu Hyal wacu. ");
INSERT INTO mfm_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Namǝn aˈyi dlǝwuri mambǝl nǝ duniya mai, ama Mambǝl kǝra shida sara dara Hyal, aga mǝna nggabiya lǝ sǝ lǝlau nǝ Hyal kǝra nji nǝ mǝn kurthlǝu. ");
INSERT INTO mfm_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Ca ngǝ sǝra ˈyu ndǝr ar kǝri, aˈyi sǝra nji highiɓǝr ˈya lagu hahangǝkur nǝ ndapi mai, ama sǝra shili lagu Mambǝl, kǝra wu cabiya jirkur nǝ Mambǝl anǝ njira wu Mambǝl. ");
INSERT INTO mfm_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Ndǝra gǝra wu Mambǝl, naju sǝn dlǝwuri sǝˈyar kǝra sara ara Mambǝl Hyal mai, arya dzakur nga nyi anǝ nyi, ǝnga naju sǝn nggabiya mai, arya lagu Mambǝl nga nju nggabiya wacu. ");
INSERT INTO mfm_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Ndǝra wu Mambǝl, ju sǝn mǝl numa ar kǝra kalar sau, ama naja ǝnga kǝrnyi aˈyi nju sǝn mǝl numa anǝ nyi mai. ");
INSERT INTO mfm_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Ənggǝr kǝra lǝkakaɗǝ nana, abǝr, “Wa ngu sǝnbiya ɗǝnga nǝ Thlagǝ tara ba ja sǝn highiɓǝ sǝ anǝ nya?” Ama aˈyi mǝn ǝnga ɗǝnga nǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Wazha ama, nayi aˈyi sǝn ndǝr anǝ hyi ǝnggǝr anǝ njira wu Mambǝl Hyal mai, ama ǝnggǝr anǝ njir duniya, njira tsu nda ǝnggǝr wazha yiɗǝɗǝu, wu lagu nu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Nayi nga vǝr sǝmǝna hyi ǝnga uˈwa ǝnggǝr wazha mamanji, aˈyi ǝnga ɗǝfǝ mai, arya tsu hyi gǝra nǝbiya dzau. Ənga jiri, baˈanǝ kabangǝkau, tsu hyi gǝra nǝbiya dzau. ");
INSERT INTO mfm_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Baˈanǝ kabangǝkau tsu hyi ǝnggǝr njir duniya. Ma tsu hyu ca shishikur, ǝnga hyu pǝpa wu pamǝu, aˈyi tsu hyi ǝnggǝr njir duniya wa? ");
INSERT INTO mfm_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Ara ma vanyi ndǝ na, “Nayi nǝ Bulusu ngau,” vanyi ndǝ tsu, “Nayi nǝ Apolusu ngau,” aˈyi tsu hyi ǝnggǝr njir duniya wa? ");
INSERT INTO mfm_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Ɗǝmya, wa ngǝ Apolusa? Wa ngǝ Bulusa? Aˈyi njir mǝl thlǝr Hyal nga ˈya waci wa, njira lagur nda nga hyi hǝnggǝri ǝnga Kǝrsiti wa? Aˈyi kalar ndǝ wu pama ˈya ngu mǝl sǝra Hyal nǝ nyi aga ja mǝl wa? ");
INSERT INTO mfm_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Nayi ngǝ thlǝkana culi, Apolusu ngǝ pǝr nda ˈyimi, ama Hyal ngǝ mǝliya nda ndǝ hau. ");
INSERT INTO mfm_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Mbar ar ndǝr thlǝka ǝnga ndǝr lǝ ˈyimi, patǝ nda, sǝ aˈyi nda aga nyi mai, ama kǝl Hyal, ndǝra mǝliya ndǝ hau. ");
INSERT INTO mfm_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Ndǝr thlǝka ǝnga ndǝr lǝ ˈyimi raragǝ nga nda wu mwar Hyal, kalar ndǝ wu pama nda wu sa uya akkǝri nyi kakalǝ ǝnga sǝra ji mǝliya. ");
INSERT INTO mfm_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Ara naˈya bazhi mǝl thlǝr Hyal ngau, nahyi tsu ngǝ fa Hyal, ǝnga sǝra Hyal ngǝ hǝriya. ");
INSERT INTO mfm_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Lagu mayiwakur kǝra Hyal nǝ ɗa, a fiyar yi hiya hǝr ar viya ndǝr hǝr kǝra mǝnahǝu, ǝnga vanyi ndǝ pamǝ tsu a dzǝgwa hǝr a dar kǝra nyi. Ama kǝ kalar ndǝ ja tsam ǝnga hangǝkal ǝnggǝra ju hǝr a dari. ");
INSERT INTO mfm_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Ara vanyi ndǝr fiya hiya hǝr pamǝ a ndiya kǝra yi fiya kǝ aˈyi mai, naja ngǝ Yesu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Alenyi nji ndǝ hǝr a dar kǝra nyi ǝnga ǝndzau, ǝnga thladla, ba ǝnga tsǝka dǝduru. Alenyi nji tsu ndǝ hǝr a dar kǝra nyi ǝnga wu, ǝnga sar, ba ǝnga ˈyiˈyi dzǝdzǝgwau. ");
INSERT INTO mfm_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","Thlǝrǝr nda patǝu wu nda cabiya dzǝ ar babal ar pǝcir shidar Thlagǝu. Thlǝr kau, wu nda nǝbiya dzǝ wu uˈu kǝra wu nda cabiya tara abari ngǝ mǝnahǝkura thlǝr kǝra ndǝ mǝliya. ");
INSERT INTO mfm_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Ma thlǝra nyi uya mbǝɗau sara wu miya uˈu, ju nda uya akkǝri. ");
INSERT INTO mfm_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Ma ndǝra thlǝr nyi nggyinakǝr wu uˈuwa nyi, ju nda uya asar, ama naja ju uya mbǝɗau, ama mbǝɗǝ nyi wu ɗa ǝnggǝr ndǝra biya sara wu miya uˈu. ");
INSERT INTO mfm_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Nahyi aˈyi hyu sǝni abǝr ar viya Ki Hyal nga hyi wa? Ənga nahyi aˈyi hyu sǝni abǝr Mambǝl Hyal a vǝr nggya wu hyi wa? ");
INSERT INTO mfm_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Kalar ndǝra ndzana Ki Hyal, Hyal wu nda ndzana nyi, arya Ki Hyal sǝ cici ngau, ǝnga nahyi ngǝ Ki Hyal kau. ");
INSERT INTO mfm_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Ndǝ ja sara ngguta kǝrnyi mai. Ma ndǝ wu pama hyi nggani abǝr hahangǝ nga ja wu nggyabiya zaman nǝ kabangǝkau, bǝgǝ ja fiya kǝrnyi ar viya ndǝ dza aga ja dzǝgwa ɗa ǝnga hahangǝkur. ");
INSERT INTO mfm_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Arya hahangǝkur nǝ duniya kau, ar viya dzakur ngau wu mwar Hyal. Ənggǝr kǝra ja tsǝtsǝfau, “Ju sǝn mbar nji hahangǝ wu kwaɗashimar nda.” ");
INSERT INTO mfm_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Ənga tsu ǝnggǝr kǝra tsǝtsǝfau wu lǝkakaɗǝ nǝ Hyal, abǝr, “Thlagǝ wu sǝni abǝr, ɗǝnga nǝ nji hahangǝ dzakur ngau wu mwar Hyal.” ");
INSERT INTO mfm_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Agabangau, ndǝ a sara ɓwadzǝ ǝnga ndǝ mai! Arya kalar sǝ nǝr hyi ngau, ");
INSERT INTO mfm_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","alaga Bulusu, alaga Apolusu, alaga Kefasu, alaga duniya, alaga pi, alaga tau, alaga sǝra ǝshina ǝnga sǝra a vǝr shili, patǝ nǝr hyi ngau, ");
INSERT INTO mfm_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ǝnga nahyi tsu nǝ Kǝrsiti ngau, Kǝrsiti tsu nǝ Hyal ngau. ");
INSERT INTO mfm_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Nji a kyaga hǝrˈya ar viya njir mǝl thlǝr nǝ Kǝrsiti, njira Hyal nǝ nda tǝtǝlna ndǝr Hyal kǝra ɗǝɗǝwa. ");
INSERT INTO mfm_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Kabangǝkau, kalar njira nji nǝ nda sǝr mǝl, nda ɗa njir mǝl thlǝr tsaˈa miya ɗǝfu. ");
INSERT INTO mfm_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Anǝ ɗa, aˈyi ɗa sǝr tal ma hyi mǝliya ɗa numa mai, ǝnga alaga alenyi njir mǝl numa anǝ ɗa mai. Ənga jiri alaga nayi aˈyi yu mǝl numa anǝ kǝrɗa mai. ");
INSERT INTO mfm_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Nayi sǝnibiya sǝra yi ndzana mai, ama alaga abangau, aˈyi cabiya abǝr vazǝ ɗa aˈyi mai. Thlagǝ ǝnga kǝrnyi ngu mǝl numa anǝ ɗa. ");
INSERT INTO mfm_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Agabangau, a sara hya mǝl numa anǝ nji tsu pǝcir numar nda gǝra ɗa mai. Hya sǝkǝ pǝci kǝra Thlagǝu nda sha shili. Ju nda cabiya ar babal sǝra ndǝ mǝlna ɗǝɗǝwa ǝnga ja cabiya sǝra ndǝ a vǝr ɗǝnga wu ɗǝfuwa nda. Ar pǝci ta ngǝ kalar ndǝ wu nda dlǝwuri fal nyi ara Hyal tsatsaˈa aga sǝra nda nyi mǝliya. ");
INSERT INTO mfm_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Kabangǝkau, wazha ama, sǝ kǝ yu na kau, a mǝliyar ˈya ar kǝra kǝrˈya nayi ǝnga Apolusu aga tara ba ja dlǝwar hyi. Lagu kǝ nga hyu sǝn highiɓǝri ara ˈya sǝra lǝkakaɗǝ nana, abǝr, “Hya sara mǝl thlǝr a biya abanga sǝra tsǝtsǝfǝ kǝ mai.” A sara ndǝ wu pama hyi a ɓwadzǝ ǝnga vanyi ndǝ a ndiya vanyi ndǝ wu pama ˈya mai. ");
INSERT INTO mfm_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Wa ngǝ mǝliya gǝ ɗa pamǝ a ndiya vanyi nda? Mi ngǝ sǝra ara gau, kǝra aˈyi nji ngǝ nǝ ngǝ maya? Ma nji ngǝ nǝ ngau, ya, ara mi nga gǝ mǝliya ji ɗa sǝr ɓwadza? ");
INSERT INTO mfm_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Kabangǝkau, a uyar hyi kalar sǝra hyu yiwu. A ɗari hyi njir bǝrba njir gǝnna! Gǝra ǝnga ˈya a ɗar hyi tǝl! Ənggǝra yu cim, a ɗari hyi tǝl ǝnga jiri, aga mǝna daɓaga sǝm tǝlkur kǝ ǝnga hyi patǝu! ");
INSERT INTO mfm_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Ara wu ɗǝnga ɗa, Hyal a fiya ˈya ri, naˈya cama sǝsau, ǝnggǝr njira a gyu ndǝla nji ǝnga didiɗi, njira nji thlana nda numa nǝ tau. Kǝja ˈya a ɗari aga sǝr nggushi wu mwar duniya ǝnga wu mwar waladiˈyar ǝnga nji patǝu. ");
INSERT INTO mfm_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Arya Kǝrsiti a ɗar ˈya dza, ama nahyi nji hahangǝ nga hyi wu Kǝrsiti! Nji kukufu nga ˈya, ama nahyi nji nǝnau! Nahyi nju gǝnggǝr hyi sǝli, ama naˈya nju gǝnggǝr ˈya sǝli mai! ");
INSERT INTO mfm_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Shili ar pǝci kǝ ǝshina ǝnga wuɓǝ ba ǝnga hili nga ˈya, kar hahal nga ar dza ˈya, ǝnga nja vǝr lǝ ɓwaɓwatǝ anǝ ˈya, naˈya nji gǝra ǝnga ki ngau. ");
INSERT INTO mfm_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","ˈYa vǝr mǝl thlǝr gagaɗau ǝnga tsa ˈya. Ar pǝcira nji shiˈwa ˈya, ba ˈya shabiya ǝnga lǝ barka. Ma nji takasǝ ˈya, ba ˈya sǝsǝˈwuri. ");
INSERT INTO mfm_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Ma nju ndǝr nǝ ndza thlǝmǝr ˈya ba ˈya shaɗǝwa ǝnga hangǝkal. Baˈanǝ shilar kabangǝkau, a ɗari ˈya sǝra nja pǝna ar dzǝgau, ǝnga wu mwar njir duniya kǝ ˈyi ɗa dzǝgau. ");
INSERT INTO mfm_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Nayi aˈyi a vǝr tsǝfǝ sǝˈyar kau, aga ya hǝna sǝlir hyi mai, ama aga ya tǝɗar himiya hyi, nahyi wazha kǝra yu yiwu gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Alaga aˈyi hyi ǝnga njir highiɓǝ gangǝ anǝ hyi wu Kǝrsiti, ama aˈyi hyi ǝnga tadaˈyar gangǝ mai, arya wu Kǝrsiti Yesu nga yi ɗa ar viya tada ar kǝra hyi lagu nǝ ndǝshigu. ");
INSERT INTO mfm_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Agabangau, yu kǝdi hyi aga hya faˈabiya hiya yau. ");
INSERT INTO mfm_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Arya kǝ nga yi sǝwa hyi Timathlawusu, zǝr ɗa kǝra yu yiwu, naja ndǝra wu mǝl thlǝr Thlagǝu tsaˈa miya ɗǝfu. Ju sa ɗǝngar hyi ar kǝra nggyabiya ɗa wu Kǝrsiti Yesu, kǝra shili kakalǝ ǝnga sǝra ya vǝr highiɓǝ ar kalar vira yi ndari ǝnga wu kalar daɓǝ dzǝ njir nu. ");
INSERT INTO mfm_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Alenyi nji wu pama hyi a ɗar njir ɓwadzau, ǝnggǝr tsu yu ɓǝra sha shili ara hyi mai. ");
INSERT INTO mfm_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Ama yu ɓǝra sha shili ara hyi kajangǝkau, ma Hyal mǝliya, ba ya dzǝgwa nggabiya aˈyi kǝl ndǝr nǝ nji ɓaɓal kǝr kǝ waci mai, ama tara wathlǝm culi dǝnama kǝra aˈyi ara nda. ");
INSERT INTO mfm_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Ara tǝlkur Hyal aˈyi sǝra nju na ǝnga miya nga nyi waci mai, ama sǝra nju mǝl ǝnga dǝnama ngau. ");
INSERT INTO mfm_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Mi ngǝ sǝra hyu cim a ɗa? Ya shili ǝnga wuɗa ǝndǝga ya shili ǝnga yiwukur, ǝndǝga ǝnga huɗǝ shishiˈwu nǝ mambǝl ya? ");
INSERT INTO mfm_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Nji nar ɗa, abǝr, sǝsukur aˈyi wu pama hyi, culi kǝra a ndiya kǝra njira gǝra sǝn Hyal a vǝr mǝl. Kǝra tǝkǝri ndǝ wu pama hyi wu pida ǝnga mala dǝnyi. ");
INSERT INTO mfm_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Kǝja hyu ɓwadzau, ama sǝr nggǝrau ngau anǝ hyi. Sǝra tsaˈa hya mǝl ca ngǝ hya hǝbiya ndǝr mǝl sǝ abangau sara wu pama daɓǝ dzǝr hyi. ");
INSERT INTO mfm_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Alaga kǝ aˈyi yi ǝkkǝˈyi hyi wu kumǝr dzǝ kǝ mai, ama aˈyi yi ǝnga hyi wu mambǝl. A thlana nyir yi numa anǝ ndǝr mǝl najaka huɗa sau wu thlǝmǝr Thlagǝr mǝn Yesu, ǝnggǝr aˈyi yi ǝkkǝˈyi hyi kabangǝkau. ");
INSERT INTO mfm_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Ar pǝcira hyu daɓau, ǝnga aˈyi yi ǝkkǝˈyi hyi wu mambǝl, ǝnga dǝnama nǝ Thlagǝr mǝn Yesu aˈyi ǝna, ");
INSERT INTO mfm_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","hya lǝr culi ndǝ kǝ anǝ shatan aga kumǝr dzǝ nǝ bikau a tau, ba mambǝl nyi a uya mbǝɗau ar pǝcir shidar Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Ɓwadzǝr hyi aˈyi sǝ mǝnahǝ ngǝ mai. Aˈyi hyu sǝni abǝr thlǝlamǝ kushu ca ngu thlǝthlǝna lǝgu ɗǝfǝ wa? ");
INSERT INTO mfm_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Hya hǝbiya bikǝ kǝra ǝnggǝr thlǝlamǝ hahal sara wu hyi, aga hya ɗa nji mafǝliyangǝ kǝra ǝnggǝr macikǝl gǝra thlǝlamǝ, ǝnggǝr kǝra hyi kau. Arya Kǝrsiti, gamǝ nǝ lardur vǝlna, ca nga nji hǝna saɗaka ǝnga ja arya mǝn. ");
INSERT INTO mfm_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Agabangau, taˈyi mǝna gu lardur mǝn, aˈyi ǝnga thlǝlamǝ hahal mai, ca ngǝ sǝ ǝnggǝr sǝɓǝ ndǝ wu ɗǝfu ǝnga shishikur, ama nǝ macikǝl gǝra thlǝlamǝ, ca ngǝ sǝ ǝnggǝr nggya nǝ cicikur ǝnga jirkur. ");
INSERT INTO mfm_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","A tsǝfǝr hyir yi wu cama tsǝtsǝfǝ ɗa abǝr a sara hya daɓǝ kǝr ǝnga nji sǝsu mai. ");
INSERT INTO mfm_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Ama nayi aˈyi a vǝr ndǝr ar kǝra nji sǝsu nǝ duniya kǝ mai, alaga njir suna ǝnga alaga njir dlǝrbau, ba njir nu katǝu. Ma ar kǝra nda nga ya vǝr ndǝr kau, a ɗari kǝl ba hya piyari duniya aga hya tǝkǝbiya dzǝ ǝnga nda. ");
INSERT INTO mfm_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Ama kabangǝkau, ya vǝr tsǝfǝ anǝ hyi abǝr, a sara hya daɓǝ kǝr ǝnga ndǝr ngga kǝrnyi ndǝr nu, ama ndǝ sǝsu nga ja mai, alaga ndǝr suna, alaga ndǝr nu katǝu, alaga ndǝr ɗa nji, alaga ndǝr sa padlau, ǝnga alaga ndǝr hǝl. Ənga culi ndǝ kau, hya sara sǝm alaga sǝr sǝm ǝnga ja mai. ");
INSERT INTO mfm_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Mi ngǝ nǝ ɗa aga ya thla numa anǝ njira aˈyi njir nu maya? Aˈyi anǝ njir nu nga hya kyaga mǝl numa wa? ");
INSERT INTO mfm_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Hyal ngu nda mǝl numa anǝ njira aˈyi njir nu mai. “Hya kǝdlǝbiya ndǝr mǝl sǝ ɗǝmwaˈyi kau, wu pama hyi.” ");
INSERT INTO mfm_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Ma ndaliya hyi aˈyi ǝnga sǝr kǝpal wu ɗǝfuwa ja ǝnga kuvwa nyi, ja sara hǝ nda nyi a dumwar njira gǝra sǝn Hyal mai, ama a dumwar nji cici gǝ Hyal wa? ");
INSERT INTO mfm_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Əndǝga aˈyi hyu sǝni abǝr nahyi nji cici gǝ Hyal ngu nda mǝl numa anǝ njir duniya wa? Ma nahyi ngu nda mǝl numa anǝ njir duniya, aˈyi hyu sǝn mǝlna numa ar kǝra sǝ kukushuˈyar kǝ wa? ");
INSERT INTO mfm_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Ɗǝm ya, aˈyi hyu sǝni abǝr namǝn ngu nda mǝl numa anǝ waladiˈyar wa? Ka dzǝgwa ɗa sǝr nggyabiya nǝ duniya kǝ nga ndiya ya? ");
INSERT INTO mfm_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Agabangau, ma aˈyi hyi ǝnga kǝpal ar kǝra sǝˈyar kau, mi ngǝ ɗa hyu maˈyi a dumwar njira gǝra tǝkǝri nda ɗa vanyi sǝ wu mwar daɓǝ dzǝ njir nu wa? ");
INSERT INTO mfm_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Yi na abangau, aga ja ɗa sǝ sǝsǝli anǝ hyi. Abari nga ja sǝn ɗa abǝr ndǝ aˈyi wu pama hyi kǝra hahangǝ, kǝra wu sǝn mǝlna numa wu pama njir nu mai ka? ");
INSERT INTO mfm_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Ama ba ɗa, hyu hǝ kuvwar hyi a ndumwar njir pathla, njira aˈyi njir nu mai. ");
INSERT INTO mfm_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Alaga ǝnggǝra hyu hǝ kuvwar hyi a ndumwar njir pathla, a cabiyari abǝr a ɗar hyi nji dladla. Aˈyi kuji hya ɗa nji vavazǝ wa? Aˈyi kuji hya ɗa ǝnggǝr njira nji ɗiya wa? ");
INSERT INTO mfm_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Ama kǝja nahyi ngǝ dzǝgwa ɗa njir vazǝ nji, ǝnga hyi ɗa njir ɗiya nji, ǝnga tsu kǝja hyu mǝl abangau anǝ zamǝr hyi. ");
INSERT INTO mfm_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Nahyi aˈyi wu sǝni abǝr nji shishi wu uya gwu tǝlkur Hyal mai wa? Hya sara ngguta kǝrhyi mai, arya nji sǝsu ǝnga njir nu katǝu, ǝnga njir dlǝnga mala ǝnga sal ndau, ǝnga shili kǝra wu pida ǝnga shili kuvwar nda, ");
INSERT INTO mfm_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ǝnga njir hǝl, ǝnga njir suna, ba ǝnga njir sa padlau, ǝnga njir na ndau, ba ǝnga njir kwaɗashima, nandu uya gwu tǝlkur Hyal mai. ");
INSERT INTO mfm_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Abangǝ ngǝ alenyi nji wu pama hyi saya ɗa, ama a cina hyir nji, ǝnga a thlǝna hyir nji. Kǝ hyi ɗa njira nji mǝliya nda nji tsapǝu, wu thlǝmǝr Thlagǝr mǝn Yesu Kǝrsiti ǝnga lagur Mambǝl Hyalǝr mǝn. ");
INSERT INTO mfm_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","A sǝn mǝl yi kalar sau, ama aˈyi kalar sǝ ngǝ ǝnga dlǝwa dzǝ anǝ ɗa mai. A sǝn mǝl yi kalar sau, ama aˈyi yu ɗa mafa anǝ kalar sǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Nji mǝliya ɗǝfau aga gwu ta, ta tsu aga pǝ ɗǝfau, ama patǝkura nda Hyal wu nda sana nda. Nji aˈyi mǝliya dzǝ aga sǝsukur mai, ama anǝ Thlagǝu, ǝnga Thlagǝ tsu anǝ dzau. ");
INSERT INTO mfm_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Hyal hyaˈana Thlagǝu sara vir tau lagu dǝnama nyi, abangǝ tsu nga ju nda hyaˈana mǝn sara vir tau. ");
INSERT INTO mfm_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Nahyi aˈyi wu sǝni abǝr dza hyi gashagashal nǝ Kǝrsiti ngǝ wa? Ya, abari nga hyu dzǝgwa hǝr dza Kǝrsiti hya daɓǝya ǝnga nǝ zawar ka? Wu kyaga ɗa mai! ");
INSERT INTO mfm_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Aˈyi hyu sǝnbiya abǝr kalar ndǝra daɓǝr kǝrnyi ǝnga zawar a ɗar nda dzǝ zǝmǝ wa? Arya tsǝtsǝfǝ nga nyi abǝr, “Nji mǝthlǝ kau, ndu ɗa dzǝ zǝmǝu.” ");
INSERT INTO mfm_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Ama kalar ndǝra daɓǝr kǝrnyi ǝnga Thlagǝu, a ɗar nda nji zǝmǝ wu mambǝl. ");
INSERT INTO mfm_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Hya hwi sara ara nggyabiya nǝ sǝsukur. Arya kalar bikǝ kǝra ndu mǝl a biyar ya kumǝr dza ja nga nyi, ama kalar ndǝra mǝliya bikǝ nǝ sǝsukur, a mǝliyar ja bikǝ anǝ kumǝr dza ja. ");
INSERT INTO mfm_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Aˈyi hyu sǝni abǝr dza hyi Ki nǝ Mambǝl Cici ngǝ wa? Mambǝl kǝra wu hyi, ara Hyal nga hyi dlǝwuri. Nahyi aˈyi nǝ kǝrhyi nga hyi mai, ");
INSERT INTO mfm_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","a ɗǝlbiya hyir nji ǝnga madiya sau. Agabangau, hya gǝnggǝr nyi sǝli anǝ Hyal ǝnga dza hyi. ");
INSERT INTO mfm_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Ar kǝra sǝra hyi sayi tsǝfǝr ɗa tsu kaɗǝ ta, wu ɗa mǝnahǝu ma ndǝ sǝn nggya gǝra hǝ mala. ");
INSERT INTO mfm_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Ama ta ɗa sǝsukur a nyabiyar dzǝ wu hyi, taˈyi kalar ndǝ a hǝr mala nyi, kalar mala tsu ja hǝr sal nyi. ");
INSERT INTO mfm_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Kalar sal ja nyabiya salkur nyi wu dza mala nyi, mala tsu ja mǝl abangǝ anǝ sal nyi. ");
INSERT INTO mfm_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Mala aˈyi naja ngu gǝla dza ja mai, ama sal nyi. Abangǝ tsu, sal aˈyi naja ngu gǝla dza ja mai, ama mala nyi. ");
INSERT INTO mfm_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Hya sara ka kǝrhyi anǝ kǝrhyi mai, kǝl ma hyi lari a ɗar tsaˈa anǝ gyapǝkura hyi nǝ pǝci kushu, kǝra hyu yiwu hya kǝdi Hyal. Alaga abangǝ tsu ma, hya sara sǝkari nǝ pǝci gangǝ mai, a sara Shatan a uya lagur dzǝ hyi, ma ndaliya hyi gǝra sǝn sǝsǝˈwuri. ");
INSERT INTO mfm_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Sǝ kǝ yi na kǝ patǝ sawara ngau, aˈyi sǝra mbari kǝl nja mǝl mai. ");
INSERT INTO mfm_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Yu cim abǝr patǝr nji nda ɗa ǝnggǝr kǝra yi kau, ama tsu kalar ndǝ aˈyi ǝnga sǝ lǝlǝ kǝra Hyal nǝ nyi, ndǝ kǝ ǝnga nǝnya sǝ lǝlau, ndǝ ta tsu ǝnga nǝnyi. ");
INSERT INTO mfm_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Ama yi na anǝ njira gǝra hǝr sal ǝnga njira gǝra hǝr mala ba ǝnga mathlǝkǝˈyi tǝsal, wu ndiya ǝnga mǝnahǝu anǝ nda, ma ndǝ sǝn nggya sǝr nda ǝnggǝr kǝra yi kau. ");
INSERT INTO mfm_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Ama ma nda nyi aˈyi wu sǝn kǝkǝya kǝrnyi mai, wu ndiya anǝ nyi ja hǝr sal alaga ja hǝr mala, ara ja sara tau ǝnga cim mala alaga sal. ");
INSERT INTO mfm_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Kǝja sǝr ɓǝla anǝ hyi nahyi njira hǝrdzau, aˈyi sara ara yi mai, ama sara ara Thlagǝu. Mala a sara tǝkǝbiya dzǝ ǝnga sal nyi mai. ");
INSERT INTO mfm_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Ama ma ji tǝkǝbiya dzau, taˈyi ja nggya sǝ nyi gǝra hǝ sal, ma aˈyi abangǝ mai, taˈyi ja ɓǝra sha a ndǝgya sal nyi ta. Sal tsu ja sara kǝdlǝna mala nyi mai. ");
INSERT INTO mfm_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Anǝ nji kǝra hyau, (Yi na, aˈyi ǝngwar Thlagǝ mai), ma ndǝr nu aˈyi ǝnga mala kǝra gǝra ndǝr nu, ya, mala nyi wu yiwu nda nggya sǝr nda, a sara sala nyi a kǝdlǝ nyi mai, bǝgǝ nda nggya sǝr nda. ");
INSERT INTO mfm_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Ma mala kǝra ndǝr nu tsu, aˈyi ǝnga sal kǝra gǝra ndǝr nu, ya sala nyi wu yiwu nda nggya abangau, mala nyi a sara tǝkǝbiya dzǝ ǝnga ja mai, ama nda nggya sǝr nda. ");
INSERT INTO mfm_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Arya sal gǝra ndǝr nu kau, a ɗari ja cicau lagu mala nyi. Abangǝ tsu ngǝ mala kǝra gǝra ndǝr nu, a ɗar ja cicau lagu sal nyi. Ma aˈyi abangǝ mai wazhar nda wu ɗa nji gǝra cicau, ama arya abangau a ɗar nda nji cicau. ");
INSERT INTO mfm_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Ama ma ndǝra gǝra ndǝr nu wu yiwu ja tǝkǝbiya dzǝ ǝnga mala alaga sal, taˈyi ja ɗa, ndǝ aˈyi ar sǝˈyi hǝdzǝ kǝ mai, arya Hyal ngǝ ngga mǝna vu nggya wu huɗǝ pǝrtǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Nagǝ mala, wa sǝna, ma gǝ mǝl abangau, tara ba ga shabiya sal ngau a shili wu mbǝɗa? Alaga nagǝ sal tsu ma gǝ mǝl abangau, wa sǝna, tara ba ga shabiya mala ngau a shili wu mbǝɗa? ");
INSERT INTO mfm_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Kalar ndaliya hyi ja dumwa ǝnga nggya wu kalar nggyabiya kǝra Hyal fuwa nyi a gwa, ja ɗa ǝnggǝr kǝra ja parangǝ kadivira Hyal ngga nyi ta. Ca ngǝ sǝr ɓǝla kǝra yu nǝ nyi anǝ patǝr daɓǝ dzǝ njir nu. ");
INSERT INTO mfm_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Nja na, ma ndǝ aˈyi kǝra nji thlana nyi pǝlzha kadivira ja ɗa ndǝr nu, ja sara shabiya pǝlzha nyi ǝnggǝr ndǝra nji gǝra thlana nyi pǝlzha mai. Ətsu ndǝra ɗa ndǝr nu ama aˈyi nji thlana nyi pǝlzha mai, tsu ja ɓǝra thla pǝlzha mai. ");
INSERT INTO mfm_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Ndǝra nji thla nyi pǝlzha ǝnga ndǝra nji gǝra thla nyi pǝlzha aˈyi ca ngǝ sǝ mai. Sǝra ndiya patǝu ca ngǝ ɓǝlari dlaɗǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Yau, kalar ndǝ ja nggya ǝnggǝr kǝra ja kadivira Hyal ngga nyi. ");
INSERT INTO mfm_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Nagǝ mafa ar pǝcira Hyal ngga ngǝ ya? A sara ga ɓwakǝr anǝ kǝrngǝ mai. Ama ma lagu aˈyi kǝra ga sǝn bǝliya kǝrngau, ba ga bǝliya. ");
INSERT INTO mfm_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Ama kalar ndǝra Thlagǝ ngga kǝra mafa nga ja, ma ji ɗa ndǝr nu, a ɗar ja kambǝr ndau wu Thlagǝu. Ma tsu kambǝr ndǝ nga ja, kadivira ji ɗa ndǝr nu, a ɗar ja mafa nǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Ənga madiya sǝ nga nji ɗǝlbiya hyi, a sara hya ɓǝra mbiya kǝrhyi wu mafakur mai. ");
INSERT INTO mfm_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Nahyi zamǝ ɗa ǝnga kwamǝ ɗaˈyar, kalar ndǝ ja nggya ǝnggǝr kǝra ja kadivira Hyal ngga nyi, ba ja nggya aga ja. ");
INSERT INTO mfm_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Ar kǝra wazha kwamathlǝkǝˈyi kǝra gǝra sǝn ndǝ sal, sǝr ɓǝla aˈyi kǝra sara ara Hyal kǝra ya nǝ hyi mai. Ama Hyal lagu tǝhuɗǝ nyi, ndǝra mǝliya ɗa yi ɗa ndǝra nju fiyafǝ ǝni, ca nga yu dzǝgwa dǝgabiya hyi ɗǝnga ɗa. ");
INSERT INTO mfm_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Arya culi nggyabiya kǝra nji a gwa kabangǝkau, yu nggani, a ndiya anǝ ndǝ ja nggya sǝ nyi abangau. ");
INSERT INTO mfm_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Ndǝra a hǝrdzau, bǝgǝ ja nggya sǝ nyi. Ma tsu nagǝ aˈyi hǝr mala alaga sal mai, a ndiya ga nggya sǝ ngǝ abangau. ");
INSERT INTO mfm_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Ma nagǝ ndǝ hǝr mala, aˈyi bikǝ mai. Ma nagǝ zǝkwamalagǝ hǝr sal, aˈyi bikǝ mai. Patǝ abangau, njira hǝrdzau pǝci kǝ ǝshina ndu gu nggyabiya nǝ dzadzaukur, ca ngǝ sǝra yu yiwu ya hǝbiya hyi sara gwa. ");
INSERT INTO mfm_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Sǝra ya vǝr na kau, ca ngǝ, nahyi wazha ama, pǝci a hyiri kushu. Mbar kabangǝkau, bǝgǝ njira ǝnga mathlǝkǝˈyi nda nggya ǝnggǝr mathlǝkǝˈyi aˈyi ara nda mai. ");
INSERT INTO mfm_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Njira vǝr sǝˈyinggu, nda ɗa ǝnggǝr aˈyi nda vǝr sǝˈyinggu mai. Njira vǝr caguli tsu, nda ɗa ǝnggǝr njira vǝr tiwi. Njira vǝr ɗǝl sau, nda ɗa ǝnggǝr njira gǝra sau. ");
INSERT INTO mfm_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Njir sǝn mǝl thlǝr ǝnga sǝr duniya, nda sara fǝ kǝra nda a gu gwa mai. Ara duniya kǝra mǝn wu sǝni kau, a vǝr tǝrabiya. ");
INSERT INTO mfm_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Yu yiwu hya ɗa ǝnga kǝr papal ar kǝra nggyabiya duniya. Ndǝra gǝra hǝr mala alaga sal ja vǝr ɗǝnga ǝnggǝra ja sǝn pina huɗa Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Ama ndǝra ǝnga mala aˈyi ja ǝnga kǝr papal mai, ara ju gal lagura ja sǝn uya sǝr duniya aga ja pina huɗa mala nyi. ");
INSERT INTO mfm_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Ənggau ju ɗa ǝnga kǝr mǝmǝthlǝu. Ənga tsu mala kǝra gǝra ǝnga sal alaga kǝra gǝra saya sǝn ndǝ sal, ǝnga papalkur kǝr, ju sǝn lǝri kǝrnyi cicau anǝ Thlagǝu wu kumǝr dzau ǝnga wu mambǝl. Ama mala kǝra hǝr sal, ju gu ɗǝnga sǝ ǝnggǝra ja sǝn pina huɗa sal nyi ǝnga ja uya sǝr duniya. ");
INSERT INTO mfm_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Ya vǝr na abangau aga ja ɗa sǝr dlǝwa hyi, aˈyi aga ya gatsǝna far hyi mai, ama aga hya uya nggya papalkǝr kǝra hya sǝn nu Thlagǝu gǝra ǝnga tǝkǝ kǝr. ");
INSERT INTO mfm_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Ma ndǝra nggani abǝr aˈyi ju mǝl sǝra tsaˈa anǝ mala mbamba nyi mai, ma cim nǝ sal kǝ ɗa gagaɗau, ba sala nyi lari ja kyaga hǝr mala nyi, ja mǝl sǝra tsatsaˈa anǝ nyi. Naja aˈyi mǝliya bikǝ mai, ba ja hǝr mala nyi. ");
INSERT INTO mfm_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Ama ma nda nyi a hǝri wu ɗǝfuwa ja aga ja nggya sǝ nyi abangau, ama ndǝ aˈyi ciwa nyi aga ja nggya abangǝ mai, ǝnga ju sǝn kǝkǝya kǝrnyi, ǝnga ji mbiya wu ɗǝfuwa ja naju hǝ nyi mai, ndǝ kǝ tsu a mǝliyar ja sǝra tsatsaˈa. ");
INSERT INTO mfm_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Agabangau, ma ndǝra hǝr zǝkwamalagǝ anǝ kǝrnyi, a mǝliyar ja sǝ mǝnahǝu. Ama ndǝra wu sǝn mbiya ɗǝfu, ba ji piyari hǝ mala, naja nga ndiya. ");
INSERT INTO mfm_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Mala ǝgyakiɗa sal nyi nga ja wu nggyabiya nyi ma sala nyi ǝnga pi. Ama ma sal nyi tau, ju sǝn hǝr vanyi sal kǝra ju yiwu, ama sala nyi a ɗa ndǝr nu Hyal. ");
INSERT INTO mfm_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Ama wu tsamǝ ɗa, wu ɗa tsaˈa ma ji sǝn nggya sǝ nyi abangau. Yu nggani tsu wu Mambǝl Hyal nga yu ndǝr kau. ");
INSERT INTO mfm_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Yu yiwu ya ndǝr anǝ hyi ar kǝra sǝr sǝm kǝra nji thlana nyi anǝ katǝu. Aˈyi mǝn patǝ ǝnga sǝnbiya sǝ gagaɗau. Sǝn sǝr mǝn kau, ca ngǝ hana kǝra mǝn, ama yiwukur ca ngǝ mbiya mǝn ɓaɓal wu mbǝrsa. ");
INSERT INTO mfm_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Kalar ndǝra nggani abǝr a sǝnbiyar ja sau, alaga abangau, naji sǝnbiya sǝra ja kyaga sǝni mai. ");
INSERT INTO mfm_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Ama ndǝra vǝr yiwu Hyal naja ngǝ ndǝra Hyal wu sǝni. ");
INSERT INTO mfm_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Ma mǝn ndǝr ar kǝra sǝm sǝr sǝm kǝra nji thlana nyi anǝ katǝu, a sǝnǝr mǝn abǝr katǝ aˈyi ja ar viya vanyi sǝ mai. A sǝnǝr mǝn tsu abǝr vanyi hyal aˈyi mai kǝl Hyal, arya Hyal zǝmǝ nga ja. ");
INSERT INTO mfm_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Alaga kǝ nju na, hyal hyalˈyar aˈyi nda gangǝu, kǝra a dǝmǝlmau ǝnga kǝra a gyuˈyi, ǝnga tsu thlagǝ thlagǝˈyar aˈyi nda gangǝu, ");
INSERT INTO mfm_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","patǝ abangau, mǝnu sǝnbiya Hyal zǝmǝ nga ja. Naja ngǝ Tada, ndǝra duniya patǝu shili sara dara ja, kǝra namǝn ma a vǝr nggya aga ja, Thlagǝ tsu zǝmǝ nga ja, ca ngǝ Yesu Kǝrsiti, lagu nyi ngǝ patǝr sǝ shili, ǝnga lagu nyi nga mǝna vǝr nggya. ");
INSERT INTO mfm_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Aˈyi patǝr nji nga vǝr sǝn najaka sǝ mai. Alenyi nji a tsǝliyar nda dzǝ ǝnga nggya katǝu, ma ndǝ sǝm sǝra nji thla nyi anǝ katǝu, ndu nggani abǝr nu hyal nga nda a gwa, ɗǝngar nda kǝra tǝtǝwa ngǝ fuwa nda wu sǝli. ");
INSERT INTO mfm_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Ɗǝfau a sǝn hǝr mǝn a shili wu mwar Hyal mai. Ma mǝn sǝm, a sǝn dlǝwar mǝn mai, ma mǝn piyari, sǝ aˈyi kǝra ja sǝn cakǝr mǝn mai. ");
INSERT INTO mfm_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Taˈyi hya nggya ǝnga ɓǝla, a sara kambǝkurǝr hyi kau, ja sara ɗa sǝr thlǝ hi anǝ nji tǝtǝwa mai. ");
INSERT INTO mfm_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Ara ma ndǝra tǝtǝwa wu ɗǝnga lar nga vǝr sǝm sǝr sǝm kǝra nji thlana anǝ katǝu, nagǝ ndǝra wu sǝnbiya sau, aˈyi gu tsǝtsǝkur nyi, ba ja sǝm sǝra nji thlana nyi anǝ katǝ wa? ");
INSERT INTO mfm_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Arya sǝnbiya sǝ ngǝ kau, ba zamǝ ngǝ kǝra tǝtǝwa wu ɗǝnga ndǝra Kǝrsiti tǝ arya ja, ba ja dla. ");
INSERT INTO mfm_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Ma gǝ mǝliya nyi bikǝ anǝ zamǝ ngǝˈyar, lagur tsǝtsǝkur nda aga nda mǝl sǝra ɗǝngar nda gǝra mbar nda mǝl, a mǝliyar gǝ bikǝ anǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Ma ɗa abǝr sǝm kum nga sǝn mǝliya ba zamǝ ɗa a thlǝr hi, a ndiya anǝ ɗa ya nggya gǝra sǝm kum, a sara ya fuwa zamǝ ɗa ja thlǝr hi. ");
INSERT INTO mfm_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Aˈyi yi kambǝr ndǝ wa? Aˈyi yi cama sǝsǝ wa? Aˈyi nayi ǝnga kǝrɗa ngǝ lari Thlagǝr mǝn Yesu ǝnga liya yi wa? Aˈyi arya thlǝr ɗa nga hyi ɗa njir nu Thlagǝ wa? ");
INSERT INTO mfm_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Ma aˈyi yi ɗa cama sǝsǝ anǝ alenyi nji mai, ama anǝ hyi cama sǝsǝ nga yau, arya nahyi ǝnga kǝrhyi sakida nga hyi abǝr cama sǝsǝ nǝ Thlagǝ nga yau. ");
INSERT INTO mfm_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Kǝja shaɗǝwa ɗa anǝ njira vǝr kǝpal dǝnama nǝ tǝlkur ɗa. ");
INSERT INTO mfm_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Aˈyi ˈya kyaga uya sǝr sǝm ǝnga sǝr sa wa? ");
INSERT INTO mfm_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Aˈyi ˈyi ɗa tsaˈa aga ˈya ɓǝ ǝkkǝˈyi mathlǝkǝˈyir ˈya kǝra njir nu ǝnggǝr kǝra alenyi cama sǝsǝˈyar ǝnga zamiya Thlagǝ ˈyar ba Kefasu a vǝr mǝl wa? ");
INSERT INTO mfm_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Əndǝga kǝl nayi ǝnga Barnabasu nga kyaga mǝl sǝra wu sǝn sǝmǝna ˈya ya? ");
INSERT INTO mfm_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Wa thlǝmǝ culi soja kǝra a miya pa nga ɓǝra sǝmǝna kǝr nya? Wa thlǝmǝ ndǝr zǝwa kǝra aˈyi sǝn sǝm sǝra ji zǝwa maya? Wa thlǝmǝ ndǝr ɓǝla kǝra aˈyi ja sǝn uya uˈwa thla kǝra ja vǝr ɓǝla maya? ");
INSERT INTO mfm_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Ndǝr ɗa kǝ ya, wu ndǝndǝkur nga yu na ya? Əndǝga hyu nggani abǝr dlaɗǝ nǝ Musa aˈyi na abangǝ maya? ");
INSERT INTO mfm_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Arya dlaɗǝ Musa a nanari abǝr, “Ga sara mba njuwangǝ wu miya thla zǝwa ndal ǝdla ma ja vǝr mǝl thlǝr dǝgǝ uhi ar lar mai.” Hyu nggani thla zǝwa ndal ǝdla ngǝ Hyal a vǝr ɗǝnga ma ju na abangǝ kǝ ya? ");
INSERT INTO mfm_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Aˈyi ar kǝra mǝn nga ja vǝr ndǝr ǝnga hangǝ wa? Angǝ, aga mǝn nga nji tsǝfǝri, aga ndǝra vǝr zǝwa fa ǝnga ndǝra vǝr faˈa sǝ asi aga gyapǝ nda nda uya fǝr kǝr nǝ uya akkǝri nǝ sǝ zǝzǝwa. ");
INSERT INTO mfm_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Ta a ɗari a thlǝkanar ˈya culi nǝ mambǝl wu hyi, aˈyi ˈya kyaga faˈa sǝr sǝm sara ara hyi wa? ");
INSERT INTO mfm_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Ma hya vǝr dlǝwa alenyi njira vǝr tǝtǝlna ndǝr Hyal anǝ hyi, aˈyi ˈya kyaga uya dlǝwa dzǝ ara hyi a ndiya nda wa? Ama naˈyi na kǝl hya mǝl abangau anǝ ˈya mai. Arya a ndiya anǝ ˈya, ˈya sǝsǝˈwuri kalar sau, a sara ˈya shili ǝnga sǝr da lagu anǝ Ndǝshigu nǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Aˈyi hyu sǝni abǝr ya kalar ndǝra vǝr mǝl thlǝr wu Ki Hyal ju uya sǝr sǝm nyi wu lǝr sǝ kǝra nji tsǝmiya wu Ki Hyal kǝ wa? Ənga aˈyi njira vǝr mǝl thlǝr ar bagadi tsu, nda vǝr uya sǝr sǝmǝr nda wu sǝra nju thla ar bagadi kǝ tsu wa? ");
INSERT INTO mfm_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Abangǝ nga nyi tsu, Hyal nana abǝr kalar ndǝra vǝr tǝtǝlna ndǝshigu ja uya dlǝwa dzau sara ara njira vǝr sǝm barka ndǝshigwa nyi. ");
INSERT INTO mfm_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Wu patǝkura nyi nayi saya taˈyi ar kǝra sǝra kyaga yi mai. Aˈyi ya vǝr ndǝr kau abǝr aga nja mǝl anǝ ɗa abangǝ mai. Nǝ jirkura nyi a ndiya anǝ ɗa ya tau a mwara ya tini ɓwadzǝ nǝ tǝtǝlna ndǝshigu kau, ");
INSERT INTO mfm_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","alaga kǝ tǝtǝlna ndǝshigu aˈyi ɗa sǝr ɓwadzǝ anǝ ɗa mai. Arya Hyal ngǝ tsǝkur ɗa aga ya mǝl. Sǝr tǝhuɗǝu anǝ ɗa ma aˈyi yi tǝtǝlna ndǝshigu mai. ");
INSERT INTO mfm_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Ma sǝ kǝ ya vǝr mǝl kau, wu dǝnamar kǝrɗa nga ja, ya kyaga yiwu gal nja kina ɗa. Ama ma sǝ kǝ ya vǝr mǝl kau, wu dǝnama kǝrɗa nga nyi mai, Hyal ǝnga kǝrnyi ngǝ nǝ ɗa sǝr mǝl. ");
INSERT INTO mfm_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Mi ngǝ akkǝri ɗa ja? Lagu kǝra yu uya aga ya tǝtǝlna ndǝshigu gǝra dlǝwu gǝnna a gwa, ca ngǝ akkǝri ɗa. Ca ngǝ sǝra ɗa, aˈyi ya vǝr yiwa sǝra tsaˈa aga yi mai. ");
INSERT INTO mfm_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Alaga kǝ kambǝr kǝrɗa nga yau, aˈyi yi ǝgya kiɗa ndǝ mai, ama yi mǝliya kǝrɗa mafa anǝ nji patǝu aga ya shabiya nji gangǝ a shili ara Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Ma yi wu pama njir Yahudiya ba ya ɗa ǝnggǝr njir Yahudiya aga ya shabiya nda shili wu Kǝrsiti. Ma yi ǝkkǝˈyi njira vǝr nu dlaɗǝ njir Yahudiya ba ya nggya ǝgya kiɗa dlaɗǝr nda alaga kǝ aˈyi yi ǝgya kiɗa dlaɗǝ mai. Ya vǝr mǝl abangau aga ya hǝbiya njira ǝgya kiɗa dlaɗau a shili ara Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Ma ya vǝr nggya ǝkkǝˈyi njira gǝra sǝni Hyal njira gǝra nu dlaɗǝ nǝ njir Yahudiya, nayi tsu ba ya ɗa ǝnggǝr njira gǝra vǝr nu dlaɗau, ama wu patǝkura nyi, nayu shini nyi yi anǝ dlaɗǝ Hyal mai, ya vǝr ɓǝlari dlaɗǝ Kǝrsiti, aga ya tǝɗǝr nda a shili ara Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Ma yi ǝkkǝˈyi njira tǝtǝwa ba ya ɗa ǝnggǝr njira tǝtǝwa, aga ya sǝn shabiya nji tǝtǝwa a shili wu Kǝrsiti. A ɗar yi kalar sau anǝ kalar nji aga ya shabiya alenyi nji a shili wu mbǝɗau alaga abari. ");
INSERT INTO mfm_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Patǝr sǝra ya vǝr mǝl kau, aga ya tǝtǝlna ndǝshigu nga nyi ba aga ya dzǝgwa jigǝwa dzau wu barka nyi. ");
INSERT INTO mfm_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Aˈyi hyu sǝni abǝr njira vǝr hwi pǝpǝra gangǝ nga nda, ama kǝl ndǝ zǝmǝ ngu nda uya sǝmku tǝlkur wa? Pǝpǝra mǝ mǝnahǝu aga uya sǝmku tǝlkur. ");
INSERT INTO mfm_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Kalar njir pǝpǝra ndu hwathliya dza nda mǝnahǝu. Ndǝ hwathliya dza nda kau, aga nda uya akkǝri kǝra gǝra sǝkari. Ama namǝn nǝr mǝn, mǝnu mǝl aga mǝna uya akkǝri kǝra wu nggya baˈanuwa. ");
INSERT INTO mfm_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Ya vǝr hwi ɗa aˈyi ǝnggǝr ndǝ kǝra gǝra jigadǝma mai. Kwakwadzǝ ɗa aˈyi ǝnga yambaɗǝ nga ya vǝr mǝl mai. ");
INSERT INTO mfm_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","Ama ya vǝr hwathlǝ dza yau ǝnggǝr kǝra njir gwa hwi pǝpǝra wu mǝl, aga ya gǝliya kǝrɗa. A sara ja ɗa ayukuɗa yi tǝtǝlna ndǝr Hyal ba ya nda tini uya akkǝri ɗa. ");
INSERT INTO mfm_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Hya sara fari ǝnga nggyar ǝjir mǝn kǝra saya ɗa a gwar tagǝ mashi ta mai, wazha ama. Patǝkura nda ndǝ ɓau ǝgya kiɗa dlama kǝra a vǝr ca lagu anǝ nda, ǝnga patǝkura nda tsu ndǝ ɓau kǝ ndǝ tǝrabiya a gwar tsadau. ");
INSERT INTO mfm_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Wu dlama ǝnga wu tsadau nga nji hǝr nda baɓǝtizǝma aga nda ɗa njir nu Musa. ");
INSERT INTO mfm_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Patǝkura nda, ndǝ sǝm sǝr sǝm culi zǝm sara dagǝ Hyal, ");
INSERT INTO mfm_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ǝnga patǝ nda tsu ngǝ sa ˈyimi culi zǝm sara dagǝ Hyal. Ndǝ sa ˈyimi kau, sara wu mǝ kǝra a vǝr maˈyi ǝkkǝˈyi nda, mǝ sara dagǝ Hyal kǝra ca ngǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Alaga abangau, huɗa Hyal aˈyi pipida ǝnga badǝgala nda mai, ca ngǝ sǝra ɗa ji dlǝdlǝna nda zǝrɓǝ a gwar tagǝ mashi. ");
INSERT INTO mfm_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Sǝˈyar kǝ ɗarkǝr aga tǝɗar himiya mǝn, a sara mǝna caguli aga mǝl sǝ ɗǝmwaˈyi mai ǝnggǝr kǝra ndǝ mǝl ta. ");
INSERT INTO mfm_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","A sara hya ɗa njir nu katǝu, ǝnggǝr kǝra alenyi nji wu pama nda mǝl ta mai. Ənggǝr kǝra lǝkakaɗǝ nana, abǝr, “Ndǝ caguli, ndǝ gu mini, ǝnga ba ndǝ gu fǝl nǝ sǝsukur.” ");
INSERT INTO mfm_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","A sara mǝna mǝl sǝsukur ǝnggǝr kǝra alenyi nji saya mǝl ta mai, kǝra shili ǝnga asar tau, kǝra dlǝna nji dubu mǝthlǝkumunyi apǝ makǝru wu pǝci pathlǝu. ");
INSERT INTO mfm_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","A sara mǝna fuwa Thlagǝu wu dzǝ mai, ǝnggǝr kǝra alenyi nji fuwa nyi wu dzau, kǝra mǝliya pabǝ ngganggalǝna nda kǝ ndǝ tau. ");
INSERT INTO mfm_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","A sara mǝna jijiga miya ǝnggǝr kǝra alenyi nji mǝl ta mai, ndǝ jijiga miya ba waladi tau shida ka sa dlǝdlǝna nda. ");
INSERT INTO mfm_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Sǝˈyar kǝ ɗarkǝr anǝ nda aga ja ɗa sǝr highiɓau. Nji tsǝfǝya nda aga ja tǝɗar himiya mǝn, namǝn njira vǝr nggya lǝhǝu wu shilir jomǝ nǝ zaman. ");
INSERT INTO mfm_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Agabangau, ma gǝ nggani abǝr a taˈyir gǝ ɓaɓalu, ga hangǝkal ga sara dla. ");
INSERT INTO mfm_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Dzǝ aˈyi kǝra gǝ gu gwa, kǝra pamǝ a mwara kǝra nju tǝrabiya a gwa mai. Arya Hyal ndǝra tsaˈa miya ɗǝfu ngau, ju piyari dzǝbiya dzau kǝra wu ndiya dǝnama ngǝ mai. Ma gǝ gu dzǝbiya dzau, ju canǝ ngǝ lagur biya aga ba ga sǝsǝˈwuri. ");
INSERT INTO mfm_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Agabangau, nahyi bazhir ˈwa ɗa ˈyar, hya hwi ara nu katǝu. ");
INSERT INTO mfm_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Ya vǝr ndǝr anǝ hyi, nahyi njir jigadǝma. Ɗǝngabiya mǝ sǝ anǝ kǝrhyi mǝnahǝu, tara sǝ kǝ ya vǝr na kau jijiri nga ja. ");
INSERT INTO mfm_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Ma mǝn sa wu kyakiwa nǝ barka, kǝra mǝn wu kǝdi Hyal aga ja fǝnggǝr barka ar kǝri, aˈyi mǝn daɓǝya dzau wu mashi Kǝrsiti kǝ wa? Ənga ma mǝn ɓǝɓǝlǝwa macikǝl nǝ Thlagǝu kǝ mǝn sǝmku, aˈyi mǝn daɓǝya dzau wu dza Kǝrsiti kǝ wa? ");
INSERT INTO mfm_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Ta ɗa macikǝl kǝ zǝmǝ nga ja, namǝn kǝra gangǝu, a ɗar mǝn dzǝ zǝmǝ tsu, arya patǝkura mǝn, a sǝmǝr mǝn sara wu macikǝl kau. ");
INSERT INTO mfm_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Hya ɗǝngabiya sǝ ar kǝra njir Izirayila. Ar pǝcira ndǝ sǝm sǝr sǝm kǝra nji thlana ar bagadi kau, saɗaka kǝ aˈyi mǝliya nda ndǝ ɗa njir mǝl sǝ zǝmǝ wa? ");
INSERT INTO mfm_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Mi nga yu yiwu ya na? Abǝr sǝra nji thlana nyi anǝ katǝ aˈyi ja ar viya vanyi sǝ ya? Əndǝga katǝ ǝnga kǝrnyi aˈyi ja ar viya vanyi sǝ ya? ");
INSERT INTO mfm_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Awau, alaga kushu, ya vǝr na abǝr sǝra nji thlana nyi anǝ katǝu, nǝ mambǝl ɗǝmwaˈyi ngau, aˈyi nǝ Hyal ngǝ mai. Agabangau, yu yiwu hya ɗa njir nu mambǝl ɗǝmwaˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Nagǝ wu sǝn sa sara wu kyakiwa nǝ Thlagǝu, ba ga ɓǝra sa sara wu kyakiwa nǝ mambǝl ɗǝmwaˈyi mai. Nagǝ wu sǝn sǝm sara wu sǝr sǝm nǝ Thlagǝu, ba ga ɓǝra sǝm sara wu sǝr sǝm nǝ mambǝl ɗǝmwaˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Mǝn wu yiwu mǝna hyaˈa par maɗǝkur anǝ Thlagǝ ya? Hyu nggani abǝr hyu ndiya nyi ǝnga dǝnama ya? ");
INSERT INTO mfm_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","Alenyi nji wu pama hyu na, abǝr, “A piyari mǝnǝr nji mǝna mǝl kalar sau,” ama aˈyi kalar sǝ ngǝ ǝnga dlǝwa dzǝ mai. “A piyari mǝnǝr nji mǝna mǝl kalar sau,” ama aˈyi kalar sǝ nga sǝn cakǝr ndǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Ga sara gal kǝl sǝra tsaˈa anǝ kǝrngǝ mai, ama sǝra tsaˈa anǝ kuvwa ngǝ tsu. ");
INSERT INTO mfm_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","A sǝn sǝm gǝ kalar kum kǝra gǝ uya ar sugu ǝnga kǝr papal, aˈyi kǝl gǝ yiwabiya tara sara mani nga nyi shili mai. ");
INSERT INTO mfm_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Arya ndǝr Hyal na, “Duniya kau, nǝ Thlagǝ ngau ǝnga kalar sǝra a gwa.” ");
INSERT INTO mfm_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Ma ndǝra aˈyi ndǝr nu mai ngga ngau aga sǝm sǝr sǝm, kǝ gǝ hǝnggǝri, ga sǝm kalar sǝra ji fiya a mwa ngau, aˈyi kǝl gǝ yiwabiya sǝ a gwa mai, ara ga sara ɗa ǝnga gǝra kǝr papal. ");
INSERT INTO mfm_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Ama ma vanyi ndǝ nar ngau, abǝr, “Sǝr sǝm kǝ anǝ katǝ nga nji thlana,” ga sara sǝm mai, arya ɗǝnga ndǝra na sǝ kau anǝ hyi ǝnga tsu aga ja ɗa ǝnga kǝr papal. ");
INSERT INTO mfm_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Sǝra ya vǝr na kau, ca ngǝ nggya kǝr papal nǝ vanyi ndǝ kau, aˈyi nǝ ngǝ mai. Ara mi ngǝ kambǝkur ɗa a sǝn kar nggya kǝr papal anǝ nda? ");
INSERT INTO mfm_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Ma yi dlǝwuri sǝr sǝm wu usaku anǝ Hyal kǝ yi sǝmku, ara mi nga hyu ɓǝra vazǝ ɗa? ");
INSERT INTO mfm_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Agabangau, kalar sǝra hyu mǝl alaga sǝm ǝnga sa, hya mǝl aga kadakadarkur nǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Ga sara ɗa sǝr thlǝ hi anǝ ndǝ mai, tara njir Yahudiya alaga njira aˈyi njir Yahudiya mai ǝnga alaga daɓǝ dzǝ njir nu. ");
INSERT INTO mfm_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Nayi ǝnga kǝrɗa ya vǝr mǝl kalar sau aga ya pina huɗa kalar ndau. Aˈyi sǝra wu pina huɗa kǝrɗa mai, ama sǝra mǝnahǝu anǝ nji gangǝu, aga nji nda uya mbǝɗau. ");
INSERT INTO mfm_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Faˈabiya mǝ hiya yau ǝnggǝr kǝra yi faˈabiya hiya Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Ya vǝr fal hyi arya nahyi fari ɗa mai, ǝnga hya vǝr nu sǝra yi highiɓǝr hyi patǝu, ǝnggǝr kǝra yi highiɓǝr hyi. ");
INSERT INTO mfm_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Ama sǝ aˈyi kǝra yu yiwu hya sǝni. Ndǝra dǝgal ar kǝra kalar sal ca ngǝ Kǝrsiti, ndǝra dǝgal ar kǝra mala tsu ca ngǝ sal nyi, ǝnga ndǝra dǝgal ar kǝra Kǝrsiti ca ngǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Kalar sal kǝra a vǝr kǝdi Hyal ǝnga na ndǝrhaha ǝnga kǝra ja zazaɗau, a diɗanar ja kǝra ja. ");
INSERT INTO mfm_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Ənga kalar mala kǝra a vǝr kǝdi Hyal ǝnga na ndǝrhaha ǝnga kǝra ja papahau, a diɗanar ja kǝra ja, kakal ǝnggǝr a sǝnar ja shishir kǝra ja. ");
INSERT INTO mfm_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Ma mala aˈyi mbana kǝra ja mai, kǝl ba ja sǝna shishir kǝra ja. Ama ma ɗa sǝ sǝsǝli anǝ nyi ma ji sǝna shishir kǝra ja kau, ya ba ja zaɗǝr kǝra ja. ");
INSERT INTO mfm_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Sal ja sara zaɗǝri kǝra ja mai, arya sal shangguɗa Hyal ngau ǝnga naja nga vǝr cabiya kadakadarkur nǝ Hyal. Mala tsu ju cabiya kadakadarkur sal. ");
INSERT INTO mfm_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Arya ndǝ sal nǝ tanggǝrma aˈyi ji biya sara wu mala mai, ama mala ngǝ biya sara wu ndǝ sal. ");
INSERT INTO mfm_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Sal aˈyi nji mǝl nyi anǝ mala mai, ama mala nji mǝliya nyi anǝ sal. ");
INSERT INTO mfm_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Arya kau, mala ja zaɗǝr kǝra ja, kǝra wu cabiya anǝ waladi ǝnga nji abǝr ǝgya kiɗa sal nga ja. ");
INSERT INTO mfm_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Wu Thlagǝu, mala aˈyi ja ar kǝrnyi mai, sal tsu aˈyi ja ar kǝrnyi mai. ");
INSERT INTO mfm_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Ənggǝr kǝra mala tanggǝrma biya sara wu ndǝ sal, sal tsu mala ngǝ yabiya nyi, ama patǝr nji sara wu Hyal ǝnga ndǝ biya. ");
INSERT INTO mfm_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Hya tsambiya, a ɗar tsaˈa anǝ mala ja kǝdi Hyal ǝnga kǝra ja papahǝ ya? ");
INSERT INTO mfm_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Aˈyi hyu sǝnbiya abǝr ma ndǝ sal piyari shishir kǝra ja tumǝu, a ɗar sǝ sǝsǝli anǝ nyi wa? ");
INSERT INTO mfm_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Aˈyi piyari shishi tumǝ ar kǝr ca ngǝ wu shili ǝnga kadakadarkur anǝ mala wa? Arya a nǝ ndar nji shishi tumǝu, aga ja ɗa sǝr zaɗǝ kǝr anǝ nda. ");
INSERT INTO mfm_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Ma ndǝra kǝpal abǝr sǝ kǝ aˈyi ɗa tsaˈa anǝ nyi mai, ya nar nyi abǝr vanyi highiɓǝ aˈyi kǝra ˈyu sǝni a ndiya kǝ mai, abangǝ nga nyi anǝ patǝr daɓǝ dzǝ njir nu tsu. ");
INSERT INTO mfm_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Wu highiɓǝ kǝra yu lǝ anǝ hyi kau, sǝ aˈyi ya sǝn faliya hyi ar kǝri mai, arya ma hyu daɓǝ dzau aˈyi aga mǝnahǝkur mai, ama aga ɗǝmwaˈyikur nga nyi. ");
INSERT INTO mfm_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Sǝ tanggǝrma, ya vǝr nggari abǝr ma hyu daɓau ar viya daɓǝ dzǝ njir nu, pamǝpamǝkur aˈyi wu pama hyi. Ndǝra nyi tsu, ǝnggǝr jiri aˈyi a gwa kukushu. ");
INSERT INTO mfm_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Jijiri kǝl pamǝpamǝkur a ɗa wu pama hyi kabangǝkau, aga nja sǝnbiya njira Hyal dlǝwuri wu pama hyi. ");
INSERT INTO mfm_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Ma hyi daɓau aga sǝr sǝm Thlagǝu, aˈyi sǝr sǝm Thlagǝ nǝ jijiri nga hyu sǝm mai. ");
INSERT INTO mfm_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","Arya alenyi nji wu hyi ndu caguli aga sǝm nǝr nda sǝr sǝm, gǝra nga sǝkǝ alenyi nji. Arya kau, ba alenyi nji a sha a ndu ki ǝnga wuɓau ama alenyi nji tsu nyinyau, nyi ǝnggǝr ǝnga padlau. ");
INSERT INTO mfm_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","Mi ngǝ abangǝ ja, ki aˈyi ara hyi kǝra hyu sǝm ǝnga sa a gwa wa? Əndǝga hyu yiwu hya diɗana daɓǝ dzǝ njir nu Hyal ǝnga hya hǝna sǝli njira gǝra sǝ ara nda ya? Mi nga ya sǝn na ja? Abǝr aga ya faliya hyi abǝr hyi mǝliya sǝ mǝnahǝ ya? Yu fal hyi alaga kushu mai. ");
INSERT INTO mfm_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Sǝra yi dlǝwuri ara Thlagǝ ǝnga kǝrnyi ca nga yi nǝr hyi kau, ǝvuˈyi kǝra nji pǝlna nyi pǝzhi, kǝ Thlagǝ Yesu hǝri macikǝl, ");
INSERT INTO mfm_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","kǝ ji lǝr usaku anǝ Hyal, ba ji ɓǝɓǝlǝwa, kǝ ji nǝ nyi anǝ zǝmbǝlma nyiˈyar, ji na, “Najakau, kumur dza yi ngau, kǝra nji lǝri aga hyi, mǝla mau abangau, aga hya ɗǝngari ǝnga yau.” ");
INSERT INTO mfm_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Abangǝ tsu nga ji hǝri kyakiwa ˈyimir wur inabi, ayukuɗa sǝr sǝm nǝ wagǝu, kǝ ji na, “Kyakiwa kau, naja ngǝ alkawal mbamba mafǝliyangǝ kǝra Hyal mbiya ǝnga mashi ɗa. Mǝla mau abangau, kalar pǝcira hyu sa sara wu kyakiwa kau, hya sa, aga hya ɗǝngari ǝnga yau.” ");
INSERT INTO mfm_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Kalar pǝcira hyu sǝm macikǝl kau, ǝnga hyu sa sara wu kyakiwa kau, hya vǝr hǝˈuna tǝr Thlagǝu, kǝl ji ɓǝra sha a shili. ");
INSERT INTO mfm_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Kalar ndǝra sǝmku macikǝl ǝnga sa sara wu kyakiwa wu lagu kǝra gǝra shili ǝnga gǝnggǝr nyi sili anǝ Thlagǝu, a mǝliyar ja bikǝ anǝ dzǝ ǝnga mashi Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Ca ngǝ sǝra ɗa kǝl ndǝ a tsambiya kǝrnyi mǝnahǝu kadivira ja dzǝgwa sǝm macikǝl ǝnga sa sara wu kyakiwa. ");
INSERT INTO mfm_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Ma nangǝ ndǝ kǝra sǝm ǝnga sa, ma aˈyi gǝ ndǝra hakǝra dza Kǝrsiti mai, a sǝmkur gau ǝnga sahur gǝ numa nǝ Hyal anǝ kǝrngau. ");
INSERT INTO mfm_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Ca ngǝ sǝra ɗa nji gangǝu wu pama hyi ɗa kukufǝu ǝnga nji gangǝu wu pama hyi uya shilgǝu, ǝnga alenyi nji tsu tǝnakǝr. ");
INSERT INTO mfm_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Ama ma mǝn tsambiya kǝrmǝn ǝnga jiri, tsu vanyi numa wu ɓǝra ɗa ar kǝra mǝn mai. ");
INSERT INTO mfm_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Ma Thlagǝ nga vǝr mǝl numa anǝ mǝn, namǝn tsu mǝn wu uya hwathlau, a sara nja nda thlana mǝn numa ǝkkǝˈyi njir duniya. ");
INSERT INTO mfm_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Nahyi wazha ama, ma hyu daɓau aga hya sǝm sǝr sǝm nǝ Thlagǝu, bǝgǝ hya sǝkǝbiya kǝrhyi. ");
INSERT INTO mfm_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Ma wuɓǝ a vǝr tǝ ngau, ga sǝm sǝr sǝm a ndu ki kwatahǝu, a sara daɓǝ dzǝr hyi ja shili ǝnga numa a da gǝra hyi. Ma yi sha shili, ba ya sa dǝgabiya hyi alenyi sǝ kǝra hyau, sǝr mǝl. ");
INSERT INTO mfm_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Ar kǝra lǝ sǝ lǝlǝ nǝ Mambǝl Cici ja, wazha ama, yu yiwu hya nggya ǝnga fǝɗǝngǝkǝr mai. ");
INSERT INTO mfm_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Hyu sǝni ar pǝcira hyi gǝra njir nu Hyal, pǝci gangǝu, nji nggutana hyi aga hya cana lagu nǝ jijiri aga hya nu katǝ kǝra gǝra ǝnga pi. ");
INSERT INTO mfm_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Agabangau, yu yiwu hya sǝni abǝr, ma ndǝra na abǝr, “Yesu ndǝ shishiˈwu ngau,” nda nyi aˈyi wu ndǝr lagu Mambǝl Hyal mai. Ətsu ma ndǝra na abǝr, “Yesu Thlagǝ ngau,” lagu Mambǝl Cici ngǝ ndǝ ka vǝr ndǝr. ");
INSERT INTO mfm_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Lǝ sǝ lǝlǝ pamǝpamǝ gangǝ aˈyi, ama Mambǝl zǝmǝ kǝ ngu lau. ");
INSERT INTO mfm_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Thlǝr Hyal pamǝpamǝ gangǝ aˈyi tsu, ama anǝ Thlagǝ zǝmǝ nga nju mǝl. ");
INSERT INTO mfm_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Ənga thlǝr mǝl pamǝpamǝ aˈyi gangǝ tsu, ama Hyal zǝmǝ kǝ ngu lǝ dǝnama anǝ nda patǝu. ");
INSERT INTO mfm_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Lǝ sǝ lǝlǝ nǝ Mambǝl nga nji nǝ nyi anǝ kalar ndǝ aga mǝna uya sǝra mǝnahǝu a gwagwa. ");
INSERT INTO mfm_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Anǝ vanyi ndǝ nji nǝ nyi lagu Mambǝla nyi highiɓǝ nǝ hahangǝkur, ǝnga anǝ vanyi ndǝ tsu, lagu Mambǝla nyi nga nji nǝ nyi highiɓǝ nǝ sǝnbiya sau, ");
INSERT INTO mfm_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","ǝnga anǝ vanyi ndau, mbǝrsa lagu Mambǝl kau, ǝnga anǝ vanyi ndǝ tsu, lǝ sǝ lǝlǝ nǝ shilǝgǝbiya ndǝ lagu Mambǝla nyi, ");
INSERT INTO mfm_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","ǝnga anǝ vanyi ndǝ tsu, dǝnama mǝl sǝ dǝdǝgur, ǝnga anǝ vanyi ndǝ tsu, na ndǝrhaha, ǝnga anǝ vanyi ndau, sǝnbiya pamǝpamǝkur nǝ mambǝlˈyar, ǝnga anǝ vanyi ndǝ tsu, ndǝr ǝnga ɗahǝ miya pamǝpamǝu, ǝnga anǝ vanyi ndǝ tsu, shabiya ndǝr ɗahǝ miya pamǝpamǝu. ");
INSERT INTO mfm_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Patǝ sǝˈyar kau, Mambǝl zǝmǝ kǝ nga vǝr lau anǝ kalar ndau, tsatsaˈa ǝnggǝr kǝra ju yiwu. ");
INSERT INTO mfm_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Ənggǝr kǝra dzǝ zǝmǝ ngau, ǝnga gashal gashal gangǝu, alaga kǝ gashal gashal aˈyi gangǝ ama dzǝ zǝmǝ nga nda. Abangǝ tsu nga nyi wu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Ara nji mǝliya mǝn baɓǝtizǝma patǝ lagu Mambǝl zǝmǝu, a vu dzǝ zǝmǝu, alaga njir Yahudiya, ǝnga njira aˈyi njir Yahudiya mai, alaga mafaˈyar ǝnga kambǝr nji, patǝkura mǝna dlǝwuri mǝn Mambǝl zǝmǝ kau. ");
INSERT INTO mfm_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Dzǝ aˈyi gashal zǝmǝ mai, ama gashal gashal gangǝu. ");
INSERT INTO mfm_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Ma hi sǝn na, “Arya nayi aˈyi tsi mai, aˈyi yi gashala dzǝ mai,” aˈyi a sǝn mǝliya nyi ja ɗa pamǝ ara dzǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","Ma himi sǝn na tsu, “Arya nayi aˈyi li mai, aˈyi yi gashala dzǝ mai,” aˈyi a sǝn mǝliya nyi ja ɗa pamǝ ara dzǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Maja bǝr dzǝ ɗa patǝ li, lagu mani nga mǝn wu nggar sa? Maja bǝr dzǝ ɗa patǝ himi, lagu mani nga mǝn wu thlar sa? ");
INSERT INTO mfm_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Nggara mǝ ja, Hyal ngǝ pǝdlǝya gashal aga dzau, kalara nda ǝnggǝr kǝra ju yiwu. ");
INSERT INTO mfm_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Maja bǝr dzǝ gashal zǝmǝ ngau, ǝmani ngǝ dzǝ wu dzǝgwa ɗa? ");
INSERT INTO mfm_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Ama jijiri gashal gashal aˈyi gangǝu, ama dzǝ zǝmǝ pathlǝ nga ja. ");
INSERT INTO mfm_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Li aˈyi wu sǝn na anǝ tsi, abǝr “Dzau ɗa aˈyi ǝnga gǝ mai!” Ənga tsu kǝr aˈyi wu sǝn na anǝ hi abǝr, “Dzau ɗa aˈyi ǝnga hyi mai!” ");
INSERT INTO mfm_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Abangǝ nga nyi mai, gashal gashal kǝra hyu nggani nanda ngǝ kukufǝ kau, sǝ aˈyi nja sǝn mǝl gǝra ǝnga nda mai. ");
INSERT INTO mfm_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","Gashal gashal kǝra mǝn wu hǝri aˈyi nda ǝnga kadakadarkur gagaɗǝ mai, nanda nga mǝn wu har nda zhaɓi mǝnahǝu. Abangǝ tsu, gashal gashal kǝra nja kyaga lari ar babal mai, ca nga mǝna shir mǝnahǝu, ");
INSERT INTO mfm_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","ama gashal gashal kǝra ar babal, nji aˈyi wu shi nda mai. Ama Hyal ǝnga kǝrnyi ngǝ daɓǝri gashal gashalˈyar kǝ patǝ abangau, aga kalar gashal gashal kǝra gǝra ǝnga kadakadarkur nda uya. ");
INSERT INTO mfm_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","Hyal ngǝ mǝliya abangau, ara pamǝpamǝkur a sara ɗa wu dzau, aga kalar gashal gashal nda dlǝwar kǝrnda wu lagu zǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","Ma gashal zǝmǝ gu ɓwaɓwatǝu, patǝr gashal gashal ngǝ gu ɓwaɓwatǝ kǝ ǝkkǝˈyi ja. Ma gashal zǝmǝ uya wahau, patǝr gashal gashal nga caguli ǝni. ");
INSERT INTO mfm_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Nahyi, dza Kǝrsiti ngau, ǝnga kalar ndǝ wu pama hyi ar viya gashal ngau. ");
INSERT INTO mfm_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","Hyal ǝnga kǝrnyi a caɗǝbiyar ja nji wu daɓǝ dzǝ njir nu, tanggǝrma ca ngǝ, cama sǝsǝˈyar, mǝthlǝkura nyi ca ngǝ, nabiˈyar, nǝ makǝrkura nyi ca ngǝ malǝmˈyar, ǝnga njir mǝl sǝ dǝdǝgur, ǝnga njir shilǝgǝbiya nji, ǝnga njir dlǝwa nji, ǝnga njir tǝɗǝmwa, ǝnga njir ndǝr ǝnga ɗahǝ miya pamǝpamǝˈyar. ");
INSERT INTO mfm_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Patǝr nji ngǝ cama sǝsǝˈyar ya? Patǝr nji ngǝ nabiˈyar ya? Patǝr nji ngǝ malǝmˈyar ya? Patǝr nji ngu sǝn mǝl sǝ dǝdǝgur ya? ");
INSERT INTO mfm_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","Patǝr nji ngu sǝn uya lǝr sǝ nǝ shilǝgǝbiya nji ya? Patǝr nji ngu sǝn ndǝr ǝnga ɗahǝ miya pamǝpamǝˈyar ya? Patǝr nji ngu sǝn shabiya ndǝr ɗahǝ miya pamǝpamǝ ya? ");
INSERT INTO mfm_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","Ama sǝr cim ca ngǝ ga uya lǝ sǝ lǝlǝ kǝra ndiya. Nayi tsu yu nda cabiya hyi lagu kǝra ndiya patǝu. ");
INSERT INTO mfm_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Ma yu ndǝr ǝnga ɗahǝ miya nji ǝnga ɗahǝ miya waladi, ama yiwudzǝ aˈyi ara yi mai, nayi ǝnggǝr tatangǝ kǝra nju tsa ngau, alaga kangga kǝra wu tiwi ngau. ");
INSERT INTO mfm_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","Ma yu sǝn na ndǝrhaha ǝnga yu sǝnbiya sǝ ar kǝra patǝr sǝra ɗǝɗǝwa ǝnga patǝr sǝnbiya sau, ba ma yi ǝnga mbǝrsa kǝra wu sǝn jahǝna mau, ama yiwudzǝ aˈyi ara yi mai, sǝ kurthlǝ nga yau. ");
INSERT INTO mfm_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Ma yi tǝkǝna kalar sǝra ara yau anǝ nji ɗaɗali, ǝnga ma yi lǝr kǝrɗa aga nja ngyina ɗa ǝnga uˈu, ma yiwudzǝ aˈyi ara yi mai, akkǝri aˈyi kǝra yu uya a gwagwa mai. ");
INSERT INTO mfm_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Yiwudzau ca ngǝ mba ɗǝfu ǝnga kiˈwakur. Yiwudzau, aˈyi ǝnga ɗa shishi mai, ǝnga ɓwadzǝ mai, ba ǝnga hakǝr mai. ");
INSERT INTO mfm_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","Yiwudzǝ aˈyi ǝnga kulangǝkur mai, ba ǝnga yiwu kǝrnyi mai, ǝnga ndzǝ huɗǝ kusakusa mai, ǝnga sǝɓǝ ndu ɗǝfu mai. ");
INSERT INTO mfm_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","Yiwudzau, aˈyi wu caguli wu ɗǝmwaˈyikur mai, ama ju caguli wu jirkur. ");
INSERT INTO mfm_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","Yiwudzǝ wu nggya cimu ǝnga capi, cimu nga ju hǝnggǝri ǝnga nji, cimu nga ja ǝnga fǝr kǝr, cimu nga ja ǝnga sǝsǝˈwu sau. ");
INSERT INTO mfm_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Yiwudzau, wu nggya baˈanuwa. Ndǝrhaha nǝnyi, ju sǝkari mai, ǝnga ndǝr ǝnga ɗahǝ miya pamǝpamǝu tsu, ju tǝrabiya, ǝnga sǝnbiya sǝ tsu, ju kuɗau. ");
INSERT INTO mfm_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","Sǝn sǝr mǝn aˈyi nyabiya dzǝ mai ǝnga ndǝrhahar mǝn tsu, aˈyi nyabiya dzǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","Ama ar pǝcira sǝra gǝra nyau, nyabiya dzau, patǝr sǝra gǝra nyau, wu kwaya ar lagu. ");
INSERT INTO mfm_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Ar pǝcira yi zǝr, yu ndǝr zǝzǝr, ɗǝnga ɗa ǝnggǝr nǝ zǝr, jigadǝma ɗa ǝnggǝr nǝ zǝr kushu. Ama ta yi hau, ba yi pǝna kalar sǝ nǝ zǝrkur. ");
INSERT INTO mfm_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Kabangǝkau, mǝn wu tsamǝ sǝ lǝlǝfuru, ǝnggǝr kǝra mǝn wu tsamǝ sǝ a gwar ˈyimi, ama mǝn wu nda lari sǝ wu bama ǝnga bama camǝ gagaɗau. Kabangǝkau, sǝn sǝ ɗa gashal gashal nga nyi, ama yu nda sǝnbiya sǝ ar babal, ǝnggǝr kǝra Hyal wu sǝnbiya ɗa. ");
INSERT INTO mfm_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","Sǝ makǝr kǝra wu nda nggya baˈanuwa, ca ngǝ mbǝrsa, ǝnga fǝr kǝr ba yiwudzau, ama kǝra ndiya nda patǝu, ca ngǝ yiwudzau. ");
INSERT INTO mfm_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Taˈyi wuɓǝ yiwudzau, a ɗa cimǝr hyi, ǝnga hya ɗa tsu njir cim sǝ lǝlǝ nǝ Mambǝl Cicau, nja na ma hya cim sǝn ndǝrhaha. ");
INSERT INTO mfm_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Arya ma ndǝra vǝr ndǝr ǝnga ɗahǝ miya pamǝpamǝu, nda nyi a vǝr ndǝr ǝnga Hyal, ama aˈyi anǝ ndǝ mai. Ndǝ aˈyi kǝra a vǝr nggari sǝra ju na kǝ mai. Arya sǝra ja vǝr na patǝu sǝ ngau kǝra ar ɗǝwa, ja vǝr na sǝ ɗǝɗǝwa lagu mambǝl nyi. ");
INSERT INTO mfm_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Ama ndǝra vǝr na ndǝrhaha, anǝ nji nga ja vǝr ndǝr aga ja nǝna nda, ǝnga ja tsǝtsǝkur nda, ba ja sǝsǝkuya nda. ");
INSERT INTO mfm_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Ndǝra wu ndǝr ǝnga vanyi ɗahǝ miya pamǝpamǝu, kǝrnyi nga ju la. Ama ndǝr ndǝrhaha,fixed daɓǝ dzǝ njir nu nga ju la. ");
INSERT INTO mfm_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","Cimǝ ɗa ca ngǝ aga patǝkura hyi hya ndǝr ǝnga vanyi ɗahǝ miya pamǝpamǝu, ama yu ndiya ǝnga yiwu hya na ndǝrhaha. Ndǝra wu ndǝrhaha nga ndiya ndǝra wu ndǝr ǝnga ɗahǝ miya pamǝpamǝu, kǝl ma vanyi ndǝ aˈyi kǝra wu sǝn shabiya aga daɓǝ dzǝ njir nu patǝ a nggabiya. ");
INSERT INTO mfm_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","Wazha ama, ma yi shili ara hyi, kǝ yi sa ndǝr ǝnga ɗahǝ miya pamǝpamǝu, abari nga ya sǝn dlǝwar hya, kǝl ma ya sǝn cabiya hyi mǝtakǝr, alaga sǝnbiya sau, alaga na ndǝrhaha alaga highiɓǝ wa? ");
INSERT INTO mfm_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","Alaga sǝ mbimbiɗau ǝkkǝˈyi sǝ tsatsa kǝra gǝra ǝnga pi ǝnggǝr mbǝlaˈwu ǝnga sǝmbǝl, abari nga nju sǝn nggabiya ɗaha nda, aˈyi kǝl nji tǝkǝbiya pamǝpamǝ ɗaha sǝra ndu na wa? ");
INSERT INTO mfm_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","Ma ndǝr mbiɗǝ tǝlǝmǝ pa aˈyi mbiɗiya ǝnggǝr kǝra nju mbiɗǝ nǝ biyar pa mai, wa ngu sǝni abǝr gwa pa nga nja? ");
INSERT INTO mfm_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","Abangǝ nga nyi, ma sǝra gu na wu vanyi miya kǝra nji gǝra nggabiya, abar nga nju sǝn sǝnbiya sǝra gu na? A ndǝrǝr gǝ nǝ kurthlǝu. ");
INSERT INTO mfm_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Ndǝr nǝ miya pamǝpamǝ aˈyi gangǝ wu duniya, kǝra gǝra ǝnga valar dzǝ aˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","Ma aˈyi ya vǝr nggari miya kǝra ga vǝr na mai, ba ya ɗa mǝthlǝpi anǝ ngau, nagǝ tsu mǝthlǝpi anǝ ɗa. ");
INSERT INTO mfm_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","Ənggǝr kǝ nga nyi ar kǝra hyi. Ta ɗa hya vǝr cim lǝ sǝ nǝ Mambǝl, sǝra tsaˈa ca ngǝ hya nǝrdzǝ aga hya hǝ wu lǝ sǝ lǝlǝ kǝra wu hǝna daɓǝ dzǝ njir nu. ");
INSERT INTO mfm_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","Agabangau, ma ndǝ ndǝr ǝnga ɗahǝ miya pamǝpamǝu, ja kǝdi Hyal ja uya dabar nǝ shabiya. ");
INSERT INTO mfm_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","Ma yi kǝdi Hyal wu ɗahǝ miya pamǝpamǝu, mambǝl ɗa ngu kǝdi Hyal, ama ɗǝnga ɗa aˈyi ǝnga dlǝwa dzǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","Mi nga ya kyaga mǝla? Yu kǝdi Hyal ǝnga mambǝl ɗa ǝnga tsu yu kǝdi Hyal ǝnga ɗǝnga ɗa. Yu thlǝ na ǝnga mambǝl ɗa ǝnga tsu yu thlǝ na ǝnga ɗǝnga ɗa. ");
INSERT INTO mfm_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","Ma ga vǝr usaku anǝ Hyal wu mambǝl ya, abar ngǝ ndǝra vǝr sǝhimi ngǝ a sǝn nggabiya ja na, “Amina” aga ja dlǝwubiya sǝra gu na wu lǝ usaku ngau, ma naja aˈyi sǝn nggabiya maya? ");
INSERT INTO mfm_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","Wu sǝn ɗa abǝr a lǝr gǝ usaku anǝ Hyal, ya, lagu mani ngǝ ndǝra vǝr nggar ngǝ wu uya cakǝr dza? ");
INSERT INTO mfm_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","Usaku anǝ Hyal, ara a ndǝrǝr yau ǝnga ɗahǝ miya pamǝpamǝ a ndiya hyi patǝu. ");
INSERT INTO mfm_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","Patǝ abangau, wu daɓǝ dzǝ njir nu a ndiya anǝ ɗa ya nabiya ndǝr kǝra nju nggabiya ɓatsu yiɗau, a ɗa tufu a mwara ya ndǝrna ndǝr dubu kumou ǝnga ndǝr ɗahǝ miya pamǝpamǝu. ");
INSERT INTO mfm_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Wazha ama hya sara ɗǝnga sǝ ǝnggǝr wazha mai. Wu ɗǝmwaˈyikur, hya ɗa ǝnggǝr wazha yiɗǝɗǝu, ama wu ɗǝngar hyi hya ɗa nji nggunggurǝm. ");
INSERT INTO mfm_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","Tsǝtsǝfǝ nga nyi wu lǝkakaɗǝ Hyal abǝr, “Yu nda ndǝr anǝ nji ɗa lagur miya nji pamǝpamǝu, ǝnga miya mǝthlǝpi nga yu ndǝr anǝ nji kau, alaga kǝ nanda wu nda sǝhimi ɗa mai,” ǝngwar Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","Hya sǝni ja, ndǝr ǝnga ɗahǝ miya pamǝpamǝ ja, mǝtsamǝ ngau, aˈyi anǝ njir nu mai ama anǝ njira gǝra njir nu. Ndǝrhaha nǝnyi anǝ njir nu nga nyi, aˈyi anǝ njira gǝra njir nu mai. ");
INSERT INTO mfm_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","Karya, ma patǝr daɓǝ dzǝ njir nu kaɓiya dzau, kǝ kalar ndǝ dzǝguya ndǝr ǝnga ɗahǝ miya pamǝpamǝu, ma njira gǝra nggabiya, alaga njira gǝra njir nu sa thlǝwa hyi ya, aˈyi hyu nggani ndu tsamǝ hyi ǝnggǝr nji bǝbǝla kǝr wa? ");
INSERT INTO mfm_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","Ama ma ndǝrhaha nga hyi patǝ a vǝr na, ma njira gǝra njir nu, alaga njira gǝra nggabiya ngǝ shili, kalar sǝra ji nggari, aˈyi wu tsaviya nyi wu ɗǝfuwa ja ba ja dzǝgwa ɗa ndǝ vavazǝ wa? ");
INSERT INTO mfm_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","Ma ndǝra nggar ndǝr kau, ba sǝ ɗǝɗǝwa nǝ ɗǝfuwa ja pahǝbiya dzau, a biyar babal, ba ja dzǝgwa ɓǝliya undi ju dlǝvǝ Hyal, ba ja na, “Jiri, Hyal aˈyi ja wu pama hyi.” ");
INSERT INTO mfm_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","Mi ngǝ sǝra aˈyi ja wazha ama? Ma hyi daɓǝya dzǝ ar mwa zǝmǝu, alenyi nji aˈyi nda ǝnga na miya fal Hyal, vanyi ndǝ ǝnga nǝ highiɓau, vanyi ndǝ ǝnga sǝn sǝ mǝtakǝr, vanyi ndǝ tsu ǝnga ɗahǝ miya pamǝpamǝu, vanyi ndǝ ǝnga shabiya ɗahǝ miya pamǝpamǝu. Patǝ sǝˈyar kau, nja mǝl aga cakǝ dzǝ daɓǝ dzǝ njir nu. ");
INSERT INTO mfm_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Ma hyu ndǝr ǝnga ɗahǝ miya pamǝpamǝu, a sara nda ndiya nji mǝthlǝ alaga nji makǝr mai, nda ndǝr ndǝ zǝmǝ ayukuɗa ndǝ zǝmǝu, kǝl vanyi ndǝ tsu ja shabiya. ");
INSERT INTO mfm_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Ama ma ndǝ aˈyi kǝra wu sǝni shabiya mai, bǝgǝ nda nyi a nggya ɗiyiwu wu daɓǝ dzǝ njir nu, ja ndǝr anǝ kǝrnyi ǝnga Hyal. ");
INSERT INTO mfm_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","Ma nju ndǝrhaha, nji mǝthlǝ alaga nji makǝr nga ndǝr, taˈyi alenyi nji ka sǝya himi aga nda walbiya sǝra ndu na mǝnahǝu. ");
INSERT INTO mfm_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","Ma Hyal canǝ nyi mǝtakǝr anǝ vanyi ndǝra aˈyi nggya, ndǝra vǝr ndǝr tanggǝrma kǝ ja bǝgau. ");
INSERT INTO mfm_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","Ara patǝkura hyi a sǝn na ndǝrhaha vanyi ndǝ ayukuɗa vanyi ndau, aga kalar ndǝ a highiɓǝr sau ǝnga ja uya tsǝtsǝku ɗǝfu. ");
INSERT INTO mfm_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Njir ndǝrhaha ndu sǝn kǝkǝya kǝrnda. ");
INSERT INTO mfm_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","Arya Hyal aˈyi Hyal nǝ dliya kǝr ngǝ mai. Hyal nǝ nggya jamǝ ngau. Abangǝ tsu wu daɓǝ dzǝ nji cici gǝ Hyal patǝu, ");
INSERT INTO mfm_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","mathlǝkǝˈyi nda nggya ɗiyiwu wu daɓǝ dzǝ njir nu, arya nji aˈyi nǝ nda lagur ndǝr a ndǝna mai, kǝl nda ɗa njir ngga sǝra nji nana, ǝnggǝr kǝra dlaɗǝ Musa nana. ");
INSERT INTO mfm_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","Ma sǝ aˈyi kǝra nda yiwu nda sǝni, ba nda yiwari ara shili a ndu ki, arya sǝ sǝsǝli ngǝ anǝ ndǝ mala ja ndǝr wu pama daɓǝ dzǝ njir nu. ");
INSERT INTO mfm_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","Hyu nggani abǝr ara hyi ngǝ ndǝr Hyal dzǝguya dzǝ ya? Abǝr anǝ hyi wacu nga nji shili ǝni ya? ");
INSERT INTO mfm_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","Ma gu nggani abǝr nagǝ nabi nga gau, ǝnga nyinyi nga gau wu mambǝl, gu kyaga sǝni abǝr sǝ kǝ ya vǝr tsǝfǝ kau, sǝr ɓǝla ngau, sara ara Thlagǝu ǝnga kǝrnyi. ");
INSERT INTO mfm_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","Ma aˈyi ji hǝnggǝri ǝnga sǝ kǝ mai, nju nda hǝnggǝri ǝnga ja tsu mai. ");
INSERT INTO mfm_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","Nahyi wazha ama taˈyi hya ɗa njir cim ndǝrhaha, ama hya sara ka nji ara ndǝr ǝnga miya pamǝpamǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","Taˈyi nja mǝl kalar sǝ ǝnggǝra ja tsaˈa nja mǝl wu lagu nyi tsu. ");
INSERT INTO mfm_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","Kabangǝkǝ tsu wazha ama, yu yiwu ya ɗǝngari hyi ar kǝra ndǝshigu kǝra yi tǝtǝlna hyi, ba hyi dlǝwuri ta, kǝra mbǝrsar hyi taˈyi ari. ");
INSERT INTO mfm_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","Lagu ndǝshigu kǝ nga hyi uya mbǝɗau, ma hyi sǝɓiya ɓaɓalu ndǝr kǝra yi tǝtǝlna hyi. Ma aˈyi ɗa abangǝ mai, mbǝrsar hyi a ɗari sǝ kurthlǝu. ");
INSERT INTO mfm_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","Ara sǝra yi dlǝwuri ca nga yi nǝr hyi ar viya sǝ kǝra ndiya ǝnga mǝnahǝu, abǝr Kǝrsiti a tǝri arya bikǝr mǝn, ǝnggǝr kǝra lǝkakaɗǝ Hyal nana. ");
INSERT INTO mfm_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","Abǝr, nji haɗǝna nyi, ayukuɗa pida makǝru ba ji hyaˈari sara vir tau, ǝnggǝr kǝra lǝkakaɗǝ Hyal nana, ");
INSERT INTO mfm_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","ba ji canǝ nyi kǝrnyi anǝ Kefasu ba anǝ cama sǝsǝ kumo apǝ mǝthlǝ kau. ");
INSERT INTO mfm_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","Ayukuɗa kau, kǝ ji cabiya kǝrnyi anǝ wazha ama kǝra a ndiya gharu tufu aga zǝmǝu, gangǝ wu pama nda aˈyi nda ǝnga pi baˈanǝ kabangǝkau, alaga kǝ alenyi nji a tǝr kau. ");
INSERT INTO mfm_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","Ba ji canǝ nyi kǝr anǝ Yakubu ba anǝ patǝr cama sǝsǝˈyar, ");
INSERT INTO mfm_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","ayukuɗa nyi patǝu, ba ji cabiya ɗa kǝr tsu, nayi ndǝra gǝra tsaˈa ya kyaga lari nyi. ");
INSERT INTO mfm_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","Ara nayi nga ndiya ǝnga kushu wu pama cama sǝsǝˈyar patǝu, ǝnga aˈyi a kyau nja ngga ɗa cama sǝsǝ mai, arya yi lǝr ɓwaɓwatǝ gagaɗau anǝ daɓǝ dzǝ njir nu nǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","Ama lagu mayiwakur nǝ Hyal nga yi sǝra ya ga nyi kau, ǝnga mayiwakur nyi anǝ ɗa, aˈyi sǝ kurthlǝ mai. Awau, a mǝlǝr yi thlǝr a ndiya nda patǝu, alaga kǝ aˈyi nayi ngǝ mǝl thlǝr kǝ ǝnga kǝrɗa mai, ama mayiwakur nǝ Hyal kǝra aˈyi ǝnga yi kau. ");
INSERT INTO mfm_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","Ama aˈyi ɗa vanyi sǝ mai, tara nayi alaga nanda ngǝ tǝtǝlna ndǝshigu kau, ca ngǝ sǝra hyi hǝnggǝri ǝni. ");
INSERT INTO mfm_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","Ta ɗa nja vǝr tǝtǝlna ndǝr Hyal abǝr Kǝrsiti a hyaˈari sara vir tau, ya lagu mani ngǝ alenyi nja vǝr na abǝr hyaˈari sara vir tau aˈyi mai ya? ");
INSERT INTO mfm_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","Maja bǝr hyaˈari sara vir tau aˈyi mai, a cabiyari abǝr Kǝrsiti aˈyi hyaˈari sara vir tǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","Maja bǝr Kǝrsiti aˈyi hyaˈari sara vir tǝ mai, tǝtǝlna ndǝr Hyal kǝra mǝna vǝr mǝl patǝ sǝ kurthlǝ ngau, ǝnga abangǝ tsu ngǝ mbǝrsar hyi. ");
INSERT INTO mfm_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","A biya banga kau, a ɗar mǝn ǝnggǝr njir lǝ sakida nǝ fati ar kǝra Hyal, arya mǝn lǝr sakida ar kǝra Hyal abǝr ji hyaˈana Kǝrsiti sara vir tau. Ama naja aˈyi hyaˈana nyi sara vir tǝ mai, ma jijiri nji aˈyi wu hyaˈari sara vir tǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","Maja bǝr nji tǝtǝ aˈyi wu hyaˈari sara vir tǝ mai, Kǝrsiti tsu aˈyi hyaˈari sara vir tǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","Ənga maja bǝr Kǝrsiti aˈyi hyaˈari sara vir tǝ mai, mbǝrsar hyi a ɗari sǝ kurthlǝu ǝnga tsu, tsu hyi wu bikǝr hyi. ");
INSERT INTO mfm_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","Maja abangau, patǝr njira tǝ wu Kǝrsiti a sar nda. ");
INSERT INTO mfm_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","Maja bǝr fǝr kǝr kǝra ara mǝn wu nggyabiya nǝ kabangǝkau nga nyi wacu, a ɗar mǝn sǝr tǝhuɗǝu a ndiya patǝr nji. ");
INSERT INTO mfm_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","Ama Kǝrsiti a hyaˈari ja sara vir tau, naja ngǝ sǝ nǝ ɗaramwa wu pama njira tau. ");
INSERT INTO mfm_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Ənggǝr kǝra tǝ shili lagu ndǝ zǝmǝu, abangǝ tsu ngǝ hyaˈari a vir tǝ shili lagu ndǝ zǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","Ara ǝnggǝr kǝra mǝn tǝtǝ patǝ wu Adamu, abangǝ tsu kalar ndǝra wu Kǝrsiti ju hyaˈari ǝnga pi. ");
INSERT INTO mfm_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","Ama nju nda hyaˈana kalar ndǝ sara vir tǝ ma pǝci nyi ɗa. Kǝrsiti ngǝ ɗaramwa nǝ hyaˈari sara vir tau. Ar pǝcira ju nda sha shida wu duniya, abangǝ tsu ju sa hyaˈana njira nǝnyi. ");
INSERT INTO mfm_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","Ayukuɗa kǝ ngǝ jomǝ ndǝl a dzǝgwa shili, ar pǝcira ju lǝr tǝlkur anǝ Hyal tada, ayukuɗa ji sana tǝl tǝlˈyar, ǝnga njir sǝm tǝlkur ba patǝr njir dǝnama. ");
INSERT INTO mfm_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","Arya kǝl Kǝrsiti dumwa ǝnga sǝm tǝlkur kǝl ma ji fiya patǝr dawa nyiˈyar ǝgya kiɗa hiya ja. ");
INSERT INTO mfm_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","Dawa kǝra ju nda tsiya ayukuɗǝ patǝu, ca ngǝ tau. ");
INSERT INTO mfm_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","Arya tsǝtsǝfǝ nga nyi wu lǝkakaɗǝ Hyal abǝr, Hyal “a fiyari kalar sǝ ǝgya kiɗa hiya ja.” Ənggǝr kǝra lǝkakaɗǝ nana, “Kalar sau” a fiyar nji ǝgya kiɗa ja. A cabiyari abǝr aˈyi daɓǝ ǝkkǝˈyi Hyal ǝnga kǝrnyi ngǝ ǝgya kiɗa Kǝrsiti mai, ama Hyal ngǝ fiya kalar sau ǝgya kiɗa Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","Ama, ar pǝcira Hyal fiya kalar sǝ a gya kiɗa dǝnama tǝlkur nǝ zǝr nyi, zǝr nyi tsu ba ja fuwa kǝrnyi a gya kiɗa dǝnama tǝlkur nǝ Hyal, aga Hyal ja ɗa a dar kǝra patǝr sau. ");
INSERT INTO mfm_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","Maja bǝr kabangǝkǝ hyaˈari sara vir tǝ aˈyi mai, mi ngǝ nji ka nda mǝla, njira nji hǝr nda baɓǝtizǝma ar viya nji tǝta? Maja bǝr nji tǝtǝ aˈyi ndu hyaˈari sara vir tǝ mai, ara mi nga nju mǝl baɓǝtizǝma arya nda? ");
INSERT INTO mfm_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","Ənga anǝ kǝrmǝn, arya mi nga mǝn wu fǝ kǝrmǝn a miya tǝ arya ndǝr Hyal kalar pǝci ka? ");
INSERT INTO mfm_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","Jijiri nga yu na anǝ hyi wazha ama, ǝnggǝr kǝra ya vǝr ɓwasǝ ǝnga hyi wu Kǝrsiti Yesu Thlagǝr mǝn, bama ǝnga bama nga yi ǝnga tǝ kalar pǝci. ");
INSERT INTO mfm_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","A vu mǝlmǝ Afisa nji shili ǝnga par kǝpal anǝ ɗa ǝnggǝr sǝr tagǝu, ba yi pana pa nyi. Maja bǝr aga kǝrɗa nga yi mǝl, mi ngu nda ɗa akkǝri ɗa? Maja bǝr nji tǝtǝ aˈyi wu hyaˈari sara vir tǝ mai, ya, “Taˈyi mǝna gu mini nǝ sǝm ǝnga sa, arya ǝzǝgǝ ma vanyi ba mǝna sa tau.” ");
INSERT INTO mfm_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","Nja sara ngguta hyi mai! “Arya nggya ǝnga nji papatagǝu wu dla ǝnga nggya papatagǝu.” ");
INSERT INTO mfm_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","Sha mau a shili wu hangǝkalǝr hyi, ba hya piyari mǝl bikau. Ara alenyi nji wu pama hyi aˈyi wu sǝnbiya Hyal mai. Yu na sǝ kǝ anǝ hyi abangǝ aga hya gu sǝli. ");
INSERT INTO mfm_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","Ama ba vanyi ndǝ a yiwa abǝr, “Abari nga nju hyaˈana nji tǝtǝ sara vir ta? Wa thlǝmǝ culi dzǝ kǝra ndu hyaˈari ǝna?” ");
INSERT INTO mfm_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","Wa thlǝmǝ najaka dzakura? Aˈyi hyu sǝni abǝr kalar sǝra nji thlǝkana, aˈyi wu tsǝ mai, kǝl ma ji tǝ kwatahǝ wa? ");
INSERT INTO mfm_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","Ar pǝcira gu thlǝka sau, aˈyi dzǝ kǝra wu nda nggya nga gu thlǝka mai, ama culi nga gu thlǝka, alaga culi uhi ǝndǝga vanyi sǝ pamǝu. ");
INSERT INTO mfm_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","Ama Hyal ngǝ wu lǝ dzau anǝ culi kau, ǝnggǝra ju yiwu ja ɗa. Anǝ kalar culi tsu ba ja nǝ nyi culi dzǝ kǝra tsaˈa aga ja. ");
INSERT INTO mfm_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","Aˈyi patǝr kumǝr dzǝ ngǝ zǝmǝ mai. Pamǝ ngǝ kumǝr dza nji, pamǝ ngǝ nǝ maˈwi, ǝnga pamǝ ngǝ nǝ ˈyagǝˈyar, ba nǝ kalfi tsu pamǝ nga nyi. ");
INSERT INTO mfm_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","Sǝ pamǝpamǝ aˈyi gangǝ kǝra Hyal mǝliya a dǝmǝlmau, ǝnga pamǝpamǝ tsu wu duniya. Ama kadakadarkur nǝ sǝra a dǝmǝlmau pamǝ nga nyi ara kadakadarkur nǝ sǝra wu duniya. ");
INSERT INTO mfm_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","Kadakadarkur nǝ pǝci pamǝ nga nyi, ǝtsu kadakadarkur nǝ hya pamǝ nga nyi, abangǝ tsu ngǝ kadakadarkur nǝ shashilgaˈyar, ǝnga tsu pamǝpamǝ ngǝ kadakadarkur nǝ shashilga a mwara vanyi shashilga. ");
INSERT INTO mfm_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","Abangǝ nga nyi tsu ǝnga hyaˈari sara vir tau. Dzǝ kǝra nju thlǝkana a gyuˈyi wu ɗiya, ama ma ji hyaˈari, ju hyaˈari ǝnga pi kǝra gǝra tau. ");
INSERT INTO mfm_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","Nju thlǝkana nyi a gyuˈyi gǝra ǝnga kadakadarkur, ama ba ja hyaˈari ǝnga kadakadarkur. Nju thlǝkana a gyuˈyi gǝra ǝnga dǝnama, ama ba ja hyaˈari ǝnga dǝnama. ");
INSERT INTO mfm_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","Nju thlǝkana nyi ǝnga kumǝr dzǝ nǝ ndǝndǝkur, ama ba ja hyaˈari ǝnga dzǝ nǝ mambǝl. Ənggǝr kǝra dzǝ nǝ ndǝndǝkur aˈyi, dzǝ nǝ mambǝl aˈyi tsu. ");
INSERT INTO mfm_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","Abangǝ nga nyi tsǝtsǝfau, abǝr, “Ndǝ nǝ tanggǝrma Adamu, ɗa ndǝ ǝnga pi.” Adamu nǝ yukuɗu tsu, naja ngǝ mambǝl nǝ lǝ pi. ");
INSERT INTO mfm_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","Ndǝ nǝ mambǝl aˈyi shili tanggǝrma mai, ama ndǝ nǝ kumǝr dzau, ayukuɗa ta ndǝ nǝ mambǝl dzǝgwa shili. ");
INSERT INTO mfm_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","Ndǝ nǝ tanggǝrma shili sara wu bǝbǝr, ama ndǝ nǝ mǝthlǝkura nyi shida sara dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","Ənggǝr kǝra ndǝra biya sara wu bǝbǝr kau, abangǝ tsu ngǝ kalar njira biya sara wu dza ja, bǝbǝr nga nda. Ənggǝr kǝra ndǝra sara dǝmǝlmau, abangǝ tsu ngǝ kalar njira a dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","Ənggǝr kǝra mǝn pabiya ndǝra sara wu bǝbǝr, abangǝ tsu nga mǝn wu nda pabiya ndǝra shida sara a dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","Sǝra yu na anǝ hyi wazha ama, ca ngǝ kumǝr dzǝ ǝnga mashi aˈyi wu uya faˈa ki nǝ tǝlkur Hyal mai. Abangǝ tsu dzǝ kǝra wu ɗiya, aˈyi wu faˈabiya ki ǝnga dzǝ kǝra gǝra ɗiya mai. ");
INSERT INTO mfm_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","Nggara mau, yu nar hyi sǝra ɗǝɗǝwa! Aˈyi patǝkura mǝn ngu nda tǝ mai, ama nju nda bǝlana dza mǝn patǝu, a ndu dzǝ mafǝliyangǝ, ");
INSERT INTO mfm_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","ǝnggǝrna, ǝnggǝr kǝra ndǝ wu ɗa maci ǝnga li, ma nji nda mbǝɗiya tǝlǝmǝ nǝ jomǝ ndǝl. Tǝlǝm wu nda mbǝɗiya dzau, ba nji tǝtǝ wu Kǝrsiti a hyaˈari ǝnga pi gǝra kuɗau, njira tsu ǝnga pi ar pǝci ta, ba nda bǝlana dzau. ");
INSERT INTO mfm_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Sǝra wu ɗiya, kǝl ji hǝr dzǝ kǝra gǝra ɗiya. Sǝra wu tǝ tsu, kǝl ji bǝlar dzǝ ǝnga sǝra gǝra tau. ");
INSERT INTO mfm_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","Ar pǝcira dzǝ kǝra wu ɗiya nda har dzǝ kǝra gǝra ɗiya, ǝnga dzǝ kǝra wu tǝ har dzǝ kǝra gǝra tau, ar pǝci ta ngǝ ndǝr kǝra tsǝtsǝfǝ wu ɗa jiri, abǝr, “A sǝmkur nji tǝlkur ar kǝra tau.” ");
INSERT INTO mfm_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","“Kara nagǝ tau, ǝmani ngǝ sǝm tǝlkur nga? Tau, ǝmani ngǝ da nga?” ");
INSERT INTO mfm_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","Da nǝ tau, ca ngǝ bikau, ǝnga dǝnama nǝ bikau, ca ngǝ dlaɗau. ");
INSERT INTO mfm_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","Ama usaku anǝ Hyal! Naja ngǝ nǝ mǝn sǝm tǝlkur lagu Thlagǝr mǝn Yesu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","Agabangau, zamǝr ˈwa ɗa ˈyar, hya taˈyi pir ǝnga dǝnama cumu. A sara vanyi sǝ a jahǝna hyi mai. Cumu hya lǝr kǝrhyi aga mǝl thlǝr nǝ Thlagǝu, arya hyu sǝni abǝr nǝrdzǝr hyi wu Thlagǝu, aˈyi wu ɗa sǝ kurthlǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","Ndǝr ar kǝra tsǝm sǝ anǝ nji cici nǝ Hyal, taˈyi hya mǝl ǝnggǝr kǝra yi nar nyi anǝ daɓǝ dzǝ njir nu ˈyar kǝra wu Galatiya nda mǝl. ");
INSERT INTO mfm_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","Kalar pǝci tanggǝrma nǝ sugu, kalar ndǝ ja kyaga fiya tsaˈa sara wu sǝra ji uya sara wu uya nyi, aga ma yi sha shili kǝl hǝri sǝra ˈyi fwatǝu, aˈyi kǝl nji dzǝgwa tsǝm sǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","Ar pǝcira yi sha shili, yu sa sǝwa njira hyi hǝnggǝri ǝnga cama tsǝtsǝfǝ ar kǝra nda, aga nda sa hǝri lǝ sǝ dlǝwa dzǝr hyi a vu Urshalima. ");
INSERT INTO mfm_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","Ma hyi lari a ɗari tsaˈa aga ya maˈyi tsu ba nda lǝbiya ɗa. ");
INSERT INTO mfm_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","Yu ɓǝra nda sha shili ara hyi ayukuɗa yi ɓǝbiya ɓau wu Masidoniya, arya lagu Masidoniya nga yu maˈyi. ");
INSERT INTO mfm_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","A sǝn ɗa yu nda sǝkari ǝkkǝˈyi hyi, ma wu sǝn ɗa ba mǝna hǝbiya vuya kǝ ǝkkǝˈyi hyi, aga hya dlǝwar ɗa wu ɓǝ ɗa kau, kalar vira yu maˈyi a ndari. ");
INSERT INTO mfm_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","Aˈyi yiwu ɗa ngǝ ya lari hyi ba ya tǝrabiya mai, awau, ɗǝfuwa yu yiwu ya sǝkari ǝkkǝˈyi hyi, ma Hyal hǝnggǝri. ");
INSERT INTO mfm_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","Ama yu sǝkari ǝnggau wu Afisa kǝl ma pǝcir Pentikosu shili. ");
INSERT INTO mfm_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","Arya madiya lagu nǝ mǝl madiya thlǝr a pahǝri anǝ ɗa, ama dawa gangǝ a vǝr da laguwa nyi. ");
INSERT INTO mfm_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","Ma Timathlawusu shili, hya nǝ nyi nggya papalkǝr wu hyi, arya ndǝr mǝl thlǝr Hyal nga ja tsu ǝnggǝr nayau. ");
INSERT INTO mfm_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","A sara hya diɗa nyi mai, hya sǝwa nyi wu lagu ǝnga huɗǝ pǝrtǝu aga ja sha shila ara yau. Yu vǝr sǝkǝ nyi, nanda ǝkkǝˈyi wazha ama ˈyar. ");
INSERT INTO mfm_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","Sǝra ya sǝn na ar kǝra Apolusu, ca ngǝ ya vǝr kǝdi nyi ǝnga jirkur aga ja nda tular hyi, naja ǝkkǝˈyi wazha ama, ama naja aˈyi wu yiwu ja shili kabangǝkǝ mai, ama ju nda shili ma ji uya lagu. ");
INSERT INTO mfm_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","Hya nggya liliˈu, hya ciya dzǝ wu mbǝrsar hyi, hya ɗa ǝnga mba ɗǝfu, hya ɗa ǝnga dǝnama. ");
INSERT INTO mfm_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","Kalar sǝra hyu mǝl hya mǝl ǝnga yiwukur. ");
INSERT INTO mfm_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","Wazha ama hya sǝni abǝr njir kir Sǝtifanusu nanda ngǝ njir nu nǝ tanggǝrma nǝ ˈyiˈyir Akaya, a lǝr nda kǝr aga mǝl thlǝr anǝ nji cici gǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","Ya vǝr kǝdi hyi, aga hya lǝr kǝrhyi anǝ culi nji ǝnggǝr kau, ǝnga patǝr njira daɓǝr kǝr ǝnga hyi wu thlǝr kau, ǝnga dǝnamar nda. ");
INSERT INTO mfm_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","Huɗa ya pidari ǝnga shilir Sǝtifanusu, ba Focinatusu ba Achayikusu, arya ndǝ dla ǝnga dlǝwa dzǝ ǝnga sǝra caja ara hyi. ");
INSERT INTO mfm_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","Arya ndǝ mbǝbiya mambǝl ɗa ǝnga nǝr hyi tsu. Culi nji ǝnggǝr kau hya gǝnggǝr nda sǝli. ");
INSERT INTO mfm_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","Daɓǝ dzǝ njir nu ˈyar nǝ ˈyiˈyir Asǝya a vǝr usa hyi. Akwila ǝnga Pǝrsila, ǝnga daɓǝ dzǝ njir nu kǝra wu kir nda, nda vǝr usa hyi gagaɗǝ wu Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","Patǝr wazha ama ˈyar kǝra ǝnggau nda vǝr usa hyi. Hya usar dzau ǝnga bǝrpǝ dzau nǝ yiwukur kǝra cicau. ");
INSERT INTO mfm_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","Nayi Bulusu nga vǝr tsǝfǝ usa dzǝ kǝ ǝnga tsa yau. ");
INSERT INTO mfm_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","Patǝr njira gǝra yiwu Thlagǝu, bǝgǝ nda ɗa nji shishiˈwau. Thlagǝu, shili. ");
INSERT INTO mfm_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","Taˈyi mayiwakur nǝ Thlagǝu Yesu a nggya ǝnga hyi. ");
INSERT INTO mfm_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","Yiwudzǝ ɗa anǝ hyi papatǝu, wu Kǝrsiti Yesu. Amina.");
INSERT INTO mfm_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","Cama tsǝtsǝfǝ kǝ sara ara Bulusu, cama sǝsǝ nǝ Kǝrsiti Yesu lagur yiwur huɗa Hyal ǝnga zamǝr mǝn Timathlawusu kǝra ǝnga yau. Cama kau, anǝ daɓǝ dzǝ njir nu kǝra wu Kwaranthli, daɓǝ ǝnga patǝkura nji cici gǝ Hyal kǝra wu patǝr ˈyiˈyir Akaya. ");
INSERT INTO mfm_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","Bǝgǝ mayiwakur ǝnga huɗǝ pǝrtǝu sara ara Hyal Dǝrmǝn ǝnga Thlagǝ Yesu Kǝrsiti nda nggya ǝnga hyi. ");
INSERT INTO mfm_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","Fal anǝ Hyal, dǝya Thlagǝr mǝn Yesu Kǝrsiti, Tada nǝ dǝgal tǝhuɗǝu ǝnga Hyal nǝ patǝr sǝsǝku ɗǝfu. ");
INSERT INTO mfm_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","Naja ndǝra wu sǝsǝkuya ɗǝfuwa mǝn wu pǝcira mǝn wu patǝr ɓwaɓwatǝu, aga mǝna sǝn sǝsǝkuya ɗǝfuwa njira wu kalar culi ɓwaɓwatǝu ǝnga sǝsǝku dzǝ kǝra mǝn uya sara ara Hyal. ");
INSERT INTO mfm_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","Ara ǝnggǝra mǝn wu lar ɓwaɓwatǝu ǝnggǝr kǝra Kǝrsiti lari, abangǝ tsu lagur Kǝrsiti ngǝ sǝsǝku ɗǝfur mǝn sara ara Hyal wu nyabiya dzau. ");
INSERT INTO mfm_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","Ma ˈya wu ɓwaɓwatǝu, aga hya uya sǝsǝku ɗǝfu ǝnga hya uya mbǝɗǝ ngau. Ma ˈyi uya sǝsǝku ɗǝfu, aga hya uya sǝsǝku ɗǝfu ngau, kǝra wu mǝliya hya ɗa njira wu sǝn cinapi wu ɓwaɓwatǝ kǝra hya vǝr sa ǝnggǝr kǝra ˈya vǝr sa tsu. ");
INSERT INTO mfm_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","Fǝrkǝr ˈya ǝnga hyi a ciyar dzau, arya ˈyu sǝni abǝr ǝnggǝr kǝra hyi lar ɓwaɓwatǝ daɓǝ ǝkkǝˈyi ˈya, abangǝ tsu nga hyu nda uya sǝsǝku dzau ǝkkǝˈyi ˈya. ");
INSERT INTO mfm_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","Wazha ama, naˈya aˈyi wu yiwu hya nggya ǝnga gǝra sǝnbiya sǝ ar kǝra ɓwaɓwatǝ kǝra ˈyi tǝrabiya a gwa wu ˈyiˈyir Asǝya mai. A lar ˈya ɓwaɓwatǝ gagaɗǝ kǝra ndiya dǝnamar ˈya, ma ˈyu nggani ˈyu nda tini piya ˈya a gwa. ");
INSERT INTO mfm_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","Pakatǝu, ma ˈyi nggani a thlanar ˈyar nji numa nǝ tau. Ama sǝkǝ ɗa aga ˈya highiɓǝri abǝr aˈyi ˈya vǝr nggya ǝnga dǝnamar kǝrˈya mai, ama ˈya vǝr nggya ǝnga dǝnamar Hyal, ndǝra ǝnga dǝnama nǝ hyaˈana nji sara vir tau. ");
INSERT INTO mfm_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","Naja ngǝ ndǝra mbǝliya ˈya sara wu miya tǝ nǝ ɗǝmwaˈyu, ǝnga ju nda mbǝlbiya ˈya. Naja ndǝra ˈyi fǝr kǝr wu ja, abǝr ju nda dumwa ǝnga mbǝl ˈya, ");
INSERT INTO mfm_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","ǝnggǝra hyu dumwa ǝnga kǝdi Hyal anǝ ˈya. Lagu kǝ ngǝ nji gangǝ wu nda lǝr usaku anǝ Hyal arya ˈya, arya barka kǝra Hyal lǝri anǝ ˈya lagur nggari kǝdi nǝ nji gangǝu. ");
INSERT INTO mfm_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","Kabangǝkau, kǝja sǝr ɓwadzǝr ˈya, abǝr, ɗǝnga nǝ ɗǝfuwa ˈya vǝr lǝ sakida anǝ ˈya abǝr nggyabiyar ˈya ǝnga njir duniya ǝnga nggyabiyar ˈya ǝnga hyi nggya cici ngau, ǝnga nggya ɗǝfu pathlu sara ara Hyal, maja ma nggya kǝra mǝn nggya ǝkkǝˈyi hyi. ˈYi mǝl abangau, aˈyi lagu hahangǝkur nǝ njir duniya mai, ama lagu mayiwakur nǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","Ara aˈyi ˈyu tsǝfǝ anǝ hyi sǝra hyi gǝra sǝn jiga ba hya nggabiya mai. Ama cim ɗa ca ngǝ, ");
INSERT INTO mfm_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","ǝnggǝr kǝra hyi nggabiya ˈya kukushu kabangǝkau, hyu nda nggabiya gagaɗau, kǝra wu mǝliya hya ɓwadzau wu ˈya ǝnggǝr kǝra ˈyu ɓwadzau wu hyi tsu ar pǝcir shidar Thlagǝ Yesu. ");
INSERT INTO mfm_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","Arya papalkǝr ɗa ju ɗa abangau, a yiwur yau aga ya nda tular hyi tanggǝrma aga hya ɓǝra uya dlǝwuri barka nǝ mǝthlǝkura nyi. ");
INSERT INTO mfm_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","A yiwur yi aga ya tular hyi ar lagur maˈyi a vu Masidoniya, ǝnga ma ya ɓǝra vǝr sha shili ara hyi sara wu Masidoniya, ba hya dzǝgwa sǝwa ɗa a vu Yahudi. ");
INSERT INTO mfm_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","Ar pǝcira yi mbiya abangau, aˈyi yi ɗǝnga sǝ ar kǝri wa? Əndǝga hyu nggani yi mǝl abangǝ lagur ɗǝnga sǝ njir duniya ya, abǝr yu sǝn na “Angǝ,” ǝnga ya ɓǝra na, “Awau” ya? ");
INSERT INTO mfm_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","Ama ǝnggǝr kǝra Hyal ndǝ tsaˈa miya ɗǝfu ngau, abangǝ nga nyi tsu abǝr ndǝr kǝra ˈyi nar hyi kau, aˈyi “Angǝ” ǝnga “Awau” mai. ");
INSERT INTO mfm_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","Arya Zǝr Hyal, Yesu Kǝrsiti, kǝra nayi ǝnga Silasu, ba Timathlawusu tǝtǝlna ndǝr nyi anǝ hyi ar kǝri, aˈyi “Angǝ” ǝnga “Awau” mai, ama wu ja cumu “Angǝ” ngau. ");
INSERT INTO mfm_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","Arya alaga yiɗawu ngǝ alkawal kǝra Hyal mǝliya wu Kǝrsiti, “Angǝ” nga nyi, a nyabiyar ja patǝu. Lagu nyi nga mǝn wu sǝn na, “Amina” aga ja shili ǝnga kadakadarkur anǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","Kabangǝkau, Hyal ngǝ mǝliya naˈya ǝkkǝˈyi hyi taˈyi wu Kǝrsiti. Naja ngǝ pǝnggǝr mǝn mal kǝra cabiya abǝr a ɗǝmbiya mǝnǝr ja, ");
INSERT INTO mfm_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","ji fiya mǝtsamǝ nǝ thlagǝkur nyi ar mǝn, ba ji fuwa Mambǝl nyi a gu ɗǝfuwa mǝn aga sǝr zhu dzau, kǝra wu nǝ mǝn fǝr kǝr nǝ uya sǝra wu shili. ");
INSERT INTO mfm_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","A nggar yi thlǝmǝr Hyal, naja ngǝ sakida ɗa, abǝr aga ya tsǝrpǝr hyi, ngǝ ɗa nayi aˈyi ɓǝra sha a vu Kwaranthli mai. ");
INSERT INTO mfm_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","Aˈyi ˈya vǝr ca dǝnama ar kǝra mbǝrsar hyi mai, ama ˈya vǝr mǝl thlǝr ǝnga hyi aga hya nyabiya dzǝ ǝnga huɗǝ pipida, arya lagu mbǝrsar hyi nga hyi ciya dzǝ gǝra kǝnggǝɗau. ");
INSERT INTO mfm_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","Agabangau, kǝ yi fuwa wu ɗǝfuwa yi abǝr tsu yu ɓǝra nda tula hyi kǝra wu shili ǝnga huɗǝ kyakyar anǝ hyi mai. ");
INSERT INTO mfm_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","Ara ma yi mǝliya hyi huɗǝ kyakyaru, wa ngǝ hyau kǝra wu nda sǝsǝkuya ɗǝfuwa ya? Aˈyi kǝl nahyi kǝra yi mǝliya hyi huɗǝ kyakyar kau. ");
INSERT INTO mfm_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","Yi tsǝfǝri hyi abangǝ tsu kaɗǝu, aga ma yi shili aga sa tula hyi, nayu uya huɗǝ kyakyar sara ara njira kyaga pina huɗa yi mai. Arya aˈyi yi ǝnga kǝr papal wu hyi papatǝu, abǝr mǝn wu nda daɓau wu caguli ɗa ǝkkǝˈyi hyi. ");
INSERT INTO mfm_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","Yi tsǝfǝ sǝkǝ anǝ hyi arya wu ɓwaɓwatǝu ǝnga huɗǝ kyakyar gagaɗǝ nga yi a gwa, ba tsu ǝnga sǝlǝm gagaɗǝ ngǝ wu liya yau. Nayi aˈyi tsǝfǝ anǝ hyi aga ya mǝliya hyi huɗǝ kyakyar mai, ama aga hya sǝnbiya tǝdǝɓǝkura yiwukur ɗa anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","Ma ndǝ aˈyi kǝra mǝliya sǝr shili ǝnga huɗǝ kyakyaru, aˈyi nayi nga ji mǝliya nyi huɗǝ kyakyar mai, ama lagu batiti patǝkura hyi nga ji mǝliya huɗa hyi kyakyaru lagu pampamu. Aˈyi yu yiwu ya cakǝ unau wu ndǝr kǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","Culi ɓwaɓwatǝ kǝra nji nǝ nyi, kǝra ji lari sara ara badǝgala nji a ɗar tsatsaˈa anǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","Kabangǝkau, a ɗar tsaˈa hya tǝfǝbiya nyi ǝnga hya sǝsǝkuya ɗǝfuwa ja ara ja sara nyabiya dzǝ ǝnga madiya huɗǝ kyakyaru. ");
INSERT INTO mfm_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","Agabangau, yu kǝdi hyi, aga hya cabiya nyi yiwukurǝr hyi anǝ nyi gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","Sǝra ɗa yi tsǝfǝr hyi najaka cama tsǝtsǝfǝ kau, ca ngǝ aga ya dzǝbiya hyi ya sǝnbiya tara njir ɓǝlar sǝra yu na anǝ hyi wu kalar sau. ");
INSERT INTO mfm_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","Kalar ndǝra hyi tǝfǝbiya, nayi tsu a tǝfǝbiya nyir yau. Sǝra yi tǝfǝbiya, ma sǝ aˈyi kǝra tsaˈa aga ya tǝfǝbiya, a tǝfǝbiya nyir yau wu mwar Kǝrsiti arya hyi. ");
INSERT INTO mfm_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","Yi mǝl abangau, a sara Shatan kǝra mǝn wu sǝni dabar nyi a uya lagur ngguta vi. ");
INSERT INTO mfm_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","Ar pǝcira yi maˈyi a vu Turuwasu a vuwa tǝtǝlna ndǝshigu Kǝrsiti, ba yi vuwa thlǝwa Thlagǝ a pahǝnar lagu anǝ ɗa a vuna. ");
INSERT INTO mfm_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","Alaga abangǝ huɗa yi aˈyi pipida mai, arya nayi aˈyi thlǝwa zamǝ ɗa Tayitusu a vuna mai. Agabangau, ba yi nar nda mǝna pida jamǝu, ba yi tǝrabiya sǝ ɗa a vu Masidoniya. ");
INSERT INTO mfm_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","Ama usaku anǝ Hyal ndǝra vǝr tǝɗǝmwa nǝ sǝm tǝlkur anǝ ˈya lagu Kǝrsiti. Ənga lagur ˈya tsu nga ja vǝr tǝtǝlna ndǝr mǝsahǝu nǝ sǝnbiya sǝ ar kǝra Kǝrsiti baˈamani ǝnggǝr pǝ ɓurdi. ");
INSERT INTO mfm_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","Ara naˈya anǝ Hyal ǝnggǝr sǝ kisǝ nǝ Kǝrsiti wu pama njira uya mbǝɗau ǝnga njira ar lagur maˈyi a nda sa. ");
INSERT INTO mfm_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","Anǝ njira ar lagur nda sa a ɗar ˈya ǝnggǝr shuni kǝra wu shili ǝnga tau. Anǝ njira uya mbǝɗǝ tsu a ɗar ˈya ǝnggǝr shuni mǝsahǝu kǝra wu shili ǝnga pi. Wa ngǝ ndǝra tsaˈa aga hǝ najaka culi thlǝra? ");
INSERT INTO mfm_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","Aˈyi ˈya ǝnggǝr alenyi nji gangǝ kǝra shabiya ndǝr Hyal ǝnggǝr sǝr shafǝli mai, ama pamǝ nga ˈya, wu dǝnamar Kǝrsiti nga ˈyu ndǝr wu mwar Hyal ǝnga jirkur, ǝnggǝr njira Hyal ngǝ sǝwa nda. ");
INSERT INTO mfm_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","Kabangǝkau, a cabiyari abǝr a mbar ˈya fal kǝrˈya anǝ hyi wayi ya? Əndǝga hyu yiwu aga ˈya sǝwa cama tsǝtsǝfǝ kǝra nǝ fal ˈya anǝ hyi ǝndǝga sara ara hyi, ǝnggǝr kǝra alenyi nja vǝr mǝl kǝ ya? ");
INSERT INTO mfm_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","Nahyi ǝnga kǝrhyi ngǝ cama tsǝtsǝfǝr ˈya, kǝra tsǝtsǝfǝ ar ɗǝfuwa ˈya, kǝra nji papatǝu wu sǝni ǝnga ndu sǝn jigana. ");
INSERT INTO mfm_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","A cabiyar hyi abǝr cama tsǝtsǝfǝ nga hyi sara ara Kǝrsiti, kǝra ca ngǝ sǝra biya ǝnga kǝr sara wu thlǝr kǝra nji ngga ˈya aga mǝl. Cama kau, aˈyi kǝra nji tsǝfǝri ǝnga sǝr tsǝfǝ sǝ mai, ama ǝnga Mambǝl Hyal kǝra ǝnga pi. Aˈyi kǝra nji tsǝfǝri ar tsǝka mai, ama ar ɗǝfuwa ndapi. ");
INSERT INTO mfm_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","Aˈyi ˈya ǝnga najaka papalkur kǝr wu mwar Hyal lagu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","Naˈya aˈyi cabiya abǝr nǝnǝkur ˈya nga ˈyi sǝn mǝliya kalar sǝ mai, ama nǝnǝkurǝr ˈya sara ara Hyal nga nyi. ");
INSERT INTO mfm_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","Naja ngǝ mǝliya ˈyi ɗa nji nǝnǝ nǝ mǝl thlǝr ar viya njir mǝl thlǝr nǝ alkawal mbamba nǝ mafǝliyangǝu, aˈyi ar kǝra dlaɗǝ kǝra tsǝtsǝfǝ mai ama ar kǝra Mambǝl, arya dlaɗǝ kǝra tsǝtsǝfǝ wu sǝn tsiya ndau, ama Mambǝl wu sǝn lǝr pi. ");
INSERT INTO mfm_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","Kabangǝkau, thlǝr mǝl kǝra dlaɗǝ Musa shili ǝni wu shili ǝnga tau, dlaɗǝ kǝra nji tsǝfǝri ar tsǝka, wu shili ǝnga kadakadarkur. Kadakadarkur kǝra mǝliya njir Izirayila aˈyi wu sǝn tsamǝ du bama Musa mai, arya mbǝmbǝla nyi, alaga kǝ gǝrpǝ nga ju gǝrpǝ kau. ");
INSERT INTO mfm_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","Ma abangǝ ja, thlǝr mǝl Mambǝl aˈyi a ndiya ǝnga kadakadarkur wa? ");
INSERT INTO mfm_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","Ma thlǝr mǝl dlaɗǝ kǝra wu shili ǝnga tau, ca ngǝ ǝnga kadakadarkur abangau, abari ngǝ kadakadarkur nǝ thlǝr kǝra wu shili ǝnga tsapǝkur aˈyi a ndiya nyi gagaɗǝ wa? ");
INSERT INTO mfm_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","Pakatǝu, sǝra ǝnga kadakadarkur ɗǝɗǝm aˈyi ja kabangǝkǝ ǝnga kadakadarkur mai, ma nji gǝlabiya nyi ǝnga madiya kadakadarkur kǝra shili wu nǝ mafǝliyangǝ kau. ");
INSERT INTO mfm_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","Ma sǝra wu gǝrpǝ dzǝ kǝ wu shili ǝnga kadakadarkur abangau, abari ngǝ dǝgalkura kadakadarkur nǝ sǝra gǝra hal ka? ");
INSERT INTO mfm_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","Agabangau, ta ɗa a uyar ˈya sǝr fǝr kǝr abangau, ca ngǝ mǝliya a ɗar ˈya nji gǝra hivǝr a miya ta. ");
INSERT INTO mfm_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","Naˈya aˈyi ǝnggǝr Musa mai, ndǝra mbuya bama ja ǝnga sǝr bakǝ dzau, a sara njir Izirayila a lari ǝnggǝra kadakadarkur kau a vǝr gǝrpǝ dzau. ");
INSERT INTO mfm_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","Ama ɗǝngar nda a ɗari ɓaɓalu. Arya baˈanǝ shili ar pǝci kǝ ǝshina sǝr mbu bama ta tsu aˈyi ǝnga nda ma nju jiga alkawal mbamba nǝ hahal ta. Nji aˈyi hǝna mai, ara kǝl wu Kǝrsiti nga nju sǝn hǝna wacu. ");
INSERT INTO mfm_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","Baˈanǝ shili ar pǝci kǝ ǝshina, ma nju jiga dlaɗǝ Musa, sǝr mbu aˈyi kǝra wu mbuya ɗǝfuwa nda. ");
INSERT INTO mfm_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","Ama ar kalar pǝci kǝra ndǝra shabiya dzǝ a shili anǝ Thlagǝu, ba nja hǝna nyi sǝr mbu bama ta. ");
INSERT INTO mfm_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","Kabangǝkau, Thlagǝ Mambǝl ngau, ǝnga kalar vira Mambǝl Thlagǝu ari, a ndǝna a uyar nji kambǝkur. ");
INSERT INTO mfm_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","Namǝn njira nji pahǝna nda bama nda patǝu, mǝn wu ca mbǝmbǝlkur nǝ kadakadarkur nǝ Thlagǝu ǝnggǝr mbǝmbǝl kǝra wu biya sara wu doragalu, ǝnga mǝn wu bǝlar dzǝ a shili wu nggya kǝra pabiya kadakadarkur nǝ Thlagǝ kǝra a vǝr cakau, kǝra wu shili sara ara Thlagǝu, ndǝra Mambǝl ngau. ");
INSERT INTO mfm_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","Agabangau, ta ɗa a uyar ˈya thlǝr mǝl lagu tǝhuɗǝ dzǝ nǝ Hyal, ca ngǝ ɗa dza ˈya aˈyi tǝnakǝr mai. ");
INSERT INTO mfm_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","Kuji a ndiya anǝ ˈya, ˈya piyari mǝl sǝra ɗǝɗǝwa sǝra wu sǝn shili ǝnga sǝli. ˈYa piyari sǝ sǝsǝli ǝnggǝr ngguta vi ǝnga alaga thla fati ǝnga ndǝr Hyal, ama ˈya cabiya nda jirkur ar babal. Lagu kǝ ngǝ kalar ndǝ wu nda ɗa sakida nǝ jirkurǝr ˈya a dumwar Hyal. ");
INSERT INTO mfm_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","Ma ɗa ndǝr Hyal kǝra ˈyu tǝtǝlna a ɗar sǝ ɗǝɗǝwa, a ɗar ja sǝ ɗǝɗǝwa anǝ njira ar lagur nda sa. ");
INSERT INTO mfm_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","Naja hyal nǝ nggyabiya nǝ kabangǝkau, ngǝ dar ɗǝngar nda, njira gǝra mbǝrsa, a sara nda lar mbǝmbǝlkur Ndǝshigu nǝ kadakadarkur Kǝrsiti. Naja ndǝra pabiya Hyal. ");
INSERT INTO mfm_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","Ara naˈya aˈyi a vǝr tǝtǝlna ndǝr ar kǝra kǝrˈya mai, ama ar kǝra Yesu Kǝrsiti, abǝr, naja ngǝ Thlagǝu, ǝnga naˈya ǝnga kǝrˈya ar viya mafar hyi arya Yesu. ");
INSERT INTO mfm_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","Arya Hyal nana, abǝr “Taˈyi mbǝmbǝl a mbǝl sara vu kuthlǝu,” naja ngǝ mǝliya mbǝmbǝla nyi a mbǝl wu ɗǝfuwa mǝn aga ja nǝ mǝn mbǝmbǝl sǝnbiya ar kǝra kadakadarkur Hyal kǝra a vǝr mbǝl ar bama Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","Ama aˈyi ˈya ǝnga najaka bǝrbakur wu ˈya, naˈya kǝra ǝnggǝr tǝm ˈyiˈyi, aga cabiya abǝr dǝnama kǝra ndiya patǝu sara ara Hyal nga nyi, ama aˈyi sara ara ˈya mai. ");
INSERT INTO mfm_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","Nja vǝr ciciɗǝ ˈya lagu pampamǝu, ama alaga abangǝ naˈya aˈyi bǝraghinakǝr mai. Aˈyi ˈya ǝnga tǝkǝkǝr, ama alaga abangǝ dza ˈya aˈyi tǝnakǝr mai. ");
INSERT INTO mfm_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","Nja vǝr ɗa ˈya, ama alaga abangǝ Hyal aˈyi piyari ˈya mai. Nja vǝr dladla ˈya a gyuˈyi, ama naˈya aˈyi dlanakǝr mai. ");
INSERT INTO mfm_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","Cimu nga ˈya a miya tau, culi tǝ nǝ Yesu, aga tsu nggyabiya Yesu a cabiya dzǝ wu ˈya. ");
INSERT INTO mfm_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","Ma tsu ˈya ǝnga pi, nju lǝr ˈya cimu anǝ tau arya Yesu, aga nggyabiya nyi a cabiya dzau wu dza ˈya kǝra wu tau. ");
INSERT INTO mfm_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","Agabangǝ tsu, tǝ a vǝr mǝl thlǝr wu ˈya, ama pi a vǝr mǝl thlǝr wu hyi. ");
INSERT INTO mfm_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","Tsǝtsǝfǝ nga nyi, abǝr, “A hǝnggǝr yau, ca ngǝ ɗa yi ndǝr.” Ənga najaka mambǝl nǝ mbǝrsa nga ˈyi hǝnggǝri ca ngǝ ɗa ˈyi ndǝr abangǝ tsu. ");
INSERT INTO mfm_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","Ara ˈyu sǝni abǝr, ndǝra hyaˈana Thlagǝ Yesu sara vir tau, ju nda hyaˈana mǝn ǝkkǝˈyi Yesu tsu, ba ja dzǝgwa lǝr ˈya ǝkkǝˈyi hyi wu mwa nyi. ");
INSERT INTO mfm_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","Patǝ sǝˈyar kǝ ɗa aga ja shili ǝnga akkǝri anǝ hyi nga nyi, aga mayiwakur Hyal a tǝtǝlnakǝr a nda anǝ nji gangǝu. Lagu kǝ nga nju nda lǝ usaku gagaɗǝ anǝ Hyal, aga ja shili ǝnga kadakadarkur anǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","Agabangau, dza ˈya aˈyi tǝnakǝr mai, alaga kǝ kumǝr dza ˈya vǝr hal kau, ama cimu ngǝ mambǝlǝr ˈya wu cakau wu mafǝliyangǝkur kalar pǝci. ");
INSERT INTO mfm_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","Ara zǝzǝra ɓwaɓwatǝ kǝra ˈya vǝr sa kabangǝkǝ kau, nǝ pǝci kushi ngau, kǝra wu nda pabǝri ˈya aga kadakadarkur kǝra gǝra kuɗau, kǝra wu ndiya patǝr ɓwaɓwatǝ kǝra ˈya vǝr sa. ");
INSERT INTO mfm_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","Agabangau, naˈyu fǝr liya ˈya ar sǝra ˈyu lari ǝnga li mai, ama ar sǝra li gǝra lari. Ara sǝ kǝra li wu lari wu tǝrabiya, ama sǝra li gǝra lari wu nggya baˈanuwa. ");
INSERT INTO mfm_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","Kumǝr dza mǝn ǝnggǝr kwapatǝ kǝra mǝna vǝr nggya a gwa wu duniya. A sǝnǝr mǝn abǝr, ar pǝci kǝra nji ndzana kumǝr dzǝ kau, kǝ mǝn tau, mǝnu nda uya vanyi dzǝ a dǝmǝlmau. Dzǝ hǝhǝr kǝra gǝra kuɗau sara dagǝ Hyal kǝra ji hǝriya ǝnga kǝrnyi, aˈyi tsa ndǝ ngǝ hǝr mai. ");
INSERT INTO mfm_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","Kabangǝkau, mǝn wu ngguli cimǝr hari dzǝ nǝ nggya a dǝmǝlmau, ǝnggǝr kǝra mǝn wu cim kar ha mafǝliyangǝu. ");
INSERT INTO mfm_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","Ma nji pǝɗǝwa mǝn wu dzǝ mafǝliyangǝ kau, nju thlǝwa mǝn turusu mai. ");
INSERT INTO mfm_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","Ma tsu mǝn wu dzǝ nǝ duniya kau, mǝn wu ngguli ara culi ɓwaɓwatǝ kǝra mǝn a gwa. Ara aˈyi aga nja tǝkǝbiya mǝn ǝnga kumǝr dzǝ kǝ mai, ama aga nja bǝlana mǝn ǝnga dzǝ kǝra sara a dǝmǝlmau, aga dzǝ kǝra wu tau a bǝlabiya dzǝ ǝnga pi baˈanuwa. ");
INSERT INTO mfm_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","Arya Hyal ǝnga kǝrnyi ngǝ pabǝr mǝn aga najaka bǝla dzau, ca ngǝ Hyal nǝ mǝn Mambǝl nyi ar viya sǝr zhu aga wa sǝn zǝgǝu. ");
INSERT INTO mfm_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","Ca ngǝ sǝra ɗa aˈyi mǝn cimu ǝnga papalkur kǝr ǝnga mǝn wu sǝni abǝr ma pǝci kǝra mǝn wu dzau, a ɗar mǝn naɗǝu ara Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","Nggyar mǝn lagur mbǝrsa nga nyi, aˈyi lagur sǝra li wu lari mai. ");
INSERT INTO mfm_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","Aˈyi ˈya ǝnga papalkur kǝr, ǝtsu a ndiya anǝ ˈya, ˈya tǝkǝbiya dzǝ ǝnga dzau, aga ˈya nggya ǝnga Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","A ɗari sǝr cimǝr ɗǝfuwa mǝn aga mǝn a pina huɗa ja, alaga tsu mǝn ǝnga pi alaga tǝtǝ mǝn. ");
INSERT INTO mfm_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","Patǝkura mǝn mǝnu nda kaɓǝ a mwar pathla numa nǝ Kǝrsiti. Ənggau, kalar ndu sa dlǝwuri akkǝri kǝra tsaˈa aga sǝra mǝla ja wu pǝcira ja wu dzau, alaga sǝ mǝnahǝu ǝnga sǝ didiɗi. ");
INSERT INTO mfm_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","Ta ɗari mǝn wu sǝni sǝra nju ngga ǝnga hivǝr Thlagǝu, a ɗari tsaˈa mǝna hǝlǝr hangǝkala nji aga nda nu. Sǝra mǝn aga nyi ar babal nga nda anǝ Hyal, ǝnga abangǝ nga yu nggani abangǝ nga nyi wu ɗǝfuwa hyi. ");
INSERT INTO mfm_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","Aˈyi kǝrˈya nga ˈya vǝr fal anǝ hyi tsu mai, ama ˈyu nǝ hyi lagu aga hya ɓwadzǝ ǝnga ˈya, aga hya ɗa njira wu sǝn shaɗǝwa anǝ kalar njira wu ɓwadzau wu sǝra nju lari ǝnga li a mwara sǝra a gyu ɗǝfu. ");
INSERT INTO mfm_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","Ma kǝra ˈya a bǝlar dzau, bǝla kǝr kau, aga Hyal nga nyi. Ma kuyatsǝkǝr nga ˈya aga hyi nga nyi. ");
INSERT INTO mfm_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","Arya yiwukur Kǝrsiti ngǝ tsǝtsǝkur ˈya, arya a hǝnggǝr mǝn abǝr ji tau arya nji patǝu, agabangau, patǝ mǝn ngǝ tau. ");
INSERT INTO mfm_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","Ji tau arya nji patǝu, aga njira ǝnga pi tsu ndu ɓǝra nggya aga kǝrnda mai, ama anǝ ndǝra tau ǝnga ji ɓǝra hyaˈari arya nda. ");
INSERT INTO mfm_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","Agabangau, mbari a shilar pǝci kǝ ǝshina tsu ˈyu ɓǝra tsamǝ nji ǝnggǝr kǝra duniya vǝr tsamǝ mai. Abangǝ nga ˈyi saya tsamǝ Kǝrsiti parangǝu, ama tsu ˈyu ɓǝra mǝl abangǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","Agabangau, kalar ndǝra wu Kǝrsiti ndǝ mafǝliyangǝ ngau. Nggyabiya hahal a tǝrabiyari, ǝtsu nggyabiya mafǝliyangǝ a shiliri. ");
INSERT INTO mfm_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","Sǝˈyar kǝ patǝ sara ara Hyal nga nda, Hyal kǝra ɓasǝwa ˈya ǝnga kǝrnyi lagu Kǝrsiti ǝnga ji nǝ ˈya thlǝr nǝ ɓasǝwa nji ǝnga Hyal. ");
INSERT INTO mfm_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","Hyal a vǝr ɓasǝwa duniya a shili ara ja lagur Kǝrsiti, aˈyi ju jiga bikǝr nji ar kǝra nda mai, ǝnga a nǝ mǝnǝr ja cama nǝ ɓasǝwa nji a shila ǝgya ja. ");
INSERT INTO mfm_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","Naˈya ngǝ cama dǝgǝci nǝ Kǝrsiti, Hyal ǝnga kǝrnyi nga vǝr kǝdi aga nja dlǝwuri nyi lagur ˈya. Ca ngǝ sǝra ɗa ˈya vǝr kǝdi hyi barka kǝra Kǝrsiti ǝnga kǝrnyi, hya ɓasǝwa dzǝ ǝnga Hyal. ");
INSERT INTO mfm_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","Kǝrsiti aˈyi saya mǝliya bikǝ mai, ama kǝ Hyal mǝliya nyi ndǝr bikau arya mǝn. Lagu kǝ nga mǝn ɗa nji tsapǝ ǝnga Hyal. ");
INSERT INTO mfm_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","Ənggǝr ndǝr mǝl thlǝr nǝ Hyal, ˈyu kǝdi hyi, nahyi njira dlǝwuri mayiwakur nǝ Hyal, a sara hya piyari ja ɗa sǝ kurthlǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","Arya ji na, “Ar pǝcira pǝci ɗa a ɗar tsaˈa, a nggar ngǝr yau, ǝnga ar pǝcir mbǝɗa nji ɗa, a dlǝwana ngǝr yau.” Yu nar hyi, kabangǝkau ngǝ pǝcir pǝci ɗa a ɗar tsaˈa, ǝnga kabangǝkau ngǝ pǝcir mbǝɗau. ");
INSERT INTO mfm_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","Naˈya fǝ tsǝka thlǝ hi anǝ kuvwar ˈya mai, ara thlǝr Hyalǝr ˈya a sara uya vazau. ");
INSERT INTO mfm_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","Sǝra tsaˈa ca ngǝ, ǝnggǝr mafa Hyal, ˈya fal kǝrˈya ar viya njir mǝl thlǝr Hyal wu kalar lagu, ja ɗa, wu sǝsǝˈwu sau, ǝnga wu ɓwaɓwatǝu, ǝnga wu kwakwaɗǝkur dzau, ǝnga wu wuthlǝwuthlǝkur, ");
INSERT INTO mfm_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","ǝnga wu dǝgǝ kǝra nju dǝgau, ǝnga nggya wu fursǝna, ǝnga nggya wu ɓwaɓwatǝ nǝ njir gwazhivi, ǝnga thlǝr kwakwaɗǝu, ǝnga pida liliˈu, ba ǝnga nggya ǝnga wuɓau. ");
INSERT INTO mfm_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","Ətsu, ˈya fal kǝrˈya ar viya njir mǝl thlǝr Hyal ǝnga ɗǝfu cicau, ǝnga nggabiya sau, ǝnga mba ɗǝfu, ǝnga kiˈwakur, ǝnga wu Mambǝl Cicau, ǝnga yiwudzǝ nǝ jijiri, ");
INSERT INTO mfm_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","ǝnga wu ndǝr jiri, ǝnga wu dǝnama nǝ Hyal, ǝnga balmi nǝ tsapǝkur wu tsi mazǝm ǝnga tsi matsal. ");
INSERT INTO mfm_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","Ənga tsu, ˈya fal kǝrˈya ar viya njir mǝl thlǝr Hyal wu lagu kadakadarkur, ǝnga lagu sǝ sǝsǝli, ǝnga ndǝr nǝ fal ǝnga ndǝr nǝ na ˈya. Nji dǝdur nga ˈya, ama nju lar ˈya ǝnggǝr nji fafati. ");
INSERT INTO mfm_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","Naˈya nji ngau kǝra nju sǝni, ama kǝ ˈyi ɗa ǝnggǝr njira nji gǝra sǝni. A miya tǝ nga ˈya, ama mbǝmbǝɗǝ nga ˈya. Nji dǝgǝ ˈya, ama nji tsiya ˈya mai. ");
INSERT INTO mfm_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","Naˈya ǝnga huɗǝ kyakyaru, ama cimu cacaguli nga ˈya. Ɗaɗali nga ˈya, ama ˈyi mǝliya nji ndǝ ɗa njir gǝnna. Naˈya nji gǝra sau, ama aˈyi ˈya ǝnga kalar sau. ");
INSERT INTO mfm_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","Nahyi njir Kwaranthli, sǝ aˈyi kǝra ˈyi ɗǝwana ara hyi mai, ǝnga tsu a cabiyar hyir ˈya yiwukur gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","Aˈyi naˈya ngǝ piyari hyi mai ama nahyi ngǝ piyari ˈya. ");
INSERT INTO mfm_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","Ya vǝr ndǝr kau anǝ hyi ǝnggǝr kǝra tada wu ndǝr anǝ wazha nyi, nahyi tsu hya cabiya ɗa yiwukur. ");
INSERT INTO mfm_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","Hya sara daɓǝ kǝr ǝnga nji kǝra gǝra njir nu mai. Ndǝ tsapǝu a sǝn nggya ǝnga ndǝ shishi ya? Əndǝga mi ngǝ sǝr daɓǝr pama mbǝmbǝl ǝnga kuthla? ");
INSERT INTO mfm_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","Kǝrsiti ya, bazhiya Shatan ngǝ ya? Alaga njir nu ǝnga njira gǝra nu, bazhi nga nda ya? ");
INSERT INTO mfm_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","Ənga mi nga sǝn daɓǝya ki Hyal ǝnga kata? Arya namǝn ki Hyal ngau, ǝnggǝr kǝra Hyal nana, “Yu nggya ǝkkǝˈyi nda, ba ya ɓau ǝkkǝˈyi nda, ǝnga yu ɗa Hyalǝr nda ba nda ɗa nji ɗa.” ");
INSERT INTO mfm_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","“Agabangau, biya mau sara wu nda, hya tǝkǝbiya dzau, ǝngwar Thlagǝu. Hya sara tsǝkwa sǝra gǝra cici mai, ba ya nda sa dlǝwuri hyi. ");
INSERT INTO mfm_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","Ənga yu nda ɗa tada anǝ hyi, ǝnga hyu nda ɗa wazha ɗa ǝnga kuˈyi ɗa, ǝngwar Thlagǝu, ndǝ Dǝgal Dǝnama.” ");
INSERT INTO mfm_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","Bazhir ˈwa ɗa ˈyar, ta ɗa a nǝ mǝnǝr nji alkawalˈyar kau, taˈyi mǝna cina kalar diɗi kǝra wu sǝni diyaɓǝna dza mǝn ǝnga mambǝlǝr mǝn. Taˈyi mǝna nyabiya dzǝ wu cicikur wu lagu hivǝr Hyal. ");
INSERT INTO mfm_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","Cabiya mǝ yiwukur anǝ ˈya wu ɗǝfuwa hyi, arya sǝ aˈyi kǝra ˈyi ndzana nyi anǝ ndǝ mai, naˈyi gwazhiri hangǝkala ndǝ mai, ǝnga tsu ndǝ aˈyi kǝra ˈyi ɗiya nyi mai. ");
INSERT INTO mfm_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","Aˈyi yi na abangǝ aga ya nǝ hyi vazǝ mai, ama ǝnggǝr kǝra yi saya nar hyi ta, abǝr sǝ aˈyi kǝra wu sǝn tǝkǝbiya mǝn mai, alaga tau ǝnga mbǝɗau. ");
INSERT INTO mfm_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","Aˈyi yi ǝnga papalkur kǝr wu hyi. Yu ɓwadzǝ ǝnga hyi, ǝnga a fiya ɗar hyi ɗǝfu gagaɗau. Wu ɓwaɓwatǝr ˈya patǝu, aˈyi yi nyinyau ǝnga huɗǝ pipida. ");
INSERT INTO mfm_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","Arya ar pǝcira ˈyi vu wu Masidoniya, naˈyi uya ɓǝlsar mai, arya nji tsǝtsǝbwarir ˈya wu kalar lagu, pǝpa ngǝ zǝwar ˈya, ǝnga hivǝr ngǝ wu ta ˈya. ");
INSERT INTO mfm_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","Ama Hyal ndǝra wu sǝsǝkuya njira wu ɓwaɓwatǝu, a sǝsǝkuya ˈyar ja ǝnga shilǝr Tayitusu. ");
INSERT INTO mfm_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","Aˈyi arya shili nyi kǝ nga yi caguli waci mai, ama sǝsǝku ɗǝfu kǝra hyi fuwa nyi a gwa. Ji nar ˈya ǝnggǝra hya vǝr cim lar ɗa, ǝnggǝra huɗa hyi ndzau ǝnga sǝra ɗa, ǝnga tsu ǝnggǝra hyi mbiya ɗa ndǝl wu yiwudzau, kǝra mǝliya huɗa yi pipida a ndiya kǝra parangǝu. ");
INSERT INTO mfm_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","Nja na ma, abǝr cama tsǝtsǝfǝ kau, a ndzanar huɗa hyi, ama yu thlǝ nggǝraˈwa nyi mai, alaga kǝ a thlǝr yi nggǝraˈwa nyi, arya wu sǝni yi abǝr cama tsǝtsǝfǝ kau a ndzanari huɗa hyi ama nǝ pǝci kushi ngau. ");
INSERT INTO mfm_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","Ama kabangǝkau, aˈyi yi ǝnga caguli ǝnga huɗǝ ndzǝndzǝ kǝra cama tsǝtsǝfǝ kǝ mǝliya hyi mai ama aˈyi yi ǝnga caguli abǝr wu nda nǝ hyi ɗǝfu nǝ tubi. Huɗǝ ndzǝndzǝr hyi, Hyal ngǝ mǝliya nyi abangǝ tsu, aga aˈyi naˈya ngǝ mǝliya hyi vanyi sǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","Huɗǝ ndzǝndzǝ sara ara Hyal wu mǝliya ndǝ a tubi ba ja uya mbǝɗau, sǝr thlǝ nggǝraˈwu aˈyi a gwa mai. Ama huɗǝ ndzǝndzǝ kǝra duniya wu shili ǝni, wu shili ǝnga tau. ");
INSERT INTO mfm_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","Tsamiya mǝ sǝra huɗǝ ndzǝndzǝ sara ara Hyal kǝ mǝliya hyi gǝyi. Ji mǝliya aga hya ɗa ǝnga kwakwaɗǝ mashi nǝ mǝl sǝra tsaˈa, ǝnga ǝnggǝra hyi nǝrdzǝ aga hya cina kǝrhyi wu vazau. Ji mǝliya hyi hya ɗa ǝnga huɗǝ ndzǝndzau, ǝnga hivǝr. Ji mǝliya hyi hya cim lar ɗa, ǝnga kwakwaɗǝ mashi. Ji mǝliya hyi hya ɗa njir yiwu nja mǝl sǝra tsaˈa. Lagur sǝra mǝla hyi a cabiyari abǝr aˈyi hyi ǝnga vazǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","Alaga kau, a tsǝfǝr hyir yau, aˈyi arya vanyi ndǝ ndzana vanyi sǝ mai, alaga ndǝra nji ndzana nyi sau, ama aga hya lari anǝ kǝrhyi wu mwar Hyal abǝr nahyi nji ngau kǝra ǝnga kwakwaɗǝ mashi aga ˈya. ");
INSERT INTO mfm_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","Lagu sǝˈyar kau nga ˈyi uya tsǝtsǝku ɗǝfu. Cakau ar kǝra tsǝtsǝku ɗǝfur ˈya, aˈyi ˈya ǝnga caguli arya huɗǝ pipida kǝra Tayitusu a gwa. Arya mambǝl nyi a ɗari camǝ lagu sǝra hyi mǝliya nyi. ");
INSERT INTO mfm_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","Alaga ma yi nar nyi abǝr yi ɓwadzǝ ǝnga hyi, nayi gu sǝli wu mwar hyi mai. Ənggǝr kǝra kalar sǝra ˈyi nar hyi jiri nga nyi, patǝr sǝra ˈyi ɓwadzǝ ǝni ar kǝra hyi anǝ Tayitusu tsu jiri nga nyi patǝu. ");
INSERT INTO mfm_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","Tayitusu a vǝr yiwu hyi gagaɗau, ar cakar cakau kalar pǝcira ji ɗǝngari ǝnggǝra hyi ɓǝlari ndǝr nyi. Hya dlǝwuri nyi ǝnga huɗǝ pathlǝu wu gǝnggǝr nyi sǝli. ");
INSERT INTO mfm_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","Aˈyi yi ǝnga huɗǝ pipida arya aˈyi yi ǝnga papalkur kǝr kǝra nyinyau wu hyi. ");
INSERT INTO mfm_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","Kabangǝkau, wazha ama ˈyu yiwu hya sǝnbiya sǝra mayiwakur Hyal a vǝr mǝl wu pama daɓǝ dzǝ njir nu pamǝpamǝ kǝra wu Masidoniya. ");
INSERT INTO mfm_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","Wu madiya ɓwaɓwatǝ kǝra nda a gwa, aˈyi nda ǝnga huɗǝ pipida kǝra tǝkǝri ndǝ uya tsi papahau aga lǝr sau wu nggya ɗaɗalir nda. ");
INSERT INTO mfm_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","A lar yi ǝnga liya yau, ndǝ lǝri lǝr sǝr nda tsaˈa aga dǝnamar nda, zada ma ja ndiya sǝra ara nda, ndǝ lǝri ǝnga yiwur nda. ");
INSERT INTO mfm_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","Nanda ǝnga kǝrnda nga vǝr kǝdi ˈya gagaɗau aga ˈya jigǝwa nda wu pama njir lǝ sǝ lǝlau anǝ nji cici gǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","Sǝra ndǝ lǝri ba ji ndiya sǝra ˈyu nggani ndu lǝri, arya tanggǝrma ndǝ lǝr kǝrnda anǝ Thlagǝu ǝnga anǝ ˈya wu yiwukur huɗa Hyal, kadivira ndǝ dzǝgwa lǝ sǝ lǝlǝr nda. ");
INSERT INTO mfm_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","Arya kau, kǝ ˈyi dzǝgwa kǝdi Tayitusu aga ja dumwa ǝnga dlǝwu lǝr sǝr hyi, mara naja ngǝ dzǝguya, baˈa shili ar kuɗiya lǝr sǝr hyi. ");
INSERT INTO mfm_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","Ənggǝr kǝra hyi a ɗar a dumwa ǝnga mǝl kalar sau, sǝ ǝnggǝr mbǝrsa, ǝnga ndǝr, ǝnga sǝn sau, ǝnga cim mǝl sǝ mǝnahǝu, ǝnga ca yiwukur anǝ ˈya, taˈyi hya ɗa a dumwa ǝnga lǝ sǝ lǝlau. ");
INSERT INTO mfm_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","Aˈyi ca nga yu ca hyi a gwa ǝnga hathlǝ mai, ama yu yiwu ya dzǝgabiya jirkura yiwur hyi kǝra hyu ca lagur gǝlabiya nyi lagur yiwukur lǝ sǝ nǝ alenyi nji. ");
INSERT INTO mfm_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","Arya hyu sǝni mayiwakur nǝ Thlagǝr mǝn Yesu Kǝrsiti, alaga kǝ ndǝr bǝrba nga ja, ama arya hyi kǝ ji ɗa ndǝ ɗaɗali, aga nahyi kǝra nji ɗaɗali hya ɗa njir gǝnna lagur ɗaɗalikur nyi. ");
INSERT INTO mfm_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","Kǝja sawara ɗa kǝra ndiya anǝ hyi patǝu, wu najaka sau. Hunau, nahyi ngǝ njira dzǝguya lǝ sǝ nǝ tanggǝrma, aˈyi lǝr sǝ waci mai, ama aˈyi hyi ǝnga ɗǝfu lǝ sau. ");
INSERT INTO mfm_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","Kabangǝkau, hya duya thlǝr kǝra hyau, aga ɗǝfu cim nǝ mǝla nyi kau, ja shili tsaˈa ǝnga cim duya nyi, ǝnggǝr kǝra dǝnamar hyi mbari. ");
INSERT INTO mfm_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","Ma ɗǝfu lǝr sǝ aˈyi ara hyi, Hyal wu nda dlǝwuri lǝr sǝr hyi. Arya lǝr sǝ a kyaga ɗa tsaˈa ǝnga sǝra ara gau, aˈyi sǝra gǝra ara gǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","Aˈyi ˈyu yiwu ˈya fǝnggǝr hyi sǝ tǝdǝɓǝu ba ˈya dlǝwana alenyi nji nda tsar yambaɗǝ mai, ama nda ɗa kakalǝu. ");
INSERT INTO mfm_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","Ar pǝci kǝ ǝshina, gangǝkur sǝr hyu nda dlǝwar nda wu ghar nda, abangǝ tsu gangǝkur sǝr nda wu nda dlǝwari hyi wu ghar hyi. Aga kalar sǝ a maˈyi kakalǝu. ");
INSERT INTO mfm_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","Ənggǝr kǝra ndǝr Hyal kǝra tsǝtsǝfǝ nana, “Naja ndǝra tsǝmiya gangǝu wu ɗa gangǝ gagaɗǝ anǝ nyi mai, naja ndǝra tsǝmiya kushu tsu aˈyi wu tǝwa gagaɗǝ anǝ nyi mai.” ");
INSERT INTO mfm_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","Usaku anǝ Hyal arya ji fuwa wu ɗǝfwa Tayitusu aga ja dlǝwari hyi ǝnggǝr kǝra ya vǝr yiwu ya mǝl. ");
INSERT INTO mfm_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","Tayitusu aˈyi dlǝwunggǝri ǝnga kǝdir ˈya aga ja shili waci mai, ama ji dlǝwunggǝri ǝnga caguli, yiwu huɗa ja nga ju yiwu ja shili. ");
INSERT INTO mfm_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","Kǝja ˈyu sǝwa zamǝ kǝ ǝnga ja, naja kǝra fiya thlǝmǝ wu daɓǝ dzǝ njir nu pamǝ pamǝu arya tǝtǝlna ndǝshigu mǝsahǝ kǝra ju mǝl. ");
INSERT INTO mfm_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","Aˈyi najakǝ waci mai ama daɓǝ dzǝ njir nu pamǝpamǝ ngǝ caɗǝbiya nyi aga ja lǝbiya ˈya ǝnggǝra ˈyu hǝ sǝ lǝlǝ kǝra ˈyi tsǝmiya. Lǝr sǝ kǝra ˈyu lau aga lǝ kadakadarkur anǝ Thlagǝu, aga ca anǝ Thlagǝu ǝnggǝra ˈya ǝnga ɗǝfu mǝnahǝu aga dlǝwa nji. ");
INSERT INTO mfm_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","ˈYa vǝr hwi a sara nja vazǝya ˈya ar kǝra lagura ˈyu tǝkǝ lǝ sǝ lǝlǝ kǝra nji lǝri gangǝu. ");
INSERT INTO mfm_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","Yiwur ˈya ca ngǝ aga ˈya mǝl sǝra tsaˈa, aˈyi sǝra tsaˈa wu mwar Thlagǝ waci mai ama patǝ ǝkkǝˈyi wu mwar nji. ");
INSERT INTO mfm_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","Kǝja ˈya sǝwa daɓǝ ǝnga nda zamǝr mǝn kǝra ˈyi dzǝgabiya nyi lagu pamǝpamǝ gangǝu kǝra ˈyi thlǝwa nyi ǝnga jiri abǝr ɗǝfu a miya ta ja wu kalar sau aga thlǝr Hyal, naja tsu a nǝr ja dzau arya papalkur kǝr nyi wu hyi. ");
INSERT INTO mfm_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","Tayitusu nǝnyi bazhi mǝl thlǝr ɗa ngau wu pama hyi, abangǝ tsu, alenyi wazha ama kǝra a vǝr mǝl thlǝr ǝkkǝˈyi ja kau, nǝrnda ar viya daɓǝ dzǝ njir nu pamǝpamǝ nga nda aga ja shili ǝnga kadakadarkur anǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","Agabangau, hya canǝ nyi yiwudzǝr hyi anǝ nji kau ǝnga sǝra ɗa ˈyu ɓwadzǝ wu hyi, aga daɓǝ dzǝ njir nu pampam kau, nda lari. ");
INSERT INTO mfm_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","Aˈyi mbari ya ɓǝra ɗǝngar hyi ar kǝra dlǝwa dzǝ nji cici gǝ Hyal mai. ");
INSERT INTO mfm_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","Ara wu sǝni yi ǝnggǝra hya vǝr yiwu dlǝwa nji ǝnga caguli, kǝra tǝkǝri ma, yu ɓwadzǝ ǝnga hyi anǝ njir Masidoniya. Ya vǝr na anǝ nda abǝr mbar hunau baˈanǝ shili ar kabangǝkau, nahyi njir Akaya nga vǝr yiwu hya lǝr sau. Huɗǝ hamǝr hyi a tsǝkur badǝgala nji aga nda mǝl sau. ");
INSERT INTO mfm_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","Kǝja tsu yu sǝwa hyi wazha ama kau, a dǝgya hyi aga ɓwadzǝr ˈya ǝnga hyi wu thlǝr kau a sara ɗa sǝ kurthlǝu. Wu yiwu yi aga hya nggya ǝnga ɓaɓathlǝ dzau, ǝnggǝr kǝra yi saya na hyu nda ɗa ta. ");
INSERT INTO mfm_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","Ma yi shili ǝkkǝˈyi njir Masidoniya, ma ndǝ sa thlǝwa hyi papatagǝu, yu nda gu sǝli arya fal kǝra ya vǝr fal hyi anǝ nda, aˈyi kǝl nayi ngǝ gu sǝli kǝ waci mai ama patǝ ǝkkǝˈyi hyi. ");
INSERT INTO mfm_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","Agabangau, tsam ɗa a mbari ya kǝdi wazha ama aga nda nda tular hyi kwatahǝu ǝnga nda nda duya pabǝr sǝ ar kǝra lǝ sǝ lǝlǝ kǝra hyi saya mǝliya alkawal ta. Aga ja ɗa lǝr sǝ ngau ǝnga ɗǝfu pathlǝu aˈyi lǝr sǝ kǝra ǝnga caca nyi mai. ");
INSERT INTO mfm_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","Hya ɗǝngari ja, kalar ndǝra thlǝkana culi kushu, ju nda gǝm sǝ zǝzǝwa kushu. Ama ndǝra thlǝkana culi gangǝu, ju nda gǝm sǝ zǝzǝwa gangǝu. ");
INSERT INTO mfm_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","Kalar ndǝ ja lǝri tsaˈa aga sǝra ɗǝfuwa ja nǝ nyi, arya Hyal a vǝr yiwu ndǝr lǝ sau ǝnga ɗǝfu pathlǝu. ");
INSERT INTO mfm_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","Hyal wu sǝn fǝnggǝr hyi mayiwakur nyi gagaɗau wu kalar sau, aga wu kalar pǝci, hyu nda uya sǝra hyu yiwu patǝu, ǝnga aga hya nyabiya dzau ǝnga mǝl kalar thlǝr mǝnahǝu. ");
INSERT INTO mfm_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","Ənggǝra nji tsǝfǝri abǝr, “Ju sǝn lǝ sǝ lǝlǝ nyi anǝ patǝr njir gha ǝnga tsi papahau, tsapǝkur nyi a nggyari baˈanuwa.” ");
INSERT INTO mfm_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","Hyal ndǝra wu lǝ culi anǝ ndǝr thlǝka, naja ngu lǝ sǝr sǝm anǝ ndǝr sǝm. Abangǝ tsu, Hyal wu lǝr hyi culi nǝ thlǝka ar kǝr ar kǝr ba valǝr hyi a nyabiya dzau ǝnga ba ja nyabiya hyi ǝnga faˈa sǝ zǝzǝwa nǝ tsapǝkur. ");
INSERT INTO mfm_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","Hyu nda ɗa njir gǝnna wu kalar lagu, aga hya ɗa njir lǝr sǝ ǝnga tsi papahau wu kalar pǝci. Lagur ˈya tsu, lǝr sǝ tsi papahǝr hyu nda shili ǝnga usaku anǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","Lǝr sǝ kau, aˈyi kǝl dlǝwa nji cici gǝ Thlagǝu nga ju mǝl waci mai, ama ǝtsu wu shili ǝnga madiya usaku anǝ Hyal wu lagu pampamǝu. ");
INSERT INTO mfm_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","Arya lagu lǝ sǝr hyi, nga hyi cabiya kǝrhyi nji gǝ Hyal. Agabangau, nju nda gǝnggǝr nyi sǝli anǝ Hyal ara ǝnggǝra hyi ɓǝlar ndǝr Hyal, ǝnga sǝra hyu nana ar kǝra ndǝshigu nǝ Kǝrsiti, ǝnga lǝ sǝr hyi anǝ nda ǝnga anǝ kalar nji ǝnga tsi papahau. ");
INSERT INTO mfm_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","Wu kǝdi Hyalǝr nda anǝ hyi, ndu nda ɗǝngar hyi wu ɗǝfuwa nda, arya madiya madiya mayiwakur nǝ Hyal kǝra ji cabiya hyi. ");
INSERT INTO mfm_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","Usaku anǝ Hyal arya lǝ sǝ lǝlǝ kǝra ji lǝri kǝra nji gǝra sǝn dǝgabiya. ");
INSERT INTO mfm_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","Lagur kiˈwakur ǝnga sǝsǝˈwu sǝ nǝ Kǝrsiti, nayi Bulusu ǝnga kǝrɗa, ndǝra nju ngga “Ndǝ sǝsǝli,” ma yu wu mwar hyi, ama “Ndǝ uˈul li” ma aˈyi yi a mwar hyi mai. ");
INSERT INTO mfm_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","Ya vǝr kǝdi hyi, ar pǝcira yi shili, aˈyi mbari abǝr kǝl yi sa ulǝna hyi li ǝnggǝr kǝra yi nggani ya mǝl anǝ alenyi nji mai, njira wu nggani abǝr ˈya vǝr nggya ǝnggǝr kǝra njir duniya wu yiwu. ");
INSERT INTO mfm_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","Alaga kǝ mǝna vǝr nggya wu duniya, par mǝn aˈyi ǝnggǝr kǝra njir duniya vǝr mǝl mai. ");
INSERT INTO mfm_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","Balmir mǝn aˈyi ǝnggǝr nǝ njir duniya mai. Ama pamǝ nga nda, aˈyi nda ǝnga dǝnama nǝ Hyal kǝra wu dlana patǝr dǝnama nǝ tǝlkur nǝ dawa. ");
INSERT INTO mfm_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","Mǝn wu wushina kalar sǝra wu kǝpal ǝnga kalar ɗǝnga ɓwaɓwadzǝ kǝra wu kar sǝnbiya sǝ ar kǝra Hyal. Ba mǝna dzǝgwa mbiya kalar ɗǝnga aga ja shili ǝnga ɓǝlar ndǝr Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","Aˈyi ˈya a yi taˈyau, aga ˈya nǝ nyi ɓwaɓwatǝu anǝ kalar ndǝra vǝr ɓǝlna ndǝr Hyal, ma ɓǝlar ndǝr Hyalǝr hyi a nyabiyar dzau. ");
INSERT INTO mfm_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","Hya tsam sǝra liya hyu lari! Ma ndǝra ǝnga papalkur kǝr na abǝr nǝ Kǝrsiti nga ja, ja tsambiya mǝnahǝu abǝr naˈya tsu ma nǝ Kǝrsiti nga ˈya. ");
INSERT INTO mfm_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","Ma ɗa ˈyi fǝr zǝr ɓwadzau ǝnga dǝnama tǝlkur kǝra Thlagǝ nǝ ˈya, sǝ aˈyi kǝra wu shili ǝnga sǝ sǝsǝli anǝ ɗa a gwa mai. Arya dǝnama tǝlkur kǝra ji nǝ ɗa kau aga hǝr hyi nga nyi a mwara dla hyi. ");
INSERT INTO mfm_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","Aˈyi yu yiwu ya gǝrahǝya hyi ǝnga cama tsǝtsǝfǝ ɗa ˈyar mai. ");
INSERT INTO mfm_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","Arya alenyi nju na, “Cama tsǝtsǝfǝˈyar nǝ Bulusu kau, kwakwaɗǝu ǝnga dzadzau nga nda, ama ma aˈyi ja ǝnga kǝrnyi aˈyi ja ndǝ kwakwaɗǝ mai, ǝnga ndǝr nyi tsu aˈyi ar viya vanyi sǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","Culi nji kǝ a kyaga sǝni abǝr pampamkur aˈyi wu pama sǝra ˈyi tsǝfǝya ma aˈyi ˈya mai, ǝnga sǝra ˈyu mǝl ma ˈya ˈyi. ");
INSERT INTO mfm_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","Naˈya sǝn gǝla ǝnga jiga kǝrˈya ǝnga njira hǝr kǝrnda ar viya vanyi sǝ mai. Njira tsu, nda a vǝr gǝla kǝrnda ǝnga kǝrnda, ǝnga ndu tǝkǝ kǝrnda ǝnga kǝrnda, nanda aˈyi nji hahangǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","Naˈya aˈyi wu nda ɓwadzǝ a ndiya sǝra ˈya kyaga ɗa mai, ǝnga aˈyi ˈyu piyari ɓwadzǝr ˈya a tǝrabiya a biya banga vi kǝra Hyal fiya anǝ ˈya mai, vi kǝra ji fiya patǝ ǝkkǝˈyi anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","Nahyi ǝnga kǝrhyi ma ar viya vira Hyal nǝ ˈya nga hyi aga ya mǝl thlǝr a gwa, ca ngǝ sǝra ɗa naˈyi maˈyi a biya banga fa ǝnga culi mai ar pǝcira ˈyi shili ǝnga ndǝshigu nǝ Kǝrsiti anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","Ɓwadzǝr ˈya aˈyi a ndiya sǝra tsatsaˈa mai ǝnga aˈyi sǝra tsǝkwar thlǝr alenyi nji mai. Ama cimǝr ˈya ca ngǝ mbǝrsar hyi a dumwa ǝnga hau, abangǝ tsu thlǝrǝr ˈya wu pama hyi, a dumwa ǝnga cakau gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","Aga ˈya daɓaga tǝtǝlna ndǝshigu a ndu ˈyiˈyir mǝlmǝ kǝra a biya banga hyi. Ama aˈyi yu yiwu ˈya ɓwadzǝ ǝnga sǝra alenyi nji mǝlna wu ˈyiˈyir nda mai. ");
INSERT INTO mfm_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","Ama “Bǝgǝ njira wu ɓwadzau nda ɓwadzau wu Thlagǝu.” ");
INSERT INTO mfm_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","Ara aˈyi ndǝra wu fal kǝrnyi ngǝ Thlagǝu wu dlǝwunggǝri ǝni mai, ama ndǝra Thlagǝu ǝnga kǝrnyi ngu fal nyi. ");
INSERT INTO mfm_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","Yu cim hya mbiya ɗǝfu ǝnga zǝr dzakur ɗa. Alaga kau, aˈyi hya vǝr mǝl kau. ");
INSERT INTO mfm_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","Ya vǝr ɗa shishi arya hyi culi shishikur nǝ Hyal. A mbabiya hyir yi alkawal nǝ hǝ dzau, nǝ hǝ sal zǝmǝu, naja ngǝ Kǝrsiti. Aga ya sa nǝr hyi nyi ar viya zǝkwamalagǝ kǝra cicau. ");
INSERT INTO mfm_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","Ama hivǝr ɗa ca ngǝ ja sara ɗa ǝnggǝr kǝra pabǝ ǝnga tsǝtsǝlkur nyi nggutana Hawawu a gu fa wu ta, ja sara bǝlana ɗǝngar hyi ara lǝr kǝrhyi nyinyau ǝnga cicau anǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","Ara ma vanyi ndǝ shili ji sa nar hyi ndǝr ar kǝra vanyi Yesu pamǝ a mwara Yesu kǝra ˈyi nar hyi kau, alaga hyi dlǝwuri vanyi mambǝl a mwara kǝra hyi dlǝwuri kau, ǝnga alaga vanyi ndǝshigu pamǝ a mwara kǝra hyi dlǝwuri kau, ba hyi dlǝwunggǝri ǝnga nda kusakusa, ama aˈyi a ki abangǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","Nayi aˈyi nggani abǝr njira nju ngga ǝnga “cama sǝsǝ nggunggurǝmˈyar” a ndiya ɗa ǝnga vanyi sǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","Tara aˈyi nji hwathliya ɗa wu lagur sǝn ndǝr mai, ama wu sǝni yi sau. A cabiya hyir ˈya sǝˈyar kǝ ar babal wu kalar lagu. ");
INSERT INTO mfm_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","A ɗar yi ndǝr bikǝ ma yi hǝya kǝr aga ya hyaˈana hyi lagur tǝtǝlna hyi ndǝshigu nǝ Hyal kǝ kurthlǝ ya? ");
INSERT INTO mfm_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","A ɗari ǝnggǝr yi mbǝliya sǝ ara alenyi daɓǝ dzǝ njir nu pampam ma ndǝ lǝ sǝ lǝlau, aga ya dzǝgwa mǝl thlǝr ǝni anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","Ar pǝcira yi ǝnga hyi yu ghar sau, ama nayi aˈyi fǝnggǝr hyi ghar sǝ ɗa ar kǝra hyi mai, ara wazha ama kǝra shili sara wu Masidoniya ngǝ nǝ ɗa kalar sǝra yu yiwu wu ghar sǝ ɗa. Ar pǝci ta nayi fǝnggǝr hyi ghar sǝ ɗa mai, abangǝ nga yu dumwa ǝnga mǝl. ");
INSERT INTO mfm_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","Ənggǝr kǝra jirkur nǝ Kǝrsiti aˈyi wu yau, ndǝ aˈyi wu ˈyiˈyir Akaya kǝra wu sǝn kar ɗa ara ɓwadzǝ ɗa kǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","Mi ngǝ ɗa yu na abanga? Ara nayi aˈyi wu yiwu hyi mai ya? Hyal wu sǝni abǝr yu yiwu hyi. ");
INSERT INTO mfm_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","Ama yu ɓǝra dumwa ǝnga mǝl sǝra ya vǝr mǝl aga ya kar “cama sǝsǝ nggunggurǝmˈyar” ara ɓwadzǝ abǝr thlǝr kǝra nda vǝr mǝl kakal ǝnga nǝr ˈya. ");
INSERT INTO mfm_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","Ama culi nji kau, cama sǝsǝ fafati nga nda, njir ngguta vi, njira wu fiya kǝrnda ǝnggǝr cama sǝsǝ nǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","Aˈyi sǝ dǝdǝgur mai, alaga Shatan ǝnga kǝrnyi a fiyar ja kǝrnyi ǝnggǝr waladi nǝ mbǝmbǝl. ");
INSERT INTO mfm_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","Agabangau, aˈyi sǝ dǝdǝgur ngǝ ma njir mǝl thlǝr anǝ nyi shabiya kǝrnda aga njir mǝl thlǝr nǝ tsapǝkur mai. Ama wu jomǝ ndǝl ndu nda dlǝwuri sǝra tsaˈa aga thlǝrǝr nda. ");
INSERT INTO mfm_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","Ya ɓǝra nar hyi, ndǝ a sara fǝ ɗa aga ndǝ dza mai. Ama ma hyi lar ɗa ǝnggǝr dza, ya, taˈyi hya hǝri ɗa abangau, aga ya uya lagur zǝr ɓwadzau. ");
INSERT INTO mfm_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","Wu ɓwadzǝ ɗa ar kǝra kǝrɗa, aˈyi ya vǝr ndǝr ǝnggǝr Thlagǝ nga vǝr ndǝr mai, ama ǝnggǝr ndǝ dza. ");
INSERT INTO mfm_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","Ta ɗa nji gangǝ a vǝr ɓwadzǝr nda ǝnggǝr kǝra njir duniya, taˈyi nayi tsu ya ɓwadzau. ");
INSERT INTO mfm_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","Nahyi ǝnga caguli nga hya vǝr nggya ǝnga nji dza, arya nji hahangǝ nga hyi. ");
INSERT INTO mfm_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","Ənga jiri tsu, hyu sǝn nggya ǝnga njira wu fuwa hyi wu mafakur, ǝnga alaga njir shishiɓǝ hyi, ǝnga alaga njir ɗiya hyi, ǝnga alaga njir ca gaukur anǝ hyi, ǝnga alaga njir dǝgǝ hyi wu bama hyi. ");
INSERT INTO mfm_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","A ɗari sǝ sǝsǝli anǝ ɗa ya hǝnggǝri abǝr arya kukufǝkurǝr ˈya ngǝ ɗa naˈyi mǝliya sǝˈyar kǝ mai. Ama ma vanyi ndǝ cabiya salkur, ba ji ɓwadzau ǝnga vanyi sau, nayi ma yu mǝliya abangǝ tsu. Ənggau, yu ndǝr ǝnggǝr ndǝ dza. ");
INSERT INTO mfm_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","Ma nanda njir Ibrani, nayi ma abangau. Ma nanda njir Izirayila, nayi ma abangau. Ma nanda culi Ibrahimu, nayi ma abangǝ tsu. ");
INSERT INTO mfm_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","Ma nanda njir mǝl thlǝr Kǝrsiti, nayi nga ndiya nda patǝu. (Ya vǝr ndǝr kau ǝnggǝr ndǝr thlǝkau.) A mǝlǝr yi thlǝr a ndiya nda patǝu, a fuwa ɗar nji wu fursǝna aga gangǝu, a dlǝwuri yi dǝgǝ ǝnga wuɗa aga gangǝu, ǝnga a gwar yi wu miya tau ar kǝr ar kǝr. ");
INSERT INTO mfm_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","Aga tǝfu ngǝ njir Yahudiya dǝgǝ ɗa ǝnga wuɗa makǝr kumunyi apǝ ǝdlau. ");
INSERT INTO mfm_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","Aga makǝr nga nji dǝgǝ ɗa ǝnga wuɗa liyangǝ. Nji vavaka ɗa nǝ tsa ǝnga tsǝka aga zǝmǝu. Aga makǝr ngǝ kwambwal mbuya dzǝ ǝnga yau. Yi hǝna vuˈyi ǝnga pǝci a gwar tsadau, kadivira nji kǝtiya ɗa. ");
INSERT INTO mfm_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","Wu ɓǝɓǝ ɗa patǝu, a ɓǝr yi ǝnga asar pampamǝu a gwar dǝl, ǝnga yi tǝɗau wu tsa njir ɗalagu. A lar yi asar wu tsa njir Yahudiya zamǝ ɗa ˈyar, ǝnga njira aˈyi njir Yahudiya mai. A nyir yi ǝnga gu asar wu huɗa mǝlmau, ǝnga miya tagǝu, ǝnga tsu a nyir yi ǝnga gu asar a gwar tsadau, ba ǝtsu a nyir yi ǝnga gu asar wu tsa wazha ama nǝ fafati. ");
INSERT INTO mfm_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","A mǝlǝr yi thlǝr gagaɗau wu ɓwaɓwatǝ gagaɗau, ǝnga a nyir yi ǝnga pida liliˈu. A nggyar yi ǝnga wuɓau ba hili nǝ pǝci gangǝu, ǝnga a nggyar yi nǝ pǝci gangǝ gǝra sǝm sǝr sǝm. A nggyar yi turusu, ǝnga a nggyar yi ar yambaɗǝu. ");
INSERT INTO mfm_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","A biya banga kalar sau, wu kalar pǝci aˈyi yi ǝnga ɗǝfu tǝdǝɓǝu, aga ya sǝn daɓǝr kǝra daɓǝ njir nu papatǝu. ");
INSERT INTO mfm_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","Ma ndǝ aˈyi ǝnga tǝtǝwakur, nayi ma yu nggar tǝtǝwakur nyi kau. Ma vanyi ndǝ mǝliya bikau, ba ja fuwa ɗa wu ndzǝ huɗǝ gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","Ma a ɗari kǝl yi ɓwadzau, ba ya ɓwadzǝ ǝnga tǝtǝwakur ɗa. ");
INSERT INTO mfm_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","Hyal ǝnga dǝya Thlagǝr mǝn Yesu Kǝrsiti, ndǝra anǝ nyi ngǝ fal baˈanuwa, wu sǝni abǝr aˈyi fati nga yu thla mai. ");
INSERT INTO mfm_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","Ar pǝcira yi wu Damasǝkasu, ar pǝcir tǝlkur Aristasu ngǝ gwamna dana miya gwar mǝlmau aga nja mbar ɗa. ");
INSERT INTO mfm_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","Ama kǝ bazhi ɗa ˈyar hǝya ɗa a gya wu tsǝla lagu liya mahwal nǝ mǝlmau aga ya mbǝlbiya dzǝ wu tsa ja. ");
INSERT INTO mfm_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","Kǝl ya dumwa ǝnga ɓwadzǝ alaga kǝ sǝ aˈyi nju uya a gwa mai kau. Kabangǝkau, yu dumwa ǝnga ndǝr ar kǝra sǝn zǝgǝu ǝnga mǝtakǝr kǝra yi uya sara ara Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","Yu sǝni vanyi ndǝ aˈyi wu Kǝrsiti nji saya hǝr nyi a dǝmǝlmǝ nǝ makǝru wu fa kumo apǝ foɗǝ kǝra tǝrabiya kau. Tara wu kumǝr dzau ǝnga tara wu mambǝl, nayi wu sǝn mai, ama kǝl Hyal ngu sǝni. ");
INSERT INTO mfm_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","Ənga yu sǝn ndǝ kau, tara wu kumǝr dzau ǝnga tara wu mambǝl, nayi wu sǝn mai, ama Hyal wu sǝni, ");
INSERT INTO mfm_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","nji hǝr nyi a dǝmǝlmau. A dǝna ji nggari sǝra nji gǝra sǝn dǝgabiya ǝnga miya, sǝra aˈyi nji piyari nyi anǝ ndǝ ja nana mai. ");
INSERT INTO mfm_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","Yu sǝn ɓwadzǝ arya culi ndǝ ǝnggǝr kau, ama aˈyi arya kǝrɗa mai, ama kǝl arya tǝtǝwakur ɗa. ");
INSERT INTO mfm_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","Ma sǝn ɗa yu ɓwadzau, aˈyi wu sǝn mǝliya ɗa ya ɗa ndǝ dza mai, arya yu nda na sǝra jijiri. Ama ba yi piyari ɓwadzau, ara nayi yu yiwu nja hǝr ɗa a ndiya sǝra ya aga nyi mai, lagur sǝra yu na ǝnga sǝra yu mǝl. ");
INSERT INTO mfm_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","Ara ya sara ɗa ndǝr ɓwadzau, arya gangǝkura mǝtakǝr kǝra yi uya, ba nji fuwa ɗa shilǝgǝ wu dzau, kǝra ɗa ǝnggǝr shikǝɗi. Naja cama shatan ngau, aga ja nǝ ɗa ɓwaɓwatǝu, a sara ya ɗa ndǝr ɓwadzau. ");
INSERT INTO mfm_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","Aga makǝr ya vǝr kǝdi Hyal aga ja hǝna ɗa shikǝɗi kau. ");
INSERT INTO mfm_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","Ama ba ji na anǝ ɗa, abǝr, “Mayiwakur ɗa a citǝ ngǝ ri, ara dǝnama ɗa wu nyabiya dzǝ wu tǝtǝwakur ngau.” Agabangau, yu ɓǝra cakǝri ɓwadzau wu tǝtǝwakur ɗa ǝnga caguli aga dǝnama Kǝrsiti a nggya wu yau. ");
INSERT INTO mfm_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","Ca ngǝ sǝra ɗa wu Kǝrsiti yu caguli ǝnga tǝtǝwakur ɗa, ǝnga ma nju nggǝl ɗa ǝnga ma yi wu ɓwaɓwatǝu ba ǝnga wu nggyabiya dzadzau. Arya ma yu tǝtǝwakur ba ya ɗa ǝnga dǝnama. ");
INSERT INTO mfm_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","A ɗar yi ndǝ dza, ama nahyi ngǝ mǝliya ɗa yi ɗa abangau. Nahyi ngǝ tsaˈa aga faliya ɗa. Alaga kǝ nayi aˈyi ar viya vanyi sǝ mai, aˈyi ɗa abǝr “cama sǝsǝ nggunggurum” nǝr hyi ˈyar kau, a ndiya ɗa mai. ");
INSERT INTO mfm_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","Hyal a cabiyari abǝr nayi cama sǝsǝ jijiri nga yau, lagur mǝtsam ǝnga sǝ dǝdǝgur kǝra yi mǝlna wu pama hyi, wu mba ɗǝfu ɗa. ");
INSERT INTO mfm_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","Lagu mani nga yi cabiya abǝr nahyi aˈyi kakal ǝnga alenyi daɓǝ dzǝ njir nu maya? Əndǝga ara yi nggǝl ara dlǝwu dlǝwa dzǝ ara hyi ya? Ya, ba hya tǝfǝbiya ɗa najaka bikau. ");
INSERT INTO mfm_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","A pabǝr yi dzǝ aga ya nda tular hyi nǝ makǝrkura nyi, ama nayu yiwu ya nda ɗa kar tǝdǝɓǝu anǝ hyi mai. Aˈyi sǝr hyi nga yu yiwu mai, ama nahyi ǝnga kǝrhyi. Arya aˈyi ɗa tsaˈa wazha nga hǝ tǝdǝɓǝkur nǝ njir ya mai, ama njir ya nga hǝ tǝdǝɓǝkur nǝ wazha. ");
INSERT INTO mfm_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","Abangau, ǝnga huɗǝ pipida nga yu tsiya sǝra ara yau, daɓǝ ǝnga kǝrɗa aga ya dlǝwar hyi. Ma yu ca yiwukur anǝ hyi gagaɗau, ba hya dzǝgwa gǝnna yiwukurǝr hyi anǝ ɗa ya? ");
INSERT INTO mfm_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","Hyu dlǝwunggǝri abǝr nayi saya ɗa kar tǝdǝɓǝ anǝ hyi mai. Ama vanyi ndu sǝn na abǝr yi nggutana hyi, ba ǝnga yi sǝmku hyi ǝnga fati. ");
INSERT INTO mfm_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","Hyu nggani yi sǝmku hyi lagur njira yi sǝwa hyi kǝ ya? ");
INSERT INTO mfm_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","Yi kǝdi Tayitusu aga ja maˈyi a ndǝra hyi, ǝnga yi sǝwa vanyi zamǝr mǝn ǝnga ja. Hyu nggani abǝr Tayitusu sǝmku hyi ya? Aˈyi ˈyi mǝl thlǝr wu mambǝl zǝmǝ ǝnga ˈyi nu lagu zǝmǝ ǝnga ja wa? ");
INSERT INTO mfm_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","Əndǝga hyu nggani abǝr ˈyu kǝtǝ kǝrˈya ar kǝra sǝra ˈyu mǝl wu mwar hyi ya? Hyal ngǝ sakidar ˈya abǝr ˈya vǝr thla jiri wu Kǝrsiti. Patǝr sǝra ˈyu mǝl, sǝr cakǝ hyi ngǝ bazhir ˈwa ɗa ˈyar. ");
INSERT INTO mfm_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","Ara hivǝr ɗa ya sara tini thlǝwa hyi ǝnggǝr kǝra yu yiwu, ǝnga nahyi ma hya sara tini thlǝwa ɗa ǝnggǝr kǝra hyu yiwu hya lari ɗa. Hivǝr ɗa ca ngǝ ya sara shili ya sa thlǝwa nju pa, ǝnga ca shishikur, ǝnga kwakwaɗǝ ɗǝfu, ǝnga yiwu kǝr, ǝnga ndza thlǝmǝ, ǝnga na ndau, ǝnga ɓwadzau, ba ǝnga gwazhi vi. ");
INSERT INTO mfm_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","Yu hivǝr ara ma yi ɓǝra sha shili, ba Hyal a sa fuwa ɗa wu sǝli wu mwar hyi. Yu hivǝr a sara huɗa ya sa ndzau ma yi sa lar badǝgala hyi, tsu hyi wu nggya nǝ bikau ǝnggǝr nǝ ɗǝɗǝmǝ ta, tsu hyi gǝra tubi, njir mǝl sǝ gǝra kyau ǝnga njir mǝl sǝsukur, ǝnga njir suna nǝ shiˈwau kǝra ndǝ fuwa kǝrnda a gwa. ");
INSERT INTO mfm_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","Najakǝ ngǝ shili ɗa a sa tula hyi nǝ makǝrkura nyi. “Kalar ndǝr ja ɗa tsaˈa, ma ji biya sara wu miya sakida mǝthlǝu alaga makǝru.” ");
INSERT INTO mfm_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","Ar pǝcira yi shili nǝ mǝthlǝkura nyi, a saya tǝɗar yi himiya njir mǝl bikau ǝnga alenyi nji aga nda piyari mǝl bikau. Kabangǝkau, yu ɓǝra tǝɗar himiya hyi alaga kǝ nayi aˈyi yi ǝnga hyi kǝ mai. Ar pǝcira yi ɓǝra sha shili ǝnga kǝrɗa nayi wu sa hyi njir bikǝ mai. ");
INSERT INTO mfm_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","Ta ɗari hyu yiwu hya uya sakida kǝra cabiya abǝr Kǝrsiti nga vǝr ndǝr lagu ɗa. Ya, kǝja sakida, aˈyi ja tǝtǝwa lagur mǝl thlǝr ǝnga hyi mai, ama aˈyi ja ǝnga dǝnama wu pama hyi. ");
INSERT INTO mfm_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","Aga nja nggya ǝnga sǝnbiya abǝr, nji dlakǝya nyi arya kukufǝkur nyi, alaga abangau, aˈyi ja ǝnga pi wu dǝnamar Hyal. Agabangǝ tsu, alaga kǝ mǝn kukufu wu ja kau, ama lagu dǝnama Hyal aˈyi mǝn ǝnga pi ǝnga ja aga thlǝr kǝra ˈya vǝr mǝl wu hyi. ");
INSERT INTO mfm_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","Hya tsambiya kǝrhyi mǝnahǝu tara tsu hyi wu mbǝrsa. Hya dumwa ǝnga dzǝbiya dzau. Aˈyi hyu sǝni abǝr Kǝrsiti Yesu a vǝr nggya wu hyi wa? Ma nahyi aˈyi wu sǝni abangǝ mai, a cabiyari abǝr a dlar hyi wu dzǝbiya dzǝ kau. ");
INSERT INTO mfm_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","Ənga cim ɗa abǝr hyu nda sǝnbiya abǝr a sǝmkur ˈya najaka dzau. ");
INSERT INTO mfm_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","Ama ˈya vǝr kǝdi Hyal a sara hya mǝliya sǝra aˈyi tsatsaˈa mai. Aˈyi aga nja lari abǝr a sǝmkur ˈya dzǝ kǝ mai, ama aga hya ɗa njir mǝl sǝra tsatsaˈa, alaga kǝ nju nda nggani abǝr dladla nga ˈya. ");
INSERT INTO mfm_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","Ara ˈyu nda nu sǝra jijiri, aˈyi ˈyu ɓǝra mǝl sǝra dawa ǝnga ja mai. ");
INSERT INTO mfm_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","Caguli nga ˈyu caguli wu kukufǝkur ˈya, ǝnga nahyi aˈyi hyi ǝnga dǝnama. Kǝdi Hyalǝr ˈya ca ngǝ hya ɗa njira nyabiya dzau. ");
INSERT INTO mfm_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","Ca ngǝ sǝra ɗa yi tsǝfǝya hyi najaka cama tsǝtsǝfau ar pǝcira aˈyi yi ǝkkǝˈyi hyi mai, aga ma yi shili, ya sara sa ndǝr ǝnga tsa anǝ hyi, ara dǝnama nǝ tǝlkur kǝra Thlagǝ nǝ ɗa nǝ hǝr ngau, aˈyi aga ya dlana hyi mai. ");
INSERT INTO mfm_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","Wu yukuɗa sǝ patǝu, wazha ama, kǝl vanyi pǝci. Hya gal nyabiya dzau, ǝnga hya nggar kǝdi ɗa, ǝnga hya dlǝwunggǝri ǝnga kǝrhyi, ǝnga hya nggya jamǝu. Lagu kǝ ngǝ Hyal ndǝr yiwudzau ǝnga nggya jamǝu, ju nggya ǝkkǝˈyi hyi. ");
INSERT INTO mfm_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","Hya usar dzau ǝnga bǝrpǝ dzau nǝ yiwukur kǝra cicau ");
INSERT INTO mfm_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","Nji cici gǝ Hyal patǝ nda vǝr usa hyi. ");
INSERT INTO mfm_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","Bǝgǝ mayiwakur nǝ Thlagǝu Yesu Kǝrsiti, ǝnga yiwukur Hyal, ǝnga daɓǝ dzǝ nǝ Mambǝl Cicau, ja nggya ǝnga hyi patǝu. Amina.");
INSERT INTO mfm_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","Cama tsǝtsǝfau sara ara Bulusu, cama sǝsǝ nǝ Yesu. Aˈyi nji ǝnga alaga ndǝ ngǝ sǝ ɗa mai. Ama Yesu Kǝrsiti ǝnga Hyal Tada ngǝ sǝ ɗa, ndǝra hyaˈana nyi sara vir tau. ");
INSERT INTO mfm_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","Naˈya ǝnga patǝkura wazha ama kǝra ǝnga yau, nga vǝr sǝ cama kau, anǝ patǝkura njir nu, njira wu Galatiya. ");
INSERT INTO mfm_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","Mayiwakur ǝnga huɗǝ pǝrtǝu sara ara Dǝrmǝn Hyal ǝnga Yesu Kǝrsiti nda nggya ǝnga hyi. ");
INSERT INTO mfm_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","Yesu Kǝrsiti lǝr kǝrnyi arya bikǝr mǝn, aga ja mbǝɗana mǝn sara ara nggyabiya ɗǝmwaˈyi kau, ǝnggǝra Hyalǝr mǝn wu yiwu. ");
INSERT INTO mfm_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","Bǝgǝ kadakadarkur a nggya nǝ nyi baˈanuwa. Amina. ");
INSERT INTO mfm_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","Sǝra hya vǝr mǝl kau a ɗari sǝr hivǝr gagaɗau anǝ ɗa. Wu pǝci kushu ǝnggǝr kau, kǝja hya piyar nu ndǝra nggar hyi lagu mayiwakur Kǝrsiti, ka tǝkǝri hyi nu vanyi ndǝshigu mafǝliyangǝu. ");
INSERT INTO mfm_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","Ya, vanyi ndǝshigu pamǝ aˈyi mai. Yi nar hyi abangau, ara alenyi nju hya hangǝkala hyi, ndu nǝrdzǝ aga nda bǝlana jirkur nǝ ndǝshigu nǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","Ama yu na anǝ hyi, ma vanyi ndǝ aˈyi wu pama ˈya kǝra wu shili ǝnga vanyi ndǝshigu pamǝ a mwara kǝra ˈyi nǝ hyi kau, alaga waladi kǝra sara dǝmǝlmǝ ngau, bǝgǝ nda nyi a ɗa ndǝ shishiˈwau! ");
INSERT INTO mfm_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","Ənggǝr kǝra ˈyi nar hyi tsu kaɗǝu, yu ɓǝra nar hyi abangǝ tsu, abǝr kalar ndǝra ɓǝra nar hyi vanyi ndǝshigu pamǝ a mwara kǝra hyi dlǝwuri kau, bǝgǝ ja ɗa ndǝ shishiˈwau! ");
INSERT INTO mfm_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","Hyu nggani yu gal dlǝwu dzau ara nji ǝndǝga ara Hyal ya? Əndǝga yu gal aga nja fal ɗa ya? Awau! Maja huɗa nji nga yu yiwu ya pina, nayi ɗa ndǝr mǝl thlǝr Kǝrsiti mai. ");
INSERT INTO mfm_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","Wazha ama, yu yiwu hya sǝni abǝr ndǝshigu kǝra yi tǝtǝlna anǝ hyi kau, aˈyi sara ara ndǝ nga nyi mai. ");
INSERT INTO mfm_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","Nayi dlǝwuri sara ara ndǝ mai. Ənga ǝtsu aˈyi ndǝ ngǝ highiɓǝ anǝ ɗa mai. Yesu Kǝrsiti ǝnga kǝrnyi ngǝ cabiya ɗa. ");
INSERT INTO mfm_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","A nggari hyi culi nggyabiya ɗa kǝra ɗǝɗǝmǝu, wu sǝr nu nǝ njir Yahudiya, ǝnggǝra yi nǝ nyi ɓwaɓwatǝ gagaɗǝ anǝ njir nu Hyal ǝnga jirkur. Kǝra tǝkǝri yu yiwu aga ya tǝtǝlna kǝra njir nuwur nda. ");
INSERT INTO mfm_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","Nahyi tsu, a sǝnǝr hyi ǝnggǝra yi nu sǝra njir Yahudiya wu nu. Yu ndiya badǝgala njir Yahudiya njira ˈyi hǝ wu nu sǝr ciji ǝnga nda ǝnga ɗǝfu hamu. ");
INSERT INTO mfm_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","Ama Hyal wu mayiwakur nyi, ji caɗǝbiya ɗa kadivira nji ya ɗa. Ənga ǝtsu ji ngga ɗa, ba ji ");
INSERT INTO mfm_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","pahǝna liya yau aga ya lari Zǝr nyi. Ənga aga ya tǝtǝlna ndǝshigu mǝsahǝu anǝ njira aˈyi njir Yahudiya mai. Ar pǝci ta, nayi gal sǝmana ara ndǝ mai, ");
INSERT INTO mfm_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","ǝnga tsu nayi maˈyi a vu Urshalima a vu gya njira ɗa cama sǝsǝ a mwara yi mai. Ənggǝrna ba yi maˈyi a ndar ˈyiˈyir njir Arabiya, ǝnggau ba yi sha shili wu mǝlmǝ Damasǝkasu. ");
INSERT INTO mfm_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","Kǝl ayukuɗa fa makǝru, ba yi maˈyi a vu Urshalima aga ya vuwa lari Kefasu, naja ngǝ Simanu Biturusu. Ətsu kǝ yi mǝliya pida kumou apǝ tǝfu nga ja. ");
INSERT INTO mfm_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","Ar pǝci ta, nayi lari alaga ndǝ zǝmǝ wu pama cama sǝsǝ mai, kǝl Yakubu zamiya Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","Ənga jiri yu nar hyi wu mwar Hyal, sǝra ya vǝr tsǝfau anǝ hyi kau, aˈyi fati mai. ");
INSERT INTO mfm_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","Ayukuɗǝ tsu, kǝ yi maˈyi a ndar ˈyiˈyir Sǝriya, ǝnga ˈyiˈyir Silisiya. ");
INSERT INTO mfm_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","Ama ar pǝci ta, njir nu Kǝrsiti kǝra aˈyi wu ˈyiˈyir Yahudi, nandǝ wu sǝn ɗa bama ǝnga bama kwatahǝ mai. ");
INSERT INTO mfm_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","Nanda tsu a nggar nda, nji na, “Ndǝra ɗǝɗǝmǝ ji lǝr ɓwaɓwatǝ anǝ ˈya, kabangǝkau, kǝja ju na ndǝr mbǝrsa ar kǝra ndǝr kǝra ɗǝɗǝmǝ ju dza!” ");
INSERT INTO mfm_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","Kǝ ndǝ fal Hyal arya sǝra ji mǝl lagu ɗa. ");
INSERT INTO mfm_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","Ayukuɗa fa kumou apǝ foɗǝu, yi ɓǝra sha a vu Urshalima. Wu pǝci kau, nayi ǝnga Barnabasu ngǝ maˈyi, ba tsu ˈyi hǝri Tayitusu. ");
INSERT INTO mfm_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","Yi maˈyi a ndara nda ara Hyal ngǝ cabiya ɗa wu mǝtakǝr aga ya maˈyi. Ta yi nda, ba yi nda ɓǝ ǝkkǝˈyi alenyi njir tǝɗǝmwa nǝ njir nu Yesu, ba yi cabiya nda zhizhir nda ar kǝra ndǝshigu kǝra yi tǝtǝlna anǝ njira aˈyi njir Yahudiya mai. Yi cabiya nda najaka sau, aga ya sǝnbiya abǝr nayi ǝnga nda a hǝnggǝr ˈya ar kǝra thlǝr kau, ǝnga a sara nǝrdzǝ ɗa wu thlǝr kǝra ya vǝr mǝl ǝnga kǝra yi mǝlna a ɗa sǝ kurthlǝu. ");
INSERT INTO mfm_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","Alaga bazhi ɓǝ ɗa Tayitusu kǝra ndǝr Gǝrikǝ ngau, nji aˈyi ciwa nyi aga nja thlana nyi pǝlzha mai. ");
INSERT INTO mfm_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","Ndǝr ar kǝra thla pǝlzha kǝ hyaˈari sara ara njir nu nǝ fafati kǝra shili ɗǝɗǝwa. Ndǝ shili wu pama ˈya aga nda sa tsambiya nggyabiyar ˈya wu Kǝrsiti Yesu, aga nda ɓǝra shabiya ˈya aga mafa. ");
INSERT INTO mfm_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","Ama alaga kushu naˈyi hǝnggǝri ǝnga nda mai, arya ˈyu yiwu ˈya tsǝrpǝr hyi jirkura ndǝshigu kau. ");
INSERT INTO mfm_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","Ama alaga njir tǝɗǝmwar nda, nandǝ cakǝri sǝ ar kǝra sǝra yi highiɓǝ kǝ mai, (wu ɗǝnga ɗa alaga wa nga nda, patǝ lagu zǝmǝ nga nda anǝ ɗa, arya Hyal wu ca pampamǝkur mai). ");
INSERT INTO mfm_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","Nanda ǝnga kǝrnda tsu a lar nda ǝnggǝra Hyal hǝnggǝri ji nǝ ɗa thlǝr tǝtǝlna ndǝshigu anǝ njira gǝra aˈyi njir Yahudiya mai, ǝnggǝr kǝra ji nǝ nyi anǝ Biturusu thlǝr tǝtǝlna ndǝshigu anǝ njir Yahudiya. ");
INSERT INTO mfm_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","Kǝja Hyal kǝra mǝl thlǝr lagur Biturusu aga mǝl thlǝr anǝ njir Yahudiya, naja tsu ngǝ mǝl thlǝr lagu ɗa aga ya ɗa cama sǝsau anǝ njira aˈyi njir Yahudiya mai. ");
INSERT INTO mfm_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","Ənggǝra ndǝ lar ǝnggǝra Hyal cabiya ɗa mayiwakur nyi abangau, ba Yakubu, ǝnga Biturusu, ba Yahwana hǝnggǝri ǝnga yau. Nanda kǝra njir tǝɗǝmwa anǝ njir nu Yesu, ndǝ dlǝwur ˈya ǝnga Barnabasu ǝnga huɗǝ zǝmǝu. ˈYi hǝnggǝri wu pama ˈya aga ˈya maˈyi a ndǝgya njira aˈyi njir Yahudiya mai, ǝnga nanda tsu nda maˈyi a ndǝgya njir Yahudiya. ");
INSERT INTO mfm_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","Kǝl kǝ ndǝ ɗǝngari ˈya abǝr ˈya sara fari ǝnga nji ɗaɗali kǝra wu pama nda mai. Alaga kǝ tsu kaɗǝu ya vǝr cim ya mǝl abangau. ");
INSERT INTO mfm_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","Ar pǝci kǝra Biturusu shili wu mǝlmǝ Antakiya, kǝ yi kughiya nyi a du bama ja, arya sǝr mǝla ja aˈyi tsaˈa mai. ");
INSERT INTO mfm_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","Tsu kaɗǝu ju sǝm sǝr sǝm ǝnga njir nu Yesu njira aˈyi njir Yahudiya mai. Ama ayukuɗa shilǝr njira Yakubu sǝwa a shili wu Antakiya, kǝ Biturusu tsana dzau, ji ɗa pamǝu. Ji mǝl abangau arya ju hivǝr njira wu yiwu nja thlana nyi pǝlzha anǝ njira aˈyi njir Yahudiya mai. ");
INSERT INTO mfm_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","Abangǝ ma alenyi njir Yahudiya njir nu Yesu mǝl culi najaka ngguta vi ǝnggǝr nǝ Biturusu kau. Sǝr mǝla nda kǝ tsu ma, ka bǝlana hangǝkala Barnabasu. ");
INSERT INTO mfm_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","Ama ta yi lari sǝr mǝla nda aˈyi wu nu jirkur nǝ ndǝshigu mai, kǝ yi kughiya Biturusu wu mwar nji patǝu, “Nagau, ndǝr Yahudiya ngau, ama kǝja gu nggya ǝnggǝr njira aˈyi njir Yahudiya mai. Nagǝ aˈyi wu nggya ǝnggǝr njir Yahudiya mai. Aga mi nga gu ca njira aˈyi njir Yahudiya mai, aga nda nu sǝr ciji nǝ Yahudiya ka?” ");
INSERT INTO mfm_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","“Alaga kǝ namǝn njir Yahudiya ngau lagur ya, aˈyi njira gǝra njir Yahudiya njir bikǝ mai, ");
INSERT INTO mfm_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","wu sǝn mǝn abǝr ndǝ aˈyi a sǝn uya nggya tsapǝu wu mwar Hyal lagur nu dlaɗǝ mai, kǝl ma ji mbǝrsa ǝnga Yesu Kǝrsiti. Agabangau, namǝn ma a lǝr mǝn kǝrmǝn anǝ Kǝrsiti Yesu, aga mǝna ɗa nji tsapǝu wu mwar Hyal lagur mbǝrsa ǝnga Kǝrsiti ama aˈyi lagur nu dlaɗǝ mai. Arya ndǝ a sǝn uya nggya tsapǝ wu mwar Hyal lagur nu dlaɗǝ mai. ");
INSERT INTO mfm_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","Ama ar pǝcira mǝn wu yiwu mǝna ɗa nji tsapǝu wu mwar Hyal lagur mbǝrsa wu Kǝrsiti, ama ba nji thlǝwa mǝn ǝnga kǝrmǝn njir bikau. Kǝ a cabiyari abǝr Kǝrsiti wu tsǝtsǝku aga nja mǝl bikǝ ya? Awau, alaga kushu! ");
INSERT INTO mfm_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","“Ama ma yi ɓǝra hǝr sǝra yi vakana tsu kaɗǝu a cabiyari abǝr nayi ndǝr ɓǝl dlaɗǝ ngau. ");
INSERT INTO mfm_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","Lagu nu dlaɗau, a ɗar yi tǝtau anǝ dlaɗau, aga ya nggya nǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","A dlakǝya ɗar nji ǝnga Kǝrsiti. Kabangǝkau, aˈyi mbǝmbǝɗǝ nga nyi mai, ama Kǝrsiti ngu nggya wu yau. Najaka nggya kǝra yu nggya wu kumǝr dzau, nggya nǝ mbǝrsa ǝnga Zǝr Hyal, ndǝra yiwu ɗa ba ji tau arya yau. ");
INSERT INTO mfm_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","Nayi wu piyari mayiwakur nǝ Hyal mai. Arya ma ndu sǝn uya nggya tsapǝ wu mwar Hyal lagur nu dlaɗau, ka cabiyari abǝr tǝr Kǝrsiti a ɗari sǝ kurthlǝu.” ");
INSERT INTO mfm_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","Nahyi njir Galatiya, thlǝkǝ wu tǝ hyi ya? Əndǝga vanyi ndǝ gwaɗǝr kǝra hyi ya? Kǝja ar babal nga yi cabiya hyi Yesu Kǝrsiti ndǝra tǝ ar wu dladlakau. ");
INSERT INTO mfm_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","Kabangǝkau, yu yiwu ya yiwar hyi vanyi sau. Mambǝl Hyal shida ar kǝra hyi arya hyi nu dlaɗǝ ya, ǝndǝga ara hyi hǝnggǝri ǝnga ndǝr kǝra hyi nggari ya? ");
INSERT INTO mfm_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","Kabangǝkau, thlǝkǝ wu tǝ hyi ya? Kǝja hyi dzǝguya wu Mambǝl, ama kǝja hya ɓǝra jamuya wu ndǝndǝkur! ");
INSERT INTO mfm_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","Ya, culi ɓwaɓwatǝ pamǝpamǝ kǝ hyi sǝsǝˈwuri kau, a ɗari sǝ kurthlǝ ya? Aˈyi a kyau, abangǝ mai. ");
INSERT INTO mfm_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","Hyu nggani Hyal nǝ hyi Mambǝl nyi, ǝnga ju mǝl sǝ dǝdǝgurˈyar wu pama hyi ara hyu nu dlaɗǝ ya, ǝndǝga ara hyi hǝnggǝri ǝnga ndǝr Kǝrsiti kǝra hyi nggar ya? ");
INSERT INTO mfm_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","Tsamiya mǝ nggyar Ibrahimu ja. Nji tsǝfǝri abǝr, “Arya Ibrahimu mbǝrsa ǝnga Hyal, kǝ Hyal jigǝwa nyi ar viya ndǝ tsapǝu.” ");
INSERT INTO mfm_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","Hya sǝnbiya abǝr njira hǝnggǝri ǝnga Hyal, nanda ngǝ culi Ibrahimu. ");
INSERT INTO mfm_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","Lǝkakaɗǝ nǝ Hyal a nanari tsu kaɗǝu, abǝr, Hyal wu nda mǝliya njira aˈyi njir Yahudiya mai a uya nggya nǝ tsapǝkur lagur mbǝrsa. Arya tsu kaɗǝu, Hyal nar nyi anǝ Ibrahimu lagu ndǝshigu, abǝr, “Lagu ngau, ngǝ patǝr ˈyiˈyi wu nda uya barka.” ");
INSERT INTO mfm_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","Hyal fǝnggǝr nyi barka anǝ Ibrahimu arya mbǝrsa nyi, agabangǝ kalar ndǝra mbǝrsa ǝnga Hyal, ju nda fǝnggǝr nda barka daɓǝ ǝnga Ibrahimu. ");
INSERT INTO mfm_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","Kalar njira wu nggani abǝr nu dlaɗǝ nǝ Musa ngu mǝliya tsapǝu, a ɗar nda nji shishiˈwau. Ara ndǝr Hyal kǝra tsǝtsǝfǝ nana, abǝr, “Kalar ndǝra gǝra nubiya patǝr sǝra tsǝtsǝfau, wu Lǝkakaɗǝ nǝ dlaɗau, a ɗar ja ndǝ shishiˈwau.” ");
INSERT INTO mfm_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","Ar babal nga nyi, ndǝ aˈyi a sǝn uya nggya tsapǝ wu mwar Hyal lagur nu dlaɗǝ mai, arya tsǝtsǝfǝ nga nyi abǝr, “Ndǝ tsapǝu, wu uya mbǝɗau lagur mbǝrsa.” ");
INSERT INTO mfm_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","Sǝr daɓǝri nu dlaɗau ǝnga mbǝrsa aˈyi mai. Ənggǝr kǝra nji tsǝfǝri, “Kalar ndǝra nubiya patǝr sǝra nji nana wu dlaɗau, ju mbǝɗau laguwa nyi.” ");
INSERT INTO mfm_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","Kǝrsiti a bǝliya mǝn ri sara wu shiˈwu nǝ dlaɗau. Arya tsǝtsǝfǝ nga nyi abǝr, “Kalar ndǝra nji dlakǝya ar wu dladlakau, a ɗari ja shishiˈwau.” ");
INSERT INTO mfm_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","Kǝrsiti a bǝliyar nji aga njira aˈyi njir Yahudiya mai a uya barka nǝ Ibrahimu, aga mǝna uya Mambǝl kǝra Hyal mǝliya alkawal lagur mbǝrsa. ");
INSERT INTO mfm_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","Wazha ama, bǝgǝ ya nar hyi karapǝ ar kǝra sǝra hyi tsǝliya. Ma alkawal kǝra nji mbiya, nji fuwa tsi a gwa, ǝnga nji hǝnggǝri ni, ndǝr sǝn pǝlna ǝnga ja cakǝri aˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","Agabangau, alkawal ngǝ Hyal mǝliya ǝnga Ibrahimu ba culi nyi. Aˈyi nji tsǝfǝri abǝr, “Culi nyiˈyar mai,” kǝra wu cabiya abǝr nji gangǝ ngau. Awau, ama ji na “Culi ngau,” kǝra cabiya ndǝ zǝmǝ ngau, ca ngǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","Sǝra yu na ca ngǝ, dlaɗǝ kǝra shili ayukuɗa fa gharu foɗǝu ǝnga makǝr kumou nyi nǝ alkawal, a sǝn mǝliya alkawal kǝra Hyal mbiya wu pama ja ǝnga Ibrahimu ja ɗa sǝ kurthlǝ mai. ");
INSERT INTO mfm_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","Maja abǝr nju uya barka kau, lagur nu dlaɗau, naji ɓǝra ɗa lagur alkawal mai. Hyal nǝ nyi barka anǝ Ibrahimu lagur alkawal kau. ");
INSERT INTO mfm_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","Ma abangǝ ja, aga mi ngǝ Dlaɗǝ shila? Nji shili ǝnga Dlaɗǝ aga ja cabiya mǝn bikǝr mǝn ar babal, kǝl pǝcira alkawal kǝra wu shili lagu culi Ibrahimu kǝ nyabiya dzau. Dlaɗau, waladiˈyar ngǝ shili ni, lagur ndǝr taˈyau wu pama Hyal ǝnga nji. ");
INSERT INTO mfm_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","Ndǝr taˈyi wu pama nji ǝnga Hyal, a sǝn ɗa ja taˈyi ar kǝra ndǝ zǝmǝ mai, ama Hyal zǝmǝ nga ja. ");
INSERT INTO mfm_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","Ɗǝm ya, dlaɗǝ wu ɗa dawa ǝnga alkawal Hyal ya? Awau, alaga kushu! Arya maja abǝr dlaɗǝ wu sǝn shili ǝnga pi, tsapǝkur ma nju sǝn uya lagu dlaɗau. ");
INSERT INTO mfm_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","Ama tsǝtsǝfǝ nga nyi wu Ndǝr Hyal, abǝr, duniya patǝ mafa bikǝ nga nda. Sǝkǝ ɗa abangǝ aga sǝra nji hǝr alkawala nyi lagur mbǝrsa wu Yesu Kǝrsiti, nja lǝri anǝ njira hǝnggǝri. ");
INSERT INTO mfm_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","Divira mbǝrsa shili, dlaɗau, a mbiya mǝn ri wu fursǝna, lagur biya aˈyi mai, kǝl lagur mbǝrsa ǝnga Yesu cabiya dzau. ");
INSERT INTO mfm_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","Nji fuwa mǝn wu tsa dlaɗau aga ja hǝr mǝna ndǝgya Kǝrsiti. Lagu kau, nga mǝn wu uya nggya tsapǝu, wu mwar Hyal lagur mbǝrsa. ");
INSERT INTO mfm_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","Kabangǝkǝ tsu, pǝcir mbǝrsa a shilǝri, tsu mǝn aˈyi ǝgyakiɗa dlaɗǝ mai. ");
INSERT INTO mfm_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","Lagur mbǝrsa wu Kǝrsiti Yesu ngǝ patǝkura hyi nggya wazha Hyal. ");
INSERT INTO mfm_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","Abangǝ tsu nahyi njira nji mǝliya hyi baɓǝtizǝma, a ɗar hyi nǝ Kǝrsiti, sǝr mǝla hyi ja ɗa sǝr mǝla Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","Agabangau, pampamǝkur aˈyi mai wu pama njira njir Yahudiya ǝnga njira aˈyi njir Yahudiya mai. Ətsu njira mafa ǝnga kambǝr nji mai, ǝnga mala ǝnga sal. Patǝkura hyi nji zǝmǝ nga hyu Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","Ma tsu nǝ Kǝrsiti nga hyi, a ɗar hyi culi nǝ Ibrahimu, ǝtsu hyu nda dlǝwuri sǝr faˈa ki kǝra Hyal mǝliya alkawala nyi. ");
INSERT INTO mfm_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","Sǝra yu na ca ngǝ, ar pǝcira ndǝr faˈa ki ar viya zǝr ngau, aˈyi ja pamǝ a mwa ara mafa mai, alaga kǝ naja ngǝ ǝnga ki kǝ papatǝu. ");
INSERT INTO mfm_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","Əgya kiɗa njira hǝ nyi ǝnga njira dǝnyi fuwa kar nyi wu tsa nda baˈanǝ shili ar pǝcira dǝnyi fiya. ");
INSERT INTO mfm_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","Abangǝ nga nyi tsu anǝ mǝn, ar pǝci kǝra mǝn tsu wazha divira Kǝrsiti cabiya dzau, namǝn ǝnggǝr mafa anǝ sǝra a vǝr sǝm tǝlkur ar kǝra duniya. ");
INSERT INTO mfm_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","Ama wu pǝci kǝra Hyal pabǝri nyabiya dzau, kǝ Hyal sǝwa Zǝr nyi. Ji shili lagu mala. Nji ya nyi ǝgyakiɗa dǝnama nǝ dlaɗau, ");
INSERT INTO mfm_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","aga ja bǝliya njira ǝgyakiɗa dlaɗau, ǝnga ja shabiya mǝn ar viya wazha Hyal. ");
INSERT INTO mfm_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","Arya namǝn wazha Hyal, ca ngǝ Hyal sǝwa Mambǝl Zǝr nyi wu ɗǝfuwa mǝn, aga ja nǝ mǝn dǝnama nǝ ngga Hyal, “Abba, Tada!” ");
INSERT INTO mfm_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","Kabangǝkau, tsu nahyi aˈyi mafa mai, ama wazha nga hyi. Ta ɗari wazha nga hyi, Hyal wu nda mǝliya hya ɗa ndǝr faˈa ki. ");
INSERT INTO mfm_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","Ɗǝɗǝmǝu, ar pǝcira hyi gǝra sǝn Hyal, hyu sǝm mafakur anǝ katǝˈyar, kǝra gǝra ar viya sau. ");
INSERT INTO mfm_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","Ama kabangǝkǝ kǝra hyu sǝn Hyal, ǝndǝga Hyal ngu sǝn hyi. Mi ngǝ ɗa hyu ɓǝra sha a ndǝgya kiɗa tǝlkur kǝra gǝra ǝnga dǝnama? Sǝ gǝra kǝr nga nda, mi ngǝ ɗa hyu yiwu hya ɓǝra sha aga mafar nda? ");
INSERT INTO mfm_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","Kǝja hyu lǝr kǝrhyi aga ɓǝla alenyi pidaˈyar ǝnga hyaˈyar, ǝnga pǝci pamǝpamǝ ba faˈyar. ");
INSERT INTO mfm_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","Sǝra hyu mǝl kau a nǝ ɗari ɗǝnga sau, ara a ɗari ǝnggǝr patǝr ɓwaɓwatǝ kǝra yi sa ar kǝra hyi kau sǝ kurthlǝu ngau! ");
INSERT INTO mfm_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","Yu kǝdi hyi wazha ama, hya nggya ǝnggǝr nayau. Arya nayi ǝnga kǝrɗa ǝnggǝr nahyi nga yau. Sǝ aˈyi hyi ndzana ɗa mai. ");
INSERT INTO mfm_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","A sǝn hyi shilǝgǝ kǝra uya ɗa, naja ngǝ mǝliya lagu kǝra yi hǝri hyi ndǝshigu nǝ tanggǝrma. ");
INSERT INTO mfm_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","Alaga kǝ shilǝgǝ kau ɗa sǝr ɓwakǝr dǝdǝgalǝu anǝ hyi, alaga abangau nahyi diɗana ɗa mai, ǝnga hyi nggǝl ara dlǝwu ɗa mai. Hyi dlǝwuri ɗa ǝnggǝr waladi sara ara Hyal, ǝnggǝr Kǝrsiti Yesu ǝnga kǝrnyi. ");
INSERT INTO mfm_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","Hyi ɗa ǝnga caguli gagaɗau ar pǝci ta! Kabangǝkǝ ya, ǝmani ngǝ cagulir hyi ta? Pakatǝ ar pǝci ta, wu sǝn yau, abǝr hyu sǝn tǝkuɗǝbiya liya hyi, ba hya nǝ ɗa! ");
INSERT INTO mfm_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","Ya, hyi shabiya ɗa dawar hyi arya yi nar hyi jiri ya? ");
INSERT INTO mfm_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","Njiˈyar kau, ndu yiwu nda kaghibiya hyi, ama aˈyi wu mǝnahǝkur mai. Ndu yiwu nda tǝkǝbiya hyi ǝnga yau, aga patǝr ɗǝngar hyi nda sha a ndǝgya nda. ");
INSERT INTO mfm_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","Ma ɗǝngar nji mǝnahǝ nga nyi, a ɗar mǝnahǝ cimu nda cabiya yiwu wu gau, aˈyi kǝl pǝcira yi ǝnga hyi waci mai. ");
INSERT INTO mfm_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","Nahyi wazha ɗa, kǝra yi ɓǝra dar tsǝkar ya nda, kǝl Kǝrsiti ciya dzau wu ɗǝfuwa hyi. ");
INSERT INTO mfm_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","Cim ɗa ya nggya ǝnga hyi baˈanǝ kabangǝkau, ba ya bǝlana ɗaha yau, arya aˈyi yi ǝnga ɗǝnga sǝ gagaɗau ar kǝra hyi! ");
INSERT INTO mfm_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","Nahyi, hya nar ɗa, nahyi njir yiwu nu dlaɗau, a sǝnbiyar hyi sǝra dlaɗau wu na ya? ");
INSERT INTO mfm_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","Tsǝtsǝfǝ nga nyi abǝr Ibrahimu aˈyi ja ǝnga wazha shili mǝthlǝu, pathlǝu, zǝr kǝra nji ya lagu mala mafa, ǝnga vanyi tsu lagu kambǝr mala. ");
INSERT INTO mfm_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","Zǝr kǝra ji yabiya ǝnga mala mafa kau, nji yabiya nyi lagura nji tsǝliya. Ama zǝr kambǝr mala kau, nji yabiya nyi lagur alkawal kǝra Hyal mbiya. ");
INSERT INTO mfm_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","Najakau, karapǝ ngau, mathlǝkǝˈyi kǝ mǝthlǝu kǝ cabiya alkawal mbamba mǝthlǝu. Hajaratu ngǝ cabiya ndǝr ya mafa, naja ngǝ alkawal mbamba nǝ Mǝ Sǝnayu. ");
INSERT INTO mfm_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","Kabangǝkau, Hajaratu a nggyari ar viya Mǝ Sǝnayu kǝra wu ˈyiˈyir Arabiya. Naja ngǝ ar viya mǝlmǝ nǝ Urshalima kabangǝkau, arya naja ǝnga wazha nyi patǝ mafa nga nda. ");
INSERT INTO mfm_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","Ama Urshalima kǝra a dǝmǝlmau, kambǝr ndǝ ngau, ǝtsu naja ngǝ mǝr mǝn. ");
INSERT INTO mfm_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","Tsǝtsǝfǝ nga nyi abǝr, “Ga ɗa ǝnga huɗǝ pǝrtǝu, nagǝ mala kǝra gǝra ya. Ga wau nǝ caguli, nagǝ ndǝra gǝra nggari kwakwaɗǝ nǝ ya. Arya wazha mala hya a ɗari nda gangǝu. A ndiyar nda mala mayiwa.” ");
INSERT INTO mfm_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","Kabangǝkau, wazha ama, Hyal a mǝliya mǝn ri ǝnggǝr Ishaku, wazha nǝ alkawal. ");
INSERT INTO mfm_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","Ar pǝci ta tsu zǝr kǝra nji ya wu lagur kǝra nji tsǝliya, ji nǝ nyi ɓwaɓwatǝ anǝ zǝr kǝra nji ya ǝnga dǝnama nǝ Mambǝl Hyal. Abangǝ nga nyi baˈanǝ kabangǝkau. ");
INSERT INTO mfm_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","Ama tsǝtsǝfǝ nga nyi wu Lǝkakaɗǝ nǝ Hyal abǝr, “Ga kǝdlǝna mafa kau ǝnga zǝr nyi, ara zǝr mafa kau aˈyi wu tǝkǝ sǝr faˈa ki ǝnga nǝ zǝr kambǝr mala mai.” ");
INSERT INTO mfm_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","Agabangau, wazha ama, aˈyi mǝn wazha mala mafa mai, ama namǝn wazha kambǝr mala ngau. ");
INSERT INTO mfm_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","Aga nggya kambǝkur ngǝ sǝra ɗa Kǝrsiti pǝliya mǝn, arya kau kǝl hyi taˈyi ǝnga dǝnama, a sara hya ɓǝra shabiya kǝrhyi anǝ ɓwaɓwatǝ nǝ mafakur dlaɗǝ mai. ");
INSERT INTO mfm_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","Hya nggar ɗa. Nayi Bulusu yu na anǝ hyi, ma hyi hǝnggǝri nja thlana hyi pǝlzha, najakǝ wu ca abǝr Kǝrsiti aˈyi ǝnga akkǝri anǝ hyi mai. ");
INSERT INTO mfm_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","Yu ɓǝra ɗǝngari hyi abǝr kalar ndǝra hǝnggǝri ja nu dlaɗǝ nǝ thla pǝlzha, yau, a ɗari anǝ nyi tsaˈa ja nu patǝr sǝra dlaɗǝ nana. ");
INSERT INTO mfm_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","Nahyi kǝra wu nǝrdzau hya uya tsapǝkur wu mwar Hyal lagu nu dlaɗau, a ɗari, a thlǝnar hyi kǝrhyi sara wu nu Kǝrsiti ja. A sanar hyi dzau ara mayiwakur Hyal. ");
INSERT INTO mfm_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","Ama lagur Mambǝl ǝnga mbǝrsa nga mǝn wu sǝkǝ daɓǝ ǝnga fǝr kǝr aga Kǝrsiti a nǝ mǝn tsapǝkur nyi. ");
INSERT INTO mfm_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","Arya ma mǝn wu Kǝrsiti Yesu, alaga pǝlzha, alaga gǝra pǝlzha, aˈyi vanyi sǝ mai. Ama sǝra mǝna tsamǝ, ca ngǝ mbǝrsa mǝn kǝra wu cabiya dzǝ lagur yiwudzau. ");
INSERT INTO mfm_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","Tanggǝrma hya vǝr dumwa gagaɗau. Wa ngǝ kar hyi ara nu nǝ jijira? ");
INSERT INTO mfm_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","Kadzangǝ ngguta vi kǝra shili anǝ hyi, aˈyi sara ara Hyal kǝra ngga hyi kǝ ngǝ mai. ");
INSERT INTO mfm_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","Ənggǝr kǝra nju sǝn na, “Thlǝlamǝ kǝra kushu a sǝn mǝliya macikǝl ja thlǝthlau.” ");
INSERT INTO mfm_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","Papalkur kǝrɗa wu thlǝr Thlagǝu, a hǝnggǝr yi abǝr nahyi ɓǝra nu vanyi ɗahǝ pamǝ a ndiya nǝɗa mai. Ətsu kalar ndǝra wu hyaˈa hangǝkala hyi, ju nda sa ɓwaɓwatǝu, alaga wa nga ja. ");
INSERT INTO mfm_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","Wazha ama, ma baˈanǝ kabangǝkau, yu tǝtǝlna ndǝr Hyal abǝr aga nja thla pǝlzha, ya, mi ngǝ ɗa baˈanǝ kabangǝkǝ tsu nju lǝ ɓwaɓwatǝ anǝ ɗa? Ma yu dlǝwa nji abǝr a ɗari tsaˈa nja thla pǝlzha, ndǝr ɗa ar kǝra tǝr Kǝrsiti ar wu dladlakǝ aˈyi a ɓǝra sǝn ɗa sǝr thlǝ hi anǝ kalar ndǝ mai. ");
INSERT INTO mfm_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","Ar kǝra njira wu hya hangǝkala hyi abǝr kǝl nji thlana hyi pǝlzha, kuji anǝ nda nyi nja thlabiya nyi aga mǝciˈu sal! ");
INSERT INTO mfm_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","Nahyi, wazha ama, a ngga hyir nji aga kambǝkur ar kǝra dlaɗau. Hya hangǝkal a sara ɗa kambǝkur hyi kau, ja ɗa nǝ sǝr cim nǝ kumǝr dzau. Ar viya kau, bǝgǝ kambǝkur hyi, ja ɗa kǝra wu hǝri hyi a ndu yiwu mǝl thlǝr nǝ yiwudzau. ");
INSERT INTO mfm_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","Arya patǝkura dlaɗau, a daɓǝr nju ɗahǝ zǝmǝu, ca ngǝ, “Ga yiwu tǝwul ngau ǝnggǝr kǝrngau.” ");
INSERT INTO mfm_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","Ama ma hyu par kǝrhyi ǝnga hyu nggal kǝrhyi ǝnggǝr maˈwi tagǝu, hya nggya ǝnga hangǝkal ja, ma aˈyi mai patǝkura hyi, hyu sanakǝr! ");
INSERT INTO mfm_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","Sǝra yu yiwu ya na kau, ca ngǝ hya nǝ nyi lagu anǝ Mambǝl Hyal ja lǝ hyi. Ma hyi mǝl abangau nahyi wu nda nggya wu ndǝndǝkur mai. ");
INSERT INTO mfm_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","Arya nggya nǝ ndǝndǝkur dawa nga ja anǝ Mambǝl, Mambǝl tsu, dawa nga ja anǝ nggya nǝ ndǝndǝkur. Culi najaka nggya tsu dawa nga nda ǝnga kǝrnda. Ca ngǝ ɗa nahyi wu sǝn mǝliya sǝra hyu yiwu hya mǝl mai. ");
INSERT INTO mfm_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","Ma Mambǝl Hyal ngu lǝ hyi, nahyi aˈyi hyi ǝgya dlaɗǝ mai. ");
INSERT INTO mfm_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","Sǝr mǝla ndǝr bikau, ar babal nga nda. Nanda ngǝ sǝsukur, ǝnga mǝl sǝ gǝra kyau, ");
INSERT INTO mfm_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","ǝnga mǝl thlǝr katǝu, ǝnga dǝshakur, ǝnga piyari shishir dza kuvwar nda, ǝnga pa wu pamǝ ǝnga ɗa shishi ǝnga tsu ɗǝfu, ǝnga yiwukǝr ba tǝkǝbiya dzau, ǝnga hya hangǝkala nji, ");
INSERT INTO mfm_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","ǝnga shishikur, ba ǝnga sa sǝ sasa, ǝnga alenyi sǝ kǝra papa ˈyar kǝ tsu. Yu kughi anǝ hyi, ǝnggǝr kǝra yi nar hyi tsu kaɗǝu, abǝr njir mǝl najaka sau, nandǝ wu gwu tǝlkur Hyal mai. ");
INSERT INTO mfm_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","Ama wazha kǝra Mambǝl wu ya, nanda ngǝ yiwudzau, ǝnga caguli, ǝnga huɗǝ pǝrtǝu, ba sǝsǝˈwu sau, ǝnga hangǝkalkur, ba mǝnahǝkur, ǝnga tsaˈa miya ɗǝfukur, ");
INSERT INTO mfm_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","ba ɓatsǝkur kǝr, ba tsu sha yi anǝ sǝra kumǝr dzǝ wu yiwu. Sǝˈyar kau, aˈyi dawa anǝ dlaɗǝ mai. ");
INSERT INTO mfm_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","Patǝkura njira nǝ Kǝrsiti Yesu ngau, a tsǝyar nda nggyabiya nǝ ndǝndǝkur ǝnga sǝ ɗǝmwaˈyiˈyar pamǝpamǝ kǝra dza ndu yiwu. ");
INSERT INTO mfm_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","Ta ɗa Mambǝl ngǝ nǝ mǝn pi, bǝgǝ Mambǝl tsu ja lǝbiya mǝn wu kalar nggyar mǝn. ");
INSERT INTO mfm_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","A sara mǝna ɗa njir hakǝr mai, alaga njir tsǝtsǝbwar kǝrnda, ǝndǝga njir ɗa shishi kǝrnda. ");
INSERT INTO mfm_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","Wazha ama, ma nji lar vanyi ndǝ a vǝr mǝl bikau, nahyi kǝra nyinyau ǝnga Mambǝl Cicau wu pama nda, bǝgǝ hya shabiya nda a shili ǝnga hangǝkal. Ama hya mǝl abangau ǝnga hangǝkal tsu, ara a vǝr sha zamǝr hyi a shili wu lagu, ba hya tǝɗau a gwu dzau. ");
INSERT INTO mfm_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","Hya dlǝwar kuvwar hyi lagur hǝ ɓwaɓwatǝr nda. Lagu kǝ nga hyu nyabiya dlaɗǝ nǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","Ma vanyi ndu nggani abǝr vanyi sǝ nga ja, ama aˈyi ja vanyi sǝ mai, ngguta kǝrnyi nga ju mǝl. ");
INSERT INTO mfm_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","Bǝgǝ kalar ndǝ ja dzǝgabiya sǝr mǝla ja. Ma ɗa mǝnahǝu, ǝnggau ja sǝn ɓwasau ǝnga sǝra ji mǝliya ǝnga kǝrnyi, ama aˈyi ja gǝla kǝrnyi ǝnga vanyi ndǝ mai. ");
INSERT INTO mfm_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","Arya tsaˈa nga nyi anǝ kalar ndǝ ja hanggǝr thlǝr nyi. ");
INSERT INTO mfm_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","Kalar ndǝra nji highiɓǝr nyi ndǝr Hyal, kǝl ja tǝkǝya sǝ mǝnahǝ kǝra ara ja ǝnga ndǝra highiɓǝ anǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","A sara hya ngguta kǝrhyi mai, ndǝr sǝn canǝ nyi dabar anǝ Hyal aˈyi mai. Kalar sǝra ndǝ thlǝkana, ca nga ju gǝm. ");
INSERT INTO mfm_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","Ma ndǝ thlǝkana wu sǝ suna nǝ kumǝr dzau, sǝra ju nda gǝm ca ngǝ tau. Ma ndǝ thlǝkana wu sǝra Mambǝl wu yiwu, sǝra ju nda gǝm ca ngǝ pi kǝra gǝra kuɗau. ");
INSERT INTO mfm_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","Agabangǝ a sara mǝna hǝɗa ǝnga mǝl mǝnahǝkur mai, arya ar pǝci kakalǝ mǝnu nda faˈa sǝ nǝ barka ma mǝn gǝra taˈyi ar lagu. ");
INSERT INTO mfm_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","Arya kau, kalar pǝci kǝra mǝn ǝnga lagu, taˈyi mǝna mǝl mǝnahǝkur anǝ nji patǝu, ja ɗa ma anǝ wazha ama kǝra wu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","Kabangǝkau, hya tsamiya culi tsǝfǝ dǝdǝgal kǝra yi mǝl anǝ hyi ǝnga pǝla yau! ");
INSERT INTO mfm_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","Nji kǝ wu yiwu kǝl nja thlana hyi pǝlzha kau, ndu yiwu nja lar nda ar viya vanyi sau. Ndu mǝl anǝ hyi abangau, arya ndu hivǝr sa ɓwaɓwatǝ kǝra ndu sa lari arya highiɓǝ ar kǝra wu dladlakǝ nǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","Alaga njira nji thlana nda pǝlzha ma, nandǝ wu ɓǝlari dlaɗǝ mai. Nanda ndu yiwu nda thlana hyi pǝlzha aga nda hya kǝr abǝr nanda ngǝ sǝwa nji thlana hyi pǝlzha. ");
INSERT INTO mfm_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","Ama alaga kushu nayi wu hyaˈa kǝr mai, kǝl ǝnga wu dladlakǝ nǝ Thlagǝr mǝn Yesu Kǝrsiti. Arya lagur tǝ nyi ar wu dladlakau ngǝ sǝr duniya tǝnakǝr wu yau, nayi tsu a tǝnar yi kǝr ǝnga sǝr duniya. ");
INSERT INTO mfm_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","Pǝlzha, gǝra pǝlzha aˈyi nda sǝ mai, sǝ dǝgal ca ngǝ nda ɗa ndǝ mafǝliyangǝ. ");
INSERT INTO mfm_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","Jamǝkur ǝnga tǝhuɗǝkur nda nggya ǝnga patǝr njira wu nu sǝr ɓǝla kau, nanda ngǝ njir Izirayila nǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","Ayukuɗa nyi wazha ama, a sara vanyi nda ɓǝra fuwa ɗa wu ɗǝnga vanyi sǝ mai, arya mǝcaviɗi kǝra ar dza yi kau, a cabiyari, abǝr nayi nǝ Yesu ngau. ");
INSERT INTO mfm_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","Wazha ama, bǝgǝ mayiwakur nǝ Thlagǝr mǝn Yesu Kǝrsiti a nggya ǝnga mambǝlǝr hyi. Amina.");
INSERT INTO mfm_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","Cama tsǝtsǝfǝ kǝ sara ara Bulusu, cama sǝsǝ nǝ Kǝrsiti Yesu lagur yiwu huɗǝ nǝ Hyal, anǝ nji cici gǝ Hyal kǝra wu Afisa, njir mǝl thlǝr tsaˈa miya ɗǝfu wu Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","Bǝgǝ mayiwakur ǝnga huɗǝ pǝrtǝu sara ara Hyal Dǝrmǝn ǝnga Thlagǝ Yesu Kǝrsiti nda nggya ǝnga hyi. ");
INSERT INTO mfm_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","Barka a nggyari anǝ Hyal, dǝya Thlagǝr mǝn Yesu Kǝrsiti, ndǝra fǝnggǝr mǝn barka sara dǝmǝlmau. Naja ndǝra fǝnggǝr mǝn barka ǝnga kalar culi barka mamambǝl wu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","Ara Hyal caɗǝbiya mǝn arya Kǝrsiti, kadivira ji dzǝguya duniya. Ji caɗǝbiya mǝn aga mǝna ɗa cicau ǝnga gǝra vazau wu mwa nyi. Arya yiwukur nyi, ");
INSERT INTO mfm_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","ji mbiya tsu kaɗǝu aga mǝna ɗa ar viya wazha nyi lagu Yesu Kǝrsiti, ǝnggǝra ju pina huɗa ja ǝnga yiwu huɗa ja. ");
INSERT INTO mfm_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","Ji mǝl abangau aga mǝna sǝn fal Hyal ara kadakadarkur mayiwakur nyi. Mayiwakur kau, ji nǝ mǝn kurthlǝu lagu zǝr nyi, ju yiwu nyi. ");
INSERT INTO mfm_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","Lagur pǝ mashi Kǝrsiti nga mǝn uya bǝlbiya dzau sara wu mafakur, ca ngǝ tǝfǝbiya dzǝ sara wu bikau. Ji mǝl abangǝ tsaˈa aga gangǝkur mayiwakur nǝ Hyal, ");
INSERT INTO mfm_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","kǝra ji pǝnggǝr mǝn gagaɗau ǝnga patǝr hahangǝkur ba sǝnbiya sau. ");
INSERT INTO mfm_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","Wu mǝliya huɗa Hyal pipida, ca nga ji mǝliya mǝn aga mǝna sǝnbiya yiwu huɗa ja kǝra ɗǝɗǝwa, kǝra ji nyabiya wu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","Naja kǝ ngǝ yiwu huɗa Hyal kǝra ju nda nyabiya ma pǝca nyi ɗa. Ju nda tsǝmiya kalar sǝ kǝra a dǝmǝlmau ǝnga wu duniya ǝgyakiɗa dǝnamar Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","Wu Kǝrsiti tsu nga ˈyi ɗa sǝr faˈa ki nǝ Hyal. Ji mbabiya ˈya abangau tsu kaɗǝu, ǝnggǝr kǝra ji pǝdlǝya wu ɗǝfwa ja. Naja Hyal ndǝra vǝr mǝl kalar sǝ kakal aga yiwur huɗa ja. ");
INSERT INTO mfm_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","Ji mǝliya abangǝ aga naˈya njira fǝr kǝr ǝnga Kǝrsiti tanggǝrma, ˈya fal kadakadarkur nyi. ");
INSERT INTO mfm_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","Ənga nahyi tsu, lagu Kǝrsiti nga hyi nggari ndǝr jiri, ndǝshigu kǝra mbǝɗana hyi. Ma ga hǝnggǝri ba Hyal a sa nǝ hyi Mambǝl Cici kǝra ji hǝr alkawala nyi abǝr ju nǝ hyi. Mambǝl Cici kǝ wu nggya mǝtsam nyi ar hyi. ");
INSERT INTO mfm_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","Mambǝl Cici ngǝ sǝr zhu kǝra cabiya abǝr Hyal wu nda nǝ mǝn sǝr faˈa ki, kǝl pǝcira Hyal wu nda bǝliya nji nyi. Sǝˈyar kǝ ɗa patǝu aga shili ǝnga fal nǝ kadakadarkur nyi. ");
INSERT INTO mfm_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","Arya kau, ǝnggǝra yi nggari ar kǝra mbǝrsar hyi wu Thlagǝ Yesu ǝnga yiwudzǝ kǝra ara hyi anǝ patǝr nji cici gǝ Hyal, ");
INSERT INTO mfm_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","nayi piyari lǝ usaku anǝ Hyal arya hyi mai, ar kalar pǝci kǝra yu kǝdi Hyal. ");
INSERT INTO mfm_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","Kǝdi Hyal ɗa anǝ hyi ca ngǝ Hyal nǝ Thlagǝr mǝn Yesu Kǝrsiti, Tada kǝra ǝnga kadakadarkur, ja nǝ hyi mambǝl nǝ hahangǝkur ǝnga ja cabiya hyi Hyal aga hya cakǝri sǝni nyi. ");
INSERT INTO mfm_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","Kǝdi Hyal ɗa tsu ca ngǝ tsu aga ja nyabiya ɗǝfuwa hyi ǝnga mbǝmbǝl aga hya nggabiya sǝ ar kǝra fǝr kǝr kǝra nji ngga hyi a shili a gwa, aga hya sǝnbiya gangǝkura kadakadarkur nǝ sǝr faˈa ki kǝra nji fiya anǝ nji cici gǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","Ənga tsu ya vǝr kǝdi Hyal anǝ hyi, aga hya nggabiya madiya dǝgalkura dǝnamar Hyal kǝra ara mǝn, namǝn njira hǝnggǝri ǝnga ja. Dǝnama kau, sǝ zǝmǝ nga ja ǝnga madiya dǝnama, ");
INSERT INTO mfm_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","kǝra Hyal hyaˈana Kǝrsiti sara vir tǝ ǝni. Dǝnamar Hyal kǝ ngǝ nǝ nyi vir nggya mǝnahǝu ar tsi mazǝma Hyal a dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","A dǝna ngǝ Kǝrsiti a vǝr sǝm tǝlkur ar kǝra tǝltǝlˈyar, ǝnga mambǝl tǝɗǝmwa, ǝnga mambǝl dǝnama tǝlkur, ǝnga mambǝl dǝnama, ba ǝnga ar kǝra kalar thlǝm kǝra nji lǝri wu zaman ǝshina kau ǝnga zaman kǝra a vǝr shili. ");
INSERT INTO mfm_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","Hyal a fiyari kalar sǝ ǝgyakiɗa tǝlkur nǝ Kǝrsiti, ǝnga ji mǝliya nyi ji ɗa kǝr a dar kǝra kalar sau, aga ja ɗa sǝr akkǝri anǝ daɓǝ dzǝ njir nu. ");
INSERT INTO mfm_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","Daɓǝ dzǝ njir nu kau, ca ngǝ dza Kǝrsiti nga nyi. Wu daɓǝ dzǝ njir nu kau, Kǝrsiti a nyabiyar dzau, ǝnggǝr kǝra naja ǝnga kǝrnyi a nyabiyari kalar sau. ");
INSERT INTO mfm_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","Ɗǝɗǝm nji tǝtǝ nga hyi ara sǝr mǝla hyi kǝra ɗǝmwaˈyu ǝnga bikǝr hyi ˈyar. ");
INSERT INTO mfm_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","Nahyi, hyi nggya wu bikǝ ɗǝɗǝmǝu, ar pǝcira hyu nu lagu nǝ njir duniya kau, ǝnga hya vǝr nu shatan, tǝl mambǝl ɗǝmwaˈyu. Naja ngǝ mambǝl kǝra a vǝr mǝl thlǝr wu ɗǝfuwa njira nggǝl ara ɓǝlar sǝra Hyal wu na. ");
INSERT INTO mfm_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","Abangǝ nga mǝn patǝ ɗǝɗǝmǝu, mǝna vǝr nu sǝra dza mǝn wu yiwu nǝ bikǝ bikau, ca ngǝ cimǝr mǝn ǝnga ɗǝngar mǝn. Arya kǝ nga mǝn ɗa njir hǝ huɗǝ ndzǝndzǝ nǝ Hyal ǝnggǝr kalar ndau. ");
INSERT INTO mfm_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","Ama ara gangǝkura tǝhuɗǝ nyi ǝnga yiwudzǝ nyi anǝ mǝn, ");
INSERT INTO mfm_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","alaga ta, a ɗar mǝn nji tǝtau wu bikǝ ta, ba ji mǝliya mǝn, mǝn ɗa ǝnga pi ǝnga Kǝrsiti. Lagu mayiwakur nǝ Hyal nga hyi uya mbǝɗau. ");
INSERT INTO mfm_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","Ənga ji hyaˈana mǝn sara vir tau ǝnga Kǝrsiti ba ǝnga ji nǝr mǝn vir nggya ǝnga Kǝrsiti a dǝmǝlmau arya Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","Hyal mǝl abangau, aga ar pǝci kǝ zǝgǝu, ju cabiya nyi anǝ nji dǝgalkura madiya mayiwakur nǝ nyi kǝra cabiya dzau anǝ mǝn ar babal wu yiwukur nyi lagur Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","Ara lagur mayiwakur Hyal nga hyi uya mbǝɗau, lagur mbǝrsar hyi. Nahyi aˈyi asǝn hǝr dlǝva nyi mai, ama lǝ sǝ kurthlǝ ngau, sara ara Hyal. ");
INSERT INTO mfm_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","Mbǝɗau aˈyi sǝra nju uya lagur mǝl sǝ mǝnahǝ ngǝ mai, agabangau, ndǝr sǝn hwavi ar kǝri aˈyi tsu mai. ");
INSERT INTO mfm_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","Arya namǝn sǝra Hyal hǝriya ngau. Ji mǝliya mǝn mafǝliyangǝ wu Kǝrsiti Yesu, aga mǝna dumwa ǝnga mǝl sǝ mǝnahǝ kǝra ji fuwa wu lagu tsu kaɗǝu aga mǝna mǝl. ");
INSERT INTO mfm_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","Agabangau, ɗǝngara mau ǝnggǝra hyu nggya ɗǝɗǝmǝu. Nahyi aˈyi njir Yahudiya lagur ya mai. Njir Yahudiya kǝra wu ngga kǝrnda, “njira nji thlana nda pǝlzha”, nanda ngǝ njira vǝr ngga hyi, “njira gǝra thla pǝlzha.” Ama pǝlzhar nda kǝra nju mǝl ǝnga tsi ngau, aˈyi wu tsǝkwar ɗǝfuwa nda mai ama a biyar kumǝr dzau. ");
INSERT INTO mfm_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","Ɗǝngara mau abǝr ɗǝɗǝm tǝtǝkǝ nga hyi ǝnga Kǝrsiti, nahyi njira aˈyi njir Izirayila mai, ǝnga mǝthlǝpi nga hyi anǝ alkawal mbamba nǝ Hyal. Wu duniya kau, aˈyi hyi ǝnga fǝr kǝr mai, ba aˈyi hyi ǝnga Hyal tsu mai. ");
INSERT INTO mfm_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","Ama kabangǝkau, wu Kǝrsiti Yesu, nahyi njira ɗǝɗǝm naɗǝu, a hǝr hyir nji lǝhǝu a shili, lagur mashi Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","Ara Kǝrsiti ngǝ nggya jamǝkurǝr mǝn, naja ndǝra daɓǝya njir Yahudiya ǝnga njira aˈyi njir Yahudiya mai ndǝ ɗa culi nji zǝmǝu. Naja ngǝ dlana dawakur kǝra tǝkǝbiya nda. ");
INSERT INTO mfm_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","Ji lǝr dza ja aga ja dazhina dlaɗǝ nǝ highiɓǝ Musa kǝra nyinyau ǝnga sǝr ɓǝla. Ji mǝl abangau, aga ja daɓaga mǝliya culi nji mafǝliyangǝ zǝmǝu wu kǝrnyi sara wu culi nji pampam mǝthlǝu. Lagu kau, nga ji shili ǝnga nggya jamǝ wu pama nda. ");
INSERT INTO mfm_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","Ji mǝl abangǝ tsu wu dzǝ zǝmǝ kau, aga ja ɓasǝwa nda gyapǝu anǝ Hyal, lagur tǝ nyi a dar wu dladlakau. Lagu kǝ nga ji hǝna dawa kǝra aˈyi wu pama nda ɗǝɗǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","Ji shili aga ja sa tǝtǝlna ndǝshigu nǝ nggya jamǝkur anǝ hyi, nahyi njira aˈyi njir Yahudiya mai, njira naɗǝ ara Hyal. Abangǝ tsu a tǝtǝlnar ja ndǝshigu nǝ nggya jamǝkur anǝ njir Yahudiya, nanda njira lǝhǝu. ");
INSERT INTO mfm_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","Ara lagu nyi nga mǝn gyapǝu, nga mǝn uya shili ara Tada lagu Mambǝl Hyal zǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","Agabangau, nahyi njira aˈyi njir Yahudiya mai, aˈyi hyi ɓǝra ɗa nji shishili mai ǝnga tsu aˈyi hyi ɓǝra ɗa mǝthlǝpi mai. Ama a ɗar hyi nji zǝmǝ ǝkkǝˈyi nji cici nǝ Hyal, ǝnga a ɗar hyi njir ki nyi. ");
INSERT INTO mfm_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","Ki nyi kau, nji hǝriya ar vi fǝ hi hǝr nǝ cama sǝsǝˈyar ǝnga nabiˈyar. Tsǝka hada nǝ hǝr kau, Kǝrsiti Yesu ǝnga kǝrnyi ngau. ");
INSERT INTO mfm_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","Naja ngǝ ndǝra sǝɓiya hǝr kau ar vi zǝmǝu, ǝnga naja ngu nda mǝliya hǝr kau ja hau, aga ja ɗa vi cici nǝ Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","Ənga wu ja tsu nga nji hǝriya hyi daɓǝ ǝkkǝˈyi njir Yahudiya, aga hya ɗa ki kǝra Hyal wu nggya a gwa lagu Mambǝl nyi. ");
INSERT INTO mfm_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","Agabangau, nayi Bulusu, nayi ndǝra nji fuwa wu fursǝna ara nu Kǝrsiti Yesu arya hyi, nahyi njira aˈyi njir Yahudiya mai. ");
INSERT INTO mfm_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","A hǝnggǝr yau, abǝr a nggar hyi ǝnggǝra Hyal wu lagu mayiwakur nyi nǝ ɗa thlǝr kau nǝ dlǝwar hyi. ");
INSERT INTO mfm_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","Najakǝ ngǝ sǝ ɗǝɗǝwa kǝra canǝ ɗa kǝr lagur mǝtakǝr, ǝnggǝr kǝra yi tsǝfǝri anǝ hyi ndǝr yiɗawu. ");
INSERT INTO mfm_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","Ma ga jiganari, gu nggabiya sǝra yi sǝni, sǝra aˈyi ɗǝɗǝwa ar kǝra Kǝrsiti, ");
INSERT INTO mfm_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","kǝra aˈyi canǝ nyi kǝr anǝ njir zaman zaman kǝra tǝrabiya kǝ mai, ǝnggǝr kǝra ji canǝ nyi kǝr lagu Mambǝl Hyal anǝ cama sǝsǝ nyiˈyar ǝnga nabi nyiˈyar kǝra cicau. ");
INSERT INTO mfm_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","Najaka sǝ ɗǝɗǝwa ca ngǝ, abǝr, lagur ndǝshigu kǝ ngǝ njira aˈyi njir Yahudiya mai wu uya sǝr faˈa ki ǝnga njir Yahudiya, ǝnga a ɗar nda nji zǝmǝ wu daɓǝ dzau, ba ǝnga ndu sa sǝm alkawal dadaɓǝ kǝra Hyal mǝliya wu Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","Yi ɗa mafa nǝ ndǝshigu kau, lagur mayiwakur nǝ Hyal kǝra yi dlǝwuri lagur mǝl thlǝr dǝnama nyi. ");
INSERT INTO mfm_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","Alaga kǝ nayi nga ndiya ǝnga kushu wu pama patǝr nji cici nǝ Hyal, nji nǝ ɗa najaka mayiwakur aga ya tǝtǝlna ndǝshigu anǝ njira aˈyi njir Yahudiya mai. Ndǝshigu kau, ca ngǝ barka ɗǝɗǝwa kǝra nji gǝra sǝn walbiya wu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","Nayi tsu ya cabiya anǝ kalar nji ar babal lagu kǝra ji pabǝri nǝ mǝl sǝ ɗǝɗǝwa nyi, sǝ kǝra Hyal ɗǝwana wu kǝrnyi fa gangǝ kǝra tǝrabiya kau, ndǝra naja ngǝ mǝliya kalar sau. ");
INSERT INTO mfm_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","Dǝnga nyi ǝnga najaka mayiwakur ca ngǝ, lagur daɓǝ dzǝ njir nu, nji a cabiya gangǝkura hahangǝkur nǝ Hyal anǝ mambǝl mambǝl kǝra a vǝr sǝm tǝlkur ǝnga dǝnama dǝnama tǝlkurˈyar kǝra a dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","Kǝ ɗarkǝr ǝnggǝr kǝra Hyal mbiya tsu kaɗǝu, kǝra ji nyabiya wu Kǝrsiti Yesu Thlagǝr mǝn. ");
INSERT INTO mfm_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","Wu ja ǝnga lagur mbǝrsa wu ja nga mǝnu sǝni shili ǝgya Hyal ǝnga ɗǝfu zǝmǝu ba gǝra hivǝr. ");
INSERT INTO mfm_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","Agabangau, yu kǝdi hyi, a sara dza hya tǝ arya ɓwaɓwatǝ kǝra yi a gwa arya hyi mai, naja ngǝ kadakadarkur hyi. ");
INSERT INTO mfm_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","Arya kau, yu ɓǝliya undi wu mwar Dǝrmǝn, ");
INSERT INTO mfm_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","naja ndǝra patǝr njira a dǝmǝlmau ǝnga njira wu duniya biya sara wu ja. ");
INSERT INTO mfm_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","Ya vǝr kǝdi nyi, abǝr sara wu gangǝkur kadakadarkur nyi aga ja nyabiya hyi ǝnga dǝnama wu ɗǝfuwa hyi lagu Mambǝl nyi, ");
INSERT INTO mfm_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","aga Kǝrsiti a nggya wu ɗǝfuwa hyi lagur mbǝrsa. Ba ǝnga yu kǝdiyau, aga hya ciya hi wu yiwudzau, ");
INSERT INTO mfm_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","aga hya uya dǝnama daɓǝ ǝnga patǝr nji cici gǝ Hyal, aga hya nggabiya culi dlaɓǝkura yiwukur nǝ Kǝrsiti, ǝnga tǝgukura nyi, ǝnga dzǝgamǝkura nyi a gya, ba ǝnga dzǝgamǝkura nyi a dǝ. ");
INSERT INTO mfm_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","Ənga tsu yu ɓǝra kǝdi Hyal aga hya sǝn yiwukur nǝ Kǝrsiti kǝra tǝrabiya a biya banga patǝr sǝn sau, aga hya nyabiya dzau wu nyinyikur nǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","Kadakadarkur a nggyari anǝ Hyalǝr mǝn, ndǝra dǝnama nyi a vǝr mǝl thlǝr wu mǝn a ndiya sǝra mǝn wu kǝdiyau, ǝnga sǝra mǝn wu ɗǝnga. ");
INSERT INTO mfm_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","Kadakadarkur a nggyari anǝ nyi wu daɓǝ dzǝ njir nu ǝnga wu Kǝrsiti Yesu, wu zaman pamǝpamǝ patǝu, baˈanuwa! Amina. ");
INSERT INTO mfm_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","Agabangau, nayi ndǝra wu fursǝna arya nu Thlagǝu, yu kǝdi hyi aga hya nggya nǝ nggyabiya kǝra kyau ǝnga ngga kǝra nji ngga hyi. ");
INSERT INTO mfm_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","Cumu hya nggya njira gǝra hakǝr, ǝnga nji shishiˈwu ɗǝfu, ǝnga nji sǝsǝˈu sau, ba ǝnga njir sǝsǝˈu kuvwar nda wu yiwudzau. ");
INSERT INTO mfm_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","Hya nǝrdzau, aga hya sǝɓiya daɓǝr kǝrǝr hyi kǝra Mambǝl nǝ hyi lagur nggya nǝ jamǝkur kǝra dzǝɓiya hyi. ");
INSERT INTO mfm_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","Dzǝ zǝmǝu ngau, ǝnga Mambǝl zǝmǝu, ǝnggǝr kǝra nji nggar hyi a shili wu fǝr kǝr zǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","Thlagǝ zǝmǝu ngau, ǝnga mbǝrsa zǝmǝu, ba ǝnga tsu baɓǝtizǝma zǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","Hyal zǝmǝu ngau, Diya kalar ndau, ndǝra ar kǝra kalar ndau, lagu nji patǝu, ǝnga wu nji patǝu. ");
INSERT INTO mfm_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","Ama anǝ kalar ndǝ wu pama mǝn, Kǝrsiti a nǝ nyi ri lǝ sǝ lǝlau tsaˈa ǝnggǝr kǝra ji lari. ");
INSERT INTO mfm_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","Ənggǝra ndǝr Hyal nana, “Ənggǝra ji maˈyi a dar madzǝgamǝu, ji faˈari njira nji mbari patǝ ǝkkǝˈyi ja, kǝ ji lǝr sǝ lǝlau anǝ nji nyi.” ");
INSERT INTO mfm_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","Mi ngǝ sǝ kǝ cabiya, “Ji maˈyi a dǝ” ka? A cabiyari abǝr tanggǝrma ji maˈyi a gyuˈyi! ");
INSERT INTO mfm_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","Naja ndǝra maˈyi a gyuˈyi ngǝ maˈyi ta a dǝmǝlmau, aga ja nyabiya kalar sǝra ji mǝliya. ");
INSERT INTO mfm_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","Naja ngǝ lǝri sǝ lǝlǝ pamǝpamǝ anǝ nji. Lǝ sǝ lǝlǝ alenyi nji, cama sǝsau, ǝnga alenyi nji tsu, nabi, ǝnga alenyi nji tsu, tǝtǝlna ndǝr Hyal, ǝnga alenyi nji tsu, ɓǝla nji ǝnga malǝmǝ. ");
INSERT INTO mfm_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","Ji mǝl abangau, aga nji kǝ a daɓaga pabǝri nji cici nǝ Hyal, aga mǝl thlǝr nyi, aga hǝbiya dza Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","Nju dumwa ǝnga mǝl abangau, kǝl mǝna ɗa nji zǝmǝ wu mbǝrsa, ǝnga nji zǝmǝ wu sǝnbiya Zǝr Hyal. Ba mǝna ɗa njira nǝbiya dzau, njira tǝkǝri nggya nyinyau nǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","Nji mǝl abangǝ ara mǝna sara ɓǝra sha aga wazha yiɗiɗǝu, alaga njira nju tǝtǝl ǝnga hangǝkala nda, njira njir highiɓǝ pamǝpamǝ wu shabiya hangǝkala nda ǝnggǝr sǝra mǝla majigwal, njira njir dabar tsu ndu sǝn nggutana nda ba nda sǝmku nda ǝnga fati. ");
INSERT INTO mfm_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","Ar viya kau, kuji kǝ mǝna nana sǝra jiri wu yiwukur. Lagur na jiri kǝ nga mǝnu hǝ wu ja wu kalar sau, naja kǝra ar viya kǝr anǝ njir nu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","Sara ara ja ngǝ patǝr dzǝ daɓiya dzau, ǝnga ji sǝɓiya nda lagur dlǝwa dzǝ nǝ bǝlatǝu. Ba ji mǝliya nda ndǝ hau, ǝnga hǝriya dzau wu yiwukur, ǝnggǝr kǝra kalar gashal gashal dzǝ a vǝr mǝl thlǝr nyi. ");
INSERT INTO mfm_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","Nggara mau, yu na anǝ hyi, ǝnga yu cakǝr na anǝ hyi wu thlǝmǝr Thlagǝu, tsu hya ɓǝra nggya ǝnggǝr njira gǝra sǝn Hyal mai, njira fuwa ɗǝngar nda wu sǝ kurthlǝu. ");
INSERT INTO mfm_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","Ɗǝfuwa nda nyinyi nga nyi ǝnga kuthlǝu, kǝra kar nda ara sǝn nggabiya sǝ Hyal. Arya ɓaɓalkura ɗǝfuwa nda ǝnga arya gǝra sǝnkurǝr nda, ba nji tǝkǝbiya nda ǝnga pi kǝra Hyal ngǝ wu lau. ");
INSERT INTO mfm_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","Ara gǝra sǝlikurǝr nda, ba ndǝ lǝr kǝrnda anǝ sǝsukur, ba ɗa kǝl kalar sǝ zhizhigǝr nga ndu mǝl cumu. ");
INSERT INTO mfm_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","Aˈyi culi sǝkǝ nga hyi highiɓǝri ar kǝra Kǝrsiti mai. ");
INSERT INTO mfm_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","A hǝnggǝr yi abǝr a nggar hyi sǝ ar kǝra ja, ǝnga a highiɓǝr hyir nji jiri ar kǝra Yesu. ");
INSERT INTO mfm_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","Sǝra nji highiɓǝr hyi ca ngǝ hya piyari nggyabiya nǝ ndǝndǝkur kǝra hyi a gwa ɗǝɗǝmǝu, nggyabiya didiɗi kǝra wu shili ǝnga suna pamǝpamǝ kǝra nggutana hyi. ");
INSERT INTO mfm_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","A kyau, hya piyari Mambǝl Hyal ja shabiya ɗǝngar hyi a ɗa mafǝliyangǝu. ");
INSERT INTO mfm_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","Hya hari nggyabiya mafǝliyangǝ kǝra Hyal mǝliya kǝra a papa kǝrnyi, nggyabiya kǝra cabiya dzǝ wu nggya tsapǝkur ǝnga nggya cicikur. ");
INSERT INTO mfm_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","Agabangau, hya piyari thla fati, hya nggya njir thla jiri anǝ kuvwar nda, arya namǝn, nji zǝmǝ nga mǝn. ");
INSERT INTO mfm_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","A sara huɗa hyi a ndzǝ ja fuwa hyu mǝl bikǝ mai. A sara ndzǝ huɗǝr hyi a kar pǝci a gya tǝɗǝ mai. ");
INSERT INTO mfm_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","A sara hya nǝ nyi lagu anǝ shatan mai. ");
INSERT INTO mfm_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","Ndǝr hǝl ja sara dumwa ǝnga hǝl mai, ama ja ɗa ndǝr mǝl thlǝr tsapǝu ǝnga tsa ja. Abangǝ nga ju sǝn uya sǝra ju dlǝwari njira gǝra ǝnga sau. ");
INSERT INTO mfm_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","Ndǝr gǝra kyau a sara biya sara wu miya hyi mai, ama kǝl ndǝr kǝra wu daɓaga mǝliya nji nda hau wu Kǝrsiti, tsaˈa ǝnggǝr sǝra ndu yiwu. Lagu kǝ ngǝ ndǝr hyi wu ɗa ǝnga dlǝwa dzau anǝ njira wu sǝhimi. ");
INSERT INTO mfm_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","Ətsu a sara hya mǝliya huɗa Mambǝl Cici nǝ Hyal a ndzǝ mai, ara naja ngǝ mǝtsam kǝra cabiya abǝr nǝ Hyal nga hyi ar pǝcir bǝlbiya dzau. ");
INSERT INTO mfm_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","Kǝl hya tǝkǝbiya dzǝ ǝnga ɗa shishi, ǝnga zaˈwu ɗǝfu, ǝnga huɗǝ ndzǝndzau, ǝnga bwari, ǝnga ndza thlǝmǝ, ba ǝnga sǝɓǝ ndǝ wu huɗǝu. ");
INSERT INTO mfm_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","Hya ɗa kuˈya anǝ kuvwar hyi, ǝnga hya tǝhuɗǝ ǝgya kuvwar hyi, ǝnga hya tǝfǝbiya kuvwar hyi ǝnggǝr kǝra Hyal tǝfǝbiya hyi lagur Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","Ta hyi ɗa wazha kǝra Hyal wu yiwu, kǝl hya faˈabiya hi culi nggyabiya nǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","Hya nggya nggyabiya nǝ yiwudzǝ ǝnggǝr kǝra Kǝrsiti cabiya mǝn yiwudzau, kǝl ta ji lǝr kǝrnyi arya mǝn, ar viya sǝ lǝlǝ kǝra kisu ǝnga saɗaka anǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","Ama wu pama hyi, nja sara nggari alaga ǝnga ǝngwa abǝr nju mǝl sǝsukur, ǝnga kalar culi sǝ zhizhigǝr, ǝnga suna mai, arya aˈyi kyau anǝ nji cici nǝ Hyal mai. ");
INSERT INTO mfm_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","Abangǝ tsu ndǝr gǝra sǝli, ǝnga ndǝr hyahya, ǝnga ndǝr dzadza, aˈyi a ki ǝnga hyi mai. Ar viya kǝ hya dumwa ǝnga usaku anǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","Ara pakatǝ hyu sǝni, abǝr ndǝr mǝl sǝsukur, ǝnga ndǝr nggya zhizhigǝr, ǝnga ndǝr toma, ndǝra kakal nga ja ǝnga ndǝr nu katǝu, nanda aˈyi wu uya faˈa ki ǝnga tǝlkur Kǝrsiti ǝnga Hyal mai. ");
INSERT INTO mfm_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","Vanyi ndǝ ja sara nggutana hyi ǝnga ndǝr papatagǝ mai, arya culi nggyabiya kǝ ngǝ huɗǝ ndzǝndzǝ nǝ Hyal wu shili ar kǝra njira gǝra ɓǝlar ndǝr nyi. ");
INSERT INTO mfm_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","Agabangau, hya sara daɓǝ kǝr ǝnga nda mai. ");
INSERT INTO mfm_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","Ara ɗǝɗǝm wu kuthlǝ nga hyi, ama kabangǝkau, a uyar hyi mbǝmbǝlkur lagur Thlagǝu. Nahyi, hya nggya ar viya nji mbǝmbǝl. ");
INSERT INTO mfm_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","Arya mbǝmbǝl kau, ngu shili ǝnga thlǝr mǝnahǝu, ǝnga nggya tsapǝu, ǝnga nggya jijiri. ");
INSERT INTO mfm_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","Hya gal lagura hya daɓaga pina huɗa Thlagǝ ari. ");
INSERT INTO mfm_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","Hya tǝkǝbiya dzau ǝnga thlǝr kuthlǝ kǝra gǝra kǝtiya hyi, kuji hya mǝliya ja ɗa ar babal. ");
INSERT INTO mfm_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","Ara wu ɗa sǝ sǝsǝli ma nja ndǝr ar kǝra sǝra ndu mǝl ar ɗǝwa. ");
INSERT INTO mfm_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","Ar pǝcira nji dla ǝnga kalar sǝ wu mwar mbǝmbǝl, kalar sǝ wu ɗa ar babal. ");
INSERT INTO mfm_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","Arya mbǝmbǝl ngǝ wu mǝliya kalar sǝ ja ɗa ar babal. Ca ngǝ sǝra ɗa ji na, “Hyaˈari wu ghanyi nagǝ ndǝra wu ghanyi, hyaˈari sara vir tau, ba Kǝrsiti a mbǝlna mbǝmbǝl nyi a gyar gau.” ");
INSERT INTO mfm_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","Agabangau, hya nggya ǝnga hangǝkal wu nggyabiyar hyi. Hya sara nggya ǝnggǝr nji dza mai, ama hya ɗa nji hahangǝu. ");
INSERT INTO mfm_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","Hya mǝl thlǝr ǝnga kalar pǝci kǝra hyi uya aga mǝl sǝ mǝnahǝu, ara pǝci kǝra mǝn a gwa kau, pǝci ɗǝmwaˈyi ngau. ");
INSERT INTO mfm_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","Agabangau, hya sara ɗa nji dza mai, ama hya sǝnbiya sǝr yiwu huɗa Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","Hya sara nyi ǝnga padlǝ mai, kǝra wu mǝliya hya ɗa njir cim mǝl yambaɗǝkur. Ama hya kyaga nyabiya dzǝ ǝnga Mambǝl Hyal. ");
INSERT INTO mfm_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","Hya ndǝr wu pama hyi sara wu Zabura, ǝnga hya na sara wu lǝkakaɗǝ na, ǝnga na mambǝl mambǝl. Hya dumwa ǝnga na nǝ fal Thlagǝu ǝnga ɗǝfuwa hyi papatǝu. ");
INSERT INTO mfm_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","Ənga cumu hya lǝr usaku ar kǝra kalar sǝ anǝ Hyal Tada wu thlǝmǝr Yesu Kǝrsiti Thlagǝr mǝn. ");
INSERT INTO mfm_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","Hya lǝr kǝrhyi anǝ kuvwar hyi wu lagur gǝnggǝr nyi sǝli anǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","Nahyi mathlǝkǝˈyi kǝra ǝnga shili, hya lǝr kǝrhyi anǝ shilǝr hyi ǝnggǝr anǝ Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","Ara sal ngǝ kǝra mala nyi, ǝnggǝr kǝra Kǝrsiti ngǝ kǝra daɓǝ dzǝ njir nu nyi. Naja ǝnga kǝrnyi ngǝ ndǝr mbǝɗa daɓǝ dzǝ njir nu nyi kǝra ca ngǝ dza ja. ");
INSERT INTO mfm_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","Ənggǝr kǝra daɓǝ dzǝ njir nu wu lǝr kǝr anǝ Kǝrsiti, abangǝ tsu nahyi mathlǝkǝˈyi hya lǝr kǝrhyi anǝ shilǝr hyi, wu kalar sau. ");
INSERT INTO mfm_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","Nahyi shili, hya canǝ nyi yiwukur anǝ mathlǝkǝˈyir hyi ǝnggǝr kǝra Kǝrsiti canǝ nyi anǝ daɓǝ dzǝ njir nu nyi. Ji lǝri piya ja ar viya ja, ");
INSERT INTO mfm_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","aga nda ɗa nji cici anǝ Hyal lagur cina nda ǝnga ˈyimi lagur ndǝr Hyal. ");
INSERT INTO mfm_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","Ji mǝliya abangǝ aga ar pǝcira ju nda lǝr daɓǝ dzǝ njir nu anǝ kǝrnyi, ndu ɗa nji gumaguma kǝra ji cina casǝu, gǝra diɗi alaga hahashau, ama cici ǝnga gǝra vazau wu mwa nyi. ");
INSERT INTO mfm_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","Abangǝ tsu, ngǝ shili, a ca yiwukur anǝ mathlǝkǝˈyir nda, ǝnggǝr kǝra ndu yiwu dza nda. Kalar ndǝra canǝ nyi yiwukur anǝ mala nyi, kǝrnyi nga ju yiwu. ");
INSERT INTO mfm_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","Ara ndǝr piyari shishir dza kǝrnyi aˈyi mai, ama ja pabǝri dza ja ǝnga ja nǝ nyi sǝr sǝm, ǝnggǝr kǝra Kǝrsiti wu pabǝ dza daɓǝ dzǝ njir nu nyi. ");
INSERT INTO mfm_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","Ara namǝn ngǝ gashal gashal dza ja. ");
INSERT INTO mfm_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","Ənggǝr kǝra ja tsǝtsǝfau, abǝr, “Arya abangau, ndǝ sal wu piyari dǝnyi ǝnga mǝnyi, nda ɗa sǝ zǝmǝ ǝnga mala nyi, nanda mǝthlǝ ndu ɗa ar viya ndǝ zǝmǝu.” ");
INSERT INTO mfm_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","Sǝkǝ sǝ ɗǝɗǝwa ngǝ kǝra dzadzau ara nggabiya. Ama ya vǝr ndǝr, aga ya cabiya sǝra wu pama Kǝrsiti ǝnga daɓǝ dzǝ njir nu nyi. ");
INSERT INTO mfm_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","Agabangau, kalar ndǝ sal, ja cabiya yiwukur anǝ mala nyi ǝnggǝr kǝra ju yiwu kǝrnyi, ǝnga kalar mala tsu, ja gǝnggǝr nyi sǝli anǝ sal nyi. ");
INSERT INTO mfm_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","Wazha, ɓǝlara mau ndǝr njir yar hyi arya Thlagǝu, arya sǝ tsatsaˈa ngau. ");
INSERT INTO mfm_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","Dlaɗǝ nǝ tanggǝrma kǝra Hyal lǝri daɓǝ ǝnga alkawal, ca ngǝ, “Ga gǝnggǝr nyi sǝli anǝ dǝngau ǝnga mǝngau, ");
INSERT INTO mfm_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","aga ja nǝ ngǝ nggya jamǝu ǝnga fa gangǝ wu duniya.” ");
INSERT INTO mfm_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","Nahyi tadaˈyar, hya sara mǝliya huɗa wazhar hyi ja ndzǝ mai, ama hya hǝr nda lagur highiɓǝ ǝnga hwathlǝ nda wu Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","Nahyi mafaˈyar, hya ɓǝlari sǝra thlagǝr kir hyi wu duniya na hya mǝl ǝnga gǝnggǝr nda sǝli ba ǝnga hya hǝya nda kǝr. Hya mǝl thlǝr anǝ nda ǝnga huɗǝ zǝmǝ ǝnggǝr kǝra hya mǝl anǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","Hya mǝl sǝra ndu yiwu aˈyi wu liya nda waci mai, aga hya ɗa dlǝdlǝu wu mwar nda mai, ama hya mǝl thlǝr ar viya mafaˈyar nǝ Kǝrsiti, ba hya mǝl sǝr yiwu huɗa Hyal sara wu ɗǝfwa hyi. ");
INSERT INTO mfm_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","Hya mǝl thlǝr anǝ nda ǝnga ɗǝfuwa hyi papatǝu, ǝnggǝr anǝ Thlagǝu, ama aˈyi anǝ ndǝ mai. ");
INSERT INTO mfm_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","Hya ɗǝngari abǝr Thlagǝ ngu nda lǝ akkǝri anǝ kalar ndǝ arya sǝ mǝnahǝ kǝra ji mǝliya, tara naja mafa ǝnga alaga zǝr huɗa ki. ");
INSERT INTO mfm_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","Nahyi thlagǝr kiˈyar, hya mǝl anǝ mafar hyi abangǝ tsu wu kalar lagu. Hya sara gǝrahǝ nda mai, arya hyu sǝni abǝr Thlagǝr hyi zǝmǝ nga nyi a dǝmǝlmau, ǝnga naju ca pampamkur mai. ");
INSERT INTO mfm_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","Ndǝr nǝ kuɗiya, hya ɗa nǝnau wu Thlagǝu, lagur dǝgalkur dǝnama nyi. ");
INSERT INTO mfm_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","Hya har patǝr kar pa kǝra Hyal nǝ hyi, aga hya sǝn taˈyau, hya pana kalar dabar kǝra shatan wu shili ǝni. ");
INSERT INTO mfm_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","Ara par mǝn aˈyi ǝnga njira ǝnga kum ǝnga mashi mai, ama ǝnga mambǝl sǝm tǝlkur nǝ ɗǝmwaˈyikur, ǝnga dǝnama tǝlkur, ǝnga dǝnama nǝ kuthlǝu wu duniya, ba ǝnga mambǝl mambǝl ɗǝmwaˈyiˈyar kǝra a dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","Agabangau, hya har patǝr kar nǝ par hyi kǝra Hyal nǝ hyi, aga kalar pǝci kǝra nǝ ɗǝmwaˈyi shili, hyu sǝn taˈyau, aga ayukuɗa pa kau, tsu hyi tataˈyi piru. ");
INSERT INTO mfm_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","Agabangau, hya taˈyi piru. Bǝgǝ jirkur ja ɗa sǝr mba sara hyi, hya mbiya sara hyi ǝni ɓaɓalu. Bǝgǝ tsapǝkur ja ɗa lǝgutǝ liyangǝ kǝra hyu hari aga par hyi. ");
INSERT INTO mfm_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","Bǝgǝ pabǝ dzǝ nǝ tǝtǝlna ndǝshigu nǝ nggya jamǝkur ja ɗa ɓiɓir har hyi. ");
INSERT INTO mfm_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","Ayukuɗa kau, bǝgǝ mbǝrsa ja ɗa lǝgǝ kǝra hyu hǝri, aga hya tsiya uˈu nǝ hafǝ sara ara ndǝ ɗǝmwaˈyu. ");
INSERT INTO mfm_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","Bǝgǝ mbǝɗau ja ɗa dara liyangǝ kǝra hyu hari. Ənga bǝgǝ ndǝr Hyal, ja ɗa katsakǝr anǝ hyi. Katsakǝr kau, Mambǝl Hyal ngǝ nǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","Ənga hya kǝdi Hyal cumu wu dǝnama nǝ Mambǝl Hyal, ǝnga hya kǝdi culi pampamǝu. Arya kau, hya dumwa ǝnga tsamǝ lagu cumu wu capi, ma hyu kǝdi Hyal anǝ nji cici gǝ Hyal patǝu. ");
INSERT INTO mfm_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","Nahyi tsu hya dumwa ǝnga kǝdi Hyal anǝ ɗa, aga Hyal a fuwa ndǝr nyi wu miya yau. Nayi tsu ya dzǝgwa ndǝr anǝ nji gǝra ǝnga hivǝr aga ya daɓaga tǝtǝlna sǝ ɗǝɗǝwa nǝ ndǝshigu. ");
INSERT INTO mfm_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","Arya ndǝshigu kau, nga yi ɗa cama dǝgǝci kǝra wu fursǝna. Hya kǝdi Hyal anǝ ɗa aga ya dumwa ǝnga tǝtǝlna ndǝshigu kǝ gǝra ǝnga hivǝr ǝnggǝr kǝra ya kyaga mǝl. ");
INSERT INTO mfm_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","Tikikusu, zamǝr mǝn kǝra mǝnu yiwu, mafa Thlagǝ kǝra wu mǝl thlǝr nyi tsaˈa miya ɗǝfu, wu nda nar hyi kalar sau, aga hya sǝnbiya jamǝkura yau, ǝnga sǝra yu mǝl. ");
INSERT INTO mfm_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","Yu sǝ nyi a nda nǝ hyi aga najaka sau, aga hya daɓaga sǝnbiya sǝra ˈyi a gwa, ǝnga aga ja tsǝtsǝkur ɗǝfuwa hyi. ");
INSERT INTO mfm_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","Wazha ama, bǝgǝ nggya ǝnga huɗǝ pǝrtǝu, ǝnga yiwu dzau, ba mbǝrsa sara Hyal Tada ǝnga Thlagǝ Yesu Kǝrsiti, ja nggya ǝnga hyi. ");
INSERT INTO mfm_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","Bǝgǝ mayiwakur ja nggya ǝnga patǝr njira wu ca yiwukur, yiwukur gǝra kuɗau, anǝ Thlagǝr mǝn Yesu Kǝrsiti. Amina.");
INSERT INTO mfm_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","Cama tsǝtsǝfǝ kǝ sara ara Bulusu ǝnga Timathlawusu, mafaˈyar nǝ Kǝrsiti Yesu, anǝ patǝr nji cici gǝ Hyal wu Kǝrsiti Yesu kǝra wu Fǝlipi, daɓǝ ǝkkǝˈyi njir tǝɗǝmwa ǝnga njir mǝl thlǝr pamǝpamǝ anǝ daɓǝ dzǝ njir nu. ");
INSERT INTO mfm_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","Bǝgǝ mayiwakur ǝnga huɗǝ pǝrtǝu sara ara Hyal Dǝrmǝn ǝnga Thlagǝ Yesu Kǝrsiti nda nggya ǝnga hyi. ");
INSERT INTO mfm_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","Ya vǝr lǝ usaku anǝ Hyal ar kalar pǝci kǝra yi ɗǝngari ǝnga hyi. ");
INSERT INTO mfm_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","Cimu, ǝnga huɗǝ pipida nga ya vǝr kǝdi Hyal ɗa anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","Ya vǝr lǝ usaku anǝ Hyal arya hyi ǝnggǝra hyi daɓǝr kǝr ǝnga yau, wu lagur tǝtǝlna ndǝshigu mbari ar pǝci nǝ tanggǝrma baˈanǝ kabangǝkau. ");
INSERT INTO mfm_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","A yi ǝnga papalkur kǝr abǝr naja kǝra dzǝguya thlǝr mǝnahǝ wu hyi kau, ju nda dumwa ǝni kǝl ma ji nda nyabiya dzǝ ar pǝcira Yesu Kǝrsiti wu nda sha shida. ");
INSERT INTO mfm_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","Tsatsaˈa nga nyi ya ɗǝnga ar kǝra hyi ǝnggǝr kau, ta ɗa yu yiwu hyi gagaɗau, arya patǝkura hyi a ɗar mǝn wu cir zǝmǝ wu mayiwakur nǝ Hyal ǝnga yau, alaga ma yi wu fursǝna, alaga ma ya vǝr hal ǝnga cabiya jirkura ndǝshigu. ");
INSERT INTO mfm_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","Hyal ngǝ sakida ɗa ǝnggǝra ya vǝr cim aga ya lar hyi patǝu ǝnga ca yiwukur nǝ Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","Kǝdi Hyal ɗa ca ngǝ, bǝgǝ yiwudzǝr hyi a dumwa ǝnga cakǝ gagaɗau wu sǝnbiya sǝ ar kǝra Hyal ǝnga kalar nggabiya sǝ kǝra a vu Hyal. ");
INSERT INTO mfm_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","Kǝ wu nda dlǝwar hyi aga hya daɓaga walbiya sǝra ndiya ǝnga mǝnahǝu, aga ar pǝcira Kǝrsiti wu nda shili ju sa thlǝwa hyi cicau ǝnga gǝra vazau. ");
INSERT INTO mfm_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","Nahyi tsu, hyu ɗa nyinyau ǝnga nggya nǝ tsapǝkur kǝra nju uya lagur Yesu Kǝrsiti, kǝra wu shili ǝnga kadakadarkur ba ǝnga fal anǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","Wazha ama, yu yiwu hya sǝni abǝr sǝˈyar kǝ ɗa ǝnga yi kau, ndǝ ɗa aga cakǝri tǝtǝlna ndǝshigu. ");
INSERT INTO mfm_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","Arya kau, a ɗari ar babal anǝ njir ɓǝla pathla ǝnga nji patǝu abǝr nggya ɗa wu fursǝna, arya Kǝrsiti nga nyi. ");
INSERT INTO mfm_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","Arya fursǝna kǝra yi a gwa kau, a mǝliyari badǝgala wazha ama wu Thlagǝu ɗa ǝnga tsǝtsǝku ɗǝfu aga tǝtǝlna ndǝr Hyal gǝra ǝnga hivǝr. ");
INSERT INTO mfm_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","Jijiri, alenyi nji tsu nda vǝr tǝtǝlna ndǝshigu Kǝrsiti wu shishikur ǝnga maɗǝkur, ama alenyi nji ǝnga ɗǝnga nǝ mǝnahǝu. ");
INSERT INTO mfm_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","Njira ǝnga ɗǝnga mǝnahǝ kau, ndu tǝtǝlna ndǝr kǝ wu yiwukur, ara ndu sǝn abǝr nggya ɗa wu fursǝna arya hal ar kǝra ndǝshigu ngau. ");
INSERT INTO mfm_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","Alenyi nji ta tǝtǝlna ndǝshigu nǝ Kǝrsiti, wu yiwu kǝrnda, aˈyi nǝ jijiri mai. Cimǝr nda ngau, aga ya ɓǝra lar ɓwaɓwatǝ wu fursǝna. ");
INSERT INTO mfm_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","Ama ar viya mi nga ja? Sǝ mǝnahǝ kǝra a gwa ca ngǝ, wu kalar lagu, tara lagu fafati, ǝnga tara lagu jijiri, ndǝshigu nǝ Kǝrsiti a tǝtǝlnakǝr. Arya kau nga yi ǝnga huɗǝ pipida. Angǝu, yu dumwa ǝnga huɗǝ pipida, ");
INSERT INTO mfm_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","ara yu sǝni lagur kǝdi Hyalǝr hyi ǝnga dlǝwa dzǝ nǝ Mambǝl Yesu Kǝrsiti, sǝra ɗarkǝr ǝnga yi kau, wu nda shili ǝnga sǝr mbǝlbiya ɗa. ");
INSERT INTO mfm_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","Yu cim ǝnga fǝr kǝr wu ɗǝfuwa yau, ya sara fuwa kǝrɗa wu sǝli wu thlǝr Thlagǝu, ama ya fiya nyi ɗǝfu anǝ kǝrɗa gagaɗǝ kabangǝkau, ǝnggǝr kǝra cumu, aga Kǝrsiti ja uya kadakadarkur wu yau, alaga mbǝmbǝɗǝkura yau ǝnga tǝtǝkura yau. ");
INSERT INTO mfm_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","Ara anǝ ɗa, mbǝmbǝɗǝkura yau Kǝrsiti ngau, tǝtǝkura yi tsu akkǝri ngau. ");
INSERT INTO mfm_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","Ama, ma ɗa tsaˈa ya nggya mbǝmbǝɗau, a nggyari ya mǝl thlǝr kǝra ǝnga dlǝwa dzau. Ama mani nga ya hǝbiya a gwa? Nayi aˈyi a sǝn mai! ");
INSERT INTO mfm_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","Ənga jijiri ɗǝnga ɗa a tǝkǝbiyar dzǝ bwata mǝthlǝu. Sǝra yu yiwu ca ngǝ ya sha a ndǝgya Kǝrsiti aga ˈya nda nggya ǝnga ja, kǝra ca nga ndiya ǝnga mǝnahǝu. ");
INSERT INTO mfm_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","Ama a ki ya nggya mbǝmbǝɗau, ara ca nga ndiya anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","Ara a yi ǝnga papalkur kǝr abǝr yu nggya ǝkkǝˈyi hyi papatǝu aga hya cakǝr hau ǝnga huɗǝ pipida wu mbǝrsar hyi. ");
INSERT INTO mfm_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","Agabangau, ma yi ɓǝra sha shila ara hyi, hyu sa uya sǝr ɓwadzǝ wu Kǝrsiti Yesu lagu sǝra ja vǝr mǝl wu yau. ");
INSERT INTO mfm_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","Alaga mi ngǝ sǝra ɗa, taˈyi hya nggya tsatsaˈa ǝnga sǝra wu shili ǝnga kadakadarkur anǝ ndǝshigu Kǝrsiti. Agabangau, alaga yi shili ǝnga kǝrɗa aga ya sa lar hyi, ǝnga alaga yi nggari cama ar kǝra hyi, taˈyi ja ɗa abǝr a ciyar hyi dzǝ wu mambǝl zǝmǝu, ǝnga mǝl thlǝr hyi arviya ndǝ zǝmǝu arya mbǝrsa wu ndǝshigu. ");
INSERT INTO mfm_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","A sara hya hivǝr ara njir ɗa shishir hyi mai. Nggya gǝra hivǝr hyi a cabiyari abǝr nju nda sana nda, ama anǝ hyi mbǝɗǝ ngau sara ara Hyal. ");
INSERT INTO mfm_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","Ara mayiwakur kǝra nji nǝ hyi arya Kǝrsiti, aˈyi aga mbǝrsa waci wu ja mai, ama aga hya nda lar ɓwaɓwatǝ arya ja, ");
INSERT INTO mfm_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","ta ɗa hya vǝr sa ɓwaɓwatǝ ǝnggǝr kǝra yi tǝrabiya a gwa, kǝra baˈanǝ ǝshina tsu yi a gwa. ");
INSERT INTO mfm_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","Ta ɗa aˈyi hyi ǝnga vanyi tsǝtsǝku ɗǝfu arya daɓǝr kǝr kǝra aˈyi ara hyi wu Kǝrsiti, ta ɗa sǝsǝkuya dzǝ aˈyi ara hyi wu yiwukur nyi, ta ɗa daɓǝ dzau aˈyi ara hyi nǝ mambǝl, ta ɗa yiwukur ǝnga tǝhuɗǝ aˈyi nyinyau wu ɗǝfuwa hyi, ");
INSERT INTO mfm_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","taˈyi hya mǝliya caguli ɗa a nyabiya dzau lagur nggya wu ɗǝnga zǝmǝu, ǝnga hya cabiya yiwukur anǝ kuvwar hyi, ǝnga hya ɗa wu mambǝl zǝmǝu ǝnga cim zǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","A sara hya mǝl sǝ wu yiwu kǝrhyi ǝnga hakǝra hyi mai. Ama, hya tina kǝra hyi, hya tsamǝ kuvwar hyi adabanga hyi. ");
INSERT INTO mfm_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","A sara hya tsamǝ kǝrhyi ǝnga yiwu huɗa kǝrhyi wacu mai, ama tsu, hya tsamǝ yiwu huɗa kuvwar hyi. ");
INSERT INTO mfm_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","Taˈyi hangǝkala hyi a ɗa ǝnggǝr nǝ kǝrsiti Yesu: ");
INSERT INTO mfm_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","Naja kǝra Hyal nga ja, ama na ji hǝr kǝrnyi kakal ǝnga Hyal sǝra ja kyaga sǝɓiya ɓaɓal mai, ");
INSERT INTO mfm_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","ama kǝ ji hǝr kǝrnyi arya vanyi sǝ mai, kǝ ji hǝri nggyabiya mafa, nji yabiya nyi apapa ndau. ");
INSERT INTO mfm_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","Ənggǝra ji shili wu dzau ǝnggǝr ndau, ba ji tina kǝrnyi kǝ ji ɓǝlar ndǝr baˈanǝ tau, tǝ kǝra ar wu dladlakau. ");
INSERT INTO mfm_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","Agabangau ba Hyal fiya nyi a dar vira ndiya ǝnga dǝgal gagaɗau, ji dzǝgwa nǝ nyi thlǝmǝ kǝra ndiya kalar thlǝmǝ, ");
INSERT INTO mfm_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","abǝr ar nggar thlǝmǝr Yesu, kalar ndǝ wu nda ɓǝliya undi a gyu huɗǝ nyi, undi kǝra a dǝmǝlmau ǝnga undi kǝra a gyu ˈyi, ba undi kǝra a gyu ndǝla ˈyiˈyi, ");
INSERT INTO mfm_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","kalar miya tsu, ja nana abǝr Yesu Kǝrsiti Thlagǝ ngau, aga lǝ kadakadarkur anǝ Hyal Tada. ");
INSERT INTO mfm_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","Agabangau, bazhir ˈwa ɗa ˈyar, ǝnggǝr kǝra hya vǝr ɓǝlar ndǝr ɗa cumu, ma aˈyi yi ǝkkǝˈyi hyi, taˈyi hya dumwa ǝnga mǝl a ndiya ta alaga ma yi shǝwangǝu. Hya dumwa ǝnga mǝl thlǝr ǝnga hivǝr Hyal ba ǝnga tsǝdzau aga hya nyabiya sǝ ar kǝra mbǝɗǝr hyi. ");
INSERT INTO mfm_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","Ara Hyal nga vǝr mǝl thlǝr nyi wu ɗǝfuwa hyi, aga yiwu nǝ ɗǝfuwa hyi ǝnga mǝl thlǝrǝr hyi ja ɗa sǝ mǝnahǝu nǝ pina huɗa ja. ");
INSERT INTO mfm_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","Kalar sǝra hya mǝl, a sara hya mǝl ǝnga ngunguni alaga ǝnga kǝpal mai, ");
INSERT INTO mfm_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","aga hya ɗa njira gǝra ǝnga vazau, ǝnga nji cicau, wazha Hyal kǝra gǝra ǝnga nggyabiya didiɗi wu zaman mǝmǝlam kau. Zaman kau, hya vǝr mbǝl a gwa ǝnggǝr shashilga a ndu duniya, ");
INSERT INTO mfm_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","ma hyi sǝɓiya ndǝr nǝ pi ɓaɓalu. Hya mǝl abangau, aga ya uya sǝr ɓwadzau ar pǝcir shili Kǝrsiti, aga thlǝr ɗa ta, ǝnga pǝrapǝra ɗa ta, aˈyi a ɗa sǝ kurthlǝ mai. ");
INSERT INTO mfm_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","Ama alaga ma ji mbari abǝr nji wu sǝn hǝr ɗa aga sǝr hǝ saɗaka, kǝ nji pǝnggǝr ɗa a gya gǝra saɗaka thlǝrǝr hyi ǝnga mbǝrsar hyi, aˈyi yi ǝnga caguli ba huɗǝ pipida gagaɗau ǝnga hyi patǝu. ");
INSERT INTO mfm_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","Abangǝ tsu, hya ɗa ǝnga caguli ba huɗǝ pipida ǝnga yau. ");
INSERT INTO mfm_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","Aˈyi yi ǝnga fǝr kǝr wu Thlagǝ Yesu aga ya sǝwa hyi Timathlawusu kajangǝkau, aga ya ɗa ǝnga fǝ ɗǝfu ma yi nggar sǝ ar kǝra hyi. ");
INSERT INTO mfm_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","Nayi sayi uya ndǝ ǝnggǝr naja kǝra cabiya hyi yiwu dǝngwadǝngwa mai. ");
INSERT INTO mfm_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","Arya patǝ nda sǝra huɗa nda vǝr yiwu nga ndu mǝl, aˈyi nǝ Yesu Kǝrsiti ngǝ mai. ");
INSERT INTO mfm_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","Ama a sǝnǝr hyi ǝnggǝra Timathlawusu cabiya ndǝkura ja, hyu sǝni ǝnggǝra ˈyi mǝl thlǝr ǝnga ja ǝnggǝr zǝr ǝnga dǝnyi wu thlǝr ndǝshigu kau. ");
INSERT INTO mfm_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","Naja nga ya vǝr ɗǝnga ya sǝwa hyi nyi, ma yi lari kalar sǝ a maˈyiri tsatsaˈa ǝnga yau. ");
INSERT INTO mfm_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","Hǝnggǝr ɗa wu Thlagǝu, abǝr wu nda sǝkar mai, yu shili ǝnga kǝrɗa. ");
INSERT INTO mfm_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","Ama a mbari kǝl ya ɓǝra sǝwa hyi Ipafǝraditusu, zamǝ ɗa, bazhi mǝl thlǝr ɗa, bazhi par thlǝr ɗa, ndǝra tsu cama ngau, ndǝra hyi sǝwa aga ja sa dlǝwa ɗa. ");
INSERT INTO mfm_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","Pakatǝu, ju cim aga ja lar hyi patǝu, ǝnga ja vǝr ɗǝnga hyi gagaɗau ara hyi nggari abǝr ji ɗa gǝra ngga. ");
INSERT INTO mfm_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","Pakatǝu, a ɗar ja gǝra ngga, lǝhǝ a miya tau. Ama kǝ Hyal tǝhuɗǝ ǝgya ja, aˈyi kǝl na ja waci mai, ama ba nayau, a sara huɗǝ ndzǝndzǝ ɗa, a ɗa gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","Agabangau, cim ɗa ya ɓǝra sǝwa hyi nyi, aga ma hyi ɓǝra lari nyi, hyu ɗa ǝnga caguli, nayi tsu ɗǝnga sǝ ɗa wu gǝnna dzau. ");
INSERT INTO mfm_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","Agabangau, hya dlǝwur nyi ǝnga caguli wu Thlagǝu. Hya gǝnggǝr nyi sǝli anǝ culi nji ǝnggǝr kau. ");
INSERT INTO mfm_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","Arya ji ɗa citǝ a miya tau ara thlǝr Kǝrsiti. Ji lǝr piya ja aga dlǝwa ɗa, dlǝwa dzǝ kǝra hyi gǝra sǝn mǝliya ɗa. ");
INSERT INTO mfm_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","Jomǝya nyi wazha ama, hya nggya ǝnga huɗǝ pipida wu Thlagǝu. Tsǝfǝ sǝ kau, aˈyi ɓǝra ɗa sǝ ɓilaɓila anǝ ɗa ya tsǝfǝr hyi najaka sǝ mai, ama aga ja kǝtiya hyi nga nyi. ");
INSERT INTO mfm_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","Hya hangǝkal ǝnga hyaˈyar kau, njir mǝl sǝ ɗǝmwaˈyiˈyar kau, njir thla cicir dza nji abǝr ndu thla pǝlzha kau. ");
INSERT INTO mfm_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","Ara namǝn ngǝ pǝlzha thlathla nǝ jiri, namǝn kǝra a vǝr dlǝvǝ Hyal lagu Mambǝl Hyal, njira ǝnga kadakadarkur wu Kǝrsiti Yesu, namǝn njira gǝra fǝr kǝr ǝnga dǝnama ndǝndǝkur. ");
INSERT INTO mfm_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","Alaga kau, aˈyi yi ǝnga patǝr sǝra ndǝ a kyaga fǝr kǝr ni wu ndǝkur. Ma ndǝ aˈyi wu nggani abǝr sǝr fǝr kǝr nyi aˈyi wu ndǝkur, yu ndiya nda nyi naɗǝu. ");
INSERT INTO mfm_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","Ar pǝcir ya ɗa pida cisu nga nji thlana ɗa pǝlzha, ndǝr Izirayila nga yau, sara wu culi gǝ Benjamenu, ndǝr Ibrani, Ibrani kǝra gǝra mida, ma aga lagur nu dlaɗau, ndǝr Farisi nga yau. ");
INSERT INTO mfm_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","Ma aga nǝ kwakwaɗǝkur mashi nǝ thlǝr nu dlaɗau, a lǝr yi ɓwaɓwatǝ anǝ daɓǝ dzǝ njir nu, ma aga tsapǝkur nǝ lagu dlaɗau, sǝr vazǝ ɗa aˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","Ama patǝr sǝra tsaˈa aga ɗa sǝr akkǝri anǝ ɗa, kabangǝkau a ɗari sǝ didiɗi anǝ ɗa, arya Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","Aˈyi najakǝ waci mai, ama kalar sǝ a ɗari sǝ didiɗi anǝ ɗa, arya madiya gangǝkura sǝnbiya Kǝrsiti Yesu Thlagǝ gǝ ɗa, ndǝra arya ja nga yi tini kalar sau. Arya yi fiya kalar sǝ ǝnggǝr sǝ ar dzǝgau, aga ya daɓaga uya Kǝrsiti, ");
INSERT INTO mfm_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","ǝnga aga ya ɗa wu ja. Yi mǝl abangau, aga ya uya tsapǝkur nǝ Hyal kǝra nju uya lagur mbǝrsa, mbǝrsa wu Kǝrsiti, aˈyi tsapǝkur kǝra nju uya lagur nu dlaɗǝ mai. ");
INSERT INTO mfm_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","Yu yiwu ya sǝn Kǝrsiti ǝnga dǝnama nǝ hyaˈari nyi sara vir tau, ǝnga daɓǝr dzau wu sa ɓwaɓwatǝ nyi, aga ya ɗa ǝnggǝr naja wu tǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","Aga alaga abari ya jigǝwa dzau wu njir hyaˈari sara vir tau. ");
INSERT INTO mfm_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","Aˈyi cabiya abǝr a ɗar yi kalar sǝra ya kyaga ɗa aga nyi mai, alaga abǝr a nyabiyar yi dzǝ cicipǝ mai. Ama sǝ pathlǝ kǝra ya vǝr mǝl, ca ngǝ, yu nǝrdzau, yu jahǝ kǝrɗa a ndumwa aga ya sǝɓiya sǝra Kǝrsiti Yesu mbar ɗa aga nyi. ");
INSERT INTO mfm_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","Wazha ama, aˈyi yi lar kǝrɗa abǝr a sǝɓiyar yi nǝɗa mai. Ama sǝ pathlǝ kǝra ya vǝr mǝl, ca ngǝ ya fari ǝnga sǝra tǝrabiya patǝu, aga ya nǝrdzau aga ya uya sǝra a dumwa. ");
INSERT INTO mfm_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","Yi cakǝri nǝrdzau a dumwa, a da dlǝwu akkǝri nǝ sǝmku tǝlkur, akkǝri kǝra Hyal ngga ɗa aga nyi, akkǝri kǝra a dǝmǝlmau lagu Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","Taˈyi patǝkura mǝn kǝra nǝnau wu mambǝl, mǝna kyaga ɗa ǝnga ɗǝngabiya sǝ abangau. Ma ndaliya hyi aˈyi ǝnga nggabiya sǝ pamǝu, taˈyi Hyal a cabiya hyi sǝra tsaˈa ar babal. ");
INSERT INTO mfm_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","Sǝ dǝgal kǝra aˈyi, ca ngǝ, taˈyi mǝna dumwa ǝnga mǝl sǝra mǝn highiɓǝri. ");
INSERT INTO mfm_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","Wazha ama, hya daɓiya dzǝ ǝkkǝˈyi nji aga hya faˈabiya hiya nggyabiya ɗa, ǝnga hya tsamǝ ǝnga hangǝkal njira vǝr nu nggyabiya kǝra ˈyi highiɓǝr hyi. ");
INSERT INTO mfm_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","Ənggǝr kǝra yi wuraga na anǝ hyi ɗǝɗǝmǝu, yu ɓǝra nar hyi wayu ǝnga sǝlǝm, nji gangǝ a vǝr dawa nǝ wu dladlakǝ nǝ Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","Kuɗiyar nggyabiyar nda ca ngǝ tǝ nǝ dǝngwadǝngwa. Hyalǝr nda tsu, ca ngǝ sǝr gu ta nda. Kadakadarkur nda, ca ngǝ mǝl sǝ sǝsǝli. Ɗǝngar nda patǝu, ar kǝra sǝr duniya. ");
INSERT INTO mfm_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","Ama namǝn, njir tǝlkur Hyal nga mǝn. Namǝn wu vǝvǝr nga mǝna vǝr sǝkǝ ndǝr Mbǝɗau sara dǝmǝlmau, naja ngǝ Thlagǝr mǝn Yesu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","Naja ndǝra ǝnga dǝnama nǝ sǝn hǝr kalar sau, a shili ǝgya kiɗa dǝnama nyi. Ənga dǝnama nyi tsu, ju nda shabiya dza mǝn kǝra tǝtǝwa kau, aga ja ɗa ǝnggǝr dza ja kǝra ǝnga kadakadarkur. ");
INSERT INTO mfm_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","Agabangau, zamǝ ɗa ˈyar, nahyi kǝra yu yiwu, aˈyi hyi wu ɗǝfuwa yau cumu, nahyi ngǝ caguli ɗa ǝnga dara tǝlkur kǝra yu nda uya nǝ akkǝri thlǝr ɗa, ya vǝr kǝdi hyi aga hya ciya dzǝ wu Thlagǝu, nahyi bazhir ˈwa ɗa ˈyar. ");
INSERT INTO mfm_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","Ya vǝr tǝɗǝ himiya Iwudiya ǝnga Sintiki, aga nda gwabiya dzau ara nji gǝ Thlagǝu nga nda. ");
INSERT INTO mfm_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","Nagǝ tsu, ndǝr mǝl thlǝr ɗa nǝ jijiri, ya vǝr kǝdi ngau aga ga dlǝwar mathlǝkǝˈyi kau, ara a sar nda ɓwaɓwatǝ ǝnga yau a vǝr tǝtǝlna ndǝshigu, ba Kǝlemetu tsu ǝnga alenyi bazhi thlǝr ɗa ˈyar, nanda kǝra thlǝmǝr nda tsǝtsǝfǝ a wu Lǝkakaɗǝ nǝ pi. ");
INSERT INTO mfm_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","Hya nggya ǝnga caguli wu Thlagǝu cumu. Ya ɓǝra zhabiya nar hyi, hya nggya ǝnga caguli. ");
INSERT INTO mfm_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","Bǝgǝ munyar hyi a cabiya dzau anǝ kalar ndau. Hya sǝnbiya abǝr shilir Thlagǝu a ɗari lǝhǝu. ");
INSERT INTO mfm_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","A sara hya ɓila kǝrhyi arya kalar sǝ mai, ama hya nar nyi kalar sau anǝ Hyal lagur kǝdi Hyal ǝnga kǝdi nǝ ɓwakǝr ǝnga lǝ usaku. ");
INSERT INTO mfm_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","Lagu kau ngǝ Hyal wu nda nǝ hyi huɗǝ pǝrtǝu kǝra ndiya kalar nggabiya sau, ǝnga ju nda ɓǝlar ɗǝfuwa hyi ǝnga ɗǝngar hyi wu Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","Jomǝ ndǝla nyi patǝu, wazha ama, kalar sǝra jijiri, ǝnga kalar sǝra nja hakǝra nyi, ǝnga kalar sǝra tsapǝu, ǝnga kalar sǝra cicau, ǝnga kalar sǝra wu shili ǝnga yiwudzau, ǝnga kalar sǝra nja cicimau, ǝnga kalar sǝra ndiya ǝnga mǝnahǝu, alaga kalar sǝra dlǝdlǝvau, hya ɗǝngabiya sǝ ar kǝra nda patǝu. ");
INSERT INTO mfm_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","Hya mǝl thlǝr ǝnga kalar sǝra hyi highiɓǝri, ǝnga sǝra hyi dlǝwuri, ǝnga kalar sǝra hyi nggari ara yau, ǝnga tsu kalar sǝra hyi lari ara yau, aga Hyal kǝra nǝ hyi huɗǝ pǝrtǝu ja nggya ǝnga hyi. ");
INSERT INTO mfm_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","Nayi ǝnga caguli gagaɗau wu Thlagǝu ara a ɓǝra hyaˈabiyar hyi yiwu ɗa wu ɗǝfuwa hyi. Pakatǝ a sǝnǝr yau abǝr hya vǝr yiwu ɗa, ama nahyi uya lagu kǝra hya sǝn cabiya ɗa mai. ");
INSERT INTO mfm_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","Aˈyi ara ghar sǝ kǝra yi a gwa nga ya vǝr na abangǝ kǝ mai, arya a highiɓǝr yi nggya nǝ fiya ɗǝfu anǝ kǝrɗa wu kalar nggyabiya kǝra yi a gwa. ");
INSERT INTO mfm_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","A sǝnǝr yau ǝnga nggyabiya nǝ ghar sau, ǝnga a sǝnǝr yau ǝnga nggyabiya ndǝr sǝ ɗa aˈyi. A highiɓǝr yi ǝnggǝra ya sǝn fiya ɗǝfu anǝ kǝrɗa wu kalar pǝci, alaga ya vǝr sǝm ǝnga alaga yi ǝnga wuɓau, alaga sǝ aˈyi ǝnga sǝ aˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","A sǝn mǝliya yi kalar sau lagu nyi ndǝra nǝ ɗa dǝnama. ");
INSERT INTO mfm_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","Alaga abangau, a mǝliyar hyi mǝnahǝu ǝnggǝra hyi dlǝwar ɗa wu pǝcira yu ɓwaɓwatǝu. ");
INSERT INTO mfm_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","Nahyi njir Fǝlipi a sǝnǝr hyi, ar pǝcira yi dzǝguya thlǝr nǝ ndǝshigu kau, daɓǝ dzǝ njir nu aˈyi alaga pathlǝu kǝra daɓǝr kǝr ǝnga yau lagur lǝ sau ǝnga dlǝwu mai, kǝl nahyi wacu ar pǝcira yi piyari Masidoniya. ");
INSERT INTO mfm_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","Ar pǝcira yi wu Tasalonika, a nyir hyi ǝnga sǝ sǝr dlǝwa dzau anǝ ɗa ar kǝr ar kǝr. ");
INSERT INTO mfm_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","A sara hya nggani abǝr lǝ sǝ lǝlau nga ya vǝr kǝdiyau ara hyi mai, ama lagur uya barka nga ya vǝr pahǝ anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","A kina ɗar nji ki sau kǝra nja kyaga kina ɗa patǝu, a ndiya sǝra nja kyaga ki ɗa. A dlǝwuri yi kalar sǝra yu yiwu, ta ɗa a dlǝwur yi lǝ sǝ kǝra hyi sǝwa Ipafǝraditusu ǝni. Lǝr sǝ lǝlǝ kau, lǝ sǝ ɗǝɗǝzǝ kisǝ ngau, saɗaka kǝra Hyal wu yiwu kǝra wu pina huɗa ja. ");
INSERT INTO mfm_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","Hyal ɗa tsu, ju nda nǝ hyi kalar sǝra hyu ghari, sara wu gangǝkura kadakadarkur bǝrba nyi wu Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","Bǝgǝ kadakadarkur anǝ Hyalǝr mǝn ǝnga anǝ Dǝrmǝn a nggya baˈanuwa. Amina. ");
INSERT INTO mfm_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","Hya usar mǝn patǝr nji cici gǝ Hyal kǝra wu Kǝrsiti Yesu. Wazha ama kǝra ˈya ǝkkǝˈyi nda, nda vǝr usa hyi. ");
INSERT INTO mfm_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","Patǝ nji cici gǝ Hyal nda vǝr usa hyi, nji cici nǝ ki Kayisaru nga ndiya ǝnga usa hyi. ");
INSERT INTO mfm_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","Bǝgǝ mayiwakur nǝ Thlagǝr mǝn Yesu Kǝrsiti a nggya ǝnga mambǝlǝr hyi. Amina.");
INSERT INTO mfm_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","Cama tsǝtsǝfǝ kǝ sara ara Bulusu cama sǝsǝ nǝ Kǝrsiti Yesu lagur yiwur huɗa Hyal, ǝnga sara ara zamǝr mǝn Timathlawusu, ");
INSERT INTO mfm_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","a nda nǝ wazha ama kǝra cicau ǝnga njir mǝl thlǝr tsaˈa miya ɗǝfu wu Kǝrsiti wu Kolosi. Bǝgǝ mayiwakur ǝnga huɗǝ pǝrtǝu sara ara Hyal Dǝrmǝn anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","Cumu ˈyu lǝ usaku anǝ Hyal, Dǝya Thlagǝr mǝn Yesu Kǝrsiti, ar pǝcira ˈyu kǝdi Hyal arya hyi. ");
INSERT INTO mfm_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","Ara a nggar ˈya ǝnggǝra hyi mbǝrsa wu Kǝrsiti Yesu ba ǝnggǝra hyu ca yiwukur anǝ patǝr nji cici gǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","Sǝra ɗa hyi mǝl abangau, ca ngǝ arya fǝr kǝrǝr hyi ǝnga sǝra Hyal fiya hyi a dǝmǝlmau. Fǝr kǝrǝr hyi kǝ shili ar pǝcira hyi nggari ndǝr jiri, sara wu ndǝshigu kau. ");
INSERT INTO mfm_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","Ndǝshigu kau, wu dumwa ǝnga ya nggya mǝnahǝu wu nggyabiya nji, ǝnga ju cakǝ tǝtǝlnakǝr a ndu huɗa duniya. Ju nda ɗa ǝnggǝr kǝra ji mǝliya wu ɗǝfuwa hyi ar pǝci kǝra hyi nggari ndǝshigu mayiwakur nǝ Hyal ba hyi nggabiya jirkura nyi. ");
INSERT INTO mfm_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","Hyi highiɓǝri jirkura nyi sara ara Ipafǝrasu, bazhir ˈya wu mǝl thlǝr kau, kǝra ˈyi cabiya nyi yiwukur, naja kǝra a vǝr mǝl thlǝr Kǝrsiti kau, tsaˈa miya ɗǝfuwa ja ar viya ˈya. ");
INSERT INTO mfm_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","Naja ndǝra nar ˈya ar kǝra culi yiwukur kǝra aˈyi ara hyi wu Mambǝl. ");
INSERT INTO mfm_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","Ca ngǝ sǝra ɗa, ar pǝcira ˈyi nggar ndǝr kau, naˈyi saya taˈyi ǝnga kǝdi Hyal arya hyi mai, ˈyu kǝdi Hyal aga ja nǝ hyi sǝni yiwu huɗa ja, lagur hahangǝkur nǝ Mambǝl ǝnga nggabiya sǝ nǝ Mambǝl patǝu. ");
INSERT INTO mfm_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","Lagu kǝ ngǝ ɓǝr hyi wu nda ɗa ɓǝ tsaˈa aga Thlagǝu, ǝnga hyu ɗa njir pina huɗa ja wu kalar lagu, ǝnga hyu ɗa njir mǝl nggyabiya mǝnahǝu, wu kalar thlǝr kǝra hyu mǝl, ǝnga tsu hyu cakǝ wu sǝnbiya Hyal. ");
INSERT INTO mfm_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","Bǝgǝ Hyal ja cakǝr hyi dǝnama patǝ sara wu dǝnama nǝ kadakadarkur nyi aga hya uya ɗǝfu nǝ sǝsǝˈu sǝ ǝnga mba ɗǝfu ba caguli wu kalar sau. ");
INSERT INTO mfm_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","Nahyi tsu hya dumwa ǝnga lǝ usaku anǝ Tada, ndǝra nǝ mǝn dǝnama nǝ uya sǝr faˈa ki nǝ nji cici gǝ Hyal wu tǝlkur nǝ mbǝmbǝl. ");
INSERT INTO mfm_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","Ara a mbǝlbiyar mǝnǝr ja sara wu dǝnama nǝ kuthlǝu, a shili wu tǝlkur nǝ Zǝr ˈwa nyi. ");
INSERT INTO mfm_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","Kǝra lagu nyi nga mǝn uya bǝlbiya dzau ǝnga tǝfǝbiya bikǝr mǝn. ");
INSERT INTO mfm_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","Kǝrsiti ngǝ ndǝra pabiya Hyal, Hyal kǝra nji gǝra sǝn lari ǝnga li, naja ngǝ yarma ar kǝra kalar sǝra Hyal mǝliya. ");
INSERT INTO mfm_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","Ara lagu nyi nga nji mǝliya kalar sau, sǝ kǝra a dǝmǝlmau ǝnga sǝ kǝra a gyu ˈyi, sǝ kǝra li wu lari ǝnga sǝ kǝra li gǝra lari, tǝltǝlˈyar ǝnga njir dǝnama ǝnga njir nabiya ka mǝlna. Kalar sǝ kǝra nji mǝliya, nji mǝliya nda anǝ nyi ǝnga lagu nyi. ");
INSERT INTO mfm_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","Kǝrsiti nga dumwar kalar sau, lagu nyi tsu ngǝ kalar sǝ kǝra nji mǝliya sǝɓiya dzau. ");
INSERT INTO mfm_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","Naja ngǝ ar viya kǝr nǝ dzau, ca ngǝ daɓǝ dzǝ njir nu. Naja ngǝ dzǝgwar kalar sau, ǝnga naja ngǝ tanggǝrma ndǝra hyaˈari sara vir tau, aga ja ɗa sǝ tanggǝrma wu kalar sau. ");
INSERT INTO mfm_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","Ara huɗa Hyal pipida gagaɗau, nga ji nyabiya Hyalkur nyi wu ja. ");
INSERT INTO mfm_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","Lagu nyi nga ji ɓasǝwa kalar sǝ anǝ kǝrnyi. Lagur pǝ mashi nyi a dar wu dladlakau nga ji mǝliya nggya jamǝu, wu pama ja ǝnga sǝ kǝra nji mǝliya kǝra a dǝmǝlmau ǝnga kǝra a gyu ˈyi. ");
INSERT INTO mfm_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","Ɗǝɗǝm naɗǝ ngǝ pama hyi ǝnga Hyal, ǝnga tsu dawa nga hyi ǝnga ja, lagur ɗǝngar hyi ǝnga sǝr mǝla hyi. ");
INSERT INTO mfm_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","Ama kabangǝkau, Hyal a ɓasǝwa hyi ri lagur tǝr Kǝrsiti wu kum ǝnga mashi. Ji mǝl abangǝ aga ja shili ǝnga hyi a shili wu mwa nyi, ba ji dzǝgwa lǝr hyi cici gǝra ǝnga diɗi ǝnga gǝra vazau anǝ kǝr nyi. ");
INSERT INTO mfm_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","Kǝl hya dumwa wu mbǝrsar hyi ǝnga hya taˈyi pir wu jirkur, gǝra kǝnggǝɗau wu fǝr kǝr, kǝra hyi dlǝwuri sara wu ndǝshigu. Najaka ndǝshigu kǝra hyi nggari, ca nga nji tǝtǝlna a ndu duniya papatǝu, kǝra nayi Bulusu ngǝ Hyal mǝliya ndǝr mǝl thlǝr kau. ");
INSERT INTO mfm_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","Kabangǝkau, wu caguli nga yau, arya ɓwaɓwatǝ kǝra ya vǝr sa arya hyi. Lagur najaka ɓwaɓwatǝ nga yu nyabiya ɓwaɓwatǝ kǝra Kǝrsiti sa arya dza ja, kǝra ca ngǝ daɓǝ dzǝ njir nu. ");
INSERT INTO mfm_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","Hyal a nǝ ɗa ri dǝnama yi ɗa ndǝr mǝl thlǝr anǝ daɓǝ dzǝ njir nu lagur tǝtǝlna ndǝshigu nyinyau anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","Najaka cama kǝra ya vǝr tǝtǝlna anǝ hyi kau, sǝ ngǝ kǝra ɗǝɗǝwa, kǝra Hyal ɗǝwana anǝ njir zaman kǝra tǝrabiya, ama kabangǝkau, a cabiyar nyir ja anǝ nji cici gǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","Anǝ nda ngǝ Hyal caɗǝbiya aga ja mǝliya nda sǝni bǝrbakur nǝ kadakadarkur nǝ sǝ kǝra ɗǝɗǝwa wu pama njira aˈyi njir Yahudiya mai, abǝr Kǝrsiti wu hyi ca ngǝ fǝr kǝr nǝ kadakadarkur. ");
INSERT INTO mfm_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","ˈYu tǝtǝlna cama ar kǝra Kǝrsiti ǝnga ˈyu kughiya ǝnga highiɓǝr nyi anǝ kalar ndau, ǝnga patǝr hahangǝkur ˈya, aga ˈya lǝri kalar ndǝr nu cicipǝu wu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","Ca ngǝ sǝra ɗa yu nǝrdzǝ ǝnga patǝr dǝnama nyi kǝra ji nǝ ɗa kǝra wu mǝl thlǝr wu yau. ");
INSERT INTO mfm_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","Yu yiwu hya sǝni ǝnggǝra yi nǝrdzǝ arya hyi ǝnga arya njira wu Lawudekiya, ǝnga arya njira gǝra saya lar ɗa. ");
INSERT INTO mfm_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","Cim ɗa, ca ngǝ yiwudzǝ ja daɓǝr nda ǝnga nda uya tsǝtsǝkudzǝ wu ɗǝfuwa nda aga nda uya bǝrba nǝ nggabiya sǝ gagaɗau, lagu kǝ nga ndu uya sǝnbiya sǝ ɗǝɗǝwa nǝ Hyal, kǝra ca ngǝ Kǝrsiti ǝnga kǝrnyi, ");
INSERT INTO mfm_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","ndǝra wu ja ngǝ patǝr kadakadar hahangǝkur ǝnga nggabiya sǝ ɗǝwanakǝr. ");
INSERT INTO mfm_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","Yu na sǝˈyar kǝ anǝ hyi a sara vanyi ndǝ a nggutana hyi ǝnga ndǝr sǝkwa vi. ");
INSERT INTO mfm_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","Alaga kǝ aˈyi yi ǝnga hyi li ǝnga li mai, ama aˈyi yi ǝnga hyi wu mambǝl. Aˈyi yi ǝnga huɗǝ pipida ǝnggǝra yi nggari nggyabiyar hyi ǝnga taˈyir hyi wu mbǝrsa wu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","Ta ɗa a dlǝwuri hyi Yesu Kǝrsiti ar viya Thlagǝr hyi, kǝl hya dumwa ǝnga nggyar hyi wu ja. ");
INSERT INTO mfm_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","Hya ciya dzau ǝnga hya hǝriya kǝrhyi wu ja, hya ɗa nǝnau wu mbǝrsar hyi kǝra nji highiɓǝr hyi ǝnga hya nyabiya dzǝ wu lǝ usaku gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","Hya nggya ǝnga hangǝkal, hya sara piyari nja nggutana hyi lagur kǝpal kǝra gǝra kǝr mai, kǝra wu shili lagur sǝn sǝ njir duniya ǝnga dǝnama nǝ mambǝl nǝ duniya, ama aˈyi sara ara Kǝrsiti mai. ");
INSERT INTO mfm_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","Ara wu Kǝrsiti ngǝ patǝr Hyalkur nǝ Hyal nggya wu dzǝ nǝ ndǝkur nyi. ");
INSERT INTO mfm_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","Agabangǝ nga nji nǝ hyi aga hya nyabiya dzau wu ja, naja kǝra a vǝr sǝm tǝlkur ar kǝra njir dǝnama ǝnga njir sǝm tǝlkur. ");
INSERT INTO mfm_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","Wu ja nga nji thlana hyi pǝlzha, ama aˈyi culi pǝlzha kǝra nju thla ǝnga tsi mai, ama pǝlzha kǝra Kǝrsiti ǝnga kǝrnyi ngǝ mǝliya, lagur thlathlana nggyabiya ndǝndǝkur wu hyi. ");
INSERT INTO mfm_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","Ar pǝcira nji mǝliya hyi baɓǝtizǝma, nji haɗǝna hyi daɓǝ ǝnga Kǝrsiti ǝnga hyi hyaˈari daɓǝ ǝnga ja, lagur mbǝrsar hyi wu dǝnama nǝ Hyal ndǝra hyaˈana Kǝrsiti sara vir tau. ");
INSERT INTO mfm_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","Ɗǝɗǝm tǝtǝ nga hyi wu bikǝr hyi, ǝnga gǝra tǝkǝbiya dzǝr hyi ǝnga nggyabiya bikau, ama kǝ Hyal mǝliya hyi, hyi ɗa ǝnga pi daɓǝ ǝnga Kǝrsiti ara a tǝfǝbiya mǝnǝr ja bikǝr mǝn patǝu. ");
INSERT INTO mfm_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","Ji mǝliya abangau, lagur kǝkǝɗǝna sǝ tsǝtsǝfǝ kǝra nji tsǝfǝya aga sakida ar kǝra mǝn abǝr a ɓǝlnar mǝn dlaɗau. Kǝ ji hǝna sǝ tsǝtsǝfa nyi naɗǝu, ba ji dlakǝya ar wu dladlakau. ");
INSERT INTO mfm_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","Kǝ ji mbǝliya kar pa nǝ dǝnamaˈyar ǝnga njir sǝm tǝlkur nǝ mambǝl ˈyar. Kǝ ji fuwa nda wu sǝli ar babal ar pǝcira ji sǝmku tǝlkur ar kǝra nda a dar wu dladlakau. ");
INSERT INTO mfm_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","Agabangau, hya sara piyari ndǝ ja mǝliya hyi numa ar kǝra sǝra hyu sǝm alaga sǝra hyu sa mai. Abangǝ tsu, hya sara piyari ndǝ ja mǝliya hyi numa lagur ɓǝla mini, ǝnga Hya Mafǝliyangǝ ǝnga ɓǝla pǝcir Ɓǝlsar nǝ sugu. ");
INSERT INTO mfm_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","Ara sǝˈyar kǝ patǝ shangguɗa sǝra a vǝr shili ngau. Kǝrsiti nga kǝrnyi ngǝ jirkura nyi. ");
INSERT INTO mfm_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","A sara hya piyari kalar ndǝr hǝya kǝr nǝ fati ǝnga ndǝr dlǝvǝ waladi a ɗiya hyi mai, aga nda kar hyi ara sǝm tǝlkur mai. Culi nji kau, wu ndǝr gangǝ ar kǝra mǝtakǝr kǝra ndu lari, ǝnga nggyabiyar nda nǝ bikau wu mǝliya nda, ndu ɗa njir hakǝr gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","Culi ndǝ kau, aˈyi dlǝɓǝr kǝrnyi ǝnga Kǝrsiti mai, ndǝra naja ngǝ kǝr nǝ dzau. Naja ngǝ ndǝra sǝɓiya patǝr daɓǝ dzǝ njir nu, kǝra ca ngǝ dza ja, kǝra dlǝdlǝɓǝr mǝn ǝnga ja lagur mǝdǝla ja ǝnga bǝlata ja, aga mǝna hau ǝnggǝra Hyal wu yiwu mǝna hau. ");
INSERT INTO mfm_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","Ta ɗa a tǝr hyi daɓǝ ǝnga Kǝrsiti, ǝnga a tǝkǝbiya hyir ja sara wu dǝnama nǝ duniya, mi ngǝ ɗa tsu hyu nggya ǝnggǝr nahyi njir duniya ka? Mi ngǝ ɗa hyu ɓǝra lǝr kǝrhyi anǝ sǝra ndu na, sǝ kǝra ǝnggǝr, ");
INSERT INTO mfm_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","“Hya sara sǝɓǝ najaka sǝ wu tsa hyi mai, hya sara ɗaha najaka sǝ mai ǝnga hya sara tsǝkwa najaka sǝ mai” ya? ");
INSERT INTO mfm_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","Culi najaka sǝr ɓǝla, sǝr highiɓǝ ngǝ kǝra gǝra sǝkari arya nji mbiya nda lagur dlaɗǝ nǝ ndǝkur. ");
INSERT INTO mfm_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","Ənga jiri, culi najaka sǝr ɓǝla, aˈyi ja ǝnga sǝr pabiya sǝra wu shili ǝnga hahangǝkur. Nanda ngǝ, dlǝvǝ caca kǝra ndǝ fǝnggǝr nyi anǝ kǝrnda, ǝnga hǝya kǝr fafati, ǝnga tsu lǝ ɓwaɓwatǝ anǝ kumur dzau. Ama jirkura nyi, sǝr ɓǝla kau, aˈyi a sǝn shili ǝnga dǝnama nǝ sǝm tǝlkur ar kǝra dǝnama nǝ suna ndǝndǝkur mai. ");
INSERT INTO mfm_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","Ta ɗa a hyaˈana hyir nji a shili wu pi mafǝliyangǝ daɓǝ ǝnga Kǝrsiti, hya fǝr liya hyi ar sǝra a dǝmǝlmau, vira Kǝrsiti a vǝr nggya ari, ja vǝr nggya ar tsi mazǝm nǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","Hya fǝr ɗǝngar hyi ar sǝra a dǝmǝlmau, ama aˈyi ar sǝra wu duniya kǝ mai. ");
INSERT INTO mfm_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","Ara a tǝr hyi, ǝnga piya hyi ɗǝɗǝwa nga nyi ǝnga Kǝrsiti wu Hyal. ");
INSERT INTO mfm_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","Ar pǝcira Kǝrsiti wu nda cabiya dzau, ndǝra naja ngǝ piya hyi, nahyi tsu hyu nda cabiya dzǝ ǝnga ja wu kadakadarkur nyi. ");
INSERT INTO mfm_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","Agabangau, kǝl hya pǝna suna sǝr duniya wu ɗǝfuwa hyi, sǝ ǝnggǝr sǝsukur, ǝnga nggya dedeɓǝkur, ǝnga suna didiɗi, ǝnga nggyabiya ɗǝmwaˈyu, ǝnga suna sǝ ndau, kǝra kakalǝ ǝnga nu katǝu. ");
INSERT INTO mfm_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","Arya culi sǝˈyar kǝ ngǝ huɗǝ ndzǝndzǝ nǝ Hyal wu shili ar kǝra njira gǝra ɓǝlar ndǝr nyi. ");
INSERT INTO mfm_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","Nahyi ǝnga kǝrhyi abangǝ ngǝ culi nggya kǝra hyi nggya a gwa ɗǝɗǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","Ama kabangǝkau, kǝl hya tǝkǝbiya dzǝ ǝnga culi nggyabiya kau. Hya piyari ndzǝ ɗǝfu, ǝnga kwakwaɗǝkur ɗǝfu, ǝnga sǝɓǝ ndǝ wu ɗǝfu, ǝnga ndza thlǝmǝ, ǝnga ndǝr kǝra gǝra kyau sara wu miya hyi. ");
INSERT INTO mfm_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","Hya sara thla fati anǝ kuvwar hyi mai, ta ɗari a piyari hyi nggyabiya ɗǝɗǝmǝ ǝnga sǝra mǝla nda, ");
INSERT INTO mfm_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","ǝnga ta ɗari a hǝr hyi nggyabiya mafǝliyangǝu. Nggyabiya kau, nggabiya nyi a ɓǝra ɗari mafǝliyangǝ aga ja ɗa ǝnggǝr ndǝra mǝliya nyi. ");
INSERT INTO mfm_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","Ənggau, ca pampamkur aˈyi mai, alaga ndǝr Gǝrikǝu, alaga ndǝr Yahudiya, ǝnga ndǝra nji thlana nyi pǝlzha, alaga ndǝra nji gǝra thlana nyi pǝlzha, ǝnga njira nggyabiyar nda ǝnggǝr nǝ maˈwi, ǝnga njir miya tagǝu, ǝnga mafa, alaga njira aˈyi mafa mai, ama Kǝrsiti ngǝ sǝ patǝu, ǝnga naja ngǝ wu kalar sǝ patǝu. ");
INSERT INTO mfm_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","Agabangau, ta Hyal a ɗǝmbiya hyi ri aga hya ɗa nji nyi, ǝnga tsu hya ɗa nji cici nyi ǝnga njira ju yiwu gagaɗau, taˈyi hya ɗa njir tǝhuɗǝu, ǝnga nji hangǝkal, ǝnga nji hǝya kǝr, ǝnga nji kiˈwa, ba ǝnga njir mba ɗǝfu. ");
INSERT INTO mfm_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","Hya sǝsǝˈwuri kuvwar hyi, ǝnga hya tǝfǝbiya nyi anǝ nji kalar sǝra ndǝ ndzana hyi. Hya tǝfǝbiya nyi anǝ nji ǝnggǝr kǝra Thlagǝ tǝfǝbiya hyi. ");
INSERT INTO mfm_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","Adabanga sǝˈyar kǝ patǝu, sǝra ndiya patǝu ca ngǝ hya ca yiwukur anǝ kuvwar hyi, arya yiwukur ngǝ wu shili ǝnga daɓǝr kǝr kǝra tsaˈa. ");
INSERT INTO mfm_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","Bǝgǝ huɗǝ pǝrtǝ nǝ Kǝrsiti kǝra ji nǝ hyi a sǝm tǝlkur wu ɗǝfuwa hyi. Hya mǝl abangǝ ara Hyal ngǝ ngga hyi aga hya nggya ǝnga hya mǝl thlǝr wu jamǝkur ar viya nji zǝmǝu. Ənga hya dumwa ǝnga lǝ usaku anǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","Hya piyari ndǝr Kǝrsiti a nyabiya dzǝ wu ɗǝfwa hyi gagaɗau. Ənga hya dumwa ǝnga highiɓau ǝnga tǝɗǝ himi anǝ kuvwar hyi wu patǝr hahangǝkur. Aga ma hyu thlǝ na Zabura, ǝnga na tsǝtsǝfǝ nǝ Hyal, ǝnga alenyi na pamǝpamǝ nǝ Mambǝl, ja dla ǝnga usaku anǝ Hyal wu ɗǝfuwa hyi. ");
INSERT INTO mfm_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","Kalar sǝra hyu na ǝnga hyu mǝl, hya mǝl wu thlǝmǝr Thlagǝ Yesu, hyu lǝ usaku anǝ Hyal Tada lagu nyi. ");
INSERT INTO mfm_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","Nahyi mathlǝkǝˈyi, cumu hya lǝr kǝrhyi anǝ shilǝr hyi. Sǝra hya kyaga mǝl ngau, ǝnggǝr kǝra tsaˈa wu Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","Nahyi shili, hya ca yiwukur anǝ mathlǝkǝˈyir hyi, ǝnga hya sara ɗa nda mai. ");
INSERT INTO mfm_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","Nahyi wazha, hya mǝl kalar sǝra njir yar hyi nar hyi, arya sǝra wu pina huɗa Hyal ngau. ");
INSERT INTO mfm_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","Nahyi tadaˈyar, a sara hya ndza huɗa wazhar hyi mai, ara kǝra nda a sara hur. ");
INSERT INTO mfm_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","Nahyi mafaˈyar, hya mǝl kalar sǝra tarkir hyi nar hyi hya mǝl. Hya sara mǝl sǝra tsaˈa wu liya nda wacu aga nda daɓaga faliya hyi mai, ama hya mǝl sǝ ǝnga ɗǝfu zǝmǝ cumu, ara nahyi njir hivǝr Thlagǝ ngau. ");
INSERT INTO mfm_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","Kalar sǝra hyu mǝl, hya mǝl ǝnga ɗǝfwa hyi patǝu, ǝnggǝr njira wu mǝl sǝ anǝ Thlagǝu, ama aˈyi ǝnggǝr anǝ nji mai. ");
INSERT INTO mfm_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","Hya mǝl thlǝrǝr hyi mǝnahǝu, ara hyu sǝni abǝr Thlagǝ ngu nda nǝ hyi sǝr faˈa ki, akkǝri kǝra ji thlana ju nǝ nyi anǝ nji. Hya mǝl abangǝ ara Thlagǝ Kǝrsiti nga hyu nu. ");
INSERT INTO mfm_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","Kalar ndǝra dumwa ǝnga mǝl sǝ ɗǝmwaˈyu, nju nda kina nyi akkǝri ɗǝmwaˈyikur nyi, ara Hyal wu tazhira mai. ");
INSERT INTO mfm_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","Nahyi tarki, hya mǝl sǝra tsaˈa anǝ mafar hyi ˈyar gǝra ǝnga tazhira ara hyu sǝni abǝr aˈyi hyi ǝnga Thlagǝu a dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","Hya dumwa ǝnga kǝdi Hyal cumu, ma hya vǝr kǝdi Hyal, hya tsam ǝnga hangǝkal ǝnga hya lǝr usaku. ");
INSERT INTO mfm_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","Ənga hya kǝdi Hyal arya ˈya tsu, aga Hyal a nǝ ˈya lagura ˈya dumwa ǝnga tǝtǝlna ndǝr ɗǝwaɗǝwa ar kǝra Kǝrsiti, arya nyi nga yi wu fursǝna. ");
INSERT INTO mfm_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","Hya kǝdi Hyal arya yau, aga ya daɓaga cabiya ndǝr kǝra ɗǝɗǝwa ar babal ǝnggǝra ya kyaga mǝl. ");
INSERT INTO mfm_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","Hya ɗa ǝnga hahangǝkur wu sǝra hyu mǝl ǝkkǝˈyi njira aˈyi njir nu mai. Hya mǝl thlǝr ǝnga kalar pǝci kǝra hyi uya. ");
INSERT INTO mfm_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","Cumu, kalar ndǝrǝr hyi ja ɗa wu sǝmana ǝnga amayaˈyi, aga hya uya lagur shaɗǝwa kǝra mǝnahǝu anǝ kalar nji. ");
INSERT INTO mfm_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","Tikikusu wu nda nar hyi patǝr sǝ ar kǝra yau. Naja zamǝ huɗa mǝn ngau, kǝra wu mǝl thlǝr tsaˈa miya ɗǝfu ǝnga tsu naja mafa nǝ Thlagǝ daɓǝ ǝnga ˈya. ");
INSERT INTO mfm_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","Sǝra ɗa yu sǝ nyi a nda anǝ hyi ca ngǝ aga hya nda sǝnbiya patǝr sǝra a vǝr ɓau ar kǝra ˈya, ǝnga aga ja tsǝtsǝkur ɗǝfuwa hyi. ");
INSERT INTO mfm_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","Ju shili ǝnga zamǝ nǝ huɗa ˈya ndǝr mǝl thlǝr tsaˈa miya ɗǝfu, ca ngǝ Onisimusu ndǝra pathlǝ wu pama hyi. Ndu sa nar hyi kalar sǝra a vǝr ɗa ǝnga ˈya. ");
INSERT INTO mfm_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","Arisitakusu, ndǝra ǝnga yi wu fursǝna wu sǝ usa dzǝ nyi anǝ hyi, abangǝ tsu ngǝ Markusu sǝgǝya Barnabasu. Markusu, ndǝra gǝ nggar ndǝr ar kǝra ja, agabangau, ma ji shili, ba ga dlǝwuri nyi. ");
INSERT INTO mfm_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","Jashuwa, ndǝra nju ngga ǝnga Jastusu wu usa hyi tsu. Nanda ngǝ nji makǝr wu pama njir nu kǝra njir Yahudiya kǝra aˈyi ǝnga yau wacu, ndu mǝl thlǝr tǝlkur Hyal ǝnga yau ǝnggau. Nanda tsu, a sǝsǝkuyar nda ɗǝfuwa yau. ");
INSERT INTO mfm_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","Ipafǝrasu, ndǝ pathlǝ wu pama hyi ǝnga ndǝr mǝl thlǝr Kǝrsiti Yesu wu usa hyi tsu. Cumu nga ja vǝr kǝdi Hyal arya hyi ǝnga huɗǝ zǝmǝu aga hya ciya dzau wu patǝr yiwu huɗa Hyal, nǝnau ǝnga papalkur kǝr. ");
INSERT INTO mfm_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","Aˈyi yi ǝnga sakida, abǝr ju mǝl thlǝr gagaɗǝ arya hyi ǝnga njir Lawudekiya ǝnga Hirapolisu. ");
INSERT INTO mfm_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","Bazhir mǝn kǝra mǝn wu yiwu gagaɗau, naja ngǝ ligǝta Luka ǝnga Dimasu, nda vǝr usa hyi. ");
INSERT INTO mfm_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","Hya usar mǝn wazha ama kǝra wu Lawudekiya ǝnga kwamǝr mǝn Nimifasu ǝnga daɓǝ dzǝ njir nu kǝra wu daɓǝ wu ki nyi. ");
INSERT INTO mfm_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","Ayukuɗa nji jigana hyi najaka cama tsǝtsǝfau, ba hya sǝwa nyi anǝ njir Lawudekiya aga nja jigana nda tsu. Nahyi tsu nja jigana hyi kǝra nji sǝwa nyi anǝ njir Lawudekiya. ");
INSERT INTO mfm_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","Hya nar nyi anǝ Aricipusu aga ja mǝl ǝnga hangǝkal aga ja nyabiya thlǝr kǝra Thlagǝ nǝ nyi aga ja mǝl. ");
INSERT INTO mfm_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","Nayi Bulusu ǝnga kǝrɗa ngǝ tsǝfǝr hyi najaka cama nǝ usa dzau ǝnga tsa yau. Hya ɗǝngari abǝr tsu yi wu fursǝna mbamba. Mayiwakur nǝ Hyal ja nggya ǝnga hyi. Amina.");
INSERT INTO mfm_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Cama tsǝtsǝfǝ kǝ sara ara Bulusu, ǝnga Silasu, ba ǝnga Timathlawusu. A nda nǝ daɓǝ dzǝ njir nu wu mǝlmǝ Tasalonika, kǝra nǝ Hyal Tada ǝnga Thlagǝr mǝn Yesu Kǝrsiti. Mayiwakur ǝnga huɗǝ pǝrtǝu anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","Cumu nga ˈyu lǝ usaku anǝ Hyal arya hyi patǝu, ǝnga ˈyu ngga thlǝmǝr hyi wu kǝdi Hyalǝr ˈya. ");
INSERT INTO mfm_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","ˈYu dumwa ǝnga ɗǝnga ar kǝra hyi wu mwar Hyalǝr mǝn ǝnga Dǝrmǝn, ar kǝra thlǝrǝr hyi nǝ mbǝrsa, ǝnga thlǝr yiwukur kǝra hyu mǝl wu dzau, ǝnga cinapir hyi wu fǝrkǝrǝr hyi wu Thlagǝr mǝn Yesu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","Wazha ama kǝra Hyal wu yiwu, a sǝn ˈya abǝr Hyal ngǝ caɗǝbiya hyi, ");
INSERT INTO mfm_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","arya ndǝshigur ˈya aˈyi shili anǝ hyi ǝnga ɗahǝ waci mai, ama tsu ǝnga dǝnama, ǝnga Mambǝl Cicau, ǝnga jiri tataˈyi pir. Arya wu sǝn hyi ǝnggǝra ˈyi nggya wu pama hyi aga dlǝwa dzǝr hyi. ");
INSERT INTO mfm_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Hyi ɗa njir faˈabiya hiya ˈya ǝnga njira faˈabiya hiya Thlagǝu. Alaga wu ɓwaɓwatǝ gagaɗau, kǝ hyi dlǝwuri cama sara ara ˈya ǝnga huɗǝ pipida lagur Mambǝl Cicau. ");
INSERT INTO mfm_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Lagu kǝ nga hyi ɗa njira nju fǝ li ari anǝ patǝr njir nu wu ˈyiˈyir Masidoniya ǝnga Akaya. ");
INSERT INTO mfm_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Arya sara ara hyi ngǝ cama Thlagǝ tǝtǝlnakǝr, aˈyi wu ˈyiˈyir Masidoniya ǝnga Akaya waci mai, ama anǝ kalar njira sǝnbiya sǝ ar kǝra mbǝrsar hyi wu Hyal baˈamani. Agabangau, sǝ aˈyi ˈya ɓǝra sǝn na ar kǝri mai. ");
INSERT INTO mfm_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","Arya nja nyi ǝnga kǝrnda nga vǝr lǝ sakida ǝnggǝra hyi dlǝwur ˈya. Nja nyi nar ˈya ǝnggǝra hyi tǝkǝbiya dzǝ ǝnga katǝr hyi ˈyar, ba hyi sha shili ǝgya Hyal, Hyal jijiri kǝra ǝnga pi. ");
INSERT INTO mfm_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","Ndǝ nana tsu, ǝnggǝra hyi nggya aga sǝkǝ shidar Zǝr nyi sara dǝmǝlmau, ndǝra Hyal hyaˈana nyi sara vir tau, ca ngǝ Yesu, ndǝra kǝtiya mǝn ara numa nǝ huɗǝ ndzǝndzǝ Hyal kǝra wu shili. ");
INSERT INTO mfm_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","Nahyi ǝnga kǝrhyi wazha ama, hyu sǝni abǝr ndar ˈya a ndǝgya hyi aˈyi ɗa sǝ kurthlǝ mai. ");
INSERT INTO mfm_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Ama alaga kǝ a lar ˈya ɓwaɓwatǝu ǝnga diɗa wu mǝlmǝ Fǝlipi, ǝnggǝr kǝra hyu sǝni, ama ǝnga tsǝtsǝku ɗǝfu nǝ Hyalǝr mǝn, a nǝ hyir ˈya ndǝshigu, wu patǝkura ɓwaɓwatǝr ˈya wu tsa dawa. ");
INSERT INTO mfm_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Arya ndǝr Hyal kǝra ˈyu mǝl kau, aˈyi shili sara wu mbǝrza ǝnga dadam ɗǝfu mai, alaga ˈyi nǝrdzau aga ˈya nggutana hyi mai. ");
INSERT INTO mfm_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Ama ˈyu ndǝr ǝnggǝr njira Hyal dlunggǝri ǝnga nda, kǝ ji fuwa ndǝshigu wu tsa nda. Aˈyi ˈya njira wu yiwu nda pina huɗa nji mai, ama Hyal ndǝra wu dzǝbiya ɗǝnga ɗǝfwa nji. ");
INSERT INTO mfm_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","Ənggǝra hyu sǝni, ndǝr ˈya aˈyi ndǝr mǝsahǝ ar miya mai, ǝtsu aˈyi ˈya ǝnga ngushi ar kǝra bama nǝ ɗǝwa sunakur mai. Hyal ngǝ sakidar ˈya. ");
INSERT INTO mfm_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","Naˈya aˈyi gal fal ara nji mai, alaga sara ara hyi ǝnga sara ara alenyi nji mai. Ar viya cama sǝsǝ nǝ Kǝrsiti, tsaˈa nga nyi, ˈya sǝn na hya sǝmǝna ˈya. ");
INSERT INTO mfm_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Ama ˈyi nu hyi ǝnga hangǝkal ǝnggǝr kǝra ama a vǝr lǝ hangǝkal anǝ zǝr mamanji. ");
INSERT INTO mfm_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Arya ˈyu yiwu hyi gagaɗau, ca ngǝ ɗa ǝnga caguli nga ˈyi nǝ hyi ndǝshigu patǝ ǝkkǝˈyi kǝrˈya. Aˈyi tǝtǝlna ndǝr Hyal kǝ waci mai, ama ǝnga caguli ˈyi lǝr kǝrˈya ara njir ɗǝfwa ˈya nga hyi. ");
INSERT INTO mfm_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","Pakatǝ wazha ama, hyu ɗǝngari ǝnga thlǝr dzadzau kǝra ˈyi mǝl vuˈyi ǝnga pǝci ara ˈya sara fǝnggǝr hyi ɓwaɓwatǝu arya ndǝshigu anǝ kalar ndaliya hyi. ");
INSERT INTO mfm_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Nahyi ngǝ sakida, nahyi njir mbǝrsa, ǝnga Hyal ngǝ sakida tsu, ar kǝra culi nggyabiya kǝra ˈyi cabiya hyi, nggyabiya nǝ cicikur, ǝnga nǝ tsapǝkur, ba ǝnga nggyabiya gǝra vazau. ");
INSERT INTO mfm_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","Ənggǝr kǝra hyu sǝni, abǝr ˈya vǝr nu kalar ndaliya hyi ǝnggǝr kǝra tada a vǝr nu ǝnga wazha nyi. ");
INSERT INTO mfm_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","ˈYi tsǝtsǝkuya hyi, ǝnga ˈyi sǝsǝkuya hyi, ba ǝnga ˈyi kǝdi hyi aga hya nggya nggya tsatsaˈa aga tǝlkur Hyal, ndǝra ngga hyi a vu tǝlkur nyi ǝnga kadakadarkur nyi. ");
INSERT INTO mfm_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Arya abangau, ˈyu usaku anǝ Hyal cumu, arya ar pǝcira hyi dlǝwuri ndǝr Hyal kǝra hyi nggari sara ara ˈya, hyi dlǝwuri ǝnggǝr ndǝr Hyal ama aˈyi ǝnggǝr ndǝr ndǝ mai. Pakatu ndǝr Hyal ngau, kǝra a vǝr mǝl thlǝr nyi wu ɗǝfwa hyi, nahyi njira mbǝrsa. ");
INSERT INTO mfm_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","Nahyi ja, wazha ama, hya faˈabiya hiya daɓǝ dzǝ njir nu Hyal pamǝpamǝ kǝra wu Yahudi, njira wu Kǝrsiti Yesu. Ənggǝr kǝra hyi lar ɓwaɓwatǝ wu tsa njir mǝlmǝr hyi, tangǝ ǝnggǝr ta ngǝ daɓǝ dzǝ njir nu ˈyar lar wu pǝla njir Yahudiya. ");
INSERT INTO mfm_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","Njir Yahudiya ngǝ tsǝya Thlagǝ Yesu ǝnga nabiˈyar tsu, ǝnga tsu ndǝ kǝdlǝna ˈya, kǝ sǝ ndzana huɗa Hyal, ba ndǝ ɗa dawa ǝnga nji patǝu! ");
INSERT INTO mfm_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","Ndu nǝrdzau aga ka ˈya ara tǝtǝlna ndǝr Hyal anǝ njira aˈyi njir Yahudiya mai, a sara nda uya mbǝɗau. Lagu kǝ nga ndǝ cakǝri kyakiwa bikǝr nda. Ama kǝja huɗǝ ndzǝndzǝ Hyal a shidari ar kǝra nda. ");
INSERT INTO mfm_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","Ama, wazha ama, ar pǝcira nji tǝkǝbiya mǝn ǝkkǝˈyi hyi nǝ pǝci kushu, tǝkǝ nǝ kumǝr dzǝ ngau, aˈyi nǝ ɗǝfu mai. A vǝr cim nga ˈya, ǝnga ˈyu nǝrdzau aga ˈya lar hyi bama ǝnga bama. ");
INSERT INTO mfm_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","A ciwar ˈya wu kǝr aga ˈya shili ǝgya hyi, nayi Bulusu, yi nǝrdzau aga ya shili, nǝrdzǝ ɗa aˈyi aga zǝmǝ mai, aˈyi aga mǝthlǝ tsu mai, ama ba shatan kar ˈya. ");
INSERT INTO mfm_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","Mi ngǝ sǝr fǝr kǝrǝr ˈya, ǝnga sǝr cagulir ˈya, ǝnga tsu dara tǝlkur nǝ kadakadarkur ˈya wu mwar Thlagǝr mǝn Yesu ar pǝcir shida nya? Aˈyi nahyi ngǝ wa? ");
INSERT INTO mfm_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","Jijiri, nahyi ngǝ kadakadarkurǝr ˈya ǝnga cagulir ˈya. ");
INSERT INTO mfm_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","Agabangau, ta ɗa naˈyu sǝn mbiya ɗǝfu mai, ba ˈyi lari a ɗari tsaˈa nja piyar ˈya wu Athlinu naˈya zhizhir ˈya. ");
INSERT INTO mfm_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","ˈYi sǝwa hyi Timathlawusu zamǝr mǝn, ǝnga zamǝ mǝl thlǝr Hyal, ndǝr tǝtǝlna ndǝshigu nǝ Kǝrsiti aga ja cakǝr hyi dǝnama ǝnga tsǝtsǝkur hyi wu mbǝrsar hyi. ");
INSERT INTO mfm_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","Ji mǝl abangau, a sara vanyi nda sara kǝnggǝɗǝr dzau ara culi najaka ɓwaɓwatǝ kǝra hyi a gwa. Arya hyu sǝni tsu kaɗǝ nga nji nana abǝr kǝl mǝn tǝrabiya a gwa. ");
INSERT INTO mfm_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Pakatǝu, ar pǝcira aˈyi ˈya ǝkkǝˈyi hyi, a nar hyir ˈya abǝr nju nda ɗa ˈya. Abangǝ tsu nga nyi ɗarkǝr ǝnggǝr kǝra hyi sǝni. ");
INSERT INTO mfm_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Arya kau, ta ɗa nayi sǝn mbiya ɗǝfu mai, ba yi sǝwa aga ya yiwabiya ar kǝra mbǝrsar hyi. Yu hivǝr ara ndǝr dzǝ kau, ja sara dzǝbiya hyi ba hǝɗar ˈya a ɗa sǝ kurthlǝu. ");
INSERT INTO mfm_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Ama kǝja Timathlawusu a shiliri kabangǝkau sara ara hyi, ji sa nar ˈya sǝ mǝnahǝ ar kǝra mbǝrsar hyi ǝnga yiwukur kǝra hyu ca. Ji ɓǝra nar ˈya ǝnggǝra aˈyi hyi ǝnga ɗǝnga cacaguli ar kǝra ˈya ǝnga ǝnggǝra hyu cim nǝ lar ˈya ǝnggǝr kǝra ˈyu cim nǝ lar hyi. ");
INSERT INTO mfm_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","Agabangau, wazha ama, wu patǝr ɓwaɓwatǝ ǝnga ɗa pamǝpamǝ kǝra ˈyi sa, a uyar ˈya sǝsǝku ɗǝfu arya mbǝrsar hyi. ");
INSERT INTO mfm_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","Kabangǝkǝ ja, a ɗar ˈya nji mbǝmbǝɗau, ta ɗa a taˈyir hyi jijiri wu Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","Wa thlǝmǝ culi usaku, kǝra ˈya sǝn nǝ nyi anǝ Hyal, arya madiya caguli kǝra ˈyi uya wu mwar Hyal arya hya? ");
INSERT INTO mfm_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","Vuˈyi ǝnga pǝci nga ˈya vǝr nǝrdzau wu kǝdi Hyal aga ˈya lar hyi li ǝnga li aga ˈya nyabiya vira hyi tǝwa wu mbǝrsa. ");
INSERT INTO mfm_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","Bǝgǝ Hyalǝr mǝn ǝnga Dǝrmǝn ǝnga kǝrnyi, ba ǝnga Thlagǝr mǝn Yesu ja pahǝna ˈya lagu aga ˈya shili ǝgya hyi. ");
INSERT INTO mfm_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Bǝgǝ Thlagǝ a mǝliya yiwukurǝr hyi a cakau, a dumwa dumwa anǝ kuvwar hyi ǝnga kalar ndau ǝnggǝr kǝra ˈya vǝr yiwu hyi. ");
INSERT INTO mfm_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","Bǝgǝ ja tsǝtsǝkur ɗǝfuwa hyi aga hya ɗa nji gǝra vazau, ǝnga hya ɗa nji cicau wu mwar Hyalǝr mǝn ǝnga Dǝrmǝn wu pǝcir shidar Thlagǝr mǝn Yesu daɓǝ ǝnga nji cici nyi patǝu. ");
INSERT INTO mfm_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","Ayukuɗa sǝ patǝ wazha ama, ˈyu kǝdi hyi ǝnga ˈyu tsǝtsǝku hyi aga hya nggya nǝ pina huɗa Hyal ǝnggǝr kǝra hya vǝr nggya kabangǝkau. ˈYu cakǝr kǝdiyau aga hya ɓǝra cakǝr dumwa ǝnga mǝl abangǝ wu Thlagǝ Yesu. ");
INSERT INTO mfm_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","Arya hyu sǝni tǝɗǝ himiya hyi kǝra ˈyi mǝl kǝ wu dǝnama tǝlkur nǝr Thlagǝ Yesu ngau. ");
INSERT INTO mfm_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","Yiwu huɗa Hyal ngau, hya nggya cicau ǝnga hya hwi ara sǝsukur. ");
INSERT INTO mfm_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","Kalar ndǝ wu pama hyi ja sǝni ǝnggǝra ja nggya ǝnga kǝrnyi, ja nggya cicau ǝnga ja sǝɓiya ndǝkur nyi, ");
INSERT INTO mfm_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","aˈyi wu lagur suna sǝsukur ǝnggǝr kǝra njira gǝra sǝn Hyal wu mǝl mai. ");
INSERT INTO mfm_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Wu najaka sau, a sara ndǝ a ndza sǝ alaga ɗiya zamǝ nyi mai, arya Thlagǝu wu nda nǝ nyi anǝ kalar ndǝ ɓwaɓwatǝ nǝ kalar bikǝ nyi ǝnggǝr kǝra ˈyi nar hyi, ǝnga ˈyi kughiya hyi tsu kaɗǝ ta. ");
INSERT INTO mfm_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Aˈyi aga nggya dedeɓǝ ngǝ Hyal ngga mǝn mai, ama aga mǝna nggya cicau. ");
INSERT INTO mfm_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Agabangau, kalar ndǝra nggǝl ara dlǝwu ndǝr kau, aˈyi ndǝr ndǝ nga ji piyari mai, ama ndǝr Hyal nga ji piyari, Hyal ndǝra nǝ hyi Mambǝl Cici nyi. ");
INSERT INTO mfm_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Ar kǝra yiwu dzǝ wazha ama tsu, aˈyi kǝl yi ɓǝra tsǝfǝr hyi ar kǝri mai, arya ndǝr Hyal a highiɓǝrǝr hyi ri hya yiwu kuvwar hyi. ");
INSERT INTO mfm_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","Pakatǝu, hya vǝr ca yiwukur anǝ wazha ama wu ˈyiˈyir Masidoniya, ama cimǝr ˈya wazha ama, ca ngǝ hya dumwa ǝnga yiwudzau ar cakau ar cakau. ");
INSERT INTO mfm_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","Hya nǝrdzau aga hya nggya jamǝu, ǝnga hya sara fǝ miya hyi a vu ndǝr nji mai, ǝnga hya mǝl thlǝr ǝnga dǝnamar hyi ǝnggǝr kǝra ˈyi highiɓǝr hyi. ");
INSERT INTO mfm_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","Hya mǝl abangǝ aga hya ɗa njira nju gǝnggǝr nda sǝli wu mwar njira gǝra njir nu, ǝnga hya sara ɗa njir nggya aga ndǝ mai. ");
INSERT INTO mfm_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Wazha ama, naˈyu yiwu hya nggya ǝnga gǝra sǝn sǝ ar kǝra njira tau wu Kǝrsiti mai, ǝnga hya nggya wu huɗǝ kyakyaru ǝnggǝr njira gǝra ǝnga fǝr kǝr mai. ");
INSERT INTO mfm_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Mara a hǝnggǝr mǝn abǝr Yesu a tǝri, kǝ ji hyaˈari, abangǝ tsu a hǝnggǝr mǝn abǝr Hyal wu nda shabiya njira tǝ wu Yesu a shida ǝkkǝˈyi ja. ");
INSERT INTO mfm_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","ˈYu ndǝr kau anǝ hyi ǝnggǝr kǝra ndǝr Thlagǝ nana abǝr, namǝn kǝra aˈyi ǝnga pi kabangǝkau, ar pǝcir shidar Thlagǝr mǝn, aˈyi mǝn wu nda hyaˈari tanggǝrma a mwara njira tǝ mai. ");
INSERT INTO mfm_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Arya Thlagǝ ǝnga kǝrnyi wu nda shida sara dǝmǝlmau ǝnga ngga dǝdǝgalǝu, ǝnga ɗaha dǝdǝgal nǝ madiya waladi, ǝnga mbǝɗǝ tǝlǝmǝ nǝ Hyal. Ənggau, njira tǝ wu Kǝrsiti, nanda ngu dzǝgwa hyaˈari tanggǝrma. ");
INSERT INTO mfm_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","Ayukuɗa ndǝ hyaˈari, namǝn kǝra ǝnga pi mǝn wu dzǝgwa hyaˈari. Nja dzǝgwa hǝr mǝn a dǝmǝlmau a du dlama, aga mǝna da ɓǝ ǝkkǝˈyi Thlagǝr mǝn a dǝmǝlmau. A ndǝna, mǝna dzǝgwa dumwa ǝnga nggya ǝnga Thlagǝu baˈanuwa. ");
INSERT INTO mfm_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Agabangǝ ja, hya fiya nyi ɗǝfu anǝ kǝrhyi ǝnga najaka ndǝr. ");
INSERT INTO mfm_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","Wazha ama, ar kǝra pǝci ǝnga saka nǝ shilǝr Thlagǝu, aˈyi mbari ˈya tsǝfǝri hyi sǝ ar kǝri mai, ");
INSERT INTO mfm_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","arya nahyi ǝnga kǝrhyi hyu sǝni abǝr pǝcir Thlagǝr mǝn wu nda ɗa ǝnggǝr shilǝr ndǝr hǝl ǝvuˈyi. ");
INSERT INTO mfm_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","Ar pǝcira nja vǝr na, “Nggya jamǝu ǝnga huɗǝ pǝrtǝ a shiliri,” kukuthlǝ ba ɓwaɓwatǝ nǝ sa a shili ar kǝra nda, ǝnggǝr kǝra ya shili anǝ mala huɗu ma pǝcir ya nyi a shiliri. Lagur mbǝɗǝbiya dzǝ aˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","Ama nahyi wazha ama aˈyi hyi wu kuthlǝ mai, ǝnga pǝci kǝ aˈyi a sǝn shili ar kǝra hyi kukuthlǝ ǝnggǝr ndǝr hǝl mai. ");
INSERT INTO mfm_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","Nahyi patǝu, wazha nǝ mbǝmbǝl ngau, ǝnga wazha nǝ pǝci tsu. Namǝn aˈyi njir vuˈyi alaga njir kuthlǝ mai. ");
INSERT INTO mfm_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","Agabangau, a sara mǝna ɗa njir gu ghanyi mai, ǝnggǝr kǝra alenyi nja vǝr mǝl mai. Bǝgǝ mǝna nggya liliˈu aga mǝna tsamǝ ǝnga mǝna nggya ɓaɓathlǝ dzau. ");
INSERT INTO mfm_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","Arya njira wu gu ghanyi, ǝvuˈyi nga ndu gwa. Njira wu sa sǝ sasa tsu, ǝvuˈyi nga ndu sa, ba ja thlǝkǝna nda. ");
INSERT INTO mfm_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","Ta ɗa nǝ puci nga mǝn, taˈyi mǝna tsamǝ ǝnga mǝna nggya ɓaɓathlǝ dzau. Bǝgǝ mbǝrsa ǝnga yiwudzau nda ɗa lǝgutǝ liyangǝ har mǝn, ǝnga fǝr kǝr nǝ mbǝɗǝ tsu ja ɗa dara liyangǝ har mǝn. ");
INSERT INTO mfm_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","Arya Hyal aˈyi jigǝwa mǝn wu njir huɗǝ ndzǝndzǝ nyi mai, ama aga mǝna uya mbǝɗau lagur Thlagǝr mǝn Yesu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","Kǝrsiti ndǝra tau arya mǝn, aga mǝna ɗa ǝnga pi ǝnga ja, alaga liliˈu mǝn alaga mǝn wu ghanyi. ");
INSERT INTO mfm_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Agabangǝ hya fiya nyi ɗǝfu anǝ kǝrhyi, ǝnga hya dumwa ǝnga dlǝwa kuvwar hyi ǝnggǝr kǝra hya vǝr mǝl kau. ");
INSERT INTO mfm_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","Kabangǝkau, ˈyu kǝdi hyi wazha ama, hya gǝnggǝr nyi sǝli anǝ njir mǝl thlǝr ǝnga jirkur wu pama hyi, ca ngǝ njir tǝɗǝmwar hyi wu Thlagǝu, njir lǝ sawara anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Hya sǝbiya nda lagur hakǝra nda gagaɗau wu yiwukur arya thlǝrǝr nda. Hya nggya jamǝ wu pam ǝnga kalar ndau. ");
INSERT INTO mfm_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","ˈYu tǝɗǝ himiya hyi wazha ama, hya kughiya ndǝr nggya haɗǝwa, ǝnga hya fiya nyi ɗǝfu anǝ njir hivǝr, ǝnga hya dlǝwar nji tutuwa dǝnama, ba ǝnga hya mba ɗǝfu ǝnga kalar ndau. ");
INSERT INTO mfm_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Hya hangǝkal hya sara ki ɗǝmwaˈyikur ǝnga ɗǝmwaˈyikur mai, ama hya dumwa ǝnga mǝnahǝkur cumu anǝ kuvwar hyi ǝnga kalar ndau. ");
INSERT INTO mfm_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","Hya nggya ǝnga caguli cumu. ");
INSERT INTO mfm_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","Kǝdiya mǝ Hyal gǝra tsǝwa. ");
INSERT INTO mfm_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","Hya lǝ usaku anǝ Hyal wu kalar sau, arya ca ngǝ sǝr yiwu huɗa Hyal anǝ hyi wu Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","Hya sara kakana ndǝr nǝ Mambǝl mai. ");
INSERT INTO mfm_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","Hya sara diɗa ndǝrhaha mai. ");
INSERT INTO mfm_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","Dzǝgabiya mǝ kalar sau, hya sǝbiya ɓaɓalu sǝra mǝnahǝu. ");
INSERT INTO mfm_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","Kwaya mǝ naɗu ara mǝl sǝ ɗǝmwaˈyu. ");
INSERT INTO mfm_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Bǝgǝ Hyal ǝnga kǝrnyi, ndǝr lǝr huɗǝ pǝrtǝu, ja thlǝna hyi cici patǝu. Bǝgǝ mambǝlǝr hyi, ǝnga ɗǝfuwa hyi ǝnga kumǝr dza hyi a nggya gǝra ǝnga vazau baˈanǝ shilar pǝcir shilǝr Thlagǝr mǝn Yesu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","Ndǝra ngga hyi kau, ndǝ tsaˈa miya ɗǝfu ngau, ju nda nyabiya sǝra ji nana. ");
INSERT INTO mfm_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","Wazha ama, kǝdiya mǝ Hyal anǝ ˈya. ");
INSERT INTO mfm_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Usara mǝ wazha ama patǝ ǝnga bǝrpǝ dzǝ kǝra cicau. ");
INSERT INTO mfm_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","Yu kǝdi hyi ǝnga thlǝmǝr Thlagǝu, hya jigana cama tsǝtsǝfǝ kau anǝ patǝr wazha ama. ");
INSERT INTO mfm_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","Bǝgǝ mayiwakur Thlagǝr mǝn Yesu Kǝrsiti ja nggya ǝnga hyi. Amina.");
INSERT INTO mfm_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Cama tsǝtsǝfǝ kǝ sara ara Bulusu, ǝnga Silasu, ba ǝnga Timathlawusu. A nda nǝ daɓǝ dzǝ njir nu kǝra wu mǝlmǝ Tasalonika, kǝra nǝ Hyal Dǝrmǝn ǝnga Thlagǝ Yesu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","Bǝgǝ mayiwakur ǝnga huɗǝ pǝrtǝu sara ara Hyal Tada ǝnga Thlagǝ Yesu Kǝrsiti nda nggya ǝnga hyi. ");
INSERT INTO mfm_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Kakal nga nyi ˈya na usaku anǝ Hyal cumu aga hyi, nahyi wazha ama, ara mbǝrsar hyi a vǝr cakǝ gagaɗau, ǝnga yiwu kǝra hya vǝr yiwu kǝrhyi a vǝr cakau. ");
INSERT INTO mfm_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","Agabangau, ˈya vǝr ɓwasau ǝnga hyi wu daɓǝ dzǝ njir nu Hyal pamǝpamǝ arya sǝsǝˈwu sǝ ǝnga mbǝrsar hyi wu patǝr ɗa dzǝ pamǝpamǝu ǝnga nggya dzadzau kǝra hya vǝr sǝsǝˈwuri. ");
INSERT INTO mfm_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","Kalar sǝˈyar kau ca ngǝ cabiya numa nǝ Hyal tsaˈa nga nyi, arya kau nja nda jigǝwa hyi wu njira a ɗari kakal nda gwu tǝlkur Hyal kǝra hya vǝr sa ɓwaɓwatǝ aga nyi. ");
INSERT INTO mfm_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","Hyal ndǝ tsapǝ ngau, ju nda kina ǝnga ɓwaɓwatǝ anǝ njira vǝr lǝ ɓwaɓwatǝ anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","Ənga tsu, ju nǝ hyi ɓǝlsar, nahyi kǝra a vǝr sa ɓwaɓwatǝ ǝkkǝˈyi naˈya tsu ma Thlagǝ Yesu cabiya kǝr sara dǝmǝlmau wu uˈu mbǝmbau ǝnga waladi nyiˈyar. ");
INSERT INTO mfm_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","Ju sa nǝ nyi ɓwaɓwatǝ anǝ njira gǝra sǝn Hyal ǝnga njira piyari nu ndǝshigu nǝ Thlagǝr mǝn Yesu. ");
INSERT INTO mfm_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","Ndu nda sa ɓwaɓwatǝ kǝra gǝra kuɗau, ǝnga na ndu nda lari bama Thlagǝu ǝnga kadakadarkur nǝ dǝnama nyi mai. ");
INSERT INTO mfm_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","Sǝˈyar kǝ wu nda ɗa, ar pǝcira ji shida, aga nji cicau ndu sa nǝ nyi kadakadarkur, patǝ njira hǝnggǝri ndu nda gǝnggǝr nyi sǝli. Ənggau, patǝ ǝkkǝˈyi nahyi, ara a hǝnggǝr hyi ǝnga sakida kǝra ˈyi nar hyi. ");
INSERT INTO mfm_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Ənga najaka sǝ a wu kǝr, ˈya vǝr kǝdi Hyal anǝ hyi cumu, aga Hyalǝr mǝn ja jigǝwa hyi wu ngga nyi, ǝnga dǝnama nyi nga ju nda nyabiya kalar sǝ mǝnahǝ kǝra hyi mǝl ǝnga kalar sǝra ɗǝfuwa hyi nǝr hyi lagur mbǝrsar hyi. ");
INSERT INTO mfm_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","ˈYa vǝr kǝdi Hyal kau, aga nja nǝ nyi kadakadarkur anǝ thlǝmǝ Thlagǝr mǝn Yesu wu hyi, ǝnga nahyi tsu, hyu uya kadakadarkur wu ja. Sǝ kǝ wu ɗar kǝr lagur mayiwakur nǝ Hyalǝr mǝn ǝnga Thlagǝ Yesu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","Ar kǝra shilǝr Thlagǝr mǝn Yesu Kǝrsiti ǝnga sa ɓǝr mǝn papatǝu ǝkkǝˈyi ja, ˈya vǝr kǝdi hyi wazha ama, ");
INSERT INTO mfm_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","a sara hya gǝrahǝ wu ɗǝfuwa hyi kusakusa mai alaga hangǝkala hyi a hyaˈari mai, abǝr pǝcir shilir Thlagǝu a kuɗa shiliri mai. Ma vanyi, abǝr vanyi ndǝ a nar hyi ri abangau, lagur ndǝr haha, alaga cama tsǝtsǝfau, alaga ndǝr papahǝu, alaga nja na abǝr cama ngau sara ara ˈya. ");
INSERT INTO mfm_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","A sara hya piyari kalar ndau a nggutana hyi alaga abari mai, ara pǝci ta aˈyi shili mai, kǝl ma gǝra nggandǝrkur kǝ ɗa kwatahǝu, ǝnga ma ndǝr hyaˈa hangǝkal ta cabiya dzau, naja ngǝ ndǝra nji fiya nyi aga sa. ");
INSERT INTO mfm_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","Naja ngǝ ndǝra wu tsamǝ kǝrnyi ǝnga kadakadarkur, ju nda pari kalar sǝra nju ngga ǝnga Hyal, ǝnga kalar sǝr dlǝvau. Ju nda fiya kǝrnyi ar vir nggya wu ki Hyal, ǝnga ju fiya kǝrnyi ar viya Hyal. ");
INSERT INTO mfm_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","Nahyi aˈyi a ɗǝngari wa, yu na sǝˈyar kau anǝ hyi ar pǝcira mǝn ar vira zǝmǝu? ");
INSERT INTO mfm_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","Kabangǝkau a sǝn hyi sǝra a vǝr kar nyi, aga kǝl ma pǝci nyi a ɗari nga ja dzǝgwa cabiya dzau. ");
INSERT INTO mfm_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","Ara ndǝr hyaˈa hangǝkal kǝ a vǝr mǝl thlǝr ɗǝɗǝwa kabangǝkau, a nggyar ja ɗǝɗǝwa kǝl ma ndǝra vǝr kar nyi ara biyar babal kǝ ɓana dzau. ");
INSERT INTO mfm_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","Ba ndǝr hyaˈa hangǝkal ka dzǝgwa cabiya dzau, ndǝra Thlagǝu Yesu wu nda tsiya nyi ǝnga sǝ pi sara wu miya ja, ǝnga ja dzǝgwa wushina nyi ǝnga kadakadarkur nǝ shili nyi. ");
INSERT INTO mfm_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","Ndǝr hyaˈa hangǝkal kau, ju nda shili ǝnga dǝnama sara ara shatan, ja dzǝgwa sana liya nji ǝnga mǝl sǝ dǝdǝgur ǝnga mǝtsam pampamǝu. ");
INSERT INTO mfm_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","Ənga ja nda nggutana njira ar lagu sasa ǝnga kalar sǝ ɗǝmwaˈyi kǝra wu sǝkwa dzau, ara ndǝ piyari yiwu jiri kǝra wu nda kǝtiya nda. ");
INSERT INTO mfm_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","Arya najaka sǝ ngǝ Hyal a nda shabiya hangǝkala nda aga nda hǝnggǝr ǝnga fatiya nyi, ");
INSERT INTO mfm_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","aga abangǝ nju nda thlana nda numa patǝu, ara na ndǝ hǝnggǝri ǝnga jirkur mai, ama ndǝ yiwu ɗǝmwaˈyikur. ");
INSERT INTO mfm_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","Kakal nga nyi ˈya lǝ usaku anǝ Hyal cumu arya hyi, nahyi wazha ama kǝra Thlagǝ a yiwu, ara Hyal ngǝ caɗǝbiya hyi aga hya ɗa wu nji tanggǝrma kǝra uya mbǝɗǝ lagur Mambǝl, ca ngǝ mǝliya hyi cici ǝnga lagur hǝnggǝri wu jiri. ");
INSERT INTO mfm_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","Aga kǝ nga ji ngga hyi, lagur ndǝshigu ˈya kǝra ˈyi nǝ hyi, aga hya uya kadakadarkur nǝ Thlagǝr mǝn Yesu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","Agabangau, wazha ama, hya ciya dzau ǝnga hya sǝɓiya highiɓǝ ˈyar kǝ ˈyi nǝ hyi kau, alaga ǝnga miya ba lagur cama tsǝtsǝfau. ");
INSERT INTO mfm_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","Bǝgǝ Thlagǝr mǝn Yesu Kǝrsiti ǝnga kǝrnyi ba Hyal Tada, kǝra cabiya mǝn yiwukur, ja nǝ mǝn tsǝtsǝku ɗǝfu kǝra gǝra kuɗau ǝnga fǝr kǝr mǝnahǝu. ");
INSERT INTO mfm_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","Bǝgǝ ja nǝ hyi tsǝtsǝku ɗǝfu, ǝnga ja nǝ hyi dǝnama wu patǝr sǝ mǝnahǝu kǝra hyu mǝl ǝnga sǝra hyu na. ");
INSERT INTO mfm_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","Wu jomǝya nyi, wazha ama, ˈya vǝr kǝdi aga hya kǝdi Hyal anǝ ˈya. Hya kǝdi Hyal aga ndǝshigu nǝ Thlagǝu a tǝtǝlnakǝr kusakusa, ǝnga aga ja ɗa ǝnga kadakadarkur, ǝnggǝr kǝra ji shili anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","Ənga tsu hya kǝdi Hyal, aga nja kǝtiya ˈya ara nji ɗǝmwaˈyu ǝnga nji shishi, ara aˈyi kalar nji ngǝ ǝnga mbǝrsa mai. ");
INSERT INTO mfm_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","Ama Thlagǝ ndǝ tsaˈa miya ɗǝfu ngau, ju nda nǝ hyi dǝnama, ǝnga ja kǝtiya hyi ara nji ɗǝmwaˈyu. ");
INSERT INTO mfm_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","A mbǝrsar ˈya ǝnga Thlagǝu abǝr hya vǝr mǝl sǝra ˈyi na aga hya mǝl, ǝnga tsu hya dumwa ǝnga mǝl nda. ");
INSERT INTO mfm_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","Bǝgǝ Thlagǝu ja tsǝkwar ɗǝfuwa hyi aga hya sǝnbiya yiwukur nǝ Hyal, ǝnga sǝsǝu sǝ lagur Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","Wazha ama, ˈya vǝr na anǝ hyi wu thlǝmǝr Thlagǝr mǝn Yesu Kǝrsiti, abǝr hya tǝkǝ ǝnga kalar zamǝ haɗǝwa, ǝnga naja aˈyi wu yiwu mǝl thlǝr ǝnga sǝra hyi highiɓǝri ara ˈya mai. ");
INSERT INTO mfm_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","Nahyi ǝnga kǝrhyi, a sǝn hyi ǝnggǝr kǝra kikyau hya faˈabiya hiya sǝra ˈyi mǝl. Wu pǝcira ˈya ǝgya hyi na ˈya aˈyi nggya dzafǝ mai. ");
INSERT INTO mfm_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","Ənga tsu naˈya aˈyi wu sǝm sǝr sǝm nji gǝra kina mai. Ama a sar ˈya ɓwaɓwatǝ vuˈyi ǝnga puci a vǝr mǝl thlǝr, aga ˈya sara ɗa sǝ tǝdǝɓǝ anǝ hyi. ");
INSERT INTO mfm_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Sǝra ɗa ˈyi mǝl abangau, ara aˈyi ˈya gǝra dǝnama nǝ yiwa aga hya dlǝwar ˈya mai, ama aga ˈya ɗa sǝr fǝ li kǝra hyu faˈabiya hiya nyi. ");
INSERT INTO mfm_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Wu pǝcira mǝn ar vira zǝmǝu, a nar hyir ˈya abǝr ma ndǝ nggǝl ara mǝl thlǝr, a sara nja lǝ sǝr sǝm anǝ nyi mai. ");
INSERT INTO mfm_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","ˈYi na abangǝ ara ˈyi nggari abǝr alenyi nji wu hyi, nji haɗǝwa ngau, thlǝr mǝl aˈyi ara nda mai, kǝl nggya aga jiɓa njir mǝl thlǝr. ");
INSERT INTO mfm_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","Culi najaka nji ˈya vǝr tǝɗǝ himiya nda ǝnga nǝ nda sǝr ɓǝla wu dǝnama nǝ Thlagǝ Yesu Kǝrsiti aga nda mǝliya kǝrnda, nda mǝl thlǝr aga nda uya ɗǝfǝ kǝra nda sǝm. ");
INSERT INTO mfm_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Nahyi tsu, wazha ama, a sara hya hǝɗa ǝnga mǝl sǝra tsaˈa mai. ");
INSERT INTO mfm_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Kalar ndǝra nggǝl ara nu sǝra ˈyi nana a gwar cama tsǝtsǝfǝ kau, hya fǝr li mǝnahǝu ar ja. A sara hya daɓǝr kǝr ǝnga ja mai, aga ja gu sǝli. ");
INSERT INTO mfm_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","Ama a sara hya fiya nyi ar viya dawa mai, ama hya tǝɗǝ himiya ja ar viya zǝr ama. ");
INSERT INTO mfm_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Bǝgǝ Thlagǝ ǝnga kǝrnyi ndǝr lǝ huɗǝ pǝrtǝu, ja nǝ hyi huɗǝ pǝrtǝ cumu wu kalar lagu. Bǝgǝ Thlagǝ ja nggya ǝnga hyi patǝu. ");
INSERT INTO mfm_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","Nayi Bulusu ngǝ tsǝfǝ najaka usa dzau ǝnga tsa yau. Kǝ ngǝ sakida nǝ kalar cama tsǝtsǝfǝ ɗa. Ənggǝr kǝ nga yu tsǝfau. ");
INSERT INTO mfm_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","Bǝgǝ mayiwakur nǝ Thlagǝr mǝn Yesu Kǝrsiti ja nggya ǝnga hyi patǝu. Amina.");
INSERT INTO mfm_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","Sara ara Bulusu, cama sǝsǝ nǝ Kǝrsiti Yesu lagur ngga nǝ Hyal ndǝr mbǝɗa mǝn ǝnga Kǝrsiti Yesu ndǝr fǝ ɗǝfu anǝ mǝn, ");
INSERT INTO mfm_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","Nga vǝr tsǝfǝ anǝ Timathlawusu zǝr ɗa nǝ jiri wu lagur mbǝrsa. Mayiwakur ǝnga tǝhuɗǝu ǝnga jamǝkur sara ara Hyal Tada ǝnga Kǝrsiti Yesu Thlagǝr mǝn a nggya ǝnga gau. ");
INSERT INTO mfm_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","Ənggǝra yi tsǝtsǝkur ngau ar pǝci kǝra ya vǝr maˈyi a ndu Masidoniya, yu yiwu ga ɓǝliya sar kushu wu Afisa aga ga kughiya njir highiɓǝ nǝ fati aga nda piyari. ");
INSERT INTO mfm_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","Ga nar nda abǝr a sara nda hǝ hangǝkalǝr nda a ndǝgya pumungutuˈyar kǝra gǝra ǝnga kǝr ba ǝnga jiga thlǝmǝr cijiˈyar, kǝra tsu kuɗiya nyi aˈyi mai. Arya culi najaka sǝ wu shili ǝnga kǝpal wacu, ar viya thlǝr Hyal kǝra wu shili lagur mbǝrsa. ");
INSERT INTO mfm_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","Sǝra najaka ndǝr ar kǝri ca ngǝ yiwudzau, kǝra wu shili lagu ɗǝfu cicau, ǝnga ɗahǝ nǝ ɗǝfu kǝra a vǝr cabiya abǝr aˈyi mǝn ǝnga bikǝ mai, ba ǝnga tsu mbǝrsa kǝra pakatǝu. ");
INSERT INTO mfm_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","Alenyi nji a thlǝnar nda dzǝ sara ara najaka jiri, kǝra tǝkǝri ndǝ shabiya dzau, ndu nu ndǝr pamǝpamǝ nǝ kurthlǝu. ");
INSERT INTO mfm_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","Ndu yiwu nda ɗa malǝmǝ nǝ dlaɗau, ya kǝja nandǝ wu sǝni sǝra ndu ndǝr arya nyi kǝ mai, alaga sǝra ndu na anǝ nji gǝra ǝnga hivǝr. ");
INSERT INTO mfm_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","A sǝn mǝn abǝr dlaɗǝ sǝ mǝnahǝ ngau, ma nji mǝl thlǝr ni tsatsaˈa. ");
INSERT INTO mfm_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","Namǝn tsu wu sǝni abǝr dlaɗau, nji lǝr nyi anǝ nji cici mai, ama anǝ njira gǝra ɓǝla dlaɗau, ǝnga nji batal, ǝnga njira gǝra hivǝr Hyal, ǝnga njir bikǝ tsu, ǝnga njira gǝra cicau, ba ǝnga njira gǝra nu Hyal, ǝnga njir tsa dǝrnda ǝnga mǝr nda ba ǝnga njir tsa nji, ");
INSERT INTO mfm_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","ǝnga tsu njir mǝl sǝsukur, ǝnga shili kǝra wu pida ǝnga shili kuvwar nda ǝnga mathlǝkǝˈyi kǝra wu pida ǝnga kuvwar nda, ǝnga njir hǝl nji, abangǝ tsu njir thla fati, ǝnga njir lǝ sakida nǝ fati, ǝnga kalar sǝra pamǝ ǝnga highiɓǝ nǝ jirkur. ");
INSERT INTO mfm_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","Abǝr najaka highiɓǝ nǝ jijiri wu shili lagu ndǝshigu dlǝdlǝvǝ nǝ Hyal kǝra ǝnga barka, kǝra ji fuwa ɗa wu tsa yi aga ya tǝtǝlna. ");
INSERT INTO mfm_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","Yu usa Kǝrsiti Yesu Thlagǝr mǝn, ndǝra nǝ ɗa dǝnama aga mǝl thlǝr kau, arya ji hǝr ɗa ndǝra nja fǝr kǝr ni, ǝnga ji caɗǝbiya ɗa a shili wu thlǝr nyi. ");
INSERT INTO mfm_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","Alaga kǝ ɗǝɗǝmǝ nayi ndǝr vazǝ Hyal ngau, ndǝr ka thlǝr nyi ara ɓau, ǝnga tsu ndǝr diɗa nyi. Ama wu sǝˈyar kǝ patǝ kǝ yi uya tuhuɗu ara Hyal ara yi mǝl nda wu gǝra sǝnkur ǝnga gǝra mbǝrsa. ");
INSERT INTO mfm_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","Mayiwakur nǝ Thlagǝr mǝn nyabiya ɗa gangǝ gagaɗau, daɓǝ ǝnga mbǝrsa ba ǝnga yiwudzǝ kǝra aˈyi wu Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","Ndǝr kǝra yu nda na kau, ndǝr kǝra nja fiyafǝ ǝni ngau, kǝra tsaˈa nja dlǝwuri patǝu, abǝr, “Kǝrsiti Yesu shili wu duniya aga mbǝɗa njir bikau,” wu pama nda patǝ nayi nga ndiya ǝnga bikau. ");
INSERT INTO mfm_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","Ama ǝnggau ca ngǝ ɗa Hyal cabiya ɗa tuhuɗǝ nyi, nayi ndǝra ndiya ǝnga bikau, aga Kǝrsiti Yesu a cabiya munya nyi aga ya ɗa ndǝr ca lagu anǝ kalar ndǝra wu nda hǝnggǝri ǝnga ja nga ndu uya pi gǝra kuɗau nǝ baˈanuwa. ");
INSERT INTO mfm_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","Bǝgau dǝgalkur ǝnga dlǝvau nda nggya nǝ ngau tǝl gǝra kuɗau nǝ baˈanuwa, ndǝra gǝra ǝnga kuɗiya, ndǝra gǝra nju lari, ǝtsu nagǝ ngǝ Hyal zǝmǝ wacu nǝ baˈanuwa! Aminu. ");
INSERT INTO mfm_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","Timathlawusu, zǝr ɗa, yu lǝ ndǝr kau anǝ ngau ar kǝra ndǝr kǝra nabiˈyar nana ar kǝra gau ɗǝɗǝmǝu, aga lagur nu nda, gu nda ɗa ndǝr mǝl thlǝr mǝnahǝu gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","Nagǝ tsu ga sǝɓiya mbǝrsa ngau ǝnga ɗahǝ nǝ ɗǝfu kǝra mǝnahǝu, arya alenyi nji a tsiyari mbǝrsar nda lagur nggǝl ara nu ɗaha ɗǝfuwa nda. ");
INSERT INTO mfm_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","Wu pama nda ca ngǝ Himaniyasu ǝnga Alegǝzanda, njira yi lǝr nda anǝ shatan aga nda highiɓǝri nda sara diɗa ndǝr Hyal. ");
INSERT INTO mfm_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","Sǝ tanggǝrma, yu tsǝtsǝku ngau, aga nja dumwa ǝnga kǝdiyau, ǝnga ndǝr ǝnga Hyal, ǝnga nja dumwa ǝnga usa Hyal arya nji patǝu. ");
INSERT INTO mfm_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","Nja kyaga mǝl abangǝ ar viya tǝltǝlˈyar patǝu, ǝnga patǝr njira a miya thlǝr dǝdǝgalǝu. Nja mǝl abangǝ tsu aga mǝna uya nggya jamǝu ǝnga huɗǝ pipida wu hivǝr Hyal ba ǝnga nggya cicau wu mwar Hyal. ");
INSERT INTO mfm_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","Naja kau mǝnahǝ nga nyi, ǝnga tsu Hyal ndǝr mbǝɗa mǝn wu nggari mǝsahǝkura nyi, ");
INSERT INTO mfm_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","ndǝra wu yiwu patǝkura nji nda uya mbǝɗau, ǝnga nda shili wu sǝnbiya jirkur. ");
INSERT INTO mfm_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","Arya Hyal zǝmǝ ngau, ndǝra wu pama Hyal ǝnga nji tsu zǝmǝ ǝnga ja, ndǝ kau, naja ngǝ Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","Naja ngǝ lǝr kǝrnyi aga ja pǝliya nji patǝu. Najakǝ ngǝ cama kǝra Hyal lǝri anǝ duniya ar pǝci kǝra kakalǝu. ");
INSERT INTO mfm_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","Aga kǝ ngǝ Hyal caɗǝbiya ɗa cama sǝsau ǝnga tsu ndǝr tǝtǝlna ndǝr Hyal. Yi ɗa malǝmǝ highiɓau anǝ patǝr njira aˈyi njir Yahudiya mai, ar kǝra mbǝrsa ǝnga jirkur. Jiri nga yu na aˈyi fati mai. ");
INSERT INTO mfm_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","Yu yiwu shili ar kalar vi nda har tsi a dǝmǝlmau wu cicikur, wu kǝdi Hyal, aˈyi ǝnga ɗǝfu ndzǝndzǝ mai, ba aˈyi ǝnga kǝpal wu ɗǝfu mai. ");
INSERT INTO mfm_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","Yu yiwu tsu mathlǝkǝˈyi nda hari kar kǝra tsaˈa, lugutu kǝra kyau, aˈyi ǝnga gangǝkur mǝl shishir kǝr mai. Ənga tsu a sara nda ha kar dinairi mai, ba ǝnga thladla ǝnga kar nǝ gǝnna gangǝ mai. ");
INSERT INTO mfm_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","Ama nda nggya ǝnga nggyabiya mǝnahǝu kǝra wu kyaga mathlǝkǝˈyi kǝra cabiya kǝrnda abǝr nanda njir hivǝr Hyal ngau. ");
INSERT INTO mfm_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","Bǝgǝ mala ja dlǝwuri najaka highiɓau wu hangǝkal nyi ba ǝnga hǝya kǝr nǝ jijiri. ");
INSERT INTO mfm_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","Nayi nǝ nyi lagu anǝ mala ja highiɓǝ anǝ ndǝ sal mai. Nayi tsu nayi nǝ nyi lagu anǝ mala ja sǝm tǝlkur a dar kǝra shili mai, bǝgǝ ja nggya zǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","Arya Hyal mǝliya Adamu tanggǝrma divira Hawawu. ");
INSERT INTO mfm_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","Aˈyi Adamu ngǝ shatan nggutana mai, ama mala nyi nga ji nggutana, ba ji ɗa ndǝr bikau. ");
INSERT INTO mfm_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","Ama mathlǝkǝˈyi ndu nda uya mbǝɗau lagur ya wazha, ma ndǝ sǝn dumwa ǝnga mbǝrsa, ǝnga yiwudzau, ǝnga cicikur daɓǝ ǝnga tsǝrpǝr kǝr. ");
INSERT INTO mfm_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","Kǝja ndǝr kǝra nja fǝr kǝr ǝni, kalar ndǝra vǝr cim ja nggya ndǝr tǝɗǝmwa anǝ njir nu, a cimǝr ja thlǝr kǝra mǝnahǝu. ");
INSERT INTO mfm_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","Ndǝr tǝɗǝmwa ja nggya ndǝra gǝra ǝnga sǝra nja vazǝ nyi ni a dumwar nji, ja ɗa ndǝr mala zǝmǝu, ndǝr ɓǝlar kǝrnyi, ndǝr ɗǝfu mǝnahǝu, ndǝra ǝnga hangǝkal mǝnahǝu, ndǝr dlǝwu mǝthlǝpi, ndǝra wu sǝn highiɓau gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","Najaka ndau aˈyi ja ndǝr nyi ǝnga padlǝ mai, ǝnga aˈyi ja ndǝr gal pa mai, ama ndǝ hangǝkal, ǝnga tsu aˈyi ndǝr tsǝtsǝbwari mai, ǝtsu aˈyi ndǝr yiwu gǝnna gagaɗǝ mai. ");
INSERT INTO mfm_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","Pakatǝu kǝl ji ɗa ndǝra sǝn sǝɓiya ki nyi mǝnahǝu, ju mǝliya wazha nyi nda mǝl sǝra ju na ǝnga nda gǝnggǝr nyi sǝli wu kalar lagu. ");
INSERT INTO mfm_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","(Ma ndau aˈyi a sǝn ǝnggǝra ja ɓau ǝnga njir ki nyi mai, abari nga ja sǝn ɓǝ ǝnga njir nu Hyala?) ");
INSERT INTO mfm_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","A sara ja ɗa ndǝra dzǝgwa ɗa ndǝr nu Hyal mai, ara ɓwadzau a nda sǝwa nyi ba nja mǝliya nyi numa kǝra nji mǝliya nyi anǝ shatan. ");
INSERT INTO mfm_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","Ndǝr tǝɗǝmwa ja ɗa ndǝra nja ndǝr mǝnahǝu ar kǝra ja wu mwar njira aˈyi njir nu mai, a sara ɗa sǝr sǝli, ǝnga ja tǝɗau a gu lǝbam shatan. ");
INSERT INTO mfm_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","Abangǝ tsu njir dlǝwa pubu, pakatǝ nda nggya njira nju gǝnggǝr nda sǝli, aˈyi njir pǝ miya mǝmǝthlu mai, ǝnga tsu aˈyi njir nyi ǝnga padlǝ mai, ǝnga njir suna gǝnna mai. ");
INSERT INTO mfm_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","A mbari anǝ nda, nda sǝɓiya jirkura mbǝrsar nda ǝnga kǝr papalǝu. ");
INSERT INTO mfm_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","Sǝ tanggǝrma nja dzǝbiya nda, ǝnggau, ma nja ˈyi thlǝwa nda ǝnga vanyi vazǝ mai, bǝgǝ nda ɗa njir dlǝwa pubu. ");
INSERT INTO mfm_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","Abangǝ tsu mathlǝkǝˈyir nda, nda ɗa njira nju gǝnggǝr nda sǝli, aˈyi njir ndǝr nǝ gwaɗǝvi mai, ama njira tsǝrpǝri kǝrnda, ǝnga wu kalar sau, nja fǝr kǝr ǝnga nda. ");
INSERT INTO mfm_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","Ndǝr dlǝwa pubu kǝl ji ɗa ndǝr mala zǝmǝu, ǝnga ju sǝn sǝɓiya wazha nyi ǝnga njir ki nyi mǝnahǝu. ");
INSERT INTO mfm_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","Njir dlǝwa pubu kǝra wu mǝl thlǝr nda mǝnahǝu, ndu uya thlǝmǝ mǝnahǝu anǝ kǝrnda, ndu ndǝr gǝra hivǝr ar kǝra mbǝrsar nda wu Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","Ar pǝci kǝra ya vǝr tsǝfǝ cama tsǝtsǝfǝ kau a nda anǝ ngau, yu fǝ ɗǝfu abǝr yu shili ǝgya gau a sǝkari kushu. ");
INSERT INTO mfm_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","Ama ma aˈyi yi shili kaɗǝ mai, ga nggya ǝnga sǝni ǝnggǝra mǝna kyaga nggya wu pama nji gǝ Hyal, kǝra ca ngǝ daɓǝ njir nu nǝ Hyal mbǝmbǝɗau, ca ngǝ shimal ǝnga fǝ hya jirkur. ");
INSERT INTO mfm_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","Aˈyi ǝnga tǝkǝkǝr mai, sǝ kǝ mǝna vǝr nu kau dǝgal nga nyi: Kǝrsiti cabiya kǝrnyi wu kumǝr dzau, Mambǝl cabiya nyi ndǝr jiri. Waladiˈyar lari nyi, nji tǝtǝlna ndǝr nyi wu duniya. A hǝnggǝri nji ǝnga ja wu duniya patǝu, Hyal hǝri nyi a dǝmǝlmau wu kadakadarkur. ");
INSERT INTO mfm_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","Kǝja Mambǝl Cicau a vǝr ca ar babal abǝr wu kuɗiyar pǝci, alenyi nju nda sǝna mbǝrsar nda ar viya njir nu ba nda hǝr hangǝkala nda a ndǝgya mambǝl ngguta vi ǝnga highiɓǝ nǝ fati nǝ mambǝl ɗǝmwaˈyiˈyar. ");
INSERT INTO mfm_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","Highiɓǝ kau wu nda hyaˈari lagur nji batal njir thla fati kǝra ɗahǝ ɗǝfuwa nda a tǝri, ǝnggǝr sǝra nji hilina ǝnga liyangǝ kwakwaɗǝu. ");
INSERT INTO mfm_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","Culi nji kau ndu ka hǝ dzau, ǝnga tsu sǝm alenyi sǝr sǝm. Ətsu, Hyal ngǝ mǝliya sǝr sǝm kau aga njira mbǝrsa ǝnga tsu njira wu sǝnbiya jirkura nyi nda dlǝwuri ǝnga usaku. ");
INSERT INTO mfm_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","Arya kalar sǝra Hyal mǝliya mǝnahǝ nga nyi, ǝnga tsu a sara nja piyari sǝ mai ma a dlǝwuri nji ǝnga usaku, ");
INSERT INTO mfm_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","ara a cinar nji lagur ndǝr Hyal ǝnga lagur ndǝr ǝnga Hyal. ");
INSERT INTO mfm_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","Ma ga highiɓǝr sǝˈyar kau anǝ wazha ama, gu nda ɗa ndǝr mǝl thlǝr Kǝrsiti Yesu kǝra mǝnahǝu. Nagǝ ndǝra hau wu ndǝr kau nǝ mbǝrsa ǝnga tsu highiɓǝ nǝ mǝnahǝu kǝra ga vǝr nu baˈanǝ ǝshina kau. ");
INSERT INTO mfm_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","Ga sara ɓukǝr ngau ǝnga kǝbǝkwatǝu ǝnga pumungutu gǝra kǝr, kǝra gǝra ǝnga dlǝwa dzau. Ama ga hwathliya kǝrngau ga nggya ǝnga ɗǝfu nǝ Hyalkur. ");
INSERT INTO mfm_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","Alaga kau, hwathlǝ dzǝ nǝ kumǝr dzau aˈyi ǝnga akkǝri tsapǝ mai, ama ga nggya ǝnga ɗǝfu nǝ Hyalkur ca nga ndiya ǝnga akkǝri wu kalar lagu. Ara najakau, wu shili ǝnga barka kabangǝkau ba ǝnga tsu nggya kǝra wu nda shili. ");
INSERT INTO mfm_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","Najakǝ ngǝ ndǝr kǝra nja fǝr kǝr ni, ǝnga tsu a tǝkǝri nja dlǝwuri ǝnga huɗǝ zǝmǝu. ");
INSERT INTO mfm_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","Aga kau ˈya vǝr nǝrdzau, ˈya vǝr mǝl thlǝr ara a fuwar ˈya ɗǝfuwa ˈya wu Hyal kǝra ǝnga pi, ndǝra ca ngǝ ndǝr mbǝɗa patǝr nji, njira ma a hǝnggǝr nda jiri ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","Ga highiɓǝ sǝˈyar kau, ǝnga ga nar nyi anǝ kalar ndau ja mǝl sǝra gu na. ");
INSERT INTO mfm_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","A sara ga hǝnggǝri nda diɗana ngau ara nagǝ zǝr baduwari mai, ama ga cabiya kǝrngau sǝr highiɓau anǝ njir nu lagur ndǝr ngau, ǝnga nggyabiya ngau, ǝnga yiwudzǝ ngau, ǝnga mbǝrsa ngau, ba ǝnga tsu nggya cici ngau. ");
INSERT INTO mfm_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","Kadivira ya shili, ga dumwa ǝnga jiga ndǝr Hyal kǝra tsǝtsǝfau anǝ ndapi, ǝnga tǝtǝlna ndǝr Hyal ba ǝnga highiɓǝ tsu. ");
INSERT INTO mfm_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","A sara ga piyari barka nǝ sǝn sau kǝra Hyal nǝ ngǝ kǝ mai, kǝra ji nǝ ngau lagur cama sara ara Hyal ar pǝci kǝra daɓǝ dzǝr njira nggurǝm fǝnggǝr ngǝ tsi. ");
INSERT INTO mfm_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","Ga mǝl sǝˈyar kau ǝnga jirkur, ga lǝr kǝrngau papatǝu anǝ nda, aga kalar ndau ja lari ǝnggǝra ga vǝr cakau. ");
INSERT INTO mfm_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","Ga ɓǝlar kǝrngau ǝnga highiɓǝ ngau gagaɗau. Ga dumwa ǝnga mǝl thlǝr ˈyar kau ǝnga huɗǝ zǝmǝu, ara ma gǝ mǝl abangau, gu nda mbǝɗana kǝrngau ǝnga njira wu sǝhimi ngau. ");
INSERT INTO mfm_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","A sara ga kughi anǝ ndǝra dǝgal a ndiya ngau ǝnga huɗǝ ndzǝndzǝ mai, ama ga ndǝr anǝ nyi ǝnggǝr anǝ dǝngau. Wazha baduwari tsu ga kughiya nda ǝnggǝr anǝ zamǝ ngau. ");
INSERT INTO mfm_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","Anǝ mathlǝkǝˈyi hahal tsu ga ndǝr ǝnggǝr anǝ mǝ ngau, anǝ kuˈyi tsu ga ndǝr ǝnggǝr anǝ kwamǝ ngau, ǝnga cicikur ɗǝfu nǝ jiri. ");
INSERT INTO mfm_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","Ga lǝri dǝgalkur anǝ mathlǝkǝˈyi tǝsal, njira ǝnga jiri njir dlǝwa nda aˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","Ama ma mala tǝsal aˈyi ǝnga wazha ǝnga ciji, bǝgǝ nda dzǝguya highiɓǝri sǝra sǝr nur nda na aga nda mǝl anǝ njir kir nda. Lagu kau nga ndu nda kina anǝ njir yar nda dlǝwa dzau kǝra ndǝ uya sara ara nda. Culi kau, mǝnahǝu nga nyi anǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","Mala tǝsal nǝ jijiri, kǝra ndǝr dlǝwa nyi aˈyi mai, ju fiya ɗǝfuwa ja wu Hyal, ba ja dumwa ǝnga ndǝr ǝnga Hyal ju gal dlǝwa dzau sara ara ja vuˈyi ǝnga pǝci. ");
INSERT INTO mfm_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","Ama mala tǝsal kǝra wu nggya aga sǝm mǝsahǝkur wacu, tǝtǝ nga ja, alaga kǝ tsu ja ˈyi ǝnga pi kau. ");
INSERT INTO mfm_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","Ga nǝ nyi najaka cama anǝ njir nu, aga nda ɗa njira gǝra ǝnga sǝr vazau wu mwar nji. ");
INSERT INTO mfm_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","Kalar ndǝra gǝra sǝn sǝmǝna nji nyi, ma na ma njir ki nyi, a ɓǝlnar ja mbǝrsa nyi, najaka ndau a ndiyar ja ndǝra gǝra ǝnga mbǝrsa ǝnga ɗǝmwaˈyu. ");
INSERT INTO mfm_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","Mala tǝsal aˈyi kari nja jigǝwa nyi pathlǝu wu pama mathlǝkǝˈyi tǝsal mai, kǝl ma fa nyi a ndiyari fa kwakumunyi Ba tsu ar pǝci kǝra sal nyi tsu ǝnga pi a nggyar ja mala tsapǝu anǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","Ənga nju sǝn nyi ǝnga sǝr mǝla ja mǝnahǝu. Ənga mala kǝra hǝri wazha nyi wu lagu mǝnahǝu, ǝnga ju dlǝwu mǝthlǝpi. Ənga ju mǝl thlǝr anǝ nji cici gǝ Hyal, ba tsu ju dlǝwa njira wu yiwu dlǝwa dzau. Ənga ji lǝri kǝrnyi aga mǝl kalar sǝra mǝnahǝu. ");
INSERT INTO mfm_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","Ama mathlǝkǝˈyi tǝsal kǝra tsu yiɗǝɗǝu, nja jiga nda wu nji kǝ mai. Arya ar pǝci kǝra cim nǝ kumǝr dzau tǝkǝbiya hangǝkala nda ǝnga Kǝrsiti, ba nda gal lagur hǝ sal. ");
INSERT INTO mfm_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","Lagu kau nga ndu dla ǝnga numa anǝ kǝrnda, ara a ɓǝlnar nda alkawal nǝ tanggǝrma. ");
INSERT INTO mfm_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","Aˈyi kǝ ma waci mai, ama ndu highiɓǝri nggya nggashu, ǝnga ndu ɓǝɓau a ndu ki nji. Aˈyi kǝ waci mai, ama daɓǝ ǝnga na ndau, ǝnga ndu ndora ba na sǝ kǝra gǝra kyau. ");
INSERT INTO mfm_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","Cimǝ ɗa, mathlǝkǝˈyi tǝsal kǝra tsu nda yiɗǝɗǝ nda hǝr sal, nda ya wazha, nda sǝɓǝ kir nda. Ara nda sara nǝ nyi anǝ dawar mǝn lagu nǝ ndǝr ɗǝmwaˈyi ar kǝra mǝn. ");
INSERT INTO mfm_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","Ara alenyi mathlǝkǝˈyi tǝsal nǝr nda a shar nda tsu kaɗǝu, nda vǝr nu shatan. ");
INSERT INTO mfm_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","Ma mala kǝra ǝnga mbǝrsa aˈyi ǝnga mathlǝkǝˈyi tǝsal wu ki nyi, ja dlǝwar nda, a sara nja nǝ nyi ɓwaɓwatǝ anǝ njir nu. Lagu kau ngǝ njir nu Yesu wu nda uya lagur dlǝwa njira mathlǝkǝˈyi tǝsal nǝ jijiri. ");
INSERT INTO mfm_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","Njira nggurǝm nǝ njir nu kǝra wu mǝl thlǝr nda mǝnahǝu, a kyau nja gǝnggǝr nda sǝli gagaɗau, ma na njira thlǝr nda ca ngǝ tǝtǝlna ndǝr Hyal ǝnga highiɓau. ");
INSERT INTO mfm_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","Ara ndǝr Hyal kǝra tsǝtsǝfǝ nana, “A sara nja fuwa njuwangǝ wu miya thla zǝwa ar pǝci kǝra ja vǝr mǝl thlǝr mai,” ǝnga tsu “Ndǝr mǝl thlǝr a kiri nja nǝ nyi sǝra nǝ nyi.” ");
INSERT INTO mfm_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","A sara ga sǝhimi ǝnga vazǝ ar kǝra ndǝ dǝgal nǝ njir nu mai, kǝl ma gǝ nggari wu miya sakida a ɗa mǝthlǝ ǝnga alaga makǝru. ");
INSERT INTO mfm_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","Njira mǝliya bikau, ga kughiya nda ar babal, aga alenyi nja gǝrahau. ");
INSERT INTO mfm_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","Wu mwar Hyal ǝnga Kǝrsiti Yesu ǝnga waladiˈyar cacaɗau, ya vǝr kughi anǝ ngau, ga nu highiɓǝˈyar kau gǝra ǝnga tazhira abǝr gu yiwu vanyi ndau a ndiya alenyi nji. ");
INSERT INTO mfm_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","A sara ga kusa ǝnga fǝ tsi nǝ barka ar kǝra ndǝ mai. Ətsu a sara ga fuwa kǝrngau a gu bikǝ nǝ alenyi nji mai. Ama ga ɓǝlar kǝrngau cicau. ");
INSERT INTO mfm_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","A sara ga dumwa ǝnga sa ˈyimi hyalagǝu waci mai, ama ga tuwari ˈyimir wur inabi kǝra mwushu kushu ara sǝhuɗǝ ngǝ kau, ǝnga tsu ara hwahwafǝkur ngǝ kau. ");
INSERT INTO mfm_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","Bikǝ nǝ alenyi nji ar babal nga nda, kǝra kalar ndu sǝni sǝra nda a gwa divira nja thlana nda numa. Ama bikǝr alenyi nji ɗǝɗǝwa nga nda kǝl wu yukuɗǝ nga ndu nda biyar babal. ");
INSERT INTO mfm_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","Abangǝ tsu thlǝr kǝra mǝnahǝu ar babal nga nda, alaga ma aˈyi nda ar babal mai, nandǝ wu sǝn ɗǝwanakǝr mai. ");
INSERT INTO mfm_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","Patǝr njira vǝr sǝm mafakur, nda kyaga lǝri dǝgalkur anǝ tarkir nda kǝra tsaˈa, ara nja sara ndǝr nǝ diɗa anǝ thlǝmǝr Hyal nga highiɓǝr mǝn. ");
INSERT INTO mfm_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","A sara mafaˈyar kǝra tarkir nda njir nu Yesu ngau, nda nggǝl ara lǝ dǝgalkur anǝ nda, ara nanda zamǝr nda mai. Ar viya kau, kuji kǝ mafaˈyar kau ɓǝra cakǝri mbiya ɗǝfu nda mǝl thlǝr nda mǝnahǝu ara tarkir nda njira wu nu Yesu ngau, njira wu uya barka sara wu thlǝr nda ǝnga tsu tarkir nda wu yiwu nda. Sǝˈyar kau nga gu highiɓau ǝnga ga tsǝtsǝku ɗǝfuwa nda aga nda mǝl. ");
INSERT INTO mfm_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","Kalar ndǝra wu highiɓau, highiɓǝ nǝ fati, ǝnga aˈyi ju hǝnggǝri ǝnga highiɓǝ nǝ mǝnahǝ nǝ Thlagǝr mǝn Yesu Kǝrsiti ǝnga highiɓǝ nǝ Hyalkur mai, ");
INSERT INTO mfm_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","naja ndǝr ɓwasau ǝnga ndǝra gǝra sǝn sau. Naja tsu ju nggya ǝnga ɗǝfu nǝ ɗǝmwaˈyikur ǝnga ju yiwu kǝpal ǝnga shasha ndǝr ar kǝra ndǝr ˈyar, kǝra wu shili ǝnga shishikur, ǝnga maɗǝkur, ǝnga nggǝl ndau ba ǝnga ɗǝnga ɗǝmwaˈyi kǝra gǝra kǝr, ");
INSERT INTO mfm_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","ǝnga kǝpal gangǝ ǝnga njira ɗǝngar nda a ɗari nǝ kurthlǝu, njira jirkur a piyari ndari. Nanda ngǝ njira wu nggani abǝr nu Hyal ca ngu shili ǝnga uya gǝnna. ");
INSERT INTO mfm_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","Gǝra ǝnga tǝkǝkǝr! Uya akkǝri aˈyi gangǝ gagaɗau anǝ njira wu hivǝr Hyal ǝnga huɗǝ pipida ǝnga sǝra ara nda. ");
INSERT INTO mfm_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","Arya sǝ aˈyi mǝn shili ni wu duniya kǝ mai, ǝnga sǝ aˈyi mǝna sǝn biya ni tsu mai. ");
INSERT INTO mfm_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","Ama ma aˈyi mǝn ǝnga sǝr sǝm ǝnga kar ha, kǝ ma a citǝri. ");
INSERT INTO mfm_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","Ama njira wu yiwu nda ɗa njir bǝrba ndu gwu dzau ǝnga lǝbam shatan. Ndu yiwu sǝ dzadza ǝnga suna suna pamǝpamǝ nǝ kurthlǝu, ca ngǝ dla ǝnga sǝ ndzǝndzau ǝnga ndǝ sanakǝr. ");
INSERT INTO mfm_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","Arya yiwu gǝnna naja ngǝ nggilang ǝnga patǝr sǝra ɗǝmwaˈyu. A vǝr gal gǝnna ǝnga kusa ngǝ alenyi nji tana lagur mbǝrsar nda, kǝlta ndǝ fuwa kǝrnda wu huɗǝ ndzǝndzǝ gangǝ gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","Ama nagau, ndǝ nǝ Hyal, ga hwinakǝr naɗǝu sara ara sǝˈyar kǝ patǝu. Nagǝ tsu ga fuwa kǝr wu gal sǝra mǝnahǝu, ǝnga nǝ Hyalkur, ǝnga mbǝrsa, ǝnga yiwudzau, ǝnga sǝsǝˈwuri sau ba ǝnga hangǝkalkur. ");
INSERT INTO mfm_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","Ga pana pa nǝ mǝnahǝu, ca ngǝ pa nǝ mbǝrsa. Ga sǝɓiya pi, pi gǝra kuɗau kǝra ca ngǝ Hyal ngga ngau aga nyi ar pǝci kǝra gǝ nana ǝnggǝra gǝ mbǝrsa a ndumwar sakida gangǝ gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","Yu kughiya ngau wu mwar Hyal kǝra nǝ nyi pi anǝ kalar sau, ǝnga Kǝrsiti Yesu, kǝra ar pǝci kǝra ja vǝr lǝ sakida wu mwar tǝl Buntusu Bilatusu ji nana ndǝr kǝra jiri, ");
INSERT INTO mfm_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","abǝr ga sǝɓiya sǝ kǝ yi nar ngǝ kau gǝra ǝnga sǝr deɓa ǝnga sǝra nja nggǝliya kǝl pǝci kǝra Thlagǝr mǝn Yesu Kǝrsiti shili ari. ");
INSERT INTO mfm_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","Naja ngǝ Hyal wu nda hǝri a shili wu pǝci nǝ kǝrnyi. Hyal kǝ ngǝ ndǝr barka ǝnga naja ngǝ ndǝra ndiya ǝnga dǝnama patǝu, naja ngǝ tǝl nǝ tǝtǝl ǝnga Thlagǝr thlagǝˈyar. ");
INSERT INTO mfm_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","Naja wacu ngǝ gǝra tau, ǝnga ju nggya wu mbǝmbǝl kǝra ndǝr sǝn lǝhǝri aˈyi mai. Naja nga nji gǝra saya lari ǝnga ndǝr sǝn lari nyi aˈyi mai. Anǝ nyi ngǝ kadakadarkur ǝnga tǝlkur baˈanuwa. Aminu. ");
INSERT INTO mfm_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","Ga nar nyi anǝ njira ǝnga gǝnna wu duniya kabangǝkau, abǝr a sara nda ɓwadzǝ nǝ mai, ǝnga nda sara fǝ ɗǝfuwa nda ar gǝnna kǝra wu ɓǝliya sar mai. Ama nda fǝr ɗǝfuwa nda anǝ Hyal ndǝra wu nǝ mǝn kalar sau ǝnga tsi bangǝu aga nggyar mǝna ɗa mǝsahǝu. ");
INSERT INTO mfm_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","Ga nar nda aga nda mǝl sǝra mǝnahǝu, ǝnga nda cakǝri mǝl thlǝr kǝra mǝnahǝu, ǝnga nda pahǝna tsa nda aga dlǝwa kuvwar nda. ");
INSERT INTO mfm_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","Lagu kau ǝnga ndu nda fiya akkǝrir nda a dǝmǝlmau kǝra wu nda ɗa ǝnggǝr sǝr fǝ hyi kǝra ndu nda nggya ar kǝri wu fa kǝra wu shili kau, aga nda nda uya pi kǝra ca ngǝ pi nǝ jijiri. ");
INSERT INTO mfm_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","Timathlawusu, ga ɓǝlari sǝra Hyal fuwa wu tsa gau. Ga hǝbiya kǝrngau sara wu ndǝr kǝra papatagǝu nǝ diɗa ndǝr Hyal, ǝnga highiɓau kǝra nju nggani abǝr sǝnbiya sǝ ngau ama ndǝr fati ngau. ");
INSERT INTO mfm_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","Lagur nu najaka highiɓau, ngǝ alenyi nji tǝkǝbiya dzau ǝnga mbǝrsar nda. Bǝgǝ mayiwakur nǝ Hyal a nggya ǝnga hyi.");
INSERT INTO mfm_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","Cama tsǝtsǝfau sara ara Bulusu, Cama sǝsǝ nǝ Kǝrsiti Yesu kǝra Hyal caɗǝbiya. Hyal ngǝ sǝwa ɗa aga ya nana ndǝr ar kǝra alkawal nǝ pi kǝra wu Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","A nda nǝ Timathlawusu, zǝr huɗa yau. Mayiwakur, ǝnga tǝhuɗǝu, ba jamǝkur sara ara Hyal Tada ǝnga Kǝrsiti Yesu Thlagǝr mǝna nggya ǝnga gau. ");
INSERT INTO mfm_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","Yu usaku anǝ Hyal, kǝra ya vǝr sǝm mafakur anǝ nyi, ǝnggǝr kǝra ǝji ɗaˈyar sara vǝr mǝl. Yu sǝm mafakur anǝ nyi ǝnga kǝr papalǝu. Ya vǝr ɗǝnga ngau cumu ma yu ndǝr ǝnga Hyal vuˈyi ǝnga pǝci. ");
INSERT INTO mfm_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","Ma yi ɗǝngari ǝnga pǝ sǝlǝm ngau, ba ya cim aga ya lar ngau, aga ya nyabiya dzau ǝnga huɗǝ pipida gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","Yi ɗǝngari ǝnga mbǝrsa ngau nǝ jijiri, kǝra aˈyi ara ǝji ngǝ mala Loyisu ba ǝnga mǝ ngau Yunisu. A sǝn yau abǝr mbǝrsa kau aˈyi ara gǝ tsu. ");
INSERT INTO mfm_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","Agabangau, ca ngǝ sǝra ɗa yu ɗǝngari ngau aga ga mbǝbiya uˈu wu barka nǝ Mambǝl kǝra Hyal nǝ ngau ar pǝci kǝra yi fǝnggǝr ngǝ tsi nǝ barka. ");
INSERT INTO mfm_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","Ara Hyal aˈyi nǝ mǝn mambǝl nǝ hivǝr mai, ama mambǝl nǝ dǝnama, ǝnga nǝ yiwudzau, ba nǝ kǝkǝya kǝr tsu. ");
INSERT INTO mfm_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","Agabangau, ga sara sǝli ara lǝ sakida ar kǝra Thlagǝr mǝn mai, ǝnga tsu ga sara sǝli ar kǝra yau ndǝra nji fuwa wu fursǝna arya ja mai. Ama ga daɓǝri kǝr ǝnga yau wu sa ɓwaɓwatǝ, arya ndǝshigu mǝsahǝu, kǝra wu shili wu lagu dǝnama nǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","Naja ngǝ mbǝɗana mǝn ǝnga ji ngga mǝn aga mǝna nggya cicau. Najaka ngga aˈyi arya vanyi sǝ mǝnahǝu kǝra mǝn mǝliya mai, ama ara sǝra ji mbiya wu mayiwakur nyi. Najaka mayiwakur, kǝra Hyal nǝ mǝn ngau lagu Kǝrsiti Yesu kadivira duniya dzǝguya dzau. ");
INSERT INTO mfm_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","Ama kabangǝkau najaka mayiwakur a cabiyar dzau lagur shida nǝ ndǝr mbǝɗa mǝn, Kǝrsiti Yesu. Naja ngǝ ndǝra sana liya tau ǝnga ji nǝ mǝn pi, pi nǝ gǝra kuɗau lagur ndǝshigu. ");
INSERT INTO mfm_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","Wu lagu ndǝshigu kau ngǝ Hyal caɗǝbiya ɗa aga ya ɗa ndǝr tǝtǝlna ndǝr Hyal ǝnga cama sǝsau ba ǝnga malǝmǝ tsu. ");
INSERT INTO mfm_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","Ca ngǝ sǝra ɗa ya vǝr sa ɓwaɓwatǝ kǝra ya vǝr sa kau. Ama alaga abangau sǝli wu tǝ ɗa mai, ara a sǝn yau ndǝra yi hǝnggǝri ǝnga ja, ba ǝnga gǝra kǝpal ju sǝn ɓǝlari sǝra ji fuwa wu tsa yau baˈa shili ar pǝci ta. ");
INSERT INTO mfm_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","Sǝra gǝ nggari sara ara yau, ga sǝɓiya ar viya highiɓǝ nǝ tsapǝu. Ga mǝl abangau wu mbǝrsa ǝnga yiwudzau wu Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","Ga sǝɓiya ndǝshigu kǝ ɓaɓalu kǝra Hyal fuwa wu tsa gau, ǝnga tsu ga sǝɓiya ǝnga dlǝwa dzau nǝ Mambǝl Cicau kǝra a vǝr nggya wu mǝn. ");
INSERT INTO mfm_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","Gu sǝn abǝr kalar ndau wu ˈyiˈyir Asǝya a piyar ɗa ri, patǝ ǝkkǝˈyi Fejilusu ǝnga Hamojinisu. ");
INSERT INTO mfm_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","Bǝgǝ Thlagǝu a canǝ nyi tǝhuɗǝu anǝ njir ki Onesiforosu, arya cimǝu ju tsǝtsǝkuri ɗǝfuwa yau, ǝnga naji sǝli ara nayi ndǝr fursǝna mai. ");
INSERT INTO mfm_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","Ar viya abangau, ǝnggǝra ji shili wu Roma, ba ji gu gal ɗa ɓakǝɓakǝu kǝlta ji thlǝwa ɗa. ");
INSERT INTO mfm_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","Bǝgǝ Thlagǝu a canǝ nyi tǝhuɗǝu gagaɗau ar pǝci ta, pǝci kǝra Yesu ɓǝra nda sha shida aga numa. A sǝnǝr hyi culi vala dzǝ pamǝpamǝ kǝra ji nǝ ɗa ar pǝci kǝra yu Afisa. ");
INSERT INTO mfm_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","Nagǝ tsu zǝr ɗa, ga ɗa nǝnau lagu mayiwakur nǝ Hyal kǝra aˈyi wu Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","Patǝr sǝra gǝ nggari ya vǝr na wu mwar sakida gangǝu, ga highiɓǝr nyi anǝ njira nju fiyafǝ ǝnga nda aga nda highiɓǝr anǝ alenyi nji. ");
INSERT INTO mfm_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","Ar viya soja tsapǝu nǝ Kǝrsiti Yesu, ga sǝsǝˈwuri ɓwaɓwatǝ ǝnga ˈya. ");
INSERT INTO mfm_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","Soja kǝra a vǝr mǝl thlǝr nyi aˈyi a kyaga fuwa kǝrnyi wu vanyi thlǝr mai, ama wu ɗǝfuwa ja, ja pina huɗa ndǝra dǝgal a dar kǝra ja. ");
INSERT INTO mfm_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","Abangǝ tsu, lagur pǝra pǝra nǝ hwi, ndǝr sǝmku nuba nǝ hwi aˈyi mai, kǝl ma ji hwi tsaˈa ǝnga sǝr ɓǝla nǝ hwiya nyi na. ");
INSERT INTO mfm_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","Ndǝr zǝwa ǝnga jiri, naja nga kyaga dzǝguya sǝm sǝr huɗa fa nyi nǝ tanggǝrma. ");
INSERT INTO mfm_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","Ga ɗǝnga sǝˈyar kǝ ya vǝr na kau, arya Hyal ngu nda nǝ ngǝ nggabiya nda patǝu. ");
INSERT INTO mfm_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","Ga ɗǝngari ǝnga Yesu Kǝrsiti, sara wu culi gǝ Dawuda, ndǝra hyaˈari sara vir tau. Najakǝ ngǝ ndǝshigu ɗa. ");
INSERT INTO mfm_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","Arya ndǝshigu kau ǝnga ya vǝr sa ɓwaɓwatǝu, baˈanǝ shili ar mba ar sǝˈyi liyangǝ dǝgǝ ndǝ batal. Ama ndǝr sǝn mbiya ndǝr Hyal aˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","Agabangǝ yi sǝsǝˈwuri sǝˈyar kǝ patǝ arya nji ɗǝɗǝm njir nu Yesu, aga nanda tsu nda uya mbǝɗau lagur Kǝrsiti Yesu ǝnga nda gu kadakadarkur nǝ baˈanuwa. ");
INSERT INTO mfm_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","Kǝja ndǝr kǝra nja fiyafǝ ǝni. Ma mǝn tǝ ǝnga ja, mǝnu nda nggya ǝnga pi ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","Ma mǝn sǝsǝˈwuri ɓwaɓwatǝu arya ja, mǝnu nda sǝm tǝlkur ǝnga ja. Ma mǝn kǝpalna sǝnǝ nyi, naja ma ju nda kǝpalna sǝnǝ mǝn tsu. ");
INSERT INTO mfm_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","Ma namǝn ngǝ nji kǝra ji gǝra fiyafǝ ni, ama ju nggya ndǝra mǝnu fiyafǝ ni, ara naja aˈyi ndǝr miya mǝthlǝ mai. ");
INSERT INTO mfm_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","Ga dumwa ǝnga ɗǝngar nda sǝˈyar kau. Ga kughiya nda wu mwar Hyal ar kǝra shasha ndǝr abǝr aˈyi ǝnga akkǝri mai, ama kǝl ndza njira wu sǝhimi nda wacu. ");
INSERT INTO mfm_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","Ga nǝrdzau aga ga cabiya kǝrngau anǝ Hyal ar viya ndǝr mǝl thlǝr kǝra Hyal dlǝwuri. Ga ɗa ndǝr mǝl thlǝr kǝra wu sǝn hǝbiya kǝrnyi sara wu sǝli wu mwar Hyal. Ga ɗa ndǝra wu sǝn highiɓǝri sǝra jiri. ");
INSERT INTO mfm_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","Ga tǝkǝbiya dzau ǝnga ndǝr papatagǝu nǝ diɗa ndǝr Hyal, ara njira fuwa kǝrnda a gwagwa, ndu dumwa ǝnga maˈyi naɗǝu ǝnga gǝra hivǝr Hyal. ");
INSERT INTO mfm_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","Highiɓǝr nda wu tǝtǝlnakǝr ǝnggǝr gyakǝma. Wu pama nda ngǝ culi nji ǝnggǝr Himaniyasu ǝnga Fǝlayitusu, ");
INSERT INTO mfm_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","njira piyari lagu jiri. Ndu na abǝr hyaˈari sara vir tau a tǝrabiyari, lagu kau nga ndu ndzana mbǝrsa nǝ alenyi nji. ");
INSERT INTO mfm_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","Alaga abangau fǝ hyi ɓaɓal nǝ Hyal a taˈyiri baˈanuwa. Hyal ǝnga kǝrnyi a fǝri mǝtsamǝ ar kǝra fǝ hyi ɓaɓal nyi kau, kǝra wu na, abǝr, “Thlagǝu wu sǝni njira nǝ nyi ngau,” ǝnga “Kalar ndǝra wu na abǝr naja nǝ Thlagǝu, kǝl ji piyari mǝl sǝra ɗǝmwaˈyu.” ");
INSERT INTO mfm_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","Wu ki dǝgal ǝhya sǝm sau aˈyi kǝra nji mǝliya sara wu ǝndzau ǝnga thladla, alenyi tsu sara wu wu, ǝnga sara wu ˈyiˈyi tsǝkwaɓǝu. Alenyi nǝ mǝl thlǝr mǝnahǝu ǝnga alenyi tsu nǝ thlǝr kǝra didiɗi. ");
INSERT INTO mfm_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","Ma ndǝra cina kǝrnyi sara ara sǝ didiɗiˈyar kau, ju ɗa kar thlǝr kǝra mǝnahǝu, kǝra cicau, kǝra ǝnga vala dzǝ anǝ thlagǝ nyi, kǝra nji mǝliya cipǝu aga mǝl kalar thlǝr kǝra tsapǝu. ");
INSERT INTO mfm_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","Ga hwinakǝr naɗǝu sara ara sǝra wu dla ǝnga suna nǝ sǝsukur nǝ wazhakur. Ga fuwa kǝr wu gal sǝra wu dla ǝnga mǝnahǝkur, ǝnga mbǝrsa, ǝnga yiwudzau ba ǝnga jamǝkur daɓǝ ǝnga njira wu ngga thlǝmǝr Thlagǝu sara wu ɗǝfu pǝrtǝu. ");
INSERT INTO mfm_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","A sara sa daɓǝr hyi ǝnga kǝpal nǝ kurthlǝ ǝnga ndǝr didiɗi mai, ara wu sǝni gau abǝr culi kau a dla ǝnga bwari wacu. ");
INSERT INTO mfm_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","Aˈya kyaga mafa Hyal ja ɗa ndǝr bwari mai, ama ja kyaga ɗa ndǝr tǝhuɗǝu ǝgya kalar ndau, ǝnga ja ɗa ndǝr sǝn highiɓau ǝnga ndǝra gǝra ndzǝ ɗǝfu. ");
INSERT INTO mfm_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","Njira wu kǝpal ǝnga ja, kǝl ja ndǝr anǝ nda ǝnga hangǝkal, tara ba Hyal a nǝ nda lagu nǝ tubi nda sǝnbiya lagu nǝ jiri. ");
INSERT INTO mfm_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","Aga nda daɓaga sha a shili wu hangǝkalǝr nda, aga nda biya sara wu lǝbam nǝ shatan, ndǝra mbar nda aga nda mǝl sǝra ju yiwu. ");
INSERT INTO mfm_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","Ama ga kyaga sǝni, abǝr ar pǝcir kuɗiyar duniya, nggyabiya wu nda ɗa dzadzau gagaɗau. ");
INSERT INTO mfm_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","Ara nju nda ɗa njir yiwu kǝrnda, ǝnga njir yiwu gǝnna, ǝnga njir fǝ kǝrnda, ǝnga njir ɓwadzau, ǝnga njir nggǝl nji, ǝnga njira gǝra gǝnggǝr nyi sǝli anǝ njir yar nda, ǝnga njira gǝra na usaku, ba ǝnga njira gǝra hivǝr Hyal. ");
INSERT INTO mfm_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","Ənga tsu njira gǝra yiwudzau, ǝnga njir sǝɓǝ ndǝ wu ta, ǝnga njir ndza thlǝmǝr ndau, ǝnga njira gǝra sǝn ɓǝlar kǝrnda, ǝnga nji shishi, ba ǝnga njira gǝra yiwu sǝ mǝnahǝu. ");
INSERT INTO mfm_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","Ətsu ndu ɗa njir thlǝ hya ndau, ǝnga njir mǝl sǝ ǝnga kusa, ǝnga njira nyabiya dzau ǝnga kǝrnda, ǝnga njir yiwu duniya a ndiya yiwu Hyal. ");
INSERT INTO mfm_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","Abangǝ tsu ar babal ndu mǝl sǝ ǝnggǝr njir nu Hyal, ama wu lagur nggyabiyar nda ndu kǝpalna dǝnama nǝ Hyal. Culi nji kau, ga sara daɓǝ kǝr ǝnga nda mai! ");
INSERT INTO mfm_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","Wu pama nda tsu, alenyi nji aˈyi kǝra wu gal lagur vu ki nji aga nda vuwa nggutana mathlǝkǝˈyi kǝra aˈyi hahangǝ mai, ǝnga mathlǝkǝˈyi kǝra maˈyiri naɗǝu wu bikau ǝnga tsu suna sǝ ɗǝmwaˈyiˈyar pamǝpamǝ hǝna hangǝkalǝr nda. ");
INSERT INTO mfm_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","Nanda ngǝ mathlǝkǝˈyi kǝra cumu ndu highiɓǝ sau, ama nandǝ wu sǝn tǝkǝbiya wu pama jiri ǝnga fati mai. ");
INSERT INTO mfm_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","Ənggǝra Janusu ǝnga Jambǝrasu nggǝl ara mǝl sǝra Musa wu na, abangǝ tsu ngǝ nji kǝ nggǝl ara nu sǝra jiri. Nanda njira ɗǝngar nda a tǝwari, agabangǝ mbǝrsa kǝra ndu highiɓǝ kau nǝ ngguta nji ngau. ");
INSERT INTO mfm_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","Ama sǝr mǝla nda kau wu nda maˈyi naɗǝ mai, ara ǝnggǝra dzakura Janusu ǝnga Jambǝrasu ɗa ar babal, abangǝ tsu ngǝ nǝr nda wu nda ɗa anǝ kalar ndau. ");
INSERT INTO mfm_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","Kabangǝkau Timathlawusu, wu sǝn gǝ sau ar kǝra highiɓǝ ɗa patǝu, ǝnga culi nggyabiya ɗa, ba ǝnga sǝra yu nggya aga nyi, ǝnga mbǝrsa ɗa, ba ǝnga culi munya ɗa ǝnga yiwukur kǝra yu ca ba sǝsǝu sǝ ɗa. ");
INSERT INTO mfm_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","Wu sǝn gǝ tsu culi ɓwaɓwatǝ pamǝpamǝ kǝra yi sǝsǝˈwuri wu mǝlmǝ Antakiya, ǝnga Ikoniyamu, ba ǝnga Lisǝtǝra, ama wu sǝˈyar kǝ patǝ kǝ Hyal hǝbiya ɗa a gwa. ");
INSERT INTO mfm_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","Ənga jiri, kalar ndǝra wu yiwu ja nggya nǝ Hyalkur wu Kǝrsiti Yesu kǝl ji ɗari ɓwaɓwatǝ. ");
INSERT INTO mfm_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","Ama nji batal ǝnga njir ngguta nji nǝr nda kǝl cakǝ nga ndu cakau wu ɗǝmwaˈyikur, ndu ngguta nji ǝnga nju ngguta nda tsu. ");
INSERT INTO mfm_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","Ama nagǝ nǝ ngau, ga dumwa ǝnga highiɓǝ kǝra gǝ nggari ǝnga ga mbǝrsa ni, ara wu sǝni gǝ njira highiɓǝr ngǝ sǝˈyar kau. ");
INSERT INTO mfm_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","Ga ɗǝngari ar pǝci kǝra gǝ tsu zǝr ǝnga ga vǝr highiɓǝ sǝra tsǝtsǝfǝ wu Lǝkakaɗǝ cicau nǝ Hyal, kǝra wu sǝn highiɓǝr ngǝ lagur uya mbǝɗau lagur mbǝrsa ǝnga Kǝrsiti Yesu. ");
INSERT INTO mfm_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","Patǝkura sǝra tsǝtsǝfə wu Lǝkakaɗǝ cicau sǝra Hyal nana ngau, mǝnahǝ nga nyi aga highiɓau ǝnga aga kughi ǝnga fǝ sǝ wu lagu ba ǝnga hwathlǝ nju lagu tsapǝu, ");
INSERT INTO mfm_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","aga kalar ndǝ nǝ Hyal ju ɗa hwahwathlau aga mǝl thlǝr wu kalar lagu kǝra mǝnahǝu. ");
INSERT INTO mfm_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","Yu na anǝ ngau wu mwar Hyal ǝnga wu mwar Kǝrsiti Yesu, ndǝra wu sa mǝl numa anǝ njira ǝnga pi ba nji tǝtau, ǝnga ǝtsu ju sha shili ju sa ciya tǝlkur nyi. ");
INSERT INTO mfm_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","Ga tǝtǝlna ndǝr Hyal, ga dumwa ni ar pǝci kǝra ja mǝsahǝu ǝnga pǝci kǝra ja aˈyi mǝsahǝ mai. Ga tǝɗar himiya nda, ǝnga ga kughiya nda, ba ǝnga tsu ga tsǝtsǝkur ɗǝfuwa nda lagur mba ɗǝfu ǝnga highiɓau. ");
INSERT INTO mfm_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","Arya pǝci a vǝr shili kǝra nju nda sǝya himi anǝ highiɓǝ nǝ tsapǝ mai. Ama ar viya kau kǝl nu sǝra ɗǝfuwa nda wu yiwu, agabangǝ ndu kaɓiya malǝmǝ gangǝu kǝra wu nda nar nda kǝl sǝra himiya nda wu yiwu nda nggari wacu. ");
INSERT INTO mfm_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","Ndu nda dari himiya nda ara nggari sǝra jiri ba nda dzǝgwa pahǝna himiya nda aga sǝhimi kǝbǝkwatǝ pampamǝu. ");
INSERT INTO mfm_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","Ama nagǝ nǝ ngau, ga tsǝrpǝr kǝrngau mǝnahǝu wu kalar sau, ga sǝsǝˈwuri kalar ɓwaɓwatǝ, ǝnga ga mǝl thlǝr nǝ ndǝr tǝtǝlna ndǝr Hyal, ǝnga ga nyabiya thlǝr ngǝ cicipǝu ar viya mafa nǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","Arya nayi nǝ ɗa ya vǝr dumwa ǝnga pǝsau nǝ piya yau, ǝnga tsu pǝcir tǝ ɗa a ɗari lǝhǝu. ");
INSERT INTO mfm_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","A panar yi pa kǝra mǝnahǝu, a hwinar yi hwi pǝra pǝra ɗa jamǝu, ǝnga tsu nayi pǝna mbǝrsa ɗa mai. ");
INSERT INTO mfm_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","Kabangǝkau, akkǝri tsapǝu kǝra cabiya abǝr a pinar yi huɗa Hyal a vǝr sǝ kǝ ɗa. Thlagǝ ndǝr numa tsapǝ ngu sa nǝ ɗa akkǝri kau, ar pǝcir numa. Aˈyi anǝ ɗa nga ju sa lǝ akkǝri kǝ waci mai, ama anǝ kalar ndǝra vǝr sǝkǝ pǝcir shili nyi ǝnga huɗǝ hamǝu. ");
INSERT INTO mfm_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","Timathlawusu, ga nǝrdzau ga shili ǝgya yau ǝnga kusa. ");
INSERT INTO mfm_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","Ara Dimasu a piyar ɗari arya ju yiwu sǝr duniya kǝ ji maˈyi a vu Tasalonika. Kǝrisensu a maˈyiri a vu ˈyiˈyir Galatiya, ǝnga Tayitusu tsu a maˈyiri ja a vu ˈyiˈyir Dalmatiya. ");
INSERT INTO mfm_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","Kǝl Luka zhizhi nyi ngǝ hiyau ǝnga yau. Ga marma Markusu ma gu shili, ara naja ǝnga vala dzau anǝ ɗa wu thlǝr ɗa. ");
INSERT INTO mfm_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","A sǝwari yi Tikikusu a vu Afisa. ");
INSERT INTO mfm_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","Ar pǝci kǝra gu shili, ga mar ɗa gwada ɗa kǝra yi piyari wu tsa Kapusu wu mǝlmǝ Turuwasu, ga faˈari ɗa lǝkakaɗǝ ɗa a shili, majama nǝ ciˈyar ta. ");
INSERT INTO mfm_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","Alegǝzanda ndǝr dlǝ liyangǝ ndzana thlǝr ɗa gagaɗau. Hyal Thlagǝu ngu nda kibiya sǝ kǝ ji mǝliya kau. ");
INSERT INTO mfm_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","Nagǝ ma ga hangǝkal ǝnga ja, arya ju ca dawakur ǝnga cama kǝra mǝn shili ni kau. ");
INSERT INTO mfm_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","Ar pǝci kǝra nji hǝr ɗa a shili wu mwar njir pathla, ndǝ aˈyi kǝra nu ɗa mai, ndǝ shini ɗa yi patǝu. Kǝdi Hyal ɗa, ca ngǝ ja tǝfǝbiya nda bikǝr nda patǝu. ");
INSERT INTO mfm_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","Ama kǝ Thlagǝu nggya ǝnga yau, ji cakǝr ɗa dǝnama, aga lagu ɗa ngǝ ndǝshigu mǝsahǝ kau wu nda tǝtǝlnakǝr anǝ nji ar babal, aga njira aˈyi njir Yahudiya mai nda nggari tsu. Naja ngǝ hǝbiya ɗa sara wu miya tau wu miya lǝvari. ");
INSERT INTO mfm_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","Thlagǝu wu nda hǝbiya ɗa sara wu kalar sǝ ɗǝmwaˈyu, ba ja hǝr ɗa jamǝu a shili wu tǝlkur nyi. A nǝ nyi ngǝ kadakadarkur baˈanuwa. Aminu. ");
INSERT INTO mfm_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","Ga usar ɗa Pǝrsila ǝnga Akwila ba ǝnga njir ki Onesiforosu. ");
INSERT INTO mfm_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","Irastusu nǝ nyi, tsu ja wu Kwaranthli, ǝnga yi piyari Tǝrafimusu a vu Miletusu gǝra ngga. ");
INSERT INTO mfm_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","Ga nǝrdzau ga shili ǝnggau divira biyargwa. Yubulusu ǝnga Fudensu ǝnga Layinusu ba Kǝlaudiyasu ǝnga patǝr wazha ama nda a vǝr usa ngau. ");
INSERT INTO mfm_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","Thlagǝu ja nggya ǝnga mambǝl ngau. Taˈyi mayiwakur a nggya ǝnga hyi.");
INSERT INTO mfm_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","Cama tsǝtsǝfǝ kǝ sara ara Bulusu mafa Hyal ǝnga cama sǝsau nǝ Yesu Kǝrsiti aga tsǝtsǝkur mbǝrsa nǝ njira Hyal caɗǝbiya nda, ǝnga aga sǝnbiya jirkur nǝ Hyalkur ");
INSERT INTO mfm_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","mbǝrsa ǝnga sǝn sau a nggyari lagur fǝr kǝr nǝ pi gǝra kuɗau, kǝra Hyal, kǝra gǝra fati mǝliya alkawal tsu wu dzuguya pǝci. ");
INSERT INTO mfm_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","Wu pǝci tsatsaˈa nyi nga ji cabiya ɗa lagur tǝtǝlna ndǝr nyi, kǝra ya vǝr tǝtǝlna, kǝra tsu naja ngǝ ndǝra fuwa a gwu tsa yau lagur Hyal ndǝr mbǝɗa mǝn. ");
INSERT INTO mfm_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","Anǝ Tayitusu, zǝr ɗa nǝ jiri wu mbǝrsa kǝra aˈyi ara mǝn patǝu. Bǝgǝ mayiwakur ǝnga huɗǝ pǝrtǝu sara ndara Hyal Tada ǝnga Kǝrsiti Yesu Ndǝr Mbǝɗa mǝn, ja nggya ǝnga gau. ");
INSERT INTO mfm_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","Sǝra ɗa yi piyari ngau a vu Kǝretu ca ngǝ, aga ga dǝwuya kalar sǝra hyau, ǝnga tsu aga ga fiya njira nggurǝm a wu kalar mǝlmau ǝnggǝr kǝra yi nar ngau. ");
INSERT INTO mfm_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","Kikikura nyi njira nggurǝm ja ɗa ndǝra nji gǝra sǝn vazǝya, ndǝ mala zǝmǝu, ndǝra wazha nyi wu hǝnggǝri ǝnga ja, ǝnga naja aˈyi nju sǝni nyi ǝnga nggya papatagǝu, ǝnga gǝra ɓǝlar ndǝr mai. ");
INSERT INTO mfm_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","Ta ɗari ndǝr tǝɗǝmwa njir nu ja ɗa ndǝ gǝra vazau, ndǝ gǝra ɗa ndǝ kurthlu, ndǝ gǝra kakafǝ ɗǝfu, ǝnga ndǝ gǝra sa sǝ sasa, ǝnga ndǝ gǝra kura vi, ba ǝnga ndǝ gǝra sǝm dlǝrbau. ");
INSERT INTO mfm_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","Ama ja ɗa ndǝr dlǝwu mǝthlǝpi, ndǝr yiwu sǝra mǝnahǝkur, ndǝra kǝkǝya kǝrnyi, ndǝra ǝnga jirkur wu ɗǝfuwa ja, ndǝ cicau, ba ǝnga ndǝra hwathliya kǝrnyi. ");
INSERT INTO mfm_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","Ja ɗa ndǝra sǝɓiya ndǝr Hyal jijiri ɓaɓalu ǝnggǝr kǝra nji highiɓǝr nyi, aga ja tsǝtsǝkuri nji patǝu lagur highiɓǝ nǝ jiri, aga ja ɓǝɓǝlna highiɓǝ kǝra dawa a vǝr highiɓau. ");
INSERT INTO mfm_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","Arya njir gwazhivi aˈyi nda gangǝu, njir ndǝr gǝra kǝr, njir sukwa vi, nja na nji kǝra a vǝr ngga kǝrnda nji thlathla pǝlzha kau. ");
INSERT INTO mfm_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","A mbari nja bǝgǝya nda ara nda sara ndzana hangǝkala nji ǝnga highiɓǝ ɗǝmwaˈyir nda kǝra ndu mǝl, aga sǝm dlǝrbau. ");
INSERT INTO mfm_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","Pathlǝ wu pama nabir nda a nanari abǝr, “Njir Kǝretunu, njir thla fati ngau cumu, nji shishi, njir haɗǝwa, njir wuraga ɗǝfau.” ");
INSERT INTO mfm_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","Najaka sakida jijiri nga nyi. Agabangau, ga kughiya nda gagaɗau, aga nda ɗa nǝnau wu mbǝrsar nda, ");
INSERT INTO mfm_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","aga nda piyari sǝhimi pumungutu fati nǝ njir Yahudiyat, ǝnga nda piyari nu sǝr ɓǝla kǝra njira piyari jiri fiya. ");
INSERT INTO mfm_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","Anǝ njira ǝnga ɗǝfu cicau, kalar sau cici nga nyi. Āma anǝ njira ǝnga ɗǝfu dedeɓǝu, njira gǝra mbǝrsa, sǝ cicau aˈyi mai. Ɗǝngar nda ǝnga ɗǝfuwa nda patǝ dedeɓǝu nga nda. ");
INSERT INTO mfm_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","Ar cicir miya nga nda vǝr na abǝr ndu sǝn Hyal, ama sǝr mǝla nda a kǝpalnari. A ɗar nda sǝ zhizhigǝr, ǝnga nji gǝra ɓǝlar ndǝr, ǝnga nanda tsu ndu sǝn mǝl sǝ mǝnahǝ mai. ");
INSERT INTO mfm_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","A fiyar kǝr anǝ ngau ga highiɓǝ sǝra tsatsaˈa ǝnggǝr kǝra highiɓǝ nǝ jijiri nana. ");
INSERT INTO mfm_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","Ga highiɓǝr nyi anǝ shili njira nggunggurǝm aga nda kǝkǝya kǝrnda, nda nggya wu hangǝkala nda, nda hwathliya kǝrnda, nda thlǝya hi wu jirkur ǝnga mbǝrsa, ǝnga yiwukur, ba ǝnga sǝsǝˈu sau. ");
INSERT INTO mfm_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","Abangǝ tsu, ga highiɓǝr nyi anǝ mathlǝkǝˈyi nggunggurumǝu aga nda ɗa ǝnga gǝnggǝr sǝli wu nggyabiyar nda, aˈyi njir ndza thlǝmǝ ǝnga njir sa pathlǝ mai, ama aga nda highiɓǝ sǝ mǝnahǝ anǝ nji. ");
INSERT INTO mfm_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","Aga nda dzǝgwa highiɓǝr nyi anǝ wazha mathlǝkǝˈyi aga nda yiwu shilir nda ǝnga wazhar nda. ");
INSERT INTO mfm_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","Nda ɗa njira kǝkǝya kǝrnda, njira cicau, njira tsǝrpǝr kir nda, njira tsapǝu, njira lǝr kǝrnda anǝ shilir nda, ara nja sara diɗana ndǝr Hyal. ");
INSERT INTO mfm_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","Abangǝ tsu, ga tsǝtsǝku wazha shili aga nda kǝkǝya kǝrnda. ");
INSERT INTO mfm_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","Wu kalar sau, ga cabiya kǝrngau abǝr ndǝra nju sǝn highiɓǝr sǝ mǝnahǝu ara ja ngau. Ga highiɓǝ ǝnga jirkur daɓǝ ǝnga kwakwaɗǝ mashi, ");
INSERT INTO mfm_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","ǝnga ga nana sǝra jiri, sǝra nji gǝra sǝn uya sǝr nggǝl a gwa. Ara njir dawa nda sara uya lagur ndǝr didiɗi ar kǝra mǝn. ");
INSERT INTO mfm_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","Ga highiɓǝr nyi anǝ mafaˈyar nda ɓǝlari ndǝr thlagǝr kir nda wu kalar sau, nda ɗa njira nju nggar mǝnahǝkur nda. Nda sara kǝpal wu pam ǝkkǝˈyi nda mai, ");
INSERT INTO mfm_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","a sara hya hǝl nda mai, ama nda cabiya abǝr njira nju fiyafǝ ǝnga nda ngau, lagu kǝ nga nju lari mǝnahǝkura highiɓǝ ar kǝra Hyal ndǝr mbǝɗa mǝn. ");
INSERT INTO mfm_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","Ara mayiwakur nǝ Hyal kǝra shili ǝnga mbǝɗau, a cabiyar kǝr anǝ kalar ndau. ");
INSERT INTO mfm_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","Mayiwakur kau, a highiɓǝr mǝnǝr ja aga mǝna piyari nggya nǝ gǝra sǝn Hyal, ǝnga mǝna piyari nggya suna suna nǝ duniya kau, aga mǝna kǝkǝya kǝrmǝn, mǝna ɗa nji jijiri wu ɗǝfu, ba ǝnga mǝna ɗa nji Hyal hyal wu najaka duniya. ");
INSERT INTO mfm_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","Mǝnu nggya abangau, ǝnggǝr kǝra mǝna vǝr sǝkǝ nyabiya dzǝ fǝr kǝr nǝ barka kau, ca ngǝ cabiya dzǝ nǝ kadakadarkur nǝ Hyalǝr mǝn, ndǝ dǝgal ǝnga ndǝr mbǝɗa mǝn Yesu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","Ndǝra naja ndǝra lǝr kǝrnyi aga ja bǝlbiya mǝn sara wu kalar shishikur, aga ja thlǝna mǝn anǝ kǝrnyi, aga mǝn ɗa nji nyi, njira wu caguli aga mǝl sǝ mǝnahǝu. ");
INSERT INTO mfm_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","Sǝˈyar kau nga sǝra ga highiɓǝr nda, ga tsǝtsǝkuri njira vǝr nggar ngau, ga kughiya nda ǝnga patǝr dǝnama. Ga sara piyari vanyi ndǝ ja diɗana ngǝ mai. ");
INSERT INTO mfm_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","Ga ɗǝngar nyi anǝ nji aga nda lǝr kǝrnda anǝ tǝlǝr nda ǝkkǝˈyi njir sǝɓǝ ˈyiˈyi. Bəgə nda ɗa njir ɓǝlar ndǝr, ǝnga nda ɗa njir mǝl kalar sǝra mǝnahǝu, ");
INSERT INTO mfm_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","a sara nda na ndǝr didiɗi anǝ ndǝ mai, nda ɗa njir nggya jamǝu daɓǝ ǝnga sǝhimi ndau, nda ɗa njir tina kǝr anǝ kalar ndau. ");
INSERT INTO mfm_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","Ɗǝɗǝmǝu nji dza nga mǝn, nji gǝra ɓǝlar ndǝr, njira nji nggutana, kǝ mǝn dzǝgwa ɗa mafa ǝnǝ kalar sǝ suna suna pampamǝu, mǝn nggya njir sǝɓǝ ndǝ wu ɗǝfu, ǝnga ɗa shishi. Nji piyari shishir dza mǝn ǝnga mǝn piyari shishir dza nji tsu. ");
INSERT INTO mfm_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","Ama ta mǝnahǝkur ǝnga yiwukur nǝ Hyal Ndər mbəɗa mǝn cabiya kǝr, ");
INSERT INTO mfm_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","ba ji mbǝɗana mǝn, aˈyi ara thlǝr tsapǝ kǝra mǝn mǝliya mai, ama arya tǝhuɗǝ nyi. Ji mbǝɗana mǝn lagur pǝra kǝra ji pǝrana mǝn kǝra nǝ mǝn yabiya dzǝ ǝnga nggya mafǝleng lagur Mambǝl Cicau. ");
INSERT INTO mfm_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","Mambǝl Cici kǝ nga nji pǝnggǝri a shidar kǝra mǝn lagur Yesu Kǝrsiti ndǝr mbǝɗa mǝn. ");
INSERT INTO mfm_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","Ji mǝl abangau aga mǝna ɗa nji gǝra bikau wu mwar Hyal lagur mayiwakur nyi, aga mǝna ɗa njir faˈaki nǝ pi gǝra kuɗau kǝra mǝna vǝr fǝrkǝr aga nyi. ");
INSERT INTO mfm_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","Ndǝr kau, ndǝr jijiri ngau. A yiwu yau ga cakǝr ndǝr ar kǝra sǝˈyar kǝ gagaɗau, aga njira hǝnggǝri ǝnga Hyal nda hangǝkal aga nda lǝr kǝrnda aga nda mǝl sǝra mǝnahǝu. Mǝnahǝ ngǝ sǝˈyar kǝ gagaɗau, ǝnga wu lǝ akkǝri anǝ kalar ndǝ tsu. ");
INSERT INTO mfm_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","Ama ga hǝbiya kǝra gau, sara wu kǝpal gǝra kǝr, ǝnga jiga sǝ ciji ciji, ǝnga kǝpal ar kǝra dlaɗau, arya sǝr dlǝwar dzǝ aˈyi a gwa mai. ");
INSERT INTO mfm_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","Ga kughiya ndǝr tǝtǝl kǝr nji, ca ngǝ sǝ tanggǝrma kǝra mǝl, ga ɓǝra kughiya nǝ mǝthlǝkura nyi, ayukuɗa nyi ba ga tǝkǝ ǝnga ja. ");
INSERT INTO mfm_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","Ga sǝni abǝr culi najaka ndau sasa nga ja, a mǝliyar ja numa anǝ kǝrnyi lagur bikǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","Ma gǝ lari a sǝwa ngǝr yi ndaliya ki Artimasu ǝnga Tikikusu, ga nǝrdzau aga ga sa thlǝwa ɗa wu Nikapolisu, ara yu yiwu ya hǝbiya vuya a ndǝna. ");
INSERT INTO mfm_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","Ga mǝl thlǝr ǝnga dǝnama ngǝ patǝu aga ga dlǝwari Zinasu, lawuya kau, nanda gyapǝu ǝnga Apolusu aga nda gu lagu. Ga lari abǝr sǝ aˈyi kǝra ndǝ tini mai. ");
INSERT INTO mfm_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","A mbari, njir mǝn nda highiɓǝri lǝr kǝrnda aga mǝl thlǝr kǝra mǝnahǝu, nda ɗa njira wu sǝn uya sǝ anǝ kǝrnda ǝnga nda njir kǝtiya nji ma thlǝr hyaˈari. Nda sara ɗa nji pǝpǝltǝ mai. ");
INSERT INTO mfm_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","Patǝr njira ˈya ǝkkǝˈyi nda, nda vǝr usa ngau. Ga usar njira vǝr yiwu mǝn wu mbǝrsa. Bəgə mayiwakur nǝ Hyal ja nggya ǝnga hyi patǝu. Amina.");
INSERT INTO mfm_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","Cama tsǝtsǝfǝ kǝ sara ara Bulusu ndǝra wu fursǝna arya Kǝrsiti Yesu, ǝnga Timathlawusu zamǝr mǝn, A nda nǝ Fǝlimonu bazhi huɗa mǝn ǝnga ndǝr mǝl thlǝrǝr mǝn, ");
INSERT INTO mfm_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","ǝnga anǝ kwamǝr mǝn Afiya, ǝnga Archipusu bazhi wu ɓwaɓwatǝr mǝn, ǝnga anǝ daɓǝ dzǝ njir nu kǝra a vǝr kaɓǝ wu ki ngau. ");
INSERT INTO mfm_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","Bǝgǝ mayiwakur ǝnga huɗǝ pǝrtǝu sara ara Hyal Dǝrmǝn ǝnga Thlagǝr mǝn Yesu Kǝrsiti ja nggya ǝnga hyi. ");
INSERT INTO mfm_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","Ya vǝr usaku anǝ Hyal cumu kalar pǝcira ya vǝr kǝdi Hyal anǝ ngau, ");
INSERT INTO mfm_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","arya a nggar yi ar kǝra mbǝrsa ngau wu Thlagǝ Yesu ǝnga yiwukur ngau anǝ patǝr nji cici gǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","Ya vǝr kǝdi Hyal aga hya ɗa nǝnǝ wu nggya wu cir zǝmǝr hyi wu mbǝrsa, aga hya nǝbiya dzǝ wu sǝnbiya sǝ wu kalar sǝ mǝnahǝ kǝra mǝn ǝni wu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","Yiwukur ngau a nǝ ɗa ri huɗǝ pipida ǝnga tsǝtsǝku ɗǝfu, arya nagau, zamǝ ɗa, a tsǝtsǝkur gǝ ɗǝfuwa nji cici gǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","Agabangau, arya kau, a sǝn taˈyi yau wu Kǝrsiti aga ya cuwa ngǝ ga mǝl sǝra kakal ga kyaga mǝl, ");
INSERT INTO mfm_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","alaga abangau, ya vǝr kǝdi ngau wu yiwukur. Nayi Bulusu, ndǝra dǝgal hahal ǝnga kabangǝkau ndǝr fursǝna arya Kǝrsiti Yesu, ");
INSERT INTO mfm_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","ya vǝr kǝdi ngau arya zǝr ɗa Onisimusu, ndǝra ɗa zǝr ɗa ar pǝcira yi wu fursǝna. ");
INSERT INTO mfm_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","Ɗǝɗǝmǝu, aˈyi ja ndǝr kǝtiya ndǝ mai, ama kabangǝkau, a ɗar ja ndǝr kǝtǝ ma gyapǝ ma. ");
INSERT INTO mfm_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","Ya vǝr sǝ nyi a ndǝra gau, naja ndǝra wu ɗǝfuwa yau. ");
INSERT INTO mfm_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","A yiwur yau aga ya sǝɓiya nyi ǝgya yau, aga ja mǝl thlǝr ar viya gau anǝ ɗa, ar pǝcira yi wu fursǝna arya tǝtǝlna ndǝshigu. ");
INSERT INTO mfm_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","Ama nayu yiwu ya mǝl kalar sǝ ǝnga gǝra hǝnggǝri ngǝ mai, aga kalar mǝnahǝkur kǝra gǝ mǝl ja ɗa sǝ yiwu huɗa gau, aˈyi sǝ caca mai. ");
INSERT INTO mfm_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","Ma vanyi sǝra ɗa hyi tǝkǝbiya dzǝ ǝnga ja nǝ pǝci kushi kau, aga ga ɓǝra sǝn dlǝwur nyi, hya nggya nǝ baˈanuwa ngau. ");
INSERT INTO mfm_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","Ga dlǝwur nyi, aˈyi ar viya mafa mai, ama ar viya sǝra ndiya mafa, ar viya zamǝ kǝra gu yiwu. A yiwu nyir yi gagaɗau, anǝ ngǝ tsu, ga yiwu nyi a ndiya kǝra ya vǝr yiwu nyi, gyapǝ wu ndǝndǝkur ǝnga zamǝ wu Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","Ma gǝ hǝr ɗa ar viya bazhi daɓǝ kǝr, dlǝwur nyi ǝnggǝr kǝra ga dlǝwur ɗa. ");
INSERT INTO mfm_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","Ma ji mǝliya ngǝ sǝra ɗǝmwaˈyu, alaga ga vǝr nu nyi mǝl nǝ kalar sau, ba ga fǝri a dar kǝra yau. ");
INSERT INTO mfm_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","Nayi Bulusu, nayi nga vǝr tsǝfǝ najaka sau ǝnga tsa yau, yu nda kina ngau, a sara nja na ya vǝr nu ngǝ mǝl nǝ pi nǝ Hyal kǝra gǝ uya lagu ɗa mai. ");
INSERT INTO mfm_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","Zam ɗa, ya vǝr cim aga ya uya akkǝri ara gau lagu Thlagǝu. Ba ga dzǝgwa pina huɗa yau wu Kǝrsiti. ");
INSERT INTO mfm_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","Aˈyi yi ǝnga papakur kǝr ǝnga ɓǝlar sǝ ngau, ca ngǝ ɗa yi tsǝfǝ najaka sau anǝ ngau, ara a sǝnǝr yau, gu nda mǝliya a ndiya kǝra yi nar ngau. ");
INSERT INTO mfm_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","Sǝ zǝm kǝra ya vǝr na, ca ngǝ ga fiya ɗa vir pida, ara ya vǝr ɗǝnga abǝr nju shabiya ɗa a shili ara hyi arya kǝdi Hyalǝr hyi. ");
INSERT INTO mfm_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","Ipafǝrasu, bazhi fursǝna ɗa arya Kǝrsiti Yesu, ja vǝr usa ngau. ");
INSERT INTO mfm_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","Abangǝ tsu Markusu, ǝnga Aristakusu, ǝnga Dimasu, ǝnga Luka bazhi mǝl thlǝr ɗa, nda vǝr usa ngau. ");
INSERT INTO mfm_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","Bǝgǝ mayiwakur nǝ Thlagǝ Yesu Kǝrsiti ja nggya ǝnga mambǝlǝr hyi . Amina.");
INSERT INTO mfm_vpl VALUES ("HB1_1","088_1_1","HEB","1","1","1","Ɗǝɗǝmǝu, Hyal ndǝrna ndǝr anǝ ǝjir mǝnˈyar lagu pampamǝu ǝnga tsu ar pǝci pampamǝu lagu nabiˈyar. ");
INSERT INTO mfm_vpl VALUES ("HB1_2","088_1_2","HEB","1","2","2","Ama ar kuɗiyar pǝci kau, ja vǝr ndǝr anǝ mǝn lagu Zǝr nyi. Lagu Zǝr nyi ngǝ Hyal mǝliya kalar sǝ wu duniya. Naja tsu nga ji caɗǝbiya aga ja ɗa ndǝr faˈa ki nyi. ");
INSERT INTO mfm_vpl VALUES ("HB1_3","088_1_3","HEB","1","3","3","Naja ngǝ mbǝmbǝl nǝ cabiya kadakadarkur nǝ Hyal ǝnga tsu naja ngǝ pabiya nggyabiya Hyal. Ja vǝr sǝɓǝ kalar sǝ lagu ndǝr nyi kǝra ǝnga dǝnama. Ayukuɗa ji cina mǝn bikǝr mǝn, ba ji nggya gya ar tsi mazǝma Ndǝra Dlǝdlǝvǝ gagaɗǝ a dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("HB1_4","088_1_4","HEB","1","4","4","Lagu kǝ tsu nga ji uya vir nggya kǝra a ndiya nǝ waladiˈyar ǝnggǝr kǝra ji uya thlǝmǝ kǝra ndiya nǝr nda ǝnga dǝgalǝu. ");
INSERT INTO mfm_vpl VALUES ("HB1_5","088_1_5","HEB","1","5","5","Arya tsu, wa ngu pama waladiˈyar kǝra Hyal saya na anǝ nyi, abǝr, “Nagǝ Zǝr Ɗa ngau, Əshina, a ɗar yi Dǝnga”? Ənga tsu, Hyal na, “Yi wu nggya tada anǝ nyi, ǝnga ju nggya zǝr anǝ ɗa”? ");
INSERT INTO mfm_vpl VALUES ("HB1_6","088_1_6","HEB","1","6","6","Ama ta ji sǝwa mǝkaji nyi a shida wu duniya, ba ji na, “Patǝr waladiˈyar nǝ Hyal nda dlǝvǝ nyi.” ");
INSERT INTO mfm_vpl VALUES ("HB1_7","088_1_7","HEB","1","7","7","Ənga ar kǝra waladi nyiˈyar tsu, ba ji na, “Ju sǝn shabiya waladi nyiˈyar majigwal kǝra wu sau, ǝnga njir mǝl thlǝr nyi tsu kyara uˈu.” ");
INSERT INTO mfm_vpl VALUES ("HB1_8","088_1_8","HEB","1","8","8","Ama ar kǝra Zǝra nyi, kǝ ji na, “Tsǝkafǝ ngau, Hyal, wu nggya baˈanuwa, zǝwa tǝlkur ngau ca ngǝ nggya nǝ tsapǝu. ");
INSERT INTO mfm_vpl VALUES ("HB1_9","088_1_9","HEB","1","9","9","Gu yiwu tsapǝkur, ǝnga gǝ piyari ɗǝmwaˈyikur. Arya kǝ Hyal, ca ngǝ Hyal ngau, hana ngau adabanga ghakǝr ngǝˈyar lagur ɗǝwa ngǝ mal nǝ ɗǝfu pǝrtǝu.” ");
INSERT INTO mfm_vpl VALUES ("HB1_10","088_1_10","HEB","1","10","10","Kǝ ji bǝra na, “Wu dzǝguya, Thlagǝu, gǝ fiya hya duniya, ba gǝ mǝliya dǝmǝlmǝˈyar ǝnga pǝla gau. ");
INSERT INTO mfm_vpl VALUES ("HB1_11","088_1_11","HEB","1","11","11","Sǝra gǝ mǝliya, ndu nda sanakǝr, ama gu nggya baˈanuwa. Ndu nda halnakǝr ǝnggǝr lǝgutǝ hahal. ");
INSERT INTO mfm_vpl VALUES ("HB1_12","088_1_12","HEB","1","12","12","Gu nda pǝɗiya nda ǝnggǝr kadǝmbul, ǝnga tsu gu nda bǝla nda ǝnggǝr nju bǝla kari. Ama aˈyi gǝ nǝ ngǝ cumu gǝra bǝla; gangǝkura fa ngau, wu sǝn kuɗǝ mai.” ");
INSERT INTO mfm_vpl VALUES ("HB1_13","088_1_13","HEB","1","13","13","Ənga anǝ waladi mani ngǝ Hyal saya na anǝ nyi, “Nggya lagu tsi mazǝma yau kǝl yi fiya dawa ngǝˈyar a gyi gya kiɗa hiya ga”? ");
INSERT INTO mfm_vpl VALUES ("HB1_14","088_1_14","HEB","1","14","14","Agabangau, waladiˈyar ngǝ njir mǝl thlǝr nga nda wacu, kǝra Hyal sǝwa aga dlǝwari njira wu nda faˈa ki nǝ mbǝɗau. ");
INSERT INTO mfm_vpl VALUES ("HB2_1","088_2_1","HEB","2","1","1","Agabangau, kǝl mǝna sǝya himi mǝnahǝ anǝ sǝra mǝn nggari, ara mǝna sara sha a gyu yukuɗu samǝu. ");
INSERT INTO mfm_vpl VALUES ("HB2_2","088_2_2","HEB","2","2","2","Cama kǝra Hyal nana lagu miya waladiˈyar a nggyari, ǝnga kalar ndǝra ɓǝlna ǝnga nggǝl ara mǝl thlǝr ǝni, nju nda nǝ nyi ɓwaɓwatǝ kǝra tsaˈa aga sǝra ji ndzana. ");
INSERT INTO mfm_vpl VALUES ("HB2_3","088_2_3","HEB","2","3","3","Ma abangǝ ja, ma mǝn piyari najaka mbǝɗǝ kǝra dǝgal, lagu mani nga mǝnu nggani mǝnu sǝn uya mbǝɗa? Najaka mbǝɗǝ kǝra Thlagǝ ǝnga kǝrnyi ngǝ dzǝguya ndǝr ar kǝra nyi tanggǝrma. Njira nggar ndǝr nyi kau, nanda ngǝ cabiya mǝn abǝr ndǝr nyi kǝ jijiri nga nyi. ");
INSERT INTO mfm_vpl VALUES ("HB2_4","088_2_4","HEB","2","4","4","Hyal ǝnga kǝrnyi ngǝ lǝri sakida ar kǝra nǝr nda sakida lagur lǝri mǝtsamˈyar ǝnga sǝ dǝdǝgurˈyar ǝnga mǝl sǝ dǝdǝgurˈyar pampamǝu, ǝnga lǝ sǝ lǝlǝˈyar kǝra ji lǝri lagu Mambǝl Cici ǝnggǝra ju yiwu. ");
INSERT INTO mfm_vpl VALUES ("HB2_5","088_2_5","HEB","2","5","5","Aˈyi anǝ waladiˈyar ngǝ Hyal nǝ nda sǝm tǝlkur ar kǝra zaman kǝra a vǝr shili ǝnga kǝra mǝna vǝr ndǝr ar kǝri kǝ mai. ");
INSERT INTO mfm_vpl VALUES ("HB2_6","088_2_6","HEB","2","6","6","Ama aˈyi tsǝtsǝfǝ ar vanyi vi kǝra vanyi ndǝ lǝr sakida, ji na, “Mi ngǝ nda gu ɓwanǝ nyi kǝr anǝ kǝrngau ǝnga ja, ǝnga zǝr ndǝ kǝra gu dǝnga ǝnga ja? ");
INSERT INTO mfm_vpl VALUES ("HB2_7","088_2_7","HEB","2","7","7","Gǝ mǝliya nyi a gya banga waladiˈyar nǝ pǝci kushu, Gǝ nǝ nyi kadakadarkur ǝnga dǝgalkur, ");
INSERT INTO mfm_vpl VALUES ("HB2_8","088_2_8","HEB","2","8","8","ǝnga gǝ fuwa kalar sǝ ǝgyakiɗa dǝnama nyi.” Ta Hyal fuwa kalar sǝ ǝgyakiɗa ja, vanyi sǝ aˈyi kǝra Hyal gǝra fiya ǝgyakiɗa ja mai. Ama alaga abangau, kabangǝkau tsu mǝn gǝra lari nji fiya kalar sau ǝgyakiɗa ja. ");
INSERT INTO mfm_vpl VALUES ("HB2_9","088_2_9","HEB","2","9","9","Ama mǝnu lari Yesu, ndǝra nji mǝliya a gya banga waladiˈyar nǝ pǝci kushu, kabangǝkau, a fǝnggǝr nyir nji kadakadarkur ǝnga dǝgalkur, ara ɓwaɓwatǝ kǝra ji lari lagur tau. Ji mǝl abangau, aga lagur mayiwakur nǝ Hyal ji ɗahar tau, arya kalar ndau. ");
INSERT INTO mfm_vpl VALUES ("HB2_10","088_2_10","HEB","2","10","10","Hyal ngǝ mǝliya kalar sau, ǝnga tsu lagu nyi ngǝ patǝr sǝ ɗa. Hyal ngǝ nggar wazha gangǝu aga nda uya kadakadarkur. Agabangau, a ɗar tsaˈa anǝ ndǝra pahǝna lagur uya mbǝɗau, ja nyabiya dzǝ lagur lar ɓwaɓwatǝu. ");
INSERT INTO mfm_vpl VALUES ("HB2_11","088_2_11","HEB","2","11","11","Agabangau, ndǝra mǝliya nji cicau ǝnga njira ji cina, wazha tada zǝmǝ nga nda. Arya kǝ ngǝ Yesu aˈyi ɗa ǝnga sǝli ja ngga nda ǝnga wazha ama mai. ");
INSERT INTO mfm_vpl VALUES ("HB2_12","088_2_12","HEB","2","12","12","Ji na anǝ Hyal, “Yi wu hǝˈu thlǝmǝ ngau anǝ wazha maɗa, Yu fal thlǝmǝ ngau wu daɓǝr nji.” ");
INSERT INTO mfm_vpl VALUES ("HB2_13","088_2_13","HEB","2","13","13","Ji ɓǝra na, “Yi wu fǝr kǝr ǝnga ja.” Kǝ ji ɓǝra na wayu, “Kǝja yau, ǝnga wazha kǝra Hyal nǝ ɗa.” ");
INSERT INTO mfm_vpl VALUES ("HB2_14","088_2_14","HEB","2","14","14","Ta ɗa wazha kau, kum ǝnga mashi ngau, naja tsu kǝl ta ji ɗa kum ǝnga mashi ǝnggǝr nanda. Ji mǝl abangau, aga lagur tǝ nyi ba ja sǝmku tǝlkur ar kǝra ndǝra ǝnga dǝnama ar kǝra tau, naja ngǝ shatan. ");
INSERT INTO mfm_vpl VALUES ("HB2_15","088_2_15","HEB","2","15","15","Lagu kǝ nga ji pǝliya njira mbamba wu mafakur nǝ hivǝr tau, wu patǝr nggyabiyar nda. ");
INSERT INTO mfm_vpl VALUES ("HB2_16","088_2_16","HEB","2","16","16","Aga jiri aˈyi anǝ waladiˈyar ngǝ Yesu shili ǝnga dlǝwa dzǝ mai, ama anǝ culi gǝ Ibrahimu. ");
INSERT INTO mfm_vpl VALUES ("HB2_17","088_2_17","HEB","2","17","17","Agabangau, a mbari kǝl ja ɗa ǝnggǝr nǝ wazha mǝnyi, aga ja ɗa pubu kǝra ndiya ǝnga dǝgalǝu, kǝra ǝnga tǝhuɗǝu ǝnga kǝra wu mǝl thlǝr Hyal tsaˈa miya ɗǝfu. Ba ja dzǝgwa hǝna bikǝr nji lagur lǝr piya ja aga sǝr hǝ saɗaka. ");
INSERT INTO mfm_vpl VALUES ("HB2_18","088_2_18","HEB","2","18","18","Ta ɗa naja ǝnga kǝrnyi a lar ja ɓwaɓwatǝu, ar pǝcir dzǝ nyi, a ɗar ja tsaˈa aga ja dlǝwar njira gwu dzau. ");
INSERT INTO mfm_vpl VALUES ("HB3_1","088_3_1","HEB","3","1","1","Agabangau, nahyi wazha ama nji cicau, nahyi njira Hyal ngga, hya hǝ ɗǝnga ar kǝra Yesu ndǝra naja ngǝ ndǝ sǝsau, ǝnga pubu kǝra ndiya ǝnga dǝgalǝu, nǝ mbǝrsa kǝra mǝnu lǝ sakida ar kǝri. ");
INSERT INTO mfm_vpl VALUES ("HB3_2","088_3_2","HEB","3","2","2","Tsaˈa miya ɗǝfu nga ja anǝ ndǝra caɗǝbiya nyi, ǝnggǝr kǝra Musa mǝl thlǝr nyi tsaˈa miya ɗǝfu wu pama nji gǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("HB3_3","088_3_3","HEB","3","3","3","A thlǝwar nji Yesu a ndiya Musa ǝnga kadakadarkur, ǝnggǝr kǝra ndǝr hǝr ki a ndiya ki ǝnga kadakadarkur. ");
INSERT INTO mfm_vpl VALUES ("HB3_4","088_3_4","HEB","3","4","4","Arya kalar ki ndǝ ngǝ hǝriya nyi, ama ndǝra hǝriya kalar sau, ca ngǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("HB3_5","088_3_5","HEB","3","5","5","Musa ndǝr mǝl thlǝr tsaˈa miya ɗǝfu ngau, ndǝr mǝl thlǝr ar viya mafa wu ki Hyal, a lǝr ja sakida ar kǝra sǝra wu nda ɗa a ndumwa. ");
INSERT INTO mfm_vpl VALUES ("HB3_6","088_3_6","HEB","3","6","6","Ama Kǝrsiti ndǝ jijiri nga ja, ndǝra vǝr mǝl thlǝr ǝnggǝr Zǝr ar kǝra ki Hyal. Namǝn ngǝ ki Hyal, ma mǝn sǝn dumwa ǝnga fǝ ɗǝfu ba nggya ǝnga fǝr kǝr wu sǝra a vǝr shili. ");
INSERT INTO mfm_vpl VALUES ("HB3_7","088_3_7","HEB","3","7","7","Agabangau, ǝnggǝr kǝra Mambǝl Cici na, “Əshina, ma hyi nggari ɗaha ja, ");
INSERT INTO mfm_vpl VALUES ("HB3_8","088_3_8","HEB","3","8","8","hya sara ɗa ǝnga ɗǝfu ɓaɓal mai ǝnggǝr kǝra hyi mǝliya ar pǝcir hyaˈa hangǝkal, ar pǝcir dzǝ a gwar tagǝ mashi. ");
INSERT INTO mfm_vpl VALUES ("HB3_9","088_3_9","HEB","3","9","9","A guna ngǝ ǝjir hyi dzǝbiya ǝnga gǝlabiya ɗa, ǝnga ndǝ lari sǝra yi mǝliya nǝ fa foɗǝ kumunyi. ");
INSERT INTO mfm_vpl VALUES ("HB3_10","088_3_10","HEB","3","10","10","Ca ngǝ ɗa huɗa yi ndzǝndzǝ ǝnga naja ta zaman, ba yi na, ‘Cumu nga ndu shinɗa yi wu ɗǝfuwa nda, nanda aˈyi wu sǝni lagu ɗaˈyar mai.’ ");
INSERT INTO mfm_vpl VALUES ("HB3_11","088_3_11","HEB","3","11","11","Wu huɗǝ ndzǝndzǝ ɗa, yi sǝmku fǝla; ‘Nandǝ wu sa gwu ɓǝlsar ɗa mai.’ ” ");
INSERT INTO mfm_vpl VALUES ("HB3_12","088_3_12","HEB","3","12","12","Hya nggya ǝnga tsamǝ, wazha ama, ara nja sara thlǝwa bikau ǝnga gǝra hǝnggǝri wu ɗǝfuwa hyi kǝra wu mǝliya hyu shini yi anǝ Hyal Ndǝra ǝnga Pi. ");
INSERT INTO mfm_vpl VALUES ("HB3_13","088_3_13","HEB","3","13","13","Ar pǝci kǝra nju ngga ǝnga “Əshina” hya tǝɗar himiya kǝrhyi, ara kalar ndu pama hyi a sara ɗa ǝnga ɗǝfu ɓaɓal lagur ngguta vi nǝ bikau. ");
INSERT INTO mfm_vpl VALUES ("HB3_14","088_3_14","HEB","3","14","14","Namǝn njir daɓǝr kǝr ǝnga Kǝrsiti ngau, ma mǝnu taˈyi wu mbǝrsa kǝra mǝn uya tanggǝrma ǝnga dǝnama baˈa ndar kuɗiyar duniya. ");
INSERT INTO mfm_vpl VALUES ("HB3_15","088_3_15","HEB","3","15","15","Ənggǝr kǝra nji na, “Əshina ma hyi nggari ɗaha ja, hya sara ɗa ǝnga ɗǝfu ɓaɓal mai ǝnggǝr kǝra hyi mǝliya ar pǝcir hyaˈa hangǝkal.” ");
INSERT INTO mfm_vpl VALUES ("HB3_16","088_3_16","HEB","3","16","16","Wa ˈyar ngǝ nggar ndǝr Hyal ǝnga kǝ ndǝ ɓǝra hyaˈana nyi hangǝkal ta? Aˈyi njira Musa hǝbiya sara wu Masaru wa? ");
INSERT INTO mfm_vpl VALUES ("HB3_17","088_3_17","HEB","3","17","17","Ənga wa ˈyar ngǝ huɗa Hyal ndzǝ nǝ fa foɗǝ kumunyi ya? Aˈyi ǝnga njira mǝliya bikǝ, ba ndǝ dlǝdla ba ndǝ tǝnakǝr a gwar tagǝ mashi ta wa? ");
INSERT INTO mfm_vpl VALUES ("HB3_18","088_3_18","HEB","3","18","18","Ənga wa ngǝ Hyal sǝm fǝla abǝr nanda aˈyi wu gwu sǝhǝɗa nyi maya? Aˈyi ǝnga njira nggǝl ara ɓǝla ndǝr nyi wa? ");
INSERT INTO mfm_vpl VALUES ("HB3_19","088_3_19","HEB","3","19","19","Agabangau, a lari mǝn abǝr arya gǝra mbǝrsar nda, nga ndǝ tini gwu sǝhǝɗa nyi. ");
INSERT INTO mfm_vpl VALUES ("HB4_1","088_4_1","HEB","4","1","1","Agabangau, ta alkawal nǝ gwu ɓǝlsar nyi aˈyi baˈa shilar pǝci kǝ ǝshina, kǝl mǝna ɓǝla ǝnga jirkur, ara ja sǝra ɗa pathlǝ wu pama hyi ja tini gwa. ");
INSERT INTO mfm_vpl VALUES ("HB4_2","088_4_2","HEB","4","2","2","Ətsu, a nggar mǝn ndǝshigu, ǝnggǝr kǝra ndǝ nggari, ama ndǝr kǝra ndǝ nggar kau, aˈyi ɗa ǝnga akkǝri anǝ nda mai, arya nanda aˈyi daɓǝr ǝnga mbǝrsa mai. ");
INSERT INTO mfm_vpl VALUES ("HB4_3","088_4_3","HEB","4","3","3","Kabangǝkau, namǝn nji kǝra hǝnggǝri ngǝ gwu ɓǝlsar nyi, ǝnggǝr kǝra Hyal nana, “Wu huɗǝ ndzǝndzǝ ɗa, yi sǝmku fǝla; ‘Nandǝ wu sa gwu ɓǝlsar ɗa mai.’” Hyal nana abangau, alaga kǝ ji kuɗǝna thlǝr nyi tsu kaɗu ar dzǝgwar duniya. ");
INSERT INTO mfm_vpl VALUES ("HB4_4","088_4_4","HEB","4","4","4","Arya ar vanyi vi ji ndǝr ar kǝra pǝci nǝ mǝɗǝfǝkura nyi, abǝr, “Ar pǝci nǝ mǝɗǝfǝkura nyi, Hyal ɓǝliya sar sara ara thlǝr nyi patǝu.” ");
INSERT INTO mfm_vpl VALUES ("HB4_5","088_4_5","HEB","4","5","5","Ama ar vi kǝ tsu ji ɓǝra na, “Nandǝ wu sa gwu ɓǝlsar ɗa mai.” ");
INSERT INTO mfm_vpl VALUES ("HB4_6","088_4_6","HEB","4","6","6","Agabangau, a nggyari baˈanǝ kabangǝkau anǝ alenyi nji nda gwa wu ɓǝlsar ta, ama nanda njira nggar ndǝshigu kǝ tsu kaɗu nandǝ uya gwa mai, arya nandǝ aˈyi ɓǝlar ndǝr Hyal mai. ");
INSERT INTO mfm_vpl VALUES ("HB4_7","088_4_7","HEB","4","7","7","Kǝja, Hyal ɓǝra fiya vanyi pǝci kǝra ji ngga ǝnga, “Əshina,” ji ndǝr kau, lagur miya Dawuda ayukuɗa fa gangǝu, ǝnggǝr kǝra nji nana tsu kaɗu abǝr, “Əshina ma hyi nggari ɗaha ja, Hya sara ɗa ǝnga ɗǝfu ɓaɓal mai.” ");
INSERT INTO mfm_vpl VALUES ("HB4_8","088_4_8","HEB","4","8","8","Maja abǝr Jashuwa nǝ nda ɓǝlsar nǝ Hyal, Hyal aˈyi ɓǝra ndǝr ar kǝra vanyi pǝci kǝra wu shili mai. ");
INSERT INTO mfm_vpl VALUES ("HB4_9","088_4_9","HEB","4","9","9","Kǝ a cabiyari baˈanǝ kabangǝkau, pǝci aˈyi nǝ ɓǝlsar anǝ nji Hyal. ");
INSERT INTO mfm_vpl VALUES ("HB4_10","088_4_10","HEB","4","10","10","Agabangau, kalar ndǝra gwu ɓǝlsar nǝ Hyal, a gwar ja wu ɓǝlsar sara wu thlǝr nyi, ǝnggǝr kǝra Hyal ɓǝliya sar sara wu nǝnyi. ");
INSERT INTO mfm_vpl VALUES ("HB4_11","088_4_11","HEB","4","11","11","Arya kau, kǝl mǝna nǝrdzau, aga mǝna uya gwu ɓǝlsara nyi, a sara vanyi nda tini gwa, arya mǝn gǝra ɓǝlari ndǝr Hyal ǝnggǝr njira tǝrabiya. ");
INSERT INTO mfm_vpl VALUES ("HB4_12","088_4_12","HEB","4","12","12","Ara ndǝr Hyal mbǝmbǝɗǝ nga ja, ǝnga dǝnama, naja ndiya kalar katsakǝr miya mǝthlǝu, ju sǝn tsaviya dzǝ ba ja vuwa tǝkǝbiya vira pi ǝnga mambǝl ɓǝ ari, ǝnga tsu pama mǝdǝla ǝnga sahwa, ju sǝn tǝtǝkǝbiya ɗǝnga ǝnga ɗǝfu. ");
INSERT INTO mfm_vpl VALUES ("HB4_13","088_4_13","HEB","4","13","13","Sǝ aˈyi kǝra nji mǝliya, kǝra ɗa ɗǝɗǝwa ara Hyal mai, ara kalar sǝ ar babal nga nyi anǝ nyi. Patǝr sǝ hyahya ar babal nga nyi wu mwa nyi, ndǝra mǝnu nda lǝri sǝr mǝla mǝn wu mwa nyi. ");
INSERT INTO mfm_vpl VALUES ("HB4_14","088_4_14","HEB","4","14","14","Ta ɗa aˈyi mǝn ǝnga madiya Pubu kǝra ndiya ǝnga Dǝgalǝu, ndǝra maˈyi a dumwar Hyal, naja ngǝ Yesu Zǝr Hyal, bǝgǝ mǝna taˈyi ar kǝra sǝra mǝn hǝnggǝri. ");
INSERT INTO mfm_vpl VALUES ("HB4_15","088_4_15","HEB","4","15","15","Ara Pubu kǝra ndiya ǝnga Dǝgal kǝra aˈyi ara mǝn kau, aˈyi ndǝra gǝra ǝnga tǝhuɗu ǝgya njir tǝtǝ dǝnama ngǝ mai, awau, naja ngǝ ndǝra nji dzǝbiya wu kalar lagu kǝra nji dzǝbiya mǝn, ama naji mǝliya bikǝ mai. ");
INSERT INTO mfm_vpl VALUES ("HB4_16","088_4_16","HEB","4","16","16","Agabangau, taˈyi mǝna shili lǝhǝu wu dzǝr tsǝkafǝ nǝ Hyal ǝnga ɗǝfu zǝmǝu, aga mǝna uya tǝhuɗǝ nyi ǝnga tsu ja canǝ mǝn mayiwakur nyi kǝra wu nda dlǝwar mǝn ar pǝci kǝra mǝn wu yiwu dlǝwa dzau. ");
INSERT INTO mfm_vpl VALUES ("HB5_1","088_5_1","HEB","5","1","1","Kalar pubu kǝra ndiya ǝnga dǝgalǝu, ndǝ ngau nji caɗǝbiya nyi sara wu nji, nji fiya nyi aga ja tǝɗǝmwa anǝ nji ar kǝra sǝra nǝ Hyal, aga ja lǝri sǝ nǝ nji anǝ Hyal ba nga tsu hǝna saɗaka ar kǝra bikǝr nji. ");
INSERT INTO mfm_vpl VALUES ("HB5_2","088_5_2","HEB","5","2","2","Naja ndǝra wu sǝn ɓǝ ǝnga njira gǝra sǝn sau nji sasa, arya naja ǝnga kǝrnyi aˈyi ja wu kumǝr dzǝ kǝra tǝtǝwa. ");
INSERT INTO mfm_vpl VALUES ("HB5_3","088_5_3","HEB","5","3","3","Agabangau, a ɗari tsaˈa ja hǝna saɗaka, aˈyi arya bikǝr nji waci mai, ama ara naja ma ndǝr bikǝ nga ja. ");
INSERT INTO mfm_vpl VALUES ("HB5_4","088_5_4","HEB","5","4","4","Ndǝr sǝn hǝr kǝrnyi a dar vi dǝgal kǝ aˈyi mai, kǝl ma Hyal ngǝ ngga nyi a dari, ǝnggǝr kǝra nji ngga Haruna. ");
INSERT INTO mfm_vpl VALUES ("HB5_5","088_5_5","HEB","5","5","5","Abangǝ tsu, Kǝrsiti aˈyi hǝr kǝrnyi a dar vi dǝgal aga ja ɗa Pubu kǝra ndiya ǝnga Dǝgal mai, kǝl ta Hyal hǝr nyi, kǝ ji na anǝ nyi, “Nagǝ Zǝr Ɗa ngau, Əshina a ɗar yi Dǝngau.” ");
INSERT INTO mfm_vpl VALUES ("HB5_6","088_5_6","HEB","5","6","6","Ənggǝra ji ɓǝra na ar vanyi vi, “Nagǝ Pubu ngau nǝ baˈanuwa, kǝra lagur Malkizadakǝu.” ");
INSERT INTO mfm_vpl VALUES ("HB5_7","088_5_7","HEB","5","7","7","Ar pǝcira Yesu tsu wu duniya, ju kǝdi Hyal ǝnga kǝdi daɓǝ ǝnga ɓwakǝr ǝnga tiwi gagaɗǝ daɓǝ ǝnga sǝlǝm, anǝ ndǝra ǝnga dǝnama ndǝra wu sǝn mbǝliya nyi sara wu miya tau. Arya naja ndǝr hivǝr Hyal, kǝ Hyal nggari kǝdi nyi. ");
INSERT INTO mfm_vpl VALUES ("HB5_8","088_5_8","HEB","5","8","8","Alaga kau, Yesu zǝr Hyal ngau, ji highiɓǝr ɓǝlar sǝ lagur ɓwaɓwatǝˈyar kǝra ji sa. ");
INSERT INTO mfm_vpl VALUES ("HB5_9","088_5_9","HEB","5","9","9","Lagu kau, ngǝ Hyal nyabiya nyi aga ja ɗa lagu nǝ uya mbǝɗǝ nǝ baˈanuwa anǝ patǝr njira ɓǝlar sǝra ji na. ");
INSERT INTO mfm_vpl VALUES ("HB5_10","088_5_10","HEB","5","10","10","Arya kǝ ngǝ Hyal fiya nyi ji ɗa Pubu kǝra ndiya ǝnga Dǝgalǝu, ǝnggǝr nǝ Malkizadakǝu. ");
INSERT INTO mfm_vpl VALUES ("HB5_11","088_5_11","HEB","5","11","11","Sǝ aˈyi gangǝu kǝra ˈya kyaga na ar kǝra sǝˈyar kau, ama dzadzau nga nyi ˈya sǝn gǝlabiya nda, arya nahyi aˈyi yiwu hya nggabiya sǝ ar kǝra ndǝshigu kǝ kusakusa mai. ");
INSERT INTO mfm_vpl VALUES ("HB5_12","088_5_12","HEB","5","12","12","Alaga kǝ pǝci kǝ ǝshina, hya kyaga nda ɗa malǝmǝ highiɓau, kwalaga abangau, hya vǝr yiwu vanyi ndǝ a ɓǝra highiɓǝ anǝ hyi sǝr nu nǝ tanggǝrma ar kǝra Ndǝr Hyal wayu. Sǝra tsaˈa aga hyi ca ngǝ uˈwa, ama aˈyi sǝr sǝm kǝra ɓaɓal mai. ");
INSERT INTO mfm_vpl VALUES ("HB5_13","088_5_13","HEB","5","13","13","Arya kalar ndǝra uˈwa ngǝ sǝr sǝm nyi, zǝr mamanji nga ja, naji ɗa tsaˈa aga dlǝwu highiɓǝ ar kǝra tsapǝkur mai. ");
INSERT INTO mfm_vpl VALUES ("HB5_14","088_5_14","HEB","5","14","14","Ama sǝr sǝm kǝra ɓaɓalu, nǝ njira hǝhǝ ngau, ca ngǝ njira hwathliya kǝrnda aga nda tǝkǝbiya sǝra mǝnahǝu ǝnga sǝra ɗǝmwaˈyu. ");
INSERT INTO mfm_vpl VALUES ("HB6_1","088_6_1","HEB","6","1","1","Agabangau, kǝl mǝna hǝbiya dzau adabanga highiɓǝ nǝ tanggǝrma kǝra mǝn dlǝwuri ar kǝra Kǝrsiti, aga mǝna dumwa ǝnga ɓǝra nggabiya highiɓǝ nyi, a sara mǝna sha a gyu yukuɗu lagur highiɓǝ ar kǝra tubi sara wu sǝra wu shili ǝnga tau, ba nǝ mbǝrsa anǝ Hyal, ");
INSERT INTO mfm_vpl VALUES ("HB6_2","088_6_2","HEB","6","2","2","ba nga highiɓǝ ar kǝra baɓǝtizǝma daɓǝ ǝnga fǝ tsi, ǝnga hyaˈari sara a vir tau, ba gwu numa kǝra gǝra kuɗau. ");
INSERT INTO mfm_vpl VALUES ("HB6_3","088_6_3","HEB","6","3","3","Namǝn wu dumwa ǝnga nggabiya highiɓǝ nyi ma Hyal yiwu. ");
INSERT INTO mfm_vpl VALUES ("HB6_4","088_6_4","HEB","6","4","4","Wu nda ɗa sǝ gǝra ɗa, anǝ njira ɗahari mbǝmbǝl nǝ Hyal, ǝnga njira ɗahari lǝr sǝ lǝlǝ nǝ Hyal, ba njira ɗahari Mambǝl Cicau ");
INSERT INTO mfm_vpl VALUES ("HB6_5","088_6_5","HEB","6","5","5","ǝnga njira ɗahari mǝsahǝkur Ndǝr Hyal, ǝnga dǝnama nggyabiya zaman kǝra wu shili, ");
INSERT INTO mfm_vpl VALUES ("HB6_6","088_6_6","HEB","6","6","6","ma ndǝ tana ar lagu, ndǝr sǝn shabiya nyi a shili aga ja tubi aˈyi mai. Lagur nggyabiyar nda kau, nga ndu ɓǝra dlakǝya Zǝr Hyal nǝ mǝthlǝkura nyi, ba nda dzǝgwa pǝlna nyi pǝzhi ar sugu. ");
INSERT INTO mfm_vpl VALUES ("HB6_7","088_6_7","HEB","6","7","7","ˈYiˈyi ma kǝra a vǝr sa ˈyimir par ar kǝr ar kǝr, ju nda tsǝbiya sǝ thlǝthlǝkaˈyar kǝra wu nda ɗa akkǝri anǝ njir zǝwa nyi, Hyal wu nda fǝnggǝr barka anǝ ˈyiˈya nyi. ");
INSERT INTO mfm_vpl VALUES ("HB6_8","088_6_8","HEB","6","8","8","Ama ma ˈyiˈyi kǝ a vǝr tsǝ shikǝɗi ǝnga jigwalǝu, aˈyi ja ǝnga akkǝri mai, Hyal wu nda shiˈwuna nyi ba nja nggyina nyi wu yukuɗa nyi. ");
INSERT INTO mfm_vpl VALUES ("HB6_9","088_6_9","HEB","6","9","9","Alaga kǝ mǝn na abangau, bazhir ˈwa ɗa ˈyar, a hǝnggǝr ˈya abǝr alenyi sǝra ndiya ǝnga mǝmǝnahǝ kǝra a vǝr shili anǝ hyi ar kǝra mbǝɗau. ");
INSERT INTO mfm_vpl VALUES ("HB6_10","088_6_10","HEB","6","10","10","Hyal aˈyi ndǝ gǝra tsapǝ mai. Naja aˈyi wu nda fari ǝnga thlǝrǝr hyi ǝnga yiwu kǝra hyu ca anǝ Hyal, lagur dlǝwa dzǝ wu yiwukur anǝ nji cici nyi mai, ǝnggǝr kǝra hya vǝr mǝl kabangǝkau. ");
INSERT INTO mfm_vpl VALUES ("HB6_11","088_6_11","HEB","6","11","11","Sǝra ˈyu yiwu gagaɗau, ca ngǝ, abǝr, hya nggya wu kwakwaɗǝkur wu thlǝrǝr hyi baˈanǝ shili ar jomǝya ndǝl, aga fǝrkǝr hyi a sa nyabiya dzau. ");
INSERT INTO mfm_vpl VALUES ("HB6_12","088_6_12","HEB","6","12","12","Hya sara ɗa nji haɗǝwa mai, ama hya faˈabiya hiya njira wu faˈabiya ki ǝnga sǝra Hyal mǝliya alkawala nyi lagur mbǝrsa ǝnga mba ɗǝfu. ");
INSERT INTO mfm_vpl VALUES ("HB6_13","088_6_13","HEB","6","13","13","Ar pǝci kǝra Hyal mǝliya alkawal anǝ Ibrahimu, vanyi ndǝ aˈyi kǝra a ndiya nyi kǝra ja sǝm fǝla ǝnga thlǝmǝ nyi mai, ba ji sǝmku fǝla ǝnga kǝrnyi. ");
INSERT INTO mfm_vpl VALUES ("HB6_14","088_6_14","HEB","6","14","14","Kǝ Hyal na, “Jijiri yu fǝnggǝr ngǝ barka, yu mǝliya culi ngǝ gangǝu.” ");
INSERT INTO mfm_vpl VALUES ("HB6_15","088_6_15","HEB","6","15","15","Agabangau, lagur sǝkǝbiya wu mba ɗǝfu ngǝ Ibrahimu dlǝwuri nyabiya dzǝ nǝ alkawala nyi. ");
INSERT INTO mfm_vpl VALUES ("HB6_16","088_6_16","HEB","6","16","16","Jijiri nju sǝm fǝla ǝnga ndǝra wu ndiya nda, ǝnga sǝm fǝla ca ngu shili ǝnga hǝnggǝri kǝra gǝra ǝnga kǝpal. ");
INSERT INTO mfm_vpl VALUES ("HB6_17","088_6_17","HEB","6","17","17","Arya Hyal wu yiwu ja cabiya nggyabiya nyi kǝra gǝra bǝlar dzǝ ar babal anǝ njir faˈa ki nǝ alkawal, kǝl ta ji ɓǝra jigǝbiya ǝnga sǝm fǝla. ");
INSERT INTO mfm_vpl VALUES ("HB6_18","088_6_18","HEB","6","18","18","Hyal mǝl abangau, aga sǝm fǝla nyi ǝnga alkawal nyi, nda nyabiya dzau. Ənggǝr kǝra mǝn wu sǝni abǝr Hyal wu thla fati mai. Ma mǝn hwi a ndu dǝla nyi, mǝn wu nggya ǝnga fǝ ɗǝfu aga mǝna sǝɓiya ɓaɓalu fǝr kǝr kǝra ji nǝ mǝn. ");
INSERT INTO mfm_vpl VALUES ("HB6_19","088_6_19","HEB","6","19","19","Fǝrkǝr kǝra mǝn ǝni kau, ǝnggǝr mǝca tǝghǝ pi kǝra wu tǝghǝr mǝn ɓaɓalu. Ənga fǝr kǝr kǝ nga mǝn wu tǝrabiya a biya banga kadǝmbul nǝ vi cici nǝ ki Hyal. ");
INSERT INTO mfm_vpl VALUES ("HB6_20","088_6_20","HEB","6","20","20","Yesu ngǝ gwa wu mwar mǝn ǝnga ji gwa ar viya mǝn. A ɗar ja a nǝ mǝn Pubu kǝra ndiya ǝnga Dǝgalǝu, ǝnggǝr nǝ Malkizadakǝu. ");
INSERT INTO mfm_vpl VALUES ("HB7_1","088_7_1","HEB","7","1","1","Najaka Malkizadakǝu, naja ngǝ tǝl nǝ Salemu, ǝnga tsu pubu nǝ Hyal Kǝra Di. Ji ɓǝ ǝnga Ibrahimu ar pǝci kǝra Ibrahimu a vǝr sha shili sara vǝr pa ǝnga tǝltǝlˈyar kǝra ji sǝmku tǝlkur ar kǝra nda, ba ji fǝnggǝr nyi barka. ");
INSERT INTO mfm_vpl VALUES ("HB7_2","088_7_2","HEB","7","2","2","Kǝ Ibrahimu nǝ nyi pathlǝu wu kumou nǝ kalar sǝra ji faˈari sara a gwa miya pa. Tanggǝrma, sǝra thlǝmǝ kǝ cabiya ca ngǝ, “Tǝl nǝ tsapǝkur.” Ənga naja tsu “Tǝl nǝ Salemu,” kǝra cabiya, “Tǝl nǝ jamǝkur.” ");
INSERT INTO mfm_vpl VALUES ("HB7_3","088_7_3","HEB","7","3","3","Naja aˈyi ǝnga njir ya mai. Aˈyi ja ǝnga culi kǝra ji biya a gwa mai. Aˈyi ja ǝnga pǝcir ya ǝnga pǝcir tǝ mai. Naja tsu ǝnggǝr Zǝr Hyal, kǝra nggya aga pubu baˈanuwa. ");
INSERT INTO mfm_vpl VALUES ("HB7_4","088_7_4","HEB","7","4","4","Hya tsamiya culi dǝgalkura ja! Kwalaga ǝjiya ǝjir mǝn Ibrahimu tsu nǝ nyi pathlǝu wu kumou nǝ kalar sǝra ji faˈari sara a gwa miya pa! ");
INSERT INTO mfm_vpl VALUES ("HB7_5","088_7_5","HEB","7","5","5","Ətsu highiɓǝ Musa a nana ri, abǝr kalar ndǝr Lawi kǝra ɗa pubu, a ɗar tsaˈa ja dlǝwuri pathlǝu wu sǝ kumou sara ara nji, alaga kǝ nji kǝ zamǝr nda ngǝ ˈyar, ǝnga tsu nanda ma culi gǝ Ibrahimu nga nda. ");
INSERT INTO mfm_vpl VALUES ("HB7_6","088_7_6","HEB","7","6","6","Ama Malkizadakǝu, ndǝra aˈyi biya sara wu culi nji gǝ Lawi mai, a dlǝwuri ja pathlǝu wu sǝ kumou sara ara Ibrahimu, ba ji fǝnggǝr nyi barka, naja ndǝra nji nǝ nyi alkawala nyiˈyar. ");
INSERT INTO mfm_vpl VALUES ("HB7_7","088_7_7","HEB","7","7","7","Gǝra ǝnga kǝpal ndǝra wu fǝ barka naja ndiya ndǝra nji fǝnggǝr nyi barka. ");
INSERT INTO mfm_vpl VALUES ("HB7_8","088_7_8","HEB","7","8","8","Kǝja njir Lawi njir dlǝwu pathlǝu wu sǝ kumou, ndu tau. Ama Malkizadakǝu nǝ nyi ndǝra dlǝwuri pathlǝu wu sǝ kumou sara ara Ibrahimu, nji lǝr sakida ar kǝra ja abǝr naja aˈyi tǝ mai. ");
INSERT INTO mfm_vpl VALUES ("HB7_9","088_7_9","HEB","7","9","9","Nju sǝn na abǝr Lawi ǝnga kǝrnyi, ndǝra culi nyi ngǝ njir dlǝwu pathlǝu wu sǝ kumou, a lǝr ja nǝ nyi pathlǝu wu sǝ kumou lagu Ibrahimu, ");
INSERT INTO mfm_vpl VALUES ("HB7_10","088_7_10","HEB","7","10","10","ara ar pǝci kǝra Malkizadakǝu ɓǝ ǝnga Ibrahimu, Lawi tsu ja wu dza ǝjiya ǝji nyi. ");
INSERT INTO mfm_vpl VALUES ("HB7_11","088_7_11","HEB","7","11","11","Kǝja dlaɗǝ Musa a cabiyari anǝ njir Izirayila abǝr kalar pubu ja biya sara wu culi gǝ Lawi. Maja abǝr thlǝr pubuˈyar nǝ culi gǝ Lawi wu mǝliya nji a ɗa nji tsapǝu, sǝr ɓǝra ɗa nja dla ǝnga vanyi pubu pamǝ lagu Malkizadakǝu aˈyi mai, kǝra aˈyi lagu Haruna mai. ");
INSERT INTO mfm_vpl VALUES ("HB7_12","088_7_12","HEB","7","12","12","Arya ma nji bǝlana lagur fǝ ndu pubukur, kǝl nja bǝlana dlaɗǝ tsu. ");
INSERT INTO mfm_vpl VALUES ("HB7_13","088_7_13","HEB","7","13","13","Naja ndǝra nja vǝr ndǝr ar kǝri kau, Thlagǝr mǝn ngau, naja ji biya sara wu culi pamǝu, culi kǝra gǝra saya mǝl thlǝr nǝ pubu. ");
INSERT INTO mfm_vpl VALUES ("HB7_14","088_7_14","HEB","7","14","14","Kadzakadzangǝ nga nyi, abǝr Thlagǝr mǝn biya sara wu culi gǝ Yahuda, laguwa culi kǝ tsu Musa aˈyi ndǝr ar kǝra nda lagu pubukur mai. ");
INSERT INTO mfm_vpl VALUES ("HB7_15","088_7_15","HEB","7","15","15","Najaka ndǝr tsu a biyari ar babal gagaɗau, ar pǝci kǝra vanyi ndǝ ɓǝra biya pubu pamǝ ǝnggǝr kǝra Malkizadakǝu, ");
INSERT INTO mfm_vpl VALUES ("HB7_16","088_7_16","HEB","7","16","16","ndǝra ɗa pubu, aˈyi lagu dlaɗǝ ǝnga culi kǝra ji biya sara a gwa mai, ama lagu dǝnama nǝ pi gǝra kuɗau. ");
INSERT INTO mfm_vpl VALUES ("HB7_17","088_7_17","HEB","7","17","17","Arya nji lǝr sakida ar kǝra ja abǝr, “Nagǝ ngǝ pubu nǝ baˈanuwa, kǝra lagur Malkizadakǝu.” ");
INSERT INTO mfm_vpl VALUES ("HB7_18","088_7_18","HEB","7","18","18","Nji hǝna dlaɗǝ kǝra ɗǝɗǝmǝu, ara gǝra dǝnamakur nyi ǝnga dlǝwa dzǝ nyi. ");
INSERT INTO mfm_vpl VALUES ("HB7_19","088_7_19","HEB","7","19","19","Arya dlaɗǝ Musa aˈyi kakalǝ ja mǝliya sǝ tsatsaˈa mai, ama kabangǝkau, fǝr kǝr aˈyi kǝra wu hǝr mǝn lǝhǝ a shila dzǝr Hyal. ");
INSERT INTO mfm_vpl VALUES ("HB7_20","088_7_20","HEB","7","20","20","Hyal nyabiya sǝ kau, lagur sǝm fǝla. Patǝr njira gu thlǝr pubu aˈyi lagur sǝm fǝla mai. ");
INSERT INTO mfm_vpl VALUES ("HB7_21","088_7_21","HEB","7","21","21","Ama ndǝ kǝ ɗa pubu lagur sǝm fǝla ar pǝci kǝra Hyal na anǝ nyi, “Thlagǝu a sǝmkur fǝla, naja aˈyi wu bǝla ɗǝnga nyi mai, ‘Nagǝ pubu ngau, nǝ baˈanuwa.’ ” ");
INSERT INTO mfm_vpl VALUES ("HB7_22","088_7_22","HEB","7","22","22","Arya najaka sǝm fǝla ngǝ Yesu nggya ar viya sǝr mbabiya nǝ alkawal mbamba kǝra ndiya ǝnga mǝnahǝu. ");
INSERT INTO mfm_vpl VALUES ("HB7_23","088_7_23","HEB","7","23","23","Pubuˈyar nǝ ɗǝɗǝmǝu, ndǝ ɗa gangǝ ara tǝ ngǝ kar nda ara dumwa ǝnga thlǝr nda parangǝu. ");
INSERT INTO mfm_vpl VALUES ("HB7_24","088_7_24","HEB","7","24","24","Ama Yesu ngǝ pubu nǝ baˈanuwa, arya naja ǝnga kǝrnyi aˈyi ja ǝnga pi baˈanuwa. ");
INSERT INTO mfm_vpl VALUES ("HB7_25","088_7_25","HEB","7","25","25","Agabangau, aˈyi ja cumu ǝnga dǝnama nǝ mbǝɗana njira shili lǝhǝu wu dzǝr Hyal lagu nyi, ara aˈyi ja cumu ǝnga pi ba ju dumwa ǝnga kǝdi Hyal anǝ nda. ");
INSERT INTO mfm_vpl VALUES ("HB7_26","088_7_26","HEB","7","26","26","Culi najaka pubu kǝra ndiya ǝnga dǝgal nga mǝnu yiwu, ndǝ kǝra cicau, ǝnga ndǝra gǝra bikau, gǝra ǝnga mǝcaviɗi, ǝnga ndǝra nji hǝbiya sara wu njir bikau ba nji hǝna nyi adabanga dǝmǝlmǝˈyar. ");
INSERT INTO mfm_vpl VALUES ("HB7_27","088_7_27","HEB","7","27","27","Aˈyi ja ǝnggǝr pubu kǝra ndiya ǝnga dǝdǝgal ta mai, arya aˈyi mbari kǝl ja lǝr saɗaka kalar pǝci mai, tanggǝrma arya bikǝ nyi, ǝnga arya bikǝ nǝ nji. Naja ji lǝr saɗaka nyi zǝmǝ pir ar pǝci kǝra ji lǝr kǝrnyi. ");
INSERT INTO mfm_vpl VALUES ("HB7_28","088_7_28","HEB","7","28","28","Arya dlaɗǝ Musa ngǝ mǝliya nju caɗǝ pubu kǝra ndiya ǝnga dǝdǝgalˈyar sara wu nji ǝnga tǝtǝwakur nda. Ama alkawal Hyal kǝra shili daɓǝ ǝnga sǝm fǝla ngǝ caɗǝbiya Zǝr nyi kǝra naja ngǝ tsatsaˈa baˈanuwa. Alkawal kau ca ngǝ kǝra shili ayukuɗa dlaɗau. ");
INSERT INTO mfm_vpl VALUES ("HB8_1","088_8_1","HEB","8","1","1","Sǝra mǝnu yiwu mǝna na ca ngǝ, aˈyi mǝn ǝnga pubu abangau, pubu kǝra ndiya ǝnga dǝgal kǝra a vǝr nggya ar tsi mazǝma tsǝkafǝ nǝ Ndǝ Dǝgal Dǝnama a dǝmǝlmau. ");
INSERT INTO mfm_vpl VALUES ("HB8_2","088_8_2","HEB","8","2","2","Ndǝra vǝr mǝl thlǝr ar vi kǝra ndiya ǝnga Cicau, kwapatǝ kǝra jijiri kǝra Thlagǝ ǝnga kǝrnyi ngǝ liya ama aˈyi ndǝ mai. ");
INSERT INTO mfm_vpl VALUES ("HB8_3","088_8_3","HEB","8","3","3","Kalar pubu kǝra ndiya ǝnga dǝgalǝu, nji fiya nyi aga hǝ saɗaka ǝnga lǝ sǝ lǝlau, agabangau, najaka pubu kǝra ndiya ǝnga dǝgalǝ tsu, a mbari kǝl ja lǝr sau. ");
INSERT INTO mfm_vpl VALUES ("HB8_4","088_8_4","HEB","8","4","4","Maja abǝr wu duniya nga ja, ju sǝn ɗa pubu mai, ara tsu kaɗu pubuˈyar aˈyi kǝra a vǝr lǝ sau ǝnggǝr kǝra dlaɗǝ nana. ");
INSERT INTO mfm_vpl VALUES ("HB8_5","088_8_5","HEB","8","5","5","Sǝra pubuˈyar ka vǝr mǝl a vu vi cici nǝ Hyal kau, tangǝ ǝnggǝr sǝra nja vǝr mǝl a dǝmǝlmau. Ca ngǝ sǝra Hyal kughiya Musa aga ja hǝriya kwapatǝ anǝ Thlagǝu, ǝnggǝr kǝra ji cabiya nyi. Ji na, “Ga tsamǝ ǝnga hangǝkal, aga ga liya kakalǝ ǝnggǝr kǝra yi cabiya ngau, a du mǝ ta.” ");
INSERT INTO mfm_vpl VALUES ("HB8_6","088_8_6","HEB","8","6","6","Ama thlǝr kǝra Yesu dlǝwuri a ndiyari nǝr nda, arya alkawal mbamba kǝra naja ngǝ tsupamǝ kǝra ndiya hahala nyi ta, arya alkawal mbamba nyi nji mbiya ar alkawal kǝra ndiya. ");
INSERT INTO mfm_vpl VALUES ("HB8_7","088_8_7","HEB","8","7","7","Maja abǝr alkawal mbamba nǝ tanggǝrma aˈyi tuwa mai, aˈyi nju ɓǝra gal nǝ mǝthlǝkura nyi kǝra ndiya mai. ");
INSERT INTO mfm_vpl VALUES ("HB8_8","088_8_8","HEB","8","8","8","Ta Hyal lari bikǝr nda, ba ji na, “Pǝci wu shili, ǝngwar Thlagǝu, yu nda mǝliya alkawal mbamba nǝ mafǝliyangǝ ǝnga njir Izirayila, ba ǝnga tsu culi Yahuda. ");
INSERT INTO mfm_vpl VALUES ("HB8_9","088_8_9","HEB","8","9","9","Aˈyi culi alkawal mbamba kǝra yi mǝl ǝnga ǝjir ndaˈyar mai, ar pǝci kǝra yi mbar pǝla nda aga ya hǝbiya nda sara wu ˈyiˈyir Masaru, arya nanda aˈyi taˈyi ǝnga alkawal ɗa mai, ca ngǝ ɗa yi tǝkǝ ǝnga nda, ǝngwar Thlagǝu. ");
INSERT INTO mfm_vpl VALUES ("HB8_10","088_8_10","HEB","8","10","10","Najakǝ ngǝ alkawal mbamba kǝra yu sa mǝl ǝnga njir Izirayila, ayukuɗa pidaˈyar kau, ǝngwar Thlagǝu, yu fuwa highiɓǝ ɗa wu ɗǝfuwa nda. Yu tsǝfǝri wu huɗa nda. Yu nggya Hyalǝr nda, nanda tsu ndu nggya nji ɗa. ");
INSERT INTO mfm_vpl VALUES ("HB8_11","088_8_11","HEB","8","11","11","Aˈyi kǝl ndǝ a highiɓǝ anǝ tǝwul nyi mai, alaga zamǝ nyi, ju na, ‘Ga sǝn Thlagǝu,’ Arya kalar ndu sa sǝn ɗa, dzǝguya ar kusha nda baˈanǝ dǝgala nda. ");
INSERT INTO mfm_vpl VALUES ("HB8_12","088_8_12","HEB","8","12","12","Ara yu sa tǝfǝbiya nda bikǝr nda aˈyi tsu yu ɓǝra ɗǝngari ǝnga sǝ ndzǝndzǝr nda mai.” ");
INSERT INTO mfm_vpl VALUES ("HB8_13","088_8_13","HEB","8","13","13","Ta Hyal ngga kau, ǝnga alkawal mbamba mafǝliyangǝu, a cabiyari abǝr nǝ tanggǝrma ta a hiliri ba ji hal. Sǝra hil ǝnga sǝra hal wu sǝkar mai, ba ja tǝrabiya kabangǝkau. ");
INSERT INTO mfm_vpl VALUES ("HB9_1","088_9_1","HEB","9","1","1","Alkawal mbamba nǝ tanggǝrma aˈyi ja ǝnga sǝra nja kyaga mǝl nǝ dlǝvau. Alkawal mbamba nǝ tanggǝrma kǝ tsu, vi aˈyi a gwa kǝra cici kǝra nji hǝriya wu duniya. ");
INSERT INTO mfm_vpl VALUES ("HB9_2","088_9_2","HEB","9","2","2","Nji pǝdlǝya kwapatǝu, wu kwapatǝ kau, kǝ nji tǝkǝya bwata mǝthlǝu. Ar bwata nǝ tanggǝrma sǝr sǝɓǝ pitǝlla aˈyi, ǝnga tǝmbǝl, ba ǝnga lǝgu macikǝl kǝra nji nǝ nyi anǝ Hyal. Bwata kau, nga nju ngga ǝnga Vi Cicau. ");
INSERT INTO mfm_vpl VALUES ("HB9_3","088_9_3","HEB","9","3","3","Ayukuɗa kadǝmbul nǝ mǝthlǝkura nyi, vanyi vi aˈyi kǝra nja ngga ǝnga Vi kǝra ndiya ǝnga Cicau. ");
INSERT INTO mfm_vpl VALUES ("HB9_4","088_9_4","HEB","9","4","4","Ar bwata nǝ mǝthlǝkura nyi bagadi aˈyi nǝ ǝndzǝ nǝ nggyi sǝ kisu, ǝnga akwati alkawal mbamba kǝra nji haɗiya ǝnga ǝndzau. Akwati kau, kǝja sǝra a gu gwa, pǝla ǝndzǝ nǝ fǝ mana, ǝnga dǝla nǝ Haruna kǝra thlau, ba nga tsǝka kǝra alkawal mbamba kǝ tsǝtsǝfǝ ari. ");
INSERT INTO mfm_vpl VALUES ("HB9_5","088_9_5","HEB","9","5","5","A dar kǝra akwati alkawal mbamba kau, shangguɗi hǝhǝr nǝ carabiyamǝu aˈyi kǝra wu cabiya kadakadarkur nǝ Hyal. Nanda ngǝ mǝliya shangguɗi anǝ sǝr haɗǝ miya akwati kau, kǝra nju ngga ǝnga vir nggya tǝhuɗu. Namǝn a sǝn ndǝr ar kǝra sǝˈyar kǝ kwatahǝ mai. ");
INSERT INTO mfm_vpl VALUES ("HB9_6","088_9_6","HEB","9","6","6","Ma nja fuwar sǝ wu lagu ǝnggǝr kau, ba pubuˈyar a gu bwata tanggǝrma ǝnggǝr kǝra ndu wuraga mǝl thlǝr nda. ");
INSERT INTO mfm_vpl VALUES ("HB9_7","088_9_7","HEB","9","7","7","Ama kǝl pubu kǝra ndiya ǝnga dǝgal ngu gu bwata mǝthlǝkura nyi kǝra gwa gwa, zǝmǝ wu fa. Naja sǝn gwa gǝra ǝnga mashi mai, aga tǝfǝbiya bikǝ nyi ǝnga kǝra nji mǝliya ǝnga gǝra sǝnkur nda. ");
INSERT INTO mfm_vpl VALUES ("HB9_8","088_9_8","HEB","9","8","8","Lagu kǝ ngǝ Mambǝl Cici cabiya abǝr, lagur gwu Vi kǝra Ndiya ǝnga Cicau aˈyi pahǝnakǝr kwatahǝ mai, ma tsu bwata tanggǝrma tsu taˈyiu. ");
INSERT INTO mfm_vpl VALUES ("HB9_9","088_9_9","HEB","9","9","9","Sǝˈyar kǝ patǝ aga nda gǝlabiya nggyabiya ǝshina, kǝra wu cabiya abǝr lǝ sau ǝnga hǝ saɗaka a sǝn shili ǝnga nggyabiya nǝ kǝr papal anǝ njir dlǝvǝ Hyal mai. ");
INSERT INTO mfm_vpl VALUES ("HB9_10","088_9_10","HEB","9","10","10","Sǝˈyar kau, ar kǝra sǝm ǝnga sa ba ǝnga ci dzau nga nda wacu. Thlǝr kau, a biyar babal nga nda wacu, kǝl ta Hyal nda canǝ mǝn lagur mǝl thlǝr nǝ mafǝliyangǝu. ");
INSERT INTO mfm_vpl VALUES ("HB9_11","088_9_11","HEB","9","11","11","Kǝja Kǝrsiti a shiliri ǝnggǝr Pubu kǝra ndiya ǝnga dǝgalǝu, nǝ sǝ mǝmǝnahǝˈyar kǝra aˈyi kabangǝkau. Ji shili, kǝ ji sa gu kwapatǝ kǝra ndiya ǝnga dǝgalǝu, ǝnga kǝra ndiya ǝnga tsatsaˈa, aˈyi kǝra nji hǝriya ǝnga tsi mai, kǝra cabiya aˈyi nǝ duniya kǝ mai. ");
INSERT INTO mfm_vpl VALUES ("HB9_12","088_9_12","HEB","9","12","12","Ji gwu vi kǝra ndiya ǝnga Cici kau, aga zǝmǝ pathlǝu. Naja aˈyi gwa ǝnga mashi kuˈyar ǝnga nǝ wazha thla mai, ama ǝnga mashi nyi nga ji gwa, kǝra ji bǝliya mǝn ǝni nǝ baˈanuwa. ");
INSERT INTO mfm_vpl VALUES ("HB9_13","088_9_13","HEB","9","13","13","Mashi nǝ kuˈyar, ǝnga thlaˈyar ba ǝnga bǝbǝr nǝ mbǝhulǝu, nju uˈuci sǝˈyar kǝ a ndar njira gǝra cicau, aga ja mǝliya nda cicau a biyar cicir dzau. ");
INSERT INTO mfm_vpl VALUES ("HB9_14","088_9_14","HEB","9","14","14","Ma abangǝ ja, mi nga mǝna sǝn na ǝnga mashi Kǝrsiti kǝra wu ndiya nda pata? Ndǝra gǝra ǝnga mǝcaviɗi, lagur dǝnamar Mambǝl Cici nǝ baˈanuwa nga ji lǝr kǝrnyi aga saɗaka kǝra tsatsaˈa anǝ Hyal. Ji mǝl abangau, aga ja cina ɗǝngar mǝn sara ara sǝr mǝla mǝn kǝra ɗǝmwaˈyu kǝra wu shili ǝnga tau aga mǝna ɗa njir dlǝvǝ Hyal mbǝmbǝɗau. ");
INSERT INTO mfm_vpl VALUES ("HB9_15","088_9_15","HEB","9","15","15","Agabangau, Kǝrsiti naja ngǝ ndǝra wu taˈyi wu pama nji ǝnga Hyal wu najaka alkawal mbamba kǝra mafǝliyangǝu. Aga kalar njira nji ngga ba nda dlǝwuri alkawal nǝ faˈa ki nǝ baˈanuwa kǝra Hyal mǝliya alkawala nyi. Ta ɗa a tǝr ja, tǝ nyi bǝliya nda sara wu bikǝr nda kǝra ndǝ mǝliya wu pǝcir alkawal nǝ tanggǝrma. ");
INSERT INTO mfm_vpl VALUES ("HB9_16","088_9_16","HEB","9","16","16","Ma ndǝ mǝliya alkawal ar kǝra sǝr faˈa ki, faˈa kiya nyi wu nyabiya dzǝ ma nja lar tǝtǝkura ja. ");
INSERT INTO mfm_vpl VALUES ("HB9_17","088_9_17","HEB","9","17","17","Arya alkawal faˈa ki aˈyi ja ǝnga dǝnama mai kǝl ma nda nyi a tǝri, ca ngǝ gyiwuliya mǝliya sǝkǝ aˈyi mai ma tsu nda nyi ǝnga pi. ");
INSERT INTO mfm_vpl VALUES ("HB9_18","088_9_18","HEB","9","18","18","Ca ngǝ sǝra ɗa alkawal mbamba nǝ tanggǝrma aˈyi nji hǝnggǝri ǝni mai, kǝl lagu mashi. ");
INSERT INTO mfm_vpl VALUES ("HB9_19","088_9_19","HEB","9","19","19","Ca ngǝ sǝra ɗa Musa nana anǝ nji papatǝu sǝr mǝl kǝra aˈyi wu dlaɗau, kǝ ji hǝri mashi wazha thla ǝnga nǝ kuˈyar, ba ji daɓǝri ǝnga ˈyimi. Ənga ji hǝr sasaˈwa ǝpa ǝpa, kǝ ji pǝɗiya a yar hyali wur hisopǝu aga ja dzǝgwa uci mashi tǝmahǝu a ndar kǝra Lǝkakaɗǝ pǝpǝɗau ba a ndar kǝra nji papatǝu ǝni. ");
INSERT INTO mfm_vpl VALUES ("HB9_20","088_9_20","HEB","9","20","20","Kǝ ji na, “Najakǝ ngǝ mashi nǝ hǝnggǝri ǝnga alkawal mbamba kǝra Hyal lǝri hyi hya ɓǝlari.” ");
INSERT INTO mfm_vpl VALUES ("HB9_21","088_9_21","HEB","9","21","21","Abangǝ tsu ji uˈucina masha nyi ar kǝra kwapatǝ kau, ba tsu ar kǝra patǝr kar thlǝr nǝ kwapata nyi ar pǝcir dlǝvau. ");
INSERT INTO mfm_vpl VALUES ("HB9_22","088_9_22","HEB","9","22","22","Ənga jiri dlaɗǝ nǝ Musa a cabiyari abǝr kǝl nja cina zada kalar sau ǝnga mashi. Ma aˈyi nji pǝna mashi mai tǝfǝbiya bikǝ aˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("HB9_23","088_9_23","HEB","9","23","23","Sǝˈyar kǝ nda nggya shangguɗi hǝhǝr nǝ sǝra a dǝmǝlmau, a mbari nda ɗa cicau, lagur hǝ saɗaka ˈyar kǝra wu duniya. Ama sǝra a dǝmǝlmau, ǝnga kǝrnda a mbari nda ɗa cicau, lagur hǝ saɗaka kǝra ndiya patǝu. ");
INSERT INTO mfm_vpl VALUES ("HB9_24","088_9_24","HEB","9","24","24","Arya Kǝrsiti ǝnga kǝrnyi aˈyi gwu Vira ndiya ǝnga Cicau, kǝra ndapi ngǝ hǝriya mai, kǝra ndǝ hǝriya a papa nǝ jijira nyi. Awau, ji maˈyi, ji da gwu vira ndiya ǝnga cicau a dǝmǝlmau ǝnga kǝrnyi, a dǝgya Hyal arya mǝn. ");
INSERT INTO mfm_vpl VALUES ("HB9_25","088_9_25","HEB","9","25","25","Ənga aˈyi ji da gwu vira ndiya ǝnga cicau a dǝmǝlmau aga ja nda lǝr kǝrnyi ar kǝr ar kǝr mai, ǝnggǝr kǝra pubu kǝra ndiya ǝnga dǝgal wu duniya kǝra gwu Vira ndiya ǝnga Cicau fa nga fa ǝnga mashi nǝ maˈwi aˈyi ǝnga mashi nyi mai. ");
INSERT INTO mfm_vpl VALUES ("HB9_26","088_9_26","HEB","9","26","26","Ma abǝr abangǝ nga nyi, Kǝrsiti wu ɓǝra lar ɓwaɓwatǝ ba ja tǝ aga gangǝu, dzǝguya ar ndǝla duniya shili ar ǝshina. Ama shili nyi aga zǝmǝu, aga nji patǝu, ba anǝ kuɗiyar duniya, ji lǝr saɗaka nǝ kǝrnyi aga tǝfǝbiya bikǝr nji. ");
INSERT INTO mfm_vpl VALUES ("HB9_27","088_9_27","HEB","9","27","27","Ənggǝr kǝra Hyal fiya aga nda tau aga zǝmǝ pathlǝu, ayukuɗa tǝ nyi kǝl sǝkǝ numa nǝ Hyal, ");
INSERT INTO mfm_vpl VALUES ("HB9_28","088_9_28","HEB","9","28","28","abangǝ tsu nga nji lǝr Kǝrsiti aga zǝmǝu, aga ja sa hǝna bikǝr nji gangǝu. Naja tsu wu ɓǝra sa shili nǝ mǝthlǝkura nyi, aga sa tǝfǝ bikǝ mai, ama aga ja sa nǝ nyi mbǝɗau anǝ njira wu caguli ǝnga shili nyi. ");
INSERT INTO mfm_vpl VALUES ("HB10_1","088_10_1","HEB","10","1","1","Dlaɗǝ Musa sǝ ngau kǝra ǝnggǝr shangguɗa sǝ mǝnahǝ kǝra a vǝr shili, ama aˈyi cabiya abǝr naja ngǝ sǝ jijiri kǝ mai. Ca ngǝ sǝra ɗa dlaɗa nyi aˈyi a sǝn mǝliya patǝr njira dla lǝhǝ wu dzǝr Hyal nda nggya cici lagur hǝ saɗaka gǝra bǝla kǝra nju mǝl fa ga fa kǝ mai. ");
INSERT INTO mfm_vpl VALUES ("HB10_2","088_10_2","HEB","10","2","2","Maja abǝr dlaɗǝ Musa aˈyi ja ǝnga dǝnama, tsu nju ɓǝra dumwa ǝnga hǝ saɗaka kǝ ya? Maja abǝr njir hǝ saɗaka kau, ndu sǝn uya nggya cicau aga zǝmǝu, tsu ɗǝnga nǝ ɗǝfuwa nda wu ɓǝra ɓwakǝr ara bikǝr nda mai. ");
INSERT INTO mfm_vpl VALUES ("HB10_3","088_10_3","HEB","10","3","3","Ama hǝ saɗaka kau, lagur ɗǝngar nda bikǝr nda ngau, fa ǝnga fa. ");
INSERT INTO mfm_vpl VALUES ("HB10_4","088_10_4","HEB","10","4","4","Arya aˈyi a sǝn ɗa mashi thlaˈyar ǝnga nǝ kuˈyar a sǝn hǝna bikǝ mai. ");
INSERT INTO mfm_vpl VALUES ("HB10_5","088_10_5","HEB","10","5","5","Agabangau, ǝnggǝra Kǝrsiti shili wu duniya, ji na, “Hǝ saɗaka ǝnga lǝ sǝˈyar nagǝ wu yiwu mai, ama kumǝr dzǝ nga gǝ pabǝri anǝ ɗa. ");
INSERT INTO mfm_vpl VALUES ("HB10_6","088_10_6","HEB","10","6","6","Hǝ saɗaka nǝ nggyi sau ǝnga nǝ hǝna bikau nagǝ wu nggar mǝsahǝkur nda mai. ");
INSERT INTO mfm_vpl VALUES ("HB10_7","088_10_7","HEB","10","7","7","Kǝ yi na, ‘Kǝja yau, Hyal, yi shili aga ya sa mǝl sǝra gu yiwu, ǝnggǝr kǝra ja tsǝtsǝfau ar kǝra yau wu lǝkakaɗǝ tsǝtsǝfǝ nǝ Hyal.’ ” ");
INSERT INTO mfm_vpl VALUES ("HB10_8","088_10_8","HEB","10","8","8","Tanggǝrma ji na, “Hǝ saɗaka, ǝnga lǝ sǝˈyar, ǝnga saɗaka nǝ nggyi sau, ǝnga saɗaka nǝ hǝ bikau, nagǝ wu yiwu nda mai, ǝnga nagǝ aˈyi wu nggar mǝsahǝkur nda mai.” Ji na abangau, alaga kau, Dlaɗǝ Musa ngǝ na nja ɓǝlar sǝˈyar kau. ");
INSERT INTO mfm_vpl VALUES ("HB10_9","088_10_9","HEB","10","9","9","Ji ɓǝra na, “ Kǝja yau, yi shili aga ya sa mǝl sǝra gu yiwu.” Ca ngǝ, a fiyar nji sǝ nǝ tanggǝrma ar thlǝrpau, aga nja dzǝgwa ciya nǝ mǝthlǝkura nyi. ");
INSERT INTO mfm_vpl VALUES ("HB10_10","088_10_10","HEB","10","10","10","Lagur sǝra Hyal wu yiwu ca ngǝ tsu a mǝliya mǝnǝr ja cicau, lagu hǝ saɗaka nǝ dza ja kǝra Yesu Kǝrsiti lǝri aga zǝmǝ pathlǝu, kǝra gǝra ǝnga cakau. ");
INSERT INTO mfm_vpl VALUES ("HB10_11","088_10_11","HEB","10","11","11","Wu kalar pǝci, kalar pubu wu taˈyi ju mǝl thlǝr nyi, ju dumwa ǝnga hǝ saɗakaˈyar kǝra gǝra bǝla dzǝ kau, ar kǝr ar kǝr kǝra gǝra ǝnga dǝnama nǝ hǝna bikǝˈyar. ");
INSERT INTO mfm_vpl VALUES ("HB10_12","088_10_12","HEB","10","12","12","Ama ta Kǝrsiti lǝri saɗaka aga zǝmǝu, nǝ baˈanuwa arya bikǝˈyar, ba ji dzǝgwa nggya ar tsi mazǝm nǝ Hyal. ");
INSERT INTO mfm_vpl VALUES ("HB10_13","088_10_13","HEB","10","13","13","Tsu wu pǝci ta ja vǝr sǝkǝ nja sa fiya dawa nyiˈyar a gyi gya kiɗa hiya ja. ");
INSERT INTO mfm_vpl VALUES ("HB10_14","088_10_14","HEB","10","14","14","Arya hǝ saɗaka zǝmǝ kǝ ji mǝliya kau, kǝ ji shabiya njira nji cicina nda, nda nggya tsatsaˈa baˈanuwa. ");
INSERT INTO mfm_vpl VALUES ("HB10_15","088_10_15","HEB","10","15","15","Mambǝl Cici lǝr sakida ar kǝra mǝn ar kǝra sǝˈyar kau. Tanggǝrma, ji na, ");
INSERT INTO mfm_vpl VALUES ("HB10_16","088_10_16","HEB","10","16","16","“Kǝja alkawal mbamba kǝra yu nda mǝl ǝnga nda, ayukuɗa pǝci kau, ǝngwar Thlagǝu. Yu nda fuwa dlaɗǝ ɗa wu ɗǝfuwa nda, ba ya dzǝgwa tsǝfǝri wu ɗǝngar nda.” ");
INSERT INTO mfm_vpl VALUES ("HB10_17","088_10_17","HEB","10","17","17","Ji ɓǝra cakǝri, ji na, “Bikǝr nda ǝnga ndza sǝr nda tsu yu ɓǝra ɗǝngar nda mai.” ");
INSERT INTO mfm_vpl VALUES ("HB10_18","088_10_18","HEB","10","18","18","Ar pǝci kǝra nji tǝfǝbiya bikǝr ndaˈyar, tsu vanyi hǝ saɗaka arya bikǝ aˈyi mai. ");
INSERT INTO mfm_vpl VALUES ("HB10_19","088_10_19","HEB","10","19","19","Agabangau, wazha ama, aˈyi mǝn ǝnga kǝr papal jijiri nǝ gwu Vira Ndiya ǝnga Cicau lagur mashi Yesu. ");
INSERT INTO mfm_vpl VALUES ("HB10_20","088_10_20","HEB","10","20","20","Naja tsu ji pahǝna mǝn lagu mafǝliyangǝ kǝra mbǝmbǝɗau, lagur kadǝmbul kǝra ca ngǝ kumǝr dza ja. ");
INSERT INTO mfm_vpl VALUES ("HB10_21","088_10_21","HEB","10","21","21","Aˈyi mǝn tsu ǝnga pubu kǝra dǝgal a vǝr sǝm tǝlkur ar kǝra ki Hyal. ");
INSERT INTO mfm_vpl VALUES ("HB10_22","088_10_22","HEB","10","22","22","Agabangau, bǝgǝ mǝna shili lǝhǝ wu dzǝr Hyal ǝnga ɗǝfu jijiri, ba ǝnga mbǝrsa kǝra gǝra ǝnga kǝpal. Mǝna shili ǝnga ɗǝfu kǝra nji cina sara wu sǝ sǝsǝli, ba ǝnga kumǝr dzǝ kǝra nji cina ǝnga ˈyimi camǝu. ");
INSERT INTO mfm_vpl VALUES ("HB10_23","088_10_23","HEB","10","23","23","Bǝgǝ mǝna taˈyi tandar ar fǝ ɗǝfu, kǝra mǝna vǝr lǝ sakida ar kǝri, ara ndǝra mǝliya mǝn alkawal ndǝr mǝl sǝ tsaˈa miya ɗǝfu ngau. ");
INSERT INTO mfm_vpl VALUES ("HB10_24","088_10_24","HEB","10","24","24","Mǝna tsǝtsǝkuri kuvwar mǝn lagura nda cabiya yiwukur ǝnga mǝl thlǝr kǝra mǝnahǝu. ");
INSERT INTO mfm_vpl VALUES ("HB10_25","088_10_25","HEB","10","25","25","Mǝna sara piyari shili wu daɓǝ dzǝ nǝ dlǝvǝ mai, ǝnggǝr kǝra alenyi nja vǝr mǝl. Ar viya kau, kuji mǝna dumwa ǝnga tsǝtsǝku ɗǝfuwa mǝn, mǝna dumwa ǝnga mǝl abang