﻿USE sofia;
DROP TABLE IF EXISTS sofia.mfi_vpl;
CREATE TABLE mfi_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mfi_vpl WRITE;
INSERT INTO mfi_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Am fakta, Dadaamiya a ndere samayaha antara haha. ");
INSERT INTO mfi_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Haha baɗemme ba ƴalaŋŋe, ndza ɓaaka ba naàzara keni aàtekwa, a heɗetaa ba tabeɗammire yawaha, Sheɗekwe aà Dadaamiya aŋkwa aà ja ɗaba argina. ");
INSERT INTO mfi_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","A ba Dadaamiya: A gevge parakkire. A gevhe ge parakkire. ");
INSERT INTO mfi_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Dadaamiya aà zhara parakkire na shagera jipu. Daaci a tegaa tara parakkire an tabeɗammire. ");
INSERT INTO mfi_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Parakkire a ɗahanaa an vaàha, tabeɗammire a ɗahanaa an vaƴiya. Magaamaga icawaya, a werehe ge ekse, una ŋanna hare ge zuŋŋwire. ");
INSERT INTO mfi_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","A ba Dadaamiya: A gevge an tega dagave aà yawaha ge dise nakwahaatare. ");
INSERT INTO mfi_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","A gevhe ge dagave aà yawaha. Daaci Dadaamiya a magaa dagavaha ŋanna, a tegaa dagave aà yawaha na am aha antara yawaha na aàtire. ");
INSERT INTO mfi_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Dadaamiya a ɗaha dalbe na aàdetire: Samaya. Una ŋanna keni a gevhe. Magaamaga icawaya, a werehe ge ekse, una ŋanna hare ge buwire. ");
INSERT INTO mfi_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","A ba Dadaamiya: A jarammeje yawaha na am ekte aà samaya na baɗemme aà dem sleɗe palle, geni a jesarje dalbe na an ula. Una ŋanna keni a gevhe. ");
INSERT INTO mfi_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Dalbe na an ula na Dadaamiya a ɗahanaa an haha. Dalbe na jarammeje yawaha aàtekwa na waà, a ɗahanaa an haye. Dadaamiya a naa una ŋanna shagera jipu. ");
INSERT INTO mfi_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Daaci a ba Dadaamiya: Haha a sansese esseɓaha antara slapaha taà an wulfaha am itare, antara nafaha na aà ya egdzere taà an wulfahaatare, jaba a duksaha ŋanna baɗemme. Una ŋanna keni a gevhe. ");
INSERT INTO mfi_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Slerekke haha a sanse masaha, antara slapaha, ma uwe keni taà an wulfaha am itare. Nafaha keni ba estuwa, jeba a nafaha gergere, ma urara keni taà aà ba an wulfahaatare baɗemme. Dadaamiya a naa una ŋanna shagera jipu. ");
INSERT INTO mfi_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Magaamaga icawaya, a werehe ge ekse, una ŋanna hare ge keƴire. ");
INSERT INTO mfi_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","A ba Dadaamiya: A gevge parakkiraha ate samaya, ge tega tara vaàha antara vaƴiya. Una ŋanna aà gev nalaamaha ge maàraà sartaha, vaàhaha, antara ivaha. ");
INSERT INTO mfi_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Parakkiraha ŋanna a gevge ate samaya, ge maàraà parakkire aàsete haha. Una ŋanna keni a gevhe. ");
INSERT INTO mfi_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Dadaamiya a magaa parakkiraha saɗaɗɗe buwa: Palle waà, ƴaikke jipu, ŋane aà maga sleksiraara am vaàha, cekwaara keni aà maga sleksiraara an vaƴiya antara terlyakwaha. ");
INSERT INTO mfi_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Dadaamiya a puwateraa ate samaya ge maàraà parakkire aàsete haha, ");
INSERT INTO mfi_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","geni taà maga sleksiraatare vaƴivacika, antara ganakini taà teganaà itare dagave aà tara parakkire, antara tabeɗammire. Dadaamiya a naa una ŋanna shagera jipu. ");
INSERT INTO mfi_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Magaamaga icawaya, a werehe ge ekse, una ŋanna hare ge ufaɗire. ");
INSERT INTO mfi_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","A ba Dadaamiya: A demda yawe ba ŋga am naàzena an shifa, a ngyairngye ƴiyaha aà dem samaya. Una ŋanna keni a naba gevhe. ");
INSERT INTO mfi_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Dadaamiya a ndere dabbaha saɗaɗɗe antara naàzu an shifa aà zlala am yawe baɗemme. Daaci yawe a fantau ge yaà jeba duksaha gergere ɓaaka zlaktaara. A nderehe zlaɓe aàdaliye ƴiyaha taà an lyakwahaatare, jebahaatare keni gergere baɗemme. Dadaamiya a naa una ŋanna shagera jipu. ");
INSERT INTO mfi_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","A gaterar barka, a ba ŋane: Yawtiya, gawevge ba kwakya, hyaiwemhye am hayaha baɗemme. ƴiyaha keni hyairemhye am huɗe aà duniya baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Magaamaga icawaya, a werehe ge ekse, una ŋanna hare ge ilyeɓire. ");
INSERT INTO mfi_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","A ba Dadaamiya: Haha a sansese naàzena an shifa ate haha baɗemme. Dabbaha, naàzena aà hulmba am haha ira naàzena an shifa ate haha baɗemme, ma uwe keni jeba gergere baɗemme. Una ŋanna keni a naba gevhe. ");
INSERT INTO mfi_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Dadaamiya a magaa estuwa dabbaha aà kaamba jeba gergere baɗemme, dabbaha aà haà keni jeba gergere ira naàzu aà hulmba am haha keni jeba gergere baɗemme. A naa una ŋanna shagera jipu. ");
INSERT INTO mfi_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Daaci a ba Dadaamiya mazlaara waà, nderaumindera urimagwe ate nderaamiya, aà gaàraàva an miya. Daaci aà kwaranaà ŋane kelfaha am haye, ƴiyaha aà samaya, dabbaha, naàzu aà hulmba am haha ira duksaha umele na ate haha baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Daaci Dadaamiya a nderehe urimagwe, a nderanaa ate nderaara, aà gaàraàva an ŋane. A nder zhele antara mukse. ");
INSERT INTO mfi_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Dadaamiya a gaterar barka, a ba ŋane aà elvan ge itare: Yawtiya, gawevge ba kwakya, hyawtehye ate haha baɗemme, fawansarfe keni. Magawmaàga sleksiraakure ate kelfaha am haye, ate ƴiyaha aà samaya, ate dabbaha na ate haha baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","A ba Dadaamiya aà elvan ge itare: Baɗemme a naàzena a kyesaa am haha, antara wulfahaatare baɗemme, antara nafaha na aà yaà egdzere antara wulfahaatare baɗemme, una ŋanna naàza zaakure. ");
INSERT INTO mfi_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ge dabbaha na ate haha baɗemme, ge ƴiyaha aà samaya baɗemme, ge naàzena aà hulmba am haha baɗemme ira naàzena ni aà puwa shifa baɗemme na, ya vaterte masa aàŋwasla, una ŋanna naàza zaatare. Una ŋanna keni a gevhe aà ba ate una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Dadaamiya a naa nazena a maganaa ŋane baɗemme shagera jipu. Magaamaga icawaya, a werehe ge ekse, una ŋanna hare ge uŋkwahire. ");
INSERT INTO mfi_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Dadaamiya a zlanaa estuwa slera a ndera samaya antara haha ira naàzu am itare baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Am hare ge vuyire, am baɗemme a slerahaara zlauzle, a puwansehe vacite ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Dadaamiya a gaa barka am hare ge vuyire, a ganve cuɗeɗɗe. Aɗaba a puwanse vacite ŋanna am sleraha baɗemme ge ndera duksa badémme. ");
INSERT INTO mfi_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Kwaya ŋane labare aà tara samaya an haha am sarte na a nderaterndera Dadaamiya. Am sarte na ni Dadaamiya nder samaya antara haha waà, ");
INSERT INTO mfi_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","zlaɓe ndza ɓaaka nafa ate haha emtsaaɗe, ndza ɓaaka slapaha aà kaamba emtsaaɗe, aɗaba zlaɓe Dadaamiya Yaakadada fantauka ge hya yawe aàsete haha. Am sarte ŋanna zlaɓe ndza ɓaaka urimagwe ge herɗa haha. ");
INSERT INTO mfi_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Amaà ndza aŋkwa ƴire aà yawe aà segashe am haha, a remanaa ŋane haha baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Daaci Dadaamiya Yaakadada a nder urimagwe an berbere aà haha, a fem effeƴa aà shifa am ŋane aà kya ektare, daaci urimagwe a gev estuwa an shifa. ");
INSERT INTO mfi_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Am igaara maa, Dadaamiya Yaakadada a de icese fe am Adnin, aà dem dalbe aà geɗi, a de njanaahe aàhuwa urimagwe na a nderanaa ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Dadaamiya Yaakadada a fantau ge sanse nafaha jeba gergere am haha, aà yaà egdzere shagera, emtake ge ezza. Am dagave aà fe ŋanna maa, a sanse nafa aà shifa, antara nafa aà diya shagerire antara shagerkire. ");
INSERT INTO mfi_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Am Adnin ŋanna maa, a naba sesehe ge yawe, a magaa guwa ƴaikke antara yawe aàtekwa, aà vantaà ŋane lailaiɗɗire ge fe ŋanna. Fantau aà ba am tate ŋaana, guwa ƴaikke na a naba tagire, a magaa guwaha umele ufaɗe. ");
INSERT INTO mfi_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Zhera aà zuŋŋwire aà guwaha ŋanna Pisaun. A jantaava ŋane ge haha aà Hawila, aŋkwa dindar am haha ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Dindar aà larde ŋanna an daradza jipu. Aŋkwa zlaɓe naàzase navawaara am haha ŋanna, antara jeba nakwa umele an daradza jipu, zhera aà nakwa ŋanna aunikis. ");
INSERT INTO mfi_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Zhera aà buwire aà guwaha ŋanna Gihaun. Guwa ŋanna keni maa, a de jantaave ge haha aà Kus katakappe. ");
INSERT INTO mfi_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Zhera aà keƴire aà guwaha ŋanna Hidakail. ŋane una aà kela am larde aà Asura am dalbe aà geɗi. Zhera aà ufaɗire aà guwaha ŋanna Aifratis. ");
INSERT INTO mfi_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Daaci Dadaamiya a eksetaa urimagwe ŋanna, a njanaahe am fe ŋanna am Adnin na, geni aà ehherɗa, aà effufa. ");
INSERT INTO mfi_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Naàwa naàzena ni a faara Dadaamiya Yaakadada ge urimagwe: A ba ŋane aà elvan ge ŋane: Nafaha na am faha na baɗemme, ezza ba seke una aà katana ervauŋɗaaŋa. ");
INSERT INTO mfi_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Amaà nafa aà diya shagerire an shagerkire na waà, zeka. Aɗaba vacitu maà de zakuze, emtsaaŋa keni ba vacite ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","A ba Dadaamiya Yaakadada: Urimagwe maàki ɓaaka ura taà nja kerɗe waà, shagerka. Yaà maganaamaga slemelanumele, aà garava aà ba antara ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Dadaamiya Yaakadada a ndere dabbaha aà kaamba baɗemme, antara ƴiyaha aà cena ɗaha na ni watse aàɗahatera ŋane. Baɗemme a nazena an shifa, ma a ɗante estara keni aà gev ba zheraara. ");
INSERT INTO mfi_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Urimagwe a fafete zheraha aà dabbaha aà haà, antara dabbaha aà kaamba ira ƴiyaha baɗemme, amaà shanka una ta kalkale antara ŋane ge melanumele. ");
INSERT INTO mfi_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Daaci Dadaamiya Yaakadada a naba far jeba paàhaàre na jauje ge ndzeɗa ge urimagwe, a naba pu hare. Dadaamiya Yaakadada a teɗese hyaihye aà slerpaara palle, a heɗete sleɗaara an hyuwa. ");
INSERT INTO mfi_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Dadaamiya Yaakadada a magaa mukse an hyaihye aà slerpa ŋanna a sanse am urimagwe na, a danaàn ge urimagwe. ");
INSERT INTO mfi_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ba a puwete icaara ate ŋane urimagwe waà, a ba ŋane aà ba an kaà kwara: Yawwaa, kwaye una kwa waà, palle aà hyaihyahaaruwa antara hyuwa aà vuwaaruwa. ŋane waà, taà ɗahana an mukse, aɗaba ta sanse am zhele. ");
INSERT INTO mfi_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Aɗaba una ŋanna zhele aà ƴaà tara eddeŋaara an emmeŋaara, taà maàslava antara muksaara, taà gev vuwa palle. ");
INSERT INTO mfi_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Urimagwe antara muksaara bukerɗe taà an ukhyiye dey, amaà waterka zherwe. ");
INSERT INTO mfi_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Am dabbaha aà kaamba na a nderanaa Dadaamiya Yaakadada baɗemme waà, a jaterwa ba zahe an ƴaimƴaimire. Zahe a de ndavanu ge mukse, a ba ŋane: Ba jirire a banba Dadaamiya geni zauka egdzara aà nafaha na am fahe na baɗemme? ");
INSERT INTO mfi_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","A ŋwanante ge mukse, a ba ŋane: Egdzara aà nafaha na am fe baɗemme ŋaà ezza. ");
INSERT INTO mfi_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Sey ba egdzara aà nafa na kwa ya ŋane am dagave aà fe na waà, a ba Dadaamiya zauka, fauka erva ate nafa ŋanna geni emtsaweka. ");
INSERT INTO mfi_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","A ba zahe aà elvan ge mukse na: Fida kwaà emtseka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Dadaamiya diyaadiya ganakini maà zakuruze egdze aà nafa ŋanna waà, aà de wera icaakure, kwaà de gev ba seke ŋane, kwaà de dzegwaàndzegwa dise shagerire antara shagerkire. ");
INSERT INTO mfi_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mukse na aà zhara egdze aà nafa na waà, aà ba am ice keni zariya jipu, watse emtake ge ezza. Shagerire aà egdze aà nafa ŋanna aà naba vante eŋkale ge ura. Daaci a naba eŋzlevaahe egdze aà nafa ŋanna, a zuhe, a vante ge zhelaara na atevege ŋane na, ŋane keni a naba zuhge. ");
INSERT INTO mfi_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Daaci a werte ge icaatare, ta naba diyeddiye geni taà an ukhyiye dey. Aɗaba una ŋanna ta kazlevaa slape aà nabugda, ta heɗe nasheriraatare an ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","An icavaciya waà, taà cena ba maga aà duksa, Dadaamiya Yaakadada aŋkwa aà jaà ɗaba am huɗe aà fe. Tara zhele antara mukse sheɓaresheɓe am ice aà nafaha, taà sheɓe aàtuge Dadaamiya Yaakadada. ");
INSERT INTO mfi_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Dadaamiya Yaakadada a naba ɗaha urimagwe, a ba ŋane aà elvan ge ŋane: Kaà aàma ka? ");
INSERT INTO mfi_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","A ŋwanante ge urimagwe, a ba ŋane: Ya cenaa kwaraaŋa am fe, iya yaà an ukhyiye dey, aɗaba una ŋanna jija lyawa sheɓanebsheɓe. ");
INSERT INTO mfi_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","A ba Dadaamiya Yaakadada aà elvan ge ŋane: A ndaaka ware ganakini kaà an ukhyiye dey na? Emtu zakuze egdze aà nafa na piyanaktepiya zeka aà ba iya na? ");
INSERT INTO mfi_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","A ŋwete ge urimagwe, a ba ŋane: Ba mukse ŋanna ka vitaa ka na waà, a vitaa ba ŋane egdze aà nafa ŋanna, iya keni ya naba zuhe. ");
INSERT INTO mfi_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","A ba Dadaamiya Yaakadada aà elvan ge mukse: Ka magan ge uwe una? A ŋwete ge mukse a ba ŋane: A keɗiyaa ba zahe ate eŋkale lauktu ya zu egdze aà nafa ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Am iga aà una ŋanna, a ba Dadaamiya Yaakadada aà elvan ge zahe: Ekka ni magakanaamaga tsawe una waà, kaà an nyainye am dagave aà dabbaha, antara naàza kaambaha baɗemme. Sey kaà zlala ate huɗaaŋa, kaà zaà ba haha haà a zlauwa estuwa shifaaŋa am duniya. ");
INSERT INTO mfi_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Yaà femfa kelaadire am dagavaakure antara mukse na, am dagave aà wulfahaaŋa, antara wulfahaara. Wulfe aà mukse na aà de hakaahe ire ba kacakaca. Ka keni naba uwwa ate naɗegaɗegaara. ");
INSERT INTO mfi_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","A ba ŋane aà elvan ge mukse: Yaà kwakyakanvekwakya zlaɗa aà yaà, kaà yaà egdzaraaŋa am palasa. Sey kaà de kumte aà ba an kuma nja antara zhelaaŋa, amaà ŋane aà de maga ba sleksiraara ate ka. ");
INSERT INTO mfi_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","A ba ŋane aà elvan ge urimagwe: Ka ƴaa ba elvaaruwa, ka cenvaa elva aà muksaaŋa, ka naba zu egdze aà nafa na piyanaktepiya, ya bakaa zeka na! Kwaye yaà nyainyainvenyainye haha aɗaba ka. Sey kaà shushe zlaɗa cuuwe, lauktu kaà shaà nazu kaà ezza ate haha na, haà aà zlauwa estuwe shifaaŋa. ");
INSERT INTO mfi_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Haha aà sakanse ba dakaha antara masaha na ɓaaka payɗaara na, kaà de za ba slapaha am kaamba. ");
INSERT INTO mfi_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Sey aà sesse ŋguɗeffire cuuwe ate wafkaaŋa, lauktu kaà shaà nazu kaà ezza. Njaaŋa ba una, dem sarte na maà eptsekpetsa zlaɓe adaliye aà dem haha, aɗaba ndza ya sakse aà ba am haha. Ekka iraaŋa ka haha, kaà eptsa aà ba dem haha ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Aadama a fete zhera aà muksaara Hawwa, aɗaba ŋane gevge emmarge emnde na taà an shifa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Dadaamiya Yaakadada a magateraa naàza heɗa nasherire an gwagwa ge tara Naadama antara Hawwa muksaara, daaci a tsekwateremhe. ");
INSERT INTO mfi_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","A ba Dadaamiya Yaakadada: Kina waà urimagwe gevge ba seke pallaamiya mazlaara, diyaadiya shagerire antara shagerkire. Shagera mi piyantepiya, aà feteka ervaara zlaɓe adaliye ate egdze aà nafa aà shifa. Maàki zauze una ŋanna aà de nja an shifa dem ba ge ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Aɗaba una ŋanna Dadaamiya Yaakadada a ngyanse urimagwe am fahe aà Adnin geni a ezlzlala aà de herɗaara ate haha na ta sanse am kwa na. ");
INSERT INTO mfi_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","A ŋgyanse urimagwe, a tsatsaa Kairubaha am dalba aà geɗi ge fahe ŋanna, taà an katsakar am erva, aà mbe pelpele ba seke nara aà kara, taà aŋkwa ufa barama a dem tate aà nafa aà shifa na. ");
INSERT INTO mfi_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Am iga aà una ŋanna maa, Naadama a deza muksaara Hawwa, a shaa huɗe, a ye egdzere zhele, zheraara Kayinu. A ba Hawwa: A shiyantaa ba Yaakadadaaruwa egdzere zhele na. ");
INSERT INTO mfi_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","A yehe zlaɓe adaliye umele, zheraara Habila, egdze a emmeŋaara ge Kayinu. Habila gevge suni, Kayinu ŋane gevge sleherɗa. ");
INSERT INTO mfi_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Vacite umele, Kayinu a sanaa sadake ge Yaakadada am naàzena a vantaa uzaara. ");
INSERT INTO mfi_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habila keni a de sanaa sadake ge Yaakadada am dabbahaara, a de sanaa ba emnde na ta zuŋŋwe ge mamahaatare, taà an ŋasla jipu na. Dadaamiya Yaakadada hayanhaya Habila lyevaalya sadakaara kani. ");
INSERT INTO mfi_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Amaà Kayinu waà, Yaakadada hyanka ŋane, lyiyaaka sadakaara keni. Daaci jaaja ervauŋɗe Kayinu na, aà kwasha feke. ");
INSERT INTO mfi_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","A ba Yaakadada aà elvan ge ŋane: Labara aà jaka ervauŋɗe kaà kwasha feke na? ");
INSERT INTO mfi_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Maà shagera maàgaaŋa, watse ka kanteka ire. Maà shagerka maàgaaŋa, kwaye haypa njanunje ge wakyiyaaŋa, baɗemme a wederaara aà ba ate ka. Amaà naàzena yaà bakanaà ya waà, gegga ba ka ndzeɗa arge ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Daaci a ba Kayinu aà elvan ge egdze a emmeŋaara Habila: Sawa mi zlala aà dem kaamba. Daraada am kaamba maa, Kayinu ŋanna a naba darge egdze a emmeŋaara na an waàva, a je shifaara. ");
INSERT INTO mfi_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","A ba Yaakadada aà elvan ge Kayinu: AÀma egdze a emmeŋa Habila? A ŋwanante a ba ŋane: Diyanka ya, ya sle ufa egdze a emmerwa emtu? ");
INSERT INTO mfi_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","A ba Yaakadada aà elvan ge ŋane: Azara una ka maganaa ka na? Eccena ba ŋgaa: Se shisha kyuwa aà uzhe aà egdze a emmeŋa aà sawa am haha. ");
INSERT INTO mfi_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Kina waà, kaà an nyainye, ɓaaka barkaaŋa, ambane ba ka ɓaaka ate haha ŋanna a shu uzhe aà egdze a emmeŋa na, ka puwanvaa ba ka an ervaaŋa na. ");
INSERT INTO mfi_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kaà de herɗa, amaà watse aà yaiveye haha naàmpire na aà magateraàn ge emnde na. Kaà de jaà ɗaba seke ba kuye, dammaru kaà de shanka tate na ni aà de ekhyekhya ervauŋɗaaŋa aàtekwa na. ");
INSERT INTO mfi_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","A ba Kayinu aà elvan ge Yaakadada: Elva na ɗemɗeme jauje ge ndzeɗaaruwa, yaà tsa sepanteka. ");
INSERT INTO mfi_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Vatena ŋgyaikiseŋgye am sleɗe aà herɗa, ŋgyaikiseŋgye aà katafkaaŋa keni baɗemme. Ganevge ba seke kuye, ɓaaka tate aà tsaaruwa ɗekiɗeki ate haha na. Una aàbi ma a shiyaa ware keni aà de jaà ba shifaaruwa? ");
INSERT INTO mfi_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","A ŋwanante ge Yaakadada, a ba ŋane: ɓaaka ura jagja ɗekiɗeki. A ba ŋane: Ma ware una a je Kayinu, aà pelava an shifa vuye. Daaci Yaakadada a magaa nalaama ate Kayinu, geni ma ta jaa ire antara ware keni, eddaara a fanfeka erva ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Am iga aà una ŋanna maa, ba ezlzlalaara ge Kayinu ƴiiƴiye an Yaakadada, kwaye a de nja am haha aà Naudi, aà dem geɗiyaara ge Adnin. ");
INSERT INTO mfi_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kayinu a deza muksaara, mukse shansha huɗe, a yese egdzere zhele zheraara Hanauk. Kayinu a ndere berni, a fete zhera aà berni ŋanna Hanauk, zhera aà egdzaara. ");
INSERT INTO mfi_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Hanauk a yese Iraɗ, Iraɗ a yese Maihuya'el, Maihuya'el a yese Maitsusa'el. Maitsusa'el a yese Lamaik. ");
INSERT INTO mfi_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamaik ŋane a halante ŋwasha buwa. Palle zheraara Adda, palle na keni zheraara Jila. ");
INSERT INTO mfi_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adda a yese egdzere zhele, zheraara Yabal. ŋane eggyetare ge emnde a kumkum, taà nja aà ba am beraha aà kacakaca, taà an waldahaatare. ");
INSERT INTO mfi_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Zhera aà egdze a emmeŋaara Yubal, ŋane eggyetare ge emnde a jaà gadzavera antara emnde a ferta nalgaita. ");
INSERT INTO mfi_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Jila keni a yese egdzere zhele zheraara Tubalkayinu, ŋane slejaà ekzla, aà jaànaà ŋane kazlaŋa aà slera baɗemme, an verzhagane antara ire daŋŋwe. Aŋkwa egdze a emmeŋaara mukse, zheraara Naama. ");
INSERT INTO mfi_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","A ba Lamaik aà elvan ge ŋwashahaara, tara Adda antara Jila: Cenaucena naàwa yaà bakura elvaaruwa, kwa ŋwashahaaruwa ya Lamaik aàbi! Yawwaa, faufa hyema ba ŋgaa ge cena elvaaruwa na. Iya Lamaik waà, maàki garifege ververe, iya yaà jaà shifa aà zhele palle. Maàki zariyuze an jaà, iya yaà jaà shifa aà egdzere zhele palle. ");
INSERT INTO mfi_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Maàki ta ceɓaa zaala vuye ge pela hume a Kayinu waà, naàzaaruwa iya Lamaik zaala kul vuye ju vuye. ");
INSERT INTO mfi_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Naadama a duhe zlaɓe aàdeza muksaara, muksaara a shaa huɗe zlaɓe adaliye, a ye egdzere zhele, Hawwa a fante Saitu ge egdzaara, aɗaba a ba ŋane: A vitaa ba Dadaamiya egdzere zhele umele am sleɗe aà Habila na jaaja Kayinu. ");
INSERT INTO mfi_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Saitu keni a shaa egdzere zhele, a fete zheraara Ainaus, ta fantau aà ba am sarte ŋanna emndimagwaha ge ɗaha zhera aà Yaakadada am maduwa. ");
INSERT INTO mfi_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Naàwa wakita na waà, aà tsaka wulfaha aà Naadama. Am sarte na Dadaamiya aà nderaà urimagwe, a nderanaa ate nderaara ge ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","A nderaterhe tara zhele an mukse, a gaterar barka, a vaterte zhera aà urimagwire ba vacite na ni a nderaterndera. ");
INSERT INTO mfi_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Yawe aà Naadama dermeke an kul keƴe am sarte na a shaa Saitu, egdze na ni a de eksa ba ŋane mazlanaaka ba tatara kini ate ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Am iga aà iva ŋanna a ye Saitu aàtekwa na waà, Naadama a magaa iva dermeke tise zlaɓe adaliye. A yayaa egdzar zaala umele antara egdzar ŋwasha. ");
INSERT INTO mfi_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Yawe aà Naadama baɗemme lauktu aà emtsa waà, dermeke maselmane an kul keƴe ");
INSERT INTO mfi_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Saitu a magaa yawe dermeke an ilyeɓe lauktu a ye Ainaus. ");
INSERT INTO mfi_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Am iga aà iva ŋanna a ye Ainaus aàtekwa na maa, Saitu a magaa yawe dermeke tise an vuye. A yayaa egdzar zaala umele antara egdzar ŋwasha. ");
INSERT INTO mfi_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Yawe aà Saitu baɗemme, dermeke maselmane an kelaawa ju buwa lauktu aà emtsa. ");
INSERT INTO mfi_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ainaus a magaa yawe kul maselmane kalkale lauktu a ye Kaynan. ");
INSERT INTO mfi_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Am iga aà iva ŋanna a ye Kaynan aàtekwa na, Ainaus a magaa yawe dermeke tise an kelaawa jilyeɓe, a yayaa egdzar zaala umele antara egdzar ŋwasha. ");
INSERT INTO mfi_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Yawe aà Ainaus baɗemme, a magaa demeke maselmane an ilyeɓe lauktu aà emtsa. ");
INSERT INTO mfi_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kaynan keni a magaa yawe kul vuye kalkale lauktu a ye Malaliyail. ");
INSERT INTO mfi_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Am igaara, a magaa yawe dermeke tise an kul ufaɗe zlaɓe adaliye. A yayaa egdzar zaala, umele antara egdzar ŋwasha. ");
INSERT INTO mfi_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Yawe aà Kaynan baɗemme a magaa dermeke maselmane an kelaawa lauktu aà emtsa. ");
INSERT INTO mfi_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Malaliyail keni magaamaga yawe kul uŋkwahe jilyeɓe lauktu a ye Yarat. ");
INSERT INTO mfi_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Am igaara, a magaa yawe dermeke tise an kul keƴe, a yayaa egdzar zaala umele, antara egdzar ŋwasha. ");
INSERT INTO mfi_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Iva aà Malaliyail baɗemme, dermeke tise an kul maselmane jilyeɓe lauktu aà emtsa. ");
INSERT INTO mfi_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yarat a magaa yawe dermeke an kul uŋkwahe ju buwa lauktu a ye Anuhu. ");
INSERT INTO mfi_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Am igaara zlaɓe adaliye, Yarat a magaa yawe dermeke tise kalkale. A yayaa egdzar zaala umele antara egdzar ŋwasha. ");
INSERT INTO mfi_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yawe aà Yarat baɗemme, dermeke maselmane an kul uŋkwahe ju buwa lauktu aà emtsa. ");
INSERT INTO mfi_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Anuhu magaamaga yawe kul uŋkwahe jilyeɓe lauktu a ye egdzere zhele zheraara Matusala. ");
INSERT INTO mfi_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Am iga aà iva ŋanna a ye Matusala aàtekwa na maa, Anuhu a magaa yawe dermeke keƴe kalkale zlaɓe adaliye, aŋkwa aà ɗaba Dadaamiya. A yayaa egdzar zaala umele antara egdzar ŋwasha. ");
INSERT INTO mfi_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Yawe aà Anuhu baɗemme, a magaa dermeke keƴe an kul uŋkwahe jilyeɓe lauktu aà emtsa. ");
INSERT INTO mfi_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Anuhu ɗabeteɗaba Dadaamiya. Emnde taà zhaàraà ba ɓaaka am dagavaatare, aɗaba eksanteksa Dadaamiya aà ba an shifa aàdezeŋaara. ");
INSERT INTO mfi_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusala a magaa iva dermeke an kul tise ju vuye, lauktu a ye Lamaik. ");
INSERT INTO mfi_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Am igaara, Matusala a magaa yawe dermeke vuye an kul tise ju buwa. A yayaa egdzar zaala umele antara egdzar ŋwasha. ");
INSERT INTO mfi_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Iva aà Matusala baɗemme, a magaa yawe dermeke maselmane an kul uŋkwahe ju maselmane lauktu aà emtsa. ");
INSERT INTO mfi_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamaik keni a magaa iva dermeke an kul tise ju buwa, lauktu a ye egdzere zhele. ");
INSERT INTO mfi_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","A fete zhera aà egdze ŋanna Nuhu. A ba ŋane: Edgze na waà, watse aà ekhyaŋera ŋane ervauŋɗe am slerahaaŋere baɗemme, aɗaba ŋgeɗepa na ŋaà aŋkwa aà magana ŋere ate haha na. Aɗaba Dadaamiya nyainyainvenyainye haha. ");
INSERT INTO mfi_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Am iga aà iva ŋanna a ye Nuhu aàtekwa na, Lamaik a magaa iva dermeke ilyeɓe an kul maselmane jilyeɓe zlaɓe adaliye. A yayaa egdzar zaala umele antara egdzar ŋwasha. ");
INSERT INTO mfi_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Iva aà Lamaik baɗemme, a magaa dermeke vuye an kul vuye ju vuye, lauktu aà emtsa. ");
INSERT INTO mfi_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuhu keni maa, a magaa yawe dermeke ilyeɓe kalkale, lauktu a fantau ge yaà egdzara. Tara Saim, antara Haamu ira Yafait. ");
INSERT INTO mfi_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Am sarte na emndimagwaha farantaufe aà ba an ndzeɗa taà aŋkwa huya ate haha, taà aŋkwa aà yaya gyaalaha zarizariya keni. ");
INSERT INTO mfi_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Emnde aà Dadaamiya taà aŋkwa a zhaàraà gyaalaha aà emndimagwaha na ta zariyaha jipu, daaci ta naba dzerese gyaalaha ŋanna, ta gaterve ŋwashahaatare. ");
INSERT INTO mfi_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Daaci a ba Yaakadada: Mazlaara yaà ƴanka Sheɗekwaaruwa aà nja am urimagwe dem ba ge ɗekiɗeki. Aɗaba urimagwe an vuwa, a ŋaa ba emtsa. Yaà gulanagula slaɗɗire aà shifaara, a juka am yawe dermeke palle an kul buwa taà nja an shifa. ");
INSERT INTO mfi_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Am zamane ŋanna, emnde a samaya ta ge gyaalaha aà emndimagwaha, ta gaterve ŋwashahaatare na waà, ba egdzara aà ŋwasha ŋanna ta ge emnde a samaya na una ndza ta emnde a ŋgaŋga, ƴaikkire keni ndza ba naàzaatare. ");
INSERT INTO mfi_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Daaci Yaakadada aà zhaàraà mandzawire aà emndimagwaha a far ba wala ate haha, naàzena taà dzamana am ervauŋɗaatare baɗemme ba mandzawiri ");
INSERT INTO mfi_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yaakadada demda am ambane ge ndera urimagwe ate haha, zlaɗevzlaɗe ervauŋɗaara jipu. ");
INSERT INTO mfi_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Aɗaba una ŋanna, a ba ŋane: Emnde ŋanna ya nderateraa ba iya na waà, sey yaà jaàteraàja ate haha ba ɗekiɗeki. Dete dabbaha, naàzu aà hulmba am haha ira ƴiya aà samaya baɗemme. Aɗaba danemda am ambane geni ambane ma nderanaterka ba ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Amaà Nuhu waà, ŋane shansha ŋgurna aàza Yaakadada. ");
INSERT INTO mfi_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Naàwa una waà, labare aà Nuhu, eddarga dawalaha keƴa: Tara Saim, antara Hamu ira Yafait. Nuhu ndza ur jirire, ndza ɓaaka duksa maàndzawe ate ŋane, ndza aà ɗaba ba Dadaamiyaara. ");
INSERT INTO mfi_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Amaà emnde baɗemme waà, duniya baɗemme sepse am ice aà Dadaamiya, a juwaa ba kelaadire ɓaaka dukse umele. ");
INSERT INTO mfi_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Dadaamiya aà ezhzhaàraà waà, duniya ŋanna baɗemme badzavbadze. Aɗaba baɗemme a emndimagwaha ɓaaka ura aà zlala ndeɗɗe am duniya. ");
INSERT INTO mfi_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Daaci a ba Dadaamiya aà elvan ge Nuhu: Maàga aà emndimagwaha ŋanna hyaahya, aɗaba duniya baɗemme badzavbadze aɗaba maàgaatare. Aɗaba una ŋanna yaà jaàteraàja ba ɗekiɗeki ate haha na. ");
INSERT INTO mfi_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Amaà ekka waà, maganaamaga paàre aà yawe ƴaikke ge iraaŋa, kaà maganaà an nafa aà gaufir. Kaà maga huɗe ma gergere waànyara keni am huɗaara. A jerka tate aàtekwa, kaà vanyavanya baɗemme an naàvawe, tara huɗe an iga baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Paàre aà yawe ŋanna naàwa kaà de magana ate una: An slaɗɗire kaà kura dza dermeke keƴe kalkal, an huya waà, dza kul ilyeɓe. Slaɗɗiraara aà dem samaya keni dza kul keƴe keslsle. ");
INSERT INTO mfi_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Maà kaà maga pare ŋanna waà, kaà maga bere arge bere, bere arge bere haà keƴe. Wakyiyaara am dalbe palle, kaà maganaà am dagavaara ge dalbe ŋanna. Sey kaà mazlanaamazla waɓiye aàtekwa aà ba an niya deydey dza palle, am dagave aà tara vuwa aà pare an mbakye. ");
INSERT INTO mfi_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Aɗaba uwe, kwaye watse yaà hya yawe ƴaikke jipu ge keɗa duniya baɗemme, naàzena an shifa baɗemme ate haha na baɗemme aà keɗa. ");
INSERT INTO mfi_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Amaà ekka waà, yaà aŋkwa maga namaàna am dagavaamiya antara ka, kaà keɗeka ɗekiɗeki. Naba dawumda am pare aà yawe antara muksaaŋa, egdzaraakure ira shawlahaakure. ");
INSERT INTO mfi_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Iyau halatertehala zlaɓe adaliye aà dem pare antara ka, duksa bubuwa tara zhele an mukse am naàzu an shifa baɗemme geni itare keni a keɗeka shifaatare, a eŋzlarseŋzle antara ka. ");
INSERT INTO mfi_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ma am ƴiyaha, ma am dabbaha, ma am naàzu aà hulmba am haha keni, am naàzena an shifa baɗemme, kaà tsaka bubuwa tara zhele an mukse, watse taà sawa ba itare aàsezeŋa geni taà eŋzleseŋzle antara ka. ");
INSERT INTO mfi_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ekka waà, ejjaàhaà ka ba naàza za, jili aà naàza za gergere fanufe hyema aàzeŋa, watse kaà ŋa iraaŋa an ŋane, antara aàzaha ŋanna baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuhu a maganaahe aà ba ate una ŋanna, a magaa ba naàzena ni a faara Yaakadada baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Daaci a ba Yaakadada aà elvan ge Nuhu: Dawumda am pare aà yawe antara emndaaŋa baɗemme. Aɗaba ya ber ba ka palle edda aà jirire am dagave aà emnde a zamane na. ");
INSERT INTO mfi_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Am dabbaha na cuɗeɗɗe waà, tsakvaatsaka aàdezeŋa zaala vuye, ŋwasha keni vuye aà ba am jeba palle. Am ƴiyaha keni ba estuwa, kaà tsaàkaà zaala vuye, ŋwashahaara keni vuye aà ba am jeba palle, geni a jauje wulfaatare am huɗe aà duniya. Amaà am dabbaha na haraàm waà, kaà tsaàkaà ba bubuwa tara zhele an mukse tara zhele an mukse zlauzle. ");
INSERT INTO mfi_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Aɗaba a juwaa ba hare vuye njeraiŋŋe, yaà de hyaà yawe ƴaikke, vaƴivacika, hare kul ufaɗe watse aà hya ba yawe ŋanna, baɗemme naàzena ya nderanaa ya ate haha na aà de jauka ba palle keni. ");
INSERT INTO mfi_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Daaci Nuhu maganaamaga naàzena a faara Yaakadada na baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Am sarte na Dadaamiya a hyaa yawe ƴaikke ge keɗa duniya baɗemme na waà, iva aà Nuhu dermeke uŋkwahe kalkale. ");
INSERT INTO mfi_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Daaci ta demhe ge tara Nuhu am paàre aà yawe antara muksaara, antara egdzaraatare ira ŋwashaha aà egdzaraatare baɗemme, geni a keɗateraaka yawe ƴaikke ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Dabbaha cuɗeɗɗe, antara dabbaha na garevka cuɗeɗɗe, antara ƴiyaha ira naàzu aà hulmba am haha, ");
INSERT INTO mfi_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","baɗemme saremsa aàseza Nuhu am pare bubuwa baɗemme, ma uwe keni ba tara zhele an mukse tara zhele an mukse, ba seke una a ndahana Dadaamiya ge Nuhu na. ");
INSERT INTO mfi_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Am magaamaga hare vuye ŋanna waà, tsekwaatsekwa yawe ƴaikke aà sawa am samaya aàsetarge haha baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ate iva na ni iva aà Nuhu magaamaga dermeke uŋkwahe na waà, ate tere ge buwire, haraara keni kelaawa ju vuye na waà, vacite ŋanna a naba sesehe ge yawaha, baɗemme heraahera sleɗe, ate samaya keni a weretaa ba ɓiyaara ge yawe, ");
INSERT INTO mfi_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Maà a de fantau ge hya yawe aà sawa am samaya waà, ba ka heɗu we. Vacivaƴika hare kul ufaɗe aà hya ba yawe na. ");
INSERT INTO mfi_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Vacite ŋanna tara Nuhu ta demhe am pare aà yawe antara muksaara, egdzaraara, tara Saim antara Hamu ira Yafait, antara shawlahaara keƴe. ");
INSERT INTO mfi_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","AÀ dem pare aà yawe ŋanna ta demhe ba kerɗe antara dabbaha aà kaamba jeba gergere, dabbaha aà haà jeba gergere, naàzu aà hulmba am haha jeba gergere, antara ƴiyaha keni jeba gergere. ");
INSERT INTO mfi_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Baɗemme aà naàzena an shifa, ta semhe bubuwa aàseza Nuhu am pare aà yawe na. ");
INSERT INTO mfi_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Am jeba duksaha na baɗemme, ta semaa tara zhele an mukse aà ba ate una a bannaa Dadaamiya ge Nuhu na. Am iga aà una ŋanna maa, ba Yaakadada an iraara a heɗanu ge Nuhu am pare aà yawe. ");
INSERT INTO mfi_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Hare kul ufaɗe kalkale vacivaƴika aà hya ba yawe ƴaikke na aà sawa am samaya, haha baɗemme walarwaàla yawe, aŋkwa aà kaà pare aà yawe na aà detire, gevge waà, pare aà yawe na aà jaà ɗaba ba estuwa arge yawe baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Yawaha na ba a farfe a ba an ndzeɗa, gevge haha ƴiƴiye jipu ge sleɗɗire a yawe argine, pare aà yawe na a ja ɗaba arge yawaha. ");
INSERT INTO mfi_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Aɗaba yawe ŋanna aŋkwa aà far ba waàla aà dem samaya, antare ba ire aà waha saɗaɗɗe keni aà naaka mazlaara ndawnde. ");
INSERT INTO mfi_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Yawe ndawnde waha baɗemme. AÀ ba arge ire aà waha keni waàlaà aà yawe dza kelaawa jilyeɓe. ");
INSERT INTO mfi_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Baɗemme a naàzena aà puwa ba shifa ate haha na jauka. Amaana: ƴiyaha, dabbaha aà haà, dabbaha aà kaamba, naàzu aà hulmba am haha, antara ba emndimagwaha. ");
INSERT INTO mfi_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Baɗemme a naàzena aà puwa shifa aà kya ektare, aà nja ate haha dzayye emtsaremtsa. ");
INSERT INTO mfi_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Yaakadada a janaahe estuwa naàzena ndza an shifa ate haha baɗemme. Tsante ate urimagwe, dabbaha saɗaɗɗe, dabbaha mesheshe, ƴiyaha, baɗemme a keɗateraahe ba ɗekiɗeki ate haha. Sey a jauwa ba Nuhu an shifa, antara emnde na ndza taà antara ŋane am pare aà yawe. ");
INSERT INTO mfi_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Waàla aà yawe ate haha gejaaka emtsaaɗe ɗekiɗeki, a magaa hare dermeke an kul ilyeɓe. ");
INSERT INTO mfi_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","2","Daaci Dadaamiya viyanaaku Nuhu, antara dabbaha aà kaamba ira dabbaha aà haà na taà antara ŋane am pare aà yawe na, a naba saa effeƴa, aŋkwa aà vata effeƴa na ate haha baɗemme, daaci yawaha na a segashe am huɗe aà haha na, antara ɓiyaha na ndza ate samaya na baɗemme haɗettehaàɗa, yawe na aà hya na keni a naba ɓelehe, lauktu waàlaà aà yawe na ate haha na a fantau ge tsekwa. ");
INSERT INTO mfi_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Waàlaà aà yawe ate haha aà far ba gula an cekwa an cekwa, a magaa hare dermeke an kul ilyeɓe lauktu gulaagula kwa waàlaà aà yawe ŋanna ba ŋga. ");
INSERT INTO mfi_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ate tere ge vuyire am iva ŋanna, ate hare kelaawa ju vuyire ate tere ŋanna waà, de tsaatse pare aà yawe am huɗe aà wa aà Araraada. ");
INSERT INTO mfi_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Yawe na aŋkwa aà far ba gula ate haha. Ate tere kelaawire, am hare ge zuŋŋwire ate tere ŋanna waà, marapsemaàre ire aà waha, naranna emnde. ");
INSERT INTO mfi_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","A magaa hare kul ufaɗe am iga aà una ŋanna, Nuhu a naba werante we aà ɓiye na a maganaa aà ba an niyaara ate pare na, ");
INSERT INTO mfi_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","a ɓelaa zalke, zalke na a naba ŋgye, de janteja ɗaba, a naba saahe. Zalke na aŋkwa aà zlala, aà saà adaliye, aŋkwa aà ja ɗaba ba estuwa haa a zlu ge yawe ate haha, eptsaaka mazlaara. ");
INSERT INTO mfi_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Am iga aà una ŋanna maa, a ɓelaa takala zlaɓe adaliye geni aà zharanaà aàtekwa maàki ba jirire gulaagula yawe ate haha. ");
INSERT INTO mfi_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Amaà takala ŋanna shanka tate na ni a tsekwa aàtekwa ba geni aà puwansepuwe seraara keni. Am zlaɓe aŋkwa yawe aàte haha baɗemme, takala na a naba eptsa aàsete vuwa aà pare aà yawe. Nuhu a velese ervaara, a eksante takala na a dem huɗe a pare aà yawe. ");
INSERT INTO mfi_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","A pakvaa hara vuye zlaɓe adaliye am iga aà una ŋanna, a ɓelaa takala na zlaɓe adaliye aàdegashe. ");
INSERT INTO mfi_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Takala na a saa aàsezeŋaara an icavaciya, antara hyema aà anyaranyara am mbuwe. Daaci diyeddiye Nuhu geni gulaagula yawe ate haha. ");
INSERT INTO mfi_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Am iga aà una ŋanna, a magaa hare vuye zlaɓe adaliye, a naba ɓela takala na adaliye. Amaà eptsaaka takala na aàsezeŋaara mazlaara. ");
INSERT INTO mfi_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ate iva na ni Nuhu shanaasha iva dermeke an palle waà, ate zuŋŋwire aà tere, hare keni zuŋŋwire ate tere ŋanna waà, yawe keni zlauzle ate haha baɗemme. Daaci Nuhu a naba fiyaa ire aà pare, a zharanaahe baɗemme waà, ɓaaka, zlauzle yawe ate haha mazlaara. ");
INSERT INTO mfi_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ate tere ge buwire, haraara keni kul buwa ju vuye waà, welasewele haha kaŋŋgelaŋŋe. ");
INSERT INTO mfi_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Mazlaara a ba Dadaamiya aà elvan ge Nuhu: ");
INSERT INTO mfi_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Sesse am pare aà yawe mazlaara. Muksaaŋa, egdzaraaŋa, shawlahaaŋa, itare keni a saresse baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Satersese aàzaha na taà aàzeŋa na keni baɗemme: ƴiyaha, dabbaha ira naàzu aà hulmba am haha. Naba satersese, puwateraapuwa a zlarzlala ma aàdeme keni ate haha baɗemme, a yairteya, a hyartehye ate haha baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Daaci a sesehe ge Nuhu am pare aà yawe, muksaara, egdzaraara, antara shawlahaara keni ta sesehe antara ŋane am pare aà yawe na. ");
INSERT INTO mfi_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Am igaatare, ta sesehe ge dabbaha jeba gergere, ƴiyaha jeba gergere, naàzu aà hulmba am haha keni jeba gergere ira naàzu an shifa aà zlala ate haha baɗemme jeba gergere, saresse am pare aà yawe. ");
INSERT INTO mfi_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Daaci Nuhu a nderanaa tate aà fana sadake aàtekwa ge Dadaamiya Saksage. Am igaara, a eksevaa palpalle am dabbaha cuɗeɗɗe, am ƴiyaha na cuɗeɗɗe keni a eksevaa palpalle, a vante sadakaara ge Dadaamiya ate tate ŋanna, baɗemme a zuwaa ba kara. ");
INSERT INTO mfi_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yaakadada sanaase emtakire aà sadake na waà, a ba ŋane am ervauŋɗaara: Yaà dalika aà nyainya haha ɗekiɗeki aɗaba urimagwe. Ge jirire waà, urimagwe aà ba am cekwire keni ɓaaka duksa umele am ervauŋɗaara, sey ba dzama ire maàndzawe. Aley keni yaà naba ƴanƴa, yaà dalika aà ceɓa naàzu an shifa seke una ya maganaa ya kina. ");
INSERT INTO mfi_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Maàki zlaɓe aà ba aŋkwa haha na waà, jaà duksa, antara icanaà aà se mba iceka. Iyau sarte aà ŋguɗeffire antara sarte aà lailaiɗɗire, viya antara erva a vaciya ira vaàha antara vaƴiya, ɓaaka tsaatare ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Dadaamiya a gar barka ge Nuhu antara egdzaraara, a ba ŋane aà elvan ge itare: Yaiwtiya, gawevge ba kwakya, hyawtehye ate haha baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Baɗemme a dabbaha, baɗemme a ƴiyaha aà samaya, baɗemme aà naàzena aà hulmba am haha, baɗemme a kelfaha am haye, sey taà kuvakurkuva. Fanakuremfa aàzaha ŋanna baɗemme am erva ge kure. ");
INSERT INTO mfi_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Baɗemme a naàzena aà zlala ate haha, baɗemme a naàzena an shifa, vanakurteva aàzaha ŋanna ge ezza. Ba seke una ndza ya vakurte masaha baɗemme ge ezza na waà, una keni ba estuwa. ");
INSERT INTO mfi_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Sey ba hyuwa na ni saska shifa am huɗaara na waà, una ŋanna zauka ɗekiɗeki. Amaana: hyuwa na icaaka. ");
INSERT INTO mfi_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Uzhaakure keni, amaana: shifaakure, sey watse yaà enndaàva aàza eddawna a je shifaakure. Shifa aà urimagwe waà, ma a janaa dabba keni, sey yaà ndavanundave, ma a janaa ura keni eddawna a je shifa aà ukfeŋaara na sey yaà ndavanundave. ");
INSERT INTO mfi_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ma ware una a puvaa uzhe aà urimagwe na, uzhaara ge ŋane keni aà de puwana ba ura seke ŋane. Aɗaba Dadaamiya a ndere urimagwe ate nderaara ge ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Kina kure waà, yaiwtiya, huyawhuya, hyawtehye ate haha ɓaaka zlaktaakure ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","A ba Dadaamiya zlaɓe adaliye, aà elvan ge Nuhu antara egdzaraara: ");
INSERT INTO mfi_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Iya waà, naàwa yaà magakura namaàna ge kure antara eggyahaakure na ni watse taà sawa am igaakure, ");
INSERT INTO mfi_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ira naàzena aà ba an shifa aŋkwa ate haha antara kure. Amaana: ƴiyaha, dabbaha, egdzar dabbaha mesheshe na aà zlala am haha na, baɗemme aà naàzena ni a segashe am pare antara kure. ");
INSERT INTO mfi_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Naàwa namaànaaruwa na yaà ŋguɗakur ge kure: ɗekiɗeki yaà hyeka yawe ƴaikke na aàdete haha, aà zlaà naàzu an shifa baɗemme na. Jeba aà yawe ŋanna aà dalika aà sawa ɗekiɗeki ge zlaà naàzu ate haha baɗemme na. ");
INSERT INTO mfi_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","A farhe zlaɓe adaliye Dadaamiya, a ba ŋane: Naàwa nalaama aà namaàna na yaà ŋguɗana iya am dagavaamiya, iya antara kure ira naàzu an shifa baɗemme dem eggyeggye maà ba taà aŋkwa emndimagwaha ate haha: ");
INSERT INTO mfi_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Yaà de fem kataliyavere am dagave aà kumbaha. Una ŋanna nalaama aà namaànaaruwa, am dagavaaruwa antara emnde na ta ate haha baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ba kelaa maà maganaamaga kumba arge haha ni jesarje kataliyavere am huɗaara waà, ");
INSERT INTO mfi_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","sey ba yaà yehammeyehe namaànaaruwa na am dagavaaruwa antara kure ira naàzu an shifa baɗemme na, aà gevka ɗemme yawe ƴaikke mazlaara ge zlaà shifa ate haha baɗemme na. ");
INSERT INTO mfi_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Watse aà tsatse kataliyavere am dagave aà kumbaha yaà de zharanaà an icaaruwa, yaà de yehete aàtekwa namaàna saksage na ni am dagavaaŋere iya Dadaamiya antara naàzena an shifa ate haha baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Dadaamiya a fanarhe zlaɓe adaliye ndandahaara ge Nuhu, a ba ŋane a elvan ge ŋane: Una ŋanna nalaama aà namaàna ya ŋguɗanaa ya, am dagavaaŋere antara naàzena an shifa ate haha baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Egdzara aà Nuhu egdzar zaala na ta segashe am pare aà yawe waà, ba tara Saim an Haamu ira Yafait. Haamu waà, ŋane eddeŋaara ge Kanaana. ");
INSERT INTO mfi_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Egdzara aà Nuhu keƴe ŋanna waà, ta huya ba itare, baɗemme aà emnde na ta ate haha na ta segashe aà ba am itare. ");
INSERT INTO mfi_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ay Nuhu waà, ŋane ndza sleherɗa, a magaa fe aà inabauhi, zhera aà nafa ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Daaci vacite umele maa, a hyana mbazla aà egdza aà nafa aà inabauhi na, jaaja, a de zlavehe am beraara an ukhyiye dey. ");
INSERT INTO mfi_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Duwa aà Haamu eddeŋaara ge Kanaana, a de zhareme am nasherire aà eddeŋaara na, a de ɓalateranse ge egdzar mamahaŋaara buwa taà aàgashe. ");
INSERT INTO mfi_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Daaci ta tsetehe ge egdzar mamahaŋaara na, tara Saim antara Yafait, ta haltaa zane, ta puwete zane na ate nahyaipaihyaipaatare, ta duwa an iga an iga aàdeza eddetare na geni a naraànka nasherire aà eddetare na an ukhyiye dey na, ta de sheɓanaa nasherire ge eddetare. ");
INSERT INTO mfi_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Am sarte na tsetse Nuhu, kyanvaarkye mbazla baɗemme, a naba diyeddiye naàzena a magannaa egdzaara na baɗemme, kudere keni ba ŋane am egdzaraara. ");
INSERT INTO mfi_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Daaci a ba Nuhu: A nyainyainvenyainye Dadaamiyalla Kanaana! A gevge kataliya aà ba am naàvaha aà egdzar mamahaŋaara keni! ");
INSERT INTO mfi_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","A farhe zlaɓe adaliye, a ba ŋane: Dadaamiyaaruwa Saksage, barka aà njinja antara Saim, sey Kanaana aà gevge navaara. ");
INSERT INTO mfi_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Huyanaahuya Yafait, njanaanja an hairire am mba aà egdze a emmeŋaara Saim. Amaà Haamu waà, a gevge navaatare. ");
INSERT INTO mfi_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Am iga aà yawe ƴaikke ŋanna maa, Nuhu a magaa yawe dermeke keƴe an kul ilyɓe zlaɓe adaliye aŋkwa aà zaà shifa. ");
INSERT INTO mfi_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ivaara baɗemme am duniya, a magaa dermeke maselmane an kul ilyeɓe lauktu aà emtsa. ");
INSERT INTO mfi_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Am iga aà yawe ƴaikke na a keɗaa naàzu an shifa ate haha baɗemme na waà, egdzara aà Nuhu, tara Saim an Haamu ira Yafait huyaraahuya, ta yayaa egdzar zaala. ");
INSERT INTO mfi_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Naàwa egdzara aà Yafait: Tara Gaumair an Magaug an Maday an Yawan an Tubal an Maisaik ira Tiram. ");
INSERT INTO mfi_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Naàwa una keni egdzara aà Gaumair: Tara Askanas an Rifat ira Taugarma. ");
INSERT INTO mfi_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Naàwa egdzara aà Yawan: Tara Ailiza an Tarsis an Kiti ira Raudani. ");
INSERT INTO mfi_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Baɗemme a lardaha na taà am dagave a haye na, antara lardaha na taà ate we aà hayaha na, ta segashe aà ba am itare. Garevge jebaha gergere kwakya, taà ndaha elvaha keni gergere kwakya, zlamaha gergere kwakya, ma emndara keni taà aà ba an lardaatare. Emnde ŋanna baɗemme ba wulfaha aà Yafait. ");
INSERT INTO mfi_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Naàwa egdzara aà Haamu keni: Tara Kus an Mitserayim an Put ira Kanaana. ");
INSERT INTO mfi_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Naàwa egdzara aà Kus: Saiba an Hawila an Sabaita an Rama ira Sabitka. Naàwa emnde na keni ta egdzara aà Rama: Tara Saba an Daidan. ");
INSERT INTO mfi_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus waà, Nimrudu keni a yanaa ba ŋane. A fantuwa ba Nimrudu ŋanna maga hakuma ate haha. ");
INSERT INTO mfi_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nimrudu ŋanna waà, sledzega an haàkuma aà dzega keni jipu aàkatafke aà Yaakadada. Aɗaba una ŋanna, ta baàntsa: Sledzega seke Nimrudu na an haàkuma aà dzega aà katafke aà Yaakadada na. ");
INSERT INTO mfi_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Naàwa eksaha na Nimrudu a fantau ge maga sleksiraara am huɗaara na: Am Baabila, am Airaik, am Akat, antara am Kalne. Eksaha ŋanna baɗemme aà ba am larde aà Siniyar. ");
INSERT INTO mfi_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","A kezlese am larde ŋanna, kwaye aà zlala aà dem larde aà Asuura. Nimrudu a de nder berniyaha gergere aàhuwa: Berni aà Niniwe, berni aà Raikaubaut Ir, berni aà Kalak ");
INSERT INTO mfi_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","antara berni aà Raissain. Raissain waà, am dagave aà tara Niniwe antara Kalak berni na ƴaikke jipu na. ");
INSERT INTO mfi_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mitserayim maa, ŋane eggyetare ge Lundiyaha an Anamiyaha an Laihabiyaha an Naftuwaha ");
INSERT INTO mfi_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","an Paterusiyaha an Kasluwaha ira Kaftauriyaha. Filistiyaha keni ta segashe aà ba am emnde ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaana a yese Sidaun makaajiyaara antara Haitu. ");
INSERT INTO mfi_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yaibusiyaha an Amauriyaha an Gairgasiyaha, ");
INSERT INTO mfi_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Haiwiyaha, Arkiyaha, Siniyaha, ");
INSERT INTO mfi_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","an Arwidiyaha, Jaimariyaha ira Hamatiyaha, baɗemme a jebaha ŋanna, ta segashe aà ba am Kanaana. Am iga aà una ŋanna maa, emnde aà Kanaana ŋanna jeba gergere na baɗemme zaɗarevzaàɗe hyaremnye am tate ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Emnde aà Kanaana waà, hahaatare ƴaikke jipu. Tsante am Sidaun am dalbe aà Gairar, dem Gaaja, dem Saudauma antara Gaumaura, an Adama an Saibauyim, kwaye de shanaasha Laisa, baɗemme ba hahaatare. ");
INSERT INTO mfi_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Kwaya ŋane wulfaha a Haamu, garevge jebaha gergere kwakya, ma emndara keni taà ndaha ba elvaatare, taà am lardahaatare gergere, antara zlamaha gergere. ");
INSERT INTO mfi_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Saim maleŋaara ge Yafait, ŋane keni a yayaa egdzar zaala, eggyetare ba ŋane ge emnde aà Aibair baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Naàwa egdzara aà Saim: Tara Ailam an Assuuru, Arfasada, Luuda ira Aram. ");
INSERT INTO mfi_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Egdzara aà Aram ŋanna maa, tara Us an Hul an Gaitair ira Mas. ");
INSERT INTO mfi_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfasada a yese Sala, Sala a yese Aibair. ");
INSERT INTO mfi_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Aibair, ŋane a yayaa egdzar zaala buwa: Pallaatare Falaik. Ta fante zhera aà Falaik aɗaba a tegava am zamanaara duniya. Zhera aà egdze a emmeŋaara Yaktaan. ");
INSERT INTO mfi_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yaktaan a yese tara Almaudat an Saitaif an Hajamawait an Yairak ");
INSERT INTO mfi_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","an Hadauram an Usal an Dikila ");
INSERT INTO mfi_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","an Aubal an Abimayail an Saiba ");
INSERT INTO mfi_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","an Aufir, an Hawila ira Yaubaba. Baɗemmaatare na ta ba egdzara aà Yaktaan. ");
INSERT INTO mfi_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Hahaatare ge itare keni maa, tsante am Maisar, dem Safar, dete wa na aà dem geɗi na, baɗemme ba hahaatare. ");
INSERT INTO mfi_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Kwaya ŋane wulfaha aà Saim, garevge jebaha gergere kwakya, ma emndara keni taà ndaha ba elvaatare, taà am lardahaatare gergere antara zlamaha gergere. ");
INSERT INTO mfi_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Kwaya ŋane jebaha aà emnde gergere na ta yanaa egdzara aà Nuhu, ate kergema aà eggyahaatare. Baɗemme a nalgaadama ta segashe aà ba am itare, lauktu ta hyete ate haha am iga aà yawe ƴaikke na a keɗaa duniya baɗemme na. ");
INSERT INTO mfi_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Werre waà, baɗemme a duniya, emnde ndza taà ndaha ba elva palle, nara aà emnde ndza ba palle. ");
INSERT INTO mfi_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Daaci tsaretse emnde ta ɗaba baraàma aà geɗi maa, ta de beraa sleɗe ƴaikke am haha aà Sinaiyar, ɗaàmbake zlaɓe adaliye, ta naba nja am sleɗe ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","A ba itare am dagavaatare: Magaumimaga jalapa, deraumidera an kara geni aà gevge an ndzeɗa. Daaci ta magaa bere an ŋane ba seke ta maganaa an nakwa, ta vecaa bere ŋanna an haha an gya an gaderauŋ. ");
INSERT INTO mfi_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","A ba itare zlaɓe adaliye am dagavaatare: Dawamiyemda am slera, sey mi nderndera berni ƴaikke antara bere slaɗɗe an tsaka ire an huɗaara, sey ire aà bere ŋanna a shanaasha samaya. Sey mi maganaamaga una ŋanna, geni a keɗeka zheraamiya, zaɗaumiyemka aà dem duniya baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Daaci a tsekwe ge Yaakadada aà sa am samaya, ge se zhara berni ƴaikke na ta nderanaa egdzara aà Naadama na. ");
INSERT INTO mfi_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","A ba Yaakadada: Emnde na waà, naàwa ta emnde a jeba palle, elva na taà ndahana itare keni ba palle, emnde na, ma ta nderaa maàga uwe am ervauŋɗaatare keni, ɓaaka naàzu aà de piyatertepiya ɗekiɗeki. Una ta maganaa itare kina na zlaɓe ba emtakwaara. ");
INSERT INTO mfi_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Mindalawa, tsekwaumitsekwa, mi de weshaterantewesha elva na taà aŋkwa aà ndahana itare geni a cenaraaveka am dagavaatare ɗekiɗeki mazlaara. ");
INSERT INTO mfi_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Daaci a de kyateraahe ge Yaakadada aàhuwa, aà dem duniya baɗemme, ƴaranƴa ndera berni ƴaikke na. ");
INSERT INTO mfi_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Aɗaba una ŋanna, ta fante zhera aà Baabila ge berni ŋanna. Aɗaba Yaakadada a weshante elva na ta ndahanaa emnde am berni ŋanna, a kyesaa emnde aà dem duniya baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Naàwa kergema aà wulfaha aà Saim: Saim magaamaga yawe dermeke lauktu a ye egdzere zhele, zheraara Arfasada. Zlaɓe ba yawe buwa am iga aà yawe aà keɗa duniya na. ");
INSERT INTO mfi_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Am iga aà a ye Arfasada keni, Saim a magaa yawe dermeke ilyeɓe zlaɓe adaliye, a yayaa egdzar zaala antara egdzar ŋwasha umele. ");
INSERT INTO mfi_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfasada a magaa yawe kul keƴe jilyeɓe, a ye egdzere zhele, zheraara Sala. ");
INSERT INTO mfi_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Am iga aà a ye Sala maa, Arfasada a magaa yawe dermeke ufaɗe an keƴe zlaɓe adaliye, a yayaa egdzar zaala antara egdzar ŋwasha umele. ");
INSERT INTO mfi_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sala magaamaga yawe kul keƴe waà, shansha egdzere zhele zheraara Aibair. ");
INSERT INTO mfi_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sala a magaa yawe dermeke ufaɗe an keƴe zlaɓe adaliye, a yayaa egdzar zaala antara egdzar ŋwasha umele. ");
INSERT INTO mfi_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Aibair magaamaga yawe kul keƴe ju ufaɗe waà, a ye Falaik. ");
INSERT INTO mfi_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Am iga aà a ye Falaik maa, Aibair a magaa yawe dermeke ufaɗe an kul keƴe a yayaa egdzar zaala antara egdzar ŋwasha umele. ");
INSERT INTO mfi_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Falaik magaamaga yawe kul keƴe, ŋane keni a ye Ragaw. ");
INSERT INTO mfi_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Am iga aà a ye Ragaw maa, Falaik a magaa yawe dermeke buwa an maselmane. A yayaa egdzar zaala antara egdzar ŋwasha umele. ");
INSERT INTO mfi_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ragaw magaamaga yawe kul keƴe ju buwa, a ye Saraku. ");
INSERT INTO mfi_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Am iga aà a ye Saraku maa, Ragaw a magaa yawe dermeke buwa an vuye zlaɓe adaliye, a yayaa egdzar zaala antara egdzar ŋwasha umele. ");
INSERT INTO mfi_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Saraku magaamaga yawe kul keƴe, a ye Nakaur. ");
INSERT INTO mfi_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Am iga aà a ye Nakaur maa, Saraku a magaa yawe dermeke buwa zlaɓe adaliye, a yayaa egdzar zaala, antara egdzar ŋwasha umele. ");
INSERT INTO mfi_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nakaur magaamaga yawe kul buwa ju maselmane, a ye Taara. ");
INSERT INTO mfi_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Am iga aà a ye Taara maa, Nakaur a magaa yawe dermeke an kelaawa ju maselmane zlaɓe adaliye, a yayaa egdzar zaala, antara egdzar ŋwasha umele. ");
INSERT INTO mfi_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Taara magaamaga yawe kul vuye, a ye Abraama, antara Nakaur ira Haran. ");
INSERT INTO mfi_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Naàwa labare aà Taara an emndaara: Taara a ye tara Abraama antara Nakaur ira Haran. Haran a ye Ludu, ");
INSERT INTO mfi_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","mazlaara a naba emtsehe eddeŋaara keni zlaɓe aà ba an shifa. A emtsaa aà ba am ekse na ta yanaa am huɗaara na, am berni aà Ur, am Kaldiya. ");
INSERT INTO mfi_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Tara Abraama antara Nakaur ta ge gyaalaha. Zhera aà mukse aà Abraama Saray. Zhera aà mukse aà Nakaur Milka. Milka ŋanna waà, egdze aà Haran eddetare palle an Yiska. ");
INSERT INTO mfi_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saray maa, ŋane dzire aà yeka ɓaaka egdzaara. ");
INSERT INTO mfi_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Taara a naba tse antara egdzaara Abraama, antara eggyeŋaara Ludu egdze aà egdzaara Haran, antara Saray shawlaara, mukse aà egdzaara Abraama, a naba tsetehe am Ur, am kwara aà Kaldiya antara emndaara, kwaye ta zlala aà dem Kanaana. Daraada am Harran waà, de njarinja aàhuwa. ");
INSERT INTO mfi_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Iva aà Taara magaamaga dermeke buwa an ilyeɓe lauktu aà emtsa. A emtsaa am Harran ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","A ba Yaakadada aà elvan ge Abraama: Sesse am lardaaŋa, sesse am jebaaŋa, sesse am mba aà eddeŋa, ezlzlala aà dem larde na ni watse yaà kwaraksaà ya. ");
INSERT INTO mfi_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Yaà de yaikteya, yaà de gagve larde ƴaikke. Yaà de gak barka, yaà de ganvege zheraaŋa zhera ƴaikke. Kaà de gev barka ge emnde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Yaà de gater barka ge emnde na ni taà de gak barka ge ekka. Yaà de nyainyai emnde a nyainyaiknyainye. Yaà de gaterar barka ge emnde na taà ate haha baɗemme aɗaba ka. ");
INSERT INTO mfi_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Daaci a naba tsetehe ge Abraama, a naba zlala ba seke una a bannaa Yaakadada na. ");
INSERT INTO mfi_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abraama magaamaga yawe kul vuye jilyeɓe am sarte na a kezla am Harran. A eksetaa muksaara Saray antara Ludu egdze aà egdze a emmeŋaara, antara navahaara na a shateraa am Harran ŋanna baɗemme ira nalmanaatare baɗemme, ba zlalaatare aà dem Kanaana. Daraada am larde aà Kanaana ŋanna maa, ");
INSERT INTO mfi_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abraama a naba degashe an huɗe aà larde aà Kanaana ŋanna peraatte, haa a daahe aà dem tate na taà ɗahana an Sikaim na, am tate aà nafa ƴaikke na taà ɗahana an Maure na. Am sarte ŋanna maa, emnde a larde taà aŋkwa am Kanaana. ");
INSERT INTO mfi_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","A naba marapsehe ge Yaakadada aà katafke aà Abraama, a ba ŋane aà elvan ge ŋane: Larde na waà, yaà de vaterte ge wulfahaaŋa. Daaci Abraama a naba nderanaa tate aà fana sadake aàtekwa ge Yaakadada na a maranaa iraara na am tate ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","A tsetehe am tate ŋanna maa, kwaye a zlala aà dem Baytila, aà dem geɗiyaara am huɗe aà wa. A de icese slalaara am tate ŋanna, a magaa berahaara an kacakaca am dagave aà tara berni aà Baytila am puti antara berni aà Ayu am geɗiyaara ŋane keni. AÀhuwa keni Abraama a nderanaa tate aà fana sadake aàtekwa ge Saksage, a magaa maduwa, a ɗaha Dadaamiya an Saksage am maduwaara. ");
INSERT INTO mfi_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Mazlaara a naba kezla aàhuwa keni, a eksetaa baraàmaara aà dem dalbe aà manem. ");
INSERT INTO mfi_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Samsa waya aà sem larde, waya ŋanna keni ƴaikke jipu. Abraama a naba kezla aà dem Misera geni aà de shekwaashekwa aàhuwa cekwaaŋguɗi. ");
INSERT INTO mfi_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Herzharanteherzhe haha aà Misera waà, a ba Abraama aà elvan ge muksaara Saray: Ka cenancena emtu, naàwa ekka, ka mukse zari jipu. Diyandiya geni ");
INSERT INTO mfi_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","maà de puwartepuwa icaatare ate ka emnde aà Misera, taà de baà: Muksaara degi una, daaci taà de ja shifaaruwa, amaà ekka waà, taà de jaŋka. ");
INSERT INTO mfi_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","De bateranba ka egdze a emmerwa, geni a fariyufe hyema, a njaninja lapiya am barkaaŋa. Yaà eŋzlanaaŋezla shifaaruwa am barkaaŋa. ");
INSERT INTO mfi_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","De tsekwatsekwa Abraama am Misera, emnde a Misera taà zhara zarire aà muksaara na jauje ge ndzeɗa. ");
INSERT INTO mfi_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Galipaha aà Firawna keni naranna. Itare ta naba danaa zlebaara ge slekse, se daranda mukse na aà dem mba aà slekse. ");
INSERT INTO mfi_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Sleksu Firawna a maganaa shaigerire kwakya jipu ge Abraama aɗaba mukse na. A naba halanu dabbaha kwakya: kyawaha, eslaha, ezzeŋwaha antara ezlegwamaha. A vante antara navaha ira kwatenaha. ");
INSERT INTO mfi_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Amaà Dadaamiya Saksage a ɓelanar masiba ƴaikke ge sleksu Firawna antara emndaara baɗemme aɗaba elva aà Saray, mukse aà Abraama. ");
INSERT INTO mfi_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Mazlaara Firawna a naba ɗante Abraama, a ba ŋane aà elvan ge ŋane: AÀzara una ka magita ka na? Labara bakiyanka geni muksaaŋa? ");
INSERT INTO mfi_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Labara ka bantsa egdze a emmeŋa geni yaà naba eksanteksa, yaà ganvege muksaaruwa? Kwaye muksaaŋa mazlaara eksanteksa, ezlzlala! ");
INSERT INTO mfi_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Firawna a vaterte elvaara palle ge emndaara, geni a varanteva baraàma ge Abraama, a ezlzlala. A eksaneksa muksaara antara kazlaŋaara baɗemme, a ezlzlala. ");
INSERT INTO mfi_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Tsetse Abraama am Misera, aŋkwa aà eptsa aà sem Kanaana am Puti, ŋane antara muksaara, antara kazlaŋaatare baɗemme. Ludu keni aà aàzeŋaara. ");
INSERT INTO mfi_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abraama ŋanna ndza sleberba jipu. Kwakya dabbahaara, kwakya gursaara antara dindar baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Abraama aŋkwa aà maga ba shula. A tsetehe am manem ŋanna, kwaye a zlala aà dem Baytila, am tate na ni ndza a magaa beraha aà kacakaca aàtekwa na, am dagave aà tara Baytila an Ayu. ");
INSERT INTO mfi_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","A baà am tate na ni ndza a nderaanaa tate aà fana sadake aàtekwa ge Dadaamiya werre na. Abraama a magaa maduwa, a ɗante Dadaamiya an Saksage am maduwaara. ");
INSERT INTO mfi_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ludu na aàzeŋaara na maa, ŋane keni an waldaha aà elsahaara antara kyawahaara, antara nawahaara halal. An beraha aà kacakacaara keni baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Nalmane aà tara Abraama antara Ludu kwakya jipu. Cekwa kaambaatare geni taà nja aàtirpalle. ");
INSERT INTO mfi_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Aɗaba una ŋanna tsetse wava am dagave aà suniyaha aà Abraama antara suniyaha aà Ludu. Emnde a haha am sarte ŋanna, emnde a Kanaana antara Pairaisiyaha, itare keni taà aà ba am haha ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Daaci a ba Abraama aà elvan ge Ludu: Taslaaŋa a jerka dagala am dagavaamiya antara ka ɗekiɗeki, ma am dagave aà suniyahaamiya keni. Aɗaba ma ba emnde a haà palle. ");
INSERT INTO mfi_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Naàwa haha baɗemme aà katafkaaŋa. Mi naba tegave. ɓaaka laàmbaaŋa ɗekiɗeki naba eksesekse dalbe na kaà katana ka. Maki ka eksese dalbe aà naɗafa, iya yaà dem nazlaɓa. Maàki ka eksese dalbe aà nazlaɓa, iya yaà dem naɗafa. ");
INSERT INTO mfi_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ludu a kante ice, a naa kaamba aà Urdun shaigera jipu, kaamba baɗemme ba slerekke. Aɗaba am sarte na zlaɓe Yaakadada kaɗanaaka tara Saudauma antara Gaumaura, dem Jauwar ndza ba seke zlanna aà Yaakadada, ndza ba seke haha aà Misera. ");
INSERT INTO mfi_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Daaci Ludu a eksananse kaamba aà Urdun ŋanna baɗemme ge iraara, mazlaara a naba kezla aà dem geɗi. Ta tegava estuwa tara Abraama antara Ludu. ");
INSERT INTO mfi_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abraama ŋane njaanja am haha aà Kanaana, Ludu, ŋane a de icese slalaara am huɗe aà kaamba, a velanaa aà dem Saudauma. A magaa berahaara an kacakaca. ");
INSERT INTO mfi_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Amaà waà, emnde a Saudauma ŋanna ta maàndzawaha jipu. Kwakya haypaatare aà katafke aà Yaakadada ");
INSERT INTO mfi_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Am sarte na Ludu ƴanaaƴa Abraama, zlaazlala, a ba Dadaamiya aà elvan ge Abraama: Kanteka icaaŋa, ezhzhara aà dem yala antara aà dem geɗi, aà dem puti, antara aà dem manem baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Haha ŋanna kaà aŋkwa aà zharana ka na waà, yaà vakte ge ekka antara wulfahaaŋa baɗemme, dem ba ge ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Yaà yaktiya ba seke berbere aà haha. Ba seke una ni kaà dzegwanka kezla berbere aà haha na waà, wulfahaaŋa keni taà hyanuka ba estuwa. ");
INSERT INTO mfi_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Tsetse, naba jemje ɗaba am haha na baɗemme, nanaana walaara antara ƴaikkiraara an vuwa baɗemme. Aɗaba ya vakte ge ekka. ");
INSERT INTO mfi_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abraama a naba kezla, a de magaa slalaara an beraha aà kacakaca am ekte aà nafaha am Mamre, herzhe an Haiburuun. A nderanaa tate aà fana sadake aàtekwa ge Yaakadada am tate ŋanna keni. ");
INSERT INTO mfi_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Am zamane aà sleksu Amrafail slekse aà Sine'ar, antara Ariyauk slekse aà Ailasar, antara Kaidaulayaumair slekse aà Ailam, antara Tidal slekse aà Gauyim, ");
INSERT INTO mfi_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","sleksaha ŋanna ta naba dateraa waàva ge sleksaha umele ilyeɓe: ta dateraa waàva ge tara sleksu Baira, slekse aà Saudauma antara Birsa, slekse aà Gaumaura, antara Siniyabu, slekse aà Adama, antara Saimaibair, slekse aà Jaibauyim ira slekse aà Baila, Jau'ar keni ba zhera aà kwara ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Sleksaha ilyeɓe na keni ta naba magaa waada, ta jamme am kaamba aà Siddim, ɗaàmbake zlaɓe adaliye. Kina waà, tate ŋanna gevge haye baɗemme, taà ɗahana an haye aà izhe. ");
INSERT INTO mfi_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Yawe kelaawa ju buwa taà aàŋkwa aà fansarfe ge sleksu Kaidaurlayaumair. Amaà ate iva kelaawa ju keƴire waà, ɓasharka mazlaara. ");
INSERT INTO mfi_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ate iva kelaawa ju ufaɗire maa, sleksu Kaidaurlayaumair antara sleksaha umele na yaatare palle na, ta naba se gaa ndzeɗa arge emnde a Raifa am Astairaut Karnayim, ta de gaa ndzeɗa arge emnde a Suni am Hama, ta de gaa ndzeɗa arge emnde a Aimi am kaamba aà Kiriyatayim. ");
INSERT INTO mfi_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Ta de gaa ndzeɗa arge emnde a Hauri zlaɓe adaliye aà ba ate ire aà waatare, am Sai'ir. Ta ɗabemhe peraatte dem Ail Paran herzhe an we aà kaamba, zaruze baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Daaci ta naba eptse kwa. Saraasa am Ain Mispat, an Kaadais keni taà ɗaha ba ekse ŋanna aàhuwa keni ta se gaa ndzeɗa arge Amalaikiyaha am hahaatare baɗemme, ta zateruhe mette an naàza erva. Amauriyaha na taà am Hasasau Tamar keni ba estuwa, itare keni zarateruze an naàza erva baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Daaci duwa aà sleksaha, slekse aà Saudauma, slekse aà Gaumaura, slekse aà Adama, slekse aà Jaibauyim ira slekse aà Baila, amaana Jau'ar. Sleksaha ŋanna ta naba sesaa emndaatare baɗemme, ta se tsatsaa waàva am kaamba aà Siddim. ");
INSERT INTO mfi_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Daaci se daremda am waàva ƴaikke antara sleksaha na, itare keni taà an emndahaatare: Sleksu Kaidaurlayaumair ŋane slekse aà Ailam, antara Tidal slekse aà Gauyim, antara Amrafail slekse aà Sine ˆar, antara Ariyauk slekse aà Ailasar, amaana: sleksaha ilyeɓe taà wava an sleksaha ufaɗe. ");
INSERT INTO mfi_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ay mbate, kaamba aà Siddim ŋanna baɗemme an yaà evvegaha. Ta de zhagade, de valyaremvalye aà dem evvegaha na tara slekse aà Saudauma antara slekse aà Gaumaura. Jugena aà emnde na, kyarekya, zhagadarzhagade aà dem waha. ");
INSERT INTO mfi_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Daaci emnde na garega ndzeɗa na ta naba halante nalmane aà emnde a Saudauma antara emnde a Gaumaura na baɗemme, antara ba naàza zaatare na ndza an sheɓe, habazarsehabaze baɗemme, zlarzlala an ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ludu egdze aà egdze a emmeŋaara ge Abraama na ndza an Saudauma na keni eksarvaksa, ŋane-ka, nalmanaara-ka, baɗemme zlarzlala an ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Aŋkwa edda aà sera umele ŋezlaŋzla, a se ɓalanansa ŋane labare ge Abraama, ura Ibraniŋkau, aà nja am ekta aà nafaha aà Maàmre ura Amauri, nafaha ŋanna saɗaɗɗe jipu. Mamre ŋane egdze a emmetare ge tara Aiskaul antara Anair, ta emnde a namaàna jipu antara Abraama. ");
INSERT INTO mfi_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","De cenaàncena Abraama geni kelaadaha eksarvaksa egdze aà egdze a emmeŋaara daraànda, a naba jemaa emndaara, dawalaha na mbarmbe waàva jipu na, zaala dermeke keƴe an kelaawa ju tise. Daaci yalla, a daa ɗaba kelaadaha na dem Dan. ");
INSERT INTO mfi_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Abraama a de tegese emndaara gergere kwakya, daaci ŋane antara dawalahaara na a naba datererhe ge kelaadaha na an waàva an vaƴiya. A naba gaa ndzeɗa arge sleksaha ŋanna, a kyateraahe, a ɗabateremhe aà dem Hauba herzhe an Damas, am dalbe aà manem. ");
INSERT INTO mfi_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","A lyevaa nalmanaatare baɗemme, a saahe an ŋane. Ludu egdze aà egdze a emmeŋaara na keni a naba sanaahe. Ludu ŋanna, ŋwashaha, emnde umele na ndza sluwaratervasluwe na, antara nalmanahaatare baɗemme sarateraasa. ");
INSERT INTO mfi_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Am sarte na Abraama gaaga ndzeɗa arge Kaidaurlayaumair antara sleksaha umele na yaatare palle na maa, a naba eptsa. A naba sesehe ge slekse aà Saudauma, a de yainuhe am kaamba a Sawe. Kaamba ŋanna waà, taà ɗahana an kaamba aà sleksaha. ");
INSERT INTO mfi_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Malkisadaka, slekse aà Salima, zlaɓe adaliye ŋane liman aà Dadaamiya na an nire ge emnde baɗemme na, ŋane keni a sesehe, a saa ɗafa antara egdze a mbazla am erva. ");
INSERT INTO mfi_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","A se gar barka ge Abraama, a ba ŋane: Abraama, a gagga Dadaamiya na an ire ge emnde baɗemme na barka. ŋane edda aà samaya antara haha. ");
INSERT INTO mfi_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Zheraara a gevge an gaàlaà, Dadaamiya na ni an nire ge emnde baɗemme, a fakem kelaadahaaŋa am erva na. Daaci Abraama a sanse luser am nalmanaara baɗemme, a vante. ");
INSERT INTO mfi_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","A ba slekse aà emnde a Saudauma na aà elvan ge Abraama: Taslaaŋa viteva ka ba emndaaruwa, ŋanaaŋa nalmane baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","A ŋwanante ge Abraama, a ba ŋane aà elvan ge ŋane: Naàwa ervaaruwa, kanakanteka aà katafke aà Yaakadada, Dadaamiya na aà nire ge emnde baɗemme, edda aà samaya antara haha na, yaà zaku ba waɗaara: ");
INSERT INTO mfi_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ba uwe keni yaà ekseka ya am nalmanaaŋa. Una ba zawa aà kimakaaŋa palle, ba hulma aà sluzhaaŋa keni. Kaà de baànka ka gananga nalmane ge Abraama. ");
INSERT INTO mfi_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ba naàzaraaŋa keni yaà ekseka ya maà ba una ta zuwaa dawalaha-ka. Amaà dza aà malaha na ta daa ɗabiɗaba na waà, yaà eksarekse, tara Anair, Aiskaul ira Mamre. Itare waà, a halarvaahala nubaatare. ");
INSERT INTO mfi_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Am iga aà labare ŋanna maa, Abraama shansha waàhaya, aŋkwa aà ndahan elva Saksage, a ba ŋane: Abraama, a waŋka lyawa ɗekiɗeki, ya gwelakwaaŋa ba iya an iraaruwa. Kwakya laɗaaŋa aàzerwa. ");
INSERT INTO mfi_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","A ŋwanante ge Abraama, a ba ŋane: Ba estuwa Yaakadadaaruwa, Saksagaaruwa. Amaà watse kaà de vite uwe ɗemme ka? Naàwa aŋkwa aà zla ndzeɗaaruwa baɗemme, amaà egdzaaruwa yaà de ƴaànaà am iga keni ɓaaka. Ba warataaruwa keni a de zaànaà ba Ailiyaijair egdze aà emnde a Damas. ");
INSERT INTO mfi_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","A farhe zlaɓe adaliye, a ba ŋane: Saksagaaruwa, ɓashakika wulfe ma, eddawna ta yanaa am huàɗe aà haaruwa na waà, watse sleza warataaruwa ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Amaà a tsekwe ge kwara aà Yaakadada zlaɓe adaliye aàsezeŋaara, a ba ŋane: ŋane ka sleza warataaŋa. AÀ de zaànaà ba eddawna aà de segashe am ka malle. ");
INSERT INTO mfi_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","A sanse aàsegashe, a ba ŋane aà elvan ge ŋane: Ezhzhaàraà ice aà dem samaya, ekkezla terlyakwaha na maà kaà dzegwaàndzegwa! Daaci a ba ŋane aà elvan ge ŋane: Wulfahaaŋa keni watse ba estuwa. ");
INSERT INTO mfi_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abraama a naba fetarhe ate elva na a ndasaa Saksage na. Aɗaba una ŋanna, Yaakadada keni a fe ŋane ate edda aà jirire. ");
INSERT INTO mfi_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","A ba Dadaamiya aà elvan ge Abraama: Ba iya una ya Yaakadada, ya sakse am Ur am haha aà Kaldiya, ya sakaa aàsehuna geni yaà vakte haha na ge ekka. ");
INSERT INTO mfi_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","A ŋwanante ge Abraama, a ba ŋane: Yaakadadaaruwa, Saksagaaruwa, yaà de dise estara geni ba jirire haha na vakiteva ge iya? ");
INSERT INTO mfi_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","A ba Yaakadada aà elvan ge ŋane: Kwaye, de tatayevaatataya gyaale sla aà yawe keƴe antara naàwe a yawe keƴe antara zhel kyawe a yawe keƴe ira takala a masar palle antara takala a kaamba palle, siyansa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abraama a naba tatayevaa dabbaha ŋanna antara ƴiyaha ŋanna baɗemme, a ɗatsanme bubuwa am dagave kalkale. Sey ba ƴiyaha waà, ɗatsaaka am dagave na. Amaà ba kelaa dabba waà, ba a icanme kalkale waà, a ɓa zlateraahe ma urara keni an ndaŋŋire a una. ");
INSERT INTO mfi_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Waàva ge zaatataha arge hyuwaara, amaà a bakaterbaka Abraama. ");
INSERT INTO mfi_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Herzhe aà eblya vaciya maa, Abraama ŋanaaŋa hare jipu, lyawa keni aà wanwa aɗaba gevge ba tabeɗamme an tsaka ire. ");
INSERT INTO mfi_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Daaci a ba Saksage aà elvan ge ŋane: A njinja am vuwaaŋa ganakini wulfahaaŋa taà de nja am larde aà emnde. Watse taà de gev navaha aà emnde ŋanna, taà de magatera palasa am iva dermeke ufaɗe. ");
INSERT INTO mfi_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Amaà watse ya pelsepele ya ate emnde ŋanna taà de magateraà navire ŋanna. Am iga aà una ŋanna maa, taà de sesse am larde ŋanna an nalmane kwakya jipu. ");
INSERT INTO mfi_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ekka maa, kaà de bere eggyahaaŋa am faya aà ba an hairire. Kaà de gev emgyegwe kurcumme lauktu kaà de emtsa. ");
INSERT INTO mfi_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Wulfahaaŋa taà de eptsa aàsehuna waà, sey am zamane ge ufaɗire. Aɗaba kina zlaɓe haypa aà Amauriyaha jawka ge ndzeɗa geni yaà bakatersebake. ");
INSERT INTO mfi_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Eblyablya vaciya ba ɗekiɗeki, gevge vaƴiya baɗemme maa, taà zhaàraà ba gahe aà kaàraà, tara nara aà kaàraà antara ƴire aà kaàraà taà segashe am huɗaara, aà zlala gahe na am dagave aà dabbaha na an ɗatsa na. ");
INSERT INTO mfi_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Dadaamiya Saksage keni a ŋgweɗe namaàna ba vacite ŋanna an Abraama, a ba ŋane aà elvan ge ŋane: Haha na waà, vanaterteva ge wulfahaaŋa, tsante ate haye aà Misera, dete haye ƴaikke na taà ɗahanaà an Aifratis na baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Larde aà Kainiyaha, larde aà Kainijiyaha, larde aà Kadmauniyaha, ");
INSERT INTO mfi_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","larde aà Haitiyaha, larde aà Pairaisiyaha, larde aà Raifaha, ");
INSERT INTO mfi_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","larde aà Amauriyaha, larde aà Kanaaniyaha, larde aà Girgasiyaha ira larde aà Yaibusiyaha baɗemme, yaà de vakte ge ekka. ");
INSERT INTO mfi_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Saray, mukse aà Abraama yaneka egdzere ge zhelaara ɗekiɗeki. Aŋkwa kwatenaara egdze aà emnde a Misera, zheraara Hajara. ");
INSERT INTO mfi_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","A ba Saray aà elvan ge zhelaara Abraama: Naàwa iya, fiyarfe Dadamiya yaà yeka. Naba njawinja antara kwatenaaruwa na, ambane watse yaà shansha ɗeme egdzere ate ŋane. Lyavaalya ervauŋɗe aà Abraama elva aà Saray na. ");
INSERT INTO mfi_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Daaci Saray a naba eksante Hajara kwatenaara, a vante ge zhelaara Abraama geni aà ganvege muksaara. Iva kelaawa una a maganaa Abraama am haha Kanaana. ");
INSERT INTO mfi_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Daaduwa Abraama aàdeza Hajara, Hajara a naba shaa huɗe. Ba a naa a shaa huɗe na waà, a naba fantau ge zhaàraà zanwaara Saray an ice a epsawa. ");
INSERT INTO mfi_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Daaci a ba Saray aà elvan ge Abraama: Emtaŋkire na ni ndza arge iya na waà, kina eptsakaareptse ge ekka. Hajara kwatenaaruwa ge iya, ya eksante ba iya ervaaruwa ya fakem am huviye ni, gevge ni aà zhari ba seke ya kere am icaara aɗaba a shaa huɗe! Miya antara ka waà, aà hyephye Dadaamiya Yaakadada dagavaamiya. ");
INSERT INTO mfi_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","A ba Abraama aà elvan ge Saray: Kwaye kwatenaaŋa, ba kina keni aà ba am ervaaŋa. Emmaga naàzena ni kaà katana ka an ŋane. Daaci Saray a naba maranaa zlaɗa kwakya ge Hajara, Hajara zhagadaazhagade aàtuge ŋane, a naba keɗeme am kaamba. ");
INSERT INTO mfi_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Malika aà Yaakadada a de bere Hajara am kaamba, aà nja ate we aà yawe. Yawe ŋanna herzhe an barama a dem Sura. ");
INSERT INTO mfi_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","A ba malika na aà elvan ge Hajara: Hajara kwatena aà Saray, ka sawa ame? Kaà deme kina? A ŋwanante, a ba ŋane: Yaà aŋkwa aà zhagade aàtuge zanwaaruwa Saray. ");
INSERT INTO mfi_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","A ba malika na aà elvan ge ŋane: Ba kina eptseptsa aàdeza zanwaaŋa. De ganaaga iraaŋa aà dem aha aàkatafkaara. ");
INSERT INTO mfi_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","A ba malika aà Yaakadada aà elvan ge ŋane zlaɓe adaliye: A ba Yaakadada yaà de yaterteya egdzaraaŋa, taà de gev kwakya jipu, ɓaaka kezlakulaatare. ");
INSERT INTO mfi_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","A ba malika aà Yaakadada aà elvan ge ŋane: Naàwa kaà aà huɗe, watse kaà yaà egdzere zhele, kaà fana zhera aà Isemayiila, aɗaba Yaakadada cenancena zlaɗaaŋa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Amaà egdzaaŋa ŋanna waà, watse slemaàndzawa ba seke ezzeŋwa a kaamba. Ervaara aà de sha emnde baɗemme, emnde keni baɗemme watse ervaatare aà de sha ŋane. Watse aà nja ba ŋane palle aà de gaterapteka ge egdzar mamahaŋaara ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Am iga aà una ŋanna maa, a ba Hajara: Abi iya keni ya nanna ŋane eddawna a nina na? Aɗaba una a ɗaha Yaakadada na a ndahan elva na an: Dadaamiya na aà nina. ");
INSERT INTO mfi_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Aɗaba una ŋanna, suwa ŋanna taà aŋkwa aà ɗahana an suwa aà Dadaamiya aŋkwa aà nina. Suwa ŋanna am dagave aà tara Kaadais antara Baarait. ");
INSERT INTO mfi_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Daaci Hajara a yan egdzere zhele ge Abraama. Abraama a fete zhera aà egdzaara na a yanaa an Hajara na Isemayiila. ");
INSERT INTO mfi_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Iva aà Abraama shanasha kul tise juŋkwahe am sarte na Hajara a yan Isemayiila. ");
INSERT INTO mfi_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abraama shanaasha yawe kul maselmane, Yaakadada a naba marapsehe aà kataftkaara, a ba ŋane aà elvan ge ŋane: Ba iya una ya Dadaamiya, hakuma baɗemme aà ba am ervaaruwa. Njinjaaŋa aàkatafkaaruwa, a jerka duksa maàndzawe ate ka am njaaŋa. ");
INSERT INTO mfi_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Naàwa yaà aŋkwa aà maga namaàna am dagavaamiya antara ka: Yaà vakte yaà, yaà de yaàkteyaà kwakya jipu. ");
INSERT INTO mfi_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Daaci Abraama a kezlan ugje ge Dadaamiya, wafkaara ba teppe ate haha. A ba Dadaamiya aà elvan ge ŋane zlaɓe adaliye: ");
INSERT INTO mfi_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Elvaaruwa ge ekka waà, namaànaaruwa vanakteva zlauzle, kaà de gev eddarge nalgaha kwakya. ");
INSERT INTO mfi_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","AÀsalikataliya na waà, taà dalika aà ɗahaàkaà an Abraama mazlaara, amaà Ibrahiima. Aɗaba ganagvege eddarge nalgaha aà emnde kwakya. ");
INSERT INTO mfi_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Yaà de gagvege eddawna ni jebaara kwakya jipu na, yaà de yakteya kwakya jipu, kaà de gev eddarge nalgaha aà emnde, sleksaha gergere taà de segashe am emndaaŋa. ");
INSERT INTO mfi_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Namaànaaruwa na ya ŋguɗakan ge ekka na waà, antara ge egdzaraaŋa keni baɗemme, dem eggyeggye. Namaànaaruwa ŋanna saksage geni ya Dadaamiyaaŋa, ya Dadaamiya aà egdzaraaŋa keni am igaaŋa. ");
INSERT INTO mfi_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Haha ŋanna naàwa ka wayve am huɗaara na waà, yaà vakte ge ekka antara egdzaraaŋa baɗemme, naàza ba ge ɗekiɗeki. Haha aà Kanaana baɗemme aà de gev naàzaaŋa, antara egdzaraaŋa am igaaŋa, watse ba iya una ya Dadaamiyaatare. ");
INSERT INTO mfi_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","A ba Dadaamiya aà elvan ge Ibrahiima zlaɓe adaliye: Ekka waà, ɗemanveɗeme ka ba namaànaaruwa, ekka antara egdzaraaŋa baɗemme dem eggyeggye. ");
INSERT INTO mfi_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Naàwa naàzena kwaà de magana kure ge tsufa namaàna na ya ŋguɗana ya antara kure: Ba kelaa ma yakuraya egdzere zhele kwaà ɓelana am sheɗekwe. ");
INSERT INTO mfi_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Dawemda am sheɗekwe. Una ŋanna nalaama aà namaàna na am dagavaamiya na, iya antara kure. ");
INSERT INTO mfi_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ba kelaa maà yakuraya egdzere zhele am jebaakure, kwaà ɓelana am sheɗekwe am hare ge tisire. Dete ba una gavka jebaakure keni ma ta yanaa aà ba am huɗe aà haà aà kure tsawe. ");
INSERT INTO mfi_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ma una ta yanaa am huɗe aà haà aà kure, ma una kwa shekweve an shekwe keni baɗemme puwawaterempuwa am sheɗekwe ɓaaka shaige. Una ŋanna nalaama aà namaànaaruwa ge kure, an puwa ate vuwaakure. Namaàna ŋanna saksage. ");
INSERT INTO mfi_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Amaà zhele na ɓaaka am sheɗekwe, icaaka zheliraara ɗekiɗeki na waà, a jaranaaja shifaara ba ɗekiɗeki am jebaara. Aɗaba ŋane ebzubze namaànaaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Daaci a ba Dadaamiya aà elvan ge Ibrahiima: Kina waà, ɗaheka muksaaŋa an Saray mazlaara. AÀ salikataliya na waà, zheraara Saratu. ");
INSERT INTO mfi_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Yaà de ga barkaaruwa ate ŋane, yaà de vakte egdzere zhele an ŋane. AÀ de gev emmarge nalgaha gergere. Sleksaha gergere antara jebaha aà emnde gergere aà de segashe am ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ibrahiima a kezle ugje, wafkaara ba teppe ate haha, amaà waà, ambera aà dzaka. Aɗaba a ba ŋane am ervauŋɗaara: Emgyegwe a zhele yawe dermeke ni kwasau zlaɓe aà de yaà egdzere? Ma Saratu keni emgyegwe a mukse yawe kul maselmani ni aè de ya egdzere? ");
INSERT INTO mfi_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Daaci a ba ŋane aà elvan ge Dadaamiya: A shifeteshifa ŋane ba Isemayiila aàkatafkaaŋa, ɓaaka naàzu yaà ƴekana umele. ");
INSERT INTO mfi_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Amaà a ŋwanante ge Dadaamiya a ba ŋane: Baaka shaigaara ɗekiɗeki, muksaaŋa Saratu aà de yaka egdzere zhele, kaà de ɗahana an Isiyaaku. Yaà de ŋguɗa namaànaaruwa antara ŋane ira egdzaraara am igaara ge ŋane. Namaànaaruwa ŋanna saksage. ");
INSERT INTO mfi_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Duksa palle waà, lyanvaalya ƴekaaŋa ate Isemayiila. Yaà de ga barkaaruwa ate ŋane, yaà ganve ura kwakya jebaara. Yaà huyanahuya kwakya jipu, sleksaha kelaawa ju buwa una taà de segashe aà ba am ŋane. ŋane ŋanna waà, yaà de ganvege nalga ƴaikke. ");
INSERT INTO mfi_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Amaà namaànaaruwa waà, yaà ŋguɗana antara Isiyaaku, egdze na ni aà de yakaa Saratu na. AÀ de yakaa egdze ŋanna am shifa sarte ba seke una. ");
INSERT INTO mfi_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Zlauzle am tsakana elvaha na ge Abrahiima maa, a zlalehe ge Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Am iga aà una ŋanna, Ibrahiima a eksante egdzaara Isemayiila, antara navaha na ta yateraa am huɗe aà haara ira emnde na a shekwaterve an nalmanaara, baɗemme a puwaterme am sheɗekwe vacite ŋanna, ba seke una a ndahanaa Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Am sarte na Ibrahiima aà dem sheɗekwe, ivaara kul maselmane ju maselmane. ");
INSERT INTO mfi_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Egdzaara Isemayiila an yawe kelaawa ju keƴe am sarte na aà fana am sheɗekwe. ");
INSERT INTO mfi_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Tara Ibrahiima antara egdzaara Isemayiila ta dem sheɗekwe aà ba ate vaci palle. ");
INSERT INTO mfi_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ba duksa palle ge emnde na taà am huɗe aà haara keni. Emnde na ta yateraa am huɗe aà haara, antara emnde na a shekwaterve an shekwa, zaalaha baɗemme, ta dem sheɗekwe aà ba am hare ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yaakadada a naba marana iraara ge Ibrahiima am dagave aà nafaha saɗaɗɗe am Mamre. Ibrahiima aŋkwa aà nja ate we aà wakyiyaara, beraara baɗemme a maganaa aà ba an kacakaca. Sarte ŋanna keni erva a vaciya jipu. ");
INSERT INTO mfi_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ba estuwa a kante ice waà, aà zhara ba emnde keƴe, zaala taà aŋkwa aà tsatse. Hatstse aà bina a naba tsetehe, aŋkwa aà de yaiteruye ate we aà wakyiya, a kezle ugje ate haha, ");
INSERT INTO mfi_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","a ba ŋane aà elvan ge pallaatare: Yaakadadaaruwa, maàki ba zakivaareze waà, taslaaŋa deska ba estuwa, sawa tsatse am mba aà navaaŋa. ");
INSERT INTO mfi_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Daaci a ba ŋane aà elvan ge itare: Sawmbare puwawansepuwe cekwaaŋguɗe am ekte aà nafa aàhuna, taà sakura egdze a yawe kwaà baraabara serahaakure. ");
INSERT INTO mfi_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Yaà katakurva antara egdze a naàza za, kwaà shansha ndzeɗa, lauktu kwaà fanu ge baraàmaakure aà de katafke ba seke una kwaà katanaà kure. Daaci estuwa, dakureska ba dey arge haà aà slesleraakure. Ta ŋwanante ge wayvaha na, a ba itare: Shagera jipu, naba emmaàga sleraaŋa. ");
INSERT INTO mfi_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ba watsewatse, a eptsa aà ba an hadzala Ibrahiima aà dem bere aàza Saratu, a ba ŋane aà elvan ge ŋane: Degevaadega ukpa na leppe jipu na keƴe ate daramaara, emmaàga gatau watsewatse. ");
INSERT INTO mfi_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ŋane an iraara, zhagadaara aà dem walde a esla, a de eksese egdze a esla na shagera vuwaara, hyuwaara kuɗkuɗe jipu na, a naba fanem am erva ge slesleraara, ŋane aŋkwa aà ganve naàza ɗaàle aà ba ate watsewatsire. ");
INSERT INTO mfi_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Gyepgye naàza ɗaàle na maa, Ibrahiima a satera jeba naza za umele aŋkwa ta magana an uɓa, antara uɓa aà waya, a sateranhe aàtirpalle antara hyuwa na, a faterhe aà katafkaatare. ŋane keni a tsaahe aà ba aàzetare am ekte aà nafa ŋanna haa ta zuhe. ");
INSERT INTO mfi_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Daaci ta ndavanuhe, a ba itare taà elvan ge Ibrahiima: AÀme muksaaŋa Saratu? A ŋwaterante, a ba ŋane: Kwaye ŋane aŋkwa am bere. ");
INSERT INTO mfi_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","A ba palle aà wayvaha na aà elvan ge Ibrahiima: Sarte seke una am shifa watse yaà eptsa, una yaà ndak ba jirire ɓaaka eptsankaara, watse yaà se bere Saratu an egdzere zhele am erva. Saratu keni aà tse aà ba am iga aà Ibrahiima ŋanna ate we aà wakyiya, aŋkwa aà cena elva na. ");
INSERT INTO mfi_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","12","Daaci dzaka ge Saratu an ila, aɗaba Ibrahiima antara ŋane bukerɗaatare garevge emgyegwaha. ŋane ɗeme ba naàɗaatare ŋwashaha keni naàzaara icevice. Aɗaba una ŋanna a ba ŋane am ervauŋɗaara: Am njaaruwa na ni kwasau zlaɓe aŋkwa emtakire aà nja antara zhele? Edda aà haaruwa keni gevge emgyegwe a zhele kurcumme! ");
INSERT INTO mfi_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","A ba Saksage aà elvan ge Ibrahiim: Labara aà dzaka Saratu? Labara a bantsa ŋane am ervauŋɗaara ganevge emgyegwe a mukse ni yaà yaà egdzere-he? ");
INSERT INTO mfi_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Una keni aŋkwa najipuwaara aàza Saksage emtu an sleksiraara? Sarte seke una am shifa, yaà aŋkwa aà eptsa aàsezeŋa, yaà se bere Saratu an egdzere zhele am erva. ");
INSERT INTO mfi_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Jaaja lyawa Saratu maa, a ba ŋane: Dzakanka. A ba Yaakadada keni ba parakke: Ka dzaka. ");
INSERT INTO mfi_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Am iga aà una ŋanna maa, tsaretse wayvaha na keƴe kerɗe, taà aŋkwa aà zlala waà, ta kurese ba ndaŋŋire aà Saudauma. Ibrahiima keni a zlala antara itare, a daa aà puwatersepuwe. ");
INSERT INTO mfi_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Daaci a ba Yaakadada: Yaà tsa sheɓanvuweka ge Ibrahiima naàza na yaà de magana ya. ");
INSERT INTO mfi_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Aɗaba Ibrahiima aà de gev eddarge nalga ƴaikke, nalga na ni watse an hakuma jipu na. Baɗemme aà emnde na taà ate haha taà de sha barka aɗaba ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ya eksese ŋane ganakini aà kwaratersekware ge egdzaraara antara wulfahaara am igaara ge ŋane geni a farfa zherwe ate shairiyahaaruwa, a magarmaàga jirire, a magarmaga duksa baɗemme an baramaara, lauktu yaà gananvege ge Ibrahiima naàzena ya banaa watse yaà vanteva na. ");
INSERT INTO mfi_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Daaci a ba Yaakadada aà elvan ge Ibrahiima: De shisha yawe aà kyuwa aà emnde kwakya, aɗaba naàzena taà aàŋkwa aà maganaà emnde a Saudauma antara Gaumaura. Haypa aà emnde ŋanna jauje ge ndzeɗa. ");
INSERT INTO mfi_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Aɗaba una ŋanna yaà aŋkwa tsekwa aàdehuwa, yaà de habaza magaatare ŋanna maàki ba jirire ba estuwa. Maàki gavka estuwa keni watse ya ŋaa ba diyeddiye. ");
INSERT INTO mfi_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Daaci emnde buwa am wayvaha na eptsaraterveptsa iga, zlarzlala am tate ŋanna, taà aŋkwa aà zlala aà dem Saudauma. Amaà Yaakadada waà, zlalaaka, aŋkwa aà tse aà ba am tate ŋanna, Ibrahiima keni aŋkwa aà ba aà tse aà katafkaara. ");
INSERT INTO mfi_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ibrahiima a ganapte ge Yaakadada, a ba ŋane aà elvan ge ŋane: Kina emnde a jirire na taà aàhuwa keni kaà de keɗaterakeɗa aàtirpalle antara emnde a haypa emtu Yaakadada? ");
INSERT INTO mfi_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","AÀmbane taà ankwa emnde a jirire kul ilyeɓe am Saudauma ŋanna, kaà de keɗaterakeɗa itare keni emtu? Kaà ƴaterareka ge emnde a ekse ŋanna aɗaba emnde a jirire kul ilyeɓe na taà am huɗaara na emtu? ");
INSERT INTO mfi_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Kay! Ekka kaà ta maganaaka jeba una. Emnde aà jirire ni kaà ceɓatera aàtirpalle antara emnde a haypa? Shairiyaatare kalkale? Una aà magaaveka. Eddawna watse aà kyana ŋane shairiya aà duniya baɗemme ni aà kyanaka shairiya a jirire? ");
INSERT INTO mfi_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","A ŋwanante ge Yaakadada, a ba ŋane aà elvan ge ŋane: Maàki shanansha emnde a jirire kul ilyeɓe am huɗe aà berni aà Saudauma waà, yaà naba ƴateraareƴe ge emnde a ekse ŋanna baɗemme aɗaba itare. ");
INSERT INTO mfi_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","A ba Ibrahiima: Taslaaŋa ƴiyareƴe Yaakadadaaruwa, aɗaba maganka lyawa aà katafkaaŋa ɗekiɗeki ge ndakse elva parakke. Iya waà, ya berbere aà haha ba dey, ya kelpa aà kara ba dey. ");
INSERT INTO mfi_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","AÀmbane watse ɓaaka ura ilyeɓe am emnde a jirire kul ilyeɓe na, kaà de keɗaterakeɗa baɗemme aɗaba emnde ilyeɓe na ɓaaka am huɗaara na emtu? A ba Yaakadada: Maki shanansha emnde a jirire kul ufaɗe jilyeɓe am ekse ŋanna waà, yaà keɗeka ekse. ");
INSERT INTO mfi_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Aley, zlaɓe Ibrahiima ƴaànka Yaakadada, a ba ŋane aà elvan ge ŋane zlaɓe adaliye: AÀmbane emnde a jirire ta ba kul ufaɗe am ekse ŋanna maa? A ŋwete ge Yaakadada, a ba ŋane: Maàki shanansha emnde a jirire kul ufaɗe am ekse ŋanna waà, yaà keɗeka ekse. ");
INSERT INTO mfi_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","A ba Ibrahiima: Taslaaŋa Yaakadadaaruwa, a jaŋka ervauŋɗe, yaà aŋkwa aà ndavakundave zlaɓe adaliye: AÀmbane emnde a jirire ta ba kul keƴe am ekse ŋanna maa? A ba Yaakadada: Maàki shanansha emnde a jirire kul keƴe am ekse ŋanna waà, yaà gejeka ekse. ");
INSERT INTO mfi_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","A ba Ibrahiima: Taslaaŋa Yaakadadaaruwa ƴiyareƴe. Aɗaba kwakya elvaaruwa aà katafkaaŋa: AÀmbane emnde a jirire ta ba kul buwa am ekse ŋanna maa? A ba Yaakadada: Maàki shanansha emnde a jirire ni hyephye kul buwa am ekse ŋanna waà, yaà gejika ekse ɗekiɗeki aɗaba emnde a jirire kul buwa ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","A ba Ibrahiima: Taslaaŋa Yaakadadaaruwa, ŋanaaŋa ervauŋɗaaŋa an slakala, yaà ndavaku ba palle mazlaara, yaà farka umele. AÀmbane emnde ŋanna ta ba kelaawa njaiŋŋe am ekse ŋanna maa? A ba Yaakadada: Maàki shanansha emnde a jirire kelaawa am ekse ŋanna waà, yaà gejeka ekse mazlaara aɗaba emnde a jirire kelaawa na. ");
INSERT INTO mfi_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Am sarte na ni Yaakadada mbeɗanumbeɗe elvaara baɗemme ge Ibrahiima, a naba ƴaa Ibrahiima, a naba zlalehe. Ibrahiima keni ba eptsaara aà sem tataara. ");
INSERT INTO mfi_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Herzhe aŋkwa aà maga mangaripu waà, daraada malikaha buwa na keni am Saudauma. Ludu maa, ŋane aŋkwa aà nja ate we aà walkame aà Saudauma ŋanna. Ba a puwete ice ate itare waà, hatstse a naba tsetehe, a de yaiteruye, a kezle ugje aà kataftkaatare wafkaara ba teppe ate haha. ");
INSERT INTO mfi_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","A ba ŋane aà elvan ge itare: Yaakadadaaruwa, taslawaakure, daweska ba estuwa arge haà aà naàvaakure. Sawmbare barawaabare serahaakure, harauhaàre, an eŋlya werre waà, lauktu kwaà tse, kwaà maga shulaakure adaliye. Amaà ta ŋwanante, a ba itare: ŋere ŋaà duka aà dem mba aà ura, ŋaà haraaŋere aà ba aàgashe. ");
INSERT INTO mfi_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Amaà Ludu keni a tsaa aà ba ate naàzaara, aà magatera tasle estuwa, aà ŋatertaà sera. Daaci ta naba duhe, ta demhe aà dem huɗe aà haara. A de magateraa muŋri antara depaiŋ na ɓaaka shahi aà makala am huɗaara na, ta zuhe. ");
INSERT INTO mfi_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ba zlaàva keni zlavareka emtsaaɗe waà, saremsa emnde a ekse aà Saudauma, dawalaha antara emgyegwar zaalahaatare baɗemme saresse am slalaha kaàtaàkaàppe se jarantaaveje ge haà aà Ludu. ");
INSERT INTO mfi_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ta ɗante Ludu, a ba itare taà elvan ge ŋane: Taà aàme dawalaha na ta tsekwaa am mbaaŋa aà ba an vaƴiya vatena na? Satersese aàseze ŋere, ŋaà kaàtaà zlava an itare. ");
INSERT INTO mfi_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","A sesehe ge Ludu aàsezetare, a tsaahe ate we aà wakyiya, a heɗanu ge wakyiya am igaara, ");
INSERT INTO mfi_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","a ba ŋane aà elvan ge itare: Estuweka emndaaruwa, magauka mandzawire na taslawaakure. ");
INSERT INTO mfi_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Naàwa taà aŋkwa egdzarahaaruwa ta buwa, garevge gyaalaha, zlaɓe diyarka zhele waà, yaà satersese itare, kwaà de maga naàzena kwaà katana kure an itare. Amaà zaala na waà, taslawaakure ƴawaterƴa, aɗaba ta wayvaha, taà am huɗe aà haaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Amaà a ba itare taà elvan ge Ludu: Jaŋernaaja ka ate we aà wakyiya! Ka wa ka sawa an sawa, ka wayve ba dey degiya gakevge narkaliyaaŋere? Use dawale, shagera kwa elvaaŋa. Ba kinamina ŋaà magakanaamaga palasa, aà jauje ba ge naàza aà emnde ŋanna. Ta naba puwana tsekweɗa ge Ludu, taà kata kezla paàre aà wakyiya maa, ");
INSERT INTO mfi_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","malikaha buwa na ta naba velese erva, ta teɗante Ludu aà dem huɗe aà haà, ta heɗanu ge wakyiya. ");
INSERT INTO mfi_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ta naba wulfete emnde ŋanna taà ate we aà wakyiya na, malaha dete egdzaraha baɗemme ɓaaka ura aà nanna ice ɗekiɗeki. Ta kuɗevaa ba itare ge tataya we aà wakyiya geni taà demda. ");
INSERT INTO mfi_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Daaci a ba malikaha na taà elvan ge Ludu: Taà aŋkwa emndaaŋa umele am ekse na emtu? Ma egdzaraaŋa, ma shawlahaaŋa, ma emndaraaŋa keni, maà ta varahaaŋa am huɗe aà ekse na waà, satersese. ");
INSERT INTO mfi_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Aɗaba ŋaà kata keɗanaakeɗa ekse na ba ɗekiɗeki. Yaakadada cenancena kyuwa emnde kwakya aɗaba maàga aà emnde a Saudauma. Aɗaba una ŋanna a ɓelaŋera Yaakadada geni ŋaà se keɗanaakeɗa ekse na. ");
INSERT INTO mfi_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","A sesehe ge Ludu, a de mbeɗateru ge shawlahaara, emnde na ta aŋkwa aà sheba egdzaraara, a ba ŋane aà elvan ge itare: Magaumaàga watsewatsire mi zlalawa am ekse na, aɗaba Yaakadada aà kata keɗe ekse ba ɗekiɗeki. Amaà shawlahaara ŋanna ta ganve ba elva a shawya. ");
INSERT INTO mfi_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kyaakya adaga waà, malikaha na ta bakante ge Ludu aà ba an ndzeɗa. A ba itare taà elvan ge ŋane: Tsetse ba watsewatse antara emndaaŋa, muksaaŋa, antara egdzaraaŋa buwa, dawedde watsewatse, a zakuruka duniya aɗaba shariya aà haypa aà emnde a ekse na. ");
INSERT INTO mfi_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Am taà ezhzhara aà hadzaleka Ludu, ta naba ŋanaahe ate erva, ta ŋanaa erva ge muksaara, ta ŋateraa erva ge egdzaraara buwa ŋanna, ta daterse aà dete iga a ekse, ta ƴatera ahuwa, aɗaba Yaakadada wayaaka keɗaara. ");
INSERT INTO mfi_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Am sarte na daratersede aàdete iga a ekse ŋanna maa, a ba palle aà malikaha na aà elvan ge Ludu: Ezhzhagade shifaaŋa aà de cuwa waà, geni a keɗeka shifaaŋa. Zhareka ice aà sem iga, tseka am kaamba keni. ");
INSERT INTO mfi_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Amaà a ŋwanante ge Ludu, a ba ŋane: Estuweka Yaakadada, yaà de dzegwaànka. ");
INSERT INTO mfi_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Urara keni ya ba naàvaaŋa, shanansha ŋgurna aàzeŋa magakiyanmaga shaigerire ƴaikke, ŋezlakiseŋzle waà, yaà dzegwaànka zhagade aà de cuwa wa. Yaà tama aà de shisha emtaŋkire, yaà de cuvaaka wa yaà emtsa. ");
INSERT INTO mfi_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Kaà aŋkwa aà nanna egdze a ekse na kwaye ŋane na emtu? Herzhe ba egdze a ekse ŋanna, yaà dzegwaàndzegwa zhagade aà de cuwa tate ŋanna, taslaaŋa viteva barama ge dehuwa. Egdze a ekse ŋanna ba cekwaaŋguɗi, daaci yaà de sheɓa iraaruwa am huɗaara. ");
INSERT INTO mfi_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Shagera, a ba malika na, yaà magakaà ŋgurna zlaɓe adaliye, yaà ƴaka egdze a ekse ŋanna, yaà gejeka. ");
INSERT INTO mfi_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ezlzlala watsewatse, kaà de sheɓa iraaŋa am egdze a ekse ŋanna, yaà maŋka ba uwe keni sey maà dakaada am ekse ŋanna. Aɗaba una ŋanna, ta fante zhera aà Jau'ar ge egdze a ekse ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Sesse vaciya am haha waà, Ludu keni de tsekwaatsekwa am Jau'ar. ");
INSERT INTO mfi_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Daaci Yaakadada a naba fantau ge hya kaàraà an wesha an baraudu aà sawa am samaya, aà setarge Saudauma antara Gaumaura. ");
INSERT INTO mfi_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Yaakadada a eptsante eksaha ŋanna, antara kaamba a tate ŋanna, antara nafaha baɗemme a ganve ba seke ndza tate ŋanna ka. ");
INSERT INTO mfi_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Mukse aà Ludu maa, ŋane a zharaa ice aà dem kataliya, ŋane keni a naba eptsapte a gev naàkwa aà izhe, amaà ba naàwa ura aà tse aà ba ka. ");
INSERT INTO mfi_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Maàkurallaara a tsetehe ge Ibrahiima an eŋlya werre, a duhe aà dem tate na ni a tsaa aà katafke aà Yaakadada na, ");
INSERT INTO mfi_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","a kante ice aà dem Saudauma antara Gaumaura antara kaambaha aà tate ŋanna baɗemme waà, aà zhara ba ƴire aà kaàraà ƴaikke jipu, ba seke ƴire aà kaàraà kaamba ƴaikke. ");
INSERT INTO mfi_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Am sarte na Dadaamiya a keɗaa eksaha aà tate ŋanna, a naba yehamme Ibrahiima, daaci a naba sanse Ludu ba lapilayye am masiba ŋanna. Amaà eksaha ŋanna ndza Ludu am huɗaara na waà, a ganve ba seke ndza tate ŋanna ka. ");
INSERT INTO mfi_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ludu maa, jaaja lyawa ge nja am egdze a ekse ŋanna taà ɗahanaà an Jau'ar na, aɗaba una ŋanna a naba kezla, kwaye a de nja am hwalakwa am huɗe aà waà, antara egdzaraara buwa egdzara ŋwasha. ");
INSERT INTO mfi_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Daaci a ba egdzere zuŋwire aà elvan ge kudereŋaara: Naàwa eddemiya keni gevge emmgyegwe, am haha na keni ɓaaka eddawna aà shebamisheba seke una taà aŋkwa aà maganaà emnde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Sawa mi ejja eddemiya an mbazla waà, mi zlava an ŋane, watse mi fanefa wulfe ge eddemiya. ");
INSERT INTO mfi_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","An vaƴiya vacite ŋanna, ta naba hyanhe ge eddetare na an mbazla telkusse, a de haàre male aàzeŋaara. Amaà ma sarte na a zlavanuzlave na, ma sarte a zlalaara keni diyaaka eddetare ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","An eŋlya werre, a ɗante kudereŋaara, a ba ŋane aà elvan ge ŋane: Yawwaa, zlawzle kwa naàzaaruwa, an vaƴiya vatena zlavaŋerzlava antara edderwa. Sey mi hyanhya zlaɓe adaliye an mbazla, kaà de hara ka vatena. Estuwa, mi naba fanefa wulfe ge eddemiya. ");
INSERT INTO mfi_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","An vaƴiya, ta naba hyanhe zlaɓe adaliye ge eddetare an mbazla, a de hare sleɗabaara aàza eddetare na. Eddetare diyaaka ɗekiɗeki sarte na a de zlavanuzlave na ma sarte a zlalaara keni. ");
INSERT INTO mfi_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Egdzara aà Ludu bukerɗe sharaànsha huɗe an eddetare. ");
INSERT INTO mfi_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Egdze a zuŋwiraara a ye egdzere zhele, a fate zheraara Mau'ab. ŋane una eggyetare ge Mau'abiyaha sem vatena. ");
INSERT INTO mfi_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Kudereŋaara keni ba estuwa, ŋane keni a ye egdzere zhele, a fete zheraara ɓii'Ammi. ŋane una eggyetare ge Ammauniyaha sem vatena. ");
INSERT INTO mfi_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","A naba kezla Ibrahiima am tate ŋanna, kwaye a de nja am Puti, a de icese slalaara am dagave aà tara Kadais antara Sura. Am iga aà una ŋanna maa, kwaye a de nja am Gairar. Am sarte na taà am Gairar ŋanna maa, ");
INSERT INTO mfi_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","a ba Ibrahiima aà elvan ge emnde a ekse ŋanna ate muksaara Saratu: Egdze a emmerwa aà bina. Daaci a sariyansa mukse ŋanna a ba slekse aà emnde a Gairar, zheraara Abimailaik. A naba ɓela emndaara, ta de eksanvaahe. ");
INSERT INTO mfi_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","An vaƴiya waà, daàmda Dadaamiya aà deza sleksu Abimailaik am shene, a ba ŋane aà elvan ge ŋane: Kina waà, samsa emtsaaŋa, sey kaà emtsa. Aɗaba mukse na ka eksevaa ka na waà, mukse aà zhele. ");
INSERT INTO mfi_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Am sarte ŋanna maa, zlaɓe Abimailaik ɗahaaka emtsaaɗe mukse na aàdezeŋaara. A ba ŋane aà elvan ge Dadaamiya: Yaakadadaaruwa, ma emnde na ɓaaka ba haypaatare keni kaà diya ba ceɓaterceɓa emtu? ");
INSERT INTO mfi_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Aɗaba a binaa ba Ibrahiima an waara, egdze a emmerwa aà bina. A ba mukse keni egdze a emmerwa. Ya maganaa aà ba an ervauŋɗaaruwa palle, maganka niya a maga mandzawire ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","AÀ ba am shene ŋanna, a ba Dadaamiya aà elvan ge ŋane: Ba iya keni diyandiya ganakini ka maganaa a ba an shagerire aà ervauŋɗe. Aɗaba una ŋanna piyanaktepiya maga haypa an ya, vanakteka barama ge nja antara mukse ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Kina waà, danaada mukse na aà dem mba aà zhelaara, aɗaba zhelaara nabi. Watse aà ƴekakuwa ŋane shifa geni kaà eŋzleseŋzle. Amaà maàki dakannaaka muksaara waà, diyeddiye geni ekka iraaŋa antara emndaaŋa baɗemme kwaà de njeka an shifa. ");
INSERT INTO mfi_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","A tsetehe ge Abimailaik an eŋlya werre, a ɗetaa galipahaara baɗemme, a tsakaterse elva ŋanna baɗemme, jaterja lyawa jipu. ");
INSERT INTO mfi_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","A ɗante Ibrahiima keni, a ba ŋane aà elvan ge ŋane: Labara ka magite una? Ya gaku uwe kena estuwa ni, ka de magite una antara emndaaruwa baɗemme am kwaraaruwa na? Naàzena ka magita ka na waà, taà maŋka emnde ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","A ndavanuhe zlaɓe adaliye, a ba ŋane aà elvan ge ŋane: A waktaa uwe demme ni ka naba wayete magite una na? ");
INSERT INTO mfi_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","A ŋwanante ge Ibrahiima, a ba ŋane: Iya, ya kurken emnde a larde na taà kuveka Dadaamiya, watse taà keɗiyaakeɗa arge muksaaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ɗemme keni waà, egdze a emmerwa ba miyenne. Aɗaba gergere ba mama ka waà, eddeŋere palle. ŋane, egdze a edderwa, gevge muksaaruwa ge iya. ");
INSERT INTO mfi_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Am sarte na sisese Dadaamiya am huɗe aà haà aà edderwa, ya ndaana ba iya, a ba iya yaà elvan ge ŋane: Maè mi de tsekwaa am eksara keni, naba ndaterndaha ge emnde a ekse ŋanna geni ka egdze a emmerwa. ");
INSERT INTO mfi_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Daaci Abimailaik a eptsanaa muksaara ge Ibrahiima, a ndakanaare antara duksaha kwakya: kyawaha antara eslaha antara ba emndimagwaha a vanteva, navaha antara kwatenaha. ");
INSERT INTO mfi_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","A ba Abimailaik aà elvan ge Ibrahiima: Kwaye lardaaruwa baɗemme aà katafkaaŋa, naba njinja am tate na ni aà katana ervauŋɗaaŋa. ");
INSERT INTO mfi_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","A ba ŋane aà elvan ge Saratu: Naàwa yaà vante gursa debu ge egdze a emmeŋa, una ŋanna lafayaaŋa, naàza heɗakaa nasherire aà katafke aà sleriyahaaŋa baɗemme. Estuwa, kaà an bara aà katafke aà emnde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Daaci Ibrahiima a magaa maduwa, maàzlaara Dadaamiya keni a naba ekhyaternaahe ge tara Abimailaik antara muksaara ira kwatenahaatare baɗemme, ta fantau ge yaà egdzere zlaɓe adaliye. ");
INSERT INTO mfi_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Aɗaba ndza Dadaamiya a heɗete yaà egdzere ba ɗekiɗeki am huɗe aà haà aà Abimailaik baɗemme aɗaba elva aà Saratu mukse aà Ibrahiima. ");
INSERT INTO mfi_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yaakadada viyanaaka Saratu, a gananve naàzena ndza a ndanndaha, a ba nane watse aà magannaamaga na. ");
INSERT INTO mfi_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saratu a naba shaa huɗe, a yane egdzere zhele ge Ibrahiima. Daaci Ibrahiima a shansha egdzere zhele aà ba am emgyegwire. Saratu a ye egdzere aà ba am sarte na a tsanaa Dadaamiya na. ");
INSERT INTO mfi_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ibrahiima a fete zhera aà egdzaara na a yannaa Saratu na, Isiyaaku. ");
INSERT INTO mfi_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Isiyaaku magaamaga hare tise am erva maa, Ibrahiima a ɓeleme am sheɗekwe ba seke una a bannaa Dadaamiya na. ");
INSERT INTO mfi_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ate iva ŋanna Ibrahiima a shaa egdzaara Isiyaaku na waà, iva aà Ibrahiima dermeke. ");
INSERT INTO mfi_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Daaci a ba Saratu: Dzakitedzaka Dadaamiya, emtake ervauŋɗaaruwa jipu. Una ma a cenanaa ware labaraaruwa keni sey aà dzaka, aà higiyuhige. ");
INSERT INTO mfi_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","A farhe zlaɓe adaliye, a ba ŋane: Ndza a tamanaa ware aà katafke aà Ibrahiima ni watse Saratu a yiya egdzere! Amaà kwaye ŋane yaneya egdzere, ŋane keni emgyegwe tsa. ");
INSERT INTO mfi_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Daaci aŋkwa aà wala egdzere, ta ŋezlaa ate uɓa. Vaci ŋezla Isiyaaku ate uɓa, Ibrahiima a magaa muŋri, a ɗetaa emnde. ");
INSERT INTO mfi_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Vacite umele maa, egdze na Ibrahiima a shanaa an Hajara egdze aà emnde a Misera na, taà aŋkwa aà gaà gusa antara Isiyaaku aà Saratu, naterna Saratu. ");
INSERT INTO mfi_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","A ba Saratu aà elvan ge Ibrahiima: ŋgyanseŋgye kwatena na, a zlarzlala antara egdzaara baɗemme. Aɗaba wayanka, ƴanaaƴa ervauŋɗaaruwa egdze aà kwatena taà de zaà warata kerɗe antara Isiyaakuwaaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Elva ŋanna ƴanaaƴa ervauŋɗe aà Ibrahiima jipu, aɗaba Isemayiila keni ba egdze a huɗaara. ");
INSERT INTO mfi_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Amaà a ba Dadaamiya aà elvan ge Ibrahiima: A guleka higaaŋa aɗaba kwatena antara egdze na ka shanaa an ŋane. Naba magananmaga ge Saratu naàzena a ndavakuwa ŋane baɗemme. Aɗaba aà ba am jirire keni wulfahaaŋa na watse ta kwakya aà ba iya, ya ndakndaha na keni, bademme watse taà segashe aà ba am Isiyaaku. ");
INSERT INTO mfi_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Amaà egdze a kwatena na keni maa, yaà de huyanaahuya ŋane keni, yaà de ganvege larde ƴaikke aɗaba ŋane keni ba egdze a huɗaaŋa. ");
INSERT INTO mfi_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Daaci ba makurallaara an eŋlya werre, Ibrahiima a eksetaa naàza za antara kanyakanya yawe am huɗaara, a far ge Hajara ate nahyapaihyapaara, a eksevaa egdzaara ŋanna, a vante, daaci a naba ŋgyanse, ezlzlalaaŋa aà ba ŋane aà elvan ge ŋane. Daaci ba zlala ge Hajara aà dem kaambaara, kwaya a de deriya am kaamba aà Birsaba. ");
INSERT INTO mfi_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","De zlarzle yawe am kanyakanya maa, a naba eblyanve egdzere am ekte aà nafa. ");
INSERT INTO mfi_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ŋane an iraara a de njehe ƴiiƴire an egdze na deydey aà zlala aà gurme palle, am ndaŋŋiraara. Aɗaba a bantsa ŋane: Wayanka zhara egdzaaruwa aà emtsa ate icaaruwa. Daaci a de njehe, a kurese ba ndaŋŋire aà tate na ni egdzaara aàtekwa na, a fantau ge kyuwa. ");
INSERT INTO mfi_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Daada kyuwa aà egdze na aàdeza Dadaamiya, a naba tsekwehe ge malika a Dadaamiya aà sawa am samaya, a ba ŋane: A jaara uwe ge ekka Hajara? A waŋka lyawa ɗekiɗeki, aɗaba Dadaamiya cenancena hula aà egdzere am tate na aàtekwa egdze ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Naba tsetse, de eksanteksa egdzaaŋa, ŋanaaŋa ba shagera, aɗaba watse yaà ganve larde yaikke an egdze ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Dadaamiya a naba weranante ice maa, Hajara a zhara ba suwa, hatstse a naba tsetehe, a de nante kanyakanyaara an yawe na, una a fanu ge egdzere. ");
INSERT INTO mfi_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Dadaamiya icaaka antara Isemayiila ɗekiɗeki haa a waltehe. Waltewala maa, a naba nja am huɗe aà kaamba aà Paran, gevge zhel matsame, aà dzega naàza kaambaha an gume. Emmeŋaara a de eksanante gyaale am Misera. ");
INSERT INTO mfi_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Am sarte ŋanna maa, a sawhe ge sleksu Abimailaik antara Pikaul male aà sawjiyahaara aàseza Ibrahiima, a ba ŋane aà elvan ge ŋane: Ekka waà, aŋkwa Dadaamiya antara ka am naàzena kaà magana ka baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Kina waà, sey kaà ziyuze waɗa an Dadaamiya geni kaà de magiteka keladire ɗekiɗeki, ma ge iya, ma ge egdzarahaaruwa, ma ge eggyahaaruwa keni. Ba seke una ni iya ya magakaa shagerire, huɗaaruwa palle ate ka na waà, ka keni maginaamaga ba estuwa. Kaà magiya shagerire ge iya antara ge larde na naàwa njakinja am huɗaara na. ");
INSERT INTO mfi_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Yaà ezza, aà ba Ibrahiima. ");
INSERT INTO mfi_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Daaci Ibrahiima a naba sananse parakke ge Abimailaik shagerkire na ni ta maganaa emndaara, ta naba lyevaa suwa aà ba an ndzeɗa beresse na. ");
INSERT INTO mfi_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","A ŋwanante ge Abimailaik, a ba ŋane: Diyanka una ɗekiɗeki ma a maganaa ware keni. Ekka keni mbeɗakiyuka, iya keni cenananka ɗekiɗeki maà vateneka. ");
INSERT INTO mfi_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Am iga aà una ŋanna, Ibrahiima a naba haltaa nawaha antara kyawaha ira eslaha, a naba vante ge Abimailaik, bukerɗaatare gevge namaàna dagavaatare mazlaara. ");
INSERT INTO mfi_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ibrahiima a naba dzerese kyawaha na deydey deydey na vuye, a tsateraahe an iraatare. ");
INSERT INTO mfi_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","A ba Abimailaik aà elvan ge Ibrahiima: Labara ka dzerese kyawaha na vuye, ka tsateraahe an iraatare na? ");
INSERT INTO mfi_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","A ŋwanante ge Ibrahiima, a ba ŋane aà elvan ge ŋane: Una waà, lyevaalya am ervaaruwa ba ge iya, ge seydire a katafkaaŋa, geni suwa na waà, ba jirire ya yanaa ba iya. ");
INSERT INTO mfi_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Aɗaba waɗa aà emnde buwa ŋanna ta zanaa am tate ŋanna, ta ɗaàhaà tate ŋanna an Birsaba kina. ");
INSERT INTO mfi_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Kwaye ŋane, ta ŋguɗanaa estuwa tara Ibrahiima antara Abimailaik namaàna am dagavaatare. Am iga aà una ŋanna maa, a tsetehe ge Abimailaik antara Pikaul male aà sawjiyahaara, ta eptsa aà dem eksaatare aà ba am Filisti ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Daaci Ibrahiima a dzeɓe nafa aà ɗaale am Birsaba. A magaa maduwa, a fantau ge ɗaàha Dadaamiya Saksage an Yaakadada am maduwaara. ");
INSERT INTO mfi_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ibrahiima haraahare jipu am larde aà Filisti. ");
INSERT INTO mfi_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Am iga aà unaha ŋanna maa, Dadaamiya a naba gyaa hala aà Abrahiima. A ɗante: Ibrahiima! A ŋutehe: Naàwa ya Yaakadada, a ba Ibrahiima. ");
INSERT INTO mfi_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","A ba Dadaamiya aà elvan ge ŋane: Eksanteksa egdzaaŋa Isiyaaku, egdzaaŋa na palle ba ŋane wayakwaya jipu na, ezlzlala an ŋane aà dem larde aà Mauriya ate ire aà wa na watse yaà de ŋgyekwakanvaa ya, de iciyantica sadakaara am tate ŋanna, sadake na ni taà epshana an kara na. ");
INSERT INTO mfi_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ba makurallaara, a tsetehe ge Ibrahiima an eŋlya werre, a tataa hazla na watse aà de epsha sadake an ŋane na, a puwete serde ate ezzeŋwaara, daaci daredde antara egdzaara Isiyaaku, aà dem tate na ni a ŋgyekwannaa Dadaamiya na. A ɗetaa emnde buwa am walaɗiyahaara, ta duwa antara ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Am hare ge keƴire waà, Ibrahiima a kante ice, a nanna tate ŋanna amaà zlaɓe ƴiiƴiye jipu. ");
INSERT INTO mfi_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","A ba ŋane aà elvan ge walaɗiyahaara buwa na: Kure waà, njawinja aàhuna antara ezzeŋwa. Amaà ŋere antara egdzere waà, kwaye ŋaà de kezlan ugje ge Dadaamiya ate ire aà wa na kwaye ŋane na. Maà zlaŋeruzle ŋaà se berakurbera. ");
INSERT INTO mfi_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Daaci Ibrahiima a eksante hazla na taà epsha naàza sadake an ŋane na, a farhe ge egdzaara Isiyaaku na. ŋane an iraara maa, a eksante kara antara washe, daredde taà aŋkwa aà zlala ba itare ta buwa mazlaara. ");
INSERT INTO mfi_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Daaci Isiyaaku a ndavanu elva ge eddeŋare taà aàtire a zlala ŋanna, a ba ŋane: Eddaye! A ŋwanante ge Ibrahiima, a ba ŋane: Naba enndaha elvaaŋa egdzaaruwa, yaà aŋkwa aà eccena. A ba Isiyaaku aà elvan ge ŋane: Naàwa maà an hazlaha antara kaàraà baɗemme, aàme egdze a zhil kyawe na mi de maga sadake an ŋane na? ");
INSERT INTO mfi_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","A ŋwanante ge Ibrahiima, a ba ŋane: Watse aà de jansaare ba Dadaamiya ŋanna an iraara ge egdze a kyawe ŋanna egdzaaruwa. Daaci taà aŋkwa aà zlalaatare aà ba aàtirpalle. ");
INSERT INTO mfi_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Daraada am tate ŋanna a ŋgyekwannaa Dadaamiya ŋanna maa, Ibrahiima a de ndere naàzena taà icanaà sadake aàtekwa ge Dadaamiya na, a kazlante hazla, daaci a naba takwasaa egdzaara Isiyaaku na, daaci a ɓelete ate hazla na ate tate aà fana sadake ge Dadaamiya na. ");
INSERT INTO mfi_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Daaci a velese erva, a eksante washe, aà kaàtaà ica egdzaara waà, ");
INSERT INTO mfi_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ibrahiima, Ibrahiima, aŋkwa aà ɗahanaà malika aà Dadaamiya aà sawa am samaya. A ŋutehe ge Ibrahima: Na'am. ");
INSERT INTO mfi_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","A ba malika: Fanfeka ervaaŋa ge egdzere ɗekiɗeki, maganaànka ba uwe keni. Kina waà, dyaneddiye mazlaara ganakini kaà aŋkwa aà kuva Dadaamiya, aɗaba yaikiveka egdzaaŋa palle ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ibrahiima a kante ice waà, aà zhara ba zhel kyawe am igaara am gwezla aà dake tabeɗamme, dermahaara an ŋaŋa am gwezla ŋanna. A naba duhe ge Ibrahiima suuwe, a de lyevaa zhel kyawe na, a maganaa sadake ge Dadaamitya an ŋane am sleɗe aà egdzaara. ");
INSERT INTO mfi_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ibrahiima a fete zhera aà tate ŋanna: Dadaamiya aŋkwa aà nanna. Sem vatena keni, emnde taà ɗaha tate ŋanna a ba an: Dadaamiya aŋkwa aà nanna ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Malika aà Yaakadada a ɗante Ibrahiima ge buwire aà sawa am samaya, ");
INSERT INTO mfi_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","a ba ŋane aà elvan ge ŋane: Naàwa elva aà Yaakadada. A ba ŋane: Ba seke una ni ekka eksakarekse magiya una, yaikiveka egdzaaŋa palle a ba ŋane na waà, yaà zaku ba waɗaara an zheraaruwa ba ge iya: ");
INSERT INTO mfi_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ba jirire yaà aŋkwa aà gakar barkaaruwa, yaà yaàkteya, egdzaraaŋa taà de gev ba seke terlyakwaha ate samaya, ba seke shili na am guwa na. Ma vatara keni sey taà de gaànaà ba emndaaŋa ndzeɗa arge kelaadahaatare. ");
INSERT INTO mfi_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Baɗemme a nalgaha am duniya taà de shaà barka ŋanna yaà de gaterar ge emndaaŋa na, aɗaba ka na ebzaŋka elvaaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Daaci a eptsehe ge Ibrahiima aà seza dawalahaara na, ta naba daatare aà dem Biirsabe. Aɗaba Ibrahiima aà nja am Biirsaba ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Am iga aà labare ŋanna baɗemme na maa, ta se mbeɗanu shawya umele ge Ibrahiima, ta baàntsa: Milka, mukse aà egdze a emmeŋa Nakaur a yayane egdzar zaala. ");
INSERT INTO mfi_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Naàwa zherahaatare: Uus, ŋane maàkaajiyaara, taà an Bus sleɗabaara, antara Kamuyail ŋane waà, eddaŋaara ge Aram, ");
INSERT INTO mfi_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","sleɗaba Bus maa Kaisaid antara Hazau antara Pilda antara Yidlaf ira Baitu'iila. ");
INSERT INTO mfi_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Baitu'iila ŋane a ye Raibaika. Kwaye ŋanne egdzara aè Milka tise ŋanna, egdzar zaala baɗemme, a yayannaa ge Nakaur egdze a emmeŋaara ge Ibrahiima. ");
INSERT INTO mfi_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Aŋkwa mukse aà Nakaur umele a gaàn ge burwire, zheraara Raiwma, ŋane keni a yaye egdzara. Naàwa zharahaatare: Taibak, taà antara Gaham, antara Tahas ira Maaka. ");
INSERT INTO mfi_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saratu a magaa iva dermeke an kul buwa juvuye lauktu aà emtsa. ");
INSERT INTO mfi_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","A emtsaa am haha aà Kanaana, am ekse aà Kiriya Arba, ba ŋane una taà ɗaha an Haiburun na. Ibrahiima a naba jemaa emnde, a kyuse Saratu. ");
INSERT INTO mfi_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Am keɗa muksaara ŋanna maa, Ibrahiima a naba ƴaa emtsa na am bere, a tsetehe, a duhe aà deza Haitiyaha, a ba ŋane aà elvan ge itare: ");
INSERT INTO mfi_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Naàwa iya, ya sawa an sawa, ya wayve am dagavaakure. Vatena na waà, shisha mandzawe, yaà kata egdze a sleɗe aàza kure taslawaakure, geni yaà de heɗa muksaaruwa am sleɗe ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ta ŋwanante ge Haitiyaha, a ba itare taà elvan ge Ibrahiima: ");
INSERT INTO mfi_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Estuweka aàmbarkaaŋa. Ekka ka ura ŋgaa am dagavaaŋere a gakaara Dadaamiya barka. Naba edduwa, de zharanaazhara irekhyahaaŋere, eksesekse ba una ɓaaka argina ɗekiɗeki na, kaà heɗa muksaaŋa am huɗaara. AÀ jerka ura am dagavaaŋere aà de yaikve irekhyaara ɗeàkiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Daaci a tsetehe ge Ibrahiima, a tsaahe aà katafke aà Haitiyaha, emnde a haha ŋanna, a gaa iraara aà katafkaatare, ");
INSERT INTO mfi_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","a ba ŋane aà elvan ge itare: Maàki ba jirire lyavaalya ervauŋɗaakure ganakini yaà heɗa muksaaruwa aàhuna waà, taslawaakure, ndavawisendave aàza Aifruna egdze aà Jauhar, ");
INSERT INTO mfi_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","maàki aà ɓashiɓasha waà, hwalakwa aà Makpaila na ate we aà fahaara na, aɗaba tate ŋanna naàzaara. A viteva aà ba ate gane na ni aà zlayaàn ge tate ŋanna, yaà shekwana aà katafkaakure baɗemme, geni iya keni yaà shansha tate aà irekhyaaruwa halal am dagavaakure. ");
INSERT INTO mfi_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Mbate, Aifruna ŋanna keni aà ba nja am dagave aà emndaatare Haitiyaha, taà aà faɗa ate we aà walkame na. A ba Aifruna aà elvan ge Ibrahiima aà ba an kaa kwara aà katafke aà zlamakelaawa: ");
INSERT INTO mfi_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Estuweka aàmbarkaaŋa, ɓaaka elva a vela am huɗaara. AÀ katafke aà emndaaruwa baɗemme, ma fe ŋanna, ma hwalakwa ŋanna keni vanakteva ba dey ge heɗa muksaaŋa am huɗaara. Nada eccena ka naàzena yaà aŋkwa aà ndaka ya na. ");
INSERT INTO mfi_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ibrahiima a gaa iraara zlaɓe adaliye aà katafke aà emnde a haha ŋanna baɗemme, ");
INSERT INTO mfi_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","a ba ŋane aà elvan ge Aifruna aà katafkaatare baɗemme: Taslaaŋa, ƴanaaka elvaaruwa na: Gane aà fahaaŋa waà, yaà ebbiya baɗemme, naba lyevalya nalmanaaŋa am ervaaruwa, lauktu yaà de heɗa muksaaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Amaà a ba Aifruna aà elvan ge Ibrahiima: ");
INSERT INTO mfi_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Labara kwa aàmbarkaaŋa, ka ƴanaa ge uwe ka elvaaruwa na? Naàwa gane aà sleɗe ŋanna gursa dermeke ufaɗa, amaà ƴaikke ba dagavaamiya ka emtu arge nalmane? Naba ezlzlala de ehheɗa muksaaŋa seke! ");
INSERT INTO mfi_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Daaci Ibrahiima a ekserhe aà ba an higa gane aà fahe ŋanna a ndaasa Aifruna aà ba an waara aà katafke aà Haitiyaha baɗemme, lipela dermeke ufaɗe aà ba ŋane na. Ibrahiima keni a naba kezlanaa gursa dermeke ufaɗe ŋanna tuwesse am erva. Una ŋanna shuŋguwaatare na taà tsakala an ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Mazlaara, fantau aà ba am sarte ŋanna, fahe aà Aifruna am Makpaila, aà dem geɗiyaara ge Mamre, damda am rezege aà Ibrahiima aà katafke aà Haitiyaha baɗemme am kendekiya ƴaikke ate we aà walkame; fe ŋanna antara hwalakwa na, antara nafaha na am fe ŋanna ira nafaha na ate nakwaha aà tate ŋanna baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Zlaruzle am una ŋanna baɗemme, lauktu Ibrahiima a de heɗa muksaara Saratu. A heɗanaa am hwalakwa, am fe am Makpaila, am geɗi aà Mamre am tate na ta ɗahana an Haiburun na, am haha aà Kanaana. ");
INSERT INTO mfi_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Kwaye ŋane, a gev estuwa fe ŋanna antara hwalakwa na am huɗaara na, am rezege aà Ibrahiima. A shekwanaa am erva a Haitiyaha, a ganve tate aà heɗa emndaara baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibrahiima ndza gevge emgyegwe a zhele kurcumme, Dadaamiya garga barka am duksa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ŋane ndza an navaha antara walaɗiyaha kwakya. Vacite umele, a ba ŋane aè elva ge eddawnaaŋana ŋane huɗe aà haara baɗemme na: Sawa femfa ervaaŋa am dagave aà serahaaruwa, aà bina, ");
INSERT INTO mfi_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","4","aɗaba yaà kata kaà ziyuze waɗa. Ganeka gyaale ge egdzaaruwa Isiyaaku am dagave aà emnde aà Kanaana na naàwa yaà am dagavaatare na ɗekiɗeki. Sey kaà zlala aà ba aà dem lardaaruwa, kaà de gan gyaale ge egdzaaruwa Isiyaaku am dagave aà varahaaruwa. Watse kaà emmaàga he? Ziyuze waɗa an zhera aà Yaakadada, Dadaamiya na a nderanaa ŋane samaya antara haha na. ");
INSERT INTO mfi_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","A ŋwanante ge slesleraara, a ba ŋane aà elvan ge ŋane: AÀmbane aà de eksarka gyaale ge ɗabiɗaba aà sem larde na maa? Maàki de gevge estuwa yaà naba eptsanaptsa emtu Isiyaakyuwaaŋa aà dem larde na ndza ka sawa am huɗaara na? ");
INSERT INTO mfi_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","A ba Ibrahiima aà elvan ge ŋane : Effa hyema, maŋka una. Daànka egdzaaruwa aàdehuwa. ");
INSERT INTO mfi_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yaakadada Dadaamiya na a nderanaa ŋane samaya na, a sisaa ba ŋane am huɗe aà haà aà edderwa, a sisaa ba ŋane am lardaaruwa na ta yiyaa am huɗaara na. A biyantsa ba ŋane, aà de vaterte larde na baɗemme ge eggyahaaruwa, a ziyu waɗa geni ɓaaka gafkaara. Daaci aà de ɓelana ba ŋane malikaara aà katafkaaŋa ge dem lardaaruwa, kaà de sana gyaale ge egdzaaruwa aà sawa aàhuwa. ");
INSERT INTO mfi_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Maàki a kwalvaa ba gyaale waà, waɗa na ka ziwa ka ge iya na keni aà ɗabaŋka mazlaara. Amaà duksa palle waà, daànka egdzaaruwa aà dehuwa ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Daaci, ane a ba walaɗi na, a naba fanem erva am dagave aà serahaara, a zanu ge zaànwaara geni aà emmaga a ba ate una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Am iga aà una ŋanna maa, walaɗi aà Ibrahiima a naba dzerese kelaawaara am ezlegwamaha aà zanwaara, antara kazlaŋa umele an daàraàdza jipu, a naba maga shula aà dem ekse aà Nakaur am Misaupautamiya. ");
INSERT INTO mfi_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Shanaasha ekse ŋanna maa, de shansha suwa ate iga a ekse ŋanna. Daaci a naba kazlateraa ugje ge ezlegwamahaara, reppe njarinja ate we aà suwa ŋanna. Sarte ŋanna keni gevge icavaciya, sarte a dem yawe ge ŋwasha. ");
INSERT INTO mfi_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","A magaa maduwa, a ba ŋane: Yaakadada, Dadaamiya aà zaànwaaruwa Ibrahiima, taslaaŋa giyanvege naàzena ni ya sawa aɗaba ŋane vatena na. Magannaamaga ŋgurna ge zanwaaruwa Ibrahiima. ");
INSERT INTO mfi_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Naàwa yaà tse ate we aà suwa, gyaalaha na taà am ekse na taà de sawa, taà se kaà yawe am suwa na. ");
INSERT INTO mfi_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Watse yaà ndavanundave ge gyaale palle am itare: Ginaaga hwamaaŋaà yaà shushe yawe, maà baànba gyaale ŋanna naàwa shushe eddaye, yaà kateruke ge ezlegwamahaaŋa keni maà taà esha waà, ba ŋane gyaale na ni ka eksanansaa ka ge slesleraaŋa Isiyaaku. Yaà de dise ate una ŋanna ŋgurna na ka maganaàn ge zanwaaruwa Ibrahiima. ");
INSERT INTO mfi_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","AÀ ba am tsaka elvaara aà katafke aà Dadaamiya keni zlaɓe zlawka waà, aà zhara ba sesse Raibaika an hwama ate nahyapaihyaipaara. Raibaika ŋanna maa, zhera aè eddeŋaara Betu'iila egdze a Milka, mukse aà Naàkaur, egdze a emmeŋaara ge Ibrahiima. ");
INSERT INTO mfi_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Raibaika gyaale zariya an tsaka ire, zlaɓe diyaaka zhele dekiɗeki. Kacawkacawkacawe sesse, a de tsekweme am suwa, a kem yawe am hwamaara, kerteŋ a ferhe aŋkwa aà zlala. ");
INSERT INTO mfi_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Daaci zhagade ge male aà walaɗiyaha aà Ibrahiima na, a de ica ba wafkaara, tsaatse, a ba ŋane aà elvan ge ŋane: Tasle a ŋa ganaaga seke hwama yaà shushe yawaaŋa na cekwaaŋguɗi? ");
INSERT INTO mfi_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","A ŋwanante ge Raibaika, a ba ŋane: Labara? Naàwa shushe eddaye! Kerteŋ a gannaahe, zhel na a shu yawe na a ƴanaa ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Hyanhya ge zhel na, a ba Raibaika aà elvan ge ŋane: Yaà paƴateraapaƴa ge ezlegwamahaaŋa keni maà taà esha, taà ƴaànaà ba itare yawe. ");
INSERT INTO mfi_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Kerteŋ a puwese yawe na ndza am hwama na aà dem kyaale, ba watsewatse a de kem umele, a se puwese adaliye, a payateru yawe na ge ezlegwamaha aà zhel na baɗemme, ta ƴanaa ba itare yawe na. ");
INSERT INTO mfi_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Am sarte na Raibaika aŋkwa aà maga slera na waà, walaɗi aà Ibrahiima na a ɗuhe tseriiye aà ndaka elva, aà zharanaà aà ba an ice. Amaà aà maga ba najipuwaara. A ba ŋane am ervauŋɗaara: Una giyanvege Yaakadada naàzena ya se katanaa ya na emtu estara? ");
INSERT INTO mfi_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Hyaterhya yawe ge ezlegwamahaara baɗemme waà, zhel na a naba vante jaɗe aà dindar ge Raibaika. Jaɗe ŋanna ganaara kwakya jipu. A naba fante ate ektare, a vante zlaɓe adaliye naàdaŋwaha buwa, una ŋanna keni ta janaa aà ba an dindar ŋanna zlaɓe adaliye, a naba puwante ate erva. ");
INSERT INTO mfi_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","A ba ŋane aà elvan ge ŋane: Taslaaŋa ndindaha, ka egdze aà ware am ekse na? A naba jerje emtu sleɗe am mbaakure geni yaà de tsekwa am mbaakure antara emnde na taà aŋkwa puwisepuwe na baɗemme? ");
INSERT INTO mfi_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","A ŋute ge gyaale, a ba ŋane: Ya egdze aà Betu'iila, ya eggyetare ge tara Naàkaur antara muksaara Milka. ");
INSERT INTO mfi_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","A farhe zlaɓe adaliye, a ba ŋane: Aŋkwa sleɗe ge tsekwa wayvaha am mbaaŋere. Dete ba kandiske antara masa ge dabbahaakure keni aŋkwa kwakya am mbaaŋere, tate aà hare a wayvaha keni aŋkwa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Daaci zhel na a naba kezle ugje am aha, a kezlan ugje ge Yaakadada, a slafan waara, ");
INSERT INTO mfi_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","a ba ŋane: Yaà aŋkwa aà slafaka waaruwa Yaakadada, Dadaamiya aà zaànwaaruwa Ibrahiima. Yaà slafakaà we, aɗaba marakiyaànmara parakke ŋgurna, antara jirire na kaà aŋkwa aà maganaàn ge zaànwaaruwa. Naàzaaruwa ge iya waà, diyandiya mazlaara geni a siya ba Yaakadada an iraara aà sem huɗe aà haà aà egdze a emmeŋaara ge zanwaaruwa suuwe. ");
INSERT INTO mfi_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Raibaika a naba kante sera aà daà, a de ɓalananse labare ge emmeŋaara. ");
INSERT INTO mfi_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Aŋkwa egdze a emmeŋaara zhele ge Raibaika, zheraara Laban; ŋane keni nanna jaɗe na am ektare aà egdze a emmeŋaara na, antara naàdaŋwaha na ate ervaara na baɗemme. Cenancena keni aà etsaka Raibaika naàzena a bannaa zhel ŋanna baɗemme. Daaci a naba sessehe ge Laban am mba, zhagadaara aà dete we aà suwa na, a de bere zhel na antara ezlegwamahaara ate we aà suwa. ");
INSERT INTO mfi_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","A ba Laban aà elvan ge ŋane: Labara ka tsaa am kaamba! Sawa aà se mbaaŋere eddaye! Ekka, ka eddawna Yaakadada a gakar barka an tsaka ire na, tsatsannaatsatse ba iya an iraaruwa tate aà tsekwa wayvaha am mbaaŋere, sleɗe ge ezlegwamaha keni aŋkwa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Daaci ta duhe, ta de tsekwaa gwatamaha ate iga aà ezlegwamaha, ta vaterte kandiske antara masa ge ezlegwamaha na, ta sateraa yawe aà bara sera ge ŋane antara emnde na ta daa aà puwansepuwe na baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ta sateraa naàza za, ta faterhe aà katafkaatare waà, a ba walaɗi aà Ibrahiima: Yaà zeka duksa maà ndanakurseka labare na ni a sisa na. A ba Laban: Naba endaha elvaaŋa edda! ");
INSERT INTO mfi_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","A ba ŋane aà elvan ge itare: Iya waà, ya walaɗi a Ibrahiima. ");
INSERT INTO mfi_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Dadaamiya Saksage a gar barka an tsaka ire ge zanwaaruwa Ibrahiima, a ganve ur ŋgaa. A vante nawaha antara kyawaha, eslaha, lipela antara dindar, antara navaha antara kwatenaha, ezlegwamaha antara ezzeŋwaha, baɗemme a duksa. ");
INSERT INTO mfi_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Muksaara Saratu a naba yane egdzere aà ba am emgyigwire. Zanwaaruwa a ƴanaa rezegaara baɗemme ge egdze ŋanna kina. ");
INSERT INTO mfi_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","A ba zanwaaruwa aà elvan ge iya: Yaà kata kaà ziyuze waɗa. Kaà ganka mukse ge egdzaaruwa am dagave aà emnde a Kanaana na ŋaà am dagavaatare na ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Sey kaà zlala aà ba aà dem lardaaruwa, aà dem dagave aà egdzar mamahaaruwa, antara emnde a jebaaruwa, kaà de gan gyaale ge egdzaaruwa aàhuwa. Watse kaà emmaga he ate una ŋanna? Sey kaà ziyuze waɗa, aà bina. ");
INSERT INTO mfi_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","A ba iya yaà elvan ge zanwaaruwa: AÀmbane watse aà ɗabika gyaale aà sem larde na maa? ");
INSERT INTO mfi_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","A ba zanwaaruwa aà elvan ge iya: Dadaamiya, Yaakadada na yaà aŋkwa aà kezlan ugje kelaazare na waà, aà de ɓelana ba ŋane malikaara aà katafkaaŋa, aà de gakanvege ŋane shulaaŋa ate una ni kaà de hayaànhaya na. Daaci kaà sannaasa gyaale ge egdzaaruwa aà sawa am jebaaruwa, aà sawa am dagave aà egdzar mamahaaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Maàki ba dakaada ka aà dem jebaaruwa waà, waɗa na yaà fakar ezzaara na keni aà ɗabaŋka mazlaara. Una ma de shakanaànka gyaale ge egdzaaruwa, varakteka keni tsekwaatsekwa ate ka, aà ɗabaŋka waɗa na kaà zaànaà ka na mazlaara. ");
INSERT INTO mfi_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Kwaye ŋane daliila a shulaaruwa vatena, ya se tsekwaa ate we aà suwa. Tsekwantsekwa ate we aà suwa waà, ya magaa maduwa, a ba iya: Yaakadada, Dadaamiya aà zanwaaruwa Ibrahiima, maà lyavaalya ervauŋɗaaŋa waà, taslaaŋa hyiyanfehye shulaaruwa vatena na. ");
INSERT INTO mfi_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","A ba iya zlaɓe adaliye am maduwaaruwa: Naàwa iya, yaà tse ate we aà suwa, maà sesse gyaale am huɗe aà ekse, a se ka yawe am suwa na, ya banaa: Taslaaŋa viteva yawe yaà shushe cekwaaŋguɗi am hwamaaŋa ni, yiveka, ");
INSERT INTO mfi_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","maà banba gyaale ŋanna: naàwa shushe eddaye, yaà paƴaterapaƴa ge ezlegwamahaaŋa keni maà taà esha, maà baànba gyaale ŋanna estuwa waà, daaci ba gyaale na ni ka eksesaa ka geni aà gev mukse aà egdze aà zanwaaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Iya keni zlaɓe yaà aàtira tsaka elva ŋanna am ervauŋɗaaruwa, yaà zhara ba sesse Raibaika an hwama ate nahyapaihyapaara, a de tsekweme am suwa, a kem yawe, a ferhe. A ba iya yaà elvan ge ŋane: Taslaaŋa viteva seke yawaaŋa na yaà kuke? ");
INSERT INTO mfi_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Kerteŋ eksaksa yawe ate nahyapaihyapaara: naàwa eddaye, yaà kateruke ge ezlegwamahaaŋa keni aà bina. Iya ya shu yawe na, a payateraa ge ezlegwamaha, itare keni ta ƴanaa ba itare yawe. ");
INSERT INTO mfi_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","A ba iya yaà elvan ge ŋane: Ka egdze aà ware? A ba ŋane: Ya egdze a Batu'iila, ya eggyetare ge tara Nakaur antara muksaara Milka. Daaci ya naba fanem jaɗe am ektare, ya puwante nadaŋwaha ate erva. ");
INSERT INTO mfi_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Daaci ya kezle ugje am aha, ya kezlane ugje ge Yaakadada, ya slafan waaruwa ge Yaakadada, Dadaamiya aà zanwaaruwa Ibrahiima, aɗaba a kwarisaa ba ŋane barama a shulaaruwa, zlalavezlale ɓaaka argina, geni yaà ganega egdze aà egdze a emmeŋaara ge zanwaaruwa ge egdzaara. ");
INSERT INTO mfi_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Kina waà, elva a juwaa aà ba aàze kure. Maàki eksaarekse iraakure maganaa shaigerire antara jirere ge zanwaaruwa, kwa ndahihe. Maàki aà gevka keni ba kwa ndahihe parakke, daaci yaà zlalaaruwa aè dem tate umele. ");
INSERT INTO mfi_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ta ŋwanante ge tara Laban antara Batu'iila, a ba itare taà elvan ge ŋane: Duksa waà, ba naàzena ni a ganvaa Dadaamiya na. ɓaaka elva na ni ŋaà ndaaka ŋere, ŋa tsa bakanka shagera elvaaŋa, ŋa tsa bakanka keni shagerka elvaaŋa. ");
INSERT INTO mfi_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Kwaye Raibaika aà katafkaaŋa, eksanteksa daànda, a de gevge mukse aà egdze aà zanwaaŋa ba seke una a ndaaka Yaakadada na. Dawaada aà ba an hairire. ");
INSERT INTO mfi_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ba a cenaa una ŋanna male aà walaɗiyaha aà Ibrahiima, a kezlan ugje ge Yaakadada am aha. ");
INSERT INTO mfi_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Am iga aà una ŋanna, a sanse kazlaŋa aà gyaale zarizariya baɗemme, umelahaara ta janaa an lipela, umelahaara ta janaa an dindar, antara naŋgyuwaha, a vante ge Raibaika. A sanse kazlaŋa umele zlaɓe adaliye an daradza jipu maa, una ŋanna a vaterte ge tara Laban egdze a emmeŋaara ge gyaale antara emmeŋaara ge gyaale. ");
INSERT INTO mfi_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Zlaruzle am shawyaatare baɗemme, lauktu male aà walaɗiyaha aà Ibrahiima antara emnde na ta daa aà puwansepuwe na ta zu duksa, ta sharhe, lauktu ta de zlava ta hare. Maàkurallaara an eŋlya werre waà, ta tsetehe, a ba male aà walaɗiyaha na aà elvan ge emnde a haà: Vawiteva kwa baraàma, yaà daà aà deza zanwaaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","A ba tara egdze a emmeŋaara ge gyaale antara emmeŋaara taà elvan ge ŋane: Amaà gyaale waà, aè shekwashekwa emtsaaɗe deydey hare kelaawa palle lauktu watse kwa daà. ");
INSERT INTO mfi_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","A ba ŋane aà elvan ge itare: ŋaŋawika seke taslawaakure. Naàwa shulaaruwa a tsatsanaa ba Yaakadada an iraara. Kure waà, vawiteva kure ba baraàma, yaà eptsa aà deza zanwaaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","A ba itare taà elvan ge ŋane: Una waà, sey ŋaà ɗaha ba gyaale an iraara, aà se ŋuta ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Daaci ta ɗante gyaale, a ba itare taà elvan ge ŋane: Kaà eɗɗaba he zhel na aà kata aà daàkaàda ba vatena? A ŋute: Yaà eɗɗaba, aà bina. ");
INSERT INTO mfi_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Daaci ta sawhe ge egdzar mamahaŋaara ge Raibaika, antara emnde haatare baɗemme, ta magateraa aàjaàmimaà shifa ge tara Raibaika antara sleŋana egdzere antara male aà walaɗiyaha aà Ibrahiima ira emnde na ta saa aà puwansepuwe na baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Egdzar mamahaŋaara ge Raibaika ta gan barka ge egdze a emmetare, a ba itare ma waraatare keni: A vakteva Dadaamiya egdze a huɗe egdze a emmerwa. Egdzaraaŋa a garevge ma debu waànyarwaànyara keni. Kelaadaha a ŋa taà de gevge ba ŋwashaha aà katafke aà egdzaraaŋa. ");
INSERT INTO mfi_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Daaci a tsetehe ge Raibaika antara kwatenahaara, ta ɗaɗalte ate iga ezlegwamaha, a ɗabete male aà walaɗiyaha aà Ibrahiima. Male aà walaɗiyaha aà Ibrahiima a gan estuwa Raibaika, a zlalehe an ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Am sarte ŋanna maa, Isiyaaku zlaɓe ba uŋule a saara, ndza a dete we aà suwa. Zhera aà suwa ŋanna Lahay Ruwa. Amaana: Dadaamiya Saksage aŋkwa aà nina. Aɗaba ŋane an iraara a nja am haha ŋanna am puti. ");
INSERT INTO mfi_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Vacite umele an icaviciya maa, Isiyaaku a de tataya tate aà tsekaɗɗire am fe, a kante ice waà, aà zhara ba ezlegwamaha taà aŋkwa aà sawa. ");
INSERT INTO mfi_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Raibaika keni kanteka ice, nanna Isiyaaku na, a naba tsekwehe ate ezlegwamaara. ");
INSERT INTO mfi_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","A ndavanu ge male aà walaɗiyaha aà Ibrahiima, a ba ŋane aà elvan ge ŋane: Ware ŋane zhel na kwaye ŋane am fe, aà se jaà ire an miya na? A ŋwanante ge zhel na, a ba ŋane aà elvan ge ŋane: Una ŋanna degiya zanwaaruwa. Ba watsewatse Raibaika a haltaa lafayaara, a puwar ge iraara. ");
INSERT INTO mfi_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Male na a se ndahanhe ge Isiyaaku naàzena a maganaa ŋane am shulaara baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Daaci Isiyaaku a daa Raibaika ba suuwe aà dem bere aà emmeŋaara Saratu. Raibaika gevge mukse aà Isiyaaku, wayaawaya jipu an muksaara. A ekhya estuwa ervauŋɗe aà Isiyaaku, aɗaba ndza a keɗaa emmeŋaara. ");
INSERT INTO mfi_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibrahiima a naba ge mukse umele zheraara Kaitura. ");
INSERT INTO mfi_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Mukse ŋanna a yayane egdzar zaala ge Ibrahiima. A yese Simran, antara Yauksan antara Maidan antara Madiyan antara Yisbak ira Suhak. ");
INSERT INTO mfi_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yauksan, ŋane keni a ye tara Saiba antara Daidan. Daidan keni a yese emnde a Asuri antara emnde Laitusi ira emnde a Laiwmi. ");
INSERT INTO mfi_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Naàwa emnde na keni egdzara aà Maidiyan: Tara Aifa antara Aifair antara Hanauk antara Abida ira Aildaba. Baɗemme a emnde na ba egdzara aà Kaitura. ");
INSERT INTO mfi_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Warata waà, Ibrahiima a vante warata aà nalmanaara baɗemme ba ge Isiyaaku palle. ");
INSERT INTO mfi_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Amaà egdzara aà ŋwashaha umele na waà, zlaɓe ŋane an shifaara, a tegateraa nalmane aà ba an ervaara, a ŋgyekwateraa sleɗaatare aà dem geɗi, ƴiiƴiye jipu an Isiyaaku, una ŋanna keni larde umele. ");
INSERT INTO mfi_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ibrahiima a magaa iva dermeke an kul vuye jilyeɓe, ");
INSERT INTO mfi_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","lauktu a zluwaa hairiraara, gevge emgyegwe an tsaka ire, ndza a jesanje am iraara nja an shifa. Amaà a emtsaa am ŋgahire, zlazlala aà deza eggyahaŋaara. ");
INSERT INTO mfi_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ta heɗanaa ba egdzaraara, tara lsiyaaku antaa Isemayiila am hwalakwa aà Makpaila, am fahe aà Aifruna egdze a Jauhar ura Haiti, fe ŋanna aà dem geɗiyaara ge Mamre. ");
INSERT INTO mfi_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Amaà fe ŋanna waà, Ibrahiima shekwefshekwe am erva aà Haitiyaha. Daaci ta heɗateraa aà ba am huɗe aà fe ŋanna tara Ibrahiima antara muksaara Saratu. ");
INSERT INTO mfi_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Am iga aà keɗa Ibrahiima maa, Dadaamiya a gar barka jipu ge egdzaara Isiyaaku. Isiyaaku a njehe, haara ba herzhe an suwa ŋanna taà ɗahana an Dadaamiya aŋkwa aà nina na. ");
INSERT INTO mfi_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Naàwa kergema aà egdzara aà Isemayiila, egdze aà Ibrahiima na a yanaa Hajara egdze aà emnde a Misra, ndza kwatena aà Saratu. ");
INSERT INTO mfi_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Naàwa zheraha aà egdzara aà Isemayiila an ɗabava an ɗabava: Naibayaut, ŋane makaaji aà Isemayiila, sleɗabaara Kaidar, lauktu Adbair, lauktu tara Maipsaam ");
INSERT INTO mfi_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","antara Misma antara Duma antara Masa ");
INSERT INTO mfi_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","antara Hadat antara Taima antara Yaituru antara Maafis ira Kaiduma. ");
INSERT INTO mfi_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Kwaye ŋane egdzara aà Isemayiila kelaawa jubuwa antara zherahaatare baɗemme. Ma waraatare keni huyaahuya gevge jeba. Ba zherahaatare una a gev zheraha aà eksahaatare antara zheraha aà sleɗaha na taà de tsekwa itare am huɗaara am kezlakezlahaatare. ");
INSERT INTO mfi_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isemayiila magaamaga iva dermeke an kul keƴe ju vuye lauktu aà emtsa, a daahe aà deza eggyahaŋaara am faya. ");
INSERT INTO mfi_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Egdzara aà Isemayiila ta nja am dagave aà tara Hawila antara Sura, aà dem geɗi aà haha aà Misera, ate baraàma a dem Sura. Am emnde aà Ibrahiima baɗemme, ta de nja ba itare ƴiiƴiye an emnde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Naàwa labare aà Isiyaaku egdze aà Ibrahiima: ");
INSERT INTO mfi_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isiyaaku magaamaga yawe kul ufaɗe kalkale lauktu a ge Raibaika egdze a emmeŋaara mukse ge Laban egdze aà Batu'iila, ura Paddan Aram. ");
INSERT INTO mfi_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isiyaaku a ŋaàla Yaakadada, aɗaba muksaara Raibaika yaaka egdzere, gevge dzire. Dadaamiya Yaakadada lyavaalya ŋaàlaara, muksaara a naba shaa huɗe. ");
INSERT INTO mfi_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Huɗe aà Raibaika ŋanna waà, wulhaha. Egdzara taà aŋkwa aà dagala am huɗe, a naba fu hula Raibaika, a ba ŋane: Maà ba estuwa, ya shan ge uwe ŋane huɗe ŋanna ba ɗekiɗeki? Daaci a de ndava aàza Yaakadada. ");
INSERT INTO mfi_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","A ba Yaakadada aà elvan ge ŋane: Aŋkwa zlamaha buwa, jeba buwa am huɗaaŋa. Jebaha buwa ŋanna taà aŋkwa aà tegaava aà sawa am huɗaaŋa. Am jebaha buwa ŋanna waà, aŋkwa palle aà de jauje ge palle an ndzeɗa. Am egdzara ŋanna waà, male aà de gev walaɗi aà kudere. ");
INSERT INTO mfi_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","De hyephye sarte aà Raibaika ge yaà, a de ye waà, a yese wulhaha buwa. ");
INSERT INTO mfi_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Am egdzaraara ŋanna, una a sawa zuŋŋwe na verannde, an ugje ate vuwa ba seke naàza aà egdze aà sla. Ta fete zheraara Isuwa. ");
INSERT INTO mfi_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","A de sawa sleɗabaara waà, a ŋaa naàɗegaɗega aà Isuwa na am ervaara. ŋane keni ta fete zheraara Yakubu. Isiyaaku magaamaga yawe kul uŋkwahe kalkale am sarte na ta ye egdzara ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Daaci walartewaàlaà egdzara buwa na. Isuwa a gev matsame, aà eblyeka ervaara aà dem haha ɗekiɗeki, ŋane gevge slekaamba. Amaà Yakubu waà, ŋane sletsekaɗɗe, aà nja aà ba am mba duksaara. ");
INSERT INTO mfi_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isiyaaku waà, ndza aà waya ba Isuwa kwakyaara, aɗaba aà sanaà hyuwa ba kelaazare. Amaà Raibaika waà, ŋane a hayaa ba Yakubu. ");
INSERT INTO mfi_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Vacite umele maa, Yakubu keni gyanvegye naàza za kyaŋŋe, Isuwa keni saasa am kaamba, kuɗukkuɗe an tsaka ire. ");
INSERT INTO mfi_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","A ba Isuwa aà elvan ge Yakubu: Taslaaŋa ƴiyanƴa naàza za na an gya kyaŋŋe na, yaà ndaɓundaɓe ya emtsaaɗe, aɗaba ɓaaka naàzu yaà maganaà ya mazlaara. Ta fante aɗaba una ŋanna zhera Aidaum ge Isuwa, amaana: Kyaŋŋe. ");
INSERT INTO mfi_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","A ŋwanante ge Yakubu, a ba ŋane: Veliyuvele daàraàdza aà makaajiyiraaŋa emtsaaɗe lauktu kaà ezza. ");
INSERT INTO mfi_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","A ba Isuwa: Yaà emtsa ni makaajiyire, watse aà magiya uwe ŋane makaajiyire ŋanna? ");
INSERT INTO mfi_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","A ba Yakubu aà elvan ge ŋane: Maà eksakarekse waà, sey kaà ziyuze waɗa emtsaaɗe. Isuwa a naba zanu waɗa ge Yakubu, geni ƴanaànƴa makaajiyire. Isuwa a velu estuwa daàraàdza a makaajiyiraara. ");
INSERT INTO mfi_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Daaci Yakubu a naba vanteva kwa naàza za na ge Isuwa, depaiŋ antara jeba a ƴire umele aŋkwa ɗaàlaara aàgire. A zuhe, a sharhe, a tsetehe duksaara ba ezlzlala. A epsawaa estuwa Isuwa daradza aà makaajiyiraara. ");
INSERT INTO mfi_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Daaci samsa waya ƴaikke a sem larde, amaà waà, waya na ndza am zamane aà Ibrahiima na ka. Daaci a naba duhe ge Isiyaaku aà deza sleksu Abimailaik slekse aà Failaistiyaha am Gairar, ");
INSERT INTO mfi_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","de marapsemare Yaakadada aà katafkaara, a ba ŋane aà elvan ge ŋane: Duka aà dem Misra ɗekiɗeki, naba njinja am larde na yaà de bakana iya. ");
INSERT INTO mfi_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Gejeka emtsaaɗe seraaŋa am larde na, iya yaà aŋkwa antara ka, yaà de gakar barkaaruwa. Aɗaba baɗemme a kwaraha na, yaà de vakte ba ge ekka antara wulfahaaŋa am igaaŋa. Yaà de ganve estuwa waɗaaruwa na ya zanu ge eddeŋa Ibrahiima. ");
INSERT INTO mfi_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Yaà de huyateraahuya egdzaraaŋa, taà de gev ba seke terlyakwaha ate samaya, kwaraha na baɗemme watse yaà de vaterte ba ge wulfahaaŋa. Baɗemme a jebaha na ate haha ta de sha barka aɗaba wulfahaaŋa. ");
INSERT INTO mfi_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Aɗaba Ibrahiima a cenaa elvaaruwa, a eɗɗaba naàzena ya bannaa ya, a tsaa aà ba ate naàzena ya tsanaa ya, ɗabaaɗaba jipu naàzena ya puwetaa ya antara shairiyahaaruwa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","A njanaa ba una ŋanna Isiyaaku am Gairar. ");
INSERT INTO mfi_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Am sarte na emnde a ekse taà aŋkwa aà ndavanu elva ate muksaara Raibaika, egdze a emmerwa aà bina. A wana lyawa ge ba muksaara, aɗaba a kuva emnde a ekse ŋanna jipu geni a jareka arge muksaara, aɗaba muksaara Raibaika zariya jipu, ɓaaka arge ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Am haraare Isiyaaku am ekse ŋanna, vacite umele, naterna sleksu Abimailaik slekse aà Failaistiyaha aà kya we aà biye aà bere, taà aŋkwa aà gwagwesa tara Isiyaaku antara muksaara Raibaika. ");
INSERT INTO mfi_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimailaik a naba ɗante Isiyaaku, a ba ŋane aà elvan ge ŋane: Mbate mukse na muksaaŋa! Ka ndana estara kena egdze a emmeŋa aà ba ka na? A ŋwanante ge Isiyaaku a ba ŋane aà elvan ge ŋane: A wiyaa ba lyawa geni a jarika adaba ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","A ba Abimailaik: AÀzara kena una ka magaŋerta ka na? A ƴaa ba cekwaaŋguɗi ma andze ura umele aà ganvege muksaara am emndaaruwa, daaci ekka keni sakaŋeranka emtu haypa? ");
INSERT INTO mfi_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Daaci sleksu Abimailaik a ndaase elvaara palle, a ba ŋane aà elvan ge emndaara: Ma ware una a ndanse elva ƴaiƴaihe ge zhel na, ma a fete erva ate muksaara keni, eddaara aà njeka an shifa ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ate iva ŋanna, Isiyaaku a herɗa aà ba am haha ŋanna, amaà jaaja duksa ɓaaka zlaktaara, aɗaba Yaakadada garga barka. ");
INSERT INTO mfi_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Nalmane Isiyaaku aŋkwa aà far ba saga, a gev sleberba ɓaaka arge ŋane ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ndza an waldaha aà sla kwakya, antara kyawaha antara nawaha, kwakya jipu. Emnde a maganaa slera keni ndza ɓaaka zlaktaatare. Daaci Failaistiyaha ta naba shelha ate ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Aɗaba shelha na maa, Failaistiyaha ta naba dashem suwaha na ndza a yayanaa eddeŋaara Ibrahiima na baɗemme an haha. Aɗaba Ibrahiima keni ndza kwakya walaɗiyahaara, ta yayanaa ba itare suwaha ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Daaci a ba Abimailaik aà elvan ge Isiyaaku: Gakevge kaà an hakuma jipu, jakuje ge ndzeɗaaŋere, ezlzlala am lardaaŋere. ");
INSERT INTO mfi_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","A naba kezla Isiyaaku, a de icese slalaara am kaamba a Gairar, ɗambake zlaɓe adaliye, a njaara aàhuwa. ");
INSERT INTO mfi_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isiyaaku a naba yayese zlaɓe adaliye suwaha na ta yayanaa am zamane aà eddeŋaara Ibrahiima, ta daishemhe ge Failaistiyaha am igaara na. ŋane a naba yayese, a fafete zheraha na ni ndza Ibrahiima a ɗaha suwaha ŋanna an ŋane na. ");
INSERT INTO mfi_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Walaɗiyaha aà Isiyaaku keni ta yaye suwaha umele aŋwaslire, ta shaa yawaha na aà emtseka ɗekiɗeki na. ");
INSERT INTO mfi_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Suniyaha aà emnde a Gairar ta naba daàgala an suniyaha aà Isiyaaku arge suwa. Aɗaba ta baàntsa itare: Suwa na nazaaŋere. Isiyaaku a naba fante zhera aà Aisaik ge suwa ŋanna. Amaana: Daàgala. Aɗaba ta kaàtaà dagala an ŋane arge suwa ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Walaɗiyaha aà Isiyaaku ta ye suwa umele, arge una ŋanna keni ta naba tsa elva zlaɓe adaliye Failaistiyaha. Isiyaaku a fete zhera aà suwa ŋanna Sitna. Amaana: Kelaadire. ");
INSERT INTO mfi_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","A tsetehe am tate ŋanna, a de ye suwa umele ge keƴire; arge una ŋanna waà, tsateka dagala. Isiyaaku a fete zhera aà suwa ŋanna Raihaubaut. Amaana: Hwihwiyire. Aɗaba a bantsa ŋane: Yaakadada sagamiyanvesage sleɗe geni mi hwiya am larde na. ");
INSERT INTO mfi_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Am iga aà una ŋanna, Isiyaaku a naba kezla zlaɓe adaliye am tate ŋanna, kwaye a de nja am Birsaba. ");
INSERT INTO mfi_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","AÀhuwa ŋanna, Yaakadada a de maranaa iraara aà ba am hare ŋanna, a ba ŋane aà elvan ge ŋane: Ba iya una ya Dadaamiya aà eddeŋa Ibrahiima. Gazleka ɗekiɗeki, aɗaba iya yaà aŋkwa antara ka, yaà de gakar barkaaruwa, yaà de yaàtertiya egdzaraaŋa aɗaba barka aà eddeŋa. ");
INSERT INTO mfi_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Daaci Isiyaaku a naba ndere naàzena taà fana sadake aàtekwa ge Dadaamiya na am tate ŋanna, a magaa maduwa, a ɗaha Dadaamiya an Yaakadada am maduwaara. A magaa beraara an kacakaca am tate ŋanna, walaɗiyahaara ta naba ye suwa umele. ");
INSERT INTO mfi_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","A sawhe ge Abimailaik aà sawa am Gairar aàsezeŋaara, ta sawa antara uraara Ahusat ira Pikaul, ŋane male aà sawjiyahaara. ");
INSERT INTO mfi_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isiyaaku a naba ndavateruhe, a ba ŋane aà elvan ge itare: Kina mu a sakuraa uwe aàsezerwa, aàbi ŋgyaikuriseŋgye am dagavaakure ƴakuriyaaƴa? ");
INSERT INTO mfi_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ta eptsanaa jawapa, a ba itare taà elvan ge ŋane: ŋaà aŋkwa aà ezhzhara ŋanna waà, aŋkwa Yaakadada antara ka ba parakke. A ba sawariyaaŋere, shagera aà demda waɗa am dagavaamiya. Ekka antara ŋere waà, namaàna dagavaamiya. ");
INSERT INTO mfi_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Kina waà, kaà zaŋeruze waɗa geni kaà de magaŋerteka kelaadire ɗekiɗeki. Aɗaba ŋere keni faŋerka zlaɗa ate ka, ŋa magakaa shaigerire jipu, ka segashe ba lapilayye am dagavaaŋere. Kwaye ŋane gakevge ura aà Yaakadada kaà an barkaara am vuwa. ");
INSERT INTO mfi_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Daaci Isiyaaku a magateraa muŋri ta zuhe, ta sharhe. ");
INSERT INTO mfi_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Makurallaara ta tsetehe an eŋlya werre, ta zu waɗa ŋanna am dagavaatare. Am iga aà una ŋanna Isiyaaku a magateraa aàjamimashifa, ta daahe aà ba an hairire. ");
INSERT INTO mfi_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ba vacite ŋanna, walaɗiyahaara ta sanaa labare aà suwa na taà aŋkwa aà eyya, a ba itare: Shaŋeransha yawe. ");
INSERT INTO mfi_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isiyaaku a fete zhera aà suwa ŋanna Saba. Amaana: Waɗa. Aɗaba una ŋanna zhera aà ekse ŋanna Birsaba sem vatena. Amaana: Sawa aà waɗa. ");
INSERT INTO mfi_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Isuwa maa, ŋane magaamaga yawe kul ufaɗe, a naba ge ŋwasha buwa. A ge tara Yaihudit egdze aà Bairi, antara Basmat egdze aà Ailaun. Bukerɗaatare ta ba egdzara aà Haitiyaha. ");
INSERT INTO mfi_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ŋwashaha aà Isuwa ŋanna ta zlaɗateranve ervauŋɗe jipu ge tara Isiyaaku antara muksaara Raibaika. ");
INSERT INTO mfi_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isiyaaku gevge emmgyegwe kurcumme, ba ice keni a nanka mazle-aara. A ɗante Isuwa makaaji-aara á dezeŋara, a ba ŋane á elvan ge ŋane: Isuwa egdze-aaruwa. A ŋwanante ge Isuwa : Ná ̍am ! ");
INSERT INTO mfi_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","A ba eddeŋara á elvan ge ŋane: Iya na wá, ganevge emmgyegwe jipu, ba sarte a emtsa-aaruwa keni diyanka ya. ");
INSERT INTO mfi_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Daaci kina wá, halantehala náza erva á ŋa, kudeme á ŋa, antara leka á ŋa, ezlzlala á dem kaamba, de eksivaksa dabba a kaamba, ");
INSERT INTO mfi_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","se gyiyanvegye hyuwa a dabba kaamba na ka de eksana ka na njeɓakke ate una ya katana ya, daaci siyansa yá zuze, yá gakar barka lauktu yá emtsa. ");
INSERT INTO mfi_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Cenancena Raibaika am sarte na Isiyaaku aŋkwa á tsakana elva na ge makaaji-aara Isuwa. Daaci zlazlala Isuwa á dem kaamba, a de tsagwaɗa náza kaamba geni a sanansa ge eddeŋara maa, ");
INSERT INTO mfi_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","a ba emmetare Raibaika á elvan ge Yakubu: Náwa ya cenancena a ba eddekure á elvan ge egdze emmeŋa: ");
INSERT INTO mfi_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Ezlzlala á dem kaamba de eksevaksa dabba a kaamba, se gyiyanvegye njeɓakke, yá zuze, ya gakar barka á katafke á Yaakadada lauktu yá emtsa. ");
INSERT INTO mfi_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Daaci kina wá, náwa yá ndaaka elva-aaruwa, eccena ba shagera ƴanaaka elva-aaruwa ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Naba duwa á dem walda, de siyansa egdzara usale-aha shagera shagera buwa wá, yá se gyananvegye ge eddeŋa njeɓakke ate una á katana ŋane, ");
INSERT INTO mfi_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ká se dananda a zuze, á gakar barka lauktu á emtsa. ");
INSERT INTO mfi_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","A ba Yakubu á elvan ge emmeŋara: Egdze a emmerwa an ugje ate vuwa, ɓaaka náza-aaruwa maa, ");
INSERT INTO mfi_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","máki tapiyatapa edderwa, diyisediye mu á de banka ya far uksaŋwirehe? Daaci máki gevge estuwa, á de kita barka edderwa yá de shanka barka na. ");
INSERT INTO mfi_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","A ŋwanante ge emmeŋara, a ba ŋane: A ɗabaŋka ɗekiɗeki, á sem mbiye-aaruwa ge iya egdze-aaruwa. Ƴanaaka ka elva-aaruwa na, naba edduwa de siyansa egdzara usale-aha na. ");
INSERT INTO mfi_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yakubu a naba de sanaa egdzaar usale-aha na ge emmeŋara, ŋane a se tsatsaa náza za njeɓakke ate una á katana eddetare. ");
INSERT INTO mfi_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Am iga a una ŋanna, a demhe am bre á egdze-aara Isuwa, egdzere zuŋŋwire-aara, a dzarese naŋgyuwe-aara na an daradza jipu na, a tsekwanme Yakubu am huɗe-aara, egdze-aara ge buwire. ");
INSERT INTO mfi_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","An gwagwa á nawe-aha ŋanna maa, a mbuwanaa ye á erva-aha an ŋane antara ye, aɗaba ye á Yakubu slerɗakke jipu. ");
INSERT INTO mfi_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Daaci Raibaika a naba fanem náza za na a tsatsanaa ŋane na am erva ge egdze-aara Yakubu, hyuwa an gya njeɓakke antara depain. ");
INSERT INTO mfi_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Mazle-aara a naba duhe ge Yakubu adeza eddeŋara na. Edda, a ba ŋane á elvan ge ŋane. A ŋwanante ge eddeŋara: Na ̍am. Ka ware egdze-aaruwa? ");
INSERT INTO mfi_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","A ba Yakubu á elvan ge ŋane: Ba iya makaaji á ŋa Isuwa, ya sakaa nazena ka ndavanaa ka na. Tsetse-kwa njinja, ká zuze hyuwa na ya sakánse na lauktu ká giyar barka. ");
INSERT INTO mfi_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","A ba Isiyaaku á elvan ge ŋane: Ka shanaa estara kena ba watsewatse na egdze-aaruwa? A ŋwanante a ba ŋane á elvan ge ŋane: A sanaa ba Yaakadada, Dadaamiya á ŋa á se katafke-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","A ba Isiyaaku á elvan ge Yakubu: Sawa emtsaaɗe egdze-aaruwa, yá tapakaatapa an erva-aaruwa ba jirire ka ba Isuwa? Máki ka Isuwa ka keni ya diyeddiye. ");
INSERT INTO mfi_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Daaci a naba gaptehe ge Yakubu á deza eddeŋara Isiyaaku na, á ettapa Isiyaaku an erva-aha-aara, a ba ŋane: Ye-aara máki á ndaha elva wá, Yakubu, amá erva-aha-aara wá, Isuwa. ");
INSERT INTO mfi_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","24","Diyaaka Isiyaaku ɗekiɗeki, aɗaba ɓaaka erva-aha á Yakubu agashe, baɗemme ba ugje ba seke náza á egdze a emmeŋara Isuwa. A ndavanuhe ge Isiyaaku, a ba ŋane: Ba jirire ka ba makaaji-aaruwa Isuwa? A ŋwanante ge Yakubu, a ba ŋane: Ba iya degiya Edda. Mazle-aara a naba fantau ge gar barka. ");
INSERT INTO mfi_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","A ba Isiyaaku á elvan ge ŋane: Siyansa hyuwa á náza kaamba na ka sinaa ka, ka makaaji-aaruwa, yá zuze lauktu yá gakar barka. Yakubu a vante, a zuhe, a de sanaa mbazla, a vante a sharhe. ");
INSERT INTO mfi_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Am iga á una ŋanna, a ba Isiyaaku: Sawa kwa egdze-aaruwa takwaliyatakwala. ");
INSERT INTO mfi_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Takwalle á ba Yakubu a de ŋaŋaa eddeŋara na. Cenancena Isiyaaku emtakkire á se á naŋgyuwe-aara, a garhe barka, a ba ŋane: Emtakkire á se á egdze-aaruwa na wá, ba seke emtakkire á se á fahe na Yaakadada garge barka jipu na. ");
INSERT INTO mfi_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","A vakteva Dadaamiya werhe á sawa am samaya antara dikele á nalmane na ni a vanta haha ge ura na. Tara hiya antara mbazla na emtakke na wá, sey tá ndavana á ba am mba á ŋa. ");
INSERT INTO mfi_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Larde-aha gergere tá de magakaa slera ge ka, jeba-aha gergere ta de ganaaga ire-aatare á katafke á ŋa. Ká de geva ka zanwe á egdzara mama-aha a ŋa, ta de gana ba itare ire-aatare a katafke á ŋa. A de sha barka eddewna ni á de gak barka ge ekka. Amá á de gev an nyainye eddawna ni á de nyainya ka na. ");
INSERT INTO mfi_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isiyaaku keni zlauzle am gar barka ge Yakubu, sesse Yakubu áza eddeŋara, vaŋayye saasa egdze a emmaŋara Isuwa á sa am baka na. ");
INSERT INTO mfi_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ŋane a se gyanve hyuwa á náza a kaamba njeɓakke, a sanánhe kwa ge eddeŋara na. A ba ŋane á elvan ge eddeŋara: Tsetse kwa edda, náwa sanakanmesa hyuwa á náza kaamba na, zuze lauktu ká gar barka ge egdze á ŋa. ");
INSERT INTO mfi_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","A ba eddeŋara á elvan ge ŋane: Ka ware ka? A ba ŋane: Ba iya egdze á ŋa Isuwa, ya makaaji á ŋa. ");
INSERT INTO mfi_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Jaaja emtaŋkire Isiyaaku, diyaaka ba názena á magana ŋane keni ɗekiɗeki. A ba ŋane: Ware ŋane ni a duhe á dem kaamba, a de je náza kaamba, a siyaa hyuwa-aara ya zuhe, náwa a tsantaa ba sera á ŋa na! Barka wá, ganarga, shansha zlauzle. ");
INSERT INTO mfi_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Isuwa ba á cenaa elva na á tsakana eddeŋara na wá, ŋane keni jaaja ervauɗe jipu, a fu hula á ba á dem samaya. A ba ŋane á elvan ge eddeŋara: Tasle á ŋa eddaye-aaruwa, iya keni giyarge barka. ");
INSERT INTO mfi_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","A ba Isiyaaku á elvan ge ŋane: Saasawa egdze a emmeŋa an zlerma, dánda ŋane barka na ma andze náza á ŋa na. ");
INSERT INTO mfi_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","A ba Isuwa: Ŋane na wá, Yakubuwire na sharanansha, egdze á zlerma. Werre keni, a berdu daradza á makaajiyire-aaruwa á ba an ndzeɗa beresse. Nawa vatena zlaɓe adaliye a se berdu barka-aaruwa gevge ser buwa kina. A ba ŋane á elvan ge eddeŋara: Mazlakinaaki barka ŋanna ge iya emtu? ");
INSERT INTO mfi_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","A ba Isiyaaku á elvan ge Isuwa: Baaka elva-aara, gananvege ŋane zanwe a ŋa. Ya fanem egdzara mama-aha-ŋara baɗemme am erva ge ŋane, tá de magana slera. Vananteva ndzeɗa jipu an hiya kwakya, ma mbazla emtakke keni tá de ndavana á ba am mba-aara. Yá magaká uwe kina mazle-aara egdze-aaruwa ");
INSERT INTO mfi_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","A ba Isuwa á elvan ge eddeŋara zlaɓe adaliye: Ndza ká á ba an barka palle ŋanna emtu edda, giyarge seke barka ge iya keni eddaye-aaruwa. Mazle-aara Isuwa a naba fu hula, aŋkwa á kyuwa a ba an ká kwara. ");
INSERT INTO mfi_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","A ŋwanante ge eddeŋare Isiyaaku, a ba ŋane á elvan ge ŋane: Sleɗe á nja ŋa ge ekka wá, watse ká ƴiƴiye an sleɗe na gelgela, werhe na á sawa am samaya na á de duka a dem dalbe á ŋa ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ekka wá, á de vakta shifa ba masalam á ŋa, ká de magana slerga ba ge egdze a emmeŋa. Amá máki yak-ya hala wá, ká naba sansese ire á ŋa am erva-aara. ");
INSERT INTO mfi_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Daaci Isuwa jaaja ervauɗe jipu ate egdze a emmeŋara Yakubu, aɗaba barka na ni a gaara eddetare na. A ba ŋane am ervauŋɗe-aara: A ba á sawa ndza ŋane vaci kyuwa eddemiya, má watse tá dá ba buwa antara Yakubu ŋanna ma. ");
INSERT INTO mfi_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ɓalarananseɓale ge Raibaika názena ni á kata magana Isuwa egdze a zuŋŋwire-aara na ate egdze a emmeŋara. A ɗante Yakubu ádezeŋara, a ba ŋane á elvan ge ŋane: Effa hyema ate ire á ŋa, aɗaba aŋkwa a tsagwaɗaktsagwaɗa egdze a emmeŋa Isuwa, á kata ja shifa á ŋa ba ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kina wá, eccena ka názena yá ndaka ya: Tsetse, ezlzlala á ŋa egdze-aaruwa á dem mba á egdze a emmerwa Laban am Harran. ");
INSERT INTO mfi_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Naba njanaanja ire á ŋa am mba-aara dem sarte na má ekhyakhya ervauŋɗe á egdze a emmeŋa. ");
INSERT INTO mfi_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Sey má viyanáviya ba ɗekiɗeki am ire-aara názena ka maganta ka na, lauktu watse yá ɓelakva we geni sawa a sa. Labara yá puwem egdzara buwa am evege am hare palle? ");
INSERT INTO mfi_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","A ba Raibaika á elvan ge Isiyaaku: Mága á shawle-aha-aaruwa, egdzara á Haiti-aha na wá, jiseje gwaygway am ire ba ɗekiɗeki. Máki Yakubu keni gaaga zlaɓe adaliye ba egdze á Haiti-aha ŋanna seke náza á Isuwa na wá, náza-aaruwa watse ɓaaka daliila a nja an shifa ŋanna mazle-aara. ");
INSERT INTO mfi_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Am iga á una ŋanna maa, Isiyaaku a ɗante Yakubu, a gar barka, a ba ŋane á elvan ge ŋane: Ya nda ba ka: Geka mukse á ŋa am egdzara á emnde a Kanaana na ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ekka wá, tsetse ezlzlala á dem mba á emnde á emmeŋa am Padda-Aram, á dem mba eggyeŋa Baitu ̍iila. De eksanteksa gyaale am dagave á egdzara á Laban, egdze a emmeŋara ge emmeŋa. ");
INSERT INTO mfi_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","A gagga Dadaamiya Slekse barka-aara, a gagvege ura kwakya jeba-aara, a huyakaahuya Dadaamiya, a gagvege eggyetare ge emnde a jeba gergere kwakya. ");
INSERT INTO mfi_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","A vakteva Dadaamiya ge ekka, antara ge egdzara á ŋa am iga á ŋa, barka na ni ndza a vante ge Ibrahiima na, geni haha ŋanna náwa ka wayve am huɗe-aara na wá, á demde am rezege á ŋa. Aɗaba vanteva Dadaamiya ge Ibrahiima zlauzle. ");
INSERT INTO mfi_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","A danse estuwa Isiyaaku Yakubu-aara á dem Padda-Aram, a de nja am mba á Laban egdze á Baitu ̍iila ura Arama. Laban ŋanna keni maa, egdze a emmeŋara ge Raibaika emmetare ge tara Isuwa antara Yakubu ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Cenancena Isuwa ganakini eddetare Isiyaaku a gar barka zlaɓe adaliye ge Yakubu, a ɓelananse erva á dem Padda-Aram, geni á de gá gyaale áhuwa. Am sarte na aŋkwa á gar barka eddetare, a ba ŋane á elvan ge ŋane: Geka mukse am egdzara á emnde a Kanaana na ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Diyaadiya ba ŋane keni geni Yakubu a magateraa ba fesarfire ge tara eddeŋara an emmeŋara, zlazlala á dem Padda-Aram ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Isuwa keni a naba diyeddiye ganakini ƴanaaƴa ervauŋɗe á eddetare geni tá gá ŋwasha-aha-aatare am egdzara á emnde a Kanaana ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","A naba njante ga mukse umele maa, a de ndava egdze a Ismayiila, egdze á Ibrahiima. Zhera á gyaale ŋanna Makalat, egdze a emmeŋara mukse ge Naibauyaut. A naba gehe, a se ɓelar ge ŋwasha-aha-aara am mba. ");
INSERT INTO mfi_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Tsetse Yakubu am Birsaba, a dem Harran. ");
INSERT INTO mfi_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","De garga vaƴiya am tate umele, a naba hare am tate ŋanna. A eksante nakwa a ɓelete ire atekwa, a naba zlava. ");
INSERT INTO mfi_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Darde ba seke shene wá, á zhara ba ŋálá ƴaike, slaɗɗe jipu ire-aara shanaasha samaya, malika-aha á Dadaamiya tá aŋkwa á ɗala, tá tsekwa an ŋála ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","A tsaahe ge Yaakadada átekwa, ate ire-aare, a ba ŋane á elvan ge ŋane: Ba iya una ya Yaakadada, Dadaamiya á eggyeŋa Ibrahiima ya Dadaamiya á Isiyaaku. Yá ndaaka ba iya una: Haha ŋanna kwaye ká zlava átekwa na wá, vanakteva ge ekka, antara ge egdzara á ŋa am iga á ŋa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Egdzara á ŋa tá de gev kwakya jipu ba seke berbere á haha. Sleɗe-aatare keni watse an nakweka. Tsante am geɗi dem yala, tsante am manem dem puti, baɗemme. Jeba-aha á emnde baɗemme ate haha tá de sha barka ázerwa aɗaba ka, antara aɗaba egdzara á ŋa. ");
INSERT INTO mfi_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Eccena ba shagera: Yá aŋkwa ba iya an ire-aaruwa antara ka, yá aŋkwa á tsufaktsufa ma ká deme keni. Sey yá sakasa zlaɓe adaliye á sem haha na, yá ƴakaaka ɗekiɗeki sey yá ganvege názena ya ndaka ya na. ");
INSERT INTO mfi_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Tsetse Yakubu am hare, a ba ŋane: Ɓaaka shaige-aara, aŋkwa Saksage am tate na, diyanseka ba iya. ");
INSERT INTO mfi_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Gazlaagazla wá, a ba ŋane: Kay! Tate na wá, ɓaaka shage átekwa ɗekiɗeki aŋkwa há á Dadaamiya áhuna. Walkame á samaya-aha áhuna degey! ");
INSERT INTO mfi_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Aŋkwa á wera ekse wá, a tsetehe ge Yakubu an eŋlya werre, a eksetaa nákwa na a fante ge ire-aara na, a dzeɓehe ndeɗɗe una ŋanna nákwa á yiha Dadaamiya, a puwar waye ate ire-aara, a ganve nákwa cuɗeɗɗe. ");
INSERT INTO mfi_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","A fete zhera á tate ŋanna Baytila. Amá werre wá, zhera á ekse ŋanna ndza Luus. ");
INSERT INTO mfi_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yakubu a tsakanse názu am ervauŋɗe-aara ge Dadaamiya, a ba ŋane: Máki ká aŋkwa ka Dadaamiya antara ya, tsufakitetsufa am shula-aaruwa, máki shanánsha názu yá ezza antara názu yá eshsha yá atsekwa, ");
INSERT INTO mfi_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","máki danaada lapiya á dem mba á edderwa, daaci ká de gev Dadaamiya-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Nákwa ŋanna náwa ya tsanaa iya ndeɗɗe ge yiha Dadaamiya na wá, á gevge bere á ŋa ka Dadaamiya. Yá de vakte luser am názena ká de vita ka baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Daaci Yakubu a fanu ge baráma-aara zlaɓe adaliye, aŋkwa a zlala á dem larde á emnde a geɗi. ");
INSERT INTO mfi_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Vacite umele maa, a naa suwa am kaamba. Walde-aha á kyawe-aha antara náwe-aha gergere keƴe tá aŋkwa zlava ate we á suwa ŋanna. Aɗaba tate á fateru yawe ge dabba-aha-aatare una ŋanna. Suwa ŋanna keni an heɗa we-aara an nákwa ƴaike. ");
INSERT INTO mfi_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Má jarammeje walde-aha baɗeme maa, lauktu tá berhanvuwe nákwa na ge we á suwa, tá fateru yawe ge dabba-aha-aatare baɗeme. Má zlaruzle ta eptsaa nákwa na zlaɓe adaliya á sete we á suwa. ");
INSERT INTO mfi_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakubu a naba ndavateruhe, a ba ŋane á elvan ge itare: Kwa emnde a ekse-ara kure egdzara mama-aha-aaruwa? Ta ŋwanante, a ba itare: Ŋa emnde a ekse á Harran. ");
INSERT INTO mfi_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","A ba ŋane á elvan ge itare: Diyakurdiya Laban á Nakaur emtu? A ba itare: Diyaŋerdiya. ");
INSERT INTO mfi_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","A ba ŋane á elvan ge itare: Awárá ŋane? A ba itare: Ba layye. Bayra kwaye Rahiilu-aara keni aŋkwa á sawa an kyawe-aha, egdzere mukse na kwaye ŋane na. ");
INSERT INTO mfi_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","A ba Yakubu á elvan ge itare: Kwaye kapteke vaciya ba ŋgaa, sarte na sarte á jaha dabba-aha á dem tate palle ka maa, fawaterufe yawe, dawaterda á de piya. ");
INSERT INTO mfi_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ta eptsanaa jawapa, a ba itare: A gevka sey má jarammeje dabba-aha baɗeme lauktu ŋá wera yawe, ŋá faterufe. ");
INSERT INTO mfi_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ŋane keni zlaɓe á ndaha ba elva antara suni-aha na, Rahiilu keni samsa antara kyawe-aha á eddeŋara, aɗaba ŋane slepiya. ");
INSERT INTO mfi_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakubu a zharaa Rahiilu egdze á daslareŋara Laban, a duhe á dete we á suwa na, a berhanvuwe nákwa ge we á suwa, a fateru yawe ge kyawe-aha á Laban egdze a emmeŋara ge emmeŋara. ");
INSERT INTO mfi_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Am iga á ŋanna maa, á de gan use ge Rahiilu. Takwalle a de takwalaa egdze na wá, aŋkwa á kyuwa á ba an yawe á kyuwa. ");
INSERT INTO mfi_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Daaci a palanaa varire-aatare antara eddeŋara ge Rahiilu na geni ŋane egdze á Raibaika. Zhagade á dá ge Rahiilu, a danaa labare ge eddeŋara. ");
INSERT INTO mfi_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","De cenancena labare á Yakubu egdze á egdze a emmeŋara mukse, zhagade ge ŋane keni a de yainuye. De jarje ire, tákwalle a de ŋaŋaa Yakubu na, a danaahe á dem mba-aara. Daaci ŋane keni a de ɓalananse názena ni a shaa ŋane na baɗemme ge daslarŋara. ");
INSERT INTO mfi_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","A ba Laban á elvan ge ŋane: Ɓaaka shaige am una ɗekiɗeki ka wulfe á ŋere ba parákke. Yakubu a magaa tere kalkale am mba Laban. ");
INSERT INTO mfi_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Daaci a ba Laban á elvan ge Yakubu: Aɗaba ka egdze a kwate-aaruwa ni ká magiyá slera á dey wá, una á gevka. Naba ndindaha názena ká katana ka ge mbera á ŋa ire na. ");
INSERT INTO mfi_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban maa, tá aŋkwa egdzara-aara buwa, egdzara ŋwasha. Una male na zhera-aara Lee ̍a, sleɗaba-aara, zhera-aara Rahiilu. ");
INSERT INTO mfi_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lee ̍a, ŋane á nánka ice shagera. Amá Rahiilu wá, garlaka, zariya zlaɓe adaliye. ");
INSERT INTO mfi_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Daaci Yakubu a wayete ŋane, a ba ŋane á elvan ge Laban: Yá magaka slera yawe vuye aɗaba Rahiilu *egdze á ŋa ge buwire na. ");
INSERT INTO mfi_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ane, a ba Laban, naba njaminja yá de vakteva. Ya keni ya hayaa ba una ŋanna arge una yá vante ge ura jeba umele. ");
INSERT INTO mfi_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yawe vuye kalkale Yakubu aŋkwa á maganá slera ge Laban aɗaba Rahiilu, amá ŋane a zharán ba seke hare cekwaaŋguɗi aɗaba wayetewa jipu an Rahiilu. ");
INSERT INTO mfi_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Am iga á una ŋanna maa, a ba Yakubu á elvan ge Laban: Yá kata mukse-aaruwa mazle-aara, aɗaba daada ate sarte na mi enndaha na ge magaka slera. Yá kata ŋana erva ge mukse-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Daaci Laban a naba magaa muŋri á nika, a jemaa emnde a ekse baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Magaamaga maŋgaripu ba ŋgaa wá, Laban a naba eksante Lee ̍a, a de jatermehe an Yakubu. Ŋane a naba ŋanaa erva, ta hare kerɗe. ");
INSERT INTO mfi_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban a eksetaa Jilpa kwatena-aara ge ŋane, a vante ge Lee ̍a, a gev kwate-aara. ");
INSERT INTO mfi_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Werawera ekse wá, Yakubu á zhara ba Lee ̍a ta hare kerɗe. A ba ŋane á elvan ge Laban: Labara ka magiya zlerma na? Abi ya magakaa slera aɗaba Rahiilu? Labara ka magite jeba una? ");
INSERT INTO mfi_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","A ŋwanante ge Laban, a ba ŋane á elvan ge Yakubu: Shagerka am ekse á ŋere danse kudere zuŋŋwe á dem mba á zhele arge male. ");
INSERT INTO mfi_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Naba zlanaazle ka hare make na antara ŋane lauktu yá vakte sleɗaba-aara na keni. Amá wá, ká magiyá slera yawe vuye zlaɓe adaliye aɗaba ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ane, a ba Yakubu, ta magaa make palle antara Lee ̍a, Laban a naba vante Rahiilu zlaɓe adaliye. ");
INSERT INTO mfi_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban a eksetaa kwatena-aara Bilha, a vante ge egdze-aara Rahiilu a gev kwatena-aara. ");
INSERT INTO mfi_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakubu a ŋanaa erva ge Rahiilu keni, a ganve mukse-aara. Welawa ba Rahiilu ázeŋara arge Lee ̍a. A naba demhe zlaɓe adaliye am slera á Laban, yawe vuye aŋkwa á emmága. ");
INSERT INTO mfi_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Am nanna Yaakadada ganakini Lee ̍a gevge mukse keliya, a naba vante yá ge ŋane, amá Rahiilu wá, a ganve dzire. ");
INSERT INTO mfi_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lee ̍a a shaa huɗe, a ya egdzere zhele, a fete zhera-aara Ruubain. Aɗaba a ba ŋane: Yaakadada nanna palasa-aaruwa, kina wá watse á wayiwaya zhele mazle-aara. ");
INSERT INTO mfi_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","A shaa huɗe umele zlaɓe adaliye, a ya egdzere zhele adaliye. A ba ŋane: Cenáncena Saksage keliyire-aaruwa ba jire. Aɗaba una ŋanna a vite egdzere zhele umele. A fete zhere á egdze ŋanna Simaun. ");
INSERT INTO mfi_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","A shaa huɗe umele zlaɓe adaliye, a ya ba una ŋanna. A ba ŋane: Kina wá, á de deska ba essaɓa keni am dagave á ŋere antara zhele-aaruwa, aɗaba ya yayan dawale-aha keƴe kalkale. Aɗaba una ŋanna a fete zhere á egdze ŋanna Laiwi. ");
INSERT INTO mfi_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","A shaa huɗe umele zlaɓe adaliye, a yese ba egdzere zhele ŋanna. A ba ŋane: Kina wá, sey yá gala Dadaamiya Saksage. Aɗaba una ŋanna, a fete zhera á egdze ŋanna Yahuuda. Mazle-aara a naba ƴaa ya egdzere. ");
INSERT INTO mfi_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Nanna Rahiila geni ŋane yaneka egdzara ge Yakubu, a naba tsante shelha á dete egdze a emmeŋara. A ba ŋane á elvan ge Yakubu: Sey ká viteve egdzara ge iya keni, má ɓaaka una wá, yá njeka an shifa. ");
INSERT INTO mfi_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Tsetse ervauŋɗe á Yakubu á dete Rahiilu, a ba ŋane á elvan ge ŋane : lya ya Dadaamiya na a piyakte yá egdzere na emtu ? ");
INSERT INTO mfi_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","A ba Rahiilu á elvan ge Yakubu : Nawa kwatena-aaruwa Bilha, naba njawinja antara ŋane tara zhele an mukse, a yiya ŋane egdzara ate ugje-aaruwa, iya keni yá shansha egdzara ate ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","A nabe vante kwatena-aara Bilha ge Yakubu, ŋane a naba ganve i mukse, ta hare kerɗe. ");
INSERT INTO mfi_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha a shaa huɗe, a yan egdzere zhele ge Yakubu. ");
INSERT INTO mfi_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","A ba Rahiilu : Yawwa, jirivejire Dadaamiya, cena-cena Dadaamiya ŋala-aaruwa, aɗaba una ŋanna a vite egdzere zhele. Aɗaba una ŋanna a fete zhera á egdze ŋanna Dan. ");
INSERT INTO mfi_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilha kwatena á Rahiilu a shaa huɗe umele, a yan egdzere zhele adaliye ge Yakubu, egdzere ge buwire. ");
INSERT INTO mfi_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","A ba Rahiilu : Kwakya wava na ya maganaa ya á dete egdze a emmerwa á katafke á Dadaamiye, kwaye ŋane ganega ndzeɗa. A fete zhera a egdzere Naftalim. ");
INSERT INTO mfi_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","A ezhzhara Lee'a á shanka huɗe mazle-aara á yeka maa, a eksante kwatena-aara Jilpa, a vante ge Yakubu geni a ganve mukse-aara. ");
INSERT INTO mfi_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Jilpa kwatena a Lee'a, a yan egdzere zhele ge Yakubu. ");
INSERT INTO mfi_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","A ba Lee'a : Kay! Ya slerezege. A fete zhera á egdze ŋanna Gada. ");
INSERT INTO mfi_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Jilpa kwatena á Lee'a, a yan egdzere ge buwire ge Yakubu. ");
INSERT INTO mfi_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","A ba Lee'a : Una wá, barka-aaruwa. Baɗemme a ŋwasha tá de biyanba geni shanansha barka áza Dadaamiya. A fete zhere-aara Asair. ");
INSERT INTO mfi_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Am slakslakire, sarte á ica hiya, Rubain a dem kaamba, a sanaa egdzara á nafa ge emmeŋara Lee'a. A ba Rahiilu á elvan ge Lee'a : Tasle á ŋa, viteva seke egdzara á nafa na a sakanaa egdze á ŋa na ? ");
INSERT INTO mfi_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","A ŋwanante ge Lee'a, a ba ŋane : Hyaaka ba una ka lyevaa zhele-aaruwa na, ká kata lyiya egdzara á nafa á egdze-aaruwa zlaɓe adaliye? Shagera, a ba Rahiilu : Máki estuwa wá, a de hare zhele ázeŋa vatena aɗaba egdzara á nafa à egdze á ŋa. ");
INSERT INTO mfi_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","An icavaciya aŋkwa á sa Yakubu am kaamba wá, a de yenu á ba an ye Lee'a, a ba ŋane á elvan ge ŋane : Vatena wá, ká se hare ázerwa, ya shekweve an egdzara á nafa á egdze-aaruwa. Daaci Yakubu a de hare ázeŋara vacite ŋanna, tara zhele an mukse. ");
INSERT INTO mfi_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Dadaamiya lyavaalya ƴeka á Lee'a, a naba shaa huɗe, a yan egdzere zhele ge ilyebire ge Yakubu. ");
INSERT INTO mfi_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","A ba Lee'a : Pelisepele Dadaamiya, aɗaba ya naba eksante kwatena-aaruwa, ya vante ge zhele-aaruwa, a ganve mukse-aara na. A fete zhera á egdze ŋanna Issaker. ");
INSERT INTO mfi_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lee'a a shaa huɗe umele zlaɓe adaliye, a yan egdzere zhele ge uŋkwahire ge Yakubu. ");
INSERT INTO mfi_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","A ba Lee'a : Dadaamiya a magiyaa shagerire ƴaikke. Kina wá, zhele-aaruwa de nja antara ya aɗaba ya yan egdzara zaala uŋkwahe kalkale na. A fete zhera á egdze ŋanna Jabulaun. ");
INSERT INTO mfi_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Am iga à una ŋanna, a yehe zlaɓe adaliye egdzere palle, une ŋanna wá, egdzere mukse, a fete zhera-aara Dina. ");
INSERT INTO mfi_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Daaci Dadaemiya a yehamme Rahiilu, lyavaalya ƴeka-aara, a naba vante yá. ");
INSERT INTO mfi_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Rahiilu a shaa huɗe, a ya egdzere zhele, a ba ŋane : Yawwa! Lyivarlye Dadaamiya-aaruwa dzaka á emnde na. ");
INSERT INTO mfi_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","A fete zhera á egdze ŋanna Yusufa. A ba ŋane zlaɓe adaliye : Tasle á ga Yaakadada-aaruwa, umele keni viteva ba estuwa. ");
INSERT INTO mfi_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Yaaya Rahiilu, a ya Yusufa wá, a ba Yakubu á elvan ge Laban : Kina wá, ɓeliyaɓela yá eptsa á dem ekse-aaruwa, á dem larde-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Viteva ŋwasha-aha-aaruwa, antara egdzara-aha-aaruwa na ya magaa slera aɗaba itare na, yá dá á dem ekse-aaruwa. Aɗaba ba ka keni diyakdiya slera na ya magakanaa ya baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","A ŋwanante ge Laban, a ba ŋane : Ba estuwa, amá tasle á ŋa zivarze. Aɗaba ya de naha wá, ta biyaa barka na ya shanaa ya áza Dadaamiya na wá, ya shanaa aɗaba ka. ");
INSERT INTO mfi_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Naba tsanaatse ka nazena ni ká kataná ka ge mbera á ŋa na, yá emmága baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","A ba Yakubu a elvan ge ŋane : Diyakdiya slera na ya magakanaa ya baɗemme. Ma nja dabba-aha á ŋa na ya se beƴanaa ya am erva á ŋa, antara dabba-aha á ŋa kina keni diyakdiya baɗemme ma ? ");
INSERT INTO mfi_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Abi yá sawa ya á sem mba á ŋa dabb-aha á ŋa ndza ba cekwaaŋguɗi ? Ba sanemsa ya á sem huɗe á há ŋa, farfe dabba-aha á ŋa jipu Yaakadada garge barka. Kwaye kina ɓaaka zlakte-aara. Watse yá magá vaatara kena naza ire-aaruwa? ");
INSERT INTO mfi_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","A ba Laban: Ekka wá, ndindaha ka ba nazena ká kata yá biyaka yá na ɓaaka lambe á ŋa. Ká kata yá biyaka wányara? A ba Yakubu : Kaà biyika ba uwe keni ɗekɗeki. Amaà aŋkwa naàzu yaà ndakndaha : Maàki eksakarekse una ŋanna waà, yaà duwa zlaɓe aà de piya dabbahaaŋa, yaà fateru hyema ba seke werre. ");
INSERT INTO mfi_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Vatena yaà dedde am dagave aà waldahaaŋa peraatte, ba kelaa kyawe na ni ugjaara viyauviyawe jili gergere seke uɓele antara ugje indale ira kyawe daŋŋwe, baɗemme yaà elle aà segashe. Am nawaha keni ba estuwa, nawe na ni ugjaara ugje uɓela antara ugje indale, baɗemme yaà elle aà segashe, mberaaruwa una ŋanna ge iya. ");
INSERT INTO mfi_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Daaci kaà se zhara jiriraaruwa maàkuralla, ma watse kaà se zhara mberaaruwa. Ba maàki ka se berenaa am naàzahaaruwa ni gafka viyawe, gafka ugje indale, gafka daŋŋwe waà, ma kyawe, ma nawe keni ya ba nayle. ");
INSERT INTO mfi_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","A ba Laban: Una waà, shagera, magamimaàga aà ba ate una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Amaà ba vacite ŋanna, Laban a fantau ge ellaara usalaha antaraà njifa na ni ugjaara an maƴaha ba seke gwambara antara viyauviyawe. Am mama aà nawaha keni ba estuwa, a dzerse viyauviyawe antara una ŋguraslasle seke uɓela antara jili na an usha an dzayye ira kyawe na daŋŋwe gyegweniyye na. A dzerse jiliyaha ŋanna baɗemme maa, a naba puwateremhe am erva ge egdzaraara. ");
INSERT INTO mfi_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Daaci a naba tegaa dagavaatare deydey shula aà vaha keƴe. Yakubu waà, ŋane aŋkwa aà piya ba jugena aà waldaha aà Laban. ");
INSERT INTO mfi_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Daaci duwa aà Yakubu, a naba ɗatsevaa ervaha aà nafa aŋwasla gergere keƴe, nafaha ŋanna keni gergere keƴe. A faya iga ate nafaha na, tate na ni an faya na gevge dzayye telle, an maƴaha nafaha baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Daaci a naba puwem nafaha na am kyaale. Taà aŋkwa a ezhzhara dabbaha maà taà se sha yawe. Aɗaba sarte a ɗala ate ŋwashaha keni ba una ŋanna ge dabbaha. ");
INSERT INTO mfi_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ba taà ɗala ŋwashahaatare dabbaha na aà katafke aà nafaha na waà, ta naba fantau ge ya egdzere jili gergere, umele seke ba gwambara, umele ŋgweraslasle seke uɓela, umele keni mbazlaukmbazlaukkwe. ");
INSERT INTO mfi_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakubu a naba dzerse dabbaha na an maƴaha antara una daŋŋwe na baɗemme am dabbaha aà Laban, a puwateraa an iraara. Yakubu a maganaa estuwa waldaha ge iraara, maslaaka una ŋanna antara naàza aà Laban. ");
INSERT INTO mfi_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","ɓa kelaa maà taà aŋkwa ɗala dabbaha na taà an ŋasla na ate ŋwashaha waà, Yakubu aà puwaterem nafahaara ŋanna am kyaale, daaci taà ezhzhara dabbaha na. ");
INSERT INTO mfi_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ama maà taà aŋkwa ɗala gampaha ate ŋwashaha waà, aà maŋka una ŋanna. A ganve estuwa Yakubu dabbaha na taà an ŋasla na baɗemme taà aàtuge ŋane, amaà gampaha waà, taà aàtuge Laban. ");
INSERT INTO mfi_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","A gevaa estuwa Yakubu sleberba an tsaka ire. Kyawaha antara nawahaara gevge kwakya jipu. An navaha antara kwatenaha kwakya, ezlegwamaha antara ezzeŋwahaara keni ɓaaka zlaktaara. ");
INSERT INTO mfi_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yaw, cenancena Yakubu elva na taà aŋkwa aà tsakana egdzara aà Laban ate ŋane. Aɗaba ta bantsa itare: Yakubu zauze nalmane aà eddeŋere baɗemme, berbiraara na, baɗemme a ganaa aà ba an nalmane aà eddeŋere. ");
INSERT INTO mfi_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakubu aà zhara elva ŋanna waà, Laban aà fanuka hyema seke werre. ");
INSERT INTO mfi_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Daaci a ba Yaakadada aà elvan ge Yakubu: Naba eptseptsa aà dem lardaaŋa, aà dem tate na ni ta yakaa aàtekwa na, iya yaà aŋkwa antara ka. ");
INSERT INTO mfi_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yakubu a naba ɓelaterve we ge ŋwashahaara, tara Rahiilu an Lee’a, geni a sarsawa aà sezeŋaara am kaamba, am taàte na aàtekwa an waldahaara. ");
INSERT INTO mfi_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Saremsa, a ba ŋane aà elvan ge itare: Yaà aŋkwa aà ezhzhara kina na waà, eddekure aà fiyuka hyema seke werre. Amaà duksa palle waà, Dadaamiya na ni aŋkwa aà ɗabana edderwa na aŋkwa antara ya. ");
INSERT INTO mfi_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Abi ba kure keni diyakurdiya slera na ya magannaa ya ge eddekure? Ya maganaa slera an ndzeɗaaruwa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Amaà eddekure a naba magiyaa zlerma an tsaka ire. Ser kelaawa aŋkwa fatsiyaa naàza zlayaaruwa. Amaà Dadaamiya waà, velaaka barama geni aà shisha kelaadire ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ndasendahe ba ŋane, a ba ŋane: Ba kelaa dabba na ŋgweraslasle na aàtu ge ekka, naàza zlayaaŋa una ŋanna, baɗemme aà dabbaha ta fantau ge yaà ŋgweraslasle. Maà banba ŋane ba kelaa dabba na an maƴaha naàzaaŋa, baɗemme aà dabbaha taà yaà egdzere an maƴaha. ");
INSERT INTO mfi_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","A sananse ba Dadaamiya dabbaha am erva ge eddekure, a vite ge iya. ");
INSERT INTO mfi_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Vacite umele ya naba shaa shene, naàwa naàzu ya nanaa ya am shenaaruwa: Am sarte a saa dabbaha, taà aŋkwa jarammeje aàtirpalle waà, usalaha antara zhel kyawaha taà aŋkwa ɗala ŋwashaha waà, baɗemme ba jili gergere. Umelahaara an maƴa, emnde umele keni taà ŋgweraslaslaha, umelahaatare keni taà daŋŋwe ba gyeguniiye. ");
INSERT INTO mfi_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","A naba ɗiɗaha malika aà Dadaamiya am shena ŋanna : Yakubu! Ya ŋutehe : A ba iya na’am. ");
INSERT INTO mfi_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","A ba ŋane : Kanteka icaaŋa, ezhzhara, kaà aŋkwa nanna emtu usalaha antara zhel kyawaha ta aŋkwa ɗala ŋwasha baɗeme jili gergere, umele an maƴaha, umele ŋgweraslasle, umele keni daŋŋwe na? Una ŋanna baɗemme na waà, aɗaba ya nanna naàzu na a magakta Laban. ");
INSERT INTO mfi_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ba iya una ya Dadaamiya ya marakaa iraaruwa am Baytila, tate na ka tsaa naàkwa, ka ganve waye ate iraara, ka tsakse naàzu am ervauŋɗaaŋa aà katafkaaruwa na. Kina waà, tsetse ezlala am larde na, eptseptse aà dem lardaaŋa, aà dem tate na ta yakaa aàtekwa na. ");
INSERT INTO mfi_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Daaci ta ŋwanante ge tara Rahiilu antara Lee`a, a ba itare taà elvan ge ŋane: ŋere waà, ɓaaka dzaaŋere am nalmane aà eddeŋere, ŋa ɓaaka am emnde a za warataara keni. ");
INSERT INTO mfi_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Eddeŋere aà zharaŋer ŋa ba seke wayvaha am huɗe aà haara mazlaara, a valaŋerwa ba ŋane an ervaara, zauze nalmane am ŋere baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Nalmane na ni a sansaa ba Dadaamiya an ervaara am erva aà eddeŋere waà, naàzaaŋere una ŋanna antara egdzaraaŋere. Ekka waà, emmaàga ba naàzena ni a ndaaka Dadaamiya na baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Daaci yalla, a ba Yakubu, aŋkwa aà maga niya a zlala, a puwete egdzaraara antara ŋwashahaara ate iga a ezlegwamaha. ");
INSERT INTO mfi_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","A jemaa waldahaara baɗemme antara kazlaŋaara umele na a ganaa am Paddan Aram ŋanna baɗemme, aŋkwa aà eptsa aà dem larde aà Kanaana, aàdeza eddeŋaara Isiyaaku. ");
INSERT INTO mfi_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Am sarte ŋanna maa, Laban ɓaaka am mba, a de ica ugje ate kyawahaara. Daaci Rahiilu a naba ilu helaha aà eddeŋaara, a zlalehe an ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","A magannaa estuwa Yakubu ɓaakire aà jirire ge Laban, aɗaba mbeɗanuka ɗekiɗeki a naba zlala. ");
INSERT INTO mfi_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","A halese kazlaŋaara baɗemme, a naba zhagade, a de ebzu guwa ƴaikke, daaci ba zlalaara aà dem huɗe aà wa Giliyat. ");
INSERT INTO mfi_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Hare keƴe kalkale lauktu ni aà cenancena Laban ganakini ɓaaka zhagadaazhagade Yakubu. ");
INSERT INTO mfi_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ŋane keni a naba jemaa egdzar mamahaŋaara, daaci ta daa aà ɗaba Yakubu na. Haraatare vuye kalkale lauktu ni de sharnaasha am huɗe aà wa a Gile`at. ");
INSERT INTO mfi_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Amaà an vaƴiya vacite ŋanna waà, Dadaamiya a naba maranaa iraara ge Laban am shene. Laban ŋanna waà, zhel Arama. A ba Dadaamiya aà elvan ge ŋane: Effa hyema ate iraaŋa, ɓelanemka ɗekiɗeki ge Yakubu, ma shagerire, ma shagerkire keni. ");
INSERT INTO mfi_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban a de beƴe Yakubu maganaamaga beraara an kacakaca am huɗe aà wa Giliyat, ŋane keni a magaa naàzaatare antara egdzar mamahaŋaara aà ba ate ire aà wa Gile`at ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Daaci Laban a ndavanuhe ge Yakubu, a ba ŋane aà elvan ge ŋane: Labara ka magiya ɓaakire aà jirire na ? Kaà zhagade an egdzaraaruwa ba seke ka sluwatervaa an ndzeɗaaŋa am wava! ");
INSERT INTO mfi_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Labara kaà zlala an ila ndakika ɗekiɗeki na? Kina ma andze ka ndindaha waà, aàbi ma andze ŋaà puwakse an gaŋka antara gadzavera antara lahe am ekte ge ekka, ma ŋaà puwakse an higa ƴaikke. ");
INSERT INTO mfi_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Kina ba ge magatera ajamimashifa ge egdzaraaruwa antara eggyahaaruwa keni piyakitepiya na waà, shagera emtu? Ekka waà, ɓaaka heŋkalaaŋa. ");
INSERT INTO mfi_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Yaà dzegwaàndzegwa magakura kelaadire. Amaà an vaƴiya ba vatena na a naba mariya iraara Dadaamiya aà eddeŋa, a ba ŋane: Effa hyema ate iraaŋa, maganaànka ba uwe keni ge Yakubu. ");
INSERT INTO mfi_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Duksa palle waà, diyandiya geni ɓaaka iraaŋa am kataykatay na mazlaara, zlalakzlala aà dem mba aà eddeŋa. Ama labara zlaɓe ka ilu helahaaruwa? ");
INSERT INTO mfi_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","A ŋwanante ge Yakubu, a ba ŋane: Iya ya kurken watse kaà halivuwe egdzaraaŋa. Aɗaba una ŋanna jija lyawa jipu. ");
INSERT INTO mfi_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Elva aà helahaaŋa maa, maàki shakaànsha aàza emndaaruwa waà, eddaara a njeka an shifa ɗekiɗeki. Kwaye kazlaŋa, naba eppakya aà katafke aà emnde baɗemme. Yakubu diyaaka geni a iluwa Rahiilu helaha na. ");
INSERT INTO mfi_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban a naba demhe am bere aà Yakubu, a demhe am bere aà Lee`a, a demde am bere aà kwatenaha buwa na, a pakyaa kazlaŋaatare baɗemme, amaà shanka ɗekiɗeki. Am iga aà una ŋanna maa, a demhe am bere aà Rahiilu keni. ");
INSERT INTO mfi_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","A halantaa ba Rahiilu ŋanna tsa helaha na amaà Laban a pakyaa beraara, shanka ɗekiɗeki, aɗaba a puweme am serde aà ezlegwamaara, a naba njetaa aàtekwa. ");
INSERT INTO mfi_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","A ba Rahiilu aà elvan ge eddeŋaara: Taslaaŋa a jaŋka ervauŋɗe eddayaaruwa yaà tsa tseteka aàkatafkaaŋa, aɗaba aŋkwa aà hyiya lyuwa bara ervaaŋere ŋwasha. ɓaaka tatu zharemka Laban ice aà dem huɗaara, amaà shanka helahaara na. ");
INSERT INTO mfi_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jaaja ervauŋɗe an tsaka ire Yakubu, a naba fantau ge dagala an Laban, a ba ŋane aà elvan ge ŋane: Azara haypaaruwa? Ya gaku haypara kaà ɗabiɗaba estuwa na? ");
INSERT INTO mfi_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Kina ka pakyaa kazlaŋaaruwa baɗemme na ka beƴa emtu duksaaŋa ba palle keni am huɗaara? Maàki shakansha waà, sheɓeka ɗekiɗeki. Kwaye emndaaŋa, naàwa emndaaruwa keni, taà kyaminaàkya shairiya ge miya ma buwa na. ");
INSERT INTO mfi_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Kina waà, aàbi magaamaga yawe kulbuwa kalkale yaà am mbaaŋa. Ma nawaaŋa, ma kyawaaŋa keni puwanaaka egdzere ser palle. Ser palle keni zanuka zhel kyawaaŋa dey ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Dete ba una a ceɓana naàza kaambaha na, ya sakanaasa emtu? aàbi nasaraaruwa ba ge iya? Antara ba una a iluwa nayle, una ma ta iluwa an vaciya, ma ta iluwa an vaƴiya keni baɗeme ka fiyar ba ge iya sey yaà eppela. ");
INSERT INTO mfi_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Nja aà kara aà vaciya na, aà pesha ba iya ya vaha deppe aàtekwa. An vaƴiya keni yaà haàre aà ba ate lailaiɗire. Haàre, ate icaaruwa ɓaaka ɗekiɗeki, ma taà paànaà estara emnde hare keni diyanka ya. ");
INSERT INTO mfi_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Kina waà, yawe kulbuwa kalkale ya magaa slera am mbaaŋa. Yawe kelaawa jufaɗaara waà, ya magakaa slera ge sheba egdzaraaŋa buwa. Yawe uŋkwahe waà, ya magakaa slera aà dabba. Ama ekka ser kelaawa kaà aŋkwa aà fatsiya mberaaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ma andze ɓaaka Dadaamiya aà eggyerwa Ibrahiima antara iya, Dadaamiya na ni aà ukkuva edderwa Isiyaaku jipu na, aàbi kina ma andze ngyakisengye am mbaaŋa aà ba an erva dey. Amaà Dadaamiya nanna palasaaruwa antara zlaɗaaruwa am slera ŋa baɗemme, daaci a se dema ŋane am dagavaamiya aà waya. ");
INSERT INTO mfi_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","A ŋwete ge Laban, a ba ŋane aà elvan ge Yakubu: Ay waà, aàbi egdzar ŋwasha na egdzaraaruwa ba ge iya, egdzaraatare na keni eggyahaaruwa ba ge iya, dete ba dabbaha na antara naàzena kaà aŋkwa aà zharana ka baɗemme na aàbi baɗemme ba naàzaaruwa? Aŋkwa naàzu yaà dzegwana ya magaterte ge egdzaraaruwa antara eggyahaaruwa emtu? ");
INSERT INTO mfi_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ekka waà, ŋgweɗamiŋgweɗa namaana am dagavaamiya. ŋere ŋa buwa na waà, ɓaaka dagalaaŋere a cenarancena emnde seydiraaŋere. ");
INSERT INTO mfi_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yakubu a naba eksante naàkwa a dzeɓehe am tate ŋanna ndeɗɗe, una ŋanna gevge nakwa aà yeha Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Am igaara, a ba ŋane aà elvan ge emnde aara: Halawaarhala nakwaha umele. Emndaara ta naba halar nakwaha umele teremme. Daaci ta njehe ate nakwaha ŋanna, ta zuhe atekwa. ");
INSERT INTO mfi_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban a feta zhera aà tate ŋanna: Yaigar Sahaduta, amaana : Dikele aà seydire. Yakubu keni a fete zhera aà Galait. ");
INSERT INTO mfi_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","A ba Laban : Vatena waà, dikele aà nakwaha na naàwa ŋane naà waà, gevge seydire am dagavaamiya, iya antara ka. Aɗaba una ŋanna taà ɗaha tate na an Galait. ");
INSERT INTO mfi_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ta naba fete zhera aà tate ŋanna zlaɓe adaliye: Mispa. Amaana: Tate aà ufa. Aɗaba a ba Laban: Miya antara ka waà, ma kyamikya aàhuna keni sey ba Yaakadada una a de gevge sle ufa dagavaamiya. ");
INSERT INTO mfi_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Maàki ka de fa zlaɗa ate egdzaraaruwa, ma ka de gaterar ŋwasha umele keni diyeddiye geni sledagavaamiya ba Dadaamiya an iraara, urimagweka. ");
INSERT INTO mfi_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","A ba Laban zlaɓe adaliye a elvan ge Yakubu: Ezhzhara ba dikele aà nakwaha na antara nakwa aà yeha Dadaamiya na naàwa ŋane an dzeɓa na. ");
INSERT INTO mfi_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Dikele a nakwaha na antara nakwa aà yeha na an dzeɓe na, bukerɗe gevge seydaha am dagavaamiya antara ka. Iya keni yaà ebzeka naàkwaha na aà dem dalbaaŋa ge magakte kelaadire, ekka keni kaà ebzeka naàkwaha na aà sem dalbaaruwa ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Miya antara ka waà, a`aa aà hyephye ba Dadaamiya a tara Ibrahiima antara Nakaur am dagavaamiya. Mazlaara Yakubu a naba zanu waɗa an Dadaamiya na a kuvanaa eddeŋaara Isiyaaku jipu na. ");
INSERT INTO mfi_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Am iga aà una ŋanna maa, a magaa sadaka ate ire aà wa ŋanna, a naba ɗetaa sleriyahaara ta zu ɗafa aà sadake na. Zaruze maa, ta naba hare ate ire aà wa ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Makurallaara a tsetehe ge Laban an eŋlyawabere, a magatera aàjamimashifa ge egdzaraara antara eggyahaŋaara, a gaterar barka. Am iga aà una ŋanna, a naba eksetaa baramaara, a eptsa aà sem eksaara. ");
INSERT INTO mfi_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Daaci Yakubu keni a naba fanu ge baramaara, ta de ja ire antara malikaha aà Dadaamiya taà sezeŋaara. ");
INSERT INTO mfi_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","A puwete ice ate itare waà, a ba ŋane: Kay! tate na waà, sleɗe a je ire antara Dadaamiya atekwa! Daaci a fete zhere aà tate ŋanna Makanayim. ");
INSERT INTO mfi_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Am iga aà una ŋanna maa, Yakubu a ɓele emnde a ɓela aàkatafkaara, aàdeza egdze a emmeŋaara Isuwa am kwara aà Se`ir am haha aà Aidaum. ");
INSERT INTO mfi_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Lauktu aà ɓelaterɓela, a ba ŋane aà elvan ge itare: Naàwa naàzu kwa de ndahan ge Isuwa: A ba slesleraaŋa Yakubu waà, ndza ya am mba aà Laban. Baɗemme a shekwashekwaaruwa aà shula na ya njaa a ba am mbaara. ");
INSERT INTO mfi_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ganega rezege kwakya, yaà an slaha antara ezzeŋwaha antara kyawaha antara naàwaha, yaà an naàvaha antara kwatenaha. Yaà aŋkwa aà ɓela emnde a ɓelaaruwa aàdekatafkaaŋa na edda waà, geni taà de ɓalakse labare, kaà lyiyiya aà ba an higa. ");
INSERT INTO mfi_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Eptsareptsa emnde a ɓela na aàseza Yakubu, a ba itare taà elvan ge ŋane: Saŋerasa aàsawa aàza egdze a emmeŋa Isuwa, ŋane keni aŋkwa aà sawa an emndaara aà sezeŋa, aŋkwa aà sawa an zaala dermeke ufaɗe. ");
INSERT INTO mfi_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Daaci jaaja lyawa Yakubu waà, gazlaagazla ba jipu na. A naba tegese emndaara, kyawahaara, naàwahaara, slahaara, ezlegwamahaara, gergere buwa. Daaci, emnde na keni taà maga shula an iraatare, emnde na keni taà aŋkwa aà maga shula an iraatare. ");
INSERT INTO mfi_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Aɗaba a ba sawariyaara: Maàki Isuwa daterarde ge emnde na zlaterazle, taà de jauje emnde na. ");
INSERT INTO mfi_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Am iga aà una ŋanna maa, Yakubu a magaa maduwa, a ba ŋane am maduwaara: Yaakadada, Dadaamiya aà eggyerwa Ibrahiima, Dadaamiya aà edderwa Isiyaaku, ka binaa ba ka eptseptsa aà dem lardaaŋa, aà dem tate na ni ta yakaa aàtekwa na, iya yaà aŋkwa antara ka. ");
INSERT INTO mfi_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Hyanepka ba naàzara keni geni yaà shansha baɗemme, shagerire na ni ka ɓeshiyaa ka an ervauŋɗaaŋa palle na. Aɗaba slesleraaŋa a segashe, a ebzu guwa aà Urdun waà, ba zadaara palle am erva, ɓaaka duksa umele. Ama kina waà, kwaye ŋane ŋaà an tega gergere buwa, ma emndara keni taà maga shula an iraatare. ");
INSERT INTO mfi_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Taslaaŋa Yaakadadaaruwa, lyilya ba ka aàtuge egdze a emmerwa Isuwa. Aɗaba jija lyawa jipu aàtuge ŋane, geni a se ceɓaŋerka baɗemme antara ŋwasha antara egdzara. ");
INSERT INTO mfi_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Aɗaba ndza keni ka binaa ba ka an iraaŋa, a ba ka: Yaà aŋkwa antara ka ma vaatara keni. Ya yaàkteya watse ɓaaka kezlakula aà egdzaraaŋa, taà de gev ba seke shili na am guwa na. ");
INSERT INTO mfi_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Daaci Yakubu a hare aà ba am tate ŋanna. Am baɗemme a naàzena aŋkwa am rezegaara maa, a naba dzerse una ni watse aà vante ge Isuwa egdze a emmeŋaara na. ");
INSERT INTO mfi_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","A dzerse mama aà nawaha dermeke buwa antara njifaha kulbuwa, mamaha aà kyawaha dermeke buwa antara zhel kyawe kulbawa, ");
INSERT INTO mfi_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ezlegwamaha kul ufaɗe, taà an egdzara zlaɓa adaliye am ekte taà sha uɓa, mama aà slaha kul ufaɗe antara kawaha kelaawa, uàmaha aà ezzeŋwa kulbuwa ira bidalaha kelaawa. ");
INSERT INTO mfi_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Daaci a naba vaterte duksaha ŋanna ge emnde a sleraara, ma waraatare keni an walde aà duksa palle. A ba ŋane aà elvan ge itare: Naba zlalauzlala kure aà katafkaaruwa, watse yaà ɗabakura aà katalliya. Amaà waà, zlalauka atirpalle, ma walde a uwe keni aà ba an iraara. ");
INSERT INTO mfi_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","A ba ŋane aà elvan ge slesleraara na ni zuŋŋwe ŋane na: Maàki kwa ja ire antara egdze a emmerwa Isuwa waà, maàki a ndavakundave ware eddaaŋa? kaà deme? aàza ware walde na? maàki a ndavaku ndavaha ŋanna waà, ");
INSERT INTO mfi_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","naba ndanndaha: Nazaà aà slesleraaŋa Yakubu, a ba ŋane dawananda ge zanwaaruwa Isuwa. Ba ŋane an iraara keni aŋkwa aà sawa am iga. ");
INSERT INTO mfi_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ga buwiraatare keni a banaa ba una ŋanna, ge keƴiraatare keni ba estuwa. Baɗemme a emnde na ta daa waldaha na a vaterte ba elva palle. A ba ŋane aà elvan ge itare: Kwaà de bana ba una kure ge zanwaaruwa Isuwa, maà de jakurja ire. ");
INSERT INTO mfi_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Naba ndawanndaha a ba kure : Ba Yakubu an iraara keni aŋkwa aà sawa aàkataliya. Yakubu ŋane, a ba ŋane am ervauŋɗaara: Yaà ekhyanakhya ervauŋɗe ge Isuwa an kazlaŋa ŋanna ta danse aà katafkaaruwa na waà, daaci watse aà lyiyiya aà ba an higa. ");
INSERT INTO mfi_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Daaci ta naba danse kazlaŋa zuŋŋwe aà katafkaara, ama ŋane waà, vacite ŋanna zlaɓe a hare aà ba am tate ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","An vaƴiya waà, a tsetehe ge Yakubu, a tsaterte ŋwashahaara buwa, kwatenahaatare buwa antara egdzaara kelaawa jumtekwe, a naba ebzu guwa aà Yabauk an itare aà dehuwaara. ");
INSERT INTO mfi_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Am iga aà una ŋanna a naba se jemaa naàzu am rezegaara baɗemme, a ebzu guwa an ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Yakubu a juwaa ba ŋane mazlaara. A naba semhe ge ura umele, ta hare pacaa a slakala, a kyateraare adaga. ");
INSERT INTO mfi_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Nanna eddaara aà danuka ge Yakubu an slakala maa, a naba taɗanu ja ge Yakubu ate egdaŋazlaara, a gurɗese am egdaŋazla palle. ");
INSERT INTO mfi_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","A ba ŋane aà elvan ge Yakubu : ɓeliyaɓela aŋkwa aà wera ekse. A ba Yakubu : Yaà ɓelakaaka ɗekiɗeki sey maà gagiyarge barka. ");
INSERT INTO mfi_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","A ba ŋane aà elvan ge Yakubu : Ware zheraaŋa? A ŋwanante, a ba ŋane : Yakubu. ");
INSERT INTO mfi_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","A ba ŋane aà elvan ge Yakubu: Mazlaara waà taà ɗehaŋka an Yakubu, zheraaŋa Iserayiila, aɗaba ka slakala an Dadaamiya, ka slakala an emndimagwaha baɗemme, ka ganaa ba ka ndzeɗa. ");
INSERT INTO mfi_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","A ndavanuhe ge Yakubu, a ba ŋane : Ndindaha kwa zheraaŋa keni? A eptsana jawapa, a ba ŋane: Labara kaà ndava zheraaruwa? Am iga a una ŋanna a gar barka ge Yakubu. ");
INSERT INTO mfi_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","A ba Yakubu : Ya naa Dadaamiya an icaaruwa parakke degey! Aley yaà aà ba an shifa! Aɗaba una ŋanna, a fete zhera aà tate ŋanna Paniyail. Amaana: Wafke aà Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Sesse vaciya am haha waà, Yakubu keni ƴanseƴe Paniyail. Aŋkwa aà zlala waà, aà tsagaɗa, aɗaba aà wana egdaŋazlaara na. ");
INSERT INTO mfi_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Aɗaba una ŋanna, sem ba kina kini Iserayiilaha ta zeka hyuwa aà egdaŋazla, aɗaba Iserayiila a shaa ververe ate tate ŋanna shanaasha perɗa. ");
INSERT INTO mfi_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","A kante ice Yakubu waà, aà zhara ba aŋkwa aà sawa Isuwa an emndaara, zaala dermeke ufaɗe na. A naba tegese egdzaraara gergere keƴe ate tara Lee`a antara Rahiilu ira kwatenaha buwa na. ");
INSERT INTO mfi_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Kwatenaha na antara egdzaraatare waà, a puwatera aà katafke, a ɗabatera Lee`a an egdzaraara, lauktu ta ɗabatera tara Rahiilu antara Yusufa aà kataliyaatare. ");
INSERT INTO mfi_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Amaà ŋane an iraara waà, aà katafkaatare baɗemme. Ser vuye aà kezla ugje am aha lauktu aà daada aà de katafke aà egdze a emmaŋaara na. ");
INSERT INTO mfi_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Isuwa ba a puwete ice ate Yakubu waà, zhagade aàdezeŋaara, takwalle a de ŋema am uksuwe, daaci ma waraatare keni aà vante ba kyuwa, taà kyuwa aà ba an yawe aà kyuwa. ");
INSERT INTO mfi_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","A kante icaara Isuwa waà, aà zhara ba egdzara antara ŋwasha. A ndavanu ge Yakubu: Emndara kena taà antara ka na? A eptsanaa jawapa, a ba ŋane: Egdzara na a vantaa Dadaamiya ge walaɗiyaaŋa. ");
INSERT INTO mfi_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ta gapteha ge kwatenaha antara egdzaraatare, ta kezle ugje am aha. ");
INSERT INTO mfi_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lee`a keni a gaptehe, taà an egdzaraara, itare keni ta kezle ugje am aha. Am igaatare baɗemme, ta gaptehe ge tara Rahiilu an Yusufa, itare keni ta kezle ugje am aha. ");
INSERT INTO mfi_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","A ba Isuwa aà elvan ge Yakubu: Kaà kata danme ka waldaha aà duksa gergere na ŋa ja ire ate barama a sawa na? A ŋwanante, a ba ŋane: Ya ɓelanaa aàdeza zanwaaruwa geni a zivarze. ");
INSERT INTO mfi_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","A ba Isuwa: Naba ŋanaaŋa ka egdze a emmerwa ani iya keni ɓaaka zlakte aà nalmanaaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","A ba Yakubu : Estuweka ɗekiɗeki. Maàki ba zakivarze waà, taslaaŋa lyevalya kazlaŋa na am ervaaruwa. Aɗaba yaà aŋkwa aà zharakzhara ate wafkaaŋa waà, seke ba ka Dadaamiya, lyakivalya an ervauŋɗaaŋa palle. ");
INSERT INTO mfi_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Naba lyevalya kazlaŋa na taslaaŋa, a vaktaa ba ervauŋɗaaruwa. ɓaaka lambaaruwa ate nalmane, aɗaba Dadaamiya giyarge barka am duksa baɗemme. Yakubu aŋkwa aà magana tasle jipu ge Isuwa ganakini sey ba aà lyevalya, daaci a naba lyevahe. ");
INSERT INTO mfi_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Am iga aà una ŋanna maa, a ba Isuwa: Magaumaga niya mindalawa. Iya waà , yaà dakurda aàkatafke. ");
INSERT INTO mfi_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Amaà a ba Yakubu aà elvan ge ŋane : Ambarkaaŋa, ba ka keni diyakdiya zlazlaɗa jipu tsufa egdzara. Iyau nawaha antara kyawaha antara slaha na taà an egdzara am ekte na keni sey a yaà datera an eŋkale. Ba maàki yaà datera an ndzeɗa waà, una ba vaha palle taà ruwa. ");
INSERT INTO mfi_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ekka waà, naba ezlala aà katafke aàmbarkaaŋa, aŋkwa aà ɗaakɗaba walaɗiyaaŋa aà kataliya. Iya waà, yaà zlala an eŋkale deydey aà zlala aà dabbaha na taà aà katafkaaruwa na antara egdzara na taà aàzerwa na, watse yaà de shakasha am Se`ir. ");
INSERT INTO mfi_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","A ba Isuwa : Aley keni sey yaà ƴaterƴa emndaaruwa umele aàzeŋa kwaà zlala kerɗe. A ŋwanante ge Yakubu, a ba ŋane: Labara? Iya ba maàki zakivarze lyakivalya waà, hyahya ba una ŋanna ge iya. ");
INSERT INTO mfi_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ba vacite ŋanna, Isuwa a eptsehe aà sem Se`ir, a saa aà ɗaba ba baramaara zlaɓe adaliye. ");
INSERT INTO mfi_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Amaà Yakubu waà, tsaara am tate ŋanna waà, kwaye a zlala aà dem Sukaut. Daaduwa aàhuwa, a de ndere bere, a magateraa beraha ge dabbahaara keni. Aɗaba una ŋanna a fete zhere aà tate ŋanna Sukaut. Amaana: Beraha. ");
INSERT INTO mfi_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Eptsaptsa Yakubu aà sawa am Padan Aram, a tsekwe ba lapilayye am Sikaim am kwara aà Kanaana. Daaci a magaa haara ate iga aà ekse. ");
INSERT INTO mfi_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","A naba shekweve egdze a sleɗaara am erva aà emnde aà Hamaur, eddawna ni a tsekwe zuŋnwe am Sikain ŋanna. A shekweve sleɗe ŋanna an gursa dermeke, daaci a maga beraha aàtekwa an kacakaca. ");
INSERT INTO mfi_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Am iga aà una ŋanna maa, a ndere tate a fanaa sadake atekwa ge Dadaamiya am tate ŋanna, a fete zhera: Dadaamiya Saksage waà, Dadaamiya aà Iserayiila. ");
INSERT INTO mfi_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Vacite umele, Dina aà Yakubu, egdzere mukse a yanaa an Lee`a, a de zhara ukfahaŋaara egdzar ŋwasha na taà am ekse ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","De nanna Sikaim egdze aà Hamaur, slekse keni ba ŋane, a naba eksevaahe ge egdze ŋanna a ba an ndzeɗa, a dana aà ba aà dem bere, a de badzanve, a fem egdzena am zherwe. ");
INSERT INTO mfi_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Amaà waà, wayetewaya jipu an Dina egdze aà Yakubu na ɓaaka buwaara. Aɗaba una ŋanna ɓaaka nazu magaaka geni aà ekhyannakhya ervauŋɗe ge gyaale. ");
INSERT INTO mfi_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","A ba ŋane aà elvan ge eddeŋaara: Sey kaà giga gyaale ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Cenancena Yakubu ganakini faremfa egdzaara Dina am zherwe, amaà a ɗu ba waara ndahaaka elva. Aɗaba egdzaraara egdzar zaala ta ɓaaka am mba, taà aŋkwa aà piya am kaamba, sey maà saraasa. ");
INSERT INTO mfi_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Daaci a naba sawhe ge Hamaur eddarge Sikaim ŋanna aàseza Yakubu eddarge Dina ganakini aà ndaha elva antara ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Am sarte ŋanna maa, egdzara aà Yakubu egdzar zaala na keni saraasa am piya na. Ba ta cenaa lamare na waà, jaterja emtaŋkire ma waraatare keni ba seke aà segashe shifa am ŋane. Aɗaba Sikaim maganaamaga naàzu zlayeka ɗekiɗeki, a naba eksevaa egdze aà Yakubu a ganve mukse. Jeba una ŋanna aà magaaveka am Iserayiila ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","A ba Hamaur aà elvan ge itare : Egdzaaruwa wayatewaya an egdzaakure ɓaaka buwaara. Taslawaakure vawanteva a gegga. ");
INSERT INTO mfi_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Naba gawamiyevge shawlaha. Vawaŋerteva egdzaraakure ŋa gaterga ge egdzaraaŋere, ŋaà vakurte egdzara ŋere kwaà gater ge egdzaraakure. ");
INSERT INTO mfi_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Naba njawaminji. Ba sleɗe na kwa katana kure na ŋaà icakuru ba tate ŋanna. Kwaà tsakalaakure, kwaà sheta nalmane kwakya. ");
INSERT INTO mfi_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","A sawhe ge Sikaim an iraara, a ba ŋane aà elvan ge eddarge gyaale antara egdzar mamahaŋaara ge gyaale: A maiɗeheka ervauŋɗaakure ɗekiɗeki naba ƴawiyarƴe, ba nazena kwa fiyare a kure na, yaà emmaga baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Magauka shaige ɗekiɗeki, naba ɓelawiyarɓele. Ma kwa ndava wanyara naàza shebe keni antara una ɓaaka am shebe ba dey na, yaà emmaga baɗemme maà ba kwaà viteva kure muksaaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Egdzara aà Yakubu ta ŋwaterante ge tara Sikaim an eddeŋaara an nama ate we aɗaba ta fem egdze a emmetare Dina am zherwe na. ");
INSERT INTO mfi_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","A ba itare taà elvan ge itare : ŋere ŋaà tsa vanteka ŋere egdze a emmeŋere ge zhel na ɓelaaka am sheɗkwe na, aɗaba ŋaà de geva an epsawa jipu. ");
INSERT INTO mfi_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","16","Daaci ŋaà tsa maganaaka ate una kwaà katana kure na, sey maà gakurevge estuwa waà, ŋaà vakurteve egdzaraaŋere kwaà naba gaterga, ŋere keni ŋaà naba ga egdzaraakure taà gev ŋwashahaaŋere, mi naba njaamiya aàtirpalle deɓiiye, mi gev ba jeba palle. ");
INSERT INTO mfi_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Amaà maà eksakurarka elvaaŋere na waà, ŋere ŋaà teɗeseteɗe egdze a emmeŋere, ŋaà zlalaaŋere. ");
INSERT INTO mfi_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Elva ŋanna lyavaalya ervauŋɗe aà tara Hamaur antara egdzaara Sikaim. ");
INSERT INTO mfi_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Dawale ŋanna de paaka hare an elva ŋanna ɗekiɗeki, aɗaba wayaawaya jipu an gyaale egdze aà Yakubu na. Am huɗe aà haà aà eddeŋaara keni ŋane an daradza jipu. ");
INSERT INTO mfi_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Daaci tara Hamaur an egdzaara Sikaim ta naba dem jahava aà eksaatare ate we aà walkame an elva na. A ba itare taà elvan ge zlamakelaawa : ");
INSERT INTO mfi_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Emnde na waà, aà duwa elvaamiya, naba ƴawaterƴa a njarinja am lardaamiya, a magarmaga tsakalaatare. Sleɗe aŋkwa aà hyamiyarhye. Mi naba ga egdzaraatare mi gaterve ŋwashahaamiya, mi vaterteva egdzaraamiya ge itare keni, taà naba gaterga. ");
INSERT INTO mfi_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Amaà, lauktu taà eksar gev palle antara miya, mi gev ba jeba palle antara itare na waà, sey maàki aàze miya keni zaala baɗemme taà demda am sheɗekwe ba seke itare. ");
INSERT INTO mfi_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Maàki eksamiyarekse abi baɗemme a waldahaatare antara dabbahaatare umele ira kazlaŋaatare umele baɗemme na aà de gev ba naàzaamiya? Naba eksawamiyarekse, a sarsawa mi se njaamiya aàtirpalle. ");
INSERT INTO mfi_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Daaci baɗemme a emnde na taà aŋkwa am jahava ŋanna ate we aà walkame na eksararekse elva aà tara Hamaur an egdzaara na, zaala baɗeme daremda am sheɗekwe. ");
INSERT INTO mfi_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Am hare ge keƴire am iga a dem sheɗekwaatare waà, zaala baɗemme taà aà zlava aɗaba zlaɗaara. Daaci duwa aà egdzara aà Yakubu buwa, tara Simaun antara Laiwi egdzar mamahaŋaara ge Dina, ta naba halem katsarkar am erva, ta dateraarhe an naàza erva, ta ceɓaa zaala baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Tara Hamaur an egdzaara Sikaim keni taà an ceɓa bukerɗe. Am iga aà una ŋanna ta teɗese egdze a emmetare am mba aà Sikaim ba ezlzalaatare. ");
INSERT INTO mfi_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ta naba sawhe zlaɓe adaliye ge egdzara aà Yakubu umele maa, ta naba daterarhe ge emnde na taà am emtsa na, ta zu ekse baɗemme aɗaba zherwe na ta fem egdze a emmetare am huɗaara. ");
INSERT INTO mfi_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Kyawaha, eslslaha, ezzeŋwaha antara kazlaŋa umele am huɗe aà ekse antara ba una zlaɓe am fe, baɗemme halarsehale. ");
INSERT INTO mfi_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Dete ba emndimagwaha, egdzara mesheshe antara ŋwasha ira kazlaŋa na am berahaatare, halarsehale rezege aà ekse ŋanna baɗemme, zlarzlala an ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","A ba Yakubu aà elvan ge egdzaraara, tara Simaun antara Laiwi : Kwaye fakurimfa am dzama ire ƴaike. Aɗaba tsakurantetse ervauŋɗe a emnde a haha na baɗemme aàsete ya. Amaana: Emnde a Kanaana antara Pairisiyaha. Naàwa watse itare taà de jemaa yaatare, taà se gweyargwe, emndaaruwa keni taà cekwa vayvaya. Kay! una waà, aà de juka haaruwa ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ta ŋwanante ge tara Simaun an Laiwi, a ba itare: Egdze a emmeŋere ba ge ŋere taà ganve seke mukse zaware waà, zlauzle ba ɓaaka elvan emtu? ");
INSERT INTO mfi_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Daaci a ba Dadaamiya aà elvan ge Yakubu: Tsetstse aàhuna, ezlzlala aà dem Baytila, de njanaanja iraaŋa aàhuwa. De nderinndera tate aà fiya sadake ge iya ya Dadaamiya na ya marakaa iraaruwa, am sarte na ka zhagade aàtuge egdza a emmeŋa Isuwa na. ");
INSERT INTO mfi_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Daaci a ba Yakubu aà elvan ge emndaara baɗemme, emnde na taà am huɗe aà haara antara emnde na taà aàzeŋaara baɗemme: Sawansese helaha aà emnde a jeba umele na am dagavaakure, barawaabara iraakure cuɗeɗɗe, mbaɗawaambaɗa kazlaŋa keni ba tseɗaŋtseɗaŋŋe. ");
INSERT INTO mfi_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Magaumimaga niya watse mi maga shula aà dem Baytila, yaà de nderana tate aà fana sadeke aàtekwa ge Dadaamiya aàhuwa. Dadaamiya na ni a meliwa am sarte a zlaɗa, aŋkwa antara ya ma yaà deme keni baɗemme na. ");
INSERT INTO mfi_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Daaci ta naba janme helaha aà emnde a jeba ŋanna ndza aŋkwa am ervaatare na baɗemme antara naàza hyemahaatare, ta naba vante ge Yakubu, ŋane a naba heɗante ge ekte aà nafa umele am Sikaim, nafa ŋanna ƴaikke jipu. ");
INSERT INTO mfi_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Mazlaara ba tsaatare am tate ŋanna, ta naba kezla. Duwa aà Dadaamiya maa, a naba faterem lyawa ƴaikke am vuwa ge emnde a eksaha aà haha ŋanna baɗemme, ɓaaka ura a dateraa wava ge egdzara aà Yakubu an eddetare ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","7","Daaci a daa estuwa Yakubu antara emnde na taà aàzeŋaara baɗemme aà dem Lairuz am haha aà Kanaana, Baytila ŋaara ba tate ŋanna. A de nderan tate aà fana sadake aàtekwa ge Dadaamiya, a fete zhera aà tate ŋanna: Dadaamiya aà Baytila. Aɗaba Dadaamiya a maranaa iraara am tate ŋanna am sarte aà zhagadaara aàtuge egdze a emmeŋaara Isuwa. ");
INSERT INTO mfi_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Cekwaaŋguɗi waà, emtsamtsa Daibaura slefanu uɓa ge Raibaika. Ta heɗenaa aà dem ahaara ge Baytila ŋanna, am ekte aà nafa umele aŋkwa, nafa ŋanna an ndzeɗa jipu. Ta fete zhera aà nafa ŋanna: Nafa aà kyuwa ura. ");
INSERT INTO mfi_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Am sarte na saasa Yakubu am Paddan Aram, Dadaamiya a naba maranaa iraara, a gar barka. ");
INSERT INTO mfi_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","A ba Dadaamiya aà elvan ge ŋane: Kina waà, zheraaŋa Yakubu, amaà aà salikataliya na waà, taà de ɗahaka an Yakubu ka mazlaara, zheraaŋa Iserayiila. Daaci Dadaamiya a fete zheraara Iserayiila. ");
INSERT INTO mfi_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","A ba Dadaamiya aà elvan ge ŋane zlaɓe adaliye: Ba iya una ya Dadaamiya, hakuma baɗemme aà ba am ervaaruwa. Gevge eddarge nalgaha kwakya, vanakteva ya. Egdzaraaŋa taà de ya lardaha gergere, sleksaha gergere kwakya taà de segashe am emndaaŋa. ");
INSERT INTO mfi_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Haha na ndza ya vante ge Ibrahiima antara Isiyaaku na waà, yaà vakte ge ekka antara egdzaraaŋa am igaaŋa, aà de gev ba hahaatare. ");
INSERT INTO mfi_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Am iga una ŋanna, a zlalehe ge Dadaamiya, a ƴaa Yakubu am tate ŋanna a ndahan elva na. ");
INSERT INTO mfi_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakubu a naba dzeɓaa nakwa aà yeha Dadaamiya am tate ŋanna, a kete egdze a mbazla aàtekwa sadakaara ge Dadaamiya, a kete antara egdze a waye ate nakwa ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Daaci Yakubu a fete zhera aà tate ŋanna Baytila. ");
INSERT INTO mfi_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ta naba tse zlaɓe adaliye, ta kezla am Baytila. Itare keni a ƴaterar ba cekwaaŋguɗi sharanaasha ekse aà Aifrata, tsekwanfetsekwe huɗe aà yaà ge Rahiilu, a naba ye egdzere zhele, amaà a yaa am palasa. ");
INSERT INTO mfi_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Am Rahiilu a yaà am zlaɗa jipu, a ba mukse na aŋkwa a eyya na aà elvan ge ŋane: A waŋka lyawa, shakansha egdzere zhele adaliye. ");
INSERT INTO mfi_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Amaà a ƴaa ba cekwaaŋguɗi aà kata emtsa Rahiilu. Aɗaba ndza a kata segashe shifa am ŋane, a fete zhera aà egdze ŋanna Bain Auni, amaana: Egdze a palasaaruwa. Amaà eddarge egdzere waà, a fete zhera a Bainjamaiŋ, amaana: Egdze a naɗafa. ");
INSERT INTO mfi_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","20","Emtsamtsa Rahiilu, ta heɗehe ate barama aà Aifrata. Ba tate ŋanna una taà ɗahana an Baytilaama kina. Yakubu a naba dzeɓaa nakwa aà dzama Rahiilu ate irekhyaara. Sem vatena keni zlaɓe aŋkwa nakwa aà dzama Rahiilu ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Iserayiila a naba tse aàhuwa, kwaye a de magaa berahaara an kacakaca am iga aà bere slaɗɗe na taà ɗahana an Migdal Aidair na. ");
INSERT INTO mfi_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Am sarte na taà am larde ŋanna maa, Rubain a naba katu Bilha palle aà ŋwashaha aà eddeŋaara, cenancena eddeŋaara. Yakubu, ŋane ndza an egdzara kelaawa ju buwa egdzar zaala. ");
INSERT INTO mfi_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Egdzara aà Lee`a tara Rubain, ŋane egdzere zuŋŋwire, an Simaun an Laiwi an Yahuuda an Isakar ira Jabulaun. ");
INSERT INTO mfi_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Egdzara aà Rahiilu, tara Yusufa taà an Bainjamaiŋ. ");
INSERT INTO mfi_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Egdzara aà Bilha kwatena aà Rahiilu, tara Dan taà an Naiftalim. ");
INSERT INTO mfi_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Egdzara aà Jilpa kwatena aà Lee`a, tara Gada taà an Asair. Kwaye ŋane egdzara aà Yakubu a yayanaa am Paddan Aram. ");
INSERT INTO mfi_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Daada Yakubu aàtevege eddeŋaara Isiyaaku am Mamre, am Kiriya Arba. Kina waà, Haiburun zhera aà tate ŋanna, tate na ni ta nja aàtekwa tara Ibrahiima antara Isiyaaku. ");
INSERT INTO mfi_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Iva aà Isiyaaku a magaa dermeke an kul tise am sarte na aà emtsa. ");
INSERT INTO mfi_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Ndza gevge emgyegwe a zhele kurcumme, a jesaa an je am iraara nja an shifa. A daahe aà deza eggyahaŋaara am faya. Ta heɗana ba egdzaraara, tara Isuwa antara Yakubu. ");
INSERT INTO mfi_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Naàwa una waà, labare aà kergema aà emnde aà Isuwa. Aidaum keni ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Isuwa a ge ŋwashahaara, baɗemme ba egdzara aà emnde a Kanaana. Naàwa ŋwashahaara ŋanna: Ada egdze aà Hailaun, ŋane ura Haiti; Auhaulibama egdze aà Ana a Jibaiyaun, ŋane keni ura Haiwi, ");
INSERT INTO mfi_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","antara Basmat egdze aà Isma`iilu, egdze a emmeŋaara ge Naibayaut. ");
INSERT INTO mfi_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada a yan Ailifas ge Isuwa. Basmat a yan Raiwail. ");
INSERT INTO mfi_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Auhaulibama, ŋane keni a yan Yai`us antara Ya`alaam ira Kaura. Kwaye ŋane egdzara aà Isuwa na a yayateraa am haha aà Kanaana. ");
INSERT INTO mfi_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Isuwa a naba kezla atevege egdze a emmeŋaara, Yakubu, kwaye a zlala aà dem haha umele ƴiyiye jipu an ŋane. A naba kezla an ŋwashahaara, egdzaraara, emnde na taà am huɗe aà haara antara dabbahaara ira naàzena am rezegaara a ganaa am haha aà Kanaana baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Kezla aà Isuwa aàtevege Yakubu na waà, aɗaba kwakya nalmanaatare, kaamba cekwa ge tate aà piya waldahaatare. Dzegwaranka nja am tate palle, aɗaba taà an waldaha kwakya jipu. ");
INSERT INTO mfi_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Daaci Isuwa kwaye a de njaara am huɗe aà wa aà Se`ir. Isuwa na waà, ba Aidaum. ");
INSERT INTO mfi_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Nawa emnde na waà, wulfaha aà Isuwa, eggyetare ge Aidaumiyaha, am huɗe aà wa a Se`ir. ");
INSERT INTO mfi_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Nawaà zhera aà egdzara aà Isuwa, egdzar zaala: Ailifas, egdze aà Ada, Raiwail egdze aà Basmat. ");
INSERT INTO mfi_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Naàwa emnde na keni egdzara aà Ailifas: Tara Taiman, an Aumar, an Jaifau, an Gatam ira Kainas. ");
INSERT INTO mfi_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Aŋkwa zlaɓe Timna, ŋane keni ba mukse aà Ailifas a eksanta aàkataliya, ŋane keni a yan Amalaik. Kwaye ŋane eggyahaŋaara ge Isuwa, egdzara aà egdzara aà muksaara Ada. ");
INSERT INTO mfi_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Nawa emnde na keni egdzara aà Raiwail: tara Nakat, an Sairak, an Samma ira Misa. Kwaye ŋane eggyahaŋaara umele ge Isuwa, egdzara aà egdze a muksaara Basmat. ");
INSERT INTO mfi_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Auhaulibama egdze a Ana, eggyeŋaara ge Jibaiyaun keni maa, a yayan tara Ye`us, an Ya`alaam ira Kaura ge Isuwa. ");
INSERT INTO mfi_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Nawa sleksaha aà emnde aà Isuwa: Sleksu Taiman, an Aumar, an Saifau, an Kainas, ");
INSERT INTO mfi_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","an Kaura, an Gatam ira Amalaik. Kwaye ŋane sleksaha aà Ailifas am haha aà Aidaum. Ailifas ŋanna waà, egdzere zuŋŋwiraatare ge tara Isuwa antara muksaara Ada. ");
INSERT INTO mfi_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Nawa emnde na keni eggyahaatare ge tara Isuwa an muksaara Basmat, egdzara aà egdzaatare Raiwail: Sleksu Nakat, an Sairak, an Samma ira Misa. Itare sleksaha aà emnde aà Raiwail am haha aà aidaum. ");
INSERT INTO mfi_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Nawa eggyahaatare ge tara Isuwa antara muksaara Auhaulibama: Tara sleksu Ye`us, an Ya`alaam ira Kaura. Itare keni ndza ta sleksaha aà emnde aà Auhaulibama, zhera a mukse aà Isuwa egdze aà Ana. ");
INSERT INTO mfi_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Itare baɗemme na, ta ba wulfaha aà Isuwa ndza ta sleksaha aà emnde a hahaatare am Aidaum. Aidaum na keni ba zhera aà Isuwa ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Naàwa egdzara aà Se`ir eggyetare ge Hauriyaha emnde a nja am haha ŋanna zuŋŋwe: Lautan, Saubal, Jibaiyaun, Ana, ");
INSERT INTO mfi_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disaun, Aijair ira Disan. Kwaye ŋane sleksaha aà hauriyaha emnde a Se`ir am haha aà Aidaum. ");
INSERT INTO mfi_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Naàwa egdzara aà Lautan keni : tara Hauri antara Hemam. Aŋkwa egdze a emmeŋaara mukse ge Lautan ŋanna keni, zheraara Timna. ");
INSERT INTO mfi_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Nawa emnde na keni egdzara aà Saubal: Aluwam, Manakat, Aibal, Saifau ira Aunam. ");
INSERT INTO mfi_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Naàwa egdzara aà Jibaiyaun: Tara Aya an Ana. Ba Ana na ndza a shaa yawaha an mbera am kaamba am sarte na a piya ezzeŋwaha aà eddeŋaara na. ");
INSERT INTO mfi_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Naàwa emnde na waà, egdzara aà Ana: Disaun ŋane egdzere zhele, taà an Auhaulibama ŋane waà, egdzere mukse. ");
INSERT INTO mfi_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Nawa emnde na keni egdzara aà Disaun: Tara Haindan, an Aisban, an Yaituran ira Kairan. ");
INSERT INTO mfi_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Naàwa una keni egdzere aà Aijair: Bilhan, Ja`awan ira Akan. ");
INSERT INTO mfi_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Naàwa emnde na keni egdzara aà Disan: Us, an Aaran. ");
INSERT INTO mfi_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Naàwa sleksaha aà Hauriyaha: Lautan, Saubal, Jibauyaun, Ana, ");
INSERT INTO mfi_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disaun Aijair ira Disan. Kwaye ŋane sleksaha aà Hauriyaha ate jebaha gergere am haha aà Se`ir. ");
INSERT INTO mfi_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Naàwa emnde na ni ndza ta sleksaha saɗaɗɗe am haha aà Aidaum, lauktu ta jesarje sleksaha am Iserayiila: ");
INSERT INTO mfi_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Baila egdze aà Bai`aur ŋane ndza slekse aà Aidaum. Zhera aà eksaara Daimhaba. ");
INSERT INTO mfi_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Emtsamtsa Baila maa, a demaa Yaubaba egdze aà Sairak am sleɗaara. Yaubaba, ŋane ura ekse aà Bausra. ");
INSERT INTO mfi_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Emtsamtsa sleksu Yaubaba, a demaa Hausam am sleɗaara. Hausam ŋane ura larde aà Taimani. ");
INSERT INTO mfi_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Emtsamtsa Husam maa, Hadaadu egdze aà Baidada a demaa am sleɗaara. Ba Hadaadu na ndza a ga ndzeɗa arge emnde a Madiyan am larde aà Mau`ab na. Zhera aà eksaara Awit. ");
INSERT INTO mfi_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Emtsamtsa Hadaadu, a demaa Samla ura ekse aà Masraika am sleɗaara. ");
INSERT INTO mfi_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Emtsamtsa Samla, a demaa Sawulu ura ekse aà Raikaubaut ate we aà haye am sleksire. ");
INSERT INTO mfi_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Emtsamtsa Sawulu, a demaa Ba`al Hanan egdze aà Akkaur am sleɗaara. ");
INSERT INTO mfi_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","De emtsamtsa Ba`al Hanan egdze aà Akkaur, a demaa Hadar am sleɗaara. Zhera aà eksaara ge ŋane keni Pa`u. Zhera aà muksaara Maihaitabaiyail, egdze aà Maitiraida, eggyeŋaara ge Maijahat. ");
INSERT INTO mfi_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Naàwa una keni zheraha aà emnde na ndza ta sleksaha am emnde aà Isuwa, ma waraatare keni ndza slekse am jebaara, an kwaraara: Sleksu Timna, Aluwa, Yaitait, ");
INSERT INTO mfi_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Auhaulibama, Aila, Pinauŋ, ");
INSERT INTO mfi_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kainas, Taiman, Mipsaara, ");
INSERT INTO mfi_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiyail ira Iram. Kwaye ŋane emnde na ndza ta sleksaha am Aidaum, ma waraatare keni ndza aà ba an sleɗaara, aà ba an kwaraara. Kwaye ŋane nja aà emnde aà Isuwa, eggyetare ba ŋane ge emnde aà Aidaum. ");
INSERT INTO mfi_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Daaci Yakubu njaanja am haha aà Kanaana, am tate na ni ndza a nja aàtekwa eddeŋaara na. ");
INSERT INTO mfi_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Naàwa labare aà egdzara aà Yakubu ŋanna. Am sarte ŋanna maa, Yusufa magaamaga egdze aà yawe kelaawa ju vuye. ŋane antara egdzara aà eddeŋaara egdzara aà Bilha antara egdzara aà Jilpa ŋwashaha aà eddeŋaara, taà aŋkwa a piya nawaha antara kyawaha aà eddetare. Mbate Yusufa na waà, elva a mandzawe na taà aŋkwa aà tsakana egdzara aà eddeŋaara am tate aà piya na waà, baɗemme aà se ɓalananse ge eddeŋaara. ");
INSERT INTO mfi_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Iserayiila keni a wayete ba Yusufa ŋanna kwakyaara am egdzaraara, aɗaba ŋane egdze a emgyegwiraara. Daaci a naba dzeɓana naŋgyuwe na ni an daradza jipu naa. ");
INSERT INTO mfi_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","De diyareddiye egdzara mamahaŋaara geni ŋane shansha welawire aàza eddetare, ervauŋɗaatare a naba ƴaa Yusufa na. Mele ɓaaka ura aà bana elva emtake am dagavaatare mazlaara. ");
INSERT INTO mfi_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Vacite umele maa, Yusufa a naba shaa shene, a ndahaterhe shenaara ŋanna ge egdzar mamahaŋaara na. Itare ta farhe zlaɓe adaliye ge ƴaa Yusufa na am ervauŋɗaatare. ");
INSERT INTO mfi_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Aɗaba nawa naàzu a baterna ŋane, a nanaa am shenaara. A ba ŋane aà elvan ge itare: Cenaucena naàwa yaà ndakur shenaaruwa: ");
INSERT INTO mfi_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ma de ica hiya am fe waà, ma ŋgwaɗaa daɓakwahaara waà, naàzaaruwa waà tsatsa ba darayye am dagave aà naàzahaakure, amaà naàzahaakure waà, ta jantaave ge nazaaruwa na, taà aŋkwa aà kezlan ugje baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ta ndavanuhe ge egdzara mamahaŋaara na, a ba itare taà elvan ge ŋane: Manaa watse kaà gev sleksaaŋere kaà de maga sleksiraaŋa ate ŋere emtu? Gevge waà, ba zhara Yusufa keni wayarka mazlaara. Aɗaba shena antara elvaara na a ndaaterse na. ");
INSERT INTO mfi_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Am iga aà una ŋanna zlaɓe adaliye, Yusufa a naba shaa shene umele, a naba ndaterhe ge egdzar mamahaŋaara ŋanna zlaɓe adaliye, a ba ŋane: Naàwa yaà aŋkwa aà ndakur shenaaruwa ya shanaa ya: Am shenaaruwa waà, ta kezli ugje tara vaciya, tre antara terlyakwaha kelaawa jemtekwe. ");
INSERT INTO mfi_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","A naba ndaterhe parakke ge tara eddeŋaara keni antara egdzar mamahaŋaara. A valarhe ge eddeŋaara, a ba ŋane aà elvan ge ŋane: Shenara ŋane ka shanaa ka! Amaana watse ŋaà de kezlakek ugje, emmeŋa, egdzar mamaha a ŋa antara ba iya an iraaruwa ŋaà de kezlakek ugje ge ekka emtu? ");
INSERT INTO mfi_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Egdzar mamahaŋaara baɗemme tsarantetse shelha a dete ŋane, amaà eddeŋaara waà, elva na seska am iraara ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Vacite umele maa, egdzar mamahaŋaara ge Yusufa ta de piya nawaha antara kyawaha aà eddetare am Sikaim. ");
INSERT INTO mfi_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","A ba eddetare aà elvan ge Yusufu : Abi egdzar mamaha a ŋa ta de piya am Sikaim, sawa nawa yaà ɓelakɓela aà dezetare. Ane, aà ba egdze na. ");
INSERT INTO mfi_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Daaci a ba Yakubu aà elvan ge ŋane: Edduwa de zharinaazhara egdzar mamaha a ŋa antara dabbaha, taà a ba aŋkwa he, kaà siya labare. A ɓelanaa aà da am ɗambake aà Haiburun, aà dem Sikaim. ");
INSERT INTO mfi_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Daaci Yusufa aŋkwa aà ja ɗaba am kaamba aà Sikaim, de jarje ire antara ura umele, a ba eddaara aà elvan ge ŋane: Kaà tataya uwe ka? ");
INSERT INTO mfi_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","A ba Yusufa : Yaà aŋkwa aà tataya egdzar mamahaaruwa taà aŋkwa aà piya. Taslaaŋa ndindaha tate na taà aàtekwa. ");
INSERT INTO mfi_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Daaci a ba eddaara : Ta ɓaaka aàhuna, zlarzlala. Aɗaba ya cenancena waà, ta bantsa itare: Mi zlalawa aà dem Dautan. Daaci zhagade ge Yusufa, aŋkwa aà bakaterbaka, kwaye a de shaterte am Dautan. ");
INSERT INTO mfi_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Kerteŋ naranna itare ba zlaɓe ƴiƴiye an itare emtsaaɗe. Lauktu aà daada Yusufa aàzetare waà, ŋgwaɗaranaaŋgwaɗa itare am dagavaatare geni sey taà keɗanaakeɗa shifaara. ");
INSERT INTO mfi_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","A ba itare am dagavaatare: Kwaye aŋkwa aà sawa edda aà shene na. ");
INSERT INTO mfi_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Sawmbare gwaumiyargwe, jaumija shifaara, mi eblyanme am suwa, daaci mi de ba a zuwa naàza kaamba. Maà ezhzhara kwa maà watse aà gevge shenaara ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Cenatercena Ruubain maa, a naba magaa niya a ŋezlese shifa aà Yusufa, a ba ŋane aà elvan ge itare: Jaumika shifaara. ");
INSERT INTO mfi_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","A farhe zlaɓe adaliye, a ba ŋane : Jaumika shifaara taslawaakure. Arge una ŋanna waà, ambane eblyawanmeblye am suwa kwaye ŋane am kaamba aàhuwa. Amaà shifaara waà, gejauka. Niyaara ge ŋane waà, geni aà fertanaaferta aàtuge itare, a daada aà deza eddeŋaara. ");
INSERT INTO mfi_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ba demdaara ge Yusufa aà deza egdzar mamahaŋaara ŋanna maa, ta naba eksevaahe, ta tsekwanse am naŋgyuwaara na an daradza jipu na, ");
INSERT INTO mfi_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ta eksante iraara, ta naba elbyanme am suwa. Amaà am suwa ŋanna waà, ɓaaka yawe am huɗaara welasewele ba ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Daaci de njarinja am aha reppe ge za egdze a duksa. Estuwa ta kante ice waà, taà zhara ba emnde, ta vayye jipu, taà aŋkwa aà sawa. Emnde ŋanna waà, emnde aà Isemayiila ta tsete am Gile`at, taà maga shula aà dem Misera. Taà an naàzasaha gergere ate iga aà ezlegwamahaatare, taà dana aà dem Misera ŋanna. Umele yawyawaara, umele naavawe aà se emtake jipu, umele keni slalwe aà duksa aà se emtake keni. ");
INSERT INTO mfi_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","A ba Yahuuda aà elvan ge egdzar mamahaŋaara : Maàki jamija kwa kina egdze a emmemiya ba ge miya, mi sheɓanve emtsaara waà, mi sha uwe miya am huɗaara? ");
INSERT INTO mfi_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Sawmbare mi velateruvele ge emnde aà Isemayiilu na. Gejaumika shifaara. Aɗaba ma estara keni ba egdze a emmemiya, vuwaamiya ba ge miya. Ta naba cenanvaahe ge egdzar mamahaŋaara. ");
INSERT INTO mfi_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Taà aŋkwa aà degashe emnde a tsakala, emnde a Madiyan maa, ta naba teɗese Yusufa am suwa na, ta velateruhe ge emnde aà Isemayiilu ŋanna aà maga gursa kulbuwa. Daaci itare ta danhe Yusufa na aà dem larde a Misera. ");
INSERT INTO mfi_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Eptsa aà Ruubain aà dem suwa na de beƴeka Yusufa am huɗaara. A naba tataa naŋgyuwaara ate vuwa, ");
INSERT INTO mfi_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","a eptsehe a deza egdzar mamahaŋaara na, a ba ŋane aà elvan ge itare : Digiya ɓaaka egdze na kina mu yaà magana estara ? ");
INSERT INTO mfi_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ta naba eksevaa usale, ta icantiye, ta hanme naŋgyuwe aà Yusufa am uzhaara. ");
INSERT INTO mfi_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Daci ta naba ɓela ura an ŋane, aà saà, a sanan ge eddetare, a sanaa labare na, a ba elvaatare taà elvan ge eddetare: Naàwa naàzena ŋa shanaa ŋere am kaamba. Zharanaazhara ba shagera mu, naŋgyuwe aà egdzaaŋa emtu ŋane ka he ? ");
INSERT INTO mfi_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakubu a naba disehe, a ba ŋane: Una naŋgyuwe aà egdzaaruwa, yaà! ɓaaka egdze na zauze naàza kaamba. Dzadzaadzadze dabba a kaamba Yusufaaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Daaci a naba dzadzaa naŋgyuwe ate vuwa, a tsekweme am emgywe a buhwaha, a fantau ge kyuwa egdzaara hare wanyarwanyara. ");
INSERT INTO mfi_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Egdzaraara baɗemme, egdzar zaala antara egdzar ŋwasha taà aŋkwa aà de gan use, amaà kwalevkwale ba ɗekiɗeki, aà ekhyeka ervauŋɗaara. A bantsaa ŋane: ƴaà de beƴa estuwa egdzaaruwa am faya keni, yaà ƴanka kyuwa ɗekiɗeki. A fantauhe zlaɓe adaliye ge kyuwa egdzaara. ");
INSERT INTO mfi_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Amaà Yusufa waà, de velaruvele emnde a Maadiyan am Misera. Ta de velanu ge Pautifar nakawa ƴaikke, eddawna ni fetarfe sleksu Firawna an ŋane, male aà sawjiyaha na taà ufa ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Am sarte ŋanna maa, Yahuuda a naba ƴaa egdzar mamahaŋaara waà, ba zlalaara aà dem Adulam, a de tsekwaa am mba a ura umele zheraara Hira. ");
INSERT INTO mfi_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yahuuda a naa gyaale ahuwa, zhera aà gyaale ŋanna Su`a, egdze aà emnde a Kanaana. Daaci a naba gehe a ganve muksaara. ");
INSERT INTO mfi_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Mukse na a shaa huɗe, a ye egdzere zhele. Yahuuda a fete zhera aà egdzere Air. ");
INSERT INTO mfi_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","A shaa huɗe umele, a ye egdzere zhele adaliye, a fete zhera aà Aunan. ");
INSERT INTO mfi_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","A shaa huɗe umele zlabe adaliye, a ye ba una ŋanna, a fete aà Saila. Amaà taà yaà Saila waà, Yahuuda am Kaijip. ");
INSERT INTO mfi_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yahuuda a eksanante gyaale ge Air, egdzere zuŋŋwirraara. Zhera aà gyaale ŋanna Tamar. ");
INSERT INTO mfi_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Amaà Air egdze aà Yahuuda ŋanna waà, slemandzawe jipu am ice aà Yaakadada. Aɗaba una ŋanna a keɗanaahe ge Yaakadada. ");
INSERT INTO mfi_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","A ba Yahuuda aà elvan ge Aunan: Naba melsemele mukse aà maleŋa na ŋgweɗauŋgweɗa nika, fanefa wakiyiya ge egdze a emmeŋa. ");
INSERT INTO mfi_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Daaci diyaadiya Aunan geni maà shanansha egdzere waà, egdze ŋanna aà tsaa gevka egdzaara ge ŋane. Aɗaba una ŋanna, ba kelaa maà jarammeje antara mukse aà egdze a emmeŋaara ŋanna waà, maà aà sawa yawe aà vuwaara waà, aà puwana aà ba aà dem haha. Aɗaba wayaaka fana wakyiya ge egdze a emmeŋaara na. ");
INSERT INTO mfi_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Nazena a maganaa ŋane ŋanna keni maàndzawe jipu am ice aà Yaakadada, a jehe ge Yaakadada ŋane keni ba shifaara. ");
INSERT INTO mfi_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","A ba Yahuuda aà elvan ge shawlaara Tamar : Ezlzlala, de njinja am mba aà eddeŋa ba seke mukse wegyegye dem sarte na maà Sailaaruwa gevge zhele. Ane, a ba Tamar, a naba de nja am mba aà eddeŋaara na. Mbate a banaa una ŋanna Yahuuda na waà, aɗaba aà ba sla aà iraara, a emtseka Saila keni seke egdzar mamahaŋaara. ");
INSERT INTO mfi_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Haraahare ba ŋgaa am iga a una ŋanna maa, a naba emtsehe ge egdze aà Su`a mukse aà Yahuuda. Am iga a mandzawe ŋanna, Yahuuda a dem Timna, ta zlala antara uraara Hira, ura Adaulam, a deza emnde a ɗatsa uàgje ate kyawahaara. ");
INSERT INTO mfi_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Cenancena Tamar ganakini aŋkwa aà sawa shawlaara Yahuuda, aà dem Timna, aà de ica uàgje ate kyawahaara. ");
INSERT INTO mfi_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","A naba tsekwese am naŋgyuwe aà mukse na a keɗaa zhelaara, a eksataa laafaya a puwerhe, a ƴan ba cekwaaŋgweɗei wafkaara agashe a de njehe ate we aà walkame aà ekse aà Ainayim ate barama a dem Timna. Aɗaba a naa Saila waltewala amaà ŋane gevka muksaara, Saila gevge tsa zhele. ");
INSERT INTO mfi_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","De damda Yahuuda aàzeŋaara, ŋane a kurken ba mukse zaware aɗaba a ƴan ba cekwaaŋguɗi wafkaara a gashe. ");
INSERT INTO mfi_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","A naba cikante aà duhe aà dezeŋaara. A ba ŋane aà elvan ge ŋane: Wayanakwaya ge kaà hyiyanvehye wederaaruwa. Diseka ŋane ɗekiɗeki ganakini una ŋanna sawlaara. Ane, a ba Tamar, amaà kaà vite uwe? ");
INSERT INTO mfi_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","A eptsanaa jawapa, a ba ŋane aà elvan ge ŋane : Watse yaà ɓela ura aàsezeŋa an usale aà sawa am waldaaruwa. Shagera, aà ba Tamar, amaà waà, sey kaà tsekwinaatsekwa dukse umele, dem sarte na maà samsa usale na. ");
INSERT INTO mfi_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","A ba Yahuuda aà elvan ge ŋane: Kaà kata yaà tsekwaka uwe? A ba mukse na : Kaà tsekwiya daàmshaaŋa na zheraaŋa an puwa atekwa na antara zawaaŋa baɗemme ira zadaaŋa na am erva na. Kwalaaka Yahuuda, a naba vante. Mazlaara a de hyananve wederaara, a naba shaa huɗe mukse na an ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Mazlaara a tsetehe ge Tamar, ba ezlzlalaara, a de puwanve laafaya na, a tsekweme am naŋgyuwe aà mukse mandzawe adaliye. ");
INSERT INTO mfi_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yahuuda a de ɓela usale na ate erva an uraara, ura Adulam na geni ŋane aà sanan ge Tamar, aà lyanvalya kazlaŋaara na a tsekwanna ŋane ge mukse ŋanna, amaà se beƴeka uraara mukse na. ");
INSERT INTO mfi_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","AÀ enndava aàza emnde a ekse, a ba ŋane: Ama mukse zaware na ndza aà nja ate barama aà Enayim na? Emnde ta eptsanaa jawapa: ɓaaka mukse zaware aàhuna. ");
INSERT INTO mfi_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","A eptsehe aàdeza Yahuuda, a ba ŋane : Shananka ya mukse na. Emnde a ekse keni ta biyaa ɓaaka mukse zaware aàhuna. ");
INSERT INTO mfi_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","A ba Yahuuda : Naba ƴanya a ŋanaaŋa ŋane kazlaŋa ŋanna, famika iraamiya aà dem zherwe ba dey. Aàbi ya eɓɓela ŋane usale ŋanna, shakanka aà ba an sha. ");
INSERT INTO mfi_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Tere keƴe am iga aà una ŋanna waà, ta sanaa labare ge Yahuuda, a ba itare taà elvan ge ŋane: Naàwa shawlaaŋa Tamar a magaa gwardzire, a naba shaa huɗe am zawarire. A ba Yahuuda : A daransede aàdete iga aà ekse, a deraraadera an kara. ");
INSERT INTO mfi_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Am sarte na taà aŋkwa aà danda Tamar aàdete iga a ekse, a naba ɓela ura an duksaha na aà deza shawlaara Yahuuda, a ba ŋane aà elvan ge ŋane : Una kazlaŋa aà eddawa ni a lyiyam huɗe na. Taslaaŋa zharanaazhara ba shagera mu daàmshe na antara zawaara ira zhera na ate damshe ŋanna mu naàza ware? Antara zade na zade aà ware? ");
INSERT INTO mfi_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yahuuda diyeddiye kazlaŋaara, a ba ŋane: Slejirire ba ŋane arge iya. Aɗaba vananteka ge egdzaaruwa Saila geni aà gevge muksaara. Ba ser palle keni zlavareka kerɗe seke tara zhele an mukse. ");
INSERT INTO mfi_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Hyephye sarte a yaara waà, huɗe aà Tamar ŋanna mbate wulhaha. ");
INSERT INTO mfi_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Egdzere palle a velese ervaara, mukse sleya Tamar na a ŋanaahe, a ŋguɗante sluzhe kyaŋŋe atekwa, a ba ŋane: A segasha ŋane zuŋŋwe. ");
INSERT INTO mfi_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Amaà a naba danmehe ervaara adaliye, a segashe egdze a emmeŋaara zuŋŋwe arge ŋane. A ba sleyaà Tamar: Kay! takaata ka barama. Ta fete zheraara: Te. ");
INSERT INTO mfi_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Am igaara, a sawa una an sluzhe kyaŋŋwe ate erva na, ŋane ta fete zheraara Jaara. ");
INSERT INTO mfi_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Emnde aà Isemayiilu daranda Yusufa aà dem larde aà Misera, ta de velanu ge ura Misera umele zheraara Pautifar. Zhel ŋanna keni nakawa ƴaikke, ŋane male aà emnde a ufa sleksu Firawna. ");
INSERT INTO mfi_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Amaà aŋkwa Yaakadada antara Yusufa. Naàzena ni a maganaa ŋane, ɓaaka gavkaara, aŋkwa aà njaara laŋŋe am huɗe aà haà aà zanwaara ura Misera. ");
INSERT INTO mfi_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ba zanwaara keni diyeddiye ganakini aŋkwa Yaakadada antara ŋane. Yaakadada aŋkwa aà gaà barka am slera aà Yusufa. ");
INSERT INTO mfi_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Aɗaba una ŋanna, Pautifar hayanhaya Yusufa jipu, a naba vante slera na ni ɓaaka argina ɗekiɗeki na, a fanem huɗe aà haara antara naàzena am rezegaara baɗemme am erva ge Yusufa. ");
INSERT INTO mfi_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Fantau am sarte ŋanna Pautifar a fanem haara, an naàzena am rezegaara baɗemme am erva ge Yusufa na waà, Yaakadada garge barka an tsaka ire ga haà zhel Misera ŋanna aɗaba barka Yusufa. Barka aà Yaakadada waà, shansha zhel ŋanna aà setarge naàzena am ervaara baɗemme, arge una am mba antara una an fe keni baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Aɗaba una ŋanna, Pautifar a fanem naàzu am rezegaara baɗemme am erva ge Yusufa, ŋane sey aà zhara ba una aà fana aà dem mbuwaara palle. Yusufa ŋanna maa, dawale, garlaka zlaɓe adaliye, an zariyire keni ɓaaka arge ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Haraare cekwaaŋguɗi waà, damda ice aà mukse aà edda haà am Yusufa. A ba ŋane aà elvan ge Yusufa : Sawa ŋa zlava kerɗe seke tara zhele an mukse. ");
INSERT INTO mfi_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Amaà kwalefkwale Yusufa, a ba ŋane aà elvan ge mukse aà zanwaara: Una aà tsa gevka ɗekiɗeki. Zanwaaruwa a fiyem haara baɗemme am erva, ŋane sey aà zhara ba una aà fana aà dem mbuwaara palle, baɗemme a naàzena am rezegaara aà ba am ervaaruwa, ");
INSERT INTO mfi_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ura aà jiyuje am huɗe aà haà na keni ɓaaka, hakuma baɗemme aà ba am ervaaruwa, aàbi ɓaaka naàzu a piyitaa zanwaaruwa am huɗe aà ha na ɗekiɗeki maàki ekka ka, aɗaba ka muksaara? Yaà magana estara haypa saksage na an Dadaamiya? ");
INSERT INTO mfi_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Amaà mukse na ƴanka ndahan elva a maàme ɗekiɗeki ge Yusufa, una ba kelaazare kwalarkwale Yusufa ge zlava antara ŋane seke tara zhele an mukse na, ba ge nja aàzeŋaara keni. ");
INSERT INTO mfi_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Vacite umele maa, damda Yusufa am huɗe aà haà, emnde a haà keni ba ura palle, ta ɓaaka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Mukse na a naba eksevaa Yusufa ate zane, a ba ŋane aà elvan ge ŋane: Sey kaà zlaviyuzlave. Yusufa a naba ƴanaa zane ŋanna am erva, a zhagadaa iraara aàsegashe. ");
INSERT INTO mfi_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","A ezhzhara mukse na Yusufa a ƴanaa zane am erva, zhagadaazhagade iraara waà, ");
INSERT INTO mfi_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","a naba ɗetaa emnde a haà, a ba ŋane aà elvan ge itare: Zharauzhara palasa na aà magina eddemiya na. A naba saa zhel emnde aà Ibrahiima na aà sem huɗe aà haà, naàwa a se diyar ge iya sey ba ŋa nja kerɗe aàbina, hula ge iya aà ba an ndzeɗa lauktu a ƴihe. ");
INSERT INTO mfi_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","AÀ ezhzhara ya kante kwara, yaà hula aà ba an ndzeɗa waà, a naba zhagadaa iraara aàdegashe, naàwa a ƴaa zanaara aà puwa aàtevege iya. ");
INSERT INTO mfi_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","A naba sheɓanve zane aà Yusufa na, saasa eddetare, a se marananhe. ");
INSERT INTO mfi_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","A tsakanse elva ŋanna, a ba ŋane: Naàwa nave, zhel emnde aà Ibrahiima na ka saŋerta ka na a naba se diyar ge iya a se nyamalinyamala. ");
INSERT INTO mfi_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ya naba kante kwara ya, ya fu hula, lauktu a zhagadaa iraara aàdegashe, naàwa a ƴaa zanaara aàtevege iya. ");
INSERT INTO mfi_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Zanwe aà Yusufa ba a cenaa elva ŋanna am mbuwe aà muksaara geni a nyamalinyamala na waà, a naba mberte ge ervauŋɗaara waà, ba seke kara ndza. ");
INSERT INTO mfi_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","A naba eksevaa Yusufa, a elbyanme am daŋgay, baira ta de ŋgweɗana aà ba am tate na ni taà an ŋgwaɗa daŋgayaha aà slekse aàtekwa na. Daaci a njaara Yusufa am daŋgay. ");
INSERT INTO mfi_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","A ba am daŋgay ŋanna keni aŋkwa Yaakadada antara Yusufa. A maganaa ŋgurna, male aà daŋgay ŋanna de hayanhaya Yusufa jipu. ");
INSERT INTO mfi_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ŋane keni a de fanem daŋgayaha umele baɗemme am erva ge Yusufa. Sleraha na ta magana am daŋgay na baɗemme aà ba am ervaara. ");
INSERT INTO mfi_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Baaka lambaara ɗekiɗeki ge male aà daŋgay ate slera na a fanem am erva ge Yusufa na. Aɗaba aŋkwa Yaakadada antara ŋane, slera na aŋkwa aà magana ŋane baɗemme an barka. ");
INSERT INTO mfi_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Haraare cekwaaŋguɗi am iga aà labare ŋanna maa, male aà emnde a magana naàza sha antara male aà gyan naàza zaha ge sleksu Firawna, garuge haypa an zanwaatare. ");
INSERT INTO mfi_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Jaaja ervauŋɗe slekse ate emnde a sleraara ŋanna, ");
INSERT INTO mfi_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","a naba puwateremhe am daŋgay. Am daŋgay ŋanna maa, ta ŋgwaɗateraa am tate na ni atekwa Yusufa na. ");
INSERT INTO mfi_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Daaci male aà daŋgayaha a puwaterem am erva ge Yusufa, de hararaahare aàhuwa cekwaaŋguɗi. ");
INSERT INTO mfi_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","An vaƴiya vacite umele, male aà emnde a maganaa naàze sha antara male aà emnde a gyan naàza za ge slekse sharansha shene bukerɗaatare aà ba am daŋgay ŋanna. Shenahaatare ŋanna waà, ma naàza aà waraatare keni aŋkwa manaara. ");
INSERT INTO mfi_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Samsa Yusufa aàsezetare an eŋlya waà, aà zharaterzhara ma ware keni ɓaaka higaatare ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","A ba ŋane aà elvan ge itare: Labara parakparakeka fekaakure vatena? ");
INSERT INTO mfi_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ta eptsanaa jawapa, a ba itare: An vaƴiya vatena, ma waraaŋere keni shansha shene, amaà ɓaaka ura aàhuna ge palaŋera maàna aà shenahaaŋere. A ba Yusufa : Estuwa ka, maànaha aà duksa waà, aà ba aàza Dadaamiya, naba ndaawindaha! ");
INSERT INTO mfi_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Male aà emnde a maga naàza sha a naba ndahanhe shenaara ge Yusufa, a ba ŋane: Am shenaaruwa, ya naa mama aà nafa aà inabauhi aà katafkaaruwa, ");
INSERT INTO mfi_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ervaha keƴe atekwa. Ya naa ba ƴaaƴa nafa na, a magaa ukbene, kerteŋ egdzere ndaceɓaire atekwa, an naha kyaŋŋe. ");
INSERT INTO mfi_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Naàza sha duksa aà sleksu Firawna keni aà ba am ervaaruwa, ya tsakevaa egdzar a inabauhi na, ya ɓeca yawaara, ya vante ge slekse. ");
INSERT INTO mfi_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","A ba Yusufa aà elvan ge ŋane : Naàwa maana aà shenaaŋa: ervaha aà nafa aà inabauhi keƴe na waà, aà mara hare keƴe. ");
INSERT INTO mfi_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Am hare keƴe, watse aà ndavakndava sleksu Firawna, aà de eptsaka aà dem sleraaŋa, kaà de vanta ka naàza sha am erva ba seke una ndza na. ");
INSERT INTO mfi_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Amaà taslaaŋa viyiyaaka. Maà shakansha hairire waà, yehiteyeha aàkatafke aà slekse magiyanmaga shagerire sisese am bere na. ");
INSERT INTO mfi_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Aɗaba aàsawa am haha aà emnde a Ibrahiima keni ta siyan aà ba an ndzeɗa beresse. Naàwa aàhuna keni ɓaaka nazu ya guwaa ya ta ŋguɗiyaa aɗaba ŋane na. ");
INSERT INTO mfi_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Male aà emnde a gya naàza za gergere am mba aà slekse cenancena ganakini Yusufa palannaapala maana aà shenaara shagera ge male emnde a maga naàza sha am mba aà sleksu Firawna. A ba ŋane aà elvan ge Yusufa : Iya keni naàwa shenaaruwa: Am shenaaruwa waà, yaà an kendayaha gergere keƴe an nyaŋa am iraaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Am kendayaha ŋanna waà, am una adetire caikcaike na waà, aŋkwa naàza zaha aà sleksu Firawna gergere am huɗaara. Amaà ta naba halese ge ƴiyaha aà ba am iraaruwa ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","A ba Yusufa aà elvan ge ŋane: Naàwa maana aà shenaaŋa ekka keni: Kendayaha ŋanna keƴe na waà, amaana hare keƴe. ");
INSERT INTO mfi_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Am hare keƴe watse aà ɗahaka slekse, amaà taà de zleŋelaka ate nafa, taà de zaka ba kuyaha. ");
INSERT INTO mfi_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Am hare ge keƴire waà, sleksu Firawna a magaa muŋri, a jemaa nakawahaara baɗemme ge za muŋri na. Daaci ta sanaa male aà emnde magana naàza sha antara male aà emnde aà maganaa naàza za gergere na, a tsatsateraa aàkatafke aà emnde a maàga sleraara baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","A eptsaa male aà emnde a maganaa naàza sha aà dem sleɗaara geni aà vanta ŋane naàza sha am erva ba seke una werre na. ");
INSERT INTO mfi_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Amaà male aà emnde a maganaa naàza zaha na waà, a naba ndaasse elvaara ate ŋane geni a zleŋelarzleŋela. Daada aà ba ate una a ndahanaa Yusufa na kalkale. ");
INSERT INTO mfi_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Amaà male aà emnde a maganaa naàza sha ge slekse na dzamaaka Yusufa ɗekiɗeki, a naba viyanaahe. ");
INSERT INTO mfi_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Magaamaga yawe buwa am iga a una ŋanna waà, Sleksu Firawna a naba shaa shene. Am shenaara ŋanna waà, ŋane aà tse ate we aà haye, ");
INSERT INTO mfi_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","a naa ba saresse eslaha vuye, zariyiraatare keni ba ka ɗuhe, taà an ŋasla zlaɓe adaliye, taà aŋkwa aà za masa ate we aà haye na. ");
INSERT INTO mfi_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","A ba am haye ŋanna, ta sessehe zlaɓe adaliye ge eslaha umele vuye, emnde ŋanna waà, ta shagerkaha ba vayvaya, taà an uŋɓa zlaɓe adaliye. Ta de tsahe aàza emnde na ta segasha itare zuŋŋwe am haye na. ");
INSERT INTO mfi_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Eslaha na ta shagerkaha, taà an uŋɓa zlaɓe adaliye na, ta naba zu eslaha na ni ta zariyaha, taà an ŋasla zlaɓe adaliye na. Daaci a tsetehe ge Firawna am hare. ");
INSERT INTO mfi_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","A pu hare adaliye, a naba shaa shene umele ge buwire. Am shenaara ŋanna, a naa iraha aà nalkame vuye, an naha shagera, saɗaɗɗe zlaɓe adaliye, ate naàzambakara palle. ");
INSERT INTO mfi_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","AÀ ba ate nazambakara ŋanna, a sesehe ge iraha aà nalkame umele vuye waà, ɓaaka egdzere atekwa shakwatarshakwatare, an ula zlaɓe adaliye, a welansaa effeƴa, aɗaba kwakya effeƴa aà sawa am geɗi. ");
INSERT INTO mfi_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Iraha aà nalkame na ɓaaka egdzere atekwa shakwatarshakwatare na ta naba ndandu iraha aà nalkame na an naba shagera, saɗaɗɗe zlaɓe aà adaliye na. A tsetehe ge sleksu Firawna am hare waà, mbate ba shene. ");
INSERT INTO mfi_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Werawera ekse waà, jaaja eŋkale aà sleksu Firawna. A naba ɗante emnde a maga namsulkwaha antara emnde a ilmu na taà am Misera baɗemme. Daaci a tsakaterse zlalava a shenahaara, amaà ɓaaka ura a dzegwandzegwa palanna maana aà shenaha ŋanna ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","De cenancena male aà emnde a maganaa naàza sha ge slekse, a ba ŋane aà elvan ge Firawna: Ambarka aà slekse, vatena waà, sey yaà yeheteyeha haypaha na ndza ya maganaa ya na baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Aŋkwa am sarte umele, ndza jakja ervauŋɗe jipu ate emnde a sleraaŋa buwa, ate ŋere antara male aà emnde magakaa naàza za. Ka naba puwaŋeremhe am daŋgay, ŋa za daŋgay aà ŋere am bere na ni aà ufana ba male aà emnde a ufa daŋgayaha ŋanna an iraara. ");
INSERT INTO mfi_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Vacite umele an vaƴiya, ŋa naba shaa shene ma waraaŋere keni. Ma shene aà ware keni an maanaara ba ge iraara. ");
INSERT INTO mfi_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ay am daŋgay ŋanna maa, aŋkwa ura, zhel emnde aà Ibrahiima, ŋane nave aà male aà sawjiyaha aà ufa daŋgay ŋanna. ŋa tsakanse shenahaaŋere ge ŋane, a palaŋeraa maanahaara baɗemme, ma waraaŋere keni an maana aà shenaara. ");
INSERT INTO mfi_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ba jirire gevge aà ba ate una a palaŋernaa ŋane, dzalevka ɗekiɗeki. Aɗaba naàwa iya, ka naba eptsiyaa aà sem sleɗaaruwa adaliye aàmbarkaaŋa, amaà male aà emnde a magakaa naàza za waà, ka ndaase elvaaŋa, ta zleŋelehe. ");
INSERT INTO mfi_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Daaci a ba sleksu Firawna a sairiyansa Yusufa. Kerteŋ saransese Yusufa am daŋgay na. A sehese ire, a barevhe, a tsekweme am naŋgyuwe umele a naba deza slekse na. ");
INSERT INTO mfi_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","A ba sleksu Firawna aà elvan ge Yusufa: Ya hare am shene, amaà ɓaaka ura dzegwandzegwa paliya maana aà shenaaruwa ŋanna. Ya cenancena geni ekka kaà dzegwandzegwa pala maana aà shene maà ndarakndaha zlalavaara. Ya ɗahaka aɗaba una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","A ŋwanante ge Yusufa, a ba ŋane aà elvan ge sleksu Firawna: Iya ka aàmbarkaaŋa. AÀ de vakta ba Dadaamiya jawapa na ni kaà hayanhaya na. ");
INSERT INTO mfi_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Daaci a ba sleksu Firawna aà elvan ge Yusufa: Am shenaaruwa, ba seke yaà ate we aà haye, ");
INSERT INTO mfi_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ya naa ba eslaha vuye, zariyiraatare ba ka ɗuhe, taà an ŋasla adaliye, ta segashe am guwa ŋanna, taà aŋkwa aà za masa ate we aà guwa. ");
INSERT INTO mfi_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Am iga aà emnde ŋanna maa, ta ɗabateremhe ge eslaha umele vuye, ta segashe aà ba am haye ŋanna, ta shagerkaha ɗekiɗeki, taà an uŋɓa zlaɓe adaliye. Nananka eslaha shagerkaha seka una ŋanna am haha aà Misera baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Amaà slaha ŋanna shagerkaha na, ta naba zu slaha na ta segashe zuŋŋwe am guwa, zariyaha, taà an ŋasla jipu na vuye baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Aley, am iga aà ba ta zu emnde na taà an ŋasla dakeɗar dakeɗare ŋanna keni, ɗekiɗeki kaà tsa banka ni ta zuwa itare. Aɗaba ba kelaa njaatare ŋanna ta shagerkaha na, taà an uŋɓa zlaɓe adaliye na. Am iga aà una ŋanna, tsanetse am hare. ");
INSERT INTO mfi_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ya shaa shene umele zlaɓe adaliye, ya naa iraha aà nalkame vuye, an naha shagera, saɗaɗɗe zlaɓe adaliye ate nazambakara palle. ");
INSERT INTO mfi_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","A ba ate nazambakara ŋanna, a naba sesehe ge iraha aà nalkame umele vuye waà, ɓaaka egdzere atekwa sakwatarsakwatare ba dey, an ula zlaɓe adaliye, a welansa effeƴa, aɗaba kwakya effeƴa aà sawa am geɗi. ");
INSERT INTO mfi_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Iraha aà nalkame na ɓaaka egdzere aàtekwa na, ta naba ndandu iraha aà nalkame vuye na an naha shagera, saɗaɗɗe zlaɓe adaliye na. Ya ndaterhe zlalava aà shenahaaruwa ŋanna ge emnde a maga namsulkwe, amaà ɓaaka ura dzegwandzegwa paliyaa maanaara ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","A ŋwanante ge Yusufa, a ba ŋane aà elvan ge sleksu Firawna: Shenahaaŋa na waà, maanaara ba palle aàmbarkaaŋa. Dadaamiya aŋkwa aà ŋgyekwakaa naàzu watse aà magana ŋane aàkatafke. ");
INSERT INTO mfi_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Eslaha vuye na ta zariyaha, taà an ŋasla zlaɓe adaliye na waà, amaana yawe vuye, iraha aà nalkame vuye na an naha shagera, saɗaɗɗe zlaɓe adaliye na keni ba yawe vuye ŋanna. Shenaha ŋanna ba duksa palle. ");
INSERT INTO mfi_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Eslaha vuye na ta sawa aàkataliya, ta shagerkaha, taà an uŋɓa zlaɓe adaliye na keni maa, amaana yawe vuye. Iraha aà nalkame vuye na ɓaaka egdzere atekwa, ɗekiɗeki, mele keni an ula zlaɓe adaliye, a welansaa effeƴa na a sawa am geɗi na keni maa, ba yawe vuye ŋanna zlaɓe adaliye. Watse aŋkwa waya am yawe vuye. ");
INSERT INTO mfi_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Daaci ba seke una ya ndakndaha na aàmbarkaaŋa waà, Dadaamiya aŋkwa aà ndak nazena watse aà magana ŋane aàkatafke. ");
INSERT INTO mfi_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Am ivaha vuye na aà de sawa na waà, watse ɓaaka zlakta aà naàza za am haha aà Misera baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Amaà am iga aà una ŋanna waà, aà de sawa waya ƴaikke aà sem larde aà Misera baɗemme, una ŋanna keni yawe vuye zlaɓe adaliye. Watse emnde taà de zlanaazle ndzeɗa aà larde. ");
INSERT INTO mfi_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ivaha na ndza ɓaaka zlakta aà naàza za am huɗaara na taà de viyanaaviya emnde baɗemme. Aɗaba waya ŋanna watse zlazlaɗa jipu. ");
INSERT INTO mfi_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Elva aà shenahaaŋa ŋanna, buwa aà ba aàtekwa aàtekwa na maa, amaana: Dadaamiya njantenja aàzeŋaara, watse a shekwaaka mazlaara. ");
INSERT INTO mfi_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ambarkaaŋa, naàzena kaà magana ka kina waà, naba tatayevaatataya ura, vanteva hakuma ate larde aà Misera baɗemme, amaà waà sey edda aà eŋkale, aŋkwa ilmu aàzeŋaara na. ");
INSERT INTO mfi_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Farfe zlaɓe adaliye ge kezlakula aà emnde a ufa larde, taà de jahana itare naàza za am larde a Misera baɗemme. Am duksa ilyeɓe, itare taà de eksa palle. Taà de magan ba estuwa am yawe vuye na ni watse aŋkwa naàza za na. ");
INSERT INTO mfi_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","A jaranmejahe naàza sa am huɗe aà Misera baɗemme am iyaha na watse aŋkwa naàza za am huɗaara na. Amaà waà, an hakuma na kaà de vaterta ka. A jaranmejahe naàza za am eksaha baɗemme, watse taà ŋaà emnde an ŋane, a faranufe hyema ba ŋgaa. ");
INSERT INTO mfi_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Daaci watse aŋkwa naàza za am larde aà Misera ge zana am waya aà iva vuye na. Daaci estuwa, waya ŋanna aà de zlanaaka ndzeɗa aà larde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Elva ŋanna hayanhaya Firawna antara emndaara baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","A ba Firawna aà elvan ge emndaara: Maà de sha ware mazlaara seke dawale na nawa ŋane na, ura aŋkwa Sheɗekwe aà Dadaamiya antara ŋane? ");
INSERT INTO mfi_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Daaci a ba ŋane aà elvan ge Yusufa: Tsante aà ba am sarte na ni Dadaamiya a kwarakse duksaha ŋanna waà, ba ka ŋanna. ŋaà shanka edda aà eŋkale umele an ilmu seke ekka. ");
INSERT INTO mfi_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ka eddaara ba ka. Huɗe aà haaruwa antara lardaaruwa baɗemme aà ba am ervaaŋa kina. Sey taà ɗaba ba nazena ka ndaasa ka. ɓaaka ura umele arge ekka ɗekiɗeki, yaà jakuwa aà ba an kurshi aà sleksire palle. ");
INSERT INTO mfi_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","A fanarhe zlaɓe adaliye, a ba ŋane aà elvan ge Yusufa: Kwaye vanakteva hakuma ate larde aà Misera baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Daaci a naba seɗaa jaɗe ate ervaara, a fante ate erva ge Yusufa, a tsekwanme am zane lefeɗɗire ba ka ɗuhe, a ŋguɗanem naberasla aà dindar am mbiye. ");
INSERT INTO mfi_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Daaci a naba njanme am darkwaara aà teɗana belsa. Darkwa ŋanna waà, naàza aà sleɗaba aà slekse. Daaci hula ge emnde a ɗaba Firawna aà katafke aà Yusufa na, a ba itare am hulaatare: Baraàma, baraàma, baraàma! A vante estuwa Firawna hakuma ge Yusufa am larde aà Misera baɗemme, ŋane a gev wanziriyaara. ");
INSERT INTO mfi_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","A ba ŋane zlaɓe adaliye aà elvan ge Yusufa: Ma ware eddaara keni, a gejeka seraara, a gejeka vuwaara ɗekiɗeki ge maga duksa am larde a Misera baɗemme, maàki ndakseka ka elva. Ya ndahanaa ya Firawna una! ");
INSERT INTO mfi_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","A eptsanante zhera ge Yusufa, a fete zheraara Jafnat Panaiyak. A eksanante gyaale zheraara Asnat, egdze aà Pautifaira, liman am ekse aà Aun. Mazlaara a naba degashe. Yusufa, a jem ɗaba am haha aà Misera baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusufa magaamaga iva kul keƴe kalkale am sarte na aà dem slera aà ŋgumna aà Misera baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Am ivaha vuye ŋanna waà, haha magaamaga jipu duksa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yusufa a janme naàza za an tsaka ire am Misera am ivaha vuye ŋanna. A janme naàza za ŋanna am eksaha gergere kwakya. Ekse na maà fafa Yusufa geni aà jaha naàza za am huɗaara, emnde a makwata na taà herɗa am kwara ŋanna taà jaha naàza za na aàdehuwa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Daaci Yusufa a jemaa naàza za ɓaaka zlaktaara, ba seke shili na am guwa na. ƴaranƴe ba ɗekiɗeki tataya kezlakulaara, aɗaba aà kezlaveka kwakya jipu. ");
INSERT INTO mfi_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Lauktu ni aà sawa waya ŋanna waà, Yusufa yaya egdzara buwa, egdzar zaala. A yanaa an Asnat egdze aà Pautifaira liman am Aun. ");
INSERT INTO mfi_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusufa a fete zhera aà egdzaara ge zuŋŋwire: Manasa. Aɗaba a bantsa ŋane: Dadaamiya viyinaaviya zlaɗahaaruwa baɗemme antara tega na ta naba tegaŋeraahe antara haà edderwa na. ");
INSERT INTO mfi_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Egdzaara ge buwire, a fete zheraa: Afrayim. Aɗaba a bantsa ŋane zlaɓe adaliye: Dadaamiya a vite ya am larde na ni a siyaa palasa aà sem huɗaara. ");
INSERT INTO mfi_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Daaci emnde ta magaa yawe vuye am emtakire am haha aà Misera baɗemme mazlaara a naba zluhe ge emtakire ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Am iga aà una ŋanna maa, a de semhe ge waya ƴaikke waà, yawe vuye emnde taà aà ba am waya ŋanna ba seke una a ndahaanaa Yusufa na. Waya maganaamaga hukumaara am duniya baɗemme, amaà am Misera waà, aŋkwa naàza za. ");
INSERT INTO mfi_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Am sarte na ŋateraŋa waya emnde am larde aà Misera, ta daa kyuwaatare aà deza Firawna. Amaà a ba ŋane aà elvan ge itare: Zlauzlaala aà deza Yusufa, magaumaga nazena a fakurara ŋane baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Am jetaaveje larde baɗemme ɓaaka tata na ni ɓaaka waya am huɗaara, Yusufa a naba werante magazaŋaha, a fantau ge velateru naàza za ge emnde a Misera baɗemme, aɗaba waya ŋanna jauje ge ndzeɗa aà emnde. ");
INSERT INTO mfi_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Gevge waà, taà aŋkwa aà sawa, emnde aà sawa am lardaha gergere kwakya, taà se shekwa hiya aàza Yusufa am larde a Misera. Aɗaba waya ŋanna aŋkwa aà magatera palasa jipu ge emnde ma am lardara keni. ");
INSERT INTO mfi_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Daaci cenancena Yakubu ganakini aŋkwa naàza za am larde aà Misera. A ba ŋane aà elvan ge egdzaraara : Labara kwaà geƴa aàzharava aà dem ice am ice, aàzara payɗaara? ");
INSERT INTO mfi_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nawa ya cenancena ganakini aŋkwa naàza za am larde a Misera waà, daumbare de shekwawamiyepshekwe, a ceɓamika waya ba dey. ");
INSERT INTO mfi_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Daaci daredde egdzar mamahaŋaara ge Yusufa, ta kelaawa, taà de shekwa naàza za am larde a Misera na. ");
INSERT INTO mfi_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Amaà Bainjamaiŋ pale aà egdzar mamahaŋaara ge Yusufa ŋanna waà, ɓelaterteka eddetare, aɗaba a bantsa ŋane: A de shanka lamare umele aàhuwa. ");
INSERT INTO mfi_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","A sawa estuwa, lauktu ta sawhe ge egdzara aà Iserayiila antara emnde a Kanaana umele ge se shekwa naàza za am Misera, aɗaba aŋkwa waya am Kanaana. ");
INSERT INTO mfi_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ay, am Misera na, hakuma baɗemme aà ba am erva aà Yusufa. AÀ velaterwa ba ŋane naàza za ŋanna ma ge emnde a lardara keni. Saremsa egdzar mamahaŋaara aà se katafkaara, ta naba kezlan ugje wafkaatare ba teppe ate haha. ");
INSERT INTO mfi_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","A zharateraahe waà, a naba diyatereddiye, amaà waà, mbeɗateruka geni ŋane egdze a emmetare. A naba marateraa ƴaikkire, a ba ŋane aà elvan ge itare aà valaha: Kwa sawa ame kure? Ta eptsanaa jawapa emnde na, a ba itare: ŋa sawa am Kanaana, ŋa se shekwa naàza za. ");
INSERT INTO mfi_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusufa diyeddiye egdzar mamahaŋaara, amaà itare waà, diyarseka Yusufa ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Daaci Yusufa a naba yehete shenaha na ndza a shanaa ŋane aà dete itare na, a ba ŋane aà elvan ge itare: Baira ɗeme kure kwa kelaadaha ta ɓelakura an ɓela, kwa se zhara larde, kwaà kata dise tate na ni ɓaaka payɗa aà emnde atekwa na. ");
INSERT INTO mfi_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ta eptsanaa jawapa, a ba itare: Estuweka aàmbarkaaŋa. Naàvahaaŋa ta se shekwa ba naàza za. ");
INSERT INTO mfi_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","A ba itare zlaɓe adaliye: ŋere baɗemme ŋa ba egdzara aà zhel palle, ŋa emnde a jirire, ŋa kelaadaha ka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","A ba Yusufa aà elvan ge itare: Eksanarka ya elvaakure na ɗekiɗeki, kwa se zhara ba larde, kwa kata dise tate na tsaftsafe na. ");
INSERT INTO mfi_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ta ŋwanante, a ba itare: Ba jirire, ŋere ŋa ba egdzara aà zhel palle am Kanaana aàmbarkaaŋa. ŋa navahaaŋa ndza ŋa kelaawa ju buwa ate eddeŋere, gaajiyaaŋere waà, aŋkwa am mba antara eddeŋere, amaà pallaaŋere waà, ŋane a keɗa werre. ");
INSERT INTO mfi_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","A ba Yusufa aà elvan ge itare: Aàbi ya ndakurndaha ya, kure waà, ɓaaka shaigaara ɗekiɗeki ta ɓelakura aà ba an ɓela, kwa se zhara ba larde. ");
INSERT INTO mfi_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ba maàki kwa kelaadaha ka tsawe waà, mi ezhzhara kwa: Yaà zakuru ba waɗa an shifa aà sleksu Firawna, kure kwaà deska aàhuna ɗekiɗeki maà samka gaajiyaakure na. ");
INSERT INTO mfi_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","A ezlzlala pallaakure emnde umele waà, sey kwaà demda am bere aàhuna, yaà zhara, tara kwa emnde a jirire an kwa emnde a fida keni. Ay ka waà, kwaye Firawna an shifaara maàki kwa kelaadaha ka. ");
INSERT INTO mfi_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","A naba puwateremhe am daŋgay baɗemmaatare, hare keƴe taà am bere na. ");
INSERT INTO mfi_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Am hare ge keƴire ŋanna waà, a ba Yusufa aà elvan ge itare: Iya keni aà wiwa lyawa atuge Dadaamiya. Maà wayakurwaya an shifaakure waà, naàwa nazu kwa de magana kure: ");
INSERT INTO mfi_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Maàki ba kwa emnde a jirire waà, ƴawanƴa pallaakure am daŋgay aàhuna, amaà kure emnde umele waà, dawanda naàza za aà dem mba, aɗaba aŋkwa waya am mbaakure. ");
INSERT INTO mfi_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ama waà, sey kwaà siya gaajiyaakure na kwa ƴanaa am mba na, geni yaà diyeddiye jiriraakure, a keɗeka shifaakure keni. Daaci ta naba ekserhe. ");
INSERT INTO mfi_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Am dagavaatare waà, ta fantau ge tsaka elva, a ba itare: Una waà, ɓaaka shaigaara ɗekiɗeki aà jaŋera ba haypa ƴaikke na ŋa guwaa an egdze a emmemiya na. Aɗaba ŋa nanna palasa na a maganaa ŋane, a ŋalaŋeru zevarzire, amaà zaŋeranvaareka ɗekiɗeki. Daaci kwaye palasa ŋanna a eptsamiyar ge miya vatena. ");
INSERT INTO mfi_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","A ba Rubain aà elvan ge itare : Aàbi ndza ya ndakundaha a ba iya magauka jeba haypa saksage na an egdzere, amaà cenakurka. Kwaye Dadaamiya aŋkwa aà ndavamiyu uzhaara vatena. ");
INSERT INTO mfi_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Itare diyarka ɗekiɗeki ganakini aŋkwa aà cenancena Yusufa elva na taà aŋkwa aà tsakana itare na, aɗaba aŋkwa turjuman am dagavaatare. ");
INSERT INTO mfi_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","A eptsaterve iga Yusufa, a zlalehe aàzetare waà, a de kyuwa. Am igaara, a naba eptsa aàsezetare, a se mbeɗateru elvaara, a eksevaa pallaatare zheraara Simaun, a naba puwete zawa ate ŋane aà ba ate icaatare, a ɓeleme am daŋgay. ");
INSERT INTO mfi_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","A naba ndaase elvaara Yusufa, geni a varaterteva naàza za am kayawahaatare, a puwaraterempuwa antara shuŋguwahaatare am kayawahaatare, a varaterteva antara kazlaŋa aà waya ge maga shulaatare an ŋane. Ta magateraa una ŋanna baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Mazlaara egdzar mamahaŋaara ta puwete kazlaŋaatare ate iga aà ezzeŋwahaatare, ba ezlzlalaatare. ");
INSERT INTO mfi_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Magaamaga vaƴiya de tsekwartsekwa am tate umele maa, pallaatare a pelaa kayawaara, aà kata vante naàza za ge ezzeŋwaara waà, a beƴa shuŋgu aà nalkame na aà ba ate waara. ");
INSERT INTO mfi_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","A ba ŋane aà elvan ge egdzar mamahaŋaara : Shuŋgu aà eptsarinaptsa nazaaruwa, nawa ŋane ya beƴanaa ate we aà kayawa. Maà a de ŋezlaa ge ervauŋɗaatare waà, palle a nazu ta ndahana itare ɓaaka. A ba itare: Aàzara kena naàzena aŋkwa aà magamita Dadaamiya na? ");
INSERT INTO mfi_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Saraasa am lardaatare am Kanaana, ta tsakanse nazena a shatersha na baɗemme ge eddetare Yakubu. ");
INSERT INTO mfi_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","A ba itare taà elvan ge eddetare: Edda aà larde ŋanna baŋeranka elva a hairire ɗekiɗeki. A bantsa ŋane ta ɓelaŋera an ɓela ŋa kelaadaha, ŋa de zhara larde. ");
INSERT INTO mfi_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","A ba ŋere ŋaà elvan ge ŋane : ŋere ŋa kelaadaha ka, ŋa ba emnde a jirire. ");
INSERT INTO mfi_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ndza ŋa kelaawa ju buwa ate eddeŋere, pallaaŋere keɗakeɗa, amaà gaajiyaaŋere waà, aŋkwa am mba antara eddeŋere am Kanaana. ");
INSERT INTO mfi_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Amaà a ba zhel ŋanna aà elvan ge ŋere: Naàwa nazena ya de diyeddiye aàtekwa tara kwa emnde a jirire an kwa emnde a fida keni: ƴawanƴa pallaakure aàzerwa aàhuna, emnde umelaakure waà, a daranda jahwana aà dem mba, aɗaba aŋkwa waya am mbaakure. ");
INSERT INTO mfi_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Zlauzlala aà daà, amaà sawiyansa kudere kure na kwa ƴanaa am mba na. Yaà de diyeddiye aà ba ate una ŋanna geni kwa emnde a jirire. Am iga a una ŋanna, yaà de ɓelakura egdze a emmekure na aàzerwa na, kwaà tsakalaakure am lardaaruwa ba seke una kwaà katana kure. ");
INSERT INTO mfi_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ta tsekwaa kayawahaatare ate iga aà ezzeŋwaha waà, ta ber shuŋguwahaatare baɗemme am kayawaha na. Itare, eddetare, baɗemme ta nanna shuŋguwaha na. Baɗemmaatare ŋateraŋa lyawa. ");
INSERT INTO mfi_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ba wera waara ge Yakubu eddetare, a ba ŋane aà elvan ge itare : Aàzara kwa! Baɗemme kwaà keɗiyakaɗa egdzara! Yusufa keni ɓaaka, nawa Simaun keni saaka zlaɓe adaliye, kwaà kata daà Bainjamaiŋ adaliye? Una waà, zlazlaɗa ba ge iya. ");
INSERT INTO mfi_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","A ba Ruubain aà elvan ge eddetare: Fiyemfa Bainjamaiŋ am erva ge iya. Ba maàki sanakanaaka waà, kwaye egdzaraaruwa buwa, ceɓateraceɓa am kelaara. ");
INSERT INTO mfi_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Amaà a ba Yakubu: ɗekiɗeki aà ɗabakurka egdzaaruwa mazlaara, aɗaba diyandiya ɓaaka egdze a emmeŋaara an shifa. Yaà zhara ba ŋane ŋanna mazlaara, maà de shansha lamare umele zlaɓe adaliye ate barama a shula waà, ya emgyegwe a zhele seke una telle ire, aà zliyaka ervauŋɗe aà ba aà da faya emtu? ");
INSERT INTO mfi_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Waya ankwa á far he maga hakuma‐aara am haha á Kanaana. ");
INSERT INTO mfi_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Emnde á Yakubu zlaranaazle nalkame na ta de sana am Misera na catte. A ba eddetare: Sey ba kwá eptsa á dem Misera na, de shekwawamiyepshekwe naza za cekwa. ");
INSERT INTO mfi_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","A ba Yahuuda: Estuweka Edda. Zhel ŋanna a ndaŋerndaha ba parakke, a ba ŋane: A puwanteka ice‐aaruwa ate kure áhuna mazle‐aara, máki sakuriyanka egdze a emmekure na kwa ƴanaa am mba na. ");
INSERT INTO mfi_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Daaci máki ká ƴanƴa egdze a emmeŋere na á zlala antara nere wá, ŋá de shekwa naza za na adaliye. ");
INSERT INTO mfi_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Amá má ká ɓeleka egdze a emmeŋere ge zlala antara ŋere wá, ŋá gejeka sera á ŋere mazle‐aara. Aɗaba a ndahaŋera an sheɓeka zhel ŋanna, amá ba parakke. A ba ŋane, a puwameka ice‐aaruwa ate kure mazle-aara má sakurka antara egdze a emmekure na am mba na. ");
INSERT INTO mfi_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","A be Iserayiila á elvan ge itare: Labara ɗemme kwa magite jeba una, há ni kwa naba banan ge zhel ŋanna ganakini aŋkwa egdze a emmekure umele am mba na? ");
INSERT INTO mfi_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ta eptsanaa jawapa, a ba itare: A ndavaŋerwa ŋane elva‐aha gergere ate ŋere antara jeba á ŋere. A ba ŋane á elvan ge ŋere: Aŋkwahe eddekure an shifa? Aŋkwahe egdze a emmekure umele am iga? Daaci ŋere keni ŋa vante ba jawapa‐aha á ndava‐aha‐aara. Tamaŋerka ɗekiɗeki watse á baŋera sawansa egdze a emmekure ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","A ba Yahuuda á elvan ge eddetare Iserayiila: Ɓeliteɓela egdze ŋanna ge iya, ŋá tse kerɗe, ŋá zlala kerɗe, máki ekka an ire á ŋa antara ŋere ira eggye-aha á ŋa mi kata nja an shifa adaliye. ");
INSERT INTO mfi_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Eksanaarekse ya shafa á egdze qanna ate ire‐aaruwa. Má sanaaka an ŋane, se fanakemka am erva wá, a gevge haypa saksage ya guwa ya an ka. ");
INSERT INTO mfi_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Sane kwakya mi keɗanaamiya. Ma andze keɗaminaaka sarte wá, ɓaaka shaige‐aara ma ser buwa keni ma saŋeraasa kina. ");
INSERT INTO mfi_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","A ba eddetare Iserayiila á elvan ge itare: Máki ba estuwa wá, shagera. Dawananda kashi‐aha á larde á miya ge zhel ŋanna, jawanmejahe kazlaŋa shagera shagera na ɓaaka argina ɗekiɗeki am larde á miya na: egdze a kajiiji antara navawe‐aha na á se emtake na antara ɗagwala á naza se antara naza se yawe yawe‐aara antara nama ira egdzar nafa emtake emtake na an ula shagera na, dawananda. ");
INSERT INTO mfi_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Iyau, viyawanaaka shuŋgu‐aha na kwa beranaa am kayawa‐aha á kure na. Una ŋanna a viyaterare á ba an viya. eksawantekse shuŋgu umeIe keni am erva. ");
INSERT INTO mfi_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Naba eksawanteksa egdze a emmekure, eptsauptsa ádeza zhel ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Dadaamiya na slekse ba ŋane palle na, an sleksire‐aara á de magana ba ŋane slera‐aara am ervauŋɗe á zhel ŋanna, lauktu á de zakurvara ŋane, á de puwakura egdzara mama‐aha a kure, tara Bainjamain antara Simaun na kwa ƴanaa áhuwa na, naza‐aaruwa ge iya wá, ba dey. Má banba ŋane a jaruka egdzara ázeŋa, ba tá juka ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Daaci egdzara á Yukubu ta janme kazlaŋa‐aha na, ta eksetaa shuŋgu an saga antara egdze e emmetare Bainjamaiŋ, ta zlala an ŋane á dem Misera, ta de katafke á Yusufa. ");
INSERT INTO mfi_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusufa ba a puweîe ice ate Balnjamaiŋ am dagave á egdzara mama‐aha-ŋara umele wá, á ba ŋane á elvan ge male á emnde a slera‐aara: Daterda emnde na á dem ɓere, de vaterteva sleɗe, eksevaksa dabba palle ganvege naza ɗale, magawanaamaga naza za an saga, watse emnde tá za ɗafa ázerwa an vacatire. ");
INSERT INTO mfi_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ane, a be zhel na, a daa emnde na suuwe á dem mba á Yusufa, a de vaterte sleɗe, a magaa nazena a bannaa Yusufa na baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Amá am sente na tá datera á dem mba á Yusufa na wá, baɗemme damda lyawa am vuwa‐aatare. Aɗaba ta bamsa itare : Tá de damiya á dem bere aɗaba shuŋgu na mi beranaa miya am kayawa‐aha na. Tá de damiyere an ja am here, tá de magamiya palasa antara ba ezzenwa‐aha á miya keni, watse ɓaaka ura á sesse, tá de gamivege nave‐aha‐aatare vatena. ");
INSERT INTO mfi_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Aɗaba una ŋanna, ta naba mbeɗanu elva‐aatare ge male á slera á Yusufa na ate we á wakyiya, ");
INSERT INTO mfi_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","a ba itare tá elvan ge ŋane: Aŋkwa elva á nere ámbarka á ŋa. Ŋere na wá, werre keni ndza ŋa sawa, ŋa se shekwa naza za á ba áhuna. ");
INSERT INTO mfi_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Am eptsa á ŋere á dá wá, ŋa de tsekwaa am ekse umele gaŋerarga vayiya wá, ma ware á ŋere keni a beƴe shuŋgu ate we á kayawa-aara, ba kelaa á shuŋgu á nalkame ŋanna baɗemme. Shuŋgu ŋanna aŋkwa saŋeransa ba ŋere an sera á ŋere. ");
INSERT INTO mfi_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Una ŋá shekwa naza za umele an ŋane keni aŋkwa baɗemme. Una ŋanna najipu, ma a puwaŋermaa ware shuŋgu ŋanna am kayawa‐aha á ŋere keni diyanerka. ");
INSERT INTO mfi_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Male na a eptsateraa jawapa, a ba ŋane á elvan ge itare: A wakurka lyawa ɗekiɗeki, una ŋanna slera á Dadaamiya á kure. Dadaamiya á eddekure. A puwakurmaa ba ŋane nalmane ŋanna am kayawa‐aha á kure. Shuŋgu‐aha á kure ndza samsa á sem erva‐aaruwa. Daaci a sanse Simaun ásezetare, ");
INSERT INTO mfi_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","a daterhe á dem hude á há á Yusufa, a sateraa yawe ge bara sera‐aha‐aatare, a vaterte masa ge ezzeŋwa‐aha‐aatare. ");
INSERT INTO mfi_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Itare ta tsatsaa kazlaŋa na ta sanaa kashi‐aara ge Yusufa na, daaci tá aŋkwa ufa sa‐aara an vacitire, aɗaba ta cenaa watse tá za ɗafa antara ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Saasa Yusufa, ta kezle ugje ákatafke‐aara reppe, ta vante kashi á larde-aatare na. ");
INSERT INTO mfi_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ŋane keni a ndavateru lapiyire á vuwa‐aatare antara lapiyire á eddetare. A ba ŋane á elvan ge itare: Awara emgyegwe a eddekure na ndza kwa ndinda na? A be aŋkwa ŋane? Zlaɓe á ba an shifa? ");
INSERT INTO mfi_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ta ŋwanante, a ba itare: Náve à ŋa eddeŋere ba lapilayye, zlaɓe á ba an shifa. Tá ambera á kezzlan ugje reppe am aha. ");
INSERT INTO mfi_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","A zharaterzhara Yusufa, a naa Bainjamaiŋ egdze a emmeŋara emmetare palle, a ndavateruhe, a ba ŋane: Una gaaji á kure na ndza kwa biyaa elva‐aara na emtu? A ba itare: Ba ŋane. A ba ŋene á elvan ge Bainjamaiŋ: A tsufaktsufa Dadaamiya, egdze‐aaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ba a ndaase una ŋanna wá, antara ba zlala‐aara, aɗaba aŋkwa á sawa yawe á kyuwa‐aara, Zhagade‐aara, a de kyuwa am bere‐aara, aɗaba haraare tegava-aatare antara egdze a emmeŋara ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Am iga á una ŋanna, a baraa ice, a naba sessehe, a sherse ice, a ba nane á elvan ge emnde‐aara: Vawaŋerteva naza za. ");
INSERT INTO mfi_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Saranmesa ɗafa wá, ta vante naza‐aara ba ŋane palle, egdzara mama‐aha‐nara keni tá an ire‐aatare, emnde a Misera na ta se za ɗafa ázeŋara na kenl tá an ire‐aatare. Adaba emnde a Misera tá zeka ɗafa átirpalle antara emnde a Ibrahiima. Una harem ge itare. ");
INSERT INTO mfi_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Egdzara mama‐aha‐ŋara ge Yusufa ta njehe an ɗabava an ɗabava ákatafke‐aara. Ta fantau ate makaaji á eddetare, dete gaaji‐aatare. Tá maga ba najipu‐aara, tá ámbera á ndaha elva an ice am dagave‐aatare. ");
INSERT INTO mfi_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yusufa a sateranhe ɗafa na ni aŋkwa á zena ŋane á katafke‐aara na ge egdzara mama‐aha‐ŋara. Amá wá, ƴaikke ba una a vante ga Bainjamaiŋ na arge una a vaterte ge egdzara mama‐aha‐ŋara umele, naza‐aatare na sey ilyeɓe‐aara lauktu á hyephye seke naza á Bainjamaiŋ. Má a de semhe ge higa‐aatare baɗemme wá, ba ka duhe. Ta sharhe zlaɓe adaliye, a jese an je am ne‐aatare. ");
INSERT INTO mfi_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","A ba Yusufa á elvan ge male á emnde a maganaa slera: Vaterteva nalkame ge dawale‐aha na, a naatenaha kayawa‐aha‐aatare ba shagera má ba tá dzegwandzewa danada‐aara. Shuŋgu‐aha‐aatare keni fateremfa am kayawa‐aha aatare ate we‐aara. ");
INSERT INTO mfi_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Eksameksa kwap‐aaruwa, kwap na ta janaa an lipela na, fananufe ge we á kayawa á gaaji‐aatare na antara shuŋgu na a se shekwa nalkame an ŋane baɗemme. Zhel na a magaternaahe á ba me una a bannaa Yusufa na. ");
INSERT INTO mfi_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Werawera ekse wá, ta naba vaterte baráma a dá ge egdzara á Yakubu, ta da‐aatare an ezzeŋwa‐aha‐aatare. ");
INSERT INTO mfi_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ba degashe‐aatare am huɗe á ekse, zlarvaazlala ba cekwaaŋguɗi wá, a ba Yusufa á elvan ge male á emnde a maga slera am huɗe á ha‐aara: Ezzlala watsewatse ɗabaterɗaba emnde na. Máki shakateraasha, bateranba wá, labara tá pela shagerire an shagerkire? ");
INSERT INTO mfi_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Naba ndaterndaha, labara kwa ilu kwap á zanwa‐aaruwa ta janaa an lipela, á sha duksa keni an ŋane, á naha keni á ba an ŋane? Maga á kure na wá, mandzawe jipu. ");
INSERT INTO mfi_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Zhagade ge male á emnde a slera‐aara na, a de shateraahe, a tsakaterse elva ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","A ba egdzara á Yakubu: Labara zlaɓe eddaye ká sanse jeba elva na am mbuwe? Ba ser palle keni slarka nave aha á na ŋe maga jeba une degiya! ");
INSERT INTO mfi_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nawa shuŋgu na ŋa de beranea am kayawa‐aha á ŋere, saŋerakansa kwaye am Kanaana. A sawa estara zlaɓe na se ila lipela antara dindar am mba á zanwe á ŋa? ");
INSERT INTO mfi_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Kwaye kazlaŋa á ŋere, naba eppakya. Eddawna ka shaa duksa á kure am kazlaŋa‐aara, njeka an shifa ɗekiɗeki, ŋere emnde umele keni gaŋervege nave‐aha á ŋa. ");
INSERT INTO mfi_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Shagera, a bá maie na, amá wá, sey ba eddawna má ya ber duksa ŋanna am kazlaŋa‐aara una á gev nave‐aaruwa. Kure emnde umele wá, á shakuraaka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kerteŋ tsekwarnatsekwa kayawa‐aha‐aatare á dem aha, ma ware keni a werante naza‐aara. ");
INSERT INTO mfi_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Male na a fantau ge pakya kazlaŋa‐aatare, a fantau ate makaaji‐aatare dete gaaji. A shaa kwap á zanwe‐aara am kazlana á Bainjamaiŋ. ");
INSERT INTO mfi_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ge jaterja emtaŋkire wá, ta tataa naŋgyuwe ate vuwa‐aatare baɗemme. Daaci ta naba eptsa á sem huɗe á ekse an nalkame na ate iga á ezzeŋwa‐aha baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yahuuda antara egdzara mama‐aha‐ŋara ta se demhe am huɗe á há á Yusufa, ta se ber nane keni zlaɓe zlalaaka. Reppe ta kezzlan ugje am aha ákatafke‐aara. ");
INSERT INTO mfi_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","A ba Yusufa á elvan ge itare: Slera á kure una ka? Diyaweddiye ganakini iya kwá aŋkwa á zharizhara na wá, ya ura an diya. Ya an hakuma ge dise nazena ni a de magava baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","A ŋwaname ge Yahuuda, a ba ŋane á elvan ge ŋane: Ɓaaka nazu ŋá ndahana ŋere ámbarka á ŋa. Ŋá ndaha tara uwe antara uwe? Ŋa ndaha uwe geni ŋá sha jirire an ŋane na? Ŋere, ŋa emnde a haypa, a ɓalesaa ba Dadaamiya an ire‐aara kaypa á nave‐aha á ŋa. Eddawna ta ber duksa á ŋa am kazlaŋa aara na, antara ŋere baɗemme, ŋa ba nave‐aha á ŋa ámbarka á ŋa. ");
INSERT INTO mfi_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Lálálá, estuweka, a ba Yusufa, ba eddawna ta ber kwap‐aaruwa am kazlaŋa‐aara na wá, á gevge ba ŋane nave aaruwa. Amá kure emnde umele wá, á shakuraka, zlauzlala á dá, ádeza eddekure an hairire. ");
INSERT INTO mfi_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Daaci Yahuuda a naba ganaptehe ge Yusufa, a ba ŋane á elvan ge ŋana: Tasle á ŋa ámbarka á ŋa, nave á ŋa á shansha baráma ge ndakse elva‐aara pane emtu? Aɗaba ekka kwa ba kalkale antara Firawna. Tasle á ŋa, a jaŋka ervauŋɗe. ");
INSERT INTO mfi_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ambarka á ŋa ndza ka ndavaterwa ba ka kahe ge nave‐aha á ŋa, a ba ka a elvan ge itare: Aŋkwahe eddekure, bi egdze a emmekure umele am mba? ");
INSERT INTO mfi_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ŋa eptsakaa jawapa, a ba ŋere aŋkwa emgyegwe a eddeŋere antara kudereŋere a yanaa am emgyegwire, ndza ta buwa ate emmetare amá keɗakeɗa maleŋara, a ƴaa ba ŋane pane, wayaawaya eddeŋara jipu ");
INSERT INTO mfi_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ambarka á ŋa, a ba ka á elvan ge nave‐aha á ŋa: Sawiyansa egdze a emmekure ŋanna yá se nanaana an ice‐aaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Abi ndza ŋa ndakndaha sera‐aara ámbarka á ŋa, geni egdze ŋanna wá, tá pakyaveka an eddeŋara. Má de ɓaaka ŋane wá, á dedde shifa am eddeŋara. ");
INSERT INTO mfi_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Amá a ba ka á elvan ge nave‐aha á ŋa: Máki sakuremka an kuderekure ŋanna wá, a puwanteka ice-aaruwa ate kure áhuna. ");
INSERT INTO mfi_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Daŋeraada maa, ŋa de mbeɗanu elva á ŋa na ge eddeŋere ambarka á ŋa. ");
INSERT INTO mfi_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Á ba eddeŋere : Eptsauptsa zlaɓe adaliye á dem Misera, de shekwawamiyepshekwe nalkame cekwaaŋguɗi. ");
INSERT INTO mfi_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","A ba ŋere ŋá elvan ge eddeŋere: Martapa a ŋere he? Máki ŋá ɗuwa antara kudereŋere Bainjamaiŋ wá, una ŋá duwa. Aɗaba máki daŋeranka kudereŋere na wá, ŋá dzegwanka de katafke á zhel ŋanna ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","A ba nave á ŋa eddeŋere á elvan ge ŋere: Ba kure keni diyakurdiya ya shaa ba egdzara buwa an mukse-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Pane á egdzara ŋanna a keɗa warre. Ya tamaa a jaa ba naza á kaamba aɗaba sem vaatena puwanteka ice‐aaruwa at ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kina máki zlalakurzlala zlaɓe adaliye an egdze a emmeŋara na, máki de shansha zlaɓe adaliye lamare umele wá, á de jija ervauŋɗe á ba a da faya, aɗaba ganevge emgyegwe a zhele, zlauzle ndzeɗa‐aaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Daci kina na ámbarka á ŋa wá, yá dzegwanka eptsa ádeza walaɗi á ŋa edderwa, má ɓaaka egdze na am dagave á ŋere. Aɗaba edderwa wayaawaya jipu an egdze na, ɓaaka pakyava-aatare ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Máki daŋeraada ni nánka egdze na am dagave á ŋare wá, ba lette shifa am ŋane. Máki de gevge estuwa, ba ŋere nave‐aha na ka emtu ŋa ja eddeŋere á ba á da faya an ervauŋɗe, emgyegwe a zhele telle ire? ");
INSERT INTO mfi_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ambarka á ŋa, iya wá, ƴananƴa ya shifa‐aaruwa aɗaba egdze na. Asawa am mba, a ba iya yá elvan ge edderwa: Máki sanakanaaka egdze na wá, daaci haypa ƴaikke ya guwaa an ka, haypa saksage ká ƴiyarka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Adaba una ŋanna, tasle á ŋa, ɓelanaaɓela egdze na a zlarzlala á dá antara egdzara mama‐aha‐aaruwa, Nawa iya givege nave á ŋa am keIa‐aara. ");
INSERT INTO mfi_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Yá dá ni, yá ƴá egdze na am iga? Yá de duwa estara á de katafke á edderwa? A nananka an ice‐aaruwa ɗekiɗeki palasa na ni á de magana edderwa na. ");
INSERT INTO mfi_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Am iga á una ŋanna maa, nja á emnde na ta jantaave ge ŋane na, aley Yusufa dzegwanka ŋa ervauŋde‐aara. A kante kwara, a ba ŋane: A daredde emnde baɗemne á degashe. Ba palle ura jauka ázeŋara am sarte na ni aŋkwa á maratera ire‐aara ge egdzara mama‐aha‐ŋara na. ");
INSERT INTO mfi_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Emtsaade wá, a fantau ge kyuwa á ba an ka kwara, haa cenarancena emnde a Misera. Dete ba emnde a há á Firawna keni cenarancena una. ");
INSERT INTO mfi_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Daaci a ba ŋane á elvan ge egdzara mama‐aha‐ŋara: Degiye una ba iya Yusufa. Zlaɓe aŋkwa edderwa an shifa? Palle á ura dzegwandzegwa eptsanaa jawapa ɓaaka am egdzara mama‐aha‐ŋara na. Aɗaba bademme-aatare tá aŋkwa á gyagya ba seke maagara á katafke‐aara. ");
INSERT INTO mfi_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","A ba ŋane á elvan ge itare: Gawaptega ásezerwa! Ta ganaptehe. A be ŋane á elvan ge itare: Ba iya una ya Yusufa, egdze a emmekure na ni kwa naba veluhe á dem Misera na. ");
INSERT INTO mfi_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Amá kina wá, a wesheka ire á kure, hyawanaaka lyuwa ge ire á kure geni ŋa magan ge uwe una. Duksa nanna wá, a siyaa ba Dadaamiya ásehuna zuŋŋwe arge kure, geni yá lyelya shifa á kure. ");
INSERT INTO mfi_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kina magaamaga yawe buwa waya am larde, amá a ƴaa yawe ilyeɓe zlaɓe adaliya ɓaaka herɗa, ɓaaka duksa na ni tá de sana emnde á sem mba. ");
INSERT INTO mfi_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Dadaamiya a ɓela iya zuŋŋwe ákatafke á kure á sem larde na wá. ba geni a lyelye shifa á kure, a zluka wulfe á kure ba ɗekiɗeki am duniya na. Lyakurselye an tsaka ire. ");
INSERT INTO mfi_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Duksa palle wá, kwa ɓeliyaa kure ka asehuna, amá á ɓeliyaa ba Dadaamiya an ire‐aara. A give male ƴaikke an tsaka ire am kwara á Firawna baɗemme. Há á Firawna antara haha á Misera bademme á ba am erva‐aaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Kina wá, eptsaweptsa watsewatse á dá, de ndawanndaha ge edderwa: a ba egdze á ŋa Yusufa wá, Dadaamiya givege ura ƴaikke, haha á Misera baɗemme á ba am erva‐aaruwa, sawa ásezerwa, shekwaaka ɗeklɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Nawa kwá se nja ba herzhe an iya am haha á Gausan antara egdzara á ŋa antara eggye‐aha á ŋa, kyawe‐aha á ŋa, nawe‐aha á ŋa, baɗamme a nazena am rezege á ŋa. ");
INSERT INTO mfi_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Yá se geleka ba iya, aɗaba zlaɓe waya a ƴaa yawe ilyeɓe. Yá se vakte naza za á ŋa antara huɗe á ŋa baɗemme antara ba dabba‐aha á kure keni baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","A farhe zlaɓe adaliye, a be ŋane á elvan ge itare: Abi kwá aŋkwa á nanna ba kure keni an ice á kure? Baaka ɗeme seke ekka Bainjamaiŋ. Kina wá, diyakureddiye geni iya Yusufa una yá aŋkwa ndakur elva na. ");
INSERT INTO mfi_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Zlauzlala kwa mazIe‐aara, de ndawanndaha ge edda ŋgahire na ni ya shanaa iya am haha á Misera baɗemme na. Tsakawansetseke nazena ni kwa nanaa kure am nja-aaruwa baɗemme. Sawiyansa irice‐aara ásehuna shekwawaaka dekodeki. ");
INSERT INTO mfi_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Am iga a una ŋanna, takwalle a ŋaŋem Bainjamaiŋ am uksuwe, bukerɗe— aatare farantaufe ge kyuwa. ");
INSERT INTO mfi_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Zlaruzle antara Bainjamaiŋ, a fantau ge ŋaŋa egdzara mama‐aha‐ŋara umele á dem uksuwe ma ware‐aazare keni, ámbera á kyuwa. Lauktu egdzara mama‐aha‐ŋara na sharansha ndzeɗa ge ndaha elva antara ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Daaci daada Iabare ŋanna á dem huɗe á há á Firawna, ta aŋkwa á enndaha emnde baɗemme geni saremmsa egdzara mama‐aha‐ŋara ge Yusufa, tá aŋkwa am ekse na. Lyavaalya ervauŋde á Firawna elva ŋanna antara nakwa‐aha‐aara keni baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","A ɗante Yusufa, a ba ŋane á elvan ge ŋane: Ndaterndaha ge egdzara mama‐aha a ŋa na wá, a halarantehala nalkame ate iga á ezzeŋwa‐ana‐aatare, a eptsareptsa á dem larde‐aamra am Kanaana. ");
INSERT INTO mfi_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Eptsa‐aatare á dem Kanaana wá, ba ge de sa eddetare anlara há-aatare baɗemme. Asarsawa ásezerwa áhuna. Asarsawa, yá se vaterte sleɗe na ni ɓaaka argina ɗekiɗeki am haha á Misera baɗemme na, tá se zana itare nampire á haha na, una shagera‐aara ba jipu na. ");
INSERT INTO mfi_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ndaterndaha zlaɓe adaliye elva na: Ya ndasaa iya, vanaterteva baráma, geni a halarantehala darkwa-aha am Misera áhuna ge sá ŋwasha‐aha‐aatare antara egdzara‐aatare ira eddetare am huɗe‐aara, a sarsawa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","A waterka kazlaŋa‐aatare ɗekiɗeki am ice. Aɗaba tá se ber umele jauje ba ge una ŋanna am Misera ahuna. ");
INSERT INTO mfi_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ane, a ba egdzara á Iserayiila, ta eksarhe maga nazena ta ndaternda na. Yusufa a naba vaterte darkwa‐aha á teɗana belsa ate una a ndahana Firawna, a vaterte antara naza la na tá maga shula an ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yusufa a vaterte amara zane‐aha palpale ge egdzara mama‐aha‐ŋara ge mbaɗese vuwa an ŋane. Amá ge Bainjamaiŋ wá, a vante amara gursa dermeke keƴe, ámasla an zane‐aha ilyeɓe. ");
INSERT INTO mfi_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Kazlaŋa na a vaterte, ta danan ge eddeŋara kenu ge ire aara: a velaanante bidale á ezzeŋwa kelaawa ge eddeŋara, ezzeŋwa-aha ŋanna baɗemme tá á ba an duksa ate iga, kazlaŋa ŋgelaama ŋgelaama na am Misera na antara úmá ezzeŋwa kelaawa tá an naza za ate iga: nalkame, depaiŋ antara jeba a naza za‐aha umele gergere ge shula á eddaŋara má watse á kezzla na. ");
INSERT INTO mfi_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Am iga a una ŋanna, a vaterte baráma a dá ge egdzara mama‐aha‐ŋara. Amá a faœr magiya, a ba ŋane á elvan ge itare: Dagalauka degiya ate baráma! ");
INSERT INTO mfi_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Daaci ba tse‐aatare ge egdzara á Yakubu am Misera na, ta da‐aatare ádeza eddetare am !arde á Kanaana. ");
INSERT INTO mfi_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ba daada‐aatare wá, a ba itare tá elvan ge eddetare: Aŋkwa Yusufa á ba an shifa‐aara. Baira male ƴaikke ba ŋane am larde a Misera baɗemme. Amá ba seke tá ndaha elva keni diyaaka eddetare na, aɗaba fetarka an itare. ");
INSERT INTO mfi_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Egdzara‐aara na ta tsakanse eiva‐aha á Yusufa baɗemme, a nanhe an ice‐aara darkwa‐aha na á teɗana belsa, a ɓelanaa Yusufa ge da ŋane am huɗe‐aara na, lauktu a fetuwa am una ŋanna maga slera am eddetare. ");
INSERT INTO mfi_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","A naba kame kwara Iserayiila, a ba ŋane: Hyaahyawa! Fawarka elva umele mazIe‐aara, an shifa Yusufa‐aaruwa. Sey yá duwa, yá de puwetepuwe ice‐aawwa ate nane lauktu yá emtsa. ");
INSERT INTO mfi_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","A naba kezzla Iserayiila an nazena am rezega‐aara baɗemme. De tsekwaatsekwa am ekse á Birsaba maa, a vante sadake á dabba ge Dadaamiya á eddeŋara Isiyaaku. ");
INSERT INTO mfi_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Dadaamiya a naba ndahan elva an vaƴiya nanna am shene. A naba eddaha: Yakubu, Yakubu. A ŋutehe: Na am á bina. ");
INSERT INTO mfi_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","A be Dadaamuya á elvan ge ŋane: Ba iya Dadaamiya, Dadaamiya na a ɗabanaa eddeŋa na. A waŋka lyawa ɗekiɗeki ge dem Misera. Aɗaba yá de yáterteya emnde á ŋa áhuwa, tá de gev nalga ƴaikke. ");
INSERT INTO mfi_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Yá daka ba iya an ire-aaruwa á dem Misera, watse yá saterasa zlaɓe adaliye emnde á ŋa á sem tata na. Má watse zlauzle hairire á ŋa maa, á de hedakanuwa Yusufa an erva-aara ice á ŋa. ");
INSERT INTO mfi_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Daaci a naba tsa Yakubu am Birsaba, Iserayiila keni ba ŋane. Egdzara‐aara ta eksame ŋane antara egdzara‐aatare antara ŋwasha‐aha‐aatare, ta halateraa am darkwa‐aha na á teɗana belsa a vatertaa Firawna ge datera am huɗe‐aara na. ");
INSERT INTO mfi_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","A naba kezzla Yakubu antara emnde‐aara baɗemme á dem Misera. Dabba‐aha‐aatare antara nalmane‐aatare umele na ta ganaa am haha á Kanaana baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","A kez!ese estuwa Yakubu á dem Misera antara emnde‐aara baɗemme, egdzara‐aara zaala antara ŋwasha Ira eggye‐aha‐ŋara baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Nawa zhera á egdzara á Iserayiila na ta sem Misera, amaana Yakubu an egdzara‐aara: Egdze a walire á Yakubu wá, Ruubain. ");
INSERT INTO mfi_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Nawa egdzara á Ruubain: Hanauk, Fallu, Haisrunu ira Karmi. ");
INSERT INTO mfi_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Nawa Simaun amara egdzara‐aara : Yainuyail, Yamain, Auhada, Yakin. Jaukar ira Sawulu. Sawulu wá, a yanaa an egdze á emnde a Kanaana. ");
INSERT INTO mfi_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Nawa una Laiwi antara egdzara‐aara: Gairsaun, Kahat ira Mairari. ");
INSERT INTO mfi_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Nawa una Yahuuda antara egdzara‐aara: tara Air antara Aunan antara Saila amara Farais ira Jara. Amá tara Air antara Aunan wá, ta matsaa am haha á Kanaana. Farais ŋane ndza an egdzara buwa, tara Haisruna an Hamul. ");
INSERT INTO mfi_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Nawa una Isakar antara egdzara‐aara: Taula, Puwa, Yauba ira Simraun. ");
INSERT INTO mfi_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Nawa Jabulaun amara egdzara‐aara: Sairait antara Ailaun ira Yaklaiyail. ");
INSERT INTO mfi_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Kwaye ŋane egdzara á Yakubu na a yanaa an Lee’a am Paddan‐Aram. Aŋkwa zlaɓe egdze a emmetare mukse, zhera‐aara Dina. Emnde á Yakubu na a yateraa an Lee’a baɗemme, a magaa kulkeƴe ju keƴe. ");
INSERT INTO mfi_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Nawa emnde na keni tara Gada antara egdzara‐aara: Tara Jaiflyaun antara Haggi amara Suni antara Aisbaun antara Airi amara Araudi ira Araih. ");
INSERT INTO mfi_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Nawa Asair amara egdzara‐aara: Yimna, Yisuwa, Yisuwi, Bairiya ira Sairak egdze a emmetare mukse. Iyau, Bairiya a ye Baibair antara Malkiyail. ");
INSERT INTO mfi_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Kwaya ŋane egdzara á Yakubu na a yanaa an Jilpa, kwatena na a vantaa Laban ge egdze‐aara Lee’a. itare keni ta kelaawa ju uŋkwahe. ");
INSERT INTO mfi_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Rahiilu mukse á Yakubu, ŋane keni a yayan egdzara buwa, tara Yusufa antara Bainjamaiŋ. ");
INSERT INTO mfi_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yusufa a ye tara Manasa amara Afrayim. A yateraa am haha á Misera, an mukse‐aara Asnat, egdze á Pautifaira liman am Aun. ");
INSERT INTO mfi_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Nawa una keni Bainjamaiŋ antara egdzara‐aara: Baila, Baikair, Asbail, Gaira, Na‘aman, Aiki, Raus, Muppim ira Arda. ");
INSERT INTO mfi_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Kwaya ŋane egdzara á Yakubu na a yanaa an Rahiilu, ta kelaawa ju ufade. ");
INSERT INTO mfi_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Tara Dan, tá an egdzeaara Husim. ");
INSERT INTO mfi_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nawa Naiftalim antara egdzara‐aara: Yaksayail antara Yaijair ira Silaim. ");
INSERT INTO mfi_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Kwaye ŋane egdzara á Yakubu na a yanaa an Bilha, kwatena na a vantaa Laban ge egdze‐aara Rahiilu, ta vuye. ");
INSERT INTO mfi_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Emnde á Yakubu na ta sem Misera baɗemme, ta kul uŋkwahe ju uŋkwahe, ɓaaka ŋwasha‐aha á egdzara‐aara am huɗe‐aara. ");
INSERT INTO mfi_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Iyau, antara egdzara á Yusufa buwa na a de yateraa am Misera na maa, emnde á Yakubu baɗemme ta magaa kul vuye am haha á Misera. ");
INSERT INTO mfi_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Am sarte na zlaɓe tá duwa maa, Yakubu a naba ɓela Yahuuda ákatafke-aara, a ɓelanaa ádeza Yusufa geni a se yainuye am kwara á Gausan. De tsekwaatsekwa Yakubu am tate ŋanna antara emnde‐aara baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusufa keni a naba duhe á de yainu ge eddeŋara am Gausan na, an darkwa‐aara á teɗana belsa. Má a de puwete ice ate eddeŋara wá, ázarekwa! Takwalle a takwalem eddeŋara na am uksuwe, á kyuwa an yawe á kyuwa na wá, ba ka ɗuhe, haa a shekwaahe. ");
INSERT INTO mfi_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ba wera we‐aara ge Iserayiila, a ba ŋane á elvan ge Yusufa: Kina wá, ma emtsanemtsa keni ba zlauzle mazle‐aara, aɗaba zlaɓe ká aŋkwa an shifa, ya nakna an ice‐aaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Am iga á una ŋanna baɗemme maa, a ba Yusufa á elvan ge egdzara mama‐aha‐ŋara antara huɗe á há â eddeŋara, a ba ŋane á elvan ge itare bademme‐aatare: Kina wá, yá de mbeɗanumbeɗe ge Firawna, a ba iya á elvan ge ŋane: Egdzara mama‐aha‐aaruwa antara huɗe á há á edderwa na ndza tá am haha á Kanaana na baɗemme saremsa ásezerwa. ");
INSERT INTO mfi_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Yá de ndanndaha antara slera á kure baɗemme, geni kwa emnde a gela dabba‐aha, sakuremsa antara dabba‐aha á kure baɗemme, nawe‐aha, kyawe‐aha, essla-aha antara nalmane á kure umele, sakuremsa an kazlaŋa á kure baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Máki a dakurdaha Firawna. a ndavakuruhe, ázara slera á kure wá, ");
INSERT INTO mfi_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","bawananba a ba kure: Ambarka á ŋa, nave‐aha á ŋa ta emnde a gela dabba‐aha. Kwaye am egdzarire sem vatena slera á ŋere ba piya, ŋá aŋkwa á maga ba slera á eggye‐aha ŋere. Estuwa wá, watse tá vakurte kwara á Gausan ge sle|ɗe á nja á kure. Aɗaba emnde a Misera tá higarka ge emnde a gela dabba‐aha, ma nawe‐aha, ma kyawe‐aha keni. ");
INSERT INTO mfi_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Daaci ba zlala‐aara ge Yusufa na ádeza Firawna, a danaa labare, a ba ŋane: Ambarka á ŋa, degiya saremsa tara edderwa antara egdzara mama‐aha-aaruwa baɗemme. Saremsa antara nawe‐aha‐aatare, kyawe‐aha‐aatare, esla-aha‐aatare antara nalmane‐aha‐aatare umele baɗemme, saremsa á sawa am haha á Kanaana. Nawa ta tsekwaa am kwara á Gausan. ");
INSERT INTO mfi_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Daaci a daa emnde ilyeɓe am egdzara mama‐aha‐ŋara na á de katafke á Firawna. ");
INSERT INTO mfi_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Firawna a ndavateru elva ge egdzara mama‐aha‐ŋara ge Yusufa na, a ba ŋane: Azara slera á kure? Ta eptsanaa jawapa. a ba itare: Ŋa emnde a piya ámbarka á ŋa. Ŋá aŋkwa á maga ba slera á eggye‐aha á ŋere. ");
INSERT INTO mfi_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","A ba itare zlaɓe adaliye tá elvan ge Firawna: Aŋkwa waya ƴaikke an tsaka ire am Kanaana ámbarka á ŋa. Ba tate á piya dabba‐aha keni tá shanka nave-aha á ŋa mazIe‐aara. Aɗaba una ŋanna nawa saŋeremsa, ŋa wayve‐aha am iarde á ŋa. Ká ƴanerƴa emtu ámbarka ŋa njinja am Gausan? ");
INSERT INTO mfi_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","A ba Firawna á elvan ge Yusufa: Samsa eddeŋa na ni a yakaa ba ŋane na antara egdzara mama‐aha a ŋa asetevge ekka. ");
INSERT INTO mfi_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Kwaye Iarde á Misera baɗemme á katafke á ŋa, zharaternaazhara sleɗe ŋgelaama na ɓaaka argena ɗekiɗeki na, njatersaanja am huɗe‐aara. Tá naba njiinja am Gausan ŋanna keni ɓaaka lambe‐aarare. Ma tá aŋkwa emnde na diyardrya slera ŋanna be shagera am dagave‐aatare maa, ká naba gatervege male‐aha arge sum‐aha-aaruwa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Am iga a una ŋanna maa, Yusufa a daa eddeŋara keni á de katafke á Firawna, a de marananhe. Yakubu a gar barka ge sleksu Firawna. ");
INSERT INTO mfi_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Firawna a ndavanu ge Yakubu: Yawe á ŋa wanyara kina baɗemme? ");
INSERT INTO mfi_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakubu a eptsanaa jawapa, a ba ŋane: Yawe‐aaruwa dermeke an kulkeye, ya ba seke wayve am duniya na. Ya nanna zlada‐aha gergere am nja‐aaruwa baɗemme Aley keni iva‐aaruwa kwakya ba naza eggye‐aha‐aaruwa zlaɓe adaliye. ");
INSERT INTO mfi_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Daaci Yakubu a gan barka zlaɓe adaliye ge Firawna, lauktu a sessehe ázeŋara. ");
INSERT INTO mfi_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Daaci Yusufa a de vaterte sleɗe ge rara eddeŋara antara egdzara mama-aha‐ŋara. A de vaterte sleɗe na ni ɓaaka argena ɗekiɗeki na am haha á Misera baɗemme, ba seke una a ndahanaa Firawna. Kwara ŋanna Ramsais, sleɗe‐aatare una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusufa a vante zlaɓe adaliye ge eddeŋata antara egdzara mama‐aha‐ŋara nazu ta ezza. A vaterte ate keziakula á emnde‐aha-aatare, ba kelaa nazu á fa erva am mbuwe na. ");
INSERT INTO mfi_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Waya na, ƴaikke an ndzedaãara. Ɓaaka naza za ɗekiɗeki am duniya, emnde a Misera antara emnde a Kanaana baɗemme tá aŋkwa á maga ba palasa ge waya. ");
INSERT INTO mfi_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Shuŋgu na ndza am erva á emnde Misera antara emnde a Kanaana baɗemme damda am erva á Yusufa, shakwarepshakwe nalkame an ŋane. Ŋane keni maa, a daa shuŋgu na á dem mba á Firawna. ");
INSERT INTO mfi_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Am zlauzle shuŋgu am erva á emnde baɗemme am Kanaana antara am Misera, ta naba sawa emnde a Misera á se katafke á Yusufa, a ba itare tá elvan ge nane: A waŋera waya. Ba ká zharaŋerzhara ŋá emtsa aɗaba ɓaaka shungu á ŋere emtu? ");
INSERT INTO mfi_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","A ba Yusufa á elvan ge itare: Má ɓaaka shuŋgu, sawansa dabba‐aha á kure lauktu yá vakurte nalkame. Sawansa dabba‐aha á kure kwa mbeɗana an ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Daaci ta fantau ge hala dabba‐aha á sawa. Belsa‐aha, ezzeŋwa‐aha, esla‐aha, kyawe‐aha antara nawe‐aha baɗemme tá ankwa á sanansa ge Yusufa na. Ate iva ŋanna wá, ta ivaa, á za ɗafa á ba an dabba‐aha‐aatare. ");
INSERT INTO mfi_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ta yivetehe, saliye á shifa‐aara keni ta sawhe zlaɓe adaliye áseza Yusufa, a ba itare tá elvan ge ŋane: Ambarka á ŋa, ba ka keni diyakdiya suŋgu á ŋere ɓaaka, kwaye ba dabba‐aha á ŋere keni ɓaaka zlauzle gevge atuge ekka. Ɓaaka duksa na ŋá sawa an ŋane mazla‐aara, máki vuwa á ŋere ka. A ƴanerar ba fahe antara vuwa a ŋere kina. ");
INSERT INTO mfi_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ha! kwá zharaŋera á ba an ice á ŋá emtsemtsa ge waya, fahe‐aha a ŋere á de gev kaamba ba dey emtu ambarka á ŋa? Naba vawaŋerteva naza za, shekwawaŋershekwe ŋere antara fahe‐aha á ŋere baɗemme, ŋá gevge nave‐ah á Firawna. Naba vawaŋerteva wulfe, geni ŋá shansha nazu ŋá ŋá shifa á ŋere an ŋane, fahe‐aha á ŋere keni keɗaaka. ");
INSERT INTO mfi_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Daaci Yusufa a shekwanve haha á Misera baɗemme ge sleksu Firawna, aɗaba waya ŋanna jauje ge ndzeɗa á emnde baɗemme. Emnde a Misera baɗemme valaruvala fahe‐aha‐aatare. A magava estuwa, lauktu haha á Misera bademme a gev ba naza á Firawna halal. ");
INSERT INTO mfi_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","A gaterve estuwa Yusufa emnde a Misera baɗemme nave‐aha á Firawna, an tate pane ka. ");
INSERT INTO mfi_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Sey ba fahe á liman‐aha palle una shekwaaka, aɗaba aŋkwa shairiya a puwetaa Firawna ate fahe á liman‐aha. Daaci ta zanaa ba itare fahe‐aha‐aatare na a vatertaa Firawna, itare wá, velarka fahe‐aha‐aatare dekideki. ");
INSERT INTO mfi_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","A be Yusufa á elvan ge emnde bademme: Kina wá, shekwanakurepshekwe. Kure ire á kure antara fahe‐aha á kure kwá atuge Firawna. Nawa yá vakurte wulfe, de jauja am fahe‐aha á kure baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Amá am ice duksa ma gyegakuragyega wá, am duksa ilyeɓe, ilyaɓire na wá, kwá vante ge Firawna. Ufade na wá, una ŋanna naza á kure. Wulfe á kure watse kwa jana am shifa antara naza za á kure antara egdzara á kure ira emnde na tá am huɗe á há a kure baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Tá ŋwanante ge emnde baɗemme, a ba itare: Hyahya ndzeɗa á kure ámbarka á na, lyakuraŋeraalya. Ura‐ara keni ká faŋerwa ba ka tsawe hyema wá, eksaŋerarekse ŋa nave‐aha á Firawna. ");
INSERT INTO mfi_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Daaci Yusufa a naba tsaa shairiya ge larde á Misera baɗemme, a ba shairiya ŋanna: Am duksa ilyeɓe ilyeɓire naza á Firawna. Sem vatena keni ta tsaa á ba ate una ŋanna. Sey ba fahe á liman‐aha palle una gevka atuge Firawna na. ");
INSERT INTO mfi_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Daaci njarinja Iserayiila‐aha am haha á Misera, am kwara á Gausan. Sharansha sleɗe‐aatare, tá aŋkwa á huya á ba an ndzeda, yanrteye jipu. ");
INSERT INTO mfi_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yawe á Yakubu am Misera, yawe kelaawa ju vuye. Am lauktu na a emtsa Yakubu wá, iva‐aara deremke an ku! ufadɗe ju vuye. ");
INSERT INTO mfi_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Am sarte na diyeddiye Yakubu am vuwa geni herzhe emtsa‐aara, a naba ɗante egdza‐aara Yusufa, a ba ŋane á elvan ge ŋane: Má ba jirire hayakihaya wá, magiyanmaga shaigerire antara jirire, heɗika am Misera áhuna ɗekiɗekki. Nawa fiyemfa erva á ŋa am dagave á sera‐aha‐aaruwa, ziyuze wada, ");
INSERT INTO mfi_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ma emtsanemtsa eksiteksa ƴaka am Misera áhuna, de zlaviyazlava am irekhya á eggye‐aha‐aaruwa. A eptsanaa jawapa Yusufa, a ba ŋane: Yá de magan ba seke una ka binaa ka na edda. ");
INSERT INTO mfi_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","A ba Yakubu: Sey má zakiyuze waɗa. A naba zanu waɗa na Yusufa. Am iga a una ŋanna maa, Iserayiila a naba gaavehe ate ire á egdera‐aara, ankwa á slafa we‐aara. ");
INSERT INTO mfi_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Am iga á una ŋanna wá, ta danaa labare ge Yusufa, geni lapika eddeŋara. Yusufa keni a eksetaa egdzara‐aara buwa, tara Aifrayim antara Manassa, ta duwa kerɗe. ");
INSERT INTO mfi_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ta de mbeɗanuhe ge Yakubu geni samsa egdze a ŋa Yusufa, aŋkwa ágashe a sawa ásezeŋa. A naba magaa dzaŋdzaŋire, zlahhe a tsetehe, a njehe ate egdera‐aara. ");
INSERT INTO mfi_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Damda Yusufa maa, a ba Yakubu á elvan ge ŋane: Dadaamiya Slekse a naba mariya ire‐aara ge iya am Luus am haha á Kanaana, a giyar barka. ");
INSERT INTO mfi_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","A ba ŋane á elvan ge iya: Yá gakvege ura kwakya jeba‐aara jipu, haha na keni yá de vaterte ge emnde á ŋa, á de gev naza‐aatare dem ba ge ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Daaci a ba ŋane zlaɓe adaliye á elvan ge Yusufa: Egdzara á ŋa buwa na ka yateraa am haha á Misera áhuna, tara Aifrayim antara Manassa, ba lauktu yá semsa ya ásezeŋa keni itare tá an ya na wá, itare ta ba kalkale antara Ruubain antara Simaun‐aaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Amá emnde na ka yateraa am iga‐atare na wá, emnde ŋanna wá, egdzara á ŋa. Tá an dza warata‐aatare aɗaba emnde buwa na. ");
INSERT INTO mfi_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Aɗaba am sarte na ya átira sa am Paddan‐Aram, a ƴaŋerar ba cekwaaŋgudi herzhaŋerameherzhe Aifrata wá, a naba emtsiyarhe ge Rahiilu emmeŋa. Daaci ya naba heɗehe emmeŋa am baráma Aifrata ŋanna, am haha á Kanaana. Aifrata ŋanna wá, tá ɗahana an Baytilaama kina. ");
INSERT INTO mfi_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","A ba am sane ŋanna maa, Iserayiila a naa egdzara á Yusufa, a ba ŋane: Una mu egdzara á ware? ");
INSERT INTO mfi_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusufa a ŋwanáne ge eddeŋara, a ba ŋane: Egdzara‐aaruwa na a vitaa Dadaamiya am Mtsera áhuna. A be eddeŋara: Satersa áse katafke‐aaruwa, yá gaterar barka. ");
INSERT INTO mfi_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Am sane ŋanna, Iserayiila gevge emgyegwe an tsaka ire, gulaagula ndzeɗa á ice‐aara jipu, á nanka ŋgelaama. Daaci Yusufa a daterhe egdzara-aara na ádekatefke‐aara, a halateremhe am huviye, a ŋateraahe takwalle. ");
INSERT INTO mfi_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Daaci a ba ŋane á elvan ge Yusufa: Ndza a tamanaa ware ganakini watse yá puwete ice‐aaruwa ate ka mazle‐aara. Amá vatena na wá, a naba jamimehe zlaɓe adaliye ge Dadaamiya antara ba egdzara á ŋa keni ya natema. ");
INSERT INTO mfi_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Daaci Yusufa a tsekwaterahe egdzara‐aara na ate sera‐aha a eddeŋara na, a kesle ugje am haha, wafke‐aara ba teppe ate haha. ");
INSERT INTO mfi_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Am iga a una ŋanna maa, a halaterte ge Yusufa egdzara na bukerɗe‐aatare ákatafke á Iserayiila. Aifrayim a eksanaa an naɗafa‐aara am nazlaɓa á lserayiila, Manassa a eksanaa an nazlaba‐aara am naɗafa á Iserayiila. A gante egdzara na ádezeŋara. ");
INSERT INTO mfi_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Iserayiila a pelese erva á naɗafa‐aara a fanem am ire ge Aifrayim, amá wá, kudere nane. Nazlaɓa‐aara keni a fanem am ire ge Manassa. diyaadiya tsa geni male ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Daaci a fantau ge gan barka-aara ge Yusufa, a ba ŋane: Yá aŋkwa á ŋala Dadaamiya na ndza tá ákatafke-aara tara eggyerwa Ibrahiima antara edderwa Isiyaaku, Dadaamiya na ni a tsufete shifa‐aaruwa sem vatena na, ");
INSERT INTO mfi_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","antara Malika na a tsufite am emtaŋkire baɗemme na, geni a gaterar barka ge egdzara na. Aɗaba barka-aatare, a keɗeka zhera‐aaruwa antara zhera á eggyerwa Ibrahiima ira zhera á edderwa Isiyaaku. A yaiterteya Dadaamiya, a hyairemhye am larde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Am sarte na Yusufa a naa eddeŋara a fanem naɗafa‐aara am ire ge Aifrayim ŋane higaaka dekiɗeki. A de ŋaa erva á eddeŋara na ganakini a janaaja am ire ge Aifrayim na, á fanemfa am ire ge Manassa. ");
INSERT INTO mfi_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","A ba ŋane á elvan ge eddeŋara: Estuwa ka edda! Nawa male una, fanemfa naɗafa á ŋa am ire ge ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Amá a naba kwalefhe ge eddeŋara, a be ŋane á elvan ge ŋane: Diyandiya egdze‐aaruwa, diyandiya baɗemme. Ŋane keni watse á de gev ura male, á de gev eddarge nalga ƴaikke. Amá wá, á de januje kudereŋara. A de januje kudereŋara an ƴaikkire, ŋane á de gev eddarge nalga‐aha kwakya. ");
INSERT INTO mfi_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Vacite ŋanna a gaterar barka, a ba ŋane am e!va‐aara: IserayiiIa‐aha baɗemme tá de ga barka an zhera á ŋa. Ta de ba: A gagvege Dadaamiya sake tara Aifrayim antara Manassa. A ganve estuwa Aifrayim male arge Manassa. ");
INSERT INTO mfi_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Am iga a una ŋanna maa, a ba ŋane á elvan ge Yusufa: naza‐aaruwa zlauzle mazle‐aara, yá de haraaka kwakya. Amá a tsufakurtsa Dadaamiya, a eptsakuraptsa zlaɓe adaliya á dem haha á eggye‐aha á kure. ");
INSERT INTO mfi_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Am haha ŋanna wá, ya vakte kwara á Sikaim ge ekka. Una ŋanna tá shanka egdzara mama‐aha á ŋa umele. Baaka arge tate ŋanna ɗekiɗeki am haha ŋanna baɗemme. Ndza ya lyiyanaa am erva á Amauri‐aha an katsakar amara gurma-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakubu a ɗetaa egdzara‐aara baɗemme, a ba ŋane á elvan ge itare: Sawmbare baɗemme jawammeje ázerwa, Nawa yá ɓalakurse nazu watse á magava ate kure á katafke. ");
INSERT INTO mfi_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Jawammeje, cenaucena nazu yá bakuma ya ba shagera, kwa egdzara‐aaruwa ya Yakubu. Cenaucena nazu yá ndaakura ya, ya eddekure Iserayiila: ");
INSERT INTO mfi_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ekka Ruubain wá, ka makaji‐aaruwa, ka hakuma‐aaruwa ba ka arge egdzara mama‐aha á ŋa baɗemme, aɗaba ka ndzeɗa‐aaruwa zuŋŋwe ba ka am sarte na yá an ndzeɗa á dawalire‐aaruwa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ká puwa sem aha seke ba yawe, ama wá, ká tsa iceka ire. Aɗaba ekka ka naba magiya nazena zlayeka ge iya, kwa naba nja amara palle á ŋwasha‐aha‐aaruwa. ");
INSERT INTO mfi_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Tara Simaun amara egdze a emmeoara Laiwi, itare ye‐aatare pane, ta emnde a garɗa. ");
INSERT INTO mfi_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ƴanaaƴa ervauŋɗe‐aaruwa sawari‐aatare, á ekseka ire-aaruwa dem jahava‐aatare ɗekiɗeki. Am ica ervauŋɗe‐aatare, ta ceɓa shifa á zaala kwakya. An sunu‐aatare ta badzanve shifa á dalau‐aha kwakya. ");
INSERT INTO mfi_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","A nyainyainvenyainye Dadaamiya ervauŋde‐aatare ŋanna, aɗaba kwakya kelaadire am huɗe‐aara, baaka zevarzire ázetare. Yá de tegese egdzara-aatare gergere kwakya am haha á Yakubu, yá de zaɗaxarvezaɗe an palpale am dagave á Iserayiila‐aha. ");
INSERT INTO mfi_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Ekka Yahuuda maa, ekka wá, egdzara mama‐aha a ŋa baɗemme tá de gala ba zhera á ŋa. Ká de gateraga ba ka an erva á ŋa kelaade‐aha á ŋa é katafke á na. Dete ba egdzara mama‐aha a ŋa keni, tá de gana ba itare ire á katafke á na ge ekka. ");
INSERT INTO mfi_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ekka Yahuuda‐aaruwa wá, ka egdze‐aamwa. Ka ba seke ervare na ni a sa am tate a tsagwaɗa dabba a kaamba, hyanhya hyuwa na. Ka egdze‐aaruwa ge iya! Má kezlakkezla ugje am haha seke áza ervare zlavakzlava, seke ba mukse á ervare, ware edda‐aara á de egjekja ge tsantetse na? ");
INSERT INTO mfi_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Zade á sleksire wá, á degasheka am huɗe á ha á Yahuuda ɗekiɗeki, hakuma á de nja á ba am erva á emnde‐aara, dem sarte na ma samsa edda á zade ŋanna an jirire, eddawna m larde baɗemme á de fansarfe na. ");
INSERT INTO mfi_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ŋane watse a se ŋguda ezzeŋwa‐aara an egdzere am inabauhi. Watse a reva kacakaca‐aara an mbazla á egdze a inabauhi, zane‐aara watse a revana an yawe á egdze a inabauhi ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ice‐aha‐aara á de nja á ba an deva kyaŋŋe ge mbazla á inabauhi, sera‐aha‐aara á de geva dzayye telle aɗaba uɓa. ");
INSERT INTO mfi_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Jabulaun maa, ŋane á de nja ate we á haye, tate á tsekwa pare á yawe-aha. Nakwe á haha‐aara ge ŋane á de shanaasha Sidaun. ");
INSERT INTO mfi_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakar wá, ŋane ezzeŋwa na ni ndzendzeɗa jipu na, á zlava am dale‐aha. ");
INSERT INTO mfi_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Be a naa tate ŋanna emtake ge puwansepuwe am huɗe‐aara, haha ŋanna keni snagera jipu wá, a naba gaa nahyapaihyape‐aara, ge sepa gwatame, a ganve ire‐aara nave. ");
INSERT INTO mfi_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan maa, ŋana wá, á de kwaratera ba ŋane emnde‐aara ba seke jeba‐aha umele am Iserayiila. ");
INSERT INTO mfi_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan, ŋane á garava an zahe na á zlava ate baráma, seke ba pushe na ni á zlava ate we á uŋŋule, a waa belse ate sera, a naba kezletaare ge eddawna ate iga a belsa ŋanna, an iga an iga, á sete haha na. ");
INSERT INTO mfi_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Saksage‐aaruwa, yá aŋkwa á fetare ate ka geni watse ká lyilyire. ");
INSERT INTO mfi_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gada maa, watse tá gwargwe emnde a za baráma, amá waîse á bakatera ba ŋane, tá de enzla ba zlahhe. ");
INSERT INTO mfi_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Amba á Asair wá, watse ɓaaka zlakta á ɗafa ɗekiɗeki. Haha ŋanna a de geɗeta emnde, watse ta ba seke slekse‐aha. ");
INSERT INTO mfi_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naiftalim maa, ŋane á garava an kaamba na ni gelgela jipu, zara‐aha na ta am huɗe á kaamba ŋanna ta zariya‐aha jipu na. ");
INSERT INTO mfi_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusufa keni maa, ŋana á garava an nafa na ni an dzeɓa ate we á haye, a ya egdzere shagera, á vala erva‐aha‐aara átarge riya bademme na. ");
INSERT INTO mfi_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Kelaade‐aha‐aara tá naba kata elva‐aara, ta naba danaa wava ta puwa gurme ate ŋane, ");
INSERT INTO mfi_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","amá ŋane tsatse degdege an gurme‐aara, erva‐aara á gyaigyaika ɗekiɗeki, aɗaba aŋkwa á melanumele suni na ŋane palaha á Iserayiila na, Dadaamiya Slekse na aŋkwa á kezlan ugje Yakubu. ");
INSERT INTO mfi_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","A melakumele Dadaamiya na aŋkwa á fansarfe eddeŋa na. A vakteva Dadaamiya Slekse barka na á hyana ŋane am yawe á sawa am huɗe á samaya antara barka na am yawe na á segashe am huɗe á haha na, antara barka na ni á vaterte ya ge ŋwasha na, amara uɓa na ta fateru ge egdzera. ");
INSERT INTO mfi_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Barka‐aha na á vakta eddeŋa wá, jauje ge barka‐aha na am huɗe á wa‐aha saɗaɗɗe na a zleka na antara am egdzar wa‐aha bademme. A tsekwanaatsekwa Dadaamiya barka‐aha ŋanna á setarge ekka Yusufa, ekka na jakateruje ge egdzar mama‐aha a ŋa baɗemme an malire na. ");
INSERT INTO mfi_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Bainjamaiŋ wá, ŋane á garave an indale na á ceɓa dabba‐aha. An eŋlya, á za dabba‐aha na á ceɓanaa ŋane, an icawaya á tega nazena a shanaa ŋane. ");
INSERT INTO mfi_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Kwaya ŋane emnde na watse tá gev jeba‐aha á Iserayiila kelaawa ju buwa. Eddetare a tsakaterse elva‐aha ŋanna, a gaterar barka. Barka ŋanna maa, a gater an palpale, ma ware‐aatare keni á ba an barka‐aara. ");
INSERT INTO mfi_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Am iga á una ŋanna baɗemme, Yakubu a ndaterse elva na ge egdzara-aara, a ba ŋane: Má emtsanemtsa ya, zlalanzlala ádeza eggy‐aha‐aaruwa wá, kwa de heɗiya am hwalakwa na am fahe á Aifruna ura Haiti. ");
INSERT INTO mfi_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","am Makpaila, á dam gedi‐aara ge Mamre na. Hwalakwa ŋanna, kwaye ndza a shekwanaa Ibrahiima antara fahe ŋanna baɗemme ge heɗa emtsa am huɗe‐aara. ");
INSERT INTO mfi_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Tara Ibrahiima ŋanna antara mukse‐aara Saraatu, tara Isiyaaku antara mukse‐aara Raibaika, baɗemme ta heɗatera á ba am tate ŋanna, ira Lee’a keni, ya heɗanaa ba iya an erva‐aaruwa á ba am tate ŋanna. ");
INSERT INTO mfi_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Fahe ŋanna antara hwalakwa na am huɗe‐aara na baɗemme an shekwa, ta shekwanaa am erva á Haiti‐aha. ");
INSERT INTO mfi_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Zlauzle am tsakatera elva na Yakubu ge egdzara‐aara, teŋelemme a zlavehe ate egdera‐aara, haaffe a puwese shifa wá, ɓaaka zlaazlala ádeza eggye‐aha‐ŋara á faya. ");
INSERT INTO mfi_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Daaci a duhe ge Yusufa á ba ate watsewatsire, a de mbaɗar ge eddeŋara na, ámbera á kyuwa á dem ice‐aara. ");
INSERT INTO mfi_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Daaci a ba ŋane á elvan ge dauktar-aha‐aara: Tsatsawanaatsatse vuwa á edderwa ba shagera an waye. Dauktar-aha na ta naba tsatsaa vuwa á Iserayiila an waye‐aha antara nazase‐aha gergere. ");
INSERT INTO mfi_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ate naɗe‐aatare, hare kul ufaɗe dauktar‐aha na tá tsatsa ba emtsa na an waye‐aha antara nazase‐aha gergere geni a sefka. Hare kul vuye kalkale emnde a Misera tá aŋkwa á kyuwa Yakubu. ");
INSERT INTO mfi_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Am sarte na zlauzla sarte a kyuwa Yakubu, a ba Yusufa á elvan ge waziri-aha á Firawna: Taslawa á kure, máki ɓashakuriɓasha wá, ndawanndaa ge Firawna: ");
INSERT INTO mfi_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Am sarte na zlaɓe an shifa edderwa, a ba ŋane sey ká de heɗiya am Kanaana. Sey ká ziyuze waɗa máki watse ká emmaga. Ya naba zanu waɗa ŋanna. Daaci kina wá, a viteva baráma, yá de heɗehe edderwa am hwalakwa na ni a tsatsanaa ba ŋane kashi‐aara am haha á Kanaana, lauktu watse yá sa. ");
INSERT INTO mfi_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","A be Firawna á elvan ge Yusufa: Ezzlala de heheɗa eddeŋa ate una ni a ndaaka ŋane na. ");
INSERT INTO mfi_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Daaci a tsetehe ge Yusufa, aŋkwa á dá eddeŋara na, á de heɗana am Kanaana. Ta daa á dabana waziri‐aha á Firawna antara male‐aha na tá am mba‐aara antara male‐aha á haha á Misera baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Tá aŋkwa emnde á Yusufa nanna baɗemme am itare antara egdzara mama‐aha-ŋara baɗemme ira emnde na tá am huɗe á há eddetare ŋanna baɗemme, jauka ura am kwara á Gausan ɗekiɗeki, sey ta ƴaa ba egdzara antara dabba-aha. ");
INSERT INTO mfi_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Kwakya emnde a ɓelsa antara emnde na tá an darkwa á teɗana ɓelsa, kwakya nalga na a daa puwa emtsa á Yakubu. ");
INSERT INTO mfi_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Daraada am laare Ataada am tate á weɗiŋe‐aha á emnde á ekse ŋanna ate iga a guwa Urdun á dem giɗe‐aara, ta naba fantau ge kyuwa Yakubu áhuwa á ba an ka kwara. Hare vuye kalkale Yusufa aŋkwa á kyuwa eddeŋara áhuwa. ");
INSERT INTO mfi_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Tá aŋkwa á zharaterzhara emnde a Kanaana na tá am laare Ataada ŋanna, a ba itare am dagave‐aatare: Kay! zlazlaɗa kyuwa ura á emnde a Misera. Aɗaba una ŋanna, ta fete zhera á tare ŋanna á katafke á Urdun: Awil‐Miserayim. Amaana: kyuwa á ura á emnde a Misera. ");
INSERT INTO mfi_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Egdzara á Yakubu magarananmaga ge eddetare ba seke una a katanaa ŋane a ndaternda na. ");
INSERT INTO mfi_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ta naba daa emtsa‐aara á dam larde á Kanaana, ta de heɗana am hwalakwa am fahe am Makpaila, fahe na ni ndza a shekwanaa Ibrahiima werre am erva á Aifruna ura Haiti, á dem geɗi á Mamre. ");
INSERT INTO mfi_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Hedareheda eddeŋara maa, Yusufa a naba eptsa sem Misera, ŋane, egdzara mama‐aha‐ŋara ira emnde na ta daa aɗabaterɗaba á de heɗa eddeŋara na baɗemme. ");
INSERT INTO mfi_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Am iga a emtsa á eddetare, a ba egdzara mama‐aha‐ŋara ge Yusufa am dagave‐aatare: Kina wá, eddemiya ɓaaka, emtsamtsa. Má banba Yusufa sey á pelsepele ate miya kelaadire na ndza mi maganta miya na wá, mi magana estara? ");
INSERT INTO mfi_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Daaci ta naba ɓela ura á deza Yusufa an labare na, a ba itare tá elvan ge nane: Nawa elva na a ndaaŋera eddeŋa am sarte na zlaɓe an shifa geni watse ŋá mbeɗakumbeɗe, ");
INSERT INTO mfi_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","a ba ŋane wá, naba zatervarze ge egdzara mama‐aha á ŋa, ƴateraarƴa kelaadire na ni ndza ta magaktaa itare na baɗemme. Daaci a be egdzara á Yakubu, tá elvan ge egdze a emmetare Yusufa: Kina wá, tasle á ŋa ƴaŋeraarƴe egdze a emmaye. Aɗaba kelaadire na ni ndza ŋa magakta ŋere na ba jire wá, naza tsaleka. Naba ƴaŋeraarƴe, aɗaba ŋere keni né aŋkwa á daba ba Dadaamiya na ni ndza a ɗabanaa eddeŋa na. Ba a cenaa una ŋanna Yusufa wá, a naba fantau ge kyuwa á ba an yawe á kyuwa. ");
INSERT INTO mfi_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Am iga a una ŋanna, ta duhe ba itare an ire‐aatare egdzara mama‐aha-ŋara na, reppe ta de kezle ugje á katafke‐aara, a ba itare tá elvan ge ŋane: Nawa ŋere ŋa nave‐aha á ŋa ámbarka á ŋa. ");
INSERT INTO mfi_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Amá a ba Yusufa á elvan ge itare: A wakurka lyawa ɗekiɗeki, iya ganafka Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ukkure wá, ndza kwa kwamaa magite kelaadire. Amá Dadaamiya a kwamaa eptsante kelaadire ŋanna, a ganve hairire ge eŋzlese emnde kwakya, ba kure keni kwa aŋkwa á nanna an ice á kure vatena. ");
INSERT INTO mfi_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Aɗaba una ŋanna, a gazleka ervauŋde á kure ɗekiɗeki, yá fakurufe hyema antara ŋwasha‐aha á kure ira egdzara á kure baɗemme. Yusufa a ekhyateraa estuwa ervauŋde, lauktu ta shetaa higa. ");
INSERT INTO mfi_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Daaci Yusufa a nja am Misera antara huɗe á há á eddeŋara baɗemme. Yawe á Yusufa baɗemme a magaa dermeke an kelaawa. ");
INSERT INTO mfi_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yusufa nanna egdzara á egdze‐aara Aifrayim dem eggye buwa. Emnde á Manasse maa, eggye‐aha‐ŋara ge buwire, egdzara á Makir a gelateraa ba ŋane, ta walete á ba am huvuye‐aara. ");
INSERT INTO mfi_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Am sarte na herzhe watse á emtsa Yusufa, a ba ŋane á elvan ge egdzara mama‐aha‐ŋara: lya wá, ya ɓaaka am dza á kure mazle‐aara, amá Dadaamiya aŋkwa antara kure ma vaatare keni. Á de tsakurta ba ŋane am larde na, á de dakura á dem larde na ni a baa watse á vaterte ge tara Ibrahiima antara Isiyaaku ira Yakubu, a zateru ba waɗa‐aara na. ");
INSERT INTO mfi_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","A be ŋane zlaɓe adaliye: Má tsekwaatsekwa Dadaamiya zakurvarze ge kure wá, taslawa á kure ƴawanka hyaihye‐aaruwa áhuna, dawanda am erva baɗemme. A faterar za waɗa, a ba ŋane: Zawiyuze waɗa ma watse kwá emmaga. Ta zanu wada na. ");
INSERT INTO mfi_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Á emtsa Yusufa am Misera wá, yawe‐aara dermeke an kelaawa. Ta tsekwanme emtsa‐aara am nazase, ta zlavanaahe am nakwati á nákwa am Misera ŋanna.");
INSERT INTO mfi_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Náwa *kergema á eggye-aha-ŋara ge Yaisu *Almasiihu. Ŋane ta yanaa am emnde á *Dawuda. *Dawuda keni wulfe á Ibrahima. ");
INSERT INTO mfi_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahima a yese Isiyaaku, Isiyaaku a yese Yakubu, Yakubu a yese Yahuda antara egdzara a mama-aha-ŋara. ");
INSERT INTO mfi_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda a yese tara Farais, antara Jara, a yateraa an Tamar. Daaci Farais a yese Haisruna, Haisruna a yese Aram, ");
INSERT INTO mfi_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram a yese Aminadabu, Aminadabu a yese Nasanu, Nasanu a yese Salmuna, ");
INSERT INTO mfi_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmuna a yese Bauyais, a yanaa an Rahab. Bauyais a yese Aubaid, a yanaa an Rut, Aubaid a yese Yaisa, ");
INSERT INTO mfi_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yaisa a yese *Dawuda, ba ŋane una gevge slekse na. *Dawuda a yese Suleymanu, a yanaa an mukse na ndza mukse á Uriya na. ");
INSERT INTO mfi_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Suleymanu a yese Raubawam, Raubawam a yese Abiya, Abiya a yese Asa, ");
INSERT INTO mfi_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa a yese Yusafat, Yusafat a yese Yauram, Yauram a yese Ujiya, ");
INSERT INTO mfi_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ujiya a yese Yauwatam, Yauwatam a yese Akas, Akas a yese Haijaikiya, ");
INSERT INTO mfi_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Haijaikiya a yese Manasa, Manasa a yese Amaus, Amaus a yese Yusiya, ");
INSERT INTO mfi_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yusiya a yese Yaihukiya antara egdzara a mama-aha-ŋara am sarte na ta kyaa emnde a *Iserayiila á dem *Babila na. ");
INSERT INTO mfi_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Am iga á una ŋanna maa, Yaikuniya a yese Salatiyail, Salatiyail a yese Jauraubabila, ");
INSERT INTO mfi_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jauraubabila a yese Abihuda, Abihuda a yese Ailiyakim, Ailiyakim a yese Ajaura, ");
INSERT INTO mfi_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ajaura a yese Sadauka, Sadauka a yese Akim, Akim a yese Ailihuda, ");
INSERT INTO mfi_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ailihuda a yese Ailiyajaaru, Ailiyajaaru a yese Mattan, Mattan a yese Yakubu, ");
INSERT INTO mfi_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakubu a yese Yusufa zhele á Maari na a yaa Yaisu na tá ɗahaná an *Almasiihu. ");
INSERT INTO mfi_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Daaci kezlakula á jeba-aha ŋanna, a fetuwe áte Ibrahima sem zamane á *Dawuda, á maga jeba kelaawa ju ufaɗe. Fantau áte *Dawuda sem zamane na ta kyaa emnde a *Iserayiila á dem *Babila, jeba kelaawa ju ufaɗe. Tsante am zamane ŋanna, sem sarte na ta yaa Yaisu *Almasiihu keni, jeba kelaawa ju ufaɗe. ");
INSERT INTO mfi_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Náwa a sawa estuwa laukta ta yese Yaisu *Almasiihu. Emmeŋara Maari wá, á shebaná ba Yusufa. Ba lauktu á danaada Yusufa á dem mba-aara keni, kerteŋ Maari lyemlye huɗe an hákuma á Sheɗekwe Cuɗeɗɗe. ");
INSERT INTO mfi_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Daaci zhele-aara Yusufa maa, ŋane dzayye ervauŋɗe-aara, wayeteka ɗekiɗeki ganakini á ɓalaná áza emnde, á kátá ƴanƴa á ba an nasherire. ");
INSERT INTO mfi_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Daaci ba ŋane keni átira dzama una ŋanna, a naba jesaarhe ge malika á Yaakadada á katafke-aara am shene, a ba ŋane á elvan ge ŋane: «Yusufa egdza á *Dawuda, a waŋka lyáwá ge gá mukse á ŋa Maari. Aɗaba egdze na am huɗe-aara na wá, a lyanmá ba Sheɗekwe Cuɗeɗɗe an hákuma-aara. ");
INSERT INTO mfi_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Á de yá egdzere zhele, ká de faná zhera á Yaisu, aɗaba á de lya emnde-aara am haypa-aha-aatare.» ");
INSERT INTO mfi_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Baɗemme á una ŋanna, aŋkwa á magava á ba áte una ndza a ndahanaa Yaakadada á kya an we á nabi na kalkale. Aɗaba a ba ŋane: ");
INSERT INTO mfi_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Náwa watse á shá huɗe gyaale na zlaɓe diyaaka zhele na, á de yá egdzere zhele, zhera-aara wá, tá de ɗahaná an Aimanuwail.» Zhera ŋanna wá, á kátá ba: Dadaamiya aŋkwa antara miya. ");
INSERT INTO mfi_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Daaci tsetsa Yusufa am háre, a magán ba seke una a bannaa malika á Yaakadada na. A naba gá Maari ge mukse-aarire. ");
INSERT INTO mfi_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Amá Yusufa njaaka antara Maari ɗekiɗeki seke tara zhele an mukse, dem sarte na a yese egdze-aara egdzere zhele na. Daaci Yusufa a fete zhera á egdzere Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Am sarte na yareya Yaisu am Baytilama, am kwara á Yahudiya, am zamane á *Hirudus, ta naba semhe ge emnde a ilmu á sem Urusaliima, ta sawa á sa am geɗi. ");
INSERT INTO mfi_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","A ba emnde a ilmu ŋanna: «Áma ŋane slekse á Yahudiya-aha na ta yán ba herzhe na? Aɗaba naŋeránna terlyakwa-aara á sa am geɗi. Aɗaba una ŋanna ŋa se kezlan ugje.» ");
INSERT INTO mfi_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ba a cenaa una ŋanna sleksu *Hirudus, ba palle a názu á enndaha keni ɓaaka. Baɗemme á emnde a Urusaliima diyarka názena tá ndahaná itare. ");
INSERT INTO mfi_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Daaci sleksu *Hirudus a naba jatermaare ge male-aha á *liman-aha, antara malum-aha na tá am larde-aara baɗemme, a ndavateruhe elva, a ba ŋane á elvan ge itare: «Ate una am wakita á Dadaamiya mu, ta baa watse tá yáná áma ŋane *Almasiihu?» ");
INSERT INTO mfi_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ta ŋwanante, a ba itare: «Am Baytilama, am kwárá á Yahudiya. Aɗaba a bá nabi á Dadaamiya áte elva ŋanna: ");
INSERT INTO mfi_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Ekka Baytilama am kwárá á Yahudiya wá, gakefka cekwa am ekse-aha na tá am Yahudiya ɗekiɗeki. Aɗaba watse á jesaare am ka slekse ƴaikke na watse á ŋáná ŋane larde-aaruwa *Iserayiila.” » ");
INSERT INTO mfi_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Daaci sleksu *Hirudus a naba ɗante emnde a ilmu na an nasherire, ta shanuwa itare jirire á sarte na ni a jesaara terlyakwa átekwa na. ");
INSERT INTO mfi_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","A ɓelaa ba itare ŋanna zlaɓe ádaliye slekse á dem Baytilama, a ba ŋane á elvan ge itare: «Dawmbare, de tatayawtátaya egdze ŋanna ba shagera. Máki shakuránsha wá, sawmbare mbeɗawiyumbeɗe labare, iya keni yá de kezlan ugje.» ");
INSERT INTO mfi_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Daaci cenarvaacena emnde a ilmu elva na a baternaa slekse, lauktu ta zlala. Am sarte na tá aŋkwa á zlala maa, tá zhárá ba terlyakwa na ndza ta zharanaa á sawa am geɗi na, aŋkwa á zlala á katafke-aatare. Ba daada terlyakwa ŋanna arge sleɗe na ni aŋkwa egdzere átekwa na wá, a naba tsaahe mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ba ta naa terlyakwa na tsaatse, ta naba higete an ervauŋɗe-aatare baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Daaci ta naba demhe á dem bere, ta de beraa egdzere áŋwaslire, antara Maari emmeŋara, daaci ta kezlaa ugje am haha, ta kezlanaa ugje na ge egdze ŋanna. Ta palaa kazlaŋa-aatare, ta vante sadake á dindar, antara ɗagwala á názase, umele keni yawyawe-aara am kudera ge egdze ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Am iga á una ŋanna maa, Dadaamiya a naba fatermaa am vuwa ge emnde a ilmu na am shene, ganakini a eptsarka á deza *Hirudus mazla-aara. Daaci ta naba eksetaa baráma-aatare umele, ta naba dá-aatare á dem larde-aatare. ");
INSERT INTO mfi_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Am sarte na daraada emnde a ilmu, a naba tsekwehe ge malika á Yaakadada á deza Yusufa am shene, a ba ŋane á elvan ge ŋane: «Tsetse ba kina an egdzere ira emmeŋara, ezzlala á dem Misera dem sarte na watse yá bakaná ya ganakini sawa á sá. Aɗaba watse *Hirudus á tataya egdzere ge já shifa-aara.» ");
INSERT INTO mfi_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Daaci a naba tsetehe ge Yusufa á ba an vaƴiya ŋanna an egdzere, ira emmeŋara, a naba zlala an itare á dem Misera. ");
INSERT INTO mfi_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ta de njaa am Misera dem sarte á keɗa *Hirudus. Una ŋanna a magava ba kalkale antara názena ndza a ɓalanaa Yaakadada á kya an we á nabi-aara. Aɗaba a ba ŋane: «Egdza-aaruwa wá, watse yá ɗahaná á sa am Misera.» ");
INSERT INTO mfi_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Am nanna sleksu *Hirudus ganakini emnde a ilmu magarka áte una a katanaa ŋane, a naba jehe ge ervauŋɗe, a ba ŋane, a ceɓarceɓa egdzar zála baɗemme am Baytilama, antara am kwárá á ekse-aatare baɗemme. A ba ŋane, a ceɓarceɓa egdzara na zlaɓe sharnaaka yawe bubuwa na, antara ba emnde na sharnaasha yawe bubuwa keni baɗemme. Ba kelaa egdzara na ta yateraa am sarte na ni a jesaara terlyakwa áte una ta se kwaransaa emnde a ilmu na a jaruka an shifa ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Daaci una a gevaa ba názena ndza a ɓalanaa nabi Yairaimiya werre na. A ba ŋane: ");
INSERT INTO mfi_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Njaanja hula am Rama, aŋkwa kyuwa antara ɗakwa á ba an ká kwárá. Rashail aŋkwa á kyuwa egdzara-aara, wayaaka tá ekhyaná ervauŋɗe ɗekiɗeki, aɗaba ta ɓaaka egdzara-aara an shifa.» ");
INSERT INTO mfi_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Am sarte na emtsamtsa sleksu *Hirudus, a naba tsekwe ge malika á Yaakadada á de katafke á Yusufa am Misera am shene. ");
INSERT INTO mfi_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","A ba ŋane á elvan ge ŋane: «Ettsetse, eptseptsa an egdzere antara emmeŋara á dem *Iserayiila. Aɗaba emnde na ndza tá kátá shifa á egdzere na tá ɓaaka an shifa mazla-aara.» ");
INSERT INTO mfi_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Daaci a naba tsetehe ge Yusufa antara egdzere ira emmeŋara, ta naba sá-aatare á sem *Iserayiila. ");
INSERT INTO mfi_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Amá cenáncena Yusufa ganakini Arkilawus egdza á sleksu *Hirudus demda am sleksire á eddeŋara, ge kwárá larde á Yahudiya, jaaja lyawa ge de njá am larde ŋanna mazla-aara. Am jaaja lyawa ŋanna, Dadaamiya a naba kwaranse názena á maganá ŋane am shene. ");
INSERT INTO mfi_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Daaci a maganaa á ba áte una ŋanna lauktu a de nja am Nasarátu am kwárá á Galili na. Una ŋanna, gevge á ba áte una ta ndahanaa nabi-aha werre. A ba itare: «Watse tá ɗahaná an ura Nasarátu.» ");
INSERT INTO mfi_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Shekwaashekwa duniya maa, a naba jesaarehe ge Yuhanna slemaga baptisma, a fantau ge ɓálá waazu am kaamba a Yahudiya. ");
INSERT INTO mfi_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","A ba ŋane am waazu-aara: «Magaumága tuba, aɗaba herzhapteherzhe sarte na ni emnde tá njá am *kwárá á Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yuhanna ŋanna wá, nabi Aisaya ndza a enndahá elva-aara, a ba ŋane: «Aŋkwa ura á ɓala elva am kaamba, a ba edda-aara: Tsatsawanaatsatse uŋŋule ge Yaakadada, tsawanaatse baráma-aara, a gevge ba ndeɗɗe.» ");
INSERT INTO mfi_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Am sarte ŋanna wá, Yuhanna ndza a tsekwa naŋgyuwe na ta hanaa an úgje á ezlegwame, ndza á ŋguɗa ba gwagwa. Náza za-aara keni maa, á za ba iwe, antara nama. ");
INSERT INTO mfi_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Daaci emnde a Urusaliima, antara emnde na tá am kwárá á Yahudiya baɗemme, antara emnde a ekse-aha na ta herherzhe an guwa á Urdun na baɗemme ta sesehe, ta sezeŋara. ");
INSERT INTO mfi_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Emnde ŋanna ta naba sanse haypa-aha-aatare, ta magaa tuba. Daaci Yuhanna keni a naba baraterve am guwa á Urdun. ");
INSERT INTO mfi_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Am nanna Yuhanna ganakini tá aŋkwa á sawa *Farisa-aha, antara *Saduki-aha ásezeŋara kwakya, tá se ndavanu baptisma, a ba ŋane á elvan ge itare: «Egdzara á kelaade-aha na, a bakurnaa ware ganakini magaumága tuba, watse kwá de eŋzleseŋzle am názena á de magaterná Dadaamiya ge emnde na tá aŋkwa am ervauŋɗe-aara na? ");
INSERT INTO mfi_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Magaumága kure názena ni tá diyeddiye átekwa ganakini kure wá, ƴakuránƴa mága á kure werre, magakurnaamaga tuba. ");
INSERT INTO mfi_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bawánka mazla-aara am ire á kure ganakini miya wá, ma egdzara á Ibrahima miyenne, ázara lámbe á miya. Yá bakurá ba jirire: Ba nákwá-aha na náwa ŋane na keni, Dadaamiya an hákuma á gaterve egdzara á Ibrahima. ");
INSERT INTO mfi_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ba kina keni á ba an tsatsa zlaugba ge ɗatsa náfá-aha na ni tá yeka egdzere na. Daaci baɗemme á náfá na ni á yeka egdzere emtake na wá, tá icese antara uksuwe-aara baɗemme, tá epshupshe an kárá. ");
INSERT INTO mfi_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yá aŋkwa bakurá ba jirire: iya wá, yá aŋkwa á magakurá baptisma an yawe wá, ba ge mara tuba á kure, ganakini magakuraamaga tuba. Amá aŋkwa ura á sawa am iga-aaruwa, ba kina keni aŋkwa á ba am dagave á kure wá, ŋane watse á magakurá baptisma an Sheɗekwe Cuɗeɗɗe, antara an kárá. Edda-aara ŋanna wá, an hákuma ba ŋane arge iya, ba ge slesaɗanse kimake am sera keni hyanefka ya ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ŋane wá, aŋkwa á sawa an kazlaŋa a fáhá duksa-aara am erva, á se fahese hiya-aara am hyaihye. Daaci watse á puweme hiya am kuvere-aara, amá hyaihye wá, watse á fante kárá na á emtseka ɗekiɗeki na.» ");
INSERT INTO mfi_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Daaci am sarte ŋanna maa, a naba tsetehe ge Yaisu á sa am Galili, a seza Yuhanna áte we á guwa á Urdun, a se ndavanu baptisma ge Yuhanna. ");
INSERT INTO mfi_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Amá á kátá maŋka Yuhanna. A ba ŋane á elvan ge ŋane: «Iya maa, yá kátá ká maginá ka baptisma ni, ká se ndaviwa ka baptisma ge iya?» ");
INSERT INTO mfi_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","A ba Yaisu á elvan ge ŋane: «Eksaareksa ka á ba an higa. Aɗaba baráma-aara ba estuwa, lauktu mi maganaamaga názena á kataná Dadaamiya.» Daaci a naba eksaarhe ge Yuhanna, ");
INSERT INTO mfi_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","a maganaa baptisma. Sessa Yaisu am yawe wá, a naba wertehe ge samaya wá, Yaisu á zhara ba aŋkwa á tsekwa Sheɗekwe á Dadaamiya á setarge ŋane ba seke takala, a se tsekwaa áte ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Cekwaaŋguɗi wá, tá cená kwárá á sa am samaya, a ba ŋane: «Ba ŋane una Egdza-aaruwa, wayanwaya jipu, baɗemme á higa-aaruwa á ba áte ŋane.» ");
INSERT INTO mfi_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Am iga á una ŋanna maa, Sheɗekwe á Dadaamiya a naba daa Yaisu á dem kaamba ganakini á de badaná Shaitaine. ");
INSERT INTO mfi_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yaisu a de magaa háre kul ufaɗe am ndera áhuwa, vaƴi vaciyeka zawka duksa. Am iga á una ŋanna maa, a naba ŋanaahe ge waya mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Daaci a duhe ge slekeɗa emnde ádezeŋara, a ba ŋane á elvan ge ŋane: «Máki ka ba *Egdza á Dadaamiya wá, bateránba ge nákwá-aha na a nyarefnye ɗafa ká ezza.» ");
INSERT INTO mfi_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","A ŋwanante ge Yaisu, a ba ŋane á elvan ge ŋane: «Aŋkwa an puwa am wakita á Dadaamiya, a ba ŋane: “Ura á njá an shifa aɗaba ɗafeka palle, amá á fanemá elva-aha na a ndahesaa Dadaamiya baɗemme na shifa am vuwa.” » ");
INSERT INTO mfi_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Shaitaine a naba zlala antara ŋane á dem huɗe á berni cuɗeɗɗe, ta de ɗaltaa antara ŋane áte ire á *mashidi ƴaikke, ");
INSERT INTO mfi_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","a ba ŋane á elvan ge ŋane: «Máki ka ba *Egdza á Dadaamiya wá, naba mbeɗanaambeɗa ire á ŋa á dem áhá. Aɗaba aŋkwa an puwa am wakita á Dadaamiya, a ba ŋane: “Dadaamiya á de puwa malika-aha-aara, tá de cuwáká á ba am erva, ganakini ká janvaarka ma ba ge sera á ŋa keni áte nákwa.” » ");
INSERT INTO mfi_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Una keni a naba ŋwanante ge Yaisu, a ba ŋane á elvan ge ŋane: «Aŋkwa an puwa zlaɓe ádaliye am wakita á Dadaamiya, a ba ŋane: “Badeka Yaakadada, Dadaamiya á ŋa ɗekiɗeki.” » ");
INSERT INTO mfi_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Shaitaine a dánhe zlaɓe ádaliye á dete ire á wa umele aŋkwa, wa ŋanna slaɗɗe jipu, a maranaa ƴaikkire na aŋkwa am huɗe á duniya na baɗemme, antara ŋgahire-aara baɗemme á sáhuwa. ");
INSERT INTO mfi_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Daaci a ba ŋane á elvan ge Yaisu: «Máki kezlakiyaakezla ugje, ká ŋala ázerwa wá, yá vakteva duksa-aha ŋanna ka nanaa ka na baɗemme.» ");
INSERT INTO mfi_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","A ba Yaisu á elvan ge ŋane: «Ekka wá, ka Shaitaine ezzlálá áhuna. Aŋkwa an puwa am wakita á Dadaamiya, a ba ŋane: “Sey ká kezlan ugje ba ge Yaakadada, Dadaamiya á ŋa palle, ká ŋala á ba ázeŋara palle.” » ");
INSERT INTO mfi_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mazla-aara a ƴanhe ge Shaitaine áte una ŋanna. Am sarte ŋanna maa, ta semhe ge malika-aha á Dadaamiya, ta se maganaa slera. ");
INSERT INTO mfi_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Cenancena Yaisu ganakini ŋguɗareŋguɗa Yuhanna am daŋgay maa, a naba tsetehe áhuwa, a dem Galili. ");
INSERT INTO mfi_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Njaaka ŋane am Nasarátu na mazla-aara, kwaye a de nja am Kafarnahum. Ekse ŋanna áte we á guwa á Galili ŋanna. Kafarnahum ŋanna wá, áte nákwa á kwárá á Jabulaun antara kwárá á Naiftalim. ");
INSERT INTO mfi_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","An una ŋanna wá, gevge elva na ndza a ndahanaa nabi Aisaya werre na. Aɗaba a ba ŋane: ");
INSERT INTO mfi_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Am kwárá á tara Jabulaun antara Naiftalim, antara ekse-aha na tá am ndaŋŋire á háye á Galili na baɗemme, an ekse-aha na tá á katafke á Urdun, ira am Galili á emnde na garevka Yahudiya-aha na, ");
INSERT INTO mfi_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","baɗemme á emnde na ni tá am tabeɗammire na, tá de nanna parakkire ƴaikke. Emnde ŋanna tá njá am sleɗe tabeɗamme jipu, shifa-aatare ba paihyhye na, watse á shateraasha parakkire ƴaikke.» ");
INSERT INTO mfi_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","A fantau á ba am sarte ŋanna Yaisu ge bálá waazu. A ba ŋane á elvan ge emnde: «Magaumága tuba. Aɗaba samsa sarte á njá am *kwárá á Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Daaci Yaisu a ɗaba we á guwa á Galili wá, a naa egdzar mama buwa, tara Simaun, ŋane una tá ɗahaná an Piyer, tá an egdza emmeŋara Andarawus. Tá aŋkwa á puwa narre-aatare á dem yawe, aɗaba itare ta emnde a sluwa kelfe. ");
INSERT INTO mfi_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Daaci a naba ɗaterɗáhá Yaisu: «Sawmbare ɗabawiɗába, yá gakurvege emnde a jaha emnde á sem sera-aaruwa, ba seke má tá jahava kelfe-aha á dem narre á kure,» a ba ŋane á elvan ge itare. ");
INSERT INTO mfi_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ba watsewatse ta naba puwanve narre-aatare á ba áhuwa, ta ɗaba Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ta zlalete ba cekwaaŋguɗi á de katafke wá, Yaisu a naa egdzar mama umele ádaliye ta buwa, egdzara á Jaibaidaiyus, tara Yakuba, tá an egdza emmeŋara Yuhanna. Antara ba eddetare keni aŋkwa ázetare, tá am paare á yawe, tá aŋkwa á tsatsa narre-aatare. Daaci a naba ɗaterɗáhá Yaisu itare keni. ");
INSERT INTO mfi_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ba watsewatse, itare keni ta naba ƴaa paare, antara eddetare áhuwa, itare, ta ɗaba Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Daaci Yaisu a jem ɗába am kwara á Galili baɗemme, a magateraa waazu ge Yahudiya-aha am mashidi-aha-aatare. Waazu ŋanna wá, waazu á labare á higa, ganakini emnde tá njá á ba am *kwárá á Dadaamiya mazla-aara. Emnde na ta lapika-aha, antara ŋgurƴekwe-aha, a mbateraahe baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Daaci ta hyanme labare-aara am sleɗe baɗemme am larde á Siriya. Baɗemme á emnde na ni aŋkwa á magaterá palasa lapikere gergere, ta sateraa áseza Yaisu. Emnde na á wáterá tauraurau, emnde na tá an shaitaine, antara emnde a ŋgurƴekwe, baɗemme á emnde na ni ta lapika-aha na, a mbateraahe. ");
INSERT INTO mfi_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kwakya nalga na a ɗaba Yaisu. Emnde na ta sawa á sá am Galili, emnde umele ta sawa á sá am ekse na tá ɗahaná an ekse kelaawa na, antara emnde na ta sawa á sá am Urusaliima antara Yahudiya baɗemme, ira emnde a ekse-aha na tá á katafke á Urdun na baɗemme ta ɗaba Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yaisu nanna nalga á emnde ŋanna maa, a ɗalete áte wa, a de njehe. Ta ɗabem ge pukura-aha, ta duhe ádezeŋara. ");
INSERT INTO mfi_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Daaci a fantau ge tsakateraa elva áhuwa, a ba ŋane á elvan ge itare: ");
INSERT INTO mfi_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Higa ƴaikke ge emnde na ni diyardiya ba itare keni am ire-aatare ganakini hyarepka ba názara keni áza Dadaamiya. Aɗaba tá de njá antara Dadaamiya am ƴaikkire-aara. ");
INSERT INTO mfi_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Higa ƴaikke ge emnde na tá an yawe á kyuwa am ice kina, aɗaba watse Dadaamiya á de halaterse yawe á kyuwa am ice. ");
INSERT INTO mfi_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Higa ƴaikke ge emnde na tá aŋkwa á maga kemaarire, aɗaba tá de shá sleɗe na a ba Dadaamiya watse á vaterteva na. ");
INSERT INTO mfi_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Higa ƴaikke ge emnde na tá an wedera á mága jirire á Dadaamiya jipu, aɗaba Dadaamiya á vaterteva ge itare keni názena á kataná ervauŋɗe-aatare. ");
INSERT INTO mfi_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Higa ƴaikke ge emnde a mága zevarzire, aɗaba Dadaamiya á de zatervaareze ge itare keni. ");
INSERT INTO mfi_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Higa ƴaikke ge emnde na an bárá ervauŋɗe-aatare, aɗaba watse tá nanna Dadaamiya á ba an ice-aatare. ");
INSERT INTO mfi_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Higa ƴaikke ge emnde na ni tá melaterá itare emnde a dágala, aɗaba tá de ɗahaterá an egdzara á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Higa ƴaikke ge emnde a shá zlaɗa aɗaba ta magaa názena á kataná Dadaamiya, aɗaba watse tá de njá antara Dadaamiya am ƴaikkire-aara. ");
INSERT INTO mfi_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Higa ƴaikke ge kure má tá aŋkwa á zlazlakurzlázle emnde, má tá fákurá áte ŋguɗiyire, tá aŋkwa á tsaka elva a mándzawe áte kure aɗaba kwa emnde-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Máki tá aŋkwa á magakurte una-aha ŋanna wá, higa ƴaikke ge kure, jákurja geɗa. Aɗaba laɗa á kure kwakya jipu am samaya. Nabi-aha werre keni ndza ta magaterán ba estuwa.» ");
INSERT INTO mfi_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Ba názena ni á magaterná elleŋa ge emnde am duniya na wá, ba kure una kwa elleŋa ge duniya. Amá máki elleŋa ŋanna ɓaaka ɗaŋɗaŋire-aara mazla-aara mu, tá maganá uwe, ganakini á gevge ɗaŋɗaŋe zlaɓe ádaliye? Ɓaaka pute ɗekiɗeki. Máki estuwa, ɓaaka nampire-aara, sey ba tá eppuwa á degashe, tá payaná emnde an sera. ");
INSERT INTO mfi_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Zlaɓe ádaliye, ba kure una kwa parakkire ge duniya, kwa ba seke berni na ni áte ire á gávaye, ma á sawa áme keni tá zhará ba ŋane na. ");
INSERT INTO mfi_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Zlaɓe ádaliye, kwa ba seke kárá á fanus. Máki mbarantembe kárá á fanus wá, tá uŋmbarka tasa, sey tá zleŋelaná áte tate-aara, ganakini á maraterá parakkire ge emnde na tá am huɗe á bere ŋanna baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ba duksa palle ge kure keni. Kwa parakkire á duniya. Marawateránmárá parakkire á kure ge emnde baɗemme. A naránna emnde shagerire na kwá maganá kure, lauktu tá de gálá Eddekure Dadaamiya am samaya.» ");
INSERT INTO mfi_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Bawánka am ire á kure, ganakini ya se mbeɗaa shairiya-aha á Dadaamiya na a sanaa Muusa na, bi ya se mbeɗaa elva-aha na ta kwaratersaa nabi-aha werre ge emnde. Amá ya se palateraa ba jirire á duksa-aha ŋanna ge emnde, ya se ganvege. ");
INSERT INTO mfi_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yá ndaakur ba jirire: Ɓaaka duksa na á shekwaashekwa seke tara samaya antara haha. Amá tá zlauzle itare; ba egdza elva cekwaaŋguɗi keni á eblyantaaveka ge názu am *tawraita, sey má gevge baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yá bakurná aɗaba una ŋanna: Ma ware una a epsawaa ba egdza duksa am shairiya-aha á Dadaamiya, bi a kwaraterse epsawa shairiya á Dadaamiya ge emnde, á de gevá kataliya ba ŋane am *kwárá á Dadaamiya. Amá edda una ni aŋkwa á fansaarfe ge shairiya-aha á Dadaamiya, ámbera á kwaraterse ge emnde geni a faransaarefe keni na wá, watse male ba ŋane am *kwárá á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yá bakurá ba jirire: Kwá demka am zlanna á Dadaamiya ɗekiɗeki, máki jakurateruka ge malum-aha, antara *Farisa-aha an mága názena á kataná Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Kwa cenan vateneka ganakini a ba Dadaamiya á elvan ge eggye-aha: “Jauka shifa. Ma a janaa ware shifa keni á de ŋezleka am shairiya.” ");
INSERT INTO mfi_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Amá iya wá, yá bakurá ba jirire: Ma a ŋanaa ware egdza emmeŋara am ervauŋɗe keni, á dem shairiya. Ma a bannaa ware ge egdza emmeŋara “Ɓaaka eŋkale á ŋa”, edda-aara á dem shairiya ƴaikke. Ma a bannaa ware ge ura “Ká an shaitaine”, edda-aara á dem kárá á jahanama. ");
INSERT INTO mfi_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Aɗaba una ŋanna, máki ka sanaa sadake á ŋa ge Dadaamiya, amá á ba á katafke á Dadaamiya ŋanna wá, ka naba yehete ganakini aŋkwa duksa ka maganta ka ge egdza emmeŋa wá, ");
INSERT INTO mfi_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","naba ƴanƴa sadake á ŋa ŋanna á ba áhuwa, de melawemela emtsaaɗe antara egdza emmeŋa, lauktu ká se vante sadake á ŋa ge Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Máki aŋkwa sledágala á ŋa watse á dáká á dem shairiya wá, edduwa ba watsewatse ádezeŋara, de melawemele arge una ni á de fakem am erva ge narkali-aha. Narkali-aha, itare tá de fakem am erva ge sawji-aha, sawji-aha tá dáka á ba á dem daŋgay. ");
INSERT INTO mfi_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yá baká ba jirire: Watse ɓaaka segashe á ŋa áhuwa ɗekiɗeki, ma a juwa ba shishi-aara keni, sey má pelaksepele baɗemme.» ");
INSERT INTO mfi_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Kwa cenán vateneka, ganakini a ba wakita á Dadaamiya: “Maŋka gwardzire.” ");
INSERT INTO mfi_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amá iya wá, yá bakurá ba jirire: Ma ware una a zharaa mukse, wayetewáyá am ervauŋɗe-aara, maganaamaga gwardzire an mukse ŋanna am ervauŋɗe-aara. ");
INSERT INTO mfi_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Daaci má aŋkwa á mbeɗáká á dem haypa ice á naɗafa á ŋa wá, naba sansese ice ŋanna, eblyanveblye ƴiƴiye an ka. Ambáne ká keɗá ba duksa palle áte vuwa á ŋa, arge una ni iricaŋa baɗemme ká dem kárá á jahanáma na. ");
INSERT INTO mfi_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Zlaɓe ádaliye, má aŋkwa á mbeɗáká á dem haypa erva a naɗafa á ŋa wá, naba icica erva ŋanna, eblyanvebelye ƴiƴiye an ka. Ambáne ká keɗá ba uɓiya palle áte ka, arge una ni iricaŋa baɗemme ká dem kárá á jahanáma na.» ");
INSERT INTO mfi_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Aŋkwa an puwa am wakita á Dadaamiya ganakini má zhele á ica nika an mukse-aara wá, sey á vante nalmesheri á ica nika ŋanna am erva ge mukse, ganakini a ɓelanaa ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Amá iya wá, yá bakurá ba jirire: Ma ware una a ɓelaa mukse-aara, wallá a eksevaa am gwardzireka, uweka, máki mukse na de gaaga zhele umele wa, a eblyanmaa ba ŋane am gwardzire. Ma a ganaa ware mukse na a segashe am mbá á zhele keni, a magaa ba gwardzire.» ");
INSERT INTO mfi_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Kwa cenán vateneka ganakini a ba Dadaamiya á elvan ge eggye-aha: “Zawka waɗa á fida, zawza ba waɗa á jirire á katafke á Dadaamiya.” ");
INSERT INTO mfi_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Amá iya wá, yá bakurá ba jirire: Zawka waɗa ɗekiɗeki ma an uwe keni. Ma an samaya keni zawka waɗa. Aɗaba una ŋanna tate á njá á Dadaamiya an sleksire-aara. ");
INSERT INTO mfi_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma an haha keni zawka waɗa. Aɗaba haha tate á puwa sera á Dadaamiya. Ma an Urusaliima keni zawka waɗa. Aɗaba aŋkwa Slekse ƴaikke am berni ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma á ba an ire á kure keni zawka waɗa ɗekiɗeki. Aɗaba kure, ba úgje á ire á kure palle keni kwá taa maganaaka, ma kuliya, ma úgje daŋŋwe keni. ");
INSERT INTO mfi_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Elva á kure ge kure wá, a tsatse á ba áte duksa palle. Ma “aꞌaa” keni, ba aꞌaa. Máki “ane” á bá kure keni, ba ane. Máki jauje am una ŋanna wá, ba slera á Shaitaine.» ");
INSERT INTO mfi_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Zlaɓe ádaliye, kwa cenán vateneka ganakini a ba wakita á Dadaamiya: “Ma a kyannaa ware ice ge ura, ŋane keni tá kyanaakya ba ice ŋanna; ma slare keni, tá mbaɗaava á ba an slare ŋanna.” ");
INSERT INTO mfi_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amá iya wá, yá bakurá ba jirire: eptsawannaaka mandzawire ge ura. Má edda-aara a teɗaku babárva am ekte a hyema á naɗafa wá, naba eptsananteptsa náza á názlaɓa keni. ");
INSERT INTO mfi_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma a ndavakuwaa ware ɗanciki á ŋa ge dáká á dem shairiya keni, naba ƴanánƴa, a lyevaalya antara ba zane keni. ");
INSERT INTO mfi_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ma a fakaara ware sepa gwatama an ndzeɗa ba kilaumaiter palle keni, naba danánda ma kilaumaiter buwa keni. ");
INSERT INTO mfi_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Má ura a ndavaku duksa wá, naba vanteva. Edda una a de ndava gema keni yanveka.» ");
INSERT INTO mfi_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Zlaɓe ádaliye, kwa cenán vateneka ganakini a ba wakita á Dadaamiya: “Ewwaya an sleriya á ŋa, amá edda una ni ŋane kelaade á ŋa wá, ka keni ƴanaaƴa.” ");
INSERT INTO mfi_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Amá iya wá, yá bakurá ba jirire: Wayauwáyá an kelaade-aha á kure, magaumága maduwa arge emnde na ni tá fá zlaɗa áte kure ba dey na. ");
INSERT INTO mfi_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Magaumága una ŋanna, lauktu kwá geva egdzara á Eddekure na am samaya na á ba an jirire. Aɗaba ŋane wá, aŋkwa á maraterá vaciya-aara ge emnde a mága kemaarire, antara emnde a mága mandzawire baɗemme; á hyaterá yawe ge emnde na an bara ervauŋɗe-aatare, antara ge emnde na daŋŋwa huɗe-aatare baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Máki kwá wáyá ba emnde na ni itare keni wayarakurwáyá wá, ɓaaka laɗa á kure áza Dadaamiya. Aɗaba ba emnde á ŋezla keni tá aŋkwa á magán ba estuwa. ");
INSERT INTO mfi_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Zlaɓe ádaliye, má kwá gater use ba ge egdzar mama-aha á kure, kwá jaterwa an uwe kena ge emnde umele? Aɗaba ba emnde na ɗabarka Dadaamiya keni, tá aŋkwa á magán ba estuwa. ");
INSERT INTO mfi_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Aɗaba una ŋanna, a ektsakuraareka eŋkale ɗekiɗeki, gawevge ba seke Eddekure na am samaya na.» ");
INSERT INTO mfi_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Máki kwá kátá mága duksa aɗaba Dadaamiya wá, magauka áte ice á emnde ganakini a naranna. Máki kwá kátá zleba á emnde wá, nube á kure ba una ŋanna, kwá shánka laɗa áza Eddekure na am samaya na mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Daaci máki ká kátá melanu ge talaga wá, ɓaleka an ɓálá. Amaana: maŋka áte ice á emnde geni a naranna. Magauka jeba á duksa na ndza ta maganaa fida-aha na am mashidi, antara áte we á layye-aha, ganakini a galaratergálá emnde na. Yá bakurá ba jirire: Jeba á emnde ŋanna, laɗa-aatare ba una ŋanna, ɓaaka umele. ");
INSERT INTO mfi_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Amá ekka wá, máki ká kátá vante sadake á ŋa ge ura wá, emmága an nasherire. Ba názlaɓa á ŋa keni a diseka názena á maganá naɗafa á ŋa. ");
INSERT INTO mfi_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Emmága maggwire á ŋa á ba an nasherire. Eddeŋa Dadaamiya wá, ɓaaka názu á nanka ŋane. Daaci á de vakteva ba ŋane laɗa-aara.» ");
INSERT INTO mfi_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Má kwá aŋkwa maga maduwa wá, gawufka seke emnde a fida. Itare wá, wayarwaya maga maduwa am tate a tse am mashidi ira áte we á layye-aha, geni a naraterna emnde. Yá bakurá ba jirire: laɗa-aatare ba una ŋanna ge jeba emnde ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amá ekka wá, má ká kátá mága maduwa wá, demde am bere á ŋa, heɗanuheɗe ge we á bere á ŋa; daaci eŋŋala Eddeŋa na ŋane aŋkwa am tata nasherire á ŋa ŋanna. Eddeŋa na ŋane aŋkwa á zhara názena ka maganaa an nasherire na, a de vakteva laɗa-aara. ");
INSERT INTO mfi_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Má kwá aŋkwa maga maduwa wá, kwakyawanveka elva-aha ba dey seke una tá maganá emnde na ɗabarka Dadaamiya. Itare tá kurken má tá tsaka elva-aha kwakya wá, watse Dadaamiya á cenatervaarcene. ");
INSERT INTO mfi_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kumauka garava-aatare ɗekiɗeki, aɗaba Eddekure Dadaamiya ŋane diyaadiya wedera á kure ba lauktu kwá de ndavana ázeŋara keni. ");
INSERT INTO mfi_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Daaci náwa kwá maga maduwa á kure estuwa: Eddeŋere am samaya, ekka wá, ka cuɗeɗɗe. Emmága dalila á ŋa ganakini emnde baɗemme a farfa zherwe áte ka. ");
INSERT INTO mfi_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Sawa an sleksire á ŋa. A gevge namaari á ŋa am duniya keni, ba seke una am samaya na. ");
INSERT INTO mfi_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Vaŋerteva náza za a hyaŋerhye vatena. ");
INSERT INTO mfi_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ƴaŋeraarƴe haypa-aha á ŋere, ba seke una ŋere keni ŋa ƴateraare ge emnde a haypa an ŋere. ");
INSERT INTO mfi_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Daŋeremka am bada á Shaitaine, fertaŋeraaferta átuge haypa. ((Aɗaba ekka, sleksire á ŋa aŋkwa. Ká an hakuma, ká an ɗemɗemire dem ba ge ɗekiɗeki. *Aamin.)) ");
INSERT INTO mfi_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Aɗaba má kure kwá aŋkwa ƴateraare haypa-aatare ge emnde a haypa an kure wá, Eddekure na am samaya na keni á ƴakuraarƴe ge kure keni. ");
INSERT INTO mfi_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Amá má kwá ƴateraareka ge emnde wá, Eddekure na am samaya na keni, á ƴakuraareka ge kure keni.» ");
INSERT INTO mfi_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Má kwá aŋkwa tsufa ndera wá, eptsawanteka njá á kure ba seke kwá am zlaɗa, seke una tá maganá emnde a fida na tá kwashante feka-aatare, geni a naranna emnde ganakini tá am nderire na. Yá aŋkwa bakurá ba jirire: jeba á emnde ŋanna laɗa-aatare ba una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amá ekka wá, má ká am ndera wá, baraabare ica á ŋa ba tseɗaŋŋe, tsatsanaatsatse ba shagera úgje am ire á ŋa, ");
INSERT INTO mfi_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","lauktu tá de diseka emnde geni ká am nderire. Sey ba Eddeŋa na ma am tate a nasherire keni ŋane aŋkwa na palle una diyaadiya. Daaci Eddeŋa na ŋane aŋkwa a nanna názu ká maganá ka an nasherire na, á de vakteva laɗa-aara.» ");
INSERT INTO mfi_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Jahauka nalmane á kure á ba am duniya na, aɗaba á naba badzanvebadze weshege-aha antara viya. Neyle-aha keni tá kyaɓa bere-aha a emnde, tá ila kazlaŋa am huɗe-aara. ");
INSERT INTO mfi_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ekkure wá, jahaujaha nalmane á kure á ba am samaya, ma weshege-aha, ma viya, ma neyle-aha keni, ɓaaka názu á de badzená áhuwa. ");
INSERT INTO mfi_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Aɗaba am tate na ni átekwa nalmane á ŋa wá, ire á ŋa keni á ba am tate ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Ice wá, ŋane ba seke kárá á fanus ge vuwa. Má lapiya ice á ŋa wá, baɗemme á vuwa á ŋa ba parakke. ");
INSERT INTO mfi_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Amá má shagerka ice á ŋa wá, vuwa á ŋa baɗemme á ba am tabeɗammire. Daaci má parakkire na am ka na gevge daŋŋwe wá, á tsaame tabeɗammire na ká tse am huɗe-aara!» ");
INSERT INTO mfi_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Ɓaaka ura á dzegwándzegwa magaterá slera ge zanwe-aha buwa átirpalle. Ba bi á de wayete ba palle, á maganá slera shagera, á de ƴá palle, á maŋka slera-aara. Kwá dzegwánka magaterá átirpalle tara slera á Dadaamiya antara tataya nalmane.» ");
INSERT INTO mfi_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Yá bakurná aɗaba una ŋanna, geni dzamauka ire an duksa na kwá de zaná kure, bi duksa na kwá de shaná kure, bi názena kwá de tsekwaná áte vuwa á kure. Ƴaikke ba shifa ka arge náza zuze emtu? Ƴaikke ba vuwa ka arge zane emtu? ");
INSERT INTO mfi_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Zharauzhárá á ba áte ƴiye-aha á samaya, tá ja duksa ka, tá icananá á dem mba ka, tá halaná á dem kuvere ka, amá Eddekure na am samaya na á gelatergela. Kwá jateruka ba kwakya ge ƴiye-aha emtu? ");
INSERT INTO mfi_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ware am kure una á dzegwandzegwa slaɗva shifa-aara ba cekwaaŋguɗi keni an dzama ire na á maganá ŋane? ");
INSERT INTO mfi_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ay labara kwá dzama ire á zane ge tsekwana áte vuwa á kure? Zharauzhárá áte ugbene-aha am kaamba, tá maga slera ka, tá há zane ka, uwe ka, ");
INSERT INTO mfi_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","amá yá ndaakur ba jirire ba Suleymanu an kwakyire á nalmane-aara keni, ndza tsekwameka am zane na ni zariya ba seke zariyire á palle á ugbene-aha ŋanna keni. ");
INSERT INTO mfi_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Má másá na aŋkwa vatená, makuralla kerteŋ faraterufe ge kárá maa, Dadaamiya á tsekwateremtsekwa am ugbene-aha zariya, sakwa kure emtu, máki cekwire á fetarfire ka? ");
INSERT INTO mfi_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","«Aɗaba una maa, dzamauka ire ɗekiɗeki geni watse ŋá de za uwe? Bi ŋá de sha uwe? Bi ŋá de tsekwa uwe? ");
INSERT INTO mfi_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sey ba emnde na ɗabarka Dadaamiya na una tá njá á ba dzama kazlaŋa ŋanna. Ekkure wá, diyaadiya Eddekure na am samaya na ganakini kwá an wedera á duksa-aha ŋanna keni. ");
INSERT INTO mfi_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Zuŋŋwe wá, tatayautataya kure ba njá am kwara á Dadaamiya, antara mága jirire-aara, daaci Dadaamiya á de vakurteva duksa-aha umele keni. ");
INSERT INTO mfi_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Dzamauka ire áte duksa á makuralla. Ŋane keni á de sakurá ba dzama ire-aara tsekemme. Aɗaba ba kelaa hare á bere á ba an dzama ire-aara.» ");
INSERT INTO mfi_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Habazauka sera á emnde, kure keni, á de zakurvaarze Dadaamiya am shairiya. ");
INSERT INTO mfi_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aɗaba ba shairiya na kwá maganá á dete emnde na wá, Dadaamiya keni á de magakurá á ba áte una ŋanna. Baɗemme á názena kwá magaterná kure ge emnde na wá, Dadaamiya keni á de magakurná á ba áte una ŋanna ge kure keni. ");
INSERT INTO mfi_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Labara ŋane ge ekka ká zhárá esseɓa na am ice á egdza emmeŋa, amá ká tapanaaka slalɓe slaɗɗe na am ice á ŋa ge ekka? ");
INSERT INTO mfi_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ká dzegwaná estara banán ge egdza emmeŋa: “Sansa yá sakansese esseɓa am ice”, amá ekka ká an slalɓe slaɗɗe am ice á ŋa? ");
INSERT INTO mfi_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Egdza á fida na, sansese emtsaaɗe slalɓe slaɗɗe na am ice á ŋa na, ká nanna ice á ŋa parakke, lauktu ká de sananse esseɓa am ice ge egdza emmeŋa. ");
INSERT INTO mfi_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Vawaterteka duksa cuɗeɗɗe ge kere-aha, kuvaukuva geni a eptsarakuraareka, a ceɓarakuraaka; velyawanveka náza hyema á kure á katafke á nabezhe-aha geni a payeraaka an sera.» ");
INSERT INTO mfi_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Naba ndavaundáva tá de vakurteva; tatayautataya, kwá de shansha; ɗauɗaha emnde a há tá se werakurantewera wakyiya. ");
INSERT INTO mfi_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aɗaba ma a ndavanaa ware keni, sey á shansha. Ma a tatayanaa ware keni, sey á shansha. Ma a janaa ware wakyiya keni, tá weranantewere. ");
INSERT INTO mfi_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aŋkwa ura am kure, má egdza-aara á ndavanu ɗafa, ŋane á vante nákwá emtu? ");
INSERT INTO mfi_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Bi má a ndavanu kelfe, ŋane á vanta zahe? ");
INSERT INTO mfi_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kwa mandzawe-aha tsa, amá diyakurdiya vaterte duksa shagera ge egdzara á kure. Sakwa Eddekure na am samaya na emtu? Ŋane á jauje ge emnde baɗemme an vante duksa shagera ge emnde na tá ndavaná ázeŋara. ");
INSERT INTO mfi_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Názu kwá kataná kure áza emnde baɗemme, kure keni magawateránmaga ba estuwa ge emnde. Aɗaba una ŋanna jirire á názena a ɓelateraare *tawraita á Muusa ge emnde, ira názena am wakita á nabi-aha.» ");
INSERT INTO mfi_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Dawemde á kya wakyiya ɓecce. Aɗaba wakyiya na gatatte antara baráma ƴaikke wá, á da ura á dem keɗa, aley emnde kwakya tá ɗaba ba una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Amá á kya wakyiya ɓecca, antara uŋŋule shairre wá, á dá ura á dem tate á shifa, emnde na tá ɗaba una ŋanna ta cekwa.» ");
INSERT INTO mfi_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Tsufautsufa ire á kure áza nabi-aha fida. Má tá sawa á sezekure, tá ganve ire-aatare ba seke kyawe-aha, amá am huɗe-aatare wá, ta ba seke indale-aha na mandzawe-aha na. ");
INSERT INTO mfi_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kwá de diyatersediye áte názena á de maraná slera-aatare. Tá ŋazlevaaka egdzara á nderza áte dake, bi egdzara á gwayafa áte zaza. ");
INSERT INTO mfi_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nafa na shagera na, á yá egdzere emtake, nafa na shagerka na, á yá egdzere keni emtaŋka. ");
INSERT INTO mfi_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nafa shagera á taa yeka egdzere emtaŋka; nafa na shagerka keni á taa yeka egdzere emtake. ");
INSERT INTO mfi_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Baɗemme á nafa na á yeka egdzere emtake na, a icarsice, a epsharapsha an kárá. ");
INSERT INTO mfi_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Una keni ba duksa palle: Kwá de diyatersediye nabi-aha fida ŋanna áte slera-aatare.» ");
INSERT INTO mfi_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Diyaweddiye una ba shagera: Baɗemme á emnde na tá biya: Yaakadada, Yaakadada na ka una watse tá shá dem zlanna am samaya. Sey edda una á maga názena á kataná Edderwa na aŋkwa am samaya na. ");
INSERT INTO mfi_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Vacite ŋanna, emnde kwakya tá de biya: Yaakadada, Yaakadada, ŋere keni ndza ŋa magaa slera á nabiyire an zhera á ŋa; ndza ŋa ŋgyanse jini-aha am ura an zhera á ŋa; ndza ŋa magaa najipu-aha gergere an zhera á ŋa. ");
INSERT INTO mfi_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Daaci ge emnde ŋanna watse yá baterá: Ndza diyanakurka ya ɗekiɗeki. Gawiyapteka zlalauzlálá, kure kwa emnde a maga haypa.» ");
INSERT INTO mfi_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Daaci ma a cenanaa ware elva-aaruwa ŋanna, a maganaahe áte una ŋanna, ŋane á garava an zhele sleŋkale, a nderaa bere-aara, a ƴese haha, á de faná ekte áte palaha. ");
INSERT INTO mfi_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","A hyehe ge yawe ƴaikke, a sawhe ge yawe á kela, a se eblyetaa áte bere ŋanna, effeƴa keni á vata á ba an ndzeɗa, aley bere ŋanna mbeɗaaka, aɗaba ta nderanaa áte palaha. ");
INSERT INTO mfi_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Amá ma ware una a cenvaahe elva-aaruwa ŋanna, maganaaka áte una ŋanna maa, ŋane á gáráva an zhele uce, a naba nderaa bere-aara áte shiili. ");
INSERT INTO mfi_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","A hyehe ge yawe ƴaikke, a sawhe ge yawe á kela, a se eblyetaa áte bere ŋanna, effeƴa keni á vata á ba an ndzeɗa, daaci a mbeɗanaahe reppe.» ");
INSERT INTO mfi_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Am sarte na Yaisu zlauzle am ndaha elva-aha ŋanna, baɗemme á zlamaha tá maga ba najipu-aara, ");
INSERT INTO mfi_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","aɗaba kwaraterseka seke náza á malum-aha á *tawraita, ŋane a kwaraterse á ba an hákuma. ");
INSERT INTO mfi_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tsekwaatsekwa Yaisu á sá áte ire á wa, kwakya nalga na a daa ɗaba ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","A semhe ge ura á wana derve, a kezlaa ugje á katafke-aara, a ba ŋane á elvan ge ŋane: «Yaakadada, ekka wá, má wayak-waya ka dzegwándzegwa givege ba meteɗɗe vuwa-aaruwa.» ");
INSERT INTO mfi_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yaisu a naba pelse erva-aara, a fete áte slederve na, a ba ŋane á elvan ge ŋane: «Wayanwáyá ká mbembe, ba meteɗɗe vuwa á ŋa.» Ba seke ndaha miya na, a naba mbehe ge slederve ŋanna meteɗɗe. ");
INSERT INTO mfi_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Daaci a ba Yaisu á elvan ge ŋane: «Eccena ba shagera: Ɓalananseka ma ge ware keni ɗekiɗeki. Názena ká de maganá ka wá, de maranánmárá ire á ŋa ge *liman, vanteva sadake na ndza a ndahanaa Muusa na, ká maraterná an una ŋanna ge emnde ge mbakmbire.» ");
INSERT INTO mfi_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Daaci damda Yaisu á dem Kafarnahum. A demhe ge male á sawji-aha á Rauma á dezeŋara, a de ŋalan geni a melanumele. ");
INSERT INTO mfi_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","A ba ŋane á elvan ge ŋane: «Yaakadada, aŋkwa nave-aaruwa á zlava am mba, lapika ba zlazlaɗa, matsamatsa uɓiya-aha áte ŋane, á shá zlaɗa jipu.» ");
INSERT INTO mfi_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","A ba Yaisu á elvan ge ŋane: «Yá aŋkwa duwa, yá de mbanaambe.» ");
INSERT INTO mfi_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","A ŋutehe zlaɓe ádaliye ge male á sawji-aha á Rauma na, a ba ŋane á elvan ge Yaisu: «Malum, hyanefka ɗekiɗeki geni ká sem huɗe á ha-aaruwa. Ndaasendahe ka ba elva á ŋa palle, á mbemmbe nave-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Aɗaba iya keni, ya ba edda á hákuma; male-aha-aaruwa keni tá aŋkwa. Iya, ya male á sawji-aha. Má ya banán ge palle-aatare: Ezzlala á dem tatu estuwa, ba á zlala. Má ya ɗaha palle-aatare ba á sawa. Má ya banán ge nave-aaruwa palle: Emmága una, sey ba á emmága.» ");
INSERT INTO mfi_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ba cenancena Yaisu elva-aara ŋanna wá, á maga ba najipu-aara. Daaci a ba ŋane á elvan ge emnde na tá aŋkwa á ɗaba ŋane na: «Yá bakurá ba jirire: á ba am *Iserayiila keni, shananka ura an fetarfire estuwa. ");
INSERT INTO mfi_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yá aŋkwa bakuranba: Emnde kwakya una tá de sawa á sá á ba am geɗi, antara á sá á ba am yala, tá de zá emtakire áza Ibrahima, Isiyaaku, ira Yakubu am zlanna am samaya. ");
INSERT INTO mfi_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Amá emnde na ma andze náza-aatare zlanna á Dadaamiya wá, itare tá de puwaterpuwa á dem tabeɗammire ágashe, tá de kyuwa ambera tá kerɗa slare-aatare ge zlaɗa.» ");
INSERT INTO mfi_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Daaci, a ba Yaisu á elvan ge male á sawji-aha na: «Ezzlala á dem mba á ŋa, a gevge áte una ka fetaare átekwa na.» Kerteŋ a naba mbehe ge nave á male á sawji-aha na á ba am sarte ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Am iga-aara maa, Yaisu a dem mba á Piyer, a de bera shawle á Piyer mukse á zlava, á wáná zlagzlagi. ");
INSERT INTO mfi_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yaisu ba a de fete erva-aara áte mukse na, daaci a naba ƴanhe ge zlagzlagi, a tsetehe, a maganaa slera-aha. ");
INSERT INTO mfi_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Herzhe maŋgaripu maa, ta sanaa emnde na tá an shaitaine na kwakya. A naba ŋgyanse jini-aha ŋanna am itare an elva-aara, a mbaa emnde na tá áte lapikere na baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Estuwa ganvege názena ndza a ndasaa nabi Aisaya, a ba ŋane: «Ba ŋane an ire-aara a lyamivaare lipire á miya ira lapikere á miya baɗemme». ");
INSERT INTO mfi_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yaisu nanna kwakyire á nalga na átevge ŋane, daaci a ba ŋane á elvan ge pukura-aha-aara: «Ebzaumibza haye ádehuwa-aara.» ");
INSERT INTO mfi_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","A ganaptehe ge malum á *tawraita umele, a ba ŋane á elvan ge Yaisu: «Malum, yá ɗabakɗaba ma ka deme keni.» ");
INSERT INTO mfi_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","A ŋwanante ge Yaisu, a ba ŋane á elvan ge ŋane: «Mbayka-aha tá an evege-aha-aatare; ƴiye-aha keni tá an bere-aha-aatare. Amá iya *Ura á emnde baɗemme wá, ba tate na yá zlavanaazlava shifa-aaruwa keni ɓaaka.» ");
INSERT INTO mfi_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","A ba ura umele zlaɓe ádaliye am dagave á emnde a ɗaba ŋane, á elvan ge ŋane: «Yaakadada, viteva barama yá de heɗeheɗa emtsaaɗe edderwa.» ");
INSERT INTO mfi_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","A ŋwanantehe ge Yaisu, a ba ŋane á elvan ge ŋane: «Sawa, ɗabiɗaba, ƴaterƴa emtsa-aha, a heɗarheɗa emtsa-aha-aatare.» ");
INSERT INTO mfi_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yaisu a de demhe am paare á yawe, pukura-aha-aara keni ta naba ɗabemhe. ");
INSERT INTO mfi_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","A naba tsetehe ge válale ƴaikke arge haye ŋanna. Yawe na a fatsana effeƴa na a nduhe paare, amá Yaisu á pá ba hare-aara. ");
INSERT INTO mfi_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ta de tsantehe ge pukura-aha-aara, tá ámbera eɗɗaha: «Yaakadada, lyamilye degiya má ɓaaka.» ");
INSERT INTO mfi_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","A ŋwutehe, a ba ŋane á elvan ge itare: «Labara á wakurwa lyawa estuwa? Ekkure wá, cekwa fetarfire á kure!» Daaci a naba tsetehe, a valateraarhe ge tara effeƴa antara haye. Ba seke ndaha miya na, a tsaahe tseriyye ba seke ndza gejaaka duksa. ");
INSERT INTO mfi_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Emnde baɗemme tá maga ba najipu, a ba itare: «Ware ŋane jeba á zhele na, dete ba effeƴa antara haye keni tá fansarefe na?» ");
INSERT INTO mfi_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Am sarte na icaransice haye tara Yaisu, daraada á dete iga a guwa am haha á Gadaraina-aha maa, ba tsekwa-aatare am paare wá, tá de ja ba ire antara emnde buwa tá an shaitaine, tá segashe am irekhya-aha, ta zlazlaɗa-aha jipu, tá an kuva áza emnde, ura á taa deseka á kya uŋŋule ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","A ba itare á ba an ka kwara: «*Egdza á Dadaamiya, ázara am dagave á ŋere antara ekka? Zlaɓe ba laukte-aara keni samka kerteŋ ka se fa zlaɗa áte ŋere emtu?» ");
INSERT INTO mfi_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ay, áhuwa ŋanna maa, aŋkwa walda á nabezhe ƴaikke, tá aŋkwa piya. ");
INSERT INTO mfi_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jini-aha na ta naba ŋala Yaisu a ba itare: «Má ká ŋgyaŋerŋgye wá, vaŋerteva barama ŋá de njá am walda á nabezhe-aha na.» ");
INSERT INTO mfi_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","«Dawmbare», a ba Yaisu á elvan ge jini-aha na. Daaci ta sesehe am emnde na, ta de demhe am walda á nabezhe-aha na. Ta naba zlerdaa zhagade ge nabezhe-aha na daga á sate egdza wa ŋanna, ta se valyeme am haye, a ndateruhe ge haye baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Zhagade á dem ekse ge suni-aha á nabezhe na, ta de ɓalaterse labare ŋanna ge emnde, antara názena ta shanaa emnde buwa na ndza tá an shaitaine na baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Daaci emnde a ekse baɗemme saresse, tá se yainu ge Yaisu. Ba puwartepuwa ice áte ŋane maa, ta ŋalanaa á ba an ŋála geni a dedde am larde-aatare ba ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yaisu a demhe am paare á yawe tá antara pukura-aha-aara, a icese haye, a saahe á sem ekse-aara. ");
INSERT INTO mfi_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Daaci ta sanaa ura lapika an matsa uɓiya-aha-aara, tá sá sepaná áte egdera. Am Yaisu nanna fetarfire-aatare, a ba ŋane á elvan ge edda una lapika na: «A gazleka ervauŋɗe á ŋa egdza-aaruwa, aɗaba an bárá haypa-aha á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Daaci tá aŋkwa malum-aha á *tawraita áhuwa, a ba itare am ervauŋɗe-aatare: «Kwaye zhele na aŋkwa á lyiya sleɗe á Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kerteŋ Yaisu diyeddiye názu tá dzamaná itare, a ba ŋane: «Labara kwa dzamete elva kelaadire estuwa am ervauŋɗe á kure? ");
INSERT INTO mfi_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ázara una tsaftsafe jauje ge baná: An bárá haypa-aha á ŋa, bi baná: Tsettse ezzlala an sera á ŋa? ");
INSERT INTO mfi_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Iya wá, yá kátá kwá diyeddiye geni iya *Ura á emnde baɗemme, yá an hákuma ge ƴateraare haypa ge emnde am duniya na.» Daaci, a ba ŋane á elvan ge edda una an matsa uɓiya-aha-aara na: «Tsettse, ezzlala á da.» ");
INSERT INTO mfi_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","A naba tsetehe, a zlalehe á dem mba-aara. ");
INSERT INTO mfi_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Amá nalga á emnde na tá áhuwa na naranna una ŋanna, baɗemme gazlargazla, ta fantau ge gálá Dadaamiya, aɗaba hákuma ŋanna a vante ge urimagwe na. ");
INSERT INTO mfi_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Daaci Yaisu a tsetehe áhuwa, aŋkwa á zlala áte barama; átira zlala, a naa zhele umele zhera-aara Mata, á njá am bere á hadama. A ba Yaisu á elvan ge ŋane: «Tsettse sawa ɗabiɗaba.» A naba tsetehe, a ɗabete Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Am iga-aara maa, tara Yaisu tá aŋkwa za ɗafa antara pukura-aha-aara am mba á Mata ŋanna, ta naba semhe ge *emnde a jaha hadama, antara emnde a haypa umele kwakya, ta se nja átirpalle antara Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","*Farisa-aha ba naranna una ŋanna maa, a ba itare tá elvan ge pukura-aha á Yaisu: «Labara malum á kure á za ɗafa antara emnde a jaha hadama ira emnde a mága ser haypa?» ");
INSERT INTO mfi_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","De cenatercena Yaisu, a ba ŋane á elvan ge itare: «Emnde na lapiya vuwa-aatare wá, ɓaaka wedere-aatare áza dauktar, sey ba emnde na lapika vuwa-aatare una tá deza dauktar. ");
INSERT INTO mfi_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Zlalauzlala, de tsahautsaha názena am huɗe á wakita á Dadaamiya, a ba ŋane: Názena yá kataná ya kwakya wá, baira zevarzire, sadake á dabba-ka. Aɗaba iya wá, sanka ya á se tataya emnde na tá am jirire, ya se tataya ba emnde a haypa.» ");
INSERT INTO mfi_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ta se ndavanuhe ge pukura-aha á Yuhanna slemaga baptisma, a ba itare: «Ŋere antara *Farisa-aha, ŋa eksa ndera, labara pukura-aha á ŋa tá ekseka ndera ɗekiɗeki na?» ");
INSERT INTO mfi_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Daaci a ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Emnde na tá ɗahaterá á sem larusa keni, kwa kurken tá dzegwándzegwa tsufa ndera emtu, am sarte na tá áza zhele á larusa? Tá dzegwánka ɗekiɗeki. Amá aŋkwa á sawa sarte umele wá, watse tá pakyava antara zhele á larusa. Am sarte ŋanna wá, itare keni, watse tá tsufá ndera. ");
INSERT INTO mfi_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Ɓaaka ura a venya emgyegwe a naŋgyuwe an baukta áŋwaslire, aɗaba una áŋwaslire na á de teɗa una emgyegwe na, daaci á de ette ba kwakya zlaɓe adaliye. ");
INSERT INTO mfi_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","«Zlaɓe ádaliye, tá puweka mbazla áŋwaslire á dem emgyegwe a *kanyakanya-aha. Aɗaba máki naavenahe, á tata kanyakanya-aha na. Daaci á puwa mbazla á dem haha, kanyakanya-aha keni badzavbadze. Sey tá puwa mbazla áŋwaslire á dem *kanyakanya keni áŋwaslire lauktu ɓaaka una á de badza am huɗe-aara.» ");
INSERT INTO mfi_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ba Yaisu aŋkwa á baterá elva-aha ŋanna, a semhe ge palle á male á Yahudiya-aha, a naba kezlaa ugje á katafke-aara, a ba ŋane á elvan ge ŋane: «Emtsamtsa egdza-aaruwa mukse ba kinamina na, amá naba sawa fetefa erva á ŋa áte ŋane, á de shifeteshifa.» ");
INSERT INTO mfi_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","A naba tsetehe ge Yaisu, ta ɗabemhe antara pukura-aha-aara. ");
INSERT INTO mfi_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aŋkwa mukse, á maga yawe kelaawa ju buwa, á maga ba palase áte lapikere á kela uzhe, a naba ganaptehe ge Yaisu á kya iga, a fete erva-aara áte we á naŋgyuwe-aara. ");
INSERT INTO mfi_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Aɗaba ndza a slaslan ba estuwa am ervauŋɗe-aara, a ba ŋane: «Ma shanansha ya fete ba erva-aaruwa áte naŋgyuwe-aara keni, ya mbembe.» ");
INSERT INTO mfi_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","A eptsapte ge Yaisu, a zharanaahe, a ba ŋane á elvan ge ŋane: «Mbakaambe fetarfire á ŋa egdza-aaruwa. A gazleka ervauŋɗe á ŋa ɗekiɗeki.» A ba am sarte ŋanna a naba mbehe ge mukse na. ");
INSERT INTO mfi_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Daaci damda Yaisu á dem mba a male á Yahudiya-aha, a de bera jahava a emnde kwakya tá kyuwa, emnde umele keni tá ferta derma. ");
INSERT INTO mfi_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Daaci a ba ŋane a elvan ge itare: «Dawedde áhuna aɗaba egdzere an emtseka, á pá ba hare.» Ta naba puwar dzáká, agira tá epsawepsawa. ");
INSERT INTO mfi_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Daredda emnde á degashe maa, a demhe ge Yaisu á dem bere ŋanna, a de ŋanaa ba erva ge egdze na, daaci a naba tsetehe. ");
INSERT INTO mfi_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ta naba hyanme labare ŋanna am larde ŋanna baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tsettsa Yaisu áhuwa zlazlálá, ta naba ɗabemhe ge wulfe-aha umele ta buwa, tá ámbera eɗɗaha an ka kwara: «Ambarka á ŋa Yaisu *Egdza á Dawuda zaŋervaarze.» ");
INSERT INTO mfi_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","De demda Yaisu am bere, ta demhe ge wulfe-aha ŋanna keni ádezeŋara, a ndavateruhe ge Yaisu: «Fakurtarefa geni yá dzegwándzegwa vakurtá ice emtu?» Ta naba ŋwanantehe: «Ane, faŋertarefe Yaakadada.» ");
INSERT INTO mfi_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Daaci Yaisu a semtateraa ice, a ba ŋane: «A gevge áte una kwá fetaara kure átekwa.» ");
INSERT INTO mfi_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","A naba werte ge ice-aatare. Yaisu a fantau ge giyatergiya, a ba ŋane á elvan ge itare: «Fawfa hyema ba shagera: a cenanka ura umele ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Aley itare ba zlala-aatare, tá de ɓalese labare á Yaisu am larde ŋanna baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Am sarte na tá átire á zlala, ta naba sanaa ura an shaitaine ge Yaisu, ba elva keni á taa ndaaseka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ba Yaisu ŋgyanseŋgye jini na am ŋane maa, uce na a naba fantau ge ndaha elva. Daaci nalga á emnde na baɗemme ta fantau ge mága najipu, ta bantsa itare: «Ndza naŋeranka jeba una am *Iserayiila ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Amá ta bantsa *Farisa-aha: «A vantaa ba male á shaitaine-aha hákuma ŋanna ge ŋgyanse jini am ura.» ");
INSERT INTO mfi_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yaisu jemje ɗaba am berni-aha antara am ekse-aha baɗemme, á kwaraterse duksa ge emnde am mashidi-aha-aatare, a ɓalateraa labare á higa, labare á dem *kwárá á Dadaamiya, ámbera á mbatermbe am lapikere gergere, ira názena a badza ura baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Am Yaisu a zharanaahe nalga á emnde na, daaci a naba zatervaarehe, aɗaba kuɗarevkuɗe, zlauzle ndzeɗa-aatare. Ta ba seke kyawe-aha na ɓaaka suni am ekte ge itare. ");
INSERT INTO mfi_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Daaci, a ba ŋane á elvan ge pukura-aha-aara: «Kwakya hiya áte fe, amá cekwa emnde a ehhálá-aara á dem mba. ");
INSERT INTO mfi_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Aɗaba una ŋanna, ŋalauŋala Edda á fe, geni á farfe ge ɓela emnde á dem fe-aara.» ");
INSERT INTO mfi_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yaisu a ɗetaa pukura-aha-aara kelaawa ju buwa, daaci a vaterte hákuma ge ŋgyanse jini-aha am ura, tá mba emnde am lapikere gergere antara emnde na tá an badza baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Náwa itare zhera-aha a emnde a ɓela kelaawa ju buwa ŋanna: Zuŋŋwe wá, ba Simaun, ŋane una ta ɗahanaa an Piyer, tá antara egdza emmeŋara Andere; egdzara á Jaibaidaiyus buwa tara Yakuba an Yuhanna, ");
INSERT INTO mfi_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, Bartaulauma, Taumas, Mata ŋane una slejaha hadama, Yakuba egdza á Halfa, Tadawus, ");
INSERT INTO mfi_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simaun na wayaaka tá kwaráterá emnde umele na, ira Yahuda Iskariyaut edda una a velu Yaisu áza kelaade-aha-aara na. ");
INSERT INTO mfi_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yaisu á ɓela pukura-aha-aara kelaawa ju buwa ŋanna, a ba ŋane á elvan ge itare: «Daumbareka á dem tate á emnde a jeba umele, daumbareka á dem ekse-aha á emnde a *Samariya keni. ");
INSERT INTO mfi_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Daumbare kure á ba deza Iserayiila-aha, itare tá ba seke kyawe-aha na ta keɗa an keɗa na. ");
INSERT INTO mfi_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Daumbare an waazu, bawateranba: Sarte á njá am *kwárá á Dadaamiya herzhapteherzhe. ");
INSERT INTO mfi_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Daaci mbaumbe lapika-aha, tsautse emnde am emtsa, mbaumbe emnde na á waterá derve, ŋgyauŋgye jini-aha am emnde keni baɗemme. Hákuma ŋanna kwá shan ba dey, kure keni magawateránmaga ba dey ge emnde. ");
INSERT INTO mfi_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Daumbareka an dindar, bi lipela, ma shuŋgu keni am lyiba-aha á kure. ");
INSERT INTO mfi_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Eksauka nambela á kashi am erva ge mága shula á kure, ma naŋgyuwe buwa keni áte ura palle. Halauka kimake, ma zade keni am erva, aɗaba edda á slera wa, zlayánzlaya geni á lyevalya ɗáfa keni. ");
INSERT INTO mfi_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Má dakuremde am berni, bi am ekse, tatayautataya ba edda una aŋkwa higa-aara ge lyiyakurlyiya na, njawinja á ba am mba-aara, dem sarte á zlala á kure áhuwa. ");
INSERT INTO mfi_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Má kwá aŋkwa dem mba á ura, bawateránba emtsaaɗe ge emnde á há ŋanna: A vakurteva Dadaamiya hairire! ");
INSERT INTO mfi_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Daaci má lyarakurvalye emnde a há ŋanna tá shansha hairire na. Amá má lyiyarakurka, tá shanka hairire ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Má dakuremde am mbá á emnde, bi am ekse na lyiyarakurka emnde, bi cenarka elva á kure wá, dawedde am ekse-aatare, papawaapape berbere na áte sera á kure. ");
INSERT INTO mfi_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yá bakurá ba jirire: Vaci shairiya wá, watse ŋgulme ba shairiya na ta magaterán ge emnde a *Saudauma antara emnde a *Gaumaura na, arge názá á emnde a ekse ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Cenaucena: Náwa yá ɓelakurɓela wá, kwa ba seke kyáwe-aha am dágave á indale-aha. Amá gawuvge ƴaimƴaime-aha ba seke záhe, gawuvge emnde a kamaare ba seke zalke-aha. ");
INSERT INTO mfi_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Faufa hyema áte ire á kure, aɗaba watse tá dakurá á de katafke á shairiya, tá de slerpákurá an já am mashidi-aha-aatare. ");
INSERT INTO mfi_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Watse tá dákurá á de katafke á male-aha á duniya, tá de dákurá á de katafke á slekse-aha áɗaba zhera-aaruwa. Estuwa, kure keni kwá de ndaasendahe seydire áte iya á katafke-aatare antara áza emnde a jeba umele keni. ");
INSERT INTO mfi_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Amá, má darákurda wá, dzamauka ire á názena kwá de ndaaná kure, bi geni kwá de ndaaná estara. Aɗaba á ba am sarte ŋanna wá, watse á semsa elva-aha na kwá de ndaaná kure á sem ire-aha á kure. ");
INSERT INTO mfi_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Aɗaba kwá de ndaaná kure-ka, á de ndaaná ba Sheɗekwe á Eddekure elva-aha ŋanna am kure. ");
INSERT INTO mfi_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Am sarte ŋanna maa, emnde umele tá de vatertá ba itare an erva-aatare egdzar mama-aha-aatare ge emnde, geni a de ceɓarateraaceɓa. Dada-aha keni tá de vatertá ba itare egdzara-aatare ge emnde, geni a de ceɓarateraaceɓa. Egdzara umele keni, tá de daterar ge dada-aha-aatare antara mama-aha-aatare, tá de ceɓa ba shifa-aatare. ");
INSERT INTO mfi_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Emnde baɗemme watse tá dá ba kelaadire ádete kure aɗaba zhera-aaruwa, amá edda una má tsaatse shagera dem halavuwa-aara wá, ŋane á lyelye shifa-aara. ");
INSERT INTO mfi_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Amá am ekse na má tá fá zlaɗa áte kure, zhagadawzhagade á dem ekse umele, aɗaba uwe, una yá bakurá ba jirire: yá de semsa ya ba estuwa, ya *Ura á emnde baɗemme, kwá de zlanaaka ja ɗaba am berni-aha á *Iserayiila baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Ɓaaka pukura na ni á januje ge málum-aara an malire; ɓaaka walaaɗi na á januje ge zanuwe-aara an malire. ");
INSERT INTO mfi_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Á juka am, ma waletewala pukura, ŋane keni á gevge seke malum-aara, ma walaaɗi keni á juka am á gevge seke zanuwe-aara. Má edda á há maa, tá ɗahaná an *Bailjaibul ni, sákwa emnde na tá am huɗe á há ŋanna emtu?» ");
INSERT INTO mfi_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Aɗaba una ŋanna, kuvauka urimagwe ɗekiɗeki. Aɗaba ɓaaka duksa na an sheɓe kina, á de sheɓaavesheɓe mazla-aara. Ɓaaka duksa na ni nasherire kina, tá de diseka emnde. ");
INSERT INTO mfi_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Názu yá bakurná ya an sheɓe na, de ɓalauseɓale ba parakke. Una tá ndaakurse á dem hyema an nasherire na keni, de ɓalauɓala á ba an ká kwárá á dem huɗe á ekse. ");
INSERT INTO mfi_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kuvawaterka emnde na tá dzegwándzegwa ceɓakurceɓa ba shifa á kure am duniya na. Itare tá dzegwánka mága duksa áte shifa a dem zlanna. Kure wá, kuvaukuva ba edda una ni ŋane an hákuma ge ceɓakurceɓa kina, an hákuma ge dakurá á dem kárá á jahanama keni. ");
INSERT INTO mfi_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Njeɗu-aha buwa tá velan ba ge kwáɓa palle-ka emtu? Amá ba palle á njeɗu-aha ŋanna keni á taa keɗeka ba estuwa, sey má a wayetaa Eddekure na am samaya na. ");
INSERT INTO mfi_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ba duksa palle ge kure keni: Ba úgje á ire á kure keni an kezla baɗemme áza Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Aɗaba una ŋanna gazlauka ɗekiɗeki, kwá an dárádza ba kure arge njeɗu-aha ŋanna ma wanyara keni.» ");
INSERT INTO mfi_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Ma ware una sheɓaaka, a enndaha ba parakke á katafke á emnde ganakini ya Yaakadada-aara wá, iya keni yá de enndaha ba parakke á katafke á Edderwa am samaya geni ŋane ura-aaruwire. ");
INSERT INTO mfi_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amá edda una ƴiyaaƴa á katafke á emnde wá, iya keni yá de ƴanaaƴa á katafke á Edderwa am samaya.» ");
INSERT INTO mfi_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Slaslauka geni iya ya saa hairire á sem duniya. Sanka an hairire á sem duniya, amá ya saa ba kelaadire. ");
INSERT INTO mfi_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Sawa-aaruwa wá, ya se wesha tara egdzere an dada, tara egdzere mukse an emmeŋara, ira tara egdzere mukse antara shawle-aara mukse. ");
INSERT INTO mfi_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ba emnde a há-aatare una tá de gev kelaade-aha-aara. ");
INSERT INTO mfi_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Ma ware una a hayaa ba eddeŋara bi a hayaa emmeŋara arge iya, ŋane wa, hyafka sleɗabiɗaba. ");
INSERT INTO mfi_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ma ware una eksanteka dzaŋgala-aara emtsaaɗe ge ɗabiɗaba an ŋane, ŋane wá, hyafka sleɗabiɗabi. ");
INSERT INTO mfi_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ma ware una á kátá ŋezlese shifa-aara na, edda-aara á keɗanaakeɗa, amá edda una a keɗaa shifa-aara aɗaba iya, ŋane á ŋezleseŋezle.» ");
INSERT INTO mfi_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Ma a lyakurvaa ware keni, edda-aara a lyevaa ba iya. Edda una lyivaalye, a lyevaa ba edda una a ɓeliɓela na. ");
INSERT INTO mfi_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ma ware una a lyevaa nabi á Dadaamiya áɗaba ŋane nabi á Dadaamiya, ŋane keni á de shansha laɗa á nabiyire. Edda una a lyevaa ura jirire áɗaba ŋane slejirire, ŋane keni á de shá laɗa á slejirire. ");
INSERT INTO mfi_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yá bakurá ba jirire: Ma ware una a vante ba yáwe lailaiɗɗe ge cekwa á pukura-aha-aaruwa, áɗaba ŋane pukura-aaruwa, á shansha laɗa-aara.» ");
INSERT INTO mfi_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Am Yaisu zlauzle á tsakaterá elva ŋanna ge pukura-aha-aara kelaawa ju buwa maa, a naba tsetehe áhuwa mazla-aara, ge de kwaraterse elva antara ge ɓalatera waazu ge emnde am ekse-aha á larde ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Am sarte ŋanna maa, Yuhanna slemaga baptisma am daŋgay. Ba cenancena labáre á slera na aŋkwa á maganá Yaisu *Almasiihu na, daaci a ɓelanve emnde umele am pukura-aha-aara, ");
INSERT INTO mfi_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","geni tá de ndavanundave estuwa: «Ba ekka edda una diyaŋerdiya ganakini watse á sáwa na emtu? Una ka ura umele, sey ŋá tsákwá hyema ádaliye he?» ");
INSERT INTO mfi_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","A ŋwaterantehe ge Yaisu, a ba ŋane á elvan ge itare: «De bawanánba kure názena á cenaná hyema á kure, antara názena kwá zheraná á ba an ice á kure na ge Yuhanna ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bawanánba ganakini wulfe-aha tá aŋkwa nanna ice-aatare, emnde a dere tá aŋkwa zlala ba laŋŋe, emnde a derve garevge ba meteɗmeteɗɗe, makwaya-aha tá aŋkwa cenáncena, emnde na ndza emtsaremtsa keni tsarettse, talage-aha keni maa, cenarvaacena waazu á labare á higa. ");
INSERT INTO mfi_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Barka ge edda una má kezlanveka fetarfire-aara áte iya na.» ");
INSERT INTO mfi_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Am sarte na tá aŋkwa zlálá pukura-aha á Yuhanna maa, Yaisu a fantau ge ndahater elva á Yuhanna ge zlamáha, a ba ŋane á elvan ge itare: «Ndza kwa de zhárá uwe kure am kaamba? Ndza kwa de zhárá masa-aha na á gejaná effeƴa na emtu? Una ŋanna-ka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ay ndza kwa de zhárá uwe? Ndza kwa de zhárá ura am zane zariya emtu? Náwa emnde a tsekwa zane zariya keni tá á ba am mba á slekse-aha. ");
INSERT INTO mfi_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ay ndza kwa de zhárá uwe? Ndza kwa de zhárá nabi á Dadaamiya ka emtu? Una ba jirire, á tsáka á ba an nabi keni. ");
INSERT INTO mfi_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Aɗaba ba Yuhanna una wakita á Dadaamiya aŋkwa á ndaha elva-aara a ba ŋane: “Náwa yá ɓela sleɓela-aaruwa á katafke á ŋa, ge tsatsaká baráma, á ba Dadaamiya.” ");
INSERT INTO mfi_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yá ndaakur ba jirire: am emndimagwaha na tá yaterá ba ŋwásha, ɓaaka ura á jauje ge Yuhanna slemaga baptisma an malire. Aley edda una cekwa ba ŋane am emnde na tá am *kwara á Dadaamiya wá, ŋane á jauje ge Yuhanna an malire. ");
INSERT INTO mfi_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kwaye a fantuwa estuwa Yuhanna slemaga baptisma ge ɓala waazu, sem vatena, kwara á Dadaamiya á shá ba zlaɗa áza kelaade-aha, tá kátá ba ta berduhe daaci tá kwaraná itare. ");
INSERT INTO mfi_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Aɗaba baɗemme á nabi-aha, antara *tawraita á Muusa ta magaa nabiyire-aatare áte kwara á Dadaamiya. Itare wá, halarvuhale á ba áte Yuhanna. ");
INSERT INTO mfi_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Má kwá cena náza-aaruwa wá, *Ailiya na Dadaamiya a ɓalese werre am wakita-aara ganakini watse á sawa na, ba ŋane Yuhanna ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Edda una aŋkwa hyema-aara ge cena duksa, a cenvaacena elva na ya bakurna ya na ba shagera. ");
INSERT INTO mfi_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Yá sláterá an ware kwa emnde a zamáne na? Yá sláterá an egdzara na tá beɗa ba nara áte we á layye am huɗe á ekse, a ba emnde umele, tá elvan ge emnde umele-aatare: ");
INSERT INTO mfi_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ŋa fertakurte derma á ga gusa, shekelakurka; ŋa tsakakurte ɗákwa keni, kyuwakurka. ");
INSERT INTO mfi_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Haá! Samsa Yuhanna, ŋane zaaka duksa-aha umele, shaaka mbazla, ŋane wá, an shaitaine ɗeme ákyiye! ");
INSERT INTO mfi_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","De samsa *Ura á emnde baɗemme, ŋane wá, aŋkwa ezza, aŋkwa essha keni, ta bantsa: Kwaye zhele na slera-aara ba huɗe, ŋane ɗeme wá, ura á emnde a ŋezla antara emnde na tá maga ba haypa na akyiye! Amá ilmu á Dadaamiya wá, aŋkwa á máráva jirire-aara am slera na aŋkwa á maganá ŋane.» ");
INSERT INTO mfi_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Daaci Yaisu a naba valateraarhe ge emnde a ekse-aha na ndza a magaa najipu-aha kwakya am huɗe-aara, aley magarka tuba ɗekiɗeki na. A ba ŋane áte ekse-aha ŋanna: ");
INSERT INTO mfi_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Degiya watse zlaɗa arge ekka, ekka Kaurajin; zlaɗa arge ekka, ekka Baytisayda. Aɗaba najipu-aha na ya maganaa am kure na wá, ma andze am Tirus antara Sidaun wá, ma andze tsakwaremtsakwa emnde a ekse-aha ŋanna am buhwa-aha, ma andze daremde am kelpa á kárá ge marese tuba-aatare. ");
INSERT INTO mfi_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Aɗaba una ŋanna, yá bakurá ba jirire: Vaci shairiya wá, watse ŋgulme ba shairiya na ta magaterán ge tara Tirus antara Sidaun na arge názá á kure. ");
INSERT INTO mfi_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ekka keni Kafarnahum, ka kurken watse á kakteka Dadaamiya, á dakaada á dem samaya emtu? Ɓaaka ɗekiɗeki! Watse á gakaage á dem jahanama. Aɗaba najipu-aha na ya maganaa am ka na wá, una ŋanna ma andze am *Saudauma wá, sem vatena keni ekse ŋanna ma ba nja-aara. ");
INSERT INTO mfi_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aɗaba una ŋanna, yá baká ba jirire: Vaci shairiya wá, watse ŋgulme ba zlaɗa na Dadaamiya á de faná áte emnde a *Saudauma na arge názá á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Am sarte ŋanna, a eksante elva ge Yaisu, a ba ŋane: «Eddaye-aaruwa, ka Edda á samaya antara haha ba ka palle. Yá aŋkwa slafak we-aaruwa kwakya, aɗaba ka sateransa ka ge egdzara mesheshe názu ka sheɓatervuwe ge emnde a diya, antara emnde a eŋkale. ");
INSERT INTO mfi_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ba estuwa Edderwa, una namaari á ŋa ganakini a gevge ba estuwa. ");
INSERT INTO mfi_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Edderwa a fime duksa baɗemme am erva ge iya. Diyaweddiye ganakini ɓaaka ura á diyeddiye *Egdza á Dadaamiya máki Eddeŋara ŋanna-ka. Dada keni, ɓaaka ura á diyeddiye máki Egdza-aara-ka palle, antara emnde na a wayaterántaa Egdza-aara ge marateránmara. ");
INSERT INTO mfi_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Kwa emnde na kuɗakurefkuɗe ge sapa gwatama ɗemɗeme na, sawmbare baɗemme ásezerwa, yá lyakurvárelya kwá puwánsepuwe. ");
INSERT INTO mfi_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Naba fawisarefe, tsahautsaha duksa ázerwa, aɗaba ya ura maggwe, ya slekemaare. Ba jirire geni kwá shansha puwansepuwe ge ire á kure. ");
INSERT INTO mfi_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Aɗaba duksa na yá de fakuraara iya, á de magakuránmaga emtakire, gwatame na yá de fakuraara iya keni, zlazlaɗa-ka essepa-aara ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Daaci shekwaashekwa cekwaaŋguɗi, vacite umele an kwaskwe á puwansepuwe Yaisu a degashe am dágave á fe-aha á hiya, á wáterá waya ge pukura-aha-aara maa, ta naba kezleve ire á hiya na, ta zuhe. ");
INSERT INTO mfi_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ba naráterna *Farisa-aha maa, a ba itare tá elvan ge Yaisu: «Ezzhara pukura-aha á ŋa tá maga názu piyatepiya shairiya á miya an vaci puwansepuwe.» ");
INSERT INTO mfi_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A naba ŋwaterantehe ge Yaisu, a ba ŋane á elvan ge itare: «Ekkure ndaakurseka názu ndza a maganaa *Dawuda am sarte na irice-aara antara emnde-aara baɗemme ŋateraaŋa waya na emtu? ");
INSERT INTO mfi_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Duwa-aatare á dem mashidi wá, ta de zuhe tapiske na ta fán ge slera á Dadaamiya na. Baráma á zuze-aara keni ɓelarateránka tsa. Una á ndaaná shairiya á miya wá, sey tá zana ba *liman-aha palle. ");
INSERT INTO mfi_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Emtu ndaakurseka am *tawraita, ganakini *liman-aha wá, ma vaci puwansepuwe keni, itare tá diya ba mága slera am mashidi emtu? Aɗaba una ŋanna, itare ma tsufarteka una am *tawraita keni, ɓaaka haypa áte itare. ");
INSERT INTO mfi_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ay degiya, aŋkwa názu jauje ba ge mashidi keni an ƴaikkire áhuna. ");
INSERT INTO mfi_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Á ndahaná wakita á Dadaamiya, a ba ŋane: Maggwire una yá kataná iya sadake á dabba-ka, á bina. Ma andze diyakurdiya una ŋanna wá, ma andze kwá faterarka shairiya ge emnde na ɓaaka haypa-aatare na. ");
INSERT INTO mfi_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ya ndahanaa áɗaba uwe una, aɗaba ba iya *Ura á emnde baɗemme una ya edda á vaci puwansepuwe ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tsetsa Yaisu áhuwa, a de demhe am mashidi-aha-aatare umele. ");
INSERT INTO mfi_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Am mashidi ŋanna wá, aŋkwa zhele an emtsa erva-aara. Emnde na tá am huɗe á bere ŋanna itare tá tsagwaɗa ba Yaisu, má watse á maganaamaga duksa na áte uŋŋule-aara-ka, lauktu ma ta puwar elva. Ta ndavanuhe áɗaba ba una ŋanna, a ba itare: «*Tawraita á naba vamiteva baráma geni mí mbanaambe ura an vaci puwansepuwe emtu?» ");
INSERT INTO mfi_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","A ŋwaterantehe ge Yaisu, a ba ŋane á elvan ge itare: «Máki a eblyemaa kyawe á kure á dem evege slaɗɗe an kwaskwe á puwansepuwe, kyawe á edda-aara keni palla ba ŋane, á zlála-ka á de sansese emtu? ");
INSERT INTO mfi_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sakwa ura emtu? Una ba jirire ganakini ƴaikke ba ura arge kyawe. Daaci estuwa, *tawraita á vante baráma á mága slera á maggwire ge ura an vaci puwansepuwe.» ");
INSERT INTO mfi_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Daaci a ba Yaisu á elvan ge zhele na an emtsa erva-aara na: «Pelansepele erva á ŋa». A naba pelanse, erva-aara gevge ba laŋŋe ba seke umele. ");
INSERT INTO mfi_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mázle-aara ba zlálá ge *Farisa-aha ta de maga sawari-aatare geni tá maganá estara, lauktu tá keɗanaakeɗa shifa á Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","De diyeddiye Yaisu sawari-aatare ŋanna maa, a naba ƴaa tate ŋanna, a naba zlala á dem tate umele. Dikele á emnde estuwa ta daa ɗaba ŋane. A mbateraahe emnde na ta lapika-aha na baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Amá a giyateraahe á ba an ndzeɗa geni a de ɓalateranseka labáre-aara ge emnde, ma ware ŋane keni. ");
INSERT INTO mfi_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Estuwa jiranvejire ŋane elva na ndza a balanaa nabi Aisaya, á ba ŋane: ");
INSERT INTO mfi_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«A bantsa Dadaamiya: Nawa una sleslera-aaruwa ya eksesaa ya, ŋane edda una a wayanaa ervauŋɗe-aaruwa, yá higa jipu áte ŋane. Watse yá se tsekwaná áte ŋane Sheɗekwe-aaruwa, á de ɓalaterá ŋane ge nalga-aha baɗemme, geni watse yá kya shairiya-aatare baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ŋane, tá de mbaɗeka we antara ura ɗekiɗeki, á de feka hula, ɓaaka ura á de cenancena kwara-aara á dem zhegela áte we á layye-aha. ");
INSERT INTO mfi_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ŋane wá, ma edda una ba seke názambakara na an dzala keni, ŋane á kezleka ɗekiɗeki. Ma ba seke kárá á názambakara na herzhe á emtsa keni, ŋane á emtsanaaka ɗekiɗeki. Á de magán ba estuwa sey má ganvege jirire á Dadaamiya am dagave á emndimagwaha. ");
INSERT INTO mfi_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Baɗemme á nalga-aha, watse tá fete tama-aatare á ba áte ŋane palle.» ");
INSERT INTO mfi_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Daaci ta sanaa zhele an jini ge Yaisu, jini na ganvege zhele ŋanna wulfe, ganvege uce. Amá Yaisu a naba mbanaahe zhele ŋanna, aŋkwa á nanna ice-aara, á ndaha elva ba laŋŋe zlaɓe ádaliye. ");
INSERT INTO mfi_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Emnde baɗemme tá aŋkwa maga ba najipu-aara, a ba itare: «Watse ba ŋane una wulfe á sleksu *Dawuda, ŋá aŋkwa ufufa na ka?» ");
INSERT INTO mfi_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Amá am sarte na cenaratercena *Farisa-aha, a ba itare: «Zhele ŋanna, a shaa hakuma á ba áza male-aatare á shaitaine-aha, zhera-aara *Bailjaibul, ge ŋgya jini-aha am emnde.» ");
INSERT INTO mfi_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Amá kerteŋ diyeddiye Yaisu názu am ire-aatare, daaci a ba ŋane á elvan ge itare: «Estuweka. Baɗemme á sleksire, máki tarapsete emnde gergere buwa am kwara ŋanna, tá aŋkwa dagala am dagave-aatare wá, sleksire ŋanna ba badzavbadze. Ma berni-ara, bi ma huɗe á há-ara keni, máki emnde na tá am huɗe-aara garevka palle, tá aŋkwa dagala am dagave-aatare wá, ba badzavbadze. ");
INSERT INTO mfi_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Daaci máki shaitaine á ŋgya jini-aha-aara ba ge ŋane wá, á wava áte ire-aara ba ge ŋane, á zlala estara kena kwara-aara á de katafke? ");
INSERT INTO mfi_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Náwa kwa bantsa kure, a vitaa ba *Bailjaibul hakuma ge ŋgya jini-aha am ura. Máki estuwa wá, a vatertaa ware kena hakuma á ŋgya jini-aha am ura ge emnde á kure? Tá kyaná ba emnde á kure shairiya-aara, geni ɓaaka jirire am elva á kure. ");
INSERT INTO mfi_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yá ndaakur ba jirire: Yá aŋkwa ŋgya jini-aha á ba an hákuma na a vitaa Sheɗekwe á Dadaamiya. Amaana wá, samsa ba Dadaamiya an sleksire-aara aseze kure.» ");
INSERT INTO mfi_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yaisu aŋkwa á slá Shaitaine an slendzeɗa, a ba ŋane á elvan ge itare: «Á dzegwaná estara ura de za há á slendzeɗa máki eksevaaka slendzeɗa ŋanna emtsaaɗe, a puwanse erva á kataliya, lauktu á za há-aara baɗemme? ");
INSERT INTO mfi_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«Daaci ma ware una ɓaaka an ya keni, ŋane kelaade-aaruwa. Ma ware una á meliyuka ge jáhá emnde na, ŋane slezaɗaterzaɗa. ");
INSERT INTO mfi_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Aɗaba una ŋanna maa, yá aŋkwa ndaakur ba jirire: Á naba ƴateraareƴe Dadaamiya ge emnde ma haypa-ara keni, antara elva-aha mandzawe na tá valyaná itare baɗemme. Amá edda una a ndaase elva mandzawe áte Sheɗekwe Cuɗeɗɗe wa, ɓaaka ƴanarƴe ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Máki ura a ndaase elva mandzawe áte *Ura á emnde baɗemme wá, á naba ƴanarƴe Dadaamiya haypa-aara. Amá edda una, má a ndaase elva mandzawe áte Sheɗekwe Cuɗeɗɗe wá, ɓaaka ƴanarƴe ge ŋane ɗekiɗeki, ma am zamane na, ma am zamane na á de sawa na keni.» ");
INSERT INTO mfi_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Egdza á nafa na emtake, sey tá shaná áte nafa na shagera. Tá shanka egdza á nafa emtake áte nafa laake. Ma nafa-ara keni tá diyeddiye á ba áte egdza-aara. ");
INSERT INTO mfi_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kure, elva-aha á kure á ja shifa seke wenye á zahe, kwá taa ndaaseka duksa shagera aɗaba kwa mandzawe-aha. We á ura wá, á ndaha ba názu jauje am ervauŋɗe á edda-aara. ");
INSERT INTO mfi_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Slekemaare, á sa arge shagerire á názena an ndaka am ervauŋɗe-aara, á sanse ba názena emtake na. Slemandzawe maa, á sa arge shagerkire á názena an ndaka am ervauŋɗe-aara, á sanse ba názena emtaŋka ɗekiɗeki na. ");
INSERT INTO mfi_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Yá ndaakur ba jirire: Vacite na Dadaamiya á de kya shairiya á duniya baɗemme wá, emnde baɗemme tá de shansha elva-aha laakire na tá aŋkwa tsakaná itare na baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Aɗaba ma ware keni tá de kyanaa shairiya á ba áte elva na aŋkwa á tsakaná ŋane baɗemme na, ma edda-aara áte jirire, ma áte fida keni.» ");
INSERT INTO mfi_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Daaci a ba emnde umele am malum-aha á *tawraita, antara *Farisa-aha, tá elvan ge Yaisu: «Malum, ŋá kátá ká maraŋerá najipu palle, ŋá diyeddiye átekwa máki a ɓelakaa ba Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","A ŋwete ge Yaisu, a ba ŋane á elvan ge itare: «Amá emnde a zamane na wa, ta mandzawe-aha váyya, varanteka ervauŋɗe-aha-aatare ge Dadaamiya. Itare tá aŋkwa ndava najipu ge diyise átekwa, máki a beliyaa ba Dadaamiya, amá tá shanka ɗekiɗeki. Hyaahya ba najipu na a marsaa Dadaamiya áte nabi Yaunas na. ");
INSERT INTO mfi_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ba seke una Yaunas a magaa váha keƴe, vaƴiya keni keƴe, am huɗe á kelfe na wá, iya *Ura á emnde baɗemme keni yá de gá váha keƴe vaƴiya keni keƴe am irekhya ba estuwa. ");
INSERT INTO mfi_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Vaci shairiya wá, emnde a *Niniwe tá de mbeɗateraambeɗa emnde a zamane na. Aɗaba itare, am sarte na cenaráncena waazu a Yaunas, magarnaamaga tuba. Amá náwa aŋkwa edda una jauje ge Yaunas kina, kure kwá maŋka tuba. ");
INSERT INTO mfi_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Zlaɓe ádaliye, vaci shairiya wá, aŋkwa slekse mukse, ŋane keni watse á mbeɗateraambeɗa emnde a zamane na. Aɗaba ŋane kwaye ndza a tsetaa am pute, a se cena waazu á Suleymanu sle-ilmu jipu. Amá náwa aŋkwa edda una jauje ge Suleymanu kina, kure kwá ceneka.» ");
INSERT INTO mfi_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Má sesse jini am ura wá, á de ja ɗaba á ba am kaamba, ge tataya tate á puwansepuwe. Máki shanka wá, ");
INSERT INTO mfi_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","á bánba jini ŋanna: Ambane yá eptsa á dem bere-aaruwa na ya segashe am huɗe-aara na. Má eptsaptsa wá, á de bera ba bere an hyaɗa, an tsatse tseɗaŋŋe, amá ɓaaka ura am kwa. ");
INSERT INTO mfi_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Daaci á zlálá-aara, á de ɗaha jini-aha umele na jaruje ba ge ŋane an mandzawire na vuye, tá sawa, tá se njá am huɗe-aara. Am iga-aara wá, edda-aara á gev ambane ba una ndza am zuŋŋwire na. Náza emnde a zamane mandzawe na keni, watse ba estuwa.» ");
INSERT INTO mfi_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yaisu aŋkwa á ndaater waazu ge emnde am bere wá, ta semhe ge tara emmeŋara antara egdzar mama-aha-ŋara wá, ta tsatsehe ágashe, tá kátá tá ndaha elva antara ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Daaci ura umele a de mbeɗanuhe ge Yaisu, geni tá aŋkwa ndavaná tara emmeŋara, tá antara egdzar mama-aha-ŋara ágashe. ");
INSERT INTO mfi_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yaisu á ŋwanante ge edda-aara, a ba ŋane: «Ware ŋane emmerwa ge iya? Emnde-ara ŋane egdzar mama-aha-aaruwa ge iya?» ");
INSERT INTO mfi_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Daaci á mara pukura-aha-aara an erva, a ba ŋane: «Náwa tara emmerwa antara egdzar mama-aha-aaruwa tá áhuna. ");
INSERT INTO mfi_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ma ware una aŋkwa á maga názu á kataná Edderwa am samaya, edda-aara egdza emmerwa zhele, bi egdza emmerwa mukse, bi emmerwa.» ");
INSERT INTO mfi_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Vacite ŋanna wá, Yaisu a tseta á ba am mba, a de nja áte we á haye geni á kwaraterse elva ge emnde. ");
INSERT INTO mfi_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Daaci emnde kwakya se jarammeje ázeŋara, ŋane a naba njema am paare áte ire á haye; emnde wá, baɗemme tá á ba am haha áte we á haye ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A kwaraterse duksa kwakya an naraje-aha, a ba ŋane á elvan ge itare: ");
INSERT INTO mfi_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","«Sesse zhele umele ge de puwa nalkame am fe-aara. Am sarte na aŋkwa á puwa nalkame ŋanna, wulfe-aha umele a de valyaa áte uŋŋule, ta se tsakantehe ge ƴiye-aha. ");
INSERT INTO mfi_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Wulfe-aha umele, a de valyaa áte cacera, cekwa haha, a naba sesehe á ba áte watsewatsire aɗaba cekwa haha. ");
INSERT INTO mfi_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Amá de sesse vaciya an kárá wá, deraadera áɗaba ɓaaka slalwe ŋgelama. ");
INSERT INTO mfi_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Wulfe-aha umele zlaɓe ádaliye, a valyemaa am dake, a waltaa am dake, a ɓecante ge dake. ");
INSERT INTO mfi_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Amá wulfe-aha umele wá, a puwaa á ba am haha shagera, a magaa ire shagera. Ekte-aha umele, ta yayaa egdzara deremke deremke; ekte-aha umele ta yayaa egdzara kul uŋkwahe kul uŋkwahe, ekte-aha umele zlaɓe ádaliye ta yayaa kul keƴe kul keƴe.» ");
INSERT INTO mfi_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Daaci a ba ŋane á elvan ge itare: «Edda una máki aŋkwa hyema-aara wá, a cenevaacena!» ");
INSERT INTO mfi_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Am iga á una ŋanna maa, ta naba sawa pukura-aha áseza Yaisu, a ba itare tá elvan ge ŋane: «Labára ká ndater elva ge emnde an naraje-aha?» ");
INSERT INTO mfi_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A ŋwaterante, a ba ŋane: «Kure wá, vararakurteva barama geni kwá diyeddiye nasherire na am *kwara á Dadaamiya, amá itare sharanka una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aɗaba edda una áŋkwa ázeŋara wá, tá de fanaarfe á de jauje á ba áte ŋane. Amá edda una an erva dey wá, ba egdza una ázeŋara na keni, watse tá de lyanvulye. ");
INSERT INTO mfi_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Aɗaba una ŋanna, yá ndater elva an naraje. Aɗaba ma tá aŋkwa ezzhárá ɗeme keni tá nánka; tá effa ɗeme hyema keni, tá cenánka duksa ɗekiɗeki, á duka á dem hyema-aatare. ");
INSERT INTO mfi_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Estuwa, názena ndza a ndahanaa Dadaamiya á kya an we á nabi Aisaya na gevge jirire-aara. Aɗaba a ba ŋane: Kwá aŋkwa eccena an hyema-aha á kure, amá kwá cenanka ba názara keni. Kwá aŋkwa ezzhara an ice-aha á kure, amá kwá nanka duksa. ");
INSERT INTO mfi_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Aɗaba degdega ire á emnde ŋanna. An vanya hyema-aha-aatare, geni a demka elva-aaruwa á demkwa. An háɗá ice-aha-aatare, geni a naránka duksa-aaruwa an ŋane. Aɗaba ire-aatare degdege jipu, tá sawka á sem sera-aaruwa, geni yá se mbateraambe, a ba Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Amá kure wá, higa ƴaikke ge kure, aɗaba ice-aha á kure aŋkwa á nanna duksa-aha á Dadaamiya, hyema-aha á kure aŋkwa cenancena. ");
INSERT INTO mfi_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yá bakurá ba jirire: Kwakya nabi-aha antara emnde á Dadaamiya umele ta kátá puwete ba ice-aatare áte názena kwá aŋkwa zharaná kure kina, amá naranka. Ndza ta kátá cena názena kwá aŋkwa cenaná kure kina, amá cenaranka.» ");
INSERT INTO mfi_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Cenaucena ba shagera náwa yá aŋkwa ndaakur maana á naraje an slepuwa wulfe na. ");
INSERT INTO mfi_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Emnde umele, tá cenvá elva áte *kwara á Dadaamiya, amá á duka á dem ire-aatare. Daaci á sawa zhele mándzawe, á se eksese elva ŋanna am vuwa-aatare. Itare wá, ta ba seke uŋŋule. ");
INSERT INTO mfi_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Emnde umele ta ba seke cacera. Itare, má cenarvaacena elva áte kwara á Dadaamiya wá, kerteŋ tá lyiyaná á ba an higa. ");
INSERT INTO mfi_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Amá tá vanteka sleɗe ge elva á Dadaamiya am vuwa-aatare. Daaci má jerje lámare umele bi zlaɗa aɗaba elva á Dadaamiya na wá, tá ƴa fetarfire-aatare ba watsewatse. ");
INSERT INTO mfi_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Emnde umele zlaɓe ádaliye wá, ta ba seke dake. Tá lyevalya tsa elva á Dadaamiya, amá wá, á dem dágave á dzama á ire-aha á duksa á duniya gergergre, antara wáyá á nalmane á duniya kwakya. Á ɓecanta ba una ŋanna elva á Dadaamiya na am itare na, á maŋka nampire ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Amá emnde umele wá, ta ba seke haha na sleɗe shagera na. Itare, má cenarvaacena elva á Dadaamiya wá, á duwa á dem ire-aatare ba shagera. Elva á Dadaamiya á sha sleɗe am itare, itare tá maga nampire. Emnde umele kwakya nampire-aatare; emnde umele nampire-aatare ba deydey. Emnde umele zlaɓe adaliye, nampire-aatare ba cekwa.» ");
INSERT INTO mfi_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Daaci a bateraa naraje umele zlaɓe ádaliye, a ba ŋane á elvan ge itare: «Náwa názu á garava an *kwara á Dadaamiya. Aŋkwa ura umele a ica faha-aara, a de jem hiya. ");
INSERT INTO mfi_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Vacite umele an vaƴiya maa, duwa kelaade-aara, a naba de janem wulfe á ezleha am hiya-aara ŋanna, a naba zlala. ");
INSERT INTO mfi_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Am sarte na waltewala hiya a sanse ire maa, ezleha-aha keni sesse. ");
INSERT INTO mfi_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Daaci duwa á emnde a slera á edda á fe ŋanna á dezeŋara, a ba itare tá elvan ge ŋane: Ambarka á ŋa male! Ábi ka jaa ba wulfe á jirire am faha á ŋa? Labara kwakya ezleha am hiya á ŋa? ");
INSERT INTO mfi_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","A ŋwaterante, a ba ŋane: A maganaa ba kelaade-aaruwa lámare na. A ba emnde a slera tá elvan ge ŋane: Eksakaarekse emtu ŋá de ica ezleha-aha ŋanna baɗemme á dem áhá? ");
INSERT INTO mfi_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ƴawanƴa, a ba ŋane á elvan ge itare, aɗaba watse kwá icesice antara hiya shagera. ");
INSERT INTO mfi_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ƴawanƴa baɗemme á narnáhá; má narvenahe, hyephye sarte á ica hiya wá, watse yá bateranba ya ge emnde a ica hiya geni a icarsice emtsaaɗe ezleha-aha, a jaranmejahe am tate palle, a epsharupsha an kárá, lauktu tá haliya hiya-aaruwa á dem kuvere.» ");
INSERT INTO mfi_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yaisu a bateraa naraje umele zlaɓe ádaliye, a ba ŋane á elvan ge itare: «*Kwara á Dadaamiya wá, ba seke mága á wulfe á pilli, a eksante ge ura umele, a de ɓeleme am haha am fe-aara. ");
INSERT INTO mfi_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Cekwa ba ŋane am wulfe-aha á duksa, amá má de sesse, waltewala wá, hyema-aha-aara jauje ge hyema á duksa-aha umele an prempremire, gevge mama á nafa, haa ƴiye-aha tá maga bere-aha-aatare áte erva-aha-aara.» ");
INSERT INTO mfi_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yaisu a bateraa naraje umele zlaɓe ádaliye, a ba ŋane á elvan ge itare: «*Kwara á Dadaamiya wá, ŋane ba seke mága á shahi á makala. Á ekseváksa mukse ba cekwaaŋguɗi, á puwante ge ukpa tasa keƴe an wasla, amá á tsantetse shahi á makala na ukpa na baɗemme.» ");
INSERT INTO mfi_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yaisu a kwaraterse elva-aha ŋanna baɗemme na an naraje-aha gergergre, ɓaaka názu a baternaa ŋane ɓaaka naraje am huɗe-aara. ");
INSERT INTO mfi_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","An una ŋanna wá, maganaamaga názena ndza a ndaanaa nabi Aisaya am nabiyire-aara na, a ba ŋane: «Watse yá bateranba elva-aha-aaruwa ge emnde an naraje-aha.» A ba ŋane zlaɓe ádaliye: «Duksa-aha na ndza an sheɓe kwaye am fakte á duniya keni, watse yá ndaatersendahe.» ");
INSERT INTO mfi_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Am sarte na Yaisu puwaterapuwa emnde, ŋane keni a de demhe am bere. Ta duhe ge pukura-aha-aara á dezeŋara, a ba itare tá elvan ge ŋane: «Palaŋernaapala maana á naraje an ezleha am hiya na.» ");
INSERT INTO mfi_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Daaci a ba ŋane á elvan ge itare: «Sleja wulfe wá, ba iya ya *Ura á emnde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Fe wá, duniya. Hiya keni maa, emnde na watse tá dem *kwara á Dadaamiya. Ezleha maa, emnde na tá átuge zhel mándzawe. ");
INSERT INTO mfi_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kelaade na a de jem ezleha ŋanna am hiya, Shaitaine. Sarte á ica hiya, amaana halavuwa á duniya. Emnde á ica hiya, malika-aha á Dadaamiya. Kwaye ŋane maana á naraje ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ba seke una ta icese ezleha am hiya, ta de peshanaa an kárá na wá, am halavuwa á duniya keni watse ba estuwa. ");
INSERT INTO mfi_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Iya *Ura á emnde baɗemme, watse yá puwa malika-aha-aaruwa á sawa, tá se dzerese emnde a emtaŋkire á hala antara emnde na tá vaterte ektapaare ge emnde na am kwara-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Malika-aha tá de puwaterem am kárá á jahanama, tá de kyuwa am kárá ŋanna, tá de kerɗa slare am kárá. ");
INSERT INTO mfi_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Amá emnde na tá aŋkwa fansarfe ge Dadaamiya wá, itare tá de gev ba seke vaciya an wulwulire am zlanna á Eddetare Dadaamiya. Edda una aŋkwa hyema-aara a cenvaacena elva ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«*Kwara á Dadaamiya wá, á garava an nalmane na an heɗa am fe, de shansha ura umele, a sheɓanvehe zlaɓe ádaliye, á higa jipu. A de vala názu am erva-aara baɗemme geni sey á shekwepshekwe fe na. ");
INSERT INTO mfi_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Zlaɓe ádaliye, kwara á Dadaamiya á garava an sletsakala, á tataya ba náza hyema na shagera na. ");
INSERT INTO mfi_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Má shansha palle, una shagera jipu zlazlaɗa gane-aara na, á valuvale názena am erva-aara baɗemme, á de shekwa náza hyema ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Zlaɓe ádaliye, *kwara á Dadaamiya á garava an narre na tá puwaná emnde a sluwa kelfe á dem haye, tá duwa jili á kelfe-aha gergergre á dem huɗe-aara. ");
INSERT INTO mfi_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Má naatena, tá teɗese ásegashe, tá dzera kelfe shagera shagera á dem ilila-aha-aatare, una ɓaaka nampire-aara na ta puwanvehe. ");
INSERT INTO mfi_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Am halavuwa á duniya keni watse á magava ba estuwa. Watse tá sawa malika-aha, tá se lateraale emnde na shagera hala-aatare, antara emnde na shagerka hala-aatare. ");
INSERT INTO mfi_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Daaci emnde na shagerka hala-aatare na maa, watse tá puwaterá á dem kárá á jahanáma, tá de kyuwa, tá de kerɗa slare am kárá ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Am iga á naraje-aha ŋanna maa, Yaisu a ndavateru ge pukura-aha-aara, a ba ŋane á elvan ge itare: «Cenakurancena una-aha ŋanna baɗemme?» «Cenaŋerancena», a ba pukura-aha tá elvan ge ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Daaci a ba ŋane á elvan ge itare: «Máki estuwa, ma ware una malum á *tawraita na aŋkwa fansarfe ge Slekse ƴaikke am samaya na, ŋane á garava an edda á há na emgyegwe a duksa keni, sey tá shaná á ba am mba-aara, duksa aŋwaslire keni á ba am mba-aara na.» ");
INSERT INTO mfi_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Zlauzle Yaisu am tsakaterse naraje-aha ŋanna maa, á tsetehe am tate ŋanna, ");
INSERT INTO mfi_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","a zlalehe á dem ekse na a waletaa am huɗe-aara na. A de fantau ge kwaraterse duksa ge emnde am *mashidi á Yahudiya-aha. Emnde na tá áhuwa baɗemme tá maga ba najipu-aara geni a shanaa áme ilmu-aara ŋanna, a vantaa ware hakuma á mága najipu-aha-aara ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ta bantsa itare wá: «Ábi ba ŋane una egdza á slega nafa na? Ba ŋane kahe una zhera á emmeŋara Maari na? Ábi ba ŋane una egdza emmetare ge tara Yakuba, antara Yusufu antara Simaun ira Yahuda? ");
INSERT INTO mfi_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ábi egdzar mama-aha-ŋara ŋwasha keni tá aŋkwa á ba am dagave á miya áhuna? A shanaa áme kena ŋane hakuma estuwa?» ");
INSERT INTO mfi_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","A piyatertaa ba una ŋanna ge fetaare áte ŋane, ɓaaka umele. Daaci a ba Yaisu á elvan ge itare: «Ma áme keni emnde tá fa zherwe áte nabi á Dadaamiya, amá am ekse-aara wá, tá feka zherwe áte ŋane.» ");
INSERT INTO mfi_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Daaci Yaisu a magaa najipu-aha ba cekwaaŋguɗi áhuwa, aɗaba tá fetareka emnde áte ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Daaci am sarte ŋanna cenancena sleksu *Hirudus labare á Yaisu. Hirudus ŋanna wá, ŋane slekse á kwara á Galili. ");
INSERT INTO mfi_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","A ba ŋane á elvan ge emnde-aara: «Una degiya ba Yuhanna slemaga baptisma. A tsetaa ba ŋane am faya. Aɗaba una ŋanna an hákuma á mága najipu-aha gergere.» ");
INSERT INTO mfi_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","A bateraa una ŋanna aɗaba ndza a ndahanaa ba ŋane ŋanna geni a eksarvaksa Yuhanna. Daaci ta naba eksevaahe, ta puwete zawa áte ŋane, ta de ɓelema am daŋgay. A ŋguɗanaa aɗaba uwe Hirudus Yuhanna, aɗaba Hirudus ŋanna a eksantaave Hirudiya ge egdza emmeŋara Filip. ");
INSERT INTO mfi_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Amá aŋkwa á ndandaha Yuhanna, geni a eksantaave mukse ge egdza emmeŋara na wá, una ŋanna zlayeka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ndza Hirudus á kátá keɗa shifa á Yuhanna á ba am sarte ŋanna, amá a kuva emnde a ekse, aɗaba baɗemme á Yahudiya-aha fartarefe an Yuhanna, geni ŋane nabi á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Daaci shekwaashekwa cekwaaŋguɗi wá, samsa sarte á ya Hirudus, a magaa egdza muŋri. Duwa á egdza á Hirudiya mukse, a de shekelaterante ge emnde na a ɗahateraa Hirudus á sem muŋri-aara. Una ŋanna hayanhaya jipu sleksu Hirudus. ");
INSERT INTO mfi_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","A naba zanu ba waɗa ge gyaale ŋanna, geni ma a ndavanu uwe keni sey á vanteva. ");
INSERT INTO mfi_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ba zlala ge gyaale na, a de ndava sawari áza emmeŋara emtsaaɗe. Zlarauzle am sawari antara emmeŋara maa, sawa-aara áseza sleksu Hirudus, a ba ŋane á elvan ge ŋane: «Iya wá, yá kata ká vite ire á Yuhanna slemaga baptisma am kwatame.» ");
INSERT INTO mfi_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Una ŋanna namaari-aareka ɗekiɗeki ge sleksu Hirudus, amá am a zanuwa ba ŋane waɗa ge gyaale ŋanna á katafke á emnde-aara baɗemme, a naba eksaarhe. Daaci a ba ŋane: A varanteva ba názena a ndavana ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Daaci a naba ɓela ura á de ica ire á Yuhanna slemaga baptisma am daŋgay. ");
INSERT INTO mfi_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ta de icaa ire áte Yuhanna am daŋgay wá, tá sanhe am kwatame, ta se vante ge gyaale ŋanna, ŋane keni a zlala an ire na á deza emmeŋara. ");
INSERT INTO mfi_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Saremsa pukura-aha-aara ge Yuhanna, ta se eksante emtsa-aara, ta de heɗehe, ta naba de mbeɗanu labare ge Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Cenancena Yaisu labare á emtsa á Yuhanna, ta naba tsetehe am tate ŋanna, ta dema am paare á yawe, ta zlala á dem tate na ta ɓaaka emnde átekwa na. Cenarancena emnde am huɗe á ekse geni zlazlala Yaisu maa, baɗemme á emnde saresse am eksa-aha-aatare, ta ɗabem Yaisu an sera, ta ɗaba ba we á haye, we á haye. ");
INSERT INTO mfi_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","De sessa Yaisu am paare maa, á zhárá ba dikele á emnde tá kela ádezeŋara, a naba zatervaarhe, a mbateraahe emnde na ta lapika-aha am dagave-aatare. ");
INSERT INTO mfi_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Eblyabelya vaciya maa, ta duhe ge pukura-aha-aara á dezeŋara, a ba itare tá elvan ge ŋane: «Ɓaaka vaciya mazla-aara, tate na keni kaamba, ambane puwateraapuwa emnde na, a zlarzlala á dem ekse-aha, tá de shakwanu náza za ge shifa-aha-aatare.» ");
INSERT INTO mfi_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A ba Yaisu á elvan ge itare: «Ma zlalarka keni ba kalle, vawaterteva ba kure názu tá zuze.» ");
INSERT INTO mfi_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Amá ta ŋwanante a ba itare: «Ɓaaka duksa ázeŋere, sey ba depaiŋ ilyeɓe, antara kelfe buwa, ɓaaka umele.» ");
INSERT INTO mfi_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","«Sawansa una ŋanna ásezerwa», a ba Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Daaci a ba ŋane á elvan ge emnde: «Njawinja baɗemme áte masa na.» Ŋane a halante depaiŋ ilyeɓe, antara kelfe buwa na, a kante ice á dem samaya, a slafanaa we-aara ge Dadaamiya, daaci a kwacaa depaiŋ-aha na, a tegateraa ge pukura-aha, geni tá vaterta ge emnde. ");
INSERT INTO mfi_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Baɗemme á emnde, ma ware keni a zuhe á ba áte huɗe-aara, aley jauje zlaɓe ádaliye. Pukura-aha ta halante jugena-aara ŋanna wárá kelaawa ju buwa. ");
INSERT INTO mfi_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kezlakula á emnde a zá náza zá ŋanna wá, tá maga zála debu ilyeɓe, ɓaaka ŋwasha antara egdzara am huɗe-aara. ");
INSERT INTO mfi_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Shekwaraaka ɗekiɗeki am iga á za depaiŋ ŋanna, a ba Yaisu á elvan ge pukura-aha-aara: «Dawemda am paare, dawedde kure zuŋŋwe á katafke-aaruwa, ebzaubze guwa á kya erwa. Iya wá, yá puwateraapuwa emtsaaɗe emnde.» ");
INSERT INTO mfi_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Puwateraapuwa emnde maa, a naba ɗaleme am egdza wa ba ŋane palle, ge de maga maduwa. Dem vaƴiya ba shagera, ba ŋane palle áte wa ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Am sarte ŋanna wá, paare na pukura-aha tá am huɗe-aara na, zlazlala ƴiƴiye. Amá aŋkwa á maganá palasa vadza á yawe áhuwa, aɗaba a se yateruwa válale, á berhaterá á sem iga. ");
INSERT INTO mfi_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","An ireŋlya wá, a duhe ge Yaisu de shateraasha pukura-aha-aara na áte ire á haye, amá á zlala á ba an sera-aara áte ire á haye ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ba naranna pukura-aha-aara ŋane aŋkwa á zlala áte yawe na wá, gazlargazla jipu, ta naba fu hula ge lyawa, aɗaba itare ta kurken shaitaine á yawe. ");
INSERT INTO mfi_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kerteŋ a ndaater elva Yaisu: «Gazlauka degiya una ba iya, a wakurka lyawa», a ba ŋane á elvan ge itare. ");
INSERT INTO mfi_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","A ŋwanante ge Piyer, a ba ŋane á elvan ge ŋane: «Máki ba jirire una ba ka Yaakadada wá, ndaasendahe elva á ŋa palle, geni yá duwa á dezeŋa áte yawe ba seke náza á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","«Sawa!» a ba Yaisu á elvan ge ŋane. A naba tsekwese am paare na ge Piyer, a fantau ge zlala áte yawe á deza Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amá ba a fantau ge zhárá mága á effeƴa wá, a ja ge lyawa, a fantau ge ŋgye á dem yawe. Daaci a naba fu hula: «Yaakadada-aaruwa lyilya!» ");
INSERT INTO mfi_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kerteŋ a velante erva-aara Yaisu, a de ŋanaahe, a ba ŋane á elvan ge ŋane: «Degiya jeba á cekwire á fetarfire na! Labara ka magaa shaige?» ");
INSERT INTO mfi_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Daaci ta ɗalema am paare bukerɗe-aatare. Tseriyye a naba ɗuhe ge válale keni. ");
INSERT INTO mfi_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Pukura-aha baɗemme ta kezlan ugje ge Yaisu am paare ŋanna. A ba itare tá elvan ge ŋane: «Ekka wá, ka *Egdza á Dadaamiya ba jirire.» ");
INSERT INTO mfi_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ba ebzarubze haye, daaci daraada am haha á Gainaizarait. ");
INSERT INTO mfi_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Emnde a ekse na ta de tsekwa am huɗe-aara na diyareddiye Yaisu, daaci duwa-aatare ge itare ta hyenme labare-aara am haha-aatare baɗemme, ta naba sanaa emnde na ta lapika-aha na baɗemme ge Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ta ndavanuhe geni a vaterteva baráma ge emnde na lapika vuwa-aatare na, tá fafetefafa ba erva-aha-aatare á ba áte we á naŋgyuwe-aara keni. Daaci emnde na ta fafete erva-aha-aatare áte naŋgyuwe á Yaisu baɗemme mbarembe. ");
INSERT INTO mfi_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Am iga á una ŋanna maa, ta semhe ge *Farisa-aha antara malum-aha á *tawraita á sa am huɗe á Urusaliima, ta se ndavanu elva ge Yaisu, a ba itare: ");
INSERT INTO mfi_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Labara pukura-aha á ŋa tá maŋka názu ta kwaramisaa eggye-aha á miya? Aɗaba ŋá aŋkwa zharaterzhara tá bareka erva ge za náza za áte naɗe á emnde a nadina.» ");
INSERT INTO mfi_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","A ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Ekkure maa, labara kure keni kwá aŋkwa cuɗa názu a ndaasa Dadaamiya, an tsaha na kwa jansaara ba kure? ");
INSERT INTO mfi_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Aɗaba a ba Dadaamiya, ɗematerveɗeme tara eddeŋa an emmeŋa. Ma a ndahesaa ware elva mándzawe áte eddeŋara, bi áte emmeŋara keni, sey tá ejja ba shifa-aara. ");
INSERT INTO mfi_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amá kwa bantsa kure wá: Máki ndakansendahe ge eddeŋa, bi ge emmeŋa, geni nalmane na ma andze yá melakumele an ŋane na wá, aŋkwa fanefa tsekemme, watse yá danán ge Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Máki ndakansendahe estuwa wá, ka ɓaaka an wedera melanu ge eddeŋa, ma emmeŋa keni mazle-aara. An jeba á tsaha á kure ŋanna, kezlakuranveka názena a ndaasaa Dadaamiya emtu? Kezlakuranvekezle ba parakke! ");
INSERT INTO mfi_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Egdzara á fida-aha, tá demka am huɗe á kure ɗekiɗeki. Sesse jirire á názena ndza a ndahanaa Aisaya am nabiyire-aara na. Ndza a ndahanaa á ba áte kure. Aɗaba a ba ŋane: ");
INSERT INTO mfi_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“A bantsa Dadaamiya wá: Emnde na wá, tá aŋkwa á galiyá á ba áte we, am ervauŋɗe-aatare ta ƴiƴiye an ya. ");
INSERT INTO mfi_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tá aŋkwa jáháva ɗeme am sera-aaruwa, amá una ŋanna ba dey. Aɗaba itare tá ndáhá ba naɗe-aha á emndimagwaha, ta ganve ba seke elva-aaruwa.” » ");
INSERT INTO mfi_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Daaci a ba Yaisu á elvan ge emnde baɗemme: «Sawmbare, cenauvaacena elva na ba shagera: ");
INSERT INTO mfi_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Názu á badza ura wá, á badzaná názu á fana edda-aara á dem mbuweka, á badzaná ba názu á segashe am mbuwe á edda-aara.» ");
INSERT INTO mfi_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ta duhe ge pukura-aha-aara á dezeŋara, a ba itare tá elvan ge ŋane: «Diyakdiya emtu ganakini aŋkwa á waterwa elva á ŋa na am ervauŋɗe ge *Farisa-aha?» ");
INSERT INTO mfi_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","A ba Yaisu: «Baɗemme á wulfe na a janaa Edderwa na am samaya na ka tsawe, watse tá eɓɓeta á degashe. ");
INSERT INTO mfi_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ƴawaterƴa seke itare, ábi ta wulfe-aha tá táɗá wulfe-aha seke itare. Máki wulfe á táɗá ukfeŋara wulfe, ba bukerɗire-aatare tá de puwa á dem evege.» ");
INSERT INTO mfi_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","A ba Piyer á elvan ge ŋane: «Palaŋeraapala maana á naraje na ŋá cenvaacena.» ");
INSERT INTO mfi_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","«Ba kure keni kwaasau kwá cenanka? ");
INSERT INTO mfi_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Baɗemme á názena á dem mbuwe á urimagwe, a tsekwa á ba á dem huɗe, amá á degashe zlaɓe adaliye am ŋane; una ŋanna ni diyakurka? ");
INSERT INTO mfi_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amá názu á segashe am mbuwe á ura wá, kwaye a fantau á sawa am ervauŋɗe, á badzaná ba una ŋanna edda-aara. ");
INSERT INTO mfi_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Aɗaba kwakya dzama ire mandzawe na á segashe am ervauŋɗe á ura. Á berhaná ba una ŋanna á de ja shifa, antara mága gwardzire, antara dakarire, an neylire, fidire, ira sanse elva ƴaiƴaihe. ");
INSERT INTO mfi_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","A badzaná ba jeba á duksa-aha ŋanna ura. Aɗaba zu duksa an erva na baraaka áte naɗe á emnde a nadina wá, una ŋanna á badzeka ura.» ");
INSERT INTO mfi_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Am iga á una ŋanna maa, a tsetehe ge Yaisu am tate ŋanna, kwaye a zlala á dem haha á Tirus antara Sidaun. ");
INSERT INTO mfi_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aŋkwa mukse Kanani umele á njá am haha ŋanna, a sawhe á seza Yaisu, a ba ŋane á elvan ge ŋane á ba an ka kwara: «Edda-aaruwa! Ura jeba á *Dawuda! Tasle á ŋa zivarze! Aɗaba aŋkwa egdza-aaruwa mukse an shaitaine, aŋkwa á maga ba palasa.» ");
INSERT INTO mfi_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Amá mbeɗanareka Yaisu ba elva palle keni. Mukse na keni ƴanka ɗabaterɗaba. Ta naba duhe ge pukura-aha-aara á dezeŋara, a ba itare tá elvan ge ŋane: «Ndandaha seke elva palle ge mukse na a ezzlala mazle-aara, aɗaba aŋkwa á hulamitehula ba dey.» ");
INSERT INTO mfi_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","A ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Iya wá, ɓelarika ge emnde umele, ta ɓeli ba ge emnde a *Iserayiila, aɗaba itare ta ba seke kyawe-aha na, ta keɗa an keɗa na.» ");
INSERT INTO mfi_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Amá cenaaka mukse na, a naba se ŋanta sera ge Yaisu: «Tasle á ŋa meliyumele edderwa», a ba ŋane á elvan ge Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","A ŋwanante ge Yaisu, a ba elva-aara á elvan ge mukse na: «Haleta ɗafa á egdzara, puwateranve ge kere-aha wá, zlayeka ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","«Ba estuwa», a ba mukse na, «amá ma kere-aha keni tá wazaná ba itare kwaca á ɗafa na á valya á sawa am erva á dada-aha-aatare na.» ");
INSERT INTO mfi_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","A ba Yaisu: «Ekka mukse na, kwakya fetarfire á ŋa. Názena ká kataná ká ŋanna wá, a gevge á ba áte una ŋanna.» A naba mbehe ge egdza á mukse ŋanna á ba am sarte ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Am iga á una ŋanna maa, a tsetehe ge Yaisu am tate ŋanna, a ɗaba we á haye á Galili, a de ɗaleta áte egdza wa umele, a de njehe áte egdza wa ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nalga á emnde kwakya ta ɗabem Yaisu á dete wa ŋanna, ta danaa antara emnde a dere, antara wulfe-aha antara ŋgurƴekwe-aha, an uce-aha, antara lapika-aha umele gergere kwakya, ta de puwateraa am sera á Yaisu, a mbateraahe baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Emnde na ndza ta uce-aha tá aŋkwa ndaha elva ba laŋŋe; emnde na ndza ta ŋgurƴekwe-aha mbarembe; emnde na ndza ta dere-aha tá aŋkwa zlala ba laŋŋe; emnde na ndza ta wulfe-aha keni tá aŋkwa nanna ice-aha-aatare baɗemme. Baɗemme á emnde na ta naa una ŋanna, tá maga ba najipu-aara. Daaci baɗemme ta fantau ge gálá Dadaamiya á emnde a *Iserayiila. ");
INSERT INTO mfi_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Am iga á una ŋanna maa, Yaisu a ɗetaa pukura-aha-aara, a ba ŋane á elvan ge itare: «Emnde na tá wiwa am ice ge iya, aɗaba hare keƴe vatena tá á ba ázerwa, názu tá ezza keni ɓaaka. Wayanka yá puwateraapuwa ba estuwa tá an waya am huɗe, a de mbaɗateraaka waya áte barama a da.» ");
INSERT INTO mfi_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","A ba pukura-aha tá elvan ge ŋane: «Mí de shaná áme kena náza zá am kaamba na ni haa á hyater ge emnde kwakya estuwa?» ");
INSERT INTO mfi_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","«Aŋkwa wanyara depaiŋ ázekure?» a ba Yaisu á elvan ge itare. A ba itare: «Aŋkwa depaiŋ vuye, antara egdza kelfe-aha cekwaaŋguɗi.» ");
INSERT INTO mfi_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Daaci «njawinja am haha,» á ba Yaisu á elvan ge emnde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ŋane a halante depaiŋ-aha vuye antara egdza kelfe na, a slafanaa we-aara ge Dadaamiya, a kwacaahe, daaci a naba tegateraa ge pukura-aha-aara, itare ta tegateraa ge emnde. ");
INSERT INTO mfi_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ma ware-aatare keni a zuhe á ba áte huɗe-aara, ta ƴanaa ba itare náza zá. Pukura-aha ta jemaa jugena-aara ilila vuye. ");
INSERT INTO mfi_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kezlakula á emnde na ta za náza za ŋanna, tá maga zála debu ufaɗe, ɓaaka ŋwasha antara egdzara am huɗe-aara. ");
INSERT INTO mfi_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Daaci Yaisu a puwaa emnde. Am iga-aara maa, a dema am paare, a zlala á dem haha á Magadan. ");
INSERT INTO mfi_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ta sawhe ge *Farisa-aha, antara *Saduki-aha áseza Yaisu, ta se tsagwaɗana áte elva, a ba itare tá elvan ge ŋane: «Máki a ɓelakaa ba Dadaamiya wá, maraŋeranmara najipu palle geni ŋá diyeddiye átekwa.» ");
INSERT INTO mfi_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Ábi kure máki hyaahya yawe kwakya dem eblya vaciya, kwá ba: Makuralla wá, watse ba laŋŋe sleɗe. ");
INSERT INTO mfi_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","An eŋlya-waabere keni, má kwa nanna daŋŋwe ekte á samaya, á ŋgya vaciya á ba am huɗe-aara, kwá ba: Watse á maga yawe vatena. Iyau, nalaama-aha na aŋkwa á magava áte samaya wá, baɗemme diyakurdiya; duksa-aha na aŋkwa á marakurná Dadaamiya am zamane na wá, diyakurka! ");
INSERT INTO mfi_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kure emnde na kwá am zamane na, kwa mándzawe-aha jipu, vakuranteka ervauŋɗe á kure ɗekiɗeki ge Dadaamiya. Kure kwá ndava najipu! Ba palle keni kwá nanka mazle-aara, hyaahya ba una kwá aŋkwa ndaaná áte Yaunas werre na.» Ba a ndaaterse una, a naba ƴaterhe, a zlala-aara. ");
INSERT INTO mfi_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Am sarte na tá aŋkwa zlala, tá átira degashe am haye á dete iga á guwa, pukura-aha ta naba viyaa depaiŋ, slaslarka ekseksa-aara. ");
INSERT INTO mfi_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Daaci a ba Yaisu á elvan ge itare: «Faufa hyema ba shagera, tsufautsufa ire á kure átuge shahi á makala á *Farisa-aha antara *Saduki-aha.» ");
INSERT INTO mfi_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Am cenaránka pukura-aha názu a ndahanaa ŋane, a ba itare am dagave-aatare: «Yaisu a ndaha una ŋanna aɗaba mi viyaa depaiŋ na.» ");
INSERT INTO mfi_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Carare cenancena Yaisu elva na tá aŋkwa ndahaná itare am dagave-aatare, a ba ŋane á elvan ge itare: «Labara kwá tsala elva a ɓaakire á depaiŋ am dagave á kure? Kure degiya ɓaaka fetarfire á kure ɗekiɗeki! ");
INSERT INTO mfi_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Sem ba kina keni aley zlaɓe ba kwá cenanka? Kwá yeheteka á ba áte depaiŋ ilyeɓe na ya kwacateraa ya ge emnde debu ilyeɓe na emtu? Kwá yeheteka á ba áte kezlakula wárá-aha na kwa nahetaa an jugena-aara na emtu? ");
INSERT INTO mfi_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Zlaɓe adaliye kwá yeheteka áte depaiŋ vuye na ya kazlateranvaa ya ge emnde debu ufaɗe antara kezlakula á ilila-aha na kwa nahete an jugena-aara na emtu? ");
INSERT INTO mfi_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Labara kwá lanaaka ganakini ya ndaakur elva á depaiŋ ka? Iya wá, ya bakuraa, tsufautsufa ire á kure ba shagera atuge shahi á makala na á segashe am *Farisa-aha antara *Saduki-aha.» ");
INSERT INTO mfi_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Daaci sharantaushe pukura-aha mazle-aara geni Yaisu ndahaaka elva a shahi á makala na tá puwaná am depaiŋ; ŋane a ndaha ba elva a názu tá kwaratersa *Farisa-aha antara *Saduki-aha ge emnde. ");
INSERT INTO mfi_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Am iga á una ŋanna maa, Yaisu a zlalehe antara pukura-aha-aara á dem Kaysariya á Filip. A de ndavateru ge pukura-aha-aara áhuwa, a ba ŋane á elvan ge itare: «Iya *Ura á emnde baɗemme mu, emnde ta baa ya ware?» ");
INSERT INTO mfi_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ta ŋwanante, a ba itare: «Ta bantsa emnde umele ka Yuhanna slemaga baptisma; a baa emnde umele, ka *Ailiya; a baa emnde umele zlaɓe adaliye ka Yairaimiya, bi ka ba nabi umele.» ");
INSERT INTO mfi_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","«Ay, kure ma, kwá ba ya ware?» ");
INSERT INTO mfi_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","A ŋwanante ge Simaun Piyer: «Ba ka una ka *Almasiihu, ka *Egdza á Dadaamiya na á fa shifa am ura na.» ");
INSERT INTO mfi_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Daaci a ba Yaisu á elvan ge ŋane: «Simaun egdza á Yaunas, ekka wá, shakansha barka kwakya, aɗaba jirire na ka cenaana áza urimagwe ka, a vaktaa ba Edderwa na am samaya na an ire-aara. ");
INSERT INTO mfi_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yá ndak ba jirire Piyer: Ábi zhera á ŋa ŋanna wá, amaana palaha. Yá faná áte palaha ŋanna emnde na tá fetaare áte ya na baɗemme. Ma emtsa keni á de dateruka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yá fakem egdza a tsekweram á wera *kwara á Dadaamiya am erva ge ekka. Ma ka piyetaa uwe ge emnde am duniya na keni, am samaya keni tá á ba áte una ŋanna. Ma ka ƴateraa baráma á uwe ge emnde keni, am samaya keni tá á ba áte una ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Am iga á una ŋanna maa, a teɗaterte hyema ge pukura-aha-aara, geni a ndaranka ge ura umele ɗekiɗeki, ganakini *Almasiihu ŋanna ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Yaisu a fantau am sarte ŋanna ge ndaaterse elva á ire-aara ge pukura-aha-aara, a ba ŋane á elvan ge itare: «Sey ba yá duwa á dem Urusaliima. Tá de magiya palasa kwakya male-aha á larde, antara male-aha á *liman-aha, ira malum-aha á *tawraita. Tá de zlanaazle shifa-aaruwa baɗemme, amá am hare ge keƴire wá, watse yá sesse zlaɓe adaliye an shifa.» ");
INSERT INTO mfi_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","A naba ɗahese ge Piyer ba itare ta buwa antara Yaisu, a ba ŋane á elvan ge ŋane: «A piyetepiya Dadaamiya jeba una, a gevka ɗeme jeba una áte ka Yaakadada-aaruwa!» ");
INSERT INTO mfi_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Amá Yaisu a eptsanaa ge Piyer, a ba ŋane á elvan ge ŋane: «Giyapteka ɗekiɗeki, ekka, ka Shaitaine, ká kátá mbeɗiya á dem haypa. Aɗaba názena ká dzamaná ka na jarammeka antara náza á Dadaamiya, náza á ŋa na ba názu tá dzamaná emndimagwaha.» ");
INSERT INTO mfi_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Daaci a ba ŋane á elvan ge pukura-aha-aara baɗemme: «Máki edda-aara wayaawaya ɗaba ya wá, a dzameka shifa-aara ɗekiɗeki, a eksanteksa dzaŋgala-aara, á ɗabiɗaba an ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Aɗaba máki edda-aara á tataya lya shifa-aara wá, á de keɗanaakeɗa. Amá edda una a keɗaa shifa-aara aɗaba ya, á de shansha zlaɓe adaliye. ");
INSERT INTO mfi_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ma edda-aara a zu emtakire á duniya na baɗemme keni, máki keɗanaakeɗa shifa-aara wá, ázara nampire-aara ge ŋane? A de maganánka duksa ɗekiɗeki. Aɗaba ɓaaka duksa na urimagwe á de vara shifa-aara an ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ya *Ura á emnde baɗemme wá, watse yá sawa antara malika-aha-aaruwa, an sleksire á Edderwa. Watse yá se pelaterse ge emnde baɗemme, ma ware keni yá se pelansa á ba áte názena ndza a maganaa ŋane.» ");
INSERT INTO mfi_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","A ba ŋane zlaɓe adaliye: «Yá ndaakur ba jirire: a ba am dagave á kure na keni, tá aŋkwa emnde na ni tá de emtseka ba estuwa, sey má naranna sawa-aaruwa ya *Ura á emnde baɗemme, má watse yá sawa am sleksire ƴaikke.» ");
INSERT INTO mfi_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","A magaa hare uŋkwahe am iga á una ŋanna maa, Yaisu a ɗetaa tara Piyer, antara Yakuba, ira Yuhanna egdza emmeŋara ge Yakuba ŋanna, a dateraa áte ire á wa umele slaɗɗe ba itare-itare áhuwa. ");
INSERT INTO mfi_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Daraada ahuwa maa, a naba eptsavte ge Yaisu am ice-aatare wá, gevge umele ba seke ŋane ka mazle-aara. Feke-aara aŋkwa á mba wulwulire ba seke vaciya, naŋgyuwe-aara gevge dzayye ba telle, aŋkwa mbe ba seke parakkire. ");
INSERT INTO mfi_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Daaci pukura-aha na tá zhára ba emndu werre, tara Muusa antara *Ailiya, tá aŋkwa ndaha elva antara Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","A ba Piyer á elvan ge Yaisu: «Yaakadada-aaruwa, una shagera jipu ŋere keni ŋá aŋkwa áhuna na. Má wayak-waya wá, yá maganaamaga dzadzawe-aha keƴe, palle náza á ŋa, palle náza á Muusa, palle keni náza á Ailiya.» ");
INSERT INTO mfi_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Zlaɓe ba elva ŋanna keni ndaaseka Piyer wá, a naba tsekwaterarhe ge kumba. Aŋkwa kwara á ndaha elva am kumba ŋanna. A ba edda-aara: «Una na wa, Egdza-aaruwa! Baɗemme á higa-aaruwa á ba áte ŋane. Cenaucena názena á bakurná ŋane.» ");
INSERT INTO mfi_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Cenarancena pukura-aha na kwara ŋanna maa, jaterja lyawa baɗemme, reppe ta kazlaa ugje am haha baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","A gapte ge Yaisu á dezetare, a de gejatertehe: «Naba tsawetse. A wakurka lyawa,» a ba ŋane á elvan ge itare. ");
INSERT INTO mfi_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ta kante ire wá, ta naa ba Yaisu palle ɓaaka ura umele ázeŋara. ");
INSERT INTO mfi_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Am sarte na tá átira tsekwa á sa áte ire á wa ŋanna maa, a ba Yaisu á elvan ge itare: «Ma ge ware keni ndaawanka názena kwa nanaa kure na ɗekiɗeki, dem sarte na má tsanetsa ya, ya *Ura á emnde baɗemme am faya.» ");
INSERT INTO mfi_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Zlauzle elva-aara, ta naba ndavanuhe ge pukura-aha na, a ba itare tá elvan ge ŋane: «Máki estuwa, labara tá bantsa malum-aha á *tawraita geni watse á semse emtsaaɗe Ailiya ádaliye na?» ");
INSERT INTO mfi_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","A ŋwaterante ge Yaisu: «Una ba jire-aatare, ba seke una ta ndahanaa itare ŋanna, á eptsa Ailiya emtsaaɗe, á se tsatsanaatsatsa ŋane duksa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Amá wá, yá ndaakur ba jirire: Ailiya wá, ndza eptsaptsa á sawa, diyarseka ba emnde, ta naba maga hakuma-aatare áte ŋane. Ya *Ura á emnde baɗemme keni tá de magiyán ba estuwa.» ");
INSERT INTO mfi_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Daaci diyareddiye pukura-aha mazle-aara ganakini á ndaater elva a Yuhanna slemaga baptisma. ");
INSERT INTO mfi_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tsekwaretsekwa á sa áte ire á wá, ta se bera jahava á emnde. A duhe ge zhele umele, a de kezla ugje am sera á Yaisu, ");
INSERT INTO mfi_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","a ba ŋane á elvan ge ŋane: «Yaakadada-aaruwa, tasle á ŋa zanvareze seke ge egdza-aaruwa, aŋkwa á maganá palasa tauraurau, ser kwakya á valyaná á dem kárá, antara á dem yawe. ");
INSERT INTO mfi_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ya saterán ge pukura-aha á ŋa, amá dzegwaránka mbanaamba.» ");
INSERT INTO mfi_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ba wera we-aara ge Yaisu, a ba ŋane á elvan ge itare: «Amá kure emnde a zamane na wá, ɓaaka fetarfire á kure ɗekiɗeki, kwa mandzawe-aha jipu! Watse yá njá antara kure dem laukte-ara? Yá fakurá ervauŋɗe dem sarte-ara estuwa? Sawiyansa kwa kure egdze ŋanna ge iya!» ");
INSERT INTO mfi_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Daaci Yaisu a valaarhe á ba an ndzeɗa ge jini na am vuwa á egdze ŋanna, a ŋgyansehe, kerteŋ a naba mbehe ge egdzere á ba am sarte ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Am iga á una ŋanna maa, ta duhe ge pukura-aha-aara á ba an niya ge ndavanu una ŋanna, a ba itare tá elvan ge ŋane: «Labara dzegwaŋeranka ŋere ŋgyesaa jini ŋanna?» ");
INSERT INTO mfi_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","A ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «A maganaa cekwire á fetarfire á kure. Yá ndaakur ba jirire: Máki aŋkwa fetarfire á kure cekwaaŋguɗi, ma ba seke wulfe á pilli keni, kwá bananba ge wa na: Tsetse áhuna, ezzlala ádehuwa, ba jirire á tsettse, á zlala, ɓaaka názu á jakurviyaaje ɗekiɗeki. (( ");
INSERT INTO mfi_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Amá keni, jeba á jini na, sey tá ŋgyanse an maduwa, antara tsufa ndera.»)) ");
INSERT INTO mfi_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Vacite umele jaremmeje pukura-aha am Galili, a ba Yaisu á elvan ge itare: «Iya *Ura á emnde baɗemme wá, watse ta fime am erva ge emnde. ");
INSERT INTO mfi_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Emnde ŋanna tá de jija. Amá am hare ge keƴire wá, watse yá tsetse am faya.» Ba cenarancena una ŋanna pukura-aha maa, daremda am dzama ire ƴaikke. ");
INSERT INTO mfi_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Am sarte na daremda tara Yaisu antara pukura-aha-aara á dem Kafarnahum, ta duhe ge emnde a jaha hadama á mashidi á deza Piyer, ta de ndavanuhe, a ba itare: «Malum á kure na ŋane á puweka hadama á mashidi emtu?» ");
INSERT INTO mfi_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","A ŋwaterante ge Piyer: «Á eppuwa», a ba ŋane á elvan ge itare. Daaci am sarte na Piyer aŋkwa á dem bere, Yaisu a ndavanu elva, a ba ŋane á elvan ge ŋane: «Ndindaha mu, emnde-ara una tá puwaná hadama antara náza ŋezla ge slekse á larde? Egdzara á larde emtu, wayve-aha he?» ");
INSERT INTO mfi_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","A ŋutehe ge Piyer: «Tá puwaná ba wayve-aha», a ba ŋane. A ba Yaisu: «Daaci estuwa tá puweka egdzara á larde. ");
INSERT INTO mfi_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Aley keni wá, mi zlaɗaterveka ervauŋɗe ge emnde ŋanna. Daaci edduwa áte we á haye, de puwumpuwa narre á ŋa á dem haye, kelfe na ká de eksaná ka zuŋŋwe na wá, naba werura we-aara, watse ká shansha shuŋgu am mbuwe á kelfe ŋanna, á hyephye ge puwa hadama á miya antara ka, naba vaterteva.» ");
INSERT INTO mfi_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","A ba am sarte ŋanna, ta duhe ge pukura-aha á deza Yaisu, ta de ndavanuhe, a ba itare: «Am *kwara á Dadaamiya mu, ware una male arge emnde umele?» ");
INSERT INTO mfi_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ge vaterte jawapa, Yaisu a ɗante egdzere, a tsanaahe á katafke-aatare, ");
INSERT INTO mfi_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","daaci a ba ŋane á elvan ge itare: «Yá ndaakur ba jirire: Máki eptsakurapteka, gakurevka ba seke egdzara mesheshe, kwá demka am kwara á Dadaamiya ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ura male am kwara á Dadaamiya wá, ba edda una má ganaaga ire-aara, a ganve ire-aara ba seke egdze na náwa ŋane na. ");
INSERT INTO mfi_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ma ware una a lyevaa egdzere seke una aɗaba elva-aaruwa, edda-aara a lyevaa ba iya an ire-aaruwa.» ");
INSERT INTO mfi_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Am iga á una ŋanna maa, a ba ŋane: «Má edda-aara mbeɗanaambeɗa palle á egdzara ŋanna ta fetaare áte iya na á dem haypa, ámbane tá ŋguɗanemŋguɗa nákwá á ha hiya am mbiye, tá eblyanma am haye á emtsa, ŋgulme ba una ŋanna ge edda-aara. ");
INSERT INTO mfi_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kay! Palase á duniya na, aɗaba kwakya názena á puwa emnde á dem haypa, ɓaaka janaaje-aara ɗekiɗeki. Amá laruwa ge edda una emnde tá puwa á dem haypa aɗaba ŋane na. ");
INSERT INTO mfi_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«Máki erva á ŋa, bi sera á ŋa áŋkwa á dáká á dem haypa wá, naba icica áte ka, eblyanveblye ƴiƴiye an ka. Ámbane ká dem tate á shifa na á zleka na an erva palle bi an sera palle, arge una ká njá an uɓiya-aha á ŋa baɗemme, amá ká dem kárá náza ba ge ɗekiɗeki na. ");
INSERT INTO mfi_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Máki ice á ŋa á dáká á dem haypa wá, sansese ice ŋanna, eblyanveblye ƴiƴiye an ka. Ámbane ká dem tate á shifa na á zleka ɗekiɗeki na an feke palle, arge una ká njá an ice-aha á ŋa bukerɗe, amá ká dem kárá na ɓaaka emtsa-aara dem ba ge ɗekiɗeki na.» ");
INSERT INTO mfi_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Tsufautsufa ire á kure ba shagera, epsawanaaka ba ura palle keni am egdzara ŋanna. Yá ndaakur ba jirire: Malika-aha-aatare tá ba tsatse á katafke á Edderwa am samaya. (( ");
INSERT INTO mfi_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Aɗaba iya *Ura á emnde baɗemme wá, ya se ŋezla una keɗaakeɗa na.)) ");
INSERT INTO mfi_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Máki ura an kyawe-aha-aara deremke, amá keɗaakeɗa kyawe palle am kaamba, á ƴanka kyawe-aha kul maselmane ju maselmane na áte wa, ŋane á tsekwa á de tataya una keɗaakeɗa na emtu? Emtu ázara a ba kure? ");
INSERT INTO mfi_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yá ndaakur ba jirire, má de shánsha wá, á higetehiga ervauŋɗe-aara jipu á ba arge kyawe-aha kul maselmane ju maselmane na tá aŋkwa na keni. ");
INSERT INTO mfi_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Eddekure na am samaya na keni ba estuwa. Ŋane wayaaka ɗekiɗeki ganakini á keɗa ba palle-aatare keni am egdzara-aara ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Máki egdza emmeŋa gawge haypa an ka wá, de ndandaha ba kure kwa buwa antara ŋane. Má cenakvaarcene, tsakanmartse ge egdza emmeŋa. ");
INSERT INTO mfi_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Amá máki ƴanaaƴa elva á ŋa wá, ká se tatayevá ura palle, bi emnde buwa, lauktu kwá duwa zlaɓe ádaliye antara itare, geni a gevge á ba áte una a ndahanaa wakita á Dadaamiya, a ba ŋane: Ma ugje-ara keni a tsaatse á ba áte seyde á emnde buwa bi keƴe na. ");
INSERT INTO mfi_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Amá máki cenaaka náza-aatare zlaɓe ádaliye wá, naba bateranba ge emnde a fetarfe am jahava. Má cenaaka náza á aiklaisiya wá, a gevge ba seke ura á jeba umele, ba seke edda ŋezla mazle-aara á katafke á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Am iga á una ŋanna maa, a ba ŋane: «Yá bakurá ba jirire: Ma kwa piyetaa uwe am duniya na keni, am samaya keni tá á ba áte una ŋanna. Ma kwa ƴateraa baráma á uwe keni, am samaya keni tá á ba áte una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Yá ndaakurndaha zlaɓe ádaliye: Má emnde buwa am dagave á kure ta ŋguɗaa ye-aatare palle ge ndava duksa am maduwa, á vaterteva Edderwa na am samaya na duksa ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Aɗaba am tatu ta jamme emnde buwa bi keƴe am zhera-aaruwa, iya yá aŋkwa am dagave-aatare.» ");
INSERT INTO mfi_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Daaci a tsetehe ge Piyer damme á deza Yaisu ge ndavanundave, a ba ŋane á elvan ge ŋane: «Yaakadada, yá ƴanaare haypa ser wanyara ge egdza emmerwa, máki ŋane á far ba mága haypa an ya? Dem ser vuye emtu?» ");
INSERT INTO mfi_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","«Aꞌaa ser vuyeka, ser kul vuye kul vuye ser vuye», a ba Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Am iga á una ŋanna a ba ŋane: «Náwa gáráva á názu á magavá am *kwara á Dadaamiya: Aŋkwa slekse umele, a ɗetaa emnde a slera-aara geni tá vante lisaafi á nalmane-aara baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Demde am lisaafi wá, jesarje edda á gema-aara á ɗaban ge nalmane kwakya jipu, ta eksanvaahe. ");
INSERT INTO mfi_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Edda-aara ŋanna ba názara-aara keni ɓaaka ge pelese gema na. Daaci a ba zanwe-aara: Eksauvaksa irice-aara velawuvele. Velawuvele mukse-aara, antara egdzara-aara, ira názu am huɗe á há-aara baɗemme, ge pela gema-aaruwa an ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Daaci a duhe ge zhel ŋanna á deza edda á gema, a de kezlaa ugje á katafke-aara, a ba ŋane: Tasle á ŋa fifa ervauŋɗe ambarka á ŋa, yá eppela baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ura male na a naba zanvaarehe, a ƴanaa gema ŋanna baɗemme, a belanaahe. ");
INSERT INTO mfi_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Amá ŋane ba segashe-aara, a se ja ba ire antara ukfeŋara, ndza tá am slera palle, ŋane keni a ɗaban ge egdza gema wá, a naba ŋanaahe am kwara: Sey ká pelisepele duksa-aaruwa, a ba ŋane á elvan ge ukfeŋara na. ");
INSERT INTO mfi_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ukfeŋara a kezlanaa ugje, a ba ŋane: Tasle á ŋa fifa ervauŋɗe yá pelaksepele baɗemme! ");
INSERT INTO mfi_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Amá faaka ervauŋɗe ɗekiɗeki, a de ŋguɗehe am daŋgay, sey máki pelesepele duksa-aara baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","«Ba ta naa una ŋanna emnde umele na ndza tá am slera kerɗe na wá, tá geja ba ire. Tá de balanse labara ŋanna baɗemme ge zanwe-aatare. ");
INSERT INTO mfi_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Daaci zanwe a naba ɓelaa emnde-aara, ta de ɗanante, a ba ŋane á elvan ge ŋane: Ekka wá, ka slemándzawe ba jire. Ekka ni ya naba ƴakaare gema-aaruwa baɗemme aɗaba slapala á ŋa; ");
INSERT INTO mfi_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Abi zlaya ka keni ma ká zanvaareze estuwa ge ukfeŋa? ");
INSERT INTO mfi_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jaaja ervauŋɗe zanwe-aara. A ba ŋane: A daránda á dem daŋgay, ŋane keni sey má pelesepele gema-aaruwa baɗemme.» ");
INSERT INTO mfi_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Am iga á una ŋanna maa, a far una Yaisu: «Edderwa na am samaya na keni, á de magakurán ba estuwa ge kure keni, má kwá ƴateraareka an ervauŋɗe á kure palle ge emnde a magakuraa haypa.» ");
INSERT INTO mfi_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yaisu zlanaazle elva-aara, a naba tsetehe am Galili, a zlala á dem haha á Yahudiya áte iga a guwa á Urdun. ");
INSERT INTO mfi_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Emnde kwakya ta ɗabemhe áduwa, emnde umele tá an emnde-aha-aatare ta lapika-aha. Yaisu a de mbateraahe. ");
INSERT INTO mfi_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Daaci ta duhe ge *Farisa-aha umele ádeza Yaisu, ta de tsagwaɗanaa áte elva. Ta de ndavanuhe, a ba itare tá elvan ge ŋane: «Vantevahe *tawraita baráma ge zhele geni á ɓelánaaɓelá mukse-aara aɗaba dalila á ma uwe keni?» ");
INSERT INTO mfi_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A ŋwaterantehe, a ba ŋane: «Ndaakurseka názu am wakita á Dadaamiya emtu? Am fakta wá, Dadaamiya a nderaterhe tara zhele an mukse.» ");
INSERT INTO mfi_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Daaci a ba ŋane: «Aɗaba una ŋanna, zhele á ƴá tara eddeŋara antara emmeŋara, tá mázláva an mukse-aara; itare ta buwa ŋanna, tá gevge ba vuwa palle. ");
INSERT INTO mfi_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Estuwa, ta buweka mázle-aara, tá geva ba vuwa palle. Daaci názena ni a janmaa Dadaamiya wá, a icanveka urimagwe.» ");
INSERT INTO mfi_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","*Farisa-aha ŋara ta ndavanuhe: «Labara a bantsa Muusa zhele á vante nalmesheri á ica nika ge mukse, máki ba estuwa?» ");
INSERT INTO mfi_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","A ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Muusa a vakurte baráma a pakyava antara ŋwasha-aha á kure na wá, aɗaba degdegire á ire á kure. Am fakta wá, ndza estuweka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yá ndaakur ba jirire: Ma ware una a ɓelaa mukse-aara, wallá a ekseva am gwardzire, a de gaa umele, a magaa ba gwardzire.» ");
INSERT INTO mfi_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","A ba pukura-aha-aara tá elvan ge ŋane: «Máki elva á tara zhele an mukse gevge estuwa wá, ambane emnde tá ƴanƴa elva á nika ba ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","A ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Emnde baɗemme ka una tá dzegwándzegwa eksar elva ŋanna, sey ba emnde na Dadaamiya a vaterte hákuma á nja estuwa. ");
INSERT INTO mfi_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Aŋkwa dalila-aha gergere na ni á piyante gá mukse bi de gá zhele ge ura: Ura umele wá, ta yanaa á ba an ŋane, vuwa-aara ba estuwa, elva á nika á taa gevka ge ŋane. Náza á emnde umele, ta halatertaave ba emndimagwaha. Emnde umele zlaɓe ádaliye, ta ƴaa nika aɗaba *kwara á Dadaamiya. Kwaye ŋane tsáha ŋanna, edda una á dzegwándzegwa na, a eksanteksa.» ");
INSERT INTO mfi_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Emnde kwakya ta sanaa egdzara ge Yaisu, ganakini á puwaterar erva a barka-aara, antara á magaterar maduwa, amá pukura-aha ta naba valateraarhe ge emnde a saa egdzara ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Daaci, a ba Yaisu á elvan ge itare: «Piyawaterteka, ƴawaterƴa a sarsawa egdzara ásezerwa, aɗaba *kwara á Dadaamiya náza á emnde na má garevge ba seke itare.» ");
INSERT INTO mfi_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Daaci a puwateraarhe erva a barka-aara áte ire-aha-aatare, a tsetehe am tate ŋanna, a zlalehe. ");
INSERT INTO mfi_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","A sawhe ge dawale umele áseza Yaisu, a ba ŋane: «Malum, shagera slera-ara yá maganaamaga, lauktu yá sha shifa na á zleka na?» ");
INSERT INTO mfi_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","A ba Yaisu, á elvan ge ŋane: «Labara ka ndaviyu elva áte duksa na shagera? Ɓaaka ura shagera ɗekiɗeki sey ba ura palle. Máki wayak-wáyá ká daada á dem tate á shifa na á zleka na wá, ŋanaaŋa shairiya-aha á Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","A ba ŋane á elvan ge Yaisu: «Ura-ara-aha-aara ge shairiya-aha?» A ba Yaisu á elvan ge ŋane: «Una a ba: Jeka shifa, maŋka gwardzire, ileka, maŋka seydire á fida áte ura, ");
INSERT INTO mfi_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ɗematerveɗeme tara eddeŋa an emmeŋa, ira ewwáyá sleriya á ŋa ba seke ire á ŋa. Kwaye ŋane shairiya-aha ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","A ba dawale ŋanna á elvan ge Yaisu: «Una ŋannaaŋa baɗemme. A juwa uwe umele?» ");
INSERT INTO mfi_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","A ba Yaisu á elvan ge ŋane: «Máki ká kátá gev edda una hyephye am duksa baɗemme wá, de valuvále názu am rezege á ŋa baɗemme, tegatertega shuŋgu-aara ge taláge-aha. Ekka watse ká shánsha láɗá-aara am samaya, daaci sawa ɗabiɗába.» ");
INSERT INTO mfi_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ba a cenaa una ŋanna dawale ŋanna maa, a da á ba an dzámá ire, aɗaba nalmane-aara kwakya jipu. ");
INSERT INTO mfi_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Daaci a ba Yaisu á elvan ge pukura-aha-aara: «Yá bakurá ba jirire: Zlazlaɗa jipu ganakini ura berba á demda á dem *kwara á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yá ndaakurndáhá zlaɓe ádaliye: Náwa zlazlaɗa ganakini á dedde nazlegwame am ɓiye á lipere, amá zlazlaɗa ba náza á sleberba zlaɓe adaliye ge dem kwara á Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ba ta cenaa una ŋanna pukura-aha wá, tá geja ba ire. A ba itare: «Máki ba estuwa wá, ɓaaka ura á ŋezleseŋzle ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","A zharateraahe ge Yaisu, a ba ŋane á elvan ge itare. « Áza emnde wá, una á taa gevka, amá Dadaamiya wá, ɓaaka názu á janviya ge ŋane.» ");
INSERT INTO mfi_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Piyer a eksetaa elva, a ba ŋane á elvan ge ŋane: «Kwaye ŋere, ƴaŋeránƴa duksa baɗemme, náwa ŋá ɗaba ba ka na mu, watse á geva estara náza á ŋere?» ");
INSERT INTO mfi_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","A ba Yaisu á elvan ge itare: «Yá ndaakur ba jirire: Am sarte na má watse se njaniinja ya, iya *Ura á emnde baɗemme am kurshi á sleksire-aaruwa am duniya na watse á de sawa áŋwaslire na, am sarte ŋanna wá, kure emnde kelaawa ju buwa na kwá aŋkwa ɗabiɗába na keni, watse kwá sha kurshi á ƴaikkire kelaawa ju buwa áte kure, kwá de njá am kurshi-aha ŋanna ge kya shairiya á Iserayiila-aha jeba kelaawa ju buwa. ");
INSERT INTO mfi_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ma ware una a ƴaa eddeŋara, bi emmeŋara, bi egdzar mama-aha-ŋara zála an ŋwásha, bi egdzara-aara, bi fe-aara, bi a ƴaa huɗe á há-aatare baɗemme aɗaba iya, á de shánsha una-aha ŋanna huɗe deremke ira shifa na á zleka na. ");
INSERT INTO mfi_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Amá emnde kwakya ta emnde a zuŋŋwa ba itare kina, tá de gev emnde a kataliya. Emnde kwakya tá am kataliya kina, watse tá gev emnde a katafka ba itare.» ");
INSERT INTO mfi_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Am *kwara á Dadaamiya wá, náwa tá gáráva an labáre na náwa ŋane na: Aŋkwa edda á há a degashe an eŋlya werre ge de hálá emnde bariyama á dem fe á náfá-aara. ");
INSERT INTO mfi_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Daaci mbera-aatare maa, ta zluwa á ba áte gane na ndza tá vaterteva ba kelaazare na; gane ŋanna suley suley áte váha. Daaci a naba daterhe á dem fe-aara. ");
INSERT INTO mfi_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","A sesehe zlaɓe ádaliye am saa maselmane maa, á zhárá ba emnde umele áte we á kwaskwe, ɓaaka slera-aatare. ");
INSERT INTO mfi_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","A ba ŋane á elvan ge itare: “Kure keni daumbare á dem fe-aaruwa, watse yá vakurta názena deydey á slera á kure.” ");
INSERT INTO mfi_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tá naba duhe. Edda á fe ŋanna a sesehe zlaɓe ádaliye an vacitire keni, a magán ba estuwa. An lásar keni a magán ba seke una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Herzhe watse emnde tá maga niya sá am fe maa, a sesehe ge edda á fe ŋanna, á zhárá ba emnde umele zlaɓe ádaliye tá áte we á kwaskwe, a ba ŋane á elvan ge itare: “Labára kwa váha á njá áhuna, ɓaaka názena kwa maganaa kure?” ");
INSERT INTO mfi_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tá ŋwanante, a ba itare: “Aɗaba ɓaaka ura a ndavaŋerndáva.” A ba ŋane á elvan ge itare: “Kure keni naba saumbare á sem fe-aaruwa, magaumaga slera.” ");
INSERT INTO mfi_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Eblyablya vaciya maa, a ba edda á fe á elvan ge male á emnde a slera-aara: “Ɗaterɗáhá, tegatertega mbera-aha-aatare, ká fantau áte emnde na ta duwa á kataliya, ká zláná áte emnde na ta duwa itare zuŋŋwe á dem slera.” ");
INSERT INTO mfi_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ta duhe ge emnde na ta de fantau ge slera herzhe á eblya vaciya na, baɗemme-aatare ta sha suley palpale. ");
INSERT INTO mfi_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Am iga-aatare, ta duhe ge emnde na ta fantuwa itare zuŋŋwe ge slera na. Itare ta kurken watse an saga náza-aatare, amá itare keni ta vaterte ba suley palpale ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ta lyevaahe, amá jaterja ervauŋɗe áte edda á fe ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","A ba itare tá elvan ge edda á fe: “Náwa emnde na ta se gejante slera ba cekwaaŋguɗi ni, ka biyateraa shuŋgu kalkale antara náza á ŋere na ŋa váha deppe á maga slera áte zlaɗa á vaciya na!” ");
INSERT INTO mfi_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Amá edda á fe a ŋwanante ge palle-aatare, a ba ŋane á elvan ge ŋane: “Ba palle a zlerma na ya magakanaa ya ɓaaka ura-aaruwa. Ha! Ndza zlamiyuka am gane geni suley palle áte váha emtu? ");
INSERT INTO mfi_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Lyevaalya suley á ŋa, jinaaja. Iyá yá kátá vanteva ge edda una a fantau á kataliya na keni ba seke názá á ŋa. ");
INSERT INTO mfi_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Emtu aŋkwa slepiyite mága slera an shuŋgu-aaruwa áte una yá kataná iya emtu? Emtu ká shelha aɗaba ya maganaa shagerire ge ura emtu?” » ");
INSERT INTO mfi_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yaisu zlauzle am tsáká elva-aara, a farhe zlaɓe ádaliye, a ba ŋane: «Emnde na tá am kataliya kina, tá de gev emnde a katafke. Emnde na tá á katafke kina, tá de gev emnde a kataliya.» ");
INSERT INTO mfi_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Aŋkwa á dem Urusaliima Yaisu wá, a ɗetaa pukura-aha-aara kelaawa ju buwa. Tá átira a zlálá, a ba ŋane á elvan ge itare: ");
INSERT INTO mfi_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Duwa á miya á dem Urusaliima kina na wá, iya *Ura á emnde baɗemme tá de eksivaksa, tá de vite ge male-aha á *liman-aha, antara malum-aha á *tawraita. Tá de ndahaná itare geni a jareja shifa-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Daaci tá de fime am erva ge emnde na ɓaaka nadina-aatare, tá de zlazlisá itare, tá de jiya itare, tá de zleŋeliya itare áte dzaŋgala. Amá am hare ge keƴire wá, watse yá tsetse am fáyá.» ");
INSERT INTO mfi_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Duwa á emmarge egdzara á Jaibaidaiyus, ta duwa antara ba egdzara-aara ŋanna á de katafke á Yaisu, a kezlaa ugje á katafke-aara, a ndavanuhe máki á shansha ŋálá ázeŋara. ");
INSERT INTO mfi_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","«Ká kátá uwe ka emmaaye,» a ba Yaisu á elvan ge ŋane. A ŋwanante, a ba ŋane á elvan ge Yaisu: «Máki dakemda am sleksire á ŋa wá, yá kátá palle á egdzara-aaruwa na á de shá njá am naɗafa á ŋa, palle keni á de shá njá am názlaɓa á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","A ŋwanante ge Yaisu, a ba ŋane á elvan ge itare: «Ábi diyakurka wedere á kure na ma andze kwá ndava ŋane na. Kina wá, watse kwá dzegwándzegwa emtu sha zlaɗa áte náza-aaruwa na watse yá essha na?» Tá ŋwanante: «Ŋá dzegwándzegwa,» a ba itare. ");
INSERT INTO mfi_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","«Zlaɗa-aaruwa wá, ba jire watse kwá de essha, amá elva a de njá am naɗafa-aaruwa antara am názlaɓa-aaruwa wá, am erva-aaruweka una ŋanna. Tá aŋkwa emnde na a dzeratersaa Edderwa ge de njá am sleɗe-aha ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","De cenaráncena pukura-aha umele na jaruje kelaawa na labáre ŋanna, a naba jaterhe ge ervauŋɗe áte egdzar mama-aha buwa ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","A ɗatertehe ge Yaisu, a ba ŋane á elvan ge itare: «Náwa diyakurdiya ganakini slekse-aha á larde wá, itare tá aŋkwa á kwárá larde-aha-aatare an márá hákuma áte emnde. Male-aha á ekse keni tá aŋkwa á márá hákuma-aatare am ekse. ");
INSERT INTO mfi_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Amá jeba á una ŋanna wá, a gevka am dagave á kure. Ma ware una á kátá gev male keni, arge una ŋanna wá, a gevge ba seke walaaɗi á kure. ");
INSERT INTO mfi_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma ware una á kátá gev slekatafke á kure keni, a gevge ba seke náve á kure. Malire wá, ba una ŋanna am ice á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ba iya *Ura á emnde baɗemme keni, sanka geni tá se magiya emnde slera, amá iya una ya se magateraa slera ge emnde, ya se ƴá shifa-aaruwa geni yá lyelye emnde ba kwakya.» ");
INSERT INTO mfi_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Segashe-aatare am ekse á Yairikau maa, emnde kwakya ta daa ɗaba Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tá aŋkwa wulfe-aha buwa tá á njanja áte we á uŋŋule, cenaráncena aŋkwa á degashe Yaisu, ta naba kante kwárá: «Yaakadada, *Egdza á Dawuda, tasle á ŋa zaŋervareze,» a ba itare. ");
INSERT INTO mfi_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ta valateraarehe ge emnde, ta bateraa a ɗaruɗe, amá itare ta farhe zlaɓe adaliye á ba an hula, a ba itare: «Yaakadada, Egdza á Dawuda, zaŋervareze.» ");
INSERT INTO mfi_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","A tsaahe ge Yaisu, a ɗaterte á dezeŋara, a ba ŋane á elvan ge itare: «Kwá kátá yá magakurá estara kina?» ");
INSERT INTO mfi_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ta ŋwanante, a ba itare: «Ŋá kátá ba ŋá nanna ice á ŋere Yaakadada». ");
INSERT INTO mfi_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yaisu a zatervaarehe, a semtateraa ice-aha-aatare. Ba seke ndaha á miya na emnde buwa na sharansha ice-aha-aatare, ta ɗabete Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Daraada am ekse á Baytifaji áte vuwa á Wa Anyaranyara, zlauzle herzharanteherzhe Urusaliima maa, Yaisu a ɓelaa pukura-aha-aara buwa á de katafke. ");
INSERT INTO mfi_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","A ba ŋane á elvan ge itare: «Dawmbare á dem ekse na kwaye á katafke á miya na wá, ba kerteŋ kwá de bera úmá á ezzeŋwa an ŋguɗa, tá antara egdza-aara wá, pelawaapele, sawiyansa. ");
INSERT INTO mfi_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Máki a ndaakur elva ura umele wá, bawanánba ge edda-aara geni a ndavanaa Yaakadada, á de ƴakuránƴa, kwá sánsa.» ");
INSERT INTO mfi_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Á magava una ŋanna, geni a gevge elva na aŋkwa a ndahesaa nabi na, a ba ŋane: ");
INSERT INTO mfi_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Bawateránba ge emnde a berni á *Siyauna wá: Kwáye aŋkwa á sawa slekse á kure á sem ekse á kure an kemaarire, aŋkwa á sawa áte úmá á ezzeŋwa ira egdza-aara.» ");
INSERT INTO mfi_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Daaci ta naba zlala pukura-aha na, ta de magán ba seke una a baternaa Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ta sanmehe úmá á ezzeŋwa na antara egdza-aara áseza Yaisu, ta ndakaa zane-aha-aatare áte ezzeŋwa-aha ŋanna lauktu a njetaa Yaisu átekwa. ");
INSERT INTO mfi_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kwakya nálga, emnde umele ta pelanse zane-aha-aatare áte baráma, emnde umele ta ɗatsaa hyema á debina, ta pelanse áte baráma ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Daaci ma emnde na tá á zlala á katafke á Yaisu, ma emnde na tá am iga-aara keni baɗemme-aatare tá leva ba hula, a ba itare: «A vanteva Dadaamiya ɗemɗemire ge *Egdza á Dawuda, a ganga barka ge edda una á sawa am zhera á Yaakadada na, Slekse ba Dadaamiya palle am samaya.» ");
INSERT INTO mfi_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Am sarte na Yaisu aŋkwa á dem huɗe á Urusaliima maa, emnde baɗemme am huɗe á berni ŋanna, tá aŋkwa á ndava geni ware ŋane zhele ŋanna. Baɗemme á huɗe á ekse ba hayakhayake. ");
INSERT INTO mfi_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ta ŋwaterante ge dikele á emnde na tá dá ɗaba Yaisu na, geni una nabi Yaisu ura Nasarátu am haha á Galili. ");
INSERT INTO mfi_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Duwa á Yaisu á dem *mashidi ƴaikke, a de beraa emnde a válá kazlaŋa, antara emnde a shákwá kazlaŋa am mashidi, a naba ŋgyaterse. A zaɗanve tabel-aha á emnde a peteke, antara kurshi-aha á emnde a válá takala masar baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Am iga á una ŋanna maa, a ba ŋane á elvan ge itare: «Aŋkwa an puwa am wakita á Dadaamiya, a ba Dadaamiya: Bere-aaruwa wá, tá ɗaháná an bere á maduwa. Amá kure kwa ganve hwalakwa á nabera-aha.» ");
INSERT INTO mfi_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tá aŋkwa wulfe-aha antara emnde a dere, ta semhe áseza Yaisu á ba am mashidi ŋanna, a naba mbateraahe. ");
INSERT INTO mfi_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ba ta naa slera á najipu na a maganaa Yaisu na male-aha á *liman-aha antara malum-aha á *tawraita wá, a naba jaterhe ge ervauŋɗe. Aɗaba antara ba egdzara keni tá aŋkwa á hula á ba dem zhegela, a ba itare: «A vanteva Dadaamiya ɗemɗemire ge *Egdza á Dawuda.» ");
INSERT INTO mfi_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","A ba male-aha ŋanna, tá elvan ge Yaisu: «Ka cenáncena názena tá ndahaná itare ka?» «Ane, ya cenáncena», a ba Yaisu. «Kure ndaakurseka-he názena am wakita á Dadaamiya, a ba ŋane: Shakánsha gálá am mbuwe á egdzara saɗaɗɗe, antara egdzara na tá áte erva na emtu?» ");
INSERT INTO mfi_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mázla-aara, ba zlala-aara ázetare, a desehe am huɗe á berni baɗemme. Kwaye a zlálá á dem Baytaniya, a de háre áhuwa. ");
INSERT INTO mfi_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mákuralla-aara aŋkwa á sá Yaisu á sem huɗe á berni maa, ŋanaaŋa waya. ");
INSERT INTO mfi_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Daaci a naa mama á nabugda áte we á uŋŋule, a duhe á dem ekte á nabugda ŋanna, shánka egdzere átekwa, jauwa ba hyema. A ndahese elva-aara áte nabugda ŋanna, a ba ŋane: «Egdzere áte ka wá, gaɗɗiru tá nánka.» Kerteŋ welasewele nabugda na baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tá maga ba najipu pukura-aha am ta naa una ŋanna. Ta ndavanu ge Yaisu geni a sawa estara welasewele nabugda na shekwaaka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","A ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Yá ndaakur ba jirire: Máki fakurtaarefe á ba an jirire, magakurka shaige, anƴƴa una náwa ya maganta iya ge nabugda na ka, ma kwa banán ba ge wa na: Tsetse áhuna de mbeɗanaambeɗá ire á ŋa á dem háye keni, sey á magaavemage. ");
INSERT INTO mfi_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Máki aŋkwa fetarfire á kure wá, ma kwa ŋála uwe keni kwá shánshá.» ");
INSERT INTO mfi_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yaisu a duhe á dem mashidi, a de fantau ge kwaraterse duksa ge emnde. Ta duhe ge male-aha á *liman-aha, antara male-aha á Yahudiya-aha á dezeŋara, a ba itare tá elvan ge ŋane: «Ka shanaa áme hákuma á mága duksa-aha na? Emtu a vaktaa ware baráma-aara?» ");
INSERT INTO mfi_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","A ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Iya keni yá ndavakurundave, máki vakuriteva jawápa wá, yá ndaakurse tate na ni ya shaa hákuma átekwa.» ");
INSERT INTO mfi_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Daaci a ba ŋane á elvan ge itare: «A ɓelanaa ware Yuhanna ge se magaterá baptisma ge emnde? Dadaamiya emtu, emndimagwaha he?» Ta fantau ge ndahanaa am dágave-aatare emtsaaɗe: «Má mi banaa a ɓelanaa Dadaamiya, watse á bamiya: labára fakurtaareka an ŋane? ");
INSERT INTO mfi_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Má mi baa, ta ɓelanaa ba emndimagwaha, sey mí kuva emnde keni, aɗaba emnde baɗemme fartarfe ganakini Yuhanna nabi á Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Aɗaba una ŋanna, «Diyaŋerka», a ba itare tá elvan ge Yaisu. A ba Yaisu: «Iya keni yá ndaakurka náza-aaruwa ma ya shaa hákuma á mága duksa-aaruwa áza ware keni.» ");
INSERT INTO mfi_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yaisu a fateraarehe zlaɓe ádaliye ge elva an naraje na. A ba ŋane á elvan ge itare: «Aŋkwa ura an egdzara buwa. A de banaa ge una male na: Vatena ká de maga slera am fe. ");
INSERT INTO mfi_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","A ŋwanante ge egdzere: Yá duka, á bina. A dzamanaahe wá, am iga-aara a naba duhe. ");
INSERT INTO mfi_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Daaci duwa á dada á deza palle na keni, a de banaa ba elva ŋanna. Ŋane wa: Ane, yá duwa edda, á bina, amá wá, daaka. ");
INSERT INTO mfi_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ate kure mu, ura-ara am egdzara ŋanna una a magaa názena a katanaa eddeŋara?» «Ba egdze na ta ndaan ge ŋane zuŋŋwe na,» a ba itare. Daaci a ba Yaisu á elvan ge itare: «Yá ndaakur ba jirire: Watse tá daada ba emnde á ŋezla antara zaware-aha zuŋŋwe á dem zlanna á Dadaamiya arge kure. ");
INSERT INTO mfi_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Aɗaba sámsa Yuhanna, a kwarakurse baráma a jirire, fakurtaareka an ŋane. Amá emnde a ŋezla, antara zaware-aha wá, fartaarefe an ŋane. A ba am sarte na nakuránna duksa ŋanna zlauzle keni, aley eptsakurka am tuba geni kwá fetaraarfe an ŋane.» ");
INSERT INTO mfi_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Cenaucena naraje umele zlaɓe ádaliye,» a ba Yaisu: «Ndza aŋkwa edda á há umele, a dzeɓaa náfa á inabauhi am fe-aara, a jantaave an dala, a magaa tate á ɓeca egdza á náfá, ira bere á edda á ufa fe ŋanna, daaci a ƴateraa fe ŋanna baɗemme am erva ge emnde a slera, ŋane a daa shula. ");
INSERT INTO mfi_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Samsa sarte a tsaka inabauhi maa, edda á fe na a ɓelaa emnde a slera-aara umele áseza emnde na a ƴateraa fe am erva, geni tá lyanvaalya dza á inabauhi-aara. ");
INSERT INTO mfi_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Amá náwa názu ta magatertaa itare: Ta sluwatervaahe baɗemme á emnde na a ɓelateraa edda á fe na, ta hyanhe ge palle-aatare an ja, buwire-aatare ta ja shifa-aara ba ɗekiɗeki, keƴire-aatare ta dzagese an nákwá. ");
INSERT INTO mfi_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Edda á fe na a naba ɓelaa emnde a slera-aara umele jauje ba ge una am zuŋŋwire na, amá emnde a mága slera am fe ta de magateraa ba názena ta magaterte ge emnde zuŋŋwe. ");
INSERT INTO mfi_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mazla-aara wá, edda á fe na a ɓelateraa egdza-aara ba ge ŋane. A ba ŋane: Egdza-aaruwa ba ge iya na wá, sey tá de fa zherwe áte ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Amá ba ta puwete ice áte ŋane emnde a mága slera am fe wá, a ba itare am dágave-aatare: Yawwaa, kwaye samsa edda una watse á zaná ŋane waráta á fe á miya na. Gwawamiyargwe, jaumija ba shifa-aara, fe-aara ŋanna watse á gev ba náza á miya. ");
INSERT INTO mfi_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Daaci má ta eksevaahe, ta danse áte iga a dala á fe ŋanna, ta naba ja shifa-aara.» ");
INSERT INTO mfi_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","A ndavateruhe ge Yaisu, a ba ŋane á elvan ge itare: «Má samsa edda á fe na mu, watse á magaterá uwe ge emnde a mága slera am fe na?» ");
INSERT INTO mfi_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ta ŋwanante, a ba itare: «Watse á zatervaareka ɗekiɗeki ge emnde a mándzawe ŋanna, sey watse á ceɓaterceɓa, watse á ƴaterá inabauhi-aara am erva ge emnde na ni watse tá vante dza á inabauhi-aara an uŋŋule-aara na.» ");
INSERT INTO mfi_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","A ba Yaisu á elvan ge itare zlaɓe ádaliye: «Aŋkwa naraje am wakita á Dadaamiya, a ba ŋane: “Ba nákwa ŋanna ta eblyanvaa emnde a nyáŋa bere na una, a eksantehe ge Dadaamiya, a ganve nákwá na á ŋáná ŋane ndzeɗa á bere ŋanna baɗemme. Kwaye ŋane názena a maganaa Yaakadada, shagera ge miya, máki namiyanna duksa ŋanna.” Ábi ndaakursende naraje ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","A ba Yaisu á elvan ge itare zlaɓe ádaliye: «Yá ndaakur ba jirire, una keni watse ba estuwa ŋanna. Watse Dadaamiya á de sanse hákuma á maga slera-aara am erva á kure, á de vaterte ge emnde a jeba umele na tá de fansaarefe na. ");
INSERT INTO mfi_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nákwá ŋanna wá, ma ware una a mbeɗehe átekwa keni, sey á kezlevkezle am tate umele. Edda una a eblyaara nákwá ŋanna ge ŋane, á hánaahe edda-aara á ganvege ba seke haha.» ");
INSERT INTO mfi_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ba ta cenaa naraje-aha á Yaisu na, male-aha á *liman-aha antara *Farisa-aha wá, ta naba diyeddiye geni á ndahaná áte itare. ");
INSERT INTO mfi_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ta naba tátaya pute á ekseksa-aara, amá á waterwa lyawa átuge jáháva á emnde na, aɗaba emnde baɗemme njarantenje Yaisu, geni ŋane nabi á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yaisu aŋkwa á vaterte sera á elva á ba an naraje zlaɓe ádaliye, a ba ŋane á elvan ge itare: ");
INSERT INTO mfi_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Náwa názu á gárává an dem zlanna á Dadaamiya: Aŋkwa slekse, a magaa muŋri á larusa, a ganaa gyaale ge egdza-aara. ");
INSERT INTO mfi_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Daaci a ɓelaa walaaɗi-aha-aara, tá de ɗanante emnde na ni tá se za ɗafa á larusire na, amá emnde ŋanna kwalarevkwále sarka. ");
INSERT INTO mfi_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","A ɓelaa emnde umele zlaɓe ádaliye an nara-aara, a ba ŋane: Bawateranba ge emnde na ya ndavateraa ya na wá: Ceɓanceɓa dalau-aha-aaruwa, antara dabba-aha-aaruwa umele na ni tá an ŋasla jipu na, an tsatsa duksa baɗemme, sawmbare á sem muŋri á larusa! ");
INSERT INTO mfi_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Amá emnde na ta ɗahateraa á dem muŋri ŋanna faranuka hyema ge una ŋanna ɗekiɗeki, ta zlalehe á dem tate á wedere-aha-aatare. Ura umele a dem fe-aara, umele a dem tsakala-aara, ");
INSERT INTO mfi_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","emnde umele ta sluva emnde a ɓela á slekse ŋanna, ta magateraa palása, ta ceɓaa shifa-aatare. ");
INSERT INTO mfi_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Daaci jaaja ervauŋɗe slekse maa, a naba ɓela sawji-aha-aara geni tá de ceɓá emnde a ceɓa shifa ŋanna, ta zu ekse-aatare baɗemme an kárá. ");
INSERT INTO mfi_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Daaci a ba slekse á elvan ge emnde a slera-aara umele: Muŋri á larusa wá, an gya, amá emnde na ndza ya ɗaterɗaha na wá, tá fuka mázla-aara. ");
INSERT INTO mfi_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Naba zlalauzlala á dete we á wálkame-aha, ma kwa shaa emnde-ara keni ɗawaterɗáhá, a se zaruze. ");
INSERT INTO mfi_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Duwa-aatare á dete we á wálkame-aha, baɗemme á emnde na ta de shateraa itare na, ta saterhe baɗemme, emnde a jirire, an emnde a mándzawe baɗemme, a se nahete ge huɗe á há an nalga. ");
INSERT INTO mfi_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«A tsete ge slekse, a de zhárá emnde na a ɗahateraa ŋane maa, a naa ba ura, tsekwámka am naŋgyuwe á dem larusa. ");
INSERT INTO mfi_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","A ba ŋane á elvan ge ŋane: Ura-aaruwa, ka shanaa estara ka baráma á sehuna tsekwakemka am naŋgyuwe á larusa na? Palle á elva na a ndahanaa zhel na ɓaaka. ");
INSERT INTO mfi_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Daaci a ba slekse á elvan ge kwakwane-aha-aara: Puwawanempuwa zawa am mbiye ge zhel na, takwasawutakwasa ba shagera erva-aha antara sera-aha-aara baɗemme, de eblyawanmeblye á dem tate na tabeɗamme jipu na ágáshe, a kyuwa kwa áhuwa, a ekkerɗa slare-aara.» ");
INSERT INTO mfi_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ge zla elva-aara Yaisu, a ba ŋane: «Kwakya emnde na á ɗaháterá Dadaamiya, amá á dzerese ba cekwa am huɗe-aara.» ");
INSERT INTO mfi_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Daaci duwa á *Farisa-aha, ta de magaa sawari-aatare geni sey tá eksevaksa Yaisu áte elva. ");
INSERT INTO mfi_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Am iga á sawari-aatare ŋanna maa, ta naba ɓela pukura-aha-aatare umele antara emnde á *Hirudus á deza Yaisu, geni tá de ndavanu elva na. A ba itare: «Malum, diyaŋerdiya geni ekka wá, ka slejirire, ka slekwaraterse jirire á Dadaamiya ge emnde áte una á kataná ŋane, ɓaaka lámbe á ŋa áte ŋgahire á urimagwe na tá ndahaná emnde na. ");
INSERT INTO mfi_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Daaci náwa ŋá ndava ázeŋa wá, ndaŋerndaha názena ka disaa ka. Am *tawraita á miya mu, aŋkwa emtu baráma á puwaná hadáma ge male á larde á Rauma, ɓaaka he?» ");
INSERT INTO mfi_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Amá kerteŋ diyeddiye Yaisu mándzawire na ta kwamanaa itare baɗemme. A ba ŋane á elvan ge itare: «Kwa emnde a fida, labára kwá tsagwaɗitsagwaɗa? ");
INSERT INTO mfi_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Marawiyánmárá emtsaaɗe shuŋgu na tá puwa hadáma an ŋane na.» Ta maranaa suley palle. ");
INSERT INTO mfi_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","A ba ŋane á elvan ge itare: «Nderáva á ware una áte shuŋgu na? Ira zhera na mu, zhera á ware?» ");
INSERT INTO mfi_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ta ŋwanante, a ba itare: «Náza á male á larde á Rauma.» A ba Yaisu á elvan ge itare: «Daaci má estuwa wá, puwawanpuwa ge male á larde názu zlaya-aara, ge Dadaamiya keni názu zlaya-aara.» ");
INSERT INTO mfi_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tá maga ba najipu á jawapa na ta cenanaa itare na. Daaci ta ƴaa Yaisu, ba zlala-aatare. ");
INSERT INTO mfi_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ba vacite ŋanna zlaɓe ádaliye maa, ta naba sem ge *Saduki-aha áseza Yaisu. Ba itare emnde na ta bantsa itare, ɓaaka tse á emnde am faya na. Ta se ndavanu elva, a ba itare: ");
INSERT INTO mfi_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Malum, a ba Muusa, máki emtsamtsa zhele ƴanka egdzere wá, a melesemele egdza emmeŋara mukse-aara geni á yaná egdzara ge egdza emmeŋara na keɗaakeɗa na. ");
INSERT INTO mfi_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Iyau, ndza tá aŋkwa dawalaa vuye ázeŋere ta egdzar mama, duwa á makaji-aatare, a gaa gyaale, áma a naba keɗehe, a ƴaa mukse na ɓaaka egdzere. ");
INSERT INTO mfi_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","A melese ge sleɗaba-aara, ŋane keni a keɗehe, a ƴaa mukse na ɓaaka egdzere. Keƴire-aatare keni ba estuwa, itare vuye na baɗemme ta gaa ba mukse ŋanna, baɗemme zlaruzle ƴaránka egdzere ba palle keni. ");
INSERT INTO mfi_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Am iga-aatare baɗemme, a keɗehe ge mukse ŋanna keni. ");
INSERT INTO mfi_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Vaci tse á emnde am faya mu, watse átuge ware palle mukse na? Aɗaba itare vuye na ndza mukse-aatare ba ŋane palle!» ");
INSERT INTO mfi_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","A ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Kure jakuraaveje áte baráma a jirire, aɗaba diyakurka názu am wakita á Dadaamiya, diyakurka ndzeɗa á Dadaamiya keni ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Má tsaretse emnde a faya wá, ɓaaka gá mukse, ma ŋwasha keni ɓaaka de gá zhele. Emnde baɗemme tá de njá ba seke malika-aha am samaya. ");
INSERT INTO mfi_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tse á emnde am faya keni maa, kure ndaakurseka názu a bakurnaa Dadaamiya áte elva ŋanna emtu? Aɗaba a ba ŋane áte eggye-aha á kure werre: ");
INSERT INTO mfi_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ba iya una ya Dadaamiya á Ibrahima, ya Dadaamiya á Isiyaaku, ya Dadaamiya á Yakubu. Daaci máki estuwa wá, tá á ba an shifa-aatare emndu werre. Aɗaba Dadaamiya wá, ŋane Dadaamiya á emnde na tá an shifa, Dadaamiya á emnde na ni tá an emtseka.» ");
INSERT INTO mfi_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Baɗemme á dikele á emnde na ta cenaa jawapa-aara na tá maga ba najipu-aara. ");
INSERT INTO mfi_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Cenaráncena *Farisa-aha geni jawapa á Yaisu katevaaka ye ge *Saduki-aha maa, ta naba jamme átirpalle. ");
INSERT INTO mfi_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Aŋkwa ura palle am dágave-aatare wá, ŋane malum á *tawraita, a magaa niya-aara geni á de tsagwaɗa Yaisu áte elva. A ba ŋane á elvan ge Yaisu: ");
INSERT INTO mfi_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Malum ƴaikke, ƴaikka ura-ara am shairiya-aha á Dadaamiya baɗemme?» ");
INSERT INTO mfi_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","A ŋwanante ge Yaisu, a ba ŋane á elvan ge ŋane: «Ewwáya Yaakadada Dadaamiya á ŋa an ervauŋɗe á ŋa baɗemme, an shifa á ŋa baɗemme, an eŋkale á ŋa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ƴaikke ba una ŋanna am shairiya-aha á Dadaamiya, ɗemɗeme zlaɓe adaliye. ");
INSERT INTO mfi_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Náwa buwire-aara na ni tá gáráva na: Ewwáya sleriya á ŋa ba seke ire á ŋa. ");
INSERT INTO mfi_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Am *tawraita á Muusa antara názu ndza ta kwaratersaa nábi-aha umele ge emnde, ƴaikke-aara ba shairiya-aha buwa na.» ");
INSERT INTO mfi_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Am tá aŋkwa *Farisa-aha jarammeje átirpalle maa, Yaisu a ndavateru elva na, a ba ŋane á elvan ge itare: ");
INSERT INTO mfi_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Kure mu, kwá slanve uwe ge *Almasiihu? Kwá ba wulfe á ware?» Ta ŋwanante a ba itare: «Wulfe á *Dawuda.» ");
INSERT INTO mfi_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","A ba Yaisu á elvan ge itare: «Ay estara kena Dawuda keni ndza á ɗaháná an Yaakadada na? Aɗaba a ba Dawuda an hákuma á Sheɗekwe Cuɗeɗɗe: ");
INSERT INTO mfi_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“A ba Yaakadada á elvan ge Yaakadada-aaruwa: Njinja am naɗafa-aaruwa, dem sarte na má ganatervege kelaade-aha á ŋa tate á puwa sera á ŋa.” ");
INSERT INTO mfi_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Máki ndza a ɗantaa Dawuda Almasiihu an Yaakadada, á sawa estara kena zlaɓe ádaliye ni á gev wulfe-aara na?» ");
INSERT INTO mfi_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ba palle keni jerka edda una ni á ŋwananteŋwa. A fantau á ba am sarte ŋanna, ɓaaka ura á kwamaha de ndavanu elva mázla-aara. ");
INSERT INTO mfi_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Daaci a ba Yaisu á elvan ge jáháva antara pukura-aha: ");
INSERT INTO mfi_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Malum-aha á *tawraita antara *Farisa-aha wá, slera-aatare tá kwaraterse názu a ndahanaa tawraita á Muusa ge emnde ákyiye. ");
INSERT INTO mfi_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Daaci fawatersaarefe, magaumága názena tá bakurná itare baɗemme. Amá wá, magauka názena tá maganá itare na ɗekiɗeki. Aɗaba názu tá kwaraterse ge emnde na, itare tá maŋka áte una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tá faterar gwatame ɗemɗeme ge emnde, amá itare ba gulanda-aatare keni tá feka átekwa ɗekiɗeki ge melaterumele. ");
INSERT INTO mfi_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Baɗemme á názena tá maganá itare, tá magán ba geni a zhararaterzhárá emnde. Estuwa, tá puwa nayya-aha, tá dzeɓemá am duksa ba seke laya, tá ŋguɗaná áte wafke-aha-aatare antara áte erva-aha-aatare, ira tá saganve jeba á puwa-aha umele aŋkwa áte zane-aha-aatare. ");
INSERT INTO mfi_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ma am muŋri-ara keni itare tá kátá ba sleɗe na ni an dárádza jipu na. Am mashidi keni sleɗe-aatare sey á jauje ge náza á emnde baɗemme, ma ware keni á náterna. ");
INSERT INTO mfi_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Tá kátá emnde tá ɗaháterá an “malum”, tá gater use an ga ire am dágave á zlamaha. ");
INSERT INTO mfi_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Amá kure wá, vawaterteka baráma ge emnde geni tá ɗahákurá an malum-aha, aɗaba baɗemme á kure kwa ba egdzar mama, aŋkwa Malum á kure ba palle. ");
INSERT INTO mfi_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ɗahauka ura áte duniya na an dada ɗekiɗeki, aɗaba Eddekure ba palle aŋkwa am samaya. ");
INSERT INTO mfi_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","A ɗaharakurka an male ɗekiɗeki, aɗaba aŋkwa Male á kure ba palle, ba ŋane una *Almasiihu. ");
INSERT INTO mfi_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ma male ware am dágave á kure keni, a gevge walaɗi á kure. ");
INSERT INTO mfi_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ma ware una a kantaa ba ŋane ire-aara na, sey tá de gánaaga. Áma edda una ni a gaa ire-aara wá, tá de kananteka.» ");
INSERT INTO mfi_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Watse zlaɗa ge kure malum-aha á *tawraita antara *Farisa-aha, kure kwa emnde a fida! Watse zlaɗa ge kure aɗaba kwá piyaterante dem *kwárá á Dadaamiya ge emnde. Kure keni dakuremka, emnde na tá kátá demda na keni kwa piyaterante. (( ");
INSERT INTO mfi_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Watse zlaɗa ge kure malum-aha á tawraita antara Farisa-aha, kure kwa emnde a fida! Kwá lyatervuwe duksa-aatare ge wegyegwar ŋwasha, daaci kwá slaɗanve maduwa-aha á kure geni tá fakura áte emnde a jirire. Aɗaba una ŋanna, zlaɗa á kure á de jauje ge náza á emnde baɗemme.)) ");
INSERT INTO mfi_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Watse zlaɗa ge kure malum-aha á tawraita antara Farisa-aha, kwa emnde a fida! Watse zlaɗa ge kure, aɗaba kwá aŋkwa ja ɗaba am larde-aha antara áte ire á haye-aha baɗemme, geni kwá shansha ura palle á gevge am dza á kure ge ɗaba nadina á kure. Má shakuránsha keni, kwá ganve edda-aara dza á kárá, á jakuruuje ba ge kure ma ser buwa keni. ");
INSERT INTO mfi_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Watse zlaɗa ge kure malum-aha, wulfe na ni kwá táɗá wulfe-aha. Aɗaba a ba kure: Má ura zauze waɗa an *mashidi ƴaikke, ɓaaka názu á maganmága, sey máki a zu waɗa án dindar na am mashidi na lauktu á eɗɗaba waɗa-aara. ");
INSERT INTO mfi_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kure wá, kwa uce-aha ba jire, kwa wulfe-aha! Ƴaikke ura-ara ŋane am duksa-aha ŋanna? Amaana ƴaikke dindar na am mashidi emtu? Tá eksetá mashidi wá, tá ganve dindar cuɗeɗɗe an ŋane emtu? ");
INSERT INTO mfi_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kwa bántsa kure zlaɓe ádaliye wá: Má ura a zu waɗa an názu tá fa sadake átekwa wá, ɓaaka názu á maganmága ɗekiɗeki. Amá máki edda-aara a zu waɗa an sadake na átekwa na wá, á eɗɗaba waɗa-aara ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kure wá, kwa wulfe-aha! Ƴaikke ura-ara ŋane am duksa-aha ŋanna? Amaana ƴaikke sadake arge duksa na tá faná átekwa na emtu? Emtu ƴaikke duksa na tá fa sadake átekwa, á ganvá ŋane sadake ŋanna cuɗeɗɗe na he? ");
INSERT INTO mfi_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yá ndaakur ba jirire, máki edda-aara zauze waɗa an duksa na tá faná sadake ge Dadaamiya átekwa na wá, edda-aara a zu waɗa an duksa ŋanna ira sadake na átekwa na keni. ");
INSERT INTO mfi_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Edda una má zauze waɗa an *mashidi ƴaikke, a zu waɗa an mashidi ka palle. A zu waɗa an Dadaamiya na am mashidi ŋanna keni. ");
INSERT INTO mfi_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Edda una a zu waɗa an samaya, a zu waɗa an kurshi á sleksire á Dadaamiya, ira Dadaamiya na á njá am kurshi ŋanna keni. ");
INSERT INTO mfi_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Watse zlaɗa ge kure, malum-aha á *tawraita antara *Farisa-aha, aɗaba kwa emnde a fida! Ɗále-aha seke tara ɗale á minti, antara timba ira makshaksha wá, kwá aŋkwa vante luser-aara ge Dadaamiya. Amá duksa ƴaikke na á kwaratersa *tawraita ge emnde seke tara jirire, antara maggwire, ira dzayyire á ervauŋɗe wá, kwá maŋka. Mbate keni ma andze kwá maganá á ba antara una-aha ŋanna, ɓaaka una kwá ƴanseƴe. ");
INSERT INTO mfi_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kure keni kwa wulfe-aha, kwá taɗa wulfe-aha seke kure. Kwá ƴemese ugjanja am yáwe á kure, amá ezlegwame wá, ƴemakurka, kwá shaná á ba antara ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Watse zlaɗa ge kure malum-aha á tawraita an Farisa-aha, aɗaba kwa emnde a fida! Kwá bárá iga á náza sha duksa antara tasa-aha á za duksa á kure, amá an naha tara neylire, antara shagerkire am huɗe-aara. ");
INSERT INTO mfi_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ekkure Farisa-aha wá, kwa wulfe-aha! Barawábárá emtsaaɗe huɗe á tasa-aha á kure, iga-aara watse á gevge tseɗaŋŋe. ");
INSERT INTO mfi_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Watse zlaɗa ge kure malum-aha á tawraita antara Farisa-aha, kwa emnde a fida! Kure kwa ba seke irekhye-aha na an bárá an duksa dzayye, zariya am ice á emnde, amá am huɗe-aara wá, an naha ba se á emtsa, an weshege-aha gergere. ");
INSERT INTO mfi_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kure keni kwa ba seke una ŋanna. Ágáshe wá, kwa emnde a jirire áza emnde, amá kwakya fida antara mándzawire am kure.» ");
INSERT INTO mfi_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Watse zlaɗa ge kure malum-aha á *tawraita antara *Farisa-aha, aɗaba kwa emnde a fida! Kwá aŋkwa nderá irekhya á nabi-aha geni hayakuránháyá slera á eggye-aha á kure, kwá aŋkwa caɗa irekhya á emnde na ndza ta magaa jirire á Dadaamiya, ");
INSERT INTO mfi_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","aley wá, a ba kure: Ma andze ŋá aŋkwa am zamane á eggye-aha á ŋere wá, ma ŋá melateruka ge ceɓa shifa á nabi-aha. ");
INSERT INTO mfi_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ba kure keni diyakurdiya am ire á kure geni kwa wulfe-aha á emnde na ndza ta ceɓaa shifa á nabi-aha. ");
INSERT INTO mfi_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Naba magaumága slera á kure ƴawánka, zlawanaazle slera á eggye-aha á kure. ");
INSERT INTO mfi_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","«Kwa havale-aha, kwa egdzara á pushe ba jire! Una ni kwá de ŋezla am shairiya, kwá duka á dem kárá á jahanáma, a ba kure? Kwá ŋezleka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Aɗaba una ŋanna yá ndaakur ba jirire, cenaucena elva na: Watse yá ɓelakurá nabi-aha, antara emnde a eŋkale, ira malum-aha, amá emnde umele-aatare watse kwá ceɓa shifa-aatare, emnde umele watse kwá zleŋeláterá áte dzaŋgala, emnde umele watse kwá slerpáterá an ja am mashidi-aha á kure, watse kwá de tatayatertátaya am ekse-aha baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Daaci baɗemme á uzhe á emnde cuɗeɗɗe na ndza ta ceɓateraa am duniya na, kwaye emtsa á Habila, sem emtsa á Zakariya baɗemme á ba am mbiye á kure. Zakariya na wá, yá ndahá elva á Zakariya egdza á Barakiya na ndza kwa janaa am dagave á tara bere cuɗeɗɗe antara duksa na tá faná sadake ge Dadaamiya átekwa na. ");
INSERT INTO mfi_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Una yá ndaakur ba jirire: Baɗemme á uzhe á emnde ŋanna á ba am mbiye á emnde a zamáne na!» ");
INSERT INTO mfi_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Urusaliima, Urusaliima, ekka ka ceɓaa nabi-aha, ka ceɓaa emnde na a ɓelateraa Dadaamiya an nákwá! Ser kwakya una yá kátá jema emnde á ŋa ásezerwa, ba seke náza á mama á ukkula, máki a jemaa egdzara-aara á dem ekta á zlambake-aara. Amá kwalakefkwale. ");
INSERT INTO mfi_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kina wá, ƴanakaaƴa, ká de gev ba kaamba! ");
INSERT INTO mfi_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yá ndaakur ba jirire: Kwá puweteka ice á kure áte iya mazla-aara, dem sarte na ni watse kwá bánba ba kure an we á kure ganakini a ganga Dadaamiya barka ge edda una a sawa an zhera á Yaakadada na!» ");
INSERT INTO mfi_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Daaci sessa Yaisu am *mashidi ƴaikke, aŋkwa á zlálá maa, ta duhe ge pukura-aha-aara á dezeŋara, a ba itare tá elvan ge ŋane: «Ezzhara emtsaaɗe jeba á nderáva á mashidi na.» ");
INSERT INTO mfi_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Daaci a ba Yaisu á elvan ge itare: «Yá ndaakur ba jirire: Una ŋanna kwá zharaná kure baɗemme na, watse á mbeɗa baɗemme, ba nákwá palle keni watse á jauka áte ukfeŋara nákwá.» ");
INSERT INTO mfi_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","De njaanja Yaisu áte ire á Wa Anyaranyara, ta duhe ge pukura-aha-aara á ba an niya á dezeŋara, ta de ndavanuhe, a ba itare tá elvan ge ŋane: «Ndaŋerndaha watse á magava am sarte-ara una ŋanna? Watse ŋá dise áte uwe ganakini herzha sawa á ŋa, an zle á duniya?» ");
INSERT INTO mfi_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","A ŋwaterante ge Yaisu, a ba ŋane: «Kure wá, faufa ba hyema, a se keɗarakuraaka emnde umele. ");
INSERT INTO mfi_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Aɗaba watse kwakya emnde na tá de sawa an zhera-aaruwa, ma ware keni á se ba: Ba iya una ya *Almasiihu. Daaci tá se keɗa emnde kwakya. ");
INSERT INTO mfi_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Watse kwá cenáncena labare á wáva-aha am larde-aha na ba herherzhe an kure, antara am larde-aha na ƴiƴiye an kure, amá gazlauka ɗekiɗeki. Sey á de magava una-aha ŋanna, amá zlaɓe zle á duniya ka emtsaaɗe. ");
INSERT INTO mfi_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Watse larde umele á de darge larde umele an wáva. Emnde á slekse umele, tá de darge kwárá á slekse umele an wáva. Waya antara gejava á haha á de magava am tate-aha gergere. ");
INSERT INTO mfi_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Baɗemme á una-aha ŋanna, zlaɓe ba fakta á zlaɗa emtsaaɗe, ba seke náza á mukse na fanantaufe zlaɗa á yá. ");
INSERT INTO mfi_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Watse tá sluwakursluwa, tá vakurte ge emnde tá magakurá palasa, tá de ceɓa shifa á kure. Emnde baɗemme tá de dá ba kelaadire ádete kure aɗaba zhera-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Emnde kwakya tá de ƴá fetaare áte ya mazla-aara am sarte ŋanna, tá de maga ba kelaadire, antara dugune am dagave-aatare. ");
INSERT INTO mfi_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tá de jesaareje nabi-aha fida kwakya, tá de keɗa emnde kwakya. ");
INSERT INTO mfi_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Watse á kwakyevaa ba shagerkire am dagave á emnde. Watse kwakya emnde na á de gula wáyáva-aatare. ");
INSERT INTO mfi_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Amá edda una tsaatse shagera dem halavuwa-aara wá, á lyelye shifa-aara. ");
INSERT INTO mfi_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Á hyemhya labare á higa, elva a sem *kwara á Dadaamiya, am huɗe á duniya baɗemme, watse tá maganaamaga seydire am larde-aha baɗemme, lauktu á sawa zle á duniya.» ");
INSERT INTO mfi_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Watse kwá nánna duksa na ni tá ɗaháná an shagerkire emtaŋka ɗekiɗeki na am tate á cuɗeɗɗe. Nabi Daniyail wá, ndza a enndaha elva-aara werre. Ma a ndaasa ware elva-aaruwa na keni, a cenevaacena elva ŋanna ba shagera. ");
INSERT INTO mfi_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Vacite na ni má nakuranna duksa ŋanna wá, watse kyaakya ge emnde na tá am Yahudiya, tá zlerda zhagade á dem huɗe á wa. ");
INSERT INTO mfi_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Edda una áte ire á bere keni, a tsuŋka á dem huɗe á bere ge hálá kazlaŋa-aara. ");
INSERT INTO mfi_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Edda una am fe keni, a eptseka á sá ge se hálá naŋgyuwe-aara. ");
INSERT INTO mfi_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","«Watse á tsaame kwa zlaɗa á ŋwasha na watse tá á huɗe am sarte ŋanna, antara ŋwasha na tá an egdzara áte erva na! ");
INSERT INTO mfi_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ŋalauŋála Dadaamiya ganakini zhagade á kure a gevka am sarte á ekhye, bi an kwaskwe á puwansepuwe! ");
INSERT INTO mfi_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Aɗaba watse kwakya jipu zlaɗa am sarte ŋanna. Ta nderaa estuwa duniya, sem vatena, jerka jeba á zlaɗa ŋanna ɗekiɗeki. Á de jesarka keni zlaɗa na ni ta kalle an una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ma andze gulanaaka Dadaamiya hare-aha á zlaɗa ŋanna wá, ma andze á jauka ura an shifa ba palle keni. Amá a naba gulanaahe ge Dadaamiya aɗaba emnde na a dzeratersaa ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Daaci am sarte ŋanna, ma a bakurnaa ware: Nawa aŋkwa *Almasiihu áhuna, bi kwaya aŋkwa áhuwa, lyiyauka elva ŋanna ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Aɗaba watse tá jesareje almasiihu-aha fida, antara nabi-aha fida am sarte ŋanna. Watse tá maga nalaama-aha antara najipu-aha gergere kwakya, geni ambane tá keɗateraakeɗa emnde na ni a dzeratersaa Dadaamiya áte eŋkale. ");
INSERT INTO mfi_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Cenawáncena! Náwa fanakuremfa ya am vuwa zlauzle. ");
INSERT INTO mfi_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Daaci ma tá bakurá: Kwaye aŋkwa *Almasiihu am kaamba keni, kure daumbareka. Ma tá bakurá: Náwa ŋane, a sheɓevaa ire-aara áhuna keni, fautaareka an elva-aatare ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Aɗaba ba seke mága á kárá á ráde á sawa am samaya, á fantau am geɗi dem pute keni ba ŋane na wá, watse sawa á *Ura á emnde baɗemme keni ba estuwa. ");
INSERT INTO mfi_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Aɗaba am tate na ni aŋkwa lipa átekwa, zaatate-aha keni tá jaháva á ba ádehuwa.» ");
INSERT INTO mfi_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Kerteŋ am iga á zlaɗa ŋanna maa, vaciya á de gevge daŋŋwe baɗemme, tere keni á de máreka parakkire-aara, terlyakwa-aha keni watse tá geda á sem áhá, baɗemme á ndzeɗa á názena áte samaya á de gejavtegeje ba ŋarŋare sleɗe. ");
INSERT INTO mfi_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Daaci tá de zhárá ba nalaama á *Ura á emnde baɗemme á sawa am samaya. Baɗemme á emnde na tá am duniya na tá de kyuwa, daaci tá zhárá ba iya Ura á emnde baɗemme yá aŋkwa á sawa áte kumba, yá sawa an hákuma ƴaikke antara ɗemɗemire. ");
INSERT INTO mfi_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tá de fertanteferta derkwákwá ƴaikke, daaci yá de ɓela malika-aha-aaruwa á dem karáfke-aha á duniya ufaɗe kerɗe, geni tá jatermaare ge emnde na ya dzeratersaa ya na baɗemme.» ");
INSERT INTO mfi_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Diyaweddiye á ba áte mama á nabugda. Máki kwa nanna gedaageda hyema átekwa, ƴaaƴa umele aŋwaslire wá, diyakurdiya ganakini herzhavteherzhe madare. ");
INSERT INTO mfi_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Una keni ba duksa palle. Máki aŋkwa á magava duksa-aha ŋanna wá, diyaweddiye ganakini iya keni yá ba áte we á sera mazla-aara ge sawa. ");
INSERT INTO mfi_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yá ndaakur ba jirire: Emnde a zamane na tá de zlauka ba estuwa, sey máki naránna duksa-aha ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tara samaya an haha wá, tá naba keɗa, tá zlauzle. Amá elva-aaruwa wá, á keɗeka ɗekiɗeki, sey má gevge.» ");
INSERT INTO mfi_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Elva á hárá á bere, antara sarte ŋanna wá, ɓaaka slediya-aara ɗekiɗeki. Ma malika-aha am samaya, ba iya *Egdza á Dadaamiya keni diyanka, sey diyaa ba Dadaamiya palle ŋane Dada. ");
INSERT INTO mfi_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ba názena ndza a magava am zamane á *Nuhu na wá, watse ba seke una ŋanna kalkale má watse yá sawa iya ya *Ura á emnde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Am sarte na zlaɓe samka yáwe á keɗa duniya wá, slera á emnde ndza ba tátaya emtakire á duniya; tá ezza, tá essha, tá gá larusa, tá vaterte gyaale-aha-aatare ge zála, a semaa estuwa kwaskwe na a demaa Nuhu á dem paare-aara, tá maga ba una. ");
INSERT INTO mfi_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","A se keɗateraahe ba estuwa yawe á keɗa duniya, farka hyema ɗekiɗeki. Má watse yá de sawa iya ya Ura á emnde baɗemme keni, á de magava ba estuwa. ");
INSERT INTO mfi_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Watse yá se bera emnde buwa am fe, watse yá eksa palle, palle-aatare yá ƴánƴa. ");
INSERT INTO mfi_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ŋwasha buwa tá há hiya, yá eksa palle, yá ƴá palle. ");
INSERT INTO mfi_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Aɗaba una ŋanna, njawinja á ba am niya á kure. Aɗaba diyakurka sarte na ni á de sawa Yaakadada á kure átekwa na. ");
INSERT INTO mfi_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Aŋkwa duksa palle, diyaweddiye ba shagera: Máki diyaadiya edda á há sarte na ni watse á sawa neyle átekwa na wá, á peka háre ɗekiɗeki, aɗaba wayaaka á demda neyle á dem huɗe á há-aara. ");
INSERT INTO mfi_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kure keni ba estuwa. Sarte na ni watse iya *Ura á emnde baɗemme yá de sawa átekwa na wá, diyakurka. Daaci njawinja á ba am niya á kure.» ");
INSERT INTO mfi_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Sleslera-ara ŋane dzayye ervauŋɗe-aara, sleŋkale zlaɓe ádaliye na? Ba edda una ni má zanwe-aatare a ƴanaa huɗe á há-aara baɗemme am erva ge ŋane, á vatertá ŋane náza za ge emnde na tá am huɗe á há ŋanna baɗemme, á vatertá an laukte-aara na. ");
INSERT INTO mfi_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yá ndaakur ba jirire, watse higa ƴaikke ge sleslera ŋanna, máki zanwe-aara a se beranaa á ba am slera-aara. ");
INSERT INTO mfi_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Rezege-aara baɗemme keni á naba fanemfe am erva zanwe-aara ge sleslera ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Amá máki daŋŋwe ervauŋɗe á sleslera ŋanna wá, á naba bánba am ervauŋɗe-aara ganakini labára á saaka zanwe-aaruwa watsewatse. ");
INSERT INTO mfi_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Daaci á fantau ge magateraa palasa an ja ge emnde a slera umele, á zá názu am huɗe á há, á essha antara emnde a mbazla umele. ");
INSERT INTO mfi_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Daaci má á sa zanwe á sleslera ŋanna wá, á sa á ba an kwaskwe na ni tamaaka ŋane ɗekiɗeki, á sa am sarte na ni diyaaka ŋane ɗekiɗeki na. ");
INSERT INTO mfi_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Palasa na á se magante zanwe-aara ge sleslera ŋanna wá, náza enndaaka. Ba emtaŋkire na ni á se puwa emnde a fida á demkwa na wá, ŋane keni á ba am huɗe-aara. Á de kyuwa-aara am tate ŋanna, á de kerɗa ba sláre ge zlaɗa.» ");
INSERT INTO mfi_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Daaci dem zlanna á Dadaamiya wá, watse á gáráva an labare á gyaale-aha ta kelaawa, ta tsetehe an kárá á fanus-aha-aatare am erva, ta de yainu ge edda á larusa. ");
INSERT INTO mfi_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Emnde ilyeɓe am gyaale-aha ŋanna ɓaaka eŋkale-aatare ɗekiɗeki. Ilyeɓe-aatare keni, ta emnde a eŋkale jipu. ");
INSERT INTO mfi_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Duwa á gyaale-aha na ɓaaka eŋkale-aatare na maa, ta haletaa ba kárá-aha á fanus-aatare, amá magarka kaashi á kanandzir. ");
INSERT INTO mfi_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Amá gyaale-aha na tá an eŋkale na wá, ta haletaa kárá á fanus-aha-aatare, ira kwalaba-aha-aatare kanandzir am huɗe-aara. ");
INSERT INTO mfi_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Saaka edda á larusa ŋanna watsewatse maa, a naba ceɓaterhe ge háre. Gyaale-aha kelaawa na baɗemme parupe háre. ");
INSERT INTO mfi_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Am huɗe á vaƴiya wá, tá cena ba hula: Náwa samsa edda á larusa! Sawesse ásezeŋara, a ba itare. ");
INSERT INTO mfi_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Daaci gyaale-aha kelaawa na baɗemme tsaretse am háre na, tá fantau ge mba kárá á fanus-aha-aatare. ");
INSERT INTO mfi_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Daaci: Kawaŋeruke kanandzir-aha á kure na, náwa á emtsa kárá-aha á ŋere, a ba emnde na ɓaaka eŋkale-aatare na, tá elvan ge emnde a eŋkale. ");
INSERT INTO mfi_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ta ŋwaterante ge emnde a eŋkale, a ba itare tá elvan ge itare: Ŋere ŋá velka! Watse á hyamiyarka antara kure, dawmbare ádeza emnde a válá kanandzir. ");
INSERT INTO mfi_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ba zlarzlálá itare á de shekwa kanandzir na, a semhe ge edda á larusa keni. Gyaale-aha ilyeɓe na ndza tá am niya-aatare na daremda á dem bere á ga nika antara edda á larusa ŋanna, ta heɗetaa bere an tsekweram. ");
INSERT INTO mfi_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Shekwaashekwa wá, saremsa gyaale-aha umele na keni. Ta ketaa kwara: Edda! Edda, weraŋerantewera bere, a ba itare. ");
INSERT INTO mfi_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Amá a ŋwaterante ge edda á larusa, a ba ŋane á elvan ge itare: Yá ndaakur ba jirire: Diyanakurka ya ɗekiɗeki, ma kwa emnde-ara keni.» ");
INSERT INTO mfi_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ge zla elva-aara Yaisu, a ba ŋane á elvan ge itare: «Ma vaatara keni, njawinja á ba am niya á kure, aɗaba diyakurka kwaskwe ŋanna, diyakurka sarte ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Adaliye dem zlanna á Dadaamiya wá, á gáráva an zhel umele a daa shula. Lauktu á zlálá, a ɗetaa emnde a slera-aara, a tegateraa nalmane-aara. ");
INSERT INTO mfi_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A vante jekka deremke ilyeɓe ge slezuŋŋwe-aatare. Ge buwire-aatare, a vante jekka deremke buwa. Ge keƴire-aatare, a vante jekka deremke. Ma ware keni a vante ba deydey á ndzeɗa-aara, daaci ba zlálá-aara ge ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Duwa edda una a shaa jekka deremke ilyeɓe, kerteŋ a de mbeɗa erva an ŋane, a shetaa riba jekka deremke ilyeɓe. ");
INSERT INTO mfi_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Edda una ta vante jekka deremke buwa na keni, a de magán ba estuwa, ŋane keni a shetaa riba jekka deremke buwa. ");
INSERT INTO mfi_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amá edda una ta vante jekka deremke na wá, ŋane a de yese evege am haha, a heɗem nalmane á zanwe-aara am huɗe-aara. ");
INSERT INTO mfi_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Shekwaashekwa wá, a naba saahe ge zanwe á emnde a slera ŋanna, a ɗaterte ge zhárá lisaafi á slera na ta maganaa itare. ");
INSERT INTO mfi_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","A sawhe ge edda una ndza ta vante jekka deremke ilyeɓe na, a ba ŋane á elvan ge zanwe-aara: Ndza ka vite jekka deremke ilyeɓe, náwa ya shante riba jekka deremke ilyeɓe. ");
INSERT INTO mfi_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Shagera, a ba zanwe-aara á elvan ge ŋane: Ka sleslera á jirire, dzayye huɗe á ŋa. Ka magaa slera an duksa na cekwa dáradza-aara an ervauŋɗe á ŋa palle; kazlaŋa na kwakya dárádza-aara keni sey yá fakemfa am erva. Sawa mí higa antara ya. ");
INSERT INTO mfi_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","A semhe ge edda una ndza a vante jekka deremke buwa, a ba ŋane á elvan ge zanwe-aara: Ndza ka vite jekka deremke buwa, náwa ya shante riba keni jekka deremke buwa. ");
INSERT INTO mfi_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Shagera, a ba zanwe-aara á elvan ge ŋane: Ká sleslera á jirire, dzayye ervauŋɗe á ŋa. Ka magaa slera an duksa na cekwa dárádza-aara an ervauŋɗe á ŋa palle; kazlaŋa na kwakya dárádza-aara keni sey yá fakemfa am erva. Sawa mí higa antara ya. ");
INSERT INTO mfi_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Am iga-aatare baɗemme maa, a semhe ge edda una ndza ta vante jekka deremke palle na keni áseza zanwe. A ba ŋane á elvan ge ŋane: Ambarka á ŋa male, diyandiya ganakini ka slemándzawe, ma jaŋka ba wulfe á duksa á ŋa keni, ká hálá ba duksa; ma tegaŋka ba duksa á ŋa keni ká jáha ba duksa. ");
INSERT INTO mfi_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Iya jiija lyawa, ndza ya heɗem shuŋgu á ŋa am haha, náwa ŋane duksa á ŋa. ");
INSERT INTO mfi_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","A ŋwanante ge zanwe, a ba ŋane á elvan ge ŋane: Ka sleslera mándzawe, ka masefe! Diyakdiya ganakini ya slemándzawe, á ba ka? Ma janeka ba wulfe á duksa-aaruwa keni yá hála ba duksa; ma teganka ba duksa-aaruwa keni yá jahá ba duksa, á ba ka? ");
INSERT INTO mfi_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Máki ba estuwa wá, ma andze ka de puweme nalmáne-aaruwa am baŋ kwa, daaci ma ya se lyiya nalmáne-aaruwa an yawe. ");
INSERT INTO mfi_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Daaci lyauvaalya jekke deremke na ázeŋara na, a ba ŋane á elvan ge emnde na tá tsatse ázeŋara, vawanteva ge edda una an jekka deremke ilyeɓe, riba keni estuwa na. ");
INSERT INTO mfi_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Aɗaba edda una aŋkwa ázeŋara wá, tá de fanaarefe, tá de sagananvesage ba kwakya. Amá edda una shanteka ɗekiɗeki wá, ba una cekwa am erva-aara na keni, tá de lyevaalya am erva-aara. ");
INSERT INTO mfi_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ŋguɗi na ɓaaka námpire-aara ɗekiɗeki ŋanna maa, naba dawansede á degashe, de eblyawanmeblye á dem tate na ni tabeɗamme jipu na, á de kyuwa-aara am huɗe-aara, á de kerɗa ba sláre ge zlaɗa.» ");
INSERT INTO mfi_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Má watse samsa *Ura á emnde baɗemme am sleksire antara malika-aha-aara baɗemme wá, a se njema am kurshi á sleksire-aara. ");
INSERT INTO mfi_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Daaci baɗemme á emnde na tá am huɗe á duniya tá de jammeje á katafke-aara, á de láterá ŋane emnde baɗemme, ba seke náza suni má á lesa kyáwe-aha, á saterse am dagave á náwe-aha. ");
INSERT INTO mfi_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kyawe-aha wá, watse á puwáterá am naɗafa-aara, nawe-aha keni am nazlaɓa-aara. ");
INSERT INTO mfi_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Náwa elva na á de baterná slekse ge emnde na tá am naɗafa-aara: Kure emnde na Edderwa a gakur barka-aara na, sawmbare á sem ƴaikkire na ta tsatsakurán ge kure kwaye am fakta á duniya. ");
INSERT INTO mfi_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Aɗaba am sarte na a wiwa waya, kure kwa vite náza za; a wiwa ndera, kwa vite názu yá shushe; ndza ya wayve, kwa lyivaahe á dem mba á kure. ");
INSERT INTO mfi_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Am sarte na yá an ukhyiye dey, kwa tsekwime am naŋgyuwe; ndza ya lapika, zakurivaareze; ndza yá am daŋgay, kwa duwa á de zharizhara. ");
INSERT INTO mfi_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Daaci watse tá ŋwananteŋwa emnde a jirire na á ndaater elva na: Ndza ŋa nák vaatara á wáká waya, lauktu ŋa vakte náza za na Yaakadada? Ŋa nák áme á wáká ndera, ŋa vakte yawe? ");
INSERT INTO mfi_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ŋa nák vaatara ka wayve am ekse á ŋere, ŋa lyiyáká am mba á ŋere? Bi ká an ukhyiye dey ŋa tsekwakeme am naŋgyuwe? ");
INSERT INTO mfi_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ŋa nák vaatara lapika, bi ká am daŋgay, ŋa de zharakzhárá? ");
INSERT INTO mfi_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Watse á ŋwateranteŋwa slekse: Náwá yá sakuransese jirire-aara: Ba kelaa má kwa magateraa una-aha ŋanna ge egdzar mama-aha-aaruwa na cekwa ndzeɗa-aatare na wá, kwa magiyán ba ge iya. ");
INSERT INTO mfi_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Am iga á una ŋanna maa, náwa názu watse á baterná slekse ge emnde na tá am názlaɓa-aara: Jawinaaja ázerwa, kure emnde na nyainyaikurvenyainye Dadaamiya, zlalauzlalawa á dem kárá na ɓaaka emtsa-aara ɗekiɗeki, ta tsatsannaa ge Shaitaine antara malika-aha-aara na! ");
INSERT INTO mfi_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aɗaba ndza a wiyaa waye, kure vakuriteka náza za; ndza a wiyaa ndera, vakuriteka yawe; ");
INSERT INTO mfi_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ndza ya wayve, lyiyakurika á dem mba á kure; ndza yá an ukhyiye dey, vakuriteka naŋgyuwe; ndza ya lapika, ndza yá am daŋgay, dakurka á de zharizhárá. ");
INSERT INTO mfi_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Daaci watse tá ŋwananteŋwa itare keni: Ndza ŋa nák vaatara á wáká waya antara ndera, bi ka wayve, bi ká an ukhyiye dey, melaŋerakuka na Yaakadada? Ndza ŋa nak vaatara ká lapika, bi ká am daŋgay, daŋerka á de zharakzhárá? ");
INSERT INTO mfi_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Watse á ŋwateranteŋwa slekse: Náwa yá sakuransese jirire-aara: Ba kelaa má kwalakurevkwala magateraa una-aha ŋanna ge emnde na cekwa ndzeɗa-aatare na, magakuriyanka ba ge iya. ");
INSERT INTO mfi_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Daaci itare, watse tá dáterá á de magaterá palasa na á zleka ɗekiɗeki na. Amá emnde a jirire wá, tá de shá shifa na á zleka na.» ");
INSERT INTO mfi_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Zlanaazle Yaisu tsáká elva-aara maa, a ba ŋane á elvan ge pukura-aha-aara: ");
INSERT INTO mfi_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Diyakurdiya muŋri á *Paska wá, a juwaa ba háre buwa. Iya *Ura á emnde baɗemme wá, watse tá eksiva á ba am muŋri ŋanna, tá de zleŋeliyá áte dzaŋgala.» ");
INSERT INTO mfi_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","De jarammeje male-aha á *liman-aha, antara male-aha á Yahudiya-aha á ba am sarte ŋanna am mba Kayafas ŋane male á *liman-aha baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Daaci ta njantaa átirpalle geni tá eksevaksa Yaisu an nasherire, tá keɗánaakeɗa shifa-aara. ");
INSERT INTO mfi_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","A ba itare am dágave-aatare: «Magaumika una ŋanna vaci muŋri, geni a tsaranteka emnde elva.» ");
INSERT INTO mfi_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Am sarte na Yaisu am Baytaniya na wá, a dem mbá á Simaun umele ndza á waná derve, ");
INSERT INTO mfi_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","a demhe ge mukse umele an kuderá á waye-aara, á se emtake, kwakya gane-aara, a de puwar waye ŋanna ge Yaisu áte ire-aara am sarte na aŋkwa á za ɗafa. ");
INSERT INTO mfi_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ba ta naa una ŋanna pukura-aha, a naba jaterhe ge ervauŋɗe, a ba itare: «Azara shagerire-aara jeba á bádza duksa na? ");
INSERT INTO mfi_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ambane ka ma ta velu waye ŋanna, ma tá sha shuŋgu kwakya an ŋane, daaci ma tá tegater ge talága-aha!» ");
INSERT INTO mfi_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","De cenáncena Yaisu elva na tá weshaná itare, a ba ŋane á elvan ge itare: «Labára kwá hyaná lyuwa ge mukse na? Názena a maginaa ŋane na shagera jipu. ");
INSERT INTO mfi_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Aɗaba uwe, talága-aha wá, ma vaatara keni watse tá aŋkwa átevege kure, amá iya wá, watse ya ɓaaka átevege kure. ");
INSERT INTO mfi_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ŋane wá, waye na a puwiyaare ŋane na wá, tsatsiyaatsatse ge ɓeliya am evege. ");
INSERT INTO mfi_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yá ndaakur ba jirire: Am huɗe á duniya baɗemme, baɗemme á tate na ni tá de ɓálá labare á higa átekwa na wá, tá de ndaha názena ni a maganaa mukse na keni, tá de viyanaaka.» ");
INSERT INTO mfi_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Daaci aŋkwa palle á pukura-aha kelaawa ju buwa, zhera-aara Yahuda Iskariyaud, a tsete duwa-aara á deza male-aha á *liman-aha, ");
INSERT INTO mfi_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","a ba ŋane á elvan ge itare: «Kwá vite uwe yá magakuránmaga ya pute na ni á demda Yaisu am erva á kure?» Ta naba kezlanaa shuŋgu kul keƴe, cappe ta puwanem am erva. ");
INSERT INTO mfi_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","A fantau á ba am sarte ŋanna Yahuda ge tataya faterem Yaisu am erva ge emnde na á ba an keski. ");
INSERT INTO mfi_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Am váha zuŋŋwire na tá za muŋri na ɓaaka shahi á makalá am huɗe-aara na, duwa á pukura-aha, ta de ndavanu ge Yaisu, a ba itare: «Ká kátá ŋá de tsatsaká ɗafa á *Paska am tate-ara?» ");
INSERT INTO mfi_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","A ŋute ge Yaisu, a ba ŋane á elvan ge itare: «Dawmbare á dem mba á manya am huɗe á ekse, de bawanánba wá: a ba malum wá, hyephye sarte-aaruwa yá kátá za muŋri á Paska antara pukura-aha-aaruwa am mba á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Pukura-aha ta magaa názena a baternaa Yaisu na, daaci ta tsatsaa muŋri á Paska. ");
INSERT INTO mfi_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Am iga a maŋgaripu maa, Yaisu antara pukura-aha-aara ta nja arge masane. ");
INSERT INTO mfi_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","A ba ŋane á elvan ge itare arge masane ŋanna wa: «Náwa yá ndaakur elva, yá ndaakur ba jirire: Watse á veliya ba palle á kure.» ");
INSERT INTO mfi_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Daaci, baɗemme á pukura-aha jáviya ba tá kyuwa, ta fantau ge ndavanu an palpale, ma ware keni ba: «Iya ka ndza Yaakadada?» ");
INSERT INTO mfi_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","A ŋute ge Yaisu, a ba ŋane: «Edda una ni erva á ŋere antara ŋane am tása na wá, watse á veliya ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Iya *Ura á emnde baɗemme wá, ɓaaka pekya-aara sey ba yá emtsa. Ate una ta puwete am wakita á Dadaamiya áte iya wá, ba estuwa. Amá watse zlaɗa jipu ge edda una ni á de veliyá ŋane, ambane ma yareka.» ");
INSERT INTO mfi_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yahuda wá, á de velaná ba ŋane keni, a eksetaa elva, a ba ŋane: «Iya ka ndza Yaakadada?» A ŋwanante ge Yaisu: «Ba estuwa.» ");
INSERT INTO mfi_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Am sarte na tá aŋkwa za masane maa, Yaisu a eksetaa ɗafa, a slafanaa we-aara ge Dadaamiya, a kezlanve ɗafa na, daaci a vaterte ge pukura-aha-aara. «Nawmbare zawuze,» a ba ŋane, «una ŋanna vuwa-aaruwa.» ");
INSERT INTO mfi_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Am iga á una ŋanna maa, a eksante feka, a slafanaa we-aara ge Dadaamiya, a vaterte: «Shawushe», a ba ŋane á elvan ge itare. ");
INSERT INTO mfi_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","«Aɗaba una ŋanna uzhe-aaruwa; a puvaa aɗaba emnde kwakya, geni emnde kwakya a sharánsha gabera á haypa-aha-aatare, Dadaamiya á ŋguɗaterá an una ŋanna namána ge emnde. ");
INSERT INTO mfi_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yá ndaakur ba jirire: Am sali kataliya na wá, yá dalika á shá yawe á egdza á náfa antara kure mázla-aara, sey watse mí de shá ba una aŋwaslire am zlanna á Edderwa.» ");
INSERT INTO mfi_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Am iga á una ŋanna maa, ta eksante lahe á gálá Dadaamiya, ba tse-aatare, ta zlala ádete ire á Wa Anyaranyara. ");
INSERT INTO mfi_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Daaci a ba Yaisu á elvan ge pukura-aha-aara: «An vaƴiya vatena wá, baɗemme á kure na watse kwá ƴiyaaƴa. Aɗaba aŋkwa an puwa am wakita á Dadaamiya, a ba ŋane: Watse yá ejja suni, baɗemme á kyawe-aha am walda tá de kya. ");
INSERT INTO mfi_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Amá má watse tsanetse am faya wá, watse yá daada ba iya zuŋŋwe arge kure á dem Galili.» ");
INSERT INTO mfi_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","A ŋwanante ge Piyer, a ba ŋane á elvan ge ŋane: «Ma ƴarakaaƴa emnde umele keni, iya wá, yá ƴakaaka ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","A ŋwanante ge Yaisu: «Yá ndak ba jirire, an vaƴiya ba vatena na, lauktu á kyuwa tsákálá, watse ká bánba ka ser keƴe geni diyakikire.» ");
INSERT INTO mfi_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","A ba Piyer: «Yá ndaaka una ɗekiɗeki. Ma emtsa antara ka keni ba yá emtsa.» Baɗemme á pukura-aha umele keni ta ndahán ba estuwa. ");
INSERT INTO mfi_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Daaci daada Yaisu antara pukura-aha-aara á dem tate na tá ɗahaná an Gaicaimane na. A ba ŋane á elvan ge pukura-aha: «Náwa njawinja áhuna, iya kwaye yá de maga maduwa áhuwa.» ");
INSERT INTO mfi_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","A eksetaa tara Piyer, antara egdzara á Jaibaidaiyus buwa, ta duwa antara ŋane. Fantaufe wá, á tápá emtaŋkire, á tápá ba zlaɗa na ni an tsaka ire na am ervauŋɗe-aara. ");
INSERT INTO mfi_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Daaci a ba ŋane á elvan ge itare: «Ɓaaka zlaɗa na ni yá tapánka na am ervauŋɗe-aaruwa, yá tápá zlaɗa á emtsa. Naba njawinja áhuna, pauka háre ɗekiɗeki, sheraumishera ice ba shagera.» ");
INSERT INTO mfi_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A zlalehe ƴiƴiye cekwaaŋguɗi an itare, a de kezlaa ugje am haha, wafke-aara ba teppe áte haha, a magaa maduwa. A ba ŋane am maduwa-aara: «Eddaye-aaruwa, máki á gevge wá, tasle á ŋa jinaaja zlaɗa na ba ƴiƴiye an ya. Amá wá, áte una yá wayaná ya ka, áte una ka wayetaa ka.» ");
INSERT INTO mfi_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Daaci ba tse-aara wá, a seza pukura-aha keƴe na, amá a se berater tá am háre. A ba ŋane á elvan ge Piyer: «Dzegwakuránka njá an ice ba saa palle keni degey? ");
INSERT INTO mfi_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pauka háre! Magaumaga maduwa geni a badakuruka shaitaine. Ire á urimagwe wá, wayaawáya jipu mága fesaarfire, amá ɓaaka payɗa á vuwa.» ");
INSERT INTO mfi_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A daliye zlaɓe ádaliye ge buwire, a de magaa maduwa-aara, a ba ŋane: «Eddaye-aaruwa, mákini á taa jaaveka zlaɗa ŋanna áte ya na, sey ba yá shushe wá, a gevge ba namaari á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Eptsa-aara zlaɓe ádaliye á seza pukura-aha-aara, a se berater tá á ba am háre. Dzegwaránka ɓasha háre ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","A daliye zlaɓe ádaliye á dem tate á maduwa-aara, a de magaa ba kelaa maduwa-aara ŋanna ge keƴire. ");
INSERT INTO mfi_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Zlauzle wá, a eptsehe zlaɓe ádaliye á seza pukura-aha-aara na. A ba ŋane á elvan ge itare: «Kure kwá pá ba háre á kure, kwá aŋkwa puwansepuwe shifa á kure ka? Ay degiya, iya *Ura á emnde baɗemme, hyephye sarte-aaruwa. Kwaye tá de fime am erva ge emnde a haypa. ");
INSERT INTO mfi_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tsawetse! Kwaye samsa edda una ni a veliyaa ŋane na, mí de yainuye.» ");
INSERT INTO mfi_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ba elva ŋanna keni zlaɓe zlanaaka Yaisu wá, tá zhárá ba sesse Yahuda palle á pukura-aha kelaawa ju buwa. Emnde kwakya tá sá ɗaba Yahuda ŋanna, tá an katsákar-aha, antara zade-aha ceppe am erva. Ta ɓelateraa male-aha á *liman-aha, antara male-aha á Yahudiya-aha. ");
INSERT INTO mfi_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yahuda na a veluwa ŋane Yaisu na maa, kwaratersekwara nalaama á ŋgyekwaterá Yaisu ge dikele á emnde ŋanna. A ba ŋane á elvan ge itare: «Ba máki kwa niina yá aŋkwa gan use ge ura ni, seke aŋkwa urire á ŋere an edda-aara wá, edda una kwá tatayaná kure na ba ŋane, naba eksauváksa.» ");
INSERT INTO mfi_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ba watsewatse wá, a duhe ge Yahuda ŋanna á deza Yaisu: «Use malum», a ba ŋane á elvan ge ŋane, daaci á gan use an ervauŋɗe-aara palle agire. ");
INSERT INTO mfi_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","A ŋwanante ge Yaisu, a ba ŋane: «A gevge názena ka se maganaa ka na ura-aaruwa.» Daaci yálla á ba emnde na, erva am mbiye ge Yaisu, ta naba eksevaahe. ");
INSERT INTO mfi_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ura palle am emnde á Yaisu, a naba teɗese masalam-aara ŋane keni, a wa sleslera á male á *liman-aha, a icanaa hyema palle. ");
INSERT INTO mfi_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","«Femfa masalám á ŋa am bere-aara», a ba Yaisu á elvan ge ŋane. «Aɗaba emnde na tá teɗa masalam, itare keni watse tá keɗaterá á ba an masalám. ");
INSERT INTO mfi_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Diyaŋka ka yá dzegwándzegwa ɗaha Edderwa ge se meliyumele, ba seke ndáhámina ká zhárá ba malika-aha á wáva á tsaaka an debu kelaawa ju buwa emtu? ");
INSERT INTO mfi_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Amá watse á geva estara kena názena á ndaaná wakita á Dadaamiya na? Aɗaba áte una am wakita wá, sey á gevge ba estuwa.» ");
INSERT INTO mfi_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Daaci a ba Yaisu á elvan ge dikele á emnde ŋanna baɗemme: «Kwá se eksiyá an masalam-aha, antara zade-aha am erva na mu, ya neyle emtu? Ábi kelaazare yá njá á ba am mashidi, yá aŋkwa kwaraterse elva á Dadaamiya ge emnde, labára eksakurika? ");
INSERT INTO mfi_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amá diyaweddiye geni baɗemme á mága ŋanna wá, ba geni a gevge elva-aha na ni ta ndahanaa nabi-aha aŋkwa am wakita á Dadaamiya na.» Daaci kyaakya zhagade ge pukura-aha baɗemme, ta naba ƴánhe. ");
INSERT INTO mfi_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Daaci emnde na ta eksevaa Yaisu na, ta dan ba suuwe á dem mba á Kayafas ŋane male á *liman-aha. Mbate kerteŋ jarammeje malum-aha á *tawraita, antara male-aha á ekse katakappe am mba á male ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piyer wá, a daa ɗaba Yaisu á dehuwa, amá wá, gaterápteka ɗekiɗeki. A de demhe á ba á dem riya-aara, a de njehe am dágave á emnde a ufa mashidi, ge zhara lámare ŋanna, ma watse á zla estara keni. ");
INSERT INTO mfi_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Male-aha á *liman-aha antara emnde a *kendekyiya na baɗemme farantaufe ge tataya ba ni ma a ndarsende emnde umele elva an dzála áte Yaisu, ma ba fida keni, lauktu ma tá bá ŋanaaŋa shairiya á emtsa. ");
INSERT INTO mfi_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kwakya tsa emnde na ta de ɗatsanve fida ge Yaisu, amá ɓaaka názu ta eksanaa áte ŋane. Am iga-aara, saremsa emnde umele ta buwa wá, ");
INSERT INTO mfi_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","a ba itare: «Zhel na degi a bantsa ŋane: Yá dzegwándzegwa mbeɗánaambeɗa *mashidi á Dadaamiya ƴaikke na. Yá nderaalindere am hare keƴe, á bina.» ");
INSERT INTO mfi_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Hattse a tsete ge male á *liman-aha na, a ba ŋane á elvan ge Yaisu: «Ká ndaka elva ɗekiɗeki ka? Tá ndáhá uwe ŋane áte ka emnde na?» ");
INSERT INTO mfi_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Amá a ɗu ba we-aara Yaisu. Daaci a ba male á liman-aha na á elvan ge ŋane: «Yá ndavaku una an zhera á Dadaamiya edda á shifa, ndindaha ba jirire ba ka una ka *Almasiihu, ka *Egdza á Dadaamiya na emtu?» ");
INSERT INTO mfi_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","A ŋwanante ge Yaisu, «Ba estuwa,» a ba ŋane á elvan ge ŋane. «Amá wá, á katafke cekwaaŋguɗi watse kwá niina ya *Ura á emnde baɗemme yá njá am naɗafa á Saksage na Slekse ba ŋane na, watse kwá niina zlaɓe adaliye, má watse yá sawa áte kumba á samaya.» ");
INSERT INTO mfi_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Daaci male á liman-aha na a naba dzadzanve zane áte vuwa-aara, a ba ŋane: «A ganve ire-aara kalle an Dadaamiya.» A ba ŋane á elvan ge emnde: «Ɓaaka wedere á miya an seyde-aha mazla-aara. Ábi cenakuráncena an hyema á kure názena a ndahanaa ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Emtu estara á bá kure?», a ba ŋane á elvan ge emnde a *kendekyiya. A ba emnde: «Una ba haypa-aara, a njeka an shifa ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Daaci ta naba kyefanem nyaihe am ice, ta vavante ɗeɗekwa, emnde umele ta vavante babárva, ");
INSERT INTO mfi_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","a ba itare tá elvan ge ŋane: «*Almasiihu, diyeddiye mu a jakaa ware.» ");
INSERT INTO mfi_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Am sarte ŋanna wá, Piyer aŋkwa á njá am dagela am huɗe á riya á male á *liman-aha. Daaci a sesehe ge kwatena á male á liman-aha maa, a ba ŋane á elvan ge Piyer: «Ka keni ka ura á Yaisu zhel emnde a Galili na.» ");
INSERT INTO mfi_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Amá eksarka Piyer ɗekiɗeki, a ba ŋane á elvan ge kwatena ŋanna á katafke á emnde baɗemme: «Ma ká ndaha elva á uwe keni diyanka ya ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","A tsete ge ŋane aŋkwa á dete wakyiya, sesse kwatenaha umele daduwa á dezeŋára. Ba a puwete ice áte ŋane wá, a ba ŋane á elvan ge emnde: «Degiya una keni ba ura á Yaisu zhel emnde a Nasarátu na!» ");
INSERT INTO mfi_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piyer a naba kwaleve zlaɓe ádaliye, a ba ŋane: «Náwa waɗa-aaruwa máki diyandiya dawale ŋanna. Ba jirire diyanka dawale ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Cekwaaŋguɗi am iga á una ŋanna maa, ta gapte ge emnde na tá aŋkwa áhuwa á deza Piyer, a ba itare tá elvan ge ŋane: «Ba jirire ka keni ka ba palle-aatare, aɗaba á ba áte nara á ŋa keni diyarakdiya emnde, diyardiya tate na ka sawa átekwa na.» ");
INSERT INTO mfi_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Daaci Piyer a fantau ge za waɗa-aha, a ba ŋane: «Náwa Dadaamiya diyanka dawale ŋanna ɗekiɗeki.» Á ba am sarte ŋanna wá, tsáktsákwalikwaa, á ba tsákálá. ");
INSERT INTO mfi_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Daaci Piyer a naba yehete elva na ndza a bannaa Yaisu, a ba ŋane: Lauktu á kyuwa tsákálá wá, ká de bánba ka ser keƴe ge diyakikire na. Mazla-aara ba segáshe-aara, a de kyuwa á ba an yawe á kyuwa. ");
INSERT INTO mfi_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Weráwera ekse an eŋlya werre wá, baɗemme á male-aha á *liman-aha, antara male-aha á ekse njarantenja mazle-aara ganakini sey tá ejja shifa á Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ta naba puwete záwa áte ŋane, ta danán ge sleksu *Pilaatu, ŋane slekse ƴaikke am kwara ŋanna, a fanaa ŋgumna a Rauma. ");
INSERT INTO mfi_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yahuda na a velanaa ŋane Yaisu na nanna ganakini ŋguɗarŋguɗa Yaisu am shairiya maa, a deme am tuba, a naba sateraa shuŋgu-aatare kul keƴe na ndza ta vantaa áte Yaisu na ge male-aha á *liman-aha, antara male-aha á ekse. ");
INSERT INTO mfi_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","A ba ŋane á elvan ge itare: «Yá an haypa ba iya, aɗaba ya velu ura cuɗeɗɗe geni tá ejja shifa-aara.» A ba itare tá elvan ge ŋane: «Ázara lámbe á ŋere áte una ŋanna? Una á shá ba ka.» ");
INSERT INTO mfi_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yahuda a naba puwateranve shuŋgu am *mashidi ƴaikke, a de zleŋelaa ire-aara áte záwa. ");
INSERT INTO mfi_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Daaci male-aha á liman-aha ta halante suley na. Amá á bá itare: «An piya am *tawraita ganakini mi puwante suley na ge suley á slera á Dadaamiya, aɗaba gane á shifa á ura.» ");
INSERT INTO mfi_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Daaci ta magaa sawari am dagave-aatare, geni tá shekwevshekwe fe á slendera gahe umele an ŋane, ge heɗa wayve-aha am huɗe-aara, ta naba shekweve. ");
INSERT INTO mfi_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Aɗaba una ŋanna, sem vatena tá ɗáhá fe ŋanna an fe á uzhe. ");
INSERT INTO mfi_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Daaci gevge názena ndza a ndahanaa nabi Yairaimiya, a ba ŋane: «Halarantehálá suley kul keƴe na egdzara á *Iserayiila, ta ges gane-aara átekwa na, ");
INSERT INTO mfi_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","daaci ta shekweve fe á slendera gahe an ŋane, ba seke una a binaa Yaakadada na.» ");
INSERT INTO mfi_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tsarnaatse Yaisu á katafke á slekse ƴaikke, a ndavanuwa ŋane elva ge Yaisu, a ba ŋane á elvan ge ŋane: «Ba ka una ka slekse á Yahudiya-aha na emtu?» A ŋwanante ge Yaisu, «Ba estuwa», a ba ŋane á elvan ge ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Am iga á una ŋanna maa, male-aha á *liman-aha, antara male-aha á larde, tá aŋkwa ɗatsanve elva wá, Yaisu a naba ɗu we-aara mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Daaci a ba slekse á elvan ge ŋane: «Ká cenánka elva na tá tsakaná áte ka na emtu? Labára ká ndaaka elva?» ");
INSERT INTO mfi_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Amá Yaisu a ɗu ba we-aara, kamákamá ndahaaka elva. Haa slekse a magaa najipu kwakya. ");
INSERT INTO mfi_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ba kelaa má samsa muŋri á *Paska wá, slekse aŋkwa á ɓelaterá daŋgay palle, edda una tá kataná itare na ge emnde a ekse. ");
INSERT INTO mfi_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ay am sarte ŋanna maa, ndza aŋkwa slemandzawe umele am daŋgay, zhera-aara Yaisu Barabas. ");
INSERT INTO mfi_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Daaci á bá slekse á elvan ge jáháva: «Am dágave á tara Yaisu Barabas, antara Yaisu na tá ɗahaná an *Almasiihu na mu, kwá kátá yá ɓelakurá ware?» ");
INSERT INTO mfi_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Diyaadiya tsa ganakini ta danaa Yaisu aɗaba ba shelha ɓaaka elva umele. ");
INSERT INTO mfi_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Am sarte na sleksu *Pilaatu aŋkwa á kya shairiya á Yaisu na ma, mukse-aara a naba ɓelanvaa ura, a ba ŋane á elvan ge ŋane: «Maganánka ba uwe keni ge zhel ŋanna ɗekiɗeki, ɓaaka haypa-aara. Aɗaba vatena ya hare á ba am palasa á shene aɗaba ŋane.» ");
INSERT INTO mfi_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Amá a ba male-aha á *liman-aha, antara male á ekse tá elvan ge jáháva: «Bawánba kure geni a ɓelarakurnaaɓela ba Barabas, a jareja Yaisu.» ");
INSERT INTO mfi_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Slekse a ndavateruhe zlaɓe ádaliye, a ba ŋane á elvan ge itare: «Kwá kátá yá ɓelakurá ware am emnde buwa ŋanna?» Ta vante jawapa, á ba itare: «Ɓelaŋernaaɓela ba Barabas.» ");
INSERT INTO mfi_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","A ba ŋane á elvan ge itare: «Yá maganá uwe ge Yaisu na tá ɗahaná an Almasiihu na?» Baɗemme-aatare ta ŋwanante, a ba itare tá elvan ge ŋane: «Zleŋelezleŋela áte dzaŋgala!» ");
INSERT INTO mfi_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","A ba sleksu Pilaatu á elvan ge itare: «A gu uwe estuwa?» Amá itare ta far hula á ba an ndzeɗa, a ba itare: «Zleŋelezleŋela áte dzaŋgala!» ");
INSERT INTO mfi_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Am nanna sleksu Pilaatu ɓaaka názu á maganá ŋane, emnde tá far ba hula maa, a kevaa yawe, a baraa erva-aara á katafke á emnde, a ba ŋane á elvan ge itare: «Shifa á zhel na kwá de jáná kure na, haypa-aara á shika ɗekiɗeki, á shá ba kure.» ");
INSERT INTO mfi_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Baɗemme á jáháva a ŋwanante, a ba itare tá elvan ge ŋane: «Una á shakaaka, haypa á ja shifa á zhel na á ba am mbiye á ŋere antara egdzara á ŋere.» ");
INSERT INTO mfi_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Daaci sleksu Pilaatu a naba ɓelateraa Barabas, amá Yaisu wá, ta zu an ja, lauktu ta de zleŋelaná áte dzaŋgala. ");
INSERT INTO mfi_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Daaci ta naba danhe ge sawji-aha á sleksu *Pilaatu Yaisu na á dem huɗe á há á slekse, ta de jamme ge sawji-aha baɗemme, tá á ba arge ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ta naba tsekwanse am naŋgyuwe-aara, ta tsekwanme am dira haŋŋe. ");
INSERT INTO mfi_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Am iga á una ŋanna maa, ta nderse dake, ta faɗanse ire an ŋane ágire *ɗaŋkaula, ta fanem zade am naɗafa-aara. Mazla-aara ta gyanu rume ágire tá epsawupsawa, a ba itare tá elvan ge ŋane: «Aska á ŋa, slekse á Yahudiya-aha!» ");
INSERT INTO mfi_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ta naba kyefanem nyaihe am ice. Ta lyevaa zade na am erva-aara, geni tá jáná an ŋane am ire. ");
INSERT INTO mfi_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Zlaruzle am maganaa palasa, ta tsekwanse am dira haŋŋe na, ta tsekwanme am náza-aara, lauktu ta dáná á dem tate na ta zleŋelanaa áte dzaŋgala. ");
INSERT INTO mfi_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Am sarte na daransede, ta de jaa ire antara ura Siraine umele zhera-aara Simaun, ta naba hyarhe ganakini á sepá dzaŋgala á Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Daraada am tate ŋanna tá ɗaháná an Gaulgauta na, amaana: Tate á feka á ire maa, ");
INSERT INTO mfi_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ta de fanu mbazla ge Yaisu áhuwa. Mbazla ŋanna keni aŋkwa duksa ƴaiƴaihe am huɗe-aara. Amá ba a tapanaahe ge Yaisu mbazla na wá, a naba kwalve, shaaka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Daaci ta naba tsakwanse am kazlaŋa-aara, ta zleŋelehe áte dzaŋgala, ta tegaa kazlaŋa-aara am dagave-aatare. Ge tega kazlaŋa-aara na wá, ta maga njeri am dagave-aatare, ganakini a sesse edda una ni á zaná ŋane ma uwe keni. ");
INSERT INTO mfi_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Daaci ta njehe á ba áhuwa ŋanna ge ufufa-aara. ");
INSERT INTO mfi_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ta puwete názena ta bantsa itare tá jáná aɗaba ŋane na áte naláwa, ta fetehe átire ge ŋane. Náwa názena ni ta puwetaa itare: «Ba ŋane una Yaisu, slekse á Yahudiya-aha.» ");
INSERT INTO mfi_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tá aŋkwa neyle-aha buwa ta zleŋelater átirpalle antara Yaisu áte dzaŋgala-aha-aatare. Palle ta zleŋelanaa am naɗafa, palle keni am názlaɓa. ");
INSERT INTO mfi_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Emnde a degáshe am tate ŋanna tá geja ba ire, tá ámbera ezzlazle. ");
INSERT INTO mfi_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","A ba itare tá elvan ge ŋane: «Ábi ka bántsa ka ká naba mbeɗanaambeɗa *mashidi ƴaikke na, á ba am hare keƴe ká nderendere umele á ba ka? Labara ká taa ŋezlanaaka ba ka ire á ŋa? Máki ka ba *Egdza á Dadaamiya, tsekwanaatsekwa kwa ire á ŋa áte dzaŋgala na!» ");
INSERT INTO mfi_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Male-aha á *liman-aha, antara malum-aha á *tawraita, ira male-aha á ekse baɗemme ta fantau ge epsawa Yaisu. Ta bántsa itare wá: ");
INSERT INTO mfi_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Iyau, á dzegwándzegwa ŋezla emnde umele, ire-aara wá, á taa ŋezlanaaka! Ábi ŋane slekse á Iserayiila-aha? A tsekwanaatsekwa kwa ire-aara áte dzaŋgala na? Máki tsekwaatsekwa wá, baɗemme mi fetarfe áte ŋane. ");
INSERT INTO mfi_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A bántsa ŋane a fetaare an Dadaamiya, ŋane *Egdza á Dadaamiya, mi ezzhara kwa kina má watse á sawa Dadaamiya ŋanna á se melanumele!» ");
INSERT INTO mfi_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Neyle-aha buwa na ta zleŋelaterhe áte dzaŋgala antara Yaisu na, itare keni ta zlazlese Yaisu ba seke male-aha ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Daaci a tsekwaa ge tabeɗammire an vacitire am huɗe á duniya baɗemme, dem lásar emnde ta á ba am tabeɗammire ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Á maga saa keƴe wá, Yaisu a ketaa kwárá á ba an ndzeɗa: «Aili! Aili! Laima sabaktani?» Amaana wá: «Dadaamiya-aaruwa labára ƴakiyaaƴa? Dadaamiya-aaruwa labára ƴakiyaaƴa?» ");
INSERT INTO mfi_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Á bá emnde umele am emnde na tá aŋkwa á tsaatse áhuwa: «Zhel na degiya á ɗaha nabi *Ailiya.» ");
INSERT INTO mfi_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Palle-aatare a teɗante zhagade, a de eksetaa sausau, a ŋguɗetaa áte zade, a femhe am mbazla umele ɗaŋɗaŋe ba estuwa, daaci a kante, a fante áte we ge Yaisu geni a shushe. ");
INSERT INTO mfi_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Amá a ba emnde umele-aatare: «Tsawaatse emtsaaɗe, mi ezzhara má watse á semsa Ailiya ŋanna á se melanumele.» ");
INSERT INTO mfi_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yaisu a fu hula zlaɓe ádaliye, mazla-aara a naba zlu ge shifa-aara. ");
INSERT INTO mfi_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Am sarte ŋanna maa, aŋkwa kacekaca á dzegwa am *mashidi ƴaikke wá, a naba tamme kalkale, a fantau á sawa átire sem áhá. Haha keni aŋkwa á gajava, palaha-aha tateptate ba ɓaley ɓaleye. ");
INSERT INTO mfi_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Irekhya-aha keni kerteŋ tá an wara, emnde á Dadaamiya na ndza matsarematsa na kwakya tsaretse am faya. ");
INSERT INTO mfi_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Emnde na ta tsetaa am faya ŋanna wá, am sarte na tsetsa Yaisu am faya na, daremda á dem berni cuɗeɗɗe, emnde kwakya naráterna. ");
INSERT INTO mfi_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sawji-aha na a sáteraa ŋgumna a Rauma, antara male-aatare baɗemme tá aŋkwa ufa Yaisu na. Ba ta naa gejava á haha antara názena magaavemaga baɗemme na wá, dámdá lyawa am itare jipu. A ba itare: «Zhel na egdza á Dadaamiya ba jire.» ");
INSERT INTO mfi_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tá aŋkwa ŋwasha keni kwakya am tate ŋanna. Ta tsaahe ƴiƴiye, ta zhara názena ni aŋkwa á magava na. Ŋwasha ŋanna kwaye ta saa á ɗaba Yaisu á sawa am kwara á Galili ge maganaa slera. ");
INSERT INTO mfi_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tá aŋkwa tara Maari mukse á emnde a Magdala, antara Maari emmetare ge tara Yakuba an Yusufa, ira emmarge egdzara á Jaibaidaiyus, am dagave á ŋwasha ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Herzhe watse á belya vaciya wá, a naba semhe ge sleberba umele ura á ekse á Arimatiya zhera-aara Yusufa. Ŋane keni fetarfe áte Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A duhe ge Yusufa ŋanna á deza sleksu *Pilaatu, a de ndavanu baráma á eksa emtsa á Yaisu. Daaci a ba slekse a varanteva. ");
INSERT INTO mfi_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Duwa á Yusufa, a eksante emtsa na, a de faɗeme am kalpakane aŋwaslire tseɗaŋŋe, jeba á kalpakane ŋanna ba lefeɗɗe. ");
INSERT INTO mfi_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Daaci a de zlavanaahe am irekhya-aara halál na a yese am cacera, zlaɓe ba uŋŋule á zlauzle-aara ge yá irekhya ŋanna. Daaci a berhanu palame ƴaikke ge we á irekhya ŋanna, lauktu a zlala. ");
INSERT INTO mfi_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Amá tara Maari mukse á emnde a Magdala, antara Maari umele na wá, itare zlalarka, ta naba njehe, wafke-aatare ba ndaŋŋe á deza irekhya na. ");
INSERT INTO mfi_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Makuralla-aara, amaana kwaskwe á puwansepuwe wá, ta naba tsetehe ge male-aha á *liman-aha antara *Farisa-aha ta deza sleksu *Pilaatu. ");
INSERT INTO mfi_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","A ba itare tá elvan ge ŋane: «Ambarka á ŋa, yehaŋerteyeha názena a ndahanaa slefida ŋanna am sarte na zlaɓe an shifa. A bantsa ŋane, watse á tsetse am faya am hare-aara ge keƴire am evege. ");
INSERT INTO mfi_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ambane ká ɓela emnde tá de ufa irekhya-aara am hare keƴe ŋanna. A de teɗarseka pukura-aha-aara, daaci watse tá baterán ge emnde geni tsetse am faya. Daaci fidire-aatare ŋanna á de jauje ge una werre.» ");
INSERT INTO mfi_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","A ba edda á hákuma á elvan ge itare: «Kwaye sawji-aha ŋanna, dawmbare, de magaumága názena kwa dzegwanaa kure ge ufufa-aara.» ");
INSERT INTO mfi_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Daaci ba zlálá-aatare, ta de vanyaa we á irekhya ba shagera, ta fafete damshe á ŋgumna, ta ɓazlaa sawji-aha ge ufufa-aara. ");
INSERT INTO mfi_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Dedde kwaskwe á puwansepuwe, an eŋlya werre ge laade wá, daremda tara Maari mukse á emnde a Magdala, antara Maari umele na ta de zhara irekhya na. ");
INSERT INTO mfi_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ba watsewatse shekwaraaka ɗekiɗeki wá, baɗemme á haha á gyagya á ba an ndzeɗa, a tsekwaa ge malika á Yaakadada á sawa am samaya, a berhanvuwe palame na ge we á irekhya maa, a njetaa átekwa. ");
INSERT INTO mfi_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Malika na á mbá wulwulire ba seke kárá á ráde. Naŋgyuwe-aara dzayye telle jauje ba ge sluzhe keni. ");
INSERT INTO mfi_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Naranna emnde a ufa irekhya na wá, ba gyaagya keni tá gyagyeteka mazla-aara ge lyawa, garevge ba seke ɓaaka shifa am itare ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Amá ŋwasha na wá, a ba malika ŋanna á elvan ge itare: «A wakurka lyawa ɗekiɗeki, aɗaba diyandiya kwa se tataya Yaisu na ta zleŋelaa áte dzaŋgala na. ");
INSERT INTO mfi_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Amá ŋane ɓaaka áhuna mazla-aara, tsetse am faya ba seke una ndza a enndaha na. Sawmbare nawanaana tate na ndza á zlava átekwa. ");
INSERT INTO mfi_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kina wá, dawmbare ba watsewatse, de mbeɗawaterumbeɗe labare ge pukura-aha geni ɓaaka, tsetse. Baira watse á daada ba ŋane zuŋŋwe arge kure á dem Galili. Kwá de nanaana áhuwa. Una ya bakurnaa ba iya.» ");
INSERT INTO mfi_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Daaci ba zlálá-aatare ge ŋwasha na áte we á irekhya, ta zlálaa á ba á zhagade ge daterá labare na ge pukura-aha á Yaisu. Tá zlálá na wá, ervauŋɗe-aatare ba seke nama, an wesha an lyawa zlaɓe ádaliye. ");
INSERT INTO mfi_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Cekwaaŋguɗi wá, Yaisu a se yaiterwa á ba an ye ge ŋwasha na: «A vakurteva Dadaamiya hairire», á bá ŋane á elvan ge itare. Zhagade ge ŋwasha na ádezeŋara, ta kezlan ugje, ta ŋante sera, tá aŋkwa á eggala. ");
INSERT INTO mfi_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","A ba Yaisu á elvan ge itare: «A wakurka lyawa ɗekiɗeki. De bawateranba ge egdzar mama-aha-aaruwa, a darduwa á dem Galili, tá de niina áhuwa.» ");
INSERT INTO mfi_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Zlaɓe tá á ba átira zlala emtsaaɗe ŋwasha na wá, sawji-aha á ufa irekhya na keni, emnde umele-aatare zlarzlala á dem huɗe á ekse, ta de mbeɗateru labare ge male-aha á *liman-aha. ");
INSERT INTO mfi_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Male-aha á liman-aha ta magaa sawari am dagave-aatare antara male-aha á ekse maa, ta vaterte shuŋgu camballe ge sawji-aha na. ");
INSERT INTO mfi_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","A ba itare ta elvan ge itare: «Bawanba geni tá se teɗesaa ba pukura-aha-aara an vaƴiya am sarte na ŋere ŋá am hare. ");
INSERT INTO mfi_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma a cenanaa ba edda á hákuma keni, diyaŋerdiya ŋere názena ni ŋá de ndahaná ŋere, ba názara keni á shakuraaka ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Daaci sawji-aha ta naba lyevaa shuŋgu na, ta maganaa áte una ni ta ndaaterndaa na. Ta naba hyanme fida ŋanna am dagave á Yahudiya-aha baɗemme, sem vatena ta tsaa á ba áte una itare. ");
INSERT INTO mfi_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Daaci zlarzlala pukura-aha kelaawa jemtekwe kereɗɗe á dem Galili, ta deba áte egdza wa na ndza a baternaa Yaisu na. ");
INSERT INTO mfi_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ba ta puwete ice áte ŋane, ta kezlan ugje, tá aŋkwa á eggala. Amá emnde umele-aatare ta magaa shaige ganakini ŋane ka. ");
INSERT INTO mfi_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Samsa Yaisu á sezetare ba herezhzhe, a ba ŋane á elvan ge itare: «Baɗemme á hákuma ta fimaa á ba am erva-aaruwa, ma am samaya, ma am duniya keni. ");
INSERT INTO mfi_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Daaci naba dawmbare ma á dem larde-ara keni baɗemme, ma emnde-ara keni gawatervege emnde-aaruwa, mágawateránmaga baptisma an zhera á Edderwa, an zhera á Egdza-aara, an zhera á Sheɗekwe Cuɗeɗɗe. ");
INSERT INTO mfi_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kwarawatersekware maga fesarfire am názena ya fakuraara ya baɗemme. Diyaweddiye ganakini iya antara kure wá, yá aŋkwa antara kure ma vaatara keni, dem halavuwa á duniya.»");
INSERT INTO mfi_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Náwa a fantuwa estuwa labare á higa, elva a Yaisu *Almasiihu *Egdza á Dadaamiya: ");
INSERT INTO mfi_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Aŋkwa an puwa am wakita á nabi Aisaya, a ba Dadaamiya: «Náwa yá ɓela sleɓela-aaruwa á katafke á ŋa, á tsatsakaná ŋane baráma. ");
INSERT INTO mfi_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Zlaɓe ádaliye a ba ŋane: Aŋkwa ura á ɓálá elva am kaamba, a ba edda-aara: Tsatsawanaatsatse uŋŋule ge Yaakadada, tsawanaatse baráma-aara a gevge ba ndeɗɗe.» ");
INSERT INTO mfi_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Am iga a una ŋanna maa, a naba semhe ge Yuhanna slemaga baptisma á sem kaamba, ba seke una a ndaana nabi ŋanna, a fantau ge ɓalaterá waazu ge emnde, a ba ŋane á elvan ge itare: «Magaumága tuba, lyauvaalya baptisma, á ƴakuraarƴe Dadaamiya haypa-aha á kure.» ");
INSERT INTO mfi_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Daaci saresse emnde a Urusaliima ba kwakya, antara emnde na tá am kwárá á Yahudiya gergere baɗemme, ta seza Yuhanna ge cena waazu-aara, daaci ta naba sanse haypa-aha-aatare, ŋane keni maa, a magateraa baptisma am guwa á Urdun. ");
INSERT INTO mfi_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Naŋgyuwe na a tsekwanaa Yuhanna wá, ta hanaa am úgje á ezlegwame, ndza á ŋguɗa ba gwagwa. Náza za-aara keni maa, á za ba iwe, antara nama. ");
INSERT INTO mfi_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","A baa ŋane am waazu-aara: «Aŋkwa á sawa ura am iga-aaruwa wá, edda-aara ŋanna an hakuma ba ŋane arge iya, ba ge saɗanse kimake am sera keni hyanefka ya ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Iya, yá aŋkwa á magakurá baptisma an yawe, amá ŋane wá, á se magakurá baptisma an Sheɗekwe Cuɗeɗɗe.» ");
INSERT INTO mfi_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Á ba am hare-aha ŋanna maa, a naba semhe ge Yaisu á sa am Nasarátu am kwárá á Galili, Yuhanna a se baranve am guwa á Urdun. ");
INSERT INTO mfi_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Am sarte na sessa Yaisu am yawe, a naa wertehe ge samaya, aŋkwa á tsekwa Sheɗekwe Cuɗeɗɗe á setarge ŋane ba seke takala. ");
INSERT INTO mfi_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Cekwaaŋguɗi wá, tá cená ba ye á sawa am samaya ŋanna, a ba edda-aara á elvan ge ŋane: «Ba ekka una ka Egdza-aaruwa wayanak-wáyá jipu, baɗemme a higa-aaruwa á ba áte ka.» ");
INSERT INTO mfi_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Cekwaaŋguɗi am iga á una ŋanna wá, Sheɗekwe á Dadaamiya á naba daa Yaisu á dem kaamba. ");
INSERT INTO mfi_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Hare kul ufaɗe á njá á ba am dagave á dabba-aha am kaamba, a de badanaa Shaitaine am hare kul ufaɗe ŋanna. Ta magannaa ba malika-aha slera am kaamba ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ŋguɗarŋguɗa Yuhanna am daŋgay maa, am iga-aara daduwa Yaisu keni á dem kwárá á Galili, a de fantau ge ɓalaterá labáre á higa na ni a ɓelanaa Dadaamiya ge emnde. ");
INSERT INTO mfi_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","A ba ŋane á elvan ge itare: «Kina wá, hyefhye sarte na ni a tsanaa Dadaamiya, samsa sarte á nja am kwárá-aara, magaumága tuba, lyauvalya labáre á higa.» ");
INSERT INTO mfi_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","A gapte ge Yaisu cekwaaŋguɗi a ɗába we á haye á Galili wá, a naa egdzar mama buwa, tara Simaun, tá an egdza emmeŋara Andere. Tá aŋkwa á puwa narre-aatare á dem yawe aɗaba itare ta emnde a sluwa kelfe. ");
INSERT INTO mfi_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Daaci a naba ɗaterɗáhá Yaisu: «Sawmbare ɗabawiɗába, yá gakurvege emnde a jaha emnde á sem sera-aaruwa, ba seke una ni má tá jahava kelfe-aha á dem narre na,» a ba ŋane á elvan ge itare. ");
INSERT INTO mfi_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ba watsewatse, ta naba puwanve narre-aatare á ba áhuwa ŋanna, ta ɗába Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ta gapte ba cekwaaŋguɗi á de katafke wá, Yaisu a naa egdzara á Jaibaidaiyus, tara Yakuba tá an egdza emmeŋara Yuhanna tá am paare á yawe, tá aŋkwa á tsatsa narre-aatare. ");
INSERT INTO mfi_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Daaci a naba ɗaterɗáha Yaisu itare keni, ta naba ƴaa eddetare Jaibaidaiyus am paare áhuwa antara emnde a slera-aara, itare ta ɗába Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Am iga á una ŋanna maa, Yaisu antara pukura-aha-aara ŋanna ta zlala á dem huɗe á Kafarnahum. Samsa kwaskwe á puwansepuwe a naba dem *mashidi á Yahudiya-aha, a de kwaraterse elva á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Itare ta mága ba najipu-aara, aɗaba ŋane kwaraterseka seke náza á malum-aha á *tawraita, amá edda á elva ŋanna ba ŋane, á kwaraterse á ba an hákuma. ");
INSERT INTO mfi_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Vacite ŋanna maa, ndza aŋkwa ura an shaitaine am vuwa-aara am jáháva-aatare, ");
INSERT INTO mfi_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","a naba fu hula zhel ŋanna, a ba ŋane a elvan ge Yaisu am hula-aara: «Ekka Yaisu ura Nasarátu na mu, ká kátá uwe ka ázeŋere? Niya á ŋa ka se keɗaŋerkeɗa emtu? Iya diyanakdiya ganakini ka Ura Cuɗeɗɗe na ɓelakaa Dadaamiya na.» ");
INSERT INTO mfi_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yaisu a naba valarhe ge shaitaine ŋanna, a ba ŋane á elvan ge ŋane: «Ɗuɗe we á ŋa, sesse am zhel na ba kina!» ");
INSERT INTO mfi_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Daaci a naba slakalapte ge shaitaine am zhel na, a fu hula an ndzeɗa-aara baɗemme, a sesehe am ŋane. ");
INSERT INTO mfi_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Baɗemme á emnde tá maga ba najipu-aara. A ba itare am dágave-aatare: «Ázara kena jeba una? Ba vaci palle keni cenaŋeránka jeba á tsaha na, naŋeránka keni jeba á hákuma na ni, ura ba a ndanse elva ge shaitaine am ura ni, a naba sesehe!» ");
INSERT INTO mfi_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kerteŋ hyaranmehye labare á Yaisu am kwárá á Galili baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ba segashe-aatare am mashidi wá, Yaisu a ɗaba tara Simaun antara Andere á dem mba-aatare, ta ɗabaterɗába tara Yakuba antara Yuhanna keni á dehuwa. ");
INSERT INTO mfi_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Duwa-aatare maa, ta de beraa shawle á Piyer mukse, á ba á zlava, á wáná zlagzlagi. Daaci ba demda á Yaisu, ta naba mbeɗanuhe. ");
INSERT INTO mfi_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","A duhe ge Yaisu á dezeŋara, a de ŋanaa ba erva, a tsantehe, a naba mbehe, a fantau ge magateraa kashi. ");
INSERT INTO mfi_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Eblyabelya vaciya, herzha máŋgaripu maa, emnde ta saa emnde-aha-aatare na lapika vuwa-aatare, antara emnde na tá an shaitaine na baɗemme áseza Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Baɗemme á emnde a huɗe á ekse saresse, ta se jamme áte we á wakyiya ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yaisu a mbateraahe emnde kwakya am lapikere-aha-aatare gergere, a ŋgyanse shaitaine-aha kwakya am emnde. Vaterteka baráma ɗekiɗeki ge shaitaine-aha ŋanna ge ndaase elva, aɗaba itare diyardiya Yaisu ma ware ŋane keni. ");
INSERT INTO mfi_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mákurálla-aara wá, a sesehe ge Yaisu á ba an ireŋlya, a zlalehe á dem kaamba ƴiƴiye an ekse ba shagera, a de maga maduwa áhuwa. ");
INSERT INTO mfi_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Daaci ta naba ɗabemhe ge tara Simaun antara emnde na ni tá ba kerɗe, ta de tataya tate na átekwa. ");
INSERT INTO mfi_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","De sharánsha maa, a ba itare tá elvan ge ŋane: «Degiya emnde baɗemme tá aŋkwa á tatayaktátaya jipu!» ");
INSERT INTO mfi_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Amá a ŋwaterante, a ba ŋane á elvan ge itare: «Mi zlálawa á miya á dem ekse-aha na herherzhe, yá de magaterá waazu ge emnde a ekse-aha ŋanna keni, aɗaba a siyaa ba una ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mázla-aara ba zlálá-aatare, ta fantau ge já ɗaba am kwárá á Galili baɗemme, aŋkwa á magaterá waazu ge Yahudiya-aha am mashidi-aha-aatare, aŋkwa á ŋgya shaitaine-aha keni am vuwa á emnde. ");
INSERT INTO mfi_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","A semhe ge slederve umele, a se kezlaa ugje á katafke-aara, a fantau ge ŋala ázeŋara, a ba ŋane á elvan ge ŋane: «Má wayak-waya wá, ká dzegwándzegwa givege ba meteɗɗe vuwa-aaruwa.» ");
INSERT INTO mfi_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Daaci Yaisu a naba zanvaarhe, a pelse erva-aara, a de fete áte ŋane, a ba ŋane á elvan ge ŋane: «Wayanwáyá ká mbembe, ba meteɗɗe vuwa á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ba seke ndaha á miya na, a naba mbehe ge slederve ŋanna meteɗɗe. ");
INSERT INTO mfi_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Amá lauktu á ɓelanaaɓela wá, a teɗanánte hyema ba shagera, ");
INSERT INTO mfi_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","a ba ŋane á elvan ge ŋane: «Ɓalananseka ma ge ware keni ɗekiɗeki. Názena ká de maganaaka wá, de maranánmárá ire á ŋa ge *liman, vanteva sadake á ŋa ge Dadaamiya áte una a ndanaa Muusa ge seydire á ŋa á katafke á emnde baɗemme ganakini mbakmbe.» ");
INSERT INTO mfi_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Amá ŋane, ba zlala-aara wá, a de ɓalse labare ŋanna áza emnde baɗemme. Aɗaba una ŋanna Yaisu dzegwánka marse ire-aara áza emnde mazla-aara, sey á njá á ba am kaamba ƴiƴiye an ekse, tá duwa ba emnde ádezeŋara, á sawa am tate-aha gergere. ");
INSERT INTO mfi_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Haraahare cekwaaŋguɗi wá, a naba eptsehe ge Yaisu, á sem huɗe á Kafarnahum, cenarancena emnde ganakini saasa, aŋkwa am mba. ");
INSERT INTO mfi_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Daaci kwakya nalga a se jamme am huɗe á ha ŋanna, sete we á wakyiya keni ɓaaka sleɗe ɗekiɗeki ge kwakyire á emnde. Daaci Yaisu a fantau ge ndater elva á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Á ba am sarte ŋanna maa, ta semhe ge emnde umele, ta sanaa ura an matsa uɓiya-aara, ta saa sepanaa emnde ufaɗe am dagave-aatare. ");
INSERT INTO mfi_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Amá dzegwaránka dáná á de katafke á Yaisu aɗaba kwakyire á nalga. Daaci ta naba ɗalte áte ire á dzuguru, ta naba weraa ire á dzuguru ŋanna am ndaŋŋire á tate na ni átekwa Yaisu, ta velem zhel na antara egdera-aara baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nánna Yaisu fetarfire á emnde ŋanna maa, a ba ŋane á elvan ge edda una lapika na: «An bárá haypa-aha á ŋa baɗemme egdza-aaruwa.» ");
INSERT INTO mfi_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Áy, tá aŋkwa malum-aha á *tawraita umele á njanja am tate ŋanna. Malum-aha ŋanna ta fantau ge dzamanaa am ervauŋɗe-aatare, a ba itare: ");
INSERT INTO mfi_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Kwaye zhel na aŋkwa á lyiya sleɗe á Dadaamiya. Ware edda una á dzegwándzegwa ƴanár haypa ge ura máki Dadaamiya ka palle?» ");
INSERT INTO mfi_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kerteŋ a naba diyeddiya Yaisu názena tá aŋkwa á dzamaná itare, a ba ŋane á elvan ge itare: «Labára kwa dzamete una am ervauŋɗe á kure? ");
INSERT INTO mfi_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ázara una tsaftsafe jauje ge banán ge edda una lapika vuwa-aara: An bárá haypa-aha á ŋa, bi baná: Tsettse, eksanteksa egdera á ŋa, ezzlala an sera á ŋa? ");
INSERT INTO mfi_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Iya wá, yá kátá kwá diyeddiye geni iya *Ura á emnde baɗemme yá an hákuma ge ƴateraare haypa ge emnde am duniya na.» Daaci a ba ŋane á elvan ge edda una an matsa uɓiya-aara na: ");
INSERT INTO mfi_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Ya ndaa ba ekka, tsettse, eksanteksa egdera á ŋa, ezzlala á da.» ");
INSERT INTO mfi_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kerteŋ tsettse zhele na á katafke-aatare baɗemme, a eksante egdera-aara, a naba zlálá. Baɗemmire-aatare tá maga ba najipu-aara, a ba itare: «Ba ser palle keni ndza naŋeránka jeba á una ɗekiɗeki.» Daaci ta fantau ge gala Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yaisu a naba eptsa ádaliye ádete we á haye á Galili. Kwakya nalga ta duhe ádezeŋara, daaci a fantau ge ndater elva á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Am iga á tsetse-aara áhuwa, a naa egdza á Halfa á njá am bere á hadáma, zhera-aara Laiwi, a ba ŋane á elvan ge ŋane: «Tsettse, sawa, ɗabiɗába.» A naba tsa Laiwi, a ɗába Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Am iga-aara maa, tara Yaisu tá aŋkwa za ɗafa antara pukura-aha-aara am mba á Laiwi ŋanna, ta naba záná átirpalle antara *emnde a jaha hadáma ira emnde a haypa umele, aɗaba kwakya jeba á emnde ŋanna ta daa ɗaba Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tá aŋkwa *Farisa-aha umele, ta malum-aha á *tawraita, ta naa Yaisu aŋkwa za ɗafa antara emnde a jaha hadáma ira emnde a maga haypa gergere. A ba itare tá elvan ge pukura-aha-aara: «Labára á za ɗafa antara jeba á emnde ŋanna?» ");
INSERT INTO mfi_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","De cenatercena Yaisu, a ba ŋane á elvan ge itare: «Emnde na lapiya vuwa-aatare wá, ɓaaka wedere-aatare áza dauktar, sey ba emnde na lapika vuwa-aatare una tá deza dauktar. Daaci ba duksa palle ge iya keni. Sanka ya á se tataya emnde na tá am jirire, ya se tataya ba emnde a haypa.» ");
INSERT INTO mfi_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Vacite umele maa, pukura-aha á Yuhanna antara *Farisa-aha tá aŋkwa tsufá ndera, amá pukura-aha á Yaisu tsufarka. Daaci ta naba duhe ge emnde umele, ta ndavanu ge Yaisu, a ba itare tá elvan ge ŋane: «Labára pukura-aha á ŋa tá ekseka ndera?» ");
INSERT INTO mfi_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Daaci a ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Emnde na tá ɗahaterá á sem larusa keni, kwa kurken tá dzegwándzegwa tsufa ndera emtu, am sarte na tá áza zhele á larusa? Am sarte na ni aŋkwa zhele á larusa am dagave-aatare wá, tá dzegwánka tsufa ndera ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Amá aŋkwa á sawa sarte umele wá, watse tá pakyava antara zhele á larusa. Am sarte ŋanna wá, itare keni, watse tá tsufá ndera. ");
INSERT INTO mfi_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Ɓaaka ura a venya emgyegwe a naŋgyuwe an baukta áŋwaslire, aɗaba máki á venyaná an una áŋwaslire, una áŋwaslire na á teɗa emgyegwe a naŋgyuwe na, daaci á farfe te-aara. ");
INSERT INTO mfi_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","«Zlaɓe ádaliye, tá puweka mbazla áŋwaslire á dem emgyegwe a *kanyakanya-aha. Aɗaba máki tsetse mbazla, á tatanvetate kanyakanya-aha na. Daaci á puwa mbazla á dem haha, kanyakanya keni badzafbadze. Daaci máki mbazla áŋwaslire wá, sey tá puwaná á dem kanyakanya-aha na áŋwaslire.» ");
INSERT INTO mfi_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Vacite umele an kwaskwe á puwansepuwe, a degashe Yaisu antara pukura-aha-aara praatte am dágave á fe-aha á hiya maa, pukura-aha-aara ta naba fantau ge kázla ire á hiya na. ");
INSERT INTO mfi_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","A ba *Farisa-aha tá elvan ge Yaisu: «Labára pukura-aha á ŋa tá maga duksa na an piya vaci puwansepuwe?» ");
INSERT INTO mfi_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","A naba ŋwaterantehe ge Yaisu, a ba ŋane á elvan ge itare: «Ekkure ndaakurseka názu ndza a maganaa *Dawuda am sarte na irice-aara antara emnde-aara baɗemme ŋateraaŋa waya, tá an wedere á náza za ba jipu na emtu? ");
INSERT INTO mfi_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Duwa-aatare á dem mashidi wá, Dawuda ŋanna a naba eksante tapiske na ta fan ge slera á Dadaamiya na, ta naba zuhe antara emnde-aara. Amá shairiya á Dadaamiya wá, a vaterte barama ba ge *liman-aha palle za tapiske ŋanna. A mágava una ŋanna am zamane á Abiyatar ŋane male á liman-aha.» ");
INSERT INTO mfi_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","A ba Yaisu á elvan ge itare zlaɓe ádaliye: «Á maganá ba kwaskwe á puwansepuwe nampire ge urimagwe. Urimagweka una á maganá nampire ge kwaskwe á puwansepuwe. ");
INSERT INTO mfi_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Daaci ba *Ura á emnde baɗemme una edda á vaci puwansepuwe.» ");
INSERT INTO mfi_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Vacite umele maa, Yaisu a daliye zlaɓe ádaliye á dem mashidi, a de bera ura an emtsa erva-aara vacite ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Am mashidi ŋanna maa, tá aŋkwa emnde na tá tsagwaɗa ba Yaisu, ta fantau ge zhárá Yaisu an eŋkale-aatare baɗemme, má watse á mbanaambe ura an kwaskwe á puwansepuwe, lauktu ma tá puwar elva aɗaba una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Amá Yaisu a naba banán ge zhele na an emtsa erva-aara na: «Naba tsettse, tsaatse á katafke á emnde baɗemme.» ");
INSERT INTO mfi_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Daaci a naba ndavateru ge emnde baɗemme, a ba ŋane á elvan ge itare: «A vamite baráma á mága uwe *tawraita an kwaskwe á puwansepuwe? Mága maggwire emtu, mandzawire he? Lya ura emtu, keɗa ura he?» Ta naba heɗu we-aatare ŋwarka. ");
INSERT INTO mfi_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jaaja ervauŋɗe á Yaisu, a zharateraahe, degdegire á ire á emnde ŋanna wantewa jipu. Daaci a ba ŋane á elvan ge zhele na: «Pelansepele erva á ŋa.» A naba pelanse, erva-aara gevge ba laŋŋe ba seke erva-aara werre. ");
INSERT INTO mfi_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mazla-aara ba zlálá á degashe ge *Farisa-aha, ta de magaa sawari-aatare antara emnde á *Hirudus, geni tá maganá estara, lauktu tá keɗanaakeɗa shifa á Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Daaci ba zlálá ge Yaisu antara pukura-aha-aara á dete we á haye á Galili. Kwakya nalga na ta ɗabanaa ádehuwa. Emnde ŋanna ta segashe am kwara á Galili, emnde umele ta sawa á sa am huɗe á Urusaliima, ");
INSERT INTO mfi_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","antara am kwara á Yahudiya baɗemme, antara á sa am kwara á Idumaya, antara á sa á katafke á guwa á Urdun, ira á sa am kwara á Tirus antara Sidaun. Emnde ŋanna baɗemme ta se á ba áza Yaisu aɗaba cenaráncena labare-aara. ");
INSERT INTO mfi_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Daaci a ba Yaisu á elvan ge pukura-aha-aara, tatayauwivaatataya egdza paare á yawe, geni a ɓecariteka emnde. ");
INSERT INTO mfi_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Aɗaba ŋane slemba emnde, daaci emnde na lapika vuwa-aatare na kwakya ta berdavuwa ásezeŋara, geni tá fetefa erva-aatare áte ŋane. ");
INSERT INTO mfi_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Emnde na tá an shaitaine, ba ta puwete ice-aatare áte ŋane maa, reppe ta naba mbeɗa am sera-aara, ta ámbera hula, a ba itare am hula-aatare: «Ba ekka una ka *Egdza á Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Amá a naba valaterarhe ge Yaisu á ba an ndzeɗa geni a ndaharka elva áte ŋane ɗekiɗeki, ma ware ŋane keni. ");
INSERT INTO mfi_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Am iga á una ŋanna maa, Yaisu a ɗetaa emnde na a wayateraa ŋane, ta ɗála emnde ŋanna antara ŋane áte egdza wa. ");
INSERT INTO mfi_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ate wa ŋanna maa, a de dzerese emnde kelaawa ju buwa am itare, a ɗaateraa an emnde a ɓela. A dzeraterse ganakini tá nja antara ŋane ba kelaazare, á ɓelaterá á de ɓalaterá labare á higa ge emnde. ");
INSERT INTO mfi_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Daaci a vaterte hákuma á ŋgya jini-aha am ura. ");
INSERT INTO mfi_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Náwa zhera-aha á emnde a ɓela ŋanna: Simaun ŋane una Yaisu a fante zhera á Piyer, ");
INSERT INTO mfi_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","tara Yakuba tá an egdza emmeŋara Yuhanna itare ta egdzara á Jaibaidaiyus, Yaisu a faterte zhera á Bauwanairgais, amaana: hula á samaya, aɗaba itare ta emnde a ica ervauŋɗe watsewatse; ");
INSERT INTO mfi_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andere, Filip, Bartaulauma, Mata, Taumas, Yakuba á Halfa, Tadawus, Simaun na wayaaka tá kwaráterá emnde umele na, ");
INSERT INTO mfi_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ira Yahuda Iskariyaut edda una a velu Yaisu áza kelaade-aha-aara na. ");
INSERT INTO mfi_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Saasa Yaisu maa, se jarammejahe emnde zlaɓe ádaliye, ba sarte á zu duksa keni sharánka tara Yaisu an pukura-aha-aara. ");
INSERT INTO mfi_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Am sarte na cenaráncena emnde a há-aatare, a ba itare: «Una wá, hairireka mazla-aara.» Daaci ta naba duhe geni tá teɗeseteɗe am dagave-aatare. ");
INSERT INTO mfi_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tá aŋkwa malum-aha á *tawraita am emnde ŋanna ta sawa á sa am huɗe á Urusaliima, ta bantsa itare: «Aŋkwa *Bailjaibul slekse á shaitaine-aha am ŋane.» Emnde umele keni ta ndahán ba estuwa, a ba itare: «A vantaa ba slekse á shaitaine-aha ŋanna hákuma ge ŋgyesaa shaitaine am ura na.» ");
INSERT INTO mfi_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Daaci Yaisu a ɗaterte baɗemme á dezeŋara, a vaterte elva an naraje, a ba ŋane á elvan ge itare: «Á sáwá estara ni Shaitaine á báká ire-aara na? ");
INSERT INTO mfi_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Am kwárá á slekse palle, máki emnde tegarsetege gergere buwa wá, á zlaleka hákuma mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Zlaɓe ádaliye, am huɗe á há palle, máki tegarsetege emnde gergere buwa, huɗe á há ŋanna á zlaleka mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ba duksa palle ge Shaitaine keni. Má gevge ni Shaitaine a teganse ire-aara buwa am kwárá-aara wá, hákuma-aara á duka á de katafke, ma vaatara keni á zle.» ");
INSERT INTO mfi_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Yaisu aŋkwa á sla Shaitaine an slendzeɗa, a ba ŋane á elvan ge itare: «Ɓaaka ura á dzegwándzegwa zá há á slendzeɗa, máki eksevaaka emtsaaɗe slendzeɗa a puwanse erva ákataliya, lauktu ŋane á zá há-aara baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Diyaweddiye una ba shagera: Baɗemme á haypa-aha na tá maganá emnde, antara elva a mándzawe na tá valyaná itare áte Dadaamiya na, á ƴateraareƴa Dadaamiya baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Amá edda una ni a ndaase elva a mándzawe áte Sheɗekwe Cuɗeɗɗe wá, ɓaaka ƴanarƴe ge ŋane ɗekiɗeki. Aɗaba haypa-aara ŋanna náza ba ge ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","A bateraa una Yaisu na wá, aɗaba ta bantsa emnde umele-aatare: An shaitaine. ");
INSERT INTO mfi_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Am iga a una ŋanna maa, ta semhe ge tara emmeŋara, antara egdzar mama-aha á ŋara, ta tsaahe á ba ágashe, ta ɓelaa ura, ta de ɗante. ");
INSERT INTO mfi_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Am sarte ŋanna kwakya emnde ázeŋara, amá ta naba ndahanhe, a ba itare: «Tá aŋkwa á ndaváká tara emmeŋa, antara egdzar mama-aha-ŋa ágashe.» ");
INSERT INTO mfi_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","A ŋwaterante, a ba ŋane á elvan ge itare: «Ware ŋane emmerwa ge iya? Emnde-ara itare egdzar mama-aha-aaruwa ge iya?» ");
INSERT INTO mfi_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Daaci a zharaa emnde na tá ázeŋara, a ba ŋane á elvan ge emnde baɗemme: «Náwa tara emmerwa antara egdzar mama-aha-aaruwa tá áhuna. ");
INSERT INTO mfi_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ma ware una á maga názu á kataná Dadaamiya, egdza emmerwa ba ŋane, emmerwa ba ŋane.» ");
INSERT INTO mfi_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yaisu a daliye zlaɓe á de kwaraterse elva á Dadaamiya ge emnde áte we á haye á Galili. Kwakya nalga á emnde a jemaa á katafke-aara. Aɗaba una ŋanna, a njema am paare, ŋane áte ire á haye; emnde wá, baɗemme tá á ba am haha áte we á haye ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A kwaraterse duksa kwakya an naraje-aha, a ba ŋane á elvan ge itare: ");
INSERT INTO mfi_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Cenawancena, náwa yá bakurá elva: Sesse zhele umele ge de puwa nalkame am fe-aara. ");
INSERT INTO mfi_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Am sarte na aŋkwa á puwa nalkame ŋanna, wulfe-aha umele a de valyaa áte uŋŋule, ta se tsakantehe ge ƴiye-aha. ");
INSERT INTO mfi_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wulfe-aha umele, a de valyaa áte cacera, cekwa haha, a naba sese á ba áte watsewatsire aɗaba cekwa haha. ");
INSERT INTO mfi_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Amá de sesse vaciya an kárá-aara wá, deraadera aɗaba ɓaaka slalwe ŋgelama. ");
INSERT INTO mfi_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wulfe-aha umele zlaɓe ádaliye, a valyemaa am dake, a waltaa am dake, a ɓecante ge dake, magaaka ire. ");
INSERT INTO mfi_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Amá wulfe-aha umele wá, a puwaa á ba am haha shagera, a sesehe ba shagera, a waltaa an uŋŋule-aara, a magaa ire. Ekte-aha umele, ta yayaa egdzara kul keƴe kul keƴe, ekte-aha umele ta yayaa kul uŋkwahe kul uŋkwahe, ekte-aha umele zlaɓe ádaliye ta yayaa deremke deremke.» ");
INSERT INTO mfi_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Daaci a ba ŋane á elvan ge itare: «Edda una máki aŋkwa hyema-aara, a cenevaacena!» ");
INSERT INTO mfi_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Am sarte na ɓaaka dikele á emnde ázeŋara, ta juwa ba emnde umele-aatare antara pukura-aha kelaawa ju buwa, ta naba ndavanu maana á naraje-aha-aara. ");
INSERT INTO mfi_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","A ŋwaterante, a ba ŋane: «Kure wá, vararakurteva baráma geni kwá diyeddiye nasherire na am *kwara á Dadaamiya, amá emnde umele wá, ma yá ndaterndáhá keni sey á ba an naraje. ");
INSERT INTO mfi_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Estuwa, ma tá aŋkwa á zharaná á ba an ice-aatare keni, tá diseka ɗekiɗeki; ma tá aŋkwa á cenaná á ba an hyema-aatare keni, tá ceneseka ɗekiɗeki. Aɗaba itare, ɓaaka wedere-aatare an ɗaba Dadaamiya. Ayka wá, ma andze á naba ƴateraarƴe Dadaamiya!» ");
INSERT INTO mfi_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Daaci a ba Yaisu á elvan ge itare: «Kina cenakuránka naraje na? Máki cenakuránka una, kwá de cenaná estara kena naraje-aha umele na? ");
INSERT INTO mfi_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Náwa maana á naraje ŋanna. Slepuwa wulfe ŋanna wá, á puwa ba elva á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Emnde umele, itare ta ba seke uŋŋule. Tá cenvaacena elva á Dadaamiya, amá kerteŋ á sawa shaitaine, á tsakse elva ŋanna am itare. ");
INSERT INTO mfi_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Emnde umele itare ta ba seke cacera. Má cenaráncena elva á Dadaamiya, kerteŋ tá lyiyaná á ba an higa. ");
INSERT INTO mfi_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amá tá vanteka sleɗe ge elva á Dadaamiya ŋanna am itare. Daaci má jerje lámare umele bi zlaɗa aɗaba elva ŋanna wá, tá ƴá fetarfire-aatare ba watsewatse. ");
INSERT INTO mfi_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Emnde umele zlaɓe ádaliye, itare ta ba seke dake. Tá lyevalya tsa elva á Dadaamiya, ");
INSERT INTO mfi_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","amá wá, á dem dagave á dzama á ire an kazlaŋa á duniya, antara waya á nalmane kwakya, ira waya á duksa-aha umele gergere am duniya na. Á ɓecanta ba una ŋanna elva á Dadaamiya na am itare, á maŋka nampire ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Amá emnde umele wá, itare ta ba seke haha na sleɗe shagera na. Tá cenevaacena elva á Dadaamiya, tá lyiyaná an ervauŋɗe-aatare palle, elva ŋanna á maga nampire am itare. Emnde umele aŋkwa nampire-aatare cekwa, emnde umele nampire-aatare deydey, amá emnde umele wá, kwakya nampire-aatare.» ");
INSERT INTO mfi_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yaisu a farhe zlaɓe ádaliye ge tsakaterá elva, a ba ŋane á elvan ge itare: «Ware edda una máki a mbante kárá á fanus, á fáná am ekte á egdera, bi á uŋmbar tasa? Ɓaaka ɗekiɗeki, sey tá zleŋelaná á ba áte tate-aara. ");
INSERT INTO mfi_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Daaci diyaweddiye ganakini baɗemme á názena an sheɓe kina, watse á sesse ásegashe. Baɗemme á názena nasherire kina, watse tá diyeddiya emnde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Edda una, máki aŋkwa hyema-aara, a cenevaacena.» ");
INSERT INTO mfi_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Zlaɓe ádaliye a ba ŋane, á elvan ge itare: «Faufa hyema am názena kwá cenaná kure baɗemme na. Aɗaba baɗemme á názena kwá magaterná kure ge emnde na wá, Dadaamiya keni á de magakurná á ba áte una ŋanna ge kure keni. Baira á de januje ŋane am una kure kwá magaterán ge emnde. ");
INSERT INTO mfi_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Edda una máki aŋkwa ázeŋara na wá, watse tá de fanaarfe zlaɓe adaliye ge ŋane. Amá edda una an erva dey wá, ba egdza una ázeŋara na keni, tá de lyanvulye.» ");
INSERT INTO mfi_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yaisu a farhe zlaɓe ádaliye, a ba ŋane á elvan ge itare: «Náwa názu á gáráva an názena á magava am *kwara á Dadaamiya: Duwa á ura umele, a puwaa wulfe am fe-aara. ");
INSERT INTO mfi_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Daaci ŋane á pá ba hare-aara, á kezla ba hare á bere, amá wulfe ámbera á ba segashe, aŋkwa á wala, ɓaaka názu a disaa ŋane am huɗe-aara ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Baɗemme, á maganá ba haha slera. A sanse wulfe, a walante, a magaa ire, haa a nanve. ");
INSERT INTO mfi_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Má welasewele, edda fe a duwa á ba an náza wa masa-aara, a de icica, aɗaba hyephye sarte.» ");
INSERT INTO mfi_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","A ba Yaisu á elvan ge itare zlaɓe ádaliye: «Mí slaterá an uwe *kwara á Dadaamiya? Mí shateru an naraje-ara ge emnde? ");
INSERT INTO mfi_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kwara á Dadaamiya wá, á gáráva an wulfe á pilli. Ŋane wá, cekwa ba ŋane am wulfe-aha baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Amá má jaremje am haha, sesse wá, á wala jipu, haa á jauje ba ge duksa-aha umele an wala, á vala erva, ƴiye-aha tá njá am sheɗekwe-aara, tá maga bere-aatare keni átekwa.» ");
INSERT INTO mfi_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yaisu a kwaraterse estuwa elva ge emnde an naraje-aha áte una tá cenáncena. ");
INSERT INTO mfi_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Baɗemme á elva-aara a kwaraterse á ba an naraje. Amá ge pukura-aha-aara, am sarte na ɓaaka emnde ázetare wá, a palateraa sera-aara baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ba vacite ŋanna herzha maŋgaripu wá, a ba Yaisu á elvan ge pukura-aha-aara: «Ebzaumibze haye ádehuwa-aara.» ");
INSERT INTO mfi_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Daaci ba tse-aatare, ta ƴaa emnde am tate ŋanna. Pukura-aha ta daa Yaisu am paare na a njemaa ŋane am huɗe-aara, amá paare-aha umele keni ndza aŋkwa áhuwa. ");
INSERT INTO mfi_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Cekwaaŋguɗi wá, a naba tsete ge válale ƴaikke átire á haye ŋanna, a maganaa ŋane vádza á haye á ba an ndzeɗa haa a nante paare an yawe. ");
INSERT INTO mfi_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yaisu ŋane á zlava áte kataliya á paare, a ɓelete ire-aara áte náza ɓela ire, á pá ba hare-aara. Duwa á pukura-aha-aara, ta tsante am hare na, a ba itare tá elvan ge ŋane: «Malum, mí keɗa ni ɓaaka lambe á ŋa?» ");
INSERT INTO mfi_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ba tsetse-aara, a naba valarhe ge válale na, a ba ŋane á elvan ge haye: «Tsaatse ba tseriyye.» Daaci a naba tsahe ge válale, tseriyye sleɗe ba seke ndza magaaveka duksa. ");
INSERT INTO mfi_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Am iga á una ŋanna maa, a ba Yaisu á elvan ge pukura-aha-aara: «Labára kwá maga lyawa estuwa? Ɓaaka fetarfire á kure áte ya emtu?» ");
INSERT INTO mfi_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Daaci jaterja lyawa jipu, a ba itare am dagave-aatare: «Ware kena ŋane una ni dete ba effeƴa antara haye keni tá fansarfe na?» ");
INSERT INTO mfi_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Am sarte na icaransice haye ŋanna maa, daraada áte iga a guwa ŋanna. Tate ŋanna wá, am kwara á Gairasaine-aha. ");
INSERT INTO mfi_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ba a tsekwese ge Yaisu am paare wá, a naba sesehe ge zhele umele am dagave á irekhya-aha, a se yainu á ba an ye ge Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Zhele ŋanna wá, an jini am ire, á njá á ba am dagave á irekhya-aha. Ɓaaka ura á dzegwándzegwa tákwasa ŋane, ma an tsavaytsavaye keni. ");
INSERT INTO mfi_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Aɗaba ser kwakya tá puwante sasala áte sera, tá tákwasaná erva an tsavaytsavaye, amá a ɓataahe baɗemme. Ɓaaka ura á dzegwándzegwa ŋá zhel ŋanna ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Vaƴi vacika á já á ba ɗába am dagave á irekhya-aha antara áte ire á wa-aha, ámbera á hula, á tata vuwa-aara an nákwa. ");
INSERT INTO mfi_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Am sarte na ni a naa Yaisu, a se yainuye na wá, a sawa á ba an zhagade, kreppe a se mbeɗehe am sera-aara, ");
INSERT INTO mfi_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","a fu hula an ndzeɗa-aara baɗemme, a ba ŋane am hula-aara á elvan ge Yaisu: «Ekka Yaisu *Egdza á Dadaamiya Slekse, ázara am dagave á miya? Yá ndaaka aɗaba Dadaamiya, tasle á ŋa, fiyemka am zlaɗa!» ");
INSERT INTO mfi_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","A ndanaa aɗaba uwe una ŋanna, aɗaba a ndaase elva-aara Yaisu, a ba ŋane: «Ekka shaitaine, sesse am zhel na!» ");
INSERT INTO mfi_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Daaci Yaisu a ndavanu zhera-aara ge zhele ŋanna, a ŋwanante, a ba ŋane: «Zhera-aaruwa wá, Dikele á Emnde, aɗaba ŋa vayye.» ");
INSERT INTO mfi_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Zhele ŋanna a fantau ge kyuwanfe ge Yaisu geni a ƴaterƴa jini-aha ŋanna, a njarinja á ba am kwara ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Am tate ŋanna maa, ndza aŋkwa walda á nabezhe ƴaikke, tá piyá áte egdza wa maa, ");
INSERT INTO mfi_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","jini-aha ŋanna ta fantau ge ŋala Yaisu, a ba itare tá elvan ge ŋane: «Tasla á ŋa, vaŋerteva ka baráma, ŋá de njá am nabezhe-aha na.» ");
INSERT INTO mfi_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yaisu a naba vaterte baráma ŋanna. Mazla-aara ta naba sesehe ge jini-aha am zhel na, ta dem nabezhe-aha ŋanna. Nabezhe-aha ŋanna á maga debu buwa, amá ta naba zlerdaa zhagade a sate egdza wa ŋanna, ta puwamme am haye, a ndateruhe ge haye baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Daaci zhagade ge suni-aha á nabezhe ŋanna, ta dateraa labáre ge emnde a makwata antara emnde a huɗe á ekse baɗemme. Daaci estuwa nalga tá kelá á dem tate ŋanna ge de zhárá názena magaavmage. ");
INSERT INTO mfi_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Daraada áza Yaisu, tá zhárá ba zhel na ndza an jini-aha am ŋane na á njá, an eŋkale-aara ba laŋŋe, a tsekweme am naŋgyuwe ba seke emnde. Amá itare, baɗemme ta fantau ge mága lyawa. ");
INSERT INTO mfi_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Daaci emnde na ni ta naana á ba an ice-aatare mága ŋanna baɗemme na, ta fantau ge tsakaterse sera-aara baɗemme, geni a shanaa estara ire-aara zhel ŋanna, antara keɗa á nabezhe-aha na. ");
INSERT INTO mfi_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Amá itare, ta ŋala Yaisu geni a dedde am larde-aatare ba ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Estuwa Yaisu a naba ɗalme am paare á yawe, amá zhele na shansha ire-aara na a ndavanu ge Yaisu, geni ŋane keni a eɗɗaba. ");
INSERT INTO mfi_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Amá eksarka Yaisu. A ba ŋane á elvan ge ŋane: «Eptseptsa á dem mba á kure, de vaterteva sera á názena a magakanaa Yaakadada na, antara zevarzire-aara na a zakvaara ŋane na baɗemme ge emnde á kure.» ");
INSERT INTO mfi_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Daaci ba zlálá á zhele ŋanna, a de fantau ge ɓala labare-aara am kwara na tá ɗahaná an Ekse Kelaawa na. Baɗemme á emnde na ta cenaa labare-aara na tá maga najipu. ");
INSERT INTO mfi_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","A eptsehe zlaɓe ádaliye ge Yaisu, a icanse haye ásete we-aara, ta se jamme ge nalga a emnde kwakya zlaɓe ádaliye ázeŋara. ");
INSERT INTO mfi_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","A semhe ge palle á male-aha am mashidi, zhera-aara Yayrus, a se kezlaa ugje am sera á Yaisu, ");
INSERT INTO mfi_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","a fantau ge ŋala ázeŋara, a ba ŋane á elvan ge ŋane: «Tasla á ŋa, sawa fetefa erva á ŋa áte egdza-aaruwa mukse lapika, aɗaba herzhe á degashe shifa am ŋane. Má dakemda ka wá, á emtseka mazla-aara, sey á mbembe.» ");
INSERT INTO mfi_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Daaci Yaisu a naba duhe antara ŋane, kwakya emnde ta daa á ɗabaná ádehuwa, tá ámbera eɓɓeca áte baráma. ");
INSERT INTO mfi_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ndza aŋkwa mukse am dagave á emnde ŋanna, yawe kelaawa ju buwa á maga ba palasa á kela á uzhe. ");
INSERT INTO mfi_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kwakya zlaɗa na a shanaa mukse ŋanna áza dauktar-aha. A keɗaa nalmane-aara baɗemme, aley shanka ŋgulmire ɗekiɗeki, sey ba á farfe. ");
INSERT INTO mfi_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","De cenáncena mukse ŋanna labáre á Yaisu maa, a ba ŋane: «Una wá, ma ya de fete erva-aaruwa á ba áte naŋgyuwe-aara keni, yá mbembe.» Daaci a naba duhe á ba am dagave á emnde ŋanna, a de fete erva-aara áte naŋgyuwe á Yaisu á kya iga. ");
INSERT INTO mfi_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kerteŋ a naba icevhe ge kela á uzhe-aara ŋanna, ba ŋane keni tapanaatápá am vuwa-aara ganakini mbaambe. ");
INSERT INTO mfi_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Á ba am sarte ŋanna a naba tapanaahe ge Yaisu keni am vuwa-aara ganakini sessa ndzeɗa am ŋane, mbanaambe ura. A naba eptsavte am dagave á nalga ŋanna, a ba ŋane á elvan ge itare: «A gejantaa ware naŋgyuwe-aaruwa?» ");
INSERT INTO mfi_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ta ŋwanante ge pukura-aha-aara, a ba itare: «Ká zhárá dikele á emnde ŋanna tá ɓecakɓeca na ni, a gejaktaa ware, a ba ka?» ");
INSERT INTO mfi_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Amá a zharateraahe ge Yaisu, ge dise edda una a magaa una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Daaci gazlaagazla mukse na, aɗaba tapanaatapa názu a gev am vuwa-aara. Daaci a sawhe ámbera á gyagya ba seke maagara, a se kezlaa ugje am sera á Yaisu, a ndanse jirire-aara baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","A ba Yaisu á elvan ge ŋane: «Mbakaambe fetarfire á ŋa egdza-aaruwa, ezzlálá á ba an hairire, de njinja ba layye.» ");
INSERT INTO mfi_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yaisu zlaɓe á ba an elva áte we, ta semhe ge emnde á sawa am mba á Yayrus male am mashidi, a ba itare tá elvan ge Yayrus: «Ɓaaka egdzere. Ƴanƴa malum mazla-aara.» ");
INSERT INTO mfi_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Amá Yaisu fanuka hyema ge elva-aatare. A ba ŋane á elvan ge Yayrus: «A waŋka lyawa ɗekiɗeki, naba fetarfe ka.» ");
INSERT INTO mfi_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Daaci a duhe, amá velaaka baráma ɗekiɗeki ganakini tá ɗabaná emnde ádehuwa, sey ta ɗabanaa ba tara Piyer, Yakuba, ira Yuhanna egdza emmeŋara ge Yakuba ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Daraada am mba á Yayrus maa, ta de beraa emnde kwakya tá maga ba emtaŋkire. Emnde umele tá kyuwa, emnde umele tá tsáka ɗákwa. ");
INSERT INTO mfi_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","A demhe ge Yaisu á dem huɗe á há, a ba ŋane á elvan ge emnde: «Labára kwá maga emtaŋkire, kwá kyuwa estuwa? Egdzere emtsaaka, á pá ba háre.» ");
INSERT INTO mfi_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Amá ta naba puwar dzáká, ágire tá epsawepsawa. Daaci Yaisu a naba bakaterse ásegashe baɗemme, a ƴaa ba tara emmeŋara antara eddeŋara ge egdzere, ira pukura-aha-aara keƴe na, ta demhe antara ŋane á dem bere na á zlava am huɗe-aara egdze na. ");
INSERT INTO mfi_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Daaci ŋane a de ŋanaa ba erva ge egdze na, a ba ŋane á elvan ge ŋane: «Talita kuma», amaana: «Egdzere, ya bakanaa ba iya tsettse.» ");
INSERT INTO mfi_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ba seke ndáhá á miya na tsetsa egdze na. Egdze ŋanna, yawe kelaawa ju buwa. Daaci baɗemme tá maga ba najipu-aara. ");
INSERT INTO mfi_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Amá Yaisu a fater magiya kwakya, geni a ɓalarka ɗekiɗeki. Am iga á una ŋanna, a ba ŋane á elvan ge itare: «Vawanteva náza za ge egdzere.» ");
INSERT INTO mfi_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Daaci a tsete ge Yaisu áhuwa, a zlala á dem ekse na ni a waletaa am huɗe-aara na. Pukura-aha-aara keni ta duwa á ba antara ŋane. ");
INSERT INTO mfi_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Samsa kwaskwe á puwansepuwe maa, ta naba dem mashidi, a de kwaraterse elva á Dadaamiya ge emnde. Emnde kwakya jarammeje am mashidi ŋanna. Am sarte na cenarvaacena elva-aara, ta mága najipu kwakya áte ŋane, a ba itare: «A de mbese áme elva na estuwa? A shanaa áme ŋane ilmu na? Ázara kwa ba najipu-aha na á maganá ŋane na! ");
INSERT INTO mfi_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ábi ba ŋane una slega nafa egdza á Maari na? Egdza emmetare ge tara Yakuba antara Yauseys, Yahuda, ira Simaun. Egdzar mama-aha-ŋara ŋwasha keni ta ba am dagave á miya.» A piyatertaa ba una ŋanna ge fetare áte ŋane, ɓaaka umele. ");
INSERT INTO mfi_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Daaci a ba Yaisu á elvan ge itare: «Ma áme keni emnde tá fa zherwe áte nabi á Dadaamiya, amá am huɗe á há-aatare, antara vara-aha-aara, ira emnde a ekse-aara baɗemme wá, tá feka zherwe áte ŋane.» ");
INSERT INTO mfi_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Daaci magaaka najipu-aha kwakya am ekse ŋanna, sey ba una a puwaterar erva ge emnde umele-aatare, a mbateraahe. ");
INSERT INTO mfi_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yaisu á maga ba najipu-aara aɗaba ɓaakire á fetarfire á emnde a ekse ŋanna. Am iga á una ŋanna maa, a naba tse am ekse ŋanna, a zlálá á dem ekse-aha na herherzhe na, a de kwaraterse elva á Dadaamiya ge emnde a ekse-aha ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Vacite umele maa, a jatermaare ge pukura-aha-aara am tate palle, a vaterte hákuma áte shaitaine-aha, lauktu a fantau ge ɓelaterɓela bubuwa. ");
INSERT INTO mfi_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Lauktu a ɓelaterɓela wá, a fater bariya, a ba ŋane á elvan ge itare: «Eksauka ba uwe keni am erva, sey ba zade á kure palle. Magauka kashi á náza za, ma shuŋgu keni am lyiba. ");
INSERT INTO mfi_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Fawaumfa kimake am sera, amá dawánka zane bubuwa.» ");
INSERT INTO mfi_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","A ba ŋane á elvan ge itare zlaɓe ádaliye: «Máki dakuremda am ekse wá, njawinja á ba am mba na máki lyarakurvaalya am huɗe-aara na, dem sarte á zlálá á kure am ekse ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Má lyiyarakurka emnde, bi cenarka elva á kure wá, dawedde am ekse-aatare, papawaapape berbere na áte sera á kure. Magawateránmaga una ŋanna, watse tá disá ba itare antara Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Daaci ba zlálá ge pukura-aha, tá de ɓelaterá elva á Dadaamiya ge emnde geni a magarmága tuba. ");
INSERT INTO mfi_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ta ŋgyesaa jini-aha kwakya am emnde; emnde na lapika vuwa-aatare keni, ta gaterve waye an zhera á Dadaamiya, mbarateraambe baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","A cenanaa estuwa sleksu *Hirudus labare á Yaisu aɗaba baɗemme á emnde tá ndáhá ba ŋane. Ta bantsa emnde umele: «A tsetaa ba Yuhanna slemaga baptisma am faya. Aɗaba una ŋanna an hákuma á mága najipu-aha gergere.» ");
INSERT INTO mfi_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Amá a ba emnde umele: «Una Yuhanna ka, nabi *Ailiya werre.» A ba emnde umele zlaɓe ádaliye: «Una ba nabi umele tsekemme, amá ŋane keni ba nabi á Dadaamiya ba seke nabi-aha werre.» ");
INSERT INTO mfi_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","De cenáncena sleksu Hirudus gajawe-aatare maa, a ba ŋane: «Una ba Yuhanna slemaga baptisma. Ndza icanaayica ire áte ŋane, amá a tsetaa ba ŋane ŋanna am faya!» ");
INSERT INTO mfi_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","A bateraa una ŋanna aɗaba ndza a ndahanaa ba ŋane ŋanna geni a eksarvaksa Yuhanna. Daaci ta naba eksevaahe, ta puwete zawa áte ŋane, ta de ɓelema am daŋgay. A ŋguɗanaa aɗaba uwe Hirudus Yuhanna; aɗaba Hirudus ŋanna a eksantaave Hirudiya ge egdza emmeŋara Filip. ");
INSERT INTO mfi_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Amá aŋkwa á ndandaha Yuhanna, geni a eksantaave mukse ge egdza emmeŋara na wá, una ŋanna zlayeka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Aɗaba una ŋanna Hirudiya wayaaka zhárá Yuhanna an shifa ɗekiɗeki, ɓaaka ba pute-aara ge já shifa-aara. ");
INSERT INTO mfi_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Aɗaba Hirudus wá, ŋane á kuvá Yuhanna jipu, wayaaka á geja shifa-aara, aɗaba diyaadiya ganakini Yuhanna ura á Dadaamiya, ura jirire. Ba kelaa máki Yuhanna aŋkwa á baná elva ge sleksu Hirudus wá, á taa weranteka ba we-aara keni, amá wayaawáyá tsa eccena-aara. ");
INSERT INTO mfi_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Vacite umele maa, shansha Hirudiya baráma á já Yuhanna. Samsa sarte á ya sleksu Hirudus, a naba gyaa muŋri, daaci a naba ɗante galipa-aha-aara, antara male-aha á sawji-aha ira male-aha umele am kwara á Galili. ");
INSERT INTO mfi_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Duwa á gyaale á Hirudiya, a de shekelaterante ge male-aha na a ɗahateraa slekse na. Hayaranháyá jipu tara slekse an emnde-aara baɗemme. A naba banánba slekse ge gyaale ŋanna, a ba ŋane: «Ma ká kátá uwe keni, naba ndaviyundave, yá vakteva.» ");
INSERT INTO mfi_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A naba zanu waɗa-aara, geni ma a ndavanu uwe keni, sey a vanteva, una ma kyalma á rezege-aara keni, sey á vanteva. ");
INSERT INTO mfi_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Daaci ba degashe-aara ge gyaale na, a deza emmeŋara, ge ndavanu názena ni á se ndavanu ge slekse na. Amá a ba emmeŋara: «De enndava ka a varakteva ba ire á Yuhanna slemaga baptisma.» ");
INSERT INTO mfi_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kerteŋ a semhe áseza slekse, a ba ŋane á elvan ge ŋane: «Yá kátá ká vite ire á Yuhanna slemaga baptisma am kwatame.» ");
INSERT INTO mfi_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Una ŋanna namaari-aareka ɗekiɗeki, amá dzegwánka kwalarkwale aɗaba waɗa na a zanuwa ŋane á katafke á emnde-aara na. ");
INSERT INTO mfi_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Daaci a naba ɓela sawji á dem daŋgay, ge de sá ire á Yuhanna na. Ba zlálá á sawji na, á dem daŋgay na, a de ica ire áte Yuhanna, ");
INSERT INTO mfi_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","a sanán ge gyaale ŋanna am kwatame. Duwa á gyaale ŋanna, a de vante ge emmeŋara. ");
INSERT INTO mfi_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Daada labare ádeza pukura-aha-aara, ta naba sawhe, ta eksante emtsa-aara, ta de heɗehe. ");
INSERT INTO mfi_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Saraasa emnde a ɓela á Yaisu, ta se ndahanhe baɗemme á názena ta maganaa itare antara názena ta kwaraterse ge emnde. ");
INSERT INTO mfi_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Emnde keni ba tá sawa emnde na, tá zlálá emnde na, ɓaaka ica-aatare ɗekiɗeki áza tara Yaisu antara pukura-aha-aara. Ba sarte á za náza za keni ta shanka ɗekiɗeki. Daaci a ba Yaisu á elvan ge itare, «Máki estuwa wá, mi zlalawa á dem tate na ta ɓaaka emnde na, kwá de puwansepuwe cekwaaŋguɗi.» ");
INSERT INTO mfi_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Daaci ta naba deme am paare, ba zlálá-aatare á dem tate na ta ɓaaka emnde átekwa, ba itare an ire-aatare. ");
INSERT INTO mfi_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Amá naraterna emnde kwakya am sarte na tá zlálá na, daaci ta naba diyatersediye, ta ɗabateremhe an sera. Emnde umele keni saresse am ekse-aha gergere, ta ɗabateremhe an sera. Baira ta dema ba itare zuŋŋwe arge tara Yaisu an pukura-aha-aara. ");
INSERT INTO mfi_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","De sessa Yaisu am paare maa, á zhárá ba dikele á emnde tá kela ádezeŋara. Á zharaterzhara wá, a naba zatervaarhe, aɗaba ta ba seke kyawe-aha na ɓaaka suni am ekte ge itare na. Daaci a fantau ge kwaraterse duksa kwakya áte Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Eblyabelya vaci maa, ta duhe ge pukura-aha-aara ádezeŋara, a ba itare tá elvan ge ŋane: «Degey ɓaaka vaciya mazla-aara, tate na keni kaamba. ");
INSERT INTO mfi_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ambane puwateraapuwa emnde na, a zlarzlala á dem ekse-aha antara egdzar makwata-aha na herherzhe áhuna, tá de shakwanu náza za ge we-aatare.» ");
INSERT INTO mfi_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","A ŋwaterante ge Yaisu, a ba ŋane: «Vawaterteva ba kure náza za!» A ba pukura-aha tá elvan ge ŋane: «Ká kátá ŋá de shekwaterá náza za jekka deremke wanyara, lauktu á hyater ge emnde na?» ");
INSERT INTO mfi_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","A ndavateru ge Yaisu, a ba ŋane á elvan ge itare: «Kwá an depaiŋ wanyara ázekure? De zharawazhara wára?» Ta de zharanaahe, a ba itare tá elvan ge ŋane: «Depaiŋ á ŋere aŋkwa ilyeɓe ámasla an kelfe buwa.» ");
INSERT INTO mfi_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mazla-aara a ba Yaisu á elvan ge pukura-aha-aara: «Njawateraanja emnde áte masa an slala an slala.» ");
INSERT INTO mfi_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Daaci ta naba njateraahe emnde deremke deremke, am slala-aha umele kul ilyeɓe kul ilyeɓe. ");
INSERT INTO mfi_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Zlauzle una ŋanna maa, Yaisu a naba halante depaiŋ ilyeɓe, antara kelfe buwa na, a kante ice á dem samaya, a slafanaa we-aara ge Dadaamiya. Daaci a kwacaa depaiŋ-aha na, a tegateraa ge pukura-aha, geni tá vatertá itare ge emnde. Am iga á una ŋanna a tegateraa kelfe-aha na keni. ");
INSERT INTO mfi_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Baɗemme á emnde, ma ware keni a zuhe á ba áte huɗe-aara náza zá na, aley jauje zlaɓe ádaliye. ");
INSERT INTO mfi_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pukura-aha ta halante jugena á depaiŋ antara kelfe ŋanna wárá kelaawa ju buwa. ");
INSERT INTO mfi_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kezlakula á emnde a zá náza zá ŋanna wá, tá maga zála debu ilyeɓe. ");
INSERT INTO mfi_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Shekwaraaka ɗekiɗeki am iga á una ŋanna, a ba Yaisu á elvan ge pukura-aha-aara: «Dawemda am paare, dawedde kure zuŋŋwe á katafke-aaruwa, ebzaubze guwa á kya erwa. Iya wá, yá puwateraapuwa emtsaaɗe emnde.» ");
INSERT INTO mfi_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Puwateraapuwa emnde maa, a naba ɗalete áte egdza wa, a de maga maduwa. ");
INSERT INTO mfi_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Zhedaazheda ice, gevge vaƴi maa, zlarzlálá pukura-aha an paare á dem dagave á haye ba shagera, amá Yaisu wá, á ba áte wa ŋanna ba ŋane palle. ");
INSERT INTO mfi_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Á zhárá pukura-aha-aara á sawa áte wa ŋanna wá, tá baka paare an zlaɗa jipu, á magaterá palasa effeƴa á eptsaterá á dem iga. An ireŋlya wá, a duhe ge Yaisu de shateraasha pukura-aha-aara na áte ire á haye, ŋane á zlálá á ba an sera-aara áte ire á haye ŋanna. Amá a de magaa ba seke á kátá ƴaterseƴe. ");
INSERT INTO mfi_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ba naranna pukura-aha-aara aŋkwa á zlálá an sera-aara áte ire á yawe na wá, ta naba fu hula, aɗaba itare ta kurken shaitaine á yawe. ");
INSERT INTO mfi_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Itare baɗemme ba seke á degáshe shifa am itare ge lyawa. Daaci kerteŋ a ndahater elva Yaisu: «Gazlauka, degiya una ba iya!» ");
INSERT INTO mfi_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Daaci a naba ɗaleme am paare á dezetare wá, tseriyiiye a naba tsaahe ge effeƴa na. Tá geja ba ire pukura-aha-aara, tá maga najipu. ");
INSERT INTO mfi_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Aɗaba degdege ire-aatare jipu, cenaránka itare najipu na a maganaa an depaiŋ na. ");
INSERT INTO mfi_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ba ebzarubze haye wá, tá am haha á Gainaizarait, daaci ta ŋguɗaa paare-aatare áte we á guwa. ");
INSERT INTO mfi_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ba segashe-aatare am paare wá, emnde ta naba dise Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Daaci ba zhagade-aatare á dem ekse-aha-aatare, ta de sanaa emnde-aha-aatare na ni á waterá vuwa-aatare áte egdera-aha-aatare. Ma a dem tate-ara Yaisu keni, tá maga ba una emnde. ");
INSERT INTO mfi_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Baɗemme á tate na ni a de tsekwaa átekwa Yaisu, ma a de tsekwaa am berni, ma áte makwata, ma am egdza ekse baɗemme, emnde ta sanaa emnde-aha-aatare na ni lapika vuwa-aatare, ta fanaa á katafke-aara am dagave á emnde baɗemme, ta ŋalateruŋale geni tá fetefa erva-aha-aatare á ba áte we á naŋgyuwe-aara keni. Daaci baɗemme á emnde na ni ta fete erva-aatare áte ŋane mbarembe. ");
INSERT INTO mfi_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Am iga á una ŋanna maa, *Farisa-aha antara malum-aha á *tawraita umele ta sawa am Urusaliima ta se jamme áza Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Amá ta naa pukura-aha umele ta naba zu ɗafa an erva a liya, bararaaka emtsaaɗe áte una ta kwaratersaa am nadina-aatare. ");
INSERT INTO mfi_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Aɗaba Farisa-aha antara Yahudiya-aha-aatare baɗemme wá, tá zeka ɗafa an erva a liya ɗekiɗeki, sey tá bara erva-aatare ba shagera emtsaaɗe. Estuwa tá aŋkwa maga duksa á eggye-aha-aatare an eŋkale-aatare baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ma ta saa á ba am kwaskwe keni, tá zeka ɗafa ɗekiɗeki, máki tsakaraaka yawe. Aŋkwa zlaɓe kwakya naɗe á eggye-aha-aatare na tá fansaare itare, ba seke bara tasa-aha-aatare, antara gahe-aha-aatare, ira kazlaŋa na ta janaa an verzhagane baɗemme á ba an tsufa ázetare. ");
INSERT INTO mfi_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Aɗaba una ŋanna, ta duwa Farisa-aha antara malum-aha á tawraita á deza Yaisu, ta de ndavanundave, a ba itare: «Labára pukura-aha á ŋa tá fansarka ge názena ta kwaraŋersaa eggye-aha a ŋere, tá naba zá ɗafa an erva a liya na?» ");
INSERT INTO mfi_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","A ŋwaterante ge Yaisu, a ba ŋane: «Una wá, ba jire á Aisaya, aɗaba ndza maganaamaga ŋane nabiyire áte kure kwa emnde na. Aŋkwa an puwa am wakita á Dadaamiya, a ba ŋane: Emnde na wá, tá aŋkwa á galiya á ba áte we, am ervauŋɗe-aatare ta ƴiƴiye an ya. ");
INSERT INTO mfi_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tá aŋkwa jáháva ɗeme am sera-aaruwa, amá una ŋanna ba dey. Aɗaba itare tá ndáhá ba naɗe-aha á emndimagwaha, ta ganve ba seke elva-aaruwa.» ");
INSERT INTO mfi_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Daaci a eksante elva-aara zlaɓe ádaliye Yaisu, a ba ŋane á elvan ge itare: «Kure kwa ƴaa shairiya á Dadaamiya, kwá aŋkwa fansar ge naɗe-aha á emndimagwaha.» ");
INSERT INTO mfi_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","A ba ŋane á elvan ge itare zlaɓe ádaliye: «Diyakurdiya eptsanve iga ge shairiya á Dadaamiya, geni kwá ganvege naɗe-aha á emndimagwaha. ");
INSERT INTO mfi_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ábi a enndaha Muusa, a ba ŋane: Ɗematerveɗeme tara emmeŋa an eddeŋa. Ma ware una a ndaase elva ƴaiƴaihe áte eddeŋara bi áte emmeŋara, edda-aara a njeka an shifa ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Amá kwa bantsa kure, ma edda-aara á kátá melanu ge eddeŋara bi ge emmeŋara keni, máki ndasendahe edda-aara ganakini aŋkwa duksa ma andze yá melaku an ŋane, amá ya fan ge slera á Dadaamiya wá, ");
INSERT INTO mfi_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","daaci ɓaaka wedera á edda-aara ge melanu ge eddeŋara bi ge emmeŋara mazla-aara. Estuwa á ba elva á kure. ");
INSERT INTO mfi_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","An una ŋanna wá, kwa ganve elva á Dadaamiya ba seke duksa dey, kwa tsaa áte naɗe-aha á eggye-aha á kure. Kwakya jeba á duksa-aha ŋanna kwá maganá kure.» ");
INSERT INTO mfi_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Am iga á una ŋanna maa, a ba Yaisu á elvan ge emnde baɗemme: «Sawmbare, cenauvaacena elva na ba shagera. ");
INSERT INTO mfi_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nazu á badza ura an Dadaamiya wá, názena á faná edda-aara á dem mbuweka, á badzená názena á segashe am mbuwe á edda-aara.» (( ");
INSERT INTO mfi_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Edda una máki aŋkwa hyema-aara, a cenevaacena.)) ");
INSERT INTO mfi_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Am sarte na ƴaterƴa Yaisu emnde, a de deme am bere maa, pukura-aha ta de ndavanu maana á naraje ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","A ŋwaterante, a ba ŋane: «Iyau, kure keni kwaasau zlaɓe shakuranka eŋkale-aara, cenakuranka? Diyakurka ganakini ɓaaka názu á duwa ádagashe á dem mbuwe á urimagwe, á badzaterá an Dadaamiya emtu? ");
INSERT INTO mfi_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Aɗaba una ŋanna á duka á dem ervauŋɗe, amá á dem huɗe, á segashe zlaɓe ádaliye am edda-aara.» An elva-aara ŋanna wá, ganvege náza za baɗemme ba halal. ");
INSERT INTO mfi_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","A ba ŋane á elvan ge itare zlaɓe ádaliye: «Ba názena ni á segashe am mbuwe á edda-aara una á badzaterá an Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Aɗaba kwakya shagerkire á hala na á segashe am ervauŋɗe á ura. Á berhaná ba una ŋanna á de maga dakarire, neylire, á de já shifa, ");
INSERT INTO mfi_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","á de maga gwardzire, á dem waya duksa á ura, á de maga mandzawire, á de zlerma ura, á de maga ŋguɗiyire, á dem shelha, á dem zá vuwa á ura, á dem gálá ire, ira á dem wucire. ");
INSERT INTO mfi_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Daaci baɗemme á duksa-aha ŋanna, á segashe á ba am ervauŋɗe á urimagwe, á badzaterá ba una ŋanna an Dadaamiya-aara.» ");
INSERT INTO mfi_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tsetsa Yaisu áhuwa, kwaye a zlálá á dem ekse-aha na herherzhe an berni á Tirus. A de demhe am bere, wayaaka tá diyeddiya emnde, amá dzegwanka sheɓe. ");
INSERT INTO mfi_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Aŋkwa mukse umele an shaitaine egdza-aara, egdzere mukse maa, ba a cenaa labare á Yaisu wá, a naba duhe ádezeŋara, a de kezlanaa ugje, ");
INSERT INTO mfi_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","a fantau ge ŋala Yaisu geni a ŋgyainseŋgye shaitaine ŋanna am egdza-aara. Mukse ŋanna wá, mukse á Yahudiya ka, ŋane mukse á Yunaniŋkau am emnde á Siraufiniki. ");
INSERT INTO mfi_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Daaci a ba Yaisu á elvan ge ŋane: «Ƴaterƴa a zaruze emtsaaɗe egdzara ɗafa. Haleta ɗafa á egdzara, puwateranve ge kere-aha wá, una zlayeka ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","«Ba estuwa,» a ba mukse na, «amá ma kere-aha keni tá wazaná ba itare kwaca á ɗafa na á valya á sawa am erva á egdzara.» ");
INSERT INTO mfi_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","A lyevaa ge Yaisu, a ba ŋane á elvan ge ŋane: «Ŋwakteŋwa shagera. Naba zlálá á da, ɓaaka shaitaine am egdza á ŋa mazla-aara.» ");
INSERT INTO mfi_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Daaci a naba da-aara mukse na, a de bera egdza-aara, á zlava áte egdera ba lapilayye, ɓaaka shaitaine am ŋane. ");
INSERT INTO mfi_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Am iga á una ŋanna maa, a tsete ge Yaisu am Tirus, a zlálá á dem Sidaun. Tsante am Sidaun maa, a segashe am kwara á tate na tá ɗahaná an Ekse Kelaawa na praatte, ge sete we á haye á Galili. ");
INSERT INTO mfi_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ahuwa maa, ta sanaa makwaya umele zhele, á taa ndaaseka elva an uŋŋule-aara keni. Daaci ta ŋala Yaisu ganakini á puwar erva-aara, á mbanaambe. ");
INSERT INTO mfi_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Daaci Yaisu a sanse zhel ŋanna am dagave á emnde, a de tsanaahe ba ŋane palle, a shaɓanem gulanda-aha-aara am hyema, a kyefaa nyaihe-aara, a gante áte nara, ");
INSERT INTO mfi_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","a kante ice á dem zhegela, a puwese shifa á ba an ndzeɗa; «Aifata,» a ba ŋane á elvan ge zhel ŋanna. Amaana: A wartewárá hyema-aha á ŋa. ");
INSERT INTO mfi_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ba seke ndaha á miya na kerteŋ wartewárá hyema-aha-aara, a werte ge we-aara keni, a fantau ge ndaha elva á ba an uŋŋule-aara. ");
INSERT INTO mfi_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Amá Yaisu a fater magiya kwakya geni a ndaaranka ma ge ware keni. Amá ba seke una ŋane a fater magiya kwakya na wá, itare keni ta de ɓalse labare ŋanna kwakya áza emnde. ");
INSERT INTO mfi_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Daaci baɗemme á emnde tá maga ba dikere-aara, a ba itare am dagave-aatare: «Baɗemme á názena a maganaa ŋane na ba shagera! Antara ba makwaya-aha keni á vaterte hyema degey! Wuce-aha keni á weraterta we, tá ndaha elva ba laŋŋe!» ");
INSERT INTO mfi_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Am sarte ŋanna maa, ta semhe ge emnde umele zlaɓe ádaliye ta kwakya jipu, ta se jamme áza Yaisu. Am ɓaaka náza za áza emnde ŋanna, Yaisu a ɗetaa pukura-aha-aara, a ba ŋane á elvan ge itare: ");
INSERT INTO mfi_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Emnde na tá wiwa am ice ge iya, aɗaba hare keƴe vatena tá á ba ázerwa, názu á ezza keni ɓaaka. ");
INSERT INTO mfi_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Máki puwanateraapuwa ba estuwa, ɓaaka názu ta zuwaa itare wá, á de ceɓateraaceɓa waya áte baráma. Aɗaba emnde umele-aatare, ta sawa á sa am tatu ƴiƴiye.» ");
INSERT INTO mfi_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ta ŋwanante ge pukura-aha, a ba itare: «Á de shaná áme kena ura náza zá am kaamba na ni á hyater ge emnde na?» ");
INSERT INTO mfi_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","«Aŋkwa wanyara depaiŋ ázekure?» a ba Yaisu á elvan ge itare. Ta ŋwanante, a ba itare: «Ŋá an depaiŋ vuye.» ");
INSERT INTO mfi_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Daaci: «Njawinja am haha,» a ba Yaisu á elvan ge emnde baɗemme. Ŋane a halante depaiŋ-aha vuye na, a slafanaa we-aara ge Dadaamiya, a kwacaahe, daaci a naba tegateraa ge pukura-aha-aara, geni tá vatertá itare ge emnde. Daaci pukura-aha ta tegateraa depaiŋ na ge emnde. ");
INSERT INTO mfi_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ndza aŋkwa egdza kelfe-aatare zlaɓe ádaliye. Yaisu a slafanaa we-aara ge Dadaamiya arge kelfe ŋanna keni, daaci a tegateraa ge pukura-aha-aara, geni tá vatertá kelfe ŋanna keni ge emnde. ");
INSERT INTO mfi_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Baɗemme-aatare, ma ware keni a zuwa á ba áte huɗe-aara, ta ƴanaa ba itare náza zá. Pukura-aha ta halante jugena-aara kenday vuye. ");
INSERT INTO mfi_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Emnde ŋanna keni ta vayye tsa, tá maga debu ufaɗe. Am iga una ŋanna maa, Yaisu a naba puwateraahe, ");
INSERT INTO mfi_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ŋane a demhe am paare antara pukura-aha-aara, kwaye ta zlala á dem kwara á Dalmanuta. ");
INSERT INTO mfi_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ta duhe ge *Farisa-aha ádeza Yaisu wá, a dateraa ba gajawe, ta de tsagwaɗanaa áte elva. A ba itare tá elvan ge ŋane: «Máki a ɓelakaa ba Dadaamiya wá, maraŋeranmárá najipu palle geni ŋá diyeddiye átekwa.» ");
INSERT INTO mfi_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Daaci Yaisu a puwese shifa á ba an ndzeɗa, a ba ŋane: «Labára ŋane emnde a zamane na tá tataya ba najipu na? Yá ndaakur ba jirire, ɓaaka najipu na ni tá marateranmárá mazla-aara.» ");
INSERT INTO mfi_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Mazla-aara ba tse-aara áhuwa, a deme am paare, a eptsehe zlaɓe ádaliye ásete we á guwa á sehuna-aara. ");
INSERT INTO mfi_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Am tse-aatare ŋanna maa, pukura-aha ta naba viyaa náza zá, tá á ba an depaiŋ palle ázetare. ");
INSERT INTO mfi_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Hyemhye am ndáhá elva a Yaisu an naraje an shahi á makala maa, a fater magiya, a ba ŋane á elvan ge itare: «Degiya faufa hyema, tsufautsufa ire á kure átuge shahi á makala á *Farisa-aha, antara *Hirudus!» ");
INSERT INTO mfi_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","A ba pukura-aha am dagave-aatare: «A ndaha una Malum, aɗaba ŋa viyaa depaiŋ.» ");
INSERT INTO mfi_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Diyeddiye Yaisu názena tá ndahaná itare, a ba ŋane á elvan ge itare: «Labára kwa bantsa kure, aɗaba kwa viyaa depaiŋ? Kwaasau zlaɓe diyakurka, ba egdza a una ni kwá taa cenvaaka? Kwaasau zlaɓe shakuránka eŋkale? ");
INSERT INTO mfi_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kwá á ba an ice á kure ni, aley kwá nanka? Kwá á ba an hyema á kure ni, kwá cenánka? Yehauteyeha ");
INSERT INTO mfi_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","á ba áte depaiŋ ilyeɓe na ya kwacanaa ya, ta zanaa emnde debu ilyeɓe na. Kwa halante jugena-aara wárá wanyara?» Ta ŋwanante: «Wárá ilyeɓe,» a ba itare. ");
INSERT INTO mfi_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","A ba Yaisu á elvan ge itare: «Depaiŋ vuye na ya kwacanaa ya, ta zanaa emnde debu ufaɗe na mu, kwa halante jugena-aara kenday wanyara?» Ta ŋwanante: «Kenday vuye,» a ba itare. ");
INSERT INTO mfi_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Daaci a ba Yaisu á elvan ge itare: «Aley ni kwaasau zlaɓe diyakurka?» ");
INSERT INTO mfi_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Se tsekwartsekwa am Baytisayda, ta se yainu á ba an ye ge Yaisu emnde, ta sanaa ura wulfe, a ba itare tá elvan ge ŋane: «Puwetepuwa erva á ŋa áte zhel na tasla á ŋa, geni a mbembe.» ");
INSERT INTO mfi_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yaisu a naba ŋá zhel ŋanna áte erva, a danse á dete iga a ekse. Daraada áhuwa maa, a de kyefaa nyaihe-aara, a gante áte ice-aha ge zhel na, a ba ŋane á elvan ge ŋane: «Ká aŋkwa nanna emtu?» ");
INSERT INTO mfi_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A kante ice-aara wulfe na, a ba ŋane: «Yá aŋkwa nanna emnde tá aŋkwa zlálá, amá ta ba seke nafa-aha.» ");
INSERT INTO mfi_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Daaci a puwanem erva-aha-aara zlaɓe ádaliye am ice, mazla-aara a naba ŋgyaiŋgyesaa ice-aara zhel na, a mbehe á ba áte una ŋanna, aŋkwa á nanna ba laŋŋe. ");
INSERT INTO mfi_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Mazla-aara a ɓelanaahe ge Yaisu, a ba ŋane á elvan ge ŋane: «Ezzlálá á da, eptseka á dem huɗe á ekse na mazla-aara.» ");
INSERT INTO mfi_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Am iga á una ŋanna maa, a naba tsetehe ge Yaisu antara pukura-aha-aara, kwaye ta zlálá á dem ekse-aha na am kwara á Kaysariya á Filip. Tá áte baráma á zlálá maa, a ndavateru ge Yaisu, a ba ŋane á elvan ge itare: «Ta baa uwe emnde áte iya, ta baa iya ware?» ");
INSERT INTO mfi_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ta ŋwanante, a ba itare: «Emnde umele wá, ta baa ka Yuhanna slemaga baptisma. A baa emnde umele, ka nabi *Ailiya werre. A baa emnde umele zlaɓe adaliye, ka ba nabi umele tsekemme.» ");
INSERT INTO mfi_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","A ba Yaisu á elvan ge itare: «Ay kure ma, kwá ba, ya ware kena?» A ŋwanante ge Piyer, a ba ŋane: «Ba ka una ka *Almasiihu na.» ");
INSERT INTO mfi_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Daaci a fater magiya Yaisu, a ba ŋane á elvan ge itare: «Ndahawanka ge ura umele mazla-aara.» ");
INSERT INTO mfi_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Am iga á una ŋanna maa, Yaisu a fantau ge vaterte sera á elva ge pukura-aha-aara. A ba ŋane á elvan ge itare: «Iya *Ura á emnde baɗemme wá, ɓaaka pekya-aara, sey yá shushe zlaɗa kwakya. Male-aha á larde, antara male-aha á *liman-aha, ira malum-aha á *tawraita, tá de ƴiyaaƴa, watse tá zlanaazle shifa-aaruwa baɗemme, amá am hare buwa ge keƴire wá, watse yá tsetse am faya.» ");
INSERT INTO mfi_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A ndaterse una ŋanna ba parakke, sheɓaaka. A naba ɗahese ge Piyer ba itare ta buwa antara Yaisu, a de maganaa gajawe áte elva ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Amá a naba eptsavte ge Yaisu áseza pukura-aha umele, a fantau ge valar ge Piyer, a ba ŋane á elvan ge ŋane: «Jinaaja ekka ka Shaitaine. Aɗaba názena ká dzamaná ka na jarammeka antara náza á Dadaamiya, náza á ŋa na ba názu tá dzamaná emndimagwaha.» ");
INSERT INTO mfi_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mazla-aara Yaisu a ɗante pukura-aha-aara antara emnde baɗemme, a ba ŋane á elvan ge itare: «Máki edda-aara wayaawáyá ɗaba ya wá, a dzameka shifa-aara ɗekiɗeki. A eksanteksa dzaŋgala-aara, a ɗabiɗába an ŋane. ");
INSERT INTO mfi_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Aɗaba máki edda-aara á tataya lya shifa-aara wá, á de keɗanaakeɗa. Amá edda una a keɗaa shifa-aara aɗaba iya, antara aɗaba labare á higa wá, á de shansha zlaɓe adaliye. ");
INSERT INTO mfi_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ma edda-aara a zu emtakire á duniya na baɗemme keni wá, ázara námpire-aara ge ŋane máki keɗanaakeɗa shifa na á katafke na? ");
INSERT INTO mfi_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Emtu watse aŋkwa názu ura á de várá shifa-aara an ŋane emtu? Ɓaaka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Am zamane na wá, emnde eptsaranveptsa iga ge Dadaamiya, wayarka fetaara áte ŋane. Ay degiya, ma ware una a magaa zherwe am dágáve-aatare ge baa ura-aaruwire, bi ge ndahater elva-aaruwa wá, iya *Ura á emnde baɗemme keni, watse á wiyá zherwe ge baa ŋane ura-aaruwire, má watse yá sawa an malika-aha cuɗeɗɗe, an ƴaikkire á Edderwa.» ");
INSERT INTO mfi_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yaisu a farhe zlaɓe ádaliye ge ndaaterndaha, a ba ŋane á elvan ge itare: «Yá ndaakur ba jirire, á ba am dagave á kure na keni, tá aŋkwa emnde na ni watse tá emtseka ba estuwa, sey máki naránna an ice-aatare Dadaamiya á jáhá emnde á dem kwara-aara an hákuma-aara.» ");
INSERT INTO mfi_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","A magaa hare uŋkwahe am iga á una ŋanna maa, Yaisu a ɗetaa tara Piyer antara Yakuba ira Yuhanna, a dateraa áte ire á wa umele slaɗɗe, ba itare itare áhuwa. Daraada áhuwa maa, a naba eptsavte ge Yaisu am ice-aatare wá, gevge umele ba seke ŋane ka mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Naŋgyuwe-aara gevge dzayye ba telle, tellire-aara an tsaka ire. Naŋgyuwe-aara ŋanna wulwule jipu. ");
INSERT INTO mfi_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Daaci pukura-aha na tá zhárá ba emndu werre, tara *Ailiya antara Muusa, tá aŋkwa ndaha elva antara Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","A ba Piyer á elvan ge Yaisu: «Malum, ŋere keni ŋá aŋkwa áhuna na wá, shagera jipu. Kina wá, ŋá magakurá dzadzawe-aha keƴe, palle náza á ŋa, palle náza á Muusa, palle keni náza á Ailiya.» ");
INSERT INTO mfi_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","A ndaase elva ŋanna ba estuwa, amá diyaaka názena á ndahaná ŋane. Aɗaba itare pukura-aha keƴe ŋanna gazlargazla jipu. ");
INSERT INTO mfi_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Cekwaaŋguɗi wá, a naba tsekwateraarhe ge kumba. Daaci tá cená ba kwara am kumba ŋanna. A ba edda-aara: «Una náwa ŋane na wá, Egdza-aaruwa na ya wayetaa ya. Cenancena názena á bakurná ŋane.» ");
INSERT INTO mfi_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Estuwa ta kante ice wá, ta naa ba Yaisu palle, ɓaaka ura umele ázeŋara. ");
INSERT INTO mfi_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Am sarte na tá átira tsekwa á sa áte ire á wa ŋanna maa, Yaisu a fater magiya, a ba ŋane á elvan ge itare: «Ndawanka názena kwa naaná kure na ma ge ware keni, a njinja á ba am huɗe á kure dem sarte na tsetsa *Ura á emnde baɗemme am faya.» ");
INSERT INTO mfi_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Faransarfe am elva ŋanna, amá a ba itare am dagave-aatare: «Uwe ŋane tsete am faya na a ndahanaa ŋane na?» ");
INSERT INTO mfi_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Aɗaba una ŋanna, ta de ndavanu ge Yaisu, a ba itare: «Labára tá bantsa malum-aha á *tawraita, sey máki eptsaptsa nabi *Ailiya emtsaaɗe?» ");
INSERT INTO mfi_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","A ŋwaterante, a ba ŋane: «Una ba jire-aatare, ba seke una ta ndahanaa itare ŋanna, á eptsa Ailiya emtsaaɗe, á se tsatsanaatsatsa ŋane duksa baɗemme. A ba iya wá, labára a ba wakita á Dadaamiya, watse á shushe zlaɗa kwakya *Ura á emnde baɗemme, watse tá epsawanaapsawa emnde? ");
INSERT INTO mfi_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ay degiya wá, ya ndaakur ba jirire, ndza eptsaptsa Ailiya á sawa, amá emnde ta naba magaa hakuma-aatare áte ŋane. Una ŋanna daada á ba áte una á ndaaná wakita á Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Am sarte na saraasa maa, ta se bera emnde kwakya antara malum-aha á *tawraita áza pukura-aha umele na. Tá aŋkwa gajawe malum-aha á tawraita antara pukura-aha na am dagave-aatare. ");
INSERT INTO mfi_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Baɗemme á emnde na, ba ta naa Yaisu wá, tá maga ba najipu-aara. Ba zhagade ádezeŋara, ta de yainuye an use. ");
INSERT INTO mfi_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","A ba Yaisu á elvan ge pukura-aha-aara: «Kwa gajawe arge uwe kure antara emnde na?» ");
INSERT INTO mfi_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","A ŋwete ge ura palle am dagave á emnde, a ba ŋane: «Malum, ya sakaa egdza-aaruwa egdzere zhele, aɗaba aŋkwa jini am ŋane, á piyante ndaha elva. ");
INSERT INTO mfi_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Jini-aara ŋanna, ma a tsete am tate-ara keni, sey ba á velyanaavelya á dem haha, á kela ugbalyailye, á kerɗa slare, á wulesewule vuwa-aara kaŋgelaŋŋe. Ya ŋala pukura-aha á ŋa ganakini tá ŋgyanseŋgye jini ŋanna am ŋane, amá dzegwaranka.» ");
INSERT INTO mfi_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ba wera we-aara ge Yaisu, a ba ŋane á elvan ge itare: «Amá kure emnde a zamane na wá, ɓaaka fetarfire á kure ɗekiɗeki! Watse yá njá antara kure dem laukte-ara? Yá fakurá ervauŋɗe dem sarte-ara estuwa? Sawiyansa kwa kure egdze ŋanna ge iya!» ");
INSERT INTO mfi_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Daaci ta naba saa egdzere ásezeŋara. Ba a puwete ice-aara áte Yaisu jini na am egdza ŋanna wá, a naba fantau ge slakala am egdzere, a velyaa egdze na am ire, á taɓara egdze na am haha, á kela ugbalyailye am mbuwe-aara. ");
INSERT INTO mfi_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yaisu a ndavanu ge eddeŋara, a ba ŋane: «A fanantau am sarte-ara?» A ba eddeŋara: «A fanantau daga am sarte na zlaɓe egdzere cekwa. ");
INSERT INTO mfi_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ba kelaa ma tsetse jini-aara ŋanna wá, sey ba á maganánmaga palasa. Am sarte umele á eblyanme am kárá, am sarte umele á eblyanme am yawe, á kátá ba já shifa á egdzere. Daaci máki ká dzegwándzegwa wá, tasla á ŋa zaŋervarze, melaŋerumele.» ");
INSERT INTO mfi_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","A ŋwanante ge Yaisu, a ba ŋane á elvan ge ŋane: «Máki yá dzegwándzegwa emtu, a ba ka? Áza edda una ni aŋkwa fetarfire-aara wá, ɓaaka názena ni á gevka na.» ");
INSERT INTO mfi_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kerteŋ ŋwateŋwa eddarge egdzere, a ba an ká kwara a ba ŋane: «Fantarfe, amá á hyepka fetarfire-aaruwa, tasla á ŋa meliyumele am huɗe-aara.» ");
INSERT INTO mfi_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Daaci Yaisu á zhárá ba tá aŋkwa kela emnde ásezetare, a naba valarhe ge jini ŋanna, a ba nane: «Ekka jini na ká piyante ndaha elva ge ura, ká ganve ura makwaya na, ya bakanaa ba iya, sesse am egdze na, ezzlálá, salika á sem ŋane ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","A naba fu hula jini na am egdzere, a slakalme am egdzere, a naba sesehe am ŋane. Amá ba seke ɓaaka shifa am ŋane, haa ta bantsa emnde umele: «Ɓaaka, emtsamtsa egdze na.» ");
INSERT INTO mfi_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Amá Yaisu a ŋanaahe áte erva, a tsante, a naba tsaahe ge egdzere an sera-aara. ");
INSERT INTO mfi_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Am sarte na daraada, ta juwa ba itare antara pukura-aha-aara maa, ta naba ndavanuhe ge pukura-aha, a ba itare tá elvan ge ŋane: «Labara dzegwaŋeranka ŋere ŋgyesaa jini ŋanna?» ");
INSERT INTO mfi_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","A ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Jeba á jini na wá, sey tá ŋgyansá an maduwa.» ");
INSERT INTO mfi_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Daaci tsaretse am tate ŋanna, ba zlálá-aatare á dem tate umele, ta degashe am huɗe á Galili praatte. Am sarte ŋanna wá, ndza wayaaka Yaisu tá diyeddiye emnde tate na tá átekwa. ");
INSERT INTO mfi_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Aɗaba aŋkwa á vaterte sera á elva-aha ge pukura-aha-aara. A ba ŋane á elvan ge pukura-aha-aara: «Iya *Ura á emnde baɗemme wá, watse tá fime am erva ge emnde, tá de já shifa-aaruwa. Amá am hare ge keƴire wá, watse yá tsetse am faya.» ");
INSERT INTO mfi_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ba palle cenaranka pukura-aha elva-aara ŋanna. Amá ge ndavanu elva-aha keni, a wateraa lyawa. ");
INSERT INTO mfi_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Am iga á una ŋanna maa, daraada am Kafarnahum. Am sarte na tá am bere, a ba Yaisu á elvan ge emnde-aara baɗemme: «Ndza kwa gajawe arge uwe kure áte barama?» ");
INSERT INTO mfi_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Amá ta heɗu ba we-aatare, ɓaaka ura á ndaha elva. Aɗaba ndza ta gajawe arge ƴaikkire, geni watse mala ware am dagave-aatare. ");
INSERT INTO mfi_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Daaci a njehe ge Yaisu áte tate a njá, a ɗetaa pukura-aha-aara kelaawa ju buwa, a ba ŋane á elvan ge itare: «Ma ware una á kátá gev slekatafke á kure keni, á ganvege ire-aara ba seke ŋane slekataliya á emnde baɗemme, antara walaaɗi á emnde baɗemme.» ");
INSERT INTO mfi_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Am iga á una ŋanna maa, a eksante egdzere, a se tsanaahe á katafke-aatare am huviye-aara ge ŋane, daaci a ba ŋane á elvan ge itare: ");
INSERT INTO mfi_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Ma ware una a lyevaa egdzere seke una aɗaba elva-aaruwa, edda-aara a lyevaa ba iya an ire-aaruwa. Edda una a lyevaa iya maa, a lyevaa iya ka palle, a lyevaa ba edda una a ɓeliɓela na an ire-aara.» ");
INSERT INTO mfi_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","A ba Yuhanna á elvan ge Yaisu: «Malum, ŋere wá, ŋa naa ura umele á ŋgyá jini-aha am emnde an zhera á ŋa, amá ŋa naba piyante, aɗaba ŋane palle á miya ka.» ");
INSERT INTO mfi_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","A ba Yaisu: «Aꞌaa, piyawanteka. Aɗaba ɓaaka ura a magaa najipu an zhera-aaruwa ni, am iga-aara á valya elva áte iya. ");
INSERT INTO mfi_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aɗaba máki edda-aara dagalaaka tsawe ásete miya wá, ura á miya ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yá ndaakur ba jirire, ma edda-aara a vakurte ba yawe á essha keni, máki a vakurtaa aɗaba zhera-aaruwa geni kwa emnde á *Almasiihu wá, edda-aara á de shansha laɗa-aara.» ");
INSERT INTO mfi_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Zlaɓe ádaliye, a ba ŋane á elvan ge itare: «Má edda-aara mbeɗanaambeɗa palle á egdzara ŋanna ta fetaare áte iya na á dem haypa wá, ámbane tá ŋguɗanem nákwá á há hiya am mbiye, tá eblyanma am haye, á emtsa, ŋgulma ba una ŋanna ge edda-aara. ");
INSERT INTO mfi_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","«Máki erva á ŋa aŋkwa á dáká á dem haypa wá, naba icica áte ka, eblyanveblye ba ƴiƴiye. Ámbane ká dem tate á shifa na á zleka na an erva palle, arge una ká njá an erva-aha á ŋa bukerɗe, amá ká dem kárá á jahanama, kárá na á emtseka ɗekiɗeki na. (( ");
INSERT INTO mfi_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Jahanama ŋanna wá, ma weshege-aara, ma kárá-aara keni, á emtseka ɗekiɗeki.)) ");
INSERT INTO mfi_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Máki sera á ŋa aŋkwa á dáká á dem haypa wá, naba icica áte ka, eblyanveblye ba ƴiƴiye. Ámbane ká dem tate á shifa na á zleka na an ser palle, arge una ká njá an sera-aha á ŋa bukerɗe, amá tá de eblyaká á dem kárá á jahanama na. (( ");
INSERT INTO mfi_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Jahanama ŋanna wá, ma weshege-aara, ma kárá-aara keni, á emtseka ɗekiɗeki.)) ");
INSERT INTO mfi_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Zlaɓe ádaliye, máki ice á ŋa aŋkwa á dáká á dem haypa wá, naba sansese ice ŋanna. Ámbane ká dem zlanna á Dadaamiya an feke palle, arge una ká njá an ice-aha á ŋa bukerɗe, amá tá de eblyaká á dem kárá á jahanama na. ");
INSERT INTO mfi_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Jahanama ŋanna wá, ma weshege-aara, ma kárá-aara keni, á emtseka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Diyaweddiye geni, ma ware keni, á de maraná ba kárá názu am edda-aara, ma emtake, ma emtaŋka keni, ba seke náza elleŋa á maraná ŋane emtakire á ɗale. ");
INSERT INTO mfi_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Elleŋa wá, duksa ŋgelama. Amá máki elleŋa ŋanna ɓaaka ɗaŋɗaŋire-aara mazla-aara mu, tá maganá uwe ganakini á gevge ɗaŋɗaŋe zlaɓe ádaliye? Ɓaaka pute ɗekiɗeki. Aɗaba una ŋanna, marausemare duksa ŋgelama am kure, njawinja an hairire am dagave á kure.» ");
INSERT INTO mfi_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","A naba tsete ge Yaisu am tate ŋanna, a zlálá á dem kwara á Yahudiya. Am Yahudiya, a de ebzu guwa á Urdun. Áhuwa keni de jarammeje emnde kwakya ázeŋara, a fantau ge kwaraterse elva á Dadaamiya, aɗaba ŋane nja-aara ba estuwa. ");
INSERT INTO mfi_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Am sarte ŋanna maa, ta duhe ge *Farisa-aha umele ádezeŋara, ta de ndavanu elva geni tá tsagwaɗaná átekwa. A ba itare tá elvan ge ŋane: «Vantevahe *tawraita barama ge zhele geni á ɓelanaaɓela mukse-aara?» ");
INSERT INTO mfi_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ge vaterte jawápa maa, Yaisu keni a ndavaterundave, a ba ŋane á elvan ge itare: «A bakuraa uwe Muusa áte una ŋanna?» ");
INSERT INTO mfi_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","A ba itare: «Muusa wá, a ƴaa barama geni zhele ŋanna á puwanante nalmesheri á ica nika ge mukse, á vanteva am erva.» ");
INSERT INTO mfi_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Daaci a ba Yaisu á elvan ge itare: «Muusa a puwakurte una ŋanna aɗaba ba degdegire á ire á kure. ");
INSERT INTO mfi_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amá áte una am fakte wá, estuweka. Am fakta, am sarte na Dadaamiya a nderaa duksa baɗemme wá, “a nderaterhe tara zhele an mukse”. ");
INSERT INTO mfi_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Aɗaba una ŋanna zhele á ƴa tara eddeŋara an emmeŋara, tá njá antara mukse-aara. ");
INSERT INTO mfi_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Itare ta buwa ŋanna, tá gevge ba vuwa palle.” Estuwa, ta buweka mazla-aara, tá geva ba vuwa palle. ");
INSERT INTO mfi_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Daaci názena ni a janmaa Dadaamiya wá, a icanveka urimagwe.» ");
INSERT INTO mfi_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Am sarte na tá am bere antara pukura-aha-aara maa, ta naba ndavanu ge pukura-aha á ba áte elva ŋanna zlaɓe ádaliye. ");
INSERT INTO mfi_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","A ba ŋane á elvan ge itare: «Ma ware una zhele, máki a ɓelaa mukse-aara, a de gaa umele, a magaa ba gwardzire, guge haypa an mukse-aara na a ɓelanaa ŋane. ");
INSERT INTO mfi_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ba duksa palle ge mukse keni. Máki a segashe am mba á zhele-aara, a de gaa umele, a magaa ba gwardzire.» ");
INSERT INTO mfi_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Emnde kwakya ta sanaa egdzara ge Yaisu geni á puwaterar erva a barka-aara, amá pukura-aha ta naba valaterarhe ge emnde a sá egdzara ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Amá náterna Yaisu wá, a naba jehe ge ervauŋɗe, a ba ŋane á elvan ge pukura-aha: «Piyawaterteka, ƴawáterƴa, a sarsawa egdzara ásezerwa, aɗaba *kwárá á Dadaamiya náza á emnde na má garevge ba seke itare. ");
INSERT INTO mfi_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yá ndaakur ba jirire: Ma ware edda-aara keni, máki lyevaaka dem kwárá á Dadaamiya ba seke náza á egdzere wá, ŋane á taa demka ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Am iga á una ŋanna, a naba lyevaa egdzara á dem erva-aara, a puwaterar erva, a gaterar barka. ");
INSERT INTO mfi_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Dedde Yaisu áte barama, aŋkwa á zlálá maa, a duhe ge zhele umele ádezeŋara á ba an zhagade, a de kezlaa ugje am sera-aara, a ba ŋane á elvan ge ŋane: «Malum, diyandiya ganakini ka ura mággwe. Naba ndindaha, yá maga tara uwe antara uwe, lauktu yá shá shifa na á zleka na?» ");
INSERT INTO mfi_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","A ŋwanante ge Yaisu, a ba ŋane: «Labára ká ɗahiyá an ura mággwe? Ɓaaka ura mággwe, máki Dadaamiya ka palle. ");
INSERT INTO mfi_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ábi diyakdiya shairiya-aha á Dadaamiya na a ba ŋane: Jeka shifa, maŋka gwardzire, ileka, maŋka seydire á fida áte ura, zlermeka duksa á ura, ɗematerveɗeme tara eddeŋa an emmeŋa. Ábi diyakdiya una-aha ŋanna baɗemme.» ");
INSERT INTO mfi_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","A ŋwete, a ba ŋane: «Una ŋanna kwaye á sawa am egdzarire-aaruwa keni ŋanaaŋa.» ");
INSERT INTO mfi_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","A ɓelanu ice á Yaisu, wayetewaya jipu am ervauŋɗe-aara, a ba ŋane á elvan ge ŋane: «Máki estuwa wá, a ƴakar ba duksa palle. De valuvale názu am rezege á ŋa baɗemme, tegatertega shuŋgu-aara ge talage-aha, ekka watse ká shánsha laɗa-aara am samaya. Daaci sawa ɗabiɗaba.» ");
INSERT INTO mfi_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ba a cenaa una ŋanna wá, puwaapuwa vuwa-aara, ba eptsa iga-aara, a zlálá an dzámá ire campaukkwe, aɗaba nalmane-aara kwakya jipu. ");
INSERT INTO mfi_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Daaci Yaisu a zharaa pukura-aha-aara, a ba ŋane á elvan ge itare: «Kay! Zlazlaɗa jipu geni tá demda emnde a berba am *kwara á Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Palle á názu tá ndahaná pukura-aha ɓaaka, elva ŋanna jauje ge ndzeɗa-aatare. Amá ŋane a fateraarhe zlaɓe ádaliye, a ba ŋane: «Una yá ndaakur ba jirire, zlazlaɗa jipu ganakini tá demda emnde á dem kwara á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Náwa zlazlaɗa ganakini á dedde názlegwame am ɓiye á lipere, amá zlazlaɗa ba náza á sleberba zlaɓe ádaliye ge dem kwara á Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ba ta cenaa una ŋanna pukura-aha wá, tá geja ba ire. A ba itare: «Máki ba estuwa wá, ɓaaka ura á ŋezleseŋzle ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","A zharateraahe ge Yaisu, a ba ŋane á elvan ge itare: «Áza emnde wá, una taa gevka, amá Dadaamiya wá, ɓaaka názu dzegwanka ŋane.» ");
INSERT INTO mfi_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Piyer a eksetaa elva, a ba ŋane á elvan ge ŋane: «Kwaye ŋere, ƴaŋeránƴa duksa baɗemme, ŋá ɗaba ba ka.» ");
INSERT INTO mfi_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","A ŋwete ge Yaisu, a ba ŋane á elvan ge itare baɗemme: «Yá ndaakur ba jirire, ma ware una a ƴaa há-aara, bi egdzar mama-aha-ŋara zala an ŋwasha, bi emmeŋara, bi eddeŋara, bi egdzara-aara, bi fe-aara, máki a ƴanaa aɗaba zhera-aaruwa antara aɗaba labare á higa wá, ");
INSERT INTO mfi_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ba jirire á de shansha zlaɓe ádaliye una-aha ŋanna baɗemme ma huɗe deremke keni; ma bere, ma egdzar mama-aha-ŋara zala an ŋwasha, ma emmeŋara, ma egdzara-aara, ma fe-aha. Baɗemme á de shansha zlaɓe ádaliye á ba am duniya na. Amá wá, zlaɗa keni á shushe. Á katafke á de shá shifa na á zleka na. ");
INSERT INTO mfi_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Amá emnde kwakya ta zuŋŋwa ba itare kina, tá de gev emnde a kataliya. Emnde kwakya tá am kataliya kina, watse tá gev emnde a katafka ba itare.» ");
INSERT INTO mfi_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tara Yaisu antara pukura-aha-aara tá áte barama á ɗala á dem Urusaliima. Yaisu wá, ŋane á katafke, pukura-aha-aara tá aŋkwa ɗabaná á kataliya, ta ƴiƴiye cekwaaŋguɗi antara ŋane. Pukura-aha-aara tá á ba an lyawa am vuwa. Dikele á emnde na tá ɗabaterɗaba na keni, tá á ba an lyawa ŋanna. Yaisu a ɗante pukura-aha-aara zlaɓe ádaliye ádezeŋara, a ndaaterahe zlaɓe ádaliye názena watse á de shá ŋane, ");
INSERT INTO mfi_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","a ba ŋane á elvan ge itare: «Duwa á miya á dem Urusaliima kina na wá, iya *Ura á emnde baɗemme tá de eksivaksa, tá de vite ge male-aha á *liman-aha antara malum-aha á *tawraita. Tá de ndahaná itare geni a jareja shifa-aaruwa. Daaci tá de fime am erva ge emnde na ɓaaka nadina-aatare, ");
INSERT INTO mfi_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","tá de zlazlisá itare, tá de kyafiyar itare nyaihe, tá de ziyá itare an ja, tá de janá itare shifa-aaruwa. Amá am hare ge keƴire wá, watse yá tsetse am faya.» ");
INSERT INTO mfi_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Am iga á una ŋanna maa, ta duhe ge egdzara á Jaibaidaiyus, tara Yakuba an Yuhanna, ádeza Yaisu. A ba itare tá elvan ge ŋane: «Malum, náwa ŋa se ŋala ázeŋa, máki ŋá shansha barama-aara.» ");
INSERT INTO mfi_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","A ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Kwá kátá uwe kure ázerwa?» ");
INSERT INTO mfi_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","A ba itare: «Máki á ɓashaŋerɓasha ervauŋɗe á ŋa wá, má watse de njakiinja am ƴaikkire á ŋa wá, ŋá kátá palle á ŋere á de njá am naɗafa á ŋa, palle á ŋere keni á de njá am názlaɓa á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","A ŋwaterante ge Yaisu, a ba ŋane: «Ábi diyakurka wedere á kure na ma andze kwá ndava ŋane na. Kina wá, watse kwá dzegwándzegwa emtu sha zlaɗa áte náza-aaruwa na watse yá essha na? Zlaɓe ádaliye, watse kwá dzegwándzegwa emtu sepá názena watse yá sepaná ya am vuwa-aaruwa na?» ");
INSERT INTO mfi_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ta naba ŋwanante: «Ŋá dzegwándzegwa,» a ba itare. A ŋwaterante ge Yaisu: «Shagera,» a ba ŋane á elvan ge itare: «Watse kwá de shá zlaɗa á ba áte náza-aaruwa, watse kwá de sepá názena yá de sepaná ya am vuwa á kure. ");
INSERT INTO mfi_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Amá elva a de njá am naɗafa-aaruwa antara názlaɓa-aaruwa wá, am erva-aaruweka una ŋanna. Sleɗe-aha ŋanna náza emnde na ni Dadaamiya a tsatsaterán ge itare.» ");
INSERT INTO mfi_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","De cenaráncena una ŋanna pukura-aha umele kelaawa na maa, ta naba ica ervauŋɗe áte tara Yakuba antara Yuhanna. ");
INSERT INTO mfi_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Cenáncena Yaisu, a ɗaaterte baɗemme-aatare ádezeŋara, a ba ŋane á elvan ge itare: «Náwa diyakurdiya ganakini emnde na ta slekse-aha á larde ba itare am duniya na wá, tá aŋkwa á kwárá larde-aha-aatare an márá hákuma áte emnde. Male-aha á ekse keni, tá aŋkwa á márá hákuma-aatare am ekse. ");
INSERT INTO mfi_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Amá jeba á una ŋanna wá, a gevka am dagave á kure. Ma ware una á kátá gev male keni, arge una ŋanna wá, a gevge ba seke walaaɗi á kure. ");
INSERT INTO mfi_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma ware una á kátá gev slekatafke á kure keni, a gevge ba seke nave á kure. Malira ba una ŋanna am ice á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aɗaba ba iya *Ura á emnde baɗemme keni, sanka geni tá se magina emnde slera, amá iya una ya se magateraa slera ge emnde, ya se ƴá shifa-aaruwa, geni yá lyelye emnde ba kwakya.» ");
INSERT INTO mfi_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mazla-aara maa, daraada am Yairikau. Am sarte na tá aŋkwa á zlálá am ekse ŋanna tara Yaisu antara pukura-aha-aara maa, kwakya emnde na ta ɗabaterɗaba. Aŋkwa ura wulfe zhera-aara Bartimawus egdza á Timawus, a njehe áte baráma na tá aŋkwa ɗabaná itare na, ge ŋala áza emnde. ");
INSERT INTO mfi_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Am sarte na cenáncena ganakini ba Yaisu ura Nasarátu una á degashe na, a fantau ge ɗaha Yaisu á ba an ká kwara, a ba ŋane: «Yaisu *Egdza á Dawuda, tasla á ŋa zivarze.» ");
INSERT INTO mfi_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kwakya emnde na ta valarhe, ta banaa a ɗuɗe, amá ŋane a far ká kwara, a ba ŋane: «Egdza á Dawuda, tasla á ŋa zivarze.» ");
INSERT INTO mfi_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Daaci a tsaahe ge Yaisu, a ba ŋane: «Ɗauɗaha, á sawa.» Ta de ɗante wulfe na, a ba itare tá elvan ge ŋane: «Ehhiga kwa mazla-aara, kwaye á ɗakɗaha, sawa ásezeŋara.» ");
INSERT INTO mfi_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","A naba tsetehe á ba áte watsewatsire, a puwanve kacekaca-aara, a duhe á ba an zhagade. ");
INSERT INTO mfi_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Daada áza Yaisu, a ba Yaisu á elvan ge ŋane: «Ká kátá yá magaká estara kina?» A ŋwanante ge wulfe, a ba ŋane: «Yá kátá ba ice, malum-aaruwa.» ");
INSERT INTO mfi_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","A ba Yaisu á elvan ge ŋane: «Naba zlálá á da, mbakaambe fetarfire á ŋa.» Ba seke ndaha á miya na, shansha ice-aara, a ɗabete Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Herzharanteherzhe Urusaliima am dalbe á ekse-aha buwa tara Baytifaji antara Baytaniya, tá áte vuwa á Wa Anyaranyara maa, Yaisu a ɓelaa pukura-aha-aara buwa á de katafke. ");
INSERT INTO mfi_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","A ba ŋane á elvan ge itare: «Dawmbare á dem ekse na kwaye á katafke á miya na wá, ba tara demda á kure wá, kwá de bera egdza á ezzeŋwa an ŋguɗa, zlaɓe njateka ura áte iga-aara, naba pelawaapele, sawiyansa. ");
INSERT INTO mfi_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Máki ura a bakuraa, kwá maga uwe kure, bawananba ge edda-aara geni a ndavanaa Yaakadada, watse á eptsakurnaptsa zlaɓe ádaliye.» ");
INSERT INTO mfi_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mazla-aara ta naba zlala, ta de bera ezzeŋwa áte ŋguɗa áte wakyiya á ura herzhe an we á baráma, ta naba eppela. ");
INSERT INTO mfi_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ta ndavateru ge emnde na tá áhuwa, a ba itare: «Labára kwá pelá ezzeŋwa na?» ");
INSERT INTO mfi_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ta ŋwaterantehe, ta bateraa elva na a ndaateraa Yaisu na, daaci ta naba ƴaterhe ge emnde ŋanna, ta sawa an ŋane. ");
INSERT INTO mfi_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ta sanaa ezzeŋwa na ge Yaisu, ta ndakete kacekaca-aha-aatare áte iga á ezzeŋwa ŋanna, lauktu a njetaa Yaisu átekwa. ");
INSERT INTO mfi_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Emnde kwakya ta pelanse kacekaca-aha-aatare áte baráma, emnde umele ta ɗatsaa hyema á debina am fe, itare keni ta se pelanse. ");
INSERT INTO mfi_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Daaci ma emnde na tá á katafke á Yaisu, ma emnde na tá am iga-aara keni, baɗemme-aatare tá leva ba hula, a ba itare: «Dadaamiya wá, Slekse. A ganga barka ge edda una á sawa an zherá á Yaakadada na. ");
INSERT INTO mfi_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","A famfe Dadaamiya barka am kwárá á wulfe á eggyemiya *Dawuda na watse mí njá am huɗe-aara na. Dadaamiya am samaya wá, Sleksa ba ŋane palle.» ");
INSERT INTO mfi_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Daaci a dem ge Yaisu á dem huɗe á Urusaliima, a zlálá ba suuwe á dem *mashidi ƴaikke. De zharanaazhara názu am mashidi maa, ba segashe-aara, ta naba eptsa á dem Baytaniya antara pukura-aha-aara, aɗaba aŋkwa á sawa vaƴiya. ");
INSERT INTO mfi_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Makuralla-aara maa, ta naba segashe am Baytaniya, tá aŋkwa á eptsa zlaɓe ádaliye. Ate baráma maa, ŋanaaŋa waya Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A naa mama á nabugda an hyema átekwa ƴiƴiye cekwaaŋguɗi an itare, a naba duhe geni ámbane aŋkwa egdzere átekwa. Duwa-aara á dem ekte á nabugda ŋanna, amá shanka ba názara keni átekwa, sey a jauwa ba hyema, aɗaba sarte a yá á nabugdeka. ");
INSERT INTO mfi_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Daaci a ndaase elva-aara áte nabugda ŋanna, a ba ŋane: «Ekka wá, gaɗɗiru tá nánka egdzere áte ka mazla-aara.» Cenarancena pukura-aha una ŋanna baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Am sarte na daraada am Urusaliima maa, Yaisu a de á ba am *mashidi ƴaikke. Daduwa á dem mashidi maa, a de beraa emnde a válá kazlaŋa antara emnde a shekwa-aara am huɗe-aara, a naba ŋgyaterse ásegashe. A zaɗanve tabel-aha á emnde a peteke, antara kurshi-aha á emnde a válá takala masar. ");
INSERT INTO mfi_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","A piyaterte ge emnde a degashe an kazlaŋa am huɗe á mashidi, ge dáná á dem tate umele. ");
INSERT INTO mfi_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Daaci a fantau ge kwaraterse názu am wakita á Dadaamiya, a ba ŋane: «Aŋkwa an puwa am wakita á Dadaamiya, a ba Dadaamiya: Bere-aaruwa wá, tá ɗahaná an bere á mága maduwa á emnde baɗemme. Amá kure, kwa ganve hwalakwa á nabera-aha.» ");
INSERT INTO mfi_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ba ta cenaa una ŋanna male-aha á *liman-aha antara malum-aha á *tawraita wá, mazla-aara ta naba fantau ge mága pute-aatare ge keɗa shifa á Yaisu. Damda lyawa am itare, aɗaba baɗemme á emnde hayaranhaya jipu elva na a kwaratersaa ŋane. ");
INSERT INTO mfi_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Eblyablya vaci maa, ba degashe Yaisu am huɗe á berni antara pukura-aha-aara baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Makuralla-aara an eŋlya-waabere maa, ta naba eptsehe zlaɓe ádaliye, tá sem berni. Am sarte na tá áte baráma á sawa maa, ta naa nabugda na welasewele antara uksuwe-aara baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","A naba yehete ge Piyer elva na a ndaasa Yaisu áte nabugda ŋanna. Daaci a ba ŋane á elvan ge ŋane: «Malum, ezzhárá emtsaaɗe, nabugda na ka nyainyaivaa ka áwaya na, emtsamtsa baɗemme.» ");
INSERT INTO mfi_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Daaci a ba Yaisu á elvan ge pukura-aha-aara baɗemme: «Yá ndaakur ba jirire, máki fakurtarfe an Dadaamiya wá, ");
INSERT INTO mfi_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ma kwa banán ba ge wa na náwa ŋane na: Tsetse áhuna, de eblyememblye am haye keni, á naba gevge. Máki magakurka shaige, fakurtaarfe á ba an jirire geni názena kwá ndavaná kure á de gevge wá, ba á gevge ŋanna aɗaba kure. ");
INSERT INTO mfi_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Aɗaba una ŋanna yá ndaakur ba jirire, máki kwá ƴeká duksa wá, fawtarfe ba seke shakuránsha duksa ŋanna zlauzle, sey ba kwá shansha. ");
INSERT INTO mfi_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Daaci máki kwá aŋkwa á maga maduwa, amá diyakurdiya ganakini aŋkwa slehaypa an kure wá, naba ƴawanarƴe, Eddekure na am samaya na á de ƴakuraarƴe ge kure keni. (( ");
INSERT INTO mfi_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Amá má kure kwá ƴateraarka ge emnde wá, Eddekure na am samaya na, á ƴakuraarka ge kure keni.»)) ");
INSERT INTO mfi_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Saremsa zlaɓe ádaliye á sem Urusaliima maa, ta naba dem *mashidi ƴaikke. Yaisu aŋkwa á jaɗaba am mashidi ŋanna, ta naba duhe ge male-aha á *liman-aha antara malum-aha á *tawraita ira male-aha á larde ádeza Yaisu, ");
INSERT INTO mfi_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ta de ndavanu elva, a ba itare: «Ka shanaa áme hákuma á mága duksa-aha na? Emtu a vaktaa ware baráma-aara?» ");
INSERT INTO mfi_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","A ŋwaterante ge Yaisu, a ba ŋane: «Iya keni, yá ndavakurundave duksa palle. Máki vakuriteva jawápa wá, iya keni yá ndaakurse tate na ni ya shaa hákuma átekwa.» ");
INSERT INTO mfi_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Daaci a ba ŋane á elvan ge itare: «A ɓelanaa ware Yuhanna ge se magaterá baptisma ge emnde? Dadaamiya emtu, emndimagwaha he? Vawiteva jawápa.» ");
INSERT INTO mfi_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ta fantau ge ndahanaa am dagave-aatare emtsaaɗe: «Má mi banaa a ɓelanaa Dadaamiya, watse á bamiya: Labára fakurtaareka an ŋane? ");
INSERT INTO mfi_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Má mi banaa ta ɓelanaa ba emndimagwaha keni, zlazlaɗa zlaɓe.» Ta kuva emnde jipu aɗaba baɗemme á emnde fartarfe ganakini Yuhanna nabi á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Aɗaba una ŋanna, «Diyaŋerka», a ba itare tá elvan ge Yaisu. A ba Yaisu á elvan ge itare: «Iya keni yá ndaakurka náza-aaruwa ma ya shaa hákuma á mága duksa-aaruwa áza ware keni.» ");
INSERT INTO mfi_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Am iga a una ŋanna maa, Yaisu a vaterte elva an naraje na. A ba ŋane á elvan ge itare: «Aŋkwa ura umele a ica fe-aara, a dzeɓaa náfá á inabauhi am huɗe-aara, a jantaave an dala, a magaa tate á ɓeca egdza a náfá, ira bere á edda á ufa fe ŋanna, daaci a ƴateraa fe ŋanna baɗemme am erva ge emnde a slera, ŋane a daa shula. ");
INSERT INTO mfi_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Samsa sarte á egdza a náfá maa, a naba ɓelaa palle á emnde a slera-aara áseza emnde na a ƴateraa fe am erva na, geni á se lyanvaalya dzaaŋara am egdzara á náfá na. ");
INSERT INTO mfi_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Amá itare, ta naba eksevaa sleslera ŋanna, ta zuhe an já, ta ɓelanaahe an erva dey. ");
INSERT INTO mfi_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Edda á fe a naba ɓelaa sleslera-aara umele. Ŋane keni ta se zlazlese, ta kyanmaarhe. ");
INSERT INTO mfi_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Edda á fe na a naba ɓelaa sleslera-aara zlaɓe ádaliye. Ŋane wá, ta se jaa ba shifa-aara. Kwaye ŋane názena ta magaterte ge emnde a slera á edda á fe. Umele ta shanu ba zlaɗa, umele ta jaa ba shifa-aara. ");
INSERT INTO mfi_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","A jauwa ba ura palle áza edda á fe ge eɓɓela-aara, egdza-aara ba ge ŋane wayaawáyá jipu na. Am iga-aara a ɓelaa ba ŋane. A ba ŋane: “Egdza-aaruwa ba ge iya na wá, sey tá de fá zherwe áte ŋane.” ");
INSERT INTO mfi_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","De samsa egdza-aara ŋanna maa, a ba emnde a kwara fe am dagave-aatare: Yawwaa, kwaye samsa edda una watse á zaná ŋane waráta á fe á miya na. Gwawamiyargwe, jaumiya shifa-aara, fe-aara ŋanna á de gev ba náza á miya. ");
INSERT INTO mfi_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Daaci ta eksevaa egdza-aara ŋanna, ta naba jaa shifa-aara, ta de eblyanve áte iga á dala.» ");
INSERT INTO mfi_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Daaci a ndavateru ge Yaisu, a ba ŋane á elvan ge itare: «Kina wá, watse á magaterá uwe edda á fe ge emnde a kwara fe ŋanna? Ay degiya watse á se ceɓa emnde ŋanna baɗemme, á faterem fe-aara am erva ge emnde umele. ");
INSERT INTO mfi_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Aŋkwa naraje am wakita á Dadaamiya, a ba ŋane: Ba nákwá ŋanna ta eblyanvaa emnde a nyáŋa bere na una, a eksantehe ge Dadaamiya, a ganve nákwá na á ŋáná ŋane ndzeɗa á bere ŋanna baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kwaye ŋane názena a maganaa Yaakadada, shagera ge miya, máki namiyanna duksa ŋanna. Ábi ndaakursende naraje ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Male-aha á Yahudiya-aha tá kátá eksa Yaisu á ba am sarte ŋanna, aɗaba diyardiya ganakini á ɓálá nákwa ŋanna á ba áte itare. Amá a wateraa lyawa átuge emnde, daaci ba tse-aatare, ta naba zlálá, ta ƴanhe. ");
INSERT INTO mfi_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Daaci ta de magaa sawari-aatare, ta ɓelanve *Farisa-aha antara emnde á sleksu *Hirudus, ge de ndavanu elva tá tsagwaɗaná an ŋane. ");
INSERT INTO mfi_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ta duhe ge emnde ŋanna, a ba itare tá elvan ge Yaisu: «Malum, diyaŋerdiya geni ekka wá, ka slejirire, ɓaaka lambe á ŋa átuge ice á emnde, ɓaaka lambe á ŋa áte ŋgahire á urimagwe keni. Ka, ká kwaraterse ba uŋŋule á Dadaamiya ge emnde. Ndaaŋernda ba jirire, am *tawraita á miya mu, aŋkwa emtu baráma á puwaná hadáma ge male á larde á Rauma, ɓaaka he? Ɓuweka ɗekiɗeki, ŋá eppuwa emtu, ŋá puweka he?» ");
INSERT INTO mfi_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Amá diyaadiya Yaisu názena a satersa na. Daaci a ba ŋane á elvan ge itare: «Labára kwá tsagwaɗitságwaɗa? Sawiyansa shuŋgu yá nanaana.» ");
INSERT INTO mfi_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ta naba de sanaa shuŋgu na. A ba Yaisu á elvan ge itare: «Nderáva á ware una áte shuŋgu na? Ira zhera na, zhera á ware?» Ta ŋwanante, a ba itare: «Náza á male á larde á Rauma.» ");
INSERT INTO mfi_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","A ba Yaisu á elvan ge itare: «Daaci má estuwa wá, puwawanpuwa ge male á larde názu zlaya-aara, ge Dadaamiya keni názu zlaya-aara.» Baɗemme-aatare tá maga ba najipu á jawapa-aara ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Daaci ta duhe ge *Saduki-aha keni ádeza Yaisu. Ba itare emnde na tá bantsa itare, ɓaaka tse á emnde am faya na. Ta se ndavanu elva, a ba itare: ");
INSERT INTO mfi_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Malum, aŋkwa a puwamitaa Muusa, a ba ŋane: má keɗaakeɗa egdza emmeŋara ge ura, a ƴaa mukse ɓaaka egdzere wá, a melesemele egdza emmeŋara ge zhele-aara mukse ŋanna, a fanfa wulfe ge egdza emmeŋara na keɗaakeɗa na. ");
INSERT INTO mfi_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Iyau, ndza tá aŋkwa dawalaa vuye ta egdzar mama, duwa á makaji-aatare, a gaa gyaale, amá a naba keɗehe, a ƴaa mukse na, ɓaaka egdzere. ");
INSERT INTO mfi_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Daaci a naba melese ge sleɗába-aara mukse na, ŋane keni a naba keɗehe, a ƴaa mukse na ɓaaka egdzere. A melese ge keƴire-aatare keni, ŋane keni ba lahe ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Itare vuye na ta gaa ba mukse ŋanna palle, amá ɓaaka ura a yaa egdzere an ŋane, lauktu á keɗá. Am iga-aatare, a keɗa ge mukse na keni. ");
INSERT INTO mfi_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Vaci tse á emnde am faya mu, watse átuge ware mukse na palle? Aɗaba itare vuye na ndza mukse-aatare ba ŋane palle!» ");
INSERT INTO mfi_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","A ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Kure jakuraaveje áte baráma a jirire. A jakuraa uwe áte barama? Aɗaba diyakurka názu am wakita á Dadaamiya, diyakurka ndzeɗa á Dadaamiya keni ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Aɗaba máki tsarettse emnde am faya wá, ɓaaka gá mukse, ma ŋwasha keni ɓaaka de gá zhele mazla-aara. Emnde baɗemme tá de njá ba seke malika-aha am samaya. ");
INSERT INTO mfi_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Elva a tse á emnde am faya maa, ndaakurseka názena a puwetaa Muusa áte elva a dake emtu? Aɗaba a ba Dadaamiya á elvan ge Muusa áte eggye-aha á kure werre wá: Ba iya una ya Dadaamiya á Ibrahima, ya Dadaamiya á Isiyaaku, ya Dadaamiya á Yakubu. ");
INSERT INTO mfi_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Daaci máki estuwa wá, tá á ba an shifa-aatare emndu werre. Aɗaba Dadaamiya wá, ŋane Dadaamiya á emnde na tá an shifa, Dadaamiya á emnde na ni tá an emtseka. Daaci diyaweddiye ganakini jakuraaveje ba jirire.» ");
INSERT INTO mfi_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Aŋkwa malum á *tawraita umele, a cenanaa á ba an hyema-aara názena ta ndaana tara Yaisu antara *Saduki-aha maa, ŋane a nanna ganakini ŋwaterteŋwa Yaisu shagera. Daaci ŋane keni a naba duhe an ndava-aara ádezeŋara, a ba ŋane á elvan ge ŋane: «Ƴaikka ura-ara am shairiya-aha á Dadaamiya baɗemme?» ");
INSERT INTO mfi_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","A ŋwanante ge Yaisu, a ba ŋane á elvan ge ŋane: «Eccena kwa, náwa yá ndakndaha: Cenevaacena elva na ba shagera *Iserayiila! Yaakadada Dadaamiya á miya wá, ba ŋane palle una Yaakadada. ");
INSERT INTO mfi_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ewwáya Yaakadada Dadaamiya á ŋa an ervauŋɗe á ŋa baɗemme, an shifa á ŋa baɗemme, an eŋkale á ŋa baɗemme, ira an ndzeɗa á ŋa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Eccena zlaɓe ádaliye náwa buwire-aara: Ewwáya sleriya á ŋa ba seke ire á ŋa. Ɓaaka una á ju ge una-aha ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","A ba malum á tawraita na á elvan ge Yaisu: «Una wá, ŋwakteŋwa shagera, malum. Elva á ŋa na ba kalkale-aara. Yaakadada wá, ba ŋane palle una Dadaamiya, ɓaaka umele. ");
INSERT INTO mfi_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Shagera ba urimagwe á wáyá Dadaamiya-aara an ervauŋɗe-aara baɗemme, an eŋkale-aara baɗemme, an ndzeɗa-aara baɗemme, ira á wáyá sleriya-aara ba seke ire-aara. Ƴaikka ba una ŋanna arge sadake á dabba-aha, antara sadake á duksa-aha umele na tá vante ge Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nanna Yaisu ganakini a ŋwanante á ba an uŋŋule-aara, a ba ŋane á elvan ge ŋane: «Ekka wá, a ƴakar ba kapáka palle ge dem *kwara á Dadaamiya.» Am iga á una ŋanna, ɓaaka ura a kwamaa ndavanu elva mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Daaci Yaisu aŋkwa á kwaraterse elva á Dadaamiya ge emnde am *mashidi ƴaikke maa, a naba ndavateruhe, a ba ŋane: «Ta bantsa malum-aha á *tawraita *Almasiihu wulfe á *Dawuda mu, a sawa estara? ");
INSERT INTO mfi_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aɗaba ndza a banba Dawuda an hákuma á Sheɗekwe Cuɗeɗɗe, a ba ŋane: A ba Yaakadada á elvan ge Yaakadada-aaruwa: Njinja am naɗafa-aaruwa, dem sarte na má ganatervege kelaade-aha á ŋa tate á puwa sera á ŋa. ");
INSERT INTO mfi_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawuda an ire-aara a ɗahanaa an Yaakadada. Ay á sawa estara kena ni á gev wulfe-aara na?» Baɗemme á dikele á emnde ŋanna, ta cenanvaa á ba an higa. ");
INSERT INTO mfi_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Daaci am sarte na aŋkwa á vaterte sera á elva-aha, a ba ŋane á elvan ge itare: «Faufa hyema am ire á kure áza malum-aha á *tawraita. Aɗaba itare ta emnde a waya marava am zane saɗaɗɗe, tá kátá emnde tá gater use an ga ire am dagave á zlamaha. ");
INSERT INTO mfi_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Am mashidi keni maa, tá kátá ba sleɗe na átire ge náza á emnde baɗemme na. Ma am muŋri keni, itare sey tá de kátá ba sleɗe na ni an dárádza jipu na. ");
INSERT INTO mfi_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Emnde a za ŋwasha wegyege áte há keni ba itare. Daaci tá slaɗanve maduwa-aatare ákatafke á emnde wá, geni ta emnde a jirire ágire. Itare zlaɗa-aatare á de jauje ge náza á emnde baɗemme vaci shairiya.» ");
INSERT INTO mfi_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Daaci a njehe ge Yaisu herzhe an nakwati na tá puwa sadake á nasherire á dem huɗe-aara na, á zhárá emnde tá aŋkwa puwa sadake á dem nakwati na. Á zhárá dikele á emnde a berba, tá puwa sadake-aatare wá, sadake-aatare kwakya jipu. ");
INSERT INTO mfi_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Am iga-aatare maa, a tsetehe ge wegyege a mukse umele ŋane taláge, a de puwum kwaɓa-aara buwa. ");
INSERT INTO mfi_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Daaci Yaisu a ɗante pukura-aha-aara, a ba ŋane á elvan ge itare: «Yá ndaakur ba jirire: Wegyege a mukse na kwaya ŋane talage ba jipu na wá, ŋane a puwum názá-aara, jauje ge náza á emnde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Aɗaba itare wá, kwakya nalmane-aatare ta saa ba cekwa-aara ge sadake á nasherire. Amá mukse na wá, ŋane talage. Ɓaaka tsa umele, amá a naba saa názu am rezege-aara baɗemme.» ");
INSERT INTO mfi_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Saresse am *mashidi ƴaikke maa, a ba pukura-aara umele á elvan ge ŋane: «Malum ezzhara emtsaaɗe jeba á nderáva á mashidi na, ƴaikkire-aara antara zariyire á nákwa-aha-aara na baɗemme.» ");
INSERT INTO mfi_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","A ŋwanante ge Yaisu, a ba ŋane á elvan ge ŋane: «Ká nanna una ŋanna baɗemme na wá, watse á mbeɗa baɗemme, ba nákwa palle keni watse á jauka áte ukfeŋara nákwa.» ");
INSERT INTO mfi_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","De njaanja Yaisu áte ire á Wa Anyaranyara am ndaŋŋire á *mashidi ƴaikke. Pukura-aha-aara tara Piyer an Yakuba, Yuhanna ira Andere, itare wá, tá aŋkwa ázeŋara. Ta ndavanuhe ge pukura-aha-aara ŋanna, a ba itare tá elvan ge ŋane: ");
INSERT INTO mfi_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Ndaŋerndaha watse á magava am sarte-ara una ŋanna? Watse ŋá dise áte uwe ganakini herzhe á magava duksa-aha ŋanna?» ");
INSERT INTO mfi_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Daaci a ba Yaisu á elvan ge itare: «Kure wá, faufa ba hyema, a se keɗarakuraaka emnde umele. ");
INSERT INTO mfi_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Aɗaba watse kwakya emnde na tá de sawa an zhera-aaruwa, ma ware keni á se ba: Ya ŋane ba iya. Daaci tá se keɗa emnde kwakya. ");
INSERT INTO mfi_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Watse kwá cenáncena labare á wáva-aha am larde-aha na ba herherzhe an kure, antara am larde-aha na ƴiƴiye an kure, amá gazlauka ɗekiɗeki. Sey á magaavemage una-aha ŋanna, amá zlaɓe zle á duniya ka emtsaaɗe. ");
INSERT INTO mfi_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Watse larde umele á de darge larde umele an wáva. Emnde á slekse umele, tá de darge kwara á slekse umele an wáva. Á de gejava haha am tate-aha gergere, á de demda waya am larde-aha gergere. Una-aha ŋanna wá, zlaɓe ba fakta á zlaɗa emtsaaɗe, ba seke náza á mukse na fanantaufe zlaɗa á ya. ");
INSERT INTO mfi_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Amá kure wá, faufa hyema ba shagera áte ire á kure. Aɗaba watse tá dákurá á de katafke á shairiya, tá de slerpákurá an ja am mashidi-aha-aatare. Watse tá de tsákurá á katafke á male-aha á duniya, tá de tsákurá á katafke á slekse-aha aɗaba zhera-aaruwa. Estuwa, kure keni kwá de ndaasendahe seydire áte iya á katafke-aatare. ");
INSERT INTO mfi_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Amá wá, sey máki cenaráncena emnde labare á higa am jeba-aha á emnde na tá am duniya baɗemme, lauktu á zla duniya. ");
INSERT INTO mfi_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Am sarte na ni watse tá dákurá á de katafke á shairiya na wá, dzamauka ire á názena kwá de ndaaná kure, de ndaundaha ba názena ni á de semsa á sem ire á kure am tate ŋanna. Aɗaba una ŋanna elva á kure ka, á de vakurta ba Sheɗekwe Cuɗeɗɗe. ");
INSERT INTO mfi_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Am sarte ŋanna maa, emnde umele tá de vaterta ba itare an erva-aatare egdzar mama-aha-aatare ge emnde, geni a de ceɓarateraaceɓa. Dada-aha keni tá de vaterta ba itare egdzara-aatare ge emnde, geni a de ceɓarateraaceɓa. Egdzara umele keni tá de daterar ge dada-aha-aatare antara mama-aha-aatare, tá de ceɓa ba shifa-aatare. ");
INSERT INTO mfi_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Emnde baɗemme tá de dá ba kelaadire ádete kure aɗaba zhera-aaruwa. Amá edda una tsaatse shagera dem halavuwa-aara wá, á lyelye shifa-aara.» ");
INSERT INTO mfi_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Watse kwá nanna duksa na ni tá ɗaháná an shagerkire emtaŋka ɗekiɗeki na am tate na zlaya-aara ka. (Ma a ndaasa ware elva-aaruwa na keni, a cenevaacena elva ŋanna ba shagera). Vacite na ni má nakuranna duksa ŋanna wá, watse kyaakya ge emnde na tá am Yahudiya, tá zlerda zhagade á dem huɗe á wa. ");
INSERT INTO mfi_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Edda una áte ire á bere keni, a tsuŋka á dem huɗe á bere ge hálá kazlaŋa-aara. ");
INSERT INTO mfi_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Edda una am fe keni, a eptseka á sá ge se hálá naŋgyuwe-aara. ");
INSERT INTO mfi_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Watse á tsaame kwa zlaɗa á ŋwasha na watse tá á huɗe am sarte ŋanna, antara ŋwasha na tá an egdzara áte erva na! ");
INSERT INTO mfi_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ŋalauŋála Dadaamiya ganakini a gevka lámare ŋanna am sarte á ekhye. ");
INSERT INTO mfi_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Aɗaba watse kwakya jipu zlaɗa am sarte ŋanna. Ta nderaa estuwa duniya daga am fakta sem vatena, jerka jeba á zlaɗa ŋanna ɗekiɗeki. Á de jerka keni zlaɗa na ni ta kalle an una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ma andze gulanaaka Dadaamiya hare-aha á zlaɗa ŋanna wá, ma andze á jauka ura an shifa ba palle keni. Amá a naba gulanaahe ge Dadaamiya aɗaba emnde na a dzeratersaa ŋane tá átuge ŋane na. ");
INSERT INTO mfi_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Daaci am sarte ŋanna, ma a bakurnaa ware: Náwa aŋkwa *Almasiihu áhuna, bi kwaye aŋkwa áhuwa, lyiyauka elva ŋanna ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Aɗaba watse tá jesaareje almasiihu-aha fida, antara nabi-aha fida am sarte ŋanna. Watse tá maga nalaama-aha antara najipu-aha gergere, geni ambane tá keɗateraakeɗa emnde na ni a dzeratersaa Dadaamiya na áte eŋkale. ");
INSERT INTO mfi_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kure wá, faufa hyema ba shagera, aɗaba fanakuremfa am vuwa zlauzle.» ");
INSERT INTO mfi_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Am iga a hare-aha á zlaɗa ŋanna maa, vaciya á de gevge daŋŋwe baɗemme, tere keni á de máreka parakkire-aara, ");
INSERT INTO mfi_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","terlyakwa-aha keni watse tá geda á sem áhá, baɗemme á ndzeɗa á názena áte samaya á de gejavtegeje ba ŋarŋare sleɗe. ");
INSERT INTO mfi_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Daaci watse tá zhárá ba iya *Ura á emnde baɗemme yá aŋkwa á sawa áte kumba, yá sawa an hákuma ƴaikke antara ɗemɗemire. ");
INSERT INTO mfi_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Watse yá ɓela malika-aha-aaruwa á dem karáfke-aha á duniya ufaɗe kerɗe, tá jatermaare ge emnde na ya dzeratersaa ya na á sawa am tate-aha baɗemme.» ");
INSERT INTO mfi_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Diyaweddiye á ba áte mama á nabugda. Máki kwa nanna gedaageda hyema átekwa, ƴaaƴa umele aŋwaslire wá, diyakurdiya ganakini herzhavteherzhe madare. ");
INSERT INTO mfi_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Una keni ba duksa palle. Máki aŋkwa á magava duksa-aha ŋanna wá, diyaweddiye ganakini iya keni yá á ba áte we á sera mazla-aara ge sawa. ");
INSERT INTO mfi_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yá ndaakur ba jirire: emnde a zamane na tá de zlauka ba estuwa, sey máki naranna duksa-aha ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tara samaya an haha wá, tá nabe keɗa, tá zlauzle. Amá elva-aaruwa wá, á keɗeka ɗekiɗeki, sey má gevge.» ");
INSERT INTO mfi_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Amá elva á hárá á bere, antara sarte ŋanna wá, ɓaaka slediya-aara ɗekiɗeki. Ma malika-aha am samaya, ba *Egdza á Dadaamiya keni diyaaka, sey diyaa ba Dadaamiya palle ŋane Dada. ");
INSERT INTO mfi_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Daaci faufa hyema, pauka hare, aɗaba diyakurka sarte ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Una ŋanna watse á magava ba seke náza á edda á há, má á daa shula. Lauktu á zlálá, á faterem huɗe á há-aara am erva ge emnde a slera-aara, ma ware keni á far slera na á de maganá ŋane, á vante sawari ge slewufa á wakyiya, geni a peka hare ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Daaci ba duksa palle ge kure keni. Pauka hare, tsakwautsakwa hyema, aɗaba diyakurka sarte na ni á de sá edda á há átekwa na. Bi watse á sá an maŋgaripu, bi an huɗe á vaƴiya, bi an ireŋlya, bi an eŋlya. ");
INSERT INTO mfi_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Máki saasa am beressire wá, a se berakurka kwá am hare. ");
INSERT INTO mfi_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Elva ŋanna ya bakurnaa iya na wá, ge emnde baɗemme. Daaci baɗemmire á kure, pauka hare, tsakwautsakwa hyema!» ");
INSERT INTO mfi_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A juwaa ba hare buwa tá maga muŋri á *Paska antara muŋri á depaiŋ na ɓaaka shahi á makala am huɗe-aara na. Am sarte ŋanna maa, male-aha á *liman-aha, antara malum-aha á *tawraita, tá aŋkwa tatayaná á ba an ndzeɗa dabari ganakini tá eksevaksa Yaisu á ba an nasherire, tá keɗanaakeɗa shifa-aara. ");
INSERT INTO mfi_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","A ba itare am dagave-aatare: «Magaumika una vaci muŋri, geni a tsaranteka emnde elva.» ");
INSERT INTO mfi_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Am sarte na Yaisu am Baytaniya maa, a dem mbá á Simaun umele ndza á waná derve. Tá arge ɗafa maa, a duhe ge mukse umele an kuderá á waye umele tá ɗahaná an nardisa, á se emtake, kwakya gane-aara keni. Daaci mukse na a naba kezlanvuhe ge we á kuderá á waye ŋanna, a puwanem waye na am ire ge Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Emnde na tá aŋkwa áhuwa ŋanna wá, emnde umele-aatare a naba jaterhe ge ervauŋɗe, a ba itare am dagave-aatare: «Azara nampire-aara kina ta badzanve waye na? ");
INSERT INTO mfi_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ábi ma andze tá naba veluvele ma gursa deremke keni, daaci ma tá naba tegatertega ge talaga-aha.» Daaci ta fantau ge far haypa ge mukse na. ");
INSERT INTO mfi_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Amá a ba Yaisu á elvan ge itare: «Weshawananteka ire ge mukse na. Labára kwá hyainá lyuwa? Názena a maginaa ŋane na shagera jipu. ");
INSERT INTO mfi_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Aɗaba talaga-aha wá, ma vaatara keni watse tá á ba átevege kure. Ba kelaa má kwá kátá magaterá shagerire, watse ba kwá emmaga. Amá iya wá, watse ya ɓaaka átevege kure. ");
INSERT INTO mfi_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mukse na wá, ŋane maginaamaga názena ni a dzegwanaa ŋane. A puwiyar waye na wá, tsatsiyaatsatse zlauzle ge ɓeliya am evege. ");
INSERT INTO mfi_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yá ndaakur ba jirire, am huɗe á duniya baɗemme, baɗemme á tate na ni tá de ɓálá labare á higa átekwa na wá, tá de ndaha názena ni a maganaa mukse na keni, tá de viyanaaka.» ");
INSERT INTO mfi_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Am iga a una ŋanna maa, a naba tsetehe ge Yahuda Iskariyaut, ŋane keni ba palle á pukura-aha kelaawa ju buwa. A duhe ge ŋane ádeza male-aha á *liman-aha, a de bateraa á kátá velateru Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Higa ge male-aha na, a ba itare tá elvan ge ŋane: «Watse ŋá vakte nalmane.» Daga á ba am sarte ŋanna, Yahuda a fantau ge tataya faterem Yaisu am erva-aatare. ");
INSERT INTO mfi_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Am váha zuŋŋwire na ni tá zá muŋri na ɓaaka shahi á makala am huɗe-aara na wá, tá ceɓán ba vacite ŋanna egdza kyawe á *Paska. Ta ndavanu ge pukura-aha-aara, a ba itare tá elvan ge ŋane: «Ká kátá ŋá de tsatsakaná áme ɗafa á Paska?» ");
INSERT INTO mfi_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Daaci Yaisu a eksetaa emnde buwa am pukura-aha-aara, a ɓelateraa á de katafke. A ba ŋane á elvan ge itare: «Dawmbare á dem huɗe á ekse, kwá de já ire antara zhele á sepa yawe am hwama wá, ɗabauɗaba á dem mba na á duwa ŋane. ");
INSERT INTO mfi_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","De bawanánba ge edda á há wá, a ba Malum: Áma bere na ŋá de zá ɗafa á Paska am huɗe-aara antara pukura-aha-aaruwa? ");
INSERT INTO mfi_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Daaci ŋane á de marakurá bere ƴaikke átire ge bere an tsatsa kazlaŋa am huɗe-aara baɗemme, kwá de tsatsamiya ɗafa á muŋri am huɗe-aara.» ");
INSERT INTO mfi_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Daaci ba zlálá ge pukura-aha na á dem huɗe á ekse, tá de bera duksa ba seke una a baternaa Yaisu na. Ta tsatsaa ɗafa á muŋri am bere ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Am iga a maŋgaripu maa, daada Yaisu antara pukura-aha-aara. ");
INSERT INTO mfi_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Am sarte na tá aŋkwa á zá masane, a ba Yaisu á elvan ge itare: «Yá ndaakur ba jirire, watse á veliya ba palle á kure, kwa emnde na náwa má zá ɗafa átirpalle na.» ");
INSERT INTO mfi_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Daaci baɗemme á pukura-aha jáviya ba tá kyuwa. Ta fantau ge ndavanu an palpale, ma ware keni á baná ba: «Iya ka ndza Yaakadada?» ");
INSERT INTO mfi_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Watse á veliya ba palle á kure, kwa pukura-aha kelaawa ju buwa na náwa má zá ɗafa am tása palle na. ");
INSERT INTO mfi_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Iya *Ura á emnde baɗemme wá, ɓaaka pekya-aara, sey ba yá emtsa. Áte una ta puwete am wakita á Dadaamiya áte ya wá, ba estuwa. Amá watse zlaɗa jipu ge edda una ni á de veliyá ŋane, ambane ma yareka.» ");
INSERT INTO mfi_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Am sarte na tá aŋkwa zá masane maa, Yaisu a eksetaa ɗafa, a slafanaa we-aara ge Dadaamiya, a kezlanve ɗafa na, daaci a vaterte ge pukura-aha-aara. A ba ŋane á elvan ge itare: «Nawmbare, lyauvalya. Una na wá, vuwa-aaruwa.» ");
INSERT INTO mfi_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Am iga a una ŋanna maa, a eksante feka, a slafanaa we-aara ge Dadaamiya, a vaterte, itare baɗemme sharushe. Am sarte na tá aŋkwa esshá, a ba ŋane á elvan ge itare: ");
INSERT INTO mfi_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","«Una ŋanna uzhe-aaruwa a puvaa aɗaba emnde kwakya, Dadaamiya á ŋguɗaterá an una ŋanna namána ge emnde. ");
INSERT INTO mfi_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yá ndaakur ba jirire, am sali kataliya na wá, yá dalika á shá yawe á egdza a náfa mazla-aara, sey watse yá de shá ba una áŋwaslire am zlanna á Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Am iga á una ŋanna maa, ta eksante láhe á gálá Dadaamiya, ba tse-aatare, ta zlálá ádete ire á Wa Anyaranyárá. ");
INSERT INTO mfi_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Daaci a ba Yaisu á elvan ge pukura-aha-aara: «Baɗemme á kure na watse kwá ƴiyaaƴa. Aɗaba aŋkwa an puwa am wakita á Dadaamiya, a ba ŋane: “Watse yá ejja suni, baɗemme á kyawe-aha tá de zaɗevzaɗe.” ");
INSERT INTO mfi_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Amá má watse tsanetse am faya wá, watse yá daada ba iya zuŋŋwe arge kure á dem Galili.» ");
INSERT INTO mfi_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","A ba Piyer á elvan ge ŋane: «Ma ƴarakaaƴa emnde umele keni, iya wá, yá taa ƴakaaka ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","A ŋwanante ge Yaisu, a ba ŋane á elvan ge ŋane: «Yá ndak ba jirire, an vaƴiya ba vatena na, lauktu á kyuwetekyuwa tsákálá ge buwire wá, watse ká banba ka ser keƴe geni diyakikire.» ");
INSERT INTO mfi_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Amá a farhe zlaɓe ádaliye Piyer, a ba ŋane: «Yá ndaaka una ɗekiɗeki. Ma á eksa shifa keni, emtsa á miya ba buwa.» Pukura-aha umele keni baɗemme ta ndaha ba una. ");
INSERT INTO mfi_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Am iga á una ŋanna maa, daraada am tate umele tá ɗahaná an Gaicaimane. A ba ŋane á elvan ge pukura-aha-aara: «Njawinja áhuna, kwaye iya yá de maga maduwa áhuwa.» ");
INSERT INTO mfi_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","A eksetaa tara Piyer an Yakuba ira Yuhanna, á zlálá antara itare á dem tate ŋanna. Daaci a fantau ge tápá emtaŋkire, antara zlaɗa na ni an tsaka ire na am ervauŋɗe-aara. ");
INSERT INTO mfi_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Daaci a ba ŋane á elvan ge itare: «Ɓaaka zlaɗa na ni yá tapanka am ervauŋɗe-aaruwa na, yá tápá zlaɗa á emtsa. Naba njawinja áhuna, pauka hare ɗekiɗeki, sherauseshere ice ba shagera.» ");
INSERT INTO mfi_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","A zlalehe ƴiƴiye cekwaaŋguɗi an itare, a de kezlaa ugje am haha, a magaa maduwa, a ŋala Dadaamiya geni máki á gevge wá, a sawka zlaɗa ŋanna ásete ŋane. ");
INSERT INTO mfi_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","A ba ŋane: «Eddaye-aaruwa, ɓaaka názu á gevka ázeŋa. Tasle á ŋa, jinaaja zlaɗa na ásete iya na. Amá wá, a gevge ba namaari á ŋa arge náza-aaruwa.» ");
INSERT INTO mfi_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Daaci ba tse-aara wá, a seza pukura-aha keƴe na, amá a se berater tá am hare. A ba ŋane á elvan ge Piyer: «Simaun, ka ŋara ka pa hare? Dzegwakanka njá an ice ba saa palle keni degey? ");
INSERT INTO mfi_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pauka hare! Magaumaga maduwa geni a badakuruka shaitaine. Aɗaba ire á urimagwe wá, wayaawáya jipu mága fesaarfire, amá ɓaaka payɗa á vuwa.» ");
INSERT INTO mfi_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","A zlalehe zlaɓe ádaliye, a de magaa ba maduwa-aara ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Eptsa-aara zlaɓe ádaliye áseza pukura-aha-aara, a se berater tá á ba am hare. Dzegwaránka ɓasha háre ɗekiɗeki. Daaci ta ba haslakke ba estuwa, ɓaaka názu tá ŋwananta itare. ");
INSERT INTO mfi_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Am sarte na a eptsa ge keƴire, a ba ŋane á elvan ge itare: «Kure kwá pá ba hare á kure, kwá aŋkwa á puwansepuwe shifa á kure ka? Ay degiya hyaahya pa hare ŋanna, iya *Ura á emnde baɗemme, hyephye sarte-aaruwa. Kwaye tá de fime am erva ge emnde a haypa. ");
INSERT INTO mfi_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tsawetse, kwaye samsa edda una ni a veliyaa ŋane na, mí de yainuye!» ");
INSERT INTO mfi_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ba elva ŋanna keni zlaɓe zlanaaka Yaisu wá, kerteŋ tá zhárá ba sesse Yahuda palle á pukura-aha kelaawa ju buwa. Emnde kwakya tá sá ɗaba Yahuda ŋanna, tá an katsákar-aha, antara zade-aha ceppe am erva. Ta ɓelateraa male-aha á *liman-aha, antara malum-aha á *tawraita, ira male-aha á Yahudiya-aha. ");
INSERT INTO mfi_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yahuda na a veluwa ŋane Yaisu na maa, kwaratersekware zlauzle nalaama á ŋgyekwaterá Yaisu ge dikele á emnde ŋanna. A ba ŋane á elvan ge itare: «Ba máki kwa niina yá aŋkwa gan use ge ura ni, seke aŋkwa urire á ŋere an edda-aara wá, edda una kwá tatayaná kure na ba ŋane, naba eksauváksa, ŋawanaaŋa ba shagera, má kwá danda na ɓelawanaaka.» ");
INSERT INTO mfi_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ba samsa Yahuda ŋanna wá, a naba duhe suuwe ádeza Yaisu wá, «Use Malum,» a ba ŋane, á gan use an ervauŋɗe-aara palle ágire. ");
INSERT INTO mfi_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Daaci yalla á ba emnde na, erva am mbiye ge Yaisu, ta naba eksevaahe. ");
INSERT INTO mfi_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ay, palle á emnde á Yaisu a naba teɗese masalam-aara am bere, a waa sleslera á male á *liman-aha, a icanaa hyema palle. ");
INSERT INTO mfi_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","A ba Yaisu á elvan ge emnde na ta se eksa ŋane: «Kwá se eksiyá an masalam-aha, antara zade-aha am erva na mu, ya neyle emtu? ");
INSERT INTO mfi_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ábi kelaazare yá njá á ba am dagave á kure am mashidi, yá aŋkwa kwaraterse elva á Dadaamiya ge emnde, labára eksakurika? Amá diyaweddiye geni una ŋanna a gev ba geni, a gevge názena á ndaaná wakita á Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Daaci kyaakya zhagade ge pukura-aha baɗemme, ta naba ƴánhe. ");
INSERT INTO mfi_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Aŋkwa dawale umele a ɗaba Yaisu maa, ŋane a duwá á ba an gwaɗau-aara áte vuwa. Ta ekseksa ŋane keni, ");
INSERT INTO mfi_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","amá a naba ƴateraa gwaɗau am erva, ba zhagade-aara an ukhyiye dey. ");
INSERT INTO mfi_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Daaci ta naba daa Yaisu na á dem mba á male á male-aha á *liman-aha baɗemme. Kerteŋ jarammeje male-aha á liman-aha, antara male-aha á larde, ira malum-aha á *tawraita baɗemme am mba á liman ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyer wá, a daa ɗaba Yaisu ádehuwa, amá wá, gaterápteka ɗekiɗeki. A de demhe á ba á dem riya á liman ŋanna. Áhuwa maa, a de demhe am dagave á emnde a ufa mashidi, tá aŋkwa cena kárá, a njehe. ");
INSERT INTO mfi_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Male-aha á liman-aha antara emnde a *kendekyiya na baɗemme farantaufe ge tataya emnde ge mága seydire áte Yaisu, ma ba fida keni, lauktu ma tá bá ŋanaaŋa shairiya á emtsa. ");
INSERT INTO mfi_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kwakya tsa emnde na ta de ɗatsanve fida ge Yaisu, amá ɓaaka názu ta eksanaa áte ŋane. ");
INSERT INTO mfi_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Daaci ta tsetehe ge emnde umele, ta de magaa seydire á fida na áte Yaisu, a ba itare: ");
INSERT INTO mfi_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Zhel na degey ndza ŋa cenáncena am mbuwe-aara a ba ŋane: Yá naba mbeɗánaambeɗa *mashidi ƴaikke na ta nderanaa emndimagwaha na, yá nderaalindere á ba am hare keƴe, á duka erva á urimagwe á dem huɗe-aara, á bina.» ");
INSERT INTO mfi_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Aley, ba itare keni jammeka elva-aatare am seydire-aatare. ");
INSERT INTO mfi_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Daaci a tsete ge liman ƴaikke na á katafke á emnde baɗemme, a ba ŋane á elvan ge Yaisu: «Ká ndaaka elva ɗekiɗeki ka? Tá ndáhá uwe ŋane áte ka emnde na?» ");
INSERT INTO mfi_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Amá ŋwaaka Yaisu, a ɗu ba we-aara. A ndavanuhe zlaɓe ádaliye ge liman na, a ba ŋane: «Ba ekka una ka *Almasiihu, Egdza á Saksage na emtu?» ");
INSERT INTO mfi_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","A ŋwanante ge Yaisu, a ba ŋane: «Ane, ya ŋane ba ya. Amá baɗemmire á kure na, watse kwá niina zlaɓe ádaliye iya *Ura á emnde baɗemme, yá njá am naɗafa á Saksage na Sleksa ba ŋane na. Zlaɓe ádaliye watse kwá niina yá sawa am kumba á samaya.» ");
INSERT INTO mfi_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ba a ndaase una Yaisu wá, liman ƴaikke na a naba dzadzanve zane áte vuwa-aara. A ba ŋane: «Una wá, ŋa ɓaaka an wedere á seyde umele mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ábi kwa cenanaa á ba an hyema á kure, a ganve ire-aara kalle an Dadaamiya. Ázara a ba elva á kure?» A ba itare baɗemme-aatare, «Una wá, ŋanaaŋa shairiya, a njeka an shifa ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Daaci emnde umele ta fantau ge kyefanem nyaihe am ice ge Yaisu, ta faɗanse ice an kacekaca, ta vavante ɗeɗekwa, a ba itare tá elvan ge ŋane: «Diyeddiye emnde na ta jakja na.» Ta eksante emnde a ufa mashidi, ta vavante babarva itare keni. ");
INSERT INTO mfi_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Amá Piyer wá, zlaɓe ba nja-aara am áhá-aara, am huɗe á há ŋanna. Daaci a duhe ge palle á kwatena-aha á *liman ŋanna ádezetare, ");
INSERT INTO mfi_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","a naa Piyer á cená kárá, a zharaa Piyer ba shagera, a ba ŋane: «Ábi ka keni ka ba ura á Yaisu ŋanna, ura Nasarátu na?» ");
INSERT INTO mfi_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Amá eksarka Piyer ɗekiɗeki, a ba ŋane á elvan ge ŋane: «Ma ká ndaha elva á uwe keni, diyanka ya ɗekiɗeki. Elva á ŋa na á duka á dem ire-aaruwa.» Daaci a naba tsetehe am tate ŋanna, a zlala ásete wakyiya. Tsaktsakwalikwaa, á ba tsákálá keni. ");
INSERT INTO mfi_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Cekwaaŋguɗi wá, kwatena na nanna Piyer zlaɓe ádaliye, a ba ŋane á elvan ge emnde: «Degiya zhel na kwaya ŋane na keni, ba palle-aatare.» ");
INSERT INTO mfi_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Amá Piyer ba eksarka ŋanna. Shekwaashekwa cekwaaŋguɗi a ba emnde na tá áhuwa, tá elvan ge Piyer: «Ɓaaka shaige-aara ɗekiɗeki, ka keni ka ba palle-aatare. Aɗaba ekka keni, ka ura Galili.» ");
INSERT INTO mfi_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Amá Piyer a fantau ge za waɗa-aha, a ba ŋane: «Náwa Dadaamiya diyanka dawale ŋanna ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ba ŋane keni zawze waɗa wá, tsaktsakwalikwaa, á ba tsákálá ge buwire. Daaci a naba yehete názena a ndaana Yaisu. Aɗaba a bananba Yaisu: «Lauktu á kyuwetekyuwa tsákálá ge buwire wá, ká de banba ka ser keƴe geni diyakikire.» Daaci a naba fantau ge kyuwa. ");
INSERT INTO mfi_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Daaci makuralla-aara á ba an eŋlya-waabere, ta naba jamme ge male-aha á *liman-aha, antara male-aha á larde, malum-aha á *tawraita ira male-aha umele na tá njá am *kendekyiya na baɗemme. Ta puwete zawa áte Yaisu, ta dáná ádeza sleksu *Pilaatu. ");
INSERT INTO mfi_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","A ndavanu ge slekse, a ba ŋane: «Ba ka una ka slekse á Yahudiya-aha tá enndá na?» A ŋwanante ge Yaisu: «Ba estuwa,» a ba ŋane á elvan ge ŋane. ");
INSERT INTO mfi_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Male-aha á liman-aha ta fantau ge ɗatsanve fida kwakya ge Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Daaci a ba sleksu Pilaatu á elvan ge ŋane: «Ká cenánka elva na tá tsakaná itare áte ka na emtu? Labára ká ndaaka elva?» ");
INSERT INTO mfi_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Amá Yaisu ɗuwa ba we-aara, ndahaaka elva mazla-aara, haa Pilaatu á maga najipu-aara. ");
INSERT INTO mfi_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ba kelaa má samsa muŋri á *Paska maa, mbarsemba emnde a ekse, slekse á ɓelaterá daŋgay palle, edda una tá kataná itare. ");
INSERT INTO mfi_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ay am sarte ŋanna maa, ndza aŋkwa dawale umele, zhera-aara Barabas an ŋguɗa am daŋgay. Ta halateraa antara emnde umele, ta magaa fitenire, haa ta naba ja shifa am fitenire ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Daaci ta naba ɗálá emnde a ekse ádeza sleksu *Pilaatu, ta de ndavanu názena ni mbarsembe ba kelaa iva na. ");
INSERT INTO mfi_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","A ba sleksu Pilaatu á elvan ge itare: «Wayakurwáyá emtu an slekse á Yahudiya-aha, yá ɓelakurnaaɓela?» ");
INSERT INTO mfi_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Diyaadiya tsa ganakini male-aha á *liman-aha ta danaa Yaisu aɗaba ba shelha, ɓaaka elva umele. ");
INSERT INTO mfi_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Amá male-aha á liman-aha ta naba fantau ge gaa ervauŋɗe á emnde. Aɗaba una ŋanna ta bantsa itare: «Ɓelaŋernaaɓela ba Barabas.» ");
INSERT INTO mfi_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","A ndavateruhe zlaɓe ádaliye ge slekse, a ba ŋane á elvan ge itare: «Ay yá maganá uwe ge edda una kwá ɗahaná an slekse á Yahudiya-aha na?» ");
INSERT INTO mfi_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ta ŋwanante á ba an ká kwara á dem zhegela, a ba itare: «Zleŋelezleŋela áte dzaŋgala!» ");
INSERT INTO mfi_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","A ba slekse á elvan ge itare: «A gu uwe estuwa?» Amá itare ta far hula á ba an ndzeɗa, a ba itare: «Zleŋelezleŋela!» ");
INSERT INTO mfi_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Am slekse á kátá higatertehiga emnde, a naba ɓelateraa Barabas. Amá Yaisu wá, ta zu an já, lauktu tá de zleŋelaná áte dzaŋgala. ");
INSERT INTO mfi_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Daaci ta naba teɗante ge sawji-aha á dem huɗe á há á sleksu *Pilaatu, ta de jemmaa sawji-aha baɗemme ásetarge ŋane. ");
INSERT INTO mfi_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ta tsekwanme am dira haŋŋe, ta nderse dake, ta faɗanse ire an ŋane agire *ɗaŋkaula. ");
INSERT INTO mfi_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mazla-aara ta fantau ge gyanu rume agire, a ba itare: «Aska á ŋa, slekse á Yahudiya-aha.» ");
INSERT INTO mfi_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ta naba taɗanu zade am ire, ta kyafanem nyaihe am ice, ta kezlaa ugje á katafke-aara, tá fá daradza áte ŋane agire. ");
INSERT INTO mfi_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Zlaruzle am epsawepsawa maa, ta tsakwanse am dira na, ta tsekwanme am naŋgyuwe-aara. Daaci ta danse á dem tate na tá de zleŋelaná átekwa na. ");
INSERT INTO mfi_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tá aŋkwa danda maa, ta naba jaa ire antara ura Siraine umele, zhera-aara Simaun, eddetare ge tara Alaikzandere antara Rufus, ŋane átira sa á sawa am makwata. Daaci sawji-aha na ta naba hyarhe ge sepala dzaŋgala á Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ta danhe Yaisu na á dem tate na tá ɗahaná an Gaulgauta na, amaana: Tate á feka á ire. ");
INSERT INTO mfi_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Áhuwa ŋanna maa, ta kátá fanu mbazla ge Yaisu. Mbazla ŋanna keni aŋkwa duksa ƴaiƴaihe am huɗe-aara ge gulanna zlaɗa, amá Yaisu shaaka. ");
INSERT INTO mfi_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mazla-aara ta naba zleŋelehe áte dzaŋgala. Itare ta tegaa kazlaŋa-aara am dagave-aatare. Ge tega kazlaŋa-aara na wá, ta maga njeri am dagave-aatare, ganakini a sesse edda una ni á zaná ŋane ma uwe keni. ");
INSERT INTO mfi_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Am sarte na ta zleŋelanaa áte dzaŋgala ŋanna wá, ta zleŋelanaa am saa maselmane á eŋlya. ");
INSERT INTO mfi_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ta naba puwete dalila á já shifa-aara an ire ge ŋane, a ba itare: «Ŋane una slekse á Yahudiya-aha.» ");
INSERT INTO mfi_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tá aŋkwa neyle-aha buwa ta zleŋelateraa átirpalle antara Yaisu áte dzaŋgala-aha-aatare. Palle ta zleŋelanaa am naɗafa-aara, palle keni am nazlaɓa-aara. (( ");
INSERT INTO mfi_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","A gevaa estuwa názena ni a ndaana wakita á Dadaamiya. Aɗaba a ba wakita á Dadaamiya: «Ŋane keni ta femhe am kezlakula á emnde a mága haypa.»)) ");
INSERT INTO mfi_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Emnde a degáshe am tate ŋanna tá geja ba ire, tá ámbera ezzlazle. A ba itare tá elvan ge ŋane: «Há! ba ka una! Ábi ka bantsa ka: Ká naba mbeɗanaambeɗa *mashidi ƴaikke na, á ba am hare keƴe ká nderendere umele, á ba ka? ");
INSERT INTO mfi_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Labára ká taa ŋezlanaaka ba ka ire á ŋa? Tsekwanaatsekwa kwa ire á ŋa áte dzaŋgala na!» ");
INSERT INTO mfi_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Male-aha á *liman-aha, antara malum-aha á *tawraita keni, ta epsawse ba estuwa. A ba itare am dagave-aatare: «Iyau, á dzegwándzegwa ŋezla emnde umele; ire-aara wá, á taa ŋezlanaaka! ");
INSERT INTO mfi_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ábi ŋane *Almasiihu, slekse á *Iserayiila keni ba ŋane. A tsekwanaatsekwa ire-aara áte dzaŋgala wá, baɗemme mí fetarfe áte ŋane.» Antara ba emnde na ta zleŋelateraa antara Yaisu na keni, ta ezzlazle. ");
INSERT INTO mfi_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","An vacitire wá, a naba tsekwaa ge tabeɗammire ásetarge duniya baɗemme, dem lásar emnde tá á ba am tabeɗammire ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Am saa keƴe wá, Yaisu a ketaa kwárá á ba an ndzeɗa: «Aili! Aili! Laima sabaktani?» Amaana wá: «Dadaamiya-aaruwa labára ƴakiyaaƴa? Dadaamiya-aaruwa labára ƴakiyaaƴa?» ");
INSERT INTO mfi_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Á bá emnde umele am emnde na tá aŋkwa á tsatse áhuwa: «Á ɗaha nabi *Ailiya degiya ŋane.» ");
INSERT INTO mfi_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Palle-aatare a naba teɗante zhagade, a de eksetaa sausau, a ŋguɗetaa áte zade, a femhe am mbazla umele ɗaŋɗaŋe ba estuwa, daaci a kante, a fantaa áte we ge Yaisu geni a shushe. Daaci a ba ŋane: «Zharaumizhárá emtsaaɗe, má watse á semsa *Ailiya ŋanna á se tsekwanaatsekwa.» ");
INSERT INTO mfi_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Amá Yaisu a fu hula á ba an ndzeɗa, mazla-aara á dese ge shifa am ŋane. ");
INSERT INTO mfi_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Am sarte ŋanna maa, aŋkwa kacekaca á dzegwa am *mashidi ƴaikke wá, a naba tamme kalkale, a fantau á sawa átire sem áhá. ");
INSERT INTO mfi_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Male á sawji-aha á Rauma na aŋkwa áhuwa, á njá am ndaŋŋire á wafke á Yaisu, nanna emtsa a Yaisu maa, a ba ŋane: «Zhel na wá, egdza á Dadaamiya ba jire.» ");
INSERT INTO mfi_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ŋwasha umele keni ndza tá aŋkwa áhuwa. Ta tsaahe ƴiƴiye, lauktu ta zhara názena ni aŋkwa á magava na. Tá aŋkwa tara Maari mukse á emnde a Magdala, an Salaume, ira Maari emmetare ge tara Yakuba cekwa antara Yauseys. ");
INSERT INTO mfi_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ŋwasha ŋanna wá, daga am Galili tá aŋkwa ɗaba Yaisu, tá aŋkwa melanumele. Tá aŋkwa zlaɓe ádaliye ŋwasha umele am tate ŋanna, itare keni ta saa á ɗaba ba Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Vacite ŋanna maa, vaci mága niya, aɗaba makuralla-aara kwaskwe á puwansepuwe. Herzhe á belya vaci wá, ");
INSERT INTO mfi_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","a semhe ge Yusufa ura Arimatiya. Yusufa ŋane wá, ura male am *kendekyiya ƴaikke. Am ervauŋɗe-aara ŋane keni aŋkwa á ufa ba zamane á njá am *kwara á Dadaamiya. Daaci ŋane a naba sherse ice, a duhe ádeza sleksu *Pilaatu, a de ndavanu baráma á eksa emtsa á Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Cenáncena sleksu Pilaatu ganakini kerteŋ emtsamtsa Yaisu, a mága ba najipu-aara. Aɗaba una ŋanna a ɓelaa we, ta de ɗahanante male á sawji-aha. A se ndavanuhe, a ba ŋane: «Emtsa-aara shekwaashekwa emtu?» ");
INSERT INTO mfi_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Am sarte na cenáncena jirire-aara áza male á sawji-aha na, a naba vante baráma ge Yusufa. ");
INSERT INTO mfi_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Daaci Yusufa a de shekuve kalpakane, jeba á kalpakane ŋanna ba lefeɗɗe, a se tsekwaa emtsa á Yaisu áte dzaŋgala, a de faɗeme am kalpakane na. Daaci a de feme am evege ta yese am cacera, a berhanu palame ƴaikke ge we á evege ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Amá tara Maari mukse á emnde a Magdala, antara Maari emmeŋara ge Yauseys wá, itare ndza tá á ba áhuwa, ta ezzhara am sarte na tá heɗá Yaisu ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Dedde kwaskwe á puwansepuwe maa, tara Maari mukse á emnde a Magdala, antara Maari emmeŋara ge Yakuba, ira Salaume, ta de shekuve waye-aatare á se emtake, ta fehe, geni watse tá de wecar ge emtsa á Yaisu. ");
INSERT INTO mfi_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","An eŋlya werre ge laade, lauktu á sessa vaci wá, daraada itare ádete irekhya. ");
INSERT INTO mfi_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Am sarte na tá átira duwa, a ba itare am dagave-aatare: «Kina mu, watse á berhamiyanvuwa ware dada palame na ge we á evege?» ");
INSERT INTO mfi_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Amá daraada wá, ta de beraa ba an berha dada palame ŋanna áte we á evege. ");
INSERT INTO mfi_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ta naba duhe á dem huɗe-aara wá, ta de beraa ba dawale á njá am naɗafa, am naŋgyuwe dzayye. A naba jaterhe ge lyawa ŋwasha na. ");
INSERT INTO mfi_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","«A wakurka lyawa,» a ba dawale ŋanna á elvan ge itare. «Aɗaba kwa se tataya Yaisu ura Nasarátu na ta zleŋelanaa áte dzaŋgala na. Ŋane ɓaaka áhuna, tsetse am faya. Náwa tate na ndza á zlava ŋane átekwa na. ");
INSERT INTO mfi_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kina wá, kure wá, zlauzlálá, dawateranda labáre ge pukura-aha-aara, Piyer keni á ba am itare. Baira ɗeme watse á daada ba Yaisu ŋanna zuŋŋwe arge kure, á dem Galili. Kwá de nanaana áhuwa, ba seke una ndza bakurnaa ŋane.» ");
INSERT INTO mfi_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Daaci ba segashe-aatare am irekhya na wá, ta teɗante zhagade emtsaaɗe ge lyawa, tá gyagya ba seke maagara, palle á ura á baná elva ge ura ɓaaka am itare, aɗaba gazlargazla jipu. ");
INSERT INTO mfi_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Am sarte na tsetsa Yaisu am faya, an eŋlya werre ge laade na wá, a maranse ire-aara ge Maari mukse á emnde a Magdala zuŋŋwe. Mukse ŋanna wá, ndza ŋgyanseŋgye Yaisu jini-aha vuye am ŋane. ");
INSERT INTO mfi_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","A de ɓalatersaa ŋane labáre á tse á Yaisu am faya ge emnde na ta ɗába ŋane. A de berater baɗemme tá á ba am emtaŋkire, tá kyuwa. ");
INSERT INTO mfi_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Aŋkwa á bateranba ɗeme mukse na ganakini tsetsa Yaisu am faya, a naana á ba an ice-aara, aley fartarka. ");
INSERT INTO mfi_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Am iga á una ŋanna maa, Yaisu a marateraa ire-aara ge emnde buwa-aatare, tá áte baráma dete makwata, amá a nyanve ire-aara seke ŋane ka. ");
INSERT INTO mfi_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ta daahe, ta de ɓalaterse labáre-aara ge emnde-aatare umele, aley ba fartarka ŋanna. ");
INSERT INTO mfi_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Shekwaashekwa zlaɓe ádaliye maa, Yaisu a de marateraa ire-aara ge pukura-aha-aara kelaawa jemtekwe tá arge ɗafa. A naba velateraahe aɗaba ɓaakire á fetarfire antara degdegire á ire na ta maganaa itare na. Aɗaba fartarka an emnde na ta naa ŋane á ba an ice-aatare am iga a tsetse-aara am faya. ");
INSERT INTO mfi_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Daaci a ba ŋane á elvan ge itare: «Zlauzlálá á dem huɗe á duniya baɗemme, dawateranda labáre á higa na ge emnde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ma a fetaara ware, lyevaalya baptisma, á lyelye shifa-aara. Edda una má fetarka wá, á de ŋezleka am shairiya á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Náwa najipu-aha na watse tá naana emnde, tá maganá emnde a fetarfe. Watse tá ŋgya jini-aha am ura an zhera-aaruwa. Watse tá ndáhá elva áŋwaslire na ni ba itare keni diyarka na. ");
INSERT INTO mfi_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Watse tá puwaterar erva ge emnde na ta lapika-aha, tá de mbembe. Zlaɓe ádaliye, ma ta halante zahe am erva, ma ta shu daldalkwanu keni, ɓaaka nazu á magateránmaga duksa-aha ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Am sarte na ni zlauzle á tsakaterá elva Yaakadada Yaisu ge pukura-aha-aara maa, a naba kapte á dem samaya, aŋkwa á njá am naɗafa á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pukura-aha-aara keni, ta naba kyaa á de ɓálá labáre á higa am huɗe á duniya baɗemme. Ndza aŋkwa Yaakadada an itare am slera-aatare. A maratersaa ŋane ge emnde geni waazu-aatare jirire, aɗaba a magaa najipu-aha gergere á kyá erva an itare.");
INSERT INTO mfi_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Áska á ŋa Tiyaufilus, Emnde kwakya puwartepuwa labáre á názena a magava am dagave á miya. ");
INSERT INTO mfi_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ta puwete názena ŋa cenanaa áza emnde na ta naana an ice-aatare duksa ŋanna daga á ba am fakta-aara. Emnde ŋanna wá, Dadaamiya a faterar slera á ɓalaterá labáre ŋanna ge emnde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aɗaba una ŋanna, iya keni ya fantau ge pakya sera-aara daga fakta-aara dem halavuwa-aara, hayananhaya jipu am mbarka á ŋa. Una ŋanna yá aŋkwa puwakte ge ekka keni názena ya shanaa ya na baɗemme, yá puwakte á ba áte una ya cenanaa ya na kalkale. ");
INSERT INTO mfi_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Baɗemme á una yá magán ba geni ekka keni ka diyeddiye jirire á elva ŋanna ta ndakndaa na. ");
INSERT INTO mfi_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Am zamane na ni ndza sleksa *Hirudus am Yahudiya maa, ndza aŋkwa *liman umele zhera-aara Zakariya, ŋane palle á liman-aha na male-aatare liman Abiya. Zhera á mukse-aara Ailizabait, ŋane wulfe á *Haruna male á liman-aha werre. ");
INSERT INTO mfi_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bukerɗe-aatare antara mukse-aara ta emnde a jirire á katafke á Dadaamiya, ta emnde a fansaare ge shairiya-aha á Yaakadada baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Amá egdzere wá, sharánka ba palle keni, aɗaba Ailizabait dziire. Am sarte ŋanna wá, bukerɗe-aatare garevge emgyegwar emnde. ");
INSERT INTO mfi_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Vacite umele maa, Zakariya aŋkwa á maga slera á limanire-aara á katafke á Dadaamiya, aɗaba daada áte itare liman-aha á Abiya baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ge tega slera-aatare am dagave-aatare liman-aha maa, mbarsembe maga njeri. Daaci vacite ŋanna maa, daada áte ŋane ganakini á de ɗizaná ŋane kajiiji am mashidi á Yaakadada. ");
INSERT INTO mfi_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Am sarte á ɗiza kajiiji ŋanna maa, baɗemme á emnde tá maga maduwa á ba ágashe. ");
INSERT INTO mfi_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Daaci a naba jesaarhe ge malika á Yaakadada á katafke á Zakariya, a tsaahe áte vuwa á duksa na tá ɗiza kajiiji átekwa na, am naɗafa-aara. ");
INSERT INTO mfi_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ba a puwete ice áte ŋane Zakariya wá, a naba gazlehe, ɓaaka názu á ndaana ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Amá a ba malika á elvan ge ŋane: «Zakariya, a waŋka lyawa. Aɗaba Dadaamiya lyevaalya maduwa á ŋa. Mukse á ŋa Ailizabait á de yaka egdzere zhele, watse ká fá zhera-aara Yuhanna. ");
INSERT INTO mfi_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Watse á gev higa ƴaikke ge ekka. Emnde kwakya tá de higatehiga aɗaba egdze ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aɗaba áza Yaakadada wá, watse ura male ba ŋane am emnde. Ŋane wá, watse á sheka mbazla antara názu á já eŋkale á ura baɗemme. Ŋane watse an naha ba Sheɗekwe Cuɗeɗɗe am ŋane daga á sawa am huɗe á emmeŋara. ");
INSERT INTO mfi_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Watse á jatermaara ŋane ge *Iserayiila-aha kwakya á sem sera á Yaakadada Dadaamiya-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Watse á sawa ŋane á katafke á Yaakadada, hala-aara antara hákuma-aara watse ba kalkale antara náza á nabi *Ailiya werre. Á se jemá ŋane ye á dada-aha antara egdzara-aatare. Emnde na tá fansaareka ge Dadaamiya keni, á se tsatermaara ŋane. Á se tsatsaná ŋane emnde ge ufa Yaakadada.» ");
INSERT INTO mfi_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Amá a ba Zakariya á elvan ge malika: «Yá dise áte uwe ganakini una ŋanna á de gevge? Aɗaba ŋere antara mukse-aaruwa baɗemme ŋa emgyegwar emnde.» ");
INSERT INTO mfi_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Daaci a ŋwanante ge malika, a ba ŋane á elvan ge ŋane: «Iya wá, ya malika *Jeberilla. Ya tsetaa á katafke á Dadaamiya, ya sleslera-aara. A ɓeliyaa ba ŋane ganakini yá saká labáre á higa na. ");
INSERT INTO mfi_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Amá faktarka an iya. Ay degiya watse á gevge ba jirire, má hyephye laukte-aara. Aɗaba faktarka ŋanna wá, ká gevge uce, ká taa ndaaseka elva ɗekiɗeki, dem sarte na má gevge duksa ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Am sarte ŋanna maa, baɗemme á emnde tá ufa ba Zakariya ágashe, tá maga ba najipu á shekwaashekwa-aara am mashidi. ");
INSERT INTO mfi_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","De sesse maa, dzegwánka ndaater elva ɗekiɗeki, a ŋgyakwateraa elva-aara á ba an erva. Ta dise áte una ŋanna emnde ganakini aŋkwa názu a naaná ŋane am mashidi. ");
INSERT INTO mfi_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Am sarte na zlauzle slera á limanire á Zakariya maa, a naba dahe á dem mba-aara. ");
INSERT INTO mfi_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","De haraare cekwaaŋguɗi am mba maa, mukse-aara Ailizabait a naba shaa huɗe. Amá a essheɓe, tere ilyeɓe á sheɓa ba ŋane. A ba ŋane am ervauŋɗe-aara: ");
INSERT INTO mfi_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Kina wá, siisessa Yaakadada am zherwe am dagave á emnde.» ");
INSERT INTO mfi_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ailizabait an huɗe á tere uŋkwahe maa, Dadaamiya a naba ɓelaa malika *Jeberilla á dem ekse á Nasarátu am kwara á Galili. ");
INSERT INTO mfi_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","A ɓelanaa ádeza gyaale umele, á shebaná dawale na zhera-aara Yusufa na. Yusufa ŋanna wá, ŋane wulfe á sleksu *Dawuda. Zhera á gyaale na a shebanaa ŋane Maari. ");
INSERT INTO mfi_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Daaci a demhe ge malika na ádeza gyaale ŋanna, a de gan use-aara, a ba ŋane: «Use gyaale. Ekka wá, Dadaamiya Yaakadada magakánmaga ŋgurna, aŋkwa ŋane antara ka.» ");
INSERT INTO mfi_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Amá use-aara ŋanna weshanantewesha ire ge Maari, a ba ŋane am ervauŋɗe-aara: «Ázara kena jeba á ga use na?» ");
INSERT INTO mfi_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","A ba malika á elvan ge ŋane: «A waŋka lyawa Maari. Aɗaba Dadaamiya magakánmaga ŋgurna. ");
INSERT INTO mfi_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kina wá, watse ká shá huɗe, ká de yá egdzere zhele, ká de faná zhera á Yaisu. ");
INSERT INTO mfi_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Watse ura male, *Egdza á Dadaamiya Slekse. Watse Dadaamiya á vante sleksire ba seke náza á eggyeŋara *Dawuda werre. ");
INSERT INTO mfi_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Á de kwaraná ŋane larde á *Iserayiila dem ba ge ɗekiɗeki. Sleksire-aara á de tseka ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","A ba Maari á elvan ge malika: «Á de magava estara una ŋanna? Aɗaba iya, ya ba gyaale.» ");
INSERT INTO mfi_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","A ŋwanante ge malika, a ba ŋane á elvan ge ŋane: «Watse á sawa Sheɗekwe Cuɗeɗɗe á setarge ekka, á de maganá ba Dadaamiya Slekse hákuma-aara am ka. Aɗaba una ŋanna, egdze na ká de yaná ka na wá, watse cuɗeɗɗe, ŋane *Egdza á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Vareŋa Ailizabait keni á huɗe á egdzere zhele, gevge emgyegwe á mukse tsa. Ndza dziire tsa, amá a shaa huɗe tere uŋkwahe vatena. ");
INSERT INTO mfi_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Aɗaba ɓaaka názu á janviya ge Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Daaci a ba Maari: «Iya ya kwatena á Dadaamiya. A giyanvege Dadaamiya á ba áte una ka ndaana ka.» ");
INSERT INTO mfi_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Á ba am sarte ŋanna maa, ba watsewatse a naba tsetehe ge Maari, a naba zlala á ba an hadzala, á dem mba á vareŋara Ailizabait am ekse umele am huɗe á wa a Yahudiya. ");
INSERT INTO mfi_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Daaduwa, á de demhe am mba á Zakariya, a de gan use ge Ailizabait. ");
INSERT INTO mfi_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Am sarte na cenancena Ailizabait use-aara, egdzere am huɗe-aara a naba fantau ge fatsava. A nahetaa á ba am sarte ŋanna Ailizabait an Sheɗekwe Cuɗeɗɗe, ");
INSERT INTO mfi_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","a ba ŋane á ba an ká kwara: «Dadaamiya a gakar barka ba ge ekka am dagave á ŋwasha baɗemme. Barka-aara a njinja am egdze na am ekka na. ");
INSERT INTO mfi_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ya hyep ware ha ni emmeŋara ge Yaakadada-aaruwa á sem mba-aaruwa na? ");
INSERT INTO mfi_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ya ndaana aɗaba uwe una? Aɗaba am sarte na ya cenaa ga use á ŋa na wá, egdzere a naba fantau ge shekela am huɗe-aaruwa á higa. ");
INSERT INTO mfi_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Higa ƴaikke ge ekka, aɗaba faktarfe am ervauŋɗe á ŋa ganakini názena ta ɓalakseɓale na á de ganvege Yaakadada baɗemme.» ");
INSERT INTO mfi_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Daaci a ba Maari: «Yá gálá Yaakadada Dadaamiya an ervauŋɗe-aaruwa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Á higa ervauŋɗe-aaruwa kwakya áte ŋane Slelya shifa-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Aɗaba ŋane á zhárá ba iya ya kwátena-aara na hyainepka ba uwe keni. Daga ba kina keni tá aŋkwa á banba emndimagwaha, tá de banba zlaɓe adaliye ma vaatara keni, geni yá an barka á Dadaamiya am vuwa. ");
INSERT INTO mfi_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Aɗaba Dadaamiya na Sleksa ba ŋane palle na a magiyaa duksa ƴaikke. Ŋane wá, zhera-aara cuɗeɗɗe. ");
INSERT INTO mfi_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Á de zatervaara ba ŋane zlaɓe ádaliye ge emnde na tá an lyawa-aara am ervauŋɗe dem eggye-aha. ");
INSERT INTO mfi_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Maganaamaga ŋane slera ƴaikke an ndzeɗa á erva-aara, a zaɗanve emnde a mága kuravire, ");
INSERT INTO mfi_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","a tsekwaa slekse-aha áte sleksire, a vaterte daradza ge talaga-aha. ");
INSERT INTO mfi_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A gater barka kwakya ge emnde na peteke erva-aatare, amá a puwaa emnde a berba an erva-aatare ilyeɓe. ");
INSERT INTO mfi_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A tsaterme am iga ge emnde a slera-aara Iserayiila-aha. Aɗaba viyanaaka magaterá shagerire-aara ge emnde-aara, ");
INSERT INTO mfi_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","áte una ndza a banán ge eggyemiya Ibrahima, ganakini watse á maganán ge ŋane dem eggye-aha-ŋara baɗemme na.» ");
INSERT INTO mfi_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Á hyephye tere keƴe a maganaa Maari am mba á Ailizabait, lauktu a zlala á dem mba-aara. ");
INSERT INTO mfi_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Am iga a una ŋanna maa, a naba hyephye ge sarte á Ailizabait, daaci a naba yaa egdzere zhele. ");
INSERT INTO mfi_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Am sarte na cenaráncena vara-aha-ŋara antara emnde a slala-aatare, ganakini Dadaamiya a magateraa shagerire kwakya, ta naba sawa, ta se higa antara itare. ");
INSERT INTO mfi_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Am hare ge tiisire maa, ta naba eptsehe zlaɓe ádaliye ge se ɓela egdzere am sheɗekwe, antara ge fá zhera. Itare tá kátá fá Zakariya cepen á eddeŋara, ");
INSERT INTO mfi_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","amá a ba emmarge egdzere: «Estuweka, zhera-aara Yuhanna.» ");
INSERT INTO mfi_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Amá a ba itare tá elvan ge ŋane: «Ábi ba palle á ura tá ɗahaná an zhera na keni, ɓaaka am emnde á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Daaci ta ndavanu ge eddarge egdzere, ta ŋgyakwanaa an ŋgyakwa, geni á kátá faná zhera-ara ge egdza-aara. ");
INSERT INTO mfi_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Daaci Zakariya a ndavateru naláwa, ta vante, a puwete: «Zhera-aara Yuhanna,» a ba ŋane. Baɗemme á emnde tá maga ba najipu-aara. ");
INSERT INTO mfi_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ba a puwete zhera ŋanna wá, kerteŋ a naba pelehe ge nara-aara keni, a fantau ge ndaha elva, á gala Dadaamiya á ba an ká kwara. ");
INSERT INTO mfi_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Daaci baɗemme á emnde a slala-aatare, ta farhe zlaɓe ádaliye ge mága lyawa á Dadaamiya am ervauŋɗe-aatare, ta hyanme labáre ŋanna am huɗe á wa a Yahudiya baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Baɗemme á emnde na ta cenaa labáre ŋanna, ta fantau ge dzamaná am ire-aatare geni watse á gev ware egdze ŋanna á de katafke. Amá ba jirire ndza aŋkwa hákuma á Yaakadada antara egdze ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ba vaci fá zhera ŋanna maa, Zakariya eddarge egdzere a naba nahete an Sheɗekwe Cuɗeɗɗe, a fantau ge mága nabiyire, a ba ŋane: ");
INSERT INTO mfi_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Yaakadada Dadaamiya á *Iserayiila-aha wá, ɓaaka kalle-aara. Aɗaba a tsaterme am iga ge emnde-aara, aŋkwa ŋezlaterŋezla, ");
INSERT INTO mfi_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","a naba jansaare ge slelya ura an hákuma jipu am dagave á wulfe-aha á sleslera-aara *Dawuda. ");
INSERT INTO mfi_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Maganaamaga názena ndza a ndaase á kya an we á nabi-aha-aara werre. ");
INSERT INTO mfi_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Aɗaba ndza a ndaase werre ganakini watse á ŋezlamiŋezla am erva á kelaade-aha, ɓaaka názu tá de eksaná itare áte miya ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ndza a baterán ge eggye-aha á miya ganakini watse á zatervarze dem eggyeggye, á de viyanaaka namana-aara ɗekiɗeki. Una ŋanna á maganá ŋane kina. ");
INSERT INTO mfi_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Aɗaba ndza a zanu ba waɗa-aara Dadaamiya ge eggyemiya Ibrahima, ");
INSERT INTO mfi_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ganakini watse á ŋezlemiyaaŋezla am erva á kelaade-aha á miya, á de gamive emnde a slera-aara na ni tá an higa an ervauŋɗe, ");
INSERT INTO mfi_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ta emnde cuɗeɗɗe, ta emnde a jirire á katafke-aara ma vaatara keni. ");
INSERT INTO mfi_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","«Ay ekka wá, egdza-aaruwa, ká de gev nabi á Dadaamiya Slekse. Aɗaba ká de zlálá ka á katafke á Yaakadada, ká de tsatsanaa ka baráma-aara. ");
INSERT INTO mfi_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Watse ká fateremá ka am vuwa ge emnde-aara ganakini á se lyaterá ŋane, á se ƴateraare haypa-aha-aatare baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Aɗaba kwakya wayavire antara maggwire á Dadaamiya. Á de maraminá ba ŋane parakkire-aara á sawa am samaya, ");
INSERT INTO mfi_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ge maraterá parakkire ge emnde na tá am tabeɗammire, tá kuva emtsa na; antara ge kwaramise zlálá áte baráma á hairire.» ");
INSERT INTO mfi_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Daaci a walte ge Yuhanna, farfe eŋkale-aara keni ba kwakya, a fantau ge de njá am kaamba, dem sarte na ni a marse ire-aara á katafke á Iserayiila-aha-aatare baɗemme, ganakini ŋane sleslera á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Á ba am sarte ŋanna yaireya Yuhanna na maa, jerje elva á sawa áza male á haha á Rauma baɗemme, zhera-aara Agustus, geni sey tá já jembel á emnde na tá am kwara-aara baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Já jembel á emnde ŋanna wá, zuŋŋwire-aara ba una ŋanna. Am sarte ŋanna maa, ndza Kiriniyus una slekse ƴaikke am haha á Siriya. ");
INSERT INTO mfi_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Daaci baɗemme á emnde, ma ware keni a zlala, á de puwa zhera-aara á ba am ekse-aara. ");
INSERT INTO mfi_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusufa keni maa, a naba tsetehe am Nasarátu am kwara á Galili, a zlala á dem Baytilama ekse á sleksu *Dawuda werre am kwara á Yahudiya. Aɗaba ŋane wulfe á Dawuda ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Daaci ta zlala antara Maari na á shebaná ŋane lyemlye huɗe na, geni ta de puwa zhera-aatare itare keni. ");
INSERT INTO mfi_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Am sarte na tá am Baytilama ŋanna maa, a naba hyephe ge sarte á Maari, ");
INSERT INTO mfi_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","a yaa egdzere zhele, egdzere zuŋŋwire-aara. A yanaa á ba am bere á dabba-aha, aɗaba ɓaaka sleɗe am bere á wayve-aha ge kwakyire á nalga. Daaci a faɗeme am baukta, a zlavanaahe am náza za duksa á dabba-aha. ");
INSERT INTO mfi_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Am ekse ŋanna maa, tá aŋkwa suni-aha wá, itare tá njá á ba am kaamba-aatare. An vaƴi wá, tá hare á ba tsákwá hyema áte walda-aha-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","An vaƴi vacite ŋanna maa, a naba jesaarhe ge malika á Yaakadada á katafke-aatare, Yaakadada a naba maraa parakkire-aara an tsaka ire ásete itare wá, jaterja lyawa jipu. ");
INSERT INTO mfi_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Amá: «A wakurka lyawa,» a ba malika na á elvan ge itare. «Aɗaba ya sakuraa labáre á higa, á de gev higa ƴaikke ge emnde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Aŋkwa yarakuraaya Slelya ura á ba an vaƴi na, am ekse á *Dawuda. Egdze ŋanna wá, ba ŋane una *Almasiihu, Yaakadada. ");
INSERT INTO mfi_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Náwa názena ni kwá de dise egdze ŋanna átekwa: watse kwá de berá egdzere áŋwaslire an faɗa am baukta, á zlava am náza za duksa á dabba-aha.» ");
INSERT INTO mfi_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Am iga á una ŋanna maa, kerteŋ, jarsaarje dikele á malika-aha umele á sawa am samaya, ta se jamme antara ŋane, ta fantau ge gala Dadaamiya, a ba itare: ");
INSERT INTO mfi_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Daradza wá, á zlayán ba ge Dadaamiya palle am samaya. A tsekwaa hairire-aara á sem duniya, á sem emnde na ni a wayateraa ŋane.» ");
INSERT INTO mfi_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Am sarte na ƴaraterƴa malika-aha, zlarzlálá á dem samaya maa, a ba suni-aha am dagave-aatare: «Mi zlalawa á dem Baytilama, mí de zhara názena a jesaara áhuwa, a baminaa Yaakadada na.» ");
INSERT INTO mfi_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Daaci ta naba tsetehe, ta zlala á ba an hadzala, ta de beraa Maari antara Yusufa, ira egdzere áŋwaslire á zlava am náza za duksa á dabba-aha. ");
INSERT INTO mfi_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Zhararaazhárá egdzere maa, ta tsakse názena ni a baternaa malika áte egdze ŋanna baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Baɗemme á emnde na ta cenaa názena ta tsakatersaa suni-aha na, tá maga ba najipu. ");
INSERT INTO mfi_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maari wá, ŋane cenáncena elva ŋanna baɗemme, ŋanaaŋa am ire-aara, aŋkwa á eddzama am ervauŋɗe-aara. ");
INSERT INTO mfi_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Am iga a una ŋanna maa, ta naba eptsa-aatare suni-aha na á dem tate-aatare. Tá aŋkwa gálá Dadaamiya am ƴaikkire-aara átira zlala. Ta galanaa aɗaba názena ta naana itare, antara názena ta cenanaa itare na baɗemme, aɗaba ta de beraa duksa na a baternaa malika na baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Am hare ge tiisire maa, hyephye sarte ge ɓela egdzere am sheɗekwe. Ta fete zhera keni ba vacite ŋanna. Ta fete zhera á Yaisu. Una zhera na ni a ndaana malika, ba huɗe-aara keni zlaɓe shanka emmeŋara na. ");
INSERT INTO mfi_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Hyephye sarte á bara Maari maa, ta naba zlala á de maga názena a ndaana *tawraita á Muusa áte mukse na a yaa egdzere, geni a gevge cuɗeɗɗe zlaɓe ádaliye. Daaci ta duhe, ta dáná antara egdzere á de katafke á Yaakadada am *mashidi ƴaikke am Urusaliima, geni átuge ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Aɗaba aŋkwa an puwa am wakita á Dadaamiya, geni baɗemme á egdzere zhele na egdza walire na wá, á wálá átuge Yaakadada. ");
INSERT INTO mfi_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ta vanta antara sadake-aatare ge Yaakadada áte una a ndaana tawraita-aara, a ba ŋane: «Tá fá takala-aha buwa bi takala-aha á masar buwa.» ");
INSERT INTO mfi_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ay, am sarte ŋanna maa, ndza aŋkwa zhele umele am Urusaliima, zhera-aara Simaun. Zhele ŋanna slefa-zherwe áte Dadaamiya jipu, ura mággwe. Ŋane á ufa ba edda una ni watse á se lyaterá ŋane *Iserayiila-aha baɗemme na. Aŋkwa Sheɗekwe Cuɗeɗɗe keni antara ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","A ndandaha Sheɗekwe ŋanna, geni ŋane á emtseka ɗekiɗeki, máki nánka *Almasiihu Sleɓela á Yaakadada. ");
INSERT INTO mfi_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ay, vacite ŋanna maa, a naba banánba Sheɗekwe Cuɗeɗɗe, geni a ezzlala zlaɓe ádaliye á dem *mashidi ƴaikke. Am sarte na ni tara emmeŋara antara eddeŋara ge Yaisu, ta daa Yaisu á dem mashidi ge de maganaa názena a ndaana *tawraita na wá, ta de beraa ba Simaun ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simaun a de lyevaa egdze na am erva-aara, a naba slafanaa we-aara ge Dadaamiya, a ba ŋane: ");
INSERT INTO mfi_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Yaakadada-aaruwa, kina wá, gevge názena ndza ka binaa ka na. Ƴanƴa a emtsemtsa sleslera á ŋa á ba an hairire. ");
INSERT INTO mfi_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Aɗaba puwantepuwa ice-aaruwa áte edda una ni ka ɓelanaa ka ge se lya emnde. ");
INSERT INTO mfi_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ya nanna uŋŋule á lya na ka tsatsateraa ka ge nalgaadama baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Una wá, ŋane parakkire na ni á de marakse am ice á emnde a duniya baɗemme, tá de diyaksediye. Á de gev daradza ƴaikke ge emnde á ŋa Iserayiila-aha keni.» ");
INSERT INTO mfi_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tara emmeŋara antara eddeŋara ge Yaisu, tá maga ba najipu á elva na á tsakaná Simaun áte egdza-aatare na. ");
INSERT INTO mfi_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simaun a naba gater barka. Am iga á una ŋanna, a ba ŋane á elvan ge Maari: «Egdze na náwa ŋane na wá, á de maraterná ŋane Dadaamiya ge emnde, amá tá de lyiyeka emnde. Dadaamiya a eksese ŋane, ganakini ŋane á gev náza vaterte ektápaare ge emnde kwakya am *Iserayiila-aha. Á ba am Iserayiila-aha ŋanna zlaɓe ádaliye, emnde kwakya tá de shá ƴaikkire, á de katerteka Dadaamiya aɗaba ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Estuwa, á se marsá ŋane ásegashe názena tá slaslaná emnde am ervauŋɗe-aatare baɗemme. Ekka emmeŋara keni maa, ɓaaka zlaɗa na ni watse ká tapánka ka am ervauŋɗe á ŋa na.» ");
INSERT INTO mfi_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ndza aŋkwa mukse umele nabi, zhera-aara Hanna, ŋane egdza á Fanuyail. Fanuyail ŋane wulfe á Asair werre. Hanna ŋanna gevge emgyegwe a mukse kurcumme. Am gyaalire-aara, ndza ta magaa ba yawe vuye antara zhele-aara na a sanse am mba á eddeŋara, daaci a naba keɗehe ge zhele-aara. ");
INSERT INTO mfi_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Am iga á una ŋanna wá, gaaka zhele umele mazla-aara, a nja ba wegyegye a mukse. Vaƴi vacika a maganaa ba slera ge Dadaamiya, á eksa ndera, á ŋala ba Dadaamiya-aara am mashidi. Daaci am sarte ŋanna ta daa Yaisu á dem mashidi na wá, mukse ŋanna shanaasha yawe kul tiise ju ufaɗe. ");
INSERT INTO mfi_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","A gateraptehe ge emnde a há á Yaisu. Ŋane keni a slafanaa we-aara ge Dadaamiya. Daaci a fantau ge baterá elva-aara ge emnde na tá ufa ba sarte na ni Dadaamiya á se lya Urusaliima na. ");
INSERT INTO mfi_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Am sarte na zlarnaazle emnde a há á Yaisu mága názena a ndaana *tawraita á Yaakadada maa, ta naba da-aatare an egdzere á dem ekse-aatare am Nasarátu am kwara á Galili. ");
INSERT INTO mfi_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Egdze ŋanna aŋkwa á farfe an wala, antara an dzaŋdzaŋire. Egdze ŋanna an eŋkale jipu, an barka á Dadaamiya am vuwa. ");
INSERT INTO mfi_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ba kelaa sakanderi emnde a há á Yaisu tá de maga muŋri á *Paska am Urusaliima. ");
INSERT INTO mfi_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ate iva na Yaisu shanaasha yawe kelaawa ju buwa, ta duwa antara ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Zlauzla muŋri wá, ta naba da-aatare, amá ta ƴaa egdzere am Urusaliima, itare diyarka. ");
INSERT INTO mfi_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ta kurken ŋane keni á ba aŋkwa am dagave á emnde na ta saa kerɗe. Lauktu tá diyeddiye wá, varváha deppe á zlala. Am iga á una ŋanna, ta fantau ge tatayanaa áza emnde-aatare ge itare, antara áza emnde a diyava-aatare baɗemme, ");
INSERT INTO mfi_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","amá sharánka. Daaci ba eptsa-aatare zlaɓe ádaliye á dem Urusaliima. ");
INSERT INTO mfi_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Am hare ge keƴire lauktu ta de shanaa am *mashidi ƴaikke, á njá am dagave á malum-aha, aŋkwa á cenatercena, ámbera á ndavateru elva-aha. ");
INSERT INTO mfi_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Baɗemme á emnde na tá cená názena a ndaana ŋane, tá maga ba najipu áte ŋane. Aɗaba kwakya eŋkale-aara, jawapa-aha-aara á ba an uŋŋule-aara. ");
INSERT INTO mfi_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ba ta puwete ice-aatare áte ŋane tara emmeŋara an eddeŋara wá, tá maga ba najipu-aara. A ba emmeŋara á elvan ge ŋane: «Labára ka magaŋeraa una, egdza-aaruwa? Ŋere antara eddeŋa, daŋeremda am dzama ire ƴaikke aɗaba ka, ŋá ámbera tatayaktataya kinekineka.» ");
INSERT INTO mfi_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A ŋwaterante, a ba ŋane á elvan ge itare: «Kwá tatayiyá aɗaba uwe? Diyakurka ganakini zlaya-aaruwa ge njá am bere á Edderwa emtu?» ");
INSERT INTO mfi_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Amá cenaránka názu am elva-aara ŋanna ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Daaci a naba saa antara itare á sem Nasarátu. A fatersaarfe jipu. Amá emmeŋara wá, ba palle keni elva-aha ŋanna keɗarka ɗekiɗeki, baɗemme á ba am ire-aara. ");
INSERT INTO mfi_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Daaci aŋkwa farfa Yaisu an wala, antara an eŋkale. Hayanhaya Dadaamiya egdze ŋanna, emnde keni hayaránhaya baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Haraare áte iva na mala Tibairiyus am haha á Rauma, shanaasha yawe kelaawa jiilyeɓe am malire-aara wá, ndza sleksa Pauntiyus *Pilaatu am kwara á Yahudiya, *Hirudus slekse am kwara á Galili, egdza emmeŋara Filip á kwará Ituriya antara Tarakaunitisa, Lisaniyus slekse am kwara á Abilain. ");
INSERT INTO mfi_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Male-aha á *liman-aha wá, tara Hanas antara Kayafas. Am laukte ŋanna maa, Dadaamiya a naba banaa elva-aara ge Yuhanna egdza á Zakariya am kaamba. ");
INSERT INTO mfi_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Daaci Yuhanna a naba fantau ge ja ɗaba an waazu am ekse-aha na herherzhe an guwa á Urdun na baɗemme, a ba ŋane á elvan ge emnde: «Magaumágá tuba, lyauvaalya baptisma, á ƴakuraarƴe Dadaamiya haypa-aha á kure.» ");
INSERT INTO mfi_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Estuwa wá, názena a puwetaa nabi Aisaya na gevge. Aɗaba a ba ŋane: «Aŋkwa ura á ɓala elva am kaamba, a ba edda-aara: Tsatsawanaatsatse uŋŋule ge Yaakadada, tsawanaatse baráma-aara ba ndeɗɗe. ");
INSERT INTO mfi_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Baɗemme á ɗambake-aha watse á gevge ba kalkale, Wa-aha antara gavaye-aha baɗemme watse ɓaaka, Kwaana-aha á baráma keni watse á njeka, baɗemme watse ba tsekke. Baɗemme á baráma na an badza na, á de gevá an memiya áte kalkalire. ");
INSERT INTO mfi_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Baɗemme á emnde watse tá nanna uŋŋule a lya na ni a tateraa Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Daaci kwakya emnde ta kelaa ádeza Yuhanna am kaamba ŋanna, ganakini á magateránmaga baptisma. Amá a ba ŋane á elvan ge itare: «Egdzara á kelaade-aha na, a bakurnaa ware ganakini magaumága tuba, watse kwá de eŋzleseŋzle am názena á de magaterná Dadaamiya ge emnde na tá aŋkwa am ervauŋɗe-aara na? ");
INSERT INTO mfi_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Magaumága kure názena ni tá diyeddiye átekwa ganakini kure wá, ƴakuránƴa mága á kure werre, magakurnaamaga tuba. Bawánka mazla-aara am ire á kure ganakini miya wá, mi egdzara á Ibrahima miyenne, ázara lámbe á miya. Yá bakurá ba jirire: ba nákwá-aha na náwa ŋane na keni, Dadaamiya an hákuma á gaterve egdzara á Ibrahima. ");
INSERT INTO mfi_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ba kina keni á ba an tsatsa zlaugba ge ɗatsa náfá-aha na ni tá yeka egdzere na. Daaci baɗemme a náfá na ni á yeka egdzere emtake na wá, tá icese antara uksuwe-aara baɗemme, tá epshupshe an kárá.» ");
INSERT INTO mfi_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ba ta cenaa una ŋanna dikele á emnde ŋanna maa, ta naba ndavanuhe ge Yuhanna, a ba itare tá elvan ge ŋane: «Ay wá, ŋá maganá estara kina?» ");
INSERT INTO mfi_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A ba Yuhanna á elvan ge itare: «Edda una aŋkwa naŋgyuwe-aara buwa, a vanteva palle ge edda una ɓaaka náza-aara. Edda una aŋkwa náza za ázeŋara keni, a emmága ba estuwa.» ");
INSERT INTO mfi_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ta sawhe ge *emnde a jaha hadáma keni ásezeŋara, geni á magaterá baptisma. A ba itare tá elvan ge ŋane: «Malum, ŋere keni ŋá maganá estara?» ");
INSERT INTO mfi_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A ŋwaterante, a ba ŋane: «Fawaterarka biya názena ndahaaka shairiya á ŋgumna ge emnde.» ");
INSERT INTO mfi_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ta ganaptehe ge sawji-aha keni, a ba itare: «Ŋere maa, ŋá maganá estara?» A ba ŋane á elvan ge itare: «Lyiyauka duksa á ura ba dey an ndzeɗa na, puwauka emnde áte lamán am fida ba dey, amá pakaupaka ba ɗafa á kure.» ");
INSERT INTO mfi_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Baɗemme á emnde tá aŋkwa ufáná á ba an niya-aatare labáre, geni watse *Almasiihu ŋara ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Daaci a ba Yuhanna á elvan ge itare baɗemme: «Iya wá, yá magakurá baptisma á ba an yawe, amá aŋkwa á sawa ura umele am iga-aaruwa wá, an hákuma ba ŋane arge iya. Ba ge slesaɗanse kimake am sera keni hyanefka ya ɗekiɗeki. Ŋane wá, á se magakurá baptisma an Sheɗekwe Cuɗeɗɗe antara an kárá. ");
INSERT INTO mfi_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aŋkwa á sawa an kazlaŋa a fáhá duksa-aara keni am erva, á se fahese hiya-aara am hyaihye. Daaci watse á puweme hiya am kuvere-aara, amá hyaihye wá, watse á fante kárá na á emtseka ɗekiɗeki na.» ");
INSERT INTO mfi_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yuhanna a faterem ndzeɗa am vuwa an elva-aha gergere kwakya, a ɓalaterse á ba am una ŋanna labáre á higa keni ge emnde ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ay, á ba am sarte ŋanna maa, Yuhanna a naba valaarhe ge sleksu *Hirudus, aɗaba a eksantaava Hirudiya ge egdza emmeŋara Filip, antara aɗaba haypa-aha umele gergere a guwaa ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Aley, Hirudus a naba farhe zlaɓe ádaliye ge haypa-aha-aara, a naba ŋguɗaa Yuhanna am daŋgay. ");
INSERT INTO mfi_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Amá am sarte na zlaɓe damka Yuhanna am zawa maa, emnde baɗemme sharánsha bara ázeŋara. Yaisu keni a duhe, a de barevhe ŋane keni. Am sarte ŋanna maa, Yaisu a mága maduwa. Ŋane á maga maduwa na wá, a naba wertehe ge samaya wá, ");
INSERT INTO mfi_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","tá zhárá ba aŋkwa á tsekwa Sheɗekwe Cuɗeɗɗe ásetarge ŋane ba seke takala, á zharava ba parakke. Cekwaaŋguɗi wá, tá cená ba kwárá á ura á sawa am samaya, a ba edda-aara: «Ba ekka una ka Egdza-aaruwa, baɗemme a higa-aaruwa á ba áte ka.» ");
INSERT INTO mfi_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Am sarte na Yaisu aŋkwa á fantau ge mága slera-aara wá, á maga egdza yawe kul keƴe. Ate emnde wá, ŋane egdza á ba Yusufa. Yusufa keni maa, ŋane egdza á Haili. ");
INSERT INTO mfi_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Haili ŋane egdza á Mattat, Mattat ŋane egdza á Laiwi, Laiwi ŋane egdza á Mailiki, Mailiki ŋane egdza á Yaana, Yaana ŋane egdza á Yusufa, ");
INSERT INTO mfi_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusufa ŋane egdza á Mattatiyas, Mattatiyas ŋane egdza á Amaus, Amaus ŋane egdza á Nahum, Nahum ŋane egdza á Haisli, Haisli ŋane egdza á Nagay, ");
INSERT INTO mfi_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay ŋane egdza á Mata, Mata ŋane egdza á Mattatiyas, Mattatiyas ŋane egdza á Saimayna, Saimayna ŋane egdza á Yausaike, Yausaike ŋane egdza á Yauda, ");
INSERT INTO mfi_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yauda ŋane egdza á Yauwánan, Yauwánan ŋane egdza á Raisa, Raisa ŋane egdza á Zauraubabila, Zauraubabila ŋane egdza á Salatiyail, Salatiyail ŋane egdza á Nairi, ");
INSERT INTO mfi_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nairi ŋane egdza á Mailiki, Mailiki ŋane egdza á Addi, Addi ŋane egdza á Kausam, Kausam ŋane egdza á Ailmadam, Ailmadam ŋane egdza á Airi, ");
INSERT INTO mfi_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Airi ŋane egdza á Yaisu, Yaisu ŋane egdza á Ailiyaijair, Ailiyaijair ŋane egdza á Yaurim, Yaurim ŋane egdza á Mattat, Mattat ŋane egdza á Laiwi, ");
INSERT INTO mfi_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Laiwi ŋane egdza á Simaun, Simaun ŋane egdza á Yahuda, Yahuda ŋane egdza á Yusufa, Yusufa ŋane egdza á Yaunam, Yaunam ŋane egdza á Ailiyakim, ");
INSERT INTO mfi_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ailiyakim ŋane egdza á Mailiya, Mailiya ŋane egdza á Menna, Menna ŋane egdza á Mattata, Mattata ŋane egdza á Naatan, Naatan ŋane egdza á *Dawuda, ");
INSERT INTO mfi_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","*Dawuda ŋane egdza á Yaisa, Yaisa ŋane egdza á Aubet, Aubet ŋane egdza á Bauwas, Bauwas ŋane egdza á Sala, Sala ŋane egdza á Naasunu, ");
INSERT INTO mfi_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasunu ŋane egdza á Aminadabu, Aminadabu ŋane egdza á Admin, Admin ŋane egdza á Arni, Arni ŋane egdza á Haisruna, Haisruna ŋane egdza á Farais, Farais ŋane egdza á Yahuda, ");
INSERT INTO mfi_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda ŋane egdza á Yakubu, Yakubu ŋane egdza á Isiyaaku, Isiyaaku ŋane egdza á Ibrahima, Ibrahima ŋane egdza á Tara, Tara ŋane egdza á Nakaur, ");
INSERT INTO mfi_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakaur ŋane egdza á Saruku, Saruku ŋane egdza á Ragaw, Ragaw ŋane egdza á Falaik, Falaik ŋane egdza á Aibair, Aibair ŋane egdza á Sala, ");
INSERT INTO mfi_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ŋane egdza á Kayinam, Kayinam ŋane egdza á Arfasada, Arfasada ŋane egdza á Saim, Saim ŋane egdza á *Nuhu, Nuhu ŋane egdza á Lamaik, ");
INSERT INTO mfi_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamaik ŋane egdza á Matusala, Matusala ŋane egdza á Anuhu, Anuhu ŋane egdza á Yaratu, Yarutu ŋane egdza á Malaliyail, Malaliyail ŋane egdza á Kayinam, ");
INSERT INTO mfi_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kayinam ŋane egdza á Ainaus, Ainaus ŋane egdza á Saitu, Saitu ŋane egdza á Naadama, Naadama wá, ŋane egdza á ba Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yaisu naatenaha an Sheɗekwe Cuɗeɗɗe. Ba tse-aara am Urdun maa, Sheɗekwe Cuɗeɗɗe a naba daa ŋane á dem kaamba. ");
INSERT INTO mfi_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Hare kul ufaɗe aŋkwa á badaná Shaitaine am kaamba ŋanna. Am hare-aha ŋanna wá, zawka ba uwe keni ɗekiɗeki. Am iga á hare-aha ŋanna wá, a naba ŋanaahe ge waya. ");
INSERT INTO mfi_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","A ba Shaitaine á elvan ge ŋane: «Máki ka ba *Egdza á Dadaamiya wá, ndaanda ge nákwá na a nyefnye ɗafa, ká ezza.» ");
INSERT INTO mfi_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Amá a ba Yaisu á elvan ge ŋane: «Aŋkwa an puwa am wakita á Dadaamiya, a ba ŋane: “Ura á njá an shifa aɗaba ɗafeka palle.” » ");
INSERT INTO mfi_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Daaci Shaitaine a ɗaltaa antara ŋane ádetire ba ŋgaa, a maranaa ƴaikkire na am huɗe á duniya na baɗemme á ba am dupalle, ");
INSERT INTO mfi_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","a ba ŋane á elvan ge ŋane: «Baɗemme á ƴaikkire na am duniya antara ŋgahire-aara na, ya vakteva. Aɗaba baɗemme á una-aha ŋanna ta fime am erva ba ge iya, yá dzegwándzegwa vante ge edda una ni yá kataná ya. ");
INSERT INTO mfi_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Daaci máki kezlakiyaakezla ugje wá, baɗemme á una ŋanna ba náza á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","A ŋwanante ge Yaisu, a ba ŋane á elvan ge ŋane: «Aŋkwa an puwa am wakita á Dadaamiya, a ba ŋane: “Sey ká kezlan ugje ba ge Yaakadada, Dadaamiya á ŋa palle, ká ŋala á ba ázeŋara palle.” » ");
INSERT INTO mfi_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Shaitaine a naba zlala antara ŋane á dem huɗe á Urusaliima, ta de ɗaltaa antara ŋane áte ire á *mashidi ƴaikke. A ba ŋane á elvan ge ŋane: «Máki ka ba *Egdza á Dadaamiya wá, naba mbeɗanaambeɗa ire á ŋa á dem áhá. ");
INSERT INTO mfi_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Aɗaba aŋkwa an puwa am wakita á Dadaamiya, a ba ŋane: “Dadaamiya á de puwa malika-aha-aara, tá de faku hyema.” ");
INSERT INTO mfi_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Aŋkwa zlaɓe am tate umele, a ba ŋane: “Tá de cuwáká á ba am erva-aatare, ganakini ká janvaarka ma ba ge sera á ŋa keni áte nákwa.” » ");
INSERT INTO mfi_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yaisu a ŋwanante zlaɓe ádaliye, a ba ŋane á elvan ge ŋane: «Aŋkwa an puwa am wakita á Dadaamiya, a ba ŋane: “Badeka Yaakadada, Dadaamiya á ŋa ɗekiɗeki.” » ");
INSERT INTO mfi_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Shaitaine ŋanna zlauzle pute-aara ge bada Yaisu maa, a naba ƴanhe kwa mazla-aara, ba zlala-aara, sey vacite umele. ");
INSERT INTO mfi_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Am iga á una ŋanna maa, Yaisu a naba saa á sem huɗe á Galili, an hákuma á Sheɗekwe Cuɗeɗɗe kwakya am ŋane. Daaci emnde ta fantau ge ndaha elva-aara am kwárá á Galili baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","A fantau ge kwaraterse duksa ge emnde am mashidi-aha gergere, a gev ura an daradza áza emnde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Daaci saasa Yaisu á sem Nasarátu ekse na a waltaa am huɗe-aara. Vaci puwansepuwe maa, a naba dem mashidi, ba seke una á magán ba kelaazare. Daaci á naba tsetehe am mashidi ŋanna, geni á kátá ndaha wakita á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Daaci ta naba vante wakita á nabi Aisaya. A naba palanse wakita na, a werante ba tate na ni aŋkwa an puwa átekwa, a ba ŋane: ");
INSERT INTO mfi_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Aŋkwa Sheɗekwe á Dadaamiya antara ya. A eksisaa ba Dadaamiya, geni yá saterá labáre á higa ge talaga-aha. A ɓeliyaa ba ŋane ge saterá labáre ge daŋgay-aha, geni watse tá shansha ire-aatare. Ge wulfe-aha keni, geni watse tá shansha ice-aha-aatare. A ɓeliyaa ŋane, geni yá se satersá ya emnde na ni tá maga palasa am erva á emnde. ");
INSERT INTO mfi_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","A ɓeli geni yá se ɓala iva na Yaakadada á de magaterá ŋgurna ge emnde átekwa na.» ");
INSERT INTO mfi_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ndaasendaha maa, a faɗante wakita na, a vante ge edda una am erva-aara wakita ŋanna, daaci a njehe. Baɗemme á emnde na tá am huɗe á mashidi, tá zhárá ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","A fantau ge ndaater elva, a ba ŋane á elvan ge itare: «Elva na kwa cenanaa kure, ya ndaase am wakita na wá, gevge vatena á ba am sarte na kwa cenanaa kure na.» ");
INSERT INTO mfi_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Baɗemmire-aatare ta fantau ge zleba Yaisu, tá maga ba najipu áte shagerire á elva na a ndaasaa ŋane, a ba itare: «Há! Ábi ba ŋane egdza á Yusufa na?» ");
INSERT INTO mfi_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","A ba Yaisu á elvan ge itare: «Ndawisendahe naraje na. Diyandiya ganakini á jakurviyaaka: “Dauktar, mbanaamba ba ka ire á ŋa.” Aɗaba watse kwá banba ganakini názena ŋa cenáncena ka maganaa am Kafarnahum na wá, maganaamaga am ekse á miya keni.» ");
INSERT INTO mfi_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Daaci a fahe zlaɓe ádaliye, a ba ŋane á elvan ge itare: «Yá ndaakur ba jirire, ɓaaka nabi na ni emnde ta faa zherwe áte ŋane am ekse-aara ba ge ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Náwa yá ndaakurnda kwa: am zamane á nabi *Ailiya wá, diyakurdiya ganakini ndza kwakya ŋwasha wegyegye am dagave á Iserayiila-aha. Amá am sarte na yawe keƴe an kyalma hyaaka yawe ɗekiɗeki, samsa waya ƴaikke na wá, ");
INSERT INTO mfi_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Dadaamiya ɓelaaka Ailiya ma á dem mba á ware-aatare keni am ŋwasha ŋanna. Kwaye a ɓelanaa á dem mba á wegyegye a mukse umele á njá am Saraipta am kwara á Sidaun. ");
INSERT INTO mfi_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Am zamane á nabi Ailisa keni maa, ndza kwakya emnde a derve am *Iserayiila. Amá ba palle-aatare keni mbanaaka Ailisa ɗekiɗeki, sey ba Naaman palle ŋane ura Siriya.» ");
INSERT INTO mfi_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Baɗemmire-aatare am huɗe á mashidi ŋanna, watertuwa jipu elva ŋanna ta cenanaa itare na. ");
INSERT INTO mfi_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Daaci ta naba eksevaahe, ta danse ádete iga a ekse, ta de ɗalte áte ire á wa á ekse-aatare antara ŋane, tá kátá hanvaare á sawa áte ire á wa ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Amá a naba dese am dagave-aatare selaakke, a zlalhe shifa-aara. ");
INSERT INTO mfi_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Am iga a una ŋanna maa, Yaisu a zlala á dem Kafarnahum á ba am Galili ŋanna. An kwaskwe á puwansepuwe wá, a de kwaraterse elva á Dadaamiya ge emnde am mashidi. ");
INSERT INTO mfi_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Baɗemme á emnde ta maga najipu áte tsaha-aara, aɗaba aŋkwa hákuma am huɗe-aara. ");
INSERT INTO mfi_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Am mashidi ŋanna maa, ndza aŋkwa ura an jini am ire, a naba fu hula á ba an ndzeɗa, a ba ŋane: ");
INSERT INTO mfi_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Ekka Yaisu ura Nasarátu na mu, ká kátá uwe ka ázeŋere? Niya á ŋa ka se keɗaŋerkeɗa emtu? Iya diyanakdiya ganakini ka Ura Cuɗeɗɗe, ka sleɓela á Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yaisu a naba valarhe ge jini ŋanna, a ba ŋane á elvan ge ŋane: «Ɗuɗe we á ŋa, sesse am zhel na ba kinamina!» Daaci jini na a naba mbeɗaa zhel na am dagave á emnde, a sessehe am ŋane, maganánka ba uwe keni. ");
INSERT INTO mfi_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Baɗemme á emnde tá maga ba najipu-aara. A ba itare am dagave-aatare: «Ázara kena jeba á hákuma na am elva-aara na? Ma valar ba ge jini keni, sey á sesse degey!» ");
INSERT INTO mfi_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Daaci hyaranmehye labáre á Yaisu am kwara ŋanna baɗemme, ma am tate-ara keni tá ndaha ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Daaci ba segashe á Yaisu am mashidi ŋanna wá, a zlala ba suuwe á dem mba á Simaun. A de beraa shawle á Simaun mukse á zlava, á wáná zlagzlagi, zlagzlagi ŋanna an ndzeɗa. Daaci ta ndavanu ge Yaisu ganakini a mbanaambe. ");
INSERT INTO mfi_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","A duhe ge Yaisu ádeza mukse na, a de tsarhe, a naba valarhe ge zlagzlagi na. A naba ƴanhe ge zlagzlagi mazla-aara. Hattse a tsete ge mukse na, a fantau ge magateraa kashi. ");
INSERT INTO mfi_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Eblyablya vaciya maa, emnde kwakya ta saa emnde-aha-aatare na á waterá vuwa baɗemme áseza Yaisu. Á waterá lapikere gergere kwakya. Daaci Yaisu a puwaterar erva-aara, a mbateraahe baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Vacite ŋanna wá, kwakya jini-aha saresse am emnde, tá ámbera hula, ta bantsa itare tá elvan ge Yaisu: «Ekka wá, ka *Egdza á Dadaamiya.» Amá Yaisu a naba valaterarhe á ba an ndzeɗa, a piyaterte ba ɗekiɗeki ge ndaha elva, aɗaba itare diyardiya ganakini *Almasiihu na ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Makuralla-aara ba kyaakya ádaga wá, a naba sesse ge Yaisu am huɗe á ekse, a zlala á dem kaamba ƴiƴiye an ekse ba shagera. Baɗemme á emnde ta fantau ge tataya ŋane. De sharansha, wayarka ɗekiɗeki á ƴaterƴa Yaisu á dem tate umele. ");
INSERT INTO mfi_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Amá a ba Yaisu á elvan ge itare: «Una zlaya ganakini yá dateránda labáre á higa, elva a njá am kwara á Dadaamiya ge emnde a ekse-aha umele keni. Aɗaba ta ɓeliyaa aɗaba ba una ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Daaci ba zlala-aara, a de ɓálá waazu am mashidi-aha gergere am kwara á Yahudiya. ");
INSERT INTO mfi_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Vacite umele Yaisu ádete we á haye á *Gainaizarait. Kwakya emnde ta kelaa ádezeŋara ge cenaa elva á Dadaamiya, ta de ɓeleme am dagave. ");
INSERT INTO mfi_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Daaci Yaisu a naa paare á yawe-aha buwa, ta tsekwesaa emnde a sluwa kelfe am huɗe-aara, tá aŋkwa bárá narre-aha-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Paare-aha ŋanna wá, palle náza á Simaun. Daaci Yaisu a ɗalme am náza á Simaun ŋanna, a ba ŋane á elvan ge ŋane: «Sawa gitega emtsaaɗe á dem dagave á yawe cekwaaŋguɗi.» Daaci Yaisu a njehe am paare ŋanna átire á haye, a fantau ge kwaraterse elva á Dadaamiya ge emnde. ");
INSERT INTO mfi_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Am sarte na zlauzle elva-aara, a ba ŋane á elvan ge Simaun: «Kwaye gantega paare á dem tate na slaɗɗa yawe-aara na, sluwausluwa kelfe antara emnde á kure.» ");
INSERT INTO mfi_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Amá a ba Simaun á elvan ge ŋane: «Aɗaba ka ndaanaaka ka wá, degey ŋa hare ba paŋŋe á maga slera am tate ŋanna, má shaŋeranka duksa ɗekiɗeki, Malum.» ");
INSERT INTO mfi_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Daaci ta naba de puwa narre-aatare á dem tate ŋanna, ta sluwevaa kelfe kwakya jipu, haa a fantau ge bátá narre-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Daaci ta fantau ge ɗaha emnde-aatare tá am paare umele an erva, ge se melaterumele. Ta sem ge emnde ŋanna, a naate ge paare-aha-aatare bukerɗe an kelfe, haa paare-aha-aatare ta fantau ge ŋgya á dem yawe. ");
INSERT INTO mfi_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ba a naa una ŋanna Simaun Piyer wá, a se ŋantaa sera ge Yaisu, a ba ŋane á elvan ge ŋane: «Yaakadada-aaruwa, zlaya á ŋa ka ɗekiɗeki ganakini mí njá kerɗe an iya, aɗaba iya ya slehaypa.» ");
INSERT INTO mfi_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ge jirire wá, tara Simaun antara emnde na tá am paare kerɗe, tá maga ba najipu-aara, aɗaba ta sluwevaa kelfe ŋanna kwakya jipu. ");
INSERT INTO mfi_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ba duksa palle ge egdzara á Jaibaidaiyus tara Yakuba antara Yuhanna na tá maga slera átirpalle antara Simaun ŋanna. Amá: «A wanka lyawa,» a ba Yaisu á elvan ge Simaun. «Á fantau ba vatena na, gakevge slejaha emnde á sem sera-aaruwa mazla-aara, ba seke kelfe na ká sluwaná ka na.» ");
INSERT INTO mfi_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Daaci ta fantau ge sawa an paare-aha-aatare ásete we-aara ge haye, ta se ƴanhe baɗemme, itare ta ɗaba Yaisu. ");
INSERT INTO mfi_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Daada Yaisu á dem huɗe á ekse, a naba duhe ge zhele umele badzanvebadza derve ádezeŋara, a kezlaa ugje á katafke-aara, a ba ŋane á elvan ge ŋane: «Yaakadada, ekka wá, má wayak-wáyá ká dzegwándzegwa givege ba meteɗɗe vuwa-aaruwa.» ");
INSERT INTO mfi_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yaisu a naba pelse erva-aara, a fete áte slederve na, a ba ŋane á elvan ge ŋane: «Wayanwáyá ká mbembe.» Ba seke ndáhá á miya na a naba mbehe ge slederve meteɗɗe. ");
INSERT INTO mfi_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yaisu a fan magiya, a ba ŋane á elvan ge ŋane: «Ndaananka ma ge ware keni degiya! De maranánmára ka ba ire á ŋa ge *liman, vanteva sadake á ŋa áte una a ndaana *tawraita a Muusa, a diyareddiya emnde ganakini mbakmbire.» ");
INSERT INTO mfi_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Aley labáre á Yaisu aŋkwa á far ba de katafke am dagave á emnde. Kwakya nalga á emnde na tá kelá ásezeŋara ba kelaazare, ge se cená elva-aara antara ganakini á mbateraambe. ");
INSERT INTO mfi_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yaisu keni a ƴaterƴa ba kelaazare, a zlala á dem kaamba, a de maga maduwa áhuwa. ");
INSERT INTO mfi_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Vacite umele, Yaisu aŋkwa á kwaraterse elva á Dadaamiya ge emnde, tá aŋkwa *Farisa-aha antara malum-aha á *tawraita keni ázeŋara. Emnde ŋanna, emnde umele-aatare ta ba emnde a Galili, emnde umele ta sawa á sa am huɗe á Urusaliima, emnde umele ta sawa á sa am ekse-aha umele á ba am kwara á Yahudiya ŋanna. Aŋkwa hákuma á Yaakadada ázeŋara ge mba emnde an ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Daaci ta semhe ge emnde umele, an ura-aatare an matsa uɓiya áte ŋane baɗemme, ta saa á sepaná antara egdera-aara baɗemme. Ta tataya baráma a dáná á de katafke á Yaisu, ");
INSERT INTO mfi_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","amá jaterviyaaja aɗaba kwakya nalga á emnde. Daaci itare ta naba ɗalte áte ire á dzuguru, ta werante, ta naba velemhe ura-aatare antara egdera-aara baɗemme á de katafke á Yaisu am dagave á emnde. ");
INSERT INTO mfi_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nanna Yaisu fetarfire á emnde ŋanna maa, a ba ŋane á elvan ge ŋgurƴekwe na: «An bárá haypa-aha á ŋa baɗemme, ura-aaruwa.» ");
INSERT INTO mfi_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Daaci farantaufe malum-aha á *tawraita antara *Farisa-aha na ge dzama duksa umele, a ba itare am ervauŋɗe-aatare: «Ware kena ŋane zhel na á lyiya sleɗe á Dadaamiya na? Aŋkwa ura á dzegwándzegwa ƴanar haypa ge ura emtu, máki Dadaamiya ka palle?» ");
INSERT INTO mfi_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Amá kerteŋ diyaadiya Yaisu názena tá aŋkwa dzamaná itare. A ba ŋane á elvan ge itare: «Labára kwa dzamete una am ervauŋɗe á kure? ");
INSERT INTO mfi_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ázara una tsaftsafe jauje ge baná: An bárá haypa-aha á ŋa, bi baná: Tsettse, ezzlala an sera á ŋa? ");
INSERT INTO mfi_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Iya wá, yá kátá kwá diyeddiye geni iya *Ura á emnde baɗemme yá an hákuma ge ƴateraare haypa ge emnde am duniya na.» Daaci a ba ŋane á elvan ge edda una an matsa uɓiya-aara na: «Ya ndaa ba ekka, tsettse, eksanteksa egdera á ŋa, ezzlala á da.» ");
INSERT INTO mfi_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hattse a naba tset ge zhel na á katafke á emnde baɗemme, a eksante egdera na ta sanaa áte ŋane na, a naba da-aara, á gálá Dadaamiya átira zlala. ");
INSERT INTO mfi_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Emnde baɗemme tá maga ba najipu-aara, ta fantau ge mága lyawa á Dadaamiya am ervauŋɗe, a ba itare am dagave-aatare: «Vatena wá, namiyanna duksa!» ");
INSERT INTO mfi_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Am iga a una ŋanna maa, Yaisu a degashe á de ja ɗaba, a naa palle á *emnde a jaha hadáma umele, zhera-aara Laiwi, aŋkwa á njá am bere á hadáma ŋanna. A naba eɗɗaha Yaisu, a ba ŋane á elvan ge ŋane: «Tsettse, sawa, ɗabiɗaba.» ");
INSERT INTO mfi_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A naba tsetehe ge Laiwi, a ƴaa duksa baɗemme, ŋane a ɗaba Yaisu. ");
INSERT INTO mfi_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Daaci Laiwi a danhe á dem mba-aara, a de magaa náza za kwakya. Emnde a jaha hadáma umele antara emnde umele, ta kwakya una ta za ɗafa átirpalle antara Yaisu. ");
INSERT INTO mfi_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Daaci a naba tsekwaa ge higa á *Farisa-aha antara malum-aha-aatare na tá aŋkwa áhuwa na baɗemme, ta fantau ge wesha elva, a ba itare tá elvan ge pukura-aha á Yaisu: «Labára kwá zá duksa átirpalle antara *emnde a jaha hadáma ira emnde a mága haypa gergere na?» ");
INSERT INTO mfi_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","A ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Emnde na lapiya vuwa-aatare wá, ɓaaka wedere-aatare áza dauktar, sey ba emnde na lapika vuwa-aatare una tá deza dauktar. ");
INSERT INTO mfi_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Daaci ba duksa palle ge iya keni. Sanka ya á se tataya emnde na tá am jirire, ya se tataya ba emnde a haypa, geni tá maga tuba.» ");
INSERT INTO mfi_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ta duhe ge emnde umele ádeza Yaisu, ta de ndavanu elva. A ba itare tá elvan ge ŋane: «Pukura-aha á Yuhanna, antara pukura-aha á *Farisa-aha wá, ɓaaka sarte na ni eksarka ndera na, tá ámbera maga maduwa keni baɗemme. Labára pukura-aha á ŋa, itare tá zá ba duksa, tá shá ba yawe-aatare na?» ");
INSERT INTO mfi_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Daaci a ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Emnde na tá ɗahaterá á sem larusa keni, tá dzegwándzegwa lyaterar tsufa ndera emtu, am sarte na tá áza zhele á larusa? Tá dzegwánka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Amá aŋkwa á sawa sarte umele wá, watse tá pakyava antara zhele á larusa. Am sarte ŋanna wá, itare keni watse tá tsufa ndera.» ");
INSERT INTO mfi_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yaisu a vaterte naraje na keni. A ba ŋane á elvan ge itare: «Ɓaaka ura á tanve baukta áŋwaslire, ge de venya emgyegwe a kacakaca an ŋane. Máki estuwa, a badzanve una áŋwaslire, antara emgyegwe-aara keni tá maslaveka. ");
INSERT INTO mfi_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","«Zlaɓe ádaliye, mbazla áŋwaslire wá, tá puweka á dem emgyegwe a *kanyakanya-aha. Aɗaba máki naavena mbazla wá, á tatanvetate kanyakanya-aha na. Daaci á puwa mbazla á dem haha, kanyakanya keni badzafbadze. ");
INSERT INTO mfi_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Daaci máki mbazla áŋwaslire wá, sey tá puwaná á dem kanyakanya keni á ba áŋwaslire. ");
INSERT INTO mfi_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Daaci máki edda-aara shaushe mbazla na naavenahe wá, ɓaaka wedere-aara an una zlaɓe tsatka na. Aɗaba ta bantsa wá: Emtake ba una naavenahe.» ");
INSERT INTO mfi_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Vacite umele an kwaskwe á puwansepuwe wá, Yaisu a degashe am dagave á fe-aha á hiya praatte antara pukura-aha-aara. Duwa á pukura-aha maa, ta naba kazleva hiya, tá aŋkwa ezza. ");
INSERT INTO mfi_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","A ba *Farisa-aha umele tá elvan ge itare: «Labára kwá maga duksa na an piya an kwaskwe á puwansepuwe?» ");
INSERT INTO mfi_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","A naba ŋwaterantehe ge Yaisu, a ba ŋane á elvan ge itare: «Ekkure ndaakurseka názu ndza a maganaa *Dawuda am sarte na irice-aara antara emnde-aara baɗemme ŋateraaŋa waya na emtu? ");
INSERT INTO mfi_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Duwa-aatare á dem mashidi wá, Dawuda ŋanna a naba eksante tapiske na ta fán ge slera á Dadaamiya na, ta naba zuhe antara emnde-aara. Amá shairiya á Dadaamiya wá, a vaterte baráma á za tapiske ŋanna ba ge *liman-aha palle.» ");
INSERT INTO mfi_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Daaci a ba Yaisu á elvan ge itare zlaɓe ádaliye: «Ba ya *Ura á emnde baɗemme una, ya edda á vaci puwansepuwe ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","An vaci puwansepuwe umele zlaɓe ádaliye, Yaisu a dem mashidi, a de kwaraterse elva á Dadaamiya ge emnde. Vacite ŋanna maa, ndza aŋkwa zhele umele an emtsa erva naɗafa-aara am mashidi ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Malum-aha á *tawraita antara *Farisa-aha wá, itare tá tsagwaɗa ba Yaisu. Ta fantau ge zhárá Yaisu an eŋkale-aatare baɗemme, má watse á mbanaambe ura an kwaskwe á puwansepuwe. Aɗaba itare, tá kátá ba názena tá eksená átekwa, lauktu ma tá puwar elva. ");
INSERT INTO mfi_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Amá Yaisu diyaadiya huɗe-aatare baɗemme. A ba ŋane á elvan ge edda una an emtsa erva-aara na: «Naba tsettse, tsaatse á katafke á emnde áhuna.» Hattse a naba tsetehe ge zhel na, a tsaahe. ");
INSERT INTO mfi_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Daaci Yaisu a naba ndavateru ge emnde baɗemme, a ba ŋane á elvan ge itare: «Aŋkwa ndáva-aaruwa ázekure. A vamite baráma á mága uwe *tawraita an kwaskwe á puwansepuwe? Mága maggwire emtu, mandzawire he? Lya ura emtu, keɗa ura he?» ");
INSERT INTO mfi_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Daaci a zharateraahe, a ba ŋane á elvan ge zhel na: «Pelansepele erva á ŋa.» A naba pelansehe, erva-aara gevge ba laŋŋe ba seke erva-aara werre. ");
INSERT INTO mfi_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Amá emnde ŋanna wá, a naba jaterhe ge ervauŋɗe, ta fantau ge ndaha názena ni watse tá magante ge Yaisu am dagave-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Am sarte ŋanna maa, Yaisu a ɗaltaa áte ire á wa, a de magaa maduwa. A hare paŋŋe an ice, á maga ba maduwa áza Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","An eŋlya-waabere wá, a naba ɗante pukura-aha-aara baɗemme, a dzerse emnde kelaawa ju buwa am itare, a ba ŋane: «Kure wá, kwa emnde a ɓela.» ");
INSERT INTO mfi_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Náwa zhera-aha á emnde a ɓela ŋanna: Simaun, ŋane una Yaisu a fante zhera á Piyer, antara egdza emmeŋara Andere, Yakuba ta antara Yuhanna, Filip, Bartaulauma, ");
INSERT INTO mfi_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mata, Taumas, Yakuba á Halfa, Simaun na tá ɗahaná an edda una wayaaka tá kwaráterá emnde na, ");
INSERT INTO mfi_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yahuda á Yakuba, ira Yahuda Iskariyaut edda una a velu Yaisu áza kelaade-aha-aara na. ");
INSERT INTO mfi_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Am iga a una ŋanna maa, a naba tsekwese á sem vaada antara itare, ta se beraa emnde a ɗaba ŋane kwakya am tate ŋanna. Tá aŋkwa zlaɓe ádaliye nalga emnde ta kwakya jipu ázetare. Emnde umele-aatare ta sawa á sa am huɗe á Urusaliima, emnde umele ta sawa á ba á sa am kwara á Yahudiya ŋanna, emnde umele zlaɓe ádaliye kwaye ta sawa á sa am Tirus antara Sidaun, ekse-aha ŋanna tá áte we á haye ƴaikke. ");
INSERT INTO mfi_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Dalila á sawa á emnde ŋanna baɗemme na wá, ta se cena waazu ázeŋara antara ganakini á mbateraambe. Emnde na ndza á magaterá palasa shaitaine am dagave-aatare keni, baɗemme mbarmbe mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Vacite ŋanna wá, ma ware keni ndza á berdava ádeza Yaisu, ganakini á fetefa erva-aara áte ŋane, aɗaba aŋkwa hákuma á mbatermbe ázeŋara, mbateraambe baɗemmire-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yaisu a zharaa pukura-aha-aara, a ba ŋane á elvan ge itare: «Higa ƴaikke ge kure talage-aha, aɗaba watse kwá de njá antara Dadaamiya am ƴaikkire-aara. ");
INSERT INTO mfi_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Higa ƴaikke ge kure emnde na á wakurá waya kina, aɗaba watse á juwa á ba áte kure duksa. Higa ƴaikke ge kure emnde na kwá an yawe á kyuwa am ice kina, aɗaba watse kwá dzaktedzáká. ");
INSERT INTO mfi_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Higa ƴaikke ge kure máki emnde tá fakurá áte kelaadire, ƴarakuraaƴa, tá aŋkwa peshakurá an zlazle, tá aŋkwa epsawakurepsawa. Higa ƴaikke ge kure, má tá magakurá una-aha ŋanna aɗaba iya *Ura á emnde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ma ta magakurte una vaatara keni, naba higauhiga, a gevge geɗa ázekure. Aɗaba laɗa á kure kwakya jipu am samaya. Aɗaba eggye-aha-aatare keni ndza ta magaterán ba estuwa ge nabi-aha werre. ");
INSERT INTO mfi_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«Amá watse zlaɗa ƴaikke ge kure kwa emnde a berba aɗaba zakuruze emtakire á kure. ");
INSERT INTO mfi_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Watse zlaɗa ƴaikke ge kure kwa emnde na an emtsa waya á kure kina, aɗaba aŋkwa waya ƴaikke á katafke á kure. Watse zlaɗa ƴaikke ge kure kwa emnde na kwá aŋkwa dzáká kina, aɗaba aŋkwa emtaŋkire á katafke á kure, watse kwá kyuwetekyuwa. ");
INSERT INTO mfi_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Watse zlaɗa ge kure, máki emnde baɗemme tá aŋkwa zlebakurzleba kina, aɗaba eggye-aha-aatare keni ndza ta magaterán ba estuwa ge nabi-aha fida werre.» ");
INSERT INTO mfi_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Ya ndaa ba kure kwa emnde na kwá aŋkwa cená elva-aaruwa: Wayauwáyá an kelaade-aha á kure, magawateránmaga shagerire. ");
INSERT INTO mfi_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gawaterga barka ge emnde na tá nyainyaikurnyainye, ŋalawateruŋale Dadaamiya ge emnde na tá magakurá palasa. ");
INSERT INTO mfi_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Má ura a teɗaku babárva am ekte a hyema wá, eptsananteptsa dalbe umele keni. Má edda-aara a lyevaa zane á ŋa an ndzeɗa wá, piyananteka a dánda antara ba ɗanciki keni. ");
INSERT INTO mfi_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ma a ndavakuwa ware duksa keni, yainanveka. Má edda-aara a lyevaa duksa á ŋa an ndzeɗa, ndaveka ka, naba ƴanánƴa a zuze. ");
INSERT INTO mfi_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Daaci baɗemme á názena ni kwá kátá tá magakurná emnde ge kure na wá, kure keni magawateránmaga ge emnde umele. ");
INSERT INTO mfi_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Máki kwá waya ba emnde na ni itare keni wayarakurwáyá wá, á de galákurá ware kena? Aɗaba emnde a haypa keni tá waya ba emnde-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Máki kwá magaterá shagerire ba ge emnde na ni itare keni tá aŋkwa magakurá shagerire wá, á de galákurá ware kena? Aɗaba emnde a haypa keni, tá maga ba una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Zlaɓe ádaliye, máki kwá vaterte duksa á kure ba ge emnde na ni diyakurdiya watse tá eptsakurnaaptsa wá, á de galákurá ware kena? Aɗaba emnde a haypa keni, tá vaterte duksa-aatare ba ge emnde a haypa seke itare, aɗaba diyardiya watse tá shálishe duksa-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Amá wá, estuweka. Wayanwáyá an kelaade-aha á kure, magawateránmaga shagerire. Vawaterteva duksa á kure ge emnde, tamawka duksa umele am iga-aara. Kure, watse kwá shá laɗa kwakya, watse kwá gev egdzara á Dadaamiya Slekse. Aɗaba ŋane wá, á magaterá maggwire ge emnde na tá banka ususe antara ge emnde a mandzawe keni baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Gawevge emnde a maggwe ba seke Eddekure.» ");
INSERT INTO mfi_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Habazauka sera á emnde, kure keni, á de zakurvarze Dadaamiya am shairiya. Mbeɗawka emnde, kure keni Dadaamiya á de mbeɗakurka am shairiya. Ƴawateraarƴe ge emnde, kure keni, á ƴakuraarƴe Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Vawaterteva duksa á kure ge emnde, kure keni á ƴakuraaka Dadaamiya. Tá de ndakakuranta á ba an ndaka ge we á ervauŋɗe á kure. Aɗaba baɗemme á názena kwá magaterná kure ge emnde na wá, Dadaamiya keni á de magakurná á ba áte una ŋanna ge kure keni.» ");
INSERT INTO mfi_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yaisu a vaterte naraje na zlaɓe ádaliye, a ba ŋane á elvan ge itare: «Aŋkwa wulfe á dzegwándzegwa taɗa ukfeŋara wulfe emtu? Ábi tá de puwa á dem evege ba bukerɗe-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Á ba aŋkwa pukura ni á januje ge malum-aara an malire? Ɓaaka ɗekiɗeki, sey máki ndaasendahe laya-aara ba shagera, lauktu á shá malire seke malum-aara. ");
INSERT INTO mfi_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Labára ŋane ge ekka ká zhárá esseɓa na am ice á egdza emmeŋa, amá ká tapanaaka slalɓe slaɗɗe na am ice á ŋa ge ekka? ");
INSERT INTO mfi_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ká dzegwaná estara banán ge egdza emmeŋa: “Sansa yá sakansese esseɓa am ice egdza emmaaye,” amá ekka ka an slalɓe slaɗɗe am ice á ŋa? Egdza a fida na, sansese emtsaaɗe slalɓe slaɗɗe na am ice á ŋa na, ká nanna ice á ŋa parakke, lauktu ká de sananse esseɓa am ice ge egdza emmeŋa.» ");
INSERT INTO mfi_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Náfá shagera wá, á yeká egdzere emtaŋka. Náfá laake keni, á yeka egdzere emtake. ");
INSERT INTO mfi_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Zlaɓe ádaliye ma náfá-ara keni ta diyeddiye á ba áte egdza-aara. Aɗaba tá tsakavaaka anyaranyara áte zaza, tá tsakavaaka nderza áte dake. ");
INSERT INTO mfi_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ba duksa palle ge emndimagwaha keni. Slekemaare, á sa arge shagerire á názena an ndaka am ervauŋɗe-aara, á sanse ba názena emtake na. Slemandzawe maa, á sa arge shagerkire á názena an ndaka am ervauŋɗe-aara, á sanse ba názena emtaŋka ɗekiɗeki na. Aɗaba ba názena ni jauje am ervauŋɗe á edda-aara na wá, am mbuwe-aara keni á sanse ba ŋane.» ");
INSERT INTO mfi_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Labára kwá ɗahiya an Yaakadada, Yaakadada, amá kwá maŋka názena yá bakurná ya? ");
INSERT INTO mfi_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Cenaucena, náwa yá marakurá garava á edda una á maga názena á se cenaná ázerwa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ura estuwa, ŋane á garava an zhel sleŋkale, a nderaa bere-aara shagera. A ƴese emtsaaɗe ba shagera, lauktu a fanaa ekte áte palaha. A sawhe ge yawe a kela, a se eblyete áte bere ŋanna á ba an ndzeɗa, amá ɓaaka názu a eksanaa áte ŋane, aɗaba an ndera shagera. ");
INSERT INTO mfi_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Amá edda una ni á de maŋka názena á se cenaná ázerwa wá, ŋane á garava an edda una ni a fanaa ekte ge bere-aara á ba áte haha ba estuwa. De samsa yawe á kela, a se eblyete áte bere ŋanna wá, a naba mbeɗanaahe reppe.» ");
INSERT INTO mfi_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Am sarte na zlanaazle Yaisu tsakaterá elva-aara ge emnde, a naba zlala á dem Kafarnahum. ");
INSERT INTO mfi_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Am Kafarnahum ŋanna maa, aŋkwa male á sawji-aha á Rauma umele, lapika nave-aara na ni ŋane wayaawaya jipu na. Herzhe á degashe shifa am ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Cenáncena male ŋanna labáre á Yaisu maa, a naba ɓela male-aha á Yahudiya-aha umele ádezeŋara, geni a se mbanaambe nave-aara lapika na. ");
INSERT INTO mfi_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Daraada emnde ŋanna áza Yaisu, ta fantau ge ŋala Yaisu an ervauŋɗe-aatare palle. A ba itare tá elvan ge ŋane: «Zhele ŋanna wá, á zlayanzlaya ganakini ká de mbanaambe ura-aara ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Aɗaba zhel ŋanna keni, aŋkwa á ŋámiyá an ervauŋɗe-aara palle. Bá mashidi á ŋere keni, a nderanaa ba ŋane an nalmane-aara.» ");
INSERT INTO mfi_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Daaci a naba duhe ge Yaisu antara itare. Ba herzharanteherzhe há wá, ta naba ja ire antara slakate-aha á male á sawji-aha na a ɓelateraa ŋane áseza Yaisu. A ba ŋane: «Malum, shuŋŋuleka ɗekiɗeki ge se mba-aaruwa. Aɗaba hyanefka geni ka sem huɗe á há-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Aɗaba ba una ŋanna danka ba iya an ire-aaruwa á de katafke á ŋa. Ndaasendaha ka ba elva á ŋa palle, á mbemmbe nave-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Aɗaba iya keni, ya ba edda á hákuma; male-aha-aaruwa keni tá aŋkwa. Iya, ya male á sawji-aha. Má ya banán ge palle-aatare: Ezzlala á dem tatu estuwa, ba á zlala. Má yá ɗaha palle-aatare, ba á sawa. Má ya banán ge nave-aaruwa palle: Emmága una, sey ba á emmága.» ");
INSERT INTO mfi_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Cenáncena Yaisu elva á zhel ŋanna wá, á maga ba najipu-aara. Daaci a naba eptsavte ádeza nalga á emnde na tá aŋkwa ɗaba ŋane na, a ba ŋane á elvan ge itare: «Kwa cenáncena emtu? Á ba am *Iserayiila keni shanánka ura an fetarfire seke zhel ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Daaci ta naba eptsa-aatare ge emnde a ɓela á male á sawji-aha na, ta de beraa nave á ura-aatare na lapiya ba layye. ");
INSERT INTO mfi_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Am iga a una ŋanna maa, Yaisu a zlala á dem ekse na ta ɗahaná an Nayin. Ta ɗabanaa pukura-aha-aara antara emnde kwakya ádehuwa. ");
INSERT INTO mfi_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Daraada áte we á wakyiya á ekse maa, ta de jaa ba ire antara emnde kwakya tá sá sepa emtsa, tá daná á dem evege. Emtsa ŋanna wá, egdzere zhele palle á ba ŋane ge emmeŋara. Emmeŋara keni wegyegye a mukse. ");
INSERT INTO mfi_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yaakadada, ba a ɓelanu ice ge mukse ŋanna wá, a naba zanvaarhe. A ba ŋane á elvan ge ŋane: «Naba ɗuɗe kyuweka.» ");
INSERT INTO mfi_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Daaci a naba duhe ádeza emnde a sepa emtsa na, a de fete erva-aara áte leɓa na tá sepa emtsa átekwa na, ta naba tsaahe ge emnde a sepa emtsa na. A ba Yaisu: «Egdze a dawale, ya bakanaa ba iya, naba tsettse!» ");
INSERT INTO mfi_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","A naba tsete ge emtsa na, a njihe, a fantau ge ndaha elva. Daaci: «Kwaye egdza á ŋa,» a ba Yaisu á elvan ge emmeŋara. ");
INSERT INTO mfi_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Baɗemme á emnde tá maga ba najipu-aara, tá an lyawa á Dadaamiya am ervauŋɗe-aatare. Ta fantau ge gálá Dadaamiya, a ba itare: «Kina wá, shamiyánsha nabi ƴaikke. A tsekwaa ba Dadaamiya an ire-aara a se tsaterme am iga ge emnde-aara.» ");
INSERT INTO mfi_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Cenaráncena labare á názena a maganaa Yaisu am kwara á Yahudiya baɗemme dem ekse-aha na tá átakwe antara Yahudiya ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Daaci Yuhanna maa, de ndaaranndáhá pukura-aha-aara názena a maganaa Yaakadada na baɗemme. A naba ɗete emnde buwa am pukura-aha-aara, ");
INSERT INTO mfi_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","a ɓelaterhe ádezeŋara, geni tá de ndavanundave elva na: «Ba ekka edda una diyaŋerdiya ganakini watse á sawa na emtu? Una ka ura umele, sey ŋá tsákwá hyema ádaliye he?» ");
INSERT INTO mfi_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Daraada áza Yaisu, a ba itare tá elvan ge ŋane: «A ɓelaŋeraa Yuhanna slemaga baptisma, ge se ndavakundave: Ba ekka edda una diyaŋerdiya ganakini watse á sawa na emtu? Una ka ura umele, sey ŋá tsákwá hyema adaliye he?» ");
INSERT INTO mfi_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ay, á ba am sarte ŋanna maa, Yaisu a mbateraahe emnde kwakya am lapikere keni gergere kwakya, a ŋgyesaa shaitaine-aha am vuwa á emnde kwakya, a vaterte ice ge wulfe-aha kwakya. ");
INSERT INTO mfi_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Daaci a vaterte jawápa ge emnde na a ɓelateraa Yuhanna na, a ba ŋane á elvan ge itare: «De bawanánba kure ba názena a cenanaa hyema á kure, antara názena kwa zharanaa á ba an ice á kure na ge Yuhanna ŋanna. Bawanánba ganakini wulfe-aha sharánsha ice, emnde a dere sharánsha sera-aha-aatare, tá aŋkwa zlala ba laŋŋe, emnde a derve mbarembe ba metmette, makwaya-aha sharánsha hyema-aha-aatare, emnde na ndza emtsaremtsa keni tsatertetse, talage-aha keni maa, cenarvaacena labáre á higa. ");
INSERT INTO mfi_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Barka ge edda una má kezlanveka fetarfire-aara áte iya na.» ");
INSERT INTO mfi_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Am sarte na zlarzlala emnde a ɓela á Yuhanna maa, Yaisu a fantau ge ndaater elva á Yuhanna ge emnde, a ba ŋane á elvan ge itare: «Ndza kwa de zhárá uwe kure am kaamba? Ndza kwa de zhárá masa-aha na á gejaná effeƴa na emtu? Una ŋanna ka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ay, ndza kwa de zhárá uwe? Ndza kwa de zhárá ura am zane zariya emtu? Náwa emnde a tsakwa zane zariya, emnde a za duniya keni, tá á ba am mba á slekse-aha. ");
INSERT INTO mfi_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ay, ndza kwa de zhárá uwe? Ndza kwa de zhárá nabi á Dadaamiya ka emtu? Una ba jirire, á tsaaka á ba an nabi keni. ");
INSERT INTO mfi_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Aɗaba ba Yuhanna una wakita á Dadaamiya aŋkwa ndaha elva-aara, a ba ŋane: “Náwa yá ɓela sleɓela-aaruwa á katafke á ŋa, ge tsatsaka baráma, a ba Dadaamiya.” ");
INSERT INTO mfi_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Una ya ndaakuraa ba iya: am emndimagwaha na tá yaterá ba ŋwasha na, ɓaaka ura á jauje ge Yuhanna an malire. Aley, edda una cekwa ba ŋane am emnde na tá am *kwara á Dadaamiya wá, ŋane á jauje ge Yuhanna an malire.» ");
INSERT INTO mfi_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Daaci baɗemme á dikele á emnde ŋanna antara *emnde a jaha hadáma na tá aŋkwa am dagave-aatare, cenarvaacena waazu á Yaisu ba shagera, aɗaba itare wá, ndza ta cenaa waazu áza Yuhanna, fartarfe ganakini una ŋanna elva á Dadaamiya ba jirire, lyarvaalya baptisma ázeŋara. ");
INSERT INTO mfi_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Amá *Farisa-aha antara malum-aha á *tawraita wá, itare cenarka Yuhanna, ƴarnaaƴa názena a ɓashateraa Dadaamiya, eksararka baptisma á Yuhanna. ");
INSERT INTO mfi_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","A ba Yaisu zlaɓe ádaliye: «Yá sláterá an ware kwa emnde a zamáne na? Tá garava an uwe? ");
INSERT INTO mfi_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ta ba seke egdzara na tá beɗa ba nara áte we á layye am huɗe á ekse, a ba emnde umele tá elvan ge emnde umele-aatare: Ŋa fertakurte derma á ga gusa, shekelakurka; ŋa tsakakurte ɗákwa keni, kyuwakurka, a ba itare na. ");
INSERT INTO mfi_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Haá! Samsa Yuhanna, ŋane shanka za ɗafa, shaaka mbazla, ŋane wá, an shaitaine ɗeme ákyiye! ");
INSERT INTO mfi_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","De samsa *Ura á emnde baɗemme, ŋane wá, aŋkwa ezza, aŋkwa essha keni, ta bantsa: kwaye zhel na slera-aara ba huɗe, ŋane ɗeme wá, ura á emnde a ŋezla, antara emnde na tá maga ba haypa na akyiye. ");
INSERT INTO mfi_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Amá ilmu á Dadaamiya wá, aŋkwa á máráva jirire-aara ba parakke áza emnde-aara.» ");
INSERT INTO mfi_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Aŋkwa ura *Farisa umele, zhera-aara Simaun, a ɗaha Yaisu ge de za ɗafa am mba-aara. A naba duhe ge Yaisu, á dem mba á zhel ŋanna, tá aŋkwa zá ɗafa na. ");
INSERT INTO mfi_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ay, am ekse ŋanna maa, aŋkwa mukse zaware umele, cenáncena ganakini aŋkwa Yaisu am mba á Simaun. Daaci a naba sawhe ge mukse ŋanna an kuderá á waye-aara am erva, se-aara emtake jipu. ");
INSERT INTO mfi_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ba semsa-aara wá, a se fantau ba ge kyuwa am sera á Yaisu, a baranaa sera ge Yaisu an yawe á kyuwa, a mesanaahe an úgje á ire-aara. A ŋante sera ge Yaisu, a gante waye-aara ŋanna áte sera-aara. ");
INSERT INTO mfi_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Aŋkwa á ezzhara ura Farisa na a ɗahanaa ŋane Yaisu, a ba ŋane am ervauŋɗe-aara: «Zhel na, ma andze nabi á Dadaamiya á ba an jirire wá, ma andze a naba diyeddiye mukse na a nyamala ŋane na, antara názena á maganá ŋane baɗemme. Aɗaba kwakya haypa na á maganá ŋane.» ");
INSERT INTO mfi_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Daaci a ba Yaisu: «Simaun, aŋkwa názu yá bakaná ya.» «Naba ndaha, malum,» a ba Simaun á elvan ge ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","A ba Yaisu á elvan ge ŋane: «Aŋkwa emnde buwa á ɗabaterá ba ura palle áte gema. Palle-aatare a ɗabán ge gursa deremke buwa. Palle wá, a ɗabán ge gursa kul buwa. ");
INSERT INTO mfi_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ay, bukerɗe-aatare ɓaaka edda una á dzegwándzegwa pelese gema na. Daaci edda á gema a naba ƴateraarhe gema ŋanna bukerɗe-aatare. Ate ka mu, ware am itare á waya edda á gema-aatare na kwakya?» ");
INSERT INTO mfi_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","A ŋwanante ge Simaun, a ba ŋane: «Yá tama, á wayaná ba edda una ndza kwakya gema-aara áte ŋane na.» «Ba jire á ŋa,» a ba Yaisu á elvan ge ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Daaci a eptsavte ádeza mukse na, a ba ŋane á elvan ge Simaun: «Mukse na wá, ya sem ba estuwa á sem huɗe á há á ŋa, vakiteka yawe á bara sera, a bariyaa ba ŋane sera-aaruwa an yawe á kyuwa-aara, a mesinaahe an úgje á ire-aara. ");
INSERT INTO mfi_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Lyakivaaka an uŋŋule-aara am huɗe á há á ŋa, amá mukse na, daga ya sem ba estuwa, sem kina keni, a ŋitaa ba sera. ");
INSERT INTO mfi_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Gakifka waye áte ire-aaruwa, amá mukse na wá, a give waye-aara áte sera-aha-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Aɗaba una ŋanna yá baká ba jirire: kwakyire á wayavire-aara na ni a wayitaa an ŋane na wá, tá diyeddiye á ba áte una ŋanna, ganakini an bárá haypa-aha-aara, ma a kwakyaava estara keni.» ");
INSERT INTO mfi_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Daaci a ba ŋane á elvan ge mukse na: «An bárá haypa-aha á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Emnde na tá arge ɗafa kerɗe na, ta fantau ge dzamanaa am ervauŋɗe-aatare: «Ware kena ŋane zhel na ni á ƴanaara ŋane haypa ge ura na?» ");
INSERT INTO mfi_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Amá a ba Yaisu á elvan ge mukse na: «Lyakaalya fetarfire á ŋa, ezzlala á ba an hairire.» ");
INSERT INTO mfi_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Am iga á una ŋanna maa, Yaisu a fantau ge ja ɗaba am berni-aha antara am makwata-aha gergere, aŋkwa á magaterá waazu ge emnde, á ɓalaterá labáre á higa, elva a njá am *kwara á Dadaamiya. Pukura-aha kelaawa ju buwa na wá, tá á ba antara ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tá aŋkwa zlaɓe ŋwasha-aha umele, a ŋezlatersaa Yaisu am erva á shaitaine, a mbateraahe am lapikere gergere, itare keni ta ɗaba Yaisu am jaɗaba ŋanna. Náwa zhera á ŋwasha ŋanna: Maari mukse na tá ɗahaná an Maari á Magdala na, ŋane una Yaisu a ŋgyesaa jini-aha vuye am ŋane, ");
INSERT INTO mfi_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yuwanna, mukse á Huja nakawa am kwara á sleksu *Hirudus, Suzanna, ira ŋwasha umele na tá aŋkwa melanu ge Yaisu antara pukura-aha-aara an nalmane-aatare na. ");
INSERT INTO mfi_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ta se jamme ge emnde kwakya áza Yaisu, ta sawa am ekse-aha gergere. Yaisu a fantau ge vaterte elva á Dadaamiya an naraje na. A ba ŋane á elvan ge itare: ");
INSERT INTO mfi_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«A sesehe ge sleherɗa umele an wulfe á nalkame-aara, á de puwaná am fe-aara. Am sarte na aŋkwa á eppuwa maa, wulfe-aha umele a de valyaa áte uŋŋule. Ta payanaahe ge emnde an sera, ta tsekante ge ƴiye-aha. ");
INSERT INTO mfi_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Wulfe-aha umele a de valyaa áte cacera, a sesehe ba watsewatse, amá shekwaraaka emtsa, aɗaba ɓaaka narase. ");
INSERT INTO mfi_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wulfe-aha umele zlaɓe ádaliye, a de valyaa am dake. Ta wala antara dake, a ɓecante ge dake. ");
INSERT INTO mfi_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Amá wulfe-aha umele wá, a puwaa á ba am haha shagera. A sesehe ge nalkame ŋanna, a magaa ire. Ba kelaa ekte a yaa egdzere deremke.» A farhe zlaɓe ádaliye ge Yaisu, a ba ŋane á elvan ge itare: «Edda una máki aŋkwa hyema-aara, a cenevaacena!» ");
INSERT INTO mfi_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Am iga á una ŋanna maa, ta de ndavanuhe ge pukura-aha-aara maana á naraje ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","A ba Yaisu á elvan ge itare: «Kure wá, vararakurteva baráma geni kwá diyeddiye nasherire na am *kwara á Dadaamiya. Amá ge emnde umele wá, sey yá vaterte á ba an naraje, geni ma tá aŋkwa á zharaná á ba an ice-aatare keni, tá diseka, ma tá effa ɗeme hyema keni, tá cenanka.» ");
INSERT INTO mfi_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Náwa maana á naraje ŋanna: Wulfe wá, una ŋanna elva á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Daaci emnde umele, itare ta ba seke uŋŋule. Ta cenevaacena elva á Dadaamiya, á sawa shaitaine, á tsakse elva ŋanna am itare na, á piyaterte ge fetarfe geni a sharánka shifa-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Emnde umele, ta ba seke cacera. Tá cenevaacena waazu, tá lyiyaná á ba an higa, amá tá vanteka sleɗe am vuwa-aatare. Tá fetarfe cekwaaŋguɗi, amá má samsa zlaɗa wá, kerteŋ tá ƴanƴa. ");
INSERT INTO mfi_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Emnde umele zlaɓe ádaliye, itare ta ba seke há á dake. Tá cenevaacena tsa elva á Dadaamiya á ba an uŋŋule-aara, amá wá, tá ƴanka dzama á ire an kazlaŋa á duniya, antara tataya berbire, ira tataya emtakire á duniya na. Á ɓecantá ba una ŋanna elva á Dadaamiya na am itare na, á sanseka ire ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Amá emnde umele wá, itare ta ba seke haha na sleɗe shagera na. Má cenaráncena elva á Dadaamiya wá, tá ŋaná á ba an ervauŋɗe-aatare palle, an shagerire á ervauŋɗe. Tá farvauŋɗe, tá maga nampire.» ");
INSERT INTO mfi_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Ɓaaka ura, máki mbantembe kárá á fanus-aara ni, á uŋmbar darau bi á faná am ekte á egdera. Estuweka. Kárá á fanus wá, tá zleŋelaná á ba áte tate-aara, lauktu emnde na tá dem huɗe á bere ŋanna, tá nanna ice parakke. ");
INSERT INTO mfi_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Daaci baɗemme á názena an sheɓe kina, watse á sesse, tá nanna emnde baɗemme. Názena nasherire kina keni maa, baɗemme watse á marapsemare, watse tá diyeddiye emnde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","«Aɗaba una ŋanna maa, faufa hyema áte cená duksa á kure! Aɗaba edda una, máki aŋkwa ázeŋara na wá, watse tá de fanaarfe zlaɓe ádaliye ge ŋane. Amá edda una an erva dey wá, ba cekwa-aara na á tamaná ŋane am erva-aara ma keni tá de lyanvulye.» ");
INSERT INTO mfi_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Am iga á una ŋanna maa, ta semhe ge tara emmeŋara antara egdzar mama-aha-ŋara ge Yaisu ta sezeŋara, amá sharánka jammeje aɗaba kwakyire á nalga. ");
INSERT INTO mfi_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ta ɓelanve we ge Yaisu, a ba itare: «Náwa tá aŋkwa ndavaká tara emmeŋa antara egdzar mama-aha-ŋa ágashe.» ");
INSERT INTO mfi_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Amá a ba Yaisu á elvan ge emnde baɗemme: «Emmerwa antara egdzar mama-aha-aaruwa wá, ba emnde na tá aŋkwa cená elva á Dadaamiya, tá aŋkwa fansarfe na.» ");
INSERT INTO mfi_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Vacite umele maa, tara Yaisu antara pukura-aha-aara ta demhe am paare á yawe. A ba Yaisu á elvan ge itare: «Ebzaumibza haye ádehuwa-aara.» Daaci ta naba zlála. ");
INSERT INTO mfi_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tá aŋkwa zlálá maa, Yaisu a naba pu hare. Cekwaaŋguɗi wá, a naba tsete ge válale átire á haye ŋanna, a naba nante paare na an yawe. Daaci baɗemme-aatare, shifa-aatare a gev ba paihyhye. ");
INSERT INTO mfi_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ta de tsante Yaisu am hare na, a ba itare: «Malum, malum, degiya ma ɓaaka!» Tsetsa Yaisu, a naba valarhe ge válale na, a valarhe ge vadza á yawe keni, tseriyye ba seke ndza ɓaaka duksa. ");
INSERT INTO mfi_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Daaci a ba ŋane ge pukura-aha-aara: «Áma fetarfire á kure ge kure?» Amá itare, tá maga ba najipu-aara, jaterja lyawa keni jipu. A ba itare am dagave-aatare. «Ware kena ŋane una ni á ndaater elva ge tara válale an yawe keni, tá eccena na?» ");
INSERT INTO mfi_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Am sarte na icaransice haye tara Yaisu, daraada á dete iga a guwa am haha á Gairasaine-aha. Tate ŋanna wá, wafke-aara ba ndaŋŋe á sem Galili. ");
INSERT INTO mfi_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ba a sesehe ge Yaisu am paare wá, a se yainu á ba an ye zhele umele, ŋane keni ba ura huɗe á ekse. Zhele ŋanna haraare an shaitaine. Wayaaka an naŋgyuwe, wayaaka an bere keni, sey á njá á ba am irekhye-aha. ");
INSERT INTO mfi_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ba pute ice-aara áte Yaisu wá, a naba fu hula áseza Yaisu na, a se mbeɗaa am sera-aara, a ba ŋane á elvan ge ŋane á ba an ka kwara: «Ekka Yaisu *Egdza á Dadaamiya Slekse, ázara am dagave á miya? Tasle á ŋa, fiyemka am zlaɗa!» ");
INSERT INTO mfi_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","A ndaana aɗaba uwe una, aɗaba Yaisu a banaa elva ge shaitaine am ŋane, a ba ŋane: «Sesse am zhel na!» Shaitaine-aara ŋanna wá, maganánmaga palasa ser kwakya. Ser kwakya tá puwanem sera am sasala, tá puwante tsavaytsavaye áte erva, amá á eɓɓátá baɗemme, shaitaine ŋanna á daná á ba dem kaamba. ");
INSERT INTO mfi_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yaisu a ndavanu zhera-aara ge zhel ŋanna, a ba ŋane: «Zhera-aaruwa wá, Dikele á Emnde.» A ndaha una ŋanna, aɗaba kwakya jini-aha am ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jini-aha ŋanna ta fantau ge ŋala Yaisu, a ba itare: «Tasle á ŋa, ma ká ŋgyaŋerŋgya am ŋane keni, daŋerka á dem evege slaɗɗe na ɓaaka halavuwa-aara na.» ");
INSERT INTO mfi_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ay, am tate ŋanna maa, ndza aŋkwa walda á nabezhe ƴaikke, tá piyá áte egdza wa. Jini-aha ŋanna ta ŋala baráma áza Yaisu, geni tá dem nabezhe-aha ŋanna. Yaisu a naba vaterte baráma. ");
INSERT INTO mfi_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Daaci jini-aha na ta naba segashe am zhel ŋanna, ta deme am nabezhe-aha ŋanna, daaci baɗemme á walda kyaakya ásate egdza wa ŋanna, valyaremvalye á dem haye, a ndateruhe ge haye baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Suni-aha á nabezhe-aha ŋanna, tá zhárá duksa ŋanna wá, kyaakya zhagade ge itare keni, ta dateraa labáre ge emnde am huɗe á ekse antara áte makwata baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Daaci estuwa nalga tá kelá á dem tate ŋanna, tá de zhárá názena magavmage na. Darduwa ádehuwa maa, ta de beraa zhel na ta segashe jini-aha am ŋane na, á njá am sera á Yaisu, an tsekwa am naŋgyuwe ba seke emnde, an eŋkale-aara ba laŋŋe. Amá itare, baɗemme ta fantau ge mága lyawa. ");
INSERT INTO mfi_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Daaci emnde na ni ta naana á ba an ice-aatare mága ŋanna baɗemme na, ta fantau ge palateraa sera-aara ge emnde, geni a shanaa estara zhele ŋanna ire-aara. ");
INSERT INTO mfi_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Aley a ba emnde a haha á Gairasaine ŋanna baɗemme tá elvan ge Yaisu: «Tasle á ŋa, ezzlálá am larde á ŋere.» Aɗaba baɗemme-aatare damda lyawa am itare. Daaci Yaisu a naba deme am paare á yawe, aŋkwa á zlala. ");
INSERT INTO mfi_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Amá zhele na shansha ire-aara na, a ŋála baráma áza Yaisu, geni ŋane keni á ɗabaterɗaba. Amá a naba eptsanaahe ge Yaisu, a ba ŋane á elvan ge ŋane: ");
INSERT INTO mfi_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Eptseptsa á dem mba á kure, de bateránba názena a magakanaa Dadaamiya baɗemme na.» Daaci ba zlálá á zhele ŋanna á dá, a de hyanme názena a maganaa Yaisu na am huɗe á ekse baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","A eptsehe zlaɓe ádaliye ge Yaisu, a icanse haye ásete we-aara maa, a se tsekwaa á ba am dagave á nalga, ta se lyiya ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","A semhe ge ura male, zhera-aara Yayrus, ŋane palle á male-aha am mashidi. A se kezlaa ugje am sera á Yaisu, a fantau ge ŋalaná á dem mba-aara, ");
INSERT INTO mfi_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","aɗaba aŋkwa egdza-aara mukse palle ba ŋane, á maga yawe kelaawa ju buwa, herzhe á degashe shifa am ŋane. Tá átire á zlálá maa, emnde ta fantau ge ɓeca Yaisu. ");
INSERT INTO mfi_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ay, aŋkwa mukse umele am dagave á emnde ŋanna, yawe kelaawa ju buwa á maga ba palasa á kela á uzhe. A keɗaa nalmane-aara baɗemme áza dauktar-aha, amá ɓaaka edda una mbanaambe. ");
INSERT INTO mfi_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Daaci mukse ŋanna a naba ganaptehe ge Yaisu á kya iga, a fete erva-aara áte we á naŋgyuwe á Yaisu. Kerteŋ a naba icevhe ge kela á uzhe-aara ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","«A gejitaa ware?» a ba Yaisu. Baɗemme á emnde, ma ware keni ba iya ka. Daaci a ba Piyer á elvan ge ŋane: «Malum! Ká zhárá nalga ŋanna ká am dágave-aatare, tá ɓecakɓeca na ni a gejaktaa ware, a ba ka?» ");
INSERT INTO mfi_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Amá a ba Yaisu: «Aŋkwa ura a gejitegeje. Aɗaba tapannaatápá sessa ndzeɗa am iya.» ");
INSERT INTO mfi_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nanna mukse na ganakini á taa sheɓevka maa, a naba marse ire-aara á katafke á Yaisu ámbera á gyagya, a kezlaa ugje am sera-aara, a ndaanhe á katafke á emnde baɗemme dalila na a de gejaken naŋgyuwe á Yaisu na, antara ganakini a naba mbehe á ba am sarte ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Daaci a ba Yaisu á elvan ge ŋane: «Mbakaambe fetarfire á ŋa egdza-aaruwa, ezzlálá á ba an hairire.» ");
INSERT INTO mfi_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Zlaɓe á ba an elva ŋanna Yaisu áte we maa, a naba semhe ge ura á sawa am mba á Yayrus male am mashidi na, a ba ŋane á elvan ge Yayrus: «Ɓaaka egdzere. Ƴanƴa malum mazla-aara.» ");
INSERT INTO mfi_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Amá cenáncena Yaisu názena á ndaana ŋane. A ba Yaisu á elvan ge Yayrus: «A waŋka lyawa, naba fetarfe ka, á mbembe egdza á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Daraada á dem mba ŋanna maa, a piyaterte ge emnde baɗemme ge dem bere na á zlava egdzere am huɗe-aara. Sey a ƴateraa baráma ba ge tara Piyer, Yuhanna, Yakuba ira tara emmeŋara antara eddeŋara ge egdzere. ");
INSERT INTO mfi_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Baɗemme á emnde na tá am huɗe á há ŋanna, tá kyuwa egdze na, tá tsaka ɗákwa. Amá a ba Yaisu á elvan ge itare: «Kyuwauka, an emtseka egdzere, á pá ba háre.» ");
INSERT INTO mfi_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Amá itare ta zhárá Yaisu ba seke wuce, aɗaba diyardiya itare, ganakini ɓaaka shifa am egdzere. ");
INSERT INTO mfi_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Amá Yaisu a de ŋanaa ba erva ge egdze na, a ba ŋane á ba an ka kwara: «Naba tsettse egdza-aaruwa.» ");
INSERT INTO mfi_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A naba shifete ge egdze na, tsekwaɗɗe a naba tsetehe. Daaci a ba Yaisu: «Vawanteva náza za, a zuze.» ");
INSERT INTO mfi_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tara emmeŋara an eddeŋara tá maga ba najipu-aara. Amá Yaisu a fater magiya, geni a ndaaranka ma ba ge ware keni. ");
INSERT INTO mfi_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Vacite umele maa, Yaisu a jatermaare ge pukura-aha-aara kelaawa ju buwa, a vaterte hákuma áte jini-aha baɗemme, antara hákuma á mba emnde áte lapikere. ");
INSERT INTO mfi_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Daaci a naba ɓelaterɓela, á de ɓalaterá labáre ge emnde, elva a njá am *kwara á Dadaamiya mazla-aara, antara ganakini a mbarmbe emnde na tá áte lapikere. ");
INSERT INTO mfi_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","A ba ŋane á elvan ge itare: «Eksauka ma uwe keni am erva ge mága shula an ŋane, ma zade, ma kashi á náza za, ba nambela keni eksauka. Zlaɓe adaliye dawanka naŋgyuwe bubuwa áte kure, ma shuŋgu am lyiba keni. ");
INSERT INTO mfi_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Baɗemme á há na, máki lyarakurvaalye am huɗe-aara wá, njawinja á ba am mba ŋanna, dem sarte á zlálá á kure am ekse ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Am tate na máki lyarakurka emnde wá, zlalauzlálá am ekse-aatare, papawateraapape berbere á haha-aatare áte sera á kure. Magawateránmaga una ŋanna, watse tá disá ba itare antara Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Daaci ba zlálá-aatare ge pukura-aha, ta zlálá á de ɓala labáre á higa am ekse-aha gergere, emnde na lapika vuwa-aatare keni ta mbateraahe am tate na ta demaa itare baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Am sarte ŋanna maa, cenáncena sleksu *Hirudus názena tá maganá itare baɗemme na. Amá ba palle á názu á ndaana ŋane ɓaaka. Aɗaba ta bantsa emnde umele: «Tsettse Yuhanna slemaga baptisma am faya.» ");
INSERT INTO mfi_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","A ba emnde umele: «Una Yuhanna ka, nabi *Ailiya werre.» A ba emnde umele zlaɓe ádaliye: «A tsetaa ba nabi umele tsekemme am faya.» ");
INSERT INTO mfi_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Amá a ba sleksu Hirudus: «Ábi ndza icaniica ire áte Yuhanna. A jesaara ware zlaɓe ádaliye yá cená labáre-aara na?» Daga á ba am sarte ŋanna, Hirudus á kátá naa wafke á Yaisu. ");
INSERT INTO mfi_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Saraasa emnde a ɓela ŋara, ta se ndahanhe názena ni ta maganaa itare baɗemme ge Yaisu. Daaci a ba Yaisu á elvan ge itare: «Sawmbare mi zláláwa á dem tate umele.» Ta naba zlálá á dem ekse ŋanna tá ɗahaná an Baytisayda na, ba itare an ire-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Amá kerteŋ cenaráncena emnde, ta naba ɗabateremhe á dem tate ŋanna. De lyatervaalye Yaisu, a vaterte waazu, elva a njá am *kwara á Dadaamiya; emnde na lapika vuwa-aatare keni a mbateraahe. ");
INSERT INTO mfi_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Eblyablya vaciya maa, ta ganaptehe ge pukura-aha-aara kelaawa ju buwa, a ba itare tá elvan ge ŋane: «Puwateraapuwa nalga á emnde na mazla-aara, a zlarzlala á dem ekse-aha antara egdzar makwata-aha na herherzhe an tate na, geni tá shansha názu tá zanu ge we-aatare, antara tate na tá zlava shifa-aatare átekwa. Aɗaba tate na kaamba, mi ƴiƴiye an ekse.» ");
INSERT INTO mfi_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Amá a ba Yaisu á elvan ge itare: «Vawaterteva ba kure náza za.» Ta ŋwanante, a ba itare: «Ázeŋere ba depaiŋ ilyeɓe ámasla an kelfe buwa. Emtu ká kátá ŋá de shekwaterve náza za ge nalga na emtu?» ");
INSERT INTO mfi_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Emnde ŋanna wá, tá maga zála debu ilyeɓe. A ba Yaisu á elvan ge pukura-aha-aara: «Naba njanjawateraanjanja kure emnde kul ilyeɓe, kul ilyeɓe.» ");
INSERT INTO mfi_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","«Ane,» a ba pukura-aha, ta nabe maganaahe. ");
INSERT INTO mfi_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Daaci Yaisu a halante depaiŋ ilyeɓe, antara kelfe buwa na, a kante ice á dem samaya, a slafanaa we-aara ge Dadaamiya. Daaci a kwacaa depaiŋ-aha na, a tegateraa ge pukura-aha, geni tá vaterta itare ge nalga ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Baɗemme á emnde, ma ware keni a zuhe á ba áte huɗe-aara náza zá na, aley jauje zlaɓe ádaliye. Pukura-aha ta halante jugena-aara wárá kelaawa ju buwa. ");
INSERT INTO mfi_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Vacite umele am maduwa Yaisu ba ŋane palle, ta duhe ge pukura-aha-aara ádezeŋara. A de ndavateru elva, a ba ŋane á elvan ge itare: «Emnde mu, ta baa uwe áte iya, ta baa ya ware?» ");
INSERT INTO mfi_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ta ŋwanante, a ba itare: «Emnde umele wá, ta baa ka Yuhanna slemaga baptisma. A baa emnde umele, ka nabi *Ailiya werre. A baa emnde umele zlaɓe adaliye, ka ba nabi umele tsekemme, a tsetaa ba palle á nabi-aha werre am faya.» ");
INSERT INTO mfi_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","A ba Yaisu á elvan ge itare: «Ay kure maa, kwá ba ya ware kena?» A ŋwanante ge Piyer, a ba ŋane: «Ba ka una ka *Almasiihu, ka sawa áza Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Amá Yaisu a fater magiya kwakya, geni a ndaaranka ma ge ware keni. ");
INSERT INTO mfi_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Daaci a ba ŋane á elvan ge itare: «Iya *Ura á emnde baɗemme wá, ɓaaka pekya-aara, sey yá shushe zlaɗa kwakya. Male-aha á larde, antara male-aha á *liman-aha, ira malum-aha á *tawraita, tá de ƴiyaaƴa, watse tá de zlanaazle shifa-aaruwa baɗemme. Amá am háre ge keƴire wá, watse yá sesse zlaɓe ádaliye á ba an shifa.» ");
INSERT INTO mfi_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Daaci a ba ŋane á elvan ge emnde baɗemme: «Máki edda-aara wayaawáyá ɗaba ya wá, a dzameka shifa-aara ɗekiɗeki. Ma vaatara keni a eksanteksa dzaŋgala-aara, a ɗabiɗaba an ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Aɗaba máki edda-aara á tataya lya shifa-aara wá, á de keɗanaakeɗa. Amá edda una a keɗaa shifa-aara aɗaba iya wá, á de shansha zlaɓe ádaliye. ");
INSERT INTO mfi_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ma edda-aara a zu emtakire á duniya na baɗemme keni wá, ázara nampire-aara ge ŋane, máki keɗanaakeɗa ire-aara, á de shanka shifa na á katafke na? ");
INSERT INTO mfi_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ay degiya, ma ware una a magaa zherwe ge baa ŋane ura-aaruwire, bi ge ndaater elva-aaruwa ge emnde wá, iya *Ura á emnde baɗemme keni, watse á wiyá zherwe ge baa ŋane ura-aaruwire, má watse yá sawa an ƴaikkire á Edderwa, antara ƴaikkire-aaruwa, ira ƴaikkire á malika-aha cuɗeɗɗe. ");
INSERT INTO mfi_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yá ndaakur ba jirire, á ba am dagave á kure na keni, tá aŋkwa emnde na ni watse tá emtseka ba estuwa, sey máki naránna an ice-aatare Dadaamiya á jáhá emnde á dem kwara-aara.» ");
INSERT INTO mfi_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Á maga háre tiise am iga á elva-aara ŋanna maa, Yaisu a ɗante tara Piyer, antara Yuhanna, ira Yakuba, a ɗálá ádete ire á wa antara itare, ge de maga maduwa. ");
INSERT INTO mfi_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Am sarte na ŋane á maga maduwa áhuwa ŋanna maa, a naba eptsavte ge wafke-aara, naŋgyuwe-aara keni gevge dzayye ba telle ámbera á maga wulwulire. ");
INSERT INTO mfi_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Cekwaaŋguɗi wá, tá zhárá ba zála buwa, tá ndaha elva antara Yaisu. Emnde buwa ŋanna wá, tara Muusa antara *Ailiya nabi-aha werre. ");
INSERT INTO mfi_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ta jesaare ba estuwa an ƴaikkire á Dadaamiya. Tá aŋkwa ndaha elva antara Yaisu áte emtsa-aara na watse á de emtsa am Urusaliima, ge zlaa slera-aara baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tara Piyer wá, ndza tá am háre, am sarte na Yaisu aŋkwa á maga maduwa na. Ta tsete am háre á ba am sarte á sawa á emnde ŋanna. Daaci ta nanna itare ƴaikkire á Yaisu antara emnde buwa ŋanna ta sezeŋara na. ");
INSERT INTO mfi_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tá kátá zlálá emnde na maa, a ba Piyer á elvan ge Yaisu, «Malum, ŋere keni ŋá aŋkwa áhuna na wá, shagera jipu. Kina wá, ŋá magakurá dzadzawe-aha keƴe, palle náza á ŋa, palle náza á Muusa, palle keni náza á Ailiya.» A ndaase elva ŋanna ba estuwa, amá diyaaka názena á ndaaná ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ba ŋane á ndáhá una ŋanna wá, tabeɗamme a tsekwaterarhe ge kumba baɗemme-aatare. Daaci a naba jater ge lyawa pukura-aha na aɗaba kumba ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Cekwaaŋguɗi wá, tá cená ba kwara á sawa am kumba ŋanna, a ba edda-aara: «Una náwa ŋane na wá, Egdza-aaruwa ya ɓelaa ba ŋane. Cenaucena názena á bakurná ŋane.» ");
INSERT INTO mfi_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Am iga á kwara ŋanna maa, ta naa ba Yaisu palle mazla-aara, ta ɓaaka emnde na. Amá elva ŋanna a njaa á ba am huɗe-aatare, ɓalarka emtsaaɗe pukura-aha na ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Makuralla-aara maa, ta naba tsekwese á sawa áte ire á wa na. Emnde kwakya ta de yainu ge Yaisu. ");
INSERT INTO mfi_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Am dagave á nalga ŋanna wá, aŋkwa ura lapika egdza-aara, palle ba ŋane, a naba ɗaha Yaisu á ba an ka kwara: «Malum, malum, tasle á ŋa, zharinaazhárá egdza-aaruwa na! ");
INSERT INTO mfi_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Á maganá palase shaitaine jipu. Ba kelaa máki tsekwanvetsekwe wá, á hula egdzere, á velyanaavelye am áhá, á kelá ugbalyailye. Sey á magannaamaga palasa lauktu á ƴanƴa. ");
INSERT INTO mfi_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ya saterán ge pukura-aha á ŋa, amá dzegwaránka ŋgyanse jini ŋanna am egdzere.» ");
INSERT INTO mfi_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","A ba Yaisu á elvan ge itare: «Amá kure emnde a zamane na wá, ɓaaka fetarfire á kure ɗekiɗeki, kwa mandzawe-aha jipu! Há! Watse yá njá antara kure, yá fakurá ervauŋɗe dem laukte-ara estuwa? Siyansa kwa ka egdze á ŋa ŋanna ge iya.» ");
INSERT INTO mfi_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Aŋkwa á sawa egdze ŋanna áseza Yaisu maa, a naba velyanaahe ge jini ŋanna am ire, aŋkwa á maganá palase am áhá. Amá Yaisu a naba valarhe ge jini ŋanna, a mbanaahe egdze na, «Kwaye egdza á ŋa,» a ba ŋane á elvan ge eddeŋara. ");
INSERT INTO mfi_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Baɗemme á emnde tá maga ba najipu áte hákuma na a maganaa Dadaamiya an sleksire-aara. Am zlaɓe emnde baɗemme tá maga ba najipu áte názena á maganá ŋane baɗemme na, a ba ŋane á elvan ge pukura-aha-aara: ");
INSERT INTO mfi_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Náwa yá bakurá elva wá, a deseka elva ŋanna am ire á kure: Iya *Ura á emnde baɗemme wá, watse tá fime am erva ge emnde.» ");
INSERT INTO mfi_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Amá ba palle á názu ta cenanaa pukura-aha am elva ŋanna ɓaaka. An sheɓe maana á elva ŋanna ge itare, geni a cenaránka baɗemme. Ndavanu ge Yaisu keni, a waterwa lyawa. ");
INSERT INTO mfi_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Farantaufe pukura-aha ge mága gajawe am dagave-aatare, geni watse mala ware am itare. ");
INSERT INTO mfi_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kerteŋ diyeddiye Yaisu názena tá aŋkwa á dzamaná itare. Daaci a eksante egdzere, a tsanaahe átevge ŋane, ");
INSERT INTO mfi_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","a ba ŋane á elvan ge itare: «Ma ware una a lyevaa egdze na aɗaba iya, edda-aara a lyevaa ba iya an ire-aaruwa. Edda una lyivaalye, edda-aara a lyevaa ba sleɓeliɓela an ire-aara. Edda una a gev ba seke cekwa ba ŋane am dagave á kure wá, mala ba ŋane am kure.» ");
INSERT INTO mfi_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","A eksante elva Yuhanna, a ba ŋane á elvan ge ŋane: «Malum, ŋere wá, ŋa naa ura umele á ŋgyá jini-aha am emnde an zhera á ŋa, amá ŋa naba piyante, aɗaba ŋane ura á miya ka.» ");
INSERT INTO mfi_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","A ba Yaisu, «Aꞌaa, piyawanteka. Aɗaba máki edda-aara dagalaaka tsuwe ádete kure wá, ura á miya ba ŋane.» ");
INSERT INTO mfi_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nánna Yaisu ganakini herzhapteherzhe sarte á zlálá-aara á dem samaya maa, a naba magaa niya-aara ganakini sey á zlálá á dem Urusaliima mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tá aŋkwa zlálá maa, herzharanteherzhe ekse umele am kwárá á *Samariya, a ɓelaa pukura-aha-aara á katafke ge tsatsaná sleɗe. ");
INSERT INTO mfi_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Amá lyiyarka emnde a ekse ŋanna, aɗaba ŋane átira dem Urusaliima. ");
INSERT INTO mfi_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Daaci a ba tara Yakuba an Yuhanna tá elvan ge ŋane: «Yaakadada, wayak-waya emtu ŋá ɗáhá kárá á sa am samaya á se zlateraazle?» ");
INSERT INTO mfi_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Amá a eptsavte ge Yaisu ádezetare, a naba valaterarhe. ");
INSERT INTO mfi_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Daaci ta naba zlálá-aatare á dem ekse umele. ");
INSERT INTO mfi_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tá á ba átira zlala ŋanna maa, a naba semhe ge ura umele, a ba ŋane á elvan ge Yaisu: «Yá ɗabakɗaba ma ka deme keni.» ");
INSERT INTO mfi_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","A ŋwanante ge Yaisu, a ba ŋane á elvan ge ŋane: «Mbayka-aha tá an evege-aha-aatare, ƴiye-aha keni tá an bere-aha-aatare, amá iya *Ura á emnde baɗemme wá, ba tate na yá zlavanaazlava shifa-aaruwa átekwa keni ɓaaka.» ");
INSERT INTO mfi_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ura umele zlaɓe ádaliye maa, a ba Yaisu á elvan ge ŋane: «Sawa, ɗabiɗaba.» Amá a ba ŋane á elvan ge Yaisu: «Yaakadada, viteva baráma yá de heɗeheɗa emtsaaɗe edderwa.» ");
INSERT INTO mfi_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Amá a ba Yaisu á elvan ge ŋane: «Ƴaterƴa emtsa-aha, a heɗarheɗa emtsa-aha-aatare. Ekka wá, ezzlala á de ɓalaterá waazu ge emnde, elva a njá am *kwara á Dadaamiya mazla-aara.» ");
INSERT INTO mfi_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","A ba ura umele zlaɓe ádaliye ge keƴire, «Ƴá ɗabakɗaba, Malum, amá wá, viteva emtsaaɗe baráma yá de magaterá á jamimá shifa ge emnde a há á ŋere.» ");
INSERT INTO mfi_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","A ba Yaisu á elvan ge ŋane: «Ma ware una a gaave áte weza, ámbera á zhárá ice á dem iga wá, ɓaaka nampire á edda-aara am kwara á Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Am iga á una ŋanna maa, Yaakadada a dzerse pukura-aha umele emnde kul vuye ju buwa, a ɓelaterɓela bubuwa. A ɓelateraa á dem berni-aha antara makwata-aha na watse á duwa ŋane ádemkwa na baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Lauktu tá zlálá, a ba ŋane á elvan ge itare: «Kwakya hiya áte fe, amá cekwa emnde a ehhálá-aara á dem mba. Aɗaba una ŋanna, ŋalauŋala Edda á fe, geni á farfe ge ɓela emnde, á dem fe-aara. ");
INSERT INTO mfi_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Zlalauzlálá, náwa ya ɓelakurɓela wá, kwa ba seke egdzar kyawe-aha am dagave á indale-aha. ");
INSERT INTO mfi_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Eksawka partamami am erva, ma nambela á kashi keni. Ba kimake keni, dawánka. Tsatsauka áte baráma ge ga use áte emnde. ");
INSERT INTO mfi_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ma kwa de tsekwaa am mba á ware keni, bawateránba emtsaaɗe ge emnde a há ŋanna: A vakurteva Dadaamiya hairire. ");
INSERT INTO mfi_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Máki aŋkwa edda una an barka am vuwa am huɗe á há ŋanna wá, hairire á kure á de tsekwá áte ŋane. Máki ɓaaka wá, á eptsa hairire á kure á ba ásezekure zlaɓe ádaliye. ");
INSERT INTO mfi_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Am huɗe á há na, máki lyarakurvaalye wá, njawinja á ba am mba ŋanna, dem sarte á zlala á kure, mbaɗauka há á emnde. Naba zauza, shausha názena ni ta fanaa itare á katafke á kure. Aɗaba sleslera wá, zlayánzláyá mbera-aara. ");
INSERT INTO mfi_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Máki dakuremda am ekse, lyarakurvaalye emnde wá, zauze názena ni ta fanaa itare á katafke á kure baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mbawmbe emnde-aatare na ni lapika vuwa-aatare na. Bawateránba ge emnde a ekse ŋanna ganakini itare wá, a hyatermaa ba Dadaamiya ge njá am kwara-aara. ");
INSERT INTO mfi_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Amá am ekse na máki lyiyarakurka emnde ŋanna wá, tsawaatse áte we á layye am huɗe á ekse ŋanna, bawateránba ge emnde ŋanna: ");
INSERT INTO mfi_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ba berbere á haha á kure na áte sera á ŋere keni, náwa ŋá papakuraapape duksa á kure. Ay degiya, diyaweddiye ganakini a hyakurmaa ba Dadaamiya ge njá am kwara-aara, kwa ƴanaa ba kure.» ");
INSERT INTO mfi_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","A farhe zlaɓe ádaliye ge Yaisu: «Yá ndaakur ba jirire, vaci shairiya wá, watse ŋgulme ba shairiya na ta magaterán ge emnde a *Saudauma arge náza á emnde a ekse ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Watse zlaɗa ge kure emnde a Kaurajin, antara emnde a Baytisayda. Aɗaba najipu-aha na ya maganaa iya am ekse-aha á kure na wá, ma andze am Tirus antara Sidaun wá, ma andze tsakwaremtsakwa emnde a ekse-aha ŋanna am buhwa-aha, ma andze daremda am kelpa á kárá ge marese tuba-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Aɗaba una ŋanna, vaci shairiya wá, watse ŋgulme ba shairiya na ta magaterán ge tara Tirus antara Sidaun na arge náza á kure. ");
INSERT INTO mfi_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kina wá, yá elvan ge kure emnde a Kafarnahum. Kwa kurken watse á kakurteka Dadaamiya, watse kwá daada á dem samaya emtu? Ɓaaka kwá daaka ɗekiɗeki! Watse á gakuraage á dem jahanáma.» ");
INSERT INTO mfi_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Daaci a ba ŋane á elvan ge pukura-aha-aara: «Kure wá, edda una a cena elva á kure, a cena ba elva-aaruwa. Edda una cenaaka elva á kure, cenaaka ba elva-aaruwa. Ay degiya, edda una a ƴaa ya wá, a ƴaa ba edda una a ɓeliɓeli na.» ");
INSERT INTO mfi_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Haraare maa, saraasa pukura-aha kul vuye ju buwa na á ba an higa. A ba itare tá elvan ge Yaisu: «Yaakadada á ŋere, ba jini-aha keni faraŋersarfe, am sarte na ŋa bateraa elva an zhera á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A ba Yaisu á elvan ge itare: «Ba estuwa. Ndza ya nanna Shaitaine am sarte na á eblya á sá am samaya, ba seke mága á kárá a rade. ");
INSERT INTO mfi_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Vanakurteva hákuma ge kure, ganakini kwá payanaapaya zahe antara herdza-aha an sera-aha á kure, kwá ŋgerɗanaaŋgerɗa kelaade á kure, ma ŋane slehákuma keni, ɓaaka názu kwá kuvaná kure ɗekiɗeki am duniya na. ");
INSERT INTO mfi_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Amá wá, higa á kure a tseka á ba áte hákuma na kwa shanaa kure áte jini-aha; higauhiga aɗaba zhera-aha á kure aŋkwa an puwa am samaya.» ");
INSERT INTO mfi_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yaisu a naba shaa higa ƴaikke am sarte ŋanna, á sawa áza Sheɗekwe Cuɗeɗɗe, a ba ŋane: «Eddaye-aaruwa, ka Edda á samaya antara haha ba ka palle. Yá aŋkwa slafak we-aaruwa kwakya, aɗaba ka sateransa ka ge egdzara mesheshe názu ka sheɓatervuwe ge emnde a diya, antara emnde a eŋkale. Ba estuwa, Edderwa, una namaari á ŋa ganakini a gevge ba estuwa. ");
INSERT INTO mfi_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«Edderwa a fime duksa baɗemme am erva ge iya. Diyaweddiye ganakini ɓaaka ura á diyeddiye *Egdza á Dadaamiya, máki Eddeŋara ŋanna ka palle. Dada keni, ɓaaka ura á diyeddiye, máki Egdza-aara ka palle, antara emnde na a wayaterantaa Egdza-aara ge marateránmara.» ");
INSERT INTO mfi_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Daaci a eptsapte ádeza pukura-aha-aara, a ndaater elva na ba ge itare palle, a ba ŋane: «Higa ƴaikke ge kure, kwa emnde na kwá aŋkwa zharaná an ice á kure duksa-aha ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Yá ndaakur ba jirire, ndza kwakya nabi-aha antara slekse-aha saɗaɗɗe tá kátá puwete ice-aatare áte duksa na kwá zharaná kure kina, amá sharánka. Ndza tá kátá cenvaacena duksa na kwá cenaná kure kina, amá sharánka keni.» ");
INSERT INTO mfi_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","A tsete ge malum á *tawraita umele, a de tsagwaɗa Yaisu áte elva, a ba ŋane á elvan ge ŋane: «Malum, yá maga uwe kina lauktu yá shá shifa na á zleka na?» ");
INSERT INTO mfi_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A ŋwanante ge Yaisu, a ba ŋane á elvan ge ŋane: «Ka beraa uwe ka am tawraita? Ká cenaná estara ka, máki ká enndaha?» ");
INSERT INTO mfi_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","A ba ŋane: «A ba tawraita wá: Ewwáya Yaakadada Dadaamiya á ŋa an ervauŋɗe á ŋa baɗemme, an shifa á ŋa baɗemme, an ndzeɗa á ŋa baɗemme, ira an eŋkale á ŋa baɗemme. A ba ŋane zlaɓe ádaliye: Ewwáya sleriya á ŋa ba seke ire á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","A ba Yaisu á elvan ge ŋane: «Ŋwakteŋwa shagera. Maganaamaga una ŋanna, ká shansha shifa.» ");
INSERT INTO mfi_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Amá malum ŋanna á kátá shaná dalila ge ire-aara wá, a ba ŋane á elvan ge Yaisu: «Ware ŋanna sleriya-aaruwa ŋanna?» ");
INSERT INTO mfi_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","A ŋwanante ge Yaisu, a ba ŋane á elvan ge ŋane: «Aŋkwa ura, a tsete am Urusaliima, á tsekwa á dem Yairikau maa, a de velyeme am dagave á emnde a za baráma, ta tsakwanse am naŋgyuwe-aara, ta hyanhe an já, ta ƴán ba ge emtsa. ");
INSERT INTO mfi_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Á ba am sarte ŋanna maa, a tsete ge *liman umele, ŋane keni a ɗába ba baráma ŋanna. Ba a naa zhele na á ɓelá wá, a naba cikante, a ƴanaa baráma. ");
INSERT INTO mfi_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Adaliye a semhe ge ura *Laiwiŋkau am tate ŋanna. Ŋane keni, ba a naa zhele ŋanna, a naba cikante, a ƴanaa baráma. ");
INSERT INTO mfi_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Amá daaduwa ura *Samariya umele á dem tate ŋanna átira mága shula-aara wá, ba a naa zhele na wá, a naba zanvaarhe, ");
INSERT INTO mfi_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","a duhe á ba ádezeŋara. Ŋane a naba baranaa wige-aha na an mbazla-aara aŋkwa, a gananu waye, daaci a faɗanaahe an gabaga. A eksante zhele ŋanna, a njante áte ezzeŋwa-aara, a dáná á dem bere á tsekwa wayve-aha, a de fanu hyema áhuwa. ");
INSERT INTO mfi_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Makuralla-aara maa, a sanse gursa-aara, a vante ge edda á tate á tsekwa wayve-aha ŋanna, a ba ŋane á elvan ge ŋane: Náwa lyevaalya una, watse yá eptsa zlaɓe ádaliye á ba kya una. Naba fanufe hyema ge zhel na, ma ka keɗaa uwe keni, yá se eppela baɗemme.» ");
INSERT INTO mfi_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Daaci a ba Yaisu á elvan ge malum á *tawraita na: «Ate ka mu, ware una ura á zhele na a de velyeme am dagave á neyle-aha na?» ");
INSERT INTO mfi_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","A ba ŋane: «Ura-aara ba edda una a zanvaarze na.» Daaci a ba Yaisu á elvan ge ŋane: «Ezzlálá, ekka keni de emmága ba seke una ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yaisu átira mága shula antara pukura-aha-aara. De sharnaasha ekse umele, aŋkwa mukse zhera-aara Marta, a tsekwateraa am mba-aara. ");
INSERT INTO mfi_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Aŋkwa egdza emmeŋara mukse ge Marta ŋanna, zhera-aara Maari, ŋane a njehe am haha áza Yaisu, á cená elva na á tsakaná ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Amá Marta wá, ŋane aŋkwa á shuŋŋula ba slera-aha umele am bere a gya ɗafa. Daaci a naba seza Yaakadada, a ba ŋane á elvan ge ŋane: «Labára ɓaaka lambe á ŋa áte iya, yá shuŋŋula ba iya palle an slera-aha á mba na? Banánba seke ge egdza emmerwa na a se meliyumele.» ");
INSERT INTO mfi_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Amá a ŋwanante ge Yaakadada, a ba ŋane: «Marta, Marta, ekka ká hyaná lyuwa ge ire á ŋa an slera-aha ba dey, ");
INSERT INTO mfi_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","una ŋanna ka, una duksa ƴaikke. Maari wá, ŋane a eksese duksa ƴaikke na tá taa lyevaaka am erva-aara ɗekiɗeki na.» ");
INSERT INTO mfi_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Vacite umele am tate umele maa, Yaisu a magaa maduwa. Am iga á una ŋanna, a ba pukura-aha-aara tá elvan ge ŋane: «Yaakadada, kwaraŋersekware ge ŋere keni mága maduwa ŋanna, seke una a kwaratersaa Yuhanna ge pukura-aha-aara na.» ");
INSERT INTO mfi_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","A ba Yaisu á elvan ge itare: «Máki kwá maga maduwa wá, bawánba a ba kure: Eddeŋere Saksage, ekka wá, ka cuɗeɗɗe. Emmága dalila á ŋa ganakini emnde baɗemme a farfa zherwe áte ka. Sawa an sleksire á ŋa. ");
INSERT INTO mfi_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Vaŋerteva náza za a hyeŋerhya ma vaatara keni. ");
INSERT INTO mfi_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ƴaŋeraarƴe haypa-aha á ŋere, aɗaba ŋere keni ŋá aŋkwa ƴateraare ge emnde a haypa an ŋere baɗemme. Daŋeremka am bada á shaitaine.» ");
INSERT INTO mfi_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yaisu a fateraarhe zlaɓe ádaliye, a ba ŋane: «Máki palle á kure a shaa wayve an huɗe á vaƴiya, ɓaaka názena á faná á katafke-aara wá, sey ba a de mba á sleriya-aara, á de baná: Vawiteva ukpa, ");
INSERT INTO mfi_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","aɗaba ya shaa wayve, ɓaaka názena yá fáná á katafke-aara. ");
INSERT INTO mfi_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Bi á ŋwananteŋwa sleriya-aara ŋanna á sawa am huɗe á bere, a ba ŋane: Weshiyanteka ire! An zleŋa bere, ŋere ŋá pá háre antara yalla-aha-aaruwa. Ŋá taa tseteka mazla-aara ge vakte ukpa. Amá ŋane wá, a maŋka ervauŋɗe. ");
INSERT INTO mfi_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yá ndaakur ba jirire, ma tsarka ge vante ukpa ŋanna aɗaba urire-aatare keni wá, sey tá tsetse tá vanteva geni á hyateraaka lyuwa mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Názu yá bakurná iya wá, naba ndavaundava, tá de vakurteva. Tatayautataya, kwá de shansha. Ɗauɗaha emnde a há, tá se werakurantewera wakyiya. ");
INSERT INTO mfi_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Aɗaba ma a ndavanaa ware keni, sey á shansha. Ma a tatayanaa ware keni, sey a shansha. Ma a janaa ware wakyiya keni, tá weranantewera. ");
INSERT INTO mfi_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Emtu ware dada am kure, má egdza-aara a ndavanu nabuhwa, ŋane á vante zahe? ");
INSERT INTO mfi_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bi máki egdzere a ndavanu slaya, á vanteva emtu herdza? ");
INSERT INTO mfi_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kwa mandzawe-aha tsa, amá diyakurdiya vaterte duksa shagera ge egdzara á kure. Sakwa Eddekure na am samaya na emtu? Ŋane wá, ma a ndavanaa ware Sheɗekwe Cuɗeɗɗe ázeŋara keni, sey ba á shansha.» ");
INSERT INTO mfi_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Vacite umele maa, Yaisu aŋkwa á ŋgya jini am ura, jini ŋanna a piyanante ge ndaha elva. Ŋgyanseŋgye Yaisu jini ŋanna wá, zhele ŋanna a fantau ge ndaha elva ba laŋŋe. Baɗemme á emnde tá maga ba najipu-aara. ");
INSERT INTO mfi_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Amá ta bantsa emnde umele wá: «A vantaa ba *Bailjaibul slekse á shaitaine-aha hákuma á ŋgya jini-aha ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Emnde umele zlaɓe ádaliye, ta de tsagwaɗa Yaisu áte elva wá, a ba itare tá elvan ge ŋane: «Máki a ɓelakaa ba Dadaamiya wá, maraŋeránmárá najipu palle, ganakini ŋá diyeddiye átekwa.» ");
INSERT INTO mfi_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Amá kerteŋ diyeddiye Yaisu názu ta sawa an ŋane am ire. Daaci a ba ŋane á elvan ge itare: «Baɗemme á sleksire, máki tarapsete emnde gergere buwa am kwara ŋanna, tá aŋkwa dagala am dagave-aatare wá, sleksire ŋanna ba badzavbadze, ba bere-aha-aatare keni tá kyaɓanaakyaɓa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ba duksa palle ge Shaitaine keni. Máki gevge ni á wava ba ŋane áte ire-aara wá, á zlálá estara kwara-aara á de katafke? Aɗaba kwa bantsa kure, a vitaa ba slekse á shaitaine-aha hákuma áte jini-aha. ");
INSERT INTO mfi_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Máki estuwa wá, a vatertaa ware kena hákuma á ŋgya jini-aha am ura ge emnde á kure? Tá kyaná ba emnde á kure shairiya-aara, geni ɓaaka jirire am elva á kure. ");
INSERT INTO mfi_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yá ndaakur ba jirire, yá aŋkwa ŋgya jini-aha á ba an hákuma na a vitaa Sheɗekwe á Dadaamiya. Amaana wá, samsa ba Dadaamiya an sleksire-aara ásezekure.» ");
INSERT INTO mfi_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Yaisu aŋkwa á slá Shaitaine an slendzeɗa, a ba ŋane á elvan ge itare: «Máki ŋgwaɗapseŋgwaɗe slendzeɗa, aŋkwa á ufa há-aara wá, ɓaaka názu á geja kazlaŋa na am huɗe á há ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Amá má daaduwa edda una jauje ge ŋane an ndzeɗa wá, ba náza a erva-aara keni á lyanvulye baɗemme, á halesehale kazlaŋa-aara baɗemme, tá de zaná antara emnde-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Daaci ma ware una ɓaaka an ya keni, ŋane kelaade-aaruwa. Ma ware una á meliyuka ge jáhá emnde na, ŋane ba slezaɗaterzaɗa.» ");
INSERT INTO mfi_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Má sesse jini am ura wá, á de ja ɗaba á ba am kaamba, ge tataya puwansepuwe. Máki shanka wá, á bánba jini ŋanna, ambane yá eptsa á dem bere-aaruwa na ya segashe am huɗe-aara na. ");
INSERT INTO mfi_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Má eptsaptsa wá, á de berá ba bere an hyaɗa, an tsatse tseɗaŋŋe. ");
INSERT INTO mfi_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Daaci á zlálá-aara, á de ɗaha jini-aha umele na jaruje ba ge ŋane an mandzawire na vuye, tá sawa, tá se njá am huɗe-aara. Am iga-aara wá, edda-aara á gev ambane ba una ndza am zuŋŋwire na.» ");
INSERT INTO mfi_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ba zlauzle Yaisu am tsáká elva ŋanna wá, a ba mukse umele á ba am nalga ŋanna á elvan ge ŋane á ba an ka kwara: «Mukse na ni a sepakaa am huɗe-aara, a faku uɓa-aara na wá, higa ƴaikke ge ŋane!» ");
INSERT INTO mfi_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Amá a ba Yaisu á elvan ge ŋane: «Higa ƴaikke wá, ba náza á emnde na tá cená elva á Dadaamiya, tá aŋkwa emmága na.» ");
INSERT INTO mfi_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Am tá aŋkwa far ba jáhá ge emnde áseza Yaisu, a ba ŋane á elvan ge itare: «Amá emnde a zamane na wá, ta mandzawe-aha váyya! Itare tá aŋkwa ndava ba najipu ge diyise átekwa, máki a ɓeliyaa ba Dadaamiya, amá tá shanka ɗekiɗeki, hyaahya ba una tá aŋkwa ndaaná áte Yaunas werre na. ");
INSERT INTO mfi_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Aɗaba ba seke una ni Dadaamiya a marse hákuma-aara am Yaunas werre á katafke a emnde a *Niniwe na wá, watse ba duksa palle am *Ura á emnde baɗemme keni á katafke á emnde a zamane na. ");
INSERT INTO mfi_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Vaci shairiya wá, aŋkwa slekse mukse, watse a mbeɗateraambeɗa emnde a zamane na. Aɗaba ŋane kwaye ndza a tseta am pute, a se cena waazu á Suleymanu sle-ilmu jipu. Amá náwa aŋkwa edda una jauje ge Suleymanu kina, kure kwá ceneka. ");
INSERT INTO mfi_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Zlaɓe ádaliye, vaci shairiya wá, emnde a *Niniwe keni tá de mbeɗateraambeɗa emnde a zamane na. Aɗaba itare, am sarte na cenaráncena waazu á Yaunas wá, magarnaamaga tuba. Amá náwa aŋkwa edda una jauje ge Yaunas kina, kure kwá maŋka tuba.» ");
INSERT INTO mfi_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Ɓaaka ura, máki mbantembe kárá á fanus-aara ni, á sheɓanve am ice á duksa umele, bi á uŋmbar darau. Estuweka. Kárá á fanus wá, tá zleŋelaná á ba áte tate-aara, lauktu emnde na tá dem huɗe á bere ŋanna, tá nanna ice parakke. ");
INSERT INTO mfi_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ice á ŋa wá, ba seke kárá á fanus ge vuwa á ŋa. Má lapiya ice á ŋa wá, baɗemme á vuwa á ŋa ba parakke. Amá má shagerka ice á ŋa wá, vuwa á ŋa baɗemme á ba am tabeɗammire. ");
INSERT INTO mfi_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Aɗaba una ŋanna maa, sey ká fá hyema ba shagera, ganakini parakkire na am ka na, a nyefka tabeɗammire. ");
INSERT INTO mfi_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Daaci máki baɗemme á vuwa á ŋa ká á ba am parakkire, ɓaaka tate na am tabeɗammire wá, ɓaaka tate na ni ká nanka keni áte ka, ba seke kárá á fanus aŋkwa á maraká parakkire-aara.» ");
INSERT INTO mfi_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Am sarte na zlauzle Yaisu am tsáká elva-aara maa, a naba ɗante ge ura *Farisa umele, ge de zá ɗafa am mba-aara. A naba duhe ge Yaisu, á de zá ɗafa na. ");
INSERT INTO mfi_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Á maga ba najipu ura Farisa na áte Yaisu, aɗaba a naa Yaisu baraaka erva lauktu á zá ɗafa. ");
INSERT INTO mfi_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Amá a ba Yaisu á elvan ge ŋane: «Kwaye kwa mága á kure *Farisa-aha: Kwá bárá iga á náza sha duksa antara tasa-aha á za duksa á kure, amá am huɗe á kure wá, kwa neyle-aha an tsaka ire, kwa emnde a mandzawe ba kure. ");
INSERT INTO mfi_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Amá kwa uce-aha degiya kure! Máki a nderanaa Dadaamiya iga á duksa, huɗe-aara wá, a nderanaa ŋane ka emtu? ");
INSERT INTO mfi_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kure wá, vawaterteva kure ba náza za ge talaga-aha antara názu tá shushe, kure kwá gev ba emnde cuɗeɗɗe, ma am uwe keni. ");
INSERT INTO mfi_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Watse zlaɗa ge kure Farisa-aha, aɗaba ɗále-aha, tara ɗále á minti antara daugdza ira ɗále-aha umele wá, kwá aŋkwa vante luser-aara ge Dadaamiya. Amá tara jirire antara wayavire áte Dadaamiya wá, kwá maganá an iga a erva. Mbate keni ma andze kwá maganá á ba antara una-aha ŋanna, ɓaaka una kwá ƴanseƴe. ");
INSERT INTO mfi_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Watse zlaɗa ge kure Farisa-aha, aɗaba kwá kátá ba sleɗe na ni átire ge náza á emnde baɗemme na am mashidi, kwá kátá emnde tá gakur use an ga ire am dagave á zlamaha. ");
INSERT INTO mfi_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Watse zlaɗa ge kure! Aɗaba kwa ba seke irekhya-aha na diyarka emnde, tá naba zlálá átekwa na.» ");
INSERT INTO mfi_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Daaci a ba malum á *tawraita umele á elvan ge ŋane: «Malum, názena ká tsakaná ka na wá, ká zlazlaŋerá antara ba ŋere.» ");
INSERT INTO mfi_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","«Ba estuwa,» a ba Yaisu, «Watse zlaɗa ge kure keni, kwa malum-aha á tawraita! Aɗaba kwá faterar gwatame ɗemɗeme, amá kure wá, á ba an gulanda á kure keni kwá melateruka ge sepa gwatame ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Watse zlaɗa ge kure, aɗaba kwá aŋkwa nderaná kure irekhya á nabi-aha werre na ta ceɓanaa eggye-aha á kure. ");
INSERT INTO mfi_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kwá aŋkwa maraná an una ŋanna, ganakini hayakuranhaya slera á eggye-aha á kure. Ta ceɓanaa itare nabi-aha á Dadaamiya, kwá tsatsaná kure irekhya-aha-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Aɗaba una ŋanna, a ba Dadaamiya Edda á ilmu: Watse yá ɓela nabi-aha-aaruwa, antara emnde a ɓela-aaruwa, amá watse tá de ceɓá emnde umele-aatare, emnde umele wá, tá de shateru ba zlaɗa. ");
INSERT INTO mfi_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Daaci baɗemme á uzhe á nabi-aha na ndza ta ceɓateraa an ceɓa daga am fakte á duniya na, á ba am mbiye á emnde a zamane na. ");
INSERT INTO mfi_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Daga emtsa á Habila, sem emtsa á Zakariya baɗemme. Zakariya na wá, yá ndahá elva á Zakariya na ndza ta janaa am dagave á tara bere cuɗeɗɗe antara duksa na tá faná sadake ge Dadaamiya átekwa na. Una yá ndaakur ba jirire: Baɗemme á uzhe á emnde ŋanna á ba am mbiye á emnde a zamane na. ");
INSERT INTO mfi_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Watse zlaɗa ge kure, malum-aha á *tawraita! Aɗaba kwa lyevaa egdza a tsekweram á wera tate á shá diya, kure keni kwá duka á dem huɗe-aara; emnde na tá kátá demda na keni, kwa piyaterante.» ");
INSERT INTO mfi_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sessa Yaisu am tate ŋanna, aŋkwa á zlálá maa, malum-aha á tawraita antara Farisa-aha, ta ɗabanaa an elva gergere, ta ndavanu elva-aha gergere kwakya, ");
INSERT INTO mfi_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ge tsagwaɗanaa an ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Am sarte ŋanna maa, jammeje nalga áza Yaisu wá, ma debu wanyara keni ta hyephye, tá zlálá á ba áte sera-aatare. Ba wera we-aara zuŋŋwe wá, a ndaater ba ge pukura-aha-aara emtsaaɗe, a ba ŋane á elvan ge itare: «Tsufantsufa ire á kure átuge shahi á makala á *Farisa-aha. Amaana wá, ɓaakire á jirire na tá maganá itare. ");
INSERT INTO mfi_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Aɗaba ɓaaka duksa na an sheɓe kina, á de sheɓaavesheɓe mazla-aara. Ɓaaka duksa na ni nasherire kina, tá de diseka emnde. ");
INSERT INTO mfi_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yá bakurná aɗaba una ŋanna, baɗemme á názena ni kwá ndaaná kure an sheɓe kina, tá de cenáncena emnde ba parakke. Názena kwá ndaaná kure kina á dem hyema antara ura umele keni, watse tá cenáncena emnde baɗemme, ba seke ta ɓalanaa an ɓala á dem huɗe á ekse.» ");
INSERT INTO mfi_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Ya ndaa ba kure emnde-aaruwa: kuvauka emndimagwaha na ma ta ceɓaa ba shifa á kure keni, ɓaaka názu tá maganá itare áte kure mazla-aara na. ");
INSERT INTO mfi_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Edda una kwá kuvaná kure wá, edda una ni an hákuma á já shifa am duniya na, zlaɓe ádaliye an hákuma á dakurá á dem kárá á jahanama. Názu yá bakurná iya wá, kuvaukuva ba ŋane palle. ");
INSERT INTO mfi_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«Njeɗu-aha ilyeɓe tá velan ba ge kwaɓa buwa ka emtu? Amá ɓaaka una a viyanaa Dadaamiya ba palle-aatare keni. ");
INSERT INTO mfi_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ba duksa palle ge kure keni. Ba úgje á ire á kure keni an kezla baɗemme áza Dadaamiya. Gazlawka ɗekiɗeki, kwá an daradza ba kure arge njeɗu-aha ŋanna, ma wanyara keni.» ");
INSERT INTO mfi_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Una yá bakurná ba iya; ma ware una sheɓaaka, a enndaha ba parakke á katafke á emnde, ganakini ya Yaakadada-aara wá, iya *Ura á emnde baɗemme keni, yá de enndaha ba parakke á katafke á malika-aha á Dadaamiya, ganakini ŋane ura-aaruwire. ");
INSERT INTO mfi_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Amá edda una ƴiyaaƴa á katafke á emnde wá, iya keni yá de ƴanaaƴa edda-aara á katafke á malika-aha á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","«Máki ura a ndaase elva mandzawe áte *Ura á emnde baɗemme wá, á naba ƴanarƴe Dadaamiya haypa-aara. Amá edda una, má a ndaase elva mandzawe áte Sheɗekwe Cuɗeɗɗe wá, ɓaaka ƴanarƴe ge ŋane ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Má watse darákurda á de katafke á shairiya wá, ma ta dákurá á de katafke á male-aha am mashidi, ma ta dákurá á de katafke á male-aha á ekse, ma ta dákurá á de katafke á slekse-aha keni, a wakurka lyawa ɗekiɗeki. Dzamauka ire á názena kwá de ndaaná kure, ge lyá ire á kure. ");
INSERT INTO mfi_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Aɗaba á de bakuranba Sheɗekwe Cuɗeɗɗe á ba am sarte ŋanna názena kwá ndaaná kure.» ");
INSERT INTO mfi_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Á ba ura umele á elvan ge Yaisu, á ba am jahava wá, «Malum, ndaandaa seke ge egdza emmerwa a tegaŋeransetege waráta á eddeŋere na.» ");
INSERT INTO mfi_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","A ba Yaisu á elvan ge ŋane: «Ya ndaa ba ka ura-aaruwa, a givaa ware narkali á kure bi sletegakurá waráta ge kure?» ");
INSERT INTO mfi_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Daaci a ba ŋane á elvan ge emnde baɗemme: «Faufa hyema ba shagera am elva a gaa nalmane. Aɗaba emtakire á njá wá, tá shaná an nalmane ka, una ma edda-aara a shaa nalmane ba seke uwe keni.» ");
INSERT INTO mfi_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Daaci a vaterte naraje na, a ba ŋane á elvan ge itare: «Aŋkwa sleberba umele kwakya fe-aha-aara, a herɗaa hiya kwakya. ");
INSERT INTO mfi_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","A ba ŋane am ervauŋɗe-aara: Kina mu, yá de puwaná áme hiya-aaruwa na, aɗaba ɓaaka sleɗe mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","A ba ŋane: Názena yá de maganá ya kina wá, sey yá kyáɓá kuvere-aha-aaruwa na, yá nderá una saɗaɗɗe, lauktu yá gyega hiya-aaruwa na á dem huɗe-aara, antara duksa-aha-aaruwa umele baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Estuwa wá, yá banba am ire-aaruwa, ganakini ɓaaka lambe-aaruwa, ɓaaka zlakta á nalmane-aaruwa, ma yawe wanyara keni yá zá ba ŋane. Yá naba banánba ge ire-aaruwa, ganakini geɗaktegeɗa mazla-aara, naba ezza, essha, ɓaaka lambe á ŋa. ");
INSERT INTO mfi_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Amá a ba Dadaamiya á elvan ge ŋane: Ekka ka uce! Á ba an vaƴiya na, yá dánda shifa á ŋa. Daaci baɗemme á nalmane ŋanna ka jahanán ge ire á ŋa na wá, watse á zaná ware?» ");
INSERT INTO mfi_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yaisu a far elva na, a ba ŋane á elvan ge itare: «Ba duksa palle ge edda una ni á jahaná nalmane ba ge ire-aara, amá am ice á Dadaamiya wá, talage ba dey.» ");
INSERT INTO mfi_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Daaci a ba ŋane á elvan ge pukura-aha-aara: «Yá bakurná aɗaba ba una ŋanna: Dzamauka ire an názena kwá de zaná kure, bi kazlaŋa na kwá de tsekwaná áte vuwa á kure. ");
INSERT INTO mfi_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Aɗaba ƴaikka ba shifa arge náza za, ƴaikka ba vuwa arge naŋgyuwe. ");
INSERT INTO mfi_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Zharauzhárá á ba áte zalke-aha. Wallá tá já duksa ka, tá icáná á dem bere ka, tá an tate á sheɓa duksa ka, tá an kuvere ka, uwe ka, á geláterá ba Dadaamiya. Ƴaikka ba kure ka arge ƴiye-aha ŋanna emtu, a jakurma uwe? ");
INSERT INTO mfi_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ware am kure, á dzegwándzegwa slaɗva shifa-aara ba cekwaaŋguɗi keni an dzámá ire na á maganá ŋane? ");
INSERT INTO mfi_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Máki diyakurdiya ganakini ɓaaka názu kwa dzegwanaa kure ba una cekwa keni wá, kwá dzamán ge uwe ire á umele? ");
INSERT INTO mfi_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Zharauzhárá zlaɓe ádaliye áte ugbene-aha áte másá, tá maga slera ka, tá há zane ka, uwe ka. Amá yá ndaakur ba jirire, ba Suleymanu an kwakyire á nalmáne-aara na keni ndza tsekwámka am zane na ni zariya, ba seke zariyire á palle á ugbene-aha ŋanna keni. ");
INSERT INTO mfi_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Másá na bá nánna emnde vatena aŋkwa am kaamba, amá makuralla tá fanu ge kárá ni, Dadaamiya á tsekwaneme á ba an tsekwa am ugbene-aha, sakwa kure emtu, máki cekwire á fetarfire ka? ");
INSERT INTO mfi_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Dzamauka ire á názena ni kwá de zaná kure, antara názena kwá de shaná kure ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sey ba emnde a duniya na ɗabarka Dadaamiya na una tá njá á ba dzámá duksa-aha ŋanna. Amá kure wá, magauka una ŋanna. Diyaadiya Eddekure ganakini kwá an wedere á duksa-aha ŋanna keni. ");
INSERT INTO mfi_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kure wá, duksa zuŋŋwe na kwá maganá kure wá, tatayautátaya kure ba njá am *kwárá á Dadaamiya, á de vakurteva ŋane duksa-aha umele na keni.» ");
INSERT INTO mfi_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Kure walda cekwa, a wakurka lyawa ɗekiɗeki. Aɗaba Dadaamiya a wayakurante de njá am zlanna-aara ge kure an ervauŋɗe-aara palle. ");
INSERT INTO mfi_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Naba valawuvála kazlaŋa á kure baɗemme, tegawatertega shuŋgu-aara ge talage-aha. Magawanánmaga partamami na ɓaaka bádza-aara ɗekiɗeki na ge ire á kure, jahawanánjáhá nalmáne na á iceka ɗekiɗeki na ge ire á kure am samaya. Aɗaba am samaya wá, ma neyle, ma weshege keni, ɓaaka una ni á shanaasha ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Aɗaba am tate na ni átekwa nalmáne á ŋa wá, ire á ŋa keni á ba am tate ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Ŋgwaɗawápseŋgwáɗe ba shagera, njawinja á ba am niya ge mága slera á kure, kárá á fanus á kure a njinja á ba an mbe. ");
INSERT INTO mfi_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Walaaɗi-aha, má dedde zánwe-aatare á dem tate á larusa wá, itare tá tsákwá ba hyema, geni ma a saa am laukte-ara keni, má janteja paare á bere wá, tá se weranantewera ba watsewatse. Daaci kure keni gawevge ba seke itare. ");
INSERT INTO mfi_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Yá ndaakur ba jirire: Watse higa ƴaikke ge emnde na má a se berateraa zanwe-aatare, tá á ba am niya-aatare na. Watse á tsekwemtsekwa ba ŋane am kazlaŋa á tega ɗafa, watse á vatertá ba ŋane an erva-aara sleɗe antara náza za. ");
INSERT INTO mfi_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ma a saa an huɗe á vaƴiya, ma a saa dedde am huɗe á vaƴiya keni, máki a se berater tá tsákwá ba hyema wá, jaterja geɗa ge emnde ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Aŋkwa duksa palle, diyaweddiye ba shagera: Máki diyaadiya edda á há sarte na ni watse á sawa neyle átekwa na wá, á ƴánka ni á demda neyle am mba-aara ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kure keni ba estuwa, sarte na ni watse iya *Ura á emnde baɗemme yá de sawa átekwa na wá, diyakurka. Daaci njawinja á ba am niya á kure.» ");
INSERT INTO mfi_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Daaci a ba Piyer á elvan ge ŋane: «Yaakadada! Naraje na ká ndaaná á ba áte ŋere emtu, áte emnde baɗemme he?» ");
INSERT INTO mfi_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","A ŋwanante ge Yaakadada, a ba ŋane á elvan ge ŋane: «Sleslera-ara ŋane dzayye ervauŋɗe-aara, sleŋkale zlaɓe ádaliye na? Ba edda una ni má zanwe-aara a ƴanaa huɗe á há-aara baɗemme am erva ge ŋane, á vatertá ŋane náza za ge emnde na tá am huɗe á há ŋanna baɗemme, á vatertá an laukte-aara na. ");
INSERT INTO mfi_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Higa ƴaikke ge sleslera ŋanna, máki zánwe-aara a se beranaa á ba am slera-aara. ");
INSERT INTO mfi_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yá bakurá ba jirire: Rezege-aara baɗemme keni á fanemfe am erva zánwe-aara ge sleslera estuwa. ");
INSERT INTO mfi_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Amá máki bánba sleslera ŋanna am ervauŋɗe-aara ganakini labára shekwaashekwa zánwe-aaruwa; kwaye ya keni yá maga názena á kataná ire-aaruwa. Daaci a fantau ge magatera palase an já ge emnde a slera á zánwe-aara am huɗe á há, an zála ka, an ŋwásha ka, a fantau ge zá názu am huɗe á há, á shá ba mbazla-aara haa á danse am eŋkale wá, ");
INSERT INTO mfi_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","zánwe á sleslera ŋanna keni á saasa á ba am sarte na ŋane tsakwaaka hyema ɗekiɗeki, tamaaka ɗekiɗeki na. Palase na á se maganná zánwe-aara ŋanna wá, náza enndaaka. Ŋane keni á de gev ba seke kelaade-aha-aara umele. ");
INSERT INTO mfi_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Zlaɓe ádaliye, sleslera na diyaadiya názena á kataná zánwe-aara, amá ɓaaka lambe-aara magaaka, ŋane wá, watse á shá já ba kwakya áza zánwe-aara. ");
INSERT INTO mfi_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Amá sleslera na diyaaka názena á kataná zánwe-aara, a naba magaa názena wayaaka ervauŋɗe á zánwe-aara, ŋane keni á shansha já, amá ba cekwa. Edda una máki ta vante kwakya, ta de ndavanundave keni ba kwakya. Edda una máki kwakya názu ta fanem am erva ge ŋane, tá de ndavanundave keni ba kwakya.» ");
INSERT INTO mfi_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Iya wá, ya saa ba kárá á sem duniya. Duksa na yá kataná ya kina wá, a mbetembe kárá ŋanna ba kinamina. ");
INSERT INTO mfi_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Amá wá, aŋkwa baptisma-aaruwa umele, sey magiyánmaga emtsaaɗe. Yá dzámá ba ire-aara kina, dem sarte na máki magariyánmaga na. ");
INSERT INTO mfi_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Emtu sawa-aaruwa á sem duniya na, kwa kurken ya saa hairire ŋane? Ɓaaka ɗekiɗeki. Iya, ya se tega ba ye á emnde. ");
INSERT INTO mfi_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Á de katafke cekwaaŋguɗi wá, watse emnde ilyeɓe tá am mba palle, á de tega ye-aatare gergere buwa, emnde keƴe tá arge emnde buwa, emnde buwa tá dagala an emnde keƴe. ");
INSERT INTO mfi_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tá de gyaaveka tara dada an egdza-aara; tara mama keni tá de gyaaveka an gyaale-aara; tara shawle mukse, tá de gyaaveka antara eggyeŋara.» ");
INSERT INTO mfi_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Daaci a ba Yaisu zlaɓe ádaliye á elvan ge nalga ŋanna: «Ábi kure máki kwa nánna tsettsa kumba am ekte á samaya á kya geɗi, kwá bá: Watse á hyá yawe na ba kina. Ba jirire á magava á ba áte una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Zlaɓe ádaliye, máki kwa nánna ice á effeƴa á sawa á sá am pute keni, kwá bá: Watse á sawa ŋguɗeffire ba watsewatse. Ba jirire á magava á ba áte una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Há! Iyau, nalaama-aha na aŋkwa á magava áte samaya an una á magava áte haha wá, diyakurdiya sera-aara baɗemme. Duksa-aha na aŋkwa á marakurná Dadaamiya am zamane na wá, diyakurka! Kure degiya ɓaaka jirire á kure ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Labára kwá taa diseka ba kure an ire á kure duksa na ni watse an uŋŋule-aara na? ");
INSERT INTO mfi_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Máki aŋkwa sledagala á ŋa watse á dáká á dem shairiya wá, edduwa ba watsewatse ádezeŋara, de melawemele á ba am dagave á kure, a ɗarakteka am shairiya. Aɗaba máki dakemda am erva á narkali-aha wá, itare tá de fakem am erva ge sawji-aha, sawji-aha tá dáká á ba á dem daŋgay. ");
INSERT INTO mfi_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Yá baká ba jirire: Ma a juwaa ba kwaɓa-aara keni, ká seska áhuwa ɗekiɗeki, máki pelakseka baɗemme.» ");
INSERT INTO mfi_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Á ba am sarte ŋanna maa, ta naba duhe ge emnde umele ádeza Yaisu, ta de banaa labáre á emnde a Galili na a ceɓateraa *Pilaatu ta átire a vante sadake á dabba ge Dadaamiya na. ");
INSERT INTO mfi_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","A ŋwaterante ge Yaisu a ba ŋane á elvan ge itare: «Emnde ŋanna ta ceɓateraa estuwa na wá, kwa kurken ta emnde a haypa ba itare arge emnde a Galili baɗemme emtu? ");
INSERT INTO mfi_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Estuweka ɗekiɗeki, una ya ndaakura ba iya. Máki magakurka tuba, kure keni baɗemme watse kwá emtsa ba seke itare. ");
INSERT INTO mfi_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Emtu emnde kelaawa ju tiise na a mbeɗateraar dzagwaváye am Silauwam baɗemme emtsaremtsa na wá, ta emnde a haypa ba itare arge emnde a Urusaliima baɗemme emtu? ");
INSERT INTO mfi_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Estuweka ɗekiɗeki, una ya ndaakura ba iya. Máki magakurka tuba wá, kure keni watse kwá emtsa ba seke itare.» ");
INSERT INTO mfi_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Am iga á una ŋanna maa, Yaisu a bateraa naraje na, a ba ŋane á elvan ge itare: «Aŋkwa ura an mama á nabugda am fe-aara, amá á yeka nabugda ŋanna. Á duwa á de tataya egdzere átekwa keni, á shánka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Daaci a ba edda á fe ŋanna á elvan ge edda una aŋkwa á maganá slera am fe ŋanna: Icesice náfá na kwaye ŋane na baɗemme ádegashe. Náwa yawe keƴe vatena ni, yá sawa keni ba yá shánka egdzere átekwa, labáre á badziyá fe ba dey? ");
INSERT INTO mfi_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Amá a ba sleslera-aara á elvan ge ŋane: Ánƴƴa emtsaaɗe vátena zánwe-aaruwa. Yá magantemága kyála, yá puwante nargwa, ");
INSERT INTO mfi_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ámbáne watse á yá egdzere am shifa. Máki yaaka zlaɓe ádaliye wá, lauktu watse mí icesice.» ");
INSERT INTO mfi_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","An kwaskwe á puwansepuwe umele maa, Yaisu aŋkwa á kwaraterse elva á Dadaamiya ge emnde am mashidi. ");
INSERT INTO mfi_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ay aŋkwa mukse am mashidi ŋanna wá, mukse ŋanna an jini am ŋane, badzanvebadze jini ŋanna, yawe kelaawa ju tiise á taa tsemka mukse na ndeɗɗe am zhegela. ");
INSERT INTO mfi_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nánna Yaisu mukse na wá, a naba ɗante. A ba Yaisu á elvan ge ŋane: «Mbákmbe emmerdzagwale. Ka ba layye mazla-aara.» ");
INSERT INTO mfi_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ba a ndaase una ŋanna, a puwar erva a barka-aara, ndeɗɗe a naba tsetehe ge mukse na, a fantau ba ge gálá Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Amá a naba jehe ge ervauŋɗe edda una ŋane male am mashidi ŋanna, a fantau ge tsaketera elva ge emnde baɗemme, a ba ŋane á elvan ge itare: «Diyakurdiya aŋkwa háre uŋkwahe ge mága slera-aha á kure. Máki kwá kátá lapiyire wá, a mbarakuraambe am háre-aha ŋanna, amá an kwaskwe á puwansepuwe ka.» ");
INSERT INTO mfi_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","A naba ŋwanante ge Yaakadada, a ba ŋane á elvan ge ŋane: «Amá kure wá, ɓaaka jirire á kure ɗekiɗeki. Ábi kure kwá aŋkwa ɓelá esla-aha á kure, antara ezzeŋwa-aha á kure an kwaskwe á puwansepuwe, kwá de fateru yawe? ");
INSERT INTO mfi_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ay labára kena mukse na ŋane keni ba wulfe á Ibrahima miyenne, tá taa pelanaaka an kwaskwe á puwansepuwe na? Yawe kelaawa ju tiise vátena a ŋguɗanaa Shaitaine ma.» ");
INSERT INTO mfi_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Elva á Yaisu ŋanna faterarfe zherwe kwakya ge emnde na lyarefka mbe á mukse ŋanna. Amá emnde baɗemme wá, ma ware keni ervauŋɗe-aara ba seke nama. Tá higa arge slera-aha á jirire na a maganaa Yaisu na baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","A ba Yaisu á elvan ge itare zlaɓe ádaliye: «Ba seke estara ŋane *kwárá á Dadaamiya? Yá slaterá an uwe kina? ");
INSERT INTO mfi_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kwárá á Dadaamiya wá, ŋane ba seke mága á wulfe á pilli, ura umele a eksante, a de ɓeleme am haha am fe-aara. A sesehe, a naba walete ba nafa, haa ƴiye-aha ta magaa bere-aatare áte erva-aara.» ");
INSERT INTO mfi_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yaisu a bateraa naraje umele zlaɓe ádaliye, a ba ŋane á elvan ge itare: «Yá sláná an uwe zlaɓe ádaliye *kwara á Dadaamiya? ");
INSERT INTO mfi_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kwara á Dadaamiya wá, ŋane ba seke mága á shahi á makala. Á eksevaakse mukse ba cekwaaŋguɗi, á puwante ge ukpa tasa keƴe an wasla, amá á tsantetse shahi á makala na ukpa na baɗemme.» ");
INSERT INTO mfi_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yaisu aŋkwa á maga shula á dem Urusaliima. Am shula-aara ŋanna maa, aŋkwa á tsatse am berni-aha gergere antara am makwata-aha gergere, aŋkwa á kwaraterse elva á Dadaamiya ge emnde. ");
INSERT INTO mfi_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","A duhe ura umele ádezeŋara, a ba ŋane á elvan ge ŋane: «Malum, ba jirire watse ba cekwa emnde na tá lyelye shifa-aatare na emtu?» A ŋwanante ge Yaisu, a ba ŋane á elvan ge ŋane: ");
INSERT INTO mfi_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Naba dawemde á kya we á bere ɓecce. Yá bakurá ba jirire, kwakya emnde na tá kátá demde na, amá watse tá dzegwánka. ");
INSERT INTO mfi_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","«Má watse tsetse edda á há, a zleŋte bere-aara an tsekweram ni, zlaɓe kure kwa tsatse á ba gashe wá, ma kwa fantau ge já we á bere, kwá ɗahá: Yaakadada, Yaakadada, weraŋerantewera bere keni, á de lyevka mazla-aara. Á de bakurá: Ma kwa emnde-ara keni, diyanakurka ya. Zlalauzlálá. ");
INSERT INTO mfi_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Watse kwá baná: Degiya ba ŋere emnde na ndza mi zaa duksa ba kerɗe, mi shaa yawe á miya keni ba kerɗe, ka kwaraŋerse elva á Dadaamiya áte we á layye-aha am ekse á ŋere na. ");
INSERT INTO mfi_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Názu á de ŋwakurantá ŋane wá, á de bakurá ba: Ma kwa emnde-ara keni, diyanakurka ya. Baɗemmire á kure, kwa emnde a mága haypa, a nanákurka áhuna ɗekiɗeki, zlalauzlálá á dem tate á kure! ");
INSERT INTO mfi_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Daaci kwá de kyuwá á kure áhuwa, kwá de kerɗá slare ge zlaɗa. Amá kwá zhárá tara Ibrahima antara Isiyaaku an Yakubu ira nabi-aha baɗemme tá am zlanna á Dadaamiya. Amá kure wá, puwarakurvepuwe ádegashe. ");
INSERT INTO mfi_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Watse emnde tá kela á sawa am geɗi, á sawa am yala, á sawa am pute, ira á sawa am manem baɗemme, tá de zá emtakire am zlanna á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ay degiya, emnde na tá á kataliya itare kina, emnde umele-aatare watse ta emnde a katafke ba itare. Emnde na tá á katafke itare kina keni maa, emnde umele-aatare tá de gevá am kataliya á emnde.» ");
INSERT INTO mfi_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ba vacite ŋanna zlaɓe ádaliye maa, ta duhe ge *Farisa-aha umele ádeza Yaisu, a ba itare tá elvan ge ŋane: «Ezzlálá, dánda ire á ŋa áhuna, aɗaba aŋkwa á tsagwaɗaktsagwaɗa sleksu *Hirudus á já shifa á ŋa ba ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","A ŋwaterante ge Yaisu, a ba ŋane: «De bawanánba ge maskwata á kure ŋanna wá, iya ɓaaka lambe-aaruwa, náwa yá maga ba slera-aaruwa. Yá aŋkwa ŋgyá jini-aha am emnde, yá aŋkwa mbá emnde na lapika vuwa-aatare, zlaɓe kwakya slera-aaruwa, vatena, makuralla, dem wergekse, lauktu yá zlanaazle. ");
INSERT INTO mfi_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Amá vatena, antara makuralla, dem wergekse na wá, zlaɓe yá maga ba slera-aaruwa emtsaaɗe am shula-aaruwa ge dem Urusaliima. Aɗaba á zlayánka ge nabi á Dadaamiya ganakini tá janá ágashe, sey am Urusaliima. ");
INSERT INTO mfi_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Urusaliima, Urusaliima, ekka ka ceɓaa nabi-aha, ka ceɓaa emnde na a ɓelateraa Dadaamiya an nákwá! Ser kwakya una yá kátá jema emnde á ŋa ásezerwa ba seke náza á mama á ukkula, máki á jaha egdzara-aara á dem ekte á zlambake-aara. Amá kwalakefkwale. ");
INSERT INTO mfi_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kina wá, ƴanakuraaƴa mazla-aara. Yá ndaakur ba jirire, kwá puweteka ice á kure áte iya mazla-aara, dem sarte na ni watse kwá bánba ba kure an we á kure ganakini, a gangá Dadaamiya barka ge edda una a sawa an zhera á Yaakadada na.» ");
INSERT INTO mfi_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","An vaci puwansepuwe umele maa, ɗaaranteɗaha Yaisu am mba á palle á male-aha á *Farisa-aha ge de zá ɗafa. Baɗemme á emnde na ta ɗaaterte am mba á male ŋanna tá fá ba hyema áte Yaisu. ");
INSERT INTO mfi_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ay aŋkwa ura lapika, vuwa-aara baɗemme an sháfá maa, a njehe á ba á katafke á Yaisu. ");
INSERT INTO mfi_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Daaci a ba Yaisu á elvan ge malum-aha á *tawraita, antara *Farisa-aha na tá aŋkwa áhuwa: «Am tawraita mu, aŋkwa emtu baráma ge mba ura lapika an kwaskwe á puwansepuwe, emtu an piya he?» ");
INSERT INTO mfi_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Amá ŋwaranarka ɗekiɗeki, ta ɗu ba we-aatare. Mazla-aara Yaisu a naba ŋanaahe zhel na, a mbanaahe, a ɓelanaahe, «Ezzlálá á ŋa,» a ba ŋane á elvan ge ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","A ba ŋane á elvan ge itare: «Kina kure, máki mbeɗemmbeɗa egdza á kure, bi esla á kure am suwa an kwaskwe á puwansepuwe, kwá zhagadeka emtu á de sansese?» ");
INSERT INTO mfi_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Dzegwaránka vante jawápa ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Daaci nánna Yaisu ganakini emnde na ta ɗahateraa á de zá ɗafa ŋanna, ma ware keni á dzera ba sleɗe na á kataná ŋane ge njá am huɗe-aara. A naba vaterte naraje na ge itare baɗemme, a ba ŋane á elvan ge itare: ");
INSERT INTO mfi_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Máki ɗaarakteɗáhá á dem muŋri á larusire wá, de njeka am sleɗe na ni an dárádza arge sleɗe-aha umele na ɗekiɗeki. Aɗaba diyaŋka ámbane ɗaaranteɗáhá ura male jauje ge ekka an dárádza, ");
INSERT INTO mfi_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","daaci edda una a ɗaakurɗáhá na á de baká: Tsettse, ƴanánƴa sleɗe ŋanna ge male. Daaci ká de tse an zherwe, á dem sleɗe na ɓaaka dárádza-aara ɗekiɗeki na. ");
INSERT INTO mfi_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Arge una ŋanna wá, máki ɗaarakteɗáhá á dem jeba á tate ŋanna wá, de njinja ka á ba am sleɗe na ni ɓaaka dárádza-aara ɗekiɗeki na. Má samsa edda una a ɗaakɗaa na, á se baká: Labára ura-aaruwa! Sawa náwa njinja am una. A se vakte sleɗe na an dárádza jipu na. Daaci una ŋanna á gev dárádza palle ge ekka á katafke á emnde na kwá zá ɗafa kerɗe. ");
INSERT INTO mfi_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Aɗaba ma ware una a kantaa ba ŋane ire-aara na, tá de ganaage edda-aara. Amá edda una ni a gaa ire-aara wá, tá de kananteka.» ");
INSERT INTO mfi_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Am iga á una ŋanna maa, a ba ŋane á elvan ge edda una a ɗaaná á dem mba-aara ŋanna: «Máki ká ɗáhá emnde ge se zá ɗafa am mbá á ŋa, bi ge se zá masane am mbá á ŋa wá, ɗaaterka emnde na ni watse tá dzegwándzegwa ɗaakteɗáhá ka keni, tá de pelaksepele na. Ma slakate-aha á ŋa, ma egdzar mama-aha a ŋa, ma vara-aha a ŋa, ma emnde a riya á ŋa keni, máki ba ta emnde a berba, ɗaheka jeba á emnde ŋanna ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Máki ka magaa muŋri á ŋa wá, ɗaaterɗáhá ka ba talága-aha, emnde a dere, antara lipa-aha umele, ira wulfe-aha. ");
INSERT INTO mfi_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ɗaaterɗáhá ka ba jeba á emnde ŋanna, watse ká higetehiga, aɗaba itare tá dzegwánka pelaksepele duksa á ŋa. Daaci á de pelaksá ba Dadaamiya, vacite na má tsatertetse emnde a mága shagerire am faya.» ");
INSERT INTO mfi_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ura umele am dágave á emnde a zá ɗafa antara Yaisu na, ba a cenaa una ŋanna wá, a ba ŋane á elvan ge Yaisu: «Edda una watse á de zá una am zlanna á Dadaamiya na, watse higa ƴaikke ge ŋane ka?» ");
INSERT INTO mfi_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yaisu a vante naraje na, a ba ŋane á elvan ge ŋane: «Aŋkwa ura male a gyaa muŋri ƴaikke am mba-aara, a ɗetaa emnde keni ba kwakya ge de zá muŋri ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Hyephye laukte a zá ɗafa á muŋri ŋanna maa, a naba ɓelaa sleɓela-aara, a ba ŋane: De bateranba ge emnde-aaruwa na a sarsawa, duksa baɗemme an tsatse mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Amá baɗemme á emnde na a ɗaateraa ŋane ŋanna, ma ware keni a fantau ba ge slápala, geni á taa daaka. A ba zuŋŋwire-aatare: Ya shekuve fe áŋwaslire, yá de ezzhárá. Aɗaba una ŋanna yá taa daaka. De banánba: Tasle-aara, a ƴiyaarƴe. ");
INSERT INTO mfi_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","A ba ura umele: Iya ya shakuve esla-aha kelaawa, yá de salatersála. Aɗaba una ŋanna yá taa daaka na. De banánba: Ba tásle-aara a ƴiyaarƴe. ");
INSERT INTO mfi_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","A ba ura umele zlaɓe ádaliye á elvan ge sleɓela na: Iya wá, yá an larusa am bere, zlaɓe ba uŋŋule a gaa gyaale-aaruwa ŋanna, yá taa daaka ya. De banánba ba estuwa. ");
INSERT INTO mfi_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Daaci sleɓela na ba eptsa-aara á dá, a danaa nara-aatare ge zánwe-aara. Amá jaaja ervauŋɗe edda á há jipu. A ba ŋane á elvan ge sleɓela-aara: Ezzlálá ba watsewatse á dem huɗe a ekse, de ejja ɗába áte we á layye-aha, ma ka bera talaga-aha-ara, ma ka bera emnde a dere antara lipa-aha-ara, ira wulfe-aha, ɗaaterɗáhá baɗemme ásehuna. ");
INSERT INTO mfi_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Cekwaaŋguɗi wá, eptsaptsa sleɓela na áseza zánwe-aara, a ba ŋane á elvan ge ŋane: Baɗemme magannaamaga názena ka ndaaná ka, amá zlaɓe ba nja sleɗe-aha na ɓaaka emnde am huɗe-aara. Shagera, a ba zánwe. ");
INSERT INTO mfi_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","A ba zánwe á elvan ge ŋane: Ezzlálá á dete mákwáta-aha, de eɗɗába we á baráma, we á baráma, antara uŋŋule-aha, ma ka shaa ware keni naba sánsa á ba an ndzeɗa, geni a naatená huɗe á há-aaruwa baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Amá emnde na ya ɗaaterɗáhá, kwalarevkwale na wá, ba palle-aatare keni á fuka ɗafa-aaruwa mazla-aara. Elva-aaruwa una ge iya.» ");
INSERT INTO mfi_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kwakya nalga á emnde, ta daa ɗaba Yaisu. Amá a eptsavte ge Yaisu ádezetare, a ba ŋane á elvan ge itare: ");
INSERT INTO mfi_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Iya wá, ɓaaka ura á dzegwándzegwa ɗabiɗaba, máki edda-aara ƴánka dzámá eddeŋara, emmeŋara, mukse-aara, egdzara-aara, egdzar mama-aha-ŋara zála antara ŋwásha, ira ire-aara ba ge ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ma ware una eksanteka dzaŋgala-aara ge ɗabiɗaba, edda-aara á taa gevka pukura-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Aŋkwa duksa palle, cenawáncena ba shagera. Ɓaaka ura á fantau ge nderá dzagwavaye, máki zlauka am lasáfi-aara ba shagera. ");
INSERT INTO mfi_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Edda-aara, má magaaka una ŋanna wá, á naba fantaufe, amá á taa zlanaaka baɗemme. Daaci baɗemme á emnde na tá zhárá slera-aara ŋanna, tá dzáká ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Tá de bánba emnde geni, máki ba ɓaaka nalmane-aara mu, a fantau ge uwe ba ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«Ba duksa palle ge slekse á larde keni. Máki tá wava an ukfeŋara wá, sey a puwa sawari am ire-aara emtsaaɗe ba shagera, máki á dzegwándzegwa de wava an emnde-aara debu kelaawa na, antara slekse na á siyanuye an emnde debu kul buwa. ");
INSERT INTO mfi_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Máki a nanna watse á dzegwánka wá, ba zlaɓe kelaade-aara ƴiƴiye an ŋane wá, á puwa emnde-aara ádezeŋara, ge ndavanundave názena á kataná ŋane, lauktu tá emtsanámtsa wava ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ba duksa palle ge kure keni. Ɓaaka ura á dzegwándzegwa gev pukura-aaruwa, máki ƴánka baɗemme á duksa na am dalbe-aara.» ");
INSERT INTO mfi_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Elleŋa wá, duksa ŋgelama. Amá máki elleŋa ŋanna ɓaaka ɗaŋɗaŋire-aara mazla-aara mu, tá maganá uwe, ganakini á gevge ɗaŋɗaŋe zlaɓe ádaliye? Ɓaaka pute ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Máki estuwa, ɓaaka nampire-aara mazla-aara. Ge nyanve nargwa zlaɓe adaliye an ŋane keni, á gevka; ge danaa á ba dem fe keni, ɓaaka nampire-aara, sey tá puwanve á ba degashe. Edda una máki aŋkwa hyema-aara wá, a cenevaacena!» ");
INSERT INTO mfi_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kwakya emnde a mága haypa antara *emnde a jáhá hadáma se jarammeje áza Yaisu, tá aŋkwa cená elva ázeŋara. ");
INSERT INTO mfi_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","A naba jaterhe ge ervauŋɗe *Farisa-aha antara malum-aha á *tawraita, a ba itare am dagave-aatare: «Labára ŋane ge zhele na á lyiya emnde a haypa, á zá ɗafa antara itare?» ");
INSERT INTO mfi_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yaisu a vaterte naraje na, a ba ŋane á elvan ge itare: ");
INSERT INTO mfi_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Ware am kure, má a keɗaa palle am kyawe-aha-aara deremke, á ƴánka kyawe-aha kul maselmane ju maselmane na, á de tatayá palle na keɗaakeɗa na emtsaaɗe? ");
INSERT INTO mfi_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Máki shánsha, á eksante á ba an higa áte ye-aara, á sá an ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Máki saasa maa, á ɗáhá slakate-aha-aara antara emnde a riya-aara, tá se higa átirpalle, aɗaba a bateraa labáre á higa, a shaa kyawe-aara na ndza keɗaakeɗa na.» ");
INSERT INTO mfi_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Daaci a ba ŋane á elvan ge itare: «Una keni ba duksa palle. Yá ndaakur ba jirire, am samaya wá, kwakya ba higa na arge slehaypa palle na a eptsanve iga ge haypa-aha-aara, arge emnde kul maselmane ju maselmane na, ta bantsa itare, ta emnde jirire, ɓaaka wedere-aatare an mága tuba na.» ");
INSERT INTO mfi_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Zlaɓe ádaliye, mukse máki an gursa-aara kelaawa, amá a eblyantaave palle á ba am bere-aara, á mbanteka kárá á ba am sarte ŋanna, á ettátaya ba shagera, á hyaɗese bere ŋanna baɗemme sey má shánsha? ");
INSERT INTO mfi_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Máki shánsha wá, slakate-aha-aara antara emnde a riya-aara sey tá cenáncena baɗemme, tá se higa átirpalle, aɗaba a bateraa labare á higa, a shaa gursa-aara na ndza keɗaakeɗa na. ");
INSERT INTO mfi_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Una keni ba duksa palle. Yá ndaakur ba jirire: málika-aha á Dadaamiya tá higa jipu, máki slehaypa palle a eptsanve iga ge haypa-aha-aara.» ");
INSERT INTO mfi_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yaisu a fateraare naraje umele zlaɓe ádaliye, a ba ŋane á elvan ge itare: «Aŋkwa ura an egdzara buwa zála. ");
INSERT INTO mfi_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","A ba kudere á elvan ge eddetare wá: Názena ni ma andze ŋá záná am warata am iga á ŋa na wá, iya yá kátá náza-aaruwa ba kina eddaaye. Ane, á ba eddetare. A naba ɗaaterte, a tegateraa nalmáne na. ");
INSERT INTO mfi_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","«Am iga á una ŋanna maa, kudere na a gaa ba hare cekwaaŋguɗi wá, a naba jimaa kazlaŋa-aara, umele a valuhe a puwem shuŋgu-aara am lyiba, puwwe a naba zlálá á dem duniya-aara. Daaduwa áhuwa maa, a de keɗaa nalmáne-aara na a shanaa áza eddeŋara na baɗemme, am dákárire ba dey. ");
INSERT INTO mfi_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ba ŋane keni pacanvepáce nalmáne-aara baɗemme cátte zlauzle duksa am erva-aara wá, samsa waya ƴaikke á sem larde ŋanna keni. Palle á názu á eksáná áte erva ɓaaka mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Daaci á tataya slera mazla-aara. A ba palle á emnde a ekse ŋanna á elvan ge ŋane: Aŋkwa slera á piya nabezhe-aha am mba-aaruwa, má ká emmága. Wayanwáyá, a ba ŋane; a naba duhe. ");
INSERT INTO mfi_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aŋkwa ice-aara am shayawe á duksa-aha na tá vante ganakini á dateran ge nabezhe-aha, amá varanteka baráma á zuze-aara. ");
INSERT INTO mfi_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«Daaci a fantau ge shá eŋkale áte nja-aara ŋanna, a ba ŋane: Emnde na tá maga slera am mba á edderwa ni tá ƴáná ba itare ɗafa ni, iya ni á jiija waya áhuna! ");
INSERT INTO mfi_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ambane yá tsetse, yá eptsa á dá. Yá de banánba ge edderwa ganakini ya ganu ge ŋaneka palle haypa na, amá ya gu haypa an Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Am nja-aaruwa kina na wá, ba geni tá ɗakiyá an egdza á ŋa keni zlayeka mazla-aara, hyainefka. Naba givege ka, a ganevge ba seke emnde a slera á ŋa umele am huɗe á há á ŋa. ");
INSERT INTO mfi_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mazla-aara a naba tse, a saa á se mba á eddeŋara na. «Am sarte na saasa herzhanteherzhe há á eddeŋárá, daga ba zlaɓe ƴiƴiye, a naba diyeddiye eddeŋárá, a naba zanvaarehe, hattse a naba tsetehe, a de yainuye, tákwálle a de ŋanaahe an erva buwa, á higa arge ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Daaci: Eddaaye, a ba egdza-aara á elvan ge ŋane, haypa-aaruwa wá, ya gaku ge ekka ka palle, haypa ƴaikke ya guwa an Dadaamiya. Hyanefka mazla-aara ganakini yá gev egdza á ŋa ádaliye. ");
INSERT INTO mfi_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Amá ba hyema keni fanuka eddeŋara na ge názena aŋkwa tsakaná ŋane. A ba ŋane á elvan ge emnde na tá maga slera am mba-aara: Dawmbare watsewatse á dem bere, de sawansa záne zariya, antara kimake, ira jaɗe palle, sawmbare an ŋane, tsekwawanemtsekwa am kazlaŋa. ");
INSERT INTO mfi_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Dawmbare, de sawánsa dalau na mi gelanaa á ba an niya na, icawantice watsewatse, una muŋri ƴaikke, higaumihiga. ");
INSERT INTO mfi_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Aɗaba egdza-aaruwa na náwa ŋane na wá, ndza ba seke a emtsa an emtsa, ŋane kina wá, ba seke a tsete am faya. Ndza keɗaakeɗa ba ɗekiɗeki, amá kwaya ŋane jesaarje. Daaci ta fantau ge mága muŋri-aara, higa ƴaikke am huɗe á há-aara baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Amá am sarte ŋanna wá, makaji á edda á há ŋanna ɓaaka am mba, a dem kaamba. Aŋkwa á sá maa, á cená ba gusa am mba-aatare, njaanja gaŋga tá shekela emnde. ");
INSERT INTO mfi_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","A naba ɗaase palle á emnde na tá maga slera am mba-aatare, a ndavanu elva, a ba ŋane: A jaara uwe am mbá á miya? ");
INSERT INTO mfi_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","A ba walaaɗi-aatare ŋanna á elvan ge ŋane: Saasa egdza emmeŋa, eddeŋa a icante dalau na mi gelanaa á ba an niya na, aɗaba a shaa egdza-aara ba lapilayye. ");
INSERT INTO mfi_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mazla-aara a naba icaa ervauŋɗe makaji á edda á há ŋanna, a kwaleve ge dem mbá ŋanna ba ɗekiɗeki. Daaci a segashe ba eddeŋara an ire-aara, a se slapalana á dem mba. ");
INSERT INTO mfi_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Amá a ba ŋane á elvan ge eddeŋara: Edda, iya náwa yawe wányarwányara yá magaká ba slera, ba ser palle keni ƴannaaka elva á ŋa ni, aley ba ser palle keni vakiteka ba egdza a nawe keni, ganakini ŋá zuze antara slekate-aha-aaruwa ni. ");
INSERT INTO mfi_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Gevge saasa egdza á ŋa, ŋane wá, a de keɗakaa nalmáne á ŋa baɗemme áte záware-aha ba dey ni, aley ka se icanante dalau na mi gelanaa á ba an niya na ádaliye! ");
INSERT INTO mfi_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ba estuwa egdza-aaruwa, a ba eddetare; Ekka wá, ba jire ba ádeme keni dakeska ɗekiɗeki. Ay degiya, baɗemme á názena am huɗe á há na ba náza á ŋa. ");
INSERT INTO mfi_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Duksa palle wá, shagera ba mi maganaamaga muŋri, mi higa. Aɗaba egdza emmeŋa ŋanna wá, ndza ba seke a emtsa an emtsa, kina ŋane gevge ba seke a tsete am faya. Ndza ba seke a keɗaa an keɗa am kaamba, náwa shanánsha zlaɓe ádaliye.» ");
INSERT INTO mfi_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","A ba Yaisu á elvan ge pukura-aha-aara: «Aŋkwa sleberba umele, an sleslera-aara a ƴanaa duksa kwakya am erva. Ta naba sem ge emnde umele áseza sleberba ŋanna, a ba itare tá elvan ge ŋane: Degiya sleslera á ŋa na aŋkwa á badzaká nalmane kwakya. ");
INSERT INTO mfi_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Daaci a naba ɗante sleslera-aara ŋanna ádezeŋara. A ba nane á elvan ge ŋane: Ázara kena ká maganá ka ta se ndindaha na? Máki estuwa wá, viteva lasafi á slera á ŋa, ká njeka am slera-aaruwa mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«Daaci a ba sleslera ŋanna am ervauŋɗe-aara: Kina mu, watse yá maga tara uwe antara uwe kena? Aɗaba ɓaaka shaige-aara, á ŋgyiŋgye zanwe-aaruwa am slera. De herɗa keni yá dzegwánka mazla-aara, ŋála keni zherwe. ");
INSERT INTO mfi_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A ba ŋane: Kina wá, diyandiya názena yá maganá ya, ma ta sise am slera keni, watse tá lyiyilyiya emnde am mba-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«Daaci a naba fantau ge ɗáhá emnde na zanwe-aara á ɗabater gema an palpale. A ndavanu ge edda una a sawa ŋane zuŋŋwe: Wanyara gema á zanwe-aaruwa áte ka? a ba ŋane á elvan ge ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","A ŋwanante, a ba ŋane: Waye gauŋgauŋ mawya deremke buwa. A ba sleslera na á elvan ge ŋane: Njinja, puwetepuwa áhuna gauŋgauŋ deremke, daaci ba seke pelaksepele gauŋgauŋ deremke. ");
INSERT INTO mfi_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","A ɗante ura umele zlaɓe, a ba ŋane á elvan ge ŋane: Wanyara gema á zanwe-aaruwa áte ka? A ŋwanante, a ba ŋane: Nalkame buhwa deremke ilyeɓe. A ba sleslera á elvan ge ŋane keni: Sawa, náwa puwetepuwa áhuna buhwa deremke ufaɗe, daaci ba seke pelaksepele buhwa deremke ufaɗe. ");
INSERT INTO mfi_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","«Daaci zanwe a fantau ge gálá sleslera-aara ŋanna. Diyaadiya tsa ganakini magaaka jirire am slera-aara, amá a galanaa aɗaba diyaadiya fanu hyema ge ire-aara á de katafke. Aɗaba emnde a duniya na wá, itare diyardiya fanu hyema ge ire-aatare jaruje ba ge emnde na tá am parakkire keni.» ");
INSERT INTO mfi_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Daaci Yaisu a farhe zlaɓe ádaliye, a ba ŋane á elvan ge itare: «Názu yá bakurná ya wá, magaumága urire an emnde an nalmane á duniya na. Daaci am sarte na má watse zlauzle am erva á kure wá, tá de lyiyakurlyiya am tate na ni á zleka ɗekiɗeki na. ");
INSERT INTO mfi_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ma ware una a magaa jirire am duksa na cekwa, am duksa ƴaikke keni estuwa. Amá edda una a magaaka jirire am duksa cekwa wá, am duksa ƴaikke keni á maga ba ɓaakire á jirire ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Aɗaba una ŋanna, máki magakurka slera an nalmane á duniya na an uŋŋule-aara mu, á de vakurta ware nalmane á jirire? ");
INSERT INTO mfi_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Zlaɓe ádaliye, máki magakurka an uŋŋule-aara áte nalmane á emnde mu, á de vakurta ware náza á ire á kure? ");
INSERT INTO mfi_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Ɓaaka ura á dzegwándzegwa magaterá slera ge zanwe-aha buwa átirpalle. Ba bi á de wayete ba palle, á maganá slera shagera, á de ƴá palle, á maŋka slera-aara. Kwá dzegwánka magaterá átirpalle tara slera á Dadaamiya antara tataya nalmane.» ");
INSERT INTO mfi_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","*Farisa-aha, emnde a waya nalmane na, ba ta cenaa elva ŋanna wá, ta naba puwar dzáká ge Yaisu ágire tá epsawepsawa. ");
INSERT INTO mfi_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","A ba Yaisu á elvan ge itare: «Kure, kwá ganve ire á kure ba seke kwa emnde a jirire, amá Dadaamiya diyaadiya ervauŋɗe á kure. Aɗaba duksa na emnde tá zharán ge ƴaikkire wá, hyapka ba názara keni áza Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Ndza á faterá ba *tawraita á Muusa, antara wakita á nabi-aha emnde áte baráma á Dadaamiya. Una ŋanna shekwaashekwa sem zamáne á Yuhanna slemaga baptisma. Ta fantau á ba am sarte ŋanna emnde ge cená labare á higa, elva a njá á ba am *kwárá á Dadaamiya. Daaci ma ware keni á wava an ndzeɗa-aara baɗemme, ganakini á demda ŋane keni am kwara ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Amá wá, á eblyantaaveka ba egdza duksa keni ge názu am *tawraita. Butu ba keɗá á tara samaya an haha arge keɗa a egdza duksa ba cekwaaŋguɗi am tawraita. ");
INSERT INTO mfi_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Ma ware una a ɓelaa mukse-aara, a gaa umele, a magaa ba gwardzire. Edda una a gaa mukse na a segashe am mba á zhele, ŋane keni a magaa ba gwardzire.» ");
INSERT INTO mfi_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Ndza aŋkwa sleberba umele, á tsekwa ba zane na ni lefeɗɗe jipu, kwakya gane-aara na. Ma vaatara keni am mba-aara tá gyeka duksa laake, ŋane á zá ba emtakire am mba-aara. ");
INSERT INTO mfi_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Aŋkwa zlaɓe talage umele zhera-aara Laajarus, baɗemme á vuwa-aara ba wige maa, a de zlavehe áte we á wakyiya á sleberba na. ");
INSERT INTO mfi_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ŋane wá, ice-aara ndza am kwácá á ɗafa na á valya á sawa am erva á sleberba na, ganakini á wazantewaza. Amá itare ta naba fanarhe ge zlaɗa, kere-aha ta se emtakanaa wige-aha-aara na. ");
INSERT INTO mfi_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Am iga á una ŋanna maa, a naba emtsehe ge Laajarus, eksaranteksa malika-aha shifa-aara, ta dáná ádeza Ibrahima am samaya. Sleberba ŋanna ŋane keni a naba emtsehe, heɗareheɗa. ");
INSERT INTO mfi_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Amá sleberba ŋanna aŋkwa á maga palasa an tsáká ire am faya. A kante ice am zlaɗa-aara ŋanna wá, á zhárá ba Ibrahima antara Laajarus ázeŋara, ta ƴiƴiye jipu an ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","A fu hula á ba an ndzeɗa, a ba ŋane: Eddaaye Ibrahima! Tasle á ŋa zivarze! Eɓɓela Laajarus, a de femfa ba we á gulanda-aara keni am yawe, a se ekhyinaakhya nara, yá am zlaɗa degiya am kárá na! ");
INSERT INTO mfi_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","A ŋwanante ge Ibrahima, a ba ŋane: Egdza-aaruwa, una wá, ɓaaka kwa mazla-aara. Ká dzamteka ka á ba áte emtakire na ka zanaa ka am duniya, Laajarus a shu zlaɗa kwakya na! Kina wá, aŋkwa á puwansepuwe ŋane mazla-aara, ka keni ba ká shá zlaɗa á ŋa. ");
INSERT INTO mfi_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Baira ɗeme, aŋkwa evege slaɗɗe am dágave á miya, ma emnde á ŋere una tá kátá dezekure keni, tá dzegwánka; ma emnde á kure tá kátá sezeŋere keni tá dzegwánka. ");
INSERT INTO mfi_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","A ba zhel ŋanna ndza sleberba na á elvan ge Ibrahima: Máki estuwa wá, ba ɓaaka elva-aara. Amá yá dalide zlaɓe ádaliye ge ŋalakŋála eddaaye, tasle á ŋa, eɓɓela seke Laajarus á dem mba á edderwa am duniya, ");
INSERT INTO mfi_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","tá aŋkwa egdzar mama-aha-aaruwa ilyeɓe zála, a de fateremfa am vuwa, ganakini a saremka itare keni á sem tate á zlaɗa ŋanna yá am huɗe-aara na. ");
INSERT INTO mfi_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","A ba Ibrahima á elvan ge ŋane: Egdzar mama-aha-ŋa wá, aŋkwa *tawraita á Muusa antara wakita á nabi-aha umele tá ndaater waazu ge emnde am huɗe-aara wá, itare keni a cenarcena. ");
INSERT INTO mfi_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Amá a ba zhel ŋanna: Una á hyepka eddaaye Ibrahima. Amá máki a tsete ura am faya ni a de beraterbera wá, tá eptsanteptsa nja-aatare mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","A ba Ibrahima á elvan ge ŋane: Máki ba tá ceneka elva á tara Muusa antara nabi-aha umele wá, ma a tsetaa ba ura am faya lauktu a de ndaaterndáhá keni, tá de maga ba una ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","A ba Yaisu á elvan ge pukura-aha-aara wá: «Ganakini a magarka emnde haypa ɗekiɗeki wá, ɓaaka dabari-aara ɗekiɗeki. Amá zlaɗa ge edda una ni á vatertá ŋane ektápaare ge emnde á dem haypa ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ambane ba ta ŋguɗanem nákwá á há hiya am mbiye ge edda-aara, ta puwaterme am haye, arge una ni á vante ektápaare ba ge palle á egdzara keni. ");
INSERT INTO mfi_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Faufa hyema áte ire á kure! Máki a gaku haypa egdza emmeŋa wá, naba duwa, de ndaandáhá ba shagera. Máki yá dalika á bina wá, naba ƴanarƴa. ");
INSERT INTO mfi_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ma a gaku haypa ser vuye á ba áte váha palle keni, máki ba kelaa haypa ni á se slapala wá, ka keni ba ká ƴanarƴa.» ");
INSERT INTO mfi_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","A ba emnde a ɓela tá elvan ge Yaakadada: «Shagera ba ká faŋeraarfe ge fetarfire á ŋere.» ");
INSERT INTO mfi_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","A ŋwaterante ge Yaakadada, a ba ŋane á elvan ge itare: «Máki hyephye fetarfire á kure ba seke ice á pilli palle wá, ma kwa banán ba ge mama á nafa na kwaye ŋane na: Ɓeteseɓete ire á ŋa, de tsaatse am haye keni, sey á zlálá nafa ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","A ba ŋane á elvan ge itare: «Zharauzhárá á ba áte slera á walaaɗire: Ware am dágave á kure an walaaɗi-aara? Máki walaaɗi á ŋa a de maga slera am fe, bi a de piya, má saasa, ká banánba emtu, sawa zuze duksa? ");
INSERT INTO mfi_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ábi ká banánka. Ekka ká baná: Mbaɗanaambaɗa kazlaŋa á ŋa watsewatse, gyigya masane, siyansa. Máki zanuze ya, lauktu ká de zá náza á ŋa. ");
INSERT INTO mfi_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ábi ɓaaka ura á slafaná we ge walaaɗi aɗaba fesarfire na a maganaa ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ba duksa palle ge kure keni. Máki magakurnaamaga názena a fakuraara Dadaamiya wá, diyaweddiye am ire á kure ganakini kwa magaa ba slera á kure, kwa walaaɗi-aha.» ");
INSERT INTO mfi_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Zlaɓe Yaisu a ba átire á mága shula ge dem Urusaliima na. Kina wá, daada átakwe á tara Galili antara *Samariya. ");
INSERT INTO mfi_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ate nakwe á kwara-aha ŋanna maa, aŋkwa ekse, ba Yaisu keni á kátá dem ekse ŋanna, ta se ica ba wafke-aara emnde a derve ta kelaawa, amá ta tsaahe ba ƴiƴiye an we á baráma. ");
INSERT INTO mfi_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Baɗemmire-aatare ta fu hula á ba an ndzeɗa ge ɗaha Yaisu. A ba itare: «Ambarkaaŋa Yaisu, tasla á ŋa, zaŋervarze.» ");
INSERT INTO mfi_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Daaci a tsaahe ge Yaisu, a zharateraahe, a ba ŋane á elvan ge itare: «Zlauzlálá, de marawateránmárá ire á kure ge *liman-aha.» Ba ta eptsa iga, tá aŋkwa zlálá wá, ta naba mbehe baɗemmire-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aŋkwa palle am dagave-aatare, ba a ɓelanu ice ge vuwa-aara, nanna ganakini mbaambe wá, a naba eptsa áseza Yaisu ámbera á gálá Dadaamiya á ba an ka kwara. ");
INSERT INTO mfi_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","A se kezlanaa ugje ge Yaisu, wafke-aara ba teppe áte haha, aŋkwa á slafaná we an ervauŋɗe-aara palle. Zhele ŋanna wá, ura *Samariya. ");
INSERT INTO mfi_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Daaci a ba Yaisu á elvan ge emnde: «Ábi baɗemmire-aatare ta kelaawa na, mbarembe. Labára kena a sawa ba ŋane palle? ");
INSERT INTO mfi_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Emnde maselmane na, ba palle-aatare keni dzamarka se slafanaa we ge Dadaamiya, sey be wayve na palle degey?» ");
INSERT INTO mfi_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Daaci: «Tsettse,» a ba Yaisu á elvan ge ŋane, «Ezzlálá á da. Mbakaambe fetarfire á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","*Farisa-aha ta ndavanu elva ge Yaisu, a ba itare tá elvan ge ŋane: «Watse á sawa vaatara Dadaamiya an sleksire-aara, ge gamive á ba am kwara-aara palle na?» A ŋwaterante ge Yaisu, a ba ŋane: «Njá am *kwara á Dadaamiya wá, tá nanka an ice. ");
INSERT INTO mfi_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tá bakanka keni: Náwa tate na wá, á kwaraná ba Dadaamiya, bi: Kwaye tate na keni, á kwaraná ba Dadaamiya. Diyaweddiye ganakini kwárá á Dadaamiya ŋanna aŋkwa á ba am dagave á kure.» ");
INSERT INTO mfi_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Daaci a ba ŋane á elvan ge pukura-aha-aara: «Aŋkwa á sawa sarte na ni watse kwá kumetekuma hare-aha na ya *Ura á emnde baɗemme yá aŋkwa antara kure na, amá ba palle keni watse kwá shánka mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Watse tá bakuránba emnde ganakini degiya samsa kwaye ŋane aŋkwa áhuwa, bi watse tá bakurá: Náwa ŋane aŋkwa áhuna. Amá kure cenauka, daumbarka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Aɗaba má watse yá sawa ya, iya Ura á emnde baɗemme wá, watse tá niina emnde ba parakke. Ba seke mága á kárá á rade á fantau am dalbe palle ge ekte á samaya, dem dalbe umele keni tá nanna emnde na wá, sawa-aaruwa keni watse ba estuwa. ");
INSERT INTO mfi_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Amá wá, sey yá shushu zlaɗa ba kwakya emtsaaɗe, tá de ƴiyaaƴa emnde a zamáne na. ");
INSERT INTO mfi_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ba názena ni ndza ta maganaa emnde am zamane á *Nuhu na wá, am sarte na watse yá eptseya iya Ura á emnde baɗemme keni, watse emnde tá maga ba una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Am zamane á Nuhu wá, slera á emnde ndza ba shuŋŋula náza za, náza sha, ga larusa, vaterte gyaale-aha-aatare ge zála. A demaa estuwa Nuhu am paare á yawe, a tsekwaa ge yawe á keɗa duniya, a keɗateraahe baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Am zamane á *Ludu keni ndza a magava ba estuwa. Emnde tá shuŋŋula ba náza zá, antara náza sha, tá shakwa kazlaŋa, emnde umele tá evvala, tá herɗa duksa á dem bere, tá ndera bere-aha baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Amá vacite na ni sassa Ludu am *Saudauma wá, Dadaamiya a naba hyateraarhe kárá an wesha an *baraudau á sawa am samaya, a keɗateraahe baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Má watse herzhe yá eptsa ya iya Ura á emnde baɗemme keni, watse emnde tá maga ba una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Vacite ŋanna wá, edda una ma a beranaa áte ire á bere keni, a tsuŋka á dem huɗe-aara ge hálá kazlaŋa-aara. Ba duksa palle ge edda una a beranaa am fe, ŋane keni a eptseka á sem mba. ");
INSERT INTO mfi_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Diyaweddiye á ba áte mukse á *Ludu. ");
INSERT INTO mfi_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Edda una a tataya ŋezla shifa-aara, watse á keɗanaakeɗa. Edda una tatayaaka ŋezla shifa-aara, ŋane á shansha shifa-aara. ");
INSERT INTO mfi_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yá ndaakur ba jirire, am hare ŋanna wá, watse emnde buwa tá zlava áte egdera palle, palle watse yá eksanteksa, yá de ƴá palle. ");
INSERT INTO mfi_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ŋwásha buwa tá há hiya átirpalle, yá de eksa palle, yá ƴá palle. (( ");
INSERT INTO mfi_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Watse yá bera emnde buwa am fe, yá de eksa palle, yá ƴa palle.»)) ");
INSERT INTO mfi_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Daaci ta naba ndavanuhe ge pukura-aha-aara, a ba itare tá elvan ge ŋane: «Watse á magava áme una ŋanna Yaakadada?» A ŋwaterante, a ba ŋane: «A ba am tate na ni aŋkwa lipa, zaatate-aha tá jaháva á ba ádehuwa.» ");
INSERT INTO mfi_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Am iga a una ŋanna maa, Yaisu a bateraa naraje na, ge batera a magarmaga maduwa ba kelaazare, a ƴaranka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","A ba ŋane á elvan ge itare: «Aŋkwa narkali am ekse umele, ɓaaka ura á kuvaná ŋane ɗekiɗeki, ba Dadaamiya keni ŋane á kuveka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ay aŋkwa zlaɓe mukse wegyege á ba am ekse ŋanna, ba kelaazare áseza narkali na, á se bana: Náwa dagalaŋerevdagale an ura, maranánmárá jirire-aaruwa ge sledagala-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Am zuŋŋwire wá, narkali na eksarka emtsaaɗe elva á mukse na ɗekiɗeki. Amá de shekwaashekwa á ƴanka mukse na wá, a ba ŋane am ervauŋɗe-aara: Ɓaaka ura yá kuvaná ya ɗekiɗeki, ba Dadaamiya keni yá kuveka ya ice-aara, ");
INSERT INTO mfi_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","amá mukse na wá, ambane yá maranánmárá jirire-aara ge sledágala-aara ŋanna, aɗaba á se weshita ire kwakya.» ");
INSERT INTO mfi_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","A eksetaa elva-aara zlaɓe ádaliye Yaakadada, a ba ŋane á elvan ge itare: «Mándzawe narkali na, kwá cenanceneka názu a ndaana ŋane? ");
INSERT INTO mfi_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Daaci Dadaamiya wá, emnde na ni a dzertersaa ŋane, vaƴi vacika tá ázeŋárá na wá, ŋane á shekwaaka ɗekiɗeki ge marse jirire-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yá ndaakur ba jirire: Á marse jirire-aatare ba watsewatse. Amá má watse yá sawa ya, iya *Ura á emnde baɗemme, watse ba yá se bera emnde na tá an fetarfire am duniya na?» ");
INSERT INTO mfi_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Daaci Yaisu a bateraa naraje na zlaɓe ádaliye, á ndaaná áte emnde na tá zhara ire-aatare ta emnde a jirire ba itare, tá epsawa emnde umele na. ");
INSERT INTO mfi_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","A ba ŋane á elvan ge itare: «Zála buwa ta de maga maduwa am *mashidi ƴaikke. Palle ura *Farisa, palle na slejaha hadáma. ");
INSERT INTO mfi_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","A tsetehe ge ura Farisa, a tsaahe, a magaa maduwa am ervauŋɗe-aara, a ba ŋane: Yaakadada Dadaamiya-aaruwa, ya slafaká we-aaruwa kwakya, aɗaba ŋa gergere antara emnde umele. Aɗaba itare ta neyle-aha, ta mándzawe-aha, ta emnde a mága gwardzire. Ususe kwakya aɗaba ŋa gergere an slejaha hadáma na náwa ŋane na. ");
INSERT INTO mfi_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Iya, ba kelaa maka yá eksa ndera ser buwa, yá aŋkwa á sakanse luser am názena yá shaná ya baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Slejaha hadáma na keni, a tsaahe ƴiƴiye an ŋane, amá ŋane wá, ba ketaa ire-aara ge zhara samaya keni magaaka ŋane. Daaci a puwanu erva ge ervauŋɗe, a magaa maduwa-aara, a ba ŋane: Yaakadada Dadaamiya-aaruwa, tasle á ŋa zivarze, iya ya slehaypa.» ");
INSERT INTO mfi_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Daaci a ba Yaisu á elvan ge itare: «Yá ndaakur ba jirire: Tá dá wá, a shanaa ba zhel ŋanna mele an Dadaamiya arge ura Farisa na. Aɗaba ma ware una a kantaa ba ŋane ire-aara na, sey tá de gánaaga. Amá edda una ni a gaa ire-aara wá, tá de kananteka.» ");
INSERT INTO mfi_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Duwa á emnde, ta sanaa egdzara ge Yaisu antara ba egdzara mesheshe keni, geni á puwaterar *erva a barka, amá naráterna pukura-aha emnde a saa egdzara ŋanna wá, ta naba valaterarhe. ");
INSERT INTO mfi_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Amá a ba Yaisu á elvan ge itare: «Piyawaterteka, ƴawaterƴa a sarsawa egdzara ásezerwa, aɗaba *kwárá á Dadaamiya náza á emnde na má garevge ba seke itare. ");
INSERT INTO mfi_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yá ndaakur ba jirire: Ma ware edda-aara keni máki lyevaaka dem kwárá á Dadaamiya ba seke náza á egdzere wá, á taa demka ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","A tsetehe ge palle á male-aha á Yahudiya-aha, a de ndavanu ge Yaisu, a ba ŋane á elvan ge ŋane: «Malum, diyandiya ganakini ka ura mággwe. Naba ndindaha, yá maga tara uwe antara uwe, lauktu yá shá shifa na á zleka na?» ");
INSERT INTO mfi_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","A ŋwanante ge Yaisu, a ba ŋane á elvan ge ŋane: «Labára ká ɗahiyá an ura mággwe? Ɓaaka ura mággwe máki Dadaamiya-ka palle. ");
INSERT INTO mfi_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ábi diyakdiya shairiya-aha á Dadaamiya na a ba ŋane: Maŋka gwardzire, jeka shifa, ileka, maŋka seydire á fida áte ura, ɗematerveɗeme tara eddeŋa an emmeŋa.» ");
INSERT INTO mfi_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","A ŋwanante ge zhel ŋanna, a ba ŋane á elvan ge Yaisu: «Una ŋanna ŋannaaŋa baɗemme daga am egdzarire-aaruwa.» ");
INSERT INTO mfi_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","A ba Yaisu á elvan ge ŋane: «Una wá, a ƴakar ba duksa palle: De valuvale názu am rezege á ŋa baɗemme, tegatertega shuŋgu-aara ge taláge-aha, ekka watse ká shánsha laɗa-aara am samaya. Daaci sawa ɗabiɗaba.» ");
INSERT INTO mfi_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ba a cenaa una ŋanna zhel ŋanna wá, a fantau ge dzama ire an tsaka ire, aɗaba nalmane-aara kwakya jipu. ");
INSERT INTO mfi_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nanna Yaisu ganakini am dzámá ire zhel na, a ba ŋane á elvan ge emnde: «Zlazlaɗa jipu ganakini tá demda emnde a berba á dem *kwárá á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Náwa zlazlaɗa ganakini á dedde názlegwame am ɓiye á lipere, amá zlazlaɗa ba náza á sleberba zlaɓe ádaliye ge dem kwárá á Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","A ba emnde na ta cenanaa an hyema-aatare elva ŋanna: «Máki ba estuwa wá, ɓaaka ura á ŋezleseŋzle ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","A ba Yaisu á elvan ge itare: «Názu á taa gevka ɗekiɗeki áza emnde na wá, áza Dadaamiya ba keski.» ");
INSERT INTO mfi_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Daaci a ba Piyer á elvan ge ŋane: «Amá ŋere wá, ƴaŋeranƴa duksa baɗemme, ganakini ŋá ɗaba ba ka palle.» ");
INSERT INTO mfi_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A ba Yaisu á elvan ge itare baɗemme: «Yá ndaakur ba jirire: Ma ware una a ƴaa há-aara, bi mukse-aara, bi egdzar mama-aha-ŋara, bi tara eddeŋara an emmeŋara, bi a ƴaa egdzara-aara, aɗaba *kwárá á Dadaamiya wá, ");
INSERT INTO mfi_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kina keni á shansha baɗemme á jauje ba ge una ŋanna, á katafke keni á de sha shifa na á zleka na.» ");
INSERT INTO mfi_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Daaci Yaisu a ɗante pukura-aha-aara kelaawa ju buwa, a ba ŋane á elvan ge itare: «Duwa á miya á dem Urusaliima kina na wá, názena ta puwetaa nabi-aha áte iya *Ura á emnde baɗemme na baɗemme á de gevge. ");
INSERT INTO mfi_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Aɗaba tá de eksivaksa, tá de vite ge emnde na ɓaaka nadina-aatare, tá de epsawisa itare, tá de zlazlisezlazle, tá de kyefiyem nyaihe am ice, ");
INSERT INTO mfi_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","tá de ziyuze an ja. Am iga a una ŋanna maa, tá de zliyaazle shifa-aaruwa ba ɗekiɗeki. Amá am hare ge keƴire wá, watse yá tsetse am fáya.» ");
INSERT INTO mfi_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Amá palle a názu ta cenanaa pukura-aha na am elva ŋanna ɓaaka ɗekiɗeki. Ázetare wá, maana á elva ŋanna seska ɗekiɗeki, cenaránka elva na a ndaateraa Yaisu na. ");
INSERT INTO mfi_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yaisu herzhanteherzhe Yairikau maa, aŋkwa ura wulfe umele á njá áte we á baráma, aŋkwa á ŋala. ");
INSERT INTO mfi_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Daaci wulfe na á cena ba tá aŋkwa á degashe emnde. A naba enndáva: «A jaara uwe?» a ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","A ba emnde: «Una aŋkwa á degashe Yaisu ura Nasarátu.» ");
INSERT INTO mfi_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A naba kante kwárá ge ŋane: «Yaisu *Egdza á Dawuda, tasle á ŋa zivarze.» ");
INSERT INTO mfi_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ta naba valarhe ge emnde a katafke ganakini a ɗuɗe, amá ŋane a far ká kwárá á ba a dem zhegela: «*Egdza á Dawuda! Tasle á ŋa zivarze.» ");
INSERT INTO mfi_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Daaci a tsaahe ge Yaisu, a ba ŋane: «Sawansa ásehuna.» Daada wulfe ŋanna á katafke á Yaisu, a ndavanu ge Yaisu, a ba ŋane: ");
INSERT INTO mfi_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Ká kátá yá magaká estara kina?» A ŋwanante ge wulfe na, a ba ŋane: «Yá kátá ba ice malum-aaruwa.» ");
INSERT INTO mfi_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","A ba Yaisu: «A wertewera ice á ŋa, mbakaambe fetarfire á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ba seke ndaha á miya na a naba werte ge ice-aara, a ɗába Yaisu, ámbera á gala Dadaamiya. Baɗemme á emnde na ta naaná an ice-aatare, itare keni ta fantau ge gálá Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Daaci damda Yaisu am huɗe á Yairikau maa, a degáshe am huɗe á ekse praatte. ");
INSERT INTO mfi_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Am ekse ŋanna maa, aŋkwa ura zhera-aara Jakayus, ŋane male á shuŋgu á hadáma, sleberba jipu. ");
INSERT INTO mfi_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A ekkata jipu ganakini á puwetepuwa ice-aara áte Yaisu, ware ŋane Yaisu ŋanna. Amá dzegwanká aɗaba ŋane paihyhye vayvaya am emnde. ");
INSERT INTO mfi_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Daaci ba zhagade-aara á de katafke, a de ɗaleme am mama á zlemnda, geni watse á nanna má á degashe. Aɗaba aŋkwa á ɗaba ba tate ŋanna Yaisu. ");
INSERT INTO mfi_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ba damda Yaisu am tate ŋanna maa, a naba kante ice á dem nafa na, a ba ŋane á elvan ge Jakayus: «Tsekwesetsekwe watsewatse Jakayus. Vatena na wá, sey yá de háre á ba am mba á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","A tsekwese ge Jakayus ba watsewatse, a se lyevaa Yaisu á ba an higa, ge daná á dem mba-aara. ");
INSERT INTO mfi_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Baɗemme á emnde na tá aŋkwa á zharaterzhárá na, aŋkwa á waterwa am ervauŋɗe. Ta bantsa itare: «Ezzhárá ka, á de hare am mba á slehaypa.» ");
INSERT INTO mfi_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Amá a tsaahe ge Jakayus, a ba ŋane á elvan ge Yaakadada: «Yaakadada-aaruwa, sey yá tegatertega kyalma á nalmane-aaruwa ge talage-aha. Máki aŋkwa edda una ndza ya lyevaa duksa-aara ba dey wá, yá de eptsannaapetsa huɗe ufaɗe.» ");
INSERT INTO mfi_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","A ba Yaisu á elvan ge ŋane: «Vatena wá, huɗe á há á ŋa shánsha shifa, ka keni ka ba eggyeŋara ge Ibrahima. ");
INSERT INTO mfi_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Aɗaba sawa-aaruwa ge iya ya *Ura á emnde baɗemme wá, ya se tataya ba edda una an keɗa na, geni yá lyelye edda-aara.» ");
INSERT INTO mfi_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ge emnde na ta zluwa á cena elva ŋanna, Yaisu a bateraa naraje na zlaɓe ádaliye. Aɗaba herzharanteherzhe Urusaliima ba ŋga, njarantenja emnde ganakini herzhe segashe-aatare mazla-aara am erva á emnde, Dadaamiya á de faterá slekse ƴaikke tá njá am kwara-aara. ");
INSERT INTO mfi_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Daaci a ba ŋane am naraje-aara: «Aŋkwa egdza á ura male a naba tsete, a zlala á dem larde ƴiƴiye, a de tatayanvaa sleksire ge ire-aara, á de eptsa ádaliye. ");
INSERT INTO mfi_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Lauktu á zlala maa, a ɗante emnde a slera-aara kelaawa, a vaterte gursa kelaawa: Tsakalautsákala an ŋane, a ba ŋane á elvan ge itare, dem sarte na má sanaasa ya. ");
INSERT INTO mfi_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Amá emnde a jeba-aara wayarka an ŋane. Zlazlala ŋane wá, ta naba belante emnde, a ba itare: Wayaŋerka ŋere, á se kwaráŋerá zhel na. ");
INSERT INTO mfi_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Amá de shánsha sleksire ŋanna, mazla-aara a naba saahe á sem larde-aara. Am sarte na saasa maa, a ɓelaa we, ta ɗanante emnde a slera-aara na ndza a vaterte gursa kelaawa ge mbeɗarva an ŋane na, geni á zhara riba á ma ware-aatare keni. ");
INSERT INTO mfi_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","A semhe ge slezuŋŋwire-aatare, a ba ŋane: Náwa názena ya shanaa an nalmane na ndza ka vitaa ka zanwe, ya shante riba huɗe kelaawa. ");
INSERT INTO mfi_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","A ba slekse ƴaikke a elvan ge ŋane: Shagera jipu, ka sleslera á jirire. Aɗaba dzayyire á huɗe á ŋa am duksa cekwa, yá gakvege male arge berni kelaawa. ");
INSERT INTO mfi_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","A semhe ge buwire-aatare, a ba ŋane: Náwa názena ya shanaa an nalmane na ndza ka vitaa ka zanwe, ya shante riba huɗe ilyeɓe. ");
INSERT INTO mfi_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","A ba slekse ƴaikke á elvan ge ŋane keni: Ekka, yá gakvege male arge berni ilyeɓe. ");
INSERT INTO mfi_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«A de semhe ge umele wá, a ba ŋane: Náwa názena ndza ka vitaa ka zanwe, ndza ya faɗeme am bagwadza, ya sheɓanve. ");
INSERT INTO mfi_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Jiija lyawa, aɗaba diyandiya am ire-aaruwa ganakini ka mandzawe; ma faŋka ba duksa á ŋa keni, ká shánsha; jaŋka ba wulfe á duksa á ŋa keni, ká hala ba duksa á juwa á ba áte ka. ");
INSERT INTO mfi_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","A ba slekse á elvan ge ŋane: Ba elva á ŋa na keni hyaahya, ŋakaaŋa shairiya. Mbate ka ŋguɗi, ka sleslereka. Diyakdiya ganakini ya mándzawe á ba ka? Ma faneka ba duksa-aaruwa keni yá shánsha; janeka ba wulfe á duksa-aaruwa keni yá hala ba duksa á juwa á ba áte ya, á ba ka? ");
INSERT INTO mfi_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Máki ba estuwa wá, labára de puwaŋka nalmane-aaruwa am baŋ, ma yá se lyiyaná an riba? ");
INSERT INTO mfi_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«Daaci a ba ŋane á elvan ge emnde na tá á tsaatse ázeŋara na: Lyauvaalya shuŋgu na ázeŋara na, fawanarfe ge edda una a shante riba huɗe kelaawa na. ");
INSERT INTO mfi_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","A ba itare tá elvan ge ŋane: Yaakadada, degi ázeŋara keni aŋkwa ɗeme gursa ŋanna? ");
INSERT INTO mfi_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","A ŋwaterante a ba ŋane á elvan ge itare: Yá ndaakur ba jirire: Tá fanaare ba ge edda una aŋkwa ázeŋara na. Amá edda una shanteka ɗekiɗeki wá, ba una cekwa am erva-aara na keni, tá de lyanvulye. ");
INSERT INTO mfi_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kelaade-aha-aaruwa na wayarka yá gev slekse arge itare na keni maa, sawatersa ba watsewatse, ɗatsawaterteɗatsa á ba á katafke-aaruwa.» ");
INSERT INTO mfi_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Zlauzle á tsaka elva ŋanna Yaisu maa, ba zlala-aara zuŋŋwe ákatafke á emnde ge dem Urusaliima. ");
INSERT INTO mfi_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Herzhanteherzhe Baytifaji antara Baytaniya, daraada áte vuwa á wa na tá ɗaháná an Wa Anyaranyara na wá, a ɓelaa emnde buwa am pukura-aha-aara, a ba ŋane á elvan ge itare: ");
INSERT INTO mfi_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Dawmbare á dem ekse na kwaye ŋane á katafke na wá, watse kwá de bera egdza á ezzeŋwa an ŋguɗa, ba ser palle keni zlaɓe njateka ura átekwa wá, naba pelawaapele sawánsa. ");
INSERT INTO mfi_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Máki ura a bakuraa: Kwá pelaná á deme? bawanánba ge edda-aara: Á kataná Yaakadada.» ");
INSERT INTO mfi_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Daaci ba zlala-aatare ge emnde a ɓela na, baɗemme ta de berán ba seke una a baternaa Yaisu na. ");
INSERT INTO mfi_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Am sarte na tá aŋkwa pela ezzeŋwa na wá, a ba dada-aha-aara: «Kwá pelaná á deme?» a ba itare, tá elvan ge itare. ");
INSERT INTO mfi_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ta ŋwaterante, a ba itare: «Á kataná Yaakadada.» ");
INSERT INTO mfi_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mazla-aara ta naba saa ezzeŋwa na áseza Yaisu, ta se ndakaa zane-aha-aatare áte iga á ezzeŋwa ŋanna, lauktu ta njetaa Yaisu átekwa. ");
INSERT INTO mfi_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Fantaufa Yaisu ge zlala maa, emnde umele ta pelanse zane-aha-aatare áte baráma, a zlálá ŋane átekwa. ");
INSERT INTO mfi_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Am sarte na herzharanteherzhe Urusaliima maa, tá áte baráma a tsekwa á sawa áte Wa Anyaranyara na wá, higartehiga pukura-aha jipu, ta fantau ge gálá Dadaamiya á ba an ká kwárá, tá galaná aɗaba najipu-aha na ta naana itare baɗemme na. ");
INSERT INTO mfi_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ta bantsa itare: «A ganga Dadaamiya barka ge slekse ƴaikke na kwaya ŋane á sawa am zhera á Yaakadada na. Ma ba hairire wá, aŋkwa am samaya; ƴaikkire wá, á zlayán ba ge Dadaamiya palle.» ");
INSERT INTO mfi_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tá aŋkwa *Farisa-aha umele am dikele á emnde ŋanna maa, a ba itare tá elvan ge Yaisu: «Malum! Bateránba ge pukura-aha á ŋa a ɗaruɗe.» ");
INSERT INTO mfi_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","A ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Ma ta ɗuwa ba itare keni, nakwá-aha na tá fantaufa á ba an ka kwara, una yá ndaakur ba jirire.» ");
INSERT INTO mfi_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yaisu herzhanteherzhe berni ba ŋga maa, ba a puwete ice-aara áte berni wá, a fantau ge kyuwa berni na, ");
INSERT INTO mfi_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","a ba ŋane: «Ekka keni ma ká diyeddiye seke ba názena ni ma andze á vakte hairire vacite ŋanna! Amá am kinire na wá, an sheɓe atuge ice á ŋa, ká taa diseka mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Amá diyeddiye ganakini aŋkwa á sawa hare-aha umele, watse tá jaktaaveje kelaade-aha á ŋa á de jauje ge ndzeɗa á ŋa, ká de gevge an ɓeca jipu. ");
INSERT INTO mfi_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Watse tá keɗakurkeɗa ba ɗekiɗeki antara emnde á ŋa. Ka berni, amá watse ba nákwá palle keni tá de nánka áte ukfeŋara nákwá, baɗemme watse tá ŋgerɗakŋgerɗa, aɗaba diyakseka sarte na ni a sawa Dadaamiya a se melakumele.» ");
INSERT INTO mfi_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Duwa á Yaisu á dem *mashidi ƴaikke, a de fantau ba ŋgya emnde a tsakala á segashe, ");
INSERT INTO mfi_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","a ba ŋane á elvan ge itare: «Aŋkwa an puwa am wakita á Dadaamiya, a ba Dadaamiya: Bere-aaruwa wá, ba bere á mága maduwa, amá kure kwa ganve hwalakwa á nabera-aha.» ");
INSERT INTO mfi_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Daaci Yaisu a fantau ge kwaraterse elva á Dadaamiya ge emnde am huɗe-aara ba kelaazare. Male-aha á *liman-aha antara malum-aha á *tawraita, ira male-aha á ekse ta tátaya ja shifa á Yaisu, ");
INSERT INTO mfi_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","amá ɓaaka dabari-aatare ge ekseksa-aara, aɗaba baɗemme á emnde tá cena ba názena aŋkwa á kwaratersá ŋane na an eŋkale-aatare baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Vacite umele, Yaisu aŋkwa á kwaraterse elva á Dadaamiya ge emnde am *mashidi ƴaikke, aŋkwa á ɓalaterá antara labare á higa maa, ta naba duhe ge male-aha á *liman-aha antara malum-aha á *tawraita, ira male-aha á ekse ádezeŋara. ");
INSERT INTO mfi_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","A ba male-aha ŋanna tá elvan ge ŋane: «Baŋeránba tate na ni ka shaa hákuma á mága duksa-aha na átekwa. Emtu a vaktaa ware baráma-aara?» ");
INSERT INTO mfi_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","A ŋwaterante ge Yaisu, a ba ŋane a elvan ge itare: «Iya keni, yá ndavakurundave duksa palle, vawiteva jawapa.» ");
INSERT INTO mfi_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Daaci a ba ŋane á elvan ge itare: «A ɓelanaa ware Yuhanna ge magatera baptisma ge emnde? Dadaamiya emtu, emndimagwaha he?» ");
INSERT INTO mfi_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ta fantau ge ndaha elva ŋanna am dagave-aatare emtsaaɗe, a ba itare: «Má mi banaa a ɓelanaa Dadaamiya, watse á bamiyá labára fakurtaareka an ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Máki mi baa ta belanaa ba emndimagwaha, baɗemme á emnde tá de ƴámika an nákwá, tá de ceɓamiceba, aɗaba emnde baɗemme fartarfe ganakini Yuhanna nabi á Dadaamiya.» ");
INSERT INTO mfi_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Daaci ta ŋwanante ge Yaisu, a ba itare: «Ma a ɓelanaa ware keni diyaŋerka ŋere.» ");
INSERT INTO mfi_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","A ba Yaisu: «Iya keni yá ndaakurka náza-aaruwa, ma ya shaa hákuma á mága duksa-aaruwa áza ware keni.» ");
INSERT INTO mfi_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Am iga a una ŋanna maa, Yaisu a fantau ge ndaater elva an naraje na ge zlamaakelaawa, a ba ŋane: «Aŋkwa ura a dzeɓaa nafa á inabauhi am fe-aara, a ƴateraa fe ŋanna am erva ge emnde a slera, ŋane a naba zlala á da shula, á de shekwaashekwa áhuwa jipu. ");
INSERT INTO mfi_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Samsa sarte á tsáká inabauhi maa, a naba ɓela sleslera-aara á deza emnde na a ƴateraa fe am erva na, geni a lyanvaalya dza á inabauhi-aara. Amá emnde na a ƴateraa fe am erva ŋanna ta hyanhe an ja ge sleɓela-aara ŋanna, ta ɓelanaahe an erva-aara dey. ");
INSERT INTO mfi_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Edda á fe na a naba ɓela sleslera-aara umele, ŋane keni ta de zlazlese, ta hyanhe an ja, ta ɓelanaahe an erva-aara ilyeɓe. ");
INSERT INTO mfi_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","A naba ɓela umele zlaɓe ádaliye ge keƴire. Ŋane ɗeme ta gyegese, vuwa-aara baɗemme ba wige, ta teɗese á degashe. ");
INSERT INTO mfi_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Daaci, a ba edda á fe ŋanna: Yá maganá estara kena? A ba ŋane: Kina wá, yá ba egdza-aaruwa. Egdza-aaruwa wayanwáya jipu na wá, ámbane tá de fa zherwe áte ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Amá ba ta puwete ice-aatare áte ŋane emnde a mága slera am fe na wá, a ba itare am dágave-aatare: Yawwaa, kwaye samsa edda una watse á záná ŋane waráta á fe á miya na. Eksaumivaksa, jaumija shifa-aara, daaci fe ŋanna á de gev ba náza á miya. ");
INSERT INTO mfi_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Daaci ta naba eksevaahe, ta danse ádegashe, ta de jehe shifa-aara.» A ndavateruhe ge Yaisu, a ba ŋane á elvan ge itare: «Má samsa edda á fe na mu, watse á magaterá uwe ge emnde a mága slera am fe na? ");
INSERT INTO mfi_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ay degiya, má watse samsa edda á fe ŋanna wá, á se keɗanaakeɗa shifa a emnde a mága slera am fe ŋanna baɗemme, á ƴaterá fe am erva ba ge emnde umele.» A ba emnde baɗemme: «A janaaja Dadaamiya una ŋanna!» ");
INSERT INTO mfi_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","A zharateraahe emtsaaɗe ge Yaisu, a ba ŋane á elvan ge itare: «Aŋkwa an puwa am wakita á Dadaamiya, a ba ŋane: Ba nákwá ŋanna ta eblyanvaa emnde a nyáŋa bere na una, a eksantehe ge Dadaamiya, a ganve nákwá na á ŋáná ŋane ndzeɗa á bere ŋanna baɗemme. Una ŋanna mu, á kata ba uwe kena, a ba kure? ");
INSERT INTO mfi_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","«Edda una má a mbeɗaa áte nákwá ŋanna, sey á kezlevkezle edda-aara am tate umele. Sakwa edda una má a eblyaara ŋanna ge ŋane, sey á hánaahe edda-aara ba ŋgerɗekɗeke.» ");
INSERT INTO mfi_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Malum-aha á *tawraita antara male-aha á *Farisa-aha ta naba diyeddiye ganakini Yaisu a ndaha naraje ŋanna á ba áte itare. Daaci ta kátá eksa Yaisu á ba am sarte ŋanna, amá ta kuva ba zlamaakelaawa. ");
INSERT INTO mfi_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mazla-aara maa, ta fantau ge tsagwaɗa Yaisu á ba am sarte ŋanna, ta ɓelanvaa emnde-aatare; emnde ŋanna ta ganve ire-aatare ba seke ta emnde a jirire, daaci ta danaa ndáva ge Yaisu, ágire tá tsagwaɗa elva a mandzawe am mbuwe-aara, lauktu ma tá eksaná átekwa, ma tá dateránda ge emnde a ŋgumna. ");
INSERT INTO mfi_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Daaci ta ndavanuhe, a ba itare tá elvan ge ŋane: «Malum, diyaŋerdiya ganakini ekka wá, baɗemme á názena ká ndaaná ka, antara názena ká kwaratersá ka ge emnde baɗemme ba jirire. Má ká kwaraterse duksa ge emnde, diyaŋerdiya ganakini ká ndaha ba tsekkire-aara ge elva, an namaari á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ndaaŋernda ba jirire, am *tawraita á miya mu, aŋkwa emtu baráma á puwaná hadáma ge male á larde á Rauma, ɓaaka he?» ");
INSERT INTO mfi_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Amá kerteŋ diyeddiye Yaisu ƴaimƴaimire na tá aŋkwa á maganá itare baɗemme, a ba ŋane, a elvan ge itare: ");
INSERT INTO mfi_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Marawiyánmárá emtsaaɗe suley palle yá nanaana.» Ta maranánhe. A ba ŋane á elvan ge itare: «Nderáva á ware una áte shuŋgu na? Ira zhera na mu zhera á ware?» Ta ŋwanante, a ba itare: «Náza á male á larde á Rauma.» ");
INSERT INTO mfi_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","A ba Yaisu á elvan ge itare: «Máki estuwa wá, puwawanpuwa ge male á larde názu zlaya-aara, ge Dadaamiya keni názu zlaya-aara.» ");
INSERT INTO mfi_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ta ettságwaɗa á katafke á emnde baɗemme, amá ɓaaka sharanka názu tá eksáná átekwa, ta ƴaa á maga ba najipu á jawapa na a vatertaa ŋane, daaci ta ɗu ba we-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ta naba semhe ge *Saduki-aha umele áseza Yaisu. Ba itare emnde na ta bantsa itare, ɓaaka tse á emnde am faya ɗekiɗeki na. Ta se ndavanu elva ge Yaisu, a ba itare: ");
INSERT INTO mfi_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Malum, aŋkwa a puwamitaa Muusa, a ba ŋane: Máki keɗaakeɗa zhele ƴanka egdzere wá, a melesemele egdza emmeŋara mukse-aara, geni á yana egdzara ge egdza emmeŋara na keɗaakeɗa na. ");
INSERT INTO mfi_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Iyau, ndza tá aŋkwa dawalaa vuye ta egdzar mama, duwa á makaji-aatare, a gaa gyaale, amá a naba keɗehe, a ƴaa mukse na, ɓaaka egdzere. ");
INSERT INTO mfi_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A melese ge sleɗaba-aara, ŋane keni a emtsehe, a ƴaa mukse na ɓaaka egdzere. Keƴire-aatare keni ba estuwa. ");
INSERT INTO mfi_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Itare vuye na baɗemme ta gaa ba mukse ŋanna, amá baɗemme zlaruzle, ƴaránka egdzere ba palle keni. ");
INSERT INTO mfi_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Am iga-aatare baɗemme, a emtsehe ge mukse ŋanna keni. ");
INSERT INTO mfi_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Vaci tse á emnde am faya mu, watse átuge ware palle mukse na? Aɗaba itare ta vuye na ndza mukse-aatare ba ŋane palle!» ");
INSERT INTO mfi_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","A ŋwaterante ge Yaisu, a ba ŋane á elvan ge itare: «Am duniya na wá, zála antara ŋwásha tá aŋkwa á gaava am dagave-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Amá am duniya na watse á sawa á katafke na wá, ma zála, ma ŋwásha keni, emnde na ni hyairephye ge tsete am faya, se njá am huɗe-aara wá, watse ɓaaka elva á nika mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Aɗaba watse ɓaaka emtsa mazla-aara, tá de gev ba seke malika-aha á Dadaamiya. Itare ta ba egdzara á Dadaamiya, ádaba ta tsete am faya. ");
INSERT INTO mfi_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Muusa wá, ndaasende ba parakke ganakini watse tá tsetsa emnde a faya an shifa. Aŋkwa an puwa am wakita á Dadaamiya, am tate na á ndaaná áte dake na, a ba ŋane áte eggye-aha á kure werre: Yaakadada, Dadaamiya á Ibrahima, Dadaamiya á Isiyaaku, Dadaamiya á Yakuba. ");
INSERT INTO mfi_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Daaci máki estuwa wá, tá á ba an shifa-aatare emndu werre. Aɗaba Dadaamiya wá, ŋane Dadaamiya á emnde na tá an shifa, Dadaamiya á emnde na ni tá an emtseka. Baɗemme á emnde a shifa tá an shifa ba ge ŋane.» ");
INSERT INTO mfi_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","A ba emnde umele am malum-aha á *tawraita: «Elva á ŋa na ka ndaase ba tsekke malum.» ");
INSERT INTO mfi_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Gazlaregazla mazla-aara, ɓaaka ura a ndavanu elva am iga a una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yaisu a ndavateru elva ge itare, a ba ŋane: «Estara ŋane ta bantsa emnde ni *Almasiihu wulfe á *Dawuda na? ");
INSERT INTO mfi_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawuda an ire-aara keni a ɗahanaa an Yaakadada, aŋkwa am Jabura, a ba ŋane: A ba Yaakadada á elvan ge Yaakadada-aaruwa: Njinja am naɗafa-aaruwa, ");
INSERT INTO mfi_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","dem sarte na má ganatervege kelaade-aha á ŋa tate á puwa sera á ŋa. ");
INSERT INTO mfi_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ha! Dawuda an ire-aara a ɗahanaa an Yaakadada *Almasiihu. Áy á sawa estara kena ni á gev wulfe-aara na?» ");
INSERT INTO mfi_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","A ba Yaisu á elvan ge pukura-aha-aara á dem hyema á emnde baɗemme: ");
INSERT INTO mfi_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Faufa hyema am ire á kure áza malum-aha á *tawraita. Aɗaba itare ta emnde a wáyá marava am záne saɗaɗɗe, tá kata emnde ta gater use an ga ire am dagave á zlamaha. Am mashidi keni maa, tá kátá ba sleɗe na átire ge náza a emnde baɗemme na. Ma am muŋri keni itare sey tá de kátá ba sleɗe na ni an dárádza jipu na. ");
INSERT INTO mfi_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Emnde a zá ŋwásha wegyege áte há keni ba itare. Daaci tá slaɗanve maduwa-aatare ákatafke á emnde wá, geni ta emnde a jirire ágire. Itare zlaɗa-aatare á de jauje ge náza á emnde baɗemme vaci shairiya.» ");
INSERT INTO mfi_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","A kante ice-aara Yaisu, á zhárá emnde a berba tá puwa sadake á nashirire á dem nakwati á jáhá sadake am *mashidi ƴaikke. ");
INSERT INTO mfi_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","A naa wegyege a mukse umele ŋane ɓaaka duksa-aara, a puwum kwaɓa buwa ŋane keni. ");
INSERT INTO mfi_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Daaci a ba Yaisu: «Yá ndaakur ba jirire: Wegyege a mukse na kwaya ŋane, taláge ba jipu na wá, ŋane a puwum náza-aara jateruje ge emnde baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Aɗaba uwe, itare wá, aŋkwa nalmane-aatare, ta saa ba cekwa-aara ge mága sadake an ŋane. Amá mukse na wá, ŋane talage. Ɓaaka tsa umele, amá a naba se puwumhe názu am erva-aara baɗemme.» ");
INSERT INTO mfi_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Emnde umele tá aŋkwa á ndaha elva á *mashidi ƴaikke am dagave-aatare, geni mashidi ŋanna wá, an ndera. Nákwá-aha-aara, antara kazlaŋa na ta sanaa sadake-aara ge Dadaamiya, ta caɗaa mashidi ŋanna an ŋane na, zariya jipu. Amá a ba Yaisu á elvan ge itare: ");
INSERT INTO mfi_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Aŋkwa á sawa sarte na ni watse ba nákwá palle keni á jauka áte ukfeŋara nákwá, watse baɗemme á mbeɗa á dem áhá kwá ezzhara na.» ");
INSERT INTO mfi_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ta naba ndavanuhe, a ba itare: «Watse á magava am sarte-ara una ŋanna? Watse ŋá dise áte uwe ganakini herzhe á magava duksa ŋanna?» ");
INSERT INTO mfi_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","A ba Yaisu: «Faufa kure ba hyema a se keɗarakuraaka emnde umele. Aɗaba watse kwakya emnde na tá de sawa an zhera-aaruwa, ma ware-aatare keni á se ba: Ba iya una ya *Almasiihu, hyephye laukte á miya mazla-aara. Amá kure wá, ɗabawaterka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Má kwa cenaa labare á wáva-aha, á dagala ervauŋɗe á male-aha gergere wá, kure gazlauka ɗekiɗeki, aɗaba watse á de magava ba una-aha ŋanna zuŋŋwe, amá zlaɓe zle á duniya áte una ŋanna-ka emtsaaɗe.» ");
INSERT INTO mfi_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","A farhe zlaɓe ádaliye, a ba ŋane: «Watse kwá cená ba darda larde umele ge larde umele an wáva. Emnde á slekse umele dararde ge kwárá á slekse umele an wáva. ");
INSERT INTO mfi_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Á de gejava haha an ndzeɗa jipu am tate-aha gergere; watse á magava masiba-aha, antara waya am tate-aha gergere. Watse tá nanna emnde najipu-aha antara nalaama-aha saɗaɗɗe á sáwa am samaya. ");
INSERT INTO mfi_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Amá lauktu ni á magava duksa-aha ŋanna wá, kure watse tá sluwakursluwa, watse tá magakuránmaga palasa; watse tá de tsákurá am shairiya am mashidi-aha gergere, tá de dákurá á dem daŋgay. Watse tá de tsakurá á katafke á slekse-aha gergere, antara male-aha á larde gergere aɗaba zhera-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Daaci watse á vakurta ba una ŋanna baráma ge kure, mága seydire an zhera-aaruwa á katafke-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Duksa palle viyawanaaka wá: Dzamauka ire á názena watse kwá ndaaná kure ge ŋezla ire á kure an ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Aɗaba watse yá vakurtá ba iya an ire-aaruwa eŋkale antara elva na kwá de ndaaná kure, tá de dzegwánka kelaade-aha á kure vakurte jawapa, tá de dzegwánka mbeɗakurmbeɗe ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Náwa ba dada-aha a kure antara mama-aha a kure, egdzar mama-aha a kure, vara-aha a kure, antara slakate-aha á kure keni, tá de vakurte ge emnde, tá de ceɓa shifa á emnde umele am kure. ");
INSERT INTO mfi_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Emnde baɗemme watse tá dá ba kelaadire ádete kure aɗaba zhera-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Amá wá, ba úgje ire á kure palle á keɗeka. ");
INSERT INTO mfi_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kure wá, tsawaatse ba shagera. Máki tsakuraatse shagera wá, kwá ŋezleseŋzle.» ");
INSERT INTO mfi_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Máki kwa nanna jarantaaveje kelaade-aha ge Urusaliima an wáva wá, diyaweddiye geni herzha keɗa-aara. ");
INSERT INTO mfi_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Daaci watse tá zhagada emnde na tá am Yahudiya am sarte ŋanna á dem huɗe á wa. Emnde na tá am huɗe á Urusaliima keni, watse tá kyá á dete mákwátá. Emnde a mákwátá wá, a sarka á sem Urusaliima ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aɗaba hare-aha ŋanna baɗemme ba hare-aha á zlaɗa, geni a gevge názena am wakita á Dadaamiya baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kay! Watse á tsaame kwa zlaɗa á ŋwasha na watse tá á huɗe, antara ŋwasha na tá an egdzara áte erva am sarte ŋanna! Aɗaba watse kwakya jipu zlaɗa am hare-aha ŋanna. Watse á marateránmárá Dadaamiya ge emnde a larde ŋanna, geni tá aŋkwa am ervauŋɗe-aarire. ");
INSERT INTO mfi_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Watse tá ceɓa shifa-aatare an masalam; emnde umele-aatare watse tá sluwatersluwa, tá dáterá an shifa á dem larde-aha umele; watse tá lyevaalya emnde na ɓaaka nadina-aatare Urusaliima, tá de ganvege ba seke berbere, dem sarte na má zlauzle náza-aatare ge itare keni.» ");
INSERT INTO mfi_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Watse tá nanna emnde nalaama áte vaciya, áte tere, áte terlyakwa-aha keni baɗemme. Ate haha keni watse ba ire keni tá de kanteka emnde am larde-aha gergere ge lyawa. Aɗaba watse á vadza haye-aha á ba an ndzeɗa, watse kwakya hula-aara. ");
INSERT INTO mfi_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Watse kwakya emnde na á de ceɓatera ba lyawa, aɗaba tá de dzámá názena watse á setarge emnde am duniya na kwakya. Aɗaba baɗemme á ndzeɗa á názena áte samaya á de gejavtegeje ba ŋarŋare sleɗe. ");
INSERT INTO mfi_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Am sarte ŋanna wá, tá de zhárá ba iya *Ura á emnde baɗemme yá aŋkwa á sawa áte kumba, yá sawa an hákuma ƴaikke antara ɗemɗemire. ");
INSERT INTO mfi_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ba máki kwa nanna aŋkwa á magava duksa-aha ŋanna wá, pauka hare mazla-aara, tsakwautsákwa hyema á dem samaya, aɗaba herzhe kwá ŋezla mazla-aara.» ");
INSERT INTO mfi_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Am iga a una ŋanna maa, Yaisu a bateraa naraje maa, a ba ŋane á elvan ge itare: «Diyaweddiye á ba áte mama á nabugda antara nafa-aha umele. ");
INSERT INTO mfi_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Máki kwa nanna puwaapuwa hyema áte nafa, ƴaaƴa umele áŋwaslire wá, diyakurdiya ganakini herzhavteherzhe madare mazla-aara. ");
INSERT INTO mfi_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Una ŋanna keni ba estuwa. Ba máki kwa nanna aŋkwa á magava duksa-aha ŋanna wá, diyaweddiye ganakini herzhavteherzhe dem zlanna á Dadaamiya. ");
INSERT INTO mfi_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Yá ndaakur ba jirire, tá de zlauka emnde a zamane na ba estuwa, sey má naránna gevge duksa-aha ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tara samaya an haha wá, tá naba keɗa, tá zlauzle. Amá elva-aaruwa wá, á keɗeka ɗekiɗeki, sey má gevge.» ");
INSERT INTO mfi_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Faufa hyema am ire á kure! Gawevka emnde a dakarire antara emnde a mbazla. Dzamauka ire an kazlaŋa á duniya. Máki estuwa, á se berakurbera háre-aha ŋanna ba estuwa, kwa ɓaaka am niya. ");
INSERT INTO mfi_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Aɗaba watse á setarge duniya baɗemme ba seke narre, ɓaaka ura á geƴa ágashe ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Aɗaba una ŋanna, pauka háre, magaumága maduwa ma am laukte-ara keni, lauktu kwá de shá ndzeɗa ge ŋezla átuge duksa-aha ŋanna baɗemme watse á setarge emnde na, watse á wakurka zherwe ge tse ákatafke-aaruwa ya *Ura á emnde baɗemme keni.» ");
INSERT INTO mfi_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ba kelaa vaha, Yaisu á kwaraterse elva á Dadaamiya ge emnde am *mashidi ƴaikke. Amá an vaƴiya wá, á de hare áte ire á wa na tá ɗaháná an Wa Anyaranyara na. ");
INSERT INTO mfi_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ba eŋlya-waabere wá, kerteŋ tsekwaasetsekwe, baɗemme á emnde tá de cena elva ázeŋara am *mashidi ƴaikke. ");
INSERT INTO mfi_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Herzhapteherzhe vayvaya muŋri á depaiŋ na ɓaaka shahi á makala am huɗe-aara, muŋri na tá ɗahaná an *Paska na. ");
INSERT INTO mfi_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Am sarte ŋanna maa, de jaremmeje male-aha á *liman-aha antara malum-aha á *tawraita, ta tátaya pute a keɗa shifa á Yaisu ba ɗekiɗeki. Ta magaa estuwa, aɗaba á wateraa lyawa á ba átuge emnde a ekse. ");
INSERT INTO mfi_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Daaci de demda Shaitaine am Yahuda, an Iskariyaut keni tá ɗaha ba ŋane, ŋane ŋanna palle á pukura-aha kelaawa ju buwa. ");
INSERT INTO mfi_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","A duhe ge Yahuda ŋanna ádeza male-aha á *liman-aha antara male-aha á emnde á ufa *mashidi ƴaikke, ta de magaa sawari kerɗe, geni á de faterem estara Yaisu am erva á ba an keski. ");
INSERT INTO mfi_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Daaci higa ge male-aha na, a ba itare una wá, «Ŋá vakte shuŋgu.» ");
INSERT INTO mfi_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","A eksarhe ge Yahuda. Am iga a una ŋanna maa, a fantau ba ge tátaya dabari á faterem Yaisu na am erva salaakke, a diyarseka emnde ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Gyaregya muŋri á depaiŋ na tá puweka shahi á makala am huɗe-aara na, vaci ica egdza kyawe á *Paska wá, ");
INSERT INTO mfi_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yaisu a naba ɓela tara Piyer tá an Yuhanna, a ba ŋane á elvan ge itare: «Dawmbare, de tsatsaumiyaatsatse ɗafa á Paska, mí de ezza.» ");
INSERT INTO mfi_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ta ndavanu ge pukura-aha na, a ba itare: «Ká kata ŋá de tsatsakaná áme?» ");
INSERT INTO mfi_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A ŋwaterante, a ba ŋane á elvan ge itare: «Máki dakuremda am huɗe á berni wá, kwá de puwa ba ja ire antara zhele á sepa yawe am hwama, naba ɗabauɗaba á dem mba na á demkwa ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Máki dakuremda maa, bawanánba ge edda á há ŋanna: A ba malum wá: Áma bere na yá de zá ɗafa á Paska am huɗe-aara antara pukura-aha-aaruwa? ");
INSERT INTO mfi_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Daaci á de marakurá bere ƴaikke átire ge bere, an tsatsa kazlaŋa am huɗe-aara. Kwá tsatsamiya ɗafa á muŋri am huɗe-aara.» ");
INSERT INTO mfi_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mazla-aara ba zlálá ge pukura-aha na, tá de bera duksa baɗemme ba seke una a baternaa Yaisu na. Daaci ta tsatsaa ɗafa á Paska am bere ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Hyephye laukte-aara maa, aŋkwa á njá arge masane na antara pukura-aha-aara, ");
INSERT INTO mfi_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","a ba ŋane á elvan ge itare: «Una názu ya katanaa ya an ervauŋɗe-aaruwa baɗemme, geni yá zuze ɗafa á *Paska na antara kure, lauktu yá de shá zlaɗa-aaruwa. ");
INSERT INTO mfi_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Aɗaba zá Paska ŋanna wá, yá ndaakur ba jirire, halevuhale ba vatena náza-aaruwa, sey mí de zá ba una am zlanna á Dadaamiya, má sessa maana-aara baɗemme parakke.» ");
INSERT INTO mfi_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Daaci a eksante feka, a slafan we-aara ge Dadaamiya, a ba ŋane á elvan ge itare: «Nawmbare shawushe baɗemme á kure. ");
INSERT INTO mfi_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Aɗaba iya wá, yá ndaakur ba jirire, halevuhale á ba áte una ge iya, geni yá eksanteksa feka yá fetefa áte we-aaruwa. A juwaa ba á sarte na ni emnde tá de njá am *kwara á Dadaamiya átekwa na.» ");
INSERT INTO mfi_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Am iga a una ŋanna maa, a eksante ɗafa, a slafan we-aara ge Dadaamiya, a kezlanve, a ba ŋane á elvan ge itare: «Una na wá, vuwa-aaruwa, ((yá ƴanƴa shifa-aaruwa aɗaba kure. Magaumága una ma vaatara keni, geni kwá dzamidzámá an ŋane.» ");
INSERT INTO mfi_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Am iga a náza za keni a magán ba estuwa, a eksante feka, a ba ŋane á elvan ge itare: «Una uzhe-aaruwa a puvaa aɗaba kure, Dadaamiya á ŋguɗaterá namána ge emnde an ŋane.)) ");
INSERT INTO mfi_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«Amá náwa edda una ni á veliyá ŋane mí zá ɗafa ba kerɗe. ");
INSERT INTO mfi_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Iya *Ura á emnde baɗemme wá, sey ba yá emtsa ɓaaka pekya-aara, aɗaba a tsanaa ba estuwa Dadaamiya. Amá palase ge edda una ni á veliyá ŋane.» ");
INSERT INTO mfi_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Daaci pukura-aha ta fantau ge ndáva am dagave-aatare, geni á maganá ware una ŋanna. ");
INSERT INTO mfi_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Njaanja gajawe am dagave á pukura-aha, tá kátá dise edda una ni tá zhárá ŋane ba seke male-aatare baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","A ba Yaisu á elvan ge itare: «Slekse-aha á larde, tá aŋkwa á márá sleksire-aatare áte larde-aha, baɗemme á emnde a hákuma tá kátá emnde tá baterá shagera slera-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Amá kure wá, estuweka. Edda una gevge male am dagave á kure, a gevge cekwa á kure ba ŋane. Slekatafke á kure, a gevge sleslera á kure ba ŋane. ");
INSERT INTO mfi_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Am dagave á tara edda una á se beraná á ba am tate á njá ɗafa, antara walaaɗi mu, málá ware am itare? Ábi málá ba edda una á se beraná á ba am tate á njá náza za na? Amá iya, nja-aaruwa am dagave á kure wá, ya ba seke walaaɗi. ");
INSERT INTO mfi_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«Kure wá, kwa emnde na ni kwá aŋkwa antara ya ba kelaazare, kwá aŋkwa antara ya am sarte-aha na a badiyaa shaitaine baɗemme. ");
INSERT INTO mfi_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ba seke una ni a vite ƴaikkire ge iya Edderwa na wá, iya keni vanakurteva ge kure. ");
INSERT INTO mfi_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Watse kwá de njá antara ya am ƴaikkire-aaruwa, mí de záná átirpalle duksa, mí de sháná átirpalle. Kwá de njá am kurshi-aha á ƴaikkire ge kya shairiya á Iserayiila-aha jeba kelaawa ju buwa.» ");
INSERT INTO mfi_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","«Simaun! Simaun!» a ba Yaakadada á ɗáhá Simaun, a ba ŋane á elvan ge ŋane: «Kwaye shansha baráma Shaitaine ganakini á maganá an kure ba seke hiya na tá aŋkwa eggyega na. ");
INSERT INTO mfi_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Amá ya magaa maduwa aɗaba ka, geni a kezlevka fetarfire á ŋa baɗemme. Am sarte na má watse eptsakeptsa á sem sera-aaruwa wá, fateremfa ndzeɗa am vuwa ge egdzar mama-aha á ŋa.» ");
INSERT INTO mfi_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","A ba Piyer á elvan ge ŋane: «Yaakadada, iya wá, ma tá damiyá á dem daŋgay keni, tá dami ba buwa; ma tá ceɓa shifa á miya keni, sey mi ba buwa.» ");
INSERT INTO mfi_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","A ba Yaisu á elvan ge ŋane: «Yá ndak ba jirire Piyer: Ba vatena na lauktu á kyuwa tsákálá wá, watse ká bánba ka ser keƴe ganakini diyakikire.» ");
INSERT INTO mfi_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Am iga a una ŋanna maa, a ba Yaisu á elvan ge itare: «Am sarte na ya ɓelakurɓela, ma shuŋgu, ma kashi ba kimake keni dakuránka na mu, aŋkwa názu kwa kumanaa kure emtu?» Ta ŋwanante, a ba itare: «Ɓaaka názu ŋa kumanaa ŋere ɗekiɗeki.» ");
INSERT INTO mfi_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","A ba ŋane á elvan ge itare: «Kina wá, estuweka mazla-aara. Edda una ni aŋkwa shuŋgu-aara, a eksanteksa; edda una aŋkwa kashi-aara keni, a eksanteksa; edda una má ɓaaka masalam-aara, a veluvele naŋgyuwe-aara, a shekwepshekwe. ");
INSERT INTO mfi_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ya bakurnaa aɗaba uwe, shagera ba á gevge názena a ndaanaa wakita á Dadaamiya áte ya na mazla-aara. Aɗaba a ba wakita á Dadaamiya: “Ŋane faremfa am emnde a mága haypa.” Daaci daada áte una ŋanna kina geni á gevge.» ");
INSERT INTO mfi_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","A ba pukura-aha tá elvan ge ŋane: «Yaakadada náwa aŋkwa masalam buwa.» A ŋwaterante, a ba ŋane: «Hyaahya ba una ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ba segashe-aara ge Yaisu wá, a zlala á ba áte Wa Anyaranyara na mbasmba ŋane na, ta ɗabemhe ge pukura-aha-aara keni. ");
INSERT INTO mfi_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Daraada áhuwa maa, a ba ŋane á elvan ge itare: «Ŋalauŋálá Dadaamiya geni a badakuruka shaitaine.» ");
INSERT INTO mfi_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Daaci a gapsehe ba ƴiƴiye an itare, á hyephye velya nákwá palle, a de kezlaa ugje, a magaa maduwa-aara, a ba ŋane: ");
INSERT INTO mfi_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Tasle á ŋa Eddaye-aaruwa jinaaja zlaɗa na a shika, máki wayakiyantewaya. Amá a gevka áte náza-aaruwa, a gevge á ba áte náza á ŋa.» (( ");
INSERT INTO mfi_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Daaci a naba jesarhe ge malika á Dadaamiya á sawa am samaya, a se fanem ndzeɗa am vuwa. ");
INSERT INTO mfi_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ge kwakyire á dzama ire na a shaa ŋane na wá, a magaa maduwa an ndzeɗa-aara baɗemme, haa a ses ge ŋguɗeffire cuuwe áte vuwa-aara, á táɗá á dete haha tak, tak, take ba seke uzhe.)) ");
INSERT INTO mfi_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Zlanaazle maduwa-aara mazla-aara, a naba tsetehe a seza pukura-aha-aara maa, a se berater tá am háre, aɗaba haraare ta taa puka hare, tá am dzámá ire ƴaikke. ");
INSERT INTO mfi_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","A tsaterte, a ba ŋane á elvan ge itare: «Labára kwá pá háre? Pauka háre; magaumága maduwa geni a badakuruka shaitaine.» ");
INSERT INTO mfi_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ba elva ŋanna keni zlaɓe zlanaaka Yaisu wá, saressa emnde ta ba kwakya, Yahuda palle á pukura-aha kelaawa ju buwa á katafke-aatare. Daaci a duhe ge Yahuda ŋanna suuwe ádeza Yaisu, a de ŋanaahe takwalle, á gan use an ervauŋɗe-aara palle ágire. ");
INSERT INTO mfi_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","A ba Yaisu á elvan ge ŋane: «Yahuda, ká se gi use ganakini ká fiyá an una ŋanna emtu á dem erva á emnde, iya *Ura á emnde baɗemme?» ");
INSERT INTO mfi_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Emnde tá antara Yaisu tá zhárá mága ŋanna wá, watse zlazlaɗa jipu. Daaci a ba itare tá elvan ge Yaisu: «Yaakadada, ŋere keni ŋá naba waterwá emtu an masalam-aha á ŋere?» ");
INSERT INTO mfi_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kerteŋ velesevele erva palle-aatare, a naba wa sleslera á male á *liman-aha, a icanaa hyema a naɗafa. ");
INSERT INTO mfi_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Amá a ba Yaisu á elvan ge itare: «Ƴawánƴa, magauka una.» A de semtanaa hyema-aara ŋanna ge zhel na, a mbanaahe. ");
INSERT INTO mfi_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Daaci a ba Yaisu á elvan ge male-aha á *liman-aha, antara male-aha á emnde a ufa *mashidi ƴaikke, ira male-aha á ekse na ta se eksa ŋane na, a ba ŋane á elvan ge itare: «Kwá se eksiya an masalam-aha, antara zade am erva na mu, ya neyle emtu? ");
INSERT INTO mfi_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ábi kelaazare yá á ba ázekure am mashidi ƴaikke, eksakurika ɗekiɗeki? Daaci sarte na wá, sarte á kure, sarte á tabeɗammire ge marse hákuma-aara.» ");
INSERT INTO mfi_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Daaci ta naba eksevaa Yaisu na, ta dan ba suuwe á dem mba á male á male-aha á *liman-aha baɗemme. Piyer wá, a daa ɗaba Yaisu ádehuwa, amá wá, gaterápteka ɗekiɗeki. ");
INSERT INTO mfi_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mbarantembe kárá am huɗe á riya á male á liman-aha na, jarantaaveje emnde ge kárá na maa, Piyer keni a de njeme am dagave-aatare. ");
INSERT INTO mfi_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Daaci á ezzhárá kwátena umele Piyer na, á njá átuge kárá, á ezzhárá, a ba ŋane: «Degi zhel na keni ba ura á Yaisu ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Amá eksarka Piyer, a ba ŋane: «Diyanka ya zhel ŋanna emmaye-aaruwa.» ");
INSERT INTO mfi_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Cekwaaŋguɗi wá, a nanhe zlaɓe ádaliye ge ura umele, a ba ŋane á elvan ge ŋane: «Ka keni ka ba palle á emnde ŋanna.» A ŋwanante ge Piyer, a ba ŋane: «Iya ŋane ka ya, eddaye-aaruwa.» ");
INSERT INTO mfi_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Shekwaashekwa á maga saa palle wá, a ba ura umele zlaɓe adaliye á ba an ndzeɗa: «Ɓaaka shaige-aara ɗekiɗeki, dawale na keni ba ura á zhel ŋanna. Aɗaba ŋane keni ba ura Galili ŋanna.» ");
INSERT INTO mfi_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Amá a ŋwanante ge Piyer, a ba ŋane: «Naba ennda seke elva á ŋa ma ká ndaha uwe keni.» Ba elva-aara keni zlaɓe zlanaaka Piyer, tsáktsákwálikwaa á ba tsakala. ");
INSERT INTO mfi_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","A eptsavte ge Yaakadada, a zharaa Piyer ba ƴamme, daaci Piyer a naba yehete názena a bann