﻿USE sofia;
DROP TABLE IF EXISTS sofia.mfh_vpl;
CREATE TABLE mfh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mfh_vpl WRITE;
INSERT INTO mfh_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Aganay sləm aŋa azla­baba madzi­dziga aŋa Yesu Kristu, bəzi aŋa David, bəzi aŋa Abəraham. ");
INSERT INTO mfh_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abəraham ayyà Isak; Isak ayyà Yakuba; Yakuba ayyà Yahuda la azla­deda aŋha; ");
INSERT INTO mfh_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda ayyà Farəs atà la Zara, (Sləm aŋa iyà aŋatà Tamar); Farəs ayyà Esərom; Esərom ayyà Aram; ");
INSERT INTO mfh_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ayyà Ami­nadab; Ami­nadab ayyà Naheson; Naheson ayyà Salmon; ");
INSERT INTO mfh_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ayyà Bowas, (Iyà aŋha kà Rahab); Bowas ayyà Obed, (Iyà aŋha kà Rut); Obed ayyà Isay; ");
INSERT INTO mfh_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isay ayyà sufəl David. David ayyà Salomon, (Iyà aŋha kà mis aŋa Uriya); ");
INSERT INTO mfh_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomon ayyà Re­ha­beham; Re­ha­beham ayyà Abiya; Abiya ayyà Asa; ");
INSERT INTO mfh_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ayyà Yosafat; Yosafat ayyà Yoram; Yoram ayyà Ozəya; ");
INSERT INTO mfh_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ozəya ayyà Yotam; Yotam ayyà Ahaz; Ahaz ayyà He­səkiya; ");
INSERT INTO mfh_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","He­səkiya ayyà Manase; Manase ayyà Amon; Amon ayyà Yosəya; ");
INSERT INTO mfh_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosəya ayyà Ye­ko­niya atà la azla­deda aŋha, la mok uwana tahəl azlabəza Isərayel à Babila. ");
INSERT INTO mfh_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mok uwana tadàla atà bokuba azla­mayà à Babila kà, Ye­ko­niya ayyà Sala­tiyel; Sala­tiyel ayyà Zoro­babel; ");
INSERT INTO mfh_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zoro­babel ayyà Abiyud; Abiyud ayyà Eli­yakim; Eli­yakim ayyà Azor; ");
INSERT INTO mfh_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ayyà Sadok; Sadok ayyà Akim; Akim ayyà Eliyud; ");
INSERT INTO mfh_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyud ayyà Ele­yazar; Ele­yazar ayyà Matan; Matan ayyà Yakuba; ");
INSERT INTO mfh_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakuba ayyà Yusufu, zil aŋa Mari­yama uwana ayyà Yesu, uwana Kristu tagoɗal. ");
INSERT INTO mfh_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kiya uwaga kà dagay Abəraham tsəràh à David mayyi à tsəh ala kulo gəl aŋha ufaɗ, ŋgaha kulo gəl aŋha ufaɗ dagay David tsəràh à uwana tadàla atà à Babila, ŋgaha aya kulo gəl aŋha ufaɗ tsəràh à mayyi Yesu uwana Kristu. ");
INSERT INTO mfh_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kiya uwaga apakà vok aŋa mayyi Yesu Kristu. Iyà aŋha, Mari­yama agà mawɗa aŋa Yusufu, ama dagay uwana taga­gamay dadàŋ aw kà, Mari­yama agà la bəzi la huɗ, uwaga kà Masasəɗok Zəzagəla la uwana adàllà à huɗ. ");
INSERT INTO mfh_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ama Yusufu mawɗa aŋha kà dza dziriga, asal masəla à uda la dazu­waya la huma à azladza aw, adzùgw masak à mawɗa aŋha la səbàh. ");
INSERT INTO mfh_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mok uwana adzùgw uwaga kà masakal kà, malika aŋa Zəzagəla apə̀halla vok la mase­siŋay agòɗal: “Yusufu, mayyi à tsəh ala aŋa David, guba akəs ka kà mazəɓ Mari­yama mawɗa aŋak aw, kà uwana la ndzəɗa aŋa Masasəɗok Zəzagəla la uwana akùd bəzi uwaga la huɗ aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Masla adàyyi bəzi zilga, uwana kadàvàl sləm Yesu, uwana adàɓəl tsəhay aŋha la tsakana aŋatà la abà gesina.” ");
INSERT INTO mfh_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tatak uwaga gesina apakà vok kà magəɗ à afik bokuba uwana Sufəl Zəzagəla apə̀h à ahàl aŋa azlaməna mapəh à atà gay à ahàl kà mapàh à azladza: ");
INSERT INTO mfh_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ˈDa­halay uwana asəl zil aw, adàzəɓ bəzi à huɗ, adàyyi bəzi zilga, tadàvàl sləm Ema­nuyel.ˈ (Uwana asal magoɗay: Zəzagəla la ahəŋ la anu) ");
INSERT INTO mfh_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mok uwana Yusufu adatsən ala kà, aɗahàŋ bokuba uwana malika aŋa Sufəl Zəzagəla apə̀hal la mase­siŋay, ŋgaha azə̀ɓ Mari­yama mawɗa aŋha kà mis. ");
INSERT INTO mfh_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ama Yusufu ahənà à ahəŋ la masla tsəràh à mayyi kona aŋha, uwana Yusufu avàl sləm Yesu, aw. ");
INSERT INTO mfh_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Kiya uwaga tayyà Yesu la gudəŋ Be­te­lehem, la kutso aŋa Yahu­diya la abà la zamana aŋa sufəl Herod. Uwana tayyay kà, azlaməna masəl tatak uwana tanərə̀zàh azla­tse­tsiliŋ tasà à afik la mas à afik afats, tasà à Uru­sa­lima. ");
INSERT INTO mfh_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tanàv: “Aŋala bəzi uwanay tayyà la ahàl à ahàl à uwana adàgay Sufəl aŋa azla Yahu­diya la? Mənəŋàŋ tse­tsiliŋ aŋha apə̀hla vok ala la mas à afik afats, maslà gà la uwaga məsa à afik kà makədeɗal à ahəŋ.” ");
INSERT INTO mfh_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kay, mok uwana sufəl Herod atsə̀n uwaga, guba akəs, gəl akàɗal à vok la azlaməna madz à ahəŋ la Uru­sa­lima gesina. ");
INSERT INTO mfh_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ahamà gay azlaməŋga aŋa azlaməna mav tatak à Zəzagəla à vok la azlaməna matapla wakità aŋa Musa à azladza, anav à atà gay ala naka tayyi Kristu ma à uwala asla tak la? ");
INSERT INTO mfh_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tagoɗal: “La Be­te­lehem, la kutso Yahu­diya la abà.” Kà uwana aganay azlaməna mapəh à atà gay à ahàl tatsetsèr: ");
INSERT INTO mfh_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ˈKak Be­te­lehem la kutso Yahu­diya la abà, Katsəh azla­gu­dəŋ aŋa Yahu­diya à tsəh aw, Kà uwana la kak la abà La uwana masla humà uwana adàguw tsəhay gulo Isərayel à huma adàs à uda.ˈ Zəzagəla agoɗ. ");
INSERT INTO mfh_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kiya uwaga Herod azàl azlaməna masəl tatak uwaga la gəl à gəl, ŋgaha anàvà à atà kaslà mapəhla vok ala aŋa tse­tsiliŋ uwatà la gay ala. ");
INSERT INTO mfh_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","La lig la ahəŋ aslə̀lla atà à Be­te­lehem: “Dàw, kayahaw bəzi uwatà, baŋa kada­ɓəzawwal kà, kadàpəhaw à gi ala babay, kà gi aŋa maday aŋa makədeɗal à ahəŋ suwaŋ”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mok uwana tatsə̀ɓ sləm à mapəhay aŋa sufəl uwaga kà, tahàd, tanəŋà tse­tsiliŋ uwana tanəŋàŋ la mas à afik afats, aga la huma aŋatà, ama mok uwana adabə̀z à slaka uwana bəzi la ahəŋ kà, tse­tsiliŋ atsìzl à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Uwana tanəŋàŋ kiya uwaga kà, tahə̀n ala la marabay məŋga. ");
INSERT INTO mfh_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tadà à gày, tanəŋàŋ bəzi vərna la iyà aŋha Mari­yama. Takədèɗàh à ahəŋ, tazlə̀ɓà bəzi, tapàlla kazlaŋa aŋatà ala, ŋgaha tavàhal azla­tatak: Luwà­luwà, matərsin, ŋgaha la mir. ");
INSERT INTO mfh_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","La lig la ahəŋ Zəzagəla apə̀h à atà vok à abà la mase­siŋay kà atà aŋa maguway la slaka sufəl Herod aya aw. Kiya uwaga tanəfà tetəvi anik kà mawul à gudəŋ aŋatà. ");
INSERT INTO mfh_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mok uwana azlaməna masəl tatak tadìy aŋatà, malika aŋa Sufəl Zəzagəla apə̀hla vok à Yusufu la mase­siŋay, agòɗal: “Sà à afik, zə̀ɓ bəzi la iyà aŋha, ŋgaha hòy à gudəŋ Misəra, kadàdz à ahəŋ la abatà tsəràh à uwana: ‘Wùlla à waŋ’, gədàgoɗ à ka, kà uwana Herod adàyah makəɗ bəzi.” ");
INSERT INTO mfh_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Hadzak, Yusufu atsìzlla ala, azə̀ɓ bəzi la iyà aŋha, ŋgaha ahòy la atà la vəɗ à kutso Misəra. ");
INSERT INTO mfh_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Adzà à ahəŋ la abatà tsəràh à mamətsay aŋa Herod, uwaga apakà vok kà magəɗ uwana à afik Sufəl Zəzagəla apə̀h la paŋaw aŋa azlaməna mapəh à atà gay à ahàl kà mapàh à azladza: ˈGəzàl à bəzi gulo à uda la kutso Misəra.ˈ ");
INSERT INTO mfh_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mok uwana Herod asə̀l kà azlaməna masəl tatak tava­vàràŋ kà, apàk ləv kaykay, avà tetəvi kà makaɗ azla­beza zilga la gudəŋ Be­te­lehem gesina dagay la azla­vərnaga tsəràh à mavay səla. Dagay la matsən gay mapəhla vok ala aŋa tse­tsiliŋ, uwana atsənàŋ la slaka azla­ma­səl tatak uwaga. ");
INSERT INTO mfh_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kiya uwaga agə̀ɗ à afik, uwana masla mapəhal gay à ahàl Ye­re­miya agòɗ: ");
INSERT INTO mfh_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ˈHulolo atsə̀n la Rama, matuway la mawiyay məŋga. Uwaga kà Rahilu la uwana atùw azlabəza aŋha, Asal matasla ala gay à ahəŋ aw, kà uwana tamatsay.ˈ ");
INSERT INTO mfh_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mok uwana Herod adamətsay, malika aŋa Sufəl Zəzagəla apə̀hla vok à Yusufu la mase­siŋay la Misəra. ");
INSERT INTO mfh_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Agòɗal: “Lagwa kà, sà à afik, zə̀ɓ bəzi la iyà aŋha, wùlàw à kutso Isərayel, kà uwana azladza uwana tayàh makəɗ bəzi kà tadamətsay.” ");
INSERT INTO mfh_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kiya uwaga Yusufu atsìzlla ala, azə̀ɓ bəzi la iyà aŋha, ŋgaha tawùl à Isərayel. ");
INSERT INTO mfh_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ama atsənàŋ kà Arke­lawus la uwana, azùw sufəl aŋa baba aŋha la Yahu­diya kà, guba akə̀s kà mawul à kutso uwatà à abà. Ama uwana adatsən Zəzagəla apə̀hal la mase­siŋay la abà aya kà, ahàd, aɓə̀k vok à makoray aŋa Galili à abà, ");
INSERT INTO mfh_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ŋgaha aŋàl gày aŋha à bəzi gudəŋ uwana à abà, sləm aŋha Nazaret. Aɗahàŋ kiya uwanay kà, kà magəɗ à afik gay uwana azlaməna mapəh à atà gay à ahàl tapàh, tagòɗ kà: ˈTa­dà­zalalla zil Nazaret.ˈ ");
INSERT INTO mfh_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","La zamana uwatà kà, Yuhana masla maɗàh batem apə̀hla vok ala la fəta aŋa Yahu­diya la abà, ŋgaha adzəkà mazàh sayda. ");
INSERT INTO mfh_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Pə̀hàw gay la ləv ala, kà uwana makoray Sufəl Zəzagəla kà nekwa atsa à waŋ”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yuhana kà dza uwana masla mapəhal gay à ahàl Yesayya apə̀h lakəl aŋha agòɗ: ˈUwaga kuda aŋa dza la uwana awiyay la fəta la abà: ‘Slàɗàw tetəvi aŋa Sufəl Zəzagəla, Tsìzllàw azla­tetəvi mana­la­ba­hayga ala gesina’ˈ, agòɗ. ");
INSERT INTO mfh_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Lukut aŋa Yuhana kà maɗehəŋga la aŋidz aŋa zlugumi, ŋgaha awàɗ para­para aŋa zlap à tsəh, tatak may aŋha kà hayyaw, la zuway mazuway la fəta. ");
INSERT INTO mfh_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Azlaməna madz à ahəŋ la Uru­sa­lima, la azla­uwana la kutso Yahu­diya ŋgaha la azla­uwana la makəla aŋa mukwà Urdun gesina tasà à waŋ à slaka aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tapàh tsakana aŋatà à uda la dazu­waya, ŋgaha aɗahà à atà batem la mukwà Urdun la abà. ");
INSERT INTO mfh_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ama mok uwana Yuhana anəŋà azla Farisəya la azla Sadu­kiya aŋuvaw tatsà à waŋ à slaka aŋha kà maɗa­hatàŋ batem kà, agòɗ à atà: “Maham à ahəŋ aŋa matsapa: uwa apə̀h à akul kà kadàtəfaw à seriya aŋa Zəzagəla uwana la gay ala, adàsa à waŋ aw uwa? ");
INSERT INTO mfh_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Lagwa kapəhawla sləray aŋkul uwana ala, apəhla ala kà kada­sakaw à sləray aŋkul uwana uwarà kaɗa­hà­hàwwàŋ. ");
INSERT INTO mfh_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ŋgaha kà kadzugwaw kà mats zlapay la gəl aŋkul: ‘Abəraham kà baba gami madzi­dziga’, kagodaw aw. Haɗay, gəpəh à akul kà, Zəzagəla aslala vok apak azlaakur ala kà mayyi à tsəh ala aŋa Abəraham. ");
INSERT INTO mfh_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Lagwa kà, goslka kà maɗehəŋ à ahəŋ gà nekwa kà mahərats la tsəh à ahàf à afik. Kəla ahàf uwana av mayyay delga aw, agay manats à ahəŋ gà ŋgaha maduw à akàl à tsəh. ");
INSERT INTO mfh_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Gi kà, gəɗa­ha­kulla batem kà la iyaw, kà mapəhla ala kà kadapəhaw gay la ləv ala pəra. Ama dza uwana adàs à waŋ la lig gulo la ahəŋ kà adà­ɗa­ha­kulla batem kà la Masasəɗok Zəzagəla, ŋgaha la akàl. Masla kà, aɗuwa gi la maslay ndzer, gi kà, gəsla kà mapaləŋ ala amiyaka bà zuwiɗ kwimik aŋha babay aw. ");
INSERT INTO mfh_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kətsaw maduw hi aŋha la ahàl kà maduwla hi kà mavàh hi ala la tafàr. Hi kà atsàk à vəɗa aŋha à abà, ama tafàr kà aduwal à akàl uwana à tsəh adà­ma­tsila la abà aw.” ");
INSERT INTO mfh_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kiya uwaga Yesu atsìzlla ala la gudəŋ Galili asà à Urdun à slaka Yuhana kà maɗa­halla batem. ");
INSERT INTO mfh_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ama gəl akàɗ à Yuhana à vok, agòɗal: “Gi la uwana gənuəkuɗa aŋa batem la slaka aŋak aya kà pəra, katsà à slaka gulo kà maɗàh à ka batem aya ay?” ");
INSERT INTO mfh_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ama Yesu awulàlla: “Kə̀s, apakà vok kiya uwanay dadàŋ, kà uwana kiya uwanay la uwana məhənaw uwana ala Zəzagəla apə̀h à anu ala la uwana anàv anu gesina.” ");
INSERT INTO mfh_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","La lig la ahəŋ aɗa­hàlla batem. Uwana Yesu adasa à uda la iyaw la abà kà, zagəla apə̀zlla à ama ala, anəŋà Masasəɗok aŋa Zəzagəla atsà à ahəŋ, adzà à gəl aŋha bokuba haba­koku. ");
INSERT INTO mfh_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ŋgaha kiya uwaga aya, kuda atsə̀n à ahəŋ la zagəla la afik: “Dza uwanay kà bəzi gay ləv gulo, gəf marabay gulo la madzugway gulo kà à masla à afik”, agòɗ. ");
INSERT INTO mfh_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kiya uwaga Masasəɗok Zəzagəla adàla Yesu à fəta à abà kà seteni aŋa mapa­patay. ");
INSERT INTO mfh_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Mok uwana Yesu adaɗàh mavakay dzik ufaɗ, la mahənay dzik ufaɗ kà, may akə̀s masla. ");
INSERT INTO mfh_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kiya uwaga seteni azà vok à slaka aŋha la magoɗal: “Baŋa kak Kona aŋa Zəzagəla ndzer kà, ‘Pàk kaf!’, gòɗ à akur uwanay.” ");
INSERT INTO mfh_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu awùlla à uda: “Uwaga kà matse­tse­rayga: ˈDza adzadzar vok kà la kaf pəra aw, ama la kəla gay gesina uwana atsa à waŋ la paŋaw aŋa Zəzagəla la awtày.ˈ” ");
INSERT INTO mfh_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kiya uwaga seteni adàla masla à Uru­sa­lima, à gudəŋ tsi­ɗa­ŋaga à abà, adàla à gəl aŋa məŋ gày Zəzagəla à afik, ");
INSERT INTO mfh_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","agòɗal: “Baŋa kak Kona aŋa Zəzagəla ndzer kà: Vàl à ahəŋ la abanay, kà uwana uwaga kà matse­tse­rayga: ˈ‘Dàw!’, Zəzagəla adàgoɗ à azla­ma­lika aŋha lakəl aŋak kà mazlak ka Ŋgaha tadàkəs ka la matsaw ka kà, kà akur aŋa mazləl ka asik aw.ˈ” ");
INSERT INTO mfh_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu awulàlla: “Tatsetsèr à wakità à abà la slaka anik babay kà: ˈKa­pa­pata Sufəl Zəzagəla aŋak aw.ˈ” ");
INSERT INTO mfh_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","La lig la ahəŋ seteni adàla à gəl gudəŋ matsəka­ka­ɗayga à afik aya, apə̀halla makoray aŋa gudəŋ à vok gesina la mazləɓay aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Gədàvà à ka uwaga gesina, à baŋa kakəɗeɗ à gi à ahəŋ kasləkaw gi”, agòɗal. ");
INSERT INTO mfh_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu agòɗal: “Zà vok, kak seteni! Haɗay, tatsetsèr à wakità Zəzagəla à abà kà: ˈZlə̀ɓà Sufəl Zəzagəla aŋak, ŋgaha ɗàhalla sləray kà masla kokuɗa gəl aŋha pəra.ˈ” ");
INSERT INTO mfh_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","La abatà seteni asàkal à ahəŋ. Azla­ma­lika tasà à waŋ à slaka Yesu kà mazla­kəŋ. ");
INSERT INTO mfh_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Mok uwana Yesu atsənàŋ tadùw Yuhana à daŋay kà, atsìzlla ala, adà aŋha à Galili. ");
INSERT INTO mfh_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Asàk à madz à ahəŋ la Nazaret, ahàd kà madz à ahəŋ la Kaper­nahum, gudəŋ uwana la gay dərəv aŋa Galili, la makoray aŋa Zabulon la Neftali la abà. ");
INSERT INTO mfh_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Apakà vok kiya uwaga kà, kà gay aŋa masla mapəhal gay à ahàl Yesayya aŋa magəɗ à afik: ");
INSERT INTO mfh_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","ˈKutso aŋa Zabulon la aŋa Neftali, Uwana la gay mukwà, la kutso uwana la dərəv à uda anik aŋa mukwà Urdun, Ŋgaha la Galili uwana azladza uwana azla Yahu­diya aw, tadz à ahəŋ la abà. ");
INSERT INTO mfh_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tsəhay uwana adz à ahəŋ la mələs la abà, Adànəŋ magol uɗaka. Azla­uwana tadz à ahəŋ la dzəgay aŋa mamətsay la abà bay, Uɗaka adàpəhatàla vok.ˈ ");
INSERT INTO mfh_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Dagay la kaslà uwatà, Yesu adzəkà mapəh gay Zəzagəla, agòɗ à atà: “Pə̀hàw gay la ləv ala kà uwana makoray aŋha kà nekwa.” ");
INSERT INTO mfh_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Mok uwana Yesu augu­zahay la gay mukwà aŋa Galili kà, anəŋà Səmon uwana tazallala Piyer atà la deda aŋha Andəre, uwana tadàw dzarawa aŋatà à iyaw à abà; kà uwana atà azlaməna makas kilfi. ");
INSERT INTO mfh_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu agòɗ à atà: “Nəfàw gi, ŋgaha gədàpakakulla kà azlaməna makas azladza.” ");
INSERT INTO mfh_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Katskats tasàk à dzarawa aŋatà à ahəŋ ŋgaha tanəfà masla. ");
INSERT INTO mfh_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Adà à huma à gay kərkər zwek, tanəŋà Yakuba atà la Yuhana deda aŋha, azla­kona aŋa Zebede. Tagà la kəslah iyaw aŋatà la afik la baba aŋatà Zebede, taɗàh dzarawa aŋatà, Yesu azàl atà. ");
INSERT INTO mfh_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","La katskats tasàk à kəslah iyaw aŋatà à ahəŋ la baba aŋatà gà, tanəfà Yesu. ");
INSERT INTO mfh_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu auguzàh la kutso Galili gesina, ata­pàhla azladza la azlagày madəv kuɗa la aku, azahà à ata gay marabəŋ lakəl aŋa makoray Zəzagəla, ŋgaha awarà azladza ala la azlatsəhay ɗuvats anik anik, la azla­deri gesina. ");
INSERT INTO mfh_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Azladza tatsənàŋ tapəhay lakəl aŋha la makoray aŋa Səriya gesina, ŋgaha tasàhla azlaməna ɗuvats anik anik à waŋ gesina uwana tas ŋgərpa, la azla­ma­sasəɗok mawi­siga, la azla­deri ŋgaha awarà atà ala. ");
INSERT INTO mfh_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Maham à ahəŋ dza aŋuvaw anəfà masla, tasà à waŋ la kutso Galili, la makoray aŋa gudəŋ kulo, la Uru­sa­lima, la Yahu­diya ŋgaha la gay makwi aŋa dərəv à uda aŋa mukwà Urdun. ");
INSERT INTO mfh_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mok uwana Yesu anəŋà maham à ahəŋ dza uwaga, ahàd à gudəŋ à afik adzà madzay la abatà, azlaməna matapla aŋha tasà à waŋ à slaka aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ŋgaha Yesu adzəkà matapatàla la kiya uwanay: ");
INSERT INTO mfh_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Marabay agay la azladza uwana tasəl la gəl aŋatà kà azlaməna kuɗa, kà uwana makoray Zəzagəla kà aŋatà! ");
INSERT INTO mfh_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Marabay agay la azla­uwana atà la mazaw la gəl la abà, kà uwana Zəzagəla adàtasl à atà gay à ahəŋ! ");
INSERT INTO mfh_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Marabay agay la azla­uwana azlatələmma, kà uwana tadàɓəz kutso uwana Zəzagəla apə̀hà ahəŋ! ");
INSERT INTO mfh_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Marabay agay la azla­uwana tawoya madz à ahəŋ bokuba uwana asa à Zəzagəla, kà uwana Zəzagəla adà­hatàŋ lela! ");
INSERT INTO mfh_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Marabay agay la azla­uwana vok aham à atà kà azladza anik, kà uwana vok adàham à Zəzagəla kà atà suwaŋ! ");
INSERT INTO mfh_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Marabay agay la azla­uwana azla­sətaka la ləv aŋatà la tsəh, kà uwana tadànəŋ Zəzagəla! ");
INSERT INTO mfh_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Marabay agay la azla­uwana tatsala lapiya à tataka aŋatà à abà, kà uwana Zəzagəla adàzal atà ala azlabəza aŋha! ");
INSERT INTO mfh_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Marabay agay la azla­uwana tatərəɓ atà, kà uwana taɗehəŋ kà uwana asà à Zəzagəla, makoray Zəzagəla kà adàgay kà aŋatà ndzer! ");
INSERT INTO mfh_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Marabay agay la akul, à baŋa azladza tatsək à akul mago­ɗahay à gəl, takal akul gay à vok, tapəh à akul azla­ma­wi­siga à vok gesina babay, kà uwana akul azlaməna matapla la slaka gulo. ");
INSERT INTO mfh_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Vàlàhàw à zagəla, ràbàw kà uwana masik məŋga akud akul la zagəla. La kità bay tatərə̀ɓàhàŋ azlaməna mapəh à atà gay à ahàl kà mapàh à azladza, uwana tadzà à ahəŋ uwarà.” ");
INSERT INTO mfh_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Akul la uwana akul azla­slugul aŋa gudəŋ à vok. Ama baŋa slugul azlaɗay aya aw ma, la mana tazla­ɗəŋ ala aya ma? Akəsà vok aya aw, say mafətəkw ala pəra, ŋgaha azladza tamələŋ à tsəh.” ");
INSERT INTO mfh_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Akul la uwana akul azlau­ɗaka aŋa gudəŋ à vok. Huɗ gudəŋ uwana maŋal à gəl gudəŋ à afik gà, kà ahàɗ vok à ahəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tavàts fənəs aŋa maf à tsəh tasà aw, ama tafay kà à slaka masərət fənəs à ahəŋ, kà mav uɗaka à azladza gesina, uwana la kay uwaga. ");
INSERT INTO mfh_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kiya uwaga la uwana uɗaka aŋkul auɗay la huma aŋa azladza gudəŋ à vok kəla suwaŋ, kà azladza gudəŋ à vok aŋa manəŋ sləray aŋkul kà delga, ŋgaha atà tadà­zləɓ Baba aŋkul uwana la zagəla la afik.” ");
INSERT INTO mfh_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kadzugwaw kà gəsà à waŋ kà maslàh mapəhay aŋa Musa ala, ŋgaha la mapàhla ala aŋa azlaməna mapəh à atà gay à ahàl kagoɗaw aw, ama gəsà à waŋ kà, kà masəla godega aŋha à uda pəra ndzer. ");
INSERT INTO mfh_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Haɗay, gəpəh à akul la dziriga: Tsəràh à uwana zagəla la kutso adàdəv à gay, amiyaka bà bəzi manəhay aŋa mapəhay uwanay adàkəɗ vok aw, ŋgaha tsəràh à makəɗ gəl à ahəŋ aŋa tatak gesina. ");
INSERT INTO mfh_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kà uwaga kəla dza uwana apəsew bəzi manəhay aŋa mapəhay uwaga, ŋgaha atapla azladza anik kà maɗehəŋ kiya aŋha kà, masla kà adàgay bəzi gà la makoray Zəzagəla. Ama dza uwana akəs mapəhay uwaga, ŋgaha atapla azladza kà maɗehəŋ kiya aŋha kà, masla kà adàgay məŋga la makoray Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ndzer, gəgoɗ à akul: Baŋa dziriga aŋkul aɗuw aŋa azlaməna mapàhla wakità seriya ala, ŋgaha la azla Farisəya aw kà, kadaw à makoray Zəzagəla aw.” ");
INSERT INTO mfh_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Katsənàw uwana tapàh à azla­baba aŋkul madzi­dziga: ‘Kakəɗ dza aw, dza uwana akəɗ dza kà tadala à huma seriya.’ ");
INSERT INTO mfh_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ama gi gəgoɗ à akul kà: Kəla uwa­be­yuwi uwana apàk ləv lakəl aŋa deda aŋha kà, ad à huma seriya. Dza uwana: ‘Kak bada’, agoɗ à deda aŋha kà, tadala à huma seriya aŋa azla­ma­siga. Dza uwana: ‘Kak kusoŋu’, agoɗ à deda aŋha kà, azlayla vok ad à akàl à abà. ");
INSERT INTO mfh_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Lagwa kà, baŋa kadzəka makəɗ tatak à Zəzagəla, ŋgaha awul à ka à gəl kà gay la ahəŋ la tataka aŋkul la abà la deda aŋak kà, ");
INSERT INTO mfh_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","sàk à tatak aŋak à ahəŋ la abatà, hàd, katsənà vok gay la deda aŋak dadàŋ, ŋgaha baŋa gay adadəv à gay kà, wùl à waŋ, kakəɗ tatak aŋak à Zəzagəla adagay zla!” ");
INSERT INTO mfh_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Baŋa dza apuwà à ka gudzi à gəl, pəra kahamàw à tetəvi à ama kà mad à seriya kà, mərà vok kà akul aŋa matsən vok gay la mok uwana akul la tetəvi la ama dadàŋ, kà masla aŋa maf ka à ahàl aŋa masla seriya aw, ŋgaha babay kà masla seriya aŋa maf ka à azla­slodzi à ahàl, ŋgaha atà aŋa maduw ka à daŋay aw. ");
INSERT INTO mfh_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","La dziriga gəgoɗ à ka, tetuwa kadàsa à uda la abatà aw say baŋa kadà­tse­tsekwah azla­ka­lamay aŋak à waŋ gesina dadàŋ.” ");
INSERT INTO mfh_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Katsənàwwàŋ bokuba uwana apəhà vok kà: ‘Kada à gəl gaw aw.’ ");
INSERT INTO mfh_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ama gi kà, gəgoɗ à akul kà: Kəla dza uwana anə̀ŋ à mis aŋa dza anik à adi la makəɗal à adi vok la ləv aŋha la tsəh kà, adadà à gəl gaw. ");
INSERT INTO mfh_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Baŋa kà yewdi ahàl kaf aŋak la uwana katəɗ à tsakana à abà kà, ɓə̀ɗ à adi ala, məl ala kərkər, kà uwana ŋuləm kà manəbay vok aŋak tekula azà ala, kà kak aŋa mad à gày akàl à abà la vok aŋak gesina. ");
INSERT INTO mfh_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Iyay, baŋa ahàl kaf aŋak la uwana apapat ka à tsakana à abà kà, nàts à vok ala, ŋuləm kà aŋak kà manəbay vok aŋak tekula azà ala, à kà vok aŋak gesina aŋa mad à gày akàl à abà.” ");
INSERT INTO mfh_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Apəhà vok aya babay kà: ‘Dza uwana akudək mis aŋha kà, say avàl wakità aŋa mavàh vok ala à ahàl dadàŋ.’ ");
INSERT INTO mfh_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ama gi kà, gəgoɗ à akul kà: Kəla uwa­be­yuwi uwana akudək mis aŋha, uwala aɓə̀zal à gəl la mazaɓ zil la tsəh aw kà, masla à zil uwaga kà adada à gəl gaw, à baŋa azəɓ mis anik, ŋgaha dza uwana azəɓ mis makuɗəkay gà babay kà, adàda à gel gaw, suwaŋ.” ");
INSERT INTO mfh_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Bà gotənaŋ katsənàwwàŋ tapə̀h à azla­baba gami madzi­dziga babay kà: ‘Kazuw mawaɗay la fida aw, ama hənà mawaɗay aŋak ala kà la Sufəl Zəzagəla la afik pəra.’ ");
INSERT INTO mfh_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ama gi kà, gəgoɗ à akul kà: Kazuwaw mawaɗay aw! Kazuwaw mawaɗay baməraka la zagəla aw, kà uwana uwaga kà kursi aŋa Sufəl Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Baməraka la kutso aw, kà uwana uwaga kà slaka maf asik à ahəŋ aŋha, adagay la Uru­sa­lima bay aw, kà uwana uwaga kà məŋ gudəŋ aŋa Sufəl. ");
INSERT INTO mfh_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kazuw mawaɗay la gəl aŋak aw, kà uwana kaslala vok, kà mapak aŋidz gəl aŋak tekula ala kà me­ɗe­kuga, baŋaw kà marsiga aw. ");
INSERT INTO mfh_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ama gòɗàw pəra kà: ‘Iyay’, baŋaw ‘Awaŋ’, kà uwana kəla tatak uwana dza aziŋ à uwaga à gəl kà, aguwa à uda kà la slaka masla mawi­siga.” ");
INSERT INTO mfh_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Katsənàwwàŋ bokuba uwana apəhà vok kà: ‘Yewdi mapəlay la yewdi, sliɗ bay mapəlay la sliɗ.’ ");
INSERT INTO mfh_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ama gi kà, gəgoɗ à akul kà: Kawulawla mawi­siga à dza uwana asal maɗa­ha­kulla mawi­siga à vok aw. Baŋa dza aɓə̀k à ka ahàl à paŋaw ahàl kaf kà, gòlla paŋaw ahàl gudzay à awtày aya. ");
INSERT INTO mfh_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Baŋa dza akəl à ka gay à vok, kà mazəɓ tsempa aŋak kà, sàkal azəɓ dawara gà aya babay. ");
INSERT INTO mfh_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Baŋa dza afa à ka gasa à gəl kà mazəɓal tatak maha­nayga, kà mazəɓalaŋ dahoy pəlis tekula kà, dàlla mahoy pəlis səla. ");
INSERT INTO mfh_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Và à dza uwana anav à ka tatak; kagola lig à dza uwana à gay asal makəl goder la slaka aŋak aw!” ");
INSERT INTO mfh_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Katsənàwwàŋ bokuba uwana apəhà vok kà: ‘Wòyà masla magay aŋak ŋgaha pəsèw masla məzam aŋak.’ ");
INSERT INTO mfh_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ama gi kà, gəgoɗ à akul kà: Wòyàwwàŋ azlaməna məzam aŋkul, də̀vàw kuɗa kà aŋa azladza uwana tatərəɓ akul. ");
INSERT INTO mfh_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kà akul aŋa magay azlabəza aŋa Baba aŋkul uwana la zagəla la afik. Kà uwana avəɗ afats à azlaməna tsakana, kiya aŋa azladza dziriga babay. Ŋgaha asuw iyaw à azladza dziriga, asuw à azlaməna tsakana babay. ");
INSERT INTO mfh_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Iyay, baŋa kawo­yawwaŋ kà azla­uwana tawoyà akul pəra ma, kà mana kakudaw maɓəz tatak la slaka Zəzagəla aya ma? Amiyaka azlaməna mazəɓ hadama babay kà, kiya uwaga taɗehəŋ aw takay? ");
INSERT INTO mfh_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ŋgaha baŋa kaɗa­hawwaŋ ‘Ayyi’ kà azla­deda aŋkul pəra ma ‘Delga məda­ɗe­həŋ’, kagoɗaw takay? Bà azladza uwana tasəl Zəzagəla aw babay kà, kiya uwaga la uwana taɗehəŋ. ");
INSERT INTO mfh_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kità kà, gàw sətaka, bokuba Baba aŋkul uwana la zagəla la afik sətaka, suwaŋ.” ");
INSERT INTO mfh_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Baŋa kaɗahaw dziriga kà, kaɗa­hawwaŋ kà huma yewdi aŋa azladza aw. Baŋa kiya uwaga kaɗa­hawwaŋ kà, kadàɓəzaw masik la slaka Baba aŋkul uwana la zagəla aw.” ");
INSERT INTO mfh_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Baŋa asa à ka mav sili à masla kuɗa anik kà, kahama kà dza à ahəŋ dàŋ kà mavàl aw, bokuba uwana azlaməna magolla dza taɗehəŋ la azlagày madəv kuɗa la aku, ŋgaha la azla­ma­ka­lapa tetəvi la ama aw. Taɗehəŋ kiya uwaga kà, kà azladza aŋa mazləɓ atà. La dziriga gəpəh à akul, atà kà taɓəz masik aŋatà tsewwa adagay. ");
INSERT INTO mfh_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ama kak kà, baŋa kav sili à masla kuɗa kà, ɗahà uwaga la kiya uwanay: Amiyaka bà slawda aŋak nekwa gà babay kà, asəl uwaga aw, ");
INSERT INTO mfh_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","kà mavày aŋak aŋa magay masəlay gà aw. Say Baba aŋak, uwana la zagəla la afik, la uwana asəl tatak uwaga pəra, ŋgaha masla adàwulla à ka ala məŋga aya.” ");
INSERT INTO mfh_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Baŋa kadəvaw kuɗa kà, kaɗa­hawwaŋ bokuba aŋa azlaməna magolla dza aw: Kà uwana atà kà, asa à atà madəv kuɗa kà la slaka matsizlla ala la azlagày madəv kuɗa la aku, ŋgaha la azla­ma­ka­lapa tetəvi la ama kà azladza gesina aŋa manəŋ atà. La dziriga gəpəh à akul: Atà kà, taɓə̀z masik aŋatà, tsewwa adagay. ");
INSERT INTO mfh_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ama kak kà, baŋa asa à ka madəv kuɗa kà, hàd à gày, tsàk à vok à ama, ŋgaha də̀v kuɗa à Baba aŋak, uwana la zagəla la afik, ŋgaha Baba aŋak uwana asəl uwana kaɗehəŋ la ləv aŋak la tsəh, adav à ka masik aŋak.” ");
INSERT INTO mfh_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Baŋa kadəvaw kuɗa kà, katsa­lahaw azlagay deydayga à gay pəra, bokuba aŋa azladza uwana tasəl Zəzagəla aw, aw, tadzugw kà la mavats gay wadza wadzaga uwaga kà, ‘Zəzagəla adàtsəɓ à anu sləm’, tagoɗ. ");
INSERT INTO mfh_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kaɗa­hawwaŋ kiya uwaga aw, kà uwana Baba aŋkul uwana la zagəla la afik asəl tatak uwana kanavaw kuɗa aŋha dagay uwarà, à mok uwana kada­na­vawal dadàŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Aganay tetəvi aŋa madəv kuɗa: Baba gami uwana la zagəla la afik. Ɗahàŋ kà azladza gesina tazləɓa sləm aŋak tsi­ka­slaga. ");
INSERT INTO mfh_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Makoray aŋak atsà à waŋ. Mawoyəŋ aŋak apaka vok la vəɗah, Bokuba uwana la zagəla. ");
INSERT INTO mfh_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Và à anu tatak may, uwana asla à anu lakana. ");
INSERT INTO mfh_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bàs à anu mawi­siga uwana məɗehəŋ gesina, Bokuba uwana məbasaŋ à azladza uwana taɗahà à anu mawi­siga à vok babay suwaŋ. ");
INSERT INTO mfh_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tə̀fà à anu kà seteni aŋa mapapat anu, kà anu aŋa masak à madiŋal gel à vok aw, Ama tə̀fà à anu la ahàl aŋa seteni.” ((Kà uwana makoray, maslay ŋgaha la mazləɓay kà la ahàl aŋak aŋa tsəràh à awtày. Amen!)) ");
INSERT INTO mfh_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Baŋa kaba­sawwaŋ à azladza anik uwana taɗa­hà­kulla mawi­siga à vok, Baba aŋkul uwana la zagəla la afik adà­ba­sa­kulaŋ suwaŋ. ");
INSERT INTO mfh_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ama baŋa kaba­sawwaŋ à azladza anik uwana taɗa­hà­kulla mawi­siga à vok aw kà, Baba aŋkul uwana la zagəla adà­ba­sa­kulla mawi­siga aŋkul uwana kaɗa­hàwwàŋ suwaŋ aw.” ");
INSERT INTO mfh_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Baŋa kakəsaw nəlay kà, pə̀hàwla huɗ adi aŋkul ala, ùzlə̀ɗaw kà kiya aŋa azlaməna magolla dza uwanay taɗehəŋ aw: Atà kà, taɓəɗla huɗ adi, kà azladza gesina aŋa masəlay kà atà la nəlay la abà. ");
INSERT INTO mfh_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ama kak kà, baŋa kakəs nəlay kà, pàl adi aŋak lela, wàz gel aŋak à uda, ");
INSERT INTO mfh_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kà azladza aŋa masəlay kà kak la nəlay la abà aw. Say pəra kà Baba aŋak uwana la slaka mahaɗ vok à ahəŋ gà la zagəla, la uwana asəlay pəra, ŋgaha Baba aŋak uwana anəŋa uwana kaɗehəŋ adàvà à ka masik aŋak.” ");
INSERT INTO mfh_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kahamaw ləmana à gudəŋ uwanay la vok aw, kà uwana mamən akəsay, marzaw akəsay, azlaməna à gəl bay tazləlay, tazəɓay. ");
INSERT INTO mfh_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ama hàmàw ləmana aŋkul kà à zagəla à afik, la abatà mamən la marzaw akəsay aw, azlaməna à gel bay taslala vok aŋa mazləlay kà mazəɓay aw. ");
INSERT INTO mfh_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kà uwana la slaka uwana ləmana aŋak la abatà, la abatà ləv aŋak la abatà, suwaŋ.” ");
INSERT INTO mfh_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Yewdi kà uɗaka aŋa vok: Baŋa yewdi aŋak kà wurwur kà, vok aŋak gesina kà uɗaka; ");
INSERT INTO mfh_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ama baŋa yewdi aŋak la ɗuvats kà, vok aŋak gesina la mələs la abà. Baŋa uɗaka uwana la kak la abà mələs gà, mələs uwaga adàgay taɓa­ɗamma kaykay.” ");
INSERT INTO mfh_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Dza aslala kà atsəp à azlaməŋga à huma à gay səla aw: Adàpəseway anik, ŋgaha adakəs gay aŋa anik, aɗah dziriga à anik, ŋgaha adà­kweska anik. Kaslawwalla vok kà matsəp Zəzagəla à huma la sili aw.” ");
INSERT INTO mfh_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kà uwaga à uwana gəpəh à akul: Kafàw gəl à ahəŋ kà tatak may la tatak masay uwana kanawkuɗa aŋha, kà madza­dzarla kà vok aw, baməraka lakəl aŋa lukut uwana asa à akul kà aŋa matsokw à vok aŋkul, sifa kà aɗuwa tatak may, ŋgaha ma vok babay kà aɗuwa lukut aw takay? ");
INSERT INTO mfh_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nərə̀zàw azla­ɗiyaŋ uwana tahoyay la zagəla tsi: Tasləkay ŋgaha tatsəɗay tatak babay aw, taham tatak à vəɗa à abà babay aw, ama Baba aŋkul uwana la zagəla la afik adzadzar atà. Iyay zla, akul ma kaɗuwwaŋ azla­ɗiyaŋ aw takay? ");
INSERT INTO mfh_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Uwa la tataka aŋkul la abà aslala vok aŋa maziŋ à mavay aŋa sifa aŋha à adi amiya ŋuv la aslasl à gəl aŋha uwa?” ");
INSERT INTO mfh_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ŋgaha ma, kà mana kafaw gel à ahəŋ kà lukut zlà ma? Akul nərə̀zàw madz à ahəŋ aŋa azla­ma­wu­ra­tatay tsi: Taɗàh sləray aw, ŋgaha tavavəɗ lukut babay aw. ");
INSERT INTO mfh_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tsa baməraka Salomon la mazləɓay aŋha gesina kà, aɓəzà à lukut delga kiya mawu­ra­tatay uwaga aw. ");
INSERT INTO mfh_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Zəzagəla adàw lukut à azlakəsaf uwana à vok la fəta bay lakana, te­ke­ɗika lebəŋ kà tadà­ya­kats à akàl à abà: ŋgaha ma azlayla kà vok aɗuwa à akul à vok ɗaɗuwa aŋatà babay aw takay? Akul kà madiŋal gel à vok à tsəh kà akul ala. ");
INSERT INTO mfh_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kiya uwaga kà, kafàwla kà gəl à ahəŋ la magoɗay: ‘Mana mədà­zuway lebəŋ mi? Mana mədàsay mi? La mana mədàduw à vok mi?’, kagoɗaw aw! ");
INSERT INTO mfh_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Uwaga kà, azla­uwana tasəl Zəzagəla aw, la uwana tayàh tatak uwaga koksi­koksi. Ama Baba aŋkul uwana la zagəla kà, asəl tatak uwana kanawkuɗa aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Fàw gəl à ahəŋ dadàŋ teraŋa kà la makoray Zəzagəla, ŋgaha la madz à ahəŋ la sifa dziriga uwana la abanay anavay, ŋgaha Zəzagəla adàkəs akul à ahàl ala gesina uwana kayahaw. ");
INSERT INTO mfh_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kiya uwaga kà kafàwla kà gəl à ahəŋ kà aŋa lebəŋ aw: Kà uwana lebəŋ uwaga kà, masla la uwana adàf gəl à ahəŋ kà akul, kà uwana ŋgərpa uwana apəhla vok ala kəla mavakay kà aŋa mavakay uwaga pəra.” ");
INSERT INTO mfh_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Kaɗahaw seriya à azladza anik à gəl aw, ŋgaha Zəzagəla aŋa maɗa­ha­kulla seriya à gəl suwaŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kà uwana Zəzagəla adà­ɗa­ha­kulla seriya à gəl, kalkal bokuba uwana kaɗa­hàwwàŋ à azladza anik, adàzəɓay daram uwana kazəɓaw kagu­rawla azladza anik bay! ");
INSERT INTO mfh_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kà mana kanərəzay kəsaf uwana la yewdi aŋa deda aŋak la awtày, ama kak kanəŋa magol tsakuɗ tsakuɗ uwana la aŋak la awtày aw ma? ");
INSERT INTO mfh_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kakay kago­ɗiya à deda aŋak: Sàk à gi, gəzəɓ à ka kəsaf uwaga la adi ala, tsa kak la magol tsakuɗ tsakuɗ la yewdi ma? ");
INSERT INTO mfh_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kak masla magolla dza, zə̀ɓ tsakuɗ tsakuɗ uwaga la adi ala dadàŋ, ŋgaha kadànəŋla lela kà aŋa mazəɓ aŋa deda aŋak!” ");
INSERT INTO mfh_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kavàw tatak tsi­ɗa­ŋaga à azlakəda aw, kà aŋa magolla à akul ala afaɗ à gəl kà makohàh akul ala aw, kafàw slərkodzka aŋkul à azla­namzi aw à huma à gay aŋa mahabəŋ ala aw.” ");
INSERT INTO mfh_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nàvàw ŋgaha kadà­ɓəzawwal; yàhàw ŋgaha kadà­ɓəzawwal, zàlà­hàwwàŋ ŋgaha tadà­pəzl akul gamagày. ");
INSERT INTO mfh_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kəla dza uwana anavay aɓəzal, dza uwana ayahay aɓəzal, ŋgaha dza apəzl gamagày à dza uwana aza­lahay. ");
INSERT INTO mfh_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Dza la ahəŋ la tataka aŋkul av akur à bəzi aŋha à baŋa anaval kà kaf takay? ");
INSERT INTO mfh_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Awma avàl ma bebi à baŋa anaval kà kilfi ay? ");
INSERT INTO mfh_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Iyay, akul azla­ma­wi­siga nəma, ama kasəlaw mavày tatak delga à azlabəza aŋkul, ŋgaha ma asa à məraka Baba aŋkul uwana la zagəla ay? Aɗuwa à akul la mav tatak delga à azladza uwana tanaval tatak!” ");
INSERT INTO mfh_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Uwana asa à akul azladza anik taɗa­ha­kulaŋ kà, akul babay kà ɗahàwwàŋ kiya uwaga à azladza bay suwaŋ, kiya uwaga à uwana mapəhay aŋa Musa apəhay la azla­wa­kità aŋa azlaməna mapəh à atà gay à ahàl là abà kà mapahay à azladza.” ");
INSERT INTO mfh_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Gàw à gay la gamagày slərkuts­kutsga! Kà uwana baŋŋaga uwanay kà, gamagày butu gà, ama adala dza kà à mazila, azladza aŋuvaw la tetəvi uwatà la tsəh. ");
INSERT INTO mfh_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ama slərkuts­kutsga uwanay kà gamagày zla­zla­ɗaga, ama masla la uwana adala dza à sifa à abà, ama azladza kà dəŋ la tetəvi uwatà la ama aw!” ");
INSERT INTO mfh_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ɗahàw haŋkəli kà azlaməna mapəh à atà gay à ahàl fida gà. Kà uwana tatsa à waŋ à slaka aŋkul la mapəhla vok aŋatà ala bokuba azla­tuwaŋ, ama la huɗ gà kà azlakəda fəta. ");
INSERT INTO mfh_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kadàsəlaw atà kà la maɗehəŋ aŋatà la vok. Tadəzl mayyay matavəruk la atàk la vok aw, ŋgaha babay tadəzl gudəv la mazləɓ la vok aw. ");
INSERT INTO mfh_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ahàf delga avày mayyay delga, ahàf mawi­siga avày mayyay mawi­siga babay. ");
INSERT INTO mfh_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ahàf delga aslala vok aŋa mayyi mawi­siga aw, ŋgaha ahàf mawi­siga aslala vok aŋa mayyi delga aw. ");
INSERT INTO mfh_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kəla ahàf uwana ayyi delga aw kà, tahərats à ahəŋ, taduwal à akàl à tsəh. ");
INSERT INTO mfh_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","La kità babay kà, kadàsəlaw azlaməna mapəh à atà gay à ahàl figa gà la maɗehəŋ aŋatà la abà gesina.” ");
INSERT INTO mfh_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Azla­uwana, ‘Sufəl, Sufəl!’, tagoɗ à gi, la uwana tadàda à makoray aŋa Zəzagəla gesin pəra aw, ama azla­uwana taɗehəŋ tatak uwana asa à Baba gulo uwana la zagəla. ");
INSERT INTO mfh_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mok uwana mavakay aŋa seriya adà­zla­ŋalay, aŋuvaw tadàgoɗ à gi ‘Sufəl, Sufəl, la sləm aŋak la uwana məzahà gay Zəzagəla à azladza, la sləm aŋak la uwana məkuɗə̀kàh azla­ma­sasəɗok mawi­siga, la sləm aŋak la uwana məɗa­hàhà azla­na­dzipo aŋuvaw aw uwa?’ ");
INSERT INTO mfh_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kiya uwaga gədàgoɗ à atà: Tetuwa gəsəl akul aw, zàw vok la slaka gulo, akul uwana kaɗahàw tsakana!” ");
INSERT INTO mfh_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Dza uwana atsəna gay uwana gəpə̀h, ŋgaha af uwaga à ahəŋ, masla kà kalkal la dza haŋkəli gà, uwana aŋal gày aŋha à təhus à afik. ");
INSERT INTO mfh_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Iyaw adzəkà masuway, ahənà à mukwà à afik, afaɗ aɗə̀ɗ la ndzəɗa, ama gày akalàh à ahəŋ aw, kà uwana mata­tukway aŋha kà aga kà la təhus la afik. ");
INSERT INTO mfh_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ama kəla dza uwana atsəɓ sləm à gay uwanay gədapəhay la abanay, ŋgaha atsəna uwaga aw kà, gəga­gazləla kà la dza kusoŋu gà, uwana aŋal gày aŋha kà à wuyyaŋ à afik. ");
INSERT INTO mfh_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Iyaw adzəkà masuway, ahənà à mukwà à afik, afaɗ aɗə̀ɗ la ndzəɗa, ŋgaha gày atə̀ɗ à ahəŋ gərim, matəɗ à ahəŋ aŋha kà panàhhà.” ");
INSERT INTO mfh_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Mok uwana Yesu adakəɗ gəl à matapla gay aŋha à azladza kà, maham à ahəŋ dza gesina kà ləv aval à atà à gay, kà tsəhay matapla aŋha uwana atapàtàla. ");
INSERT INTO mfh_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kà uwana masla kà atàpàtàla kà bokuba azlaməna mapàhla wakità seriya aŋatà ala aw, ama apə̀hàtàla kà la maslay aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mok uwana Yesu adasa à ahəŋ la gudəŋ la afik, maham à ahəŋ dza aŋuvaw tanəfà masla. ");
INSERT INTO mfh_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kiya uwaga masla akàl zagəla anik, azà vok à slaka aŋha, akəɗèɗ à huma aŋha la magoɗay: “Məŋga, baŋa asa à ka, kaslala vok mawur gi ala.” ");
INSERT INTO mfh_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu abiyà ahàl ala, adəɓanì, ŋgaha agòɗ: “Asa à gi, wùr ala.” Katskats dza uwaga awur ala la akàl zagəla aŋha la abà. ");
INSERT INTO mfh_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kiya uwaga Yesu agòɗal: “Tsənàŋ lela, kapəh uwaga à dza anik aw. Ama kəla kà, hàd kadàpəhla vok aŋak à masla mav tatak à Zəzagəla, ŋgaha babay kavà tatak uwana Musa apə̀h kà masəlay aŋa azladza gesina kà kawur ala!” ");
INSERT INTO mfh_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mok uwana Yesu adada à Kaper­nahum à abà, məŋga aŋa azla­slodzi dzim aŋa azla Rom la abà, azà vok à slaka aŋha la magoɗay: ");
INSERT INTO mfh_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Məŋga, magamza gulo la slaka mahən à ahəŋ la mtəga, masla maməts à afik gà saŋŋà, ŋgaha as ŋgərpa məŋga məŋga.” ");
INSERT INTO mfh_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu agòɗal: “Gəda à awtày, gədà­wu­rəŋ ala.” ");
INSERT INTO mfh_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ama məŋga aŋa azla­slodzi uwaga awulàlla, agòɗ: “Məŋga, gəsla kà kak aŋa mad à gày gulo aw. Ama pə̀h gay tekula la tsəh ala pəra kà, magamza gulo adàwur ala. ");
INSERT INTO mfh_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gi bay kà, azlaməŋga la ahəŋ lakəl gulo, ŋgaha gi babay, gi lakəl aŋa azla­slodzi anik suwaŋ. Gəslala vok aŋa magoɗay à tekula aŋatà: ‘Hàd kà’, aday. Gəgoɗ à anik aya: ‘Sà à waŋ kà’, atsa à waŋ; ŋgaha gəgoɗ à magamza: ‘Ɗahà uwanay kà’, aɗehəŋ.” ");
INSERT INTO mfh_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Mok uwana Yesu atsə̀n gay uwaga, akə̀sal à gəl kaykay, ŋgaha agòɗ à azla­uwana tanəfay la tsəh: “Haɗay la dziriga gəgoɗ à akul kà: Didi gədanəŋ madiŋal gəl à vok uwanay la tataka azla Isərayel la abà aw. ");
INSERT INTO mfh_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Gəpəh à akul la dziriga kà, azladza aŋuvaw tadàsa à waŋ la mas à afik afats la matəɗ à ahəŋ afats, ŋgaha tadàdzah madzay la tatak may lakəl la azla Abəraham, Isak, Yakuba la makoray Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ama azla­uwana naka tagay azlaaŋa makoray uwaga kà tadàuts atà à mələs à abà la uda, la abatà kà mapaɗ sliɗ la matuway adàgay la ahəŋ aŋa koksi­koksi.” ");
INSERT INTO mfh_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kiya uwaga Yesu agòɗ à məŋga aŋa azla­slodzi: “Dà aŋak à mtəga, uwana kanav la madiŋal gəl à vok adàpaka à ka vok!” Ŋgaha magamza aŋa məŋga aŋa azla­slodzi awùr ala la kaslà uwana: ‘Dà aŋak’, Yesu agòɗal. ");
INSERT INTO mfh_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","La abatà Yesu ahàd à mtəga Səmon Piyer. Aɓə̀z à məŋay aŋa Piyer à gəl, la slaka mahən à ahəŋ, akàl la vok. ");
INSERT INTO mfh_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu adəɓanì la ahàl, ŋgaha akàl vok asàl à vok ala; asà à afik, adzəkà mazlak à atà. ");
INSERT INTO mfh_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mok uwana mokokhu adasa à waŋ tasàhla azlaməna zagəla zagəla aŋuvaw à Yesu à waŋ. La gay aŋha uwana apàh, Yesu akuɗə̀kàh azla­zagəla zagəla gesina, ŋgaha la mawar azlaməna ɗuvats anik anik gesina ala. ");
INSERT INTO mfh_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aɗahàŋ kà aŋa magəɗ gay uwana à afik, masla mapəhal gay à ahàl Yesayya agoɗ: ˈMasla azəɓ maru vok à ahəŋ gami la ɗuvats gami gesina à gəl aŋha.ˈ ");
INSERT INTO mfh_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Uwana Yesu anəŋàŋ kà maham à ahəŋ dza ada­hamal à adi, agòɗ à azlaməna matapla la slaka aŋha kà: “Məhàd à gay dərəv à uda anik.” ");
INSERT INTO mfh_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Masla mapahla mapəhay ala anik, azà vok à slaka aŋha, agòɗal: “Məŋga, à kəla slaka uwana kadàday kà, gədànəf ka.” ");
INSERT INTO mfh_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu awulàlla: “Azla­ma­yaka kà, afək aŋatà la ahəŋ, azla­ɗiyaŋ babay gày aŋatà la ahəŋ, ama Kona aŋa dza kà, bà slaka mahən gəl à ahəŋ aŋha la ahəŋ kà maduw ləv aw.” ");
INSERT INTO mfh_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Dza anik la tataka azlaməna matapla aŋha la abà, agòɗal aya: “Məŋga, và à gi tetəvi kà gi aŋa mal baba gulo dadàŋ.” ");
INSERT INTO mfh_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ama Yesu agòɗal: “Nəfà à gi, ŋgaha sàk azla­ma­zim­nekiɗ talàh vok aŋatà.” ");
INSERT INTO mfh_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu ahàd à kəslah iyaw à afik, azlaməna matapla la slaka aŋha tanə̀fàh. ");
INSERT INTO mfh_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Katskats, magol kular məŋga atsìzlla ala la gəl dərəv tsəràh à uwana magan­tsay aŋa iyaw azà kəslah ala. Ama Yesu kà, adatə̀ɗ à madzehal à abà la godega kəslah iyaw. ");
INSERT INTO mfh_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Azlaməna matapla la slaka aŋha tazà à vok à slaka aŋha, tatsənàŋ ala la magoɗal: “Sufəl, tə̀fà anu, maslà la uwaga məməts à gay!” ");
INSERT INTO mfh_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu awùlla à atà ala: “Kà mana guba azà akul ma? Madiŋal gel à vok aŋkul kà matsi­hila gà.” Ŋgaha atsìzlla ala, aslə̀l məl à kular à gəl, ŋgaha tsiriya, iyaw atsà à ahəŋ titi. ");
INSERT INTO mfh_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ləv avàlàh atà à gay gesina aŋatà, ŋgaha tagòɗ: “Tsəhay dza mana à uwanay à amiyaka kular la iyaw lakəl babay kà atsəna gay aŋha la?” ");
INSERT INTO mfh_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mok uwana Yesu adabez à gay dərəv à uda anik, la kutso aŋa azla Gada­re­niya la abà kà, azladza səla tasà à waŋ kà maga­gamay la masla, azladza uwatà kà tasà à lag kà la zəvay la aku, atà la azla­ma­sasəɗok zagəla zagəla lakəl, azla­mak­sa­fər, bà dza bay kà aslala vok aŋa maguw à awtày la tetəvi uwatà aw. ");
INSERT INTO mfh_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tadzəka mawiyay: “Kona aŋa Zəzagəla, ma kawoyaŋ la slaka gami ma? Kasà à abanay kà mazàh anu ala, tsa kaslà adàslay dadàŋ aw takay?” ");
INSERT INTO mfh_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Maham à ahəŋ namzi la ahəŋ la abatà la gay anik, tayàh huɗ aŋatà à gay. ");
INSERT INTO mfh_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Azla­ma­sasəɗok mawi­siga tadəv kuɗa à Yesu la kiya uwanay, tagòɗal: “Baŋa asa à ka makuɗək anu kà, slə̀l anu à azla­namzi à awtày à gəl zla!” ");
INSERT INTO mfh_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Dàw!”, Yesu agòɗ à atà. Kiya uwaga tasà à azladza səla uwaga lakəl ala, ŋgaha tahàd à azla­namzi uwatà à gəl. Katskats maham à ahəŋ namzi ahòy à ahəŋ la madəguruh la afik, tatsàh gəl à iyaw à abà, tasùfàh à abà. ");
INSERT INTO mfh_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Azlaməna manəŋla azla­namzi tahòy aŋatà à huɗ gudəŋ à abà, ŋgaha tadzəkà mapàh à azladza à gay aŋa tatak uwaga apakà vok gesina, lakəl aŋa azladza səla uwaga la masasəɗok mawi­siga. ");
INSERT INTO mfh_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kiya uwaga azlaməna gudəŋ uwatà gesina tasà à uda kà mad à slaka Yesu. Mok uwana tanəŋàŋ kà, tadəval kuɗa kà maz à vok la kutso aŋatà la abà. ");
INSERT INTO mfh_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","La lig aŋa uwaga la ahəŋ kà, Yesu ahàd à kəslah iyaw à afik, aguwà à uda la dərəv la abà, ŋgaha ahàd à huɗ gudəŋ aŋha à abà. ");
INSERT INTO mfh_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","La abatà tasàlla à waŋ dza makalàh à vəɗah gà la kəslah. Mok uwana Yesu anəŋà madiŋal gəl à vok aŋatà, agòɗ à dza makalàh à vəɗah gà uwaga: “Wàɗ vok à uda bəzi gulo! Tsakana aŋak ada­ma­tsila!” ");
INSERT INTO mfh_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kiya uwana azlaməna mapàhla wakità seriya ala taŋoŋuz la tataka aŋatà la abà, tagòɗ: “Dza uwanay kà, apə̀h mawi­siga lakəl aŋa Zəzagəla, ndzer.” ");
INSERT INTO mfh_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu asə̀l madzugway aŋatà, ŋgaha agòɗ à atà: “Kà mana akul la madzugway mawi­siga kiya uwanay ma? ");
INSERT INTO mfh_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tak ma ŋuləm magoɗay: Tsakana aŋak ada­ma­tsila, awma: Sà à afik, hàd aŋak takay?! ");
INSERT INTO mfh_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ama asa à gi kasəlaw, kà Kona aŋa dza la maslay la gudəŋ uwanay la vok kà mamats tsakana aŋa azladza ala.” Kiya uwaga agòɗ à dza makalàh à vəɗah gà uwaga: “Sà à afik, zə̀ɓ kəslah aŋak, kadà aŋak à mtəga!” ");
INSERT INTO mfh_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Zil uwaga asà à afik ahàd aŋha à mtəga. ");
INSERT INTO mfh_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mok uwana maham à ahəŋ dza adanəŋ uwaga kà, ləv avàl atà à gay kaykay, ŋgaha tazləɓà Zəzagəla kà ndzəɗa uwaga avà à azladza. ");
INSERT INTO mfh_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu atsìzlla ala la abatà, mok uwana aday kərkər kà anəŋà dza anik uwana sləm aŋha Mata la gày mazəɓ hadama la aku, agòɗal: “Nəfà à gi!”. Mata asà à afik anəfà masla. ");
INSERT INTO mfh_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mok uwana Yesu adadza à tatak may à adi la mtəga Mata la azlaməna matapla la slaka aŋha kà, azlaməna mazəɓ hadama, la azladza uwana tetəvi aŋatà delga aw, la azlaməna tsakana tasà à waŋ, tadzàh à tatak may à gəl atà nna. ");
INSERT INTO mfh_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Uwana azla Farisəya tanə̀ŋ uwaga, tagòɗ à azlaməna matapla la slaka aŋha: “Kà mana məŋga aŋkul azuw tatak may la azlaməna mazəɓ hadama la azladza uwana tetəvi aŋatà kà delga aw ma?” ");
INSERT INTO mfh_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Uwana Yesu atsənà uwaga kà, agòɗ à atà: “Azladza uwana ɗuvats az atà aw kà, tayàh dokwtar aw, say azlaməna ɗuvats la uwana tayahay pəra. ");
INSERT INTO mfh_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Dàw, kata­pawla uwana matse­tseray gà la wakità la abà: ˈGəwoyaŋ kà dziriga, awkà makaɗ à gi tatak awˈ kà uwana gəsà à waŋ kà mayahay kà azladza uwana: ‘Anu azla­dzi­riga’ tagoɗ aw, ama azla­uwana: ‘Anu azlaməna tsakana’, tagoɗ.” ");
INSERT INTO mfh_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Azlaməna matapla la slaka Yuhana masla maɗàh batem tazà à vok à slaka Yesu, ŋgaha tagòɗal: “Kà mana anu la azla Farisəya kà məkàsàh nəlay, tsa azlaməna matapla la slaka aŋak kà takasàh nəlay aw ma?” ");
INSERT INTO mfh_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu awùlla atà ala: “Kadzugwaw ma azladza uwana tazàla atà à mazəɓ vok à abà, takəs nəlay, la kaslà uwana masla mazəɓ mis la tataka aŋatà la abà takay? Awaŋ! Ama kaslà adàsa à waŋ à uwana masla mazəɓ mis adàgay la tataka aŋatà la abà aya aw kà, la mok uwaga la uwana tadàkəs nəlay suwaŋ.” ");
INSERT INTO mfh_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Dza aslala vok aŋa matsap à lukut mavi­yaga à lukut mawga à vok aw, kà uwana lukut mawga uwaga adàkwoh mavi­yaga uwaga à tsəh kaykay aya. ");
INSERT INTO mfh_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ŋgaha babay kà, taɗaw iyaw matavəruk mawga à kiwa iyaw mavi­yaga à agu aw, kà uwana iyaw matavəruk mawga adàsləh kiwa iyaw mavi­yaga ala, say taɗaw iyaw matavəruk mawga kà à kiwa iyaw mawga à agu suwaŋ, ŋgaha kiwa iyaw aŋa makəs iyaw matavəruk uwaga lela.” ");
INSERT INTO mfh_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mok uwana Yesu apə̀h à atà gay uwaga, məŋga anik la tataka azla Yahu­diya la abà asà à wan, akədèɗ à Yesu à huma la magoɗal: “Dugu gulo adamətsay bà lagonay, sà à waŋ, ɓə̀kal ahàl aŋak à vok, ŋgaha adàdza à ahəŋ la sifa aya!” ");
INSERT INTO mfh_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu asà à afik tanəfà atà la azlaməna matapla la slaka aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mis anik la ahəŋ aŋiz akə̀lal à tsəh ala, dagay mavay kulo gel aŋha səla, agoɓà à awtày la lig aŋa Yesu adəɓanì gay lukut aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kà uwana agòɗ la gəl aŋha kà: ‘Baŋa gədəbani bà gay lukut aŋha pəra kà, gədàwur ala.’ ");
INSERT INTO mfh_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu agolà vok anə̀ŋal à adi, agòɗal: “Wàɗ vok à uda dugu gulo, kà uwana madiŋal gəl à vok aŋak awùr ka ala”, bà la kaslà uwatà, mis uwaga awùr ala. ");
INSERT INTO mfh_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Uwana Yesu abə̀z à mtəga ana məŋga uwatà, anəŋà azlaməna mats segəla, la azlaməna mataway gesina ");
INSERT INTO mfh_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ŋgaha agòɗ à atà: “Dàw à uda, dugu kà adamətsay aw, adzehal pəra.” “Uwàà...”, takəɗàslal. ");
INSERT INTO mfh_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Uwana takuɗə̀kàh maham à ahəŋ dza à uda kà, Yesu ahàd à gày uwatà à agu, akə̀s bəzi dugu la ahàl, atsənàŋ ala ŋgaha asà à afik. ");
INSERT INTO mfh_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Gay uwatà atsàn la kutso uwatà la abà gesina. ");
INSERT INTO mfh_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu atsìzlla ala la abatà adà aŋha, uwana adà aŋha kà, azla­gu­ləf səla tanəfà la tsəh la mawiyay: “Kona aŋa David, Kona aŋa David, vok ahama ka kà anu!” ");
INSERT INTO mfh_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Mok uwana Yesu adabəz à mtəga kà, azla­gu­ləf səla uwaga tazà à vok à slaka aŋha, ŋgaha agòɗ à atà: “Kadi­ŋawwal gəl à vok kà gəslala vok gəɗàh uwaga ay?” “Iyay, məŋga gami, mədiŋal gəl à vok kà kak la ndzəɗa.” ");
INSERT INTO mfh_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kiya uwaga Yesu adəɓanì yewdi aŋatà la magoɗ à atà: “Delga, uwaga akəs akul à vok bokuba uwana kadi­ŋawal gəl à vok.” ");
INSERT INTO mfh_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ŋgaha yewdi aŋatà apàzlla à ama ala adagay. Yesu afàhà à atà akur à lig, agòɗ à atà: “Tsənàwwàŋ lela, kapəhaw uwaga à dza anik aw.” ");
INSERT INTO mfh_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ama tahàd, tazàhà tatak uwana Yesu aɗa­hàtàŋ la kutso uwatà la abà gesina. ");
INSERT INTO mfh_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mok uwana Yesu ada­tsizlla ala adìy aŋha kà, tasə̀lla dza anik uwana à waŋ, aslàla vok kà maɓaɗma aw, ŋgaha aya kà, aga la masasəɗok mawi­siga. ");
INSERT INTO mfh_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Uwana Yesu ada­ku­ɗə̀k masasəɗok uwaga kà, dza badaga uwaga adzəkà maɓaɗma. Ləv avàlàh à maham à ahəŋ dza à gay gesina, ŋgaha tagòɗ: “Didi, didi mədanəŋ dzəɓa gà uwanay la Isərayel aw!” ");
INSERT INTO mfh_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ama azla Farisəya tagòɗ kà: “Sufəl aŋa azla­ma­sasəɗok mawi­siga la uwana avàl maslay kà makuɗəkàh azla­ma­sasəɗok mawi­siga uwaga!” ");
INSERT INTO mfh_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu augu­zàhàh la azlahuɗ gudəŋ la abà, la azlabəza gudəŋ gesina, atapàhàtàla la azlagày madəv kuɗa aŋatà la aku, azà gay marabəŋ aŋa makoray Zəzagəla, la mawar azlaməna ɗuvats ala gesina, amiyaka tsəhay gà uwala beyli, ŋgaha la azlaməna takàlàh à vəɗah gesina. ");
INSERT INTO mfh_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Vok ahamà à Yesu kà maham à ahəŋ dza uwana tayahay, kà uwana azladza uwatà tayàh vok adagay, ŋgaha bokuba azla­tuwaŋ uwana masla manəŋla atà la ahəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kiya uwaga agòɗ à azlaməna matapla la slaka aŋha: “Matsəɗ tatak la ahəŋ məŋga, ama azlaməna sləray kà atà dəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kiya uwaga kà: Də̀vàw kuɗa à dza aŋa tatak, kà masla aŋa masləl azlaməna sləray à waŋ kà matsəɗal tatak aŋha!” ");
INSERT INTO mfh_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu azàl azlaməna matapla la slaka aŋha kulo gəl aŋha səla uwatà, ŋgaha avà à atà ndzəɗa à ahàl kà makuɗəkàh azla­ma­sasəɗok mawi­siga la mawar azlatsəhay ɗuvats anik anik ala, ŋgaha la azla­uwana takàlàh à vəɗah gesina. ");
INSERT INTO mfh_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aganay sləm aŋa azlaməna matapla kulo gəl aŋha səla uwatà la slaka Yesu. Teraŋa dadàŋ kà Səmon uwana tazàllala Piyer, atà la deda aŋha Andəre; Yakuba bəzi aŋa Zebede atà la deda aŋha Yuhana; ");
INSERT INTO mfh_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip atà la Barte­lemi; Tomas atà la Mata, masla mazəɓ hadama; Yakuba, kona aŋa Alfe atà la Tade; ");
INSERT INTO mfh_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Səmon uwana tazàlal ala Zəlot atà la Yudas Iska­riyot, masla uwana adàta kaf à Yesu à gəl. ");
INSERT INTO mfh_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu aslə̀l azlaməna matapla kulo gəl aŋha səla uwaga la mapəh à atà gay uwanay à vok à abà: “Gudəŋ uwana azla Yahu­diya tadza à ahəŋ la abà aw kà, kadaw à abà aw, kadàw à gudəŋ aŋa Sama­riya à abà babay aw. ");
INSERT INTO mfh_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ama dàw kà à tataka azla­tuwaŋ mazeh­laga à abà la tsəhay Isərayel pəra. ");
INSERT INTO mfh_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","La tetəvi aŋkul la ama kà, zàw sayda, gòɗàw kà: ‘Makoray Zəzagəla kà nekwa atsa à waŋ.’ ");
INSERT INTO mfh_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Wàràw azlaməna ɗuvats ala, wàlàwla azla­ma­zim­nekiɗ à uda, wàràw azlaməna akàl zagəla ala, kuɗə̀kàhàw azla­ma­sasəɗok mawi­siga. Kaɓəzaw à uwaga kà deyday, vàw à atà deyday suwaŋ. ");
INSERT INTO mfh_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kazəɓaw luwà­luwà à ahàl baŋaw gursu, baŋaw sili la zliba la aku aw. ");
INSERT INTO mfh_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Amiyaka kiwa, amiyaka matsəp lukut, amiyaka kwimik, bà amiyaka agəla kà aŋa mau­gu­zahay aŋkul aw. Kà uwana azlayla kà vok, kà masla sləray kà azlayla vok azuw tatak may!” ");
INSERT INTO mfh_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Mok uwana kadàbəzaw azlaməŋ gudəŋ à abà baŋaw azlabəza gudəŋ à abà, yàhàw kà dza uwana akəs akul la ahàl səla, ŋgaha dzàw à ahəŋ la mtəga aŋha tsəràh à uwana katsaw à uda la gudəŋ uwatà la abà. ");
INSERT INTO mfh_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mok uwana kadaw à gày, gòɗàw dadàŋ teraŋa kà: ‘Lapiya agay la akul.’ ");
INSERT INTO mfh_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Baŋa azlaməna huɗ gày uwatà takəs akul la ahàl səla kà, ‘Ayyi’ aŋa lapiya aŋkul uwana kaɗa­hàw­wàtàŋ kà, adza à ahəŋ lakəl aŋatà, ama baŋa takəs akul aw kà, wùllàw ‘Ayyi’ aŋa lapiya aŋkul à tsəh la slaka aŋatà. ");
INSERT INTO mfh_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Baŋa la huɗ gày anik baŋaw la gudəŋ anik la abà, takweska akul aŋa makəs akul baŋaw aŋa matsəɓ akul sləm kà, dàw aŋkul la abatà, dèɗàw à atà à adi burburu aŋa kutso aŋa gudəŋ aŋatà uwana agàɗ à akul à asik. ");
INSERT INTO mfh_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","La dziriga gəpəh à akul: La vuɗ seriya kà ŋuləm kà aŋa azlaməna gudəŋ Sodom la Gomor kà azlaməna gudəŋ uwaga.” ");
INSERT INTO mfh_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Lagwa kà, aganay gəsləl akul bokuba akul azla­tuwaŋ, à tataka azlakəda fəta à abà. Kiya uwaga kà, gàw mahanay gà bokuba azla­bebi, gəgoɗ à akul, ŋgaha gàw tələmma bokuba akul azla­ha­ba­koku. ");
INSERT INTO mfh_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ɗahàw haŋkəli kà uwana azladza tadà­ɗahla akul à huma seriya, ŋgaha tadà­zlaɓàh akul la kurpi la gày madəv kuɗa aŋatà la aku. ");
INSERT INTO mfh_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tadà­pahla akul ala la huma aŋa azlaməna makoray ŋgaha la huma aŋa azla­su­fəl, kà uwana kawoyàw gi, kà akul aŋa maz sayda gulo la huma aŋatà, ŋgaha la huma aŋa azla­uwana azla Yahu­diya aw. ");
INSERT INTO mfh_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mok uwana tadàdala akul à huma seriya kà, kadà­dzugwaw lakəl aŋa uwana kadàpəhaw aw, la uwana kadà­wulawla à uda, gay uwana kadà­wulawla à uda kà, adàda à paŋaw aŋkul à awtày la kaslà uwatà. ");
INSERT INTO mfh_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Gay uwaga kà adàgay kà madzugway aŋkul aw, ama Masasəɗok aŋa Baba aŋkul Zəzagəla la uwana adà­guway la akul la abà la kaslà uwatà.” ");
INSERT INTO mfh_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Deda adàvà deda aŋa aslasl gəl aŋha kà makaɗay, baba bay adà­ɗe­həŋ kiya uwaga la bəzi aŋha; azlabəza babay tadà­gola afaɗ à azla­baba aŋatà à gəl kà makaɗ atà. ");
INSERT INTO mfh_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Azladza gesina tadà­pəsew akul kà uwana kawoyaw gi. Ama dza uwana adàgəɗ dziriga à afik tsəràh à makəɗ gəl à ahəŋ kà adàɓəlay. ");
INSERT INTO mfh_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Baŋa tatərəɓ akul la gudəŋ anik la abà, hòyàw à huɗ gudəŋ anik à abà. La dziriga gəpəh à akul: Kadàdəvaw mau­gu­zahay à gay la gudəŋ Isərayel gesina dadàŋ kà mas à waŋ aŋa Kona aŋa Zəzagəla aw.” ");
INSERT INTO mfh_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Masla asik aɗuw məŋga aŋha tetuwa aw, magamza aɗuw dza uwana aɗahalla sləray aw. ");
INSERT INTO mfh_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Say aslay kà masla asik apakay bokuba məŋga aŋha la masəlay dàŋ, ŋgaha magamza agay bokuba məŋga aŋha dàŋ. Baŋa tazàla à zil gày Bel­zəbul kà, sləm uwana tadàv à azlaməna huɗ gày kà adàgay delga aw aɗaɗuwa à gay aŋa zil gày la mawi­siga.” ");
INSERT INTO mfh_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Guba akəs akul kà azladza asik zlà ma aw. Tatak mahaɗ à ahəŋ gà gesina adàgay mapəhla vok ala gà, ŋgaha tatak nasiri gà gesina adàgay masəlay gà la dazu­waya. ");
INSERT INTO mfh_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kəla tatak uwana gəpəhakulla la mələs la abà, pə̀hàw uwaga la uɗaka ala; ŋgaha tatak uwana katsənawwaŋ la à gəl à gəl kà, dàw kà wiyawla la gay zaŋ. ");
INSERT INTO mfh_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Guba akəs akul kà azla­uwana takəɗ sləɓ vok aw, kà uwana taslala vok aŋa makəɗ dokvadzi aŋa sifa aw, guba akəs akul kà, kà Zəzagəla uwana aslala vok aŋa maduw dokvadzi la sifa la sləɓ vok gesina à gày akàl à abà. ");
INSERT INTO mfh_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Taslala vok aŋa maduw dəgtsetsek səla ala kà aŋa sili tekula aw takay? Amiyaka tekula aŋatà azila la masəlay aŋa Baba aw kà aga la ahəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Amiyaka aŋidz taka­sa­gəl aŋkul gesina kà, Zəzagəla asəl la tekula tekula gesina aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Tsa kità kà, guba akəs akul aw, kà uwana akul kaɗuwaw azla­dəgtsetsek uwaga gesina la manəŋ akul à adi.” ");
INSERT INTO mfh_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Baŋa dza apəhla gi ala la huma azladza la dazu­waya kà, gi babay gədàpəhla masla ala la huma aŋa Baba gulo, uwana la zagəla la afik: Masla kà aŋulo, gədà­goɗay. ");
INSERT INTO mfh_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ama baŋa dza agəɗəŋ à afik kà asəl gi aw la dazu­waya la huma azladza kà, gi babay gədà­gəɗəŋ à afik la dazu­waya la huma Baba gulo kà: Gəsəl masla aw, gədà­goɗay bay, suwaŋ.” ");
INSERT INTO mfh_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Iyay, kadzugwaw kà lapiya la uwana gəsə̀lla à gudəŋ à vok, kagoɗaw aw: Gəsə̀lla lapiya à waŋ aw ama mavàhla. ");
INSERT INTO mfh_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Gəsà à waŋ kà masàh gəl à azlabəza zil gà à vok la azla­baba aŋatà, azladəgam à vok la azlaiyà aŋatà, ŋgaha azlamis à vok la azla­dzedzi aŋatà. ");
INSERT INTO mfh_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mazan vok à gəl adàgay la tataka azlaməna huɗ gày la abà.” ");
INSERT INTO mfh_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Dza uwana awoya baba aŋha baŋaw iyà aŋha kà gi kaykay kà, akə̀s gi vok aw, dza uwana awoya bəzi aŋha zilga baŋaw dugu aŋha gà kaykay kà gi kà, akə̀s gi vok aw. ");
INSERT INTO mfh_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Dza uwana akəs maməts à ahàf à adi aŋha, ŋgaha anəf gi aw kà, masla akəs gi vok aw. ");
INSERT INTO mfh_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kəla dza uwana asal matuw sifa aŋha, adàziŋ ala; ama dza uwana atuw sifa aŋha aw kà gi kà, adàɓəzal.” ");
INSERT INTO mfh_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Dza uwana akəs akul kà, akəs gi babay, ŋgaha dza uwana akəs gi, akəs dza uwana aslə̀l gi à waŋ babay. ");
INSERT INTO mfh_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dza uwana akəs masla mapəhal gay à ahàl aŋa Zəzagəla, à kà uwana masla mapəhal gay à ahàl aŋha kà, adàɓəz masik uwana maf à ahəŋ gà kà aŋa azlaməna mapəh à atà gay à ahàl, ŋgaha dza uwana akəs dza dziriga la huma aŋa Zəzagəla, kà uwana masla dziriga la huma aŋha, adàɓəz masik uwana maf à ahəŋ gà kà aŋa azladza dziriga. ");
INSERT INTO mfh_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Haɗay, gəpəh à akul la dziriga: Kela dza uwana atəɗ iyaw mataslay gà à tekula la tataka azlabəza uwanay la abà, à kà uwana masla matapla la slaka gulo kà, adàɓəz masik aŋha.” ");
INSERT INTO mfh_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mok uwana Yesu adadəv mapàhla à tatak azlaməna matapla la slaka aŋha kulo gəl aŋha səla uwaga, atsìzlla ala la slaka uwatà kà mad matapla tatak à azladza la azlahuɗ gudəŋ la kutso uwatà la abà. ");
INSERT INTO mfh_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Mok uwatà kà Yuhana masla maɗàh batem kà, agà la daŋay. Uwana atsənà gay aŋa sləray aŋa Yesu Kristu, aslə̀l azlaməna matapla azlaanik aŋha à slaka Yesu ");
INSERT INTO mfh_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kà manaval à gay ala: “Kak dza uwana məkuday awma kak dza anik kəla ay?” ");
INSERT INTO mfh_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu agòɗ à atà: “Dàw, kadàpəhaw Yuhana à tatak uwana katsənàwwàŋ la uwana kanəŋàwwàŋ gesina: ");
INSERT INTO mfh_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Azla­gu­ləf tanəŋla, azla­deri taday, azlaməna akàl zagəla tawarla, azla­ma­da­gazlam bay tatsən sləm, azla­ma­zim­nekiɗ tawal à uda, azlaməna kuɗa babay tatsən gay marabay. ");
INSERT INTO mfh_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Marabay agay la azladza uwana tasak à madiŋ gi gəl à vok aw.” ");
INSERT INTO mfh_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mok uwana azlaməna matapla aŋa Yuhana tadìy aŋatà, Yesu adzəkà mapəhay à maham à ahəŋ dza lakəl aŋa Yuhana la magoɗay: “Mana à uwana kadàw kà mayahay la kəsaf la abà ma, mazuwa uwana afaɗ abəla­kəŋ ay? Awaŋ, uwaga aw. ");
INSERT INTO mfh_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kətà zla, mana kadàw kà aŋa manəŋəŋ ma? Awma dza uwana atsàkw à lukut mahəɗayga à abà kəla ay? Ama azla­uwana tatsəkwàh à lukut mahəɗayga à abà kà, atà kà la huɗ gày sufəl. ");
INSERT INTO mfh_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mana kadàw kà aŋa manəŋəŋ ma? Masla mapəhal gay à ahàl aŋa Zəzagəla kəla ay? La kità kà, gəgoɗ à akul kà, Yuhana aɗuwa masla mapəhal gay à ahàl, ");
INSERT INTO mfh_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","kà uwana tatsetsèr lakəl aŋha: ˈAganay, gəsləl à awtày masləlay gulo à huma aŋakˈ Zəzagəla agòɗ, ˈKà maɗàh tetəvi à ahəŋ.ˈ ");
INSERT INTO mfh_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","La dziriga gəpəh à akul: La tataka azladza asik la abà kà, dza mayyayga la ahəŋ aɗuw Yuhana masla maɗàh batem uwanay aw, te­ke­ɗika, dza uwana mabəziga bəziga la makoray Zəzagəla kà, aɗuwa Yuhana uwaga. ");
INSERT INTO mfh_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Dagay la mok uwana Yuhana masla maɗàh batem azà sayda tsəràh à lakana, kà taɗàh gasa à makoray Zəzagəla à gəl, ŋgaha azlaməna məzam tayahay kà mazəɓay lakana. ");
INSERT INTO mfh_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Azlaməna mapəh à atà gay à ahàl gesina la mapəhay aŋa Musa tapàh gay lakəl aŋa makoray Zəzagəla tsəràh à mas à waŋ aŋa Yuhana, masla maɗàh batem. ");
INSERT INTO mfh_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Baŋa asa à akul kà madiŋ gi gəl à vok kà, Yuhana kà Eliya uwana wakità apəhla mas à waŋ aŋha ala dagay uwarà. ");
INSERT INTO mfh_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Dza uwana sləm lakəl kà, atsəɓal sləm lela!” ");
INSERT INTO mfh_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yesu agòɗ aya: “Ma la mana lagwa gəga­gazləla azladza aŋa zamana uwanay lakana ma? Gəga­gazləla atà la azlabəza uwana tadzàh madzay la vada­vaday kasukwa la afik, tazàlàh vok kà atà kà atà, ");
INSERT INTO mfh_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","la magoɗay, anu mətsà à akul talakway, ama akul kahà­bàwwal à tsəh aw, məhàb à akul dəs kuɗa, ama katàwàw la mats hulolo aw. ");
INSERT INTO mfh_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","La kità Yuhana asà à waŋ, azùw aw, asà aw, ŋgaha azladza tagòɗ kà: ‘Masla la masasəɗok mawi­siga.’ ");
INSERT INTO mfh_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kità aya babay kà, Kona aŋa dza asà à waŋ, azuway, asay, ŋgaha azladza tagoɗ kà: ‘Nərə̀zàw dza uwanay tsi, masla huɗ. Afa sləm à kà à mazuway la masay aŋha pəra’, tagòɗ. ‘Kafaw masla kà à tataka aŋa azlaməna mazəɓ hadama à abà, la azlaməna tsakana, ŋgaha la azladza uwana madz à ahəŋ aŋatà kà lela aw.’ Ama te­ke­ɗika matsi­hila aŋa Zəzagəla apəhla vok ala la sləray aŋha la abà.” ");
INSERT INTO mfh_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kiya uwaga Yesu adzəkà maslàh məl à azla­gu­dəŋ uwana à gəl, aɗahàhà azla­na­dzipo kaykay gà la abà, kà uwana azlaməna madz à ahəŋ la abà kà tapəh gay la ləv ala aw. ");
INSERT INTO mfh_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Agòɗ: “Ŋgərpa lakəl aŋak à kak Korazən! Ŋgərpa lakəl aŋak à kak Be­tsayda! Kà uwana agay nadzipo uwana aɗahà à ahəŋ la tataka aŋkul la abà, agay kà la gudəŋ Tir la Sədon kà, naka dagay uwarà azlaməna madz à ahəŋ la abà kà, tatsàh kutso akàl à vok ŋgaha la madaw abuh à vok, kà mapəhla ala kà atà tapə̀h gay la ləv ala. ");
INSERT INTO mfh_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kà uwaga à uwana gəgoɗ à akul kà: La vuɗ seriya kà, seriya uwana adàɓəz azlaməna gudəŋ Tir, la azlaməna gudəŋ Sədon kà ŋuləm kà aŋatà à kà aŋa gudəŋ aŋkul. ");
INSERT INTO mfh_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ŋgaha kak Kaper­nahum kadzugw kà: ‘Gədà­zigənay tsəràh à zagəla,’ kagòɗ takay? Awaŋ, tadà­dukwa ka à vəɗah à gày akàl à abà, kà uwana azla­na­dzipo uwana aɗa­hàhàŋ la kak la abà, agay la Sodom kà, naka gudəŋ uwatà kà agay la ahəŋ tsəràh à lakana. ");
INSERT INTO mfh_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kiya uwaga kà, gəpəh à akul kà la vuɗ seriya kà, azlaməna Sodom tadàgay ŋuləm kà kak.” ");
INSERT INTO mfh_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","La mok uwatà Yesu agòɗ: “Iyay Baba, Sufəl ana zagəla ŋgaha aŋa vəɗah, ‘Kikay’, gəgoɗ à ka, kà uwana kafatə̀la à azla­be­zaga la à ama ala tatak nasiri gà uwana kahàɗ à azlaməna masəl tatak uwana à adi, ‘Mədawur gəl’, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iyay, Baba gəzləɓ ka kà uwaga.” ");
INSERT INTO mfh_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Baba gulo aɓək à gi tatak gesina. Dza la ahəŋ asəl Kona aw, say Baba pəra asəl gi, dza la ahəŋ asəl Baba aw, say gi Kona aŋha pəra, ŋgaha la azla­uwana Kona apəhatàla Baba aŋha pəra.” ");
INSERT INTO mfh_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Sàw à waŋ à slaka gulo akul gesina, akul uwana kayàw vok la mazəɓ mahanay, gədàvà à akul maduw ləv. ");
INSERT INTO mfh_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Zə̀ɓàw zeləŋ zukw kuda gulo, ŋgaha kə̀sàw matapla gulo, kà uwana gi kà gi dzaŋ­dzaŋ aw, gi tələmma, ŋgaha kadàɓəzaw maduw ləv aŋa ləv aŋkul. ");
INSERT INTO mfh_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kà uwana zukw kuda uwana asa à gi mav à akul kà zla­zlaɗa kà mazəɓay aw, mahanay uwana gədàfa à akul à gəl babay kà tsaf­tsaf.” ");
INSERT INTO mfh_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mok uwana uwaga adadà à lig kà, Yesu la azlaməna matapla la slaka aŋha tagùw à uda la guf nalkama la abà, (uwana bokuba hi), la vuɗ maduw ləv. Azlaməna matapla la slaka aŋha uwaga kà may akəs atà, tadzəka makalay kà mazuway. ");
INSERT INTO mfh_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Uwana azla Farisəya tanəŋà uwaga kà, tagòɗ à Yesu: “Nerə̀z, azlaməna matapla la slaka aŋak taɗàh tatak uwana mapəhay gami avərà gay kà maɗehəŋ la vuɗ maduw ləv tsi!” ");
INSERT INTO mfh_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu awùlla atà ala: “Kadzèŋàw à tatak uwana David aɗahàŋ vərdi anik la mok uwana may akə̀s la azlaməna aŋha aw uwà? ");
INSERT INTO mfh_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ahàd à gày Zəzagəla à agu, kà mazəɓ tatak may tsi­kaslaga uwana maf à ahəŋ gà. Te­ke­ɗika tetəvi la ahəŋ kà mazuway aŋha aw, baməraka azla­ma­nalay aŋha babay aw, say à azlaməna mav tatak à Zəzagəla pəra, la uwana tetəvi la ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Awma kadzèŋàw la mapəhay aŋa Musa la abà kà, azlaməna mav tatak à Zəzagəla taɗàh sləray la gày Zəzagəla la aku amiyaka la vuɗ maduw ləv, ŋgaha tatugw mawi­siga lakəl aŋatà aw kà, kasəlaw aw takay? ");
INSERT INTO mfh_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","La dziriga gəpəh à akul kà, dza uwana aɗuwa məŋ gày Zəzagəla uwaga kà aga la abanay. ");
INSERT INTO mfh_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Agayŋa kasəlaw, uwana matse­tseray uwanay asal magoɗay kà: ˈVok mahamay la uwana asa à agi, awkà tatak makaɗay gà awˈ, naka kadùkwàw seriya à azladza uwana à gəl, atà kokuɗa tsakana aw. ");
INSERT INTO mfh_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kà uwana Kona aŋa dza kà masla la uwana məŋga aŋa vuɗ maduw ləv.” ");
INSERT INTO mfh_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu atsìzlla ala la abatà, azà à vok, ahàd à gày madəv kuɗa aŋatà à agu. ");
INSERT INTO mfh_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Dza anik la ahəŋ la abatà, uwana agà la ahàl mamətsayga. Azladza uwana la gày uwatà la aku tanàvà à Yesu: “Mapəhay gami ma avà tetəvi kà mawur dza ala, la vuɗ maduw ləv takay?”, kà atà aŋa maɓəzal à tsəh kà mapuwal gudzi à gəl. ");
INSERT INTO mfh_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ama Yesu awùlla atà ala: “Baŋa dza la ahəŋ la tataka aŋkul la abà la tuwaŋ tekula pəra, ŋgaha tuwaŋ uwaga atəɗ à suwa à abà la vuɗ maduw ləv, ma aday kà mazəɓ à uda la abà aw takay? ");
INSERT INTO mfh_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ŋgaha dza ndzer, ma aɗuwa tuwaŋ aw takay? Kà uwaga à uwana mapəhay gami avà tetəvi à dza kà maɗàh delga la vuɗ maduw ləv.” ");
INSERT INTO mfh_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kiya uwaga Yesu agòɗ à dza uwatà: “Biyà ahàl ala!” Abiyà ahàl ala, ŋgaha ahàl aŋha ada­wurla bokuba anik uwahà. ");
INSERT INTO mfh_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Azla Farisəya tadà aŋatà, takə̀s sawaray kà maɓəz tetəvi kà makəɗla Yesu. ");
INSERT INTO mfh_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mok uwana Yesu atsənà uwaga kà, asà à uda la slaka uwatà la abà, ŋgaha maham à ahəŋ dza aŋuvaw tanəfà. Awarà azlaməna ɗuvats ala gesina. ");
INSERT INTO mfh_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ama afàh à atà akur à lig la ndzəɗa kà atà aŋa mapəh uwana apakà vok aw. ");
INSERT INTO mfh_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aɗahàŋ kiya uwanay kà, kà gay aŋa masla mapəhal gay à ahàl Yesayya aŋa magəɗ à afik. ");
INSERT INTO mfh_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Zəzagəla agòɗ: ˈA aganay masla sləray gulo uwana gəkə̀sànì, Uwana gəwoyàŋ ŋgaha marabay gulo lakəl aŋha. Gədà­sləl Masasəɗok gulo à gəl aŋha, Ŋgaha adàz gay seriya gulo à azlatsəhay gudəŋ à vok gesina. ");
INSERT INTO mfh_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Masla adà­gazlay la dza aw, adà­wiyay aw, Ŋgaha dza adàtsən mawiyay aŋha la azla­tetəvi la ama aw. ");
INSERT INTO mfh_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Adà­davla à gay à mazuwa manəlfa­hayga à vok aw, Ŋgaha akàl fənəs uwana atəm à ahəŋ ŋuliza bay kà, adà­dəvla à gay à vok aw. Masla adàdz à ahəŋ kiya uwanay tsəràh à maɗàh dziriga à gudəŋ à vok gesina. ");
INSERT INTO mfh_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Azlatsəhay gudəŋ à vok gesina tadàf manəwəŋ aŋatà à masla à afikˈ, agòɗ aya. ");
INSERT INTO mfh_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kiya uwaga la abatà tasəlà dza à Yesu à waŋ, guləf badaga, la masasəɗok mawi­siga lakəl. Yesu awurà dza uwatà ala tsəràh à uwana dza aslala vok aŋa maɓaɗma, ŋgaha la manəŋla. ");
INSERT INTO mfh_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ləv avàlàh à maham à ahəŋ dza à gay gesina, ŋgaha tagòɗ: “Masla kà Kona aŋa David təga aw ay?” ");
INSERT INTO mfh_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ama uwana azla Farisəya tatsənà uwaga kà, tagòɗ: “Kona uwaga aku­ɗəkahay azla­ma­sasəɗok mawi­siga kà, kà uwana Bel­zəbul, sufəl aŋa seteni avàl ndzəɗa kà maku­ɗəkàhla.” ");
INSERT INTO mfh_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ama Yesu asə̀l madzugway aŋatà ŋgaha agòɗ à atà: “Baŋa azladza gudəŋ tekula tatsàkla, ŋgaha guvəl la tataka aŋatà la abà, makoray aŋa gudəŋ uwatà kà azila. Huɗ gudəŋ, baŋaw huɗ gày, uwana tap guvəl la tataka aŋatà la abà, aslala vok aŋa madz à ahəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Baŋa seteni akuɗək seteni, masla la gəl aŋha ada­tsakla, ma kakay à makoray aŋha adàdza à ahəŋ ma? ");
INSERT INTO mfh_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Iyay, akul kadzugwaw kà Bel­zəbul la uwana avà à gi ndzəɗa kà makuɗəkàh azla­ma­sasəɗok mawi­siga uwaga, kagoɗaw. Kità ma, uwa adav ndzəɗa à azlabəza aŋkul kà maku­ɗəkahay uwa? Kà uwaga à uwana tadàgah azlaməna seriya aŋkul. ");
INSERT INTO mfh_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ama tsa baŋa la Masasəɗok Zəzagəla la uwana gəkuɗə̀kàh azla­ma­sasəɗok mawi­siga uwanay kà, tsa kətà kà, gòɗàw kà makoray aŋa Zəzagəla kà adaɓəz akul à vok lakana, gòɗàw zla.” ");
INSERT INTO mfh_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Dza la ahəŋ ad à gày la mtəga aŋa dza ndzəɗa-ndzəɗaga kà mad à gəl aw, say atsà à vok à abà, akə̀s dza uwaga, awaɗəŋ dàŋ, ŋgaha la lig la ahəŋ aslala vok aŋa mazuw gày aŋha à gay.” ");
INSERT INTO mfh_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Dza uwana anu səla aw kà, masla məzam gulo. Ŋgaha babay kà dza uwana azlak gi kà maham ala gay à vok aw kà, masla kà masla madà­dasiŋ ala. ");
INSERT INTO mfh_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kà uwaga gəgoɗ à akul haɗay kà: Maham à ahəŋ tsakana la azlagay mawi­siga aŋa azladza gesina kà agay mama­tsi­la gà, ama kəla kà, dza uwana apəh mawi­siga la matsək mago­ɗahay à Masasəɗok Zəzagəla à gəl kà, masla kà, aɓəz mama­tsila aŋa tsakana aw. ");
INSERT INTO mfh_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kəla dza uwana apəh mawi­siga lakəl aŋa Kona aŋa dza adà­ma­tsalaŋ ala, ama kəla dza uwana agoɗàh à Masasəɗok Zəzagəla kà, masla adàɓəzal mama­tsila tsakana aŋha la zamana uwanay, ŋgaha la məlo uwana adàsa à waŋ babay aw.” ");
INSERT INTO mfh_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Baŋa ahàf delga kà, mayyay aŋha bay kà delga. Ahàf mawi­siga bay kà, mayyay aŋha kà mawi­siga. Kà uwana tasəl ahàf kà la mayyay aŋha uwana la vok ayyay. ");
INSERT INTO mfh_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Akul azlabəza aŋa matsapa, kakay kapəhaw azla­tatak delga, tsa akul azla­ma­wi­siga ma? Uwana gay apəhay kà uwana adahən ləv ala. ");
INSERT INTO mfh_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dza delga atsalla tatak delga à uda la ləmana delga aŋha la abà; dza mawi­siga bay atsalla tatak mawi­siga à uda la ləmana aŋha mawi­siga la abà babay. ");
INSERT INTO mfh_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Iyay, gəgoɗ à akul kà: La vuɗ seriya kà, azladza tadà­wulla à uda la gəl aŋatà lakəl aŋa azlagay deyday gà uwana tapàh gesina. ");
INSERT INTO mfh_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kà uwana la afaɗ gay aŋak la uwana seriya adàpəh à vok, ŋgaha adàpəhla ala kà kak dziriga baŋaw azlayla ka aw.” ");
INSERT INTO mfh_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kiya uwaga azlaanik la tataka aŋa azlaməna mapàhla mapəhay ala la azla Farisəya tagòɗ à Yesu: “Məŋga, asa à anu kà kaɗehəŋ nadzipo tekula mənəŋəŋ.” ");
INSERT INTO mfh_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kiya uwaga Yesu awùlla atà ala, agòɗ: “Azladza aŋa zamana uwanay azla­mak­sa­fər, taɗàh mabila, tanàv nadzipo, ama nadzipo la ahəŋ tanəŋəŋ aw, say aŋa masla mapəhal gay à ahàl Yonas uwatà pəra. ");
INSERT INTO mfh_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bokuba uwana Yonas aɗahà mavakay makər la mahənay makər la huɗ aŋa kilfi babay kà, kiya uwaga adàpaka vok la Kona aŋa dza uwana adàɗah mahənay makər la mavakay makər la zəvay la aku babay. ");
INSERT INTO mfh_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","La vuɗ seriya kà, azladza aŋa gudəŋ Niniv tadà­gola afaɗ à azladza aŋa zamana uwanay à gəl, ŋgaha tadà­puwa à atà gudzi à gəl, à kà uwana azlaməna madz à ahəŋ la Niniv tapə̀h gay la ləv ala, à mok uwana tatsə̀n sayda aŋa Yonas. Uwana aɗuwa Yonas aganay la abanay. ");
INSERT INTO mfh_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","La vuɗ seriya kà, sufəl mis gà uwana la gəl la aku adàgola afaɗ à azladza aŋa zamana uwanay à gəl, ŋgaha adàpuwa à atà gudzi à gəl, kà uwana asà à afik la tsəh la ahəŋ la makəɗ gəl à ahəŋ gudəŋ à vok, kà matsəɓ sləm à haŋkəli aŋa Salomon. Uwana aɗuwa Salomon kà aganay la abanay.” ");
INSERT INTO mfh_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“La mok uwana masasəɗok mawi­siga adasa à uda la dza la abà kà, aday augu­zahay la azla­slaka dey­dayga gesina, ayàh slaka maduw ləv. Ama baŋa aɓəzal aw kà, ");
INSERT INTO mfh_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","agoɗay la gəl aŋha kà: ‘Lagwa kà, gəday, gədàwul à slaka gulo uwana à abà gəsà à uda la abà. Ŋgaha awulay aɓəzal à gəl kà masla­ɗayga lela, maɗehəŋ à ahəŋ gà dzəɓa aŋha səla aw.’ ");
INSERT INTO mfh_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","La abatà kà aday, ayahay azla­ma­sasəɗok mawi­siga anik à tsəh məɗəf, azla­uwana taɗuwa masla la dzaŋ­dzaŋ, tatsa à waŋ atà nna, tadza à ahəŋ la abatà. Kiya uwaga kà, madz à ahəŋ aŋa dza uwaga agay mawi­siga ɗaɗuwa uwana uwarà. Kiya uwaga adàgay la azladza mawi­siga aŋa zamana uwanay.” ");
INSERT INTO mfh_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","La mok uwana iyà la azla­deda aŋa Yesu tasà à waŋ kà, Yesu aɓaɗmà à maham à ahəŋ dza. Tatsàzl à uda, asà à atà maɓa­ɗalma. (( ");
INSERT INTO mfh_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dza anik agòɗ à Yesu: “Iyà la azla­deda aŋak la uda, asà à atà maɓa­ɗa­kama!”)) ");
INSERT INTO mfh_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu awùlla à dza uwatà: “Uwa à iyà gulo la azla­deda gulo uwa?” ");
INSERT INTO mfh_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ŋgaha apə̀hla azlaməna matapla la slaka aŋha ala la magoɗay: “Atà nnay azlaiyà la azla­deda gulo. ");
INSERT INTO mfh_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kəla dza uwana aɗàh uwana asa à Baba gulo uwana la zagəla la afik kà, masla kà deda gulo, baŋaw iyà gulo.” ");
INSERT INTO mfh_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","La mavakay uwatà Yesu asà à uda la kay, ŋgaha ahàd adzà madzay la gay dərəv kà matapla tatak à azladza. ");
INSERT INTO mfh_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Magol maham à ahəŋ dza ahàmal à adi. Masla ahàd à kəslah iyaw à afik, adzà madzay la afik, maham à ahəŋ dza babay tatsàzlla à gay dərəv. ");
INSERT INTO mfh_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Apə̀hàtàla azla­tatak aŋuvaw la azlagay la gay la abà, ŋgaha agòɗ à atà: “Masla maslək tatak asa à uda kà mad à maslək tatak. ");
INSERT INTO mfh_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","La mok uwana aslək hi la guf aŋha la abà, azla­fo­fulo anik tanis à tetəvi à ama, azla­ɗiyaŋ tasa à waŋ tazuw à gay. ");
INSERT INTO mfh_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Azlaanik aya tanis à pala akur afik, bokuba uwana kutso la pala akur lakəl məŋga aw kà, hi as à uda katskats, kà uwana kutso aga la ahəŋ məŋga aw. ");
INSERT INTO mfh_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ŋgaha uwana afats adàdzəka mavəɗay la ndzəɗa, agulla fofulo tsatsaɗeɗa ala, kà uwana aɓək slilih kà à pala akur à afik. ");
INSERT INTO mfh_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bà gotənaŋ azla­fo­fulo anik tanis à atàk à abà, uwana atàk azigənay, akəɗ mas uda aŋa fofulo à tsəh. ");
INSERT INTO mfh_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Bà gotənaŋ azla­fo­fulo anik tanis à kutso delga gà à abà, ŋgaha tavà mayyay lela: Azlaanik tayya à adi zazuŋ səla, azlaanik aya zuŋ, ŋgaha azlaanik huməts.” ");
INSERT INTO mfh_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu azà­tàlàŋ à gəl agòɗ: “Tsə̀ɓàwwal sləm lela à baŋa sləm aga à akul lakəl.” ");
INSERT INTO mfh_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kiya uwaga azlaməna matapla la slaka aŋha tazà vok à slaka aŋha: “Kà mana kapəhatàla gay la gay la abà ma?”, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu agòɗ à atà: “Akul kà, kaɓəzaw masəl nasiri aŋa makoray Zəzagəla, ama atà kà taɓəzal aw. ");
INSERT INTO mfh_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kà uwana dza uwana la tatak tadà­vàlla à gəl aya, ŋgaha adàsəg gəl ala. Ama kà aŋa dza uwana la tatak ŋuv kà, kà tadà­dəvalla à ahàl ala. ");
INSERT INTO mfh_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kà uwaga à uwana gəpəhatàla gay la gay la abà, kà uwana tanəŋaŋ ama tanərəzaŋ ala aw, ŋgaha tatsənaŋ ama bokuba tatsəɓal sləm la matsənəŋ aw, ");
INSERT INTO mfh_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","kà gay aŋa masla mapəhal gay à ahàl Yesayya aŋa magəɗ à afik: ˈAkul la matsəɓal sləm, ama katsənawwaŋ aw; kanəŋawwaŋ la matsəkal yewdi à gay, ama kanəŋawwaŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kà uwana tsəhay uwanay kà adà­dzadza gəl aŋha ala, Danakàh à sləm à ama. Tatsakàh à yewdi aŋatà à ama Kà yewdi aŋatà aŋa manəŋ aw Kà sləm aŋatà aŋa matsənəŋ aw, Ŋgaha kà atà aŋa masəl tatak la ləv aŋatà la tsəh aw, Kà atà aŋa mawul à waŋ à slaka gulo, kà gi aŋa mawuratàla aya aw, Zəzagəla agòɗ.ˈ ");
INSERT INTO mfh_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ama akul kà, marabay agay la akul, kà uwana yewdi aŋkul kà anə̀ŋla, ŋgaha sləm aŋkul atsənà tatak. ");
INSERT INTO mfh_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","La dziriga gəpəh à akul: Aŋuvaw azlaməna mapəh à atà gay à ahàl kà mapàhla à azladza, la azladza dziriga aŋa Zəzagəla, tayàh kà manəŋəŋ uwana kanəŋàwwàŋ, ama tanəŋàŋ aw, kà matsən uwana katsənàwwàŋ, ama tatsənàŋ aw.” ");
INSERT INTO mfh_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Iyay, tsənàwwàŋ godega aŋa gay la gay la abà aŋa masla maslək tatak, uwana asal magoɗay zla. ");
INSERT INTO mfh_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Azla­uwana tatsəna gay marabəŋ lakəl aŋa makoray Zəzagəla ŋgaha takəsaŋ aw, atà kà kalkal la gay tetəvi uwana azla­fo­fulo tanis ala à ama: Ŋgaha mawi­siga atsa à waŋ, atsatsam uwana à uda tasləka à ləv aŋatà à tsəh. ");
INSERT INTO mfh_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Azlaanik kalkal la pala akur, uwana azla­fo­fulo tanis à afik, tatsəɓ sləm à gay, takəs la marabay katskats, ");
INSERT INTO mfh_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ama tadala slilih la atà la abà aw. Takəs kà aŋa kaslà ŋuv pəra. Mok uwana matərəɓay, la mas ŋgərpa adà­tsizlla ala kà gay Zəzagəla kà, katskats tasak madiŋal gəl à vok aŋatà la tsəh ala. ");
INSERT INTO mfh_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Azlaanik kalkal la gày atàk uwana azla­fo­fulo tanis à abà: Tatsəna gay Zəzagəla, ama madzugway la adi aŋa gudəŋ à vok uwanay, la matsiɗay aŋha, la mapa­patay aŋha lakəl aŋa ləmana asufa gay uwana ala la ləv aŋatà la tsəh, ŋgaha ahən aw. ");
INSERT INTO mfh_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Azlaanik kalkal la kutso delga uwana azla­fo­fulo tanis à abà: Tatsəɓ sləm à gay, ŋgaha tatsənaŋ. Ŋgaha tahən lela, azlaanik tayya à adi zazuŋ səla, azlaanik zuŋ, azlaanik aya huməts.” ");
INSERT INTO mfh_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu apə̀h à atà gay la gay la abà anik, agòɗ à atà: “Aganay tatak uwana məga­gazləla la makoray Zəzagəla. Dza anik asləkà fofulo delga à guf aŋha à abà. ");
INSERT INTO mfh_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","La vəɗ la abà vərdi anik, à mok uwana azladza gesina la madzehal la abà, masla məzam aŋa dza uwatà asà à waŋ, akokos maŋa­viya à guf hi uwatà à abà, ŋgaha adà aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mok uwana hi ada­zigənay, adzəkà matsa à gəl ahənay kà, maŋa­viya apàhla vok ala babay. ");
INSERT INTO mfh_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Azla­ma­gamza aŋa dza aŋa guf tasà à waŋ tagòɗal: ‘Məŋga, kasləkà kà fofulo delga à guf aŋak à abà mi ya, maŋa­viya uwanay ma asà à waŋ ma lala aya la?’ ");
INSERT INTO mfh_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Agòɗ à atà: ‘Uwaga kà masla məzam gulo la uwana aɗahà kiya uwaga’. Kiya uwaga azla­ma­gamza tanàval, tagòɗal: ‘Lagwa ma, asa à ka məday mədà­tsəɗ à ahəŋ ay?’ ");
INSERT INTO mfh_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Awaŋ’, agòɗ à atà: ‘Baŋa la katsəɗaw maŋa­viya à ahəŋ kà, zlahaw kà, kadà­tsəɗawla hi gà, ");
INSERT INTO mfh_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","sàkàwwal, tahən la slaka gà tsəràh à matsəɗ tatak. La kaslà uwatà kà, gədàgoɗ à azlaməna matsəɗ tatak: Tsə̀ɗàw kà maŋa­viya dadàŋ, wàɗà­hàwàŋ təmta­təm kà matəl à gay, ŋgaha la lig la ahəŋ kà, dàwgəla hi gulo à mtəga, gədàgoɗ à azlaməna matsəɗ tatak’.” ");
INSERT INTO mfh_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu apə̀h à atà gay la gay la abà anik aya, agòɗ à atà: “Makoray Zəzagəla kà, məga­gazləla kà la tsəhay hamadz uwana atsa à uda la lig gày aŋa dza. ");
INSERT INTO mfh_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Masla la uwana à tsəh azlatsəhay anik anik à tsəh gesina, ama baŋa ada­zigənay kà, masla la uwana aɗuwa azlaahàf anik, apak magol ahàf tsəràh à uwana azla­ɗiyaŋ tasaha à waŋ kà maŋalàh gày aŋatà à afik.” ");
INSERT INTO mfh_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu apə̀h à atà gay la gay la abà anik aya, agòɗ à atà: “La mana gəga­gazləla makoray Zəzagəla ma? Makoray Zəzagəla kà kalkal la tatak maməsl tatak ala, uwana mis akotsiŋ à pə̀hàw dogum zlo à tsəh uwana aɗàh kilo dzik səla gəl aŋha səla, tsəràh à uwana aməsl magol pə̀hàw uwaga ala gesina.” ");
INSERT INTO mfh_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu apə̀h uwaga gesina à maham à ahəŋ dza kà la gay la gay la abà. Apə̀h à atà gay la kokuɗa la gay la gay la abà aw, ");
INSERT INTO mfh_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","kà gay aŋa masla mapəhal gay à ahàl aŋa mapàhla à azladza aŋa magəɗ à afik: ˈGədà­paha à atà kà la gay la gay la abà, Gədàpəhatàla tatak mahaɗ vok à ahəŋ gà uwana agà dagay madzəka vok aŋa gudəŋ à vok.ˈ ");
INSERT INTO mfh_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","La lig la ahəŋ Yesu asàk à maham à ahəŋ dza à ahəŋ, awùl à mtəga. Azlaməna matapla la slaka aŋha tazà vok à slaka aŋha kà manaval godega aŋa gay la gay la abà uwatà: “Pə̀hanula gay la gay la abà aŋa maŋa­viya uwana la guf hi la abà!” ");
INSERT INTO mfh_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu awùlla atà ala la kiya uwanay: “Iyay, dza uwana aslək fofulo delga kà, uwaga kà Kona aŋa dza, ");
INSERT INTO mfh_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","guf kà, uwaga kà gudəŋ à vok, fofulo delga kà, azladza uwana azlaaŋa makoray Zəzagəla, ŋgaha maŋa­viya bay kà, azlaaŋa masla mawi­siga. ");
INSERT INTO mfh_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Masla məzam uwana akokos maŋa­viya uwaga kà seteni; təla matsəɗ tatak uwaga, kà madəv à gay gudəŋ à vok, azlaməna matsəɗ tatak kà azla­ma­lika. ");
INSERT INTO mfh_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Bokuba uwana tawàɗàh maŋa­viya à akàl à gay kà, kiya uwaga adàpaka vok la madəv à gay gudəŋ à vok babay. ");
INSERT INTO mfh_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kona aŋa dza adàsləl azla­ma­lika aŋha à ahəŋ, ŋgaha tadà­tsatsam à uda la makoray aŋha la abà azladza uwana tasokw dza à tsakana à abà gesina, la azladza uwana taɗàh mawi­siga. ");
INSERT INTO mfh_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tadà­wuts atà à gudùh akàl uwana à abà, matuway la mapaɗ sliɗ la tsəh ala te­ra­wawa la abà. ");
INSERT INTO mfh_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ama azla­uwana takə̀s gay aŋa Zəzagəla kà, atà kà tadàuɗay bokuba afats la makoray aŋa Baba Zəzagəla la abà. Tsə̀ɓàwwal sləm lela, à baŋa sləm aga akul lakəl.” ");
INSERT INTO mfh_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Makoray Zəzagəla kà kalkal la ləmana uwana mahaɗəŋ à ahəŋ gà la guf la abà. Dza anik aɓəz à ləmana uwaga, ŋgaha ahaɗeŋ à ahəŋ aya. Masla arab, ahad madawla uwana akoray gesina, ŋgaha asukwla guf uwatà.” ");
INSERT INTO mfh_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Makoray Zəzagəla kà, kalkal la masla matsa­kalay uwana ayàh azla­tatak ɓə̀ɗà delga delga gà. ");
INSERT INTO mfh_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mok uwana adaɓəz tatak ɓə̀ɗà uwana delga gà, tsa­kalay aŋha zla­zlaɗa kà, aday, adawul tatak uwana akoray gesina, ŋgaha asukw la tatak ɓə̀ɗà uwatà.” ");
INSERT INTO mfh_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Makoray Zəzagəla kà kalkal la dzarawa uwana aduway à iyaw à abà uwana ahəl tsəhay tatak anik anik gesina. ");
INSERT INTO mfh_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mok uwana adahən ala, azlaməna makas kilfi tabiyaŋ à uda, ŋgaha tadzàh madzay kà makəs kilfi delga delga à takosà à abà, ama uwana delga aw kà, tafətukw ala. ");
INSERT INTO mfh_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kiya uwanay à uwana adàpak à vok la makəɗ gəl à ahəŋ gudəŋ à vok: Azla­ma­lika tadàsa à ahəŋ kà mavàh azla­ma­wi­siga ala la azla­delga, ");
INSERT INTO mfh_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ŋgaha tadàfətukw azla­ma­wi­siga à gudùh akàl à abà. Tadà­taway la mapaɗàh sliɗ la tsəh ala, la abatà.” ");
INSERT INTO mfh_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Katsenaw uwaga gesina nəma ay?”, Yesu agòɗ à atà. “Iyay”, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ŋgaha agòɗ à atà: “Kiya uwanay zla, kəla masla mapàhla wakità mapəhay uwana ala apàk masla asik aŋa makoray Zəzagəla kà, masla kà bokuba zil gày uwana ahəl à uda la ləmana aŋha la abà azla­tatak mawga la azla­ma­vi­yaga.” ");
INSERT INTO mfh_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Mok uwana Yesu adadəv azlagay la gay la abà uwaga à gay kà, adà aŋha la abatà. ");
INSERT INTO mfh_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ŋgaha awùl à gudəŋ uwana à abà azigə̀n la abà, adzəkà matapatàla azla­tatak la gày madəv kuɗa anatà la aku, ŋgaha azladza gesina kà ləv avàlàh à atà à gay gesina, tagòɗ: “Haŋkəli uwanay ma aɓə̀zal ma lala? Kakay asla kà maɗehəŋ azla­na­dzipo uwanay ma? ");
INSERT INTO mfh_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Masla kà bəzi aŋa masla mapəɗ ahàf təga aw uwà? Mari­yama la uwana iyà aŋha aw takay? Yakuba, Yusufu, Səmon, ŋgaha Yahuda la uwana azla­deda aŋha təga aw takay? ");
INSERT INTO mfh_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Azla­deda aŋha dəgam gà bay kà, atà la abanay kəla mavakay aw takay? Ŋgaha ma lala aɓə̀zal ndzəɗa uwaga zlam la?” ");
INSERT INTO mfh_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kà uwaga à uwana tadìŋ gəl à masla à vok aw. Ama Yesu agòɗ à atà: “Masla mapəhal gay à ahàl kà lala beyli kà takəs gay aŋha, ama la gudəŋ aŋha uwana tayyà à abà baŋaw la huɗ gày aŋha kà, takəs gay aŋha aw.” ");
INSERT INTO mfh_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","La abatà kà Yesu aɗahà azla­na­dzipo ŋuv pəra kà uwana tadìŋ gəl à masla à vok aw. ");
INSERT INTO mfh_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","La zamana uwatà, Herod sufəl aŋa Galili avərà gay kà mapəhay lakəl aŋa Yesu. ");
INSERT INTO mfh_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Agòɗ à azlaməna magamza aŋha: “Yuhana masla maɗàh batem kà, adawul à uda la mamətsay, kà uwaga à uwana aga la maslay kà maɗàh azla­na­dzipo kiya uwanay.” ");
INSERT INTO mfh_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tekeɗik kà, Herod la uwana avà tetəvi kà makəs Yuhana, awàɗàŋ, ŋgaha adùw à daŋay kà lakəl aŋa mis aŋa deda aŋha Filip, uwana sləm aŋha He­ro­diya. ");
INSERT INTO mfh_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kà uwana Yuhana agòɗ à Herod: “Azlayla kà, kà kak aŋa mazəɓ He­ro­diya kà aŋa mis aw.” ");
INSERT INTO mfh_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod asàl makəɗ Yuhana, ama guba akə̀s kà azla Yahu­diya, kà uwana gesina anatà tanəŋà Yuhana kà bokuba masla mapəhal gay à ahàl aŋa Zəzagəla kà mapàhla azladza. ");
INSERT INTO mfh_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mok uwana mavakay uwana tayyà Herod adadəbà, tahàb madəvaday la mavakay uwatà. Dugu aŋa He­ro­diya ahàb dəs la huma aŋa azladza uwana tazàlàh atà. Dəs uwatà, adà à ləv aŋa Herod à tsəh, aràbàŋ, ");
INSERT INTO mfh_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","tsəràh à uwana azùw mawaɗay kà mav tatak à dugu uwaga kəla tatak uwana anavay gesina. ");
INSERT INTO mfh_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","La mapəhal aŋa iyà aŋha, agòɗ à sufəl: “Nàts gi gəl aŋa Yuhana à tasà à abà, kavà à gi.” ");
INSERT INTO mfh_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kay, uwaga azà à sufəl məŋga, ama kà mazuw mawaɗay aŋha, ŋgaha la azladza uwana azàlàh atà kà, avà tetəvi kà maɗàh uwaga. ");
INSERT INTO mfh_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Aslə̀l dza kà mad manats gəl aŋa Yuhana masla maɗàh batem à waŋ la daŋay. ");
INSERT INTO mfh_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tasəlà gəl uwatà à waŋ la tasà la abà, tavà à dahalay, masla bay adàla à iyà aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","La lig la ahəŋ azlaməna matapla la slaka Yuhana masla maɗàh batem, tasà à waŋ, tazə̀ɓ vok aŋha kà mad malay. La lig la ahəŋ, tahàd kà mapəh tatak uwana apakà vok à Yesu. ");
INSERT INTO mfh_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mok uwana Yesu atsənà uwaga, atsìzlla ala la abatà la kəslah iyaw, kà mad aŋha à kəsaf à abà kokuɗa gəl aŋha. Ama uwana maham à ahəŋ dza atsə̀n uwaga kà, tasà à uda la gudəŋ la abà, ŋgaha tanəfà Yesu la maguway la gay gərdza. ");
INSERT INTO mfh_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mok uwana Yesu adasa à ahəŋ la kəslah iyaw la afik, anəŋà maham à ahəŋ dza aŋuvaw. Vok ahàmal kaykay kà azladza uwaga, ŋgaha adzəkà mawar atà ala la ɗuvats aŋatà la abà gesina. ");
INSERT INTO mfh_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Uwana mokokhu adasa à waŋ kà, azlaməna matapla la slaka aŋha tazà vok à slaka aŋha, tagòɗal: “Vəɗ adagay, ŋgaha slaka uwanay kà fəta aya. Sàk à maham à ahəŋ dza tadà aŋatà à huɗ gudəŋ, kà atà aŋa mayàh huɗ aŋatà à gay.” ");
INSERT INTO mfh_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu awùlla atà ala: “Akəsa vok kà atà aŋa madiy aŋatà aw, akul la gəl aŋkul, vàw à atà tatak may.” ");
INSERT INTO mfh_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ama tagòɗal: “La abanay kà kaf gay bərsew zlo la kilfi səla pəra aga anu la ahàl.” ");
INSERT INTO mfh_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu agòɗ à atà: “Sàwgəla à waŋ à abanay dadàŋ.” ");
INSERT INTO mfh_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yesu agòɗ à maham à ahəŋ dza: “Dzàw madzay la kəsaf la afik!” Ŋgaha masla ahə̀l kaf gay bərsew zlo la kilfi səla uwatà, anəŋà à zagəla, “Kikay”, agòɗ à Zəzagəla. Atsəkà kaf ala, avà à azlaməna matapla la slaka aŋha, ŋgaha azlaməna matapla uwaga tavàh à maham à ahəŋ dza uwatà bay. ");
INSERT INTO mfh_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kiya uwaga kəla uwa­be­yuwi azùw, kəla aŋa may aŋha. Azlaməna matapla tahamà à gay à matəm à atà à ahàl gà à vok, takosà kulo gəl aŋha səla à uwana atəmal à atà à ahàl la kaf zlo la kilfi səla uwaga la abà. ");
INSERT INTO mfh_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Matugway aŋa azlazil uwana tazùw kaf kà, aslay dəbow zlo kokuɗa matugw azlamis la azlabəza. ");
INSERT INTO mfh_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kiya uwaga Yesu agòɗ à azlaməna matapla la slaka aŋha kà: “Dàw à kəslah iyaw à afik, katsəvokaw à gay dərəv à uda anik kà gi, gi kà: ‘Mada aŋulo zlà’, gəgoɗ à maham à ahəŋ dza.” ");
INSERT INTO mfh_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Uwana tavàh vok ala, ahàd à gudəŋ anik à afik kokuɗa gəl aŋha kà madəv kuɗa. Vəɗ aɓə̀zal à gəl la abatà. ");
INSERT INTO mfh_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kəslah iyaw babay kà adaday kà kərkər. Afaɗ atərəɓà atà, kà uwana tagolà à huma à gay. ");
INSERT INTO mfh_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Zwek la huma la gay la matuway gotsak teraŋa, Yesu adà à awtày à slaka azlaməna matapla aŋha la maday lakəl iyaw. ");
INSERT INTO mfh_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ama mok uwana tanəŋàŋ aday la gəl iyaw kà, tasəkùlàh à tsəh ala kà guba, “Uwaga kà tatak mavavat dza”, tagòɗ, ŋgaha tadzəkà mawiyay guba. ");
INSERT INTO mfh_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ama katskats Yesu aɓa­ɗa­tàmà: “Karuwaw vok à ahəŋ aw, gi ŋuwà, guba akəs akul aw!”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piyer aɓa­ɗalmà, agòɗal: “Sufəl, baŋa kak dziri kà: ‘Sà à waŋ’, gòɗ à gi, gəda à awtày la gəl iyaw!” ");
INSERT INTO mfh_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Sà à waŋ”, Yesu agòɗal. Piyer asà à ahəŋ la kəslah iyaw la afik, adzəkà maday la gəl iyaw kà mad à slaka Yesu. ");
INSERT INTO mfh_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ama uwana anəŋàŋ afaɗ adzəkà maɗəɗay kà, adzəkà masəkulay la mad à iyaw à abà, adzəkà mawiyay: “Sufəl, ɓə̀lla gi!” ");
INSERT INTO mfh_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Katskats Yesu abiyà ahàl ala, akə̀s la ahàl, ŋgaha agòɗal: “Kayyà, madiŋal gəl à vok aŋak kà à tsəh ala, kà mana kadzur­kway la ləv aŋak la tsəh ma?” ");
INSERT INTO mfh_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tadà à kəslah iyaw à afik atà səla, ŋgaha afaɗ aɗə̀ɗ aya aw, adzà à ahəŋ titi. ");
INSERT INTO mfh_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kiya uwaga azlaməna matapla uwana la kəslah iyaw la afik takədèɗ à ahəŋ la huma aŋa Yesu, tagòɗal: “Ndzer, kak Kona aŋa Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mok uwana tadà à uda la dərəv la abà kà, tabə̀z à makoray aŋa Ge­ne­saret à abà. ");
INSERT INTO mfh_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bokuba uwana azladza la gudəŋ uwatà tasə̀l Yesu kà, tazàhà gay aŋa mas à waŋ aŋha la huɗ gudəŋ gesina, ŋgaha tahamàhla azlaməna ɗuvats à waŋ gesina. ");
INSERT INTO mfh_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tadə̀v kuɗa à Yesu kà azlaməna ɗuvats taɓəz tetəvi kà madəɓani amiyaka gay aŋa lukut aŋha pəra, ŋgaha dza gesina uwana adəɓani kà awur ala la ɗuvats aŋha la abà. ");
INSERT INTO mfh_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Azla Farisəya la azlaməna matapla mapəhay aŋa Zəzagəla tasà à waŋ la Uru­sa­lima, tasà à slaka Yesu la magoɗal: ");
INSERT INTO mfh_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kà mana azlaməna matapla la slaka aŋak kà takə̀s mapəhay aŋa azla­baba madzi­dziga aw ma? Kà mana tapalàh ahàl bokuba uwana matapla gami apəhay kà mazuw tatak may aw ma?” ");
INSERT INTO mfh_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu awùlla atà ala, agoɗ à atà: “Akul ma, kà mana kakəsaw mapəhay aŋa Zəzagəla aw, kanəfaw kà matapla aŋa gəl aŋkul ma? ");
INSERT INTO mfh_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tekeɗik kà Zəzagəla agòɗ kà: ˈZlə̀ɓà baba aŋak la iyà aŋakˈ ŋgaha ˈDza uwana apəh mawi­siga lakəl aŋa baba aŋha baŋaw aŋa iyà aŋha kà azlayla mamətsay.ˈ ");
INSERT INTO mfh_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ama akul kà kagoɗaw kà: ‘Baŋa dza agoɗ à baba aŋha baŋaw à iyà aŋha: Humà tatak gulo, uwana gəɗàhla sləray kà, annaka gəslala vok aŋa mav à ka mazlak ka, uwaga kà tatak maf à ahəŋ gà kà aŋa Zəzagəla.’ ");
INSERT INTO mfh_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kiya uwaga kà, dza uwaga anəkuɗa kà mazlakay baba aŋha baŋaw iyà aŋha aya aw. Kiya uwaga à uwana kakəlaw mapəhay aŋa Zəzagəla ala, kà akul aŋa manəf matapla aŋa gəl aŋkul. ");
INSERT INTO mfh_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Akul azlaməna magolla dza, azlawla Yesayya masla mapəhal gay à ahàl apə̀h lakəl aŋkul, agòɗ: ");
INSERT INTO mfh_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ˈAzladza uwanay kà tazləɓ gi la paŋaw deyday pəra. Ama ləv aŋatà kà kərkər la gi. ");
INSERT INTO mfh_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Makədeɗ à ahəŋ uwana azladza uwanay takədeɗ à gi à ahəŋ kà deyday, Kà uwana atà tapàhla ala kà masəlay aŋa gəl aŋatà, uwana mapəhay aŋa dza pəra.ˈ” ");
INSERT INTO mfh_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","La lig la ahəŋ Yesu azàl à maham à ahəŋ dza agòɗ à atà: “Tsənàwwàŋ, fàwwal sləm lela: ");
INSERT INTO mfh_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tatak mazuway uwana ada à gay à awtày, la uwana aɗàh àlàh à dza aw, ama uwana atsa à waŋ la gay la awtày, la uwana aɗàh àlàh à dza.” ");
INSERT INTO mfh_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Azlaməna matapla aŋa Yesu tazà à vok à slaka aŋha, tagòɗal: “Kasəl kà gay aŋak uwanay kà azin azla Farisəya à gəl kaykay aw takay?” ");
INSERT INTO mfh_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Awùlla à atà la magoɗay: “Kela fofulo uwana Baba gulo uwana la zagəla la afik asləkà aw kà, adàgay maɓəɗ à ahəŋ gà. ");
INSERT INTO mfh_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Sàkàw atà, atà azlaməna makas azla­gu­ləf à ahàl. Ama baŋa akəs guləf anik à ahàl kà, atà səla nna tadàsokw à afək à abà.” ");
INSERT INTO mfh_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piyer atsə̀val gay aŋha à gay, agòɗal: “Sànula à uda à gay la gay la abà uwaga!” ");
INSERT INTO mfh_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu agòɗ à atà: “Akul babay kà kaslaw matsən uwanay aw takay? ");
INSERT INTO mfh_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kasəlaw kà kəla tatak uwana ad à huɗ aŋa dza kà aguw à uda la godega aw takay? ");
INSERT INTO mfh_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ŋgaha babay kəla tatak uwana aguwa la gay aŋa dza kà asà à uda kà la ləv la tsəh, uwaga la uwana aɗàh àlàh à dza à vok. ");
INSERT INTO mfh_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kà uwana la ləv la tsəh la uwana madzugway mawi­siga atsà à uda adàla dza à makəɗ dza à abà, à gəl gaw à abà, à mabila à abà, à limlim à abà, à gəl à abà, à fida à abà, ŋgaha à mapàh mawi­siga lakəl aŋa azladza anik à abà babay. ");
INSERT INTO mfh_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Uwaga la uwana aɗàh àlàh à dza à vok, ama mazuw tatak la kokuɗa mapal ahàl bokuba uwana manəbay aŋkul agòɗ kà, aɗàh àlàh à dza à vok aw.” ");
INSERT INTO mfh_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu atsìzlla ala la abatà, ahàd à kutso uwana à abà nekwa la gudəŋ Tir la Sədon. ");
INSERT INTO mfh_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mis Kana­niya uwana adzà à ahəŋ la gudəŋ uwatà, asà à waŋ à slaka aŋha, adə̀val kuɗa: “Məŋga, Kona aŋa David, vok aham à ka kà gi. Dugu gulo la zagəla zagəla lakəl məŋga, uwana atərəɓəŋ kaykay.” ");
INSERT INTO mfh_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ama Yesu apakwà gay məslək aw. Kiya uwaga azlaməna matapla la slaka aŋha tasà à waŋ, tagòɗ à Yesu: “ ‘Dà aŋak’, gòɗ à mis uwaga, anəf anu la tsəh la gay.” ");
INSERT INTO mfh_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu awùlla à uda: “Gi kà gəga masləl gi à waŋ kà, kà aŋa azla­tuwaŋ mazàhla gà Isərayel pəra.” ");
INSERT INTO mfh_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ama mis asà à waŋ, akədèɗ à ahəŋ la huma aŋha la magoɗal: “Məŋga, kamkam zlàk à gi.” ");
INSERT INTO mfh_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu awùlla à uda, agòɗal: “Delga kà mazəɓ kaf aŋa azlabəza kà maməl à azlakəda à ahəŋ aw.” ");
INSERT INTO mfh_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Iyay nəma, Məŋga”, mis agòɗal. “La kità babay kà, azlakəda kà tatsatsàm mapətsèh pətsèhga uwana atàɗ kà azlaməŋga à vəɗah.” ");
INSERT INTO mfh_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kiya uwaga Yesu awulàlla, agòɗal: “Hay, mis, madiŋal gəl à vok aŋak kà məŋga, tatak uwana kayahay kadàɓəzal.” Ŋgaha dugu aŋha awùr ala la kaslà uwatà. ");
INSERT INTO mfh_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu adà aŋha la abatà, ahàd à gay dərəv aŋa Galili, à gudəŋ à afik, adzà madzay la abatà. ");
INSERT INTO mfh_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Maham à ahəŋ dza aŋuvaw tasà à waŋ à slaka aŋha, tasàhla azlaməna ɗuvats à waŋ: Azla­deri, azla­gu­ləf, azla­ma­kalàh gà, azla­bada, ŋgaha azlatsəhay anik anik gesina babay. Tahamà atà à huma aŋa Yesu, ŋgaha awaràtàla. ");
INSERT INTO mfh_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ləv avàlàh à azladza à gay məŋga, kà uwana tanəŋà kà azla­bada tavats gay, azla­ma­kalàh gà tawàrla, azla­deri tadày, ŋgaha azla­gu­ləf bay tanə̀ŋla. Tadzəka mazləɓ Zəzagəla aŋa Isərayel. ");
INSERT INTO mfh_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu azàl azlaməna matapla la slaka aŋha ŋgaha agòɗ à atà: “Kay, vok aham à gi kà azladza uwanay, kà uwana mahənay makər atà la slaka gulo, ŋgaha tatak may adadàv kà atà à gay, asa à gi maduw atà à gəl la may gà aw, kà uwana may adàkaɗ atà asik à gəl, tadàtəɗ à ahəŋ la tetəvi la ama.” ");
INSERT INTO mfh_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Azlaməna matapla la slaka aŋha tanàval à gay ala: “Lala məɓəz tatak may məŋga kà aŋa azladza kat uwanay la kəsaf uwanay la abà la?” ");
INSERT INTO mfh_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu anàv à atà gay ala, agòɗ à atà: “Kaf gay bərsew nna aga à akul la ahàl ma?” Tagòɗal: “Gay bərsew məɗəf, la azlabəza kilfi ŋuv ŋuv.” ");
INSERT INTO mfh_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","“Kiya uwaga dzàhàw madzay”, agòɗ à maham à ahəŋ dza. Maham à ahəŋ dza tadzàhà à madzay. ");
INSERT INTO mfh_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","La lig la ahəŋ ahə̀l kaf məɗəf la azlabəza kilfi uwatà, “Kikay”, agòɗ à Zəzagəla, akà­làhàŋ ala, ŋgaha avà à azlaməna matapla la slaka aŋha, kà atà aŋa mavàh à maham à ahəŋ dza. ");
INSERT INTO mfh_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kəla uwa­be­yuwi aŋatà azùw kəla may aŋha. Matam à atà à ahàl gà kà, azlaməna matapla tahà­malla à gay à vok takosà məɗəf aya. ");
INSERT INTO mfh_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Azlaməna mazuw tatak uwaga kà zil dəbow ufaɗ kokuɗa matugw azlamis la azlabəza. ");
INSERT INTO mfh_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mok uwana “Dàw wurwur”, Yesu ada­go­ɗiya à maham à ahəŋ dza kà, ahàd à kəslah iyaw à afik kà maday à kutso aŋa Magadan à abà. ");
INSERT INTO mfh_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Azla Farisəya la azla Sadu­kiya tazà à vok à slaka Yesu, kà mava­va­rəŋ, tanàv à Yesu kà mapəhatàla la nadzipo la abà kà ndzəɗa aŋha kà atsa à ahəŋ kà la Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ama Yesu awùlla atà ala: “La matəɗ à ahəŋ afats kagoɗaw kà: ‘Baŋa məlo, atəv à tsəh la matəɗ à ahəŋ afats kà, lebəŋ kà məl adàhəɗay’, kagoɗaw. ");
INSERT INTO mfh_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ama la gay bebəŋ gà kà kagoɗaw: ‘Iyaw adà­suway lakana, kà uwana zagəla atəv à tsəh’. Akul kà, kasəlaw mavàh məlo aŋa zagəla ala, ama kà mana kasəlaw mavàh masəlay aŋa zamana uwanay ala aw ma? ");
INSERT INTO mfh_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Azladza aŋa zamana uwanay kà azla­mak­sa­fər, azla­ma­bila la huma Zəzagəla aw, tanavay azla­na­dzipo, ama nadzipo la ahəŋ aw, say masəlay aŋa Yonas pəra”. La lig la ahəŋ asàk atà à ahəŋ, adà aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mok uwana azlaməna matapla taguway la gay dərəv à uda kà avikà à atà kà mazəɓ tatak may à ahàl. ");
INSERT INTO mfh_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kiya uwaga Yesu agòɗ à atà kà: “Ɗahàw haŋkəli, nə̀ŋàwla gəl aŋkul kà tatak maməsl tatak ala aŋa azla Farisəya la azla Sadu­kiya.” ");
INSERT INTO mfh_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Azlaməna matapla tadzəka magoɗay kà atà kà atà: “Iyay, apə̀h kiya uwanay kà, kà uwana məzə̀ɓ tatak may à ahàl aw”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu atsənà madzugway aŋatà, agòɗ à atà: “Kà mana kavàtsàw gay la tsəh ala kà akul à akul ma? Kà uwana tatak may aga à akul la ahàl aw takay? Madiŋal gel à vok aŋkul kà à tsəh ala. ");
INSERT INTO mfh_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tsəràh à lakana babay kà, katsənawwaŋ aw takay? Dzùgwàw lakəl aŋa kaf gay bərsew zlo uwana gətsàkàŋ ala kà aŋa azlazil dəbow zlo tsi. Kasəlaw ma takosà nna atə̀mal à tsəh ala ma? ");
INSERT INTO mfh_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Dzùgwàw lakəl aŋa kaf məɗəf uwana gətsàkàŋ ala kà aŋa azlazil dəbow ufaɗ aya tsi. Ŋgaha ma takosà nna atə̀mal à tsəh ala babay aya ma? ");
INSERT INTO mfh_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kà mana katsənàwwàŋ kà gəpə̀h à akul kà lakəl aŋa tatak may aw ma? Nə̀ŋàwla gəl aŋkul kà tatak maməsl tatak ala aŋa azla Farisəya la azla Sadu­kiya.” ");
INSERT INTO mfh_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kiya uwaga kà, azlaməna matapla tatsənàŋ kà apə̀h à atà kà lakəl aŋa manəŋla vok kà tatak maməsl tatak ala aw, ama kà mapàhla ala aŋa azla Farisəya la azla Sadu­kiya. ");
INSERT INTO mfh_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu ahàd à kutso uwana à abà nekwa la Zəsare aŋa Filip, anàv azlaməna matapla la slaka aŋha la gay ala: “Mana azladza tapəhay lakəl aŋa Kona aŋa dza ma?” ");
INSERT INTO mfh_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tawulàlla: “Azladza anik tagoɗ kà: ‘Kak Yuhana masla maɗàh batem’, azlaanik tagoɗ kà: ‘Kak Eliya’, ŋgaha azlaanik aya tagoɗ kà: ‘Kak Ye­re­miya, baŋaw masla mapəhal gay à ahàl anik’ ”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Iyay zla, akul ma gi uwa kagoɗaw tak uwa?”, Yesu agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Səmon Piyer awùlla à uda agòɗal: “Kak Kristu, Kona aŋa Zəzagəla uwana la sifa aŋa tsəràh à awtày.” ");
INSERT INTO mfh_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kiya uwaga Yesu agòɗal: “Kak la marabay, Səmon kona aŋa Yuhana, kà uwana dza asik à uwana apə̀hakala dziriga uwaga aw, ama Baba gulo uwana la zagəla la afik la uwana apə̀hakala uwaga. ");
INSERT INTO mfh_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ŋgaha gi, gəgoɗ à ka: Kak Piyer, uwana asal magoɗay kà: Dzəgla, ŋgaha la dzəgla uwanay la afik la uwana gədàŋal maham à ahəŋ məna gay Zəzagəla gulo, bà mamətsay bay kà, adàslal à vok aw. ");
INSERT INTO mfh_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gədàvà à ka tsəku­rəm aŋa makoray Zəzagəla à ahàl: Uwana kawaɗəŋ la vəɗah adàgay mawaɗəŋga la zagəla, uwana kapələŋ ala la vəɗah adàgay mapələŋ ala gà la zagəla la afik babay.” ");
INSERT INTO mfh_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","La lig la ahəŋ Yesu afàh akur à azlaməna matapla à lig la slaka aŋha, kà atà aŋa mapəhay à dza anik kà masla Kristu aw. ");
INSERT INTO mfh_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Dagay la kaslà uwatà Yesu adzəkà matapla azlaməna matapla à slaka aŋha la dazu­waya la magoɗay: “Azlayla kà vok kà, gəda à Uru­sa­lima, ŋgaha kà gi aŋa mas ŋgərpa məŋga la abatà la ahàl aŋa azla­ma­siga, la azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla, ŋgaha aya la azlaməna mapàhla mapəhay ala. Tadàkəɗ gi, ŋgaha la mahənay mamakər gədàwul à uda la mamətsay.” ");
INSERT INTO mfh_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kiya uwaga Piyer akə̀s à fəta à awtày ŋgaha adàl à gəl, agòɗal: “Zəzagəla anəŋla ka Sufəl, uwaga adàɓəz à ka aw!” ");
INSERT INTO mfh_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ama Yesu agolà vok, agòɗ à Piyer: “Zà à gi vok kərkər, kak seteni, kak masla matsalla à gi matekwiɗ la tetəvi gulo la ama, kà uwana madzugway aŋak kà aŋa azladza vəɗah awkà uwana asà à Zəzagəla aw.” ");
INSERT INTO mfh_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ŋgaha la lig aŋa uwaga la ahəŋ Yesu agòɗ à azlaməna mata­pla la slaka aŋha: “Baŋa dza asal manəf gi kà, asak à maf sləm à gəl aŋha, ŋgaha azəɓ ahàf mamətsay aŋha, ŋgaha anəf gi. ");
INSERT INTO mfh_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Dza uwana asal matəf gəl aŋha, adàziŋ ala, ama dza uwana az gəl aŋha ala kà gi, adàɓəl gəl aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mana akəs vok à dza, uwana akor gudəŋ à vok gesina, ŋgaha masla adàz gəl ala la huma la gay bawbaw ma? Tatak la ahəŋ dza avày kà masukwla sifa aŋha takay? ");
INSERT INTO mfh_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kona aŋa dza adàsa à waŋ la mazləɓay aŋa Baba aŋha la abà la azla­ma­lika aŋha, ŋgaha adàpəlay à kəla dza la tsəhay maɗehəŋ aŋha uwana aɗa­hàhàŋ. ");
INSERT INTO mfh_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Haɗay, gəpəh à akul la dziriga: Azladza anik la tataka aŋkul la abà la abanay kà, tadà­matsay dàŋ aw, say baŋa tanəŋ Kona aŋa dza atsa à waŋ la makoray aŋha.” ");
INSERT INTO mfh_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mahənay mukwa la lig aŋha la ahəŋ, Yesu azə̀ɓ Piyer, Yakuba ŋgaha Yuhana, deda aŋa Yakuba, ŋgaha adàla atà à gəl gudəŋ kərkər gà à afik, kokuɗa gəl aŋatà. ");
INSERT INTO mfh_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aɓə̀ɗla vok la huma yewdi aŋatà, huɗ adi aŋha aŋəràzlla atà à adi bokuba afats, ŋgaha lukut aŋha aùɗ təlla. ");
INSERT INTO mfh_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ŋgaha azlaməna matapla makər uwaga tanəŋà Musa atà la Eliya, tavàts gay la Yesu. ");
INSERT INTO mfh_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kiya uwaga Piyer agòɗ à Yesu: “Sufəl delga à uwana məga la abanay zla. Baŋa asa à ka gəts safsaf makər à abanay, tekula aŋak, tekula aŋa Musa, tekula aŋa Eliya.” ");
INSERT INTO mfh_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","La mok uwana Piyer aɓaɗmà, habaga akə̀l atà, mələs magol mago­du­godu à adi taɓa­ɗamma, la habaga uwatà la abà kà kuda atsə̀n la magoɗay: “Uwanay kà bəzi gay ləv gulo, gərabay məŋga, məŋga kà masla. Tsə̀ɓàw sləm à masla lela.” ");
INSERT INTO mfh_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mok uwana azlaməna matapla tatsə̀n kuda uwaga kà, guba akə̀s atà, takədèɗ à ahəŋ la huma aŋa Yesu. ");
INSERT INTO mfh_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu azà à vok à slaka aŋatà, ŋgaha aɓàk atà à ahàl à gəl: “Tsì­zlàwla guba akəs akul aw”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tawàlla gel à afik, ama tanəŋà dza anik aw say Yesu kokuɗa gel aŋha pəra. ");
INSERT INTO mfh_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mok uwana tatsàh à ahəŋ la gudəŋ la afik, Yesu afahà à atà akur à lig: “Kapəhaw à dza lakəl aŋa tatak uwana kanəŋàwwàŋ tsəràh à mok uwana Kona aŋa dza adàwul à uda la mamətsay aw.” ");
INSERT INTO mfh_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ŋgaha kiya uwaga azlaməna matapla tanàv à Yesu: “Kà mana azlaməna mapàhla mapəhay ala tagoɗ kà: ‘Eliya adàtsa à vok à waŋ ma’?” ");
INSERT INTO mfh_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Awùlla à atà ala: “La dziriga Eliya atsa à waŋ kà maɗàh tatak à ahəŋ la tetəvi aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ama gəgoɗ à akul kà, Eliya kà adasa à waŋ dagay uwarà, ama azladza tasəl kà masla aw, taɗa­hàlàŋ à vok bokuba uwana asà à atà. Kiya uwaga babay tadà­ɗe­həŋ à Kona aŋa dza la gel aŋha.” ");
INSERT INTO mfh_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kiya uwaga à uwana azlaməna matapla tatsənàŋ à uwana apə̀h à atà gay lakəl aŋa Yuhana masla maɗàh batem. ");
INSERT INTO mfh_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mok uwana tabəzay à slaka uwana maham à ahəŋ dza la ahəŋ, dza anik azà à vok à slaka Yesu akədèɗal à huma, ");
INSERT INTO mfh_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","agòɗal: “Məŋga, vok aham à ka, kà bəzi gulo uwana la ɗuvats tatagà akasay, atərəɓ à ahəŋ kaykay, ŋgaha babay ataɗàh à akàl à abà, à iyaw à abà aya babay. ");
INSERT INTO mfh_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Gəsə̀lla à azlaməna matapla la slaka aŋak à waŋ, ama taslàlà vok aŋa mawurəŋ ala aw.” ");
INSERT INTO mfh_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu agòɗ à atà: “Kayyà, akul azladza dzaŋ­d­zaŋga, ŋgaha mawi­siga, dagay mbà mədàdz à ahəŋ anina ma? Tsəràh mbà, gədà­ba­sa­ha­kulaŋ ma? Lagwa sàwgəla bəzi uwatà à abanay!” ");
INSERT INTO mfh_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","La abatà Yesu aslə̀h məl à masasəɗok mawi­siga à gəl, ŋgaha masasəɗok mawi­siga uwaga asà à uda la bəzi uwaga la abà, awùr ala la mok uwatà. ");
INSERT INTO mfh_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","La lig la ahəŋ, azlaməna matapla la slaka aŋha tazà à vok à slaka aŋha, tanàval à gay ala: “Kà mana məslalla vok, kà masəlla masasəɗok mawi­siga uwaga à uda aw ma?” ");
INSERT INTO mfh_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu agòɗ à atà: “Kà uwana madiŋal gəl à vok aŋkul asla aw! Haɗay, la dziriga: Agay madiŋal gel à vok aŋkul à gay la ahəŋ bà kat tsəhay hamadz kà, naka kaslawwalla vok aŋa magoɗ à dadəgwal uwanay: ‘Zà à vok la abanay!’, ŋgaha masla aslala vok aŋa maz à vok. Tatak la ahəŋ aɗəɗ à akul gay à ahəŋ aw. (( ");
INSERT INTO mfh_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ama say la madəv kuɗa la makəs nəlay la uwana, dza aslala vok aŋa masəla à tsəhay masasəɗok mawi­siga uwanay à uda!))” ");
INSERT INTO mfh_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Vuɗ tekula, mok uwana azlaməna matapla la slaka aŋha tagà la kutso Galili, Yesu agòɗ à atà: “Kona aŋa dza kà tadàvày à ahàl aŋa azladza. ");
INSERT INTO mfh_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tadàkəɗay, ama la mahənay mamakər adàwul à uda la mamətsay.” Azlaməna matapla tadzà à ahəŋ la mazaw la gel la abà məŋga, kà gay uwaga. ");
INSERT INTO mfh_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mok uwana Yesu la azlaməna matapla la slaka aŋha tabə̀z à Kaper­nahum, azlaməna mazəɓ hadama aŋa məŋ gày Zəzagəla tazà à vok à slaka Piyer, kà manaval à gay ala: “Piyer, məŋga aŋkul ma apəl hadama aŋa məŋ gày Zəzagəla aw takay?” ");
INSERT INTO mfh_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Iyay, apəlay”, Piyer agòɗal. Mok uwana Piyer adà à gày la kay, Yesu adzəkà gay teraŋa, agòɗal: “Mana kadzugway ma Səmon? Azla­uwana tapəlay hadama baŋaw tapəl gəl à azla­su­fəl aŋa gudəŋ à vok uwanay uwà? Azlaməna gudəŋ takay awma azlaməlok dza takay?” ");
INSERT INTO mfh_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Azlaməlok dza”, Piyer agòɗal. Yesu agòɗal: “Tsa kiya uwaga kà, azlaməna gudəŋ tapəlay aw. ");
INSERT INTO mfh_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ama kà mazin à atà à gəl aw kà, hàd à dərəv à abà, ɗadùw kodzar aŋak à iyaw à abà, kilfi uwana kadàtsa à vok à makəsay kà, kadàpakw à gay aŋha kadàɓəzal gursu la paŋaw aŋha la awtày kà, kadàhəlay, ŋgaha kadàɓək à atà kà aŋami anu səla.” ");
INSERT INTO mfh_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","La kaslà uwatà azlaməna matapla tazà à vok à slaka Yesu ŋgaha tanàval: “Uwa, məŋga gà la makoray Zəzagəla uwa?” ");
INSERT INTO mfh_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu azàla bəzi ŋuv gà, atsìzl­latàŋ à huma à gay, ");
INSERT INTO mfh_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","agòɗ à atà: “Gəpəh à akul la dziriga: Baŋa kapakaw bokuba bəzi ŋuv gà uwanay aw kà, kadàdaw à makoray Zəzagəla aw. ");
INSERT INTO mfh_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Dza uwana tələmmaga bokuba bəzi uwanay kà, masla la uwana dza məŋga gà la makoray Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ŋgaha: Dza uwana akəs bəzi ŋuv gà uwanay kà sləm gulo kà, akəs gi babay.” ");
INSERT INTO mfh_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Dza uwana adukw mabəziga bəziga uwanay adiŋ gi gəl à vok, à tsakana à abà kà, ŋuləm kà aŋha kà tawaɗal magol dzəgla à kuda, ŋgaha taduw à dərəv à abà. ");
INSERT INTO mfh_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kayyà ŋgərpa kà aŋa gudəŋ à vok uwanay, kà uwana aga la azla­tatak uwana adala dza à tsakana à abà. Dza aslala vok kà maɗəɗ gay à uwaga à ahəŋ aw, ama ŋgərpa agay la dza uwana abiy uwaga à waŋ.” ");
INSERT INTO mfh_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Baŋa ahàl aŋak baŋaw asik aŋak la uwana adala ka à tsakana à abà kà, nàtsàh à tsəh ala, wùtsla kərkər la kak, ŋuləm kahàd à sifa dziriga à abà la ahàl tekula baŋaw la asik tekula, à kà kak aŋa mad à gày akàl uwana à abà ama­tsila aw la azlaahàl aŋak la azlaasik aŋak gesina aŋa koksi­koksi. ");
INSERT INTO mfh_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Baŋa kà yewdi aŋak la uwana adala ka à tsakana à abà kà, ɓə̀ɗ à adi ala, məlla kərkər, ŋuləm kahàd à sifa à abà ŋizliŋa ŋizliŋ la yewdi, kà kak aŋa mad à gày akàl uwana à abà ama­tsila aw aŋa koksi­koksi la yewdi səla nna.” ");
INSERT INTO mfh_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ɗahàw haŋkəli kà mapəseway tekula aŋa azlabəza uwanay, kà uwana gəpəh à akul à vok à abà kà, la zagəla kà azla­ma­lika aŋatà tatsizl à ahəŋ koksi­koksi la huma aŋa Baba gulo, kà aŋatà.” (( ");
INSERT INTO mfh_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kà uwana Kona aŋa dza asa à waŋ kà mayàh maɓəl azla­uwana tazahla.)) ");
INSERT INTO mfh_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mana kadzugwaw à baŋa dza akor tuwaŋ dzim, ŋgaha tekula aŋatà azilà, asàk azladzik ladəga gəl aŋha ladəga gà uwanay la gudəŋ la afik, kà mad mayàh uwana azalà aw takay? ");
INSERT INTO mfh_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Gəgoɗ à akul baŋa adaɓəzal kà, arabay məŋga kaykay à kà azladzik ladəga gəl aŋha ladəga uwanay tazàh ala aw. ");
INSERT INTO mfh_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kiya uwaga babay, Baba aŋkul uwana la zagəla la afik kà, asal amiyaka tekula la tataka azlabəza gà uwaga la abà azila aw.” ");
INSERT INTO mfh_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Baŋa deda aŋak aɗahà à ka tsakana à vok, hàd à slaka aŋha, pə̀h alla mawi­siga aŋha, ama gàw kà akul səla səla pəra. Baŋa atsəɓ à ka sləm kà, kaɓəz deda aŋak aya. ");
INSERT INTO mfh_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ama baŋa akwes kà matsəɓ à ka sləm kà, zàl à dza tekula à tsəh baŋaw səla, kà mapəhay lakəl aŋa gay uwaga gesina, kà magay la sayda aŋa azladza səla la afik baŋaw aŋa azladza makər bokuba uwana matse­tseray apəhay. ");
INSERT INTO mfh_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ama baŋa akweska matsəɓ à atà sləm kà, pə̀h uwaga à azlaməna madiŋal gəl à vok gesina; ŋgaha baŋa atsəna à atà aw kà, pàkàw dza uwaga ala bokuba dza uwana asəl Zəzagəla aw, baŋaw kiya masla mazəɓ haɗama.” ");
INSERT INTO mfh_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“La dziriga gəpəh à akul uwana kawa­ɗawwaŋ la vəɗah, adàgay mawaɗəŋga la zagəla, uwana kapəlawwaŋ ala la vəɗah, adàgay mapələŋ ala gà la zagəla la afik babay.” ");
INSERT INTO mfh_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Iyay, gəpəh à akul babay aya kà, baŋa azladza səla la tataka aŋkul la abà, tatsən vok gay kà manavay amiyaka bà mana beymi la madəv kuɗa la abà kà, Baba gulo uwana la zagəla la afik adàvà à atà. ");
INSERT INTO mfh_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kà uwana la slaka uwana azladza səla baŋaw makər taham gay à vok la sləm gulo kà, gi la tataka aŋatà la abà”, Yesu agòɗ. ");
INSERT INTO mfh_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kiya uwaga Piyer azà à vok à slaka Yesu, anàvalla gay ala: “Sufəl, asik nna gədà­matsiŋ à deda gulo ala à baŋa asàkìyà à maɗehgəŋ mawi­siga à vok aw ma? Tsəràh à asik məɗəf ay?” ");
INSERT INTO mfh_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","“Awaŋ”, Yesu agòɗal: “Asik məɗəf gəgoɗ à ka aw, ama tsəràh à asik dzik məɗəf asik məɗəf. ");
INSERT INTO mfh_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kiya uwaga à uwana məga­gazləla makoray Zəzagəla la Sufəl anik uwana asal masəl madz à ahəŋ aŋa tatak aŋha la slaka magamza aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mok uwana tadzàh madzay kà matugway kà, tasàlla dza uwana à waŋ anəfay la sili ləfu gà, azla­million aŋuvaw la vok. ");
INSERT INTO mfh_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Dza uwatà agà la tatak kà mapəlla sili uwatà aw. Məŋga aŋha agoɗ: Məduw masla ala bokuba mayà, ŋgaha maduw mis aŋha ala la azlabəza aŋha gesina, ŋgaha kəla tatak uwana akoray gesina, kà mapəlla goder uwana la vok gesina. ");
INSERT INTO mfh_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Magamza uwaga akəɗeɗ à ahəŋ la huma aŋa məŋga aŋha: ‘Kamkam, bàsàgəŋ, gədàpəla à ka gesina’, agoɗal. ");
INSERT INTO mfh_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kiya uwaga vok aham à məŋga aŋha: Asà­kalla goder aŋha uwaga la vok gesina, adùwal gəl, adà aŋha.” ");
INSERT INTO mfh_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Magamza maduwal gəl gà uwaga, asà à uda anəŋà dza uwana taɗa­hàhà sləray atà səla, uwana goder aŋha la vok aŋa sili akur akurga dzim. Uwana ada­nəŋəŋ kà, akə̀s la kuda agòɗal: ‘Pə̀l à gi goder gulo uwana aga à ka la vok.’ ");
INSERT INTO mfh_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","‘Kamkam, kamkam’, manalay aŋha akəɗeɗal à ahəŋ la magoɗal: ‘Bàsàgəŋ, gədàpəla à ka goder aŋak gesina’, agòɗal. ");
INSERT INTO mfh_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ama akə̀s aw, adùw à daŋay tsəràh à uwana apəl goder aŋha dàŋ. ");
INSERT INTO mfh_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mok uwana azla­ma­gamza anik tanəŋà uwaga apakà vok, tapàkàh ləv məŋga kà uwaga, ŋgaha tahàd, tapə̀h uwaga à məŋga aŋatà. ");
INSERT INTO mfh_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kiya uwaga məŋga aŋatà azàla magamza uwaga. ‘Kak magamza makəsa­fər gà, gi gəsàk à ka ala goder gulo uwana agà à ka la vok gesina, kà uwana kadə̀v à gi kuɗa aw takay? ");
INSERT INTO mfh_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Naka vok aham à ka kà manalay aŋak suwaŋ, bokuba uwana vok ahamà à gi kà kak aw takay?’ ");
INSERT INTO mfh_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Məŋga uwaga apàk ləv məŋga lakəl aŋha, adùw magamza uwaga à daŋay tsəràh à uwana apəlal goder aŋha gesina suwaŋ.” ");
INSERT INTO mfh_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kiya uwaga Yesu azàlàŋ à gəl: “Baba gulo uwana la zagəla la afik adà­ɗa­ha­kulaŋ kiya uwaga babay, à baŋa tekula aŋkul amatsàŋ à deda aŋha ala la ləv aŋha gesina aw zla!” ");
INSERT INTO mfh_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mok uwana Yesu adakəɗ gəl à gay uwaga, asà à uda la Galili kà mad à makoray aŋa Yahu­diya uwana à abà la gay dərəv uda anik aŋa mukwà Urdun. ");
INSERT INTO mfh_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Maham à ahəŋ dza aŋuvaw tanəfà, ŋgaha awarà azlaməna ɗuvats aŋatà ala gesina. ");
INSERT INTO mfh_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Azla Farisəya anik tazà à vok à slaka Yesu kà matap masla, tanàval: “Haɗay, ma mapəhay gami avà tetəvi à dza kà makuɗək mis la kəla gay uwala beyli takay?” ");
INSERT INTO mfh_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu awùlla à uda, agòɗ: “Kadzèŋàw uwana matse­tseray apəhay aw takay? La madzəka Zəzagəla aŋàl zil atà la mis. ");
INSERT INTO mfh_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kà uwaga à uwana zil adàsak à baba aŋha à ahəŋ, ŋgaha à iyà aŋha à ahəŋ kà madz à ahəŋ atà la mis aŋha, atà səla nna tadàgay vok tekula pəra. ");
INSERT INTO mfh_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kiya uwaga kà, atà səla aya aw, atà tekula pəra, kità kà, dza avàh tatak uwana ala Zəzagəla ada­ha­malla à atà ala gay à vok aw.” ");
INSERT INTO mfh_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Azla Farisəya tanàv: “Kà mana zlà ma Musa agòɗ kà, zil av wakità mavàh vok ala à ahàl aŋa mis kà atà aŋa mavàhla, agòɗ zla ma?” ");
INSERT INTO mfh_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu awùlla à uda: “Musa avà à akul tetəvi kà, kà uwana akul azla­dzaŋ­dzaŋ. Awkà dagay la madzəka kà, agà kiya uwanay aw. ");
INSERT INTO mfh_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Gəpəh à akul la dziriga: Baŋa dza akuɗək mis aŋha, tsa la mazaɓ zil la tsəh aw kà, masla kà adàda à gəl gaw, à baŋa azəɓ mis anik.” ");
INSERT INTO mfh_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Azlaməna matapla la slaka aŋha tagòɗal: “Iyay, baŋa gay aŋa zil atà la mis adagay kiya uwanay kà, ŋuləm mazəɓ mis aw pəra.” ");
INSERT INTO mfh_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu awùlla à atà ala: “Azladza gesina taslala vok aŋa makəs mapəhay uwanay aw, say azla­uwana Zəzagəla avà à atà maslay pəra. ");
INSERT INTO mfh_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tatak anik anik la ahəŋ à uwana aɗəɗ gay à dza à ahəŋ, kà mazəɓ mis dagay la mayyay. Azladza anik kà azladza la uwana taɗa­hatàŋ à vok, tadadəslàh atà, kà aŋa azladza anik babay kà tapak kiya uwanay kà makoray Zəzagəla. Dza uwana asla kà makəsay matapla uwanay kà, akəs!” ");
INSERT INTO mfh_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Azladza tasàhla azlabəza à slaka Yesu kà masla aŋa maɓak à atà ahàl à gəl, ŋgaha kà madəv kuɗa lakəl aŋatà. Ama azlaməna matapla la slaka Yesu tavərà atà gay. ");
INSERT INTO mfh_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu agòɗ à atà: “Sàkàw azlabəza ŋuv ŋuvga tasa à waŋ à slaka gulo, kavəraw atà gay aw, kà uwana makoray Zəzagəla kà aŋa azlatsəhay gà uwaga”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Masla aɓàk à atà ahàl à gəl ŋgaha adà aŋha la abatà. ");
INSERT INTO mfh_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Dza anik azà à vok à slaka Yesu, anàv: “Məŋga, mana à delga gəɗehəŋ, kà gi aŋa maɓəz sifa adəv à gay aw ma?” ");
INSERT INTO mfh_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu agòɗal: “Kà mana kanàv à gi lakəl aŋa delga ma? Dza tekula pəra, delga. Baŋa asa à ka, kà maɓəz sifa adəv à gay aw kà, say kakəs mapəhay gesina.” ");
INSERT INTO mfh_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Tsəhay gà uwala?”, agòɗ à Yesu. Yesu agòɗal: “Kakəɗ dza aw, kada à gəl gaw aw, kad à gəl aw, kapəh mawi­siga lakəl aŋa dza aw, ");
INSERT INTO mfh_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","slə̀kàw baba aŋak la iyà aŋak, wòyà masla magay aŋak bokuba uwana kawoya gəl aŋak.” ");
INSERT INTO mfh_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Bəzi kohana agòɗal: “Uwaga kà, dagay la bəziga la uwana gəkəs uwaga gesina. Mana gà à uwana gəɗehəŋ aya ma?” ");
INSERT INTO mfh_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu agòɗal: “Baŋa asa à ka aŋa magay sətaka kà, hàd, dàw tatak uwana ala kakoray gesina, ŋgaha vàh sili gà à azlaməna kuɗa, kiya uwaga kadàɓəz ləmana la zagəla, ŋgaha sà à waŋ kanəf gi!” ");
INSERT INTO mfh_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ama mok uwana bəzi kohana atsənà gay uwaga kà, adà aŋha la mazaw la gəl gà, kà uwana galepi gà kaykay. ");
INSERT INTO mfh_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kiya uwaga Yesu agòɗ à azlaməna matapla la slaka aŋha: “Gəpəh à akul la dziriga, zla­zlaɗa kà aŋa galepi kà mad à makoray Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ŋgaha gəpəh à akul uwanay aya: Ŋuləm zlugumi aguw à uda la afək lepiri, à kà galepi aŋa mad à makoray Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mok uwana azlaməna matapla la slaka aŋha tatsə̀n gay uwaga kà, ləv avàlàh atà à gay kaykay la magoɗay: “Tsa kiya uwanay zlà ma, uwa aslala vok aŋa maɓəlay uwa?” ");
INSERT INTO mfh_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu anərə̀z atà la magoɗ à atà: “Zla­zlaɗa la slaka azladza, ama zla­zlaɗa la slaka Zəzagəla aw.” ");
INSERT INTO mfh_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kiya uwaga Piyer agòɗal: “Tsənàŋ, anu mədasak à tatak à uwana ahəŋ məkòr gesina, ŋgaha kà manəf ka. Mana adàpaka vok kà aŋami ma?” ");
INSERT INTO mfh_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu agòɗ à atà: “Gəpəh à akul la dziriga kà: Mok uwana Kona aŋa dza adàdza madzay la kursi aŋa mazləɓay aŋha la afik kà, akul kulo gəl aŋha səla uwana kanəfaw gi, akul babay kà, kadàdzaw madzay la kursi la afik, kà maɗàh seriya à tsəhay kulo gəl aŋha səla aŋa Isərayel à gəl. ");
INSERT INTO mfh_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ŋgaha azla­uwana gesina tasàk azlagày aŋatà à ahəŋ baŋaw azla­deda aŋatà à ahəŋ, à azla­deda aŋatà dəgam gà à ahəŋ, à azla­baba aŋatà à ahəŋ, à azlaiyà aŋatà à ahəŋ, à azlabəza aŋatà à ahəŋ, à azlaàlàk aŋatà à ahəŋ kà gi, tadàɓəzal aŋuvaw asik dzim aya, ŋgaha la huma aya sifa uwana adəv à gay aw. ");
INSERT INTO mfh_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ama aŋuvaw azlaməna huma lagonay, tadàgay azlaməna lig gà, ŋgaha aŋuvaw azlaməna lig gà lagonay, tadàgay azlaməna huma.” ");
INSERT INTO mfh_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Aganay, gəga­gazləla makoray Zəzagəla la dza uwana asà à uda la gay bebəŋ bəŋ, kà mahəl azlaməna sləray à guf aŋha à abà. ");
INSERT INTO mfh_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Akəs kà mapəl à atà sili aŋa mavakay: Gursu tekula, ŋgaha asləl atà à guf à abà. ");
INSERT INTO mfh_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Asà à uda la zil gosila aya, anəŋà azladza anik tatsàzl à ahəŋ la vada­vaday la afik kokuɗa sləray. ");
INSERT INTO mfh_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Agòɗ à atà: ‘Akul babay, dàw à guf gulo à abà, gədàpəl akul bokuba uwana akəs à vok’. ");
INSERT INTO mfh_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ŋgaha tahàd. Kona uwaga asà à uda la tataka afats, ŋgaha la afats dat mago­va­gova gərewni delga aya, ŋgaha aɗahàŋ kiya uwana aɗahàŋ aya. ");
INSERT INTO mfh_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ŋgaha asà à uda afats ɗaɓək agər à abà, aɓə̀z azladza anik à gəl uwana tatsàzl à ahəŋ la vada­vaday la afik deyday aya. Anàv à atà à gay ala: ‘Kà mana kavakaw à abanay kokuɗa maɗàh sləray ma?’ ");
INSERT INTO mfh_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Dza la ahəŋ ahə̀l anu aw’, tagòɗal. Agòɗ à atà: ‘Akul bay, dàw à guf gulo à abà!’ ” ");
INSERT INTO mfh_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Mok uwana mokokhu adasa à waŋ, dza aŋa guf agòɗ à kohana aŋha: ‘Zàl azlaməna sləray kà, pə̀l à atà sili aŋatà, dzəkà la azlaməna ligga, tsəràh à azla­uwana tasà à waŋ gay bebəŋ’. ");
INSERT INTO mfh_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Azla­uwana tadzəkà sləray la afats ɗaɓək agər à abà tasà à waŋ, kəla uwa­be­yuwi aŋatà taɓàz à gursu tekula tekula. ");
INSERT INTO mfh_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mok uwana tazàl azlaməna mahəl atà teraŋa, tasà à waŋ, tadzùgw kà tadàɓəzal kà aɗuwaŋ à azladza anik, tagòɗ. Ama kəla uwa­be­yuwi aŋatà taɓàzà gursu tekula tekula pəra. ");
INSERT INTO mfh_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","La mok uwana takasay kà tako­kò­tàhà gəl lakəl aŋa dza aŋa guf. ");
INSERT INTO mfh_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ŋgaha tagòɗ: ‘Azlaməna sləray uwana taɗahà sləray kà sa tekula pəra kà, kapə̀l atà kà kalkal la aŋami uwana məbàs may vok aŋa mavakay lis à marabak ala ma?’ ");
INSERT INTO mfh_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ama dza aŋa guf awùlla à tekula aŋatà: ‘Slawda gulo, gəva­varà ka aw. ‘Aya’, kagòɗ, kà maɗàh sləray aŋa mavakay lakəl aŋa gursu tekula aw takay? ");
INSERT INTO mfh_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kə̀s sili aŋak ŋgaha kà, dà aŋak. Asa à gi mav à dza uwana gəzə̀ɓ la lig aŋak la ahəŋ bokuba aŋak suwaŋ. ");
INSERT INTO mfh_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kagoɗ ma, gəslala vok aŋa maɗehəŋ la sili gulo bokuba uwana asa à gi aw takay? A uwana kaɗàh à adi ma, kà uwana gəɗahà delga takay?’ ");
INSERT INTO mfh_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kiya uwanay azla­uwana azlaməna ligga tadàgay azlaməna huma, ŋgaha azlaməna huma tadàgay azlaməna ligga”, Yesu agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu adà à Uru­sa­lima à afik. Ahə̀l azlaməna matapla aŋha kulo gəl aŋha səla uwaga à fəta à awtày, ŋgaha apə̀h à atà gay la asik lakəl: ");
INSERT INTO mfh_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tsənàwwàŋ, məda à Uru­sa­lima lagwa, ŋgaha tadàv Kona aŋa dza à ahàl aŋa azla­ma­dza­haga aŋa azlaməna makaɗ tatak à Zəzagəla la ahàl aŋa azlaməna mapàhla mapəhay ala. Tadàdukw ala mamətsay à gəl. ");
INSERT INTO mfh_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ŋgaha tadàvày à ahàl aŋa azladza uwana azla Yahu­diya aw, atà tadà­kədaslal, tadà­zlaɓay la kurpi ŋgaha tadà­ta­taslay à ahàf à adi. Ama la mahənay makər kà, adàwul à uda la mamətsay.” ");
INSERT INTO mfh_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kiya uwaga iyà aŋa azlabəza aŋa Zebede azà à vok à slaka Yesu la azlabəza aŋha, akədèɗ à huma aŋha kà manaval tatak. ");
INSERT INTO mfh_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Mana asa à ka ma?”, Yesu agòɗal. Agòɗ: “Và à gi tetəvi, kà azlabəza gulo səla uwanay kà, tadàdzah madzay tekula la ahàl kaf aŋak ŋgaha anik la ahàl gudzay aŋak lakəl la makoray aŋak!” ");
INSERT INTO mfh_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","“Kasəlaw tatak uwana kanavaw aw”, Yesu agòɗ, “Kaslawwalla vok kà mas tatak à uda la kətsaw ŋgərpa uwana la abà gədàsay ay?” “Məslala vok”, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“Ndzer kadàsaw la kətsaw ŋgərpa gulo”, Yesu agòɗ à atà. “Ama la ahàl gulo kà magoɗay lakəl aŋa madz madzay la slaka gulo, anik la ahàl kaf, anik la ahàl gudzay aw. Slaka uwatà kà, kà aŋa azla­uwana Baba gulo aɗa­hatàŋ à ahəŋ pəra.” ");
INSERT INTO mfh_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Uwana azlaməna matapla kulo anik uwanay tatsənà uwaga kà, taŋoŋùz lakəl aŋa azla­deda səla uwanay. ");
INSERT INTO mfh_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kiya uwaga Yesu azàla atà gesina, agòɗ: “Kasəlaw kà azla­su­fəl aŋa gudəŋ à vok taɗàh gasa à azladza à gəl, ŋgaha azlaməŋga tapə̀h la ndzəɗa aŋatà ala. ");
INSERT INTO mfh_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ama uwaga kà apaka vok kiya uwaga la tataka aŋkul la abà aw, baŋa tekula la tataka aŋkul asal magay məŋga kà, say agay masla mazəɓ dagum à azladza anik, ");
INSERT INTO mfh_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ŋgaha baŋa tekula la tataka aŋkul asal magay masla huma, say agay mayà aŋkul. ");
INSERT INTO mfh_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Amiyaka gi Kona aŋa dza kà, gəsà à waŋ kà azladza aŋa mazlək gi aw, ama gəsà à waŋ kà mazlək azladza, la mav sifa gulo bokuba tatak mapəlla gəl à ahəŋ aŋa azladza aŋuvaw.” ");
INSERT INTO mfh_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mok uwana tasà à uda la gudəŋ Yeriko la abà, maham à ahəŋ dza aŋuvaw tanəfà Yesu. ");
INSERT INTO mfh_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Azla­gu­ləf səla la ahəŋ tadzàh madzay la gay tetəvi tatsənàŋ kà Yesu adà à awtày la abatà, tadzəkà mawiyay: “Məŋga, Kona aŋa David, vok aham à ka kà anu!” ");
INSERT INTO mfh_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Maham à ahəŋ dza taslàh à atà məl à gəl la magoɗay: “Dzàw à ahəŋ titi!”, ama tazà kuda à zagəla la mawiyay aya kaykay: “Məŋga, Kona aŋa David, vok aham à ka kà anu!” ");
INSERT INTO mfh_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu atsìzlla à ahəŋ, azàl atà, ŋgaha anàv à atà gay ala: “Mana asa à akul, kà gəɗa­ha­kulaŋ ma?” ");
INSERT INTO mfh_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tagòɗal: “Məŋga, kà yewdi gami aŋa manəŋla.” ");
INSERT INTO mfh_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Vok ahamà à Yesu, adəɓanì yewdi aŋatà; katskats azladza səla uwaga tanàŋ ala, ŋgaha tanəfà Yesu. ");
INSERT INTO mfh_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kiya uwaga mok uwana tazlà­bə̀z kà Uru­sa­lima la gudəŋ Betfaze, la gudəŋ kuvu la afik, Yesu aslə̀l azlaməna matapla la slaka aŋha səla à huma à gay. ");
INSERT INTO mfh_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Agòɗ à atà: “Dàw à gudəŋ uwatày à abà la huma aŋkul, kadàɓəzaw à ziwŋŋu à gəl mawaɗəŋ à ahəŋ gà la bəzi aŋha, pə̀làw masla, ŋgaha sàwgəla à waŋ à abanay. ");
INSERT INTO mfh_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Baŋa dza apəh à akul gay ‘Kà mana mi kà’, gòɗàwwal kà, Sufəl awoyàŋ, ŋgaha tadàsak à akul aŋa masəlla à waŋ.” ");
INSERT INTO mfh_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Uwaga apakà vok kà aŋa magəɗ à afik aŋa gay aŋa masla mapəhal gay à ahàl aŋa mapàh à azladza uwana agòɗ: ");
INSERT INTO mfh_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ˈGòɗàw à azlaməna madz à ahəŋ la Səyon kà: Nə̀ŋàŋ Sufəl aŋak atsa à waŋ à slaka aŋak La masləkaway məŋga la ziwŋŋu la afik, Ŋgaha la bəzi ziwŋŋu la afik.ˈ ");
INSERT INTO mfh_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Azlaməna matapla taɗahàŋ bokuba uwana apə̀h à atà. ");
INSERT INTO mfh_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tas1əlla ziwŋŋu à waŋ la bəzi aŋha, ŋgaha tadawal azla­deb­debi aŋatà à lig. La lig la ahəŋ Yesu adzà à afik. ");
INSERT INTO mfh_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Maham à ahəŋ dza aŋuvaw tadawal azla­deb­debi aŋatà à tetəvi à ama, ŋgaha azlaanik taslàh baɓasl aŋa azlaahàf, à tetəvi à ama kà mazləɓ masla. ");
INSERT INTO mfh_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Azladza uwana taguwà à huma aŋa Yesu tawiyà la marabay: “Mazləɓay agay la Kona aŋa David, ŋgaha Zəzagəla apis gay à dza uwana à vok, atsa à waŋ la sləm aŋa Sufəl Zəzagəla. Mazləɓay agay la Zəzagəla uwana kərkər la zagəla la afik!” ");
INSERT INTO mfh_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mok uwana adabəz à Uru­sa­lima à abà, azladza gudəŋ uwaga gesina tavədzàh ala. Tanàv à vok: “Uwa à dza uwaga uwa?” ");
INSERT INTO mfh_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Masla mapəhal gay à ahàl Yesu, zil Nazaret, uwana la Galili”, maham à ahəŋ dza agòɗ. ");
INSERT INTO mfh_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Uwana tabə̀z à Uru­sa­lima, Yesu ahàd à məŋ gày Zəzagəla à agu, ŋgaha akuɗə̀kàh azlaməna madaw tatak ala la azlaməna masukw tatak à lag la məŋ gày Zəzagəla uwatà la aku. Adakwà table aŋa azlaməna maɓaɗ sili à ahəŋ, ŋgaha la azla­kursi aŋa azlaməna madaw haba­koku ala, ");
INSERT INTO mfh_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","agòɗ à atà: “Tatsetsèr à wakità Zəzagəla à abà kà: ˈGày gulo kà tazallala kà gày madəv kuɗa. Ama akul kà, kada­pa­kawwaŋ ala kà katsakur aŋa azlaməna à gəlˈ.” ");
INSERT INTO mfh_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kiya uwaga azla­gu­ləf la azla­deri tazà à vok à slaka aŋha la məŋ gày Zəzagəla la aku, ŋgaha awarà atà ala. ");
INSERT INTO mfh_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla, la azlaməna mapàhla mapəhay ala kà, gəl akàɗ atà à vok à mok uwana tanəŋà tatak uwana aɗahàŋ kà, la mawiyay aŋa azlabəza uwana la məŋ gày Zəzagəla la aku: “Mazləɓay agay la Kona aŋa David”, tawiyà. ");
INSERT INTO mfh_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kiya uwaga tagòɗ à Yesu: “Katsəna uwana tapəhay ay?” “Iyay, gətsənaŋ”, Yesu agòɗ à atà. “Akul kà, kadzèŋàw uwana la matse­tseray la abà aw ay? A uwana agoɗ kà: Azlabəza la azlabəza vərna tazləɓay, aw takay?” ");
INSERT INTO mfh_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ŋgaha asà à uda, asàk à atà à ahəŋ kà mad à Be­ta­niya kà mahən à abatà. ");
INSERT INTO mfh_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","La bəŋ, mok uwana awùl à huɗ gudəŋ à abà, may akə̀s Yesu. ");
INSERT INTO mfh_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Anəŋà gudəv la gay tetəvi, azà à vok à tsəh aŋha, ama mayyay la vok aw, say baɓasl pəra. Masla agòɗ à gudəv: “Tetuwa kadàyyay aya aw!” La kirim yewdi gudəv uwaga agùl à afik, saŋlatta. ");
INSERT INTO mfh_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Azlaməna matapla la slaka aŋha tanəŋàŋ, ŋgaha ləv avàl à atà à gay kaykay, tanàv à Yesu: “Kakay gudəv uwanay adagula saŋlatta la kirim yewdi ma?” ");
INSERT INTO mfh_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu agòɗ à atà: “Gəpəh à akul la dziriga: Agay madiŋal gəl à vok aŋkul la ahəŋ, ŋgaha katsaw gay la ləv aŋkul la tsəh aw kà, naka akul kà, kaɗa­hawwaŋ uwanay gəɗahàŋ à gudəv uwanay pəra aw, naka kaslawal à vok aŋa magoɗay à dadəgwal uwanay: ‘Ɓə̀ɗ à vok la abanay, hàd, katsà gəl à dərəv à abà!’ Kà uwaga apakà vok, haɗay. ");
INSERT INTO mfh_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Baŋa kadi­ŋawwal gəl à vok kà tatak uwana kanavaw gesina la madəv kuɗa la abà kà, kadà­ɓəzawwal.” ");
INSERT INTO mfh_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu ahàd à məŋ gày Zəzagəla à agu, ŋgaha adzəkà matapla tatak. Azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla la azla­ma­siga aŋa azla Yahu­diya tazà à vok à slaka aŋha, ŋgaha tagòɗal: “La tetəvi ma uwala kaɗàh azla­tatak uwanay la? Uwa avà à ka ndzəɗa uwanay uwa?” ");
INSERT INTO mfh_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu agòɗ à atà: “Gi babay lagwa kà gənav akul manavay tekula, baŋa kawulaw gi ala manavay uwanay kà, gədàpəhakulla ndzəɗa uwana gəɗahlàŋ tatak uwanay. ");
INSERT INTO mfh_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Uwa à uwana aslə̀l Yuhana masla maɗàh batem à waŋ uwa? Zəzagəla awma azladza takay?” Ama tadzəkà mabay vok gay la tataka aŋatà la abà, ŋgaha tagòɗ: “Baŋa məgoɗ kà Zəzagəla la uwana aslə̀l à waŋ, adàgoɗ à anu: ‘Kà mana zlà ma kadiŋaw gəl à masla à vok aw ma?’ ");
INSERT INTO mfh_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ama baŋa məgoɗ: ‘Azladza la uwana taslə̀l à waŋ’, bay kà, guba aza à anu kà maham à ahəŋ dza, kà uwana azladza gesina tasəl kà masla mapəhal gay à ahàl aŋa Zəzagəla kà mapəhay à azladza.” ");
INSERT INTO mfh_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kiya uwaga tawùlla à Yesu: “Məsəl aw!”. Ŋgaha agòɗ à atà: “Tsa kətà kà, gi babay kà, gəpəh à akul la ndzəɗa uwana gəɗàhla tatak uwanay babay suwaŋ aw!” ");
INSERT INTO mfh_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu adà à huma à gay la mapəhay: “Mana kadzugwaw lakəl aŋa uwanay ma? Dza anik agà la azlabəza səla. Adà à slaka matera, agòɗal: ‘Bəzi gulo, hàd, kadà­ɗaha sləray la guf la abà lakana.’ ");
INSERT INTO mfh_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Gəday aw’, agòɗal, ama zwek la huma la gay kà, aɓə̀ɗla madzugway aŋha, ahàd, aɗahà sləray. ");
INSERT INTO mfh_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Baba ahàd à slaka aŋa anik, apə̀hal. Masla kà, ‘Ayà, Baba’, agòɗal, ama ahàd aw. ");
INSERT INTO mfh_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Uwa lala tataka aŋatà la abà aɗahà uwana asà à Baba uwa?” “Matera”, tagòɗal. Yesu agòɗ à atà: “Gəpəh à akul la dziriga: Azlaməna mazəɓ hadama, la azlaməna mazaɓ zil tadàtsa à vok à makoray Zəzagəla kà akul, ");
INSERT INTO mfh_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","kà uwana Yuhana asà à waŋ à slaka aŋkul la mapəhakulla tetəvi dziriga, ama kadi­ŋawwal gəl à vok aw, kakwe­sawka. Ama azlaməna mazəɓ hadama la azlaməna mazaɓ zil kà, takə̀s, tadìŋal gəl à vok, bà amiyaka tanəŋà uwaga dadàŋ aw. Ama akul kà, kanəŋaw uwaga, ama kaɓəɗawla vok dagay la huɗ gà kà madiŋ gəl à masla à vok aw!” ");
INSERT INTO mfh_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Tsə̀ɓàw sləm à gay la gay la abà anik. Zil gày anik la ahəŋ, atsə̀ɓ guf matavəruk, akə̀sal zlagam à adi, ŋgaha alà afək, kà maku­ɗits iyaw aŋa mayyay ahàf aŋha à abà, ŋgaha aŋàl gày mad à afik maday, kà aŋa masla manəŋla guf, asàkla guf uwatà à azlaməna sləray la ahàl. Ŋgaha adà aŋha à mau­gu­zahay kərkər. ");
INSERT INTO mfh_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mok uwana təla mahənay tatak adaslay, aslə̀l azla­ma­gamza aŋha à slaka azlaməna sləray guf kà mazəɓal humà mahənay aŋa tatak aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ama azlaməna sləray takàs à atà, tazlàɓ anik, takàɗ anik, tatsàh anik la akur. ");
INSERT INTO mfh_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ama masla guf aslə̀l azla­ma­gamza anik aya, uwana atà dəŋ kà azla­uwana uwarà, ama azlaməna sləray guf taɗàhà à atà à vok bokuba uwana taɗahàŋ azla­ma­tera à vok. ");
INSERT INTO mfh_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","La lig aŋa uwaga la ahəŋ, aslə̀l bəzi aŋa huɗ aŋha, agòɗ kà: ‘Tadàsləkaw masla’. ");
INSERT INTO mfh_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ama mok uwana azlaməna sləray guf tanə̀ŋ bəzi aŋha, tagòɗ kà atà kà atà: ‘Yewwa, masla la uwana adàgay dza aŋa tatak bawbaw. Məkə̀ɗ masla, ŋgaha mədàɓəɗal à gəl!’ ");
INSERT INTO mfh_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Takə̀s, tadùw à uda la guf la abà, takə̀ɗ.” ");
INSERT INTO mfh_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu anàv: “Iyay zla, baŋa dza aŋa guf adàsa à waŋ, ma mana adà­ɗe­həŋ la azlaməna sləray uwaga ma?” ");
INSERT INTO mfh_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tagòɗal: “Adàkaɗ azlaməna sləray mawi­siga uwaga à gay, ŋgaha adàvà guf à ahàl aŋa azlaməna sləray anik, uwana tadà­vàhal mahənay aŋa tatak aŋha la mok uwana asàl.” ");
INSERT INTO mfh_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","“Iyay”, Yesu agòɗ à atà: “Kadzèŋàw didi à uwana matse­tseray apəhay aw takay? ˈAkur uwana azlaməna maŋal gày tamə̀l ala kà, Masla la uwana adapak akur mawaɗ gày, Kiya uwaga la uwana Sufəl aɗehəŋ, Ŋgaha uwaga kà akəsa à vok kà aŋami kà manəŋ uwaga!ˈ” ");
INSERT INTO mfh_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kà uwaga Yesu azàlàŋ à gəl: “Haɗay, la dziriga, gəpəh à akul, makoray Zəzagəla adàgay mazəɓa­kullaŋ ala gà, kà mav à tsəhay anik uwana adàvà mayyay à məŋga aŋha. (( ");
INSERT INTO mfh_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kəla dza uwana atəɗ à akur uwanay à afik kà, adà­ka­lahla. Ama baŋa akur la uwana atəɗ à dza à gəl kà aslərəɗəŋ ala kədənna.))” ");
INSERT INTO mfh_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla la azla Farisəya tatsənà gay la gay la abà uwaga kà Yesu kà apəhay kà lakəl aŋatà. ");
INSERT INTO mfh_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kiya uwaga tayàh dabaray kà makəsay, ama guba akə̀s atà kà maham à ahəŋ dza, uwana tapakà Yesu ala kà masla mapəhal gay à ahàl kà mapàhla à azladza. ");
INSERT INTO mfh_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu apə̀hatàla la gay la gay la abà, agòɗ à atà: ");
INSERT INTO mfh_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Aganay tatak uwana məga­gazləla la makoray aŋa Zəzagəla: Sufəl anik atà magol tatak may kà mazəɓ mis aŋa bəzi aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Aslə̀l azla­ma­gamza aŋha kà mazallàh azladza uwana azàllàh atà kà aŋa tatak may uwaga, ama asà à atà mas à waŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Aslə̀l azlaanik aya, la mapəhay uwanay la ahàl: ‘Gòɗàw à azladza uwana gəzàllàh atà kà: Tatak may gulo kà adahənay adagay, azla­kokur gulo, la azla­tatak gulo magag seyga gəda­kaɗay gesina, adahənay. Sàw à waŋ à tatak may mazəɓ mis à gəl!’ ");
INSERT INTO mfh_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ama azlaməna mazala atà kà, tafàl sləm aw, taɗahàŋ à atà à azlaudəra aŋatà anik anik. Anik ahàd à guf aŋha à abà, anik bay à matsa­kalay aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Azlaanik takàs azla­ma­gamza, tatərə̀ɓàhà atà, ŋgaha takàɗ azlaanik. ");
INSERT INTO mfh_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kiya uwaga Sufəl apàk ləv məŋga, asləl azla­slodzi aŋha kà makaɗ atà la mabaɓəh gudəŋ aŋatà à gay la akàl. ");
INSERT INTO mfh_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ŋgaha agòɗ à azla­ma­gamza aŋha: ‘Tatak may aŋa mazəɓ mis kà adagay nekwa, ama azlaməna mazala atà gà kà tadàɓəzal aw. ");
INSERT INTO mfh_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Lagwa kà, dàw à azlabəza tetəvi à ama gesina, ugu­zàhàw, sàwla à waŋ kəla dza uwana kaɓəzawwal à tatak may à gəl.’ ");
INSERT INTO mfh_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Azla­ma­gamza tahàd à azlabəza tetəvi à ama, ŋgaha tahamà gay azla­uwana à vok taɓəzal gesina, azla­ma­wi­siga, la azla­delga ŋgaha kiya uwaga à uwana gày madəvaday ahənà ala la dza.” ");
INSERT INTO mfh_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“La lig la ahəŋ Sufəl asà à gày kà manərəz azladza uwana tazàllàh atà, ŋgaha anəŋà dza uwana lukut mazəɓ mis la vok aw. ");
INSERT INTO mfh_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Sufəl agòɗal: ‘Slawda gulo, kakay kaslà kà mas à gày uwanay à agu, kokuɗa lukut mazəɓ mis la vok ma?’ Ama dza uwaga aslàla vok kà maɓaɗma aya aw. ");
INSERT INTO mfh_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ŋgaha Sufəl agòɗ à azla­ma­gamza aŋha: ‘Tsərə̀kàw azlaahàl aŋha la azlaasik aŋha ŋgaha dùwàw à mələs à abà la uda, la abatà la uwana mawiyay la mapaɗ sliɗ la tsəh ala la ahəŋ, ");
INSERT INTO mfh_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","kà à uwana azlaməna mazal atà gà aŋuvaw, ama azlaməna matsa­tsa­mani atà gà kà dəŋ aw’.” ");
INSERT INTO mfh_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Azla Farisəya tahàd, takə̀s sawaray kà atà aŋa masəlayla: “Kakay à uwana məslala vok aŋa maɓəzal à tsəh la manavay mi?”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Taslə̀l azla­ko­hana aŋatà la azlaanik la tataka maham à ahəŋ matsən vok gay aŋa Herod la abà, tahàd kà magoɗ à Yesu: “Məŋga, məsəl kà dziriga la uwana katapla à azladza aŋa madz à ahəŋ uwana asà à Zəzagəla, kurit yewdi agoɗ à ka, kà maɗehəŋ aŋa azladza uwana tadzugway aw, kà uwana kaɗàh tatak la mahoy adi uwana dza aɗehəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Lagwa kà: Pə̀h à anu uwana kadzugw lakəl aŋa uwanay zla: Mapəhay gami ma, avà à anu tetəvi kà mapəl hadama à məŋ sufəl aŋa azla Rom takay, awma kakay ma?” ");
INSERT INTO mfh_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ama Yesu asə̀l madzugway mawi­siga aŋatà, agòɗ à atà: “Azlaməna magolla dza, kà mana asa à akul aŋa maɓəz gi à tsəh ma? ");
INSERT INTO mfh_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pə̀hàw gi ala sili uwaga kapəlawla hadama tsi!” Tapə̀halla akur sili. ");
INSERT INTO mfh_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ŋgaha Yesu anàv à atà: “Gəl la sləm uwanay ma aŋa uwa la sili uwanay la afik uwa?” ");
INSERT INTO mfh_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Aŋa məŋ sufəl”, tagòɗal. Kiya uwaga Yesu agòɗ à atà: “Kità kà, pə̀làw à məŋ sufəl Zəsar tatak uwana aŋha, ŋgaha pə̀làw à Zəzagəla uwana aŋha suwaŋ!” ");
INSERT INTO mfh_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mok uwana tatsə̀n mawulla à uda aŋa Yesu kiya uwaga, ləv avàlàh à atà à gay kaykay, tasàkal, tadà aŋatà. ");
INSERT INTO mfh_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","La mavakay uwatà, azla Sadu­kiya, atà uwana mawul à uda la mamətsay la ahəŋ aw tagoɗ, tasà à waŋ à slaka Yesu, kà manaval. ");
INSERT INTO mfh_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tanàval: “Məŋga, à aganay uwana Musa apə̀h: Baŋa dza aməts aŋa mis ala kokuɗa maɓəz bəzi kà, say deda aŋha azəɓ à uda la gày kuɗa ŋgaha atsilla tsəhay aŋha ala. ");
INSERT INTO mfh_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Azladza la ahəŋ, atà məɗəf, la azla­deda aŋatà la tataka gami la abà la abanay. Magolga azə̀ɓ mis, amə̀tsal à kəl ala kokuɗa maɓəzal bəzi, ŋgaha asàkla mis kuɗa à deda aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Apakà vok kalkal la uwaga la deda masəla bay, ŋgaha kiya uwaga la mamakər aya, ŋgaha kà məɗəf nna gesina apakà vok kiya uwaga. ");
INSERT INTO mfh_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","La lig aŋatà la ahəŋ gesina kà, mis amə̀ts. ");
INSERT INTO mfh_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","La vuɗ uwana azlaməna mazim­nekiɗ tadàwul à uda ma, atà məɗəf uwaga ma mis adàgay ma aŋa uwa? Kà uwana gesina aŋatà kà, tazàɓ?” ");
INSERT INTO mfh_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu agòɗ à atà: “Kazawla, haɗay zla, kà uwana kasəlaw bà amiyaka matse­tse­rayga, bà amiyaka ndzəɗa aŋa Zəzagəla aw. ");
INSERT INTO mfh_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kà uwana mok uwana azladza tadàwul à uda la mamətsay kà, mazəɓ vok adàgay la ahəŋ aya aw. Tadàdza à ahəŋ kà bokuba azla­ma­lika uwana la zagəla. ");
INSERT INTO mfh_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Lakəl aŋa azla­ma­zim­nekiɗ uwana tadàwul à uda la mamətsay kà kadzeŋaw à uwana Zəzagəla apə̀h lakəl aŋha aw ay? Agòɗ: ");
INSERT INTO mfh_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ˈGi Zəzagəla aŋa Abəraham, gi Zəzagəla aŋa Isak, gi Zəzagəla aŋa Yakubaˈ Zəzagəla azàlàŋ à gəl Zəzagəla kà aŋa azladza uwana la sifa, kà aŋa azla­ma­zim­nekiɗ aw.” ");
INSERT INTO mfh_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Maham à ahəŋ dza uwana tatsənà uwaga kà, ləv avàlàh à atà à gay məŋga kà matapla aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mok uwana azla Farisəya tatsənàŋ Yesu adaməl gəl à azla Sadu­kiya à ahəŋ la gay kà, tahamà gay à vok. ");
INSERT INTO mfh_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ŋgaha tekula aŋatà uwana atapla mapəhay à azladza asàl kà makəsal asik la tsəh ala, anàval à gay ala: ");
INSERT INTO mfh_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Məŋga, mapəhay gami ma uwala à uwana aɗuwa azlaanik gesina ala?” ");
INSERT INTO mfh_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu agòɗal: “Wòyà Sufəl Zəzagəla aŋak la ləv aŋak gesina, la sifa aŋak gesina, la haŋkəli aŋak gesina, ŋgaha la masasəɗok aŋak gesina bay. ");
INSERT INTO mfh_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Uwaga la uwana mapəhay uwana aɗuwa azlaanik. ");
INSERT INTO mfh_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ŋgaha aganay masəla aŋha uwana tazlà à gay kalakal: Wòyà masla magay aŋak bokuba gəl aŋak. ");
INSERT INTO mfh_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mapəhay aŋa Musa la azla­ma­tapla aŋa azlaməna mapəh à atà gay à ahàl gesina tapəh kà lakəl aŋa mapəhay səla uwaga.” ");
INSERT INTO mfh_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Uwana azla Farisəya tahamà gay à vok kà, Yesu anavà à atà gay uwanay: ");
INSERT INTO mfh_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mana kadzugwaw lakəl aŋa Kristu ma? Aga ma mayyi à tsəh ala ma aŋa uwa?” “Mayyi à tsəh ala aŋa David!”, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu agòɗ à atà: “Kakay zlà ma, David uwana masasəɗok Zəzagəla aguwà la masla la abà, aslàla vok azàlal Sufəl ma? Kà uwana David agòɗ: ");
INSERT INTO mfh_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ˈSufəl Zəzagəla agòɗ à Sufəl gulo: Dzà madzay la ahàl kaf gulo lakəl, Tsəràh à uwana gəɓək à ka azlaməna məzam aŋak à tsəh asik.ˈ ");
INSERT INTO mfh_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Iyay zla, baŋa David azàlal ala Sufəl gulo ma, kakay Kristu apàk kona aŋha ma?” ");
INSERT INTO mfh_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Dza la ahəŋ aslàla vok kà mawulla gay uwaga à uda amiyaka tekula aw, ŋgaha dagay la mavakay uwatà, dza aslàla vok kà manaval manavay aya aw. ");
INSERT INTO mfh_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","La lig la ahəŋ, Yesu agolà à huma à slaka maham à ahəŋ dza la azlaməna matapla la slaka aŋha ");
INSERT INTO mfh_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","agòɗ à atà: “Azlaməna mapàhla mapəhay ala la azla Farisəya, sləray aŋatà kà mapàhla mapəhay aŋa Musa à azladza. ");
INSERT INTO mfh_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kiya uwaga kà, kə̀sàw gay aŋatà, ŋgaha hànàw uwana ala tapəh à akul gesina, ama kaɗa­hawwaŋ bokuba maɗehəŋ aŋatà aw, kà uwana atà takəs uwana tatapla à azladza anik aw. ");
INSERT INTO mfh_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tawàɗàh tatak maha­nayga kà mafàh à azladza anik à gəl, ama atà kà takəs aw, amiyaka bà gay gəl ahàl aŋatà babay kà tadəbəlani aw. ");
INSERT INTO mfh_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ama taɗàh sləray aŋatà gesina kà la huma yewdi aŋa azladza pəra. Tawàɗàhla azla­laya à vok la azla­ga­baga bəzlə̀h bəzlə̀hga à vok, uwana matsetser à ahàl azla­mapəhay anik anik aŋa wakità Zəzagəla à adi, ŋgaha la azla­gwa­zazuv duksuffa la azla­lukut aŋatà la gay. ");
INSERT INTO mfh_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Asa à atà kà azla­slaka teraŋa la azlagày madəv kuɗa la aku, la azla­tatak may lakəl kà manəŋ à atà aŋa azladza. ");
INSERT INTO mfh_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Asa à atà bay kà azladza taɗa­haha à atà ‘Ayyi’ la azla­va­da­vaday la afik, la mazalàhatàla azlaməŋga. ");
INSERT INTO mfh_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ama akul kà, kayahaw maza­la­kulla azlaməŋga aw, kà uwana akul gesina kà akul azla­deda, ŋgaha məŋga aŋkul kà tekula ahàl pəra. ");
INSERT INTO mfh_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kaza­lawla Baba à dza asik babay aw, kà uwana akul kà Baba aŋkul kà tekula à ahàl pəra, masla uwana la zagəla la afik. ");
INSERT INTO mfh_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ŋgaha aya kayahaw maza­la­kulla sufəl babay aw, kà uwana Sufəl aŋkul kà tekula à ahàl pəra, uwaga kà Kristu. ");
INSERT INTO mfh_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mazəɓ gəl gà aŋkul kà, agà kà bokuba masla mazəɓ à akul dogum. ");
INSERT INTO mfh_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Dza uwana azigəŋ gəl kà tadà­wulla à vəɗah, ŋgaha dza uwana awulla gəl à vəɗah kà, tazi­gənəŋ.” ");
INSERT INTO mfh_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ŋgərpa agay la akul, akul azlaməna matapla mapəhay, la akul azla Farisəya. Akul azlaməna magolla dza. Katsakaw à gamagày aŋa makoray Zəzagəla à ama kà azladza. Tekeɗik kà, akul la gəl aŋkul kà asa à akul mad à gày aw, azla­uwana tayàh mad à gày bay kavàw à atà tetəvi aw.” (( ");
INSERT INTO mfh_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Ŋgərpa agay la akul, akul azlaməna matapla mapəhay la akul azla Farisəya, akul azlaməna magolla dza. Kazawaw azlamis kuɗa à uda gesina, ŋgaha aya kavakaw à madəv kuɗa à abà kà mapəhla gəl aŋkul ala la huma azladza. Kà uwaga à uwana kadàɓəzaw seriya uwana aɗuwa aŋa azladza anik.”)) ");
INSERT INTO mfh_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ŋgərpa agay la akul, akul azlaməna matapla mapəhay la akul azla Farisəya, akul azlaməna magolla dza. Kau­gu­zahaw dawali dawali gesina la gudəŋ la vok, amiyaka la kəslah iyaw babay, kà akul aŋa maɓəz masla mapəh gay la ləv ala tekula. Ŋgaha baŋa kaɓə̀zàwwal aya kà, kapa­kàwwàŋ ala kà bəzi aŋa gày akàl ɗaɗuwa à gay akul asik səla.” ");
INSERT INTO mfh_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ŋgərpa agay la akul, akul azlaməna maguwàh azla­gu­ləf à huma. Kagoɗaw kà: ‘Baŋa dza azuw mawaɗay la məŋ gày Zəzagəla kà, uwaga kà deyday’, kagoɗaw. ‘Ama baŋa azuw mawaɗay kà la luwà­luwà uwana la gày Zəzagəla la aku kà, mawaɗay adànəfay’, kagoɗaw. ");
INSERT INTO mfh_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Akul azla­ku­soŋu, akul azla­gu­ləf! Uwa la à uwana məŋga gà la? Luwà­luwà ay awma məŋ gày Zəzagəla uwana masla la uwana agəŋ luwà­luwà uwaga sətaka takay? ");
INSERT INTO mfh_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kagoɗaw aya kà: ‘Baŋa dza azuw mawaɗay la slaka makəɗ tatak kà, uwaga kà deyday’, kagoɗaw, ‘Ama dza uwana azuw mawaɗay la tatak makəɗayga uwana la afik kà, mawaɗay adànəfay’, kagoɗaw. ");
INSERT INTO mfh_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Akul azla­gu­ləf, uwa la à uwana məŋga gà la? Tatak makəɗayga ay awma slaka makəɗ tatak uwana agəŋ tatak makəɗayga sətaka takay? ");
INSERT INTO mfh_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kà uwaga kà, dza uwana azuw mawaɗay la slaka makaɗ tatak kà azuw mawaɗay la tatak maka­ɗayga uwana la afik babay. ");
INSERT INTO mfh_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Dza uwana azuw mawaɗay la məŋ gày Zəzagəla kà, azuw mawaɗay la məŋ gày Zəzagəla ŋgaha la Zəzagəla uwana adz à ahəŋ la aku babay. ");
INSERT INTO mfh_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Dza uwana azuw mawaɗay la zagəla kà, azuw mawaɗay la kursi Sufəl aŋa zagəla, ŋgaha la masla uwana adz à ahəŋ la afik babay.” ");
INSERT INTO mfh_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ŋgərpa agay la akul, akul azlaməna matapla mapəhay, ŋgaha la akul azla Farisəya, akul azlaməna magolla dza, kavàw makulo aŋa tatak aŋkul, baməraka la azlatsəhay alàl anik anik gesina, ama kapəsewaw uwana aɗuwa à vok la mapəhay la abà, bokuba maɗehəŋ delga la tələmma, ŋgaha la madiŋal gəl à vok. Uwaga la uwana akəsà à vok kà makəsay la kokuɗa mapəsewaw azlaanik uwanay. ");
INSERT INTO mfh_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Akul azlaməna maguwàh azla­gu­ləf à huma, kazaɓaw slaslam à uda la tataka masay aŋkul la abà, ama zlugumi kà kadà­guwa à gay.” ");
INSERT INTO mfh_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ŋgərpa agay la akul, akul azlaməna matapla mapəhay, la akul azla Farisəya, akul azlaməna magolla dza, kapalaw lig aŋa kətsaw la azlakəslaɗ aŋkul, ama la huɗ aŋkul kà kahənawla la makəsa­fər dzəɓaŋŋa, ŋgaha la gəl la adi gesina. ");
INSERT INTO mfh_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kak zil Farisəya guləf gà, pàl huɗ kətsaw dadàŋ, ŋgaha lig gà adàgay kuze­kaka babay.” ");
INSERT INTO mfh_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ŋgərpa agay la akul, akul azlaməna matapla mapəhay, la akul azla Farisəya, akul azlaməna magolla dza. Akul kà bokuba akul azlazəvay uwana tawoɗəŋla, ahəɗ la lig gà, ama la huɗ gà kà, mahənlaga la azla­tatak mazinga vaŋvavaŋ. ");
INSERT INTO mfh_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Akul babay kà la lig gà kà, kapəhawla vok ala kà kiya uwaga: ‘Anu azladza delga’, kagoɗaw, ama la huɗ kà kahənawla la magolla dza ŋgaha la mawi­siga”, Yesu agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yesu ahàd à huma à gay la magoɗay: “Ŋgərpa agay la akul, akul azlaməna matapla mapəhay, la akul azla Farisəya, akul azlaməna magolla dza, kaŋa­làhàw zəvay aŋa azlaməna mapəh à atà gay à ahàl kà mapàhla à azladza ala kà lela. Kaɗahàw azla­tatak ɓə̀ɗà à azlazəvay aŋa azla­uwana à vok tadzà à ahəŋ la dziriga la abà. ");
INSERT INTO mfh_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","‘Aganay məgay la ahəŋ la zamana aŋa azla­baba gami madzi­dziga kà naka məɗàh sləray anina kà makaɗ azlaməna mapəh à atà gay à ahàl kà mapàh à azladza aw’, kagoɗaw aya. ");
INSERT INTO mfh_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","La gəl aŋkul kà, kasəlaw kà akul azla­mayyi à tsəh ala aŋa azladza uwana takàɗàh azlaməna mapəh à atà gay à ahàl uwaga. ");
INSERT INTO mfh_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kətà zlà kà, dàw à huma à gay kadəvawla sləray uwana à gay azla­baba aŋkul tadzəkà maɗehəŋ zla! ");
INSERT INTO mfh_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Akul azlabəza matsapa: ‘Kakay mədàtəf seriya aŋa gày akàl la gay ala?’, kagoɗaw ma!” ");
INSERT INTO mfh_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ŋgaha agòɗ aya: “Kà uwaga katsənàwwàŋ lela, gədà­sləl akul à azlaməna mapəh à atà gay à ahàl à waŋ, la azlaməna haŋkəliga, ŋgaha la azla­uwana tasəl mapəhay. Kadà­kaɗaw azlaanik, azlaanik aya kà, kadà­ta­taslaw atà à ahàf à adi, azlaanik kadà­zla­ɓahaw atà la kurpi la gày madəv kuɗa la aku, ŋgaha aya kadà­nəfahaw la gudəŋ la gudəŋ kà makaɗ atà. ");
INSERT INTO mfh_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kiya uwaga à uwana aŋiz aŋa azladza dziriga uwana takà­ɗàhàh atà dadzəka à vok la Abel, dza dziriga uwana takàɗ, tsəràh à makaɗ Zakari, kona aŋa Baraki uwana kakàɗàw la tataka aŋa azlagày tsi­ɗa­ŋaga à abà la slaka makaɗ tatak. ");
INSERT INTO mfh_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Haɗay, gəpəh à akul la dziriga kà, kà uwaga gesina adàtəɗay kà à gəl aŋa azladza aŋa zamana uwanay lakana.” ");
INSERT INTO mfh_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Uru­sa­lima, Uru­sa­lima, kak la uwana kakàɗ azlaməna mapəh à atà gay à ahàl uwana à gay, ŋgaha katsàh azla­uwana Zəzagəla aslala kà atà à waŋ la akur. Gəday vok kà mənga, kà maham gay à vok aŋa azladza aŋak la slaka gulo, bokuba gotsak uwana aham gay azlabəza aŋha à vok la tsəh gogozlàh aŋha, ama kakəsaw aw. ");
INSERT INTO mfh_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ŋgaha zla, lagwa kà, gày aŋkul adàgay ŋvagay. ");
INSERT INTO mfh_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","La kità gəpəh à akul kà: Dagay lakana kadànəŋaw gi aya tsəràh à uwana: ‘Məpis gay à vok à gay la dza uwana atsa à waŋ la sləm aŋa Sufəl’, kadà­goɗaw”, Yesu agòɗ. ");
INSERT INTO mfh_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kiya uwaga Yesu asà à lag la məŋ gày Zəzagəla la aku. Uwana adìy aŋha kà, azlaməna matapla la slaka aŋha tazà à vok à slaka aŋha kà mapəhalla maŋalay aŋa məŋ gày Zəzagəla uwatà. ");
INSERT INTO mfh_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kiya uwaga Yesu awùlla à uda, agòɗ à atà: “Kanəŋaw uwaga gesina takay? Haɗay gəpəh à akul la dziriga kà, amiyaka akur tekula babay kà adàgəɗal à gay aw, tadà­kalah à ahəŋ gesina.” ");
INSERT INTO mfh_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu adzà madzay la gudəŋ kuvu la afik, la abatà azlaməna matapla la slaka aŋha tazà à vok à slaka aŋha, tanàval à gay ala: “Pə̀hanula: Mbà uwaga adàpaka vok ma, masəlay ma uwala adàpəhanula kaslà mas à waŋ aŋak la makəɗ gəl à ahəŋ gudəŋ à vok la?” ");
INSERT INTO mfh_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu awùlla à atà ala: “Ɗahàw haŋkəli kà aŋa mapapatakulla aw. ");
INSERT INTO mfh_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kà uwana azladza aŋuvaw tadàsa à waŋ la sləm gulo, ŋgaha: ‘Gi Kristu!’, tadà­goɗay, ŋgaha tadà­va­varah azladza aŋuvaw à bada à abà. ");
INSERT INTO mfh_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kadàtsənaw azla­ma­wiyay aŋa guvəl, ŋgaha azlagay lakəl aŋa guvəl. Guba adàkəs akul aw, uwaga kà, say leri apaka vok, ama uwaga kà makəɗ gəl à ahəŋ gudəŋ à vok dadàŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Azladza tsəhay anik tadàp guvəl la azlatsəhay anik, ŋgaha makoray anik adàp guvəl la makoray anik, azlamay tadà­gahay la ahəŋ, ŋgaha azla­ma­ɓəlakàh vok aŋa kutso tadà­gahay la ahəŋ la azla­slaka anik anik. ");
INSERT INTO mfh_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ama azla­tatak uwaga gesina adàpaka vok kà bokuba madzəka mazay aŋa huɗ bəzi.” ");
INSERT INTO mfh_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Azladza tadàvàh akul à ahàl aŋa azladza anik kà matərəɓàh akul, ŋgaha tadà­kaɗah akul. Azlatsəhay gudəŋ à vok gesina tadà­pəsew akul kà uwana kawoyaw gi. ");
INSERT INTO mfh_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","La kaslà uwatà, azladza aŋuvaw tadàsak à madiŋal gəl à vok la tsəh ala, ŋgaha tadàtah à vok kaf à gəl, ŋgaha tadàzin vok à vok ala kà atà à àtà. ");
INSERT INTO mfh_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Azlaməna mapəh à atà gay à ahàl fida gà tadà­pahla vok ala la tataka aŋkul la abà, tadà­va­varah azladza anik aŋkul aŋuvaw. ");
INSERT INTO mfh_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mawi­siga la uwana adàsləh gəl à ahəŋ à kà delga, azladza gay məŋga tadà­waɗah vok à uda la uwaga la abà à kà delga. ");
INSERT INTO mfh_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ama dza uwana adà­basiŋ tsəràh à makəɗ gəl à ahəŋ la tetəvi aŋa Zəzagəla à ama kà, adàɓəlay. ");
INSERT INTO mfh_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Gay marabəŋ aŋa makoray Zəzagəla adàgay mapəhayga la gudəŋ la vok gesina, kà maziŋ gà à azlatsəhay gudəŋ à vok gesina. Baŋa ada­tsanay kiya uwaga kà, madəv à gay gudəŋ à vok adà­zla­ŋalay.” ");
INSERT INTO mfh_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Mok uwana kadànəŋaw masla məzam aŋa Kristu, uwana masla mapəhal gay à ahàl Daniyel apə̀h, à uwana atsìzl à slaka tsi­kasla gà à abà kà, (kəla dza uwana adzeŋ uwaga kà, aɗaha haŋkəli lela!) ");
INSERT INTO mfh_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kiya uwaga kà azla­uwana la kutso Yahu­diya kà, tadàhoy à gudəŋ à afik. ");
INSERT INTO mfh_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Dza uwana la gəl gày babay, adàsa à ahəŋ kà mad à gày kà mahəl azla­tatak uwana la huɗ gày aŋha aya aw. ");
INSERT INTO mfh_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ŋgaha dza uwana la fəta, adàwul à mtəga kà mahəl dəbdəbi aŋha la mtəga aŋha aw. ");
INSERT INTO mfh_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kay, ŋgərpa məŋga adàgay la azlamis uwana la bəza la huɗ, ŋgaha la azla­uwana bəza vərna aga la atà la ahàl la mavakay uwatà! ");
INSERT INTO mfh_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ɗə̀vàw kuɗa à Zəzagəla kà mavakay mawi­siga uwaga aŋa matəɗ à təla anasl à abà baŋaw à vuɗ maduw ləv à abà aw. ");
INSERT INTO mfh_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","La kaslà uwatà kà, ŋgərpa məŋga adàgay la ahəŋ uwana adapakà vok dagay uwana Zəzagəla aɗahà gudəŋ à vok tsəràh à lakana aw, uwana adàpaka vok bokuba uwaga aya ɗiki­ɗiki aw. ");
INSERT INTO mfh_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Agayŋa Zəzagəla atetuwà mavakay uwaga aw kà, naka dza la ahəŋ aɓəlay aw, ama Zəzagəla atetuwà mavakay uwaga kà, kà azlaaŋha uwana atsa­tsà­mànì atà.” ");
INSERT INTO mfh_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Baŋa ‘Kristu kà à aganay, la abanay, à agatày la abatày’, tagoɗ à akul kà, kakəsaw gay aŋatà aw. ");
INSERT INTO mfh_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kà uwana azlak­ristu fidaga, la azlaməna mapəh à atà gay à ahàl fida gà tadà­pa­hahla vok ala. Tadàɗah azla­magol nadzipo kà mava­varla azladza amiyaka bà azla­uwana Zəzagəla atsa­tsà­mànì atà. ");
INSERT INTO mfh_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tsə̀ɓàwwal sləm kà uwana gədapəh à akul à vok à abà.” ");
INSERT INTO mfh_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Kità kà, baŋa: ‘A agatày la kəsaf la abà, la abatày’, tagoɗ à akul kà, kadaw aw! Baŋaw dza agoɗ à akul: ‘Aganay adada à gày à abà la abanay’, tagoɗ à akul kà, kakəsaw gay aŋha aw. ");
INSERT INTO mfh_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bokuba habaga uwana awutsəɗ à uda la ləv zagəla la abà dagay la tsəh la ahəŋ tsəràh à gəl à agu kà, kiya uwaga à mas à waŋ aŋa Kona aŋa dza babay. ");
INSERT INTO mfh_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","La slaka uwana tatak mamətsayga la ahəŋ la uwana azla­kwa­tsamu tahàm gay à vok la abatà.” ");
INSERT INTO mfh_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“La katskats la lig mapak vok aŋa ŋgərpa uwaga la ahəŋ kà, afats adàuɗay aya aw, təla bay adàv uɗaka aŋha aya aw, azla­tse­tsiliŋ tadàsokw à ahəŋ la zagəla, ŋgaha ndzəɗa aŋa zagəla adàɓəlaka vok. ");
INSERT INTO mfh_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ŋgaha masəlay aŋa Kona aŋa dza adàpəhla vok ala la zagəla la afik. Kiya uwaga azladza à vəɗah gesina tadà­taway, tadànəŋ Kona aŋa dza atsa à ahəŋ la habaga la abà la ndzəɗa mazləɓay məŋga la zagəla. ");
INSERT INTO mfh_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Magol mapara məŋga adàtsənay, ŋgaha tadànəŋ azla­ma­lika la gay tər gudəŋ ufaɗ aŋa kutso, tadàham gay azla­uwana à vok atsa­tsà­mànì atà la azlagay tər gudəŋ à vok uwaga.” ");
INSERT INTO mfh_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Tsənàw uwana gudəv apəhakulla: Mok uwana gudəv agagəray baɓasl aŋha aɗay kà, sə̀làw kà madara kà nekwa. ");
INSERT INTO mfh_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kiya uwaga kà, baŋa kadànəŋaw uwaga gesina kà, sə̀làw kà, kaslà mas à ahəŋ aŋa Sufəl kà adaslay. ");
INSERT INTO mfh_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Haɗay, gəpəh à akul la dziriga kà: Kà azladza aŋa zamana uwanay tadà­məts à gay dadàŋ gesina, kà mas à waŋ aŋa makoray Zəzagəla aw. ");
INSERT INTO mfh_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Zagəla la kutso kà adàdəv à gay, ama gay gulo kà, adàdəv à gay aw!” ");
INSERT INTO mfh_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Dza la ahəŋ asəl kaslà la mavakay, baŋaw sa aŋa mapaka vok aŋa tatak uwaga aw, amiyaka azla­ma­lika uwana la zagəla, amiyaka Kona aŋha babay aw, say Baba kokuɗa gəl aŋha pəra la uwana asəl. ");
INSERT INTO mfh_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tatak uwana apakà vok la zamana aŋa Nuhu kà, adàpaka vok kalkal la uwaga aya à mok uwana Kona aŋa dza adàsa à waŋ. ");
INSERT INTO mfh_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","La kità, à mok uwana mavakay aŋa iyaw, uwana azà dza ala, aləg à waŋ kà, azladza tazùw, tasàh tatak, tazàɓ mis, tadàh à zil tsəràh à mavakay uwana Nuhu adà à kəslah iyaw à abà. ");
INSERT INTO mfh_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tadzùgw tatak ɗiki­ɗiki tsəràh à uwana iyaw asà à waŋ, azàtàla gesina aw. Kiya uwaga adà­pakay la vuɗ mas à waŋ aŋa Kona aŋa dza babay. ");
INSERT INTO mfh_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","La kità, azladza səla tadàgay la fəta, tekula adàgay mazəɓay gà, anik adàgay masakal gà. ");
INSERT INTO mfh_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Azlamis səla tadàdzam vəl, tekula adàgay mazəɓay gà, anik adàgay masakal gà. ");
INSERT INTO mfh_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Dzàw à ahəŋ la adi, kà uwana kasəl aw mavakay uwana Kona aŋa dza adàsa à waŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tsə̀ɓàw sləm à uwanay lela: Aŋa zil gày asəl kaslà uwana masla à gəl atsa à waŋ kà mazləl gày aŋha la vəɗ kà, adzehal aw, ahən à ahəŋ la adi kà masla gəl aŋa mad à gày aŋha aw. ");
INSERT INTO mfh_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kà uwaga: Ɗahàw vok à ahəŋ, akul babay, kà uwana Kona aŋa dza adàsa à waŋ kà la kaslà uwana manəwəŋ aŋkul lakəl aw.” ");
INSERT INTO mfh_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Uwa à magamza dziriga uwana la haŋkəli gà uwa? Uwaga kà dza uwana məŋga aŋha afà à gəl aŋa azlaməna sləray anik, kà masla aŋa mavàha à atà tatak may la sa uwana asà à atà. ");
INSERT INTO mfh_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Marabay agay la magamza uwana məŋga aŋha awul à waŋ, aɓəzal à gəl la sləray aŋha la abà. ");
INSERT INTO mfh_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Haɗay, gəpəh à akul la dziriga: Zil gày adàv ləmana à magamza aŋha uwanay à ahàl gesina. ");
INSERT INTO mfh_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ama baŋa magamza uwaga mawi­siga kà, agoɗay la gəl aŋha kà: Məŋga gulo kà adà­safay, ");
INSERT INTO mfh_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","adzəka mazlaɓàh azla­ma­nalzay aŋa sləray, ŋgaha azuway la azlaməna guzu, ");
INSERT INTO mfh_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","kiya uwaga zil gày adà­zla­ŋalay la vuɗ uwana magamza uwaga la makuday la abà aya amiyaka aŋa sa tekula aw. ");
INSERT INTO mfh_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Zil gày adà­ɗahla seriya zla­zla­ɗaga à gəl, ŋgaha adàvàl masik aŋha kà la tataka aŋa azlaməna magolla dza la abà, la abatà la uwana adà­tuway, la mapaɗ sliɗ la tsəh ala tərra­wawa”, Yesu agòɗ. ");
INSERT INTO mfh_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Kiya uwaga makoray Zəzagəla kà kalkal la gay aŋa azladəgam kulo uwana tasà à uda, tahə̀l fənəs aŋatà, tahàd kà maga­gamay la masla mazəɓ mis. ");
INSERT INTO mfh_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Azladəgam zlo la tataka aŋatà la abà kà, azla­ku­soŋu gà. Azlazlo anik uwanay kà, azlaməna masəl gəl gà. ");
INSERT INTO mfh_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Azla­ku­so­ŋuga uwaga tahə̀l fənəs aŋatà kokuɗa matəɗani amàl à koloba à agu kà madla la ahàl. ");
INSERT INTO mfh_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ama azla­ma­səl gəl gà uwanay kà tada­təɗani amàl à koloba à agu, tadàla la ahàl gesina la fənəs aŋatà. ");
INSERT INTO mfh_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hay, masla mazəɓ mis asàf kà mas à waŋ, azladəgam kulo uwaga tadzehàl.” ");
INSERT INTO mfh_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“La tataka vəɗ mawiyay atsə̀n: ‘Masla mazəɓ mis vok ada­zla­ŋalay, sàw à afik, məgàgàm la masla zla!’ ");
INSERT INTO mfh_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kiya uwaga azladəgam kulo uwaga tatsànla, ŋgaha tavà­tsàhà fənəs aŋatà. ");
INSERT INTO mfh_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Azla­ku­so­ŋuga uwanay tagòɗ à azla­ma­səl gəl gà uwanay: ‘Kamkam, dzè­slàhàw à anu amàl aŋkul, kà uwana fənəs gami adà­ma­tsahla, səlew­k se­səlewk tsi!’ ");
INSERT INTO mfh_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Azla­ma­səl gəl gà tagòɗ à atà: ‘Awaŋ, adàsla anu aw, dàw à kanti à agu, kadà­sukwaw!’ ");
INSERT INTO mfh_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kiya uwaga azla­ku­so­ŋuga uwaga tahàd kà masukw amàl la kanti, ama la sa uwaga masla mazəɓ mis asà à waŋ, azladəgam zlo masəl gəl gà uwatà tadà à gày la slaka gà, à gày mazəɓ vok à agu, kà uwana tagà nekwa, ŋgaha tatsàk à gamagày à ama la tsəku­rəm tərrəzl. ");
INSERT INTO mfh_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Zewk, la huma la gay, azladəgam anik uwanay tasà à waŋ, tadzəkà maza­lahay: ‘Məŋga, pə̀zl à anu gamagày!’ ");
INSERT INTO mfh_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ama masla mazəɓ mis agòɗ à atà: ‘Haɗay, gəgoɗ à akul la dziriga: Tetuwa gəsəl akul aw!’ ” ");
INSERT INTO mfh_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu azàlàŋ à gəl, agòɗ à atà: “Dzàw à ahəŋ la adi, kà uwana kasəlaw mavakay, amiyaka sa uwatà aw!” ");
INSERT INTO mfh_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Adagay kalkal la dza uwana ad à mau­gu­zahay. Azàlàh azla­ma­gamza aŋha, aɓə̀k à atà à gəl aŋa tatak aŋha gesina. ");
INSERT INTO mfh_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Anik aŋatà avàl gursu dəbow, à anik aya gursu dadərmokw ufaɗ, à mamakər gà avàl gursu dadərmokw səla. Avà à atà la kəla ndzəɗa aŋa dza suwaŋ, ŋgaha la lig la ahəŋ adà aŋha à mau­gu­zahay. ");
INSERT INTO mfh_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Magamza uwana aɓəzà gursu dəbow, ahàd, atsà­kàlla, ŋgaha aɓə̀zal riba aŋa gursu dəbow anik aya. ");
INSERT INTO mfh_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Masla aŋa maɓəzal gursu dadərmokw ufaɗ aɗahàŋ kiya uwaga babay suwaŋ, ŋgaha aɓə̀z riba aŋa gursu dadərmokw ufaɗ anik aya. ");
INSERT INTO mfh_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ama dza uwana aɓəzà gursu dadərmokw səla, ahàd, alà à afək à uda, ŋgaha ahàɗ à sili uwatà à agu məŋga aŋha avàl.” ");
INSERT INTO mfh_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Uwana ada­safay məŋga kà, məŋga aŋatà awùl à waŋ la mau­gu­zahay, ŋgaha adzà madzay, kà matugway lakəl aŋa sili aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Magamza uwana aɓəzà gursu dəbow atsà à vok à waŋ à slaka məŋga aŋha, apə̀hal gursu dəbow anik uwana ayyà à tsəh. ‘Məŋga, kavà à gi kà gursu dəbow tekula, təga aw uwà ay? Nə̀ŋàŋ tsi, aganay gursu dəbow uwaga ayyà à tsəh ala gursu dəbow anik aya.’ ");
INSERT INTO mfh_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Məŋga aŋha agòɗal: ‘Delga, kak magamza dziriga, kagà dziriga la azlabəza tatak deyday gà la abà, gədàfa à ka à gəl aŋa azla­tatak uwana aga la ndzəɗa, sà à waŋ à marabay gulo à abà.’ ");
INSERT INTO mfh_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Magamza uwana aɓəzà gursu dadərmokw ufaɗ, azà à vok à awtày babay, agòɗ: ‘Məŋga, kavà à gi gursu dadərmokw ufaɗ aw uwà ay? Nə̀ŋàŋ, aganay dadərmokw ufaɗ anik uwana ayyà à tsəh.’ ");
INSERT INTO mfh_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Məŋga aŋha agòɗal: ‘Delga, kak magamza dziriga, kagà dziriga la azlabəza tatak dey­dayga la abà, gədàfa à ka à gəl aŋa azla­tatak məŋga gà. Sà à waŋ à marabay gulo à abà.’ ");
INSERT INTO mfh_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","La lig la ahəŋ magamza uwana aɓəzà à gursu dadərmokw səla azà à vok à awtày, agòɗ: ‘Məŋga gulo, gəsəl kà kak dza dzaŋ­d­zaŋga. La guf uwana la abà kasləkà tatak à abà babay aw kà, katsəɗay, ŋgaha la guf uwana la abà kasləkà aw kà, kalay. ");
INSERT INTO mfh_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Guba akə̀s à gi kà uwaga à uwana, gəhàd, gəlà sili aŋak uwaga à afək à agu. Nə̀ŋàŋ, aganay à tatak aŋak!’ ");
INSERT INTO mfh_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Məŋga aŋha awulàlla: ‘Kak magamza mawi­siga, ŋgaha masaga, kasəl kà gətsəɗay ŋgaha gəlay la guf uwana la abà gəsləkà aw, kagoɗ, ààà?! ");
INSERT INTO mfh_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kà mana kafà sili gulo à gày makal goder aw, naka mok uwana gədawul à waŋ kà naka gəday, gəhəl sili la iyaw la tsəh la abatà aw ma? ");
INSERT INTO mfh_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Hə̀làwla gursu dadərmokw səla gà uwaga ala, ŋgaha ɓə̀kàw à dza aŋa gursu dəbow à vok. ");
INSERT INTO mfh_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kà uwana kəla dza uwana akoray kà, tadà­vàlla à vok, ama dza uwana akoray aw kà, bà bəzi gà uwatà agà la ahàl kà, tadàdəval à ahàl ala aya. ");
INSERT INTO mfh_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ama magamza mawi­siga uwaga kà dùwàw à uda à mələs à abà, la abatà matuway la mapaɗ sliɗ adàpaka vok!’ ” ");
INSERT INTO mfh_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Mok uwana Kona aŋa dza adàsa à ahəŋ mas Sufəl Sufəl, la azla­ma­lika aŋha gesina kà, adàdza à kursi mazləɓay aŋha à afik. ");
INSERT INTO mfh_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Azlatsəhay gudəŋ à vok gesina tadàham gay à vok la huma aŋha, ŋgaha adàvàh azladza ala, bokuba uwana masla manəŋla azla­tatak avàh azla­tuwaŋ ala la azlaawàk. ");
INSERT INTO mfh_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Adàɓək azla­tuwaŋ à ahàl kaf aŋha à gəl, ŋgaha azlaawàk à ahàl gudzay aŋha à gəl. ");
INSERT INTO mfh_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kiya uwaga Sufəl adà­goɗay à azla­uwana la ahàl kaf aŋha lakəl: ‘Sàw à waŋ akul uwana Baba gulo adapis akul gay à vok, ŋgaha ɓə̀zàw à makoray uwana aga maɗa­ha­kullaŋ à ahəŋ gà dagay madzəka gudəŋ à vok. ");
INSERT INTO mfh_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kà uwana may azà à gi, kavàw à gi tatak may, nəlay akə̀s à gi, katə̀ɗàw gi iyaw gəsà, gəgà məlok gà, kakə̀sàw gi la ahàl səla. ");
INSERT INTO mfh_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Gəgà la godega deyday, kadùwàw à gi lukut à vok, gəgà la ɗuvats gà, kasàw à waŋ kà manəŋ gi à gày la à gi sləm, gəgà la daŋay, kasàw waŋ kà manəŋ gi à gày.’ ");
INSERT INTO mfh_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Kiya uwaga azladza uwana azla­dzi­riga taulàlla: ‘Sufəl, mbà mənəŋà ka la may gà, ŋgaha məvà à ka tatak may baŋaw la nəlay gà ŋgaha mətə̀ɗ à ka iyaw masay ma? ");
INSERT INTO mfh_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Mbà mənəŋà ka kak məlok gà, ŋgaha məkə̀s kà la ahàl səla, baŋaw mənəŋà ka la godega deyday ŋgaha məduwà à ka lukut à vok ma? ");
INSERT INTO mfh_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Mbà mənəŋà ka ɗuvats azà ka, mbà la daŋay maslà mədà à awtày kà manəŋa ka à gày la?’ ");
INSERT INTO mfh_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Sufəl awulla à atà ala: ‘Haɗay, la dziriga gəpəh à akul: Uwana kaɗa­hà­hàwwàŋ à tekula la tataka azlabəza uwanay la abà gesina kà, uwaga kà, kaɗa­hàwàŋ kà gi!’ ” ");
INSERT INTO mfh_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ŋgaha la lig la ahəŋ Sufəl adàgoɗ à azla­uwana la ahàl gudzay aŋha: ‘Zàw gi à vok, akul uwana Zəzagəla adà­tsafla akul! Dàw à akàl uwana à abà adàmats ala aw uwana maɗehəŋ à ahəŋ gà, kà aŋa seteni la azla­ma­lika aŋha gesina! ");
INSERT INTO mfh_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kà uwana may azà à gi, kavàw à gi tatak may aw, nəlay akə̀s à gi, katə̀ɗàw à gi iyaw gəsà aw, ");
INSERT INTO mfh_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","gəgà məlok gà, ama kakə̀sàw gi aw, gəgà la ɗuvats ŋgaha gəgà la daŋay kafàw gi sləm babay aw.’ ");
INSERT INTO mfh_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Kiya uwaga taulàlla: ‘Sufəl, mbà mənəŋà ka la may gà baŋaw la nəlay gà, baŋaw kagà məlok gà, baŋaw la godega deyday, baŋaw la daŋay ŋgaha maslà məzlakà ka aw la?’ ");
INSERT INTO mfh_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Sufəl awulla à atà ala: ‘Haɗay, gəpəh à akul la dziriga: Kəla tatak uwana kaɗa­hà­hàwwàŋ à azla­bəzaga uwanay gesina kiya uwaga aw kà, bà kaɗa­hà­hàwwàŋ à gi babay aw.’ ");
INSERT INTO mfh_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kiya uwaga tadàdala atà à seriya uwana à abà adàdəv à gay aw. Ama azladza dziriga kà tadàɓəz sifa uwana adəv à gay aw”, Yesu agòɗ zlà. ");
INSERT INTO mfh_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Haɗay, mok uwana Yesu adadəvla gay aŋha à gay kà, agòɗ à azlaməna matapla la slaka aŋha: ");
INSERT INTO mfh_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Sə̀làw kà madəvaday uwana sləm aŋha Paska adàgay la ahəŋ la mahənay səla la abà, ŋgaha tadàv Kona aŋa dza à ahàl aŋa azladza kà mata­tasl à ahàf à adi.” ");
INSERT INTO mfh_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kiya uwana azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla, la azla­ma­siga aŋa azla Yahu­diya tahamà gay à vok la mtəga aŋa Kayyif, məŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Takə̀s matsən vok gay la gəl la gəl, kà makəs Yesu, ŋgaha kà makəɗay. ");
INSERT INTO mfh_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tagoɗ: “Məslala vok kà makəsay la madəvaday la abà aw, kà uwana maham à ahəŋ dza adà­vədzahla”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Mok uwana Yesu la Be­ta­niya, la mtəga aŋa Səmon masla akàl zagəla uwatà kà, ");
INSERT INTO mfh_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","mis anik asà à waŋ à slaka aŋha la dərew amàl la ahàl mahənlaga la amàl matərsin zla­zla­ɗaga. Adzadzàɓ amàl matərsin uwatà à Yesu à gəl la mok uwana tazùw kaf. ");
INSERT INTO mfh_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Uwana azlaməna matapla la slaka aŋha tanəŋà uwaga kà, gəl akàɗ à atà à vok, tagòɗ: “Kà mana awìs tatak ala kiya uwanay ma? ");
INSERT INTO mfh_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Agayŋa avà à anu amàl matərsin uwaga tsa­kalay aŋha zla­zlaɗa: məduw ala, kà mav sili gà à azlaməna kuɗa, kà ŋuləm.” ");
INSERT INTO mfh_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu kà asə̀l uwana tapəhay, agòɗ à atà: “Kà mana katərəɓaw mis uwaga ma? Kà uwana aɗa­hà­gəŋ kà dzəɓa aŋha səla aw? ");
INSERT INTO mfh_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kà uwana azlaməna kuɗa tadàgay la ahəŋ koksi­koksi, ama gi kà mədàgay la ahəŋ anina koksi­koksi aw. ");
INSERT INTO mfh_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kà uwana amàl uwanay adzadzàɓ à gi à vok kà, maɗàh amàl à mazim­nekiɗ uwana à vok kà mazəɓ à uda. ");
INSERT INTO mfh_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Haɗay, gəpəh à akul la dziriga: Kəla slaka, uwana dza adàpəh gay matsi­ɗayga uwanay la gudəŋ la vok gesina kà, tadà­pahay lakəl aŋa uwana mis uwanay aɗahàŋ, kà mis uwanay aŋa mawul à atà à gəl.” ");
INSERT INTO mfh_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mok uwana uwaga adada à lig kà, tekula la tataka azlaməna matapla kulo gəl aŋha səla uwaga la abà, uwana sləm aŋha Yudas Iska­riyot, ahàd kà maɓəz à azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla à vok, ");
INSERT INTO mfh_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","agòɗ à atà: “Mana kadàvàw à gi, à baŋa gəfa à akul Yesu à ahàl ma?” Ŋgaha tatùgwal gursu dzik makər à ahàl. ");
INSERT INTO mfh_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Dagay la mok uwatà Yudas ayàh tetəvi kà maf à atà Yesu à ahàl. ");
INSERT INTO mfh_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","La mavakay teraŋa aŋa madəvaday pain uwana kokuɗa tatak makəsliŋ, azlaməna matapla tasà à waŋ, tanàv à Yesu: “Lala asa à ka məday kà maɗàh tatak madəvaday Paska à ahəŋ la?” ");
INSERT INTO mfh_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kiya uwaga Yesu agòɗ à atà: “Dàw à huɗ gudəŋ à abà à slaka dza uwahà: Məŋga agoɗ à ka, ‘Kaslà gulo adaslay kà gi aŋa mazuw tatak may aŋa Paska la azlaməna matapla gulo la mtəga aŋak’, agoɗ, gòɗàwwal.” ");
INSERT INTO mfh_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Azlaməna matapla tahàd, taɗahà uwana Yesu apə̀h à atà à ahàl, ŋgaha taɗahà tatak may aŋa madəvaday Paska à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mok uwana mokokhu adasa à waŋ kà, Yesu adzà à tatak may à adi la azlaməna matapla la slaka aŋha kulo gəl aŋha səla uwatà. ");
INSERT INTO mfh_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mok uwana tazùw tatak may, Yesu agòɗ à atà: “Haɗay, gəpəh à akul la dziriga, tekula aŋkul adàta à gi kaf à gəl.” ");
INSERT INTO mfh_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Uwaga aɓə̀k mazawla à gəl à azlaməna matapla məŋga, tadzəkà mana­vahal la tekula, tekula: “Sufəl, gi zlàk uwà, gi zlàk uwà?”, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu awùlla à uda, agòɗ à atà: “Dza uwana mədəɓ ahàl à kaf à gəl anu səla la kəslaɗ la abà, la uwana adàta à gi kaf à gəl. ");
INSERT INTO mfh_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Haɗay, Kona aŋa dza adàmətsay la tsəhay gà uwana matse­tseray, apəhay la wakità la abà lakəl aŋha, ama ŋgərpa adàgay la dza uwana adàta kaf à Kona aŋa dza à gəl! Agayŋa tayyay aw kà, naka ŋuləm kà aŋha.” ");
INSERT INTO mfh_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudas masla matal kaf à gəl, uwaga agòɗ la manavay: “Məŋga, gi la magay zlàk uwà?” Yesu awulàlla, agòɗal: “Kak Yudas, kapə̀h!” ");
INSERT INTO mfh_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","La mok uwana tazùw tatak may, Yesu azə̀ɓ kaf, “Kikay”, agòɗ à Zəzagəla, atsakàŋ ala, avà à azlaməna matapla la slaka aŋha la magoɗay: “Uwanay kà vok gulo, zə̀ɓàw, kazùwwàw!” ");
INSERT INTO mfh_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ŋgaha azə̀ɓ kətsaw mahənla gà la tatak masay gà, “Kikay”, agòɗ à Zəzagəla, avà à atà la magoɗay: “Sàw uwaga gesina aŋkul, ");
INSERT INTO mfh_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kà uwana uwaga kà aŋiz gulo, aŋiz makəs vok slawda, uwana masokw à vəɗah gà, kà aŋa azladza aŋuvaw, kà maɓəz mama­tsila tsakana. ");
INSERT INTO mfh_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Gəpəh à akul uwaga la dzahhà: Dagay lakana gədàsay iyaw mayyay ahàf uwanay aw, tsəràh à uwana mədàsay anina la makoray aŋa Baba gulo aya.” ");
INSERT INTO mfh_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","La lig aŋa mahab mahabay mazləɓay à gay, tadà aŋatà à gudəŋ kuvu à afik. ");
INSERT INTO mfh_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kiya uwaga Yesu agòɗ à azlaməna matapla la slaka aŋha: “La huɗ aŋa vəɗ uwanay lakana kà, kadà­sakaw gi à ahəŋ gesina aŋkul, bokuba uwana mədzeŋay la matse­tseray la abà: ˈGədà­kəɗ masla manəŋla azla­tuwaŋ, ŋgaha maham à ahəŋ tuwaŋ gesina adàsləh gəl à ahəŋ.ˈ ");
INSERT INTO mfh_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ama mok uwana gədàwul à uda kà, gədà­tsəvokay kà akul à Galili.” ");
INSERT INTO mfh_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piyer agòɗal: “Amiyaka azladza anik gesina tasàk à kak à ahəŋ kà, gi kà, gədàsak à ka à ahəŋ tetuwa aw!” ");
INSERT INTO mfh_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu awulàlla: “Haɗay, gəpəh à ka la dziriga: Bà la vəɗ uwanay kà, gurayŋa mew­g­dza­galaŋ awiyay kà, kadà­goɗay asik makər, kà kasəl gi aw, kà uwaga Piyer.” ");
INSERT INTO mfh_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piyer agòɗal: “Ɗi­ki­ɗiki: Gəsəl kak aw, gədà­goɗay aw, amiyaka bà makits aga à gi la kuda bay!” Azlaməna matapla uwana la slaka aŋha tapə̀h bokuba aŋa Piyer uwaga babay. ");
INSERT INTO mfh_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kiya uwaga Yesu abə̀z à slaka anik à abà uwana sləm aŋha Ge­tse­mane, ŋgaha agòɗ à azlaməna matapla aŋha: “Aga, gəday, gədàdəv kuɗa la abatày kà, dzàhàw madzay la abanay.” ");
INSERT INTO mfh_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Adàla Piyer, ŋgaha azlabəza aŋa Zebede səla la tsəh, adzəkà maskulay la mazaw la gəl. ");
INSERT INTO mfh_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Agòɗ à atà: “Ləv gulo adahənla la mazaw la gəl aŋa mamətsay, dzàw à ahəŋ la abanay, dzàw à ahəŋ la adi kiya gi.” ");
INSERT INTO mfh_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Masla adànì kərkər zewk, atsòŋ gəl à ahəŋ, ŋgaha adə̀v kuɗa la kiya uwanay: “Baba gulo, agayŋa uwanay aɓəz à vok kà naka, kazəɓgəŋ kətsaw ŋgərpa uwanay ala, amiyaka bà la uwaga babay kaɗahaŋ bokuba uwana asa à ka, awkà bokuba uwana asa à gi aw!” ");
INSERT INTO mfh_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","La lig la ahəŋ awul à waŋ à slaka azlaməna aŋha makər uwaga, aɓə̀z atà à gəl kà tadzehal. Agòɗ à Piyer: “Kaslawwalla vok kà madz à ahəŋ la adi la gi, amiyaka sa tekula aw uwà? ");
INSERT INTO mfh_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Dzàw à ahəŋ la adi, də̀vàw kuɗa kà akul aŋa matəɗ à mapa­patay à abà aw. Masasəɗok aŋa dza asal manəfay nəma, ama vok kà guɓguɓ.” ");
INSERT INTO mfh_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Azà à atà vok la vok ala kà masəla, ŋgaha adə̀v kuɗa kiya uwanay: “Baba gulo, baŋa akəs à vok kà kətsaw uwanay azəɓ vok à uda kiya uwanay aw, sàk à gi kà gi aŋa mas à uda la abà, ŋgaha masal aŋak apaka vok zla.” ");
INSERT INTO mfh_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Masla awùl à waŋ aya à slaka azlaməna matapla aŋha uwaga, aɓə̀z atà à gəl kà tadzehàl aya, taslàlla vok aŋa madz à ahəŋ la adi aw. ");
INSERT INTO mfh_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesu azà à atà vok la vok ala aya kà mamakər, adə̀v kuɗa la kiya uwana uwarà. ");
INSERT INTO mfh_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","La lig la ahəŋ, awùl à waŋ à slaka aŋatà, agòɗ à atà: “Kadzewhal gotənaŋ, kaduwaw ləv aŋkul pəra ay? Nə̀ŋàwwàŋ sa kà adaslay adagay, ŋgaha Kona aŋa dza adagay mavàyga à ahàl aŋa azlaməna tsakana. ");
INSERT INTO mfh_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Sàw à afik, məhàd! Dza uwana adata à gi kaf à gəl kà aganay la abanay!” ");
INSERT INTO mfh_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ŋgaha bokuba uwana Yesu à lig la maɓaɗma la abà, à mok uwana Yudas, tekula la tataka azlaməna matapla kulo gəl aŋha səla la abà, asà à waŋ la maham à ahəŋ dza aŋuvaw la tsəh, katsakar la azlaazəva agà à atà la ahàl. Azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla, la azla­ma­siga aŋa azla Yahu­diya la uwana taslə̀l atà à waŋ. ");
INSERT INTO mfh_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudas, uwana adata kaf à Yesu à gəl apə̀h à atà uwana à vok à abà, adà­ɗe­həŋ kà mapəhatàla Yesu: “Lagwa kà, dza uwana gədàkəs vok kà, masla gà la uwaga à uwana kayahaw, kadà­va­la­hawka pəra”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yudas azà à vok à slaka Yesu la katskats: “Ayyi, məŋga gulo”, agòɗal, la makəs à vok. ");
INSERT INTO mfh_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu agòɗal: “Slawda, uwana kasà à waŋ kà maɗehəŋ kà, ɗahàŋ katskats!” Kiya uwaga azladza anik tasà à waŋ, tavà­làhàka Yesu, takə̀s. ");
INSERT INTO mfh_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tekula uwana agà la Yesu aɓə̀ɗ katsakar aŋha à uda, ŋgaha aɗə̀ɗla magamza aŋa məŋ madza­haga, anàtsal sləm lakəl ala. ");
INSERT INTO mfh_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu agòɗal: “Kay, wùlla katsakar aŋak à gày aŋha à agu, kà uwana azladza uwana tahəl katsakar kà, tadàkaɗ atà la katsakar babay. ");
INSERT INTO mfh_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kasəl kà aŋa asa à gi kà gəzal à Baba gulo kà mazlak gi aw takay, ŋgaha asləl gi azla­ma­lika à ahəŋ maŋəla­ŋəl kulo gəl aŋha səla aw takay? ");
INSERT INTO mfh_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ama baŋa kiya uwaga ma kakay à uwana tatsetsèr à wakità à abà, agəɗ à afik ma? Kà uwana wakità agoɗ kà: Say uwanay adàpaka vok kiya uwanay, agoɗ.” ");
INSERT INTO mfh_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ŋgaha Yesu agòɗ à maham à ahəŋ dza: “Kasàw à waŋ kà makəs gi la azla­ka­tsakar, la azlaazəva la ahàl bokuba gi masla nabəra takay? Kəla mavakay gədzàhà madzay la məŋ gày Zəzagəla la aku kà matapla tatak à azladza, uwala kakə̀sàw gi aw! ");
INSERT INTO mfh_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ama uwaga gesina apakà vok kà gay aŋa masla mapəhal gay à ahàl uwana la wakità la abà aŋa magəɗ à afik.” Ŋgaha azlaməna matapla tasàkal à ahəŋ, tahòy aŋatà gesina. ");
INSERT INTO mfh_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Azladza uwana takə̀s Yesu, tadàla masla à huma aŋa Kayyif, məŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla, la azlaməna mapàhla mapəhay ala, la azla­ma­siga uwana tahamà gay à vok la abatà. ");
INSERT INTO mfh_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piyer anəfà Yesu la tsəh makəda kəda. Tsəràh à gəl akàl aŋa məŋ madza­haga, adà à gày, adzà madzay la slaka aŋa azla­manəŋla, kà manərəz tatak uwana apaka vok la Yesu. ");
INSERT INTO mfh_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla, la azla­ma­siga aŋa gudəŋ tayàh mapuw gudzi à Yesu à gəl, amiyaka bà la fida uwala beyli, kà maɓəzal à tsəh kà makəɗay. ");
INSERT INTO mfh_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ama taɓə̀zal aw, amiyaka bà la uwala beyli, bà la abatà azladza tasàhla azlagay deyday gà à waŋ lakəl aŋha. Bà la kità babay azladza səla tapəhla vok ala. ");
INSERT INTO mfh_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Tagòɗ: “Dza uwanay agoɗ kà: ‘Gəslala vok, gəkalàh məŋ gày Zəzagəla uwanay à ahəŋ, ŋgaha gəwulla à afik la mahənay makər la abà’, agòɗ.” ");
INSERT INTO mfh_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Məŋ madza­haga asà à afik, agòɗ à Yesu: “Kawulla gay à uda aw takay? Mana à uwanay azladza uwanay tapəhay lakəl aŋak tak ma?” ");
INSERT INTO mfh_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ama Yesu adzà à ahəŋ titi. Məŋ madza­haga uwaga agòɗal aya: “La sləm aŋa Zəzagəla uwana la sifa, kamkam wùlla gay à uda: Ma kak, Kristu Kona aŋa Zəzagəla takay?” ");
INSERT INTO mfh_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu awulàlla: “Iyay, bokuba uwana kapə̀h. Ŋgaha aya gəpəh à akul la dziriga: Dagay lakana kadànəŋaw Kona aŋa dza adàdza madzay la ahàl kaf aŋa Zəzagəla lakəl la ndzəɗa, kadà­nəŋawwaŋ adàsa à ahəŋ la habaga la abà babay.” ");
INSERT INTO mfh_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kiya uwaga məŋ madzahaga akwàhà lukut aŋha à vok agòɗ: “Apə̀h mawi­siga à Zəzagəla à vok, asà à anu azlaməna sayda anik aya aw, katsənàw uwana adapəhay lakəl aŋa Zəzagəla təga aw way? Mana kadzugwaw aya ma?”, agòɗ. ");
INSERT INTO mfh_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","“Azlayla kà, say makəɗay pəra!”, azlaməna matsəɓal sləm tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ŋgaha tadzəkà matafal slesliɓ à adi, azlàɓ la mamits à ahàl, azlaanik tazlàɓ à paŋaw à abà, ");
INSERT INTO mfh_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","tagòɗal: “Pə̀hanula dza uwana aɗə̀ɗ ka, à baŋa kak Kristu zla!” ");
INSERT INTO mfh_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piyer adzà madzay la uda la gəl akàl. Magamza misga aŋa məŋ madza­haga azà à vok à slaka aŋha, agòɗal: “Kak babay kà, kadzàw à ahəŋ la Yesu zil Galili uwaga.” ");
INSERT INTO mfh_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ama Piyer aɗahà fida la huma aŋa azladza gesina la magoɗay: “Gi kà, gəsəl uwana asa à ka mapəhay aw!” ");
INSERT INTO mfh_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kiya uwaga asà à afik la abatà, azà à vok à gay gamagày. Magamza misga anik, anəŋàŋ aya, ŋgaha agòɗ à azlaməna madz à ahəŋ la abatà: “Iyay, dza uwanay kà adzà à ahəŋ la Yesu zil Nazaret.” ");
INSERT INTO mfh_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ama Piyer aɗahà fida kà masəla la magoɗay aya: “Zagəla, gəsəl dza uwaga kapəhaw aw!” ");
INSERT INTO mfh_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mok uwana tasà­fànì aya, azladza uwana la abatà la slaka Piyer, tazà à vok à slaka aŋha, tagòɗal: “Ndzer kà, kak tekula aŋatà, məsəl ka la kuda aŋak la abà, à slaka uwana kasà à waŋ la abà.” ");
INSERT INTO mfh_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kiya uwaga Piyer adzəkà magoɗay: “Baŋa fida gəpəhay kà, Zəzagəla aɗahà à gi seriya à gəl. Gədà­zuwa à akul mawaɗay kà, gəsəl dza uwaga aw, gəgòɗ à akul, aw takay?” Apə̀h uwatà la gay ala, tsatsokw yokwyokw mew­g­dza­galaŋ ada­wiyay. ");
INSERT INTO mfh_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ŋgaha awùl à Piyer à gəl à gay uwana Yesu apə̀hal: “Gurayŋa mew­g­dza­galaŋ adà­wiyay asik makər kà, kasəl gi aw, kadà­goɗay Piyer!”, Piyer asà à uda, atùw la iyaw tugwi. ");
INSERT INTO mfh_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mok uwana uwaga adada à lig kà, bəŋ la zay la tsəh, azla­ma­dza­haga, la azla­ma­siga takə̀s sawaray la slaka gà kà makəɗ Yesu. ");
INSERT INTO mfh_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tawaɗàŋ, tadàla, tavà à Pilatus gumna aŋa azla Rom à ahàl. ");
INSERT INTO mfh_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mok uwana Yudas masla mat kaf à Yesu à gəl anəŋàŋ kà, seriya adàtəɗ à Yesu à gəl kà, awùlla sili gursu dzik makər uwaga à slaka azla­ma­dza­haga, la azla­ma­siga. ");
INSERT INTO mfh_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Agòɗ à atà: “Gəɗahà tsakana, kà uwana gətà kaf à dza uwana à gəl kokuɗa tsakana”, agòɗ. Ama tagòɗal: “Anu kà, gay gami la abà aya aw. Uwaga adagay kà aɓəz ka à kak pəra!” ");
INSERT INTO mfh_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudas adùw sili uwaga à məŋ gày Zəzagəla à agu. La lig la ahəŋ, ahàd, akə̀ɗ vok aŋha la madə̀ɓ vok aŋha à zagəla. ");
INSERT INTO mfh_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Azla­ma­dza­haga tazə̀ɓ sili uwaga, tagòɗ: “Makoray gami avà tetəvi kà mazəɓay sili uwanay kà maf à sahar aŋa gày Zəzagəla à agu aw, kà uwana uwanay kà sili aŋa aŋiz.” ");
INSERT INTO mfh_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mok uwana tatsə̀n vok gay la tataka aŋatà la abà lakəl aŋha kà, tasùkw guf aŋa masla maŋalàh tatak la sili uwatà, kà atà aŋa malàh azlaməlok dza à abà la abatà. ");
INSERT INTO mfh_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kà uwaga à uwana tsəràh à lakana kà tazallala: Guf aŋiz, à guf uwatà. ");
INSERT INTO mfh_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kiya uwanay à uwana gay aŋa masla mapəhal gay à ahàl Ye­re­miya agoɗ: ˈTahəl gursu dzik makər uwaga. (Sili uwaga azla Isərayel tatsəna vok gay lakəl aŋha kà masukwla) ");
INSERT INTO mfh_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ta­sukwla guf aŋa masla maŋalàh tatak, bokuba uwana Sufəl Zəzagəla apə̀h.ˈ ");
INSERT INTO mfh_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu la huma aŋa gumna kà manaval gay la gay ala: “Kak la uwana kak Sufəl aŋa azla Yahu­diya ay?” “Iyay, bokuba uwana kapə̀h”, Yesu agòɗal. ");
INSERT INTO mfh_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Uwana azla­ma­dza­haga, la azla­ma­siga tapùwla gudzi à gəl kà, awùlla gay à uda aw. ");
INSERT INTO mfh_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kiya uwaga Pilatus agòɗal: “Kak katsənà azlagay uwaga gesina tatugway lakəl aŋak aw, takay?” ");
INSERT INTO mfh_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ama Yesu awulàlla gay amiyaka tekula aw, tsəràh à uwana ləv avàl à gumna à gay. ");
INSERT INTO mfh_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bà kəla madəvaday Paska kà, gumna adawah gəl à masla daŋay tekula uwana asà à maham à ahəŋ dza kà uwana adagay zagəlà aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","La mok uwatà kà, dza anik la ahəŋ la daŋay, masla mawi­siga kaykay, sləm aŋha kà Barabas. ");
INSERT INTO mfh_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kiya uwaga Pilatus anàv à maham à ahəŋ dza la gay ala: “Uwa à uwana asa à akul gəduw à akul ala à gəl uwa: Barabas ay awma Yesu uwana Kristu ay?”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kà uwana Pilatus asə̀l ndzer kà tafàl Yesu à ahàl kà, kà maŋor. ");
INSERT INTO mfh_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Uwana gəl akàɗ à Pilatus à vok kà gay aŋa seriya, kà mis aŋha aslə̀l dza à slaka aŋha agòɗal: “Katapa à ahàl à dza uwaga à vok tetuwa aw, kà uwana masla kà aɗahà tsakana aw, gəsày ŋgərpa məŋga la mase­siŋay la vəɗɗà lakəl aŋa gay aŋha.” ");
INSERT INTO mfh_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Məŋ madza­haga la azla­ma­siga tagòɗ à azladza kà: Say tanav à masakay kà Barabas, ŋgaha takəɗ Yesu. ");
INSERT INTO mfh_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gumna anàv à atà à gay ala aya: “Uwa la tataka aŋa azladza səla uwanay la abà asa à akul kà gəduw à akul la gəl ala?” Tagòɗal: “Dùw à anu gəl à Barabas!” ");
INSERT INTO mfh_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Anàv à atà: “Mana gəɗehəŋ la Yesu, uwana Kristu tagòɗal zlà ma?” Gesina aŋatà tagòɗ: “Zlə̀l à ahàf à adi!” ");
INSERT INTO mfh_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatus anàv à atà aya: “Sləray mawi­siga ma uwala aɗahàŋ là?” Ama tazà kuda à zagəla la ndzəɗa, tagòɗ: “Zlə̀l à ahàf à adi!” ");
INSERT INTO mfh_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Uwana Pilatus anəŋàŋ kà aslàla vok aɗàh tatak anik aw say mawiyay pəra taziŋ à zagəla kà, atəɗànì iyaw, apàl ahàl aŋha la huma aŋa azladza gesina, agòɗ: “Tsakana aŋa makəɗ kona uwanay kà, aɓəz kà gi aw, uwaga kà say gay lakəl aŋkul pəra.” ");
INSERT INTO mfh_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Azladza gesina tagòɗ: “Tsakana makəɗ masla kà awulla à anu à gəl la azlabəza gami!” ");
INSERT INTO mfh_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ŋgaha Pilatus adùw gəl à Barabas, aslahà Yesu ala la kurpi, avà à atà à ahàl kà mazləl à ahàf à adi. ");
INSERT INTO mfh_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Azla­slodzi aŋa Pilatus tadàla Yesu à mtəga aŋa gumna, ŋgaha maham à ahəŋ slodzi gesina ahàmal à adi. ");
INSERT INTO mfh_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tasərə̀talla la ahàl lukut aŋha la vok ala, tadùwal diri mativga à vok. ");
INSERT INTO mfh_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Taslàslàp gabaga aŋa atàk, tafàl à gəl, tafàl azəva gulakay à ahàl kaf, ŋgaha takədèɗal à huma à gay, takəɗàslal la magoɗay: “Ayyi, Sufəl aŋa azla Yahu­diya!” ");
INSERT INTO mfh_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tatàfal slesliɓ à vok, tazə̀ɓ azəva uwatà la ahàl aŋha, tazlàɓla à gəl. ");
INSERT INTO mfh_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mok uwana takəɗàslal tsewwa kà, tasərə̀tal diri mativga uwatà la vok ala, tadùwal lukut aŋha à vok, tadàla masla kà mazləl à ahàf à adi. ");
INSERT INTO mfh_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","La mok uwana tadùw à uda la gudəŋ à abà kà tagagàm la dza anik sləm aŋha Səmon, zil Səren. Azla­slodzi tafàl leri à gəl kà mazəɓ ahàf uwana tadà­zləl Yesu à adi. ");
INSERT INTO mfh_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tabə̀z à slaka anik uwana sləm aŋha Gol­go­ta, bokuba magoɗay: Slaka həraŋ gəl. ");
INSERT INTO mfh_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","La abatà la uwana tatə̀ɗ à tatak masay hamhamga à Yesu, atapàŋ ŋiz yewdi kà, akweskà. ");
INSERT INTO mfh_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tazlə̀l Yesu à ahàf à adi, ŋgaha tavàhà lukut aŋha la tataka aŋatà la abà la matsal tsatsa lakəl. ");
INSERT INTO mfh_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ŋgaha tadzàh madzay la abatà kà manəŋla. ");
INSERT INTO mfh_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tafà matse­tseray à gəl aŋha à afik à abatà kà mapəhla godega aŋa makəɗay aŋha ala: DZA UWANAY KÀ, YESU SUFƏL AŊA AZLA YAHUDIYA. ");
INSERT INTO mfh_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tata­tàslàh azlaməna nabəra səla à ahàf à adi babay, anik la ahàl kaf, anik la ahàl gudzay. ");
INSERT INTO mfh_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Azladza uwana tau­guwàh à awtày la abatà tako­kò­tàhà gəl, tatsàk atà mago­ɗahay à gəl, ");
INSERT INTO mfh_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","tagòɗal: “Kak uwana kayàh makal məŋ gày Zəzagəla à ahəŋ, ŋgaha kà mawulla à afik la mahənay makər kà, ɓə̀l gəl aŋak à baŋa kak Kona aŋa Zəzagəla, sà à ahəŋ la ahàf uwaga la adi zla!” ");
INSERT INTO mfh_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kiya uwaga babay azla­ma­dza­haga aŋa azlaməna mav tatak, la azlaməna mapàhla mapəhay ala, la azla­ma­siga takəɗàsl à masla, tagòɗ: ");
INSERT INTO mfh_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Masla kà aɓàlàhà azladza anik, ama aslàla vok aŋa maɓəl gəl aŋha aw takay? A tsa masla kà Sufəl aŋa azla Isərayel ay? Lagwa kà, sà à ahəŋ la ahàf la adi zlà pəra, anu bay mədìŋ à ka gəl à vok. ");
INSERT INTO mfh_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Masla afà madzugway aŋha à Zəzagəla à afik, ŋgaha apə̀hla lela: ‘Gi Kona aŋa Zəzagəla’, agòɗ! Iyay zla, mənəŋəŋ à baŋa Zəzagəla aɓələŋ lagonay zla!”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Azlaməna nabəra uwana tazlàlal à makəla aŋha tatsə̀kal mago­ɗahay à gəl kiya uwaga babay. ");
INSERT INTO mfh_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","La tataka afats, mələs apakà vok la kutso la abà gesina, tsəràh afats dat mago­va­gova gərewni delga. ");
INSERT INTO mfh_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","La afats dat mago­va­gova gərewni delga uwatà, Yesu awiyà la ndzəɗa, agòɗ: “Eli, Eli lema sabac­ht­ha­ni?” (Bokuba magoɗay: Zəzagəla gulo, Zəzagəla gulo, kà mana kasàk gi ma?) ");
INSERT INTO mfh_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Azlaanik uwana tadzà à ahəŋ la abatà tatsənàŋ uwaga, tawiyà: “Azalay kà à Eliya!”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Katskats tekula aŋatà ahòy, azə̀ɓ sawsaw, adùw à iyaw hamhamga à abà, afà à gulakay à gay, adzìyla à Yesu, kà masla aŋa mako­kuzay. ");
INSERT INTO mfh_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ama azlaanik tagòɗ: “Məkuda, à baŋa Eliya atsa à waŋ kà maɓələŋ kà mənəŋəŋ tak zlà!” ");
INSERT INTO mfh_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","La lig la ahəŋ Yesu awiyà la ndzəɗa aya, ŋgaha amə̀ts. ");
INSERT INTO mfh_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","La sa uwatà bafta uwana tanə̀lla məŋ gày Zəzagəla ala akohàla tsəràɗ tsəràh à afik tsəràh à vəɗah. Kutso aɓəlàkà à vok, ŋgaha azladzəgla tapəslàkàh ala. ");
INSERT INTO mfh_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Azlazəvay tapàzlla à ama ala ŋgaha aŋuvaw azlaməna madiŋal gəl à Zəzagəla à vok tawàlla à uda la mamətsay. ");
INSERT INTO mfh_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tasàhà à lag la zəvay la aku, ŋgaha la lig mawul à uda aŋa Yesu la ahəŋ, tahàd à huɗ gudəŋ tsi­ɗa­ŋaga à abà, azladza aŋuvaw tanaŋà atà. ");
INSERT INTO mfh_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Azla­slodzi aŋa azla Rom, la məŋga aŋatà tanə̀ŋla Yesu. Uwana tanəŋà mabəlak à vok aŋa kutso la tatak uwana apakà vok gesina kà, guba məŋga akə̀s atà, tagòɗ: “Ndzer masla kà, Kona aŋa Zəzagəla!” ");
INSERT INTO mfh_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Azlamis aŋuvaw tagà la abatà, tatsàzl à ahəŋ kərkər, tanərəzay atà. Tanəfà Yesu à waŋ dagay la Galili, kà atà aŋa mazlak masla à sləray à abà. ");
INSERT INTO mfh_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mari­yama uwana dəg zla Magdala, Mari­yama iyà aŋa Yakuba atà la Yusufu, la iyà aŋa azlabəza aŋa Zebede tagà la tataka azlamis uwaga la abà. ");
INSERT INTO mfh_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Uwana mokokhu adasa à waŋ kà, dza galepi anik uwana la Arimate asà à waŋ, sləm aŋha kà Yusufu, masla bay kà masla asik aŋa Yesu. ");
INSERT INTO mfh_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ahàd, abə̀z à Pilatus à vok kà manaval vok aŋa Yesu. Kiya uwaga Pilatus avà tetəvi à Yusufu kà mazəɓ vok aŋa Yesu. ");
INSERT INTO mfh_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu asà à waŋ, azə̀ɓ vok aŋa Yesu à ahəŋ, afa­fàɗal à bafta mawga à adi. ");
INSERT INTO mfh_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ŋgaha afà à zəvay aŋa aslasl gəl aŋha uwana à agu, alà à təhus à afik, ata­kòslal magol ɓəlam à gay, kà matsakal à ama, ŋgaha adà aŋha. ");
INSERT INTO mfh_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari­yama dəg zla Magdala atà la Mari­yama anik uwanay tadzàhà madzay la abatà la magohla à huma à zəvay à adi. ");
INSERT INTO mfh_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","La vuɗ maduw ləv aŋa azla Yahu­diya bəŋ azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla, la azla Farisəya tahàd à slaka aŋa Pilatus, ");
INSERT INTO mfh_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","tagòɗal: “Arveri, awùlla à anu à gəl kà, masla fida uwanay kà, uwana aləg mamətsay kà, agòɗ kà: La mahənay makər kà, gədàwul à uda, agòɗ. ");
INSERT INTO mfh_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ŋuləm kà, gòɗ, kà tanəŋla zəvay aŋha mahənay makər, kà azlaməna matapla aŋha aŋa mas à waŋ kà mazəɓ à lag la aku aw, ŋgaha kà atà magoɗay à azladza kà adawul à uda la mamətsay aw. Kà uwana fida uwaga adàɗuw fida aŋa uwarà.” ");
INSERT INTO mfh_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatus agòɗ à atà: “Azla­slodzi kà atà la uwanay, dàw, kanəŋawla zəvay bokuba uwana kaslawwalla vok gesina.” ");
INSERT INTO mfh_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tahàd taɓə̀k azlaməna manəŋla zəvay à ahəŋ, tafà masəlay à akur uwana à vok tatsakla zəvay à ama, ŋgaha taɓə̀k azla­slodzi à ahəŋ kà manəŋla. ");
INSERT INTO mfh_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","La lig aŋa vuɗ maduw ləv aŋa azla Yahu­diya la ahəŋ, à vuɗ ladu la bəŋ gà, Mari­yama dəg zla Magdala, atà la Mari­yama anik uwatà, tahàd kà manəŋ à gəl zəvay. ");
INSERT INTO mfh_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","La katskats kutso aɓəlàkà à vok la ndzəɗa, malika aŋa Sufəl Zəzagəla asà à ahəŋ la zagəla, ata­kòslla à ɓəlam uwana ala tatsàkla à zəvay à ama, ŋgaha adz à afik la abatà. ");
INSERT INTO mfh_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Masla awutsəɗay bokuba mawutsəɗay habaga, lukut aŋha babay təlla bokuba slewzi. ");
INSERT INTO mfh_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mok uwana azlaməna manəŋla zəvay tanəŋàŋ kà, guba akə̀s atà kaykay, atà tasəkùlàh, tapàkàh iyaw. ");
INSERT INTO mfh_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Malika agòɗ à azlamis uwatà: “Akul kà, guba akəs akul aw, kà uwana gəsəl kà kayahaw kà Yesu uwana tazlə̀l à ahàf à adi. ");
INSERT INTO mfh_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Aga la abanay aw, ada­wulla à uda la mamətsay, bokuba uwana apə̀h à akul uwarà. Sàw à waŋ, kago­vàlàw slaka uwana tahə̀n à ahəŋ tsi. ");
INSERT INTO mfh_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Dàw katskats kadàpəhaw à azlaməna matapla la slaka aŋha kà masla ada­wulla à uda la mamətsay. Lagwa adà­tsəvokay kà akul à kutso Galili. Kadà­nəŋawwaŋ kà la abatà, uwaga la uwana gəpəh à akul zla.” ");
INSERT INTO mfh_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Katskats azlamis uwaga tatsìzlla ala la gəl zəvay la guba la vok, ama la marabay məŋga babay. Tahàd la mahoyay kà madla gay uwaga à azlaməna matapla aŋa Yesu. ");
INSERT INTO mfh_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Katskats Yesu asà à waŋ agagam à atà nna, agòɗ à atà: “Ayyi, gəgoɗ à akul”. Azlamis uwaga tazà à vok à slaka aŋha, takàs à asik aŋha à ahàl, takə̀ɗal à ahəŋ, ŋgaha taslə̀kàw masla. ");
INSERT INTO mfh_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kiya uwaga Yesu agòɗ à atà: “Guba akəs akul aw. Dàw, kadà­goɗaw à azla­deda gulo kà, tahàd à kutso Galili, la abatà la uwana tadànəŋ gi”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mok uwana azlamis uwanay tadà aŋatà kà, azlaanik la tataka aŋa azla­slodzi uwana la abà tanəŋla zəvay uwaga, tahàd à huɗ gudəŋ à abà. Tapə̀h tatak uwana apakà vok à azla­ma­dza­haga aŋa azlaməna mav tatak gesina. ");
INSERT INTO mfh_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Azla­ma­dza­haga takə̀s sawaray la azla­ma­siga. Mok uwana tatsə̀n vok gay, tavà sili à azla­slodzi uwatà məŋga. ");
INSERT INTO mfh_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Tagòɗ à atà: “Kadà­goɗaw kà azlaməna matapla la slaka aŋha tasà à waŋ la vəɗ, tazə̀ɓ vok aŋa Yesu la gəl à gəl, la mok uwana mədatàɗ à madzehal à abà. ");
INSERT INTO mfh_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kiya uwaga baŋa atsə̀n à gumna, məsəl dabaray uwana mədàɓəzal à tsəh, ŋgaha akul kadàsaw à uda la gay la abà gesina.” ");
INSERT INTO mfh_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Azla­manəŋla tahə̀l sili, ŋgaha taɗahàŋ bokuba uwana tatàp à atà ala kà maɗehəŋ gesina. Kiya uwaga gay uwaga azahà vok la tataka azla Yahu­diya la abà tsəràh à lakana. ");
INSERT INTO mfh_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kiya uwaga azlaməna matapla kulo gəl aŋha tekula uwaga, tawùl à gudəŋ Galili à dadəgwal uwana à afik, Yesu apə̀hatàla. ");
INSERT INTO mfh_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mok uwana tanəŋə̀ŋ kà, taslə̀kàw masla, azlaanik la tataka aŋatà la abà taɓə̀k gəl à ahəŋ səla. ");
INSERT INTO mfh_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu azà à vok à slaka aŋatà, agòɗ à atà: “Lagwa kà ndzəɗa uwana la zagəla, ŋgaha la uwana la vəɗah kà agay mav à gi gà. ");
INSERT INTO mfh_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Dàw à slaka azladza gudəŋ à vok gesina, kapa­ka­ha­wa­tàla kà azlaməna matapla gulo, kadà­ɗahaw à atà batem la sləm aŋa Baba, la sləm ana Kona, ŋgaha la sləm aŋa Masasəɗok tsi­kasla. ");
INSERT INTO mfh_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tapawatàla kà atà aŋa manəf uwana gətà­pà­kulla gesina. Sə̀làw kà, gədàgay la ahəŋ la akul koksi­koksi, tsəràh à makəɗ gəl à ahəŋ gudəŋ à vok.”");
INSERT INTO mfh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Aganay gay delga uwana adzəka à vok lakəl aŋa Yesu, Kona aŋa Zəzagəla, uwana mafal dzakwa à gəl gà. ");
INSERT INTO mfh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","La wakità uwana la abà Yesayya atsetsèr, Zəzagəla agòɗ: ˈ“Aganay gəsləl à awtày masləlay gulo, la huma aŋak kà maɗahkaŋ tetəvi à ahəŋ.”ˈ ");
INSERT INTO mfh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Uwaga kà kuda aŋa dza uwana awiyay la fəta la abà: ˈ“Ɗa­hàwla azla­tetəvi à Sufəl Zəzagəla à ahəŋ tərra.”ˈ ");
INSERT INTO mfh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kiya uwaga Yuhana apəhla vok ala la fəta la abà. Az gay Zəzagəla, anavà azladza uwana tasà à waŋ à slaka aŋha: ˈ“Kə̀sàw batem, uwana apəhla ala kà kadapəhaw gay la ləv ala, ŋgaha Zəzagəla adà­ma­ma­tsa­kula tsakana ala.”ˈ ");
INSERT INTO mfh_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Azladza la makoray masla Yahu­diya, la azladza la Uru­sa­lima gesina, tasà à waŋ à slaka aŋha, uwana tasə̀lla tsakana aŋatà à uda. Yuhana aɗahà à atà batem la mukwà Urdun la abà. ");
INSERT INTO mfh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yuhana adùw lukut maɗehəŋga à vok la aŋidz aŋa zlugumi, rəts awadà vok ala la para­para zlap, tatak may aŋha kà hayyaw la zuway mazuway. ");
INSERT INTO mfh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Apə̀h à azladza, agòɗ à atà: “Dza uwana atsa à waŋ la lig gulo la ahəŋ kà, aɗuwa gi la məŋga, gəsla gay kà makəl gəl à ahəŋ aŋa mapəl zuwiɗ kwimik aŋha ala aw. ");
INSERT INTO mfh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Gi kà, gəɗa­ha­kulla batem kà la iyaw, ama masla kà aɗa­ha­kullaŋ kà la Masasəɗok Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","La abatà Yesu asà à waŋ la gudəŋ Nazaret la kutso Galili. Yuhana aɗahalla batem la mukwà Urdun la abà. ");
INSERT INTO mfh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mok uwana Yesu asà à uda la iyaw la abà, anəŋà à zagəla kà, zagəla mapəzl à ama ala gà. Anəŋà Masasəɗok Zəzagəla atsà à ahəŋ à gəl aŋha bokuba haba­koku. ");
INSERT INTO mfh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ŋgaha tatsənà kuda uwana atsə̀n à ahəŋ la zagəla: “Kak bəzi gay ləv gulo, gərabay məŋga kà kak.” ");
INSERT INTO mfh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","La lig la ahəŋ, katskats Masasəɗok Zəzagəla adala Yesu à fəta à abà. ");
INSERT INTO mfh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Adzà à ahəŋ la abatà mavakay dzik ufaɗ, ŋgaha seteni apapàt masla. Yesu adzà à ahəŋ la tataka azla­tatak fəta la abà, ŋgaha azla­ma­lika tazlàk masla bay. ");
INSERT INTO mfh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tadùw Yuhana à daŋay, kiya uwaga Yesu ahàd à kutso Galili, kà maz gay matsi­ɗayga aŋa Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Agòɗ: “Kaslà adaslay à dagay kà Zəzagəla adzəka makoray aŋha. Pə̀hàw gay la ləv ala, dìŋàw gəl à gay matsi­ɗayga aŋa Zəzagəla à vok!” ");
INSERT INTO mfh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mok uwana Yesu anə̀f à gay dərəv aŋa Galili, anəŋà azlaməna makas kilfi səla, Səmon la deda aŋha Andəre. Tadàw dzarawa à iyaw abà kà makasla kilfi. ");
INSERT INTO mfh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu agòɗ à atà: “Sàw à waŋ, nə̀fàw gi, gədàpakakulla kà azlaməna makas azladza.” ");
INSERT INTO mfh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Katskats tasàk à dzarawa aŋatà, tanəfà masla. ");
INSERT INTO mfh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Uwana adada à huma à gay ŋuv, anəŋà azlabəza aŋa Zebede, Yakuba atà la Yuhana, atà la kəslah iyaw la abà taɗàh dzarawa aŋatà. ");
INSERT INTO mfh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Katskats Yesu azàla atà, tasàk à baba aŋatà à ahəŋ la azlaməna sləray aŋha la kəslah iyaw la afik, ŋgaha tanəfà Yesu. ");
INSERT INTO mfh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu la azlaməna matapla la slaka aŋha tahàd à Kaper­nahum. La vuɗ maduw ləv aŋa azla Yahu­diya, Yesu adà à gày madəv kuɗa aŋatà à agu kà matapatàla. ");
INSERT INTO mfh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Azladza uwana tatsənà gay aŋha kà, ləv avàl atà à gay, kà uwana atapàtàla kà bokuba azlaməŋga aŋa azlaməna madzeŋ wakità Zəzagəla aw, ama bokuba dza uwana akor ndzəɗa. ");
INSERT INTO mfh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mok uwatà, dza la masasəɗok mawi­siga apə̀hla vok ala la gày madəv kuɗa uwatà la aku, awiyà: ");
INSERT INTO mfh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Mana à gay aŋak la anu ma? Yesu, kak zil Nazaret! Kasà à waŋ kà mazanula ay? Gəsəl kà, kà kak Tsi­ka­slaga uwana Zəzagəla aslə̀l kak à waŋ.” ");
INSERT INTO mfh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu aslə̀h məlo à masasəɗok uwatà à gəl: “Dzà à ahəŋ titi! Sà dza uwaga lakəl ala!” ");
INSERT INTO mfh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ŋgaha masasəɗok mawi­siga aɓəllakà dza uwatà la ndzəɗa, awiyà la kuda məŋga, ŋgaha asàlla à kəl ala. ");
INSERT INTO mfh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ləv avàl atà à gay gesina. Tanà­vàhà à vok: “Mana gay mawga uwanay asal magoɗay ma? Mana uwaga ma, akor azla­ma­sasəɗok mawi­siga la ndzəɗa, ŋgaha azla­ma­sasəɗok mawi­siga bay tafa à gəl à gay aŋha?” ");
INSERT INTO mfh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Katskats azladza tazàhà gay lakəl aŋa Yesu la kutso Galili gesina. ");
INSERT INTO mfh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Uwana tasà à uda la gày madəv kuɗa la aku kà, katskats Yesu ahàd atà la Yakuba ŋgaha la Yuhana à mtəga aŋa Səmon la Andəre. ");
INSERT INTO mfh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Məŋay aŋa Səmon la akàl la vok la slaka mahən à ahəŋ. Mok uwana Yesu abə̀z atà à vok kà, tapə̀hal gay lakəl aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu ahàd à slaka aŋha, akə̀s la ahàl, atsìzllàŋ ala, ŋgaha akàl vok asàlla vok ala. La lig la ahəŋ mis uwatà azlàk atà. ");
INSERT INTO mfh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","La mokokhu, mok uwana afats adatəɗ à ahəŋ, azladza tasàhla azlaməna ɗuvats aŋuvaw à waŋ à slaka Yesu, la azla­uwana la masasəɗok mawi­siga. ");
INSERT INTO mfh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Azladza gudəŋ uwatà tahamà gay à vok la gay gamagày aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu awaràŋ ala azladza aŋuvaw uwana tas ŋgərpa la azla­ɗu­vats anik anik gesina, la makuɗəkàh azla­ma­sasəɗok mawi­siga, afàhà à atà akur à lig kà mapəhlaŋ ala aw, kà uwana atà: “Məsəl Yesu”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Lebəŋ gà bəŋ, afats à lig mas à afik, Yesu atsìzlla ala, ŋgaha asà à uda la kay, ahàd aŋha à fəta à abà ŋgaha adə̀v kuɗa la abatà. ");
INSERT INTO mfh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Səmon atà la azlama­nalay aŋha tahàd kà mayàh masla. ");
INSERT INTO mfh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Uwana taɓə̀zal à vok, “Azladza gesina tayàh kà!”, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ama Yesu agòɗ à atà: “Məhàd à azla­gu­dəŋ anik anik, gədàpəhay gay Zəzagəla la abatà babay, kà uwana gəsà à waŋ kà maɗàh sləray uwaga.” ");
INSERT INTO mfh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kiya uwaga augu­zàhàh la kutso Galili gesina. Apàh gay matsi­ɗayga la azlagay madəv kuɗa aŋatà la aku, ŋgaha akuɗə̀kàh azla­ma­sasəɗok mawi­siga à uda. ");
INSERT INTO mfh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Masla akàl zagəla asà à waŋ à slaka Yesu, akədèɗal à huma à gay, anàval: “Kamkam, baŋa asa à ka kà, kaslala vok kà mawur gi ala!” ");
INSERT INTO mfh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Vok ahàm à Yesu, abiyà ahàl ala, adəɓanì, ŋgaha agòɗal: “Asa à gi, wùr ala!” ");
INSERT INTO mfh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Katskats akàl zagəla asàl à vok ala, awùr ala. ");
INSERT INTO mfh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","La lig la ahəŋ, Yesu awùl à masla la mafahal akur à lig, agòɗal: ");
INSERT INTO mfh_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Tsənàŋ lela, kapəh uwaga à dza anik aw, ama hàd kadàpəhla vok à masla mav tatak à Zəzagəla, kà kada­wurla, ŋgaha và tatak uwana Musa apə̀h à ahəŋ kà masəlay kà kawùr ala.” ");
INSERT INTO mfh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ama dza uwatà ahàd, adzəkà mapəhay à azladza gesina lakəl aŋa mawurla aŋha. Gay gà la uwaga à uwana Yesu aslàla vok kà mad gudəŋ à abà la dazu­waya aw. Kà uwaga à uwana Yesu adzà à ahəŋ la uda la fəta la abà, la abatà bay, azladza tadàh à awtày à slaka aŋha la kəla slaka gesina. ");
INSERT INTO mfh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","La lig mahənay ŋuv Yesu ahàd à Kaper­nahum aya. Uwana tatsənàŋ Yesu la kay kà, ");
INSERT INTO mfh_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","azladza aŋuvaw tahamà ahəŋ tsəràh à uwana slaka atə̀m à ahəŋ baməraka la gəl akàl aw, apə̀h à atà gay Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ŋgaha azladza anik tasà à waŋ à slaka aŋha, tasə̀lla dza makalàh à vəɗah gà à waŋ, azladza ufaɗ la tsəh tazəɓay. ");
INSERT INTO mfh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ama taɓə̀z à tetəvi kà madla à slaka Yesu aw, kà uwana maham à ahəŋ dza aŋuvaw la ahəŋ, tadala à gəl gày à afik, tapokwà gəl gày uwana Yesu la kay la afik, uwana tapokwàŋ tadzilà dza makalàh à vəɗah gà uwatà à gày la kəslah gà. ");
INSERT INTO mfh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Uwana Yesu anəŋàŋ madiŋal gəl à vok aŋatà məŋga, agòɗ à dza makalàh à vəɗah gà uwaga: “Bəzi gulo, tsakana aŋak adà­ma­tsila!” ");
INSERT INTO mfh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ama azladza anik la tataka azlaməna mapàhla wakità seriya la abà la slaka madzàh madzay la abatà, tadzùgw la gəl aŋatà: ");
INSERT INTO mfh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kà mana dza uwanay apəhay mawi­siga lakəl aŋa Zəzagəla kiya uwaga ma? Dza aslala vok aŋa mamats tsakana à dza ala aw, say Zəzagəla pəra!” ");
INSERT INTO mfh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Katskats Yesu asə̀l uwana tadzugway la ləv aŋatà la tsəh, agòɗ à atà: “Kà mana kadzugwaw kiya uwanay la ləv aŋkul la tsəh ma? ");
INSERT INTO mfh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Butu mala zla­zlaɗa magoɗay: gədà­mats à ka tsakana aŋak ala takay? Awma: Sà à afik, zə̀ɓ kəslah aŋak, hàd aŋak takay? ");
INSERT INTO mfh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ama asa à gi kasəlaw, kà gi kona aŋa dza, ŋgaha kà gi la masəlay aŋa mamats tsakana aŋa azladza gudəŋ à vok ala: ");
INSERT INTO mfh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Sà à afik, zə̀ɓ kəslah aŋak, hàd mtəga aŋak! Gəgoɗ à kak”, Yesu agòɗ à dza makalàh à vəɗah gà. ");
INSERT INTO mfh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Katskat asà à afik, azə̀ɓ kəslah aŋha. Uwana azladza gesina tanəŋàŋ adìŋ aŋha, ləv avàl à atà à gay gesina, tazləɓà Zəzagəla, tagòɗ: “Məda­nəŋəŋ ɗiki­ɗiki kiya uwanay aw!” ");
INSERT INTO mfh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu awùlla à gay dərəv aya, sləm aŋha kà dərəv Galili. Azladza aŋuvaw tahamà à waŋ à slaka aŋha, ŋgaha atàpatàla. ");
INSERT INTO mfh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Uwana adà à awtày, anəŋàŋ Levi, kona aŋa Alfe, adadza madzay la gày mazəɓ hadama la aku. Yesu agòɗal: “Sà à afik, nəfà à gi!” Levi asà à afik, anəfà. ");
INSERT INTO mfh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","La lig la ahəŋ Yesu la azlaməna matapla aŋha tahàd à mtəga Levi kà mazuw tatak may. Azlaməna mazəɓ hadama aŋuvaw la azlaməna tsakana aŋuvaw, tadzàhà madzay atà nna, kà uwana azladza tsəhay gà uwaga aŋuvaw tanəfà atà aya. ");
INSERT INTO mfh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Azlaanik la tataka azla­ma­dza­haga aŋa wakità seriya aŋa Zəzagəla la abà, uwana la tataka aŋa azla Farisəya la abà, tanəŋàŋ kà Yesu azùw tatak may la slaka gà la azlaməna mazəɓ hadama la azladza tsakana, tagòɗ à azlaməna matapla la slaka aŋha: “Kà mana azuw tatak may la azlaməna mazəɓ hadama la azlaməna tsakana ma?” ");
INSERT INTO mfh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Uwana Yesu atsənà uwaga, agòɗ à atà: “Azladza uwana ɗuvats aza à ata aw, kà tayàh mad dokwtar aw, say azlaməna ɗuvats pəra. Gi, gəsà à waŋ kà mazalay azladza uwana tadzugw kà azla­dzi­riga aw, ama gəsà à waŋ kà, kà mazal azlaməna tsakana.” ");
INSERT INTO mfh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Azlaməna matapla aŋa Yuhana, masla maɗàh batem la azla Farisəya takasàh nəlay la azla­kaslà anik anik. Azladza anik tasà à waŋ à slaka Yesu, tanàval: “Kà mana azlaməna matapla aŋa Yuhana, masla maɗàh batem, la azla Farisəya kà takas nəlay, ama kà mana azlaməna matapla la slaka aŋak kà takas nəlay aw ma?” ");
INSERT INTO mfh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu agòɗ à atà: “Baŋa dza azəɓ mis azàlàh azla­slawda aŋha kà mazuw tatak may, ma tasàk tatak may la mavakay uwatà aŋa makəs nəlay takay? Awaŋ, tasàkal aw, tazuway. ");
INSERT INTO mfh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ama mok uwana zil mis adàdiŋ aŋha la slaka aŋatà, la uwana tadàkas nəlay adàgay la mok uwatà.” ");
INSERT INTO mfh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yesu aga­gàzlla atà ala la mata­patla mawga aŋha uwanay: “Dza atsap lukut mawga à mavi­yaga à vok aw. Baŋa aɗehəŋ kità kà, lukut mawga akwàh mavi­yaga à tsəh, ŋgaha makwàhla aŋha azàh à tsəh aya. ");
INSERT INTO mfh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Dza aɗaw iyaw aŋa mayyay ahàf mawga à kiwa iyaw mavi­yaga à agu aw, kà uwana à baŋa amsəlila kà, akwàh kiwa ala. Ŋgaha iyaw aŋa mayyay ahàf la kiwa iyaw tadà­uwi­sila. Ama aɗuwa à vok kà taɗaw iyaw aŋa mayyay ahàf mawga à kiwa mawga à agu, suwaŋ.” ");
INSERT INTO mfh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Vərdi anik la vuɗ maduw ləv, Yesu aguwà à awtày la gay guf nalkama. Azlaməna matapla la slaka aŋha tadzəkà mabərədahay nalkama la tetəvi la ama. ");
INSERT INTO mfh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Azla Farisəya tagòɗ à Yesu: “Kà mana azlaməna matapla la slaka aŋak taɗàh tatak uwana azlayla kà à vok aw ma? Kà uwana wakità seriya gami avəra gay kà tatak uwaga la vuɗ maduw ləv.” ");
INSERT INTO mfh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu awùlla à atà ala: “Kadzèŋàw ɗiki­ɗiki aw uwana David aɗahàŋ la mok uwana may akə̀s la azladza uwana la slaka aŋha aw uwà? ");
INSERT INTO mfh_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ahàd à gày Zəzagəla à agu, azə̀ɓ kaf uwana tafàh à huma aŋa Zəzagəla, azùw. Mok uwatà kà, Abi­yatar la uwana məŋga aŋa azlaməna mav tatak à Zəzagəla. Wakità seriya gami kà, avà tetəvi kà azlaməna mav tatak à Zəzagəla kà mazuway pəra. Ama David azə̀ɓ, azùw, ŋgaha avàh à azlaməna aŋha bay.” ");
INSERT INTO mfh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu agòɗ à atà aya: “Zəzagəla aɗahà vuɗ maduw ləv kà, kà madz à ahəŋ delga aŋa dza, awkà Zəzagəla aɗahà dza kà aŋa vuɗ maduw ləv aw. ");
INSERT INTO mfh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Gay gà la uwaga gi Kona aŋa dza la uwana Sufəl aŋa vuɗ maduw ləv.” ");
INSERT INTO mfh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","La vərdi anik, Yesu ahàd à gày madəv kuɗa à agu aya. La gày uwatà la aku kà, dza la ahəŋ uwana ahàl aŋha mamətsayga. ");
INSERT INTO mfh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Azladza la ahəŋ la gày madəv kuɗa la aku, tanərə̀z Yesu à baŋa awur dza ala la vuɗ maduw ləv, kà atà maɓəzal à tsəh la gay la abà, kà uwana akə̀s mapəhay lakəl aŋa vuɗ maduw ləv aw. ");
INSERT INTO mfh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu agòɗ à dza uwana ahàl aŋha mamətsayga: “Sà à afik, sà à waŋ à huma azladza gesina!” ");
INSERT INTO mfh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ŋgaha anàv azladza uwana tatsə̀kal yewdi à gay: “Mana wakità seriya gami apəh à anu ma? Tetəvi la ahəŋ kà maɗàh delga la vuɗ maduw ləv takay? Awma maɗàh mawi­siga takay?” Asà à atà mawulla gay à uda aw. Takwès. ");
INSERT INTO mfh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu atsəkà à atà yewdi à gay la mazinal à gəl. Ama apàk ləv məŋga kà madzugway mawi­siga aŋatà. Kiya uwaga agòɗ à dza uwatà: “Biyà ahàl ala!” La kirim yewdi awùr ala. ");
INSERT INTO mfh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Batsàrà, uwana azla Farisəya tanə̀ŋ uwaga kà, tasà à uda la gày Zəzagəla la aku, tahàd, tahamà gay à vok la azladza maham à ahəŋ gà uwana tatsə̀n vok gay la Herod kà aŋa magəɗ uwana à afik azlayla makəɗla Yesu. ");
INSERT INTO mfh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu la azlaməna matapla aŋha tazà vok. Tahàd à gay dərəv aŋa Galili, maham à ahəŋ dza aŋuvaw tanəfà atà. Azladza tasàhà à waŋ la makoray Galili, la Yahu­diya, ");
INSERT INTO mfh_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","la Uru­sa­lima dagay la gay dzika makoray aŋa Idumiya tsəràh à gay dzika aŋa dərəv uda aŋa mukwà Urdun, la azladza uwana tadzà à ahəŋ nekwa la gudəŋ Tir la Sədon. Magol maham à ahəŋ dza tasàhà à waŋ à slaka Yesu kà uwana tatsənàŋ lakəl aŋa tatak uwana aɗa­hàhàŋ. ");
INSERT INTO mfh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesu agòɗ à azlaməna matapla la slaka aŋha: “Yàhàw à gi bəzi kəslah iyaw, kà maham à ahəŋ dza aŋa maŋisl gi aw.” ");
INSERT INTO mfh_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yesu awurà azladza ala aŋuvaw, gay gà la uwaga azladza uwana tasà ŋgərpa la azla­ɗu­vats anik anik tavàhà vok kà madəɓani masla. ");
INSERT INTO mfh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","La mok uwana azladza uwana la azla­ma­sasəɗok mawi­siga tanəŋà masla, tatàɗal à huma la mawiyay, tagòɗal: “Kak, Kona aŋa Zəzagəla!” ");
INSERT INTO mfh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ama Yesu asləhà atà məl à gəl la ndzəɗa, kà mapəhla masla ala aw. ");
INSERT INTO mfh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu ahàd à dadəgwal à afik, ŋgaha azàl azladza uwana asàl, kà tatsà à waŋ à slaka aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Yesu akàsànì azladza kulo gəl aŋha səla, ŋgaha azàla atà ala azlaməna matapla la slaka aŋha, agòɗ à atà: “Gəkà­sànì akul kà madz à ahəŋ la slaka gulo, ŋgaha gədàslal akul kà mapàh gay Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Gəvà à akul maslay kà makuɗəkàh azla­ma­sasəɗok mawi­siga.” ");
INSERT INTO mfh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aganay azladza kulo gəl aŋha səla uwana akàsànì atà: Səmon uwana Yesu avàl sləm Piyer; ");
INSERT INTO mfh_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakuba la deda aŋha Yuhana, azlabəza aŋa Zebede. (Yesu avà à atà sləm Bowa­ner­gəs, asal magoɗay: masləh məl aŋa habaga, kà uwana tasaf à mapak ləv aw) ");
INSERT INTO mfh_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","La Andəre; Filip; Barte­lemi; Mata; Tomas; Yakuba, bəzi aŋa Alfe; Tade; Səmon zil Kananan ");
INSERT INTO mfh_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ŋgaha Yudas Iska­riyot, uwana adàda kà məzam à Yesu à gəl. ");
INSERT INTO mfh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu ahàd à mtəga aŋa dza anik. Maham à ahəŋ dza tahamà gay à vok aya, kà uwaga à uwana Yesu la azlaməna matapla la slaka aŋha taɓəzà tetəvi kà mazuw tatak may aw. ");
INSERT INTO mfh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mok uwana azlaməna huɗ gày aŋha tatsə̀n uwaga, tahàd kà masəla à mtəga, kà uwana azladza tagòɗ kà: “Gəl ada­kaɗal à vok!” ");
INSERT INTO mfh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Azla­ma­dza­haga aŋa wakità seriya tasà à ahəŋ la Uru­sa­lima tagòɗ: “Masla la Bel­zəbul, sufəl aŋa zagəla zagəla!”, asal magoɗay sufəl aŋa azla­ma­saɗok mawi­siga. Azlaanik tagòɗ: “Sufəl aŋa azla­ma­sasəɗok mawi­siga avàl maslay kà makuɗək azla­ma­sasəɗok mawi­siga.” ");
INSERT INTO mfh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu azàl azladza à slaka aŋha, agòɗ à atà: “Kakay sufəl aŋa masasəɗok mawi­siga aslala vok aŋa makuɗək seteni à uda aya ma? Akəsà vok aw. ");
INSERT INTO mfh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Baŋa azladza la makoray tekula tatsak ala kà, makoray sufəl uwatà kà aslala vok madz à ahəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Baŋa azladza la huɗ gày tatsak ala kà, huɗ gày uwatà aslala vok madz à ahəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Baŋa seteni ap guvəl à vok aŋha à adi kà, makoray aŋha ada­vahla, aslala vok aŋa madz à ahəŋ aw, ama makoray uwaga adàdəv à gay. ");
INSERT INTO mfh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Dza aslala vok aŋa mad à gày aŋa masla ndzəɗa kà mazəɓ tatak aŋha aw, say atsərkwiŋ dadàŋ, ŋgaha aslala vok kà mahəl tatak aŋha gesina. ");
INSERT INTO mfh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Gəpəh à akul la dziriga: Tsakana gesina la gay mawi­siga gesina uwana azladza tapəhay, Zəzagəla adà­ma­tsataŋ ala. ");
INSERT INTO mfh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ama dza uwana apəh mawi­siga lakəl aŋa Masasəɗok Zəzagəla kà, tsakana uwaga adà­ma­tsila ɗiki­ɗiki aw, ama tsakana uwaga adàdza à ahəŋ aŋa koksi­koksi.” ");
INSERT INTO mfh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu apə̀h kiya uwaga kà, kà uwana azlaanik tagòɗ kà: “Masla la masasəɗok mawi­siga”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iyà la azla­deda aŋa Yesu tasà à waŋ, taslə̀l dza kà mazal à atà la uda. ");
INSERT INTO mfh_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Azladza aŋuvaw tadzàhà madzay la makəla aŋa Yesu, tagòɗal: “Iyà la azla­deda aŋak la uda, tazala ka!” ");
INSERT INTO mfh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu awùl à atà ala: “Uwa iyà gulo la azla­deda gulo uwa?” ");
INSERT INTO mfh_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ŋgaha Yesu anərə̀z azladza uwana la makəla aŋha lakəl, agòɗ à atà: “Aganay azlaiyà la azla­deda gulo la abanay. ");
INSERT INTO mfh_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kà uwana kəla uwa­be­yuwi uwana aɗàh mawoyəŋ aŋa Zəzagəla la uwana azla­deda gulo la azlaiyà gulo.” ");
INSERT INTO mfh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu atàpla à maham à ahəŋ dza la gay dərəv aŋa Galili aya. Aŋuvaw tahamà gay à vok la slaka aŋha. Kà maham à ahəŋ dza, Yesu adà à kəslah iyaw à afik, adzà madzay. Ama maham à ahəŋ dza la gay dərəv. ");
INSERT INTO mfh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yesu apə̀hatàla azla­tatak aŋuvaw la gay la gay la abà, ŋgaha agòɗ à atà la matapla aŋha la abà: ");
INSERT INTO mfh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Tsə̀ɓàwwal sləm!”, Yesu agòɗ à atà, “Dza anik asà à uda kà mad maslək hi. ");
INSERT INTO mfh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mok uwana adadzəka maslək hi à guf aŋha à abà, fofulo anik tanìs à gay tetəvi, azla­ɗiyaŋ tasà à waŋ, tazùw à gay. ");
INSERT INTO mfh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Azlaanik aya tanìs à pala akur à afik uwana kutso lakəl məŋga aw, katskats asà à uda, kà uwana kutso la pala akur lakəl məŋga aw. ");
INSERT INTO mfh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mok uwana afats adadzəka mavəɗay la ndzəɗa agulà hi ala kà uwana aɓə̀k slilih kà à pala à akur à afik. ");
INSERT INTO mfh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Gotənaŋ fofulo anik tanìs à atàk à abà. Uwana atàk azigənay akə̀ɗ à tsəh, atsà à gəl aw. ");
INSERT INTO mfh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Bà gotənaŋ fofulo anik tanìs à kutso delga gà à abà. Asà à uda lela azigə̀ŋ lela, ŋgaha atsà gəl lela. Anik aɓə̀k à adi huməts, anik aɓə̀k à adi zuŋ, ŋgaha anik aya bay zazuŋ səla.” ");
INSERT INTO mfh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu agòɗ à atà: “Tsə̀ɓàwwal sləm lela, wàɗàw vok à uda kà mafal sləm!” ");
INSERT INTO mfh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mok uwana Yesu kokuɗa aŋha, azladza uwana tatsə̀ɓal sləm, la azlaməna matapla la slaka aŋha kulo gəl aŋha səla, tasà à waŋ à slaka aŋha, ŋgaha tanàv godega aŋa gay la gay la abà uwatà. ");
INSERT INTO mfh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu agòɗ à atà: “Akul kà, Zəzagəla avà à akul nasiri aŋa makoray aŋha, ama azladza anik tatsən tatak gesina kà say la gay la gay la abà pəra. ");
INSERT INTO mfh_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kà uwaga à uwana: ˈTanərzay la yewdi aŋatà babay, ama tanəŋaŋ la dziriga aw, Tatsəɓal sləm la sləm aŋatà babay, ama tatsənaŋ la dziriga aw, Kiya uwaga kà atà aŋa mawul à slaka Zəzagəla aw, ŋgaha Zəzagəla aŋa amatsa à atà tsakana aŋatà ala aw!ˈ” ");
INSERT INTO mfh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ŋgaha Yesu anàv à atà gay ala: “Katsənàw gay la gay la gay la abà uwanay aw takay? Kakay kadatsənaw gay la gay la abà anik zla ma? ");
INSERT INTO mfh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Masla masləkay kà masla mapəh gay Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Azladza anik kà bokuba gay tetəvi uwana fofulo anis ala ama: Mok uwana tatsənàŋ, katskats seteni asa à waŋ, aɓàɗ atà à ləv ala gay uwana tasləkà à ləv à tsəh. ");
INSERT INTO mfh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kiya uwaga bay la azladza anik tadəɓani slaka pala akur gà, à uwana gay anìs à afik, katskats uwana tatsə̀n gay kà takə̀s la marabay. ");
INSERT INTO mfh_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ama tasàkal adàla slilih la ləv aŋatà la tsəh aw, tafàl sləm la lela aw, takə̀s kà aŋa kaslà ŋuv pəra. La mok uwana ŋgərpa la matərəɓay adaɓəz atà kà gay Zəzagəla kà, katskats tasàk madiŋ gəl à vok aŋatà la tsəh ala. ");
INSERT INTO mfh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Azladza anik aya kà tadəɓani à vok la gày atàk uwana fofulo anìs à abà. Tatsə̀ɓ sləm à gay. ");
INSERT INTO mfh_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ama adi aŋa gudəŋ à vok uwanay la matsiɗay aŋha uwana apapàt azladza, adà à ləv aŋatà à tsəh, akə̀ɗ gay masləkayga uwaga à tsəh, ŋgaha azladza uwaga tav mayyay aw. ");
INSERT INTO mfh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Azladza anik aya gotənaŋ kà tadəɓani à vok la kutso uwana fofulo anìs à abà. Atà tatsə̀ɓ sləm à gay lela, tafàl sləm lela, tavà mayyay, anik aɓə̀k à adi huməts, azlaanik zuŋ, azlaanik aya gotənaŋ zazuŋ səla.” ");
INSERT INTO mfh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu agòɗ à atà aya: “Dza af fənəs à tsəh tasà takay, awma à tsəh gogozlàh ay? Awaŋ, aɗuwa vok kà dza af fənəs à slaka dzəgamma gà. ");
INSERT INTO mfh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bokuba magoɗay, tatak mahaɗəŋ à ahəŋ gà ada à gay mapəhla à vok ala gà. Ŋgaha nasiri gesina, azladza tadàsəlay. ");
INSERT INTO mfh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tsə̀ɓàwwal sləm lela à baŋa sləm aga akul lakəl.” ");
INSERT INTO mfh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesu agòɗ à atà aya: “Ɗahàw haŋkəli lakəl aŋa tatak uwana katsənawwaŋ la uwana kaɗa­hawwaŋ. La daram uwana kagoraw la azladza, Zəzagəla adàgor akul la uwaga la maza­kullaŋ à gəl suwaŋ. ");
INSERT INTO mfh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kà uwana dza uwana af sləm à uwana Zəzagəla avàl, adàɓəzal məŋga aya. Ama dza uwana af sləm à tatak aw, tadà­dəvalla à ahàl ala ŋuv gà uwatà Zəzagəla avàl aya babay.” ");
INSERT INTO mfh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu agòɗ à atà aya: “Məslala vok maga­gazləla makoray Zəzagəla kà la dza uwana asləkà fofulo à guf aŋha à abà. ");
INSERT INTO mfh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","La lig la ahəŋ kà say madzehal aŋha kəla mahənay pəra. La kaslà uwana fofulo adas à uda azigən la kokuɗa masəlay aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kutso azigəna makəl gay aŋa tatak: Teraŋa kavak gà, ŋgaha masəh gəl à uda, la maɓək bəza adi. ");
INSERT INTO mfh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mok uwana tatak adahənay, dza adzəka sləray la mavaw aŋha, kà uwana matsəɗ tatak adasa à waŋ.” ");
INSERT INTO mfh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu anàv à azladza la gay la: “La mana makoray Zəzagəla aɗəɓani vok ma? La gay la gay la abà ma uwala məga­gazləla makoray aŋha la? ");
INSERT INTO mfh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Aɗəɓani vok kà la tsəhay uwana bəziga gà la tataka azlatsəhay fofulo anik la abà gesina bokuba tsəhay hamadz. ");
INSERT INTO mfh_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ama baŋa azigənay kà, aɗuwa azla­ba­ɓasl anik anik gesina. Azigənay məŋga, aɗuwa azlaahàf anik, azləl ahàl məŋga, ŋgaha azla­ɗiyaŋ tadza à ahəŋ la dzəgay aŋha la abà.” ");
INSERT INTO mfh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kiya uwaga Yesu apə̀h à atà gay Zəzagəla la azlagay la gay la abà aŋuvaw bokuba uwanay. Apə̀h à atà kà bokuba uwana azladza taslalà vok aŋa matsənəŋ. ");
INSERT INTO mfh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Apə̀h à atà kà bà la gay la gay la abà pəra. Ama uwana masla la azlaməna matapla la slaka aŋha kokuɗa gəl aŋatà kà, apə̀h à atà ala tatak gesina la paraka. ");
INSERT INTO mfh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","La mokokhu vuɗ uwatà, Yesu agòɗ à azlaməna matapla la slaka aŋha: “Məhàd à gay dərəv uda anik.” ");
INSERT INTO mfh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kiya uwaga tasàk à maham à ahəŋ dza à ahəŋ, azlaməna matapla la slaka aŋha tadà à kəslah iyaw uwana à afik, Yesu atsà à vok à afik. Azlakəslah iyaw anik la ahəŋ la abatà bay aw. ");
INSERT INTO mfh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Magol kular adzəkà maɗəɗay. Magaŋ­tsay aŋa iyaw adàh à kəslah iyaw à abà, kiya uwaga kà ahənàŋ ala. ");
INSERT INTO mfh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu agà la godega kəslah iyaw la madzehal gà, afà gəl à tatak maf gəl à afik à afik. Azlaməna matapla la slaka aŋha tatsənàŋ ala la magoɗal: “Məŋga, məzlàmətsay, kafa à anu gəl aya aw, takay?” ");
INSERT INTO mfh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu atsənà ala, aslə̀h məlo à kular à gəl. Apə̀h la ndzəɗa à magaŋ­tsay aŋa iyaw: “Dzà à ahəŋ titi!” Kular atsìzl à ahəŋ, iyaw adzà à ahəŋ titi, magaŋ­tsay aŋa iyaw la ahəŋ aya aw, tsiriya. ");
INSERT INTO mfh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","La lig la ahəŋ agòɗ à azlaməna matapla la slaka aŋha: “Kà mana guba akə̀s à akul ma? Kadiŋaw gi gəl à vok aw ay?” ");
INSERT INTO mfh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Guba akə̀s atà məŋga tagòɗ kà atà kà atà: “Uwa à dza uwanay, amiyaka afaɗ la iyaw bay kà takəs gay aŋha uwa?” ");
INSERT INTO mfh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","La lig la ahəŋ tabəzà à gay dərəv uda aŋa gay dərəv aŋa Galili uwana la kutso Ge­ra­səniya la abà. ");
INSERT INTO mfh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Uwana Yesu adasa à ahəŋ la kəslah iyaw la afik, batsàrà dza anik anəŋà Yesu kərkər, asà à waŋ kà maga­gamay səla. Dza uwaga asà à waŋ kà la gày zəvay la abà, dza uwatà kà zagəla zagəla lakəl. ");
INSERT INTO mfh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Adzà à ahəŋ kà la mabuwaŋ zəvay la aku. Dza aslàla vok aŋa mawaɗəŋ à ahəŋ ba amiyaka la maza­kazak aw. ");
INSERT INTO mfh_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Aŋuvaw tawà­ɗà­halla ahàl à ahəŋ la azla­ma­ta­tasla ahàl, la sasala asik la azla­ma­za­kazak aŋa ada. Ama aslà­hàhàŋ ala la azla­manal sasala ala. Dza aslàla vok kà makəsiŋ à ahəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Koksi­koksi kəla mahənay la mavakay augu­za­hahay la azlagəl zəvay la azla­matəku­kurùh la afik la mawiyay la masàh vok aŋha la akur. ");
INSERT INTO mfh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Dza uwatà anəŋà Yesu kərkər ŋgaha ahàd la mahoyay à huma aŋha, atə̀ɗ à Yesu à huma. ");
INSERT INTO mfh_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Awiyà la ndzəɗa: “Masak à ama Yesu, Kona aŋa Zəzagəla uwana la afik. Kamkam gənava à ka, kà la sləm aŋa Zəzagəla: Sàk à gi, bàsak, kavà à gi ŋgərpa aw.” ");
INSERT INTO mfh_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Apə̀h uwaga kà, kà uwana Yesu afàl gay à gəl: “Kak zagəla zagəla: Sà à dza uwaga la kəl ala.” ");
INSERT INTO mfh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","La abatà Yesu anàval: “Uwa sləm aŋak uwa?” Masla zagəla zagəla agòɗal: “Sləm gulo kà maham à ahəŋ, kà uwana anu aŋuvaw. ");
INSERT INTO mfh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kamkam mədəv à ka kuɗa, kakuɗək anu la gudəŋ uwanay aw!” ");
INSERT INTO mfh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Maham à ahəŋ namzi la ahəŋ la abatà uwana tadzadzàr à vok nekwa la matəku­kurùh la afik. ");
INSERT INTO mfh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Azla­ma­sasəɗok mawi­siga tanàv à Yesu, tagòɗal: “Slə̀l anu à maham à ahəŋ namzi à abà pəra, và à anu tetəvi, məda à atà à gəl.” ");
INSERT INTO mfh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","“Aya, dàw!” Yesu agòɗ à atà. La kità azla­zagəla zagəla tasà à dza uwatà lakəl ala, ŋgaha tahàd à azla­namzi à gəl gesina. Batsàrà, tahòy à ahəŋ, tavàlàh à iyaw à abà, ŋgaha tasùfàh à abà. Azla­namzi uwaga gesina kà taslà dəbow səla. ");
INSERT INTO mfh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Azlaməna manəŋla azla­namzi tahòy aŋatà, tadàla gay uwaga kà maziŋ azladza bəza gudəŋ la azlahuɗ gudəŋ gesina la makoray uwatà. Azladza tasàhà à uda, tasà à waŋ kà manəŋ tatak uwana aɗahà vok. ");
INSERT INTO mfh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Uwana tabə̀z à slaka Yesu tanəŋà dza uwana agà la maham à ahəŋ zagəla zagəla lakəl, madza madzayga la lukut la vok, haŋkəli adawulla à gəl. Ləv avàl à azladza à gay. Guba akə̀s atà. ");
INSERT INTO mfh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Azlaməna manəŋ uwana apakà vok gesina kà, tazàhà gay aŋa dza uwana la zagəla zagəla lakəl uwarà la aŋa azla­namzi gesina bay. ");
INSERT INTO mfh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","La abatà tagòɗ à Yesu: “Kamkam, sà à uda la makoray gami.” Yesu asà à afik, ahàd à slaka kəslah iyaw. ");
INSERT INTO mfh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mok uwana adà à kəslah iyaw à afik, dza uwana agà la azla­zagəla zagəla lakəl uwarà, agòɗ à Yesu: “Kamkam, asa à gi mədaw səla.” ");
INSERT INTO mfh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ama Yesu avàl tetəvi aw: “Wùl à huɗ gày aŋak, zàhàtàŋ uwana Sufəl Zəzagəla aɗa­hàkàŋ gesina lakəl aŋa uwana vok ahàmal kà kak!”, agòɗal. ");
INSERT INTO mfh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dza uwaga adà aŋha zla, ŋgaha adzəkà mapahay la makoray uwana sləm aŋha gudəŋ kulo, à tatak uwana Yesu aɗa­hàlàŋ gesina. Azladza gesina uwana tatsə̀ɓ sləm à gay uwaga, gesina aŋatà, ləv avàl atà gay. ");
INSERT INTO mfh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu awùl à waŋ la gay dərəv uda anik la kəslah iyaw. La mok uwana ada­tsizl à ahəŋ la gay mukwà, maham à ahəŋ dza aŋuvaw ahamàl à adi. ");
INSERT INTO mfh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Məŋga aŋa gày Zəzagəla asà à waŋ, sləm aŋha Yayrus. Uwana anəŋàŋ Yesu akəɗèɗ à makəla asik aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Anàval, agòɗal: “Bəzi dugu gulo azlàmətsay. Kamkam, sà à waŋ, kaɓək ahàl à bəzi à vok kà masla mawur ala ŋgaha kà masla aɓəz sifa aŋha aya.” ");
INSERT INTO mfh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu asà à afik, tahàd atà səla, maham à ahəŋ dza aŋuvaw taŋìsl Yesu. ");
INSERT INTO mfh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mis anik la ahəŋ la abatà, aŋiz akəllal à tsəh ala dagay mavakay kulo gəl aŋha səla. ");
INSERT INTO mfh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Aday vok məŋga la madàh à slaka azlaməna mavàh yohof, az ləmana aŋha ala kà aŋuvaw. Ama aga ŋuləm aw: say mavədzehəŋ ala pəra. ");
INSERT INTO mfh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Vərdi anik atsənàŋ tapəhay lakəl aŋa Yesu, kiya uwaga afà à vok à maham à ahəŋ dza à abà. ");
INSERT INTO mfh_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Adzùgw la gəl aŋha: “Baŋa gədəɓani lukut aŋha pəra kà, gədà­wurla”, agòɗ. Aguwà la lig aŋa Yesu, adəɓanì lukut aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Batsàrà makəlay aŋiz aŋha atsìzl à ahəŋ, atapà vok aŋha kà adawur ala la ɗuvats aŋha la abà. ");
INSERT INTO mfh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","La mok uwatà Yesu atapà kà ndzəɗa asà à uda la vok aŋha. Agolà vok à maham à ahəŋ dza à abà la magoɗay: “Uwa à uwana adəɓanì lukut gulo uwa?” ");
INSERT INTO mfh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Azlaməna matapla la slaka aŋha tagòɗal: “Nəŋà maham à ahəŋ dza taŋisl ka tsi, pəra kanav madəɓiŋ ka aya ay?” ");
INSERT INTO mfh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesu anəŋà à makəla gəl kà masəl dza uwana aɗahà uwaga. ");
INSERT INTO mfh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Anasl adadiya à mis à vok kà uwana asə̀l uwana aɗahà vok la masla. Asà à waŋ, atə̀ɗ à makəla asik aŋa Yesu, apə̀hal dziriga aŋha gesina. ");
INSERT INTO mfh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu agòɗal: “Dugu gulo, madiŋal gəl à vok aŋak awurà ka ala. Hàd la wurwur, kada­wurla la ŋgərpa aŋak la abà!” ");
INSERT INTO mfh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mok uwana Yesu apə̀h gay uwaga kà, azlaməna masləlay tasà à waŋ la mtəga aŋa Yayrus, məŋga aŋa gày madəv kuɗa, tagòɗal: “Dugu aŋak kà adamətsay, kà mana katərə̀ɓ Sufəl aya ma?” ");
INSERT INTO mfh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ama Yesu afà sləm à gay aŋatà aw, agòɗ à Yayrus: “Ləv aval à kak à gay, kasak à madiŋal gəl à vok aw!” ");
INSERT INTO mfh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Avà tetəvi à dza kà malakəŋ aw, say Piyer, Yakuba la deda aŋha Yuhana pəra. ");
INSERT INTO mfh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mok uwana abə̀z à mtəga aŋa məŋga aŋa gày madəv kuɗa, Yesu atsənà hulolo aŋa azladza, la mataway, la mawiyay məŋga. ");
INSERT INTO mfh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu adà à gày, agòɗ à atà: “Kà mana kadzuɗəɗəkaw la mataway ma? Dugu uwanay kà, adamətsay aw, ama adzehal pəra!” ");
INSERT INTO mfh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Uwana azladza tatsənà uwaga: “Uwàà...”, tasakwà à ahəŋ, takəɗàslal. Kà uwaga: “Dàw à uda gesina!”, agòɗ à atà. Say Baba la iyà aŋa dugu la azlaməna matapla la slaka aŋha makər uwatà pəra tagə̀ɗ à gày. Uwana tahàd la gày uwana la aku tahənà dugu à agu. ");
INSERT INTO mfh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu akə̀s bəzi dugu la ahàl, agòɗal: “Ta­litha koum” (Bokuba magoɗay: Bəzi dugu sà à afik, gəgoɗ à ka) ");
INSERT INTO mfh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Katskats bəzi dugu asà à afik, adzəkà maday. (Mavay aŋha kà kulo gəl aŋha səla) La mok uwana tanəŋà uwaga kà, ləv avàl à atà à gay kaykay. ");
INSERT INTO mfh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ama Yesu afàhà à atà akur à lig kà aŋuvaw, kà atà mapəh à dza anik aw. Ŋgaha agòɗ à atà: “Vàwwal tatak may!” ");
INSERT INTO mfh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu azà vok la slaka uwatà, awùl à gudəŋ aŋha, uwana azigə̀n la abà. Azlaməna matapla la slaka aŋha tanəfà. ");
INSERT INTO mfh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Uwana vuɗ maduw ləv adasa à waŋ, adzəkà matapla tatak à azladza la gày madəv kuɗa la aku. Maham à ahəŋ dza aŋuvaw la abatà. Uwana tatsə̀ɓal sləm gesina kà, ləv avàl à atà à gay, tagòɗ: “Lala aɓəzà tsəhay gay uwanay la? Dzəɓa matsi­hila mana gà à uwanay aɓə̀zal ma? Kakay aɗehəŋ à tsəhay tatak dzəɓa aŋha səla aw gà uwanay ma? ");
INSERT INTO mfh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Dza uwanay kà masla mapəɗ kəslah aw takay? Kona aŋa Mari­yama, ŋgaha deda aŋa Yakuba, la Yosəs, la Yahuda, la azla Səmon aw ay? Azla­deda aŋha de­ga­gamga bay atà la uwanay anina la abanay aw takay?” Kà uwaga à uwana tadiŋal gəl à vok aw. ");
INSERT INTO mfh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu agòɗ à atà: “Tazləɓ masla mapəhal gay à ahàl aŋa Zəzagəla baməraka la mali, ama la gudəŋ aŋha kà tazləɓ masla aw, la tataka azla­yaga aŋha la abà, azlaməna gày aŋha kà tazləɓay aw!” ");
INSERT INTO mfh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesu aslàla vok kà maɗàh nadzipo la abatà dəŋ aw, say aɓə̀k ahàl à azlaməna ɗuvats anik à gəl ŋgaha awàr atà ala. ");
INSERT INTO mfh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ləv avàlal à gay kà uwana madiŋal gəl à vok aŋatà la ahəŋ aw. La lig la ahəŋ Yesu auguzàh la gudəŋ la abà gesina kà matapla gay Zəzagəla à azladza. ");
INSERT INTO mfh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu azàl azlaməna matapla la slaka aŋha kulo gəl aŋha səla, adzəkà masləl atà la səla səla, avà à atà maslay kà makor azla­ma­sasəɗok mawi­siga. ");
INSERT INTO mfh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Afàh à atà akur à lig, agòɗ à atà: “Kazəɓaw tatak à ahàl kà aŋa tetəvi aw, tatak may aw, kiwa aw, sili la zliba la aku aw, say azəva pəra. ");
INSERT INTO mfh_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ɓə̀kàw kwimik à asik, ama katsəpaw lukut səla à vok aw!” ");
INSERT INTO mfh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Agòɗ à atà bay: “Baŋa kadaw à gudəŋ à abà kà, dzàw à ahəŋ la mtəga aŋa dza uwana akəs akul lela tsəràh à uwana kadaw aŋkul la abatà. ");
INSERT INTO mfh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Azladza gudəŋ uwana takə̀s akul aw, ŋgaha tatsə̀n akul aw kà, kadaw aŋkul la abatà, dèɗàw burburu la asik ala kà mapəh à atà ala kà taɗàh mawi­siga.” ");
INSERT INTO mfh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Azlaməna matapla la slaka aŋha tahàd mapəh gay Zəzagəla, kà à azladza aŋa mapəh gay ləv ala, kà atà tasak à tsakana aŋatà. ");
INSERT INTO mfh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Takuɗə̀kàh azla­ma­sasəɗok mawi­siga aŋuvaw, taɗahàŋ amàl à azlaməna ɗuvats à gəl, aŋuvaw tawàr ala. ");
INSERT INTO mfh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Sufəl Herod atsənà gay aŋa Yesu, kà uwana azladza tasə̀l sləm aŋha baməraka la mali, tagòɗ: “Yuhana masla maɗàh batem adawul à uda, gay gà la uwaga aslàla vok aŋa maɗàh nadzipo”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Azlaanik tagòɗ aya: “Uwaga kà Eliya”, azlaanik bay: “Uwaga masla masləl à waŋ aŋa Zəzagəla bokuba tekula la tataka aŋa azlaməna mapəh à atà gay à ahàl uwana la abà uwarà”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Uwana Herod atsənà gay uwaga, agòɗ: “Uwaga Yuhana masla maɗàh batem uwana gəslə̀l dza kà manats gəl aŋha, masla la uwana adawul à uda la mamətsay.” ");
INSERT INTO mfh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kà uwana Herod la gəl aŋha apə̀h gay makəs Yuhana dagay uwarà, kà aŋa mawoɗəŋ à gày daŋay à agu. Aɗahàŋ kiya uwaga kà gay aŋa He­ro­diya, mis aŋa deda aŋha Filip, uwana Herod azə̀ɓ. ");
INSERT INTO mfh_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ama Yuhana agòɗ à Herod: “Uwaga kà delga aw, kà aŋa mazəɓ mis deda aŋak aw!” ");
INSERT INTO mfh_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kà uwaga He­ro­diya apàk ləv lakəl aŋa Yuhana, ayàh kà makəɗ masla. Ama aɓəzà à tetəvi aw kà Herod. ");
INSERT INTO mfh_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kà uwana guba azà Herod kà Yuhana, asə̀l kà masla dza dziriga ŋgaha sətaka gà, anə̀ŋla masla lela, asàl matsən gay aŋa Yuhana, ama uwana adatsen gay aŋha gesina kà, haŋkəli aŋha awìsa ala. ");
INSERT INTO mfh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mavakay delga aŋa He­ro­diya adasa à waŋ, uwaga mavakay aŋa mayyi Herod. Masla atà kaf à uda kà aŋa azlaməna aŋha, kà azlaməŋga aŋa azla­slodzi la azlaməŋga aŋa kutso Galili. ");
INSERT INTO mfh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bəzi dugu aŋa He­ro­diya adà à gày, ahàb dəs, arabà ləv aŋa Herod la azladza uwana tadzàh madzay atà nna. Sufəl Herod agòɗ à dahalay: “Mana asa à ka gəvà à ka ma? Nàv uwana asa à ka gesina, gəvà à ka”, agòɗal. ");
INSERT INTO mfh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Azùwal mawaɗay: “Uwana kanav à gi gesina gəvà à ka, amiyaka tenma aŋa makoray gulo bay.” ");
INSERT INTO mfh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dahalay asà à uda, agòɗ à iyà aŋha: “Mana gənavay ma?” Agòɗal: “Nàval gəl aŋa Yuhana masla maɗàh batem.” ");
INSERT INTO mfh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Katskats amərà vok kà mad à slaka sufəl, anàv la magoɗay: “Asa à gi kanəl gi gəl aŋa Yuhana masla maɗàh batem à tasà à abà.” ");
INSERT INTO mfh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Uwaga kà azà à sufəl la ləv məŋga, ama kà mazuw mawaɗay aŋha uwana azùw la huma aŋa azladza kà, aslàla vok kà makosal aw. ");
INSERT INTO mfh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Katskats sufəl aslə̀l slodzi kà manəl gəl aŋa Yuhana, kà aŋa masəlla à waŋ. Slodzi ahàd à gày daŋay à agu, anə̀l gəl aŋa Yuhana. ");
INSERT INTO mfh_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Asə̀lla gəl aŋa Yuhana à waŋ la tasà la abà, avà à dahalay. Dahalay bay adàla à iyà aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mok uwana azlaməna asik aŋa Yuhana tatsə̀n uwaga, tasà à waŋ kà mazəɓ vok aŋha, kà malay. ");
INSERT INTO mfh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Azlaməna matapla la slaka aŋha tawùl à waŋ à slaka Yesu. Tapə̀hal uwana taɗahàŋ, la uwana tatàpla à azladza. ");
INSERT INTO mfh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Azladza aŋuvaw tasà à waŋ, aŋuvaw tadàŋ atà, kiya uwaga Yesu la azlaməna matapla la slaka aŋha taɓəzà à tetəvi kà mazuw tatak may aw. Gay gà la uwaga Yesu agòɗ à atà: “Məhàd kokuɗa gami à fəta a abà, kà anu aŋa maduw ləv ŋuv.” ");
INSERT INTO mfh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tahàd la kəslah iyaw kokuɗa gəl aŋatà à fəta à abà. ");
INSERT INTO mfh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ama azladza aŋuvaw tanəŋà atà à uwana taday, aŋuvaw tasə̀l atà. Tasàhà à uda la gudəŋ la abà gesina tamərà vok la asik ŋgaha tatsà vok à huma kà Yesu la azlaməna matapla la slaka aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Uwana Yesu adasa à ahəŋ la kəslah iyaw la afik kà, anəŋà azladza aŋuvaw. Vok ahàmal kà atà, kà uwana anəŋà atà kà bokuba azla­tuwaŋ uwana masla manəŋla atà la ahəŋ aw. Adzəkà matapatàla tatak aŋuvaw. ");
INSERT INTO mfh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Uwana afats adatəɗ à ahəŋ, azlaməna matapla aŋha tasà à waŋ à slaka aŋha tagòɗal: “Afats adatəɗ à ahəŋ ŋgaha uwanay bay kà anu la fəta. ");
INSERT INTO mfh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wùlla azladza kà taday à bəza gudəŋ à abà la azlahuɗ gudəŋ kà tasukw tatak may aŋatà.” ");
INSERT INTO mfh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu awùlla à uda, agòɗ à atà: “Akul vàw à atà tatak may tazuw!” Tagòɗal: “Lala məɓəz tatak may kà madza­dzarla azladza kət uwanay la?” ");
INSERT INTO mfh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu anàv atà: “Kaf ma katay aga la akul la ahàl ma? Dàw, kanəŋàwwàŋ!” Uwana tanəŋə̀ŋ uwaga: “Kaf gay bərsew zlo la kilfi səla.” tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu agòɗ à azlaməna matapla la slaka aŋha, kà azladza tadzàhà madzay la dzibokw dzibokw la kəsaf biyaga la afik. ");
INSERT INTO mfh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tadzàhà madzay la dzibokw dzibokw, azlaanik dzim, azlaanik bay dzik zlo, dzik zlo. ");
INSERT INTO mfh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu ahə̀l kaf zlo la kilfi səla uwatà, anəŋà à zagəla, “Kikay”, agòɗ à Zəzagəla, ŋgaha atsəkà kaf ala, avà à azlaməna matapla la slaka aŋha kà mavàh à azladza. Kiya uwaga ahə̀lla kilfi səla uwatà ala bay, tavàh à maham à ahəŋ dza gesina. ");
INSERT INTO mfh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Atà gesina tazùw, aslàh atà. ");
INSERT INTO mfh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","La lig la ahəŋ azlaməna matapla la slaka aŋha tahamà gay mapətsèh pətsèh aŋa kaf uwana à vok atə̀mal à tsəh ala la kilfi səla uwatà, kà aɗahà takosà kulo gəl aŋha səla. ");
INSERT INTO mfh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Matugway aŋa azladza uwana tazùw kaf kà taslà zil dəbow zlo. ");
INSERT INTO mfh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesu afà à gay à azlaməna matapla aŋha à gəl kà tadiyà à kəslah iyaw à afik kà matsəvokay kà masla à gay dərəv uda anik, nekwa la Be­tsayda, mok uwana: ‘Dàw aŋkul!’, agoɗiyà à maham à ahəŋ dza. ");
INSERT INTO mfh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","La mok uwana tavàhla atà nna kà, Yesu adà aŋha à gudəŋ à afik kà madəv kuɗa. ");
INSERT INTO mfh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Uwana vəɗ adasa à waŋ, mok uwaga kəslah iyaw bay adabəzay à tataka iyaw à abà, ama Yesu aləg la vəɗah kokuɗa gəl aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Anəŋàŋ azlaməna matapla la slaka aŋha kà atà la ŋgərpa la abà kà madla kəslah iyaw, kà uwana afaɗ awùl à atà à adi. Uwana azlagay matuway gotsak, Yesu adà à awtày à slaka aŋatà lakəl iyaw. Asal matsəv­kay kà atà. ");
INSERT INTO mfh_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Uwana tanəŋàŋ aday lakəl iyaw kà, atà tadzùgw kà tatak mavavat dza, tadzəkà mawiyay, ");
INSERT INTO mfh_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kà uwana atà gesina tanəŋàŋ, ŋgaha guba akə̀s atà. Ama katskats Yesu aɓa­ɗa­tàmà, agòɗ à atà: “Wàɗàw vok à uda, uwaga kà gi ŋwà!” ");
INSERT INTO mfh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ahàd à kəslah iyaw à afik la slaka aŋatà, afaɗ akəsà à asik. Azlaməna matapla la slaka aŋha tahàn ala la madzugway məŋga, ləv avàl à atà à gay. ");
INSERT INTO mfh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kà uwana tasə̀l godega aŋa nadzipo aŋa kaf uwatà aw, kà uwana haŋkəli aŋatà aslà kà aŋa matsən godega aŋa tatak uwatà aw. ");
INSERT INTO mfh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Uwana tadùw à uda à gay dərəv anik kà, tawàɗà kəslah iyaw aŋatà à gay gərdza, tabə̀z à kutso aŋa Ge­ne­saret à abà. ");
INSERT INTO mfh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mok uwana tasà à ahəŋ la kəslah iyaw la afik kà, katskats azladza tasə̀l Yesu. ");
INSERT INTO mfh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tadàh à gudəŋ à abà la mahoyay, tadzəkà masàhla à waŋ azlaməna ɗuvats la kəslah la slaka gesina. ");
INSERT INTO mfh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bà kəla slaka uwana Yesu adà à abà, baməraka la azlaməŋ gudəŋ la abà, la azlabəza gudəŋ la abà gesina azladza tasàhla azlaməna ɗuvats aŋatà à waŋ à vada­vaday kasukwa à afik, ŋgaha azla­uwana tadə̀vàhal kuɗa kà madəɓani amiyaka gay aŋa lukut aŋha, tawàr ala. ");
INSERT INTO mfh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Azla Farisəya la azlaanik la tataka aŋa azla­ma­dza­haga aŋa wakità seriya aŋa Zəzagəla la abà tasà à waŋ à gudəŋ Uru­sa­lima, tahamà gay à vok la slaka Yesu. ");
INSERT INTO mfh_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tanəŋàŋ azlaanik la tataka azlaməna matapla aŋa Yesu la abà tazùw tatak may la kokuɗa matsuf manəfay aŋatà. ");
INSERT INTO mfh_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kà uwana azà à azla Farisəya la azla Yahu­diya gesina takə̀s lakəl aŋa matapla aŋa azla­baba aŋatà madzi­dziga, tazùw tatak may kokuɗa mapal ahàl aw. ");
INSERT INTO mfh_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Baŋa tawùl à waŋ la kasukwa tazùw tatak may dàŋ aw, say baŋa tapàl vok lela. Takə̀s gay aŋa azla­baba madzi­dziga kà məŋga. Uwana azla­baba madzi­dziga taɗa­hàhàŋ delga bokuba mapalal azlakətsaw, la azla­masik, la azla­tasà vərze­gani ŋgaha la kəslah mahən à afik aŋuvaw. ");
INSERT INTO mfh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Azla Farisəya la azla­ma­dza­haga aŋa wakità seriya aŋa Zəzagəla tanàv à Yesu: “Kà mana azlaməna matapla la slaka aŋak tatsùf gay aŋa azla­baba gami madzi­dziga aw ma? Tazùw tatak la ahàl àlàhga ma?” ");
INSERT INTO mfh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu awùlla à atà ala: “Hay! Azlayla masla mapəhal gay à ahàl aŋa Zəzagəla Yesayya asə̀l madzugway aŋkul lela. Akul azlaməna magolla dza, bokuba uwana tatsetsèr à wakità Zəzagəla à abà, Zəzagəla agòɗ: ˈAzladza uwanay tazləɓ gi la gay pəra, ama ləv aŋatà kà kərkər la gi! ");
INSERT INTO mfh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tagoɗ kà, tawoya gi, ama gay aŋatà kà deyday pəra, kà uwana tapàh mapəhay aŋa azla­baba aŋatà kà bokuba mapəhay aŋa Zəzagəla.ˈ” ");
INSERT INTO mfh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesu agòɗ à atà: “Kasakaw à mapəhay aŋa Zəzagəla, ŋgaha kanəfaw matapla aŋa azladza!” ");
INSERT INTO mfh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ŋgaha Yesu agòɗ à atà aya: “Hay, kasəlaw makweska gay makoray aŋa Zəzagəla kà makəs mapəhla ala aŋkul. ");
INSERT INTO mfh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa agòɗ: ˈZlə̀ɓà baba aŋak la iyà aŋak. Dza uwana aɗaha à atà mawi­siga à vok, say makəɗay.ˈ ");
INSERT INTO mfh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ama akul kagoɗaw kà: Baŋa dza agòɗ à baba aŋha baŋaw à iyà aŋha: ‘Tenma aŋa tatak gulo uwana asa à gi mav à ka kà mazlak kà, kà uwaga kà Kor­ban.’ (Bokuba magoɗay, tatak mavi­yàga à Zəzagəla) ");
INSERT INTO mfh_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","La lig la ahəŋ kasakaw dza uwana azlak baba baŋaw iyà aŋha ɗiki­ɗiki aya aw. ");
INSERT INTO mfh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kiya uwaga kawi­sèwwàŋ gay Zəzagəla ala la gay matapla aŋkul. Uwana kazà­hàwwàŋ vok gesina, ŋgaha kapàkàw aŋkul ala kà gay Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","La abatà Yesu azàla à maham à ahəŋ dza aya, agòɗ à atà: “Tsə̀ɓàw gi sləm gesina aŋkul, tsənàw gay uwanay”, agòɗ à atà, ");
INSERT INTO mfh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","“Tatak uwana dza azuway kà aɗàh àlàh à dza à vok aw, say uwana atsa à uda la ləv aŋa dza la tsəh la uwana aɗàh àlàh. ");
INSERT INTO mfh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tsənàwwàŋ lela, baŋa sləm aga à akul lakəl aŋa matsənəŋ!” ");
INSERT INTO mfh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mok uwana Yesu adasak à maham à ahəŋ, adà à gày, azlaməna matapla la slaka aŋha tanàval gay lakəl aŋa gay la gay la abà uwatà. ");
INSERT INTO mfh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ŋgaha Yesu agòɗ à atà: “Akul babay, kaslawwal à vok aŋa matsənəŋ aw ay? Tatak uwana adiya à huɗ aŋa dza atsa à uda aslala vok maɗàh àlàh à dza à vok aw, ");
INSERT INTO mfh_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","kà uwana adiya à ləv à tsəh aw, ad à huɗ, atsa à uda!” (La gay uwaga la abà Yesu apə̀h kà dèwdèw tatak may gesina kà, azuw vok) ");
INSERT INTO mfh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ŋgaha agòɗ à atà aya: “Uwana atsa à uda la ləv aŋa dza la tsəh la uwana aɗàhla àlàh. ");
INSERT INTO mfh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kà uwana la ləv aŋa dza la uwana madzugway mawi­siga atsa à uda uwana adala dza à mabila à abà, mad gəl, makəɗ dza, ");
INSERT INTO mfh_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","à gəl gaw, adi, maksa­fər, ɗemɗem, maŋor, mapəh mawi­siga lakəl aŋa dza anik, zlapay, masəl gəl aw. ");
INSERT INTO mfh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Dèwdèw tatak mawi­siga uwanay gesina atsa à uda la ləv aŋa dza la tsəh, uwaga la uwana aɗahla tsakana.” ");
INSERT INTO mfh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ŋgaha Yesu atsìzlla ala la abatà, ahàd à gay makwi aŋa gudəŋ Tir. Adà à gày anik à abà, asàl kà azladza tasə̀l slaka uwana masla la abà aw, ama aslàla vok aŋa mahaɗ vok à ahəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mis anik uwana dugu aŋha la masasəɗok mawi­siga lakəl atsənà gay lakəl aŋa Yesu. Katskats asà à waŋ à slaka aŋha, akədèɗal à makəla asik aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mis uwaga kà məlok gà, tayyà à gudəŋ Fe­nesəya uwana la kutso Səriya la abà. Adə̀v kuɗa à Yesu kà makuɗək masasəɗok mawi­siga à dugu aŋha lakəl ala. ");
INSERT INTO mfh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ama Yesu agòɗal: “Sàk azlabəza tahanla dadàŋ, mazəɓ tatak may aŋa azlabəza aŋa maməl à azlakəda à ahəŋ kà delga aw.” ");
INSERT INTO mfh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mis awùlla à uda: “Sufəl gulo, azlakəda kà uwana la makəla kəslaɗ atàɗ kà azlabəza à vəɗah, la uwana tatsa­tsamay!” ");
INSERT INTO mfh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu awulàlla: “Kà gay aŋak uwanay kà, dà aŋak à mtəga, masasəɗok mawisiga adasiya à dugu aŋak lakəl ala!” ");
INSERT INTO mfh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Awùl aŋha à mtəga, aɓə̀z à bəzi aŋha à gəl mahən à ahəŋ gà la azlav la afik, masasəɗok mawi­siga adasal à kəl ala. ");
INSERT INTO mfh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ŋgaha Yesu asà à uda la kutso aŋa Tir. Aguwà la Sədon, ŋgaha awùl à gay dərəv Galili, aguwà la makoray aŋa azla­gu­dəŋ kulo la abà. ");
INSERT INTO mfh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tasàlla dza mada­ga­zlamga uwana à waŋ, aslàla vok maɓaɗma aw, tadə̀val kuɗa kà maɓəkal ahàl à gəl kà mawuriŋ ala. ");
INSERT INTO mfh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu adàla à uda la tataka maham à ahəŋ dza la abà, atsìzllàŋ à ahəŋ kokuɗa aŋha, adùwal gay gəl ahàl à sləm à abà, atə̀f slesliɓ à ahàl, adəɓanì alàh aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Anəŋà à zagəla, abàs vok la tsəh ala, agòɗ à dza: “Ephphatha!” (Bokuba magoɗay: Pə̀zlla à ama ala!) ");
INSERT INTO mfh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","La kirim yewdi sləm aŋha aslàh ala. Katskats tatak uwana awàɗla alàh à ahəŋ, apə̀zlla, aɓaɗmà lela. ");
INSERT INTO mfh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu afahà à atà akur à lig, kà tapə̀h à dza aw. Ama bà la mafàh à atà akur à lig, uwaga tapàh gesina. ");
INSERT INTO mfh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ləv avàl à azladza à gay məŋga, tagòɗ: “Aɗahaŋ kà dzəɓa aŋha səla aw, aɗahaŋ kà azla­ma­da­gazlam aŋa matsən sləm, azla­uwana taslàla vok aŋa maɓaɗma aw bay taɓaɗma adagay!” ");
INSERT INTO mfh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","La vuɗ uwatà maham à ahəŋ dza aŋuvaw tahamà gay à vok aya la slaka Yesu. Uwana tatak may aŋatà la ahəŋ aw, Yesu azàla azlaməna matapla à slaka aŋha, agòɗ à atà: ");
INSERT INTO mfh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kay, vok aham à gi kà azladza uwanay, kà uwana anina dagay mahənay makər lagwa, tatak may aŋatà bay adadəv kà atà à gay. ");
INSERT INTO mfh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Baŋa gəwulla atà à mtəga anatà la may gà kà, tadàtaɗ à ahəŋ la tetəvi la ama, kà uwana azlaanik kà tasà à waŋ kà kərkər.” ");
INSERT INTO mfh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Azlaməna matapla la slaka aŋha tagòɗal: “Lala məɓəz tatak may kà aŋa azladza gesina uwanay la kəsaf la abà la?” ");
INSERT INTO mfh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu anàv à atà gay ala: “Kaf gay bərsew nna aga à akul la ahàl ma?” “Gay bərsew məɗəf”, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu agòɗ à azladza: “Dzàhàw madzay!” Ŋgaha ahə̀l kaf gay bərsew məɗəf uwatà, “Kikay”, agòɗ à Zəzagəla, atsakà kaf ala, avà à azlaməna matapla la slaka aŋha, ŋgaha azlaməna matapla aŋha tavàhà à atà. ");
INSERT INTO mfh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kilfi bəziga la ahàl aŋatà aya, Yesu ahə̀l, “Kikay”, agòɗ à Zəzagəla, avà à azlaməna matapla la slaka aŋha kà mavàh à azladza. ");
INSERT INTO mfh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Gesina aŋatà tazùw, aslàh à atà. Azlaməna matapla la slaka aŋha tahàm à gay mapətsèh pətsèhga à vok takosà məɗəf à uwana atàm à atà à ahàl. ");
INSERT INTO mfh_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Azladza uwana tazùw kaf uwaga taslà dəbow ufaɗ. Ŋgaha adàgay kà: “Dàw à mtəga aŋkul!”, Yesu agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Katskats ahàd à kəslah iyaw à afik la azlaməna matapla la slaka aŋha, tahàd à kutso Dalma­nuta. ");
INSERT INTO mfh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Azla Farisəya anik tadà à awtày, tadzəkà mabay vok gay la Yesu. Asà à atà makəsay, gay gà la uwaga tanàv nadzipo la slaka aŋha, kà mapəhatàla, ŋgaha atà aŋa masəlay kà ndzəɗa aŋha asà à waŋ kà la slaka Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu abàs vok la ndzəɗa, ŋgaha agòɗ: “Kà mana azladza aŋa lakana tanav à gi nadzipo ma? Gəpəh à akul la dziriga: Gədàpəhakulla nadzipo ɗiki­ɗiki aw.” ");
INSERT INTO mfh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ŋgaha asàk atà à ahəŋ, ahàd à kəslah iyaw à afik aya, ahàd à gay məŋ dərəv anik. ");
INSERT INTO mfh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Avika azlaməna matapla aŋa Yesu kà mahəl kaf à ahàl. Tatak may la ahəŋ la slaka aŋatà la kəslah iyaw la afik aw, say kaf gay bərsew tekula pəra. ");
INSERT INTO mfh_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu afahà à atà akur à lig, agòɗ à atà: “Ɗàw haŋkəli kà tatak makəsl tatak ala aŋa azla Farisəya la aŋa Herod.” ");
INSERT INTO mfh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Azlaməna matapla la slaka aŋha tavàts gay la tsəh ala kà atà kà atà la tataka aŋatà la abà, tagòɗ: “Apə̀h uwaga kà, kà uwana kaf aga anu la ahàl aw.” ");
INSERT INTO mfh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu asə̀l uwana tadzugway, anàv atà gay ala: “Kà mana kavatsaw gay la tsəh ala ma? Kà uwana kaf aga akul la ahàl aw ay? Kasəlaw tatak uwanay gotənaŋ aw uwà? Katsənaw godega aŋha aw, bà gotənaŋ ay? Matsi­hila aŋkul ma matsak à ama à gay ay? ");
INSERT INTO mfh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yewdi aga à akul la vok, ama kanəŋawla aw ay? Sləm aga à akul lakəl, ama katsənawlaŋ aw? Awul akul à gəl gotənaŋ aw ay? ");
INSERT INTO mfh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kaf gay bərsew zlo uwana gətsàkàŋ ala kà aŋa azladza dəbow zlo, ma takosà nna à mapətsèh pətsèhga à uwana kaha­màwla gay à vok ma?” “Kulo gəl aŋha səla”, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ŋgaha Yesu anàv à atà gay ala aya: “Kaf gay bərsew məɗəf uwana gətsàkàŋ ala kà aŋa azladza dəbow ufaɗ bay, ma takosà nna à mapətsèh pətsèhga à uwana kaha­màwla gay à vok ma?” “Məɗəf”, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“La kità”, Yesu agòɗ à atà: “Kakay katsənaw godega aŋha aw gotənaŋ zlà ma?” ");
INSERT INTO mfh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Uwana tabə̀z à gudəŋ Be­tsayda, tasàlla guləf à waŋ. Tadə̀val kuɗa kà aŋa madəɓani guləf, kà masla mawur ala. ");
INSERT INTO mfh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu akə̀s guləf à ahàl, adàla à uda la gudəŋ la abà, ŋgaha adə̀ɓal slesliɓ à yewdi, aɓə̀kal ahàl à gəl, ŋgaha anàv à dza uwaga: “Kanəŋa tatak ay?” ");
INSERT INTO mfh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Guləf anə̀ŋ à zagəla, agòɗal: “Gənaŋa azladza, ama gənəŋa atà kà bokuba azlaahàf uwana taday.” ");
INSERT INTO mfh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Bà gotənaŋ, Yesu adəɓanì yewdi aŋa guləf aya. Masla atsə̀k yewdi à uda la ndzəɗa, anə̀ŋla, anəŋà azla­tatak gesina la paraka. ");
INSERT INTO mfh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ŋgaha la lig la ahəŋ, Yesu agòɗal kà: “Hàd à mtəga aŋak, kada à gudəŋ à abà aw!” ");
INSERT INTO mfh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","La lig la ahəŋ, Yesu ahàd à azlabəza gudəŋ uwana à abà la kutso Zəsare, uwana la makoray aŋa Filip la azlaməna matapla la slaka aŋha. Yesu anàv à atà gay ala la tetəvi la ama: “Azladza ma uwa tagòɗ kà gi ma?” ");
INSERT INTO mfh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tawùlla à uda: “Azadza anik tagoɗ, kà kak Yuhana masla maɗàh batem, azlaanik tagoɗ, kà kak Eliya, azlaanik aya tagoɗ, kà kak tekula la tataka azladza uwana la abà, Zəzagəla aslàl atà à waŋ uwarà.” ");
INSERT INTO mfh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Iyay zla! Ama akul ma, gi uwa kagoɗaw uwi?”, Yesu anàv à atà. Piyer awùl à uda, agòɗal: “Kak, dza uwana Zəzagəla afà à ka dzakwa à gəl.” ");
INSERT INTO mfh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu afahà à atà akur à lig la magoɗ à atà: “Kapəhawla gi ala la slaka azladza aw!” ");
INSERT INTO mfh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","La lig la ahəŋ, Yesu adzəkà matapla azlaməna matapla la slaka aŋha: “Say Kona aŋa dza as ŋgərpa məŋga. Azlaməŋga, azla­ma­siga, la azlaməna mav tatak à Zəzagəla, la azla­ma­dza­haga aŋa wakità seriya aŋa Zəzagəla tadà­kweska, ŋgaha tadàkəɗa. La lig aŋa mahənay makər adàwul à uda la mamətsay.” ");
INSERT INTO mfh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Apə̀h à atà gay uwaga la paraka. Piyer akə̀s Yesu à ahəŋ kokuɗa aŋha, adzəkà mafahal akur à lig la magoɗay: “Kapəh kiya uwaga aw!” ");
INSERT INTO mfh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ama Yesu agolà à vok, anəŋà azlaməna matapla anik à adi, ŋgaha adzəkà maslàh məl à Piyer à gəl, agòɗal: “Zà à vok la slaka gulo, kak seteni, kà uwana madzugway aŋak kà bokuba aŋa Zəzagəla aw, ama kiya aŋa azladza.” ");
INSERT INTO mfh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ŋgaha Yesu azàl à maham à ahəŋ dza, la azlaməna matapla la slaka aŋha, agòɗ à atà: “Baŋa dza asal manəf gi kà, say asak maf gəl à azla­tatak aŋha à tsəh, azəɓ ahàf mamətsay aŋha, ŋgaha anəf gi, bokuba uwana gədàzəɓay suwaŋ. ");
INSERT INTO mfh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kà uwana uwa­bey­uwi, uwana asal maɓəl sifa aŋha la ahàl aŋha, az gəl aŋha ala. Ama uwa­bey­uwi, uwana az sifa aŋha ala kà gi, ŋgaha kà gay matsi­ɗayga aŋa Zəzagəla kà, masla adàɓəl sifa aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mana akəsa vok à dza uwana aɓəza tatak aŋa gudəŋ à vok gesina, ama az sifa aŋha ala ma? ");
INSERT INTO mfh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tatak la ahəŋ, dza avày kà masukwla sifa aŋha takay? ");
INSERT INTO mfh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Gay gà la uwaga, baŋa ziruwi az dza kà gi, ŋgaha kà gay gulo lakana la tataka azladza uwana takəs gay aŋa Zəzagəla aw la abà, ŋgaha taɗehəŋ mawi­siga, kiya uwaga kà Kona aŋa dza ziruwi adàkəsay kà masla suwaŋ, la mok uwana adàwul à waŋ la mazləɓay aŋa Baba aŋha la abà la azla­ma­lika aŋha.” ");
INSERT INTO mfh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu agòɗ à atà aya: “Haɗay, gəgoɗ à akul, azladza anik uwana la abanay kà, tadàmətsay ɗiki­ɗiki aw, say baŋa tanəŋ makoray Zəzagəla atsa à waŋ la ndzəɗa.” ");
INSERT INTO mfh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Uwana mahənay mukwa adada à lig, Yesu ahə̀l azla Piyer, Yakuba, Yuhana ŋgaha tahàd à matsəkəkaɗay gudəŋ à afik kokuɗa gəl aŋatà. La abatà aɓə̀ɗla vok à ahəŋ la huma yewdi aŋatà. ");
INSERT INTO mfh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Lukut aŋha apàk me­ɗe­kuga mawu­tsəɗayga təlla. Dza la ahəŋ la gudəŋ la vok awuɗ lukut ala kiya uwatà aw. ");
INSERT INTO mfh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ŋgaha azlaməna matapla la slaka aŋha makər uwatà tanəŋà Eliya la Musa taɓaɗmà la Yesu. ");
INSERT INTO mfh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piyer agòɗ à Yesu: “Sufəl gulo, delga kà anu la abanay. Sàk anu məɗàh safsaf makər, tekula aŋak, tekula aŋa Musa, tekula aŋa Eliya.” ");
INSERT INTO mfh_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piyer asə̀l tatak uwana anakà apəhay aw, kà uwana guba akə̀s masla la azlaməna matapla anik səla uwanay. ");
INSERT INTO mfh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Habaga asà à waŋ, akə̀l atà mələs à adi. La habaga uwatà la abà kà tatsənà dza aɓaɗmà la abà: “Uwaga kà bəzi gay ləv gulo uwana gəwoyaŋ, tsə̀ɓàwal sləm!” ");
INSERT INTO mfh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Katskats azlaməna matapla makər uwatà tanàŋla, ama tanəŋà dza aw, say Yesu kokuɗa gəl aŋha la slaka aŋatà pəra. ");
INSERT INTO mfh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Uwana tatsà à ahəŋ la gudəŋ la afik, Yesu afàh à atà akur à lig kà atà aŋa mapəh tatak uwana tanəŋàŋ à dza aw, say baŋa Kona aŋa dza adàwul à uda la mamətsay dadàŋ. ");
INSERT INTO mfh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Takə̀s gay uwatà, ama tanà­vàhà vok kà atà kà atà: “Mana asal magoɗay mawul à uda la mamətsay ma?” ");
INSERT INTO mfh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Gay gà la uwaga tanàv la slaka Yesu: “Kà mana à azla­ma­dza­haga aŋa wakità seriya Zəzagəla tagòɗ kà, say Eliya atsa à vok à waŋ dàŋ ma?” ");
INSERT INTO mfh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Agòɗ à atà: “La dziriga, say Eliya atsa à vok à waŋ, adàɗah tatak à ahəŋ gesina. Ama kà mana zlà ma tatsetsèr à wakità Zəzagəla à abà bay kà, say Kona aŋa dza as ŋgərpa məŋga ma, ŋgaha azladza tanərəz kà bokuba dza delga aw ma? ");
INSERT INTO mfh_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ama gəgòɗ à akul: Eliya asà à waŋ, ŋgaha azladza taɗa­hàl­làŋ à vok uwana asà à atà gesina, bokuba uwana tatsetsèr à wakità Zəzagəla à abà lakəl aŋha.” ");
INSERT INTO mfh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mok uwana tabə̀zìyà à azlaməna matapla anik à vok, tanəŋà maham à ahəŋ dza aŋuvaw uwana takə̀s atà gay à adi. Azla­ma­dza­haga aŋa wakità seriya aŋa Zəzagəla tabày vok à gay la azlaməna matapla aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Uwana azladza tanəŋà Yesu kà, tadzà à ahəŋ titi. Katskats tadà à awtày à slaka aŋha la mahoyay kà maskuwiŋ. ");
INSERT INTO mfh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu anàv à azlaməna matapla la slaka aŋha la gay ala: “Kà mana kabayaw vok gay akul nna ma?” ");
INSERT INTO mfh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dza tekula la tataka maham à ahəŋ dza la abà awùlalla: “Məŋga, gəsàla bəzi gulo zilga à waŋ, kà uwana masla la masasəɗok uwana avàl tetəvi aŋa maɓaɗma aw. ");
INSERT INTO mfh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Baməraka la mali beli masasəɗok akàsàh, amàlal gəl à ahəŋ, huzləv asàhal à gay ala la mapaɗ sliɗ la tsəh ala. Vok aŋha apa­kahay dzaŋ­dzaŋ. Gədə̀v kuɗa à azlaməna matapla la slaka aŋak kà makuɗək masasəɗok mawi­siga uwaga, ama taslàla vok aw.” ");
INSERT INTO mfh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu agòɗ à atà: “Kay, madiŋal gəl à vok aŋkul la ahəŋ aw takay? Dagay mbà gədadza à ahəŋ la akul ma? Dàgay mbà gədà­ba­sa­kulaŋ ma? Sàwgəla bəzi à waŋ!” ");
INSERT INTO mfh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tasəlla bəzi à slaka Yesu, mok uwana bəzi adanəŋ Yesu, katskats masasəɗok abiyà bəzi, atə̀ɗ à vəɗah, abàbal, huzləv asàl à gay ala. ");
INSERT INTO mfh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu anàv à baba aŋa bəzi: “Dagay mbà tatak uwanay azəŋ ma?” Baba agòɗal: “Dagay la vərnaga. ");
INSERT INTO mfh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Aŋuvaw masasəɗok mawi­siga uwaga amà­làhal à gəl akàl à abà, à iyaw à abà kà makəɗay. Ama kamkam, baŋa kaslala vok mazlak anu, kà vok aham à ka, kà anu!” ");
INSERT INTO mfh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu agòɗal: “Kà mana kagoɗ kà: Baŋa kaslala vok ma? Dza uwana adiŋal gəl à vok aslala vok kà maɗàh tatak gesina.” ");
INSERT INTO mfh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Katskats baba aŋa bəzi awiyà: “Gədiŋal gəl à vok, ama zlàk à gi, kà uwana madiŋal gəl à vok gulo kà à tsəh ala!” ");
INSERT INTO mfh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu anəŋà maham à ahəŋ dza tatsà à waŋ à slaka aŋatà, aslə̀h məl à masasəɗok uwana à gəl, aɗə̀ɗ gay à dza à ahəŋ aŋa maɓaɗma la matsən sləm: “Kak, masasəɗok mada­ga­zlamga, sà à dza uwanay lakəl ala, gəgoɗ à ka, kadàdal à gəl ɗiki­ɗiki aya aw!” ");
INSERT INTO mfh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Masasəɗok awiyà, ago­dzàlla bəzi, asà à uda la masla la abà. Bəzi apàk bokuba mamətsayga. Kiya uwaga azladza aŋuvaw uwana la abatà tagòɗ kà adamətsay. ");
INSERT INTO mfh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ama Yesu akə̀s bəzi la ahàl, atsìzllàŋ ala, dzawwa bəzi agə̀ɗ à zagəla à tsəh. ");
INSERT INTO mfh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","La lig la ahəŋ, mok uwana Yesu adawul à gày, azlaməna matapla la slaka aŋha tanàvla gəl à gəl: “Kà mana anu kà, məslàla vok aŋa makuɗəkay aw ma?” ");
INSERT INTO mfh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu agòɗ à atà: “Makuɗək tsəhay masasəɗok uwanay kà, say la madəv kuɗa. Ndzəɗa anik la ahəŋ aw.” ");
INSERT INTO mfh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tadà aŋatà la abatà, taguwà à uda la kutso Galili la abà. Yesu kà asàl kà dza asəl slaka madz à ahəŋ aŋha aw, ");
INSERT INTO mfh_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kà uwana atapəlà azlaməna matapla la slaka aŋha, agòɗ à atà: “Kona aŋa dza tadà­viya à ahàl aŋa azladza. Atà tadàkəɗay, ama la lig la ahəŋ gədàwul à uda la mamətsay la mahənay makər.” ");
INSERT INTO mfh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Azlaməna matapla la slaka aŋha tatsənà godega aŋa gay uwatà aw, ŋgaha guba akə̀s atà bay kà manaval. ");
INSERT INTO mfh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tabə̀z à gudəŋ Kaper­nahum. Uwana tadà à gày, Yesu anàv à azlaməna matapla la slaka aŋha: “Kà mana kabàyàw vok gay la tetəvi la ama ma?” ");
INSERT INTO mfh_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ama tadzà à ahəŋ titi, kà uwana la tetəvi la ama kà, tabayà à vok à gay haɗay, tagòɗ: “Uwa məŋga la tataka gami la abà uwa?” ");
INSERT INTO mfh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu adzà madzay, azàl azlaməna matapla la slaka aŋha kulo gəl aŋha səla, agòɗ à atà: “Baŋa dza asal mapak mazəɓ gəl gà kà, say apak mabəziga bəziga aŋa azladza gesina, apak masla mazəɓ à atà kiwa.” ");
INSERT INTO mfh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yesu azə̀ɓ bəzi ŋuvga à ahàl, atsìzlla atà à huma à gay. Akə̀s bəzi la ahàl, agòɗ à azlaməna matapla la slaka aŋha: ");
INSERT INTO mfh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Uwa­be­yuwi uwana akəs bəzi ŋuvga uwanay kà sləm gulo kà, akəs gi. Ŋgaha uwa­be­yuwi uwana akəs gi kà, akəs gi pəra aw, ama akəs masla masləl gi à waŋ.” ");
INSERT INTO mfh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yuhana agòɗ à Yesu: “Sufəl gulo, mənəŋà dza anik uwana akuɗə̀k masasəɗok mawi­siga la sləm aŋak, ama mədèɗal gay à ahəŋ, kà uwana anəfà anu aw.” ");
INSERT INTO mfh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ama Yesu agòɗ à atà: “Kaɗe­ɗawwal gay à ahəŋ aw, kà uwana dza la ahəŋ aɗàh nadzipo la sləm gulo pəra, la lig la ahəŋ kà, atugw à gi gay à vok aw. ");
INSERT INTO mfh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kà uwana uwa­be­yuwi uwana masla məzam gami aw, kà slawda gami. ");
INSERT INTO mfh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Sə̀làw kà, dza uwana adàvà à akul kətsaw iyaw, kà uwana akul aŋa dza uwana Zəzagəla afàl dzakwa à gəl kà, adàɓəz à masik aŋha.” ");
INSERT INTO mfh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Dza uwana adukw tekula aŋa azlabəza uwanay à ahəŋ à tsakana à abà, tadiŋ gi gəl à vok kà, masla kà ŋuləm tawaɗal nəvol akur à kuda, taməla à dərəv à abà. ");
INSERT INTO mfh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Baŋa kà ahàl aŋak la uwana katəɗ à tsakana à abà, nàts à tsəh ala, ŋuləm kà kaɓəz à sifa la ahàl tekula, kà magay la ahàl səla nna, uwana adàdala kà à gày akàl uwana à abà adàməts ala aw. (( ");
INSERT INTO mfh_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","La abatà madu­wari uwana azuw vok amətsay aw, ŋgaha akàl bay amats ala aw.)) ");
INSERT INTO mfh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Baŋa kà asik aŋak la uwana katəɗiya à tsakana à abà kà, nàts à tsəh ala. Ŋuləm kaɓəz à sifa la asik tekula, kà mad à gudùh akàl à abà la asik səla nna, uwana amats ala ɗiki­ɗiki aw. (( ");
INSERT INTO mfh_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","La abatà madu­wari uwana azuw vok adàmətsay aw, ŋgaha akàl amats ala aw.)) ");
INSERT INTO mfh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Baŋa kà yewdi aŋak la uwana adala ka à tsakana à abà, ɓə̀ɗ à waŋ, ŋuləm kaɓəz à sifa la yewdi tekula gà à ka magay la yewdi səla kà madiya à gudùh akàl à abà. ");
INSERT INTO mfh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","La abatà madu­wari uwana azuw vok adàmətsay aw, ŋgaha akàl la abà kà madzaɗ atà ala adàmats ala aw. ");
INSERT INTO mfh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kà uwana dza gesina tadàtəka atà slugul à adi la akàl, bokuba uwana tatək slugul à tatak à adi kà matse­ɗəŋ.” ");
INSERT INTO mfh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Kà uwana slugul kà tatak delga, ama baŋa slugul azlaɗay aw, ma kakay kazla­ɗawwaŋ ala ma? Gàw la slugul la ləv aŋkul la tsəh, dzàw à ahəŋ la wurwur, kaɗa­hawa à magazlay la tataka aŋkul la abà aw!” ");
INSERT INTO mfh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu asà à afik la abatà, ahàd à gay makwi aŋa kutso Yahu­diya la gay dərəv uda anik aŋa Urdun. Bà gotənaŋ maham à ahəŋ dza tahamà gay à vok la slaka aŋha aya. Ŋgaha atàpatàla bokuba uwana aɗa­hà­hàŋ koksi­koksi. ");
INSERT INTO mfh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Azla Farisəya anik tasà à waŋ à slaka Yesu, asà à atà kà makəsal maləkaw à ahəŋ kà gay aŋha: “Wakità seriya gami ma avà tetəvi à dza kà makuɗək mis aŋha takay?” ");
INSERT INTO mfh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu awùlla à atà ala la magoɗay: “Mana Musa agoɗ à akul ma?” ");
INSERT INTO mfh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tagòɗal: “Musa avà tetəvi à dza kà matsetser wakità makuɗək mis, ŋgaha məsa­kiya à mis uwatà.” ");
INSERT INTO mfh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ama Yesu agòɗ à atà: “Musa apə̀h à akul kiya uwatà kà, kà dzaŋ­dzaŋ aŋa ləv aŋkul. ");
INSERT INTO mfh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ama dagay madzəka gudəŋ à vok, mok uwana Zəzagəla aɗahà tatak gesina kà, aŋàl zil la mis pəra. ");
INSERT INTO mfh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Gay gà la uwaga zil asàkìyà à baba aŋha à ahəŋ la iyà aŋha, kà madz à ahəŋ la mis aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Atà səla nna tapàk vok tekula. Kiya uwaga atà səla aya aw, ama tagay kà vok tekula pəra. ");
INSERT INTO mfh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dza avahàŋ ala uwana Zəzagəla ahamàla gay à vok aw.” ");
INSERT INTO mfh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mok uwana atà la kay, azlaməna matapla la slaka aŋha tanàvà Yesu lakəl aŋa gay uwatà aya. ");
INSERT INTO mfh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Masla agòɗ à atà: “Baŋa dza akuɗək mis aŋha, azəɓ anik, aɗàh à gəl gaw la mis teraŋa gà uwatà. ");
INSERT INTO mfh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","La kità babay kà, baŋa mis akweska zil aŋha teraŋa, ŋgaha adiya à zil anik, adàzaɓ zil.” ");
INSERT INTO mfh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Azladza tasàhla azlabəza ŋuv ŋguvga à Yesu à waŋ, kà madəɓani atà la mapis à atà gay à vok. Azlaməna matapla la slaka aŋha taslàh məl à azladza à gəl. ");
INSERT INTO mfh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Uwana Yesu anəŋà uwaga, azìnal à gəl, agòɗ à azlaməna matapla la slaka aŋha: “Sàkàw azlabəza ŋuv ŋuvga tasa à waŋ à slaka gulo. Kaɗəɗaw atà gay à ahəŋ aw, kà uwana makoray Zəzagəla kà aŋa azladza uwana bokuba atà uwaga. ");
INSERT INTO mfh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Haɗay, gəgoɗ à akul: Uwa­be­yuwi uwana akəs makoray Zəzagəla bokuba bəzi ŋuvga aw, adàda à abatà ɗiki­ɗiki aw.” ");
INSERT INTO mfh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ŋgaha azàɓ azlabəza à ahàl, afahà à atà ahàl aŋha à gəl, la tekula tekula aŋatà gesina, apìs à atà gay à vok. ");
INSERT INTO mfh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Uwana Yesu ada­tsizlla kà maday aŋha, dza anik asà à waŋ la mahoyay, akədèɗal à ahəŋ, agòɗal: “Kak Sufəl, kak delga, mana gəɗehəŋ kà gi aŋa maɓəz sifa adəv à gay aw ma?” ");
INSERT INTO mfh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu agòɗal: “Kà mana kagoɗ, kà gi delga ma? Dza delga la ahəŋ aw, say Zəzagəla pəra. ");
INSERT INTO mfh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kasəl mapəhay aŋa Zəzagəla bay: Kakəɗ dza aw, kə̀s gay aŋa azla­baba aŋak la aŋa iyà aŋak.” ");
INSERT INTO mfh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Masla agòɗ: “Məŋga, gədakəs mapəhay uwaga dagay la bəzi gà.” ");
INSERT INTO mfh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu anərə̀z masla la mawoyəŋ, agòɗal: “Tatak tekula aləg kà ka: Hàd, kadaw azla­tatak aŋak ala gesina, vàh sili gà à azlaməna kuɗa, kadàɓəz ləmana la zagəla la afik. Ŋgaha kà, sà à waŋ, kà nəfà à gi!” ");
INSERT INTO mfh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ama uwana atsənà uwaga, ləv azə̀ŋ kà gay uwatà, ŋgaha adà aŋha la mapak ləv gà, kà uwana tatak aŋha aŋuvaw. ");
INSERT INTO mfh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu anəŋà azlaməna matapla la slaka aŋha à adi, agòɗ à atà: “Zla­zlaɗa kà aŋa dza galepi kà mad à makoray Zəzagəla!” ");
INSERT INTO mfh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ləv avàl à atà à gay kà gay uwaga. Ama Yesu agòɗ à atà aya: “Azlabəza gulo, madiya à makoray Zəzagəla kà zla­zlaɗa! ");
INSERT INTO mfh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ŋuləm zlugumi agwu à uda la afik lepiri, kà galepi aŋa mad à makoray Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ləv avàl à azlaməna matapla aŋha à gay kaykay aya kà gay uwaga, tagòɗ kà atà kà atà: “Tsa baŋa kiya uwaga ma: Uwa aslala vok aŋa maɓəlay uwa?” ");
INSERT INTO mfh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu anəŋà à atà à adi, agòɗ: “Zla­zlaɗa la slaka azladza, ama la slaka Zəzagəla kà zla­zlaɗa aw, kà uwana masla aslala vok kà maɗàh tatak gesina.” ");
INSERT INTO mfh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Piyer agòɗal: “Nə̀ŋàŋ, mədasak à tatak gesina à ahəŋ, mədanəfa ka.” ");
INSERT INTO mfh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu agòɗal: “Dziriga, gi bay gəgoɗ à akul: Uwa­be­yuwi uwana asakiya gày aŋha à ahəŋ, baŋaw azla­deda aŋha, la azlaiyà aŋha, la azla­baba aŋha, baŋaw azlabəza aŋha à ahəŋ, amiyaka guf aŋha kà gi, ŋgaha kà gay matsi­ɗayga kà, ");
INSERT INTO mfh_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Zəzagəla adàvàl, adàɓəz tatak aŋha asik dzim aya, la mok aŋa madz à ahəŋ la gudəŋ la vok: azlagày, azla­deda, azlaiyà, azlabəza, azlaguf, azla­matərəɓay bay, kà la huma la gay, adàɓəzal sifa adəv à gay aw la zagəla la afik aya. ");
INSERT INTO mfh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ama aŋuvaw uwana tatsà vok à huma, tadà­pakah azlaməna à lig, ŋgaha azlaməna à lig bay tadà­pakah azlaməna à huma.” ");
INSERT INTO mfh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Uwana atà la tetəvi la ama kà mad à Uru­sa­lima, Yesu aguwà à huma, guba akə̀s azlaməna matapla la slaka aŋha, azladza uwana tanəfà atà guba akəs atà babay. Ŋgaha Yesu ahə̀l azlaməna matapla kulo gəl aŋha səla uwatà aya, kokuɗa aŋatà, adzəkà mapəh à atà gay uwana adàɓəzal. ");
INSERT INTO mfh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Agòɗ à atà: “Tsənàwwàŋ, məda à Uru­sa­lima. La abatà tadàvà Kona aŋa dza à ahàl aŋa azlaməŋga aŋa azlaməna mav tatak à Zəzagəla, la azla­ma­dza­haga aŋa wakità seriya aŋa Zəzagəla. Tadàdukwla seriya mamətsay à gəl, tadà­məliya à ahàl aŋa azladza uwana tasəl Zəzagəla aw. ");
INSERT INTO mfh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tadàtsəkal mago­ɗahay à gəl, tadà­tafal slesliɓ à vok, tadà­zlaɓay la golba, tadàkəɗay. Ama la mahənay mamakər adàwul à uda la mamətsay.” ");
INSERT INTO mfh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","La lig la ahəŋ Yakuba la Yuhana, azlabəza aŋa Zebede, tazà vok à slaka Yesu, tagòɗal: “Məŋga gami, tatak la ahəŋ à uwana mənava à gay ala.” ");
INSERT INTO mfh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu agòɗ à atà: “Mana asa à akul gəɗa­ha­kullaŋ ma?” ");
INSERT INTO mfh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tawulàlla: “Baŋa kadàdza madzay la kursi mazləɓay aŋak la afik kà, và à anu tetəvi kà madza madzay tekula la ahàl kaf aŋak ŋgaha tekula la ahàl gudzay aŋak!” ");
INSERT INTO mfh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu agòɗ à atà: “Kasəlaw tatak uwana kanavaw aw, kaslawwal à vok kà mas tatak à uda la kətsaw ŋgərpa uwana la abà gədàsay ay? Kadàɓəzaw batem aŋa ŋgərpa uwana tadàɗah gi à ahəŋ ay?” ");
INSERT INTO mfh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ŋgaha tawulàlla: “Iyay, məslala vok.” Yesu agòɗ à atà: “Haɗay, kadàsaw tatak à uda la kətsaw ŋgərpa uwana la abà bokuba gi, kadàɓəzaw batem uwana tadà­ɗahgəŋ bay. ");
INSERT INTO mfh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ama slaka madza madzay la ahàl kaf gulo ŋgaha la ahàl gudzay gulo kà, gay gulo aw. Slaka uwaga kà, Zəzagəla la uwana aɗahaŋ à ahəŋ kà aŋa azladza uwana atsa­tsà­mànì à atà.” ");
INSERT INTO mfh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Uwana azlaməna matapla anik kulo tatsə̀n gay uwaga kà, taŋoŋùz lakəl aŋa Yakuba atà la Yuhana. ");
INSERT INTO mfh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Gay gà la uwaga Yesu azàl à atà gesina à slaka aŋha, agòɗ à atà: “Kasəlaw kà azla­uwana tanəŋla à atà bokuba azla­su­fəl aŋa kutso kà takor azladza, ŋgaha azlaməŋ dza aŋatà, taɗaha à atà ndzəɗa à gəl. ");
INSERT INTO mfh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ama uwaga apaka vok la tataka aŋkul la abà aw. Ama baŋa tekula la tataka aŋkul la abà asal mapak məŋga kà, say agay masla mazəɓ kiwa à azlaanik. ");
INSERT INTO mfh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Dza uwana asal mapak dza teraŋa gà la tataka aŋkul la abà kà, say apak mayà aŋa azlaanik aŋkul gesina. ");
INSERT INTO mfh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Amiyaka Kona aŋa dza kà, asà à waŋ kà mazla­kəŋ aŋa azladza aw, ama asà à waŋ kà mazlak azladza, ŋgaha kà mav sifa aŋha bokuba tatak mapəlla gəl à azladza aŋuvaw à ahəŋ.” ");
INSERT INTO mfh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Uwana tabə̀z à gudəŋ Yeriko, Yesu la azlaməna matapla aŋha la maham à ahəŋ dza aŋuvaw tasà à uda la gudəŋ uwatà la abà. Dza guləfga la slaka madza madzay la gay tetəvi atsàtsàh tatak. Sləm aŋha Bartime, kona aŋa Time. ");
INSERT INTO mfh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Uwana atsənàŋ kà Yesu zil Nazaret la uwana adà à awtày kà, adzəkà mawiyay: “Yesu, Kona aŋa David, vok aham à kak kà gi!” ");
INSERT INTO mfh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Azladza aŋuvaw taslàhal məl à gəl kà madz à ahəŋ titi, ama masla awiyà la ndzəɗa aya: “Kona aŋa David, vok aham à kak kà gi!” ");
INSERT INTO mfh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu atsìzlla à ahəŋ, agòɗ: “Zàlàwwal!” Tazàlalla, tagòɗal: “Wàɗ vok à uda, sà à afik, azàla ka!” ");
INSERT INTO mfh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ŋgaha guləf awìts peteli ala, avàl à afik, asà à waŋ à slaka Yesu. ");
INSERT INTO mfh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu anàval la gay ala: “Mana asa à ka gəɗa­hakaŋ ma?” Guləf agòɗal: “Məŋga, asa à gi gəɓəz yewdi gulo.” ");
INSERT INTO mfh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ŋgaha Yesu agòɗal: “Hàd, madiŋal gəl à vok aŋak adawur kak ala!” Katskats aɓəzà à yewdi aŋha, anəfà Yesu. ");
INSERT INTO mfh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mok uwana atà nekwa la Uru­sa­lima, bokuba la bəza gudəŋ Betfaze la Be­ta­niya, tabəzà à gudəŋ kuvu à afik. (Uwana tazalalla la gay nasara gudəŋ Oliviye) Yesu aslə̀l azlaməna matapla aŋha səla à huma, agòɗ à atà: ");
INSERT INTO mfh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Dàw à gudəŋ uwaga à abà la huma aŋkul. Kadàɓəzaw à ziwŋŋu ŋuvga mawaɗəŋ à ahəŋ gà uwana dza adadza à afik ɗiki­ɗiki aw. Pə̀làw, kasawgəla à waŋ! ");
INSERT INTO mfh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Baŋa dza agòɗ à akul: ‘Mana kaɗa­hawlaŋ mi?’, kago­ɗawwal: ‘Asa à Sufəl gami, adà­ullàlla à waŋ katskats’.” ");
INSERT INTO mfh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tahàd, taɓəzà à ziwŋŋu mawaɗəŋ à ahəŋ gà à gəl la gay gamagày, la gay tetəvi. Uwana tapə̀l ziwŋŋu uwatà kà, ");
INSERT INTO mfh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","azladza anik uwana la abatà, tanàv à atà gay ala: “Mana kaɗa­hawllaŋ ma? Kà aŋa ma kapəlaw bəzi ziwŋŋu uwaga ma?” ");
INSERT INTO mfh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tawùl ala bokuba uwana Yesu apə̀h à atà, ŋgaha azladza tasàk atà. ");
INSERT INTO mfh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tasə̀lla bəzi ziwŋŋu uwatà à Yesu à waŋ, taɓə̀kal lukut aŋatà à lig, ŋgaha Yesu adà à afik. ");
INSERT INTO mfh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Azladza aŋuvaw tadàw lukut aŋatà à tetəvi à ama, azlaanik tatsàɗ baɓasl biyaga uwana la guf la abà, taslàh à tetəvi à ama kà masləkaway. ");
INSERT INTO mfh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Azla­uwana la huma aŋa Yesu, la azla­uwana tanəfay la tsəh, tawiyà la magoɗay: “Delga kà azladza tazləɓ Zəzagəla, mapis gay à vok agay la dza uwana atsà à waŋ la sləm aŋa Sufəl. ");
INSERT INTO mfh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Zəzagəla apis gay à makoray aŋa baba gami David à vok, uwana adadzəka vok lagwa. Məzləɓà Zəzagəla uwana la zagəla la afik kərkər!” ");
INSERT INTO mfh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kiya uwaga Yesu ahàd à gudəŋ Uru­sa­lima, kà mad à gày Zəzagəla à agu, anaŋà azla­tatak gesina lela. Uwana gay mokokhu adagay, ahàd à gudəŋ Be­ta­niya la azlaməna matapla aŋha kulo gəl aŋha səla uwatà. ");
INSERT INTO mfh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Lebəŋ gà, uwana tasà à uda la gudəŋ Be­ta­niya, may akə̀s Yesu. ");
INSERT INTO mfh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Anəŋà gudəv la baɓasl la vok, ŋgaha ahàd kà mayàh mayyay la vok aŋha. Ama uwana ada­bəziya à tsəh aŋha kà, aɓəzà mayyay la vok aŋha aw, say baɓasl pəra, kà uwana kaslà aŋa gudəv dadàŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu agòɗ à gudəv: “Dza adàzuw mayyay la vok aŋak aŋa tetuwa aya aw!” Azlaməna matapla la slaka aŋha tatsənà gay uwaga. ");
INSERT INTO mfh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Uwana tabə̀z à Uru­sa­lima, Yesu ahàd à məŋ gày Zəzagəla à agu. Adzəkà makuɗəkàh azlaməna tsa­kalay à uda, la azlaməna masukw tatak la gày Zəzagəla la aku. Adakwà azla­table aŋa azlaməna maɓaɗla sili à ahəŋ la azla­slaka madza madzay aŋa azlaməna madaw haba­koku ala. ");
INSERT INTO mfh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Asà kà dza baməraka tekula aŋa mad à gày Zəzagəla à agu la tatak lakəl aw. ");
INSERT INTO mfh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Atapla tatak à azladza, agòɗ: “Aganay uwana tatsetsèr à wakità à abà, Zəzagəla agòɗ: ˈSləm aŋa gày gulo kà uwaga gày madəv kuɗa aŋa azladza gudəŋ à vok gesina. Ama akul kà, kada­pa­kawwaŋ ala kà bokuba tsakur aŋa azlaməna gəl.ˈ” ");
INSERT INTO mfh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Azlaməŋga aŋa azlaməna mav tatak à Zəzagəla, la azla­ma­dza­haga aŋa wakità seriya aŋa Zəzagəla tatsənà gay uwatà. Gay gà la uwaga tayàh Yesu kà maziŋ ala. Ama guba akə̀s atà kà masla, kà uwana ləv avàl à azladza à gay gesina kà gay aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Uwana mokokhu adasa à waŋ, Yesu la azlaməna matapla la slaka aŋha, tasà à uda la gudəŋ la abà. ");
INSERT INTO mfh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","La gay bebəŋ bəŋ uwana tadùw à awtày la abatà, tanəŋà gudəv uwatà aya, adagul à afik la slilih gà gesina. ");
INSERT INTO mfh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Awùl à Piyer à gəl, agòɗ à Yesu: “Məŋga gulo, nəŋà gudəv uwana katsàfla, kà adagul à afik tsi!” ");
INSERT INTO mfh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu awùlla à atà ala: “Haɗay, gəgoɗ à akul, baŋa kadiŋaw gəl à Zəzagəla à vok kà, ");
INSERT INTO mfh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","kaslawwal à vok aŋa magoɗay à gudəŋ uwanay: Zà vok la abanay, tsà gəl à dərəv à abà. Baŋa kadzurkaw la ləv aŋkul la tsəh aw, kadi­ŋawwal gəl à vok la ləv aŋkul la tsəh kà, uwaga adàpakakulla vok haɗay. ");
INSERT INTO mfh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Gay gà la uwaga gəgoɗ à akul, baŋa kadəvaw kuɗa kà manav tatak anik la sləm gulo kà, dìŋàwwal gəl à vok kà kada­ɓəzawwal, ŋgaha tadàvàkulla. ");
INSERT INTO mfh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mok uwana katsì­zlàwla kà madəv kuɗa kà, baŋa gay la ahəŋ la ləv aŋkul la tsəh la dza anik kà, matsalaŋ mawi­siga aŋha ala ŋgaha Baba aŋkul, uwana la zagəla la afik ama­tsa­kulaŋ ala bay. (( ");
INSERT INTO mfh_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ama baŋa kama­tsawwaŋ azladza anik ala aw kà, Baba aŋkul uwana la zagəla la afik adà­ma­tsa­kulaŋ ala bay aw.))” ");
INSERT INTO mfh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tawùl à Uru­sa­lima aya. Mok uwana Yesu augu­zahay la gày Zəzagəla la aku kà, azlaməŋga aŋa azlaməna mav tatak à Zəzagəla, la azla­ma­dza­haga aŋa wakità seriya aŋa Zəzagəla, la azla­ma­siga tasà à waŋ à slaka Yesu. ");
INSERT INTO mfh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tanàv à Yesu la gay ala: “La maslay ma uwala kaɗàh sləray uwanay la? Uwa avà à ka tetəvi kà maɗàh sləray uwanay uwa?” ");
INSERT INTO mfh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu awùlla à atà ala: “Gi bay, gənav à akul manavay tekula. Baŋa kawulawgəla, gi bay gədàpəhakulla maslay uwana gəɗàhla sləray. ");
INSERT INTO mfh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Uwa avà tetəvi à Yuhana kà maɗàh batem uwa? Zəzagəla ay? Awma azladza takay? Wùlàwgəla!” ");
INSERT INTO mfh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ama takə̀s sawaray kà atà kà atà, tagòɗ: “Baŋa məgoɗ kà: Zəzagəla la uwana avàl tetəvi kà, adàgoɗ à anu: Ka mana kadi­ŋawwal gəl à vok aw zlà ma? ");
INSERT INTO mfh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ama baŋa məgoɗ kà, azladza tavàl tetəvi tsa kità aw kà...” (Guba akəs atà kà azladza, kà uwana azladza gesina tanəŋà Yuhana kà masla kà dza uwana Zəzagəla aslə̀l à waŋ la dziriga) ");
INSERT INTO mfh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kà uwaga tagòɗ à Yesu: “Məsəl aw.” Yesu agòɗ à atà: “Ayyà, gi bay, gəpəhakulla dza uwana avà à gi tetəvi aŋa maɗàh tatak uwanay suwaŋ aw.” ");
INSERT INTO mfh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu apə̀h à atà gay la gay la abà, agòɗ: “Dza anik atsə̀ɓ matavəruk à guf aŋha à abà, akə̀sal zlagam à adi; aɗahà slaka à ahəŋ kà maku­ɗits iyaw mayyay matavəruk uwatà à abà, aŋàl gày kà aŋa masla manəŋla guf. Asàkla à azla­ma­gamza aŋha la ahàl, adà aŋha à mau­gu­zahay anik kərkər. ");
INSERT INTO mfh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Uwana təla mahənay tatak adasa à waŋ, aslə̀l kohana aŋha à slaka azla­ma­gamza uwatà kà, mavàl humà tatak aŋa guf aŋha suwaŋ. ");
INSERT INTO mfh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ama atà takə̀s magamza uwatà, tazlàɓ, takuɗə̀k la ahàl deyday. ");
INSERT INTO mfh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Dza aŋa guf aslə̀l kohana anik à slaka aŋatà aya. Azla­ma­gamza tatsàh à gəl, ŋgaha tatsə̀kal mago­ɗahay à gəl. ");
INSERT INTO mfh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Dza aŋa guf aslə̀l magamza anik aya. Masla kà takə̀ɗ. Taɗa­hàhàŋ azla­ma­gamza anik à vok aŋuvaw kalkal kiya uwaga, tazlàɓàh azlaanik, ŋgaha azlaanik bay takàɗ atà. ");
INSERT INTO mfh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Atə̀m kà dza aŋa guf à ahəŋ kà dza tekula pəra, bəzi gay ləv aŋha uwana awoyàŋ məŋga. La madəvla à gay, aslə̀l à slaka aŋatà, adzùgw kà: ‘Tadà­zləɓ kona gulo haɗay aw ay’, agòɗ. ");
INSERT INTO mfh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ama atà tagòɗ kà atà kà atà: ‘Aganay dza uwana adàzuw gày. Sàw à waŋ, məkəɗ ŋgaha guf adàgəɗ à anu!’ ");
INSERT INTO mfh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Takàs masla, takə̀ɗ masla, tamə̀l à uda la guf la abà.” ");
INSERT INTO mfh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu agòɗ: “Iyay zla, mana dza aŋa guf adà­ɗe­həŋ ma? Adàsa à waŋ, adàkaɗ azla­ma­gamza makəsafərga uwatà, adàvà guf uwatà à azlaanik. ");
INSERT INTO mfh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Haɗay, kadzèŋàw gay uwanay la wakità Zəzagəla la abà: ˈAkur uwana azlaməna maŋal gày tamə̀lla kà, masla la uwana adapak akur mawaɗ gày. ");
INSERT INTO mfh_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Aganay uwana Sufəl Zəzagəla aɗahàŋ uwaga kà nadzipo la huma yewdi gamiˈ!” ");
INSERT INTO mfh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Azla­ma­dza­haga aŋa azla Yahu­diya tayàh kà makəs Yesu, kà uwana atà tasə̀l, kà Yesu apə̀h gay la gay la abà uwaga kà lakəl aŋatà. Ama guba akə̀s atà, kà maham à ahəŋ dza, kà uwaga à uwana tasàkal, tadà aŋatà. ");
INSERT INTO mfh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ama katskats azlaməna mav tatak à Zəzagəla, la azla­ma­dza­haga aŋa wakità seriya aŋa Zəzagəla, la azla­ma­siga taslə̀l azla Farisəya anik, la azlaanik la tataka aŋa maham à ahəŋ matsən vok gay la sufəl Herod kà magəɗ uwana à afik, azlayla kà vok kà makəsla. ");
INSERT INTO mfh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tasà à waŋ, tagòɗ à Yesu: “Məŋga, məsəl kà kapəhay kà say dziriga pəra, la madz à ahəŋ bokuba uwana asà à Zəzagəla, pə̀h à anu wakità seriya gami, ma avà à anu tetəvi aŋa mapəl hadama à məŋ sufəl Zəsar takay? Awma məpəlal aw takay?” ");
INSERT INTO mfh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ama Yesu asə̀l kà madzugway aŋatà kà mawi­siga, agòɗ à atà: “Kà mana kava­varaw gi kiya uwaga ma? Sàwgəla sili uwaga à waŋ gənəŋəŋ.” ");
INSERT INTO mfh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tasàlla sili à waŋ. Agòɗ à atà: “Gəl la sləm uwanay la sili la afik ma aŋa uwa?” Tagòɗal: “Aŋa Zəsar.” ");
INSERT INTO mfh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu awùlla à atà ala: “Delga, vàw à məŋ sufəl Zəsar tatak uwana aŋha, vàw à Zəzagəla bay tatak uwana aŋa Zəzagəla.” Ləv avàl à atà à gay kà gay aŋha, məslək la ahəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Azlaanik la tataka aŋa azla Sadu­kiya la abà, tasà à waŋ à slaka Yesu. (Atà kà, mawul à uda la mamətsay la ahəŋ aw, tagòɗ) ");
INSERT INTO mfh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Tagòɗ à Yesu: “Məŋga, Musa atsetsèr à anu mapəhay uwanay: ˈBaŋa dza anik amətsay, asàkìyà à mis aŋha à ahəŋ kokuɗa bəzi, say deda aŋha azəɓ mis à uda la gay kuɗa la abà. Ŋgaha aɓəziya azlabəza la mis uwatà kà à huma aŋa deda aŋha uwana amə̀ts.ˈ ");
INSERT INTO mfh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Azla­deda zilga məɗəf la ahəŋ. Magolga aŋatà azə̀ɓ mis, ŋgaha amə̀ts kokuɗa mayyay bəzi. ");
INSERT INTO mfh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Masəla azə̀ɓ à uda la gày kuɗa la abà, amə̀tsàlàŋ ala kokuɗa mayyi bəzi aya. Kiya uwaga apakà vok la mamakər aŋatà bay. ");
INSERT INTO mfh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kiya uwaga atà məɗəf nna mis atsetsèr à atà à gay, tamàts kokuɗa mayyi bəzi la masla. La lig la ahəŋ, mis amə̀ts suwaŋ. ");
INSERT INTO mfh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ŋgaha tak ma, la mok uwana azladza tadàwul à uda la mamətsay ma, mis ma adàgay ma aŋa uwa tak uwa? Kà uwana agà mis aŋatà məɗəf nna!” ");
INSERT INTO mfh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu awùlla à atà ala: “Kazawla haɗay zla! Kasəlaw wakità Zəzagəla aw, kasəlaw maslay aŋha babay aw. ");
INSERT INTO mfh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kà uwana la vuɗ uwana azla­ma­zim­nekiɗ tadàwul à uda la mamətsay kà, azlamis la azlazil tadàzaɓ vok aya aw, ama tadà­pa­kahay kà bokuba azla­ma­lika, uwana la zagəla la afik pəra. ");
INSERT INTO mfh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Lakəl aŋa azla­ma­zim­nekiɗ, uwana tawul à uda la mamətsay kà, kadzèŋàw ɗiki­ɗiki la wakità la abà aw uwà? Paŋaw ma uwala aɓaɗ­lamà à Musa la alàl aŋa akàl la abà, la gay kuswe­kuswe la abà ala? Agòɗal: ˈGi Zəzagəla aŋa Abəraham, gi Zəzagəla aŋa Isak, ŋgaha gi Zəzagəla aŋa Yakuba bay.ˈ ");
INSERT INTO mfh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Uwaga bokuba magoɗay kà Masla kà Zəzagəla aŋa azla­ma­zim­nekiɗ aw, ama aŋa azla­uwana la sifa. Gay gà la uwaga kaza­hawla la dziriga.” ");
INSERT INTO mfh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","La kaslà uwatà madza­haga aŋa wakità seriya aŋa Zəzagəla la ahəŋ la abatà, atsəɓà à atà sləm kà tabày vok à gay. Atsənàŋ kà Yesu awùlla à azla Sadu­kiya kà lela. Azà vok à awtày, anàval à gay ala: “Mapəhay ma uwala à uwana aɗuwa vok ala?” ");
INSERT INTO mfh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu awulàlla: “Aganay uwana aɗuwa azlaanik gesina: ˈTsənàwwàŋ akul azladza Isərayel! Sufəl Zəzagəla gami kà, masla Sufəl kokuɗa gəl aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Wòyà Sufəl Zəzagəla aŋak la ləv aŋak gesina, la sifa aŋak gesina, la haŋkəli aŋak gesina, ŋgaha la ndzəɗa aŋak gesina.ˈ ");
INSERT INTO mfh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aganay mapəhay masəla: ˈWòyà masla magay aŋak bokuba gəl aŋak!ˈ Mapəhay uwanay la uwana aɗuwa azlaanik gesina.” ");
INSERT INTO mfh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Məŋ dza uwatà agòɗal: “Delga Sufəl, kapə̀h dziriga, Zəzagəla tekula, anik la ahəŋ aw, say azladza takəs gay aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Say dza awoy Zəzagəla la ləv aŋha, la haŋkəli aŋha, la ndzəɗa aŋha gesina, ŋgaha bay awoy masla magay aŋha babay bokuba gəl aŋha. Manəf mapəhay səla uwaga la uwana aɗuwa tatak gesina uwana mədawal à akàl à tsəh kà aŋa Zəzagəla, la uwana məvàl gesina.” ");
INSERT INTO mfh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu anəŋàŋ kà madza­haga aŋa wakità seriya uwatà awùlla à uda la haŋkəli, ŋgaha agòɗal: “Kak kà, kərkər la makoray Zəzagəla aw.” La lig la ahəŋ guba akə̀s atà gesina kà manaval gay anik. ");
INSERT INTO mfh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mok uwana Yesu atàpatàla la gày Zəzagəla la aku, anàvà à atà gay uwanay: “Kakay azla­ma­dza­haga aŋa wakità seriya tagoɗay kà: Dza uwana tafàl dzakwa à gəl, kà mayyi à tsəh ala aŋa David ma? ");
INSERT INTO mfh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kà uwana Masasəɗok Zəzagəla la uwana aguwà la David la abà, à uwana apə̀h la gəl aŋha: ˈSufəl agòɗ à Sufəl gulo: ‘Dzà madzay la ahàl kaf gulo lakəl, ŋgaha gədàɓək azlaməna məzam aŋak à tsəh asik aŋak.’ˈ ");
INSERT INTO mfh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David la gəl aŋha azàlal Sufəl, ŋgaha ma kakay Kristu kà agay mayyi à tsəh ala aŋa David ma?” Maham à ahəŋ dza aŋuvaw tatsənà gay aŋa Yesu la marabay. ");
INSERT INTO mfh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Agòɗ à atà la matapla aŋha la abà: “Ɗahàw haŋkəli kà azla­ma­dza­haga aŋa wakità seriya! Asa à atà mau­gu­zahay la dawa­rawa məŋga la vok, asa à atà kà azladza tasokw à atà la slaka maham gay à vok. ");
INSERT INTO mfh_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tayahay kà slaka madza madzay delga la gày mazuw tatak may la aku. ");
INSERT INTO mfh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tazàɓ tatak à azlamis kuɗa ala, ŋgaha la madəv kuɗa ziŋziŋga kà azladza aŋa magoɗay kà atà azladza dziriga. Atà tadàɓəzal seriya dzaŋ­d­zaŋga.” ");
INSERT INTO mfh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu adzà madzay nekwa la sahar sili, la gày Zəzagəla la aku, ŋgaha anəŋà uwana azladza taɓàk sili à sahar à agu. Azla­ga­lepi anik aŋuvaw tavàh məŋga. ");
INSERT INTO mfh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mis kuɗa gà asà à waŋ, awìts nini səla à agu. ");
INSERT INTO mfh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu azàl azlaməna matapla la slaka aŋha, agòɗ à atà: “Gəgoɗ à akul: mis kuɗa uwanay kà, avà sili uwana aɗuwa à azladza anik gesina, ");
INSERT INTO mfh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","kà uwana atà kà, tavà sili aŋa ləmana aŋatà məŋga, ama mis kuɗa uwanay avà gesina, anik aŋha la ahəŋ kà mazuway aw.” ");
INSERT INTO mfh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Uwana Yesu adasa à uda la gày Zəzagəla la aku, tekula la tataka aŋa azlaməna matapla la slaka aŋha agòɗal: “Məŋga gulo, nərə̀z azlaakur aŋa gày uwanay tsi, atà dzəɓa aŋha səla aw!” ");
INSERT INTO mfh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu awulàlla: “Kanəŋa gày məŋga uwanay ay? Amiyaka akur tekula kà, adàgəɗal à gay aw. Azlaməna məzam tadà­bazlah à ahəŋ gesina.” ");
INSERT INTO mfh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu ahàd à gudəŋ à afik, adzà madzay la gudəŋ kuvu la afik, la huma magol gày Zəzagəla. Azla Piyer, Yakuba, Yuhana la Andəre uwana kokuɗa gəl aŋatà, tanàval: ");
INSERT INTO mfh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Pə̀hanula, mbà tatak uwanay adàpaka vok ma? La mana mədà­nəŋəŋ madəv à gay aŋa tatak uwaga adàsa à waŋ ma?” ");
INSERT INTO mfh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","La abatà Yesu adzəkà mapàhla ala la magoɗay: “Ɗahàw haŋkəli, dza avavar akul aw! ");
INSERT INTO mfh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kà uwana azladza aŋuvaw tadàsa à waŋ la sləm gulo, tadà­goɗay: ‘Gi la uwana, gi dza uwana Zəzagəla afàl dzakwa à gəl.’ Tadàzah azladza ala aŋuvaw. ");
INSERT INTO mfh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Baŋa kadàtsənaw gay guvəl la slaka nekwa gà, ŋgaha uwana la slaka kərkər gà kà, guba akəs akul aw. Say uwaga adapaka vok leri, ama uwaga kà makəɗ gəl aŋha dadàŋ aw. ");
INSERT INTO mfh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kà uwana azladza kutso anik tadàp guvəl la azladza kutso anik, makoray aŋa sufəl anik tadàp guvəl la makoray aŋa sufəl anik. Kutso adà­ɓəlaka vok la slaka anik anik, ŋgaha may məŋga adàsa à waŋ. Uwaga madzəka vok aŋa ŋgərpa bokuba mazay aŋa huɗ bəzi pəra.” ");
INSERT INTO mfh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ama akul kà, ɗahàw haŋkəli kà gəl aŋkul, kà uwana tadà­kasah akul, ŋgaha tadàɗahla akul à huma seriya. Tadà­zlaɓah akul la gày madəv kuɗa la aku. Tadà­tsazlah akul à huma azlaməŋga, la azla­su­fəl kà gay gulo, ŋgaha kadà­pahaw gay gulo la huma aŋatà. ");
INSERT INTO mfh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Say dza gesina la gudəŋ la vok tadà­tsən gay Zəzagəla dadàŋ. ");
INSERT INTO mfh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Baŋa takas akul, tadala akul à huma seriya, guba adàkas akul dadàŋ, kà gay uwana kadàpəhaw à atà à adi aw. Ama baŋa kaslà adàsa à waŋ, gay uwana kadàpəhaw kà kadà­ɓəzawwal la ləv aŋkul la tsəh, kà uwana gay uwanay kà, gay aŋa gəl aŋkul aw, ama Masasəɗok Zəzagəla adàvà à akul! ");
INSERT INTO mfh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Azladza tadàvah azla­deda aŋatà la ahàl aŋatà kà makaɗ atà. Baba bay adàva bəzi aŋha kà aŋa makəɗay, azlabəza bay tadà­gohla afaɗ à azla­baba aŋatà à gəl, ŋgaha tadàkaɗ atà. ");
INSERT INTO mfh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Azladza gesina tadà­pəsewah akul lakəl aŋa gay gulo. Ama dza uwana adà­basiŋ tsəràh à awtày la tetəvi Zəzagəla la ama kà, masla kà adàɓəlay.” ");
INSERT INTO mfh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesu agòɗ bay: “Kadànəŋaw dza uwana tazala: Məzam aŋa Zəzagəla adàdza madzay la slaka uwana azlayla aw, (Dza uwana adzeŋ uwaga kà atsənəŋ lela!), azla­uwana la Yahu­diya tadàhoy à gudəŋ à afik. ");
INSERT INTO mfh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Dza uwana la gəl gày, adàsa à vəɗah, ama adàda à gày kà mahəl tatak aŋha aya aw. ");
INSERT INTO mfh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Dza uwana la guf la abà, adàwul à mtəga kà mahəl lukut aŋha bay aw. ");
INSERT INTO mfh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ŋgərpa kà aŋa azlamis uwana la bəza la huɗ, ŋgaha azlamis uwana bəza vərna aga à atà la ahàl, la mavakay uwatà. ");
INSERT INTO mfh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Də̀vàw kuɗa à Zəzagəla kà tatak uwaga aŋa mapak vok la təla anasl aw. ");
INSERT INTO mfh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","La kaslà uwatà kà, ŋgərpa məŋga adàgay la ahəŋ, uwana adapak vok dagay uwana Zəzagəla aɗahà gudəŋ à vok tsəràh à lakana aw, adàpaka vok bokuba uwaga aya ɗiki­ɗiki aw. ");
INSERT INTO mfh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ama Zəzagəla adag azla­ma­vakay uwatà desl kà azladza aŋha uwana ada­tsa­tsa­mani à atà. Baŋa kiya uwaga aw, kà dza adàɓəlay ɗiki­ɗiki aw.” ");
INSERT INTO mfh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Kiya uwaga, baŋa dza anik agoɗ à akul: ‘Aganay dza uwana Zəzagəla afàl dzakwa à gəl la abanay, à agatày, la abatày’, kadi­ŋawwal gəl à vok aw! ");
INSERT INTO mfh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kà uwana azlaməna mapəh à atà gay à ahàl fidaga tadà­saha à waŋ, tadà­pahla azla­na­dzipo anik anik ala, kà maz azladza uwana ala Zəzagəla ada­tsa­tsamni atà, à baŋa taslala vok. ");
INSERT INTO mfh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Akul zlà kà, ɗahàw haŋkəli! Gədapəh à akul tatak uwaga à vok à abà dagay uwarà.” ");
INSERT INTO mfh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“La mavakay uwatà, la lig aŋa ŋgərpa la ahəŋ, afats adàtəf à zagəla, təla adàuɗay aya aw. ");
INSERT INTO mfh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Azla­tse­tsiliŋ tadàsokw à ahəŋ la zagəla, azla­maslay uwana la zagəla la afik tadàɓəlaka vok. ");
INSERT INTO mfh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ŋgaha azladza gesina tadànəŋ Kona aŋa dza atsa à ahəŋ la habaga la abà, la ndzəɗa ŋgaha la mazləɓay məŋga. ");
INSERT INTO mfh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Adàsləl azla­ma­lika aŋha à slaka gesina, kà maham à gay azladza uwana à vok Zəzagəla atsa­tsà­mànì atà, dagay la gay tər gudəŋ à vok ufaɗ.” ");
INSERT INTO mfh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Tapawla gay la gay la abà aŋa gudəv: Baŋa azləl ahàl mawga baɓasl aɗay, kasəlaw kà təla madara kà nekwa. ");
INSERT INTO mfh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kiya uwaga babay, baŋa kanəŋaw tatak uwaga apakà vok gesina, sə̀làw kà, Kona aŋa dza kà nekwa la gay gamagày kà mas à waŋ. ");
INSERT INTO mfh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Haɗay, gəgoɗ à akul: Azladza aŋa zamana uwanay tadàdəv à gay dadàŋ aw, say baŋa tatak uwanay adàpaka vok gesina dadàŋ. ");
INSERT INTO mfh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Zagəla la kutso tadàdəv à gay, ama gay gulo kà, adàdəv à gay ɗiki­ɗiki aw.” ");
INSERT INTO mfh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ama dza asəl mavakay uwatà, baŋaw kaslà uwatà aw, azla­ma­lika uwana la zagəla la afik tasəl aw, Kona aŋa dza bay asəl aw, say Baba kokuɗa gəl aŋha pəra. ");
INSERT INTO mfh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ɗahàw haŋkəli, kadzewhal aw, kà uwana kasəlaw mok uwana tatak uwaga adàpaka vok aw. ");
INSERT INTO mfh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Adà­pakay kà bokuba dza uwana ad à mau­gu­zahay, asàkìyà à gày aŋha à ahəŋ, aviyà à ahàl aŋa azla­ma­gamza aŋha, avàhà à atà sləray ala, ŋgaha agòɗ à masla manəŋla gamagày: ‘Say kanəŋla lela, kadzehal aw!’ ");
INSERT INTO mfh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kà uwaga dzàw à ahəŋ la adi, kà uwana kasəlaw mok uwana zil gày adàwul à waŋ aw, bi la mokokhu, bi la tataka vəɗ, bi la mawiyay gotsak, bi məl palaha. ");
INSERT INTO mfh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Baŋa atsa à waŋ katskats, aɓəza akul à gəl la madzehal la abà aw. ");
INSERT INTO mfh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tatak uwana gəgoɗ à akul, gəgoɗ à azladza gesina babay: Dzàw à ahəŋ la adi!” ");
INSERT INTO mfh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A lig mavakay səla kà aŋa madzəka madəvaday Paska uwana azladza tazuw Pain kokuɗa tatak makəsliŋ, azlaməŋga aŋa azlaməna mav tatak à Zəzagəla, la azla­ma­dza­haga aŋa wakità seriya aŋa Zəzagəla tayàh tetəvi la vuɗ uwatà, kà makəs Yesu la ɗemɗem, ŋgaha aŋa makəɗay. ");
INSERT INTO mfh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tagoɗ: “Mədàkəs la vuɗ madəvaday aw, kà azladza aŋa madzəka magazlay aw.” ");
INSERT INTO mfh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Uwana Yesu la gudəŋ Be­ta­niya, la kay aŋa Səmon, masla akàl zagəla, mok uwana adadza madzay kà mazuw tatak may kà, mis anik asà à waŋ la amàl matərsin la ahàl la koloba gà, sləm aŋa amàl uwatà kà nar. Tsa­kalay aŋha kà zla­zlaɗa. Mis uwatà apə̀zl koloba, adzadzàɓ matərsin uwatà à Yesu à gəl. ");
INSERT INTO mfh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Azladza anik uwana la abatà kà, azìŋ atà à gəl, tagòɗ: “Kà mana awis amàl matərsin aŋha ala deyday ma? ");
INSERT INTO mfh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Agayŋa aduw matərsin gà ala aŋa sili dadərmokw makər, ŋgaha avàh sili gà azlaməna kuɗa la uwana aɗuwa à vok.” Kiya uwaga taŋoŋùz à tsəh ala lakəl aŋha. ");
INSERT INTO mfh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ama Yesu agòɗ à atà: “Sàkàwwal! Kà mana kavərawla gay ma? Aɗàh à gi sləray delga gà. ");
INSERT INTO mfh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Azlaməna kuɗa kà, atà la slaka aŋkul koksi­koksi, kaslawwalla vok aŋa maɗaha à atà delga koksi­koksi bokuba uwana asa à akul. Ama gi gədàdza à ahəŋ la akul koksi­koksi aw. ");
INSERT INTO mfh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mis uwanay aɗahà uwana aslàla vok. Masla aɗàh gi amàl matərsin à vok kà, kà maɗàh gi à ahəŋ aŋa maf gi à zəvay à agu. ");
INSERT INTO mfh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Haɗay, gəgoɗ à akul: La gudəŋ la vok gesina, uwana tadàpah gay marabəŋ, tadàpəhay bay tatak uwana mis uwanay aɗahàŋ, ŋgaha mis uwanay adàwul à atà à gəl.” ");
INSERT INTO mfh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","La lig la ahəŋ, Yudas Iska­riyot, tekula la tataka aŋa azlaməna matapla kulo gəl aŋha səla la abà, ahàd à slaka azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla kà mat kaf à Yesu à gəl. ");
INSERT INTO mfh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Uwana tatsənà uwaga kà, taràb, tagòɗal: “Mədàvà à ka sili.” Dagay kaslà uwatà, Yudas ayàh tetəvi kà mapəhla Yesu ala. ");
INSERT INTO mfh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","La mavakay teraŋa aŋa madəvaday Pain kokuɗa tatak makəsliŋ, vuɗ makaɗ magadzaw aŋa Paska, azlaməna matapla aŋha tanàval à gay la: “Lala asa à ka kà məday kà maɗàh à ka tatak may aŋa madəvaday Paska à ahəŋ la?” ");
INSERT INTO mfh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesu aslə̀l azladza səla la tataka aŋatà la abà, agòɗ à atà: “Dàw à gudəŋ à abà, dza la ahəŋ la tuguzl lakəl, la iyaw gà, kadà­ga­gamaw akul nna. ");
INSERT INTO mfh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nə̀fàw à gày uwana à abà adàda à agu, gòɗàw à zil gày uwatà kà: Məŋga gami agoɗ à ka: ‘Lala à gày gulo, uwana gədàzuw tatak may aŋa Paska la aku la azlaməna matapla gulo li? agoɗ’, gòɗàwwal. ");
INSERT INTO mfh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Masla adàpəhakulla gày məŋga uwana la afik gà, slaka maɗehəŋ à ahəŋ gà gesina. La abatà la uwana kadà­ɗahaw vok à ahəŋ gesina kà aŋami.” ");
INSERT INTO mfh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Azlaməna matapla la slaka aŋha tahàd, tahàd à huɗ gudəŋ à abà, taɓəzà tatak à gəl bokuba uwana Yesu apə̀hatàla. Uwana taɗàh tatak may Paska à ahəŋ kà, tawùl à slaka Yesu. ");
INSERT INTO mfh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Uwana mokokhu adasa à waŋ kà, Yesu abə̀z à abatà la azlaməna matapla aŋha kulo gəl aŋha səla. ");
INSERT INTO mfh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mok uwana tadzà madzay, tazùw tatak may, Yesu agòɗ à atà: “Haɗay, gəgoɗ à akul, tekula la tataka aŋkul la abà uwana məzuw tatak may səla adàta à gi kaf à gəl.” ");
INSERT INTO mfh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Azlaməna matapla la slaka aŋha tadzəkà mazawla à gəl, tagoɗal la tekula tekula aŋatà: “Gi zlàk uwà? Gi zlàk uwà?” ");
INSERT INTO mfh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu agòɗ à atà: “Dza tekula la tataka aŋkul la abà, uwana mədəɓ alàl à kaf à gəl anu səla, la uwana adàta à gi kaf à gəl. ");
INSERT INTO mfh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ndzer gi, gi Kona aŋa dza gədàmətsay bokuba uwana tatsetsèr à wakità à abà lakəl gulo. Ama ŋgərpa adàgay la dza uwana adàtəg kaf à gəl aŋa Kona aŋa dza agay, tayyì dza uwaga aw kà ŋuləm kà masla.” ");
INSERT INTO mfh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","La mok uwana tazùw tatak may, Yesu azə̀ɓ kaf, atsàkàŋ ala, ‘Kikay’ agòɗ à Zəzagəla, ŋgaha avà à azlaməna matapla la slaka aŋha, agòɗ à atà: “Zùwàw uwaga kà vok gulo!” ");
INSERT INTO mfh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ŋgaha azə̀ɓ kətsaw la iyaw mayyay ahàf gà, ‘Kikay’, agòɗ à Zəzagəla, avà à atà, atà gesina tasà à uda la abà, ");
INSERT INTO mfh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ŋgaha agòɗ à atà: “Uwaga kà aŋiz gulo, aŋiz makəs vok slawda la Zəzagəla, uwana asokw à vəɗah kà aŋa azladza aŋuvaw. ");
INSERT INTO mfh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Haɗay, gəgòɗ à akul, gədàsa iyaw mayyay ahàf uwanay aya aw, tsəràh à uwana mədàsay anina aya la makoray Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tazləɓà Zəzagəla la mahabay, ŋgaha tasà à uda, tadà aŋatà à gudəŋ kuvu à afik. ");
INSERT INTO mfh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu agòɗ à azlaməna matapla la slaka aŋha: “Akul gesina kadà­sakaw gi à ahəŋ, kadàhoy à waŋ akul, kà uwana uwaga kà matse­tse­rayga la wakità Zəzagəla la abà: ˈGədà­kəɗ masla manəŋla azla­tuwaŋ, azla­tuwaŋ tadàvah gəl à ahəŋ.ˈ ");
INSERT INTO mfh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ama la lig la ahəŋ, gədàwul à uda la mamətsay, gədà­tsəvokay kà akul kà mad à Galili.” ");
INSERT INTO mfh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piyer agòɗal: “Amiyaka azladza gesina tasak à kak à ahəŋ kà, gi kà, gədàsak à kak à ahəŋ aw.” ");
INSERT INTO mfh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ŋgaha Yesu awùllal ala: “Haɗay, gəpəh à ka, la vuɗ uwanay lakana, gurayŋa mew­g­dza­galaŋ awiyay asik səla kà, kà kak Piyer kadà­goɗay kà, kà kasəl gi aw, asik makər.” ");
INSERT INTO mfh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ama Piyer agòɗ la ndzəɗa aya: “Gədàpəh tsəhay gay uwaga aw, gəmətsay ndzer la kak!” Atà gesina tagòɗ kiya uwaga babay. ");
INSERT INTO mfh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tabə̀z à slaka anik uwana sləm aŋha Ge­tse­mane. Yesu agòɗ à azlaməna matapla la slaka aŋha: “Dzàw à abanay, gəda à madəv kuɗa!” ");
INSERT INTO mfh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yesu ahə̀l azla Piyer, Yakuba la Yuhana kà maday atà nna. Adzəkà maskulay la mazaw la gəl. ");
INSERT INTO mfh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Agòɗ à atà: “Mazaw la gəl akəɗ gi. Ama dzàw la abanay, dzèwhàl aw!” ");
INSERT INTO mfh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Azà à atà vok la vok ala ŋuv, atə̀ɗ à vəɗah, adə̀v kuɗa à Zəzagəla: “Baŋa kaslala vok, và à gi tetəvi, kà kaslà aŋa ŋgərpa ada aŋha la slaka gulo. ");
INSERT INTO mfh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Iyay Baba gulo, kaslala vok kà maɗàh tatak gesina. Zə̀ɓagəŋ kətsaw ŋgərpa uwanay ala la slaka gulo. Ama bokuba uwana asa à gi aw, say bokuba uwana asa à ka.” ");
INSERT INTO mfh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ŋgaha awùl à waŋ, aɓəzà azlaməna matapla aŋha makər uwatà à gəl, atà la madzehal gà. Agòɗ à Piyer: “Səmon, kadzehal ay? Kaslala vok aŋa madz à ahəŋ la adi sa tekula aw ay? ");
INSERT INTO mfh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Akul gesina dzàw à ahəŋ la adi, də̀vàw kuɗa kà matəɗiya à mava­varay à abà aw. Haɗay, masasəɗok aŋa dza asal makəs gay, ama vok aŋha la nzdəɗa aw!” ");
INSERT INTO mfh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ŋgaha adà aŋha aya. Adə̀v kuɗa kalkal uwana uwarà. ");
INSERT INTO mfh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Uwana awùl à waŋ, aɓəzà atà à gəl la madzehal gà. Taslàlà vok aŋa madz à ahəŋ la adi aw. Tasə̀l uwana tawùllal ala aw. ");
INSERT INTO mfh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Uwana awùl à waŋ à slaka aŋatà aŋa mamakər aŋha, agòɗ à atà: “Kadzewhal, kaduwaw ləv ay? Diga adagay, sa kà adaslay. Lagwa azlaməna tsakana takəs Kona aŋa dza. ");
INSERT INTO mfh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Sàw à afik, məhàd adagay, aganay dza uwana atəg à gi kaf à gəl kà ada­zlaŋay”, Yesu agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mok uwana Yesu avàts gay dadàŋ, Yudas, tekula la tataka aŋa azla­kulo gəl aŋha səla la abà, asà à waŋ. Maham à ahəŋ dza aŋuvaw tanəfà à waŋ la katsakar, la zəva. Məŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla, la azla­ma­dza­haga aŋa wakità seriya aŋa Zəzagəla, la azla­ma­siga la uwana taslə̀lla atà. ");
INSERT INTO mfh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas uwana atàl kaf à gəl apə̀hla dabaray à maham à ahəŋ dza kà makəs Yesu. Agòɗ: “Dza uwana gədàsəkwiŋ maslawda slawda kà, masla la uwana kayahaw, kadà, kə̀sàw, ɗawùlla nə̀ŋàwla.” ");
INSERT INTO mfh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Uwana adabəz à abatà, katskats ahàd à slaka Yesu, agòɗ: “Məŋga gulo!”, akəsà vok. ");
INSERT INTO mfh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Azladza takə̀s Yesu, tawà­slàhàŋ à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ama tekula la tataka azlaməna matapla la abà, atsìzlla ala, aɓə̀ɗ katsakar aŋha à lag, aɗə̀ɗ magamza aŋa məŋga aŋa azlaməna mav tatak à Zəzagəla, anàtsal sləm lakəl ala. ");
INSERT INTO mfh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu agòɗ à maham à ahəŋ dza: “Kà mana katsàw à wàŋ la katsakar ŋgaha la zəva la ahàl kà aŋa makəs gi ma? Gi masla nabəra ay? ");
INSERT INTO mfh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kəla mavakay gədzà à ahəŋ la akul la məŋ gày Zəzagəla la aku, gətàpakulla tatak, akul bay kakə̀sàw gi aw. Ama uwaga apaka vok kà madəvəŋ à gay tatak uwana azlaməna mapəh à atà gay à ahàl tapə̀h dagay uwarà.” ");
INSERT INTO mfh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ŋgaha azlaməna matapla la slaka aŋha gesina tasàkal à ahəŋ. Tahòy aŋatà. ");
INSERT INTO mfh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kohana anik la ahəŋ, anəfà Yesu la peteli la vok pəra. Tayàh kà makəsay. ");
INSERT INTO mfh_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ama asàkatàla peteli à ahəŋ, ahòy aŋha ala diga. ");
INSERT INTO mfh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Maham à ahəŋ dza tadàla Yesu à slaka məŋga aŋa azlaməna mav tatak à Zəzagəla, la azla­magol dza la azla­ma­dza­haga aŋa wakità seriya aŋa Zəzagəla. Gesina tahamà gay à vok. ");
INSERT INTO mfh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyer anəfà atà la lig kərkər, adà à kodal aŋa məŋga aŋa azlaməna mav tatak à Zəzagəla à abà, adzà madzay la azla­slodzi à vəɗa akàl à vok. ");
INSERT INTO mfh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Azlaməŋga aŋa azlaməna mav tatak la azla­ma­dza­haga gesina tayàh dabaray aŋa makəsalla fida à gəl aŋa madukwla seriya mamətsay à gəl, ama taɓəzà à mawi­siga aŋha aw. ");
INSERT INTO mfh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kà uwana uwa­be­yuwi atùgw gay fida lakəl aŋha, ama fida aŋatà akəsà vok aw. ");
INSERT INTO mfh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Azlanik aŋatà tasà à afik ŋgaha tatsə̀ɗal azla­fida anik anik à gəl gesina. ");
INSERT INTO mfh_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Mətsənàŋ agòɗ kà: ‘Gədàkal magol gày Zəzagəla uwanay à ahəŋ, uwana azladza taŋàl la ahàl la mahənay makər, gədàhənəŋ ala kokuɗa maf ahàl à abà aŋa azladza’, agòɗ.” ");
INSERT INTO mfh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Baməraka la maɗàh fida uwatà, gay aŋatà akə̀s à vok aw. ");
INSERT INTO mfh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Məŋga aŋa azlaməna mav tatak asà à afik, atsìzlla ala la tataka azladza la abà gesina, anavà Yesu la gay ala: “Kawulla gay à uda aw takay? Mana à uwana tatugw kà gəl tak ma?” ");
INSERT INTO mfh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ama Yesu adzà à ahəŋ titi. Awùlla gay à uda aw. Məŋga aŋa azlaməna mav tatak anavà Yesu aya: “Kak Kristu, Kona aŋa Zəzagəla uwana tazləɓay ay?” ");
INSERT INTO mfh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu agòɗal: “Bà kiya uwaga, kadànəŋaw Kona aŋa dza madza madzayga la ahàl kaf aŋa Zəzagəla lakəl la maslay, la mazləɓay məŋga, ŋgaha atsa à ahəŋ la habaga zagəla la abà.” ");
INSERT INTO mfh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Məŋga aŋa azlaməna mav tatak akwàhà lukut aŋha ala, agòɗ: “Məwoya sayda anik lakəl aŋha aya aw! ");
INSERT INTO mfh_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Katsənàw uwana apə̀h mawi­siga lakəl aŋa Zəzagəla. Mana kadzəgwaw ma?” Gesina aŋatà tadùkwla seriya mamətsay à gəl. ");
INSERT INTO mfh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Azladza anik la tataka aŋatà la abà tadzəkà mataf slesliɓ à Yesu à adi. Tatsàkal à yewdi à ama, tazlàɓ la mamits ahàl, ŋgaha tagòɗal: “Pə̀hanula, uwa à uwana aɗə̀ɗ à ka uwa?” Azla­slodzi takə̀s Yesu, ŋgaha tabakàlla ahàl à sləm à abà. ");
INSERT INTO mfh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piyer la gəl akàl dadàŋ, à uwana dugu madza­dzaray aŋa məŋga aŋa azlaməna mav tatak asà à waŋ. ");
INSERT INTO mfh_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Uwana anəŋà Piyer à vəɗa akàl à vok kà, anərə̀z, agòɗ: “Kak bay, kadzà à ahəŋ la Yesu, zil Nazaret.” ");
INSERT INTO mfh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ama Piyer aɗahà fida, agòɗ: “Gəsəl aw, gətsəna gay uwaga asa à ka magoɗay aw!” Ŋgaha asà à uda, adà aŋha à dzog­dzog à abà. Mok uwatà mew­g­dza­galaŋ awiyà. ");
INSERT INTO mfh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Dugu madza­dzaray anəŋà Piyer aya, agòɗ à azladza uwana la abatà aya: “Dza uwanay kà tekula aŋatà bay!” ");
INSERT INTO mfh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ama Piyer agòɗ aya: “Awaŋ, gi tekula aŋatà aw.” La lig la ahəŋ ŋuv, azladza uwana la abatà tagòɗ à Piyer: “Haɗay, kak bay, kak tekula aŋatà, kà uwana kak zil Galili.” ");
INSERT INTO mfh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Piyer adzəkà magoɗay: “Baŋa gəɗàh fida, say Zəzagəla avà à gi ŋgərpa zagəla. Gəsəl dza uwaga kapəhaw gay aŋha ɗiki­ɗiki aw!” ");
INSERT INTO mfh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","La mok uwatà mew­g­dza­galaŋ awiyà kà masəla. Gay uwana Yesu apə̀h, awùl à Piyer à gəl: ‘Mok uwana mew­g­dza­galaŋ awiyay asik səla dadàŋ aw, kadà­goɗay asik makər kà, kasəl gi aw.’ Piyer adzəkà matuway. ");
INSERT INTO mfh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bəŋ la zay la tsəh, azlaməŋga aŋa azlaməna mav tatak takə̀s sawaray la azla­ma­dza­haga aŋa wakità seriya aŋa Zəzagəla gesina, tatsurkà Yesu, tadàlla, tavà à Pilatus à ahàl à afik. ");
INSERT INTO mfh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatus anavà Yesu la gay ala: “Kak Sufəl aŋa azla Yahu­diya ay?” Yesu awulàlla: “Iyay, bokuba uwana kagòɗ.” ");
INSERT INTO mfh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Azlaməŋga aŋa azlaməna mav tatak, takàl gay à Yesu à vok aŋuvaw. ");
INSERT INTO mfh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatus anavà Yesu aya: “Kawulla à gay à uda aw uwà? Tsənà makəl à ka gay à vok aŋatà tsi.” ");
INSERT INTO mfh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ama Yesu awùlla à gay à uda aw. Ləv avàl à Pilatus à gay kà uwaga. ");
INSERT INTO mfh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kəla madəvaday Paska, Pilatus adùwatàla gəl à masla daŋay tekula, uwana maham à ahəŋ awoyàŋ. ");
INSERT INTO mfh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","La mok uwatà, dza tekula la ahəŋ la daŋay la aku, sləm aŋha Barabas. Masla tekula aŋa azlaməna mazləl guvəl à gumna à adi, takàɗ dza la magazlay la abà. ");
INSERT INTO mfh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Maham à ahəŋ dza ahàd à mtəga Pilatus kà aŋa manav uwana Pilatus aɗa­hà­hàtàŋ viya viya. ");
INSERT INTO mfh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatus anavà atà à gay ala: “Asa à akul kà gəduwakulla gəl Sufəl aŋa azla Yahu­diya ay?” ");
INSERT INTO mfh_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kà uwana asə̀l kà azlaməŋga aŋa azlaməna mav tatak tadàla Yesu à slaka aŋha kà maŋor pəra. ");
INSERT INTO mfh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ama azlaməŋga aŋa azlaməna mav tatak tavədzàhà à tsəh azladza à afik kà Pilatus aduwatàla gəl kà Barabas. ");
INSERT INTO mfh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatus agòɗ à maham à ahəŋ dza aya: “Mana asa à akul gəɗehəŋ à dza uwanay à vok kaza­lawla ala Sufəl aŋa azla Yahu­diya ma?” ");
INSERT INTO mfh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tawulàlla la mawiyay: “Zlə̀l masla à ahàf à adi!” ");
INSERT INTO mfh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatus anavà atà: “Mana mawi­siga aŋha uwana aɗahàŋ ma?” Ama tazàla mawiyay à gəl aya: “Zlə̀l masla à ahàf à adi!” ");
INSERT INTO mfh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatus awoyà marab ləv aŋa azladza. Kà uwaga à uwana aduwà à atà gəl à Barabas. Ŋgaha agòɗ à azla­slodzi kà taslàh Yesu ala la kurpi, avà à atà masla à ahàl kà mazləliya à ahàf à adi. ");
INSERT INTO mfh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Azla­slodzi tadàla Yesu à gəl akàl aŋa Pilatus, tazàlàhà azla­slodzi gesina. ");
INSERT INTO mfh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tadùwal dawara mativga à vok, taslàslàp atàk, tatse­fàɗal à gəl maga­ba­ga gabaga aŋa sufəl kà makədaslal. ");
INSERT INTO mfh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ŋgaha tasukwà masla: “Ayyi, Sufəl aŋa azla Yahu­diya!” ");
INSERT INTO mfh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Taɗə̀ɗ à gəl la kavak, tatàfal slesliɓ à vok, takədèɗ à ahəŋ la huma aŋha bokuba sufəl kà madze­dzinay. ");
INSERT INTO mfh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Uwana tadə̀v makəɗaslal à gay, tasərə̀tal dawara mativga uwatà la vok ala, tawùllal lukut aŋha à vok, ŋgaha tadàla à uda kà aŋa mazləl à ahàf à adi. ");
INSERT INTO mfh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","La tetəvi la ama, tagagàm la dza, uwana zil gudəŋ Səren, sləm aŋha Səmon baba aŋa Ale­kəsander atà la Rufus. Masla atsà à waŋ la guf aŋha la abà. Azla­slodzi tafàl ndzəɗa à gəl aŋa mazəɓ ahàf aŋa Yesu. ");
INSERT INTO mfh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tadàla Yesu à slaka uwana sləm aŋha Gol­go­ta. (Bokuba magoɗay: slaka aslasl takasa à gəl) ");
INSERT INTO mfh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","La abatà asà à atà aŋa maval iyaw hamhamga uwana tatè­ɗalla mir à tsəh, kà mataslala maziŋ ala, ama Yesu akweskà kà masay. ");
INSERT INTO mfh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ŋgaha tata­tàsl Yesu à ahàf à adi. Tavàhà lukut aŋha la tataka aŋatà la abà, tatsàl tsatsa lakəl, kà uwana asà à atà masəl tatak uwana uwa­be­yuwi aŋatà aɓə̀zal. ");
INSERT INTO mfh_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mok uwana tatàsl Yesu à ahàf à adi kà zil gosela. ");
INSERT INTO mfh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tatsetsèr à gəl aŋha gay seriya tapə̀hla ala la magoɗay gay uwana takə̀ɗ ala: SUFƏL AŊA AZLA YAHUDIYA. ");
INSERT INTO mfh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tata­tàsl azlaməna nabəra səla à ahàf à adi la Yesu, tekula la ahàl kaf aŋha, tekula bay la ahàl gudzay aŋha. (( ");
INSERT INTO mfh_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kiya uwaga agay bokuba uwana tatsetsèr à wakità Zəzagəla à abà: Tatugw masla à tataka aŋa azlaməna haypa à abà.)) ");
INSERT INTO mfh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Azladza uwana tagu­wàhà à awtày la abatà takəɗàslal, tako­kò­tàhà gəl, tagòɗal: “Nə̀ŋàŋ zla! Kak uwana kagòɗ kà, asa à ka makal magol gày Zəzagəla à ahəŋ, aŋa maŋalay anik la mavakay makər, kagòɗ. ");
INSERT INTO mfh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Sà à ahəŋ la ahàf la adi, ɓə̀lla gəl aŋak tak zla!” ");
INSERT INTO mfh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kiya uwaga babay azlaməŋga aŋa azlaməna mav tatak takəɗàslal la azla­ma­dza­haga aŋa wakità seriya aŋa Zəzagəla la slaka gà, tagòɗ kà atà kà atà: “Aɓəlà azladza anik, ama aslala vok aŋa maɓəl gəl aŋha aw uwà? ");
INSERT INTO mfh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Say mənəŋəŋ Mesi, Sufəl aŋa Isərayel atsa à ahəŋ la ahàf la adi dadàŋ, ŋgaha mədiŋal gəl à vok.” Azladza uwana tata­tàsl à ahàf à adi tatsə̀kal mago­ɗahay à gəl babay. ");
INSERT INTO mfh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","La tataka afats, mələs apakà vok la kutso la abà gesina, tsəràh afats dat mogova gova gərewni delga. ");
INSERT INTO mfh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","La afats dat magova gova gərewni delga uwatà, Yesu awiyà la ndzəɗa, agòɗ: “Eloyyi, Eloyyi, lema sabac­ht­ha­ni?”. (Bokuba magoɗay: Zəzagəla gulo, Zəzagəla gulo, kà mana kasak gi ma?) ");
INSERT INTO mfh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Azlaanik uwana tadzà à ahəŋ la abatà tatsənà uwaga, tagòɗ kà: “Aganay azalay à dza uwana Zəzagəla apəhal gay à ahàl à uwana sləm aŋha Eliya.” ");
INSERT INTO mfh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dza tekula ahòy à awtày la abatà, ahənà sawsaw ala la iyaw hamhamga, afà sawsaw à gay kavak, avàl kà mako­kuzay, agòɗ: “Tsetsi mədzà à ahəŋ titi, mənərə̀z à baŋa Eliya atsa à waŋ kà aŋa mazəɓ à ahəŋ la ahàf la adi!” ");
INSERT INTO mfh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ama Yesu awiyà la ndzəɗa, ŋgaha amə̀ts. ");
INSERT INTO mfh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ama bafta məŋga uwana la gày Zəzagəla la aku, akohàla tsəràɗ, tsəràh à afik, tsəràh à vəɗah. ");
INSERT INTO mfh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Məŋga aŋa azla­slodzi dzim, uwana atsìzl à huma aŋa Yesu, anəŋà mamətsay aŋha, à uwana ada­wiyay, agòɗ: “Haɗay, dza uwanay kà Kona aŋa Zəzagəla!” ");
INSERT INTO mfh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Azlamis uwana tanəŋà à awtày kərkər la ahəŋ, la abatà la tataka aŋatà la abà, Mari­yama dəg zla Magdala, la Mari­yama iyà aŋa Yakuba uwana bəziga la Yosəs, la Salome. ");
INSERT INTO mfh_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tau­gu­zàhàh la azla Yesu, à mok uwana agà la gudəŋ Galili. La abatà bay azlamis anik aŋuvaw tahàɗ la azla Yesu la slaka gà à Uru­sa­lima à afik. ");
INSERT INTO mfh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Lagwa kà mokokhu adagay, uwaga mavakay maɗàh vok à ahəŋ bokuba magoɗay vuɗ maɗàh vok aŋa vuɗ maduw ləv. ");
INSERT INTO mfh_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","La gay mokokhu, Yusufu zil Arimate asà à waŋ, masla tekula la tataka aŋa azla­ma­siga la abà. Masla kà akùd makoray Zəzagəla babay. Kurit yewdi agòɗal kà madiya à slaka Pilatus aw. Anàv vok aŋa Yesu. ");
INSERT INTO mfh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ama ləv avàl à Pilatus à gay, kà uwana atsənàŋ kà Yesu adamətsay katskats. Azàla məŋga aŋa azla­slodzi dzim, anàv la slaka aŋha: “Amə̀ts ma uwarà ay?” ");
INSERT INTO mfh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Uwana adatsən dziriga la slaka məŋga aŋa azla­slodzi dzim, avà tetəvi à Yusufu kà mazəɓ vok aŋa Yesu. ");
INSERT INTO mfh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufu asùkw bafta, azə̀ɓ vok aŋa Yesu à ahəŋ la ahàf la adi, afafàɗ à bafta uwatà à abà, afà à zəvay à agu, zəvay kà tàlla kà à tsakur à abà. Ŋgaha ata­kòslal məŋ abəlam à ama. ");
INSERT INTO mfh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari­yama dəg zla Magdala, la Mari­yama iyà aŋa Yosəs tanəŋà zəvay uwana tafà Yesu à agu ");
INSERT INTO mfh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Uwana mavakay maduw ləv adada à lig, Mari­yama dəg zla Magdala, la Mari­yama iyà aŋa Yakuba, la Salome tasùkw amàl matərsin kà aŋa madla aŋa maɗa­hiya à Yesu à vok. ");
INSERT INTO mfh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bəŋ la zay la tsəh, vuɗ ladu uwana afats à lig mas à afik, tahàd à gəl zəvay. ");
INSERT INTO mfh_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tagòɗ kà atà kà atà: “Uwa adà­ta­kosl anu à bəlam à zəvay la ama ala uwa?” ");
INSERT INTO mfh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kà uwana bəlam uwatà kà məŋga. Ama tanəŋà à awtày kà, tanəŋà bəlam mata­koslal à ama ala gà tsewwa. ");
INSERT INTO mfh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tahàd à zəvay à agu. Tanəŋà bəzi kohana uwana adzà madzay la abatà la ahàl kaf lakəl, la lukut me­ɗe­kuga la vok. Guba akə̀s atà. ");
INSERT INTO mfh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Agòɗ à atà: “Guba akəs akul aw! Kayahaw Yesu zil Nazaret, uwana tata­tàsl à ahàf à adi. Aga la abanay aw, awùl à uda la mamətsay. Aganay slaka aŋha uwana tahənàŋ à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Lagwa kà, dàw, kadà­goɗaw à azlaməna matapla aŋha, kaykay gà kà à Piyer à gay uwanay: Yesu atsavokkay kà akul kà mad à Galili. La abatà kadà­nəŋawwaŋ bokuba uwana agòɗ à akul.” ");
INSERT INTO mfh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Azlamis tasà à uda la zəvay la aku, tahòy. Ləv avàl atà à gay la guba məŋga. Taɓaɗmà à dza aw kà uwana guba akə̀s atà. ");
INSERT INTO mfh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Uwana Yesu adawul à uda la mamətsay, bəŋ vuɗ ladu apə̀hla vok à Mari­yama dəg zla Magdala dadàŋ. (Mis uwana akuɗə̀kal azla­ma­sasəɗok mawi­siga məɗəf lakəl ala) ");
INSERT INTO mfh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mari­yama ahàd kà mapəh uwaga à azladza uwana tadzàhà à ahəŋ la Yesu, tazàwla gəl, ŋgaha tatàw. ");
INSERT INTO mfh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ama mok uwana tatsənà uwana apə̀h à atà kà, Yesu aga la ahəŋ la sifa kà, ŋgaha kà masla anəŋàŋ kà, atà tadìŋal gəl à vok aw. ");
INSERT INTO mfh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","La lig la ahəŋ, Yesu apə̀hla vok à azlaməna matapla aŋha səla. La mok uwana atà tahàd à mau­gu­zahay à bəzi gudəŋ anik à abà. ");
INSERT INTO mfh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tawùl à Uru­sa­lima à abà, tapə̀h à azladza anik, ama atà bay kà, tadìŋal gəl à vok aw. ");
INSERT INTO mfh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","La lig la ahəŋ, Yesu apə̀hla vok à azlaməna matapla la slaka aŋha kulo gəl aŋha tekula, la mok uwana atà la tatak may lakəl. Agòɗ à atà kà, atà la madiŋal gəl à vok aw, atà la ləv dzaŋ­d­zaŋga. Kà uwana tadìŋ gəl à azladza uwana à vok, tagòɗ à atà kà tadanəŋ la sifa aw. ");
INSERT INTO mfh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yesu agòɗ à atà: “Dàw à gudəŋ à vok gesina, zàwàŋ, pə̀hàw gay Zəzagəla à azladza gesina! ");
INSERT INTO mfh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Dza uwana adiŋal gəl à vok adàhalla batem, adàɓəlay. Dza uwana adiŋal gəl à vok aw Zəzagəla adàɗahalla seriya à gəl. ");
INSERT INTO mfh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aganay azla­na­dzipo la maslay uwana azlaməna madiŋal gəl à vok tadàɗah à ahəŋ la sləm gulo: Tadà­slala vok makuɗəkàh azla­ma­sasəɗok mawi­siga, tadà­vatsah azlagay məlok gà, ");
INSERT INTO mfh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","tadàkas azla­bebi la ahàl amiyaka tadàsa magur bay kà, aza à atà aw. Tadàɓak ahàl à azlaməna ɗuvats à gəl, ŋgaha tadàwur ala.” ");
INSERT INTO mfh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","La mok uwana Sufəl Yesu adadəv gay aŋha à gay, adà aŋha à zagəla, adzà madzay la ahàl kaf aŋa Zəzagəla lakəl. ");
INSERT INTO mfh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Azlaməna asik aŋha, tahàd à gudəŋ à vok gesina aŋa maz gay matsi­ɗayga aŋa Sufəl Zəzagəla. Sufəl Yesu aɗahà sləray la atà aya gotənaŋ, apə̀hla dziriga aŋa gay aŋatà ala la maɗàh nadzipo aŋuvaw.");
INSERT INTO mfh_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Deda Tewofil. Azladza aŋuvaw tawàɗ vok à uda, kà matsetser gay uwana apakahà vok la tataka gami la abà. ");
INSERT INTO mfh_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tatse­tseràh azla­tatak uwana tatsənàŋ la slaka azladza uwana tanəŋàŋ la yewdi aŋatà, dagay la madzəka, ŋgaha tafà à atà kà mapəhay gay uwaga à ahàl. ");
INSERT INTO mfh_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Gi babay gəkə̀s tetəvi aŋa manərəz tatak uwaga gesina, dagay la madzəka, kà gi aŋa mapàhla uwaga ala, la tekula tekula à kak məŋga Tewofil. ");
INSERT INTO mfh_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Uwana gəɗahà uwaga kà, kà kak aŋa matsən dziriga aŋa matapla uwana kaɓə̀zal gesina. ");
INSERT INTO mfh_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","La mok uwana Herod agà Sufəl aŋa Yahu­diya kà, masla mav tatak à Zəzagəla anik la ahəŋ, uwana sləm aŋha kà Zakari; masla kà tsəhay aŋa azlaməna mav tatak à Zəzagəla, la huɗ gày aŋa Abiya. Sləm aŋa mis aŋha kà Eli­sabet, masla kà mayyi à tsəh ala aŋa Haruna, məŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla uwarà. ");
INSERT INTO mfh_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Atà səla nna kà, azladza dziriga la huma aŋa Zəzagəla, ŋgaha takə̀s gay aŋa Sufəl Zəzagəla la ləv tekula, tanəfà mapəhay aŋha la dziriga bay. ");
INSERT INTO mfh_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ama bəzi aŋatà la ahəŋ aw, Eli­sabet aslàla vok aŋa maɓəz bəzi aw, kà uwana tadapak makoz. ");
INSERT INTO mfh_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Vərdi anik, Zakari aɗàh sləray aŋa makaɗ tatak à Zəzagəla, kà uwana à ahàl iyaw aŋha kà maɗehəŋ. ");
INSERT INTO mfh_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Bokuba uwana zagəlà aŋatà aŋa mazəɓani vok la ahàl iyaw la ahàl iyaw, kà masəl dza uwana aɗàh sləray la mavakay uwatà la tsəh, ŋgaha atə̀ɗ à Zakari à gəl kà maɓək kidzidzi la gày Sufəl Zəzagəla la aku. ");
INSERT INTO mfh_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","La mok uwana aɓə̀k kidzidzi kà, maham à ahəŋ dza tadə̀v kuɗa. ");
INSERT INTO mfh_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","La abatà malika aŋa Sufəl Zəzagəla apə̀hla vok à Zakari, atsìzl à ahàl kaf aŋa slaka maɓək kidzidzi à gəl. ");
INSERT INTO mfh_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Guba akə̀s Zakari à mok uwana anəŋàŋ askùlla à tsəh ala kaykay. ");
INSERT INTO mfh_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ama malika agòɗal: “Zakari, guba akəs ka aw, kà uwana Zəzagəla adatsən madəv kuɗa aŋak. Eli­sabet mis aŋak adàyya à ka bəzi, kadàvàl sləm Yuhana. ");
INSERT INTO mfh_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kak kadàhənla la marabay, ŋgaha azladza aŋuvaw tadà­rabay lakəl aŋa mayyi masla. ");
INSERT INTO mfh_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kà uwana adàgay məŋ dza la huma yewdi aŋa Sufəl Zəzagəla. Tetuwa adàsa guzu aw, amiyaka bà mana beymi uwana maməslga bay kà adàsay aw. Adàgay mahənla à la Masasəɗok Zəzagəla dagay la huɗ aŋa iyà aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Adà­wulla azla Isərayel aŋuvaw à huma Sufəl Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Masla la gəl aŋha adàtsa vok à awtày à huma Zəzagəla la ndzəɗa aŋa Masasəɗok, ŋgaha la ndzəɗa aŋa masla mapəhal gay à ahàl Eliya uwana uwarà, kà matsən vok gay azla­baba la azlabəza aŋatà, adà­wulla azlaməna makəs gay aw à haŋkəli aŋa azladza dziriga à abà, adàɗah tsəhay à ahəŋ kà mas à waŋ aŋa Sufəl Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ama Zakari agòɗ à malika: “Kakay gədàsəlay kà uwaga kà dziriga ma? Tsa məda­pakah makoz la mis gulo mi”, agòɗal. ");
INSERT INTO mfh_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kiya uwaga malika agòɗal: “Gi kà sləm gulo kà Gabəriyel. Gi la uwana Zəzagəla afà à gi à huma aŋha à gay, kà gi aŋa mazla­kəŋ, masla aslə̀l gi à waŋ kà mapəh à ka gay uwaga. ");
INSERT INTO mfh_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ama kadìŋ gəl à gay gulo uwana à vok gəpə̀h à ka, adàpaka vok gəgòɗ à ka aw kà, kà uwaga kapakay bada, kaɓaɗma aya aw, tsəràh à uwana tatak uwana gəpə̀h à ka adàpaka vok dandan la uwana kadà­ɓaɗma.” ");
INSERT INTO mfh_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","La kaslà uwatà, azlaməna madiŋal gəl à vok takùd Zakari la uda, ŋgaha ləv avàl atà à gay məŋga, kà uwana asàf məŋga la gày maɓək kidzidzi la aku. ");
INSERT INTO mfh_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ama mok uwana adasa à uda kà, aslàla vok aŋa maɓa­ɗa­tàma aya aw, azladza tadzùgw kà: Anəŋà nadzipo anik la gày la aku, tagòɗ. Aɓa­ɗa­tàmà kà la ahàl pəra, kà uwana aslàla vok kà maɓaɗma aya aw. ");
INSERT INTO mfh_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mok uwana Zakari adadəv kaslà aŋha à gay kà maɓək kidzidzi la məŋ gày Zəzagəla la aku kà, awùl à mtəga aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Zwek la huma la gay kà, bəzi adà à Eli­sabet, mis aŋha, à huɗ, ŋgaha masla Eli­sabet ahaɗà bəzi la huɗ tsəràh à təla zlo. Agòɗ la gəl aŋha: ");
INSERT INTO mfh_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Iyay, aganay tatak uwana Sufəl Zəzagəla aɗahàŋ kà aŋulo, Zəzagəla asàl aŋa mahəlla gi ziruwi lakəl ala la huma azladza gesina.” ");
INSERT INTO mfh_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","La təla mukwa, Zəzagəla aslə̀l malika Gabəriyel à gudəŋ Galili, uwana sləm aŋha Nazaret, ");
INSERT INTO mfh_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","à slaka dahalay anik, uwana mawɗa aŋa Yusufu, masla kà la mayyi à tsəh ala aŋa sufəl David la abà. Sləm aŋa dahalay uwatà bay kà Mari­yama. ");
INSERT INTO mfh_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malika adagay à slaka aŋha agòɗal: “Ràb, kà uwana Zəzagəla adahənkala la vok mahamay aŋha, Sufəl Zəzagəla la ahəŋ la kak.” ");
INSERT INTO mfh_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mari­yama kà gəl akàɗal à vok kà gay uwaga. Anavà gəl aŋha agòɗ: ‘Mana asal magoɗay ayyi marabay gà uwanay ma?’ ");
INSERT INTO mfh_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kiya uwaga malika agòɗal: “Mari­yama, guba akəs ka aw, kà uwana kadaɓəz vok mahamay aŋa Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kadàgay la bəzi la huɗ ŋgaha kadàyyi bəzi zilga, uwana kadàvàl sləm Yesu. ");
INSERT INTO mfh_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Masla adàgay məŋ dza, ŋgaha tadà­zallalla Kona aŋa Zəzagəla, uwana kərkər la afik. Sufəl Zəzagəla adà­pa­kəŋ ala kà məŋ sufəl, bokuba uwana aɗahàŋ à David, baba aŋha madzi­dziga. ");
INSERT INTO mfh_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ŋgaha adàkor tsəhay Isərayel aŋa koksi­koksi; makoray aŋha adàkəɗ gəl à ahəŋ aw.” ");
INSERT INTO mfh_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari­yama agòɗ à malika: “Kakay uwaga adàpaka vok, tsa gi la zil dadàŋ aw ma?” ");
INSERT INTO mfh_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malika agòɗal: “Masasəɗok tsi­kasla adàsa à ahəŋ à gəl aŋak, ŋgaha ndzəɗa aŋa Zəzagəla uwana kərkər la afik, adàsa à ka à gəl, bokuba dzəgay, kà uwaga à uwana bəzi uwana kadàyyi kà, tadà­zallalla: Tsi­kasla, Kona aŋa Zəzagəla uwana la zagəla la afik. ");
INSERT INTO mfh_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Eli­sabet dəg tsiŋ aŋak babay kà, bəzi la huɗ, te­ke­ɗika adagay makoz babay, azladza kà ‘Dəgər’, tagòɗal, ama lagonay kà bəzi la huɗ aŋa təla mukwa. ");
INSERT INTO mfh_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kà uwana tatak la ahəŋ aɗuw kà Zəzagəla à gəl aw.” ");
INSERT INTO mfh_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kiya uwaga Mari­yama agòɗ: “Gi kà, gi mayà aŋa Sufəl Zəzagəla; apakà à gi vok, bokuba uwana kapə̀h lagwa zlà.” Kiya uwaga malika asàkal à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","La kaslà uwatà, Mari­yama atsìzlla ala, amərà vok, kà mad à gudəŋ anik à abà, la gudəŋ la afik la kutso Yahu­diya. ");
INSERT INTO mfh_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ahàd à gày aŋa Zakari, “Ayyi”, agòɗ à Eli­sabet. ");
INSERT INTO mfh_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","La mok uwana Eli­sabet atsənà maɗàh ‘Ayyi’ aŋa Mari­yama kà, bəzi aɓəlakà vok la huɗ aŋha. Eli­sabet adàhənla la Masasəɗok Zəzagəla, ");
INSERT INTO mfh_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","awiyà la ndzəɗa: “Zəzagəla apìs à ka gay à vok kaykay la tataka azlamis anik la abà gesina, ŋgaha mapis gay à vok aŋha adàdza à ahəŋ lakəl aŋa bəzi, uwana kadàɓəzal. ");
INSERT INTO mfh_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Gi ma gi uwa, à uwana iyà aŋa Sufəl gulo atsa à waŋ à mtəga gulo uwa? ");
INSERT INTO mfh_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kà uwana mok uwana gətsənà ‘Ayyi’ aŋak kà, bəzi aɓəlakà vok la huɗ gulo la marabay. ");
INSERT INTO mfh_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Lapiya agay la kak, kà uwana kadiŋ gəl à tatak uwana à vok, Sufəl Zəzagəla apə̀h à ka uwaga apaka vok.” ");
INSERT INTO mfh_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Kiya uwaga Mari­yama agòɗ: “Masasəɗok gulo azləɓ məŋga aŋa Sufəl Zəzagəla, ");
INSERT INTO mfh_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ləv gulo adahənla la marabay à kà Zəzagəla masla maɓəl gi. ");
INSERT INTO mfh_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kà uwana vok ahamàl kà gi à uwana anə̀ŋ gi kà kiya gi mayà aŋha tələmmaga. Iyay, dagay lakana azladza tagoɗay kà, gi kà gi mapis gay à vok gà. ");
INSERT INTO mfh_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kà uwana Zəzagəla, uwana tsi­kasla, aɗahà tatak gesina dzəɓa aŋha səla aw kà aŋulo. Sləm aŋa Zəzagəla kà tsi­kasla. ");
INSERT INTO mfh_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mawoyəŋ aŋha adàgay la ahəŋ Lakəl aŋa azladza gesina, uwana tahoy yewdi aŋha koksi­koksi. ");
INSERT INTO mfh_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ahənà azlasləray məŋga məŋga ala, la ndzəɗa aŋa ahàl aŋha. Awìts azlaməna zlapay gà ala. ");
INSERT INTO mfh_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Adakwà azla­su­fəl à ahəŋ la kursi aŋatà la afik, ada­walla atà à vəɗah; Ama azi­gənàhà azlaməna tələmmaga. ");
INSERT INTO mfh_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ahanà azlaməna may ala la azla­tatak delga, delga gà, Akuɗə̀kàh azla­go­robu la ahàl deyday. ");
INSERT INTO mfh_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Asà à waŋ, azlàk tsəhay aŋha Isərayel, masla sləray aŋha Avikàŋ kà mapəhla delga aŋha ala aw, ");
INSERT INTO mfh_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","La slaka Abəraham, ŋgaha la mayyi à tsəh ala aŋha kà aŋa koksi­koksi, Bokuba uwana apə̀h à azla­baba gami madzi­dziga.” ");
INSERT INTO mfh_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari­yama adzà à ahəŋ la Eli­sabet nekwa nekwa təla makər, la lig la ahəŋ, awùl à mtəga aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kiya uwaga mok uwana kaslà masewk à ahəŋ aŋa Eli­sabet adaslay kà, ayyà bəzi zilga. ");
INSERT INTO mfh_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Azlaməna magay aŋha la azlatsəhay aŋha tatsənàŋ kà Sufəl Zəzagəla ada­ɗa­halla delga, ŋgaha atà taràb la slaka gà. ");
INSERT INTO mfh_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mok uwana bəzi adaɗah kasukwa tekula kà, tadala kà makədəv à uda, atà kà, asà à atà kà mavàl sləm aŋa baba aŋha, Zakari. ");
INSERT INTO mfh_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ama, “Awaŋ”, iyà aŋha agòɗ; “Sləm aŋha kà mavàl kà Yuhana.” ");
INSERT INTO mfh_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","“Awaŋ, dza la ahəŋ la tsəhay aŋak la abà, à uwana tavàl tsəhay sləm uwanay”, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kiya uwaga tanavà baba aŋha mabada bada, kà masəl sləm uwana asàl mav à bəzi. ");
INSERT INTO mfh_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakari anàv tatak kà manəhal à adi, ŋgaha kiya uwanay à uwana anə̀h: ‘Yuhana, la uwana sləm aŋha.’ Ləv avàl atà à gay gesina aŋatà. ");
INSERT INTO mfh_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Katskats la abatà Zakari adzəkà mapokw gay kà maɓaɗma, adzəkà mazləɓ Zəzagəla la kuda zləkkà. ");
INSERT INTO mfh_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kiya uwaga guba akə̀s azlaməna magay aŋha gesina, ŋgaha azlaməna madz à ahəŋ la gudəŋ uwatà la afik gesina tapàh tatak uwana apakà vok. ");
INSERT INTO mfh_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Azladza gesina uwana tatsənà uwana tapəhay kà, awùl atà à gəl, ŋgaha tanàvàh à vok: “Tsa bəzi uwanay ma adàgay ma uwa tak uwa? Ndzer, maslay aŋa Sufəl Zəzagəla la ahəŋ lakəl aŋha, haɗay!” ");
INSERT INTO mfh_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakari, baba aŋa bəzi uwaga, agà mahənlaga la Masasəɗok Zəzagəla, adzəkà maziŋ kiya uwanay: ");
INSERT INTO mfh_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Mazləɓay agay kà la Sufəl, uwana Zəzagəla aŋa azla Isərayel Kà uwana afà sləm à azladza aŋha, aɓə̀lla atà. ");
INSERT INTO mfh_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Masla apə̀hanula maslay la mav à anu masla maɓələŋ dziriga, Uwana la mayyi à tsəh ala aŋa Sufəl David la abà, uwana magamza aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Uwaga la uwana apə̀h uwarà la paŋaw aŋa azlaməna mapəh à atà gay à ahàl kà mapàh à azladza: ");
INSERT INTO mfh_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Gədàtəf akul la ahàl aŋa azlaməna məzam aŋkul agòɗ, Ŋgaha la ahàl aŋa azla­uwana tapəsew anu gesina.’ ");
INSERT INTO mfh_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Masla adàpəhla mawoyəŋ aŋha à azla­baba gami madzi­dziga ala, Ŋgaha gay makəs vok slawda aŋha tsi­ka­slaga uwatà adà­wulal à gəl. ");
INSERT INTO mfh_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kà uwana Sufəl Zəzagəla azùw mawaɗay à baba gami madzi­dziga Abəraham. ");
INSERT INTO mfh_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Kà masla aŋa mapəlanula la ahàl aŋa azlaməna məzam gami, Ŋgaha kà anu aŋa maɗahala sləray la kokuɗa kurit yewdi. ");
INSERT INTO mfh_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kà anu aŋa magay sətaka, ŋgaha la dziriga la huma aŋha koksi­koksi. ");
INSERT INTO mfh_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ŋgaha kak, bəzi gulo kadàgay masla mapəhal gay à ahàl aŋa dza uwana kərkər la afik aŋa koksi­koksi. Kà uwana kak la uwana kadàguway la huma aŋa Sufəl kà maɗa­hallaŋ tetəvi à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ŋgaha kà mapəhla à azladza aŋha ala kà, adàɓəl atà la mamats atà tsakana aŋatà ala. ");
INSERT INTO mfh_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Haɗay, Sufəl Zəzagəla gami kà, adahənla la vok mahamay, ŋgaha la lapiya, Adasləl à anu uɗaka à ahəŋ à gəl gami gesina, bokuba uɗaka aŋa afats uwana atsa à afik. ");
INSERT INTO mfh_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kà masla aŋa manəŋ azladza uwana ala, atà la mələs la abà, ŋgaha la azladza uwana la dzəgay aŋa mamətsay la abà, Ŋgaha masla aŋa manəŋla asik gami la tetəvi aŋa lapiya la tsəh.” ");
INSERT INTO mfh_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Bəzi azigə̀n, ŋgaha haŋkəli aŋha bay azàla vok à gəl. Adzà à ahəŋ la fəta la abà, tsəràh à mavakay uwana apə̀hla vok ala la huma tsəhay Isərayel. ");
INSERT INTO mfh_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","La zamana uwatà Awgustus, məŋ sufəl aŋa azla Rom agòɗ kà: ‘Say tatugw dza la makoray gulo gesina’, agòɗ. ");
INSERT INTO mfh_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Uwaga kà matugw dza matera, uwana apakà vok la zamana aŋa Kwi­ri­niyus gumna aŋa kutso Səriya. ");
INSERT INTO mfh_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Azladza gesina tadàh kà matsetser atà, kəla uwa­be­yuwi adà à gudəŋ aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusufu babay atsìzlla ala la Nazaret la kutso Galili, kà maday à kutso Yahu­diya, à huɗ gudəŋ uwana à abà, Be­te­lehem tagòɗal, à slaka uwana tayyà sufəl David à abà. Kà uwana masla kà mayyi à tsəh ala aŋa David. ");
INSERT INTO mfh_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tahàd kà matsetser sləm aŋatà, la mawɗa aŋha, Mari­yama, uwana akùd kaslà masewk à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kiya uwaga, mok uwana tabəzay, kaslà masewk à ahəŋ aŋha adaslay. ");
INSERT INTO mfh_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ŋgaha ayyà bəzi zilga, malkwoy aŋha, afa­fàɗal lukut à adi, ŋgaha ahənàŋ à daŋor à abà, kà uwana slaka la ahəŋ kà aŋatà la gày məlok dza la aku aw. ");
INSERT INTO mfh_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","La gudəŋ uwatà, azlaməna manəŋla azla­tatak la ahəŋ uwana tahanay la fəta kà manəŋla azla­tatak aŋatà. ");
INSERT INTO mfh_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Malika aŋa Sufəl Zəzagəla apə̀hatàla vok, ŋgaha mazləɓay aŋa Sufəl Zəzagəla awùɗla slaka aŋatà. Guba akə̀s atà gesina aŋatà. ");
INSERT INTO mfh_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ama malika agòɗ à atà: “Guba akəs akul aw, kà uwana gəsà à akul à waŋ kà gay matsi­ɗayga, uwana adàrab azlatsəhay gesina. ");
INSERT INTO mfh_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","La huɗ aŋa vəɗ uwanay la abà, la huɗ gudəŋ aŋa David la abà kà, tayyà à akul masla maɓəl akul: Masla Kristu, Sufəl. ");
INSERT INTO mfh_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Aganay tatak uwana adàpəhakulla: Kadànəŋaw bəzi vərna mafa­fàɗal lukut à adi gà, mahənəŋ à ahəŋ gà la daŋor la abà.” ");
INSERT INTO mfh_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Katskats, maham à ahəŋ malika la zagəla tahamà gay à vok la malika uwatà, taslə̀kàw Zəzagəla tagòɗ: ");
INSERT INTO mfh_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Mazləɓay aga la Zəzagəla uwana la zagəla, Lapiya aga la gudəŋ la vok la slaka azladza uwana Zəzagəla awoya atà, ŋgaha azla­uwana tawoya masla babay!” ");
INSERT INTO mfh_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mok uwana azla­ma­lika tasàk atà à ahəŋ, tawùl aŋatà à zagəla kà, azlaməna manəŋla azla­tatak tagòɗ à vok kà atà à atà: “Məhàd tsəràh à Be­te­lehem zlà, delga kà mənəŋ tatak uwana apakà vok, mədànəŋ Sufəl Zəzagəla apə̀hanula zlà”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ŋgaha atà tamərà vok kà maday, taɓə̀z à Mari­yama à vok atà la Yusufu, ŋgaha la bəzi vərna, uwana mahənəŋ à ahəŋ gà la daŋor la abà. ");
INSERT INTO mfh_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mok uwana tanəŋə̀ŋ, tatùgw gay uwana tanəŋàŋ, la uwana tatsənà la slaka aŋa malika lakəl aŋa bəzi. ");
INSERT INTO mfh_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Azladza uwana tatsə̀ɓ sləm à azlaməna manəŋla azla­tatak uwaga kà, ləv avàl atà à gay gesina, kà uwana tatsənà uwaga. ");
INSERT INTO mfh_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ama Mari­yama kà, aɓə̀k uwaga gesina à gəl aŋha à afik, adzùgw uwaga la lela. ");
INSERT INTO mfh_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","La lig la ahəŋ, azlaməna manəŋla azla­tatak takə̀s tetəvi kà mawul aŋatà la mazləɓ Zəzagəla. Tazləɓà masla kà azla­tatak uwana tatsənàŋ, la uwana tanəŋàŋ, kà uwana uwaga gesina kà, apakà vok bokuba uwana malika apə̀h à atà. ");
INSERT INTO mfh_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mok uwana kasukwa tekula adadà à lig kà, mahənay adaslay kà makədəv Yesu à uda, tavàl sləm Yesu, sləm uwana malika apəhla ala à mok uwana iyà aŋha alə̀g mazəɓ à huɗ dadàŋ. ");
INSERT INTO mfh_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ŋgaha bokuba uwana gay aŋa maɗàh mavəlàh adadəv à gay kà, bokuba uwana mapəhay aŋa Musa agoɗ, tadàla Yesu à Uru­sa­lima kà mapəhla masla ala la huma aŋa Sufəl Zəzagəla, ");
INSERT INTO mfh_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","bokuba uwana tatsetsèr à mapəhay aŋa Sufəl à abà: ˈKəla malkwoy zilga kà, uwaga tatak matsufay gà aŋa Sufəl Zəzagəla la fəta la awtày tsi­kasla.ˈ ");
INSERT INTO mfh_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Takaɗàh azla­tatak uwana kaɗàw, wakità mapəhay agòɗ: ˈAzla­ha­ba­koku fəta səla baŋaw azla­zla­bara haba­koku mtəga səla.ˈ ");
INSERT INTO mfh_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Dza anik la ahəŋ la Uru­sa­lima uwana sləm aŋha Səmeyyon. Zil uwatà kà dza dziriga, akə̀s gay aŋa Zəzagəla, ŋgaha akudà dza uwana naka atsa à waŋ, kà maɓəl azladza Isərayel. Masla kà agà la Masasəɗok Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ŋgaha Masasəɗok Zəzagəla apə̀hla à vok à abà kà, adàmətsay dadàŋ aw, say baŋa adànəŋ huɗ adi aŋa Kristu, uwana Sufəl Zəzagəla adàsləl à ahəŋ dadàŋ. ");
INSERT INTO mfh_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Masasəɗok Zəzagəla adàla masla à məŋ gày Zəzagəla à agu, la mok uwana azla­baba tasə̀lla Yesu à waŋ, kà maɗa­hallaŋ bokuba uwana: ‘Ɗa­hàwwàŋ’, wakità seriya agòɗ. ");
INSERT INTO mfh_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Səmeyyon azə̀ɓ bəzi à ahàl, ŋgaha ‘Kikay’, agòɗ à Zəzagəla la magoɗay: ");
INSERT INTO mfh_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Sufəl, lagonay kà mapəh à ahəŋ aŋak kà adagəɗ à afik, Sàk à mayà aŋak aməts aŋha la lapiya adagay zlà, ");
INSERT INTO mfh_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kà uwana lagwa kà, gədanəŋ maɓəlay aŋak la yewdi gulo, ");
INSERT INTO mfh_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Uwana kaɗahàŋ à ahəŋ kà aŋa tsəhay gesina. ");
INSERT INTO mfh_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Uwaga la uwana uɗaka uwana adapəhla ka ala la huma azladza gudəŋ à vok gesina, Uwaga la uwana adavà mazləɓay à tsəhay aŋak Isərayel.” ");
INSERT INTO mfh_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Baba la iyà aŋha atà səla nna ləv avàl atà à gay kà gay uwana Səmeyyon apə̀h lakəl aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Səmeyyon apìs à atà gay à vok, ŋgaha agòɗ à Mari­yama iyà aŋa Yesu: “Zəzagəla akə̀sànì bəzi uwanay kà, kà matsalla matekwiɗ, ŋgaha kà aŋa matsizlla azladza aŋuvaw ala la tataka azla Isərayel la abà. Adagay tatak manəŋal adi aŋa Zəzagəla, uwana azladza tadà­kweska. ");
INSERT INTO mfh_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ŋgaha adàpəhla madzugway aŋa azladza gesina ala la uɗaka la abà la dazu­waya, ŋgaha kak babay kà, katsakar adàzləl madzugway aŋak ala kà madzugway aŋa tsəh ləv aŋak mas à uda la dazu­waya.” ");
INSERT INTO mfh_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Agà la ahəŋ babay masla mapəhal gay ahàl misga uwana sləm aŋha kà Hana, dugu aŋa Fanuyel uwana la tsəhay aŋa Asər. Masla adagay makoz, zil dahalay aŋha uwana ahàd kà, taɗahà mavay məɗəf atà səla, ");
INSERT INTO mfh_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","adzà à ahəŋ bokuba mis kuɗa tsəràh à mavay dzik mtəgis gəl aŋha ufaɗ. Masla azàhà vok la gày Zəzagəla la aku aw, la mavakay la mahanay gesina, azlàkàh Zəzagəla, ŋgaha akàs nəlay la madəv kuɗa babay. ");
INSERT INTO mfh_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Asà à waŋ la kaslà uwatà, “Kikay”, agòɗ à Zəzagəla, ŋgaha apə̀h gay aŋa bəzi à azladza gesina uwana atà takudà kà Zəzagəla aŋa maɓəl Uru­sa­lima. ");
INSERT INTO mfh_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mok uwana azla­baba aŋa Yesu tadàva tatak uwana à gay: ‘Ɗa­hàwwàŋ’, wakità mapəhay aŋa Sufəl Zəzagəla agòɗ kà, tawùl aŋatà la masla à Galili à gudəŋ Nazaret. ");
INSERT INTO mfh_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Bəzi adà à huma à gay la mazigənay, azàla ndzəɗa à gəl aya, ahə̀nla la matsi­hila. Ŋgaha vok mahamay aŋa Sufəl Zəzagəla agà lakəl aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kəla mavay azla­baba aŋha tadàhah à Uru­sa­lima kà aŋa madəvaday Paska. ");
INSERT INTO mfh_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","La mok uwana adaɗah mavay kulo gəl aŋha səla kà, tasə̀l à waŋ la tsəh, kà uwana zagəlà aŋatà. ");
INSERT INTO mfh_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mok uwana madəvaday adadəv à gay kà, tawùl aŋatà, la kokuɗa masəlay aŋa azla­baba, kà Yesu agə̀ɗ à Uru­sa­lima. ");
INSERT INTO mfh_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Madzugway aŋatà kà: ‘Yesu kà aga la tataka aŋa azla­ma­nalay aŋha la abà’, tagòɗ, ŋgaha la mok uwana lis tavàk asik à gəl kà, tadzəkà mayahay la tataka aŋa dugum tsiŋ aŋha la abà, ŋgaha la azla­ma­nalay aŋha la abà babay. ");
INSERT INTO mfh_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ama taɓə̀zal aw, kà uwaga à uwana azla­baba aŋha tawùl à Uru­sa­lima kà mayahay. ");
INSERT INTO mfh_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","La mavakay mamakər taɓə̀zal à gəl la məŋ gày Zəzagəla la aku. Masla adadza madzay la tataka aŋa azlaməna matapla tatak à azladza la abà, atsə̀ɓ à atà sləm, la manavàh atà tatak. ");
INSERT INTO mfh_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Azladza gesina uwana tasə̀ɓal sləm, ləv avàl atà à gay kà haŋkəli aŋha, ŋgaha kà azla­ma­wul à uda aŋha aya. ");
INSERT INTO mfh_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mok uwana azla­baba aŋha tanə̀ŋ kà, takə̀s gəl la ahàl səla, ŋgaha iyà aŋha agòɗal: “Bəzi gulo, kà mana maɗàh à anu a ahəŋ kiya uwanay ma? Nə̀ŋàŋ tsi, anu la baba aŋak kà, mədayàh ka kà məŋga, la iyaw tugwi la adi.” ");
INSERT INTO mfh_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Agòɗ à atà: “Kà mana kayàhàw gi ma? Kasə̀làw kà, azlayla gi, aŋa madz à ahəŋ la gày aŋa baba gulo la aku, kà maɗàh sləray aŋha aw takay?” ");
INSERT INTO mfh_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ama atà kà tatsənà tatak uwana apə̀h à atà aw. ");
INSERT INTO mfh_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kiya uwaga Yesu awùl à mtəga atà nna à gudəŋ Nazaret, akə̀s atà gay la ahàl ala. Ama iyà aŋha kà akəsàn lakəl à mad vok aŋa azla­tatak gesina uwana apakà vok. ");
INSERT INTO mfh_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu azigə̀n, maslay aŋha adà à huma à gay, masla ahə̀ɗ à Zəzagəla à adi, ŋgaha à azladza gesina à adi babay. ");
INSERT INTO mfh_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","La mavay makulo gəl aŋha zlo aŋa makoray aŋa məŋ sufəl aŋa azla Rom, uwana sləm aŋha Tiber Zəsar, Pontsəyus Pilatus agà gumna aŋa Yahu­diya, Herod bay akòr Galili, ŋgaha deda aŋha Filip akòr Ituriya la Təra­ko­niya, ŋgaha Lisa­niyas akòr Abilen. ");
INSERT INTO mfh_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","La kaslà uwatà kà, Hanas atà la Kayyif atà tagà azlaməŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla. La mok uwaga gay aŋa Zəzagəla atsənà à Yuhana, kona aŋa Zakari la kəsaf la abà. ");
INSERT INTO mfh_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yuhana augùzàh la kutso uwana la abatà la makəla aŋa Urdun gesina. Azàtàŋ, agòɗ: “Pə̀hàw gay la ləv ala, ɗahàw batem ŋgaha Zəzagəla adàmatsakulla tsakana aŋkul ala.” ");
INSERT INTO mfh_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Uwaga kà bokuba uwana tatsetsèr à wakità aŋa masla mapəhal gay à ahàl Yesayya à abà: ˈUwaga kà kuda aŋa dza uwana awiyay la fəta la abà: Slàɗàw tetəvi à Sufəl à ahəŋ, Tsàzlàw azla­tetəvi mana­la­ba­hayga ala gesina! ");
INSERT INTO mfh_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Azlazləlok gesina aɗahàbà, Azla­gu­dəŋ la azla­dadəgwal tapakàh vada­vaday, Azla­ma­na­labay aŋa barama tatsazl ala, azla­tetəvi uwana malàh à uda gà, taɗa­hàbà taka­karra. ");
INSERT INTO mfh_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kiya uwaga azladza gesina tadànəŋ maɓəl anu aŋa Zəzagəla.ˈ ");
INSERT INTO mfh_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Maham à ahəŋ dza aŋuvaw asà à waŋ à slaka Yuhana, kà atà aŋa maɓəz batem. Masla agòɗ à atà kà: “Akul azlabəza aŋa matsapa, uwa à uwana agòɗ à akul kà kadàtəfaw à mapak ləv aŋa Zəzagəla la gay la à uwana adàsa à waŋ bawbaw uwa? ");
INSERT INTO mfh_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Lagwa kà, ɗahàwwàŋ sləray uwana apəhla ala kà kadà­ɓəɗawla kà vok, kà kapəhaw gay la ləv ala zlà, kadzugwaw la ləv aŋkul la tsəh kà: ‘Abəraham baba gami madzi­dziga’, kagoɗaw aw. Kà uwana haɗay gəpəh à akul kà, Zəzagəla aslala vok aŋa mapak azlaakur uwanay ala, kà magay azlabəza aŋa Abəraham. ");
INSERT INTO mfh_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Lagwa kà goslka kà maɗehəŋ à ahəŋ gà, kà mahərats la tsəh à ahàf à afik. Kəla ahàf uwana av mayyay delga aw kà, tanats à ahəŋ, ŋgaha taduwa à akàl à tsəh.” ");
INSERT INTO mfh_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kiya uwaga maham à ahəŋ dza anàv: “Mana ma à uwana məɗehəŋ zlà ma?” ");
INSERT INTO mfh_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Masla awùlatàla, agòɗ: “Dza uwana akor lukut səla tavàhàŋ la dza uwana aŋha la ahəŋ aw, ŋgaha dza uwana la tatak may babay tatsàkàŋ la dza uwana aŋha la ahəŋ aw.” ");
INSERT INTO mfh_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Azlaməna mazəɓ hadama tasà à waŋ aŋa maɗa­hatàŋ batem suwaŋ, ŋgaha tanavà Yuhana: “Məŋga, mana ma à uwana məɗehəŋ ma?” ");
INSERT INTO mfh_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kiya uwaga agòɗ à atà: “Kafàw à azladza à gəl kà mapəlay məŋga ɗuwà uwana pə̀làw, tagòɗ aw.” ");
INSERT INTO mfh_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kiya uwaga azla­slodzi tanàv suwaŋ: “Anu ma, kakay anu babay zlà ma?” Agòɗ à atà: “Kahalaw sili azladza ala la gasa aw, baŋaw la tetəvi fida gà aw, ama kùdàw kà masik aŋkul uwana kadà­ɓəzawwal.” ");
INSERT INTO mfh_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ama uwana maham à ahəŋ dza gesina tagà la manəwəŋ la abà lakəl aŋa Yuhana kà, ‘Zlahaw kà, masla la uwana Kristu’ tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","“Gi”, Yuhana agòɗ à atà gesina kà, “Gəɗa­ha­kulla batem kà la iyaw. Ama dza anik la ahəŋ atsa à waŋ la lig gulo la ahəŋ kà, bà gi babay kà gəsla mapəzl zuwiɗ kwimik aŋha ala babay aw. Masla kà adà­ɗa­ha­kulla batem kà la Masasəɗok tsi­kasla, ŋgaha la akàl. ");
INSERT INTO mfh_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kətsaw madula hi aŋha la ahàl, kà masəhla hi, kà mavàh à atà ala la tafarga. Hi aŋha kà adàtsak à vəɗa aŋha à abà, ama tafarga kà, aduwal à akàl uwana à tsəh adàmats ala ɗiki­ɗiki aw!” ");
INSERT INTO mfh_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","La mapəh à atà azlagay anik anik aŋuvaw aya, la uwana Yuhana azà gay matsi­ɗayga à azlatsəhay uwaga. ");
INSERT INTO mfh_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yuhana asləhà vok à Herod à kà uwana azə̀ɓ He­ro­diya, mis aŋa deda aŋha, ŋgaha kà uwana aɗahà azla­ma­wi­siga anik anik aŋuvaw aya. ");
INSERT INTO mfh_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kiya uwaga Herod azàla mawi­siga aŋha à gəl aya la maduw Yuhana à daŋay. ");
INSERT INTO mfh_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kiya uwaga Yesu asà à waŋ, à mok uwana azladza gesina taɓə̀z batem, aɓəzà à batem aŋha suwaŋ. La kaslà uwana adə̀v kuɗa, zagəla apə̀zl à ama ala, ");
INSERT INTO mfh_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ŋgaha Masasəɗok Zəzagəla asà à ahəŋ à gəl aŋha bokuba haba­koku. Ŋgaha bay kuɗa atsə̀n à ahəŋ la zagəla la magoɗay: “Kak bəzi gay ləv gulo; marabay gulo gesina kà la kak la afik.” ");
INSERT INTO mfh_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","La mok uwana Yesu adzəkà sləray aŋha, kà adaɗah mavay dzik makər. La madzugway aŋa azladza kà: ‘Kona aŋa Yusufu’ tagòɗ, à uwana agà kona aŋa Heli. Aganay madzəka vok mayyi à tsəh ala aŋa azla­baba madzi­dziga uwana adà à huma à gay. ");
INSERT INTO mfh_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli kona aŋa Matat, kona aŋa Levi, kona aŋa Melki, kona aŋa Yanay, kona aŋa Yusufu, ");
INSERT INTO mfh_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","kona aŋa Mata­tiyas, kona aŋa Amos, kona aŋa Nahum, kona aŋa Esəli, kona aŋa Nagay, ");
INSERT INTO mfh_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","kona aŋa Mat, kona aŋa Mata­tiyas, kona aŋa Səmeyyi, kona aŋa Yosək, kona aŋa Yoda, ");
INSERT INTO mfh_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","kona aŋa Yohanan, kona aŋa Resa, kona aŋa Zoro­babel, kona aŋa Sala­tiyel, kona aŋa Neri, ");
INSERT INTO mfh_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","kona aŋa Melki, kona aŋa Adi, kona aŋa Kosam, kona aŋa Elmadam, kona aŋa Er, ");
INSERT INTO mfh_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","kona aŋa Yesu, kona aŋa Eli­ye­zər, kona aŋa Yorim, kona aŋa Matat, kona aŋa Levi, ");
INSERT INTO mfh_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","kona aŋa Səmeyyon, kona aŋa Yahuda, kona aŋa Yusufu, kona aŋa Yonam, kona ana Eli­yakim, ");
INSERT INTO mfh_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","kona ana Meleyya, kona aŋa Mena, kona aŋa Matata, kona aŋa Natan, kona aŋa David, ");
INSERT INTO mfh_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","kona aŋa Yese, kona aŋa Yobed, kona aŋa Boz, kona aŋa Sala, kona aŋa Naheson, ");
INSERT INTO mfh_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","kona aŋa Ami­nadab, kona aŋa Adəmin, kona aŋa Arəni, kona aŋa Esərom, kona aŋa Farəs, kona aŋa Yahuda, ");
INSERT INTO mfh_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","kona aŋa Yakuba, kona aŋa Isak, kona aŋa Abəraham, kona aŋa Tara, kona aŋa Nakor, ");
INSERT INTO mfh_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","kona aŋa Səruk, kona aŋa Ragaw, kona aŋa Falek, kona aŋa Eber, kona aŋa Sala, ");
INSERT INTO mfh_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","kona aŋa Kaynam, kona aŋa Arəfakəsad, kona aŋa Səm, kona aŋa Nuhu, kona aŋa Lamek, ");
INSERT INTO mfh_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","kona aŋa Matu­sala, kona aŋa Enok, kona aŋa Yared, kona aŋa Male­leyel, kona aŋa Kaynan, ");
INSERT INTO mfh_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","kona aŋa Enos, kona aŋa Sət, kona aŋa Adama, uwana agà la gəl aŋha kona aŋa Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu ahə̀nla la Masasəɗok Zəzagəla, awùlla à waŋ la gay mukwà Urdun. Ŋgaha Masasəɗok Zəzagəla adàlla à fəta à abà. ");
INSERT INTO mfh_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","La abatà aɗahàŋ mavakay dzik ufaɗ, azùw tatak aw, la mok uwaga seteni apapàt masla kà, uwana masla la may gà. ");
INSERT INTO mfh_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kiya uwaga seteni agòɗal: “Baŋa kak bəzi aŋa Zəzagəla kà, pakà akur uwanay ala kà kaf.” ");
INSERT INTO mfh_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu awulàlla: “Iyay, uwaga kà matse­tseray gà: ˈAma dza adzadzar vok kà la kaf pəra aw.ˈ” ");
INSERT INTO mfh_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Seteni adàlla à afik kərkər aya, apə̀hla azla­ma­koray aŋa gudəŋ à vok. ");
INSERT INTO mfh_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ŋgaha agòɗal: “Gədàvà à ka maslay uwana la abà la tatak uwana la gudəŋ uwanay la vok gesina, kà uwana uwaga kà aŋulo, ŋgaha gi babay kà gəslala vok aŋa mav à dza uwana asa à gi. ");
INSERT INTO mfh_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","A baŋa kak kasləkaw gi, la makəɗ à gi à aheŋ, kà uwaga gesina kà adàgay kà aŋak.” ");
INSERT INTO mfh_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu agòɗal: “Wakità agoɗ kà: ˈSufəl Zəzagəla aŋak la uwana kanəfay pəra, ŋgaha masla kokuɗa gəl aŋha la uwana kazlakəŋ pəra.ˈ” ");
INSERT INTO mfh_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kiya uwaga seteni adàla masla à Uru­sa­lima, adàla masla à gəl məŋ gày Zəzagəla à afik, agòɗal: “Baŋa kak bəzi aŋa Zəzagəla kà, vàl à ahəŋ la abanay! ");
INSERT INTO mfh_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kà uwana uwaga kà matse­tseray gà: ˈDàw, Zəzagəla adàgoɗ à azla­ma­lika aŋha, kà manəŋla ka!ˈ Ŋgaha aya kà: ");
INSERT INTO mfh_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ˈAtà kà, tadàkəs kà ahàl, kà kak aŋa mazləl asik à akur la adi aw.ˈ” ");
INSERT INTO mfh_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu agòɗal: “Wakità Zəzagəla agoɗ kà: ˈKatapa Sufəl Zəzagəla aŋak aw.ˈ” ");
INSERT INTO mfh_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mok uwana seteni adàv mapapat Yesu à gay la azla­da­baray anik anik gesina kà, asàkal à ahəŋ, adà aŋha, say kà afats anik. ");
INSERT INTO mfh_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu awùlla à Galili mahənlaga la ndzəɗa ana Masasəɗok Zəzagəla. Tadzəkà mavats gay lakəl aŋha la makoray uwatà la abà gesina. ");
INSERT INTO mfh_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Atàpla tatak à azladza la azlagày madəv kuɗa la aku. Azladza gesina tatsə̀ɓal sləm, tazlə̀ɓa masla. ");
INSERT INTO mfh_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu awùlla à gudəŋ Nazaret à slaka uwana à abà azigə̀n. La vuɗ maduw ləv aŋa azla Yahu­diya, ahàd à gày Zəzagəla à agu bokuba uwana adagay zagəlà aŋha. Atsìzlla ala kà madzeŋ wakità. ");
INSERT INTO mfh_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tavàl à ahàl wakità aŋa Yesayya, masla mapəhal gay à ahàl, à ahàl, apapàs wakità uwatà à uda ŋgaha abə̀z à slaka anik uwana tatsetsèr kà: ");
INSERT INTO mfh_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ˈMa­sasəɗok ana Sufəl Zəzagəla lakəl gulo, Akə̀sànì gi, kà gi aŋa madla gay matsi­ɗayga à azlaməna kuɗa. Aslə̀l gi à waŋ kà, kà gi aŋa mapəh gay mapəlla à azlaməna daŋay, Kà mavàh yewdi à azla­gu­ləf, Ŋgaha kà mataf azla­uwana tas ŋgərpa. ");
INSERT INTO mfh_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kà mapəhla ala mavày uwana vok mahamay aŋa Sufəl Zəzagəla adàpəhla vok ala.ˈ ");
INSERT INTO mfh_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ŋgaha kiya uwaga Yesu akə̀l wakità à abà, awùlla à ahəŋ, adzà aŋha madzay. Dèwdèw dza uwana la gày uwatà la aku tatsə̀kal yewdi à gay gesina. ");
INSERT INTO mfh_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","La lig la ahəŋ, adzəkà magoɗ à atà: “Lakana kà, matse­tseray uwanay kà, adagəɗ à afik à uwana mədzèŋ la abanay la sləm aŋkul.” ");
INSERT INTO mfh_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Atà gesina takə̀s gay aŋha, ləv avàl atà à gay, kà gay aŋha dzəɓa aŋha səla aw gà uwaga apə̀h à atà. Tagòɗ: “Masla kà kona aŋa Yusufu aw takay?” ");
INSERT INTO mfh_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu agòɗ à atà: “Dzer, asa à gi kapəhaw gi gay la gay la abà uwanay: ˈDokwtar wurà gəl aŋak ala!ˈ kadà­goɗaw gi babay: ‘Anu mətsənà uwana kaɗahàŋ la Kaper­nahum gesina, ɗahàŋ uwaga la huɗ gudəŋ aŋak babay zlà!’ ” ");
INSERT INTO mfh_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ŋgaha aya agòɗ à atà: “La dziriga gəpəh à akul, ɗiki­ɗiki masla mapəhal gay à ahàl la ahəŋ tawoyəŋ, la huɗ gudəŋ aŋha uwana tayyà abà aw. ");
INSERT INTO mfh_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Iyay la dziriga gəpəh à akul: La zamana aŋa Eliya, azlamis kuɗa la ahəŋ aŋuvaw la gudəŋ Isərayel, la mok uwana iyaw anə̀ɗ à ahəŋ la zagəla aw mavay makər la təla mukwa. Ŋgaha magol məl may məŋga apakà vok la gudəŋ uwatà gesina. ");
INSERT INTO mfh_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ama Zəzagəla aslə̀l Eliya à mtəga aŋa tekula aŋa azlamis uwaga aw, say à slaka aŋa mis kuɗa uwana la Sarepəta, la makoray aŋa Sədon la abà pəra. ");
INSERT INTO mfh_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Agà la ahəŋ babay azlaməna akàl zagəla aŋuvaw la gudəŋ Isərayel la zamana aŋa Elise, masla mapəhal gay à ahàl, amiyaka bà tekula aŋatà kà awùr ala aw, say Naman zil Səriya pəra.” ");
INSERT INTO mfh_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mok uwana tatsənà gay uwaga, azladza gesina la gày madəv kuɗa la aku tapakàh à ləv. ");
INSERT INTO mfh_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tasà à afik, takàs masla, tabàyàŋ à uda la gudəŋ aŋatà la abà, tadàlla à dadəgwal uwana à afik taŋà­làhal gày aŋatà à makəla, ŋgaha kà atà aŋa maməl à ahəŋ la afik la abatà. ");
INSERT INTO mfh_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ama masla, kussàh, asà à uda la tataka aŋatà la abà, adà aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu ahàd à gudəŋ Kaper­nahum, uwana la kutso Galili la abà. Ŋgaha adzəkà matapla tatak à azladza la vuɗ maduw ləv. ");
INSERT INTO mfh_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ləv avàl atà à gay məŋga kà mapàhla ala aŋha, kà uwana atàpatàla kà lela, ŋgaha la maslay. ");
INSERT INTO mfh_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","La gày madəv kuɗa uwatà la aku kà, dza anik la ahəŋ uwana masasəɗok mawi­siga atərəɓəhəŋ, adzəkà mawiyay la ndzəɗa. ");
INSERT INTO mfh_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Kayyà, kak Yesu, zil Nazaret, mana gay aŋak la anu ma? Kasà à waŋ ma, kà mazàh anu ala takay? Gəsəl la dziriga kà, kak tsi­ka­slaga uwana Zəzagəla aslə̀l kà à waŋ!” ");
INSERT INTO mfh_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu aslə̀h məl à masasəɗok mawi­siga uwaga à gəl la ndzəɗa, agòɗal: “Dzà à ahəŋ titi, sà à dza uwaga lakəl ala!”, masasəɗok mawi­siga amə̀l gəl à dza uwaga à ahəŋ la huma aŋa azladza gesina, ŋgaha asàl à kəl ala, kokuɗa maɗahal amik à vok. ");
INSERT INTO mfh_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Azladza gesina kà, ləv avàl à atà à gay, tavàts gay la tsəh ala kà atà kà atà: “Kakay, à tsəhay gay uwanay ma? Masla akor azla­ma­sasəɗok mawi­siga la ndzəɗa, ŋgaha azla­ma­sasəɗok takəs gay aŋha, tasàh azladza lakəl ala ma?” ");
INSERT INTO mfh_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ŋgaha azladza tadzəkà mapəhay lakəl aŋa Yesu la makoray uwatà la abà gesina. ");
INSERT INTO mfh_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu asà à lag la gày madəv kuɗa la aku, ŋgaha ahàd à mtəga aŋa Səmon. Məŋay aŋa Səmon la akàl à vok məŋga, məŋga. La abatà tanavà Yesu kà mawurəŋ ala. ");
INSERT INTO mfh_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu atsòŋ à masla ɗuvats à gəl, apə̀h gay la tsəh ala la ndzəɗa, “Sàkal!”, agòɗ à ɗuvats. Ɗuvats asàk à mis uwaga, katskats asà à afik kà mazlak atà à sləray à abà. ");
INSERT INTO mfh_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","La mok uwana afats adatəɗ à ahəŋ, tasàhla azlaməna ɗuvats à waŋ, la azla­ɗu­vats anik anik gesina, kà maɓak à atà ahàl à gəl la tekula, tekula aŋatà gesina, awarà atà ala. ");
INSERT INTO mfh_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Azla­zagəla zagəla la azla­ma­sasəɗok mawi­siga tasàh à azlaməna ɗuvats lakəl ala aŋuvaw la mawiyay: “Kak la uwana kak Kona aŋa Zəzagəla!” Ama Yesu apə̀h à atà gay la ndzəɗa, ŋgaha adèɗ à atà gay à ahəŋ kà mavats gay la ndzəɗa, kà uwana tasə̀l kà, masla kà Kristu. ");
INSERT INTO mfh_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mok uwana məl ada­wulla, Yesu asà à uda la gudəŋ la abà, adà aŋha à fəta à abà kokuɗa gəl aŋha. Maham à ahəŋ dza aŋuvaw tadzəkà mayàh masla. Mok uwana tabə̀zal à vok kà, asà à atà asàk atà à ahəŋ aya aw. ");
INSERT INTO mfh_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ama Yesu agòɗ à atà: “Say gəz gay matsi­ɗayga aŋa makoray Zəzagəla à azla­gu­dəŋ anik gesina bay, kà aŋa uwaga à uwana Zəzagəla aslə̀l gi à waŋ.” ");
INSERT INTO mfh_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ŋgaha apàh gay Zəzagəla la azlagày madəv kuɗa la aku la kutso Galili gesina. ");
INSERT INTO mfh_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Vərdi anik Yesu atsìzlla à gay dərəv aŋa dərəv Ge­ne­saret, ŋgaha magol maham à ahəŋ dza tahamà à slaka aŋha kà matsəɓ sləm à gay Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesu anəŋà azlakəslah iyaw səla la gay gərdza, azlaməna makas kilfi tasà à ahəŋ la afik, tapalàh dzarawa aŋatà. ");
INSERT INTO mfh_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu ahàd à kəslah iyaw à afik, uwana agà aŋa Səmon, agòɗal: “Zà à gi à gəl iyaw ŋuv.” Ŋgaha adzà madzay la kəslah iyaw la afik, adzəkà matapla tatak à maham à ahəŋ dza uwaga. ");
INSERT INTO mfh_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mok uwana adadəv matapatàla à gay kà, agòɗ à Səmon: “Zàw vok à gəl dərəv lela, ŋgaha kak la azla­ma­nalay aŋak kadawaw dzarawa aŋkul à iyaw à abà, kà makas kilfi.” ");
INSERT INTO mfh_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Səmon agòɗal: “Məŋga, huyip, mədahənal à gəl kà madaw à abà, ama mədakəs tatak aw. Ama bokuba uwana kapə̀h kà, gəkweska gay aŋak aw, gəduw à abà aya kità.” ");
INSERT INTO mfh_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kiya uwaga atà tadùw dzarawa aŋatà à abà, ahə̀l kilfi à agu aŋuvaw tsəràh à uwana dzarawa aŋatà awòy masla­hàhla, kà magay məŋga aŋa kilfi uwana la aku. ");
INSERT INTO mfh_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","La abatà atà tafa­ta­kàhà azla­ma­nalay aŋatà, uwana la kəslah iyaw anik la afik, kà atà aŋa mas à waŋ aŋa mazlak atà, tadà à awtày tazlàk atà, tahanà kəslah iyaw ala səla nna la kilfi tsəràh à uwana azlakəslah iyaw uwaga tawòy madàh à huɗ iyaw, kà mahanay aŋa azla­kilfi uwaga. ");
INSERT INTO mfh_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Uwana Səmon Piyer anəŋà uwaga kà, akədèɗ à huma aŋa Yesu la magoɗal: “Sufəl, zà à gi vok la vok ala, kà uwana gi kà gi masla tsakana!” ");
INSERT INTO mfh_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Guba akə̀s masla, la azladza uwana atà nna gesina, kà magol kilfi uwana takàs. ");
INSERT INTO mfh_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Azla Yakuba la Yuhana, azlabəza aŋa Zebede, uwana sləray aŋatà tekula la Səmon, ləv avàl atà à gay babay. Ama Yesu agòɗ à Səmon: “Guba akəs ka aw, dagay lakana gədàpaka ka ala kà masla makas azladza.” ");
INSERT INTO mfh_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Mok uwana tadàla azlakəslah iyaw aŋatà à gay gərdza kà, tasàk à tatak gesina à ahəŋ, tanəfà Yesu. ");
INSERT INTO mfh_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu agà la gudəŋ anik la abà, à uwana masla akàl zagəla asà à waŋ kà maga­gamay la masla, uwana ada­nəŋəŋ atə̀ɗ à huma asik aŋha la magoɗal: “Məŋga, baŋa asa à ka kà, kaslala vok mawur gi ala!” ");
INSERT INTO mfh_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu abiyà ahàl ala, adəɓani masla la magoɗay: “Asa à gi, kawur ala!” Akàl zagəla asà à dza uwatà la vok ala katskats. ");
INSERT INTO mfh_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Aganay mafahal akur à lig, uwana Yesu afàhal à lig: “Kapəh gay uwanay à dza aw. Ama hàd, kadàpəhla vok aŋak à məŋga aŋa azlaməna mav tatak à Zəzagəla, ŋgaha kavà tatak uwana Musa apə̀h la wakità seriya la abà, kà azladza gesina aŋa masəlay kà kawùrla!” ");
INSERT INTO mfh_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Amiyaka bà la uwaga gesina kà, gay aŋa Yesu atsə̀nla la slaka azladza gesina. Maham à ahəŋ dza aŋuvaw tasàhàw à waŋ à slaka aŋha kà matsəɓal sləm, ŋgaha tawàràh ala la azla­ɗu­vats aŋatà la abà gesina. ");
INSERT INTO mfh_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ama Yesu asà à uda la tataka aŋatà la abà, adà aŋha à fəta à abà kokuɗa gəl aŋha, kà madəv kuɗa. ");
INSERT INTO mfh_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Iyay, vərdi anik aya, Yesu adzəkà mapàhla tatak ala. Azla Farisəya la azlaməna mapàhla wakità seriya ala tadzàhà madzay nekwa la slaka aŋha. Tasà à waŋ la gudəŋ aŋa Galili, la aŋa Yahu­diya ŋgaha babay la Uru­sa­lima. Ndzəɗa aŋa Sufəl Zəzagəla agà la Yesu la abà kà mawar azlaməna ɗuvats ala. ");
INSERT INTO mfh_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ŋgaha tasə̀lla masla ɗuvats à waŋ la kəslah, kà uwana makalàh à vəɗah gà, tayàh tetəvi kà madalla à gày kà maf à huma aŋa Yesu. ");
INSERT INTO mfh_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ama tasə̀l slaka uwana tagòla à awtày la abà aw, kà uwana maham à ahəŋ dza kà aŋuvaw. Kiya uwaga tagòla la gəl gày, tazlə̀lla gəl gày ala, tawàɗàh zuwiɗ à kəslah à gay, tadzilà à gày la abatà la kəslah gà, à tataka maham à ahəŋ dza à abà la huma aŋa Yesu. ");
INSERT INTO mfh_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mok uwana Yesu anəŋà madiŋal gəl à vok aŋa azladza uwaga, Yesu agòɗ à dza makalàh à vəɗah gà: “Tsakana aŋak ada­ma­tsila tsewwa.” ");
INSERT INTO mfh_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ŋgaha azlaməna mapàhla wakità seriya ala la azla Farisəya tadzəkà madzugway la magoɗay: “Uwa asla à tsəhay dza uwanay, atugw mawi­siga lakəl aŋa Zəzagəla uwa? Uwa aslala vok aŋa mamats tsakana à dza ala, tsa baŋa Zəzagəla kokuɗa gəl aŋha pəra aw uwa?” ");
INSERT INTO mfh_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Bokuba uwana Yesu asə̀l madzugway aŋatà, agòɗ à atà: “Mana kadzugwaw la maŋo­ŋuzay la ləv aŋkul la tsəh ma? ");
INSERT INTO mfh_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Tak ma, butu ma, la magoɗay kà: Tsakana aŋak ada­ma­tsila, awma magoɗay: Sà à afik, ŋgaha hàd aŋak, takay? ");
INSERT INTO mfh_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ama asa à gi kasəlaw kà, kà Kona aŋa dza la maslay la gudəŋ uwanay la vok kà mamats tsakana aŋa dza ala.” Ŋgaha agòɗ à dza makalàh à vəɗah gà uwaga: “Gi uwaga gəgoɗ à ka: Sà à afik, zə̀ɓ kəslah aŋak, ŋgaha dà aŋak à mtəga!” ");
INSERT INTO mfh_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kiya uwaga, hadzak, dza uwaga asà à afik la huma azladza gesina, azə̀ɓ kəslah aŋha uwana ahənay la afik, ŋgaha adà aŋha à mtəga la mazləɓ Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ləv avàlàh atà à gay gesina, ŋgaha tazləɓà Zəzagəla, guba akə̀ɗ atà à gay, ŋgaha tagòɗ: “Lakana kà, məda­nəŋəŋ azla­tatak dzəɓa aŋha səla aw gà, ndzer.” ");
INSERT INTO mfh_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","La lig aŋa uwaga la ahəŋ, Yesu asà à uda, ŋgaha anəŋà masla mazəɓ hadama, sləm aŋha Levi, adadza madzay la gày mazəɓ hadama la aku. ");
INSERT INTO mfh_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yesu agòɗal: “Nəfà à gi!” Hadzak, Levi asà à afik asàk azla­tatak à ahəŋ gesina, anəfà masla. ");
INSERT INTO mfh_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi atà magol tatak may la mtəga aŋha. Azladza aŋuvaw tahamà gay à vok la masla, azlaməna mazəɓ hadama, la azladza anik babay. ");
INSERT INTO mfh_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Azla Farisəya la azlaməna mapàhla mapəhay ala, uwana tagà la paŋaw tekula kà, azà à atà lakəl aŋa uwaga, tagòɗ à azlaməna matapla la slaka aŋha: “Kà mana kazuwaw la azlaməna mazaɓ hadama ma, ŋgaha kasaw la azladza uwana madz à ahəŋ aŋatà kà delga aw gà, la azlaməna tsakana ma?” ");
INSERT INTO mfh_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Uwana Yesu atsənà uwaga, agòɗ à atà: “Azladza uwana la ɗuvats aw kà, tanəkuɗa mad à dokwtar aw, say azla­uwana la ɗuvats pəra!” ");
INSERT INTO mfh_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ama agòɗ atà aya: “Gəsà à waŋ kà mazala azladza uwana azla­wurwur aw, ama gəsà à waŋ kà mazala azladza uwana atà la ɗuvats pəra, kà atà aŋa mapəh gay la ləv ala”, agòɗ. ");
INSERT INTO mfh_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ŋgaha azladza tagòɗal: “Azlaməna matapla la slaka Yuhana kà takà­sàhàh nəlay koksi­koksi, ŋgaha tadàv kuɗa, amiyaka aŋa azla Farisəya bay. Ama azlaaŋak kà: tazuway, tasay.” ");
INSERT INTO mfh_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ama Yesu agòɗ atà: “Madzugway aŋkul ma maf leri à azla­uwana à gəl tazala atà à mazəɓ vok à abà aŋa makəs nəlay à baŋa masla mazəɓ mis aləg la tataka aŋatà la abà kagoɗaw takay? Awaŋ, akəs vok aw. ");
INSERT INTO mfh_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ama kaslà adàsa à waŋ, à mok uwana masla mazəɓ mis adàgay la tataka aŋatà la abà aya aw kà, la mok uwatà la uwana tadàkas nəlay suwaŋ.” ");
INSERT INTO mfh_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu apə̀hatàla gay la gay la abà uwanay: “Dza la ahəŋ, akohəni lukut mawga kà matafay à lukut mavi­yaga à vok aw, baŋa aɗehəŋ kiya uwaga kà, awis lukut mawga ala, ŋgaha lukut mawga agay kalkal la lukut mavi­yaga babay aw. ");
INSERT INTO mfh_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ŋgaha aya babay kà, dza la ahəŋ aɗaway iyaw matavəruk mawga à kiwa iyaw mavi­yaga à agu aw. Baŋa aɗehəŋ kiya uwaga kà, mamslila aŋha kà, adàkwah kiwa mavi­yaga ala, ŋgaha iyaw matavəruk asokw à vəɗah, ŋgaha kiwa babay awis ala. ");
INSERT INTO mfh_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ama kəla kà, say taɗaway iyaw matavəruk mawga à kiwa iyaw mawga à agu suwaŋ. ");
INSERT INTO mfh_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Baŋa dza adasa iyaw matavəruk mavi­yaga kà, ayàh mas iyaw matavəruk mawga aya aw, kà uwana tagoɗ kà: ‘Maviya gà la uwana aɗuwa mawga la matsiɗay’, tagoɗ.” ");
INSERT INTO mfh_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Vərdi anik, la vuɗ maduw ləv Yesu aguwà à uda la guf nalkama la abà. (Uwana bokuba hi) Azlaməna matapla la slaka aŋha tadzəkà manal gəl gà, ŋgaha tavərə̀slàh kà mapaɗay kà uwana may azà à atà. ");
INSERT INTO mfh_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Azla Farisəya anik tagòɗ à atà: “Kà mana kaɗahaw tatak uwana tetəvi la ahəŋ aŋa maɗàh uwaga, la vuɗ maduw ləv aw ma?” ");
INSERT INTO mfh_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","“Kay”, Yesu agòɗ à atà: “Akul kà, kadzèŋàw tatak uwana David aɗahàŋ la mok uwana may akə̀s la azladza uwana tagà atà nna aw takay? ");
INSERT INTO mfh_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Masla, la azlaməna aŋha tahàd à gày Zəzagəla à agu, tazùw tatak may tsi­ka­slaga, uwana maf à ahəŋ gà kà aŋa Zəzagəla pəra. Te­ke­ɗika tetəvi la ahəŋ kà atà aŋa mazuway aw, say azlaməna mav tatak à Zəzagəla la uwana atà la tetəvi aŋa mazuway pəra.” ");
INSERT INTO mfh_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu agòɗ à atà aya: “Kona aŋa dza la uwana məŋga aŋa vuɗ maduw ləv uwaga.” ");
INSERT INTO mfh_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","La vuɗ maduw ləv anik aya, Yesu ahàd à gày madəv kuɗa anik à agu, ŋgaha adzəkà matapla azladza la abatà. Dza anik la ahəŋ la abatà, uwana ahàl kaf aŋha kà mamətsayga. ");
INSERT INTO mfh_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","La abatà kà, azlaməna mapàhla mapəhay ala, la azla Farisəya tatsə̀ɓ sləm à Yesu la manərəzay, à baŋa awur dza uwaga ala la vuɗ maduw ləv, kà atà aŋa maɓəzal à tsəh, kà mapuw ala gudzi à gəl kà uwana apesew vuɗ maduw ləv. ");
INSERT INTO mfh_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ama Yesu asə̀l madzugway aŋatà, kiya uwaga agòɗ à dza uwana la ahàl mamətsayga: “Sà à afik, tsìzlla à tataka à abà, la abà gà, la huma azladza gesina.” Dza uwaga asà à afik, ŋgaha atsìzlla à atà à huma à gay la abatà. ");
INSERT INTO mfh_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","“La kità”, Yesu agòɗ à atà: “Gi la manavay la slaka aŋkul: Mapəhay gami ma avà à anu tetəvi aŋa maɗàh delga la vuɗ maduw ləv takay, awma maɗàh mawi­siga ay? Maɓəl sifa aŋa dza, awma maz sifa aŋa dza ala, la uwana delga takay?” ");
INSERT INTO mfh_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Atà gesina tatsə̀kal yewdi à gay, kiya uwaga Yesu agòɗ à dza uwaga: “Biyà ahàl ala!” Abiyà ahàl ala, ŋgaha ahàl ada­wur ala. ");
INSERT INTO mfh_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ama azla Farisəya la azlaməna mapàhla mapəhay ala tahə̀n ala la maŋor, ŋgaha la mapakàh ləv, ŋgaha tadzəkà mabay vok gay kà atà kà atà lakəl aŋa uwana asà à atà maɗehəŋ à Yesu à vok. ");
INSERT INTO mfh_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","La kaslà uwatà, Yesu ahàd à dadəgwal à afik kà madəv kuɗa la abatà, huyip ahə̀n à madəv kuɗa à gəl, adə̀v kuɗa à Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mok uwana məl adawulla, azàla azlaməna asik aŋha, ŋgaha atsa­tsà­mànì kulo gəl aŋha səla, uwana apakàtàla kà azlaməna matapla la slaka aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Səmon (uwana avàl sləm Piyer bay) la deda aŋha Andəre, Yakuba, Yuhana, Filip, Barte­lemi, ");
INSERT INTO mfh_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mata, Tomas, Yakuba kona aŋa Alfe, Səmon uwana tazàlal Zəlot, ");
INSERT INTO mfh_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas kona aŋa Yakuba, ŋgaha Yudas Iska­riyot, uwana apaka masla məzam aŋa Sufəl Yesu. ");
INSERT INTO mfh_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu asà à ahəŋ la dadəgwal la afik atà nna, ŋgaha asà à vada­vaday à afik, kà uwana azlaməna asik aŋha aŋuvaw la abatà. Azlaməna kutso Yahu­diya, la azlaməna gudəŋ Uru­sa­lima ŋgaha azla­uwana la makəla aŋa gudəŋ Tir, la Sədon uwana la gay mukwà, atà gesina la abatà. ");
INSERT INTO mfh_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tasàhà à waŋ kà matsəɓal sləm, ŋgaha kà atà aŋa mawarla la azla­ɗu­vats aŋatà la abà. Azla­uwana tasà ŋgərpa la ahàl aŋa azla­ma­sasəɗok mawi­siga babay kà, tawarà ala. ");
INSERT INTO mfh_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Dèwdèw dza tayàh kà madəɓani Yesu, kà uwana ndzəɗa asahàh à uda la masla la abà, awàràhà atà ala gesina. ");
INSERT INTO mfh_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu anərə̀z azlaməna matapla la slaka aŋha agòɗ: “Marabay agay la akul uwana azlaməna kuɗa lagwa, kà uwana makoray Zəzagəla kà adàgay kà aŋkul. ");
INSERT INTO mfh_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Marabay agay la akul uwana may az akul lagwa, kà uwana kadà­ɓəzawwal tatak may sakay sasakay. Marabay agay la akul uwana katuwaw lagwa, kà uwana kadà­kəɗaslaw. ");
INSERT INTO mfh_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Marabay agay la akul à baŋa azladza tapəsew akul, takweska akul, tatsək à akul mago­ɗahay à gəl, ŋgaha tatərəɓ akul la mawi­siga, kà Kona aŋa dza. ");
INSERT INTO mfh_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ràbàw la vuɗ uwaga, ŋgaha vàlàhàw à zagəla kà uwana masik məŋga akud akul la zagəla, kiya uwaga à uwana azla­baba aŋkul madzi­dziga tatərə̀ɓàhà azlaməna mapəh à atà gay à ahàl uwarà. ");
INSERT INTO mfh_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ama ŋgərpa agay la akul, akul azla­go­robu, kà uwana kada­zuwwaw. ");
INSERT INTO mfh_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ŋgərpa agay la akul, akul uwana kakoraw tatak sakay sasakay lakana, kà uwana may la uwana adàkaɗ akul. Ŋgərpa agay la akul uwana kada­kəɗaslaw lakana, kà uwana bawbaw kà, kadàgaw la mazaw la gəl la abà, ŋgaha kadà­gahaw la iyaw tugwi la adi. ");
INSERT INTO mfh_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ŋgərpa agay la akul à baŋa azladza gesina tasləkaw akul, kà uwana kiya uwaga la uwana, azla­baba aŋkul madzi­dziga taɗa­hàhàŋ la azlaməna mapəh à atà gay à ahàl fidaga.” ");
INSERT INTO mfh_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ama gəpəh à akul, akul uwana katsəɓaw gi sləm: Wòyàw azlaməna məzam aŋkul, ɗahàw delga à azladza uwana tapəsew akul. ");
INSERT INTO mfh_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pìsàw gay à azla­uwana à vok, tatsafla akul, də̀vàw kuɗa kà aŋa azla­uwana tatərəɓ akul. ");
INSERT INTO mfh_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Baŋa dza adeɗka à paŋaw à abà, gòlla anik uwanay à awtày aya, baŋa dza ahə̀l dawara aŋak kà, sàkal ahəl bəzi aŋha aya babay. ");
INSERT INTO mfh_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kəla dza uwana anav à ka tatak kà, vàl, baŋa dza azəɓ à ka tatak ala la gasa kà, kapùwla gudzi à gəl aw. ");
INSERT INTO mfh_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tatak delga uwana asa à akul azladza taɗa­ha­kulaŋ kà, ɗahàwàŋ à azladza anik bokuba uwaga suwaŋ kəla.” ");
INSERT INTO mfh_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Baŋa kawo­yawwaŋ kà azladza uwana tawoya akul pəra ma, kà mana kakudaw masik anik aya ma? Kà uwana bà azlaməna tsakana babay kà, tawoya azla­uwana tawoya atà babay suwaŋ pəra. ");
INSERT INTO mfh_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ŋgaha baŋa kaɗa­hawwaŋ delga kà azla­uwana taɗa­ha­kulaŋ delga pəra ma, kà mana kakudaw masik anik aya ma? Amiyaka azlaməna tsakana kà, kiya uwaga à uwana taɗehəŋ babay. ");
INSERT INTO mfh_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Baŋa kakəllaw goder à dza uwana kasəlaw, kà adàpəlay ma, kà mana kakudaw masik anik aya ma? Azlaməna tsakana babay kà, takal vok goder, ŋgaha atà aŋa mavàh vok aŋatà suwaŋ, kità ma: Uwa adàvà akul masik aya zlà ma uwa? ");
INSERT INTO mfh_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ama kəla kà: Wòyàw azlaməna məzam aŋkul, ŋgaha kə̀làw atà goder la kokuɗa madzugway kà mawul akul ala. Kiya uwaga kà, kadàɓəzaw à masik məŋga la slaka Baba uwana kərkər la afik, ŋgaha kadàgaw azlabəza aŋha. Kà uwana masla kà dziriga la huma aŋa azlaməna tsakana la azlaməna makəsa­fər gesina. ");
INSERT INTO mfh_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Hə̀nàwla, la delga ŋgaha la vok mahamay, bokuba Baba aŋkul uwana adahənla la dzəɓa aŋha səla aw.” ");
INSERT INTO mfh_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kaɗahaw seriya à azladza anik à gəl aw, ŋgaha Zəzagəla adà­ɗa­ha­kulla seriya à gəl suwaŋ aw; kaɗəkaw seriya à azladza à gəl aw, ŋgaha Zəzagəla adà­ɗəka­kulla seriya à gəl suwaŋ aw, matsawaŋ azladza anik ala, ŋgaha Zəzagəla adà­ma­tsa­kul­laŋ ala suwaŋ. ");
INSERT INTO mfh_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Vàw à azladza anik, ŋgaha Zəzagəla adàvà à akul: Zəzagəla adàtsak akul à zliba aŋkul à agu tsəŋ tsətsəŋ, tadà­ha­tsəkwəŋ la maɗəkwəŋ se­ra­faffa. La daram uwana kagu­rawla à azladza anik kà, uwaga la la uwana tadàgur à akul ala suwaŋ.” ");
INSERT INTO mfh_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu apə̀h à atà gay la gay la abà anik, agòɗ à atà: “Guləf aslala vok aŋa makəs guləf anik à ahàl takay? Awaŋ, atà səla nna tadà­sakway à afək à abà. ");
INSERT INTO mfh_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Masla matapla aɗuw masla mata­palla aw, ama baŋa adàdəv matapla madzeŋay aŋha à gay kà, aslala vok aŋa magay bokuba masla.” ");
INSERT INTO mfh_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Kay, kà mana kanəŋa kəsaf la yewdi aŋa deda aŋak la awtày, ama aŋak uwana magol tsəkuɗ tsəkuɗ la awtày kà, kanəŋa aw ma, kà mana ma? ");
INSERT INTO mfh_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ŋgaha kagoɗay à deda aŋak: ‘Deda, sàk à gi, gəzəɓ à ka kəsaf la adi ala’. Kak, la gəl aŋak kà, kanəŋà magol tsəkuɗ tsəkuɗ uwaga la aŋak la awtày aw ma? Kak, masla magolla dza, zə̀ɓ aŋak la adi ala dadàŋ, ŋgaha la lig la ahəŋ kà, kadànəŋla lela kà mazəɓ kəsaf à deda aŋak la adi ala, la dziriga.” ");
INSERT INTO mfh_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ahàf delga kà avà mayyay mawi­siga aw, ahàf mawi­siga babay kà, aslala vok aŋa mav mayyay delga aw. ");
INSERT INTO mfh_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Iyay, kəla ahàf kà agay masəlayga la mayyay aŋha la vok. Dza aslala vok aŋa madəzl gudəv la matatàk la vok aw, ŋgaha bay, dza adəzl matavəruk la mazləɓ la vok aw. ");
INSERT INTO mfh_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Dza delga kà, aɗehəŋ kà delga, kà uwana, uwana la ləv aŋha la tsəh kà delga. Dza mawi­siga kà, aɗehəŋ kà mawi­siga, kà uwana uwana la ləv aŋha la tsəh kà mawi­siga. Kà uwana paŋaw aŋa dza kà, apəhay kà uwana la ləv aŋha la tsəh.” ");
INSERT INTO mfh_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Kà mana kazalaw gi ala: Sufəl, Sufəl, ŋgaha tsa kaɗahaw tatak uwana gəpəh à akul aw ma? ");
INSERT INTO mfh_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kəla uwa­be­yuwi uwana atsa à waŋ à slaka gulo ŋgaha atsəɓ sləm à kuda gulo kà, gəpəhakulla dza uwana gəga­gazləla la masla. ");
INSERT INTO mfh_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Masla kà kalkal la dza uwana atatukw mata­tukway aŋa gày aŋha kà à təhus à afik. Mok uwana iyaw adàdzəka mas à afik, akəl la lig gày, afaɗ aɗə̀ɗ la ndzəɗa, ama gày kà akalàh à ahəŋ aw, kà uwana tatətùkw kà à təhus à afik. ");
INSERT INTO mfh_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ama dza uwana atsəɓ sləm à gay gulo, ŋgaha akəs uwaga aw kà, masla kà gəga­gazləla kà la dza, uwana aŋal gày à wuyyaŋ à afik. Mok uwana iyaw mukwà adàda à mukwà à afik, azəɓ gày uwaga gesina, adalla.” ");
INSERT INTO mfh_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Mok uwana Yesu adadəv gay aŋha à gay la huma aŋa maham à ahəŋ dza, atsìzlla ala la abatà, ahàd à Kaper­nahum. ");
INSERT INTO mfh_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Məŋga aŋa azla­slodzi aŋa azla Rom la ahəŋ la abatà. Magamza aŋha uwana awoyàŋ kaykay, aga la ɗuvats, agà kà la ləv la ləv. ");
INSERT INTO mfh_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mok uwana məŋga aŋa azla­slodzi atsənà gay uwana tapahay lakəl aŋa Yesu kà, masla aslə̀l azla­ma­siga anik la tataka azla Yahu­diya la abà, kà madəv kuɗa à Yesu kà mas à waŋ aŋa mawur magamza aŋha ala. ");
INSERT INTO mfh_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kiya uwaga, mok uwana tabə̀z à slaka Yesu, tadə̀val kuɗa la kamkam la iyaw tugwi, ŋgaha la magoɗay: “Dza uwanay kà, azlayla kà vok kà kazlakay, ");
INSERT INTO mfh_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kà uwana masla kà awoyà tsəhay gami, ŋgaha aya, masla la uwana aŋàl anu gày madəv kuɗa gami aya.” ");
INSERT INTO mfh_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kiya uwaga Yesu anəfà atà, ŋgaha mok uwana tada­zla­bəz kà mtəga, məŋga aŋa azla­slodzi uwaga aslə̀l azla­ma­nalay aŋha kà magoɗal: “Madza­haga katərəɓ gəl aŋak aw, kà uwana gəsla kà kak aŋa makəl gəl à ahəŋ kà mas à gày gulo à agu aw. ");
INSERT INTO mfh_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kà uwaga, gi babay la gəl gulo kà, gənərə̀z kà, gəslà kà mad à awtày à slaka aŋak la gəl gulo aw. Ama pə̀h gay tekula la tsəh ala pəra kà kona gulo aŋa mawurla. ");
INSERT INTO mfh_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gi babay kà azlaməŋga la ahəŋ lakəl gulo, gi babay, gi lakəl aŋa azla­slodzi anik suwaŋ. Ŋgaha gəslala vok magoɗay à tekula aŋatà: Hàd, kà aday. Gəgoɗay à anik aya: Sà à waŋ kà, atsa à waŋ, ŋgaha bay gəgoɗay à masla sləray gulo: Ɗahàŋ uwanay kà, aɗehəŋ bay.” ");
INSERT INTO mfh_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Mok uwana Yesu atsənà gay uwaga, awoyà masla kaykay, agòla vok, ŋgaha agòɗ à maham à ahəŋ dza uwana tanəfà la tsəh: “La dziriga gəpəh à akul: Gəda­nəŋəŋ didi­didi à tsəhay madiŋal gəl à vok uwanay, amiyaka bà la Isərayel aw.” ");
INSERT INTO mfh_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Azlaməna sləray aŋa məŋga aŋa azla­slodzi tawùl à mtəga, ŋgaha taɓə̀z à magamza uwaga à gəl, kà ada­wur ala. ");
INSERT INTO mfh_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ŋgaha Yesu ahàd à gudəŋ anik uwana à abà, sləm aŋha Nayyin, la azlaməna matapla la slaka aŋha, ŋgaha maham à ahəŋ dza aŋuvaw tanəfà masla. ");
INSERT INTO mfh_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kiya uwaga mok uwana tazlà­bə̀z à gay gamagày aŋha huɗ gudəŋ, tagagàm la azladza uwana tazə̀ɓ mazim­nekiɗ à uda. Uwaga bəzi tekula gà aŋa mis kuɗa, uwana anik aŋha la ahəŋ aw. Maham à ahəŋ dza aŋa gudəŋ uwaga gesina tagà la slaka mis uwaga. ");
INSERT INTO mfh_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mok uwana Sufəl Yesu anəŋà mis uwaga vok ahamàl: “Katùw aw”, agòɗal. ");
INSERT INTO mfh_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ŋgaha Yesu azà vok à slaka mazim­nekiɗ, adəɓanì azlav aŋha. Azlaməna mazəɓay tatsìzlla à ahəŋ, Yesu agòɗ: “Kohana, sà à afik, gəgoɗ à ka!” ");
INSERT INTO mfh_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kiya uwaga mazim­nekiɗ atsìzlla ala, ŋgaha adzəkà mavats gay. La lig la ahəŋ Yesu awùlla à iyà aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","La abatà ləv avàl à azladza à gay gesina, tazləɓà Zəzagəla la magoɗay: “Magol masla mapəhal gay à ahàl aŋa mapàh azladza adapəhla vok ala la tataka gami la abà lakana. Zəzagəla la gəl aŋha adasa à ahəŋ kà mazlak tsəhay aŋha lakana.” ");
INSERT INTO mfh_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ŋgaha gay aŋa Yesu uwaga atsə̀n la kutso Yahu­diya la abà gesina la kutso uwana la makəla aŋha gesina. ");
INSERT INTO mfh_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Kiya uwaga azlaməna matapla la slaka aŋa Yuhana tapə̀h uwaga gesina aŋatà à məŋga aŋatà. Yuhana azàl azladza səla la tataka aŋatà la abà, ");
INSERT INTO mfh_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ŋgaha aslə̀lla atà à slaka Yesu kà manaval à gay ala: “Kak, ma kak dza uwana məkud kà aŋa mas à waŋ takay? Awma məkud dza anik kəla ay?” ");
INSERT INTO mfh_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Mok uwana tabə̀z à slaka Yesu, tagòɗal: “Yuhana, masla maɗàh batem, aslə̀l anu à waŋ kà manav à ka: ‘Kak, ma kak dza uwana məkuday kà aŋa mas à waŋ takay, awma məkud dza anik ay?’ ” ");
INSERT INTO mfh_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","La kaslà uwatà, Yesu awarà azladza ala aŋuvaw, la azla­ɗu­vats aŋatà la abà, ŋgaha la azla­mazay vok aŋatà la abà, apàlla atà ala la ndzəɗa aŋa azla­ma­sasəɗok mawi­siga la abà, ŋgaha avàh yewdi à azla­gu­ləf aŋuvaw. ");
INSERT INTO mfh_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kiya uwaga awùlla gay à azlaməna masləl atà à waŋ gà aŋa Yuhana: “Dàw, kadàpəhaw à Yuhana uwana kanəŋàwwàŋ la uwana katsənàwwàŋ: ˈAzla­gu­ləf tanəŋla, azla­deri taday, azlaməna akàl zagəla tawarla, azla­ma­da­gazlam tatsən sləm, azla­ma­zim­nekiɗ tawul à uda la mamətsay. Ŋgaha gay matsi­ɗayga babay adatsən à azlaməna kuɗa.ˈ ");
INSERT INTO mfh_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Marabay agay la dza, uwana asak gi à tsəh ala la madiŋal gel à vok la abà aw!” ");
INSERT INTO mfh_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Mok uwana azlaməna matapla la slaka Yuhana tadìy aŋatà, Yesu adzəkà mapəhay à maham à ahəŋ, dza lakəl aŋha la magoɗay: “Mana à uwana kadàw kà mayahay la fəta la abà ma? Mazuwa uwana afaɗ aɓəla­kəŋ ay? Awaŋ, uwaga aw. ");
INSERT INTO mfh_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kətà zlà ma: Mana à uwana kadàw aŋa manəŋəŋ zlà ma? Dza uwana atsàkwàh à lukut mahəɗayga à abà kəla ay? Azla­uwana tatsàkwàh à lukut mahəɗayga à abà kà, atà kà azla­su­fəl. Ŋgaha tadzà à ahəŋ la huɗ gày sufəl. ");
INSERT INTO mfh_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kətà zlà ma: Mana kadàw kà aŋa manəŋəŋ ma, masla mapəhal gay ahàl aŋa Zəzagəla kəla ay? Iyay, gəgoɗ à akul: amiyaka adagay masla mapəhal gay à ahàl babay kà, ");
INSERT INTO mfh_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","haɗay, Yuhana kà masla kà dza uwana matse­tseray apəh lakəl aŋha: ˈ‘Aganay gəsləl masləlay gulo à awtày à huma aŋak,’ Zəzagəla agoɗ: ‘Kà masla aŋa mapəslak tetəvi.’ˈ” ");
INSERT INTO mfh_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“La dziriga gəpə̀h à akul: La tataka azladza asik la abà, agà la ahəŋ dza uwana agà bokuba Yuhana masla maɗàh batem uwanay aw; te­ke­ɗika, dza uwana mabəziga bəziga la makoray Zəzagəla kà, aɗuwa Yuhana uwanay lagwa.” ");
INSERT INTO mfh_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Maham à ahəŋ dza gesina la azlaməna mazəɓ hadama tatsə̀ɓ sləm à masla, atà gesina tagəɗàŋ à afik kà Zəzagəla kà dziriga. Atà taɓəzàl batem la slaka Yuhana. ");
INSERT INTO mfh_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ama azla Farisəya la azlaməna mapàhla mapəhay ala, takweskà tatak uwana asà à Zəzagəla kà maɗàh à atà à ahəŋ kà aŋatà, kà uwana takweskà batem aŋa Yuhana. ");
INSERT INTO mfh_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu agòɗ aya: “Lagwa ma, la mana gəgazləla azladza aŋa zamana aŋa lakana uwanay ma? La mana atà tadəɓani vok lagwa ma? ");
INSERT INTO mfh_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Haɗay, atà gəga­gazləla atà la azlabəza uwana tadzàh madzay la vada­vaday kasukwa la afik. Tazàlàh vok, kà atà kà atà la magoɗay: Anu mətsà à akul talakwoy, ama akul kahà­bàwal à tsəh aw. Məhàb à akul dəs kuɗa, ama katàwàw la mats hulolo aw. ");
INSERT INTO mfh_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ŋgaha aya Yuhana masla maɗàh batem azlaŋal, azùw kaf aw, ŋgaha asàh iyaw matavəruk aw, ŋgaha kagòɗàw aya kà: ‘Masla la masasəɗok mawi­siga.’ ");
INSERT INTO mfh_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kità aya, Kona aŋa dza azlaŋàl, azuway, asay, ŋgaha kagoɗaw kà: ‘Nərə̀zàw dza uwanay tsi: Masla huɗ’, kagoɗaw. ‘Afa sləm kà à mazuway la masay aŋha pəra. Kafàw masla kà à tataka aŋa azlaməna mazəɓ hadama abà, la azlaməna tsakana, ŋgaha la azladza uwana madz à ahəŋ aŋatà kà lela aw.’ ");
INSERT INTO mfh_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ama matsi­hila aŋa Zəzagəla apəhla masla ala la slaka azladza gesina kà makəs masla.” ");
INSERT INTO mfh_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Zil Farisəya anik azàla à Yesu kà mazuw tatak may la mtəga aŋha. Yesu ahàd à mtəga aŋa zil uwatà, adzà à tatak may à adi. ");
INSERT INTO mfh_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mis masla tsakana agà la gudəŋ uwatà la abà. Mok uwana atsənà, kà Yesu la tatak may la adi la mtəga aŋa zil Farisəya uwaga kà, asə̀lla amàl matərsin à waŋ wuf la dərew gà. ");
INSERT INTO mfh_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mis atsìzl à makəla asik aŋa Yesu la matuway, aləɓà asik aŋa Yesu la iyaw tugwi, ŋgaha asla­slàɗàŋ ala la aŋidz gəl aŋha, ŋgaha ahə̀l asik aŋa Yesu à təkul à abà kà madza­dzaɓal amàl matərsin à gəl. ");
INSERT INTO mfh_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mok uwana zil Farisəya uwana azàla Yesu, anəŋà uwaga kà, agòɗ la gəl aŋha kà: ‘Ndzer kà, agayŋa zil uwanay, agay masla mapəhal gay à ahàl kà mapàh à azladza kà, naka asəl mis uwanay kà masla tsakana gà.’ ");
INSERT INTO mfh_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu agòɗ à zil Farisəya: “Səmon, gi la gay anik kà mapəh à ka!” Səmon agòɗal: “Məŋga, pə̀h!” ");
INSERT INTO mfh_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ŋgaha Yesu agòɗ: “Tsənàŋ lela: Dza anik la ahəŋ uwana avà goder sili à azladza səla, anəfà dza anik la gursu dadərmokw zlo, ŋgaha la slaka dza anik aya, gursu dzik zlo. ");
INSERT INTO mfh_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Uwana taɓə̀z à tatak kà mapəlla aya aw, asàk à atà ala goder aŋha la vok. Ŋgaha ma, dza uwala à uwana awoyàŋ kaykay la?” ");
INSERT INTO mfh_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Səmon agòɗal: “Gi kà, gədzugw kà, dza uwana gursu dadərmokw zlo la vok, kà masla la uwana ‘Kikay’, agoɗay kaykay.” Yesu agòɗal: “Iyay, azlayla kà.” ");
INSERT INTO mfh_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesu agòla à huma à slaka mis la magoɗ à Səmon: “Səmon, kanəŋa mis uwanay ay? Gi la kay aŋak, bà iyaw bay, kà katəɗəgəŋ kà mapal asik gulo aw, ama masla kà alə̀ɓ à gi asik gulo la iyaw tugwi aŋha, ŋgaha aya la aŋidz gəl aŋha la uwana asla­slàɗgə̀ŋ ala. ");
INSERT INTO mfh_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kak, kakə̀s gi la ahàl səla aw, ama masla kà akə̀s gi la ahàl səla. Dagay uwana gəsà à gày kà akəsà à asik gulo, kà uwana awoyà gi. ");
INSERT INTO mfh_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kak, kaɗàh à gi à amàl à gəl aw, ama masla kà adzadzàɓ à gi matərsin à asik. ");
INSERT INTO mfh_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kà uwaga à uwana gəgoɗ à ka: Kà magol masal məŋga uwaga apəhla ala kà, maham à ahəŋ tsakana aŋha kà ada­ma­tsila, suwaŋ. Ama aŋa dza uwana tamà­tsàlàŋ ala ŋuv kà, masal aŋha suwaŋ kà ŋuvga babay.” ");
INSERT INTO mfh_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kiya uwaga Yesu agòɗ à mis: “Tsakana aŋak adamats ala.” ");
INSERT INTO mfh_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Azladza uwana la tatak may la adi atà nna, tadzəkà maŋo­ŋuzay: “Uwa asla dza uwaga, aslala vok aŋa mamats tsakana à dza ala uwa?” ");
INSERT INTO mfh_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ama Yesu agòɗ à mis: “Madiŋal gəl à vok aŋak adaɓəl ka, hàd la wurwur!” ");
INSERT INTO mfh_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","La lig aŋa uwaga la ahəŋ, Yesu adàh à azla­gu­dəŋ à abà la azlahuɗ gudəŋ, azahà gay matsi­ɗayga aŋa makoray Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Azlaməna matapla la slaka aŋha kulo gəl aŋha səla uwatà, la azlamis anik anik, uwana ada­palàh atà ala la azla­ma­sasəɗok mawi­siga la abà, ŋgaha la azla­ɗu­vats anik anik la abà, atà gesina tanəfà, Mari­yama, dəg zla Magdala, uwana akuɗə̀kal azla­ma­sasəɗok mawi­siga məɗəf lakəl ala, ");
INSERT INTO mfh_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ŋgaha Yohana mis aŋa Kuza, vazaray aŋa sufəl Herod, Suzan la azlamis anik aŋuvaw uwana tazlàk Yesu la azlaməna matapla la slaka aŋha, la ləmana aŋatà. ");
INSERT INTO mfh_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Azladza gudəŋ anik, anik gesina tasàhà à waŋ, tahamà gay à vok la slaka aŋha, ŋgaha apə̀h à atà gay la gay la abà uwanay: ");
INSERT INTO mfh_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Masla maslək tatak asà à uda, kà mad maslək hi. La mok uwana aslə̀k hi uwaga la guf aŋha la abà, azla­fo­fulo anik anìs à tetəvi à ama. Tafàhal asik à gəl ŋgaha azla­ɗiyaŋ tasà à waŋ, tazùw à gay. ");
INSERT INTO mfh_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Azlaanik aya anìs à pala akur à afik, bokuba uwana kutso la pala akur lakəl məŋga aw, hi asà à uda katskats, ŋgaha uwaga agùl ala katskats, kà uwana kutso la pala akur lakəl məŋga aw. ");
INSERT INTO mfh_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Gotənaŋ fofulo anik anìs à atàk à abà, asà à uda, ama bokuba uwana tazigənay la slaka gà, atàk akə̀ɗ à tsəh. ");
INSERT INTO mfh_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Bà gotənaŋ fofulo anik aya anìs à kutso delga à abà, uwaga asà à uda, azigə̀n, atsà gəl lela, ŋgaha tavà mayyay lela, anik ayyà à adi huməts, anik aya ayyà à adi zuŋ, ŋgaha anik ayyà à adi zazuŋ səla.” Mok uwana Yesu adakəɗ gəl à mapəh gay aŋha, agòɗ à atà la maza­tàlaŋ à gəl: “Tsə̀ɓàwwal sləm lela, à baŋa sləm aga à akul lakəl!” ");
INSERT INTO mfh_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Azlaməna matapla la slaka aŋha tanàv godega aŋa gay la gay la abà uwatà. ");
INSERT INTO mfh_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu agòɗ à atà: “Akul kà, kaɓə̀zàw nasiri aŋa masəl godega aŋa wakità Zəzagəla. Ama kà aŋa azladza anik kà, apəhatàla kà la gay la gay la abà pəra: ˈKà atà aŋa manəŋəŋ, ama bokuba tanəŋaŋ aw, kà atà aŋa matsənəŋ ama bokuba tatsənaŋ aw.ˈ” ");
INSERT INTO mfh_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Aganay godega aŋa gay la gay la abà uwanay: Fofulo kà gay Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Azladza anik məpakatàla bokuba tetəvi uwana hi anìsal à ama: Atà tatsə̀ɓ sləm à gay, ama katskats seteni asa à waŋ, aɓəɗ à gay uwaga la ləv aŋatà la tsəh, kà atà aŋa madiŋal gəl à vok kà maɓəlay aw. ");
INSERT INTO mfh_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Azlaanik aya kalkal la pala akur uwana fofulo anìs à afik. Tatsə̀ɓ sləm à gay, takə̀s la marabay katskats, ama tasakal adala slilih la atà la abà la lela aw. Tadiŋal gəl à vok kà aŋa kaslà ŋuv pəra, la mok uwana azlaŋ­gərpa tadzahka vok kà, takweska madiŋal gəl à vok la katskats. ");
INSERT INTO mfh_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Fofulo uwana anìs à atàk à abà aya kà, apəhla azla­uwana ala tatsəna gay Zəzagəla, takəs, ama madzugway la adi aŋa gudəŋ à vok uwanay, la matsiɗay aŋha, la mapa­patay aŋha lakəl aŋa ləmana, asufa gay uwanay ala la ləv aŋatà la tsəh, ŋgaha ahən aw. ");
INSERT INTO mfh_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Fofulo uwana anìs à kutso delga à abà kà, apəhla azla­uwana ala tatsəɓ sləm à gay, ŋgaha takəs uwaga la ahàl səla ŋgaha la ləv tekula, ŋgaha tatsizlla gay uwaga à afik, kiya uwaga tahən lela.” ");
INSERT INTO mfh_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesu agòɗ: “Dza avats fənəs kà maf à tsəh tasà takay, awma kà maf à tsəh gogozlàh takay? Awaŋ, tafay kà à slaka dzəgamma gà, kà azladza uwana tada à gày aŋa manəŋ uɗaka aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Dèwdèw tatak mahaɗəŋ à ahəŋ gà kà, adàpəhla vok ala, ŋgaha dèwdèw tatak nasiri gà, adàgay masəlay gà, adàpəhla vok ala la dazu­waya la afats kà manəŋəŋ aŋa azladza. ");
INSERT INTO mfh_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ɗahàw haŋkəli la kaykay à uwana katsənawwaŋ! Kà uwana tavày məŋga à dza à uwana la tatak, ama kà tazəɓallaŋ ala à abà bəziga gà à uwana adzugw maɓəzal babay.” ");
INSERT INTO mfh_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iyà la azla­deda aŋa Yesu tahàd à slaka aŋha, ama taɓə̀zal à vok aw, kà uwana maham à ahəŋ dza aŋuvaw. ");
INSERT INTO mfh_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ŋgaha tapə̀h à Yesu: “Iyà la azla­deda aŋak la uda, tayàh ka, asa à atà manəŋ ka”, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","“Iyà la azla­deda gulo kà azla­uwana tatsəna gay Zəzagəla, ŋgaha la maɗehəŋ, la uwana azla­deda gulo la iyà gulo pəra”, Yesu agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Vərdi anik kà, Yesu ahàd à kəslah iyaw à afik la azlaməna matapla la slaka aŋha, agòɗ à atà: “Məguwà la gay dərəv à uda anik”, ŋgaha tahàd. ");
INSERT INTO mfh_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Uwana tagà la kəslah iyaw la afik kà, Yesu adzehàl. Katskats magol kular adzəkà vok la ndzəɗa lakəl iyaw, kəslah iyaw ahə̀n ala la magan­tsay aŋa iyaw uwana adàhà à abà, ŋgaha atà kà, tagà la zlamtsa la abà. ");
INSERT INTO mfh_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kiya uwaga azlaməna matapla tazà vok à slaka aŋa Yesu tatsənàŋ ala la magoɗal: “Məŋga, məŋga, məzlàmamətsay, zlàk anu!” Hadzak, Yesu asà à afik ŋgaha aslə̀h məlo à kular à gəl la magan­tsay ana iyaw, ŋgaha tadzà à ahəŋ titi. ");
INSERT INTO mfh_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ŋgaha Yesu agòɗ à azlaməna matapla la slaka aŋha: “Aŋala madiŋal gəl à vok aŋkul la?” Ama guba akə̀s atà, ləv avàl atà à gay, ŋgaha tagòɗ à vok kà atà kà atà: “Tsəhay dza uwala à uwanay la? Amiyaka kular, la magan­tsay aŋa iyaw babay kà tasəl masla, ŋgaha takəsal gay la ahàl ala!” ");
INSERT INTO mfh_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","La lig la ahəŋ gesina aŋatà tabə̀z à gay dərəv à uda aŋa gay dərəv aŋa Galili, uwana la kutso aŋa Ge­ra­səniya la abà. ");
INSERT INTO mfh_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Batsàrà uwana Yesu atsà à vəɗah la kəslah iyaw la afik, dza anik asà à waŋ la huɗ gudəŋ la abà kà maga­gamay la masla. Dza uwatà kà zagəla zagəla lakəl, ada­safay kà atsakwah à lukut abà aw, ahanay la gày la aku babay aw, la azla­ma­buwaŋ zəvay la aku pəra. ");
INSERT INTO mfh_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mok uwana anəŋà Yesu, awiyà la ndzəɗa ŋgaha atə̀ɗ à makəla asik aŋha la magoɗay: “Mana kayahay la slaka gulo ma? Yesu Kona aŋa Zəzagəla uwana kərkər la afik. Kamkam gədəv à ka kuɗa, kasa à gi ŋgərpa aw gəgoɗ à ka!” ");
INSERT INTO mfh_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Uwana apə̀h uwaga kà, kà uwana Yesu afà gay à masasəɗok mawi­siga uwaga à gəl, kà masal à kəl ala. Zagəla zagəla uwaga adahal à gəl zwek zwek. Aŋuvaw tawa­ɗe­həŋ à ahəŋ la azla­ma­za­kazak ada, aslàhàh ala la manalàh ada ala, kà matəf à fəta. ");
INSERT INTO mfh_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kiya uwaga Yesu anàval gay ala la magoɗal: “Uwa à sləm aŋak uwa?” Masla awùlla à uda agòɗ: “Sləm gulo kà: Maham à ahəŋ.” Kà uwana azla­zagəla zagəla kà atà aŋuvaw tahamàl à gəl. ");
INSERT INTO mfh_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Azla­zagəla zagəla uwaga tadə̀v kuɗa à Yesu kà mawits atà à afək zəŋzəŋga à abà aw. ");
INSERT INTO mfh_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Maŋəla­ŋəl namzi la ahəŋ la abatà tapàɗ awul la madəguruh la afik. Azla­zagəla zagəla uwaga tadə̀v kuɗa à Yesu, kà masla masləlla atà à azla­namzi uwatà à abà. Yesu avà à atà tetəvi: “Dàw à atà à gəl!”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kiya uwaga azla­zagəla zagəla uwaga, tasà à dza uwaga lakəl ala, tahàd à azla­namzi à gəl. Kiya uwaga maŋəla­ŋəl namzi uwaga tahòy à ahəŋ la madəguruh la afik, ŋgaha tatsàh gəl à iyaw à abà, tasufàh à abà. ");
INSERT INTO mfh_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Uwana azlaməna manəŋla azla­namzi tanəŋà uwaga apakà vok, tahòy anatà, tahàd kà mapàh azlagay uwaga à azladza huɗ gudəŋ gesina, la azladza uwana la azlabəza gudəŋ la abà babay. ");
INSERT INTO mfh_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Azladza tasà à uda la gudəŋ la abà gesina kà maday manəŋ tatak uwana apakà vok, ŋgaha tasà à waŋ à slaka Yesu, taɓəzà dza uwaga à gəl azla­zagəla zagəla tasàl à kəl ala. Adadza madzay la makəla aŋa Yesu, masla adatsokw lukut à vok, haŋkəli aŋha babay kà delga. Azladza uwana tanəŋàŋ gesina kà, ləv avàl atà à gay kà masla. ");
INSERT INTO mfh_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Azladza uwana tanəŋàŋ mawurla aŋha, tapàh godega aŋa mawurla aŋha à azladza uwatà. ");
INSERT INTO mfh_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ŋgaha maham à ahəŋ dza gesina, uwana la makoray aŋa Ge­ra­səniya tadə̀v kuɗa à Yesu kà mas à uda la makoray aŋatà la abà, kà uwana guba akə̀s atà à gay kaykay. Kiya uwaga masla ahàd à kəslah iyaw à afik, adà aŋha la abatà. ");
INSERT INTO mfh_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Dza uwana azla­zagəla zagəla tasàl à kəl ala, adə̀v kuɗa à Yesu kà madz à ahəŋ atà səla. Ama “Dà aŋak!”, Yesu agòɗal la magoɗay: ");
INSERT INTO mfh_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Wùl à huɗ gày aŋak, ŋgaha pə̀h tatak uwana Zəzagəla aɗahàŋ kà aŋak gesina!” Masla atsìzlla ala, ahàd, apàh tatak gesina uwana Yesu aɗahàŋ kà aŋha la makoray uwatà la abà gesina. ");
INSERT INTO mfh_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","La mok uwana Yesu adawul à waŋ maham à ahəŋ dza takə̀s masla la ahàl səla, kà uwana takudà masla. ");
INSERT INTO mfh_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Dza anik uwana sləm aŋha Yayrus asà à waŋ, masla agà məŋga aŋa gày madəv kuɗa, atə̀ɗ à makəla asik aŋa Yesu, la madəval kuɗa kà masla aŋa manəf à mtəga aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Dugu aŋha kà tekula à ahàl gà, la uwatà mavay aŋha kulo gəl aŋha səla. Masla la ɗuvats, alə̀g kà la ləv la ləv pəra. La mok uwana Yesu aday la tetəvi la ama, maham à ahəŋ dza taŋìsl masla la makəla gesina. ");
INSERT INTO mfh_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mis anik la ahəŋ aŋiz akə̀llal à tsəh ala dagay mavay kulo gəl aŋha səla. Ləmana aŋha gesina kà ada­dəvəŋ à dokwtar à tsəh gesina, ama ŋuləm aw. ");
INSERT INTO mfh_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kiya uwaga mis uwaga aguwà la lig aŋa Yesu, ŋgaha adəɓanì makəlbà aŋa gay dzika aŋa lukut aŋha. Katskats makəlay aŋa aŋiz aŋha atsìzlla à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Dzàw, Yesu atsìzlla à ahəŋ, agòla vok: “Uwa à uwana adəɓanì gi uwa?” Kəla uwa­be­yuwi agòɗal: “Gi kà, gi aw!” Piyer agòɗal: “Məŋga, kasəl kà maham à ahəŋ dza tahamà ka à adi, kakay kagoɗay kà: Uwa adəɓanì gi uwi ma?” ");
INSERT INTO mfh_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesu agòɗ: “Dza la ahəŋ adəɓanì gi, kà uwana gətàp à ndzəɗa asà à uda la vok gulo la abà.” ");
INSERT INTO mfh_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kiya uwaga mis anəŋàŋ kà, aslàla vok kà mahaɗ vok à ahəŋ aw, asà à waŋ la masu­kulay kosl kakosl à huma aŋa Yesu, ŋgaha atsehùr à makəla asik aŋha, apə̀hal godega aŋa uwana adəɓanì gay lukut aŋha. La huma aŋa azladza la kirim yewdi awùr ala. ");
INSERT INTO mfh_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu agòɗal: “Dugu gulo, madiŋal gəl à vok aŋak awùr ka ala, dà aŋak la lapiya!” ");
INSERT INTO mfh_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","La mok uwana Yesu à lig la maɓaɗma la abà dadàŋ, dza anik asà à waŋ la mtəga aŋa məŋga aŋa gày madəv kuɗa à Zəzagəla, la magoɗay: “Kà mana katərəɓ məŋga aya ma? Dugu aŋak adamətsay, tsewwa.” ");
INSERT INTO mfh_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mok uwana Yesu atsənà gay uwaga kà, agòɗ à Yayrus: “Ləv aval à ka à gay aw. Dìŋal gəl à vok pəra, ŋgaha adà­ɓelay!” ");
INSERT INTO mfh_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mok uwana tabə̀z à mtəga, Yesu avà tetəvi à dza amiyaka tekula kà mad à gày aw, say Piyer, Yuhana, Yakuba, ŋgaha baba la iyà aŋa bəzi pəra. ");
INSERT INTO mfh_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Te­ke­ɗika azladza gesina tatuway la matsàh hulolo, kà uwana bəzi adamətsay. Ama Yesu agòɗ à atà: “Katawaw aw, kà uwana bəzi la adi atə̀ɗ à madzehal à abà pəra”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","“Uwàà...”, takəɗàslal kà uwana tasə̀l kà bəzi kà adamətsay. ");
INSERT INTO mfh_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ama masla à Yesu akə̀s bəzi la ahàl la mazalal: “Bəzi, sà à afik, tsìzlla ala!” ");
INSERT INTO mfh_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kiya uwaga bəzi awùlla à ləv, ŋgaha asà à afik. Yesu agòɗ à atà: “Vàwwal tatak may, azuw!” ");
INSERT INTO mfh_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Gəl akàɗ azla­baba aŋha à vok, ləv avàlàhà atà à gay. Ama Yesu afahà à atà akur à lig la magoɗ à atà: “Dza apəh tatak uwana apakà vok à azladza anik aw.” ");
INSERT INTO mfh_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu ahamà gay azlaməna matapla la slaka aŋha à vok gesina, avà à atà ndzəɗa la maslay kà maku­ɗəkahay azla­ma­sasəɗok mawi­siga gesina, ŋgaha kà mawar azlaməna ɗuvats ala. ");
INSERT INTO mfh_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","La lig la ahəŋ, aslə̀l atà kà maz gay aŋa makoray Zəzagəla, ŋgaha kà mawar azlaməna ɗuvats ala, ");
INSERT INTO mfh_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","agòɗ à atà: “Zə̀ɓàw tatak à ahàl aŋa maday aw. Adàgay azəva, adàgay kiwa, adàgay kaf, adàgay sili, adàgay lukut bay, katsəpawwaŋ à vok aw! ");
INSERT INTO mfh_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kəla huɗ gày uwana azladza takə̀s akul la kay la ahàl səla kà, dzàw à ahəŋ la abatà, tsəràh à uwana kadà­tsi­zlawla, kadàdaw aŋkul la abatà. ");
INSERT INTO mfh_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ŋgaha kəla slaka uwana tadàkəs akul la abà aw kà, sàw à uda la huɗ gày aŋatà. Baməraka burburu aŋa kutso aŋa gudəŋ aŋatà, uwana agàɗ akul à asik bay kà, kaɗəɗaw à atà à adi, uwaga kà agay bokuba tatak mapəh à atà à vok à abà gà kà aŋatà.” ");
INSERT INTO mfh_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Azlaməna matapla tatsìzlla ala, tahàd kà maz gay matsi­ɗayga aŋa makoray Zəzagəla la azlahuɗ gudəŋ gesina, ŋgaha tawà­ràhà azlaməna ɗuvats ala gesina. ");
INSERT INTO mfh_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kiya uwaga à uwana Herod, sufəl aŋa gudəŋ uwatà, atsənà uwana tapəhay kà, gəl akàɗal à vok, kà uwana azladza anik tagoɗay kà: “Yuhana masla maɗàh batem adawul à uda la mamətsay.” ");
INSERT INTO mfh_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Azlaanik tagòɗ kà: “Eliya, la uwana ada­zla­ŋalay.” Ŋgaha azlaanik tagòɗ kà: “Uwaga kà, tekula la tataka azlaməna mapəh à atà gay à ahàl la abà uwarà, ada­zla­ŋalay.” ");
INSERT INTO mfh_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ama Herod agòɗ: “Tsa gi la uwana ‘Nàtsàw gəl aŋa Yuhana!’ gəgoɗ, ma uwaga zlà ma uwi? Uwa à dza uwaga tapə̀h azla­tatak aŋuvaw lakəl aŋha zlà à ama uwa?” Kà uwaga à uwana ayàh manəŋ Yesu. ");
INSERT INTO mfh_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Uwana azlaməna matapla tawùl à waŋ tapə̀h à Yesu dèwdèw tatak uwana taɗahàŋ gesina. Uwana adatsən uwaga kà, asə̀lla atà à uda la abatà, adàla atà à fəta à awtày kokuɗa gəl aŋatà la huma aŋa huɗ gudəŋ, uwana sləm aŋha Be­tsayda. ");
INSERT INTO mfh_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ama uwana maham à ahəŋ dza adatsən uwaga kà, tanəfà masla, Yesu akə̀s atà la lela, ŋgaha apə̀h à atà gay aŋa makoray Zəzagəla, la mawar azla­uwana ala, asà à atà mawarla. ");
INSERT INTO mfh_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mok uwana vəɗ adasa à waŋ, azlaməna matapla tahàd à slaka aŋha, tagòɗal: “ ‘Dàw aŋkul,’ gòɗ à maham à ahəŋ dza, kà atà aŋa mad à azla­gu­dəŋ uwana à abà takəs anu gay à adi, kà atà aŋa maɓəz tatak may la azla­slaka mahan à ahəŋ, kà uwana la abatà kà fəta.” ");
INSERT INTO mfh_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ama Yesu agòɗ à atà: “Akul, vàw à atà tatak may, tazuw!” Atà tagòɗ à Yesu: “Kaf gay bərsew zlo, la bəza kilfi səla pəra, aga anu la ahàl. Asa à ka məday kà masukw tatak may kà aŋa maham à ahəŋ dza uwanay gesina la gəl gami kəla ay?” ");
INSERT INTO mfh_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kà uwana la abatà kà matugway aŋatà kà aslay dza dəbow zlo. Yesu agòɗ à azlaməna matapla la slaka aŋha: “Dzàhàw atà madzay la dzibokw dzibokw, dzik zlo dzik zlo gesina aŋatà!” ");
INSERT INTO mfh_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Azlaməna matapla takə̀s, ŋgaha tadzàhà atà madzay gesina aŋatà. ");
INSERT INTO mfh_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ŋgaha Yesu ahə̀l kaf gay bərsew zlo la kilfi səla uwatà, anəŋà à zagəla, “Kikay”, agòɗ à Zəzagəla. Atsakà kaf ala, avà à azlaməna matapla la slaka aŋha, ŋgaha azlaməna matapla uwaga tavàh à maham à ahəŋ dza uwatà bay. ");
INSERT INTO mfh_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kiya uwaga kəla uwa­be­yuwi azùw kəla aŋa may aŋha. Azlaməna matapla tahamà gay à matam à atà à ahàl gà à vok, takosà kulo gəl aŋha səla à uwana atə̀m à atà à ahàl la kaf gay bərsew zlo la kilfi səla uwaga la abà. ");
INSERT INTO mfh_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Vuɗ tekula Yesu adə̀v kuɗa kokuɗa gəl aŋha. Azlaməna matapla tasà à waŋ à slaka aŋha. Yesu anàv atà manavay la magoɗ à atà: “Uwa azladza tagoɗ kà gi uwa?” ");
INSERT INTO mfh_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tawulàlla tagòɗal: “Azladza anik tagoɗay kà: Kak Yuhana, masla maɗàh batem, azladza anik bay tagoɗ: Kak Eliya, azlaanik aya tagoɗ: Kak tekula la tataka aŋa azlaməna mapəh à atà gay à ahàl, à uwana tapàhàh gay à azladza uwarà.” ");
INSERT INTO mfh_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesu agòɗ à atà: “Iyay zlà, akul ma: Gi uwa kagoɗaw uwa?” Piyer agòɗal: “Kak la uwana Kristu aŋa Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu afahà à atà akur à lig kaykay, kà atà aŋa mapəh tatak uwaga à dza aw. ");
INSERT INTO mfh_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ŋgaha azàlàŋ à gəl, agòɗ aya: “Say Kona aŋa dza as ŋgərpa məŋga. Azla­ma­siga, la azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla, ŋgaha la azlaməna matapla mapəhay à azladza tadà­kweska masla, tadàkəɗ masla bay, ama la mahənay mamakər adàwul à uda la mamətsay.” ");
INSERT INTO mfh_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ŋgaha agòɗ à azladza gesina: “Baŋa dza asal manəf gi kà, asak maf sləm à gəl aŋha, ŋgaha azəɓ ahàf mamətsay aŋha koksi­koksi, ŋgaha anəfa gi. ");
INSERT INTO mfh_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Dza uwana asal matəf gəl aŋha, adàziŋ ala, ama dza uwana az gəl aŋha ala kà gi, adàɓəl gəl aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mana akəs vok à dza, uwana akor gudəŋ à vok gesina, ŋgaha masla adàz gəl aŋha ala la makəɗ gəl à vok aŋha ma? ");
INSERT INTO mfh_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Baŋa ziruwi az dza kà gi, ŋgaha kà gay gulo, kità kà, Kona aŋa dza kà, ziruwi adàkəsay kà masla suwaŋ, la mok uwana adàsa à ahəŋ la mazləɓay aŋha, ŋgaha la mazləɓay aŋa Baba Zəzagəla, ŋgaha la aŋa azla­ma­lika aŋha tsi­ka­slaga la abà. ");
INSERT INTO mfh_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Haɗay, gəpəh à akul la dziriga: Azladza anik la tataka aŋkul la abà la abanay kà, tadàmətsay dàŋ aw, say baŋa tanəŋ makoray aŋa Zəzagəla dàŋ.” ");
INSERT INTO mfh_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","La lig mavakay mtəgis la ahəŋ, à uwana apə̀h gay uwaga, Yesu ahə̀l Piyer, Yuhana, ŋgaha Yakuba, à tsəh, adàla atà à gudəŋ à afik, kà madəv kuɗa la abatà kokuɗa gel aŋatà. ");
INSERT INTO mfh_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","La mok uwana tadə̀v kuɗa, huɗ adi aŋha agòlla vok, lukut aŋha awutsəɗay təlla. ");
INSERT INTO mfh_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Katskats aganay azladza səla la slaka aŋha, tavàts gay, uwatà kà Musa atà la Eliya, ");
INSERT INTO mfh_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","uwana tapə̀hla vok ala la mazləɓay aŋa zagəla la abà. Tapàhà gay lakəl aŋa sləray aŋha uwana adà­ɗe­həŋ, la mamətsay à Uru­sa­lima aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piyer la azla­ma­na­lay aŋha uwaga, tatàɗ à madzehal à abà. Ama kà uwana tatsə̀nla, tanəŋà mazləɓay aŋha, ŋgaha la azladza səla uwana tatsìzlla à ahəŋ la masla. ");
INSERT INTO mfh_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mok uwana azladza səla uwaga tadìy aŋatà, tasàk à Yesu à ahəŋ, Piyer agòɗal: “Məŋga, delga zlà bà à uwana anu la abanay zla. Məɗàh safsaf makər à abanay, tekula à aŋak, tekula aŋa Musa, ŋgaha tekula aŋa Eliya.” Kà uwana masla asəl tatak uwana apəhay aw ");
INSERT INTO mfh_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","La mok uwana Piyer aɓaɗmà, habaga akə̀l à atà mələs à adi, taɓa­ɗamma. Ləv avàl à azlaməna matapla uwaga à gay, kà uwana habaga atsakà à atà à ama la makəl à atà mələs à adi. ");
INSERT INTO mfh_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ŋgaha kuda atsənà à uda la habaga uwatà la abà: “Masla uwanay, la uwana Kona gulo uwana gi gəkə̀sànì. Tsə̀ɓàwwal sləm.” ");
INSERT INTO mfh_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mok uwana kuda uwaga atsə̀n kà, tanəŋàŋ kà Yesu kokuɗa gəl aŋha pəra. Azlaməna matapla la slaka aŋha tadzà à ahəŋ titi. Ŋgaha babay tapə̀h à dza tatak uwana tanəŋàŋ la mavakay uwatà aw. ");
INSERT INTO mfh_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","La bebəŋ gà, uwana tatsà à ahəŋ la gudəŋ la afik, maham à ahəŋ dza aŋuvaw tasà à waŋ kà maga­gamay la Yesu. ");
INSERT INTO mfh_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","La maham à ahəŋ dza uwatà la abà kà, dza anik la ahəŋ awiyà la magoɗay: “Məŋga, vok ahamà ka, kà bəzi gulo tekula gà uwanay tsi, kà uwana masla la ɗuvats. ");
INSERT INTO mfh_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kà uwana masasəɗok mawi­siga akasay, amallal gəl à ahəŋ, agodzal à ahəŋ la ndzəɗa, huzləv asahal à waŋ la gay la awtày, atərəɓ à ahəŋ kà məŋga, məŋga, asàk à ahàl kà wiy aw. ");
INSERT INTO mfh_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Gədə̀v kuɗa à azlaməna matapla la slaka aŋak kà makuɗəkal masasəɗok mawi­siga uwaga lakəl ala, ama taslàla vok aw.” ");
INSERT INTO mfh_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Uwana Yesu atsənà gay uwaga, agòɗ à atà: “Kayyà, akul azladza mawi­siga, kokuɗa madiŋal gəl à vok, dagay mbà à uwana mədadza à ahəŋ anina ma? Dagay mbà gədà­ba­sa­ha­kulaŋ ma?” Yesu agòɗal: “Sàgəla kona aŋak à waŋ à abanay!” ");
INSERT INTO mfh_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mok uwana bəzi azà vok à slaka aŋha, masasəɗok amə̀llal gəl à ahəŋ, ago­dzàlla bəzi la ndzəɗa. Ama Yesu aslə̀h məlo à masasəɗok mawi­siga uwatà à gəl la ndzəɗa, ŋgaha awurà bəzi ala, avà à baba aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ŋgaha gesina aŋatà la abatà, ləv avàl atà à gay, kà məŋga aŋa ndzəɗa aŋa Zəzagəla la mazləɓay ŋgaha la maslay aŋha. Ama Yesu atapà azlaməna matapla la slaka aŋha, agòɗ à atà kà: ");
INSERT INTO mfh_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Fàw gay uwanay à sləm à abà lela! Kona aŋa dza kà tadàvày à ahàl aŋa azladza.” ");
INSERT INTO mfh_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ama tatsənà gay uwatà aw, ahaɗà godega aŋa gay uwatà à ahəŋ, kà atà aŋa masəlay aw. Ŋgaha atà kà, guba akə̀s atà kà manav godega aŋha babay. ");
INSERT INTO mfh_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kiya uwaga azlaməna matapla tadzəkà mabay vok gay la tetəvi la ama, kà masəl dza uwana məŋga gà la tataka aŋatà la abà. ");
INSERT INTO mfh_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu asə̀l madzugway aŋatà uwana tadzugway gesina la ləv aŋatà la tsəh, masla akə̀s bəzi ŋuvga, atsìzl­latàŋ à huma à gay, ");
INSERT INTO mfh_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","agòɗ à atà: “Dza uwana akəs bəzi ŋuvga uwanay kà, kà uwana awoya gi kà, masla babay kà akəs gi, ŋgaha dza uwana akəs gi, akəs dza uwana aslə̀l gi à waŋ babay. Dza uwana bəziga la tataka aŋkul la abà kà, masla la uwana məŋga gà.” ");
INSERT INTO mfh_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yuhana adzəkà maɓaɗma, agòɗal: “Məŋga, mənəŋà dza anik uwana akuɗə̀kàh azla­ma­sasəɗok mawi­siga la sləm aŋak, ŋgaha məvəràla gay kà uwana anina aw.” ");
INSERT INTO mfh_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu agòɗ à atà: “Awaŋ, kà mana kavəràwla gay ma, kà uwana dza uwana masla məzam aŋkul aw kà, masla kà slawda aŋkul!” ");
INSERT INTO mfh_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mok uwana kaslà mad à zagəla aŋa Yesu adagay nekwa kà, akə̀s tetəvi kà mad à Uru­sa­lima. ");
INSERT INTO mfh_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yesu aslə̀l azlaməna masləlay la huma dadàŋ, tahàd, tadà à gudəŋ, uwana la Sama­riya la abà kà maɗa­halla azla­tatak à ahəŋ gesina. ");
INSERT INTO mfh_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ŋgaha azlaməna madz à ahəŋ la gudəŋ uwatà takəs aw, kà uwana agà la tetəvi la ama, kà mad à Uru­sa­lima. ");
INSERT INTO mfh_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kiya uwaga à uwana azlaməna matapla Yuhana atà la Yakuba tatsənàŋ uwaga kà, tagòɗ: “Sufəl, asa à ka kà mənav akàl atsa à ahəŋ la zagəla kà mabaɓəh atà à gay ay?” ");
INSERT INTO mfh_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ama Yesu agòlla vok, anəŋà atà à adi, ŋgaha asləhà à atà vok. ");
INSERT INTO mfh_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ŋgaha atà tahàd à gudəŋ anik à abà. ");
INSERT INTO mfh_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mok uwana tatsìzlla ala, dza anik agòɗ à Yesu: “Yesu, kəla slaka uwana kadàday kà gədànəf ka.” ");
INSERT INTO mfh_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ŋgaha Yesu agòɗal: “Azla­ma­yaka kà: afək aŋatà la ahəŋ, azla­ɗiyaŋ kà: gày aŋatà la ahəŋ, ama Kona aŋa dza kà bà, slaka mahən gəl à ahəŋ aŋha la ahəŋ kà maduw ləv aw.” ");
INSERT INTO mfh_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kiya uwaga Yesu agòɗ à anik aya: “Nəfà gi!” Ama masla agòɗal: “Məŋga, và à gi tetəvi, kà gi aŋa mal baba gulo dadàŋ.” ");
INSERT INTO mfh_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ama Yesu agòɗal: “Sàk azla­ma­zim­nekiɗ talàh vok aŋatà, ama kak kà, hàd, kazà gay aŋa makoray Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Dza anik agòɗal aya: “Sufəl, gi kà gənəf ka nəma, ama và à gi tetəvi kà maday, ‘Gi kà maday’, gədàgoɗ à huɗ gày gulo dadàŋ.” ");
INSERT INTO mfh_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu agòɗ à atà: “Kəla dza uwana adafa ahàl aŋha à səɗuk sla à lig, ŋgaha anəŋ à lig kà, masla kà, akəsa vok aya kà aŋa makoray Zəzagəla aw.” ");
INSERT INTO mfh_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","La lig aŋa uwaga la ahəŋ, Sufəl atsa­tsà­mànì azladza anik dzik məɗəf gəl aŋha səla, ŋgaha aslə̀latàla səla səla la huma aŋha, à azla­gu­dəŋ uwana à abà, à uwana masla la gəl aŋha asàl madàɗàh à abà. ");
INSERT INTO mfh_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kiya uwaga Yesu agòɗ à atà: “Sləray matsəɗ tatak la ahəŋ aŋuvaw, ama azlaməna sləray kà dəŋ aw. Kità kà, də̀vàw kuɗa à dza ana makor tatak, kà masla aŋa masləl azlaməna matsəɗ tatak à waŋ dəŋ. ");
INSERT INTO mfh_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Dàw, aganay gəsləl akul bokuba azla­tuwaŋ à tataka azlakəda fəta à abà. ");
INSERT INTO mfh_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kazəɓaw sili à ahàl, amiyaka kiwa aŋa tatak may, la kwimik babay aw. Katsizllaw à ahəŋ la tetəvi la ama kà maɗàh ‘Ayyi’ à dza aw. ");
INSERT INTO mfh_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kəla gày, uwana kadaw à gày kagoɗaw dadàŋ teraŋa kà: ‘Lapiya agay la kay uwanay.’ ");
INSERT INTO mfh_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Baŋa masla lapiya la ahəŋ la kay uwatà, ayyi aŋa lapiya ankul adàdza à ahəŋ lakəl aŋha, tsa baŋa kità aw kà, ayyi aŋa lapiya ankul anəfa akul. ");
INSERT INTO mfh_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Dzàw à ahəŋ la huɗ gày aŋa lapiya, zùwàw, sàw uwana taf à akul à huma à gay gesina, kà uwana masla sləray kà azlayla masik aŋha. Ama katse­tse­rahaw à gày à gày aw. ");
INSERT INTO mfh_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Baŋa kadàdaw à huɗ gudəŋ anik à abà, ŋgaha takəs akul la ahàl səla, zùwàw tatak uwana taf à akul à huma akul à gay. ");
INSERT INTO mfh_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wàràw azlaməna ɗuvats ala la gudəŋ uwatà la abà, gòɗàw à azlaməna madz à ahəŋ la abatà kà: ‘Makoray aŋa Sufəl Zəzagəla kà nekwa la akul.’ ");
INSERT INTO mfh_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ama baŋa kadaw à huɗ gudəŋ anik à abà, ŋgaha takəs akul la ahàl səla aw kà, sàw à uda à tetəvi à ama, ŋgaha gòɗàw à atà: ");
INSERT INTO mfh_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Aganay məɗəɗ à akul burburu aŋa gudəŋ aŋkul à adi, à uwana agàɗ à anu à asik la gudəŋ aŋkul la abà. Te­ke­ɗika sə̀làw la lela kà: Makoray Zəzagəla kà adagay nekwa.’ ");
INSERT INTO mfh_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","La dziriga gəpə̀h à akul kà: La vuɗ seriya kà ŋuləm adagay kà aŋa azlaməna madz à ahəŋ la gudəŋ Sodom, kà azlaməna madz à ahəŋ la gudəŋ uwanay la abà.” ");
INSERT INTO mfh_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ŋgərpa lakəl aŋak à kak Korazən! Ŋgərpa lakəl aŋak à kak Be­tsayda! Kà uwana agay nadzipo uwana taɗahàŋ la tataka aŋkul la abà agay kà la gudəŋ Tir la Sədon kà, nakà, dagay uwarà azlaməna madz à ahəŋ la abà kà tatsàh kutso akàl à vok, ŋgaha la madaw abùh à vok, kà mapəhla ala kà, atà tapə̀h gay la ləv ala. ");
INSERT INTO mfh_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kà uwaga à uwana gəgoɗ à akul kà: La vuɗ seriya kà, seriya uwana adàɓəz azlaməna gudəŋ Tir, la azlaməna gudəŋ Sədon kà, ŋuləm kà aŋatà, à kà aŋa gudəŋ aŋkul. ");
INSERT INTO mfh_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ŋgaha kak, Kaper­nahum, kadzugw kà: ‘Gəda­zigənay tsəràh à zagəla’, kagoɗ takay? Awaŋ, tadàdukw ka à vəɗah à gày akàl à abà.” ");
INSERT INTO mfh_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kiya uwaga Yesu agòɗ à azlaməna matapla la slaka aŋha: “Dza uwana atsəɓ à akul sləm, atsəɓ à gi sləm babay, dza uwana akweska akul kà, akweska gi babay, ŋgaha akweska masla masləl gi à waŋ babay aya.” ");
INSERT INTO mfh_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kiya uwaga azlaməna asik uwaga tawùl à waŋ, la marabay tsek­t­satsek tagòɗ: “Məŋga gami, amiyaka azla­ma­sasəɗok mawi­siga babay kà takə̀s anu gay la ahàl ala, à mok uwana mədapəh à atà gay aŋak!” ");
INSERT INTO mfh_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","“Haɗay”, Yesu agòɗ à atà: “Gənəŋà seteni atə̀ɗ à ahəŋ la zagəla bokuba mawutsəɗay aŋa habaga. ");
INSERT INTO mfh_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tsənàwwàŋ, aganay gədavà à akul maslay kà akul aŋa mahaɓàh azla­bebi ala, la azlaaliz, ŋgaha babay kà akul aŋa mahaɓàh ndzəɗa aŋa masla məzam ala gesina. Ŋgaha tatak mawi­siga la ahəŋ adà­dəɓani à akul aw. ");
INSERT INTO mfh_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ama kəla kà, karabaw kà uwana azla­ma­sasəɗok mawi­siga takəs gay aŋkul aw, ama kà, ràbàw kà, kà uwana sləm aŋkul matse­tse­rayga la wakità aŋa sifa la abà, la zagəla la afik!” ");
INSERT INTO mfh_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","La mok uwatà, Masasəɗok Zəzagəla ahənà Yesu ala la marabay, agòɗ: “Iyay, Baba Sufəl aŋa zagəla ŋgaha aŋa vəɗah, kikay gəgoɗ à ka, kà uwana kafətla à azla­bəzaga la ama ala tatak nasi­riga uwana kahaɗàŋ à azlaməna masəl tatak uwana à adi: ‘Mədawur gəl’, tagoɗ. Iyay Baba gəzləɓ ka kà uwaga.” ");
INSERT INTO mfh_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Baba gulo aɓə̀k à gi tatak gesina. Dza la ahəŋ asəl Kona aw, say Baba pəra asəl gi, dza la ahəŋ asəl Baba aw, say gi Kona aŋha pəra, ŋgaha la azla­uwana, Kona apəhatàla masla pəra.” ");
INSERT INTO mfh_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ŋgaha Yesu agòla à huma à azlaməna matapla la slaka aŋha à gay, agòɗ à atà, à atà kokuɗa gəl aŋatà pəra: “Marabay kà aŋkul, kà uwana yewdi ankul tanəŋà tatak dzəɓa aŋha səla aw! ");
INSERT INTO mfh_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","La dziriga gəpeh à akul, azlaməna mapəh à atà gay à ahàl aŋa mapàh à azladza, la azla­su­fəl tayàh kà manəŋ uwaga kanəŋàwwàŋ lagwa, ama tanəŋàŋ aw. Ŋgaha kà matsənəŋ uwana katsənàwwàŋ lagwa, ama tatsənàŋ aw.” ");
INSERT INTO mfh_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Masla mapàhla wakità mapəhay ala, asà à afik. Asàl matap ləv aŋa Yesu, kà maɓəzal à tsəh la gay la abà, agòɗal: “Məŋga, mana à uwana, gəɗehəŋ kà gi aŋa maɓəz sifa adəv à gay aw ma?” ");
INSERT INTO mfh_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Kiya uwaga Yesu agòɗal: “Mana tatsetsèr à wakità mapəhay à abà ma, aŋa kadzeŋay ma?” ");
INSERT INTO mfh_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Masla awùlla à uda, agòɗal: “Wòyà Sufəl Zəzagəla aŋak, la ləv aŋak gesina, la ndzəɗa aŋak gesina, la haŋkəli aŋak gesina, ŋgaha la sifa aŋak gesina, ŋgaha wòyà masla magay aŋak, bokuba gəl aŋak uwana kawoyàŋ.” ");
INSERT INTO mfh_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kiya uwaga Yesu agòɗal: “Delga kawùlla à uda, Ɗahàŋ kiya uwaga zlà, kadàɓəz sifa uwana adəv à gay aw.” ");
INSERT INTO mfh_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ama masla asàl mag gəl aŋha dziriga, agòɗ à Yesu: “Iyay zlà, uwa à masla magay gulo uwa?” ");
INSERT INTO mfh_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu agòɗal: “Iyay tsənàŋ: Dza anik atsìzlla ala la Uru­sa­lima kà mad à Yeriko. La tetəvi la ama, azlaməna nabəra tasà à waŋ, tazlawàŋ, tazlàɓ masla, tazùw, ŋgaha tasàkàl à ahəŋ la ləv la ləv pəra. ");
INSERT INTO mfh_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","La lig la ahəŋ, tsəhay azlaməna mav tatak à Zəzagəla aguwàŋ la tetəvi uwatà. Mok uwana anəŋà dza uwaga kà, akə̀llal vavara à adi, aguwà la dərəv à uda anik. ");
INSERT INTO mfh_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ŋgaha aya, zil Levi, (Uwana azla­kaha à azlaməna mav tatak à Zəzagəla à sləray uwana la abà, taɗahaŋ la gày Zəzagəla la aku) anəfà tetəvi uwatà bay. Mok uwana adabəz à slaka uwatà, anəŋà dza uwaga, akə̀llal vavara à adi aya suwaŋ, aguwà la dərəv à uda anik. ");
INSERT INTO mfh_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Agà la ahəŋ aya babay zil Sama­riya uwana la mau­gu­zahay la abà, anəfà tetəvi uwatà babay suwaŋ, abəzà à slaka aŋa dza uwatà la ləv la ləv. Mok uwana anəŋàŋ, vok ahamàl kaykay kà masla. ");
INSERT INTO mfh_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ŋgaha azà vok à slaka aŋha niɓ, apà­làhal azlaamik aŋha, la maɗà­hàhal amàl à gəl, la iyaw matavəruk uwana azay la abà, bokuba mamle­ləŋ uwana azay la amik la abà, ŋgaha abàkal azlaamik uwaga, afà masla à tatak aŋha uwana à afik, masla aday la afik, ŋgaha adàla masla à gày məlok dza à agu, la slaka uwana tadànəŋal à adi lela. ");
INSERT INTO mfh_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","La bebəŋ bəŋ, mok uwana atsìzlla ala, kà mad aŋha, ahə̀l gursu səla à uda, avà à dza aŋa gày məlok la magoɗal: ‘Fàl sləm lela à dza uwanay, la vuɗ uwana gədàwul à waŋ à abanay kà, gi la gəl gulo, gədàpəlla ka tatak uwana kadàziŋ ala kà aŋha gesina.’ ” ");
INSERT INTO mfh_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","La lig la ahəŋ Yesu anavà à dza uwaga gà: “Iyay zlà, la tataka aŋa azladza makər uwaga la abà, ma uwala à uwana agà bokuba masla magay aŋa dza uwana azlaməna nabəra tazùw, tazlàɓ ala?” ");
INSERT INTO mfh_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Masla mapahla mapəhay uwaga ala agòɗ: “Gi kà, dza uwana vok ahamàl kà masla, gəgoɗ.” “Delga”, Yesu agòɗal, “Kak babay, hàd, kaɗahàŋ kiya uwaga babay suwaŋ zlà.” ");
INSERT INTO mfh_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Mok uwana atà la tetəvi la ama la azlaməna matapla aŋha, ahàd à gudəŋ anik à abà. Mis anik la ahəŋ la abatà, sləm aŋha Marta, akə̀s Yesu à mtəga aŋha la ahàl səla. ");
INSERT INTO mfh_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Deda aŋa mis uwatà la ahəŋ, sləm aŋha Mari­yama, adzà madzay la makəla asik aŋa Sufəl, kà matsəɓ sləm à uwana masla apəhay. ");
INSERT INTO mfh_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Bokuba uwana sləray maɗagəl adakaɗ gəl à Marta à vok, ŋgaha agòɗ à Yesu: “Sufəl, uwaga kà aza ka aw, tak à uwana deda gulo adasakgəla sləray à gəl gesina ay? ‘Zlakà deda aŋak’, gòɗal!” ");
INSERT INTO mfh_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Sufəl awulàlla agòɗal: “Marta, Marta, katərəɓ gəl aŋak la azla­tatak aŋuvaw kiga ma, kà mana ma? ");
INSERT INTO mfh_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ama kəla kà, tatak tekula la uwana akəsa vok! Mari­yama kà, akə̀sànì tatak uwana dzəɓa aŋha səla aw gà, uwana dza azəɓallaŋ ala aya aw tetuwa.” ");
INSERT INTO mfh_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kiya uwaga vərdi anik, Yesu adə̀v kuɗa la slaka anik. Mok uwana adakəɗ gəl à madəv kuɗa, tekula la tataka azlaməna matapla la slaka aŋha la abà anàval: “Sufəl, tàpanula madəv kuɗa, bokuba aŋa Yuhana uwana atàpla azlaməna asik aŋha.” ");
INSERT INTO mfh_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu agòɗ à atà: “Baŋa kadəvaw kuɗa kà, gòɗàw kà: Baba, Sləm aŋak tsi­kaslaga agay masəlay gà, la slaka azladza. Ŋgaha makoray aŋak atsa à waŋ. ");
INSERT INTO mfh_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Và à anu tatak may asla à anu kəla mahənay. ");
INSERT INTO mfh_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Matsan tsakana gami ala, Ŋgaha anu bay la gəl gami aŋa mamatsiŋ à azladza uwana ala, taɗahà à anu mawi­siga à vok. Ŋgaha, fà à anu sləm, kà seteni aŋa mapapat anu aw.” ");
INSERT INTO mfh_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ŋgaha Yesu agòɗ à atà: “Baŋa tekula aŋkul ada à mtəga slawda aŋha la tataka vəɗ agoɗal: ‘Slawda gulo, kamkam ɓə̀k à gi kaf gay bərsew makər tsi, ");
INSERT INTO mfh_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kà uwana slawda gulo anik agurùh à gi, asà à waŋ la mau­gu­zahay, gəsəl tatak uwana gəvàl aw.’ ");
INSERT INTO mfh_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tsənàw maɓaɗma à uda la kay aŋa dza anik uwanay tsi: ‘Sàk à gi titi, gədatsak gamagày à ama kà dagay uwarà, ŋgaha anu babay kà mədahan à ahəŋ la azlabəza gulo, tsewwa. Gəslala vok aŋa mas à afik aŋa mav à ka aya aw.’ ");
INSERT INTO mfh_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ŋoɗa à gi kà, masla adàsa à afik kà aŋa mavàl kà, kà slawda aw; ama adàsa à afik kà, kà uwana slawda aŋha ad à huma à gay la mazalay, la mapakla. ");
INSERT INTO mfh_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ama gi kà gəgoɗ à akul kà: Nàvàw ŋgaha kadà­ɓəzawwal, yàhàw ŋgaha tadàv à akul dè­ɗàwwàŋ, ŋgaha dza uwana ayahay aɓəzal, ŋgaha dza apəzl gamagày à dza uwana azalay, ");
INSERT INTO mfh_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","kà uwana kəla dza uwana anavay: aɓəzal; dza uwana ayahay: aɓəzal; ŋgaha dza apəzl gamagày à dza uwana aza­lahay. ");
INSERT INTO mfh_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Baba ma aŋa uwa la tataka aŋkul la abà, baŋa bəzi aŋha anaval kilfi ma avàl bebi takay? ");
INSERT INTO mfh_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Awma baŋa anaval slaslay ma avàl aliz ay? ");
INSERT INTO mfh_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Akul azla­ma­wi­siga nəma, ama kasəlaw mav tatak delga à azlabəza aŋkul, ŋgaha zlà ma ada­məraka Baba uwana la zagəla la afik takay. A masla uwana avàhay Masasəɗok aŋha à azladza uwana tanaval?” ");
INSERT INTO mfh_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu adzəkà makuɗək masasəɗok mawi­siga à dza anik lakəl ala à uwana ada­pa­kəŋ ala kà bada. Mok uwana masasəɗok mawi­siga uwaga adasal à kəl ala, bada adzəkà maɓaɗma, ŋgaha ləv avàl à maham à ahəŋ dza à gay gesina la abatà. ");
INSERT INTO mfh_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ama azladza anik la tataka aŋatà la abà, tagòɗ: “Bel­zəbul, sufəl aŋa azla­ma­sasəɗok mawi­siga la uwana avàl ndzəɗa kà makuɗəkàh azla­ma­sasəɗok mawi­siga.” ");
INSERT INTO mfh_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Azladza anik asà à atà malal à afək à ahəŋ, kà uwaga à uwana azladza anik tagòɗ: “Ɗahà à anu a ahə̀ŋ nadzipo tsi, kà aŋa mapəhanula kà, Zəzagəla la uwana aslə̀l kà à waŋ.” ");
INSERT INTO mfh_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ama Yesu asə̀l madzugway aŋatà, agòɗ à atà: “Baŋa azladza gudəŋ tekula tatsàk ala, ŋgaha tapa guvəl la tataka aŋatà la abà kà, makoray ana gudəŋ uwatà kà azila, huɗ gày la huɗ gày tagwàh vok à gəl. ");
INSERT INTO mfh_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tsa baŋa seteni la gəl aŋha adatsakla ma, kakay makoray aŋha ad à huma à gay aya ma? Tsa akul kagoɗaw kà: Gəkuɗə̀kàh azla­ma­sasəɗok mawi­siga kà Bel­zəbul la uwana avà à gi ndzəɗa kagoɗaw ma? ");
INSERT INTO mfh_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Iyay, akul kadzugwaw kà Bel­zəbul la uwana avà à gi ndzəɗa kà makuɗəkàh azla­ma­sasəɗok mawi­siga, uwaga kagòɗàw. Kità ma, uwa adavà ndzəɗa à azlabəza aŋkul, kà maku­ɗəkàhla uwa? Kà uwaga à uwana tadàgah azlaməna seriya aŋkul. ");
INSERT INTO mfh_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ama tsa baŋa la Masasəɗok Zəzagəla la uwana gəkuɗə̀kàh azla­ma­sasəɗok mawi­siga uwanay kà, tsa kətà kà, gòɗàw kà makoray aŋa Zəzagəla kà adaɓəz akul à vok lakana, gòɗàw zlà!” ");
INSERT INTO mfh_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Baŋa dza mabəla­faga aɓə̀k kazlaŋa guvəl aŋha à vok, anə̀ŋla gày aŋha lela, kà uwana akoray gesina kà ahàl adàlla vok aw. ");
INSERT INTO mfh_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ama baŋa dza uwana aɗuwa masla la ndzəɗa atsa à waŋ à slaka aŋha, ŋgaha akəɗaslal, ahəlla kazlaŋa guvəl aŋha uwana ala à uwana afà manəwəŋ aŋha à afik gesina. Ŋgaha ahəl tatak aŋha, avàh à azladza à uda gesina.” ");
INSERT INTO mfh_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Dza uwana anu səla aw kà, masla kà, masla məzam gulo. Ŋgaha babay, dza uwana azlak gi, kà mahamla gay à vok aw kà, masla kà, masla madà­da­siŋla.” ");
INSERT INTO mfh_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“La mok uwana masasəɗok mawi­siga adasa à uda la dza la abà kà, aday augu­zahay la azla­slaka deyday gà gesina, ayàh slaka maduw ləv. Ama baŋa aɓəzal aw kà, agoɗay la gəl aŋha kà: ‘Lagwa kà, gəday, gədàwul à slaka gulo uwana à abà, gəsà à uda la abà.’ ");
INSERT INTO mfh_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ŋgaha awulay, aɓəzal à gəl kà masla­ɗayga lela, maɗehəŋ à ahəŋ gà dzəɓa aŋha səla aw. ");
INSERT INTO mfh_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","La abatà kà, aday, ayahay azla­ma­sasəɗok mawi­siga anik à tsəh məɗəf, azla­uwana taɗuwa masla la dzaŋ­dzaŋ, tatsa à waŋ atà nna, tadza à ahəŋ la abatà. Kiya uwaga kà madz à ahəŋ aŋa dza uwaga agay mawi­siga ɗaɗuwa à gay uwana uwarà.” ");
INSERT INTO mfh_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mok uwana Yesu adapəh gay kiya uwanay kà, mis anik adzəkà maɓaɗma la tataka maham à ahəŋ dza la abà: “Lapiya agay la mis uwana azàɓ ka la huɗ, ŋgaha la uwana avàhà à ka awà.” ");
INSERT INTO mfh_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ama Yesu agòɗal kà: “Lapiya agay kaykay kà la azladza, uwana tatsəɓ sləm à gay Zəzagəla, ŋgaha taf sləm à uwaga lela.” ");
INSERT INTO mfh_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mok uwana dza adahama gay à vok la slaka aŋha kà, Yesu agòɗ à atà: “Azladza aŋa zamana uwanay lakana kà, azla­ma­wi­siga, dziriga aŋatà la ahəŋ aw. Atà tayàh nadzipo, ama nadzipo la ahəŋ tanəŋ aw, say aŋa masla mapəhal gay à ahàl Yonas uwatà pəra. ");
INSERT INTO mfh_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ŋgaha bokuba uwana Yonas apàk nadzipo kà aŋa azlaməna gudəŋ Niniv kà, kiya uwaga Kona aŋa dza adàpak nadzipo kà aŋa azladza aŋa zamana aŋa lakana suwaŋ. ");
INSERT INTO mfh_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","La vuɗ seriya kà, mis sufəl gà uwana la gəl la aku, adàgola à huma azladza aŋa lakana à gay, ŋgaha adàpuwa à atà gudzi à gəl, kà uwana asà à afik la tsəh la ahəŋ la makəɗ gəl à ahəŋ gudəŋ à vok, kà matsəɓ sləm à gay matsi­hila aŋa Salomon. Aganay à dza uwana aɗuwa Salomon la abanay lakana. ");
INSERT INTO mfh_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","La vuɗ seriya azlaməna aŋa gudəŋ Niniv tadà­gola afaɗ à azladza aŋa lakana à gəl, ŋgaha tadà­puwa atà gudzi à gəl, à kà uwana azlaməna madz à ahəŋ la gudəŋ Niniv tapəh gay la ləv ala, la mok uwana tatsənà sayda aŋa Yonas. Ama dza uwana aduwa Yonas kà aganay la abanay zlà.” ");
INSERT INTO mfh_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Dza la ahəŋ avats fənəs maf à tsəh tasà aw, ama afay kà à slaka masərət fənəs à ahəŋ, kà mav uɗaka à azladza gesina, uwana tad à gày. ");
INSERT INTO mfh_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yewdi kà uɗaka aŋa vok aŋak: baŋa yewdi aŋak kà wurwur kà, vok aŋak gesina kà uɗaka, ama baŋa yewdi aŋak la ɗuvats kà, vok aŋak gesina kà la mələs la abà. ");
INSERT INTO mfh_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kiya uwaga kà, ɗahà haŋkəli kà uɗaka uwana la vok aŋak kà, kà aŋa magay la mələs la abà aw. ");
INSERT INTO mfh_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Iyay, baŋa vok aŋak gesina auɗay, kokuɗa magay la abà aŋa bəzi mələs la slaka anik kà, vok aŋak gesina kà adàgay uɗaka, bokuba fənəs uwana av uɗaka la huɗ gày gesina.” ");
INSERT INTO mfh_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","La mok uwana Yesu adadəv maɓaɗma à gay, zil Farisəya anik azàlal kà mazuw tatak may atà səla la mtəga aŋha. Yesu adà à gày à dza à tatak may à gəl. ");
INSERT INTO mfh_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kay, zil Farisəya uwaga akə̀s gəl la ahàl səla, kà uwana Yesu apàl ahàl kà mazuw tatak may aw, azùw pəra. ");
INSERT INTO mfh_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Sufəl agòɗal: “Akul, azla Farisəya kà kapa­lahaw azla­tatak masala iyaw, la azlakəslaɗ. Ama la huɗ aŋkul kà, kahə̀nàwla la makəsa­fər dzəɓaŋŋa, ŋgaha à gəl la adi gesina. ");
INSERT INTO mfh_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Akul azla­ku­soŋu. Dza uwana aɗahàŋ udaga uwaga, ma masla la uwana aɗahà huɗga à awtày takay? ");
INSERT INTO mfh_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ŋuləm kavàw à azlaməna kuɗa à tatak uwana la kətsaw aŋkul la abà, la uwana la kəslaɗ aŋkul la abà, ŋgaha tatak gesina adàgay dzahhà kà aŋkul.” ");
INSERT INTO mfh_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ŋgərpa la akul, azla Farisəya! Kà uwana kavàw Zəzagəla makulo aŋa tatak aŋkul, baməraka la azlatsəhay alàl bəzaga gesina bay, ama kapəsewaw dziriga la masal aŋa Zəzagəla. Te­ke­ɗika naka uwatà la uwana maɗehəŋ kəla, ŋgaha mapəsew azla­tatak anik anik deydayga uwanay gesina.” ");
INSERT INTO mfh_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ŋgərpa la akul, azla Farisəya! Kà uwana asa à akul azla­slaka mate­raga la azlagày madəv kuɗa la aku, ŋgaha aya asa à akul kà azladza taɗa­ha­kulla ‘Ayyi’, la huma maham à ahəŋ dza gesina kà mapəhla gəl aŋkul ala, kà akul azladza məŋga. ");
INSERT INTO mfh_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ŋgərpa la akul! Akul uwana kapa­kàhàw kà bokuba azlazəvay uwana adakal à ahəŋ taɓazl à abà tanəŋla aya aw, kalkal la kutso uwana tau­gu­zahay la afik.” ");
INSERT INTO mfh_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","“Iyay”, tekula la tataka azlaməna mapàhla mapəhay ala la abà agòɗal: “Məŋga, la mapəhay kiya uwaga kà, anu babay kà kago­ɗaha à anu ma kasəl nəmay?” ");
INSERT INTO mfh_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu agòɗ à atà: “Ŋgərpa la akul, akul azlaməna mapàhla mapəhay ala! Kà uwana kaɓəɗaw dzəgla à azladza à gəl, tsa tekeɗik akul la gəl aŋkul kà, amiyaka la gay gəl ahàl babay kà, kadəba­wani aw. ");
INSERT INTO mfh_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ŋgərpa la akul! Akul uwana kaŋa­lahaw zəvay aŋa azlaməna mapəh à atà gay à ahàl kà mapàh à azladza, tekeɗik azla­baba aŋkul la uwana takàɗàh atà. ");
INSERT INTO mfh_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kiya uwaga kà, akul azlaməna sayda aŋatà lakəl aŋa sləray aŋatà uwana taɗahàŋ. Kà uwana atà la uwana takàɗàh azlaməna mapəh à atà gay à ahàl. Ŋgaha aya, akul kà katərka­ka­slahaw la maŋalàh azlazəvay aŋatà aya! ");
INSERT INTO mfh_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kiya uwaga à uwana Zəzagəla agòɗ la matsi­hila aŋha kà: ˈ‘Gədà­sləl atà à awtày azlaməna mapəh à atà gay à ahàl la azlaməna matapatàla tatak. Atà tadà­ka­ɗahay azlaanik aŋatà, ŋgaha babay tadàtərərɓah azlaanik aŋatà aya!’ˈ ");
INSERT INTO mfh_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Gəpəh à akul la dziriga kà, aŋiz aŋa azlaməna mapəh à atà gay à ahàl, uwana tasòkwàh à vəɗah dagay madzəka gudəŋ à vok kà, tadà­navay kà la ahàl aŋa azladza aŋa lakana. ");
INSERT INTO mfh_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Dagay aŋiz aŋa Abel tsəràh à aŋiz aŋa Zakari, uwana kakə̀ɗàw à tataka azla­slaka makaɗ tatak à abà la slaka tsi­ka­slaga. Gəpəh à akul la dziriga kà, tadànav aŋiz aŋa azladza uwaga kà la ahàl aŋa azladza aŋa lakana!” ");
INSERT INTO mfh_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ŋgərpa la akul, akul azlaməna mapàhla mapəhay ala! Kà uwana kazə̀ɓàw tsəku­rum uwana av tetəvi kà masəl tatak, uwala akul la gəl aŋkul kà, kadaw à gày la abatà aw, ŋgaha pəra aya kà, kaɗəɗaw gay à azladza anik uwana à ahəŋ, asa à atà mad à gày la abatà.” ");
INSERT INTO mfh_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Mok uwana Yesu adasa à uda la abatà azlaməna mapàhla mapəhay ala la azla Farisəya tanəfà masla la gay, tanà­vàhal azla­tatak aŋuvaw la gay ala. ");
INSERT INTO mfh_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Atà tayàh maɓəzal à tsəh la azlagay mawi­siga la abà, ŋgaha kà atà aŋa mapuwalla gudzi à gəl. ");
INSERT INTO mfh_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","La kaslà uwatà kà, azladza dəbow dəbow tahamà gay à vok, tsəràh à uwana azladza tafàh vok asik à gəl kà atà kà atà. Teraŋa kà, Yesu kà, apə̀h gay kà à azlaməna matapla la slaka aŋha dadàŋ, masla agòɗ à atà: “Nə̀ŋàwla gəl aŋkul, kà tatak makəsliŋ aŋa azla Farisəya, uwaga asal magoɗay kà: Magolla dza aŋatà. ");
INSERT INTO mfh_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tatak maha­ɗe­həŋ à ahəŋ gà gesina, adàgay mapəhla vok ala gà, ŋgaha tatak nasiri gà gesina adàgay masəlayga la dazu­waya. ");
INSERT INTO mfh_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kəla tatak uwana kaɗa­hawwaŋ la mələs la abà kà, adàtsənla la paraka, ŋgaha tatak uwana kà ŋoŋu­zawla la gəl la gəl la kay kà, uwaga adàgay bokuba mawiy­laga la gay azàŋ.” ");
INSERT INTO mfh_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Gəgoɗay kà akul, azlaməna gay ləv gulo, guba akəs akul kà azla­uwana takəɗ sləɓ vok aw. Kà uwana tatak anik la ahəŋ taɗehəŋ à uwana aɗuwa uwaga aw! ");
INSERT INTO mfh_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ama aganay gəpehakulla, dza uwana kahoyaw guba, kà masla: Guba akəs akul kà Zəzagəla, kà uwana mok adakəɗ akul kà, asla kà maduw vok aŋkul à akàl uwana à abà, adà­ma­tsila aw kəla, iyay, masla la uwana kahoyaw guba aŋha pəra.” ");
INSERT INTO mfh_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Tak ma taslala vok aŋa maduw dəgtsetsek zlo ala, kà aŋa sili səla aw takay? Iyay, te­ke­ɗika amiyaka tekula aŋatà kà azila la huma Zəzagəla aw. ");
INSERT INTO mfh_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Amiyaka aŋidz taka­sa­gəl aŋkul gesina kà, Zəzagəla asəl, la tekula tekula gesina aŋha. Guba akəs akul aw, kà uwana kaɗuwaw azla­dəgtsetsek gesina la manəŋla akul à adi.” ");
INSERT INTO mfh_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Haɗay, gəgoɗ à akul la dziriga: Baŋa dza agoɗay: ‘Gi aŋa Yesu la paraka’, ‘Aŋulo’, Kona aŋa dza adà­goɗay la huma aŋa azla­ma­lika aŋa Zəzagəla lakəl aŋha bay. ");
INSERT INTO mfh_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ama baŋa dza apəhay mawi­siga lakəl kà aŋa Kona aŋa dza, Kona aŋa dza adàpəh mawi­siga lakəl aŋha suwaŋ, la huma aŋa azla­ma­lika aŋa Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Kəla dza uwana apəh mawi­siga lakəl aŋa Kona aŋa dza, adà­ma­tsalaŋ ala, ama kəla dza uwana agoɗàh à Masasəɗok Zəzagəla kà, masla adàɓəz mama­tsila tsakana aŋha aw!” ");
INSERT INTO mfh_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Mok uwana tadà­bayàh akul à azlagày madəv kuɗa à agu, baŋaw à huma aŋa azla­su­fəl, baŋaw à huma aŋa azla­gumna kà aŋa maɗahàh akul seriya à gəl kà, guba akəs akul à kà tatak uwana kadàpəhaw, kà matəf gəl aŋkul aw. ");
INSERT INTO mfh_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kà uwana la kaslà uwatà kà, uwana kadzugwaw aw kà, Masasəɗok Zəzagəla adàpəhakulla adàgay la paŋaw aŋkul la awtày.” ");
INSERT INTO mfh_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kiya uwaga dza anik la ahəŋ, la maham à ahəŋ dza la abà, agòɗ à Yesu: “Məŋga, gòɗ à deda gulo kà: ‘Vàhàw ləmana, uwana baba aŋkul asàk à akul à ahəŋ’, gòɗal.” ");
INSERT INTO mfh_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu awulàlla, agòɗal: “Zil, uwa à uwana afà à gi à ahəŋ, kà gi aŋa magay masla seriya aŋa mavà­ha­kulla tatak ala la deda aŋak uwa?” ");
INSERT INTO mfh_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kiya uwaga agòɗ à atà gesina: “Ɗahàw haŋkəli la gəl aŋkul lakəl aŋa mawoy ləmana, kà uwana sifa aŋa dza kà la magay la ahəŋ, amiyaka adàgay masla gorobu məŋga gà, aw.” ");
INSERT INTO mfh_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kiya uwaga Yesu apə̀h à atà gay la gay la abà uwanay la magoɗay: “Dza anik la ahəŋ uwana agà la azlaàlàk delga delga. ");
INSERT INTO mfh_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Masla adzugw la gəl aŋha, ‘Mana gəɗehəŋ mi: Tsa uwala slaka asləkà à gi aŋa matsakàh tatak may gulo à abà aw mi. ");
INSERT INTO mfh_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Lagwa kà, gəkalàh bəza vəɗa uwanay à ahəŋ gesina, ŋgaha gəŋalàh məŋga məŋgaga, ŋgaha gədà­tsakah azla­tatak gulo à abà gesina. ");
INSERT INTO mfh_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ŋgaha gədà­goɗay à gəl gulo: Kak la tatak aŋuvaw, lagwa adàgay kà aŋa mavay dəŋ; dùw ləv aŋak, zùw, ŋgaha sà, ràb aŋak, dùw asik à zagəla.’ ");
INSERT INTO mfh_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ama Sufəl Zəzagəla agòɗal: ‘Kak zil kuso­ŋuga! Zlahaw la vəɗ uwanay lakana kà kamətsay ma, ŋgaha ma adàgay ma aŋa uwa à tatak uwaga kaɗahaŋ à ahəŋ gesina uwa?’ ” ");
INSERT INTO mfh_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Kiya uwaga Yesu azàlàŋ à gel, agòɗ à atà: “Kiya uwaga à uwana dza uwana ahamà ləmana aŋa gəl aŋha à ahəŋ kà, masla kà, galepi la huma yewdi aŋa Zəzagəla aw.” ");
INSERT INTO mfh_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kà uwaga à uwana Yesu agòɗ à azlaməna matapla la slaka aŋha, “Kafawla kà gəl à ahəŋ kà tatak may uwana kadza­dza­rawla kà vok aw, baməraka lakəl aŋa tatak matsokw à abà babay aw. ");
INSERT INTO mfh_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sifa ma aɗuwa tatak may aw takay? Ŋgaha ma vok aɗuwa tatak matsokw à abà aw takay? ");
INSERT INTO mfh_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nərə̀zàw azla­kwakwak tsi: Uwala tasləkay aw, ŋgaha tatsəɗay babay aw, vəɗa aŋatà la ahəŋ, kà aŋa lebəŋ aw. Ama Zəzagəla adzadzar atà, akul ma kaɗu­wawwaŋ azla­kolaŋ uwaga aw takay? ");
INSERT INTO mfh_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Uwa la tataka aŋkul la abà aslala vok aŋa maziŋ à mavay aŋa mamətsay aŋha à adi amiyaka ŋuv la aslasl gəl aŋha uwa? ");
INSERT INTO mfh_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ŋgaha ma, tsa baŋa azlabəza tatak babay kà, kaslawwalla vok aw ma, kà mana kafawla kà gəl à ahəŋ lakəl aŋa azla­tatak anik anik deyday ma? ");
INSERT INTO mfh_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nərə̀zàw bokuba uwana azla­ma­wu­ra­tatay aŋa guf tazigənay tsi: Taɗàh sləray aw, ŋgaha tavavəɗ slewzi kà aŋa lukut babay aw. Ama la dziriga gəgoɗ à akul kà: Amiyaka bà Salomon uwana akòr ləmana aŋha aŋuvaw babay kà, aɓəzà à lukut bokuba aŋa azla­ma­wu­ra­tatay uwaga tatsokw à abà aw. ");
INSERT INTO mfh_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iyay zlà, Zəzagəla adàw lukut à azlakəsaf à vok uwana à vok la fəta bay lakana, te­ke­ɗika atà kà lakana baŋaw lebəŋ kà taya­kats à akàl à gay: Ŋgaha ma adàgay anu uwanay babay takay? Kay akul la madiŋal gəl à vok matsi­hi­laga haɗay. ");
INSERT INTO mfh_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kiya uwaga kà, kafawla kà gəl à ahəŋ, la uwana kadà­zuwwaw, la uwana kadàsaw aw, ŋgaha kagahaw azlaadi aw. ");
INSERT INTO mfh_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kà uwana uwaga kà, say azladza uwana tasəl Zəzagəla aw, la uwana tayàh tatak uwaga koksi­koksi. Ndzer Baba aŋkul uwana la zagəla la afik kà asəl tatak uwana kanaw­kuɗa aŋha gesina. ");
INSERT INTO mfh_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Fàwla kà gəl à ahəŋ dadàŋ teraŋa kà, kà makoray Zəzagəla, la lig la ahəŋ kà masla adàkəs akul à ahàl ala dèwdèw tatak uwana kana­vawwal.” ");
INSERT INTO mfh_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Maham à ahəŋ bəziga, guba akəs akul aw, kà uwana asa à Baba kà masla aŋa mav à akul makoray aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Dàwàw azla­tatak aŋkul ala, vàhàw sili gà à azlaməna kuɗa à uda. Pàkàw vok ankul ala kà kiwa sili uwana sili adəv à lag la aku aw, ŋgaha ləmana uwaga awisila la zagəla aw aw. Kà uwana la abatà kà, masla à gəl ad à abatà aw, marzaw la fafay bay awisəŋ ala aw. ");
INSERT INTO mfh_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kà uwana slaka uwana ləmana aŋak la abatà kà, la abatà bay kà, ləv aŋak adz à ahəŋ babay suwaŋ!” ");
INSERT INTO mfh_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Gàw maɗàh vok à ahəŋ gà, wàɗàhàw para­para aŋkul à tsəh lela, ŋgaha bay fənəs aŋkul agàh mavats à ahəŋ gà. ");
INSERT INTO mfh_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Gàw bokuba azla­ma­gamza uwana takud məŋga aŋatà ala, à baŋa ahàd à mazəɓ mis, kà atà mapəzlal gamagày la mok uwana maza­lahay aŋha adàsa à waŋ. ");
INSERT INTO mfh_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Marabay à gay kà la azla­ma­gamza uwana məŋga aŋatà atsa à waŋ, aɓəz atà à gəl la adi. La dziriga gəpəh à akul kà, məŋga aŋatà adàwaɗ para­para aŋha à tsəh, ŋgaha adàdzàh atà madzay, kà mavàh à atà tatak may la gəl aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Baŋa məŋga aŋatà asa à waŋ la tataka vəɗ, adàɗuw uwaga babay, baŋa aɓəz atà à gel la adi kà, marabay agay la atà! ");
INSERT INTO mfh_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tsə̀ɓàw sləm à gay uwanay lela: Agayŋa zil gày asəl kaslà uwana masla à gəl atsa à waŋ kà, mazləl gày aŋha la vəɗ kà, naka masla kà naka adzehal aw huyip à ahən à ahəŋ la adi, kà mad à gay aŋha, aŋa masla à gəl aw. ");
INSERT INTO mfh_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Akul babay kà, gàw nekwa, kà uwana la mas à waŋ aŋa Kona aŋa dza babay kà adàgay kà bà kiya uwaga la gurùh!” ");
INSERT INTO mfh_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Kiya uwaga Piyer agòɗal: “Sufəl kà aŋami la uwana kapəhay gay la gay la abà uwaga, awma kà aŋa azladza gesina takay?” ");
INSERT INTO mfh_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kiya uwaga Sufəl agòɗal: “Kità ma, uwa à masla sləray dziriga, ŋgaha haŋkəliga uwa? Uwaga kà dza uwana məŋga aŋha afà à gəl aŋa azla­ma­gamza anik, kà masla aŋa mavàh à atà tatak may la kaslà uwana asa à atà. ");
INSERT INTO mfh_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Marabay agay la magamza uwana məŋga aŋha awul à waŋ, aɓəzal à gəl la sləray aŋha la abà. ");
INSERT INTO mfh_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Haɗay, gəpəh à akul la dziriga: Ndzer, zil gày adàvà ləmana aŋha à ahàl aŋha gesina. ");
INSERT INTO mfh_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ama baŋa magamza uwaga agoɗay la ləv aŋha la tsəh: ‘Məŋga gulo kà adà­safay’, ŋgaha adzəka makəsa­fər la mazlaɓàh azla­ma­gamza anik anik gesina, ŋgaha aday à mazuway à abà, à masay à abà, apaka masla guzu. ");
INSERT INTO mfh_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kiya uwaga kà, məŋga aŋha adàsa à waŋ la gurùh, la mavakay uwana adzugw mas à waŋ aŋa məŋga aŋha aw. Kiya uwaga kà, məŋga aŋha adàsal ŋgərpa, kà uwana akudàŋ ala aw, masla kà tadàfay kà à tataka aŋa azlaməna tsakana à abà.” ");
INSERT INTO mfh_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Te­ke­ɗika magamza uwana asəl tatak uwana asa à məŋga aŋha, akuda məŋga aŋha ala aw kà, aɗahàŋ kà bokuba uwana asa à gəl aŋha pəra, mazlaɓay adàslal məŋga. ");
INSERT INTO mfh_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ama kà aŋa magamza uwana asəl maɗàh uwana asa à məŋga aŋha aw, ŋgaha aɗàh sləray uwana agay tazlaɓla kà, tadà­zlaɓay kà ŋuv pəra, kà uwana asəl aw. Dza uwana tavàl tatak məŋga kà, la slaka aŋha kà, tanaval kà məŋga suwaŋ; ŋgaha aya dza uwana tafal à ahàl məŋga tadà­naval məŋga suwaŋ.” ");
INSERT INTO mfh_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesu agòɗ: “Gi kà, gəsà à waŋ kà, kà masəlla akàl à waŋ à gudəŋ à vok, ŋgaha asa à gi kà agay mavats vok gà. ");
INSERT INTO mfh_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Batem anik la ahəŋ tadà­ɗahgəŋ, nə̀ŋàw madz à ahəŋ gulo la mazaw la gəl la uwaga la abà tsi, gətərəɓay tsəràh adàpakà vok. ");
INSERT INTO mfh_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Akul ma, kagoɗaw ma, gəsəlla lapiya à kutso uwanay à abà, kagoɗaw takay? Awaŋ, gəgoɗ à akul, ama mavàhla la uwana gəsəlla à waŋ. ");
INSERT INTO mfh_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ɗahàw haŋkəli, dagay lakana, huɗ gày aŋa dza uwana atà zlo la kay, tadàtsak kəla azladza makər tadà­hamay à azladza səla à gəl, ŋgaha səla adàham à makər à gəl. ");
INSERT INTO mfh_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baba adàgola afaɗ à bəzi aŋha à gəl, iyà babay adàgola afaɗ à dugu aŋha à gəl, dugu bay adàgola afaɗ à iyà à gəl. Dzedzi misga adàgola afaɗ à kuhuwà aŋha à gəl, ŋgaha kuhuwà aŋha babay adàgola afaɗ à dzedzi aŋha misga à gəl.” ");
INSERT INTO mfh_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kiya uwaga Yesu agòɗ à maham à ahəŋ dza aya: “La mok uwana kanəŋaw habaga atsa à afik la matəɗ à ahəŋ afats, katskats kagoɗaw kà: ‘Iyaw adà­suway’, uwaga apakàhà vok, haɗay. ");
INSERT INTO mfh_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Baŋa kanəŋaw afaɗ aɗəɗay la gəl la aku, ‘Aŋuf adàgay la ahəŋ’, kagoɗaw, uwaga bay kà apakàhà vok, haɗay. ");
INSERT INTO mfh_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kay, akul kà akul azlaməna magolla dza, kasəlaw mavàh məlo uwana ala la vəɗah, ŋgaha la uwana la zagəla, ŋgaha ma kà mana katsənaw godega aŋa məlo uwanay lakana aw zlà ma?” ");
INSERT INTO mfh_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Kà mana akul la gel aŋkul kaɗahaw vok seriya à vok aŋkul à gəl kà madz à ahəŋ la dziriga la abà aw ma? ");
INSERT INTO mfh_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Baŋa dza apuwà à ka gudzi à gəl kà, la mok uwana akul à tetəvi la ama, kadaw à huma seriya akul səla kà, wàɗ vok à uda kà akul aŋa matsən vok gay səla, ŋgaha kà masla aŋa maf ka à ahàl aŋa masla seriya aw, ŋgaha bay kà masla seriya aŋa maf ka à ahàl aŋa azla­slodzi aw, ŋgaha kà azla­slodzi babay aŋa maduw ka à daŋay aw. ");
INSERT INTO mfh_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","La dziriga gəpəh à ka kà, kadàsa à uda la abatà aw, say baŋa katsa­tsakwàh azla­ma­təm à ahəŋ sili aŋak à waŋ gesina dadàŋ!” ");
INSERT INTO mfh_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","La kaslà uwatà, azladza anik tasà à waŋ kà mapəh à Yesu gay lakəl aŋa azla Galili, uwana Pilatus akə̀ɗ atà, à mok uwana tahàd kà maf tatak aŋatà à slaka mav tatak à Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu agòɗ à atà: “Haɗay, ma kadzugwaw ma azla Galili uwaga ma: ‘Taɗahàŋ mawi­siga uwana aɗuwa aŋa azla Galili anik uwanay,’ kagoɗaw takay? ");
INSERT INTO mfh_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Awaŋ, gəgoɗ à akul gesina, baŋa kapəhaw gay la ləv ala aw kà, akul gesina kadà­zahawla bokuba aŋatà babay. ");
INSERT INTO mfh_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Iyay zlà, azladza kulo gəl aŋha mtəgis uwana məŋ gày la gudəŋ Silowe atə̀ɗ à gəl, adza­màhà atà ala ma, akul ma, la madzugway aŋkul ma, azlaməna tsakana taɗuwà azlaməna gudəŋ Uru­sa­lima anik kagoɗaw takay? ");
INSERT INTO mfh_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kay! Awaŋ, gəgoɗ à akul, ama baŋa kapəhaw gay la ləv ala aw kà, akul gesina kadà­matsaw à gay bokuba atà babay.” ");
INSERT INTO mfh_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kiya uwaga Yesu apəh à atà gay la gay la abà uwanay la magoɗay: “Dza anik la ahəŋ, gudəv la guf matavəruk aŋha la abà. Masla atsìzlla ala, ahàd kà mayàh mayyay la vok aŋha, ama aɓəzal aw. ");
INSERT INTO mfh_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Masla à dza aŋa guf, agoɗ à masla mapəs guf aŋha: ‘Kay, nə̀ŋàŋ tsi, dagay mavay makər gəsàhà waŋ kà mayàh mayyay la vok aŋha, ama gəɓəzal aw, adadza à slaka à gəl deyday, kiya kà, gəkəsay aya aw, nàts à ahəŋ.’ ");
INSERT INTO mfh_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ama masla mapəs guf agoɗal: ‘Məŋga gulo, kamkam, sàkal la viya uwana aya, gədàla à tsəh aŋha gədàtəkal vəraw à tsəh dadàŋ. ");
INSERT INTO mfh_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Baŋa gədà­ɗe­həŋ kiya uwaga kà, zlahaw kà adàyyay, nərə̀z tsəràh à kà vuɗ anik, baŋa ayya aw kà: Kadà­nats à ahəŋ!’ ” ");
INSERT INTO mfh_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","La vuɗ maduw ləv, vərdi anik, Yesu adzəkà matapla tatak à azladza la gày madəv kuɗa la aku. ");
INSERT INTO mfh_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","La abatà aga la ahəŋ mis masla ɗuvatsga, uwana agà makəlàh à vəɗah gà dagay mavay kulo gəl aŋha mtəgis. Masasəɗok mawi­siga ada­ka­lahal gay à vok, aslàlla à vok aŋa matsizlla ala aw. ");
INSERT INTO mfh_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Mok uwana Yesu anəŋà mis uwaga azàlal la magoɗal: “Lagwa kà, wùr ala la ɗuvats aŋak la abà!” ");
INSERT INTO mfh_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Aɓə̀kal ahàl à gəl, ŋgaha la katskats, mis atsìzlla ala, ŋgaha adzəkà mazləɓ Zəzagəla la matsəkay. ");
INSERT INTO mfh_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ama məŋga aŋa gày madəv kuɗa kà, gəl akàɗal à vok, ləv avàlal à gay kà mawur dza ala uwana Yesu awuràŋ ala vuɗ maduw ləv. Agòɗ à maham à ahəŋ dza: “Mavakay mukwa la ahəŋ la tsəh aŋa kasukwa, à uwana dza aslala vok aŋa maɗàh sləray. Sàhàwwàŋ, tawarakulla la azla­ma­vakay uwaga la tsəh, awkà kasawwaŋ kà mawarakulla la mavakay maduw ləv aw!” ");
INSERT INTO mfh_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","“Iyay”, Sufəl Yesu agòɗ à atà: “Akul azlaməna magolla dza, kəla uwa­be­yuwi aŋkul ma apàlàh sla aŋha ala baŋaw ziwŋŋu aŋha ala la vuɗ maduw ləv kà madla atà à iyaw à abà aw takay? ");
INSERT INTO mfh_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ŋgaha ma baməraka mis mayyi à tsəh ala aŋa Abəraham, uwana tak seteni adatsiŋ à sasala aŋha à abà mavay kulo gəl aŋha mtəgis, ŋgaha ma azlayla kà vok aŋa mapələŋ ala la sasala aŋha la abà la vuɗ maduw ləv aw takay?” ");
INSERT INTO mfh_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mawul à uda aŋa Yesu uwaga akə̀lla ziruwi à azlaməna məzam aŋha à gəl gesina; ama maham à ahəŋ dza tagà la marabay məŋga kà azlasləray nadzipo uwana Yesu aɗa­hàhàŋ. ");
INSERT INTO mfh_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Apə̀h à atà gay la gay la abà anik, agòɗ à atà: “La mana makoray Zəzagəla adəɓani vok ma? La mana à uwana gəga­gazləla ma?” ");
INSERT INTO mfh_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yesu agòɗ: “Makoray Zəzagəla kà, gəga­gazləla la tsəhay hamadz uwana atsà à uda la lig gày aŋa dza: Azigənay, apaka magol ahàf, tsəràh à uwana azla­ɗiyaŋ tasaha à waŋ kà maŋalàh gày aŋatà à afik.” ");
INSERT INTO mfh_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kiya uwaga Yesu agòɗ à atà aya: “La mana gəga­gazləla makoray Zəzagəla ma? ");
INSERT INTO mfh_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Makoray Zəzagəla kà kalkal la tatak maməsl tatak ala, uwana mis akotsəŋ à pə̀hàw dogum zlo à tsəh, uwana aɗàh kilo dzik səla gəl aŋha səla, tsəràh à uwana amə̀sl magol pə̀hàw uwaga ala gesina.” ");
INSERT INTO mfh_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","La maday aŋha la abà à Yesu kà, aguwàhà à uda la azlaməŋ gudəŋ la abà, la azlabəza gudəŋ la abà gesina, ŋgaha la matapla tatak à azladza la tetəvi aŋa maday à Uru­sa­lima la ama. ");
INSERT INTO mfh_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kiya uwaga dza anik anav: “Məŋga, kà mana azladza ŋuv pəra tadàɓəlay ma?” Ama Yesu agòɗ à atà: ");
INSERT INTO mfh_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Wàɗàw vok à uda kà mad à gày la gamagày slərkuts­kutsga uwaga; la paraka gəpəh à akul kà, azladza aŋuvaw tadàyah aŋa mad à gày la abatà, ama tadàslay aw.” ");
INSERT INTO mfh_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Agòɗ à atà: “La mok uwana zil gày ada­tsizlla ala adatsak à gamagày à ama kà, akul uwana la uda kadà­dzawka maza­lahay la magoɗay: ‘Sufəl, Sufəl, pə̀zl anu à ama ala.’ Ama masla adà­tsizlla ala, adàgoɗ à akul: ‘Akul gesina uwaga, gəsəl slaka uwana kaguwàŋ la abà aw, gəsəl akul aw.’ ");
INSERT INTO mfh_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ŋgaha kadà­go­ɗawwal: ‘Məzàw tatak məsàh tatak gesina kà la slaka gà anina, ŋgaha aya katà­pàhànula tatak la azla­gu­dəŋ gami la abà.’ ");
INSERT INTO mfh_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ŋgaha aya adàgoɗ à akul: ‘Gəsəl akul aw, gəsəl slaka uwana kaguwàŋ la abà aw, zàw gi vok akul gesina aŋkul, uwana kaɗahàw mawi­siga.’ ");
INSERT INTO mfh_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","La abatà la uwana kadà­tawaw, la mapaɗ sliɗ la tsəh ala təra­wawa, la mok uwana kadànəŋaw Abəraham, Isak, Yakuba, ŋgaha la azlaməna mapəh à atà gay à ahàl, kà mapàh à azladza gesina la makoray Zəzagəla, te­ke­ɗika akul kà akul mawits akul à uda gà. ");
INSERT INTO mfh_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ŋgaha aya kà, azladza tadàsa à waŋ la tsəh la ahəŋ, la matəɗ à ahəŋ afats, la mas à afik afats ŋgaha la gəl la aku bay. Ŋgaha atà tadàɓəzal slaka madza madzay la tatak may lakəl la makoray aŋa Sufəl Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kiya uwaga azlaanik la tataka azlaməna huma la abà, tadàgay azlaməna lig, ŋgaha azlaanik la tataka azlaməna lig la abà bay kà, tadàgay azlaməna huma.” ");
INSERT INTO mfh_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","La kaslà uwatà kà, azla Farisəya anik tazà vok à slaka Yesu, ŋgaha tagòɗal: “Dà aŋak la abanay. Hàd à slaka anik kà uwana Herod asal makəɗ ka!” ");
INSERT INTO mfh_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ŋgaha Yesu agòɗ à atà: “Dàw, kadàpəhaw à hayyàŋ uwaga kà kiya uwanay: Aganay gəkuɗə̀kàh azla­ma­sasəɗok mawi­siga la mawar azladza ala lakana, lebəŋ, ama la mavakay makər aŋha kà gədàkəɗ gəl à sləray gulo. ");
INSERT INTO mfh_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ama kəla kà, say gətsizlla ala lakana, lebəŋ, la vuɗ uwahà, kà uwana akəsa vok kà aŋa masla mapəhal gay à ahàl aŋa Zəzagəla aŋa maməts à uda aŋa huɗ gudəŋ Uru­sa­lima aw, say la huɗ gudəŋ Uru­sa­lima kəla.” ");
INSERT INTO mfh_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Uru­sa­lima, Uru­sa­lima kak la uwana kakàɗàh azlaməna mapəh à atà gay à ahàl aŋa Zəzagəla, uwana aslàlàh kà atà à waŋ gesina. Asik dəŋ gəda­yahah maham gay à azladza aŋak à vok la slaka gula, bokuba gotsak uwana ayàh maham gay azlabəza aŋha à vok, la tsəh gogozlàh aŋha. Ama kakə̀sàw aw. ");
INSERT INTO mfh_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Haɗay, lagwa kà, gày aŋkul adàpak ŋvagay. Ama gi kà, gəpəh à akul la dziriga kà, akul kadànəŋaw gi, tsəràh à kaslà uwana kadà­goɗaw kà: ‘Zəzagəla apis gay à dza uwana à vok, atsa à waŋ la sləm aŋa Sufəl Zəzagəla’, aw.” ");
INSERT INTO mfh_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Vərdi anik, Yesu ahàd à mtəga aŋa tekula aŋa məŋga aŋa azla Farisəya la vuɗ maduw ləv, kà mazuw tatak may. Azladza uwana la abatà, tanərə̀z Yesu lela. ");
INSERT INTO mfh_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Dza anik la ahəŋ uwana makəsl vəɗah gà la abatà la huma aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu apə̀h gay à azlaməŋga aŋa azlaməna mapəhla mapəhay ala la azla Farisəya: “Wakità mapəhay gami ma avà tetəvi kà mawur dza ala la vuɗ maduw ləv takay?” ");
INSERT INTO mfh_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ama asà à atà mawulla gay à uda aw. Kiya uwaga aɓə̀k ahàl à masla ɗuvats à gəl, awuràŋ ala, ŋgaha asàk à dza uwatà, adà aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yesu agòɗ à atà: “Uwa à uwana bəzi aŋha àŋkaw kokur aŋha atəɗ à suwa à abà ma la vuɗ maduw ləv kà, azəɓ à uda aw uwi?” ");
INSERT INTO mfh_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Dza la ahəŋ aslàla vok kà mawulla gay à uda lakəl aŋa uwaga aw. ");
INSERT INTO mfh_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iyay, la abatà Yesu anərə̀z maya­hani slaka aŋa azladza uwana tazàlàh atà à maham gay à vok à abà. Tayahay kà azla­slaka delga. Kiya uwaga apə̀h à atà gay uwaga: ");
INSERT INTO mfh_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Baŋa dza azàla ka à madəvaday mazəɓ mis à abà kà, kayàh slaka madza madzay delga gà dadàŋ aw. Zlahaw dza anik la ahəŋ, à uwana tazàlal à madəvaday uwaga à abà, aɗuwa ka bay ma? ");
INSERT INTO mfh_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ŋgaha kà pəra masla mazallàh akul atsa à waŋ, agoɗ à ka: ‘Kona, sàkla slaka uwaga à dza uwanay.’ La abatà kà, kak kà magol ziruwi adahama ka à gəl kà matsizlla ala la huma, kà mad à lig. ");
INSERT INTO mfh_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ama baŋa tazàla ka kiya uwaga kà: Hàd, kadza aŋak à madzay la lig. Kà uwana la mok uwana masla mazallàh akul adàda à awtày kà, adàgoɗ à ka: ‘Slawda, kak kà, zà vok à huma à gay la abanay’, la abatà kà, kà aŋak kà adàgay dzəɓa aŋha səla aw la huma azladza uwaga gesina, kà kak aŋa mad à huma à gay. ");
INSERT INTO mfh_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kà uwana kəla uwa­be­yuwi uwana azigən gəl aŋha kà, tadà­wulla ala à lig. Ŋgaha dza uwana awulla gəl à vəɗah kà, tadàdalla à huma.” ");
INSERT INTO mfh_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kiya uwaga Yesu agòɗ à dza uwana, azàlàh babay: “Iyay zlà, baŋa kavà tatak may, baŋaw kata kaf à uda kà, kazàllàh azla­slawda aŋak la azla­deda aŋak, baŋaw la azla­yaga aŋak, la azlaməna magay aŋak, uwana azla­ga­le­piga pəra aw. Way kà atà babay kà tadà­zalla ka vərdi anik, kà mazuw tatak, kà uwana baŋa tazàla ka kà bokuba tapə̀lla ka uwana à abà tazùw la mtəga anak suwaŋ. ");
INSERT INTO mfh_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ama baŋa kat kaf à uda kà, zàlàh kà azlaməna kuɗa, azla­ma­godu, azla­deri ŋgaha la azla­gu­ləf pəra. ");
INSERT INTO mfh_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kità kà, kadàgay la marabay, kà uwana atà kà taslala vok aŋa mapəlla ka à abà aw. Uwaga kà Zəzagəla la uwana adàpəlla ka à abà la mavakay uwana adà­wulla azladza dziriga à uda la mamətsay.”‘ ");
INSERT INTO mfh_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mok uwana tatsə̀n gay uwaga kà, tekula la tataka aŋa azladza uwana la tatak may la adi, agòɗ à Yesu: “Tsa kətà kà, marabay agay la dza uwana adàzuw tatak may aŋha la makoray aŋa Zəzagəla!” ");
INSERT INTO mfh_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu agòɗ à atà: “Dza anik la ahəŋ, atà magol kaf à uda, ŋgaha azàlàh azladza aŋuvaw. ");
INSERT INTO mfh_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","La mok uwana tatak adahənay kà, aslə̀l magamza aŋha kà mazalàh azladza uwana tapàh à atà: ‘Sàw à waŋ, sàw à waŋ adagay, kà uwana tatak may kà adahənay!’ ");
INSERT INTO mfh_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ama gesina aŋatà tadzəkà manav kamkam la tekula tekula. Matera agòɗ à magamza: ‘Gi, gəsùkw guf kà, asa à gi, gəday kà manəŋəŋ, kamkam bàsgəŋ.’ ");
INSERT INTO mfh_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kiya uwaga masəla agòɗal aya: ‘Gəsùkw sla səɗuk zlo, gəday gədàgurla atà sləray, kamkam bàsgəŋ.’ ");
INSERT INTO mfh_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ŋgaha anik agòɗal aya suwaŋ: ‘Gi kà, gədazəɓ mis kà bà lagwa lagwa, kà uwaga à uwana gəslala vok aŋa manəf ka aw pəra.’ ");
INSERT INTO mfh_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kiya uwaga magamza awùl à slaka məŋga aŋha, apə̀hal uwana tapàhal gesina. La abatà kà, zil gày apàk ləv, la magoɗay à magamza aŋha: ‘Hàd, katskats à azla­va­da­vaday à afik, la azlagay barama à ama la huɗ gudəŋ la abà, ŋgaha hàd kasəlla azlaməna kuɗa à waŋ, la azla­ma­godu, la azla­gu­ləf ŋgaha la azla­deri gesina!’ ");
INSERT INTO mfh_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Zwek la huma, uwana uwaga adaɗaha vok kà, magamza asà à waŋ agòɗ à məŋga aŋha: ‘Məŋga, uwana kapə̀h kà, aɗahà vok, ama slaka atamà à ahəŋ bà gotənaŋ aya.’ ");
INSERT INTO mfh_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kiya uwaga məŋga agòɗ à magamza aŋha: ‘Lagwa kà, dàh à azlabəza mazləramàh tetəvi à ama, la azlalig zlagam, fàh à atà gasa à gəl, kà masəlla atà à waŋ kà aŋa mahənla aŋa gày gulo! ");
INSERT INTO mfh_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ndzer, gəpəh à akul la dziriga kà, azla­uwana gəzàlàh atà takwèsàh kà, tetuwa tadàtap tatak may gulo tetuwa aw.’ ” ");
INSERT INTO mfh_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Maham à ahəŋ dza aŋuvaw tanəfà Yesu la tsəh. Yesu agòla vok, ŋgaha agòɗ à atà: ");
INSERT INTO mfh_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Baŋa dza asal, manəf gi kà, say apəsew baba aŋha, la iyà aŋha, la mis aŋha, la azlabəza aŋha, la azla­deda aŋha ŋgaha amiyaka gəl aŋha dadàŋ. Tsa baŋa kiya uwaga aw kà, aslala vok aŋa magay masla matapla la slaka gulo aw. ");
INSERT INTO mfh_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kəla dza uwana akəs mamətsay aŋha, ŋgaha anəf gi aw kà, aslala vok aŋa magay masla matapla la slaka gulo aw. ");
INSERT INTO mfh_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Baŋa dza asal maŋal magol gày kà, say adza madzay dadàŋ, atugw tatak uwana adàziŋ ala gesina dadàŋ. Baŋa sili aslay kà mahənlaŋ ala, la uwana adzəka sləray. ");
INSERT INTO mfh_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Awkà baŋa adzəka maf godega à gày à ahəŋ pəra, uwala à adà­hənəŋ ala aw kà, kəla dza uwana adànəŋ gày uwana ahənla aw kà, tadàdzəka makəɗaslal. ");
INSERT INTO mfh_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Tadà­goɗay: ‘Nə̀ŋàw tsi, kona uwanay tsi: Adzəkà maŋal magol gày, uwala aslala vok aŋa mahənəŋ ala aw tsi!’ ");
INSERT INTO mfh_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kiya uwaga babay la sufəl uwana asal map guvəl la sufəl anik kà, say adza madzay dadàŋ, kà manərəzay à baŋa dza dəbow kulo aslala vok aŋa map guvəl la dza dəbow dzik səla. ");
INSERT INTO mfh_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Baŋa aslay aw kà, tsa sufəl anik uwanay aləg kərkər dadàŋ kà, say asləl gay kà manav masəl vok atà səla.” ");
INSERT INTO mfh_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yesu agòɗ kiya uwaga babay zlà: “Baŋa dza apəsew tatak aŋha gesina aw kà, aslala vok aŋa magay masla matapla la slaka gulo aw!” ");
INSERT INTO mfh_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“La haɗay gà kà, slugul kà tatak delga. Ama baŋa azlaɗay aya aw ma, kakay dza azlaɗəŋ ma? ");
INSERT INTO mfh_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Uwaga akəsa vok baməraka aŋa kutso aw, ŋgaha bay apàk arəguwa babay aw. Uwaga kà say maftukw ala pəra. Dza uwana sləm lakəl kà atsəɓal sləm lela zlà!” ");
INSERT INTO mfh_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","La abatà azlaməna mazəɓ hadama la azladza anik uwana madz à ahəŋ aŋatà kà lela aw kà, tazà vok à slaka Yesu kà matsəɓal sləm. ");
INSERT INTO mfh_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Azla Farisəya la azlaməna mapàhla mapəhay ala taŋoŋùz à tsəh ala kà atà kà atà la magoɗay: “Nə̀ŋàw, konnay akə̀s azlaməna tsakana kà la ahàl səla tsi, ŋgaha tazùw tatak may la slaka gà la atà nna tsi.” ");
INSERT INTO mfh_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kiya uwaga Yesu apə̀h à atà gay la gay la abà uwanay, agòɗ à atà: ");
INSERT INTO mfh_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Uwa la tataka aŋkul la abà uwana akor tuwaŋ dzim, ŋgaha tekula aŋatà azila à ama, asak à dzik ladəga gəl aŋha ladəga gà uwanay la fəta, kà masla aŋa mad mayàh tekula gà uwaga tsəràh à uwana aɓəzal aw uwi? ");
INSERT INTO mfh_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mok uwana adaɓəz tuwaŋ aŋha kà arabay, akəsay, af à kuda. ");
INSERT INTO mfh_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Mok uwana adà à mtəga kà, adzəka mazalàh azla­slawda aŋha la azlaməna magay aŋha, la magoɗ à atà: ‘Mərab anina, kà uwana gədaɓəzal tuwaŋ gulo uwana azalà.’ ");
INSERT INTO mfh_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kiya uwaga babay gəgoɗ à akul kà, marabay məŋga adàgay la zagəla la afik, kà aŋa masla tsakana tekula uwana apə̀h gay la ləv ala, aɗuwa dza dzik ladəga gəl aŋha ladəga gà uwanay, uwana: ‘Anu azla­dzi­riga’, tagoɗ.” ");
INSERT INTO mfh_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Awma mis ma uwala à uwana akor gursu kulo, ŋgaha tekula azilà à ama, kadzugwaw ma, avats fənəs, aslaɗ gày, ŋgaha ayahay la haŋkəli, tsəràh à uwana aɓəzal aw takay? ");
INSERT INTO mfh_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mok uwana adaɓəzal gursu aŋha kà, azàllàh azla­slawda aŋha la azla­ma­te­tegi aŋha gesina, ŋgaha agoɗ à atà: ‘Məràb anina, kà uwana gursu gulo uwana azalà kà gədaɓəzal adagay!’ ");
INSERT INTO mfh_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kiya uwaga babay, gəgoɗ à akul kà, marabay adagay la zagəla la afik, la slaka azla­ma­lika aŋa Zəzagəla, kà mapəh gay la ləv ala aŋa masla tsakana tekula, uwana atsà à huma aŋa Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kiya uwaga Yesu agòɗ aya: “Dza anik la ahəŋ agà la azlabəza səla. ");
INSERT INTO mfh_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kiya uwaga, mabəziga bəziga agòɗ à baba aŋha: ‘Baba và à gi humà ləmana, uwana adàgay aŋulo!’ Kiya uwaga baba avahà ləmana à azlabəza aŋha səla ala. ");
INSERT INTO mfh_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mok uwana adahəni à ahəŋ ŋuv, mabəziga bəziga adàw humà makoray aŋha ala, adà aŋha kərkər la sili gà. La abatà azà sili aŋha ala la mago­gotsay aŋa gudəŋ à vok la abà gesina. ");
INSERT INTO mfh_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kiya uwaga, mok uwana adakəɗ tatak aŋha gesina kà, magol may adzəkà vok la gudəŋ uwatà la abà, ŋgaha adzəkà mawoy tatak, ama tatak la ahəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Masla ahàd à mtəga dza anik aŋa gudəŋ uwatà la abà uwana aslə̀l à guf aŋha à abà kà manəŋla azla­namzi. ");
INSERT INTO mfh_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Masla kà ayàh kà bà mahən huɗ aŋha ala, la azla­ma­ho­la­hola uwana azla­namzi tapaɗay, ama dza la ahəŋ avàl aw. ");
INSERT INTO mfh_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Təh, awùlal à gəl lakəl aŋa madz à ahəŋ aŋha uwana uwarà, agòɗ: ‘Azlaməna sləray aŋa baba gulo kà tatak may aɗuwa atà, ama gi kà, masla la uwanay gəmətsay kà may ma, kakay ma? ");
INSERT INTO mfh_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Lagwa kà, ŋuləm, gəda à mtəga baba gulo gədà­goɗal: Baba, kamkam gəɗahà mawi­siga à Zəzagəla à vok, ŋgaha à kak à vok bay. ");
INSERT INTO mfh_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Baba, lagwa kà, azlayla kà vok kà mazal gi ala bəzi aŋak aya aw! Ama lagwa kà, fà à gi à ahəŋ bokuba gi magamza aŋak!’ ");
INSERT INTO mfh_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","La abatà kà atsìzlla ala, kà mad à mtəga baba aŋha.” “Mok uwana alə̀g kərkər la gày aŋa baba aŋha kà, baba aŋha anəŋàŋ kà, atsa à waŋ. Ŋgaha vok ahamàl kaykay. Hadzak, asà à afik, atsə̀ɗal à ama, avàl kà, akəsà vok la marabay. ");
INSERT INTO mfh_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Bəzi uwaga agòɗal: ‘Baba, kamkam gəɗahà mawi­siga à Zəzagəla à vok, ŋgaha à kak à vok. Lagwa kà, azlayla kà vok kà mazalgəla bəzi aŋak aya aw!’ ");
INSERT INTO mfh_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ama baba agòɗ à azla­ma­gamza aŋha: ‘Katskats, sàwla dawara delga à waŋ, kaduwal à vok; fàwwal dzeɗa à ahàl, ɓə̀kàwwal kwimik à asik. ");
INSERT INTO mfh_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Lagwa kə̀sàw vəlik magagseyga à waŋ, kakəɗaw, məpàɗ ŋgaha məràb, ");
INSERT INTO mfh_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","kà uwana bəzi gulo uwana agà bokuba mamətsayga kà aganay, adawul à uda la sifa aya, azalà, ama adagay maɓəzalga.’ Ŋgaha kiya uwaga tadzəkà marabay.” ");
INSERT INTO mfh_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Te­ke­ɗika magol bəzi aŋha kà, agà la fəta. La mok uwana atsà à waŋ la fəta, uwana adagay nekwa la gày kà, atsənà talakway la azladəs la madəvaday gesina. ");
INSERT INTO mfh_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Magol bəzi uwaga azàla magamza tekula, anàvalla gay ala: ‘Mana ma à uwaga adadzəka vok la mtəga gami ma?’ ");
INSERT INTO mfh_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kiya uwaga magamza agòɗal: ‘Deda aŋak kà adawul à waŋ. Masla gà la uwaga, baba aŋak akə̀ɗ vəlik magagseyga uwatà, kà uwana awùlla à waŋ la wurwur.’ ");
INSERT INTO mfh_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nə̀ŋ, adzəkà mapak ləv, ŋgaha akə̀s mad à gày aya aw. Kiya uwaga baba aŋha asà à uda, adə̀val kuɗa kà mad à gày. ");
INSERT INTO mfh_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ama masla agòɗ à baba aŋha: ‘Baba, mavay dəŋ à uwana gi la slaka aŋak, didi gəda­kweska mapəhay aŋak aw. Ama bà məzezak babay kà, kavà à gi aŋa marabla la azla­ma­nalay gulo aw! ");
INSERT INTO mfh_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ama baŋa kà aŋa bəzi aŋak uwanay ada­dadas tatak aŋak ala la zlapay la tsəh, ŋgaha ada­wulla à waŋ kà, kakə̀ɗal vəlik uwana məgagsàŋ aya ma kà mana ma?’ ");
INSERT INTO mfh_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ama baba agòɗal: ‘Bəzi gulo, iyay, kak la ahəŋ koksi­koksi la gi, gəsəl. Kasəl kà, dèwdèw tatak uwana gəkoray kà uwaga kà aŋak aw takay? ");
INSERT INTO mfh_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ama lakana kà, akəsà vok kà, məvalàh à zagəla, la mahab madəvaday, kà uwana deda aŋak uwana agà bokuba mamətsayga kà, aganay ada­wula à uda la sifa aya, azalà ŋgaha adagay maɓəzalga aya kà uwaga à uwana mərabay!’ ” ");
INSERT INTO mfh_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kiya uwaga Yesu agòɗ à azlaməna matapla la slaka aŋha aya: “Dza galepi gà la ahəŋ uwana agà la magamza lakəl aŋa ləmana aŋha gesina. Ŋgaha azladza tasàhàla gay uwana à waŋ, magamza aŋha uwaga aɗa­ha­həŋ la tatak aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Məŋga aŋha azàlal, agòɗal: ‘Mana ma à uwana gətse­nəŋ lakəl aŋak ma? Iyay, tùgw à gi godega aŋa sləray aŋak lagonay, kà uwana kadàgay magamza gulo aya aw!’ ");
INSERT INTO mfh_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Magamza adzugw la gel aŋha, agòɗ: ‘Aga, məŋga gulo azəɓ gi à tatak aŋha lakəl ala ma, mana ma à uwana gəɗehəŋ lagwa zlà ma? Mapəs guf, ndzəɗa gulo la ahəŋ aw. Matsatsàh tatak babay, ziruwi. ");
INSERT INTO mfh_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Iyay, təga, gəsəl uwana gədà­ɗe­həŋ à mok uwana adàzəɓ gi à tatak aŋha lakəl ala. Azladza la ahəŋ à uwana tadàfa à gi à ahəŋ à mtəga aŋatà.’ ");
INSERT INTO mfh_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kiya uwaga azàlàh azladza uwana goder aŋa məŋga aŋha agàhà à atà la vok tekula, tekula. Agòɗ à matera: ‘Nna à goder aŋa məŋga gulo, uwana agà kà la vok ma?’ ");
INSERT INTO mfh_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Amàl kuvu goŋgoŋ dzim’, agòɗal. Magamza agòɗal: ‘Wakità aŋa goder aŋak kà, aganay, dzà madzay katskats, katsetser goŋgoŋ dzik zlo!’ ");
INSERT INTO mfh_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ŋgaha anavà dza anik aya: ‘Kak ma, nna aga kà la vok ma?’ ‘Nalkama nesesa dadərmokw zlo.’ Magamza agòɗal: ‘Kak bay kà, aganay à wakità aŋa goder aŋak: Tsetsèr dadərmokw ufaɗ!’ ");
INSERT INTO mfh_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kiya uwaga məŋga aŋha, azləɓà magamza kaskasga uwana aɗahà uwaga gesina la ɗemɗem, kà uwana azladza aŋa gudəŋ à vok lakana taɗuwa à azladza aŋa uɗaka la katskats la sləray aŋatà la abà.” ");
INSERT INTO mfh_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu azàlàŋ à gəl, agòɗ à atà: “Kə̀sàw vok slawda la azla­ləmana aŋa gudəŋ à vok uwanay, ŋgaha kà vuɗ uwana kadàɓəzaw à tatak aw kà, tadàkəs akul à slaka madz à ahəŋ, uwana adəv à gay aw. ");
INSERT INTO mfh_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kà uwana dza uwana dziriga la azlabəza tatak la abà kà, masla kà dziriga la azlaməŋ tatak la abà babay. Ŋgaha dza uwana kaskas la azlabəza tatak la abà kà, masla kaskas la azlaməŋ tatak la abà bay. ");
INSERT INTO mfh_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tsa baŋa akul kagaw dziriga la tatak uwana la abà, tafà à akul à ahàl la gudəŋ uwanay la vok aw, ma uwa à uwana adàfa à akul ləmana dziriga à ahàl zlà ma uwa? ");
INSERT INTO mfh_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Baŋa akul kagaw dziriga la ləmana aŋa azladza anik aw, ma uwa à uwana aslala vok mav à akul ləmana aŋkul uwa?” ");
INSERT INTO mfh_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kiya uwaga dza la ahəŋ atsəp azlaməŋga səla à huma à gay aw: Apəsew anik, ŋgaha akəs gay aŋa anik; awoy anik, ŋgaha akweska anik. Kiya uwaga babay zlà, kaslawwalla vok kà matsəp Zəzagəla à huma la sili aw.” ");
INSERT INTO mfh_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Azla Farisəya tatsənà gay uwaga gesina, takəɗàsl à Yesu, kà uwana atà kà, azlaməna mawoy sili məŋga. ");
INSERT INTO mfh_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kiya uwaga Yesu agòɗ à atà: “Akul kà: ‘Anu azladza dziriga’, kagoɗaw la huma aŋa azladza la maɗàh gasa. Ama Zəzagəla asəl madzugway aŋkul. Uwana azladza tanərəz bokuba tatak məŋga gà kà, la huma Zəzagəla, kà uwaga kà bokuba tatak deydayga pəra.” ");
INSERT INTO mfh_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Azlaməna mapəh à atà gay à ahàl la azla­mapəhay aŋa Musa tapàh gay lakəl aŋa makoray Zəzagəla tsəràh à kaslà aŋa Yuhana masla maɗàh batem. Dagay la mok uwatà kà, kəla uwa­be­yuwi aɗàh gasa kà mad à makoray Zəzagəla à abà. ");
INSERT INTO mfh_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Zagəla la kutso kà adəv à gay la butu, à kà matəɗla aŋa mapəhay ŋuvga la wakità Zəzagəla la abà.” ");
INSERT INTO mfh_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kəla dza uwana akuɗək mis aŋha, ŋgaha azəɓ anik kà adada à gəl gaw, ŋgaha dza uwana azəɓ mis uwana zil aŋha akuɗəkay babay kà, adada à gəl gaw suwaŋ.” ");
INSERT INTO mfh_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Dza galepi anik la ahəŋ, uwana atsakwàh à diri mativga à abà uwana tsa­kalay aŋatà kà zla­zlaɗa. Masla kà adzàhà à ahəŋ kà say la matsiɗay la abà pəra. ");
INSERT INTO mfh_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","La abatà kà, masla kuɗa anik la ahəŋ uwana sləm aŋha Lazar. Vok aŋha gesina kà bà amik amik tsa­tsa­basla. Adzàhà à ahəŋ la slaka mahən à ahəŋ la gay gamagày aŋa galepi. ");
INSERT INTO mfh_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Asal mahən huɗ aŋha ala la azla­tatak may mapətsèh pətsèhga, uwana atàɗ à ahəŋ la table aŋa galepi uwaga la afik, ama aslà aw. Ŋgaha aya kà, azlakəda tasàhà à waŋ kà mamətəɗàh amik aŋha uwaga la abatà kà, azàhə̀ŋ kaykay. ");
INSERT INTO mfh_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Masla kuɗa uwatà amə̀ts, ŋgaha azla­ma­lika tasà à waŋ, tazə̀ɓ masla, tadàlla à slaka Abəraham la zagəla. La lig la ahəŋ kà, galepi uwaga amə̀ts suwaŋ, talà, tatùw lela. ");
INSERT INTO mfh_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Galepi uwaga kà asà ŋgərpa məŋga la mezewi. La matərəɓay aŋha la abà kà, anəŋà à zagəla kərkər kà, anəŋà Abəraham la Lazar la slələf aŋha lakəl. ");
INSERT INTO mfh_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ŋgaha masla adzəkà maza­lahal la magoɗay: ‘Baba Abəraham, vok ahamà ka kà gi, slə̀l Lazar à waŋ, atàp gay gəl ahàl aŋha à iyaw abà, kà matas­gəla alàh gulo, kà uwana gəs ŋgərpa məŋga la gày akàl uwanay la abà.’ ");
INSERT INTO mfh_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ama Abəraham agoɗal: ‘Iyay bəzi gulo, dzùgw tsi, kazùw matsiɗay la mok uwana kalə̀g la sifa, ama Lazar kà asà ŋgərpa məŋga. Lagonay kà, adaɓəz à matsiɗay suwaŋ la abanay, ŋgaha kà kak, kadaɓəɗ à matərəɓay à abà. ");
INSERT INTO mfh_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ŋgaha aya kà, la tataka gami la abà la akul kà, magol afək zəŋzəŋga la ahəŋ; avahanula. Azladza uwana la slaka gami la abanay taslala vok aŋa mad à uda à slaka aŋkul aw, ŋgaha azla­uwana la slaka aŋkul taslala vok aŋa mas à gay babay à slaka gami aw.’ ");
INSERT INTO mfh_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Galepi agòɗ: ‘Kamkam, baba Abəraham, slə̀l Lazar à mtəga baba gulo, ");
INSERT INTO mfh_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kà uwana azla­deda gulo la ahəŋ zlo aya, kà masla aŋa mapəh à atà à vok à abà, kà atà aŋa mas à waŋ à slaka uwanay gi la abà aw.’ ");
INSERT INTO mfh_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ama Abəraham agòɗal: ‘Musa la azlaməna mapəh à atà gay à ahàl kà tapəh à atà. Say takəs gay aŋatà pəra!’ ");
INSERT INTO mfh_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Galepi agòɗal: ‘Awaŋ, baba Abəraham, diga aw. Ama baŋa dza awul à uda la mamətsay, ahàd, la uwana tadàkəs gay aŋha, ŋgaha tadàpəh gay la ləv ala.’ ");
INSERT INTO mfh_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kiya uwaga Abəraham agòɗal: ‘Baŋa tatsəna gay aŋa Musa la azlaməna mapəh à atà gay à ahàl anik aw kà, amiyaka bà dza uwana awùlla à uda la mamətsay, adàday babay kà, tadà­tsən gay aŋha aw’ ”, kiya uwaga Yesu apə̀h à atà. ");
INSERT INTO mfh_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu agòɗ à azlaməna matapla la slaka aŋha: “Tatak uwana adà­dahla azladza à tsakana à abà la ahəŋ koksi­koksi. Ama ŋgərpa adàgay la dza, uwana aɗàh uwaga. ");
INSERT INTO mfh_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ŋuləm tawaɗal dzəgla à kuda, taduw à dərəv à abà, à kà uwana adukw tekula aŋa azlabəza uwanay à tsakana à abà. ");
INSERT INTO mfh_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ɗahàw haŋkəli lela!” “Baŋa deda aŋak aɗaha tsakana kà, pə̀hal la tələmma; baŋa atuw lakəl aŋa tsakana aŋha kà, matsallaŋ ala. ");
INSERT INTO mfh_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Baŋa aɗahà à ka tsakana à vok asik məɗəf la mavakay la tsəh, pəra kəla maɗàh tsakana kà, atsa à waŋ atuway lakəl aŋha kà, matsallaŋ ala gesina.” ");
INSERT INTO mfh_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Azlaməna matapla tagòɗ à Sufəl: “Zànula madiŋal gəl à vok gami à gəl!” ");
INSERT INTO mfh_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Sufəl agòɗ à atà: “Agayŋa la madiŋal gəl à vok aŋkul à gay la ahəŋ bakət tsəhay hamadz kà, naka: ‘Ɓə̀ɗà vok ala la abanay, hàd kadà­tsəɓ vok à dərəv à abà!’, kagoɗaw à gudəv kà, naka uwaga kà apakakulla vok, kà uwana akul la madiŋal gel à vok.” ");
INSERT INTO mfh_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Uwa la tataka aŋkul la abà, à uwana magamza aŋha apə̀s guf baŋaw anə̀ŋla azla­tatak kà, la mok uwana adasa à waŋ la fəta kà: ‘Sà à waŋ katskats, kadza à tatak may à gəl’, agoɗal uwa? ");
INSERT INTO mfh_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Awaŋ, ama agoɗal kà: ‘Ɗàh gi tatak may, ɓə̀ɗla lukut, kà mav à gi tatak may la tatak masay, la lig la ahəŋ kà pəra, kak kadàdzəka mazuw tatak, la masay suwaŋ.’ ");
INSERT INTO mfh_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kagoɗaw ma, ‘Kikay’, agoɗ à masla sləray uwana aɗa­hàlla kiya uwanay kagoɗaw takay? Awaŋ, uwaga kà sləray aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Akul babay kà kiya uwaga: Mok uwana kada­ɗahaw uwana tapə̀h à akul gesina kà, gòɗàw kà: ‘Anu azlaməna sləray dey­dayga pəra’, gòɗàw; ‘Məɗahàŋ kà uwana uwaga kà, agay kà sləray gami pəra’.” ");
INSERT INTO mfh_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","La mok uwana Yesu adà à Uru­sa­lima kà, aguwà la gay makwi aŋa Sama­riya atà la Galili. ");
INSERT INTO mfh_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","La kaslà uwana masla azlàdà à huɗ gudəŋ anik à abà kà, azlaməna akàl zagəla kulo tagagam la masla. Tatsàzl à fəta à awtày. ");
INSERT INTO mfh_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ŋgaha tazà kuda à zagəla la mawiyay: “Yesu, məŋga, vok ahama ka kà anu!” ");
INSERT INTO mfh_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Masla anərə̀z atà, agòɗ à atà: “Dàw kadà­pəhawla vok aŋkul à azlaməna mav tatak à Zəzagəla!” La mok uwana atà la asik lakəl kà maday kà, tanərə̀z vok aŋatà kà: Tawàrla. ");
INSERT INTO mfh_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kiya uwaga tekula la tataka aŋatà la abà, uwana anəŋàŋ kà ada­wurla kà, awùl à slaka Yesu la mazləɓ Zəzagəla la kuda zləkkà. ");
INSERT INTO mfh_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Atə̀ɗ à makəla asik aŋha la magoɗay: ‘Kikay’. Masla kà te­ke­ɗika zil Sama­riya. ");
INSERT INTO mfh_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kiya uwaga Yesu agòɗ à atà: “Azladza kulo tawàr ala aw takay? Atà la azla­ladəga anik uwanay la? ");
INSERT INTO mfh_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Dza la ahəŋ adzùgw kà mawul à awtày kà mav kikay aw. Say məlok dza uwanay pəra.” ");
INSERT INTO mfh_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ŋgaha Yesu agòɗ à dza uwana awùl à waŋ: “Sà à afik, hàd aŋak; madiŋal gəl à vok aŋak adawur ka ala!” ");
INSERT INTO mfh_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Azla Farisəya tanavà Yesu: “Mbà makoray Zəzagəla adàsa à waŋ mi”, tagòɗal. Yesu agòɗ à atà: “Makoray Zəzagəla kà, atsa à waŋ la kiya uwanay aŋa manəŋəŋ la yewdi aw. ");
INSERT INTO mfh_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ŋgaha dza aslala vok babay kà magoɗay kà: ‘Aganay la abanay, baŋaw agatày la abatày’, tagoɗay babay aw. Sə̀làw kà, aganay la tataka aŋkul la abà à makoray Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Masla agòɗ à azlaməna matapla la slaka aŋha: “Azla­ma­vakay anik tadàsa à waŋ à uwana kadà­yahaw la iyaw tugwi kà manəŋ Kona aŋa dza bà à mavakay tekula, ama kadà­nəŋawwaŋ aya aw. ");
INSERT INTO mfh_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ŋgaha azladza tadà­goɗah à akul Kristu kà ‘Aganay la abanay, baŋaw agatày la abatày.’ Kakəsaw gay aŋatà aw, kadaw la abatà aw! ");
INSERT INTO mfh_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kà uwana bokuba habaga uwana awutsəɗ à uda la ləv zagəla la abà, dagay la tsəh la ahəŋ tsəràh à gəl à agu kà, la kiya uwaga adàpaka vok la vuɗ mas à waŋ aŋa Kona aŋa dza babay. ");
INSERT INTO mfh_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ama kəla kà say asa ŋgərpa məŋga dadàŋ, ŋgaha kà say azladza aŋa zamana uwanay takweska masla aya dadàŋ. ");
INSERT INTO mfh_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Bokuba uwana apakàhà vok la zamana aŋa Nuhu kà, kiya uwaga à uwana adàpaka vok babay la mavakay aŋa Kona aŋa dza. ");
INSERT INTO mfh_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","La zamana uwatà azladza tazàw, tasàh, tazàɓ mis, tavàh azladəgam aŋatà à zil, tsəràh à mavakay uwana Nuhu adà à kəslah iyaw à agu. Ama atà kà, tadzùgw tatak anik ɗiki­ɗiki tsəràh à uwana mazlaha asà à waŋ azàhà atà ala aw. ");
INSERT INTO mfh_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Apakà vok la zamana aŋa Lot bay kà kità: Tazàw, tasàh, tasàkwàh, taɗàwàh ala, taslə̀kàh tatak, ŋgaha taŋàlàh azlagày aŋatà. ");
INSERT INTO mfh_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ama la mavakay uwana Lot asà à uda la gudəŋ Sodom la abà kà, Zəzagəla aduw akàl à ahəŋ la zagəla uwana la abà, kaɗàh kà kaɗàh. Ŋgaha azaha azladza ala gesina. ");
INSERT INTO mfh_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Adàpaka vok kalkal la uwaga la vuɗ mas à waŋ aŋa Kona aŋa dza babay.” ");
INSERT INTO mfh_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Kiya uwaga babay la mavakay uwatà kà, dza uwana la gəl gày la afik kà, amiyaka kazlaŋa aŋha la kay kà, adàsa à ahəŋ kà mahəlay aw. Ŋgaha babay kà, dza uwana la guf la abà kà, adàwul à mtəga babay aw. ");
INSERT INTO mfh_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Dzùgwàw lakəl aŋa mis aŋa Lot tsi. ");
INSERT INTO mfh_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dza uwana ayàh matəf sifa aŋha kà, adàziŋ ala, ŋgaha dza uwana atùw sifa aŋha aw kà, adà­təfəŋ uwaga. ");
INSERT INTO mfh_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","La dziriga gəpəh à akul: La vuɗ uwatà kà, azladza səla la kəslah tekula la afik kà, tekula tadàzəɓay, tekula tadà­sakal. ");
INSERT INTO mfh_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Azlamis səla la vəl tekula la afik kà, tekula adàzəɓay, tekula tadà­sakal. (( ");
INSERT INTO mfh_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Aya kà, azlazil səla la guf tekula la abà, tekula tadàzəɓay, ŋgaha tekula tadà­sakal.))” ");
INSERT INTO mfh_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kiya uwaga azlaməna matapla la slaka aŋha tanàv: “Sufəl, uwaga ma adàpaka vok ma lala?” Masla agòɗ à atà: “La slaka uwana tatak mama­tsayga la ahəŋ la uwana azla­kwa­tsamu taham gay à vok la abatà.” ");
INSERT INTO mfh_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","La lig la ahəŋ Yesu apə̀h à atà gay la gay la abà kà aŋa mapəhatàla kà masak à madəv kuɗa la tsəh ala la ahəŋ la maruw vok à ahəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Masla seriya la ahəŋ la gudəŋ anik ahoy guba aŋa Zəzagəla aw, ŋgaha akə̀s gay aŋa dza babay aw. ");
INSERT INTO mfh_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","La gudəŋ uwatà la abà babay kà, mis kuɗa anik la ahəŋ, asàh à waŋ à slaka aŋha la magoɗal: ‘Ɗàh à gi seriya la masla məzam gulo.’ ");
INSERT INTO mfh_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Asik dəŋ masla seriya akwe­sàhal à gəl, ama la lig la ahəŋ adzùgw la gəl aŋha: ‘La dziriga kà, guba az à gi kà aŋa Zəzagəla aw, gəkəs gay aŋa azladza aw. ");
INSERT INTO mfh_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ama lagwa kà, mis kuɗa uwanay atərəɓ gi ayigəla kà, gəɗàhla seriya aŋha ŋgaha masla aŋa masàh à waŋ aŋa mawis à gi gəl à vok aya aw.’ ” ");
INSERT INTO mfh_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kiya uwaga Sufəl Yesu agòɗ: “Tsənàw uwana masla seriya mawi­siga uwanay agòɗ tsi. ");
INSERT INTO mfh_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kətà zlà ma, Zəzagəla kà adàɗah dziriga à azla­uwana atsa­tsà­mànì atà aw, kagoɗaw takay? Adàɗah dziriga à azla­uwana tanàval tatak mavakay la mahənay gesina. Ŋgaha vok ahamàl kà atà babay aya. ");
INSERT INTO mfh_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Bà la dziri gəpəh à akul kà, adàɗah à atà dziriga la katskats. Tekeɗik ma, baŋa Kona aŋa dza adàsa à waŋ ma, adàɓəz à madiŋal gəl à vok à gəl la vəɗah takay?” ");
INSERT INTO mfh_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Uwana Yesu apə̀h gay la gay la abà uwanay kà, kà aŋa azladza anik, uwana tapakà gəl aŋatà ala kà: ‘Anu azladza dziriga la huma Zəzagəla’, tagòɗ, tapəsèw azladza anik. ");
INSERT INTO mfh_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Azladza səla tatsìzlla kà mad madəv kuɗa la məŋ gày Zəzagəla la aku. Anik zil Farisəya, anik uwanay masla mazəɓ hadama. ");
INSERT INTO mfh_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Zil Farisəya atsìzlla ala, adə̀v kuɗa la kiya uwanay: ‘Sufəl Zəzagəla, kikay gəgoɗ à ka, kà uwana gi kà, gi kiya azladza anik aw. Kà uwana atà kà: Azlaməna gəl, azla­ma­wi­siga, azla­ma­bila! Zəzagəla, kikay gəgoɗ à ka, kà uwana gi kà kiya masla mazəɓ hadama uwanay aw! ");
INSERT INTO mfh_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ŋgaha aya kà, asik səla gəkəs nəlay la kasukwa la tsəh, kəla tatak gulo uwana gəɓəzal kà, gəvàhay tekula la gay aŋa makulo gesina.’ ");
INSERT INTO mfh_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ama masla mazəɓ hadama atsìzlla à fəta à awtày, aslà kà madzək yewdi à zagəla aw, ama ata­tàslla gay ləv: ‘Sufel Zəzagəla gulo, vok ahama ka kà gi, à gi uwana gi masla tsakana!’ ");
INSERT INTO mfh_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Gəpəh à akul la dziriga kà, masla la uwana adà à mtəga la ləv səta­kaga, à kà dza anik uwanay. Kà uwana kəla uwa­be­yuwi uwana azigən gəl aŋha kà tawulla à lig, ŋgaha kəla dza uwana awulla gəl aŋha à vəɗah kà, Zəzagəla adàdalla à huma.” ");
INSERT INTO mfh_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Azladza tasàhla azlabəza à Yesu à waŋ, kà masla aŋa mapis à atà gay à vok, ŋgaha azlaməna matapla la slaka aŋha taslàh atà məl à gəl. ");
INSERT INTO mfh_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ama Yesu azàla atà la magoɗay: “Sàkàw azlabəza tasa à waŋ à slaka gulo, kavəraw atà ay aw, kà uwana makoray Zəzagəla kà aŋa azlatsəhay azla­uwaga! ");
INSERT INTO mfh_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","La dziriga gəpəh à akul: Kəla uwa­be­yuwi uwana akəs makoray aŋa Zəzagəla bokuba azlabəza uwanay aw kà, adàda à makoray Zəzagəla ɗiki­ɗiki aw!” ");
INSERT INTO mfh_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Masiga anik aŋa azla Yahu­diya anavà Yesu la magoɗal: “Məŋga, kak delga, mana à delga gəɗehəŋ, kà gi aŋa maɓəzal sifa adəv à gay aw ma?” ");
INSERT INTO mfh_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu agòɗal: “Kà mana ‘Kak delga’, kagòɗ à gi ma? Dza delga la ahəŋ aw, say Zəzagəla kokuɗa gəl aŋha pəra delga. ");
INSERT INTO mfh_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kasəl mapəhay uwana la wakità Zəzagəla la abà ay? Kada gəl gaw aw, kakəɗ dza aw, kada à gəl aw, kaɗahà fida lakəl aŋa dza anik aw, ŋgaha zlə̀kàw baba aŋak la iyà aŋak!” ");
INSERT INTO mfh_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kohana agòɗ: “Uwaga kà, dagay la bəziga la uwana gekə̀s uwaga gesina.” ");
INSERT INTO mfh_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Uwana Yesu adatsən uwaga kà, agòɗal: “Lagwa kà, tatak tekula atəm à ka kà à ahəŋ! Kəla tatak gesina uwana kakoray kà: Dàw ala, vàh à azlaməna kuɗa à uda gesina, ŋgaha sà à waŋ, kanəfa à gi, kadàɓəz ləmana la zagəla!” ");
INSERT INTO mfh_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ama mok uwana kohana atsə̀n uwaga gesina kà, amə̀ts à ahəŋ la adi, kà uwana galepi. ");
INSERT INTO mfh_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Uwana Yesu anəŋàŋ kà, adapak ləv kà, agòɗ: “Haɗay gà, kà zla­zlaɗa kà dza galepi aŋa mad à makoray Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ŋuləm zlugumi aguwa à uda la afik lepiri, kà dza galepi aŋa mad à makoray Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kiya uwaga azla­uwana tatsə̀ɓal sləm kà, tadzəkà magoɗay: “Tsa aŋa kità ma, uwa à uwana aslala vok aŋa maɓəlay zlà ma uwa?” ");
INSERT INTO mfh_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu agòɗ: “La slaka azladza kà zla­zlaɗa, ama la slaka Zəzagəla kà zla­zlaɗa aw.” ");
INSERT INTO mfh_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kiya uwaga Piyer agòɗal: “Tsənàŋ anu kà, mədasàk tatak uwana à ahəŋ məkor gesina, kà manəf ka.” ");
INSERT INTO mfh_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu agòɗ à atà: “Gəpəh à akul la dziriga kà, baŋa dza asàk gày aŋha à ahəŋ, à mis aŋha à ahəŋ, à azla­deda aŋha ahəŋ, à azla­baba aŋha à ahəŋ, à azlabəza aŋha à ahəŋ kà makoray Zəzagəla kà, ");
INSERT INTO mfh_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","dagay lakana la zamana uwanay adàɓəz tatak aŋuvaw, ŋgaha la huma la gay aya kà, adàɓəz sifa adəv gay aw aya!” ");
INSERT INTO mfh_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu ahə̀l azlaməna matapla kulo gəl aŋha səla uwatà à tsəh, ŋgaha agòɗ à atà: “Tsənàwwàŋ, aganay mədàda à Uru­sa­lima, kà uwana la abatà la uwana tatak uwana azlaməna mapəh à atà gay à ahàl aŋa mapàh à azladza tatsetsèr adàgəɗ à afik, lakəl aŋa Kona aŋa dza. ");
INSERT INTO mfh_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tadàkəs masla, tadàvà à ahàl aŋa azladza uwana azla Yahu­diya aw, atà tadà­kədaslal, tadà­tsakal mago­ɗahay à gəl la matafal slesliɓ à vok. ");
INSERT INTO mfh_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tadà­zlaɓay la kurpi, tadàkəɗay. Ŋgaha la mahənay mamakər kà, adàwul à uda la mamətsay.” ");
INSERT INTO mfh_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ama azlaməna matapla tatsənà godega aŋha aw, kà uwana godega aŋa gay uwatà kà, ahà­ɗàtàŋ à adi, tasə̀l uwana Yesu apə̀h aw. ");
INSERT INTO mfh_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Uwana Yesu azlàbə̀z gudəŋ Yeriko kà, guləf anik madza madzay gà la gay tetəvi, atsatsàh tatak la abatà. ");
INSERT INTO mfh_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mok uwana atsənà dəruk­dəruk aŋa maham à ahəŋ dza uwana tadà à awtày kà, katskats masla adzəkà manavay la magoɗay: “Uwaga ma, mana ma aguwa ma?” ");
INSERT INTO mfh_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Azladza tagòɗal: “Yesu, zil Nazaret la uwana ada à awtày kiya uwaga la maham à ahəŋ dza la tsəh.” ");
INSERT INTO mfh_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kiya uwaga adzəkà mawiyay la magoɗay: “Yesu, Yesu, Kona aŋa David, vok ahama ka kà gi.” ");
INSERT INTO mfh_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ama azladza uwana taguwà à huma taslàhal məl à gəl, “Dzà à ahəŋ titi!”, tagòɗal, ama azà kuda à zagəla la mawiyay aya: “Kona aŋa David vok ahama ka kà gi, gəgoɗ à ka!” ");
INSERT INTO mfh_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kiya uwaga Yesu atsìzlla à ahəŋ, “Sàwgəla à waŋ!”, agòɗ à atà. Mok uwana tadàlla guləf à slaka aŋha, anavà guləf la gay ala: ");
INSERT INTO mfh_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Mana asa à ka, kà gəɗahàŋ ma?”, Yesu agòɗal. “Məŋga, asa à gi kà gənəŋla la yewdi gulo”, guləf awulàlla. ");
INSERT INTO mfh_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","La abatà: “Nə̀ŋ ala, madiŋal gəl à vok aŋak adawur ka ala!” ");
INSERT INTO mfh_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kiya uwaga, uɗak, anə̀ŋla la kirim yewdi, ŋgaha anəfà Yesu la tsəh la mazləɓ Zəzagəla. Mok uwana maham à ahəŋ dza anəŋà uwaga kà, gesina aŋatà tazləɓà Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Mok uwana Yesu adada à gudəŋ Yeriko kà, aguwà à uda la huɗ gudəŋ la abà. ");
INSERT INTO mfh_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Dza anik la ahəŋ, uwana sləm aŋha Zase la abatà, masla kà məŋga aŋa azlaməna mazəɓ hadama, ŋgaha galepi aya, ");
INSERT INTO mfh_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ayàh manəŋ Yesu. “Uwa à Yesu uwatà uwi?”, agòɗ, ama aslà aw, kà uwana maham à ahəŋ dza kà aŋuvaw, ŋgaha babay kà azigən aw, agə̀ɗ à ahəŋ desl. ");
INSERT INTO mfh_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ahàd à huma à gay la mahoyay, ahàd à gudəv à afik, ŋgaha kà masla aŋa manəŋ Yesu, uwana aguwà à awtày la tetəvi uwatà. ");
INSERT INTO mfh_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ŋgaha mok uwana Yesu adabəz à tsəh aŋha kà, anə̀ŋ à afik, agòɗal: “Zase, sà à vəɗah katskats, kà uwana lakana kà, say gəda à mtəga aŋak!” ");
INSERT INTO mfh_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Katskats asà à vəɗah, akə̀s Yesu la ahàl səla, kà mad à mtəga aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Uwana azladza gesina tanəŋà masla kà, taŋoŋùz à tsəh ala, tagòɗ: “Kakay ada mahən à mtəga masla tsakana ma?” ");
INSERT INTO mfh_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zase asà à afik la huma aŋa Sufəl, agòɗal: “Sufəl, tenma aŋa ləmana gulo kà, gəvàh à azlaməna kuɗa à uda gesina. Ŋgaha aya, baŋa gəɗahà mawi­siga à dza à vok la mahəl sili aŋha la kaskas kà, gəvàlla à iyaw à tsəh asik makər, ŋgaha aŋa magay maufaɗ la iyà aŋa sili aŋha!” ");
INSERT INTO mfh_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu agòɗal: “Lakana kà maɓəlay adasa à huɗ gày uwanay, kà uwana masla babay kà mayyi à tsəh ala aŋa Abəraham, ndzer. ");
INSERT INTO mfh_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kà uwana Kona aŋa dza asà à waŋ kà mayàh maɓəl azla­uwana tazàhla.” ");
INSERT INTO mfh_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesu ahàd à huma à gay la mapəhatàla gay la gay la abà à azladza uwana tatsənà paŋaw aŋha. Bokuba uwana atà nekwa la Uru­sa­lima kà tagòɗ kà: ‘Makoray Zəzagəla kà apəhla vok ala la katskats la dazu­waya’, gəl aŋatà agòɗ. Kiya uwaga Yesu apə̀h à atà gay la gay la abà anik. ");
INSERT INTO mfh_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Aganay à uwana apə̀h: “Gada­mula anik, uwana la huɗ gày məŋga, ahàd à gudəŋ anik kərkər kà mazuw sufəl la abatà, kà masla mawul à mtəga la lig la ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Uwana adày kà, azàllàh azla­ma­gamza aŋha kulo dadàŋ, avàhà à atà gursu aŋa luwà­luwà tekula tekula, agòɗ à atà: ‘Tsa­kàl­làw la sili uwanay, tsəràh à mok uwana gədàwul à waŋ.’ ");
INSERT INTO mfh_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ama azlaməna gudəŋ aŋha tapəsèw masla, taslə̀l gay kà magoɗay kà: ‘Asa à anu dza uwanay aŋa magay sufəl lakəl gami aw’, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mok uwana adazuw sufəl kà, awùl à waŋ à gudəŋ aŋha à abà. Ŋgaha azàlàh azla­ma­gamza aŋha uwana avàhà à atà gursu aŋa luwà­luwà kà aŋa matsa­kalla, asàl manərəz uwana taɓə̀zalla à adi. ");
INSERT INTO mfh_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Kiya uwaga matera adà à awtày la magoɗay: ‘Sufəl, sili aŋak kà ayyà à tsəh sili kulo.’ ");
INSERT INTO mfh_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Sufəl agòɗal: ‘Delga, kak magamza delga, bokuba uwana kagà dziriga la bəzi tatak la abà kà, gəf ka à ahəŋ lawan aŋa gudəŋ kulo.’ ");
INSERT INTO mfh_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Kiya uwaga masəla asà à waŋ: ‘Sufəl, sili uwana kavà à gi kà, gəɓə̀zalla à adi zlo aya’. ");
INSERT INTO mfh_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Sufəl agòɗ à masla babay: ‘Kak babay, kak lawan aŋa gudəŋ zlo.’ ");
INSERT INTO mfh_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Magamza anik asà à waŋ aya, agòɗ: ‘Sufəl, aganay sili aŋak, gəfafàɗ à maka­tse­katsa à abà, gəhaɗàŋ à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Guba akə̀s gi kà kak, kà uwana kak dza dzaŋ­d­zaŋga. Kà uwana tatak uwana kak kafà à ahəŋ aw babay kà, kazəɓay, ŋgaha bà tatak uwana kak kasləka aw babay kà, katsəɗay.’ ");
INSERT INTO mfh_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Sufəl agòɗal: ‘Kak magamza maksafərga. Paŋaw aŋak uwana kapə̀h, la uwana aɗahà à ka seriya à gəl. Iyay, kasə̀l kà gi dza dzaŋ­d­zaŋga, ŋgaha gəzə̀ɓ tatak uwana gəfà à ahəŋ aw, kagòɗ. Gətsəɗ tatak uwana gəsləkà aya bay aw, kagoɗ.’ ");
INSERT INTO mfh_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ŋgaha sufəl agòɗal: ‘Kà mana kafà sili gulo à gày makal goder, naka mok uwana gədawul à waŋ kà, naka gəday, gəhəl sili la iyaw la tsəh la abatà aw ma?’ ");
INSERT INTO mfh_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ŋgaha sufəl agòɗ à azladza uwana la slaka aŋha: ‘Zə̀ɓàwwal gursu tekula uwaga la ahàl ala, vàwla à dza uwana à vok akor sili kulo!’ (( ");
INSERT INTO mfh_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Atà tagòɗ: ‘Sufəl, masla kà sili kà kulo la ahàl ŋuwà!’)) ");
INSERT INTO mfh_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘La dziriga’, gəpəh à akul: ‘Dza uwana akoray kà, tadà­valla à vok. Ama dza uwana akoray aw kà, bà bəziga uwatà aga la ahàl kà, tadà­dəvalla à ahàl ala aya! ");
INSERT INTO mfh_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ama azlaməna məzam gulo uwana la abanay, asà à atà kà gəkor atà aw kà, sàwla atà à abanay à huma gulo, kàɗàw atà la yewdi gulo’, sufəl agòɗ à azla­ma­gamza aŋha”, kiya uwanay Yesu apə̀h. ");
INSERT INTO mfh_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","La mok uwana adapəh gay uwaga, Yesu adà à huma aŋa maham à ahəŋ dza kà mad à Uru­sa­lima. ");
INSERT INTO mfh_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mok uwana tazlà­bə̀z à Betfaze atà la Be­ta­niya, nekwa la gudəŋ uwana gudəŋ kuvu tagoɗal kà, aslə̀l azlaməna matapla səla la slaka aŋha la huma, agòɗ à atà: ");
INSERT INTO mfh_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Dàw à gudəŋ uwaga à abà la huma aŋkul. Baŋa kadàbəzaw kà, kadànəŋaw bəzi ziwŋŋu mawaɗəŋ à ahəŋ gà, uwana dza adadza à afik didi aw. Ɗapə̀llàw, kadà­sawla à waŋ à abanay. ");
INSERT INTO mfh_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Baŋa: ‘Kà mana kapəllaw mi’, dza agoɗ à akul kà, ‘Sufəl gami awoyaŋ’, gòɗàwwal!” ");
INSERT INTO mfh_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Uwana azlaməna masləlay taday kà, tanəŋà tatak gesina apakà vok bokuba uwana Sufəl apə̀h à atà. ");
INSERT INTO mfh_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mok uwana tapə̀l bəzi ziwŋŋu uwaga kà: “Kà mana kapəllaw bəzi ziwŋŋu uwaga mi?”, ");
INSERT INTO mfh_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","azladza aŋha tagòɗ à atà, “Sufəl awoyaŋ”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ŋgaha tasə̀lla bəzi ziwŋŋu uwaga à slaka Yesu, atà tadàwal azla­lukut aŋatà à lig, tadzà Yesu à afik. ");
INSERT INTO mfh_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mok uwana adadzəka maday, azladza tadàw azla­lukut aŋatà à tetəvi à ama. ");
INSERT INTO mfh_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","La mok uwana tazlàbəzay à Uru­sa­lima, kà mad à ahəŋ la gudəŋ kuvu la afik kà, azlaməna matapla tahə̀n ala la marabay gesina aŋatà, ŋgaha tazləɓà Zəzagəla la kuda zləkkà, kà azla­tatak nadzi­poga uwana tanaŋàŋ gesina. ");
INSERT INTO mfh_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Azla dza tagòɗ: “Delga kà Zəzagəla apis gay à Sufəl uwana à vok, atsa à waŋ la sləm aŋa Sufəl Zəzagəla! Lapiya la zagəla, ŋgaha mazləɓay agay la Zəzagəla uwana la zagəla la afik.” ");
INSERT INTO mfh_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ŋgaha azla Farisəya anik uwana la tataka maham à ahəŋ dza la abà tagòɗ à Yesu: “Məŋga, ‘Dzàw à ahəŋ titi’, gòɗ à azlaməna matapla la slaka aŋak!” ");
INSERT INTO mfh_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ama Yesu agòɗ à atà: “Baŋa: ‘Dzà à ahəŋ titi’, gəgoɗ à atà babay kà, bà azlaakur babay kà tadzəka mawiyay babay!” ");
INSERT INTO mfh_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mok uwana Yesu azlàbə̀z à huɗ gudəŋ kà, adzəkà matuway à uwana ada­nəŋəŋ ");
INSERT INTO mfh_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","la magoɗay: “Agayŋa kak la gəl aŋak kasəl tatak uwana agay lapiya kà aŋak kà, naka kità aw. Ama lagonay kà adadza à ahəŋ kà bokuba nasi­riga la huma yewdi aŋak. ");
INSERT INTO mfh_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kà uwana azla­ma­vakay anik tadàsa, à waŋ à uwana azlaməna məzam aŋak tadàkəs à ka gay adi la kazlaŋa guvəl la ahàl, tadàtsak à ka à ama tadàtsah kà makalla gesina. ");
INSERT INTO mfh_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Tadà­za­kala tetuwa kak la azlabəza aŋak, amiyaka bà akur tekula babay kà adàgəɗ à gəl aŋa anik aw, kà uwana awul à ka à gəl à mavakay uwana Zəzagəla asa à waŋ aŋa mazlak ka aw.” ");
INSERT INTO mfh_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Mok uwana Yesu adada à məŋ gày Zəzagəla à agu kà, adzəkà makuɗəkàh azlaməna matsa­kalay à lag la aku. ");
INSERT INTO mfh_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Agòɗ à atà: “Aganay à uwana tatsetsèr à wakità Zəzagəla à abà: ˈGày gulo kà adagay kà gày madəv kuɗa, ama akul kà kada­pa­kawwaŋla kà tsakur aŋa azlaməna gəl.ˈ” ");
INSERT INTO mfh_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu ata­pàhla tatak à azladza la məŋ gày Zəzagəla la aku koksi­koksi. Azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla, la azlaməna mapàhla mapəhay à azladza, ŋgaha la azladza uwana masəl à atà gà, la gudəŋ uwatà la abà, tayàh makəs Yesu, kà makəɗay. ");
INSERT INTO mfh_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ama taslà kà maɗàh dabaray uwana asà à atà maɗehəŋ aw, kà uwana azladza gesina kà, tafà sləm kà à masla la matsəɓal sləm pəra. ");
INSERT INTO mfh_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","La vərdi anik Yesu atàpla tatak à azladza la məŋ gày Zəzagəla la aku, ŋgaha apə̀h à atà gay matsi­ɗayga. Azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla, la azlaməna mapàhla mapəhay ala, la azla­ma­siga aŋa azla Yahu­diya ");
INSERT INTO mfh_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","tasà à waŋ à slaka aŋha tagòɗal: “Pə̀hanula, la ndzəɗa ma uwala à uwana kaɗàhla azla­tatak uwanay tak la? Uwa à uwana avà à ka tetəvi aŋa maɗàh azla­tatak uwanay uwa?” ");
INSERT INTO mfh_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu agòɗ à atà: “Gi babay kà, gənav à akul tatak tekula lagwa, wùllàwgəla suwaŋ! ");
INSERT INTO mfh_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Uwa à uwana aslə̀l Yuhana à waŋ kà maɗàh batem tak uwa? Zəzagəla ay, awma azladza takay?” ");
INSERT INTO mfh_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ama atà tadzəkà mabay vok gay la tataka aŋatà la abà kà atà à atà, ŋgaha tagòɗ: “Baŋa məgoɗ Zəzagəla la uwana aslə̀l à waŋ, ‘Kà mana zlà ma kadì­ŋàwwal gəl à vok aw mi’, adà­goɗay. ");
INSERT INTO mfh_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Baŋa məgoɗ: ‘Azladza la uwana taslə̀l à waŋ kà’, maham à ahəŋ dza uwana la abanay gesina tadàtsah anu à gəl la akur aya, kà uwana tasəl kà Yuhana kà masla mapəhal gay à ahàl aŋa Zəzagəla kà mapàh à azladza ndzer.” ");
INSERT INTO mfh_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ŋgaha tawulàlla: “Anu kà, məsəl dza uwana aslə̀l à waŋ aŋa maɗàh batem aw.” ");
INSERT INTO mfh_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","La abatà Yesu agòɗ à atà: “Kətà kà, gi babay kà, gəpəhakulla ndzəɗa uwana gəɗàhla azla­tatak uwanay babay zlà à ama aw.” ");
INSERT INTO mfh_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kiya uwaga Yesu adzəkà mapəh gay la gay la abà uwanay à maham à ahəŋ dza: “Dza anik atsə̀ɓ gày matavəruk aŋha, asàkla uwaga la azla­ma­gamza aŋha la ahàl, ŋgaha adà aŋha kərkər à gudəŋ anik, asàf la abatà. ");
INSERT INTO mfh_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mok uwana adasal kà, aslə̀l dza aŋha à azla­ma­gamza à tsəh, kà mavàl humà mahənay aŋa tatak guf aŋha. Ama mok uwana azla­ma­gamza tanəŋə̀ŋ kà, tazlàɓal, ŋgaha takuɗə̀k la ahàl deyday. ");
INSERT INTO mfh_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bà gotənaŋ aslə̀l dza anik aya. Ama atà tazlàɓ à gəl, ŋgaha tatsə̀kal mago­ɗahay à gəl, la makuɗəkay la ahàl deyday babay. ");
INSERT INTO mfh_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Aslə̀l dza anik kà mamakər aya. Ama tatsàh, taɗàhal amik à vok, ŋgaha tamə̀l à tetəvi à tsəh. ");
INSERT INTO mfh_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Dza aŋa guf matavəruk agòɗ: ‘Mana à uwana gəɗehəŋ lagwa zlà ma?’, agòɗ la gəl aŋha, ‘Gəsləlla à atà bəzi gay ləv gulo, zlahaw kà, tadàsləkaw masla.’ ");
INSERT INTO mfh_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ama mok uwana tanəŋà masla, azla­ma­gamza tatsa­tsə̀l vok gay kà atà à atà, tagòɗ: ‘Masla la uwana masla mazuw gày, sàw à waŋ katskats, məkə̀ɗ pəra, anu mədàɓəɗ à mazuw gày à gəl!’ ");
INSERT INTO mfh_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tadùw à uda la guf la abà, takəɗ.” “Ama kakay dza aŋa guf matavəruk adà­ɗa­hatàŋ à vok ma? ");
INSERT INTO mfh_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Adàsa à waŋ adàkaɗ azla­ma­gamza maksafərga uwaga gesina, ŋgaha adàvà guf à ahàl aŋa azladza anik uwana tadà­vàhal mahənay aŋa matavəruk la kaslà uwana asal gesina.” Ama mok uwana tatsənà uwaga tagòɗ: “Kiya uwaga apakà vok aw!” ");
INSERT INTO mfh_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ama Yesu anərə̀z atà la magoɗay: “Uwanay tatsetsèr, ma mana asal mapəhla ala tak ma? ˈAkur uwana azlaməna maŋal gày tapəsèw kà, Masla la uwana adagay akur mawaɗ gày gesina.ˈ ");
INSERT INTO mfh_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kəla dza uwana atəɗ à akur uwanay à afik kà adà­ka­lahla. Ama baŋa akur uwanay la uwana atəɗ à dza à gəl kà, aslərəɗəŋ ala kədənna.” ");
INSERT INTO mfh_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Azlaməna mapàhla mapəhay ala la azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla tayàh kà makəs Yesu la kaslà uwatà. Ama guba akə̀s atà kà maham à ahəŋ dza, kà uwana tasə̀l kà apə̀h gay la gay la abà uwaga kà lakəl aŋatà. ");
INSERT INTO mfh_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kiya uwaga kà maɓəz à Yesu à tsəh kà, azlaməŋga taslə̀l azlaməna matsəɓ sləm, uwana tapakà gəl aŋatà ala kà bokuba azladza dziriga, awkà bokuba azlaməna matsəɓ sləm pəra aw, kà maɓəzal à tsəh la gay mawi­siga uwana la abà, atsà à waŋ la gay aŋha la awtày amiyaka tekula, ŋgaha kà atà aŋa mav masla à ahàl aŋa azlaməna makoray. ");
INSERT INTO mfh_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kiya uwaga tanàval à gay ala la magoɗay: “Məŋga, məsəl kà uwana kapəhay, la uwana katapla à azladza, kà dziriga, ŋgaha babay kà kakəsani dza makasay aw, ama la dziriga, la tetəvi aŋa Zəzagəla à uwana katapla à azladza. ");
INSERT INTO mfh_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Anu ma tetəvi la ahəŋ, kà mapəl hadama gami à məŋ sufəl Zəsar ay, awma mapəhay gami avà à anu tetəvi aw kəlay?” ");
INSERT INTO mfh_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Bokuba uwana Yesu asə̀l ɗemɗem aŋatà kà, agòɗ à atà: ");
INSERT INTO mfh_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Pə̀hàwgəla akur sili uwatà dadàŋ tsi”, agòɗ à atà. “Gəl la sləm uwanay ma aŋa uwa, la sili uwanay la afik uwa?”, agòɗ à atà. Tagòɗal: “Aŋa Zəsar.” ");
INSERT INTO mfh_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kiya uwaga Yesu agòɗ à atà: “Kità kà, pə̀làw à məŋ sufəl Zəsar tatak uwana aŋha, ŋgaha pə̀làw à Zəzagəla uwana aŋha suwaŋ!” ");
INSERT INTO mfh_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kiya uwaga kà, taɓə̀z à gay à tsəh kà makəsla masla aw, kà uwana gay aŋha uwana apə̀h la huma maham à ahəŋ dza kà mawi­siga la abà aw, ləv avàl atà à gay kà mawulla gay à uda aŋha, tadzà à ahəŋ titi. ");
INSERT INTO mfh_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kiya uwaga azladza anik la tataka azla Sadu­kiya la abà, atà uwana: ‘Mawul à uda la mamətsay la ahəŋ aw’, tagòɗ, tasà à waŋ à slaka Yesu kà manaval: ");
INSERT INTO mfh_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Məŋga, aganay uwana Musa apə̀h: Baŋa dza aməts à mis ala kokuɗa maɓəz bəzi kà, say deda aŋha azəɓ mis aŋha à uda la gày kuɗa, ŋgaha atsizlla ala tsəhay aŋha ala. ");
INSERT INTO mfh_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Azladza la ahəŋ atà məɗəf la azla­deda aŋatà. Magolga gà azə̀ɓ mis, amə̀tsal akə̀lla ala kokuɗa maɓəz bəzi. ");
INSERT INTO mfh_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Deda masəla ŋgaha mamakər tazàɓ mis uwaga à uda la gày kuɗa. ");
INSERT INTO mfh_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kiya uwaga tazàɓ tsəràh à məɗəf nna gesina. Gesina aŋatà tamà­tsàlàŋ ala kokuɗa maɓaz bəzi la mis uwaga. ");
INSERT INTO mfh_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Uwana uwaga adada à lig kà, mis amə̀ts bay suwaŋ. ");
INSERT INTO mfh_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ŋgaha ma la vuɗ mawul à uda la mamətsay, ma mis ma adàgəɗay ma à uwa, tsa atà gesina aŋatà kà tazàɓ uwa?” ");
INSERT INTO mfh_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ŋgaha Yesu agòɗ à atà: “Azladza aŋa zamana uwanay la uwana tazəɓ vok. ");
INSERT INTO mfh_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ama azla­uwana Zəzagəla adà­tsa­tsa­mani atà kà maɓəz à sifa adəv gay aw, tadàwul à uda aŋa madz à ahəŋ la sifa uwana adàdəv gay aw kà, atà kà, tadàzaɓ vok aya aw. ");
INSERT INTO mfh_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kà uwana la dziriga gà kà, tadà­matsay aya aw, tadà­pa­kahay kà bokuba azla­ma­lika, ŋgaha tadà­gahay azlabəza aŋa Zəzagəla, à kà uwana tawul à uda la mamətsay kà madz à ahəŋ la sifa. ");
INSERT INTO mfh_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Iyay, lakəl aŋa mawul à uda la mamətsay kà, Musa apə̀h lakəl aŋha la wakità la abà la paraka: ˈ‘Sufəl Zəzagəla gulo, Zəzagəla aŋa Abəraham, Zəzagəla aŋa Isak, ŋgaha Zəzagəla aŋa Yakuba bay.’ˈ ");
INSERT INTO mfh_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Zəzagəla kà Zəzagəla aŋa azla­ma­zim­nekiɗ aw, ama aŋa azladza uwana la sifa, kà uwana tatak gesina uwana la sifa kà aŋha.” ");
INSERT INTO mfh_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","La kità kà, uwana tatsə̀n uwaga kà, azlaməna mapàhla wakità aŋa mapəhay ala tagòɗ: “Məŋga, uwaga kà lela kapə̀h.” ");
INSERT INTO mfh_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kà uwana taslà manaval gay aya aw. ");
INSERT INTO mfh_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu agòɗ à atà: “Kakay tagoɗay kà Kristu kà Kona aŋa David ma? ");
INSERT INTO mfh_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kà uwana David la gəl aŋha kà agòɗ à wakità aŋa Mahabay la abà kà: ˈ‘Sufəl Zəzagəla agòɗ à Sufəl gulo: Dzà madzay la ahàl kaf gulo lakəl ");
INSERT INTO mfh_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tsəràh à uwana gəɓək à ka azlaməna məzam aŋak à tsəh asik!’ˈ ");
INSERT INTO mfh_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tsa baŋa David la gəl aŋha kà azàlalla Sufəl ma, kakay apàk kona aŋha ma?” ");
INSERT INTO mfh_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mok uwana maham à ahəŋ dza atsə̀ɓal sləm kà, Yesu agòɗ à azlaməna matapla la slaka aŋha: ");
INSERT INTO mfh_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ɗahàw haŋkəli kà azlaməna mapəhla wakità mapəhay ala kà uwana atà kà, asa à atà mau­gu­zahay la azla­da­wara məŋga məŋga gà la vok, kà mapa­patla dza. Ŋgaha asa à atà kà azladza tasukw atà kà la azla­ba­rama uwana la ama mahamay dza la abatà, asa à atà madza madzay kà la slaka teraŋa la gày madəv kuɗa la aku, ŋgaha aya asa à atà madza madzay kà la slaka delga la tatak may lakəl. ");
INSERT INTO mfh_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Atà kà, azlaməna mazaw azlamis kuɗa à uda aya, ŋgaha asà à atà mavakàh à madəv kuɗa à abà la slaka madəv kuɗa. Atà kà tadàɓəzal seriya kà dzaŋ­d­zaŋga.” ");
INSERT INTO mfh_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu anə̀ŋ à slələf à gəl kà, anəŋà azla­ga­lepi uwana tawàts sili à sahar aŋa ofərand à abà la məŋ gày Zəzagəla la aku. ");
INSERT INTO mfh_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","La abatà bay kà anəŋà mis kuɗa kuɗaga uwana awìts kalamay səla à abà la abatà la ləv tekula. ");
INSERT INTO mfh_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu agòɗ: “La dziriga, gəpəh à akul kà, mis kuɗa uwanay kà avà kà aɗuwa azladza anik uwanay gesina. ");
INSERT INTO mfh_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Azladza uwanay tavà kiya uwanay kà, kà uwana ada­baday la slaka aŋatà, ama mis kuɗa uwanay kà, azə̀ɓ à uda kà uwana agà la ahàl aŋa madzadzarla gəl aŋha gesina.” ");
INSERT INTO mfh_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Azladza anik tapə̀h lakəl aŋa məŋ gày Zəzagəla kà ahəɗ. ‘Maɗahala vok à uda gà, la azlaakur delga delga gà’, tagòɗ, ‘Ŋgaha la azla­tatak anik anik uwana tavàh à Zəzagəla.’ Yesu agòɗ à atà: ");
INSERT INTO mfh_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Mavakay adàsa à waŋ, kà azlaakur uwanay adàdza à ahəŋ kiya uwanay aw, amiyaka bà akur tekula adàgəɗal à gay aw, tadà­ɓazlah à ahəŋ gesina.” ");
INSERT INTO mfh_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kiya uwaga tanàval à gay la: “Məŋga, mbà à tatak uwaga adàpaka vok ma? Tatak ma uwala à uwana adàpəhanula zlà?” ");
INSERT INTO mfh_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Kiya uwaga Yesu agòɗ à atà: “Ɗahàw haŋkəli, dza apapat akul aw, kà uwana azladza aŋuvaw tadàsaha à waŋ la sləm gulo, à uwana ‘Anu azlak­ristu. Lagwa kà, kaslà aŋha la uwanay adàsa à waŋ lagwa’, tadà­goɗay. Ama kadànəfaw atà aw. ");
INSERT INTO mfh_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Baŋa kadàtsənaw gay lakəl aŋa guvəl, la azla­ma­wiyay aŋha kà, ləv adàval akul à gay aw, kà uwana uwaga kà say leri apaka vok dadàŋ, ama uwaga kà makəɗ gəl à ahəŋ aŋa gudəŋ à vok dadàŋ aw.” ");
INSERT INTO mfh_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kiya uwaga agòɗ à atà: “Azladza tsəhay anik tadàpa guvəl la azlatsəhay anik, ŋgaha makoray anik adàpa guvəl la makoray anik. ");
INSERT INTO mfh_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Azla­maɓəlak à vok aŋa kutso adà­gahay la ahəŋ aŋuvaw, ɗuvats la azlamay, la matərəɓay ada­gahay la ahəŋ la azla­slaka anik anik. Azla­tatak guba, la azla­na­dzipo məŋga tadàsa à ahəŋ la zagəla.” ");
INSERT INTO mfh_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ama kà uwaga aŋa mapak vok gesina kà tadà­kasah akul, tadàtsərəkwah akul tadàtərərɓah akul la azlagày madəv kuɗa la aku, ŋgaha tadà­wats akul à daŋay, tadà­bayàh akul à huma aŋa azla­su­fəl, ŋgaha à huma aŋa azla­lawan kà gi. ");
INSERT INTO mfh_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Uwaga la uwana adàvà à akul tetəvi kà maz sayda gulo. ");
INSERT INTO mfh_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Lagwa kà, gəɗawaŋ à afik la ləv aŋkul la tsəh kà akul aŋa mago­gotsay kà aŋa mahəl à ahəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kà uwana gi la gəl gulo la uwana gədà­guway la paŋaw aŋkul la awtày, kà mav à akul matsi­hila kà masla məzam aŋkul aŋa maməl akul gəl à ahəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Te­ke­ɗika kà, bà azla­baba aŋkul, la azla­deda aŋkul dardarga, ŋgaha la azla­slawda aŋkul la uwana tadàtsərkwah akul. Ŋgaha tadàzah sifa aŋa azlaanik aŋkul ala aya. ");
INSERT INTO mfh_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Azladza gudəŋ à vok gesina tadà­pəsew akul kà uwana kawoyaw gi. ");
INSERT INTO mfh_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ama bà la uwaga kà, amiyaka bà aŋidz taka­sa­gəl aŋkul tekula babay kà adàzila aw. ");
INSERT INTO mfh_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","La matsizlla à ahəŋ lela aŋkul la uwana kadàɓəzaw à sifa aŋkul.” ");
INSERT INTO mfh_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Mok uwana kadànəŋaw azlaməna guvəl tadàkəs gay à Uru­sa­lima à adi kà, sə̀làw kà nekwa: ‘Takal à ahəŋ adàgay’, kadà­goɗaw. ");
INSERT INTO mfh_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kiya uwaga azla­uwana atà la Yahu­diya kà, tadàhoy à gudəŋ à afik. Ŋgaha azla­uwana tadàgay la huɗ aŋa Uru­sa­lima kà, tadàza vok, ŋgaha azla­uwana la lig gà la uda kà, tadàda à abà aya aw. ");
INSERT INTO mfh_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ama azla­ma­vakay uwaga kà azla­ma­vakay aŋa seriya la mazay, ama kà magəɗ uwana à afik tatsetsèr à wakità Zəzagəla à abà. ");
INSERT INTO mfh_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ŋgərpa adàgay la azlamis uwana la bəza la huɗ, la azlauwana bəza vərna aga à atà la ahàl la mavakay uwaga, kà uwana matərəɓay la mapak ləv aŋa Zəzagəla adàpəhla vok ala la tataka azlatsəhay uwanay la abà. ");
INSERT INTO mfh_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tadà­kaɗah atà la katsakar, tadà­pakah atà ala kà azla­mayà la tataka azlatsəhay gudəŋ à vok la abà. Azladza uwana azla Yahu­diya aw, tadà­habah Uru­sa­lima à tsəh tsəràh à uwana kaslà aŋatà adàdəv à gay.” ");
INSERT INTO mfh_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Azla­masəlay, la azla­na­dzipo anik anik la afats la abà, la təla la abà, la azla­tse­tsiliŋ, ŋgaha la kutso la abà adàgay la ahəŋ. Gudəŋ à vok adàgay la mazaw la gel la abà, gəl adàkaɗ atà à vok kà maho­humay aŋa magaŋ­tsay aŋa azla­dərəv. ");
INSERT INTO mfh_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Azladza tadà­məts à gay kà ŋgərpa uwana adàpaka vok la kutso la abà la vəɗah, kà uwana azlan­dzəɗa uwana la zagəla tadàɓəlak à vok. ");
INSERT INTO mfh_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kiya uwaga kadànəŋaw Kona aŋa dza atsa à ahəŋ la habaga zagəla la abà, la mazləɓay, ŋgaha la maslay gesina. ");
INSERT INTO mfh_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mok uwana azla­tatak uwaga tadàdzəka mapakàh vok kà, dzərəɗàkàw vok ala, tsìzllàw gəl ala la matsizlla à ahəŋ lela, kà uwana maɓəlay aŋkul kà nekwa.” ");
INSERT INTO mfh_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kiya uwaga Yesu apə̀h à atà gay la gay la abà uwanay: “Nərə̀zàw gudəv la azlaahàf anik anik gesina tsi. ");
INSERT INTO mfh_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Baŋa kadànəŋaw azla­ba­ɓasl aŋatà tadzəka maɗay kà, sə̀làw kà madara kà nekwa. ");
INSERT INTO mfh_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","La kità babay, mok uwana kadànəŋaw azla­tatak uwaga tadàdzəka vok kà, sə̀làw kà, makoray Zəzagəla kà nekwa atsa à waŋ. ");
INSERT INTO mfh_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","La dziriga, gəpəh à akul: Zamana uwanay adàdəv à gay dadàŋ kà mapak vok aŋa azla­tatak uwaga aw. ");
INSERT INTO mfh_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Zagəla la kutso tadàdəv à gay, ama gay gulo kà, adàdəv à gay aw.” ");
INSERT INTO mfh_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Nə̀ŋàwla gel aŋkul! Kà gəl aŋa makaɗ akul à vok lakəl aŋa tatak masay, la tatak may, la azla­tatak aŋa gudəŋ à vok uwanay aw! Tsa baŋa kità aw kà, mavakay aŋa seriya adàsa à waŋ adà­goruh akul. ");
INSERT INTO mfh_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kà uwana mavakay uwatà kà, adàsa à waŋ kà bokuba makəs tatak aŋa kəda kəfu à uwana adàsa azladza à gudəŋ à vok à gəl. ");
INSERT INTO mfh_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Dzàw à ahəŋ la adi, də̀vàw kuɗa la kaslà gesina, kà akul aŋa maɓəz ndzəɗa kà matəf uwana la gay ala atsa à waŋ gesina, ŋgaha kà akul aŋa matsizlla à ahəŋ dzawwa la huma aŋa Kona aŋa dza.” ");
INSERT INTO mfh_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Te­ke­ɗika la afats kà, Yesu atàpla tatak à azladza la məŋ gày Zəzagəla la aku, ama la mokokhu gà kà, ahàd, ahə̀n à gudəŋ uwana afik: ‘Gudəŋ kuvu’, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Maham à ahəŋ dza gesina asà à waŋ la bəŋ la zay la tsəh kà matsəɓal sləm la məŋ gày Zəzagəla la aku. ");
INSERT INTO mfh_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mok uwana uwaga adada à lig kà, madəvaday aŋa Pain uwana kokuɗa tatak maməsləŋ ala, à uwana tazalalla Paska agay nekwa. ");
INSERT INTO mfh_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kiya uwaga azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla, ŋgaha la azlaməna mapàhla mapəhay ala tayàh dabaray kà makəɗ Yesu, ama guba akə̀s atà kà maham à ahəŋ dza. ");
INSERT INTO mfh_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kiya uwaga seteni aguwà la Yudas uwana la abà, tazàlalla Iska­riyot, tekula aŋa azlaməna matapla kulo gəl aŋha səla. ");
INSERT INTO mfh_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ŋgaha masla ahàd kà matsən vok gay la azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla, la azlaməŋga aŋa azlaməna manəŋla məŋ gày Zəzagəla, kà mav à atà Yesu à ahàl. ");
INSERT INTO mfh_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Taràb məŋga, “Mədàvà à ka sili!”, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas akə̀s la ahàl səla, ayàh tetəvi kà maf à atà Yesu à ahàl kokuɗa matsənəŋ aŋa maham à ahəŋ dza. ");
INSERT INTO mfh_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kiya uwaga mavakay aŋa Pain uwana kokuɗa tatak maməsləŋ ala, uwana azladza takàɗàh magadzaw adada à abà. ");
INSERT INTO mfh_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","La kità, kà Yesu aslə̀l azla Piyer atà la Yuhana la magoɗ à atà: “Dàw, kadà­ɗahaw anu tatak aŋa madəvaday Paska à ahəŋ, kà anu aŋa mazuway!” ");
INSERT INTO mfh_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Lala asà ka məday aŋa maɗehəŋ à ahəŋ la?” tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ŋgaha agòɗ à atà: “Mok uwana kadabəzaw à huɗ gudəŋ à abà kà, kadà­ga­gamaw la dza uwana iyaw lakəl la tuguzl gà. Ɗanə̀fàw masla à gày uwana à abà, adàda à abà. ");
INSERT INTO mfh_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ŋgaha kadà­goɗaw à zil gày: ‘Məŋga anav gày, uwana adàzuw tatak may aŋa Paska la aku, la azlaməna matapla la slaka aŋha la slaka aŋak.’ ");
INSERT INTO mfh_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kiya uwaga adàpəhakulla gày maɗehəŋ à ahəŋ gà uwana lakəl aŋa gày anik la afik, ŋgaha kà la abatà la uwana kadà­ɗahaw tatak may à ahəŋ.” ");
INSERT INTO mfh_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mok uwana taday kà, taɓə̀z à tatak à gəl gesina bokuba uwana Yesu apə̀h à atà, ŋgaha tadzəkà maɗàh vok à ahəŋ kà aŋa madəvaday Paska. ");
INSERT INTO mfh_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mok uwana kaslà adaslay kà Yesu la azlaməna matapla la slaka aŋha tadzàh à tatak may à adi, ");
INSERT INTO mfh_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yesu agòɗ à atà: “Gəwoyaŋ kà bà mawoyay kà mazuw tatak may aŋa Paska uwanay anina dadàŋ, kà gi aŋa mas ŋgərpa. ");
INSERT INTO mfh_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","La dziriga gəgoɗ à akul: Tetuw gədà­zuway aya aw, tsəràh à uwana adàgay magəɗ à afik gà la makoray aŋa Sufəl Zəzagəla dadàŋ.” ");
INSERT INTO mfh_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Azə̀ɓ kətsaw à ahàl la tatak masay gà, “Kikay”, agòɗ à Zəzagəla, “Kə̀sàw kətsaw uwanay, kaslawwaŋ à vok à gay la tataka aŋkul la abà. ");
INSERT INTO mfh_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kà uwana la dziriga gəpəh à akul kà, gədàsa iyaw matavəruk uwanay aya aw, say la makoray Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ŋgaha azə̀ɓ kaf, “Kikay”, agòɗ à Zəzagəla, atsakàŋ ala, avà à atà la magoɗ à atà: “Uwanay kà vok gulo ((uwana mavày gà kà aŋkul. Ɗahàw uwanay kà gi aŋa mawul akul à gəl.” ");
INSERT INTO mfh_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","La lig aŋa mazuw tatak may à gay la ahəŋ kà, avà à atà kətsaw iyaw la tatak masay la abà, agòɗ à atà: “Kətsaw uwanay kà, kətsaw makəs vok slawda mawga la aŋiz gulo, uwana masokw à vəɗah gà kà aŋkul.))” ");
INSERT INTO mfh_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ama aganay à dza uwana adàta à gi kaf à gəl məda­tsəp vok à ahàl à tatak may à abà anu səla. ");
INSERT INTO mfh_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ndzer, Kona aŋa dza adàdiy aŋha bokuba uwana tatsetsèr à wakità Zəzagəla à abà, ama ŋgərpa la dza uwana atal kaf à gəl, avà à ahàl aŋa azladza!” ");
INSERT INTO mfh_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ŋgaha azlaanik uwanay tadzəkà manavàh vok kà atà kà atà: “Uwa à uwana adzugw maɗàh tsəhay gà uwaga la tataka gami la abà uwa?”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mabay vok gay atsìzlla ala la tataka aŋa azlaməna matapla la abà, kà masəl dza uwana azlayla magay məŋga aŋatà. ");
INSERT INTO mfh_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu agòɗ à atà: “Azla­su­fəl aŋa gudəŋ à vok takor azladza aŋatà, azlaməna ndzəɗa lakəl aŋatà babay asa à atà kà tazala à atà ala azladza delga. ");
INSERT INTO mfh_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ama akul kà, kiya uwaga aw. Məŋga gà la tataka aŋkul la abà kà apakay kà masla mazəɓ kiwa. Ŋgaha masla makor akul aya kà, agay kà bokuba masla mazəɓ akul dagum. ");
INSERT INTO mfh_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","La dziriga, ma dza ma uwala à uwana məŋga tak la? Uwana adza madzay la tatak may lakəl ay, awma uwana atsak tatak may à azladza, adàha à atà ala ay. Ŋoɗa à gi kà, dza uwana la tatak may lakəl, la uwana məŋga gà. Ama gi kà gi la ahəŋ la tataka aŋkul la abà koksi­koksi bokuba masla maɗahakulla tatak may. ");
INSERT INTO mfh_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Akul kà akul la ahəŋ la gi koksi­koksi la ŋgərpa gulo la abà. ");
INSERT INTO mfh_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ŋgaha bokuba gi, uwana Baba afa à gi à makoray aŋha à abà kà, gi babay kà gədàfa à akul à makoray à abà suwaŋ. ");
INSERT INTO mfh_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kà akul aŋa mazuway la masay tatak la table gulo la afik la makoray gulo, ŋgaha kadà­dzahaw madzay la azla­kursi sufəl la afik kà maɗàh seriya à azlatsəhay kulo gəl aŋha səla aŋa Isərayel à gəl.” ");
INSERT INTO mfh_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu agòɗ à Səmon: “Səmon, Səmon, tsənàŋ tsi: Seteni adanav tetəvi kà magodzal ka kà, bokuba uwana tasəh tatak kà mavàh azla­tafàr gà ala la fofulo delga gà. ");
INSERT INTO mfh_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ama gi kà gədəv kuɗa kà aŋak Piyer, kà madiŋal gəl à vok aŋak aŋa maruw vok à ahəŋ aw, ŋgaha kà pəra aŋa kadàwul à tetəvi à tsəh kà, ɗadzərə̀ɗàhà azla­deda aŋak ala gesina!” ");
INSERT INTO mfh_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piyer agòɗal: “Sufəl, gi kà ɗagəɗ à uwali gəgoɗ aw, amiyaka à daŋay, amiyaka tadàkəɗ ka, kà gi kà, gi nekwa kà mamətsay la slaka gà à anu səla.” ");
INSERT INTO mfh_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ama Sufəl Yesu agòɗ à Piyer: “Tsənàŋ Piyer, lakana kà mew­g­dza­galaŋ ada­wiyay dadàŋ aw, kà magoɗay aŋak kà kasəl gi aw asik makər.” ");
INSERT INTO mfh_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kiya uwaga Yesu agòɗ à atà: “La mok uwana gəsləl akul kokuɗa sili, kokuɗa kiwa, kokuɗa kwimik ma, kanàwkuɗa aŋa tatak takay?” “Awaŋ, mənəkuɗà aŋa tatak aw”, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kiya uwaga Yesu agòɗ à atà: “Lagonay kà, kiya uwatà aya aw, dza uwana sili aŋha la ahəŋ kà, ahəl, dza uwana kiwa aŋha la ahəŋ kà azəɓ, ŋgaha dza uwana katsakar aŋha la ahəŋ aw kà, aduw dəɓdəɓi aŋha ala kà masukw katsakar. ");
INSERT INTO mfh_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kà uwana la dziriga kà tatak uwana tatsetsèr lakəl gulo kà say agəɗ à afik, ˈMasla kà, tatugwla la azlaməna tsakana.ˈ La haɗay kà, uwana tatsetsèr lakəl gulo kà adagəɗ à afik.” ");
INSERT INTO mfh_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Azlaməna matapla la slaka aŋha tagòɗal: “Sufəl, katsakar səla la uwanay ma diga aw takay?” Yesu agòɗ à atà: “Diga uwà gà.” ");
INSERT INTO mfh_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Bokuba uwana zagəlà aŋa Yesu, asà à uda, adà aŋha à gudəŋ kuvu à afik. Azlaməna matapla la slaka aŋha tanəfà la tsəh. ");
INSERT INTO mfh_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mok uwana tabə̀z à slaka uwatà à abà kà: “Də̀vàw kuɗa kà akul aŋa matəɗ à mapa­patay à abà aw!”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Masla azà à atà vok la vok ala, zaɗ daməl akur, akədèɗ à ahəŋ, adə̀v kuɗa. ");
INSERT INTO mfh_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Baba, baŋa asa à ka kà, zà kətsaw ŋgərpa uwanay ala la slaka gulo. Ama kaɗahaŋ kà mawoyəŋ gulo aw, say aŋak!” (( ");
INSERT INTO mfh_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kiya uwaga malika asà à ahəŋ la zagəla adzərəɗàŋ ala. ");
INSERT INTO mfh_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Adə̀v kuɗa la mazaw la gəl məŋga, amə̀ts à madəv kuɗa à abà tsəràh à uwana aŋuf anàɗal à adi ala, vikuza bokuba aŋiz.)) ");
INSERT INTO mfh_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mok uwana adadəv madəv kuɗa à gay kà, asà à waŋ à slaka azlaməna matapla aŋha, aɓə̀z atà à gəl, kà atà la madzehal aŋa mazaw la gəl la abà. ");
INSERT INTO mfh_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Agòɗ à atà: “Kà mana kadzewhal ma? Sàw à afik də̀vàw kuɗa, kà akul aŋa matəɗ à mapa­patay à abà aw.” ");
INSERT INTO mfh_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Uwana Yesu alə̀g la maɓaɗma la abà kà, maham à ahəŋ dza azlàŋal, atà la azla Yudas, tekula aŋa azlaməna matapla kulo gəl aŋha səla, uwana tatà­pàhla tatak la slaka aŋha. Tazà vok à awtày à slaka Yesu. ");
INSERT INTO mfh_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ama Yesu agòɗal: “Yudas, la makəs gi à vok la uwana kaduw Kona aŋa dza ala takay?” ");
INSERT INTO mfh_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Mok uwana azladza uwana la Yesu tanəŋà uwaga adzəkà vok kà, tagòɗal: “Sufəl, mətsəɗ à atà kuda à gəl la katsakar ay?” ");
INSERT INTO mfh_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tekula la tataka aŋa azlaməna matapla la abà aɗə̀ɗ magamza aŋa madza­haga aŋa azlaməna mav tatak à Zəzagəla, anàtsal sləm lakəl ala. ");
INSERT INTO mfh_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ama Yesu avərà gay: “Sàkàw uwaga, digiya”, agòɗ à atà. Yesu adəɓanì sləm aŋa dza uwatà awuràŋ ala. ");
INSERT INTO mfh_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kiya uwaga Yesu agòɗ à azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla, la azlaməŋga aŋa azlaməna manəŋla gày Zəzagəla, ŋgaha la azla­ma­siga: “Kasàwwàŋ kà makəs gi la azla­ka­tsakar la azlaazəva la ahàl, bokuba gi masla nabəra ŋuwà? ");
INSERT INTO mfh_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Te­ke­ɗika kəla mavakay kà, məgàh anina la məŋ gày Zəzagəla la aku, uwala katàpàw gi ahàl à vok aw. Ama uwanay kà adagay kà kaslà aŋkul, la ndzəɗa aŋa mələs.” ");
INSERT INTO mfh_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Takàs Yesu, tadàlla à mtəga aŋa məŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla; Piyer anəfà à atà la tsəh zaɗamma. ");
INSERT INTO mfh_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","La mok uwatà kà, anasl la ahəŋ, tavàts akàl à kodal à abà, Piyer adzà madzay la slaka azladza uwana la akàl la adi. ");
INSERT INTO mfh_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Masla sləray misga tekula anəŋà Piyer adzà à akàl à adi, atsə̀kal yewdi à gay la magoɗay: “Zil uwanay babay kà tau­guzàh atà səla.” ");
INSERT INTO mfh_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ama Piyer aɗahà fida: “Gəsəl masla aw, gəgoɗ à ka, mis!” ");
INSERT INTO mfh_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Zwek la huma la gay dza anik anəŋàŋ, agòɗal: “Kak babay kà, kak tekula aŋatà.” Ama Piyer agòɗ à dza uwaga: “Awaŋ, gi tekula aŋatà aw.” ");
INSERT INTO mfh_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mok uwana tasà­fànì kà, dza anik awaslàŋ à afik la magoɗay: “Ndzer, dza uwanay kà tau­guzàh atà səla, masla babay kà zil Galili.” ");
INSERT INTO mfh_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ama Piyer agòɗ: “Kona, gəsəl uwana asa à ka mapəhay aw!”, uwana talə̀g la mavats gay la abà kà, mew­g­dza­galaŋ awiyà. ");
INSERT INTO mfh_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Sufəl Yesu agòla vok, anəŋà à Piyer à adi, ŋgaha awùl à Piyer à gəl, à gay aŋa sufəl uwana apə̀hal à vok à abà uwarà: ‘Gurayŋa mew­g­dza­galaŋ ada­wiyay lakana kà asik makər kà, kadà­goɗay kà, kasəl gi aw.’ ");
INSERT INTO mfh_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Piyer asà à uda atùw la iyaw tugwi. ");
INSERT INTO mfh_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Azladza uwana tanə̀ŋla Yesu takəɗàslal, ŋgaha tazlàɓ. ");
INSERT INTO mfh_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tawàɗal lukut à yewdi à ama, tanàval: “Uwa à uwana aɗə̀ɗ kà tak uwa? Sə̀l zlà!” ");
INSERT INTO mfh_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ŋgaha tatsə̀kal azla­ma­go­ɗahay anik anik à gəl aya. ");
INSERT INTO mfh_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Uwana məl adawula kà, azla­ma­siga aŋa azla Yahu­diya, la azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla, la azlaməna mapàhla mapəhay ala, tahamà gay à vok, ŋgaha tadàla Yesu à huma à azlaməna sawaray aŋatà ");
INSERT INTO mfh_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","la magoɗay: “Baŋa kak Kristu kà: Pə̀h à anu!” Ama Yesu agòɗ à atà: “Gədapəh à akul bay kà, kafàwwal sləm aw, ");
INSERT INTO mfh_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","à bà gənava à akul à manavay tekula bay kà, kawullaw gi ala aw. ");
INSERT INTO mfh_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ama dagay lakana Kona aŋa dza adza madzay la ahàl kaf aŋa Baba Zəzagəla lakəl, uwana Zəzagəla adahama ala ndzəɗa gesina.” ");
INSERT INTO mfh_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Gesina aŋatà tagòɗ: “Lagwa zlà ma, kak Kona aŋa Zəzagəla ay?” Kiya uwaga Yesu agòɗ à atà: “Iyay, kiya uwana kagoɗaw kà, gi masla!” ");
INSERT INTO mfh_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kiya uwaga tagòɗ: “Lagwa kà, məyàh azlaməna sayda aya zlà ma aw. Anu la gəl gami kà, məda­tsənəŋ paŋaw aŋha adagay.” ");
INSERT INTO mfh_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ŋgaha la abatà kà, maham à ahəŋ dza gesina tatsìzlla ala, tadàla Yesu à huma Pilatus. ");
INSERT INTO mfh_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tadzəkà makallal gay à vok la magoɗay: “Dza uwanay kà, masla mapəs à tsəh à gudəŋ gami à afik, ‘Dza apəl hadama à Zəsar aw’, agòɗ, ŋgaha ‘Gi Kristu, gi Sufəl’, agòɗ aya.” ");
INSERT INTO mfh_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatus anàval à gay ala: “Kak la uwana kak Sufəl aŋa azla Yahu­diya, haɗay ay?” “Iyay, kiya uwana kapə̀h”, Yesu agòɗal. ");
INSERT INTO mfh_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatus agòɗ à azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla, ŋgaha à maham à ahəŋ dza: “Ɗi­ki­ɗiki gəɓəz à mawi­siga aŋa dza uwanay aw.” ");
INSERT INTO mfh_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ama tazà kuda à zagəla la ndzəɗa. “Masla la uwana apə̀s à tsəh à maham à ahəŋ dza à afik la matapla aŋha. Adzəkà la Galili, la Yahu­diya gesina, tsəràh à uwana adabəzla à abanay lakana.” ");
INSERT INTO mfh_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mok uwana Pilatus atsənà uwaga kà, anàv: “Konnay ma, zil Galili takay?” ");
INSERT INTO mfh_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Uwana ada­tse­nəŋ kà, asà à waŋ kà la makoray aŋa Herod la abà kà, aslə̀l masla à slaka Herod, kà uwana la mavakay uwatà kà, Herod kà agà la Uru­sa­lima. ");
INSERT INTO mfh_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mok uwana Herod anəŋà Yesu kà, aràb məŋga, kà uwana ayahay aŋa manəŋəŋ kà dagay uwarà, kà uwana atsənà gay uwana tapəhay lakəl aŋha kà delga. Ŋgaha adzùgw kà Yesu, aɗahalla nadzipo. ");
INSERT INTO mfh_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Anà­vàhal azla­ma­navay aŋuvaw, ama Yesu aɓà­ɗalma aw. ");
INSERT INTO mfh_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla, la azlaməna matapla mapəhay à azladza la abatà, tapùwla gudzi à gəl la ndzəɗa. ");
INSERT INTO mfh_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod la azla­slodzi aŋha takəɗàslal, tatərə̀ɓàŋ, tadùwal lukut delga gà à vok, ŋgaha tawùlla masla à slaka Pilatus. ");
INSERT INTO mfh_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","La mok uwatà la uwana Herod atà la Pilatus takə̀s vok slawda, kayka uwarà kà tasà vok iyaw aw. ");
INSERT INTO mfh_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatus ahamà gay azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla à vok, la azla­ma­la­haga aŋa gudəŋ uwatà. ");
INSERT INTO mfh_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ŋgaha agòɗ à atà: “Akul, kasàwgəla dza uwanay à waŋ kà: ‘Apə̀s à tsəh à gudəŋ à afik’, kagoɗaw. Iyay, lagonay kà gənàval gay kà la huma aŋkul gesina, ama gəɓə̀z à mawi­siga la slaka aŋha kà madukwla seriya à gəl la mapuwla gudzi à gəl uwana kapùwwal à gəl aw. ");
INSERT INTO mfh_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Amiyaka Herod babay kà, anəŋà mawi­siga aŋha aw, kà uwaga à uwana aslə̀l anu à abanay. Kiya uwaga dza uwanay aɗahà mawi­siga takəɗla aw!” ");
INSERT INTO mfh_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Pilatus agòɗ: “Lagwa kà gəslahəŋla pəra, ŋgaha gəduwal gəl, ada aŋha.” (( ");
INSERT INTO mfh_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kəla madəvaday Paska kà, gumna adawàh gəl à masla daŋay tekula uwana asa à maham à ahəŋ dza, kà uwana uwaga kà adagay zagəlà aŋha kà madaw à atà la gəl kəla madəvaday.)) ");
INSERT INTO mfh_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ama gesina aŋatà tawiyà la ndzəɗa: “Kə̀ɗ kà kona uwaga, kaduwanula gəl à Barabas!” ");
INSERT INTO mfh_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Tadùw Barabas à daŋay te­ke­ɗika uwana apə̀s à tsəh à gudəŋ à afik, akàɗ dza.) ");
INSERT INTO mfh_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bà gotənaŋ Pilatus anavà atà gay ala aya, kà uwana asàl maduw gəl à Yesu. ");
INSERT INTO mfh_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ama tazà kuda à zagəla la mawiyay: “Zlə̀l masla à ahàf à adi, zlə̀l masla à ahàf à adi.” ");
INSERT INTO mfh_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatus awùlla à atà la tsəh kà mamakər la magoɗ à atà: “Mawi­siga ma uwala à uwana aɗahàŋ la? Gəɓəzà à mawi­siga la slaka aŋha amiyaka bà tekula uwana takəɗla aw!”, Pilatus agòɗ à atà: “Ama gəsla­həŋ ala la kurpi, ŋgaha gəduwalla à gəl.” ");
INSERT INTO mfh_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ama tasà mawiyay à zagəla kaykay la magoɗay: “Say mazləl masla à ahàf à adi”, ŋgaha mawiyay aŋatà agə̀ɗ à afik. ");
INSERT INTO mfh_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ŋgaha kà bokuba uwana asà à atà la uwana Pilatus agəɗàŋ à afik, kà marab ləv aŋatà. ");
INSERT INTO mfh_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kiya uwaga kà, apə̀lla à atà masla makaɗ dza uwana ala, tadùw à daŋay la mapəs à tsəh à gudəŋ à afik la tsəh, kiya uwana maham à ahəŋ dza uwaga anàv. Ŋgaha tavà à atà Yesu à ahàl, kà atà aŋa maɗa­hallaŋ, bokuba uwana asà à atà. ");
INSERT INTO mfh_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mok uwana tadàla Yesu, tagagàm la dza anik uwana sləm aŋha Səmon, atsà à waŋ la fəta, masla kà zil gudəŋ Səren. Azla­slodzi takə̀s, tafàl ahàf à kuda kà manəfla Yesu la tsəh. ");
INSERT INTO mfh_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Maham à ahəŋ dza aŋuvaw, la azlamis, tanəfà la hulolo ŋgaha la mataway kà masla, taɓàk ahàl à gəl. ");
INSERT INTO mfh_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu agòt ala à huma à gay, agòɗ à atà: “Azlamis gudəŋ Uru­sa­lima katuwaw kà gi aw, ama tùwàw à gəl aŋkul la azlabəza aŋkul, ");
INSERT INTO mfh_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","kà uwana mavakay adàsa à waŋ à uwana tadà­goɗay kà: ‘Marabay kà la azla­dəgər, la azla­uwana azlabəza tasà awà aŋatà aw.’ ");
INSERT INTO mfh_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kiya uwaga azladza tadàdzəka magoɗàh azla­gu­dəŋ: ‘Taɗaw anu à gəl, ŋgaha hàɗàhàw anu à ahəŋ’, tadà­goɗah à azla­dadəgwal. ");
INSERT INTO mfh_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Baŋa dza aɗehəŋ kiya uwanay la ahàf biyaga, ma kakay adàpaka vok la magolga ma?” ");
INSERT INTO mfh_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tadàla azlaməna nakəra anik à awtày səla, kà makaɗ atà la slaka gà. ");
INSERT INTO mfh_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mok uwana tabə̀z à slaka uwana Gol­go­ta tagòɗal kà, (Uwana asal magoɗay: slaka həraŋ gəl), tatàslàh atà à ahàf à adi tekula la ahàl kaf, tekula la ahàl gudzay aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kiya uwaga Yesu agòɗ: “Baba, basà à atà tsakana aŋatà, kà uwana tasəl uwana taɗehəŋ aw!” Ŋgaha tavàhà lukut aŋha la tataka aŋatà la abà, la matsal tsatsa lakəl. ");
INSERT INTO mfh_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Maham à ahəŋ dza la abatà, azla­ma­siga aŋa azla Yahu­diya uwana la abatà tadzəkà makəɗaslla Yesu la magoɗal: “Masla uwana aɓàlàhà azladza anik kà, masla la gəl aŋha kà, aɓəla gəl aŋha suwaŋ zlà, à baŋa masla kà Kristu, uwana Zəzagəla akə̀sànì tak zlà!” ");
INSERT INTO mfh_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Azla­slodzi babay takəɗàslal; tatə̀ɗalla iyaw hamhamga, ");
INSERT INTO mfh_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ŋgaha tagòɗal: “Baŋa kak la uwana sufəl aŋa azla Yahu­diya kà, ɓə̀lla gəl aŋak zlà!” ");
INSERT INTO mfh_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Aganay à uwana tatsetsèr à gəl aŋha à afik: DZA UWANAY KÀ SUFƏL AŊA AZLA YAHUDIYA. ");
INSERT INTO mfh_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tekula la tataka aŋa azladza səla uwana la abà tatàsl à atà à ahàf à adi atà nna, akəɗàslal la magoɗay: “Kak kà, kak Kristu aw takay? Ɓə̀lla gəl aŋak, ŋgaha ɓə̀lla anu babay zlà!” ");
INSERT INTO mfh_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ama anik uwanay apìsal iyaw à tsəh la kaykay agòɗal: “Kahoy yewdi aŋa Zəzagəla, à kà uwana kagaw la seriya tekula la abà la masla aw takay? ");
INSERT INTO mfh_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kà aŋami kà uwanay takàɗ anu kà, azlayla atà takàɗ anu. Kà uwana leri məɓəzaw à masik aŋa tatak uwana məɗa­hàwwàŋ. Ama masla kà, aɗahà mawi­siga amiyaka bà tekula à ahàl aw.” ");
INSERT INTO mfh_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ŋgaha agòɗal: “Kamkam Yesu, ɗafà gi à ahəŋ la sləm, à vuɗ uwana kadàgay la makoray aŋak la abà.” ");
INSERT INTO mfh_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu agòɗal: “Haɗay, gəpəh à ka la dziriga: Lakana uwanay kà, kadàgay la makoray gulo la abà, anu səla.” ");
INSERT INTO mfh_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","La tataka afats mələs apakà vok la kutso la abà gesina tsəràh afats dat magova gova gərewni delga. ");
INSERT INTO mfh_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Mok uwana afats adakəl mələs kà, bafta uwana la gày Zəzagəla la aku akwohà la tsəràh à afik tsəràh à vəɗah, la tataka la abà. ");
INSERT INTO mfh_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kiya uwaga Yesu awiyà la ndzəɗa agòɗ: “Baba, gəsaka masasəɗok gulo kà la ahàl aŋak.” Mok uwana adapəh uwaga la gay ala kà, amə̀ts. ");
INSERT INTO mfh_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Məŋga aŋa azla­slodzi aŋa azla Rom anəŋà tatak uwana apakà vok gesina, adzəkà magoɗay: “Ndzer kà, dza uwanay kà, dza dziriga”, ŋgaha adzəkà mazləɓ Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","La lig la ahəŋ kà, maham à ahəŋ dza gesina uwana tasà à waŋ kà manəŋ uwana apakà vok gesina kà, tawùl à mtəga la madaɗ gay ləv. ");
INSERT INTO mfh_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Azla­slawda aŋa Yesu la azlamis uwana tanəfà à waŋ dagay la Galili, tatsàzl à fəta à awtày kà manərəz tatak uwana apakà vok gesina. ");
INSERT INTO mfh_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Dza anik la ahəŋ uwana sləm aŋha Yusufu, uwana la tataka aŋa azla­ma­siga la abà, masla babay kà dza dziriga. ");
INSERT INTO mfh_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Masla kà adzugway kà lakəl aŋa mas à waŋ makoray Zəzagəla, masla kà atsənà sawaray aŋa azladza anik babay aw, masla kà zil gudəŋ Arimate, la kutso Yahu­diya la abà. ");
INSERT INTO mfh_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ahàd, abə̀z à Pilatus à vok kà manaval mazim­nekiɗ aŋa Yesu. ");
INSERT INTO mfh_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Uwana Pilatus adaval tetəvi kà azə̀ɓ vok aŋa Yesu à ahəŋ la ahàf la adi kà, afa­fàɗal lukut à adi. Ŋgaha adàlla à zəvay mawga uwana à agu talà à təhus à afik, tafà dza à agu didi dadàŋ aw. ");
INSERT INTO mfh_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Vuɗ uwatà kà, vuɗ maɗàh vok à ahəŋ aŋa vuɗ maduw ləv. ");
INSERT INTO mfh_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Azlamis uwana tanəfà Yesu à waŋ la tsəh dagay la Galili, tanəfà Yusufu à waŋ, tanəŋà zəvay, ŋgaha la tsəhay maf Yesu uwana à ahəŋ tahənàŋ à ahəŋ la zəvay la aku. ");
INSERT INTO mfh_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ŋgaha tawùl à mtəga aŋatà, ŋgaha taɗahà vok à ahəŋ la azlaamàl, la azla­matərsin kà maɗàh à Yesu à vok. Ŋgaha la vuɗ maduw ləv kà taduw ləv bokuba uwana mapəhay agoɗ. ");
INSERT INTO mfh_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Bəŋ la zay la tsəh, vuɗ ladu kà, azlamis uwatà tadàla azlaamàl la azla­matərsin uwana taɗahàŋ à ahəŋ kà madla. ");
INSERT INTO mfh_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Azlamis tabə̀z à zəvay à gəl kà mata­koslal ɓəlam la ama ala gà, zaɗ zwek la gay zəvay. ");
INSERT INTO mfh_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tadà à agu, ama tanəŋà sləɓ vok aŋa Sufəl Yesu aw. ");
INSERT INTO mfh_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Gəl akàɗ à atà à vok. Bokuba uwana atà la madzugway la abà kà, azla­ma­lika səla tatsàkwàh à lukut me­ɗe­kuga təlla gà à abà, tapə̀hatàla vok. Lukut aŋatà aŋəràzl atà à adi. ");
INSERT INTO mfh_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ama uwana guba adakaɗ à atà à gay gesina kà, sasukwà tadzà à ahəŋ, azladza uwatà tagòɗ à atà: “Kà mana kayahaw dza uwana la sifa la tataka azla­ma­zim­nekiɗ la abà ma? ");
INSERT INTO mfh_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Aga la abanay aw, ada­wula à uda la mamətsay. Dzùgwàw lakəl aŋa uwana apəh à akul la mok uwana à lig la Galili tsi. ");
INSERT INTO mfh_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Say Kona aŋa dza agày mav à ahàl aŋa azlaməna tsa­ka­naga, ŋgaha tadà­ta­tasl à ahàf à adi, ŋgaha awul à uda la mahənay mamakər.” ");
INSERT INTO mfh_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kiya uwaga awùlla atà à gəl à gay aŋa Yesu uwana apə̀h à atà. ");
INSERT INTO mfh_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ŋgaha tatsìzlla ala la gəl zəvay, tadàla gay uwaga à slaka azlaməna matapla kulo gəl aŋha tekula uwanay, ŋgaha à azladza anik gesina bay. ");
INSERT INTO mfh_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Uwaga kà azla Mari­yama dəg zla Magdala, Yohana, ŋgaha Mari­yama iyà aŋa Yakuba, la azlamis anik uwana tahàd atà nna, tapə̀h gay uwaga à azlaməna matapla aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ama azlaməna matapla uwaga tafà sləm à gay uwaga aw, uwaga kà: ‘Gay mase­siŋay’, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ama Piyer atsìzlla ala, ahàd à gel zəvay; anəŋà à agu kà, anəŋà kà azla­ga­baga pəra, ŋgaha awùl à mtəga la mavalàh à zagəla kà tatak uwana apakà vok. ");
INSERT INTO mfh_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","La mavakay uwaga Piyer awùl à lig, aganay azladza səla la tataka azlaməna manəf Yesu la tsəh, tadà à gudəŋ uwana sləm aŋha Emawus. Tataka aŋatà atà la Uru­sa­lima kà bokuba magur mahoy pəlis zlo mala məkwa. ");
INSERT INTO mfh_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tavàts gay la tetəvi la ama, lakəl aŋa tatak uwana apakà vok gesina. ");
INSERT INTO mfh_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kiya uwaga mok uwana tabày vok la mavats gay kà, Yesu adasa à waŋ à slaka aŋatà, tahàd la tetəvi la ama atà nna. ");
INSERT INTO mfh_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","La abatà tanəŋàŋ masla, ama tatak anik aɗə̀ɗ à atà gay à ahəŋ, kà aŋa masəlay. ");
INSERT INTO mfh_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","La abatà Yesu aɓa­ɗa­tàmà: “Lakəl ma aŋa mana ma, kabàyàw vok gay la tetəvi la ama ma?”, agòɗ à atà. Ŋgaha tatsìzlla à ahəŋ la mazaw la gəl. ");
INSERT INTO mfh_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","La kità tekula aŋatà, uwana sləm aŋha Kəle­yopas, agòɗal: “Kak ma, kak məlok aŋa Uru­sa­lima ay? Kasəl uwana apakà vok la mahənay uwanay la abà aw takay?” Dza uwaga anavà atà: “Mana apakà vok ma?” ");
INSERT INTO mfh_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Aa, à tatak uwana apakà vok la Yesu, zil Nazaret uwana masla mapəhal gay à ahàl aŋa Zəzagəla aŋa mapàh à azladza, masla maslay, la ndzəɗa la gay la abà la huma Zəzagəla, ŋgaha la slaka azladza ay? ");
INSERT INTO mfh_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ama azla­ma­siga aŋa azlaməna mav tatak à Zəzagəla, la azlaməna makoray gami tavà à ahàl aŋa azladza aŋa makəɗay la mata­tasl à ahàf à adi. ");
INSERT INTO mfh_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Te­ke­ɗika anu mənawàŋ kà masla la uwana adàzlak Isərayel, ama lakana mahənay mamakər aŋha à uwana tatak uwanay apakà vok. ");
INSERT INTO mfh_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ŋgaha aya kà, azlamis anik la tataka gami la abà, takàɗ anu gəl à vok. Kà uwana bəŋ la zay la tsəh lakana kà, tahàd à gəl zəvay. ");
INSERT INTO mfh_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ama taɓəzà mazim­nekiɗ aŋa Yesu aw, tawùl à waŋ aŋa mapəh à anu, kà azla­ma­lika tapə̀h à atà vok, ŋgaha tapə̀h à atà la paraka, kà Yesu la adi. ");
INSERT INTO mfh_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mok uwana azlamis tapə̀h uwaga kà, azlaməna gami anik tahàd à gel zəvay, ŋgaha tanəŋàŋ gesina bokuba uwana azlamis tapə̀h, ama masla kà, tanəŋàŋ aw.” ");
INSERT INTO mfh_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","La kaslà uwatà Yesu agòɗ à atà: “Kayyà, akul azladza matsən sləm aw gà, akul azla­nalnal aŋa makəs mapəhay aŋa azladza uwana Zəzagəla apə̀h à atà gay à ahàl aŋa mapàh à azladza! ");
INSERT INTO mfh_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kiya uwaga Kristu asà ŋgərpa dadàŋ la uwana ada à makoray aŋha à abà?” ");
INSERT INTO mfh_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kiya uwaga apə̀h à atà à gay uwana tatsetsèr lakəl aŋha la wakità Zəzagəla la abà gesina, la wakità aŋa Musa la abà, akə̀ɗal gəl la wakità aŋa azladza uwana Zəzagəla apəh à atà gay à ahàl kà mapàh à azladza. ");
INSERT INTO mfh_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Uwana tazlà­bə̀z à gudəŋ uwana à abà asà à atà maday kà, dza uwaga azə̀ɓ atà asik lakəl ala. ");
INSERT INTO mfh_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Azladza səla uwanay tazàlal à tsəh la magoɗal: “Mədzà à ahəŋ anina adagay vəɗ.” Ŋgaha adagay kà madz à ahəŋ atà nna. ");
INSERT INTO mfh_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kaslà aŋa mazuw tatak may adaslay kà, tadzəkà madz à tatak may à adi la slaka gà, uwana tadzàl à adi kiya uwaga kà, azə̀ɓ kaf, “Kikay”, agòɗ à Zəzagəla, atsakàŋ ala, avà à atà. ");
INSERT INTO mfh_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","La katskats yewdi aŋatà apə̀zlla à ama ala, tasə̀l masla, ama azà à atà à adi. ");
INSERT INTO mfh_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","“Agà! Mok uwana aɓa­ɗa­numà, apə̀h à anu gay Zəzagəla la tetəvi la ama kà, ləv azlawàh kà anu à ama aw takay?” ");
INSERT INTO mfh_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","La gay uwaga hahadzàk tavàlàh à afik, tawùl à Uru­sa­lima. Taɓə̀z azlaməna matapla kulo gəl aŋha tekula à gəl la azla­sla­gama aŋatà. ");
INSERT INTO mfh_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tagòɗ: “Ndzer, məŋga gami kà awùl à uda la mamətsay, kà uwana Səmon Piyer anəŋàŋ. ");
INSERT INTO mfh_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kiya uwaga azladza səla uwanay tawùl à waŋ à slaka aŋatà, tapə̀h à atà gay uwana apakà vok la tetəvi la ama, la masəl Yesu aŋatà la mok uwana atsəkà kaf ala.” ");
INSERT INTO mfh_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mok uwana talə̀g la maɓaɗma la abà aya, à uwana Yesu atsìzlla à tataka aŋatà à abà, aɗahà à atà ‘Ayyi’, agòɗ à atà: “Lapiya agay la akul!” ");
INSERT INTO mfh_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","La abatà aŋidz ahamà à atà à gəl məŋga, kà uwana: ‘Mədanəŋ tatak mavavat dza’, gəl agoɗ, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kiya uwaga masla agòɗ à atà: “Kà mana kaguɗə̀kàhàwla ala ma? Kà mana katsàw gay la ləv aŋkul la tsəh ma? ");
INSERT INTO mfh_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Bà, gi ndzer gəvàlàw à ahàl gulo la azlaasik gulo tsi, dəɓà­wànì gi, kà uwana tatak mavavat dza kà la sləɓ vok, la aslasl, bokuba dza aw.” ");
INSERT INTO mfh_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Uwana adapəh à atà gay uwaga, apə̀hatàla ahàl aŋha, la azlaasik aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ama taslàla vok aŋa makəsay aw, kà uwana marabay aɗuwà ndzəɗa aŋatà; la abatà Yesu anavà atà: “Tatak may aga la akul la ahàl ay?” ");
INSERT INTO mfh_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Maslà tavàl tenma aŋa kilfi mana­zayga la pə̀hàw malpayga, la zuway mazuway. ");
INSERT INTO mfh_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Azə̀ɓ, ŋgaha apàɗ la huma aŋatà. ");
INSERT INTO mfh_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","La lig la ahəŋ agòɗ à atà: “Mok uwana gi la akul gəgòɗ à akul kà: Tatak uwana matse­tse­rayga lakəl gulo la wakità aŋa Musa la abà la azla­uwana la wakità aŋa azlaməna mapəh à atà gay à ahàl la abà kà mapàh à azladza anik, ŋgaha la uwana la mahabay aŋa David la abà gesina kà, azlayla kà vok apakà vok haɗay.” ");
INSERT INTO mfh_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","La abatà Yesu apakwà haŋkəli aŋatà, kà atà aŋa matsən wakità Zəzagəla uwaga. ");
INSERT INTO mfh_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ŋgaha agòɗ à atà aya: “Aganay, à gay uwana tatsetsèr à abà: ˈKristu as ŋgərpa dadàŋ, ŋgaha kà masla aŋa mawul à uda la mamətsay la mahənay mamakər. ");
INSERT INTO mfh_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kiya uwaga azlayla vok, kazàw gay uwanay à azladza gesina la sləm aŋha, kadzaw kà la abanay la Uru­sa­lima, tsəràh à makaɗ gəl à ahəŋ gudəŋ à vok gesina, zàw à atà gay mapəh gay la ləv ala, la gay mabasa à atà tsakana aŋatà.ˈ ");
INSERT INTO mfh_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Akul kà, akul azlaməna sayda aŋa uwaga. ");
INSERT INTO mfh_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kiya uwaga, gi la gəl gulo gədà­sləlla akul Masasəɗok Zəzagəla uwana à ahəŋ, Baba gulo apə̀h à ahəŋ uwarà, ama say: Dzàw à ahəŋ la gudəŋ uwanay tsəràh à uwana ndzəɗa aŋa Masasəɗok uwaga adàsa à akul à gəl dadàŋ, la uwana kadàdaw.” ");
INSERT INTO mfh_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","La lig aŋa uwaga la ahəŋ gesina, Yesu asə̀lla atà à uda la gudəŋ la abà tsəràh à uwana tazlà­bə̀z à gudəŋ Be­ta­niya. Mok uwana tadabəz à abatà kà adzìyla ahàl à zagəla, ŋgaha apìs à atà gay à vok. ");
INSERT INTO mfh_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","La abatà Zəzagəla azə̀ɓ à slaka aŋha. ");
INSERT INTO mfh_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kiya uwaga tazləɓà, ŋgaha tawùlla à Uru­sa­lima la marabay məŋga. ");
INSERT INTO mfh_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ama tadzàhà à ahəŋ koksi­koksi la məŋ gày Zəzagəla la aku kà mazləɓ Zəzagəla.");
INSERT INTO mfh_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mok uwana Zəzagəla alə̀g maɗàh gudəŋ à vok dadàŋ kà, agà la ahəŋ uwana tazàlalla Gay. Gay uwatà adzà à ahəŋ la Zəzagəla. Gay uwaga kà Zəzagəla la gəl aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Gay uwaga agà la Zəzagəla dagay madzəka. ");
INSERT INTO mfh_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tatak gesina uwana Zəzagəla aɗahàŋ kà, kà masla; tatak anik la ahəŋ à uwana Zəzagəla aɗahàŋ kokuɗa masla aw. ");
INSERT INTO mfh_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Sifa kà la masla la abà, sifa uwatà kà avà uɗaka à azladza. ");
INSERT INTO mfh_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Uɗaka uwaga aùɗ la mələs la abà, mələs aslalà vok à mamatsiŋ ala aw. ");
INSERT INTO mfh_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Zəzagəla aslə̀l dza anik uwana à waŋ, sləm aŋha Yuhana. ");
INSERT INTO mfh_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Asà à waŋ kà, kà maz sayda aŋa uɗaka. Asà à waŋ kà, kà azladza gesina kà madiŋal gəl à vok, kà made­golay uwana apàh. ");
INSERT INTO mfh_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Masla à Yuhana agà uɗaka la gəl aŋha aw, ama asà à waŋ kà maz sayda lakəl aŋa uɗaka uwaga. ");
INSERT INTO mfh_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Uɗaka uwaga kà agà uɗaka dziriga, asà à waŋ à gudəŋ à vok, uwaga aùɗ à azladza gesina. ");
INSERT INTO mfh_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Gay uwaga agà la gudəŋ la vok. Zəzagəla aɗahà gudəŋ à vok kà la masla, ama azladza uwana la gudəŋ la vok tasə̀l aw. ");
INSERT INTO mfh_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Agà la tataka aŋa azladza aŋha la abà, ama azladza aŋha takweskà. ");
INSERT INTO mfh_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ama azla­uwana takə̀s, la azla­uwana tadiŋal gəl à vok, avà à atà maslay kà mapa­kahay azlabəza aŋa Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tapàk azlabəza aŋa Zəzagəla la tetəvi aŋa azladza la mayyay aŋa vəɗah, bokuba uwana azladza tatugway aw. Ama Zəzagəla la uwana, avà à atà sifa mawga. ");
INSERT INTO mfh_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Gay uwaga apàk dza la sləɓ vok, adzà à ahəŋ la tataka gami la abà. Ləv aŋha kà tekula la slaka azladza, adahənla la dziriga, kà aŋha kà, apə̀hanula mazləɓay aŋha, uwana la mazləɓay uwana bəzi tekula aɓə̀zal la slaka Baba aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yuhana azà sayda lakəl aŋha, awiyà: “Lakəl aŋha gəpə̀h à akul à uwana gəgòɗ: ‘Masla manəf gi à tsəh à waŋ atsà à waŋ, ama masla la uwana mazləɓayga kà gi, masla kà agà la ahəŋ dagay uwana taləg mayyi gi, aɗuwa gi la maslay’, gəgoɗ à akul.” ");
INSERT INTO mfh_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Anu gesina məɓəzà à masik la gorobu la abà; məɓəzà à mapis gay à vok kaykay lakəl aŋa mapis gay à vok aya. ");
INSERT INTO mfh_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Zəzagəla avà à anu mapəhay la ahàl aŋa Musa, ama vok mahamay la dziriga kà tasà à waŋ kà la ahàl aŋa Yesu Kristu. ");
INSERT INTO mfh_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Dza adanəŋ Zəzagəla ɗiki­ɗiki aw, ama Kona aŋha tekula gà, uwana la makəla aŋa Baba lakəl, la uwana apə̀hanula masla. ");
INSERT INTO mfh_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Aganay uwana Yuhana apə̀h à mok uwana azla Yahu­diya la Uru­sa­lima taslə̀l azlaməna mav tatak à Zəzagəla la azlaməna sləray la məŋ gày Zəzagəla la aku à slaka aŋha kà manaval: “Kak ma, kak uwa?” ");
INSERT INTO mfh_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Akweskà mawulatàla aw, ama adzaɗàŋ ala la paraka la huma aŋatà gesina: “Gi kà, gi Kristu aw.” ");
INSERT INTO mfh_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Kak uwa zlà ma uwa? Kak Eliya, uwana tapàh uwarà ay?” “Awaŋ, gi masla aw”, Yuhana agòɗ à atà. “Kak masla mapəhal gay ahàl aŋa Zəzagəla ay?”, tagòɗal. “Awaŋ”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kiya uwaga tagòɗal: “Kak uwa zlà ma uwa? Say kapəh à anu gay ŋgaha mədàpəh à azla­uwana taslə̀l anu à waŋ. Kak la gəl aŋak ma: ‘Gi uwà’ kagoɗ lagwa uwa?” ");
INSERT INTO mfh_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yuhana agòɗ à atà: “Gi kà gi ˈKuda aŋa dza uwana awiyay la kəsaf la abà: Ɗahàw tetəvi tərra à ahəŋ kà aŋa Sufəl!ˈ” (Kiya uwaga à uwana masla mapəhal gay à ahàl Yesayya atsetsèr à wakità Zəzagəla à abà) ");
INSERT INTO mfh_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","La tataka azlaməna masləl atà à waŋ uwatà la abà kà, azla Farisəya la abà. ");
INSERT INTO mfh_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Tanavà Yuhana: “Tsa aŋa kak Kristu aw, kak Eliya aw, kak masla mapəhal gay à ahàl kà mapàh à azladza aw, ma kà mana kaɗàh batem zlà ma?” ");
INSERT INTO mfh_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yuhana agòɗ à atà: “Gi gəɗa­ha­kullaŋ batem kà la iyaw; dza anik la ahəŋ la tataka aŋkul la abà, kasəlaw aw, ");
INSERT INTO mfh_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","atsa à waŋ la lig gulo la ahəŋ, ama gi bay kà gəsla kà mapəl zuwiɗ kwimik aŋha ala babay aw.” ");
INSERT INTO mfh_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tatak uwaga gesina aɗahà vok la Be­ta­niya, la gay dərəv uda anik aŋa mukwà Urdun, la slaka uwana Yuhana aɗahà batem. ");
INSERT INTO mfh_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","La bebəŋ gà, Yuhana anəŋà Yesu atsà à waŋ à slaka aŋha, agòɗ: “Aganay magadzaw aŋa Zəzagəla uwana azəɓ tsakana aŋa gudəŋ à vok gesina. ");
INSERT INTO mfh_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Lakəl aŋha la uwana gəpə̀h à akul, gəgòɗ à akul: ‘Dza la ahəŋ atsa à waŋ la lig gulo. Masla la uwana mazləɓayga kà gi, kà uwana masla kà, agà la ahəŋ dagay uwana taləg mayyi gi. ");
INSERT INTO mfh_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Gi kà gəsəl masla aw, ama gəsà à waŋ kà maɗàh batem aŋa iyaw à azlatsəhay Isərayel, kà atà aŋa masəl masla.’ ” ");
INSERT INTO mfh_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yuhana agòɗ aya: “Gənəŋà Masasəɗok tsi­kasla atsà à ahəŋ la zagəla bokuba haba­koku, adzà à gəl aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","La mok uwatà gəsə̀l masla aw, ama Zəzagəla la uwana aslə̀l gi kà gi aŋa maɗàh batem: ‘Masasəɗok adàdza madzay lakəl aŋha, masla kà adàɗah batem la Masasəɗok Zəzagəla’, agòɗ à gi. ");
INSERT INTO mfh_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Gədanəŋ uwaga, gəgəɗìŋ à afik, kà masla la uwana Kona aŋa Zəzagəla”, Yuhana agòɗ. ");
INSERT INTO mfh_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","La bebəŋ gà aya kà, Yuhana ada­tsizlla à ahəŋ la abatà la azlaməna matapla la slaka aŋha səla. ");
INSERT INTO mfh_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Uwana anəŋà Yesu ada à awtày agòɗ: “Aganay Magadzaw aŋa Zəzagəla!” ");
INSERT INTO mfh_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Azlaməna matapla aŋha səla uwaga kà, tatsənà uwana apə̀h, ŋgaha tanəfà Yesu. ");
INSERT INTO mfh_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu agolà vok, anəŋà à lig, anəŋàŋ kà tanəfà masla, ŋgaha anavà atà: “Mana kayahaw ma?” Tagòɗal: “Rabbi, kadza à ahəŋ ma lala?” (Rabbi asal magoɗay: Məŋga) ");
INSERT INTO mfh_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Agòɗ à atà: “Sàw à waŋ, kadà­nəŋawwaŋ!” Ŋgaha tahàd, tanəŋà slaka madz à ahəŋ aŋha. (Mok uwaga kà sa ufaɗ aŋa mokokhu) Tadəvà mavakay uwatà à gay atà nna. ");
INSERT INTO mfh_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tekula la tataka aŋa azladza uwana la abà tatsənà sayda aŋa Yuhana, anəfà Yesu, masla la uwana Andəre, deda aŋa Səmon Piyer. ");
INSERT INTO mfh_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Teraŋa dadàŋ, Andəre agagàm la deda aŋha Səmon, agòɗal: “Kay, mədanəŋ Kristu, bokuba magoɗay: dza uwana Zəzagəla afàl dzakwa à gəl!” ");
INSERT INTO mfh_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Adàla Səmon à slaka Yesu. Yesu anərə̀z masla, agòɗal: “Kak la uwana, kak Səmon kona aŋa Yuhana, la huma la gay sləm aŋak adàgay Kayfas.” (Uwana asal magoɗay kà dzəgla) ");
INSERT INTO mfh_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","La bebəŋ gà, asà à Yesu kà mad à kutso Galili ŋgaha tagagàm la Filip, agòɗal: “Nəfà à gi!” ");
INSERT INTO mfh_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip kà zil Be­tsayda, gudəŋ aŋatà tekula la Andəre la Piyer. ");
INSERT INTO mfh_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip tatagàm la Nata­nayel, ŋgaha agòɗal: “Mədanəŋ dza uwana Musa apə̀h lakəl aŋha la wakità mapəhay la abà, baməraka azlaməna mapəh à atà gay à ahàl kà mapàh à azladza babay kà, tapəh lakəl aŋha, sləm aŋha kà, Yesu kona aŋa Yusufu uwana la gudəŋ Nazaret.” ");
INSERT INTO mfh_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nata­nayel agòɗal: “Dziri kà tatak delga aguwa à waŋ la Nazaret ay?” Filip agòɗal: “Sà à waŋ, kadà­nəŋəŋ!” ");
INSERT INTO mfh_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Mok uwana Yesu anəŋà Nata­nayel ada à awtày à slaka aŋha kà, apə̀h lakəl aŋha: “Aganay zil Isərayel deŋ­deŋga, mawi­siga la ahəŋ la masla la abà aw.” ");
INSERT INTO mfh_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nata­nayel anavàl: “Kakay kasəl gi ma?” Yesu agòɗal: “Gənəŋà ka à mok uwana kak la tsəh gudəv, à mok uwana Filip aləg mazala ka.” ");
INSERT INTO mfh_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kiya uwaga Nata­nayel agòɗal: “Rabbi, kak la uwana kak Kona aŋa Zəzagəla, kak Sufəl aŋa azla Isərayel!” ");
INSERT INTO mfh_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu awulà ala: “Kadiŋal gəl à vok kà, kà uwana gənəŋà ka la tsəh gudəv, gəgòɗ à ka takay? Kadànəŋ azla­tatak uwana tadàɗuw uwanay gesina.” ");
INSERT INTO mfh_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu agòɗal aya: “La dziriga gəpəh à akul, kadànəŋaw zagəla mapəzl à ama ala gà. Tsaɗ tsatsaɗ, azla­ma­lika aŋa Zəzagəla tadàda à afik, ŋgaha tatsa à ahəŋ à gəl aŋa Kona aŋa dza.” ");
INSERT INTO mfh_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Uwana mahənay səla adada à lig kà mamakərga, kà mazəɓ vok apakà vok la Kana la kutso aŋa Galili. Iyà aŋa Yesu la abatà. ");
INSERT INTO mfh_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu atà la azlaməna matapla la slaka aŋha bay kà tazàla atà à mazəɓ vok uwaga à abà. ");
INSERT INTO mfh_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mok uwana iyaw matavəruk adadəv à gay. Iyà aŋa Yesu agòɗal: “Tatak masay la ahəŋ aya aw!” ");
INSERT INTO mfh_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ama Yesu awulà ala: “Mis, kak la uwana kapəh à gi uwana asa à gi maɗehəŋ takay? Kaslà gulo adaslay dadàŋ aw.” ");
INSERT INTO mfh_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ŋgaha iyà aŋha agòɗ à azlaməna sləray: “Ɗahàw tatak uwana adàpəh à akul gesina!” ");
INSERT INTO mfh_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","La abatà agà la ahəŋ yuŋ mukwà, uwana azla Yahu­diya tata­ɗani iyaw à abà kà maɗàhlaŋ sləray kà mapa­lahla azlaasik kà uwana uwaga kà bokuba mafəla fəla aŋatà, kà magay tsiɗaŋa. Kəla yuŋ tekula aɗàh tuguzl zlo, baŋaw mukwa. ");
INSERT INTO mfh_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu agòɗ à atà: “Hànàw iyaw à azlayuŋ uwanay à abà pawasl papa­wasl.” Tahànàŋ ala bokuba uwana apə̀h à atà. ");
INSERT INTO mfh_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kiya uwaga Yesu agòɗ à atà: “Taɗawni iyaw uwaga ŋuv, kadawla à məŋga aŋa madəvaday.” Tatə̀ɗànì, tadàlla. ");
INSERT INTO mfh_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Məŋga aŋa madəvaday atapàŋ, kà apàk iyaw matavəruk. Masla asə̀l slaka uwana aguwà à waŋ à abà aw. (Ama azlaməna matat iyaw kà, tasəl slaka uwana aguwà à waŋ la abà) Azàla masla mazəɓ mis, ");
INSERT INTO mfh_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ŋgaha agòɗal: “Azladza kà tatsə̀vkàh mavàhay kà iyaw matavəruk matsi­ɗayga dadàŋ, baŋa azlaməna mazalàh atà gesina tasay kà, la lig la ahəŋ kà pəra, tavàh uwana atsiɗ aw. Ama kak kà, kaɓə̀k matsi­ɗayga à ahəŋ dadàŋ.” ");
INSERT INTO mfh_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Uwaga la uwana nadzipo matera uwana Yesu aɗahàŋ la Kana la kutso Galili, apə̀hla mazləɓay aŋha ala, kà uwana à uwana azlaməna matapla la slaka aŋha tadìŋ gəl à masla à vok. ");
INSERT INTO mfh_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","La lig aŋa uwaga la ahəŋ, ahàd à gudəŋ Kaper­nahum la iyà aŋha, la azla­deda aŋha, la azlaməna matapla la slaka aŋha, tadzànì à ahəŋ la abatà. ");
INSERT INTO mfh_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Uwana madəvaday aŋa Paska aŋa azla Yahu­diya nekwa kà, Yesu ahàd à Uru­sa­lima. ");
INSERT INTO mfh_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Aɓə̀z azlaməna matsa­kalay à gəl, la məŋ gày Zəzagəla la aku. Tadàw sla ala, la azla­tuwaŋ, la azla­ha­ba­koku, aɓə̀z azlaməna maɓaɗla sili à gəl bay, tadzàh madzay la huma aŋa sili aŋatà, taɓàɗla. ");
INSERT INTO mfh_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Aɗahà kurpi aŋa zuwiɗ, akuɗə̀kàh atà à lag gesina la məŋ gày Zəzagəla la aku, la azla­tuwaŋ, la azlasla aŋatà, adakwà table aŋa azlaməna maɓaɗla sili à vəɗah anasà sili aŋatà ala. ");
INSERT INTO mfh_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ŋgaha agòɗ à azlaməna madaw azla­ha­ba­koku ala: “Hə̀làw atà ala la abanay! Kapakàw gày aŋa baba gulo ala kà gày matsa­kalay aw!” ");
INSERT INTO mfh_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Təh, awùl à azlaməna matapla la slaka aŋha gay uwana tatsetsèr à wakità Zəzagəla à abà à gəl: ˈMawoy gày aŋak gulo kà, bokuba akàl uwana abaɓəhgəla ləv la tsəh.ˈ ");
INSERT INTO mfh_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ama azla­ma­dza­haga aŋa azla Yahu­diya tanavàl: “Tsəhay nadzipo ma uwala kapəhanula kà anu aŋa masəlay kà kak la maslay kà maɗehəŋ kiya uwanay la?” ");
INSERT INTO mfh_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu agòɗ à atà: “Kàlàw məŋ gày Zəzagəla uwanay à ahəŋ, ŋgaha gədà­ula à afik la mahənay makər.” ");
INSERT INTO mfh_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Azla Yahu­diya tagòɗal: “Gày uwanay taŋàl kà taɗahà mavay dzik ufaɗ gəl aŋha mukwà, kà pəra masla kadà­wula à afik la mahənay makər kagoɗ, aah..?!” ");
INSERT INTO mfh_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ama məŋ gày Zəzagəla uwana Yesu apə̀h, kà lakəl aŋa vok aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Uwana Yesu adawula à uda la mamətsay kà, təh awùl à azlaməna matapla à gəl la slaka aŋha à gay uwaga, tadìŋ gəl uwana à vok matse­tse­rayga, ŋgaha la gay uwana Yesu apə̀h à atà gesina. ");
INSERT INTO mfh_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mok uwana Yesu la Uru­sa­lima, la kaslà aŋa madəvaday aŋa Paska kà, azladza aŋuvaw tadìŋal gəl à vok, kà azla­na­dzipo uwana aɗa­hàtàŋ. ");
INSERT INTO mfh_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ama Yesu afà à atà gəl aw, kà uwana asə̀l madzugway aŋatà lela. ");
INSERT INTO mfh_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kà uwana masla kà anəkuɗà dza aŋa mapəhalla madzugway aw, kà uwana masla la gəl aŋha asə̀l uwana la ləv aŋatà la tsəh. ");
INSERT INTO mfh_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Dza anik la ahəŋ sləm aŋha Niko­demus, agà tekula aŋa azla­ma­siga aŋa azla Yahu­diya, masla kà zil Farisəya. ");
INSERT INTO mfh_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","La vəɗ la abà vərdi anik asà à waŋ à slaka Yesu la magoɗal: “Rabbi, məsəl kà Zəzagəla aslə̀l ka à waŋ kà matapanula, kà uwana dza la ahəŋ aɗəhəŋ tsəhay nadzipo uwaga kaɗəhəŋ aw, tsa baŋa Zəzagəla la masla aw aw.” ");
INSERT INTO mfh_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu agòɗal: “Haɗay, gəgoɗ à ka la dziriga: Dza aslala vok manəŋ makoray Zəzagəla aw, say baŋa adayyi vok mawga dàŋ.” ");
INSERT INTO mfh_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Niko­demus anavàl: “Kakay dza adagay magol gà, kà ayyi vok mawga aya ma? Aslala vok aŋa maul à huɗ aŋa iyà aŋha kà mayyay aya ay?” ");
INSERT INTO mfh_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu agòɗal: “La dziriga gəpəh à ka: Dza aslala vok aŋa mad à makoray Zəzagəla aw, say baŋa adayyi vok, la iyaw ŋgaha la Masasəɗok. ");
INSERT INTO mfh_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Uwana tayyà la sləɓ vok, uwaga sləɓ vok; uwana tayyà la Masasəɗok, uwaga Masasəɗok. ");
INSERT INTO mfh_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ləv avàl à ka à gay kà, kà uwaga gəpə̀h à ka aw: ‘Azlawla kà vok, say akul gesina kayyaw vok mawga.’ ");
INSERT INTO mfh_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Afaɗ aɗəɗay bokuba uwana asal; katsəna maɗəɗay aŋha, ama kasəl slaka uwana asà à waŋ la abà aw, kasəl slaka uwana ada à abà aw. Kiya uwaga à uwana apaka vok la azladza uwana tayyà vok la Masasəɗok.” ");
INSERT INTO mfh_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kiya uwaga Niko­demus agòɗal: “Kakay uwaga apaka vok ma?” ");
INSERT INTO mfh_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu agòɗal: “Tsa kak masla matapla à azla Isərayel la abà, kà pəra masla kasəl uwaga aw uwà? ");
INSERT INTO mfh_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Gəpəh à ka la dziriga: Məpəhay lakəl aŋa tatak uwana məsəl, ŋgaha lakəl aŋa tatak uwana mənəŋàŋ. Ama asa à akul makəs sayda gami aw. ");
INSERT INTO mfh_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tsa kadiŋaw gəl à gay aŋa azla­tatak uwana apaka vok la vəɗah aw ma, ŋgaha ma, kakay zlà ma kadàkəsaw kaslawwal à vok aŋa madiŋal gəl à vok à baŋa gəpəh à akul gay aŋa azla­tatak la zagəla ma? ");
INSERT INTO mfh_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Dza la ahəŋ adada à zagəla aw, tsa baŋa Kona aŋa dza uwana asà à ahəŋ la afik aw aw.” ");
INSERT INTO mfh_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Kiya uwana uwarà Musa adzilà bebi aŋa adà à zagəla la ahàf la gay la fəta la abà, kiya uwaga tadà­dzilla Kona aŋa dza à zagəla suwaŋ. ");
INSERT INTO mfh_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ŋgaha kəla uwa­be­yuwi uwana adiŋ gəl à masla à vok aɓəz sifa adəv à gay aw. ");
INSERT INTO mfh_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kà uwana Zəzagəla awoya gudəŋ à vok kà kaykay, à uwana avà Kona aŋha tekula gà uwaga, kà dèwdèw dza uwana tadiŋal gəl à vok kà, tazila aw, ama kà, tadàɓəz sifa adəv gay aw. ");
INSERT INTO mfh_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Zəzagəla aslə̀l Kona aŋha à waŋ kà, kà seriya à gudəŋ à vok à gəl aw, ama kà gudəŋ à vok aŋa maɓəz maɓəlay la masla.” ");
INSERT INTO mfh_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Dza uwana adiŋ gəl à Kona à vok, seriya adàkəsay aw, ama dza uwana adiŋal gəl à vok aw kà, seriya adakəsay, kà uwana adiŋ gəl à Kona tekula gà aŋa Zəzagəla à vok aw. ");
INSERT INTO mfh_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Aganay slaka uwana seriya aguwaŋ la abà: Uɗaka asà à waŋ à gudəŋ à vok, ama azladza tahaya mələs kà uɗaka, kà uwana maɗehəŋ aŋatà kà delgaw. ");
INSERT INTO mfh_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Azladza gesina taɗàh mawi­siga kà, tapəsew dziriga aŋa uɗaka, ŋgaha tatsa à waŋ à uɗaka à abà aw, kà uwana asa à atà kà sləray mawi­siga uwaga aŋa mapəhla vok ala, la uɗaka la abà aw. ");
INSERT INTO mfh_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ama dza uwana akəs dziriga kà, aday kà la uɗaka la abà, kà azladza gesina aŋa manəŋəŋ la dazu­waya, kà akəs gay aŋa Zəzagəla la masləkaway.” ");
INSERT INTO mfh_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","La lig aŋa uwaga la ahəŋ Yesu atsìzlla ala, ahàd à kutso aŋa Yahu­diya à abà la azlaməna matapla la slaka aŋha. Tasà­fànì la abatà atà nna, taɗa­hàhà batem. ");
INSERT INTO mfh_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","La kaslà uwatà kà Yuhana aɗahàhà batem à azladza la Aynon, uwana nekwa la Salim, kà uwana iyaw la ahəŋ la abatà məŋga. Azladza tasàhà à waŋ à slaka aŋha, ŋgaha aɗahà à atà batem, suwaŋ. ");
INSERT INTO mfh_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(La kaslà uwatà kà, Yuhana kà tadùw à daŋay dadàŋ aw) ");
INSERT INTO mfh_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kiya uwaga azlaanik la tataka azlaməna matapla aŋa Yuhana la abà tadzəkà mabay vok gay la zil Yahu­diya anik, lakəl aŋa tsəhay mapal vok aŋatà aŋa magay tsiɗaŋa. ");
INSERT INTO mfh_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tahàd à slaka Yuhana ŋgaha tagòɗal: “Rabbi, kadzugway lakəl aŋa dza uwana kagaw akul səla la gay dərəv uda aŋa mukwà Urdun, uwana kaz anu sayda lakəl aŋha takay? Lagwa kà, masla bay kà, aɗàh batem à azladza, azladza takə̀l à slaka aŋha gesina!” ");
INSERT INTO mfh_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yuhana agòɗ à atà: “Dza la ahəŋ aslala vok aɓəz tatak aw, say baŋa Zəzagəla adavàl. ");
INSERT INTO mfh_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Akul la gəl aŋkul kà, akul azlaməna sayda gulo, gəgòɗ kà: Gi Kristu aw. Ama gi à masləl gi à waŋ gà, la huma aŋha pəra. ");
INSERT INTO mfh_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Masla mazəɓ mis kà masla la uwana zil mis. Ama sləgud aŋa zil misga, ada­tsizlla à ahəŋ la makəla aŋha, atsəɓal sləm. Baŋa adatsən kuda aŋa zil mis, arabay. Kiya uwaga à marabay gulo babay suwaŋ zlà. Lagwa kà, marabay gulo adahənla pawasla. ");
INSERT INTO mfh_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kà aŋa uwaga kà, say masla agay mazləɓayga, ŋgaha mazləɓay gulo ata­tuway.” ");
INSERT INTO mfh_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Dza uwana asa à ahəŋ la zagəla, masla lakəl aŋa azla­tatak gesina, ama dza uwana la vəɗah masla dza aŋa vəɗah, apəhay kà gay aŋa vəɗah bay. Uwana asa à ahəŋ la zagəla aga lakəl aŋa tatak gesina. ");
INSERT INTO mfh_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Uwana anəŋàŋ, uwana atsənàŋ la uwana apəhay, ama dza akəs mapəhay aŋha aw. ");
INSERT INTO mfh_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kəla uwa­be­yuwi uwana akəs mapəhay aŋha, agəɗaŋ à afik kà Zəzagəla kà dziriga. ");
INSERT INTO mfh_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Dza uwana Zəzagəla aslə̀lla à waŋ apəhay gay aŋa Zəzagəla, kà uwana ahənə̀ŋ ala la Masasəɗok aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baba awoya Kona aŋha, ŋgaha avàl ndzəɗa lakəl aŋa tatak gesina. ");
INSERT INTO mfh_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Dza uwana adiŋ gəl à Kona à vok, aɓəz sifa adəv à gay aw, ama dza uwana akweska Kona, adàɓəz sifa uwaga tetuwa à aw, ama mapak ləv aŋa Zəzagəla adza à ahəŋ lakəl aŋha.” ");
INSERT INTO mfh_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Azla Farisəya tatsənàŋ kà Yesu aɗàh batem, ŋgaha aɓə̀z azlaməna matapla ɗaɗuwa à gay aŋa Yuhana. ");
INSERT INTO mfh_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ama Yesu la gəl aŋha kà aɗahà batem à dza amiyaka tekula aw, say azlaməna matapla la slaka aŋha pəra) ");
INSERT INTO mfh_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Mok uwana Yesu atsənà uwaga tapəhay kà, asàk à kutso Yahu­diya à ahəŋ, awùl à Galili. ");
INSERT INTO mfh_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kà awùl à Galili kà, say aguwà à uda la kutso Sama­riya. ");
INSERT INTO mfh_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","La mas à uda la Sama­riya abə̀z à gudəŋ uwana à abà sləm aŋha Səser, uwana nekwa la guf uwana Yakuba avà à kona aŋha Yusufu. ");
INSERT INTO mfh_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","La abatà suwa aŋa Yakuba la ahəŋ, Yesu adày vok la mau­gu­zahay aŋha la abà, adzà madzay la gay suwa. Mok uwaga azlagay tataka afats. ");
INSERT INTO mfh_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mis Sama­riya asà à waŋ kà matəɗ iyaw, Yesu agòɗal: “Mis tə̀ɗ à gi iyaw, gəsay!” ");
INSERT INTO mfh_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(La kaslà uwatà kà, azlaməna matapla aŋha tadà à huɗ gudəŋ kà mayàh tatak may) ");
INSERT INTO mfh_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mis Sama­riya agòɗ à Yesu: “Kak, kak zil Yahu­diya! Kakay kaslala vok kà manav à gi iyaw masay à gi uwana gi mis Sama­riya ma?” (Apə̀h kiya uwaga kà, kà uwana azla Yahu­diya tatsənà vok la azla Sama­riya aw ma) ");
INSERT INTO mfh_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu awulà ala: “Agayŋa kasəl tatak uwana Zəzagəla avày kà, ŋgaha naka kasəl dza uwana anava à ka iyaw masay kà, naka kak la uwana kanaval iyaw sifa, ŋgaha naka avà kà uwaga.” ");
INSERT INTO mfh_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mis agòɗal: “Məŋga, tsa tatak matəɗla iyaw aga la kak là ahàl aw, suwa bay kà kərkər ma, kakay kaɓəz iyaw sifa ma? ");
INSERT INTO mfh_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Baba gami madzi­dziga Yakuba avà à anu suwa uwanay; bay kà asàh la azlabəza aŋha la azla­ləmana aŋha babay. Kadzugw ma, ‘Gəɗuwa Yakuba’, kagoɗ, takay?” ");
INSERT INTO mfh_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu awulà ala: “Kəla uwa­be­yuwi uwana asà iyaw aŋa suwa uwanay, nəlay adàkəsay aya, ");
INSERT INTO mfh_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ama dza uwana adàsay iyaw uwana gədà­təɗallaŋ kà, nəlay adàkəsay aya aw. Kà uwana iyaw uwana gədà­təɗallaŋ kà, adà­pakay la huɗ aŋha mukwà aŋa iyaw, uwana akəlay aŋa sifa adəv à gay aw.” ");
INSERT INTO mfh_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mis agòɗal: “Məŋga, təɗəgəŋ iyaw uwaga, kà nəlay aŋa makəs gi aya aw, ŋgaha kà gi aŋa manəkuɗa aŋa mas à waŋ aŋa matəɗ iyaw la abanay aya aw.” ");
INSERT INTO mfh_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu agòɗal: “Hàd, kazala zil aŋak, kasawwaŋ à abanay.” ");
INSERT INTO mfh_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mis agòɗal: “Zil gulo la ahəŋ aw.” Yesu agòɗal: “Dziriga à uwana kapə̀h: ‘Zil gulo la ahəŋ aw’, kagòɗ. ");
INSERT INTO mfh_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Haɗay, kadàh à zil zlo, ama uwana kak la mtəga aŋha lagwa kà, zil aŋak aw. Kapə̀h dziriga.” ");
INSERT INTO mfh_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kiya uwaga mis agòɗal: “Məŋga, gəsəl kà kak masla mapəhal gay à ahàl aŋa Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Azla­baba gami madzi­dziga tadavàh kuɗa à Zəzagəla la gudəŋ uwanay la afik, ama akul azla Yahu­diya kà, kagoɗaw kà: ‘Slaka uwana dza adəv kuɗa à Zəzagəla, kà la Uru­sa­lima’, kagoɗaw.” ");
INSERT INTO mfh_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu agòɗal: “Mis, dìŋ à gi gəl à vok, kaslà adàsa à waŋ à uwana kadàdəvaw kuɗa à Baba Zəzagəla la gudəŋ uwanay la afik aw, amiyaka la Uru­sa­lima aw. ");
INSERT INTO mfh_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Akul azla Sama­riya kasəlaw tatak uwana kadəvawwal kuɗa aw; ama anu, anu azla Yahu­diya kà, məsəl tatak uwana mədəval kuɗa, kà uwana maɓəlay kà, asa à uda kà la azla Yahu­diya la abà. ");
INSERT INTO mfh_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ama kaslà adàsa à waŋ, lagwa kà adasa à waŋ lagwa, uwana azlaməna madəv kuɗa tadàdəv kuɗa la Masasəɗok ŋgaha la dziriga, azladza uwana tadəv kuɗa kiya uwaga à ahəŋ, à uwana Baba ayahay. ");
INSERT INTO mfh_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Zəzagəla kà Masasəɗok gà, azlauwla kà vok kà, azla­uwana tadəval kuɗa kà la Masasəɗok ŋgaha la dziriga.” ");
INSERT INTO mfh_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mis agòɗal: “Məsəl kà Mesi atsa à waŋ, uwana asal magoɗay kà Kristu. A baŋa adàsa à waŋ, adàpəhanula tatak gesina.” ");
INSERT INTO mfh_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu agòɗal: “Gi gà la uwaga gəɓa­ɗa­kama lagwa.” ");
INSERT INTO mfh_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","La kaslà uwatà, azlaməna matapla la slaka aŋha tawùl à waŋ, ŋgaha ləv avàl à atà à gay kà uwana tavàts gay la mis. Ama dza aslàla vok aŋa manaval aw: “Mana asal mi? Baŋaw, kà mana kaɓaɗawma akul səla mi?”, la ahəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kiya uwaga mis asàk à tuguzl aŋha à ahəŋ, ahàd à huɗ gudəŋ à abà, la abatà agòɗ à azladza: ");
INSERT INTO mfh_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Sàw à waŋ, kà nə̀ŋàwwàŋ dza uwana adapəh à gi tatak uwana gəɗa­hàhàŋ gesina. Zlahaw kà, masla Kristu aw ay?” ");
INSERT INTO mfh_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Azladza tasà à uda la gudəŋ la abà, tahàd à slaka Yesu. ");
INSERT INTO mfh_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","La kaslà uwatà azlaməna matapla tadə̀v kuɗa à Yesu kà mazuw tatak may. “Rabbi, kamkam zùw tatak may!”, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ama agòɗ à atà: “Gi la tatak may uwana kasəlaw aw.” ");
INSERT INTO mfh_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","La abatà azlaməna matapla tanàv vok kà atà kà atà: “Dza anik ada­salla tatak may à waŋ kəlay?” ");
INSERT INTO mfh_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu agòɗ à atà: “Tatak may gulo kà, makəs gay aŋa dza uwana aslə̀l gi à waŋ, ŋgaha maɗàh sləray uwana afà à gi à ahàl kà maɗehəŋ. ");
INSERT INTO mfh_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Akul kà, kagoɗaw kà, à lig təla ufaɗ kà matsəɗ tatak, ama gi kà gəgoɗ à akul kà, nərə̀zàw guf lela tsi, hi adahənay, nekwa kà matsəɗay. ");
INSERT INTO mfh_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Masla matsəɗ tatak aɓəz masik aŋha, ŋgaha ahama hi à ahəŋ kà aŋa sifa adəv à gay aw, ŋgaha kà masla masləkay atà la masla matsəɗay tarabay la slaka gà. ");
INSERT INTO mfh_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ˈDza anik asləkay, dza anik atsəɗayˈ, uwana gay la gay la abà agoɗ kà, bà dziriga. ");
INSERT INTO mfh_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Gəsləl akul kà matsəɗay la guf uwana la abà kaɗahaw sləray la abà aw; azladza anik taɗahà sləray gà uwana, ŋgaha kà kaɓəzaw à gəl kà sləray aŋatà.” ");
INSERT INTO mfh_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Azla Sama­riya aŋuvaw tadìŋal gəl à vok la gudəŋ uwatà kà gay uwana mis apə̀h à atà: “Apə̀h à gi tatak gesina uwana gəɗa­hàhàŋ”, mis agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mok uwana tadasa à waŋ à slaka Yesu, tadə̀val kuɗa kà madzin à ahəŋ atà nna; kiya uwaga Yesu aɗahà mavakay səla atà nna. ");
INSERT INTO mfh_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Gotənaŋ aŋuvaw tadìŋ gəl à Yesu à vok, kà gay aŋha uwana apə̀h à atà. ");
INSERT INTO mfh_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","La abatà tagòɗ à mis: “Lagwa kà, mədiŋal gəl à vok kà uwana kapə̀h à anu pəra aw, ama kà uwana anu la gəl gami məda­tsənəŋ uwana apə̀h, la dziriga, məsəl kà masla la uwana masla maɓəl gudəŋ à vok.” ");
INSERT INTO mfh_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mok uwana Yesu adadza à ahəŋ la abatà mavakay səla, asàk atà à ahəŋ, ahàd à kutso Galili. ");
INSERT INTO mfh_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu la gəl aŋha agòɗ: “Masla mapəhal gay à ahàl aŋa Zəzagəla maɓəz mazləɓay la gudəŋ aŋha la abà aw.” ");
INSERT INTO mfh_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ama tekeɗik mok uwana adabəzay à gudəŋ aŋha, azladza takə̀s la ahàl səla, kà uwana mok uwana tahàd à madəvaday à Uru­sa­lima, tanəŋàŋ, uwana aɗahàŋ la madəvaday uwatà la abà gesina. ");
INSERT INTO mfh_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","La kaslà uwatà, masla awùl à Kana, la slaka uwana apakà iyaw ala kà iyaw matavəruk. Kana uwaga agà kà la Galili la abà. Masla sləray aŋa gumna la ahəŋ la abatà, bəzi aŋha la ɗuvats la Kaper­nahum. ");
INSERT INTO mfh_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mok uwana masla sləray uwaga atsənàŋ kà Yesu adasa à waŋ à Yahu­diya la Galili kà, masla atsìzlla ala, ahàd à slaka Yesu, adə̀val kuɗa kà manəf masla à Kaper­nahum, kà masla aŋa mawur bəzi aŋha ala. Kà uwana bəzi agà kà la ləv la ləv pəra. ");
INSERT INTO mfh_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu agòɗal: “Akul gesina, kadiŋaw gi gəl à vok aw, say baŋa kadànəŋaw azla­na­dzipo la uwana kadà­di­ŋawwal gəl à vok.” ");
INSERT INTO mfh_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Masla sləray agòɗal: “Məŋga, sà à waŋ à mtəga gulo dadàŋ, kà mamətsay aŋa bəzi gulo.” ");
INSERT INTO mfh_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu agòɗal: “Hàd à mtəga aŋak, bəzi aŋak aga la ahəŋ, adza à ahəŋ la sifa, awkà adàmətsay aw.” Zil uwaga adìŋ gəl à uwaga à vok Yesu apə̀hal. ");
INSERT INTO mfh_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Uwana agà la tetəvi la ama, kà mawul à mtəga, tagagàm la azlaməna sləray aŋha, maslà tagòɗal: “Bəzi aŋak adaɓəlay!” ");
INSERT INTO mfh_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Masla anàv à atà la məl, ma uwala aɓəzà à ŋuləm la. Tagòɗal: “Lakuhu la sa tekula, à uwana akàl vok asàlla vok ala.” ");
INSERT INTO mfh_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kiya uwaga awùl à baba à gəl kà kalkal la kaslà uwana Yesu apə̀hal: “Bəzi aŋak adaɓəlay”, agòɗal. Kà uwaga à uwana masla la azlaməna huɗ gay aŋha gesina tadìŋ gəl à Yesu à vok. ");
INSERT INTO mfh_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Uwaga kà masəla aŋa nadzipo uwana Yesu aɗahàŋ dagay la mas à uda aŋha la Yahu­diya, la kutso Galili. ");
INSERT INTO mfh_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Uwana uwaga adada à lig, azla Yahu­diya tadzəkà mahab madəvaday, Yesu bay ahàd à Uru­sa­lima. ");
INSERT INTO mfh_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","La gudəŋ uwatà la abà nekwa la gamagày aŋa azla­tuwaŋ, agà la ahəŋ iyaw matsakayga uwana sləm aŋha la gay ibəra­nəŋkowen: Be­tsa­ta. Iyaw uwatà tanuɗa ala à gay à abà la azla­tsa­tsa­gla zlo. ");
INSERT INTO mfh_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","La tsəh aŋa tsa­tsa­gala uwatà, azlaməna ɗuvats aŋuvaw tahà­nàhal à tsəh: azla­gu­ləf, azla­deri, azla­magul à afik gà. ((Takudàh maɓəlak vok aŋa iyaw uwana aɓəlà­kàhà à vok. ");
INSERT INTO mfh_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kwà à kwà malika aŋa Zəzagəla asàh à ahəŋ aŋa maɓəlakàh iyaw uwaga. Masla ɗuvats uwana atsa à vok à iyaw uwaga à abà aɓəlakay, awur ala la ɗuvats aŋha la abà, baməraka ɗuvats tsəhay gà uwala beyli gesina.)) ");
INSERT INTO mfh_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Masla ɗuvats anik la ahəŋ la abatà, adaɗah mavay dzik makər gəl aŋha mtəgis. ");
INSERT INTO mfh_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Uwana Yesu anəŋà dza uwatà la slaka mahən à ahəŋ, asə̀l kà ada­safay la ɗuvats aŋha uwaga la abà, Yesu agòɗal: “Asa à ka mawur ala ay?” ");
INSERT INTO mfh_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Masla ɗuvats awulà ala, anə̀ŋal à adi agòɗal: “Məŋga, dza gulo la ahəŋ aŋa madla gi à abà la kaslà uwana iyaw aɓəlak vok aw. Baŋa gəwaɗ vok à uda, gəda à abà zlà, gədà­goɗay kà dza anik atsà à vok à abà kà gi.” ");
INSERT INTO mfh_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu agòɗal: “Sà à afik, zə̀ɓ butsi aŋak, ŋgaha dà aŋak!” ");
INSERT INTO mfh_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hadzak, asà à afik awùr ala, akə̀l butsi aŋha à abà, adzəkà maday. Ama mavakay uwatà kà mavakay maduw ləv tekeɗik. ");
INSERT INTO mfh_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Uwana azla­ma­siga aŋa azla Yahu­diya tanəŋàŋ, tagòɗ à dza uwana awùr ala: “Lakana kà vuɗ maduw ləv, wakità mapəhay gami avà tetəvi kà mazəɓ butsi aŋak aw!” ");
INSERT INTO mfh_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Agòɗ à atà: “Dza uwana awurà gi ala agòɗ à gi: ‘Kə̀l butsi aŋak à abà, ŋgaha dà aŋak’, agòɗ à gi.” ");
INSERT INTO mfh_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tanavàl la gay ala: “Uwa à dza uwana ‘Zə̀ɓ butsi aŋak, dà aŋak’, agòɗ à ka uwa?” ");
INSERT INTO mfh_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ama dza uwana awurà ala kà, asə̀l dza uwana awuràŋ ala aw. Yesu adadiy aŋha la abatà, kà uwana maham à ahəŋ dza aŋuvaw la abatà. ");
INSERT INTO mfh_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Zwek, la huma la gay, Yesu agagàm à məŋ gày Zəzagəla à agu atà səla, ŋgaha agòɗal: “Tsənàŋ lagwa kà kawùr ala. Kaɗahàŋ tsakana aya kà tatak mawi­siga uwana aɗuwa uwanay aŋa maɓəza kà aya aw!” ");
INSERT INTO mfh_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dza uwaga adà aŋha, ŋgaha agòɗ à azla Yahu­diya kà Yesu la uwana awuràŋla. ");
INSERT INTO mfh_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kà uwaga à uwana azla Yahu­diya tadzəkà matərəɓ Yesu, à kà uwana awurà dza ala la vuɗ maduw ləv. ");
INSERT INTO mfh_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ama Yesu agòɗ à atà: “Baba gulo aɗàh sləray koksi­koksi, gi bay kà gəɗehəŋ kiya uwaga suwaŋ.” ");
INSERT INTO mfh_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kà gay uwaga à uwana, azla Yahu­diya tayàh kaykay kà makəɗay, kà uwana agòɗ kà Zəzagəla kà Baba aŋha, ŋgaha aga­gazləla gəl aŋha la Zəzagəla. Awkà kà, uwana apəsèw mavakay maduw ləv pəra aw. ");
INSERT INTO mfh_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kà uwaga, Yesu agòɗ à atà: “Gəgoɗ à akul la dziriga, Kona aslala vok maɗàh tatak la gəl aŋha aw, say anəŋəŋ kà say uwana Baba aɗehəŋ. Uwana Baba aɗehəŋ gesina, uwaga la uwana Kona aɗehəŋ babay. ");
INSERT INTO mfh_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kà uwana Baba awoya Kona, apəhalla uwana aɗehəŋ gesina. Adàpəhalla à azla­tatak uwana aɗuwa uwanay aya, kà Kona aŋa maɗàh uwaga. Ŋgaha uwaga adaval akul ala ləv à gay. ");
INSERT INTO mfh_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bokuba uwana Baba awùlla azla­ma­zim­nekiɗ à uda la mamətsay kà mav à atà sifa kà, kiya uwaga babay Kona av sifa à uwa­be­yuwi uwana awoyaŋ gesina. ");
INSERT INTO mfh_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Baba kà aɗàh seriya à dza à gəl aw, ama avà maslay maɗàh seriya uwaga à ahàl aŋa Kona aŋha gesina, ");
INSERT INTO mfh_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kà azladza gesina aŋa masləkaway Kona, bokuba uwana tasləkaw Baba. Dza uwana asləkaw Kona aw, masla asləkaw Baba uwana aslə̀l à waŋ babay aw.” ");
INSERT INTO mfh_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Gəpəh à akul la dziriga, dza uwana atsəɓ sləm à gay gulo, ŋgaha adiŋ gəl à dza uwana à vok aslə̀l gi à waŋ kà, masla la sifa adəv à gay aw. Seriya adàkəsay aw, aguwa à uda la mamətsay, adàɓəz sifa adəv à gay aw. ");
INSERT INTO mfh_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Haɗay gəgoɗ à akul la dziriga, kaslà atsa à waŋ, ŋgaha kaslà uwaga aga la tataka gami la abà lagwa, uwana azla­ma­zim­nekiɗ tadà­tse­nəŋ kuda aŋa Kona aŋa Zəzagəla, ŋgaha kà azla­uwana tadàkəɗeɗal à ahəŋ tadàdz à ahəŋ la sifa. ");
INSERT INTO mfh_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Iyay, bokuba uwana Baba la maslay kà mavày sifa adəv à gay aw à azladza, kiya uwaga bay avà maslay uwaga à Kona aŋha à ahàl, kà masla aŋa mav sifa à azladza. ");
INSERT INTO mfh_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Avà maslay à Kona aŋha kà maɗàh seriya, kà uwana masla Kona aŋa Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ləv aval à akul à gay kà uwaga aw, kà uwana kaslà atsa à waŋ, à uwana azla­ma­zim­nekiɗ uwana la zəvay la aku gesina tadà­tsən kuda aŋha, ");
INSERT INTO mfh_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ŋgaha tadàsa à uda la zəvay aŋatà la aku. Azladza uwana taɗahàŋ delga tadàwula à uda kà maɓəzal masik aŋatà uwana sifa adəv à gay aw, ama azla­uwana taɗahàŋ mawi­siga tadàwula à uda kà maɗa­hàtaŋ seriya à gəl.” ");
INSERT INTO mfh_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Gi la gəl gulo kà gəslala vok kà maɗàh tatak aw, gəɗàh seriya kà bokuba uwana ‘Ɗahàŋ’, Baba agòɗ à gi, seriya gulo kà dziriga, kà uwana gəyàh mawoyəŋ aŋa gəl gulo aw. Ama uwana asa à dza uwana aslə̀l gi à waŋ pəra. ");
INSERT INTO mfh_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Baŋa gəz sayda aŋa gəl gulo kà, sayda gulo kà agay dziriga aw. ");
INSERT INTO mfh_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ama say dza anik la uwana az sayda lakəl gulo, gəsəl kà sayda uwana aziŋ lakəl gulo kà dziriga. ");
INSERT INTO mfh_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kasləlaw azlaməna matsəɓ sləm à slaka Yuhana, sayda aŋha uwana azaŋ kà dziriga. ");
INSERT INTO mfh_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ama gi kà gənə­kuɗa aŋa sayda aŋa dza aw, gəula akul à gəl kà, kà akul aŋa maɓəz maɓəlay pəra. ");
INSERT INTO mfh_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yuhana kà agà kà bokuba fənəs mavatsiŋ à ahəŋ gà pəra, ŋgaha karabaw ŋuv la uɗaka aŋha la abà. ");
INSERT INTO mfh_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ama sayda gulo uwana gəziŋ kà, aɗuwà aŋa Yuhana uwana azàŋ, azlasləray uwana Baba gulo avà à gi kà mahənəŋla kà, taz sayda gulo. Ŋgaha babay kà apəhla ala kà Baba la uwana aslə̀l gi à waŋ. ");
INSERT INTO mfh_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Baba uwana aslə̀l gi à waŋ apəhay lakəl gulo aya. Akul kà kadàtsənaw kuda aŋha didi aw, ŋgaha kadànəŋaw huɗ adi aŋha babay aw. ");
INSERT INTO mfh_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Akul kafaw gay aŋha à ləv aŋkul à tsəh aw, kà uwana kadi­ŋawwal gəl à vok à dza uwana aslə̀l à waŋ aw. ");
INSERT INTO mfh_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kadzeŋaw wakità Zəzagəla la haŋkəli, kadzugwaw kà: ‘La abà la uwana mədàɓəz sifa adəv à gay aw’, kagoɗaw. Bà dziri haɗay gà, la wakità uwaga la abà la uwana sayda gulo. ");
INSERT INTO mfh_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ama asa à akul aŋa mas à slaka gulo aŋa maɓəz sifa dziriga aw.” ");
INSERT INTO mfh_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ama gi kà, gəyàh mazləɓ gi aŋa azladza aw. ");
INSERT INTO mfh_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ama akul kà, gəsəl kà, kawoyaw Zəzagəla la ləv aŋkul la tsəh aw. ");
INSERT INTO mfh_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Gəsà à ahəŋ kà la sləm aŋa Baba gulo, ama karabaw gi à huma aw. Ama baŋa dza anik atsa à waŋ la maslay aŋa aslasl gəl aŋha kà, kakəsaw. ");
INSERT INTO mfh_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Akul asa à akul mayàh mazləɓay aŋa azladza anik anik, ŋgaha kayahaw mazləɓay uwana asa à ahəŋ la slaka Zəzagəla dziriga aw. Ŋgaha ma kakay kadiŋaw gəl à vok ma? ");
INSERT INTO mfh_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ama kadzugwaw kà, gədàta akul kaf à gəl la slaka Baba gulo, kagoɗaw aw. Ama Musa la uwana adàta à akul kaf à gəl, à masla uwana kafaw manəwəŋ aŋkul à masla à afik. ");
INSERT INTO mfh_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Agayŋa ndzer, kadiŋaw gəl à Musa à vok kà, naka kadiŋaw gi gəl à vok babay, kà uwana Musa atsetsèr kà lakəl gulo. ");
INSERT INTO mfh_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ama tsa kadiŋaw gəl à uwana à vok atsetsèr aw ma, kakay kadiŋaw gəl à gay gulo à vok zlà ma?” ");
INSERT INTO mfh_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","La lig aŋa uwaga la ahəŋ, Yesu ahàd à gay dərəv à uda anik aŋa dərəv Galili, uwana tazalalla bay dərəv Tibe­riya. ");
INSERT INTO mfh_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Maham à ahəŋ dza aŋuvaw tanəfà, kà uwana tanaŋà azla­na­dzipo uwana aɗa­hàhàŋ la mawar azladza ala. ");
INSERT INTO mfh_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu ahàd à dadəgwal à afik la abatà, tadzà madzay la azlaməna matapla la slaka aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Paska, madəvaday aŋa azla Yahu­diya, nekwa. ");
INSERT INTO mfh_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Uwana Yesu anəŋà maham à ahəŋ dza aŋuvaw tatsà à waŋ à slaka aŋha, Yesu atàp à Filip agòɗal: “Lala mədàɓəz tatak may kà masukway, kà mav à maham à ahəŋ dza uwanay aŋa mazuway zlà?” ");
INSERT INTO mfh_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Apə̀h uwaga kà, kà matap Filip. Awkà, masla kà asə̀l tatak uwana naka aɗehəŋ. ");
INSERT INTO mfh_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip agòɗal: “Amiyaka məsukw kaf aŋa gursu dadərmokw səla bay kà, aslay kà kəla uwa­be­yuwi aŋatà aŋa maɓəzal ŋuv aw.” ");
INSERT INTO mfh_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tekula la tataka azlaməna matapla aŋha la abà Andəre, deda aŋa Səmon Piyer agòɗal: ");
INSERT INTO mfh_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Bəzi kohna anik la ahəŋ la abanay, kaf gay bərsew zlo la kilfi səla la ahàl, ama uwaga ma, mana akəs à vok aŋa maham à ahəŋ dza kiya uwanay ma?” ");
INSERT INTO mfh_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kiya uwaga Yesu agòɗ à atà: “Dzàw azladza madzay gesina, slaka uwatà kà delga kà madzàh madzay, kà uwana kəsaf la ahəŋ.” Ŋgaha atà tadzàhà madzay gesina aŋatà taslay zil dəbow zlo. ");
INSERT INTO mfh_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu ahə̀l kaf uwaga, “Kikay”, agòɗ à Zəzagəla, atsakà kaf ala, ŋgaha avàhà à azladza. Ahə̀l kilfi, aɗahàŋ kalkal kiya uwaga aya. Tazùw tsəràh à uwana aslàh à atà. ");
INSERT INTO mfh_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mok uwana tahànla gesina, Yesu agòɗ à azlaməna matapla la slaka aŋha: “Hamàw gay à mapətsèh pətsèhga uwaga à vok, atə̀ɗal ala amiyaka tekula aw.” ");
INSERT INTO mfh_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ŋgaha tahamà gay à mapətsèh pətsèhga uwana à vok atàm a atà à ahàl, tahənàŋ ala takosà kulo gəl aŋha səla. ");
INSERT INTO mfh_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Uwana azladza tanəŋàŋ nadzipo uwana Yesu aɗahàŋ, tagòɗ: “Kayyà, dza uwanay ndzer kà masla mapəhal gay à ahàl, uwana naka atsa à waŋ à gudəŋ à vok!” ");
INSERT INTO mfh_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Uwana Yesu asə̀l kà azladza tatsà à waŋ kà mafiya à sufəl à abà la ndzəɗa kà, kà uwaga à uwana adà aŋha à gudəŋ à afik kokuɗa gəl aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mok uwana mokokhu adasa à waŋ kà, azlaməna matapla la slaka Yesu tadà à ahəŋ à gay dərəv, ");
INSERT INTO mfh_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","tahàd à kəslah iyaw à afik, ŋgaha tadzəkà mad à uda la dərəv la abà, kà mabəziya à Kaper­nahum. La mok uwaga kà, vəɗ adasa à waŋ, Yesu alə̀g mabəz atà à tsəh dadàŋ. ");
INSERT INTO mfh_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Magol kular adzəkà à vok, iyaw dərəv adzəkà magaŋ­tsay la mavəlay lakəl. ");
INSERT INTO mfh_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Azlaməna matapla kà, taday azla­talka magur mahoyay pəlis səla la tenma baŋaw makər kà zla­zlaɗa aŋa afaɗ. Uwana tanə̀ŋ Yesu adà à awtày à slaka aŋatà lakəl dərəv la asik kà, guba akə̀s atà. ");
INSERT INTO mfh_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ama Yesu agòɗ à atà: “Guba akəs akul aw, gi ŋwà!” ");
INSERT INTO mfh_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tayàh mazəɓ à tsəh la kəslah iyaw la afik nəma, la katskats tanəŋà kà kəslah iyaw adà­dəɓani kutso uwana asà à atà mad à abà. ");
INSERT INTO mfh_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","La bebəŋ gà kà, maham à ahəŋ dza uwana tagə̀ɗ à gay dərəv à uda anik, awùl atà à gəl kà la mokokhu lakuhu kà, agà la ahəŋ pəra kà kəslah iyaw tekula, ŋgaha tasə̀l bay kà Yesu ahàd à kəslah iyaw à afik la azlaməna matapla la slaka aŋha aw. Ama azlaməna matapla aŋha tahàd kokuɗa gəl aŋatà pəra. ");
INSERT INTO mfh_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ama pəra kà, azlakəslah iyaw anik taguwà à waŋ la Tibe­riya, tasà à waŋ à slaka uwana Yesu avà kaf, à mok uwana kikay agòɗ à Zəzagəla kà aŋa uwaga. ");
INSERT INTO mfh_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Uwana maham à ahəŋ dza anəŋàŋ kà Yesu la abatà aw, azlaməna matapla la slaka aŋha bay kà atà la abatà aw, tadàh à azlakəslah iyaw uwaga à afik, tada à Kaper­nahum kà mayahay. ");
INSERT INTO mfh_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","La kiya uwaga taɓəzà Yesu à vok la gay dərəv à uda anik aŋa dərəv ŋgaha tagòɗal: “Rabbi, kasà à abanay mbà?” ");
INSERT INTO mfh_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu awulà à atà ala: “Haɗay, gəpəh à akul la dziriga, kayahaw gi kà, kà uwana kazùwàw kaf, kahà­nàwla, aslahà à akul, awkà kà azla­na­dzipo la azlasləray gulo uwana gəɗahàŋ aw. ");
INSERT INTO mfh_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kaɗahaw sləray kà aŋa tatak may uwana awìs ala aw. Ama ɗahàwàŋ kà aŋa tatak may uwana adza à ahəŋ, avà sifa adəv à gay aw. Tatak may uwaga kà, Kona aŋa dza la uwana adàvà à akul la maslay, uwana aɓə̀zal la slaka Baba Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ŋgaha tanavàl: “Mana məɗehəŋ kà maɗàh sləray uwana asa à Zəzagəla zlà ma?” ");
INSERT INTO mfh_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu awulà à atà ala: “Sləray uwana Zəzagəla akuday la slaka aŋkul kà, say madiŋ gəl à dza uwana à vok, Zəzagəla aslə̀l à waŋ.” ");
INSERT INTO mfh_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tagòɗal: “Nadzipo ma uwala kapəhanula kà anu aŋa madiŋ à ka gəl à vok la? Ŋgaha ma sləray ma uwala kaɗehəŋ la? ");
INSERT INTO mfh_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Azla­baba gami madzi­dziga tazùw manne à uwana asàhà à ahəŋ la zagəla la fəta la abà, bokuba uwana tatsetsèr à wakità Zəzagəla à abà. Masla avà à atà tatak may uwana asàh à ahəŋ la zagəla.” ");
INSERT INTO mfh_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu awulà à atà ala: “Haɗay la dziriga, gəpəh à akul, Musa la uwana avà à akul tatak may uwana asà à ahəŋ la zagəla aw. Ama Baba gulo la uwana avà à akul tatak may dziriga, uwana asà à ahəŋ la zagəla. ");
INSERT INTO mfh_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kà uwana tatak may uwana Zəzagəla avày kà, anik la ahəŋ aw, say masla uwana asà à ahəŋ la zagəla, (Uwaga kà Yesu) ŋgaha ava sifa à azladza gudəŋ à vok gesina.” ");
INSERT INTO mfh_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Kiya uwaga tagòɗal: “Kayyà Sufəl, và à anu tatak may uwaga koksi­koksi kəla zlà!” ");
INSERT INTO mfh_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu asà à atà ala à uda: “Gi la uwana gi tatak may aŋa sifa. Dza uwana atsa à waŋ à slaka gulo, adiŋ à gi gəl à vok kà, may adàkəs aya aw, nəlay adàkəs bay aw. ");
INSERT INTO mfh_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ama gəpəh à akul: Kanəŋaw gi, ama bà la uwaga gesina kà, kanəŋaw gi kadiŋaw gi gəl à vok aw. ");
INSERT INTO mfh_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mana beymi uwana Baba avà à gi, atsà à waŋ à slaka gulo, ŋgaha gədà­kweska dza uwana atsa à slaka gulo aw. ");
INSERT INTO mfh_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kà uwana gəsà à ahəŋ la zagəla kà, kà maɗehəŋ mawoyəŋ aŋa dza uwana aslə̀l gi à waŋ, awkà aŋa gəl gulo aw. ");
INSERT INTO mfh_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Aganay uwana asa à dza uwana aslə̀l gi à waŋ: Kà gəziŋ ala tekula aŋa tatak uwana avà à gi à ahàl aw, ama kà gəula atà à uda la mamətsay la sifa la mavakay makəɗ gəl à ahəŋ gudəŋ à vok. ");
INSERT INTO mfh_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Aganay uwana asa à Baba gulo: Kà dèwdèw dza, uwana tanəŋà Kona aŋa Zəzagəla, ŋgaha tadiŋal gəl à masla à vok kà, taɓəzal sifa adəv à gay aw, ŋgaha gəda­ula atà à uda la mamətsay la madəv à gay gudəŋ à vok.” ");
INSERT INTO mfh_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Azla Yahu­diya taŋoŋùz lakəl aŋa Yesu, kà uwana Yesu, ‘Gi tatak may uwana asà à ahəŋ la zagəla’, agòɗ. ");
INSERT INTO mfh_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Təga kà, Yesu kona aŋa Yusufu aw takay? Məsəl baba aŋha la iyà aŋha, ŋgaha ma kakay: ‘Gəsà à ahəŋ la zagəla’, agòɗ zlà ma?”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu awulà atà ala: “Sàkàw à maŋoŋuz à tsəh ala kà akul à akul. ");
INSERT INTO mfh_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Dza aslala vok aŋa mas à waŋ à slaka gulo aw, say Baba uwana aslə̀l gi à waŋ, la uwana abiyəŋ masla à slaka gulo, ŋgaha gi gədà­ula à uda la mamətsay la vuɗ makəɗ gəl à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Azladza uwana Zəzagəla apə̀h à atà gay à ahàl kà mapàh à azladza, tatsetsèr à wakità à abà: ˈZəzagəla la gəl aŋha adà­ta­pa­tala tatak gesina.ˈ Kəla dza uwana atsəɓ sləm à Baba, akəs mapəhay aŋha, masla atsa à waŋ à slaka gulo. ");
INSERT INTO mfh_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Asal magoɗay, kà dza adanəŋ Zəzagəla aw. Dza uwana asà à ahəŋ la slaka Zəzagəla la uwana adanəŋ Baba pəra.” ");
INSERT INTO mfh_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“La dziriga gəpəh à akul, dza uwana adiŋal gəl à vok kà, adàɓəz sifa adəv à gay aw. ");
INSERT INTO mfh_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Gi tatak may uwana avà sifa adəv gay aw. ");
INSERT INTO mfh_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Azla­baba aŋkul madzi­dziga tazùw manne la fəta la abà. Bà la uwaga bay kà tamə̀ts à gay. ");
INSERT INTO mfh_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ama uwa­be­yuwi uwana azuw tatak may uwana asà à ahəŋ la zagəla kà, adàmətsay aw. ");
INSERT INTO mfh_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Gi tatak may aŋa sifa, uwana asà à ahəŋ la zagəla. Baŋa dza azuw tatak may uwatà, adàdza à ahəŋ la sifa aŋa koksi­koksi. Tatak may uwana gədàvàl kà vok gulo, gədàvày, ŋgaha gudəŋ à vok aŋa madz à ahəŋ la sifa.” ");
INSERT INTO mfh_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Lakəl aŋa gay uwaga azla Yahu­diya tabayà vok gay kà atà kà atà, tagòɗ: “Kakay dza uwanay avà à anu sləɓ vok aŋha aŋa mazuway ma?”, tanavà vok. ");
INSERT INTO mfh_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu agòɗ à atà: “Haɗay, gəpəh à akul la dziriga: Baŋa kazuwaw sləɓ vok aŋa Kona aŋa dza aw, ŋgaha baŋa kasaw aŋiz aŋha aw kà, kadàɓəzaw à sifa tetuwa aw. ");
INSERT INTO mfh_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Dza uwana azuw sləɓ vok gulo, ŋgaha as aŋiz gulo kà, aɓəz sifa adəv à gay aw, ŋgaha gədà­ula à uda la mamətsay la vuɗ makəɗ gəl à ahəŋ gudəŋ à vok. ");
INSERT INTO mfh_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kà uwana sləɓ vok gulo kà tatak may dziriga, ŋgaha aŋiz gulo bay kà tatak masay dziriga aya. ");
INSERT INTO mfh_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Dza uwana azuw sləɓ vok gulo, as aŋiz gulo, adza à ahəŋ la gi la abà, ŋgaha gi babay gədza à ahəŋ la masla la abà. ");
INSERT INTO mfh_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bokuba uwana Baba uwana la sifa aslə̀l gi à waŋ, ŋgaha gi gədza à ahəŋ la sifa kà masla, kiya uwaga babay dza, uwana azuw gi, adza à ahəŋ la sifa kà gi babay. ");
INSERT INTO mfh_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Aganay tatak may uwana asà à ahəŋ la zagəla: Masla kà bokuba uwana azla­baba aŋkul tazawàh, uwana tamàtsàh à gay aw. Ama dza uwana azuw tatak may uwanay, adàdza à ahəŋ la sifa aŋa koksi­koksi.” ");
INSERT INTO mfh_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu apə̀h à atà gay uwaga kà la mok uwana atapla azladza la gày madəv kuɗa la aku la Kaper­nahum. ");
INSERT INTO mfh_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mok uwana tatsə̀n uwana Yesu apə̀h kà, aŋuvaw la tataka azlaməna asik aŋha la abà tagòɗ: “Gay uwanay kà zla­zlaɗa, uwa aslala vok aŋa makəs uwaga uwa?”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu asə̀l kà gay uwaga kà adàla maŋo­ŋuzay à azlaməna asik aŋha à ləv à tsəh, ŋgaha agòɗ à atà: “Uwaga ma atsəɗ akul à asik la tsəh ala takay? ");
INSERT INTO mfh_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kakay tak à gay kanəŋaw Kona aŋa dza, uwana ada à afik à slaka aŋha uwana à abà adzà à ahəŋ uwarà ma? ");
INSERT INTO mfh_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Masasəɗok Zəzagəla la uwana avà sifa; vok aŋa dza kà asla tatak aw. Azlagay uwaga gəpəh à akul, la uwana Masasəɗok ŋgaha sifa. ");
INSERT INTO mfh_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ama azladza anik la ahəŋ la tataka aŋkul la abà kà, tadiŋal gəl à vok aw.” (Kà uwana dagay madzəka kà, Yesu kà asəl azladza uwana tadà­diŋal gəl à vok aw, ŋgaha la dza uwana adàtal kaf à gəl) ");
INSERT INTO mfh_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Azalàŋ à gəl la magoɗay: “Kà uwaga à uwana gəgoɗ à akul, dza aslala vok aŋa mas à waŋ à slaka gulo aw, tsa baŋa Baba abiyəŋ à waŋ, avàl tetəvi.” ");
INSERT INTO mfh_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Dagay la mavakay uwatà aŋuvaw la tataka azlaməna manəfay aŋha la abà, tawùl à lig. ");
INSERT INTO mfh_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kiya uwaga Yesu agòɗ à azlaməna matapla la slaka aŋha kulo gəl aŋha səla: “Asa à akul madiŋ akul babay suwaŋ ay?” ");
INSERT INTO mfh_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Səmon Piyer agòɗal: “Sufəl, məday ma à slaka ma aŋa uwa? Tsa kak la azlagay uwana tav sifa adəv à gay aw uwa? ");
INSERT INTO mfh_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Lagonay kà, mədiŋal gəl à vok, kak tsi­ka­slaga uwana Zəzagəla aslə̀l ka à waŋ.” ");
INSERT INTO mfh_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu agòɗ à atà: “Akul kulo gəl aŋha səla gətsa­tsà­mànì akul aw takay? Ama tsa tekula aŋkul kà seteni!” ");
INSERT INTO mfh_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Apə̀h uwaga kà lakəl aŋa Yudas Iska­riyot, kona aŋa Səmon, uwana agà la tataka azlaməna matapla kulo gəl aŋha səla uwaga la abà. Masla la uwana naka ata kaf à Yesu à gəl. ");
INSERT INTO mfh_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Uwana uwaga adada à lig kà, Yesu auguzàh la kutso Galili, asàl kà madz à ahəŋ la kutso Yahu­diya aw, kà uwana azla Yahu­diya tayàh makəɗay. ");
INSERT INTO mfh_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mok uwana madəvaday aŋa azla Yahu­diya, uwana tazalalla madəvaday tsa­tsa­gla adagay nekwa kà, ");
INSERT INTO mfh_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","azla­deda aŋha tagòɗal: “Zà vok la abanay, hàd à Yahu­diya, kà azlaməna asik aŋak kà manəŋ sləray aŋak uwana kaɗe­ha­həŋ. ");
INSERT INTO mfh_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Baŋa dza asal azladza tasəl masla kà, apəhla gəl aŋha ala. Tsa kaɗahàh azlasləray anik anik kiya uwanay kà, ɗahàŋ la paraka azladza aŋa manəŋ ka.” ");
INSERT INTO mfh_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Amiyaka azla­deda aŋha tadiŋ gəl à masla à vok bay aw) ");
INSERT INTO mfh_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu agòɗ à atà: “Kaslà gulo uwana asa à gi kà, adasa à waŋ aw. Ama kà akul kà, kəla kaslà gesina kà delga. ");
INSERT INTO mfh_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Gudəŋ à vok aslala vok aŋa mapəsew akul aw, ama gi kà apəsew gi. Kà uwana gəpəh la paraka kà azlasləray aŋha uwana aɗehəŋ kà mawi­siga. ");
INSERT INTO mfh_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Dàw aŋkul à madəvaday akul zlà. Məday anina aw, kà uwana kaslà uwana asa à gi adasa à waŋ dadàŋ aw.” ");
INSERT INTO mfh_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Uwana adapəh à atà gay uwaga kà, adzà à ahəŋ la Galili. ");
INSERT INTO mfh_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Iyay, la mok uwana azla­deda aŋha tad à madəvaday, masla babay ahàd, ama apə̀hla vok ala aw, la səbàh pəra. ");
INSERT INTO mfh_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","La abatà la madəvaday la abà azla Yahu­diya tayàh masla la maham à ahəŋ dza la abà la madəvaday la abà: “Aŋala?”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tavàts gay la tsəh ala la gəl à gəl lakəl aŋha, la tataka maham à ahəŋ dza la abà. Azlaanik tagòɗ: “Masla kà, dza delga”, azlaanik tagòɗ bay: “Awaŋ, dza delga aw!” Tagòɗ: “Masla mazàh azladza ala.” ");
INSERT INTO mfh_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ama dza aslàla vok aŋa mapəhay gay lakəl aŋha la dazu­waya aw, kà uwana guba akə̀s atà kà azla Yahu­diya. ");
INSERT INTO mfh_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mok uwana madəvaday adada à lig tenma kà, Yesu ahàd à məŋ gày Zəzagəla à agu, adzəkà matapla tatak à azladza. ");
INSERT INTO mfh_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ləv avàl à azla Yahu­diya à gay la magoɗay: “Kakay dza uwanay asəl tatak tsa tapla aw ma?” ");
INSERT INTO mfh_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu awulà à atà ala: “Matapla uwana gəpahla ala kà, asa à waŋ kà la slaka gulo aw, ama asà à ahəŋ kà la slaka Zəzagəla, uwana aslə̀l gi à waŋ. ");
INSERT INTO mfh_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Baŋa dza asal maɗàh masal aŋa Zəzagəla kà, adàsəl tatak uwana gəpəhakulla kà, asa à waŋ kà la slaka Baba Zəzagəla, awkà uwaga kà gay aŋa ndzəɗa aŋa aslasl gəl gulo aw. ");
INSERT INTO mfh_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Dza uwana apəh gay aŋa aslasl gəl aŋha kà, ayàh mazləɓ gəl aŋha. Ama dza uwana aɗàh sləray kà aŋa dza uwana aslə̀l à waŋ kà, masla kà apəhay kà uwana dziriga, ŋgaha mawi­siga la ahəŋ la uwana la abà apəhay aw. ");
INSERT INTO mfh_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa avà à akul mapəhay aw takay? Ama amiyaka tekula aŋkul kà, akəs gay aŋa mapəhay aw. Kà mana kayahaw makəɗ gi zlà ma?” ");
INSERT INTO mfh_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Maham à ahəŋ dza awulà: “Kak la masasəɗok mawi­siga, kak masla zagəla zagəla, uwa ayàh makəɗ kà uwa?” ");
INSERT INTO mfh_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu agòɗ à atà: “Gəɗahàŋ kà sləray tekula pəra, à uwana ləv avàl akul à gay gesina! ");
INSERT INTO mfh_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa avà à akul tetəvi kà makadav azlabəza à uda, (Amiyaka Musa la uwana adzəkà makadav azlabəza à uda babay aw, ama azla­baba aŋkul madzi­dziga), kà uwaga à uwana kaka­davaw azlabəza aŋkul à uda la vuɗ maduw ləv bay. ");
INSERT INTO mfh_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kaka­davaw dza à uda la vuɗ maduw ləv kà matəm mapəhay aŋa Musa à ahəŋ aw, ŋgaha ma kà mana kapakaw gi ləv à gəl, à kà uwana gəwurà dza ala səɗa­kaka la vuɗ maduw ləv ma? ");
INSERT INTO mfh_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Sàkàw à maɗàh seriya aŋa tatak uwana kanəŋawwaŋ la uda gà. Ŋgaha ɗahàw seriya la tetəvi aŋha.” ");
INSERT INTO mfh_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Azladza anik uwana tadzà à ahəŋ la Uru­sa­lima tagòɗ: “Dza gà la uwanay à uwana tayahay aŋa makəɗay aw takay? ");
INSERT INTO mfh_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nə̀ŋàwwàŋ, aɓaɗma la dazu­waya la tataka azladza la abà, ama uwala gay la ahəŋ tapəhal aw. Ŋgaha azlaməŋga gami ma tasəl kà masla la uwana Kristu ndzer zlà ma uwa? ");
INSERT INTO mfh_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ama baŋa Kristu adàsa à waŋ, dza la ahəŋ asəl slaka uwana adaguwa à waŋ la abà aw. Ama dza uwanay kà məsəl slaka uwana asà à waŋ la abà.” ");
INSERT INTO mfh_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu ataplà la məŋ gày Zəzagəla la aku, azà kuda à zagəla agòɗ à atà: “La dziriga kasəlaw gi, ŋgaha kasəlaw slaka uwana gəsà à waŋ la abà ay? Gi kà, gəsà à waŋ kà la aslasl gəl gulo aw, ama dza uwana aslə̀l gi à waŋ kà, dza dziriga. Akul kà kasəlaw aw! ");
INSERT INTO mfh_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ama gi kà, gəsəl masla, kà uwana la slaka aŋha la uwana gəsà à waŋ, ŋgaha masla la uwana asləl gi à waŋ bay.” ");
INSERT INTO mfh_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kiya uwaga tayàh makəs masla, ama dza aslà kà matapal ahàl à vok aw, kà uwana kaslà aŋha adaslay dadàŋ aw. ");
INSERT INTO mfh_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Aŋuvaw la tataka maham à ahəŋ dza la abà, tadìŋ gəl à masla à vok, tagòɗ: “Baŋa Kristu adàsa à waŋ kà, adà­ɗe­həŋ azla­na­dzipo adà­ɗuwaŋ aŋa kona uwanay ay?”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Azla Farisəya tatsənà uwana maham à ahəŋ dza apə̀h la gəl à gəl lakəl aŋa Yesu, ŋgaha azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla, la azla Farisəya taslə̀l azla­ko­hana kà makəs masla. ");
INSERT INTO mfh_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu apə̀h à atà la paraka: “Gi la ahəŋ la akul aŋa kaslà ŋuv aya, la lig la ahəŋ gədàwula à slaka dza, uwana aslə̀l gi à waŋ. ");
INSERT INTO mfh_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kadà­yahaw gi ama kadàɓəz gi aw, kà uwana kaslaw mad à slaka uwana gədàday aw.” ");
INSERT INTO mfh_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Azla Yahu­diya tanàv vok kà atà kà atà: “Lagwa ma masla ma adàday ma uwala à uwana: ‘Kadànəŋaw gi aya aw’, agòɗla? Adàday ma à slaka azla Yahu­diya uwana taslə̀h gəl à ahəŋ la tataka azla Gərək la abà, kà matapatàla azla­tatak takay? ");
INSERT INTO mfh_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Gay uwaga apə̀h ma mana asal magoɗay ma? ‘Kadà­yahaw gi, ama kadàɓəza gi aw, kà uwana kaslawwal à vok mad à slaka uwana gədàday aw. La slaka uwana gədàdza à ahəŋ babay aw’, agòɗ ma?” ");
INSERT INTO mfh_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","La mavakay uwana takə̀ɗ gəl à mavədaday, la uwana aga delga, la vuɗ uwatà Yesu astìzlla ala la huma maham à ahəŋ dza, azà kuda à zagəla, agòɗ: “Uwa­be­yuwi uwana nəlay azəŋ, asa à waŋ, asa iyaw la slaka gulo. ");
INSERT INTO mfh_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kəla uwa­be­yuwi uwana adiŋ gi gəl à vok, dərəv aŋa iyaw sifa adàkəlay la ləv aŋha la tsəh bokuba uwana tatsetsèr à wakità Zəzagəla à abà.” ");
INSERT INTO mfh_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu kà apəhay kà lakəl aŋa Masasəɗok Zəzagəla, uwana azla­uwana tadiŋal gəl à vok tadàɓəzal, kà uwana taɓəz Masasəɗok dadàŋ aw, kà uwana Yesu adada à afik kà maɓəz mazləɓay la slaka Baba aŋha aw. ");
INSERT INTO mfh_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Azladza anik la tataka maham à ahəŋ dza la abà tatsənàŋ gay uwaga tagòɗ: “Ndzer kà, dza uwanay kà masla mapəhal gay à ahàl aŋa Zəzagəla kà mapàh à azladza.” ");
INSERT INTO mfh_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Azlaanik tagòɗ: “Masla kà Kristu!”, azlaanik tagòɗ: “Awaŋ, masla aw, Kristu kà aguwa à waŋ la Galili ay? ");
INSERT INTO mfh_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tatsetsèr à wakità Zəzagəla à abà kà: Kristu kà adàguwa à uda kà la mayyi à tsəh ala aŋa David, ŋgaha adàguwa à waŋ la Be­te­lehem, la gudəŋ uwana David adzà à ahəŋ la abà.” ");
INSERT INTO mfh_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Maham à ahəŋ dza atsàk ala kà Yesu. ");
INSERT INTO mfh_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Azlaanik la tataka aŋatà la abà, asà à atà makəs Yesu, ama dza la ahəŋ aslàla vok aŋa matapal ahàl à vok aw. ");
INSERT INTO mfh_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Azla­ko­hana tawùl à slaka azlaməŋga aŋa azlaməna mav tatak à Zəzagəla la azla Farisəya, tanàv atà: “Kà mana kasàwla Yesu à waŋ aw ma?” ");
INSERT INTO mfh_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Azladza uwana taslə̀lla atà, tawulà à atà: “Dza la ahəŋ adapəh gay ku bà aŋa dza uwanay didi didi aw.” ");
INSERT INTO mfh_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Azla Farisəya tanàv atà: “Akul babay kà kadànəfaw mapa­patay aŋha uwaga ŋwà? ");
INSERT INTO mfh_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Məŋga la ahəŋ la tataka gami la abà, baŋaw la tataka aŋa azla Farisəya la abà, ada­diŋal gəl à vok ay? ");
INSERT INTO mfh_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ama say azladza deyday gà la uwana tadiŋal gəl à vok, kà uwana tasəl mapəhay aŋa Musa aw, atà azla­ma­tsaf­laga!” ");
INSERT INTO mfh_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Niko­demus agà la tataka aŋa azla Farisəya la abà. A masla uwana asà à waŋ à slaka Yesu la vəɗ vərdi anik, agòɗ à atà: ");
INSERT INTO mfh_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Haɗay, ma wakità seriya avà tetəvi kà maɗàh seriya à dza à gəl, la kokuɗa matsən uwana aɗahàŋ takay? Awma məsəl uwana aɗahàŋ aw, takay?” ");
INSERT INTO mfh_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tawulàl ala: “Kak zil Galili ay? Dzèŋ wakità lela, ŋgaha kadà­tse­nəŋ kà masla mapəhal gay à ahàl aŋa Zəzagəla adàguwa à waŋ la Galili aw!” (( ");
INSERT INTO mfh_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","La lig la ahəŋ kəla uwa­be­yuwi awùl à mtəga aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mok uwana uwaga adadəv à gay kà, Yesu ahàd à gudəŋ kuvu à afik. ");
INSERT INTO mfh_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","La bebəŋ gà la zay la tsəh, awùl à məŋ gày Zəzagəla à agu aya, ŋgaha maham à ahəŋ dza aŋuvaw tahamà à slaka aŋha. Adzà madzay, adzəkà mata­patàla azla­tatak ");
INSERT INTO mfh_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Azlaməna mapàhla mapəhay ala, la azla Farisəya tadàlla mis uwana à awtày, takə̀s la mazaɓ zil la tsəh. Atà tatsìzllàŋ à huma aŋa maham à ahəŋ dza gesina, ");
INSERT INTO mfh_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ŋgaha tanàv Yesu: “Məŋga, mis uwanay kà, takə̀s kà la mabila la tsəh. ");
INSERT INTO mfh_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","La wakità Zəzagəla gami la abà Musa agòɗ à anu kà, azlatsəhay mis uwanay kà, say makaɗ atà la matsàh atà la akur pəra. Kak ma kakay kagoɗ ma?” ");
INSERT INTO mfh_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tapə̀h uwaga kà, kà makəsal madiŋay à ahəŋ kà aŋa mapuwal gudzi à gəl. Ama la abatà Yesu akəsà gəl à ahəŋ, anə̀h à kutso à abà la gay gəl ahàl aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Uwana bà manaval tanavàl kà, awulà gəl à afik la magoɗ à atà: “Dza uwana la tataka aŋkul la abà adaɗah tsakana didi aw kà, atsa vok ala akur à mis uwaga zlà!” ");
INSERT INTO mfh_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ŋgaha la lig la ahəŋ, awulà gəl à vəɗah kà manəhay aya. ");
INSERT INTO mfh_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mok uwana tatsənà gay uwaga kà, tadahà aŋatà la tekula, tekula, azla­ma­golga dàŋ, ŋgaha azlabəza gà. Yesu agə̀ɗ à ahəŋ kokuɗa aŋha la mis matsizl à ahəŋ gà, uwaga la huma aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kiya uwaga awulà gəl à afik agòɗal: “Mis, atà la azlaməna mapuwa à ka gudzi à gəl aŋak la? Dza la ahəŋ aɗùkw kà ka seriya à gəl aw uwa?” ");
INSERT INTO mfh_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Dza la ahəŋ aw, məŋga”, mis agòɗal. Yesu agòɗal: “Gi babay kà, gədukw ka seriya à gəl aw, hàd, ama kadà­ɗaha tsakana aya aw!”, Yesu agòɗal.)) ");
INSERT INTO mfh_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Bà gotənaŋ Yesu apə̀h gay à maham à ahəŋ dza aya: “Gi la uwana gi uɗaka aŋa gudəŋ à vok. Dza uwana anəf gi kà masla adàɓəz uɗaka aŋa sifa, adàday la mələs la abà aw.” ");
INSERT INTO mfh_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Azla Farisəya tagòɗal: “Kak kà kapəhay kà sayda aŋa gəl aŋak, uwana kapəhay kà makəs vok aŋha la ahəŋ aw.” ");
INSERT INTO mfh_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu awulà à uda agòɗ à atà: “Baməraka gədaza sayda aŋa gəl gulo babay kà, mapəhay gulo kà dziriga, kà uwana gi kà gəsəl slaka uwana gəsà à waŋ, la slaka uwana gəday babay. Ama akul kà, kasəlaw slaka uwana gəsà à waŋ la slaka uwana gəday babay aw. ");
INSERT INTO mfh_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Akul kà kaɗahaw seriya kà la mahoy yewdi, ama gi kà gəɗàh seriya kà kiya uwaga aw. ");
INSERT INTO mfh_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bà amiyaka gəɗàh seriya à dza kà seriya gulo kà dziriga, kà uwana gəɗàh seriya kà kokuɗa gəl gulo aw, ama anu la Baba uwana aslə̀l gi à waŋ. ");
INSERT INTO mfh_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Uwaga kà matse­tse­rayga la wakità seriya aŋkul la abà: Sayda aŋa azladza səla uwana tapəhay kalkal kà dziriga. ");
INSERT INTO mfh_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Gəza sayda aŋa gəl gulo ŋgaha Baba uwana aslə̀l gi à waŋ az sayda aŋa gəl gulo babay.” ");
INSERT INTO mfh_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tanàv Yesu: “Uwa à Baba aŋak uwa?” Yesu awulà à atà ala: “Akul kasəlaw gi aw, baməraka Baba gulo babay aw, agayŋa kasəlaw gi kà, naka kasəlaw Baba gulo babay.” ");
INSERT INTO mfh_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu apə̀h gay uwaga kà la mok uwana atàpatàla tatak la məŋ gày Zəzagəla la aku. Apə̀h uwaga kà la slaka uwana tafàh sahar aŋa ofərand à ahəŋ, dza aslàla vok aŋa makəsay aw, kà uwana kaslà aŋha adaslay dadàŋ aw. ");
INSERT INTO mfh_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu agòɗ à atà aya: “Gəda aŋulo, kadà­yahaw gi, ama akul kadà­matsaw à tsakana aŋkul à abà. Kaslawwal à vok kà mad à slaka uwana gəday aw.” ");
INSERT INTO mfh_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Azla Yahu­diya tagòɗ vok kà: “Adàkəɗ vok ay à uwana: ‘Kaslawwalla vok kà mad à slaka uwana gəday aw’, agoɗay?” ");
INSERT INTO mfh_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu awulà à atà ala: “Akul kà akul azladza aŋa vəɗah, ama gi kà gəsà à ahəŋ kà la zagəla. Akul azlaaŋa gudəŋ à vok uwanay, ama gi kà gi aŋa gudəŋ à vok uwanay aw. ");
INSERT INTO mfh_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kà uwana à uwana gəgoɗ à akul kà kadà­matsaw à tsakana aŋkul à abà, ndzer kà, kadà­matsaw à tsakana aŋkul à abà, à baŋa kadiŋaw gi gəl à vok à gi uwana gi aw.” ");
INSERT INTO mfh_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tanavàl à gay zlà: “Kak uwa?” Yesu agòɗ à atà: “Gi uwana gəpəh à akul dagay madzəka. ");
INSERT INTO mfh_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Lakəl aŋkul gi la azlagay məŋga aŋa mapəh à akul, à gay uwana aɗahakulla seriya à gəl. Ama dza aslə̀l gi à waŋ kà dziriga, gəpəhay à azladza gudəŋ à vok kà uwana gətapla la slaka Baba pəra.” ");
INSERT INTO mfh_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tasə̀l kà Yesu apəhay lakəl aŋa Baba Zəzagəla aw. ");
INSERT INTO mfh_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kiya uwaga Yesu agòɗ à atà: “Baŋa kadà­tsizllaw Kona aŋa dza ala kà, kadàsəlaw kà gi uwana gi la ahəŋ. Kadàsəlaw kà gəɗàh tatak la gəl gulo aw, ama gəpəhay kà lakəl aŋa uwana Baba apahà à gi ala pəra. ");
INSERT INTO mfh_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Dza uwana aslə̀l gi à waŋ kà, anu səla, awkà asàk gi kokuɗa gəl gulo aw, kà uwana koksi­koksi gəɗehəŋ uwana ahəɗal à adi.” ");
INSERT INTO mfh_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Uwana Yesu adapəhay kiya uwaga, azladza aŋuvaw tadìŋal gəl à masla à vok. ");
INSERT INTO mfh_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu agòɗ à azla Yahu­diya uwana tadìŋal gəl à vok: “Baŋa kakəsaw matapla à mapəhay gulo kà, kadàgaw azlaməna matapla la slaka gulo ndzer. ");
INSERT INTO mfh_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kiya uwaga kà, kadàsəlaw dziriga, ŋgaha dziriga adàdala akul à makor gəl à abà.” ");
INSERT INTO mfh_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tawulà à uda: “Anu kà anu mayyi à tsəh ala aŋa Abəraham, ŋgaha anu azla­mayà aŋa azladza ɗiki­ɗiki aw, ŋgaha ma kakay kagoɗ à anu kà, mədàgay la makor gəl la abà ma?” ");
INSERT INTO mfh_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu agòɗ à atà: “Haɗay, gəpəh à akul la dziriga: Kəla uwa­be­yuwi uwana aɗàh tsakana kà, masla kà mayà aŋa tsakana. ");
INSERT INTO mfh_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mayà kà, aslala vok aŋa magay masla gày aw. Ama kona kà, agay masla gày aŋa koksi­koksi. ");
INSERT INTO mfh_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Baŋa Kona adàpəlakulla kadàgaw la makor gəl la abà ndzer. ");
INSERT INTO mfh_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Gəsəl kà akul mayyi à tsəh ala aŋa Abəraham. Ama kayahaw makəɗ gi aya, kà uwana kakəsaw matapakulla gulo aw. ");
INSERT INTO mfh_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Gəpəhay lakəl aŋa tatak uwana Baba gulo apə̀h à gi ala, ama akul kà kaɗahaw uwana baba aŋkul tapàhàkulla, suwaŋ.” ");
INSERT INTO mfh_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tawulà à uda: “Baba gami kà Abəraham!” Yesu awulà à atà ala: “Agayŋa kagaw azlabəza aŋa Abəraham kà, naka kaɗahaw sləray aŋa Abəraham uwana aɗa­hàhàŋ. ");
INSERT INTO mfh_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Gi kà, gəpəh à akul kà dziriga, uwana gətsənàŋ la slaka Zəzagəla, la uwana gəpəh à akul, ama bà la uwaga kà, kayahaw makəɗ gi. Tsəhay gà uwaga kà, Abəraham aɗahàŋ didi aw. ");
INSERT INTO mfh_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Akul kà kaɗa­hawwaŋ kà sləray aŋa baba aŋkul.” Atà tawulà ala: “Anu azlabəza gəl gaw aw, anu Baba gami kà la Zəzagəla, tekula pəra.” ");
INSERT INTO mfh_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu agòɗ à atà: “Agayŋa Zəzagəla agay Baba aŋkul ndzer kà, naka kawoyaw gi, kà uwana gəsà à waŋ la slaka aŋha, à uwana gəsà à slaka aŋkul kà masal aŋha. Gəsà à waŋ kà, la aslasl gəl gulo aw, masla la uwana aslə̀l gi à waŋ. ");
INSERT INTO mfh_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kà mana katsəɓaw sləm à uwana gəpəh à akul aw zlà ma? Kà uwana kaslaw kà aŋa matsən uwana gəpəhay aw. ");
INSERT INTO mfh_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Akul kà, baba aŋkul kà la seteni, asa à akul maɗàh uwana asa à seteni kà uwana masla makaɗ dza dagay la madzəka vok aŋa tatak. Adapəh dziriga didi aw, kà uwana dziriga la ahəŋ la slaka aŋha aw. Baŋa apəh fida, apəh la fəla aŋha, kà uwana masla fida, ŋgaha masla baba aŋa fida. ");
INSERT INTO mfh_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ama gi kà, gəpəhay kà dziriga, ŋgaha kà uwaga la uwana kadiŋaw gi gəl à vok aw. ");
INSERT INTO mfh_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Uwa la tataka aŋkul la abà aslala vok agoɗay kà, gəda­ɗe­həŋ tsakana uwa? Kà mana, baŋa gəpəh dziriga kà, kadi­ŋawwal gəl à vok aw zlà ma? ");
INSERT INTO mfh_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dza aŋa Zəzagəla kà, atsə̀ɓ sləm à gay Zəzagəla. Ama akul azlaaŋa Zəzagəla aw. Gay gà la uwaga katsəɓaw gi sləm aw!” ");
INSERT INTO mfh_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Azla Yahu­diya tagòɗal: “Azlayla anu à uwana: Kak zil Sama­riya, məgoɗ à ka, ŋgaha kak la azla­ma­sasəɗok mawi­siga aw uwà?” ");
INSERT INTO mfh_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu agòɗ à atà: “Gi la masasəɗok mawi­siga aw, ama gi gəsləkaw Baba gulo, ama akul kà kapəsew gi. ");
INSERT INTO mfh_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Gi kà gəyàh mazləɓay aŋa gəl gulo aw. Dza anik la ahəŋ tekula, uwana ayàh gi mazləɓay, masla la uwana masla seriya bay. ");
INSERT INTO mfh_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","La dziriga gəpəh à akul: Dza uwana akəs gay gulo, adàmətsay ɗiki­ɗiki aw.” ");
INSERT INTO mfh_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Azla Yahu­diya tagòɗal: “Lagonay kà məsəl ndzer kà, kà kak la masasəɗok mawi­siga, Abəraham amə̀ts, azlaməna mapəh à atà gay à ahàl tamàts, ŋgaha kak kagoɗay kà: ‘Dza uwana akəs mapəhay gulo kà, adàmətsay aw’, kagoɗ ma? ");
INSERT INTO mfh_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Baba gami Abəraham amə̀ts: Kadzugw ma: ‘Gəɗuwa masla’, kagoɗ takay? Azlaməna mapəh à atà gay à ahàl bay tamàts. Ŋgaha ma kapakà gəl aŋak ala ma kà kak uwi?” ");
INSERT INTO mfh_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu awulà à atà ala, la magoɗay: “Agayŋa gəzləɓ gəl gulo kà, naka mazləɓay gulo, akəs vok aw. Baba gulo la uwana azləɓ gi, à masla à uwana: ‘Zəzagəla gami’, kagoɗaw. ");
INSERT INTO mfh_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ama kasəlaw masla ɗiki­ɗiki aw. Ama gi kà gəsəl masla. Agayŋa gəgoɗay kà, gəsəl masla aw kà, naka gəgay masla fida bokuba akul. Ama gəsəl masla, ŋgaha gəkəs gay aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abəraham baba aŋkul kà, aràb lakəl mavakay aŋa mas à waŋ gulo, anəŋàŋ ŋgaha aràb kaykay.” ");
INSERT INTO mfh_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Azla Yahu­diya tagòɗal: “Uwala kaslay mavay dzik zlo, awkà pəra: ‘Gənəŋà Abəraham’, kagoɗ ay?” ");
INSERT INTO mfh_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu awulà à uda: “Haɗay, gəpəh à akul la dziriga: Mok uwana talə̀g mayyay Abəraham kà, gi la ahəŋ.” ");
INSERT INTO mfh_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ŋgaha tahə̀l akur kà matsàhla. Ama kusàh. Yesu ahaɗà vok à ahəŋ, asà à lag la məŋ gày Zəzagəla la aku. ");
INSERT INTO mfh_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Mok uwana Yesu anəfà tetəvi aŋha, anəŋàŋ dza anik uwana tayyà à ahəŋ guləf gà. ");
INSERT INTO mfh_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Azlaməna matapla la slaka aŋha tanavà: “Məŋga, kà mana dza uwanay kà tayyà à ahəŋ kà guləf gà ma? Kà tsakana aŋa gəl aŋha ay, à uwana kà tsakana aŋa azla­baba aŋha ay?” ");
INSERT INTO mfh_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu awulà à atà ala: “Kà tsakana aŋha aw, kà tsakana aŋa azla­baba aŋha magay aw. Tayyà guləf kà, kà sləray aŋa Zəzagəla aŋa mapəhla vok ala la masla la abà pəra. ");
INSERT INTO mfh_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","La afats kà, say məɗàh sləray aŋa dza uwana aslə̀l gi à waŋ. Vəɗ la uwaga atsa à waŋ, à uwana dza aslala vok aŋa maɗàh sləray aya aw. ");
INSERT INTO mfh_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","La mok uwana gi la gudəŋ la vok kà, gi uɗaka aŋa gudəŋ à vok.” ");
INSERT INTO mfh_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Uwana Yesu adapəh uwaga la gay ala, atə̀f slesliɓ à vəɗah aləpànì kutso, asəfàh à yewdi aŋa guləf uwaga. ");
INSERT INTO mfh_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ŋgaha agòɗal: “Hàd, kadàpal yewdi aŋak la mukwà Silowe la abà (Sləm uwaga asal magoɗay masləlay) Guləf ahàd, apàl adi. La mok uwana awùl à waŋ la tetəvi la ama, aslàla vok aŋa manəŋla adagay.” ");
INSERT INTO mfh_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Azlaməna magay aŋha la azladza uwana tanàŋ à ahəŋ atsatsàh tatak uwarà, tagòɗ: “Uwanay kà dza uwana adzàhah madzay kà matsatsàh tatak aw, takay?” ");
INSERT INTO mfh_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Azladza anik: “Masla”, tagòɗàh. Azlaanik babay: “Masla aw”, tagòɗ, “Ama maftsa à vok aŋha pəra”, tagòɗ. Zil uwaga agòɗ à atà: “Kà bà, gi!” ");
INSERT INTO mfh_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tagòɗal: “Kakay yewdi aŋak apakwà vok ma?” ");
INSERT INTO mfh_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Agòɗ à atà: “Dza uwana tazalalla Yesu aləpànì abisl, ŋgaha asàfàh gi à yewdi, ŋgaha agòɗ à gi: ‘Hàd, kadàpal adi aŋak la mukwà Silowe la abà’, agòɗ à gi. Ŋgaha gəhàd, mok uwana gədapal à adi, gəslàla vok aŋa manəŋla.” ");
INSERT INTO mfh_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tanavàl: “Aŋala dza uwatà la?”, tagòɗal, “Gəsəl aw”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kiya uwaga tadàla guləf à slaka azla Farisəya. ");
INSERT INTO mfh_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Kà uwana Yesu aləpànì kutso, asə̀fàhal à yewdi kà dza uwatà la mavakay maduw ləv à uwana awuràŋ ala. ");
INSERT INTO mfh_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kà uwaga à uwana azla Farisəya babay tanàv dza uwatà, tagòɗal: “Kakay kanəŋla lagonay adagay ma?” Kona uwaga agòɗ à atà: “Asàfàh à gi abisl à yewdi, ŋgaha agòɗ à gi: ‘Hàd à mukwà Silowe à abà, kapal adi’, ayà gəgòɗ, gəhàd, gəpàl adi, ŋgaha lagwa gədanəŋla.” ");
INSERT INTO mfh_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Azlaanik la tataka azla Farisəya la abà tagòɗ: “Dza uwana aɗahà tsəhay gà uwanay kà, asà à waŋ kà la slaka Zəzagəla aw, kà uwana afà gəl à vuɗ maduw ləv aw.” Ama azlaanik tagòɗ: “Kakay dza aslala vok aŋa maɗàh nadzipo kiya uwanay, tsa baŋa masla tsakana ma?” Ŋgaha tatsàk ala la tataka aŋatà la abà. ");
INSERT INTO mfh_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Azla Farisəya tanàv à guləf uwana awùr ala aya gotənaŋ: “Kak ma uwa kagoɗ kà dza uwana awurà kà ala uwa?” Agòɗ à atà: “Masla mapəhal gay à ahàl aŋa Zəzagəla, kà mapàh à azladza”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bà gotənaŋ azla Farisəya tadìŋal gəl à vok, kà masla tayyà guləf gà aw, ŋgaha awùr ala tagòɗ aw, kà uwaga à uwana tazàl azla­baba aŋha à waŋ aya babay, ");
INSERT INTO mfh_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","kà tanav atà gay ala, tagòɗ: “Haɗay ma, uwanay kà kona aŋkul ay? Ndzer ma, kayyàw ma guləf gà ay? Kà kay à uwana apakà vok à uwana anə̀ŋla lagwa adagay ma?” ");
INSERT INTO mfh_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Azla­baba aŋha tawulà à uda, tagòɗ: “Məsəl kà masla kona gami, uwana məyyà guləf gà. ");
INSERT INTO mfh_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ama anu kà, məsəl tatak uwana apakà vok kà manəŋla aŋha lagonay aw, ŋgaha məsəl dza uwana apə̀zllal yewdi babay aw. Nàvàw à masla la gəl aŋha, kà uwana masla asla manaval gay adagay.” ");
INSERT INTO mfh_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Uwana tapə̀h kiya uwanay kà, kà uwana guba akə̀s à atà kà azla Yahu­diya, kà uwana azla Yahu­diya tatsa­tsə̀l vok gay kà atà aŋa makuɗək azladza uwana à lag la gày madəv kuɗa la aku, uwana: ‘Yesu kà Kristu’, tagoɗay. ");
INSERT INTO mfh_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kà uwaga à uwana azla­baba aŋha tagòɗ kà: “Masla kà asla maula gay à uda la gəl aŋha, nàvàw à masla”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bà gotənaŋ azla Farisəya tahàd, tazàla dza uwana awùr ala aya kà masəla, ŋgaha tagòɗal: “Pə̀h la dziriga la huma Zəzagəla, məsəl kà dza uwatà kà masla tsakana.” ");
INSERT INTO mfh_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Agòɗ à atà: “Gəsəl aw, adagay masla tsakana, adagay masla tsakana aw kà, gəsəl aw. Ama tatak tekula uwana gəsəl kà: Gi guləf, ama lagwa kà gənəŋla!” ");
INSERT INTO mfh_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tanavàl aya: “Mana kaɗahàŋ ma? Kakay apə̀zl à ka yewdi ma?” ");
INSERT INTO mfh_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Awulà à atà ala: “Gədapəh à akul təga aw uwa?”, agòɗ à atà. “Ama kafàw gi sləm aw. Kà mana asa à akul matsənəŋ aya kà masəla ma mi? Awma akul babay ma asa à akul magay azlaməna matapla la slaka aŋha babay kəla ay?” ");
INSERT INTO mfh_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tatsə̀kal mago­ɗahay à gəl la magoɗay: “Kak masla matapla aŋa zil uwaga, ama anu kà anu, anu azlaməna matapla aŋa Musa. ");
INSERT INTO mfh_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Məsəl kà Zəzagəla aɓaɗmà la Musa, ama masla kà, bà slaka uwana asà à waŋ la abà kà, məsəl aw!” ");
INSERT INTO mfh_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Zil uwaga awulà à atà ala: “Lagwa kà tatak uwanay la uwana aval ləv à dza à gay zlà, kasəlaw slaka uwana asà à waŋ la abà aw, ama masla la uwana apə̀zl gi yewdi gulo! ");
INSERT INTO mfh_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Məsəl kà Zəzagəla atsəɓ sləm à azlaməna tsakana aw, ama atsəɓ sləm à dza uwana ahoy yewdi aŋha, ŋgaha akəs mapəhay aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Didi didi gəda­tsənəŋ tagoɗay kà dza adapəzl yewdi à dza, uwana tayyà guləf gà aw. ");
INSERT INTO mfh_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Agayŋa dza uwaga atsà à waŋ la slaka Zəzagəla aw kà, naka tatak la ahəŋ aɗehəŋ aw.” ");
INSERT INTO mfh_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tagòɗ à guləf: “Tayyà ka à tsakana à abà, ŋgaha ma asa à ka, kà matapanula tatak takay?”, takuɗə̀k à lag la gày madəv kuɗa la aku. ");
INSERT INTO mfh_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mok uwana atsənà à Yesu kà takuɗə̀k à lag la gày madəv kuɗa la aku kà, agagàm atà səla, agòɗal: “Kadiŋ gəl à Kona aŋa dza à vok ay?” ");
INSERT INTO mfh_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","“Məŋga, pə̀hgəla, uwa à masla uwa, kà gi aŋa madiŋ gəl à masla à vok uwa?”, agòɗal. ");
INSERT INTO mfh_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","“Masla gà la uwaga kanəŋaŋ, à uwana aɓa­ɗa­kama lagwa”, Yesu agòɗal. ");
INSERT INTO mfh_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Gədiŋal à ka gəl à vok, Sufəl gulo”, zil uwaga agòɗal, ŋgaha la makədeɗ à ahəŋ la huma aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kiya uwaga Yesu agòɗal: “Gəsà à waŋ à gudəŋ uwanay à vok kà seriya aŋa maɗàh vok, kà azla­gu­ləf aŋa manəŋla, ŋgaha azlaməna yewdi aŋa mapakàh guləf.” ");
INSERT INTO mfh_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Azlaanik la tataka azla Farisəya la abà, uwana la slaka aŋha la abatà, tatsənà gay uwaga, ŋgaha tanavàl: “Anu ma anu azla­gu­ləf babay suwaŋ ay?” ");
INSERT INTO mfh_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu agòɗ à atà: “Agayŋa kagaw azla­gu­ləf kà, naka kagaw azlaməna tsakana aw, ‘Tsa mənəŋla’, kagoɗaw kà, tsakana aŋkul aləg.” ");
INSERT INTO mfh_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Gəpəh à akul la dziriga, dza uwana aguw la gay gamagày aŋa gargar aŋa azla­tuwaŋ aw, ama aguwa à ahəŋ kà la gəl aŋa zlagam, bi aguway la slaka anik kà, masla kà masla gəl, masla nabəra. ");
INSERT INTO mfh_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ama dza uwana aguwa à gày la gamagày kà, masla manəŋla azla­tuwaŋ. ");
INSERT INTO mfh_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Masla manəŋla gamagày kà apəzlal gamagày, azla­tuwaŋ bay tatsən kuda aŋha. Azàllàh azla­tuwaŋ aŋha, sləm la sləm, ŋgaha atsala atà à uda. ");
INSERT INTO mfh_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Baŋa adasa à atà à uda gesina kà, masla aguwa atà à huma, azla­tuwaŋ tanəfay, kà uwana tasəl kuda aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ama tanəf məlok dza aw, tahoyal à ahàl, kà uwana tasəl kuda aŋha aw.” ");
INSERT INTO mfh_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu apə̀h à atà gay la gay la abà uwaga, ama tasə̀l tatak uwana apə̀h à atà aw. ");
INSERT INTO mfh_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu agòɗ aya: “Gəpəh à akul la dziriga, gi la uwana gi gamagày aŋa gargar aŋa azla­tuwaŋ. ");
INSERT INTO mfh_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Azla­uwana tatsà à vok à waŋ kà gi kà, gesina kà, azlaməna gəl, azlaməna nabəra. Ama azla­tuwaŋ tatsə̀ɓ à atà sləm aw. ");
INSERT INTO mfh_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Gi la uwana gi gamagày. Dza uwana adàda à gày la sləm gulo adà­ɓelay, aslala vok ada à gày, atsa à uda, aɓəz tatak may. ");
INSERT INTO mfh_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Masla gəl kà, atsa à waŋ kà, kà mad à gəl pəra, makaɗay, la madà­dasàh atà ala. Ama gi kà gəsà à waŋ kà azladza aŋa maɓəzal sifa uwana aɗuwa vok kaykay.” ");
INSERT INTO mfh_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Gi masla manəŋla azla­tuwaŋ delga. Masla manəŋla azla­tuwaŋ delga av sifa aŋha kà azla­tuwaŋ aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Dza uwana aɗàh sləray kà aŋa sili pəra, uwala azla­tuwaŋ aŋha aw kà, dza aŋa azla­tuwaŋ aw. Asakay azla­tuwaŋ à ahəŋ, ahoy aŋha à baŋa anəŋa kəda fəta atsa à waŋ à slaka aŋha, ŋgaha kəda fəta akəs atà, adà­dasàh atà gesina. ");
INSERT INTO mfh_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ahoy aŋha kà uwana aɗàh sləray kà aŋa sili, ŋgaha af sləm à azla­tuwaŋ aw. ");
INSERT INTO mfh_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Gi masla manəŋla azla­tuwaŋ delga. Bokuba uwana Baba asəl gi, gi bay gəsəl masla. Gəsəl azla­tuwaŋ gulo, atà babay tasəl gi. Ŋgaha gəv sifa gulo kà aŋa azla­tuwaŋ gulo. ");
INSERT INTO mfh_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Azla­tuwaŋ gulo anik la ahəŋ à uwana atà la ahəŋ la gargar uwanay la abà aw. Say gəsəlla atà à waŋ babay kà atà aŋa masəl kuda gulo lagwa. Kiya uwaga adagay maham à ahəŋ tuwaŋ tekula, la masla manəŋla atà tekula à ahàl.” ");
INSERT INTO mfh_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Baba awoya gi, kà uwana gəvà sifa gulo, kà gi aŋa maulal à tsəh aya. ");
INSERT INTO mfh_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Dza la ahəŋ azəɓ sifa la slaka gulo la ndzəɗa aw, ama gi la uwana gəvày la mawoyəŋ gulo. Gi la maslay kà mavày, ŋgaha gi la maslay aŋa maulal à tsəh aya. Kiya uwaga la uwana: ‘Ɗahàŋ’, Baba gulo agòɗ à gi.” ");
INSERT INTO mfh_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kà gay uwaga matsakla ahàd à tataka azla Yahu­diya à abà aya. ");
INSERT INTO mfh_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Aŋuvaw la tataka aŋatà la abà tagòɗ: “Masla la masasəɗok mawi­siga, bada, kà mana katsəɓawwal sləm ma?” ");
INSERT INTO mfh_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Azlaanik tagòɗ: “Dza uwana la masasəɗok mawi­siga aslala vok aŋa maɗehəŋ kiya uwanay aw. Kakay masasəɗok mawi­siga aslala vok mawur guləf ala ma?” ");
INSERT INTO mfh_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Madəvaday matsi­kasl məŋ gày Zəzagəla ala apakà vok la Uru­sa­lima la təla awkusa. ");
INSERT INTO mfh_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu auguzàh la məŋ gày Zəzagəla la aku la tsəh tsa­tsa­gla aŋa Salomon. ");
INSERT INTO mfh_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Kiya uwaga azla Yahu­diya takə̀sal gay à adi, tagòɗal: “Mbà kadàsəlla à anu à uda la madzugway gami la abà ma? Baŋa kak Kristu kà, pə̀h à anu la dazu­waya, lakana!” ");
INSERT INTO mfh_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu agòɗ à atà: “Gədapəh à akul nəma, asa à akul matsəɓ gi sləm aw pəra. Sləray uwanay gəɗehəŋ la ndzəɗa aŋa Baba gulo kà sayda gulo. ");
INSERT INTO mfh_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ama akul kà, kadi­ŋawwal gəl à vok aw, kà uwana akul la tataka aŋa azla­tuwaŋ gulo la abà aw. ");
INSERT INTO mfh_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Azla­tuwaŋ gulo tatsəna kuda gulo, gəsəl atà, ŋgaha tanəfa gi. ");
INSERT INTO mfh_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Gəvà à atà sifa adəv à gay aw, tadàmətsay didi aw, dza aslala vok aŋa mahəl atà la ahàl gulo aw. ");
INSERT INTO mfh_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tatak uwana Baba gulo aɓə̀k gi atà kà, aɗuwaŋ azla­tatak gesina, dza la ahəŋ ahəl atà la ahàl aŋa Baba gulo aw. ");
INSERT INTO mfh_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Anu la Baba kà anu tekula.” ");
INSERT INTO mfh_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Azla Yahu­diya tahə̀l akur kà matsàhla aya. ");
INSERT INTO mfh_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ama Yesu agòɗ à atà: “Gəɗahà azlasləray dzəɓa aŋha səla aw gà uwanay, la huma aŋkul gesina la maslay aŋa Baba gulo uwana avà à gi, ŋgaha ma kà sləray ma uwala asa à akul matsàhgəla akur la?” ");
INSERT INTO mfh_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Azla Yahu­diya tawulà ala: “Asa à anu kà matsàh kà la akur kà sləray uwana kaɗahàŋ aw, ama kà uwana kapə̀h mawi­siga lakəl aŋa Zəzagəla: Tsa kak dza deyday kà pəra, kaga­gazləla gəl aŋak la Zəzagəla ma, məgoɗ.” ");
INSERT INTO mfh_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu awulà à atà ala: “Tatsetsèr à wakità mapəhay akul à abà kà, Zəzagəla agòɗ à akul azla­zəzagəla, ");
INSERT INTO mfh_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","məsəl la paraka kà, kà dza aslala vok aŋa mawisəŋ ala uwana matse­tse­rayga la wakità mapəhay la abà aw. Zəzagəla azal azla­zəzagəla azladza uwana takəs gay aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Gi kà, Zəzagəla akə̀sànì, aslə̀l gi à waŋ à gudəŋ uwanay à vok, ŋgaha ma kakay kagoɗaw kà, gəpə̀h mawi­siga à Zəzagəla à vok ma? Tsa gəpə̀hla dziriga kà gi Kona aŋa aŋha ma? ");
INSERT INTO mfh_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tsa baŋa sləray aŋa Baba gulo la uwana gəɗehəŋ, awkà kadiŋaw gi gəl à vok zlà ma aw. ");
INSERT INTO mfh_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ama baŋa sləray aŋha la uwana gəɗehəŋ kà, dìŋàw gi gəl à vok, kadiŋaw gi gəl à sləray gà uwana à vok tsi, kà akul aŋa masəl la paraka aw kà gi la Baba la abà, ŋgaha Baba babay la gi la abà.” ");
INSERT INTO mfh_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tatàhkà à makəsay gotənaŋ, ama atəf kà atà. ");
INSERT INTO mfh_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu adà aŋha à gay dərəv à uda aŋa mukwà Urdun, la slaka uwana Yuhana aɗahàhà batem uwarà. Ŋgaha adzà à ahəŋ la abatà. ");
INSERT INTO mfh_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Azladza aŋuvaw tasàh à slaka aŋha. Tagòɗ: “Ɗi­ki­ɗiki Yuhana kà, adaɗah nadzipo aw, ama uwana apə̀h lakəl aŋa dza uwanay kà agə̀ɗ à afik, ndzer.” ");
INSERT INTO mfh_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","La abatà azladza aŋuvaw tadìŋ gəl à masla à vok. ");
INSERT INTO mfh_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Dza anik la ahəŋ, sləm aŋha Lazar, agà la ɗuvats, adzà à ahəŋ la Be­ta­niya, la gudəŋ uwana Mari­yama atà la deda aŋha Marta tadzà à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Mari­yama uwaga kà mis uwana adzadzàɓ amàl matərsin à Sufəl Yesu à asik à gəl, asla­slaɗà, aŋàlal la aŋidz gəl aŋha) Deda aŋha Lazar la uwana agà la ɗuvats. ");
INSERT INTO mfh_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Azla­deda dəgamga səla uwaga taslə̀l gay à Yesu à tsəh, tagòɗal: “Sufəl, slawda aŋak kà la ɗuvats.” ");
INSERT INTO mfh_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Uwana Yesu atsənà uwaga, agòɗ: “Ɗuvats aŋa Lazar kà, ɗuvats mamamətsay aw, ama uwaga kà, kà mapəhla maslay aŋa Zəzagəla ala, uwaga la uwana adàpəhla mazləɓay aŋa Kona aŋha ala bay.” ");
INSERT INTO mfh_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu awoyà Marta atà la Mari­yama la Lazar deda aŋatà. ");
INSERT INTO mfh_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mok uwana atsənàŋ kà Lazar la ɗuvats kà, adzà à ahəŋ la slaka uwatà mavakay səla aya gotənaŋ. ");
INSERT INTO mfh_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","La lig la ahəŋ, agòɗ à azlaməna matapla la slaka aŋha: “Məwùl à kutso Yahu­diya!” ");
INSERT INTO mfh_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Azlaməna matapla la slaka aŋha tawulà ala: “Məŋga ada­safay aw, bà nekwa nekwa azladza tayàh matsàh ka à gəl la akur, ŋgaha asa à ka mawul à abatà aya ay?” ");
INSERT INTO mfh_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu agòɗ à atà: “Sa kulo gəl aŋha səla la ahəŋ la mavakay la tsəh aw takay? Kà uwana baŋa dza aday la afats, matekwiɗ atsalla aw, kà uwana anəŋa uɗaka aŋa gudəŋ à vok uwanay. ");
INSERT INTO mfh_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ama baŋa dza aday la vəɗ kà, matekwiɗ atsalla, kà uwana uɗaka la ahəŋ la masla la abà aw.” ");
INSERT INTO mfh_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu apə̀h à atà gay uwaga ŋgaha azà­tàlàŋ à gəl: “Slawda gami Lazar kà aga la madzehal gà, kà uwaga à uwana gəday aŋa mada­tsənəŋ ala.” ");
INSERT INTO mfh_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Azlaməna matapla tawulà à uda: “Sufəl, baŋa adzehal kà, adà­wurla, haɗay!” ");
INSERT INTO mfh_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ama Yesu kà asàl magoɗay kà Lazar kà adamətsay, ama azlaməna matapla la slaka aŋha tadzùgw lakəl aŋa madzehal deyday pəra. ");
INSERT INTO mfh_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kiya uwaga Yesu agòɗ à atà la paraka kà: “Lazar adamətsay. ");
INSERT INTO mfh_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Gi la marabay kà aŋkul, à kà uwana gi la abatà aw, ŋgaha kà akul aŋa madiŋ gi gəl à vok. Ama lagwa, məhad à slaka aŋha.” ");
INSERT INTO mfh_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kiya uwaga Tomas uwana tazalalla vəgal, agòɗ à azlaməna matapla anik: “Anu babay kà, məhàd kà mədàmətsay la məŋga gami.” ");
INSERT INTO mfh_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mok uwana Yesu adà à awtày kà, Lazar adaɗah mahənay ufaɗ la zəvay la aku. ");
INSERT INTO mfh_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Be­ta­niya kà nekwa la Uru­sa­lima, kərkər aŋha kà bokuba magur mahoyay pəlis tekula. ");
INSERT INTO mfh_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Azla Yahu­diya aŋuvaw tasàhà à waŋ à mtəga Marta atà la Mari­yama kà mamətsay aŋa deda aŋatà Lazar. ");
INSERT INTO mfh_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Uwana Marta atsənàŋ kà Yesu atsà à waŋ, ahàd kà matsəɗal à ama. Ama Mari­yama adzà à ahəŋ à mtəga. ");
INSERT INTO mfh_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta agòɗ à Yesu: “Sufəl, agayŋa kagay la abanay kà, naka deda gulo amətsay aw. ");
INSERT INTO mfh_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ama lagonay babay kà, tatak uwana kadà­navay à Zəzagəla gesina kà, adàvà à ka!” ");
INSERT INTO mfh_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu agòɗal: “Deda aŋak adà­ula à uda la sifa.” ");
INSERT INTO mfh_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta agòɗal: “Gəsəl adàwula à uda la mamətsay, la kaslà uwana azla­ma­zim­nekiɗ tadà­ula à uda la vuɗ makəɗ gəl à ahəŋ.” ");
INSERT INTO mfh_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu agòɗal: “Gi la uwana gi masla maula azladza à uda la mamətsay, ŋgaha la sifa, dza uwana adiŋ gi gəl à vok, adàdza à ahəŋ la sifa, amiyaka kà aməts, ");
INSERT INTO mfh_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ŋgaha dza uwana la sifa, ŋgaha adiŋ gi gəl à vok kà, adàmətsay ɗiki­ɗiki aw, kadiŋ gəl à uwaga à vok nəmay?” ");
INSERT INTO mfh_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Iyay Sufəl”, agòɗal, “Gədiŋal gəl à vok, kà kak Kristu, Kona aŋa Zəzagəla, uwana naka atsà à waŋ à gudəŋ à vok.” ");
INSERT INTO mfh_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mok uwana Marta adapəh gay uwaga, ahàd, azàla deda aŋha Mari­yama, agòɗal la gəl à gəl: “Məŋga gami kà, agà la abanay, ayàh ka, kà mad à awtày.” ");
INSERT INTO mfh_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mok uwana Mari­yama adatsən gay uwaga, asà à afik amərà vok kà mad à slaka Yesu. ");
INSERT INTO mfh_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Mok uwatà kà, Yesu kà, adabəz à huɗ gudəŋ à abà dadàŋ aw, alə̀g la slaka uwana tagagàm la Marta. ");
INSERT INTO mfh_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Uwana azla Yahu­diya, uwana atà la kay la slaka Mari­yama kà matabla gay à ahəŋ, tanəŋàŋ asà à uda la mamər vok kà, tanəfà à uda. Tadzùgw kà, adàla kà matuway à gəl zəvay tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mok uwana Mari­yama adabəz à slaka uwana Yesu kà agà la abatà, atə̀ɗ à makəla asik aŋha la makədeɗay, ŋgaha agòɗal: “Sufəl, à magay kagay la abanay kà, naka deda gulo kà amətsay aw.” ");
INSERT INTO mfh_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Uwana Yesu anəŋà, atuway la azla Yahu­diya uwana tasà à waŋ atà nna bay tataway, huɗ kut, ləv agòɗal kà uwaga. ");
INSERT INTO mfh_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Anàv atà: “Kalàw ma uwala?” Tagòɗal: “Sufəl, sà à waŋ, kanəŋa slaka uwana tallà à abà.” ");
INSERT INTO mfh_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu atùw. ");
INSERT INTO mfh_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kiya uwaga azla Yahu­diya tagòɗ: “Nə̀ŋàw mawoy masla aŋha tsi!” ");
INSERT INTO mfh_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ama azlaanik la tataka aŋatà la abà tagòɗ: “Masla uwana apo­kwàhà yewdi à azla­gu­ləf tak ma, kà mana asla kà maɗəɗ gay à mamətsay à Lazar la vok ala aw ma?” ");
INSERT INTO mfh_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Bà gotənaŋ kà, Yesu kà ləv aŋha adatəsl ala aw, ahàd à gəl zəvay. Uwaga kà tsakur, matsakal à ama gà la akur mabəlam bəlamga. ");
INSERT INTO mfh_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“Zə̀ɓàwwal abəlam la gay ala!”, Yesu agòɗ à atà. Marta, deda aŋa mazim­nekiɗ agòɗ: “Sufəl, azinay adagay, kà uwana adaɗah mahənay ufaɗ la aku.” ");
INSERT INTO mfh_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu agòɗal: “Gəpə̀h à ka aw takay, kà baŋa kadiŋal gəl à vok kà, kadà­nəŋəŋ mazləɓay Zəzagəla, gəgòɗ à ka aw ay?” ");
INSERT INTO mfh_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tazə̀ɓal abəlam la gay ala. Yesu anəŋà à zagəla la magoɗay: “Baba, kikay gəgoɗ à ka, kà uwana katsəɓ gi sləm. ");
INSERT INTO mfh_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Gəsəl kà kada­tsəɓ gi sləm koksi­koksi, ama uwana gəpəh uwanay kà, kà maham à ahəŋ dza uwanay tatsəɓ gi sləm lagwa, kà atà aŋa madiŋal gəl à vok, kà kak la uwana kaslə̀l gi à waŋ.” ");
INSERT INTO mfh_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mok uwana adapəh gay uwaga, awiyà la ndzəɗa: “Lazar, sà à lag la aku!” ");
INSERT INTO mfh_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mazim­nekiɗ asà à lag, azlaahàl la azlaasik aŋha matsafàɗ à ahəŋ à ahəŋ gà la gabaga, huɗ adi aŋha mafa­faɗal nalbət à adi gà. Yesu agòɗ à atà: “Pə̀làwwàŋ ala, ŋgaha sàkàwwal, adà aŋha.” ");
INSERT INTO mfh_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Aŋuvaw la tataka azla Yahu­diya uwana la abà tasà à waŋ à slaka Mari­yama, tanəŋà tatak uwana Yesu aɗahàŋ gesina, tadìŋ gəl à masla à vok. ");
INSERT INTO mfh_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ama azlaanik la tataka aŋatà la abà, tahàd à slaka azla Farisəya, tatùgw à atà uwana Yesu aɗahàŋ gesina. ");
INSERT INTO mfh_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kiya uwaga azla Farisəya la azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla la azlaməna makoray tahamà gay à vok kà matstsəzl vok gay, tagòɗ: “Mana məɗehəŋ la dza uwanay aɗàh azla­na­dzipo aŋuvaw mi? ");
INSERT INTO mfh_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Baŋa məsakal kiya uwanay, azladza gesina tadiŋ gəl à masla à vok, ŋgaha azla Rom bay tadàsa à waŋ, tadà­kalah anu məŋ gày Zəzagəla gami à ahəŋ la tsəhay gami.” ");
INSERT INTO mfh_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tekula la tataka aŋatà, uwana sləm aŋha Kayyif, uwana masla agà məŋ madza­haga la mavay uwatà la tsəh, agòɗ à atà: “Kasəlaw tatak aw! ");
INSERT INTO mfh_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kasəlaw kà ŋuləm dza tekula aməts kà gudəŋ gesina aŋa mazila aw takay?” ");
INSERT INTO mfh_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Apə̀h gay uwaga kà la masal aŋha aw, ama kà masla la uwana məŋ madza­haga la mavay uwatà la tsəh. Apə̀h à ahəŋ kà say Yesu amətsay, kà aŋa azla Yahu­diya, ");
INSERT INTO mfh_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kà aŋa tsəhay aŋatà pəra aw, ama bay kà maham gay azlabəza aŋa Zəzagəla uwana à vok, taslə̀h gəl à ahəŋ la uda gesina. ");
INSERT INTO mfh_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Dagay la vuɗ uwatà, azlaməŋga aŋa azla Yahu­diya tatsa­tsə̀l vok gay, kà makəs Yesu kà makəɗay. ");
INSERT INTO mfh_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kà uwaga à uwana Yesu auguzàh la dazu­waya, la tataka azla Yahu­diya la abà aya aw. Masla ahàd à gudəŋ anik à abà la fəta, uwana sləm aŋha Efərayim, adzà à ahəŋ la abatà la azlaməna matapla la slaka aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Madəvaday aŋa Paska aŋa azla Yahu­diya nekwa. Azladza gudəŋ anik anik aŋuvaw tadà à afik à Uru­sa­lima, kà uwana asà à atà matsi­kasl gəl ala ŋurayŋa mavakay madəvaday atsà à waŋ. ");
INSERT INTO mfh_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tayàh Yesu à mok, uwana atà la məŋ gày Zəzagəla la aku. Tanavà vok kà atà kà atà: “Mana kadzugwaw ma, adàsa à waŋ à madəvaday takay? Awma adàsa à waŋ aw ay?” ");
INSERT INTO mfh_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Uwana tapàh kiya uwaga kà, kà uwana azla­maz­da­haga aŋa azlaməna mav tatak la azla Farisəya tagòɗ kà: “Baŋa dza asəl slaka aŋha kà, apəhla ala kà maday makəsay”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Mahənay mukwa adà à lig kà, kà mas à waŋ aŋa madəvaday Paska, Yesu ahàd à gudəŋ Be­ta­niya, à slaka uwana Lazar adzà à ahəŋ, à Lazar uwana awulà à uda la mamətsay. ");
INSERT INTO mfh_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","La abatà tatà tatak may à Yesu. Lazar kà tekula la tataka azladza uwana la abà, tadzàh à tatak may à adi la Yesu. Marta la uwana atsàk à atà tatak may. ");
INSERT INTO mfh_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ŋgaha Mari­yama azə̀ɓ dərew amàl matərsin bəf la dərew gà matsi­ɗayga, azlà gay tenma aŋa litre. Tsa­kalay aŋha kà zla­zlaɗa. Adzadzàɓ à Yesu à asik à gəl, ŋgaha asla­slàɗàŋ ala la aŋidz gəl aŋha, kà uwana abàdal à asik à gəl. Uwaga kà taɗahaŋ kà la ahàf mazi­nayga. Mazinay aŋha azə̀ɓ gày à gəl. ");
INSERT INTO mfh_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tekula la tataka azlaməna matapla aŋha la abà à Yudas Iska­riyot, masla uwana ayah mat à kaf à Yesu à gəl agòɗ: ");
INSERT INTO mfh_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kà mana taduw matərsin uwanay ala kà aŋa sili gursu dadərmokw makər, kà mavàh sili gà à azlaməna kuɗa aw ma?” ");
INSERT INTO mfh_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Uwana apə̀h kiya uwaga kà, kà uwana awoyà azlaməna kuɗa magay aw, ama kà uwana masla kà masla gəl: Masla la uwana anə̀ŋla kiwa sili, ŋgaha aza­ɓà­hànì uwana tafàh à agu. ");
INSERT INTO mfh_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu agòɗal: “Sàkal, afà matərsin uwaga à ahəŋ kà aŋa vuɗ mal gi, ");
INSERT INTO mfh_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","akul, koksi­koksi kadàgaw la azlaməna kuɗa, ama gi kà, mədàday anina koksi­koksi aw.” ");
INSERT INTO mfh_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mok uwana maham à ahəŋ dza asə̀l kà Yesu kà aga la Be­ta­niya kà, azla Yahu­diya tahàd, ama kà gay aŋa Yesu pəra aw, ama bay kà, kà Lazar uwana Yesu awùlla à uda la mamətsay bay. ");
INSERT INTO mfh_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Azlaməŋga aŋa azlaməna mav tatak à Zəzagəla tatsənà vok gay kà makəɗ Lazar, ");
INSERT INTO mfh_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kà masla à uwana azla Yahu­diya aŋuvaw tasàk azlaməŋga aŋatà la tsəh ala kà madiŋal gəl à Yesu à vok. ");
INSERT INTO mfh_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","La bebəŋ gà, maham à ahəŋ dza, uwana tasà à waŋ à madəvaday Paska tatsənàŋ, kà Yesu atsà à Uru­sa­lima à abà. ");
INSERT INTO mfh_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kiya uwaga tasà à uda, taslàh baɓasl la azla­slahoy à vəɗah la tetəvi la ama, kà Yesu aŋa maday maguw à ahəŋ la afik, kà maga­gamay atà nna la mawiyay: “Mazləɓay agay la Zəzagəla, Zəzagəla apisa gay à dza uwana à vok, atsa à waŋ la sləm aŋa Sufəl. Zəzagəla apisa gay à Sufəl aŋa azla Isərayel à vok!” ");
INSERT INTO mfh_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu aɓə̀z à ziwŋŋu, adzà à afik la abatà, bokuba uwana wakità Zəzagəla apəh: ");
INSERT INTO mfh_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ˈAkul azladza Siyon, guba akəs akul aw, məŋ Sufəl aŋkul kà masla la uwana atsa à waŋ, adadza madzay la bəzi ziwŋŋu à afik.ˈ ");
INSERT INTO mfh_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Azlaməna matapla la slaka aŋha kà, tatsənà godega aŋa tatak uwaga dadàŋ aw, ama mok uwana Yesu adàɓəz à mazləɓay kà, awùl à atà à gəl uwana wakità Zəzagəla apəh lakəl aŋha kà uwaga dziriga, ŋgaha atà bay tagə̀ɗ à uwaga à afik uwana apə̀h gesina lakəl aŋha la sləray aŋatà gesina. ");
INSERT INTO mfh_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Maham à ahəŋ dza, uwana atà la abatà, à mok uwana Yesu awùlla Lazar à uda la mamətsay kà, tapə̀h lakəl aŋa uwana tanəŋàŋ gesina bay. ");
INSERT INTO mfh_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kà uwaga à uwana, maham à ahəŋ dza asà à waŋ kà maga­gamay la Yesu, kà uwana tasə̀l kà masla la uwana aɗahà nadzipo uwaga. ");
INSERT INTO mfh_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kiya uwaga azla Farisəya tagòɗ kà atà kà atà: “Nə̀ŋàwwàŋ zlà, kaslawwal à vok kà aŋa maɗàh tatak aya zlà aw, kà uwana azladza gesina kà tanəfay kà masla adagay.” ");
INSERT INTO mfh_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Azla Gərək anik la tataka aŋa azladza uwana la abà tasà à waŋ à Uru­sa­lima kà madəv kuɗa à Zəzagəla la madəvaday la abà kà, ");
INSERT INTO mfh_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","tazà vok à slaka Filip, uwana asà à waŋ la Be­tsayda, uwana la Galili, tagòɗal: “Kona, asa à anu manənəŋ Yesu.” ");
INSERT INTO mfh_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip ahàd, apə̀h à Andəre, ŋgaha tahàd à slaka Yesu, atà səla. ");
INSERT INTO mfh_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu agòɗ à atà: “Lagonay kà, kaslà adaslay adagay, à uwana Kona aŋa dza maɓəz à mazləɓay aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Haɗay, gəgoɗ à akul la dziriga: Fofulo hi tekula adza à ahəŋ bawtawta, à baŋa atəɗ à kutso à abà, baŋa akəl gay aw. Ama baŋa adakəl à gay, adàsa à uda kà, av mayyay aŋuvaw. ");
INSERT INTO mfh_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Dza uwana awoya sifa aŋha kà, adàziŋ ala. Ama dza uwana afa sləm à sifa aŋha la gudəŋ uwanay la vok aw kà, adàɓəl uwaga kà aŋa sifa adəv à gay aw. ");
INSERT INTO mfh_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Baŋa dza asal mazlak gi kà, say anəf à gi, kiya uwaga bay magamza gulo adàgay la slaka uwana gədàgay suwaŋ, Baba gulo adàzləɓ magamza uwana adazlak gi.” ");
INSERT INTO mfh_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesu agòɗ lagwa kà: “Baŋbabaŋ, ləv agoɗ à gi, kakay gəgoɗay lagwa mi? Baba tə̀f gi kà tatak uwana aɓəz à gi la kaslà uwanay? Ama kà aŋa uwaga la uwana gəsa à waŋ. ");
INSERT INTO mfh_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Baba và mazləɓay à sləm aŋak!” Kuda atsənà à ahəŋ la zagəla la afik agoɗ: “Gədazləɓay, ŋgaha gədàzləɓay aya gotənaŋ.” ");
INSERT INTO mfh_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Maham à ahəŋ dza uwana la abatà tatsənà kuda uwatà: “Uwatà kà masləh məl aŋa habaga”, tagòɗ. Azlaanik tagòɗ: “Malika aɓa­ɗalmà.” ");
INSERT INTO mfh_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ama Yesu apə̀h à atà la paraka: “Kuda uwaga atsənà à ahəŋ kà, kà aŋulo aw, ama kà aŋkul. ");
INSERT INTO mfh_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Lagonay kà, kaslà adaslay à uwana seriya aɗàh vok à gudəŋ à vok uwanay à gəl, lagonay la uwana takuɗək sufəl aŋa gudəŋ à vok uwanay adagay kà makələŋ à uda. ");
INSERT INTO mfh_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Gi, baŋa gədàda à afik la vəɗah kà, gədàbiy azladza gesina à slaka gulo.” ");
INSERT INTO mfh_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","La gay uwaga asàl mapəhla tsəhay mamətsay aŋha uwana ala adàmətsay. ");
INSERT INTO mfh_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Maham à ahəŋ dza agòɗal: “Mədzèŋ la wakità mapəhay gami la abà kà, Kristu adàdza à ahəŋ aŋa koksi­koksi. Ŋgaha ma, kakay kagoɗay, kà Kona aŋa dza adàday à zagəla ma? Uwa à Kona aŋa dza uwa?” ");
INSERT INTO mfh_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu agòɗ à atà: “Uɗaka kà aga la ahəŋ la tataka aŋkul dadàŋ, aŋa kaslà ŋuv. Nəfàw tetəvi dziriga la mok uwana akul la uɗaka la abà, kà mələs aŋa matsak à akul à ama aw, kà uwana dza uwana aday la mələs la abà kà, asəl slaka uwana ada à abà aw. ");
INSERT INTO mfh_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kiya uwaga kà, dìŋàwwal gəl à vok à mok uwana akul la uɗaka la abà, kà akul aŋa magay azladza aŋa uɗaka.” Uwana Yesu adapəh gay uwaga kà, adà aŋha la abatà, ahàɗ à atà vok à adi. ");
INSERT INTO mfh_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Amiyaka bà la azla­na­dzipo uwana aɗa­hàhàŋ, aŋuvaw la huma aŋatà babay kà, tadìŋal gəl à vok aw, ");
INSERT INTO mfh_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","kà magəɗ uwana à afik, masla mapəhal gay à ahàl Yesayya uwana agòɗ: ˈSufəl uwa adiŋ gəl à gay gami à vok uwa? A uwa à uwana Sufəl Zəzagəla apəhla maslay aŋha ala uwa?ˈ ");
INSERT INTO mfh_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Taslàla vok aŋa madiŋal gəl à vok aw kà uwana Yesayya agòɗ aya: ");
INSERT INTO mfh_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","ˈZəzagəla aguləfàh atà ala, ada­tsakah à atà haŋkəli à ama, kà yewdi aŋatà aŋa manəŋla aw, kà haŋkəli aŋatà aŋa masəl tatak aw. Ŋgaha kà atà aŋa magola vok à slaka gulo, kà gi aŋa mawur atà ala aya aw.ˈ Zəzagəla agòɗ. ");
INSERT INTO mfh_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesayya apə̀h uwaga kà, kà uwana anəŋà mazləɓay aŋa Yesu, à uwana apə̀h lakəl aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Aŋuvaw la tataka azlaməna gày zil aŋa azla Yahu­diya la abà, tadìŋ gəl à Yesu à vok, ama la dazu­waya aw, kà uwana guba akə̀s atà kà azla Farisəya aŋa makuɗəkàh atà à lag gày madəv kuɗa la aku. ");
INSERT INTO mfh_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kà uwana asà à atà kà azladza tazlə̀ɓ atà, à kà mazləɓ atà aŋa Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kiya uwaga Yesu azà kuda à zagəla la magoɗay: “Dza uwana adiŋ gi gəl à vok, adiŋ gəl kà à gi à vok pəra aw, ama à dza uwana à vok aslə̀l gi à waŋ babay. ");
INSERT INTO mfh_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ŋgaha dza uwana anəŋa gi, anəŋa dza uwana aslə̀l gi à waŋ babay. ");
INSERT INTO mfh_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Gi kà, gəsà à waŋ à gudəŋ à vok kà bokuba gi uɗaka, kəla dza uwana adiŋ gi gəl à vok kà, adz à ahəŋ la mələs la abà aw. ");
INSERT INTO mfh_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ama baŋa dza atsəna gay gulo, ŋgaha akəs aw kà, gi la uwana gədà­ɗahla ala seriya à gəl aw, kà uwana gəsà à waŋ kà aŋa maɓəl azladza gudəŋ à vok, awkà aŋa maɗàh seriya à gudəŋ à vok à gəl aw. ");
INSERT INTO mfh_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Dza uwana akweska gi, ŋgaha akəs gay uwana gəpəh aw kà, seriya la ahəŋ lakəl aŋha, gay uwana gəpə̀h la uwana adà­ɗahla ala seriya à gəl, la vuɗ madəv à gay gudəŋ à vok. ");
INSERT INTO mfh_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Gay uwanay gəpəhay kà la maslay aŋa aslasl gəl gulo aw, ama Baba uwana aslə̀l gi à waŋ kà, la gəl aŋha, la uwana avà à gi maslay kà gi aŋa mapəhay, aŋa matapla azladza. ");
INSERT INTO mfh_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Uwana apə̀h à gi, la uwana atsakakulla sifa adəv à gay aw à waŋ. Uwana gəpəhay kà, gəpəhay kà bokuba uwana Baba avà à gi maslay lakəl aŋha.” ");
INSERT INTO mfh_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Uwaga kà vuɗ maɗàh vok aŋa madəvaday Paska. Yesu asə̀l kà kaslà aŋha adaslay, kà maz vok aŋha la gudəŋ uwanay la vok, ŋgaha kà madiy aŋha à slaka Baba aŋha la zagəla. Koksi­koksi awoyàhà azlaməna aŋha uwana la gudəŋ la vok, adàwoya atà tsəràh à makəɗ gəl à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu la azlaməna matapla la slaka aŋha tazùw tatak may aŋa mokokhu. La mok uwaga kà, seteni ada­guway la ləv aŋa Yudas, kona aŋa Səmon Iska­riyot la tsəh, kà mat kaf à Yesu à gəl. ");
INSERT INTO mfh_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu asə̀l kà masla kà asà à waŋ kà la slaka Baba, ŋgaha awulay à abatà aya, kà uwana Zəzagəla Baba avàl maslay à ahàl gesina. ");
INSERT INTO mfh_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kiya uwaga Yesu atsìzlla ala la tatak may la adi, asərə̀t dawara aŋha la vok ala, azə̀ɓ gabaga aŋha, awàɗ à tsəh. ");
INSERT INTO mfh_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ŋgaha avə̀d iyaw à daraw à abà adzəkà mapa­làhla asik à azlaməna matapla la slaka aŋha, aɗahàh à atà iyaw la asik ala la gabaga, uwana awàɗ à tsəh. ");
INSERT INTO mfh_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mok uwana adabəz à slaka aŋa Səmon, Səmon Piyer agòɗal: “Sufəl, kak la uwana kapal gi asik, kagoɗ takay?” ");
INSERT INTO mfh_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu awulà ala la magoɗal: “Səmon Piyer, tatak uwana gəɗehəŋ lagonay kà, kasəl dadàŋ aw, ama la huma la gay la uwana kadàsəl godega aŋha.” ");
INSERT INTO mfh_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Səmon Piyer agòɗal: “Awaŋ Sufəl, kapal gi asik aw!” Yesu agòɗal: “Baŋa gəpala à asik aw, kadàɓəz à tatak la ahàl gulo aya aw.” ");
INSERT INTO mfh_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Səmon Piyer awulà ala: “Sufəl, tsa kità kà, kapal gi azlaasik pəra aw, ama pal gi azlaahàl gulo, la gəl gulo gesina!” ");
INSERT INTO mfh_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu agòɗal: “Dza uwana adapal vok gesina kà, anəkuɗa mapal vok aya aw, say azlaasik gà pəra, kà uwana vok aŋha kà kuze­kaka. Akul azla­ku­ze­kaka, ama akul gesina nəma aw.” ");
INSERT INTO mfh_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu kà asə̀l dza uwana adàtal kaf à gəl, kà uwaga à uwana agòɗ: “Akul azla­ku­ze­kaka gesina aw.” ");
INSERT INTO mfh_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","La lig aŋa uwaga la ahəŋ, à mok uwana ada­palàh à atà asik, Yesu awulà dawara aŋha à vok aya, ŋgaha adzà madzay la slaka aŋha la abà, agòɗ à atà: “Katsənaw godega aŋa uwaga gəda­ɗa­ha­kullaŋ takay? ");
INSERT INTO mfh_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Akul kazalawgəla məŋga, ŋgaha Sufəl, azlayla akul nəma, kà uwana gi masla haɗay. ");
INSERT INTO mfh_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Tsa baŋa gi la uwana gi Sufəl, ŋgaha məŋga kà, kà gəda­palàh à akul asik lagwa, akul babay kà, azlayla kà vok kà kapa­lahaw vok asik kà akul kà akul suwaŋ babay zlà. ");
INSERT INTO mfh_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Lagwa kà gədapəhakulla mafətsa à vok aŋha, à uwana kaɗa­hàwwàŋ bokuba uwana gəɗehə̀ŋ zlà, la slaka aŋkul. ");
INSERT INTO mfh_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Haɗay la dziriga gəpəh à akul: Masla sləray la ahəŋ, aɗuw məŋga aŋha aw, masləlay bay, aɗuw dza uwana asləl aw! ");
INSERT INTO mfh_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Lagonay kà, kasəlaw uwaga, kadàgaw la marabay à baŋa kakəsaw uwaga gesina.” ");
INSERT INTO mfh_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Gəpəhay kà lakəl aŋkul gesina aw, gəsəl azla­uwana gətsa­tsà­mànì atà. Ama say gay aŋa matse­tseray uwanay agəɗ à afik, dza uwanay məzuw tatak may anu səla, la uwana adà­guwgəla à lig à vok. ");
INSERT INTO mfh_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Dagay lagonay gəpə̀h à akul à vok à abà, kokuɗa mapak vok aŋa azla­tatak uwaga, ŋgaha kà baŋa azla­tatak uwaga adàpaka vok kà, akul aŋa masəlay kà gi uwana gi ndzer. ");
INSERT INTO mfh_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Gəpəh à akul la dziriga: Dza uwana akəs gi, akəs dza uwana aslə̀l gi à waŋ babay.” ");
INSERT INTO mfh_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","La mok uwana Yesu adapəh gay uwaga, aɓə̀k mazaw la gəl məŋga agòɗ: “Gəpəh à akul la dziriga kà: Tekula aŋkul adàta à gi kaf à gəl!” ");
INSERT INTO mfh_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Azlaməna masla matapla tanəŋà à vok à adi kà atà kà atà, tasə̀l dza uwana apəhay lakəl aŋha aw. ");
INSERT INTO mfh_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tekula aŋa azlaməna matapla uwana Yesu awoyàŋ kaykay, agà la makəla aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Səmon Piyer anavàl la yewdi, kà masla aŋa manavay à Yesu kà masəl dza uwana apəhay lakəl aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kiya uwaga, masla matapla ahùɓ à slaka Yesu kà manaval: “Sufəl uwa, uwatà uwa?” ");
INSERT INTO mfh_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu agòɗal: “Aganay gədəɓay alàl à kaf à gəl, dza uwana gədàvàl kà, masla gà la uwaga.” Kiya uwaga Yesu atsi­kànì kaf, adə̀ɓal à alàl à gəl, ŋgaha avà à Yudas, kona aŋa Səmon Iska­riyot. ");
INSERT INTO mfh_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mok uwana Yudas azə̀ɓ kaf uwaga kà, seteni adà à ləv aŋha à tsəh. Yesu agòɗal: “Uwana asa à ka maɗehəŋ kà, ɗahàŋ la katskats!” ");
INSERT INTO mfh_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","(Ama bà dza tekula la tataka aŋa azladza uwana la abà, tadzàh à tatak may à adi kà, dza la ahəŋ agòɗ: ‘Kà mana Yesu apə̀h kiya uwaga mi’, la ahəŋ aw. Kà uwana tatsənàŋ aw. ");
INSERT INTO mfh_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bokuba uwana: Kà uwana Yudas la uwana kiwa sili la ahàl kà, tadzùgw kà Yesu asal masləlay, kà masukw tatak aŋa madəvaday aya, tagòɗ. Baŋaw: ‘Và tatak à azlaməna kuɗa’, agoɗal, tagòɗ) ");
INSERT INTO mfh_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudas akə̀s kaf uwana atsəkallàŋ à ahàl, asà à uda katskats kà, adagay vəɗ. ");
INSERT INTO mfh_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Mok uwana Yudas adasa à uda kà, Yesu agòɗ: “Lagonay kà, mazləɓay aŋa kona aŋa dza apə̀hla vok ala, ŋgaha mazləɓay aŋa Zəzagəla adapəhla vok ala la masla la abà. ");
INSERT INTO mfh_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mazləɓay aŋa Zəzagəla apəhla vok ala la kona aŋa dza la abà, Zəzagəla bay adàpəhla mazləɓay uwana ala à Kona aŋa dza akor la gəl aŋha, aɗàh uwaga kà zwek bà lagwa. ");
INSERT INTO mfh_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Azlabəza gulo gi la ahəŋ la akul aŋa kaslà ŋuv pəra. Kadà­yahaw gi, ama gəpəh à akul bokuba uwana gəpəh à azla Yahu­diya aya: Kaslawwal à vok aŋa mad à slaka uwana gəday aw. ");
INSERT INTO mfh_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Gədàvà à akul mapəhay mawga: Wòyàw vok kà akul à akul, say kawoyaw vok kà akul à akul bokuba uwana gəwoyà akul. ");
INSERT INTO mfh_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Baŋa kawoyaw vok kà akul à akul kà, azladza gesina tadàsəlay kà, akul azlaməna matapla la slaka gulo, haɗay!” ");
INSERT INTO mfh_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Səmon Piyer anavàl à gay la: “Sufəl kaday ma à uwala?” Yesu awulà ala: “Kaslala vok aŋa manəf gi à slaka uwana gəday lagonay aw. Ama bawbaw kà, kadànəf gi.” ");
INSERT INTO mfh_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piyer agòɗal: “Sufəl, kà mana gəslay kà manəf ka lagonay aw ma? Gi, gədàɗah vok, kà mav sifa gulo kà aŋak!” ");
INSERT INTO mfh_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu agòɗal: “Ndzer, kà kak kadàɗah vok aŋa mav sifa aŋak kà aŋulo ay? Gəpəh à ka la dziriga kà, gurayŋa mew­g­dza­galaŋ awiyay kà asik makər, kadà­goɗay asik makər, kà kasəl gi aw!” ");
INSERT INTO mfh_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Kazamaw la gəl aw”, Yesu agòɗ à atà, “Dìŋàw gəl à Zəzagəla à vok, ŋgaha dìŋàw gi gəl à vok bay. ");
INSERT INTO mfh_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Slaka madz à ahəŋ aŋuvaw la mtəga Baba gulo, gəday gədà­ɗa­ha­kulla slaka à ahəŋ. Agayŋa haɗay awkà, naka gəpəh à akul aw. ");
INSERT INTO mfh_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ŋgaha baŋa gədaday gəda­ɗa­ha­kulla slaka à ahəŋ, kà gədàwula à waŋ, kà gi aŋa mahəl akul à slaka gulo, kà akul aŋa magay la slaka uwana gi la abà. ");
INSERT INTO mfh_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Akul kà, kasəlaw tetəvi mad à slaka uwana gəday.” ");
INSERT INTO mfh_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas agòɗal: “Sufəl, məsəl slaka uwana kaday aw. Kakay məslala vok aŋa masəl tetəvi ma?” ");
INSERT INTO mfh_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu awulà ala: “Gi tetəvi, gi dziriga, gi sifa. Dza aslala vok aŋa mad à slaka Baba la tetəvi anik, kokuɗa maguway la slaka gulo aw. ");
INSERT INTO mfh_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Baŋa kasəlaw gi kà, kasəlaw Baba gulo babay. Dagay lagonay kà, kasəlaw masla, ŋgaha kanəŋawwaŋ babay.” ");
INSERT INTO mfh_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip agòɗal: “Sufəl, pə̀hanula Baba, uwaga kà diga zlà.” ");
INSERT INTO mfh_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu agòɗal: “Mədadza à ahəŋ kà məŋga anina kà, bà pəra kà, kasəl gi aw uwa, Filip? Dza uwana anəŋà gi kà, anəŋà Baba gulo babay, ŋgaha ma kakay kagoɗay pə̀hanula Baba ma? ");
INSERT INTO mfh_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kadiŋal gəl à vok, kà gi la Baba la abà, Baba la gi la abà aw uwa? Gay uwanay gəpəh à akul gesina kà, atsa à waŋ kà la slaka gulo aw, ama la slaka Baba gulo. Baba uwana adza à ahəŋ la gi la abà la uwana ahən sləray aŋha ala. ");
INSERT INTO mfh_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Dìŋàw gi gəl à vok à uwana gəgoɗ: Gi la Baba la abà, Baba bay la gi la abà. Baŋa kadi­ŋawwal gəl à gay uwaga à vok aw kà, dìŋàw gəl à abà à sləray gà uwana à vok tsi! ");
INSERT INTO mfh_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","La dziriga gəpəh à akul: Dza uwana adiŋ gi gəl à vok, adàɗah azlasləray uwana gəda­ɗe­həŋ suwaŋ. Adàɗah sləray uwana aɗuwa uwanay, kà uwana gi gədaà à slaka Baba gulo. ");
INSERT INTO mfh_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Dèwdèw tatak uwana kadà­navaw la sləm gulo kà, gədàvà à akul uwaga gesina, kà Kona aŋa mapəhla mazləɓay aŋa Baba aŋha ala. ");
INSERT INTO mfh_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Baŋa kanavaw tatak la sləm gulo kà, gədàvà à akul uwaga.” ");
INSERT INTO mfh_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesu agòɗ: “Aŋa kawoyaw gi kà, naka kakəsaw mapəhay gulo. ");
INSERT INTO mfh_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Gədàdəv kuɗa à Baba, kà masla aŋa masləl à akul masla mazlak akul anik à waŋ kà, Masasəɗok dziriga, kà masla aŋa magay la akul koksi­koksi. ");
INSERT INTO mfh_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Gudəŋ à vok kà aslala vok aŋa maɓəzal aw, kà uwana aslala vok aŋa manəŋəŋ la masəlay aw. Ama akul kà kasəlaw masla, kà uwana adagay la akul ŋgaha adàdza à ahəŋ la akul la abà.” ");
INSERT INTO mfh_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Gədàsak akul à ahəŋ la matawaŋ la abà aw, gədàwula à waŋ à slaka aŋkul. ");
INSERT INTO mfh_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","La kaslà ŋuv la abà, gudəŋ à vok adànəŋ gi aw, ama akul kà, kadànəŋaw gi, kà uwana gi la sifa, akul babay la sifa. ");
INSERT INTO mfh_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Baŋa mavakay uwatà adàsa à waŋ kà, la mok uwatà la uwana kadàsəlaw kà gi la Baba la abà, ŋgaha kà Baba bay la gi la abà, ŋgaha gi bay la akul la abà.” ");
INSERT INTO mfh_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Dza uwana akəs mapəhay gulo, ŋgaha anəŋla uwaga kà, masla mawoya gi zlà. Baba gulo adàwoy dza uwana awoya gi babay, gədàwoya masla, gədà­pəhalla vok.” ");
INSERT INTO mfh_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yahuda (awkà Yudas Iska­riyot aw), agòɗal: “Sufəl, kakay uwaga aɗàh vok, kà kapəhanula vok kà anu pəra, awkà à gudəŋ à vok aw ma?” ");
INSERT INTO mfh_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu awulàl ala, agòɗal: “Dza uwana awoya gi akəs mapəhay gulo kà, Baba gulo adà­wo­yəŋ, anu la Baba gulo mədàduw à awtày à slaka aŋha, mədàdza à ahəŋ la mtəga aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Dza uwana awoya gi aw kà, akəs mapəhay gulo aw. Uwana katsənaw gi gəpahay kà, uwaga kà asa à waŋ kà la slaka gulo aw, ama asa à waŋ kà la slaka Baba gulo uwana asləl gi à waŋ.” ");
INSERT INTO mfh_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Gədapəh à akul uwaga dagay uwarà, à mok uwana məga anina. ");
INSERT INTO mfh_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Masla mazlak akul, à Masasəɗok tsi­kasla uwana Baba adàsləl à akul à waŋ, la sləm gulo kà, masla la uwana adà­ta­pahakulla tatak gesina, ŋgaha adà­wula à akul à gəl uwana gədapàha à akul gesina aya.” ");
INSERT INTO mfh_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Gəsak à akul ala lapiya à ahəŋ, gəvà à akul lapiya gulo. Gəvà à akul kà bokuba uwana gudəŋ à vok avà à akul aw. Kazamawla gəl aw, guba akəs akul babay aya aw. ");
INSERT INTO mfh_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Katsənàw uwana gəgòɗ à akul kà, gədiy aŋulo. Ama gədàwula à waŋ à slaka aŋkul. Agayŋa kawoyaw gi kà, naka karabaw à kà uwana gəda à slaka Baba gulo, gəgoɗ à akul, kà uwana Baba la uwana məŋga kà gi. ");
INSERT INTO mfh_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Lagonay kà, gədapəhakulla vok à abà, kokuɗa mapak vok aŋa azla­tatak uwaga, kà mok uwana adà­zla­ŋalay kà, kadà­di­ŋawwal gəl à vok. ");
INSERT INTO mfh_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Gəslala vok aŋa maɓaɗma məŋga anina aya aw, kà uwana sufəl aŋa gudəŋ à vok uwanay kà nekwa atsa à waŋ. Maslay aŋha la ahəŋ bà ŋuv lakəl gulo aw. ");
INSERT INTO mfh_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ama say gudəŋ à vok asəlay, kà gəwoya Baba kəla, ŋgaha gədza à ahəŋ kiya uwana asa à Baba. Sàw à afik məda aŋami la abanay lagwa!” ");
INSERT INTO mfh_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu agòɗ aya: “Gi la uwana gi matavəruk dziriga, Baba gulo kà dza aŋa guf matavəruk. ");
INSERT INTO mfh_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kəla ahàl matavəruk uwana av mayyay aw kà, asləh gi à vok ala. Ŋgaha kəla ahàl uwana av mayyay kà adà­deslay, kà aŋa mav mayyay məŋga aya. ");
INSERT INTO mfh_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kà matapla uwanay gəda­tapaakullla kà, kadàgaw mada­de­slayga. ");
INSERT INTO mfh_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nə̀ɓàw vok la gi, bokuba uwana gi la manəɓ vok gà la akul. Ahàl matavəruk aslala vok aŋa mav mayyay la aslasl gəl aŋha aw, say agay manəɓ vok gà, à iyà gà à vok. Kiya uwaga babay kaslawwal à vok aŋa madz à ahəŋ kokuɗa gəl aŋkul aw, say baŋa kanəɓaw gi vok à vok.” ");
INSERT INTO mfh_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Gi la uwana gi matavəruk iyà gà, akul kà akul azla­ma­zləzl vok gà. Dza uwana adza à ahəŋ la gi la abà, iyaw gulo akəlay la masla la abà, masla adàvà mayyay aŋuvaw, kà uwana kaslawwalla vok aŋa maɗàh tatak la kokuɗa gi aw. ");
INSERT INTO mfh_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Dza uwana adza à ahəŋ manəɓ vok gà la gi aw kà, taduw à uda la guf la abà, bokuba ahàl matavəruk makəɗəval à vok ala gà, agula la abatà, tatsa­tsamay kà maɓəkay à akàl à gay, ŋgaha akàl aɓaɗ à gay leɗɗa. ");
INSERT INTO mfh_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Baŋa kadànəɓaw vok la gi, ŋgaha bay gay gulo adànəɓ vok la akul la abà, nàvàw uwana asa à akul gesina, kadà­ɓəzawwal. ");
INSERT INTO mfh_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Baŋa kavàw mayyay aŋuvaw, kadàgaw azlaməna matapla la slaka gulo. La uwaga la uwana mazləɓay aŋa Baba gulo adàpəhla vok ala la slaka azladza. ");
INSERT INTO mfh_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Gəwoya akul la ləv tekula, bokuba uwana Baba gulo awoya gi. Dzàw à ahəŋ la masal gulo la abà. ");
INSERT INTO mfh_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Baŋa kakəsaw mapəhay gulo kà, kadàdzaw à ahəŋ la masal gulo la abà, kalkal bokuba uwana gəkəsàŋ mapəhay aŋa Baba gulo, ŋgaha gədzà à ahəŋ la masal aŋha la abà babay.” ");
INSERT INTO mfh_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Gəpəh à akul uwaga kà, kà marabay gulo aŋa magay la akul la abà, ŋgaha marabay aŋkul babay aŋa magay mahənlaga. ");
INSERT INTO mfh_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Aganay mapəhay gulo: Wòyàw vok kà akul à akul, bokuba uwana gəwoya akul bay. ");
INSERT INTO mfh_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Masal la ahəŋ aɗuw aŋa dza, uwana av sifa aŋha kà aŋa azla­slawda aŋha aw. ");
INSERT INTO mfh_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Akul azla­slawda gulo, à baŋa kaɗahaw uwana ‘Ɗa­hàwwàŋ’, gəgoɗ à akul gesina. ");
INSERT INTO mfh_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Dagay lakana kà, gədàzala akul ala azla­ma­gamza aya aw, kà uwana magamza kà asəl tatak uwana məŋga aŋha aɗehəŋ aw. Ama gədà­zalla akul ala azla­slawda, kà uwana tatak uwana gətàpla la slaka Baba kà, gədatap à akul ala babay suwaŋ. ");
INSERT INTO mfh_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Akul la uwana kakə̀sàwnì gi aw, ama gi la uwana gəkə̀sànì akul, gəɓə̀k akul à ahəŋ kà kadaw aŋa mav mayyay, ŋgaha mayyay uwaga ada­safay aŋa koksi­koksi. Kiya uwaga Baba adàvà à akul dèwdèw tatak uwana kadà­navaw la sləm gulo. ");
INSERT INTO mfh_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Gay uwana gəpəh à akul à vok à abà lagwa, say kawoyaw vok kà akul à akul.” ");
INSERT INTO mfh_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Baŋa gudəŋ à vok azinakulla vok ala kà, sə̀làw kà atsà vok à mazin gi vok ala dadàŋ teraŋa. ");
INSERT INTO mfh_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Agay kagaw azlaaŋa gudəŋ à vok kà, naka gudəŋ à vok awoya akul kà uwana akul azlaaŋha. Ama gətsa­tsà­mànì akul, gəhə̀l akul à uda la abà, lagonay kà, akul azlaaŋa gudəŋ à vok aya aw, kà uwaga à uwana gudəŋ à vok azinakullla vok ala. ");
INSERT INTO mfh_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Awula à akul à gəl, à uwana gəpə̀h à akul uwarà kà, magamza aɗuwa məŋga aŋha aw. Baŋa tatərə̀ɓ gi kà, tadàtərərɓah akul bay, ama baŋa takəs mapəhay gulo kà, tadàkas mapəhay aŋkul babay. ");
INSERT INTO mfh_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ama tadà­ɗaha­kulla uwaga à vok gesina kà, kà ahàl gulo, kà uwaga à uwana tasəl dza uwana asləl gi à waŋ aw. ");
INSERT INTO mfh_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Agayŋa gətsà à waŋ kà aŋa mapəh à atà aw, kà naka tsakana aŋatà atə̀ɗ à atà à gəl aw. Ama lagwa kà haŋay lakəl aŋa tsakana aŋatà la ahəŋ aya aw. ");
INSERT INTO mfh_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Dza uwana azin gi vok ala kà, azina vok à Baba gulo ala bay. ");
INSERT INTO mfh_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Agayŋa gəɗàh azla­tatak nadzipo gà uwana dza aɗahəŋ aw aw, kà naka tsakana atəɗ à atà à gəl aw. Ama tsa gəda­ɗahah azla­na­dzipo uwaga kà, ŋgaha bà gotənaŋ kà, tazinan vok ala la Baba gulo. ");
INSERT INTO mfh_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ama uwaga apakà vok kà, kà magəɗ uwana à afik tatsetsèr à wakità mapəhay à abà: ˈTa­da­zingəŋ vok ala kà kiga pəra.ˈ” Yesu agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Yesu agòɗ à atà aya: “Baŋa masla mazlak akul adàsa à waŋ, masla la uwana Masasəɗok dziriga, uwana adàguwa à waŋ la slaka Baba gulo, gədà­sləl à akul à ahəŋ à baŋa gədada à slaka Baba gulo. Masasəɗok uwaga adàza sayda lakəl gulo. ");
INSERT INTO mfh_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ŋgaha akul bay kadàzaw sayda gulo, kà uwana kagaw la gi dagay la madzəka.” ");
INSERT INTO mfh_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Gəpəh à akul uwaga kà, kà akul aŋa masak madiŋal gəl à vok aw. ");
INSERT INTO mfh_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tadà­kuɗəkah akul à lag la gày madəv kuɗa aŋa azla Yahu­diya la aku. Kaslà adàsa à waŋ à uwana azladza uwana tadà­kaɗah akul, tadà­goɗay kà: ‘Sləray uwana məɗehəŋ kà, akəs à Zəzagəla à gəl.’ ");
INSERT INTO mfh_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Taɗàh uwaga kà, kà uwana tasəl Baba aw, ŋgaha tasəl gi babay aw. ");
INSERT INTO mfh_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ama gəpəh à akul uwanay kà, kà akul aŋa madzugway lakəl aŋha, kà baŋa adapaka vok kà, kà aŋa mawul à akul à gəl.” “Uwana gəpəh à akul uwaga dagay madzəka aw kà, kà uwana gi la tataka akul la abà. ");
INSERT INTO mfh_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Lagonay kà, gəda à slaka dza uwana aslə̀l gi à waŋ, ama dza la ahəŋ ‘Kad à uwali’, agoɗ à gi la tataka aŋkul la abà, amiyaka tekula aw. ");
INSERT INTO mfh_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ama mazaw la gəl adakəs akul kà uwana gəpə̀h à akul uwaga. ");
INSERT INTO mfh_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ama gəpəh à akul la dziriga kà, aŋkul kà ŋuləm gəda aŋulo, kà uwana baŋa gədà aŋulo aw kà, masla mazlak akul atsa à ahəŋ à slaka aŋkul aw. Ama baŋa gi gəda aŋulo kà, gədà­sləl à akul à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Masla kà, baŋa adàsa à ahəŋ kà, adàpəhla à azladza gudəŋ à vok madzugway mawi­siga aŋatà, lakəl aŋa tsakana, lakəl aŋa dziriga, ŋgaha lakəl aŋa seriya aŋa Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tadà­vavar gəl aŋatà lakəl aŋa tsakana, kà uwana tadiŋ gi gəl à vok aw, ");
INSERT INTO mfh_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","tavavar gəl aŋatà lakəl aŋa tatak dziriga, kà uwana gədà à slaka Baba gulo, ŋgaha kà, kadànəŋaw gi aya aw. ");
INSERT INTO mfh_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Lakəl aŋa seriya babay kà, kà uwana sufəl aŋa gudəŋ à vok uwanay kà seriya adàkəsay.” ");
INSERT INTO mfh_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Gi la azlagay aŋuvaw kà mapəh à akul, ama kaslawwalla vok aŋa makəsiŋ dadàŋ aw. ");
INSERT INTO mfh_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mok uwana Masasəɗok dziriga adà­zla­ŋalay kà, adàdala akul la dziriga la abà gesina, kà uwana adàpəhay kà lakəl aŋa maslay aŋa gəl aŋha aw, ama adàpəhay kà lakəl aŋa uwana atsənàŋ, ŋgaha lakəl aŋa azla­tatak uwana atsa à waŋ la huma la gay. ");
INSERT INTO mfh_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Masla adàpəhla mazləɓay gulo ala, kiya uwana atsənàŋ la slaka gulo, la uwana adà­za­kulaŋ. ");
INSERT INTO mfh_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kəla tatak uwana Baba akoray kà uwaga aŋulo, kà uwaga à uwana gəgoɗ à akul kà, Masasəɗok Zəzagəla adà­wula à akul tatak uwana aɓə̀zal la slaka gulo.” ");
INSERT INTO mfh_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesu agòɗ à atà: “Aŋa kaslà ŋuv kadànəŋaw gi aya aw, ama zwek la huma la gay ŋuv kadànəŋaw gi aya.” ");
INSERT INTO mfh_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kiya uwaga azlaanik la tataka azlaməna matapla la slaka aŋha, tanà­vàhà à vok kà atà kà atà: “Uwaga ma, mana asal magoɗay ma? Agòɗ à anu kà: ‘Aŋa kaslà ŋuv kà mədà­nəŋəŋ gi aw, ama zwek la huma la gay aya kà mədà­nəŋəŋ gi aya, ŋgaha babay gəda à slaka Baba’, agòɗ aya. ");
INSERT INTO mfh_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Mana asal magoɗay kaslà ŋuv ma? Mətsənà uwana asal mapəhay aw.” ");
INSERT INTO mfh_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu asə̀l kà asa à atà manaval. Kiya uwaga agòɗ à atà: “Asafay à uwana gəpəh à akul uwaga aw, zwek la huma la gay kadànəŋaw gi aw, la lig la ahəŋ ŋuv kadànəŋaw gi aya. Lakəl ma aŋa uwaga à uwana kana­vahaw vok takay? ");
INSERT INTO mfh_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Gəpəh à akul la dziriga: Katawaw, katsa­hahaw hulolo, ama gudəŋ à vok adà­rabay, kadà­zamawla gəl, ama mazaw la gəl aŋkul kà, adàpaka marabay. ");
INSERT INTO mfh_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Baŋa mis azlà asekw à ahəŋ kà, mazaw gəl adal à vok, kà uwana kaslà matərəɓay aŋha adaslay, ama baŋa adasekw à ahəŋ kà, matərəɓay avikaŋ, kà uwana marabay kà uwana adayyi bəzi. ");
INSERT INTO mfh_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kiya uwaga babay, akul la mazaw la gəl la abà la kaslà uwanay, ama gədànəŋ akul aya, ŋgaha ləv aŋkul adà­rabay. Dza la ahəŋ aslala vok kà mazəɓa­kulla marabay ala tetuwa aw.” ");
INSERT INTO mfh_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Baŋa mavakay uwatà adasa à waŋ kà, kadà­navaw gi tatak la sləm gulo aya aw. Gəpəh à akul la dziriga: Kəla tatak uwana kanavaw la sləm gulo kà, Baba adàvà à akul uwaga gesina. ");
INSERT INTO mfh_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tsəràh à lakana dadàŋ kà, kada­navaw tatak la sləm gulo aw. Nàvàw ŋgaha kaɓəzawwal, ŋgaha kà marabay aŋkul aŋa mahənla.” ");
INSERT INTO mfh_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Gəpəh à akul azla­tatak uwaga gesina kà la gay la gay la abà, ama kaslà atsa à waŋ à uwana gədàpəh à akul kà la gay la gay la abà aya aw. Gədàpəh à akul kà la dazu­waya lakəl aŋa Baba gulo. ");
INSERT INTO mfh_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Baŋa mavakay uwaga adaslay kà, gədàdəv kuɗa à Baba kà aŋkul, gəgoɗ magay aw. ");
INSERT INTO mfh_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kà uwana Baba la gəl aŋha awoya akul. Awoya akul kà, kà uwana kawoyaw gi, kà uwana kadi­ŋawwal gəl à vok, kà gəsa à waŋ la slaka aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Gəsà à waŋ à gudəŋ à vok kà, gəsà à ahəŋ kà la slaka Baba. Lagwa kà, gəda à slaka Baba, gəsak à gudəŋ à vok à ahəŋ.” ");
INSERT INTO mfh_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Azlaməna matapla la slaka aŋha tagòɗal: “Lagonay kà, kapəhay la dazu­waya, kokuɗa la gay la gay la abà zlà. ");
INSERT INTO mfh_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Lagwa kà, mədasəlay kà kasəl tatak gesina, ŋgaha kanəkuɗa kà dza aŋa manav à ka tatak aw. Mədiŋal gəl à vok kà ndzer, kasà à ahəŋ kà la slaka Baba Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu agòɗ à atà: “Kadi­ŋawwal gəl à vok adagay lagwa ay? ");
INSERT INTO mfh_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kaslà adàsa à waŋ, lagwa kà adasa à waŋ, uwana kadàsləhaw gəl à ahəŋ uwa­be­yuwi adàdiŋ aŋha à mtəga aŋha, kadà­sakaw gi à ahəŋ kokuɗa gulo. Ama la dziri kà, gi kokuɗa gulo aw, kà uwana anu la Baba gulo. ");
INSERT INTO mfh_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Uwana gəpəh à akul uwaga gesina kà, kà akul aŋa magay la lapiya la maham gay à vok la abà la gi. Akul kà, kadàsaw ŋgərpa la gudəŋ la vok, ama kurit yewdi, agoɗ à akul aw! Kà uwana gəda­kəɗaslla gudəŋ à vok.” ");
INSERT INTO mfh_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Mok uwana Yesu adapəh gay uwaga à gay gesina kà, anəŋà à zagəla, agòɗ: “Baba, kaslà kà adaslay. Pə̀hla mazləɓay aŋa Kona aŋak ala, ŋgaha Kona aŋak apəhla mazləɓay aŋak ala suwaŋ, ");
INSERT INTO mfh_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","kà uwana kavàl maslay lakəl aŋa azladza gesina la vəɗah, kà masla aŋa mav sifa adəv à gay aw à azladza uwana kaɓə̀kal atà gesina. ");
INSERT INTO mfh_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Sifa adəv à gay aw kà, kà aŋa azla­uwana tasəl ka pəra, à kak Zəzagəla dziriga gà, ŋgaha kà masəlay Yesu Kristu uwana kaslə̀l à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Gədapəhla mazləɓay aŋak ala la vəɗah, gəda­dəvəŋ à gay sləray uwana kaf à gi à ahàl kà maɗehəŋ. ");
INSERT INTO mfh_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Lagwa zlà kà, Baba kà, và à gi mazləɓay uwana gəgà la masla la huma aŋak mok uwana gudəŋ à vok aləg madzəka dàŋ zlà.” ");
INSERT INTO mfh_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Baba, azladza uwana kaɓə̀k à gi, atà la gudəŋ uwanay la vok kà, gədàpəhatàla kak, kà uwana atà tagay azlaaŋak, ŋgaha kaɓə̀k à gi atà, lagwa kà, atà takə̀s gay aŋak. ");
INSERT INTO mfh_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Lagwa kà dèwdèw tatak uwana kavà à gi kà, tasə̀l kà, atsà à ahəŋ la slaka aŋak. ");
INSERT INTO mfh_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kà uwana gəpə̀h à atà ala gay uwana kapə̀h à gi à ahàl kà mapəh à atà, takə̀s, tasə̀l ndzer kà gəsà à waŋ la slaka aŋak, ŋgaha kà kak la uwana kaslə̀l gi à waŋ.” ");
INSERT INTO mfh_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Baba gədəv à ka kuɗa kà aŋatà. Awkà gədəv kuɗa kà gudəŋ à vok aw, ama kà aŋa azla­uwana kaɓə̀k à gi atà à ahàl, kà uwana azlaaŋak. ");
INSERT INTO mfh_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Dèwdèw tatak uwana aŋak kà aŋulo, dèwdèw tatak uwana aŋulo bay kà, uwaga kà aŋak, kà uwaga à uwana mazləɓay gulo apəhla vok ala la azla­tatak uwaga la abà gesina. ");
INSERT INTO mfh_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Gi kà, gi la gudəŋ la vok aya aw, ama atà kà, atà la gudəŋ la vok. Gi kà gəda à slaka aŋak Baba tsi­kasla, nə̀ŋla atà la ndzəɗa aŋa sləm aŋak uwana kavà à gi, kà atà aŋa magay tekula, bokuba uwana məgaw tekula anu səla. ");
INSERT INTO mfh_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mok uwana gi la slaka aŋatà gəfà à atà sləm la maslay aŋa sləm aŋak, sləm uwana kavà à gi. Gənə̀ŋla atà, amiyaka tekula aŋatà bay kà, azàla aw. Say dza uwana naka azilà, wakità agòɗ kà magəɗ uwana à afik, wakità agòɗ pəra. ");
INSERT INTO mfh_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ama lagonay kà, gəda à slaka aŋak, à uwana gəpəh kiya uwanay kà, kà uwana gələg la gudəŋ la vok dadàŋ, kà atà aŋa maɓəzal marabay gulo la huɗ aŋatà, marabay uwana mahənlaga. ");
INSERT INTO mfh_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Gi, gəvà à atà gay aŋak, ŋgaha gudəŋ à vok azin atà vok ala, kà uwana azlaaŋa gudəŋ à vok aw, bokuba gi uwana gi aŋa gudəŋ à vok bay aw. ");
INSERT INTO mfh_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Gədəv à ka kuɗa kà mahəl atà à uda la gudəŋ la vok aw, ama aŋa manəŋla atà kà mawi­siga. ");
INSERT INTO mfh_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Atà kà azlaaŋa gudəŋ à vok aw, bokuba gi, uwana gi aŋa gudəŋ à vok aw. ");
INSERT INTO mfh_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pàk atà ala kà azlaaŋak, gay aŋak kà dziriga pəra. ");
INSERT INTO mfh_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Gi gəda­sləl atà à gudəŋ à vok, bokuba uwana kaslə̀l gi à ahəŋ à gudəŋ à vok. ");
INSERT INTO mfh_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Gəvà à ka sifa gulo gesina kà aŋatà, kà atà babay aŋa magay azlaaŋak la dziriga.” ");
INSERT INTO mfh_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Gədəv kuɗa kà, kà aŋatà pəra aw, ama kà aŋa azla­uwana tadàdiŋ gi gəl à vok, à kapə̀hla ala aŋatà bawbaw bay.” ");
INSERT INTO mfh_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","“Gədəv kuɗa kà atà gesina aŋa magay tekula. Baba, tagay tekula la anu bokuba kak la gi babay anu tekula pəra, gudəŋ à vok aŋa masəlay kà kak kaslə̀l gi à waŋ. ");
INSERT INTO mfh_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Baba gəvà à atà mazləɓay uwana kavà à gi, kà atà aŋa tagay tekula bokuba anu səla uwana anu tekula. ");
INSERT INTO mfh_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Gəgay la atà la abà, ŋgaha kak babay məgaw anu səla, kà magay tekula la slaka gà. Ŋgaha gudəŋ à vok aŋa masəlay kà kak la uwana kasləl gi à ahəŋ haɗay, ŋgaha kà kak kawoya atà bokuba uwana kawoya gi.” ");
INSERT INTO mfh_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Baba, kak kavà à gi atà, asa à gi kà atà tagay la slaka uwana gədàgay, ŋgaha kà atà aŋa manəŋ mazləɓay gulo, uwana kavà à gi, kà uwana kawoya gi dagay uwana kaləg maɗàh gudəŋ à vok. ");
INSERT INTO mfh_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Baba dziriga, gudəŋ à vok asəl ka aw, ama gi kà gəsəl ka, ŋgaha azla­uwana babay kà tasəl ka kà kak la uwana kaslə̀l gi à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Lagwa gəpə̀hatàla kak, ŋgaha gədàpəhatàla kak aya, kà masal aŋak uwana kawoya gi aŋa magay la atà babay, ŋgaha gi babay aŋa magay la atà.” ");
INSERT INTO mfh_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Kiya uwaga mok uwana Yesu adadəv madəv kuɗa à gay kà, ahàd la azlaməna matapla la slaka aŋha à gay dərəv à uda anik aŋa mukwà Kidəron. La abatà kà, gày alàl la ahəŋ adà à abà la azlaməna matapla la slaka aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudas masla matal kaf à Yesu à gəl babay kà, asəl slaka uwatà, kà uwana Yesu adàha à abatà kwà à kwà la azlaməna matapla la slaka aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yudas zlà, ahàd à gày alàl à abà la maham à ahəŋ slodzi, la azlaməna manəŋla gày Zəzagəla la tsəh. Azladza uwaga kà azla­ma­dza­haga aŋa mav tatak la azla Farisəya la uwana taɓə̀kal à tsəh, tahə̀l fənəs la matəvani à akàl à ahàl. ");
INSERT INTO mfh_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Kiya uwaga Yesu kà asəl tatak uwana adàɓəzal gesina, azà à vok à awtày à slaka aŋatà, agòɗ à atà: “Uwa, kayahaw uwa?” ");
INSERT INTO mfh_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tawulà ala, tagòɗ: “Yesu, zil Nazaret.” Yesu agòɗ à atà: “Giga la uwanay, à uwana kayahaw!” Yudas uwana atàl kaf à gəl, la abatà atà nna. ");
INSERT INTO mfh_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Mok uwana ‘Gəga la uwanay’, Yesu agòɗ à atà kà, tawùl à lig, tatàɗ à vəɗah. ");
INSERT INTO mfh_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu anàv à atà aya, agòɗ à atà aya: “Uwa, kayahaw uwa?” Tagòɗal: “Yesu, zil Nazaret.” ");
INSERT INTO mfh_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu agòɗ à atà: “Gəga la uwanay, gədagoɗ à akul aw takay? Baŋa gi kayahàw kà, sàkàw azlaanik uwaga tada aŋatà!” ");
INSERT INTO mfh_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kiya uwaga la uwana gay uwana Yesu apə̀h uwarà, agəɗ à afik: “Baba, azladza uwana kaɓə̀k à gi à ahàl kà, amiyaka tekula aŋatà kà adazila aw.” ");
INSERT INTO mfh_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Katsakar la Səmon Piyer la ahàl, aɓə̀ɗ katsakar à lag, aɗə̀ɗla mayà aŋa məŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla, akəɗə̀val sləm ahàl kaf lakəl ala, sləm aŋa mayà uwatà kà Malkus. ");
INSERT INTO mfh_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu agòɗ: “Hay, Piyer, wulà katsakar aŋak à gày aŋha à agu. Kadzugw kà ‘Gəsa ŋgərpa à uda la kətsaw uwana la abà Baba avà à gi aw’, kagoɗ takay?” ");
INSERT INTO mfh_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Maham à ahəŋ slodzi, la azlaməŋga aŋatà, la azlaməna manəŋla gày Zəzagəla aŋa azla Yahu­diya tahamà à Yesu à adi, takàs, tawàɗàŋ. ");
INSERT INTO mfh_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Teraŋa kà, tadàlla à mtəga aŋa Hanas dadàŋ. Hanas kà tsiŋay aŋa Kayyif, uwana masla la uwana məŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla la mavay uwatà la tsəh. ");
INSERT INTO mfh_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tekeɗik kà, Kayyif la uwana avà sawaray à azla Yahu­diya: “Ŋuləm kà dza tekula aməts à kà azladza gesina aŋa maməts à gay”, agòɗ tekeɗik. ");
INSERT INTO mfh_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Səmon Piyer atà la masla matapla anik tanəfà Yesu. Masla matapla anik uwatà kà, məŋ madza­haga asə̀l, tahàd à gày à kodal à abà la slaka la Yesu, à kodal aŋa məŋ madza­haga uwaga à abà. ");
INSERT INTO mfh_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ama Piyer agə̀ɗ à gay gamagày. Kiya uwaga masla matapla anik uwana məŋ madza­haga asə̀l, asà à uda aɓaɗmà la mis uwana anə̀ŋla gamagày kà mav tetəvi à Piyer, kà mad à gày. ");
INSERT INTO mfh_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mis uwana anə̀ŋla gamagày agòɗ à Piyer: “Kak babay kà kak masla matapla aŋa zil uwanay aw takay?” “Awaŋ, awaŋ, gi la abà aw”, Piyer agòɗ. ");
INSERT INTO mfh_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Anasl la ahəŋ, azlaməna sləray, la azlaməna manəŋla tavatsà akàl à ahəŋ, kà madz la ahəŋ la adi. Piyer babay adzà à akàl à adi la slaka aŋatà. ");
INSERT INTO mfh_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Məŋ madza­haga aŋa azlaməna mav tatak uwana anavà Yesu lakəl aŋa azlaməna matapla la slaka aŋha, lakəl aŋa matapla aŋha uwana atàpla à azladza. ");
INSERT INTO mfh_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu agòɗal: “Gəpə̀hàhàh gay à azladza la dazu­waya, gətà­pàhàtàla azla­tatak la azlagày madəv kuɗa la aku, ŋgaha la məŋ gày Zəzagəla la aku, la slaka uwana azla Yahu­diya tahà­màhà gay à vok gesina, gəhaɗà tatak à ahəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kà mana kanav gi tatak aya ma? Nàv à azladza uwana tatsə̀ɓ gi sləm lakəl aŋa azlagay uwana gəpə̀h à atà gesina. Atà tasəl la lela lakəl aŋa uwana gəpə̀h à atà.” ");
INSERT INTO mfh_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Uwana Yesu apə̀h gay uwaga kà, masla manəŋla anik uwana la makəla aŋha, akəɗə̀val mamits à ahàl la magoɗal: “Kiya uwaga la uwana kaula à məŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla à adi takay?” ");
INSERT INTO mfh_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu agòɗal: “Baŋa gəpə̀h mawi­siga kà pə̀hgəla mawi­siga uwatà. Ama baŋa dziriga gəpə̀h ma, kà mana kaɗə̀ɗ à gi kiya uwanay ma?” ");
INSERT INTO mfh_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hanas aslə̀l masla la mawaɗəŋga à slaka Kayyif məŋ madza­haga. ");
INSERT INTO mfh_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","La mok uwatà Səmon Piyer la abatà à vuɗ akàl à vok. Tanavàlla gay ala: “Kak babay, kak tekula aŋa azlaməna matapla aŋa zil uwanay aw takay?” Ama Piyer awulà à uda, agòɗ: “Awaŋ, awaŋ, gi la abà aw!” ");
INSERT INTO mfh_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tekula la tataka aŋa azla­ma­gamza aŋa məŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla la abà, uwana yaga aŋa dza uwana Piyer akəɗə̀val sləm lakəl ala, agòɗal: “Kak à uwana gənəŋà ka la gày alàl la abà, akul səla aw takay?” ");
INSERT INTO mfh_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","“Gi aw!”, Piyer agòɗ aya, katskats mew­g­dza­galaŋ awiyà la kaslà uwatà. ");
INSERT INTO mfh_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","La gay bebəŋ bəŋ, tasə̀lla Yesu à uda la mtəga Kayyif, tadàlla à mtəga gumna aŋa azla Rom. Ama azla Yahu­diya tadà à gày la mtəga aŋa gumna aw, kà uwana wakità mapəhay aŋatà avà à atà tetəvi aw, kà uwana baŋa tadà à gày kà, adatàla àlàh à vok, taslala vok aŋa mazuw tatak may aŋa madəvaday Paska aw. ");
INSERT INTO mfh_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kà uwaga à uwana gumna Pilatus asà à uda à slaka aŋatà, anàv à atà lakəl: “Ma aŋa mana kapuwàw gudzi à dza uwanay à gəl ma?” ");
INSERT INTO mfh_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tagòɗal: “Agayŋa agay dza mawsiga aw kà, naka məslala vok aŋa mav à ka à ahàl aw.” ");
INSERT INTO mfh_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatus agòɗ à atà: “Ɗàwla, kadà­ɗa­hawla seriya à gəl aŋkul bokuba uwana wakità mapəhay aŋkul apəhay.” Azla Yahu­diya tagòɗal: “Tetəvi la ahəŋ kà aŋami aŋa maɗàh seriya mamətsay à dza à gəl aw.” ");
INSERT INTO mfh_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Uwaga apakà vok aŋa magəɗ gay aŋa Yesu à afik, apə̀h lakəl aŋa mamətsay aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kiya uwaga Pilatus awùl à gày, azàla Yesu, agòɗal: “Kak, Sufəl aŋa azla Yahu­diya ay?” ");
INSERT INTO mfh_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu agòɗal: “Kapəh uwaga ma la gəl aŋak ay? Awma azlaanik tapə̀h à ka magay ay?” ");
INSERT INTO mfh_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatus agòɗal: “Gi zil Yahu­diya suwaŋ ay? Azla­yaga aŋak dardar gà, la azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla la uwana tavà à gi kak, mana kaɗahàŋ takay ma?” ");
INSERT INTO mfh_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu agòɗ: “Makoray gulo kà aŋa gudəŋ à vok uwanay aw, agayŋa makoray gulo kà aŋa gudəŋ à vok uwanay kà, naka iyay, azlaməna sləray gulo tagoɗay kà mav à gi à ahàl aŋa azla Yahu­diya aw. Ama kiya uwaga aw, makoray gulo kà aŋa gudəŋ à vok uwanay aw.” ");
INSERT INTO mfh_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatus agòɗal zlà: “Lagwa ma kak Sufəl ay?” Yesu agòɗal: “Bokuba uwana kapə̀h kà, gi Sufəl. Tayyà gi, gəsà à ahəŋ à gudəŋ à vok kà, kà mapəh dziriga. Uwa­be­yuwi uwana asal dziriga atsəɓ sləm à dziriga uwana gəpəhay.” ");
INSERT INTO mfh_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","“Mana à dziriga ma?”, Pilatus agòɗal. Mok uwana adapəh gay uwaga, Pilatus asà à uda aya, kà mad à slaka azla Yahu­diya, adzà­ɗàtàŋ ala, agòɗ à atà: “Gəɓəz à tatak uwana adukwla zil uwanay à ahəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ama bokuba uwana zagəlà aŋkul kà, gədàwa à akul gəl à masla daŋay tekula kəla madəvaday Paska ma. Lagwa ma asà à akul gəduwa à akul gəl à Sufəl aŋa azla Yahu­diya ay?” ");
INSERT INTO mfh_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kiya uwaga tadzəkà mawiyay: “Awaŋ, masla aw! Barabas la uwana asa à anu!” Tekeɗik Barabas uwatà kà, agà kà masla nabəra. ");
INSERT INTO mfh_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kiya uwaga Pilatus avà à atà tetəvi kà maslàh Yesu ala la kurpi. ");
INSERT INTO mfh_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Azla­slodzi taslàslàp gabaga aŋa atàk kà mawaɗ à Yesu à gəl, ŋgaha tatsàkwà à deri mativga gà à abà vikuza. ");
INSERT INTO mfh_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tazà à vok à slaka aŋha, ŋgaha tagòɗal: “Ayyi, Sufəl aŋa azla Yahu­diya!” Ŋgaha tazlàɓ la maməts à ahàl. ");
INSERT INTO mfh_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Kiya uwaga Pilatus asà à uda aya, agoɗ à maham à ahəŋ dza, agòɗ à atà: “Gətsa­kulla à uda à abanay. Kà akul aŋa masəlay kà tatak la ahəŋ à uwana azlayla kà madukwla seriya à gəl aw.” ");
INSERT INTO mfh_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesu asà à uda la gabaga aŋa atàk lakəl, la deri mativga la vok vikuza. Ŋgaha Pilatus agòɗ à atà: “Aganay dza zlà!” ");
INSERT INTO mfh_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ama uwana azla­madz­haga aŋa azlaməna mav tatak à Zəzagəla, la azlaməna manəŋla gày Zəzagəla tanəŋàŋ kà, tadzəkà mawiyay: “Zlə̀l masla à ahàf à adi, zlə̀l masla à ahàf à adi!” Pilatus agòɗ à atà: “Zlə̀làw masla à ahàf à adi la gəl aŋkul, kà uwana gəɓəzà à tatak uwana gəɗa­halla seriya à gəl aw.” ");
INSERT INTO mfh_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Azla Yahu­diya tagòɗal: “La wakità mapəhay gami la abà kà, mapəhay gami agòɗ kà: Azlayla à vok amətsay kà uwana: ‘Gi la gəl gulo kà, gi Kona aŋa Zəzagəla’, agoɗ.” ");
INSERT INTO mfh_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Mok uwana Pilatus atsənà gay uwatà, guba akə̀s kaykay aya. ");
INSERT INTO mfh_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Awùl à gày, ŋgaha anàv à Yesu: “Kasà à waŋ ma la ala tak la?” Ama Yesu kà awulà gay à uda aw. ");
INSERT INTO mfh_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kiya uwaga Pilatus agòɗal: “Asà à ka maɓaɗ­gəma aw ay? Kasəl kà gi la maslay aŋa maduwa ka gəl, ŋgaha bay kà, gi la maslay aŋa mazləl ka à ahàf à adi aw takay?” ");
INSERT INTO mfh_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu agòɗal: “Kak la maslay lakəl gulo aw, say baŋa uwana Zəzagəla avà à ka dagay la afik pəra. Kà uwaga à uwana dza uwana avà à ka gi à ahàl la uwana aɗuwa ka la tsakana gesina.” ");
INSERT INTO mfh_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Dagay la mok uwatà Pilatus ayàh tetəvi kà maduw gəl à Yesu. Ama azla Yahu­diya tadzəkà mawiyay: “Baŋa kasak à dza uwaga kà, kak slawda aŋa məŋ sufəl aya aw! Kəla dza uwana ‘Gi sufəl’, agòɗ kà, masla məzam aŋa məŋ sufəl!” ");
INSERT INTO mfh_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Mok uwana Pilatus atsənà gay uwaga kà, awùlla Yesu à uda aya, adzà à kursi aŋa seriya à afik, la slaka uwana tazalalla Pave (Uwaga asal magoɗay: slaka akur madəlay gay gà, la gay Ibəra­nəŋkowen Gab­batha, tagoɗal) ");
INSERT INTO mfh_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Uwaga kà, agà vuɗ maɗàh vok aŋa vuɗ madəvaday Paska, la tataka afats. Pilatus agòɗ à azla Yahu­diya: “Masla la uwaga à Sufəl aŋkul!” ");
INSERT INTO mfh_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ama tadzəkà mawiyay: “Kə̀ɗ masla, kə̀ɗ masla, zlə̀l à ahàf à adi!” Azlaməŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla tagòɗ: “Sufəl gami anik la ahəŋ aw, say məŋ sufəl aŋa azla Rom pəra.” ");
INSERT INTO mfh_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kiya uwaga Pilatus avà à atà Yesu à ahàl, kà atà aŋa mazləl à ahàf à adi. Kiya uwaga tadàla Yesu. ");
INSERT INTO mfh_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu asà à uda la gudəŋ la abà, ahàf uwana tadàzləllal à adi lakəl aŋha, kà mad slaka uwana tazalalla slaka aslasl takas à gəl. (Tazalalla Gol­go­ta la gay Ibəra­nəŋkowen) ");
INSERT INTO mfh_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","La abatà la uwana, azla­slodzi tazlə̀l Yesu à ahàf à adi. La kaslà uwatà la uwana tazlə̀l azladza səla à ahàf à adi atà nna, tekula la ahàl kaf, tekula la ahàl gudzay aŋha. Yesu la tataka la abà. ");
INSERT INTO mfh_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatus avà à atà tetəvi kà matsetser wakità kà maf à ahàf à adi lakəl aŋha. Aganay matse­tseray gà uwana tatsetsèr: YESU ZIL NAZARET, SUFƏL AŊA AZLA YAHUDIYA. ");
INSERT INTO mfh_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Azla Yahu­diya aŋuvaw tadzèŋàh matse­tseray uwatà, kà uwana slaka uwana tazlə̀l Yesu à ahàf à adi, kà nekwa la mad à huɗ gudəŋ à abà, matse­tseray gà uwana tatsetsèr kà la gay Ibəra­nəŋkowen, la gay latin, ŋgaha la gay gərək. ");
INSERT INTO mfh_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kiya uwaga azlamadza­haga aŋa azlaməna mav tatak à Zəzagəla uwana la tataka azla Yahu­diya la abà, tagòɗ à Pilatus: “Matse­tseray uwanay: Gi Sufəl aŋa azla Yahu­diya, kagoɗ kà kità aw, ama tsetsèr kà: Dza uwanay la uwana agòɗ kà: ‘Gi Sufəl aŋa azla Yahu­diya’, agòɗ, kagoɗay.” ");
INSERT INTO mfh_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatus agòɗ: “Uwana gəda­tse­tseray kà, adza à ahəŋ kiya uwaga pəra.” ");
INSERT INTO mfh_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Mok uwana azla­slodzi tazlə̀l Yesu à ahàf à adi kà, tahə̀l lukut aŋha, tavàhàŋ ala sla­slaka ufaɗ, kəla slodzi aɓə̀zal slaka tekula, tekula. Tahə̀l deri aŋha uwana madzəɓayga vok aw, tsəràh à afik, tsəràh à vəɗah. ");
INSERT INTO mfh_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Azla­slodzi tagòɗ à vok kà atà kà atà: “Məkwaha deri uwanay ala aw, ama mətsà tsatsa lakəl kà anu aŋa masəl dza uwana agəɗal.” Uwanay apakà vok kà magəɗ gay uwana à afik wakità Zəzagəla apəh: ˈTavàhà lukut gulo la tataka aŋatà la abà, tatsà tsatsa la lukut gulo lakəl.ˈ Kiya uwanay la uwana azla­slodzi taɗahàŋ zlà. ");
INSERT INTO mfh_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nekwa la ahàf uwana tazlə̀llal Yesu à adi kà, iyà aŋha atsìzl à abatà, atà la deda aŋha duguga, mis aŋa Kəlopas, ŋgaha Mari­yama dəg zla Magdala. ");
INSERT INTO mfh_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu anəŋà iyà aŋha, la makəla aŋha masla matapla uwana awoyàŋ kaykay. Yesu agòɗ à iyà aŋha: “Mis uwanay kà kona aŋak la uwaga.” ");
INSERT INTO mfh_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ŋgaha agòɗ à masla matapla uwaga: “Iyà aŋak la uwaga.” Dagay vuɗ uwatà, masla matapla azə̀ɓ à mtəga aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Uwana uwaga adada à lig gesina, Yesu asə̀l tatak gesina kà adadəv à gay, apə̀h uwaga kà mahən gay uwana ala matse­tseray agoɗ: “Nəlay aza à gi.” ");
INSERT INTO mfh_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Iyaw hamhamga la ahəŋ la abatà la daraw gà dəŋəra. Azla­slodzi tadùw sawsaw à iyaw hamhamga uwaga à abà, tafà à kavak à gay kà madziyla à afik aŋa mako­kuzay. ");
INSERT INTO mfh_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mok, uwana ada­kokuz iyaw uwaga, Yesu agòɗ: “Lagwa kà adagay diga!” Akəsà gəl à ahəŋ, amə̀ts. ");
INSERT INTO mfh_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Uwaga kà mavakay maɗàh vok aŋa maduw ləv, asà à azla Yahu­diya kà, azlavok adza à ahəŋ la ahàf à adi tsəràh à mavakay maduw ləv aw, kà uwana mavakay uwatà kà mavakay mapis ala gay à vok gà, tanàv à Pilatus kà, takà­làhà à atà asik ala, kà mahəl vok à ahəŋ la ahàf la adi. ");
INSERT INTO mfh_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kiya uwaga azla­slodzi tasà à waŋ takà­làhà asik à matera ala, la aŋa masəla, uwana la makəla aŋa Yesu lakəl la slaka gà. ");
INSERT INTO mfh_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Uwana tabə̀z à Yesu à vok kà, tanəŋàŋ kà adamətsay. Kà uwaga à uwana takàlla ala asik ala aw. ");
INSERT INTO mfh_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ama tekula aŋa azla­slodzi azlə̀l ala makəlla la atsəkaɗ, batsàrà aŋiz la iyaw asà à uda. ");
INSERT INTO mfh_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Dza uwana azàŋ lakəl aŋa tatak uwaga apakà vok gesina kà, azàŋ lakəl aŋha kà dziriga, masla bay kà asə̀l kà uwana anəŋà, akul babay kà kaslaw aŋa madiŋal gəl à vok. ");
INSERT INTO mfh_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Uwanay apakà vok kà gay aŋa matse­tseray aŋa magəɗ à afik ndzer: ˈTa­dàkəlah aslasl aŋha ala aw.ˈ ");
INSERT INTO mfh_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","La azla­slaka anik la wakità la abà agoɗ aya kà: ˈTa­dà­nəŋ dza uwana tazlə̀làŋ ala la ahàf la adi.ˈ ");
INSERT INTO mfh_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Uwana uwaga adada à lig, Yusufu zil gudəŋ Arimate, anàv tetəvi la slaka Pilatus kà mazəɓ vok aŋa Yesu. (Yusufu kà masla matapla la slaka Yesu la gəl à gəl, kà uwana guba azəŋ kà azla Yahu­diya) Pilatus avàl tetəvi. Kiya uwaga Yusufu asà à waŋ, azə̀ɓ vok aŋa Yesu à ahàf à adi ala. ");
INSERT INTO mfh_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Niko­demus, zil uwana ahàd à slaka Yesu la vəɗ, asà à waŋ à slaka aŋha bay, matərsin, la azlaahàf kidzidzi uwana maha­mala gay à vok gà la ahàl, mahanay aŋha kà kilo dzik makər (Bokuba tasà kulo gəl aŋha zlo) ");
INSERT INTO mfh_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tazə̀ɓ vok aŋa Yesu atà səla, tafàɗal bafta à adi, taɗa­hàhal azla­tatak mazinay gà à vok, uwana zagəlà aŋa azla Yahu­diya, kà mazəɓ dza à uda, à baŋa adamətsay. ");
INSERT INTO mfh_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","La slaka uwana tazlə̀l Yesu à ahàf à adi kà, gày alàl la ahəŋ la abatà. La gày alàl uwatà la abà kà, zəvay mawga la ahəŋ, taf dza à agu didi aw. ");
INSERT INTO mfh_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bokuba uwana vuɗ maɗàh vok aŋa vuɗ maduw ləv aŋa azla Yahu­diya kà, tafà Yesu à agu la abatà, kà uwana zəvay kà nekwa. ");
INSERT INTO mfh_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Bəŋ la zay la tsəh vuɗ maduw ləv aŋa azla Yahu­diya, Mari­yama dəg zla Magdala, ahàd à gəl zəvay. Masla anəŋàŋ kà akur uwana la zəvay la gay kà, mata­koslal à ama ala gà. ");
INSERT INTO mfh_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Adà aŋha la mahoyay, abə̀z à Səmon Piyer à vok, atà la masla matapla anik uwana Yesu awoyàŋ kaykay, agòɗ à atà: “Sufəl kà, tazə̀ɓ à lag la zəvay la aku, məsə̀l slaka uwana tadàlla à abà aw.” ");
INSERT INTO mfh_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piyer atà la masla matapla anik uwanay tahàd à gəl zəvay. ");
INSERT INTO mfh_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tahàd la mahoyay, tahòy, ama masla matapla anik uwanay aɗuwà Piyer la mahoyay, atsà vok à gəl zəvay. ");
INSERT INTO mfh_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Atsòŋ gəl à agu, anəŋà bafta la vəɗah la aku, ama adà à agu aw. ");
INSERT INTO mfh_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Səmon Piyer, uwana asà à waŋ la lig la ahəŋ, adà à agu. Masla anəŋà bəfta la vəɗah, ");
INSERT INTO mfh_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","la nalbət uwana tafafàɗ à Yesu à gəl, masla kà, adəɓanì vok la bafta aw, mafafaɗ à abà gà la slaka anik kokuɗa gəl aŋha. ");
INSERT INTO mfh_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","La lig la ahəŋ, masla matapla uwana atsà vok à gəl zəvay, adà à agu suwaŋ. Anəŋàŋ, ŋgaha adìŋal gəl à vok. ");
INSERT INTO mfh_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Te­ke­ɗika la kaslà uwatà kà, azlaməna matapla tatsənà godega aŋa wakità, uwana Yesu adàwula à uda la mamətsay agoɗ, dadàŋ aw) ");
INSERT INTO mfh_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ŋgaha azlaməna matapla səla uwatà tawùl aŋatà. ");
INSERT INTO mfh_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mari­yama atsìzlla ahəŋ la gay zəvay la matuway. Uwana atuway kà, atsòŋ gəl à zəvay à agu kà manərəzay, ");
INSERT INTO mfh_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ŋgaha anəŋà azla­ma­lika səla la lukut me­ɗe­kuga la vok təlla, tadzàh madzay la slaka uwana hənà Yesu à ahəŋ. Tekula adzà madzay lakəl gà, anik adzà madzay la godega gà. ");
INSERT INTO mfh_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Azla­ma­lika uwaga tanà­valla gay: “Mis, kà mana katuway ma?” Mis agòɗ à atà: “Tazə̀ɓ vok aŋa Sufəl gulo, gəsəl slaka uwana tadàlla à abà aw.” ");
INSERT INTO mfh_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","La mapəh gay uwaga la gay la, agolà vok, ŋgaha anəŋà Yesu. ");
INSERT INTO mfh_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu anà­valla gay ala: “Mis, kà mana katuway ma? Uwa kayahay uwa?” Mis adzùgw kà masla sləray guf, agòɗ, à uwana apəhal kiya uwanay: “Baŋa kak kazə̀ɓ kà, pə̀hgəla slaka uwana kafà à abà, kà gəday, gədàzəɓay.” ");
INSERT INTO mfh_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu agòɗal: “Mari­yama!” Fə̀tsal, Mari­yama agolà vok à slaka aŋha, ŋgaha agòɗal la gay Ibəra­nəŋkowen: “Rab­bu­ni!” (Uwana asal magoɗay: Məŋga gulo) ");
INSERT INTO mfh_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu agòɗal: “Kakəs gi à ahəŋ aw, kà uwana gədàda à afik à slaka Baba gulo aw. Ama hàd, kadàgoɗ à azla­deda gulo kà gədàda à afik à slaka Baba gulo, uwana Baba aŋkul babay, à slaka Zəzagəla gulo uwana Zəzagəla aŋkul babay.” ");
INSERT INTO mfh_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kiya uwaga Mari­yama dəg zla Magdala azà gay uwaga à azlaməna matapla: “Gədanəŋ Sufəl!” Ŋgaha atùgw a àtà tatak uwana apəhal gesina. ");
INSERT INTO mfh_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","La gay mokokhu aŋa vuɗ maduw ləv aŋa azla Yahu­diya uwatà, azlaməna matapla tahamà gay à vok la gày anik la aku, tatsàkà à gamagày à ama la tsəku­rum, kà uwana guba azà à atà kà azla Yahu­diya. Yesu asà à waŋ, atsìzl à tataka aŋatà à abà, agòɗ à atà: “Lapiya aga la akul!” ");
INSERT INTO mfh_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Uwana adapəh à atà uwaga, apə̀hatàla ahàl aŋha la makəla aŋha. Azlaməna matapla tahə̀n ala la marabay à kà uwana tanəŋà Sufəl. ");
INSERT INTO mfh_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu agòɗ à atà aya: “Lapiya aga la akul, bokuba uwana Baba aslə̀l gi à waŋ kà, gi babay kà gəsləl akul suwaŋ.” ");
INSERT INTO mfh_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","La lig aŋa uwaga la ahəŋ, afətà à atà afaɗ à gəl, agòɗ à atà: “Ɓə̀zàw Masasəɗok Zəzagəla! ");
INSERT INTO mfh_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Uwa­be­yuwi uwana kama­tsa­wwalla tsakana ala kà, adàɓəz mama­tsila. Azla­uwana kamatsaw à atà tsakana ala aw kà, tadàɓəz mamtsila babay aw.” ");
INSERT INTO mfh_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Mok uwana Yesu asà à waŋ kà, Tomas, tekula aŋa azlaməna matapla kulo gəl aŋha səla, (Uwana tazalal vəgal), la uwana agà la tataka aŋatà la abà, à mok uwana Yesu asà à waŋ aw pəra. ");
INSERT INTO mfh_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Azlaməna matapla anik tagòɗal: “Mənəŋà Sufəl!” Ama Tomas agòɗ à atà: “Baŋa gədà­nəŋəŋ azla­mokfak aŋa mama­sa­masa uwana la ahàl aŋha aw kà, gədiŋal gəl à vok aw, say baŋa gədàtap gay gəl ahàl gulo à amik, aŋa mama­sa­masa uwatà à abà dadàŋ, ŋgaha gətàp ahàl gulo à amik uwana à abà la makəla aŋha aw kà, gədiŋal gəl à vok aw!” ");
INSERT INTO mfh_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Bà la mad à abà aŋa kasukwa uwatà aya kà, azlaməna matapla tahamà gay à vok la kay aya. Vuɗ uwatà kà, Tomas la tataka aŋatà la abà. Gamagày matsa­kahay gà la tsəku­rum, ama Yesu asà à waŋ, atsìzl à tataka aŋatà à abà, la magoɗay: “Lapiya aga la akul!” ");
INSERT INTO mfh_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ŋgaha agòɗ à Tomas: “Tomas, tàp gay gəl ahàl aŋak à abà la abanay, ŋgaha nərə̀z makəla gulo, sàk à matsigay, dìŋal gəl à vok pəra.” ");
INSERT INTO mfh_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas agòɗal: “Sufəl gulo, Zəzagəla gulo!” ");
INSERT INTO mfh_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu agòɗal: “Kà uwana kadanəŋ gi pəra, à uwana kadiŋal gəl à vok ay? Marabay la azla­uwana tadiŋal gəl à vok la kokuɗa manəŋ gi!” ");
INSERT INTO mfh_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu aɗahà azla­na­dzipo anik la huma aŋa azlaməna matapla aŋha aŋuvaw, uwana tatsetsèr à wakità uwanay à abà aw. ");
INSERT INTO mfh_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ama uwana agà la abà kà tatsetser kà, kà akul aŋa madiŋal gəl à vok kà Yesu kà Kristu, ŋgaha Kona aŋa Zəzagəla. La madiŋal gəl à vok uwaga kà akul kaɓəzaw sifa adəv à gay aw, la masla la abà. ");
INSERT INTO mfh_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","La lig aŋa uwaga la ahəŋ aya, Yesu apə̀hla vok à azlaməna matapla la slaka aŋha, la gay dərəv Tibe­riya, la kuba uwanay uwana apəhatàla vok: ");
INSERT INTO mfh_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Səmon Piyer, la Tomas (Uwana tazalalla vəgal), Nata­nayel, uwana la Kana aŋa Galili, azlabəza aŋa Zebede, la azlaməna matapla səla anik aŋa Yesu, tahamà gay à vok. ");
INSERT INTO mfh_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Səmon Piyer agòɗ à atà: “Gəday, gədàkas kilfi.” Atà tagòɗal: “Anu babay kà, mənəfa ka”, ŋgaha tahàd à kəslah iyaw à afik. Ama la huɗ vəɗ uwatà kà, takə̀s tatak aw. ");
INSERT INTO mfh_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mok uwana məl azlà awulà, Yesu apə̀hatàla vok la gay dərəv, ama azlaməna matapla tasə̀l kà uwaga kà Yesu aw. ");
INSERT INTO mfh_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kiya uwaga Yesu agòɗ à atà: “Azla­ko­hana, kakàsàw kilfi ay?”, agòɗ à atà. “Awaŋ”, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Masla agòɗ à atà: “Dùwàw dzarawa aŋkul à makəla à ahàl kaf aŋa kəslah iyaw, ŋgaha kaɓəzaw à kilfi!” Kiya uwaga tadùw à abà ŋgaha taɓə̀z kilfi tsəràh à uwana taslàla vok aŋa mabiyəŋ à uda aya aw, kà uwana adahənla la kilfi. ");
INSERT INTO mfh_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Masla matapla uwana Yesu awoyàŋ kaykay agòɗ à Piyer: “Uwaga kà Sufəl gami!” Kà uwaga, mok uwana Səmon Piyer atsənà uwaga: ‘Sufəl’ tagòɗ kà, adùw lukut aŋha à vok, avàl à iyaw à abà. ");
INSERT INTO mfh_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Azlaməna matapla anik tasà à waŋ la kəslah iyaw, la mabiy dzarawa uwana kilfi adahən à abà. Kərkər la gay dərəv aw, bokuba zuwiɗ tekula. ");
INSERT INTO mfh_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Mok uwana tasà à vəɗah kà, tanəŋà akàl, kilfi la afik la Pain. ");
INSERT INTO mfh_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu agòɗ à atà: “Kilfi uwaga kakàsàw, kasawla azlaanik à waŋ à abanay.” ");
INSERT INTO mfh_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Səmon Piyer ahàd à kəslah iyaw à afik, abiyà dzarawa à vəɗah la kilfi məŋga gà dzim bəzi aŋha dzik zlo gəl aŋha makər gesina aŋha. Ama la magol kilfi uwaga babay kà dzarawa akwa­hala aw. ");
INSERT INTO mfh_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu agòɗ à atà: “Sàw à waŋ, kazuwaw!” Amiyaka bà tekula la tataka azlaməna matapla aŋha la abà kà, dza aslàla vok aŋa manaval: “Kak uwa” aw, kà uwana tasə̀l kà masla Sufəl aŋatà. ");
INSERT INTO mfh_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu azà vok à slaka Pain, ahə̀l, ŋgaha avàhà à atà, ŋgaha akàl à atà kilfi babay, bokuba uwana avàhà à atà Pain. ");
INSERT INTO mfh_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Uwaga kà, kà mamakər à uwana Yesu apə̀hla vok à azlaməna matapla la slaka aŋha, la lig aŋa mawul à uda aŋha la mamətsay. ");
INSERT INTO mfh_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Uwana tazùw tatak may à gay kà, Yesu agòɗ à Səmon Piyer: “Səmon, Kona aŋa Yuhana, kaɗuwà azla­uwanay la mawoy gi takay?” “Iyay, Sufəl, kasəl kà gəwoya ka” Yesu agòɗal: “Nə̀ŋla azlabəza tuwaŋ gulo.” ");
INSERT INTO mfh_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ŋgaha agòɗal kà masəla aya: “Səmon, Kona aŋa Yuhana, kawoya gi ay?” “Iyay, Sufəl, kasəl kà gəwoya ka.” Yesu agòɗal: “Fà sləm à azlabəza tuwaŋ gulo!” ");
INSERT INTO mfh_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ŋgaha Yesu agòɗal kà mamakər aya: “Səmon, Kona aŋa Yuhana, kawoya gi ay?” Piyer agòɗal la mazaw la gəl gà, kà uwana Yesu apə̀hal kà mamakər: ‘Kawoya gi ay?’ Ŋgaha agòɗal: “Sufəl, kasəl tatak gesina, kasəl bay kà, gəwoya ka.” Yesu agòɗal: “Nə̀ŋla azla­tuwaŋ gulo! ");
INSERT INTO mfh_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","La haɗay gəgoɗ à ka: La mok uwana kaləg meɗega, kafàh para­para aŋak à tsəh la gəl aŋak, kadàhah à slaka uwana asà à ka. Ama aŋa kadàgay makoz kà, tadàbay à ahàl aŋak ala, kà dza anik aŋa maf à ka para­para à tsəh, ŋgaha dza anik adàdala ka à slaka uwana asà à ka maday aw.” ");
INSERT INTO mfh_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(La gay uwaga kà Yesu asal mapəhla ala tsəhay mamətsayga uwana Piyer adàmətsay kà mavày mazləɓay à Zəzagəla) La lig la ahəŋ Yesu agòɗal: “Nəfà gi!” ");
INSERT INTO mfh_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piyer anəŋà à lig kà, anəŋà masla matapla uwana Yesu awoyàŋ kaykay, atsà à waŋ la lig aŋatà. Masla uwana ahùɓ à Yesu à makəla, la mok uwana atà la tatak may lakəl uwarà, à uwana anàv à Yesu: ‘Sufəl, uwa à dza uwana adàta à kaf à gəl uwa?’ ");
INSERT INTO mfh_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piyer anəŋà, ŋgaha agòɗ à Yesu: “Dza uwanay, takay Sufəl, masla ma mana à uwana adàɓəzal tak ma?” ");
INSERT INTO mfh_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu agòɗal: “Baŋa asa à gi adz à ahəŋ la sifa tsəràh à uwana gədàwula à waŋ ma, mana aŋak la abà ma? Kak kà, nəfà gi pəra.” ");
INSERT INTO mfh_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Azlaməna maham à ahəŋ gay Zəzagəla tatsənà gay uwaga: ‘Masla matapla uwanay, adàmətsay aw’, tagòɗ. Ama, ‘Adàmətsay aw’, Yesu agòɗ à Piyer aw, ama agòɗ pəra kà: ‘Baŋa asa à gi adza à ahəŋ la sifa tsəràh à kaslà uwana gədàwula à waŋ ma, mana aŋak la abà mi?’, agòɗal pəra. ");
INSERT INTO mfh_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Uwaga masla matapla gà la uwanay à uwana atsetsèr gay uwanay kà, ŋgaha məsəl kà uwana atsetsèr kà dziriga. ");
INSERT INTO mfh_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu aɗahà azlasləray anik aŋuvaw. Agay tatse­tseray la tekula, tekula gesina kà, naka gudəŋ gesina aslala vok aŋa makəsiŋ azla­wa­kità uwanay tatsetser aw.");
INSERT INTO mfh_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","A kak slawda gulo Tewofil. La wakità gulo matera la abà kà, gətsetser à ka lakəl aŋa Yesu. Gəda­tse­tseray lakəl uwana apàhla ŋgaha la uwana ata­pàhla à azladza gesina, dagay madzəka vok aŋa sləray aŋha, ");
INSERT INTO mfh_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tsəràh à mavakay uwana Zəzagəla azə̀ɓ à zagəla. Mok uwana aləg la gudəŋ la vok, akàsànì azladza kà magay azlaməna matapla aŋha, atàpàhàtàla uwana naka taɗehəŋ, aɗahà uwaga kà la ndzəɗa aŋa Masasəɗok Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","La lig la ahəŋ, à mok uwana ada­matsay apə̀hatàla vok asik dəŋ la mahanay dzik ufaɗ la abà, kà atà aŋa masəlay la dziriga kà masla la sifa. Apə̀h à atà gay aŋa makoray Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Vərdi anik uwana tadahama gay à vok kà mazuw tatak may la slaka gà kà, agòɗ à atà: “Baba gulo, apə̀h à akul à ahəŋ kà mav à akul tatak uwanay, à uwana gəpə̀h à akul, kadaw à slaka aw, dzàw à ahəŋ la abanay la Uru­sa­lima kakudaw. ");
INSERT INTO mfh_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kà uwana Yuhana aɗahà batem à azladza la iyaw, ama la huma la gay kà, akul kà, tadà­ɗa­ha­kullaŋ kà la Masasəɗok Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Azlaməna matapla uwana tahamà gay à vok la Yesu tanàval: “Sufəl gami, la kaslà uwatà la uwana kadàv makor gəl à tsəhay aŋak Isərayel ay?” ");
INSERT INTO mfh_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu agòɗ à atà: “Uwaga kà gay aŋkul la abà kà masəl kaslà uwatà aw, say Baba gulo la uwana asəl uwaga pəra. ");
INSERT INTO mfh_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ama à akul kà, Zəzagəla adàvà à akul Masasəɗok aŋha, la ndzəɗa aŋha ŋgaha kadàgaw azlaməna sayda gulo, la abanay la Uru­sa­lima, ŋgaha la kutso Yahu­diya, la Sama­riya ŋgaha tsəràh à makəɗ gəl à ahəŋ gudəŋ à vok gesina.” ");
INSERT INTO mfh_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","La mapəh uwaga la gay ala, azə̀ɓ vok à zagəla, ahàd à slaka Baba, la huma yewdi aŋatà. Ŋgaha azà à atà à adi, ŋgaha tanəŋàŋ aya aw. ");
INSERT INTO mfh_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","La mok uwana atà la matsak yewdi à zagəla aya kà, azladza səla tatsìzlla atà à vok la lukut me­ɗe­kuga la vok təlla. ");
INSERT INTO mfh_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Tagòɗ à atà: “Akul azla Galili, kà mana kadzaw à ahəŋ tsàk yewdi à zagəla ma? Yesu uwana ahàd à zagəla asàk akul à ahəŋ, adàwul à waŋ bokuba uwana kanə̀ŋàw mad à zagəla aŋha.” ");
INSERT INTO mfh_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","La lig aŋa uwaga la ahəŋ, azlaməna matapla tasà à ahəŋ la gudəŋ uwana la afik, tazalalla gudəŋ kuvu, kiya uwaga tasà à ahəŋ la abatà, tahàd à Uru­sa­lima kərkər aŋha kà mahoyay pəlis tekula. ");
INSERT INTO mfh_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Mok uwana tabəzà Uru­sa­lima kà, tadà à gày uwana à agu lakəl aŋa gày anik la afik tadzà à ahəŋ la aku uwarà. Azladza gà uwana kà: Piyer, Yuhana, Yakuba kona aŋa Alfe, Səmon uwana tazala Zəlot ŋgaha Yahuda kona aŋa Yakuba. ");
INSERT INTO mfh_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Gesina aŋatà tahamàh gay à vok kà madəv kuɗa la slaka gà, la azlamis, la Mari­yama iyà aŋa Yesu, ŋgaha la azldeda aŋa Yesu. ");
INSERT INTO mfh_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","La vərdi anik aya, azlaməna madiŋal gəl à vok tahamà gay à vok: Dza dzim bəzi aŋha dzik səla. Hadzak, Piyer atsìzlla ala la tataka aŋatà la abà, agòɗ à atà: ");
INSERT INTO mfh_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“Azla­deda, Yudas kà agà la tataka gami la abà. Masla kà tavàl sləray bokuba anu bay. Ama la mok uwana azladza tayàh makəɗ Yesu kà, aguwà azladza à huma, kà makəs Yesu. Dagay uwarà la matse­tseray la abà, David apə̀h à ahəŋ lakəl aŋa Yudas uwana naka aɗehəŋ. Ndzer, say gay uwanay agəɗ à afik bokuba uwana apə̀h à vok.” ");
INSERT INTO mfh_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yudas kà aɗahàŋ kà mawi­siga. Sili uwana tapə̀lal kà maguw azladza à huma aŋa mapəhla Yesu ala kà, asùkwla guf, ŋgaha atsà gəl à ahəŋ la guf uwatà la abà, tsəzllòh, hana aŋha gesina asà à vəɗah gesina, vərɗəɗa. ");
INSERT INTO mfh_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Azlaməna madz à ahəŋ la Uru­sa­lima tasəl à uwana apakà vok gesina, gay gà la uwaga tazàlalla guf uwatà la gay gudəŋ aŋatà kà: Ha­kel­da­ma, bokuba magoɗay kà: Guf aŋa aŋiz. ");
INSERT INTO mfh_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Piyer awùlla à gay aŋha à tsəh, agòɗ aya: “Gay gà la uwaga David apə̀h à ahəŋ dagay uwarà lakəl aŋa Yudas la wakità aŋa Mahabay la abà: ˈGày aŋha adà­pakay ŋvagay tsewwa, Dza adàdza à ahəŋ la aku aŋa tetuwa.ˈ Tatsetsèr aya kà: ˈSay dza anik aɓəɗ à slaka aŋha à abà aya.ˈ” ");
INSERT INTO mfh_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Say dza aɓəɗ à slaka aŋha à abà kà mapak masla sayda aŋa mawul à uda aŋa Sufəl Yesu gami la mamətsay. Dza uwaga agay kəla kà tekula la tataka azla­uwana la abà mau­gu­zahàh anina la kəla slaka uwana Sufəl Yesu adahàh à abà dagay zamana uwana Yuhana aɗa­hàlla batem tsəràh asàk anu à ahəŋ à mok uwana Yesu awùl à uda la mamətsay awùl à zagəla.” ");
INSERT INTO mfh_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kiya uwaga tatsìzlla azladza səla ala: Yusufu uwana tazalalla Barsabas, sləm aŋha anik aya Yustus, atà la Matiyas. ");
INSERT INTO mfh_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ŋgaha tadə̀v kuɗa à Zəzagəla gesina aŋatà, tagòɗ: “Sufəl, kak uwana kasəl madzugway aŋa ləv aŋa dza kà, pə̀hanula la uwana kakə̀sànì la tataka aŋatà la abà, ");
INSERT INTO mfh_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kà masla aŋa maɓəɗ à slaka asik aŋa Yudas à abà kà magay masla matapla, kà masla aŋa maɗàh sləray aŋha à uwana Yudas asàkal, kà masla aŋa mad à slaka uwana à abà agà aŋha.” ");
INSERT INTO mfh_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","La lig la ahəŋ tatsà à atà goropu lakəl aŋa mazəɓani tekula aŋatà. Kiya uwaga Zəzagəla azə̀ɓànì Matiyas, ŋgaha adà à matugway aŋa azlaməna matapla kulo gəl aŋha tekula gà uwaga à adi. ");
INSERT INTO mfh_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Mok uwana madəvaday aŋa Pen­ta­kosta adasa à waŋ, azlaməna madiŋal gəl à vok tahamà gay à vok gesina la slaka tekula la abà. ");
INSERT INTO mfh_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Katskats tatsənà masləh məlo bokuba maho­humay aŋa məŋ kular, asa à ahəŋ la zagəla, ŋgaha ahənà gày uwana ala, atà la aku gesina. ");
INSERT INTO mfh_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","La abatà azla­tatak anik tapàhla vok ala bokuba azlaalàh akàl; taslə̀hà gəl à ahəŋ, tadzàh à kəla uwa­be­yuwi aŋatà à gəl gesina. ");
INSERT INTO mfh_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Gesina aŋatà tahə̀n ala la Masasəɗok Zəzagəla, ŋgaha tadzəkà maɓaɗma la azlagay gudəŋ anik anik, bokuba uwana Masasəɗok avà à atà kà mapəhay. ");
INSERT INTO mfh_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","La kaslà uwatà azla Yahu­diya uwana tanəfà mapəhay aŋa fəla aŋatà, la ahəŋ la Uru­sa­lima, tasà à waŋ la azla­kutso anik anik la abà gesina, tasà à waŋ kà madz à ahəŋ la Uru­sa­lima. ");
INSERT INTO mfh_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Mok uwana tada­tsən maho­humay uwaga, tasà à waŋ, tahamà gay à vok. Ləv avàlàh à atà à gay gesina aŋatà, kà uwana kəla uwa­be­yuwi aŋatà kà atsənàŋ kà tapə̀h gay kà la gay gudəŋ aŋha. ");
INSERT INTO mfh_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kiya uwaga gesina aŋatà ləv avàlàh à atà à gay, gəl akàɗ à atà à vok, tagòɗ: “Azladza uwanay tavats gay kà, kà azla Galili aw takay? ");
INSERT INTO mfh_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ŋgaha ma, uwanay ma kakay apaka vok, kà kəla uwa­be­yuwi gami atsəna kà tapəhay kà la gay gami uwi? ");
INSERT INTO mfh_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tsa tekeɗik kà azladza uwanay tasà à waŋ la kutso Partiya, Medi, Elam, Me­so­po­tami, Yahu­diya, Kapa­dotsəya, tsəràh à Asəya. ");
INSERT INTO mfh_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ŋgaha la Fərizi, Pamfi­liya, Misəra, ŋgaha la kutso aŋa Libiya uwana nekwa la Səren, azlaanik la tataka gami la abà, tasà à waŋ la Rom, ");
INSERT INTO mfh_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","azla­uwana azla Yahu­diya slilih gà la azla­uwana tapakàh azla Yahu­diya mapakay, azlaanik uwana tasà à waŋ la Kəreta ŋgaha azlaanik la Arabiya. Ama ku bà la uwaga bay kà, kəla uwa­be­yuwi gami atsəna kà tapəhay lakəl aŋa sləray məŋga aŋa Zəzagəla la gay gudəŋ aŋha!” ");
INSERT INTO mfh_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ləv avàlàh à atà à gay gesina, tasə̀l uwana tapəhay aw, tagòɗ kà atà à atà: “Uwanay ma, mana asal magoɗay mi?” ");
INSERT INTO mfh_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ama bà la uwaga kà azlaanik takəɗàsl azlaməna madiŋal gəl à vok la magoɗay: “Ndzer, azladza uwanay kà guzu adakaɗ atà à gay.” ");
INSERT INTO mfh_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Hadzak Piyer asà à afik la azlaməna matapla kulo gəl aŋha tekula gà uwanay, azà kuda à zagəla, agòɗ à maham à ahəŋ dza: “Akul azla Yahu­diya, ŋgaha akul uwana kadzaw à ahəŋ la Uru­sa­lima la abà gesina, sə̀làw, tsə̀ɓàw sləm à gay uwanay gəpəh à akul lagwa. ");
INSERT INTO mfh_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kay, azladza uwanay kà, guzu adakaɗ atà bokuba uwana kagoɗaw aw, kà uwana bà zil gosila bay kà, adaslay dadàŋ aw. ");
INSERT INTO mfh_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ama kà magəɗ uwana à afik, masla mapəhal gay à ahàl Yoyel apə̀h: ");
INSERT INTO mfh_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Zəzagəla agòɗ: ˈKiya uwanay à uwana adàpaka vok la madəv à gay mahənay: Gədà­sləl Masasəɗok gulo à ahəŋ à azladza à gəl gesina; azlabəza aŋkul, la azla­ko­hana aŋkul, la azla­ma­kozga aŋkul masa­siŋay adà­sa­si­ŋahla atà, gədàɓəɗahà atà à ama la abà, tapàh paŋaw gulo. ");
INSERT INTO mfh_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ndzer, haɗay gədà­sləh Masasəɗok gulo à gəl aŋa azla­ma­gamza gulo, azla­zilga, la azla­misga la mavakay uwatà Ŋgaha tadà­pahah à azladza. ");
INSERT INTO mfh_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Gədà­ɗahah azla­na­dzipo la zagəla ŋgaha la vəɗah, aŋiz, akàl ŋgaha habaga la azla­kəsək tadà­gahay la ahəŋ, ");
INSERT INTO mfh_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Afats adàtəfa zagəla, Təla adàgay mativga vikuza, bokuba aŋiz. La lig la ahəŋ kà pəra, mavakay aŋa Sufəl uwana mazləɓayga, aŋa mas à waŋ. ");
INSERT INTO mfh_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kəla dza uwana atsal sləm aŋa Zəzagəla agay adàɓəlay!ˈ” ");
INSERT INTO mfh_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Akul azla Isərayel, tsə̀ɓàw sləm à uwanay gəpəhay”, Piyer agòɗ à atà. “Yesu zil Nazaret uwana Zəzagəla aslə̀l à waŋ, apə̀hla maslay aŋha ala, la maɗàh azla­na­dzipo la azla­masəlay anik anik la tataka aŋkul la abà, akul babay kasəlaw. ");
INSERT INTO mfh_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Zəzagəla avà à ahàl aŋkul bokuba uwana awoyàŋ kà uwana dagay uwarà, asə̀l uwana kadà­ɗa­haw­wallaŋ à vok. Gay gà la uwaga kavàw masla à ahàl aŋa azlaməna tsakana kà mazləlay à ahàf à adi kà mamətsay. ");
INSERT INTO mfh_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ama Zəzagəla awùlla à uda la mamətsay, adzà à ahəŋ la sifa aya. Ndzer kà, masla kà agə̀ɗ à ndzəɗa aŋa mamətsay à ahàl aw. ");
INSERT INTO mfh_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","David apə̀h lakəl aŋha kà: ˈKok­si­koksi gənəŋə̀ŋ Sufəl gulo la yewdi gulo, agà la ahàl kaf gulo, kà gi aŋa mago­gotsay aw. ");
INSERT INTO mfh_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Gay gà la uwaga, ləv gulo adahən ala la marabay, ŋgaha gay gulo uwana gəpəhay kà matsi­ɗayga, Baməraka gi la sləɓ vok pəra, gədàf manəwəŋ gulo à masla à afik. ");
INSERT INTO mfh_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kadàsak gi la ahàl aŋa mamətsay aw. Kadàkəsay kà sləɓ vok aŋa kohana aŋak amazinla aw. ");
INSERT INTO mfh_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kak, kapə̀hgəla tetəvi uwana adala gi à sifa à abà, Gi la marabay kà uwana kak la gi.ˈ” ");
INSERT INTO mfh_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Azla­deda gulo, azlayla gi gəpəh à akul la paraka lakəl aŋa Baba gami madzi­dziga David; masla kà amə̀ts tallà, zəvay aŋha la ahəŋ la tataka gami la abà tsəràh à lakana. ");
INSERT INTO mfh_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Masla mapəhal gay ahàl aŋa Zəzagəla asə̀l kà Zəzagəla azùwal mawaɗay la magoɗal: ‘Gədà­kəsani à uda tekula la mayyi tsəh ala aŋak la abà, gədàfa à sufəl à abà.’ ");
INSERT INTO mfh_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David asə̀l dagay uwarà lakəl aŋa mawul à uda aŋa dza, uwana mafal dzakwa à gəl gà, kà uwaga agòɗ: ˈGəsakal la mezewi aw ŋgaha vok aŋha azin ala aw.ˈ Zəzagəla agòɗ.” ");
INSERT INTO mfh_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Piyer agòɗ aya: “Zəzagəla awùlla Yesu uwanay à uda la mamətsay, anu azlaməna sayda aŋa uwaga gesina. ");
INSERT INTO mfh_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Zəzagəla Baba atsìzllàŋ à ahàl kaf aŋha, ŋgaha avàl Masasəɗok uwana apə̀h à ahəŋ, masla aslə̀h anu à ahə̀ŋ à gəl à uwana kanəŋàwwàŋ la uwana katsənàwwàŋ lagwa. ");
INSERT INTO mfh_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David kà, masla kà ahàd à zagəla aw, ama apə̀h gay lakəl aŋa dza uwana tafal dzakwa à gəl, agòɗ: ˈSufəl Zəzagəla gulo agòɗ à sufəl gulo: ‘Dzà aŋak à abanay la ahàl kaf gulo lakəl. ");
INSERT INTO mfh_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Tsəràh à uwana gədàɓək azlaməna məzam aŋak à tsəh à asik aŋak, kà maf asik à afik aŋak.’ˈ” ");
INSERT INTO mfh_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Kità gəgoɗ à akul à azla Isərayel, ndzer kasəlaw kà, akul kazlə̀llàw Yesu uwanay à ahàf à adi, masla la uwana Zəzagəla apakàŋ ala kà Sufəl, ŋgaha afàl dzakwa à gəl.” ");
INSERT INTO mfh_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Uwana tatsə̀n gay uwaga kà, ləv avàlàh à atà à gay gesina. Tanavà Piyer la azlaməna matapla anik: “Azla­deda, mana à uwana məɗehəŋ ma?” ");
INSERT INTO mfh_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piyer agòɗ à atà: “Pə̀hàw gay la ləv ala, ŋgaha kəla uwa­be­yuwi aŋkul taɗa­halla batem la sləm aŋa Yesu Kristu kà tsakana aŋkul aŋa mama­tsilla. Ŋgaha Zəzagəla adàvà à akul Masasəɗok aŋha. ");
INSERT INTO mfh_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kà uwana mapəh à ahəŋ aŋa Zəzagəla kà aŋkul, la mayyi à tsəh ala ŋgaha kà aŋa azla­uwana kərkər gà, kà aŋa azla­uwana Sufəl Zəzagəla gami adàzala à atà gesina.” ");
INSERT INTO mfh_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kiya uwaga Piyer apəh à atà azlagay anik anik aya, kà maɓaz atà à tsəh, ŋgaha kà madzərəɗàh atà ala la magoɗ à atà: “Sàw à uda la tataka aŋa azladza uwana takəs Yesu aw, yàhàw kà Zəzagəla aŋa maɓəl akul pəra.” ");
INSERT INTO mfh_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Aŋuvaw la tataka aŋatà la abà tadìŋ gəl à gay aŋa Piyer à vok ŋgaha taɗahà à atà batem. La mavakay uwatà dza dəbow makər azà à vok à azlaməna matapla à adi. ");
INSERT INTO mfh_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tavà vok aŋatà kà matsəɓ sləm à uwana à azlaməna matapla tapə̀hatàla, tadzà à ahəŋ la mazuw tatak may tekula la abà, ŋgaha tazàw tatak may la slaka tekula babay, ŋgaha la madəv kuɗa à Zəzagəla la slaka gà. ");
INSERT INTO mfh_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Azla­na­dzipo la azla­masəlay aŋuvaw taɗa­hàhà vok la ahàl aŋa azlaməna matapla, ŋgaha ləv avàlàh à azladza à gay. ");
INSERT INTO mfh_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Azlaməna madiŋal gəl à vok tagà tekula, ŋgaha tahamà gay à tatak aŋatà à vok la slaka gà gesina. ");
INSERT INTO mfh_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tadawàh azlaàlàk aŋatà ala la azla­ləmana aŋatà, tavàhàh sili gà la tataka aŋatà la abà uwa­be­yuwi kəla udəra aŋha. ");
INSERT INTO mfh_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kəla mavakay tahamà gay à vok la məŋ gày Zəzagəla la aku, tazàwàh tatak may aŋatà la slaka gà la mtəga la ləv tekula la marabay. ");
INSERT INTO mfh_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tazlə̀ɓàhàh Zəzagəla, ŋgaha azladza gesina tawo­yàhà atà. Kəla mavakay Sufəl Zəzagəla azàhà à atà ala azla­uwana à adi asal maɓəl atà. ");
INSERT INTO mfh_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Vərdi anik, Piyer atà la Yuhana tahàd à məŋ gày Zəzagəla à agu kà madəv kuɗa la gay mokokhu, la kaslà aŋa madəv kuɗa. ");
INSERT INTO mfh_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Deri anik la ahəŋ la gay gamagày uwana tazalalla gamagày delga, masla kà deriga dagay mayyay məŋ aŋha. Kəla mavakay azladza tadàhla à gay gamagày uwaga, kà masla aŋa matsatsàh tatak la slaka azlaməna mad à gày à agu. ");
INSERT INTO mfh_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Piyer atà la Yuhana tadà à gày kà, anavà atà à tatak. ");
INSERT INTO mfh_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ama Piyer atà la Yuhana tatsə̀kal yewdi à gay, ŋgaha Piyer agòɗal: “Nərə̀z anu!” ");
INSERT INTO mfh_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Dza uwaga anərə̀z atà la tsetsi dadàŋ, adzùgw kà aɓəz tatak la ahàl aŋatà. ");
INSERT INTO mfh_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Piyer agòɗal: “Tetuwa sili aga gi la ahàl aw, ama uwana gəkoray gəvà à ka. La sləm aŋa Yesu Kristu, zil Nazaret, sà à afik, hàd, gəgoɗ à ka!” ");
INSERT INTO mfh_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ŋgaha akə̀s la ahàl kaf, atsìzllàŋ ala, katskats asik la azla­ma­ta­ko­la ta­kola aŋha tadzərə̀ɗàhà ala. ");
INSERT INTO mfh_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Hadzak, atsìzlla ala, dza­ra­dzara, ahàd, tadà à məŋ gày Zəzagəla à agu la azlaməna matapla la mavalàh à zagəla, ŋgaha la mazləɓ Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Maham à ahəŋ dza anəŋà deri uwaga, aday la mazləɓ Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Uwana tasə̀l kà, uwaga kà deri uwana adzàhà madzay kà matsatsàh tatak la gày gamagày aŋa məŋ gay Zəzagəla uwana tazala ala gamagày delga kà, ɓəɗək, ləv avàlàhà à atà à gay kà tatak uwana apakà vok. ");
INSERT INTO mfh_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Piyer atà la Yuhana talə̀g la golav aŋa məŋ gày Zəzagəla uwana la abà tazalalla: Golav aŋa Salomon. Dza uwaga asàk atà à ahəŋ aw. Kiya uwaga azladza tasàhà à waŋ à slaka aŋatà la mahoyay, kà uwana ləv avàlàhà à atà à gay kà uwaga. ");
INSERT INTO mfh_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Mok uwana Piyer adanəŋ uwaga kà apə̀h gay à maham à ahəŋ dza, agòɗ à atà: “Akul azla Isərayel, kà mana ləv avàlàhà à akul à gay ma? Kà mana kanərəzaw anu bokuba anu la uwana matsizlla dza uwanay ala la ndzəɗa aŋa aslasl gəl gami ma, la manəf fəla gami lela ma? ");
INSERT INTO mfh_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Awaŋ, Zəzagəla aŋa azla­baba gami madzi­dziga, aŋa Abəraham, aŋa Isak, ŋgaha aŋa Yakuba uwana tadaval kuɗa, avà mazləɓay à Kona aŋha. Uwana akul la gəl aŋkul kavàw à ahàl aŋa azlaməna makor dza kapù­wàwwalla gudzi à gəl la huma Pilatus, à mok uwana masla adzùgw maduwal à gəl. ");
INSERT INTO mfh_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kakwèsàw kà dza dziriga, səta­kaga, ŋgaha kanavàw la slaka Pilatus kà maduw à akul gəl à masla makaɗ dza. ");
INSERT INTO mfh_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kiya uwaga kakə̀ɗàw Madza­haga aŋa sifa, ama Zəzagəla awùlla à uda la mamətsay, anu kà anu azlaməna sayda aŋa uwaga. ");
INSERT INTO mfh_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ama kà aŋa dza uwanay kà, kanəŋawwaŋ; kasəlaw uwaga kà: Ndzəɗa aŋa Yesu la uwana avàl ndzəɗa uwanay, madiŋ gəl à Yesu à vok la uwana awurà dza uwanay ala la huma yewdi aŋkul.” ");
INSERT INTO mfh_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Azla­deda, mok uwana azla­ma­siga aŋkul kapùwàw gudzi à Yesu à gəl, la azla­ma­siga aŋkul kà, gəsəl kà la masəl gəl gà, kaɗahàw uwaga aw. ");
INSERT INTO mfh_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Iyay, kiya uwanay à uwana Zəzagəla agəɗàŋ gay aŋha uwana à afik, apə̀h à azlaməna mapəh à atà gay à ahàl aŋha uwarà, kà uwana apə̀h à ahəŋ kà Kristu adàs ŋgərpa, agòɗ. ");
INSERT INTO mfh_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","La kità kà, pə̀hàw gay la ləv ala, gòla vok à slaka Zəzagəla, kà masla aŋa mama­tsa­kulla tsakana aŋkul ala. ");
INSERT INTO mfh_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kiya uwaga Zəzagəla adàsak akul ala zamana lapiya à waŋ, ŋgaha adàsləl akul Kristu uwana à waŋ apə̀h à ahəŋ uwarà kà aŋkul, uwaga kà Yesu. ");
INSERT INTO mfh_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ama kà aŋa diŋa kà, Yesu adzà à ahəŋ la zagəla tsəràh à uwana Zəzagəla apakàh azla­tatak ala kà mawga dadàŋ, bokuba uwana apə̀h à azlaməna mapəh à atà gay à ahàl dagay uwarà. ");
INSERT INTO mfh_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Təga kà Musa agòɗ kà: ˈSufəl Zəzagəla aŋkul adàsləl akul masla mapəhal gay à ahàl à waŋ bokuba gi, uwana adàgay tekula la mayyi à tsəh ala aŋkul la abà. Kadàtsəɓaw sləm à uwana adàtapakulla gesina. ");
INSERT INTO mfh_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ama kəla uwa­be­yuwi uwana adàtsəɓ sləm à masla mapəhal gay à ahàl uwatà aw kà, adàdza à ahəŋ la tataka aŋa azladza aŋa Zəzagəla la abà aw, tadàkaɗ atà.ˈ ");
INSERT INTO mfh_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Amiyaka azlaməna mapəh à atà gay à ahàl anik babay kà, tapàh bokuba aŋa Musa lakəl aŋa tatak uwana adàpaka vok la zamana gami, dagay Samuyel, ŋgaha la azla­uwana la lig aŋha la ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Azla­deda, mapəh à ahəŋ uwana Zəzagəla apə̀h à ahəŋ la azlaməna mapəh à atà gay ahàl kà, kà aŋkul, kiya uwaga babay à uwana Zəzagəla akə̀s vok slawda la Abəraham: ˈGədàpis azlatsəhay gudəŋ à vok gesina la tsəhay aŋak,ˈ agòɗ, ˈMakəs vok slawda uwaga kà, kà aŋkul.ˈ ");
INSERT INTO mfh_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kà uwaga à uwana Zəzagəla aslə̀l à akul Kona aŋha à waŋ, à akul tsəhay aŋha teraŋa. Aslə̀l à akul à waŋ aŋa mapəh à akul ala dabaray, kà akul aŋa mas à uda la mawi­siga aŋkul la abà, ŋgaha kà masla aŋa mapis à akul gay à vok.” ");
INSERT INTO mfh_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Mok uwana Piyer atà la Yuhana tapə̀h gay à maham à ahəŋ dza aya kà, azlaməna mav tatak à Zəzagəla tasà à waŋ, la məŋga aŋa azlaməna manəŋla məŋ gày Zəzagəla, ŋgaha la azla Sadu­kiya uwana tagòɗ kà: Mawul à uda la mamətsay la ahəŋ aw. ");
INSERT INTO mfh_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tapakà ləv lakəl aŋatà, kà uwana azlaməna matapla tatapla à azladza kà, azladza tadàwul à uda la mamətsay. ");
INSERT INTO mfh_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kà uwana vəɗ adasa à waŋ, takàs atà kà, tawùts atà à daŋay tsəràh à bebəŋ. ");
INSERT INTO mfh_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tekeɗik aŋuvaw uwana tatsə̀n mapəhay aŋatà uwaga kà, tadìŋal gəl à vok, kiya uwaga matugway aŋa azlaməna madiŋal gəl à vok azigə̀n tsəràh azladza dəbow zlo. ");
INSERT INTO mfh_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","La bebəŋ gà, azlaməŋga aŋa azla Yahu­diya, la azla­ma­siga, la azlaməna mapàhla wakità seriya ala tahamà gay à vok gesina aŋatà la Uru­sa­lima. ");
INSERT INTO mfh_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Hanas, məŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla la ahəŋ, la Kayyif, la Yuhana, la Ale­kəsander ŋgaha la azla­uwana la huɗ gày aŋa məŋ madza­haga gesina. ");
INSERT INTO mfh_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tadàla azla Piyer la Yuhana à huma aŋatà, ŋgaha tanavà atà gay ala: “La ndzəɗa ma aŋa uwa, awma la sləm aŋa uwa kawuràwla masla ɗuvats ala uwa?” ");
INSERT INTO mfh_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Masasəɗok ahənà Piyer ala, ŋgaha agòɗ à atà: “Akul, azlaməŋga aŋa azla Yahu­diya, la azla­ma­siga, ");
INSERT INTO mfh_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kanavàw anu gay ala lakana, kà uwana məɗahà delga la mawur deri ala. ‘Kakay awùr ala mi?’, kagòɗàw. ");
INSERT INTO mfh_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Haɗay zlà, delga kasəlaw gesina, akul azladza Isərayel, masla uwana kazlə̀làw à ahàf à adi, à Yesu zil Nazaret, Zəzagəla awùlla à uda la mamətsay. ");
INSERT INTO mfh_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Lakəl aŋa Yesu uwanay, à uwana wakità Zəzagəla apə̀h lakəl aŋha agòɗ: ˈAkur uwana akul azlaməna maŋal gày kadù­wàwla, masla la uwana adapak akur mawaɗ gày.ˈ ");
INSERT INTO mfh_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kiya uwaga gəgòɗ à akul: Zəzagəla aɓə̀l dza baməraka tekula kokuɗa masla aw. Dza anik la ahəŋ tetuwa à uwana Zəzagəla asləl à waŋ à gudəŋ à vok kà maɓəl azladza aw.” ");
INSERT INTO mfh_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Azladza uwaga ləv avàlàhà à atà à gay kà uwana tanəŋà mawaɗ vok à uda aŋa Piyer atà la Yuhana, ŋgaha bay kà, tasə̀l kà tadà à nekol aw, tasə̀l la gəl aŋatà kà atà kà azlaməna matapla la slaka aŋa Yesu. ");
INSERT INTO mfh_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ama uwana tanəŋà dza uwana awurà ala atsìzl à ahəŋ la makəla aŋatà kà, taslàla vok kà mapəh à atà gay aw. ");
INSERT INTO mfh_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tavà à atà tetəvi kà mas à uda, kà atà aŋa makəs sawaray aŋatà kà atà kà atà. ");
INSERT INTO mfh_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tagòɗ à vok: “Mana məɗehəŋ à azladza uwanay à vok ma? Kà uwana azlaməna madz à ahəŋ la Uru­sa­lima gesina tasəl la paraka kà nadzipo uwanay apakà vok ndzer, uwala anu babay à waŋ məslala vok aŋa magoɗay aw. ");
INSERT INTO mfh_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ama asa à anu gay uwanay atsən ala kà masəlay aŋa azladza aw, lagwa kà məɗəɗ à atà gay à ahəŋ lakəl aŋa Yesu.” ");
INSERT INTO mfh_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ŋgaha tazàla à atà à gày aya, tavə̀r à atà gay kà matapla sləm aŋa Yesu à azladza. ");
INSERT INTO mfh_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ama Piyer atà la Yuhana tawùlla à atà ala: “Akul la gəl aŋkul à kà nàtsàw gay uwaga ala. Delga la huma Zəzagəla kà makəs gay aŋkul ay, awma aŋa Zəzagəla takay? ");
INSERT INTO mfh_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ama anu kà, məslala vok aŋa masak mapəh uwana mənəŋàŋ la uwana mətsənàŋ aw.” ");
INSERT INTO mfh_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Uwana azladza uwaga taslàh à atà məl à gəl kà tasàk atà. Taɓəzà tetəvi kà madukw à atà seriya à gəl aw, kà uwana azladza gesina tazlə̀ɓà Zəzagəla lakəl aŋa tatak uwana apakà vok gesina. ");
INSERT INTO mfh_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Dza uwana awurà ala la nadzipo uwaga kà, mavay aŋha kà aɗuwa dzik ufaɗ. ");
INSERT INTO mfh_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Uwana tadùw à atà gəl kà, Piyer atà la Yuhana tahàd à slaka azlaməna aŋatà, ŋgaha tatùgw atà uwana azlaməŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla, la azla­ma­siga tapə̀h à atà. ");
INSERT INTO mfh_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Uwana tatsə̀n uwaga kà, tadəv kuɗa à Zəzagəla la ləv tekula: “Zəzagəla gami, kak la uwana kaɗahà zagəla, la kutso, la dərəv ŋgaha la azla­tatak uwana la abà gesina. ");
INSERT INTO mfh_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kak la uwana kapə̀h à anu la Masasəɗok aŋak la paŋaw aŋa baba gami madzi­dziga David, magamza aŋak uwana agòɗ: ˈKà mana azladza gudəŋ à vok tapakàh, azla­va­làhà ma? Kà mana azladza tadzàhkà maɗàh dabaray deyday gà ma? ");
INSERT INTO mfh_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Azla­su­fəl aŋa gudəŋ à vok taɗahà vok à ahəŋ kà aŋa guvəl, Ŋgaha azlaməŋga bay tatsə̀n vok gay Lakəl aŋa Sufəl Zəzagəla ŋgaha lakəl aŋa Kristu aŋha, (Masla mafal dzakwa à gəl gà).ˈ ");
INSERT INTO mfh_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ndzer, apakà vok la abanay la Uru­sa­lima, Herod la Pontsəyus Pilatus, la azladza à uda gà ŋgaha la azlatsəhay Isərayel tahamà gay à vok gesina lakəl aŋa Yesu, magamza tsi­ka­slaga aŋha, uwana mafal dzakwa à gəl gà. ");
INSERT INTO mfh_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tahamà gay à vok kà maɗàh uwana kadzùgw à ahəŋ gesina dagay uwarà la mawoyəŋ aŋak la abà. ");
INSERT INTO mfh_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Sufəl, lagonay kà, tsə̀n à maslah məlo aŋatà tsi, lagwa kà, và maslay à azla­ma­gamza aŋak kà mapəh gay aŋak la mawaɗ vok à uda gesina zlà. ");
INSERT INTO mfh_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Lagwa kà, và à anu maslay aŋak kà maɗàh azla­na­dzipo anik anik la sləm aŋa Yesu, Kona aŋak zlà.” ");
INSERT INTO mfh_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Mok uwana tadadəv madəv kuɗa à gay kà, slaka uwana atà la abà aɓəlàkà à vok. Tahə̀n ala gesina aŋatà la Masasəɗok Zəzagəla, ŋgaha tapə̀h gay Zəzagəla la mawaɗ vok à uda. ");
INSERT INTO mfh_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Azlaməna madiŋal gəl à vok tagà la ləv tekula la matsən vok gay lela. Dza la ahəŋ “Ləmana kà, kà aŋulo pəra”, agòɗ la tataka aŋatà la abà aw. Uwana takòr gesina kà, taɗahà vok huŋwa à vok la tataka aŋatà la abà aw. ");
INSERT INTO mfh_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Azlaməna matapla tazà sayda lakəl aŋa Yesu kaykay, tagòɗ kà Yesu awùl à uda la mamətsay: “Mənəŋàŋ”, tagòɗ. Ŋgaha Zəzagəla apisà gay à azlaməna madiŋal gəl à vok à vok. ");
INSERT INTO mfh_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Dza la ahəŋ la tataka aŋatà la abà, kuɗa akə̀s aw, kà uwana azlaməna àlàk, la azlagày la ahəŋ, tadawàh ala la tataka aŋatà la abà, ŋgaha tasàhla sili gà à waŋ. ");
INSERT INTO mfh_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Taɓàkàh à slaka azlaməna matapla, la lig la ahəŋ tavà­hàhà sili uwaga, kəla udəra aŋa dza. ");
INSERT INTO mfh_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Bokuba Yusufu, zil Levi la kutso Sipəre uwana azlaməna matapla tazàlal Barnabas. (Barnabas asal magoɗay: Masla maɓəllafàh azladza ala) ");
INSERT INTO mfh_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Masla adùw àlàk aŋha ala, asə̀lla sili gà à slaka azlaməna matapla gesina. ");
INSERT INTO mfh_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ama dza anik la ahəŋ, uwana sləm aŋha Ana­niyas, atà la mis aŋha Safira, tadùw àlàk aŋatà ala la matsən vok gay lela. ");
INSERT INTO mfh_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Atə̀mla sili à mtəga, ŋgaha adàla uwanay à huma aŋa azlaməna matapla la kokuɗa masəlay aŋatà, ama mis aŋha kà asə̀l uwaga. ");
INSERT INTO mfh_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kiya uwaga Piyer agòɗal: “Ana­niyas, kà mana kavà tetəvi à seteni, ahàd à ləv aŋak à tsəh kà mavavar Masasəɗok Zəzagəla la matəmla sili aŋa àlàk aŋak, uwanaw kadù ala à mtəga ma? ");
INSERT INTO mfh_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mok uwana kaləg madula kà bà àlàk aŋak. Uwana kaduwla, bay sili gà bay, bà kà kak kakoray. Kà mana kadzugw la ləv aŋak kà maɗàh tsəhay mawi­siga uwanay ma? Fida kà kaɗahàŋ kà à dza aw, ama à Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Uwana Ana­niyas adatsən gay uwaga kà, atə̀ɗ à vəɗah, amə̀ts. Azladza uwana tatsənà uwaga gesina kà, guba məŋga akə̀s à atà. ");
INSERT INTO mfh_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Azla­ko­hana tasà à waŋ, tafa­fàɗal lukut à adi, tazə̀ɓ à uda, tallà. ");
INSERT INTO mfh_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Zwek, tatak aŋa sa makər adada à lig, mis aŋa Ana­niyas adà à gày kokuɗa masəl uwana apakà vok. ");
INSERT INTO mfh_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piyer anavàl à gay ala magoɗal: “Pə̀h à gi, uwanay sili aŋa àlàk aŋkul uwana kadù­wàwla pəra takay?” Mis agòɗal: “Iyay, bà masla gà la uwaga.” ");
INSERT INTO mfh_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kiya uwaga Piyer agòɗal: “Kà mana katsənàw vok gay kà matap Masasəɗok Sufəl ma? Tsənàŋ, azla­uwana tallà zil aŋak kà, atà la uwaga tatsà à gày la gày gamagày, ŋgaha tadàzəɓ ka, talla ka!” ");
INSERT INTO mfh_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","La kirim yewdi, atə̀ɗ à makəla à asik aŋa masla matapla, ŋgaha amə̀ts. Azla­ko­hana tasà à gay, taɓə̀zal à gəl kà mamətsay gà; tazə̀ɓ, ŋgaha tadàla, tallà à makəla aŋa zil aŋha. ");
INSERT INTO mfh_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Guba məŋga akə̀s azlaməna gay Zəzagəla la azladza anik gesina uwana tatsənà gay uwaga. ");
INSERT INTO mfh_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Azlaməna matapla taɗa­hàhà azla­na­dzipo la masəlay anik anik la tataka azladza la abà. Azlaməna madiŋal gəl à vok gesina tahà­màhà gay à vok la ləv tekula la golav aŋa Salomon la abà. ");
INSERT INTO mfh_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Dza uwana adìŋal gəl à vok aw kà, aslàla vok kà maham gay à vok atà nna aw. Kay nəma kà, azladza tawoyà à atà! ");
INSERT INTO mfh_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Azladza aŋuvaw tasàhà à waŋ, azlazil la azlamis tadìŋ gəl à Zəzagəla à vok, ");
INSERT INTO mfh_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","kà azla­na­dzipo uwana azlaməna matapla taɗa­hàhàŋ. Azladza tasàhla azlaməna ɗuvats à azla­tetəvi à ama à waŋ aŋuvaw. Tahà­nàhà atà à azlakəslah à afik, la azla­butsi, kà makud mad à awtày aŋa Piyer, kà maguwa aŋha à kəl ala aŋa dzəgay aŋha. ");
INSERT INTO mfh_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Azladza aŋuvaw tasàhà à waŋ la azla­gu­dəŋ uwana la abà la makəla aŋa Uru­sa­lima. Tasàhla azlaməna ɗuvats à waŋ, la azladza uwana zagəla zagəla agà à atà lakəl, gesina aŋatà tawarà ala. ");
INSERT INTO mfh_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Məŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla la azla­uwana tagà la masla, bokuba magoɗay azla Sadu­kiya, tagà la maŋor lakəl aŋa azlaməna matapla, ŋgaha tadzəkà matərəɓ atà. ");
INSERT INTO mfh_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kiya uwaga takàs azlaməna matapla, tawùts atà à daŋay. ");
INSERT INTO mfh_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ama la huɗ aŋa vəɗ kà, malika aŋa Zəzagəla asà à ahəŋ, apə̀zl gamagày aŋa gày daŋay, asə̀lla azlaməna matapla à uda, ŋgaha agòɗ à atà: ");
INSERT INTO mfh_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Dàw à məŋ gày Zəzagəla à agu, ŋgaha zàw gay aŋa sifa adəv à gay aw à azladza!” ");
INSERT INTO mfh_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Azlaməna matapla takə̀s. Bəŋ la zay la tsəh, tahàd à məŋ gày Zəzagəla à agu kà matapla azladza. La vuɗ uwatà kà, məŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla, ŋgaha la uwana la abatà gesina tahamà gay à vok la azla­ma­siga aŋa azla Yahu­diya, takə̀s sawaray ŋgaha taslə̀l azladza kà madka azlaməna matapla à daŋay. ");
INSERT INTO mfh_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Uwana azlaməna masləlay tabəzà daŋay kà, taɓə̀z atà aw. Tawùl, tapə̀h à azlaməna sawaray: ");
INSERT INTO mfh_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Məhàd à daŋay kà, azla­ga­magày kà matsa­ka­hayga lela, azlaməna manəŋla gamagày tagà la slaka aŋatà la abà la gay gamagày. Ama mapəzl gamagày kà, dza la aku aw.” ");
INSERT INTO mfh_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Uwana məŋga aŋa azlaməna manəŋla məŋ gày Zəzagəla, la azlaməŋga aŋa azlaməna mav tatak à Zəzagəla tatsə̀n uwaga kà, gəl akàɗ à atà à vok, tasə̀l uwana tadzugway aya lakəl aŋa azlaməna matapla aw, ŋgaha tana­vàhà vok uwana adapakà vok. ");
INSERT INTO mfh_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kiya uwaga hazlaŋ, dza anik asà à waŋ, agòɗ à atà: “Tsənàwwàŋ tsi! Azladza uwana kakàsàw atà, kawàtsàw atà à daŋay kà, atà la məŋ gày Zəzagəla la aku, tatapla azladza!” ");
INSERT INTO mfh_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","La abatà məŋga aŋa azlaməna manəŋla ahàd la azladza, ŋgaha tawùlla azlaməna matapla à waŋ. Ama la gasa aw kà uwana guba akə̀s à atà, kà matsàh atà la akur aŋa azladza. ");
INSERT INTO mfh_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Mok uwana tasə̀lla atà à waŋ à huma aŋa sawaray kà, məŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla anavà atà gay ala. ");
INSERT INTO mfh_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Agòɗ à atà: “Mədaɗəɗ à akul gay à ahəŋ kà matapla la sləm aŋa dza uwaga aw ay? Ŋgaha ma, kà mana kaɗa­hàwwàŋ lagwa ma? Kaslə̀hàw matapla aŋkul à Uru­sa­lima à abà gesina, ŋgaha ma asa à akul aŋiz aŋha ma aŋa mawul à anu à gəl takay?!” ");
INSERT INTO mfh_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ama Piyer la azlaməna matapla anik tawùlla à atà ala: “Leri makəs gay aŋa Zəzagəla ɗaɗuwa à gay aŋa azladza. ");
INSERT INTO mfh_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Haɗay, Zəzagəla aŋa azla­baba gami madzi­dziga awùlla à uda la mamətsay, dza uwaga kazlə̀llàw à ahàf à adi. ");
INSERT INTO mfh_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Zəzagəla azə̀ɓ à ahàl kaf aŋha à gəl, apakàŋ ala kà Sufəl, ŋgaha masla maɓələŋ kà mav tetəvi à azla Isərayel kà mapəh gay la ləv ala kà atà aŋa maɓəz mama­tsila aŋa tsakana aŋatà. ");
INSERT INTO mfh_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Haɗay, anu la gəl gami kà, anu azlaməna sayda kà aŋa uwaga, anu la Masasəɗok uwana Zəzagəla avà à azla­uwana takəs gay aŋha.” ");
INSERT INTO mfh_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Mok uwana tatsə̀n gay uwaga kà tapakàh ləv, asà à atà makaɗ azlaməna matapla. ");
INSERT INTO mfh_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","La tataka aŋatà zil Farisəya anik, sləm aŋha Gama­liyel la abà, masla mapàhla mapəhay aŋa Musa ala. Azladza gesina tasləkaway. Uwana azladza anik tapakàh ləv, asà à afik la tataka aŋatà la abà, agòɗ: “ ‘Dàw à uda’, gòɗàw à azladza uwanay dadàŋ.” ");
INSERT INTO mfh_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Mok uwana tasà à uda, agòɗ: “Azla­deda gulo, azla Isərayel, məɗahà haŋkəli la uwana məɗehəŋ à azladza uwanay à vok. ");
INSERT INTO mfh_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Dzùgwàw lakəl aŋa Tewudas uwana avàlla à waŋ uwarà tsi: ‘Gi məŋ dza’, agòɗ, tsəràh à uwana azladza dadərmokw ufaɗ tanəfà. Ama takə̀ɗ, ŋgaha azla­uwana tanə̀f à masla gesina tasləhà gəl à ahəŋ, ama tadə̀v à gay tərzləm. ");
INSERT INTO mfh_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","La lig aŋha la ahəŋ Yudas, zil Galili adzəkà la mok uwana tatùgw dza aya, azàlàh azladza aŋuvaw kà manəf masla, ama takə̀ɗ masla la azlaməna manəfay aŋha gesina, tərzləm. ");
INSERT INTO mfh_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Lagonay kà, gəgoɗ à akul kà, məsəlla à ahàl à azladza uwanay la tsəh ala, tada aŋatà. Baŋa sləray aŋatà uwanay taɗehəŋ atsà à waŋ kà la slaka azladza asik kà, adàzila bay, ");
INSERT INTO mfh_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ama baŋa asà à waŋ kà la slaka Zəzagəla ndzer kà, məslala à vok kà maɗəɗal gay à ahəŋ aw. Məɗahà haŋkəli, məpà guvəl la Zəzagəla aw!” Azlaməna sawaray takə̀s mapəhay aŋa Gama­liyel. ");
INSERT INTO mfh_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tazàla azlaməna matapla à gày, tazlàɓàh atà, tagòɗ à atà: “Kapəhaw la sləm aŋa dza uwaga aya aw, ama lagwa kà dàw aŋkul!” ");
INSERT INTO mfh_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Azlaməna matapla tazà à vok la slaka sawaray la marabay kà uwana azlayla atà la huma Zəzagəla kà mas ŋgərpa kà sləm aŋa Yesu, kà uwana Zəzagəla asəl kà tabasiŋ. ");
INSERT INTO mfh_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ŋgaha kəla mahənay tadà à huma à gay la matapla gay marabəŋ à azladza lakəl aŋa Yesu, uwana Zəzagəla afàl dzakwa à gəl, la məŋ gày Zəzagəla la aku, ŋgaha la gày anik anik. ");
INSERT INTO mfh_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","La kaslà uwana azlaməna matapla tasigla kà azla Yahu­diya uwana tapə̀h gay Gərək la azla­uwana tapə̀h gay gudəŋ aŋatà tagòɗ: “Azlamis kuɗa gami kà, tafà à atà sləm, à mok uwana tavàh tatak may aw”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kiya uwaga azlaməna matapla kulo gəl aŋha səla uwaga tahamà gay à azlaməna asik à vok gesina, ŋgaha tagòɗ à atà: “Anu kà, akəs à anu à vok, kà anu aŋa masak à mapəh gay Zəzagəla, kà mad à gay aŋa tatak may à abà aw. ");
INSERT INTO mfh_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Azla­deda, tsa­tsà­màwnì azladza məɗəf, uwana kasəlaw madz à ahəŋ aŋatà la tataka aŋkul la abà, mahənlaga la Masasəɗok Zəzagəla ŋgaha azlaməna makor haŋkəli gà lela. Ŋgaha mədàɓək à atà sləray aŋa tatak may uwaga à ahàl aŋatà. ");
INSERT INTO mfh_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ŋgaha anu kà, məslala vok aŋa mav vok gami gesina à madəv kuɗa à abà la maz gay Zəzagəla à azladza.” ");
INSERT INTO mfh_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Gay uwaga akəsà vok à azladza uwana tahamà gay à vok gesina. Takà­sànì azladza; Etiyen, uwana adahənla la madiŋal gəl à vok, la Masasəɗok Zəzagəla: la Filip; Pərokor; Nikanor; Timon; Parmenas; ŋgaha Nikolas, zil Anti­yews uwana aɓə̀ɗla vok à tsəhay Yahu­diya à abà dagay uwarà. ");
INSERT INTO mfh_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","La lig la ahəŋ tapə̀hla atà à azlaməna matapla, kà atà aŋa madəv kuɗa lakəl aŋatà la maɓək à atà ahàl à gəl. ");
INSERT INTO mfh_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Gay Zəzagəla asləhà gəl à ahəŋ kaykay. Matugway aŋa azlaməna madiŋal gəl à vok azigə̀ŋ, asigla la Uru­sa­lima, ŋgaha azlaməna mav tatak à Zəzagəla aŋuvaw takàs madiŋ gəl à Yesu à vok. ");
INSERT INTO mfh_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etiyen uwana Zəzagəla apìs ala gay à vok kaykay, agà la ndzəɗa məŋga la tetəvi aŋa Zəzagəla la tsəh, aɗahàhà azla­na­dzipo anik anik la tataka azladza la abà. ");
INSERT INTO mfh_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Azla Yahu­diya anik tasàhà à waŋ la Səren la Ale­kəsan­dəra, la azla­uwana tadə̀v kuɗa la gày uwana la aku, tazalalla gày aŋa azla­mayà mapalla gà, la azla Yahu­diya anik, uwana tasàhà à waŋ la kutso Səlisəya ŋgaha la kutso Asəya, gesina aŋatà tabayà vok gay la Etiyen. ");
INSERT INTO mfh_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ama taslàla vok kà matsizllal à huma aw kà uwana Masasəɗok la uwana avàl haŋkəli. ");
INSERT INTO mfh_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kiya uwaga tasùkw azladza kà atà aŋa magoɗay kà: “Mətsənàŋ apə̀h mawi­siga lakəl aŋa Musa ŋgaha lakəl aŋa Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","La abatà tavədzàhà à tsəh azladza à afik, la azla­ma­siga ŋgaha la azlaməna mapàhla wakità mapəhay ala. Ŋgaha tahamà Etiyen à gəl, tadàlla à huma aŋa azla­ma­siga aŋatà. ");
INSERT INTO mfh_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tadàla azlaməna sayda fidaga uwatà à awtày babay kà mapəh fida lakəl aŋha: “Dza uwanay kà; asak à mapəh mawi­siga lakəl aŋa məŋ gày Zəzagəla gami, ŋgaha lakəl aŋa mapəhay aŋa Musa aw. ");
INSERT INTO mfh_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mətsənàŋ agòɗ aya kà: ‘Yesu zil Nazaret uwaga adà­kalah məŋ gày Zəzagəla gami à ahəŋ, ŋgaha adàɓəɗla madz à ahəŋ uwana Musa avà à anu’, agòɗ aya.” ");
INSERT INTO mfh_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Azladza uwana la gày sawaray la aku gesina tatsə̀k yewdi à Etiyen à gay, tanəŋàŋ kà huɗ adi aŋha kà kalkal la aŋa malika aŋa Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","“Uwanay tapə̀h à ka vok ma haɗay ay?”, məŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla agòɗ à Etiyen. ");
INSERT INTO mfh_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiyen awùlla à uda: “Azla­deda la azla­baba gulo, tsə̀ɓàw à gi sləm. Zəzagəla uwana mazləɓayga apə̀hla vok à baba gami madzi­dziga Abəraham, à mok uwana agà la kutso Me­so­po­tami, à mok uwana aləg maday kà madz à ahəŋ la Karan. ");
INSERT INTO mfh_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ŋgaha agòɗal: ˈSà à uda la gudəŋ aŋak, la huɗ gày aŋak, hàd, kadàdza à ahəŋ la gudəŋ uwana gədàpəhakla!ˈ ");
INSERT INTO mfh_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kiya uwaga Abəraham asà à uda la kutso Kaldiya, ahàd kà madz à ahəŋ la Karan. La lig aŋa mamətsay aŋa Baba aŋha la ahəŋ, Zəzagəla adàlla à kutso uwanay à abà, kadzaw à ahəŋ la abà lakana lagwa. ");
INSERT INTO mfh_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","La abatà kà, bà slaka madiŋ asik à ahəŋ bay, kà aɓə̀zal aw. Ama Zəzagəla apə̀h à Abəraham à vok à abà kà mavàl kutso uwaga, agòɗal: ˈGədàv à ka, ŋgaha mayyi à tsəh ala aŋak la uwana adà­korayˈ agòɗal, te­ke­ɗika, Abəraham kà bəzi aŋha la ahəŋ à mok uwatà aw. ");
INSERT INTO mfh_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Aganay uwana Zəzagəla apə̀h: ˈMayyi à tsəh ala aŋak adàdza à ahəŋ la gudəŋ dza la abatà, tadàgay azla­mayà, ŋgaha tadàtərərəɓah atà tsəràh à mavay dadərmokw ufaɗ. ");
INSERT INTO mfh_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ama gədàɗah seriya à azladza uwana à gəl tadà­tərəɓ atà. La lig la ahəŋ tadàdiy aŋatà la abatà, tadà­kedəɗ à gi à ahəŋ la slaka uwanay lagwa,ˈ Zəzagəla agòɗ. ");
INSERT INTO mfh_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kiya uwaga Zəzagəla akə̀s vok slawda la Abəraham, agòɗal kà: ˈMa­kədəv vok à uda la uwana masəlay aŋa makəs vok slawda uwaga.ˈ Gay gà la uwaga, Abəraham akədə̀v bəzi aŋha Isak à uda la lig mahənay mtəgis la ahəŋ, kiya uwaga babay, Isak akədə̀v Yakuba à uda uwana akədə̀v azlabəza aŋha kulo gəl aŋha səla à uda bay. Atà la uwana takə̀slla azlatsəhay gami ala.” ");
INSERT INTO mfh_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Azlaməna makəsl anu uwaga taɗahàŋ maŋor à deda aŋatà Yusufu à vok, tadùw à azla Misəra ala kà aŋa mayà. Ama Zəzagəla agà la masla. ");
INSERT INTO mfh_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Zəzagəla anə̀ŋla la ŋgərpa uwaga la abà gesina. Avà haŋkəli à Yusufu kà masla aŋa maɓəz mawoyəŋ, la vok matsiɗay la huma aŋa Faruna, sufəl aŋa Misəra. Masla la uwana afà à Yusufu à ahəŋ kà gumna aŋa makoray Misəra, ŋgaha lakəl aŋa huɗ gày aŋha gesina. ");
INSERT INTO mfh_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Mok uwatà kà, may məŋga adzəkà à vok la kutso Misəra la Kanana gesina. Ŋgərpa agà məŋga, ŋgaha azla­baba gami madzi­dziga taɓəzà tatak may kà mazuway aw. ");
INSERT INTO mfh_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Mok uwana Yakuba atsənàŋ kà tatak may la ahəŋ la makoray Misəra kà, aslə̀l azla­baba gami asik tekula dadàŋ. ");
INSERT INTO mfh_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Maday kà masəla uwana tahàd kà, Yusufu apə̀hla vok à azla­deda aŋha, ŋgaha Faruna asə̀l kà azlau­waga kà huɗ gày aŋa Yusufu. ");
INSERT INTO mfh_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","La abatà Yusufu aslə̀l atà kà mazala baba aŋha Yakuba, la azladza gesina uwana la huɗ gày aŋha, gesina aŋatà taslà dza dzik məɗəf gəl aŋha zlo. ");
INSERT INTO mfh_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kiya uwaga Yakuba ahàd à kutso Misəra à slaka uwana amə̀ts à abatà, la azla­baba gami madzi­dziga bay. ");
INSERT INTO mfh_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Talàh atà kà à Səsem à zəvay uwana à agu Abəraham asùkw la gursu, la slaka aŋa tsəhay Hemor.” ");
INSERT INTO mfh_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Mok uwana kaslà adaslay, kà Zəzagəla aŋa mahən mapəhay aŋha uwana ala, aɗahàŋ la Abəraham, tsəhay gami ayyà à tsəh aŋuvaw la kutso Misəra. ");
INSERT INTO mfh_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ŋgaha sufəl mawga uwana asə̀l Yusufu aw adzəkà makor gudəŋ uwaga. ");
INSERT INTO mfh_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Sufəl uwatà ava­và­ràhà tsəhay gami, afàhà à atà leri à gəl kà mamal azlabəza ala, kà azlabəza aŋa mamats à gay. ");
INSERT INTO mfh_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","La zamana uwatà la uwana tayyà Musa, uwana bəzi mahəɗayga. Zəzagəla awoyàŋ. Tanə̀ŋla tsəràh à təla makər la huɗ gày aŋa baba aŋha. ");
INSERT INTO mfh_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Mok uwana tamə̀l à uda, dugu aŋa Faruna azə̀ɓ, adzadzàr bokuba mayyay aŋha. ");
INSERT INTO mfh_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kiya uwaga Musa adzèŋ atsa­tsehà ala la azla­tatak gesina uwana azla Misəra tasə̀l, ŋgaha agà maslay gà la gay la abà, ŋgaha la sləray aŋha la abà gesina.” ");
INSERT INTO mfh_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Mok uwana mavay aŋha adaslay dzik ufaɗ kà: ‘Gəday, gədànəŋ azlaməna gulo azla Isərayel à gay’, Musa agòɗ. ");
INSERT INTO mfh_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Anəŋà zil Misəra atərə̀ɓ tsəhay aŋha, aɓə̀ɗ à huma kà mazla­kəŋ dza uwana tatərəɓəŋ, apə̀l goder, akə̀ɗ zil uwaga. ");
INSERT INTO mfh_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa adzùgw kà azla­deda aŋha tadàsəlay kà: ‘Zəzagəla akəs mapəl atà ala tadà­goɗay’, agòɗ, la mazlak atà aŋha, ama tatsənà godega aŋha aw. ");
INSERT INTO mfh_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","La bəŋ gà Musa abəzà azla Isərayel səla à gəl tazlàɓ vok, asàl kà masəl à atà à vok. Agòɗ à atà: ‘Azla­deda, tsa akul la deda ma, kà mana katərəɓaw vok kà akul à akul ma?’ ");
INSERT INTO mfh_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ama dza uwana atərə̀ɓ anik uwanay, aɗəkà Musa la vok ala, agòɗal: ‘Uwa afà à ka à ahəŋ məŋga baŋaw kà masla seriya lakəl gami uwa? ");
INSERT INTO mfh_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Awma asa à ka makəɗ gi, bokuba uwana kakə̀ɗ zil Misəra lakuhu kəlay?’ ");
INSERT INTO mfh_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Uwana Musa adatsən gay uwaga kà, ahòy aŋha, ahàd, adzà à ahəŋ la kutso Madiyan. La abatà aɓəzà azlabəza zilga səla.” ");
INSERT INTO mfh_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“La lig aŋa mavay dzik ufaɗ la ahəŋ, la mok uwana Musa la fəta aŋa gudəŋ Sənayyi kà, malika aŋa Zəzagəla asà à waŋ, apə̀hla vok à Musa la alàh aŋa akàl uwana abaɓəhay la tsew­wagay la abà. ");
INSERT INTO mfh_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Uwana adanəŋ tatak uwaga kà, ləv avàlal à gay. Ama bokuba uwana azà à vok à awtày nekwa kà manərəziŋ ala kà, kuda aŋa Sufəl Zəzagəla atsə̀n la abà, agòɗ: ");
INSERT INTO mfh_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ˈGi Zəzagəla aŋa Abəraham, aŋa Isak ŋgaha aŋa Yakuba, aŋa azla­baba aŋak madzi­dziga uwaga.ˈ Musa adzəkà masu­kulay dawdadaw kà guba, ŋgaha aslàla vok kà manərəziŋ ala aya aw. ");
INSERT INTO mfh_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Kiya uwaga Sufəl Zəzagəla agòɗal: ˈSərə̀tàh kwimik aŋak la asik ala, kà uwana slaka uwanay kak la abà kà, kutso tsi­ka­slaga, kokuɗa àlàh. ");
INSERT INTO mfh_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Gədanəŋ ŋgərpa aŋa azlatsəhay gulo la Misəra. Gəda­tsən mabas vok aŋatà ŋgaha gəsà à ahəŋ kà mapəlla atà ala. Lagwa kà, sà à waŋ, gəsləl ka à Misəra.ˈ” ");
INSERT INTO mfh_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Sə̀làw azla­deda, azla Isərayel takweskà Musa la magoɗal: ‘Uwa à uwana afà ka à ahəŋ, kà məŋga, ŋgaha kà masla seriya uwa’, tagòɗal. Ama bà la uwaga kà, la lig la ahəŋ Zəzagəla aslə̀l à slaka aŋatà kà magay məŋga aŋatà, ŋgaha kà mapəlla atà ala, la ndzəɗa aŋa malika uwana apə̀halla vok la tsew­wagay la abà. ");
INSERT INTO mfh_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Masla la uwana asə̀lla azladza à uda la Misəra la maɗahàh azla­masəlay la azla­na­dzipo anik anik la abatà, ŋgaha la gay dərəv mativga, ŋgaha la fəta la abà, tsəràh à mavay dzik ufaɗ. ");
INSERT INTO mfh_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Bà Musa uwaga aya gotənaŋ, la uwana agòɗ à azla Isərayel: ‘Zəzagəla adàsləl à akul masla mapəhal gay à ahàl anik à waŋ bokuba gi, uwana adàsa à uda la tsəhay aŋkul la abà.’ ");
INSERT INTO mfh_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Musa gà la uwaga à uwana adzà à ahəŋ la mahəm à ahəŋ aŋa Isərayel la fəta la abà; agà la azla­baba gami madzi­dziga, ŋgaha la malika uwana aɓa­ɗalmà la gudəŋ Sənayyi la afik. La abatà la uwana aɓəzà à azlagay uwana tavà sifa, la slaka Zəzagəla kà mav à anu.” ");
INSERT INTO mfh_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ama azla­baba gami madzi­dziga takə̀s uwaga aw, takweskà, tayàh mawul aŋatà à Misəra. ");
INSERT INTO mfh_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tagòɗ à Haruna: ‘Ɗahà à anu azla­zəzagəla uwana taguwa à anu à huma, kà uwana məsəl tatak uwana aɓəzà à Musa, uwana asə̀lla anu à uda la Misəra aw.’ ");
INSERT INTO mfh_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","La mavakay uwatà taɗahà vəlik luwà­luwà, ŋgaha tavàl tatak. Taràb məŋga lakəl aŋa sləray aŋa ahàl aŋatà. ");
INSERT INTO mfh_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ama la lig aŋa uwaga la ahəŋ, Zəzagəla aguwà à atà ala lig à gay, asàk à atà kà masləkaw azla­tse­tsiliŋ uwana la zagəla, bokuba uwana tatsetsèr à wakità aŋa azlaməna mapəh à atà gay à ahàl à abà: ˈAkul, tsəhay Isərayel kà aŋulo, à uwana kakàɗàw azla­tatak anik anik la mav tatak anik takay? A mavay dzik ufaɗ uwaga la fəta la abà ay? ");
INSERT INTO mfh_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Awaŋ, kazə̀ɓàw gày lukut aŋa Molokw mazlazlay aŋkul, ŋgaha kazə̀ɓàw maftsa à vok aŋa tse­tsiliŋ kà aŋa Refan, mazlazlay aŋkul. Azla­ma­zlazlay uwana kà kaɗahàw atà kà masləkaw atà. Gay gà la uwaga gədàza akul kərkər la Babila.ˈ” ");
INSERT INTO mfh_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Gotənaŋ Etiyen adà à huma à gay, agòɗ: “Mok uwana azla­baba gami madzi­dziga tadzà à ahəŋ la fəta la abà, tagà la gày lukut, uwana tadùw à sahar aŋa makəs vok slawda à gəl, kà atà aŋa masəlay kà Zəzagəla agà la tataka aŋatà la abà. Gày uwatà kà taɗahàŋ kà, bokuba uwana Zəzagəla apə̀hla à Musa, kà maɗehəŋ kalkal la uwana anəŋàŋ. ");
INSERT INTO mfh_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","La lig la ahəŋ, azla­baba gami tavà gày lukut uwaga à mayyi à tsəh ala aŋatà. Mayyi à tsəh ala uwaga kà Josu'e la uwana aguwà à atà à huma kà, mazaɓ kutso aŋa azlatsəhay anik, uwana Zəzagəla akuɗə̀k à atà la huma aŋatà. Gay gà la uwaga, gày lukut adzà à ahəŋ la gudəŋ la abà tsəràh à zamana aŋa sufəl David. ");
INSERT INTO mfh_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David aɓəzà vok mahamay aŋa Zəzagəla, adə̀val kuɗa, kà masla aŋa maɓəzal tetəvi kà maŋalal məŋ gày Zəzagəla à Zəzagəla aŋa Yakuba. ");
INSERT INTO mfh_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ama Salomon la uwana aŋàlal uwaga pəra.” ");
INSERT INTO mfh_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Te­ke­ɗika Zəzagəla uwana la zagəla la afik, adza à ahəŋ la gày uwana la aku azladza taŋàlal aw. Bokuba uwana masla mapəhal gay à ahàl apə̀h. Sufəl Zəzagəla agòɗ kà: ");
INSERT INTO mfh_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ˈZagəla kà kursi gulo, kutso kà slaka maf à asik gulo à ahəŋ. Tsəhay gày ma uwala à uwana kaŋalaw à gi la? Slaka ma uwala asla kà gi aŋa maduw ləv la abà la? ");
INSERT INTO mfh_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Gi la uwana gəɗahàŋ azla­tatak uwaga gesina aw takay?ˈ” ");
INSERT INTO mfh_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Haɗay, akul azlaməna madza­dzaŋàh gəl ala, ləv aŋkul la sləm aŋkul kà, asa à atà matsən gay aŋa Zəzagəla ɗiki­ɗiki aw! Kakwesaw kà Masasəɗok aŋa Zəzagəla koksi­koksi, bokuba aŋa azla­baba aŋkul. ");
INSERT INTO mfh_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Azlaməna mapəh à atà gay à ahàl, azla ma uwala, azla­baba aŋkul madzi­dziga tatərə̀ɓàh atà aw la? Atà tata­kàɗàh azla­uwana, tasà à waŋ kà maz mas à waŋ aŋa dza dziriga lagonay bay, kà masla la uwanay katàwwal kaf à gəl, ŋgaha kakə̀ɗàw. ");
INSERT INTO mfh_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tekeɗik kà akul kà, Zəzagəla avà à akul mapəhay la ahàl aŋa azla­ma­lika, ama kakə̀sàw aw.” ");
INSERT INTO mfh_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Uwana maham à ahəŋ aŋa azlaməna sawaray tatsə̀n gay uwaga kà, tapàɗ sliɗ la tsəh ala, tapakàh ləv məŋga lakəl aŋa Etiyen. ");
INSERT INTO mfh_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ama Etiyen uwana mahənla ala gà la Masasəɗok Zəzagəla, adzilà yewdi à zagəla, anəŋà mazləɓay aŋa Zəzagəla, la Yesu matsizl à ahəŋ gà la ahàl kaf aŋa Zəzagəla lakəl. ");
INSERT INTO mfh_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Etiyen agòɗ: “Tsə̀ɓàwwal sləm: Gənəŋà zagəla kà zagəla mapəzlla ama ala gà, ŋgaha Kona aŋa dza dzawwa la ahàl kaf aŋa Zəzagəla lakəl.” ");
INSERT INTO mfh_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tawiyà la ndzəɗa kà makaɗal gəl à ahəŋ la manakàh à sləm à ama. Gesina aŋatà tahamàl à gəl. ");
INSERT INTO mfh_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Tabayàŋ à uda la gudəŋ la abà, ŋgaha tadzəkà matsahay la akur kà makəɗay. Azlaməna makəɗay tahamà lukut aŋatà à slaka bəzi kohana, uwana sləm aŋha Sawul. ");
INSERT INTO mfh_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Uwana tatsahay la akur kà Etiyen, adə̀v kuɗa kiya uwanay: “Sufəl Yesu, gəmətsay kà à ahàl aŋak à afik!” ");
INSERT INTO mfh_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ŋgaha akədèɗ à ahəŋ, azà kuda à zagəla awiyà: “Sufəl, katugw uwaga bokuba tsakana lakəl aŋatà aw!”, agòɗ. La mapəh gay uwaga la gay ala, amə̀ts. ");
INSERT INTO mfh_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Makəɗ Etiyen kà, akə̀s à Sawul à gəl. La mavakay uwatà, matərəɓay məŋga adzəkà à vok lakəl aŋa maham à ahəŋ məna gay Zəzagəla la Uru­sa­lima. Gesina aŋatà tasləhà gəl à ahəŋ la kutso Yahu­diya ŋgaha la Sama­riya. Say azlaməna matapla pəra tatə̀m à Uru­sa­lima. ");
INSERT INTO mfh_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ama azladza dziriga talà Etiyen, ŋgaha tatùw məŋga. ");
INSERT INTO mfh_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sawul awàɗ vok à uda kà mabəzl gəl à maham à ahəŋ məna gay Zəzagəla à abà; adàhàh gày la gày, kà makas azlaməna madiŋal gəl à vok, azlazil la azla­misga gesina, kà mawats atà à daŋay. ");
INSERT INTO mfh_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Azla­uwana tasləhà gəl à ahəŋ kà, tau­gu­zàhàh la kutso gesina kà maz gay marabəŋ. ");
INSERT INTO mfh_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip ahàd à Sama­riya, ŋgaha azà gay aŋa Kristu à azlaməna madz à ahəŋ la gudəŋ uwatà. ");
INSERT INTO mfh_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Maham à ahəŋ dza takə̀s gay aŋa Filip à mok uwana tatsənàŋ ŋgaha tanəŋàŋ azla­na­dzipo uwana aɗa­hàhàŋ. ");
INSERT INTO mfh_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","La kità azla­ma­sasəɗok mawi­siga tasàhà à uda la azlaməna ɗuvats la abà aŋuvaw la mawiyay, ŋgaha azla­magul à afik gà, la azla­deri tawarà ala bay. ");
INSERT INTO mfh_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Marabay məŋga apakà vok la gudəŋ uwatà. ");
INSERT INTO mfh_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Dza anik la ahəŋ, dagay uwarà la gudəŋ uwatà, sləm aŋha Səmon. Masla kà avàlàh ləv à azladza à gay la Sama­riya la məzla aŋha. Masla kà: “Gi məŋ dza”, agòɗ. ");
INSERT INTO mfh_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Gay gà la uwaga azladza la gudəŋ uwatà gesina, azla­uwana azlaməŋga tagòɗ à atà, la azla­bəzaga gesina, taslə̀kàw masla, tagòɗ kà: “Masla la uwana ndzəɗa aŋa Zəzagəla uwana tazàlalla ndzəɗa məŋga gà.” ");
INSERT INTO mfh_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tasləkàwàh masla məŋga kà uwana avàlàh ləv à azladza à gay la məzla aŋha dagay uwatà. ");
INSERT INTO mfh_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ama mok uwana tadìŋ gəl à gay marabəŋ uwana à vok, Filip azàŋ lakəl aŋa makoray Zəzagəla, ŋgaha lakəl aŋa sləm aŋa Yesu Kristu kà, taɓəzà batem, azlazil la azlamis. ");
INSERT INTO mfh_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Səmon la gəl aŋha bay, adìŋal gəl à vok, aɓəzà batem, adzà à ahəŋ la slaka Filip, ŋgaha ləv ava­làhal à gay məŋga la manəŋ azla­masəlay la azla­na­dzipo uwana Filip aɗa­hàhàŋ. ");
INSERT INTO mfh_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Azlaməna matapla la Uru­sa­lima tatsənàŋ kà azladza la Sama­riya takə̀s gay aŋa Zəzagəla kà, taslə̀l à atà Piyer à awtày atà la Yuhana. ");
INSERT INTO mfh_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Mok uwana tabəzà à Sama­riya kà, tadə̀v kuɗa kà aŋa azlaməna madiŋal gəl à vok kà atà aŋa maɓəz Masasəɗok Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kà uwana Masasəɗok Zəzagəla adasa à ahəŋ, baməraka à gəl aŋa tekula aŋatà dadàŋ aw, taɓəzà batem la sləm aŋa Sufəl Yesu dadàŋ pəra. ");
INSERT INTO mfh_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Gay gà la uwaga à uwana, Piyer atà la Yuhana taɓə̀k à atà ahàl à gəl, ŋgaha maɓəz Masasəɗok Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Mok uwana Səmon anəŋà Masasəɗok asà à gəl aŋa azlaməna madiŋal gəl à vok, à mok uwana azlaməna matapla taɓə̀k à atà ahàl à gəl kà, Səmon ayàh maɓək sili à azla Piyer atà la Yuhana. ");
INSERT INTO mfh_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Agòɗ: “Vàw à gi ndzəɗa uwaga babay suwaŋ, kà kəla uwa­be­yuwi uwana gədàɓəkal ahàl à gəl aŋa maɓəz Masasəɗok Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ama Piyer awulàlla: “Zàlla la sili aŋak, kà uwana kadzugw kà: Mavày aŋa Zəzagəla kà tasukway la sili, kagòɗ. ");
INSERT INTO mfh_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Humà gà aŋak la ahəŋ, la gay uwanay la abà aw. Kak kà, kak la sləray gami la abà aw, kà uwana ləv aŋak la dziriga la huma Zəzagəla aw! ");
INSERT INTO mfh_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Pə̀h gay la ləv ala kà mawi­siga aŋak uwaga, də̀v kuɗa à Sufəl, zlahaw kà masla ama­tsakaŋ ala tsəhay madzugway aŋak uwaga tak. ");
INSERT INTO mfh_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kà uwana gənəŋàŋ kà kadahən ala la mawi­siga ɗe­ha­kakga, ŋgaha kak mayà aŋa tsakana.” ");
INSERT INTO mfh_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kiya uwaga Səmon agòɗ à Piyer atà la Yuhana: “Kamkam, də̀vàw kuɗa à Sufəl kà gi, kà gay uwana kapə̀hàw à gi aŋa maɓəz à gi aw!” ");
INSERT INTO mfh_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Piyer atà la Yuhana tapàh sayda aŋa Sufəl Yesu la maz gay marabəŋ la Sama­riya, ŋgaha tawulà à Uru­sa­lima. La tetəvi aŋatà la ama kà, tapàhàh gay marabəŋ lakəl aŋa Yesu la azlabəza gudəŋ uwana la kutso Sama­riya la abà gesina. ");
INSERT INTO mfh_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","La lig aŋa uwaga la ahəŋ, malika aŋa Sufəl Zəzagəla apə̀hla vok à Filip, agòɗal: “Filip, sà à afik, wùl à gəl à agu, à tetəvi uwana à ama asà à uda la Uru­sa­lima ada à Gaza.” Tetəvi uwana tetəvi kəsaf. ");
INSERT INTO mfh_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filip atsìzlla ala, ahàd. Tagagàm à tetəvi à ama la dza anik. Dza uwatà kà zil Eti­yo­piya, subaga, slaw­para aŋa Kandantse, məŋ sufəl misga la Eti­yo­piya. Asà à Uru­sa­lima kà masləkaw Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Agà la tetəvi mawul à mtəga aŋha la tsəh, la dərkwa aŋha la afik, adzeŋay la wakità aŋa masla mapəhal gay à ahàl Yesayya la abà. ");
INSERT INTO mfh_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Masasəɗok Zəzagəla agòɗ à Filip: “Hàd à slaka aŋha, zà à vok à slaka aŋa dərkwa aŋha!” ");
INSERT INTO mfh_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filip azà à vok à slaka aŋha la mahoyay, ŋgaha atsənà zil Eti­yo­piya uwaga adzeŋay la wakità aŋa masla mapəhal gay à ahàl Yesayya la abà. Anavàl à gay la: “Katsənà uwaga kadzeŋay ay?” ");
INSERT INTO mfh_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Kona uwaga agòɗal: “Kakay gətse­nəŋ à baŋa dza adàpatgəla godega aŋha aw ma? Sà à waŋ à slaka gulo à dərkwa la afik”, agòɗ à Filip. ");
INSERT INTO mfh_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Aganay à slaka uwana adzèŋ la wakità la abà: ˈAgà bokuba tuwaŋ uwana tadàla à makəɗay, bokuba bəzi tuwaŋ uwana atuway à baŋa tatsəɗ aŋidz aŋha aw. Kiya uwaga məslə̀k, apokwà gay aŋha aw. ");
INSERT INTO mfh_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tapəsèw, takə̀l ala ziruwi à gəl, tadùkw ala seriya à gəl kà deyday pəra. Uwa à uwana adà­slala vok aŋa matugway lakəl aŋa tsəhay aŋha uwa? Kà uwana takə̀ɗ à gəl à sifa aŋha la gudəŋ la vok.ˈ ");
INSERT INTO mfh_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Slaw­para uwaga anavà Filip: “Kamkam, pə̀hgəla lakəl ma aŋa uwa masla mapəhal gay à ahàl apəhay uwa? Apəhay ma lakəl aŋha, awma lakəl aŋa dza anik ay?” ");
INSERT INTO mfh_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filip adzəkà lakəl aŋa uwana dza uwaga adzeŋay la wakità la abà, azàla gay lakəl aŋa Yesu. ");
INSERT INTO mfh_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Uwana taday, taday kà, tabəzà à iyaw à vok, la abatà slaw­para agòɗ: “Tsa iyaw la uwanay, ma mana à uwana aɗəɗ à gi gay à ahəŋ kà maɓəz batem ma?” (( ");
INSERT INTO mfh_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip agòɗal: “Baŋa kadiŋal gəl à vok la ləv aŋak gesina kà, kaslala vok kà, maɓəz batem.” Kona uwaga awulàlla: “Gədiŋal gəl à vok, kà Yesu Kristu kà Kona aŋa Zəzagəla.”)) ");
INSERT INTO mfh_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ŋgaha la abatà: “Tsìzlla dərkwa à ahəŋ”, agòɗ à magamza aŋha. Filip atà la slaw­para tasà à ahəŋ, tahàd à iyaw à abà, ŋgaha Filip aɗahàlla batem. ");
INSERT INTO mfh_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","La mok uwana tasà à uda la iyaw la abà kà, Masasəɗok Sufəl Zəzagəla azəɓà Filip ala dzəgasl. Slaw­para anəŋàŋ aya aw, ama adà aŋha la marabay. ");
INSERT INTO mfh_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Batsàrà kà, Filip anə̀ŋla kà agà la Azot. Kiya uwaga aguwàh la azla­gu­dəŋ la abà gesina, kà maz gay matsi­ɗayga la slaka gesina tsəràh uwana abəzà Zəsare. ");
INSERT INTO mfh_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","La mok uwatà, Sawul asakà matərəɓəŋ la makaɗ azlaməna matapla la slaka Sufəl Yesu aw. Ahàd à slaka məŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Anavà patanti, kà aŋa gày madəv kuɗa la Damas, kà makas azladza uwana tanəfa Yesu, azlazil la azlamis gesina, kà madla atà à Uru­sa­lima. ");
INSERT INTO mfh_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Mok uwana adaɓəz à patanti uwaga kà, atsìzlla ala, kà mad à Damas. La tetəvi la ama, uwana azlabəzay, katskats məŋ uɗaka asà à ahəŋ la zagəla, aùɗ la slaka aŋha. ");
INSERT INTO mfh_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Atə̀ɗ à vəɗah, ŋgaha atsənà kuda uwana agòɗal: “Sawul, Sawul, kà mana katərəɓ gi ma?” ");
INSERT INTO mfh_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Anàv, agòɗal: “Kak uwa, Sufəl?” Kuda uwaga agòɗal: “Gi Yesu uwana katərəɓəŋ.” ");
INSERT INTO mfh_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ama agòɗal: “Sà à afik, hàd à gudəŋ à abà, la abatà la uwana tadàpəh à ka uwana kadà­ɗe­həŋ.” ");
INSERT INTO mfh_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Azlaməna mau­gu­zahay atà nna tagu­ɗə̀kàhla, taslàla vok kà mapokw gay aw, tatsənà maɓaɗma, ama tanəŋà dza aw. ");
INSERT INTO mfh_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sawul asà à afik la vəɗah, apə̀zl yewdi, ama aslàla vok kà manəŋ tatak aw. Takə̀s à ahàl kà madla à Damas. ");
INSERT INTO mfh_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tsəràh mavakay makər, aslàla vok kà manəŋla aw, azùw ŋgaha asà tatak babay aw. ");
INSERT INTO mfh_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Masla asik anik la ahəŋ la Damas uwana sləm aŋha Ana­niyas. Sufəl Zəzagəla apə̀hal la masa­siŋay, agòɗal: “Ana­niyas, Ana­niyas!” “Awway, gi la uwanay, Sufəl gulo”, Ana­niyas agòɗal. ");
INSERT INTO mfh_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Sufəl Zəzagəla agòɗal: “Katskats, hàd lagonay à bəzi barama tərraga à ama. Lakay aŋa Yudas, dza uwana sləm aŋha Sawul zil Tarsus, adəv kuɗa lagwa, ɗanàv. ");
INSERT INTO mfh_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Kiya uwaga la masa­siŋay kà, Sawul anəŋà dza anik, uwana sləm aŋha Ana­niyas adà à gày kà maɓəkal ahàl à gəl, kà masla aŋa manəŋla aya.” ");
INSERT INTO mfh_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ana­niyas agòɗal: “Sufəl, azladza aŋuvaw tapə̀h à gi lakəl aŋa dza uwaga, lakəl aŋa uwana aɗahàŋ à azlaməna manəfay aŋak à vok la Uru­sa­lima. ");
INSERT INTO mfh_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ŋgaha asà à waŋ à abanay la patanti, uwana la ahàl azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla la Uru­sa­lima tavàl, kà makas azladza uwana tatsàl sləm aŋak à gay.” ");
INSERT INTO mfh_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ama Sufəl Zəzagəla agòɗal: “Hàd, kà uwana gədazəɓ masla, ŋgaha gədà­pa­kəŋ ala, kà masla mapəhla gi ala, la slaka azlatsəhay anik anik, la azla­su­fəl aŋatà, ŋgaha la tsəhay Isərayel. ");
INSERT INTO mfh_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Gi la gəl gulo gədàpəh ala ŋgərpa uwana adàsay kà gi.” ");
INSERT INTO mfh_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kiya uwaga Ana­niyas ahàd, adà à gày uwatà à agu, aɓə̀k ahàl à Sawul à gəl, agòɗal: “Deda Sawul, Sufəl Yesu uwana apə̀hakala vok la tetəvi la ama à uwana katsà à waŋ, masla la uwana asləl gi à waŋ, kà kak aŋa manəŋla aya, ŋgaha kà kak aŋa magay mahənlaga la Masasəɗok Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Katskats tatak anik bokuba mafafətay aŋa kilfi anìs à Sawul la adi ala, ŋgaha anə̀ŋla aya. Hadzak, asà à afik ŋgaha taɗà­halla batem. ");
INSERT INTO mfh_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","La lig la ahəŋ azùw tatak may, ŋgaha aɓəzà à ndzəɗa aya. Sawul asàf la azlaməna madiŋal gəl à vok ŋuv la Damas. ");
INSERT INTO mfh_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Katskats adzəkà mapəhàh gay Zəzagəla la azlagày madəv kuɗa la aku, la mapəhla ala, kà Yesu kà Kona aŋa Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Azladza uwana tatsə̀ɓal sləm gesina, ləv avàlàh à atà à gay, tagòɗ: “Uwaga kà dza uwana atərə̀ɓàhà azladza la ndzəɗa la Uru­sa­lima, azla­uwana takə̀s gay aŋa Yesu aw takay? Ŋgaha asà à waŋ à abanay kà aŋa makas atà la madla atà à məŋ madza­haga aŋa azlaməna mav tatak à Zəzagəla aw takay?” ");
INSERT INTO mfh_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ama Sawul azàŋ la ndzəɗa koksi­koksi la mad à huma à gay, azla Yahu­diya uwana tadzà à ahəŋ la Damas, tasə̀l uwana tawulàlla aya à mok uwana apə̀hatàla kà Yesu kà Kristu aw. ");
INSERT INTO mfh_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Uwana ada­safni kà, azla Yahu­diya takə̀s sawaray kà makəɗay. ");
INSERT INTO mfh_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ama atsənà uwana tatsənàŋ à vok kà maɗa­hallaŋ à vok. Kəla mavakay la mahənay tanə̀ŋla gay gamagày aŋa huɗ gudəŋ kà makəɗay. ");
INSERT INTO mfh_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kiya uwaga la vəɗ vərdi anik, azlaməna asik aŋha tazə̀ɓ, tafà à takosà à abà, tadzilà à ahəŋ la gəl zlagam, uwana takə̀slla gay à huɗ gudəŋ à adi. ");
INSERT INTO mfh_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Mok uwana Sawul adawul à Uru­sa­lima kà, ayàh maham gay à vok la azlaməna matapla; ama guba akə̀s à atà gesina, kà uwana tadiŋal gəl à vok, kà masla ndzer kà adapaka masla manəf Yesu aw. ");
INSERT INTO mfh_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ama Barnabas akə̀s à tsəh, adàlla à slaka azlaməna matapla la slaka Yesu, ŋgaha atùgw à atà godega manəŋ Sufəl Yesu aŋa Sawul la tetəvi la ama, ŋgaha la uwana Sufəl Yesu aɓa­ɗalmà. Apə̀h à atà gay lakəl aŋa mawaɗ vok à uda aŋa Sawul uwana azà gay aŋa Yesu la Damas aya. ");
INSERT INTO mfh_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Dagay kaslà uwatà kà, Sawul adà à atà à adi, tau­gu­zàhàh la gudəŋ Uru­sa­lima kà maz gay aŋa Sufəl Yesu. ");
INSERT INTO mfh_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ŋgaha apàhàh à azla Yahu­diya uwana tapə̀h gay Gərək la mabay vok gay la atà babay, ama atà kà, tayàh kà makəɗay. ");
INSERT INTO mfh_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Mok uwana azla­deda tatsə̀n uwaga kà, talakà Sawul à Zəsare, ŋgaha taslə̀l à Tarsus. ");
INSERT INTO mfh_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kiya uwaga azlaməna madiŋal gəl à vok la kutso Yahu­diya, la Galili, la Sama­riya gesina tadzà à ahəŋ la lapiya, kokuɗa matərəɓay. Tadzərə̀ɗàh ala, tadzà à ahəŋ la mahoy à adi aŋa masləkaw Sufəl Zəzagəla la abà, tasəg ala la mazlakay aŋa Masasəɗok Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","La kaslà uwatà Piyer augu­zàhàh la azla­gu­dəŋ la abà gesina. Vərdi anik, ahàd à slaka azlaməna madiŋal gəl à vok uwana tadzà à ahəŋ la Lidda. ");
INSERT INTO mfh_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","La abatà dza anik uwana sləm aŋha Ene la ahəŋ. Magul à afik gà dagay mavay mtəgis agà la slaka mahən à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piyer agòɗal: “Ene, Yesu Kristu awur ka ala! Sà à afik, kakəl slaka mahən à ahəŋ aŋak à abà!” Hadzak Ene asà à afik. ");
INSERT INTO mfh_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","La abatà azlaməna madz à ahəŋ la Lidda ŋgaha la azla­uwana la vaday Saron tanəŋàŋ gesina aŋatà tapə̀h gay la ləv ala la huma aŋa Sufəl Yesu. ");
INSERT INTO mfh_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mis anik la ahəŋ la Yope sləm aŋha Tabita, (Sləm uwaga la gay Gərək Dorkas, uwana asal magoɗay Pəkur) Masla kà aɗahàhà azlasləray dzəɓa aŋha səla aw gà la mazlakay kuda. ");
INSERT INTO mfh_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","La kaslà uwatà ɗuvats akə̀s, ŋgaha amə̀ts. La mok uwana tapàlal vok kà, tahənàŋ à gày, uwana à agu lakəl aŋa gày anik. ");
INSERT INTO mfh_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Uwana azlaməna madiŋal gəl à vok la Yope tatsənàŋ kà Piyer la Lidda, nekwa la gudəŋ uwaga kà, taslə̀lal azladza səla à tsəh la gay: “Mədəv à ka kuɗa, sà à waŋ à mtəga gami la katskats.” ");
INSERT INTO mfh_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piyer anəfà à atà la katskats. Mok uwana tabəzà awtày kà, tadàla à gày uwana à afik tahənàŋ à agu. Azlamis kuɗa gesina tadà à awtày à slaka aŋha la mataway; tapà­halla azla­ne­newi, ŋgaha la azla­deb­debi uwana Dorkas atsàh à mok uwana aləg la sifa. ");
INSERT INTO mfh_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","La abatà Piyer akuɗə̀kàh azladza à uda, ŋgaha akəɗèɗ à ahəŋ, adə̀v kuɗa, agolà à huma à slaka mazim­nekiɗ: “Tabita, sà à afik!”, agòɗal. Tabita apə̀zl yewdi, uwana anəŋà à Piyer à adi, asà à afik, adzà madzay. ");
INSERT INTO mfh_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piyer akə̀s à ahàl, ŋgaha azlakàŋ kà matsi­zlləŋ ala. La lig la ahəŋ Piyer azàla azlamis kuɗa la azlaməna madiŋal gəl à vok, apə̀hatàla kà agay la sifa. ");
INSERT INTO mfh_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Uwaga asə̀lla à vok la Yope gesina, ŋgaha azladza aŋuvaw tadìŋ gəl à Sufəl Yesu à vok. ");
INSERT INTO mfh_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piyer kà asàf məŋga la gudəŋ Yope la mtəga aŋa Səmon, masla masaɗ zlap. ");
INSERT INTO mfh_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Dza la ahəŋ la Zəsare, sləm aŋha Korne­liyus, masla kà zil Rom, məŋga aŋa azla­slodzi dzim aŋa maham à ahəŋ slodzi, uwana tazalal ala maham à ahəŋ Italiya. ");
INSERT INTO mfh_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Masla awoyà Zəzagəla, asləkàw Zəzagəla la azlaməna huɗ gày aŋha gesina. Azlàkàh azlaməna kuɗa uwana azlatsəhay Yahu­diya, ŋgaha adàv kuɗa à Zəzagəla koksi­koksi. ");
INSERT INTO mfh_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","La gay mokokhu vərdi anik la sa makər, masa­siŋay asa­sìŋla, anəŋà malika aŋa Zəzagəla adagay à slaka aŋha ŋgaha agòɗal: “Korne­liyus!” ");
INSERT INTO mfh_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Anərə̀z malika la masu­kulay, ŋgaha agòɗal: “Kak uwa, Sufəl gulo?” Malika awulàlla: “Zəzagəla adatsən madəv kuɗa aŋak la mazlakàh azlaməna kuɗa aŋak, ŋgaha lagwa kà kawùllal à gəl. ");
INSERT INTO mfh_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Lagwa kà, slə̀l azladza à Yope kà mazal Səmon uwana ‘Piyer’, tagoɗal. ");
INSERT INTO mfh_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ahənay kà la mtəga Səmon masla masaɗ zlap, uwana gày aŋha kà la gay dərəv.” ");
INSERT INTO mfh_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Mok uwana malika uwaga aɓa­ɗalmà, adada aŋha kà. Korne­liyus azàl azla­ma­gamza aŋha səla, la slodzi tekula uwana anə̀ŋlal, masla bay, awoyà Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Atùgw à atà uwana apakà vok gesina, ŋgaha aslə̀lla atà à gudəŋ Yope. ");
INSERT INTO mfh_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kiya uwaga tatsìzlla ala, tahàd à Yope. La bebəŋ gà, mok uwana tazla­bə̀z Yope kà, Piyer bay kà, ahàd à gəl gày à afik kà madəv kuɗa la tataka afats. ");
INSERT INTO mfh_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","May akə̀s Piyer, asàl mazuw tatak may. A mok uwana tadzəkà matal tatak, à uwana masa­siŋay asa­sìŋla. ");
INSERT INTO mfh_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Anəŋà zagəla apə̀zlla vok, ŋgaha tatak anik asà à ahəŋ: Magol məŋ tatagà bokuba peteli gay dzika ufaɗ mawaɗ à ahəŋ ala gà, afà à vok à vəɗah. ");
INSERT INTO mfh_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","La huɗ aŋha kà kəla tsəhay tatak asik ufaɗ la abà gesina, la azla­tatak uwana taday la huɗ, ŋgaha la azlatsəhay tatak uwana tahoyay gesina. ");
INSERT INTO mfh_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ama Zəzagəla agòɗal: “Sà à afik, kakəɗ, ŋgaha pàɗ zlà, Piyer!” ");
INSERT INTO mfh_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ama Piyer agòɗ: “Awaŋ, kiya uwaga aw, Sufəl gulo, kà uwana ɗiki­ɗiki gədapaɗ tatak àlàhga aw, aslə̀h!” ");
INSERT INTO mfh_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Agòɗal aya: “Kapakàŋ ala bokuba àlàhga à uwana Zəzagəla ada­pa­kəŋ ala tsiɗaŋa aw.” ");
INSERT INTO mfh_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Uwaga aɗahà vok asik makər, ŋgaha la lig la ahəŋ la kirim yewdi tatak uwaga awùl à zagəla. ");
INSERT INTO mfh_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piyer adzùgw godega aŋa uwana masa­siŋay uwaga asàl mapəhalla. Ama la kaslà uwatà kà, azlaməna masləlay aŋa Korne­liyus tana­vahay la slaka azladza: “Lala à gày aŋa Səmon masla masaɗ zlap la?”, tagoɗay. Tsa mok uwaga kà, atà la gay gamagày aŋha. ");
INSERT INTO mfh_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tazàlàh, ŋgaha tanàv: “La abanay à Səmon uwana tazalalla Piyer ahənay ay?” ");
INSERT INTO mfh_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piyer alə̀g la madzugway aŋa masa­siŋay uwaga la abà, uwana Masasəɗok Zəzagəla agòɗal: “Nə̀ŋàŋ, azladza makər la uwaga tayàh ka la gay gamagày la uda. ");
INSERT INTO mfh_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Sà à afik, dà à ahəŋ, kadaw akul nna, kokuɗa matsurəkway, kà uwana gi la uwana gəslə̀lla ka atà à waŋ!” ");
INSERT INTO mfh_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piyer asà à ahəŋ à slaka azladza uwaga, ŋgaha agòɗ à atà: “Gəga la uwanay à uwana kayahaw gi. Mana kasawka à waŋ ma?” ");
INSERT INTO mfh_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tagòɗal: “Məsà à waŋ kà, Korne­liyus məŋga aŋa azla­slodzi dzim, la uwana aslə̀lla anu à waŋ. Masla kà dza dziriga, uwana azlə̀ɓ Zəzagəla, uwana azla Yahu­diya gesina kà: ‘Dza’, tagòɗal. Malika aŋa Zəzagəla apə̀hal gay, kà masla aŋa mazala à ka, kà kak aŋa mapəhal uwana asa à ka mapəhal.” ");
INSERT INTO mfh_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ŋgaha Piyer adàla atà à gày, avà à atà slaka mahən à ahəŋ. La bebəŋ gà, takə̀s tetəvi, tahàd atà nna. Azla­deda anik, la tataka azladza la abà la Yope, talakà à atà. ");
INSERT INTO mfh_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","La bebəŋ gà aya tabəzà Zəsare. Korne­liyus babay kà adahama gay azladza à vok la azlahuɗ gày aŋha gesina kà makud atà. ");
INSERT INTO mfh_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Uwana Piyer adà à gày kà, tagagàm la Korne­liyus, atə̀ɗ à huma aŋha, akədèɗal à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ama Piyer akə̀s à afik la magoɗal: “Sà à afik, gi kà bà gi dza kiya kak bay.” ");
INSERT INTO mfh_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kiya uwaga tadà à huma à gay la maɓaɗma la abà la Korne­liyus, ŋgaha tsəràh à uwana tahamà gay à vok takuday. ");
INSERT INTO mfh_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Agòɗ à atà: “Kasəlaw kà zil Yahu­diya aŋa madz à ahəŋ la azlatsəhay anik, kà zla­zlaɗa, ama Zəzagəla apə̀h à gi kà gəpak tsəhay dza anik ala kà àlàhga, gəda à gày aŋha aw, gəgoɗay aw. ");
INSERT INTO mfh_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Gay gà la uwaga mok uwana kazàlàw gi kà, gəsa à waŋ kokuɗa madzurəkway. Lagwa ma, kà mana kazàlàw gi mi?” ");
INSERT INTO mfh_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korne­liyus awulàlla: “Adagay mahənay ufaɗ lakana, bà la kaslà uwanay gədə̀v kuɗa la mtəga gulo la sa makər aŋa mokokhu. La kirim yewdi kà, dza anik ada­tsakwàh la lukut mawutsəɗay gà la vok la huma gulo. ");
INSERT INTO mfh_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ŋgaha agòɗ à gi: Korne­liyus, Zəzagəla atsənà madəv kuɗa aŋak, ŋgaha mazlakay aŋak uwana kazlakàh à azlaməna kuɗa ada­wullal à gəl. ");
INSERT INTO mfh_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Lagwa kà, slə̀l azladza à Yope kà mazal Səmon uwana tazalalla Piyer. Adza à ahəŋ la mtəga Səmon, masla masaɗ zlap, uwana gày aŋha la gay dərəv. ");
INSERT INTO mfh_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Katskats gəslə̀l azladza à awtày, kà mazal à ka. Kaɗahàŋ delga la mas à waŋ aŋak. Lagonay kà, anu la uwanay gesina gami la huma aŋa Zəzagəla, kà matsəɓ sləm à uwana Sufəl apə̀h à ka, kà mapəh à anu gesina zlà.” ");
INSERT INTO mfh_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Piyer adzəkà maɓaɗma, agòɗ: “Lagwa kà, gədasəlay kà Zəzagəla kà avàh à dza mavahay aw. ");
INSERT INTO mfh_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kəla dza tsəhay uwala beyli uwana adiŋal gəl à vok, ŋgaha aɗàh dziriga kà, ahə̀ɗal à adi. ");
INSERT INTO mfh_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Haɗay, kasəlaw kà Zəzagəla aslə̀l gay aŋha à slaka azla Isərayel, uwaga kà gay matsi­ɗayga à uwana məslalà vok aŋa magla lapiya la Zəzagəla, kà made­golay Yesu, uwana asə̀lla anu vok la Zəzagəla, uwana Sufəl aŋa dza gesina. ");
INSERT INTO mfh_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Gay matsi­ɗayga uwanay adzəkà vok la Galili, la lig aŋa batem uwana la ahəŋ Yuhana azàŋ, ŋgaha asləhà gəl à ahəŋ la kutso Yahu­diya. ");
INSERT INTO mfh_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kasəlaw à uwana Zəzagəla aslə̀l Masasəɗok aŋha à ahəŋ, à Yesu zil Nazaret à gəl, ŋgaha kasəlaw babay, à uwana Yesu augu­zàhàh la azla­gu­dəŋ la abà gesina la maɗehəŋ delga la mawar azladza uwana ala, atà la ahàl aŋa seteni. Ndzer kà, Zəzagəla agà la masla. ");
INSERT INTO mfh_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Gesina gami kà, anu azlaməna sayda aŋa tatak uwana aɗa­hàhàŋ la Uru­sa­lima, la kutso aŋa azla Yahu­diya la abà gesina. Takə̀ɗ masla la mazləl à ahàf à adi. ");
INSERT INTO mfh_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ama Zəzagəla awùlla à uda la mamətsay la mahənay makər, ŋgaha avàl ndzəɗa kà mapəhla vok ala. ");
INSERT INTO mfh_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ama azladza gesina tanəŋàŋ aw, anu uwana atsa­tsà­mànì anu la madzəka, kà anu aŋa magay azlaməna sayda pəra, mənəŋàŋ. La lig aŋa uwana Zəzagəla awùlla à uda la mamətsay kà, məzùw, məsà la slaka gà anina. ");
INSERT INTO mfh_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ŋgaha apə̀h à anu à vok à abà kà maz gay marabəŋ à azladza, ŋgaha kà mapəhla ala kà Zəzagəla afà Yesu à ahəŋ, kà masla seriya lakəl aŋa azladza uwana la sifa, ŋgaha lakəl aŋa azla­uwana tamatsay. ");
INSERT INTO mfh_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Azlaməna mapəh à atà gay à ahàl kà mapàh à azladza gesina tapàh lakəl aŋha: Kəla dza uwana adiŋ gəl à Yesu à vok kà, Zəzagəla adà­ma­tsalla tsakana aŋha ala, kà sləm aŋa Yesu.” ");
INSERT INTO mfh_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Mok uwana Piyer aləg la maɓaɗma la abà kà, Masasəɗok Zəzagəla asà à gəl aŋa azladza uwana tatsə̀ɓ sləm à gay aŋha gesina. ");
INSERT INTO mfh_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Azla Yahu­diya uwana tadìŋ gəl à Yesu à vok, azla­uwana tanəfà Piyer à waŋ kà, ləv avàlàh à atà à gay, kà Masasəɗok, uwana Zəzagəla avà à azladza uwana azla Yahu­diya aw bay. ");
INSERT INTO mfh_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kà uwana tatsənà atà tazlə̀ɓ maslay aŋa Zəzagəla la azlagay məlok gà, uwana tatàpla aw. Piyer agòɗ: ");
INSERT INTO mfh_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Lagwa ma məslala vok aŋa maɗəɗ gay à azladza uwanay à ahəŋ kà maɗa­hatàŋ batem aŋa iyaw, tsa taɓəzà Masasəɗok Zəzagəla bokuba anu ay?” ");
INSERT INTO mfh_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ŋgaha avà tetəvi kà maɗàh à atà batem la sləm aŋa Yesu Kristu. Ŋgaha tanavàl à masla aŋa madzin à ahəŋ atà nna. ");
INSERT INTO mfh_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Azlaməna masləlay la azlaməna madiŋal gəl à vok uwana tadzà à ahəŋ la Yahu­diya tatsənàŋ kà azladza uwana azla Yahu­diya aw babay takə̀s gay Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Uwana Piyer adawul à Uru­sa­lima kà, azla Yahu­diya uwana tadìŋ gəl à Yesu à vok taslàhàla vok. ");
INSERT INTO mfh_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Tagòɗal: “Kahàd à tataka aŋa azladza uwana à abà, makadav atà à uda gà aw, ŋgaha kazùw aw tatak may akul nna?!” ");
INSERT INTO mfh_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kiya uwaga Piyer adzəkà matugw à atà godega aŋha takwatokw lakəl aŋa uwana apakà vok gesina. Agòɗ à atà: ");
INSERT INTO mfh_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Gi, kà gi la Yope, mok uwaga gi la madəv kuɗa la abà kà, mase­siŋay ase­sìŋla gi. Gənəŋà tatak anik asà à ahəŋ la zagəla, asà à slaka gulo. Tatak uwatà kà bokuba magol peteli, mawaɗ à ahəŋ ala gà, kəla gay dzika ufaɗ nna, asà à ahəŋ la zagəla, asà à slaka gulo. ");
INSERT INTO mfh_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Gənərə̀z huɗ aŋha la haŋkəli kà, gənəŋà azla­tatak uwana la asik ufaɗ, azla­tatak fəta la azla­uwana taday la huɗ, ŋgaha la azla­uwana tahoyay la zagəla. ");
INSERT INTO mfh_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ŋgaha gətsənà kuda aŋa Zəzagəla agòɗ à gi: ‘Piyer, sà à afik, kə̀ɗ ŋgaha pàɗ!’ ");
INSERT INTO mfh_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ama gəwulàlla: ‘Awaŋ, kiya uwaga aw, Sufəl gulo, ɗiki­ɗiki tatak àlàhga adada à gay gulo à awtày aw, aslə̀h!’ ");
INSERT INTO mfh_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","La abatà kuda uwaga atsə̀n à ahəŋ aya: ‘Kapakà tatak uwana ala Zəzagəla ada­pa­kəŋ ala tsiɗaŋa kà àlàhga aw!’ ");
INSERT INTO mfh_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Aɗahà vok asik makər, ŋgaha la lig la ahəŋ, tatak uwaga awùl à zagəla gesina. ");
INSERT INTO mfh_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","La kaslà uwatà azladza makər tasà à waŋ à gày, uwana à abà gi lakay. Taslə̀lla atà à waŋ kà dagay la Zəsare kà mayàh gi. ");
INSERT INTO mfh_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","La abatà Masasəɗok Zəzagəla agòɗ, gənəfà atà, kakwes aw. Kiya uwaga azla­deda mukwà talaka gi babay à Zəsare, gesina gami mədà à gày la mtəga Korne­liyus. ");
INSERT INTO mfh_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Uwana Korne­liyus adanəŋ anu kà, adzəkà matugw anu gay lakəl aŋa malika uwana adà à mtəga aŋha, atsìzlla à ahəŋ, agòɗal: ‘Slə̀l azladza à Yope, kà mazalay à Səmon uwana tazalalla Piyer. ");
INSERT INTO mfh_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Adàpəh à ka ala gay uwana kadàɓəla la azlaməna huɗ gày aŋak gesina.’ ");
INSERT INTO mfh_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","La abatà gədzəkà mapəh à atà. Masasəɗok Zəzagəla asà à atà à gəl bokuba uwana asà à anu à gəl babay suwaŋ, dagay uwarà. ");
INSERT INTO mfh_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","La abatà kà, awùl à gi à gəl lakəl aŋa uwana Sufəl Zəzagəla apə̀h: ˈYuhana aɗahàŋ batem la iyaw, ama akul kadàɓəzaw batem kà la Masasəɗok Zəzagəla.ˈ ");
INSERT INTO mfh_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ndzer, Zəzagəla avà à atà Masasəɗok aŋha bokuba uwana avà à anu à mok uwana mədìŋ gəl à Sufəl gami Yesu Kristu à vok. Ŋgaha ma, gi ma gi uwa, kà maɗəɗ gay à Zəzagəla à ahəŋ uwa?” ");
INSERT INTO mfh_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Mok uwana tatsə̀n gay uwaga kà, tadzà à ahəŋ titi, ŋgaha tazləɓà Zəzagəla la magoɗay: “Haɗay kà, Zəzagəla adavà tetəvi à azladza uwana azla Yahu­diya aw babay, kà atà aŋa mapəh gay la ləv ala, kà atà maɓəzal sifa adəv gay aw, haɗay.” ");
INSERT INTO mfh_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Azlaməna madiŋal gəl à vok tasləhà gəl à ahəŋ kà makəɗ Etiyen, uwana takə̀ɗ. Azlaanik la tataka aŋatà la abà tadà à Fe­nesəya, ŋgaha à Sipəre, ŋgaha à Anti­yews. Ama tazà gay Zəzagəla kà à azla Yahu­diya pəra. ");
INSERT INTO mfh_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ama azlaməna madiŋal gəl à vok anik uwana la Sipəre la azla­uwana la Səren, tahàd à Anti­yews, ŋgaha tazà gay marabəŋ lakəl aŋa Yesu Kristu à azla­uwana azla Yahu­diya aw. ");
INSERT INTO mfh_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ndzəɗa aŋa Sufəl Zəzagəla agà la atà, azladza aŋuvaw tapàh gay ləv ala, tadìŋ gəl à Sufəl Yesu à vok. ");
INSERT INTO mfh_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mok uwana gay uwaga adatsən à azlaməna madiŋal gəl à vok la Uru­sa­lima kà, taslə̀l à atà Barnabas à awtày à Anti­yews. ");
INSERT INTO mfh_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Uwana adada à awtày kà, aràb məŋga, kà uwana Zəzagəla apisà gay à azlaməna madiŋal gəl à vok à vok, kiya uwaga Barnabas adzərə̀ɗàh atà ala, kà atà aŋa mahoy yewdi aŋa Zəzagəla la manəfay la ləv tekula. ");
INSERT INTO mfh_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas kà dza delga gà, mahənlaga la ndzəɗa aŋa Masasəɗok Zəzagəla, ŋgaha la madiŋal gəl à vok. Azladza aŋuvaw tanəfà Sufəl Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabas ahàd kà mayàh Sawul la Tarsus. ");
INSERT INTO mfh_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Uwana adaɓəzal, asə̀lla à Anti­yews. Atà səla nna, tadzà à ahəŋ mavay tekula la abatà, kà atà səla aŋa matapla azlaməna gay Zəzagəla la matse­tsehàh atà ala aŋuvaw la Anti­yews. La uwana, azlaməna matapla tadzəkà mazalalla la sləm: Azlaməna madiŋal gəl à vok. ");
INSERT INTO mfh_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","La zamana uwatà azlaməna mapəh à atà gay à ahàl aŋa Zəzagəla kà mapàh à azladza, tasàhà à waŋ la Uru­sa­lima, tadàh à Anti­yews. ");
INSERT INTO mfh_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tekula aŋatà uwana sləm aŋha Agabus, atsìzlla ala, la ndzəɗa aŋa Masasəɗok Zəzagəla agòɗ: “Magol may atsa à waŋ à gudəŋ à vok gesina.” (Apakà vok la zamana makoray aŋa məŋ sufəl Kəlod) ");
INSERT INTO mfh_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kiya uwaga azlaməna matapla tatsənà vok gay kà kəla uwa­be­yuwi aŋatà avà uwana aslàla vok kà masləl à azla­deda uwana la may la abà la kutso Yahu­diya. ");
INSERT INTO mfh_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Uwana taɗàh uwaga, taslə̀l Barnabas atà la Sawul kà madla sili uwaga à slaka azla­ma­siga la kutso Yahu­diya. ");
INSERT INTO mfh_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","La zamana uwatà Sufəl Herod adzəkà matərəɓ azlaməna madiŋal gəl à vok, ");
INSERT INTO mfh_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","akə̀ɗ Yakuba, deda aŋa Yuhana la katsakar. ");
INSERT INTO mfh_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Uwana anəŋàŋ kà, akə̀s à azla Yahu­diya à gəl kà, akə̀s Piyer aya. (Kaslà uwaga agà mavakay aŋa Pain uwana tatak makəsliŋ la tsəh aw) ");
INSERT INTO mfh_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bokuba uwana akə̀s à azla Yahu­diya à gəl, à uwana Herod akə̀s Piyer, aduw à daŋay. “Nə̀ŋàwla!”, agòɗ à azla­slodzi. Atà azla­slodzi tatsàk ala madzəga ufaɗ, kəla slaka kà, slodzi ufaɗ ufaɗ, kà uwana asàl madalla à huma aŋa azladza à baŋa madəvaday Paska adàdəv à gay. ");
INSERT INTO mfh_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Azla­slodzi tanə̀ŋla Piyer la daŋay, ama azlaməna madiŋal gəl à vok tada à huma à gay la madəv kuɗa à Zəzagəla la ləv tekula kokuɗa masakal. ");
INSERT INTO mfh_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","La mahənay uwana naka Herod adala Piyer à huma à azladza, Piyer la madzehal gà la tataka azla­slodzi səla la abà, mawoɗəŋ à ahəŋ gà la maza­kazak səla, ŋgaha azlaməna manəŋla bay atà la slaka aŋatà la abà la gay gamagày. ");
INSERT INTO mfh_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","La kirim yewdi, malika aŋa Sufəl Zəzagəla apə̀hla vok ala, magol uɗaka aùɗ la gày daŋay la aku. Malika afetekà Piyer, atsənàŋ ala, agòɗal: “Sà à afik, katskats!” Azla­ma­za­kazak tanə̀sal à ahàl ala. ");
INSERT INTO mfh_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ŋgaha malika agòɗal: “Wàɗ para­para aŋak à tsəh, ŋgaha wàɗàhà kwimik aŋak!” Piyer aɗahàŋ kiya uwaga, ŋgaha malika agòɗal: “Dùw dəbdebi aŋak à vok, ŋgaha kà nəfà gi!” ");
INSERT INTO mfh_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piyer asà à uda la gày daŋay la aku la manəf malika. Asə̀l kà uwaga malika aɗehəŋ kà dziriga aw. Gəl aŋha agòɗ kà: ‘Mase­siŋay la uwana ase­sìŋla à gi’, agòɗ. ");
INSERT INTO mfh_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tatsə̀ɗ à azla­slaka azlaməna manəŋla teraŋa la vok ala, azla­masəla la vok ala, ŋgaha tabəzà à gay gamagày aŋa adà à vok, adà à huɗ gudəŋ. Gamagày uwaga apə̀zlla vok la ahàl aŋha la huma aŋatà, ŋgaha tasà à uda. Tadà à barama à ama. La abatà malika asàk à Piyer à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Uwana Piyer adavàh gəl ala lakəl aŋa uwana apakà vok kà, agòɗ: “Ndzer, Zəzagəla aslə̀l malika aŋha à waŋ kà mapəl gi ala la ahàl aŋa Herod, ŋgaha la mawi­siga uwana la abà gesina azla Yahu­diya tayàhla gi kà maɗàhgəŋ à vok gesina.” ");
INSERT INTO mfh_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Uwana adavàh gəl ala kà, ahàd à mtəga Mari­yama, iyà aŋa Yuhana uwana tazalalla Mark, la slaka uwana azladza aŋuvaw tahamà gay à vok kà madəv kuɗa. ");
INSERT INTO mfh_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piyer atsìzlla à gay gamagày aɗəɗàŋ, ŋgaha masla sləray misga, uwana sləm aŋha Rode, azà vok à gay gamagày à huɗ kà mapəzlay. ");
INSERT INTO mfh_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Katskats asə̀l kuda aŋa Piyer, aràb məŋga, ama apə̀zl gamagày aw adùw vok à gày, kà mapəh à azladza kà Piyer la uda la gay gamagày. ");
INSERT INTO mfh_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Kak kusoŋu!” Ama masla kà, agəɗàŋ afik ndzer kà, bà masla. Ŋgaha tagòɗal: “Uwaga malika aŋha!” ");
INSERT INTO mfh_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Tekeɗik Piyer asàk à maɗəɗ à gay gamagày aw. Uwana tapə̀zl gamagày tanəŋàŋ kà, tsa masla, ləv avàlàh à atà à gay gesina. ");
INSERT INTO mfh_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Piyer adzilà ahàl à zagəla, akokòt à atà à ahàl à adi, kà atà aŋa madz à ahəŋ titi, ŋgaha adzəkà matugw à atà uwana Sufəl Zəzagəla aɗahàŋ kà masəla à uda la daŋay la abà. Agòɗ à atà aya: “Kadàpəhaw à Yakuba, ŋgaha à azla­deda anik aya babay.” La lig la ahəŋ, asà à uda, adà aŋha à slaka anik. ");
INSERT INTO mfh_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Uwana məl ada­wulla kà, gəl akàɗ à azla­slodzi à vok: “Kakay Piyer adà aŋha ma?”, tagòɗàh à vok. ");
INSERT INTO mfh_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod ayàh, ama aɓə̀zal aw. Anavàh azlaməna manəŋla la gay ala, ŋgaha avà tetəvi kà makaɗ atà. La lig la ahəŋ masla à Herod ahàd, adzà à ahəŋ la Yahu­diya ŋgaha la Sama­riya. ");
INSERT INTO mfh_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","La mok uwatà kà, azlaməna gudəŋ Tir la azla Sədon tayàh matsən vok gay la Herod, kà uwana la abatà la uwana taɓəz tatak may aŋatà. Kà uwana Herod la mapak ləv gà lakəl aŋatà. Tasà à waŋ, takə̀s dza anik uwana à ahàl, masla manəŋla huɗ gày aŋa Sufəl, uwana sləm aŋha Bəlastus. Ŋgaha tahàd à slaka Herod kà manav məsəl vok. ");
INSERT INTO mfh_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","La abatà Herod akədə̀v à atà kaslà à ahəŋ, kà mapəh à atà gay. La mavakay uwatà, atsòkw à lukut sufəl aŋha à abà, ŋgaha adzà madzay la kursi sufəl aŋha la afik, ŋgaha apə̀h à atà gay la kuɗa zləkkà. ");
INSERT INTO mfh_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Maham à ahəŋ dza agòɗ: “Uwaga kà maɓaɗma aŋa dza asik aw”, tagòɗ, “Ama aŋa zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Uwana Herod atsənà uwaga kà, aɗə̀ɗ à gay ləv. Gay gà la uwaga malika aŋa Zəzagəla adùwal ɗuvats à gəl, madu­wari azùw à gay, ŋgaha amə̀ts, kà uwana azləɓà gəl aŋha bokuba Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kiya uwaga gay aŋa Sufəl Zəzagəla azigə̀n kaykay aya. ");
INSERT INTO mfh_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Mok uwana Barnabas atà la Sawul tadə̀vla sləray aŋatà à gay la gudəŋ Uru­sa­lima, tawùl à lig ŋgaha tazə̀ɓ Yuhana uwana à tsəh, tazalalla Mark. ");
INSERT INTO mfh_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","La tataka maham à ahəŋ məna gay Zəzagəla la abà la Anti­yews kà, azlaməna mapəh à atà gay à ahàl la ahəŋ kà mapàh à azladza, ŋgaha la azlaməna matapla: Barnabas, Səmeyyon uwana sləm aŋha marsiga, Lutsəyus zil Səren, la Manayen uwana tazigə̀n la slaka gà la Herod sufəl, ŋgaha Sawul. ");
INSERT INTO mfh_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","La vərdi anik, uwana tadə̀v kuɗa à Zəzagəla la makəs nəlay, Masasəɗok Zəzagəla agòɗ à atà: “Ɓə̀kàw gi, azla Barnabas atà la Sawul à fəta à awtày kà mahənəŋ sləray uwana ala, gəzàlla atà ala.” ");
INSERT INTO mfh_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Uwana takə̀ɗ gəl à madəv kuɗa la makəs nəlay, taɓə̀k atà à ahàl à gəl, ŋgaha taslə̀l atà à sləray à abà. ");
INSERT INTO mfh_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Bokuba uwana Masasəɗok Zəzagəla aslə̀l azla Barnabas atà la Sawul, tahàd à gudəŋ Səloy­səya, la abatà tahàd à kəslah iyaw à afik kà maday à gudəŋ uwana à afik la tataka iyaw la abà, sləm aŋha Sipəre. ");
INSERT INTO mfh_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Mok uwana tabəzay à Salamin, tadzəkà mapàh gay Zəzagəla la azlagày madəv kuɗa aŋa azla Yahu­diya la aku, Yuha­na, uwana tazalalla Mark, azlàk atà la sləray. ");
INSERT INTO mfh_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Taguwà à uda la gudəŋ uwatà la abà tsəràh à Pafos. La abatà taɓəzà məzla anik à gəl uwana sləm aŋha Bar-Yesu, zil Yahu­diya. “Gi masla mapəh à gi gay à ahàl”, agòɗ, ama tsa fida. ");
INSERT INTO mfh_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Masla kà tasə̀l vok lela la sufəl aŋa gudəŋ uwatà. Sləm aŋa sufəl uwatà kà Ser­giyus Pawlus, masla makor haŋkəli. Sufəl uwaga azàla Barnabas atà la Sawul kà matsən gay Zəzagəla la slaka aŋatà. ");
INSERT INTO mfh_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ama məzla uwatà (Uwana tazalalla Elimas la gay Gərək) akə̀s atà aw. Ayàh maɗəɗ gay à sufəl à ahəŋ kà matsən gay Zəzagəla, kà masla aŋa madiŋal gəl à vok aw. ");
INSERT INTO mfh_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kiya uwaga Sawul uwana tazalalla Pol babay, agà mahənlaga la Masasəɗok Zəzagəla, atsə̀k yewdi à məzla uwaga à gay. ");
INSERT INTO mfh_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ŋgaha agòɗ: “Kak ɗemɗem kahənla la makəsa­fər, kak kona aŋa seteni. Kak masla məzam aŋa tatak delga aŋa Zəzagəla gesina, kadà­sakal à tsəh ala, ma mbà à mawis dziriga aŋa Sufəl Zəzagəla ala ma? ");
INSERT INTO mfh_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Gəgoɗ à ka, tsənàŋ lagwa Sufəl Zəzagəla aɗəɗ kà: Kapàk guləf, kanəŋla aw la tataka mahənay anik la abà aya aw.” Katskats yewdi aŋa Elimas apàk məra­zlakka taɓa­ɗamma bokuba la vəɗ, taptap ayàh dza kà makəs à ahàl. ");
INSERT INTO mfh_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Uwana sufəl anəŋà uwaga apakà vok kà, adìŋ gəl à Zəzagəla à vok. Gay aŋa Sufəl Zəzagəla adàl à ləv à tsəh kaykay. ");
INSERT INTO mfh_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","La abatà azla Pol tasà à uda la gudəŋ Pafos, tahàd à kəslah iyaw à afik kà mad à Perge la kutso Pamfi­liya. La abatà la uwana Yuha­na, uwana tazala Mark bay, asàk atà à tsəh ala, awùl à Uru­sa­lima. ");
INSERT INTO mfh_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Tatsìlla ala la asik, dagay la Perge tahàd à Anti­yews la kutso Pisədiya. La vuɗ maduw ləv tahàd à gày madəv kuɗa à agu, tadzàhà madzay. ");
INSERT INTO mfh_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mok uwana tadzeŋay la wakità mapəhay aŋa azlaməna mapəh à atà gay à ahàl la abà, məŋga aŋa gày madəv kuɗa azàl à atà: “Azla­deda, baŋa akul la gay kà mapəh à maham à ahəŋ dza, kà madzərəɗàh atà ala kà kaslawwalla vok aŋa mapəhay lagwa à dagay.” ");
INSERT INTO mfh_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pol atsìzlla ala, adzìyla ahàl à zagəla, agòɗ à atà: “Akul azla Isərayel la azlatsəhay dza anik uwana kasləkawaw Zəzagəla, tsə̀ɓàw gi sləm! ");
INSERT INTO mfh_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Zəzagəla aŋa tsəhay gami Isərayel uwana atsa­tsà­mànì azla­baba gami madzi­dziga, azigənà tsəhay aŋha, mok uwana atà la məlok la Misəra, kiya uwaga asə̀lla atà à uda la Misəra la ndzəɗa aŋha məŋga. ");
INSERT INTO mfh_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Adzadzàr atà la kəsaf la abà mavay dzik ufaɗ. ");
INSERT INTO mfh_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Azàŋ ala makoray məɗəf la kutso Kanana, avà kutso uwatà à tsəhay aŋha. ");
INSERT INTO mfh_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Uwaga gesina aɗahàŋ bokuba mavay dadərmokw ufaɗ bəzi aŋha dzik zlo.” “La lig aŋa uwaga la ahəŋ, Zəzagəla aɓə̀k azlaməna seriya à azla­baba gami madzi­dziga à ahəŋ, tsəràh à zamana aŋa masla mapəhal gay à ahàl Samuyel. ");
INSERT INTO mfh_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","La lig la ahəŋ kà, tanavà maf à atà sufəl à ahəŋ ŋgaha Zəzagəla af à atà Sawlu à ahəŋ, kona aŋa Kis, uwana asà à uda la tsəhay aŋa Ben­yamin la abà, akòr mavay dzik ufaɗ. ");
INSERT INTO mfh_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","La lig la ahəŋ, Zəzagəla akweskà Sawlu, afà à atà David à ahəŋ kà sufəl. Apə̀h gay lakəl aŋha, agòɗ: ‘Ge­daɓəzal David kona Isay, dza uwana asà à ləv gulo, ŋgaha adà­ɗahgəŋ uwana asa à gi gesina.’ ");
INSERT INTO mfh_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Tekula la mayyi à tsəh ala aŋa David kà Yesu, à uwana Zəzagəla apakàŋ ala kà masla maɓəl azlatsəhay aŋha Isərayel, kiya uwaga à uwana apə̀h à ahəŋ dagay uwarà. ");
INSERT INTO mfh_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Mok uwana Yesu à lig mas à waŋ kà, Yuhana agòɗ: ‘Azla Isərayel, pə̀hàw gay la ləv ala, ŋgaha taɗa­ha­kullaŋ batem!’, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","La kaslà uwatà à uwana, Yuhana adaɓəz makəɗ gəl à ahəŋ sifa aŋha kà, agòɗ à atà: ‘Gi uwa, kagoɗaw uwa? Gi kà, gi dza uwana kakudaw aw. Ama fàw à sləm à abà, kà masla anəfa gi à tsəh à waŋ ŋgaha baməraka gi kà gəsla kà mapəl suwiɗ kwimik aŋha uwana ala, la asik aw.’ ");
INSERT INTO mfh_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Azla­deda, akul mayyi à tsəh ala aŋa Abəraham la azladza anik uwana kasləkawaw Zəzagəla. Gay aŋa maɓəlay uwanay asə̀lla kà à slaka gami. ");
INSERT INTO mfh_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ama azlaməna madz à ahəŋ la Uru­sa­lima, la azlaməŋga aŋatà kà, tatsənà godega aŋa Yesu aw, ŋgaha bay tatsənà mapəhay aŋa azlaməna mapəh à atà gay à ahàl uwana tadzèŋàh la azlagày madəv kuɗa la aku kəla vuɗ maduw ləv aw. Ama tagəɗà gay uwaga à afik la makəɗ Yesu. ");
INSERT INTO mfh_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Amiyaka taɓəzà tetəvi kà maɗukwlaŋ à ahəŋ kà makəɗay aw, bay kà tanavà Pilatus kà makəɗay. ");
INSERT INTO mfh_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Uwana tadə̀v uwana à gay taɗa­hàllàŋ à vok wakità Zəzagəla apə̀h lakəl aŋha gesina kà, tazə̀ɓ à ahəŋ la ahàf la adi, tafà à zəvay à agu. ");
INSERT INTO mfh_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ama Zəzagəla awùlla à uda la mamətsay. ");
INSERT INTO mfh_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Azla­ma­vakay aŋuvaw apàhla vok à azla­uwana tanəfà à waŋ la Galili tsəràh à Uru­sa­lima. Lagwa kà, atà la uwana azlaməna sayda aŋha la slaka azla Isərayel. ");
INSERT INTO mfh_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Anu la gəl gami mədasa à akul ala gay marabəŋ uwanay. Zəzagəla apə̀h à azla­baba gami madzi­dziga, azla Yahu­diya à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ada­gəɗəŋ à afik lagonay kà, anu azla­mayyi à tsəh ala aŋha. La mawulla Yesu à uda la mamətsay, bokuba uwana tatsetsèr à wakità aŋa mahabay masəla la abà: ˈKak bəzi gay ləv gulo, Lakana gədayyi ka.ˈ ");
INSERT INTO mfh_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Aganay babay uwana Zəzagəla apə̀h à ahəŋ lakəl aŋa mawulla à uda aŋha la mamətsay, kà masla aŋa mazinla aw. ˈNdzer, gədàpisakulla gay à vok la ahàl gulo bokuba Uwana gəpə̀h à David à ahəŋ uwarà.ˈ ");
INSERT INTO mfh_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Gay gà la uwaga David agòɗ la azla­slaka anik la abà: ˈIyay, kadàsaka dza aŋak la slaka mamətsay aw, kà mazinla aŋa dza aŋak aw.ˈ ");
INSERT INTO mfh_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David kà, masla kà aɗahà uwana asà à Zəzagəla tsəràh à mamətsay aŋha, tallà à makəla aŋa azla­baba gami madzi­dziga ŋgaha azìn ala. ");
INSERT INTO mfh_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ama dza uwana Zəzagəla awùlla à uda la mamətsay kà, azìn ala aw. ");
INSERT INTO mfh_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Azla­deda, delga kasəlaw, anu məza­kullaŋ kà, kà la Yesu la uwana Zəzagəla amàts tsakana à azladza ala. La masla la uwana Zəzagəla agə̀ŋ azla­uwana tadiŋ gəl à masla à vok sətaka, kà uwana mapəhay aŋa Musa kà aslà aw. ");
INSERT INTO mfh_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Lagwa kaɗahaw haŋkəli lakəl aŋa uwana azlaməna mapəh à atà gay à ahàl tapə̀h kà aŋa mazəɓ akul aw: ");
INSERT INTO mfh_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ˈLa kaslà aŋkul gədà­ɗe­həŋ sləray anik. Akul uwana kapəsewaw gay aŋa Zəzagəla, nərə̀zàw zlà, akul azlaməna mapəsew gay Zəzagəla, ləv aval à akul à gay, kamətsaw à gay kà sləray uwana gədada à ahəŋ la zamana aŋkul, kà uwana amiyaka tatapə̀hakulla godega aŋha bay kà naka kakəsaw aw.ˈ” ");
INSERT INTO mfh_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Mok uwana Pol atà la Barnabas tasà à lag la gày madəv kuɗa la aku kà, tagòɗ à atà kà, tadàwul à waŋ la vuɗ maduw ləv anik aya kà mapəh à anu lakəl aŋa uwaga aya gotənaŋ, tagòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mok uwana azladza taslə̀h ala, aŋuvaw la tataka azla Yahu­diya la abà, ŋgaha la azla­uwana taɓə̀ɗla vok à tsəhay Yahu­diya à abà, tanəfà Pol atà la Barnabas. Azla Pol tadzərə̀ɗàhàtàla kà matsizl à delga uwana à afik, Zəzagəla asàl maɗa­hatàŋ. ");
INSERT INTO mfh_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","La vuɗ maduw ləv azladza la gudəŋ uwatà gesina tahamà gay à vok kà matsən gay Sufəl Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Uwana azla Yahu­diya tanəŋà maham à ahəŋ dza kiya uwaga kà, atà maŋor akəsà atà, tafà guvəl à uwana à adi Pol apə̀h, ŋgaha tatsə̀kal mago­ɗahay à Pol à gəl. ");
INSERT INTO mfh_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pol atà la Barnabas tagòɗ à atà la paraka: “Azlayla kà vok, kà gay Zəzagəla agay mapəh à akul gà dadàŋ. Ama tsa kakwe­sawka gay sifa adəv gay aw kà, məday mədàziŋ à azladza uwana azla Yahu­diya aw zlà. ");
INSERT INTO mfh_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Aganay mafàh akur à ahəŋ, uwana Sufəl Zəzagəla afàhà à gi à lig, agòɗ: ˈGəfà à ka à ahəŋ, kà ka aŋa magay uɗaka aŋa azladza, kà ka aŋa maz gay maɓəlay à azladza uwana la makaɗ gəl à ahəŋ gudəŋ à vok gesina.ˈ” ");
INSERT INTO mfh_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mok uwana azla­uwana azla Yahu­diya aw tatsə̀n uwaga kà taràb. Tadzəkà mazləɓ gay aŋa Sufəl. Azla­uwana Zəzagəla atsa­tsà­mànì atà gesina kà, atà aŋa maɓəz sifa adəv gay aw kà, tadìŋal gəl à vok. ");
INSERT INTO mfh_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Gay Sufəl Zəzagəla asləhà gəl à ahəŋ la kutso uwatà la abà gesina. ");
INSERT INTO mfh_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ama azla Yahu­diya tavətsàhàh azlamis uwana ala sləm aŋatà la ahəŋ, azla­uwana taslə̀kàw Zəzagəla, la azla­ga­da­mola aŋa gudəŋ uwatà gesina, ŋgaha tayàh azla Pol la magazlay tsəràh à uwana takuɗə̀kàh atà à uda la makoray aŋatà la abà. ");
INSERT INTO mfh_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Azla Pol atà la Barnabas tagòɗ: “Gay gami la abà aw”, tagòɗ. Taɗèɗ à atà burburu aŋa gudəŋ aŋatà à adi, ŋgaha tahàd aŋatà à Iko­niyum. ");
INSERT INTO mfh_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Baməraka takuɗə̀kàh azla Pol la Anti­yews bay kà, azlaməna matapla la gudəŋ uwatà tagà la marabay, ŋgaha tahənà ala la Masasəɗok Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Uwana Pol atà la Barnabas tabəzà Iko­niyum, tahàd à gày madəv kuɗa à agu, bokuba uwana taɗahàŋ la Anti­yews babay, tsəràh à uwana gay məŋga aŋa azla Yahu­diya la azla­uwana azla Yahu­diya aw tadìŋal gəl à vok. ");
INSERT INTO mfh_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ama azla Yahu­diya uwana takweskà madiŋal gəl à vok, tavədzà­hàhà azladza uwana ala, atà azla Yahu­diya aw, kà atà aŋa madzugw mawi­siga lakəl azla­deda uwaga. ");
INSERT INTO mfh_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pol atà la Barnabas tadzà à ahəŋ məŋga la Iko­niyum, tapàh gay Sufəl Zəzagəla la dazu­waya. Tazà gay lakəl aŋa vok mahamay aŋha, ŋgaha Sufəl avà à atà ndzəɗa kà maɗàh azla­masəlay la azla­na­dzipo, kà mapəhla ala kà gay aŋatà kà dziriga. ");
INSERT INTO mfh_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Azladza gudəŋ uwaga tatsàk ala. Azlaanik tagà aŋa azla Yahu­diya, ŋgaha azlaanik tagà aŋa azlaməna asik. ");
INSERT INTO mfh_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Azla Yahu­diya la azladza uwana azla Yahu­diya aw, la azla­su­fəl aŋatà, taɗahà vok à ahəŋ kà matərəɓ azla Pol kà aŋa makəɗ atà la matsàh atà la akur. ");
INSERT INTO mfh_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Uwana azla Pol tada­tsən uwaga kà, tahòy aŋatà, tanəfà tetəvi uwana adà à Lisətəra la Derbe, la makoray aŋa Lika­wo­niya la abà. ");
INSERT INTO mfh_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Tadzəkà maz gay marabəŋ à azladza la abatà. ");
INSERT INTO mfh_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","La Lisətəra dza anik la ahəŋ adzà à ahəŋ kà la slaka madza madzay, kà uwana magul à afik gà dagay mayyay, aslàla vok adaday la asik aŋha, amiyaka asik tekula aw. ");
INSERT INTO mfh_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Vərdi anik kà, atsə̀ɓ sləm à uwana Pol apəhay. Pol atsə̀kal yewdi à gay ŋgaha anərə̀z kà masla la madiŋal gəl à vok, aslàla vok kà mawurla. ");
INSERT INTO mfh_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Kiya uwaga agòɗal, la kuda zləkkà: “Sà à afik, tsìzlla à asik aŋak à gay, dzawwa!” Hadzak, dza uwaga atsìzlla à asik aŋha à gay, adzəkà maday. ");
INSERT INTO mfh_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Uwana maham à ahəŋ dza adanəŋ uwaga Pol aɗahàŋ kà, tadzəkà mawiyay la gay gudəŋ aŋatà, gay Lika­wo­niya: “Azla­zəzagəla kà, tada­pakàh azladza gà adagay, ŋgaha tasà à tataka gami à abà la vəɗah!” ");
INSERT INTO mfh_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Tazàla à Barnabas Tsoys, sləm aŋa mazlazlay aŋatà, ŋgaha Pol bay kà, Herməs tagòɗal, kà uwana masla kà masla mapàh gay. ");
INSERT INTO mfh_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Masla mav tatak à Zəzagəla Tsoys, uwana la slaka mazlazlay kà, la gay gamagày aŋa mad à gày à huɗ gudəŋ, asə̀lla azla­kokur à waŋ, tatsa­fàɗàh atà gəl à uda la azla­ma­wu­ra­tatay à gay gamagày aŋa gày mazlazlay, asàl kà maham à ahəŋ dza takəɗ tatak à azla Barnabas atà la Pol. ");
INSERT INTO mfh_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Mok uwana tatsə̀n uwaga, tako­hàhà lukut à vok, tahòy à tataka maham à ahəŋ dza à abà la mawiyay: ");
INSERT INTO mfh_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Azla­slawda, kà mana kaɗahàw uwanay mi, anu bay kà anu azladza asik bokuba akul miya! Məsà à akul ala gay marabəŋ à waŋ kà mawulla akul à gəl kà akul masak azla­ma­zlazlay dey­dayga uwana kanəfaw lagwa, ŋgaha kà akul magola vok à slaka Zəzagəla, uwana la sifa, masla uwana aɗahà zagəla la kutso, la azla­mukwà ŋgaha la azla­tatak uwana la abà gesina! ");
INSERT INTO mfh_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","La zamana uwana uwarà kà, asàk azlatsəhay gesina kà manəf tetəvi aŋa gəl aŋatà. ");
INSERT INTO mfh_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Tekeɗik kà, apə̀lla vok à azladza la azlasləray aŋha dzəɓa aŋha səla aw gà uwana aɗehəŋ: Asùw akul iyaw, kalàw tatak la kaslà aŋha, avà à akul tatak may ŋgaha ahənà ləv akul ala la marabay.” ");
INSERT INTO mfh_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Baməraka la mapəhay kiya uwaga babay kà, la zla­zlaɗa taɗə̀ɗ gay à maham dza à ahəŋ kà makaɗ tatak. ");
INSERT INTO mfh_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","La kaslà uwatà, azla Yahu­diya anik tasà à waŋ la gudəŋ Anti­yews la kutso Pisədiya ŋgaha la Iko­niyum. Tavədzàh à tsəh azla­maham à ahəŋ dza à afik, tatsàh Pol la akur kà makaɗay, ŋgaha tasəpə̀r à uda la gudəŋ la abà kà uwana tadzùgw kà: ‘Adamətsay’, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ama uwana azlaməna madiŋal gəl à vok tahamà gay à vok lakəl aŋha kà, asà à afik, awùl à gudəŋ à abà. La bebəŋ gà kà, tahàd à Derbe atà la Barnabas. ");
INSERT INTO mfh_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pol atà la Barnabas tazà gay marabəŋ la Derbe la slaka uwana taɓəzà azladza aŋuvaw kà aŋa Yesu. Ŋgaha tawùl à Lisətəra, à Iko­niyum, à Anti­yews uwana la kutso aŋa Pisədiya la abà. ");
INSERT INTO mfh_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Kəla gudəŋ uwana tadàhà à abà kà, tadzərə̀ɗàhà azlaməna madiŋal gəl à vok ala, kà matsizl à madiŋal gəl à vok à afik. “Haɗay kà, mad à makoray Zəzagəla kà, say maguw à uda kà la azla­magol ŋgərpa la abà dadàŋ.” ");
INSERT INTO mfh_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","La kəla maham à ahəŋ məna gay Zəzagəla kà, tatsa­tsà­mà­hànì azladza kà mapak atà ala kà azla­ma­siga. Ŋgaha takə̀s nəlay, tadə̀v kuɗa kà aŋa azlaməna madiŋal gəl à vok, ŋgaha taɓə̀k à atà à ahàl aŋa Sufəl Zəzagəla, à uwana tadìŋal gəl à vok, tadà aŋatà. ");
INSERT INTO mfh_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tagùw à uda la kutso Pisədiya la abà ŋgaha tabəzà kutso Pamfi­liya. ");
INSERT INTO mfh_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Tazà gay Zəzagəla la Perge, la lig la ahəŋ tahàd à Ataliya. ");
INSERT INTO mfh_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Dagay la abatà tadà à kəslah iyaw à afik, tahàd à Anti­yews la gudəŋ uwatà la uwana taɓə̀k à atà à ahàl aŋa Zəzagəla, kà masla mav à atà vok mahamay kà aŋa sləray aŋha, sləray uwaga kà tahənàŋ ala lagwa. ");
INSERT INTO mfh_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Mok uwana tabəzay à Anti­yews, tahamà gay azlaməna madiŋal gəl à vok à vok gesina, ŋgaha tatùgw à atà uwana apakà vok la atà gesina, uwana Zəzagəla aɗahàŋ la atà, la mapəzl tetəvi à azladza uwana azla Yahu­diya aw, kà atà aŋa madiŋal gəl à vok babay. ");
INSERT INTO mfh_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Tadzà à ahəŋ məŋga la azlaməna madiŋal gəl à vok la abatà. ");
INSERT INTO mfh_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Azladza anik tasà à waŋ la Yahu­diya, tahàd à Anti­yews, tagòɗ à azla­deda: “Kaslawwalla vok kà maɓəlay aw, say baŋa kakədəvaw vok à uda, bokuba uwana mapəhay aŋa Musa apəh dàŋ.” ");
INSERT INTO mfh_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol atà la Barnabas takə̀s aw, tabayà vok gay lakəl aŋa uwaga. Taslə̀l Pol atà la Barnabas ŋgaha la azla­deda anik la Anti­yews, kà madla atà à Uru­sa­lima kà mapəhay lakəl aŋa gay uwaga la azlaməna matapla la slaka aŋa Yesu, la azla­ma­siga. ");
INSERT INTO mfh_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kiya uwaga azlaməna madiŋal gəl à vok taslə̀l atà. Taguwà à uda la Fe­nesəya la Sama­riya la mapàhla ala gay magola vok aŋa azla­uwana azla Yahu­diya aw à slaka Zəzagəla. Gay mawga uwaga kà, avà marabay à azladza gesina. ");
INSERT INTO mfh_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Mok uwana tabə̀z à Uru­sa­lima, azlaməna matapla la slaka aŋa Yesu, la azla­ma­siga, ŋgaha la azlaməna madiŋal gəl à vok takə̀s atà la ahàl səla, ŋgaha azla Pol tapə̀h à atà tatak uwana Zəzagəla aɗahàŋ la atà gesina. ");
INSERT INTO mfh_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ama azlaməna madiŋal gəl à vok anik, uwana taguwà à uda la maham à ahəŋ aŋa azla Farisəya la abà kà, tagòɗ kà: “Say makadav azlaməna madiŋal gəl à vok uwana à uda azla Yahu­diya aw, ŋgaha mətapatàla aya makəs mapəhay aŋa Musa dadàŋ kəla.” ");
INSERT INTO mfh_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","La abatà azlaməna matapla la slaka aŋa Yesu, la azla­ma­siga tahamà gay à vok kà manərəz gay uwaga. ");
INSERT INTO mfh_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","La lig mavats gay məŋga uwaga la ahəŋ, Piyer asà à afik, agòɗ: “Azla­deda, kasəlaw kà Zəzagəla akə̀sànì gi la tataka aŋkul la abà dagay uwarà, kà gi aŋa maz gay marabəŋ à azladza uwana azla Yahu­diya aw. Kà atà aŋa matsənəŋ, ŋgaha kà atà aŋa madiŋal gəl à vok bay. ");
INSERT INTO mfh_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Zəzagəla uwana masla masəl madzugway aŋa ləv aŋa azladza gesina, apə̀hla ala kà awoyà azladza uwaga babay, avà à atà Masasəɗok aŋha bokuba uwana avà à anu babay. ");
INSERT INTO mfh_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Zəzagəla avà­hà­nula la atà aw: Agà ləv aŋatà sətaka, kà uwana tadìŋal gəl à vok. ");
INSERT INTO mfh_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ŋgaha ma, kà mana lagonay kà, katàpàw Zəzagəla la maf atà magol mahanay məŋga à gəl ma? Baməraka anu, la azla­baba gami madzi­dziga kà məslàla vok aŋa mazəɓay tekeɗik aw ma? ");
INSERT INTO mfh_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","La madiŋal gəl à Sufəl Yesu à vok kà, vok mahamay aŋha la uwana mədàɓəlay, kiya uwaga babay la atà aw takay?” ");
INSERT INTO mfh_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kiya uwaga maham à ahəŋ dza adzà à ahəŋ titi, tatsə̀ɓ sləm à Barnabas atà la Pol uwana tapə̀h à atà azla­na­dzipo uwana Zəzagəla aɗa­hàhàŋ la ahàl aŋatà la tataka aŋa azladza uwana la abà, azla Yahu­diya aw. ");
INSERT INTO mfh_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Mok uwana takə̀ɗ gəl à maɓaɗma, Yakuba aɓə̀ɗ à gay à gay agòɗ: “Azla­deda, tsə̀ɓàw sləm dàŋ! ");
INSERT INTO mfh_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Səmon atùgw lakəl aŋa Zəzagəla bokuba uwana akə̀s azladza uwana azla Yahu­diya aw, dagay la mok uwana Zəzagəla akàsànì azladza anik aŋatà, kà atà magay azlaaŋha. ");
INSERT INTO mfh_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ŋgaha mapəhay aŋa azlaməna mapəh à atà gay à ahàl agagàm la uwaga. Kiya uwana matse­tseray agòɗ: ");
INSERT INTO mfh_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ˈLa lig aŋa uwaga la ahəŋ, Sufəl Zəzagəla agòɗ: ‘Gədàwul à waŋ, Gədàŋal ŋvagay aŋa David uwana akàlàh à ahəŋ, Gədà­tsizl uwaga ala. ");
INSERT INTO mfh_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ŋgaha kà pəra, azladza gesina kà mayàh gi.’ Sufəl Zəzagəla agòɗ. ‘Tsəhay gesina uwana gəzàl atà, atà magay azla­gulo.’ ");
INSERT INTO mfh_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Kiya uwaga à uwana Sufəl Zəzagəla agòɗ, à uwana apə̀hla uwaga ala dagay uwarà la viyaŋu.ˈ” ");
INSERT INTO mfh_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Gay gà la uwaga Yakuba azàlàŋ à gəl, agòɗ: “Gi kà madzugway gulo kà, asa à gi makaɗ gəl à azlatsəhay anik uwanay à vok tagolà vok à slaka Zəzagəla aw. ");
INSERT INTO mfh_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ama ŋuləm mətsetser à atà, kà tapaɗ sləɓ uwana tadàhla matuwlay la mazlazlay aw, kà uwana uwaga kà mawi­siga, taɗahàh mabila aw, tapaɗ tatak uwana tasùfàŋ ala masufay aw, tasa aŋiz aw, kà uwana uwaga kà mawi­siga. ");
INSERT INTO mfh_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kay dagay uwarà kà, azladza tapàh mapəhay aŋa Musa la kəla gudəŋ aŋha tadzèŋàh la kəla vuɗ maduw ləv la gày madəv kuɗa la aku!” ");
INSERT INTO mfh_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kiya uwaga azlaməna matapla la slaka aŋa Yesu, la azla­ma­siga, la azlaməna madiŋal gəl à vok takə̀s matsa­tsa­mani azladza anik la tataka aŋatà la abà kà, kà masləl atà la azla Pol la Barnabas à Anti­yews. Yahuda uwana tazàlalla Barsabas atà la Silas, atà səla nna azlaməna madiŋal gəl à vok masəl atà gà. ");
INSERT INTO mfh_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Taslə̀l atà la wakità uwaga la ahàl: “Anu azlaməna matapla la slaka aŋa Yesu, la azla­ma­siga la uwana mətsetser à akul. ‘Ayyi’, məgoɗ à akul, akul azlaməna madiŋal gəl à vok, uwana akul azla Yahu­diya aw la Anti­yews ŋgaha la azla­uwana la kutso Səriya la Səlisəya. ");
INSERT INTO mfh_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mətsənàŋ kà azladza anik tasà à uda la tataka gami la abà la abanay, tadà à awtày kà maka­ɗa­kulla gəl à vok, ŋgaha la mav à akul madzugway la gay aŋatà. Anu kà, məpə̀h à atà gay à ahàl lakəl aŋa uwaga aw. ");
INSERT INTO mfh_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Gay gà la uwaga, gesina gami, məkà­sànì azladza kà masləl à akul à awtày, talakà azla­deda gami mawoy atà gà uwaga à awtày Barnabas atà la Pol, ");
INSERT INTO mfh_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","uwana tadùw sifa aŋatà ala kà sləray aŋa Sufəl Yesu Kristu. ");
INSERT INTO mfh_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Məsləl akul azla Yahuda atà la Silas à awtày, tadàpəh à akul lakəl aŋa uwana məda­tse­tseray la abanay lagwa. ");
INSERT INTO mfh_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Akə̀s à Masasəɗok tsi­kasla la gəl anu gesina gami, məkə̀s kà manəf akul, akə̀s à maham à ahəŋ anik à gəl aya aw, say uwanay məpə̀h la uwana akəsà vok pəra. ");
INSERT INTO mfh_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kapaɗaw sləɓ matulay aw, la aŋa mazlazlay aw; kasaw aŋiz aw, kapaɗaw sləɓ aŋa tatak uwana tasufaŋ ala masufay aw, kadaw à gəl gaw aw. Baŋa kasakaw uwaga la tsəh ala gesina kà, kà kaɗahàw delga. Mədzà à ahəŋ wurwur zlà!” ");
INSERT INTO mfh_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Mok uwana tavà à atà wakità uwaga: “Dàw zlà!”, tagòɗ à atà. Azlaməna masləlay tahàd, tabəzà à Anti­yews. La abatà tahamà gay azlaməna madiŋal gəl à vok à vok gesina, ŋgaha tavà à atà wakità uwatà. ");
INSERT INTO mfh_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Atà tadzèŋ, ŋgaha adzərə̀ɗàhàtàla, taràb kaykay lakəl aŋha! ");
INSERT INTO mfh_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yahuda atà la Silas tagà azlaməna mapəh à atà gay à ahàl kà mapàh à azladza, la gəl aŋatà tavàts gay məŋga la azla­deda kà madzərəɗàh atà ala la mav à atà ndzəɗa. ");
INSERT INTO mfh_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Uwana tasafay la abatà, azla­deda talakà atà: “Dàw la wurwur zla!”, tagòɗ à atà, ŋgaha tawùl à slaka azladza uwana taslə̀lla atà à waŋ. (( ");
INSERT INTO mfh_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ama Silas kà, kà ayàh madz à ahəŋ la abatà.)) ");
INSERT INTO mfh_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Tekeɗik Pol atà la Barnabas tasàf la Anti­yews, La azladza anik aŋuvaw, tapà­hàhla azladza la maz gay aŋa Sufəl Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Uwana tadadza à ahəŋ ŋuv, Pol agòɗ à Barnabas: “Məwùlàw, mədà­naŋaw azla­deda à gay la azla­slaka uwana məzàhàw gay aŋa Sufəl Zəzagəla, kà anu aŋa masəl madz à ahəŋ aŋatà.” ");
INSERT INTO mfh_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas kà, asàl madla Yuhana uwana tazalalla Mark la tsəh. ");
INSERT INTO mfh_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ama Pol akə̀s kà madalla aw, kà uwana vərdi anik kà, asàk atà à ahəŋ la kutso Pamfi­liya, awùlla atà à tsəh ala la sləray aŋatà la abà. ");
INSERT INTO mfh_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mapak ləv adà à tataka aŋatà à abà. Tavà­hàla tsəràh à uwana Barnabas azə̀ɓ Mark, tahàd à kəslah iyaw à afik kà maday à Sipəre. ");
INSERT INTO mfh_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pol azə̀ɓ Silas. Ŋgaha azlaməna madiŋal gəl à vok tadə̀v kuɗa kà atà, kà Zəzagəla aŋa mavàhàh à atà vok mahamay aŋha, ŋgaha tatzìlla ala. ");
INSERT INTO mfh_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pol ahàd à kutso Səriya la Səlisəya, adzərə̀ɗàhà azlaməna madiŋal gəl à vok ala la madiŋal gəl à vok la abà. ");
INSERT INTO mfh_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol abəzà Derbe ŋgaha à Lisətəra. La abatà masla madiŋal gəl à vok anik la ahəŋ, sləm aŋha Timo­tawus. Iyà aŋha kà dəg zla Yahu­diya, masla madiŋal gəl à vok. Ama baba aŋha kà tsəhay zil Gərək. ");
INSERT INTO mfh_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Azla­deda uwana la Lisətəra ŋgaha la Iko­niyum gesina kà, tafà madzugway aŋatà kà à masla à afik. ");
INSERT INTO mfh_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol asàl mazəɓ Timo­tawus kà magay manalay aŋha. Kà maday atà səla kà, akədə̀v à uda dadàŋ. Aɗahàŋ kiya uwaga kà, kà uwana azla Yahu­diya uwana tadzà à ahəŋ la abatà gesina kà, tasə̀l kà baba aŋa Timo­tawus kà zil Yahu­diya aw. ");
INSERT INTO mfh_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kəla gudəŋ uwana tagùwàh la abà kà, tapàh à azlaməna madiŋal gəl à vok, tatak uwana azlaməna matapla la slaka aŋa Yesu, la azla­ma­siga la Uru­sa­lima tapə̀h, ŋgaha tafàh à atà akur à lig kà makəs mapəhay uwatà lela. ");
INSERT INTO mfh_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kiya uwaga məna madiŋal gəl à vok tadzərə̀ɗàhà ala la madiŋal gəl à vok la abà, ŋgaha matugway aŋatà azàhàla vok à gəl kəla mahənay. ");
INSERT INTO mfh_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ama Masasəɗok Zəzagəla aɗə̀ɗ à atà gay à ahəŋ kà maz gay Zəzagəla la kutso Asəya, kà uwaga à uwana taguwà à uda la Fərizi la Gala­tiya. ");
INSERT INTO mfh_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Mok uwana tabəzà Misiya kà, asà à atà mad à kutso Biti­niya à abà, ama Masasəɗok aŋa Yesu avà à atà tetəvi gotənaŋ aw. ");
INSERT INTO mfh_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kà uwaga taguwà la Misiya, ŋgaha tadà à ahəŋ à gay dərəv la Tərowas. ");
INSERT INTO mfh_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","La huɗ aŋa vəɗ mase­siŋay ase­sìŋla Pol. Anəŋà zil Make­du­niya atsìzlla à ahəŋ, adə̀val kuɗa: “Guwà à waŋ la Make­du­niya kà mazlak anu!”, agòɗal. ");
INSERT INTO mfh_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Katskats la lig aŋa mase­siŋay uwaga la ahəŋ, məyàh tetəvi kà maday à Make­du­niya. Məsə̀l kà Zəzagəla azàla anu kà maz gay marabəŋ à azladza la kutso uwatà la abà haɗay. ");
INSERT INTO mfh_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Mətsìzlla ala la gudəŋ Tərowas la kəslah iyaw, tərra, məhàd à gudəŋ uwana à afik la tataka iyaw la abà, sləm aŋha Samotəras, la bebəŋ gà məzlaŋàl la Ne­ya­po­ləs. ");
INSERT INTO mfh_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Dagay la abatà la uwana, məhàd à Fili­piya uwana gudəŋ teraŋa la makoray Make­du­niya, slaka madz à ahəŋ aŋa azla Rom. Mədzà à anu à ahəŋ la abatà. ");
INSERT INTO mfh_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","La vuɗ maduw ləv mədà à uda la gudəŋ la abà kà mayàh slaka madəv kuɗa aŋa azla Yahu­diya la gay mukwà. Mədzàhà madzay ŋgaha mətapla azlamis uwana tahamà gay à vok la abatà. ");
INSERT INTO mfh_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tekula la tataka aŋa azlamis uwatà la abà, sləm aŋha Lidiya, asà à waŋ la gudəŋ Tiyatir, masla matsakal azla­sana, uwana iyaw aŋha zla­zlaɗa, masla mahoy adi aŋa Zəzagəla babay. Atsə̀ɓ anu sləm, ŋgaha Sufəl Zəzagəla azàla haŋkəli kà masla aŋa maf sləm à uwana Pol apəhay. ");
INSERT INTO mfh_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","La abatà taɗà­halla batem la azlaməna huɗ gay aŋha gesina, azàla anu à mtəga aŋha la magoɗay: “Bokuba uwana tsa kasəlaw kà gəda­diŋal gəl à Zəzagəla à vok la dziriga kà, sàw à waŋ, kadzaw à ahəŋ la mtəga gulo”, agòɗ à anu. Afà anu leri à gəl. ");
INSERT INTO mfh_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Vərdi anik la ahəŋ uwana mədà à slaka madəv kuɗa kà, məgagàm la dugu mayà gà, uwana la masasəɗok mawi­siga lakəl. Apàhàh tatak uwana adàpaka vok la huma la gay, la mapàh tatak uwaga kà, adaɓəz sili kà aŋa məŋga aŋha. ");
INSERT INTO mfh_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Adzəkà manəf anu la tsəh, awiyaa agòɗ: “Azladza uwanay kà, azlaməna sləray aŋa Zəzagəla uwana kərkər la afik! Tapəha­kulla tetəvi uwana Zəzagəla adàɓəla akul!” ");
INSERT INTO mfh_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Apə̀hàh uwaga mavakay dəŋ. La makəɗ gəl à ahəŋ, Pol adày vok, agolà vok à slaka aŋha, agòɗ à masasəɗok mawi­siga: “Kak masasəɗok mawi­siga, la sləm aŋa Yesu: Sà à uda la masla la abà, gəgoɗ à ka!” La kirim yewdi masasəɗok asà à uda. ");
INSERT INTO mfh_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Mok uwana azlaməŋga aŋa dugu mayà uwaga tanəŋàŋ kà taɓəz sili aya aw kà, takàs azla Pol atà la Silas ŋgaha tabayà atà à vada­vaday kasukwa à afik tsəràh à huma aŋa azlaməŋga aŋa gudəŋ. ");
INSERT INTO mfh_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Tadàla atà à slaka azla­gumna aŋa azla Rom ŋgaha tagòɗ: “Azladza uwanay kà, tatsàlla magazlay à gudəŋ gami à abà, atà kà, azla Yahu­diya. ");
INSERT INTO mfh_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ŋgaha tapàhla mapəhay uwana ala wakità seriya gami avəra gay à azladza, anu uwana anu azla Rom, kà manəfay la makəsay.” ");
INSERT INTO mfh_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Maham à ahəŋ dza ahamà atà à gəl. Azla­gumna tahàl lukut aŋa Pol atà la Silas, ŋgaha tavà tetəvi kà mazlaɓàh atà la kurpi. ");
INSERT INTO mfh_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Uwana tazlàɓàh atà la kurpi kà, tawìts atà à daŋay, ŋgaha tafàhà akur à azlaməna manəŋla à atà à lig kà, kà manəŋla atà lela. ");
INSERT INTO mfh_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Uwana masla manəŋla atà adatsən gay uwaga kà, awìts atà à daŋay huɗ gà à agu, ŋgaha aɓə̀k atà sasala à asik. ");
INSERT INTO mfh_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","La huɗ aŋa tataka vəɗ azla Pol atà la Silas tadə̀v kuɗa, ŋgaha tahàb kà mazləɓ Zəzagəla; azlaməna daŋay anik tatsənà atà babay. ");
INSERT INTO mfh_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Katskats kutso aɓəlàkà vok məŋga məŋga, baməraka mata­tukway aŋa gày kà aɓəlàkà vok, katskats azla­ga­magày tapàzlla vok, ŋgaha la kità bay, azla­sa­sala la azla­ma­za­kazak tapal­làhà à vok à azlaməna daŋay la vok ala kokuɗa gəl aŋatà. ");
INSERT INTO mfh_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Masla manəŋla azlaməna daŋay atsənà ala. Uwana anəŋàŋ kà gamagày aŋa gày daŋay mapazl vok gà, aɓə̀ɗ katsakar aŋha kà makəɗ vok, kà uwana adzùgw kà, azlaməna daŋay tahoyay. ");
INSERT INTO mfh_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ama Pol awiyà la ndzəɗa: “Kay, kakəɗ vok aŋak aw, anu gesina gami la ahəŋ!” ");
INSERT INTO mfh_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Masla manəŋla uwaga anàv akàl, ahàd à gày daŋay à agu la katskats la masəkulay la abà kà guba, atə̀ɗ à makəla asik aŋa azla Pol atà la Silas. ");
INSERT INTO mfh_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ŋgaha asə̀lla atà à uda, anavà atà: “Azlaməŋga gulo, mana gəɗehəŋ kà gi aŋa maɓəlay ma?” ");
INSERT INTO mfh_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Tawulàlla: “Dìŋ gəl à Yesu à vok, ŋgaha kaɓəlay, kak la huɗ gày aŋak gesina!” ");
INSERT INTO mfh_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ŋgaha tazàla gay aŋa Sufəl Zəzagəla la azlaməna huɗ gày aŋha gesina. ");
INSERT INTO mfh_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Masla manəŋla gày daŋay uwaga, ahə̀l atà à uda la vuɗ uwatà, ŋgaha apàlàh azlaamik aŋatà. La lig la ahəŋ taɗà­halla batem la azlaməna huɗ gày aŋha gesina. ");
INSERT INTO mfh_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Adàla azla Pol la Silas à gày aŋha à agu, ŋgaha avà à atà tatak may. Zil uwaga la azlaməna huɗ gày aŋha gesina tahə̀n ala la marabay, kà uwana tadìŋ gəl à Zəzagəla à vok. ");
INSERT INTO mfh_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Mok uwana məl adawula, azla­gumna aŋa azla Rom, taslə̀l dza à slaka masla manəŋla gày daŋay la magoɗal: “Sàk azladza uwaga, tahàd aŋatà”, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Masla manəŋla asà à waŋ, apə̀h à azla Pol, agòɗ à atà: “Azla­gumna tav tetəvi kà mawits akul à gəl. Kaslawwalla vok aŋa mas à uda, kà madiy aŋkul la lapiya.” ");
INSERT INTO mfh_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ama Pol agòɗ à azlaməna masləlla atà à waŋ: “Lakuhu tazlàɓàh anu la vada­vaday kasukwa la afik, ŋgaha kà pəra tawìts anu à gəl kokuɗa maɗàh seriya gami, tsa anu babay kà, anu azla Rom kà pəra, tawìts anu à gəl, la gəl à gəl ma kà mana mi?! Kiya uwaga aw! Say atà la gəl aŋatà tatsa à waŋ kà mapəl anu ala, kəla!” ");
INSERT INTO mfh_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Azlaməna masləllay tawùlla à gay uwaga à azla­gumna Rom. Ama guba akə̀s atà kaykay kà uwana tatsənàŋ kà Pol la Silas kà azla Rom. ");
INSERT INTO mfh_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kiya uwaga, atà tasà à waŋ tadə̀v atà kuɗa, ŋgaha tasə̀lla atà à lag la gày daŋay la aku, ŋgaha aya tadə̀v atà kuɗa kà mas à uda la kutso aŋatà la abà. ");
INSERT INTO mfh_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Uwana Pol atà la Silas tadasa à uda la daŋay, tahàd à mtəga Lidiya dadàŋ. Uwana tanə̀ŋ azla­deda la abatà tadzərə̀ɗàhàtàla, ŋgaha tahàd aŋatà. ");
INSERT INTO mfh_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Tanəfà tetəvi uwana aguwà la Amfi­polis la Apo­lo­niya ŋgaha tabəzà Te­sa­lo­niki. Gày madəv kuɗa aŋa azla Yahu­diya la ahəŋ la abatà. ");
INSERT INTO mfh_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Bokuba uwana adagay zagəlà aŋa Pol, ahàd à gày madəv kuɗa à agu. Mavakay maduw ləv makər, Pol atsanà vok gay atà nna lakəl aŋa wakità Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Atàpàhàtàla la madzərəɗàhatàla, kà akəsà vok kà Kristu asà ŋgərpa, ŋgaha awùl à uda la mamətsay, Pol agòɗ à atà: “Yesu uwanay gəpə̀h à akul kà, Kristu gà la uwaga.” ");
INSERT INTO mfh_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Azladza anik la tataka aŋatà la abà takə̀s uwaga, tanəfà Pol atà la Silas. Azla Gərək uwana tahòy yewdi aŋa Zəzagəla la azlamis huɗ gudəŋ uwana sləm aŋatà la ahəŋ aŋuvaw. ");
INSERT INTO mfh_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ama azla Yahu­diya tahə̀n ala la maŋor. Kiya uwaga tahamà gay azla­bu­ɗaray à vok, tawiyà kà maf à tsəh à maham à ahəŋ dza à afik la magazlay la huɗ gudəŋ. Tahàd à mtəga Yason kà mayàh azla Pol atà la Silas, kà madla atà à huma aŋa azlaməna sawaray. ");
INSERT INTO mfh_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Uwana taɓə̀z azla Pol la abatà aw kà, tabayà Yason la azla­deda anik à huma aŋa azlaməŋga aŋa gudəŋ, ŋgaha tadzəkà mawiyay: “Azladza uwana tawìs gudəŋ à vok ala kà, atà, la uwanay tabəzà à abanay lakana. ");
INSERT INTO mfh_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yason akə̀s atà à mtəga aŋha, azladza uwaga gesina tapəsèw mapəhay aŋa sufəl aŋa Rom, kà uwana tapəhay kà məŋ sufəl anik la ahəŋ, uwana sləm aŋha Yesu”, tagòɗ. ");
INSERT INTO mfh_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Gay uwaga avədzàhà à tsəh à maham à ahəŋ dza à afik la azlaməŋga aŋa gudəŋ. ");
INSERT INTO mfh_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Kiya uwaga azlaməŋga tafà leri à azla Yason à gəl kà tapə̀l sili dàŋ kà maduw atà à gəl. ");
INSERT INTO mfh_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Uwana vəɗ adasa à waŋ, azla­deda tagòɗ à Pol atà la Silas: “Dàw aŋkul à Bere!”, tagòɗ à atà. Mok uwana tabəzà abatà kà, tahàd à gày madəv kuɗa aŋa azla Yahu­diya à agu. ");
INSERT INTO mfh_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Azla­uwanay kà madzugway aŋatà kà delga, kà azla Yahu­diya aŋa Te­sa­lo­niki, takə̀s gay Zəzagəla la ahàl səla, kəla mavakay tamədzèɗàh huɗ aŋa wakità, kà masəlay à baŋa uwana Pol apəhay kà dziriga. ");
INSERT INTO mfh_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ŋgaha aŋuvaw la tataka aŋatà la abà tadìŋal gəl à vok. Azla Gərək la azlamis uwana sləm aŋatà la ahəŋ, la azlazil tadìŋal gəl à vok. ");
INSERT INTO mfh_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ama uwana azla Yahu­diya uwana la Te­sa­lo­niki tatsənàŋ kà Pol apə̀h gay Zəzagəla la Bere kà, tasà à waŋ la maham à gay azladza à vok, kà mavədzàh azladza ala. ");
INSERT INTO mfh_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kiya uwaga azla­deda tadàla Pol à gay dərəv, ama Silas atà la Timo­tawus tagə̀ɗ à Bere. ");
INSERT INTO mfh_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Azla­uwana talakà Pol, tabə̀zla tsəràh à Atena. La lig la ahəŋ tawùlla aŋatà à Bere la gay uwana la ahàl Pol, apə̀h à atà kà mapəh à azla Silas atà la Timo­tawus, kà tabə̀zalla vok la katskats. ");
INSERT INTO mfh_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Mok uwana Pol akùd azla Silas atà la Timo­tawus la Atena kà, ləv azə̀ŋ məŋga kà manəŋ gudəŋ uwaga adahənla la azla­ma­zlazlay. ");
INSERT INTO mfh_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Taba­yàhà vok gay la azla Yahu­diya la gày madəv kuɗa la aku, la azla­uwana azla Yahu­diya aw, ama tahòy yewdi aŋa Zəzagəla, la azla­uwana la vada­vaday kasukwa la afik, ŋgaha la azla­uwana taga­gàmàh la masla. ");
INSERT INTO mfh_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Azlaməna matapla azladza anik azla Epi­ku­riya ŋgaha la azla Səto­yi­səya tavàts gay la masla. Azlaanik tagòɗ: “Mana masla gay zlaw­z­lawga uwanay agòɗ lagwa zlà ma? Zlahaw kà apəhay kà gay aŋa azla­zəzagəla məlok gà.” Tapə̀h uwaga kà, kà uwana Pol apəhay lakəl aŋa Yesu, ŋgaha lakəl mawul à uda la mamətsay. ");
INSERT INTO mfh_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kiya uwaga takə̀s, tadàlla à gudəŋ uwana à afik Are­wopez la huma aŋa azlaməna sawaray, ŋgaha tagòɗal: “Lagwa asa à anu masəlay matapla, ma uwala asa à ka matapanula? ");
INSERT INTO mfh_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kà uwana asa à ka matapanula azla­tatak məlok gà, ŋgaha bay asa à anu masəl godega aŋha zlà.” ");
INSERT INTO mfh_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Azla Atena la azlaməlok dza uwana tadzà à ahəŋ la tataka aŋatà la abà, taɗahà tatak aw, say matsən azlagay mawga uwana tavàts pəra) ");
INSERT INTO mfh_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Hadzak, Pol atsìzlla ala la tataka aŋa azlaməna sawaray la abà ŋgaha agòɗ: “Azla Atena, gədzùgw kà akul kanəfaw azlatsəhay zəzagəla anik anik gərga­gər. ");
INSERT INTO mfh_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Haɗay, bokuba uwana gədau­gu­zahay la huɗ gudəŋ aŋkul la abà kà, gənəŋà azla­slaka mazlazlay aŋkul. Ŋgaha gənəŋà anik aya uwana tatse­tsèral à vok: ‘Slaka uwana kà aŋa zəzagəla dza asəl sləm aŋha aw.’ Iyay zlà! Kasləkawaw kokuɗa masəlay, ama gi kà gəsəl, uwana gəsà à waŋ kà mapəha­kulla. ");
INSERT INTO mfh_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Masla la uwana aɗahàŋ gudəŋ à vok, la azla­tatak uwana la huɗ aŋha gesina, ama masla kà adza à ahəŋ la azlagày uwana la aku, ahàl aŋa dza aŋàl aw. ");
INSERT INTO mfh_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Masla kà anəkuɗa kà dza aŋa maɗa­halla tatak aw, kà uwana masla la uwana av sifa à dza la masafay gesina. ");
INSERT INTO mfh_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","La dza tekula la abà, la uwana mayyi à tsəh ala apakà vok gesina, ŋgaha aɓə̀k atà à ahəŋ la gudəŋ uwanay la vok. Dagay uwana aləg maɗàh vok, afàh azla­kaslà à ahəŋ la azla­makwi aŋa madz à ahəŋ aŋatà babay. ");
INSERT INTO mfh_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Aɗahà à atà kà atà mayàh masla təzlta­təzl, kà atà aŋa maɓəzal. Ama la dziriga kà, Zəzagəla kà kərkər la uwa­be­yuwi gami aw, ");
INSERT INTO mfh_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kà uwana: ˈLa masla anu la sifa masla la vok aŋa masafay anu la ahəŋ.ˈ Delga à uwana azladza anik aŋkul tahàb, ŋgaha tagòɗ: ˈAnu babay kà anu azlabəza aŋha.ˈ ");
INSERT INTO mfh_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Tsa anu azlabəza aŋa Zəzagəla kà, məslala vok məga­gazləla la madzugway kà, Zəzagəla kà bokuba luwà­luwà, sili, baŋaw akur aw. Kà uwana aŋa azla­tatak uwaga kà, dza aɗahà à atà la haŋkəli aŋha, kà azla­ma­zlazlay aŋha. Azla­tatak uwaga kà azlaaŋa Zəzagəla aw. ");
INSERT INTO mfh_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Iyay, kà uwana Zəzagəla atugw tsakana aŋa uwarà aya aw, kà uwana azladza tadza à ahəŋ kà la mawur gəl aw la abà. Ama lagonay kà, adazala azladza baməraka leli gesina, kà mapəh gay la ləv ala. ");
INSERT INTO mfh_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","La haɗay gà kà, afà mavakay tekula à ahəŋ, à uwana adàɗah seriya à gudəŋ à vok à gəl la dziriga. La ahàl aŋa dza tekula uwana akə̀sànì, ŋgaha apə̀hanula masla la mawul à uda la mamətsay.” ");
INSERT INTO mfh_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Uwana tatsənà, kà Pol apə̀h lakəl aŋa mawul à uda la mamətsay kà, azladza anik takəɗàslal, azlaanik tagòɗ: “Iyay, lagwa kà, asa à anu aŋa mədàtsəɓal sləm vərdi anik aya zlà!” ");
INSERT INTO mfh_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kiya uwaga à uwana, Pol asà à uda la tataka aŋatà la abà. ");
INSERT INTO mfh_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Azlaanik tadà à atà à adi, tadìŋal gəl à vok. La tataka aŋatà la abà kà Denəs tekula la tataka maham à ahəŋ sawaray, uwana la abà la gudəŋ la afik, mis anik uwana sləm aŋha Damarəs, ŋgaha la azladza anik aya. ");
INSERT INTO mfh_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","La lig aŋa uwaga la ahəŋ, Pol atsìzlla ala la Atena ŋgaha ahàd à Korin­tiya. ");
INSERT INTO mfh_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Zil Yahu­diya anik la ahəŋ la abatà, sləm aŋha Akilas, tagagàm la Pol. Pol ahàd à mtəga aŋha kà manəŋ atà à gay. Masla kà, tayyà kà à makoray aŋa Pontiya à abà, ama asafay la abatà aw. Asà à waŋ kà la Italiya la ahàl à ahàl atà la mis aŋha Pərəskila, kà uwana sufəl Rom, uwana sləm aŋha Kəlod, akuɗə̀kàh azla Yahu­diya gesina la Rom. ");
INSERT INTO mfh_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Sləray aŋatà kà tekula la Pol, (Mataf gày lukut) adzà à ahəŋ la mtəga aŋatà, ŋgaha taɗa­hàhà sləray la slaka gà. ");
INSERT INTO mfh_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kəla vuɗ maduw ləv, Pol abayàhà vok gay la azla Yahu­diya la gày madəv kuɗa la aku, kà atà tadiŋal gəl à vok, baməraka azla Gərək bay. ");
INSERT INTO mfh_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ama mok uwana azla Silas atà la Timo­tawus tasà à waŋ la Make­du­niya kà, Pol aɗahà sləray anik aya aw, say azàŋ kà gay Zəzagəla la mapàhla à azla Yahu­diya, kà Yesu kà masla uwana Zəzagəla afàl dzakwa à gəl. ");
INSERT INTO mfh_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ama uwana azla Yahu­diya tafà gəl à gay aŋha aw, tatsə̀kal mago­ɗahay à gəl Pol aɗə̀ɗ à atà burburu aŋa gudəŋ aŋatà à gəl, agòɗ à atà: “Baŋa kadà­za­hawla kà, mawi­siga kà adagay kà aŋkul, gay gulo la abà aw. Dagay lagonay lagwa gəgola vok gulo à slaka azladza uwana azla Yahu­diya aw adagay.” ");
INSERT INTO mfh_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kiya uwaga adà aŋha la abatà, ahàd à mtəga aŋa dza anik uwana sləm aŋha Titiyus Yustus, uwana ahòy yewdi aŋa Zəzagəla, ŋgaha gày aŋha kà agà la makəla aŋa gày madəv kuɗa. ");
INSERT INTO mfh_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirəspus, məŋga aŋa gày madəv kuɗa, adìŋ gəl à Sufəl Yesu à vok la huɗ gày aŋha gesina. Azla Korin­tiya uwana tatsənà gay uwaga, tadìŋal gəl à vok, ŋgaha taɗahà à atà batem. ");
INSERT INTO mfh_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","La vəɗ la abà vərdi anik mase­siŋay ase­sìŋla Pol, Sufəl Zəzagəla agòɗal: “Guba akəs ka aw, dà à huma à gay la mapəh gay gulo, kadza à ahəŋ titi aw! ");
INSERT INTO mfh_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kà uwana gi la ahəŋ la kak. Dza la ahəŋ aslala vok kà makəs ka, kà maɗaha à ka mawi­siga à vok aw, kà uwana azla­uwana tada­gahay azlaa­ŋulo kà, atà ŋuv la gudəŋ uwanay la abà aw.” ");
INSERT INTO mfh_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pol adzà à ahəŋ la Korin­tiya mavay la tenma, ata­pàhla gay Zəzagəla à azladza. ");
INSERT INTO mfh_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Mok uwana Galiyon apàk gumna aŋa kutso Akayya, azla Yahu­diya tahamà gay à vok, takə̀s Pol, tadàlla à huma seriya, ");
INSERT INTO mfh_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Tagòɗ: “Dza uwanay kà apapat azladza kà atà makədeɗ à Zəzagəla anik à ahəŋ, la azla­tetəvi anik anik, uwana aɗəɓ vok la mapəhay gami aw.” ");
INSERT INTO mfh_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol asàl maɓaɗma, à mok uwana Galiyon agòɗ à azla Yahu­diya: “Baŋa dza uwanay akə̀ɗ dza, baŋaw aɗàh mawi­siga anik zla­zla­ɗaga naka gəbasiŋ, gətsəɓ akul sləm. ");
INSERT INTO mfh_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ama tsa kabayaw vok gay kà lakəl aŋa azlagay, lakəl aŋa azla­sləm, ŋgaha lakəl aŋa wakità seriya aŋkul kà, say akul la gəl aŋkul kakədəvaw uwaga ala, gi kà, gəɗàh seriya aŋa tsəhay gà uwaga aw.” ");
INSERT INTO mfh_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ŋgaha akuɗə̀kàh atà la huma seriya. ");
INSERT INTO mfh_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","La abatà gesina aŋatà takàs Sostenus, məŋga aŋa gày madəv kuɗa, tazlàɓ la huma seriya. Ama Galiyon afàl sləm aw. ");
INSERT INTO mfh_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Uwana Pol adadzin à ahəŋ la Korin­tiya aya kà, la lig la ahəŋ, asàk azla­deda à ahəŋ, ahàd à Ken­ke­riya atà la Pərəskila la Akilas. La abatà afə̀ts gəl à ahəŋ kà maslaf vok aŋha uwana aslàf la huma Zəzagəla. La lig la ahəŋ ahàɗ à kəslah iyaw à afik, kà mad à kutso Səriya. ");
INSERT INTO mfh_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Uwana tabəzà Efesus, Pol asakà Akilas à ahəŋ atà la Pərəskila, ŋgaha ahàd à gày madəv kuɗa à agu, kà matsən vok gay la azla Yahu­diya. ");
INSERT INTO mfh_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Atà tanavàl masa­fani la abatà, ama akə̀s aw. ");
INSERT INTO mfh_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Asàk atà à ahəŋ la magoɗ à atà: “Baŋa asa à Zəzagəla kà, gədàwul à waŋ à slaka aŋkul aya”, ŋgaha adà aŋha à Efesus la kəslah iyaw. ");
INSERT INTO mfh_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Mok uwana adabəz à Zəsare kà, ahàd à Uru­sa­lima kà maɗàh ayyi à azlaməna gay Zəzagəla la abatà. La lig la ahəŋ, adà à ahəŋ à Anti­yews. ");
INSERT INTO mfh_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Uwana adadzən à ahəŋ la abatà kà, awùl aŋha aya, aguwà à uda la makoray aŋa Gala­tiya la abà, ŋgaha la Fərizi la madzərəɗàh azlaməna madiŋal gəl à vok ala. ");
INSERT INTO mfh_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","La zamana uwatà kà, zil Yahu­diya anik la ahəŋ, sləm aŋha Apolos tayyà à Ale­kəsan­dəra, abəzà à gudəŋ Efesus. Masla la haŋkəli aŋa maɓaɗma, asə̀l wakità Zəzagəla lela. ");
INSERT INTO mfh_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Asə̀l tetəvi aŋa Sufəl Zəzagəla lela. La maɓaɗma delga apàhla gay aŋa Yesu à azladza la dziriga. Ama batem tsəhay gà aŋa Yuhana la uwana asə̀l pəra. ");
INSERT INTO mfh_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Adzəkà mapàh gay la gày madəv kuɗa la aku la kokuɗa guba. Mok uwana Pərəskila atà la Akilas tatsə̀n mapəhay aŋha, tadàla masla à mtəga aŋatà, tapə̀halla tetəvi aŋa Zəzagəla la dziriga. ");
INSERT INTO mfh_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kiya uwaga Apolos akə̀s tetəvi kà mad à kutso Akayya. Azla­deda məna madiŋal gəl à vok tadzərə̀ɗàŋ ala, tatse­tsèral wakità à ahàl, kà mav à azlaməna madiŋal gəl à vok la kutso uwatà, kà atà makəsay la ahàl səla. Mok uwana adabəz à abatà kà, azlàk azlaməna madiŋal gəl à vok la vok mahamay uwana Zəzagəla avàl. ");
INSERT INTO mfh_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apə̀h à azla Yahu­diya la huma azladza gesina, tsəràh à uwana dza apə̀zl gay maslək aw, apə̀hatàla la wakità Zəzagəla la abà, kà Yesu la uwana dza uwana Zəzagəla afàl dzakwa à gəl, Kristu. ");
INSERT INTO mfh_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Mok uwana Apolos la Korin­tiya, Pol aguwà la gudəŋ la afik, abəzà à Efesus. La abatà la uwana aɓəzà azlaməna madiŋal gəl à vok anik à vok. ");
INSERT INTO mfh_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Anavà atà: “Kaɓəzaw Masasəɗok Zəzagəla, à mok uwana kadì­ŋàwwal gəl à vok ay?” Tawulàlla, tagòɗ: “Tetuwa məda­tsənəŋ tapəhay lakəl aŋa Masasəɗok Zəzagəla aw.” ");
INSERT INTO mfh_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Kiya uwaga Pol anavà atà: “Tsəhay batem ma uwala taɗa­hà­kullàŋ la?” Tawùlalla: “Tsəhay gà aŋa Yuhana”, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pol agòɗ à atà: “Yuhana aɗahà batem à azla­uwana tapàh gay la ləv ala, ŋgaha agòɗàh à azla Isərayel kà, say tadiŋ gəl à dza uwana à vok adànəfal à tsəh à waŋ, uwaga kà Yesu.” ");
INSERT INTO mfh_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Mok uwana tatsə̀n uwaga taɗa­hàtàŋ batem la sləm aŋa Sufəl Yesu. ");
INSERT INTO mfh_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pol aɓə̀k à atà ahàl à gəl, gesina aŋatà taɓə̀zal Masasəɗok Zəzagəla. Tadzəkà maɓaɗma la azlagay məlok gà, ŋgaha tazà sayda uwana taɓə̀zal la slaka Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Gesina aŋatà kà taslay kulo gəl aŋha səla. ");
INSERT INTO mfh_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Təla makər Pol aɗahàŋ kà matapatàla la gày madəv kuɗa aŋa azla Yahu­diya la aku, apàhla azladza kokuɗa guba, kà atà tatsənà vok gay, awàɗ vok à uda kà mapəhatàla gay aŋa makoray Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ama azlaanik aŋatà tadza­dzà­ŋàhà gəl ala, takweskà, tapə̀h mawi­siga lakəl aŋa tetəvi aŋa Sufəl Zəzagəla la huma maham à ahəŋ dza. Kà uwaga à uwana Pol ahə̀l azlaməna madiŋal gəl à vok, tahàd aŋatà. Kəla mavakay atàpla azladza la gày nekol aŋa Tiranus la aku. ");
INSERT INTO mfh_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Anəfà maɗàh uwaga tsəràh à mavay səla, tsəràh à uwana azladza la kutso Asəya, la azla Yahu­diya, ŋgaha la maham à ahəŋ dza anik gesina tatsənà gay aŋa Sufəl Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Zəzagəla aɗahàhà azla­na­dzipo tsəhay anik anik la ahàl aŋa Pol. ");
INSERT INTO mfh_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Azla­lukut uwana tada­bani vok aŋa Pol la azla­nalbət gesina kà tawa­ràhà azlaməna ɗuvats ala gesina. ");
INSERT INTO mfh_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","La kaslà uwatà azla Yahu­diya anik la ahəŋ uwana tau­gu­zàhàh, tawùl à abanay, tawùl à abatày kà makuɗəkàh azla­ma­sasəɗok mawi­siga à azlaməna ɗuvats lakəl ala, tazə̀ɓ kà sləm aŋa Sufəl Yesu kà maku­ɗəkàhla azla­ma­sasəɗok mawi­siga uwaga. Tagòɗàh à azla­ma­sasəɗok uwaga: “Məgòɗ à akul: Sàw à uda la sləm aŋa Yesu uwana Pol apahay!” ");
INSERT INTO mfh_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Uwaga azlabəza aŋa məŋ madza­haga aŋa mav tatak à Zəzagəla, uwana sləm aŋha Seva, taɗahà uwaga atà məɗəf. ");
INSERT INTO mfh_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ama masasəɗok mawi­siga agòɗ à atà: “Gəsəl Yesu, Pol babay gəsəl, ŋgaha ma akul ma, akul azla uwa tak uwa?” ");
INSERT INTO mfh_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Masla zagəla zagəla avàl à atà à adi, aɗuwà à atà gesina. Azlàɓàh à atà à gay, aɗahàh à atà amik à vok, tavàlàh à uda, tahòy aŋatà la godega deyday. ");
INSERT INTO mfh_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Azla Yahu­diya la azla­maham à ahəŋ dza anik anik, uwana tadzà à ahəŋ la Efesus gesina, tatsənà uwaga. Ləv avàl à atà à gay tsəràh à uwana azladza tazàŋ mazləɓay sləm aŋa Sufəl Zəzagəla à gəl kaykay aya. ");
INSERT INTO mfh_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Aŋuvaw la tataka azlaməna madiŋal gəl à vok la abà tasàhà à waŋ, tapàh gay la ləv ala lakəl aŋa uwana tada­ɗahaŋ la huma azladza gesina. ");
INSERT INTO mfh_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Aŋuvaw la tataka aŋa azla­uwana la abà taɗàh məzla, tasàhla wakità aŋatà à waŋ, tadàwal à akàl à tsəh la huma aŋa azladza gesina. Tatùgw sili aŋa wakità gà, uwana kà aɗàh gursu dəbow dzik zlo. ");
INSERT INTO mfh_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kiya uwaga à uwana gay aŋa Sufəl Zəzagəla asləhà gəl à ahəŋ la ndzəɗa la mapəhla ndzəɗa aŋha ala. ");
INSERT INTO mfh_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Mok uwana uwaga adada à lig gesina, Pol akə̀s tetəvi uwana aguwà la Make­du­niya, la Akayya kà masla aŋa mad à Uru­sa­lima. “Baŋa gədabəzay kà, gədàd à gudəŋ Rom babay”, agòɗ. ");
INSERT INTO mfh_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Aslə̀l azlaməna mazlakay aŋha səla à Make­du­niya, Timo­tawus atà la Erastus, ama masla kà adzànì à ahəŋ la Asəya dadàŋ. ");
INSERT INTO mfh_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","La kaslà uwatà kà, gay məŋga atsìzlla ala la Efesus lakəl aŋa tetəvi aŋa Sufəl Zəzagəla. ");
INSERT INTO mfh_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Dza anik la ahəŋ la abatà, sləm aŋha Deme­təriyus, uwana avàtsàh azla­maf­tsa à vok aŋa gày uwana azladza taslə̀kàwàh, uwanay gày aŋa mazlazlay Arəte­məs misga, akə̀s atà à vok la azlaməna sləray aŋha gesina kà madawla. ");
INSERT INTO mfh_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Azàlàh azlaməna sləray aŋha, la azladza uwana sləray aŋatà tekula, ŋgaha agòɗ à atà: “Azla­kona, kasəlaw kà, la sləray gami akəs à anu aw takay, ");
INSERT INTO mfh_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","kanəŋawwaŋ, ŋgaha katsənawwaŋ uwana Pol uwanay aɗehəŋ aw takay? Agoɗ à azladza kà: Azla­ma­zlazlay uwana məɗehəŋ la ahàl kà, azla­zəzagəla delga aw, agoɗ. Ŋgaha azladza takəs gay aŋha kà la abanay la Efesus pəra aw, ama la makoray aŋa Asəya la abà gesina bay. ");
INSERT INTO mfh_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Baŋa kiya uwanay kà, azladza tadàpəh mawi­siga lakəl aŋa sləray gami, ŋgaha tadà­pəsew məŋ gày mazlazlay Arəte­məs ba­məraka Arəteməs bay, kà tadàhoy yewdi aŋha aya aw. Tekeɗik kà, masla la uwana azla Efesus tasləkaway la azladza gudəŋ à vok gesina!” ");
INSERT INTO mfh_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Mok uwana tatsə̀n gay uwaga kà, tapakà ləv kaykay, tadzəkà mawiyay, tagòɗ: “Arəte­məs aŋa azla Efesus kà məŋga, Arəte­məs aŋa Efesus kà məŋga!” ");
INSERT INTO mfh_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Gay uwaga asləhà gəl à gudəŋ à abà gesina, awisà gəl à azladza à vok, takàs azlaməna manəf Pol səla, Gayyus atà la Arəs­tarkus uwana tasà à waŋ la Make­du­niya, tabayà atà, tadàla atà à vada­vaday aŋa marazlay à afik. ");
INSERT INTO mfh_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol bay kà asal aŋa mad à abà, ama azlaməna madiŋal gəl à vok taɗə̀ɗal gay à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Azlamənga aŋa kutso Asəya uwana azla­sla­gama aŋha taslə̀l gay à slaka aŋha, tadə̀val kuɗa kà masla aŋa mad à vada­vaday marazlay à afik aw. ");
INSERT INTO mfh_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","La mok uwaga kà, maham à ahəŋ gesina hohoɗa gəl à vok, kəla uwa­be­yuwi awiyay deyday pəra, kà uwana aŋuvaw la tataka aŋatà la abà, tasə̀l gay uwana ahamà atà gay à vok aw. ");
INSERT INTO mfh_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Zil Yahu­diya anik la ahəŋ la abatà la tataka azladza la abà, sləm aŋha Ale­kəsander, tadàlla à awtày à huma aŋa maham à ahəŋ dza kà uwana azla Yahu­diya tasə̀l masla, kà mapəhla godega aŋa gay uwaga à azladza. ");
INSERT INTO mfh_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ama uwana tasə̀l kà masla babay zil Yahu­diya kà, tazà mawiyay à zagəla la kuda tekula, tasàf la mawiyay la abà azlagay sa səla: “Arəte­məs aŋa azla Efesus kà məŋga, Arəte­məs aŋa azla Efesus kà məŋga!” ");
INSERT INTO mfh_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","“Dzàw à ahəŋ titi!”, məŋ səkəreter aŋa gudəŋ uwaga agòɗ à atà kà kuɗa kuɗa: “Haɗay, akul azla Efesus kà uwa­be­yuwi asəl kà gudəŋ aŋa Efesus kà masla manəŋla məŋ gày aŋa Arteməs, ŋgaha la maftsa vok tsi­ka­slaga aŋha, uwana asà à ahəŋ la zagəla, kəla dza uwala beyli asəl uwaga. ");
INSERT INTO mfh_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Dza la ahəŋ ats gadzewi lakəl aŋha aw. Gay gà la uwaga say kadzaw à ahəŋ titi, ŋgaha kaɗahaw haŋkəli lakəl aŋa uwana kaɗa­hawwaŋ bay. ");
INSERT INTO mfh_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Haɗay, sə̀làw kà, azladza uwana kasàwla atà à abanay kà, tadà à gəl la məŋ gày mazlazlay gami la aku aw, uwala tapə̀h mawi­siga lakəl aŋa mazlazlay gami bay aw. ");
INSERT INTO mfh_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Baŋa gay la Deme­tərius lakəl, la azlaməna sləray aŋha, kà mapuw gudzi à dza à gəl kà, kaslà la ahəŋ à uwana dza ada à seriya la mok uwatà à huma aŋa azlaməŋga, la abatà la uwana tadàvah atà ala. ");
INSERT INTO mfh_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Baŋa akul la azlagay anik aya babay kà, say kadawla à huma à azlaməna sawaray, kà makədəvəŋ ala la abatà. ");
INSERT INTO mfh_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ama kà aŋa uwanay lakana kà, akəs anu vok aw, kà uwana tagoɗ à anu kà, akul la uwana məda­tsizl gay ala, tagoɗ à anu, kà uwana akəs anu vok kà maham gay à vok kiya uwanay aw!” ");
INSERT INTO mfh_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ŋgaha mok uwana adakəɗ gəl à gay uwaga kà: “Dàw aŋkul!”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Mok uwana gay ataslə̀la kà, Pol ahamà gay à azlaməna madiŋal gəl à vok à vok. Adzərə̀ɗàhàla la azlagay, agòɗ à atà: “Gi kà, gəda à Make­du­niya.” ");
INSERT INTO mfh_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Aguwà à uda la kutso uwatà la abà la madzərəɗàh azlaməna madiŋal gəl à vok ala, la mazàh à atà gay Zəzagəla, ŋgaha ahàd à Akayya. ");
INSERT INTO mfh_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Adzà à ahəŋ la abatà təla makər, aɗahà vok à ahəŋ kà mad à Səriya la kəslah iyaw, ama atsənàŋ kà azla Yahu­diya tatsə̀n vok gay kà makəɗay, gay gà la uwaga awùl à Make­du­niya. ");
INSERT INTO mfh_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sopatər, kona aŋa Pirus, zil Bere alakàŋ, ŋgaha bay Arəs­tarkus atà la Se­kundus, uwana azla Te­sa­lo­niki, Gayyus zil Derbe, Tisik atà la Tərofim ŋgaha bay Timo­tawus, uwana atà azla Asəya, tahàd atà nna gesina. ");
INSERT INTO mfh_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Tatsà vok à huma kà anu, tahàd à Tərowas, takudà anu la abatà. ");
INSERT INTO mfh_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Anu la gəl gami məgəɗ à Fili­piya, uwana madəvaday aŋa pain uwana tatak maməsləla la tsəh aw adada à lig kà, la mahənay zlo kà məɓəzà atà à vok la Tərowas la kəslah iyaw. Məɗahà kasukwa tekula la abatà. ");
INSERT INTO mfh_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","La mokokhu gà, vuɗ səɓdu kà, maham gay à vok kà mazuw tatak may tsi­ka­slaga. La abatà Pol apə̀h gay à azladza. Apə̀h gay tsəràh à tataka vəɗ, kà uwana la bebəŋ gà kà, asal mad aŋha. ");
INSERT INTO mfh_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","La gày uwatà la aku lakəl aŋa gày uwatà la afik, məhàm à agu kà, azla­fənəs aŋuvaw dza­dzàhà la ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Bəzi kohana uwana sləm aŋha Antikus adzà madzay la gay fenetər. Pol adà à huma à gay la mapəh gay Zəzagəla tsəràh à uwana Antikus ayì vok, adzehàl. Tsəŋu­rəsl, atə̀ɗ à ahəŋ, dagay la kəl gày mamakər la afik, tazə̀ɓ à afik kà adamətsay. ");
INSERT INTO mfh_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ama Pol asà à ahəŋ, ahùɓal à gəl, akə̀s à vok, agòɗ: “Katawaw aw, mamətsayga aw!” ");
INSERT INTO mfh_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ŋgaha Pol awùl à gày uwatà à afik, azə̀ɓ Pain atsəkàŋ ala, ŋgaha tazùw gesina aŋatà la slaka gà. Apə̀h à atà gay uwaga tsəràh à gay bebəŋ, la lig la ahəŋ adà aŋha. ");
INSERT INTO mfh_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Tadàla bəzi kohana uwaga à mtəga la sifa, taràb məŋga kà uwaga, tadzərə̀ɗàhà ala. ");
INSERT INTO mfh_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Anu kà, mətsà vok à huma, kà Pol aŋa maday à kəslah iyaw à afik uwana adàla anu à Asos. La abatà la uwana mədzùgw mazəɓ Pol à tsəh à kəslah iyaw à afik, kà uwana masla kà anəfà tetəvi à asik. ");
INSERT INTO mfh_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Mok uwana adaɓəz anu vok la Asos kà, məzə̀ɓ à tsəh à kəslah iyaw à afik, məhàd à Mitilen. ");
INSERT INTO mfh_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Mətsìzlla ala la abatà aya, məhàd à huma aŋa Tsiyo. La bebəŋ aŋha aya kà, məbəzà à Samos, ŋgaha la bebəŋ aŋha aya kà maufaɗ kà, məbəzà à Milet. ");
INSERT INTO mfh_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Asà à Pol kà matsəɗ à Efesus lakəl ala, kà uwana asàl matsizl à ahəŋ kà maz kaslà ala la kutso Asəya aw, kà uwana av vok kà mabəz à Uru­sa­lima gurayŋa madəvaday Pen­ta­kosta, aɗàh vok kəla. ");
INSERT INTO mfh_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mok uwana Pol adabəz à Milet kà, aslə̀l gay à slaka azla­ma­siga aŋa maham à ahəŋ məna gay Zəzagəla la Efesus: “Sàw à waŋ à abanay!”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Mok uwana tadùw à awtày à slaka aŋha kà: “Kasəlaw kakay à madz à ahəŋ gulo uwana gədzà à ahəŋ la makoray aŋa Asəya la abà”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","“Gəɗahà sləray aŋa Sufəl Zəzagəla la ləv tekula, ŋgaha la iyaw tugwi la adi, la ŋgərpa, la tataka aŋkul la abà kà matsən vok gay la azla Yahu­diya. ");
INSERT INTO mfh_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Sə̀làw babay kà, gəha­ɗà­hà­kulla tatak uwana à vok akəsà akul à vok aw. Gəpə̀h à akul uwaga gesina, ŋgaha gətàpakulla la dazu­waya, ŋgaha baməraka la azlahuɗ gày aŋkul. ");
INSERT INTO mfh_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Gəzàlla azla Yahu­diya ŋgaha la azla­uwana azla Yahu­diya aw kà mapəh gay la ləv ala, kà atà magola vok à slaka Zəzagəla, ŋgaha atà aŋa madiŋ gəl à Sufəl Yesu à vok. ");
INSERT INTO mfh_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ama lagonay kà, gəday à Uru­sa­lima, kà uwana Masasəɗok Zəzagəla afà à gi leri à gəl kà maday, lagwa kà, gəsəl tatak uwana adàbəz à gi la abatà aw. ");
INSERT INTO mfh_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kəla kà, kəla huɗ gudəŋ uwana gəguwà à uda la abà kà, Masasəɗok Zəzagəla agòɗ à gi, kà tadàduw gi à daŋay, gədàsa ŋgərpa. ");
INSERT INTO mfh_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ama kà gi kà gədàmətsay, gədàdza à ahəŋ la sifa kà, bà tatak tekula, baŋa gədàkəɗ gəl à madahay gulo, la sləray uwana Sufəl Zəzagəla afà à gi à gəl kà diga, uwaga kà mapəhla ala gay marabəŋ lakəl aŋa vok mahamay aŋa Zəzagəla.” ");
INSERT INTO mfh_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Gəu­gu­zàhàh la tataka aŋkul la abà gesina, gəzà gay aŋa makoray Zəzagəla. Lagwa kà, gəsəl kà kadànəŋaw gi aya aw. ");
INSERT INTO mfh_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kà uwaga à uwana gəpəh à akul la paraka lakana: Baŋa tekula aŋkul azalla kà: Gay gulo aw. ");
INSERT INTO mfh_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kà uwana gəzàla masal aŋa Zəzagəla gesina, gəha­ɗà­hà­kulla tatak à vok aw. ");
INSERT INTO mfh_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Nə̀ŋàwla gəl aŋkul, nə̀ŋàwla maham à ahəŋ məna gay Zəzagəla, uwana Zəzagəla asùkw atà la mamətsay aŋa Kona aŋha. ");
INSERT INTO mfh_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Kà uwana baŋa gədàda aŋulo kà, azladza tadà­sahah à waŋ bokuba azlakəda fəta à tataka aŋkul à abà, tadàsaka azla­tuwaŋ aw. ");
INSERT INTO mfh_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Baməraka la tataka aŋkul la abà bay kà, tadà­pahla vok ala kà maɗàh fida kà azlaməna madiŋal gəl à vok aŋa manəf atà bay. ");
INSERT INTO mfh_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kiya uwaga kà, nə̀ŋàwla gəl aŋkul, awulla à akul à gəl gədapaha à akul mavay makər, mavakay la mahanay gesina, la iyaw tugwi la adi.” ");
INSERT INTO mfh_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Lagonay kà, gədàɓək akul à ahàl aŋa Zəzagəla, ŋgaha à ahàl aŋa vok mahamay aŋha. Aslala vok kà aŋa mazigəŋ akul, aslala vok kà aŋa mapis à akul gay à vok la ləmana uwana aɗa­hà­kulàŋ gesina. ");
INSERT INTO mfh_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Gənavà sili la lukut la slaka dza aw. ");
INSERT INTO mfh_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Akul la gəl aŋkul babay kà kasəlaw, kà gəɗa­hàhà sləray la ahàl gulo, kà gi aŋa maɗàhla tatak uwana gənə̀­kuɗa aŋha la azladza uwana anina. ");
INSERT INTO mfh_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","La azla­tatak gesina la abà, gəpə̀hakulla kà say kazlakaw azlaməna kuɗa la tsəhay sləray uwanay gesina. Tawulla anu gəl babay à gay aŋa Sufəl Yesu uwana agòɗ la gəl aŋha: ˈMa­rabay agay la dza uwana avày, marabay uwanay aɗuwa marabay aŋa dza uwana akəsay pəraˈ, Yesu agoɗ.” ");
INSERT INTO mfh_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Mok uwana Pol adadəv gay aŋha à gay kà, akə̀ɗ à ahəŋ, adə̀v kuɗa atà nna la slaka gà gesina. ");
INSERT INTO mfh_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Gesina aŋatà tatàw, la makas masla à vok ŋgaha: “Hàd, zla!”, tagòɗal la maɓak ahàl à kuɗa. ");
INSERT INTO mfh_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Tapakàh ləv məŋga, kà uwana ‘Kadànəŋaw gi aya aw’, agòɗ à atà. Ŋgaha talakàŋ à kəslah. ");
INSERT INTO mfh_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","La abatà ‘Maday’, məgòɗ à atà, məhàd la kəslah iyaw à afik, məbə̀z à Kos. La bebəŋ gà, məbə̀z à Rodəs. Dagay la abatà məhàd à Patara. ");
INSERT INTO mfh_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","La abatà la uwana məɓəzà à kəslah iyaw, kà mad à Fe­nesəya. Mədà à afik, məhàd, ");
INSERT INTO mfh_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Katskats mənəŋà gudəŋ Sipəre, uwana la tataka dərəv la abà, məfàl à ahàl gudzay, kà mad à Səriya. Məsà à vəɗah la Tir kà matsək kazlaŋa aŋa kəslah iyaw à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Məɓə̀z azlaməna madiŋal gəl à vok la abatà, ŋgaha mədzà à ahəŋ kasukwa tekula anina. Masasəɗok Zəzagəla apə̀hatàla tatak uwana adàɓəz Pol, kiya uwaga kà: ‘Kadà à Uru­sa­lima aw’, tagòɗal. ");
INSERT INTO mfh_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ama uwana kasukwa uwatà adada à lig kà, mətsìzlla ala, məhàd la azlamis aŋatà la azlabəza aŋatà gesina, talakà anu à uda la huɗ gudəŋ la abà. Məkədèɗàh à ahəŋ la gay dərəv məŋga, madəv kuɗa. ");
INSERT INTO mfh_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Mok uwana: ‘Mədzà à ahəŋ wurwur’, mədagoɗ à vok kà, məhàd à kəslah iyaw à afik, atà babay tawùl à mtəga aŋatà. ");
INSERT INTO mfh_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kiya uwaga mədəvà mau­gu­zahay gami à gay la iyaw lakəl la mad à Tir, tsəràh à Poto­le­mawus. La abatà babay, azla­deda takə̀s anu, məvakà à abatà à slaka aŋatà. ");
INSERT INTO mfh_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","La bebəŋ gà məhə̀l vok, məhàd à Zəsare. La abatà məhàd à mtəga aŋa Filip masla mapəh gay Zəzagəla, məhə̀n à mtəga aŋha. Masla kà tekula la tataka azladza məɗəf uwana la abà, tatsa­tsà­mànì atà la Uru­sa­lima. ");
INSERT INTO mfh_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Azladəgam aŋha la ahəŋ, uwana tadàh à zil dadàŋ aw, tapàhàh gay uwana Zəzagəla apəh à atà à ahàl kà mapàh à azladza. ");
INSERT INTO mfh_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Uwana mədahəni à abatà kà, masla mapəhal gay à ahàl aŋa Zəzagəla kà mapàh à azladza, uwana sləm aŋha Agabus, asà à waŋ la Yahu­diya. ");
INSERT INTO mfh_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Asà à waŋ à slaka gami, azə̀ɓ para­para aŋa Pol, awàɗla asik à ahəŋ la azlaahàl aŋha, agòɗ: “Aganay uwana Masasəɗok Zəzagəla agòɗ: ‘Azla Yahu­diya la Uru­sa­lima tadàwaɗ dza aŋa para­para uwanay kiya uwanay, tadàfa masla à ahàl aŋa azladza uwana azla Yahu­diya aw.’ ” ");
INSERT INTO mfh_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Mok uwana məda­tsən gay uwaga, anu la azladza uwana la Zəsare kà: “Kamkam, kahad à Uru­sa­lima aw!”, məgòɗ à Pol. ");
INSERT INTO mfh_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ama awùlla à uda: “Kà mana katawaw ma? Asa à akul kà mav à gi guba takay? Ama gi kà, gədàvà vok gulo kà mawaɗ gi la Uru­sa­lima pəra aw, ama kà mamətsay kà Sufəl Yesu Kristu bay.” ");
INSERT INTO mfh_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Uwana məslàla vok kà maɗəɗal gay à ahəŋ aw kà, mədzà à ahəŋ titi: “Bokuba uwana asa à Zəzagəla pəra zlà”, məgòɗal. ");
INSERT INTO mfh_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Uwana mədadza à ahəŋ la abatà kà, məɗahà vok kà mad à Uru­sa­lima. ");
INSERT INTO mfh_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Azlaməna madiŋal gəl à vok anik la Zəsare talakà anu. Tadàla anu à mtəga aŋa Manason, uwana asà à waŋ la Sipəre, masla madiŋal gəl à vok dagay uwarà, kà mahən anu à ahəŋ. ");
INSERT INTO mfh_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Mok uwana mədabəzay à Uru­sa­lima kà, azla­ma­diŋal gəl à vok la abatà, takə̀s anu la ahàl səla. ");
INSERT INTO mfh_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","La bebəŋ gà, məhàd, la azla Pol, à mtəga aŋa Yakuba, à slaka uwana azla­ma­siga aŋa maham à ahəŋ məna gay Zəzagəla gesina tahamàh gay à vok. ");
INSERT INTO mfh_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pol aɗahà à atà ‘Ayyi’, ŋgaha apə̀h à atà sləray, uwana Zəzagəla aɗahà la ahàl aŋha la tataka aŋa azladza uwana azla Yahu­diya aw. ");
INSERT INTO mfh_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Mok uwana tatsə̀n uwaga la slaka aŋha kà, tazlə̀ɓà Zəzagəla, tagòɗ à Pol: “Deda à kanəŋà uwana apakà vok la abanay la slaka azla Yahu­diya tsi. Azla Yahu­diya dəbow dəbew tapakà azla­ma­diŋal gəl à vok. Ama gesina kà tanəfa gay aŋa wakità seriya aya. ");
INSERT INTO mfh_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Tatsənàŋ kà, katàpla azla Yahu­diya uwana tadzà à ahəŋ la tataka aŋa azla tsəhay dza anik la abà, kà atà aŋa magola vok à uda la wakità seriya aŋa Musa la abà, ŋgaha kagòɗ à atà kà, tasàkal makadav azlabəza aŋatà à uda, ŋgaha tasàk à madz à ahəŋ aŋa azla Yahu­diya la tsəh ala babay. ");
INSERT INTO mfh_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Mana məɗehəŋ ma? Kà uwana ndzer tasəlay kà, kadasa à waŋ. ");
INSERT INTO mfh_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Lagwa ɗahà kà uwana məpəhaha à ka: Azladza ufaɗ la ahəŋ la abanay, à uwana asà à atà masəɗ vok. ");
INSERT INTO mfh_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Nəfà atà, ŋgaha kadàsəɗaw vok akul nna, bokuba uwana wakità seriya apəhay, pə̀l sili aŋa mafəts gəl à ahəŋ aŋatà. Baŋa kadàɗah uwaga gesina kà, azladza tadàsəlay kà uwana tapəh à ka à vok, kà fida, ŋgaha atà kà masəlay kà kanəfa mapəhay aŋa Musa lela! ");
INSERT INTO mfh_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ama kà aŋa azla­uwana azla Yahu­diya aw kà, masla tapakà azlaməna madiŋal gəl à vok kà mətsetsèr à atà wakità kà mapəh à atà uwana məkə̀s: Təga kà, məgoɗ à atà kaslawwalla vok mapaɗ sləɓ matulay, sləɓ mazlazlay, mas aŋiz la mapaɗ sləɓ aŋa tatak masew­fla gà, kaɗahaw mabila aw, uwaga gesina kà delga aw, mətsetsèr à atà.” ");
INSERT INTO mfh_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kiya uwaga la bebəŋ gà, Pol ahàd la azladza ufaɗ uwaga, tasə̀ɗ vok, kà magay sətaka, ŋgaha tahàd à məŋ gày Zəzagəla à agu. La abatà agòɗ: ‘Baŋa mahənay məɗəf adaslay kà, madəv sləray aŋa magay sətaka aŋa kəla uwa­be­yuwi aŋatà.’ (Bokuba magoɗay kà sartà aŋa makaɗ tatak kà aŋatà adaslay) ");
INSERT INTO mfh_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Mok uwana mavakay məɗəf uwaga azladə̀v à gay kà, azla Yahu­diya uwana la makoray Asəya tanəŋà Pol la məŋ gày Zəzagəla la aku kà, ŋgaha tavədzàhà maham à ahəŋ dza ala, ŋgaha takə̀s Pol, ");
INSERT INTO mfh_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","la mawiyay: “Azlatsəhay gami Isərayel zlàkàw anu! Aganay dza à uwanay augu­zà­hàhay la slaka gesina, atùgw delga aw à azladza gesina lakəl aŋa azla Isərayel lakəl aŋa wakità seriya aŋa Musa, ŋgaha lakəl aŋa məŋ gày Zəzagəla babay! Bà gotənaŋ babay asə̀lla azla­kirdi à gày Zəzagəla gami à agu, taɗàhla àlàh à slaka tsiɗaŋa gami à vok.” ");
INSERT INTO mfh_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Uwana tapə̀h kiya uwaga kà, kà uwana tanəŋàŋ Tərofim zil Efesus atà la Pol tau­guzàh la huɗ gudəŋ la abà, tadzùgw kà tahàd à məŋ gày Zəzagəla à agu, gəl agoɗ à atà) ");
INSERT INTO mfh_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Gay uwaga atsàn à huɗ gudəŋ à abà gesina, azladza gesina tahamà gay à vok. Takə̀s Pol, tabayàŋ à lag la gày Zəzagəla la aku, ŋgaha tatsàkàh azla­ga­magày à ama gesina. ");
INSERT INTO mfh_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Maham à ahəŋ dza asà à atà makəɗ Pol, ama gay uwaga atsə̀n à məŋga aŋa azla­slodzi aŋa azla Rom, tagòɗal kà azladza Uru­sa­lima gesina gəl adawis à atà à vok. ");
INSERT INTO mfh_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Katskats məŋga aŋa azla­slodzi ahə̀l azla­slodzi la azlaməŋga aŋatà, tahàd à maham à ahəŋ dza à abà la mahoyay. Uwana azladza tanəŋàŋ azla­slodzi tasà à waŋ kà, tasàk à mazlaɓ Pol. ");
INSERT INTO mfh_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kiya uwaga məŋga aŋa azla­slodzi azà vok à slaka Pol, akə̀s: “Wàɗàwwàŋ kà la maza­kazak səla!”, agòɗ. Ŋgaha anavà atà: “Uwanay ma, mana aɗahàŋ ma?”, agòɗ à atà. ");
INSERT INTO mfh_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Azladza la maham à ahəŋ dza la abà tapàh azlagay anik anik dey­dayga. Takàɗla gəl à gay uwaga à vok, ŋgaha asə̀l uwana aɗehəŋ kà gay uwau­waga uwaga aw, ŋgaha agòɗ kà: “Dàwla Pol à mtəga azla­slodzi!”, agòɗ. ");
INSERT INTO mfh_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Mok uwana tabəzà maslək à ahàl gamagày, azla­slodzi tazə̀ɓ mazəɓay kà mav dzèhla aŋa maham à ahəŋ dza, ");
INSERT INTO mfh_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","kà uwana azladza tanəfà la tsəh dukw­dadukw la mawiyay: “Məkə̀ɗ, məkə̀ɗ, məkə̀ɗ!” ");
INSERT INTO mfh_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Mok uwana tazlàdàla Pol à gày aŋa azla­slodzi uwatà à agu kà, Pol agòɗ à məŋga aŋa slodzi: “Gəɓəzal tetəvi kà maɓaɗma ay?” Məŋga aŋa azla­slodzi agòɗ: “Tsa kasəl gay Gərək aw nna? ");
INSERT INTO mfh_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Tsa kak kà zil Misəra, uwana azlə̀l guvəl la azladza la kaslà uwanay adada à lig aw takay, uwana adàla azladza dəbow ufaɗ à kəsaf à abà kà magay azlaməna nabəra aw ay?” ");
INSERT INTO mfh_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pol agòɗ: “Gi zil Yahu­diya, tayyà gi à Tarsus uwana la Səlisəya, gi bəzi huɗ gudəŋ məŋga gà. Kamkam, gəgoɗ à ka, và à gi tetəvi kà gi aŋa maɓaɗma à maham à ahəŋ dza uwanay!” ");
INSERT INTO mfh_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Məŋga aŋa azla­slodzi avàl tetəvi. Kiya uwaga Pol atsìzlla à maslək ahàl gamagày à afik, akokòt à atà ahàl à adi kà madz à ahəŋ titi, uwana tadzà à ahəŋ titi kà, Pol apə̀h à atà gay, la gay Yahu­diya: ");
INSERT INTO mfh_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Azla­deda la azla­baba, lagwa kà, tsə̀ɓàw sləm à gay mazlayla gi gulo uwana gəpəh à akul lagwa!” ");
INSERT INTO mfh_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Mok uwana tatsənàŋ, kà apə̀h à atà kà la gay aŋatà kà, dziriya tadzà à ahəŋ titi ŋgaha Pol agòɗ à atà: ");
INSERT INTO mfh_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Gi zil Yahu­diya, tayyà gi à Tarsus la Səlisəya, ama gəzigə̀n kà la abanay la Uru­sa­lima, ŋgaha bay kà, masla matap­gəla tatak kà, Gama­liyel, masla la uwana apàh­gəla masəl mapəhay aŋa azla­baba gami madzi­dziga. Gəɗahà sləray aŋa Zəzagəla kà məŋga bokuba aŋkul uwanay kaɗa­hàwwàŋ lakana. ");
INSERT INTO mfh_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Kasəlaw kà gətərə̀ɓàhà azlaməna madiŋ gəl à Yesu à vok tsəràh à makaɗ atà. Gəkàsàh azlazil la azlamis, gəwàts atà à daŋay. ");
INSERT INTO mfh_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Kiya uwaga madza­haga aŋa azlaməna mav tatak à Zəzagəla, la azla­ma­siga tanərəz kà delga à uwana gəɗehəŋ, tavà à gi wakità kà azla­deda gami azla Yahu­diya uwana la Damas, gəhàd à abatà kà makas atà, ŋgaha kà madla atà à Uru­sa­lima à huma seriya.” ");
INSERT INTO mfh_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Mok uwana gi la tetəvi la ama, kà mad à Damas, uwana azlàgay tataka afats kà, katskats magol uɗaka məŋga asà à ahəŋ la zagəla, aùɗ la makəla gulo. ");
INSERT INTO mfh_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Gətə̀ɗ à vəɗah, ŋgaha gətsənà maɓaɗma agòɗ à gi: ‘Sawul, Sawul, kà mana katərəɓ gi ma?’ ");
INSERT INTO mfh_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Gənàv: ‘Kak uwa, Sufəl?’ Agòɗ à gi: ‘Gi Yesu, zil Nazaret uwana katərəɓəŋ.’ ");
INSERT INTO mfh_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Azladza uwana la slaka gulo tanəŋà uɗaka, ama tatsənà kuda uwana aɓaɗ­gəmà aw. ");
INSERT INTO mfh_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Kiya uwaga gənàv: ‘Sufəl, mana gəɗehəŋ ma?’ La abatà Sufəl Yesu agòɗ à gi: ‘Sà à afik, hàd à gudəŋ Damas à abà, la abatà la uwana tadàpəhakala tatak gesina uwana asà à Sufəl Zəzagəla kaɗehəŋ.’ ");
INSERT INTO mfh_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Uwana gədapaka guləf kà magol uɗaka uwana aŋəràzl gi à adi, azladza uwana məday anina takə̀s gi à ahàl, ŋgaha tadàla gi à Damas.” ");
INSERT INTO mfh_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Dza anik la ahəŋ la abatà, uwana sləm aŋha Ana­niyas, masla kà asə̀l Zəzagəla, akə̀s wakità seriya gami lela, sləm aŋha la ahəŋ la tataka azla Yahu­diya aŋa Damas la abà. ");
INSERT INTO mfh_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Asà à waŋ à slaka gulo, atsìzl gi gəl, agòɗ à gi: ‘Sawul, deda gulo, nə̀ŋ ala aya à dagay!’ La kaslà uwatà gənə̀ŋ ala, ŋgaha gənəŋà masla. ");
INSERT INTO mfh_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Agòɗ à gi: ‘Zəzagəla aŋa azla­baba madzi­dziga akə̀sànì ka, kà mapəhla mawoyəŋ aŋha ala la kak, kà manəŋ dziriga aŋa Kona aŋha, ŋgaha kak aŋa matsən gay aŋha la dziriga. ");
INSERT INTO mfh_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kà uwana say kagay masla sayda aŋha la huma aŋa azladza gesina lakəl aŋa uwana kanəŋàŋ ŋgaha katsəŋàŋ. ");
INSERT INTO mfh_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Lagonay ma, mana kakuɗay aya ma? Kə̀s batem!’, agòɗ à gi, ‘Kà Zəzagəla aŋa mazlak ka, kà aŋa mapal ka la tsakana aŋak la abà gesina, la mazal sləm aŋha!’.” ");
INSERT INTO mfh_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Gəwùl à waŋ à Uru­sa­lima. La mok uwana gədə̀v kuɗa la məŋ gày Zəzagəla la aku kà, mase­siŋay ase­sìŋla gi. ");
INSERT INTO mfh_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Gətsənà Sufəl Yesu agòɗ à gi: ‘Hadzak gòɗ, sà à uda la gudəŋ uwanay la abà, kà uwana azlaməna gudəŋ uwanay kà tadàkəs gay uwana kadàpəh à atà lakəl gulo aw.’ ");
INSERT INTO mfh_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Gəwulàlla, gəgòɗ: ‘Haɗay, Sufəl, tasəl la paraka kà gəɗàh à azlagày madəv kuɗa à agu, gəkàsàh atà, gəwàtsàh atà à daŋay, ŋgaha gəzlàɓàh azla­uwana tadìŋ gəl à gay aŋak à vok ndzer. ");
INSERT INTO mfh_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ŋgaha aya, mok uwana takə̀s Etiyen, masla sayda aŋak kà, gi bay kà gi la abatà. Gəkə̀s makəɗay, gənə̀ŋla lukut aŋa azlaməna makəɗay.’ ");
INSERT INTO mfh_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Kiya uwaga Sufəl Zəzagəla agòɗ à gi: ‘Hàd, kà uwana gəsləl ka kərkər à slaka azladza uwana azla Yahu­diya aw!’.” ");
INSERT INTO mfh_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Maham à ahəŋ dza atsə̀ɓ sləm à Pol tsəràh à uwana apə̀h gay uwaga, ama la lig la ahəŋ kà tadzəkà mawiyay: “Zàwwàŋ ala à dza uwaga, kə̀ɗàw, azlayla adza à ahəŋ la sifa aw.” ");
INSERT INTO mfh_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Tawiyà la makwahàh lukut la vok ala, la matak kutso à zagəla. ");
INSERT INTO mfh_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Kiya uwaga məŋga aŋa azla­slodzi avà tetəvi kà madla Pol à gày uwatà à agu, kà masla­həŋ ala, ŋgaha kà masla mapəh dziriga lakəl aŋa mana uwana azla Yahu­diya tawiyay mi à məŋga. ");
INSERT INTO mfh_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ama mok uwana tawaɗə̀ŋ kà mazlaɓay kà, Pol agòɗ à məŋga aŋa azla­slodzi uwana la abatà: “Dziri ma, tetəvi la ahəŋ kà mazlaɓ zil Rom kokuɗa matsən seriya aŋha takay?” ");
INSERT INTO mfh_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Mok uwana adatsən uwaga kà, ahàd, apə̀h gay uwaga à məŋga aŋatà suwaŋ: “Kakay kadàgoɗ aŋak ma? Zil uwanay kà zil Rom.” ");
INSERT INTO mfh_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Məŋga aŋa azla­slodzi asà à waŋ à slaka Pol anavàl: “Pə̀h à gi, kak zil Rom ay?” “Iyay”, Pol agòɗal. ");
INSERT INTO mfh_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kiya uwaga məŋga aŋa azla­slodzi agòɗal: “Gi kà, gəpə̀l kà magol tebeləm aŋa sili kà gi aŋa mapak zil Rom.” Pol awulàlla: “Gi kà dagay mayyi gi.” ");
INSERT INTO mfh_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","La lig la ahəŋ azla­uwana asà à atà mazlaɓay, kà masla aŋa mapəh dziriga kà, tawùl aŋatà à lig. Baməraka məŋga aŋa azla­slodzi bay kà, guba akə̀s à uwana ada­tse­nəŋ kà Pol kà zil Rom, à kà uwana awaɗàŋ la kadərtsi. ");
INSERT INTO mfh_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Məŋga aŋa azla­slodzi asàl kà masəlay, kà mana azla Yahu­diya tayàh makəɗ Pol mi. Gay gà la uwaga, la bebəŋ gà kà apə̀zlla Pol ala la kadərtsi la abà. Agòɗ kà azla­ma­dza­haga aŋa azlaməna mav tatak à Zəzagəla la azla­ma­siga gesina tahamà gay à vok, agòɗ. Kiya uwaga asə̀lla Pol à waŋ, à huma aŋatà gesina. ");
INSERT INTO mfh_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol atsə̀k yewdi à azla­ma­siga à gay agòɗ: “Azla­deda, gənəfà gay aŋa Zəzagəla kà kokuɗa mawi­siga dagay uwarà tsəràh à lakana.” ");
INSERT INTO mfh_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Məŋ madza­haga uwana sləm aŋha Ana­niyas avà tetəvi à azladza uwana la makəla aŋa Pol lakəl, kà maɗəɗ à paŋaw à abà. ");
INSERT INTO mfh_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Kiya uwaga Pol agòɗal: “Ndzer, Zəzagəla adàɗəɗ ka, kak zlagam me­ɗe­kuga. Kagòɗ kà: ‘Gəɗàh seriya kà la tetəvi aŋa wakità seriya’, kagòɗ, ‘Tsa tekeɗik kanəfà aw’.” ");
INSERT INTO mfh_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Azla­uwana la makəla aŋa Pol lakəl tagòɗal: “Kagoɗàh à məŋ madza­haga aŋa Zəzagəla ŋuwà?” ");
INSERT INTO mfh_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","“Azla­deda, gəsə̀l kà məŋ madza­haga aŋa mav tatak à Zəzagəla à masla aw. Haɗay kà wakità agòɗ kà, ‘Kapə̀h mawi­siga à məŋga aŋkul à gəl aw’, agòɗ.” ");
INSERT INTO mfh_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Uwana Pol asə̀l kà azla Sadu­kiya uwana: Mawul à uda la mamətsay la ahəŋ aw tagoɗ, la tataka azla Farisəya la abatà kà, apə̀h gay à azladza la kuda zləkkà: “Azla­deda, gi kà, gi zil Farisəya, kona aŋa zil Farisəya, uwana tasə̀lla gi à abanay kà, kà uwana: ‘Mawul à uda la mamətsay la ahəŋ’, gəgòɗ, à uwana tasə̀lla gi à huma seriya.” ");
INSERT INTO mfh_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Uwana adapəh gay uwaga kà, azla Farisəya la azla Sadu­kiya tadzəkà mabay vok gay la tataka aŋatà, ŋgaha maham à ahəŋ atsàk ala. ");
INSERT INTO mfh_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Kà uwana azla Sadu­kiya tagòɗ la paraka kà: ‘Mawul à uda la mamətsay la ahəŋ aw, malika la ahəŋ aw, masasəɗok la ahəŋ babay aw’, tagòɗ. Tekeɗik kà azla Farisəya kà, tadiŋal gəl à uwaga à vok, kà aga la ahəŋ) ");
INSERT INTO mfh_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Uwana mawiyay uwaga ada­zalla vok à gəl kà, azlaanik la tataka azlaməŋga aŋa wakità seriya la abà, uwana la maham à ahəŋ aŋa azla Farisəya la abà tasà à afik, tavədzàhàtàla tagòɗ: “Kiya uwanay kà, məɓəza mawi­siga amiyaka tekula la slaka zil uwanay aw, zlahaw malika, baŋaw masasəɗok apə̀halla ala uwaga la dziriga à məŋga.” ");
INSERT INTO mfh_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Magazlay atsìzlla ala məŋga kaykay tsəràh à uwana guba akə̀s məŋga aŋa azla­slodzi kà maslàh Pol à ahàl aw. Gay gà la uwaga avà tetəvi à azla­slodzi kà mad à tataka maham à ahəŋ dza à abà, kà atà aŋa madla Pol à mtəga aŋatà à agu. ");
INSERT INTO mfh_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kiya uwaga la huɗ aŋa vəɗ uwatà Zəzagəla agòɗ à Pol: “Guba akəs ka aw, kaz sayda gulo la Uru­sa­lima la abanay, ŋgaha bay kà, kaz sayda gulo la Rom aya babay.” ");
INSERT INTO mfh_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","La bebəŋ gà, azla Yahu­diya anik anik tahamà gay à vok, tagòɗ kà: “Məzùw tatak may, məs iyaw aw say baŋa mədakəɗ Pol”, tagòɗ, la mazuw mawaɗay. ");
INSERT INTO mfh_vp