﻿USE sofia;
DROP TABLE IF EXISTS sofia.mey_vpl;
CREATE TABLE mey_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mey_vpl WRITE;
INSERT INTO mey_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","فالبداية خلڮ مولانا العالم. وهاذي هي الطريقة اللي خلڮو بيها: ");
INSERT INTO mey_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","فالبداية كانت لارض ماهي منتظمة ولا فيها شي، وكانت الظلمة امغطية الما، وروح مولانا يحوم فوڮو. ");
INSERT INTO mey_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","وڮال مولانا: يخلڮ النور. واخلڮ النور. ");
INSERT INTO mey_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","وخرص مولانا النور وشاف النور زين. وافصل مولانا النور عن الظلمة. ");
INSERT INTO mey_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","وسما مولانا النور انهار، وسما الظلمة ليل. وعاد ليل وعاد امع الصباح . وكان ذاك هو اليوم لأول. ");
INSERT INTO mey_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","وڮال مولانا: تخلڮ قبة امبين المياه اياك اتڮسم المياه شور قسمين. ");
INSERT INTO mey_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","وخلڮ مولانا قبة وافصل المياه اللي تحت القبة عن المياه اللي فوڮها. واخلڮ هاذا. ");
INSERT INTO mey_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","وسما مولانا القبة السما. وعاد ليل وعاد امع الصباح. وكان ذا اليوم الثاني. ");
INSERT INTO mey_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","وڮال مولانا: يجتمعو المياه اللي تحت السما كاملين فابليدة وحدة اياك تظهر التراب. واخلڮ ذا. ");
INSERT INTO mey_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","وسما مولانا هاذي التراب لارض، وسما بل امنين اجتمعو المياه لبحور. وخرص مولانا وشاف ذاك كامل زين. ");
INSERT INTO mey_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","وڮال مولانا: تعطي لارض النباتات اللي فيهم لبذور، ويخلڮ اصدر رافد الثمار اللي فيهم لبذور بكل أنواعهم اعلى لارض. واخلڮ ذا. ");
INSERT INTO mey_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ووخظت لارض النباتات اللي فيهم لبذور بكل أنواعهم، واعطات املي اصدر رافد اثمار فيهم لبذور من نوعهم. وخرص مولانا وشاف ذا كامل زين. ");
INSERT INTO mey_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","وعاد ليل وعاد امع الصباح. وكان ذا اليوم الثالث. ");
INSERT INTO mey_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","وڮال مولانا: يخلڮو لأنوار فقبة السما اياك يميزو النهار عن اليل ويعودو علامات يحددو لأيام والسنين ولعياد. ");
INSERT INTO mey_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ويخلڮو أنوار فقبة السما اياك يظو اعلى لارض. واخلڮ ذا . ");
INSERT INTO mey_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","وخلڮ مولانا لأنوار لكبار لأثنين : خلڮ النور لأول لكبير اياك يعود فانهار، وخلڮ النور الثاني الصغير اياك يعود فاليل، وخلڮ مولانا النجوم املي. ");
INSERT INTO mey_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ودار مولانا هاذو لأنوار فقبة السما اياك ايظو اعلى لارض، ");
INSERT INTO mey_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","واجعلهم مولانا هوما المسؤولين عن انهار وليل وهوما اللي يميزو النور من الظلمة. وخرص مولانا وشاف ذا كامل زين. ");
INSERT INTO mey_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","وعاد ليل وعاد امع الصباح. وكان ذا اليوم الرابع. ");
INSERT INTO mey_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","وعاڮب ذا ڮال مولانا: تمتلا المياه بياسر من المخلوقات الحيين، واتعود فم اطيور اتطير امبين لارض والسما. ");
INSERT INTO mey_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","وخلڮ مولانا وحوش لبحور لكبار ، وكيف ما خلڮ المخلوقات الحيين كاملين اللي املان منهم الماء، خلڮهم من كل نوع. وخلڮ املي كل اطير بريشاتو من كل نوع. وخرص مولانا هاذا وشافو زين. ");
INSERT INTO mey_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ودار مولانا فيهم البركة وڮال: اثمرو واكثارو ويمتلاو مياه لبحور بالمخلوقات، ويكثارو الطيور اعلى لارض. ");
INSERT INTO mey_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","وعاد ليل وعاد امع الصباح. وكان ذا اليوم الخامس. ");
INSERT INTO mey_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","وڮال مولانا: تعطي لارض مخلوقات حيين من كل نوع : من حيوان يُربّا وزواحف وحيوانات لخلا من كل نوع. واخلڮ ذا. ");
INSERT INTO mey_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","وخلڮ مولانا الحيوانات لخلا من كل نوع، والحيوان اللي يُربّا من كل نوع، وكل حيوان يزحف اعلى التراب من كل نوع. وخرص مولانا وشاف ذا زين. ");
INSERT INTO mey_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","وعاڮب ذاك ڮال مولانا: انخلڮو لإنسان اعلى شي من صيفاتنا، وسلّط مولانا لإنسان اعلى حوت لبحر واطيور السما والحيوان اللي يُربّا وحيوان لخلا اعلى التراب واعلى كل حيوان يزحف اعلى التراب . ");
INSERT INTO mey_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","وخلڮ مولانا لإنسان اعلى شي من صيفاتو، اعلى شي من صيفاتو خلڮهم راجل وامرة. ");
INSERT INTO mey_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ودار مولانا فيهم البركة وڮال: اثمرو واكثارو وعودو ياسرين وسيطرو اعلى لارض، واتسلطو اعلى حوت لبحر واطيور السما وكل شي يتحرك اعلى لارض. ");
INSERT INTO mey_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","وڮال مولانا: اراني اعطيتكم كل اصدر اعلى وجه لارض رافد ابذور. اعطيتكم كل صدراية رافدة لكم ثمار اياك توكلوهم. ");
INSERT INTO mey_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","يغير لحيوانات لارض واطيور السما كاملين وكل الحيوانات الصغيرة اللي تزحف وكل مخلوق فيه روح، اتعود النباتات اطعامها. واخلڮ ذا . ");
INSERT INTO mey_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","وخرص مولانا هاذا وشافو زين حته. وعاد ليل وعاد امع الصباح. وكان ذا اليوم السات. ");
INSERT INTO mey_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","وبهاذي الطريقة اوفاو السماوات ولارض وذا كامل اللي فيهم. ");
INSERT INTO mey_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","وعاڮب يلين اوفا مولانا من شغلتو كامل، استراح فاليوم السابع . ");
INSERT INTO mey_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","وبارك مولانا اليوم السابع وڮال اعلنو مخصصلو، بيهلي اوفا فيه من خلڮ العالم. ");
INSERT INTO mey_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","هاذي هي قصة السماوات ولارض وقت اخلاڮتهم: اليوم اللي خلڮ الله تعالى لارض والسماوات ");
INSERT INTO mey_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ما كانت أي اربيعة خالڮة اعلى لارض، ولا كان املي أي اصدر فات انبت، بيهلي الله تعالى مافات فهاذا الوقت مشّا اسحاب اعلى لارض، ولا كان فات اخلڮ أي آرڮاج يحرث التراب. ");
INSERT INTO mey_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","يغير كان يوخظ من لارض فهاذا الوقت عين من الما تسڮي التراب. ");
INSERT INTO mey_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","وعاڮب ذاك خلڮ الله تعالى الراجل من التراب وانفخ فاخنافرو الحياة وعاد الراجل نفس حية. ");
INSERT INTO mey_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","وعاڮب ذاك اغرس الله تعالى اصدر فابليدة زينة فعدن فالشرق وفم عاد عايش الراجل اللي خلڮ. ");
INSERT INTO mey_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ونبت الله تعالى من لارض كل نوع من الصدر الزين و صالح للوكيل. وكانت فوسط هاذي لبليدة الزينة صدراية تعطي الحياة وصدراية اخرا تعطي معرفة الصالح والطالح. ");
INSERT INTO mey_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","وكان فم نهر يمشي فهاذي لبليدة الزينة اللي فعدن اياك يسڮيها، وكان هاذا النهر يتفرعو منو 4 فروع. ");
INSERT INTO mey_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","اسم لأول هو فيشون وهو اللي يوخظ احذا ارض الحويلة كاملة بل امنين فيه الذهب. ");
INSERT INTO mey_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","والذهب اللي فم من نوعية زينة، وفم املي ازين لبخور واحجار العقيق. ");
INSERT INTO mey_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","واسم الثاني هو جيحون وهو اللي يوخظ احذا ارض كوش كاملة. ");
INSERT INTO mey_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","واسم الثالث هو دجلة ويوخظ شرق أشور. والرابع اسمو الفرات. ");
INSERT INTO mey_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","واڮبظ الله تعالى الراجل ودارو فهاذي لبليدة الزينة اللي فعدن اياك يحرثها ويرعاها. ");
INSERT INTO mey_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ووصا الله تعالى الراجل وڮالّو: اتڮد توكل اللي تبغي من الصدر ذي لبليدة اللي فعدن. ");
INSERT INTO mey_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","يغير ذيك الصدراية اللي تعطي المعرفة امبين الصالح والطالح، لا توكل منها، بيهلي الوقت اللي توكل منها لاهي اتموت . ");
INSERT INTO mey_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","وڮال الله تعالى: ماهو زين يبڮا الراجل وحدو، ولذاك لاهي انخلڮلو مُعِين اياك يشارك حياتو امعاه. ");
INSERT INTO mey_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","وخلڮ الله تعالى من التراب كل حيوان فلحريثة وكل اطيور السما. وعاڮب ذاك جابهم كاملين للراجل اياك يشوف شلاهي يسمّي كل واحد منهم. وكل مرة يسمّي واحد من المخلوقات يعود ذاك اسمو. ");
INSERT INTO mey_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","وسما الراجل الحيوانات كاملين اللي يُربّاو واطيور السما كاملين وحيوانات لخلا كاملين ، يغير ما اجبر امبينهم واحد يعاونو ويشابهلو. ");
INSERT INTO mey_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","و رڮّد الله تعالى الراجل ارڮاد امتين، وفوقت ارڮادو، اڮبظ الله تعالى ظلعة من اظلوعو وغطا بلها بالجل . ");
INSERT INTO mey_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","وعاڮب ذاك خلڮ الله تعالى من الظلعة اللي اڮبظها من الراجل امرة وڮدمهالو. ");
INSERT INTO mey_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","وڮال الراجل: ظرك ، هاذي اعظم من اعظامي ولحمة من لحمي، ولاهي انسميها امرة بيهَلي انڮبظت من امرئ. ");
INSERT INTO mey_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ولذا السبب يخلي الراجل بوه وأمو ويلتصڮ باعيالو، ويعودو عايلة وحدة. ");
INSERT INTO mey_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","وكانو الراجل واعيالو كلهم عريان، يغير ما كانو يستحاو. ");
INSERT INTO mey_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","وكان الحنش هو أمكر حيوانات لخلا اللي خلڮ الله تعالى. وڮال للمرة: حڮحڮ ڮالكم الله تعالى : لا توكلو من أي صدراية فهاذي لبليدة الزينة ؟ ");
INSERT INTO mey_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","وڮالت لمرة للحنش: ابدي انڮدو نوكلو من احدج الصدر كامل اللي فهاذي لبليدة، ");
INSERT INTO mey_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","يغير الصدراية اللي فوسط هاذي لبليدة الزينة، ڮط ڮالنا الله تعالى: لا توكلو منها ولا اتمسوها اياك ما اتموتو. ");
INSERT INTO mey_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","وڮال الحنش للمرة: ابدي مانكم لاهي اتموتو . ");
INSERT INTO mey_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","يغير الله تعالى يعرف اعلنكم الوقت اللي توكلو منها لاهي اتعود عندكم معرفة اجديدة واتعودو كيفت الله تعالى اتميزو امبين الصالح والطالح. ");
INSERT INTO mey_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","وشافت لمرة اعلن الصدراية زينة للوكيل وتجذب شورها العين، ومرغوب فيها بسبب اللي تعطي من الحكمة لحد يوكل منها . وڮبظت من احدجها وكالت. ومن فم اعطات لراجلها اللي كان امعاها وكال هو املي. ");
INSERT INTO mey_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","وانفتحو عينيهم، وفطنو اعلنهم عريانين. وخيطو اورڮ صدراية التين وصنعو لروسهم لباس يغطي عورتهم. ");
INSERT INTO mey_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ومن فم سمعو صوت الله تعالى ماشي فهاذي لبليدة الزينة وقت مشي الريح، واتروقو الراجل واعيالو من الله تعالى امبين اصدر هاذي لبليدة. ");
INSERT INTO mey_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","وعيط الله تعالى للراجل وڮالّو: انتا امنين؟ ");
INSERT INTO mey_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","وڮال الراجل: اسمعت صوتك فهاذي لبليدة ونخلعت بيّلي آنا عريان، واتروقت عنك. ");
INSERT INTO mey_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","وڮالّو الله تعالى: من ڮالّك اعلنك عريان؟ اثرك كلت من الصدراية اللي انهيتك عن توكل منها؟ ");
INSERT INTO mey_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","وڮال الراجل: لمرة اللي امعايَ ، اعطاتني من احدج الصدراية وكلت. ");
INSERT INTO mey_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","وعند ذاك ڮال الله تعالى للمرة: ذا اللي عدلتي شنهو؟ وڮالتلو لمرة: الحنش احتال اعليَّ وكلت من احدج ذيك الصدراية. ");
INSERT INTO mey_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","وڮال الله تعالى للحنش: بيكلي انتا عدلت ذاك، اتعود ملعون أكثر من المخلوقات لخرين كاملين. وكل أيام حياتك لاهي تحبي اعلى كرشك، ولاهي توكل التراب، ");
INSERT INTO mey_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ولاهي اندير عداوة امبينك وامبين لمرة وامبين نسلك ونسلها. لاهي يبعج نسلها راسك وانتا لاهي اتعظو فالعرڮوب. ");
INSERT INTO mey_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","وڮال الله تعالى للمرة: لاهي انكثر اوجاع حملك. وبلألام لاهي تبراي أولادك، ولاهي تخدمي راجلك، ولاهي يسود اعليك. ");
INSERT INTO mey_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","وڮال الله تعالى للراجل: انتا اسمعت اللي اقترحت اعليك اعيالك وكلت من الصدراية اللي انهيتك عن توكل منها. ولذا لاهي نلعن لارض، ولانك لاهي اتعود توكل منها يكون بالكد والتعب كل أيام حياتك. ");
INSERT INTO mey_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ولاهي اتنبتلك الشوك وينيتي، ولاهي توكل من اصدر لحريثة . ");
INSERT INTO mey_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","اتحصل اطعامك باعرڮ جبهتك ، يلين ترجع للتراب اللي اوخلڮت منها. من التراب اوخلڮت وشور التراب لاهي ترجع. ");
INSERT INTO mey_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","وسما آدم اعيالو حواء بيهَلي لاهي اتعود أم البشر كاملين. ");
INSERT INTO mey_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","واصنع الله تعالى لباس من جل حيوان لآدم واعيالو، ولبسولهم. ");
INSERT INTO mey_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","وڮال الله تعالى: اراعيه عاد لإنسان كيف واحد منا فالتمييز امبين الصالح والطالح، وظرك عاد يڮد يمد ايدو ويڮبظ من احدج صدراية الحياة ويوكل منها ويعيش إلى الأبد. ");
INSERT INTO mey_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","وصاعو الله تعالى من لبليدة الزينة اللي فعدن اياك يحرث التراب اللي اوخلڮ منها. ");
INSERT INTO mey_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","وعاڮب يلين صاع لإنسان، دار مولانا فجيهة شرق عدن نوع من الملايكة اسمهم الكروبيم اللي كانو رافدين سيف من نار يزڮنن اياك يحرس اطريڮ اللي واعدة صدراية الحياة. ");
INSERT INTO mey_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","وعاشر آدم اعيالو حواء وحملت منو وخلاتلو اطفيل اسمو قابيل وڮالت: ارزقني الله تعالى باطفيل. ");
INSERT INTO mey_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","وعاڮب ذاك خلات خوه هابيل. وكان هابيل راعي لغنم، وقابيل كان مزارع . ");
INSERT INTO mey_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","و عاڮب فترة ڮدم قابيل لله تعالى قربان من خيرات لارض. ");
INSERT INTO mey_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","وهابيل ڮدم اشبه اللي عندو من اكبر لغنم واسمنها. واڮبل الله تعالى قربان هابيل، ");
INSERT INTO mey_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","يغير قربان قابيل ما ڮبلو. وانفڮع قابيل حته، و عاد وجهو امعبس. ");
INSERT INTO mey_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","وڮال الله تعالى لقابيل، اعلاش تنفڮع؟ اعلاش يعبس وجهك؟ ");
INSERT INTO mey_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","يلين اتعدل شي صالح نڮبلو، وإلين اتعدل شي ما هو صالح لاهي يعود ذنبك اڮريب من بابك ويدور يتحكم فيك، ولا تخليه يتحكم فيك. ");
INSERT INTO mey_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","وڮال قابيل لخوه هابيل: وهاي جاي نمشو شور الخلوات. وفالوقت اللي كانو فيه هوما لأثنين فالخلوات، اهجم قابيل اعلى خوه هابيل وكتلو. ");
INSERT INTO mey_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","وڮال الله تعالى لقابيل: امنين خوك هابيل؟ وڮالّو قابيل: ما نعرف. آنا اثري حارس لخويَ؟ ");
INSERT INTO mey_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","وڮال الله تعالى: شنهو اللي عدلت؟ دم خوك يزوڮيلي من التراب. ");
INSERT INTO mey_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","من ظرك لارض لعنتك وفتحت فمها لدم خوك اللي اكتلتو بايدك. ");
INSERT INTO mey_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","يلين تحرث التراب ماهي لاهي تعطيك شي. وانتا لاهي اتعود واقد بلا مسكن. ");
INSERT INTO mey_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","وڮال قابيل لله تعالى: عقابي امتن من انڮد نتحملو. ");
INSERT INTO mey_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","انتا اليوم صعتني من لارض اياك نختفي من حضرتك وانعود ابلا مسكن فالدنيا، وأي آرڮاج يجبرني يكتلني. ");
INSERT INTO mey_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","وڮالّو الله تعالى: ابدي، اللي يكتلك لاهي انعاقبو باسبع مرات عقابك. ودار الله تعالى علامة اعلى قابيل اياك ما يكتلو حد يجبرو. ");
INSERT INTO mey_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","وامشا قابيل عن محضر الله تعالى واسكن فارض نود اللي شرق عدن. ");
INSERT INTO mey_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","وعاشر قابيل اعيالو وحملت وخلاتلو اطفيل اسمو حنوك. وكان قابيل وقتها يبني مدينة، وسماها حنوك اعلى اسم ولو. ");
INSERT INTO mey_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","وحنوك اجبر إشيرو اسمو عيراد، وعيراد اجبر محويل، ومحويل اجبر متوشيل ومتوشيل اجبر لامك. ");
INSERT INTO mey_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","واتعرس لامك امع مرتين: وحدة منهم اسمها عادة ولخرا اسمها صلّة. ");
INSERT INTO mey_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","وخلات عادة يابال وهو أول آرڮاج اسكن فلخيام واسرح لغنم. ");
INSERT INTO mey_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","واسم خوه يوبال وهو أول آرڮاج اخبط التيدينيت والنيفارة . ");
INSERT INTO mey_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","وصلّة خلات توبال قابيل وهو أول آرڮاج اصنع آلات من النحاس ولحديد، واختو اسمها نعمة. ");
INSERT INTO mey_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","وڮال لامك لاعلياتو عادة وصلّة: يا عادة وصلّة اسمعو اكلامي يا اعليات لامك، عدلو اللي انڮولكم: آنا اكتلت راجل اجرحني وشاب اخبطني. ");
INSERT INTO mey_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","وبالتالي يلين يعود يخلص لقابيل 7 مرات لاهي يعود يخلص للامك 77 مرة. ");
INSERT INTO mey_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","وعاشر آدم حواء مرة اخرا وخلاتلو اطفيل وسماتو شيث وڮالت: ارزقني مولانا باطفيل اوخر بل هابيل اللي كتلو قابيل. ");
INSERT INTO mey_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","واجبر شيث اطفيل وسماه أنوش. وفذاك الوقت ابداو الناس يعبدو الله تعالى. ");
INSERT INTO mey_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","هاذا سجل مواليد آدم: اليوم اللي خلڮ مولانا فيه لإنسان، خلڮو اعلى شي من صيفاتو. ");
INSERT INTO mey_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","وخلڮهم راجل وامرة وباركهم وسماهم لإنسان. ");
INSERT INTO mey_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","وإلين عاد عند النبي آدم 130 سنة، اجبر ول يشابهلو اعلى صيفاتو وسماه شيث. ");
INSERT INTO mey_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","وعاش آدم بعد اخلاڮة شيث 800 سنة، واجبر فيها أولاد اخرين وامنات. ");
INSERT INTO mey_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","وكان آدم عندو 930 يلين اتوفا . ");
INSERT INTO mey_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","وإلين عاد عند شيث 105 سنوات اجبر أنوش. ");
INSERT INTO mey_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","وعاش شيث بعد ذاك 807 سنوات، واجبر فيها أولاد اخرين وامنات. ");
INSERT INTO mey_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","وكان عند شيث 912 سنة وقت وفاتو . ");
INSERT INTO mey_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","وإلين عاد عند أنوش 90 سنة اجبر قينان. ");
INSERT INTO mey_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","وعاش أنوش عاڮب ذاك 815 سنة، واجبر فيها أولاد اخرين وامنات. ");
INSERT INTO mey_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","وكان عند أنوش 905 سنوات وقت وفاتو . ");
INSERT INTO mey_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","وإلين عاد عند قينان 70 سنة اجبر مهللئيل. ");
INSERT INTO mey_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","وعاش قينان بعد ذاك 840 سنة، واجبر فيها أولاد اخرين وامنات. ");
INSERT INTO mey_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","وكان عند قينان 910 سنوات وقت موتو. ");
INSERT INTO mey_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","وإلين عاد عند مهللئيل 65 سنة اجبر يارد. ");
INSERT INTO mey_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","وعاش مهللئيل عاڮب ذاك 830 سنة، واجبر فيها أولاد اخرين وامنات. ");
INSERT INTO mey_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","و كان عند مهللئيل 895 سنة وقت وفاتو . ");
INSERT INTO mey_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","وإلين عاد عند يارد 162 سنة اجبر النبي إدريس. ");
INSERT INTO mey_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","وعاش يارد عاڮب ذاك 800 سنة، واجبر فيها أولاد اخرين وامنات. ");
INSERT INTO mey_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","وكان عند يارد 962 سنة وقت وفاتو . ");
INSERT INTO mey_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","وإلين عاد عند النبي إدريس 65 سنة اجبر متوشالح. ");
INSERT INTO mey_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","وعاش النبي إدريس عاڮب ذاك 300 سنة. كان متقي فيها مولانا، واجبر فيها أولاد وامنات. ");
INSERT INTO mey_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","وكان عند النبي إدريس فهاذا الوقت 365 سنة. ");
INSERT INTO mey_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","وكان النبي إدريس متقي فيها مولانا. وعاڮب ذاك اختفا النبي إدريس بيهلي رفعو مولانا شورو. ");
INSERT INTO mey_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","وإلين عاد عند متوشالح 187 سنة اجبر لامك. ");
INSERT INTO mey_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","وعاش متوشالح عاڮب ذاك 782 سنة، واجبر فيها أولاد اخرين وامنات. ");
INSERT INTO mey_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","وكان عند متوشالح 969 سنة وقت موتو. ");
INSERT INTO mey_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","وإلين عاد عند لامك 182 سنة اجبر اطفيل، ");
INSERT INTO mey_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","وسماه نوح وڮال: هاذا الول يخفف عنّا تعبنا والمشقات اللي انعانوها فلارض اللي العنها الله تعالى. ");
INSERT INTO mey_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","وعاش لامك بعد اخلاڮة نوح 595 سنة، واجبر فيها أولاد اخرين وامنات. ");
INSERT INTO mey_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","وكان عند لامك 777 سنة وقت وفاتو . ");
INSERT INTO mey_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","وإلين عاد عند نوح 500 سنة، اجبر سام وحام ويافث. ");
INSERT INTO mey_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","وإلين ابداو البشر يكثارو فلارض وخلڮولهم امنات، ");
INSERT INTO mey_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","شافو الملايكة اعلن امنات البشر ازوينات وڮبظوهم واتعرسو امعاهم كيف ما ابغاو. ");
INSERT INTO mey_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","وڮال الله تعالى: روحي ما يبڮا فلإنسان الزمن كامل بيهلي هو إنسان فاني ومن ظرك ماهو لاهي يعيش أكثر من 120 سنة. ");
INSERT INTO mey_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ومن ذاك الوقت عاد فلارض لجبابرة بيهلي الملايكة اتعرسو امع امنات البشر وجبرو منهم أولاد. وكانو أولادهم هوما لجبابرة اللي معروفين بالحرب من ذاك الزمن. ");
INSERT INTO mey_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","وعاڮب ذاك شاف الله تعالى اعلن شر لإنسان انزاد حته فلارض، واعلن رغبات لإنسان وافكار ڮلبو كاملين دائما ماهم امسڮمين. ");
INSERT INTO mey_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","واتكدر الله تعالى حته فڮلبو اعلنو خلڮ لإنسان فلارض. ");
INSERT INTO mey_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","وڮال الله تعالى: لاهي انفرق البشر اللي خلڮتهم من اعلى لارض، الناس امع الحيوان والمخلوقات اللي يزحفو اعلى اكروشتهم والطيور السما بيّلي اتندمت اعلني خلڮتهم. ");
INSERT INTO mey_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","يغير النبي نوح ارضا اعليه الله تعالى. ");
INSERT INTO mey_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","وهاذي هي قصة النبي نوح: هو كان آرڮاج صالح ومتقي مولانا من امبين أهل جيلو، ويعدل كل شي طلبو منو مولانا. ");
INSERT INTO mey_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","واجبر اثلت أولاد هوما سام وحام ويافث. ");
INSERT INTO mey_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","عادت لارض فاسدة عند مولانا وعاد فيها الظلم وشر لإنسان. ");
INSERT INTO mey_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","وإلين شاف مولانا هاذا الفساد اللي خسر حياة كل البشر، ");
INSERT INTO mey_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ڮال مولانا للنبي نوح: جات نهاية هاذا الزمن، ولاهي انفرق البشر كاملين من الوجود بيهلي بسببهم امتلات لارض من الظلم. لاهي انبيدهم وانبيد لارض امعاهم. ");
INSERT INTO mey_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","وعدل لراصك سفينة من لعمد لمتان، وابني فيها ابيوت وادهنها بالطين من الڮدام ومن النڮر اياك الما ما يدخل فيها. ");
INSERT INTO mey_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","وتبينها بهاذي الطريقة: طول السفينة يعود 150 ميتر، وعرظها يعود 25 ميتر، وطولها اعلى الفوڮ يعود 15 ميتر. ");
INSERT INTO mey_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","واتعدل فيها مغطاية يعود امبينها امع السفينة 50 سانتيمتر، واتعدل فيها باب، واتعدل فيها ثلاثة طوابق، التحتاني والوسطاني والفوڮاني. ");
INSERT INTO mey_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","بيّلي راعيني لاهي انمشّي طوفان اعلى لارض اياك انفرق كل مخلوق حي تحت السما. وكل شي اعلى لارض لاهي يهلك. ");
INSERT INTO mey_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","يغير لاهي انعدل عهدي امعاك وتدخل السفينة انتا وأولادك واعيالك واعليات أولادك امعاك. ");
INSERT INTO mey_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","وتڮبظ امعاك فالسفينة 2 من كل مخلوق اذكر ونيثي اياك يسلكو امعاك: ");
INSERT INTO mey_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","أثنين من كل نوع من الطيور ومن كل نوع من الحيوانات ومن كل نوع الحيوانات اللي يزحفو اعلى اكروشتهم اياك يحياو. ");
INSERT INTO mey_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","واڮبظ امعاك كل شي ينتكل واتخزنو اياك يعودلهم ويعودلك الطعام. ");
INSERT INTO mey_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","وعدل النبي نوح كل شي اطلب مولانا منو. ");
INSERT INTO mey_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ومن فم ڮال الله تعالى للنبي نوح: ادخل فالسفينة انتا وكل أسرتك، بيَّلي اجبرتك وحدك صالح فهاذا الجيل. ");
INSERT INTO mey_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","واڮبظ امعاك من كل نوع من الحيوانات لحلال اسبع اذكور واسبع ناثي، والحيوانات اللي ماهم احلال تڮبظ من كل نوع أثنين من الذكور وأثنين من الناثي. ");
INSERT INTO mey_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","واملي تڮبظ من كل نوع من الطيور اسبع اذكور واسبع ناثي اياك يبڮا جنسهم اعلى لارض. ");
INSERT INTO mey_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","بيَّلي عاڮب اسبعة أيام لاهي انمشّي اسحاب اعلى لارض، ولاهي اتم ماشة مدة 40 يوم فليل وانهار، اياك انفرق كل مخلوق حي ڮط خلڮتو من اعلى لارض. ");
INSERT INTO mey_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","وعدل النبي نوح كل شي اطلب منو الله تعالى. ");
INSERT INTO mey_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","وكان النبي نوح فهاذا الوقت عندو 600 سنة وقت امجي طوفان اعلى لارض. ");
INSERT INTO mey_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","وادخل النبي نوح فالسفينة هو وأولادو واعيالو واعليات أولادو اياك يسلكو من ما الطوفان. ");
INSERT INTO mey_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ودخلو املي الحيوانات لحلال والحيوانات اللي ماهم احلال والطيور والحيوانات اللي يزحفو اعلى اكروشتهم. ");
INSERT INTO mey_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","وجاو للنبي نوح ودخلو فالسفينة اعلى شكل أزواج اذكر ونيثي كيف ما اطلب مولانا من النبي نوح. ");
INSERT INTO mey_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","وعاڮب اسبعة أيام جا الطوفان اعلى لارض. ");
INSERT INTO mey_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","فسنة 600 من حياة نوح فالشهر الثاني فاليوم 17 من الشهر، انفجرت المياه اللي كانت عميقة فالتراب وانفتحو ابواب السما. ");
INSERT INTO mey_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ونزلت اسحاب اعلى لارض فليل وانهار مدة 40 يوم. ");
INSERT INTO mey_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","وفذاك اليوم نفسو ادخل النبي نوح فالسفينة هو وأولادو، سام وحام ويافث واعيال نوح واعليات أولادو الثلاثة. ");
INSERT INTO mey_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","وكان امعاهم من كل نوع من حيوانات لخلا والحيوانات اللي يُربّاو والحيوانات اللي يزحفو اعلى اكروشتهم والطيور. ");
INSERT INTO mey_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","من كل المخلوقات الحيين جاو للنبي نوح ودخلو فالسفينة اعلى شكل أزواج ");
INSERT INTO mey_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","اذكر ونيثي من كل مخلوق كيف ما اطلب مولانا من النبي نوح. وعاڮب ذاك اڮفل الله تعالى باب السفينة. ");
INSERT INTO mey_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","وواصل الطوفان مشيه اعلى لارض مدة 40 يوم، ورڮب ما الطوفان السفينة فوڮ لارض. ");
INSERT INTO mey_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","وكانت المياه الياسرة اتواصل مشيها اعلى لارض والسفينة ماشة فوڮ الما. ");
INSERT INTO mey_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","وانزادت المياه حته يلين غطات لكدا لكبار كاملين اللي تحت السما. ");
INSERT INTO mey_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","وواصلت المياه مشيها يلين الحڮ طولها اعلى الفوڮ اسبع امتار فوڮ لكدا لكبار. ");
INSERT INTO mey_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","وماتو كل المخلوقات الحيين اللي كانو موجودين اعلى لارض من الطيور وحيوانات لخلا والحيوانات اللي يُربّاو والزواحف والبشر. ");
INSERT INTO mey_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ومات كل مخلوق حي يتنفس اعلى لارض. ");
INSERT INTO mey_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","وفرق مولانا من اعلى سطح لارض كل مخلوق اسوا من البشر والحيوانات والزواحف واطيور السما، كاملين فرقو من لارض ولا ابڮا ماهو نوح واللي امعاه فالسفينة. ");
INSERT INTO mey_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","وابڮات المياه موجودة اعلى لارض مدة 150 يوم. ");
INSERT INTO mey_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ولا انسا مولانا النبي نوح وكل حيوانات لخلا والحيوانات اللي يُربّاو اللي امعاه فالسفينة، ومشّا الريح اعلى لارض وبدات لارض اتمص الما. ");
INSERT INTO mey_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","وكانت عين الما لكبيرة اللي عميقة فالتراب انڮفلت وابواب السما انڮفلو، ووڮفت اسحاب الجاية من السما. ");
INSERT INTO mey_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","واتراجعت المياه عن لارض اشوي اشوي. وعاڮب 150 يوم، ");
INSERT INTO mey_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","فاليوم 17 من الشهر السابع، وڮفت السفينة اعلى اكدا أراراط. ");
INSERT INTO mey_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","وظلت المياه تنتڮص يلين الشهر العاشر. وفاليوم لأول من الشهر العاشر ظهرو روس لكدا. ");
INSERT INTO mey_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","وعاڮب 40 يوم افتح النبي نوح الكوة اللي عدل فالسفينة. ");
INSERT INTO mey_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ومشّا اغراب واتم طاير فوڮ لارض يلين بدات المياه تيبس عن لارض. ");
INSERT INTO mey_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","وعاڮب ذاك مشّا النبي نوح احمامة اياك يشوف إلى عادت المياه يبست عن لارض. ");
INSERT INTO mey_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ولا اجبرت لحمامة ابليدة تنزل فيها بيهلي المياه مزالت امغطية لارض كاملة. ورجعت لحمامة شور النبي نوح فالسفينة. ومد ايدو واحكمها ودخلها شورو فالسفينة. ");
INSERT INTO mey_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","وحانا اسبعة أيام اخرين ومشّا لحمامة من السفينة مرة اخرا. ");
INSERT INTO mey_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ورجعت شورو امع اغروب الشمس رافدة فخشمها ورڮة من صدراية الزيتون اجديدة. وافهم النبي نوح اعلن المياه مصتها لارض. ");
INSERT INTO mey_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","وحانا اسبعة أيام اخرين وبعدين مشّا لحمامة ولا رجعتلو هاذي المرة. ");
INSERT INTO mey_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","وفاليوم لأول من الشهر لأول من سنة 601 من حياة النبي نوح، فهاذا الوقت كانت المياه بدات تيبس عن لارض. وارفع النبي نوح مغطاية السفينة وشاف اعلن لارض تيبس حته. ");
INSERT INTO mey_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","وفاليوم 27 من الشهر الثاني يبست لارض تماما. ");
INSERT INTO mey_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","وكلم مولانا النبي نوح وڮالّو: ");
INSERT INTO mey_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","اوخظ من السفينة انتا واعيالك وأولادك واعليات أولادك. ");
INSERT INTO mey_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ووخظ كل نوع من المخلوقات الحيين اللي امعاك، من الطيور والحيوانات والزواحف اياك يتوالدو فلارض ويكثارو. ");
INSERT INTO mey_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","وخاظ النبي نوح وأولادو واعيالو واعليات أولادو ");
INSERT INTO mey_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","والحيوانات والزواحف والطيور والمخلوقات اللي يتحركو اعلى لارض خاظو كاملين من السفينة بأنواعهم. ");
INSERT INTO mey_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","وابنا النبي نوح مذبح لله تعالى واڮبظ واحد من كل الحيوانات لحلال والطيور لحلال واذبحهم وڮدمهم لله تعالى كيفت قربان محروڮ اعلى المذبح. ");
INSERT INTO mey_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","واڮبلهم الله تعالى وارضا وڮال الله تعالى امبينو امع راصو: ماني لاهي نلعن لارض مرة اخرا بسبب لإنسان امع اعلن ميول ڮلبو شرير من صغرو. ولاني لاهي نكتل كل مخلوق حي مرة اخرا كيف ما عدلت. ");
INSERT INTO mey_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ومادامت لارض موجودة لاهي يعودو فيها مواسم لحريثة والحصاد، البرد والحمان والصيف والشتا والنهار والليل. ولاهي يتم هاذا هو حالها إلى الأبد. ");
INSERT INTO mey_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","وبارك مولانا النبي نوح وأولادو وڮالهم: اثمرو واكثارو واملاو لارض. ");
INSERT INTO mey_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","حيوانات لخلا اللي فلارض واطيور السما والزواحف وحوت لبحر كاملين لاهي يخافو منكم ويرهبوكم، بيهلي مولانا اعطاكم السلطة اعليهم. ");
INSERT INTO mey_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","وكيف ما اعطيتكم الصدر لخظر كيفت اطعام لكم، ظرك عاطيكم الحيوانات. ");
INSERT INTO mey_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","يغير لا توكلو أي لحم مزال الدم فيه بيهلي الدم هوا اللي يمثل الحياة. ");
INSERT INTO mey_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","يغير دمكم انتوما لاهي انعاقب اعليه كل حيوان سفكو، واملي كل إنسان لاهي نكتلو اعلى حياة خوه لإنسان بيهلي هو كيفتو. ");
INSERT INTO mey_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ومن يسفك الدم لإنسان لاهي ينسفك دمو، بيهلي مولانا خلڮ لإنسان اعلى شي من صيفاتو. ");
INSERT INTO mey_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","يغير انتوما اثمرو واكثارو فلارض. ");
INSERT INTO mey_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","وكلم مولانا النبي نوح وامعاه أولادو وڮالّو: ");
INSERT INTO mey_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","آنا ظرك لاهي انعدل عهدي امعاكم وامع نسلكم اللي جاي اوراكم. ");
INSERT INTO mey_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","وامع كل مخلوق حي امعاكم من الطيور والحيوانات اللي يُربّاو وكل حيوانات لخلا، وكل اللي خاظ من السفينة وكل مخلوق حي اعلى لارض. ");
INSERT INTO mey_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","ولاهي انعدل عهدي امعاكم ولا تيت لاهي نسمح باعلن اتفرق مياه الطوفان كل مخلوق حي مرة اخرا، ولا تيت لاهي نسمح باعلن الطوفان يجي ويخسر لارض مرة اخرا. ");
INSERT INTO mey_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","وڮال مولانا: هاذي هي علامة العهد اللي لاهي انعدل بيني وبينكم وكل مخلوق حي امعاكم فكل لاجيال، ");
INSERT INTO mey_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","لاهي اندير خط الندية فالسما ويعود علامة العهد امبيني وامبين لارض. ");
INSERT INTO mey_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","وإلين انمشّي السحاب فوڮ لارض ويظهر خط الندية فالسما، ");
INSERT INTO mey_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","نتذكر العهد اللي امبيني وبينكم وامع كل نوع من مخلوق حي، ولا تتحول المياه شور طوفان يهلك كل مخلوق حي. ");
INSERT INTO mey_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","وإلين يظهر خط الندية فالسما لاهي انشوفو ونتذكر العهد اللي لاهي يدوم إلى الأبد امبيني وامبين المخلوقات الحية كاملين اللي اعلى لارض. ");
INSERT INTO mey_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","وڮال مولانا للنبي نوح: هاذي هي علامة العهد اللي عدلتو امع كل مخلوق حي اعلى لارض. ");
INSERT INTO mey_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","هاذو هوما أولاد نوح اللي خاظو من السفينة: سام وحام ويافث. وحام هو بو كنعان. ");
INSERT INTO mey_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","هوما أولاد النبي نوح الثلاثة ونسلهم هو اللي انتشر فكل جيهات لارض. ");
INSERT INTO mey_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","واشتغل النبي نوح فلحريثة واحرث اصدر العنب اللي يُعدل منو عصير العنب. ");
INSERT INTO mey_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","واشرب من عصير العنب واسكر واتعرا فخيمتو. ");
INSERT INTO mey_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","وشاف حام بو كنعان عورة بوه وامشا وعلم اخوتو. ");
INSERT INTO mey_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","واڮبظو سام ويافث حولي وداروه اعلى اكتافهم ودخلو شور بوهم النبي نوح فالخيمتو، وهوما كانو ماشين اعلى لورا وسترو عورة بوهم. وكانو وجوهتهم صادين اعلى الجيهة لخرا اياك ما يشوفو عورة بوهم. ");
INSERT INTO mey_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","وإلين اوعا النبي نوح من سكرو واعرف اللي عدلّو ولو الصغير، ");
INSERT INTO mey_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ڮال: ملعون كنعان ولاهي يعود أحقر من اعبيد اخوتو. ");
INSERT INTO mey_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","وڮال املي: يا ربي وإلهي بارك سام واجعل كنعان عبد لو. ");
INSERT INTO mey_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ووسع حدود يافث، ويسكن فاخيام سام ويعود كنعان عبد لو. ");
INSERT INTO mey_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","وعاش النبي نوح عاڮب الطوفان 350 سنة. ");
INSERT INTO mey_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","وإلين اتوفا النبي نوح كان عندو 950 سنة. ");
INSERT INTO mey_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","هاذي لاحة سجل أولاد سام وحام ويافث أولاد النبي نوح، اللي خلڮولهم عاڮب الطوفان. ");
INSERT INTO mey_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","أولاد يافث هوما جومر وماجوج وماداي وياوان وتوبال وماشك وتيراس. ");
INSERT INTO mey_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","وأولاد جومر هوما أشكناز وريفاث وتوجرمة. ");
INSERT INTO mey_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","وأولاد ياوان هوما أليشة وترشيش وكتيم ورودانيم. ");
INSERT INTO mey_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ومنهم اتفرعو الناس من قريات اللي اعلى حاشية لبحر اعلى حسب قبايلهم وشعوبهم ولغاتهم. ");
INSERT INTO mey_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","وأولاد حام هوما كوش ومصرايم وفوط وكنعان. ");
INSERT INTO mey_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","وأولاد كوش هوما سبا وحويلة وسبتة ورعمة وسبتكا. وأولاد رعمة هوما شبا وددان. ");
INSERT INTO mey_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","وكوش اجبر ول اسمو نمرود اللي عاد محارب امتين فلارض. ");
INSERT INTO mey_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","وكان صياد مانع بفضل الله تعالى. ولذا السبب يڮول المثل: كيفت نمرود هو صياد امتين بفضل الله تعالى. ");
INSERT INTO mey_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","وتكونت مملكتو فلأول من مدن بابل وأرك وأكد وكلنة فارض شنعار. ");
INSERT INTO mey_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","وعاڮب ذاك هاجر شور أشور وابنا مدن نينوى ورحوبوت عير وكالح ");
INSERT INTO mey_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ورسن اللي هي مدينة اكبيرة امبين نينوى وكالح. ");
INSERT INTO mey_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","ومصرايم اجبر قبايل لود وعنام ولهاب ونفتوح ");
INSERT INTO mey_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","وفتروس وكفتور وكسلوح، ومن كسلوح جاو الفلشطيميين. ");
INSERT INTO mey_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","وكنعان اجبر اطفيل اسمو صيدون وهو بكرو وبعدين اجبر حثا، ");
INSERT INTO mey_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","وكنعان هو املي بو اليبوسيين ولأموريين والجرجاشيين ");
INSERT INTO mey_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","والحويين والعرقيين والسينيين ");
INSERT INTO mey_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ولأرواديين والصماريين والحماثيين. وعاڮب ذاك اتفرعو افخاظ قبايل الكنعانيين. ");
INSERT INTO mey_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","وامتدو حدود كنعان من صيدون يلين غزة واخظين من جرار، واورا ذاك شور لاشع واخظين من سدوم وعمورة وأدمة وصبويم. ");
INSERT INTO mey_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","وهاذو كاملين هوما أولاد حام اعلى حسب قبايلهم ولغاتهم وشعوبهم وبلدانهم. ");
INSERT INTO mey_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","وسام هو خو يافث لكبير وهو املي اجبر أولاد وهو جد أولاد عابر كاملين. ");
INSERT INTO mey_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","أولاد سام هوما عيلام وأشور وأرفكشاد ولود وأرام. ");
INSERT INTO mey_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","وأولاد أرام هوما عوص وحول وجاثر وماش. ");
INSERT INTO mey_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","وأرفكشاد اجبر شالح وشالح اجبر عابر. ");
INSERT INTO mey_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","وعابر اجبر اطفلين لأول منهم اسمو فالق وهو اللي فأيامو انڮسمت لارض. واسم خوه الثاني هو يقطان. ");
INSERT INTO mey_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ويقطان اجبر أولاد هوما ألموداد وشالف وحضرموت ويارح ");
INSERT INTO mey_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","وهدورام وأوزال ودقلة ");
INSERT INTO mey_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","وعوبال وأبيمايل وشبا ");
INSERT INTO mey_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","وأوفير وحويلة ويوباب. وهاذو كاملين هوما أولاد يقطان. ");
INSERT INTO mey_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","وكانو ساكنين فاراضي لكدا اللي فالشرق اللي امبين ميشع وسفار. ");
INSERT INTO mey_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","وهاذو كاملين هوما أولاد سام حسب قبايلهم ولغاتهم وبلدانهم وشعوبهم. ");
INSERT INTO mey_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","وهاذو هوما قبايل أولاد النبي نوح حسب انسابهم وشعوبهم ومنهم اتفرڮو الشعوب فلارض عاڮب الطوفان. ");
INSERT INTO mey_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","وكانت الناس كاملة اللي فلارض تتكلم بلغة وحدة ويستخدمو كلمات يعرفوهم كاملين. ");
INSERT INTO mey_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","واخلڮ اعلن يلين رحلت الناس شور الشرق جبرو واد فارض شنعار واتسعو فيه. ");
INSERT INTO mey_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","وڮالو امبيناتهم: وهاو نڮبظو الطوب ونشووه بالنار. واستخدمو الطوب بل لحجار ونوع من الطين لمتين بل الطين العادي. ");
INSERT INTO mey_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","وڮالو: وهاو نبنو لروصنا مدينة وبرج يوصل طولو للسما ونعطو لروصنا هوية اياك ما نتفرڮو فكل جيهات لارض. ");
INSERT INTO mey_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","وانزل الله تعالى اياك يشوف لمدينة والبرج اللي كانو الناس يبنوهم. ");
INSERT INTO mey_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","وڮال الله تعالى: يلين عادو وهوما شعب واحد ويتكلمو بلغة وحدة، بداو يعدلو هاذا، ماهو لاهي يصعاب اعليهم يعدلو أي شي اوخر ينواو يعدلوه. ");
INSERT INTO mey_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ننزلو اصا وانخلطو لغتهم اياك كلهم ما يفهم لغة لوخر. ");
INSERT INTO mey_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","وشتتهم الله تعالى من فم فلارض كاملة ووڮفو عن بناء لمدينة. ");
INSERT INTO mey_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ولذا السبب اُسمات لمدينة بابل اللي معناها الله تعالى خلط لغة العالم كامل. ومن فم شتتهم الله تعالى فكل جيهات لارض. ");
INSERT INTO mey_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","وهاذي لاحة سجل أولاد سام: يلين عاد سام عندو 100 سنة اجبر أرفكشاد عاڮب الطوفان بسنتين. ");
INSERT INTO mey_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","وعاش سام عاڮب ذاك 500 سنة واجبر فيها أولاد اخرين وامنات. ");
INSERT INTO mey_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","وإلين عاد عندو أرفكشاد 35 سنة اجبر شالح. ");
INSERT INTO mey_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","وعاش أرفكشاد عاڮب ذاك 403 سنوات اجبر فيها أولاد اخرين وامنات. ");
INSERT INTO mey_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","وإلين عاد عندو شالح 30 سنة اجبر عابر. ");
INSERT INTO mey_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","وعاش شالح عاڮب ذاك 403 سنوات اجبر فيها أولاد اخرين وامنات. ");
INSERT INTO mey_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","وإلين عاد عندو عابر 34 سنة اجبر فالق. ");
INSERT INTO mey_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","وعاش عابر عاڮب ذاك 430 سنة اجبر فيها أولاد اخرين وامنات. ");
INSERT INTO mey_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","وإلين عاد عندو فالق 30 سنة اجبر رعو. ");
INSERT INTO mey_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","وعاش فالق عاڮب ذاك 209 سنوات اجبر فيهم أولاد اخرين وامنات. ");
INSERT INTO mey_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","وإلين عاد عندو رعو 32 سنة اجبر سروج. ");
INSERT INTO mey_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","وعاش رعو عاڮب ذاك 207 سنوات اجبر فيها أولاد اخرين وامنات. ");
INSERT INTO mey_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","وإلين عاد عندو سروج 30 سنة اجبر ناحور. ");
INSERT INTO mey_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","وعاش سروج عاڮب ذاك 200 سنة اجبر فيها أولاد اخرين وامنات. ");
INSERT INTO mey_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","وإلين عاد عندو ناحور 29 سنة اجبر تارح. ");
INSERT INTO mey_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","وعاش ناحور عاڮب ذاك 119 سنة اجبر فيها أولاد اخرين وامنات. ");
INSERT INTO mey_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","وإلين عاد عندو تارح 70 سنة اجبر أبرام وناحور وهاران. ");
INSERT INTO mey_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","وهاذا سجل أولاد تارح: تارح اجبر أبرام وناحور وهاران، وهاران اجبر لوط. ");
INSERT INTO mey_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ومات هاران سابڮ بوه تارح فلارض اللي اخلڮ فيها شور أور الكلدانيين. ");
INSERT INTO mey_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","واتعرس كل من أبرام وناحور وكان اسم اعيال أبرام ساراي واسم اعيال ناحور مِلْكَةُ منت هاران اللي اجبر مِلْكَةُ ويسكة. ");
INSERT INTO mey_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","وكانت ساراي عاڮر ما اتخلي التركة. ");
INSERT INTO mey_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","واڮبظ تارح ولو أبرام وول ولو لوط ول هاران وساراي اعيال ولو أبرام وامشاو فابلد من أور الكلدانيين واعدين ارض كنعان. يغير يلين لحڮو حاران سكنو فم. ");
INSERT INTO mey_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ومات تارح فحاران يلين كان عندو 205 سنوات. ");
INSERT INTO mey_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","وڮال الله تعالى لأبرام: امشي من ارضك وقبيلتك ودار أهلك، وڮيس لارض اللي لاهي انعتلك. ");
INSERT INTO mey_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ولاهي انعدل منك شعب عظيم، ولاهي انباركك، ولاهي انكبر اسمك، واتعود بركة لناس كاملة. ");
INSERT INTO mey_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","واللي يباركك يعود امبارك، واللي يلعنك يعود ملعون. ولاهي تتبارك القبايل كاملين اللي فلارض بسببك. ");
INSERT INTO mey_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","وڮام أبرام وعدل ذا اللي ڮالّو الله تعالى. وامشات امعاه ساراي اعيالو ولوط ول خوه من حاران. وفذا الوقت كان عندو أبرام 75 سنة. ");
INSERT INTO mey_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","وڮبظو امعاهم ادبشهم واعبيدهم اللي كانو فحاران، وامشاو واعدين ارض كنعان. وإلين وصلو ارض كنعان، ");
INSERT INTO mey_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","عاد أبرام يمشي من ابليدة شور ابليدة يجول فكنعان يلين اوصل لبليدة اللي فيها صدراية اكبيرة اسمها موري اللي خارج مدينة شكيم اللي ساكنين فيها الكنعانيين فذاك الوقت. ");
INSERT INTO mey_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","واظهر الله تعالى لأبرام، وڮالّو: لاهي نعطي هاذي لارض لنسلك. وڮام أبرام وابنا فم مذبح، ويڮدم فيه اذبايح لله تعالى اللي اظهرلو. ");
INSERT INTO mey_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","وعاڮب ذاك امشا من هاذي لبليدة واعد كدية فجيهة الشرق من لبليدة اللي اظهرلو الله تعالى فيها. وابنا خيمتو امبين بيت إيل اللي فالغرب ومدينة عاي اللي فالشرق. وابنا فم مذبح لله تعالى وصلى فيه. ");
INSERT INTO mey_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ومن فم ڮيم ماشي واعد النقب اللي فالجنوب. ");
INSERT INTO mey_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","وإلين خلڮت جفاف فارض كنعان، ڮام أبرام وامشا واعد مصر يسكن فيها شي من الوقت بيهلي الجفاف كانت امتينة فلارض. ");
INSERT INTO mey_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","وإلين ڮرب من مصر ڮال لساراي اعيالو: آنا نعرف اعلنك امرة زينة، ");
INSERT INTO mey_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","وإلين يشوفوك المصريين لاهي يڮولو عنك اعيالي، ويكتلوني، ويمشو بيك امعاهم. ");
INSERT INTO mey_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ڮوليلهم اصا عنك اختي ونسلكو من المشاكل ونجبرو العافية بسببك انتي. ");
INSERT INTO mey_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","وإلين ادخل أبرام مصر شافو أهل مصر اعلن اعيالو امرة زينة. ");
INSERT INTO mey_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","وشافوها املي عمال فرعون وخبرو فرعون بجمالها ، وامشاو بيها شور قصرو. ");
INSERT INTO mey_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ولا ابخل شي من شي متعدل لأبرام بسبب ساراي، واعطاه لغنم ولبڮر ولحمير ولعبيد ولخدم والبل. ");
INSERT INTO mey_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","يغير ما ابطا فرعون يلين ابلاه الله تعالى هو وأهلو بامراض خطيرة بسبب اعلنو اكبظ ساراي زوجة أبرام وحاول يتعرص امعاها. ");
INSERT INTO mey_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","وڮام فرعون ومشّا لأبرام يجيه وڮالّو: انتا ذا اللي عدلتلي شنهو؟ اعلاش ما اتڮولي اعلنها اعيالك؟ ");
INSERT INTO mey_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","اعلاش اتڮولي اعلنها ختك اياك نڮبظها ونتخيم امعاها؟ ظرك اصا اسمع، اڮبظ اعيالك وامرڮ بيها. ");
INSERT INTO mey_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","وڮام فرعون ووصا اعليه ارواڮيج يصيفطوه هو واعيالو وكل أملاكو. ");
INSERT INTO mey_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","وامشا أبرام من مصر وامعاه ساراي ولوط وكل أملاكو شور النقب فكنعان. ");
INSERT INTO mey_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","وكان أبرام عندو ياسر من الحيوان والفظة والذهب. ");
INSERT INTO mey_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","وامشا من النقب شور بيت إيل إلى لبليدة اللي ڮط ابنا فيها خيمتو فلول، اللي امبين بيت إيل وعاي. ");
INSERT INTO mey_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","وهاذي هي لبليدة اللي فيها مذبح مولانا اللي ڮط ابنا. وفم صلى لله تعالى. ");
INSERT INTO mey_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","وكان املي لوط اللي امشا امع أبرام عندو لغنم ولبڮر ولخيام. ");
INSERT INTO mey_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","وامتلات لارض من أملاكهم يلين ما اتلا فم بل امنين يعيشو فيه فبلد. ");
INSERT INTO mey_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","وخلڮت اخصومة امبين رعيان أبرام ورعيان لوط فالوقت اللي كانو يعيشو فيه الكنعانيين والفرزيين فلارض. ");
INSERT INTO mey_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","وڮال أبرام للوط : ما يالتنا نتخاصمو امبيناتنا، ولا يالتهم يتخاصمو رعياننا بيهلي نحنا خوت، ");
INSERT INTO mey_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ولارض واسعة ڮدامك. خلينا نتفاصلو. وإلين تمشي اعلى زرك العربي، نمشي اعلى زري العسري. وإلين تمشي اعلى زرك العسري، نمشي آنا شور زري العربي. ");
INSERT INTO mey_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","واتلفت لوط اعلى زرو وشاف واد الأردن كامل يلين صوغر. وكانت لارض املانة من لخظار وكيفت جنة الله تعالى، وتشابه لارض مصر. وهاذا كان سابڮ يهلك الله تعالى سدوم وعمورة. ");
INSERT INTO mey_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","واختار لوط لراصو واد الأردن كامل، وامشا شور الشرق. واتفرڮ كلهم عن صاحبو. ");
INSERT INTO mey_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","واسكن أبرام فارض كنعان، واسكن لوط فابلد لخظار، وابنا اخيامو اڮريب من سدوم. ");
INSERT INTO mey_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","وكانو أهل سدوم اشرار وعاصين حته لله تعالى. ");
INSERT INTO mey_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","وڮال الله تعالى لأبرام عاڮب ما امشا عنو لوط: رڮب عينيك واتلفت من حولك من لبليدة اللي انتا فيها، الشمال والجنوب والشرق والغرب، ");
INSERT INTO mey_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","بيهلي هاذي لارض اللي انتا شايف لاهي نعطيهالك ولنسلك إلى الابد. ");
INSERT INTO mey_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ولاهي انعدل نسلك كيفت احصي التراب، إلى عاد آراڮاج يڮد يحسب احصي التراب يتمكن من عد ذريتك . ");
INSERT INTO mey_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ڮوم وامشي فطول لارض وعرظها بيلي اعطيتهالك. ");
INSERT INTO mey_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","وڮام أبرام وارفد اخيامو وابناها احذا اصدر ممرا اللي احذا حبرون. وابنا مذبح لله تعالى فم. ");
INSERT INTO mey_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","وفذاك الوقت اخلڮ اعلن أمرافل ملك بابل وأريوك ملك ألاسار وكدرلعومر ملك عيلام وتدعال ملك جويم ");
INSERT INTO mey_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ادايڮو امع بارع ملك سدوم وبرشاع ملك عمورة وشنأب ملك أدمة وشمئير ملك صبويم وملك بالع اللي هي صوغر. ");
INSERT INTO mey_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","كلهم اجمع اللي عندو من لجنود فواد السديم اللي ينڮالو لبحر الميت. ");
INSERT INTO mey_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","واللي كانو اعبيد لكدرلعومر مدة 12 سنة، يغير امبلڮو واتكبرو اعليه فالسنة 13 . ");
INSERT INTO mey_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","وفالسنة 14 امشا كدرلعومر وأصحابو من الملوك، وغلبو الرفائيين فلبليدة ينڮالها عشتروت قرنائم. وغلبو الزوزيين فلبليدة ينڮالها هام. وغلبو الإيميين فبطحة قريتايم. ");
INSERT INTO mey_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","وغلبو الحوريين احذا كدية سعير يلين بيت فاران اللي ماهو ابعيد من الخلوات. ");
INSERT INTO mey_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ومن فم رجعو واعدين مدينة قادش، وغلبو كل لارض اللي كانو فيها قبيلة العماليق. وغلبو املي الأموريين اللي كانو ساكنين فارض حزازون تامار. ");
INSERT INTO mey_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","وعاڮب ذاك ڮامو كل من ملك سدوم وملك عمورة وملك أدمة وملك صبويم وملك بالع، ");
INSERT INTO mey_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","وادايڮو امع كدرلعومر ملك عيلام وتدعال ملك جويم وأمرافل ملك بابل وأريوك ملك ألاسار فواد السديم. وكانو أربع ملوك ضد خمسة. ");
INSERT INTO mey_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","وكان واد السديم املان من ظايات الطين. وكل من ملك سدوم وملك عمورة حاولو يهربو امع رجالتهم من الحرب يغير وحلو فالطين واللي اسلك منهم اهرب شور الكدية. ");
INSERT INTO mey_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","وڮامو الملوك لخرين الربعة الباڮين اللي غلبو فالحرب وڮبظو كل شي كان فسدوم وعمورة من أملاك واطعام وامشاو. ");
INSERT INTO mey_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","وڮردو لوط ول خو أبرام اللي كان ساكن فسدوم فهاذا الوقت، وڮبظو كل شي كان عندو. ");
INSERT INTO mey_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","واسلك آراڮاج من أهل سدوم وعمورة، وجا لأبرام العبراني ورد اعليه ذا اللي اخلڮ. وكان أبرام ساكن احذا صدراية اكبيرة اللي فاتراب ممرا، اللي من الأموريين، وهو خو أشكول وعانر، وكلهم أصحاب لأبرام. ");
INSERT INTO mey_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","وإلين اسمع أبرام باعلن ول خوه نحبس، ڮام واڮبظ كل رجالتو اللي اخلاڮة وكابرين عندو، واللي كان عددهم 318 آراڮاج، وامشا دافع اورا الملوك الربعة يلين لحڮ مدينة دان. ");
INSERT INTO mey_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","وإلين عاد ليل، ڮام أبرام وڮسم رجالتو اعلى فرق، واهجم اعليهم، واغلبهم، وامشا دافع اوراهم يلين لحڮو ابليدة اسمها حوبه اللي هي شمال دمشق. ");
INSERT INTO mey_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","واڮبظ اللي كانو يملكو، وجاب لوط ول خوه وأملاكو ولعليات ولمحابيس لخرين. ");
INSERT INTO mey_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","وارجع إبراهيم بعدما اغلب الملك كدرلعومر والملوك لخرين اللي كانو امعاه. وخاظ ملك سدوم اياك يستقبلو فواد شوى اللي اسمو واد الملك. ");
INSERT INTO mey_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","وكان ملكيصادق ملك ساليم امع ملك سدوم . واعطا ملكيصادق لأبرام شي من امبورو وشي من عصير العنب. وكان راجل من رجالة مولانا العظيم. ");
INSERT INTO mey_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","وبارك أبرام وڮالّو: اعليك بركة مولانا العظيم اللي خلڮ السما والتراب، ");
INSERT INTO mey_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","والحمد لمولانا العظيم اللي نصرك اعلى أعدائك. واعطاه أبرام العشر من كل شي كان عندو. ");
INSERT INTO mey_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","وعاڮب ذاك ڮال ملك سدوم لأبرام: لاهي نڮبظ الرواڮيج وانتا تڮبظ الباڮي. ");
INSERT INTO mey_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","وڮالّو أبرام: احلفت اعلى الله تعالى اللي خلك السما والتراب، ");
INSERT INTO mey_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","اعلني ما نڮبظ أي شي من ذا اللي عندك اياك ما اتڮول اعلني اجبرت الخير من عندك. ");
INSERT INTO mey_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ولاني لاهي نڮبظ من عندك ماهو اللي كالو رجالتي. يغير اصا الرجالة اللي امشاو امعايَ فالحرب واللي هوما عانر وأشكول وممرا، خليهم يجبرو ڮرعتهم. ");
INSERT INTO mey_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","وعاڮب يلين خلڮت هاذي لمور، ڮال الله تعالى لأبرام فحلم: لا تخاف من شي. آنا نحميك وأجرك اكبير عندي. ");
INSERT INTO mey_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","وڮال أبرام: يا مولانا يا ربي شنهي اصا فايدة الخير اللي تعطيني. آنا ما نجبر لولاد، واللي لاهي يورثني هو أليعازر اللي من دمشق. ");
INSERT INTO mey_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","وڮال املي أبرام: انتا ما اعطيتني لولاد وذا هو لعبد اللي اخلاڮة عندي لاهي يورثني. ");
INSERT INTO mey_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","وڮالّو الله تعالى: ذا لعبد ماهو لاهي يورثك. اللي لاهي يورثك لاهي يوخظ من صلبك. ");
INSERT INTO mey_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ووخظ الله تعالى أبرام شور ڮدام خيمتو وڮالّو: خرص السما واعد النجوم إلى ڮديت. وڮالّو الله تعالى: ڮد عدد النجوم لاهي يعود ڮد نسلك. ");
INSERT INTO mey_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","وصدق أبرام الله تعالى واعتبر الله تعالى أبرام إنسان صالح. ");
INSERT INTO mey_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","وڮالّو: آنا هو الله تعالى اللي جابك من أور الكلدانيين اياك انورثك هاذي لارض . ");
INSERT INTO mey_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","وڮال أبرام لله تعالى: ابسيمحالة لاهي نعرف اعلني لاهي نورثها؟ ");
INSERT INTO mey_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","وڮالّو الله تعالى: اڮبظلي عجلة وعنز وكبش اعمر كل منهم 3 سنوات. وڮبظلي املي احمامتين. ");
INSERT INTO mey_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","وڮبظهم أبرام وشڮهم من الوسط اعلى نصين واجعل كل نص امڮابل النص لوخر، والطيور ما ڮسمهم. ");
INSERT INTO mey_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","وإلين ڮامت الطيور لخلة تنزل وتوكل من الجيفة، صاعهم أبرام. ");
INSERT INTO mey_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","وإلين الحڮ لمغرب، ارڮد أبرام ارڮاد امتين، وفذا جات اعليه ظلمة امتينة ونخلع. ");
INSERT INTO mey_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","وڮالّو الله تعالى: عود متيقن اعلن نسلك لاهي يتغرب فارض ماهي لهم ، ولاهي يستعبدوهم أهلها ويحڮروهم مدة 400 سنة. ");
INSERT INTO mey_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","يغير لاهي انخلص لهم من ذاك الشعب اللي أستعبدهم، وعاڮب ذاك لاهي يوخظو بياسر من لأملاك. ");
INSERT INTO mey_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","وانتا لاهي اتموت فالعافية وتندفن بشيبة صالحة. ");
INSERT INTO mey_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","وهوما لاهي يرجعو هون عاڮب أربع اجيال . بيهلي اثام الأموريين اللي ساكنين هون ما فات عادت ياسرة اياك يعاقبهم الله تعالى اعليها . ");
INSERT INTO mey_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","وإلين غربت الشمس وجات الظلمة، اظهر اعمود من الدخان واشهاب من النار واخظين امبين طشات اللحم. ");
INSERT INTO mey_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","وفذاك اليوم عدل الله تعالى عهد امع أبرام وڮالّو: لاهي نعطي هاذي لارض لنسلك من نهر مصر إلى نهر لكبير، نهر الفرات، ");
INSERT INTO mey_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ابلاد القينيين والقنزيين والقدمونيين ");
INSERT INTO mey_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","والحيثيين والفرزيين والرفائيين ");
INSERT INTO mey_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ولأموريين والكنعانيين والجرجاشيين واليبوسيين. ");
INSERT INTO mey_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","وساراي اعيال أبرام كانت امرة عاڮر. وكانت عندها خادم مصرية اسمها هاجر. ");
INSERT INTO mey_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","وڮالت ساراي لأبرام: الله تعالى ما اعطاني الذرية. ڮوم اصا اتكي امع هاجر. يكان الله تعالى يعطيني ذرية منها. وعدل أبرام ذا اللي ڮالتلو ساراي اعيالو. ");
INSERT INTO mey_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","وڮامت ساراي واعطاتو خادمها وعاشرها. وهاذا اخلڮ عاڮب ما قضاو 10 سنوات فارض كنعان. ");
INSERT INTO mey_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","وعاشر أبرام هاجر وحملت منو . وإلين عرفت أنها حملت، عادت تحڮر عربيتها ساراي. ");
INSERT INTO mey_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","وفذا ڮالت ساراي لأبرام: الله تعالى يحاسبك اعلى ذا اللي اخلڮلي. عاڮب ما اعطيتك خادمي وحملت منك، عادت تحڮرني. الله تعالى يقضي بيني وبينك. ");
INSERT INTO mey_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","وجاوبها أبرام وڮالها: هاذي خادمك ڮدامك وعدليلها اللي اتدوري. وعذبت ساراي هاجر يلين هربت اعليها. ");
INSERT INTO mey_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","واجبرها ملاك الله تعالى اڮريب من ظاية الماء فطريڮ اللي واعدة مدينة اسمها شور. ");
INSERT INTO mey_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","وڮالها ملاك الله تعالى: يا هاجر يا خادم ساراي، من امنين جاية؟ وامنين واعدة؟ وڮالتلو هاجر: آنا اهربت من عربيتي ساراي. ");
INSERT INTO mey_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","وڮالها ملاك الله تعالى: رجعي شور عربيتك وسمعيلها. ");
INSERT INTO mey_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","وڮالها املي: لاهي انكثر نسلك يلين يعود ما يڮد ينعد. ");
INSERT INTO mey_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","وڮالها املي: انتي موجوعة ظرك ولاهي تبراي اعلى اطفيل، ولاهي اتسميه إسماعيل اللي معناه الله تعالى يسمع. بيهلي الله تعالى حس بألامك. ");
INSERT INTO mey_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","واطفيلك لاهي يعود آراڮاج امتين وامعادي الناس كاملة والناس كاملة امعاديتو. ولاهي يعود آراڮاج مستحرش ومتكبر اعلى اخوتو كاملين. ");
INSERT INTO mey_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","وحمدت هاجر الله تعالى اللي شافها وحس بألامها وڮالت: آنا شفت ظرك اللي يراعي فيَّ . ");
INSERT INTO mey_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ولذاك اُسمات هاذي الحاسي باسم: حاسي الحي اللي يراعي فيَّ. وهاذي الحاسي هي موجودة امبين قادش وبَاردَ. ");
INSERT INTO mey_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","وعاڮب ذا خلات هاجر لأبرام ولو. وسما أبرام اطفيلو اللي من هاجر باسم إسماعيل. ");
INSERT INTO mey_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","وكان أبرام فذا الوقت عندو 86 سنة. ");
INSERT INTO mey_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","وإلين عاد أبرام عندو 99 سنة اتجلالّو الله تعالى وڮالّو: آنا هو مولانا القادر، امشي ڮدامي بطريڮ امسڮمة. ");
INSERT INTO mey_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","لاهي انعدل عهدي امعاك وانكثر نسلك حته. ");
INSERT INTO mey_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","وڮام أبرام واسجد ڮدام مولانا. واتكلم امعاه مولانا وڮالّو: ");
INSERT INTO mey_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","اراعيني لاهي انعدل عهدي امعاك ولاهي اتعود بو ياسر من لأُمم. ");
INSERT INTO mey_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ومن ظرك ما اتلا ينڮالك أبرام اللي معاناه البو لمعظم ، يغير لاهي ينڮالك النبي إبراهيم اللي معناها بو ياسر من لأُمم. بيلي لاهي انعدلك منك ياسر من الشعوب. ");
INSERT INTO mey_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ولاهي اتعود آراڮاج فايديتو ياسرة، ولاهي يتفرع من نسلك ياسر من الشعوب، ولاهي يوخظو من نسلك ملوك. ");
INSERT INTO mey_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","ويعود عهدي إلى الأبد امبيني وبينك وبين نسلك عاڮبك جيل اورا جيل. وانعودلك إله ولنسلك من بعدك ");
INSERT INTO mey_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ونعطيك انتا ولذريتك من بعدك ارض كنعان كاملة، اللي اسكنتها متغرب، لكم الدهر كاملو وانعود إلههم. ");
INSERT INTO mey_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","وڮال مولانا للنبي إبراهيم: احفظ عهدي انتا وذريتك من عاڮبك مادامو حيين. ");
INSERT INTO mey_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","هاذا هو لعهد اللي امبيني وبينك وامبين ذريتك من بعدك اللي يالتكم تحفظوه: يُزيّنو الذكور كاملين اللي عندكم . ");
INSERT INTO mey_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","اتزينو كل اذكوركم كاملين واتعود علامة لعهد اللي امبيني وامبينكم. ");
INSERT INTO mey_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","اتمو زينو اذكوركم كاملين من بو 8 أيام اسوا من ذريتك وللا من ذرية حد مشري من فظتك ماهو من نسلك. ");
INSERT INTO mey_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","يالة يُزيّن كل اطفيل اخلاڮة فدارك وللا مشري بالفظة، واتعود علامة عهدي إلى الأبد فلحمكم . ");
INSERT INTO mey_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","واذكر اللي فيكم ما اُزيّن ينصاع من دار أهلو بيهلي خالف عهدي. ");
INSERT INTO mey_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","وڮال مولانا للنبي إبراهيم: وساراي اعيالك لا تيت اتڮولها ساراي من ظرك، يغير لاهي يعود اسمها سارة اللي معناها لأميرة. ");
INSERT INTO mey_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ولاهي انباركها، ولاهي نعطيك اطفيل منها، ولاهي انباركها وانعدلها أم لياسر من الشعوب. ومنها لاهي يوخظ ملوك. ");
INSERT INTO mey_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","واسجد النبي إبراهيم واظحك وڮال امبينو امع راصو: اثرو يصح يخلڮ اطفيل لراجل بو 100 سنة ؟ واثرو يصح تبرا سارة وهي أم 90 سنة ؟ ");
INSERT INTO mey_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","وڮال النبي إبراهيم لمولانا: وإسماعيل ياريتو يُحظَر من بركتك . ");
INSERT INTO mey_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","وڮالّو مولانا: اللي لاهي تبرا هي سارة اعيالك، ولاهي يخلڮلك منها اطفيل، واتسميه إسحاق. لاهي انعدل عهدي إلى الأبد امعاه وامع ذريتو من بعدو. ");
INSERT INTO mey_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","أما اصا إسماعيل فأستجبت لطلبتك لو. لاهي انباركو حته، ولاهي يعود فايدتو ياسرة، ولاهي انكثر نسلو، ولاهي يعود بو للثاني عشر رئيس. ويعود شعب اكبير. ");
INSERT INTO mey_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","يغير عهدي لاهي يعود امع إسحاق اللي لاهي يجي من سارة كيف هاذا الوقت من السنة الجاية. ");
INSERT INTO mey_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","وإلين اوفا مولانا من لكلام امع النبي إبراهيم امشا عنو. ");
INSERT INTO mey_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","وفذاك النهار اڮبظ النبي إبراهيم ولو إسماعيل والذكور كاملين اللي خلڮو فدارو والذكور كاملين اللي اشرا، وزينهم، وعدل ذا اللي ڮالّو مولانا. ");
INSERT INTO mey_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","وكان النبي إبراهيم عندو 99 سنة وقت ازيانتو. ");
INSERT INTO mey_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","وإسماعيل ولو وقت ازيانتو عندو 13 سنة. ");
INSERT INTO mey_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","وتمت ازيانة النبي إبراهيم وإسماعيل ");
INSERT INTO mey_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","والذكور كاملين اللي خلڮو فدارو واذكور كاملين اللي اشرا فنفس اليوم. ");
INSERT INTO mey_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","وعاڮب ذاك اظهر الله تعالى للنبي إبراهيم عند صدراية ممرا، وقت اللي كان ڮاعد ڮدام فم خيمتو لڮايلة. ");
INSERT INTO mey_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","وفذا رڮب وجهو وشاف اثلت رجالة ماشين اعلى جيهتو، وادفع شورهم اياك يرحب بيهم. وإلين لحڮهم، ڮام واسجد اعلى التراب إحترام لهم. ");
INSERT INTO mey_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","وڮال: يا شيخي إلى عدت شايف عن عبدك يستحق الشرف عنك تستراح عندو، لا تتخطاه. ");
INSERT INTO mey_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","وخليني انجيب لكم شي من الماء تغسلو بيه كرعيكم وتڮعدو تحت ظل الصدراية. ");
INSERT INTO mey_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","وانجيب لكم شي من امبورو توكلوه ومن فم تواصلو مشيكم واتعودو خظتو اعلى خيمة عبدكم. وڮالولو: ما فم مشكلة، عدل ذا اللي ڮلت. ");
INSERT INTO mey_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","وادفع النبي إبراهيم واعد خيمتو اللي فيها سارة وڮالها: ڮومي بالعجلة وعجني 3 كيلات اكبار من الدڮيڮ الزين وخبزيهم. ");
INSERT INTO mey_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","وڮام النبي إبراهيم وادفع شور امراحو واڮبظ اعجل اسمين واعطاه لجديع عندو ينصبو. ");
INSERT INTO mey_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","وعاڮب ذاك اڮبظ النبي إبراهيم شي من الزبدة وللبن ولعجل اللي انطبخ، واطرح ذا ڮدامهم، وابڮا واڮف ڮدامهم يخدمهم تحت الصدراية وهوما يوكلو. ");
INSERT INTO mey_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","وڮالولو: وينهي اعيالك؟ ڮالّهم النبي إبراهيم: اراعيها فالخيمة. ");
INSERT INTO mey_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","وڮال واحد منهم للنبي إبراهيم: لاهي نرجعلك فهاذا الوقت من السنة الجاية ولاهي اتعود سارة عادت باطفيلها منك. وذا الوقت كانت سارة واڮفة اوراه عند فم الخيمة وسمعت اكلامهم. ");
INSERT INTO mey_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","وكان النبي إبراهيم وسارة اكهولة اكبار فالسن واتخطات سارة سن لحمل. ");
INSERT INTO mey_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","وظحكت سارة امبينها امع راصها وڮالت: عاڮب ما استكهلت وعاد راجلي شيباني نجبر العيال؟ ");
INSERT INTO mey_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","فذا ڮال الله تعالى للنبي إبراهيم: اشواسا سارة تظحك واتڮول: انڮد نبرا اعلى اطفيل وآنا كهلة؟ ");
INSERT INTO mey_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","الله تعالى اثرو يڮلبو شي؟ لاهي نرجعلك فهاذا الوقت من السنة الجاية واتعود سارة عادت باطفيلها منك. ");
INSERT INTO mey_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","وانخلعت سارة ونكرت اعلنها ظحكت. وڮالها الله تعالى: ماهي حڮ انتي اظحكتي اڮبال! ");
INSERT INTO mey_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","وعاڮب ذاك ڮامو الرجالة الثلاثة ماشين اعلى جيهة سدوم، وامشا امعاهم النبي إبراهيم يسيفطهم. ");
INSERT INTO mey_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","وڮال الله تعالى اللي هو واحد من الرجالة الثلاثة : ما انڮد نجحد عن إبراهيم اللي ناوي انعدل لسدوم. ");
INSERT INTO mey_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","وإبراهيم لابد من يعود بو شعب اكبير وامتين وتتبارك شعوب لارض كاملة بسببو . ");
INSERT INTO mey_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","بيلي آنا هو اللي اخترتو اياك يوصي أولادو وأهلو من بعدو اياك يحفظو الطريڮ الله تعالى، امعدلين البر والعدل يلين يعدل الله تعالى اللي اتعهد بيه للنبي إبراهيم. ");
INSERT INTO mey_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","وڮال الله تعالى: اكثارة الشكوى والظلم اعلى أهل سدوم وعمورة وشرهم زاد اعلى حدو. ");
INSERT INTO mey_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","لاهي انڮيسهم وانشوف إلى عاد ذا حڮ ونتأكد بنفسي. ");
INSERT INTO mey_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","وامشاو الرجالة اللي كانو امع الله تعالى واعدين سدوم ، وابڮا النبي إبراهيم واڮف امع الله تعالى. ");
INSERT INTO mey_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","وڮرب النبي إبراهيم منو وڮالّو: لاهي تهلك الصالح امع الشرير؟ ");
INSERT INTO mey_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","يلين تجبر فذي لمدينة 50 آرڮاج صالحة لاهي تهلكها وللا لاهي اتسامحها اعلى أساس هاذو الخمسين الصالحين؟ ");
INSERT INTO mey_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","انتا اعظم من اللي اتخلط امبين الصالح والشرير، ويعود الصالح كيف الشرير حشاك. ما يصح اعلنك انتا الديان ما تَعْدل؟ ");
INSERT INTO mey_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","وڮال الله تعالى للنبي إبراهيم : يلين نجبر فسدوم الا 50 آرڮاج صالحة انسامح الباڮين. ");
INSERT INTO mey_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","وڮال النبي إبراهيم: آنا كثرت من لكلام امع الرب امع اعلني مخلوق من التراب والرماد. ");
INSERT INTO mey_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","وفحالتهم نقصو 5 ارواڮيج صالحين لاهي تهلك لمدينة اعلى أساس 45؟ وڮالّو : يلين نجبر فيها 45 صالحين ما نهلكها. ");
INSERT INTO mey_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","وڮالّو النبي إبراهيم مرة ثانية: وفحالتك اجبرت الا 40 آرڮاج صالحة؟ وڮالّو : ماني لاهي نهلكهم اعلى أساس 40 الصالحين. ");
INSERT INTO mey_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","وڮال النبي إبراهيم: لا تنفڮع اعليَّ واسمحلي نتكلم، وفحالتك اجبرت الا 30 صالحين؟ وڮالّو: ماني لاهي نهلكها إلى اجبرت فيها 30 صالحين. ");
INSERT INTO mey_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","وڮال النبي إبراهيم: آنا نعرف اعلني كثرت لكلام امعاك، يغير فحالتك اجبرت الا 20 صالحين؟ وڮالّو : ماني لاهي نهلكها يلين نجبر فيها 20. ");
INSERT INTO mey_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","وڮال النبي إبراهيم: لا تغضب اعليَّ يا رب إلى اتكلمت وڮلتلك إلى اجبرت فلمدينة الا 10 صالحين؟ وڮالّو : ماني لاهي نهلكها إلى اجبرت فيها 10. ");
INSERT INTO mey_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","وعاڮب ما اوفا الله تعالى من لكلام امع النبي إبراهيم، امشا وارجع النبي إبراهيم شور بلو. ");
INSERT INTO mey_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","وجاو الملايكة لأثنين لمدينة سدوم امع اغروب الشمس. وذا الوقت كان لوط ڮاعد احذا بوابة سدوم. وإلين شافهم ڮام واڮف واعدهم يستقبلهم ، واسجد بوجهو اعلى التراب إحترام لهم. ");
INSERT INTO mey_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","وڮال: يا شيوخي استراحو وباتو فدار عبدكم اياك اتقضو ليلتكم وتغسلو كرعيكم، وامع الصباح اتواصلو اطريڮكم. وڮالولو: ابدي لاهي انقضو ليلتنا لڮدام. ");
INSERT INTO mey_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","يغير لوط الح اعليهم يلين ڮبلو يمشو امعاه ويباتو فدارو. وعشاهم واخبزلهم امبورو وكالو. ");
INSERT INTO mey_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","وسابڮ يرڮدو اجتمع اعليهم اكهولة وفڮاريج مدينة سدوم ڮدام الدار. ");
INSERT INTO mey_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","وعيطو لوط وڮالولو: وين هوما الرجالة اللي بايتين عندك الليلة ؟ وخظهم شورنا اياك انلوطوهم. ");
INSERT INTO mey_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","وخاظ شورهم لوط واڮفل الباب اوراه ");
INSERT INTO mey_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","وڮال: لا اتعدلو المعصية يا خوتي. ");
INSERT INTO mey_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","اراعي عندي منتين اعزيبات. لاهي انوخظهم لكم اياك اتعدلو امعاهم اللي تبغو. أما اصا ذو الرجالة لا اتعدلولهم شي ما ينفع بيهلي ضيوف عندي. ");
INSERT INTO mey_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","وڮالولو: اكحز ابعيد عنّا ! وڮالو املي: ذا آرڮاج اللي جا يسكن عندنا عاد هامو يتحكم فينا. ظرك اصا لاهي انعدلولك شي أطم منهم هوما. واتڮدمو واعدين لوط لاهي يدڮدڮو الباب. ");
INSERT INTO mey_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","فذا الرجالة اللي هوما خطار لوط مدو ايديهم وحكموه ودخلوه وسط الدار، وڮفلو الباب. ");
INSERT INTO mey_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","وخبطو بلعما ارواڮيج اللي كانو واڮفين ڮدام الباب، اصغيرهم واكبيرهم، يلين عاد قالبهم يجبرو بل امنين الباب. ");
INSERT INTO mey_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","وڮالّو الرجالة لأثنين للوط : مندرا يكان عندك أقارب فلمدينة: انساب وللا أولاد وللا امنات وللا أي آراڮاج اوخر اڮريب منك؟ وخظهم من هاذي لمدينة ");
INSERT INTO mey_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","بيهلي نحنا هامنا اندمرو هاذي لبليدة بيهلي كثرة الشكوى من شرها عند الله تعالى، وارسلنا اياك اندمروها. ");
INSERT INTO mey_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","وامشا لوط يعلم الرجالة اللي كانو لاهي يتخيمو امع امناتو وڮالّهم: ڮومو الفوڮ واوخظو من هاذي لبليدة بيهلي الله تعالى لاهي يدمر هاذي لمدينة. ولا جد اعليهم اكلامو. ");
INSERT INTO mey_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","وإلين عاد الفجر الحو الملايكة لأثنين اعلى لوط وڮالولو: ڮوم الفوڮ واڮبظ اعيالك وامناتك اللي امعاك اياك ما تهلك بسبب اثام أهل لمدينة. ");
INSERT INTO mey_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","يغير يلين ابطا لوط حكمو الرجالة بايديه وايدين اعيالو وامناتو وامشاو بيهم شور ڮدام لمدينة بيهلي الله تعالى اشفق اعليهم. ");
INSERT INTO mey_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","وإلين وخظوهم ابعيد ڮال واحد من الملايكة للوط: سلك روحك ولا اتخرص اوراك ولا توڮف فذي لبليدة كاملة. اهرب اعلى جيهة لكدا اياك تسلك. ");
INSERT INTO mey_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","وڮال لوط: لا اتواسيلي ذاك يا شيخي، ");
INSERT INTO mey_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","انتا اعرفتلي شي واهتميت بيَّ وسلكتني من الموت. يغير آنا ما انڮد نلجا فلكدا خايف من يخلڮلي شي وانموت. ");
INSERT INTO mey_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","اراعي مدينة اڮريب انڮد نهرب شورها. وهي مدينة اصغيرة وخليني نلجا شورها. امالها مدينة اصغيرة حته؟ وانڮد نسلك فيها بروحي؟ ");
INSERT INTO mey_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","وڮالّو الملاك: آنا اڮبلت طلبك ولاني لاهي اندمر ذي لمدينة الصغيرة. ");
INSERT INTO mey_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","اهرب شورها بالعجلة بيهلي ما انڮد انعدل شي لسدوم سابڮ توصل انتا لهاذي لمدينة الصغيرة. ولهاذا السبب اُسمات هاذي لمدينة باسم صوغر اللي معناها الصغيرة. ");
INSERT INTO mey_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","وإلين ظهرت الشمس اعلى لارض، الحڮ لوط صوغر. ");
INSERT INTO mey_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","وفذا امطر الله تعالى اعلى سدوم وعمورة كبريت ونار من السما. ");
INSERT INTO mey_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","واحرڮ الله تعالى ذيك لارض واللي ساكنين فيها والوديان اللي حذاها وكل ارضهم كاملة اللي محروثة. ");
INSERT INTO mey_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","واتلفتت اعيال لوط اللي كانت اوراه بيها اڮبيظ لقبة واتحولت شور اعمود من الملح . ");
INSERT INTO mey_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","وامشا النبي إبراهيم امع الصباح شور لبليدة اللي وڮف فيها ڮدام الله تعالى. ");
INSERT INTO mey_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","وخرص اعلى جيهة سدوم وعمورة واعلى لارض اللي امجاورتهم وشاف الدخان طالع اعلى شكل اعمود. ");
INSERT INTO mey_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","وعاڮب ما دمر مولانا هاذي لبليدة، ما انسا وعدو للنبي إبراهيم ووخظ لوط سابڮ يدمر لمدينة اللي كان ساكن فيها. ");
INSERT INTO mey_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","وعاڮب ما دمر مولانا سدوم وعمورة، امشا لوط وامناتو من صوغر، واسكنو فلكدا بيهلي كان خايف من السكن فصوغر. والجا هو وامناتو فامغارة فالكدية. ");
INSERT INTO mey_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","وڮالت منتو لكبيرة لختها الصغيرة : نحنا بونا يستكهل ولارض ما اتلاو فيها رجالة يتخيمو امعانا كيف الناس كاملة. ");
INSERT INTO mey_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","اتعالي اصا نسڮوه شي من الخمر ونتكو امعاه اياك ما تنڮطع ذرية بونا. ");
INSERT INTO mey_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","واسڮاو الخمر لبوهم فذيك الليلة، وڮامت المنت لكبيرة واتكات امعاه . ولا حس لوط بتكيها امعاه ولا اڮيامها. ");
INSERT INTO mey_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","وفانهار اللي اوراه ڮالت المنت لكبيرة لختها الصغيرة: آنا اتكيت امع بويَ البارح . وهاي نسڮوه الخمر هاذي الليلة املي وتدخلي شورو انتي وتتكي امعاه، ونجبرو من بونا ذرية. ");
INSERT INTO mey_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","واسڮاو بوهم الخمر فذي الليلة الثانية وڮامت المنت الصغيرة واتكات امعاه. ولا حس لوط بتكيها امعاه وللا اڮيامها. ");
INSERT INTO mey_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","وبهاذا السبب حملو امنات لوط من بوهم. ");
INSERT INTO mey_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","وابرات المنت لكبيرة اعلى اطفيل سماتو مؤاب اللي معناه من بويَ، وهو بو قبيلة المؤابيين إلى اليوم. ");
INSERT INTO mey_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","والمنت الصغيرة ابرات املي اعلى اطفيل وسماتو بن عمي اللي معناه ول أهلي، وهو بو قبيلة بني عمون إلى اليوم. ");
INSERT INTO mey_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","وارحل النبي إبراهيم من فم واعد ارض النقب اللي فالجنوب واسكن امبين مدينة قادش ومدينة شور وقضا شي من الوقت فمدينة جرار. ");
INSERT INTO mey_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","وفم ڮال النبي إبراهيم عن سارة اعيالو: هاذي اختي. وارسل أبيمالكك ملك جرار امراسيل يجيبولو سارة . ");
INSERT INTO mey_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","واتجلا مولانا لأبيمالك فحلم فالليل وڮالّو: انتا لاهي اتموت بسبب اعلنك اڮبظت امرة متخيمة . ");
INSERT INTO mey_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","يغير أبيمالك لحڮو ذا مافات امسها وڮال لمولانا: لاهي تكتلني وتكتل أمة بريئة؟ ");
INSERT INTO mey_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","امالو ڮالّي اعلنها اختو وهي املي ڮالتلي اعلنو خوها؟ ما عدلت ذا اللي عدلت يكون شاك اعلنو صالح ونيتي كانت زينة . ");
INSERT INTO mey_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","وڮالّو مولانا: آنا نعرف اعلنك نيتك كانت زينة ، ولذاك امنعتك من اطيح فالمعصية واتمس سارة. ");
INSERT INTO mey_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ظرك اصا رجع للراجل اعيالو بيهلي هو نبي، اياك يطلبك مولانا وتحيا. وإلى ما رجعتها اعرف اعلنك انتا وذا اللي لك ميتين قطعا. ");
INSERT INTO mey_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","وبكر أبيمالك امع الصباح وعيط لعبيدو كاملين، ورد اعليهم ذا اللي اخلڮ، وانخلعو كاملين خلعة امتينة. ");
INSERT INTO mey_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","وعيط أبيمالك للنبي إبراهيم وڮالّو: اللي عدلتنا شنهو؟ شنهو الخطأ اللي عدلتلك اياك اتجيبلي واتجيب لمملكتي هاذا الذنب لكبير؟ انتا عدلتلي شي خاسر ما كان يالتك اتعدلولي. ");
INSERT INTO mey_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","وسول أبيمالك النبي إبراهيم: اشخلاك اتعدل هاذا ؟ ");
INSERT INTO mey_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","وڮالّو النبي إبراهيم: آنا عدلت ذا اللي عدلت بيهلي شكيت اعلن هاذي لبليدة ما فيها حد خايف من مولانا، وخفتكم تكتلوني اعلى أساس اعيالي. ");
INSERT INTO mey_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","وفلحقيقية هي اختي منت بويَ ولا هي منت أمي واتعرست امعاها. ");
INSERT INTO mey_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","وإلين ادعاني مولانا اياك نمشي عن دار بويَ، ڮتلها: بل امنين نمشو ڮولي اعلني خوك واتعودي عدلتيلي غاية اكبيرة. ");
INSERT INTO mey_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","واڮبظ أبيمالك اغنم وابڮر واعبيد واخدم واعطاهم للنبي إبراهيم، ورجعلو سارة اعيالو. ");
INSERT INTO mey_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","وڮال أبيمالك: هاذي ارضي ڮدامك واسكن بل امنين تبغي فيها. ");
INSERT INTO mey_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","وڮال لسارة: اراني اعطيت لخوك ألف ڮطعة من الفظة . انبرئك بيها من لإساءة ڮدام الناس اللي امعاك، وانتي بريئة ڮدام كل واحد. وابهاذي الطريڮة اتعود رجعتلك كرامتك. ");
INSERT INTO mey_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","واطلب النبي إبراهيم مولانا اياك يشفي أبيمالك. وابرات اعيالو وخدمو ");
INSERT INTO mey_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","بيهلي مولانا ابلا اعيال وكل اخدم أبيمالك بلعڮار بسبب سارة اعيال النبي إبراهيم. ");
INSERT INTO mey_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","وعاڮب هاذي لحداث انعم الله تعالى اعلى سارة واعطاها ذا اللي وعدها بيه. ");
INSERT INTO mey_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","وحملت سارة وابرات اعلى اطفيل لإبراهيم فنفس الوقت اللي ڮط ڮالّو مولانا. وكان النبي إبراهيم فذا الوقت مستكهل حته. ");
INSERT INTO mey_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","وڮام النبي إبراهيم وسما اطفيلو اللي اجبر من سارة إسحاق. ");
INSERT INTO mey_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","وڮام زيّنو فاليوم الثامن كيف ما اطلب مولانا. ");
INSERT INTO mey_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ووقت اخلاڮة إسحاق كان النبي إبراهيم عندو من لعمر 100 سنة. ");
INSERT INTO mey_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","وڮالت سارة: آنا ظحكني مولانا. وكل الناس اللي تسمع ذي اللي اخلڮ يظحكو هوما املي. ");
INSERT INTO mey_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","وڮالت سارة املي: من كان يڮد يڮول للنبي إبراهيم اعلن سارة لاهي اترظع أولاد؟ واراعيني آنا ابريتلو اعلى اطفيل فاستكهيلو. ");
INSERT INTO mey_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","واكبر إسحاق وانفطم وعدل النبي إبراهيم وقت فطيم إسحاق ندوية اكبيرة. ");
INSERT INTO mey_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","وفواحد من انهارات شافت سارة اعلن إسماعيل ول هاجر المصرية يجوق فإسحاق. ");
INSERT INTO mey_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","وڮالت سارة للنبي إبراهيم: صوع هاذي الخادم هي وولها بيهلي ول هاذي الخادم ماني ڮابلتو يورث امع ولي إسحاق. ");
INSERT INTO mey_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ولا ازيان هاذا عند النبي إبراهيم اعلى أساس ولو إسماعيل. ");
INSERT INTO mey_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","وڮال مولانا للنبي إبراهيم : لا تنفڮع من امردة الطفيل وأمه. واسمع لكلام سارة وعدل ذا اللي ڮاتلك بيهلي من إسحاق اتعود لك ذرية. ");
INSERT INTO mey_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ولاهي نجعل من ول الخادم املي أمة اكبيرة بيهلي هو من ذريتك. ");
INSERT INTO mey_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","وانهار من غد ڮام النبي إبراهيم امع الصباح واڮبظ شي من امبورو وڮربة ماء واعطاهم لهاجر ودارهم اعلى اكتافها وصاعها هي امع اطفيلها. وڮيمت ماشة وذهبت فخلوات بئر السبع. ");
INSERT INTO mey_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","وإلين افرق اعليها ماء لڮربة، طرحت الطفيل تحت وحدة من الصدرايات. ");
INSERT INTO mey_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","وڮعدت امڮابل 100 متر ڮدامو بيهلي ڮالت: ما نبغي نحظر الموت اطفيلي . وڮعدت تزڮي وعادت تبكي. ");
INSERT INTO mey_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","واسمع مولانا بكي الطفيل، وفذا عيط ملاك مولانا لهاجر من السما وڮالها: انتي اشفاڮعك يا هاجر؟ لا تخافي بيهلي مولانا اسمع بكي الطفيل من لبليدة اللي فيها. ");
INSERT INTO mey_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ڮومي ورفديه وضميه شورك. بيهلي لاهي انعدلو أمة اكبيرة. ");
INSERT INTO mey_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","وافتح مولانا عينين هاجر ونعتلها حاسي من الماء. وامشات واملات لڮربة واسڮات الطفيل. ");
INSERT INTO mey_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","وكان مولانا امع الطفيل. وإلين اكبر إسماعيل، اسكن فخلوات فاران وعاد اخباري فارماية السهم. ");
INSERT INTO mey_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","وعرستو أمو امع امرة مصرية. ");
INSERT INTO mey_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","وفذا الوقت ڮال أبيمالك وقائد جيشو فيكول للنبي إبراهيم: نحنا لاحظنا اعلن مولانا امعاك فكل شي اتعدلو ، ");
INSERT INTO mey_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","واندورك ظرك تحلفلي اعلى مولانا اعلنك مانك لاهي تغدر بيَّ ولا تغدر بنسلي ولا أولادي، واحلفلي اعلنك لاهي تعرف شي لشعبي اللي اتغربت بينهم كيفما آنا احسنت اعليك. ");
INSERT INTO mey_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","وڮال النبي إبراهيم: راني حالفلك . ");
INSERT INTO mey_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","وعاتب النبي إبراهيم أبيمالك اعلى أساس الحاسي اللي ڮبظوها اعبيد أبيمالك بالقوة. ");
INSERT INTO mey_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","وڮال أبيمالك: آنا ما نعرف من اڮبظ هاذا الحاسي، وانتا املي ما ڮلتلي من اڮبظها. وأول مرة نسمع بذا هو اليوم. ");
INSERT INTO mey_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","وفذا اعطا النبي إبراهيم لأبيمالك اغنم وابڮر واڮطع كلهم امع لوخر عهد. ");
INSERT INTO mey_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","وعزل النبي إبراهيم اسبع انعاج من غنمو اعلى زر. ");
INSERT INTO mey_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","وڮالّو أبيمالك: شنهي الغاية من اعزيل هاذو اسبع انعاج وحدهم؟ ");
INSERT INTO mey_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","وڮالّو النبي إبراهيم: هاذو اسبع انعاج انڮدمها بين ايديك تشهد اعلني آنا هو اللي احفرت هاذي الحاسي. ");
INSERT INTO mey_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ولهاذا السبب سما هاذي لبليدة بئر السبع اللي معناها حاسي الحلفة. بيهلي أبيمالك والنبي إبراهيم كل واحد منهم احلف فم. ");
INSERT INTO mey_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","وبهاذي الطريقة ڮطعو لأثنين عهد امبيناتهم فبئر السبع. ومن فم ڮام أبيمالك وفيكول قائد جيشو ورجعو شور ارض الفلشطيميين. ");
INSERT INTO mey_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","واغرس النبي إبراهيم نوع من الصدر كيف الڮنات فبئر السبع وصلى فم لله تعالى للإله اللي كان موجود سابڮ كل شي. ");
INSERT INTO mey_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","واسكن النبي إبراهيم فارض الفلشطيميين ياسر من الزمن. ");
INSERT INTO mey_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","وبعد يلين اسكن النبي إبراهيم فارض الفلشطيميين، ڮام مولانا وأمتحن النبي إبراهيم وعيطلو: يا إبراهيم ! وڮال النبي إبراهيم: اراعيني يا مولانا. ");
INSERT INTO mey_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","وڮال مولانا للنبي إبراهيم: اڮبظ ولك إسحاق اللي امعاك واللي تبغي، وامشي شور ارض المُريا، وذبحو فم، وحرڮو، وڮدمو كيفت قربان اعلى وحدة من ذوك لكدا اللي لاهي انعتلك. ");
INSERT INTO mey_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","وانهار من غد اوعا النبي إبراهيم امع الصباح واحزم اعلى احمارو، وامشا امعاه بإثنين من اعبيدو وامعاهم ولو إسحاق، وجهز لحطب اياك يحرڮ اعليه القربان، وامشا اعلى جيهة لبليدة اللي ڮالّو مولانا. ");
INSERT INTO mey_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","وانهار الثالث رڮب النبي إبراهيم وجهو وشاف لبليدة اللي ڮالّو مولانا من ابعيد. ");
INSERT INTO mey_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","وڮال النبي إبراهيم للعبيد اللي امعاه: ابڮاو هون امع لحمار اياك نمشي آنا امع الطفيل وانصلو لمولانا، ومن فم نرجعولكم. ");
INSERT INTO mey_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","وڮام النبي إبراهيم ورفّد إسحاق لحطب، وارفد النبي إبراهيم مشعل النار والموس، وامشاو فبلد. ");
INSERT INTO mey_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","وڮال إسحاق لبوه النبي إبراهيم: يا بويَ! وڮالّو النبي إبراهيم: اراعيني يا ولي. وڮالّو: وينهو لخروف اللي لاهي ينحرڮ كيفت قربان؟ بيهلي إسحاق شاف النبي إبراهيم عندو النار والموس يغير ما شاف لخروف. ");
INSERT INTO mey_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","وڮال النبي إبراهيم لإسحاق: مولانا لاهي يدبر لخروف اللي لاهي ينحرڮ كيف قربان، لا يشطنك شي. وواصلو مشيهم فبلد. ");
INSERT INTO mey_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","وإلين لحڮو لبليدة اللي ڮال مولانا للنبي إبراهيم، ڮام النبي إبراهيم وابنا فم مذبح، واجمع لحطب، وكتف النبي إبراهيم ولو إسحاق ودارو فوڮ المذبح فوڮ لحطب. ");
INSERT INTO mey_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ومد النبي إبراهيم ايدو واڮبظ الموس اياك يذبح ولو إسحاق. ");
INSERT INTO mey_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","وفذا عيطلو ملاك الله تعالى من السما: إبراهيم إبراهيم! وڮال النبي إبراهيم للملاك: اراعيني. ");
INSERT INTO mey_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","وڮال الملاك للنبي إبراهيم: لا اترڮب ايدك اعلى الطفيل، ولا اتعدلّو أي شي. آنا ظرك اعرفت اعلنك خايف من مولانا، ولا ابخلت ابولك الوحيد اعلى مولانا. ");
INSERT INTO mey_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","وخرص النبي إبراهيم اوراه وشاف كبش متعلڮ باعراش الصدر. وڮام ڮاسو وجابو وذبحو وحرڮو القربان بل ولو. ");
INSERT INTO mey_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","وسما النبي إبراهيم ذيك لبليدة باسم يَهْوَه يَرأَه اللي معناه الله تعالى يدبر. ولهاذا السبب ينڮال اليوم: فكدية الله تعالى يدبر. ");
INSERT INTO mey_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","وعيط ملاك الله تعالى للنبي إبراهيم من السما مرة اخرا ");
INSERT INTO mey_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","وڮال: راعيني نحلفلك بيكلي عدلت ذا اللي اطلبت منك ولا احكمت عني ولك الوحيد . ");
INSERT INTO mey_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","لذاك لاهي انباركك وانكثر ذريتك ويعود عددهم كيفت انجوم السما وكيفت احصي التراب لبحر، ولاهي تورث ذريتك مدن اعدائها. ");
INSERT INTO mey_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","وبذريتك تتبارك جميع أُمم لارض بيك اللي اسمعتلي. ");
INSERT INTO mey_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","وعاڮب ذاك ارجع النبي إبراهيم شور اعبيدو لأثنين ورجعو كاملين شور بئر السبع بل امنين ساكن النبي إبراهيم. ");
INSERT INTO mey_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","وانڮال للنبي إبراهيم عاڮب يلين خلڮت هاذو لمور: اراعيها مِلْكَةُ خلڮولها أولاد لخوك ناحور: ");
INSERT INTO mey_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","عوصا هو لبكر وخوه بوزا وقموئيل بو أرام ");
INSERT INTO mey_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","وكاسد وحزواَ وفلداش ويدلاف وبتوئيل . ");
INSERT INTO mey_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","واخلڮ لبتوئيل رفقة. هاذو الثمانية خلاتهم مِلْكَةُ لناحور خو النبي إبراهيم. ");
INSERT INTO mey_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","واملي خلاتلو خادمو اللي اسمها رؤومة: طابح وجاحم وتاحش ومعكة. ");
INSERT INTO mey_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","وعاشت سارة 127 سنة من لعمر. ");
INSERT INTO mey_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","وماتت فقرية حبرون فارض كنعان. وجا النبي إبراهيم امتكدر اياك ينوح اعلى سارة. ");
INSERT INTO mey_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","وإلين ڮام النبي إبراهيم من ڮدام جثمان سارة ڮال للحيثيين: ");
INSERT INTO mey_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","آنا خاطر وضيف عندكم وطالبكم تعطوني اقبر ندفن فيه اعيالي اللي ماتت. ");
INSERT INTO mey_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","وڮالولو الحيثيين: ");
INSERT INTO mey_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","اسمع يا شيخنا انتا مولانا عدلك زعيم بينا، اڮبظ تدفن اعيالك فازين اقبورنا، ما فينا حد لاهي يحكمك عن تدفن اعيالك فقبرو. ");
INSERT INTO mey_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","وڮام النبي إبراهيم اركع ڮدام الحيثيين أهل لبلاد يشكرهم. ");
INSERT INTO mey_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","وڮالهم النبي إبراهيم: إلى عدتو تبغوني اصا ندفن اعيالي، فاسمعوني واتوسطولي فعفرون ول صوحر ");
INSERT INTO mey_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","اياك يبيعلي امغارة المكفيلة اللي يملك واللي اعلى زر احريثتو، ويبيعهالي بسعرها كامل اياك انعدلها مدفنلي. ");
INSERT INTO mey_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","وفذا الوقت كان عفرون الحيثي ڮاعد امع اجماعتو وڮال للنبي إبراهيم ڮدام كل الحيثيين اللي اجتمعو عند بوابة لمدينة: ");
INSERT INTO mey_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","لا يا شيخي اسمعلي، لاهي نعطيك احريثتي ولمغارة اللي فيه هدية مني لك. وشعبي شاهد اعلى ذا، وادفن فيها اعيالك. ");
INSERT INTO mey_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","واركع النبي إبراهيم يشكر الحيثيين مرة اخرا. ");
INSERT INTO mey_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","وڮال النبي إبراهيم لعفرون ڮدام الحيثيين: حڮلا اسمعني، آنا نبغي ندفع صوڮ لحريثة واڮبل مني هاذا اياك انڮد ندفن اعيالي فيه. ");
INSERT INTO mey_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","وجاوبو عفرون وڮالّو: ");
INSERT INTO mey_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","اسمعني يا شيخي، هاذي لارض قيمتها 5 كيلوات من الفظة، وهاذا لمبلغ بلا قيمة بيني وبينك، وادفن اعيالك. ");
INSERT INTO mey_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","واڮبل النبي إبراهيم لمبلغ اللي اعرض اعليه عفرون واوزن النبي إبراهيم لعفرون 5 كيلوات من الفظة ڮدام الحيثيين حسب الوزنة اللي متعارف اعليها عند تجارهم. ");
INSERT INTO mey_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","وصبحت احريثة عفرون اللي فالمكفيلة اللي اڮريب من ممرا ولمغارة اللي فيها وكل الصدر اللي لحريثة ");
INSERT INTO mey_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","للنبي إبراهيم وهاذا اشهد اعليه كل الحيثيين اللي اجتمعو عند بوابة لمدينة. ");
INSERT INTO mey_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","وعاڮب ذاك ڮام النبي إبراهيم وادفن اعيالو سارة فامغارة المكفيلة اڮريب من ممرا اللي هي حبرون فابلاد كنعان. ");
INSERT INTO mey_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","واملك النبي إبراهيم من الحيثيين لحريثة ولمغارة اللي فيها وعادو مدفنلو. ");
INSERT INTO mey_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","وعاڮب فترة من الزمن استكهل النبي إبراهيم حته وباركو الله تعالى فكل شي. ");
INSERT INTO mey_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","وڮال النبي إبراهيم لشيخ اعبيدو واللي هو مسؤول عن كل شي فدار النبي إبراهيم: دير ايدك تحت ڮايمتي، ");
INSERT INTO mey_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","واحلفلي اعلى الله تعالى إله السما ولارض اعلنك ما اتعرس لولي أي امرة من أهل كنعان اللي آنا عايش امبيناتهم. ");
INSERT INTO mey_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","وتمشي شور بلدي وفخظي وتڮبظ امرة منهم لولي إسحاق. ");
INSERT INTO mey_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","وڮال لعبد للنبي إبراهيم: وإلى عادت لمرة اللي لاهي نڮبظ لإسحاق ما تبغي تمشي شور هاذي لارض ، وفذي الحالة مندرا يكانك تبغيني انجيب إسحاق للبليدة اللي انتا جاي منها؟ ");
INSERT INTO mey_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","وڮالّو النبي إبراهيم: عسك من اترجع ولي لفم. ");
INSERT INTO mey_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","الله تعالى إله السما اللي اڮبظني من دار بويَ ومن وطني وتكلم امعايَ واحلفلي وڮالّي: اندور نعطي هاذي لارض لنسلك. يدور يمشي ڮدامك ملاك اياك تڮبظ امرة لولي من ارض أهلي. ");
INSERT INTO mey_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","وإلين ترفض لمرة تمشي امعاك، اتعود انتا فهاذي الحالة عدلت اللي احلفتلي اعليه. يغير لا اترجع ولي لذيك لارض. ");
INSERT INTO mey_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ودار لعبد ايدو تحت ڮايمة النبي إبراهيم واحلف لشيخو اعلنو لاهي يعدل ذا اللي احلفلو اعليه. ");
INSERT INTO mey_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","واڮبظ لعبد 10 اجمال من حيوان النبي إبراهيم ورفّد اجمال من كل الخير اللي عند شيخو. وامشا واعد أرام النهرين لبليدة اللي فيها ناحور. ");
INSERT INTO mey_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","وإلين ڮرب، برك اجمال خارج لمدينة احذا حاسي من الماء. وكان هاذا امع مغرب الشمس، وذا كان وقت وخيظ لعليات اياك يوردو فالحاسي. ");
INSERT INTO mey_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","واطلب لعبد وڮال: يا الله تعالى إله شيخي النبي إبراهيم، يسرلي امري اليوم واحسن اعلى شيخي النبي إبراهيم . ");
INSERT INTO mey_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","آنا اراعيني واڮف عند الحاسي ولعليات هاذي لمدينة لاهي يوخظو يوردو. ");
INSERT INTO mey_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ولمرة اللي انڮولّها: نزلي ڮدرتك اياك نشرب، وتسڮيني وتسڮي اجمالي، اتعود هي لمرة اللي اخترت لعبدك إسحاق. وبهاذي الطريقة انعود اعرفت اعلنك احسنت اعلى شيخي النبي إبراهيم. ");
INSERT INTO mey_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","وسابڮ يوفي عبد النبي إبراهيم دعاؤو، جات رفقة منت بتؤئيل ول مِلْكَةُ اعيال ناحور خو النبي إبراهيم وڮدرتها اعلى اكتفها. ");
INSERT INTO mey_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","وكانت اشويبة ازوينة حته واعزيبة ما ڮط مسها راجل. وڮاست ظاية الماء واملات ڮدرتها وڮيمت ماشة. ");
INSERT INTO mey_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","وادفع عبد النبي إبراهيم شورها وڮالها: اسڮيني اشوي من الماء من ڮدرتك. ");
INSERT INTO mey_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","وڮالتلو رفقة: اشرب يا شيخي ونزلت ڮدرتها بالعجلة اعلى ايديها واسڮاتو. ");
INSERT INTO mey_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","وعاڮب يلين اسڮاتو ڮالتلو: لاهي انجيب املي الماء لاجمالك اياك نسڮيهم. ");
INSERT INTO mey_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","وصبت ڮدرتها بالعجلة فحوظ الماء ودفعت شور حاسي وتورد الماء يلين اسڮات اجمالو كاملين. ");
INSERT INTO mey_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","وكان عبد النبي إبراهيم امراقبها فذا كامل اللي اتعدل من دون كلام اياك يعرف يكانها هي اللي اختار الله تعالى لإسحاق وللا ابدي. ");
INSERT INTO mey_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","وإلين شربت اجمال، اڮبظ لعبد ووخظ حزمة من الذهب وزنها اڮريب من 6 اڮرامات ووخظ املي أسوارين من الذهب وزنهم 120 اڮرام. ");
INSERT INTO mey_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","وسول لعبد رفقة وڮالها: انتي منت من؟ ڮوليلي مندرا يكانا انڮدو نجبرو ابليدة انباتو فيها فدار بوك؟ ");
INSERT INTO mey_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","وڮالتلو رفقة: آنا بويَ هو بتؤئيل ول مِلْكَةُ وناحور. ");
INSERT INTO mey_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","وڮالتلو املي: عندنا لحشيش وياسر من لعلف وعندنا املي بل امنين اتباتو فيه. ");
INSERT INTO mey_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","وفذا اركع واسجد لعبد لله تعالى يشكرو. ");
INSERT INTO mey_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","وڮال: اتبارك الله تعالى إله شيخي النبي إبراهيم اللي ما امنع كرمه ونزاهتو عن النبي إبراهيم. وڮال لعبد: الله تعالى سهداني اعلى دار اخوت شيخي النبي إبراهيم. ");
INSERT INTO mey_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ودفعت رفقة شور دار أمها وردت اعليها اللي اخلڮ. ");
INSERT INTO mey_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","وكان عند رفقة خو ينڮالو لابان. وڮام لابان وامشا واخظ شور لعبد اللي عند الظاية ");
INSERT INTO mey_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","بيهلي فات شاف حزمة الذهب وأسوارين فايدين اختو رفقة، واسمع املي اكلام رفقة عن لعبد اللي اجبرت، واجبر لابان لعبد واڮف احذا اجمالو اڮريب من الظاية. ");
INSERT INTO mey_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","وڮال لابان للعبد: اتفضل انتا امباركك الله تعالى. اعلاش انتا واڮف الڮدام ؟ آنا جهزت الدار وجهزت املي ابليدة يستراحو فيها اجمالك. ");
INSERT INTO mey_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","وڮاس لعبد الدار وانزل لابان وعبيدو اللي كانو رافدين اجمالو واعطاو لاجمال لعبد لحشيش ولعلف، وجابولو شي من الماء هو واللي كان امعاه اياك يغسلو ڮرعيهم. ");
INSERT INTO mey_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","وطرحو ڮدامو اطعام اياك يوكل ، يغير سابڮ يوكل ڮال: ماني لاهي نوكل سابڮ ما ڮتلكم اللي عندي. وڮال لابان لعبد النبي إبراهيم: اتفضل ڮول اللي عندك. ");
INSERT INTO mey_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","وڮال للابان: آنا عبد للنبي إبراهيم. ");
INSERT INTO mey_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","والله تعالى بارك حته شيخي النبي إبراهيم وعاد زعيم. والله تعالى اعطاه لغنم ولبڮر والفظة والذهب ولعبيد ولخدم والبل ولحمير. ");
INSERT INTO mey_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","وخلاتلو سارة اطفيل عاڮب ما استكهلت واعطاه بوه النبي إبراهيم كل أملاكو. ");
INSERT INTO mey_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","واحلفلي شيخي النبي إبراهيم وڮالّي: لا اتعرس لولي إسحاق أي امرة من الكنعانيين اللي آنا ساكن فبلادهم. ");
INSERT INTO mey_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","وڮالّي: ڮيس أهل بويَ وعايلتي واڮبظ امرة لولي. ");
INSERT INTO mey_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","وڮلت لشيخي النبي إبراهيم: وفحالة لمرة اللي لاهي نجبر ابات تمشي امعايَ شور كنعان؟ ");
INSERT INTO mey_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","وڮالّي النبي إبراهيم: الله تعالى اللي امشيت آنا اعلى اطريڮو يدور يمشي ملاكو ويوفقك فمهمتك اياك تڮبظ اعيال لولي إسحاق من عائلتي ومن أهل بويَ. ");
INSERT INTO mey_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","وڮالّي شيخي النبي إبراهيم: وإلى جيت لأهلي ورفضو يعطوهالك، فهاذي الحالة نطلصك من الحلفة اللي احلفتلي اعليها. ");
INSERT INTO mey_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","وڮست اليوم الحاسي وإلين الحڮتها اطلبت الله تعالى وڮتلو: يا الله تعالى إله شيخي النبي إبراهيم، آنا طالبك اتوفقني فاللي اعلى أساسو آنا سافرت. ");
INSERT INTO mey_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","آنا اراعيني واڮف ڮدام الحاسي. اندورك تجعل الشويبة اللي لاهي اتجي اياك تورد الماء واللي يلين نطلب منها: تسڮيني من الماء، ");
INSERT INTO mey_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","واتڮولّي: اشرب انتا وآنا لاهي نسڮي اجمالك املي. اتعود هي الشويبة اللي اختارها الله تعالى لإسحاق ول شيخي. ");
INSERT INTO mey_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","والوقت اللي كنت نطلب فيه مولانا واناجي فيه نفسي، فذا شفت رفقة جاية ورافدة ڮدرة اعلى اكتافها ، وڮاست الحاسي تورد الماء وڮتلها: طالبك تسڮيني. ");
INSERT INTO mey_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","ودفعت وطرحت ڮدرتها وڮاتلي: اشرب انتا ولاهي نسڮي املي اجمالك. ");
INSERT INTO mey_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","وسولتها: منت من انتي؟ وڮاتلي اعلنها منت بتؤئيل ول ناحور اللي خلاتلو مِلْكَةُ. واڮبظت ودرت الخاتم فاخنافرها والسوار فايديها. ");
INSERT INTO mey_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","وڮمت واسجدت وباركت الله تعالى إله شيخي النبي إبراهيم اللي سهداني شور الطريڮ لمسڮمة اياك نڮبظ منت خو النبي إبراهيم لولو إسحاق. ");
INSERT INTO mey_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","وظرك ڮولولي إلى عدتو لاهي اتعدلو ذي الغاية لشيخي النبي إبراهيم ، وللا طلصوني وخلوني انڮيم واعد ابليدة اخرا. ");
INSERT INTO mey_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","وڮالولو لابان هو وبتؤئيل: ذي لمردة جات من عند الله تعالى ونحنا ما انڮدو انڮولولك اهيه وللا ابدي. ");
INSERT INTO mey_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","رفقة اراعيها ڮدامك. اڮبظها وامشي بيها اياك اتعود اعيال لأول شيخك النبي إبراهيم كيفت ماراد الله تعالى. ");
INSERT INTO mey_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","وإلين اسمع عبد النبي إبراهيم اكلامهم، ابرك اعلى التراب ساجد لله تعالى. ");
INSERT INTO mey_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ووخظ لعبد اديار من الفظة والذهب ولباس واعطاهم لرفقة واعطا املي لخوها وأمها هدايا غالية. ");
INSERT INTO mey_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","وكال واشرب هو ورجالتو وباتو ليلتهم فم. وإلين اوعاو امع الصباح ڮالّهم: اعطوني اطريڮ اياك نرجع شور شيخي النبي إبراهيم. ");
INSERT INTO mey_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","وڮالولو خو رفقة وأمها: خلي رفقة تبڮي امعانا 10 أيام وللا ذاك ومن فم تمشي. ");
INSERT INTO mey_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","وڮالّهم لعبد: لا تحصروني ، الله تعالى سڮملي اطريڮي ، خلوني نمشي شور شيخي النبي إبراهيم. ");
INSERT INTO mey_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","وڮالولو: لاهي انعيطو لرفقة وانسولوها عن رأيها. ");
INSERT INTO mey_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","وعيطو لرفقة وسولوها: تبغي تمشي امع ذا الراجل؟ وڮالتلهم: اهيه نبغي نمشي. ");
INSERT INTO mey_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","وخلاو رفقة تمشي وامشات امعاها امرظعتها وعبد النبي إبراهيم ورجالتو. ");
INSERT INTO mey_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","وباركو رفقة وڮالولها: اعليك بركة مولانا. انتي ختنا عدلي ياسر من الذرية اياك اتعود ألاف مؤلفة وتورث ذريتك مدن اعدائها. ");
INSERT INTO mey_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","وڮامت رفقة واخدمها وركبو اجمال وامشاو اورا عبد النبي إبراهيم. وڮيم لعبد برفقة ماشي بيها. ");
INSERT INTO mey_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","وفذاك الوقت كان إسحاق اللي ساكن فالنقب ارجع من الطريڮ اللي ينڮالها حاسي الحي اللي يراعي فيَّ. ");
INSERT INTO mey_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","وفدحميساية امشا واعد الخلوات اياك يتخمم . فذا شاف اجمال جاية . ");
INSERT INTO mey_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ورفعت رفقة هي املي عينها وشافت إسحاق، ونڮزت عن اجملها. ");
INSERT INTO mey_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","وسولت عبد النبي إبراهيم وڮاتلو: منهو هاذا الراجل اللي ماشي فالحرث اياك يتلڮالنا ؟ وڮالها لعبد: هاذا شيخي إسحاق. وڮبظت حوليها واتحجبت عنو. ");
INSERT INTO mey_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","وعاڮب ذاك رد لعبد اعلى إسحاق ذا كامل اللي اخلڮ. ");
INSERT INTO mey_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ودخل إسحاق رفقة شور خيمة أمو سارة واتعرس امعاها وابغاها حته واتعزا بيها عاڮب موت أمو سارة. ");
INSERT INTO mey_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","وعاڮب ذا ڮام النبي إبراهيم واتعرس امع امرة اسمها قطورة. ");
INSERT INTO mey_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","وخلاتلو زمران ويقشان ومدان ومديان ويشباق وشوحا. ");
INSERT INTO mey_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","وخلا يقشان شبا ودادان ، وأولاد دادان هوما الأشوريم وللطوشيم ولأميم. ");
INSERT INTO mey_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","وأولاد مديان هوما عيفة وعفر وحنوك وأبيداع وألدعة ، وهاذو كاملين جايين من ذرية قطورة. ");
INSERT INTO mey_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","وورّث النبي إبراهيم للنبي إسحاق كل أملاكو. ");
INSERT INTO mey_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","واعطا لولادو من خدمو هدايا وقت محدو كان حي، وارسلهم اعلى جيهة الشرق ابعيد عن ولو إسحاق. ");
INSERT INTO mey_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","وعاش النبي إبراهيم 175 سنة. ");
INSERT INTO mey_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ومات النبي إبراهيم بشيبة صالحة وانضم إلى اسلافو. ");
INSERT INTO mey_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ودفنو إسحاق وإسماعيل بوهم النبي إبراهيم فامغارة المكفيلة فحرث عفرون ول صوحر الحيثي اللي احذا ممرا. ");
INSERT INTO mey_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","وهو الحرث اللي كط اشرا النبي إبراهيم من الحيثيين وفيه اندفنو سارة والنبي إبراهيم فزر بعض. ");
INSERT INTO mey_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","وعاڮب موت النبي إبراهيم بارك مولانا إسحاق ولو واسكن إسحاق عند الحاسي الحي اللي يراعي فيَّ. ");
INSERT INTO mey_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","وهاذا سجل أولاد إسماعيل ول النبي إبراهيم اللي خلاتو هاجر المصرية خادم سارة لإبراهيم. ");
INSERT INTO mey_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","وهاذي أسامي أولاد إسماعيل مرتبة حسب اخلاڮتهم: نبايوت هو بكر إسماعيل وقيدار وأدبئيل ومبسام ");
INSERT INTO mey_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ومشماع ودومة ومسا ");
INSERT INTO mey_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","وحدارُ وتيماء ويطور ونافيش وقدمة. ");
INSERT INTO mey_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","وهاذو هوما أسامي أولاد إسماعيل وعادو الشيوخ للثاني عشر قبيلة فبليدات مختلفة. ");
INSERT INTO mey_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","وعاش إسماعيل 137 سنة ومات وانضم شور اسلافو. ");
INSERT INTO mey_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","واسكن نسلو فلبليدة اللي امبين حويلة وشور اعلى حدود مصر اعلى الزر الشرقي من مدينة أشور، وكانو اعلى عداوة امع أولاد عمهم. ");
INSERT INTO mey_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","وهاذا سجل أولاد النبي إسحاق: إبراهيم خلا إسحاق، ");
INSERT INTO mey_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","وكان النبي إسحاق عندو 40 سنة فالوقت اللي اتعرس فيه امع رفقة منت بتؤئيل لأرامي اللي جاي من واد أرام، وكانت خت لابان لأرامي. ");
INSERT INTO mey_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","وكانت رفقة اعيال النبي إسحاق عاڮر. وڮام النبي إسحاق واطلبلها الله تعالى اياك تجبر الذرية. واستجابلو الله تعالى وحملت رفقة. ");
INSERT INTO mey_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","وادايڮو أولادها وهوما مزالو فكرشها، وفذا ڮالت رفقة: اعلاش يخلڮلي ذا؟ وامشات رفقة اتصلي واتسول الله تعالى عن السبب. ");
INSERT INTO mey_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","وڮالها الله تعالى: فكرشك أُمتين ويتفارڮو من هاذو لأُمتين شعبين ، واحد منهم يڮلب لوخر ، وولك لكبير يستعبدو الصغير. ");
INSERT INTO mey_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","وإلين الحڮ وقت بريها ابرات رفقة اعلى اتواما. ");
INSERT INTO mey_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","واخلڮ لأول احمر واملان من ازغب. وسماوه عيسو اللي معناه لمزغب. ");
INSERT INTO mey_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","وعاڮب اشواي اخلڮ خوه، وهو كارد اكراع عيسو. وسماوه يعقوب اللي معناه لمخادع . ووقت اخلاڮتهم كان النبي إسحاق عندو 60 سنة. ");
INSERT INTO mey_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","وكبرو التركة وكان عيسو اخباري فالصيد ويبغي الخلوات. ويعقوب كان عكسو بارد ويبغي لڮعاد فالخيام. ");
INSERT INTO mey_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","وكان عيسو هو لمفضل عند النبي إسحاق بيهلي يجبلو من صيدو. وكانت رفقة غالي اعليها يعقوب. ");
INSERT INTO mey_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","وفيوم من لأيام يلين ارجع عيسو من الخلوات فتران، اجبر يعقوب انصب اطعام زين. ");
INSERT INTO mey_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","وڮال عيسو ليعقوب: غديني من ذا الطعام لحمر. آنا ميت بيَّ الجوع. ولهاذا السبب عيسو اُسمّا أدوم اللي معناها لحمر كيف الطعام اللي كال . ");
INSERT INTO mey_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","وڮال يعقوب لعيسو: لاهي انغديك بشرط اعلنك اتبعيلي بكوريتك . ");
INSERT INTO mey_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","وڮال عيسو ليعقوب: اعلى ذي الحالة آنا لاهي نعڮب انموت بالتالي شنهي الفايدة من بكوريتي؟ ");
INSERT INTO mey_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","وڮالّو يعقوب: احلفلي ظرك . واحلفلو عيسو وبهاذي الطريڮة باع عيسو بكوريتو ليعقوب. ");
INSERT INTO mey_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","واعطا يعقوب لعيسو شي من امبورو ولعدس وكال عيسو واشرب وڮيم ماشي. وبهاذي الطريڮة احتقر عيسو فايدة لبكورية.");
ALTER TABLE mey_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
