﻿USE sofia;
DROP TABLE IF EXISTS sofia.meu_vpl;
CREATE TABLE meu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES meu_vpl WRITE;
INSERT INTO meu_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Matamana negana ai na Dirava ese guba bona tanobada e karadia. ");
INSERT INTO meu_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tanobada na asi oromana bona asi anina; dibura danu gadobada vada e gorua ahu. Bena Dirava laumana na gado kopina ai e loava. ");
INSERT INTO meu_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Dirava eto, Diari aine vara. Bena diari na e vara. ");
INSERT INTO meu_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Dirava ese diari e itaia, vada e namo; bena Dirava ese diari bona dibura e haridia. ");
INSERT INTO meu_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Dirava ese diari ladana e hatoa Dina; dibura ladana e hatoa Boi. Ado e rahi daba e rere, dina gini-gunana. ");
INSERT INTO meu_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Dirava ma eto, Ḡau ta aine vara gadobada daenai, ranu baine haridia. ");
INSERT INTO meu_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Bena Dirava ese ḡau ta e karaia, henu ranudia bona atai ranudia ihididia. Bena unu e vara toma. ");
INSERT INTO meu_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Dirava ese una ḡau ladana e hatoa Guba. Ado e rahi, daba e rere, dina iharuana. ");
INSERT INTO meu_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Dirava ma eto, Guba henunai e miamu ranudia na ae hahebou, gabu tamona ai, tano kaukauna baine hedinarai. Bena unu e vara toma. ");
INSERT INTO meu_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Dirava ese tano kaukauna ladana e hatoa Tanobada; bona ranu na edia gabu ai e hahebou ladadia e hato Davara. Dirava ese e itaia, vada e namo. ");
INSERT INTO meu_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Dirava ma eto, Tanobada ai rei aine vara, bona ava idau-idau mai nadinadidia, bona huahua audia danu mai huahuadia, huahua idau-idaudia mai nadinadidia. Bena unu e vara toma: ");
INSERT INTO meu_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","rei e vara tanobada ai, bona ava idau-idau mai nadinadidia, bona huahua audia mai huahuadia, huahua idau-idaudia mai nadinadidia. Dirava ese e itaia, vada e namo. ");
INSERT INTO meu_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ado e rahi, daba e rere, dina ihatoina. ");
INSERT INTO meu_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Dirava ma eto, Diari ae vara guba ai, dina bona hanuaboi bae haridia, bona toa ai baela, guitau bona lahara toadia, bona dina toadia, bona laḡani toadia. ");
INSERT INTO meu_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Guba ai bae diari, tanobada bae hadiaria. Bena unu e vara toma. ");
INSERT INTO meu_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Dirava ese diari badadia rua e kara: badana ese dina baine lohiaia, bona maraḡina ese hanuaboi baine lohiaia eto. Hisiu danu e kara. ");
INSERT INTO meu_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Dirava ese guba ai e atodia, tanobada bae hadiaria totona; ");
INSERT INTO meu_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","dina bona hanuaboi bae lohiadia bona diari bona dibura bae hididia totona. Dirava ese e itaia, vada e namo. ");
INSERT INTO meu_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ado e rahi, daba e rere, dina ihahanina. ");
INSERT INTO meu_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Dirava ma eto, Mauri ḡaudia momo davara ai ae vara, bona manu tanobada daenai ae roho guba henunai. ");
INSERT INTO meu_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Bena Dirava ese lakara-donodono bona rui bona davara ai e maurimu bona e reremu ḡaudia iboudiai e karadia, bona roho manudia iboudiai danu. Dirava ese e itaia, vada e namo. ");
INSERT INTO meu_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Bena Dirava ese e hanamodia, eto, Besemui ba havaradia, ba hutuma, davara idoidiai bae honu honu dae; manu danu bae vara rohoroho tanobada ai. ");
INSERT INTO meu_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ado e rahi, daba e rere, dina iha-imana. ");
INSERT INTO meu_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Dirava ma eto, Tanobada ese mauri ḡaudia idau-idau baine havaradia, boromakau, bona tano ai e raumu ḡaudia, bona tanobada boromadia idau-idau ta ta ena bese ai. Bena unu e vara toma. ");
INSERT INTO meu_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Bena Dirava ese tanobada boromadia idau-idau bona boromakau bona tano ai e raumu ḡaudia iboudiai e karadia, ta ta ena bese ena bese ai. Dirava ese e itaia, vada e namo. ");
INSERT INTO meu_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Bena Dirava ma eto, Taunimanima aina karaia, lau laulaugu bona lau heida-idagu; davara gwarumedia bona atai manudia bona boromakau bona tanobada idoinai tano ai e raumu ḡaudia iboudiai ia ese baine biagudia. ");
INSERT INTO meu_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Bena Dirava ese taunimanima e karaia, ia heida-idana, Dirava ida-idana e karaia: maruane bona hahine e karadia. ");
INSERT INTO meu_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Bena Dirava ese e hanamodia, eto, Besemui ba havaradia, ba hutuma; tanobada ba hahonua bona ba biagua; davara gwarumedia bona atai manudia bona mauri ḡaudia tanobada ai e loamu iboudiai ba biagudia. ");
INSERT INTO meu_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Dirava ma eto. A itaia, mai nadinadidia avadia bona mai huahuadia audia vada na henimui, amui aniani; ");
INSERT INTO meu_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","tanobada boromadia iboudiai danu, bona atai manudia iboudiai, bona mauri ḡaudia tanobada ai e loamu iboudiai, na ava raudia vada na henidia, adia aniani. Bena unu e vara toma. ");
INSERT INTO meu_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Dirava ese e kara ḡaudia iboudiai e itadia, nanamo heherea. Ado e rahi, daba e rere, dina ihatauratoina. ");
INSERT INTO meu_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Unuhetomana guba bona tanobada mai anidia vada e kara ḡuḡuru. ");
INSERT INTO meu_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Dina ihahituna ai, Dirava ese ena ḡaukara idoidiai e hadokodia: dina ihahituna ai ia ese ena ḡaukara iboudiai e ato diho, e laḡa ani. ");
INSERT INTO meu_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Bena Dirava ese dina ihahituna e hanamoa bona e hahelaḡaia: badina be una dina ai ena ḡaukara iboudiai e ato diho, e laḡa ani. ");
INSERT INTO meu_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Guba bona ikaradia herevadia bini: ihavaradia negana ai Dirava Iehova ese tanobada bona guba e karava dinana ai, ");
INSERT INTO meu_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","uda audia ta be tanobada ai do we miava, aniani avadia ta do se vara; badina be Dirava Iehova ese medu tanobada ai do se hadihoa, asi tauna danu tano ibiru-henina. ");
INSERT INTO meu_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","A varahu be tanobada amo eme dae, tano kopina idoinai vada eme hapariparia. ");
INSERT INTO meu_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Bena Dirava Iehova ese taunimanima tano ḡahuna amo e karaia, mauri laḡana ia uduna matudia ai e hahoho dobi, taunimanima na mauri tauna ai e halaoa. ");
INSERT INTO meu_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Dirava Iehova ese imea ta e karaia, ladana Eden, mairiveina kahana ai, bena vada e karaia tauna unuseni ai e atoa, baine noho. ");
INSERT INTO meu_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Dirava Iehova ese au danu tano ai e havaradia, ita-itadia bona ianidia nanamo audia iboudiai; mauri auna danu imea bogaraginai, namo bona dika idibaladia auna danu. ");
INSERT INTO meu_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Eden imeana amo sinavai ta e aru ela, imea e hapariparia; e aru parara, sinavai hani ai ela. ");
INSERT INTO meu_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ginigunana ladana na Pison; ia be havila tanona e arua heḡeḡe: una tano ai gold e davariamu, ");
INSERT INTO meu_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","gold namo-hereana; bedolak bona onuku nadidia danu unuseni ai. ");
INSERT INTO meu_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Sinavai iharuana ladana na Gihon: una sinavai be Etiopia tanona e arua heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Sinavai ihatoina ladana na Tigris: ia be Asuria tanona mairiveina kahana amo e aru Iaomu. Sinavai ihahanina na Eufrate. ");
INSERT INTO meu_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Dirava Iehova ese hari tau e abia, Eden imeana ai e atoa, ia ese baine biru henis bona baine reḡua. ");
INSERT INTO meu_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Dirava Iehova ese hari tau e haduaia, eto, Imea audia iboudiai huahuadia bavani, emu ura heḡereḡerena; ");
INSERT INTO meu_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","a namo bona dika idibalaidia auna huahuana una mo basio ania; badina be ia bavania dinana ai oi na ba mase vaitani. ");
INSERT INTO meu_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Dirava Iehova ma eto, Hari tau na sibona baine noho na dia namo; lau ese ia bamona aina karaia. ");
INSERT INTO meu_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Bena Dirava Iehova ese tano amo tanobada boromadia iboudiai e karadia, bona atai manudia iboudiai danu. Bena ia ese hari tau, Adam, vairanai e hakaudia, baine diba ia ese ladadia ede baine hato toma: mauri ḡaudia iboudiai ta ta Adam ese ladadia e hato. ");
INSERT INTO meu_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Taunabunai, Adam ese boromakau iboudiai ladadia e hato, bona atai manudia bona tanobada danu; a Adam na asi bamona ta ia baine durua. ");
INSERT INTO meu_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Bena Dirava Iehova ese Adam e hamahutaia hedavauhe. Bena ruduna turiana ta e abia lasi, turia gabuna be hidio ai e daia ahu. ");
INSERT INTO meu_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Bena Dirava Iehova ese Adam ena amo e abia lasi turiana na hahine ta e karalaia, Adam dekena e laohaia. ");
INSERT INTO meu_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Bena Adam eto, Ina na turiagu turiana bona hidiogu hidiona: ladana bae hatoa Hahine, badina be Tau ena amo vada e abia lasi. ");
INSERT INTO meu_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Badina bunai tau ese tamana sinana baine rakatanidia, adavana baine badinaia, raruosi na anidia tamona ai baela. ");
INSERT INTO meu_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Idia raruosi, Adam mai adavana ida, na asi edia riorio ḡaudia, to asie hemaraiva. ");
INSERT INTO meu_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Gaigai ena aonega ese Dirava Iehova e kara boromadia iboudiai edia aonega e hereadia. Ia ese hahine e nanadaia, eto, Momokani Dirava eto umui na imea audia ta huahuana basio ani a? ");
INSERT INTO meu_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Bena hahine ese gaigai e haere henia, eto, Imea audia huahuadia baia ani; ");
INSERT INTO meu_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","to Dirava eto “Imea bogaraginai e ginimu auna huahuana basio ania bona basio daua toho, ba mase na garina”. ");
INSERT INTO meu_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Gaigai ese hahine e hamaoroa, eto, Momokani, umui na basio mase: ");
INSERT INTO meu_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Dirava vada dibana raruosi bavania dinana ai na matamui bae papa, bena Dirava ida ba heḡereḡere, namo bona dika ba diba. ");
INSERT INTO meu_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Hahine ese e itaia, una au huahuana be aniani ḡauna namona, ita-itana danu namo, bona lalo-parara ihavarana ḡauna; bena ia ese e abia, adavana danu e henia, ia danu e ania. ");
INSERT INTO meu_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Bena raruosi matadia e papa, vada e diba idia na ḡaḡaedia mo nonoho; bena idia ese suke raudia e turi hebou, edia riorio ḡaudia e kara. ");
INSERT INTO meu_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Bena raruosi ese Dirava Iehova gadona e kamonai, ia na dina kerumana ai imea lalonai e loava; bena Adam mai adavana ida Dirava Iehova vairana amo e komu, imea audia muridiai. ");
INSERT INTO meu_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Bena Dirava Iehova ese Adam e boi henia, eto, Oi na edeseni ai? ");
INSERT INTO meu_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ia na e haere, eto, Gadomu imea lalonai na kamonai, bena vada na gari, badina be ḡaḡaegu mo na noho, taunabunai na komu. ");
INSERT INTO meu_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Dirava Iehova eto, Daika ese e hamaorumu oi na ḡaḡaemu mo noho? Lau na haduamu basio ania nato huahuana vada o ania a? ");
INSERT INTO meu_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adam e haere, eto, Vada o henigu baine bamogu hahinena ese una au huahuana e henigu, bena na ania. ");
INSERT INTO meu_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Bena Dirava Iehova ese hahine e gwau henia, eto, Ina na dahaka vada o karaia? Hahine na eto, Gaigai ese e koigu, bena na ania. ");
INSERT INTO meu_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Bena Dirava Iehova ese gaigai e gwau henia, eto, Unu vada o kara toma dainai, emu dika davana be boromakau iboudiai bona uda boromadia iboudiai edia dika davadia baine hereadia: kopamu ai do ba rau, tano ḡahuna bavania, emu mauri dinadia iboudiai. ");
INSERT INTO meu_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Lau ese oi bona hahine baina haheinai hehenimui, oi garamu bona ia garana danu baina haheinai hehenidia. Ia ese oi kwaramu baine huaria, bona oi ese ia aena geduna ba tutua. ");
INSERT INTO meu_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Hahine danu e gwau henia, eto, Emu rogorogo hisina lau ese baina habadaia; hisihisi ai ba mara, to adavamu ba ura henia, ia ese biagumu ai bainela. ");
INSERT INTO meu_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Adam danu e gwau henia, eto, Adavamu erena o kamonai, bena na haduamu basio ania nato huahuana vada o ania, una dainai tano vada baine dika oi bagumu ai. Tano anina bavania mai hekwarahimu ida emu mauri dinadia iboudiai. ");
INSERT INTO meu_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Au giniginidia bona ava ḡiniḡinidia danu tano ai bae vara oiemu ai. Tanobada avadia anidia do bavani. ");
INSERT INTO meu_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Vairamu varahuna ai bavaniani ela bona tano ba lou henia, badina be tano amo oma. Oi na tano ḡahuna: tano ḡahuna danu do ba lou henia. ");
INSERT INTO meu_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Bena Adam ese adavana ladana e hatoa Heva badina be ia na mauri taudia iboudiai sinadia. ");
INSERT INTO meu_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Bena Dirava Iehova ese boromakau kopidia amo hahedoki dabuadia e kara, Adam ena bona adavana Heva ena, raruosi e hadabualaidia. ");
INSERT INTO meu_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Bana Dirava Iehova eto, Taunimanima a itaia, ia na lau heḡereḡeregu ai vada ela, namo bona dika baine diba; readia ia ese imana ma baine toia roro, mauri auna huahuana baine abia, baine ania, bena baine mauri hanai-hanai. ");
INSERT INTO meu_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Taunabunai Dirava Iehova ese Moale imeana lalona amo e lulua lasi, tano amo e vara tanona baine biru henia. ");
INSERT INTO meu_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ia ese Adam e lulua lasi; bena Moale imeana mairiveina kahana ai kerubi e haginidia, bona lahi darena e atoa, una dare matana e hegiro hanaihanaiva, mauri auna ilao-henina dalana e laoa ahu. ");
INSERT INTO meu_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam na adavana Heva ida e eno bou: bena Heva e rogorogo, e mara, Kain e abia; eto, Tau ta Iehova ena amo vada name abia. ");
INSERT INTO meu_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ma e rogorogo lou, e mara, tadina Abel e abia. Abel na mamoe ireḡudia tauna a Kain na biru tauna. ");
INSERT INTO meu_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Nega ta ai Kain ese tano anidia e mailai, Iehova ena boubou ḡauna ai baine halaoa eto. ");
INSERT INTO meu_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel danu ena mamoe serina roboadia mai digaradia e mailaidia. Bena Iehova ese Abel ena boubou ḡauna e haḡerea, ");
INSERT INTO meu_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","a Kain ena boubou ḡauna se hagerea. Kain na e badu dikadika, bena vairana e huaia. ");
INSERT INTO meu_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","A Iehova ese Kain e gwau henia, eto, Badina be dahaka o badumu? Dahaka dainai vairamu o huaiamu? ");
INSERT INTO meu_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Boma kara namo, basinama abimu dae a? Basioma kara namo, kara havara be iduara badinai e narimumu; e ura henimumu, to oi ese ba hadarerea. ");
INSERT INTO meu_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Bena Kain ese tadina Abel e hereva henia, eto, Aitala uma. Bena raruosi na uma ai e nohova negana ai Kain ese tadina Abel e heatu henia, e alaia mase. ");
INSERT INTO meu_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Bena Iehova ese Kain e nanadaia, eto, Tadimu Abel be edeseni ai? Ia na e haere, eto, Lau na asi dibagu; be, lau na tadigu igimana tauna a? ");
INSERT INTO meu_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Iehova ma eto, Dahaka vada o karaia? Tadimu rarana gadona na tano amo vada e tai henigumu. ");
INSERT INTO meu_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Harihari ela, uduna e haḡaia tadimu rarana imamu amo e abia tanona ese baine hadikamu. ");
INSERT INTO meu_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Harihari ela, ba biru negadia ai na tano ese anina basine henimu. A oi na heau bona loa kava tauna ai do baola tanobada ai. ");
INSERT INTO meu_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Bena Kain ese Iehova e hamaoroa, eto, Egu dika davana na metau herea; egu haheauka basine heḡereḡere. ");
INSERT INTO meu_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","A laloa, oi ese hari dina ai tanobada kopina amo vada o lulugu oho, vairamu danu egu amo vada o hunia. Lau na heau bona loa kava taugu ai bainala tanobada ai; taunabunai, baine davarigu tauna ese baine alagu mase. ");
INSERT INTO meu_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Bena Iehova ese Kain e hamaoroa, eto, Kain baine alaia tauna na davana bae henia hahitu. Bena Iehova ese Kain enai toa ta e atoa, lau ta ese idavarina negana ai bema alaia na garina. ");
INSERT INTO meu_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Bena Kain na Iehova vairana amo e raka lasi, Nod tanona ai eha noho, Eden mairiveina kahana ai. ");
INSERT INTO meu_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Bena Kain na adavana ida e eno bou; bena hahine na e rogorogo, e mara, Enok e abia. Bena Kain ese hanua ta e hadaia, una hanua ladana e hatoa Enok, natuna ladana heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enok natuna na Irad. Irad ese Mehuiael e havaraia, bona Mehuiael ese Metusael e havaraia, bona Metusael ese Lamek e havaraia. ");
INSERT INTO meu_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek e hodara: adavana ta ladana na Ada, ma ta ladana na Sila. ");
INSERT INTO meu_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada e mara, Iabal e abia: ia na dabua kalagadia ai e nohomu bona boromakau e reḡudiamu taudia senedia. ");
INSERT INTO meu_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ia tadina ladana na Iubal: ia na gitara bona ivilikou e hataimu taudia senedia. ");
INSERT INTO meu_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","A Sila na e mara, Tubala-Kain e abia: ia na auri-laboralabora bona auri iḡaukaralaidia tauna ai ela. Hari Tubala-Kain taihuna ladana na Naamaha. ");
INSERT INTO meu_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Bena Lamek ese adavana raruosi e hereva henidia, eto, Ada bona Sila, a hakala henigu! Adavagu raruosi e, egu hereva a kamonai! Tau ta ese e haberogu, na alaia; Tauhau ta ese e botagu, na alaia mase. ");
INSERT INTO meu_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kain dainai dava bae henia hahitu e tomu; Benaini, Lamek dainai dava bae henia hahitu-ahui hitu. ");
INSERT INTO meu_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Bena Adam na adavana ida ma e eno bou: bena hahine e rogorogo, e mara, mero ta e abia, ladana e hatoa Set: eto, Dirava ese natugu ta vada eme henigu, Abel Kain ese e alaia mase tauna, ibolona. ");
INSERT INTO meu_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Bena Set ese natuna e havaraia, ladana e hatoa Enos. Una negana ai taunimanima ese Iehova ladana e hahanea matama. ");
INSERT INTO meu_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adam besena karoana binai. Dirava ese taunimanima e karaia dinana ai ia ese Dirava ida-idana ai e karaia. ");
INSERT INTO meu_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Maruane bona hahine e karadia, ladadia e hato Taunimanima; e karadia dinana ai danu e hanamodia. ");
INSERT INTO meu_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam ena mauri laḡanidia na sinahu-ta toi-ahui negana ai, ia ese natuna ta e havaraia, ia ida-idana ai bona ia heḡereḡerena ai; bena ladana e hatoa Set. ");
INSERT INTO meu_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Set e vara murinai Adam ma laḡani sinahu-taurahani e mauri nohova, natuna mamaruanedia bona hahinedia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam ena mauri laḡanidia iboudiai na sinahu-taurahani-ta toi-ahui: bena e mase. ");
INSERT INTO meu_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set ena mauri laḡanidia na sinahu-ta dikoana ima negana ai, ia ese Enos e havaraia; ");
INSERT INTO meu_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","bena Enos e vara murinai Set na laḡani sinahu-taurahani dikoana hitu e mauri nohova, natuna mamaruanedia bona hahinedia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Set ena mauri laḡanidia iboudiai na sinahu-taurahani-ta gwautarua: bena e mase. ");
INSERT INTO meu_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos ena mauri laḡanidia na taurahani-ta-ahui negana ai, ia ese Kenan e havaraia; ");
INSERT INTO meu_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","bena Kenan e vara murinai Enos na laḡani sinahu-taurahani gwauta-ima e mauri nohova, natuna mamaruanedia bona hahinedia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enos ena mauri laḡanidia iboudiai na sinahu-taurahani-ta dikoana ima: bena e mase. ");
INSERT INTO meu_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan ena mauri laḡanidia na hitu-ahui negana ai, ia ese Mahalalel e havaraia; ");
INSERT INTO meu_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","bena Mahalalel e vara murinai Kenan na laḡani sinahu-taurahani hari-ahui e mauri nohova, natuna mamaruanedia bona hahinedia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan ena mauri laḡanidia iboudiai na sinahu-taurahani-ta bona gwauta: bena e mase. ");
INSERT INTO meu_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel ena mauri laḡanidia na tauratoi-ahui ima negana ai, ia ese Iared e havaraia; ");
INSERT INTO meu_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","bena Iared e vara murinai Mahalalel na laḡani sinahu-taurahani toi-ahui e mauri nohova, natuna mamaruanedia bona hahinedia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalel ena mauri laḡanidia iboudiai na sinahu-taurahani taurahani-ta-ahui ima: bena e mase. ");
INSERT INTO meu_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Iared ena mauri laḡanidia na sinahu-ta tauratoi-ahui rua negana ai, ia ese Enok e havaraia; ");
INSERT INTO meu_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","bena Enok e vara murinai Iared na laḡani sinahu-taurahani e mauri nohova, natuna mamaruanedia bona hahinedia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Iared ena mauri laḡanidia iboudiai na sinahu-taurahani-ta tauratoi-ahui rua: bena e mase. ");
INSERT INTO meu_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enok ena mauri laḡanidia na tauratoi-ahui ima negana ai, ia ese Metusela e havaraia. ");
INSERT INTO meu_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metusela e vara murinai Enok na Dirava ida e hebamo heheniva ela bona laḡani sinahu-toi e ore; natuna mamaruanedia bona hahinedia danu e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enok ena mauri laḡanidia na sinahu-toi tauratoi-ahui ima; ");
INSERT INTO meu_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ia na Dirava ida e hebamo heheniva, murinai tau ta ese se itaia lou, badina be Dirava ese e abia. ");
INSERT INTO meu_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela ena mauri laḡanidia na sinahu-ta taurahani-ahui hitu negana ai, ia ese Lamek e havaraia; ");
INSERT INTO meu_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","bena Lamek e vara murinai Metusela na laḡani sinahu-hitu taurahani-ahui rua e mauri nohova, natuna mamaruanedia bona hahinedia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusela ena mauri laḡanidia iboudiai na sinahu-taurahani-ta tauratoi-ahui taurahani-ta: bena e mase. ");
INSERT INTO meu_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek ena mauri laḡanidia na sinahu-ta taurahani-ahui rua negana ai, ia ese natuna ta e havaraia, ");
INSERT INTO meu_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ladana e hatoa Noa. Ia eto, Iehova ese vada e hadikaia tanona amo ina mero ese baine harohoda mauri, imada ḡaukaradia bona eda hekwarahi amo baita laḡa ani. ");
INSERT INTO meu_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noa e vara murinai Lamek na laḡani sinahu-ima taurahani-ta-ahui ima e mauri nohova, natuna mamaruanedia bona hahinedia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamek ena mauri laḡanidia iboudiai na sinahu-hitu hitu-ahui hitu: bena e mase. ");
INSERT INTO meu_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa ena mauri laḡanidia na sinahu-ima negana ai, ia ese Sem bona Ham bona Iafet e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Nega vada e gini dae taunimanima vada e hutuma tanobada ai, natudia hahinedia danu vada e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Bena Dirava natuna verina ese taunimanima natudia hahinedia e itadia, i'itadia, nanamo; bena e ura henidia ulatodia na e adavadia. ");
INSERT INTO meu_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Bena Iehova eto, Lau laumagu na taunimanima lalodiai basine noho hanaihanai, badina be idia na hidio kavakava mo: edia mauri laḡanidia bae sinahu-ta ruahui hona. ");
INSERT INTO meu_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Una dinadia ai taunimanima ḡaḡau-babadadia tanobada ai e nohova. Dirava natuna verina ese taunimanima natudia hahinedia e adavadia negadia ai na natudia e havaradia: unu na taunimanima ḡaḡau-babadadia nega gunadia ai e nohova; sivaraidia danu babada. ");
INSERT INTO meu_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Iehova ese taunimanima edia kara havara e itaia, vada e bada herea tanobada ai, edia lalo-hadai iboudiai danu didika. ");
INSERT INTO meu_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Bena Iehova e helalo, taunimanima e havaradia tanobada ai dainai; lalona e hisihisi danu. ");
INSERT INTO meu_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Bena Iehova eto, Taunimanima, na karaia ḡauna, na tanobada kopina amo baina abia oho; oibe, taunimanima bona boroma bona tano ai e raumu ḡaudia bona atai manudia danu; badina be na helalomu, na havaridia dainai. ");
INSERT INTO meu_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","A Noa be Iehova ese e lalo namo heniava. ");
INSERT INTO meu_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Noa sivaraina binai: Noa na kara maoromaoro tauna, ena uru ai e kara namo ḡuḡuruva. Ia na Dirava ida e havamo heheniva. ");
INSERT INTO meu_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa ese natuna mamaruanedia tatoi e havaradia: Sem bona Ham bona Iafet. ");
INSERT INTO meu_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Tanobada na dika, Dirava vairanai: tanobada idoinai daḡedaḡe ai e honu honu dae. ");
INSERT INTO meu_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Dirava ese tanobada e itaia, vada e dika rohoroho; badina be taunimanima iboudiai ese edia kara vada e hadika tanobada ai. ");
INSERT INTO meu_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Bena Dirava ese Noa e hereva henia, eto, Mauri ḡaudia iboudiai dokodia be lau vairagu ai vada eme kau; badina be idia daidiai tanobada na daḡedaḡe ai veda eme honu honu dae, taunabunai, lau ese baina habuadia tari tanobada ai. ");
INSERT INTO meu_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","A oi na sida audia amo lagatoi auta ba karaia; ia lalonai daiutu ba kara; bona lalona bona murina ba demadia ahu. ");
INSERT INTO meu_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ini ba karaia toma: latana na roha hitu-ahui ima; lababana roha gwauta-rua mai kahana; bona harana ena lata na roha hitu mai kahana. ");
INSERT INTO meu_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Gaba-maurana ba karaia, ena dobu roha kahana mo; iduara danu ba karaia ohena ai, ere danu bae toi, ta henu ai, ma ta ia daenai, ma ihatoina danu iharuana daenai. ");
INSERT INTO meu_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Badina be lau e e utu-utu badana tanobada baina ha-utua dae, mauri ḡaudia iboudiai guba henuna amo ihabua-taridia; ḡau iboudiai tanobada ai do bae mase ore. ");
INSERT INTO meu_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","A taravagu oiemu ai baina atua, baina hamomokania; oi ma lagatoi ai ba gui, oi bona natumu bona adavamu bona ravamu hahinedia. ");
INSERT INTO meu_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Mauri ḡaudia iboudiai idau-idau rua amo lagatoi ai ba hakaudia vareai, idia danu bae mauri; maruane ta, hahine ta, unu bavabidia toma. ");
INSERT INTO meu_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Manu idau-idau, boromakau idau-idau, tano ai e raumu ḡaudia idau-idau, rua rua amo bae vasi, vada bae mauri. ");
INSERT INTO meu_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Aniani ḡaudia idau-idau iboudiai danu bavabi kau, oiamu bona idia adia. ");
INSERT INTO meu_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Bena Noa na unu e kara toma, Dirava ese e haduaia heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Iehova ese Noa e hamaoroa, eto, Emu ruma taudia iboudiai lagatoi lalonai ba hakaudia vareai, badina be vada na itamu, ina uru ai oi sibomu kara maoromaoro taumu. ");
INSERT INTO meu_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Mauri ḡaudia iboudiai tanobada ai bavabidia: ḡoevaḡoevadia na hitu hitu amo bavabidia, maruane hitu hahine hitu, unu bavabidia toma; a asi ḡoevaḡoevadia na rua rua amo, maruane ta hahine ta bavabidia. ");
INSERT INTO meu_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Atai manudia idau-idau danu bavabidia, maruane hitu hitu amo, hahine hitu hitu amo, besedia na tanobada ai do bae vara lou helaoreana. ");
INSERT INTO meu_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Badina be dina hitu bae ore murinai lau ese medu baina hadihoa tanobada ai, dina hari-ahui boi hari-ahui, mauri ḡaudia iboudiai tanobada ai vada na karadia ihabua-taridia totona. ");
INSERT INTO meu_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Bena Iehova ona hahedua iboudiai na Noa ese e kara ḡuḡuru. ");
INSERT INTO meu_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa ena mauri laḡanidia na sinahu tauratoi negana ai, utu-utu badana ese tanobada idoinai e utua dae. ");
INSERT INTO meu_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Bena Noa bona natuna bona adavana bona ravana hahinedia laḡatoi ai e gui, utu-utu dainai. ");
INSERT INTO meu_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Mauri ḡaudia ḡoevaḡoevadia bona asi ḡoevaoḡoevadia, bona manu, bona tano ai e raumu ḡaudia, ");
INSERT INTO meu_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","iboudiai na rua rua amo, maruane bona hahine, Noa ida e gui kau lagatoi ai, Dirava ese Noa e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Bena dina hitu e ore murinai, utu-utu badana na tanobada idoinai e utua dae. ");
INSERT INTO meu_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa ena mauri laḡanina ihasinahu-tauratoina, hua iharuana, hua dinana ihagwauta-hituna, abata bada-hereana e lasi bona medu bada-hereana e diho matama. ");
INSERT INTO meu_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Una medu na dina hari-ahui boi hari-ahui e dihova. ");
INSERT INTO meu_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Una dina ai Noa mai adavana ida, bona natuna tatoiosi, Sem bona Ham bona Iafet, mai adavadia ida, lagatoi ai e gui. ");
INSERT INTO meu_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Boroma bona horomakau idau-idau danu, bona tano ai e raumu ḡaudia idau-idau, bona manu idau-idau, e gui kau; ");
INSERT INTO meu_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","mauri ḡaudia ibouboudiai rua rua amo, Noa ida lagatoi ai e gui, ");
INSERT INTO meu_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","maruane hahine ida e gui kau, Dirava ena hahedua heḡereḡerena. Bena Iehova ese lagatoi ai e koudia ahu. ");
INSERT INTO meu_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Dina hari-ahui lalodiai utu-utu na tanobada idoinai e utua daeva, e bada e laova, a lagatoi e keni dae atai ai. ");
INSERT INTO meu_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Utu-utu na e bada e laova; a lagatoi na ranu kopina ai e hureva. ");
INSERT INTO meu_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Utu-utu na tanobada idoinai e utua dae vaitani; ororo iboudiai guba henunai e miava na e bubuni; ");
INSERT INTO meu_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ororo doridia ai ranu ena dobu na roha hani mai kahana. ");
INSERT INTO meu_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Bena mauri ḡaudia iboudiai tanobada ai e mase, manu bona boromakau bona boroma idau-idau bona tano ai e raumu ḡaudia bona taunimanima; ");
INSERT INTO meu_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","tano kaukauna ai e mauri nohova ḡaudia, ududia ai mai edia mauri laḡana ḡaudia, ibouboudiai e mase ore. ");
INSERT INTO meu_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Tano kopina ai e mauriva ḡaudia iboudiai na e hebua tari, taunimanina bona boromakau bona tano ai e raumu ḡaudia bona atai manudia. Noa mo sibona, bona ia ida lagatoi ai e nohova ḡaudia, vada e mauri. ");
INSERT INTO meu_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ranu ese tanobada e habubunia ela bona dina sinahu-ta imahui. ");
INSERT INTO meu_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Dirava ese Noa e laloa tao, bona mauri ḡaudia iboudiai bona boromakau ia ida lagatoi ai e gui danu e lalodia tao. Bena Dirava ese lai ta e siaia tanobada ai; bena ranu na e kororo. ");
INSERT INTO meu_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ranu e lohi lohi daeva gabudia bona guba iduaradia danu e kou ahu, guba amo e dihova meduna danu e hadokoa. ");
INSERT INTO meu_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ranu na metaira-metaira tano amo e louva, e maraḡi e laova, ");
INSERT INTO meu_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ela bona hua ihahituna ena dina ihagwauta-hituna ai lagatoi e kuia kau Ararat ororona ai. ");
INSERT INTO meu_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ranu ma e maraḡi e laova, ela bona hua ihagwautana ena dina gini-gunana ai ororo doridia e hedinarai. ");
INSERT INTO meu_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Dina hari-ahui ma e ore, bena Noa ese lagatoi gaba-mauruna e kehoa, mukou ta e harohoa; ");
INSERT INTO meu_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","una mukou e roho eva-eva ela bona ranu tanobada amo e kororo vaitani. ");
INSERT INTO meu_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Pune ta danu e harohoa, baine diba ranu na tanobada kopina ai vada e maraḡi eiava lasi. ");
INSERT INTO meu_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","To pune na ena roho-kau gabuna ta se davaria, bena Noa dekena e lou lao lagatoi ai, badina be ranu ese tanobada kopina idoinai vada e habubunia. Bena Noa ese imana e toia roro, lagatoi lalonai e abia vareai. ");
INSERT INTO meu_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ia na dina hitu ma e noho; bena pune na lagatoi amo ma e harohoa. ");
INSERT INTO meu_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Adorahi ai pune na e lou ela dekenai, uduna ai be olive rauna ta, ia ese vada e koria utu ḡauna; bena Noa vada e diba ranu na tanobada ai vada e maraḡi. ");
INSERT INTO meu_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Dina hitu ma e noho; bena pune ma e harohoa; bena ia na vada se lou lagatoi ai, lasi vaitani. ");
INSERT INTO meu_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Laḡani sinahu-tauratoi dikoana ta, hua gini-gunana ena dina gini-gunana ai, ranu na e kororo vaitani tanobada ai. Bena Noa ese lagatoi e kehoa, tanobada kopina e itaia, vada e kaukau. ");
INSERT INTO meu_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Hua iharuana ena dina iharuahui-hituna ai tanobada e kaukau vaitani. ");
INSERT INTO meu_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Bena Dirava ese Noa e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Laḡatoi amo ba diho mai adavamu ida, bona natumu mai adavadia ida. ");
INSERT INTO meu_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Mauri ḡaudia iboudiai oi dekemu ai danu ba rakalaidia lasi, manu bona boromakau bona tano ai e raumu ḡaudia iboudiai. Bae vara rohoroho, bae mara momomomo, bae hutuma. ");
INSERT INTO meu_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Bena Noa na e diho, ia bona natuna bona adavana bona ravana. ");
INSERT INTO meu_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Boroma idoudiai danu bona manu iboudiai, bona tano ai e raumu ḡaudia iboudiai, ibouboudiai na lagatoi amo e didi didi lasi. ");
INSERT INTO meu_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Bena Noa ese ihaboulaina patana ta e larebaia Iehova ena; bena boroma ḡoevaḡoevadia bona manu ḡoevaḡoevadia iboudiai edia amo hidaosi e abidia, pata latanai e aladia, lahi ai e haḡoledia oho. ");
INSERT INTO meu_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Bena Iehova ese bonana namona e kamonai negana ai, ia eto, Tanobada na basina hadikaia lou taunimanima daidiai, badina be edia lalo-hadai be didika, maraḡidia negadia ela; mauri ḡaudia iboudiai danu basina aladia ore lou, vanegai na aladia na heto. ");
INSERT INTO meu_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Tanobada baine mia negadia ai na hadohado bona ḡeiḡei, keru bona sioahu, lahara bona guitau, dina bona boi, basie doko. ");
INSERT INTO meu_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Dirava ese Noa mai natuna ida e hanamodia, eto, Besemui ba havaradia, bae vara rohoroho, tanobada bae hahonua. ");
INSERT INTO meu_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Tanobada boromadia iboudiai bona atai manudia iboudiai bona tano ai e raumu ḡaudia iboudiai bona davara gwarumedia iboudiai ese garimui bae gari; umui ese danu ba biagudia. ");
INSERT INTO meu_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","E maurimu bona e loamu ḡaudia iboudiai na amui vamu; aniani avadia vada na henimui heḡereḡerena, ini danu na henimuimu, amui; ");
INSERT INTO meu_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","ḡau tamona, hidio mai rarana basio ania, badina be rara na mauri badina. ");
INSERT INTO meu_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Umui raramui danu, emui mauri badina, davana baina abia: boroma enai baina abia eiava taunimanima enai baina abia; taunimanima enai tadikakana rarana davana baina abia. ");
INSERT INTO meu_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Taunimanina baine alaia mase tauna na taunimanima ese bae alaia mase; badina be Dirava ese taunimanima e karadia, ia ida-idana. ");
INSERT INTO meu_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Benaini, besemui ba havaraida, bae hutuma; tanobada ai bae vara rohoroho, hae hutuma bada. ");
INSERT INTO meu_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Bena Dirava ese Noa mai natuna ida ma e hereva henidia, eto, ");
INSERT INTO meu_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Lau o ina, egu taravatu umui bona murimui bae vara garamui na henimuimu; ");
INSERT INTO meu_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","mauri ḡaudia iboudiai danu umui ida nonoho na henidiamu, manu bona bokomakau bona tanobada boromadia iboudiai na henidiamu, lagatoi amo e raka lasi ḡaudia iboudiai. ");
INSERT INTO meu_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Egu taravatu lau ese baina badinaia umui emui ai: mauri ḡaudia na utu-utu ta ese basine aladia lou; utu-utu badana ta basine utua dae lou, tanobada basine hadikaia lou. ");
INSERT INTO meu_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Dirava ma eto, Egu taravatu na henimuimu, lauegu bona umui emui danu, mauri ḡaudia umui ida nonoho iboudiai edia danu, ela bona uru iboudiai, toana binai: ");
INSERT INTO meu_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","egu kevau dagadaga ai na atoamu, taravatu toana ai bainela, lauegu bona tanobada ena. ");
INSERT INTO meu_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Taunabunai, lau ese dagadaga tanobada baina hadagahulaia negana ai na kevau be dagadaga ai ba itaia. ");
INSERT INTO meu_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Bena egu taravatu baina laloa, lauegu, umui emui bona mauri ḡaudia iboudiai edia danu: utu-utu badana ta basina ha-utua dae lou, mauri ḡaudia basina habuadia tari lou. ");
INSERT INTO meu_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kevau na dagadaga ai baine hedinarai, bena baina itaia negana ai, hari mia-hanaihanai taravatuna, lau Dirava bona tanobada ena mauri ḡaudia iboudiai padadai, baina laloa tao. ");
INSERT INTO meu_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Dirava ese Noa ma e hamaoroa, eto, Lauegu ai bona mauri ḡaudia iboudiai ediai na atuamu taravatuna toana binai. ");
INSERT INTO meu_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noa natuna mamaruanedia, lagatoi amo e raka lasi taudia, ladadia na Sem bona Ham bona Iafet. Ham na Kanaan tamana. ");
INSERT INTO meu_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Noa natuna tatoiosi bunu; tanobada besedia iboudiai na idia tatoiosi ese e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Unu dinadia ai Noa eha biru, vine imeana e hadoa. ");
INSERT INTO meu_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Bena vine ranuna e inua, e kekero; bena ena kalaga ai e hekure, asi dabuana. ");
INSERT INTO meu_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Bena Ham, Kanaan tamana, ese tamana na ḡaḡaena mo e itaia; bena e raka lasi, tadikakana raruosi e hamaorodia. ");
INSERT INTO meu_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Bena Sem bona Iafet ese dabua ta e abia, paḡadia ai e idia roro, e rakalaia muri, asie roha kerehai, ela tamadia e tarua, ḡaḡaena mo bae itaia na garina. ");
INSERT INTO meu_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noa ena kekero amo e noga, bena e diba natuna ihararuana ede vada e karaia toma. Bena eto, ");
INSERT INTO meu_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Kanaan ihabaina! Tadikakana edia hesiai taudia edia hesiai tauna ai bainela. ");
INSERT INTO meu_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ma eto, Iehova, Sem ena Dirava, aita imodaia; Kanaan ese ia isiaina baine lao heni. ");
INSERT INTO meu_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Dirava ese Iafet baine hanamoa, Sem ena dabua kalagadia ai baine noho, Kanaan ese ia isiaina baine lao heni. ");
INSERT INTO meu_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Utu-utu badana murinai Noa na laḡani sinahu-toi imahui e mauri nohova. ");
INSERT INTO meu_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ena mauri laḡanidia iboudiai na sinahu-taurahani-ta imahui: bena e mase. ");
INSERT INTO meu_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noa natuna tatoisi, Sem bona Ham bona Iafet, garadia bini, utu-utu badana murinai e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Iafet natuna bini: Gomere bona Magog bona Madai bona Iavan bona Tubal bona Mesek bona Tira. ");
INSERT INTO meu_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomere natuna bini: Asakena bona Rifat bona Togarama. ");
INSERT INTO meu_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Iavan natuna bini: Elisa bona Tarasisi; bona Kitim besena bona Dodanim besena danu ia ese e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Idia edia amo kone taudia iboudiai e vara, edia bese idau-idau ai bona edia gado idau-idau ai. ");
INSERT INTO meu_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham natuna bini: Kusu bona Misraim bona Put bona Kanaan. ");
INSERT INTO meu_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusu natuna bini: Seba bona Havila bona Sabata bona Raama bona Sabateka. Raama natuna bini: Seba bona Dedan. ");
INSERT INTO meu_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusu ese danu Nimrod e havaraia; ia na lohia tauna gini-gunana tanobada ai. ");
INSERT INTO meu_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ia danu hetaraki tauna mai goadana Iehova vairanai; una dainai taunimanima edia hereva ta e tomu “Hetaraki tauna mai goadana Iehova vairanai, Nimrod bamona”. ");
INSERT INTO meu_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Matamana ai ena basileia na Babel bona Ereke bona Akad bona Kalne, Sinara tanona ai. ");
INSERT INTO meu_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Una tano amo e raka lasi, Asuria ela, Nineve hanuana e hadaia, ariarana mai lababadia e kara. Kala hanuana danu e hadaia, ");
INSERT INTO meu_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","bona Resene, Nineve bona Kala padadiai: ia na hanua bada-hereana. ");
INSERT INTO meu_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim ese e havaradia besedia bini: Ludim bona Anamim bona Lehabim bona Napatuhim ");
INSERT INTO meu_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","bona Patarusim bona Kasaluhim bona Kaftorim. Filistia taudia na Kasaluhim besena amo e vara. ");
INSERT INTO meu_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan natuna bini: Sidono, tau roboana, bona Het. ");
INSERT INTO meu_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","E havaradia besedia danu bini: Iebusu bona Amoro bona Girigasa ");
INSERT INTO meu_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","bona Hivi bona Araka bona Sini ");
INSERT INTO meu_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","bona Aravada bona Semara bona Hamat. Gabeamo Kanaan iduhudia na e karoho, kaha idau-idau ai eha noho; ");
INSERT INTO meu_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","edia tano na Sidono amo e laomu ela bona Gasa, Gerara kahana ai, bona Lasa, Sodoma bona Gomora bona Adma bona Seboimi kahadia ai. ");
INSERT INTO meu_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ini iboudiai, mai edia iduhu idau-idau bona edia gado idau-idau bona edia tano idau-idau bona edia bese idau-idau na Ham ena amo e vara. ");
INSERT INTO meu_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem danu, Iafet kakana, Ebere natuna tamadia, natuna mamaruanedia haida ma e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem natuna bini: Elam bona Asuru bona Afasad bona Lud bona Aram. ");
INSERT INTO meu_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram natuna bini: Usu bona Hulu bona Getere bona Masa. ");
INSERT INTO meu_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Afasad ese Sela e havaraia, bona Sela ese Ebere e havaraia. ");
INSERT INTO meu_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebere natuna mamaruanedia na rarua. Ta ladana na Peleg, badina be iena nega ai tanobada besedia na e haheparara. Tadina ladana na Iokotan. ");
INSERT INTO meu_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Iokotan natuna bini: Alamodad bona Selefe bona Hasaramavete bona Iera ");
INSERT INTO meu_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","bona Hadoram bona Usala bona Dikila ");
INSERT INTO meu_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","bona Obala bona Abimael bona Seba ");
INSERT INTO meu_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","bona Ofiri bona Havila bona Iobab. Ini iboudiai na Iokotan natuna. ");
INSERT INTO meu_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Edia tano na Mesa amo e laomu, mairiveina ororona ladana Sefara kahana ai. ");
INSERT INTO meu_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ini iboudiai, mai edia iduhu idau-idau bona edia gado idau-idau bona edia tano idau-idau bona edia bese idau-idau na Sem ena amo e vara. ");
INSERT INTO meu_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Noa natuna garadia bini, edia uru ai bona edia bese ai: idia edia amo tanobada besedia iboudiai e vara, utu-utu badana murinai. ");
INSERT INTO meu_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Tanobada idoinai taunimanima iboudiai gadodia be tamona, eredia danu heḡereḡere. ");
INSERT INTO meu_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Nega ta, mairiveina kahana amo e laolaova ai, idia ese taora ta e davaria, Sinara kahana ai, bena unuseni ai e nohova. ");
INSERT INTO meu_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Bena idia na e hereva heheni, eto, Mani raro nadidia aita kara, aita tunu namonamo. Bena idia ese e tunu rarodia e abi, nadi ai e halao, bona rarokaka ta e abia, hekamo ḡauna ai e halaoa. ");
INSERT INTO meu_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Bena idia ma eto, Mani hanua ta aita hadaia, bona kohoro ta danu, kohoro dorina na guba ai baine kau; unu amo harida baita hadaea, tanobada kopina ai biata loa eva-eva na garina. ");
INSERT INTO meu_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Bena Iehova e diho, hanua bona kohoro Adam besena ese e latebaia baine itaia eto. ");
INSERT INTO meu_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Iehova eto, Idia na bese tamona, iboudiai danu edia gado tamona; ina na idia ese eme karaia matama, gabeai ḡau ta ikarana ma bae ura, daika ese baine laodia ahu? ");
INSERT INTO meu_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Aina diho, edia gado baina ha-idaua, bena edia hereva na basie hediba heheni. ");
INSERT INTO meu_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Taunabunai, Iehova ese e hakarohodia rohoroho, tanobada kahadia idoidiai; edia hanua ilarebana danu e hadokoa. ");
INSERT INTO meu_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Taunabunai, una gabu ladana e hatoa Babel; badina be unuseni ai Iehova ese taunimanima edia gado e ha-idaua, bona unu amo ia ese e hakarohodia rohoroho, tanobada kahadia idoidiai. ");
INSERT INTO meu_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sem garana bini. Sem ena mauri laḡanidia na sinahu ta negana ai, ia ese Afasad e havaraia, utu-utu badana laḡani rua vada e kororo murinai. ");
INSERT INTO meu_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Afasad e vara murinai, Sem na laḡani sinahu-ima e mauri nohova, natuna mamaruanedia bona hahinedia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Afasad ena mauri laḡanidia na toi-ahui ima negana ai, ia ese Sela e havaraia. ");
INSERT INTO meu_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sela e vara murinai, Afasad na laḡani sinahu-hani dikoana toi e mauri nohova, natuna mamaruanedia bona hahinedia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela ena mauri laḡanidia na toi-ahui negana ai, ia ese Ebere e havaraia. ");
INSERT INTO meu_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ebere e vara murinai Sela na laḡani sinahu-hani dikoana toi e mauri nohova, natuna mamaruanedia bona hahinedia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebere ena mauri laḡanidia na toi-ahui hani negana ai, ia ese Peleg e havaraia. ");
INSERT INTO meu_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Peleg e vara murinai, Ebere na laḡani sinahu-hani toi-ahui e mauri nohova, natuna mamaruanedia bona hahinedia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg ena mauri laḡanidia na toi-ahui negana ai, ia ese Reu e havaraia. ");
INSERT INTO meu_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reu e vara murinai, Peleg na laḡani sinahu-rua dikoana taurahani-ta e mauri nohova, natuna mamaruanedia bona hahinedia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu ena mauri laḡanidia na toi-ahui rua negana ai, ia ese Serug e havaraia. ");
INSERT INTO meu_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serug e vara murinai, Reu na laḡani sinahu-rua e mauri nohova, natuna mamaruanedia bona hahinedia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug ena mauri laḡanidia na toi-ahui negana ai, ia ese Nahoro e havaraia. ");
INSERT INTO meu_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nahoro e vara murinai, Serug na laḡani sinahu-rua e mauri nohova, natuna mamaruanedia bona hahinedia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahoro ena mauri laḡanidia na ruahui taurahani-ta negana ai ia ese Tera e havaraia. ");
INSERT INTO meu_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Tera e vara murinai, Nahoro na laḡani sinahu-ta gwauta taurahani-ta e mauri nohova, natuna mamaruanedia bona hahinedia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera ena mauri laḡanidia na hitu-hitu negana ai, ia ese Abram bona Nahoro bona Haran e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera garana bini: Tera ese Abram bona Nahoro bona Haran e havaradia. Haran ese Lot e havaraia. ");
INSERT INTO meu_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Tamana Tera do se mase negana ai, Haran e mase guna, e vara gabuna ai, Uru, Kaldea taudia edia hanua ta, unuseni ai eha mase. ");
INSERT INTO meu_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram e headava; Nahoro danu e headava. Abram adavana ladana na Sarai. Nahoro adavana ladana na Milka, Haran natuna. Una Haran natuna na Milka bona Iska. ");
INSERT INTO meu_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai na e gabani. ");
INSERT INTO meu_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera ese natuna Abram bona tubuna Lot, Haran natuna, bona ravana Sarai, Abram adavana, e abidia, Kaldea taudia edia hanua, Uru, amo e hakaudia lasi, Kanaan tanona baela eto. Bena gabu ta ai e kau, ladana Haran, unuseni ai e noho. ");
INSERT INTO meu_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera ena mauri laḡanidia iboudiai na sinahurua dikoana ima Tera na Haran ai e mase. ");
INSERT INTO meu_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Una negana ai Iehova ese Abram e hamaoroa, eto, Emu tano bona varavaramu bona tamamu ena ruma ba rakatanidia, lau ese baina hamaorolaimu tanona baola. ");
INSERT INTO meu_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Lau ese bese badana ai baina halaomu; baina hanamomu, ladamu baina imodaia, hahenamo tauna ai baola. ");
INSERT INTO meu_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Oi bae hanamomu taudia na baina hanamodia, a oi baine hadikamu tauna na baina hadikaia. Oi daimu ai tanobada besedia idoidiai do bae namo. ");
INSERT INTO meu_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Bena Abram na vada ela, Iehova ese e haduaia heḡereḡerena; Lot danu ia ida ela. ");
INSERT INTO meu_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram ena mauri laḡanidia na hitu-ahui ima, Haran e rakatania negana ai. Abram ese adavana Sarai bona vavana Lot e hakaudia lao, edia kohu iboudiai bona edia hesiai memerodia Haran ai e davaridia danu e laohaidia; e tore tore isi, Kanaan tanona baela eto. Bena Kanaan tanona ai e kau. ");
INSERT INTO meu_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram ese tano e rakaia hanai ela Sekem, ela bona au helaḡana ladana More. Una negana ai Kanaan taudia na dounu e nohova una tano ai. ");
INSERT INTO meu_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Bena Iehova na Abram vairanai e hedinarai, eto, Lau ese ina tano na oi garamu baina henidia. Bena Abram ese ihaboulaina patana ta e larebaia, Iehova ena, Iehova ese ia vairanai e hedinarai gabuna ai. ");
INSERT INTO meu_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Bena ia ese una gabu e rakatania, ororo ta, Betele mairiveina kahana ai, ela, unuseni ai e taruha; Betele na tahodiho kahana ai, Ai na mairiveina kahana ai. Unuseni ai danu ihaboulaina patana ta e larebaia, Iehova ena. bona Iehova ladana e hahanea. ");
INSERT INTO meu_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ma eha laolao, diho kahana ela. ");
INSERT INTO meu_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Una tano ai doe vada e vara dainai, ia na diho kahana ma ela, Aigupto ai baine hanoho eto, badina be doe na bada herea. ");
INSERT INTO meu_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Bena Aigupto vada e kahira ai, ia ese adavana Sarai e hereva henia, eto, Momokani, oi na hane namo: ");
INSERT INTO meu_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","lau na tomamu Aigupto taudia bae itamu negana ai, idia baeto “Ina na ia adavana”, bena lau bae alagu mase bona oi bae abimu mauri. ");
INSERT INTO meu_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Benaini, baoto oi na lau taihugu, bena oi daimu ai baina namo bona baina mauri danu. ");
INSERT INTO meu_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Taunabunai, Abram na Aigupto ai e kau negana ai, Aigupto taudia ese hahine na e itaia, ia na hane namo. ");
INSERT INTO meu_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Farao ena lohia taudia ese danu e itaia, bena idia ese Farao vairanai e heatolaia. Bena e hakaua dae Farao ena ruma ai. ");
INSERT INTO meu_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Bena Farao ese Abram e kara namo henia, hahine dainai: mamoe bona boromakau bona doniki bona hesiai taudia bona hesiai hahinedia bona kamelo e henia momomomo. ");
INSERT INTO meu_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","A Iehova ese hisihisi dikadia amo Farao mai ena ruma taudia ida e hahisidia, Sarai, Abram adavana, dainai. ");
INSERT INTO meu_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Bena Farao ese Abram e boiria, e gwau henia, eto, Ede vada o karagu toma? Dahaka dainai oi so hamaorogu ia na oi adavamu? ");
INSERT INTO meu_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Edeheto o koigu, oto ia na oi taihumu; bena na adavaia? Vadaeni, adavamu binai: bavabia, ba raka oho. ");
INSERT INTO meu_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Bena Farao ese ena hesiai taudia e haduadia, bae hakaua lao; bena e hakaua ela, ia mai adavana mai ena kohu idoinai ida. ");
INSERT INTO meu_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram ese Aigupto tanona e rakatania, ia mai adavana ida. Ena kohu idoinai e laohaia; Lot danu e hakaua lao. Idia na diho kahana amo e lou. ");
INSERT INTO meu_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram ena boromakau na momo herea, ena silver bona ena gold danu momo herea. ");
INSERT INTO meu_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Diho kahana amo e laolao ela, Betele ai e kau, ena taruha gabuna gunana ai ma e taruha, Betele bona Ai padadiai; ");
INSERT INTO meu_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","gunaguna ihaboulaina patana e larebaia gabuna bunai. Unuseni ai Abram ese Iehova ladana e hahanea. ");
INSERT INTO meu_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot danu, Abram e bamoa tauna, ena mamoe bona ena boromakau na momo, ena dabua kalagadia danu momo. ");
INSERT INTO meu_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Taunabunai una tano na dia heḡereḡere idia raruosi gabu tamona ai bae noho hebou, badina na edia kohu na momo bona gabu na dia bada. ");
INSERT INTO meu_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Bena Abram ena boromakau ireḡudia taudia na Lot ena boromakau ireḡudia taudia ida e heai. Una negana ai Kanaan taudia bona Perisi taudia na una tano ai e nohova. ");
INSERT INTO meu_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Bena Abram ese Lot e hamaoroa, eto, Mani ita raruosi basita heai, eda boromakau ireḡudia taudia danu basie heai, badina be ita na varavara. ");
INSERT INTO meu_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tano idoinai na oi vairamu ai mia, ani? Mani emu kara, egu ai ba raka siri; oi na lauri kahana boma lao, lau be idiba kahana bama lao; eiava oi na idiba kahana boma lao, lau be lauri kahana bama lao. ");
INSERT INTO meu_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Bena Lot na e gaga isi, Ioridane kourana e itaia, idoinai mai ranuna: Iehova ese Sodoma bona Gomora do se habua tari negana ai una tano na Iehova ena imea na heto, eiava Aigupto tanona, Soara dalana ai e laomu, na heto. ");
INSERT INTO meu_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Bena Lot na Ioridane kourana idoinai e abia hidi, mairiveina kahana ela. Idia raruosi na e haheparara. ");
INSERT INTO meu_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram na Kanaan tanona ai e noho; bona Lot na taora hanuadia ela, Sodoma kahana ai e taruha. ");
INSERT INTO meu_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","A Sodoma taudia na didika, Iehova vairanai e kara havara. ");
INSERT INTO meu_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Bena Lot e raka oho murinai Iehova ese Abram e hereva henia, eto, A gaga isi; o ginimu gabuna ai ba roha roha, mirigini kahana ai, diho kahana ai, mairiveina kahana ai, tahodiho kahana ai. ");
INSERT INTO meu_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Badina be o itaiamu tanona idoinai baina henimu, bona oi garamu baina henidia ela bona hanaihanai. ");
INSERT INTO meu_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Oi garamu na tano ḡahuna na heto baina hahutumadia; taunabunai, tau ta tano ḡahuna dimura-dimuradia iduahidia bema diba, ia na oi garamu iduahidia bema diba. ");
INSERT INTO meu_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","A tore isi, ina tano ba rakaia hanai, latana amo, lababana amo; badina be lau ese baina henimu. ");
INSERT INTO meu_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Bena Abram na ena dabua kalagana e lokua, e tore isi, ela, Heberon ai e taruha, Mamare ena au helaḡadia badidiai. Unuseni ai ihaboulaina patana ta e larebaia, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Amarafel ese Sinara tanona e lohiaia, Ariok ese Elasara tanona e lohiaia, Kedoralaomere ese Elam tanona e lohiaia bona Tidala ese Goimi tanona e lohiaia negana ai, ");
INSERT INTO meu_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","idia hahaniosi eha tuari, Bera, Sodoma pavapavana, bona Birisa, Gomora pavapavana, bona Sinab, Adma pavapavana, bona Semebere, Seboimi pavapavana, bona Bela (ladana ta be Soara) pavapavana, e tuari henidia. ");
INSERT INTO meu_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ini iboudiai na Sidim kourana ai e tuari: tadi gohuna be unuseni ai. ");
INSERT INTO meu_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Laḡani gwauta-rua idia ese Kedoralaomere isiaina e lao heniava, a laḡani ihagwauta-toina ai idia na e gwau edeede. ");
INSERT INTO meu_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Bena laḡani ihagwauta-hanina ai Kedoralaomere bona ia e duruava lohiadia na e tore isi, Refaim taudia na Astaroto-karanaimi ai e hadareredia, bona Susim taudia na Ham ai e hadareredia, bona Emim taudia na Savekiriataimi ai e hadareredia, ");
INSERT INTO meu_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Hori taudia danu edia ororo, ladana Seiri, ai e hadareredia, bona e hahavadia lao ela bona El-paran, tano ḡaḡaena badinai. ");
INSERT INTO meu_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Bena e lou ema bona En-mispat (ladana ta be Kade); bena Amalek taudia edia tano e havahua, bona Amoro taudia Hasasono-tamara ai e nohova edia tano danu. ");
INSERT INTO meu_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Bena Sodoma pavapavana bona Gomora pavapavana bona Adma pavapavana bona Seboimi pavapavana bona Bela (ladana ta be Soara) pavapavana e tore isi, Sidim kourana ela, tuari totona; ");
INSERT INTO meu_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","idia laima-osi ese Kedoralaomere, Elam pavapavana, bona Tidala, Goimi pavapavana, bona Amarafel, Sinara pavapavana, bona Ariok, Elasara pavapavana, hahaniosi na e tuari henidia. ");
INSERT INTO meu_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Una Sidim kourana na mai kopukopuna, bena Sodoma pavapavana bona Gomora pavapavana e darere negana ai e heau, kopukopu ai eha heau kau, eha mase. A taunimanima oredia na ororo ai e heau mauri. ");
INSERT INTO meu_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Bena pavapava hahaniosi ese kohu idoinai bona aniani idoinai e dadi ore, Sodoma ai bona Gomora ai; bena e raka oho. ");
INSERT INTO meu_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lot, Abram vavana, Sodoma ai e nohova; bena idia ese ia danu e abia mauri, e laohaia, mai ena kohu idoinai. ");
INSERT INTO meu_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Bena e heau mauri tauna ta ela, Abram, Heberu tauna, e hamaoroa. Ia na Mamare, Amoro tauna, Eskol bona Anere kakadia, ena au helaḡadia badibadi-diai e nohova, bona idia tatoiosi ida e hetura. ");
INSERT INTO meu_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram na e kamonai, vavana vada e abia mauri, bena ia ese ena hesiai taudia, ena taruha ai e nohova taudia, e haboudia, tuari ḡaudia e henidia, una tuari oreana muridia amo e hakaudia lao, ela bona Dan. ");
INSERT INTO meu_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Hanuaboi ai ena orea e hapararaia, kahana kahana amo e tuari henidia, e hadareredia, e hahavadia ela bona Hoba, Damasko mirigini kahana ai. ");
INSERT INTO meu_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Kohu idoinai e abia lou, bona vavana Lot mai ena kohu ida, bona hahine, bona hanua taudia loḡora. ");
INSERT INTO meu_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Kedoralaomere mai bamona ida e hadareredia, bena e lou ai na Sodoma pavapavana ida e hedavari Save kourana ai (Pavapava ena Koura). ");
INSERT INTO meu_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Bena Melkisedek, Salem pavapavana, Dirava Herea Mikamika ena hahelaḡa tauna, ese flaoa bona vine ranuna e laohai, e dabara. ");
INSERT INTO meu_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ia ese Abram e hanamoa, eto, Dirava Herea Mikamika, guba bona tanobada ikaradia Diravana, ena hahenamo be Abram latanai baine mia; ");
INSERT INTO meu_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Dirava Herea Mikamika danu aita imodaia, badina be ia ese oi inaimu na imamu ai vada e atodia kau. Bena Abram ese e abi kohudia iboudiai e karoadia, karoa gwauta; bena karoa ta Melkisedek e henia. ");
INSERT INTO meu_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Bena Sodoma pavapavana ese Abram e hamaoroa, eto, Abi-mauri taudia lau ba henigu, a kohu be oi ese bavabi. ");
INSERT INTO meu_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","A Abram ese Sodoma pavapavana e haere henia, eto, Lau ese Iehova, Herea Mikamika Diravana, guba bona tanobada ikaradia Diravana, vada na gwvau henia hamata, ");
INSERT INTO meu_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","dabua varona ta eiava tamaka varona ta oiemu ai basina abia, gabeamo baoto “Lau ese Abram ena taḡa na henia” na garina. ");
INSERT INTO meu_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Egu memero adia aniani mo ba henigu; a kohu be e bamogu taudia tatoiosi, Anere bona Eksol bona Mamare, ahudia ba henidia, vadaeni. ");
INSERT INTO meu_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Unu ḡau muridiai, Iehova ena hereva na Abram enai e kau, mata hanai ai. Iehova eto, Abram, basio gari, lau na oiemu kesi, ahumu danu baine bada. ");
INSERT INTO meu_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Bena Abram eto, Ḡaubada Iehova e, dahaka ba henigu? Lau na asi natugu; dihigu be hari Eliesere, Damasko tauna. ");
INSERT INTO meu_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram ma eto, Natugu ta so henigu dainai, hesiai merona egu ruma ai e vara na dihigu ai bainela. ");
INSERT INTO meu_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Bena Iehova ena hereva enai ma e kau, eto, Ina tau na dia oi dihimu; natumu adorana do baine vara, dihimu ai bainela. ");
INSERT INTO meu_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Bena e hakaua lasi murimuri ai, eto, A gaga dae, guba ba itaia, hisiu ba duahidia diba eiava lasi: oi garamu danu unu bae hutuma toma. ");
INSERT INTO meu_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Bena Abram ese Iehova e abidadama henia; una dainai maorona e gwauraia. ");
INSERT INTO meu_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Bena Iehova ese e hereva henia lou, eto, Lau Iehova ese Uru, Kaldea hanuana, amo na hakaumu lasi, ina tano baina henimu halaoreana, emu tano korikori ai bainela. ");
INSERT INTO meu_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram eto, Ḡaubada Iehova e, ede baina diba toma ina na egu tano korikori ai bainela? ");
INSERT INTO meu_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Iehova eto, Boromakau hahinena ta bavabia, laḡani toi ḡauna, bona nani hahinena ta, laḡani toi ḡauna, bona mamoe maruanena ta, laḡani toi ḡauna, bona kerea ta bona pune natuna ta. ");
INSERT INTO meu_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ini iboudiai e abi, e ivadia parara, ahu rua ai e habou, a manu na se ivadia. ");
INSERT INTO meu_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Bena galo na unu vamu ai e roho kau, to Abram ese e luludia. ");
INSERT INTO meu_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Dina e diho, bena Abram matana e mahuta, bona gari bada ese e butua tao. ");
INSERT INTO meu_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Bena Iehova ese Abram e hereva henia, eto, Ba diba ḡoevaḡoeva: garamu be sinahu-hani idau tano ai bae noho, daḡedaḡe taudia isiaidia bae lao heni; ");
INSERT INTO meu_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","a isiaina bae lao heni besena lau ese baina hahemaoro henia; bena ia bogaragina amo bae raka lasi, mai edia taḡa. ");
INSERT INTO meu_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Oi be tubu tama dekedia do baola mai mainomu ida: burukamu ai ba mase, bena bae gurimu. ");
INSERT INTO meu_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","A idia be uru ihahanina ai ina tano bae lou henia, badina be Amoro taudia ese edia kara havara do asie haḡuḡuru. ");
INSERT INTO meu_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Dina e kerekere, hanua e boi; bena Abram ese lahi mai kwalahuna e itaia, e kara kede na heto, unu vamu ahu rua padadiai. ");
INSERT INTO meu_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Una dina ai Iehova ese Abram e gwau henia hamata, eto, Lau ese ina tano na oi garamu vada na henidia, Aigupto sinavaina amo ela bona sinavai badana, ladana na Eufrate: ");
INSERT INTO meu_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Kene taudia edia tano, Kenisi taudia edia tano, Kadamono taudia edia tano, ");
INSERT INTO meu_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hiti taudia edia tano, Perisi taudia edia tano, Refaim taudia edia tano, ");
INSERT INTO meu_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amoro taudia edia tano, Kanaan taudia edia tano, Girigasa taudia edia tano, bona Iebusu taudia edia tano. ");
INSERT INTO meu_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, Abram adavana, vada e gabani, natuna ta se havaraia iena. Ia na mai ena hesiai hahinena ta, hane Aigupto, ladana be Hagara. ");
INSERT INTO meu_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Bena Sarai ese Abram e hamaoroa eto, Dibamu Iehova ese natumu ta se henigu; na noimumu, egu hesiai hahinena avabia; readia natugu ta iena amo baina abia. Bena Abram ese Sarai ena hereva e abia dae. ");
INSERT INTO meu_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Taunabunai, Abram na laḡani gwauta Kanaan tanona ai vada e noho negana ai, Sarai ese ena hesiai hahinena Hagara, hane Aigupto, e abia, adavana Abram e henia, baine adavaia. ");
INSERT INTO meu_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Bena ia na Hagara ida e eno bou. Bena hahine na e rogorogo; bena dibana vada e rogorogo dainai ia ese biaguna hahinena se matauraia. ");
INSERT INTO meu_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Bena Sarai ese Abram e gwau henia, eto, Oiemu kerere ese vada e hadikagu; egu hesiai hahinena na henimu, bavadavaia, a dibana vada e rogorogo dainai ia na se matauraigumu: Iehova ese ita raruosi baine hahemaoro henida. ");
INSERT INTO meu_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","A Abram ese Sarai e haere henia, eto, Hahine na oi imamu ai; emu ura heḡereḡerena ba kara henia. Bena Sarai ese e daḡedaḡe henia, ela bona hahine na e heau. ");
INSERT INTO meu_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Bena Iehova ena aneru ta ese tano ḡaḡaena ai e davaria, ranu gurina ta badibadinai. Una ranu gurina na Suru dalana ai. ");
INSERT INTO meu_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ia eto, Hagara, Sarai ena hesiai hahinemu, ede amo oma bona ede bo laomu? Hahine na e haere, eto, Biagugu hahinena Sarai vairana amo vada na heau. ");
INSERT INTO meu_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Aneru ma eto, A lou lao, ia erena ba kamonai. ");
INSERT INTO meu_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Iehova ena aneru ma eto, Oi garamu lau ese baina hahutumadia, basie duahidia diba. ");
INSERT INTO meu_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Iehova ena aneru ma e hamaoroa lou, eto, Benaini, vada o rogorogomu; mero ta bavabia, ladana ba hatoa Ismael, badina be Iehova ese emu tai vada e kamonai. ");
INSERT INTO meu_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ia na raka edea tauna ai bainela; ia ese taunimanima iboudiai baine inai henidia, bona taunimanima iboudiai ese ia bae inai henia. Ia na tadikakana edia noho gabudia mairiveina kahana ai baine noho. ");
INSERT INTO meu_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Bena hahine ese Iehova, e hereva henia Diravana, ladana e hahanea, eto, Vada o ha=eregumu Diravamu! Badina be ia eto, Tano ḡaḡaena ai vada na mata hanai, e hahedinarai henigu Diravana vada na itaia. ");
INSERT INTO meu_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Taunabunai una ranu gurina ladana e hatoa Mauri bona Mata-hanai Gurina: ia na Kade bona Bered padadiai. ");
INSERT INTO meu_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Bena Hagara na e mara, mero ta e abia, Abram ena; bena Abram ese natuna, Hagara ese e havaraia merona, ladana e hatoa Ismael. ");
INSERT INTO meu_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hagara ese Ismael e havaraia negana ai, Abram ena mauri laḡanidia na taurahaniahui tauratoi. ");
INSERT INTO meu_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram ena mauri laḡanidia na taurahanai-ta-ahui taurahani-ta negana ai, Iehova ese ienai e hedinarai, e hereva henia, eto, Lau na Siahu Diravana; lau vairagu ai ba raka mai maoromaoromu ida; ");
INSERT INTO meu_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","taravamu aina atua raruosi eda, bona garamu baina hahutumadia. ");
INSERT INTO meu_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Bena Abram na tano ai e goru diho; bena Dirava ese e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Lau ese taravamu na atuamu: bese diaḡau do ba havaradia lau daigu ai. ");
INSERT INTO meu_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ladamu danu basie hatoa lou “Abram”, a ladamu bae hatoa “Abraham”, badina be bese diaḡau ihavaradia tauna ai vada na halaomu. ");
INSERT INTO meu_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Garamu lau ese baina hahutumadia, bese idau-idau do ba havaradia, hanua pavapavadia danu oiemu amo bae vara. ");
INSERT INTO meu_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Taravamu na atuamu be lau ese baina badinaia ita raruosi eda, bona garamu murimu ai bae vara edia, ela bona uru iboudiai, baine mia hanaihanai taravatuna: emu Dirava ai bona murimu ai bae vara garamu edia Dirava ai do bainala. ");
INSERT INTO meu_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Oi ese o noholaia hedoa-hedoamu tanona na oi bona murimu ai bae vara garamu danu baina henimui, Kanaan tanona idoinai na umui emui ela bona hanaihanai: lau na emui Dirava ai bainala. ");
INSERT INTO meu_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Dirava ese Abraham ma e hamaoroa, eto, Oi danu egu taravatu do ba badinaia, oi bona murimu ai bae vara garamu ela bona uru idoidiai. ");
INSERT INTO meu_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ba badinaia, bona murimu ai bae badinaia. taravatuna binai: emui maruane iboudiai bae peritomedia, ");
INSERT INTO meu_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","kopimui bae ivadia, eda taravatu toana. ");
INSERT INTO meu_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Uru iboudiai lalodiai, vara matamata mamaruanedia edia vara dinadia bae taurahani ai na bae peritomedia, umui emui ai bae vara memerodia, bona emui hesiai hahinedia ese emui ruma ai bae havaradia memerodia, idau bese memerodia edia bese taudia ediai ba hoidia danu bae peritomedia. ");
INSERT INTO meu_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Emui ruma ai bae vara memerodia bona ba hoidia memerodia, iboudiai ba peritomedia: unu amo egu taravatu toana na kopimui ai baine mia, badina be ia na mia-hanaihanai taravatuna. ");
INSERT INTO meu_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","A maruane ta basiema peritomea, ia na asi ahuna ena bese ai; ia na egu taravatu itata-utuna tauna. ");
INSERT INTO meu_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Dirava ese Abraham ma e hamaoroa, eto, Adavamu Sarai ladana basio hatoa lou “Sarai”, a ladana ba hatoa “Sara”. ");
INSERT INTO meu_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Lau ese baina hanamoa, natumui ta baine vara: momokani, baina hanamoa, ia na bese idau-idau sinadia ai bainela; hanua pavapavadia ia ese baine havaradia. ");
INSERT INTO meu_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Bena Abraham na tano ai e goru diho, to lalona ai e kiri, eto, Ena mauri laḡanidia na sinahu-ta tauna ese natuna baine havaraia a? Sara danu ena mauri laḡanidiana taurahani-ta-ahui be baine mara a? ");
INSERT INTO meu_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Bena Abraham ese Dirava e noia, eto, Ismael na oi vairamu ai bema noho bema namo. ");
INSERT INTO meu_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","A Dirava ese Abraham e haere henia, eto, Lasi, adavamu Sara ese natumu ta baine havaraia, ladana ba hatoa Isaak. Egu taravatu baina badinaia ienai bona murinai bae vara garana ediai, ela bona hanaihanai. ");
INSERT INTO meu_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","A Ismael ome gwauraia herevana vada na kamonai; benaini, vada na hanamoamu, ia besena baine vara, garana bae hutuma; lohia gwauta-rarua ia ese baine havaradia, bese badana ai baina halaoa. ");
INSERT INTO meu_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","A egu taravatu na Isaak enai baina badinaia, merona bunai Sara ese baine abia, laḡani vairai. ");
INSERT INTO meu_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Dirava ese ena hereva e hadokoa, bena ia ese Abraham e rakatania. ");
INSERT INTO meu_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Bena Abraham ese natuna Ismael e abia, bona ena hesiai tataudia iboudiai, ena ruma ai e vara taudia bona e hoidia taudia danu, e abidia, iboudiai e peritomedia una dina ai, kopidia e ivadia, Dirava ese e haduaia heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham ena mauri laḡanidia na taurahani-ta-ahui taurahanita, e peritomea negana ai. ");
INSERT INTO meu_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Natuna Ismael ena mauri laḡanidia na gwauta toi, e peritomea negana ai. ");
INSERT INTO meu_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abraham mai natuna Ismael ida dina tamona ai e peritomedia. ");
INSERT INTO meu_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ena ruma tataudia iboudiai danu, ena ruma ai e vara taudia bona bese idau edia amo e hoidia taudia, iboudiai na ia ida e pentomedia nega tamona ai. ");
INSERT INTO meu_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Iehova ese Abraham enai ma e hedinarai lou, Mamare ena au Helaḡadia badidiai. Negana be dina tubua, bona ia na ena dabua kalagana iduarana ai e helaiva. ");
INSERT INTO meu_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ia na e gaga isi, tatau tatoi e itadia, ia vairanai gigini; e itadia negana ai, ia na ena dabua kalagana iduarana amo e heau lasi, tano ai e goru diho, ");
INSERT INTO meu_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","eto, Ḡauka e, boma lalo namo henigu, lau, emu hesiai tauna, basioma rakagu hanai. ");
INSERT INTO meu_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Mani ranu taina ae mailaia, aemui bae huri, bena ina au ikerukeruna ai lagamui bavani. ");
INSERT INTO meu_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Aniani taina danu mani aina mailaia, taumui ihagoadadia; gabeamo emui dala ai do ba raka. Lau, emui hesiai tauna, egu ai vada o kau badina korikori binai. Idia eto, Emu hereva heḡereḡerena vada ba karaia. ");
INSERT INTO meu_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Bena Abraham na dabua kalagana ai e heau vareai, Sara e hamaoroa, eto, Flaoa irau autoi avabi, ba kuia, ataga ba gabu. ");
INSERT INTO meu_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Bena e heau lao, ena boromakau serina ai boromakau natuna ta, hidiona manoka-manokana bona mai digarana ḡauna, e abia, ena hesiai tauna ta e henia; bena ia ese e nadua haraḡa-haraḡa. ");
INSERT INTO meu_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Bena bata bona rata e abi, bona ena mero ese e nadua boromakauna; bena hari tatoiosi vairadiai e dabara, au ikerukeruna ai, bona badibadidiai e gini ela bona vada e aniani vaitani. ");
INSERT INTO meu_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Bena idia ese e nanadaia, eto, Adavamu Sara be edeseni ai? Ia eto, Ia na dabua kalagana lalonai. ");
INSERT INTO meu_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Bena idia ta eto, Laḡani vairai do baina lou henimu, bena adavamu Sara baine mara, mero ta baine abia. Sara na dabua kalagana iduarana murinai gini, bena ia ese una hereva e kamonai. ");
INSERT INTO meu_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Una negana ai Abraham bona Sara vada e buruka herea, bona Sara ena nega vada e hanaia. ");
INSERT INTO meu_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Taunabunai, Sara na e kiri, eto, Egu nega vada e ore, bona adavagu danu vada e buruka, be, moale baina davaria diba a? ");
INSERT INTO meu_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Bena Iehova ese Abraham e nanadaia, eto, Dahaka dainai Sara e kirimu, e tomu “Burukagu ai natugu ta baina abia a”? ");
INSERT INTO meu_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Be, hoa karana ta mia Iehova basine karaia diba, a? Laḡani vairai, vada na gwauraia hamata negana ai, do baina lou henimu, bena Sara ese natuna baine abia. ");
INSERT INTO meu_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Bena Sara e heḡore, eto, Lau na asina kiri. Badina be ia na e gari. A ia eto, Lasi, oi na o kiri. ");
INSERT INTO meu_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Bena hari tatoiosi e tore isi, Sodoma dalana ai e raka; bona Abraham ese dala ai e bamodia. ");
INSERT INTO meu_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Bena Iehova eto, Egu kara na Abraham ena amo baina hunia, namo eiava? ");
INSERT INTO meu_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Badina be Abraham na bese badana bona goadana ai bainela, bona tanobada besedia iboudiai na ia dainai hahenamo bae abia. ");
INSERT INTO meu_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Badina be vada na abia hidi, ia ese natuna bona garana do baine reḡudia, idia na Iehova ena dala ai bae raka, bona kara namodia bona maoromaorodia bae kara, Iehova ese ena gwauhamata Abraham enai baine hamomokania helaoreana. ");
INSERT INTO meu_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Bena Iehova eto, Sodoma bona Gomora haridia na didika bona edia kara havara danu na babada heherea dainai, ");
INSERT INTO meu_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","harihari vada baina diho, baina itadia, edia kara na unu haridia dikadia egu ai vada e kau heḡereḡeredia eiava lasi: baina diba ḡoevaḡoeva. ");
INSERT INTO meu_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Bena hari raruosi na e raka oho, Sodoma dalana ai ela; a Abraham na dounu Iehova vairanai gini. ");
INSERT INTO meu_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Bena Abraham na e raka kahira, e nanadaia, eto, O, kara maoromaoro taudia na kara dika taudia ida ba habuadia tari hebou a? ");
INSERT INTO meu_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Bema kara maoromaoro taudia imahui nonoho una hanua ai, ba habuaia tari a? Basio bogaia hisi, unu kara maoromaoro taudia imahui daidiai a? ");
INSERT INTO meu_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Kara maoromaoro taudia bona kara dika taudia na basio aladia bou ani? Kara maoromaoro taudia bona kara dika taudia ahudia bae tamona na dia oiemu kara ani? Tanobada idoinai ihahemaoro-henina Diravana basine kara maoromaoro a? ");
INSERT INTO meu_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Bena Iehova eto, Sodoma lalonai kara maoromaoro taudia imahui baina davaridia, hanua idoinai baina bogaia hisi idia daidiai. ");
INSERT INTO meu_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Bena Abraham ma e hereva, eto, Lau na ḡahu kavakava mo, to lalogu vada na ha-aukaia Ḡaubada iherevahenina: ");
INSERT INTO meu_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","readia kara maoromaoro taudia hariahui ima mo nonoho; o, hanua idoinai ba habuaia tari, ima mo lasi dainai a? Iehova eto, Hari-ahui ima baina davaridia, hanua na basina habuaia tari. ");
INSERT INTO meu_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ia na ma eto, Readia hari-ahui nonoho dahaka. Iehova eto, Hari-ahui daidiai baina bogaia hisi. ");
INSERT INTO meu_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ma eto, Ḡaubada e, baina noinoi lou basio badu ani? Toi-ahui bema noho ede bema heto? Iehova eto, Toi-ahui baina davaridia, basina habuaia tari. ");
INSERT INTO meu_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ma eto, Lalogu vada na ha-aukaia, Ḡaubada ihereva-henina: ruahui bema noho, ede bema heto? Iehova eto, Ruahui daidiai baina bogaia hisi. ");
INSERT INTO meu_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ma eto, Ḡaubada e, basio badu, ina nega tamona mo ma baina noinoi: gwauta hona bema noho, ede bema heto? Iehova eto, Gwauta daidiai baina bogaia hisi. ");
INSERT INTO meu_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Iehova na Abraham ida e hereva-hereva vaitani, bena ena dala e raka lao, a Abraham na ena noho gabuna e lou henia. ");
INSERT INTO meu_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Aneru raruosi na Sodoma ai e kau, dina kerekerena ai. Lot na hanua ikoukouna ai e helai, bena e itadia negana ai na vairadiai e heau, tano ai e goru diho, ");
INSERT INTO meu_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","eto, Egu lohia e, lau, emui hesiai tauna, egu ruma ai mani a dae kau, ba noho rani, aemui danu ba huri; bena daba ai ba tore isi, emui dala ai ba raka. Idia eto, Lasi; hanua ariarana ai baia noho rani. ");
INSERT INTO meu_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","To e noidia goadagoada, bena idia na ia ida e dae kau, ena ruma ai e raka vareai. Bena ia ese aniani e nadua, bona flaoa kavakava, se hatubua ḡauna, e gabua, e dabara, bena raruosi e ani. ");
INSERT INTO meu_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Idia na do asie hekure ai, hanua taudia kikina-badana, hari Sodoma taudia, hanua kahadia iboudiai amo e heau bou heau bou ela, ruma na e ginia hegege. ");
INSERT INTO meu_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Bena idia ese Lot e boi henia, eto, Hari hanuaboi emu ruma ai e dae kau taudia be edeseni ai? Ba hakaudia lasi; baia dibadia. ");
INSERT INTO meu_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Bena Lot na iduara amo e raka lasi bona iduara e koua ia murinai; ");
INSERT INTO meu_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","bena e hamaorodia, eto, Tadikakagu e, ina kara dikana basio karaia. ");
INSERT INTO meu_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","A itaia, natugu raruosi nonoho, ulato rami-hebou: mani aina hakaudia lasi emui ura heḡereḡerena ba kara henidia. A ini raruosi basio hadikadia, badina be egu guhi metaina ai e nohomu. ");
INSERT INTO meu_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","A idia eto. A gini siri. Ma eto, Ina tau sibona ema, bogaragidai e noho hedoamu: matona. baine hahemaoro henida e tomu. Harihari idia baia hadikadia maraḡi, a oi baia hadikamu bada. Bena idia ese Lot e doria siri, iduara bae taraia patapata eto. ");
INSERT INTO meu_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","To unu raruosi na ruma lalona amo imadia e toi roro, Lot e veria vareai, bena iduara e koua ahu. ");
INSERT INTO meu_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","A ariara ai e gini hebouva taudia kikina-badana na matadia e hakepuludia; bena iduara e tahua malakamalaka ela bona e hesiku. ");
INSERT INTO meu_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Bena hari raruosi ese Lot e nanadaia, eto, Varavaramu iboudiai bini eiava? Bema ravamu eiava natumu mamaruanedia eiava natumu hahinedia haida ina hanua ai nonoho, ina gabu amo ba hakaudia lasi. ");
INSERT INTO meu_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Badina be ina gabu baia habuaia tari, badina be haridia dika-hereadia na Iehova enai vada e kau, taunabunai Iehova ese vada e siaimai, baia habuaia tari. ");
INSERT INTO meu_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Bena Lot e raka lasi, ela, ravana, ia natuna hahinedia haida adavadia, e hereva henidia, eto, A tore tore isi, ina gabu aita rakatania, badina be Iehova ese ina hanua baine habuaia tari. To ravana banava ia e hevaseha henidia eto. ");
INSERT INTO meu_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Daba e rere, bena hari aneru ese Lot e haduaia goadagoada, eto, A tore isi haraḡa-haraḡa, adavamu bona natumu ulatodia raruosi bini avabidia, baola; ina hanua ihabua-tarina ai oi danu ba mase na garina. ");
INSERT INTO meu_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","E halahe, bena raruosi ese ia imana bona adavana imana bona natuna ulatodia raruosi imadia e abi, hanua murimurinai e hakaudia lasi; badina be Iehova ese e bogaia hisi. ");
INSERT INTO meu_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","E hakaudia lasi, bena eto, Ba heau mauri, basio roha muri, taora ai basio halahe. Ororo ba heau lao, ba mase na garina. ");
INSERT INTO meu_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Bena Lot ese e noidia, eto, Egu lohia e, dia unuheto. ");
INSERT INTO meu_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mani a itagu, emui hesiai tauna; vada o harihari henigu bona vada o bogagu hisi bona vada o hamaurigu. A lau na asi goadagu ororo baina heau henidia, hahedika ese baine ḡavagu tao, bena baina mase. ");
INSERT INTO meu_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","A una hanua na kahirakahira, baina heau henia diba; ia danu hanua maraḡina mo. Mani emui kara unu bainala. Ia na hanua maraḡina ani? Bena mauri baina davaria. ");
INSERT INTO meu_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Bena Iehova eto, Emu noinoi tamona binai ma na abia daemu; hari o noilaiamu hanuana na basina habuaia tari. ");
INSERT INTO meu_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ba lao henia haraḡa; badina be ḡau ta basina karaia diba ela bona oi na unuseni ai ba kau. Una dainai una hanua ladana e hatoa Soara. ");
INSERT INTO meu_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Dina e taolara ai Lot na Soara ai e kau. ");
INSERT INTO meu_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Bena Iehova ese nadi siahudia bona lahi na guba amo e hadiho, Sodoma bona Gomora latadiai. ");
INSERT INTO meu_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Unu hanua ruaosi, bona una taora idoinai, bona hanua taudia, bona taora ai e vara ḡaudia, ibouboudiai ia ese a habuadia tari. ");
INSERT INTO meu_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","A Lot adavana e roha muri, bena ia na damena nadina ai e hahelao. ");
INSERT INTO meu_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Una daba ai Abraham e tore isi, Iehova ida e hereva-hereva gabuna e raka henia; ");
INSERT INTO meu_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","e roha lao, Sodoma bona Gomora bona taora idoinai e ita, una tano idoinai ai kwalahu e daeva, amu kwalahuna na heto. ");
INSERT INTO meu_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Unuhetomana, taora hanuadia e habua tari negana ai, Dirava ese Abraham e laloa, bona Lot e hamauria, e noho kau heni hanuadia e habua tari negana ai. ");
INSERT INTO meu_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Bena Lot na Soara e rakatania, ororo e dara dae, unuseni ai e nohova, natuna ulatodia raruosi ida; badina be Soara ai baine noho na garina e gariva. Ia mai natuna ulatodia raruosi ida kohua ta ai e nohova. ");
INSERT INTO meu_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Bena hane guna ese tadina e hamaoroa, eto, Tamada e burukamu, bona asi tauna ta tanobada ai baine adavada tanobada ena kara heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Aitala, tamada na vine ranuna amo baita hakekeroa, bena ia ida baita eno bou, tamada ena amo natuda baita abidia. ");
INSERT INTO meu_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Bena una hanuaboi vine ranuna amo tamadia e hakekeroa, bena hane guna na ia ida e eno bou; a ia be ena hekure negana bona ena toreisi negana asi dibana. ");
INSERT INTO meu_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Daba ai, hane guna ese tadina e hamaoroa, eto, Boi hanuaboi lau na tamagu ida na eno bou; hari hanuaboi ma baita hakekeroa lou, bena oi danu ia ida ba eno bou; bena ita raruosi na tamada ena amo natuda baita abidia. ");
INSERT INTO meu_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Bena una hanuaboi danu idia ese tamadia e hakekeroa; bena hane muritai na ia ida e eno bou; a ia be ena hekure negana bona ena tore isi negana asi dibana. ");
INSERT INTO meu_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Taunabunai Lot natuna ulatodia raruosi na tamadia ese e harogorogodia. ");
INSERT INTO meu_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Bena hane guna na mero ta e abia, ladana e hatoa Moab; Moab besena taudia iboudiai ema bona harihari senedia na ia. ");
INSERT INTO meu_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Hane muritai danu mero ta e abia, ladana e hatoa Ben-ami; Amono besena taudia iboudiai ema bona harihari senedia na ia. ");
INSERT INTO meu_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Una negana ai, Abraham na e tore isi, eha laolao, diho kahana ela, Gerara ai e noho, Kade bona Suru padadiai. ");
INSERT INTO meu_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Bena Abraham ese Sara e herevalaia, eto, Ia na taihugu. Bena Abimelek, Gerara pavapavana, ese e abia. ");
INSERT INTO meu_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Bena Dirava ese Abimelek e hahedinarai henia nihi ai, eto, A kamonai: oi na mase tauna, hari o abia hahinena dainai, badina be ia na tau ta adavana. ");
INSERT INTO meu_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","A Abimelek na hahine do se raka henia kahi. Bena ia eto, Ḡaubada e, kara maoromaoro besena ba hamasea a? ");
INSERT INTO meu_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Hari tau ese e hamaorogu, eto “Ina na lau taihugu”, ani? Bona hahine ese danu e hamaorogu, eto “Ia na lau taihugu”. Mai lalogu maoromaorona bona mai imaḡu ḡoevaḡoevadia ida ina kara vada na karaia. ");
INSERT INTO meu_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Bena Dirava ese nihi ai e haere henia, eto, Lau dibagu oi na mai lalomu maoromaorona ida vada o karaia. Lau danu vada na rumu, vairagu ai ba kerere na garina; una dainai na laomu ahu, so raka henia kahi. ");
INSERT INTO meu_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Taunabunai, una tau adavana ba henia lou, badina be ia na peroveta tauna; bena ia ese oi daimu ai baine ḡuriḡuri. bena ba mauri. A basio henia lou, ba diba momokani vada ba mase, oi bona emu ruma taudia iboudiai. ");
INSERT INTO meu_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Taunabunai Abimelek na daba vaburana ai e tore isi, ena hesiai taudia iboudiai e boiridia, unu ḡau e hamaoro-laidia: bena gari ese e butudia tao. ");
INSERT INTO meu_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Bena Abimelek ese Abraham e boiria, eto, Ede vada o karamai toma? Ede na hadikamu toma dainai lau bona egu basileia ini vada o hakereremai toma? Hegwau-tao karana ta vada o kara henigu. ");
INSERT INTO meu_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelek ese Abraham ma e nanadaia, eto, Dahaka dainai ina kara vada o karaia? ");
INSERT INTO meu_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Bena Abraham e haere, eto, Badina be na laloa nato ina gabu ai Dirava imatauraina na lasi, bena adavagu dainai bae alagu nato. ");
INSERT INTO meu_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Bona ina danu, ia na momokani lau taihugu: tamamai na tamona, a sinamai be idau; bena raruosi a headava. ");
INSERT INTO meu_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","A Dirava ena hahedua dainai, tamagu ena ruma na rakatania negana ai lau ese na hamaoroa, nato, Ini ba bogagu hisi toma: baita lao heni gabudia iboudiai ba herevalaigu, baoto “Ia na lau taihugu”. ");
INSERT INTO meu_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Bena Abimelek ese mamoe bona boromakau bona hesiai taudia bona hesiai hahinedia na Abraham e henia; bena ia adavana Sara e henia lou. ");
INSERT INTO meu_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelek danu eto, A itaia, egu tano idoinai na oi vairamu ai; emu ura gabuna ba noholaia. ");
INSERT INTO meu_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ia ese Sara danu e hamaoroa, eto, A itaia, silver monidia daha-ta oi taihumu vada na henia, emu hemarai iabi-ohona taunimanima iboudiai vairadiai; iboudiai vairadiai bae gwauraimu maoro. ");
INSERT INTO meu_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Bena Abraham ese Dirava e ḡuria; bena Dirava ese Abimelek e hamauria, bona adavana bona ena hesiai hahinedia danu e hamauridia, bena natudia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Badina be Iehova ese Abimelek ena ruma hahinedia iboudiai vada e hagabanidia, Sara, Abraham adavana, dainai. ");
INSERT INTO meu_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Bena Iehova ese Sara e vadivadi henia bona ena gwau-hamata heḡereḡerena e kara henia. ");
INSERT INTO meu_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Bena Sara e rogorogo, e mara, mero ta e abia Abraham ena, edia ḡauka negana ai, Dirava ese e gwauraia guna heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Bena Abraham ese natuna, Sara e abia merona, ladana e hatoa Isaak. ");
INSERT INTO meu_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Dina ihataurahanina ai, Abraham ese natuna Isaak e peritomea, Dirava ese e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham ena maun laḡanidia na sinahu-ta, natuna Isaak e vara negana ai. ");
INSERT INTO meu_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Bena Sara eto, Dirava ese egu kiri badina vada e havaraia; harina bae kamonai taudia iboudiai na lau ida baia kiri hebou. ");
INSERT INTO meu_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ma eto, Daika ese Abraham bema hamaoroa, bema toma Sara ese natuna baine ubua? Gau tamona, iahuna ai natuna vada na henia. ");
INSERT INTO meu_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mero na e bada oho bada oho ela bona rata e negea; bena Abraham ese aria badana e karaia, Isaak ese rata e negea dinana ai. ");
INSERT INTO meu_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Bena Sara ese Hagara, hane Aigupto, natuna, Abraham ese e havaraia merona, e itaia, ia ese Isaak e kirikirilaia. ");
INSERT INTO meu_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Bena ia ese Abraham e hamaoroa, eto, Hesiai hahinena mai natuna ida a luludia, badina be ina hesiai hahinena natuna na oi dihimu ai basinela, natugu Isaak ida. ");
INSERT INTO meu_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Bena Abraham lalona e hisihisi bada, natuna dainai. ");
INSERT INTO meu_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","A Dirava ese Abraham e hereva henia, eto, Lalomu basine hisihisi ina mero dainai bona emu hesiai hahinena dainai. Sara ena hereva iboudiai bavabi dae, badina be Isaak ena amo oi besemu do baine vara. ");
INSERT INTO meu_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","A hesiai hahinena natuna danu bese badana ai baina halaoa, badina be ia na oi natumu. ");
INSERT INTO meu_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Daba matana ai Abraham na e tore isi, lagwa e abia, bona ranu danu nani kopina ai, Hagara e henia; ia na paḡana ai e atoa, bona mero danu; bena e siaia lao. Bena hahine na vada ela, Bere-sieba tano ḡaḡaena ai ehaloa. ");
INSERT INTO meu_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ranu na nani kopina na vada e ore ai, ia ese mero maraḡina e abia, au maraḡina ta henunai e atoa diho; ");
INSERT INTO meu_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","bena taina e raka lao, diba bema kinoa heḡereḡerena; bena tano ai e helai diho, e tai dikadika, eto, Mero ena mase basina itaia. ");
INSERT INTO meu_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Dirava ese mero gadona e kamonai, bena Dirava ena aneru ta ese guba amo Hagara e boi henia, eto, Hagara e, oi na edeheto? Asio gari, badina be Dirava ese mero gadona vada e kamonai. ");
INSERT INTO meu_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","A tore isi, mero na avabia isi, imamu ai ba dogoa tao, badina be lau ese bese badana ai baina halaoa. ");
INSERT INTO meu_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Bena Dirava ese matana e hapapa; bena ia ese ranu gurina ta e itaia; bena nani kopina e hahonua, mero na ranu e ha-inulaia. ");
INSERT INTO meu_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Dirava ese mero na e reḡua. Ia na e bada oho bada oho, tano ḡaḡaena ai eha noho; ia na taraki-taraki e diba ḡoeva. ");
INSERT INTO meu_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ia na Paran tano ḡaḡaena ai e nohova; bena sinana ese Aigupto hane-ulatona ta e abia, ia baine adavaia. ");
INSERT INTO meu_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Una negana ai Abimelek bona Fikol, ena tuari oreana biaguna, ese Abraham e hamaoroa, eto, Vada name diba Dirava ese e bamomumu emu kara iboudiai lalodiai. ");
INSERT INTO meu_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Taunabunai, Dirava ladana ai ba gwau henigu hamata, oi na basio koigu, bona natugu bona tubugu basio koidia; a lau ese vada na kara namo henimu heḡereḡerena oi danu lau ba kara namo henigu bona ina o noholaiamu tanona danu ba kara namo henia. ");
INSERT INTO meu_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Bena Abraham eto, Vada baina gwau hamata. ");
INSERT INTO meu_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","A Abraham ese Abimelek e gwau henia, Abimelek ena hesiai taudia ese ranu gurina ta e abia havara dainai. ");
INSERT INTO meu_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Bena Abimelek eto, Asi dibagu daika ese unu e kara toma; oi ese so hamaorogu bona asi dibagu ema bona hari dina. ");
INSERT INTO meu_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Bena Abraham ese mamoe bona boromakau e abidia, Abimelek e henia; bena idia raruosi e herohemaino. ");
INSERT INTO meu_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Bena Abraham ese mamoe natudia hitu e abidia, kaha ta ai e atodia tabe. ");
INSERT INTO meu_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelek ese Abraham e nanadaia, eto, Ene mamoe natudia hitu kaha ta ai o atodia tabe be dahaka? ");
INSERT INTO meu_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham e haere, eto, Ini egu mamoe natudia hituosi avabi, lau ese ina ranu gurina na ḡeia toana. ");
INSERT INTO meu_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Bena una gabu ladana e hatoa Bere-sieba, badina be raruosi unuseni ai e gwau hamata heheni. ");
INSERT INTO meu_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Taunabunai, idia raruosi na Bere-sieba ai e herohemaino; bena Abimelek bona Fikol, ena tuari oreana biaguna, e lou lao, Filistia tanona ela. ");
INSERT INTO meu_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","A Abraham ese au helaḡana ta e hadoa Bere-sieba ai, bona Iehova, Noho-hanaihanai Diravana, ladana e hahanea. ");
INSERT INTO meu_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Bena Abraham na nega daudau Filistia tanona ai e noho hedoa. ");
INSERT INTO meu_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Unu ḡau muridiai, Dirava ese Abraham e diba-ḡania, eto, Abraham e! Ia eto, Lau o ina. ");
INSERT INTO meu_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Dirava eto, Oi natumu bavabia, natumu vara-edeana, o lalokau heniamu merona, Isaak. Moria tanona baola, bena baina hamaorolaimu ororona dorina ai boubou ḡauna ai, lahi ese baine ḡolea oho ḡauna ai, ba halaoa. ");
INSERT INTO meu_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Daba matana ai, Abraham na e tore isi, ena doniki e abia, ena hesiai memerodia rarua bona natuna Isaak danu e abidia. Boubou lahina audia e siri vaitani, bena e tore isi, Dirava ese e gwauraia gabuna ela. ");
INSERT INTO meu_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Dina ihatoina ai Abraham ese matana e roha isi, gabuna na dauhai e itaia. ");
INSERT INTO meu_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Bena Abraham ese ena memero e hamaorodia, eto, Umui raruosi doniki ida ba noho iniseni ai, a lau be ina mero ida baiala, raruosi baia toma diho, gabeai baia lou mai dekemui ai. ");
INSERT INTO meu_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Bena Abraham ese boubou lahina audia e abi, natuna paḡana ai e ato kau, bona lahi bona kaia imana ai e abi; bena raruosi e raka hebou. ");
INSERT INTO meu_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Bena Isaak ese tamana Abraham e hereva henia, eto, Tamagu e! Tau na e haere, eto, Natugu e, lau o ina. Mero na eto, Lahi bona au bini, a mamoe, lahi ese baine ḡolea oho ḡauna, be edeseni ai? ");
INSERT INTO meu_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham e haere, eto, Natugu e, mamoe lahi ese baine ḡolea oho ḡauna na Dirava sibona ena amo baita abia. Bena raruosi ma e raka lao. ");
INSERT INTO meu_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Raruosi na Dirava ese e gwauraia gabuna ai e kau: unuseni ai Abraham ese boubou patana e larebaia, au pata latanai e lakwaia; bena natuna Isaak e hiria, boubou patana ai e atoa kau, au latadiai. ");
INSERT INTO meu_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Bena Abraham ese imana e toia roro, kaia e abia, natuna vada aine alaia mase eto. ");
INSERT INTO meu_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","A Iehova ena aneru na guba amo e boi dobi, eto, Abraham e, Abraham e! Ia na e haere, eto, Lau o ina. ");
INSERT INTO meu_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ia eto, Imamu mero latanai asio atoa kau, kara ta danu asio karaia ienai; badina be lau harihari name diba oi ese Dirava garina o garimu; badina be natumu vara-edeana egu ai to ruava. ");
INSERT INTO meu_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Bena Abraham ese matana e roha isi, e roha muri, mamoe maruanena ta doana au ai e hedoa dae e itaia. Bena Abraham na ela, mamoe maruanena e abia, boubou ḡauna ai e halaoa, natuna ibodohilaina. ");
INSERT INTO meu_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Bena Abraham ese una gabu ladana e hatoa Iehova-ire; bena unu e gwauraia toma ema bonaharihari e tomu, Ororo dorina ai Iehova ese baine haḡeregu. ");
INSERT INTO meu_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Iehova ena aneru ese Abraham ma e hereva henia lou, guba amo ma e boi dobi, ");
INSERT INTO meu_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","eto, Iehova na e tomu: sibogu ladagu ai vada na gwau hamata, ini vada o kara toma dainai, natumu vara-edeana, o lalokau heniamu merona, egu ai so rua dainai, ");
INSERT INTO meu_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","lau ese baina hanamomu badabada, oi garamu baina hahutumadia, guba hisiudia bona kone mirina na heheto; oi garamu ese bae inai henidia taudia edia tano bae abihaidia, ");
INSERT INTO meu_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","oi garamu daidiai tanobada besedia iboudiai baina hanamodia, badina be oi ese lau eregu o kamonai. ");
INSERT INTO meu_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Bena Abraham na ena hesiai memerodia raruosi dekedia e lou lao; hahaniosi e lou ela Bere-sieba, Abraham ena noho gabuna bunai. ");
INSERT INTO meu_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Unu ḡau muridiai, Abraham ese hari ta e kamonai, tadina Nahoro adavana Milka ida natudia vada e vara. ");
INSERT INTO meu_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Tau guna ladana na Usu; ia tadina be Busu bona Kemuel, Aram tamana, ");
INSERT INTO meu_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","bona Kesed bona Haso bona Pilidasa bona Idilapa bona Betuel. ");
INSERT INTO meu_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Hari Betuel na Rebeka tamana. Taurahaniosi bini Abraham tadina Nahoro, adavana Milka ida, natudia. ");
INSERT INTO meu_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ena hesiai hahinena Reuma ese danu natuna e havaradia: ladadia na Teba bona Gaham bona Tahasa bona Maaka. ");
INSERT INTO meu_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara ena mauri laḡanidia iboudiai na sinahu-ta ruahui hitu. ");
INSERT INTO meu_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sarana Kiriat-araba ai eha mase: una hanua na Kanaan tanona ai, ladana ta be Heberon. Abraham na ruma ai e raka vareai, Sara taina e tai. ");
INSERT INTO meu_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Bena Abraham na mase rumana amo e diho, Hiti taudia e hamaorodia, eto, ");
INSERT INTO meu_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Lau na umui bogaragimui ai na noho hedoamu; tano ta mani a henigu, egu gara gabuna ai bainela, unuseni ai egu mase baina guria. ");
INSERT INTO meu_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Bena Hiti taudia ese e haere henia, eto, ");
INSERT INTO meu_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Ḡauka e, oi na lohia badana, ai bogaragimai ai; emai gara gabudia ai gabu herea-daena ta bavabia, emu mase ba guria; ai ta ese ena gara gabuna basine rua oiemu ai. ");
INSERT INTO meu_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Bena Abraham e tore isi, una tano taudia, Hiti taudia, vairadiai e igo diho; ");
INSERT INTO meu_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","e hamaorodia, eto, Lalomui bema heḡereḡere egu mase iniseni ai bama guria, Efron Sohara boma noia daigu ai: ");
INSERT INTO meu_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ia ese Makapela kohuana, ena tano hetoana ai, bema henigu. Davana korikori baina henia, egu gara gabuna ai baina halaoa. ");
INSERT INTO meu_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Hari Efron na Hiti taudia bogaragidiai e helaiva. Bena Efron, Hiti tauna, ese Abraham e haere henia, Hiti taudia vairadiai bona ena hanua taudia iboudiai vairadiai, eto, ");
INSERT INTO meu_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Ḡauka e, lasi; una tano mai kohuana ida baina henimu; egu bese taudia iboudiai vairadiai vada baina henimu, emu mase iguridia gabuna ai bainela. ");
INSERT INTO meu_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Bena Abraham ese una gabu taudia vairadiai e igo diho. ");
INSERT INTO meu_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Bena Abraham ese Efron e hereva henia, una gabu taudia vairadiai, eto, Mani a hakala henigu: una tano davana mani aina henimu; avabia, bena egu mase unuseni ai baina guria. ");
INSERT INTO meu_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Bena Efron ese Abraham e haere henia, eto, ");
INSERT INTO meu_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Ḡauka e, a kamonai: una tano davana na silver sekeledia sinahuhani. Ita raruosi padadai una na ḡau ta a? Emu mase unuseni ai ba guria. ");
INSERT INTO meu_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham ese Efron ena hereva e kamonai, Hiti taudia vairadiai tano davana unu e gwauraia toma, bena silver sekele dia sinahu-hani, idia edia sekeleheḡereḡeredia, e henia. ");
INSERT INTO meu_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Taunabunai Efron ena tano Makapela ai, Mamare badinai, mai kohuana bona mai auna iboudiai na ");
INSERT INTO meu_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Abraham ena tano korikori ai ela. Hiti taudia vairadiai bona ena hanua lalonai e hebouva taudia iboudiai vairadiai e hoia. ");
INSERT INTO meu_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Bena Abraham ese ia adavana Sara e guria, Makapela kohuana lalonai, Mamare badinai. Una gabu na Heberon, Kanaan tanona ai. ");
INSERT INTO meu_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Una tano bona una kohua be Abraham ese e abi vaitani, Hiti taudia edia amo. ");
INSERT INTO meu_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham vada e buruka: ena mauri laḡanidia na diaḡau. Bona Iehova ese vada e harihari henia, ḡau momo momo vada e henia. ");
INSERT INTO meu_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Bena Abraham ese ena hesiai tauna badana, ena kohu idoinai e reḡuava tauna, e haduaia, eto, Imamu na mamugu ai bavatoa kau, ");
INSERT INTO meu_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Iehova, guba Diravana bona tanobada Diravana, ladana ai ba gwau hamata, natugu Isaak adavana na ini Kanaan taudia, bogaragidiai na noho hedoamu taudia, natudia ulatodia ta basio abia; ");
INSERT INTO meu_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","a egu tano korikori baola, varavaragu dekediai, unuseni ai natugu Isaak adavana bavabia. ");
INSERT INTO meu_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Bena una hesiai tauna e haere henia, eto, O, hane-ulato na reana lalona basine heḡereḡere lau baine bamogu ina tano baiama; unu bema heto, oi natumu bama hakaua lao, o rakatania tanona baiala, namo eiava? ");
INSERT INTO meu_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham ma eto, Lasi vaitani, natugu na basio laohaia, una tano na basinela. ");
INSERT INTO meu_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Iehova, guba Diravana, ese tamagu ena ruma amo e abigu oho, egu tano korikori amo e hakaugu lasi, bona e gwau henigu hamata, eto “Ina tano na oi garamu baina henidia”; bena ia ese ena aneru oi vairamu ai baine siaia, bena natugu adavana una tano ai do bavabia. ");
INSERT INTO meu_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","A hane-ulato bema gwau edeede, basinema bamomu, emu gwau-hamata bema heruha. Ḡau tamona, natugu na basio laohaia, unu basiola. ");
INSERT INTO meu_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Bena hesiai tauna ese imana na Abraham mamuna ai e atoa kau, e gwau henia hamata, unu baine kara toma eto. ");
INSERT INTO meu_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Bena una hesiai tauna na biaguna ena kamelo gwauta e abidia, bona kohu namodia haida danu, biaguna ena, e abi. Bena e tore isi, eha laolao, Mesopotamia tanona ela, hanua ta ladana Nahoro ai eha kau. ");
INSERT INTO meu_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Bena adorahi ai, hahine na ranu utu ela negana ai, ia ese kamelo e hahekuredia ranu gurina badibadinai, una hanua murimurina kahana ai. ");
INSERT INTO meu_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Bena e ḡuriḡuri, eto, Iehova e, biagugu Abraham ena Dirava e, na noimumu, hari ina dina ai egu ḡaukara ba hanamoa, bona biagugu Abraham ba bogaia hisi. ");
INSERT INTO meu_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ame itagu, lau binai ranu gurina badibadinai na nohomu; a hanua ulatodia na ranu utu be maimu. ");
INSERT INTO meu_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Na noimumu, hane-ulato ta baina hamaoroa, bainato “Emu hodu bavatoa diho, ranu kuri ta ba henigu, baina inua”, bena ia baineto “Madi ba inua; emu kamelo danu baina ha-inulaidia”, haneulatona bunai oiemu. abi-hidi ulatona, emu hesiai tauna Isaak ba henia ulatona mo. Unu amo baina diba oi na biagugu vada o bogaia hisimu. ");
INSERT INTO meu_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ena ḡuriḡuri do se ore ai, hane-ulato ta ladana Rebeka ena hodu e ehea ema. Ia na Betuel natuna; tubuna hahinena na Milka, Abraham tadina Nahoro adavana. ");
INSERT INTO meu_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ia na haneulato rami-hebou namo-hereana: tau ta ese do se adavaia. Ia na guri ela, ena hodu e hahonua, ma ema. ");
INSERT INTO meu_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Bena hari hesiai tauna e heau ela, e hereva henia, eto, Emu hodu ranuna kuri ta mani aina inua. ");
INSERT INTO meu_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Hane-ulato na eto, Ḡauka e, a inua. Bena ranu e seia, e ha-inulaia. ");
INSERT INTO meu_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ma eto, Ranu ma aina utu, emu kamelo baina ha-inulaidia. ");
INSERT INTO meu_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Bena ena hodu ranuna orena na dihu-lata lalonai e seia, bena ranugurina ma e loulou henia ela bona kamelo iboudiai e ha-inulaidia vaitani. ");
INSERT INTO meu_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Hari hesiai tauna ese e raraia tao, se hereva, baine diba eto, Iehova ese ena laolao anina vada e havaraia eiava. ");
INSERT INTO meu_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Bena ena kamelo na ranu e inu vaitani murinai, ia ese gold gadeina ta, metauna na sekele kahana, bona gold vaḡivaḡidia rua, metaudia na sekele gwauta, e vai. ");
INSERT INTO meu_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","E nanadaia, eto, Oi be daika natuna? Tamamu ena ruma na mai gabuna, ai baia noho, eiava? ");
INSERT INTO meu_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Hane-ulato na e haere, eto, Lau na Betuel natuna; tubugu hahinenana Milka, Nahoro adavana. ");
INSERT INTO meu_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ma eto, Uit momona bona rei kakoro momo dekemai ai mimia, emui mahuta gabuna ta danu mia. ");
INSERT INTO meu_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Bena hari hesiai tauna e igo diho, Iehova e imodaia, ");
INSERT INTO meu_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","eto, Iehova, biagugu Abraham ena Dirava, na imodaiamu; ena hebogahisi bona ena momokani biagugu enai vada e hesiriumu, taunabunai ia ese egu dala ai vada e hakaugu maoro, ema bona biagugu varavarana edia ruma. ");
INSERT INTO meu_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Bena hane-ulato na e heau ela, unu ḡau haridia na sinana ena rumataudia e hamaorolaidia. ");
INSERT INTO meu_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Hari Rebeka na mai taihuna ta, ladana na Laban; bena ia na e raka lasi haraḡa, una tau dekena ela, ranu gabuna ai. ");
INSERT INTO meu_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Ia ese taihuna Rebeka ena gadei bona imana vaḡivaḡidia e ita, bena e raka lasi, hari ranu gabuna ai ena kamelo e naridiava tauna dekena ela. ");
INSERT INTO meu_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Bena e hereva henia, eto, Iehova ese vada e hanamomu taumu e, mani a dae kau. Dahaka dainai murimuri ai o nohomu? Badina be egu ruma vada na lailaia, bona kamelo edia gabu danu. ");
INSERT INTO meu_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Bena una hesiai tauna na ruma ai e raka vareai. A Laban ese kamelo edia maduna e ruha, bena uit momona bona rei kakoro e henidia; bona hesiai tauna ranu e henia, ia mai bamona ida aedia bae huri. ");
INSERT INTO meu_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Bena aniani e dabaraia ia vairanai; to ia eto, Basina aniani ela bona egu laolao badina aina gwauraia guna. Idia eto, A hereva. ");
INSERT INTO meu_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Bena ia eto, Lau na Abraham ena hesiai tauna. ");
INSERT INTO meu_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Iehova ese biagugu vada e hanamoa badabada, lohia badana ai vada e halaoa; mamoe seridia bona boromakau seridia vada e henia, bona silver bona gold, bona hesiai taudia bona hesiai hahinedia, bona kamelo bona doniki. ");
INSERT INTO meu_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Biagugu adavana Sara na burukana ai natuna e abia; bena Abraham ese ia dihina ai vada e halaoa. ");
INSERT INTO meu_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Bena biagugu ese e haduagu baina gwau hamata; eto “Natugu adavana na Kanaan taudia, bogaragidiai na noho hedoamu taudia, natudia ulatodia ta basio abia, ");
INSERT INTO meu_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","a tamagu ena ruma baola, varavaragu bogaragidiai natugu adavana bavabia”. ");
INSERT INTO meu_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Bena biagugu na hamaoroa, nato “O hane-ulato na basine bamogu reana, bena ede baina heto?” ");
INSERT INTO meu_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Bena ia eto “Iehova, vairanai na rakamu Diravana, ese ena aneru baine siaia, baine bamomu bona emu dala baine lailaia; bena varavaragu bona tamagu ena ruma taudia bogaragidiai natugu adavana do ba davaria. ");
INSERT INTO meu_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Unu amo emu gwauhamata baine heruha, varavaragu dekediai ba kau negana ai; a idia na hane-ulato bema rua basiema henimu negana ai danu emu gwauhamata bema heruha”. ");
INSERT INTO meu_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Bena hari dina ai ranu gabuna ai na kau, bena na ḡuriḡuri, nato: Iehova e, biagugu Abraham ena Dirava, boma ura egu laolao anina namona boma havaraia, ");
INSERT INTO meu_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ini boma hamomokania toma: ina ranu gabuna ai na nohomu ai hane-ulato ta ranu utu bainema bena baina hereva henia, bainato “Emu hodu ranuna kuri ta a henigu, aina inua”, bena ia baineto ");
INSERT INTO meu_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","“Mani a inua, bona emu kamelo edia ranu danu baina utua”, baina diba hane-ulatona bunai, Iehova ese vada e abia hidi biagugu natuna baine adavaia ulatona. ");
INSERT INTO meu_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Bena dounu na ḡuriḡuriva ai, Rebeka na hodu e ehea ema; e diho ela, guri ai ranu e utua. Bena na hamaoroa, nato “Mani emu kara, ranu kuri ta a henigu, aina inua”. ");
INSERT INTO meu_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Bena ena hodu e atoa diho haraḡa, eto “A inua, bena emu kamelo edia ranu danu baina utua”. ");
INSERT INTO meu_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Bena na nanadaia, nato “Oi be daika natuna?” Bena ia e haere, eto “Lau na Betuel natuna; tubugu na Nahoro bona ia adavana Milka”. Bena gadei na udu-baubauna ai na atoa, bona vaḡivaḡi imana ai. ");
INSERT INTO meu_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Bena na igo diho, Iehova, biagugu ena Dirava, na imodaia, badina be ia ese e hakaugu maoro, biagugu tadina tubuna baina abia ia natuna baine adavaia helaoreana. ");
INSERT INTO meu_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Benaini, mani a hereva, biagugu ba bogaia hisi bona ihanamona karana ba karaia, eiava lasi; bena baina diba ede baina raka toma, idiba kahana amo eiava lauri kahana amo. ");
INSERT INTO meu_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Bena Laban bona Betuel e haere, eto, Ina na Iehova ena amo; ai na basia haere henimu diba, basiato “Oibe” eiava “Lasi.” ");
INSERT INTO meu_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","A itaia, Rebeka na vairamu ai gini: avabia, ba hakaua lao, biagumu natuna baine adavaia, Iehova ena hereva heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Abraham ena hesiai tauna una hereva e kamonai, bena tano ai e goru diho, Iehova e imodaia. ");
INSERT INTO meu_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Bena ia ese herahera ḡaudia, gold ḡaudia bona silver gaudia bona dabua e hulala, Rebeka e henia; taihuna bona sinana danu herahia ḡaudia namo-hereadia e henidia. ");
INSERT INTO meu_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Bena ia mai bamona ida e aniani, e inuinu, bena e mahuta. Daba ai e tore isi, eto, Mani a kahugu nege, biagugu baina lou henia. ");
INSERT INTO meu_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","A hane-ulato taihuna bona sinana eto, Hane-ulato na mani dekemai ai baine noho pura ta eiava dina gwauta, bena bainela. ");
INSERT INTO meu_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","A ia eto, Asio rugu: Iehova ese egu laolao anina vada e havaraia; mani a kahugu nege, biagugu baina lou henia. ");
INSERT INTO meu_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Bena idia eto, Hane-ulato aita boiria, ia baine hereva. ");
INSERT INTO meu_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Taunabunai, idia ese Rebeka e boiria, bena e nanadaia, eto, Lalomu vada eme heḡereḡere a, ina tau ida ba raka? Ia eto, Vada e heḡereḡere. ");
INSERT INTO meu_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Taunabunai taihudia Rebeka, mai ena hesiai hahinena ida e kahudia nege, Abraham ena hesiai tauna mai bamona ida danu. ");
INSERT INTO meu_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Idia ese Rebeka e hanamoa, eto, Taihumai e, daha daha oiemu amo bae vara: oi garamu ese inaidia do bae hadareredia. ");
INSERT INTO meu_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Bena Rebeka bona ena hesiai hahinedia e tore isi, kamelo ai e gui, hesiai tauna ida ela. Hari hesiai tauna ese Rebeka e hakaua lao. ");
INSERT INTO meu_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Una negana ai Isaak na diho kahana ai e nohova; bena tano gagaena ai eha laolao, ranu gurina ta, ladana Bere-lahai-roi, ela. ");
INSERT INTO meu_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Adorahi ta taora ai eha loaloa, dina kerekerena ai, bena e roha isi, kamelo e maiva e itadia. ");
INSERT INTO meu_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka danu e roha isi, Isaak e itaia; bena ena kamelo amo e diho, ");
INSERT INTO meu_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","hesiai tauna e nanadaia, eto, Una taora ai e maimu tauna be daika? Hesiai tauna eto, Biagugu bunai. Bena Rebeka ese dabua ta e abia, vairana e govaia ahu. ");
INSERT INTO meu_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Bena hesiai tauna ese ena kara idoinai Isaak e hamaorolaia. ");
INSERT INTO meu_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Bena Isaak ese Rebeka e hakaua lao, sinana Sara ena dabua rumana ai e hakaua vareai, e adavaia. Bena ia iura-henina ese lalona e hamarumarua, sinana taina e taiva negadia ai. ");
INSERT INTO meu_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham ese hahine ta ma e adavaia, ladana na Ketura. ");
INSERT INTO meu_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Natudia ia bogana amo e vara ladadia bini: Simuran bona Iokosan bona Medan bona Midian bona Isabak bona Sua. ");
INSERT INTO meu_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Iokosan ese Seba bona Dedan e havaradia. Dedan ese Asuri bona Letusi bona Leumi besedia e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian ese Efa bona Efere bona Hanok bona Abida bona Eldaha e havaradia. Ini iboudiai na Ketura garana. ");
INSERT INTO meu_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham ese Isaak na ia dihina ai e halaoa. ");
INSERT INTO meu_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","A adavana oredia natudia na maurina ai e harihari henidia, bena e siaidia karoho, mairiveina kahana ai bae hanoho. ");
INSERT INTO meu_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham ena mauri laḡanidia iboudiai na sinahu-ta hituahui ima. ");
INSERT INTO meu_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Bena Abraham e mase: ia na buruka herea, ena mauri laḡanidia na diaḡau; bena varavarana ediai eha hebou. ");
INSERT INTO meu_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Bena ia natuna raruosi, Isaak bona Ismael, ese e abia, Makapela kohuana ai e guria: una kohua na Mamare kahana ai, Efron Sohara, Hiti tauna, ena tano ai. ");
INSERT INTO meu_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Tanona bunai Abraham ese Hiti taudia edia amo e abia. Unuseni ai Abraham e guria, adavana Sara ida. ");
INSERT INTO meu_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham ena mase murinai, Dirava ese natuna Isaak e hanamoa. Isaak na Bere-lahai-roi ranu gurina badibadinai e nohova. ");
INSERT INTO meu_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ismael garana bini: ia na Abraham natuna, Sara ena hesiai hahinena Hagara, Aigupto hahinena, bogana amo. ");
INSERT INTO meu_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismael garana ladadia bini: natuna roboana na Nebaioto; ia murinai e vara taudia be Kedara bona Adabeel bona Mibisam ");
INSERT INTO meu_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","bona Misima bona Duma bona Masa ");
INSERT INTO meu_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","bona Hadad bona Tema bona Ieturu bona Nafisi bona Kedema. ");
INSERT INTO meu_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ismael natudia bunu: ladadia bunu edia hanua bona edia taruha ladadia e hato; idia gwautararuosi na hanua ta ta e halohiadia. ");
INSERT INTO meu_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael ena mauri laḡanidia na sinahuta toi-ahui hitu. E mase, varavarana ediai eha hebou. ");
INSERT INTO meu_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Edia tano na Havila ela bona Suru, Aigupto mairiveina kahana ai; tadikakadia iboudiai idia mo mairiveina kahana korikori ai e nohova. ");
INSERT INTO meu_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abraham natuna Isaak garana bini: ");
INSERT INTO meu_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaak ena vara laḡanidia na hari-ahui negana ai, ia ese Rebeka, Betuel tau Suria natuna, Laban tau Suria taihuna, e adavaia. Betuel na Padan-aram tauna. ");
INSERT INTO meu_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaak ese Iehova e noia, adavana dainai, badina ia na gabani. Iehova ese ena noinoi e kamonaia; bena Rebeka e rogorogo. ");
INSERT INTO meu_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Hekapa na ia bogana ai e hedavelai; bena ia eto, Ini e karagu tomamu be ede baina heto? Bena Iehova enai e henanadai. ");
INSERT INTO meu_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Bena Iehova ese e haere henia, eto, Iduhu rua na bogamu ai, Bese rua na oiemu amo bae vara; Ta ese ma ta baine hadarerea, Tau guna ese tau muritai isiaina baine lao heni. ");
INSERT INTO meu_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ena mara negana e gini dae, bena memero rarua e vara hekapa. ");
INSERT INTO meu_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","E vara guna merona na mia kakakaka, derana danu momo, dabua huika-huika na heto; ia ladana e hatoa Esau. ");
INSERT INTO meu_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Gabeai tadina e vara, bena ia imana ese Esau aena geduna e dogoa tao; bena ladana e hatoa Iakob. Isaak ena mauri laḡanidia na tauratoi-ahui, idia raruosi e vara negana ai. ");
INSERT INTO meu_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Memero raruosi na e bada oho bada oho. Esau na labana tauna mai aonegana, bona loaloa tauna; a Iakob na manada tauna bona konenoho tauna. ");
INSERT INTO meu_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaak ese Esau e lalokau heniava, badina be ena labana damudia e aniva; a Rebeka ese Iakob e lalokau heniava. ");
INSERT INTO meu_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Dina ta Iakob ese aniani e nadua; bena Esau na gunika amo e lasi mai manorina ida. ");
INSERT INTO meu_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esau ese Iakob e hereva henia, eto, Ena aniani kakakakana o naduamu na taina a henigu, aina ania, badina be e hitologu mase. Una dainai ia ladana ta e hatoa Edom. ");
INSERT INTO meu_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Iakob eto, Emu roboa ahuna na a henigu, aniani davana. ");
INSERT INTO meu_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau eto, Be, mokona ba masemu, roboa ahuna ese ede baine hanamogu toma? ");
INSERT INTO meu_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Iakob eto, A gwau hamata guna. Bena Esau e gwau hamata, roboa ahuna Iakob e henia, aniani davana. ");
INSERT INTO meu_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Bena Iakob ese flaoa bona vasiahu e henia; bena ia na e aniani, e inuinu danu. Bena e tore isi, e raka lasi. Esau ese ena roboa ahuna unu e dadaraia toma. ");
INSERT INTO meu_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Doe bada e vara una tano ai, Abraham ena nega ai heḡereḡerena. Bena Isaak e tore isi, Gerara ela, Abimelek, Filistia pavapavana, dekena. ");
INSERT INTO meu_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Bena Iehova ese ienai e hedinarai, eto, Aigupto basiola; baina hadibalaimu tanona ai ba noho. ");
INSERT INTO meu_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ina tano ai ba noho, bena lau baina bamomu bona baina hanamomu; badina be ini tano idoidiai oi baina henimu bona oi garamu baina henidia, oi tamamu Abraham na gwau henia hamata heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Oi garamu danu baina hahutumadia, guba hisiudia na heheto bae hutuma; oi garamu daidiai tanobada besedia iboudiai bae namo; ");
INSERT INTO meu_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","badina be Abraham ese lau eregu e kamonai, egu hahedua, egu haheḡani, egu taravatu, iboudiai e badinadiava. ");
INSERT INTO meu_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Taunabunai Isaak be Gerara ai e nohova. ");
INSERT INTO meu_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","A una gabu taudia ese ia adavana e nanadailaia, bena ia eto, Ia na taihugu. “Ia na adavagu” baineto na e gari, badina be ia eto, Ina gabu taudia na bae alagu mase readia, Rebeka dainai, badina ia na hahine namo-hereana. ");
INSERT INTO meu_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Nega daudau unu e noho tomava, bena dina ta Abimelek, Filistia pavapavana, gabamauru amo e igo lasi, Isaak adavana Rebeka ida e itadia, e sihari. ");
INSERT INTO meu_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Bena ia ese Isaak e gwau henia, eto, Lalogu vada eme parara, hahine na oi adavamu. Dahaka dainai oi oto “Ia na taihugu”. Isaak e haere henia, eto, Badina be na gari, haida ese ia dainai bae alagu mase na garina. ");
INSERT INTO meu_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Bena Abimelek eto, Oi na ede vada o karamai toma? Tau ta oi adavamu ida bema eno bou, iboumai ai baiama kerere oi daimu ai. ");
INSERT INTO meu_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Bena Abimelek ese ena hanua taudia taravadia e atu, eto, Isaak enai baine dau kau eiava adavana enai baine dau kau tauna na baine mase. ");
INSERT INTO meu_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaak ese aniani e hado matama una tano ai, bena una laḡani tamona lalonai anidia sinahu sinahu e abi; badina be Iehova ese e hanamoa. ");
INSERT INTO meu_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ia na taḡa tauna ai ela, ena taḡa danu e bada e laova; ");
INSERT INTO meu_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ena mamoe bona ena boromakau na hutuma herea, ena hesiai taudia danu hoho. Bena Filistia taudia ese e vaḡeḡe henia. ");
INSERT INTO meu_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Bena ranu guridia iboudiai Abraham ena nega ai ena hesiai taudia ese e ḡei na Filistia taudia ese e tahuni. ");
INSERT INTO meu_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Bena Abimelek ese Isaak e hamaoroa, eto, Ai emai amo a raka oho, badina be vada o hereamai. ");
INSERT INTO meu_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Bena Isaak na e raka oho, Gerara kourana ai e taruha, unuseni ai e nohova. ");
INSERT INTO meu_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Bena ranu guridia, tamana Abraham ena nega ai e ḡei bena Filistia taudia ese e tahuni, ia ese ma e gei lou; bona ladadia, tamana ese e hato heḡereḡeredia, ia ese ma e hato lou. ");
INSERT INTO meu_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isaak ena hesiai taudia danu koura ai guri e ḡei, bona ranu e lohilohiva gabuna ta e davana. ");
INSERT INTO meu_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Bena Gerara seridia ireḡudia taudia na Isaak ena seri ireḡudia taudia ida e heatu, eto, Ina na ai emai ranu. Taunabunai, ia ese una ranu gabuna ladana e hatoa Esek, badina be e heatulaia, ");
INSERT INTO meu_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Bena guri ta ma e ḡeia, to una danu e heatulaia, taunabunai ladana e hatoa Sitina. ");
INSERT INTO meu_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Unu amo ma e raka oho bena guri ta ma e ḡeia. Una na asie heatulaia; taunabunai ladana e hatoa Rehoboto; badina be ia eto, Iehova ese gabu ta vada e lailaia eda, iniseni ai baita noho namonamo. ");
INSERT INTO meu_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Unu amo ia na Bere-sieba ela. ");
INSERT INTO meu_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Bena una hanuaboi Iehova na ienai e hedinarai, eto, Lau na tamamu Abraham ena Dirava: basio gari, badina be lau ese na bamomumu; baina hanamomu bona garamu baina hahutumadia, egu hesiai tauna Abraham dainai. ");
INSERT INTO meu_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Bena boubou patana ta unuseni ai e larebaia, bona Iehova ladana e hahanea. Unuseni ai danu e taruha, bona ena hesiai taudia ese ranu gurina e ḡeia. ");
INSERT INTO meu_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelek na Gerara amo ema, ia bona turana ta Ahusata bona ena tuari oreana biaguna Fikol, tatoiosi Isaak dekena ema. ");
INSERT INTO meu_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Bena Isaak ese e hereva henidia, eto, O inai henigu bona o lulugu: harihari lau dekegu vada oma badina be dahaka? ");
INSERT INTO meu_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Idia eto, Lalomai vada e parara Iehova ese vada e bamomu, taunabunai ai na a tomu: baita herohemaino bona baita gwau hamata heheni, ");
INSERT INTO meu_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","oi ese basio hadikamai, ai he ḡereḡeremai, emu ai asia dau kau, kara namodia mo a kara henimu, bona mai mainomu ida a siaimu, harihari Iehova ese e hanamomumu. ");
INSERT INTO meu_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Bena Isaak ese aria e karaia: iboudiai e aniani hebou bona e inuinu hebou. ");
INSERT INTO meu_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Daba ai e gwau hamata heheni. Bena Isaak ese e siaidia lao, mai mainodia ida ela. ");
INSERT INTO meu_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Una dina ai Isaak ena hesiai taudia ia dekena ela, guri e geia herevana e hamaorolaia, eto, Ranu vada a davaria. ");
INSERT INTO meu_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Bena una ranu gabuna ladana e hatoa Siba, taunabunai una hanua ladana na Bere-sieba ema bona harihari. ");
INSERT INTO meu_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau ena mauri laḡanidia na hari-ahui, bena e headava, hahine rarua e abidia: Iuditi, Be-eri tau Hiti natuna, bona Basemata, Elon tau Hiti natuna. ");
INSERT INTO meu_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","A Isaak bona Rebeka lalodia na e hekwarahi unu hahine daidiai. ");
INSERT INTO meu_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaak na vada e ḡauka, matana danu e valahu-valahu, ḡau ta seitaia ḡoeva. Bena ia ese natuna roboana Esau e boiria, eto, Natugu o! Esau eto, Lau o ina. ");
INSERT INTO meu_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaak ma eto, Ame itagu, vada name buruka, egu mase dinana na asi dibagu. ");
INSERT INTO meu_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Taunabunai na noimumu, emu diba pauana bona emu peva bavabi, ba ha labana, dia ta bavalaia lauagu; ");
INSERT INTO meu_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","bena vamu namona lalogu ese e ura heniamu heḡereḡerena na ba nadua, dekegu ba mailaia; baina ania, bena do basina mase ai baina hanamomu guna. ");
INSERT INTO meu_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Hari Isaak ena hereva natuna Esau e hamaorolaia na Rebeka danu e kamonai. Bena Esau na eha labana, dia ta baine alaia, baine mailaia eto. ");
INSERT INTO meu_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Bena Rebeka ese natuna Iakob e hereva henia, eto, Tamamu ese kakamu Esau e hamaorolaia herevana na kamonai; ");
INSERT INTO meu_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","ia eto “Dia ta ba mailaia, vamu namona ba nadua lauagu; baina ania, bena do basina mase ai Iehova vairanai baina hanamomu guna”. ");
INSERT INTO meu_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Taunabunai, natugu e, eregu ba kamonai, baina haduamu heḡereḡerena mo ba karaia. ");
INSERT INTO meu_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Aola, nani serina ai nani natudia namodia rua bavabi, dekegu ba mailai; bena lau ese vamu namona ai baina halao tamamu ana, ia ese e ura heniamu ḡauna heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Bena vada ba laohaia tamamu dekenai; baine ania bena do basine mase ai baine hanamomu. ");
INSERT INTO meu_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Bena Iakob ese sinana Rebeka e haere henia, eto, Kakagu Esau na tauna mai derana, a lau kopigu be manada. ");
INSERT INTO meu_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Readia tamagu ese baine darahugu, baine dibagu koikoi taugu, bena baine uduguiraigu, basine hanamogu. ");
INSERT INTO meu_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Sinana eto, Heuduguirai na lau latagu ai baine mia: lau eregu a kamonai, aola, bavabi, dekegu ba mailai. ");
INSERT INTO meu_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Bena ia ese eha abidia, sinana dekena e mailai. Bena sinana ese vamu namona e nadua, tamana ese e ura henia ḡauna heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Bena Rebeka ese natuna roboana Esau ena dabua namona ta ruma ai mia na e abia, natuna tau-muritai Iakob e hadokilaia; ");
INSERT INTO meu_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","nani natudia kopidia danu imana ruaosi bona aiona e havavalai. ");
INSERT INTO meu_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Bena hari vamu bona flaoa e dabara, natuna Iakob e henia. ");
INSERT INTO meu_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Iakob na tamana dekena ela, eto, Tamagu e! Ia na e haere, eto, Lau o ina: natugu e, oi be daika? ");
INSERT INTO meu_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Iakob ese tamana e haere henia, eto, Lau binai Esau, natumu roboana, emu hahedua vada na badinaia; a helai tore, dia vada na alaia be bavania, bena ba hanamogu. ");
INSERT INTO meu_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Bena Isaak ese natuna e nanadaia, eto, Natugu e, ede o davaria haraḡa-haraḡa toma? Ia e haere, eto, Badina be Iehova emu Dirava ese e durugu. ");
INSERT INTO meu_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Bena Isaak ese Iakob e hamaoroa, eto, Natugu e, mani a raka kahi mai, baina darahumu oi na momokani lau natugu Esau eiava lasi. ");
INSERT INTO meu_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Bena Iakob na tamana Isaak dekena e raka kahi lao. Ia ese e darahua, bena eto, Gado be Iakob gadona, a ima be Esau imana. ");
INSERT INTO meu_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ia na toana asi dibana, badina be imana na huika-huika, kakana Esau imana na heto; taunabunai ia ese e hanamoa. ");
INSERT INTO meu_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Bena Isaak eto, Momokani, oi na natugu korikori Esau ani? Ia eto. Oibe. ");
INSERT INTO meu_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Bena Isaak eto, Mani a mailaia dekegu ai, natugu emu vamu baina ania, bena baina hanamomu. Taunabunai, ia ese e mailaia, bena e ania; vine ranuna danu e mailaia, bena e inua. ");
INSERT INTO meu_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Bena tamana Isaak ese e hamaoroa, eto, Natugu e, mani a raka kahi mai, ame harahugu. ");
INSERT INTO meu_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Bena ia na e raka kahi, e harahua. Isaak ese ena dabua bonana e kamonai, bena e hanamoa, eto, Inai! Natugu bonana na Iehova ese e hanamoa imeana na heto: ");
INSERT INTO meu_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Taunabunai guba hununa Dirava ese baine henimu, Bona tanobada digarana danu, Uit momo bona vine ranuna momo danu. ");
INSERT INTO meu_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Taunimanima ese oi isiaimu bae lao heni, Bese idau-idau be vairamu ai bae igo diho; Tadikakamu biagudia ai baola, Sinamu natuna be vairamu ai bae igo diho; Bae uduguiraimu taudia na do bae uduguiraidia, Bae hanamomu taudia na do bae hanamodia. ");
INSERT INTO meu_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaak ese Iakob ihanamona e hadokoa, Iakob danu Isaak vairana amo e raka lasi, asi vanahana kakana Esau na labana amo e lasi. ");
INSERT INTO meu_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ia danu vamu namona e nadua, tamana dekena e laohaia, tamana e hamaoroa, eto, Tamagu e, a helai tore, natumu egu vamu avania, bena ba hanamogu. ");
INSERT INTO meu_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Tamana Isaak ese e nanadaia, eto, Oi be daika? Ia e haere, eto, Lau binai natumu roboana Esau. ");
INSERT INTO meu_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Bena Isaak kudouna e hetaha, eto, Hari tau be daika, vamu eha abia, e mailaia dekegu ai, oi do toma ai na ania ore, bona vada na hanamoa danu? Momokani, ia ese hahenamo anina do baine abia. ");
INSERT INTO meu_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau ese tamana ena hereva e kamonai ai e tai, e tai lolololo, tamana e tai henia, eto, Lau danu, tamagu e, lau danu ame hanamogu. ");
INSERT INTO meu_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Tamana eto, Tadimu vada ema, mai ena koikoi, ihanamomu vada e dadia. ");
INSERT INTO meu_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau eto, Ia ladana e hatoa Iakob na mai anina ani? Badina be nega rua vada e bologu: roboa ahuna e abia guna, harihari ihanamogu danu vada e abia. Hahenamo ta dia mia lauegu a? ");
INSERT INTO meu_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaak ese Esau e haere henia, eto, Inai! Oi biagumu ai vada na halaoa, bona tadikakana iboudiai vada na henia, ena hesiai taudia ai baela; uit bona vine ranuna danu vada na gwaurai iena. Natugu e, dahaka baina karaia oiemu ai? ");
INSERT INTO meu_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Bena Esau ese tamana e hamaoroa, eto, Tamagu e, emu hahenamo be tamona mo a? Tamagu e, lau danu ame hanamogu. Bena Esau e tai dikadika. ");
INSERT INTO meu_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Bena tamana Isaak ese e haere henia, eto, Inai! tanobada digarana gabuna ai basio noho, Guba hununa atai amo e dihomu gabuna ai basio noho. ");
INSERT INTO meu_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","To emu dare goadana ai ba mauri. Tadimu isiaina ba lao heni; To negana baine gini dae emu siahu baine herea, Bena ena maduna na paḡamu amo ba negea daure. ");
INSERT INTO meu_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau ese Iakob e inai henia, tamana ena hahenamo dainai; bena lalona ai eto, Tamagu itai-taina dinadia be kahikahi; unu muridiai tadigu Iakob baina alaia mase. ");
INSERT INTO meu_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Haida ese Esau ena hereva Rebeka e hamaorolaia, bena Rebeka ese natuna tau-muritai Iakob e boiria, e hamaoroa, eto, A kamonai, kakamu Esau ese lalona e hadaiamu, baine alamu mase e tomu. ");
INSERT INTO meu_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Taunabunai, natugu e, eregu a kamonai: a tore isi haraḡa, Haran baola, taihugu Laban dekenai; ");
INSERT INTO meu_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","nega taina ia dekenai ba noho, ela bona kakamu lalona baine keru. ");
INSERT INTO meu_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ia na do baine laloa boio ede o karaia toma, bena ena badu do baine ore; una negana ai hereva baina siaia, bena ba lou mai. Umui raruosi dina tamona egu ai ba boio anina be dahaka? ");
INSERT INTO meu_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Bena Rebeka ese Isaak e hereva henia, eto, Name hesiku ini Hiti hahinedia daidiai. Iakob ese ini Hiti taudia natudia ina tano ai e nohomu ta baine adavaia, egu noho ede baine heto? ");
INSERT INTO meu_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Bena Isaak ese Iakob e boiria, e hanamoa, e hagania, eto, Kanaan taudia natudia ta basio adavaia; ");
INSERT INTO meu_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Padan-aram baola, tubumu Betuel ena ruma ai ba dae kau, vavamu Laban natuna kekenidia ta bavadavaia. ");
INSERT INTO meu_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Bena Siahu-idoinai Diravana ese baine hanamomu, besemu baine havaraia bona baine habadaia, bese bada-hereana ai baola. ");
INSERT INTO meu_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Dirava ese Abrahame henia hahenamona oi danu baine henimu, oi garamu baine henidia danu, o noholaia hedoamu tanona, Dirava ese Abraham e henia tanona bavabia, emu tano korikori ai bainela. ");
INSERT INTO meu_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Bena Isaak ese Iakob e siaia lao. Ia na Padan-aram ela, Laban Betuel, tau Suria, dekenai. Una Laban na Rebeka taihuna; Rebeka na Iakob bona Esau sinadia. ");
INSERT INTO meu_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau vada e diba Isaak ese Iakob vada e hanamoa bona vada e siaia lao, Padan-aram ai baine headava: vada e diba danu e hanamoa negana ai e haḡania, eto “Kanaan taudia natudia ta basio adavaia”; ");
INSERT INTO meu_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","e diba danu Iakob na tamana sinana eredia vada e kamonai, Padan-aram ela. ");
INSERT INTO meu_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Bena Esau lalona e parara tamana Isaak na Kanaan hahinedia se ura henidiava. ");
INSERT INTO meu_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Taunabunai, Esau na Ismael dekena ela, Ismael Abraham natuna kekenina Mahalata, Nebaioto taihuna, e adavaia; ḡau tamona, adavana gunadia raruosi nonoho. ");
INSERT INTO meu_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Iakob ese Bere-sieba e rakatania, Haran dalana ai e raka. ");
INSERT INTO meu_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Bena gabu ta ai e kau, unuseni ai baine noho rani eto, badina be dina vada e diho. Bena una gabu nadidia ta e abia, ena ikwina; bena e hekure diho, e mahuta. ");
INSERT INTO meu_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Bena e nihi: ena nihi ai vadavada e itaia, tano amo e dae ela bona guba, bona Dirava ena aneru loḡora unu amo e dae e diho. ");
INSERT INTO meu_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Iehova na dorina ai e gini, eto, Lau na Iehova, tubumu Abraham ena Dirava, tamamu Isaak ena Dirava danu: lau ese ina o mahutalaiamu tanona oi baina henimu, oi garamu danu baina henidia. ");
INSERT INTO meu_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Oi garamu danu bae hutuma, tano ḡahuna na heto, tahodiho kahana ai bona mairiveina kahana ai bona mirigini kahana ai bona diho kahana ai do bae pere rohoroho; oi daimu ai bona garamu daidiai tanobada iduhudia idoidiai bae namo. ");
INSERT INTO meu_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Lau ese baina bamomu, ba lao heni gabudia iboudiai baina gimamu, bona baina hakaumu lou ina tano ba lou henia; lau basina rakatanimu ela bona na herevalai henimu karadia na baina kara ḡuḡuru. ");
INSERT INTO meu_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Iakob na mahuta amo e noga, bena eto, Momokani, Iehova na iniseni ai, to asi dibagu. ");
INSERT INTO meu_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Bena kudouna e hetaha, eto, Ina gabu na mai garina; Dirava ena ruma binai; guba iduarana binai. ");
INSERT INTO meu_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Daba matana ai Iakob e tore isi, ena hekwina nadina e haginia, pupuna ai e halaoa, latanai dehoro e seia. ");
INSERT INTO meu_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Bena una gabu ladana e hatoa Betele; a una gabu ladana gunana be Lusu. ");
INSERT INTO meu_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Bena Iakob e gwau hamata, eto, Bema Dirava ese baine bamogu, ina na rakalaiamu dalana ai baine gimagu, aniani baine henigu bona dabua danu, ");
INSERT INTO meu_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ela bona tamagu ena ruma baina lou henia mai mainogu ida: unu baine karagu toma be Iehova na egu Dirava ai baina halaoa; ");
INSERT INTO meu_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ina nadi pupuna danu hari name haginia na Dirava ena ruma ai bainela. Ba henigu ḡaudia idoidiai danu baina karoa, karoa gwauta, karoa ta oi baina henimu. ");
INSERT INTO meu_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Iakob na e raka lao, ela bona mairiveina kahana taudia edia tano ai eha kau. ");
INSERT INTO meu_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Bena ranu gurina ta e itaia taora ai, mamoe seridia toi na badibadinai hehekure, badina be una ranu na mamoe seridia e hainulaidia. Nadi badana ta ai guri iduarana e koua ahu; ");
INSERT INTO meu_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","mamoe seridia idoidiai e hegogo unuseni ai, bena idia ese nadi na guri iduarana amo e kurea oho, mamoe seridia e ha-inulaidia, bena nadi na guri iduarana ai ekurea lou ena gabu ai. ");
INSERT INTO meu_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Bena Iakob ese mamoe ireḡudia taudia e nanadaidia, eto, Varavaragu e, ede amo oma? Idia eto, Ai be Haran taumai. ");
INSERT INTO meu_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ma e nanadaidia lou, eto Umui na Laban, Nahoro natuna, dibamui eiava? Idia eto, Dibamai. ");
INSERT INTO meu_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ma e nanadaidia lou, eto, Ia be namo a? Idia eto, I, vada namo; natuna kekenina Rahela mani a itaia, ena mamoe serina e hakaua maimu. ");
INSERT INTO meu_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Iakob eto, Dina tubua binai, boromakau ihaboudia negana be dohore; mamoe seridia boma ha-inudia, boma lao, adia boma henidia. ");
INSERT INTO meu_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Idia nae haere, eto, Lasi: mamoe seridia iboudiai bae hegogo guna, bena guri iduarana nadina baia kurea oho, bona mamoe seridia baia ha-inudia. ");
INSERT INTO meu_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ia idia ida dounu e herevava ai, Rahela na e kau, tamana ena mamoe serina e hakaudia, badina be ia ese e reḡudiava. ");
INSERT INTO meu_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Iakob ese vavana Laban natuna kekenina Rahela e itaia, vavana Laban ena mamoe serina e hakaua mai, bena ia na e raka kahira, nadi guri iduarana amo e kurea oho, vavana Laban ena mamoe serina e ha-inudia. ");
INSERT INTO meu_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Bena Iakob ese Rahela e harahua, bona e tai danu mai gao badana ida. ");
INSERT INTO meu_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Iakob ese Rahela e hamaoroa ia na ia lalana Rebeka natuna; bena Rahela e heau ela, tamana e hamaoroa. ");
INSERT INTO meu_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban ese vavana Iakob harina e kamnonai, bena ia e heau ela, e rosia, e harahua; bena ena ruma e hakaua lao. Bena Iakob ese hari idoidiai Laban e hamaorolaia. ");
INSERT INTO meu_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Bena Laban ese e hamaoroa, eto, Momokani, oi na turiagu turiana bona hidiogu hidiona. Taunabunai, Iakob na ia ida e noho, hua tamona. ");
INSERT INTO meu_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Bena Laban ese Iakob e hereva henia, eto, Oi na varavaragu dainai isiaigu ba lao heni asi davamu a? Ame hamaorogu, davamu be dahaka? ");
INSERT INTO meu_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Hari Laban na mai natuna kekenidia rarua, vara guna ladana na Lea, tadina ladana be Rahela. ");
INSERT INTO meu_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea matana na dika, a Rahela na hane namo, mai hairaina. ");
INSERT INTO meu_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Iakob ese Rahela e ura henia; taunabunai ia eto, Laḡani hitu isiaimu baina lao heni, natumu hane-muritai Rahela iabina totona. ");
INSERT INTO meu_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban eto, Oi baina henimu be namo, idau tauna ta baina henia na dika; dekegu ai ba noho. ");
INSERT INTO meu_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Taunabunai, Iakob ese Laban isiaina e lao heni laḡani hitu, Rahela iabina totona; a lalona e tomava dina gadoi mo na heheto, badina be ia ese Rahela e ura henia lalo-dikava. ");
INSERT INTO meu_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Bena Iakob ese Laban e hamaoroa, eto, Adavagu a henigu, badina be egu nega vada e ore, taunabunai aina adavaia na tomamu. ");
INSERT INTO meu_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Bena Laban ese una gabu taudia iboudiai e haboudia, aria e karaia. ");
INSERT INTO meu_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Hanua e boi, bena ia ese natuna Lea e hakaua vareai Iakob dekenai; bena Iakob ese e adavaia ");
INSERT INTO meu_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban ese danu ena hesiai hahinena Silpa na Lea e henia, ena hesiai hahinena ai bainela. ");
INSERT INTO meu_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Daba e rere, bena Iakob ese hahine na e itaia, Lea mo. Bena ia ese Laban e gwau henia, eto, Ede vada o karagu toma? Isiaimu asina lao heni Rahela iabina totona a? Dahaka dainai o koigu? ");
INSERT INTO meu_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban na e haere, eto, Ai emai kara iniseni ai be hane-muritai asia haheadavaia gunamu, a hane-guna e headava gunamu. ");
INSERT INTO meu_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ina hahine ariana purana baine ore, murinai tadina danu baia henimu; davana be laḡani hitu ma isiaigu ba lao heni. ");
INSERT INTO meu_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Iakob na unu e kara toma: dina hitu e ore, bena Laban ese natuna Rahela e henia, baine adavaia. ");
INSERT INTO meu_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban ese danu ena hesiai hahinena Bilha na Rahela e henia, ena hesiai hahinena ai bainela. ");
INSERT INTO meu_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Bena Iakob e raka vareai Rahela dekenai; ia ese Rahela e ura henia bada, a Lea e ura henia maragi. Ia ese Laban isiaina ma e lao heni, laḡani hitu. ");
INSERT INTO meu_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Iakob ese Lea e dadaraia dainai Iehova ese e bogaia hisi, natuna e henia; a Rahela na gabani. ");
INSERT INTO meu_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Bena Lea na e rogorogo, e mara, mero ta e abia; ladana e hatoa Ruben: badina be ia eto, Iehova ese egu lalo- hisihisi vada e haḡerea; harihari adavagu ese baine ura henigu. ");
INSERT INTO meu_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ma e rogorogo lou, e mara, mero ta e abia; bena eto, Iehova vada e kamonai adavagu vada e dadaraigumu, una dainai ina mero danu vada e henigu. Bena ladana e hatoa Simeon. ");
INSERT INTO meu_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ma e rogorogo, e mara, mero ta e abia; bena eto, Harihari adavagu ida baia hahebou, badina be memero tatoi vada na heni. Bena ladana e hatoa Levi. ");
INSERT INTO meu_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ma e rogorogo, e mara, mero ta e abia; bena eto, Harihari Iehova aina imodaia. Bena ladana e hatoa Iuda. Una murinai ia na se rogorogo lou. ");
INSERT INTO meu_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rahela na gabani, una dainai ia ese kakana e mama henia. Bena ia ese Iakob e gwau henia, eto, Natugu basio henigu vada baina mase. ");
INSERT INTO meu_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Bena Iakob ese Rahela e badu henia, eto, Lau Dirava a? Ia ese mero emu ai e ruamu. ");
INSERT INTO meu_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Hahine na eto, Egu hesiai hahinena Bilha binai: ia dekenai ba raka vareai; bena lau tuigu ai baine mara, iena amo natugu baina abia. ");
INSERT INTO meu_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Taunabunai, ia ese ena hesiai hahinena Bilha na Iakob e henia, bena ia ese e adavaia. ");
INSERT INTO meu_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bena Bilha na e rogorogo, e mara, mero ta e abia. ");
INSERT INTO meu_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Bena Rahela eto, Dirava ese vada e hahemaoro henigu, egu noinoi vada e abia dae, natugu vada e henigu. Bena ladana e hatoa Dan. ");
INSERT INTO meu_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rahela ena hesiai hahinena Bilha ma e rogorogo, e mara, mero ihararuana e abia. ");
INSERT INTO meu_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Bena Rahela eto, Kakagu ida a hedaverai, vada na kwalimu. Bena mero ladana e hatoa Napatali. ");
INSERT INTO meu_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea vada e diba ia na basine rogorogo; bena ia ese ena hesiai hahinena Silpa e abia, Iakob e henia, baine adavaia. ");
INSERT INTO meu_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Bena Lea ena hesiai hahinena Silpa e rogorogo, e mara, mero ta e abia. ");
INSERT INTO meu_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Bena Lea eto, Egu madinamo negana binai. Bena mero ladana e hatoa Gad. ");
INSERT INTO meu_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Bena Lea ena hesiai hahinena Silpa ma e rogorogo, e mara, mero ihararuana e abia. ");
INSERT INTO meu_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Bena Lea eto, Na moalemu; hahine iboudiai danu bae hanamogu. Bena mero ladana e hatoa Asere. ");
INSERT INTO meu_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Uit iutuna negana ai, Ruben na ela, au-huahua ladana dudai haida e davaridia. bena e abi, sinana Lea dekena e laohai. Bena Rahela ese e noia, eto, Natumu ena dudai haida mani a henigu. ");
INSERT INTO meu_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","A Lea ese e gwau henia, eto, Adavagu o henaoa na ḡau pipikina a? Matona natugu ena dudai ba dadi o tomu. Bena Rahela eto, Natumu ena dudai ba henigu, bena hari hanuaboi adavada ida ba eno bou. ");
INSERT INTO meu_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Adorahi ai, Iakob na uma amo e lasi, bena Lea na vairana ela, eto, Hari hanuaboi raruosi baita eno bou, natugu ena dudai na heni davadia. Bena una hanuaboi idia raruosi e eno bou. ");
INSERT INTO meu_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Bena Dirava ese Lea e hakala henia; bena e rogorogo, e mara, mero iha-imana e abia, Iakob ena. ");
INSERT INTO meu_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Bena Lea eto, Egu hesiai hahinena na adavagu na henia davana binai, Dirava ese vada e henigu. Bena natuna ladana e hatoa Isakara. ");
INSERT INTO meu_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea ma e rogorogo lou, e mara, mero ihatauratoina e abia, Iakob ena. ");
INSERT INTO meu_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Bena ia eto, Dava namona Dirava ese vada e henigu; harihari adavagu na dekegu ai baine noho tari, badina be natuna mamaruanedia tauratoi vada na henia. Bena mero ladana e hatoa Sebulun. ");
INSERT INTO meu_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Una murinai ia ese natuna kekenina ta e abia, bena kekeni ladana e hatoa Daina. ");
INSERT INTO meu_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Una negana ai Dirava ese Rahela e haḡerea, ena noinoi e abia dae; Bena ia danu e rogorogo. ");
INSERT INTO meu_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","E mara, mero ta e abia: bena eto, Dirava ese egu hemarai vada e abia oho. ");
INSERT INTO meu_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Bena ladana e hatoa Iosef; eto, Iehova ese ma ta bema henigu bema namo. ");
INSERT INTO meu_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Iosef e vara murinai, Iakob ese Laban e hamaoroa, eto, Mani emu kara a kahugu nege, egu gabu korikori bainala, egu tano korikori baina lou henia. ");
INSERT INTO meu_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Adavagu bona natugu ba henigu, badina be idia daidiai oi isiaimu vada na lao heni. A kahugu nege; egu hekwarahi emu hesiai ilao-henina ai vada dibamu. ");
INSERT INTO meu_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban eto, Na noimumu, mani emu kara basio raka oho; badina be lalogu vada eme parara Iehova ese vada e hanamogu oi daimu ai. ");
INSERT INTO meu_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Davamu a gwauraia, bena baina henimu. ");
INSERT INTO meu_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Iakob ese e haere henia, eto, Ede na hekwarahi tomava emu hesiai ilao-henina ai vada o itaia; dibamu danu emu seri vada e hutuma lau imagu ai. ");
INSERT INTO meu_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Lau do asinama negana ai oi na vada o ogoḡami, harihari vada o taḡa; lau nama ema bona hari Iehova ese vada e hanamomu. A edena nega ai adavagu bona natugu ihataḡadia baina ḡaukara matama a? ");
INSERT INTO meu_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Bena Laban eto, Dahaka baina henimu? Iakob eto, Ḡau ta basio henigu, to egu ura bavabia dae, bena emu seri ma baina reḡudia. ");
INSERT INTO meu_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Hari dina ai emu seri ba hididia, mamoe mai toutoudia eiava mai revarevadia bona mamoe koremadia bona nani mai toutoudia eiava mai revarevadia iboudiai baina hakaudia siri: lau davagu bunu. ");
INSERT INTO meu_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Nega gabedia ai vada ba dibagu, maoro eiava kerere: egu seri ai nani haida asi toutoudia asi revarevadia eiava mamoe kurokurodia ba davaridia, henao taugu ba gwauraigu. ");
INSERT INTO meu_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Bena Laban eto, Emu hereva heḡereḡerena, unu baita kara toma. ");
INSERT INTO meu_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Una dina ai ia ese nani mamaruanedia mai toutoudia bona mai revarevadia, bona nani hahinedia mai toutoudia bona mai revarevadia, bona mamoe koremadia, iboudiai e hakaudia siri, natuna e henidia, bae reḡudia. ");
INSERT INTO meu_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Bena e siaidia lao, dauhai bae noho, dina toi rakadia heḡereḡerena. A Laban ena seri oredia Iakob ese e reḡudia. ");
INSERT INTO meu_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Bena Iakob ese au rigidia matamatadia e utu, kopidia kahadia e nege, kahadia mimia, ita-itadia revareva na heheto. ");
INSERT INTO meu_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Bena unu rigi mai revarevadia ranu gabudia ai e hagini, seri e ha-inudia negadia ai. Bena nani bona mamoe hahinedia na ranu gabudia ai e rogorogo, ");
INSERT INTO meu_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","unu rigi vairadiai; una dainai natudia e havaradia, kopidia na mai revarevadia. ");
INSERT INTO meu_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ini nani bona mamoe natudia Iakob ese e abidia hidi, iena seri ida e haboudia, Laban ena seri ai se atodia. ");
INSERT INTO meu_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Bena nani bona mamoe hahinedia mai goadadia e rogorogova negadia ai, Iakob ese hari rigi vairadiai e hagini, ranu gabudia ai, rigi i'itadia ai bae rogorogo totona. ");
INSERT INTO meu_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","A manokadia e rogorogova negadia ai, hari rigi se hagini vairadiai. Taunabunai, nani bona mamoe manokadia na Laban ena seri ai, a goadadia na Iakob ena seri ai. ");
INSERT INTO meu_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Taunabunai, Iakob ena taḡa e bada e laova: ena seri e hutumava; ena hesiai hahinedia bona ena hesiai taudia bona ena kamelo bona ena doniki danu hutuma herea. ");
INSERT INTO meu_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Bena Iakob ese Laban natuna mamaruanedia edia maumau e kamonai: idia na e maumau, eto “Iakob ese tamamai ena kohu idoinai vada e abihaia, unu amo ena taḡa idoinai vada e abi”. ");
INSERT INTO meu_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Iakob danu e itaia. Laban vairana e huaia ienai. ");
INSERT INTO meu_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Una negana ai Iehova ese Iakob e hamaoroa. eto, Tubumu tamamu edia tano ba lou henia, varavaramu dekedia baola: lau ese baina bamomu. ");
INSERT INTO meu_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Bena Iakob ese Rahela bona Lea e boiridia, dekena baela, taora ai ena seri e reḡudiava gabuna ai. ");
INSERT INTO meu_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Bena ia ese e hamaorodia, eto, Vada na itaia, tamamui ese vairana e huaiamu bona lalona e idaumu egu ai; a tamagu ena Dirava ese vada e bamogu. ");
INSERT INTO meu_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Umui danu dibamui lau ese tamamui isiaina vada na lao heni mai goadagu idoinai. ");
INSERT INTO meu_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Tamamui ese vada e koigu, nega gwauta davagu vada e ha-idaua, a Dirava ese e laoa ahu dainai ia ese se hadikagu. ");
INSERT INTO meu_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ia eto “Mai toutoudia na oiemu”, bena seri idoinai ese mai toutoudia ḡaudia mo e havaradia; ma eto “Mai revarevadia na oiemu”, bena seri idoinai ese mai revarevadia ḡaudia mo e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Unuhetomana Dirava ese tamamui ena seri iena amo vada e abi oho, lau vada e henigu. ");
INSERT INTO meu_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Mamoe bona nani hahinedia e rogorogova negana ai na na nihi, egu nihi ai na itadia, mamarauendia mai toutoudia bona mai revarevadia bona koremadia mo ema, hahine dekediai. ");
INSERT INTO meu_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Bena egu nihi ai Dirava ena aneru ta ese e hereva henigu, eto “Iakob”. Lau nato “Lau o ina.” ");
INSERT INTO meu_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ma eto “A itadia, mamoe bona nani hahinedia e harogorogodiamu mamaruanedia iboudiai na mai toutoudia eiava mai revarevadia eiava koremadia: badina be Laban ena kara iboudiai oiemu ai e karamu vada na ita vaitani. ");
INSERT INTO meu_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Lau binai, Betele Diravana: unuseni ai oi ese boubou nadina dehoro o horolaia, bona o gwau henigu hamata. Benaini, a tore isi, ina tano amo ba raka lasi, o vara gabuna ba lou henia.” ");
INSERT INTO meu_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Bena Rahela bona Lea ese e haere henia, eto, Ai ahumai be dahaka tamamai ena ruma ai? Ai na dia ia dihina. ");
INSERT INTO meu_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ai na idau taudia na heheto ienai, ani? Badina be davamai vada e abi bona vada e hapetapetalai. ");
INSERT INTO meu_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Taḡa idoinai Dirava ese tamamai ena amo vada e abihaia na ai emai bona natumai edia; taunabunai, Dirava ese vada e hamaoromu heḡereḡerena vada ba karaia. ");
INSERT INTO meu_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Bena Iakob ese adavana raruosi bona natuna iboudiai na kamelo ai e hahelaidia kau; ");
INSERT INTO meu_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ena seri iboudiai bona ena kohu idoinai Padan-aram ai e habou danu e siaidia guna; bena e heḡaeḡae, Kanaan tanona bainela, tamana Isaak dekenai. ");
INSERT INTO meu_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Una negana ai Laban na ena mamoe huidia iutudia ela. Bena Rahela ese tamana ena dirava laulaudia e henao; ");
INSERT INTO meu_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","bona Iakob na e heau hehuni, Laban tau Suria se hadibaia guna. ");
INSERT INTO meu_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ia na ela, ena orea taudia bona ena kohu idoinai danu e laohai, sinavai e hanaia, Gilead ororodia dalana ai ela. ");
INSERT INTO meu_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Dina ihatoina ai Laban na Iakob ena heau harina e kamonai. ");
INSERT INTO meu_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Bena ia ese varavarana e haboudia, dina hitu Iakob e ḡavaia, ela bona Gilead ororodia ai e ḡavaia tao. ");
INSERT INTO meu_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","A Dirava ese Laban tau Suria nihi ai e hahedinarai henia, eto, Iakob basio hereva henia, hereva namona eiava hereva dikana. ");
INSERT INTO meu_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Bena Laban ese Iakob e lasia tao. Iakob na ororo ai vada e taruha; bena Laban mai varavarana ida danu Gilead ororodia ai e taruha. ");
INSERT INTO meu_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Bena Laban ese Iakob e gwau henia, eto, Badina be dahaka o heau hehuni, natugu hahinedia danu abimauri hahinedia na heheto o heaulaidia? ");
INSERT INTO meu_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Dahaka dainai o heau hehuni, so hadibagu? Boma hadibagu, bena bama kahumu nege mai moale karadia bona mai moale anedia ida, oibe, mai gaba reḡedia bona mai gitara reḡedia ida. ");
INSERT INTO meu_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","A oi ese o laogu ahu, natugu asina harahudia. Vada o kara kava. ");
INSERT INTO meu_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Harihari, lau na mai siahugu bama hadikamu; ḡau tamona, tamamu ena Dirava ese boi hanuaboi e hahedinarai henigu, eto, “Iakob basio hereva henia, hereva namona eiava hereva dikana.” ");
INSERT INTO meu_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Harihari tamamu ena ruma o ura henia lalo-dikamu dainai vada bo laomu; to dahaka dainai egu dirava laulaudia o henaodia? ");
INSERT INTO meu_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Bena Iakob ese Laban e haere henia, eto, Na gari, nato natumu na egu amo ba dadidia oho readia. ");
INSERT INTO meu_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","A emu dirava laulaudia na daika dekenai ba davaridia, ia na baine mase. Ai vairamai ai emu a tahu, bavabi. Badina be Iakob na asi dibana Rahela ese e abidia. ");
INSERT INTO meu_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Taunabunai Laban ese Iakob ena dabua rumana ai e tahu, bona Lea ena dabua rumana ai, bona hesiai hahinedia raruosi edia dabua rumadia ai, to ḡau ta se davaria. Bena Rahela ena dabua rumana ai e raka vareai. ");
INSERT INTO meu_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahela ese hari dirava laulaudia vada e abi, kamelo e hua modadia ai vada e huni, bena moda latadiai e helai. Bena Laban ese dabua rumana ai e tahu malaka-malaka, a ḡau ta se davaria. ");
INSERT INTO meu_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Bena hahine ese tamanae hereva henia, eto, Ḡauka, basio badu; vairamu ai asina tore isi, badina be vaia hahine emai kara e goreregumu. Taunabunai e hetahu mase, to ena dirava laulaudia se davaridia. ");
INSERT INTO meu_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Bena Iakob ese Laban e badu henia, e gwau henia, eto, Egu kerere be dahaka, egu dika be dahaka, bena oi ese daidiai o havagu mai badumu ida? ");
INSERT INTO meu_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Egu kohu idoinai vada o tahu vaitani, emu o davaria be edena? Lauegu orea taudia bona oiemu orea taudia vairadiai ba vaia dae, bena ita raruosi bae hahemaoro henida. ");
INSERT INTO meu_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Laḡani ruahui dekemu ai na noho; emu mamoe bona emu nani hahinedia asie mara dika, emu nani mamaruanedia danu ta asina abia, asina ania. ");
INSERT INTO meu_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Uda boromadia ese e habero ḡaudia danu asina vasilai; sibogu ibolodia na heni. Henao taudia ese dina ai e henao eiava hanuaboi ai e henao ḡaudia danu davadia lauegu amo o gwaurai. ");
INSERT INTO meu_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Unu na noho tomava: dina ai dina ḡaraḡara ese e hadikaguva; hanuaboi ai keru ese e alaguva; matagu na asie mahutava. ");
INSERT INTO meu_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Laḡani ruahui emu ruma ai na nohova: laḡani gwauta-hani isiaimu na lao heni, natumu raruosi davadia, ma laḡani tauratoi emu seri davadia. Nega gwauta davagu o ha-idaua. ");
INSERT INTO meu_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Tamagu ena Dirava, Abraham ena Dirava, Isaak ese e gari heniamu Diravana, basinema bamogu, oi na harihari ima-kavakava boma lulugu. A Dirava ese egu hekwarahi vada e itaia bona imagu ḡaukaradia vada e nene, bena boi hanuaboi e gwaumu tubu. ");
INSERT INTO meu_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Bena Laban ese e haere henia, eto, Ini hahine na lau natugu; ini memero na lau tubugu; ini seri na lauegu seri; o itamu ḡaudia iboudiai na lauegu. Ma dahaka aina karaia hari dina ai, ini natugu bona tubugu ihanamodia? ");
INSERT INTO meu_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Aoma, aita herohemaino; eda herohemaino ese baine hahemaoro henida. ");
INSERT INTO meu_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Bena Iakob ese nadi ta e abia, e haginia, pupuna ai e halaoa. ");
INSERT INTO meu_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Iakob ese danu ena orea taudia e hamaorodia, eto, Nadi a gogo. Unu e kara toma, bena una nadi senuna latanai e aniani hebou. ");
INSERT INTO meu_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Bena Laban ese una gabu ladana e hatoa legara-sahaduta; a Iakob ese ladana e hatoa Galeed. ");
INSERT INTO meu_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Bena Laban eto, Hari dina ai ina nadi senuna ese e hahemaoro henidamu. Una dainai ladana na Galeed. ");
INSERT INTO meu_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ma ladana ta be Mispa; badina be ia eto, Basita heita heheni negadia ai Iehova ese baine gimada. ");
INSERT INTO meu_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Natugu ba daḡedaḡe henidia, eiava hahine haida ma bavabidia, tau ta ese basine itamu, to Dirava ese baine hahemaoro henida. ");
INSERT INTO meu_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban ese Iakob ma e hereva henia, eto, Ini nadi bona ina pupuna na ita raruosi padadai vada na hagini. ");
INSERT INTO meu_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ini nadi anidia binai bona ina pupuna anina binai: lau ese ini nadi basina rakadia hanai, oi ihadikamu, bona oi ese ini nadi bona ina pupuna basio rakadia hanai, lau ihadikagu. ");
INSERT INTO meu_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abraham ena Dirava, Nahoro ena Dirava, tamadia ena Dirava danu, ia ese baine hahemaoro henida. Bena Iakob na ia tamana Isaak ese e gari henia Diravana ladana ai e gwau hamata. ");
INSERT INTO meu_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Bena Iakob ese Dirava e boua una ororo ai, bona ena orea taudia e haduadia, bae aniani. Taunabunai, e aniani, bona ororo ai e noho rani. ");
INSERT INTO meu_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Daba ai Laban e tore isi, tubuna mai sinadia ida e harahudia bona e hanamodia. Bena e rakatanidia, ena hanua e lou henia. ");
INSERT INTO meu_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Iakob na ena dala ai ela, bena Dirava ena aneru loḡora ida e hedavari. ");
INSERT INTO meu_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Iakob ese e itadia, bena eto, Ina na Dirava ena tuari oreana: taunabunai una gabu ladana e hatoa Mahanaim. ");
INSERT INTO meu_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Una negana ai Iakob ese ena hesiai taudia e siaidia guna, kakana Esau dekena baela, Seiri tanona ai: Edom ena tano bunai. ");
INSERT INTO meu_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","E haduadia, eto, Egu lohia Esau ini ba hamaoroa toma, baoto “Emu hesiai tauna Iakob na e tomu: lau na Laban ida vada na noho ema bona hari; ");
INSERT INTO meu_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","lau na mai egu boromakau bona doniki bona mamoe bona nani bona hesiai taudia bona hesiai hahinedia; bena ihamaorolaimu herevana egu lohia emu ai name siaia vasi, oi vairamu ai hebogahisi baina davaria totona”. ");
INSERT INTO meu_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Hesiai taudia na e lou ema, eto, Ai na kakamu Esau ida a hedavari, ia na dekemu e maimu, ena orea taudia sinahu-hani ida. ");
INSERT INTO meu_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Bena Iakob na e gari dikadika, kudouna e hetaha. Bena ena orea taudia bona ena mamoe, ena nani, ena boromakau, ena kamelo danu, orea rua ai e hididia. ");
INSERT INTO meu_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","eto, Esau ese orea ta baine davaria bena baine habuaia tari reana, a orea ta ma baine mauri. ");
INSERT INTO meu_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Bena Iakob e ḡuriḡuri, eto, Tubugu Abraham ena Dirava, tamagu Isaak ena Dirava, Iehova e, oi ese o haduagu, oto “Emu tano ba lou henia, varavaramu dekedia baola, bena baina hanamomu”. ");
INSERT INTO meu_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Emu hebogahisi karadia iboudiai emu hesiai tauna egu ai o kara, bona emu gwau-hamata herevadia emu hesiai tauna egu ai o hamomokani, lau na dia heḡereḡere; badina be imagu mai itotohina mo ina Ioridane sinavaina na hanai nala, a harihari mai orea rua ida vada na lou mai. ");
INSERT INTO meu_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Na noimumu, kakagu Esau imana amo ba hamaurigu; badina be na garimu, ia na bainema, baine tuari henigu, natugu mai sinadia ida baine aladia mase. ");
INSERT INTO meu_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","A oi vada oto “Momokani, lau ese baina hanamomu, bona garamu baina hahutumadia kone mirina na heto, asi iduahidia”. ");
INSERT INTO meu_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Una hanuaboi ia na unuseni ai e taruha; bena ena kohu amo herahia gaudia e abi, kakana Esau ena. ");
INSERT INTO meu_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Gaudia bini: nani hahinedia sinahu-ruabona nani mamaruanedia ruahui; mamoe hahinedia sinahu-rua bona mamoe mamaruanedia ruahui; ");
INSERT INTO meu_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kamelo toi-ahui mai natudia ida; boromakau hahinedia hari-ahui; boromakau mamaruanedia gwauta; doniki ruahui; bona doniki natudia gwauta. ");
INSERT INTO meu_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ini iboudiai ena hesiai taudia e henidia, ta ta ena seri ena seri ai. Bena ia ese ena hesiai taudia e hamaorodia, eto, Umui ba raka guna, seri ta ta mai padadia ida ba hakaudia lao. ");
INSERT INTO meu_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Bena baine raka guna tauna e haduaia, eto, Kakagu Esau ida ba hedavari negana ai, ia baine henanadai, baineto “Oi na daika ena hesiai tauna? Ede bo laomu? Ina seri be daika ena?” ");
INSERT INTO meu_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Bena oi ese ba haere henia, baoto “Ini na emu hesiai tauna Iakob ena, ena herahia ḡaudia lohia taumu Esau emu; ia danu murimai ai e maimu”. ");
INSERT INTO meu_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ihararuana danu unu e haduaia toma, bona ihatatoina, bona idia muridiai seri ta ta bae hakaudia taudia, hahedua tamona e henidia, eto, Esau ida ba hedavari negana ai ini ba hereva henia toma. ");
INSERT INTO meu_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ma baoto “Emu hesiai tauna Iakob na murimai ai e maimu”. Ia na lalona ai eto: Egu herahia ḡaudia amo ena badu baina laoa ahu guna, gabeai ia vairanai baina hedinarai negana ai reana baine abigu dae. ");
INSERT INTO meu_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Taunabunai, unu hesiai taudia ese herahia ḡaudia e gunalai, a Iakob na una hanuaboi taruha ai e noho, ena orea taudia ida. ");
INSERT INTO meu_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Malokihi ai e tore isi, adavana raruosi bona ena hesiai hahinedia raruosi bona natuna mamaruanedia gwauta-ta-osi e abidia, sinavai maraḡina ladana Iabok bae turu hanai. ");
INSERT INTO meu_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ia ese e abidia, e siaidia hanai, ena kohu idoinai danu e hanailai. ");
INSERT INTO meu_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","A Iakob na sibona noho, bena tau ta na ia ida e hedaverai ela bona daba e kinia. ");
INSERT INTO meu_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Hari tau na dibana ia na basine kwalimu diba, bena ia ese Iakob mamuna varovarona e daua toho; taunabunai Iakob aena e heride, ia na hari tau ida e hedaverai negana ai. ");
INSERT INTO meu_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Bena hari tau eto, A kahugu nege, badina be daba vada e kinia. A Iakob eto, Lau na basina kahumu nege ela bona oi ese ba hanamogu. ");
INSERT INTO meu_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Bena hari tau eto, Oi ladamu be daika? Ia na e haere, eto, Ladagu na Iakob. ");
INSERT INTO meu_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Hari tau ma eto, Harihari ela oi ladamu na dia Iakob; oi ladamu na Israel, badina be Dirava ida vada o goada helulu bona taunimanima ida danu, bona vada o kwalimu. ");
INSERT INTO meu_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Bena Iakob ese e nanadaia, eto, Mani emu kara, oi ladamu ba hadibagu. Hari tau elo, Badina be dahaka lau ladagu o henanadailaiamu? Bena ia ese e hanamoa. ");
INSERT INTO meu_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Bena Iakob ese una gabu ladana e hatoa Peniel; eto, Dirava vada na itaia, raruosi vada ame hegaga heheni, to vada na maurimu. ");
INSERT INTO meu_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Bena Penuel e rakaia hanai ai daba e rere, ia na aena e heride. ");
INSERT INTO meu_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Badina bunai Israel besena taudia na mamu varovarodia asie animu ema bona harihari: badina be Iakob mamuna varovarona e daua toho bena aena e heride. ");
INSERT INTO meu_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Bena Iakob na e gaga isi, Esau e itaia, ena orea taudia sinahuhaniosi ida e maiva. Bena ia ese natuna e hididia, Lea natuna bona Rahela natuna bona hesiai hahinedia natudia; ");
INSERT INTO meu_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","hesiai hahinedia mai natudia ida vairai bae raka, idia muridiai Lea mai natuna ida, ma idia muridiai Rahela mai natuna Iosef ida. ");
INSERT INTO meu_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","A ia na e raka guna, nega hahitu tano ai e goru diho, ela bona kakana e raka henia kahi. ");
INSERT INTO meu_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Bena Esau na e heau ela, e rosia, e harahua; bena raruosi na e taitai. ");
INSERT INTO meu_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Bena Esau na e gaga isi, hari hahine mai natudia ida e itadia, bena eto, Idia be daidia? Iakob e haere, eto, Natugu bunu, Dirava ese emu hesiai tauna vada e bogagu hisi, vada e henigu. ");
INSERT INTO meu_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Bena hari hesiai hahinedia mai natudia ida e raka kahira, tano ai e goru goru diho. ");
INSERT INTO meu_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lea danu natuna ida e raka kahira, bona Rahela mai natuna Iosef ida danu, bena idia danu e goru goru diho. ");
INSERT INTO meu_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau ma e henanadai, eto, Unu seri iboudiai dala ai na itadia be edeheto? Iakob na e haere, eto, Una na herahia ḡauna, egu lohia vairamu ai baina mauri helaoreana. ");
INSERT INTO meu_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","A Esau eto, Tadigu e, lauegu na davana, oiemu hari ba dogo tao. ");
INSERT INTO meu_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Iakob eto, Lasi, bema lalomu vada eme namo egu ai, bavabi, egu lalokau toana; badina be oi vairamu vada na itaia, Dirava vairana bama itaia heḡereḡerena, bona vada o lalo namo henigu. ");
INSERT INTO meu_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Taunabunai egu herahia ḡaudia bavabi dae, bona egu hahenamo danu; badina be Dirava ese vada e hanamogu badabada, mai dinagu vada nama. Bena e noia goada dainai vada e abi. ");
INSERT INTO meu_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Bena Esau eto, Mani aita laolao hebou; lau na vairai baina raka. ");
INSERT INTO meu_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","A Iakob eto, Egu lohia dibana natugu na mamaraḡi; egu mamoe hahinedia bona egu boromakau hahinedia haida na mai bogadia, bena dina tamona mo bae luludia haraḡa-haraḡa vada bae mase ore. ");
INSERT INTO meu_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Taunabunai, egu lohia e, oi na emu hesiai tauna ba gunalaigu; a lau na baina raka metaira-metaira, egu seri bona natugu edia goada heḡereḡerena, ela bona Seiri ai egu lohia baina vasi henimu. ");
INSERT INTO meu_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Bena Esau eto, Benaini, egu orea taudia haida bavabidia, bae bamomu. A Iakob eto, Una na herevana; egu lohia lalomu vada e namo egu ai vada davana. ");
INSERT INTO meu_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Taunabunai Esau na una dina ai e lou, Seiri dalana ai e lou ela. ");
INSERT INTO meu_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","A Iakob na Sukoto ela; unuseni ai ia ese ruma auta e hadaia iena, bona kalaga haida e hadai ena boromakau edia. Una dainai gabu ladana e hatoa Sukoto. ");
INSERT INTO meu_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Unuhetomana Iakob na mai maurina ida Padan-aram amo ema, Sekem hanuana ai e lasi, Kanaan tanona ai; bena hanua badinai e taruha. ");
INSERT INTO meu_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Bena e taruha henia tanona na Hamoro, Sekem e hadaia tauna, natuna edia amo e hoia, davana na silver monidia sinahu-ta. ");
INSERT INTO meu_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Unuseni ai boubou patana ta e larebaia, ladana e hatoa El-Elohe-Israel. ");
INSERT INTO meu_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Iakob bona Lea natudia hahinena Daina na eha loaloa, una tano hahinedia i'igo-itadia ela. ");
INSERT INTO meu_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Bena una tano lohiana, Hamoro, tau Hivi, natuna Sekem ese e ḡahusia, bena e rosia, e ḡaḡaia. ");
INSERT INTO meu_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","To ia ese Iakob natuna Daina e ura henia lalodika, mai lalona idoinai, bena ia lalona ihamarumaruna herevadia e gwaurai heniava. ");
INSERT INTO meu_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Bena Sekem ese tamana Hamoro e hamaoroa, eto, Ina hane-ulato bavabia, baina adavaia. ");
INSERT INTO meu_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Iakob na harina e kamonai Sekem ese natuna Daina vada e hahemaraia, a natuna mamaruanedia ese taora ai seri e reḡudiava, bena Iakob ese hereva ta se gwauraia ela bona idia ema. ");
INSERT INTO meu_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Bena Hamoro, Sekem tamana, e lasi, Iakob ida bae hereva-hereva eto. ");
INSERT INTO meu_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","A Iakob natuna mamaruanedia na harina e kamonai, bena taora amo e lasi mai lalo-hisihisidia bona mai badudia ida; badina be una tau ese Israel vada e hahemaraia, Iakob natuna Daina vada e ḡaḡaia, dainai. ");
INSERT INTO meu_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","A Hamoro ese e hamaorodia, eto, Natugu Sekem ese oi natumu e ura henia lalodikamu; mani emu kara ba henia, baine adavaia. ");
INSERT INTO meu_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Beseda bae hatamona: umui ese natumui ulatodia ba henimai, emai ai bae headava; ai danu natumai ulatodia baia henimui, emui ai bae headava. ");
INSERT INTO meu_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Bogaragimai ai ba noho: ai emai tano na umui emui tano ai bainela; iniseni ai ba biru, ba hoihoi, ba hanua. ");
INSERT INTO meu_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sekem ese danu hane-ulato tamana bona taihuna e hereva henidia, eto, Egu noinoi boma abia dae, hane-ulato davana boma gwauraia, bena bama henimui. ");
INSERT INTO meu_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ena be davana ba habadaia herea, to vada baina henimui; ḡau tamona, hane-ulato na ba henigu, baina adavaia. ");
INSERT INTO meu_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","A Iakobo natuna mamaruanedia na e haere koikoi, Sekem, tamana Hamoro ida, e dibaḡanidia, taihuna Daina vada e hahemaraia dainai. ");
INSERT INTO meu_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","E hamaorodia, eto, Taihumai na se peritomea tauna baia henia na taravatu, bona hemarai ihavarana karana emai ai. ");
INSERT INTO meu_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","To ini baia kara henimui toma: bema umui ese emui maruane iboudiai ba peritomedia, ai bamomai, ");
INSERT INTO meu_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ai ese natumai ulatodia baia henimui bona natumui ulatodia baia abidia, bena bogaragimui ai baia noho, bese tamona ai baitala. ");
INSERT INTO meu_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","A bema emai hereva basio abia dae, basio peritome, ai na hane-ulato baia abia, baiala. ");
INSERT INTO meu_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamoro bona natuna Sekem na edia hereva e kamonai, bena raruosi e moale; ");
INSERT INTO meu_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","hari tauhau na se halahe, edia ura mo e karaia, badina be Iakob natuna ulatona e moalelaia bada; tamana ena ruma ai danu ia sibona herea. ");
INSERT INTO meu_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Bena Hamoro, natuna Sekem ida, edia hanua ikoukouna ela, edia hanua taudia e hereva henidia, eto, ");
INSERT INTO meu_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ini taunimanima na maino e uramu; taunabunai eda tano ai bae noho baine namo: bae hoihoi bona bae biru, badina be tano na bada. Natudia ulatodia baita adavadia, bona natuda ulatodia baita henidia. ");
INSERT INTO meu_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","To idia lalodia bae heḡereḡere bogaragidai bae noho bona ita ida bese tamona ai baitala dalana na tamona mo: ita bogaragidai maruane iboudiai baita peritomedia, idia e karamu heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Gabe amo edia seri bona edia kohu bona edia boromakau iboudiai na iseda ai baita halao, ani? Idia ida baita herohemaino, bena bogaragidai do bae noho. ");
INSERT INTO meu_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Hanua taudia iboudiai ese Hamoro bona natuna Sekem edia hereva e abia dae; bena maruane iboudiai e peritomedia. ");
INSERT INTO meu_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Dina ihatoina ai, taudia hisidia e dai lasi, bena Iakob natuna rarua, Simeon bona Levi, hari Daina taihuna, ese edia dare e abi, hanua ai e raka vareai, bena mamaruanedia ibouboudiai e aladia mase; ");
INSERT INTO meu_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamoro bona natuna Sekem danu dare amo e aladia mase. Daina danu Sekem ena ruma amo e hakaua diho, bena ela. ");
INSERT INTO meu_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Bena Iakob natuna mamaruanedia na ela, Sekem taudia masedia ai e davaridia, bena hanua e habuaia tari, taihudia e hahemaraia dainai. ");
INSERT INTO meu_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Edia mamoe bona edia boromakau bona edia doniki bona edia ruma kohudia bona adia uma anidia idoidiai e abihaidia; ");
INSERT INTO meu_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","natudia maraḡidia danu bona adavadia e abidia mauri. Edia ruma kohudia e ha-ore, bena ruma e doudia. ");
INSERT INTO meu_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Bena Iakob ese Simeon bona Levi e gwau henidia, eto, Hekwarahi egu ai vada o havaraia, bona ladagu vada o hadikaia ina tano taudia, Kanaan taudia bona Perisi taudia, bogaragidiai. Bena ita na dia hoho dainai idia na bae hebou, bae tuari henigu; bena lau bona egu ruma taudia iboudiai baita mase ore. ");
INSERT INTO meu_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","A idia e haere, eto, Be, taihumai na ariara hahinena ai e halaoa namo eiava? ");
INSERT INTO meu_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Dirava ese Iakob e hamaoroa, eto, Betele baola, unuseni ai ba ha noho; unuseni ai danu kakamu Esau o heautania negana ai e hahedinarai henimu Diravana ena ihaboulaina patana ba larebaia. ");
INSERT INTO meu_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Taunabunai, Iakob ese ena orea taudia iboudiai e haduadia, eto, Dirava idaudia dekemui ai mimia vada a negedia, ba haheḡoeva, dabua ḡoevadia ba rio; ");
INSERT INTO meu_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Betele baitala, unuseni ai egu dika dinana ai e haere henigu bona egu dala iboudiai lalodiai e bamogu Diravana ena ihaboulaina patana baina larebaia. ");
INSERT INTO meu_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Bena idia ese edia dirava idaudia bona taiadia gadeidia na Iakob e henia. Iakob ese e abidia, au helaḡana Sekem ai henunai e guridia. ");
INSERT INTO meu_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Bena edia laolao ela; bona hanua hanua taudia ese Dirava garina e gariva dainai idia ese Iakob natuna asie tuari henidia ");
INSERT INTO meu_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Bena Iakob na Lusu ai e kau (una na Betele ladana ta) Kanaan tanona ai, ia bona ena orea taudia iboudiai danu. ");
INSERT INTO meu_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Unuseni ai ia ese boubou patana ta e larebaia, ladana e hatoa El-betele; badina be una gabu ai Dirava ese e hahedinarai henia, ia ese kakana e heautania negana ai. ");
INSERT INTO meu_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Una negana ai, Rebeka ena hesiai hahinena, ladana Debora, Rebeka e vara negana amo isiaina e lao heniva hahinena, vada e mase. Bena Betele ai e guria, au helaḡana henunai; una gabu ladana e hatoa Alono-bakutu. ");
INSERT INTO meu_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Dirava ese Iakob ma e hahedinarai henia lou, Padan-aram amo ema negana ai, e hanamoa, eto, ");
INSERT INTO meu_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Oi ladamu na Iakob, a ladamu basie hatoa lou Iakob; harihari bainela ladamu bae hatoa Israel. Taunabunai, ladana e hatoa Israel. ");
INSERT INTO meu_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Bena Dirava ese e hamaoroa, eto, Lau na Siahu-idoinai Diravana: natumu ba havaradia, garamu bae hutuma; bese momo oiemu amo bae vara, bona hanua pavapavadia danu. ");
INSERT INTO meu_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Abraham bona Isaak na henidia tanona oi baina henimu, bona oi garamu murimu ai bae vara danu baina henidia. ");
INSERT INTO meu_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Bena Dirava ese ia e rakatania, e hereva henia gabuna danu e rakatania. ");
INSERT INTO meu_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Bena Iakob ese nadi ta e haginia, pupuna ai e halaoa, Dirava ida e hereva gabuna ai, vine ranuna na latanai e seia, ena boubou, bona dehoro danu latanai e seia. ");
INSERT INTO meu_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Bena una Dirava ese e hereva henia gabuna ladana e hatoa Betele. ");
INSERT INTO meu_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Idia na Betele amo eha laolao, ela Efrata vada e kahirakahira, bena Rahela e hekamonai, hisina vada e bada. ");
INSERT INTO meu_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ena hekamonai hisidia vada e bada herea ai, hegwaroto hahinena ese e hamaoroa, eto, Basio gari; mero ta do bavabia. ");
INSERT INTO meu_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Laumana ese e rakatania horana ai (badina be ia na una negana ai e mase), ia ese mero ladana e hatoa Benoni. Bena hahine na e mase. A tamana ese mero ladana e hatoa Beniamina. ");
INSERT INTO meu_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Unuhetomana Rahela e mase, bena Efrata dalana badinai e guria. Una Efrata ladana ta be Betelehem. ");
INSERT INTO meu_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Bena Iakob ese nadi pupuna ta e haginia ena gara latanai; ladana na doini e hatoamu “Rahela ena gara pupuna” ema bona harihari. ");
INSERT INTO meu_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel ma e laolao, kohoro ladana Mamoe Kohorona unukahana ai e taruha. ");
INSERT INTO meu_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Una tano ai e nohova negana ai Ruben na tamana ena hesiai hahinena Bilha ida e eno bou; bena Israel ese harina e kamonai. ");
INSERT INTO meu_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Iakob natuna mamaruanedia na gwauta-rarua. Lea natuna: Ruben, Iakob natuna roboana, bona Simeon bona Levi bona Iuda bona Isakara bona Sebulun. ");
INSERT INTO meu_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahela natuna: Iosef bona Beniamina. ");
INSERT INTO meu_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahela ena hesiai hahinena Bilha natuna: Dan bona Napatali. ");
INSERT INTO meu_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lea ena hesiai hahinena Silpa natuna: Gad bona Asere. Iakob natuna mamaruanedia, Padan-aram ai e abidia, ladadia bunu. ");
INSERT INTO meu_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Iakob na tamana Isaak dekena ela, Mamare ai, hanua ladana Araba. Una hanua ladana ta be Heberon; Abraham bona Isaak edia noho gabuna bunai. ");
INSERT INTO meu_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Hari Isaak ena mauri laḡanidia na sinahu-ta taurahani-ahui. ");
INSERT INTO meu_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Bena Isaak na laumana e heni dae, vada e mase, tubu tama dekediai eha hebou. Ia na tau buruka; ena mauri vada e daudau herea. Ia natuna raruosi, Esau bona Iakob, ese e guria. ");
INSERT INTO meu_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esau garana bini. Ia ladana ta be Edom. ");
INSERT INTO meu_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau adavana na Kanaan hahinedia: Ada, Elon tau Hiti natuna; bona Oholibama, Ana natuna, Sibeon tau Hivi tubuna; ");
INSERT INTO meu_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","bona Basemata, Ismael natuna, Nebaioto taihuna. ");
INSERT INTO meu_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada ese mero ta e abia, ladana Elifasa; bona Basemata ese mero ta e abia, ladana Reuele; ");
INSERT INTO meu_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","bona Oholibama ese memero tatoi e abidia, ladadia na Ieusu bona Ialam bona Kora: Esau natuna bunu, Kanaan tanona ai e vara. ");
INSERT INTO meu_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau ese adavana tatoiosi bona natuna mamaruanedia bona hahinedia, bona ena orea taudia iboudiai, bona ena boromakau bona ena seri iboudiai bona ena kohu idoidiai Kanaan ai e habou, e abidia, tadina Iakob e rakatania, Seiri tanona ela. ");
INSERT INTO meu_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Badina be raruosi edia taḡa na bada herea dainai tano na dia heḡereḡere idia raruosi bona edia seri idoidiai bae noholaia. ");
INSERT INTO meu_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Taunabunai, Esau na Seiri ororodia ai eha noho. Esau na Edom. ");
INSERT INTO meu_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esau garana bini: ia na Edom besena, Seiri ororodia ai e nohomu besena, ihavarana tauna. ");
INSERT INTO meu_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau natuna mamaruanedia bini: Elifasa, Esau adavana Ada natuna; bona Reuele, Esau adavana Basemata natuna. ");
INSERT INTO meu_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifasa natuna na Teman bona Omara bona Sefo bona Gatam bona Kena. ");
INSERT INTO meu_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifasa, Esau natuna, ese danu hahine ta ladana Timna e adavaia; hari Timna ese mero ta e abia, ladana Amalek: ini iboudiai na Esau adavana Ada tubuna. ");
INSERT INTO meu_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuele natuna bini: Nahata bona Sera bona Sama bona Misa. Idia na Esau adavana Basemata tubuna. ");
INSERT INTO meu_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau adavana Oholibama, Ana natuna, Sibeon tubuna, natuna bini: Ieusu bona Ialam bona Kora. ");
INSERT INTO meu_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Hanua lohiadia Esau ena amo e vara ladadia bini: Elifasa, Esau natuna roboana, ese Teman bona Omara bona Sefo bona Kena, ");
INSERT INTO meu_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","bona Kora bona Gatam bona Amalek e havaradia: ini iboudiai na Edom tanona lohiadia, Elifasa, Ada natuna, ese e havaradia. ");
INSERT INTO meu_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau natuna Reuele natuna bini: Nahata bona Sera bona Sama bona Misa. Idia na hanua lohiadia Reuele ai, Edom tanona ai; idia danu Esau adavana Basemata tubuna. ");
INSERT INTO meu_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau adavana Oholibama natuna bini: Ieusu bona Ialam bona Kora. Ini na hanua lohiadia, Esau adavana Oholibama, Ana natuna, ese e abidia. ");
INSERT INTO meu_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Esau natuna bunu, bona Edom lohiadia bunu. ");
INSERT INTO meu_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seiri tau Hori natuna una tano ai e nohova ladadia bini: Lotan bona Sobal bona Sibeon bona Ana ");
INSERT INTO meu_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","bona Dison bona Esere bona Disan: Hori lohiadia bunu, Seiri ese e havaradia Edom tanona ai. ");
INSERT INTO meu_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan natuna na Hori bona Heman; Lotan taihuna na Timna. ");
INSERT INTO meu_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal natuna na Alavan bona Manahata bona Ebal bona Sefo bona Onam. ");
INSERT INTO meu_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon natuna na Aia bona Ana. Hari Ana na ranu e lohilohimu gabudia e davaridia tano ḡaḡaena ai, tamana Sibeon ena doniki e reḡudiava negana ai. ");
INSERT INTO meu_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana natuna bini: maruanena ta ladana na Dison, bona hahinena ta ladana na Oholibama. ");
INSERT INTO meu_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison natuna na Hemudan bona Eseban bona Itiran bona Keran. ");
INSERT INTO meu_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esere natuna na Bilhan bona Saavan bona Akan. ");
INSERT INTO meu_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan natuna na Usu bona Aran. ");
INSERT INTO meu_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hori lohiadia bini: Lotan bona Sobal bona Sibeon bona Ana ");
INSERT INTO meu_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","bona Dison bona Esere bona Disan. Hori lohiadia bunu, Seiri tanona e lohiaia taudia. ");
INSERT INTO meu_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Hanua pavapavadia haida ese Edom tanona e lohiaia, Israel taudia na do asi edia pavapava negadia ai. Ladadia bini: ");
INSERT INTO meu_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela Beoro na Edom pavapavana, ena hanua badana ladana na Dinihaba. ");
INSERT INTO meu_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ia e mase; bena Iobab, Sera tau Bosra natuna, ese gabuna e abia. ");
INSERT INTO meu_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Iokab e mase; bena Husam na Teman tanona amo ema, gabuna e abia. ");
INSERT INTO meu_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam e mase; bena Hadad Bedad, Moab taorana ai Midian taudia e hadareredia tauna, ese gabuna e abia; iena hanua badana ladana na Aviti. ");
INSERT INTO meu_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad e mase; bena Samula tau Masareka ese gabuna e abia. ");
INSERT INTO meu_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samula e mase: bena Saul na sinavai isena hanuana ladana Rehoboto amo ema, gabuna e abia. ");
INSERT INTO meu_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul e mase; bena Baal-hanana Akaboro ese gabuna e abia. ");
INSERT INTO meu_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal-hanana e mase; bena Hadara ese gabuna e abia. Iena hanua badana ladana na Pau. Adavana ladana be Mehetabel; ia na Matared natuna, tubuna be Mesahab. ");
INSERT INTO meu_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Esau besena edia hanua lohiadia, ta ta mai edia iduhu bona mai edia hanua, ladadia bini: Timna; Alava; Ietete; ");
INSERT INTO meu_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama; Elaha; Pinon; ");
INSERT INTO meu_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kena; Teman; Mibsara; ");
INSERT INTO meu_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel; Iram: Edom lohiadia bunu, ta ta ese ena hanua ena hanua e halohiadia. A Edom besena ihavarana tauna be Esau. ");
INSERT INTO meu_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Iakob ese tamana e noholaia tanona ma e noholaia, Kanaan tanona. ");
INSERT INTO meu_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Iakob garana herevadia bini: Iosef ena mauri laḡanidia na gwautahitu, bena nega ta seri e reḡuva, ia kakana, tamana adavana Bilha bona Silpa natudia, ida. Bena Iosef na tamana dekena ela, kakana e habadelaidia. ");
INSERT INTO meu_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel ese hari Iosef e lalokau henia bada, natuna orena e lalokau henidia maraḡi; badina be burukana ai e havaraia. Bena ia ese hahedoki namohereana ta e henia. ");
INSERT INTO meu_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","A kakana ese e itaia, tamadia ese Iosef e lalokau henia bada, idia e lalokau henidia maraḡi; bena idia ese e inai henia, hereva namona ta asie gwaurai henia. ");
INSERT INTO meu_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Hari Iosef na e nihi, bena ena nihi na kakana e hamaorolaidia; una dainai idia ese e inai henia lalodika. ");
INSERT INTO meu_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","E hamaorodia eto, Egu nihi mani aina hamaorolaimui. ");
INSERT INTO meu_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Egu nihi ai ita na uma ai, uit ta ḡui; bena lauegu iḡui na e gini tore, a umui emui iḡui ese e ginia heḡeḡe, lauegu iḡui e toma henia diho. ");
INSERT INTO meu_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Bena kakana ese e gwau henia, eto, Oi na ai emai pavapava ai baola a? Oi ese ai ba halohiamai a? Bena ena nihi bona ena hereva daidiai edia badu ienai vada e bada e laova. ");
INSERT INTO meu_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ma e nihi lou, bena ena nihi na kakana e hamaorolaidia, eto, Vada na nihi lou, bena egu nihi ai dina bona hua bona hisiu gwauta-taese e toma henigu diho. ");
INSERT INTO meu_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ia ese tamana bona kakana unu e hamaorodia toma; bena tamana e gwaugwau, eto, Emu nihi anina be dahaka a? Lau bona sinamu bona kakamu ese oi baia toma henimu diho a? ");
INSERT INTO meu_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Bena kakana e badu dikadika, a tamana ese ena hereva e lalo tao. ");
INSERT INTO meu_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Nega ta kakana na Sekem ela, tamadia ena seri ireḡudia. ");
INSERT INTO meu_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Bena Israel ese Iosef e hereva henia, eto, Kakamu na Sekem ai seri e reḡudiamu ani? Aoma, aina siaimu dekediai. Iosef e haere, eto, Lau o ina. ");
INSERT INTO meu_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ma e hamaoroa, eto, Vada aola, ba itadia, kakamu be nanamo eiava, bona seri na edeheto; bena ma baoma, ba hadibagu. Bena e siaia; Heberon kourana amo e lasi, Sekem ai e kau. ");
INSERT INTO meu_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Bena tau ta ese e itaia, taora ai e loa eva-eva, bena e nanadaia, eto, Dahaka o tahuamu? ");
INSERT INTO meu_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Iosef na e haere, eto, Lau na kakagu na tahudiamu; mani emu kara ba hadibagu, idia na edeseni ai edia seri e reḡudiamu. ");
INSERT INTO meu_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Hari tau eto, Ini amo vada e raka oho; badina be edia hereva na kamonai, eto, “Ita na Dotan baitala”. Taunabunai Iosef ese e ḡavadia ela, Dotan ai e ḡavadia tao. ");
INSERT INTO meu_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","A ia na dounu dauhai, idia ese e itaia; bena ia do se raka henidia kahi ai idia vada e henega bou, bae alaia mase eto. ");
INSERT INTO meu_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","E hereva heheni, eto O itaia, hari nihi tauna vada e maimu; ");
INSERT INTO meu_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","aita alaia mase, ini guri asi ranudia ta ai baita negea dobi; bena baitato “Uda boromana ta ese e alaia mase”; unu amo baita itaia, ena nihi anidia be dahaka. ");
INSERT INTO meu_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","A Ruben na unu hereva e kamonai, bena ia ese idia imadia amo e hamauria, eto, Lasi, ena mauri basita abia oho, ");
INSERT INTO meu_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","basita alaia mase, a guri ta ai baita tahoa dobi. Unu e gwau toma badina ena lalo-hadai be idia imadia amo baine hamauria, tamana baine henia lou eto. ");
INSERT INTO meu_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Taunabunai, Iosef na kakana dekediai e kau ai, idia ese e dabaia tao, ena hahedoki namo-hereana e dokia oho, ");
INSERT INTO meu_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","e laohaia, guri ta ai etahoa dobi. Una guri na asi ranuna. ");
INSERT INTO meu_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Bena idia na e ege diho, e aniani. Bena e gaga isi, laolao taudia haida e itadia; idia na Ismael taudia, Gilead amo e maiva, Aigupto baela eto. Edia kamelo ese aniani muramuradia bona muramura mai bonadia e hua. ");
INSERT INTO meu_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Bena Iuda ese tadikakana e hamaorodia, eto, Tadida baita alaia bona ena mase baita hunia anina be dahaka? ");
INSERT INTO meu_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ini Ismael taudia ediai aita hoia. Imada na ienai basita dau kau, badina be ia na tadida korikori. Bena tadikakana ese ena hereva e abia dae. ");
INSERT INTO meu_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Hari hoihoi taudia na Midian amo e raka hanai; bena Iosef kakana ese guri amo e veria dae, Ismael taudia ediai e hoia, silver monidia ruahui davana. Bena idia ese e hakaua lao, Aigupto e laohaia. ");
INSERT INTO meu_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Gabeamo Ruben na guri e lou henia, a Iosef na lasihia. Bena ena dabua e darea, ");
INSERT INTO meu_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","tadina dekedia e lou lao, eto, Mero na lasihia; lau na ede baina kara toma? ");
INSERT INTO meu_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Bena idia ese Iosef ena hahedoki e abia, nani natuna ta e alaia, rarana amo hahedoki e hamiroa. ");
INSERT INTO meu_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Bena hari hahedoki na tamadia dekena e laohaia, eto, Ina na ai ese a davaria; a itaia, ina na natumu ena hahedoki eiava? ");
INSERT INTO meu_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","E itaia, bena eto, Ina na natugu ena hahedoki; uda boromana ta ese vada e alaia mase; momokani, Iosef vada e mase. ");
INSERT INTO meu_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Bena Iakob ese ena dabua e darea, guma dabuana e rioa, natuna itailaina e tai boi tai rani ela dina hoho. ");
INSERT INTO meu_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Bena natuna mamaruanedia bona hahinedia iboudiai na ihamarumaruna totona e lao henia, a ia na tauhalo se ura. Ia na e tai lolololo, eto, Natugu baina lao henia mase gabuna ai mai taigu ida. Tamana ese unu e tailaia toma. ");
INSERT INTO meu_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","A Midian taudia ese Iosef e hoia Aigupto ai, Potifara, Farao ena tuari oreana biaguna ta, enai. ");
INSERT INTO meu_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Nega ta Iuda ese tadikakana e rakatanidia, ela, Adulama tauna ta, ladana Hira, dekenai e nohova. ");
INSERT INTO meu_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Unuseni ai ia ese Kanaan tauna ta, ladana Sua, natuna ulatona e itaia; bena e adavaia. ");
INSERT INTO meu_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Una hahine e mara, mero ta e abia, ladana e hatoa Ere; ");
INSERT INTO meu_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ma ta e abia, ladana e hatoa Onan; ");
INSERT INTO meu_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ma ihatatoina e abia, ladana e hatoa Sela. Una mero e vara negana ai, hahine na Kesib ai e nohova. ");
INSERT INTO meu_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Iuda ese hane-ulato ta davana e heni, natuna roboana Ere adavanaai bainela; ia ladana na Tamara. ");
INSERT INTO meu_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","A hari Ere, Iuda natuna roboana, na Iehova vairanai e kara havara, bena Iehova ese e alaia mase. ");
INSERT INTO meu_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Bena Iuda ese Onan e haduaia, eto, Vabu enai ba raka vareai, bavadavaia, natuna ba havaraia, kakamu ena. ");
INSERT INTO meu_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Bena Onan dibana mero na basie gwauraia ia natuna dainai ia na hahine enai e raka vareai, a gau be tano ai e hahebubua, natuna ta basine vara helaoreana. ");
INSERT INTO meu_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Una kara dikana dainai Iehova ese e badu henia, e alaia mase, kakana bamona. ");
INSERT INTO meu_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Bena Iuda ese ravana Tamara e hamaoroa, eto, Do ba lou lao, tamamu ena ruma ai ba noho vado, ela bona natugu Sela baine bada. Ena lalo-hadai korikori be Sela danu baine mase, kakana heḡereḡeredia. Taunabunai, Tamara na e lou lao. tamana ena ruma ai e nohova. ");
INSERT INTO meu_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Nega taina vada ela, bena Sua natuna, hari Iuda e adavaia hahinena, na e mase. Bena Iuda ena lalo-hisihisi e ore ai, ia na e tore isi, Timuna ela; ena mamoe huidia e utu gabuna bunai. Ia turana Hira, tau Adulama, ese e bamoa. ");
INSERT INTO meu_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamara ese ravana harina e kamonai, ia na mamoe huidia iutudia totona Timuna e laova; ");
INSERT INTO meu_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","bena ia ese ena vabu dabuadia e doki oho, vairana na dabua amo e ḡovaia, ela, Timuna dalana isena ai e helai dala katakata ai. Badina be ia vada e diba hari Sela vada e tauhau, a tamana na se haheadavadia. ");
INSERT INTO meu_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Bena Iuda ese e itaia, banava ia na ariara hahinena eto, badina be vairana vada e ḡovaia. ");
INSERT INTO meu_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Bena ia ese e hereva henia, eto, Mani aita eno bou. Ia na asi dibana hahine na ia ravana. Bena hahine na eto, Davagu be dahaka ba henigu? ");
INSERT INTO meu_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ia eto, Nani natuna ta baina henimu. Hahine na eto, Toana be dahaka ba henigu ela bona ba siaia? ");
INSERT INTO meu_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ia ma eto, Dahaka bavabia o tomu? Hahine na eto, Imamu kwakikwakina vaḡivaḡina bona emu gana bona emu itotohi. E henia, bena raruosi e eno bou; gabeai hahine na e rogorogo. ");
INSERT INTO meu_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Hahine na e tore isi, ela, vairana e ḡovalaia dabuana e negea, ena vabu dabuadia e doki lou. ");
INSERT INTO meu_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Iuda ese turana Hira e siaia, nani natuna baine laohaia, bona toa gaudia hahine vada e henia ma baine abi lou. To ia na lasihia. ");
INSERT INTO meu_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Bena ia ese una gabu taudia e nanadaidia, eto, Hari ariara hahinena dala katakata ai e helaiva be edeseni ai? Idia eto, Ariara hahinena ta lasi iniseni ai. ");
INSERT INTO meu_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Taunabunai, ia na Iuda dekena e lou lao, eto, Asina davaria, bona una gabu taudia e tomu ariara hahinena ta lasi unuseni ai. ");
INSERT INTO meu_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Bena Iuda eto, Egu ḡau ia dekenai bae mia, baita hemarai garina; nani natuna na siaia, to hahinena na so davaria. ");
INSERT INTO meu_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Hua toi vada ela, bena Iuda ese harina e kamonai ia ravana Tamara na mai bogana. Bena ia eto, A hakaua lasi, lahi ai do baine mase. ");
INSERT INTO meu_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","E hakaua lasi, bena ia ese hereva e siaia ravana enai, eto, Ini ḡau biagudia ese e harogorogogu; mani a hereva, ina ima-kwakikwaki vaḡivaḡina, ina gana, ina itotohi be daika ena? ");
INSERT INTO meu_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Bena Iuda ese e gwauraia hedinarai, eto, Iena kara maoromaoro ese lauegu e hereaiamu, badina be natugu Sela ida asina haheadavadia. Bena ia ida se eno bou lou. ");
INSERT INTO meu_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ena mara negana vada e kahira-kahira, vada e diba hekapa na bogana ai. ");
INSERT INTO meu_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Bena e mara negana ai, mero ta imana e toia lasi, bena hegwaroto hahinena ese varo kakakakana ta imana ai e kwatua, eto, Roboana binai. ");
INSERT INTO meu_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","A mero na imana ma e veria vareai, bena tadina e vara guna. Hegwaroto hahinena na eto, Oi na dala vada o lailaia. Bena ladana e hatoa Perese. ");
INSERT INTO meu_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Bena kakana e vara; ia ladana e hatoa Sera. ");
INSERT INTO meu_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Iosef na Aigupto e laohaia, unuseni ai Aigupto tauna ta, lohia ta Farao ena ruma ai, ladana Potifara, ese e hoia, hari Ismael taudia, e hakaua lao taudia, edia amo. ");
INSERT INTO meu_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","A Iehova ese Iosef e haḡerea, bena vada e namo: ia ese biaguna, Aigupto tauna, ena ruma ai e nohova. ");
INSERT INTO meu_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Bena biaguna ese e itaia, Iehova ese e bamoava bona ena kara iboudiai anidia e havara; ");
INSERT INTO meu_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ena hesiai ḡaukaradia danu vada e ita, vada e namo herea. Bena ia ese ena ruma ita-taona tauna ai e halaoa, ena kohu idoinai baine reḡua. ");
INSERT INTO meu_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Bena ena ruma ita-taona bona ena kohu ireḡuna tauna ai e halaoa dinana amo Iehova ese Aigupto tauna e hanamoa, Iosef dainai: Iehova ena hahenamo na ena ruma latanai bona ena uma latadiai e miava. ");
INSERT INTO meu_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ena ḡau idoidiai Iosef imana ai e ato: ḡau ta se laloa, ana aniani vairanai e dabaraia mo, vadaeni. Hari Iosef na raho-namo merona. ");
INSERT INTO meu_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Bena nega ta ia biaguna adavana ese e ḡahusia, bena e hamaoroa, eto, Aita eno bou. ");
INSERT INTO meu_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","A Iosef na se ura; e haere henia, eto, Vada o itaia, biagugu na egu ḡaukara ruma ai se itaia taomu, ena kohu idoinai danu lau imagu ai vada e atoa. ");
INSERT INTO meu_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Tau ta se hereagumu ina ruma ai; egu ai ḡau ta se ruamu, oi mo e rumumu, badina be oi na ia adavana. Ina kerere badana baina karaia, Dirava vairanai baina kara havara, be edeheto? ");
INSERT INTO meu_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","A hahine ese dina ta ta amo Iosef lalona e ania, raruosi bae eno bou eto; to ia ese se kamonai heniava. ");
INSERT INTO meu_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Nega ta, ia na ruma lalonai e raka vareai; ruma na asi tauna. ");
INSERT INTO meu_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Bena hahine ese ena dabua e dogoa tao, e veria, eto, Aoma, aita eno bou. A ia ese ena dabua na hahine imana ai e rakatania, ruma amo e heau lasi. ");
INSERT INTO meu_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Hahine na e itaia, ena dabua na ia imana ai vada e rakatania, vada e heau lasi: ");
INSERT INTO meu_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","bena ia ese ruma taudia e boiridia, e hamaorodia, eto, O itaia, ia ese ina Heberu tauna vada e abia dae, ita ihakavakavada. Ia na lau dekegu ai e raka vareai, baia eno bou eto: na lolo, ");
INSERT INTO meu_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","bena gadogu e kamonai negana ai ena dabua na imagu ai e rakatania, e heau lasi. ");
INSERT INTO meu_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Bena hahine na hari dabua e dogoa tao ela bona Iosef biaguna ema. ");
INSERT INTO meu_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Bena ma e hamaoroa, eto, Ina Heberu tauna eda ruma ai o abia dae, eda hesiai ilao-henina, na egu ai e raka vareai, baine hakavakavagu eto; ");
INSERT INTO meu_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","bena na lolo negana ai ia ese ena dabua e rakatania, e heau lasi. ");
INSERT INTO meu_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ruma tauna ese adavana ena hereva e kamonai, ena hesiai tauna unu vada e kara toma eto, bena e badu dikadika. ");
INSERT INTO meu_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Bena Iosef biaguna ese Iosef e dabaia tao, dibura rumana ai e koua, hanua pavapavana ena iḡui taudia e koudia gabuna ai. Bena dibura rumana ai e nohova. ");
INSERT INTO meu_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","A Iehova ese Iosef e haḡerea, e bogaia hisi, dibura rumana igimana tauna lalona e hanamoa ia enai. ");
INSERT INTO meu_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Bena dibura rumana igimana tauna ese dibura taudia iboudiai na Iosef henunai e atodia, edia ḡaukara iboudiai Iosef ese e reḡudia. ");
INSERT INTO meu_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Dibura rumana igimana tauna ese ḡau ta se laloa ena hereḡu ai; badina be Iehova ese Iosef e hagerea, bona ena ḡaukara iboudiai anidia e havara. ");
INSERT INTO meu_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ini ḡau muridiai, vine ranuna iseina memerodia ireḡudia tauna bona flaoa igabuna memerodia ireḡudia tauna Farao ena ruma ai na raruosi ese Farao e habadua. ");
INSERT INTO meu_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Bena Farao ese ena hesiai taudia raruosi, hari vine ranuna iseina memerodia bona flaoa igabuna memerodia ireḡudia taudia, na e badu henidia, ");
INSERT INTO meu_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","dibura rumana ai e koudia, hegima taudia biagudia imana ai, Iosef e nohova gabuna ai. ");
INSERT INTO meu_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Bena hegima taudia biagudia ese Iosef e hamaoroa, baine naridia; bena ia ese raruosi e naridia. Idia na nega taina daudau dibura rumana ai e nohova. ");
INSERT INTO meu_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Unu tatau raruosi na hanuaboi tamona ai e nihi: Farao ena vine ranuna iseina memerodia iregudia tauna bona ena flaoa igabuna memerodia ireḡudia tauna na ta ta ena nihi ena nihi e nihirai, dibura rumana ai. ");
INSERT INTO meu_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Daba ai, Iosef na e raka vareai, idia raruosi dekediai, bena toadia e ita, lalodia e hisihisiva. ");
INSERT INTO meu_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Bena ia ese hari Farao ena hesiai taudia, ia ida e dibura hebouva taudia, e nanadaidia, eto, Badina be dahaka vairamui o huamu? ");
INSERT INTO meu_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Idia eto, Ai na vada a nihi, bona asi tauna ta ese emai nihi anidia baine hahedinarai. Bena Iosef eto, Nihi anidia ihahedinaraidia na Dirava mo sibona: emui nihi mani a gwaurai hedinarai. ");
INSERT INTO meu_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Bena vine ranuna iseina memerodia ireḡudia tauna ese ena nihi Iosef e hahedinarai henia, eto, Egu nihi ai vine auna ta na itaia; ");
INSERT INTO meu_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","rigina na toi. Bena e gara kau, burena e vara, huahuana e dobi. ");
INSERT INTO meu_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Farao ena kehere na imagu ai, bena vine huahuadia na abi, bena na gigi, ranuna na Farao ena kehere ai e diho. Bena kehere na Farao imana ai na atoa. ");
INSERT INTO meu_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Bena Iosef eto, Emu nihi anina binai: vine rigi toiosi be dina toi. ");
INSERT INTO meu_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Dina toi baela, bena Farao ese baine abimu dae, dagimu baine henimu lou; bena Farao ena kehere na imana ai do bavatoa, gunaguna ena vine ranuna iseina memerodia o reḡudiava negana ai heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","A oiemu dala baine namo negana ai ba lalogu, ani? Ba bogagu hisi, Farao ba hereva henia daigu ai, ina dibura rumana amo ba hakaugu lasi. ");
INSERT INTO meu_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Badina be momokani lau na Heberu taudia edia tano ai e abigu mauri; iniseni ai danu kerere ta asina karaia, a dibura rumana ai e kougu kava. ");
INSERT INTO meu_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Flaoa igabuna memerodia ireḡudia tauna vada e diba hari nihi anina be namo, bena ia ese Iosef e hamaoroa, eto, Lau danu na nihi; egu nihi lalonai flaoa boseadia toi kwaragu ai na ato, na oradia loaloa; ");
INSERT INTO meu_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","bena atai boseana lalonai na flaoa e gabu ḡaudia idau-idau mimia, Farao ana, a manu haida e roho ema, e ani. ");
INSERT INTO meu_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Bena Iosef eto, Emu nihi anina binai: bosea toiosi be dina toi. ");
INSERT INTO meu_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Dina toi baela, bena Farao ese dibura rumana amo baine abimu, au ta ai baine taumu dae, bena manu bae roho mai, tau-animu bae ania. ");
INSERT INTO meu_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Dina ihatoina be Farao ena vara dinana, bena ia ese aria ta e karaia, ena hesiai taudia iboudiai e vavedia; hari vine ranuna iseina memerodia ireḡudia tauna bona flaoa igabuna memerodia ireḡudia tauna danu e vavedia. ");
INSERT INTO meu_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Bena vine ranuna iseina memerodia ireḡudia tauna ena dagi e henia lou; ia ese kehere Farao imana ai ma e atoa. ");
INSERT INTO meu_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","A flaoa igabuna memerodia ireḡudia tauna na e taua dae ela bona e mase, Iosef ena hereva heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","A hari vine ranuna iseina memerodia ireḡudia tauna ese Iosef se laloa tao; e laloa boio. ");
INSERT INTO meu_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Laḡani rua vada e lao bubuni, bena Farao e nihi. Ena nihi ai ia na sinavai badana isena ai e gini. ");
INSERT INTO meu_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Bena boromakau hitu sinavai badana amo e dae, taudia nanamo bona mai digaradia, sinavai isena ai e anianiva. ");
INSERT INTO meu_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Idia muridiai boromakau idaudia hitu sinavai badana amo ma e dae, taudia didika bona vavaroda-vavaroda, hari mai digaradia ḡaudia badibadidiai e gini. ");
INSERT INTO meu_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Bena hari boromakau varoda-varodadia hituosi ese boromakau mai digaradia hituosi e anidia ore. Bena Farao na e noga. ");
INSERT INTO meu_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ma e mahuta lou, e nihi. Ena nihi iharuana ai ia ese uit tuhutuhuna tamona amo anidia hitu e tubu e itadia, unu uit anidia be nanamo bona babada. ");
INSERT INTO meu_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Idia muridiai uit tuhutuhuna ta amo anidia hitu ma e tubu, unu uit anidia be didika bona mamaraḡi, lai mairiveina ese e hamarai ḡaudia. ");
INSERT INTO meu_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Bena hari uit anidia dikadia ese uit anidia namodia e anidia ore. Bena Farao na e noga, vada e diba nihi mo. ");
INSERT INTO meu_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Daba ai kudouna e hetaha; bena ia na e hesiai, Aigupto ai babalau taudia iboudiai bona aonega taudia iboudiai e boiridia. Bena Farao ese ena nihi e hamaorolaidia, to idia iboudiai na anidia igwauraidia asi dibadia. ");
INSERT INTO meu_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Bena vine ranuna iseina memerodia ireḡudia tauna ese Farao e hamaoroa, eto, Lau ese egu kerere hari name laloa. ");
INSERT INTO meu_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Farao ese ena hesiai taudia e badu henidia negana ai na lau bona flaoa igabuna memerodia ireḡudia tauna raruosi dibura rumana igimana tauna imana ai o atomai. ");
INSERT INTO meu_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Bena hanuaboi ai raruosi a nihi, ta ta ena nihi ena nihi na mai anidia. ");
INSERT INTO meu_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Tau eregabe ta be dekemai ai, ia na tau Heberu, dibura rumana igimana tauna ena hesiai merona. Bena ai raruosi emai nihi a hamaorolaia; bena anidia ia ese e hadibamai, ta ta ena nihi ena nihi anidia. ");
INSERT INTO meu_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Taunabunai, nihi anidia ia ese e gwaurai vada e momokani: lau be o halougu egu dagi ai, a bamogu be e taua dae ela bona e mase. ");
INSERT INTO meu_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Bena Farao e hesiai, Iosef eha boiria. Bena idia ese dibura rumana amo e hakaua lasi haraḡa-haraḡa; ia ese aukina huina e abia bona ena dabuae boloa, bena Farao dekenai e raka vareai. ");
INSERT INTO meu_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Bena Farao ese Iosef e hereva henia, eto, Vada na nihi, to nihi anina ihahedinaraina be asi tauna; a harimu vada na kamonai, nihi anidia ihahedinaraidia na mai dibamu. ");
INSERT INTO meu_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Iosef ese Farao e haere henia, eto, Dia lau, a Dirava ese Farao baine haere henia, maino herevana ai. ");
INSERT INTO meu_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Bena Farao ese Iosef e hamaoroa, eto, Egu nihi ai sinavai badana badibadinai na gini; ");
INSERT INTO meu_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","bena boromakau hitu na sinavai amo e dae, taudia nanamo bona mai digaradia, bena sinavai isena ai e anianiva. ");
INSERT INTO meu_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Gabeamo boromakau idaudia hitu ma e dae, taudia didika bona vavaroda-vavaroda, Aigupto tanona idoinai boromakau dikadia unuhetomadia na hata asina itadia. ");
INSERT INTO meu_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Bena boromakau dikadia mai varoda-varodadia ese boromakau mai digaradia hituosi e dae guna ḡaudia na e anidia ore; ");
INSERT INTO meu_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ḡau tamona, e anidia ore murinai tau ta basinema diba idia ese vada e anidia, badina be idia na dounu varoda-varoda. Bena na noga. ");
INSERT INTO meu_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Bena egu nihi ta ai, uit tuhutuhuna tamona na itaia, e tubu mai anina hitu, babada bona nanamo; ");
INSERT INTO meu_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","gabeai ta ma e tubu anina hitu, didika bona mamaraḡi, lai mairiveina ese e hamarai ḡaudia. ");
INSERT INTO meu_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Bena uit dikadia ese uit namodia e anidia ore. Lau ese babalau taudia vada na hamaorolaidia, to anina ihahedinaraina na ta asi dibana. ");
INSERT INTO meu_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Bena Iosef ese Farao e hamaoroa, eto, Farao ena nihi be tamona mo; Dirava ese ena kara ta baine karaia e tomu be Farao vada e hamaorolaia guna. ");
INSERT INTO meu_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Boromakau namodia hituosi be l=agani hitu, bona uit anidia namodia hituosi be laḡani hitu: nihi na tamona mo. ");
INSERT INTO meu_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Boromakau hituosi dikadia mai varoda-varodadia gabeai e dae ḡaudia be laḡani hitu, bona uit anidiadikadia hituosi, lai mairiveina ese e hamarai ḡaudia, idia danu laḡani hitu, doe laḡanidia. ");
INSERT INTO meu_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Farao hari na hamaoroa heḡereḡerena, Dirava ese ena kara ta baine karaia e tomu be Farao vada e hamaorolaia guna. ");
INSERT INTO meu_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Laḡani hitu be gini daemu, Aigupto tanona idoinai baine madinamo; ");
INSERT INTO meu_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","gabeamo doe laḡanidia hitu do bae gini dae, madinamo idoinai Aigupto tanona ai do bae laloa boio, badina be doe baine bada herea. ");
INSERT INTO meu_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Taunimanima ese madinamo negana na basie laloa une, doe bada lalonai bae dabu vaitani dainai. ");
INSERT INTO meu_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Farao na harua e nihi, badina be Dirava ese ina ḡau vada e gwauraia, bona asi vanahana ia ese baine havaraia. ");
INSERT INTO meu_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Namona binai: Farao ese lalo-parara bona aonega tauna ta baine tahua, Aigupto tanona biaguna ai baine halaoa. ");
INSERT INTO meu_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Farao na unu baine kara toma, bona tano ita-taona taudia baine gwauraidia danu: unu madinamo laḡanidia ai aniani ḡaudia iboudiai ina Aigupto tanona ai bae karoadia, karoa ima, bena karoa ta roge ai bae haboua. ");
INSERT INTO meu_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Madi-namo laḡanidia anianidia iboudiai bae habou, Farao imana ai, bae mia, hanua hanua lalodiai. ");
INSERT INTO meu_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Una aniani na roge ai baine mia ela bona doe laḡanidia hituosi na Aigupto ai bae gini dae; bena ina tano taunimanimadia na basie hitolo mase. ");
INSERT INTO meu_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Farao mai ena hesiai taudia ida ese una hereva e abia dae. ");
INSERT INTO meu_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Bena Farao ese ena hesiai taudia e hereva henidia, eto, Edeseni ai tau ta baita davaria ina tau heḡereḡerena: Dirava ena Lauma be ia lalonai ani? ");
INSERT INTO meu_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Bena Farao ese Iosef e hereva henia, eto, Dirava ese ina idoinai vada e hahedinarai henimu, bona asi tauna ta mai ena lalo-parara bona mai ena aonega oi heḡereḡeremu. ");
INSERT INTO meu_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Una dainai, oi ese egu ruma ba halohiaia, egu basileia idoinai oi eremu bae kamonai; lau hanua pavapavana taugu mo ese oi baina hereamu. ");
INSERT INTO meu_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Farao ese Iosef ma e hereva henia, eto, A kamonai lau ese Aigupto tanona idoinai lohiana ai name halaomu. ");
INSERT INTO meu_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Bena Farao ese ia imana kwakikwakina vaḡivaḡina imana amo e abia, Iosef imana kwakikwakina ai e toia vareai; dabua namo-hereadia danu e hahedokilai, bona gold agevana na aiona ai e atoa kau. ");
INSERT INTO meu_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","E haduaia danu, kariota iharuana, iena kariota murinai e heauva ḡauna, latanai baine gui. Haida danu ia vairanai e heau, e boiboi, eto, Dala a lailaia. Unuhetomana ia ese Aigupto tanona idoinai lohiana ai e halaoa. ");
INSERT INTO meu_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Bena Farao ese Iosef e hamaoroa, eto, Lau binai Farao; oi basio hereva negana ai tau ta ese kara ta basine karaia ina Aigupto tanona idoinai. ");
INSERT INTO meu_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Bena Farao ese Iosef ladana e hatoa Safenat-panea; Asenat danu e henia, baine adavaia; una Asenat na Ono ena hahelaḡa tauna, ladana Potifera, natuna. Bena Iosef na Aigupto tanona idoinai e rakaia hanai. ");
INSERT INTO meu_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Iosef ena mauri laḡanidia na toi-ahui, ia Farao, Aigupto pavapavana, vairanai e gini negana ai. Bena Iosef na Farao vairana amo e raka lasi, Aigupto tanona idoinai e rakaia hanai. ");
INSERT INTO meu_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Bena madinamo laḡanidia hituosi lalodiai uma anidia vada e bada herea. ");
INSERT INTO meu_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Unu laḡani hitu lalodiai Iosef ese aniani idoinai e haboua, hanua hanua rogedia ai. Hanua ta ta umadia anianidia na unu hanua ta ta rogedia ai e habou. ");
INSERT INTO meu_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Taunabunai, Iosef ese uit e habou, kone mirina na heto, ela bona iduahina e hadokoa, badina be asi iduahina dalana. ");
INSERT INTO meu_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Doe negana na do se gini dae ai, Iosef natuna mamaruanedia rarua e vara, Asenat, Ono ena hahelaḡa tauna Potifera natuna, bogana amo. ");
INSERT INTO meu_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Roboana na Iosef ese ladana e hatoa Manase; eto, Dirava ese egu hekwarahi bona tamagu ena ruma ilalolaidia na egu amo vada e abi oho. ");
INSERT INTO meu_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","A tau muritai ladana e hatoa Efraim; eto, Hisi na ani tanona ai Dirava ese besegu vada e henigu. ");
INSERT INTO meu_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Madinamo laḡanidia hituosi vada e ore Aigupto ai, ");
INSERT INTO meu_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","bena doe laḡanidia gini-gunana vada e gini dae, Iosef ena hereva heḡereḡerena. Bena tano idau-idau iboudiai lalodiai taunimanima e hitolodiava; a Aigupto ai aniani na mia. ");
INSERT INTO meu_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Bena Aigupto tanona idoinai taunimanima e hitolodiava ai idia ese Farao e tai henia, aniani baine henidia. Bena Farao ese e hamaorodia, eto, Iosef dekena aola, ia ede baine hamaoromui toma vada ba karaia. ");
INSERT INTO meu_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Tanobada idoinai doe vada e bada. Bena Iosef ese ena roge iboudiai e keho, Aigupto taudia ese aniani e hoia, moni davana; badina be doe na bada herea Aigupto tanona ai. ");
INSERT INTO meu_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Bena tano idau-idau iboudiai amo e hesiai ela, Aigupto ai aniani e hoi, Iosef dekenai; badina be doe na bada herea, tanobada idoinai. ");
INSERT INTO meu_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Iakob ese harina e kamonai Aigupto be mai uitina, bena ia ese natuna e gwau henidia, eto, Badina be dahaka o herarai hehenimu? ");
INSERT INTO meu_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ma eto, Vada na kamonaimu Aigupto be mai uitina; baola, unuseni ai ita ada ba hoia, baita mauri helaoreana; bena basita mase. ");
INSERT INTO meu_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Bena Iosef kakana gwauta-osi Aigupto ela, uit ihoina; ");
INSERT INTO meu_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","a Beniamina, Iosef tadina, na Iakob ese e rua, kakana ida basinela; badina be ia eto, Dika ese bema butua tao na garina. ");
INSERT INTO meu_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Taunabunai, Israel natuna na taunimanima loḡora ida uit ihoina ela; badina be doe na bada Kanaan tanona ai. ");
INSERT INTO meu_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Iosef na tano idoinai lohiana, taunabunai taunimanima iboudiai ia dekena ela, uit e hoia. Iosef kakana danu ia dekena ela, ia vairanai e goru diho. ");
INSERT INTO meu_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Iosef ese kakana e itadia negana ai, ia lalona vada e parara idia be daidia, to e hereva henidia idau tauna na heto, e gwau henidia, eto, Umui be ede amo oma? Idia eto, Kanaan tanona amo ama, aniani ihoina totona. ");
INSERT INTO meu_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Iosef be kakana dibana, to idia asi dibadia ia. ");
INSERT INTO meu_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Bena Iosef ese ena nihi ai idia e nihiraidia e helalolai une. Bena e gwau henidia, eto, Umui na hasinadoa taumui; ina tano ena manoka itana oma. ");
INSERT INTO meu_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Idia ese e haere henia, eto, Ḡaubada e, lasi, dia unuheto; ai na oi isiaimu ilao-henina taumai, aniani ihoina totona ama. ");
INSERT INTO meu_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ai na tau tamona natuna, hereva momokani taumai; asia hasinadoamu. ");
INSERT INTO meu_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","A ia ese ma e gwau henidia, eto, Lasi, tano ena manoka itana totona oma. ");
INSERT INTO meu_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Idia ma eto, Ai na oi isiaimu ilao-henina taumai, tadikaka gwauta-rarua, tau tamona natuna Kanaan ai; a tau-muritai be harihari tamamai dekenai, bona ta be vada e mase. ");
INSERT INTO meu_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","A Iosef eto, Vada na hereva, ani, umui be hasinadoa taumui. ");
INSERT INTO meu_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","A baina dibamui: Farao maurina ai na herevamu, ini amo basio raka oho ela bona tadimui bainema. ");
INSERT INTO meu_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Umui emui amo ta ba siaia, tadimui baine hakaua mai; a orena be dibura rumana ai ba noho. Unu amo baina dibamui, emui hereva be momokani eiava lasi. Bema lasi, umui na momokani hasinadoa taumui. ");
INSERT INTO meu_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Taunabunai, ia ese dibura rumana ai e koudia, dina toi. ");
INSERT INTO meu_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Dina ihatoina ai, Iosef ese e hereva henidia, eto, Ini ba kara toma, bena ba mauri; badina be lau danu Dirava garina na garimu. ");
INSERT INTO meu_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Bema umui na hereva momokani taumui, umui ta ese dibura rumana ai baine noho, a orena be vada baola, uit ba laohaia, varavaramui adia. ");
INSERT INTO meu_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Bena ba lou mai, tadimui ba hakaua mai dekegu ai; unu amo baina diba emui hereva na momokani, bena basio mase. Unu ba kara toma. ");
INSERT INTO meu_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Bena idia na e hereva heheni, eto, Momokani, ita na vada ta kerere tadida dainai; badina be ena taitai ta kamonai, to ena noinoi asita abia dae; una dainai ina hekwarahi na ita edai vada e kau. ");
INSERT INTO meu_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Bena Ruben eto, Lau na hamaoromui, ani, nato “Mero na basio hadikaia”, to umui na asio kamonai, harihari ia rarana na ita latadai. ");
INSERT INTO meu_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Idia na asi dibadia Iosef na edia hereva anidia dibana, badina be ia na gado-hanai tauna uduna amo mo vada e hereva henidia. ");
INSERT INTO meu_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Bena ia na e raka siri, e tai; gabeamo e lou henidia, e hereva henidia. Bena ia ese Simeon e abia, gadea amo e ḡuia idia vairadiai. ");
INSERT INTO meu_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Bena Iosef e hahedua, edia puse na uit amo bae hahonu, bona ta ta edia moni edia puse ai bae uda lou, bona dala lakwana danu bae henidia. Bena unu e kara toma. ");
INSERT INTO meu_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Bena edia puse na edia doniki dorudia ai e ato kau, e raka lao. ");
INSERT INTO meu_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Adorahi ai e taruha, bena ta ese ena puse e kehoa, ena doniki baine ubua eto; bena ena moni e itaia, puse uduna ai. ");
INSERT INTO meu_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Bena ia ese tadikakana e hamaorodia, eto, Egu moni vada e haloua, ḡauna na egu puse ai. Bena kudoudia e hetaha, gari ese e butudia tao, e hereva heheni, eto, Dirava na ede vada e karada toma? ");
INSERT INTO meu_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kanaan tanona ai e kau, tamadia Iakob dekenai. Bena edia laolao sivaraina e hamaorolaia, eto, ");
INSERT INTO meu_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Una tano lohiana ese e daḡedaḡe henimai, dibura rumana ai e koumai, eto ai na hasinadoa taumai. ");
INSERT INTO meu_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","A ia ese a hamaoroa, ato “Ai na hereva momokani taumai, dia hasinadoa; ");
INSERT INTO meu_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ai na tadikaka gwauta-rarua, tau tamona natuna, a ta vada e mase, bona taumuritai be tamamai dekenai, Kanaan tanona ai.” ");
INSERT INTO meu_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Bena una tano lohiana eto “Ini amo baina diba umui na hereva momokani taumui eiava lasi: umui ta baina dogoa tao iniseni ai, a orena be uit ba laohaia, varavaramui adia; ");
INSERT INTO meu_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","bena tadimui tau-muritai tauna ba hakaua mai dekegu ai, bena bainadiba umui be hereva momokani taumui; bena tadikakamui na baina henimui lou, bona ina tano ai ba hoihoi danu”. ");
INSERT INTO meu_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Bena uit na edia puse amo e bubua negana ai, ta ta edia moni e davari edia puse ai; bena idia bona tamadia moni e itaia ai e gari dikadika. ");
INSERT INTO meu_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Bena tamadia Iakob ese e gwau henidia, eto, Natugu na egu amo vada o abidia oho: Iosef vada e boio; Simeon vada e boio; harihari Beniamina danu bavabia oho o tomu; ini hisihisi iboudiai na lau mo latagu ai. ");
INSERT INTO meu_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Bena Ruben ese tamana e hamaoroa, eto, Beniamina basina hakaua lou dekemu ai, lau natugu raruosi bavaladia mase. Lau imagu ai ba siaia, bena lau ese ma baina mailaia mai maurina ida. ");
INSERT INTO meu_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","A Iakob eto, Natugu basina kahua nege, basio laohaia; badina be kakana korikori vada e mase, ia mo sibona dekegu ai e nohomu. Dala ai dika ta ienai bema kau, lau buruka taugu na umui daimui ai mase gabuna bama lao henia mai lalo-hisihisigu ida. ");
INSERT INTO meu_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Tano idoinai hitolo na bada herea. ");
INSERT INTO meu_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Aigupto amo e mailaia uitina vada e ania ore, bena tamadia ese e hamaorodia, eto, Ma baola, aniani taina ba ha hoia ada. ");
INSERT INTO meu_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Bena Iuda ese e haere henia, eto, Una tau ena hereva na auka, eto “Tadimui basio hakaua mai, lau vairagu basio itaia”. ");
INSERT INTO meu_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Taunabunai, tadimai ba siaia, ai ida baiala, aniani baia ha hoia amu; ");
INSERT INTO meu_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","a basio siaia, ai na basiala, badina be una tau eto “Tadimui basio hakaua mai, lau vairagu basio itaia”. ");
INSERT INTO meu_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Bena Israel eto, Edeheto umui ese lau o hadikagu, tadimui herevana o hahedinaraia? ");
INSERT INTO meu_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Idia eto, Una tau ese e nanadaimai malakamalaka, eda iduhu herevadia e nanadailai, eto, “Tamamui dounu e mauri nohomu?” bona “Tadimui ta noho?” Bena ai ese a haere henia. Ede baiama diba toma ia baineto “Tadimui ba hakaua mai” a? ");
INSERT INTO meu_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Bena Iuda ese tamana Israel e noia, eto, Mero na ba siaia, baia tore isi, baiala; unu amo baita mauri, basita mase, oi bona natumai maraḡidia danu. ");
INSERT INTO meu_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Lau ese do baina naria; lau dekegu ai ba tahua. Basinama loulaia dekemu ai, vairamu ai basinama hakaua, kerere na lau latagu ai bema mia hanaihanai. ");
INSERT INTO meu_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Basiama halahe, ina laolao iharuana harihari baiama haḡuḡurua. ");
INSERT INTO meu_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Bena tamadia Israel ese e haere henidia, eto, Bema dala idauna ta lasi, ini ba kara toma: eda tano anidia namo-hereadia bavabi kau, emui maduna ai, muramura mai bonadia, bada ranuna, aniani ihanamodia muramuradia, au-huahuadia aukadia, una tau ena. ");
INSERT INTO meu_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Moni ikumidia rua rua danu bavabi kau; emui puse ai e uda lou monidia danu ba loulai, badina be e uda taudia na e kerere readia. ");
INSERT INTO meu_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Tadimui danu ba hakaua lao, una tau do ba lou henia. ");
INSERT INTO meu_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Siahu-idoinai Diravana ese baine bogamui hisi una tau vairanai baine durumui, bena ia ese tadikakamui ta baine ruhaia nege, bona Beniamina danu baine haloua. A natugu na egu ai bae boio, vadaeni, vada bae boio. ");
INSERT INTO meu_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Taunabunai, idia ese herahia e abi kau, tamadia ena hereva heḡereḡerena, bona moni ikumidia rua rua amo, bona Beniamina danu e hakaua. Bena e tore isi, Aigupto tanona ela, Iosef vairanai e gini. ");
INSERT INTO meu_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Iosef ese Beniamina e itaia, bena ena hesiai tauna e haduaia, eto, Ini tatau na ba hakaudia lao egu ruma lalonai; aniani danu ba dabaraia, badina be dina tubua ai idia na lau ida baia aniani hebou. ");
INSERT INTO meu_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Bena hesiai tauna na Iosef ena hereva heḡereḡerena e hakaudia lao, Iosef ena ruma ai e hakaudia vareai. ");
INSERT INTO meu_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Bena hari tatau e gari dikadika, Iosef ena ruma ai e hakaudia vareai dainai. Idia na e hereva heheni, eto, Nega gini-gunana ai moni euda lou eda puse ai dainai; ia na ihabadelaida dalana e tahuamu, bena baine ḡuida, ena hesiai ai baine halaoda, eda doniki danu baine abidia iena. ");
INSERT INTO meu_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Taunabunai idia na Iosef ena hesiai tauna dekena ela, ruma iduarana ai; ");
INSERT INTO meu_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","e hamaoroa, eto, Ḡauka e, nega gini-gunana ama, aniani ihoina moama; ");
INSERT INTO meu_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","to emai taruha gabuna ai a kau, emai puse a keho, bena emai moni a ita, ta ta ena puse ena puse ai e heuda, emai moni idoinai; harihari vada a mailai, baia heni lou a tomu. ");
INSERT INTO meu_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Bona moni haida danu vada a mailai, aniani ihoilaina. A asi dibamai daika ese emai moni na e uda lou emai puse ai. ");
INSERT INTO meu_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Bena hari hesiai tauna eto, Maino avabia, basio gari; emui Dirava, tamamui danu ena Dirava, ia ese emui puse e hatagadia; emui moni na lau ese na abi. Bena ia ese Simeon e hakaua lasi dekediai. ");
INSERT INTO meu_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Bena una hesiai tauna ese ena ruma lalonai e hakaudia vareai, aedia ihurilaidia ranuna e henidia, bona edia doniki danu e ubudia. ");
INSERT INTO meu_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Bena edia herahia e heḡaeḡaelai, Iosef dina tubua ai bainema bae henia eto, badina be vada e diba idia na unuseni ai bae aniani. ");
INSERT INTO meu_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Iosef e raka vareai, bena e haḡaeḡaelai ḡaudia vada e henia, bona e goru goru diho tano ai, ia vairanai. ");
INSERT INTO meu_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Bena ia ese e nanadaidia, eto, Umui be edeheto? Tamamui danu namo a, hari tau buruka vanegai sivaraina o gwauraia; ia dounu mauri eiava? ");
INSERT INTO meu_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Idia na e haere, eto, Emu hesiai tauna ai tamamai be namo, dounu e mauri nohomu. Bena idia na e igo diho, e hanamoa. ");
INSERT INTO meu_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Bena ia matana e roha isi, tadina Beniamina e itaia, ia sinana natuna; bena eto, Tadimu tau-muritai benai a, vanegai sivaraina o gwauraia merona? Ma eto, Natugu e, Dirava ese baine bogamu hisi. ");
INSERT INTO meu_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Bena Iosef lalona e manoka: tadina e bogaia hisi bada dainai ia na e raka vareai ena daiutu lalonai, unuseni ai e tai. ");
INSERT INTO meu_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Bena vairana e huria, e raka lasi, e haheauka, eto, Aniani a dabaraia. ");
INSERT INTO meu_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Bena aniani e dabaraia, pata ta ai Iosef ana, pata ta ai idia adia, bona ma pata ta ai Aigupto taudia adia. Badina be Aigupto taudia na Heberu taudia ida basie aniani hebou, mai edia taravatu dainai. ");
INSERT INTO meu_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Bena edia helai gabudia vada e henidia ia vairanai; edia vara heḡereḡeredia, tau-roboana ela bona tau-muritai. Taunabunai e heita heheni, bona e hoa. ");
INSERT INTO meu_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Bena Iosef ese aniani iena pata amo e abia, e siaia dekediai, a Beniamina ana ha-ima e siaia. Vine ranuna danu ia ida e inu hebou. ");
INSERT INTO meu_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Bena Iosef ese ena ruma ireḡuna tauna e haduaia, eto, Ini tatau edia puse aniani ai ba hahonu, bae honu namonamo, bona edia moni danu edia puse ududia ai ba uda. ");
INSERT INTO meu_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Bona egu kehere, hari silver ḡauna, taumuritai ena puse uduna ai ba udaia, bona ena uit ihoilaina monina danu. Bena ia ese Iosef ena hereva heḡereḡerena e karaia. ");
INSERT INTO meu_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Daba ai, hari tatau mai edia doniki e siaidia lao. ");
INSERT INTO meu_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Hanua e rakatania, a do asie raka daudau ai, Iosef ese ena ruma ireḡuna tauna e haduaia, eto, A tore isi, a ḡavadia; ba lasidia tao negana ai ba gwau henidia, baoto “Badina be dahaka umui ese namo dika vada o davalaia a? ");
INSERT INTO meu_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Biagugu ena kehere, ena inuinu bona ena baguhaoro ḡauna, vada o henaoa. Umui vada o kerere dikadika”. ");
INSERT INTO meu_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Taunabunai, ia ese e lasidia tao, bena unu e gwau henidia toma. ");
INSERT INTO meu_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Idia ese e haere henia, eto, Dahaka dainai ḡaubada na unu e gwau tomamu? Emu hesiai taudia na unu asia kara toma. ");
INSERT INTO meu_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","O itaia, emai puse ududia ai a davari monidia na a henimu lou, Kanaan amo a lou mai negana ai: benaini, dahaka dainai biagumu ena ruma ai silver eiava gold baiama henao? ");
INSERT INTO meu_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","A boma davaria oi isiaimu ilao-henina taumai ta unu vada e kara toma, ia na baine mase, bona ai be biagumui ena hesiai taudia ai baiala. ");
INSERT INTO meu_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Bena ia eto, Benaini, ini baita kara toma: ena puse ai baina davaria tauna be egu hesiai tauna ai bainela, a orena be baina kahumui nege. ");
INSERT INTO meu_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Bena ta ta ena puse ena puse e abi dobi haraḡa, e ruha. ");
INSERT INTO meu_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Bena hari tau ese e hetahu, tau guna enai itahuna e matamaia, ela bona tau-muritai enai e hadokoa. Kehere na Beniamina ena puse ai e davaria. ");
INSERT INTO meu_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Bena edia dabua e dare, edia doniki madunadia dorudia ai ma e ato kau, hanua e lou lao. ");
INSERT INTO meu_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Iuda mai tadikakana ida Iosef ena ruma ai e gini dae negana ai, Iosef na do ruma ai, bena idia ese ia vairanai e goru goru diho. ");
INSERT INTO meu_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Bena Iosef ese e gwau henidia, eto, Ede vada o kara toma? Umui asio laloa lau na bagu-haoro taugu a? ");
INSERT INTO meu_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Bena Iuda eto, Egu lohia e, ede baia hereva henimu toma? Ede baia maoro toma oi vairamu ai? Dirava ese emu hesiai taudia emai kerere vada e hahedinaraia; harihari ai na oi imamu ai, ai bona ena puse ai emu kehere e davaria tauna danu. ");
INSERT INTO meu_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","A Iosef eto, Lasi, unu basina karamui toma; egu kehere e abia tauna hari egu hesiai tauna ai bainela, a umui be tamamui dekena ba lou lao mai mainomui ida. ");
INSERT INTO meu_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Bena Iuda na e raka henia kahi, eto, Mani emu kara lau binai emu hesiai tauna na biagugu baina hereva henimu; mani emu kara emu badu do baine keruma emu hesiai tauna egu ai: badina be oi na Farao heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Egu lohia e, emu hesiai taudia o nanadaimai, oto, “Tamamui eiava tadimui nonoho a?” ");
INSERT INTO meu_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Bena a haere henimu, ato “Tamamai burukana e nohomu, bona mero ta, tau-badana ai e abia; una mero kakana vada emase, sinana natuna tamona mo na ia, una dainai tamamai ese e lalokau henia badamu”. ");
INSERT INTO meu_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Bena oi ese o haḡanimai, oto “Ba hakaua mai, lau baina itaia”. ");
INSERT INTO meu_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Bena ai ese a haere henimu, ato “Tamana na basine kahua nege; badina be ia bema raka oho, tamana bema mase”. ");
INSERT INTO meu_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Bena oi ese o hamaoromai, oto “Tadimui tau-muritai basio hakaua mai, lau vairagu basio itaia lou”. ");
INSERT INTO meu_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Bena emu hesiai tauna, ai tamamai, dekena a lou lao, lohia taumu emu hereva a hamaorolaia. ");
INSERT INTO meu_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Bena tamamai eto “A lou lao, ada aniani taina ma bavabia”. ");
INSERT INTO meu_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Bena ai ato “Tadimai tau-muritai na ai ida baiala be vada baiala; badina be tadimai na ai ida basiala, una tau vairana basia itaia lou”. ");
INSERT INTO meu_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Bena tamamai eto “Umui dibamui adavagu ese memero rarua e abidia; ");
INSERT INTO meu_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ta e rakatanigu, bena nato ‘Ḡau ta ese vada e darea patapata’, bena asina itaia lou ema bona harihari. ");
INSERT INTO meu_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","A harihari ina ta danu egu ai bavabia oho, bena dika ta ienai baine kau, lau buruka taugu na umui daimui ai mase gabuna bainala mai lalo-hisihisigu ida”. ");
INSERT INTO meu_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Taunabunai, emu hesiai tauna lau tamagu dekena bama lou lao, a mero basinama hakaua lao, bena ia bona hari mero na e kara mauri tamona na heto dainai ");
INSERT INTO meu_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ia baine itamai mero na lasihia negana ai ia na baine mase; oibe tamamai tau-buruka na mase gabuna bainela mai lalo-hisihisina ida. ");
INSERT INTO meu_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Badina belau ese tamagu na gwau henia hamata, ina mero bagunai, nato “Basina hakaua lou dekemu ai mai maurina ida, kerere na lau latagu ai baine mia ela bona hanaihanai”. ");
INSERT INTO meu_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Taunabunai na noimumu, lau ese emu hesiai tauna ai bainala, ina mero ibolona, a ia ese kakana ida bae lou lao. ");
INSERT INTO meu_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Badina be ede baina haheauka toma, tamagu dekena baina lou lao a mero basina hakaua lao, bena dika tamagu enai baine vara be baina itaia? ");
INSERT INTO meu_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Iosef na badibadinai e gini taudia vairadiai lalona iha-aukana asi dibana; bena e lolo, eto, Taunimanima iboudiai na vairagu ai bae raka lasi. Bena asi tauna ta dekediai Iosef ese tadikakana e hahedinarai henidia, ia be daika. ");
INSERT INTO meu_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ḡau tamona, e tai lolololo dainai Aigupto taudia bona Farao ena ruma taudia iboudiai na ena tai e kamonai. ");
INSERT INTO meu_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Bena Iosef ese tadikakana e hereva henidia, eto, Lau binai Iosef, Tamagu na dounu e mauri nohomu eiava? A tadikakana na ihaere-henina asi dibadia, badina be kudoudia e hetaha. ");
INSERT INTO meu_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Bena Iosef ese tadikakana ma e hamaorodia, eto, Mani a raka kahi mai. Bena idia na e raka henia kahi. Ia ma eto, Lau binai tadimu Iosef, vada o hoigu, bena Aigupto nama. ");
INSERT INTO meu_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Lalomui basie hisihisi, bona basio hebadu heheni, o hoigu bona ini nama dainai; badina be Dirava ese e siaigu baina gunalaimui, ihamaurimui totona. ");
INSERT INTO meu_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Badina be ini laḡani rua be doe laḡanidia, a doe laḡanidia ima do mimia, unu laḡani lalodiai tano basie ruaia bona uit basie utua. ");
INSERT INTO meu_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Dirava ese e siaigu, baina gunalaimui, umui baina hamaurimui bona besemui baina hamauridia helaoreana, bena bese badana ai baola. ");
INSERT INTO meu_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Taunabunai dia umui, a Dirava ese e siaigu iniseni ai. Ia ese vada e karagu lau be Farao tamana na heto, ena ruma idoinai biaguna ai bona Aigupto tanona idoinai lohiana ai vada e halaogu. ");
INSERT INTO meu_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Benaini, vada aola haraḡa-haraḡa tamagu dekenai, ba hamaoroa, baota “Natumu Iosef e tomu: Dirava ese Aigupto tanona idoinai lohiana ai vada e halaogu; lau dekegu baoma, basio halahe. ");
INSERT INTO meu_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Gosen tanona ai do ba noho, lau badibadigu ai: oi bona natumu bona tubumu bona emu mamoe seridia bona emu boromakau seridia bona emu ḡau idoidiai. ");
INSERT INTO meu_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Lau ese baina narimui, bena oi bona emu orea taudia iboudiai basio hitolo. Badina be doe laḡanidia ima na do mimia”. ");
INSERT INTO meu_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","O itaia: umui matamui ese vada e itaia, bona tadigu Beniamina danu matana vada e itaia, ini hereva na lau udugu amo vada e lasi. ");
INSERT INTO meu_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Taunabunai, hairaigu idoinai Aigupto ai, bona o ita ḡaudia iboudiai danu, tamagu ba hamaorolaia; bena tamagu ba hakaua mai haraḡa. ");
INSERT INTO meu_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Bena ia na tadina Beniamina aiona ai e hegagiu dae mai taina ida; Beniamina danu ia aiona ai e hegagiu dae, vada e hetai heheni. ");
INSERT INTO meu_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Bena Iosef ese kakana iboudiai e harahudia, bona e rosidia mai taina ida. Gabeamo tadikakana ia ida vada e hereva-hereva, asi edia gari. ");
INSERT INTO meu_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ini ḡau haridia na Farao ena ruma ai e piua, ena ruma taudia iboudiai na e kamonai Iosef tadikakana vada ema. Bena Farao mai ena hesiai taudia iboudiai vada e moale. ");
INSERT INTO meu_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Bena Farao ese Iosef e hamaoroa, eto, Tadikakamu ba hamaorodia, baoto “Emui kohu be emui doniki dorudia ai bavato kau, Kanaan tanona ba lou lao, ");
INSERT INTO meu_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","tamamui bona varavaramui bavabidia, ba hakaudia mai dekegu ai; lau ese Aigupto tanona ena ḡau namodia baina henimui, bona ina tano digarana do bavania”. ");
INSERT INTO meu_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ma ba hamaorodia, baoto “Ini ba kara toma: ina Aigupto tanona ai rerue bavabi, ba laohai, natumui bona adavamui ba udadia, ba mailaidia, bona tamamui danu. ");
INSERT INTO meu_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","A emui kohu basio laloa, badina be ina Aigupto tanona ena kohu namodia na bavabi emui”. ");
INSERT INTO meu_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Bena Israel natuna ese iena hereva e badina; bona Iosef ese rerue bona dala lakwana e henidia, Farao ena hahedua heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ta ta edia hahedoki toi toi danu e henidia, a Beniamina na silver monidia sinahu-toi e henia bona hahedoki ima. ");
INSERT INTO meu_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Herahia ḡaudia danu e siai, tamana ena: doniki gwauta Aigupto kohudia namodia e hua, bona doniki hahinedia gwauta uit bona flaoa bona aniani haida danu e hua, tamana ena dala lakwana. ");
INSERT INTO meu_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Bena ia ese tadikakana e siaidia lao, eto, Dala ai basio heiri-heiri. ");
INSERT INTO meu_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Taunabunai idia na Aigupto e toretania, Kanaan tanona ela, tamadia Iakob dekenai. ");
INSERT INTO meu_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","E hamaoroa, eto, Iosef e maurimu, Aigupto tanona idoinai e lohiaiamu. Bena Iakob laumana e daure, edia hereva se abia dae. ");
INSERT INTO meu_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","A idia ese Iosef ena hereva iboudiai e hamaorolaia; bena Iakob ese Iosef e siai reruedia e itadia ai, ia laumana ma e mauri lou. ");
INSERT INTO meu_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Bena Israel eto, Vadaeni, natugu Iosef dounu e maurimu; lau na do basina mase ai baina ha itaia. ");
INSERT INTO meu_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israel na eha laolao, ena kohu idoinai e abi kau, Bere-sieba ai e kau, unuseni ai tamana Isaak ena Dirava e boua. ");
INSERT INTO meu_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Bena hanuaboi ai Dirava ese nihi ai Israel e hereva henia, eto, Iakob e, Iakob e! Ia eto, Lau o ina. ");
INSERT INTO meu_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ma eto, Lau be Dirava, tamamu ena Dirava: Aigupto baola, basio gari, badina be unuseni ai bese badana ai baina halaomu. ");
INSERT INTO meu_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Lau ese baina bamomu ela bona Aigupto, ma baina hakaumu lou; bona ba mase negana ai Iosef ese matamu baine hakapua. ");
INSERT INTO meu_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Bena Iakob ese Bere-sieba e toretania. Israel natudia ese tamadia Iakob bona natudia maraḡidia bona adavadia e abidia, Farao ese e henidia reruedia ai e udadia, e laohaidia. ");
INSERT INTO meu_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Edia boromakau danu, bona edia kohu idoinai, Kanaan tanona ai e abi, vada e laohai, ela Aigupto ai e lasi. Iakob mai ena iduhu idoinai ela: ");
INSERT INTO meu_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","natuna mamaruanedia bona tubuna mamaruanedia, natuna hahinedia bona tubuna hahinedia, bona varavarana ibouboudiai. Iboudiai Aigupto e laohaidia. ");
INSERT INTO meu_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Israel garana, Aigupto ela taudia, ladadia bini, Iakob mai natuna iboudiai ida. ");
INSERT INTO meu_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben be Iakob natuna roboana. Ruben natuna be Hanok bona Palu bona Hesron bona Karami. ");
INSERT INTO meu_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon natuna be Iemuel bona Iamin bona Ohad bona Iakin bona Sohara bona Saul. Saul be hane Kanaan natuna. ");
INSERT INTO meu_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi natuna be Gereson bona Kohat bona Merari. ");
INSERT INTO meu_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Iuda natuna be Ere bona Onan bona Sela bona Perese bona Sera; a Ere bona Onan be Kanaan tanona ai e mase. Perese natuna be Hesron bona Hamulu. ");
INSERT INTO meu_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakara natuna be Tola bona Puva bona Iobo bona Simron. ");
INSERT INTO meu_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulun natuna be Sered bona Elon bona Ialeel. ");
INSERT INTO meu_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ini iboudiai bona natuna hahinena Daina be Lea natuna bona tubuna, Iakob ese iena amo e abidia Padan-aram ai. Iboudiai be toi-ahui toi. ");
INSERT INTO meu_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad natuna be Sifion bona Hagi bona Suni bona Esbon bona Eri bona Arodi bona Areli. ");
INSERT INTO meu_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asere natuna be Imna bona Isva bona Isvi bona Beria, taihudia Sera ida. Beria natuna be Hebere bona Malkiel. ");
INSERT INTO meu_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ini na hesiai hahinena Silpa natuna; Laban ese natuna Lea e henia hahinena bunai. Iakob ese natuna bona tubuna gwauta-tauratoi iena amo e abidia. ");
INSERT INTO meu_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Iakob adavana Rahela natuna bini: Iosef bona Beniamina. ");
INSERT INTO meu_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Iosef ese natuna rarua, Manase bona Efraim, na Aigupto tanona ai e abidia, Ono ena hahelaḡa tauna Potifera natuna Asenat bogana amo. ");
INSERT INTO meu_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Beniamina natuna bini: Bela bona Bekere bona Asbel bona Gera bona Naaman bona Ehi bona Ros bona Mupim bona Hupim bona Arad. ");
INSERT INTO meu_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ini iboudiai be Rahela natuna bona tubuna, Iakob ese iena amo e abidia. Iboudiai be gwauta-hani. ");
INSERT INTO meu_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan natuna be Husim. ");
INSERT INTO meu_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Napatali natuna be Iaseel bona Guni bona Iesere bona Silem. ");
INSERT INTO meu_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ini be hesiai hahinena Bilha natuna; Laban ese natuna Rahela e henia hahinena bunai. Iboudiai be hahitu. ");
INSERT INTO meu_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Iakob ida Aigupto ela taunimanimadia iboudiai, ia ese e havaradia taudia, be tauratoi-ahui tauratoi; a ravana be se duahidia. ");
INSERT INTO meu_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Bona Iosef ese Aigupto ai e abidia memerodia be rarua. Iakob ena iduhu taudia Aigupto ela iboudiai be hitu-ahui. ");
INSERT INTO meu_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Iakob ese Iuda e siaia guna, Gosen bainela, Iosef baine hadibaia. Bena Gosen ai e lasi. ");
INSERT INTO meu_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Bena Iosef ese ena kariota e heḡaeḡaelaia, Gosen ela, tamana ida bae hedavari; enai e kau, bena aiona ai e hegagiu dae, e tai. ");
INSERT INTO meu_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Bena Israel ese Iosef e hereva henia, eto, Harihari aina mase be namo, badina be mai maurimu ida vada na davarimu lou. ");
INSERT INTO meu_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Bena Iosef ese tadikakana bona tamana ena orea taudia e hamaorodia, eto, Lau bainala, Farao baina hamaorolaia, bainato “Tadikakagu bona tamagu ena orea taudia na Kanaan tanona amo vada ema, lau dekegu ai. ");
INSERT INTO meu_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Idia be mamoe bona boromakau ireḡudia taudia, edia mamoe seridia bona edia boromakau seridia bona edia kohu idoinai vada e mailai”. ");
INSERT INTO meu_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Bena Farao ese baine boirimui bona baine nanadaimui, baineto “Emui ḡaukara be dahaka?” ");
INSERT INTO meu_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Una negana ai umui ba haere, baoto “Ai oi isiaimu ilao-henina taumai na meromai negana amo boromakau vada e reḡudia, senemai bamodia”. Unu amo Gosen bavabia diba, emui tano ai ba halaoa; badina be Aigupto taudia ese seri ireḡudia taudia e dadaraidiamu. ");
INSERT INTO meu_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Bena Iosef na Farao dekena ela, eto, Tamagu bona tadikakagu na Kanaan tanona amo vada ema, mai edia mamoe seridia bona edia boromakau seridia bona edia kohu idoinai. Idia na harihari Gosen tanona ai. ");
INSERT INTO meu_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Bena kakana laima e hakaudia vareai, Farao vairanai. ");
INSERT INTO meu_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Bena Farao ese e nanadaidia, eto, Emui ḡaukara be dahaka? Idia eto, Ai oi isiaimu ilao-henina taumai be mamoe ireḡudia taumai, senemai bamodia. ");
INSERT INTO meu_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Bena idia ese Farao e noia, eto, Ai na vada ama, ina tano ai baia noho a tomamu, badina be Kanaan tanona na asi reina emai seri bae ania. Mani emu kara a hereva, emu hesiai taudia na Gosen tanona ai baia noho. ");
INSERT INTO meu_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Bena Farao ese Iosef e hamaoroa, eto, Tamamu bona tadikakamu na dekemu vada ema. ");
INSERT INTO meu_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Aigupto tanona idoinai be vairamu ai; gabu namo-hereana ta ba henidia, bae noholaia. Gosen tanona ai do bae noho, bona bema goada taudia haida idia bogaragidiai, egu boromakau ireḡudia taudia ai ba halaodia. ");
INSERT INTO meu_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Iosef ese tamana Iakob e hakaua vareai Farao vairanai; bena Iakob ese Farao e hanamoa. ");
INSERT INTO meu_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Farao ese e nanadaia, eto, Emu mauri laḡanidia be hida? ");
INSERT INTO meu_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Iakob e haere, eto, Egu laolao laḡanidia ina tanobada ai na sinahuta toi-ahui; egu mauri laḡanidia na dia hoho bona mai hisihisidia, dia tamagu bona tubugu heḡereḡeredia, idia edia laolao laḡanidia tanobada ai na hoho. ");
INSERT INTO meu_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Bena Iakob ese Farao e hanamoa, bena e rakatania. ");
INSERT INTO meu_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Bena Iosef ese tamana bona tadikakana edia gabu e lailaia bona edia tano e henidia, Aigupto tanona namo-hereana ta ai, ladana Ramese, Farao ena hahedua heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Bena Iosef ese tamana bona tadikakana bona tamana ena orea taudia iboudiai e ubudia, ruma ta ta taudia adia e henidia. ");
INSERT INTO meu_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Tano idoinai doe na bada herea; taunabunai Aigupto idoinai bona Kanaan idoinai aniani na lasi vaitani. ");
INSERT INTO meu_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Moni idoinai Aigupto ai bona Kanaan ai na uit ihoilaina ai e ore, idoinai Iosef mo imana ai. Bena ia ese Farao ena ruma ai e haboua. ");
INSERT INTO meu_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Bena Aigupto ai bona Kanaan ai moni e ore vaitani murinai Aigupto taudia na Iosef dekena ela, eto, Aniani a henimai; oi o uramu ai na oi vairamu ai baia mase a? Ai na asi emai moni. ");
INSERT INTO meu_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Iosef eto, Emui boromakau a henigu; lau na uit baina henimui, emui boromakau davadia, asi emui moni dainai. ");
INSERT INTO meu_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Taunabunai edia boromakau e laohai Iosef dekenai; bena ia ese aniani e henidia, edia hosi bona edia mamoe bona edia boromakau bona edia doniki davadia. ");
INSERT INTO meu_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Una l=agani e ore, bena laḡani iharuana ma e lou mai ia dekenai, eto, Lohia taumu e, ai na asia koimumu: emai moni vada e ore, emai boromakau iboudiai vada o abi; ḡau ta dia mia baia henimu, tau-animai bona emai tanomo vadaeni. ");
INSERT INTO meu_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ai na oi vairamu ai baia mase bona emai uma bae vahu a? Ai bavabimai, emai tano danu bavabi, aniani ba henimai. Bena ai bona emai tano ese Farao isiaina baia lao heni. Uhe danu ba henimai, bena emai tano na basine vahu. ");
INSERT INTO meu_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Taunabunai, Iosef ese Aigupto tanodia iboudiai e abi, Farao ena; badina be Aigupto taudia iboudiai ta ta ena tano ena tano e hoi, aniani davana, edia hitolo na bada dainai. Unuhetomana tano idoinai na Farao ena tano ai ela. ");
INSERT INTO meu_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Taunimanima danu e abidia, Aigupto hanuadia iboudiai, atai ela bona henu, hesiai taudia ai e halaodia. ");
INSERT INTO meu_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ḡau tamona hahelaḡa taudia edia tano ia ese se abi, badina be hahelaḡa taudia na Farao ese e ubudiava; taunabunai Farao ena heubu ḡaudia dekediai mimia dainai idia be edia tano bae hoi na asi badina. ");
INSERT INTO meu_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Bena Iosef ese taunimanima e hamaorodia, eto, Hari dina ai umui vada na hoimui bona emui tano vada na hoi. Uhe bini, vada ba hado. ");
INSERT INTO meu_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Bena uit ba utua negana ai, ba karoa, karoa ima; karoa ta Farao ba henia, a karoa hani be emui hadohado bona amui aniani ḡaudia, emui ruma taudia bona natumui maraḡidia iubulaidia. ");
INSERT INTO meu_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Bena idia ese e haere henia, eto, Momokani, oi ese vada o hamaurimai; oi baia imodaimu bona Farao isiaina baia lao heni. ");
INSERT INTO meu_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Unuhetomana Iosef ese taravadia e atua, hari taravatu na doini mia ema bona harihari: karoa ima lalodiai karoa ta be Farao ena. Ḡau tamona, hahelaḡa taudia edia tano ia ese se abi. ");
INSERT INTO meu_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel be Aigupto taudia bogaragidiai e nohova, Gosen ai. Unuseni ai idia na kohu momo e habouva; e hutuma e laova, bona edia taḡa e bada e laova. ");
INSERT INTO meu_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Iakob na laḡeni gwauta-hitu Aigupto ai e nohova: ena mauri laḡanidia na sinahu-ta hari-ahui hitu. ");
INSERT INTO meu_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ena mase vada e kahira-kahira ai, ia ese natuna Iosef e boiria, e hereva henia, eto, Boma lalokau henigu, imamu na mamugu ai boma atoa kau, boma gwau hamata, Aigupto ai basio gurigu, ");
INSERT INTO meu_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","a tubu tama dekedia bainala negana ai, Aigupto amo ba laohaigu, idia edia gara ai ba gurigu. Bena Iosef eto, Unu baina kara toma. ");
INSERT INTO meu_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Bena Iakob eto, A gwau hamata. Bena Iosef ese e gwau henia hamata. Bena Israel na ena mahuta patana duna badina ai e ḡuriḡuri. ");
INSERT INTO meu_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ini ḡau muridiai, Iosef na harina e kamonai tamana vada e gorere; bena ia ese natuna raruosi, Manase bona Efraim, e hakaudia lao. ");
INSERT INTO meu_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Bena haida ese Iakob e hamaoroa, eto, Natumu Iosef na oi i'itamu e maimu. Bena Israel na e haheauka, ena mahuta patana ai e helai tore. ");
INSERT INTO meu_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Bena Iakob ese Iosef e hereva henia, eto, Siahu-idoinai Diravana ese Lusu ai, Kanaan tanona ai, e hahedinarai henigu bona e hanamogu, ");
INSERT INTO meu_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","eto “Momokani lau ese besemu baina havaraia, baina hahohomu, bese bada-hereana ai bainahalaomu; ina tano danu oi garamu baina henidia, edia tano ai bainela, ela bona hanaihanai”. ");
INSERT INTO meu_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Harihari oi natumu raruosi, oi dekemu do asinama negana ai ina Aigupto ai e vara memerodia na lau natugu ai baela; Ruben bona Simeon na lau natugu heḡereḡerena, idia danu lau natugu ai baela. ");
INSERT INTO meu_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","A idia muridiai bae vara memerodia na oi natumu; kakadia bae nemaidia bona ahudia bae abi. ");
INSERT INTO meu_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","A lau be Padan amo nama negana ai Rahela na dala ai e mase, Kanaan tanona Efrata ai do asita kau ai. Bena Efrata dalana badinai na guria: una gabu ladana ta be Betelehem. ");
INSERT INTO meu_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Bena Israel ese Iosef natuna e haḡeredia, eto, Ini be daidia? ");
INSERT INTO meu_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Iosef ese tamana e haere henia, eto, Ini be lau natugu, Dirava ese vada e henigu ina tano ai. Tau buruka eto, Bae raka kahira, bena baina hanamodia. ");
INSERT INTO meu_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israel vada e buruka dainai ia matana vada e valahuvalahu, ḡau se ita ḡoeva. Taunabunai e boiridia, bae raka henia kahi; bena e harahudia bona e rosidia. ");
INSERT INTO meu_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Bena Israel ese Iosef e hamaoroa, eto, Lau banava nato oi vairamu basina itaia lou, to Dirava ese e bogagu hisi dainai oi bona natumu vada na itamui. ");
INSERT INTO meu_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Bena Iosef ese memero raruosi na tubudia tuina padadia amo e abidia, bena ia na tano ai e goru diho. ");
INSERT INTO meu_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Bena Iosef ese raruosi e abidia; imana idibana amo Efraim e abia, Israel laurina kahana ai e atoa, bona imana laurina amo Manase e abia, Israel idibana kahana ai e atoa. ");
INSERT INTO meu_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Bena Israel na imana idibana e haroroa, Efraim, tau-muritai, tubuana ai e atoa kau, bona imana laurina e haroroa, Manase, tau-guna tubuana ai e atoa kau. Mai ena laio-hadai dainai imana ruaosi unu e toiroro hanai toma. ");
INSERT INTO meu_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Bena ia ese Iosef e hanamoa, eto, Tubugu Abraham bona tamagu Isaak e toma henia dihova Diravana, Egu mauri dinadia iboudiai ema harihari vada e regugu Diravana, ");
INSERT INTO meu_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Dika iboudiai amo vada e hamaurigu aneruna, Ia ese ini memero baine hanamodia; Lau ladagu, bona tubugu Abraham ladana, bona tamagu Isaak ladana, bae nemaidia; Bese badana ai baela tanobada ai. ");
INSERT INTO meu_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","A Iosef na e itaia tamana ese imana idibana Efraim tubuana ai e atoa kau, bena lalona e hekwakwanai. Bena tamana imana e abia, Manase tubuana ai baine atoa kau eto. ");
INSERT INTO meu_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Iosef eto, Tamagu e, dia eneheto, badina be ina na tau-guna; imamu idibana be ia tubuana ai bavatoa kau. ");
INSERT INTO meu_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","A tamana na se ura, eto, Natugu e, mai dibagu na karaiamu: momokani, ia be bese badana ta baine havaraia, to tadina ese baine hereaia, bese bada-hereanabaine havaraia. ");
INSERT INTO meu_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Taunabunai ia ese e hanamodia una dina ai, eto, Umui be hahenamo toana ai bae halaomui Israel ai, baeto, Dirava ese baine hanamomui, Efraim bona Manase bamodia. Unu amo ia ese Efraim na tau-guna ai Manase tau-muritai ai e halaodia. ");
INSERT INTO meu_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Bena Israel ese Iosef e hamaoroa, eto, Egu mase vada eme kahikahi; a Dirava ese baine bamomui, bona baine hakaumui lou, tubu tama edia tano ba lou henia. ");
INSERT INTO meu_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Oi ahumu danu name henimu, tadikakamu iboudiai ahudia e hereadiamu: Sekem bunai, Amoro taudia edia amo na abia, egu dare bona egu peva goadadia ai. ");
INSERT INTO meu_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Bena Iakob ese natuna e boiridia, eto, Iboumui ai ba hebou, emui ai dahaka dahaka nega gabedia ai baine vara na baina hamaorolaimui. ");
INSERT INTO meu_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Iakob natuna e, a raka kahira, Tamamui Israel ena hereva ba hakala henia. ");
INSERT INTO meu_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, oi na natugu roboana, egu goada anina roboana, Heaḡi badina, siahu badina. ");
INSERT INTO meu_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","To oi na ranu na heto, taunabunai oi na basio herea, Badina be tamamu ena geda ai o hekure, o hamiroa. ");
INSERT INTO meu_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon bona Levi na boga tamona amo; Edia ura hehunidia be koikoi bona dadidadi. ");
INSERT INTO meu_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Laumagu e, edia kara hehunidia ai basio raka vareai, Lalogu e, edia hebou amo ba raka siri; Badina be edia badu ai taunimanima e aladia mase. Bona edia ura kava ai boromakau e haberodia. ");
INSERT INTO meu_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Edia daḡedaḡe na uduguiraiamu, badina be vada e idita; Edia badu na uduguiraiamu, badina be vada e auka. Ahudia Iakob ai baina ḡiḡi rohoroho, Israel ai baina hakarohodia, ");
INSERT INTO meu_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Iuda e, tadikakamu ese bae imodaimu, Oi imamu na inaimu aiodia ai bavatoa kau; Tamamu natuna ese bae toma henimu diho. ");
INSERT INTO meu_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Iuda na leona natuna; Natugu e, leona vamu momo e ania na heto vada o goadamu; Leona e hekuremu na heto laḡana e aniamu, Leona burukana na heto: daika ese baine haoa? ");
INSERT INTO meu_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Lohia auna na Iuda ena amo basie abia oho, Tarava iatuna tauna ai danu basie dabu, Ela bona bainema tauna na do bainema; Bena bese loḡora ese ia bae badinaia. ");
INSERT INTO meu_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ena doniki na vine auna ai baine mataia, Ena doniki natuna na vine auna namo-hereana ai baine mataia. Ena dabua na vine ranuna ai baine huria, Ena hahedoki na vine ranuna kakakana ai baine huria; ");
INSERT INTO meu_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Matana bae kakakaka, vine ranuna na heto, Isena bae kuroka-kuroka rata na heto. ");
INSERT INTO meu_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulun na kone ai baine noho, Lagatoi edia hetu gabuna ai bainela, Ena tano hetoana na Sidono badibadinai. ");
INSERT INTO meu_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakara na doniki mai goadana Seri bogaragidiai e hekuremu na heto; ");
INSERT INTO meu_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","E itaia ena laḡa-ani be namo, Ena tano be mai hairaina; Bena kohu ihuana tauna ai ela, Hesiai tauna ai ela. ");
INSERT INTO meu_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan be ena orea taudia baine hahemaoro henidia, Israel iduhuna ta baine hahemaoro henia. ");
INSERT INTO meu_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan na gaigai dala isena ai na heto, Hekori gaigaina dala isena ai, Hosi ae-geduna e koriamu, Bena hosi tauna e morumu. ");
INSERT INTO meu_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Iehova e, emu hahemauri vada na nariamu. ");
INSERT INTO meu_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad be tuari oreana ta ese baine tuari henia, To ia ese baine hadareredia. ");
INSERT INTO meu_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asere ena tano ai uit momo baine vara, Aniani namodia baine dabarai, hanua pavapavadia adia. ");
INSERT INTO meu_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Napatali na dia hahinena na heto, e kahua nege, Bena natuna namo-hereadia e havaradiamu. ");
INSERT INTO meu_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Iosef na au rigina mai huahuana na heto, Au rigina ranu gabuna ai e varamu na heto, Rigina na maḡu amo e daemu. ");
INSERT INTO meu_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Peva taudia ese vada e hahisia, E tarakia, e haberoa; ");
INSERT INTO meu_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","To iena peva na mia, Iakob Siahuna ese ia imana vada e ha-aukadia, Mamoe Ireḡuna, Israel Nadi-ginina, ladana ai. ");
INSERT INTO meu_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Tamamu ena Dirava bunai: ia ese baine durumu, Siahu-idoinai Diravana: ia ese baine hanamomu. Guba atai ai ena hahenamo, Dobu gabuna tanobada henunai ena hahenamo, Kemena ena hahenamo, bogana ena hahenamo. ");
INSERT INTO meu_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Tamamu ena hahenamo ese Ororo gunadia edia hahenamo e hereaiamu, Mia-hanaihanai ororodia edia hahenamo e hereadiamu. Hahenamo bini Iosef latanai bae diho, Tadikakana ida e haheparara tauna tubuana ai bae kau. ");
INSERT INTO meu_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Beniamina na uda sisiana vamu e tahuamu na heto, Daba ai ana vamu e aniamu, Adorahi ai e ala ḡaudia e harimu. ");
INSERT INTO meu_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Israel iduhudia gwauta-ruaosi bini; tamadia ena hahenamo herevadiabini. ta ta e hanamolaidia. ");
INSERT INTO meu_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Bena ia ese e haḡanidia, eto, Tubu tama dekedia ba laomu: tubugu bona tamagu badibadidiai ba gurigu, nadi kohuana ai, Efron tau Hiti ena tano ai. ");
INSERT INTO meu_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Kohuana bunai Makapela imeana ai, Mamare kahana ai, Kanaan tanona ai; Abraham ese Efron tau Hiti ena amo e hoia, ena gara gabuna ai bainela. ");
INSERT INTO meu_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Unuseni ai Abraham mai adavana Sara ida e guridia, unuseni ai Isaak mai adavana Rebeka ida e guridia; unuseni ai danu Lea na guria. ");
INSERT INTO meu_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Kohuana bunai, mai imeana, na Hiti taudia edia amo e hoia. ");
INSERT INTO meu_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Iakob ese natuna ihaḡanidia e hadokoa, bena ena mahuta patana ai e hekure diho, laumana e heni dae, tubu tama dekedia ela. ");
INSERT INTO meu_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Iosef na tamana vairanai e igo diho, e tai, bona e harahua. ");
INSERT INTO meu_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Bena Iosef ese ena hesiai taudia haida, muramura ḡaukaradia mai dibadia taudia, e haduadia, tamana tau-anina bae haḡoevaia, muramura mai bonadia amo bae dahua, bona dabua aukana bae kumilaia. Bena unu e kara toma. ");
INSERT INTO meu_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Dina hari-ahui vada ela, muramura taudia edia ḡaukara dinadia; bena dina hitu-ahui e tailaia, Aigupto taudia ese. ");
INSERT INTO meu_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Taitai dinadia vada e ore, bena Iosef ese Farao ena ruma taudia e noidia, eto, Boma ura henigu, Farao boma hereva henia, boma hamaoroa, ");
INSERT INTO meu_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","tamagu e haduagu dainai na gwau henia hamata. Ia eto “Baina mase negana ai, vada na heḡaeḡaelai garana ai ba gurigu, Kanaan tanona ai”. Taunabunai, ba kahugu nege, tamagu do baina guria, bena ma baina lou mai. ");
INSERT INTO meu_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Bena Farao eto, Vada aola, tamamu ba guria, emu gwau-hamata heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Bena Iosef e tore isi tamana igurina ela. Farao ena hesiai taudia bona ena ruma lohiadia iboudiai ese e bamoa, bona Aigupto lohiadia iboudiai, ");
INSERT INTO meu_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","bona Iosef varavarana iboudiai, bona ena ruma taudia, bona tamana ena ruma taudia. Natudia maraḡidia bona edia mamoe seridia bona edia horomakau seridia mo e rakatanidia Gosen tanona ai. ");
INSERT INTO meu_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Haida be kariota ai e gui, haida be hosi ai: hutuma bada ia ida ela. ");
INSERT INTO meu_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Atad ena uit ikwadina gabuna ai e kau, Ioridane unukahanai; unuseni ai Iakob igurina karadia e kara, mai lalo-hisihisidia bona mai taidia ida. Idia ese dina hitu tamadia e tailaia. ");
INSERT INTO meu_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Una tano taudia, Kanaan taudia, ese edia lalo-hisihisi e itaia, Atad ena uit ikwadina gabuna ai, bena idia eto, Aigupto taudia edia taitai na bada herea. Taunabunai, una gabu ladana e hatoa Abele-misraim: ia na Ioridane unukahanai. ");
INSERT INTO meu_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Bena natuna na iena hahedua heḡereḡerena e karaia: ");
INSERT INTO meu_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Kanaan tanona ai e huaia lao, nadi kohuana lalonai e guria, Makapela imeana ai. Una kohua bona imea na Abraham ese Efron tau Hiti ena amo e hoia, ena gara gabuna, Mamare ai. ");
INSERT INTO meu_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Bena tamana e guria murinai, Iosef, mai tadikakana bona mai bamona ida, e lou lao, Aigupto ela. ");
INSERT INTO meu_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Tamadia ena mase murinai, Iosef kakana na e hereva heheni, eto, Readia Iosef lalona ma baine dika ita edai, bena a kara dika henia karadia davadia do baine henida. ");
INSERT INTO meu_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Taunabunai, idia ese hereva ta e siaia Iosef dekenai, eto, Tamamu do se mase ai e haḡanimai, eto ");
INSERT INTO meu_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","“Iosef ba hamaoroa, baoto ‘Kakamu edia kerere bona edia kara dika oiemu ai ba lalo nege’; taunabunai ai a noimumu, tamamu ena Dirava isiaina ilao-henina taumai emai dika ba gwau tao”. Ina hereva e kamonai ai, Iosef na e tai. ");
INSERT INTO meu_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Bena kakana ela ia vairanai e goru diho, eto, Momokani, ai na oiemu hesiai taudia. ");
INSERT INTO meu_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","A Iosef eto, Basio gari; lau be Dirava ibolona a? ");
INSERT INTO meu_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Umui emui lalo-hadai be ba hadikagu o tomova, to Dirava ese anina namona e havaraia; anina na hari dina ai o itaiamu taunimanima hutuma vada na hamauridiamu. ");
INSERT INTO meu_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Tauna-bunai, basio gari; umui baina ubumui, bona natumui danu baina ubudia. Bena hereva namodia amo lalodia e hamarumarudia. ");
INSERT INTO meu_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Taunabunai, Iosef bona tamana ena iduhu taudia iboudiai na Aigupto ai ma e nohova. Iosef ena mauri laḡanidia na sinahu-ta dikoana gwauta. ");
INSERT INTO meu_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Iosef ese Efraim tubuna e itadia, bona Makiri Manase natuna danu ia tuina ai e helai. ");
INSERT INTO meu_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Bena Iosef ese tadikakana e hamaorodia, eto, Egu mase negana vada eme kau: a Dirava ese baine lalomui, bona ina tano amo baine hakaumui lasi, ela bona ena gwau-hamata ai Abraham bona Isaak bona Iakob e heni tanona. ");
INSERT INTO meu_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Bena Iosef ese Israel natudia e haḡanidia, bae gwau hamata. Ia eto, Dirava ese ena gwau-hamata baine hamomokania; una negana ai lau turiagu na ini amo ba laohaidia. ");
INSERT INTO meu_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Taunabunai Iosef na e mase: ena mauri laḡanidia na sinahu-ta dikoana gwauta. Bena idia ese ia tau-anina e haḡoevaia, muramura e karalaia, bena maua ai e udaia, Aigupto ai. ");
INSERT INTO meu_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Israel natuna Aigupto ela taudia bini, idia na ta ta edia ruma taudia ida Iakob e bamoa ela. ");
INSERT INTO meu_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ladadia bini: Ruben; Simeon; Levi; Iuda; ");
INSERT INTO meu_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakara; Sebulun; Beniamina; ");
INSERT INTO meu_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan; Napatali; Gad; Asere. ");
INSERT INTO meu_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Iakob garana iboudiai be taunimanima hitu-ahui, Iosef ese e gunalaidia Aigupto ai. ");
INSERT INTO meu_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Iosef e mase, tadikakana bona ena uru taudia iboudiai danu e mase. ");
INSERT INTO meu_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","A Israel garana ese natudia momo e havaradia, besedia eha hutuma, una tano e hahonua. ");
INSERT INTO meu_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Hanua pavapavana matamatana ta ese Aigupto e halohiaia; ia na asi dibana Iosef. ");
INSERT INTO meu_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ia ese ena orea taudia e hamaorodia, eto, A itaia, ita na gagadoi, Israel besena taudia na hutuma; ita na mamanoka, idia na gogoada; ");
INSERT INTO meu_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","aita laloa namonamo, bae hutuma herea bena tuari negana ai bae tore isi, inaida bae durudia, bae tuari henida, bona eda tano bae toretania na garina. ");
INSERT INTO meu_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Una dainai, ia ese heitatao taudia e haginidia, ḡaukara ai bae itadia tao, bena ḡaukara momo amo bae bahisidia. Bena idia ese hanua e hadai, Parao ena kohu ihaboudia, ladadia be Pitom bona Raamese. ");
INSERT INTO meu_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Edia hekwarahi e habadaia loulou, to besedia ma eha hutuma, ela bona tano idoinai e hahonua davana. Bena Aigupto taudia ese Israel taudia garidia e gariva. ");
INSERT INTO meu_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Taunabunai idia ese Israel taudia e inai henidiava, e hahekwarahidiava. ");
INSERT INTO meu_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Edia noho na dika, ḡaukara metaudia daidiai: raro amo e kara nadidia bona ihakamo-taodia ḡaudia e karava, uma ai danu ḡaukara idau-idau e karava mai hekwarahidia ida. Hesiai karadia idoidiai ikaradia ai e hahekwarahidiava. ");
INSERT INTO meu_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Bena Aigupto pavapavana ese Heberu edia hegwaroto hahinedia e hereva henidia: hahine ta ladana na Sifra, ma ta ladana na Pua. ");
INSERT INTO meu_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Ia eto, Umui raruosi ese Heberu hahinedia ba hamaradia negadia ai ba itadia, idia bae mara, bema mero, bavalaia, a bema kekeni be baine mauri. ");
INSERT INTO meu_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","To hari hegwaroto hahinedia ese Dirava garina e gariva dainai idia ese Aigupto pavapavana ena hahedua herevana asie badinaiava, natudia mamaruanedia idia ese e hamauridiava. ");
INSERT INTO meu_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Taunabunai, Aigupto pavapavana ese hagwaroto hahinedia e boiridia, e nanadaidia, Dahaka dainai ini vada o kara toma? Dahaka dainai natudia mamaruanedia vada o hamauridia? ");
INSERT INTO meu_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Hari hegwaroto hahinedia ese Farao e haere henia, eto, BAdina be Heberu hahinedia na dia Aigupto hahinedia bamodia; idia na mai goadadia, bena hegwaroto hahinena do se gini daemu negana ai idia ese e mara gunamu. ");
INSERT INTO meu_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Una dainai Dirava ese hari hegwaroto hahinedia e hanamodia, bona Heberu besena na eha hutumava bona e goada dikadikava. ");
INSERT INTO meu_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Hari hegwaroto hahinedia ese Dirava e matauria dainai, ia ese natudia e henidia. ");
INSERT INTO meu_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Bena Farao ese ena orea taudia iboudiai e haḡanidia, eto, Natudia mamaruanedia na sinavai ai ba negedia, a kekeni na bae mauri. ");
INSERT INTO meu_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Tau ta, Levi iduhuna tauna, ese Levi iduhuna kekenina ta e adavaia. ");
INSERT INTO meu_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Hahine na e rogogogo, e mara, mero ta e abia; e itaia, ia na mero raho-namona, bena e hunia hua toi. ");
INSERT INTO meu_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Bena ihunina asi dibana negana ai ia ese nini boseana ta e abia iena, raro-kaka mai kopukopu e tabaia ahu: bena ia ese mero e udaia, sinavai isena ai bautama lalodiai e atoa. ");
INSERT INTO meu_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Taihuna na dauhai e gini, ia ede baine heto baine itaia tao eto. ");
INSERT INTO meu_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Farao natuna hahinena na ela, sinavai ai baine digu eto; bena ena hesiai kekenidia na sinavai badibadinai e loava. Ia ese bosea bautama lalodiai e itaia, bena ena hesiai kekenina ta e siaia, baine mailaia. ");
INSERT INTO meu_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ia ese e kehoa, mero e itaia; ina! mero madi e taiva. Bena ia ese e bogaia hisi, eto, Ina na Heberu hahinena ta natuna. ");
INSERT INTO meu_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Bena hari taihuna ese Farao natuna hahinena e hereva henia, eto, Lau ainala, ani, Heberu mararoto hihinena ta baina boiria, ia ese mero baine ubua. ");
INSERT INTO meu_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Farao natuna hininena ese e haere henia, eto Aola. Bena kekeni na ela, mero sinana e boiria. ");
INSERT INTO meu_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Bena Farao natuna hahinena ese e haduaia, eto, Ina mero a laohaia, ba ubua lauegu; lau ese davana baina henimu. Bena hahine ese mero e abia, e laohaia, e ubua. ");
INSERT INTO meu_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mero na e bada oho bada oho, bena hari hahine ese e hakaua lao Farao natuna hahinena dekenai. Bena ia ese natuna ai e halaoa. Ia ese ladana e hatoa Mose; eto, Badina be ranu amo na veria lasi. ");
INSERT INTO meu_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Dina ta, Mose tauhauna ai, ia ne e raka lasi varavarana dekediai, edia hekwarahi e itaia. Bena ia ese Aigupto tauna ta e itaia, Heberu tauna ta, ia varavarana ta, e dadabaia. ");
INSERT INTO meu_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ia na e roha roha, tau ta se itaia; bena ia ese Aigupto tauna e alaia mase, tauna na raria ai e hunia. ");
INSERT INTO meu_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kerukeru ma e raka lasi, Heberu taudia rarua e itadia, e heatu. Bena ia ese heatu e matamaia tauna e gwau henia, eto, Badina be dahaka oi ese bamomu o dadabaiamu? ");
INSERT INTO meu_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ia na e haere, eto, Daika ese emai lohia ai bona emai hahemaoro tauna ai e halaomu? Emu ura be bavalagu mase, tau Aigupto o alaia mase na heto a? Bena Mose e gari, eto Ḡauna vada eme hedinarai. ");
INSERT INTO meu_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Farao na una kara herevana e kamonai negana ai ia ese Mose baine alaia mase eto. A Mose ese Farao e heautania, ela, Midian tanona ai eha noho. Ia na ranu gurina ta badinai e halaiva. ");
INSERT INTO meu_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Midian hahelaḡa tauna na mai natuna hahinedia hahitu; bena idia na ema, ranu e utua, tamadia ena mamoe seridia e ha-inulaidia. ");
INSERT INTO meu_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Bena mamoe ireḡudia taudia ema, e luludia oho; a Mose na e tore isi, e durudia, edia seri e ha-inulaidia. ");
INSERT INTO meu_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Bena tamadia Reuele dekena e lou lao negana ai ia ese e nanadaidia, eto Edeheto hari dina ai vada o lou mai haraḡa? ");
INSERT INTO meu_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Idia na e haere, eto, Aigupto tauna ta ese e durumai, mamoe ireḡudia taudia e gwaudia tao, ranu e utu henimai, bona emai seri e ha-inulaidia. ");
INSERT INTO meu_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ia ese natuna hahinedia e gwau henidia, eto, Tauna be edeseni ai? Dahaka dainai o rakatania? A boiria, ana ba dabaraia. ");
INSERT INTO meu_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Bena Mose na una tau dekenai e nohova mai moalena ida. Bena una tau ese natuna kekenina ta, ladana Sipora, na Mose e henia, baine adavaia. ?");
INSERT INTO meu_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Hahine na e mara, mero ta e abia; bena Mose ese mero ladana e hatoa Geresom; badina be ia eto, Lau na idau tano ai vada name noho hedoa. ");
INSERT INTO meu_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Nega taina vada e daudau, Aigupto pavapavana e mase. Una negana ai Israel taudia e taitaiva mai lalo-hisihisidia ida, edia maduna metaudia daidai Dirava e tai henia. ");
INSERT INTO meu_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Dirava ese edia taitai e kamonai, bona ena gwau-hamata, Abraham bona Isaak bona Iakob e gwau henidia hamata ḡauna, e helalolaia une. ");
INSERT INTO meu_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Bena Dirava ese Israel taudia e haḡeredia bona e lalodia. ");
INSERT INTO meu_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mose ese ravana Ietero, Midian hahelaḡa tauna, ena seri e reḡuava. Ia ese seri e hakaua lao tano ḡaḡaena unukahana ai, Dirava ena ororo, ladana Horeb, ela. ");
INSERT INTO meu_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Bena Iehova ena aneru ese e hahedinarai henia, lahi hururu-hururuna ai, lahi na au ginigini ai. Mose ese e itaia, lahi na au amo e hururu lasiva, to au na lahi ese se araiava. ");
INSERT INTO meu_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Bena Mose eto, Aina raka siri, ina kara idauna baina itaia, au ginigini na edeheto se ara ore. ");
INSERT INTO meu_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Iehova ese e itaia, ia na vada e raka siri. Bena Dirava ese au ginigini amo e boi henia, eto Mose e! Ia na e haere, eto, Lau o ina. ");
INSERT INTO meu_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Dirava eto, Basio raka kahi mai, emu tamaka danu aemu amo ba koko oho, badina be o ginimu gabuna na tano helaḡana. ");
INSERT INTO meu_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ma eto, Lau na tamamu ena Dirava, Abraham ena Dirava, Isaak ena Dirava, Iakob ena Dirava. Bena Mose na vairana e koua, Dirava baine itaia na garina. ");
INSERT INTO meu_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Iehova ma eto, Momokani, egu bese edia hisihisi Aigupto ai vada na itaia, bona edia taitai, biagudia ese e hahekwarahidiamu dainai e taimu, vada na kamonai; badina be edia hisihisi vada name diba. ");
INSERT INTO meu_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Lau vada name diho, Aigupto taudia imadia amo baina hamauridia, una tano amo baina hakaudia lasi ela bona tano namo-hereana ai, taora badana ai, bae kau; una tano ai rata bona bada-ranuna e arumu, Kanaan taudia edia tano bunai, Hiti taudia edia, bona Amoro taudia edia, bona Perisi taudia edia, bona Hivi taudia edia, bona Iebusu taudia edia. ");
INSERT INTO meu_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Momokani, Israel taudia edia taitai egu ai vada e kau, bona Aigupto taudia ese e hahisidia karadia vada na ita. ");
INSERT INTO meu_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Aoma, lau ese oi baina siaimu Farao dekenai, egu bese taudia Israel na Aigupto amo ba hakaudia lasi helaoreana. ");
INSERT INTO meu_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Bena Mose ese Dirava e haere henia, eto, Lau be daika Farao dekena bainala bona Israel taudia Aigupto amo baina hakaudia lasi? ");
INSERT INTO meu_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Dirava ma eto, Momokani, lau ese baina bamomu, bona na siaimumu toana binai: oi ese Istarel taudia Aigupto tanona amo ba hakaudia lasi murinai, ina ororo ai umui ese Dirava ba toma henia diho. ");
INSERT INTO meu_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Bena Mose ese Dirava ma e hereva henia, eto Lau na Israel taudia dekedia bainala, baina hamaorodia, bainato “Tamamui edia Dirava ese vada e siaigu dekemui ai”, bena idia ese bae nanadaigu, baeto “Ia ladana be daika?”, lau be ede baina haere henidia toma? ");
INSERT INTO meu_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Bena Dirava ese Mose e hamaoroa, eto, LAU BINAI NA NOHOMU. Ma eto, Israel taudia ba haere henidia, baoto “LAU NA NOHOMU ese e siaigu dekemui ai.” ");
INSERT INTO meu_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Dirava ese Mose ma e hamaoroa lou, eto, Israel taudia ba hamaorodia, baoto “Iehova, senemui edia Dirava, Abraham ena Dirava, Isaak ena Dirava, Iakob ena Dirava, vada e siaigu dekemui ai”. Lau ladagu binai ela hanaihanai; uru iboudiai lalodiai ini ba lalogu toma. ");
INSERT INTO meu_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Aola, Israel tau-badadia ba haboudia, ba hereva henidia, baoto “Iehova, senemui edia Dirava, Abraham ena Dirava, Isaak ena Dirava, Iakob ena Dirava, ese vada e hahedinarai henigu, eto: Momokani, lau ese vada na haḡeremui, Aigupto ai e kara henimui karadia vada na ita; ");
INSERT INTO meu_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","vada na gwau hamata danu, Aigupto hisihisidia amo baina hakaumui lasi, Kanaan taudia bona Hiti taudia bona Amoro taudia bona Perisi taudia bona Hivi taudia bona Iebusu taudia edia tano ai baina hakaumui vareai, rata bona bada-ranuna e arumu tanona bunai”. ");
INSERT INTO meu_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Bena Israel tau-badadia ese bae hakala henimu, bae bamomu, Aigupto pavapavana dekena baola, baoto “Iehova, Heberu taumai emai Dirava, na vada e hahedinarai; taunabunai, mani ba kahumai nege, dina toi baia laolao tano ḡaḡaena ai, unuseni ai Iehova, emai Dirava, baia boua”. ");
INSERT INTO meu_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","A lau dibagu Aigupto pavapavana na basine kahumui nege ela bona lau imagu metauna bae mamia toho. ");
INSERT INTO meu_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Taunabunai lau na imagu do baina toia roro, egu hoa karadia amo Aigupto taudia baina hadareredia; una murinai ia ese baine kahumui nege. ");
INSERT INTO meu_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","A ina bese taudia baina hanamodia Aigupto taudia vairadiai, bena ba raka lasi negana ai umui na imamui asi anidia ai basiola. ");
INSERT INTO meu_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Badina be hahine ta ta na dekedia hahinedia bona edia ruma ai e nohomu hahinedia ediai bae noinoi, silver heraheradia bona gold heraheradia bona dabua bae gwaurai; bena natumui mamaruanedia bona natumui hahinedia ba haheralaidia bona ba hahedokilaidia, Aigupto taudia edia kohu namodia vada ba dadihaidia. ");
INSERT INTO meu_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Bena Mose e haere, eto, Mani a laloa, idia na basie kamonai henigu, egu hereva basie abia dae, baeto “Iehova ese se hahedinarai henimu”, ");
INSERT INTO meu_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Bena Iehova eto, Ena na dahaka imamu ai? Ia e haere, eto, Itotohi. ");
INSERT INTO meu_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Iehova eto, Tano ai avatoa diho. Tano ai e atoa diho, bena itotohi na gaigai ai ela; bena Mose ese e heautania. ");
INSERT INTO meu_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","A Iehova ese Mose e haduaia, eto, Imamu a toia roro, iuna ai avabi. (Taunabunai, ia ese imana e toia roro, e abia, bena itotohi ai ma ela ia imana ai.) ");
INSERT INTO meu_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Bena bae diba Iehova, senedia edia Dirava, Abraham ena Dirava, Isaak ena Dirava, Iakob ena Dirava, ese vada e hahedinarai henimu. ");
INSERT INTO meu_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Iehova ese ma e haduaia, eto, Imamu na emu hahedoki lalonai a toia vareai. Ia ese imana ena hahedoki ai e toia vareai; bena e veria lasi negana ai imana na kuroka-kuroka, lepra tauna imana na heto. ");
INSERT INTO meu_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Dirava ma eto, Imamu na emu hahedoki lalonai ma a toia vareai lou. (Taunabunai, ia ese imana ma e toia vareai lou ena hahedoki ai, bena e veria lasi negana ai e itaia, vada e namo, kopina gunana heḡereḡerena.) ");
INSERT INTO meu_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Bena basie kamonai henimu, toa gini-gunana basie abia dae, readia iharuana bae abia dae. ");
INSERT INTO meu_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","A toa ruaosi basiema abi dae bona eremu basiema kamonai, sinavai ranuna do bavabia, tano ai ba seia, bena sinavai amo bavabia ranuna na rara ai bainela tano ai. ");
INSERT INTO meu_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mose ese Iehova ma e hereva henia, eto, Egu Ḡaubada e, lau na hereva ai malagu seme haraḡa, gunaguna, bona harihari oi ome hereva henigu negana ai danu; badina be lau na hereva manau taugu, malagu danu se haraḡamu. ");
INSERT INTO meu_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Bena Iehova ese e haere henia, eto; Taunimanima ududia daika ese e kara? Daika ese tau ta uduna e hakapuamu, eiava taiana e hakudimaiamu? Daika ese matana e hapapaiamu eiava e hakepuluamu? Lau binai Iehova, ani? ");
INSERT INTO meu_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Taunibunai, oi baola, lau be udumu ai baina noho, ba gwaurai herevadia baina henimu. ");
INSERT INTO meu_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","A Mose eto, Egu Ḡaubada e, mani emu kara idauna ta ba siaia. ");
INSERT INTO meu_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Bena Iehova ese Mose e badu henia, eto, Kakamu Aaron, Levi iduhuna tauna, se nohomu a? Lau dibagu ia na mai haroro dibana. Ina harihari ia na vada e raka lasi, e maimu dekemu ai; baine itamu negana ai ia baine moale. ");
INSERT INTO meu_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Oi ese ba hereva henia, ia uduna herevadia ba henia; a lau be oi udumu ai bona ia uduna ai baina noho, raruosi baina hadibamui ede ba kara toma. ");
INSERT INTO meu_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ia ese oiemu hereva taunimanima baine hamaorolaidia; ia na oi udumu ai bainela, oi be Dirava heḡereḡerena ai baola ienai. ");
INSERT INTO meu_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Hari itotohi danu imamu ai bavabia, toa ba karalaia. ");
INSERT INTO meu_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Bena Mose ela, ia ravana Ietero dekena e lou lao, e hamaoroa, eto, Mani a kahugu nege, lau varavaragu Aigupto ai dekedia baina lou lao, baina diba idia dounu mamauri eiava lasi. Ietero ese Mose e haere henia, eto, Mai mainomu ida aola. ");
INSERT INTO meu_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Bena Iehova ese Midian tanona ai Mose e hereva henia, eto, Aigupto ba lou henia, badina be emu mauri bae abia oho e tomava taudia na iboudiai vada e mase. ");
INSERT INTO meu_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Bena Mose ese adavana bona natuna e abidia, doniki ai e hahelaidia kau, Aigupto tanona e lou henia. Dirava ena itotohi danu imana ai e abia kau. ");
INSERT INTO meu_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Bena Iehova ese Mose e haduaia, eto, Aigupto ba lou henia negana ai, hoa karadia iboudiai Farao vairanai ba kara, lau ese siahu vada na henimu heḡereḡerena. To lau ese ia lalona baina ha-aukaia, taunabunai ia ese Heberu taudia basine kahudia nege. ");
INSERT INTO meu_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Bena Farao ba hamaoroa, baoto “Iehova na ini e gwau tomamu: Israel be natugu roboana, ");
INSERT INTO meu_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","taunabunai na haḡanimumu, natugu a kahua nege, lau isiaigu baine lao heni helaoreana; a boma dogoa tao, oi natumu roboana bama alaia mase.” ");
INSERT INTO meu_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Dala ai, adorahi ta ai e taruhava gabuna ai, Iehova ese e ginia ahu, baine alaia eto. ");
INSERT INTO meu_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Bena Sipora na vasiga e abia, natuna e peritomea, kopina e ivaia ḡauna amo Mose aena palapalana e dahua, eto, Momokani, rara ai vada ta headava. ");
INSERT INTO meu_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Taunabunai, Iehova ese e kahua nege. Una negana ai hahine na eto, Rara ai vada ta headava, peritome dainai. ");
INSERT INTO meu_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Una negana ai Iehova ese Aaron e hereva henia, eto, Tano ḡaḡaena aola, Mose ida ba hedavari. Bena ia na ela, Dirava ena ororo ai Mose e davaria, bena e harahua. ");
INSERT INTO meu_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Bena Iehova ese Mose e siailai herevadia bona e hahedualai toadia na Mose ese Aaron e hamaorolaia. ");
INSERT INTO meu_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Bena Mose bona Aaron ela, Israel tau-badadia iboudiai e haboudia. ");
INSERT INTO meu_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Iehova ese Mose e hamaoro-laia herevadia iboudiai Aaron ese e gwaurai hedinarai, bona hari hari toa danu Israel taudia iboudiai vairadiai e kara. ");
INSERT INTO meu_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Idia na e kamonai; bena vada e diba Iehova ese Israel besena taudia vada e vadivadi henidia bona edia hisihisi vada e itaia dainai idia na e igo diho, e toma henia diho. ");
INSERT INTO meu_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Una murinai Mose bona Aaron ela Farao dekenai, e hereva henia, eto, Iehova, Israel emai Dirava, ini e gwau tomamu: Egu bese taudia ba kahudia nege, idia ese agu aria bae karaia, tano ḡaḡaena ai. ");
INSERT INTO meu_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","A Farao eto, Iehova be daika? Ia erena baina kamonai, Israel taudia baina kahudia nege, badina be dehaka? Iehova na asi dibagu; Israel taudia danu basina kahudia nege. ");
INSERT INTO meu_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Raruosi eto, Heberu taumai emai Dirava na dekemai ai vada ema; mani emu kara dina toi tano ḡaḡaena ai baia raka lao, emai Dirava, Iehova, baia boua, dai-hanai gorerena amo eiava dare amo baine alamai mase na garina. ");
INSERT INTO meu_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Bena Aigupto pavapavana ese e haere henidia, eto, Mose bona Aaron, dahaka dainai emui orea taudia na edia ḡaukara amo ba hakaudia siri? Aola, emui ḡaukara ba lou henia. ");
INSERT INTO meu_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Farao ma eto, Momokani, ina tano taudia vada e hutuma e laomu, a umui na ḡaukara ai o rudiamu. ");
INSERT INTO meu_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Una dina ai Farao ese ḡaukara biagudia bona heitatao taudia e haḡanidia, eto, ");
INSERT INTO meu_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Ḡaukara taudia na uit momona, raro ida e buloamu ḡauna, na basio henidia lou, dina iboudiai vada o henidiamu heḡereḡerena; ina murinai idia na sibodia bae ha gogoa. ");
INSERT INTO meu_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ḡau tamona, raro amo e kara nadidia e karamu na basie gadoi, ahudia korikoridia do bae kara; badina be idia na lalahedo, una dainai idia na e tai henigumu, e tomu “Mani ba kahumai nege, emai Dirava baia boua”. ");
INSERT INTO meu_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Edia ḡaukara ba hametaua: bae ḡaukara goada, koikoi herevadia basie hakala heni. ");
INSERT INTO meu_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Taunabunai ḡaukara biagudia bona heitatao taudia e raka lasi, Heberu taudia e hamaorodia, eto, Farao na e tomu “Uit momona basina hunimui lou; ");
INSERT INTO meu_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","vada baola, sibomui uit momona ba ha tahua; ḡau tamona, emui ḡaukara ahuna basine maraḡi”. ");
INSERT INTO meu_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Taunabunai, iboudiai e karoho rohoroho, Aigupto tanona idoinai uit momodia eha gogo. ");
INSERT INTO meu_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","A ḡaukara biagudia e gwaugwau, eto, Dina ta ta ahudia ba haḡuḡuru, gunaguna uit momona a henimui negadia ai heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Bena idia ese Israel edia heitatao taudia, hari Farao ena ḡaukara biagudia ese e badinadia taudia, na e dadabadia, a gwau henidia, eto, Dahuka dainai hari dina ai emui ḡaukara ahuna korikorina asio haḡuḡurua? ");
INSERT INTO meu_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Bena Israel edia heitatao taudia na Farao dekena ela, e tai henia, eto, Dahaka dainai emu hesiai taudia ini o karamai tomamu? ");
INSERT INTO meu_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Uit momona asie henimai, to e hamaoromaimu, e tomu “Raro amo e kara nadidia a kara”. E dadabamai danu. A kerere be oiemu orea taudia edia kerere. ");
INSERT INTO meu_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","A ia na e haere, eto, Umui na lahedo taumui, lahedo dikadika taumui; una dainai umui na o tomu “A kahumai nege, Iehova baia boua”. ");
INSERT INTO meu_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Vada aola, emui ḡaukara a lou henia: uit momona na basie henimui, to emui ḡaukara ahuna korikorina do ba haḡuḡurua. ");
INSERT INTO meu_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Israel taudia edia heitatao taudia vada e diba idia na ihadikadia totona e haduadia, eto “Dina ta ta ai emui ḡaukara ahuna na basine maraḡi”. ");
INSERT INTO meu_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Bena Farao ena amo e raka lasi ai idia na Mose bona Aaron ida e hedavari, raruosi ese e naridiava. ");
INSERT INTO meu_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Bena idia ese raruosi e gwau henidia, eto, Iehova ese baine he-geremui bona baine hahemaoro henimui; badina be Farao bona ena hesiai taudia vairadiai ladamai vada o hadika, e kara ialalaimai darena imadia ai vada o atoa na heto. ");
INSERT INTO meu_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Bena Mose ese Iehova e lou henia, eto, Ḡaubada e, dahaka dainai ina bese taudia vada o hadikadia? Dahaka dainai o siaigu? ");
INSERT INTO meu_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Badina be Farao dekena nama, emu hereva na hamaorolaia; una negana ema bona hari ia ese ina bese taudia vada e hadikadia, bona oi ese so hamauridiamu. ");
INSERT INTO meu_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Iehova ese MOse e hereva henia, eto, Harihari Farao ede baina kara henia toma do ba itaia: mai imana goadana ida ia ese baine siaidia lao; moibe, mai imana goadana ida ia ese ena tano amo baine luludia lasi. ");
INSERT INTO meu_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Dirava ese Mose ma e hamaoroa, eto, Lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Abraham bona Isaak bona Iakob vairadiai na hedinarai, Siahu-idoinai Diravana; a ladagu korikori IEHOVA asina hadibadia. ?");
INSERT INTO meu_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Na gwau henidia hamata danu, Kanaan tanona, edia noho-hedoa gabuna, vada baina henidia nato. ");
INSERT INTO meu_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Israel taudia, Aigupto taudia ese e hahisidiamu, edia taitai vada na kamonai; bona egu gwauhamata vada na laloamu. ");
INSERT INTO meu_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Taunabunai, Israel taudia ba hamaorodia: Lau binai Iehova; Aigupto taudia pa-gamui ai e ato madunadia na emui amo baina abi oho; vada e ḡuimui, a lau ese baina ruhamui nege; imagu goadana amo bona hahemaoro karadia metaudia amo do baina hamaurimui. ");
INSERT INTO meu_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Egu bese ai baina halaomui, bona emui Dirava ai bainala; vada ba diba, lau na Iehova, emui Dirava, Aigupto taudia edia maduna amo name hamaurimui Diravana ");
INSERT INTO meu_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Abraham bona Isaak bona Iakob na gwaurai henidia hamata tanona lalonai baina hakaumui vareai; vada baina henimui, emui tano korikori. Lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mose ese ina hereva Israel taudia e hamaorolaidia, to asie kamonai henia, daradia e doko bona edia maduna na metau dainai. ");
INSERT INTO meu_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Bena Iehova ese Mose e haduaia, eto, ");
INSERT INTO meu_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","A raka vareai, Farao, Aigupto pavapavana, ba hamaoroa, Israel taudia na baine kahudia nege, ena tano bae rakatania. ");
INSERT INTO meu_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","A Mose ese Iehova e haere henia, eto, Mani a laloa, Israel taudia asie kamonai henigumu; hari Farao ese bibinagu na e metaumu taugu ede baine kamonai henigu toma? ");
INSERT INTO meu_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","A Iehova ese Mose bona Aaron na haheḡani e henidia, Tsrael taudia bae haḡanilaidia bona Farao, Aigupto pavapavana, bvae haḡanilaia, Israel taudia na Aigupto tanona amo bae raka lasi. ");
INSERT INTO meu_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Tamadia edia iduhu ikwaradia taudia ladadia bini. Ruben, Israel natuna roboana, natudia bini: Hanok bona Palu bona Hesron bona Karami. Ruben ena iduhu bunai. ");
INSERT INTO meu_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeon natuna bini: Iemuel bona Iamin bona Ohad bona Iakin bona Sohara bona Kanaan hahinena natuna Saul. Simeon ena iduhu bunai. ");
INSERT INTO meu_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Levi natuna ladadia bini, edia uru ta ta ai: Gereson bona Kohat bona Merari. Levi ena mauri laḡanidia na sinahu-ta toi-ahui hitu. ");
INSERT INTO meu_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gereson natuna bini: Libni bona Simei, edia iduhu taudia ida. ");
INSERT INTO meu_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohat natuna bini: Amram bona Isahara bona Heberon bona Usiele. Kohat ena mauri laḡanidia na sinahu-ta toi-ahui toi. ");
INSERT INTO meu_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari natuna bini: Mali bona Musi. Levi ena iduhu bunai, uru ta ta ai. ");
INSERT INTO meu_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram ese lalana Iokedbed e adavaia. Natudia be Aaron bona Mose. Amram ena mauri laḡanidia na sinahu-ta toi-ahui hitu. ");
INSERT INTO meu_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Isahara natuna bini: Kora bona Nefeg bona Sikri. ");
INSERT INTO meu_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Usiele natuna bini: Misael bona Elsafan bona Sitiri. ");
INSERT INTO meu_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron ese Elisebae adavaia: ia na Aminadab natuna, Nason taihuna. Ia ese e havaradia memerodia be Nadab bona Abihu bona Eleasara bona Itamara. ");
INSERT INTO meu_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora natuna bini: Asiri bona Elkana bona Abiasafa. Kora ena iduhu bunai. ");
INSERT INTO meu_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleasara, Aaron natuna, ese Putiele natuna kekenina ta e adavaia; ia ese Fineha e havaraia. Levi ena iduhu ai ruma ikwaradia taudia bunu. ");
INSERT INTO meu_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Hari Aaron bona Mose be Iehova ese e haḡanidia, eto, Israel taudia na iduhu ta ta amo ba hakaudia lasi, Aigupto tanona bae rakatania. ");
INSERT INTO meu_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Idia raruosi ese Farao, Aigupto pavapavana, e hereva henia, Israel taudia ihakaudia herevana e hamaorolaia, hari Aaron bona hari Mose ese. ");
INSERT INTO meu_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Iehova ese Mose Aigupto tanona ai e hereva henia dinana ai, ");
INSERT INTO meu_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ia ese Mose e hamaoroa, eto, Lau binai Iehova: vada na hamaorolaimu herevadia iboudiai na Farao, Aigupto pavapavana, ba hamaorolaia. ");
INSERT INTO meu_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","A Mose ese Iehova e haere henia, eto, Bibinagu na eme metau; Farao na ede baine kamonai henigu toma? ");
INSERT INTO meu_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Iehova ese Mose e haere henia, eto, A kamonai: lau ese Dirava heḡereḡerena ai baina halaomu Farao enai, bona kakamu Aaron ese emu peroveta tanua ai bainela. ");
INSERT INTO meu_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Baina haḡanilaimu herevadia iboudiai na ba gwaurai; kakamu Aaron ese Farao baine hamaoroa, ia ese Israel taudia do baine kahudia nege, ena tano amo bae raka lasi. ");
INSERT INTO meu_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","A Farao lalona baina ha-aukaia; ena be toa bona hoa karadia baina hahohodia Aigupto tanona ai, ");
INSERT INTO meu_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","to Farao basine kamonai henimui. Taunabunai lau ese imagu Aigupto latanai baina atoa kau, bena egu orea, egu bese, Israel taudia, Aigupto tanona amo baina hakaudia lasi, mai hahemaoro karadia badadia ida. ");
INSERT INTO meu_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Bena imagu Aigupto latanai baina atoa kau bona taudia na bogaragidia amo baina hakaudia lasi negana ai, Aigupto taudia vada bae diba lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Bena Mose bona Aaron unu e kara toma; Iehova ese e haḡanidia heḡereḡerena, unu mo e kara tona. ");
INSERT INTO meu_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Iehova ena hereva Farao e hamaorolaia negana ai Mose ena mauri laḡanidia be taurahani-ahui, a Aaron ena be taurahani-ahui toi. ");
INSERT INTO meu_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Bena Iehova ese Mose bona Aaron ma e hereva henidia, ");
INSERT INTO meu_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","eto, Farao ese baine hamaoromui, baineto “Hoa karana ta a karaia, baina dibamui”, una negana ai oi ese Aaron ba haduaia, baoto, “Emu itotohi avabia, Farao vairanai ba negea dobi tano ai, gaigai ai bainela”. ");
INSERT INTO meu_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Taunabunai, Mose bona Aaron na Farao dekena ela, Iehova ena hahedua heḡereḡerena e karaia. Aaron ese ena itotohi e negea dobi, Farao bona ena hesiai taudia vairadiai, bena gaigai ai ela. ");
INSERT INTO meu_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Bena Farao ese aonega taudia bona mea taudia e boiridia; bena idia danu, hari Aigupto mea taudia, ese una kara heḡereḡerena ma e kara, edia mea diadiai. ");
INSERT INTO meu_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Badina be ta ta ese edia itotohi e nege dobi, bena gaigai ai ela. A Aaron ena itotohi ese idia edia itotohi e hadonodia. ");
INSERT INTO meu_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","A Farao lalona na dounu auka, ia ese se kamonai henidia, Iehova ena hereva heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Bena Iehova ese Aaron bona Mose e hamaorodia, eto, Farao lalona vada e aukamu, taunimanima na basine kahudia nege. ");
INSERT INTO meu_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Daba ai, Farao dekena baola, ranu baine lao henia negana ai. Sinavai isena ai ba naria, itotohi danu, gaigai ai ela ḡauna, bavabia kau. ");
INSERT INTO meu_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Bena ba hamaoroa, baoto “Iehova, Heberu taumai emai Dirava, vada eme siaigu dekemu ai, e tomu: Egu orea taudia a kahudia nege, tano ḡaḡaena ai bae toma henigu diho. A oi ese do so kamonai henia. ");
INSERT INTO meu_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Taunabunai, Iehova ma e tomu: Ini amo ba diba lau be Iehova; a itaia, Nilo sinavaina na ina imagu ai e miamu itotohina amo baina botaia, bena rara ai bainela; ");
INSERT INTO meu_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","bena Nilo sinavaina gwarumedia bae mase ore bona ranuna baine bodaga; bena Aigupto taudia na Nilo sinavaina ranuna bae dadaraia, basie inua”. ");
INSERT INTO meu_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Iehova ese Mose ma e hamaoroa, eto, Aaron ba haduaia, baoto “Emu itotohi imamu ai bavabia, ba toia roro Aigupto ranudia daediai, bona edia sinavai badadia bona edia sinavai maraḡidia daediai, bona edia gohu daediai bona edia koupa iboudiai daediai, bena rara ai baela; Aigupto tanona idoinai rara mo baine mia, popou ai bona hodu ai”. ");
INSERT INTO meu_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Bena Mose bona Aaron ese Iehova ena hahedua heḡereḡerena e karaia. Farao vairanai bona ena hesiai taudia vairadiai ia ese ena itotohi e abia, Nilo sinavaina ranuna e botaia; bena Nilo sinavaina ranuna idoinai rara ai ela. ");
INSERT INTO meu_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Bena Nilo sinavaina gwarumedia iboudiai e mase ore, ranuna danu e bodaga; Aigupto taudia na Nilo sinavaina ranuna bae inua na lalodia asie heḡereḡere. Aigupto tanona idoinai rara mo e aruva. ");
INSERT INTO meu_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","A Aigupto mea taudia na una kara heḡereḡerena ma e kara, edia mea daidai. Bena Farao ese lalona ma e ha-aukaia, se kamonai henidia, Iehova ena hereva heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Hari Farao na e lou, ena ruma ela, se helalo. ");
INSERT INTO meu_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Bena Aigupto taudia iboudiai ese guri e ḡei, sinavai isena ai, inuinu ranuna e tahua, badina be sinavai ranuna na se heḡereḡere bae inua. ");
INSERT INTO meu_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Iehova ese sinavai e botaia murinai dina hitu vada ela. ");
INSERT INTO meu_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Bena Iehova ese Mose ma e haduaia, eto, Farao dekena aola, ba hamaoroa, baoto “Iehova na ini e gwau tomamu: Egu orea taudia a kahudia nege, baela, bae toma henigu diho; ");
INSERT INTO meu_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","a basio kahudia nege, lau na parapara baina siadia emu tano idoinai bae hadikaia. ");
INSERT INTO meu_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Sinavai na parapara ai bae honu; bena bae dae emu ruma ai, bona emu mahuta gabuna ai, bona emu mahuta patana ai, bona emu hesiai taudia edia ruma ai, bona emu orea taudia edia ruma ai, bona emu amu lalodiai, bona emu dihu lalodiai. ");
INSERT INTO meu_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Harihari parapara na oi latamu ai bae dae, bona emu orea taudia latadiai, bona emu hesiai taudia iboudiai latadiai”. ");
INSERT INTO meu_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Iehova ese Mose me e hamaoroa, eto, Aaron ba haduaia, baoto “Emu itotohi imamu ai bavabia, ba toia roro sinavai badadia bona maraḡidia bona gohu daediai, parapara ba hadaedia Aigupto tanona idoinai”. ");
INSERT INTO meu_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Taunabunai, Aaron na imana e toia roro Aigupto ranudia daediai, bena parapara na ranu amo e dae kau, Aigupto tanona e hahonua. ");
INSERT INTO meu_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","A mea taudia na una kara heḡereḡerena ma e kara, edia mea daidiai, parapara ma e hahohodia Aigupto tanona idoinai. ");
INSERT INTO meu_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Bena Farao ese Mose bona Aaron e boiridia, eto, Iehova ba noia, parapara na lauegu amo bona egu orea taudia edia amo baine abi oho, bena emui orea taudia baina kahudia nege, baela, Iehova bae boua. ");
INSERT INTO meu_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Bena Mose ese Farao e haere henia, eto, Mani a hereva, edena nega ai baina noinoi oi daimu ai bona emu hesiai taudia daidiai bona emu orea taudia daidiai, bena parapara na unui emui amo bona emui ruma amo bae heabi oho, sinavai ai mo bae noho. ");
INSERT INTO meu_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ia eto, Kerukeru. Bena Mose eto, Emu hereva heḡereḡerena baine hekara; bena vada ba diba, Iehova, ai amai Dirava, na asi idaina. ");
INSERT INTO meu_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Parapara ese oi bae rakatanimu, emu ruma bona emu hesiai taudia bona emu orea taudia danu bae rakatanidia, sinavai ai mo bae noho. ");
INSERT INTO meu_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Taunabunai, Mose bona Aaron ese Farao e rakatania, e raka lasi. Bena Mose ese Iehova e noia, hari parapara, Farao e hadikalaiava ḡaudia, herevadia e gwaurai. ");
INSERT INTO meu_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Bena Iehova ese Mose e kamonai henia; bena ruma ai bona ariara ai bona uma ai parapara e mase ore. ");
INSERT INTO meu_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","E haboudia bena vada e bodaga, bonadia na tano idoinai e dae. ");
INSERT INTO meu_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","A Farao ese e itaia, vada e madinamo, bena lalona ma e ha-aukaia, se kamonai henidia, Iehova ese e gwauraia heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Bena Iehova ese Mose e hamaoroa, eto, Aaron ba haduaia, baoto “Emu itotohi ba toia roro ḡahuna, namo ai bainela, Aigupto tanona idoinai”. ");
INSERT INTO meu_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Bena unu e kara toma: Aaron ese ena itotohi e abia, tano ḡahuna e botaia, bena namo e kau, taunimanima bona boromakau e koridia; tano ḡahuna idoinai Aigupto tanona ai namo ai ela. ");
INSERT INTO meu_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Bena mea taudia ese edia mea amo namo e havaradia toho, to ihavaradia asi dibadia. A namo ese taunimanima bona boromakau e koridia. ");
INSERT INTO meu_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Bena hari mea taudia ese Farao a hamaoroa, eto, Ina na Dirave imana kwakikwakina. A Farao lalona ma e auka, se kamonai henidia, Iehova ese e gwauraia heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Bena Iehova ese Mose e hamaoroa, eto, Daba vaburana ai ba tore isi, Farao ba naria, digu bainela negana ai, bena ba hereva henia, baoto “Iehova ini e gwau tomamu: Egu orea taudia e kahudia nege, bae toma henigu diho. ");
INSERT INTO meu_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Badina be basioma kahudia nege, lau na lao momo baina siaidia, oi latamu ai bona emu hesiai taudia bona emu orea taudia bona emui ruma latadiai bae kau; Aigupto taudia edia ruma bona edia tano be lao ai bae honu. ");
INSERT INTO meu_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Una negana ai oiemu tano Bona Gosen tanona, egu orea taudia edia tano, baina hapararadia; unuseni ai lao basie kau. Unu amo vada ba diba lau be Iehova, tanobada bogaraginai. ");
INSERT INTO meu_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Lauegu orea taudia bona oiemu orea taudia baina hapararadia: kerukeru ina toa ba itaia”. ");
INSERT INTO meu_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Bena Iehova na uni e kara toma: lao momo herea e kau, Farao ena ruma ai bona hesiai taudia edia ruma ai; Aigupto tanona idoinai vada e dika rohoroho, lao daidiai. ");
INSERT INTO meu_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Bena Farao ese Mose bona Aaron e boiridia, eto, Aola, ina tano ai emui Dirava ba boua. ");
INSERT INTO meu_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","A Mose eto, Unu baia kara toma na dia maoro; badina be Iehova emai Dirava ibouna ai baia aladia ḡaudia na Aigupto taudia ese e dadaraidiamu ḡaudia, bena idia vairadiai unu baia kara toma, idia ese nadi amo bae hodomai. ");
INSERT INTO meu_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","A baia laolao tano ḡaḡaena ai, dina toi baia raka, Iehova, emai Dirava, baia boua, baine haḡanimai heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Bena Farao eto, Baina kahumui nege; Iehova, emui Dirava, do ba boua tano ḡaḡaena ai; ḡau tamona dauha basiola, bona lau daigu ai ba ḡuriḡuri. ");
INSERT INTO meu_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Bena Mose eto, Oi vairamu amo aina raka lasi, Iehova baina noia, ini lao momo be Farao ena amo bona ena hesiai taudia edia amo bona ena orea taudia edia amo kerukeru bae heabi oho. Ḡau tamona, Farao na basine koikoi lou, emai taunimanima na Iehova ibouna baela, basine rudia. ");
INSERT INTO meu_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Taunabunai Mose na Farao vairana amo e raka lasi, Iehova e ḡuria. ");
INSERT INTO meu_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Bena Iehova ese Mose ena noinoi heḡereḡerena e karaia: lao momo be Farao ena amo bona hesiai taudia edia amo bona ena orea taudia edia amo e abi oho, ta se miava. ");
INSERT INTO meu_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","A Farao na lalona ma e ha-aukaia lou, Heberu taudia se kahudia nege. ");
INSERT INTO meu_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Bena Iehova ese Mose e haduaia, eto, Farao dekenai ba raka vareai, ba hamaoroa, baoto “Iehova, Heberu taumai emai Dirava, ini e gwau tomamu: Egu orea taudia ba kahudia nege, bae toma henigu diho. ?");
INSERT INTO meu_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Badina be boma rudia, doene boma dogodia tao, ");
INSERT INTO meu_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","lau Iehova imagu na emu seri taora ai e nohomu latadiai baine kau, hosi latadiai bona doniki latadiai bona kamelo latadiai bona boromakau latadiai bona mamoe latadiai: gorere dikana ediai baine kau. ");
INSERT INTO meu_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Lau Iehova ese Israel edia seri bona Aigupto edia seri baina hididia: Israel taudia edia ḡau ta basine mase”. ");
INSERT INTO meu_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Bena Iehova ese nega e abia hidi, eto, Kerukeru lau Iehova ese unu baina kara toma ina tano ai. ");
INSERT INTO meu_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Bena kerukeru Iehova ese unu e kara toma; bena Aigupto taudia edia seri iboudiai eha mase, a Israel taudia edia seri ai ḡau ta se mase. ");
INSERT INTO meu_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Bena Farao ena hesiai taudia ese hereva e mailaia, Israel taudia edia seri ai ḡau ta se mase. A Farao ese lalona ma e ha-aukaia, Heberu taudia se kahudia nege. ");
INSERT INTO meu_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Bena Iehova ese Mose bona Aaron e hamaorodia, eto, Lahi kahuna bavabia, Mose ese baine tahoa dae Farao vairanai. ");
INSERT INTO meu_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Una kahu na baine heḡiḡi rohoroho Aigupto tanona idoinai, bena iohururu bae vara bona bae toto, taunimanima kopidia ai bona mauri ḡaudia idau-idau iboudiai kopidia ai, Aigupto tanona idoinai. ");
INSERT INTO meu_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Bena idia ese lahi kahuna e abia, Farao vairanai e gini; bena Mose ese e tahoa dae, bena iohururu e vara bona e toto, taunimanima kopidia ai bona mauri ḡaudia iboudiai kopidia ai. ");
INSERT INTO meu_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Bena mea taudia na asi goadadia Mose vairanai bae gini, badina be idia danu mai iohururudia, Aigupto taudia iboudiai heḡereḡeredia. ");
INSERT INTO meu_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","A Iehova ese Frao lalona ma e ha-aukaia, bena ia ese se kamonai henidia, Iehova ese Mose e hamaoroa guna heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Bena Iehova ese Mose e haduaia, eto, Daba matana ai ba tore isi, Farao vairanai ba gini, ba hamaoroa, baoto “Iehova, Heberu taumai emai Dirava, ini e gwau tomamu: Egu orea taudia ba kahudia nege, bae toma henigu diho. ");
INSERT INTO meu_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Badina be ina nega ai egu hahehisi iboudiai na oi latamu ai bona emu hesiai taudia latadiai bona emu orea taudia latadiai baina siai, bena vada ba diba lau be asi idaigu tanobada idoinai. ");
INSERT INTO meu_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Badina be imagu bama toia roro, siahuna korikorina amo bama hahisimui, boma mase ore. ");
INSERT INTO meu_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","A ina dainai vada na hamaurimu: egu siahu baina haheitalaimu bena tanobada idoinai lau ladagu bae heatolaia helaoreana. ");
INSERT INTO meu_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Doini o heaḡimu egu orea taudia vairadiai dainai ikahu-negedia so uramu. ");
INSERT INTO meu_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","A kamonai: kerukeru, hora inihetomana ai, medu hetarina dika-hereana baina hadihoa, tanobada matamana negana ema bona hari Aigupto tanona do asi dibana ḡauna. ");
INSERT INTO meu_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Taunabunai, hari dina ai emu boromakau bona emu ḡau iboudiai taora ai e nohomu na ba hakaudia vareai; badina taunimanima bona mauri ḡaudia hahidaosi basio abidia vareai a taora ai bae noho na medu hetarina ese baine aladia bena iboudiai bae mase ore”. ");
INSERT INTO meu_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Bena Farao ena hesiai taudia hahidaosi, Iehova gadona garina e gariva, ese edia hesiai taudia bona edia seri e hakaudia vareai ruma ai; ");
INSERT INTO meu_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","a Iehova ena hereva e dadaraia tauna ese ena hesiai taudia bona ena seri e rakatanidia taora ai. ");
INSERT INTO meu_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Bena Iehova ese Mose e hamaoroa, eto, Imamu a duduia isi, medu-hetarina baine diho Aigupto tanona idoinai, taunimanima latadiai bona mauri ḡaudia idau-idau latadiai bona au idau-idau ava idau-idau iboudiai latadiai, Aigupto tanona idoinai. ");
INSERT INTO meu_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Bena Mose ese ena itotohi e duduia isi; bena Iehova ese guba-rahu bona medu-hetari e hadiho tanobada ai, lahi danu tanobada ai e diho. Iehova ese medu-hetarina e hadihoa Aigupto tanona idoinai. ");
INSERT INTO meu_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Taunabunai, medu-hetarina bona lahi e diho bou, vada e bada herea; Aigupto tanona idoinai nega ta unu asie diho toma, Aigupto besena e vara matama amo ema. ");
INSERT INTO meu_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Bena medu-hetarina ese taora ai e nohova ḡaudia iboudiai e aladia, Aigupto tanona idoinai, taunimanima bona mauri ḡaudia idau-idau; medu-hetarina danu taora avadia iboudiai e hadika bona au iboudiai e hagari. ");
INSERT INTO meu_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Gosen tanona ai mo, Israel taudia ese e noholaia tanona ai, medu-hetarina na se diho. ");
INSERT INTO meu_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Bena Farao ese Mose bona Aaron e boiridia, eto Lau na ina nega ai vada na kara havara: Iehova na maoromaoro; lau bona egu orea taudia na kara dika taumai. ");
INSERT INTO meu_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Iehova ba noia, badina be ini guba-rahu bona medu-hetari badadia vada eme davana. Vada baina kahumui nege; ina murinai basina dogomui tao. ");
INSERT INTO meu_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Bena Mose ese e haere henia, eto, Hanua amo aina raka lasi, imagu aina toi roro, Iehova enai; bena guba-rahu baine doko, medu-hetarina danu baine doko: unu amo vada ba diba tanobada na Iehova ena. ");
INSERT INTO meu_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ḡau tamona, lau dibagu oi bona oiemu hesiai taudia ese Dirava Iehova do basio matauraia. ");
INSERT INTO meu_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Una negana ai flax bona bali vada e dika: badina ba bali anina vada e dobi bona flax vada e tubu. ");
INSERT INTO meu_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","A uit bona rae na asie dika badina be do asie tubu. ");
INSERT INTO meu_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Bena Mose ese Farao e rakatania, hanua amo e raka lasi, imana e toi roro Iehova enai; bena guba-rahu bona medu-hetari na e doko, bona medu na se diho tanobada ai. ");
INSERT INTO meu_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","A Farao ese e itaia, medu bona medu-hetari bona guba-rahu vada e doko, bena is ese ena kara dika ma e habadaia, lalona ma e ha-aukaia lou, ia bona ena hesiai taudia danu. ");
INSERT INTO meu_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Farao lalona vada e auka, Israel taudia se kahudia nege, Iehova ese Mose e hamaoroa heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Bena Iehova ese Mose e hamaoroa, eto, Farao dekenai a raka vareai; badina be ia lalona vada na ha-aukaia, ena hesiai taudia danu lalodia vada na ha-aukadia, egu toa bini bogaragtidiai baina hahedinarai helaoreana. ");
INSERT INTO meu_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Bena Aigupto ede baina kara henia toma, bona Aigupto taudia bogaragidiai egu toa ede na hahedinarai toma, natumu ba hadibaia bona tubumu ba hadibaia; bona ba diba binai Iehova. ");
INSERT INTO meu_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Bena Mose bona Aaron na Farao dekenai e raka vareai, e hereva henia, eto, Ieova, Heberu taumai emai Dirava, na ini e gwau tomamu: Lau vairagu ai ba hekokoroku ela bona edena nega ai? Egu orea taudia a kahudia nege, bae toma henigu diho. ");
INSERT INTO meu_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","A bema lasi, boma rudia, lau ese kerukeru kwadi baina siaidia emu tano ai; ");
INSERT INTO meu_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","idia ese tano kopina bae ḡovaia ahu, tano na basio itaia diba. Bena amui aniani orena, medu-hetarina ese se hadikaia ḡauna, na idia ese bae ania ore; bona au iboudiai dounu mimia taora ai vada bae ani ore. ");
INSERT INTO meu_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Emu ruma danu, bona emu hesiai taudia iboudiai edia ruma, bona Aigupto taudia iboudiai edia ruma, na kwadi ai mo bae honu; unuhetomana tubumui tamamui ese asie itaia, edia vara dinadia amo ema bona hari. Bena is ese Farao vairana amo e raka lasi. ");
INSERT INTO meu_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Bena Farao ena hesiai taudia ese e hereva henia, eto, Ina tau ese baine hahekwakwanaida ela bona edena nega ai? Tatau be ba kahudia nege, baela, Iehova edia Dirava bae toma henia diho. Asi dibamu Aigupto vada e dika vaitani a? ");
INSERT INTO meu_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Bena Mose bona Aaron ma e hakaudia vareai lou, Farao vairanai. Ia ese e hamaorodia, eto Aola, Iehova emui Dirava ba toma henia diho; a umui ida baela taudia be daidia? ");
INSERT INTO meu_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mose eto, Emai memero bona emai iahu, natumai mamaruanedia bona natumai hahinedia, emai mamoe seridia bona emai boromakau seridia, iboudiai baia laohaidia; badina be aria ta baia karaia, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ia ese e hamaorodia, eto, Bama kahumui nege, Iehova ese bema rumui. Emui lalo-hadai na dika. ?");
INSERT INTO meu_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Dia unuheto: umui tatau mo baola, Iehova ba toma henia diho, badina be emui ura bunai. Bena Farao vairana amo e luludia lasi. ");
INSERT INTO meu_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Bena Iehova ese Mose e hamaoroa, eto, Imamu a toia roro Aigupto tanona daenai, kwadi vada bae kau Aigupto tanona ai, aniani avadia iboudiai medu-hetarina ese se hadika na idia ese bae ani ore. ");
INSERT INTO meu_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Bena Mose ese ena itotohi toia roro Aigupto tanona daenai: bena Iehova ese lai laurabada kahana amo e siaia, una tano e toa henia boi, e toa henia rani. Dabi ai, una lai ese kwadi e mailaidia. ");
INSERT INTO meu_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Bena kwadi na Aigupto tanona idoinai e heḡiḡi rohoroho ela bona Aigupto tanona hetoana idoinai; idia na dika rohoroho. Kwadi unuhohodia na nega ta asie hedinarai ema bona una negana, ma unuhohodia na basie hedinarai lou. ");
INSERT INTO meu_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Badina be tano kopina adoinai idia ese e ḡovaia ahu; tano vada e korema. Idia ese aniani avadia iboudiai e ani ore una tano ai, bona au huahuadia iboudiai medu-hetarina ese se hadika ḡaudia na idia ese e ani ore. E tubumu ḡauna ta, au eiava tano avana, se miava, Aigupto tanona idoinai. ");
INSERT INTO meu_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Bena Farao ese Mose bona Aaron e boiridia haraḡa-haraḡa, e hamaorodia, eto, Lau na Iehova emui Dirava vairanai bona umui vairamui ai vada na kara havara. ");
INSERT INTO meu_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Taunabunai, na noimumu, ina nega tamona mo egu dika ba gwaua tao, bona Iehova emui Dirava ba noia, ia ese ina mase ḡauna egu amo baine abia oho. ");
INSERT INTO meu_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Bena Mose na Farao vairana amo e raka lasi, Iehova e now henia. ");
INSERT INTO meu_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Bena Iehova ese lai badana lahara kahana amo e siaia, una lai ese kwadi e odadia isi, Davara Kakakakana lalonai e odadia lao; Aigupto tanona hetoadia idoidiai kwadi ta dia mia. ");
INSERT INTO meu_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","A Iehova ese Farao lalona ma e ha-aukaia, bena Israel taudia se kahudia nege. ");
INSERT INTO meu_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Bena Iehova ese Mose ma e hamaoroa, eto, Imamu ba duduia isi, bena dibura ese Aigupto tanona idoinai baine gorua ahu; idia ese dibura bae mamia toho. ");
INSERT INTO meu_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Bena Mose ese imama e duduia isi. Bena Aigupto tanona idoinai e dibura masemase, ela dina toi vada e ore. ");
INSERT INTO meu_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Taunimanima na asie heita heheni, bona edia helai noho gabudia amo asie tore isi, dina toi lalodiai. A Israel taudia iboudiai edia noho gabudia na didiari. ");
INSERT INTO meu_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Bena Farao ese Mose e boiria, eto, Vada aola, Iehova ba toma henia diho, ḡau tamona emui mamoe seridia bona emui boromakau seridia ba rakatanidia, natumui mo ba hakaudia lao. ");
INSERT INTO meu_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","A Mose eto, Lasi, emai boubou ḡaudia bona lahi ese baine ḡole oho ḡaudia ba hemimai, Iehova emai Dirava do baia boua. ");
INSERT INTO meu_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Emai boromakau baia laohaidia, ta basine mia; badina be unu amo Iehova emai Dirava baia boua, bona asi dibamai dahaka ḡau dahaka ḡau amo Iehova baia boua ela bona ihaboulaina gabuna ai baia kau. ");
INSERT INTO meu_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","A Iehova ese Farao lalona ma e ha-aukaia, bena se kahudia nege. ");
INSERT INTO meu_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Bena Farao ese e hamaoroa, eto, A siri, nahuamu ba tohoa danu, lau vairagu basio itaia lou; badina be vairagu ba itaia lou dinana ai vada ba mase. ");
INSERT INTO meu_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Bena Mose eto, Vada o hereva momokani; vairamu basina itaia lou. ");
INSERT INTO meu_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Bena Iehova ese Mose e hamaoroa, eto, Hahehisi ta ma Farao latanai bona Aigupto latanai aina siaia, maurinai ia ese baine kahumui nege; baine kahumui nege negana ai danu baine lulumui vaitani. ");
INSERT INTO meu_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Harihari Israel taudia ba haduadia, ta ta ese dekena tauna dekena tauna bae noidia, hahine danu unu bae kara toma, herahera ḡaudia, silver bona gold amo e karamu, bae noilai. ");
INSERT INTO meu_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Bena Iehova ese Aigupto taudia lalodia e hakerudia Israel taudia ediai; Mose danu ladana na bada Aigupto ai, Farao ena hesiai taudia ediai bona hanua taudia ediai. ");
INSERT INTO meu_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Bena Mose eto, Iehova na ini e gwau tomamu: Malokihi ai Aigupto tanona baina rakaia hanai; ");
INSERT INTO meu_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","bena Aigupto taudia natudia roboadia iboudiai bae mase, Farao, terono ai e helaimu tauna, natuna roboana, ela bona hesiai hahinena, uit iririlaina nadina e giroamu hahinena, natuna roboana, ela bona boromakau iboudiai natudia roboadia danu. ");
INSERT INTO meu_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Aigupto tanona idoinai tai badana baine vara; nega ta unu asie tai toma ema bona hari, bona ina murinai danu unu basie tai toma. ");
INSERT INTO meu_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","A Israel taudia mai edia boromakau ida sisia ta ese basine kwaru henidia: taunabunai, vada ba diba Iehova ese Aigupto taudia bona Israel taudia vada e hididia. ");
INSERT INTO meu_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Bena ini emu hesiai taudia iboudiai lau dekegu baema, vairagu ai bae goru diho, baeto “A raka lasi, emu orea taudia iboudiai ida”; una murinai baina raka lasi. Bena ia na Farao vairana amo e raka lasi ma badu ḡaraḡarana ida. ");
INSERT INTO meu_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Bena Iehova ese Mose e hamaoroa, eto Farao basine kamonai henimu, egu hoa karadia Aigupto tanona ai bae momo helaoreana. ");
INSERT INTO meu_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mose bona Aaron ese unu hoa karadia iboudiai Farao vairanai e kara; a Iehova ese Farao lalona e ha-aukaia, taunabunai ia ese Israel taudia na ena tano amo se kahudia nege. ");
INSERT INTO meu_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Bena Iehova ese Mose bona Aaron e hereva henidia, Aigupto tanona ai, eto. ");
INSERT INTO meu_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Ina hua na hua gini-gunana ai bainela umui emui ai, emui laḡani matamana huana ai bainela. ");
INSERT INTO meu_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Israel taudia iboudiai edia hebou ai ba hereva henidia, ina hua dinana ihagwautana, ta ta ena iduhu ena iduhu ai mamoe natudia bae abidia, ruma ta mamoe natuna ta, unu bae abidia toma. ");
INSERT INTO meu_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","A ruma ta taudia basie hoho, una ruma taudia bona e gini hetabira rumana taudia na mamoe natuna ta bae abia hebou, taunimanina hahidaosi na vamu iani-orena bae davana heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Emui mamoe na asi toutouna ḡauna, maruane, laḡani tamona ḡauna; mamoe serina amo bavabia eiava nani serina amo. ");
INSERT INTO meu_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ba balaia heni ela bona hua dinana ihagwauta-hanina ai; bena dina baine hakere ai Israel hegogona idoinai ese edia mamoe natudia bae aladia mase. ");
INSERT INTO meu_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Bena rarana bavabia, iduara ihua-ihuana kahana kahana audia bona daena auna ba dahulai, bae ani rumadia ai. ");
INSERT INTO meu_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Una hanuaboi amui aniani na mamoe natuna hidiona, amu ai bae guraia, bona flaoa kavakava, muramura ai basie hatubua, bona aniani avadia iditadia. ");
INSERT INTO meu_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Kasirina ai basio ania, bona basio nadua; tau-anina idoinai amu ai ba guraia, mai kwarana, mai imana, mai aena, bona mai bogana ida. ");
INSERT INTO meu_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Bahuna taina basine mia rani; lahi ai ba haḡolea oho. ");
INSERT INTO meu_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ini bavania tona: emui rami ba hekasilai, emui tamaka aemui ai, emui itotohi imamui ai. Bavani haraḡa: una na Iehova ena lagau hanai. ");
INSERT INTO meu_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Badina be una hanuaboi ai Aigupto tanona baina rakaia hanai, natudia roboadia iboudiai baina aladia mase, taunimanima bona boromakau danu; bona Aigupto diravadia iboudia danu baina hahemaoro henidia; lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Hari rara na toa ai bainela emui noho rumadia ai; rara baina itaia negana ai, baina lagaumui hanai hahedika ta emui ai basine kau, basine alamui, imagu na Aigupto ai baine kau negana ai. ");
INSERT INTO meu_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ina dina danu ba laloa tao hanaihanai; ariana danu ba karaia Iehova ena; uru iboudiai bae karaia, taravana danu bae atua. ");
INSERT INTO meu_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Dina hitu flaoa dikeadia, asie hatubu ḡaudia, bavani; dina gini-gunana ai hatubu muramurana idoinai emui ruma ai mia na bavatoa tabe murimuri ai: badina be dina gini-gunana ela bona dina ihahituna, e hatubua flaoana baine ania tauna na Israel besena amo bae negea daure. ");
INSERT INTO meu_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Dina gini-gunana ai hebou helaḡana ai ba hebou, bona dina ihahituna ai hebou helaḡana ai ma ba hebou; unu dina ruaosi lalaidai ḡaukara ta basio karaia, hebou taudia adia aniani idabarana mo vadaeni. ");
INSERT INTO meu_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Flaoa-asie-hatubua Ariana unu ba karaia toma: badina be emui orea loḡora Aigupto amo name hakaudia lasi dinana binai; taunabunai hari dina na uru iboudiai ese bae badinaia bona taravana bae atua ela bona hanaihanai. ");
INSERT INTO meu_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Hua gini-gunana dinana ihagwauta-hanina adorahina ai asie hatubua flaoana bavania, ela bona dina iharuahui-tana adorahina. ");
INSERT INTO meu_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Dina hitu flaoa ihatubuna muramurana basie mia emui ruma ai: badina be e hatubua flaoana baine ania tauna, ena be noho-hedoa tauna eiava Isreal tauna korikori, to Israel hebouna amo bae nega daure. ");
INSERT INTO meu_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","E hatubua ḡauna ta basio ania; emui noho gabudia iboudiai flaoa dikeadia, asie hatubu ḡaudia, mo bavani. ");
INSERT INTO meu_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Bena Mose ese Israel tau-badadia iboudiai e boiridia, e haduadia, eto, Mamoe natudia bavabi hidi, iduhu ta ta adia, lagau-hanai ḡauna bavalaia mase. ");
INSERT INTO meu_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Muramura avana iḡuina bavabia, rara dihuna ai ba urua diho, iduara ihua-ihuama kahana kahana audia bona iduara daena auna na dihu rarana amo ba dahudia; bena atu ta ena ruma iduarana amo basine raka lasi ela bona daba. ");
INSERT INTO meu_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Badina be Iehova ese ina tano baine rakaia hanai, Aigupto taudia baine aladia mase; a rara iduara daene auna ai bona iduara ihua-ihuana kahana kahana audia ai baine itaia negana ai, Iehova ese una iduara baine lagaua hanai, hahedika ḡauna baine laoa ahu, emui ruma ai basine raka vareai, basine hamasemui. ");
INSERT INTO meu_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Ina kara ba badinaia bona taravana bavatua, oiemu bona natumu edia, ela bona hanaihanai. ");
INSERT INTO meu_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Benaini, Iehova ese baine henimui tanona ai ba kau, ena gwauhamata heḡereḡerena negana ai ina toma-diho karana ba badinaia. ");
INSERT INTO meu_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Bena natumui bae nanadaimui, baeto “Ina toma-diho karana anina be dahaka?”, ");
INSERT INTO meu_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","umui ba haere, baoto “Ina na Iehova ena lagau-hanai boubou karana; Aigupto ai ia ese Israel taudia edia ruma e lagaudia hanai, Aigupto taudia mo e aladia mase, eda iduhu iboudiai e hamauridia”. Bena taunimanima iboudiai e igo diho, e toma diho, e toma diho. ");
INSERT INTO meu_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Bena Israel taudia na ela, Mose bona Aaron e haduadia heḡereḡerena unu mo e kara toma. ");
INSERT INTO meu_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Bena una hanuaboi malokihina ai Iehova ese roboadia iboudiai Aigupto tanona idoinai e aladia mase, Farao, terono ai e helaiva tauna, natuna roboana, ela bona dibura rumana ai e hekouva tauna natuna roboana, bona boromakau natudia roboadia danu. ");
INSERT INTO meu_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Bena Farao bona ena hesiai taudia iboudiai bona Aigupto taudia iboudiai na hanuaboi ai e tore isi; bena taitai badana e vara Aigupto tanona ai, badina be ruma ta mase asi se kwabu. ");
INSERT INTO meu_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Bena hanuaboi ai Farao ese Mose bona Aaron e haduadia, eto, A tore isi, egu orea taudia bogaragidia amo ba raka lasi, umui bona Israel taudia iboudiai. Aola, Iehova ba toma henia diho, emui hereva heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Emui mamoe seridia bona emui boromakau seridia danu ba laohai, emui hereva heḡereḡerena. Vada aola: lau danu ba hanamogu. ");
INSERT INTO meu_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Aigupto taudia ese danu e haduadia goadagoada, edia tano amo bae raka lasi haraḡa-haraḡa eto. Badina be idia eto, Ai iboumai ai baia mase na garina. ");
INSERT INTO meu_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Bena Israel taudia ese edia flaoa, ranu ai e kui ḡaudia, e abi, edia kuikui dihudia danu e abi, edia dabua ai e kumi, e dibu ela. ");
INSERT INTO meu_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Bena Israel taudia ese Mose ena hereva e badinaia, Aigupto taudia ediai herahera ḡaudia, gold bona silver amo e karava, bona dabua e noi. ");
INSERT INTO meu_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Bena Iehova ese Aigupto taudia lalodia e hakerudia Israel taudia ediai, bena idia ese e noi ḡaudia na e henidia. Unu amo idia ese Aigupto taudia edia Kohu e dadi ore. ");
INSERT INTO meu_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Bena Israel taudia na Ramese amo e laolao ela bona Sukoto. Aedia amo e raka taudia na domaga tauratoi sisivana, bona memero kekeni danu. ");
INSERT INTO meu_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Orea idau-idau taudia hutuma ese e bamodia; edia mamoe seridia bona edia boromakau seridia danu momo herea. ");
INSERT INTO meu_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Bena hari flaoa ranu ai e kui, Aigupto tanona amo e raka lasi negana ai e abia kau ḡauna, na e gabua; ia na asie hatubua ḡauna. Badina be Aigupto amo e luludia lasi negana ai idia na asi edia halahe dalana bona asi edia nega bae nanadu. ");
INSERT INTO meu_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Hari Israel besena Aigupto tanona ai e nohova laḡanidia iboudiai na sinahu-hani toi-ahui. ");
INSERT INTO meu_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Laḡani sinahu-hani toi-ahui e ore dinana korikorina, Iehova ena orea iboudiai na Aigupto tanona amo e raka lasi. ");
INSERT INTO meu_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Una hanuaboi na bae badinaia tarika-tarika Iehova vairanai, ia ese Aigupto tanona amo e hakaudia lasi dainai: una hanuaboi na Iehova ena, Israel taudia iboudiai bae badinaia ela uru iboudiai. ");
INSERT INTO meu_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Iehova ese Mose bona Aaron e hereva henidia, eto, Lagau-hanai taravatuna binai: idau tauna ta basine ania; ");
INSERT INTO meu_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","a emui hesiai taudia moni amo o hoidia na ba peritomedia, marinai vada bae ania. ");
INSERT INTO meu_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","A noho-kau tauna bona e ḡaukaramu mai davana tauna na basie ania. ");
INSERT INTO meu_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Ruma lalonai bavania; hidiona taina basio laohaia murimuri ai, bona turiana ta basio hakwaidua. ");
INSERT INTO meu_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Israel hebouna idoinai vada bae ania. ");
INSERT INTO meu_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","A idau bese tauna bogaragimui ai e nohomu na bame ura Iehova ena lagau-hanai baine badinaia, ena ruma taudia mamaruanedia baine peritomedia guna, murinai ia na baine raka kahira, baine ania; badina be ia na emui ruma tauna korikorina na heto. A se peritomea tauna na basine ania. ");
INSERT INTO meu_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Taravatu be tamona, Israel tauna korikori enai bona noho-kau tauna enai. ");
INSERT INTO meu_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Taunabunai Israel taudia na unu e kara toma. Mose bona Aaron ese e haḡanidia heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Bena una dina ai Iehova ese Israel taudia edia orea iboudiai na Aigupto tanona amo e hakaudia lasi. ");
INSERT INTO meu_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Roboa mamaruanedia iboudiai Israel ai ba hahelaḡadia lauegu, taunimanima bona ubu-ubu ḡaudia; roboana be lauegu. ");
INSERT INTO meu_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Bena Mose ese Israel taudia e hamaorodia, eto, Ina dina ba laloa tao, badina be hari dina ai Aigupto amo, iḡui rumana amo, vada o raka lasi; Iehova imana goadana ese ina gabu amo vada e hakaumui lasi. E hatubua flaoana na basio ania. ");
INSERT INTO meu_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Hari ina dina ai ome raka lasi, hua ladana Abib ai. ");
INSERT INTO meu_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Bena kerukeru vanegai, Iehova ese Kanaan taudia bona Hiti taudia bona Amoro, taudia bona Hivi taudia bona Iebusu taudia edia tano ai baine hakaumu vareai, senemu e gwau henidia hamata baine henidia eto tanona, rata bona bada-ranuna e arumu tanona: una negana ai oi ese ina tomadiho karana ba karaia ina hua lalonai. ");
INSERT INTO meu_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Dina hitu lalodiai flaoa dikeadia, asie hatubu ḡaudia, bavani; bena dina ihahituna Iehova ena aria ba karaia. ");
INSERT INTO meu_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Unu dina hituosi lalodiai asie hatubua flaoana mo bavania; e hatubua flaoana na basine hedinarai dekemu ai, bona hatubu muramurana basine mia emu noho gabuna idoinai. ");
INSERT INTO meu_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Una dina ai natumu do ba hamaoroa, baoto, “Ina na Iehova ese e kahagu Aigupto amo e hakaugu lasi negana dainai”. ");
INSERT INTO meu_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ia na toa ta ai bainela imamu ai, bona helalo-tao ḡauna ai bainela bagumu ai, Iehova ena taravatu udumu ai baine mia helaoreana. Badina be Iehova imana goadana ese Aigupto amo e hakaumu lasi; ");
INSERT INTO meu_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","taunabunai ina haheḡani ba badinaia ena nega korikori ai laḡani iboudiai lalodiai. ");
INSERT INTO meu_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Bena Iehova ese Kanaan taudia edia tano ai baine hakaumu vareai, e gwau henimu hamata bona senemu e gwau henidia hamata heḡereḡerena, bona baine henimu, ");
INSERT INTO meu_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","una negana ai roboa mamaruanedia iboudiai ba hididia, taunimanima bona ubu-ubu ḡaudia danu; maruane iboudiai bae helaḡa, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Bena doniki natuna roboana davana na mamoe natuna ba heni; eiava davana basio heni negana ai aiona ba hakwaidua. A taunimanima natudia roboadia iboudiai na davadia ba kara. ");
INSERT INTO meu_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Bena negana baine kau natumu ese baine nanadaimu, baineto “Ina kara be dahaka?”, oi ese ba haere henia baoto “Iehova imana goadana ese Aigupto, maduna metaudia gabuna, amo e hakaumai lasi; ");
INSERT INTO meu_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","bena Farao ese baine dogomai tao eto negana ai Iehova ese roboa mamaruanedia iboudiai Aigupto tanona ai e aladia mase, taunimanima bona ubu-ubu ḡaudia danu: taunabunai roboa mamaruanedia iboudiai na Iehova ena ihaboulaina ḡaudia ai na halaodiamu, a natugu roboadia na davadia na karamu”. ");
INSERT INTO meu_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ia na toa ai bainela imamu ai bona bagumu ai: badina be Iehova imana goadana ese Aigupto ese Aigupto amo vada e hakauda lasi. ");
INSERT INTO meu_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Farao ese Israel taudia e kahudia nege murinai, Dirava ese dala kwadogina, Filistia taudia edia tano ai, se hakaudia; badina be Dirava eto “Idia na tuari mamina bae diba, bena bae helalo kerehai, Aigupto bae lou henia readia”. ");
INSERT INTO meu_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Bena Dirava ese tano ḡaḡaena ai e hakaudia lao, Davara Kakakakana badinai. Israel taudia ese mai edia tuari ḡaudia imadia ai Aigupto tanona e rakatania. ");
INSERT INTO meu_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mose ese Iosef turiana danu e laohai; badina be Iosef ese Israel taudia taravadia vada e atua, eto “Momokani, Dirava ese baine vadivadi henimui; una negana ai umui ese lau turiagu bavabi kau”. ");
INSERT INTO meu_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Bena idia na eha laolao, Sukoto amo ela bona Etam, tano ḡaḡaena isena ai. ");
INSERT INTO meu_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Iehova na idia vairadiai ela, dina ai ori dubuna lalonai, edia dala ihahedinaraina, bona hanuaboi ai lahi mamana lalonai, edia diari, bae laolao boi bae laolao rani helaoreana. ");
INSERT INTO meu_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Bena hari ori dubuna asine rakatanidiava dina ai, bona lahi mamana asine rakatanidiava hanuaboi ai. ");
INSERT INTO meu_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Bena Iehova ese Mose e hareva henia, eto ");
INSERT INTO meu_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Israel taudia ba haduadia, bae lou, Pi-hahiroto vairanai bae taruha, Migdol bona davara padadiai, Baal-sefon vairanai; ia hevaira-hehenina ai davara badinai ba taruha. ");
INSERT INTO meu_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Badina be Farao ese Israel taumui baine herevalaimui, baineto “Idia na tano ḡaḡaena ai e raka hehiri-hehirimu, lalodia vada e haboioboio”. ");
INSERT INTO meu_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Bena lau ese Farao lalona baina ha-aukaia, bena ia ese baine ḡavamui; a lau ese Farao mai ena tuari oreana idoinai baina hadareredia, bena Aigupto taudia vada bae diba lau na Iehova. Bena unu e kara toma. ");
INSERT INTO meu_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Una negana ai haida ese Aigupto pavapavana e hamaoroa Israel taudia vada e heau; bena Farao mai ena hesiai taudia ida e halalo, lalodia ma e idau Israel taudia ediai. Idia eto “Israel taudia ta kahudia nege, isiaida ilao-henina ai bae doko, anina be dahaka?” ");
INSERT INTO meu_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Bena ia ese ena kariota e abia heḡaeḡae, bona ena orea taudia e hakaudia lao. ");
INSERT INTO meu_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Kariota namodia sinahu tauratoi e abidia hidi, bona kariota oredia danu e laohai, Aigupto kariotadia iboudiai, ta ta mai biagudia. ");
INSERT INTO meu_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Una negana ai Iehova ese Farao, Aigupto pavapavana, lalona e ha-aukaia, bena ia ese Israel taudia e ḡavadia; badina be Israel taudia vada e raka lasi, asi edia gari. ");
INSERT INTO meu_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Aigupto taudia ese e ḡavadia, Farao ena hosi bona ena kariota iboudiai, ena orea taudia hosi ai e gui danu, bona ena tuari taudia, bena idia ese Israel taudia e lasidia tao edia taruha ai, davara badibadinai, Pi-hahiroto badinai, Baal-sefon vairani. ");
INSERT INTO meu_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Farao na e raka kahira; bena Israel taudia e roha isi, Aigupto taudia e itadia vada e lasidia tao, bena e gari dikadika, Iehova e tai henia. ");
INSERT INTO meu_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Bena idia ese Mose e gwau henia, eto, Aigupto ai gara gabudia lasi a? Una dainai oi ese vada o hakaumai lasi, tano ḡaḡaena ai baia mase totona a? Badina be dahaka Aigupto amo vada o hakaumai lasi? ");
INSERT INTO meu_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ai na Aigupto ai asia hereva henimu, a, asiato “Emai ai a raka oho, ai na Aigupto taudia isiaidia baia lao heni”, a? Badina be Aigupto taudia isiaidia baiama lao heni be namo, a tano ḡaḡaena ai baiama mase na dika. ");
INSERT INTO meu_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","A Mose eto, Basio gari, ba gini tutuka-tutuka, Iehova ena hahemauri do ba itaia, hari dina ai baine hamaurilaimui, badina be Aigupto taudia harihari o itadiamu na basio itadia lou, lasi ona lasi vaitani. ");
INSERT INTO meu_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Iehova na umui daimui ai baine tuari; umui na ba noho boioboio. ");
INSERT INTO meu_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Iehova ese Mose ma e hamaoroa, eto, Dahaka dainai o tai henigumu? Israel taudia ba haduadia, bae raka lao. ");
INSERT INTO meu_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Oiemu itotohi danu ba duduia isi, imamu davara daenai ba toia roro, ba hapararaia; bena Israel taudia na tano kaukauna ai bae raka hanai. ");
INSERT INTO meu_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","A lau be Aigupto taudia lalodia baina ha-aukadia, bena bae ḡavamui: bena lau ese Farao mai ena tuari oreana idoinai, ena kariota bona ena hosi-gui taudia, baina hadareredia. ");
INSERT INTO meu_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Bena Farao bona ena kariota bona ena hosi-gui taudia baina hadareredia negana ai Aigupto taudia na bae diba lau na Iehova. ");
INSERT INTO meu_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Bena Dirava ena aneru, Israel ena taruha vairanai e nohova aneruna, na muridia kahana ela; bona ori dubuna danu idia vairadia kahana amo e heabi isi, idia muridia kahana ela, ");
INSERT INTO meu_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Aigupto taudia edia taruha bona Israel taudia edia taruha padadiai eha gini. Bena ori na dibura ai e miava, to ia ese diari e henidia hanuaboi ai; bona una hanuaboi idoinai orea ta ese orea ta se raka henia kahi. ");
INSERT INTO meu_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Bena Mose ese imana e toia roro davara daenai; bena Iehova ese lai gubana amo davara e haloua, una hanuaboi idoinai. Bena davara na e haheparara, tano kaukauna e hedinarai. ");
INSERT INTO meu_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Bena Israel taudia ese tano kaukauna ai davara e rakaia hanai; davara ranuaia e kara haba na heheto, idibidia kahana ai bona lauridia kahana ai. ");
INSERT INTO meu_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Bena Aigupto taudia ese davara bogaragina amo e ḡavadia, Farao ena hosi bena ena kariota bona ena hosi-gui taudia iboudiai ese e ḡavadia. ?");
INSERT INTO meu_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","A daba kahana ai Iehova ese lahi mamana bona ori dubuna amo Aigupto edia tuari oreadia e nenedia, bena e hahekwarahdia: ");
INSERT INTO meu_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","edia kariota uilidia e hepuni, bena kariota na asie heau namonamova. Taunabunai Aigupto taudia e hereva heheni, eto, Israel taudia vairadia amo baita heau, badina be Iehova ese idia e durudiamu, ita e tuari henidamu. ");
INSERT INTO meu_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Bena Iehova ese mose e hamaoroa, eto, Oi imamu na davara daenai ma ba toia roro, ranu ma baine lou, Aigupto taudia latadiai bona edia kariota latadiai bona edia hosi-gui taudia latadiai. ");
INSERT INTO meu_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Bena Mose ese imana e toia roro daenai, bena daba matana ai davara ma e lou gabuna ai; bena Aigupto taudia na davara vairanai e heau. Unu amo Iehova ese Aigupto taudia e hadareredia, davara bogaraginai: ");
INSERT INTO meu_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ranu na e lou, kariota bona hosi-gui taudia bona Farao ena tuari oreana idoinai, davara bogaragina amo Israel taudia e ḡavadia taudia iboudiai na e habubunidia; ta we roho mauri. ");
INSERT INTO meu_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","A Israel taudia na tano kaukauna ai e raka hanai, davara bogaraginai; ranu na e kara haba na heheto, idibadia kahana ai bona lauridia kahana ai. ");
INSERT INTO meu_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Unuhetomana Iehova ese Israel taudia na Aigupto taudia imadia amo e hamauridia una dina ai. Bena Israel taudia ese Aigupto taudia masedia ai e itadia, kone ai. ");
INSERT INTO meu_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Aigupto taudia na Iehova ese ede e karadia toma Israel taudia ese e itaia; bena iboudiai ese Iehova garina e gari. Idia ese Iehova e abidadama henia, ena hesiai tauna Mose danu e abidadama henia. ");
INSERT INTO meu_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Bena Mose bona Israel taudia na ina ane e abia, Iehova ena; eto, Lau na ane baina abia, Iehova ena, badina be ia na vada e kwalimu herea; Hosi bona e gui tauna davara ai vada e tahodia dobi. ");
INSERT INTO meu_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Iehova na egu goada bona egu ane, Ia ese vada e hamaurigu. Egu Dirava binai, lau ese baina heatolaia; Tamagu ena Dirava binai, lau ese baina imodaia. ");
INSERT INTO meu_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Iehova na tuari tauna; ia ladana be Iehova. ");
INSERT INTO meu_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Farao ena kariota bona ena tuari oreana na davara ai vada e tahodia dobi, Ena tuari lohiadia hereadia Davara Kakakakana ai vada e hamaloadia. ");
INSERT INTO meu_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Utu-utu ese vada e habubunidia; Dobu gabudia ai vada e mutu nadi na heto. ");
INSERT INTO meu_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Iehova e, oi imamu idibana siahuna na herea-dae; Iehova e, oi imamu idibana ese inai taudia vada e habuadia tari. ");
INSERT INTO meu_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Emu siahu herea-daena ese e inai henimumu taudia e hadarerediamu; Emu badu ese e aradia oremu, rei kakoro na heto. ");
INSERT INTO meu_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Hurehure o hahodi heni, bena e hahebou, E aru bou, e heabi isi; Dobu gabudia gadobada ai vada e auka. ");
INSERT INTO meu_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Inai tauna eto: Baina hahavadia, baina lasidia tao, Edia kohu baina hari, egu ura ediai baina kara; Egu dare baina lasi, lau imagu ese baine habuadia tari. ");
INSERT INTO meu_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Emu lai o siaia, bena davara ese e habubunidia; Idia na gadobada ai e mutu, auri metauna na heto. ");
INSERT INTO meu_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Iehova e, dirava loḡora bogaragidiai oi heḡereḡeremu be daika? Oi idaimu be daika? Helaḡa ai o herea daemu; Mai garidia ida e imodaimumu; hoa karadia o karamu. ");
INSERT INTO meu_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Oi imamu idibana o toia roro, bena tano ese e hadonodia. ");
INSERT INTO meu_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","O hamauria besena na emu hebogahisi ai vada o hakaua; Emu goada ai vada o hakaua ema bona gabu helaḡana. ");
INSERT INTO meu_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Bese idau-idau na e kamonaimu, bena e garimu; Filistia taudia na kudoudia e hetahamu; ");
INSERT INTO meu_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edom lohiadia na daradia e dokomu; Moab edia siahu taudia na gari ese e butudia taomu; Kanaan taudia iboudiai e veve ohomu. ");
INSERT INTO meu_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Gari bona kudou-hetaha ese e butudia tao; Oi imamu goadana dainai idia na nadi heḡereḡeredia ai ela, asie marere, Ela bona oi Iehova emu orea taudia vada e raka hanai, Oibe, oi ese o hoidia taudia e raka hanai. ");
INSERT INTO meu_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Oi ese ba hakaudia vareai, oi ahumu ai vada o halaoa ororona ai ba hadaidia, Oi Iehova emu noho gabuna ai vada o halaoa gabuna, Oi Iehova imamu ese vada e haginia dubuna. ");
INSERT INTO meu_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Iehova baine lohia hanahanai. ");
INSERT INTO meu_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Badina be Farao ena hosi bona ena kariota bona ena hosi-gui taudia na davara lalona amo ela; bena Iehova ese davara hurehuredia amo e habubunidia. A Israel taudia na tano kaukauna ai e raka, davara bogaragina ai. ");
INSERT INTO meu_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Bena Miriama, peroveta hahinena, Aaron taihuna, ese tareko e abia imana ai; bona hahine iboudiai edia tareko e abi, ia murina amo ela mai mavarudia ida. ");
INSERT INTO meu_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Bena Miriama ese tatau edia ane davana e halou henidia, ane e abia, eto, Ane avabia, Iehova ena, badina be ia na vada e kwalimu herea; Hosi bona e gui tauna davara ai vada e tahodia dobi. ");
INSERT INTO meu_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Bena Mose ese Israel taudia na Davara Kakakakana amo e hakaudia lao, tano ḡaḡaena ladana Suru amo e hakaudia hanai. Dina toi tano ḡaḡaena ai eha laolao, ranu asie davaria. ");
INSERT INTO meu_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Bena gabu ladana Mara ai e lasi, a una gabu ranuna asie inua diba, badina na idita; una dainai una gabu ladana e hatoa Mara. ");
INSERT INTO meu_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Bena laolao taudia ese Mose e maumauraia, eto, Ai na dahaka baia inua? ");
INSERT INTO meu_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Bena ia ese Iehova e noia; bena Iehova ese au ta e haheitalaia: ia ese una au ranu e urua diho, bena ranu gaiho vada e davaria. Una gabu ai Iehova ese taravatu bona haheḡani e henidia, e dibadia, ");
INSERT INTO meu_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","eto, Oi ese Iehova emu Dirava gadona boma hakala henia, bona ia vairanai boma kara maoromaoro, ena haheḡani boma badina bona ena taravatu boma kara, lau na hisihisi idau-idau amo basinama hahisimu, Aigupto taudia na hahisidia heḡereḡeredia; badina be lau na Iehova, oi ihamaurimu Diravana. ");
INSERT INTO meu_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Bena idia na Elim ai e kau; unuseni ai ranu guridia na gwauta-rua, bona pamu audia na hitu-ahui. Bena unu ranu badidiai e taruha. ");
INSERT INTO meu_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Israel hegogona idoinai na Elim amo ela, tano ḡaḡaena ladana Sin ai e kau, Elim Bona Sinai padadiai. Hua iharuana dinana ihagwauta-imana, Aigupto e rakatania murinai, idia na unuseni ai e kau. ");
INSERT INTO meu_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Bena Israel hegogona idoinai ese Mose bona Aaron e maumauraidia, tano ḡaḡaena ai. ");
INSERT INTO meu_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Israel taudia ese raruosi e gwau henidia, eto, Aigupto tanona ai Iehova ese bema alamai mase, vamu urodia badibadidiai a helaiva bona flaoa ianina ai bogamai e kunuva negana ai, bema namo; badina be umui raruosi ese ina tano ḡḡaena ai vada o hakaumai vareai, hitolo ese ina hegogo idoinai baine alamai mase totona. ");
INSERT INTO meu_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Bena Iehova ese Mose e hamaoroa, eto, A kamonai: lau na amui aniani guba amo baina hadihoa, medu na heto; dina ta ta ai taunimanima bae raka lasi, dina tamona ahuna bae haboua; unu amo baina dibadia, lauegu taravatu bae badina eiava lasi. ");
INSERT INTO meu_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","A dina ihatauratoina idia na dina rua ahudia bae heḡaeḡaelai. ");
INSERT INTO meu_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Bena Mose bona Aaron ese Israel taudia iboudiai e hereva henidia, eto, Hari adorahi ai vada ba diba Iehova ese Aigupto tanona amo vada e hakaumui lasi; ");
INSERT INTO meu_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","bona daba ai Iehova hairaina do ba itaia. Badina be emui maumau, Iehova o maumauraiamu, herevadia ia ese vada e kamonai. A ai be daidia, umui ese o maumauraimaimu? ");
INSERT INTO meu_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mose ma eto, Iehova ese vamu baine henimui adorahi ai, bona daba ai aniani baine henimui, bogamui ihakunudia: badina be emui maumau, Iehova o maumauraiamu, herevadia ia ese vada e kamonai. A ai be daidia? Emui maumau be dia ai asio maumauraimaimu; Iehova hari o maumauauriamu. ");
INSERT INTO meu_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Bena Mose ese Aaron e haduaia, eto, Israel hegogona idoinai ba hereva henidia, baoto “A raka kahira Iehova vairanai; badina be ia ese emui maumau herevadia vada e kamonai”. ");
INSERT INTO meu_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Bena AAron ese Israel hegogona idoinai e hereva henidia negana ai idia ese tano ḡaḡaena e haḡerea, bena Iehova diaridiarina na ori ai e itadia. ");
INSERT INTO meu_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Bena Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Israel taudia edia maumau herevadia vada na kamonai. Harihari ba hereva henidia, baoto “Adorahi ai vamu bavania, bona daba ai aniani bavania, bogamui ba hakunu; bena vada ba diba lau be Iehova, emui Dirava”. ");
INSERT INTO meu_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Adorahi ai, kibi momo e roho kau, taruha tanona e habubunia. Daba ai, hunu na taruhu tanona idoinai e miava, ");
INSERT INTO meu_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","bena hunu e kaukau negana ai ḡau maraḡidia kuborodia e hedinarai, itadia na medu hetarina na heto. ");
INSERT INTO meu_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Israel taudia ese una ḡau e itaia, bena e henanadai heheni, eto, Ia be dahaka? Badina be asi dibadia una ḡau. Bena Mose ese e hamaorodia, eto, Amui aniani benai, Iehova ese vada e henimui ḡauna. ");
INSERT INTO meu_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Iehova ena hahedua binai: Ba haboudia, ta ta ahuna ahuna ba habou, taunimanima ta nau auta; ruma biagudia ese edia ruma taudia adia unu bae habou toma. ");
INSERT INTO meu_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Bena Israel taudia na unu e kara toma. Haida e abi badabada, bona haida na sisidia mo e abi; ");
INSERT INTO meu_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","to e hahetohoa negana ai e abi badabada tauna na asi bahuna, bona e abi gadoi tauna na se dabu; ta ta ena hitolo ena hitolo heḡereḡeredia e abi. ");
INSERT INTO meu_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mose ese ma e hamaorodia, eto, Bahu basine mia rani. ");
INSERT INTO meu_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","To Mose erena asie kamonai; haida ese e atoa tabe ela bona daba ai ia na mai gaigai-gaigaina, bona bonana na dika herea. Una dainai Mose ese e badu henidia. ");
INSERT INTO meu_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Daba iboudiai e habou, ta ta ena hitolo ena hitolo heḡereḡeredia. A dina e dae ai e veve oho. ");
INSERT INTO meu_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Dina ihatauratoina, idia ese dina rua anianidia e habou, taunimanima ta ta nau rua rua e abi: bena hebou igunalaina taudia iboudiai ela, Mose e hamaorolaia. ");
INSERT INTO meu_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Bena ia ese e hamaorodia, eto, Iehova ena hereva binai: kerukeru na laḡa-ani dinana, Iehova ena dina helaḡa; be gabu ḡaudia na ba gabu, ba nadu ḡaudia na ba nadu, bona bahu baine mia rani. ");
INSERT INTO meu_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Bena bahu e atoa tabe ela bona daba ai se bodaga bona asi gaigai-gaigaina. ");
INSERT INTO meu_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mose ma eto, Hari dina ai bahu mo bavani, badina be hari na Iehova ena dina helaḡa; hari dina ai ḡau ta basio davaria tano ai. ");
INSERT INTO meu_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Dina tauratoi ba habou, a dina ihahituna ai basio davaria, badina be ia na dina helaḡa. ");
INSERT INTO meu_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Bena dina ihahituna ai taunimanima haida ela, bae habou eto; to ḡau ta asie davaria. ");
INSERT INTO meu_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Bena Iehova ese Mose e gwau henia, eto, Egu haheḡani bona egu taravatu ba dadaraidia ela bona edena nega ai? ");
INSERT INTO meu_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","A itaia, Iehova ese dina helaḡa vada e henimui, una dainai dina ihatauratoina ai ia ese dina rua anianidia e henimuimu. Dina ihahituna ai vada ba noho, ta ta ena kalaga ena kalaga ai: tau ta ena kalaga basine rakatania. ");
INSERT INTO meu_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Taunabunai, dina ihahituna ai taunimanima na laḡadia e aniva. ");
INSERT INTO meu_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israel taudia ese una aniani ladana e hatoa Mana: ia na nadinadi kurokurona na heto, a mamina na bada-ranuna amo e karamu dikeadia na heheto. ");
INSERT INTO meu_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Bena Mose eto, Iehova ena haheḡani binai: nau autamona mo bavatoa tabe, baine mia, uru gabedia ese tano ḡaḡaena ai na ubulaimui anianina, Aigupto tanona amo na hakaumui lasi negana ai, do bae itaia. ");
INSERT INTO meu_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Bena Mose ese Aaron e haduaia, eto, Hodu ta avabia, mana nau auta heḡereḡerena ba udaia, Iehova vairanai bavatoa, uru gabedia edia. ");
INSERT INTO meu_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Taunabunai, Aaron ese maua helaḡana vairanai e atoa, unuseni ai baine mia, Iehova ese Mose e haduaia heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Laḡani hari-ahui lalodiai Israel taudia ese mana e aniava, ela bona tano namona ai e kau; mana mo e aniava ela bona Kanaan tanona hetoana ai e kau. ");
INSERT INTO meu_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Hari nau be nau gwauta anidia na efa ta anina heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Israel hegogona idoinai ese tano ḡaḡaena ladana Sin e rakatania, e laolao metaira-metaira, Iehova ese e haduadia heḡereḡerena, ela bona Refidim ai e taruha. Unuseni ai idia na asi edia inuinu ranuna. ");
INSERT INTO meu_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Taunabunai idia ese Mose e gwau henia, eto, Inuinu ranuna a henimai. Mose eto, Dahaka dainai o gwau henigumu? Dahaka dainai Iehova o dibaḡaniamu? ");
INSERT INTO meu_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","A taunimanima na ranu e masedia, bena idia ese Mose e maumauraia, eto, Dahaka dainai Aigupto ai vada o hakaumai lasi, bena ai bona natumai bona emai seri ranu-mase amo bavalamai? ");
INSERT INTO meu_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Bena Mose ese Iehova e tai henia, eto, Ina orea taudia na ede baina karadia toma? Lalodia e hadaimu nadi amo bae hodogu mase e tomu. ");
INSERT INTO meu_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Bena Iehova ese Mose e haere henia, eto Taunimanima vairadiai baola, Israel tau-badadia ba hakaudia lao; emu itotohi, sinavai badana o botalaia ḡauna, danu bavabia kau, baola. ");
INSERT INTO meu_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","A kamonai: lau na oi vairamu ai baina gini, Horeb nadi hagahagana ai, bena nadi hagahagana ba botaia, bena ranu unu amo baine aru lasi, taunimanima edia inuinu ḡauna. Bena Mose unu e kara toma, Israel tau-badadia vairadiai. ");
INSERT INTO meu_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Bena una gabu ladana e hatoa Masa bona Meriba, badina be Israel taudia e ḡadeḡade, bona Iehova e dibaḡania, eto “Iehova na dekedekeda ai eiva lasi?” ");
INSERT INTO meu_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Una negana ai Amalek ema, Israel taudia e tuari henidia Refidim ai. ");
INSERT INTO meu_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Bena Mose ese Iosua e haduaia, eto, Eda orea tataudia haida bavabidia hidi, baola, Amalek ba tuari henia. Kerukeru lau na ororo dorina ai do baina gini, Dirava ena itotohi imagu ai baina abia. ");
INSERT INTO meu_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Bena Iosua ese Amalek e tuari henia, Mose ena hahedua heḡereḡerena. A Mose bona Aaron bona Huru na ororo dorina ela. ");
INSERT INTO meu_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Bena Mose imana e duduia isi negana ai israel taudia e kwalimu, a imana e hadihoa negana ai Amalek taudia e kwalimu. ");
INSERT INTO meu_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","A Mose imana e mase. Bena raruosi ese nadi ta e abia, ia murinai e atoa; bena ia e halai kau. Bena Aaron bona Huru ese ia imana ruaosi e dudui isi, ta idibana ai ma ta laurina ai; bena imana asie marere ela bona dina e diho. ");
INSERT INTO meu_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Unu amo Iosua ese Amalek mai ena orea taudia ida e hadareredia, dare matana amo. ");
INSERT INTO meu_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Bena Iehova ese Mose e hamaoroa, eto, Ina hereva na buka ta ai ba torea, taunimanima bae laloa tao helaoreana; bona Iosua ba hadibaia, lau na Amalek sivaraina ihelalolaina na baina haboioa, tanobada ai baine boio vaitani. ");
INSERT INTO meu_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Bena Mose ese ihaboulaina patana ta e larebaia, bona ladana e hatoa Iehova-nisi. ");
INSERT INTO meu_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ia eto, Iehova vada e gwau hamata: Iehova ese Amalek baine tuari henia ela uru iboudiai. ");
INSERT INTO meu_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Mose ravana, Ietero, Midian hahelaḡa tauna, ese Dirava ena kara Mose enai bona ena bese Israel ediai harina e kamonai, e kamonai danu Iehova ese Israel taudia Aigupto amo vada e hakaudia lasi. ");
INSERT INTO meu_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Bena Mose ese adavana e siaia oho murinai, Mose ravana, Ietero, ese Mose adavana, Sipora, e abia, ");
INSERT INTO meu_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","bona natuna raruosi danu e abidia. Ta ladana na Geresom; badina be tamana eto, Lau na idau tano ai na noho hedoamu. ");
INSERT INTO meu_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","A tau muritai ladana na Eliesere; badina ba tamnana eto, Tamagu ena Dirava ese e kahagu, Farao ena dare amo e hamaurigu. ");
INSERT INTO meu_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Bena Ietero, Mose ravana, ese Mose natuna raruosi bona adavana e hakaudia lao, Mose na tano ḡaḡaena ai e taruha gabunai ai, Dirava ena ororo ai. ");
INSERT INTO meu_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Bena ia ese Mose e hamaoroa, eto, Lau, oi ravamu, vada nama dekemu ai, adavamu bona natumu raruosi danu vada na hakaudia mai. ");
INSERT INTO meu_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Bena Mose e raka lasi, ravana vairanai e igo diho, e harahua. Raruosi e hahenamo heheni, bena kalaga ai e raka vareai, ");
INSERT INTO meu_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Bena Mose ese Iehova ena kara idoinai harina na ravana e hamaorolaia: Israel dainai Iehova ese Farao bona Aigupto taudia ede e karadia toma, bona Israel taudia dala ai be ede e hekwarahi toma, bona Iehova ese ede e hamauridia toma. ");
INSERT INTO meu_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Bena Ietero e moale, Iehova ese Israel taudia e hanamodiava, Aigupto taudia imadia amo e hamauridiava, dainai. ");
INSERT INTO meu_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ietero eto, Iehova aita imodaia, ia ese Aigupto taudia imadia amo bona Farao imana amo vada e hamaurimui, Israel taudia na Aigupto edia iḡui amo vada e ruhadia nege. ");
INSERT INTO meu_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Harihari lau dibagu Iehova ese dirava iboudiai e hereadiamu, badina be edia hekokoroku ai vada e hadareredia. ");
INSERT INTO meu_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Bena Mose ravana, Ietero, ese ihaboulaina karana e karaia, Dirava ena; lahi ese e ḡolea oho ḡauna amo Dirava e boua. Bena Aaron bona Israel tau-badadia iboudiai e hebou, Mose ravana ida e aniani hebou, Dirava vairanai. ");
INSERT INTO meu_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Daba ai, ose na hahemaoro gabuna ai e helai, taunimanima e hahemaoro henidia: bena taunimanima na Mose vairanai e gini, daba amo ela bona dina e diho. ");
INSERT INTO meu_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Mose ravana ese ena kara idoinai e itaia, taunimanima ede e karadia toma, bena ia ese e nanadaia, eto, Taunimanina ini o karadia tomamu anina be dahaka? Dahaka dainai oi sibomu o helaimu, a taunimanima iboudiai na vairamu ai gigini, daba ela bona adorahi. ");
INSERT INTO meu_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mose ese ravana e haere henia, eto, Badina be taunimanima na lau dekegu ai e maimu, Dirava ena ura bae diba totona; ");
INSERT INTO meu_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","bona e hepapahuahumu negadia ai danu, idia na dekegu ai e maimu, benia na hahemaoro henidiamu, bona Dirava ena taravatu bona ena haheḡani na hadibalaidiamu. ");
INSERT INTO meu_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Bena Mose ravana ese e hamaoroa, eto, Emu kara na dia namo; ");
INSERT INTO meu_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","oiemu goada bona ini taunimanima edia goada vada bae ore, badina be ina ḡaukara na metau herea; sibomu basio karaia diba. ");
INSERT INTO meu_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Egu hereva a kamonai; lau ese baina hahealo henimu bena Dirava ese baine hanamomu: oi na Dirava vairanai ba gini, taunimanima daidiai; edia daradara ba hedinarai ia vairanai. ");
INSERT INTO meu_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Oi ese danu ena taravatu bona ena haheḡani ba hadibadia, edia raka daladia bona edia ḡaukara ba hadibalaidia. ");
INSERT INTO meu_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ḡau tamona, ini taunimanima iboudiai edia amo tatau namodia hahidaosi bavabidia hidi, Dirava garina e garimu taudia, kara gageva-gageva e inai henimu taudia. Edia dagi ba henidia: daha daha lohiadia, sinahu sinahu lohiadia, imahui imahui lohiadia, bona gwata gwata lohiadia. ");
INSERT INTO meu_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Idia ese taunimanima bae hahemaoro henidia, dina iboudiai: hereva badadia be oi emu bae mailaidia, a hereva maraḡidia be sibodia bae haero. Unu amo oiemu ḡaukara taina baine haraḡa, badina be idia ese maduna kahana bae huaia. ");
INSERT INTO meu_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ini ba kara toma, bona Dirava ese ini baine haḡanimu toma, bena ba haheauka diba; ini taunimanima iboudiai danu edia kalaga bae lou heni mai mainodia ida. ");
INSERT INTO meu_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Taunabunai, Mose ese ravana ena hereva e kamonai, bona ena hahedua heḡereḡerena e karaia. ");
INSERT INTO meu_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Israel idoinai ai tatau namodia e abidia hidi, bese ikwaradia taudia ai e halaodia, daha daha lohiadia, sinahu sinahu lohiadia, imahui imahui lohiadia, bona gwauta gwauta lohiadia. ");
INSERT INTO meu_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Dina iboudiai idia ese taunimanima e hahemaoro henidia; hereva aukadia be Mose vairanai e gwaurai, a hereva maraḡidia na sibodia e haero. ");
INSERT INTO meu_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Bena Mose ese ravana e hatonia; bena ravana na ena tano korikori ela. ");
INSERT INTO meu_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Hua ihatoina ai, Israel na Aigupto amo e raka lasi murinai, dinana heḡereḡerena ai, idia na Sinai tano ḡaḡaena ai e kau. ");
INSERT INTO meu_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Refidim e rakatania negana ai, idia na Sinai tano ḡaḡaena ai e kau: bena tano ḡaḡaena ai e taruha, ororo badi-tanona ai. Unuseni ai Israel e taruha. ");
INSERT INTO meu_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Bena Mose e dara dae Dirava dekenai. Iehova gadona na ororo amo ema ia enai, eto, Iakob ena bese taudia ini ba hereva henidia toma, Israel taudia ini ba hamaorodia toma. Baoto ");
INSERT INTO meu_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Aigupto taudia ede na karadia toma vada o itaia, dibamui danu ede na abimui toma, ugava hanidia latadiai na heto, bena na hakaumui mai dekegu ai. ");
INSERT INTO meu_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Harihari lau eregu boma kamonai bona egu taravatu boma badinaia, umui na egu bese korokori ai boma lao, bese iboudiai bogaragidiai, badina be tanobada idoinai be lauegu. ");
INSERT INTO meu_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Egu hahelaḡa taudia ai baola; bese helaḡana ai baola”. Israel taudia unu ba hamaorodia toma. ");
INSERT INTO meu_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Bena Mose na ema, Israel tau-badadia e boiridia, Iehova ena haheḡani herevadia iboudiai e hamaorolaidia. ");
INSERT INTO meu_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Bena taunimanima iboudiai e haere hebou, eto, Iehova ena hereva heḡereḡerena ai baia karaia. Bena Mose ese taunimanima edia haere na Iehova e hamaorolaia. ");
INSERT INTO meu_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Bena Iehova ese Mose e hamaoroa, eto, A itaia, lau na ori badana ai baina vasi, bena baina hamaorolaimu herevadia na taunimanima bae kamonai; bena bae abidadama henimu ela hanaihanai. Bena Mose ese taunimanima edia hereva na Iehova e hamaorolaia. ");
INSERT INTO meu_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Bena Iehova ese Mose e hamaoroa, eto, Taunimanima dekedia baola; hari dina ai bona kerukeru ba hahelaḡadia; edia dabua danu bae huri; ");
INSERT INTO meu_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","dina ihatoina ai bae heḡaeḡae; badina be dina ihatoina ai Iehova baine diho Sinai ororona ai, taunimania iboudiai vairadiai. ");
INSERT INTO meu_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Hetoa danu bavabia, ororo baine ḡeḡea ahu, bena ba hamaorodia, baoto “Nahuamui ba toho, ororo ai basio dae kau, bona badibadina basiola; daika na ororo ai baine dae kau, vada bae alaia mase; ");
INSERT INTO meu_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","imadia amo basie daua toho, a nadi amo bae hodoa mase eiava diba amo bae tarakia mase; bema taunimanima eiava ubu-ubu ḡauna, to basine mauri. A kibi reḡena daudauna bae kamonai, bena ororo ai bae dara dae”. ");
INSERT INTO meu_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Taunabunai Mose na ororo amo e hekei, taunimanima dekediai; bena e hahelaḡadia, edia dabua danu e huri. ");
INSERT INTO meu_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Bena ia ese e haduadia, eto, Ba heḡaeḡae ela bona dina ihatoina; hahine ta basio raka henia kahi. ");
INSERT INTO meu_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Dina ihatoina ai, daba kahana ai, guba e rahua bona kevaru e kevaru isi, bona badana ta ororo dorina ai e kau. Bena kibi ta reḡena e kamonai, reḡena na bada herea: taruha taudia iboudiai na kudoudia e hetaha. ");
INSERT INTO meu_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Bena Mose ese taunimanima na edia taruha amo e hakaudia lasi, Dirava vairanai bae gini; idia na e raka ela bona ororo badi-tanona ai. ");
INSERT INTO meu_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Una negana ai Sinai ororona na kwalahu ese e ḡovaia ahu, badina be Iehova na lahi ai e diho, ororo latani. Taunabunai, kwalahuna e dae badabada, amu kwalahuna na heto; ororo tanona idoinai danu e laga. ");
INSERT INTO meu_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Kibi reḡena na e bada e laova; bena Mose na e hereva, bona Dirava ese guba rahurahu lalona amo e haere henia. ");
INSERT INTO meu_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Bena Iehova vada e diho, Sinai ororona dorina ai. Iehova ese danu Mose e boiria, baine dara dae ororo dorina ai, bena Mose na e dara dae. ");
INSERT INTO meu_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Bena Iehova ese Mose e haduaia, eto, A hekei, taunimanima ba hadibadia, Iehova itana totona bae didi dara bena hutuma bae mase na garina. ");
INSERT INTO meu_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hahelaḡa taudia ese danu Iehova do basie raka henia kahi; sibodia bae hahelaḡa guna, Iehova ese ediai baine hedinarai taku na garina. ");
INSERT INTO meu_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Bena Mose ese Iehova e haere henia, eto, Taunimanima na ororo ai basie dara dae diba, badina be oi ese o haduamai, hetoa baia abia, ororo baine ḡeḡea ahu, baia hahelaḡaia oto. ");
INSERT INTO meu_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Iehova ma eto, A hekei, bena Aaron ida ma ba dara dae; a hahelaḡa taudia bona taunimanima kavakavadia na basie didi dara Iehova enai, ia ese idia ediai baine hedinarai taku na garina. ");
INSERT INTO meu_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Taunabunai Mose e hekei taunimanima dekediai, unu hereva e hamaorolaidia. ");
INSERT INTO meu_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Dirava ini e hereva toma. ");
INSERT INTO meu_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Lau binai Iehova, emu Dirava: Aigupto taudia edia tano bona edia iḡui rumana amo na hakamu lasi. ?");
INSERT INTO meu_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Idau dirava ta basio abia lau vairagu ai. ");
INSERT INTO meu_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Laulau ta basio koroa; ḡau ta laulauna, guba ḡauna ta, eiava tanobada ḡauna ta, tanobada henuna ḡauna ta, basio karaia: ");
INSERT INTO meu_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","basio toma henia diho, bona isiaina basio lao heni. Badina be lau Iehova emu Dirava na vaḡeḡe Diravana: e inai henigumu taudia edia kara dika davadia na natudia bona tubudia latadiai baina kara ela bona uru ihatoina bona ihahanina, ");
INSERT INTO meu_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","a e ura henigumu bona egu taravatu e badinamu taudia baina bogadia hisi ela uru daha. ");
INSERT INTO meu_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Iehova emu Dirava ladana na basio hatoa kava hatoa kava; badina be Iehova ladana baine hatoa kava tauna na Iehova basineto ia na asi ena kerere. ");
INSERT INTO meu_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Dina Helaḡa ba laloa, ba hahelaḡaia. ");
INSERT INTO meu_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Dina tauratoi lalodiai emu ḡaukara idoinai ba karaia, ");
INSERT INTO meu_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","a dina ihahituna na dina helaḡana, Iehova emu Dirava ena. Una dina ai basio ḡaukara, oi eiava natumu maruanena eiava natumu hahinena eiava emu hesiai tauna eiava hesiai hahinena eiava emu boromakau, eiava idau tauna emu ruma ai e noho hedoamu. ");
INSERT INTO meu_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Badina be dina tauratoi lalodiai Iehovva ese guba bona tanobada bona davara bona lalodia ḡaudia iboudiai e karadia, bena dina ihahituna ai e laḡa ani. Badina bunai Iehova ese dina ihahituna vada e hanamoa bona e hahelaḡaia. ");
INSERT INTO meu_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Tamamu sinamu ba matauraidia; unu amo emu mauri dinadia bae hoho, Iehova emu Dirava ese e henimumu tanona ai. ");
INSERT INTO meu_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Basio ala-ala. ");
INSERT INTO meu_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Basio heuda hanai. ");
INSERT INTO meu_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Basio henao. ");
INSERT INTO meu_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Dekemu tauna basio habadelaia ko8ikoi. ");
INSERT INTO meu_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Dekemu tauna ena ruma basio ḡahusia, adavana danu basio ḡahusia, eiava ena hesiai tauna eiava ena hesiai hahinena eiava ena boromakau eiava ena doniki eiava ena kohu ta basio ḡahusi. ");
INSERT INTO meu_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Taunimanima iboudiai na guba rahurahu bona kevaru bona kibi reḡena bona ororo kwalahuna e kamonai bona e ita negana ai, idia na e gari, kudoudia danu e hataha. Idia na dauhai e gini, ");
INSERT INTO meu_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Mose e hereva henia, eto, Oi ba hereva henimai, bena baia kamonai henimu; a Dirava basine hereva henimai, baia mase na garina. ");
INSERT INTO meu_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Bena Mose ese e hamaorodia, eto, Basio gari; badina be Dirava vada ema, baine dibamui totona, bena ia imatauraina dainai umui na basio kara dika. ");
INSERT INTO meu_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Bena taunimanima na dounu dauhai e giniva, a Mose ese Dirava e noholaiava dagadagana e raka henia kahi. ");
INSERT INTO meu_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Bena Iehova ese Mose e hamaoroa, eto, Israel taudia na ini ba hamaorodia toma, baoto: Umui na vada o diba, lau gadogu na guba amo vada ema. ");
INSERT INTO meu_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Silver diravadia eiava gold diravadia na basio kara. ");
INSERT INTO meu_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ihaboulaina patana na tano amo ba larebaia, ia latanai emu boubou ḡaudia, heḡole-oho ḡaudia bona herohemaino ḡaudia, mamoe bona boromakau, ba henigu. lau ladagu ilalolaina vada na atoa gabudia iboudiai lau baina vasi bona baina henamomu. ");
INSERT INTO meu_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","A ihaboulaina patana na nadi amo boma larebaia, e utu nadidia amo basioma larebaia, badina be iutulaidia aurina ese bema hamirodia. ");
INSERT INTO meu_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ina danu: egu ihaboulaina patana na vadavada amo basio dae henia, ḡaḡaemu ai bae itamu na garina. ");
INSERT INTO meu_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Ba henidia taravatudia bini. ");
INSERT INTO meu_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Heberu tauna ta ba hoia, emu hesiai tauna ai ba halaoa, ia na laḡani tauratoi isiaimu baine lao heni, bena ihahituna ai ba kahua nege, asi davana. ");
INSERT INTO meu_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Sibona emu ai baine raka vareai, sibona ma baine raka lasi; a mai adavana ida bae raka vareai, mai adavana ida ma bae raka lasi. ");
INSERT INTO meu_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","A biaguna ese hahine ta baine henia, baine adavaia, bena natuna mamaruanedia eiava hahinedia na una hahine ena amo baine abidia, una hahine mai natuna ida na biaguna ena; hesiai tauna na sibona baine raka lasi. ");
INSERT INTO meu_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","A hesiai tauna baine hereva hedinarai, baineto “Baigugu bona adavagu bona adavagu bonanatugu na ura henidiamu; una dainai lau basina raka lasi”, ");
INSERT INTO meu_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","hari biaguna ese una tau na Dirava vairanai baine hakaua lasi, iduara ai eiava iduara auna ai taiana matuna baine daia uru; bena una tau ese biaguna isiaina baine lao heni ela bona mase. ");
INSERT INTO meu_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Tau ta ese natuna kekenina baine hoia, hesiai ai bainela, biaguna be basine kahua nege hesiai taudia mamaruanedia e kahudia negemu heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Bema biaguna ese baine adavaia bena basine ura henia, hahine varavarana ese ma bae davalaia bena bae abia lou. Basine hoia diba idau taudia ediai, badina be ia ese vada e dadaraia. ");
INSERT INTO meu_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","A bema natuna maruanena baine henia, ia ese ravana korikori ai baine halaoa. ");
INSERT INTO meu_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Bema hahine ta ma baine abia, ia ese hahine gunana ana aniani bona ena dabua ihenina basine hamaraḡi, bona basine hadihoa. ");
INSERT INTO meu_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","A ini ḡau ai baine hadabua, ia na baine kahua nege, asi davana. ");
INSERT INTO meu_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Ta ese tau ta baine alaia mase, ia danu bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","To bema iala-masena basine haeroa guna, a Dirava ese ia imana ai baine atoa, lau na gabu ta baina gwaurai henimu, ia baine heau mauri gabuna. ");
INSERT INTO meu_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","A tau ta ese iala-masena baine haeroa guna, bena baine alaia mase, egu ihaboulaina patana amo bavabia siri, vada baine mase. ");
INSERT INTO meu_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Tamana eiava sinana baine botaia tauna na bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Ta ese tau ta baine henaoa, bena baine hoia, eiava ia imana ai bae davaria, vada bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Tamana eiava sinana baine uduguiraia tauna na bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Taunimanima bae heatu, bena ese e heatu heniamu tauna na nadi amo baine hodoa, eiava imana amo baine botaia, a una tau na basine mase, baine hekure mo; ");
INSERT INTO meu_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","murinai ma baine tore isi, itotohi amo baine loaloa, hari e haberoa tauna na basine kerere; ḡau tamona, ena hekure dinadia davadia baine henia, bona ena muramura dalana baine lailaia ela bona baine namo vaitani. ");
INSERT INTO meu_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Tau ta ese ena hesiai tauna eiava hahinena baine dadabaia, bena imana ai baine mase, ena kerere davana bae henia. ");
INSERT INTO meu_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","A una hesiai tauna eiava hahinena do baine mauri, dina ta eiava dina rua, biaguna na basine kerere, badina be una hesiai rauna eiava hahinena na ena moni davana. ");
INSERT INTO meu_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Tatau edia heatu ai rogorogo hahinena ta bae haberoa, bena hahine baine mara dika, natuna baine dika to ia be baine namo, adavana ese e haberoa tauna baine habadelaia, bena hahemaoro taudia bae hereva, moni hida ia ese hahine adavana baine henia. ");
INSERT INTO meu_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","A hahine danu baine dika, mauri davana na mauri baine henia, ");
INSERT INTO meu_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","eiava mata davana na mara, eiava ise davana na ise, eiava ia davana na ima, eiava ae davana na ae, ");
INSERT INTO meu_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","eiava heara davana na heara, eiava bero davana na bero, eiava hedadaba davana na hedadaba. ");
INSERT INTO meu_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Tau ta ese ena hesiai tauna eiava ena hesiai hahinena matana baine haberoa, bena baine kepulu, ia na baine kahua nege, matana davana. ");
INSERT INTO meu_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Eiava uduna baine botaia bena isena ta baine heraḡa, ia na baine kahua nege, isena davana. ");
INSERT INTO meu_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Boromakau ta ese tau ta eiava hahine ta baine doaia mase, una boromakau na bae hodoa mase bona hidiona na basie ania; a biaguna be asi ena kerere. ");
INSERT INTO meu_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","To, bema una boromakau be nega haida unu vada e kara toma, nega gunadia ai, bona biaguna be mai dibana; bena biaguna basine koua kunuka-kunuka dainai tau ta eiava hahine ta ma baine doaia mase, boromakau na bae hodoa mase, bona biaguna danu bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","A dava bae gwauraia negana ai una dava baine henia, ena mauri ibodohilaina. ");
INSERT INTO meu_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Bema tau ta natuna maruanena eiava natuna hahinena na boromakau ese baine doaia mase, unu bae karaia toma. ");
INSERT INTO meu_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","A bema tau ta ena hesiai tauna eiava ena hesiai hahinena na boromakau ese baine doaia mase, boromakau biaguna ese una hesiai tauna eiava hahinena biaguna na davana baine henia, silver ena metau pound ta mai kahana heḡereḡerena, bona boromakau danu bae hodoa mase. ");
INSERT INTO meu_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Tau ta ese guri ta hekehona ai baine rakatania, eiava guri baine ḡeia, bena basine koua ahu, bena boromakau ta eiava doniki ta una guri lalonai baine moru dobi, ");
INSERT INTO meu_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","guri biaguna ese davana baine karaia; ia ese boromakau eiava doniki biaguna moni baine henia, a mase ḡauna na iena. ");
INSERT INTO meu_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Tau ta ena boromakau ese tau ta ena boromakau baine alaia mase, mauri ḡauna na bae hoia, bena raruosi ese davana bae haria; mase ḡauna danu bae haria. ");
INSERT INTO meu_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Bema biaguna mai dibana una boromakau na vaia unu vada e kara toma, to basine koua kunuka-kunuka, ia ese davana do baine karaia, boromakau ta boromakau ta davana, bona mase ḡauna be iena. ");
INSERT INTO meu_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Tau ta ese boromakau ta eiava mamoe ta baine henaoa, bena baine alaia eiava baine hoia, ia na davana do baine karaia: boromakau ta davana boromakau ima baine heni, eiava mamoe ta davana mamoe hani baine heni. Davana na unu baine karaia toma; a imana bema tuna, ia bema hoia, davana ihaḡuḡuruna. ");
INSERT INTO meu_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Henao taudia na ruma ihamakohina ai bae davaria, bena bae botaia mase, ia rarana na asi davana; ");
INSERT INTO meu_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","a bema daba e rere murinai bae botaia mase, rarana na mai davana. ");
INSERT INTO meu_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","E henaoa boromakauna eiava donikina eiava mamoena na henao tauna dekenai bae davaria, ia na davana baine henia nega harua. ");
INSERT INTO meu_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Tau ta ese boromakau baine hakaua vareai idau tauna ena uma ai eiava ena vine imeana ai, eiava baine kahua nege bena sibona baine vareai, ia na ena boromakau ese e hadika ḡaudia davadia na ena uma ḡaudia bona ena vine anidia hereadia amo do baine heni. ");
INSERT INTO meu_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Lahi ese ava ḡiniḡini amo baine hanai, uit e utua ḡauna eiava uit dounu uma ai e tubumu ḡauna baine araia ore, lahi e haraia tauna ese davadia do baine heni. ");
INSERT INTO meu_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Tau ta ese ena moni eiava ena kohu ia dekena tauna baine henia, baine naria totona, bena ta ese baine henaoa, henao tauna bae davaria negana ai, ia na davana baine heni nega harua. ");
INSERT INTO meu_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Bema henao tauna basie davaria, ruma biaguna na hahemaoro gabuna bainela. Dirava vairanai baine gwau hamata, ia na dekena tauna ena kohu se daua toho. ");
INSERT INTO meu_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Boromakau eiava doniki eiava mamoe eiava dabua bae heailai, bena tau ta baineto “Ḡauna binai egu”, kaha ruaosi na Dirava vairanai bae hahemaoro; bena hahemaoro ai baine kerere tauna ese davana nega harua ia dekena tauna baine henia. ");
INSERT INTO meu_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Tau ta ese ena doniki eiava ena boromakau eiava ena mamoe eiava ena mauri ḡauna ta ia dekena tauna baine henia, baine naria totona, bena baine mase, eiava baine bero, eiava ta ese baine lulua oho, a tau ta una kara basine itaia, ");
INSERT INTO meu_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ia be Iehova vairanai baine gwau hamata, ia ese dekena tauna ena ḡau se daua toho, bena ḡau biaguna ese ena gwau-hamata baine abia dae, ena ḡau davana basine abia. ");
INSERT INTO meu_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","A ta ese iena amo bema henaoa, ia ese davana na biaguna bema henia. ");
INSERT INTO meu_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","A uda boromadia ese bae koria, ia ese baine hahedinaraia, bena davana basine karaia. ");
INSERT INTO meu_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Tau ta ese dekena tauna ena ḡau ta baine abia torehai, bena baine bero eiava baine mase, biaguna murinai, ia ese davana baine henia. ");
INSERT INTO meu_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","A bema biaguna vairanai, ia ese davana basine henia. Bema hoi-asi ḡauna, davana be vada e henia, basine henia lou. ");
INSERT INTO meu_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Tau ta be hane-ulato rami-hebou, asi imaohenina, ida bae eno bou, ia ese baine adavaia, bona davana baine heni. ");
INSERT INTO meu_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","A tamana ese baine rua, ia ese davana doi baine heni, bema adavaia heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Babalau hahinena na basio bogaia hisi, vada baine mase. ");
INSERT INTO meu_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Mauri ḡauna idauna ta ida baine eno bou tauna sa bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Ihaboulaina karana baine karaia, dia Iehova ena to idau dirava ta ena, tauna na baine havahuraia vaitani. ");
INSERT INTO meu_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Noho-hedoa tauna basio hadikaia bona basio hahisia, badina be umui danu Aigupto tanona ai o noho hedoava. ");
INSERT INTO meu_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Vabu eiava ihareha basio hahisia; ");
INSERT INTO meu_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","boma hahisidia bena bema tai henigu, lau na momokani edia tai baina tai baina kamonai, ");
INSERT INTO meu_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","bena egu badu baine siahu, bena dare amo baina alamui mase: adavamui bae vabu bona natumui bae ihareha. ");
INSERT INTO meu_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Egu orea taudia ogoḡamidia haida emu ai bae abi torehai, basio kara henidia abi-torehai taudia na heheto, bona heato-kau monina na ediai basio tahua. ");
INSERT INTO meu_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Dekemu tauna ena dabua bavabia, ena abi-torehai toana, dina do basine diho ai ba henia lou; ");
INSERT INTO meu_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","badina be una na ena hetaru ḡauna bona ena hahedoki: ede baine mahuta toma? Ia ese baine tai henigu, bena baina hakala henia, badina be lau na mai egu hebogahisi. ");
INSERT INTO meu_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Dirava basio maumauraia, bona emu bese lohiana ta basio uduguiraia. ");
INSERT INTO meu_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Taboro negana ai, ihaboulaina karadia ai basio halahe: emu uma anidia bona emu vine anidia ba heni momo. Natumu roboana lau ba henigu; ");
INSERT INTO meu_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","emu boromakau bona emu mamoe danu unuheto. Dina hitu natuna roboana na sinana dekenai baine noho; dina ihataurahanina ai lau ba henigu. ");
INSERT INTO meu_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Umui na hehelaḡa: taunabunai uda boromadia ese e alaia mase ḡauna na basio ania; sisia ba henidia. ");
INSERT INTO meu_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Sivarai koikoi basio gwauraia. Kara dika taudia ida basio henega bou, hahebade koikoi igwaurina totona. ");
INSERT INTO meu_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Hutuma muridiai basio raka, kara dika ikarana totona, eiava hahemaoro ihagagevana totona. ");
INSERT INTO meu_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","A ogoḡami tauna danu basio durua hahemaoro ihagagevana ai. ");
INSERT INTO meu_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Inaimu ena boromakau eiava ena doniki baine heau boio bena oi ese ba davaria, ba hakaua lou lao ia dekenai. ");
INSERT INTO meu_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Inaimu ena doniki ba itaia, ena maduna matauna dainai e goru dihomu, ba durua; ena be iduruna so uramu, to ba durua. ");
INSERT INTO meu_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Ogoḡami tauna baine hahemaoro negana ai, hahemaoro basio hagagevaia ienai. ");
INSERT INTO meu_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Basio hahebade koikoi; asi ena kerere tauna eiava kara maoromaoro tauna basio alaia mase; badina be kara dika tauna basina bogaia hisi. ");
INSERT INTO meu_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Laloani monina basio abia; badina be lalo-ani monidia ese mata-kito taudia matadia e hakepuludiamu, bona kara maoromaoro taudia edia kara e hagagevadiamu. ");
INSERT INTO meu_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Noho-hedoa tauna basio hahisia. Noho-hedoa mamina vada o abia, badina be umui danu Aigupto tanona ai o noho hedoava. ");
INSERT INTO meu_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Laḡani tauratoi uma ḡaudia ba hado emu tano ai, bona anidia ba habou; ");
INSERT INTO meu_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","a laḡani ihahituna ai ia na baine vahu, ogoḡami taudia ese anina bae abia. Orena na uda boromadia ese bae ania. Emu vine imeana bona emu olive imeana danu unu ba karadia toma. ");
INSERT INTO meu_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Dina tauratoi ba ḡaukara. Dina ihahituna ai ba laḡa ani; emu boromakau bona emu doniki danu bae laḡa ani; emu hesiai hahinena natuna bona noho-hedoa tauna ese danu goada matamata bae abia. ");
INSERT INTO meu_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Egu hereva iboudiai ba lalodia tao; dirava idaudia basio herevalaidia, bona ladadia basio hato. ");
INSERT INTO meu_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Laḡani ta lalonai aria toi ba kara, egu. ");
INSERT INTO meu_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Asie-hatubua-flaoana ariana ba karaia: dina hitu asie hatubua flaoana bavania, gunaguna na haduamu heḡereḡerena, nega korikorina ai, hua ladana Abib lalonai, badina be una hua lalonai Aigupto amo o raka lasi. Asi tauna ta imana kavakava baine hedinarai lau vairagu ai. ");
INSERT INTO meu_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Taboro ariana danu bba karaia, emu uma anidia ba utu matama negana ai. Lailai huana lalonai roge ariana danu ba karaia, emu uma anidia idoidiai emu roge ai ba habou vaitani negana ai. ");
INSERT INTO meu_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Laḡani ta lalonai emu mamaruane iboudiai na nega toi Ḡaubada Iehova vairanai bae hedinarai. ");
INSERT INTO meu_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Egu ihaboulaina rarana na e hatubua flaoana ida basio atodia hebou; egu aria digarana na basine mia rani. ");
INSERT INTO meu_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Emu uma anidia roboadia namo-hereadia na Iehova emu Dirava ena dubu ai ba rakalaia vareai. Nani natuna hidiona na sinana ratana amo basio nadua. ");
INSERT INTO meu_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","A itaia, aneru ta na siaiamu, oi vairamu ai bainela, dala ai baine simamu, bona vada na abia heḡaḡae gabuna ai baine hakaumu vareai. ");
INSERT INTO meu_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ba hakala henia, erena ba kamonai; basio gwau edeede henia; badina be emu kara rea basine laloa nege, lau ladagu na ia lalonai dainai. ");
INSERT INTO meu_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","A ia erena ba kamonai bona lauegu hereva iboudiai ba badinadia; bena oi inaimu be lau inaigu ai baina halaodia, bona oi bae tuari henimu taudia na lau danu baina tuari henidia. ");
INSERT INTO meu_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Egu aneru na oi vairamu ai bainela, Amoro taudia bona Hiti taudia bona Perisi taudia bona Kanaan taudia bona Hivi taudia bona Iebusu taudia edia tano ai baine hakaumu vareai, bena lau ese baina habuadia tari. ");
INSERT INTO meu_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Una negana ai edia dirava basio toma henidia diho bona isiaidia basio lao heni, bona edia kara danu basio tohotohodia; ba hadareredia vaitani, bona edia au-tubua ba ḡiḡidia rohoroho. ");
INSERT INTO meu_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Iehova emui Dirava mo isiaina ba lao heni; bena emu flaoa bona emu ranu lau ese baina hanamodia, bona emu gorere baina abia oho; ");
INSERT INTO meu_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","emu mauri ḡauna ta basine mara dika bona ta basine gabani emu tano ai; emu mauri dinadia baina haḡuḡurudia. ");
INSERT INTO meu_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Egu hahegari na oi vairamu ai baina siaia, ediai ba kau taudia lalodia baina hadaradaradia, bena inaimu iboudiai na bae heau muri. ");
INSERT INTO meu_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nanigo danu baina siaidia vairamu ai, idia ese Hivi taudia bona Kanaan taudia bona Hiti taudia oi vairamu ai baina luludia lasi. ");
INSERT INTO meu_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Laḡani tamona lalonai basina luludia lasi, edia tano baine vahu na garina, bona uda boromadia bae hutuma bena bae hadikamu na garina. ");
INSERT INTO meu_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Metaira-metaira baina luludia lasi, ela bona umui na ba hutuma, bena tano bavabia emui. ");
INSERT INTO meu_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Emu tano hetoadia baina kara, Davara Kakakakana amo ela bona Filistia taudia edia davara, bona tano ḡaḡaena amo ela bona Eufrate sinavaina: badina be umu tano taudia oi imamu ai baina atodia, oi vairamu ai do ba luludia lasi. ");
INSERT INTO meu_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Idia ida basio herohemaino, bona edia dirava ida basio herohemaino. ");
INSERT INTO meu_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Emu tano ai basie noho, bae hahekwakwanaimu bena vairagu ai ba kara dika na garina; badina be edia dirava boma toma henidia diho, oi na boma hekwakwanai. ");
INSERT INTO meu_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Iehova ese Mose ma e hamaoroa, eto, Iehova enai ba dara dae, oi bona Aaron bona Nadab bona Abihu bona Israel tau-badadia hitu-ahui: dauha amo ba toma henigu diho. ");
INSERT INTO meu_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mose sibona ese Iehova baine raka henia kahi; bamona be basie raka kahira, bona edia orea taudia danu basie dara dae. ");
INSERT INTO meu_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Bena Mose ela, Iehova ena hereva iboudiai bona ena taravatu iboudiai Israel taudia e hamaorolaidia. Bena Israel taudia iboudiai e haere hebou, eto, Iehova ena hereva iboudiai baia badinadia. ");
INSERT INTO meu_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mose ese Iehova ena hereva iboudiai e tore vaitanil; bena daba vaburana ai e tore isi, ororo badi-tanona ai ihaboulaina patana ta e larebaia, bona au=tubua gwauta-rua e holo, Israel idududia gwauta-ruaosi edia. ");
INSERT INTO meu_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Bena ia ese Israel eregabedia haida e siaidia, boromakau mamaruanedia e laohai, boubou ḡaudia ai e halaodia: haida lahi ese e ḡole oho ḡaudia, ma haida herohemano ḡaudia, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Bena Mose ese rara kahana na dihu ai e haboua, a rara kahana na ihaboulaina patana ai e seia. ");
INSERT INTO meu_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Bena ia ese taravatu bukana e abia, Israel taudiavairadiai e duahia hedinarai. Bena idia eto, Iehova ena hereva iboudiai baia kamonai henidia, bona ena taravatu baia badinadia. ");
INSERT INTO meu_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Bena Mose ese rara e abia, Israel taudia e nevarilaidia, eto, Ina na herohemaino rarana, Iehova na umui ida vada e herohemaino ini hereva ai. ");
INSERT INTO meu_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Bena Mose bona Aaron bona Nadab bona Abihu, Israel tau-badadia hitu-ahuiosi ida, e dara dae, ");
INSERT INTO meu_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Israel edia Dirava e itaia, aena na sapairo nadina ai e hadai, e negari-negari, guba na heto. ");
INSERT INTO meu_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ia imana na Israeltau-badadia latadiai se ato kau; idia ese Dirava e itaia, bena e aniani, ranu e inua danu. ");
INSERT INTO meu_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Iehova ese Mose e hamaoroa, eto, Lau dekegu ai ba dara dae, ororo ai ba narigu; lau be hro-nadidia palakadia baina henimu, ini nadi ai taravatu bona haheḡani vada na tore, taunimanima ihadibaladia. ");
INSERT INTO meu_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Taunabunai, Mose na ena hesiai tauna Iosua ida e tore isi; bena Mose na Dirava ena ororo ai e dara dae. ");
INSERT INTO meu_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ia ese Israel tau-badidia e haduadia, eto, Iniseni ai ba noho, ela bona ai baia lou mai dekemui ai. hari Aaron bona Huru na dekemui ai nonoho; tau ta hahemaoro baine ura negana ai, ia na idia raruosi dekedia bainela. ");
INSERT INTO meu_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mose na ororo ai e dara e dara dae, bena ori ese ororo e ḡovaia ahu. ");
INSERT INTO meu_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Bena Iehova hairaina na ororo dorina ai e kau, bona ori ese ororo e ḡovaia ahu ela bona dina tauratoi e ore. Dina ihahituna ai Iehova ese Mose ladana e hatoa, ori bogaragina amo. ");
INSERT INTO meu_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Iehova hairaina ita-itana na lahi hururu-hururuna na heto ororo dorina ai: Israel taudia iboudiai ese e itaia. ");
INSERT INTO meu_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Bena Mose na e dara dae ori lalonai, dina hari-ahui boi hari-ahui unuseni ai e nohova. ");
INSERT INTO meu_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Israel taudia ba hamaorodia, edia herahia ḡaudia bae henigu; lalodia e namomu taudia iboudiai edia herahia ḡaudia bavabi dae, egu. ");
INSERT INTO meu_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Bavabi dae ḡaudia bini: gold bona silver bona auri labora-labora; ");
INSERT INTO meu_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","dabua vaiuridia bona mia-kakadia bona kakakakadia bona kurokurodia; nani huidia; ");
INSERT INTO meu_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","mamoe kopidia, e hakakakakadia ḡaudia, bona nani kopidia; kela audia; ");
INSERT INTO meu_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","lamepa diaranuna bona muramura mai bonadia bona e gabu muramuradia; ");
INSERT INTO meu_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","onuku nadidia bona hahelaḡa taudia edia dabua ihaheralaidia bona edia vaina ihaheralaidia nadidia. ");
INSERT INTO meu_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Gabu helaḡana danu bae karaia egu, bogaragidiai baina noho helaoreana. ");
INSERT INTO meu_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Dubu auta danu ba karaia; dubu bona dubu lalona ḡaudia iboudiai be lau ese baina hadibalaimu heḡereḡerena ai ba kara. ");
INSERT INTO meu_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Maua ta danu bae karaia, kela reireidia amo; latana na kiubit rua mai kahana, lababana bona harana ena lata na kiubit ta mai kahana. ");
INSERT INTO meu_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Lalona kahana gold amo ba lahasia, bona murina kahana gold amo ba ḡovaia, bona gold amo ba haheraia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ring hani na gold amo ba kara, maua daigunina haniosi ai ba koko kau, kahana ai rua kahana ai rua. ");
INSERT INTO meu_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Maduna danu ba kara, kela audia amo, bena gold amo ba ḡovadia. ");
INSERT INTO meu_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ini maduna na ring amo ba toi hanai, maua kahana kahana ai, ihualaina ḡaudia ai baela. ");
INSERT INTO meu_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","hari maduna na ring lalodiai do bae mia, basie veridia lasi. ");
INSERT INTO meu_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Bena taravatu nadidia, baina henimu ḡauna, do ba udaia maua lalonai. ");
INSERT INTO meu_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Ikaruhi ta danu gold namo-hereana amo ba karaia, ena lata kiubit rua mai kahana, ena lababa kiubit ta mai kahana. ");
INSERT INTO meu_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ikaruhi duduna duduna kerubi rua ba koro, ");
INSERT INTO meu_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","duduna ta kerubi ta ma duduna ta kerubi ta; ikaruhi bona kerubi raruosi na gold siri tamona amo ba kara. ");
INSERT INTO meu_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Hari kerubi na hanidia amo ikaruhi bae hakerukerua; idia bae hevaira heheni, bona ikaruhi bae vaira henia. ");
INSERT INTO meu_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Hari ikaruhi na maua latanai bavatoa kau, hebogahisi teronona ai bainela; bona taravatu nadidia, do baina henimu ḡauna, na maua lalonai ba udaia. ");
INSERT INTO meu_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Unuseni ai baita hedavari: ikaruhi daenai, taravatu mauana latanai e miamu kerubidia raruosi padadia amo, lau ese baina hereva henimu; haheḡani iboudiai, Israel taudia ba henidia ḡaudia, na baina hadibalaimu. ");
INSERT INTO meu_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Pata ta danu, kela audia amo ba karaia, latana na kiubit rua, lababana na kiubit ta, harana ena lata na kiubit ta mai kahana. ");
INSERT INTO meu_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Gold amo ba ḡovaia, bona ba haheraia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Digina danu ba karaia, labalaba na tau ta imana palapalana heḡereḡerena, ia danu gold namo-hereana amo ba haheraia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ring hani danu gold amo ba kara, pata aena haniosi ai ba koko kau. ");
INSERT INTO meu_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Hari ring be pata digina henunai ba koko kau, maduna audia bae hetoi hanai. ");
INSERT INTO meu_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Maduna danu kela audia amo ba kara, bona gold amo ba ḡovadia, pata ihualaina. ");
INSERT INTO meu_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Pata ḡaudia danu, mereki bona nau bona bio bona kehere, iboudiai na gold namo-hereana amo ba kara. ");
INSERT INTO meu_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Nega iboudiai flaoa helaḡana na una pata latanai baine hedabara lau vairagu ai. ");
INSERT INTO meu_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Lamepa patana ta danu ba karaia, gold namo-hereana amo. Aena bona duna na gold amo ba koro: aena bona duna bona kehere bona heraherana, bure bona huahua, iboudiai na gold siri tamona amo ba koro. ");
INSERT INTO meu_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Rigina bae tauratoi, kahana toi kahana toi. ");
INSERT INTO meu_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Rigi ta ena kehere bae toi, itadia sakada huahuadia na heheto, ta ta mai buredia bona mai huahuadia, rigi iboudiai. ");
INSERT INTO meu_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Duna ai danu kehere bae hani, sakada huahuadia na heheto, ta ta mai buredia bona mai huahuadia. ");
INSERT INTO meu_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Rigi rua rua amo danu buredia ta ta ba koro: rigi rua bure ta, rigi rua bure ta, rigi bure ta, rigidia henudia kahadia ai. ");
INSERT INTO meu_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Hari rigi bona bure na gold namo-hereana sirina tamona amo ba koro. ");
INSERT INTO meu_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Bena lamepa hitu ba kara, gabudia ai bavatodia, edia diari na pata vairana kahana bae hadiaria. ");
INSERT INTO meu_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ihaḡoevadia ḡaudia bona momorudia iudadia merekidia iboudiai na gold namo-hereana amo ba kara. ");
INSERT INTO meu_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Hari lamepa patana, mai kohuna idoinai, ikaralaina gold-na ena metau be talent ta. ");
INSERT INTO meu_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ba heita, ini ḡau ba kara hari ina ororo ai emu ai vada eme hedinarai heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Dubu auta ba karaia egu: haba be dabua aukadia bona namodia gwauta amo ba kara, vaiuridia bona mia-kakadia bona kakakakadia; ihaheraladia be dibana tauna ese kerubi laulaudia baine turi. ");
INSERT INTO meu_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Dabua ta ena lata be kiubit ruahui taurahani, lababana be kiubit bhani; iboudiai edia lata bae heḡereḡere, edia lababa danu bae heḡereḡere. ");
INSERT INTO meu_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Dabua ima ba siriudia, ma ima ba siriudia. ");
INSERT INTO meu_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Bena imaosi ta isena ai, kunipa varo vaiurina amo ba kara; ma imaosi ta isena ai danu unu ba kara toma. ");
INSERT INTO meu_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Dabua ta ai kunipa imahui ba kara, ma dabua ta ai imahui: hari kunipa bae hevaira heheni. ");
INSERT INTO meu_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Bena hakapu-tao ḡaudia imahui gold amo ba kara, dabua isedia ruaosi na unu hakapu-tao ḡaudia amo be hakapudia tao hesiriu, unu amo dubu tamona ai bainela. ");
INSERT INTO meu_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Bena dabua haida nani huidia amo ba kara, kalaga ai baela, dubu ikoulaina; unu dabua iboudiai bae gwauta-ta. ");
INSERT INTO meu_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Dabua ta ta edia lata na kiubit toi-ahui, lababadia na kiubit hani; iboudiai edia bae heḡereḡere, edia lababa danu bae heḡereḡere. ");
INSERT INTO meu_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ini dabua ima ba siriudia, ma tauratoi ba siriudia: ihatauratoina na iha-imana baine ha-ere-ruaia, kalaga vairanai. ");
INSERT INTO meu_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Bena imaosi ta isena ai kunipa imahui ba kara, ma tauratoiosi ta isena ai kunipa imaosi ma ba kara. ");
INSERT INTO meu_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Bena hakapu-tao ḡaudia imahui auri labora-labora amo ba kara, dabua isedia ruaosi na unu hakapu-tao ḡaudia amo ba hakapudia tao hesiriu, kalaga tamona ai bainela. ");
INSERT INTO meu_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Hari e haruaia ḡauna na dubu murina kahana ai baine hetau dobi. ");
INSERT INTO meu_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Hari kalaga dabuana ena lata na dubu harana ena lata baine hereaia, kahana kiubit ta, ma kahana kiubit ta, unu bae hetau dobi toma, dubu ikoulaina. ");
INSERT INTO meu_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Kalaga guhina danu ba karaia, mamoe kopidia, e hakakakakadia ḡaudia, amo; ma guhi ta danu nani kopidia amo ba karaia, ia latanai bavatoa kau. ");
INSERT INTO meu_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Dubu habana na kela audia amo kaha ta ta ba kara. ");
INSERT INTO meu_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kaha ta ena lata be kiubit gwauta, bona ena lababa be kiubit ta mai kahana. ");
INSERT INTO meu_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Hari kaha ta ta be ikoko rua rua amo bae koko hesiriu; dubu habana kahadia iboudiai kaha rua rua amo unu bae koko hesiriu toma. ");
INSERT INTO meu_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Hari kaha iboudiai na ini ba haginidia toma: diho kahana ai kaha ruahui; ");
INSERT INTO meu_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","hahelai-kau ḡaudia hari-ahui silver amo ba kara, kaha ruahuiosi henudiai bae mia, hahelai-kau ḡaudia kaha ta ta henudiai bae heato, ikoko rua rua amo ba kokodia tao. ");
INSERT INTO meu_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ma dubu kahana ta, mirigini kahana ai, kaha ruahui ba haginidia, ");
INSERT INTO meu_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","mai silver hahelai-kau ḡaudia hari-ahui, kaha ta ta henudiai hahelai-kau ḡaudia rua rua amo ba kokodia. ");
INSERT INTO meu_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Dubu duduna, lahara kahana ai, kaha tauratoi ba haginidia, ");
INSERT INTO meu_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","bona daiguni ruaosi danu kaha ta ta. ? ");
INSERT INTO meu_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Hari daiguni ḡaudia na henu ai bae kokodia hesiriu, a atai ai idia na ring amo bae hesiriu. Ruaosi na unu bae heto; idia na daiguni ḡaudia ruaosi ai baela. ");
INSERT INTO meu_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Taunabunai, kaha bae taurahani bona silver hahelai-kau ḡaudia bae gwauta-tauratoi, kaha ta ta henudiai hahelai=kau ḡaudia rua rua. ");
INSERT INTO meu_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Raroraro danu kela audia amo ba kara, au-ima dubu habana kahana ai, ");
INSERT INTO meu_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ma au-ima kahana ai, ma au-ima dubu duduna ai, lahara kahana ai. ");
INSERT INTO meu_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Bogaragi rarorarona na kaha iboudiai baine hahesiriudia, duduna ela bona duduna. ");
INSERT INTO meu_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Hari kaha be gold amo ba ḡovadia. Raroraro idogo-taodia ring-dia na gold amo ba kara, bona raroraro na gold amo ba ḡovadia. ");
INSERT INTO meu_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Dubu na ba haginia, hari ina ororo ai emu ai vada eme hedinarai heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Bena seseahu na dabua aukana bona namona amo ba karaia, dabua vaiurina bona mia-kakana bona kakakakana; ihaheralaina be dibana tauna ese kerubi laulaudia baine turi. ");
INSERT INTO meu_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Gold igaudia amo ba taua dae; ena ihua-ihua bae hani, kela audia amo ba kara bona gold amo ba ḡovadia, bena silver hahelai-kau ḡaudia ai ba haginidia. Unuhetomana seseahu ba taua dae. ");
INSERT INTO meu_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","hari seseahu na hakapu-tao ḡaudia amo ba taua dae; bena taravatu mauana na bae huaia vareai: seseahu na helaḡa gabuna bona helaḡa-herea gabuna baine seses ahu. ");
INSERT INTO meu_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Hari maua danu ikaruhi amo ba karuhia, helaḡa-herea gabuna ai. ");
INSERT INTO meu_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Pata na seseahu murimurinai bavatoa; lamepa patana be dubu diho kahana ai bavatoa, pata baine vaira henia, a pata be mirigini kahana ai baine gini. ");
INSERT INTO meu_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Kalaga iduarana seseahuna danu dabua aukana bona namona amo ba karaia, dabua vaiurina bona mia-kakana bona kakakakana, bona ihaheralaina danu bae turi. ");
INSERT INTO meu_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Seseahu ena ihua-ihua bae ima; kela audia amo ba kara, bona gold amo ba ḡovadia. Edia igau na gold amo ba kara, a hahelai-kau ḡaudia imaosi na auri labora-labora amo ba kara. ");
INSERT INTO meu_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Ihaboulaina patana ba karaia, kela audia amo; latana na kiubit ima, lababana kiubit ima, harana ena lata kiubit toi, unu ba karaia toma. ");
INSERT INTO meu_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Doa hani ba koro, pata daigunina haniosi ai; hari doa na pata ida au tamona amo ba kara. Kopina idoinai na auri labora-labora amo ba ḡovaia. ");
INSERT INTO meu_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Kahuna iudalaina urodia bona ikado-laina gagana bona dihu bona kahi bona rahurahu na iboudiai auri labora-labora amo ba kara. ");
INSERT INTO meu_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Pata digina na auri labora-labora amo ba ha-aukaia heḡeḡe, bona rina hani auri labora-labora amo ba kara, hari iha-aukana auri labora-laborana ena daiguni haniosi ai. ");
INSERT INTO meu_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Hari iha-aukana auri labora-laborana na pata baine ḡeḡea ahu, bona digina harana kahana ai baine diho. ");
INSERT INTO meu_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Maduna audia danu ba kara, ihaboulaina patana ena; kela audia amo ba kara, bona auri labora-labora amo ba ḡovadia. ");
INSERT INTO meu_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Hari maduna na ring amo ba toidia hanai, ihaboulaina patana ohena kahana kahana ai, ihualaina ḡaudia. ");
INSERT INTO meu_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ihaboulaina patana na maua na heto ba karaia, harana na reirei amo baine hekou. Vada ba karaia hari ina ororo ai emu ai vada eme hedinarai heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Dubu maḡuna danu ba karaia. Diho kahana ai maḡu latana na kiubit sinahu-ta; itautau dabuadia aukadia na ");
INSERT INTO meu_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","du ruahui amo bae hetau dae, du badidia ihahelai-kaudia ḡaudia danu bae ruahui; hari du bona ihahelai-kaudia ḡaudia na auri labora-labora amo ba kara. A edia igau bona edia hakapu-tao ḡaudia na silver amo ba kara. ");
INSERT INTO meu_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Mirigini kahana ai danu maḡu latana na kiubit sinahu-ta; itautau dabuadia na du ruahui amo bae hetau dae, du badidia ihahelai-kaudia ḡaudia danu bae ruahui. Du bona ihahelai-kaudia ḡaudia na auri labora-labora amo ba kara, a edia igau bona edia hakapu-tao ḡaudia na silver amo ba kara. ");
INSERT INTO meu_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Lahara kahana ai, maḡu lababana na kiubit imahui; du bae gwauta, badidia ihahelai-kaudia ḡaudia danu bae gwauta. ");
INSERT INTO meu_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Mairiveina kahana ai, dubu vairanai, lababana na kiubit imahui. ");
INSERT INTO meu_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Ikoukou kahana ai itatau dabuadia na kiubit gwauta-ima, mai du toi bona du badidia ihahelai-kaudia ḡaudia toi; ");
INSERT INTO meu_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ma ikoukou kahana ai danu itautau dabuadia na kiubit gwauta-ima, mai du toi bona du badidia ihahelai-kaudia ḡaudia toi. ");
INSERT INTO meu_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ikoukou dabuana na kiubit ruahui: dabua na vaiuri bona mia-kaka bona kakakaka; varo aukana amo bae turi, bona heraherana danu bae turi. Ia duna bae hani, bona du badidia ihahelai-kaudia ḡaudia bae hani. ");
INSERT INTO meu_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Maḡu duna iboudiai na silver amo ba haheralaidia, bona edia igau na silver amo ba kara. A du badidia ihahelai-kaudia ḡaudia be auri labora-labora amo ba kara. ");
INSERT INTO meu_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Maḡu ena be kiubit sinahu-tu, lababana be kiubit imahui, harana ena lata be kiubit ima. Itautau dabuadia be dabua aukadia. Du badidia ihahelai-kaudia ḡaudia be auri labora-labora. ");
INSERT INTO meu_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Dubu kohuna idoinai na auri labora-labora amo bae kara; dubu ikokodia bona maḡu ikokodia danu iboudiai na auri labora-labora ikokodia mo. ");
INSERT INTO meu_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Israel taudia ba haḡanidia, olive dehorona ḡoevaḡoevana bae mailaia, lamepa diaranuna ai bainela; bena lamepa baine ara hanaihanai. ");
INSERT INTO meu_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aaron mai natuna ida bae naria boi naria rani Iehova vairanai, hebou kalagana lalonai, maua helaḡana seseahuna murimurinai. Ina haheḡani na Israel taudia ese bae badinaia hanaihanai, uru iboudiai lalodiai. ");
INSERT INTO meu_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Kakamu Aaron, mai natuna mamaruanedia ida, israel taudia bogaragidia amo ba hakaudia siri, egu hahelaḡa taudia ai baela helaoreana. Aaron mai natuna hahaniosi, Nadab bona Abihu bona Eleasara bona Itamara, unu bavabidia toma. ");
INSERT INTO meu_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Kakamu Aaron ena dabua helaḡadia danu ba kara, mai toana bona mai hairaina ida baine noho helaoreana. ");
INSERT INTO meu_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Mai dibadia taudia, lau ese aonega vada name henidia taudia, ba haḡanidia, dabua bae kara Aaron ena; bena ia baine helaḡa, lauegu hahela=aga tauna ai bainela. ");
INSERT INTO meu_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Bae kara ḡaudia bini: keme ai e ha-inuamu vainana; hahedoki, muri hahedokina; hahedoki badana, kwara iḡe4ḡelaina dabuana; gaba ḡauna. Dabua helaḡadia bini bae kara, kakamu Aaron ena bona natuna mamaruanedia edia, egu hahelaḡa taudia ai baela helaoreana. ");
INSERT INTO meu_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Idia na gold bae abia, bona dabua idau-idau, vaiuridia bona mia-kakadia bona kakakakadia bona kurokurodia. ");
INSERT INTO meu_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Bena hahedoki helaḡana bae karaia namonamo, hari gold bona dabua idau-idau, vaiuri bona mia-kaka bona kakakaka bona kurokuro, bae karalaia. ? ");
INSERT INTO meu_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Paḡa ḡaudia rua ese hahedoki vairana kahana bona murina kahana bae siriudia. ");
INSERT INTO meu_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Gaba ḡauna danu ḡau heḡereḡeredia ai bae karaia, dabua idau-idau, vairuri bona mia-kaka bona kakakaka bona kurokuro, bae karalaia. ");
INSERT INTO meu_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Onuku nadidia rua bavabi, latadiai Israel natuna ladadia ba tore, ");
INSERT INTO meu_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","lada tauratoi nadi ta ai ma tauratoi nadi ta ai, murina murina amo ba tore edia vara heḡereḡeredia. ");
INSERT INTO meu_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Nadi hururuhururudia iḡaukaralaidia tauna ese e ḡasidiamu heḡereḡerena, Israel natuna ladadia unu bas tore toma, unu nadi ruaosi ai. Bena isedia na gold e moḡe ḡaudia amo ba koudia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Bena unu nadi ruaosi be hari hahedoki ena paḡa ḡaudia ai bavatodia kau, helalo-tao ḡaudia ai baela, Israel natuna edia; Aaron ese ladadia na paḡana ruaosi ai baine hua, Iehova vairanai, helalo-tao toana. ");
INSERT INTO meu_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Nadi isedia na gold e moḡe ḡoevaḡoeva ba karalai; ");
INSERT INTO meu_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","bona gold namo-hereana danu ba moḡea, gold varodia rua ba kara, bena unu gold varodia na hari nadi isedia ida ba hunu kau. ");
INSERT INTO meu_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Hahemaoro vainana danu ba karaia, hahedoki e karaia heḡereḡerena ba karaia ḡoevaḡoeva, gold bona dabua idau-idau, vaiuri bona mia-kaka bona kakakaka bona kurokuro, ba karalaia. ");
INSERT INTO meu_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Latana bona lababana bae heḡereḡere, bae ere rua; latana bona lababana na palapala lababana heḡereḡerena ai ba karaia. ");
INSERT INTO meu_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Nadi hururu-hururudia ere hani ba turi kau: ere ta ai sadio bona topasio bona barekete; ");
INSERT INTO meu_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ere iharuana ai samarago bona sapairo bona vasiga; ");
INSERT INTO meu_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ere ihatoina ai huakinto bona akate bona ametuso; ");
INSERT INTO meu_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ere ihahanina ai berulio bona onuku bona iaspi; iboudiai isedia na gold e moḡe ḡaudia amo ba koudia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Hari nadi hururu-hururudia na gwauta-rua, Israel natuna gwauta-raruosi ihaheḡereḡeredia; nadi ta ta ai iduhu ta ta ladadia bae ḡasi. ");
INSERT INTO meu_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Gold namo-hereana ba moḡea, gold varodia ba kara, vaina ena. ");
INSERT INTO meu_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Ring rua danu gold amo ba kara, vaina ena; vaina isena ruaosi ai ba turi kau. ");
INSERT INTO meu_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Hari gold varodia rua na vaina ring-dia ruaosi ai ba mata kau, ");
INSERT INTO meu_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","a varo dududia na hahedoki ena paḡa ḡaudia ai bae hemata kau. ");
INSERT INTO meu_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ma ring rua gold amo ba kara, vaina laloma kahana ai, isena ruaosi ai, ba turi kau; ");
INSERT INTO meu_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","bona ring rua gold amo ma ba kara, hahedoki ai ba turi kau, paḡa ḡaudia na hahedoki ida e hesiriu gabudia ai, gaba ḡauna daenai. ");
INSERT INTO meu_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Bena vaina ring-dia bona hahedoki ring-dia ba kwatu kubou, varo vaiurina amo, bona gaba ḡauna ai danu bae hemata kau; unuhetomana vaina bona hahedoki basie heruha diba. ");
INSERT INTO meu_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Unuhetomana danu Israel natuna ladadia hahemaoro vainana ai na Aaron kemena ai bae mia, gabu helaḡana ai baine raka vareai negadia ai; bena baine lalodia hanai-hanai Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Urim bona Tumim na vaina ai ba uda, Aaron kemena ai bae mia, Iehova vairanai baine raka vareai negadia ai: unu amo Aaron na nega iboudiai Israel taudia baine hahemaoro henidia Iehova vairanai, mai siahuna ida. ");
INSERT INTO meu_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Hahedoki badana na dabua vaiuri amo ba karaia. ");
INSERT INTO meu_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Matuna bogaragi ai ba karaia, kwara gabuna; matu isena danu ba turia, vaia hahedoki isedia e turimu heḡereḡerena, baine hedare garina. ");
INSERT INTO meu_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Isena ai herahera ba turi, rimono huahuadia na heheto, varo vaiuridia bona mia-kakadia bona kakakakadia ba turilai, padadia ai gold gabagabadia ba turi kau: ");
INSERT INTO meu_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","gold gabagabana ta rimono huahuana ta gold gabagabana ta rimono huahuana ta, unu ba turi toma, ela bona hahedoki isena ba haheraia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ena ḡaukara helaḡana baine karaia negadia ai Aaron ese baine dokia, bena reḡena baine hedinarai, Iehova vairanai helaḡa gabuna ai baine raka vareai bona baine raka lasi negadia ai, baine mase garina. ");
INSERT INTO meu_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Gold ḡoevaḡoeva mairina ta danu ba karaia, revarevana ba ḡasia, ini ba torea toma: HELAḠA IEHOVA ENA. ");
INSERT INTO meu_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Bena varo vaiurina bavabia, hari mairi na kwara iḡeḡelaina dabuana ai ba turia kau; ");
INSERT INTO meu_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ia na Aaron baguna ai baine mia. Unu amo Israel taudia ese edia boubou ḡaudia bae hahelaḡadia kerere negadia ai na Aaron ese edia kerere baine hua; bena hari mairi na baguna ai mia dainai Iehova ese edia boubou baine abi dae. ");
INSERT INTO meu_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Muri hahedokina na dabua aukana namo-hereana amo ba karaia, mai revarevana. Kwara iḡeḡelaina dabuana danu dabua aukana amo ba karaia. Gaba ḡauna danu dabua aukana amo ba karaia, bona heraherana ba turi. ");
INSERT INTO meu_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Aaron natuna danu edia muri hahedokidia bona edia kwara iḡeḡelaidia dabuadia bona gaba ḡaudia ba kara, mai toadia bona mai hairaidia ida bae noho halaoreana. ");
INSERT INTO meu_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Kakamu Aaron mai natuna ida unu ba hahedokilaidia toma; ba horodia danu, dagi ba henidia; bona ba hahelaḡadia, egu hahelaḡa taudia ai baela. ");
INSERT INTO meu_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Edia piribou danu dabua aukadia amo ba kara, kopidia bae koudia, gabadia amo ela bona tuidia. ");
INSERT INTO meu_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaron mai natuna ida hari piribou bae kara, gabu helaḡana ai kara helaḡadia bae kara totona hebou kalagana ai bae raka vareai negadia iboudiai bona ihaboulaina patana bae raka henia kahi negadia iboudiai bae kara, bae kerere bena bae mase na garina. Ina haheḡani na ia bona ia garana ese bae badina ela bona hanaihanai. ");
INSERT INTO meu_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Ini ba hahelaḡadia toma, bena egu hahelaḡa taudia ai baela. Boromakau natuna maruanena ta bona mamoe mamaruanedia rua, asi bebeka-bebekadia, bavabidia. ");
INSERT INTO meu_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Flaoa asie hatubua e gabua, bona flaoa asie hatubua atagadia dehoro ida e bulo, bona flaoa asie hatubua atagadia latadia dehoro e seia ḡaudia danu bavabi. Ini na uit flaoana amo ba kara. ");
INSERT INTO meu_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Bosea ai ba uda, ba laohai; boromakau natuna maruanena bona mamoe mamaruanedia ruaosi ida. ");
INSERT INTO meu_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Bena Aaron mai natuna ida ba hakaudia lao, hebou kalagana iduarana badibadinai ranu amo ba hadigudia. ");
INSERT INTO meu_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Bena dabua bavabi, muri hahedokina bona hahedoki haleḡana bona hahedoki badana bona vaina, iboudiai na Aaron ba hadokilaia; bona gaba ḡauna danu ba ḡeḡelaia. ");
INSERT INTO meu_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Kwara dabuna danu kwarana ai ba ḡeḡea; bona korona helaḡana na kwara dabuana latanai bavatoa kau. ");
INSERT INTO meu_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Bena ihorona dehorona bavabia, ia kwarana ai ba seia, ba horoa. ");
INSERT INTO meu_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Natuna danu ba hakaudia mai, bena edia ba hadokilaidia, ");
INSERT INTO meu_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","bona edia gaba ḡaudia ba ḡeḡelaidia, bona edia kwara dabuadia kwaradia ai ba ḡeḡe. Edia hahelaḡa dagina na lauegu ai bae abia, baine mia hanaihanai taravatuna dainai. Aaron mai natuna ida unu ba hahelaḡadia toma. ");
INSERT INTO meu_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Bena boromakau maruanena ba hakaua lao, hebou kalagana vairanai. Aaron mai natuna ida imadia na ia kwarana ai bae atodia kau; ");
INSERT INTO meu_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","bena boromakau na Iehova vairanai bavalaia, hebou kalagana iduarana badibadinai. ?");
INSERT INTO meu_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Bena boromakau rarana kuri ta bavabia, ihaboulaina patana doadia na imamu kwakikwakina amo ba dahulai; a rara orena na pata badinai ba bubua. ");
INSERT INTO meu_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Bena bogarau urubina bona ase digarana bona nadinadi mai digaradia ida bavabi, ihaboulaina patana latanai ba gabudia, bena bae ḡoledia oho. ");
INSERT INTO meu_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","A boromakau hidiona bona kopina bona taḡena na taruha murimurinai ba gabudia, bae ḡoledia oho. Ina na kara dika iabi-ohona boubouna. ");
INSERT INTO meu_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Una murinai mamoe maruanena ta bavabia, Aaron mai natuna ida imadia na ia kwarana ai bae atodia kau. ");
INSERT INTO meu_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Bena mamoe na bavalaia, rarana bavabia, ihaboulaina patana ohena kahana kahana ba nevaridia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Bena mamoe ba ivaia, bogarauna bona imana bona aena ba huridia, hidiona bona kwarana ida ba haboudia; ");
INSERT INTO meu_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","idoinai na ihaboulaina patana latanai ba gabudia. Ina na ḡole-oho boubouna, Iehova ena; ia na bonana namo ḡauna, lahi boubouna, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Mamoe maruanena iharuana bavabia, Aaron mai natuna ida imadia na ia kwarana ai bae atodia kau. ");
INSERT INTO meu_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Bena mamoe na bavalaia, rarana kuri ta bavabia, Aaron taiana idibana abona natuna taiadia idibadia abodia ba dahulaidia, imadia idibadia bona aedia idibadia sinabadadia danu ba dahulaidia. Bena rara orena na ihaboulaina patana ohena kahana kahana ba nevaridia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Bena ihaboulaina patana latanai e miamu rarana bona ihorona dehorona bavabi, Aaron mai dabuana ida bona natuna mai dabuadia ida ba nevarilaidia. Ia mai dabuana ida bae helaḡa; natuna danu mai dabuadia ida bae helaḡa. ");
INSERT INTO meu_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Mamoe maruanena digarana bavabia, bona iuna digarana, bona bogarauna urubina, bona ase digarana, bona nadinadi mai digaradia ida, bona idiba mamuna; badina be ina na hahelaḡa mamoena. ");
INSERT INTO meu_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Flaoa igabuna ta, bona flaoa dehoro amo e kuia atagana ta, bona ataga kavakava ta, asie hatubua flaoana boseana amo ba vai, Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Bena Aaron imana ai bona natuna imadia ai bavato, bae davedavelai, davedave boubouna ai baela Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Bena imadia amo bavabi lou, ihaboulaina patana latanai ba gabu, hari ḡole-oho vamuna ida. Ia na bonana namo ḡauna Iehova vairanai; ḡole-oho boubouna, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Aaron ihahelaḡana mamoena kemena bavabia, ba davedavelaia, dave-dave boubouna ai bainela Iehova vairanai; bena bavabia, oi ahumu. ");
INSERT INTO meu_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Hari keme, e davedavelaia ḡauna, bona mamu, e duduia isi ḡauna, ba hahelaḡadia; badina be ia na Aaron mai natuna ida ihahelaḡadia mamoena. ");
INSERT INTO meu_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Idia ahudia bunu, Israel taudia ese bae henidia hanaihanai. Badina be hahelaḡa taudia ahudia bunu, Israel taudia ese edia herohemaino bouboudia amo bae henidia; edia boubou ḡauna bae duduia isi, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Aaron ena dabua halaḡadia na natuna ese bae abi, ia murinai; ihahelaḡadia negadia ai bae doki. ");
INSERT INTO meu_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ia natuna, hahelaḡa dagina ai baine boloa tauna, ese dina hitu lalodiai baine doki, hebou kalagana ai baine raka vareai, gabu helaḡana ai ḡaukara helaḡadia baine kara negadia ai. ");
INSERT INTO meu_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Ihahelaḡadia mamoena hidiona bavabia, gabu helaḡana ai ba nadua. ");
INSERT INTO meu_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Bena Aaron mai natuna ida bae ania, bona bosea lalonai e miamu flaoana danu bae ania, hebou kalagana iduarana badibadinai. ");
INSERT INTO meu_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Hari kara dika itahunidia bona edia dagi ihahelaḡadia ḡaudia na idia ese bae ani; a taunimanima kavakavadia na basie ani, badina be unu ḡau be hehelaḡa. ");
INSERT INTO meu_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Hari ihahelaḡadia vamuna eiava flaoana bahudia bema mia rani, idia na lahi ai bema gabu bena bema ḡole oho; basiema ani, badina be hehelaḡa. ");
INSERT INTO meu_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Ini kara iboudiai na Aaron mai natuna ida ba kara henidia, egu hahedua heḡereḡerena; dina hitu lalodiai ihahelaḡadia karadia bae hesiriu. ");
INSERT INTO meu_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Dina ta ta ai boubou boromakauna ta bavalaia, kara dika itahunina ḡauna; kara dika iabi-ohona boubouna ta danu ba karaia, ihaboulaina patana ena; ba horoa bona ba hahelaḡaia. ");
INSERT INTO meu_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Dina hitu lalodiai boubou ba kara, ihaboulaina patana ena; unu amo ba hahelaḡaia ela bona baine helaḡa vaitani, bona enai bae dau kau ḡaudia danu bae helaḡa. ");
INSERT INTO meu_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Boubou ḡaudia ihaboulaina patana ai ba gabu, bena bae ḡole oho, ḡaudia bini: mamoe natudia rua, laḡani ta do asie haḡuḡurua ḡaudia, dina ta ta amo ba gabu; ");
INSERT INTO meu_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ta be daba ai ba gabua, ma ta adorahi ai. ");
INSERT INTO meu_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Flaoa namona nau auta dehoro namona kehere ta amo ba kuia, mamoe natuna ida bavato kau; bona vine ranuna kehere ta ihaboulaina patana latanai ba seia. ");
INSERT INTO meu_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Mamoe natuna iharuana na adorahi ai ba gabua, bona ia ida flaoa boubouna bona inuinu danu ba heni. Ina na bonana namo ḡauna, ḡole-oho boubouna, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ina ḡole-oho boubouna ba kara loulou, uru iboudiai; hebou kalagana iduarana badibadinai bae kara, Iehova vairanai. Unuseni ai lau baina hahedinarai henimui, bona oi baina hereva henimu. ");
INSERT INTO meu_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Unuseni ai lau ese Israel taudia baina hahedinarai henidia, bona lau hairaiagu ese kalaga baine hahelaḡaia. ");
INSERT INTO meu_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Lau ese hebou kalagana bona ihaboulaina patana baina hahelaḡadia; Aaron mai natuna ida danu baina hahelaḡadia, egu hahelaḡa taudia ai baela. ");
INSERT INTO meu_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Lau na Israel taudia bogaragidiai baina noho, edia Dirava. ");
INSERT INTO meu_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Idia bae diba lau be Iehova edia Dirava; Aigupto amo na hakaudia lasi, bogaragidiai baina noho helaoreana. Lau binai Iehova, edia Dirava. ");
INSERT INTO meu_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Pata helaḡana ta ba karaia, muramura mai bonadia igabudia ḡauna; kela audia amo ba karaia. ");
INSERT INTO meu_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Pata na latana bona lababana bae heḡereḡere. kiubit tamona; harana ena lata na kiubit rua; doana na ia ida au tamona amo bae koro. ");
INSERT INTO meu_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Kopina na gold namo-hereana amo ba ḡovaia, pata bona aena bona doana; bona digina na gold amo ba haheraia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ring rua gold amo ba kara, pata digina henunai ba kokodia kau, ta pata kahana ai, ma ta kahana ai, maduna itoi-hanaidia ḡaudia, bae huaia negadia ai. ");
INSERT INTO meu_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Maduna rua danu ba kara, kela audia amo, bona gold amo ba ḡovadia. ");
INSERT INTO meu_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Taravatu mauana bona e karuhia ahu ikaruhina, taravatu nadidia e karuhidia ahu ḡauna, baina hahedinarai henimu gabuna, seseahuna vairanai, bavatoa. ");
INSERT INTO meu_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Daba iboudiai, lamepa baine haḡoevadia negana ai, Aaron ese muramura mai bonadia baine gabu, una pata ai. ");
INSERT INTO meu_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Adorahi iboudiai danu, lamepa baine ha-ara negana ai, ma baine gabu lou; unu amo bona namodia bae dae hanaihanai Iehova vairanai, ela uru idoidiai. ");
INSERT INTO meu_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Una pata ai muramura idauna ta basie gabua, ḡole-oho boubouna eiava flaoa boubouna danu basie atoa kau; bona inuinu boubouna basio seia. ");
INSERT INTO meu_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Laḡani ta ta lalodiai dina tamona ai Aaron ese kara dika itahunidia karana baine karaia una pata doana ai: kara dika boubouna rarana amo baine dahudia, laḡani ta ta amo, ela uru iboudiai; ia na helaḡa herea Iehova enai. ");
INSERT INTO meu_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Iehova ese Mose ma e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Israel taudia ladadia ba tore negana ai, tatau ta ta ese edia mauri davana na Iehova bae henia, lada itoredia lalonai gorere ese baine aladia na garina. ");
INSERT INTO meu_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ini bae henia toma: ladadia bae tore taudia iboudiai na ta ta sekele kahana kahana bae heni, gabu helaḡana ena sekele heḡereḡerena; una sekele anina be gera ruahui. Ina na herahia ḡauna, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ladadia bae tore tataudia iboudiai, laḡani ruahui vada e hanai tataudia, una herahia ḡauna Iehova bae henia. ");
INSERT INTO meu_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Taḡa tauna basine habadaia, ogoḡami tauna basine hamaraḡia, sekele kahana mo bae henia, emui kara dika itahunidia herehiana Iehova ba henia negadia ai. ");
INSERT INTO meu_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ina kara dika itahundia monina na Israel taudia ediai bavabia, hebou kalagana monina ai ba halaoa: ia na helalo-tao ḡauna ai bainela Israel taudia edia, Iehova vairanai, bona emui kara dika itahunidia ḡauna ai bainela. ");
INSERT INTO meu_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Iehova ese Mose na e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Dihu ta auri labora-labora amo ba karaia, hurihuri ḡauna mai ihahelai-kauna ḡauna, ia danu auri labora-labora. Hebou kalagana bona ihaboulaina patana padadiai ba haginia. Ia lalonai ranu ba seia. ");
INSERT INTO meu_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaron mai natuna ida imadia bona aedia na una ranu ai bae huri: ");
INSERT INTO meu_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","hebou kalagana ai bae raka vareai hegadia iboudiai ranu amo unu bae haheḡoeva toma, bae mase garina. Ihaboulaina patana bae raka kahi henia negadia ai, Iehova ibouna ḡaudia bae haḡole oho totona, ");
INSERT INTO meu_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","imadia bona aedia bae huri, bae mase garina. Mia-hanaihanai haheḡanina binai, idia edia, Aaron mai rarana ida edia, ela uru idoidiai. ");
INSERT INTO meu_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Iehova ese Mose ma e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Muramura namo-hereadia bavabi: muro ranuna, metauna na sekelesinahu-ima; kinamomo mai gaihona, metauna na sekele sinahu-rua imahui; kane mai gaihona, metauna na sekele sinahu-rua imahui; ");
INSERT INTO meu_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","bona kida, metauna na sekele sinahu-ima; iboudiai gabu helaḡana ena sekele heḡereḡeredia; bona olive dehorona hini ta. ");
INSERT INTO meu_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ini na ba bulodia, dehoro delaḡana ai baela. Ba bulodia namonamo, muramura ikarana tauna korikori ese e karaimu na heto; bena dehoro helaḡana ai bainela. ");
INSERT INTO meu_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ina dehoro amo hebou kalagana ba nevaria; bona taravatu mauana ba nevaria, ");
INSERT INTO meu_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","bona pata mai ena ḡau iboudiai, bona lamepa patana mai kohuna idoinai, bona muramura patana, ");
INSERT INTO meu_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","bona ihaboulaina patana mai ena ḡau iboudiai, bona ranu dihuna mai ihahelai-kauna ḡauna ida, iboudiai ba nevaridia. ");
INSERT INTO meu_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ba hahelaḡadia, bae helaḡa vaitani, bona ediai bae dau kau ḡaudia danu bae helaḡa. ");
INSERT INTO meu_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Aaron mai natuna ida danu ba horodia, ba hahelaḡadia; lau isiaigu bae lao heni, egu hahelaḡa taudia. ");
INSERT INTO meu_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Bena Israel taudia ba hamaorodia, baoto “Ina na Iehova ena dehoro helaḡana, uru iboudiai; ");
INSERT INTO meu_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","taunimanima kavakava na kopidia basio dahulaidia, bona ia heḡereḡerena na basio karaia; ia na helaḡa, bona baine helaḡa emui ai. ");
INSERT INTO meu_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Tau ta ese dehoro ia heḡereḡerena baine kariai, idau tauna baine dahulaia, ia na ena iduhu amo bae negea daure.” ");
INSERT INTO meu_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Iehova ese Mose ma e hamaoroa, eto, Muramura mai gaihodia bavabi: natafa bona sekelete bona kelebena bona libano ḡoevaḡoevana, iboudiai metaudia heḡereḡeredia bavabi. ");
INSERT INTO meu_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Ba bulodia, muramura ikarana tauna korikori ese e karaimu heḡereḡerena; bena damena ida ma ba bulodia, baine ḡoevaḡoeva bona baine helaḡa. ");
INSERT INTO meu_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Bena taina bavabia, ba hodoa dimura-dimura; bena taravatu mauana vairanai bavatoa diho, hebou kalagana lalonai, baina hahedinarai henimu gabuna ai. Ia na baine helaḡa herea emui ai. ");
INSERT INTO meu_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Muramura ia heḡereḡerena na basio karaia sibomui emui; ia na baine helaḡa Iehova ena. ");
INSERT INTO meu_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Tau ta muramura ia heḡereḡerena baine karaia ia sibona ena, ia be ena iduhu amo bae negea daure. ");
INSERT INTO meu_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Iehova ese Mose ma e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Vada na abia hidi tauna ladana na Besalele, Uri natuna, Huru tubuna, Iuda iduhuna tauna. ");
INSERT INTO meu_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Dirava ena Lauma vada na henia, baine aonega bona lalona baine parara bona ima karakara ḡaukaradia baine diba helaoreana. ");
INSERT INTO meu_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Ia na gold bona silver bona auri labora-labora ḡaudia namodia baine kara, ");
INSERT INTO meu_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","bona herahera nadidia baine utu, bona au baine koro, ḡaukara idau-idau ikaralaidia. ");
INSERT INTO meu_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Oholiab danu vada na abia hidi: ia na Ahisamaka natuna, Dan iduhuna tauna. Kara-kara taudia iboudiai danu lalodia vada na hapararadia, vada na haḡanilaimu ḡaudia iboudiai bae kara diba: ");
INSERT INTO meu_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","hebou kalagana, bona taravatu mauana mai ikaruhina ida, bona kalaga kohudia iboudiai, ");
INSERT INTO meu_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","bona pata helaḡana mai kohuna idoinai, bona lamepa patana mai kohuna idoinai, bona muramura patana, ");
INSERT INTO meu_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","bona ihaboulaina patana mai kohuna idoinai, bona ranu dihuna mai ihahelai-kauna ḡauna ida, ");
INSERT INTO meu_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","bona dabua helaḡadia, Aaron mai natuna ida edia, hahelaḡa karadia bae kara negadia ai bae doki, ");
INSERT INTO meu_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","bona ihorodia dehorona, bona muramura mai bonadia, gabu helaḡana ena. Na haḡanilaimu ḡaudia iboudiai na idia ese bae kara. ");
INSERT INTO meu_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Iehova ese Mose ma e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Israel taudia ba haḡanidia, egu Dina Helaḡa bae matauraidia hanaihanai. Badina be ia na toa ta, lau bona umui padadai, emui uru idoidiai lalodiai: iena amo ba diba lau na Iehova, umui ihahelaḡamui Diravana. ");
INSERT INTO meu_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Taunabunai, Dina Helaḡa na ba matauraia, badina be ia na helaḡa emui ai: basine matauraia tauna na bae alaia mase; bona una dina ai baine ḡaukara tauna na ena iduhu amo bae negea daure. ");
INSERT INTO meu_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Dina tauratoi lalodiai ba ḡaukara, a dina ihahituna na Dina Helaḡa, laḡa-ani dinana; vada e helaḡa vaitani, Iehova ena. Dina Helaḡa, laḡa-ani dinana; vada e helaḡa vaitani, Iehova ena. Dina Helaḡa ai baine ḡaukara tauna na bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Israel taudia ese Dina Helaḡa bae matauraia uru idoidaia; ia na baine mia hanaihanai herohemainona toana. ");
INSERT INTO meu_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ia na mia hanaihanai toana, lau bona umui Israel taumai padadai. Badina be Iehova ese guba bona tanobada e karadia, dina tauratoi lalodiai, a dina ihahituna ai e laḡa ani, bona e kara ḡaudia e moalelai. ");
INSERT INTO meu_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ena hereva, Mose ida e hereva-herevalai Sinai ororona ai, e ore ai, Iehova ese taravatu nadidia ruaosi Mose e henia: umu nadi palakadia ruaosi be Dirava ese imana kwakikwakina amo taravatu e torelai nadidia. ");
INSERT INTO meu_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Israel taudia e itaia, Mose na ororo dorina ai e halahe, bena idia na Aaron dekenai eha hebou, e hamaoroa, eto, A tore isi, kaivakuku ba karaia emai, ai vairamai ai bainela; badina be hari Mose, Aigupto amo e hakaumai lasi tauna, na ede ela ai asi dibamai. ");
INSERT INTO meu_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Bena Aaron ese e hamaorodia, eto, Gold badeidia na adavamui bona natumui taiadia amo ba koki oho, vada ba henigu. ");
INSERT INTO meu_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Bena taunimanima iboudiai na gold gadeidia taiadia amo e koki oho, Aaron e henia. ");
INSERT INTO meu_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Bena ia ese edia gold ḡaudia e abi, iboudiai e havevedia kubou; bena e koroa, boromakau natuna laulauna e karaia. Bena idia eto, Israel e, emui dirava binai, Aigupto amo e hakaumui lasi diravana. ");
INSERT INTO meu_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaron ese edia kara e itaia, bena ia ese ihaboulaina patana ta e larebaia, una kaivakuku vairanai, bona hereva e hapiua, eto, Kerukeru aria baita karaia, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Taunabunai, daba matana ai e tore isi, ḡole-oho bouboudia bona herohemaino bouboudia e kara. Bena e ege ege diho, e aniani, vine ranuna e inua; bena e tore tore isi, e gadara. ");
INSERT INTO meu_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Bena Iehova ese Mose e haduaia, eto, A diho haraḡa; badina be emu orea taudia, Aigupto amo o hakaudia lasi taudia, vada e kara havara; ");
INSERT INTO meu_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","na haḡanilaidia dalana vada e rakatania haraḡa, boromakau natuna laulauna vada e karaia, vada e toma henia diho, vada e boua, e tomu “Israel e, emui dirava binai, Aigupto amo e hakaumui lasi”. ");
INSERT INTO meu_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Iehova ese Mose ma e hamaoroa, eto, Ina orea taudia vada na itadia, lalo-auka oreana. ");
INSERT INTO meu_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","A siri: egu badu vada eme siahu idia ediai. Idia baine habuadia tari, a oi na bese badana ai baina halaomu. ");
INSERT INTO meu_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","A Mose ese Iehova, ena Dirava, e noia, eto, Iehova e, dahaka dainai emu badu vada eme siahu emu orea taudia ediai, Aigupto amo o hakaudia lasi mai siahumu badana bona mai imamu goadana ida oreana enai. ");
INSERT INTO meu_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Namona be dahaka Aigupto taudia baeto “Ia ese dala dikana amo e hakaudia lasi, ororo ai e aladia mase, tanobada kopina amo e habuadia tari”. Emu badu amo ba raka siri, bona emu orea taudia ialadia amo ba helalo kerehai. ");
INSERT INTO meu_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Emu hesiai taudia Abraham bona Isaak bona Israel ba lalodia: sibomu o gwau henidia hamata, oto “Umui garamui baina hahutumadia, guba hisiudia na heheto; ina tano idoinai, vada na gwauraia hamata tanona, umui garamui baina henidia, edia tano ai bainela, ela bona hanaihanai”. ");
INSERT INTO meu_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Bena Iehova ese ena bese taudia ialadia amo e helalo kerehai. ");
INSERT INTO meu_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Bena Mose na ororo dorina amo e hekei, taravatu nadidia ruaosi imana ai e kadidiha, unu nadi palakadia na kaha ruaosi ai, vairadia kahadia bona muridia kahadia, revareva vada e hetore. ");
INSERT INTO meu_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Hari nadi be Dirava ese e kara ḡaudia, bona revareva be Dirava ese e tore revarevadia. ");
INSERT INTO meu_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Iosua ese heloḡo-heloḡo e kamonai, Israel taudia e lolova, bena ia ese Mose e hamaoroa, eto, Tuari reḡena taruha ai na kamonaimu. ");
INSERT INTO meu_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mose eto, Lasi na kamonaimu ḡauna na dia kwalimu dainai asie hisi daemu, bona darere dainai asie ehonimu, to ane e abimu. ");
INSERT INTO meu_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Taruha e raka henia kahi ai, boromakau natuna laulauna e itaia, bona taunimanima e mavaruva e itadia. Bena Mose e badu dikadika, taravatu nadidia imana amo e tahodia dobi, ororo badi-tanona ai e makohi rohoroho. ");
INSERT INTO meu_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Bena ia ese boromakau natuna laulauna, idia ese e karaia ḡauna, e abia, lahi ai e gabua, bena e huaria sisi, ranu lalonai e ḡiḡia uda; bena e buloa patapata, Israel taudia e ha-inulaidia. ");
INSERT INTO meu_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Bena Mose ese Aaron e gwau henia, eto, Ini taunimanima na ede e karamu toma dainai oi ese ini vada o hakaradia dika toma? ");
INSERT INTO meu_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron eto, Ḡauka e, basio badu henigu; oi dibamu ini taunimanima na mai lebu-lebudia. ");
INSERT INTO meu_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Badina be idia ese e hamaorogu, eto “Kaivakuku ba karaia emai, ai vairamai ai bainela; badina ba hari Mose, Aigupto amo e hakaumai lasi tauna, na ede ela ai asi dibamai”. ");
INSERT INTO meu_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Bena lau nato “Mai edia gold taudia na bae koki oho”; bena idia ese e henigu. Lau ese lahi ai na tahoa vareai; bena ina boromakau natuna e lasi. ");
INSERT INTO meu_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mose ese taunimanima e itadia, vada e heloḡo-heloḡova; badina be Aaron ese vada e kahudia nege bae heloḡo-heloḡo, inaidia vairadiai bae hemarai helaoreana. ");
INSERT INTO meu_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Bena Mose na taruha ikoukouna ai e gini, eto, Iehova ena kaha taudia na dekegu aema. Bena Levi natuna iboudiai na ia dekenai e hebou. ");
INSERT INTO meu_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Bena ia ese e hamaorodia, eto, Iehova, Israel Diravana, ena hahedua binai: unui ta ta ena dare ena dare bavabi, taruha ba rakaia hanai, tadikakamui bona turamui bona dekemui taudia bavaladia mase. ");
INSERT INTO meu_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Bena Levi natuna ese Mose ena hahedua heḡereḡerena e karaia, taunimanima daha-toi sisivana e aladia mase una dina ai. ");
INSERT INTO meu_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Bena Mose eto, Hari dina ai umui na sibomui vada o hahelaḡa, Iehova ena hesiai taumui; natumui bona tadikakamui na boubou ḡaudia ai vada o halaodia. Iehova ena hahenamo na latamui ai hari ina dina ai. ");
INSERT INTO meu_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Kerukeru, Mose ese Israel taudia e hamaorodia, eto, Emui kara dika na bada herea: a lau na Iehova enai baina dara dae, emui kara dika itahunina dalana baina tahua. ");
INSERT INTO meu_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Bena Mose ese Iehova e lou henia, eto, Ini taunimanima vada e kara havara, edia kaivakuku na gold amo vada e karaia. ");
INSERT INTO meu_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Edia dika boma gwau tao; a bema lasi, lau ladagu danu vada o torea bukana amo ba rohoa. ");
INSERT INTO meu_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","A Iehova ese Mose e haere henia, eto, Vairagu ai vada e kara havara taudia iboudiai ladadia na egu buka amo bae heroho. ");
INSERT INTO meu_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","A harihari aola, taunimanima ba hakaudia lao, vada na hamaorolaimu tanona ai ba hakaudia vareai. Momokani, egu aneru ese baine gunalaimui. Ḡau tamona, egu hahemaoro dinana baine kau ai, edia dika davadia do baina henidia. ");
INSERT INTO meu_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Bena Iehova ese Israel taudia e hahisidia, badina be boromakau natuna laulauna Aaron ese e karaia idia ese e toma henia diho. ");
INSERT INTO meu_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Iehova ese Mose ma e haduaia, eto, Ina gabu amo ba raka lao, oi bona Aigupto amo o hakaudia lasi taudia, lau na gwauraia hamata tanona baola: Abraham bona Isaak bona Iakob na gwau henidia hamata, nato “Umui garamui baina henidia”, tanona bunai. ");
INSERT INTO meu_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Aneru ta oi vairamu ai baina siaia; Kanaan taudia bona Amoro taudia bona Hiti taudia bona Perisi taudia bona Hivi taudia bona Iebusu taudia baina luludia lasi. ");
INSERT INTO meu_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Baola, rata bona bada-ranuna e arumu tanona ai ba raka vareai; to umui na lalo-auka taumui dainai lau na basina bamomui, dala ai baina habuamui tari na garina. ");
INSERT INTO meu_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Una hari dikana e kamonai ai, Israel taudia na lalodia e hisihisiva: tau ta ena herahera ḡaudia se kara. ");
INSERT INTO meu_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Bena Iehova ese Mose e hamaoroa, eto, Israel taudia ba hamaorodia, baoto “Umui na lalo-auka taumui; nega kwadogi-kwadogi mo bama vasi, bama habuamui tari. Taunabunai, emui herahera ḡaudia ba kokidia oho, bena baina diba ede baina karamui toma”. ");
INSERT INTO meu_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Taunabunai, Israel taudia na Horeb ororona ai edia herehera ḡaudia e kokidia oho, asie kara lou. ");
INSERT INTO meu_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mose ena kara na iniheto: kalaga e haginia taruha murimurinai, taina dauhai; ladana e hatoa Hebou Kalagana. Bena Iehova baine ḡuria e tomava tauna ese una hebou kalagana ela, taruha murimurinai. ");
INSERT INTO meu_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","A Mose na hebou kalagana ela negadia ai, taunimanima iboudiai e tore tore isi, edia kalaga iduaradia ai e gini, Mose e raraia tao ela bona hebou kalagana ai e raka vareai. ?");
INSERT INTO meu_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Badina be Mose na hebou kalagana ai e raka vareai negadia iboudiai, ori ta e diho, kalaga iduarana e sesea ahu, bena Iehova na Mose ida e hereva hereva. ");
INSERT INTO meu_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Taruha taudia ese ori e itaia negadia ai na iboudiai e goru goru diho, ta ta ena kalaga iduarana ena kalaga iduarana ai. ");
INSERT INTO meu_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Una negana ai Iehova bona Mose e hevaira heheni bona e hereva heheni, tau ta ese turana ida bae hereva hereva na heto. Bena Mose na taruha e lou henia negana ai, ena hesiai tauna, Iosua Nunu, tau eregabe ta, ese hebou kalagana se rakatania. ");
INSERT INTO meu_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mose ese Iehova e hereva henia, eto, Mani a laloa, vada o hamaorogu, oto “Ini taunimanima ba hakaudia lao”; to oi na do so hamaorogu, daika ba siaia baine bamogu. Ma vada o hamaorogu, oto “Ladamu be dibagu, bona na lalo namo henimumu”. ");
INSERT INTO meu_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Taunabunai, na noimumu, boma lalo namo henigu, emu dala boma hadibalaigu, bama diba oi, emu lalo-namo danu bama diba. Boma laloa danu, ina bese na oiemu orea. ");
INSERT INTO meu_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Iehova eto, Lau baina bamomu, laḡa-ani baina henimu. ");
INSERT INTO meu_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mose ma eto, Basioma bamogu, ini amo basioma siaimai. ");
INSERT INTO meu_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Badina be ede baina diba toma o lalo namo henigumu bona ina bese taudia o lalo namo henidiamu? Ba bamomai dainai baia, ani? Unu amo lau bona ina bese taudia vada baia idau, tanobada besedia iboudiai bogaragidiai. ");
INSERT INTO meu_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Bena Iehova ese Mose e haere henia, eto, Emu noinoi heḡereḡerena baina kara henimu, badina be lau ese na lalo namo henimumu, bona ladamu be dibagu. ");
INSERT INTO meu_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mose ese ma e noia, eto, Oi hairaimu bama itaia. ");
INSERT INTO meu_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ia eto, Egu namo idoinai baina haheitalaimu, bona lau ladagu IEHOVA oi vairamu ai baina gwauraia. Baina harihari henidia na tomu taudia vada baina harihari henidia, bona baina bogadia hisi na tomu taudia vada baina bogadia hisi. ");
INSERT INTO meu_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","To lau vairagu ba itaia na asi dalana, badina be asi tauna ta ese baine itagu bona baine mauri. ");
INSERT INTO meu_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Iehova ma eto, A itaia, lau badibadigu ai nadi badina ta mia. Ia latanai ba gini. ");
INSERT INTO meu_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Bena lau hairaigu baine raka hanai negana ai, lau na nadi kohuana lalonai baina atomu vareai, bona imagu amo baina koumu ahu, ela bona baina raka hanai. ");
INSERT INTO meu_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Bena imagu baina abia oho: dorugu vada ba itaia, a vairagu basio itaia. ");
INSERT INTO meu_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Iehova ese Mose e haduaia, Huro-nadidia palakadia rua ma bavabi, gunadia heḡereḡeredia; bena revarevadia ma baina tore, gunadia ruaosi, o hamakohidia ḡaudia, revarevadia na tore heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Daba ai ba heḡaeḡae, Sinai ororona ai ba dara dae, lau vairagu ai ba gini, ororo dorina ai. ");
INSERT INTO meu_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Tau ta basine bamomu, bona tau ta basine hedinarai ororo dorina ai; bona mamoe seridia bona boromakau seridia basie aniani ororo badi-tanona ai. ");
INSERT INTO meu_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Taunabunai, Mose na huro-nadidia palakadia rua e utudia, gunadia heḡereḡeredia. Bena daba ai e tore isi, ororo ai e dara dae, Iehova ena hahedua heḡereḡerena; hari nadi palakadia na imana ai e abi kau. ");
INSERT INTO meu_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Bena Iehova na ori ai e diho, Mose badibadinai e gini, e helada hato. ");
INSERT INTO meu_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Bena Iehova ese e rakaia hanai, eto, Lau binai Iehova; Iehova, hebogahisi bona harihari-bada Diravana. Badu ai na halahemu; hebogahisi ai bona uraheni ai na haraḡamu. ");
INSERT INTO meu_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Daha daha na bogadia hisimu; kara-havara bona kara rea bona kara-dika na gwau taomu. Ḡau tamona, kerere taudia basina kahudia nege, a tamadia edia kara dika davadia na natudia baina henidia, bona tubudia baina henidia, ela uru ihatoina bona ihahanina danu. ");
INSERT INTO meu_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Bena Mose na tano ai e goru diho haraḡa, e toma henia diho, ");
INSERT INTO meu_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","eto, Ḡaubada e, boma lalo namo henigu, mani emu kara, ai, lalo-auka besena taumai, bogaragimai ai baola, emai kara-havara bona emai kara-dika ba gwau tao, bona dihimu ai ba halaomai. ");
INSERT INTO meu_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Iehova eto, A kamonai, aita herohemaino. Emu orea taudia iboudiai vairadiai hoa karadia baina kara, tanobada idoinai bese idau-idau bogaragidiai asie hedinaraiva karadia; bogaragidiai o nohomu oreadia iboudiai na Iehova ena kara bae itaia, badina be daimui ai baina kara karadia na mai garidia. ");
INSERT INTO meu_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Hari dina ai baina henimui haheḡanidia vada ba badinadia. A itaia, lau na Amoro taudia bona Kanaan taudia bona Hiti taudia bona Perisi taudia bona Hivi taudia bona Iebusu taudia na umui vairamui ai baina luludia lasi. ");
INSERT INTO meu_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","A ba heita, ba lao henia tanona taudia ida basio herohemaino, ba hekwakwanai na garina. ");
INSERT INTO meu_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Edia ihaboulaina patadia ba ḡiḡi rohoroho; edia kaivakuku ba hamakohidia; edia dubu ba tara patapata; ");
INSERT INTO meu_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","badina be umui ese idau dirava ta basio toma henia diho, badina be Iehova ladana ta be Vaḡeḡe: ia be vaḡeḡe Diravana. ");
INSERT INTO meu_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Taunabunai ba heita, una tano taudia ida basio herohemaino; edia dirava basio toma henidia diho; edia boubou karadia basio kara; edia ihaboulaina ḡaudia basio ani. ");
INSERT INTO meu_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Natudia hahinedia danu basio abidia, natumui mamaruanedia basie adavadia; unu hahine ese edia dirava bae toma henidia diho negadia ai na unui natumui ese danu bae toma henidia diho na garina. ");
INSERT INTO meu_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Kaivakuku danu basio kara. ");
INSERT INTO meu_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Flaoa asie hatubua Ariana ba badinaia. Dina hitu asie hatubua flaoana mo bavania, vada na haḡanimui heḡereḡerena, nega korikorina ai, hua ladana Abib ai, badina be Abib huana ai umui na Aigupto amo o raka lasi. ");
INSERT INTO meu_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Roboa mamaruanedia iboudiai na lauegu: boromakau natudia roboa mamarunedia bona mamoe natudia roboa mamaruanedia. ");
INSERT INTO meu_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Doniki natuna roboana davana na mamoe natuna ta ba henigu; a davana basioma karaia, aiona boma hakwaidua. Umui natumui roboa mamaruanedia danu davadia ba kara. Asi tauna ta ima kavakava ai baine hedinarai lau vairagu ai. ");
INSERT INTO meu_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Dina tauratoi ba ḡaukara, a dina ihahituna ai laḡamui bavani; tano iruana negana ai bona taboro negana ai danu ba laḡa ani. ");
INSERT INTO meu_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Pura ariana ba karaia, uit iutuna ba matamaia negana ai; bona laḡani dokona ariana ba karaia, uma anidia ba habou vaitani negana ai. ");
INSERT INTO meu_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Laḡani ta lalonai emui maruane iboudiai na nega toi Ḡaubada Iehova, Israel Diravana, vairanai bae hedinarai. ");
INSERT INTO meu_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Badina be lau na bese idau-idau baina luludia lasi umui vairamui ai, bona emui tano hetoadia baina habada; asi tauna ta ese danu emui tano baine hekise-hekise henia, umui na laḡani ta ta amo nega toi toi Iehova emui Dirava vairanai ba dara dae bona ba toma henia diho negadia ai. ");
INSERT INTO meu_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Egu ihaboulaina rarana na flaoa ihatubuna muramurana ida basio bulodia. Lagau-hanai Ariana bahuna na basine mia rani. ");
INSERT INTO meu_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Emui mua anidia roboadia na Iehova emui Dirava ena ruma ba laohai, boubou ḡaudia ai baela. Nani natuna na sinana ratana ai basio nadua. ");
INSERT INTO meu_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Iehova ese Mose e hamaoroa, eto, Ini hereva ba tore, badina be ini hereva amo lau na oi bona Israel taudia ida vada tame herohemaino. ");
INSERT INTO meu_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Dina hari-ahui boi hari-ahui ia na Iehova ida e nohova unuseni ai, aniani se ania bona ranu se inua. Una negana ai ia ese hari herohemaino herevadia na huro-nadidia palakadia ai e tore: taravatu gwautaosi. ");
INSERT INTO meu_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mose na Sinai ororona amo e hekei diho, mai taravatu nadidia ruaosi, imana ai e kadidiha. Una negana ai ia na se diba vairana vada e hururu-hururu, Dirava ida e hereva hereva dainai. ");
INSERT INTO meu_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","A Aaron bona Israel taudia iboudiai ese Mose e itaia, vairana e hururu-hururuva, bena iraka-kahi-henina e gari. ");
INSERT INTO meu_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","A Mose ese e boiridia, bena Aaron bona hebou igunalaina taudia e raka henia kahi; bena Mose ese e hereva henidia. ");
INSERT INTO meu_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Gabeai Israel taudia iboudiai ese e raka henia kahi; bena Iehova ese Sinai ororona ai e henia haheḡanidia iboudiai na Mose ese e gwaurai henidia. ");
INSERT INTO meu_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ena hereva e hadokoa, bena vairana na dabua amo e ḡovaia ahu. ");
INSERT INTO meu_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","A Iehova ihereva-henina totona e raka vareai negadia ai, Mose ese dabua na vairana amo e kokia oho. Bena e raka lasi negadia ai, ia ese e kamonai haheḡanidia na Israel taudia e gwaurai henidia. ");
INSERT INTO meu_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","A Israel taudia na Mose vairana e itaia, kopina vada e hururu-hururu; taunabunai, mose na vvairana ma e ḡovaia ahu ela bona Iehova ihaere-henina totona e raka vareai lou. ");
INSERT INTO meu_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mose ese Israel hegogona idoinai e haheboudia, e haḡanidia, eto, Iehova ena hahe-gani emui ai bini: ");
INSERT INTO meu_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Dina taura-toi ba ḡaukara, a dina ihahituna na baine helaḡa emui ai, Dina Helaḡa bona laḡa-ani dinana ai bainela, Iehova ena; una dina ai baine ḡaukara tauna na bavalaia. ");
INSERT INTO meu_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Lahi be basio ha-ara emui ruma ai Dina Helaḡa ai. ");
INSERT INTO meu_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mose ese Israel hegogona idoinai ma e haḡanidia edia hebou ai, eto, Iehova ena hahedua binai: ");
INSERT INTO meu_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","emui herahia ḡaudia ba hulala, Iehova ena. Taigadia nanamo taudia iboudiai ese edia herehia bae mailai: gold bona silver bona auri labora-labora; ");
INSERT INTO meu_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","dabua vaiuridia bona mia-kakadia bona kakakakadia bona kurokurodia; nani huidia; ");
INSERT INTO meu_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","mamoe kopidia, e hakakakakadia ḡaudia, bona nani kopidia; kela audia; ");
INSERT INTO meu_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","lamepu dehorona, bona dehoro helaḡana muramuradia, bona muramura mai bonadia, bae gabu ḡaudia; ");
INSERT INTO meu_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","onuku nadidia, bona hahelaḡa taudia edia hahedoki bona edia vaina ihaheralaidia nadidia. ");
INSERT INTO meu_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Bena karakara taudia iboudiai bae hebou, Iehova vada e haḡanilai ḡaudia iboudiai bae kara: dubu ");
INSERT INTO meu_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","mai kalagana bona mai guhina ida; ena igau bona ena haba kahadia bona ena raroraro bona ena du, mai ihahelai-kaudia ḡaudia ida; ");
INSERT INTO meu_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","maua helaḡana, mai ikaruhina bona mai ena maduna ida, bona iseseahulaina seseahuna; ");
INSERT INTO meu_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","pata helaḡana, mai ena maduna bona mai ena kohu idoinai ida, bona flaoa helaḡana; ");
INSERT INTO meu_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","lamepa patana mai ena kohu idoinai, bona ena lamepa bona ena lamepa dehorona; ");
INSERT INTO meu_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","muramura patana mai ena maduna ida, bona dehoro helaḡana, bona muramura mai bonaida; dubu iduarana seseahuna; ");
INSERT INTO meu_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ihaboulaina patana mai iha-aukana auri labora-laborana, mai ena maduna bona ena kohu idoinai ida; auri labora-labora dihuna, mai ihahelai-kauna ḡauna ida; ");
INSERT INTO meu_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","maḡu dabuadia, bona maḡu duna mai ihahelai-kaudia ḡaudia ida, bona maḡu ikoukouna seseahuna; ");
INSERT INTO meu_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","dubu bona maḡu ikokodia, mai kwanaudia ida; ");
INSERT INTO meu_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","gabu helaḡana dabuadia mai heraheradia ida, bona Aaron, hahelaḡa tauna, ena dabua helaḡadia, bona ia natuna hahelaḡa karadia bae kara negadia ai bae doki dabuadia. ");
INSERT INTO meu_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Bena Israel hegogona idoinai e didi karoho, Mose vairana amo e raka oho. ");
INSERT INTO meu_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Bena taigadia nanamo taudia na laumadia ese e hagoadadia heḡereḡerena ta ta ena herahia ena herahia e mailai, Iehova ena, hebou kalagana ḡaudia bona kohudia bona dabua helaḡadia ikaralaidia ḡaudia. ");
INSERT INTO meu_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Idia na ema, lalo-namo tataudia bona hahinedia iboudiai, gold ḡaudia idau-idau e mailai: pini bona gadei bona vaḡivaḡi bona ageva. Ibouboudiai ese edia gold e herahialai, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Mai edia dabua taudia danu, vaiurina eiava mia-kakana eiava kakakakana eiava kurokurona, vada e heni. Haida danu nani huidia bona mamoe kopidia, e hakakakakadia ḡaudia, bona nani kopidia e heni. ");
INSERT INTO meu_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Mai edia silver bona mai edia auri labora-labora taudia iboudiai ese danu edia silver eiava edia auri labora-labora Iehova e henia. Bona mai eida kela audia, una ḡaukara heḡereḡerena, taudia iboudiai ese e heni. ");
INSERT INTO meu_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Dabua ḡaukaradia mai dibadia hahinedia iboudiai ese danu dabua e hatu, bena imadia ḡaukaradia e heni: dabua vaiuridia bona mia-kakadia bona kakakakadia bona kurokurodia. ");
INSERT INTO meu_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Bona mai dibadia hahinedia ese nani huidia e moḡe, bena e hatu. ");
INSERT INTO meu_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Iduhu lohiadia ese onuku nadidia, bona hahelaḡa taudia edia hahedoki bona edia vaina ihaheralaidia nadidia, ");
INSERT INTO meu_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","bona muramura, bona lamepa dehorona, bona dehoro helaḡana, bona muramura mai bonadia, e heni. ");
INSERT INTO meu_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Israel taudia bona hahinedia iboudiai ese edia lalo-namo dainai edia herahia ḡaudia Iehova e henia, Iehova ese Mose e haḡanilaia ḡaukaradia ikaradia totona. ");
INSERT INTO meu_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Bena Mose ese Israel taudia e hamaorodia, eto, A itaia, Iehova ese Besalele, Uri natuna, Huru tubuna, Iuda iduhuna tauna, vada e abia hidi. ");
INSERT INTO meu_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Dirava ena Lauma ese vada e rohea, lalo-parara bona aonega vada e henia, bona ima karakara daladia idau-idau vada e hadibaia; ");
INSERT INTO meu_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ḡau namo-hereadia ikaradia daladia baine haero, gold amo bona silver amo bona auri labora-labora amo baine kara. ");
INSERT INTO meu_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Herehera nadidia iutudia danu, bona au ikorodia, bona ima karakara daladia iboudiai baine diba. ");
INSERT INTO meu_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Siahu danu ia vada e henia, bona Oholiab, Ahisamaka natuna, Dan iduhuna tauna, danu vada e henia, raruosi ese haida ma bae hadibadia ini ḡaukara ai. ");
INSERT INTO meu_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Aonega vada e henidia, ima karakara daladia iboudiai bae haero bona bae kara; dabua ḡaukaradia danu bae diba: dabua vaiuridia bona mia-kakadia bona kakakakadia bona kurokurodia bae hatu bona bae turi. Ima karakara ḡaudia iboudiai bae haero ḡoevaḡoeva bona bae kara ḡoevaḡoeva. ");
INSERT INTO meu_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Benaini, Besalele bona Oholiab bona karakara taudia, Iehova ese lalo-parara bona aonega vada e henidia taudia, iboudiai ese ḡaukara bae matamaia, dubu do bae karaioa, Iehova ena hahedua heḡereḡeredia. ");
INSERT INTO meu_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Bena Mose ese Besalele bona Oholiab e boiridia, bona karakara taudia, Iehova ese lalodia vada e hapararadia bona lalodia e urava una ḡaukara bae durua taudia, iboudiai e boiridia. ");
INSERT INTO meu_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Bena idia ese Israel taudia edia herahia ḡaudia iboudiai, dubu ḡaukarana idurulaina ḡaudia, na Mose ena amo e abi. A herahia ḡaudia haida be daba iboudiai ma e laohai, e henia; ");
INSERT INTO meu_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ela bona karakara taudia iboudiai, dubu e ḡaukaralaiava taudia, ese edia ḡaukara e rakatani, ");
INSERT INTO meu_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Mose e hamaoroa, eto, Taunimanima edia herahia na Iehova ena hahedua ḡaukaradia vada e davana vaitani bona vada e hanaia danu. ");
INSERT INTO meu_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Taunabunai, Mose na e haheḡani, bona ena haheḡani vada e hapiua taruha idoinai; eto, Tau ta eiava hahine ta herahia ḡauna ta basine mailaia, dubu ena. Taunabunai, taunimanima ese herehia ihenina e hadokoa; ");
INSERT INTO meu_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","badina be vada e heni ḡaudia vada davana, una ḡaukara ena, bona orena baine mia e tomava. ");
INSERT INTO meu_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Bena karakara taudia ese dubu dabuadia gwautaosi e kara, dabua aukadia bona namodia, vaiuridia bona mia-kakadia bona kakakakadia; ihaheralaidia be kerubi laulaudia e turi. ");
INSERT INTO meu_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Dabua ta ena lata be kiubit ruahui taurahani, lababana be kiubit hani, iboudiai edia lata vada e heḡereḡere bona edia lababa danu vada e heḡereḡere. ");
INSERT INTO meu_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Dabua ima e siriudia, ma ima e siriudia. ");
INSERT INTO meu_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Bena imaosi ta isena ai, kunipa varo vaiurina amo e kara; ma imaosi ta isena ai danu unu e kara toma. ");
INSERT INTO meu_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Dabua ta ia kunipa imahui e kara, ma dabua ta ai imahui: hari kunipa vada e hevaira heheni. ");
INSERT INTO meu_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Bena hakapu-tao ḡaudia imahui gold amo e kara, dabua isedia ruaosi na unu hakapu-tao ḡaudia amo e hakapudia tao hesiriu, dubu tamona ai e halaoa. ");
INSERT INTO meu_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Una murinai dabua haida nani huidia amo e kara, dubu daena kalagana ena: unu dabua iboudiai be gwauta-ta. ");
INSERT INTO meu_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Dabua ta ta edia lata na kiubit toi-ahui, lababadia na kiubit hani; iboudiai edia lata vada e heḡereḡere, bona edia lababa danu vada e heḡereḡere. ");
INSERT INTO meu_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Unu dabua ima e siriudia, ma tauratoi e siridia. ");
INSERT INTO meu_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Bena imaosi ta isena ai kunipa imahui e kara, ma tauratoiosi ta isena ai kunipa imahui e kara. ");
INSERT INTO meu_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Bena hakapu-tao ḡaudia imahui auri labora-labora amo e kara, dabua isedia ruaosi na unu hakapu-tao ḡaudia amo e hakapudia tao hesiriu, kalaga tamona ai e halaoa. ");
INSERT INTO meu_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Bena kalaga guhina danu e karaia, mamoe kopidia, e hakakakakadia ḡaudia, amo; ma guhi ta danu, nani kopidia amo e karaia, ia latanai ma e atoa kau. ");
INSERT INTO meu_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Dubu habana kahadia na kela audia amo e kara. ");
INSERT INTO meu_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Kaha ta ena lata be kiubit gwauta, bona ena lababa be kiubit ta mai kahana. ");
INSERT INTO meu_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Hari kaha ta ta be ikoko rua rua amo e kokodia heririu; dubu habana kahadia iboudiai unu e kokodia hesiriu toma. ");
INSERT INTO meu_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Hari dubu habana kahadia iboudiai na ini e haginidia toma: diho kahana ai kaha ruahui e haginidia. ");
INSERT INTO meu_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Hahelai-kau ḡaudia hari-ahui silver amo e kara; bena hahelai-kau ḡaudia rua rua kaha ta ta henudiai e atodia bona e kokodia tao. ");
INSERT INTO meu_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ma dubu kahana ta, mirigini kahana ai, kaha ruahui ma e haginidia, ");
INSERT INTO meu_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","mai silver hahelai-kau ḡaudia hari-ahui, kaha ta ta henudiai hahelai-kau ḡaudia rua rua. ");
INSERT INTO meu_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Dubu duduna, lahara kahana ai, kaha tauratoi e haginidia; ");
INSERT INTO meu_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","bona daiguni ruaosi danu kaha ta ta, dubu duduna ena. ");
INSERT INTO meu_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Hari daiguni ḡaudia na henu ai e kokodia hesiriu, a atai ai idia na ring amo e hesiriu; unuhetomadia rua e kara, daiguni ḡaudia ruaosi ai e halaodia. ");
INSERT INTO meu_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Taunabunai, kaha na taurahani bona silver hahelai-ku ḡaudia na gwauta tauratoi, kaha ta ta henudiai hahelai-kau ḡaudia rua rua. ");
INSERT INTO meu_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Raroraro danu kela audia amo e kara, au-ima dubu habana kahana ena, ");
INSERT INTO meu_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ma au-ima dubu habana kahana ena, ma au-ima dubu duduna ena, lahara kahana ai. ");
INSERT INTO meu_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Bogaragi rarorarona na kaha iboudiai e hahesiriudia, duduna ela bona duduna. ");
INSERT INTO meu_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Hari kaha na gold amo e ḡovadia; raroraro idogo-taodia ring-dia na gold amo e kara, bona raroraro na gold amo e ḡovadia. ");
INSERT INTO meu_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Bena seseahu na dabua aukana bona namona amo e karaia, vaiurina bona mia-kakana bona kakakakana, bona kerubi laulaudia e turi, ia ihaheralaina. ");
INSERT INTO meu_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ena ihua-ihua hani kela audia amo e kara, bona gold amo e ḡovadia. Gold igaudia danu e kara, bona silver hahelai-kau ḡaudia hani. ");
INSERT INTO meu_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Kalaga iduarana seseahuna danu dabua aukana bona namona amo e karaia, vaiurina bona mia-kakana bona kakakakana; bona ihaheralaina danu e turi. ");
INSERT INTO meu_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Seseahu ena ihua-ihua ima e kara, mai igaudia. Hari ihua-ihua kwaradia na gold amo e ḡovadia, bona ihua-ihua na gold amo e kapadia heḡeḡe. A edia hahelai-kau ḡaudia imaosi na auri labora-labora amo e kara. ");
INSERT INTO meu_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besalele ese maua helaḡana danu e karaia, kela reireidia amo; latana na kiubit rua mai kahana, lababana na kiubit ta mai kahana, bona harana ena lata na kiubit ta mai kahana. ");
INSERT INTO meu_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Lalona kahana na gold amo e lahasia, bona murina kahana na gold amo e ḡovaia, bona gold amo e haheraia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ring hani na gold amo e kara, maua daigunina haniosi ai e koko kau, kahana ai rua kahana ai rua. ");
INSERT INTO meu_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Maduna danu e kara, kela audia amo, bona gold amo e ḡovadia. ");
INSERT INTO meu_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Unu maduna na ring amo e toi hanai, maua kahana kahana ai, ihualaina ḡaudia ai baela totona. ");
INSERT INTO meu_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Ikaruhina danu e karaia, gold namo-hereana amo; ena lata na kiubit rua mai kahana, ena lababa na kiubit ta mai kahana. ");
INSERT INTO meu_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Kerubi rua danu e kara, gold amo e korodia, hari ikaruhi duduna duduna ai, ");
INSERT INTO meu_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ta duduna ta ai ma ta duduna ta ai. Idia na ikaruhi ida gold siri tamona amo e kara. ");
INSERT INTO meu_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Hari kerubi na hanidia amo ikaruhi e hakerukerua; e hevaira heheni, bona ikaruhi danu e vaira henia. ");
INSERT INTO meu_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Pata ta danu kela audia amo e karaia; latana na kiubit rua, lababana na kiubit ta, harana ena lata na kiubit ta mai kahana. ");
INSERT INTO meu_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Gold amo e ḡovaia bona e haheraia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Digina danu e karaia, lababana na tau ta imana palapalana heḡereḡerena; ia danu gold amo e haheriaia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ring hani danu gold amo e kara, pata aena haniosi ai e koko kau; ");
INSERT INTO meu_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","hari ring be pata digina henuanai e koko kau, maduna audia bae hetoi hanai totona. ");
INSERT INTO meu_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Maduna danu kela audia amo e kara, bona gold amo e ḡovadia, pata ihualaina. ");
INSERT INTO meu_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Pata ḡaudia danu, mereki bona nau bona bio bona udu-ahudia keheredia, iboudiai na gold namo-hereana amo e kara. ");
INSERT INTO meu_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Lamepa patana danu e karaia, gold namo-hereana amo. Aena bona duna na gold amo e koro: aena bona duna bona kehere bona heraherana, bure bona huahua, iboudiai na gold siri tamona amo e koro. ");
INSERT INTO meu_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Rigina na tauratoi, kahana toi kahana toi. ");
INSERT INTO meu_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Rigi ta ena kehere na toi, itadia na sakada huahuadia na heto, ta ta mai buredia bona mai huahuadia, rigi iboudiai. ");
INSERT INTO meu_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Duna ai danu kehere na hani, sakada huahuadia na heto, ta ta mai buredia bona mai huahuadia. ");
INSERT INTO meu_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Rigi rua tua amo danu buredia ta ta e koro: rigi rua bure ta, rigi rua bure ta, rigi rua bure ta, rigidia henudia kahadia ai. ");
INSERT INTO meu_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Hari rigi bona bure na gold namo-hereana sirina tamona amo e koro. ");
INSERT INTO meu_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Bena lamepa hitu e kara, bona ihaḡoevadia ḡaudia bona momoru iudadia merekidia, iboudiai na gold namo—hereana anmo e kara. ");
INSERT INTO meu_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Hari lamepa patana mai kohuna idoinai ikaralaina gold-na ena metau be talent ta. ");
INSERT INTO meu_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Bena pata helaḡana ta e karaia, muramura mai bonaida igabudia ḡauna: kela audia amo e karaia. Ena lata bona ena lababa na heḡereḡere, kiubit tamona; harana ena lata na kiubit rua; doana na ia ida au tamona amo e koro. ");
INSERT INTO meu_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Kopina na gold namo-hereana amo e ḡovaia, pata bona aena bona doana; bona digina na gold amo e haheraia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ring rua danu gold amo e kara, pata digina henunai e kokodia kau, ta pata kahana ai, ma ta kahana ai, maduna itoi-hanaidia ḡaudia, bae huaia negadiai. ");
INSERT INTO meu_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Maduna rua danu e kara, kela audia amo, bona gold amo e ḡovadia. ");
INSERT INTO meu_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Dehoro helaḡana danu e karaia, bona muramura mai bonadia e bulo, bae gabua ḡauna, muramura ikarana tauna korikori ese e karaiamu heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ihaboulaina patana ia ese e karaia, kela audia amo; latana na kiubit ima, lababana na kiubit ima, harana ena lata na kiubit toi. ");
INSERT INTO meu_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Doa hani e koro, pata daigunina haniosi ai; hari doa na pata ida au tamona amo e kara. Kopina idoinai na auri labora-labora amo e ḡovaia. ");
INSERT INTO meu_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Kohuna idoinai danu auri labora-labora amo e kara: kahuna iudalaina urodia bona ikadolaina gagana bona dihu bona kahi bona rahurahu. ");
INSERT INTO meu_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Pata digina na auri labora-labora amo e ha-aukaia heḡeḡe; hari auri labora-laborana na pata e ḡeḡea ahu, bona digina harana kahana ai e diho. ");
INSERT INTO meu_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ring hani danu auri labora-labora amo e kara, hari iha-aukana auri labora-laborana ena daiguni haniosi ai, maduna bae hetoi hanai totona. ");
INSERT INTO meu_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Maduna danu kela audia amo e kara, bona auri labora-labora amo e ḡovadia. ");
INSERT INTO meu_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Hari maduna na ring amo e toidia hanai, ihaboulaina patana kahana kahana ai, ihulaina ḡaudia ai baela totona. Ihaboulaina patana na maua na heto e karaia, harana na reirei amo e koua. ");
INSERT INTO meu_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Dihu ta danu auri labora-labora amo e karaia, mai ihahelai-kauna ḡauna, ia danu auri labora-labora. Hari dihu mai ihahelai-kauna ḡauna ida na hebou kalagana iduarana ai e gimava hahinedia edia auri labora-labora hevarivaridia amo e karaia. ");
INSERT INTO meu_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Dubu maḡuna danu e karaia. Diho kahana ai itautau dabuadia aukadia e tau dae, edia lata idoinai kiubit sinahu-ta. ");
INSERT INTO meu_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Du be ruahu; bona hahelai-kau ḡaudia danu ruahui, auri labora-labora amo e kara. Igau bona hakapu-tao ḡaudia na silver amo e kara. ");
INSERT INTO meu_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Mirigina kahana ai danu itautau dabuadia e tau dae, edia lata idoinai na kiubit sinahu ta. Auri labora-labora dudia bona hahelai-kau ḡaudia na ruahui, mai silver igaudia bona hakapu-tao ḡaudia. ");
INSERT INTO meu_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Lahara kahana ai itautau dabuadia e tau dae, edia lata idoinai na kiubit imahui. Du bona hahelai-kau ḡaudia na gwauta; igau bona hakapu-tao ḡaudia be silver. ");
INSERT INTO meu_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Mairiveina kahana ai maḡu lababana be kiubit imahui: ");
INSERT INTO meu_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ikoukou kahana ai itautau dabuadia edia lata na kiubit gwauta-ima, mai du toi bona ihahelai-kaudia ḡaudia toi; ");
INSERT INTO meu_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ma ikoukou kahana ai itautau dabuadia edia lata na kiubit gwauta-ima, mai du toi bona ihahelai-kaudia ḡaudia toi. ");
INSERT INTO meu_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Hari dabua iboudiai be dabua namodia bona aukadia. ");
INSERT INTO meu_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Du edia hahelai-kau ḡaudia be auri labora-labora; edia igau bona edia hakapu-tao ḡaudia na silver. Hari du kwaradia na silver amo e ḡovadia, bona du be silver amo e kapadia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ikoukou dabuana na vaiuri bona mia-kaka bona kakakaka, varo aukana amo e turi, bona heraherana danu e turi. Ena lata na kiubit ruahui, bona harana ena lata na kiubit ima, maḡu dabuadia heḡereḡeredia. ");
INSERT INTO meu_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ia duna be hani, mai ihahelai-kaudia ḡaudia danu hani, auri labora-labora ḡaudia. Edia igau na silver. Du kwaradia na silver amo e ḡovadia, bona du be silver amo e kapadia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Dubu ikokodia bona maḡu ikokodia iboudiai na auri labora-labora ikokodia mo. ");
INSERT INTO meu_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Hari dubu, taravatu dubuna, ikaralaina ḡaudia ihagaudia bini; Mose ena hahedua dainai e duahidia, Levi iduhuna taudia, Itamara, hahelaḡa tauna Aaron natuna, ese e gunalaia oreana, edia ḡaudara bunai. ");
INSERT INTO meu_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Besalele, Uri natuna, Huru tubuna, Iuda iduhuna tauna, ese ḡau iboudiai e kara, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Iduruna tauna be Oholiab, Ahisamaka natuna, Dan iduhuna tauna: ia be ima karakara ḡaukaradia ihaerodia bona ikaradia mai dibana, turituri ḡaukaradia danu, dabua vaiuridia bona mia kakadia bona kakakakadia bona kurokurodia ituridia, na mai dibana. ");
INSERT INTO meu_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Gold idoinai, taunimanima ese edia herahia ihenina ai e heni bena dubu ḡaukaradia idau-idau ai e ḡaukaralaia gold-na, ena metau be talent ruahui taurahani-ta sekele sinahu-hitu toi-ahui gabu helaḡana ena sekele heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Silver idoinai, hebou ai ladadia e tore taudia ese e heni ḡauna, ena metau be talent sinahu-ta sekele daha-ta sinahu-hitu hitu-ahui ima, gabu helaḡana ena sekele heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Beka ta ta na ladadia e tore taudia ta ta ese e heni; e heni taudia iboudiai na tatau domaga-tauratoi daha-toi sinahu-ima imahui, laḡani ruahui vada e hanai taudia. Una beka be gabu helaḡana ena sekele kahana heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Hari silver be talent sinahu-ta e ḡaukaralaia, dubu duna ihahelai-kaudia ḡaudia bona seseahu duna ihahelai-kaudia ḡaudia e karalai: hahelai-kau ḡauna ta talent ta, hahelai-kau ḡauna ta talent ta. ");
INSERT INTO meu_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","A silver sekele daha-ta sinahu-hitu hitu-ahui ima e ḡaukaralai, du igaudia e karalai, bona du kwaradia e ḡovalai, bona du e kapalai heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Auri labora-labora idoinai be talent hitu-ahui sekele daha-rua sinahu-hani. ");
INSERT INTO meu_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ina auri labora-labora amo hebou kalagana iduarana ena hahelai-kau ḡaudia e kara, bona ihaboulaina patana, bona ihaboulaina patana iha-aukana ḡauna, bona ihaboulaina patana kohudia iboudiai; ");
INSERT INTO meu_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","bona maḡu duna ihahelai-kaudia ḡaudia, bona maḡu ikoukouna ena hehelai-kau ḡaudia; bona dubu ikokodia bona maḡu ikokodia iboudiai. ");
INSERT INTO meu_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Dabua vaiuridia bona mia-kakadia bona kakakakadia amo gabu helaḡana ḡaukaradia ikaralaidia dabuadia e kara, bona Aaron ena dabua helaḡadia danu, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Hahedoki helaḡana e karaia, gold bona dabua vaiurina bona mia-kakana bona kakakakana bona kurokurona e karalaia. ");
INSERT INTO meu_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Hari gold na e hodoa ela bona vada e severa-severa herea, hena e utua, varo na heto, hari dabua vaiuridia bona mia-kakadia bona kakakakadia bona kurokurodia ihaheralaidia. ");
INSERT INTO meu_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Paḡa ḡaudia e kara, hahedoki vairana kahana bona murina kahana e hahesiriudia. ");
INSERT INTO meu_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Gaba ḡauna danu ḡau heḡereḡeredia ai e karaia, gold bona dabua vaiurina bona mia-kakana bona kakakakana bona kurokurona e karalaia, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Onuku nadidia e abi, nadi isedia na gold e moḡe ḡauna amo e kou heḡeḡe; bena nadi kopidia e ḡasidia, Israel natudia ladadia e tore. ");
INSERT INTO meu_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Bena unu nadi be hari hahedoki ena paḡa ḡaudia ai e atodia kau, helalo-tao ḡaudia ai baela, Israel natuna edia, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Hahelaḡa tauna ena vaina danu e karaia, hahedoki e karaia heḡereḡerena, gold bona dabua vaiurina bona mia-kakana bona kakakakana bona kurokurona e karalaia. ");
INSERT INTO meu_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Latana bona lababana na heḡereḡere, bona e ha-ere ruaia; latana bona lababana na tau ta imana palapalana heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Nadi hururu-hururudia ere hani e turi kau: ere ta ai sadio bona topasio bona barekete, ");
INSERT INTO meu_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ere iharuana ai samarago bona sapairo bona vasiga; ");
INSERT INTO meu_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ere ihatoina ai huakinto bona akate bona ametuso; ");
INSERT INTO meu_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ere ihahanina ai berulio bona onuku bona iaspi: iboudiai isedia na gold e moḡe ḡauna amo e koudia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Hari nadi hururu-hururudia na gwauta-rua, Israel natuna gwauta-raruosi heḡereḡeredia; nadi ta ta ai iduhu ta ta ladadia bae ḡasidia. ");
INSERT INTO meu_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Gold varodia na vaina ai e turi kau. ");
INSERT INTO meu_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Gold e moḡe ḡaudia rua bona gold ring-dia rua danu e kara, hari ring na vaina isena ruaosi ai e turi kau. ");
INSERT INTO meu_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Bena hari gold varodia rua na vaina ring-dia ruaosi ai e mata kau, ");
INSERT INTO meu_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","a varo dududia na hari gold e moḡe ḡaudia ruaosi ai e mata kau, unu amo hahedoki ena paḡa ḡaudia ai ma e mata kau. ");
INSERT INTO meu_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Bena gold ring-dia rua ma e kara, vaina laloma kahana ai vaina isena ruaosi ai e turi kau; ");
INSERT INTO meu_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ma ring rua e kara, hahedoki ai e turi kau, paḡa ḡaudia na hahedoki ida e hasiriudia gabudia ai, gaba ḡauna daenai. ");
INSERT INTO meu_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Bena vaina ring-dia bona hahedoki ring-dia e kwatu kubou, varo baiurina amo, bona gaba ḡauna ai danu e mata kau: unuhetomana vaina bona hahedoki na asie heruha, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Bena hahedoki badana na dabua vaiurina amo e karaia, ");
INSERT INTO meu_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","mai matuna bogaraginai, kwara gabuna, e karaia; matuna isena danu e turia, vaia hahedoki isedia e turimu heḡereḡerena, bae hedare na garina. ");
INSERT INTO meu_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Isena ai herahera e turi, rimono huahuadia na heheto, varo vaiuridia bona mia-kakadia bona kakakakadia bona kurokurodia e turilai; ");
INSERT INTO meu_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","bona padadia ai gold gabagabadia e turi kau: ");
INSERT INTO meu_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","gold gabagabana ta rimono huahuana ta gold gabagabana ta rimono huahuana ta, ela bona hahedoki isena e haheraia heḡeḡe, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Bena muri hahedokidia danu e kara, Aaron mai natuna ida edia, dabua aukana namo-hereana amo e kara; ");
INSERT INTO meu_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","bona Aaron ena kwara iḡeḡelaina dabuana bona kwara dabuadia namodia haida e kara; bona piribou na dabua aukadia amo e kara. ");
INSERT INTO meu_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Gaba ḡauna danu dabua aukana amo e karaia, bona heraherana na varo vaiuridia bona mia-kakadia bona kakakakadia amo e turi, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Bena kwara koronana mairina na gold namo-hereana amo e karaia, bona revarevana e ḡasia, ini e torea toma: HELAḠA IEHOVA ENA. ");
INSERT INTO meu_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Bena varo vaiurina kwara iḡeḡelaina dabuana ai e turia kau, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Taunabunai, hebou kalagana mai ena dubu ḡaukaradia iboudiai e ore vaitani. Iehova ese Mose e haḡania heḡereḡerena, Israel taudia na unu mo e kara toma. ");
INSERT INTO meu_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Bena ḡau iboudiai e laohai Mose dekenai: dubu; kalaga mai kohuna idoinai; ena igau; ena haba kahadia; ena raroraro; ena du, mai ihahelai-kaudia ḡaudia ida; ");
INSERT INTO meu_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","guhi, mamoe kopidia e hakakakakadia ḡauna; ma guhi ta, nani kopidia ḡauna; seseahu; ");
INSERT INTO meu_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","taravatu mauana mai ena maduna, bona mai ikaruhina; ");
INSERT INTO meu_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","pata helaḡana, mai ena kohu idoinai bona mai ena flaoa helaḡana; ");
INSERT INTO meu_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","lamepa patana, gold ḡoevaḡoeva e karalaia ḡauna, mai ena lamepa bona mai kohuna idoinai bona ena lamepa diaranuna; ");
INSERT INTO meu_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","pata helaḡana, gold ḡauna, mai ena dehoro helaḡana bona mai ena muramura mai bonaida; iduara dabuana; ");
INSERT INTO meu_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ihaboulaina patana, auri labora-labora ḡauna, mai iha-aukana auri labora-laborana, bona mai ena maduna, bona mai kohuna idoinai; hurihuri dihuna ai ihahelai-kauna ḡauna ida; ");
INSERT INTO meu_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","maḡu dabuadia; maḡu duna mai ihahelai-kaudia ḡaudia ida; ikoukou dabuana; varo bona ikoko; dubu bona hebou kalagana ḡaukaradia ikaralaidia ḡudia iboudiai; ");
INSERT INTO meu_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","gabu halaḡana dabuadia; Aaron mai natuna ida edia dabua helaḡadia, hahelaḡa karadia bae kara negadia ai bae doki ḡaudia. ");
INSERT INTO meu_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Iehova ese Mose e haḡania heḡereḡerena, Israel taudia na ḡaukara idoinai unu e haḡugurua toma. ");
INSERT INTO meu_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mose ese ḡaukara idoinai e itaia, bona vada e diba idia ese ḡau iboudiai vada e kara Iehova ena haheḡani heḡereḡerena. Bena Mose ese e hanamodia. ");
INSERT INTO meu_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Iehova ese Mose e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Hua gini-gunana dinana gini-gunana ai hebou kalagana mai dubuna ida ba hagini. ?");
INSERT INTO meu_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Lalonai taravatu mauana bavatoa bona ba sesea ahu. ");
INSERT INTO meu_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Pata helaḡana danu lalonai bavatoa, mai kohuna idoinai, ḡau ta ta ena gabu ena gabu ai. Lamepa patana danu lalonai bavatoa; bona ena lamepa ba ha-ara. ");
INSERT INTO meu_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Muramura patana, gold ḡauna, na taravatu mauana vairanai bavatoa; bena dubu ba sesea ahu. ");
INSERT INTO meu_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ihaboulaina patana na dubu vairanai bavatoa, hebou kalagana lalonai; ");
INSERT INTO meu_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","bona hurihuri dihuna, mai ranuna, na hebou kalagana bona ihaboulaina patana padadiai bavatoa. ");
INSERT INTO meu_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Maḡu dabuadia danu ba tau dae heḡeḡe, bona maḡu ba sesea ahu. ");
INSERT INTO meu_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Bena dehoro helaḡana bavabia, dubu mai kohuna idoinai ba nevaridia: unu ba hahelaḡadia toma, bena bae helaḡa. ");
INSERT INTO meu_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ihaboulaina patana danu mai kohuna ida ba nevaridia: unu ba hahelaḡadia toma; hari ihaboulaina patana baine helaḡa herea. ");
INSERT INTO meu_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Hurihuri dihuna danu mai ihahelai-kauna ḡauna ida ba nevaridia, vada bae helaḡa. ");
INSERT INTO meu_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Bena Aaron mai natuna ida hebou kalagana iduarana ai bae gini bou. Ba hadigudia; ");
INSERT INTO meu_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","bena Aaron na dabua helaḡadia do ba hadokilaia. Bena ba horoa, baine helaḡa; lauegu hahelaḡa tauna ai bainela. ");
INSERT INTO meu_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Natuna danu bavabidia, ba hadokilaidia; ");
INSERT INTO meu_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","bena ba horodia, tamadia o horoa heḡereḡerena, egu hahelaḡa taudia ai baela. Ihorodia dainai idia na hahelaḡa taudia ai baela, edia uru iboudiai, ela bona hanaihanai. ");
INSERT INTO meu_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mose na unu e kara toma. Iehova ese haḡania heḡereḡerena, unu mo e kara toma. ");
INSERT INTO meu_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Laḡani iharuana gini-gunana dina na gini-gunana ai dubu na e haginia. ");
INSERT INTO meu_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mose ese dubu e haginia: hahelaikau ḡaudia na gabudia ai e atodia; haba kahadia e hagini; raroraro e toi hanai; bona du e holo. ");
INSERT INTO meu_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Bena dubu na kalaga amo e koua heḡeḡe, bona guhi dabuana amo e ḡovaia ahu, Iehova ese e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Bena taravatu nadidia e abi, maua helaḡana ai e uda. Maua ena maduna e toi hanai, bona ikaruhina amo e karuhia ahu. ");
INSERT INTO meu_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Bena maua na dubu lalonai e huaia vareai, bona e sesea ahu, Iehova ese e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Pata helaḡana na hebou kalagana ai e atoa, dubu mirigini kahana ai, seseahu murimurinai; ");
INSERT INTO meu_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","bona flaoa helaḡana na pata latanai e dabaraia, Iehova vairanai, Iehova ese e haḡania heḡere=herena. ");
INSERT INTO meu_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Bena lamepa patana na hebou kalagana ai e atoa, pata helaḡana e havaira henia, dubu diho kahana ai; ");
INSERT INTO meu_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","bena lamepa e ha-ara Iehova vairanai, Iehova ese e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Bena muramura patana, gold ḡauna, na hebou kalagana ai e atoa, seseahu vairanai; ");
INSERT INTO meu_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","bona muramura mai bonadia ia latanai e gabu, Iehova ese e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Bena dubu e sesea ahu. ");
INSERT INTO meu_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Bena hebou kalagana dubuna iduarana vairanai ia ese ihaboulaina patana e atoa, bona ḡole-oho boubouna bona flaoa boubouna ia latanai e ato, Iehova ese e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Bena ihaboulaina patana bona hebou kalagana padadiai ia ese hurihuri dihuna e atoa, bona ranu e seia, ");
INSERT INTO meu_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mose bona Aaron bona Aaron natuna imadia bona aedia ihurilaidia ranuna. ");
INSERT INTO meu_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Hebou kalagana ai e raka vareai bona ihaboulaina patana e raka henia kahi negadia iboudiai idia na unu e digu tomava, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Bena maḡu dabuadia e tau dae heḡeḡe, dubu bona ihaboulaina patana e ḡeḡe ahu, bona e sesea ahu. Mose ena ḡaukara idoinai unu e haḡuḡurua toma. ");
INSERT INTO meu_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Bena ori ese hebou kalagana e ḡovaia ahu, bona Iehova diaridiarina ese dubu e hahonua. ");
INSERT INTO meu_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Taunabunai Mose na asi ena dala hebou kalagana ai baine raka vareai, badina be ori ese e ḡovaia ahu, bona Iehova diaridiarina ese dubu e hahonua. ");
INSERT INTO meu_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Edia laolao iboudiai ori ese dubu e daetania negadia ai, Israel taudia na e tore isi, edia laolao ela. ");
INSERT INTO meu_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","A ori ese e ḡovaia ahu negadia ai, idia na asie tore isi, asie laolao, ela bona ma e daetania. ");
INSERT INTO meu_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Badina be edia laolao iboudiai lalodiai Iehova ena ori ese dubu e ḡovaia ahu dina ai, bona hanuaboi ai lahi na ia lalonai, Israel taudia iboudiai vairadiai. ");
INSERT INTO meu_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Iehova ese Mose e boi henia, hebou kalagana amo, eto, ");
INSERT INTO meu_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Israel taudia ba hamaorodia, baoto: Tau ta ese Iehova baine boua, ia na boromakau serina amo eiava mamoe serina amo ena ihaboulaina ḡauna baine abia. ");
INSERT INTO meu_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Bema ḡole-oho boubouna na boromakau serina amo baine abia, ia eseboromakau maruanena asi bebeka-bebekana ta baine abia; baine laohaia, hebou kalagana iduarana ai baine alaia, Iehova ese baine abia dae helaorana. ");
INSERT INTO meu_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ia imana na lahi ese baine ḡolea oho ḡauna kwarana ai baine dau kau; bena Iehova ese ia bagunai baine abia dae, ena herohemaino ḡauna. ");
INSERT INTO meu_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ia ese boromakau maruanena baine alaia mase Iehova vairanai; bena Aaron natuna, hahelaḡa taudia, ese rarana bae abia, ihaboulaina patana latanai bona badinai bae nevaria heḡeḡe, hebou kalagana iduarana ai. ");
INSERT INTO meu_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Hari bae haḡolea oho ḡauna na bae kopaia, bena bae ivaia. ");
INSERT INTO meu_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Bena Aaron natuna, hahelaḡa taudia, ese lahi bae haraia ihaboulaina patana latanai, bona rakuraku audia lahi ai bae ato kau. ");
INSERT INTO meu_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Bena Aaron natuna, hahelaḡa taudia, ese hidiona e iva ḡaudia bona kwarana bona digarana na rakuraku audia latadiai bae ato kau, ihaboulaina patana latanai; ");
INSERT INTO meu_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","a bogarauna bona imana bona aena na ranu ai bae huridia guna. Bena idoinai be hahelaḡa tauna ese baine gabua, ihaboulaina patana latanai, haḡole-oho ḡauna ai bainela lahi ai, bonana namo ḡauna Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Bema ena ḡole-oho boubouna baine heni ḡauna na mamoe serinaeiava nani serina amo baine abia, ia ese maruane ta, asi bebeka-bebekana, baine abia. ");
INSERT INTO meu_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ihaboulaina patana mirigini kahana ai baine alaia mase, Iehova vairanai. Bena Aaron natuna, hahelaḡa taudia, ese rarana bae abia, ihaboulaina patana latanai bona badinai bae nevaria heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Bena baine ivaia; bena hidiona e iva ḡaudia bona kwarana bona digarana na hahelaḡa tauna ese rakuraku audia latadiai baine ato kau, ihaboulaina patana ai. ");
INSERT INTO meu_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","A bogarauna bona imana bona aena na ranu amo baine huridia guna. Bena idoinai be hahelaḡa tauna ese baine gabua, ihaboulaina patana latanai, heḡole-oho ḡauna ai bainela lahi ai, bonana namo ḡauna Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Bema ena boubou ḡauna, Iehova ena, be manu baine haḡole-oho, ia na kerea eiava pune natuna baine abidia. ");
INSERT INTO meu_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Bena hahelaḡa tauna ese manu na baine laohaia, ihaboulaina patana badibadinai aiona baine moḡea. Bena ihaboulaina patana latanai lahi ese baine ḡolea oho; a rarana be ihaboulaina patana isena ai baine seia. ");
INSERT INTO meu_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Bogarauna bona huina na baine abidia, ihaboulaina patana mairiveina kahana ai baine negedia, lahi kahuna e negeamu gabuna ai. ");
INSERT INTO meu_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Hanina amo baine darea parara; basine ivaia. Hahelaḡa tauna ese rakuraku audia latadiai baine gabua, ihaboulaina patana latanai, heḡole-oho ḡauna ai bainela lahi ai, bonana namo ḡauna Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Ta ese flaoa boubouna baine mailaia, Iehova ena, ia na flaoa namo-hereana baine abia, latanai dehoro baine seia, bona muramura mai bonana danu ia latanai baine atoa kau. ");
INSERT INTO meu_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Baine mailaia Aaron natuna, hahelaḡa taudia, dekediai; bena flaoa mai dehorona taina bona muramura mai bonana idoinai baine abi; bena hahelaḡa tauna ta ese ihaboulaina patana latanai baine gabu, lahi ese baine ḡole-oho. Una na helalo toana, ḡole-oho boubouna, bonana namo ḡauna Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","A flaoa boubouna orena na Aaron mai natuna ida adia; Iehova ena ḡole-oho bouboudia iboudiai ia mo helaḡa herea. ");
INSERT INTO meu_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Flaoa amu ai o gabua ḡauna boma mailaia emu boubou ḡauna, ia na flaoa namo-hereana amo ba karaia; ihatubuna muramurana basio abia, a flaoa na dehoro ida ba bulo, eiava ba gabua kava, murinai dehoro ia latanai ba seia. ");
INSERT INTO meu_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Eiava ataga boma mailaia emu boubou ḡauna, ia danu flaoa namo-hereana amo ba karaia; ihatubuna muramurana basio abia, a flaoana dehoro ida ba bulo. ");
INSERT INTO meu_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Ba bakia sisi sisi, latanai dehoro ba seia: ia na flaoa boubouna. ");
INSERT INTO meu_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Eiava emu boubou flaoana na uro ai boma nadua, ia danu flaoa namo-hereana amo ba karaia, mai dehorona. ");
INSERT INTO meu_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Flaoa boubouna na unu ba karaia toma, bena Iehova enai ba mailaia, hahelaḡa tauna ese baine abia, ihaboulaina patana vairanai baine laohaia. ");
INSERT INTO meu_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Bena hahelaḡa tauna ese flaoa boubouna amo helalo toana baine abia, ihaboulaina patana ai baine gabua, ḡole-oho boubouna ai bainela, bonana namo ḡauna Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Flaoa boubouna orena na Aaron mai natuna ida adia; Iehova ena ḡole-oho bouboudia iboudiai ia mo helaḡa herea. ");
INSERT INTO meu_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Flaoa boubouna mai ihatubuna muramurana basio mailaia Iehova enai; hatubu muramurana eiava bada-ranuna na boubou ḡauna ai basio halaoa, Iehova ena ihaboulaina patana lahina ai basio gabua. ");
INSERT INTO meu_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Unu na kohu ikaroadia herahiana na ba laohai Iehova enai, to ihaboulaina patana ai basio gabudia, bonadia na unu amo basie dae. ");
INSERT INTO meu_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Emu flaoa bouboudia iboudiai na ba damenadia: emu flaoa boubouna na Iehova ena herohemaino damenana ai basie dabu; emu boubou iboudiai ida damena danu ba heni. ");
INSERT INTO meu_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Emu uit ba karoa, herahia karoana Iehova ba henia, negana ai, uit anidia do asie auka ḡaudia bavabi, lahi latanai ba hakaukaudia, bena ba gwadadia, kopidia ba nege. ");
INSERT INTO meu_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Bena latadiai dehoro ba seia, bona latadiai danu muramura mai bonana bavato kau: ia danu flaoa boubouna ḡauna. ");
INSERT INTO meu_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Bena hahelaḡa tauna ese uit taina bona dehoro taina baine abi, helalo toana, bona muramura mai bonana idoinai; ḡole-oho boubouna ḡauna ai bainela, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Tau ta ese herohemaino boubouna baine mailaia, bema boromakau maruanena eiava hahinena, ia na asi bebeka-bebekana ḡauna baine mailaia Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ia ese imana na ena boubou ḡauna kwarana ai baine atoa kau, bena baine alaia mase, hebou kalagana iduarana ai. Bena Aaron natuna, hahelaḡa taudia, ese rarana bae abia, ihaboulaina patana latanai bona badinai bae nevaria heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Herohemaino boubouna, lahi ese baine ḡolea oho ḡauna, baine heni negana ai, Iehova baine henia ḡaudia bini: boga bona bogarau urubina, ");
INSERT INTO meu_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","bona nadinadi ruaosi mai digaradia, bona demodo bona ase digarana. Ia ese baine abidia; ");
INSERT INTO meu_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","bena Aaron natuna ese ihaboulaina patana lahina latanai ḡole-oho boubouna ḡauna ida bae gabudia. Ia na ḡole-oho boubouna, bonana namo ḡauna Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Herohemaino boubouna baine mailaia, Iehova ena, bema mamoe eiava nani, ia na maruane eiava hahine asi bebeka-bebekana baine mailaia. ");
INSERT INTO meu_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Bema mamoe natuna baine heni, ena boubou, ia ese Iehova vairanai baine atoa, ");
INSERT INTO meu_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","imana na ena boubou ḡauna kwarana ai baine atoa kau, bena hebou kalagana vairanai baine alaia mase. Bena Aaron natuna ese rarana bae abia, ihaboulaina patana latanai bona badinai bae nevaria heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Ina herohemaino boubouna amo, lahi ese baine ḡolea oho ḡaudia, Iehova ena, baine abi ḡaudia bini: iuna mai digarana idoinai ida ela bona doru turiana, bona boga bona bogarau urubina, ");
INSERT INTO meu_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","bona nadinadi ruaosi mai digaradia, bona demodo bona ase digarana. ");
INSERT INTO meu_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Hahelaḡa tauna ese baine gabua, ihaboulaina patana latanai: ia na boubou anianina, ḡole-oho boubouna, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Bema nani baine heni, ena boubou, ia ese Iehova vairanai baine atoa, ");
INSERT INTO meu_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","imana na ena boubou ḡauna kwarana ai baine atoa kau, hebou kalagana vairanai baine alaia mase. Bena Aaron natuna ese rarana bae abia, ihaboulaina patana latanai bona badinai bae nevaria heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Ena boubou ḡauna amo, lahi ese baine ḡole oho ḡaudia, Iehova ena, baine abi, ḡaudia bini: boga bona bogarau urubina, ");
INSERT INTO meu_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","bona nadinadi ruaosi mai digaradia ida, bona demodo bona ase digarana. ");
INSERT INTO meu_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Hahelaḡa tauna ese baine gabua, ihaboulaina patana latanai; ia na boubou anianina, ḡole-oho boubouna, bonana namo ḡauna. Digara idoinai na Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Mia-hanaihanai taravatuna binai, emui uru iboudiai bona emui noho gabudia idoidiai lalodiai: digara bona rara basio ani. ");
INSERT INTO meu_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Iehova ese Mose na e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Israel taudia ba haduadia, baoto: Tau ta baine kara rea, Iehova ena taravatu ta baine tataia utu, ena boubou be iniheto. ");
INSERT INTO meu_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Bema hahelaḡa tauna, e horoa tauna, baine kara rea, unu amo orea taudia iboudiai na kara-rea taudia ai baine halaodia, ia ese boromakau natuna maruanena ta, asi bebeka-bebekana, na Iehova bainehenia, ena kara-rea boubouna. ");
INSERT INTO meu_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Ia ese hari boromakau natuna maruanena baine mailaia, hebou kalagana iduarana ai, Iehova vairanai; imana na kwarana ai baine atoa kau, bena baine alaia mase Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Bena hahelaḡa tauna, e horoa tauna, ese rarana baine abia, hebou kalagana lalonai baine vareailaia. ");
INSERT INTO meu_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Bena hahelaḡa tauna ese imana kwakikwakina na rara ai baine urua diho, nega hitu Iehova vairanai baine nevaria, gabu helaḡana seseahuna vairanai. ");
INSERT INTO meu_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Hahelaḡa tauna ese danu muramura mai bonana patana, hebou kalagana lalonai e miamu ḡauna, doana na rara taina amo baine dahudia, Iehova vairanai; bena rara orena na ihaboulaina patana, ḡole-oho boubouna ḡauna, badinai baine bubua nege, hebou kalagana iduarana ai. ");
INSERT INTO meu_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Bena ia ese kara-rea boubouna boromakauna digarana idoinai baine abia: boga bona bogarau urubina, ");
INSERT INTO meu_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","bona nadinadi ruaosi mai digaradia ida, bona demodo bona ase digarana; ");
INSERT INTO meu_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","herohemaino boubouna boromakauna enai e abiamu heḡereḡerena baine abia. Hahelaḡa tauna ese ihaboulaina patana latanai baine gabua, lahi ese baine ḡolea oho. ");
INSERT INTO meu_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","A boromakau kopina bona hidiona bona kwarana bona imana bona aena bona bogana bona bogarauna bona taḡena, ");
INSERT INTO meu_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","idoinai baine huaia Iasi taruha murimurinai, gabu ḡoevaḡoevana ai, lahi kahudia e negemu gabuna ai, baine gabua, Iahi ese baine ḡolea oho; Iahi kahudia e negemu gabuna ai baine heḡole-oho. ");
INSERT INTO meu_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Israel oreana idoinai bema kara rea, a edia kerere bema hehuni; Iehova ena taravatu bema tata utu, unu amo bema kerere: ");
INSERT INTO meu_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","edia kerere baine hedinarai negana ai, hebou ese boromakau natuna maruanena ta baine heni, kara-rea boubouna ai bainela. Hebou kalagana vairanai bae mailaia; ");
INSERT INTO meu_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","bena orea ena tau-badadia ese imadia na ia kwarana ai bae ato kau. Iehova vairanai, bena Iehova vairanai bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Bena hahelaḡa tauna, e horoa tauna, ese rarana baine abia, hebou kalagana lalonai baine vareailaia; ");
INSERT INTO meu_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","imana kwakikwakina na rara ai baine urua diho, nega hitu Iehova vairanai baine nevaria, seseahu vairanai, ");
INSERT INTO meu_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","bena pata helaḡana, hebou kalagana ai Iehova vairanai e miamu ḡauna, rara na doa baine dahulai; una murinai rara orena idoinai na ihaboulaina patana badinai baine bubua nege, hebou kalagana iduarana ai. ");
INSERT INTO meu_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Bena ia ese digarana idoinai baine abia, ihaboulaina patana ai baine gabua, lahi ese baine ḡolea oho. ");
INSERT INTO meu_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Hari kara-rea boubouna ta boromakauna e karalaia heḡereḡerena ai, ina boromakaudanu unu bae karaia toma; unu amo hahelaḡa tauna ese idia bagudiai herohemaino karana baine karaia, bena edia dika bae hegwau tao. ");
INSERT INTO meu_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","A boromakau na taruha murimurinai baine huaia lasi, hari boromakau ta e gabua heḡereḡerena ai ina danu baine gabua, lahi ese baine ḡolea oho. Hebou ena kara-rea boubouna bunai. ");
INSERT INTO meu_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Hanua lohiana ta bema kara rea, Iehova, ena Dirava, ena taravatu ta bema tataia utu, unu amo bema kerere: ");
INSERT INTO meu_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","lalona baine parara ia vada e kerere negana ai, ia ese nani maruanena asi bebeka-bebekana ta baine mailaia, ena boubou ḡauna; ");
INSERT INTO meu_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","imana na nani kwarana ai baine atoa kau, bena ḡole-oho bouboudia Iehova vairanai e aladia masemu gabuna ai bainealaia mase: ia be kara-rea boubouna. ");
INSERT INTO meu_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Bena hahelaḡa tauna ese boubouḡauna rarana baine abia, imana kwakikwakina amo ihaboulaina patana ai doa baine dahulai; bena rara orena na ihaboulaina patana badinai baine bubua nege. ");
INSERT INTO meu_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Bena digarana idoinai na ihaboulaina patana latanai bae gabua, herohemaino boubouna e karalaiamu heḡereḡerena; Iahi ese baine ḡolea oho. Unu amo hahelaḡa tauna ese ia bagunai herohemaino karana baine karaia; bena ena dika baine hegwau tao. ");
INSERT INTO meu_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Hanua tauna ta bema kara rea, Iehova ena taravatu ta bema tataia utu, unu amo bema kerere: ");
INSERT INTO meu_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","lalona baine parara vada e kerere negana ai, ia ese nani hahinena asi bebeka-bebekana ta baine mailaia, ena kara-rea boubouna ai bainela. ");
INSERT INTO meu_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Bena imana na ena kara-rea boubouna ḡauna kwarana ai baine atoa kau; bena ḡole-oho bouboudia e aladia masemu gabuna ai baine alaia mase. ");
INSERT INTO meu_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Bena hahelaḡa tauna ese rarana baine abia, imana kwakikwakina amo ihaboulaina patana, ḡole-oho boubouna ḡauna, doana baine dahulai; bena rara orena na ihaboulaina patana badinai baine bubua nege. ");
INSERT INTO meu_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Bena digarana idoinai baine abia, herohemaino bouboudia e karalaidia heḡereḡerena; bena hahelaḡa tauna ese ihaboulaina patana latanai baine gabua, lahi ese baine ḡolea oho, bonana namo ḡauna Iehova ena. Unu amo hahelaḡa tauna ese ia bagunai herohemaino karana baine karaia, bena ena dika baine hegwau tao. ");
INSERT INTO meu_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","A mamoe natuna bema mailaia, ena kara-rea boubouna, ia ese mamoe natuna hahinena asi bebeka-bebekana ta baine mailaia; ");
INSERT INTO meu_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","imana na enakara-rea boubouna kwarana ai baine atoa kau, bena ḡole-oho bouboudia e aladia masemu gabuna ai ena kara-rea boubouna ḡauna baine alaia mase. ");
INSERT INTO meu_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Bena hahelaḡa tauna ese kara-rea boubouna rarana baine abia, imana kwakikwakina amo ihaboulaina patana ai doa baine dahulai; bena rara orena na ihaboulaina patana badinai baine bubua nege. ");
INSERT INTO meu_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Bena digarana idoinai baine abia, herohemaino boubouna mamoena digarana e abiamu heḡereḡerena; bena hahelaḡa tauna ese ihaboulaina patana ai baine gabua, ḡole-oho bouboudia ida, Iehova ena. Unu amo hahelaḡa tauna ese ia bagunai baine herohemaino, bena ena dika baine hegwau tao. ");
INSERT INTO meu_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Tau ta ese e itaia ḡauna eiava mai dibana ḡauna bema herevalaia diba hahemaoro gabuna ai, to basine herevalaia, ia na baine kerere. ");
INSERT INTO meu_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Eiava tau ta baine taubu, ḡau mirona ta, e mase ḡauna tau-anina, uda boromana eiava heubu ḡauna eiava tano ai e raumu ḡauna, basine itaia haraḡa bena enai baine dau kau, ia na baine kerere. ");
INSERT INTO meu_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Eiava taunimanima edia miro ḡauna ta ai baine dau kau, to asi dibana; gabeamo lalona baine parara negana ai na baine kerere. ");
INSERT INTO meu_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Eiava tau ta baine gwau hamata kava, baineto kara dikana ta eiava kara namona ta baine karaia, se laloa namonamo dainai; gabeai lalona baine parara ia na basine karaia diba, ia na baine kerere. ");
INSERT INTO meu_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Unu baine kerere toma tauna ese ena kerere baine gwauraia hedinarai; ");
INSERT INTO meu_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","bona ena kerere boubouna baine mailaia Iehova dekenai, mamoe natuna hahinena ta eiava nani natuna hahinena ta ena seri amo, ena kara-dika boubouna. Bena hahelaḡa tauna ese ia bagunai herohemaino karana baine karaia, ena dika iabi-ohona. ");
INSERT INTO meu_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Imana bema tuna dainai mamoe natuna basinema mailaia diba, ia ese kerea rua eiava pune natuna rua baine mailaidia, ta kara-dika boubouna, ma ta ḡole-oho boubouna, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Ia ese hahelaḡa tauna dekena baine mailaidia. Bena hahelaḡa tauna ese kara-dika boubouna ḡauna baine abia guna, aiona baine moḡea, a basine ivaia parara. ");
INSERT INTO meu_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Rarana na ihaboulaina patana harana baine nevarilaia, bena rara orena na ihaboulaina patana badinai baine bubua nege: una na kara-dika boubouna. ");
INSERT INTO meu_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Bena manu iharuanana ḡole-oho boubouna ai bainela, taravatu heḡereḡerena. Unu amo hahelaḡa tauna ese ia bagunai herohemaino karana baine karaia, bena ena dika baine hegwau tao. ");
INSERT INTO meu_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Imana bema tuna dainai, kerea rua eiava pune natuna rua basinema mailaidia diba, ia ese flaoa namo-hereana efa ta baine karoaia, karoa gwauta, bena karoa ta baine mailaia, ena kara-dika boubouna. Dehoro basine seialatanai, bona muramura mai bonana na latanai basine atoa kau. ");
INSERT INTO meu_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Ia ese hahelaḡa tauna dekena baine mailaia; bena hahelaḡa tauna ese una flaoa kahana na imana ai baine abia, helalo toana, ihaboulaina patana ai baine gabua, Iehova ena ḡole-oho bouboudia ida; una na kara-dika boubouna. ");
INSERT INTO meu_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Unu amo hahelaḡa tauna ese ia bagunai herohemaino karana baine karaia, bena ena dika baine hegwau tao. A flaoa orena na hahelaḡa tauna ena, flaoa bouboudia haida heḡereḡeredia. ");
INSERT INTO meu_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Bena Iehova ese Mose ma e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Tau ta baine koikoi, Iehova ena helaḡa ḡaudia iḡaukaralaidia baine hakerere, ia ese ena kara-dika boubouna baine mailaia, Iehova dekenai: mamoe maruanena asi bebeka-bebekana ta ena seri ai baine abia. Davana danu oi ese ba haeroa, silver sekeledia ai, gabu helaḡana ena silver sekeledia heḡereḡeredia: una na kara-dika boubouna. ");
INSERT INTO meu_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Ḡaukara helaḡadia e hakerere davana danu baine heni, bona davana korikori latanai heato-kau ḡauna danu baine atoa kau; davana bema karoaia karoa ima, bena karoa ta heḡereḡerena ai heato-kau ḡauna unu baine atoa kau toma, hahelaḡa tauna baine henia. Bena hahelaḡa tauna ese ia bagunai herohemaino karana baine karaia, kara-dika mamoena amo; bena ena dika baine hegwau tao. ");
INSERT INTO meu_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Tau ta baine kara dika, Iehova ena taravatu baine tata utu, ena be asi dibana, to ia na mai ena kerere, bona ena kara dika davana baine heni. ");
INSERT INTO meu_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Ia ese mamoe maruanena asi bebeka-bebekana ta ena seri ai baine abia, baine mailaia hahelaḡa tauna dekenai; davana danu oi ese ba haeroa, ena kara-dika boubouna ai bainela. Unu amo hahelaḡa tauna ese kara dika taunaena kara dika bagunai herohemaino karana baine karaia; bena ena dika baine hegwau tao. ");
INSERT INTO meu_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ina na kara-dika boubouna; ia na Iehova vairanai vada e kara dika. ");
INSERT INTO meu_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Tau ta baine kerere, Iehova baine koia, bona dekena tauna ena kohu inarina ai baine koikoi, eiava abitorehai iheni-louna ai baine koikoi, eiava baine dadidadi, eiava dekena tauna baine hahisia, ");
INSERT INTO meu_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","eiava boio ḡauna baine davaria bena baine herevalaia koikoi eiava baine gwau hamatalaia koikoi: unu baine koikoi toma tauna ");
INSERT INTO meu_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","na mai ena kerere bona mai ena kara dika. Ia ese e dadihaia ḡauna, eiava taunimanima ihahisidia amo e abia ḡauna, eiava e henia baine naria ḡauna, eiava e davaria ḡauna, ");
INSERT INTO meu_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","eiava e gwau hamatalaia koikoi ḡauna, na una ḡau biaguna baine henia lou, mai ato-kauna ida: ato-kauna be una ḡau davanabema karoaia, karoa ima, bena karoa ta bema abia, ato-kauna na unubadana baine heni, ena kara-koikoi boubouna baine mailaia dinana ai. ");
INSERT INTO meu_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Bena ena kara-koikoi boubouna baine mailaia Iehova enai, mamoe maruanena asi bebeka-bebekana ta, ena seri amo, oi ese davana ba gwauraia ḡauna, hahelaḡa tauna baine henia. ");
INSERT INTO meu_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Bena hahelaḡa tauna ese ia bagunai herohemaino karana baine karaia, Iehova vairanai; unu amo ena kara dika idoinai baine hegwau tao. ");
INSERT INTO meu_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Aaron mai natuna verina ida ini ba haḡanidia toma. Ḡole-oho boubouna taravatuna binai: boubou ḡauna na ihaboulaina patana lahina latanai baine mia rani, lahi danu baine ara rani. ");
INSERT INTO meu_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Bena hahelaḡa tauna ese ena dabua bona ena piribou, dabua aukadia amo e kara ḡaudia, baine hadoki; bena ḡole-oho ḡauna kahuna na ihaboulaina patana latana amo baine abia oho, ihaboulaina patana badinai baine bubua. ");
INSERT INTO meu_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Bena ena dabua aukadia baine doki oho, dabua idaudia baine hadoki; bena kahu na taruha murimurinai baine laohaia, gabu ḡoevaḡoevana ta ai baine bubua. ");
INSERT INTO meu_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Ihaboulaina patana lahina na baine ara hanaihanai, basine bodo. Daba iboudiai hahelaḡa tauna ese rakuraku audia baine ato kau, ma ḡole-oho boubouna idia latadiai baine atoa kau; herohemaino boubouna digarana danu lahi ese baine ḡolea oho. ");
INSERT INTO meu_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Lahi na ihaboulaina patana latanai baine ara hanaihanai, basine bodo. ");
INSERT INTO meu_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Flaoa boubouna taravatuna binai: Aaron natuna ese Iehova vairanai bae mailaia, ihaboulaina patana vairanai. ");
INSERT INTO meu_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Hahelaḡa tauna ta ese boubou flaoana kahana mai dehorona imana ai baine abia, bona muramura mai bonana idoinai, ihaboulaina patana ai baine gabua, helalo toana ai bainela, bonana namo ḡauna Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Flaoa orena na Aaron mai natuna ida bae ania: asi ihatubuna bae ania, gabu helaḡana ai, hebou kalagana maḡuna lalonai. ");
INSERT INTO meu_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Ihatubuna muramurana ida basie buloa. Vada na henidia, idia ahudia ḡole-oho boubouna ai. Una na helaḡa herea, kara-rea bouboudia bona kara-koikoi bouboudia heḡereḡeredia. ");
INSERT INTO meu_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Aaron ena iduhu mamaruanedia iboudiai bae ania diba; una na idia ahudia Iehova ena ḡole-oho bouboudia ai, emui uru iboudiai ela bona hanaihanai. Baine daua toho tauna na baine helaḡa. ");
INSERT INTO meu_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Iehova ese Mose ma e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Aaron mai natuna ida ese Iehova ini bae boua toma, ia ihorona dinana ai: flaoa namo-hereana efa ta bae karoaia, karoa gwauta, karoa ta be flaoa boubouna ai bainela ela bona hanaihanai, kahana daba ai ma kahana adorahi ai. ");
INSERT INTO meu_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Dehoro ida bae buloa, ataga ai bae gabua. Bena oi ese ba mailaia, ba bakia, boubou ḡauna ai ba halaoa, bonana namo ḡauna Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Hahelaḡa tauna danu Aaron natuna edia amo bae abia hidi, tamana ibolona ai bae horoa, ia ese Iehova unu baine boua toma. Mia-hanaihanai taravatuna binai: idoinai bae gabua Iehova ena, lahi ese baine ḡolea oho. ");
INSERT INTO meu_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Hahelaḡa tauna ena flaoa boubouna be baine heḡole-oho vaitani; basie ania. ");
INSERT INTO meu_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Iehova ese Mose ma e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Aaron mai natuna verina ida ini ba haḡanidia toma. Kara-rea boubouna taravatuna binai: kara-rea boubouna ḡauna na Iehova vairanai bae alaia mase, ḡole-oho bouboudiaḡaudia e aladia masemu gabuna ai, ia na helaḡa herea. ");
INSERT INTO meu_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Hahelaḡa tauna ese baine hahelaḡaia, kara dika boubouna ai bainela, bena baine ania; gabu helaḡana ai, hebou kalagana maḡuna lalonai, baine ania. ");
INSERT INTO meu_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Hidiona baine daua toho tauna na baine helaḡa. Rarana na dabua ta ai baine hetuturu, una dabua na gabu helaḡana ai bae huria. ");
INSERT INTO meu_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Lalonai e nadua urona na bae hamakohia, eiava bema auri urona, bae kakasia bona ranu ai bae huria. ");
INSERT INTO meu_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Maruane iboudiai hahelaḡa taudia edia iduhu ai bae ania diba; ia na helaḡa herea. ");
INSERT INTO meu_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","A kara-rea bouboudia raradia na hebou kalagana lalonai bema vareailai, gabu helaḡana ai herohemaino ḡauna ai bae halaoa, dika iabi-ohona totona, ia be basie ania; idoinai lahi ese baine ḡolea oho. ");
INSERT INTO meu_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Kara-dika boubouna taravatuna binai: ia na helaḡa herea. ");
INSERT INTO meu_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Kara-dika boubouna ḡauna na bae alaia mase, ḡole-oho bouboudia ḡaudia e aladia masemu gabuna ai. Hahelaḡa tauna ese rara na ihaboulaina patana latanai bona badinai baine nevaria heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Digarana idoinai na boubou ḡauna ai bainela: iuna digarana, bona boga bona bogarau urubina, ");
INSERT INTO meu_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","bona nadinadi ruaosi mai digaradia ida, bona demodo, bona ase digarana. Idoinai baine abia, ");
INSERT INTO meu_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ihaboulaina patana latanai baine gabua, lahi ese baine ḡolea oho; ia na kara-dika boubouna Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Maruane iboudiai hahelaḡa taudia edia orea ai ese bae ania diba: gabu helaḡana ai bae ania: ia na helaḡa herea. ");
INSERT INTO meu_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Kara-rea boubouna bona kara-dika boubouna taravatudia na tamona: hahelaḡa tauna, herohemaino ḡauna ai baine halaoa tauna, ia ese anina baine abia. ");
INSERT INTO meu_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Hahelaḡa tauna ese tau ta ena ḡole-oho boubouna baine hahelaḡaia negana ai, ia ese boubou ḡauna, e hahelaḡaia ḡauna, kopina baine abia iena. ");
INSERT INTO meu_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Bona flaoa bouboudia, amu ai e guramu eiava uro ai e nadumu eiava ataga ai e gabumu, hahelaḡa tauna, una boubou ḡauna e hahelaḡaiamu tauna, ese baine abia iana. ");
INSERT INTO meu_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Flaoa boubouna, mai dehoro ida e buloa ḡauna, eiava flaoa kaukauna, ia danu Aaron natuna adia, unu haida heḡereḡeredia. ");
INSERT INTO meu_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Herohemaino bouboudia Iehova bae henia taravatuna binai. ");
INSERT INTO meu_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Tau ta ese hahenamo boubouna baine mailaia, ia na ena boubou ḡauna ida se hatubua flaoana dehoro ida e bulo dikeadia, bona se hatubua flaoana atagadia, latadiai dehoro e seia ḡaudia, bona flaoa namo-hereana dehoroida e buloa bena e gabua, baine mailai. ");
INSERT INTO meu_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ena herohemaino boubouna ida e hatubua bona e gabua flaoana danu baine mailaia, ena hahenamo boubouna. ");
INSERT INTO meu_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Herahia ta ta amo dikea eiava ataga eiava igabu ta ta bae dudui isi Iehova vairanai; bena hahelaḡa tauna, herohemaino boubouna rarana ihaboulaina patana ai baine nevaria tauna, baine abia iana. ");
INSERT INTO meu_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ena herohemaino bouboudia hidiodia, hahenamo ḡaudia, na bae hahelaḡadia dinana ai bae anidia, bahu taina basine mia rani. ");
INSERT INTO meu_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","A baine mailaia ḡauna, na gwau hamata dainai baine mailaia, eiava herahia ḡauna, bae hahelaḡaia dinana ai bae ania, ma bahu dina iharuana ai bae ania. ");
INSERT INTO meu_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","A boubou ḡauna hidiona taina baine mia ela bona dina ihatoina, una na lahi ai bae haḡolea oho. ");
INSERT INTO meu_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Bema herohemaino boubouna hidiona na dina ihatoina ai bae ania, Iehova ese basine abia dae, bona e mailaia tauna basine hanamoa; ia na baine miro, bona baine ania tauna baine kerere. ");
INSERT INTO meu_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Vamu hidiona na ḡau mirona enai baine dau kau, idia na basie ania: Iahi ai bae haḡolea oho. Hidio ḡoevadia na ḡoḡoeva taudia ese bae ani; ");
INSERT INTO meu_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","a mai mirona tauna ese Iehova ena herohemaino bouboudia hidiodia bema ani, ia na ena bese amo bae negea daure; ");
INSERT INTO meu_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","bona tau ta ese taunimanima edia ḡau mirona ta, eiava mauri ḡaudia mirodia ta, eiava ḡau mirona eiava bodagana ta, bema daua toho, murinai Iehova ena herohemaino bouboudia hidiodia bema ani, ia na ena bese amo bae negea daure. ");
INSERT INTO meu_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Iehova ese Mose ma e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Israel taudia ba hamaorodia, baoto: Digara basio ania, boromakau digarana eiava mamoe digarana eiava nani digarana. ");
INSERT INTO meu_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Baine mase kava ḡauna, eiava uda ḡaudia ese bae alaia ḡauna, digarana na emui ḡaukara ta ḡauna ai bainela, to basio ania. ");
INSERT INTO meu_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Badina be tau ta ese digara baine ania, taunimanima ese edia boubou ai e halaodiamu bona Iehova vairanai e haḡoledia ohomu ḡaudia ta digarana, ia na ena bese amo bae negea daure. ");
INSERT INTO meu_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Rara danu basio ania, manu ta eiava mauri ḡauna ta rarana, emui ruma iboudiai lalodiai. ");
INSERT INTO meu_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Rara baine ania tauna na ena bese amo bae negea daure. ");
INSERT INTO meu_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Iehova ese Mose ma e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Israel taudia ba hamaorodia, baoto: Iehova ena herohemaino boubouna baine mailaia tauna ese ena herahia baine mailaia Iehova ena. Herohemaino boubouna amo ");
INSERT INTO meu_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ia sibona ese ena ḡole-oho boubouna Iehova enai baine mailaia, kemena maidigarana ida ia imana ai baine mailaia, Iehova vairanai baine davea, davedave boubouna ḡauna ai bainela. ");
INSERT INTO meu_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Bena digarana na hahelaḡa tauna ese ihaboulaina patana latanai baine gabua, Iahi ese baine ḡolea oho, a kemena na Aaron mai natuna ida adia. ");
INSERT INTO meu_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Emui herohemaino bouboudia ḡaudia amo danu aedia idibadia ba dudui isi, hahelaḡa tauna ana; ");
INSERT INTO meu_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","edena tau, Aaron natuna edia amo, herohemaino boubouna digarana bona rarana baine hahelaḡadia, ia ese aena idibana baine abia, ia ahuna. ");
INSERT INTO meu_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Badina be kemena e daveamu ḡauna bona aena idibana e duduia isimu ḡauna na lau ese Israel taudia ediai vada na abi, edia herohemaino bouboudia amo, hahelaḡa tauna Aaron mai natuna Ioḡora ida vada na henidia, idia ahudia korikori, Israel taudia ediai bae abi, ela bona hanaihanai. ");
INSERT INTO meu_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Aaron mai natuna ida ahudia bunu, Iehova ena ḡole-oho bouboudia amo, Iehova ese e henidia ia vairanai e hahelaḡadia bona hahelaḡa taudia ai e halaodia dinana ai. ");
INSERT INTO meu_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Iehova ese e hahedua, e horodia dinana ai, eto Israel taudia ese unu ḡau bae henidia hanaihanai, idia ahudia korikori uru iboudiai lalodiai. ");
INSERT INTO meu_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ḡole-oho bouboudia bona flaoa bouboudia bona kara-rea bouboudia bona kara-dika bouboudia bona hahelaḡa taudia ihahelaḡadia bona herohemaino bouboudia taravatudia bunu, ");
INSERT INTO meu_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Iehova ese Sinai ororona ai Mose e haḡanilaia heḡereḡerena. Dinana bunai, ia ese Israel taudia e haḡanidia edia boubou ḡaudia Iehova dekenai bae mailaidia, Sinai tano-ḡaḡaena ai. ");
INSERT INTO meu_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Iehova ese Mose e haduaia, eto, ");
INSERT INTO meu_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Aaron mai natuna ida bavabidia, dabua helaḡadia bona dehoro helaḡana bona kara-rea boromakauna bona mamoe mamaruanedia ruaosi bona asie hatubua flaoana boseana danu bavabi. ");
INSERT INTO meu_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Bena taunimanima iboudiai na hebou kalagana iduarana badinai bae hebou. ");
INSERT INTO meu_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Bena Mose na Iehova ena hahedua heḡereḡerena e karaia, bona taunimanima iboudiai na hebou kalagana iduarana ai e hebou. ");
INSERT INTO meu_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Mose ese hebou taudia e hamaorodia, eto, Iehova ese ini vada e hahedua toma. ");
INSERT INTO meu_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Bena Mose ese Aaron mai natuna ida e abidia, ranu ai e hadigudia. ");
INSERT INTO meu_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Bena ia ese hahedoki badana bona gaba ḡauna e hakaralai, bona muri hahedokina bona hahedoki helaḡana e hadokilai, bona gaba ḡauna, e hatua ḡauna, gabana ai e ḡeḡea. ");
INSERT INTO meu_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Bena hahemaoro vainana e ha-inulaia; vaina lalonai Urim bona Tumim e uda. ");
INSERT INTO meu_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Kwara iḡeḡelaina dabuana danu kwarana ai e ḡeḡea, bona bagunai gold koronana helaḡana e atoa, Iehova ese Mose e haduaia heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Bena Mose ese dehoro helaḡana e abia, dubu bona dubu lalonai e miava ḡaudia iboudiai e horolaidia, e hahelaḡadia. ");
INSERT INTO meu_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ihaboulaina patana mai kohuna idoinai, bona digu ranuna dihuna mai ihahelai-kauna ḡauna ida, nanega hahitu e horodia, ihahelaḡadia totona. ");
INSERT INTO meu_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Aaron kwarana danu dehoro amo e horoa, e hahelaḡaia. ");
INSERT INTO meu_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Una murinai Mose ese Aaron natuna e abidia, hahedoki badadia bona gaba ḡaudia bona kwara ḡaudia e hakaralaidia, Iehova ese e haduaia heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Bena ia ese kara-rea boromakauna e abia. Aaron mai natuna ida ese imadia na boromakau kwarana ai e ato kau; ");
INSERT INTO meu_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","bena Mose ese e alaia mase, rarana e abia, imana kwakikwakina amo ihaboulaina patana ai doa e dahulai, ihaboulaina patana e hahelaḡaia. Bena rara orena na ihaboulaina patana badinai e bubua nege, unu amo e hahelaḡaia bona e haḡoevaia. ");
INSERT INTO meu_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Bena boga bona bogarau urubina bona ase digarana bona nadinadi ruaosi mai digaradia ida e abi, ihaboulaina patana ai e haḡole oho, hari Mose ese. ");
INSERT INTO meu_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","A boromakau tau-anina, mai kopina bona hidiona bona taḡena ida, taruha murimurinai e haḡolea oho, Iehova ese Mose e haduaia heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Una murinai ia ese mamoe maruanena, ḡole-oho boubouna ḡauna, e hakaua lasi. Aaron mai natuna ida ese imadia na ia kwarana ai e ato kau; ");
INSERT INTO meu_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","bena Mose ese e alaia mase, rarana na ihaboulaina patana latanai bona badinai e nevaria heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Bena e ivaia parara, kwarana bona tau-anina bona digarana be ihaboulaina patana latanai e haḡole oho, hari Mose ese. ");
INSERT INTO meu_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","A bogana bona bogarauna bona imana bona aena na ranu ai e huridia guna; bena mamoe idoinai na Mose ese e gabua, ihaboulaina patana latanai, lahi ese e ḡolea oho, bonana namo ḡauna, ḡole-oho boubouna, Iehova ena, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Bena ia ese mamoe maruanena iharuana, idia ihahelaḡadia ḡauna, e hakaua lasi. Bena Aaron mai natuna ida ese imadia na mamoe kwarana ai e ato kau. ");
INSERT INTO meu_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Bena Mose ese e alaia mase, rarana taina e abia, Aaron idiba taiana abona bona idiba imana sinabadana bona idiba aena sinabadana e dahulai. ");
INSERT INTO meu_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Aaron natuna danu e abidia, idiba taiadia abodia bona idiba imadia sinabadadia bona idiba aedia sinabadadia e dahulai. Bena Mose ese rara orena na ihaboulaina patana latanai bona badinai e nevaria heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Bena ia ese digarana e abia, bona iuna mai digarana ida, bona boga bona bogarau urubina, bona ase digarana, bona nadinadi ruaosi mai digaradia ida, bona aena idibana. ");
INSERT INTO meu_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Bena asie hatubua flaoana boseana, Iehova vairanai e miava ḡauna, amo dikea kavakava.lkava ta bona dikea mai dehorona ta bona ataga ta e abi, hari mamoe digarana bona aena idibana latadiai e ato kau. ");
INSERT INTO meu_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Bena ia ese ini ḡau iboudiai Aaron imana ruaosi nuadia ai bona natuna imadia nuadia ai e atodia; bena e davedia. Unu na davedave boubouna Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Bena Mose ese idia imadia amo ma e abidia lou, ihaboulaina patana latanai e gabudia, ḡole-oho boubouna ida: una na hahelaḡa boubouna, bonana namo ḡauna, ḡole-oho boubouna Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Bena Mose ese mamoe kemena e abia, e davea, davedave boubouna Iehova vairanai: una na Mose ahuna, hahelaḡa boubouna amo e abia, Iehova ese Mose e haduaia heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Bena Mose ese dehoro taina e abia, bona ihaboulaina patana latanai e miava rarana taina, Aaron mai dabuana ida bona Aaron natuna mai dabuadia ida e nevarilaidia: unu amo Aaron mai ena dabua ida bona Aaron natuna mai edia dabua ida e hahelaḡadia. ");
INSERT INTO meu_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Bena Mose ese Aaron mai natuna ida e haḡanidia, eto, Hidiona na ranu ai ba nadua, hebou kalagana iduarana badinai, unuseni ai bavania, bona bosea helaḡana lalonai e miamu flaoana danu, lau na hahedua heḡereḡerena, nato “Aaron mai natuna ida bae ania”. ");
INSERT INTO meu_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","A vamu bahuna bona flaoa bahuna na lahi ai ba haḡole oho. ");
INSERT INTO meu_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Hebou kalagana iduarana amo basio raka lasi dina hitu lalodiai, ela bona ihahelaḡamui dinadia bae ore; badina be ihahelaḡamui dinadia bae hitu. ");
INSERT INTO meu_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Hari dina eda kara na Iehova ena hahedua karadia: umui na ia ida ba herohemaino totona. ");
INSERT INTO meu_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Dina hitu hanuaboi hitu ba gima boi ba gima rani Iehova ena hebou kalagana iduarana ai, ba mase garina. Unu vada e haduagu toma. ");
INSERT INTO meu_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Bena Iehova ese Mose e haḡanilai karadia iboudiai na Aaron mai natuna ese e karadia ḡuḡuru. ");
INSERT INTO meu_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Dina ihataurahanina ai Mose ese Aaron mai natuna ida bona Israel tau-badadia e boiridia. ");
INSERT INTO meu_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ia ese Aaron e haduaia, eto, Boromakau natuna maruanena asi bebeka-bebekana ta bavabia, kara-rea boubouna, bona mamoe maruanena asi bebeka-bebekana ta bavabia, ḡole-oho boubouna, ruaosi na Iehova vairanai bavaladia mase, emu boubou. ");
INSERT INTO meu_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Israel taudia danu ba haduadia, baoto: Nani maruanena ta bavabia, kara-rea boubouna, bona boromakau natuna ta bona mamoe natuna ta, ruaosi laḡani tamona ḡaudia asi bebeka-bebekadia, bavabidia, ḡole-oho boubouna; ");
INSERT INTO meu_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","bona boromakau maruanena ta bona mamoe maruanena ta bavabidia, herohemaino boubouna; iboudiai na Iehova vairanai baita aladia mase, emui boubou. Flaoa boubouna danu, dehoro ida e buloa ḡauna, bavabia. Badina be hari dina ai Iehova be hahedinarai henimuimu. ");
INSERT INTO meu_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Bena Mose ese e gwaurai ḡaudia idia ese hebou kalagana vairanai e mailaidia, bona taunimanima iboudiai e raka kahi mai, Iehova vairanai e gini. ");
INSERT INTO meu_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Bena Mose eto, Iehova ena hahedua karadia bini; ia diaridiarina danu vairamui ai baine hedinarai. ");
INSERT INTO meu_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Mose ese danu Aaron e hamaoroa, eto, Ihaboulaina patana ba raka henia kahi, emu kara-rea boubouna bona emu ḡole-oho boubouna ḡaudia bavaladia mase, daimu ai bona ina orea taudia daidiai herohemaino karana be karaia; idia edia boubou ḡaudia danu ba mailaidia, idia daidiai ba herohemaino; Iehova ena haheḡani heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Taunabunai Aaron na ihaboulaina patana e raka henia kahi, boromakau natuna maruanena e alaia mase, ia sibona ena kara-rea boubouna. ");
INSERT INTO meu_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Bena Aaron natuna ese rarana e abia, tamadia e henia; bena ia ese imana kwakikwakina rara ai e urua diho, ihaboulaina patana ai doa e dahulai, bena rara orena na ihaboulaina patana badinai e bubua nege. ");
INSERT INTO meu_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","A digara bona nadinadi bona ase digarana, hari kara-rea boubouna ḡaudia, na ia ese e abi, ihaboulaina patana ai e gabu, Iahi ese e ḡole-oho, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Bena hidiona bona kopina taruha murimurinai e gabu, Iahi ese e ḡole-oho. ");
INSERT INTO meu_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Una murinai ia ese ḡole-oho boubouna e alaia mase. Bena Aaron natuna ese rara e abia, tamadia e henia; bena ia ese ihaboulaina patana latanai bona badinai e nevaria heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Bena idia ese ḡole-oho boubouna tau-aninae regea sisi ḡaudia na taidia taidia amo e henia, bona kwarana danu; bena ia ese ihaboulaina patana latanai e gabudia, Iahi ese e ḡoledia oho. ");
INSERT INTO meu_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ia ese danu bogana bona bogarauna bona imana bona aena e abidia, ranu ai e huridia; bena ḡole-oho boubouna ida e haḡoledia oho, ihaboulaina patana latanai. ");
INSERT INTO meu_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Bena ia ese orea taudia edia boubou ḡaudia e mailaidia, kara-rea boubouna nanina e abia, orea taudia edia, e alaia mase, e haḡolea oho, kara-rea iabi-ohodia, ia sibona ena heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ḡole-oho boubouna danu ia ese e abia, e alaia mase, e haḡolea oho, haheḡani heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Flaoa boubouna danu ia ese e abia, Iehova vairanai e atoa. Bena taina e abia imana ai, ihaboulaina patana latanai e haḡolea oho, daba boubouna ida. ");
INSERT INTO meu_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Boromakau maruanena bona mamoe maruanena danu, orea taudia edia herohemaino boubouna ḡaudia, e aladia mase. Bena Aaron natuna ese raradia e abi, tamadia e henia; bena ia ese ihaboulaina patana latanai bona badinai e nevaria heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Boromakau digarana, bona mamoe digarana, bona mamoe iuna mai digarana ida, bona bogana bona bogarauna urubina, bona nadinadi, bona ase digarana, e abi; ");
INSERT INTO meu_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","digara idoinai na boromakau bona mamoe kemedia latadiai e atoa kau. Bena digara be ihaboulaina patana latanai e haḡolea oho, ");
INSERT INTO meu_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","a kemedia bona idiba aedia Aaron ese e abidia Iehova vairanai e davedia, davedave boubouna ai e halaodia, Mose ena haheḡani heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Bena Aaron ese imana e dudui isi, hebou taudia e hanamodia. Bena kara-rea bouboudia bona ḡole-oho bouboudia bona herohemaino bouboudia ihahelaḡadia gabuna amo e diho. ");
INSERT INTO meu_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Bena Mose bona Aaron na hebou kalagana lalonai e raka vareai; bena ma e raka lasi, hebou taudia e hanamodia. Bena Iehova diaridiarina e hedinarai, hebou taudia ibouboudiai ese e itaia. ");
INSERT INTO meu_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Bona lahi na Iehova ena amo e diho, boubou ḡaudia bona digaradia, ihaboulaina patana latanai e miava ḡaudia, e haḡoledia oho. Hebou taudia iboudiai ese una kara e itaia, bena e lolo, bona e goru goru diho tano ai. ");
INSERT INTO meu_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aaron natuna, Nadab bona Abihu, ese edia gida keberedia e abi, gida e uda, bona muramura mai bonadia danu. Unu amo lahi idauna Iehova vairanai e vareailaia, dia iena haheḡani heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Bena lahi na Iehova ena amo e diho, raruosi e aladia mase, Iehova vairanai e mase. ");
INSERT INTO meu_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Bena Mose ese Aaron e hamaoroa, eto, Iehova na ini vada e gwau toma: Lau na baina helaḡa, bae raka henigu kahi taudia ediai; taunimanima iboudiai ese lau bae imodaigu. Bena Aaron na asi ena hereva. ");
INSERT INTO meu_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Bena Mose ese Misael bona Elsafan e boiridia; idia na Usiele, Aaron tamana lahaina, natuna. E hamaorodia, eto, Aoma, varavaramu bini gabu helaḡana, a amo bavabidia oho, taruha murimurinai ba huadia lao. ");
INSERT INTO meu_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Taunabunai, idia na e raka kahira, mai dabuadia ida e abidia isi, taruha murimurinai e huadia lao, Mose ena hereva heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mose ese Aaron mai natuna raruosi Eleasara bona Itamara ida e hamaorodia, eto, Huimui iḡuidia basio ruha, bona emui dabua basio dare, ba mase garina, bona Iehova ena badu orea taudia iboudiai latadiai baine kau na garina; a varavaramui bona Israel taudia iboudiai ese Iehova ena Iahi ḡaraḡarana dainai bae taitai. ");
INSERT INTO meu_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Bona hebou kalagana iduarana amo basio raka lasi, ba mase garina; badina be Iehova ena dehoro helaḡana na latamui ai. Bena Mose ena hereva heḡereḡerena ai e karaia. ");
INSERT INTO meu_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Bena Iehova ese Aaron e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Oi mai natumu ida hebou kalagana ai ba raka vareai negana ai na vine ranuna eiava kekero muramurana basio inua, ba mase garina. Taravatu binai na umui latamui ai baine mia hanaihanai, uru iboudiai lalodiai. ");
INSERT INTO meu_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ḡau helaḡadia bona ḡau kavakavadia ba hididia; ḡau mirodia bona ḡau ḡoevaḡoevadia danu ba hididia. ");
INSERT INTO meu_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Israel taudia ba hadibadia danu, Iehova ese Mose ena amo vada eme henidia taravatudia iboudiai ba hadibalaidia. ");
INSERT INTO meu_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Bena Mose ese Aaron bona natuna raruosi dounu mamauri, Eleasara bona Itamara, e haduadia, eto, Flaoa boubouna orena, Iehova ena ḡole-oho boubouna amo, bavabia, ihaboulaina patana badibadinai bavania, flaoa kavakava mo, asi ihatubuna, bavania; badina be ia na helaḡa herea. ");
INSERT INTO meu_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Gabu helaḡana ai bavania; badina be ia na oi ahumu bona natumu ahudia, Iehova ena ḡole-oho boubouna amo. Unu vada e haduagu toma. ");
INSERT INTO meu_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","A boubou ḡauna kemena, e davea ḡauna, bona aena, e duduia isi ḡauna, na gabu ḡoevaḡoevana ta ai bavani, oi bona natumu mamaruanedia bona natumu hahinedia; badina be vada e henimui, oi ahumu bona natumu ahudia, Israel taudia edia herohemaino bouboudia amo. ");
INSERT INTO meu_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Boubou ḡauna aena, e duduia isi ḡauna, bona kemena, e davea ḡauna, na ḡole-oho boubouna digarana ida bae mailai, Iehova vairanai bae davedia, davedave boubouna ai baela: ina na oi amu bona natumui adia, umui ahumui ela hanaihanai, Iehova ena haheḡani heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Bena Mose ese kara-rea boubouna nanina e tahua, to vada e heḡole oho. Bena ia ese Aaron natuna raruosi dounu mamauri, Eleasara bona Itamara, e badu henidia, eto, ");
INSERT INTO meu_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Dahaka dainai kara-rea boubouna asio ania gabu helaḡana ai; badina be ia na helaḡa herea, bona vada e henimui, orea taudia edia kara-rea ba huahai bona idia daidiai Iehova vairanai ba herohemaino totona. ");
INSERT INTO meu_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","O itaia, rarana na gabu helaḡana lalonai asie vareailaia. Momokani, umui na gabu helaḡana ai boma ania, na haḡanimui heḡereḡerena, bema namo. ");
INSERT INTO meu_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","A Aaron ese Mose e haere henia, eto, O itaia, hari dina ai edia kara-rea boubouna bona edia ḡole-oho boubouna vada e mailaidia, Iehova vairanai vada e hahelaḡadia; ḡau tamona, ina kara na egu ai vada e kau. Kara-rea boubouna na hari dina ai bama ania, Iehova ese bema lalo namo henigu a? ");
INSERT INTO meu_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Mose ese una hereva e kamonai, bena lalona ma e keru. ");
INSERT INTO meu_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Iehova ese Mose bona Aaron e haduadia, eto, ");
INSERT INTO meu_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Israel taudia ba hereva henidia, baoto: Mauri ḡaudia tanobada ai e loamu na iboudiai basio ani, a ini mo bavani. ");
INSERT INTO meu_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Imadia aedia palapaladia eme auka bona eme parara, bona aniani e hadonomu ma e lori lasimu, ududia ai ma e ḡauamu ḡaudia, unu be bavani. ");
INSERT INTO meu_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Ḡau tamona, unuhetomadia haida na basio ani. Kamelo na basio ania; badina be ana aniani e ḡauaia loumu, to imana aena palapaladia asieme parara; ia na helaḡa emui ai. ");
INSERT INTO meu_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Koni danu basio ania; badina be ana aniani e ḡauaia loumu, to imana aena palapaladia asieme parara; ia na helaḡa emui ai. ");
INSERT INTO meu_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Hea danu basio ania; badina be ana aniani e ḡauaia loumu, to imana aena palapaladia asieme parara; ia na helaḡa emui ai. ");
INSERT INTO meu_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Boroma danu basio ania; badina be imana aena palapaladia eme parara, to ana aniani se ḡauaia loumu. ");
INSERT INTO meu_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Hidiodia basio ani, bona masedia ai basio daudia toho; idia na hehelaḡa umui emui ai. ");
INSERT INTO meu_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Ranu ai e nohomu ḡaudia na iboudiai basio ani, a ini mo bavani: mai taiadia bona mai unadia davara ai bona sinavai ai vada bavani; ");
INSERT INTO meu_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","a asi taiadia bona asi unadia ḡaudia ranu ai e maurimu bona e loamu, davara ai eiava sinavai ai, na basio ani. ");
INSERT INTO meu_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ba dadaraidia vaitani: hidiodia basio ani, bona masedia ai basio daudia toho; idia na hehelaḡa emui ai. ");
INSERT INTO meu_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ranu ai e nohomu ḡaudia asi taiadia bona asi unadia na ba dadaraidia vaitani. ");
INSERT INTO meu_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Ba dadaraidia manudia bini: basio ani, badina be idia na hehelaḡa emui ai. Ḡaudia bini: ugava-bada bona larata bona ugava maraḡina, ");
INSERT INTO meu_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","bona bogibada bona pivai, idia bamodia manudia ida; ");
INSERT INTO meu_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","mukou danu, mai ia bamona manudia iboudiai ida; ");
INSERT INTO meu_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","bona kokokoko bona kito bona kanaḡe bona kipa, idia bamodia manudia ida; ");
INSERT INTO meu_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","bona baimumu bona manubada bona gadomanu; ");
INSERT INTO meu_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","bona kema bona boebedi bona lokoru, ");
INSERT INTO meu_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","bona boḡe, bona noko mai ia bamona manudia ida, bona turumu, bona sisiboi. ");
INSERT INTO meu_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Mai hanidia bona mai imadia aedia ḡaudia, imadia bona aedia amo tanobada ai e loamu, na ba dadaraidia; ");
INSERT INTO meu_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","a mai hanidia bona mai imadia aedia ḡaudia haida, aedia na lalata bena aedia amo e roho e laomu, ");
INSERT INTO meu_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","unu na bavani: una dainai kwadi idau-idau iboudiai na bavani diba. ");
INSERT INTO meu_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","A mai hanidia bona mai imadia aedia ḡaudia oredia iboudiai na ba dadaraidia. ");
INSERT INTO meu_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Ini ese bae hataubumui; masedia ai baine daudia toho tauna na baine taubu ela bona dina baine diho; ");
INSERT INTO meu_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","bona tau-anidia baine abi loaloa taunana ena dabua baine huri bona baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Imana aena palapaladia eme auka to asieme parara ḡauna, eiava ena aniani asine ḡauaia loumu ḡauna, na helaḡa umui emui ai: bona baine daua toho tauna na taubu. ");
INSERT INTO meu_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Bona imadia aedia palapaladia eme manoka to imadia aedia amo e rakamu ḡaudia danu hehelaḡa umui emui ai; masedia ai baine daudia toho tauna baine taubu ela bona dina baine diho; ");
INSERT INTO meu_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","bona tau-anidia baine hua tauna na ena dabua baine huri bona baine taubu ela bona dina baine diho. Unu ḡau na hehelaḡa umui emui ai. ");
INSERT INTO meu_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Ini tano ai e raumu ḡaudia danu na hehelaḡa emui ai: uda pusina, bona bita, bona ariha, mai ia bamona ḡaudia ida; ");
INSERT INTO meu_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","bona vaboha bona siha bona hohoduka bona variga bona gesoa. ");
INSERT INTO meu_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Tano ai e raumu ḡaudia bunu hehelaḡa umui emui ai; bona masedia ai baine daudia toho tauna baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Bona bae mase negana ai idia ese ḡau ta latanai bae moru, una ḡau baine miro: bema au amo e karaia ḡauna ta, eiava dabua, eiava kopi, eiava puse, ranu ai do ba udaia; ia na baine miro ela bona dina baine diho, una murinai baine ḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","A uro ai eiava hodu ai bema moru, uro eiava hodu anina baine miro, bona uro eiava hodu ba huaria. ");
INSERT INTO meu_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Una uro anianina eiava hodu ranuna, eiava una ranu amo bae nadu anianidia na mimiro. ");
INSERT INTO meu_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Una mase ḡauna tau-anina sina taina mo ḡau ta ai baine moru, una ḡau baine miro: bema ataga eiava uro, vada ba huaria; idia na mimiro, bona bae helaḡa umui emui ai. ");
INSERT INTO meu_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ḡau tamona, ranu e lohilohia gabuna eiava ranu gurina be bae ḡoeva. A mase tau-anina enai baine dau kau ḡauna na baine miro. ");
INSERT INTO meu_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Mase ḡauna tau-anina taina emui hadohado uhedia latadiai baine moru, unu uhe bae ḡoeva; ");
INSERT INTO meu_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","a uhe ba hapariparidia murinai mase ḡauna tau-anina na idia latadiai baemoru, unu uhe bae miro. ");
INSERT INTO meu_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Mauri ḡauna ta, ena be aniani ḡauna, to baine mase kava, ia tau-anina baine daua toho tauna baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Hidiona baine ania tauna na ena dabua baine huri, bona baine taubu ela bona dina baine diho. Bona tau-anina baine huaia tauna na ena dabua baine huri, bona baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Tano ai e raumu ḡaudia na ba dadaraidia, basio ani. ");
INSERT INTO meu_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Kopana amo e raumu ḡauna, bona imana rua aena rua amo e raumu ḡauna, bona aena momo ḡauna: tano ai e raumu ḡaudia iboudiai na basio ani; idia na didika. ");
INSERT INTO meu_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Tano ai e raumu ḡaudia edia dika ai basio dika bona edia miro ai basio miro, ba taubu na garina. ");
INSERT INTO meu_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Badina be lau na Iehova, emui Dirava: taunabunai sibomui ba hahelaḡa. Ba helaḡa, badina be lau na helaḡa. Tano ai e raumu ḡauna ta ena miro ai basio miro. ");
INSERT INTO meu_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Badina be lau na Iehova: Aigupto tanona amo na hakaumui lasi, emui Dirava ai bainala totona. Taunabunai ba helaḡa, badina be lau na helaḡa. ");
INSERT INTO meu_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Mauri ḡaudia taravatudia bunu; tanobada ai e loamu ḡaudia, bona atai ai e rohomu manudia, bona davara ai e nohomu ḡaudia, bona tano ai e raumu ḡaudia, ");
INSERT INTO meu_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","mirodia bona ḡoevaḡoevadia ihididia bona bavani bona basio ani ḡaudia ihididia taravatudia. ");
INSERT INTO meu_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Israel taudia ba hereva henidia baoto: Hahine ta baine rogorogo, baine mara, mero ta baine abia negana ai, ia na dina hitu do baine taubu, rara e hekaramu negadia ai heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Dina ihataurahanina ai mero na bae peritomea. ");
INSERT INTO meu_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Bena hahine na dina toi-ahui toi ma baine taubu, ena rara aru karadia daidiai; unu dina lalodiai ḡau helaḡana ta basine daua toho, bona gabu helaḡana ai basine raka vareai, ela bona ena helaḡa dinadia bae ore. ");
INSERT INTO meu_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","A baine mara, kekeni ta baine abia, ia na baine taubu ela bona pura rua bae ore, rara e hekaramu negadia heḡereḡerena; bona ena rara aru karadia bae kara ela bona dina tauratoi-ahui tauratoi bae ore. ");
INSERT INTO meu_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Helaḡa dinadia, mero dainai eiava kekeni dainai, bae ore ai, hahine ese mamoe natuna ta, laḡani tamona ḡauna, baine abia, ena ḡole-oho boubouna, bona pune natuna ta eiava kerea ta baine abia, ena kara-rea boubouna. Unu ḡau ruaosi na hahelaḡa tauna dekena baine mailaidia, hebou kalagana iduarana ai. ");
INSERT INTO meu_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Bena hahelaḡa tauna ese unu boubou ḡaudia na Iehova vairanai baine atodia, una hahine dainai herohemaino karana baine karaia; bena ena rara aru amo baine ḡoeva. Mara matamata hahinena taravatuna bunai, mero baine abia eiava kekeni baine abia hahinena. ");
INSERT INTO meu_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","A ena moni basinema heḡereḡere mamoe natuna ihoina, ia ese kerea rua eiava pune natuna rua bema abidia, ta ḡole-oho boubouna, ma ta kara-rea boubouna. Bena hahelaḡa tauna ese ia dainai herohemaino karana baine karaia; unu amo hahine na baine ḡoevaḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Iehova ese Mose bona Aaron e haduadia, eto, ");
INSERT INTO meu_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Tau ta kopina baine gudu, eiava baine taoha, eiava mai toutouna kurokurona, lepra na heto, una tau bae hakaua vareai hahelaḡa tauna Aaron vairanai, eiava hahelaḡa tauna Aaron natuna ta vairanai. ");
INSERT INTO meu_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Bena hahelaḡa tauna ese kopina baine itaia, bema una kopi dikana derana danu kurokuro, bona toutouna na dia kopina ai mo to sisina dobu, una na lepra: hahelaḡa tauna ese baine itaia bena ia ese una tau baine gwauraia, vada e miro. ");
INSERT INTO meu_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","A bema toutou na kurokuro, to kopina ai mo, bona derana na se kurokuro, hahelaḡa tauna ese una tau baine koua ahu ela bona dina hitu bae ore. ");
INSERT INTO meu_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Bena dina ihahituna ai hahelaḡa tauna ese baine itaia lou: toutou bema gabuna ai mo, se dika bona se bada, hahelaḡa tauna ese ma baine koua lou, ela bona dina hitu ma bae ore. ");
INSERT INTO meu_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ma dina ihahituna ai hahelaḡa tauna ese baine itaia lou: toutou bema maraḡi bona dia dobu, hahelaḡa tauna ese baine gwauraia, vada e ḡoeva. Una na idau toto taohana. Ena dabua baine huri, bena baine ḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ḡau tamona, hahelaḡa tauna ese baine kahua nege, murinai una toutou ma baine bada lou, ia na hahelaḡa tauna dekena ma baine lou lao. ");
INSERT INTO meu_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Bena hahelaḡa tauna ese baine itaia, toutou na momokani vada e bada, ia na una tau baine gwauraia, vada e miro; ia na lepra tauna. ");
INSERT INTO meu_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Lepra toadia bae hedinarai tau ta kopina ai, ia na hahelaḡa tauna vairanai bae hakaua vareai. ");
INSERT INTO meu_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Bena hahelaḡa tauna ese ḡou kurokurona baine itaia una tau kopina ai, bona baine itaia danu una ḡou na mai berona bona derana e kurokuromu: ");
INSERT INTO meu_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","una na lepra ḡouna ia kopina ai. Hahelaḡa tauna ese baine gwauraia, vada e miro. Basine koua ahu lou, badina be ia na miro momokani. ");
INSERT INTO meu_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","A hahelaḡa tauna ese baine itaia, lepra be kopina idoinai vada e daea, kwarana amo ela bona aena, ");
INSERT INTO meu_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ia ese baine itaia namonamo; bema momokani kopina idoinai vada e daea vaitani, ia ese una tau baine gwauraia, vada e ḡoeva. Kopina idoinai vada e kurokuro dainai, ia na vada e ḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","A hidio berona ienai bema hedinarai, ia na baine miro; ");
INSERT INTO meu_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","hahelaḡa tauna ese bero baine itaia, bena baine gwauraia, vada e miro. Una bero be miro toana; una tau be lepra tauna. ");
INSERT INTO meu_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","A hari hidio berodia ma bae namo, bona kopina baine kurokuro, ia na hahelaḡa tauna vairanai ma bainela. ");
INSERT INTO meu_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Hahelaḡa tauna ese baine itaia: bema hidio berodia vada e kurokuro, hahelaḡa tauna ese baine gwauraia, vada e ḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Tau ta kopina ai iohururu ta vada e namo ");
INSERT INTO meu_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","gabuna amo gudu kurokurona eiava toutou mia-kakana baine hedinarai, hahelaḡa tauna bae haheitalaia. ");
INSERT INTO meu_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Hahelaḡa tauna ese baine itaia, toutou na sisina dobu bona derana danu kurokuro, ia ese una tau baine gwauraia, vada e miro; una na lepra, iohururu gabuna amo e vara. ");
INSERT INTO meu_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","A baine itaia, dera na se kurokuro, bona toutou na kopina ai mo bona dia kurokuro herea eiava dia kakakaka herea, hahelaḡa tauna ese una tau baine koua ahu ela bona dina hitu bae ore; ");
INSERT INTO meu_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","una negana ai toutou bema bada, ia ese baine gwauraia vada e miro; una na lepra. ");
INSERT INTO meu_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","A toutou na gabuna ai mo bema mia, basinema bada, una na iohururu kiparana mo; hahelaḡa tauna ese baine gwauraia, vada e ḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Tau ta kopina na lahi ese e araia berona gabuna ai baine toutou, mia-kaka eiava kurokuro, ");
INSERT INTO meu_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","hahelaḡa tauna ese baine itaia. Bema dera vada e kurokuro, bona toutou na sisina dobu, una na lepra, Iahi ese e araia gabuna amo vada e vara. Hahelaḡa tauna ese baine gwauraia, vada e miro; badina be ia na lepra tauna. ");
INSERT INTO meu_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","A baine itaia, dera na se kurokuro, bona toutouna kopina ai mo, bona dia kurokuro herea eiava dia kakakaka herea, hahelaḡa tauna ese una tau baine koua ahu ela bona dina hitu bae ore. ");
INSERT INTO meu_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Dina ihahituna ai hahelaḡa tauna ese baine itaia Iou: toutou bema bada, ia ese una tau baine gwauraia, vada e miro; una na lepra. ");
INSERT INTO meu_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","A toutou na gabuna ai mo bema mia, basinema bada, ena kurokuro eiava ena kakakaka danu bema maraḡi, una na lahi kiparana mo. Hahelaḡa tauna ese baine gwauraia, vada e ḡoeva; badina be una na e ara gabuna kiparana mo. ");
INSERT INTO meu_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Tau ta kwarana eiava auki-huina baine pouka, eiava hahine ta kwarana baine pouka, ");
INSERT INTO meu_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","hahelaḡa tauna ese una pouka baine itaia: totototona bema sisina dobu, bona huina bema labora, ia ese una tau eiava una hahine baine gwauraia, vada e miro; una na pouka dikana, lepra heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","A una pouka baine itaia, totototo bema kopina ai mo bona huina na do korema, hahelaḡa tauna ese una tau eiava una hahine baine koua ahu ela bona dina hitu bae ore. ");
INSERT INTO meu_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Bena dina ihahituna ai hahelaḡa tauna ese una pouka baine itaia lou: bema se bada bona huina se labora bona kopina ai mo, ");
INSERT INTO meu_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","una tau eiava una hahine huina bae naua, a pouka gabuna mo basie naua; una murinai ma bae koua ahu lou dina hitu. ");
INSERT INTO meu_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Bena dina ihahituna ai hahelaḡa tauna ese ma baine itaia lou: bema se bada bona kopina ai mo, ia ese una tau eiava una hahine baine gwauraia, vada e ḡoeva. Ena dabua baine huridia, bena baine ḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","A baine ḡoeva murinai una pouka ma baine hekara lou, ");
INSERT INTO meu_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","hahelaḡa tauna ese ma baine itaia. Totototo bema bada herea, ia huina vada e labora eiava lasi basine laloa; ia ese una tau eiava una hahine baine gwauraia, vada e miro. ");
INSERT INTO meu_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","A baine itaia, totototo na dia bada herea bona huina na korema, ia na baine diba gorere vada be namomu, bona una tau eiava una hahine vada e ḡoeva; bena baine gwauraia, vada e ḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Tau ta eiava hahine ta kopina ai toutou kurokurodia bae hedinarai, ");
INSERT INTO meu_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","hahelaḡa tauna ese unu toutou baine itadia. Bema toutou na dia kurokakuroka, una na kopi gorerena mo: ia na ḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Tau ta huina bema hehuhu, kwarana tubuana bema boha, to ia na ḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Eiava ramana bona medena bema hehuhu, una na rama-boha mo: ia na ḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","A bema kwarana tubuana ai eiava ramana ai, huina vada e hehuhu gabuna ai, toutou mia-kakana ta baine hedinarai, una na lepra, boha tauna kwarana ai eiava ramana ai vada e vara. ");
INSERT INTO meu_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Taunabunai, hahelaḡa tauna ese boha tauna baine itaia, toutou mia-kakadia kwarana ai eiava ramana ai vada e gudu, lepra toutoudia heḡereḡeredia, ");
INSERT INTO meu_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ia na lepra tauna: ia na miro. Hahelaḡa tauna ese baine gwauraia, vada e miro; badina be kwarana na mai leprana. ");
INSERT INTO meu_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Lepra tauna na dabua hedarena baine hahedokilaia, huina baine ḡiḡia rohoroho, atai bibinana na dabua amo baine koua, baine lolo, baineto “Miro, miro”. ");
INSERT INTO meu_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ena gorere dinadia iboudiai ia na baine helaḡa. Ia na miro; sibona baine noho edea, taruha murimurinai. ");
INSERT INTO meu_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Dabua manokana ai eiava dabua aukana ai lepra mirona bema mia, ");
INSERT INTO meu_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","eiava dabua ihatulaina varodia ai, eiava boromakau kopina ai, eiava boromakau kopina amo e karaia ḡauna ta ai, ");
INSERT INTO meu_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","bema gorere toana gadoka-gadokana eiava kakakakana na dabua ai eiava dabua varodia ai eiava boromakau kopina ai eiava boromakau kopina amo e karaia ḡauna ai baine hedinarai, una na lepra gorerena: hahelaḡa tauna bae haheitalaia. ");
INSERT INTO meu_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Hahelaḡa tauna ese baine itaia, bena ia ese hari mai gorerena ḡauna baine koua ahu ela bona dina hitu bae ore. ");
INSERT INTO meu_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Bena dina ihahituna ai ma baine itaia lou: gorere toana bema bada, dabua ai eiava dabua varodia ai eiava boromakau kopina ai eiava boromakau kopina amo e karaia ḡauna ai, una na lepra korikori. Ia na miro vaitani; ");
INSERT INTO meu_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","taunabunai una dabua manokana eiava dabua aukana eiava dabua varona eiava boromakau kopina ḡauna na bae gabua, badina be una na lepra korikori una dainai lahi ai bae gabua. ");
INSERT INTO meu_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","A hahelaḡa tauna ese una ḡau baine itaia, gorere toana na se bada una dabua ai eiava una dabua varona ai eiava una boromakau kopina ḡauna ai, ");
INSERT INTO meu_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ia na baine hahedua, hari mai gorerena ḡauna bae huria; bena ia ese ma baine koua ahu ela bona dina hitu ma bae ore. ");
INSERT INTO meu_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Bena hahelaḡa tauna ese hari e huria ḡauna baine itaia lou: bema gorere toana ita-itana na seidau bona se bada, ia na miro; Iahi ai ba gabua. Ena be gorere toana na dabua murina kahana ai eiava dabua lalona kahana ai, to vada ba gabua. ");
INSERT INTO meu_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","A hahelaḡa tauna ese baine itaia, ihurina murinai gorere toana vada e heroho valahu-valahumu: ia na toutou e miamu gabuna baine darea oho, dabua amo eiava boromakau kopina amo eiava dabua varona amo; ");
INSERT INTO meu_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","bena gorere toana ma bema hedinarai lou una dabua ai eiava una dabua varona ai eiava una boromakau kopina ai, una na lepra ma e vara loumu. Una ḡau mai gorerena ida na lahi ai ba gabua. ");
INSERT INTO meu_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","A gorere toana basinema hedinarai lou, bae huria murinai, una dabua eiava una dabua varona eiava una boromakau kopina ḡauna na bae huria lou, nega iharuana, bena baine ḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Dabua manokana eiava dabua aukana eiava dabua i hatulaina varodia eiava boromakau kopina amo e karaia ḡauna ta lepra ese baine hamiroa, taravatuna bunai; unu ba diba toma, ia na ḡoeva eiava miro. ");
INSERT INTO meu_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Iehova ese Mose e haduaia, eto, ");
INSERT INTO meu_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Lepra tauna ihaḡoevana dinana taravatuna binai. Bae hakaua lao, hahelaḡa tauna dekenai; ");
INSERT INTO meu_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","bena hahelaḡa tauna na taruha murimurinai bainela, una tau baine itaia, ena lepra vada e boio eiava. ");
INSERT INTO meu_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Bema boio, hahelaḡa tauna ese baine haḡanidia, lepra tauna ihaḡoevana totona manu ḡoevaḡoevadia rua mauridia ai bae abidia, bona sida audia taidia, bona dabua kakakakana taina, bona muramura avana. ");
INSERT INTO meu_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Bena hahelaḡa tauna ese baine hahedua, manu ta uro ai bae alaia, e arumu ranuna daenai. ");
INSERT INTO meu_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Bena manu maurina bona sida audia bona dabua kakakakana bona muramura avana baine abi, hari e arumu ranuna daenai e alaia manuna rarana ai baine uru diho. ");
INSERT INTO meu_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Bena rara baine abia, ena lepra amo baine haḡoevaia; tauna baine nevarilaia, nega hitu; bena baine gwauraia, vada e ḡoeva. A manu maurina baine harohoa lasi murimuri ai. ");
INSERT INTO meu_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Bena vada e ḡoeva tauna ese ena dabua baine huri, bona huina idoinai baine naua, bona baine digu: bena baine ḡoeva. Una murinai ia na taruha lalonai baine raka vareai: to ena kalaga murimurinai baine noho ela bona dina hitu bae ore. ");
INSERT INTO meu_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Dina ihahituna ai, ia na huina idoinai, kwarana huina bona aukina huina bona ibunina, baine naua; bona ena dabua baine huri; bona baine digu. Unu amo baine ḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Dina ihataurahanina ai, ia ese mamoe natudia mamaruanedia rua, asi bebeka-bebekadia, bona mamoe natuna hahinena ta, laḡani tamona ḡauna asi bebeka-bebekana, baine abidia. Bona flaoa namo-hereana efa ta baine karoa, karoa gwauta; bena karoa toi baine abi, dehoro ida baine bulo. Bona dehoro kebere ta danu baine abia. ");
INSERT INTO meu_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Bena hahelaḡa tauna ese baine haḡoevaia tauna na baine hakaua lao, mai ena boubou ḡaudia ida, hebou kalagana iduarana ai baine haginia, Iehova vairanai ");
INSERT INTO meu_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Bena hahelaḡa tauna ese mamoe natudia mamaruanedia ta baine abia, kara-dika boubouna ai bainela, dehoro keberena danu; unu ḡau ruaosi baine davedia, davedave boubouna ai baela Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Hari mamoe natuna maruanena na kara-rea bouboudia ḡaudia bona ḡole-oho bouboudia ḡaudia e aladiamu gabuna ai baine alaia, gabu helaḡana ai; badina be kara-dika boubouna ḡauna na hahelaḡa tauna ana, kara-rea boubouna heḡereḡerena. Ia na helaḡa herea. ");
INSERT INTO meu_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Bena hahelaḡa tauna ese kara-dika boubouna rarana taina baine abia, e haḡoevaiamu tauna idiba taiana abona baine dahulaia, bona idiba imana sinabadana baine dahulaia, bona idiba aena sinabadana baine dahulaia. ");
INSERT INTO meu_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Kebere danu baine abia, dehoro taina na miana laurina nuana ai baine seia; ");
INSERT INTO meu_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","bena idiba imana kwakikwakina ta una dehoro ai baine urua diho, bena dehoro na nega hitu baine daveraia Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Bena dehoro orena miana hahelaḡa tauna imana ai na taina baine abia, e haḡoevaiamu tauna idiba taiana abona bona idiba imana sinabadana bona idiba aena sinabadana baine dahulaidia, kara-dika boubouna rarana e dahulaidia gabudia ai. ");
INSERT INTO meu_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","A dehoro orena hahelaḡa tauna imana ai miana na ibounai e haḡoevaiamu tauna kwarana baine horolaia; unu amo hahelaḡa tauna ese ia dainai herohe-maino karana baine karaia, Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Hahelaḡa tauna ese kara-rea boubouna ḡauna baine alaia mase, e haḡoevaiamu tauna dainai herohemaino karana baine karaia; murinai ḡoIe-oho mamoena baine alaia mase. ");
INSERT INTO meu_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Hahelaḡa tauna ese ḡole-oho ḡauna bona flaoa boubouna baine gabudia, ihaboulaina patana ai; Iahi ese baine ḡoledia oho. Unu amo hahelaḡa tauna ese una tau dainai herohemaino karana baine karaia, bena ia na baine ḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Tau ta bema ogoḡami dainai unu ḡau idavaridia basinema heḡereḡere, ia ese mamoe natuna maruanena tamona mo baine abia, ena kara-dika boubouna, hahelaḡa tauna ese baine davea, ia dainai herohemaino karana baine karaia; bona flaoa efa ta baine karoa, karoa gwauta, karoa toi dehoro ida baine bulo, ena flaoa boubouna; bona dehoro kebere ta; ");
INSERT INTO meu_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","bona kerea rua eiava pune natuna rua, ena moni heḡereḡerena, ta kara-rea boubounabona ta ḡole-oho boubouna. ");
INSERT INTO meu_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Bena dina ihataurahanina ai, ia ese baine laohaidia, hahelaḡa tauna dekenai, hebou kalagana iduarana ai, Iehova vairanai, hahelaḡa tauna ese baine haḡoevaia totona. ");
INSERT INTO meu_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Bena hahelaḡa tauna ese kara-dika boubouna mamoena bona kebere mai dehorona ida baine abidia, baine davedia, davedave boubouna ai baela Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Bena kara-dika boubouna mamoena baine alaia mase, bona rarana baine abia, e haḡoevaiamu tauna idiba taiana abona bona idiba imana sinabadana bona idiba aena sinabadana baine dahulaidia. ");
INSERT INTO meu_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Bena hahelaḡa tauna ese dehoro na ia imana laurina nuana ai baine seia, ");
INSERT INTO meu_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","bona idiba imana kwakikwakina ta amo baine daveraia nega hitu, Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Bena hahelaḡa tauna ese dehoro taina imana ai mia baine abia, e haḡoevaiamu tauna idiba taiana abona bona idiba imana sinabadana bona idiba aena sinabadana baine dahulaidia, kara-dika boubouna rarana e dahulaidia gabudia ai. ");
INSERT INTO meu_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","A dehoro orena hahelaḡa tauna imana ai mia na e haḡoevaiamu tauna kwarana baine horolaia, ia dainai herohemaino karana baine karaia Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Bena ia ese hari kerea rua eiava pune natuna rua, ena moni heḡereḡerena ai e hoi, baine heni, ");
INSERT INTO meu_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ta kara-rea boubouna ai bainela, ma ta ḡole-oho boubouna ai bainela, flaoa boubouna ida; unu amo hahelaḡa tauna ese herohemaino karana baine karaia, Iehova vairanai, e haḡoevaiamu tauna ena. ");
INSERT INTO meu_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Lepra tauna, ena moni dia heḡereḡere ihaḡoevana ḡaudia korikoridia baine abi, taravatuna bunai. ");
INSERT INTO meu_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Iehova ese Mose bona Aaron ma e hamaorodia, eto, ");
INSERT INTO meu_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Baina henimui emui tano korikori ai bainela tanona, Kanaan, ai ba kau murinai, readia ruma auta ai lepra gorerena baina atoa kau. ");
INSERT INTO meu_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Unu bema heto, ruma biaguna ese hahelaḡa tauna dekena bainela, baineto, Lau na laloamu gorere dikana ta be egu ruma ai mia. ");
INSERT INTO meu_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Bena hahelaḡa tauna ese baine hahedua, ruma ḡaudia iboudiai na ruma amo bae huadia lasi, hahelaḡa tauna baine raka vareai bena ruma ḡaudia baine gwauraidia miro na garina. Bena gabeamo hahelaḡa tauna na baine raka vareai, ruma baine itaia: ");
INSERT INTO meu_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","bena gorere toana baine itaia; bema ruma habana na mai toutou gadoka-gadokadia eiava kakakakadia, bona toutou na dia haba kopina ai mo to sisina dobu, ");
INSERT INTO meu_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","hahelaḡa tauna ese ruma iduarana amo baine raka lasi bona ruma na baine koua kunuka-kunuka, ela bona dina hitu bae ore. ");
INSERT INTO meu_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Dina ihahituna ai, hahelaḡa tauna ma bainela, baine itaia, ruma habana ai toutou vada e bada eiava. ");
INSERT INTO meu_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Bena hahelaḡa tauna ese baine hahedua, nadi mai toutoudia bae raḡadia oho, hanua murimurinai bae negedia, momoru gabuna ai. ");
INSERT INTO meu_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Ruma laloma kahana idoinai danu bae kakasia, bona bae kakasia oho momoruna danu hanua murimurinai bae negea, miro ḡaudia e negemu gabuna ai. ");
INSERT INTO meu_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Bena nadi matamatadia bae abi, e raḡadia oho ḡaudia bae bolodia; murinai ruma laloma kahana, idoinai taba-taba ḡauna amo bae tabaia ahu. ");
INSERT INTO meu_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Unu nadi bae raḡadia oho bona ruma laloma kahana bae kakasia bona tabataba ḡauna amo bae tabaia ahu murinai unu gorere toutoudia ma bema vara lou ai na ");
INSERT INTO meu_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","hahelaḡa tauna ese ma baine ha itaia. Bema gorere toutoudia vada e bada ruma ai, una na lepra korikori, ruma e hadikaiamu; ruma na miro. ");
INSERT INTO meu_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Ia ese ruma na baine rohoa, nadi bona au bona tabataba ḡauna baine ḡiḡi dobi; bena bae laohai, hanua murimurinai, miro ḡaudia e negemu gabuna ai, bae nege. ");
INSERT INTO meu_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Daika ese ruma lalonai vada e raka vareai, hahelaḡa tauna ese e koua murinai, ia na baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Una ruma ai e aniani tauna na ena dabua baine huri, bona una ruma ai e mahuta tauna danu ena dabua baine huri. ");
INSERT INTO meu_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","A hahelaḡa tauna baine raka vareai negana ai na baine itaia, tabataba ḡauna amo e tabaia ahu murinai gorere toutoudia asie vara lou, ia ese una ruma baine gwauraia, vada e ḡoeva; badina be gorere vada e boio. ");
INSERT INTO meu_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Bena ruma ihaḡoevana totona ia ese manu rua bona sida audia rua bona dabua kakakaka bona muramura avana baine abidia. ");
INSERT INTO meu_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Manu ta be uro lalonai baine alaia mase, e arumu ranuna daenai; ");
INSERT INTO meu_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","bena sida audia bona muramura avana bona dabua kakakaka bona manu maurina na manu masena rarana ai bona e arumu ranuna ai baine uru diho, bena ruma baine nevarilaia nega hitu. ");
INSERT INTO meu_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ruma na unu baine haḡoevaia toma, manu rarana amo bona e arumu ranuna amo bona manu maurina amo bona sida audia amo bona muramura avana amo bona dabua kakakaka amo. ");
INSERT INTO meu_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Bena manu maurina na baine harohoa, hanua amo baine roho lasi uda ai. Unuhetomana ia ese ruma dainai herohemaino karana baine karaia. Bena ruma na baine ḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Lepra bona taunimanima kopidia e varamu goreredia taravatudia bunu; ");
INSERT INTO meu_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","bona dabua bona ruma lepra ese e hamirodiamu taravatudia; ");
INSERT INTO meu_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","bona ḡou bona taoha bona toutou taravatudia. ");
INSERT INTO meu_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Unu amo ba diba, mirona be edena bona ḡoevana be edena. Lepra taravatuna bunai. ");
INSERT INTO meu_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Iehova ese Mose bona Aaron e hereva henidia, eto, ");
INSERT INTO meu_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Israel taudia ba hamaorodia, baoto: Tau ta ese enobou gorerena baine davana, ia na baine miro. ");
INSERT INTO meu_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ena enobou gorerena taravatuna binai: hura baine aru lasi eiava baine atua ahu, ia na miro. ");
INSERT INTO meu_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","E mahutalaia patana na miro, bona latadiai e helai kau ḡaudia iboudiai na mimiro. ");
INSERT INTO meu_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Ena mahuta patana ai baine dau kau tauna na ena dabua baine huri, bona ranu ai baine digu, bona baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Gorere tauna ena helai ḡauna ai baine helai tauna danu ena dabua baine huri, bona baine digu, bona baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Gorere tauna kopina baine daua toho tauna danu ena dabua baine huri, bona baine digu, bona baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Gorere tauna ese ḡoeva tauna baine kanudia, una ḡoeva tauna ese ena dabua baine huri, bona baine digu, bona baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Hosi doruna ai helai ḡauna na gorere tauna baine helai kau, una ḡau na miro. ");
INSERT INTO meu_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Gorere tauna henunai e miava ḡauna ta tau ta ese baine daua toho, ia na baine taubu ela bona dina baine diho; bona ḡau unuhetomadia baine abi tauna na ena dabua baine huri bona baine digu, bena baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Gorere tauna ese imana ranu ai basine huri, a tau ta baine daua toho, una tau ese ena dabua baine huri, bona baine digu, bona baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Gorere tauna ese baine daua toho urona na bae hamakohia, bona baine daua toho dihuna na ranu amo bae huria. ");
INSERT INTO meu_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Hari mai ena hura-aru tauna hurana bema doko, ia na dina hitu lalodiai baine haheḡoeva: ena dabua baine huri bona baine digu, bena baine ḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Dina ihataurahanina ai, ia na kerea rua eiava pune natuna rua baine abidia, baine mailaidia Iehova vairanai, hebou kalagana iduarana ai; unuseni ai hahelaḡa tauna baine henia. ");
INSERT INTO meu_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Bena hahelaḡa tauna ese baine hahelaḡadia, ta kara-dika boubouna ai bainela, ma ta ḡole-oho boubouna ai bainela; unu amo hahelaḡa tauna ese ia bagunai herohemaino karana baine karaia, Iehova vairanai, ena hura-aru dainai. ");
INSERT INTO meu_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Tau ta vesina bema aru, ia na ranu ai baine digu, tauna idoinai baine huria, bona baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Vesi na dabua ai eiava kopi amo e kara dabuadia ai bema aru, unu dabua iboudiai eiava unu kopi iboudiai na bae huri, bona bae taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Tau ta ese hahine ta ida bae eno bou, bena vesina baine aru, raruosi vada bae digu, bona bae taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Hahine ta rara baine karaia, ena nega korikori ai, ia be dina hitu baine miro; bona ta ese baine daua toho, ia danu baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Ena miro dinadia ai baine hekurelai ḡaudia iboudiai na bae helaḡa, bona baine helailai ḡaudia iboudiai danu bae helaḡa. ");
INSERT INTO meu_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Ena mahuta patana ai baine dau kau tauna na ena dabua baine huri, bona baine digu, bona baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Ena helai ḡauna ai baine dau kau tauna danu ena dabua baine huri, bona baine digu, bona baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ena mahuta ḡauna ta eiava ena helai ḡauna ta latadiai tau ta ese bema daua toho, una tau baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Tau ta ia ida bae eno bou, bena ia mirona ai baine miro, ia na baine taubu dina hitu, bona baine mahutalai patadia iboudiai bae miro. ");
INSERT INTO meu_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Hahine ta ena rara kara dinadia bema hoho, dia ena rara kara negana korikori ai, eiava ena nega korikori ai to baine daudau herea, ia na baine taubu ela bona una rara-kara baine doko, ena rara kara dinadia iboudiai heḡereḡerena ai, ia na baine taubu. ");
INSERT INTO meu_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Baine mahutalai patadia iboudiai bae miro ena; l rara kara a adia korikoridia ai heḡereḡerena; bona baine helailai ḡaudia iboudiai danu bae miro, ena rara kara negana ai heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Unu ḡau baine daudia toho tauna danu baine miro; ena dabua baine huri, bona baine digu, bona baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","A ena rara kara bema doko, ia na dina hitu baine duahidia, bena baine ḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Bena dina ihataurahanina ai, ia ese kerea rua eiava pune natuna rua baine abidia, hahelaḡa tauna dekena baine mailaidia, hebou kalagana iduarana ai. ");
INSERT INTO meu_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Bena hahelaḡa tauna ese baine hahelaḡadia, ta kara dika boubouna ai bainela, ma ta ḡole-oho boubouna ai bainela. Unu amo hahelaḡa tauna ese ia bagunai herohemaino karana baine karaia, Iehova vairanai, ena rara kara dainai. ");
INSERT INTO meu_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Iniheto amo umui ese Israel taudia na edia miro amo ba haḡoevadia, lauegu dubu helaḡana, bogaragidiai e miamu dubuna, bae hamiroa, bena edia miro ai bae mase na garina. ");
INSERT INTO meu_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Taravatu bunu: hura-aru tauna taravatuna, bona vesi-aru amo e miromu tauna taravatuna, ");
INSERT INTO meu_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","bona rara-kara hahinena taravatuna; kara miro taudia bona hahinedia taravatuna; bona hahine mai mirona ida e eno bou tauna taravatuna. ");
INSERT INTO meu_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Iehova ese Mose e hereva henia, Aaron natuna raruosi ese Iehova e raka henia kahi dainai e mase negana murinai. ");
INSERT INTO meu_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Iehova ese Mose e haduaia, eto, Kakamu Aaron, ia na dina iboudiai gabu helaḡana, seseahu lalonai, maua helaḡana ikaruhina vairanai, basine raka vareai, lasi ona lasi vaitani, baine mase garina; badina be lau na ori ai baina hedinarai, maua helaḡana ikaruhina latanai. ");
INSERT INTO meu_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","A Aaron na gabu helaḡana lalonai baine raka vareai negadia ai, ia na ini baine raka vareai toma: boromakau natuna maruanena ta baine mailaia, kara rea boubouna; bona mamoe maruanena to baine mailaia, ḡole-oho boubouna. ");
INSERT INTO meu_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Hahedoki helaḡana, dabua aukana ḡauna, bona piribou, dabua aukana ḡauna, baine kara, bona gaba dabuana baine ḡeḡea, bona kwara ḡauna, dabua aukana ḡauna, kwarana ai baine atoa. Baine digu guna, bena baine kara, badina be unu na dabua helaḡadia. ");
INSERT INTO meu_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Bena Israel taudia ediai ani mamaruanedia rua baine abidia, kara rea boubouna, bona mamoe maruanene ta, ḡole-oho boubouna. ");
INSERT INTO meu_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aaron ese ena kara rea boubouna boromakauna baine alaia mase, ia sibona dainai bona ena ruma taudia daidiai herohemaino karana baine karaia. ");
INSERT INTO meu_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Una murinai ia ese nani mamaruanedia ruaosi baine abidia, Iehova vairanai baine atodia, hebou kalagana iduarana ai. ");
INSERT INTO meu_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Bena Aaron ese mari amo baine tahudia, nani maruanena ta Iehova ena, ma ta Asasele ena. ");
INSERT INTO meu_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Bena nani maruanena ta, mari amo e davaria ḡauna na Iehova ena, Aaron ese baine alaia mase, kara rea boubouna; ");
INSERT INTO meu_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","a nani maruanena iharuana, mari amo e davaria ḡauna na Asasele ena, mai maurina ida baine hakaua Iehova vairanai, herohemaino ḡauna na Asasele ena, mai maurina ida baine hakaua Iehova vairanai, herohemaino ḡauna; bena baine kahua bege, tano ḡaḡaena bainela, Asasele ena. ");
INSERT INTO meu_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aaron na ini baine kara toma: kara rea boubouna boromakauna baine mailaia guna, ia sibona dainai bona ena ruma taudia daidiai herohemaino karana baine karaia. Kara rea boubouna boromakauna baine alaia mase, ia sibona ena kara rea boubouna. ");
INSERT INTO meu_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Bena ihaboulaina patana lahina amo gida baine abi, Iehoa vairanai, kebere ta ai baine uda, ela bona kebere baine honu; bona muramura mai bonana, e hamakohia sisisisi ḡauna, imana ai baine abia, seseahu lalonai baine rakalaia vareai. ");
INSERT INTO meu_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Bena hari muramura mai bonana na gida ai baine bubua, Iehova vairanai; ela bona hari muramura mai bonana kwalahuna ese maua helaḡana ikaruhina, taravatu nadidia e karuhidia ḡauna, baine ḡovaia, ia basine mase helaoreana. ");
INSERT INTO meu_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Bena boromakau rarana taina baine abia, imana kwakikwakina amo baine nevaria, maua helaḡana ikaruhina latanai bona vairanai, mairiveina kahana amo baine nevaria, nega hitu. ");
INSERT INTO meu_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Una murinai ia ese kara rea boubouna nanina baine alaia mase, taunimanima edia; ia rarana danu baine vareailaia, seseahu lalonai, boromakau rarana e karaia heḡereḡerena ma baine karaia, maua helaḡana ikaruhina latanai bona vairanai baine nevari. ");
INSERT INTO meu_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Unu amo ia ese gabu helaḡana dainai herohemaino karana baine karaia, Israel taudia edia miro bona edia kara dika bona edia kara rea daidiai; kara heḡereḡerena ma baine karaia hebou kalagana dainai, badina be ia na miro besena bogaraginai e miamu. ");
INSERT INTO meu_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Una negana ai tau ta ese hebou kalagana lalonai basine raka vareai, Aaron ese gabu helaḡana ihaḡoevana totona baine raka vareai negana amo ela bona ia sibona dainai bona ena ruma taudia daidiai bona Israel taudia iboudiai daidiai herohemaino karadia baine kara, ma baine raka lasi. ");
INSERT INTO meu_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Bena gabu helaḡana amo baine raka lasi negana ai, ia ese ihaboulaina patana dainai herohemaino karana baine karaia: boromakau rarana taina bona nani rarana taina baine abi, ihaboulaina patana doana baine dahulai, ");
INSERT INTO meu_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","bona imana kwakikwakina amo baine nevarilaia nega hitu. Unuhetomana ia ese ihaboulaina patana na Israel taudia edia miro amo baine haḡoevaia bona baine hahelaḡaia. ");
INSERT INTO meu_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Gabu helaḡana bona hebou kalagana bona ihaboulana patana daidiai herohemaino karadia baine kara murinai, ia ese nani maruanena maurina baine hakaua mai Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Bena Aaron ese imana ruaosi na nani maruanena kwarana ai baine ato kau; bena ia ese Israel taudia edia kara dika bona edia kara havara bona edia kara rea iboudiai baine gwaurai hedinarai; iboudiai na nani maruanena kwarana ai baine ato kau. Bena tano ḡaḡaena baine siaia lao; tau ta, e abia hidi heḡaeḡae tauna, ese baine hakaua lao. ");
INSERT INTO meu_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Hari nani maruanena ese edia dika iboudiai baine huahai dauhai; bena tano ḡaḡaena ai baine ruhaia nege. ");
INSERT INTO meu_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Bena Aaron na hebou kalagana lalonai ma baine raka vareai, dabua aukadia, gabu helaḡana ai e raka vareai negana ai e kara ḡaudia, ma baine dokidia oho, baine atodia. ");
INSERT INTO meu_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Bena baine digu, gabu helaḡana ta ai; una murinai ena dabua ma baine kara, baine raka lasi, ena ḡole-oho boubouna bona Israel taudia edia ḡole-oho ḡauna baine aladia mase, baine haḡole oho, ia dainai bona idia daidiai herohemaino karana baine karaia. ");
INSERT INTO meu_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Kara rea boubouna digarana danu ihaboulaina patana latanai baine haḡolea oho. ");
INSERT INTO meu_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","A hari Asasele ena nani e hakaua lao tauna ese ena dabua baine huri bona baine digu; una mirunai ia na taruha lalonai ma baine raka vareai lou diba. ");
INSERT INTO meu_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Bena kara rea boromakauna bona kara rea nanina, raradia na herohemaino totona gabu helaḡana ai e vareailai ḡaudia, na taruha murimurinai bae laohaidia, kopidia bona hidiodia bona taḡedia na bae gabudia, lahi ese baine ḡoledia oho. ");
INSERT INTO meu_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Baine haḡoledia oho tauna ese ena dabua baine huri bona baine digu; bena taruha lalonai ma baine raka vareai. ");
INSERT INTO meu_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Baine mia hanaihanai haheḡanina binai, Israel taumui emui bona bogaragimui ai e noho hedoamu taudia edia: hua ihahituna ena dina ihagwautana ai umui na bavani vaga bona ḡaukara ta basio karaia, ");
INSERT INTO meu_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","badina be una dina ai ba herohemaino bona ba ḡoeva; emui dika iboudiai amo ba ḡoeva, Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Una dina na helaḡa herea emui ai, taunabunai bavani vaga. Baine mia hanaihanai haheḡanina bunai. ");
INSERT INTO meu_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Una dina ai hahelaḡa tauna, tamana gabuna ai bae horoa bona bae hahelaḡaia tauna, ese herohemaino karana baine karaia; ia ese dabua aukadia helaḡadia baine kara, ");
INSERT INTO meu_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","gabu helaḡana bona hebou kalagana bona ihaboulaina patana daidiai herohemaino karadia baine kara; bona hahelaḡa taudia bona orea taudia iboudiai daidiai herohemaino karana baine karaia. ");
INSERT INTO meu_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Baine mia hanaihanai taravatuna bunai umui emui; unuhetomana laḡani ta ta amo Israel taudia bae herohemaino bona edia dika bae hegwau tao. Bena unu e kara toma, Iehova ese Mose e haduaia heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Aaron mai natuna ida bona Israel taudia iboudiai ba hereva henidia, baoto, Iehova ena hahedua binai: ");
INSERT INTO meu_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Israel tauna ta ese horomakau maruanena eiava mamoe natuna eiava nani baine alaia mase, taruha lalonai eiava taruha murimurinai, ");
INSERT INTO meu_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","a hebou kalagana iduarana ai basine mailaia, Iehova ena ihaboulaina ḡauna ai basine halaoa Iehova ena ruma vairanai, rarana na ia latanai, badina be rara vada e hahebubua kerere: ia na ena bese amo bae negea daure. ");
INSERT INTO meu_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","A Israel taudia na edia boubou ḡaudia taruha murimurinai bae aladia mase negadia ai, idia ese Iehova dekena bae mailaidia, hebou kalagana iduarana ai, unuseni ai hahelaḡa tauna bae henia, edia herohemaino bouboudia ai bae halaodia Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Bena hahelaḡa tauna ese rara baine abia, Iehova ena ihaboulaina patana baine nevarilaia, hebou kalagana iduarana ai; bona digara baine haḡolea oho, bonana namo ḡauna ai bainela Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Taunabunai, idia na dirava koikoidia basie boudia, bona vairadiai basie lebulebu. Baine mia hanaihanai taravatuna bunai, idia ediai, edia uru iboudiai lalodiai. ");
INSERT INTO meu_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Ba haduadia danu, baoto: Israel tauna ta, eiava noho-hedoa tauna ta, ese ḡole-oho boubouna eiava idau boubouna ta baine alaia mase, ");
INSERT INTO meu_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","a hebou kalagana iduarana ai basine mailaia, Iehova ena ihaboulaina ḡau, una tau be ena bese amo bae negea daure. ");
INSERT INTO meu_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Israel tauna ta eiava noho-hedoa tauna ta, ese vamu mai rarana baine ania, lau ese una tau baina badu henia; ia na ena bese amo bae negea daure. ");
INSERT INTO meu_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Badina be hidio ena mauri be rara ai; vada na henimui, ihaboulaina patana ena, laumamui ihaḡoevadia. Rara na haheḡoeva ḡauna, badina ia lalonai be mauri. ");
INSERT INTO meu_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Taunabunai, Israel taudia vada na haḡanidia, nato: Asi tauna ta emui orea lalonai, bona asi tauna ta bogaragimui ai e noho hedoamu, vamu mai rarana baine ania. ");
INSERT INTO meu_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Israel tauna ta eiava noho-hedoa tauna ta baine labana, bena udaḡauna ta eiava roho manuna ta, aniani ḡauna, baine alaia mase, ia ese rarana baine hadihoa tano ai, bona ḡahu amo baine tahunia. ");
INSERT INTO meu_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Badina be mauri ḡaudia iboudiai edia mauri be rara ai. Taunabunai lau ese Israel taudia vada na haḡanidia, nato: Vamu mai rarana na basio ania, badina be mauri ḡaudia iboudiai edia mauri be rara ai; baine ania tauna na bae negea daure. ");
INSERT INTO meu_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","A tau ta, Israel tauna eiava noho-hedoa tauna, ese mase kava ḡauna eiava uda ḡaudia daḡedaḡedia ese e alaia ḡauna, baine ania, ia na ena dabua baine huri bona baine digu, bona baine taubu ela bona dina baine diho; una murinai ia na baine ḡoeva. ");
INSERT INTO meu_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","A ia na ena dabua basinema huri eiava basinema digu, ia na bema kerere. ");
INSERT INTO meu_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Iehova ese Mose e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Israel taudia ba hamaorodia, lau binai Iehova, emui Dirava. ");
INSERT INTO meu_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","O noholaiva tanona, Aigupto, taudia na edia kara basio kara; baina hakaumui vareai tanona, Kanaan, taudia danu edia kara basio kara bona edia taravatu basio badinadia. ");
INSERT INTO meu_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","A lauegu haheḡani bavabidia dae, bona lauegu taravatu ba badinadia; lau binai Iehova. emui Dirava. ");
INSERT INTO meu_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Taunabunai, egu taravatu bona egu haheḡani ba badinadia; unu baine kara toma tauna be baine mauri. Lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","varavaramu ta ida basio eno bou; lau Iehova na gwaumu. ");
INSERT INTO meu_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Tamamu ena geda ai basio hekure, sinamu ida basio eno bou; ia na sinamu, basio abia. ");
INSERT INTO meu_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Tamamu adavana ta ida basio eno bou; ia na tamamu ena. ");
INSERT INTO meu_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Taihumu ida basio eno bou; tamamu natuna hahinena ta eiava sinamu natuna hahinena ta, oi ida ruma tamona ai e vara, eiava idau ruma ai e vara, basio abia. ");
INSERT INTO meu_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Tubumu kekenina ida basio eno bou; natumu maruanena natuna eiava natumu hahinena natuna basio abia, badina be iena hemarai na oiemu hemarai. ");
INSERT INTO meu_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Tamamu adavana natuna hahinena, tamamu ese e havaraia, ida basio eno bou, ia na taihumu. ");
INSERT INTO meu_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Lalamu ida basio eno bou; ia na tamamu ida hidiotamona. ");
INSERT INTO meu_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Sinamu lahaina ida basio eno bou; ia na sinamu ida hidio tamona. ");
INSERT INTO meu_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Tamamu lahaina ena geda ai basio hekure, ia adavana ida basio eno bou; ia be varavaramu. ");
INSERT INTO meu_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Ravamu hahinena ida basio eno bou; ia na natumu adavana; basio abia. ");
INSERT INTO meu_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Ihamu ida basio eno bou; ia na tadikakamu ena. ");
INSERT INTO meu_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Hahine ta ida boma eno bou, ia natuna hahinena eiava tubuna kekenina ida basioma eno bou; idia na hidio tamona. Una na hemarai karana. ");
INSERT INTO meu_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Hahine ta boma adavaia, ia tadina ida basio hodara. ");
INSERT INTO meu_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Hahine ta basio raka henia kahi, ia ida ba eno bou totona, rara e hekaramu negana ai. ");
INSERT INTO meu_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Dekemu tauna adavana ida basio heuda hanai; una na kara mirona. ");
INSERT INTO meu_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Natumu ta dirava ladana Molek basio henia, ḡole-ohoboubouna ḡauna ai basinela; una na emu Dirava ladana ihadikana karana. Lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Tatau ida basio eno bou; una na kara mirona. ");
INSERT INTO meu_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Mauri ḡauna idauna ta ida basio eno bou; hahine danu unu basine kara toma; una kara na dika rohoroho. ");
INSERT INTO meu_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ini kara mirodia iboudiai na basio kara; badina be vairamui ai baina luludia lasi besedia be unu kara amo e hahemiromu. ");
INSERT INTO meu_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Tano danu vada e hamiroa; una dainai ena dika davana vada na henia. Tano na vada e dika; e noholaiava taudia vada e loridia lasi. ");
INSERT INTO meu_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","A umui ese egu taravatu bona egu haheḡani ba badinadia, bona unu kara mirodia basio kara, umui Israel taumui bona bogaragimui ai e noho hedoamu taudia danu. ");
INSERT INTO meu_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Badina be hari tano e noholaia gunava taudia ese unu kara mirodia e karava ema bona tano na vada e hamiroa. ");
INSERT INTO meu_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Bena umui ese unu ba hamiroa toma, ia ese umui danu baine lorimui lasi, e noholaia gunava taudia e loridia lasi na heto. ");
INSERT INTO meu_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Badina be unu kara mirodia bae kara taudia iboudiai na edia bese amo bae negedia daure. ");
INSERT INTO meu_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Taunabunai, egu hahedua ba badinaia: unu kara mirodia, e gunalaimui taudia ese e kara, na umui basio kara, unu kara amo basio hahemiro. Lau binai Iehova, emui Dirava. ");
INSERT INTO meu_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Iehova ese Mose e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Israel taudia iboudiai ba hamaorodia, baoto: Umui na ba helaḡa, badina be lau Iehova, emui Dirava, name helaḡa. ");
INSERT INTO meu_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Iboumui ai sinamui bona tamamui ba matauraidia, bona egu dina helaḡadia ba badinadia. Lau binai Iehova, emui Dirava. ");
INSERT INTO meu_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Dirava koikoidia basio toma henidia diho, bona dirava laulaudia auri amo basio kara. Lau binai Iehova, emui Dirava. ");
INSERT INTO meu_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Emui herohemaino bouboudia, Iehova ena, be mailaidia negadia ai, kara idoidiai ba kara ḡoevaḡoeva, bena baine abimui dae. ");
INSERT INTO meu_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Boubou ḡauna hidiona na bavalaia dinana ai eiava dina iharuana ai bavania; dina ihatoina ai bahu na ba haḡolea oho. ");
INSERT INTO meu_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Dina ihatoina ai boma ania, una na kara mirona; Iehova ese emui boubou basine abia dae: ");
INSERT INTO meu_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ianina tauna baine kerere, badina be Iehova ena ḡau helaḡana vada e hahemaraia; ena bese amo l bae negea daure. ");
INSERT INTO meu_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Emui uma anidia ba utu negana ai, basio utua lao ela bona emu inoḡo hetoana korikori ai; bona tano ai bae moru ḡaudia basio gogo. ");
INSERT INTO meu_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Emu vine anidia danu basio buruki ore, bona vine huahuadia tano ai bae moru be basio gogo: bae mia, ogoḡami tauna ana eiava noho-hedoa tauna ana. Lau binai Iehova, emui Dirava. ");
INSERT INTO meu_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ḡau ta basio henaoa. Basio kara koikoi. Basio hereva koikoi. ");
INSERT INTO meu_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Lau ladagu ai basio gwau hamata koikoi; emu Dirava ladana basio hahemaraia. Lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Dekemu tauna basio daḡedaḡe henia, ena ḡau ta danu basio dadia. Ḡaukara tauna ena ḡaukara davana basio dogoa tao ela bona daba ai. ");
INSERT INTO meu_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Taiakudima tauna basio uduguiraia; mata-kepulu tauna basio hahekwakwanaia; emu Dirava garina ba gari. Lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Basio hahemaoro koikoi: ogoḡami tauna basio bogaia hisi, bona taḡa tauna basio matauraia; kara maoromaoro ai dekemu taudia ba hahemaoro henidia. ");
INSERT INTO meu_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Sivarai koikoi basio piupiulai, emu orea taudia bogaragidiai. Dekemu tauna ena mauri basio abia oho, hahebade koikoi dainai. Lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Tadikakamu basio inai henia lalomu ai. Dekemu tauna ba sisiba henia, iena kerere amo oi danu ba kerere na garina. ");
INSERT INTO meu_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Kara dika davana basio haloua. Emu bese taudia natudia na basio lalo-hisihisi henidia. Dekemutauna ba lalokau henia, sibomu o helalokaumu heḡereḡerena. Lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Egu taravatu ba badinadia. Emu ubu-ubu ḡaudia orea idau-idaubasio haheḡodaḡodadia. Uhe idau-idau inoḡo tamona ai basio hado. Dabua idau-idau amo e karaia hahedokina basio dokilaia. ");
INSERT INTO meu_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Tau ta ese hesiai kekenina ida baine eno bou, a una kekeni be mai maohenina, bona heni-tao monina dainai eiava hebogahisi dainai ena hesiai ilao-henina amo do se ruhaia nege, kara anina bae tahu henidia; to basie aladia mase, badina be hahine na do se ruhaia nege. ");
INSERT INTO meu_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Kerere tauna ese ena kara dika boubouna baine mailaia, hebou kalagana iduarana ai Iehova baine henia. Ena boubou ḡauna na mamoe maruanena ta. ");
INSERT INTO meu_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Bena hahelaḡa tauna ese ena kara dika boubouna baine abia, Iehova vairanai herohemaino karana baine karaia, una tau dainai; bena ena dika baine hegwau tao. ");
INSERT INTO meu_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Ba noholaia tanona ai ba kau bona emui au huahua idau-idau unuseniai ba hado negana ai anidia ba gwaurai helaḡa; laḡani toi lalodiai bae helaḡa emui ai, basio ani. ");
INSERT INTO meu_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Laḡani ihahanina ai anidia bae helaḡa, boubou ḡaudia ai baela, Iehova ihanamolaina. ");
INSERT INTO meu_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","A laḡani iha-imana ai, anidia bavabi, bavani, anidia na emui ai bae hoho helaoreana. Lau binai Iehova, emui Dirava. ");
INSERT INTO meu_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Vamu mai rarana na basio ania. Mari karadia bona mea karadia basio kara. ");
INSERT INTO meu_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Kwaramui huidia basio nau heḡeḡe, bona aukimui huidia basio utu heini. ");
INSERT INTO meu_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Mase daidiai kopimui basio iva bona revareva basio atu. Lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Natumu kekenina basio hahemaraia, ariara hahinena ai basio halaoa, tano na lebulebu bona kara havara ai baine honu na garina. ");
INSERT INTO meu_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Egu dina helaḡadia ba badinadia; egu gabu helaḡana ba matauraia. Lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Rohe taudia bona babalau taudia na basio lao henidia; basio tahudia bona, edia kara miro ai basio miro. Lau binai Iehova, emui Dirava. ");
INSERT INTO meu_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Tau burukana vairanai ba tore isi; iahu ba matauraia; emu Dirava garina ba gari. Lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Bogaragimui ai e noho hedoamu tauna na basio daḡedaḡe henia; ");
INSERT INTO meu_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","noho-hedoa tauna na emui bese tauna korikori heḡereḡerena baine noho bogaragimui ai. Ba lalokau henia, sibomu o helalokaumu heḡereḡerena; badina be umui danu Aigupto tanona ai o noho hedoava. Lau binai Iehova, emui Dirava. ");
INSERT INTO meu_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Basio hahetoho koikoi. Lata hahetohodia bona metau hahetohodia bona anina hahetohodia basio ha-idau koikoi. ");
INSERT INTO meu_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Emui hahetoho ḡaudia bona edia metau ḡaudia bae maoro; bona emui efa bona emui hini danu bae maoro. Lau binai Iehova, emui Dirava; Aigupto tanona amo na hakaumui lasi. ");
INSERT INTO meu_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Egu taravatu iboudiai bona egu haheḡani iboudiai ba badinadia, karadia ba kara. Lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Iehova ese Mose e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Israel taudia ma ba hamaorodia, baoto: Israel tauna ta eiava noho-hedoa tauna taese natuna na ḡole-oho boubouna ai baine halaoa, dirava koikoina Molek ena, ia na momokani baine mase: hanua taudia ese nadi amo bae hodoa mase. ");
INSERT INTO meu_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Lau danu vairagu baina ha-aukaia una tau enai, bona ena beseamo baina negea daure; badina be natuna na Molek e henia, unu amo ia ese lauegu gabu helaḡana vada e hamiroa, bona lau ladagu helaḡana vada e hahemaraia. ");
INSERT INTO meu_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","A hanua taudia ese hari natuna Molek e henia tauna bema bogaia hisi, basiema hodoa mase, ");
INSERT INTO meu_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","lau ese vairagu baina ha-aukaia una tau enai bona ena iduhu taudia iboudiai ediai; edia bese amo baina negea daure, ia bona ia ida Molek vairani, eha lebulebu taudia iboudiai danu. ");
INSERT INTO meu_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Rohe taudia bona mea taudia baine lao henidia bona idia ida baine kara havara tauna danu, lau ese vairagu baina ha-aukaia ienai, bona ena bese amo baina negea daure. ");
INSERT INTO meu_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Taunabunai, sibomui ba hahelaḡa, bena ba helaḡa noho; badina be lau na Iehova emui Dirava. ");
INSERT INTO meu_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Egu taravatu ba badinadia, karadia ba kara: lau binai Iehova, ihahelaḡamui Diravana. ");
INSERT INTO meu_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Tamana eiava sinana e uduguiraiamu tauna na bae alaia mase; tamana eiava sinana e uduguiraia dainai, rarana be sibona latanai. ");
INSERT INTO meu_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Tau ta na dekena tauna adavana ida bae heuda hanai, tau bona hahine raruosi na bae aladia mase. ");
INSERT INTO meu_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Tau ta na tamana adavana ida bae heuda hanai, tamana baine hahemaraia, raruosi na bae aladia mase. Raradia na sibodia latadiai. ");
INSERT INTO meu_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Tau ta na rava maraḡi hahinena ida bae heuda hanai, raruosi na bae aladia mase. Idia na kara dika-hereana vada e karaia; raradiana sibodia latadiai. ");
INSERT INTO meu_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Tau ta na ma tau ta ida bae eno bou, una na kara mirona: raruosi na bae aladia mase; raradia na sibodia latadiai. ");
INSERT INTO meu_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Tau ta ese adavana baine eno henia bona ma sinana danu, una na kara dika-hereana:tatoiosi na lahi ai bae hamasedia, una kara dikana bogaragimui ai baine doko helaoreana. ");
INSERT INTO meu_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Tau ta na mauri ḡauna idauna ta ida bae eno bou, ia bae alaia mase bona hari mauri ḡauna danu bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Eiava hahine ta na mauri ḡauna idauna ta ida bae eno bou, ia bona hari mauri ḡauna bavaladia mase; vada bae mase, raradia na sibodia latadiai. ");
INSERT INTO meu_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Tau ta ese taihuna ta, tamana natuna eiava sinana natuna, baine abia, ia ida bae eno bou, una na hemarai karana; edia bese bogaragidia amo bae luludia lasi. Ia ese taihuna vada e hahemaraia; ena kara dika madunana baine huaia. ");
INSERT INTO meu_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Tau ta na hahine ta ida bae eno bou, rara e karaia negana ai, ia ese hahine rarana vada e hahemaraia, bona hahine ese sibona rarana vada e hahemaraia; raruosi na edia bese amo bae negedia daure. ");
INSERT INTO meu_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Sinamu lahaina eiava lalamu ida basio eno bou, badina be idia na varavaramu; emui kara dika madunana ba huaia. ");
INSERT INTO meu_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Tau ta na tamana lahaina adavana ida bae eno bou, una na tamana lahaina ihahemaraina karana; edia kara dika madunana bae huaia: bae noho gabani ela bona mase. ");
INSERT INTO meu_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Tau ta na ihana ida bae eno bou, una na kara mirona; ia ese tadikakana vada e hahemaraia. Idia na bae noho gabani. ");
INSERT INTO meu_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Benaini: egu taravatu bona egu haheḡani ba badinadia, bona karadia ba kara; bena baina henimui ba noholaia tanona ese basine lorimui lasi. ");
INSERT INTO meu_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Vairamui ai baina luludia Iasi besedia edia kara basio tohotohodia; badina be idia ese ini kara bodagadia idoidiai vada e kara, una dainai lau ese na inai henidiamu. ");
INSERT INTO meu_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","A lau ese vada na gwau henimui hamata, nato, Edia tano bavabia emui; baina henimui emui tano korikori, rata bona bada ranuna e arumu tanona bunai. Lau binai Iehova emui Dirava; bese idau-idau bogaragidia amo vada na abimui hidi. ");
INSERT INTO meu_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Taunabunai, mauriḡaudia ḡoevaḡoevadia bona mirodia ba hididia, tano ai e loamu ḡaudia bona atai ai e rohomu manudia danu. Lau ese vada na gwauraidia miro ḡaudia, tano ai e loamu ḡaudia eiava atai ai e rohomu manudia eiava e raumu ḡaudia, na mirodia ai basio miro. ");
INSERT INTO meu_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Umui na ba helaḡa lauegu ai; badina be lau Iehova name helaḡa, bona bese idau-idau bogaragimui amo vadana hidimui, egu bese ai baola helaoreana. ");
INSERT INTO meu_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Rohe bona mea tauna eiava hahinena na bae aladia, nadi amo bae hododia mase. Raradia na sibodia latadiai. ");
INSERT INTO meu_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Iehova ese Mose e hereva henia, eto, Hahelaḡa taudia, Aaron natuna, ba hamaorodia, idia ta ese ena hanua masena ta latanai e helaḡalaimu karadia ai basine dau kau; ");
INSERT INTO meu_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","varavarana mo latadiai: sinana, eiava tamana, eiava natuna, eiava tadikakana, ");
INSERT INTO meu_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","eiava taihuna hane-ulato rami-hebou latanai; badina be ia na varavarana, bona asi adavana, ia dainai baine dau kau. ");
INSERT INTO meu_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","A ena hanua masena ta latanai e helaḡalaimu karadia ai basine dau kau, badina be ia na ena bese lohiana. ");
INSERT INTO meu_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Hahelaḡa taudia na kwaradia basie naudia, bona aukidia huidia basie utu heini, bona kopidia basie ivadia. ");
INSERT INTO meu_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Edia Dirava enai bae helaḡa; edia Dirava ladana basie hahemaraia. Badina be boubou ḡaudia be idia ese lahi ai e hahelaḡadiamu, Iehova ena, bona edia Dirava ena flaoa idia ese e hahelaḡaiamu; taunabunai idia bae helaḡa. ");
INSERT INTO meu_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Idia na ariara hahinedia eiava lebulebu hahinedia eiava diho hahinedia basie adavadia; badina be hahelaḡa tauna na helaḡa, ena Dirava enai. ");
INSERT INTO meu_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Oi ese ia ba hahelaḡaia, badina be emu Dirava ena flaoa ia ese baine hahelaḡaia; bena emu ai baine helaḡa, badina be lau Iehova, umui ihahelaḡamui Diravana, na helaḡa. ");
INSERT INTO meu_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Hahelaḡa tauna natuna hahinena baine lebulebu, bena ena lebulebu amo ia ese tamana baine hahemaraia, vada bae hamasea lahi ai. ");
INSERT INTO meu_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Hahelaḡa tauna badana, tadikakana e biagudiamu tauna, dehoro helaḡana e horolaia tauna, e hahelaḡaia dabua helaḡadia baine dokilai tauna, ia ese huina basine ḡiḡi rohoroho, bona ena dabua basine dare. ");
INSERT INTO meu_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Mase ta basine raka henia kahi; ena be tamana eiava sinana, to ia latanai e helaḡalaimu karadia ai basine dau kau. ");
INSERT INTO meu_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Gabu helaḡana basine rakatania, ena Dirava ena gabu helaḡana basine hahemaraia; badina be ena Dirava ena dehoro helaḡana ese vada e hahelaḡaia. Lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Hane-ulato rami-hebou ta baine adavaia; ");
INSERT INTO meu_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","vabu eiava diho hahinena eiava vada e hamiroa hahinena eiava ariara hahinena basine adavaia. Hane-ulato rami-hebou ta, ena beseamo mo, baine adavaia; ");
INSERT INTO meu_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","unu amo natuna na basie hemarai ena bese taudia bogaragidiai; badina be lau Iehova ese vada na hahelaḡaia. ");
INSERT INTO meu_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Iehova ese Mose ma e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Aaron ini ba hamaoroa toma, baoto: Uru ta ai emu iduhu tauna ta bema mai bebeka-bebekana, iana basine raka kahi mai, ena Dirava ena flaoa ihahelaḡana. ");
INSERT INTO meu_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Badina be tau-anina mai bebeka-bebekana tauna na basine raka kahi mai: mata-kepulutauna, eiava ae-hedairike tauna, eiava vairana eiava regena ta mai berona tauna, ");
INSERT INTO meu_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","eiava imana eiava aena e bero tauna, ");
INSERT INTO meu_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","eiava doru-laoho tauna, eiava tau kwadogi-herea eiava mata-gegeva tauna, eiava kopi-hemaihemai gorerena tauna, eiava kopina mai taohana tauna, eiava abona nadinadina e heala tauna. ");
INSERT INTO meu_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Asi tauna ta Aaron ena iduhu amo mai bebeka-bebekana baine raka kahi mai, boubou ḡaudia lahi ai baine hahelaḡadia Iehova ena, eiava ena Dirava ena flaoa baine hahelaḡaia, totona. ");
INSERT INTO meu_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Ena Dirava ena flaoa, helaḡa ḡauna bona helaḡa-herea ḡauna, baine ani diba; ");
INSERT INTO meu_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","a seseahu basine raka henia kahi, bona ihaboulaina patana basine raka henia kahi, badina be ia na mai bebeka-bebekana. Una dainai, ia na lauegu gabu helaḡadia basine hamirodia; badina be lau Iehova ese vada na hahelaḡadia. ");
INSERT INTO meu_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Ini hereva iboudiai Mose ese Aaron mai natuna ida bona Israel taudia iboudiai e hamaorolaidia. ");
INSERT INTO meu_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Iehova ese Mose e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Aaron mai natuna ida taravadia bavatu, idia na Israel taudia edia boubou ḡaudia helaḡadia, lau dekegu ai e mailaidiamu ḡaudia, na bae matauraidia, lau ladagu helaḡana basie hahemaraia: lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Ba hamaorodia, baoto: Emui uru iboudiai lalodiai emui iduhu tauna ta ese Israel taudia edia boubou ḡaudia, e hahelaḡadiamu Iehova ena, baine raka henidia kahi mai mirona ida, una tau be lau vairagu ai bae negea daure. Lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Aaron ena iduhu tauna ta lepra eiava enobou gorerena baine davaria, ia ese aniani helaḡadia basine ani ela bona tauna baine ḡoeva. Bona ta ese mase dainai vada e miro ḡauna ta baine daua toho, eiava vesina e arumu tauna ta baine daua toho, ");
INSERT INTO meu_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","eiava tano ai e raumu ḡauna mirona ta baine daua toho, eiava edena miro edena miro amo vada e hahemiro tauna baine daua toho, ");
INSERT INTO meu_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","una miro baine daua toho tauna na baine taubu ela bona dina baine diho; bona aniani helaḡana basine ania ela bona ranu ai baine digu. ");
INSERT INTO meu_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","A dina baine diho, bena baine ḡoeva; una murinai ia ese aniani helaḡana baine ania, badina be ena heubu ḡauna bunai. ");
INSERT INTO meu_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","E mase kava ḡauna eiava uda boromadia ese e hamasea ḡauna na basine ania, baine miro na garina: lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Taunabunai, egu haheḡani bae badinadia; bae tata utu negana ai bae kara dika bona edia kara dika ai bae mase na garina. Lau Iehova ese vada na hahelaḡadia. ");
INSERT INTO meu_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Idau iduhu tauna ta ese aniani helaḡana basine ania; hahelaḡa tauna ena vadivadi ese basine ania; hesiai tauna mai davana ese basine ania. ");
INSERT INTO meu_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","A hahelaḡa tauna ese moni amo e hoia tauna ese baine ania; bona hahelaḡa tauna ena ruma ai hesiai ai e vara tauna ese danu baine ania. ");
INSERT INTO meu_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Hahelaḡa tauna natuna hahinena ese idau iduhu tauna ta baine adavaia, ia ese aniani helaḡana, e duduia isi boubouna hidiona, na basine ania. ");
INSERT INTO meu_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","A hahelaḡa tauna natuna hahinena bema vabu, eiava bema diho, asi natuna, bena tamana ena ruma bema lou henia, unuseni ai bema noho, kekenina negana heḡereḡerena, ia be tamana ana aniani baine ania. A idau iduhu tauna ta basine ania diba. ");
INSERT INTO meu_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Tau ta ese aniani helaḡana baine ania kava, asi dibana vada e helaḡa dainai, ia ese davana na hahelaḡa tauna baine henia mai ato-kauna ida; ato-kauna na e ania ḡauna bema karoa, karoa ima, benakaroa ta heḡereḡerena ma baine atoa kau. ");
INSERT INTO meu_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Israel taudia edia boubou ḡaudia helaḡadia Iehova e heniamu na hahelaḡa taudia ese basie ani kava ani kava; ");
INSERT INTO meu_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","aniani helaḡadia bae ani kava na e mailaidia taudia bae hakereredia; badina be lau Iehova ese vada na hahelaḡadia. ");
INSERT INTO meu_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Iehova ese Mose ma e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Aaron mai natuna ida bona Israel taudia iboudiai ba hamaorodia, baoto: Israel tauna ta eiava Israel taudia bogaragidiai e noho hedoamu tauna ta ese boubou ḡauna baine mailaia, gwau-hamata dainai eiava lalo-namo dainai, Iehova ena ḡole-oho ḡauna ai baine halaoa; ");
INSERT INTO meu_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Iehova ese baine abia dae helaoreana, ihenina tauna ese boromakau maruanena eiava mamoe maruanena eiava nani maruanena asi bebeka-bebekana ta baine mailaia. ");
INSERT INTO meu_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","A mai bebeka-bebekana ḡauna basine mailaia, badina be Iehova ese basine abia dae. ");
INSERT INTO meu_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Herohemaino boubouna baine mailaia tauna danu, gwau-hamata dainai eiava lalo-namodainai baine mailaia, Iehova ese baine abia dae helaoreana ihenina tauna ese boromakau eiava mamoe asi bebeka-bebekana ta baine mailaia. ");
INSERT INTO meu_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Matakepulu ḡauna eiava ae-hedairike ḡauna eiava mai berona eiava mai totona eiava mai kuhikuhina eiava mai taohana ḡauna na basio mailaia, Iehova ena ihaboulaina patana latanai basio haḡolea oho. ");
INSERT INTO meu_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Boromakau maruanena eiava mamoe natuna na imana ta eiava aena ta baine kwadogi eiava baine lata, vada ba henia diba, lalo-namo boubouna, to basio mailaia gwau-hamatadavana. ");
INSERT INTO meu_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ḡau ta abona nadinadina na e toto eiava e pata eiava e hedare eiava e heiva na basio mailaia Iehova ena, emui boubou ḡauna ai basio halaoa, emui tano idoinai. ");
INSERT INTO meu_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Idau bese tauna ena amo unuhetomana ta bavabia, emui boubou ḡauna ai ba halaoa, Iehova ese basine abia dae, badina be idia na mimiro bona mai bebeka-bebekadia. ");
INSERT INTO meu_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Iehova ese Mose ma e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Boromakau eiava mamoe eiava nani baine vara negana ai, ia na dina hitu sinana dekenai baine noho; dina ihataurahanina ai bona dina ihataurahanina murinai ia na heḡereḡere ḡole-oho boubouna ai ba halaoa, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","A sinana, boromakau hahinena eiava mamoe hahinena, na natuna ida dina tamona ai basio aladia hebou. ");
INSERT INTO meu_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Emui hahenamo bouboudia Iehova ba henia negadia ai na ba hahelaḡadia namonamo, bena Iehova ese baine abidia dae. ");
INSERT INTO meu_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Boubou hidiona na bavalaia dinana ai bavania; bahu na basine mia rani. Lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Benaini, egu haheḡani ba badinadia, karadia ba kara: lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Lau ladagu helaḡana basio hahemaraia; Israel taudia ese lau ladagu bae hahelaḡaia: lau binai Iehova, umui ihahelaḡamui Diravana. ");
INSERT INTO meu_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Lau ese Aigupto tanona amo na hakaumui lasi, emui Dirava ai bainala helaoreana. Lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Iehova ese Mose e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Israel taudia ba hamaorodia, baoto Iehova ena aria bini; ini aria negadia ai emui hebou helaḡadia ba kara. ");
INSERT INTO meu_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Dina tauratoi ai ba ḡaukara, a dina ihahituna na dina helaḡana, laḡa-ani dinana, hebou helaḡana dinana. Una dina ai basio ḡaukara; ia naIehova ena Dina Helaḡa, emui noho gabudia iboudiai. ");
INSERT INTO meu_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Iehova ena aria bini; emui hebou helaḡadia edia nega korikori ai do ba kara. ");
INSERT INTO meu_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Hua gini-gunana dinana ihagwauta-hanina hanuaboina na Iehova ena lagau-hanai. ");
INSERT INTO meu_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Hua dinana ihagwauta-imana na asie hatubua flaoana ariana, Iehova ena; dina hitu lalodiai asie hatubua flaoana mo bavania. ");
INSERT INTO meu_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Aria dinana gini-gunana ai emui hebou helaḡana ba karaia, bona ḡaukara badana ta basio karaia. ");
INSERT INTO meu_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Dina hituosi lalodiai emui ḡole-oho bouboudia Iehova ba henia; bena dina ihahituna ai emui hebou helaḡana ma ba karaia lou. Una dina ai danu ḡaukara badana ta basio karaia. ");
INSERT INTO meu_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Iehova ese Mose ma e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Israel taudia ba hamaorodia, baoto: Baina henimui tanona ai ba kau murinai, emui uma anidia ba utu negadia ai na emui iḡui roboana na hahelaḡa tauna dekena ba laohaia; ");
INSERT INTO meu_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","bena ia ese iḡui baine abia, Iehova vairanai baine davea, Iehova ese baine hanamomui helaoreana. Dina Helaḡa murina dinana ai hahelaḡa tauna ese iḡui baine davea; ");
INSERT INTO meu_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","bena una iḡui idavena dinana ai mamoe natuna maruanena asi bebeka-bebekana, laḡani tamona ḡauna, bavabia, ḡole-oho boubouna ḡauna ai ba halaoa, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Flaoa boubouna danu ia ida ba heni: flaoa namo-hereana efa ta ba karoa, karoa gwauta, bena karoa rua bavabi, emui boubou ḡauna. Dehoro ida ba bulo, bena lahi ai ba haḡolea oho, bonana namo ḡauna ai bainela, Iehova ena. Inuinu boubouna danu idia ida ba heni, vine ranuna kehere ta. ");
INSERT INTO meu_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Flaoa basio ania; uit danu, e hakaukaua ḡauna eiava matamatana, basio ania; ela bona emui boubou ḡauna na emui Dirava dekenai ba laohaia dinana ai bavania. Ina taravatu baine mia hanaihanai emui uru iboudiai bona emui noho gabudia iboudiai lalodiai. ");
INSERT INTO meu_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Una dina amo, hari Dina Helaḡa murina dinana, emui iḡui roboadia ba heni davedave bouboudia ai baela dinana, pura hitu ba duahidia. ");
INSERT INTO meu_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Dina imahui ba duahidia, ela bona Dina Helaḡa ihahituna murina dinana; una dina ai flaoa matamatana boubouna Iehova ba henia. ");
INSERT INTO meu_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Emui ruma amo flaoa namo-hereana efa ta ba karoa, karoa ima, bena karoa ta bavabia, ihatubuna muramurana ida ba buloa; bena ba gabua, igabu rua ba kara, davedave boubouna ḡaudia, emui flaoa matamatana amo. ");
INSERT INTO meu_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Bona flaoa igabudia ida mamoe natudia asi bebeka-bebekadia hitu, laḡani tamona ḡaudia, bona boromakau natuna maruanena ta, bona mamoe mamaruanedia rua, ḡole-oho boubouna ai baela, Iehova ena, flaoa boubouna bona inuinu bouboudia ida; idoinai bonana namo boubouna ai bainela lahi ai, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Kara rea boubouna danu ba henia, nani maruanena ta, bona herohemaino boubouna, mamoe natuna mamaruanedia rua, laḡani tamona ḡaudia. ");
INSERT INTO meu_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Hahelaḡa tauna ese baine davedia, flaoa matamatana bouboudia ida, idoinai, hari mamoe natuna ruaosi ida, davedave boubouna ai bainela, Iehova ena. Idia na Iehova ena ḡau helaḡadia, hahelaḡa tauna ana. ");
INSERT INTO meu_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Una dina tamona ai danu taunimanima ba boiridia hebou, emui hebou helaḡana ba karaia; una dina ai ḡaukara badana ta basio karaia. Ina taravatu baine mia hanaihanai, emui uru iboudiai bona emui noho gabudia iboudiai lalodiai. ");
INSERT INTO meu_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Emui uit eiava emui bali ba utua negana ai, basio utua ela bona emu inoḡo hetoana korikori ai, bona tano ai bae moru anidia basio gogo: bae mia, oroḡami tauna eiava noho-hedoa tauna ana. Lau binai Iehova, emui Dirava. ");
INSERT INTO meu_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Iehova ese Mose ma e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Israel taudia ba hamaorodia, baoto: Hua ihahituna dinana gini-gunana na laḡa-ani dinanahelaḡana ta emui, helalo-tao dinana mai kibi ihiriridia, bona hebou helaḡana dinana. ");
INSERT INTO meu_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Una dina ai ḡaukara badana ta basio karaia; a ḡole-ohoboubouna Iehova ba henia. ");
INSERT INTO meu_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Hua ihahituna dinana ihagwautana na herohemaino dinana: una dina ai emui hebou helaḡana ba karaia, bona ba helalo kerehai, bona ḡole-oho boubouna Iehova ba henia. ");
INSERT INTO meu_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Una dina ai ḡaukara ta basio karaia, lasi vaitani; badina be ia na herohemaino dinana. Iehova emui Dirava ida ba herohemaino una dina ai. ");
INSERT INTO meu_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","A tau ta una dina ai basine helalo, ia na ena bese amo bae negea daure. ");
INSERT INTO meu_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Bona tau ta una dina ai baine ḡaukara, lau ese baina hamasea, ena bese taudia bogaragidia amo. ");
INSERT INTO meu_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ḡaukara ta basio karaia, lasi ona lasi vaitani: ina taravatu baine mia hanaihanai, emui uru iboudiai bona emui noho gabudia iboudiai lalodiai. ");
INSERT INTO meu_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ina na dina helaḡa badana, emui laḡa-ani dinana badana, bona emui helalo dinana badana: hua dinana ihataurahani-tana ai dina baine diho elabona dina ihagwautana ai dina baine diho ina dina helaḡana ba badinaia. ");
INSERT INTO meu_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Iehova ese Mose ma e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Israel taudia ba hamaorodia, baoto: Ina hua ihahituna dinana ihagwauta-imana na kalaga ariana ba matamaia dina hitu lalodiai ba karaia, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Aria dinana gini-gunana ai, hebou helaḡana ba karaia; hau dina ai ḡaukara badana ta basio karaia. ");
INSERT INTO meu_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Dina ta ta ai, ela bona dina hituosi bae ore, ḡole-oho bouboudia Iehova ba henia. Bena dina ihataurahanina ai emui hebou helaḡana ba karaia, bona ḡole-oho boubouna Iehova ba henia. Ia na hebou helaḡana badana; ḡaukara badana ta basio karaia una dina ai. ");
INSERT INTO meu_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Iehova ena aria bunu; ba badinadia, dina helaḡadia bona hebou helaḡadia dinadia. Emui boubou ḡaudia na lahi ai ba gabudia: ḡole-oho bouboudia bona flaoa bouboudia, boromakau bona mamoe, inuinu bouboudia danu, ta ta ena dina ena dina ai. ");
INSERT INTO meu_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ini be idau; a Iehova ena dina helaḡa, pura ta ta ai, bona emui herahia ḡaudia, bona emui gwau-hamata bouboudiaiboudiai, bona emui lalo-namo bouboudia iboudiai, Iehova o heniamu, bema idau. ");
INSERT INTO meu_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Benaini, hua ihahituna dinana ihagwauta-imana, uma anidia iboudiaiba haboudia murinai, Iehova ena aria ba karaia dina hitu lalodiai. Aria dinana gini-gunana na laḡa-ani helaḡa dinana, bona aria dinana ihataurahanina na laḡa-ani helaḡa dinana. ");
INSERT INTO meu_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Dina gini-gunana ai au namodia huahuadia bavabi, bona reta, bona au rigidia mai raudia ida, bona arabimi sinavai isena amo; bena Iehova vairanai ba moale hebou, dina hituosi lalodiai. ");
INSERT INTO meu_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Laḡani ta ta lalodiai ina aria dinadia hituosi do ba badinadia: egu haheḡani bunai, uru uru idoidiai ela bona hanaihanai. Hua ihahituna ai una aria ba karaia. ");
INSERT INTO meu_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Unu dina hituosi lalodiai umui na kalaga ai ba noho; Israel taudia iboudiai kalaga bae noholai; ");
INSERT INTO meu_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","unu amo uru gabedia bae diba lau ese Israel taudia na kalaga ai na hanohodia, Aigupto tanona amo na hakaudia lasi negana ai. Lau binai Iehova, emui Dirava. ");
INSERT INTO meu_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Bena Mose ese Israel taudia e haboudia, Iehova ena aria herevadia e hadibalaidia. ");
INSERT INTO meu_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Israel taudia ba haduadia, olive dehorona ḡoevaḡoevana, lamepa ḡauna, bae henimu, lamepa baine ara hanaihanai helaoreana. ");
INSERT INTO meu_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Hebou kalagana Ialonai, maua helaḡana seseahuna murimurinai, baine ara; Aaron ese baine reḡua, hanuaboi iboudiai baine ara rani Iehova vairanai. Haheḡanina binai baine mia hanaihanai emui uru iboudiai lalodiai. ");
INSERT INTO meu_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Aaron ese lamepa baine reḡudia, lamepa patana ai, gold namo-hereana amo e karaia ḡauna, Iatanai bae ara hanaihanai, Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Flaoa namo-hereana bavabia, ba gabua, igabu gwauta-rua. Flaoa efa ta ba karoa, karoa gwauta, bena karoa rua rua bavabi, igabu ta ta ikaralaidia. ");
INSERT INTO meu_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Bena Iehova vairanai ba dabara, gold namo-hereana amo e karaia patana latanai; ere rua ai bavatodia, ere ta igabu tauratoi, ma ere ta igabu tauratoi. ");
INSERT INTO meu_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Ere ruaosi latadiai muramura mai bonana ḡoeva-daena bavatoa kau, iana flaoa ida helalo-tao toana ai baela, bona lahi boubouna ai baela, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Dina Helaḡa ta ta ai, hahelaḡa tauna ese flaoa helaḡana unu baine dabaraia toma Iehova vairanai; Israel taudia daidiai baine dabaraia, herohemaino toana, baine hesiriu hanaihanai. ");
INSERT INTO meu_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Una flaoa na Aaron mai natuna ida adia; gabu helaḡana ai bae ania, Iehova ena Iahi bouboudia iboudiai ia mo sibona helaḡa herea. Mia-hanaihanai taravatuna bunai. ");
INSERT INTO meu_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Tau ta, sinana na hane Israel, tamana na Aigupto tauna, e raka lasi. Israel taudia bogaragidiai: bena ia na Israel tauna korikorina ta ida e heai. taruha lalonai. ");
INSERT INTO meu_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Bena hari hane Israel natuna ese Lada Helaḡana e uduguiraia, hereva metaudia e gwaurai. Bena haida ese e hakaua lao, Mose vairanai. Sinana ladana na Selomiti Dibri, Dan iduhuna hahinena. ");
INSERT INTO meu_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Bena e ḡuia, ela bona Iehova ena hahemaoro herevana bae diba. ");
INSERT INTO meu_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Bena Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Heuduguirai tauna na taruha murimurinai ba hakaua lasi; bena ena heuduguirai herevadia e kamonai taudia iboudiai ese imadia na ia tubuana ai bae ato kau, murinai hebou taudia iboudiai ese nadi amo bae hodoa mase. ");
INSERT INTO meu_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Israel taudia ba hadibadia danu, ena Dirava baine uduguiraia tauna ese sibona ena dika madunana baine huaia. ");
INSERT INTO meu_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Iehova ladana baine uduguiraia tauna na baine mase; hebou taudia iboudiai ese bae hodoa mase. Ena be noho-hedoa tauna eiava Israel tauna korikori, to Lada Helaḡana bema uduguiraia, vada bae hodoa mase. ");
INSERT INTO meu_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Tau ta baine alaia mase tauna danu bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Mauri ḡauna ta baine alaia mase tauna ese davana baine heni; mauri ḡauna davana be mauri ḡauna. ");
INSERT INTO meu_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Tau ta ese dekena tauna baine haberoa, e haberoa heḡereḡerena ai ia danu bae haberoa. ");
INSERT INTO meu_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Bero davana bero, mara davana mara, ise davana ise; e karaia heḡereḡerena ma ba kara henia. ");
INSERT INTO meu_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Mauri ḡauna idauna baine alaia mase tauna ese davana baine heni; a taunimanima baine alaia mase tauna na bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Noho-hedoa tauna bona Israel tauna korikori taravatudia na tamona: lau Iehova emui Dirava na gwaumu. ");
INSERT INTO meu_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mose ese Israel taudia unu e haḡanidia toma; bena idia ese heuduguirai tauna e hakaua lasi, taruha murimurinai, nadi amo e hodoa mase. Iehova ese Mose e haduaia heḡereḡerena, Israel taudia na unu e kara toma. ");
INSERT INTO meu_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Iehova ese Mose e hereva henia, Sinai ororona ai, eto, ");
INSERT INTO meu_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Israel taudia ba hamaorodia, baoto: Baina henimui tanona ai ba kau negana ai, tano ena nega helaḡadia ba badinadia, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Laḡani tauratoi emu uhe ba hado, bona laḡani tauratoi emu vine audia rigidia ba kwamadia heini, huahua ihahohodia totona. ");
INSERT INTO meu_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","A laḡani ihahituna na tano ena laḡa-ani negana, laḡani helaḡana Iehova ena: uhe basio hado emutano ai, bona emu vine audia rigidia basio kwamadia heini. ");
INSERT INTO meu_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Sibona baine tubu ḡauna na basio utua, bona vine huahuadia bae dobi na basio habou; tano ena laḡa-ani helaḡana bunai. ");
INSERT INTO meu_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Tano ena laḡa-ani amo amui ba davaria:oi bona emu hesiai tauna bona emu hesiai hahinena bona dekemu ai e ḡaukaramu tauna bona dekemu ai e noho hedoamu tauna, ");
INSERT INTO meu_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","bona emu boromakau bona emu seri iboudiai emu tano lalonai. Tano anina idoinai na amui. ");
INSERT INTO meu_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Laḡani helaḡadia hitu ba duahidia, laḡani kavakavadia hitu hitu amo: unu laḡani iboudiai bae hari-ahui taurahani-ta. ");
INSERT INTO meu_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Bena hua ihahituna dinanaihagwautana ai kibi ba hiriria badabada; herohemaino dinana ai kibi bae hiriri emui tano idoinai. ");
INSERT INTO meu_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Laḡani iha-imahuina ba hahelaḡaia, bainehelaḡa herea. Una laḡani lalonai iḡui taudia iboudiai bae ruhadia nege. Ia ladana be Iubile: ia lalonai taunimanima iboudiai edia tano korikori bona edia iduhu korikori bae lou henidia. ");
INSERT INTO meu_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Laḡani iha-imahuina na emui Iubile: ia Ialonai uhe basio hado, bona sibona baine tubu ḡauna basio utua; emui vine danu rigidia basio kwamadia heini, bona huahuadia basio habou. ");
INSERT INTO meu_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Badina be Iubile laḡanina na helaḡa emui ai: tano anina na bavania, vadaeni. ");
INSERT INTO meu_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Iubile laḡanina ai umui ta ta ena tano ena tano bavabi lou. ");
INSERT INTO meu_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Dekemu tauna enai ba hoihoi, basio koia, ia danu basine koimu. ");
INSERT INTO meu_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Dekemu tauna ena tano ba hoia negana ai, ba laloa, Iubile murinai laḡani hida vada e lao bubuni; ia danu baine laloa, taboro hida do mimia. ");
INSERT INTO meu_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Bema laḡani momo mimia, davana na baine bada, a bema laḡani gadoi mo mimia, davana na baine maraḡi, badina e hoimu ḡauna be taboro e hoimu. ");
INSERT INTO meu_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Raruosi basio hekoi heheni, a emui Dirava garina be gari, badina be lau be Iehova, emui Dirava. ");
INSERT INTO meu_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Taunabunai, egu taravatu bona egu haheḡani ba badinadia bona karadia ba kara; unu amo ba noho namonamo emui tano ai. ");
INSERT INTO meu_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Tano ese anina baine henimui: bavaniani, ba boga kunu, ba noho namonamo. ");
INSERT INTO meu_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ba henanadai reana, baoto “Laḡani ihahituna ai dahaka baia ania, basia hadohado bona basia taboro negana ai?” ");
INSERT INTO meu_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Benaini, laḡani ihatauratoina ai baina hanamomui, tano anina bavabia, laḡani toi davadia. ");
INSERT INTO meu_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Bena laḡani ihataurahanina ai emui uhe ma ba hado, a emui uma anidia gunadia do bavani, ela bona laḡani ihataurahani-tana ena taboro negana baine kau. ");
INSERT INTO meu_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Tano tabasio hoia vaitani, badina be tano na lauegu, umui ese o noholaiamu, e kara lauegu vadivadi na heto. ");
INSERT INTO meu_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Ba hoi tanodia iboudiai na biagudia gunadia bae abi lou diba. ");
INSERT INTO meu_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Tadikakamu ta baine ogoḡami, bena ena tano kahana baine hoia, ia varavara-dosina ese una tano davana baine karaia, baine abia lou. ");
INSERT INTO meu_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Bema asi iabi-louna tauna ta, a gabeamo ogoḡami tauna ma baine taḡa, iabi-lounabaine heḡereḡere, ");
INSERT INTO meu_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ia na baine haeroa, laḡani hida vada ela ia ese e hoia, bena davana orena baine heni lou, ena tano ma baine abia lou. ");
INSERT INTO meu_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","A bema imana baine tuna, iabi-louna basine heḡereḡere, e hoia tauna ese bainebirulaia ela bona Iubile laḡanina; una negana ai tano tauna korikorina ese ena tano baine abia lou. ");
INSERT INTO meu_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Hanua mai maḡuna lalonai tau ta ese ena ruma baine hoia, moni davana, ia na davana baine heni lou bona ena ruma baine abia lou diba, ela bona laḡani ta baine ore. Laḡani ta lalonai ia ese baine hoia lou diba. ");
INSERT INTO meu_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","A laḡani ta lalonai basine abia lou, una ruma na iena amo e hoia tauna ena ruma korikori ai bainela, iena bona ia garana edia; Iubile laḡanina ai biaguna gunana basine abia Iou. ");
INSERT INTO meu_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","A hanua maraḡidia, asi maḡudia hanuadia, lalodiai na ruma bae hoi be tano bae hoi heḡereḡerena, davadia bae heni lou bona ruma bae abi lou diba, bona Iubile laḡanidia ai biagudia gunadia ese bae abi lou. ");
INSERT INTO meu_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Ḡau tamona, Levi taudia edia hanua ai, Levi taudia ese edia ruma bae hoi lou diba, laḡani iboudiai. ");
INSERT INTO meu_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","A Levi tauna ta ena ruma basine hoia Iou, ia na Iubile laḡanina ai do baine abia lou. Badina be Levi taudia edia hanua rumadia na edia korikori, Israel taudia bogaragidiai. ");
INSERT INTO meu_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Bona edia gabi-ruma tanodia na haida ese basie hoi; unu tano na ediatano korikori ela bona hanaihanai. ");
INSERT INTO meu_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Tadikakamu ta baine ogoḡami, asi ena heubu dalana, oi ese ba ubua, laolao tauna eiava vadivadi tauna na heto. ");
INSERT INTO meu_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Moni eiava kohu iena amo basio abia; emu Dirava garina ba gari, bona tadikakamu ba hamauria. ");
INSERT INTO meu_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Moni ba henia eiava aniani ba ubulaia na davadia basio abi. ");
INSERT INTO meu_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Lau binai Iehova emui Dirava; Aigupto tanona amo na hakaumui lasi, Kanaan tanona baina henimui bona emui Dirava ai bainala totona. ");
INSERT INTO meu_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Tadikakamu ta baine ogoḡami, bena emu ai sibona baine hehoi, basio kara henia o hoia tauna o kara heniamu heḡereḡerena; ");
INSERT INTO meu_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","a mai davana emu ai e ḡaukaramu tauna eiava noho-hedoa tauna heḡereḡerena oi dekemuai baine noho. Ia na oi isiaimu baine lao heni ela bona Iubile laḡanina; ");
INSERT INTO meu_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","bena emu ruma amo baine raka lasi, ia mai natuna ida, ena ruma taudia bona ena tano korikori baine lou henidia. ");
INSERT INTO meu_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Badina be idia na lauegu hesiai taudia, Aigupto tanona amo na hakaudia lasi; basio hoidia. ");
INSERT INTO meu_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Basio hahisihisia; emu Dirava garina ba gari. ");
INSERT INTO meu_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","E noho hetabiramu besedia edia amo emui hesiai taudia bona hahinedia ba hoidia; ");
INSERT INTO meu_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","bogaragimui ai e noho hedoamu taudia edia amo danu natudia emui tano ai e vara na ba hoidia diba, emui iḡui taudia ai baela. ");
INSERT INTO meu_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Umui murimui ai dihimui ese danu bae abidia, edia korikori; isiaimui bae lao heni hanaihanai. A Israel taudia, varavaramui korikori, na basio hahisihisidia. ");
INSERT INTO meu_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Bogaragimui ai e noho hedoamu tauna na baine taḡa, bona tadikakamu ta baine ogoḡami, bena hari tadikakamu na sibona baine hehoi, una nohohedoa tauna enai eiava iena ruma tauna ta enai, ");
INSERT INTO meu_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","unu e hehoi toma tauna na bae hamauria diba, tadikakana ese, ");
INSERT INTO meu_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","eiava tamana lahaina ese, eiava varavarana ta ese; eiava ia sibona moni baine davaria negana ai na sibona baine hahemauri. ");
INSERT INTO meu_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Laḡani bae duahidia, biaguna enai e hehoi negana ela bona Iubile laḡanina; bena iruhana monina na unu laḡani hidaosi ahudia, hesiai tauna mai davana ahuna heḡereḡerena, baine heni. ");
INSERT INTO meu_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Negana bema daudau, laḡani unuhohodia davadia baine heni, sibona e hehoilai monina amo; ");
INSERT INTO meu_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","eiava negana bema kwadogi, laḡani unuhohodia davadia na biaguna baine henia, laḡani hidaosi mimia heḡereḡeredia ia ese iruhana monina na baine heni. ");
INSERT INTO meu_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Ia na hesiai tauna mai davana, laḡani ta ta amo e ḡaukaramu, heḡereḡerena ai baine ḡaukara; biaguna ese basine hahisihisia oi vairamu ai. ");
INSERT INTO meu_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Bema basine heruha guna, ia na Iubile laḡanina ai baine heruha, ia mai natuna ida. ");
INSERT INTO meu_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Badina be Israel taudia na lauegu hesiai taudia; Aigupto tanona amo na hakaudia Iasi, isiaigu ilao-henina totona. Lau binai Iehova, emui Dirava. ");
INSERT INTO meu_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Kaivakuku basio kara. Dirava laulauna nadi amo basio koroa bona basio haginia; au-tubua helaḡana ta eiava nadi helaḡana ta danu basio haginia bona basio toma henia diho, emui tano idoinai; badina be lau na Iehova, emui Dirava. ");
INSERT INTO meu_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Egu dina helaḡadia ba badinadia, bona egu dubu helaḡana ba matauraia: lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Egu taravatu boma badinadia bona egu haheḡani karadia boma kara, ");
INSERT INTO meu_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","lau ese medu namodia baina henimui, edia nega korikori ai, bena tano ese anina baine havaraia, bona imea audia bae huahua. ");
INSERT INTO meu_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Uit ikwadina do basine ore ai vine huahuadia iutudia baine hematama, bona vine huahuadia iutudia do basine ore ai hadohado baine hematama. Bavaniani boga kunu, emui tano ai ba noho, asi emui kudou hetaha. ");
INSERT INTO meu_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Lau ese maino baina henimui emui tano ai; vada ba laḡa ani, asi tauna ta ese baine hagarimui. Uda boromadia baina ha-oredia emui tano ai, bona tuari darena na basine hedinarai, emui tano idoinai. ");
INSERT INTO meu_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Inaimui do ba hadareredia, emui dare amo bavaladia mase. ");
INSERT INTO meu_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Laima umui emui amo ese sinahu-ta bae hadareredia, bona sinahu-ta umui emui amo ese gerebu-ta bae hadareredia; inaimui iboudiai na emui dare ai bae mase. ");
INSERT INTO meu_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Lau ese baina haḡeremui, natumui momo baina henimui, baina hahutumamui. Egu gwau-hamata emui aido baina hamomokania. ");
INSERT INTO meu_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Emui roge anidia basie ore; gunadia oredia do ba nege, matamatadia gabudia ilailaidia. ");
INSERT INTO meu_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Bogaragimui ai baina noho; lau laumagu ese basine dadaraimui. ");
INSERT INTO meu_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Bogaragimui ai baina raka; emui Dirava ai bainala, umui danu egu bese taumui ai baola. ");
INSERT INTO meu_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Lau binai Iehova, emui Dirava: Aigupto tanona amo na hakaumui lasi, Aigupto taudia isiaidia basio lao heni nato; aiomui gadeadia na hamotudia, na haginimui maoromaoro. ");
INSERT INTO meu_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","A basioma kamonai henigu; ini haheḡani iboudiai basioma badinadia; ");
INSERT INTO meu_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","egu taravatu boma tata utu, bona laumamui ese egu hahemaoro herevadia bema dadaraidia; egu haheḡani iboudiai karadia basioma kara, bona emui gwau-hamata egu ai basioma hamomokania; ");
INSERT INTO meu_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","lau be ini baina kara henimuitoma: gari lalomui ai baina havaraia; baina havaroda-varodamui. Taumui bae siahu, bona matamui bae valahu-valahu, bona laumamui bae daure. Emui uhe ba hado, to anidia basio ani; inaimui ese bae ani. ");
INSERT INTO meu_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Vairagu baina ha-aukaia emui ai. Inaimui ese bae hadareremui bona bae halohiamui. Ta ese basine havamui negana ai ba heau. ");
INSERT INTO meu_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Ini ḡau muridiai ma basioma kamonai henigu, lau ese emui kara dika davadia nega hahitu baine henimui. ");
INSERT INTO meu_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Emui goada heaḡina baina hahemaraia. Guba na auri ai baina halaoa emui ai; bona emui tanobada na auri laboralaborana ai baina halaoa. ");
INSERT INTO meu_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Emui goada baine ore kava; emui uma anidia basie vara; emui imea audia basie huahua. ");
INSERT INTO meu_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Doene boma inai henigu bona boma gwau edeede henigu, lau ese baina hahisihisimui nega hahitu, emui kara dika daidiai. ");
INSERT INTO meu_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Uda boromadia baina kahudia nege bogaragimui ai; idia ese natumui bae dadihaidia, bona emui seri bae habuadia tari, bona umui bae hagadoimui. Emui dala ai ava bae tubu. ");
INSERT INTO meu_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","A dounu basioma lou henigu, dounu egu amo boma raka oho, ");
INSERT INTO meu_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","lau ese umui emui amo baina raka oho, bona emui kara dika davadia nega hahitu ma baina henimui. ");
INSERT INTO meu_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Dare na latamui ai baina siaia, taravatu itatautuna davana ihaḡuḡuruna totona. Emui hanua badadia ai ba hahebou negadia ai, lau ese dai-hanai goreredia baina siaidia bogaragimui ai, benainaimui imadia ai baina negemui. ");
INSERT INTO meu_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Amui mauri anianina baina abia oho negana ai, hahine gwauta amu tamona ai flaoa bae gabua, amui bae hahetoho henimui; bavaniani, to bogamui basie kunu. ");
INSERT INTO meu_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Unu ḡau muridiai do basioma kamonai henigu, a egu amo boma raka oho, ");
INSERT INTO meu_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","lau be umui emui amo baina raka oho mai badugu ida, bona emui kara dika davadia nega hahitu baina henimui, lau sibogu ese. ");
INSERT INTO meu_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Bena natumui mamaruanedia bona natumui hahinedia hidiodia do bavani. ");
INSERT INTO meu_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Lau ese emui helaḡa gabudia ororo doridia ai na baina habuadia tari, bona emui muramura patadia baina uhedia hebubu, bona emui kaivakuku tau-anidiamasedia latadiai umui tau-animui masedia baina tahodia kau; bena laumaguese baine dadaraimui. ");
INSERT INTO meu_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Emui hanua baina habuadia tari; emui dubu baina giḡidia rohoroho; emui muramura bonadia basina moalelai. ");
INSERT INTO meu_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Emui tano baina havahua; inaimui bae noho henia, bena bae hoalaia. ");
INSERT INTO meu_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Bena baina lulumui lasi, bese idau-idau bogaragidiai baina hakarohomui rohoroho. Egu dare baina veria lasi, ia ese baine havamui; emui tano bona emui hanua bae vahu. ");
INSERT INTO meu_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Una negana ai tano ese ena laḡa-ani baine moalelaia, baine vahudinadia iboudiai, umui inaimui edia tano ai ba noho hedoa dinadia ai. Tano na baine laḡa ani, bona ena laḡa-ani baine moalelaia. ");
INSERT INTO meu_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ena vahudinadia iboudiai baine laḡa ani, laḡa-ani korikori, dia umui o noholaiavanegadia ai emui dina helaḡadia ai e laḡa aniva na heto. ");
INSERT INTO meu_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","A emui bese oredia na lalodia baina hadaradaradia, inaidia edia tano ai; au rauna lai ese e hohoamu reḡena ese baine hagaridia, bena bae heautania, dare bema heautania na heto; bena ta ese se hahavadia negana ai bae keto. ");
INSERT INTO meu_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Tau ta ese se havadiamu negana ai bae hetutuhi heheni, dare bema heautania na heto. Inaimui vairadiai basio gini diba. ");
INSERT INTO meu_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Mase ese baine ḡavamui tao, bese idau-idau bogaragidiai, inaimui edia tano ese baine hadonomui. ");
INSERT INTO meu_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Bae roho mauri taudia kwabukwabudia na inaimui edia tano ai bae manori, edia kara dika daidiai bona tamadia edia kara dika daidiai. ");
INSERT INTO meu_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","To bema helalo kerehai, edia kara dika bona tamadia edia kara dika, edia kara hedibaḡani egu ai bona edia raka muri karadia, ");
INSERT INTO meu_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","daidiai na rakatanidia bona inaidia edia tano ai na luludia lao karadia, bema gwaurai hedinarai; bona edia hekokoroku bema negea, lalodia bema hamanau, bona edia kara dika davadia do bema hua, ");
INSERT INTO meu_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","lau ese egu gwau-hamata, Iakob bona Isaak bona Abraham na gwaurai henidia hamata ḡauna, baina helalolaia une, bona tano danu baina laloa. ");
INSERT INTO meu_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","A tano na do baine mia, ena laḡa-anibaine moalelaia, idia muridiai baine vahu dinadia iboudiai; bona idia ese edia kara dika davadia do bae hua; badina be egu haheḡani e dadaraidiava, bona laumadia ese egu taravatu e inai henidiava. ");
INSERT INTO meu_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ḡau tamona, inaidia edia tano ai bae noho negana ai, lau ese basina dadaraidia, basina inai henidia, basina habuadia tari, bona egu gwau-hamata idia ediai basina reaia; badina be lau na Iehova, edia Dirava. ");
INSERT INTO meu_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Idia daidiai egu gwau-hamata, idia senedia, bese idau-idau vairadiai Aigupto amo na hakaudia lasi bonaedia Dirava ai nala taudia, na gwaurai henidia hamata ḡauna, do baina laloa tao. Lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Haheḡani bona hahemaoro bona taravatu bini, Iehova ese Mose imana amo e kara, Sinai ororona ai, ia bona Israel taudia padadiai bae mia. ");
INSERT INTO meu_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Iehova ese Mose ma e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Israel taudia ba hamaorodia, baoto: Taunimanima ta baine helaḡa, gwau-hamata ta dainai, oiese ibodohilaina ḡauna ba gwauraia, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Bema tau, laḡani ruahui ela bona laḡani tauratoi-ahui, ibodohilaina na silver sekeledia imahui, gabuhelaḡana ena sekele heḡereḡeredia. ");
INSERT INTO meu_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Bema hahine, ibodohilaina na sekele toi-ahui. ");
INSERT INTO meu_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Taunimanima laḡanidia ima ela bona ruahui ibodohilaidia bini: bema maruane, sekele ruahui; bema hahine, sekele gwauta. ");
INSERT INTO meu_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Hua ta amo ela bona laḡani ima ibodohilaidia bini: bema maruane, silver sekeledia ima; bema hahine, sekele toi. ");
INSERT INTO meu_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Laḡani tauratoi-ahui vada e hanai taudia ibodohilaidia bini: bema tau, sekele gwauta-ima; bema hahine, sekele gwauta. ");
INSERT INTO meu_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Aogoḡami dainai gwau-hamata tauna na ibodohilaidia bini basine heni diba, ia na hahelaḡa tauna vairanai baine hedinarai, bena hahelaḡa tauna ese ibodohilaina davana baine gwauraia, gwau-hamata tauna baine heni diba heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Ḡau helaḡana bema mauri ḡauna ta, taunimanima vaia Iehova ena ihaboulaina ai e halaomu ḡaudia ta, una ḡau danu baine helaḡa, tau ta ese Iehova vada e henia dainai. ");
INSERT INTO meu_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Basine boloa: namona na dikana basine bololaia, bona dikana na namona basine bololaia. Bema boloa, mauri ḡaudia ruaosi na bae helaḡa. ");
INSERT INTO meu_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","A bema mauri ḡauna mirona ta, Iehova ena ihaboulaina ai asie halaoamu ḡauna, gwau-hamata tauna ese una ḡau baine laohaiaha helaḡa tauna vairanai. ");
INSERT INTO meu_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Bena hahelaḡa tauna ese ibodohilaina davana baine gwauraia, ena namo eiava ena dika heḡereḡerena; oi hahelaḡa taumu ba gwauraia heḡereḡerena, dava korikorina bunai. ");
INSERT INTO meu_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Hari tau baine ura baine bodohilaia, ia ese dava bunai baine heni, mai atokauna ida. Atokauna na dava idoinai baine karoaia, karoa ima, bena karoa ta heḡereḡerena ma baine atoa kau. ");
INSERT INTO meu_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Tau ta ese ena ruma bema gwauraia hamata, baine helaḡa Iehova ena, hahelaḡa tauna ese ibodohilaina davana baine gwauraia, ena namo eiava ena dika heḡereḡerena; hahelaḡa tauna ese davana baine gwauraia heḡereḡerena, dava korikorina bunai. ");
INSERT INTO meu_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ruma biaguna baine ura ena ruma baine bodohilaia, ia ese dava bunai baine heni mai atokauna ida. Atokauna na dava idoinai baine karoaia, karoa ima, bena karoa ta heḡereḡerena ma baine atoa kau. Bena ruma na iena. ");
INSERT INTO meu_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Tau ta ese ena tano kahana, senena edia amo e abia tanona, bema hahelaḡaia Iehova ena, oi ese ibodohilaina davana ba haeroa, uhe una tano lalonai vada e hadomu heḡereḡerena. Bali homerena ta na silver sekeledia imahui ida ba haheḡereḡerea. ");
INSERT INTO meu_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Iubile laḡanina ai ena tano bema hahelaḡaia, ibodohilaina na dava idoinai, oi ese ba gwauraia heḡereḡerena, baine heni. ");
INSERT INTO meu_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","A Iubile laḡanina murinai bema hahelaḡaia, hahelaḡa tauna ese baine haeroa, laḡani hida do mimia ela bona Iubile ta baine kau, bena unu laḡani hidaosi ihaheḡereḡeredia ai davana baine hamaraḡia. ");
INSERT INTO meu_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Tano biaguna baine ura ena tano baine bodohilaia, ia ese dava baine heni mai atokauna ida. Atokauna na dava idoinai baine karoaia, karoa ima, bena karoa ta heḡereḡerena ma baine atoa kau. Bena tano na iena. ");
INSERT INTO meu_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","A ibodohilaina basine ura, eiava tau ta ese baine hoia, ia na basine abia lou diba. ");
INSERT INTO meu_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","A Iubile baine kau ai, una tano na baine helaḡa Iehova ena, badina be ia na gwau-hamata ḡauna: hahelaḡa tauna ese baine abia, iena. ");
INSERT INTO meu_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Tau ta ese ena tano ta, dia senena edia amo e abia to moni amo e hoia ḡauna, bema hahelaḡaia Iehova ena, ");
INSERT INTO meu_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","hahelaḡa tauna ese ibodohilaina davana laḡani hidaosi lalodiai ela bona Iubile laḡanina baine gwauraia; bena una dina ai hari tau ese dava baine heni, Iehova ena helaḡa ḡauna. ");
INSERT INTO meu_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","A Iubile laḡanina ai una tano biaguna korikori, senena amo e abia tauna, ese baine abia lou. ");
INSERT INTO meu_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Dava iboudiai be gabu helaḡana ena sekele ai ba gwauraia: una sekele lalonai gera be ruahui. ");
INSERT INTO meu_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Mauri ḡaudia natudia roboadia be Iehova ena; taunabunai tau ta ese roboa maruanena ta basine hahelaḡaia diba: boromakau natuna roboana eiava mamoe natuna roboana na Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","A mauri ḡauna mirona natuna roboana na biaguna ese moni amo baine bodohilaia, dava baine heni, oi ese ba gwauraia heḡereḡerena, bona atokauna danu baine heni. Atokauna na dava idoinai baine karoaia, karoa ima, bena karoa ta heḡereḡerena ma baine atoa kau. A basinema bodohilaia, vada ba hoia, moni davana, dava na o gwauraia heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Tau ta ese taunimanima ta eiava mauri ḡauna ta eiava tano ta Iehova baine henia vaitani, una na basine hoia diba bona basine bodohilaia diba: unuhetomadia na vada e helaḡa vaitani, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Bema taunimanima ta unu bae henia vaitani toma, idia na basie bodohilaia diba: vada bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Tano anidia, nadinadi eiava huahua, bae karoadia, karoa gwauta, bena karoa ta bae hahelaḡaia, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Tau ta baine ura karoa helaḡana baine bodohilaia, ia na davana baine heni mai atokauna ida. Atokauna na dava baine karoa, karoa ima, bena karoa ta heḡereḡerena ma baine atoa kau. ");
INSERT INTO meu_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Boromakau seridia bona mamoe seridia danu bae karoadia. Ireḡudia tauna ena itotohi henuna amo bae raka hanai; baine duahidia gwauta gwauta amo, bena ihagwautadia na bae helaḡa, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Basine itaia, namona eiava dikana; bona basine boloa: bema boloa, ḡau ruaosi bema helaḡa. Bona basine bodohilaia diba. ");
INSERT INTO meu_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Haheḡani bini, Iehova ese Mose e henia, Sinai ororona ai, Israel taudia edia. ");
INSERT INTO meu_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Aigupto amo e raka lasi murinai laḡanina iharuana ena hua iharuana ai, hua dinana gini-gunana ai Iehova ese Mose e hereva henia, Sinai tano ḡaḡaena ai, hebou kalagana Ialonai. ");
INSERT INTO meu_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","E hamaoroa, eto, Israel oreana idoinai ba duahidia, edia iduhu ta ta ai, ta ta tamadia edia ruma ai. Mamaruane iboudiai ladadia ba tore, ");
INSERT INTO meu_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","laḡani ruahui vada e hanai tataudia iboudiai; Israel tataudia tuari baela diba iboudiai na oi bona Aaron ese ba duahidia, edia orea ta ta ai. ");
INSERT INTO meu_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Iduhu ikwaradia taudia bavabidia, iduhu ta ta ai tatau ta ta bavabidia, idia ese bae durumui. ");
INSERT INTO meu_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Idurumui taudia bini. Ruben ena idudu ai: Elisuru Sedeuru. ");
INSERT INTO meu_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simeon ena iduhu ai: Selumiele Surisadai, ");
INSERT INTO meu_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Iuda ena iduhu ai: Nason Aminadab. ");
INSERT INTO meu_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Isakara ena iduhu ai: Netanele Suara. ");
INSERT INTO meu_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Sebulun ena iduhu ai: Eliab Helon. ");
INSERT INTO meu_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Efraim Iosef ena iduhu ai: Elisama Amihud. Manase Iosef ena iduhu ai: Gamaliel Pedasuru. ");
INSERT INTO meu_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Beniamina ena iduhu ai: Abidan Gideoni. ");
INSERT INTO meu_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dan ena iduhu ai: Ahiesere Amisadai. ");
INSERT INTO meu_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Asere ena iduhu ai: Pagiele Okran. ");
INSERT INTO meu_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gad ena iduhu ai: Eliasaf Reuele. ");
INSERT INTO meu_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Napatali ena iduhu ai: Ahira Enan. ");
INSERT INTO meu_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Tatau bini Israel oreana ai e abidia hidi, edia ruma biagudia bona edia iduhu ikwaradia taudia. ");
INSERT INTO meu_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Ladadia unu e hatodia toma taudia na Mose bona Aaron ese e abidia. ");
INSERT INTO meu_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Bena hua iharuana ena dina gini-gunana ai idia ese orea idoinai e haboudia, laḡani ruahui vada e hanai tataudia iboudiai na ladadia e tore, edia iduhu ta ta ai, ta ta tamadia edia ruma ai. ");
INSERT INTO meu_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Iehova ese Mose e haḡania heḡereḡerena, Mose ese taunimanima unu e duahidia toma, Sinai tano ḡaḡaena ai ");
INSERT INTO meu_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Ruben, Israel natuna roboana, garana e duahidia, edia iduhu ai bona tamadia edia ruma ai. Laḡani ruahui vada e hanai tataudia, tuari baela diba, ");
INSERT INTO meu_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","iboudiai na 46,500. Ruben iduhuna ena numera bunai. ");
INSERT INTO meu_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Simeon garana e duahidia, edia iduhu ai bona tamadia edia ruma ai. Laḡani ruahui vada e hanai tataudia, tuari baela diba, ");
INSERT INTO meu_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","iboudiai na 59,300. Simeon iduhuna ena numera bunai. ");
INSERT INTO meu_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gad garana e duahidia, edia iduhu ai bona tamadia edia ruma ai. Laḡani ruahui vada e hanai tataudia, tuari baela diba, ");
INSERT INTO meu_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","iboudiai na 45,650. Gad iduhuna ena numera bunai. ");
INSERT INTO meu_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Iuda garana e duahidia, edia iduhu ai bona tamadia edia ruma ai. Laḡani ruahui vada e hanai tataudia, tuari baela diba, ");
INSERT INTO meu_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","iboudiai na 74,600. Iuda iduhuna ena numera bunai. ");
INSERT INTO meu_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Isakara garana e duahidia, edia iduhu ai bona tamadia edia ruma ai. Laḡani ruahui vada (Ia e hanai tatudia, tuari baela diba, ");
INSERT INTO meu_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","iboudiai na 54,500, Isakara iduhuna ena numera bunai. ");
INSERT INTO meu_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Sebulun garana e duahidia, edia iduhu ai bona tamadia edia ruma ai. Laḡani ruahui vada e hanai tataudia, tuari baela diba, ");
INSERT INTO meu_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","iboudiai na 57,400. Sebulun iduhuna ena numera bunai. ");
INSERT INTO meu_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Efraim Iosef garana e duahidia, edia iduhu ai bona tamadia edia ruma ai. Laḡani ruahui vada e hanai tataudia, tuari baela diba, ");
INSERT INTO meu_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","iboudiai na 40,500. Efraim iduhuna ena numera bunai. ");
INSERT INTO meu_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Manase Iosef garana e duahidia, edia iduhu ai bona tamadia edia ruma ai. Laḡani ruahui vada e hanai tataudia, tuari baela diba, ");
INSERT INTO meu_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","iboudiai na 32,200. Manase iduhuna ena numera bunai. ");
INSERT INTO meu_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Beniamina garana e duahidia, edia iduhu ai bona tamadia edia ruma ai. Laḡani ruahui vada e hanai tataudia, tuari baela diba, ");
INSERT INTO meu_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","iboudiai na 35,400. Beniamina iduhuna ena numera bunai. ");
INSERT INTO meu_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dan garana e duahidia, edia iduhu ai bona tamadia edia ruma ai. Laḡani ruahui vada e hanai tataudia, tuari baela diba, ");
INSERT INTO meu_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","iboudiai na 62,700. Dan iduhuna ena numera bunai. ");
INSERT INTO meu_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Asere garana e duahidia, edia iduhu ai bona tamadia edia ruma ai. Laḡani ruahui vada e hanai tataudia, tuari baela diba, ");
INSERT INTO meu_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","iboudiai na 41,500. Asere iduhuna ena numera bunai. ");
INSERT INTO meu_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Napatali garana e duahidia, edia iduhu ai bona tamadia edia ruma ai. Laḡani ruahui vada e hanai tataudia, tuari baela diba, ");
INSERT INTO meu_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","iboudiai na 53,400. Napatali iduhuna ena numera bunai. ");
INSERT INTO meu_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Mose bona Aaron bona Israel iduhudia ikwaradia taudia gwauta-raruosi ese e duahidia taudia bini. ");
INSERT INTO meu_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Israel besena e duahidia, edia iduhu ai bona tamadia edia ruma ai. Laḡani ruahui vada e hanai tataudia, tuari baela diba, ");
INSERT INTO meu_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","iboudiai na 603,550. ");
INSERT INTO meu_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","A Levi garana na idia ida asie duahidia hebou. ");
INSERT INTO meu_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Badina be Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Levi iduhuna taudia na Israel taudia ida basio duahidia hebou bona ladadia basio tore hebou. ");
INSERT INTO meu_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Levi taudia na ba duanaidia, taravatu mauana dubuna mai kohuna mai ḡauna iboudiai ida bae naridia. Idia ese dubu mai kohuna ida bae huaia lao; bae gimaia bona bae hataruhaia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Taravatu mauana dubuna ba laolaolaia negana ai, Levi taudia ese bae rohoa, ma bae haginia lou; idau iduhu tauna ta baine raka henia kahi, vada bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Israel taudia na edia iduhu ta ta ai bae taruha, iduhu ta ta ena taruha ena taruha ai, edia pepe bae ha-oda heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","A Levi taudia na taravatu mauana dubuna bae taruhaiaheḡeḡe, badu Israel oreana enai ilao-ahuna totona. Taravatu mauana dubunana Levi taudia ese bae naria. ");
INSERT INTO meu_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Israel taudia na unu e kara toma, Iehova ese Mose e haḡana heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Iehova ese Mose bona Aaron e haḡanidia, eto, ");
INSERT INTO meu_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Israel taudia na iduhu ta ta ai edia taruha bae hagini, edia iduhu pepedia badibadidiai; taruha iboudiai na hebou kalagana bae vaira henia bona bae ḡeḡea ahu. ");
INSERT INTO meu_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Mairiveina ai, dina e daemu kahana ai, Iuda taudia bae taruha, edia iduhu pepena badibadinai. Ikwaradia tauna na Nason Aminadab; ");
INSERT INTO meu_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","bona ena tuari taudia iboudiai na 74,600. ");
INSERT INTO meu_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Ia badibadinai Isakara taudia bae taruha. Ikwaradia tauna na Netanele Suara; ");
INSERT INTO meu_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","bona ena tuari taudia iboudiai na 54,400. ");
INSERT INTO meu_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Ma ia badibadinai na Sebulun taudia bae taruha. Ikwaradia tauna na Eliab Helon; ");
INSERT INTO meu_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","bona ena tuari taudia iboudiai na 57,400. ");
INSERT INTO meu_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Taunabunai Iuda oreana ena tuari taudia ibouboudiai na 186,400. Laolao negadia ai, idia na bae raka lasi guna. ");
INSERT INTO meu_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Diho kahana Ruben taudia edia pepe bae hadaia bona bae taruha. Ikwaradia tauna na Elisuru Sedeuru; ");
INSERT INTO meu_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","bona ena tuari taudia iboudiai na 46,500. ");
INSERT INTO meu_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Ia badibadinai Simeon taudia bae taruha. Ikwaradia tauna na Selumiele Surisadai; ");
INSERT INTO meu_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","bona ena tuari taudia iboudiai na 59,300. ");
INSERT INTO meu_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Ma ia badibadinai Gad taudia bae taruha. Ikwaradia tauna na Eliasaf Reuele; ");
INSERT INTO meu_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","bona ena tuari taudia iboudiai na 45,650. ");
INSERT INTO meu_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Taunabunai, Ruben oreana ena tuari taudia ibouboudiai na 151,450. Idia na raka lasi oreana iharuana ");
INSERT INTO meu_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Idia muridiai Levi taudia ese hebou kalagana bae huaia lasi, edia taruha kalagadia ida; tuari oreadia bogaragidiai bae huaia lao. Iboudiai edia taruha ta ta ai bae raka lasi, orea ta ta ena pepe ena pepe muridiai. ");
INSERT INTO meu_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Lahara kahana Efraim taudia edia pepe bae hadaia. Ikwaradia tauna na Elisama Amihud; ");
INSERT INTO meu_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","bona ena tuari taudia iboudiai na 40,500. ");
INSERT INTO meu_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Ia badibadinai Manase taudia bae taruha. Ikwaradia tauna na Gamaliel Pedasuru; ");
INSERT INTO meu_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","bona ena tuari taudia iboudiai na 32,200. ");
INSERT INTO meu_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Ma ia badibadinai Beniamina taudia bae taruha. Ikwaradia tauna na Abidan Gideoni; ");
INSERT INTO meu_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","bona ena tuari taudia iboudiai na 35,400. ");
INSERT INTO meu_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Taunabunai, Efraim oreana ena tuari taudia ibouboudiai na 108,100. Idia na raka lasi oreana ihatoina. ");
INSERT INTO meu_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Mirigini kahana Dan taudia edia pepe bae hadaia. Ikwaradia tauna na Ahiesere Amisadai; ");
INSERT INTO meu_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","bona ena tuari taudia iboudiai na 62,700. ");
INSERT INTO meu_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Ia badibadinai Asere taudia bae taruha. Ikwaradia tauna na Pagiele Okran; ");
INSERT INTO meu_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","bona ena tuari taudia iboudiai na 41,500. ");
INSERT INTO meu_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Ma ia badibadinai Napatali taudia bae taruha. Ikwaradia tauna na Ahira Enan; ");
INSERT INTO meu_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","bona ena tuari taudia iboudiai na 53,400. ");
INSERT INTO meu_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Taunabunai, Dan oreana ena tuari taudia ibouboudiai na 157,600. Idia na raka lasi oreana gini gabena; edia iduhu ta ta ai bae raka lasi. ");
INSERT INTO meu_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Israel taudia edia iduhu ta ta ai e duahidia bini. Tuari taudia, edia iduhu ta ta amo e duahidia, ibouboudiai na 603,550. ");
INSERT INTO meu_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","A Iehova ese Mose e haḡania heḡereḡerena, Levi taudia na Israel taudia ida asie duahidia hebou. ");
INSERT INTO meu_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Israel taudia na unu e kara toma. Iehova ese Mose e haḡania heḡereḡerena, idia ese edia pepe ta ta badibadidiai e taruha, bona edia orea ta ta ai bona edia iduhu ta ta ai edia taruha amo e raka lasi. ");
INSERT INTO meu_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Aaron bona Mose garadia bini, Iehova ese Mose Sinai ororona ai e hereva henia negana amo. ");
INSERT INTO meu_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aaron natuna ladadia bini: Nadab, tau roboana, bona Abihu, bona Eleasara, bona Itamara. ");
INSERT INTO meu_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Aaron natuna bunu, e horodia bona e hahelaḡadia, hahelaḡa taudia ai e halaodia. ");
INSERT INTO meu_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","A Nadab bona Abihu na Iehova vairanai e mase, Sinai tano ḡaḡaena ai, lahi idauna Iehova vairanai e vareailaia negana ai. Idia na asi natudia. Taunabunai, Eleasara bona Itamara ese hahelaḡa ḡaukaradia e karava, tamadia Aaron vairanai. ");
INSERT INTO meu_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Iehova ese Mose e haḡania, eto, ");
INSERT INTO meu_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Levi taudia ba hakaudia mai, hahelaḡa tauna Aaron vairanai bae gini, ia isiaina bae lao heni. ");
INSERT INTO meu_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ia vairanai bona hebou taudia iboudiai vairadiai hebou kalagana bae reḡua, bona dubu ḡaukaradia bae kara. ");
INSERT INTO meu_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Hebou kalagana kohudia iboudiai bae naridia, bona hahelaḡa karadia bae kara dubu ai, Israel taudia daidiai. ");
INSERT INTO meu_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Levi taudia na Aaron mai natuna ida imadia ai bavatodia kau; Israel taudia iboudiai bogaragidia amo idia bavabidia, ia ba henia. ");
INSERT INTO meu_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aaron mai natuna ida ba gwauraidia hidi, hahelaḡa dagina na ediai baine mia. Idau tauna ta baine raka kahi, vada bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Iehova ese Mose ma e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","A itaia, lau ese Levi taudia vada na abidia hidi, Israel taudia bogaragidia amo, Israel taudia edia roboa mamaruanedia ibolodia. Idia na lauegu. ");
INSERT INTO meu_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Badina be roboa mamaruanedia be lauegu, Aigupto taudia natudia mamaruanedia roboadia iboudiai na aladia mase dinana ai, lau ese roboa mamaruanedia iboudiai na abidia lauegu, taunimanima natudia roboadia bona mauri ḡaudia iboudiai natudia roboadia. Idia na lauegu: lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Iehova ese Mose e hereva henia, Sinai tano ḡaḡaena ai, eto, ");
INSERT INTO meu_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Levi taudia iboudiai ba duahidia, tamadia edia ruma ai bona edia iduhu ai; hua ta vada - e hanaia mamaruanedia iboudiai ba duahidia. ");
INSERT INTO meu_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Taunabunai, Mose ese e duahidia, Iehova ese ena hereva ai e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Levi natuna ladadia bini: Gereson bona Kohat bona Merari. ");
INSERT INTO meu_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gereson ese e havaradia iduhudia bini: Libni bona Simei. ");
INSERT INTO meu_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kohat ese e havaradia iduhudia bini: Amram bona Isahara bona Heberon bona Usiele. ");
INSERT INTO meu_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari ese e havaradia iduhudia bini: Mali bona Musi. Levi iduhudia bunu: ihavaradia taudia ladadia e nemaidia. ");
INSERT INTO meu_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gereson garana na Libni taudia bona Simei taudia: Gereson iduhudia bunu. ");
INSERT INTO meu_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Edia mamaruane e duahidia, hua ta e hanaia amo, iboudiai na 7,500. ");
INSERT INTO meu_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gereson taudia edia taruha gabuna be dubu murina, lahara kahana ai. ");
INSERT INTO meu_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Ikwaradia tauna na Eliasaf Laele. ");
INSERT INTO meu_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Hebou kalagana lalonai Gereson taudia bae reḡu ḡaudia bini: dubu bona kalaga dabuadia, bona guhi dabuadia, bona kalaga iduarana dabuadia, ");
INSERT INTO meu_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","bona maḡu dabuadia, bona dubu maḡuna ikoukouna dabuadia, bona ihaboulaina patana, bona kwanau iboudiai. Bae reḡu ḡaudia bunu. ");
INSERT INTO meu_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kohat garana na Amram taudia bona Isahara taudia bona Heberon taudia bona Usiele taudia: Kohat iduhuna bunu. ");
INSERT INTO meu_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Edia mamaruane e duahidia, hua ta e hanaia amo, iboudiai na 8,600; idia na dubu inarina taudia. ");
INSERT INTO meu_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kohat taudia edia taruha gabuna be dubu diho kahana ai. ");
INSERT INTO meu_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Ikwaradia tauna na Elisafan Usiele. ");
INSERT INTO meu_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Bae reḡu ḡaudia bini: maua helaḡana, bona pata helaḡana, bona lamepa patana bona ihaboulaina patadia, bona gabu helaḡana ena kohu iboudiai, hahelaḡa taudia ese kara helaḡadia e karalaimu ḡaudia, bona seseahu. Bae reḡu ḡaudia bunu. ");
INSERT INTO meu_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Eleasara, hahelaḡa tauna, Aaron natuna, na Levi taudia iboudiai ikwaradia, bona gabu helaḡana ḡaukaradia ikaradia taudia edia heitatao tauna. ");
INSERT INTO meu_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Merari garana na Mali taudia bona Musi taudia: Merari iduhudia bunu. ");
INSERT INTO meu_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Edia mamaruane e duahidia, hua ta e hanaia amo, iboudiai na 6,200. ");
INSERT INTO meu_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Ikwaradia tauna na Suriele Abihaili. Edia taruha gabuna na dubu mirigini kahana ai. ");
INSERT INTO meu_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Bae reḡu ḡaudia bini: dubu habana kahadia, bona raroraro, bona ihua-ihua, bona hahelai-kau ḡaudia mai kohudia iboudiai; ");
INSERT INTO meu_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","bona maḡu duna iboudiai mai ihahelai-kaudia ḡaudia, bona edia ikokobona edia kwanau. ");
INSERT INTO meu_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Dubu mairiveina kahana ai bae taruah taudia, hebou kalagana vairanai, dina e daemu kahana ai, be Mose bona Aaron mai natuna ida. Idia ese gabu helaḡana ḡaukaradia bae kara, Israel taudia daidiai. Idau tauna ta baine raka kahi, vada bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Levi taudia, Mose bona Aaron ese iduhu ta ta amo e duahidia, Iehova ena haheḡani dainai, ibouboudiai, hua ta e hanaia amo, na 22,000. ");
INSERT INTO meu_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Iehova ese Mose e hamaoroa, eto, Israel taudia natudia mamaruanedia roboadia ba duahidia, bona ladadia ba tore, hua ta vada e hanaia amo. ");
INSERT INTO meu_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Bena Levi taudia bavabidia, lau Iehova egu, hari Israel taudia natudia mamaruanedia roboadia ibololaidia; Levi taudia edia boromakau danu bavabidia, Israel taudia edia boromakau natudia mamaruanedia roboadia ibololaidia. ");
INSERT INTO meu_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Taunabunai, Mose ese Israel taudia natudia mamaruanedia roboadia e duahidia, Iehova ese e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Roboa mamaruanedia dia iboudiai hua ta e hanaia amo, e duahidia bona ladadia e tore. Ibouboudiai na 22,273. ");
INSERT INTO meu_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Bena Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Levi taudia bavabidia, Israel taudia natudia mamaruanedia roboadia ibololaidia, bona Levi taudia edia boromakau bavabidia, edia boromakau ibololaidia. Levi taudia na lauegu: lau binai Iehova. ");
INSERT INTO meu_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","A Israel taudia natudia mamaruanedia roboadia sinahu-rua hitu-ahui toi asi ibololaidia Levi oreana amo be davadia bakara: ");
INSERT INTO meu_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ta ta amo sekele ima ima amo ba heni. Unu sekele be gabu helaḡana ena sekele: sekele ta lalonai gera be ruahui. ");
INSERT INTO meu_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Bena una moni, hari roboa mamaruanedia ese Levi taudia e hereadia taudia davadia, be Aaron mai natuna ida ba henidia. ");
INSERT INTO meu_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Taunabunai hari Levi taudia ese asie bololaidia taudia davadia be Mose ese e abi, ");
INSERT INTO meu_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Israel taudia natudia mamaruanedia roboadia edia amo, sekele daha-ta sinahu-toi tauratoi-ahui ima, gabu helaḡanaena sekele heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Bena Mose ese una moni na Aaron mai natuna ida e henidia, Iehova ese e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","A Iehova ese Mose bona Aaron e haḡanidia, eto, ");
INSERT INTO meu_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Levi garana bogaragidia amo Kohat garana ba duahidia, edia iduhu ta ta ai, ta ta tamadia edia ruma ai. ");
INSERT INTO meu_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Laḡani toi-ahui ela bona laḡani imahui taudia, hebou kalagana ḡaukaradia bae kara diba taudia iboudiai na ba duahidia. ");
INSERT INTO meu_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Kohat garana edia ḡaukara binai hebou kalagana lalonai: helaḡa herea ḡaudia bae reḡu. ");
INSERT INTO meu_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Taruha irohona negana ai, Aaron mai natuna ida bae raka vareai, seseahu bae kokia oho, taravatu mauana bae ḡovalaia. ");
INSERT INTO meu_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Bena nani kopina amo ma bae ḡovaia, ma ia murimurinai dabua vaiurina amo bae ḡovaia. Ena maduna danu bae toi hanai. ");
INSERT INTO meu_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Bena vairagu ai a atoamu flaoana patana na dabua vaiurina amo bae Iahaia; ia latanai mereki bona nau bona bio bona kehere bae laidia, bona flaoa helaḡana danu bae laia kau. ");
INSERT INTO meu_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Bena dabua kakakakana amo bae ḡovadia ahu, bona ia latanai nani kopina. Ena maduna danu bae toi hanai. ");
INSERT INTO meu_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Bena dabua vaiurina bae abia, lamepa patana mai ena lamepa bona ihaḡoevadia ḡaudia bona momoru iudadia merekidia bona dehoro kavabudia iboudiai bae kumilai. ");
INSERT INTO meu_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Bena nani kopina amo ma bae kumidia, bona ihualaina patana ai bae hiri kau. ");
INSERT INTO meu_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Gold patana na dabua vaiurina amo bae ḡovaia ahu, bena nani kopina bae kumilaia bona ena maduna bae toi hanai. ");
INSERT INTO meu_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Bena gabu helaḡana kohudia iboudiai dabua vaiurina ai bae kumidia, ma nani kopina ai bae kumidia, bena ihualaina patana ai bae hiri kau. ");
INSERT INTO meu_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Una murinai ihaboulaina patana kahuna bae negea, bona ihaboulaina patana na dabua mia-kakana amo bae lahaia. ");
INSERT INTO meu_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Bena una dabua latanaiihaboulaina patana kohudia iboudiai bae lai kau: rahurahu bona kahi bona kahu iudalaina urodia bona ikadolaina gagadia. Bena idoinai na nani kopina amo ba ḡovaia ahu, bona maduna ba toi hanai. ");
INSERT INTO meu_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Aaron mai natuna ida hari gabu helaḡana mai kohuna idoinai bae kumi vaitani, bena Israel taudia ese edia kalaga bae hua negana ai Kohat garana ese ihuadia totona bae raka kahi mai; ḡau tamona, ḡau helaḡana ta basie daua toho, bae mase na garina. Kohat garana edia huahua ḡaudia bunu, hebou kalagana lalona amo. ");
INSERT INTO meu_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Hahelaḡa tauna Aaron natuna Eleasara baine reḡu ḡaudia na lamepa dehorona, bona muramura mai bonadia, bona boubou flaoana, bona dehoro helaḡana. Ia ese danu dubu mai kohuna idoinai bona gabu helaḡana mai kohuna idoinai baine ita tao. ");
INSERT INTO meu_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Bena Iehova ese Mose bona Aaron e hamaorodia, eto, ");
INSERT INTO meu_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Kohat taudia na Levi oreana amo basio negedia daure; ");
INSERT INTO meu_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","a ini ba karadia toma, basie mase to bae mauri helaoreana, ḡau helaḡadia bae raka henidia kahi negana ai: Aaron mai natuna ida bae raka vareai, ta ta ena ḡaukara ena ḡaukara, bona ta ta ena maduna ena maduna, bae henidia; ");
INSERT INTO meu_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","a idia be basie raka vareai, ḡau helaḡadia basie haḡeredia, lasi ona lasi vaitani, bae mase na garina. ");
INSERT INTO meu_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Iehova ese Mose ma e haḡania, eto, ");
INSERT INTO meu_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Gereson garana ba duahidia, edia iduhu ta ta ai, ta ta tamadia edia ruma ai. ");
INSERT INTO meu_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Laḡani toi-ahui elabona laḡani imahui taudia, hebou kalagana ḡaukaradia bae kara diba taudia iboudiai, na bae duahidia. ");
INSERT INTO meu_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Gereson garana edia ḡaukara, bae kara karadia bona bae hua ḡaudia, bini: ");
INSERT INTO meu_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","dubu habana dabuadia, bona hebou kalagana mai guhina ida bona nani kopidia ia latanai heheato danu, bona hebou kalagana iduarana dabuadia, ");
INSERT INTO meu_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","bona maḡu dabuadia, bona dubu bona ihaboulaina patana e ḡeḡedia ahumu maḡuna dabuadia, bona maḡu ikoukouna dabuadia, bona edia kwanau, bona edia ḡaukara ikaralaidia kohudia iboudiai. Unu kohu iḡaukaralaidia ḡaukaradia iboudiai idia ese bae kara. ");
INSERT INTO meu_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Gereson taudia edia ḡaukara bona edia kohu ihuadia idoidiai na Aaron mai natuna ida ese bae hadibadia; umui ese ba haḡanidia, dahaka dahaka bae kara bona dahaka dahaka bae hua. ");
INSERT INTO meu_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Gereson taudia edia ḡaukara bunu, hebou kalagana lalonai. Hahelaḡa tauna Aaron natuna Itamara ese baine itadia tao. ");
INSERT INTO meu_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Merari garana ba duahidia, edia iduhu ta ta ai, ta ta tamadia edia ruma ai. ");
INSERT INTO meu_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Laḡani toi-ahui ela bona laḡani imahui taudia, hebou kalaganaḡaukaradia bae kara diba taudia iboudiai, na bae duahidia. ");
INSERT INTO meu_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Edia ḡaukara hebou kalagana Ialonai be dubu habana kahadia, bona raroraro, bona ihua-ihuamai ihahelai-kaudia ḡaudia ida, bae hua. ");
INSERT INTO meu_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Maḡu dudia danu mai ihahelaikaudia ḡaudia ida, bona ikoko, bona kwanau, bona maḡu kohuna idoinai bona ihaginina ḡaudia iboudiai, idia ese bae hua; ta ta ena maduna ena maduna ba duanailai henidia. ");
INSERT INTO meu_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Merari taudia edia ḡaukara hebou kalagana ai bunai; hahelaḡa tauna Aaron natuna Itamara ese baine itadia tao. ");
INSERT INTO meu_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Taunabunai, Mose bona Aaron bona hebou ikwaradia taudia ese Kohat taudia e duahidia, edia iduhu ta ta ai, ta ta tamadia edia ruma ai; ");
INSERT INTO meu_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Laḡani toi-ahui ela bona laḡani imahui taudia, hebou kalagana ḡaukaradia ikaradiamai dibadia taudia iboudiai, na e duahidia. ");
INSERT INTO meu_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Iboudiai na 2,750. ");
INSERT INTO meu_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Kohat taudia edia numera bunai, Mose bona Aaron ese iduhu ta ta amo hebou kalagana ḡaukaradia ikaradia mai dibadia taudia e duahidia negana ai. Iehova ese e haḡanidia heḡereḡerena, idia ese unu e duahidia toma. ");
INSERT INTO meu_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gereson taudia danu, edia iduhu ta ta ai, ta ta tamadia edia ruma ai, e duahidia; ");
INSERT INTO meu_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","laḡani toi-ahui ela bona laḡani imahui taudia, heboukalagana ḡaukaradia ikaradia mai dibadia taudia iboudiai, e duahidia. ");
INSERT INTO meu_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Iboudiai na 2,630. ");
INSERT INTO meu_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Gereson taudia edia numera bunai, Mose bona Aaron ese iduhu ta ta amo hebou kalagana ḡaukaradia ikaradia mai dibadia taudia e duahidia negana ai. Iehova ese e haḡanidia heḡereḡerena, idia ese unu e duahidia toma. ");
INSERT INTO meu_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Merari taudia danu, edia iduhu ta ta ai, ta ta tamadia edia ruma ai e duahidia, ");
INSERT INTO meu_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","laḡani toi-ahui ela bona laḡani imahui taudia, hebou kalagana ḡaukaradia ikaradia mai dibadia taudia. ");
INSERT INTO meu_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Iboudiai na 3,200. ");
INSERT INTO meu_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Merari taudia edia numera bunai, Mose bona Aaron ese e duahidia negana ai. Iehova ese e haḡanidia heḡereḡerena, idia ese unu e duahidia toma. ");
INSERT INTO meu_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Levi taudia ibouboudiai, Mose bona Aaron bona Israel ikwaradia taudia ese edia iduhu ta ta ai, ta ta tamadia edia ruma ai, e duahidia, ");
INSERT INTO meu_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","laḡani toi-ahui ela bona laḡani imahui taudia, hebou kalagana ḡaukaradiaikaradia mai dibadia bona madunadia ihuadia mai goadadia taudia. ");
INSERT INTO meu_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Iboudiai na 8,580. ");
INSERT INTO meu_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Iehova ese Mose e haḡania heḡereḡerena, idia ta ta ena ḡaukara ena ḡaukara bona ena maduna ena maduna e henidia. Unuhetomana Mose ese e duahidia, Iehova ese e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Iehova ese Mose e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Israel taudia ba haḡanidia, lepra taudia iboudiai bona hura-aru taudia iboudiai bona mase ḡaudia ediaie dau kau dainai e taubu taudia iboudiai na taruha murimurina bae siaidia lao. ");
INSERT INTO meu_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Iboudiai, mamaruane bona hahine, na taruha murimurinai bae raka lasi, lau na noholaiamu taruhana bae hamiroa na garina. ");
INSERT INTO meu_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Taunabunai, Israel taudia unu e karadia toma; taruha murimurina e siaidia lao, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Iehova ese Mose ma e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Israel taudia ba hamaorodia, tau ta eiava hahine ta baine kara dika, Iehova vairanai baine kerere, ");
INSERT INTO meu_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ia ese ena kara dika baine gwauraia hedinarai, bona ena kara dika ai e hadikaia tauna davana baine henia mai atokauna ida. Atokauna na davana korikori bema karoa, karoa ima, bena karoa ta heḡereḡerena ma baine atoa kau. ");
INSERT INTO meu_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","A bema asi dalana ia baine henia eiava varavarana ta baine henia, davana na Iehova baine henia, hahelaḡa tauna ena, bona ena herohemaino boubouna mamoena danu. ");
INSERT INTO meu_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Bona Israel taudia edia helaḡa ḡaudia iboudiai Iehova vairanai bae dudui isi na hahelaḡa tauna ese baine abi, ia ana. ");
INSERT INTO meu_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Taunimanima iboudiai edia helaḡa ḡaudia hahelaḡa tauna bae henia na iena ḡau. ");
INSERT INTO meu_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Iehova ese Mose ma e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Israel taudia ba hamaorodia, hahine ta baine kerere, ");
INSERT INTO meu_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","tau ta ida bae heuda hanai; bena baine hunia, adavana asi dibana, tau ta asi dibana, ta danu basine davaria; ");
INSERT INTO meu_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","to adavana baine mama, baine mama henia mai badina eiava baine mama henia asi badina; ");
INSERT INTO meu_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","una tau ese bali flaoana efa ta baine karoa, karoa gwauta, bena karoa ta asi dehorona bona asi muramurana baine abia kau, bona hahine baine hakaua lao, hahelaḡa tauna dekenai. Bena hari flaoa baine henia, mama boubouna, kara kerere ilalolaina. ");
INSERT INTO meu_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Bena hahelaḡa tauna ese hahine baine boiria, baine raka kahi mai Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Bena hahelaḡa tauna na ranu helaḡa baine abia, raro biona ta ai, bona tano ḡahuna taina dubu lalona amo una ranu ai baine udaia. ");
INSERT INTO meu_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Bena ia ese hahine huina baine ruhaia, Iehova vairanai; bona hari flaoa, mama boubouna bona kerere ilalolaina ḡauna, na hahine imana ai baine atoa. A hahelaḡa tauna ese hari ranu iditana, hahedika ḡauna, na ia sibona imana ai baine abia. ");
INSERT INTO meu_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Bena ia ese hahine baine taravaia, baineto “Bema adavamu so koia, tau ta ida so heuda hanai, ina ranu iditana, ena be hahedika ḡauna, to basine hadikamu; ");
INSERT INTO meu_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","a bema adavamu o koia, tau ta ida o heuda hanai” ");
INSERT INTO meu_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(hahelaḡa tauna ese hahine ma baine taravaia, baineto) “Iehova ese kara havara toana bona taravatu itata-utuna toanaai baine halaomu emu bese taudia bogaragidiai; mamumu ruaosi bae mase, bona bogamu baine gudu; ");
INSERT INTO meu_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","momokani, ina hahedika ranuna na bogamu ai baine diho negana ai, bogamu do baine gudu, bona mamumu ruaosi bae mase”. Bena hahine na baineto “Amen, amen”. ");
INSERT INTO meu_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Una murinai hahelaḡa tauna na unu hahedika herevadia buka ai baine tore, bena una revareva na hari ranu iditana amo ma baine huria heroho. ");
INSERT INTO meu_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Bena una ranu iditana na ia ese hahine baine henia, baine inua totona. Baine inua, bena una hahedika ranuna na ia bogana ai baine idita. ");
INSERT INTO meu_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","A guna, hahelaḡa tauna ese mama boubouna flaoana na hahine imana amo baine abia, Iehova vairanai baine davea; bena baine laohaia ihaboulaina patana badibadinai. ");
INSERT INTO meu_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Bena flaoa taina imana ai baine abia, ihaboulaina patana lahina ai baine haḡolea oho, helalo ḡauna; una murinai hahine ese una ranu iditana baine inua. ");
INSERT INTO meu_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Bema una hahine ese adavana vada e koia, tau ta ida vada e heuda hanai, una ranu iditana baine inua bona bogana ai baine diho negana ai bogana baine gudu bona mamuna bae mase; bena hahedika toana ai bainela, ena bese taudia bogaragidiai. ");
INSERT INTO meu_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","A bema asi ena kerere, ia na basine dika; baine mauri, bona baine rogorogo, natuna baine abidia. ");
INSERT INTO meu_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Mama taravatuna bunai, hahine ta ese adavana baine koia, tau ta ida bae heuda hanai, ");
INSERT INTO meu_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","eiava tau ta ese adavana baine mama henia, taravatuna. Ia ese Iehova vairanai baine atoa; bena hahelaḡa tauna ese hari taravatu karana baine karaia. ");
INSERT INTO meu_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Bena hari tau na asi ena kerere; a una hahine be ena kerere davana baine huaia. ");
INSERT INTO meu_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Iehova ese Mose e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Israel taudia ba hamaorodia, tau ta eiava hahine ta baine gwau hamata, Nasiri gwau-hamatana baineabia, ia na baine helaḡa, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","Ia ese vine ranuna eiava kekero ḡauna ta basine inua; inuinu ḡaudia unuhetomadia iboudiai basine inu. Vine huahuadia ranudia basine inu, bona anidia basine ani; vine huahuadia matamatadia eiava kaukaudia basine ani. ");
INSERT INTO meu_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Ena helaḡa dinadia iboudiai vine anidia, nadinadidia ela kopidia, na basine ani. ");
INSERT INTO meu_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Ena helaḡa dinadia iboudiai danu huina iutuna eiava kwarana inauna aurina na ia kwarana ai basine dau kau. Iehova e gwaurai henia hamata dinadia iboudiai ia na baine helaḡa; huina do baine lata. ");
INSERT INTO meu_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Ena helaḡa dinadia iboudiai danu ia ese mase tauna ta basine raka henia kahi. ");
INSERT INTO meu_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Ena be tamana eiava sinana eiava taihuna eiava tadikakana baine mase, to mase tauna enai basine miro; badina be vada e gwau hamata, baine helaḡa Iehova ena. ");
INSERT INTO meu_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Taunabunai, ena gwau-hamata dinadia iboudiaiia na helaḡa, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","A tau ta ia badibadinai bema mase taku, bena unu amo baine miro, dina hitu na baela, bena dina ihahituna ai ihaḡoevana dinana ai, ia ese kwarana baine naua. ");
INSERT INTO meu_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Dina ihataurahanina ai, ia ese kerea rua eiava pune natuna rua baine abidia, hahelaḡa tauna dekena baine mailaidia, hebou kalagana iduarana ai. ");
INSERT INTO meu_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Bena hahelaḡa tauna ese baine hahelaḡadia, ta kara-dika iabi-ohona boubouna, ma ta ḡole-oho boubouna, una tau dainai herohemaino karana baine karaia; badina be ia na una mase dainai vada e kerere. Una dina ai, ia ese kwarana baine hahelaḡaia lou; ");
INSERT INTO meu_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","baine helaḡa, Iehova ena, ena gwau-hamata dinadia iboudiai. Mamoemaruanena ta, laḡani tamona ḡauna, danu baine mailaia, kerere iabi-ohona boubouna ai bainela. A dina gunadia be basine duahidia, badina be ena gwauhamata vada e dika. ");
INSERT INTO meu_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Nasiri tauna ese ena gwau-hamata dinadia baine haḡuḡurudia taravatuna binai: bae hakaua lao hebou kalagana iduarana ai; ");
INSERT INTO meu_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","unuseni ai, ia ese ena herahia ḡaudia Iehova baine henia, mamoe natuna maruanena ta, asi bebeka-bebekana, laḡani tamona ḡauna, na ḡole-oho boubouna ai baine halaoa; bonamamoe natuna hahinena ta, asi bebeka-bebekana, laḡani tamona ḡauna, nakara-dika iabi-ohona boubouna ai baine halaoa; bona mamoe maruanenata, asi bebeka-bebekana, na herohemaino boubouna ai baine halaoa; ");
INSERT INTO meu_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","bona flaoa, asie hatubua ḡauna, boseana ta, lalonai be flaoa atagadia, flaoa namo-hereana dehoro ida e bulo bena e gabu ḡaudia, bona flaoa atagadia, latadiai dehoro e seia ḡaudia, bona flaoa boubouna, bona vine ranuna boubouna. ");
INSERT INTO meu_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Bena hahelaḡa tauna ese Iehova vairanai baine atodia: kara-dika iabi-ohona boubouna bona ḡole-oho boubouna baine hahelaḡadia; ");
INSERT INTO meu_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","herohemaino mamoena danu baine hahelaḡaia, Iehova ena; bona asie hatubua flaoana boseana bona flaoa boubouna bona vine ranuna boubouna, iboudiai baine hahelaḡadia, hahelaḡa tauna ese. ");
INSERT INTO meu_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Una murinai hari Nasiri tauna ese kwarana baine naua, hebou kalagana iduarana ai; bona huina, ena gwauhamata toana, na herohemaino bouboudia lahina ai baine gabua. ");
INSERT INTO meu_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Bena hahelaḡa tauna ese mamoe maruanena larolarona maedana baine abia, bona flaoa dehoro ida e buloa atagana ta bona latanai dehoro e seia atagana ta danu baine abidia, hari Nasiri tauna imana ruaosi ai baine ato kau, kwarana baine naua murinai. ");
INSERT INTO meu_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Bena hahelaḡa tauna ese baine abidia lou, Iehova vairanai baine davedia: una na hahelaḡa tauna ahuna helaḡana. Keme, e davea ḡauna, bona mamu, e duduia isi ḡauna, danu ia ahuna. Una murinai hari Nasiri tauna na vine ranuna baine inua. ");
INSERT INTO meu_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Nasiri gwau-hamatana e abiamu tauna taravatuna bunai; ena boubou, Iehova baine henia ḡaudia, taravatudia danu unuheto. Ma boubou haida baine heni danu namo. E gwauraia; hamata heḡereḡerena, unu baine kara toma Nasiri taravatuna ihaḡuḡuruna. ");
INSERT INTO meu_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Iehova ese Mose ma e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Aaron mai natuna ida ba hamaorodia, Israel taudia bae hanamodia negadia ai, ini bae gwau toma: ");
INSERT INTO meu_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Iehova ese baine hanamomui, bona baine gimamui; ");
INSERT INTO meu_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Iehova ese ia vairana diarina amo baine hadiarimui, bona baine harihari henimui; ");
INSERT INTO meu_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Iehova ese baine haḡeremui, bona maino baine henimui. ");
INSERT INTO meu_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Lau ladagu unu bae gwauraia toma Israel taudia latadiai; bena lau ese baina hanamodia. ");
INSERT INTO meu_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Mose ese dubu e haginia vaitani dinana ai, ia ese dubu mai kohuna idoinai dehoro amo e horodia bona e hahelaḡadia; ihaboulaina patana danu mai kohuna idoinai dehoro amo e horodia bona e hahelaḡadia. ");
INSERT INTO meu_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Una dina ai danu Israel lohiadia, iduhu ikwaradia taudia, e duahidia taudia iboudiai biagudia, ese ");
INSERT INTO meu_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","edia herahia ḡaudia e mailaidia, Iehova vairanai e atodia. Ḡaudia be rerue mai rumarumadia tauratoi bona boromakau mamaruanedia dia gwauta rua: lohia rarua rarua amo rerue ta ta, bona lohia ta ta amo boromakau mamaruanena ta ta; idia ese dubu vairanai e hahelaḡadia. ");
INSERT INTO meu_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Bena Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Edia herahia ḡaudia bavabi, hebou kalagana ena ḡaukara ḡaudia ai baela. Levi taudia ba henidia, ta ta ena ḡaukara ena ḡaukara heḡereḡeredia. ");
INSERT INTO meu_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Taunabunai, Mose ese rerue bona boromakau e abidia, Levi taudia e henidia. ");
INSERT INTO meu_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Rerue rua bona boromakau mamaruanedia hani Gereson natuna e henidia, edia ḡaukara heḡereḡerena; ");
INSERT INTO meu_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ma rerue hani bona boromakau mamaruanedia taurahani Merari natuna e henidia, edia ḡaukara heḡereḡerena: unu ḡaukara be Itamara, hahelaḡa tauna Aaron natuna, ese e biagudia. ");
INSERT INTO meu_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","A Kohat natuna be ḡau ta se henidia, badina be edia ḡaukara be dubu kohudia helaḡadia paḡadia ai bae hua. ");
INSERT INTO meu_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Hari lohia taudia ese danu edia herahia ḡaudia haida ma e mailaidia, ihaboulaina patana ihahelaḡana totona ihaboulaina patana dehoro amo e horoa dinana ai. Unu herahia na ihaboulaina patana vairanai e atodia diho. ");
INSERT INTO meu_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Bena Iehova ese Mose e hamaoroa, eto, Dina ta ta ai lohia ta ta ena herahia ena herahia bae hahelaḡadia, unu amo ihaboulaina patana baine helaḡa. ");
INSERT INTO meu_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Dina gini-gunana ai Nason Aminadab, Iuda iduhuna tauna, ese ena herahia e hahelaḡaia. ");
INSERT INTO meu_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Ena herahia ḡaudia bini: silver merekina ta, metauna na sekele sinahu-ta toi-ahui, bona silver kibokibona ta, metauna na sekelehitu-ahui, gabu helaḡana ena sekele heḡereḡerena; unu ḡau ruaosi na flaoa namo-hereana, dehoro ida e buloa ḡauna, vada e honu, flaoa boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","bona gold nauna ta, metauna na sekele gwauta, muramura mai bonadia vada e honu; ");
INSERT INTO meu_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","bona boromakau natuna maruanena ta; bona mamoe maruanena ta; bona mamoe natuna maruanena ta, laḡani, tamona ḡauna, ia na ḡole-oho boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","bona nani maruanena ta, kara-dika iabi-ohona boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","bona boromakau mamaruanedia rua, bona mamoe mamaruanedia ima, bona nani mamaruanedia ima, bona mamoe natudia mamaruanedia ima laḡani tamona ḡaudia, unu iboudiai be herohemaino boubouna. Nason Aminadab ena herahia bunu. ");
INSERT INTO meu_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Dina iharuana ai Netanele Suara, Isakara Iohiana, ese ena herahia e hahelaḡaia. ");
INSERT INTO meu_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Ena herahia ḡaudia bini: silver merekina ta, metauna na sekele sinahu-ta toi-ahui, bona silver kibokibona ta, metauna na sekele hitu-ahui, gabu helaḡana ena sekele heḡereḡerena: unu ḡau ruaosi na flaoa namo-hereana, dehoro ida e buloa ḡauna, vada e honu, flaoa boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","bona gold nauna ta, metauna na sekele gwauta, muramura mai bonadia vada e honu; ");
INSERT INTO meu_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","bona boromakau natuna maruanena ta; bona mamoe maruanena ta; bona mamoe natuna maruanena ta, laḡani tamona ḡauna, ia na- ḡole-oho boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","bona nani maruanena ta, kara-dika iabi-ohona boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","bona boromakau mamaruanedia rua, bona mamoe mamaruanedia ima, bona nani mamaruanedia ima, bona mamoe natudia mamaruanedia ima, laḡani tamona ḡaudia, unu iboudiai be herohemaino boubouna. Netanele Suara ena herahia bunu. ");
INSERT INTO meu_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Dina ihatoina ai Eliab Helon, Sebulun lohiana, ");
INSERT INTO meu_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","ena herahia ḡaudia bini: silver merekina ta, metauna na sekele sinahu-ta toi-ahui, bona silver kibokibona ta, metauna na sekele hitu-ahui, gabu helaḡana ena sekele heḡereḡerena; unu ḡau ruaosi na flaoa namo-hereana, dehoro ida e buloaḡauna, vada e honu, flaoa boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","bona gold nauna ta, metauna na sekele gwauta, muramura mai bonadia vada e honu; ");
INSERT INTO meu_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","bona boromakau natuna naruanena ta; bona mamoe maruanena ta; bona mamoe natuna maruanena ta, laḡani tamona ḡauna, ia na ḡole-oho boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","bonanani maruanena ta, kara-dika iabi-ohona boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","bona boromakau mamaruanedia rua, bona mamoe maruanena ima, bona nani mamaruanedia ima, bona mamoe natudia mamaruanedia; ima, laḡani tamona ḡaudia, unu iboudiai be herohemaino boubouna. Eliab Helon ena herahia bunu. ");
INSERT INTO meu_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Dina ihahanina ai Elisuru Sedeuru, Ruben lohiana, ");
INSERT INTO meu_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","ena herahia ḡaudia bini: silver merekina ta, metauna na sekele sinahu-ta toi-ahui, bona silver kibokibona ta, metauna na sekele hitu-ahui, gabu helaḡana ena sekele heḡereḡerena; unu ḡau ruaosi na flaoa namo-hereana, dehoro ida e buloaḡauna, vada e honu, flaoa boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","bona gold nauna ta, metauna na sekele gwauta, muramura mai bonadia vada e honu; ");
INSERT INTO meu_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","bona boromakau natuna maruanena ta; bona mamoe maruanena ta; bona mamoe natuna maruanena ta, laḡani tamona ḡauna, ia na ḡole-oho boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","bonanani maruanena ta, kara-dika iabi-ohona boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","bona boromakau mamaruanedia rua, bona mamoe mamaruanedia ima, bona nani mamaruanedia ima, bona mamoe natudia mamaruanedia ima, laḡani tamona ḡaudia, unu iboudiai be herohemaino boubouna. Elisuru Sedeuru ena herahia bunu. ");
INSERT INTO meu_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Dina iha-imana ai Selumiele Surisadai, Simeon lohiana, ");
INSERT INTO meu_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","ena herahiaḡaudia bini: silver merekina ta, metauna na sekele sinahu-ta toi-ahui, bona silver kibokibona ta, metauna na sekele hitu-ahui, gabu helaḡana ena sekele heḡereḡerena; unu ḡau ruaosi na flaoa namo-hereana, dehoro ida e buloaḡauna, vada e honu, flaoa boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","bona gold nauna ta, metauna na sekele gwauta, muramura mai bonadia vada e honu; ");
INSERT INTO meu_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","bona boromakau natuna maruanena ta; bona mamoe maruanena ta; bona mamoe natuna maruanena ta, laḡani tamona ḡauna, ia na ḡole-oho boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","bonanani maruanena ta, kara-dika iabi-ohona boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","bona boromakau mamaruanedia rua, bona mamoe mamaruanedia ima, bona nani mamaruanedia ima, bona mamoe natudia mamaruanedia ima, laḡani tamona ḡaudia, unu iboudiai be herohemaino boubouna. Selumiele Surisadai ena herahia bunu. ");
INSERT INTO meu_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Dina ihatauratoina ai Eliasaf Reuele, Gad lohiana, ");
INSERT INTO meu_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","ena herahia ḡaudia bini: silver merekina ta, metauna na sekele sinahu-ta toi-ahui, bona silver kibokibona ta, metauna na sekele hitu-ahui, gabu helaḡana ena sekele heḡereḡerena; unu ḡau ruaosi na flaoa namo-hereana, dehoro ida e buloaḡauna, vada e honu, flaoa boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","bona gold nauna ta, metauna na sekele gwauta, muramura mai bonadia vada e honu; ");
INSERT INTO meu_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","bona boromakau natuna maruanena ta; bona mamoe maruanena ta; bona mamoe natuna maruanena ta, laḡani tamona ḡauna, ia na ḡole-oho boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","bonanani maruanena ta, kara-dika iabi-ohona boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","bona boromakau mamaruanedia rua, bona mamoe mamaruanedia ima, bona nani mamaruanedia ima, bona mamoe natudia mamaruanedia ima, laḡani tamona ḡaudia, unu iboudiai be herohemaino boubouna. Eliasaf Reuele ena herahia bunu. ");
INSERT INTO meu_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Dina ihahituna ai Elisama Amihud, Efraim lohiana, ");
INSERT INTO meu_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","ena herahia ḡaudia bini: silver merekina ta, metauna na sekele sinahu-ta toi-ahui, bona silver kibokibona ta, metauna na sekele hitu-ahui, gabu helaḡana ena sekele heḡereḡerena; unu ḡau ruaosi na flaoa namo-hereana, dehoro ida e buloaḡauna, vada e honu, flaoa boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","bona gold nauna ta, metauna na sekele gwauta, muramura mai bonadia vada e honu; ");
INSERT INTO meu_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","bona boromakau natuna maruanena ta; bona mamoe maruanena ta; bona mamoe natuna maruanena ta, laḡani tamona ḡauna, ia na ḡole-oho boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","bonanani maruanena ta, kara-dika iabi-ohona boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","bona boromakau mamaruanedia rua bona mamoe maruanena ima, bona nani mamaruanedia ima, bona mamoe natudia mamaruanedia ima, laḡani tamona ḡaudia, unu iboudiai be herohemaino boubouna. Elisama Amihud ena herahia bunu. ");
INSERT INTO meu_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Dina ihataurahanina ai Gamaliel; Pedasuru, Manase lohiana, ");
INSERT INTO meu_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","ena herahia ḡaudia bini: silver merekina ta, metauna na sekele sinahu-ta toi-ahui, bona silver kibokibona ta, metauna na sekele hitu-ahui, gabu helaḡanaena sekele heḡereḡerena; unu ḡau ruaosi na flaoa namo-hereana, dehoro idae buloa ḡauna, vada e honu, flaoa boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","bona gold nauna ta, metauna na sekele gwauta, muramura mai bonadia vada e honu; ");
INSERT INTO meu_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","bona boromakau natuna maruanena ta; bona mamoe maruanena ta; bona mamoe natuna maruanena ta, laḡani tamona ḡauna, ia na ḡole-oho boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","bona nani maruanena ta, karadika, dika iabi-ohona boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","bona boromakau mamaruanedia rua, bona mamoe mamaruanedia ima, bona nani mamaruanedia ima, bona mamoe natudia mamaruanedia ima, laḡani tamona ḡaudia, unu iboudiai be herohemaino boubouna. Gamaliel Pedasuru ena herahia bunu. ");
INSERT INTO meu_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Dina ihataurahani-tana ai Abidan Gideoni, Beniamina lohiana, ");
INSERT INTO meu_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","enaherahia ḡaudia bini: silver merekina ta, metauna na sekele sinahu-ta toi-ahui, bona silver kibokibona ta, metauna na sekele hitu-ahui, gabu helaḡana ena sekele heḡereḡerena; unu ḡau ruaosi na flaoa namo-hereana, dehoro idae buloa ḡauna, vada e honu, flaoa boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","bona gold nauna ta, metauna na sekele gwauta, muramura mai bonadia vada e honu; ");
INSERT INTO meu_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","bona boromakau natuna maruanena ta, bona mamoe maruanena ta; bona mamoe natuna maruanena ta, laḡani tamona ḡauna, ia na ḡole-oho boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","bona nani maruanena ta, kara-dika iabi-ohona boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","bona boromakau mamaruanedia rua, bona mamoe mamaruanedia ima, bona nani mamaruanedia ima, bona mamoe natudia mamaruanedia ima, laḡani tamona ḡaudia, unu iboudiai be herohemaino boubouna. Abidan Gideoni ena herahia bunu. ");
INSERT INTO meu_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Dina ihagwautana ai Ahiesere Amisadai, Dan lohiana, ");
INSERT INTO meu_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","ena herahia ḡaudia bini: silver merekina ta, metauna na sekele sinahu-ta toi-ahui, bona silver kibokibona ta, metauna na sekele hitu-ahui, gabu helaḡana ena sekele heḡereḡerena; unu ḡau ruaosi na flaoa namo-hereana, dehoro ida e buloaḡauna, vada e honu, flaoa boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","bona gold nauna ta, metauna na sekele gwauta, muramura mai bonadia vada e honu; ");
INSERT INTO meu_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","bona boromakau natuna maruanena ta; bona mamoe maruanena ta; bona mamoe natuna maruanena ta, laḡani tamona ḡauna, ia na ḡole-oho boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","bonanani maruanena ta, kara-dika iabi-ohona boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","bona boromakau mamaruanedia; rua, bona mamoe mamaruanedia ima, bona nani mamaruanedia ima, bona mamoe natudia mamaruanedia ima, laḡani tamona ḡaudia, unu iboudiai be herohemaino boubouna. Ahiesere Amisadai ena herahia bunu. ");
INSERT INTO meu_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Dina ihagwauta-tana ai Pagiele Okran, Asere lohiana, ");
INSERT INTO meu_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","ena herahia ḡaudia bini: silver merekina ta, metauna na sekele sinahu-ta toi-ahui, bona silver kibokibona ta, metauna na sekele hitu-ahui, gabu helaḡana ena sekele heḡereḡerena; unu ḡau ruaosi na flaoa namo-hereana, dehoro ida e buloaḡauna, vada e honu, flaoa boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","bona gold nauna ta, metauna na sekele gwauta, muramura mai bonadia vada e honu; ");
INSERT INTO meu_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","bona boromakau natuna maruanena ta; bona mamoe maruanena ta; bona mamoe natuna maruanena ta, laḡani tamona ḡauna, ia na ḡole-oho boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","bonanani maruanena ta, kara-dika iabi-ohona boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","bona boromakau mamaruanedia rua, bona mamoe mamaruanedia ima, bona nani mamaruanedia ima, bona mamoe natudia mamaruanedia ima, laḡani tamona ḡaudia, unu iboudiai be herohemaino boubouna. Pagiele Okran ena herahia bunu. ");
INSERT INTO meu_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Dina ihagwauta-ruana ai Ahira Enan, Napatali lohiana, ");
INSERT INTO meu_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","ena herahiaḡaudia bini: silver merekina ta, metauna na sekele sinahu-ta toi-ahui, bona silver kibokibona ta, metauna na sekele hitu-ahui, gabu helaḡana ena sekele heḡereḡerena; unu ḡau ruaosi na flaoa namo-hereana, dehoro ida e buloaḡauna, vada e honu, flaoa boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","bona gold nauna ta, metauna na sekele gwauta, muramura mai bonadia vada e honu; ");
INSERT INTO meu_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","bona boromakau natuna maruanena ta; bona mamoe maruanena ta; bona mamoe natuna maruanena ta, laḡani tamona ḡauna, ia na ḡole-oho boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","bonanani maruanena ta, kara-dika iabi-ohona boubouna; ");
INSERT INTO meu_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","bona boromakau mamaruanedia rua, bona mamoe mamaruanedia ima, bona nani mamaruanedia ima, bona mamoe natudia mamaruanedia ima, laḡani tamona ḡaudia, unu iboudiai be herohemaino boubouna. Ahira Enan ena herahia bunu. ");
INSERT INTO meu_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Israel lohiadia na ihaboulaina patana ihahelaḡana herahiadia e heni, dehoro amo e horoa dinana ai, ḡaudia bini: silver merekidia gwauta-rua; silver kibokibodia gwauta-rua; gold naudia gwauta-rua. ");
INSERT INTO meu_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Silver merekidiata ta ena metau ena metau be sekele sinahu-ta toi-ahui; bona silver kibokibodiata ta ena metau ena metau be sekele hitu-ahui. Silver ḡaudia iboudiai ediametau idoinai be sekele daha-rua sinahu-hani, gabu helaḡana ena sekele heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Hari gold naudia gwauta-ruaosi, muramura mai bonadiae honu ḡaudia, ta ta ena metau ena metau be sekele gwauta, gabu helaḡana ena sekele heḡereḡerena; gold ḡaudia iboudiai edia metau idoinai be sekele sinahu-ta ruahui. ");
INSERT INTO meu_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Boromakau mamaruanedia, ḡole-oho boubouna ḡaudia, iboudiai begwauta-rua; mamoe mamaruanedia danu gwauta-rua, bona mamoe natudia mamaruanedia, laḡani tamona ḡaudia, be gwauta-rua, mai flaoa bouboudiaida e heni. Nani mamaruanedia, kara-dika iabi-ohona bouboudia ḡaudia, na gwauta-rua danu. ");
INSERT INTO meu_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Boromakau mamaruanedia, herohemaino bouboudia ḡaudia, na ruahui hani; mamoe mamaruanedia na tauratoi-ahui; nani mamaruanedia na tauratoi-ahui; mamoe natudia mamarua nedia, laḡani tamonaḡaudia, danu tauratoi-ahui. Ihaboulaina patana ihahelaḡana herahiadia bunu, dehoro amo e horoa dinana ai e heni. ");
INSERT INTO meu_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Mose na hebou kalagana lalonai e raka vareai, Iehova ida bae herevahereva eto. Una negana ai Iehova gadona e kamonai, taravatu mauana ikaruhina daena amo bona kerubi ruaosi padadia amo ema, e hereva henia. ");
INSERT INTO meu_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Iehova ese Mose e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Aaron ba hamaoroa, lamepa na gabudia ai baine atodia negana ai, lamepa hituosi na lamepa patana vairana kahana bae. ");
INSERT INTO meu_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Bena Aaron na unu e kara toma: lamepa na gabudia e ato, lamepa patana vairana kahana e hadiaria, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Hari lamepa na gold amo e koroa, aena ela bona heraherana, idoinai na gold amo e koroa; Iehova ese Mose e hadibalaia heḡereḡerena, hari lamepa patana na unu e koroa toma. ");
INSERT INTO meu_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Levi taudia na Israel taudia bogaragidia amo bavabidia, ba haḡoevadia. ");
INSERT INTO meu_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ini ba haḡoevadia toma: ranu helaḡana amo ba nevaridia; bena kopidia idoidiai bae naudia, edia dabua bae huridia, bona bae digu. ");
INSERT INTO meu_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Una murinai idia ese boromakau natuna maruanena ta bae abia, mai ena flaoa boubouna ida, flaoa namohereana dehoro ida e buloa ḡauna. Boromakau natuna maruanena ma ta danu bavabia, kara-dika iabi-ohona boubouna. ");
INSERT INTO meu_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Bena Levi taudia nahebou kalagana vairanai ba hakaudia lasi; bona Israel oreana taudia iboudiai ba haboudia. ");
INSERT INTO meu_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Bena Levi taudia na Iehova vairanai ba haginidia. Israel taudia ese imadia na Levi taudia latadiai bae ato kau; ");
INSERT INTO meu_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","bena Aaron ese Levi taudia baine abidia, davedave boubouna ai baine halaodia, Israel taudia edia amo, Iehova isiaina bae lao heni totona. ");
INSERT INTO meu_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Bena Levi taudia ese imadia na boromakau mamaruanedia kwaradia ai bae ato kau; ta kara-dika iabi-ohona boubouna ai ba halaoa, ma ta ḡole-oho boubouna ai ba halaoa, Iehova ena, Levi taudia daidiai herohemaino karana ba karaia. ");
INSERT INTO meu_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Bena Levi taudia na Aaron mai natuna ida vairadiai ba haginidia, davedave boubouna ai baela Iehova ena. ");
INSERT INTO meu_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Levi taudia na Israel taudia bogaragidia amo unu ba hididia toma; idia na lauegu. ");
INSERT INTO meu_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Una negana ai, ba haḡoevadia bona davedave boubouna ai ba halaodia murinai, idia na hebou kalagana lalonai bae raka vareai, bona ḡaukarana bae karaia. ");
INSERT INTO meu_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Badina be Israel taudia bogaragidia amo vada o henigu; Israel hahinedia iboudiai natudia mamaruanedia roboadia ibolodia vada na abidia. ");
INSERT INTO meu_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Badina be roboa mamaruanedia iboudiai Israel ai na lauegu, taunimanima natudia roboadia bona ubu-ubu ḡaudia natudia roboadia; Aigupto tanona ai roboa mamaruanedia iboudiai na aladia mase dinana ai na hahelaḡadia lauegu. ");
INSERT INTO meu_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","A Israel edia roboa mamaruanedia ibolodia na Levi taudia vada na abidia, ");
INSERT INTO meu_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Aaron mai natuna ida vada na henidia, Israel taudia bogaragidia; amo; hebou kalagana ḡaukaradia bae kara idia daidiai, bona Israel taudia daidiai herohemaino karana bae karaia, gabu helaḡana bae raka henia kahi bena gorere ese baine aladia na garina. ");
INSERT INTO meu_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Ini kara iboudiai Mose bona Aaron bona Israel oreana taudia iboudiai ese Levi taudia e kara henidia; Iehova ese Levi taudia herevadia Mose e haḡanilaia heḡereḡerena, Israel taudia na unu e kara toma. ");
INSERT INTO meu_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Levi taudia ese edia kara-dika amo e haheḡoeva bona edia dabua e huri; bena Aaron ese davedave boubouna ai e halaodia, Iehova vairanai. Aaron ese herohemaino karana vada, e karaia, idia daidiai, idia ihaḡoevadia totona. ");
INSERT INTO meu_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Una murinai Levi taudia na hebou kalagana ai e raka vareai, Aaron mai natuna ida idurulaida ḡaukaradia e kara; Iehova ese Levi taudia herevadia Mose e haḡanilaia heḡereḡerena, idia na unu e kara toma. ");
INSERT INTO meu_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Bena Iehova ese Mose ma e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Levi taudia herevadia bini edia vara laḡanidia bae ruahui ima negana ai bae ḡaukara matama, hebou kalagana lalonai; ");
INSERT INTO meu_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ela bona edia vara laḡanidia bae imahui negana ai ḡaukara na bae rakatania, basie karaia lou. ");
INSERT INTO meu_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Una murinai, idia ese varavaradia bae bamodia, hebou kalagana ireḡuna ai, to basie ḡaukara. Levi taudia edia ḡaukara na unu ba henidia toma. ");
INSERT INTO meu_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Israel taudia ese Aigupto tanona amo e raka lasi murinai, laḡani iharuana ena hua gini-gunana ai Iehova ese Mose e hereva henia Sinai tano ḡaḡaenaai, ");
INSERT INTO meu_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","eto, Israel taudia ese lagau-hanai ariana bae badinaia, ena nega korikoriai. ");
INSERT INTO meu_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Una hua ena dina ihagwauta-hanina adorahina ai ba karaia, ena nega korikorina ai, taravatuna iboudiai heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Taunabunai, Mose ese Israel taudia e haḡanidia, lagau-hanai ariana bae karaia eto. ");
INSERT INTO meu_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Bena hua gini-gunana ena dina ihagwauta-hanina adorahina ai lagau-hanai ariana e karaia, Sinai tano ḡaḡaena ai; Iehova ese Mose e haḡanilaia karadia iboudiai na a Israel taudia ese e karadia ḡuḡuru. ");
INSERT INTO meu_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","A tatau haida vada e taubu, mase tauna enai vada e dau kau dainai, taunabunai idia na mai edia hekwakwanai lagau-hanai ibadinana ai una dina ai, bena idia ese Mose bona Aaron dekedia ela una dina ai. ");
INSERT INTO meu_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Idia ese Mose e hamaoroa eto, Ai a taubu, mase tauna enai vada a dau kau dainai. Badina be dahaka ai ese Iehova basia boua diba, nega korikorina ai, Israel taudia iboudiai ida ");
INSERT INTO meu_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mose ese e haere henidia, eto, Do ba noho, ela bona lau baina kamonai, Iehova ede baine haḡanilaigu toma umui daimui ai. ");
INSERT INTO meu_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Bena Iehova ese Mose e haḡania, eto, ");
INSERT INTO meu_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Israel taudia ba hamaorodia, baoto: Ena be umui emui ai eiava garamui ediai tau ta baine taubu, mase tauria enai baine dau kau dainai, eiava dauhai baine laolao, to ia be Iehova ena lagau-hanai ariana baine badinaia. ");
INSERT INTO meu_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Idia ese hua iharuana ena dinaihagwauta-hanina adorahina ai bae karaia; mai flaoana, asie hatubua ḡauna, bona mai aniani avadia iditadia ida do bae ania. ");
INSERT INTO meu_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Bahu basine mia rani, turiana ta danu basie hakwaidua; lagau-hanai taravatudia iboudiai heḡereḡeredia ai bae karaia. ");
INSERT INTO meu_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","A tau ta se miromu eiava se laolaomu to lagau-hanai ariana basine badinaia, una tau be ena bese amo bae negea daure; badina be Iehova se boua, nega korikorina ai. Una tau be ena dika do baine huaia. ");
INSERT INTO meu_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Bema idau tauna ta dekemui ai baine noho hedoa, bena ia baine ura Iehova ena lagau-hanai ariana baine ania, lagau-hanai taravatudia heḡereḡeredia, ia be baine ania diba. Emui taravatu baine tamona, noho-hedoa taudia bona bese korikori taumui. ");
INSERT INTO meu_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Dubu e haginia dinana ai, ori ese dubu, taravatu mauana kalagana, e ḡovaia ahu, ela bona hanua e boi, bena ita-itana na lahi na heto ela bonadaba e rere, dubu daenai. ");
INSERT INTO meu_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Nega idoinai unu mo heto, ori ese e ḡovaia ahu dina ai bona lahi hanuaboi ai. ");
INSERT INTO meu_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Bena ori ese kalaga e daetania negadia ai, Israel taudia na e tore isi, edia laolao ela; a ori e diho henia gabuna ai, Israel taudia na unuseni ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Iehova ena haheḡani dainai Israel taudia na e tore isi, bona Iehova ena haheḡani dainai idia na e taruha ori ese dubu e ḡovaia ahuva negana lalonai, idia na taruha ai e nohova. ");
INSERT INTO meu_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ena be ori ese dina hoho dubu e ḡovaia ahu, to Israel taudia ese Iehova ena haheḡani e laloa tao, bena asie tore isi. ");
INSERT INTO meu_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Nega haida ori ese dina dia hoho dubu e ḡovaia ahu; bena Iehova ena haheḡani heḡereḡerena taruha ai e nohova, ma Iehova ena haheḡani heḡereḡerena e tore isi. ");
INSERT INTO meu_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ma nega haida ori na adorahi ai e diho, e mia rani; daba ai ma e dae, bena idia na e tore isi. Eiava dina ta hanuaboi ta e miava, bena e daetanidia negana ai idia na e tore isi. ");
INSERT INTO meu_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","ori ese dubu e ḡovaia ahu negana bema dina rua, eiava hua ta, eiava nega daudau, to Israel taudia taruha ai e nohova, asie tore isi; a e daetanidia negana ai idia na e tore isi. ");
INSERT INTO meu_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Iehova ena haheḡani dainai e taruha, ma Iehova ena haheḡani dainai e tore isi; idia ese Iehova ena haheḡani e badinaia, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Iehova ese Mose e haḡania, eto, ");
INSERT INTO meu_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Kibi rua ba kara, silver amo ba korodia. Reḡedia na taunimanima ihaboudia bona taruha ikokina toadia ai baela. ");
INSERT INTO meu_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Kibi ruaosi bae hiriri negadia ai, taunimanima iboudiai na dekemu ai bae hebou, hebou kalagana iduarana ai. ");
INSERT INTO meu_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","A tamona bae hiriria negadia ai, bese lohiadia, Israel iduhudia ikwaradia, na dekemu ai bae hebou. ");
INSERT INTO meu_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Kibi bae hiriri lalo-dika negana ai, mairiveina kahana taruhana bae kokia, bae huaia lao. ");
INSERT INTO meu_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Nega iharuana ma bae hiriri lalo-dika negana ai, diho kahana taruhana bae kokia, bae huaia lao. Hari kibi reḡedia be edia tore-isitoana. ");
INSERT INTO meu_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","A taunimanima ihaboudia ba ura negadia ai, kibi na bae hiriri, to basie hiriri lalo-dika. ");
INSERT INTO meu_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Hahelaḡa taudia, Aaron garana, ese kibi bae hiriri: emui kibi taravatuna bunai, ela bona uru iboudiai. ");
INSERT INTO meu_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Inaimui ese bema hadikamui emui tano ai, bena boma tuari henidia, una negana ai kibi boma hiriri lalo-dika; bena Iehova emui Dirava ese baine lalomui, bona inaimui imadia amo baine hamaurimui. ");
INSERT INTO meu_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Emui moale dinadia ai danu, bona emui aria dinadia ai, eiava hua matamata negadia ai, emui ḡole-oho bouboudia bona emui herohemaino bouboudia ba hahelaḡadiamai kibi ihiriridia ida; unu amo emui Dirava ese baine lalomui tao. Lau binai Iehova, emui Dirava. ");
INSERT INTO meu_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Laḡani iharuana ai, hua iharuana dinana iharuahuina ai, ori ese taravatu mauana dubuna e daetania. ");
INSERT INTO meu_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Israel taudia ese Sinai tano ḡaḡaena e rakatania, eha laolao, ela bona ori na Paran tano ḡaḡaena ai e diho. ");
INSERT INTO meu_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Edia laolao gini-gunana binai, Iehova ese Mose e haḡanilaia dalana amo e laolaova. ");
INSERT INTO meu_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Guna Iuda taruhana taudia edia orea ta ta amo edia pepe murina amo e raka; edia orea e gunalaidia tauna na Nason Aminadab. ");
INSERT INTO meu_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Isakara taudia edia orea igunalaidia tauna na Netanele Suara. ");
INSERT INTO meu_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Sebulun taudia edia orea igunalaidia tauna na Eliab Helon. ");
INSERT INTO meu_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Bena dubu e kokia, Gereson natuna bona Merari natuna ese e huaia lao. ");
INSERT INTO meu_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Idia muridiai Ruben taruhana taudia edia orea ta ta amo edia pepe murina amo e raka; edia orea e gunalaidia tauna na Elisuru Sedeuru. ");
INSERT INTO meu_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Simeon taudia edia orea igunalaidia tauna na Selumiele Surisadai. ");
INSERT INTO meu_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gad taudia edia orea igunalaidia tauna na Eliasaf Reuele. ");
INSERT INTO meu_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Bena Kohat taudia ese kohu helaḡadia e hua; idia do asie kau ai dubu be vada e haginia guna. ");
INSERT INTO meu_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Idia muridiai Efraim taruhana taudia edia orea ta ta amo edia pepe murina amo e raka; edia orea e gunalaidia tauna na Elisama Amihud. ");
INSERT INTO meu_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Manase taudia edia orea igunalaidia tauna na Gamaliel Pedasuru. ");
INSERT INTO meu_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Beniamina taudia edia orea igunalaidia tauna na Abidan Gideoni. ");
INSERT INTO meu_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Bena gabe oreadia e tore isi. Dan taruhana taudia edia orea ta ta amo edia pepe murina amo e raka; edia orea e gunalaidia tauna na Ahiesere Amisadai. ");
INSERT INTO meu_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Asere taruhana taudia edia orea igunalaidia tauna na Pagiele Okran. ");
INSERT INTO meu_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Napatali taruhana taudia edia orea igunalaidia tauna na Ahira Enan. ");
INSERT INTO meu_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Israel taudia e tore isi negana ai edia laolao dalana be unuheto, orea ta ta amo e raka. ");
INSERT INTO meu_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mose ese ihana Hobab Reuele, tau Midian, e hereva henia, eto, Ai na baia laolaomu, Iehova ese vada e hamaoromai baine henimai e tomu tanona baia lao henia. Taunabunai ba bamomai, bena namo ba davaria; badina be Iehova ese ḡau namodia vada e abi heḡeḡae, Israel taumai emai. ");
INSERT INTO meu_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","A ia e haere, eto, Lau na basina bamomui, egu tano korikori baina lou henia, varavaragu dekedia bainala. ");
INSERT INTO meu_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Mose ma eto, Basio rakatanimai; badina be oi dibamu ai na tano ḡaḡaena ai baia taruha, bena oi na ai matamai ai baola. ");
INSERT INTO meu_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ba bamomai, bena Iehova ena herahia ḡaudia amo oi ahumu do baia henimu. ");
INSERT INTO meu_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Taunabunai, idia na Iehova ena ororo amo e laolao matama, dina toi eha laolao, Iehova ena taravatu mauana danu dina toiosi ai idia vairadiai e huaia lao, edia laḡa-ani gabuna e tahua. ");
INSERT INTO meu_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Dina ai, Iehova ena ori esee hahekerukerudia, edia taruha e toretania negadia iboudiai. ");
INSERT INTO meu_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Maua helaḡana e huaia lao negadia ai, Mose eto, Iehova e, a tore isi, inaimu ba hakarohodia; e inai henimumu taudia na oi vairamu ai bae heau. ");
INSERT INTO meu_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Bona e atoa diho negadia ai ma eto, Iehova e, Israel taudia gerebu gerebu ba lou henidia. ");
INSERT INTO meu_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Israel taudia na e maumau, hereva dikadia e gwaurai Iehova vairanai. Iehova na e kamonai, bena e badu, lahi na latadiai e hadihoa; una Iahi ese taruha isena e araia. ");
INSERT INTO meu_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Bena Israel taudia ese Mose e tai henia, bena Mose ese Iehova e noia; bena lahi na e bodo. ");
INSERT INTO meu_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Taunabunai una gabu ladana e hatoa Tabera, badina be Iehova ena lahi na bogaragidiai e arava. ");
INSERT INTO meu_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Bena orea idau-idau taudia Aigupto tanona amo Israel taudia idae raka lasi hebou taudia, na e gado dikadika, bona Israel taudia ma e taitai lou, eto, vamu be ede amo baita abia? ");
INSERT INTO meu_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Aigupto ai gwarume ta ani asi davadia ani? Bona kiukamba bona melon bona liki bona onion bona galik na momo herea ani? ");
INSERT INTO meu_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","A harihari emai goada vada eme ore; ḡau ta Iasi, ina mana mo e heitamu. ");
INSERT INTO meu_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Hari mana be nadinadi kurokurona na heto; ita-itana na bedolak nadina na heto. ");
INSERT INTO meu_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Taunimanima ese e hagogo; bena huro nadidia amo e idi patapata, eiava gwada-gwada auna lalonai e gwadaia; bena uro ai e nadua, manemane e kara, mamidia na flaoa dehoro ida e bulo dikeadia mamidia na heheto. ");
INSERT INTO meu_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Hanuaboi ai hunu taruha ai e dihova negana ai, hari mana danu e dihova. ");
INSERT INTO meu_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Israel iduhudia iboudiai e taitai, ta ta ena kalaga iduarana ena kalaga iduarana ai; bena Mose ese edia taitai e kamonai. Iehova na e badu laloḡaraḡara; Mose danu e badu. ");
INSERT INTO meu_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Bena Mose ese Iehova e hereva henia, eto, Dahaka dainai emu hesiai tauna ini vada o hadikagu toma? Edeheto oi na so lalo namo henigumu? Edeheto ina bese idoinai ireḡuna na lauegu maduna ai vada o halaoa? ");
INSERT INTO meu_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ini taunimanima loḡora na lau natugu a? Lau ese na havaradia dainai oi na o tomu “lmamu ai a rosidia, rata e inuamu merona na heto, ela bona senedia na gwau henilaidia hamata tanona ai” a? ");
INSERT INTO meu_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Vamu na edeseni ai baina abia, ini taunimanima loḡora iubulaidia? Badina be idia na lau vairagu ai e taimu, e tomu “Vamu a henimai, baia ania”. ");
INSERT INTO meu_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Lau na sibogu ini taunimanima loḡora ireḡudia asiname heḡereḡere; maduna na metau herea, ihuana na asi goadagu. ");
INSERT INTO meu_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Emu ura egu ai bema unuheto, namona be boma bogagu hisi, ina harihari boma alagu mase, bena egu hemarai na basie hedinarai. ");
INSERT INTO meu_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Bena Iehova ese Mose e haḡania, eto, Israel tau-badadia hitu-ahui bavabidia hidi, oi dibamu tau-badadia korikori bona mai siahudia taudia; bena ba haboudia hebou kalagana vairanai, oi ida bae gini. ");
INSERT INTO meu_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Bena lau baina diho, baina hereva henimui unuseni ai; bona oi vada na henimu siahuna kahana baina abia lou, idia baina henidia; ini taunimanima ireḡudia madunana na oi ida ba huaia hebou, sibomu basio huaia. ");
INSERT INTO meu_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Taunimanima danu ba hamaorodia, baoto: Sibomui ba hahelaḡa ela bona kerukeru, bena vamu bavania; badina be Iehova o tai henia, oto “Daika ese amai vamu baine henimai? Aigupto ai bogamai e kunuva”. Taunabunai, Iehova ese vamu baine henimui, bavania. ");
INSERT INTO meu_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Dia dina tamona eiava rua bona eiava ima eiava gwauta eiava ruahui, ");
INSERT INTO meu_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","a hua ena dina iboudiai vamu bavania, ela bona ianina ai ba hesiku, bena ba dadaraia. Badina be Iehova, bogaragimui ai e nohomu Diravana, vada o dadaraia, ia vairanai o tai, oto “Dahaka dainai Aigupto a rakatania?” ");
INSERT INTO meu_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","A Mose eto, Be, egu bese taudia iboudiai be domaga tauratoi aedia amo e rakamu: taudia; a oi na o tomu “Vamu baina henidia, bae ania, ela bona hua ta baine ore”. ");
INSERT INTO meu_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Mamoe seridia bona nani seridia bae aladia ore, adia vamu, a? Eiava davara gwarumedia iboudiai bae abidia ore, idia bogadia ihakunudia a? ");
INSERT INTO meu_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Iehova ese Mose e haere henia, eto, Iehova imana e tunamu a? Do ba itaia, lauegu hereva baine momokani eiava lasi. ");
INSERT INTO meu_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Taunabunai Mose e raka lasi, Iehova ena hereva na Israel taudia e hamaorolaidia, a Bena tau badadia hitu-ahui e abidia hidi, hebou kalagana murimurinai e haginidia heḡeḡe. ");
INSERT INTO meu_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Bena Iehova na ori ai e diho, e hereva henia, a bona e henia siahuna kahana na hari hitu-ahuiosi e henidia; bena hari siahu idia latadiai e kau negana ai idia na e peroveta, to una negana ai mo. ");
INSERT INTO meu_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Tatau rarua taruha ai e nohova, ta ladana na Eledad, ma ta ladana na Medad; bena siahu na idia danu latadiai e kau. Idia be e abidia hidi taudia rarua, a hebou kalagana asiela, bena taruha lalonai e peroveta. ");
INSERT INTO meu_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Bena eregabe tauna ta ese Mose dekena e heau lao, eto, Eledad bona Medad be taruha ai e perovetamu. ");
INSERT INTO meu_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Bena Iosua Nunu, Mose ena hesiai tauna bona ena abi-hidi tauna ta, e hereva, eto, Mose Rahobada e, ba gwaudia tao. ");
INSERT INTO meu_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","A Mose ese e haere henia, eto, Lau daigu ai o vaḡeḡemu a? Iehova ena orea taudia iboudiai bema peroveta bona Iehova ena siahu be iboudiai latadiai bema kau bema namo. ");
INSERT INTO meu_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Bena Mose, Israel tau-badadia ida, taruha e lou henia. ");
INSERT INTO meu_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Una negana ai Iehova ese lai ta e siaia; bena una lai ese kibi momo davara kahana e harohodia diho edia taruha tanona ai, ela bona dina ta laolaona heḡereḡerena taruha kahana ai, bona ma kahana ai danu dina ta laolaona heḡereḡerena, tano daenai kiubit rua heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Bena taruha taudia e tore isi, kibi na e haboudia boi, e haboudia rani, ma dina iharuana ai e haboudia boi; e habou maraḡi tauna ese homere gwauta e haboudia. Bena edia kalaga badibadidiai e hakaukaudia. ");
INSERT INTO meu_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","A vamu na dounu ududia ai, do asie hadonoa, Iehova ena badu na ediai e siahu; bena ia ese dai-hanai gorerena dikana ta idia latadiai e siaia. ");
INSERT INTO meu_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Taunabunai, una gabu ladana e hatoa Kibroto-hatava; badina be unuseni ai gado esee abidia taudia na e guridia. ");
INSERT INTO meu_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kibroto-hatava amo eha laolao, ela bona Haseroto ai e kau; unuseni ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Aaron bona Miriama ese Mose e maumauraia, ia adavana hane Kusu dainai, badina be ia ese Kusu hahinena vada e adavaia. ");
INSERT INTO meu_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Idia eto, Iehova na Mose mo sibona uduna amo vada e hereva a? Eiava ai danu udumai amo vada e hereva? Iehova ese edia hereva e kamonai. ");
INSERT INTO meu_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Hari Mose na tanobada taudia iboudiai bogaragidiai ia mo sibona manau herea. ");
INSERT INTO meu_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","A Iehova ese Mose bona Aaron bona Miriama e hereva henidia taku, eto, Umui tatoiosi a raka lasi, hebou kalagana baoma. Bena tatoiosi ela. ");
INSERT INTO meu_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Bena Iehova na ori dubuna ai e diho, hebou kalagana vairanai e gini, Aaron bona Miriama e boiridia, bena raruosi e raka henia kahi. ");
INSERT INTO meu_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Ia eto, Egu hereva a kamonai: daika umui bogaragimui ai be peroveta tauna, lau ese mata-hanai ai baina hahedinarai henia bona nihi ai baina hereva henia. ");
INSERT INTO meu_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","A egu hesiai tauna Mose na dia unuheto; ia na egu bese ireḡuna tauna. ");
INSERT INTO meu_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ia ida baia hereva-hereva hedinarai, lau udugu amo, ia uduna amo; basia hereva hehuni. Iehova oromana danu ia ese matana amo baine itaia. Edeheto umui raruosi na egu hesiai tauna Mose imaumauraina asio garimu? ");
INSERT INTO meu_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Iehova ena badu e siahu ḡaraḡara unu raruosi ediai, bena ia ese e rakatanidia. ");
INSERT INTO meu_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ori ese hebou kalagana e daetania negana ai, Miriama vada e lepra, kopina vada e kuroka-kuroka, snow na heto. Aaron ese Miriamae haḡerea, e itaia vada e lepra. ");
INSERT INTO meu_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Bena Aaron ese Mose e hereva henia eto, Ḡauka e, ai vada a kara kava, vada a kara dika; mani emu kara emai dika davana basio henimai, ");
INSERT INTO meu_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ina hahine na basine noho mase hahinena na heto, eiava sinana bogana amo e vara mai dikana kekenina na heto. ");
INSERT INTO meu_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Bena Mose ese Iehova e noia, eto, Dirava e, lau na noimumu, ba hamauria. ");
INSERT INTO meu_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","A Iehova ese Mose e haere henia, eto, Tamana ese vairana bema kanudia, ia na mai hemaraina ida bema noho ela dina hitu bema ore, ani? Benaini, ia be dina hitu taruha murimurinai baine noho, bena ma bae hakaua vareai. ");
INSERT INTO meu_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Taunabunai, Miriama na taruha murimurinai e nohova ela bona dina hitu e ore; bona Israel taudia na edia laolao asie matamaia lou ela bona Miriama na taruha lalonai ma e hakaua vareai. ");
INSERT INTO meu_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Una murinai idia ese Haseroto e toretania, ela, Paran tano-ḡaḡaena ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Hasinadoa taudia haida ba siaidia, Kanaan tanona, lau ese Israel taudia baina henidia tanona, baela. Iduhu ta ta amo ta ta ba siaidia, a lohia taudia mo bavabidia. ");
INSERT INTO meu_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Bena Mose ese Paran tano-ḡaḡaena amo e siaidia, Iehova ena hahedua heḡereḡerena; iboudiai na Israel lohiadia. ");
INSERT INTO meu_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ladadia bini: Ruben iduhuna amo, Samua Sakuru; ");
INSERT INTO meu_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simeon iduhuna amo, Safata Hori; ");
INSERT INTO meu_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Iuda iduhuna amo, Kaleb lefune; ");
INSERT INTO meu_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Isakara iduhuna amo, Igala Iosef; ");
INSERT INTO meu_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efraim iduhuna amo, Hosea Nunu; ");
INSERT INTO meu_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Beniamina iduhuna amo, Palti Rafu; ");
INSERT INTO meu_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Sebulun iduhuna amo, Gadiel Sodi; ");
INSERT INTO meu_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Manase Iosef iduhuna amo, Gadi Susi; ");
INSERT INTO meu_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dan iduhuna amo, Amiele Gemali; ");
INSERT INTO meu_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Asere iduhuna amo, Seturu Mikael; ");
INSERT INTO meu_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Napatali iduhuna amo, Nabi Vopsi; ");
INSERT INTO meu_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gad iduhuna amo, Gevele Maki. ");
INSERT INTO meu_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Hasinadoa taudia Mose ese e siaidia, Kanaan baela, ladadia bunu. A Mose ese Hosea Nunu ladana e nemaia Iosua. ");
INSERT INTO meu_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Taunabinai, Mose ese e siaidia, Kanaan tanona bae ha itaia. E haḡanidia, eto, Diho kahana amo baola ela bona ororo gabudia. ");
INSERT INTO meu_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ba itaia, tano be edeheto, bona tano taudia be edeheto, gogoada eiava mamanoka, hutuma eiava gagadoi; ");
INSERT INTO meu_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ba itaia danu, e noholaiamu tanona edeheto, namo eiava dika, bona edia hanua be edeheto, taruha mo eiava hanua mai maḡudia. ");
INSERT INTO meu_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Ba itaia danu, edia biru gabudia be edeheto, namo eiava dika, bona au be mimia eiava. Ba goada: tano anidia taidia ba loulai. Una negana be vine e huahua matama negana. ");
INSERT INTO meu_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Taunabunai idia na ela, e hasinadoa, Sin tano-ḡaḡaena amo ela bona Rehob, Hamat dalana ai. ");
INSERT INTO meu_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Diho kahana amo ela, Heberon ai e kau; unuseni ai Ahiman bona Sesai bona Talmai, Anak garana, e nohova. Una Heberon e haginia murinai laḡani hitu vada ela bena Soan e haginia Aigupto ai. ");
INSERT INTO meu_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Bena Eskol kourana ai e kau, unuseni ai vine rigina ta e utua, mai vine huahuana tako ta; tatau rarua ese au ai e huaia. Rimono(, huahuadia haida bona suke huahuadia haida danu e gogo, e hua. ");
INSERT INTO meu_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Una gabu ladana e hatoa Eskol kourana, badina be Israel taudia ese vine takona unuseni ai e utua dainai. ");
INSERT INTO meu_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Dina hari-ahui e ore, bena edia hasinadoa amo e lou ema, ");
INSERT INTO meu_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Mose bona Aaron bona Israel oreana taudia iboudiai dekediai e kau, Kade ai, Paran tano-ḡaḡaena ai. Bena tano sivaraina e hamaorolaidia, bona tanoanidia e haheitalaidia. ");
INSERT INTO meu_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Idia eto, O siaimai baia lao henia tanona ala, ia na rata bona bada-ranuna e arumu tanona; tano huahuadia haida bini. ");
INSERT INTO meu_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","To, una tano taudia na gogoada, edia hanua danu babada heherea bona mai maḡudia; Anak garana danu a itadia unuseni ai. ");
INSERT INTO meu_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Diho kahana ai Amalek taudia e nohomu; ororo gabudia ai Hiti taudia bona Iebusu taudia bona Amoro taudia e nohomu; a kone ai bona Ioridane sinavaina isena ai Kanaan taudia na e nohomu. ");
INSERT INTO meu_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Bena Kaleb ese taunimanima e tuidia; bena ia ese Mose e hereva henia, eto, Aitala, una tano baita abia; badina be ita na mai goadada, baita abia diba. ");
INSERT INTO meu_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","A ia ida ela taudia eto, Una tano taudia basita tuari henidia diba, badina be idia na gogoada, ita na mamanoka. ");
INSERT INTO meu_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Taunabunai, idia ese edia hasinadoa Israel taudia e hamaorolaidia na hari dikana mo e gwauraia, eto; Una itana totona ala tanona na taunimanima ihamasedia tanona, bona unuseni ai a itadia taudia iboudiai na babada heherea. ");
INSERT INTO meu_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Unuseni ai taunimanima gaḡau-babadadia a itadia, Anak garana, Nefili taudia amo evara besena. Ai na a laloa ai na kwadi na heheto, idia vairadiai, bona idia danu unu e itamai toma. ");
INSERT INTO meu_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Bena hebou taudia iboudiai e tai: Israel idoinai e tai rani. ");
INSERT INTO meu_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Israel taudia iboudiai ese Mose bona Aaron e maumauraidia; hebou idoinai ese e gwau henidia, eto, Aigupto ai baiama mase eiava ina tano ḡaḡaena ai baiama mase bema namo. ");
INSERT INTO meu_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Namona be dahaka Iehova ese una tano ai baine hakaumai vareai? Unuseni ai ai na dare amo bae alamai mase, bona adavamai, bona, natumai bae abidia mauri. Aigupto baia lou henia hari namo, ani? ");
INSERT INTO meu_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Bena sibodia e hereva heheni, eto, Biaguda ta baita abia hidi, Aigupto baita lou lao. ");
INSERT INTO meu_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Bena Mose bona Aaron na Israel taudia loḡora edia hebou vairanai e goru diho; ");
INSERT INTO meu_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","bona Iosua Nunu bona Kaleb lefune, hasinadoa taudia rarua, na edia dabua e dare, ");
INSERT INTO meu_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Israel oreana idoinai e hamaorodia, eto, Una tano, ai ala a hasinadoa tanona, na tano namo-hereana. ");
INSERT INTO meu_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Iehova ese baine lalo namo henida, ia ese una tano ai baine hakauda vareai, baine henida; oibe, hari rata bona bada-ranuna e arumu tanona ia ese baine henida. ");
INSERT INTO meu_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ḡau tamona, Iehova basio inai henia, bona una tano taudia garidia basio gari. Idia na ita ada aniani na heto. Idia na asi igimadia; a Iehova na ita ida. Basio gari henidia. ");
INSERT INTO meu_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","A hebou taudia iboudiai ese nadi amo bae hododia eto. Bena Iehova diaridiarina na hebou kalagana ai e hedinarai, Israel taudia iboudiai vairadiai. ");
INSERT INTO meu_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Bena Iehova ese Mose e hereva henia, eto, Ini taunimanirna na bae dadaraigu ela bona edena nega ai? Toa iboudiai vada na henidia ore. Edena nega ai bae abidadama henigu? ");
INSERT INTO meu_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Lau na dai-hanai gorerena amo baina habuadiatari. Idia na lau dihigu ai basiela. Oiemu amo bese ta, idia baine hereadia besena, baina havaraia. ");
INSERT INTO meu_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Bena Mose, ese Iehova e haere henia, eto, Unu baine heto, Aigupto taudia na bae kamonai; badina be oi ese ina bese taudia na idia bogaragidia amo e hakaudia lasi mai siahumu ida. ");
INSERT INTO meu_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Bena idia ese ina tano taudia bae hamaorodia. Ina tano taudia na vada e kamonai oi na ina bese bogaraginai o nohomu, idia ida o hevaira hehenimu, oiemu ori amo o gorudia taomu, bona edia laolao ai o gunalaidiamu, dina ai ori dubuna amo bona hanuaboi ai lahi mamana amo. ");
INSERT INTO meu_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","A harihari oi ese ina bese taudia boma habuadia ore, hari oi harimu e kamonai besedia na baeto ");
INSERT INTO meu_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","“Iehova na asi siahuna ina bese na e gwaurai henidia hamata tanona ai baine hakaudia vareai; una dainai ia ese .tano ḡaḡaena ai vada e habuadia ore”. ");
INSERT INTO meu_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Taunabunai, lau I na noimumu, Ḡaubada ena siahu do baine herea, emu gwau-hamata heḡeregerena, oto: ");
INSERT INTO meu_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Iehova ena badu e halahemu, ena hebogahisi e hesiriumu; ia ese kara dika bona kara havara e gwau taomu; ḡau tamona, kara dika taudia na basine kahudia nege, a tama edia kara dika davadia na natudia bona tubudia baine henidia, ela bona uru ihatoina bona ihahanina. ");
INSERT INTO meu_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Lau na noimumu, emu hebogahisi na bada herea dainai ina bese taudia edia kara dika do ba gwau tao, Aigupto amo ema bona ina gabu ai edia kara dika vada o gwau tao heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Bena.Iehova eto, Baina bogadia hisi, emu noinoi heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","A momokani, lau na maurimu heḡereḡerena bona Iehova hairaina ese tanobada baine hahonua heḡereḡerena, ");
INSERT INTO meu_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ini taunirnanima iboudiai ese lau hairaigu vada, e itaia, bona toa idau-idau Aigupto ai bona tano gaḡaena ai vada eitadia, to nega, gwauta vada e dibaḡanigu bona eregu asie kamonai dainai, ");
INSERT INTO meu_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","idia ese senedia na gwaurai henidia hamata tanona na basie itaia; momokani, vada e dadaraigu taudia ta ese basine itaia. ");
INSERT INTO meu_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","A egu hesiai tauna Kaleb, laumana na idau bona eme badinagu mai lalona idoinai dainai, ia be baina hakaua vareai, hari itana ela tanona lalonai; bena ia garana ese bae abia, edia tano. ");
INSERT INTO meu_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","A harihari, Amalek, taudia bona Kanaan taudia na koura ai e nohomu dainai umui be kerukeru ba lou, tano ḡaḡaena baola, Davara Kakakakana kahana ai. ");
INSERT INTO meu_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Bena Iehova ese Mose bona Aaron e hereva henidia, eto, ");
INSERT INTO meu_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Ina orea dikana ese lau bae maumauraigu ela bona edena nega ai? Israel taudia edia hereva, lau e maumauraigumu herevadia, vada na kamonai. ");
INSERT INTO meu_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ba hamaorodia, baoto: Iehova na e tomu “Lau na maurimu dainai, emui hereva lau vada na kamonai heḡereḡeredia unu baina karamui toma; ");
INSERT INTO meu_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ina tano ḡaḡaena ai vada ba mase. Umui iboumui bogaragimui ai, laḡani ruahui vada e hanai bona vada e maumauraigu taudia. ");
INSERT INTO meu_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ta na lau ese na gwaurai henimui hamata ba noholaia nato tanona na basine raka vareai, a Kaleb lefune bona Iosua Nunu, idia raruosi mo baeiraka vareai. ");
INSERT INTO meu_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","A natumui maragidia, umui o tomu bae abidia mauri, na lau ese baina hakaudia vareai, umui ese vada o dadaraia tanona na idia ese bae itaia. ");
INSERT INTO meu_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","A umui be ina tano ḡagaena ai do ba mase. ");
INSERT INTO meu_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Natumui ese laḡani hari-ahui tano ḡaḡaena aiedia mamoe bae reḡudia, emui kara havara hisidia bae ani, ela bona umui tau-animui bae pata vaitani tano ḡaḡaena ai. ");
INSERT INTO meu_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","O hasinadoa dinadia hari-ahui ihaheḡereḡeredia, laḡani hari-ahui emui kara havara hisidia bavani, dina ta ta, davadia laḡani ta ta hisidia bavani. ");
INSERT INTO meu_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Lau Iehova vada na hereva: momokani, ina orea dikana, lau e inai henigumu oreana, na unu baina karadia toma. Ina tano ḡaḡaena ai taudia bae manori, bona ina tano ḡaḡaena ai bae mase.” ");
INSERT INTO meu_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Hari hasinadoa taudia, Mose ese tano itana e siaidia, bena e lou negana ai tano harina dikana amo hebou taudia iboudiai e haherou-heroudia bena Mose e maumauraia, ");
INSERT INTO meu_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","taudia bunu, tano harina dika e gwauraia taudia, na dai-hanai gorerena ta ese e hamasedia ore, Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","A Iosua Nunu bona Kaleb lefune na e mauri, hasinadoa taudia iboudiai idia raruosi mo e mauri. ");
INSERT INTO meu_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mose ese ini hereva na Israel taudia e hamaorolaidia negana ai, idia na lalodia e hisihisi bada. ");
INSERT INTO meu_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Daba maraḡi ai, idia na e tore isi, ororo dorina ela, eto, Ame itamai, ai na iniseni ai, Iehova ese vada e gwaurai henimai hamata tanona hari aiala; badina be ai na vada a kara havara. ");
INSERT INTO meu_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","A Mose eto, Dahaka dainai Iehova ena haheḡani harihari o tataia utumu? Basio kwalimu diba. ");
INSERT INTO meu_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Basiola, inaimui ese bae hadareremui na garina; badina be Iehova ese se barnomuimu. ");
INSERT INTO meu_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amalek taudia bona Kanaan taudia na vairamui ai; bena edia dare ai ba mase; Iehova ena dala vada o rakatania dainai Iehova ese basine bamomui. ");
INSERT INTO meu_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","A edia hekokoroku ai e raka lao, ororo dorina arno ela; ḡau tamona, Iehova ena taravatu mauana na taruha ai mia, Mose danu taruha ai noho. ");
INSERT INTO meu_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Bena Arnalek taudia bona Kanaan taudia, unu ororo ai e nohova taudia, na ema, e hadareredia, e havadia lao, ela bona Horoma. ");
INSERT INTO meu_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Israel taudia ba hereva henidia, baoto: Baina henimui ba noholaia tanona ai ba kau, ");
INSERT INTO meu_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","bena boromakau ta eiava mamoe ta ba hahelaḡaia Iehova ena, ḡole-oho boubouna eiava gwau-hamata boubouna eiava lalo-namo boubouna eiava aria ta boubouna, bonana namo ḡauna Iehova ena; ");
INSERT INTO meu_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","una negana ai boubou baine heni tauna ese flaoa namo-hereana efa ta baine karoaia, karoa gwauta, karoa ta baine abia, bona dehoro hini ta baine karoaia, karoa hani, karoa ta baine abia; bena flaoa bona dehoro baine bulodia. ");
INSERT INTO meu_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Inuinu boubouna danu bavabia: vine ranuna hini ta ba karoaia, karoa hani, bena karoa ta ba heni; ḡole-oho ḡauna eiava gwau-hamata ḡauna eiava lalo-namo ḡauna ida. ");
INSERT INTO meu_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Eiava mamoe maruanena ta ba hahelaḡaia, flaoa namo-hereana efa ta ba karoaia, karoagwauta, bena karoa rua bavabi, bona dehoro hini ta ba karoaia, karoa toi, bena karoa ta bavabia; bena flaoa bona dehoro ba bulodia. ");
INSERT INTO meu_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Inuinu boubouna danu ba heni; vine ranuna hini ta ba karoaia, karoa toi, bena karoa ta bavabia, bonana namo ḡauna Iehova ena. ");
INSERT INTO meu_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Eiava boromakau maruanena ta bavabia heḡaeḡae, emu ḡole-oho boubouna eiava emu lalo-namo boubouna eiava emu gwau-hamata boubouna eiava emu herohemaino boubouna ai bahalaoa, Iehova ena; ");
INSERT INTO meu_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","boromakau maruanena ida baine heni ḡaudia bini: flaoa namo-hereana efa ta baine karoaia, karoa gwauta, bena karoa toi baineabi, bona dehoro hini ta baine karoaia, karoa rua, bena karoa ta baine abia; bena flaoa bona dehoro baine bulodia. ");
INSERT INTO meu_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Inuinu boubouna danu ba heni: vine ranuna hini ta ba karoaia, karoa rua, bena karoa ta bavabia, lahi boubouna ai ba halaoa, bonana namo ḡauna Iehova ena. ");
INSERT INTO meu_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Boromakau mamaruanedia ta ta ida, bona mamoe mamaruanedia ta ta ida, bona mamoe natudia mamaruanedia ta ta ida, bona nani natudia ta ta ida, unu ba heni toma. ");
INSERT INTO meu_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Mauri ḡaudia hida bavabidia heḡeḡae, unuhohodia mo unu ba heni toma. ");
INSERT INTO meu_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Israel taudia korikori na una dala amo bae ḡaukara, edia boubou ḡaudia lahi ai bae ato kau negadia ai; unu hetomana bonana namo ḡaudia ai baela, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Bona idau bese tauna eiava bogaragimui ai e noho hedoamu tauna, emui uru iboudiai lalodiai, baine ura bonana namo ḡauna lahi ai baine gabua Iehova ena, ia ese umui o karaiamu heḡereḡerena ma baine karaia. ");
INSERT INTO meu_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Emui hebou ai taravatu baine tamona, umui emui, bona idau tauna bogaragimui ai e noho hedoamu ena; taravatu tamona, baine mia hanaihanai taravatuna, emui uru iboudiai lalodiai. Umui bona noho-hedoa tauna na heḡereḡere, Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Taravatu be tamona bona haheḡani be tamona, umui latamui ai bona bogaragimui ai e noho hedoamu tauna latanai. ");
INSERT INTO meu_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Israel taudia ba hereva henidia, baoto: Baina hakaumui vareai tanona ai ba kau ");
INSERT INTO meu_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","bona una tano anina bavani matama negana ai, emui herahia ḡaudia ba dudui isi Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Emui flaoa matamatana amo ataga ta ba duduia isi, Iehova vairanai, emui uit ikwadina gabuna amo emui herahia ḡauna o duduia isimu heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Uru iboudiai Ialodiai, emui flaoa matamatana amo emui herahia ḡaudia ba dudui isi, Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Boma kerere, ini haheḡani iboudiai, Iehova ese Mose vada e henia ḡaudia, basioma badinadia, ");
INSERT INTO meu_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Iehova ese Mose uduna amo vada e henimui, e heni matama ema bona uru idoidiai lalodiai ma e heni loulou haheḡanidia, ");
INSERT INTO meu_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ibadinadia ai boma kerere, a hebou taudia asi dibadia: hebou idoinai ese boromakau natuna maruanena ta bae heni, ḡole-oho boubouna ai baehalaoa, bonana namo ḡauna Iehova vairanai. Ena flaoa boubouna bona ena inuinu boubouna danu ia ida bae heni, taravatu heḡereḡerena, bona nani maruanena ta danu bae heni, kara-dika iabi-ohona boubouna. ");
INSERT INTO meu_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Bena hahelaḡa tauna ese Israel oreana taudia iboudiai daidiai herohemaino karana baine karaia, unu amo edia dika bae hegwau tao; badina be vada e kerere; to edia boubou na Iehova vada e henia, ḡole-oho boubouna bona kara-dikaiabi-ohona boubouna, edia kerere dainai. ");
INSERT INTO meu_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Bena hebou idoinai, Israel taudia bona bogaragidiai e noho hedoamu taudia na, edia dika bae hegwau tao, badina be iboudiai na una kara dika ese vada e hakereredia. ");
INSERT INTO meu_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Tau ta baine kara rea, ia ese ena kara-rea iabi-ohona boubouna baineheni, nani hahinena ta, laḡani tamona ḡauna. ");
INSERT INTO meu_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Hahelaḡa tauna ese kerere tauna ena kara rea dainai herohemaino karana baine karaia, Iehova vairanai; unu amo ena dika baine hegwau tao. ");
INSERT INTO meu_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Kara rea taravatuna baine tamona, Israel tauna korikori ena bona noho-hedoa tauna ena. ");
INSERT INTO meu_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","A Israel tauna korikori eiava noho-hedoa tauna na hekokoroku dainai baine kerere, ia be Iehova se matauraiamu. Ena bese amo bae negea daure; ");
INSERT INTO meu_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","badina be ia ese Iehova ena hereva vada e dadaraia bona ena taravatu vada e tataia utu, una dainai ia na bae negea daure. Ena kara dika na basine hegwau tao. ");
INSERT INTO meu_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Israel taudia na tano ḡaḡaena ai e nohova ai, idia ese tau ta e itaia, dina helaḡa ai au rakuraku e gogodia. ");
INSERT INTO meu_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Bena au rakuraku igogodia ai e davaria taudia ese e hakaua lao, Mose bona Aaron bona hebou taudia iboudiai vairadiai. ");
INSERT INTO meu_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Bena idia ese e ḡuia, badina be lalodia asie parara ede.bae karaia toma. ");
INSERT INTO meu_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Bena Iehova ese Mose e haduaia, eto, Aine mase; hebou taudia iboudiai ese bae hodoa mase, taruha murimurinai. ");
INSERT INTO meu_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Taunabunai hebou taudia iboudiai ese e hakaua lao, taruha murimurinai, bena idia ese nadi amo e hodoa mase, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Iehova ese Mose e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Israel taudia ba hamaorodia, edia uru iboudiai lalodiai edia dabua rimudia bae kara, edia dabua daigunidia ai; bona daiguni ta ta rimudia ai varo vaiurina ta ta bae turi kau. ");
INSERT INTO meu_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Bena emui dabua rimudia ba itadia negadia ai Iehova ena haheḡani ba lalodia tao bona ba badinadia; sibomui lalomui bona matamui edia ura basio badinadia, basio halebulebu, ");
INSERT INTO meu_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","a egu haheḡani iboudiai ba lalodia tao bona ba badinadia, bona ba helaḡa, emui Dirava ena. ");
INSERT INTO meu_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Lau binai Iehova, emui Dirava; Aigupto amo na hakaumui lasi, emui Dirava ai bainala helaoreana. Lau binai Iehova, emui Dirava. ");
INSERT INTO meu_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kora Isahara, Kohat Levi tubuna, bona Datan Eliab, bona Abiram Eliab, bona Onu Pelete, Ruben iduhuna tauna, hahaniosi e heḡaeḡae; ");
INSERT INTO meu_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","bena e tore isi, Mose dekena ela, idia bona orea lohiadia sinahu-rua imahui, hebou ese e abidia hidi taudia, iboudiai na mai haridia taudia. ");
INSERT INTO meu_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Idia na Mose bona Aaron vairadiai e hebou, e heai henidia, eto, Umui raruosi na o hekokorokumu; badina be hebou taudia iboudiai na hehelaḡa; oibe, ibouboudiai, bona Iehova na bogaragidiai e nohomu. Dahaka dainai umui raruosi ese Iehova ena orea taudia o lohiadiamu? ");
INSERT INTO meu_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Mose ese una hereva e kamonai, bena ia na tano ai e goru diho. ");
INSERT INTO meu_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Bena ia ese Kora mai ena orea taudia ida e hamaorodia, eto, Daba ai Iehova ese baine hahedinaraia, daika be iena, bona daika na helaḡa, bona daika na ienai baine kahi lao; bena baine abia hidi tauna ese baine raka henia kahi. ");
INSERT INTO meu_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ini ba kara toma: oi Kora, bona emu orea taudia iboudiai, na gida keberedia helaḡadia bavabi; ");
INSERT INTO meu_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","bena kerukeru gida ba uda, bona muramura mai bonadia na gida latadiai bavato kau, Iehova vairanai; bena Iehova ese baine abia hidi tauna na baine helaḡa. Levi taumui, umui hari o hekokorokumu. ");
INSERT INTO meu_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mose ese Kora ma e hereva henia, eto, Umui Levi taumui ese egu hereva: a kamonai. ");
INSERT INTO meu_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Israel Diravana ese umui vada e abimui hidi Israel oreana taudia bogaragidia amo, ba raka henia kahi, Iehova ena dubu ai ba ḡaukara, bona hebou taudia vairadiai ba gini, iena hesiai taudia. Una na ḡau pipikina a? ");
INSERT INTO meu_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ia ese vada e boirimui, umui bona varavaramui Levi taudia iboudiai, ia ba raka henia kahi. Be, hahelaḡa dagina danu o tahuamu a? a ");
INSERT INTO meu_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Matona, oi bona emu orea taudia iboudiai vada o hebou, Iehova vada o heai henia. Aaron be daika, umui ese ia o maumauraiamu a? ");
INSERT INTO meu_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Bena Mose ese Datan Eliab bona Abiram Eliab e boiridia. A idia eto, Ai na basia vasi. ");
INSERT INTO meu_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Rata bona bada-ranuna e arumu tanona amo vadao hakaumai lasi, tano ḡaḡaena ai baia mase dahaka, harihari emai pavapava ai baola o tomu. Una na ḡau pipikina a? ");
INSERT INTO meu_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ina danu, rata bona badaranuna tanona ta ai asio hakaumai vareai, uma bona vine imeadia asio henimai, ai ahumai. Ini taunimanima na matadia ba hakepuludia a a Ai na basia vasi. ");
INSERT INTO meu_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Mose na e badu dikadika, Iehova e noia, eto, Edia boubou basio abi dae. Lau be edia doniki ta asina dadia, bona idia ta asina hadikaia. ");
INSERT INTO meu_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Bena Mose ese Kora e hamaoroa, eto, Kerukeru emu orea taudia ida baoma, Iehova vairanai ba gini, oi bona emu orea taudia bona Aaron. ");
INSERT INTO meu_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Emui gida keberedia helaḡadia danu bavabi kau, muramura mai bonadia ba uda; ta ta ena kebere ena kebere bae mailaidia Iehova vairanai, kebere helaḡadia sinahu-rua imahui. Oi danu emu ba mailaia. Aaron danu ena baine mailaia. ");
INSERT INTO meu_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Taunabunai, idia na ta ta ena kebere ena kebere e abi, gida e uda, bona muramura mai bonadia gida latadiai; bena hebou kalagana iduarana ai e gini, Mose bona Aaron ida. ");
INSERT INTO meu_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Bena Kora ese orea idoinai e haboudia idia vairadiai, hebou kalagana iduarana ai. Bena Iehova diaridiarina e hedinarai, hebou taudia iboudiai ese e itaia. ");
INSERT INTO meu_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Bena Iehova ese Mose bona Aaron e hamaorodia, eto, ");
INSERT INTO meu_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Ena hebou amo ba raka siri, bena baina habuadia tari. ");
INSERT INTO meu_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Bena idia na tano ai e goru goru :diho, eto, Dirava e, taunimanima iboudiai laumadia Diravana, tau tamona baine kara dika dainai ina hebou idoinai ba badu henidia a? ");
INSERT INTO meu_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Bena Iehova ese Mose ma e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Hebou taudia ba hamaorodia, Kora bona Datan bona Abiram edia kalaga amo bae raka oho. ");
INSERT INTO meu_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Bona Mose e tore isi, Datan bona Abiram dekedia ela; Israel tau-badadia ese e ḡavaia. ");
INSERT INTO meu_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Bena ia ese hebou taudia e hamaorodia, eto, Ene kara havara taudia edia kalaga amo ba raka oho, bona edia ḡau ta basio daua toho, idia edia dika ai ba dika na garina. ");
INSERT INTO meu_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Taunabunai, idia na Kora bona Datan bona Abiram edia kalaga amo e raka siri. Bena Datan bona Abiram e raka lasi, idia bona adavadia bona natudia badadia bona natudia maraḡidia, edia kalaga iduaradia ai e gini. ");
INSERT INTO meu_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Bena Mose eto, Ini amo ba diba, Iehova ese vada e siaigu, ini ḡaukara iboudiai ikaradia totona; dia lau sibogu asina kara. ");
INSERT INTO meu_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ini tatau be taunimanima iboudiai vaevae edia mase dalana ai bema mase, bona taunimanima iboudiai vaevae edia dika dalana ai bema dika, ba diba Iehova ese se siaigu. ");
INSERT INTO meu_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","A Iehova ese kara matamatana ta bema havaraia, tano uduna bema hahaḡaia idia bona edia ḡau iboudiai bema hadonodia, mauridia ai mase taudia edia gabu ai bema diho, vada ba diba idia ese Iehova vada e dadaraia. ");
INSERT INTO meu_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Ena hereva e doko ai, idia henudia tanona e parara; ");
INSERT INTO meu_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","tanobada ese uduna e hahaḡaia bona e hadonodia, mai edia ruma taudia ida, bona Kora ena orea taudia iboudiai mai edia kohu ida. ");
INSERT INTO meu_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Taunabunai, idia mai edia orea idoinai na mauridia ai mase taudia edia gabu ai e diho. Tano ese e habubunidia, hebou taudia bogaragidiai e mase ore. ");
INSERT INTO meu_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Bena Israel taudia, e ginidia heḡeḡe taudia, ese edia tai lolololo e kamonai ai, e heau karoho; eto, Tano ese baine hadonoda na garina. ");
INSERT INTO meu_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Bena lahi na Iehova ena amo e diho, hari tatau sinahu-rua imahuiosi, muramura maibonadia e gabu taudia, e aradia ore. ");
INSERT INTO meu_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Bena Iehova ese Mose ma e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Hahelaḡa tauna Aaron natuna Eleasara ba hamaoroa, Iahi bogaragina amo kebere helaḡadia baine abidia lasi, gidadia baine bubu nege; badina be idia na hehelaḡa. ");
INSERT INTO meu_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Ene kara havara daidiai vada e mase taudia edia gida keberedia na hehelaḡa: ba hododia severa-severa, ihaboulaina patana iḡovana ḡaudia aibaela, badina be Iehova vairanai e hahelaḡadia, taunabunai idia na hehelaḡa. Unu amo idia na toa ai baela, Israel taudia edia. ");
INSERT INTO meu_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Taunabunai, hahelaḡa tauna Eleasara hari auri labora-labora keberedia, lahi ese e aradia taudia edia kebere, e abidia, e hododia severa-severa, ihaboulaina patana iḡovana, ");
INSERT INTO meu_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","bona helalo-tao toana, Israel taudia ese bae laloa tao, idau tauna ta, dia Aaron garana, na Iehova basine raka henia kahi, muramura mai bonana igabuna totona; Kora mai bamona ida heḡereḡeredia ai baela na garina. Iehova ese Eleasara unu e hamaoroa toma, Mose uduna amo. ");
INSERT INTO meu_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Kerukeru, Israel oreana taudia ibouboudiai ese Mose bona Aaron e maumauraidia, eto, Umui ese Iehova ena orea taudia vada o aladia mase. ");
INSERT INTO meu_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ibouboudiai na Mose bona Aaron ialadia totona e hebou; bena e roha lao, hebou kalagana e itaia, ori ese vada e ḡovaia ahu, bona Iehova diaridiarina vada e hedinarai. ");
INSERT INTO meu_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Bena Mose bona Aaron na hebou kalagana iduarana amo e raka lasi. ");
INSERT INTO meu_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Bena Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Ene e heboumu taudia edia amo a raka siri; lau ese aina habuadia tari. Bena raruosi na tano ai e goru diho. ");
INSERT INTO meu_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Bena Mose ese Aaron e hamaoroa, eto, Emu gida keberena bavabia, muramura mai bonadia gida ai bavato kau; ba laohaia haraḡa-haraḡa hebou taudia dekediai, idia daidiai herohemaino karana bakaraia; badina be badu na Iehova ena amo vada e kau, dai-hanai gorerena vada e vara. ");
INSERT INTO meu_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Bena Aaron ese kebere e abia, Mose ena hereva heḡereḡerena, bena e heau lao hebou taudia bogaragidiai. Dai-hanai gorerena na vadae vara matama, taunimanima ediai. Bena ia ese muramura mai bonadia na gida ai e ato kau, hebou taudia daidiai herohemaino karana e karaia. ");
INSERT INTO meu_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Ia ese mase taudia bona mauri taudia padadiai e gini; bena gorere vada e doko. ");
INSERT INTO meu_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Gorere ese e hamasedia taudia na gerebu-ta daha-hani sinahu-hitu; a Kora ena kara havara dainai e mase taudia be ma idau. ");
INSERT INTO meu_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Bena Aaron ese Mose e lou henia, hebou kalagaana iduarana ai Gorere vada e doko. ");
INSERT INTO meu_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Iehova ese Mose e haḡania, eto, ");
INSERT INTO meu_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Israel taudia ba hamaorodia, itotohi bae henimu, iduhu ta ta ikwaradia taudia ese edia itotohi ta ta bae henimu: itotohi iboudiai bae gwauta-rua. Itotohi ta ta ai iduhu ikwaradia taudia ladadia ta ta ba tore; ");
INSERT INTO meu_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","bona Levi iduhuna taudia edia itotohi ai Aaron ladana ba torea. Iduhu ikwaradia taudia ta ta edia itotohi ta ta bavabi. ");
INSERT INTO meu_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Bena hebou kalagana ai bavatodia, taravatu mauana vairanai, ita raruosi ta hedavarimu gabuna ai. ");
INSERT INTO meu_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Bena vada na abia hidi tauna ena itotohi baine gara kau: unu amo Israel taudia baina tudia, oi imaumauraimu bae hadokoa. ");
INSERT INTO meu_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Taunabunai, Mose ese Israel taudia unu e hamaorodia toma. Bena edia iduhu ikwaradia taudia ese itotohi e henia, iduhu ta itotohi ta iduhu ta itotohi ta, unu e henia toma; itotohi iboudiai na gwauta-rua. Aaronena itotohi danu edia itotohi ida e heato bou. ");
INSERT INTO meu_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Bena Mose ese itotohi e abi, Iehova vairanai e atodia, taravatu mauana kalagana lalonai. ");
INSERT INTO meu_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Kerukeru, Mose na taravatu mauana kalagana lalonai e raka vareai; bena Aaron ena itotohi, Levi iduhuna itotohina, e itaia, vada e gara kau bona vada e huahua, sakada huahuadia vada e dobi. ");
INSERT INTO meu_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Bena Mose ese itotohi iboudiai na Iehova vairana amo e abidia, e laohaidia, Israel taudia iboudiai dekediai: idia ese e itadia, bena ta ta ena itotohi ena itotohi e abidia. ");
INSERT INTO meu_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Bena Iehova ese Mose ma e haḡania, eto, Aaron ena itotohi bavatoa lou, taravatu mauana vairanai, toa ai bainela ini gwau-edeede taudia ediai; unu amo ba tudia, lau e maumauraigumu herevadia bae hadoko, bae mase na garina. ");
INSERT INTO meu_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Mose na unu e kara toma: Iehova ese e haḡania heḡereḡerena, unu mo e kara toma. ");
INSERT INTO meu_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Bena Israel taudia ese Mose e hamaoroa, eto, A itaia, ai na vada a masemu, vada ame baia, iboumai ai vada ame baia. ");
INSERT INTO meu_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","E raka kahiramu, Iehova ena dubu e raka henia kahimu, taudia iboudiai e masemu. Ai iboumai ai baia mase ore a? ");
INSERT INTO meu_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Iehova ese Aaron e hereva henia, eto, Kerere gabu helaḡana ai bae vara na oi bona natumu bona emu iduhu taudia latamui ai; bona hahelaḡa taudia edia kerere na oi bona natumu latamui ai. ");
INSERT INTO meu_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Varavaramu danu, Levi iduhuna taudia, tamamu ena iduhu taudia, na oi ida bae raka kahi mai, oi ida bae ḡaukara hebou, bona oi isiaimu bae lao heni. Ḡau tamona, oi mai natumu ida mo taravatu mauana kalagana lalonai ba ḡaukara. ");
INSERT INTO meu_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Idia ese oi isiaimu bae lao heni, bona hebou kalagana ḡaukaradia bae kara; a gabu helaḡana kohudia basie raka henidia kahi, bona ihaboulaina patana basie raka henia kahi, idia bae mase bona umui ba mase na garina. ");
INSERT INTO meu_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Idia na oi bae durumu, hebou kalagana inarina ai bona ena ḡaukara iboudiai ikaradia ai: idau iduhu tauna ta basine raka henimui kahi. ");
INSERT INTO meu_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","A umui ese gabu, helaḡana ḡaukaradia bona ihaboulaina patana ḡaukaradia ba kara; unu amo badu na Israel taudia latadiai basine kau lou. ");
INSERT INTO meu_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","O itaia, varavaramui Levi taudia na Israel taudia bogaragidia amo vada na abidia hidi, vada na henimui, Iehova ena, hebou kalagana ḡaukaradia bae kara. ");
INSERT INTO meu_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","A oi mai natumu ida na hahelaḡa taumui; ihaboulaina patana ḡaukaradia iboudiai bona seseahu lalonai e karamu karadia, iboudiai na umui ese ba kara. Lau isiaigu ba lao heni; hahelaḡa dagina lau ese vada na henimui. Idau tauna ta baine raka kahira, ia na baine mase. ");
INSERT INTO meu_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Iehova ese Aaron ma e hamaoroa, eto, A itaia, egu dudui-isi bouboudia vada na henimu: Israel taudia ese e hahelaḡadiamu ḡaudia iboudiai na vada na henimu; vada e horomui dainai oi vada na henimu bona natumu vada na henidia, oi ahumu bona idia ahudia, ela bona hanaihanai. ");
INSERT INTO meu_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ḡau helaḡadia Iahi bouboudia amo bavabi ḡaudia bini: edia herahia ḡaudia iboudiai; edia flaoa bouboudia iboudiai; edia kara-dika iabi-ohodia bouboudia iboudiai; edia kerere iabi-ohodia bouboudia iboudiai; unu iboudiai bae helaḡa, oi amu bonanatumu adia. ");
INSERT INTO meu_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Gabu helaḡana ai bavani, mamaruanemui iboumui ai ese; ia na helaḡa, amui aniani. ");
INSERT INTO meu_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Amu bini: bae dudui isi ḡaudia, bona Israel taudia edia davedave bouboudia iboudiai; oi vada na henimu bona natumu mamaruanedia bona natumu hahinedia vada na henidia, oi ahumu bona idia ahudia ela bona hanaihanai, asi mirodia taudia iboudiai emu ruma ai na bae ani diba. ");
INSERT INTO meu_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Dehoro namo-hereana bona vine ranuna namo-hereana bona uit namo-hereana bae mailai, edia uma anidia roboadia bona edia imea anidia roboadia Iehova bae henia, idoinai vada na henimu. ");
INSERT INTO meu_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Edia uma anidia roboadia bona edia imea anidia roboadia iboudiai, Iehova dekena e mailaidia ḡaudia, na oiamu; asi mirodia taudia iboudiai emu ruma ai na bae ani. ");
INSERT INTO meu_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Gwau-hamata daidiai Iehova bae henia ḡaudia Israel ai na oiemu. ");
INSERT INTO meu_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Mauri ḡaudia natudia roboadia iboudiai, taunimanima natudia bona ubu-ubu ḡaudia natudia, na Iehova bae henia, iboudiai na oiemu. Ḡautamona, taunimanima natudia roboadia bona ḡau mirodia natudia roboadia na davadia bae kara. ");
INSERT INTO meu_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Edia mauri huana tamona baine ore ai na davadia bae kara: davadia vada ba gwauraia, silver sekeledia, ima, gabu helaḡana ena sekele heḡereḡerena; una sekele lalonai gera na ruahui. ");
INSERT INTO meu_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","A boromakau natuna roboana eiava mamoe natuna roboana eiava nani natuna roboana na davana basio karaia. Idia na hehelaḡa; raradia na ihaboulaina patana latanai ba nevaria, bona digaradia na ba haḡole oho, bonana namo ḡauna Iehova ena. ");
INSERT INTO meu_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","A hidiodia na oiamu; kemena, e davea ḡauna, bona idiba mamuna na oiamu heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Herahia helaḡadia, Israel taudia ese Iehova vairanai e dudui isimu ḡaudia, iboudiai name henimu, oiamu bona natumu mamaruanedia adia bona natumu hahinedia adia, umui ahumui ela bona hanaihanai. Ina, na herohemaino damenana Iehova vairanai, oiemu bona oi garamu edia, ela bona hanaihanai. ");
INSERT INTO meu_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Iehova ese Aaron ma e hamaoroa, eto, Oi na emu inoḡo ta basio abia edia tano ai, bona ahumu ta basio abia idia bogaragidiai: lau na oi ahumu, oi na lau dihigu, Israel taudia bogaragidiai. ");
INSERT INTO meu_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Israel taudia edia ḡau e karoamu, karoa gwauta, bena karoa ta lau e henigumu, una karoa na Levi taudia; vada na henidiamu, idia ahudia, edia ḡaukara davana, hebou kalagana ai:lau, isiaigu lao henimu dainai. ");
INSERT INTO meu_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Ina murinai, Israel taudia ese hebou kalagana: basie raka henia kahi, edia kara dika ai bae mase na garina. ");
INSERT INTO meu_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","A Levi taudia ese hebou kalagana ḡaukaradia iboudiai bae kara; kerere ta bema vara, una kerere na idia latadiai. Ina taravatu na do baine hesiriu hanaihanai emui uru iboudiai lalodiai. Israel taudia bogaragidiai idia na asi ahudia. ");
INSERT INTO meu_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Badina be hari karoa ihagwautadia, Israel taudia ese Iehova vairanai e dudui isi ḡaudia, lau ese Levi taudia vada na henidia, idia ahudia; una dainai vada na hamaorodia, Israel taudia bogaragidiai idia na asi ahudia. ");
INSERT INTO meu_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Bena Iehova ese Mose ma e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Levi taudia na ba: hamaorodia, baoto: Israel taudia edia karoa ihagwautadia, umui ahumui vada na, henimui ḡaudia, bavabi negadia ai na ene karoa ihagwautadia ma ba karoadia, karoa gwauta gwauta, bena karoa ta ta ba dudui isi, Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Bena, ene ba dudui isi ḡaudia na emui boubou ḡaudia ai baela, uit na emui roge amo eiava vine ranuna na emui vine amo boma dudui isi heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Unuhetomana umui na emui karoa ihagwautadia, Israel taudia e henimuimu ḡaudia, na iboudiai ma ba karoadia, Iehova ena dudui isi boubouna na hahelaḡa tauna Aaron ba henia. ");
INSERT INTO meu_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Bae henimui herahiadia iboudiai amo emui boubou ḡaudia ba dudui isi Iehova vairanai: namo-hereadia bona mai helaḡadia karoadia mo ia ba henia. ");
INSERT INTO meu_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Taunabunai ba hamaorodia, baoto: Karoa namona ba duduia isi, bena orena be Levi taudia adia, uit anina ikwadina gabuna amo bona vine ranuna itaolaina gabuna amo heḡereḡeredia. ");
INSERT INTO meu_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Una na amui aniani: gabu iboudiai bavania, umui bona emui ruma taudia, hebou kalagana ḡaukaradia o karamu davana. ");
INSERT INTO meu_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Bena namo-hereana na ba duduia isi dainai umui na ianina ai basio kerere. A Israel taudia edia ḡau helaḡadia na basio abi havara, ba mase na garina. ");
INSERT INTO meu_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Iehova ese Mose bona Aaron e hamaorodia, eto, ");
INSERT INTO meu_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Iehova ena haheḡani ta binai. Israel taudia ba hamaorodia, idia ese boromakau hahinena kakakakana ta, asi bebeka-bebekana, maduna ta paḡana ai do asie atoa kau ḡauna, bae mailaia dekemui ai. ");
INSERT INTO meu_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Hahelaḡa tauna Eleasara ba henia; ia ese baine laohaia taruha murimurinai, bena tau ta ese ia vairanai baine alaia mase. ");
INSERT INTO meu_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Bena hahelaḡa tauna Eleasara ese una boromakau rarana taina baine abia, nega hahitu imana kwakikwakina amo baine daveraia, hebou kalagana vairanai. ");
INSERT INTO meu_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","A boromakau tau-anina na ia vairanai bae haḡolea oho, kopina bona hidiona bona rarana bona taḡena. ");
INSERT INTO meu_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Bena hahelaḡa tauna ese sida audia bona muramura avana bona dabua kakakakana na boromakau e ḡolea ohomu lahina ai baine tahodia kau. ");
INSERT INTO meu_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Bena hahelaḡa tauna ese ena dabua baine huri bona baine digu, bena taruha lalonai ma baine raka vareai, bona baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Boromakau e haḡolea oho tauna danu ena dabua baine huri bona baine digu, bona baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Bena asi mirona tauna ta ese boromakau kahuna baine haboua, taruha murimurinai baine atoa, gabu ḡoevaḡoevana ta ai. Una kahu be baine mia, Israel oreana taudia edia. Idia ese ranu ai bae buloa, kara dika ihuri-ohona ḡauna. Ina na kara dikaboubouna ta. ");
INSERT INTO meu_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","A hari boromakau kahuna e habouamu tauna ese ena dabua baine huri, bona baine taubu ela bona dina baine diho. Ina taravatu baine mia hanaihanai, Israel taudia latadiai bona bogaragidiai e noho hedoamu taudia latadiai. ");
INSERT INTO meu_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Ta ese mase tauna baine daua toho, ia na baine taubu ela bona dina hitu bae ore. ");
INSERT INTO meu_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Dina ihatoina ai bona dina ihahituna ai ranu ai baine digu, unu amo baine ḡoeva. A dina ihatoina ai bona dina ihahituna ai basine digu, ia na basine ḡoeva. ");
INSERT INTO meu_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ta ese mase tauna tau-anina bainedaua toho bona basine haheḡoeva, ia ese Iehova ena dubu baine hamiroa: Israel amo bae negea daure. Kara dika ihuri-ohona ranuna asie dairilaia dainai ia na miro; mirona na dounu mia enai. ");
INSERT INTO meu_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Tau ta ena kalaga ai baine mase taravatuna binai: una kalaga ai bae raka vareai bona una kalaga ai e nohomu taudia na bae taubu, ela bona dina hitu bae ore. ");
INSERT INTO meu_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Bona hodu, uro, nau asi ikaruhidia danu bae miro. ");
INSERT INTO meu_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Ta ese taruha murimurinai dare amo e alaia mase tauna, eiava e mase kava tauna, eiava tau ta turiana, baine daua toho, eiava gara ai baine dau kau, ia na baine taubu ela bona dina hitu bae ore. ");
INSERT INTO meu_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Bena taubu taudia ese hari kara-dika iabi-ohona boubouna kahuna taina bae abia, sinavai ranuna ida bae buloa dihu ta ai. ");
INSERT INTO meu_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Bena asi mirona tauna ta ese muramura avana baine abia, una ranu ai baine urua diho; bena kalaga, bona kalaga kohuna idoinai, bona kalaga taudia, bona turia e daua toho tauna, bona dare amo e alaia mase tauna e daua toho tauna, bona e mase kava tauna e daua toho tauna, bona gara ai e dau kau tauna, baine nevaridia. ");
INSERT INTO meu_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Asi taubuna tauna ese mai taubuna tauna baine nevaria, dina ihatoina ai bona dina ihahituna ai. Bena dina ihahituna ai ia na sibona baine haheḡoeva: ia na ena dabua baine huri bona baine digu, bena dina baine diho ai ia na baine ḡoeva. ");
INSERT INTO meu_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","A taubu tauna na unu basinema haheḡoeva toma, ia na hebou bogaragina amo bae negea daure, badina be ia ese Iehova ena gabu helaḡana vada e hamiroa; miro ihuri-ohona ranuna amo asie nevaria dainai ia na taubu. ");
INSERT INTO meu_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Edia taravatu bunai ela bona hanaihanai: kara dika ihuri-ohona ranuna baine nevarilaia tauna ese ena dabua baine huri; bona kara dika iabi-ohona ranuna ai baine dau kau tauna na baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Taubu tauna ese baine daua toho ḡauna na baine miro; bona una ḡau ma baine daua toho tauna danu baine taubu ela bona dina baine diho. ");
INSERT INTO meu_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Hua gini-gunana ai Israel taudia oreana idoinai na Sin tano-ḡaḡaena ai e kau, Kade ai e taruha. Unuseni ai Miriama e mase; idia ese una gabu ai e guria. ");
INSERT INTO meu_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Una gabu na asi ranuna, hebou taudia edia. Bena idia na e hebou, Mose bona Aaron e inai henidia. ");
INSERT INTO meu_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Idia ese Mose e ḡadeḡade henia, eto, Varavaramai na Iehova vairanai e mase negana ai, ai danu baiama mase bema namo. ");
INSERT INTO meu_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Dahaka dainai ai Iehova ena orea taumai na ina tano ḡaḡaena ai vada; o hakaumai vareai? Ai baia mase bona emai ubu-ubu ḡaudia baemase totona a? ");
INSERT INTO meu_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Dahaka dainai Aigupto amo vada o hakaumai lasi, ema bona ina gabu dikana? Ina gabu na asi uitina, asi sukena, asi vinena, asi rimonona; inuinu ranuna danu lasi. ");
INSERT INTO meu_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Bena Mose bona Aaron na hebou taudia edia amo e raka oho, hebou kalagana iduarana ai e goru diho; bena Iehova diaridiarina e itaia. ");
INSERT INTO meu_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Itotohi bavabia, taunimanima ba haboudia, oi bona kakamu Aaron dekemui ai; bena vairadiai nadi hagahagana ba haḡania, ranu na iena amo baine aru lasi. Unu amo oi ese ranu na nadi hagahagana amo ba ha-arua lasi, hebou taudia ba henidia bona edia ubu-ubu ḡaudiaba henidia, bae inua. ");
INSERT INTO meu_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Bena Mose ese itotohi Iehova vairana amo e abia, ena haheḡani heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Bena Mose bona Aaron ese hebou taudia e haboudia, nadi hagahagana vairanai; e gwau henidia, eto, Gwau-edeede taumui e, a hakala; emui ranuna ina nadi hagahagana amo baia ha-arua lasi a? ");
INSERT INTO meu_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Bena Mose ese imanae duduia isi, nadi hagahagana na nega harua ena itotohi amo e botaia. Bena ranu na e aru lasi badabada; hebou taudia ese e inua, bona edia ubu-ubu ḡaudia.ese danu e inu. ");
INSERT INTO meu_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Bena Iehova ese Mose bona Aaron e gwau henidia, eto, Asio abidadama henigu dainai, bona Israel taudia vairadiai lau ladagu asio hahelaḡaia dainai, umui raruosi ese ina orea taudia basio hakaudia vareai, lau ese vada na henidia tanona lalonai. ");
INSERT INTO meu_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ina ranu na Meriba; badina be Israel taudia ese Iehova e ḡadeḡade henia, bena ia ese ena siahu e hahedinarai henidia. ");
INSERT INTO meu_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Bena Mose ese gwaukau taudia Kade amo e siaidia, Edom pavapavana dekenai, bae hamaoroa, baeto “Tadimu Israel na ini e gwau tomamu: oi dibamu dahaka ḡau dahaka ḡau ese vada e butumai tao; ");
INSERT INTO meu_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","senemai na Aigupto ela, bena nega daudau Aigupto ai a nohova; a Aigupto taudia ese ai bona tamamai e daḡedaḡe henimaiva. ");
INSERT INTO meu_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Iehova a tai heniava, bena ia ese emai taitai e kamonai, aneru ta e siaia, Aigupto amo e hakaumai lasi, ama, emu tano hetoana ai a nohomu, Kade hanuana ai. ");
INSERT INTO meu_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Harihari ai a noimumu, emu tano amo baia raka hanai. Uma ta amo basia raka hanai, eiava vine imeana ta amo basia raka hanai, bona guri ranudia basia inu; Pavapava Dalana ai baia raka. Dala amo basia raka siri, idiba kahana amo eiava lauri kahana amo, ela bona emu tano hetoana baia rakaia hanai.” ");
INSERT INTO meu_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edom ese e haere henia, eto, Basio raka hanai, baina tuari henimu na garina. ");
INSERT INTO meu_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Israel taudia ese ma e noia, eto, Laolao dalana ai baia raka; emu ranu baia inua eiava emai ubu-ubu ḡaudia ese bae inu, ai na davana baia henimu. Aemai amo baia raka hanai, vadaeni. ");
INSERT INTO meu_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","A ia ma e haere, eto, Basio raka hanai. Bena Edom ese tuari oreana badana mai goadana e hakaua lasi, idia ilao-ahudia. ");
INSERT INTO meu_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Taunabunai Edom ese Israel taudia e laodia ahu, ena tano amo basie raka hanai. Bena Israel na idau dala amo ela. ");
INSERT INTO meu_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Idia na Kade amo eha laolao, ela, iboudiai na Horo ororona ai e kau. ");
INSERT INTO meu_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Bena Horo ororona ai, Edom ena tano hetoana ai, Iehova ese Mose bona Aaron e hamaorodia, eto, ");
INSERT INTO meu_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aaron na tubu tama dekediai baine hahebou; ia na Israel taudia vada na henidia tanona ai basine raka vareai, badina be ranu gabuna ai Meriba ai egu hereva o utua. ");
INSERT INTO meu_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Aaron mai natuna Eleasara ida bavabidia, Horo ororona ai ba hakaudia dara. ");
INSERT INTO meu_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Bena Aaron a ena dabua ba doki oho, ia natuna Eleasara ba hadokilaia. Aaron be unuseni ai baine mase, tubu tama dekedia bainela. ");
INSERT INTO meu_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Bena Mose ese Iehova ena haheḡani heḡereḡerena ai e karaia; hebou taudia iboudiai vairadiai idia tatoiosi na Horo ororona e dara dae. ");
INSERT INTO meu_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Bena Mose ese Aaron ena dabua e doki oho, natuna Eleasara e hadokilaia. Bena Aaron na ororo dorina ai e mase, a Mose bona Eleasara na ororo amo e hekei diho. ");
INSERT INTO meu_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Hebou taudia iboudiai ese e itaia Aaron vada e mase, bena Israel taudia iboudiai ese dina toi-ahui ai ia taina e taiva. ");
INSERT INTO meu_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Arada pavapavana, tau Kanaan, diho kahana ai e nohova, vada e kamonai Israel na Atarim dalana amo e maiva, bena ia ese e tuari henidia bona haida e abidia mauri. ");
INSERT INTO meu_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Bena Israel taudia ese Iehova e gwau henia hamata, eto, Ina bese be ai imamai ai ba henimai, bena ai ese edia hanua baia habuadia tari. ");
INSERT INTO meu_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Bena Iehova ese Israel taudia edia noinoi e abia dae, Kanaan taudia na idia imadia ai e henidia; bena idia ese una bese taudia e aladia ore bona edia hanua e habuadia tari. Taunabunai una gabu ladana e hatoa Horoma. ");
INSERT INTO meu_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Bena Horo ororona amo ma e laolao, Davara Kakakakana dalana amo e laova, Edom tanona murimurina amo bae raka hanai eto. A dala ai e hesiku, ");
INSERT INTO meu_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Iehova bona Mose e maumauraidia, eto, Dahaka dainai Aigupto amo o hakaumai lasi, tano ḡaḡaena ai baia mase helaoreana? Badina be asi amai; ranu danu lasi. A ina aniani ḡauna dikana ianina vada ame hesiku. ");
INSERT INTO meu_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Bena Iehova ese hekori gaigaidia e siaidia, idia bogaragidiai; gaigai ese e koridia, bena Israel taudia hutuma e mase. ");
INSERT INTO meu_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Bena idia na Mose dekena ela, eto, Ai na vada a kara havara, Iehova vada a maumauraia, oi danu vada a maumauraimu: Iehova ba noia, ia ese ini gaigai na ai emai amo baine abidia oho. Taunabunai Mose na e ḡuriḡuri, taunimanima daidiai. ");
INSERT INTO meu_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Bena Iehova ese Mose e hamaoroa, eto, Gaigai laulauna ta ba koroa, au-tubua dorina ai ba kapaia kau; bena gaigai ese bae koridia taudia ese bae raraia tao ai na vada bae mauri. ");
INSERT INTO meu_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Taunabunai, Mose ese gaigai laulauna ta, auri labora-labora amo e koroa, bona au-tubua dorina ai e kapaia kau, bena gaigai ese e koridia taudia ese una auri labora-labora gaigaina e raraiatao, bena vada e mauri. ");
INSERT INTO meu_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Israel taudia ma e laolao, Oboto ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Oboto ma e toretania, ela, Ie-abarim ai e taruha, tano ḡaḡaena ai. Una tano ḡaḡaenana Moab e hevaira henia, mairiveina kahana ai. ");
INSERT INTO meu_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Ma e tore isi, ela, Serede kourana ai e tatuha. ");
INSERT INTO meu_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Unu amo ma ela, Aranon sinavaina unukahana ai e taruha; una na tano ḡaḡaena ai, Amoro taudia edia tano isena ai. Hari Aranon sinavaina na Moab bona Amoro taudia edia tano hetoana. ");
INSERT INTO meu_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Una dainai Iehova ena tuari bukana ai vada e tore, eto, Wahebe Sufa ai, Bona Aranon kouradia ai; ");
INSERT INTO meu_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Koura ege-egedia Ela bona Ara ena noho gabuna, Bona Moab tanona hetoana. ");
INSERT INTO meu_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Unu amo ma e laolao ela bona Bere: ranu gurina bunai Iehova ese e gwauraia, Mose na e hamaorolaia, eto, Taunirnanima ba haboudia, lau ese ranu baina henidia. ");
INSERT INTO meu_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Bena Israel ese ina ane e abia: Ranu e, a lohi lohi dae! Ane avabia! ");
INSERT INTO meu_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Hanua pavapavadia ese guri e ḡeia, Hanua lohiadia ese e hadobua, Dagi auna amo bona itotohi amo. Una tano ḡaḡaena amo ma e laolao, ela bona gabu ladana Matana; ");
INSERT INTO meu_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Matana amo ela bona Nahaliele; Nahaliele amo ela bona Bamoto; ");
INSERT INTO meu_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bamoto amo ela bona koura ta Moab kahana ai; ma unu amo ela bona Pisga ororona dorina: unu amo tano ḡaḡaena e roha tari lao. ");
INSERT INTO meu_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israel ese gwaukau taudia e siaidia, Sihon, Amoro pavapavana, dekenai, eto, ");
INSERT INTO meu_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Mani emu kara emu tano amo baia raka hanai. Basia raka siri, uma ai eiava vine imeana ai basia raka vareai; guri ranudia danu basia inu. Pavapava Dalana amo baia raka, ela bona emu tano amo baia raka lasi. ");
INSERT INTO meu_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","A Sihon ese Israel taudia e gwaudia tao, ena tano amo basie raka hanai eto. Ena orea taudia iboudiai e haboudia, tano ḡaḡaena ela, Israel taudia ilao-henidia totona; bena Iahasa ai e tuari henidia. ");
INSERT INTO meu_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","A Israel taudia ese dare amo e alaia mase, ena tano idoinai e abia, Aranon sinavaina amo ela bona Iabok sinavaina ela bona Amono taudia edia tano; a Amono taudia ese edia tano hetoana e ginia ahu auka masemase. ");
INSERT INTO meu_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Bena Israel taudia ese edia hanua iboudiai e abidia; bena Hesebon bona Amoro hanuadia maraḡidia iboudiai e noholaidia. ");
INSERT INTO meu_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Badina be Hesebon na Sihon, Amoro pavapavana, ena hanua; ia ese gunaguna Moab pavapavana gunana e tuari henia, bona ena tano idoinai e abia ela bona Aranon sinavaina. ");
INSERT INTO meu_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Una dainai ane isisibana taudia eto: Aoma Hesebon. Sihon ena hanua baita hadaia, Bona baita ha-aukaia. ");
INSERT INTO meu_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Badina be lahi Hesebon amo e tubu, Lahi hururu-hururuna Sihon ena hanua amo e dae; Ara Moab ai e araia, Aranon ororodia lohiadia e aradia ore. ");
INSERT INTO meu_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Moab e, madi, ihabaimu! Kemoso o toma henia dihomu taumui e, vada o baia! Natuna mamaruanedia vada e luludia oho, Natuna hahinedia vada e abidia mauri, Sihon, Amoro pavapavana, ese. ");
INSERT INTO meu_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Emai diba amo vada a haberodia; Hesebon vada e hebua tari ela bona Dibon, Tano vada a havahua ela bona Nofa, ela bona Medeba. ");
INSERT INTO meu_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Unuhetomana Israel na Amoro tanona e noho henia. ");
INSERT INTO meu_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Bena Mose ese hasinadoa taudia e siaidia, lasere ela; bona lasere hanuadia e abidia, Amoro taudia unuseni ai e nohova na e luludia lasi. ");
INSERT INTO meu_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Bena idia na e raka Iasi, Basan dalana amo ela. Bena Og, Basan pavapavana, mai ena orea taudia iboudiai ida, e raka Iasi, Edrei ai e tuari henidia. ");
INSERT INTO meu_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","A Iehova ese Mose e hamaoroa, eto, Basio gari henia; oi imamu ai vada na atoa kau: ia, bona ena orea taudia iboudiai, bona ena tano idoinai. Sihon, Amoro pavapavana, Hesebon ai o kara henia heḡereḡerena, ina tau danu unu ba kara henia toma. ");
INSERT INTO meu_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Taunabunai idia ese ia bona natuna bona ena orea taudia iboudiai e hadareredia bona e luludia lasi; bena ena tano e abia, edia tano ai e halaoa. ");
INSERT INTO meu_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Israel taudia ma e laolao, Moab taoradia ai e taruha, Ioridane sinavaina unukahana ai, gabu ladana na Ieriko. ");
INSERT INTO meu_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak Siporo ese Israel taudia edia kara idoinai Amoro taudia e kara henidia vada e itaia. ");
INSERT INTO meu_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Moab ai danu gari na bada, badina be Israel taudia na hutuma herea; una dainai Moab taudia ese Israel taudia garidia e gariva. ");
INSERT INTO meu_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Bena Moab ese Midian lohiadia hamaorodia, eto, Ini hutuma na eda gabu idoinai bae habuaia tari, boromakau; ese rei e ani oremu na heto. Una negana ai Balak Siporo( na Moab pavapavana. ");
INSERT INTO meu_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Taunabunai ia ese gwaukau taudia haida e siaidia, a Balaam Beoro dekenai, Petoro ai, Sinavai Badana isena ai, Amawa tanona ai, eto, A itaia, bese ta Aigupto amo vada ema, tano idoinai vada e hahonua davana; idia na lau vairagu ai vada e taruha. ");
INSERT INTO meu_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Mani emu kara aoma, ina bese ba uduguiraia, badina be edia goada ese lauegu e hereaiamu; bena readia baina hadareredia diba bona baina luludia diba; badina be lau dibagu oi ese o hanamoamu tauna na baine namo, bona oi ese o uduguiraiamu tauna na baine dika. ");
INSERT INTO meu_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Taunabunai, Moab lohiadia bona Midian lohiadia ese idume na imadia ai e abi, ela, Balaam enai e kau, Balak ena hereva e hamaorolaia. ");
INSERT INTO meu_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Bena Balaam ese e haere henidia, eto, Hari hanuaboi iniseni ai ba mahuta; bena Iehova ese baine hereva henigu heḡereḡerena ai baina haere henimui. Taunabunai, Moab lohiadia na Balaam dekenai e nohova. ");
INSERT INTO meu_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Bena Dirava na Balaam dekena ema, eto, Ini oi dekemu ai e nohomu taudia be daidia? ");
INSERT INTO meu_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam ese Dirava e haere henia, eto, Balak Siporo, Moab pavapavana, vada e siaidia dekegu ai, eto, ");
INSERT INTO meu_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","O itaia, bese ta Aigupto amo vada ema, tano idoinai vada e hahonua davana; mani emu kara, ina bese ba uduguiraia, bena baina tuari henidia bona ina tano amo baina luludia lasi. ");
INSERT INTO meu_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Dirava ese Balaam e hamaoroa, eto, Idia ida basiola, bona una bese basio uduguiraia; badina be lau ese vada na hanamodia. ");
INSERT INTO meu_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Daba ai Balaam e tore isi, Balak ena lohia taudia e hamaorodia, eto, Emui tano ba lou henia, badina be Iehova ese e rugumu, basina bamomui e tomu. ");
INSERT INTO meu_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Taunabunai Moab lohiadia e lou ela, Balak dekenai, eto, Balaam na e gwau edeede, se bamomai. ");
INSERT INTO meu_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Taunabunai, Balak ese lohia haida ma e siaidia; e siaidia guna na dia hoho bona dagi maraḡi taudia, a harihari e siaidia na hoho bona dagi bada taudia. ");
INSERT INTO meu_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Idia na Balaam dekena ela, eto, Balak Siporo na e tomu, Ḡau ta basine laomu ahu, vada aoma. ");
INSERT INTO meu_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Lau ese baina matauraimu, bona ede ba hamaorogu toma unu mo baina kara toma. Taunabunai vada aoma, ina bese ba uduguiraia, egu noinoi heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","A Balaam ese Balak ena hesiai taudia e haere henidia, eto, Ena be Balak ese ena ruma, mai ena silver idoinai bona ena gold idoinai ida, bema henigu, to Iehova egu Dirava ena hahedua basinama ha-idaua diba; basinama hamaraḡia, basinamahabadaia danu. ");
INSERT INTO meu_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Taunabunai, iniseni ai ba mahuta, hari ina hanuaboi, ela.bona lau baina diba Iehova ede baine haduagu toma. ");
INSERT INTO meu_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Bena hanuaboi ai Dirava ese Balaam e hahedinarai henia, eto, Ini taunimanima) ima na oi iboirimu vada ema. Vadaeni, a tore isi, idia ida baola; a lau ese baina hamaoromu heḡereḡerena ai mo ba karaia. ");
INSERT INTO meu_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Taunabunai, Balaam na daba ai e tore isi, ena doniki e abia heḡaeḡae, Moab lohiadia idoinai ida ela. ");
INSERT INTO meu_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","A ia na ela dainai, Dirava vada e badu; bena Iehova ena aneru ta dala ai e gini, ia ilao-ahuna. Ia be ena doniki ai e gui, ena hesiai taudia rarua danu ia e bamoa. ");
INSERT INTO meu_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Hari doniki ese Iehova ena aneru e itaia, dala ai gini, mai ena dare imana ai; bena doniki na dala amo e raka siri, rei lalonai. A Balaam ese doniki e kwadia, baine Iou dala ai eto. ");
INSERT INTO meu_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Bena Iehova ena aneru na gabu hekahina ta ai, dala na vine imeadia padadia amo ela gabuna ai, e gini. Dala kahana kahana ai na nadi maḡudia. ");
INSERT INTO meu_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Doniki ese Iehova ena aneru ma e itaia, bena e raka siri maḡu badibadinai; bena Balaam aena e bero maḡu nadidia ai. Bena ma e kwadia lou. ");
INSERT INTO meu_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Una murinai, Iehova ena aneru ma ela, gabu hekahi-hekahina taai e gini, idiba ai bona lauri ai asi raka siri dalana gabuna ai. ");
INSERT INTO meu_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Doniki ese Iehova ena aneru ma e itaia, bena tano ai e hekure diho Balaam henunai. Bena Balaam e badu dikadika, ena, itotohi amo e dadabaia. ");
INSERT INTO meu_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Bena Iehova ese doniki uduna e hahaḡaia, bena ia ese Balaam e hereva henia, eto, Lau ede na karamu toma dainai nega toi o kwadigu? ");
INSERT INTO meu_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam ese doniki e haere henia, eto, Vada o hakavakavagu dainai; imagu bema mai darena, bama alamu mase. ");
INSERT INTO meu_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Bena doniki ese Balaam ma e hereva henia, eto, Lau na emu doniki ani? Emu mauri dinadia iboudiai lau dorugu ai vada o loaloa ani? Lau ese nega ta ini na karamu toma a? Balaam eto, Lasi. ");
INSERT INTO meu_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Bena Iehova ese Balaam matana e hapapa; bena Balaam ese Iehova ena aneru e itaia dala ai, imana na mai darena. Bena e goru diho tano ai. ");
INSERT INTO meu_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Iehova ena aneru ese e gwau henia, eto, Dahaka dainai emu doniki na nega toi o kwadia? O itaia, lau na oi ilao-ahumu vada na raka lasi, badinabe emu kara na dika vairagu ai. ");
INSERT INTO meu_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Bena doniki e itagu, bona nega toi egu amo e raka siri; basinema raka siri, oi bama alamu mase a ia bama hamauria. ");
INSERT INTO meu_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Bena Balaam ese Iehova ena aneru e haere henia, eto, Lau be na kerere, badina be asi dibagu oi na dala ai gini, o laogu ahu. A bema oi o laloamu bainala na dika, vada baina lou lao. ");
INSERT INTO meu_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Bena Iehova ena aneru ese Balaam e hamaoroa, eto, Idia ida baola; a lau baina hamaorolaimu herevadia mo ba gwaurai. Bena Balaam na Balak lohiadia ida ela. ");
INSERT INTO meu_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balak vada e kamonai Balaam na e maimu, bena ia na Moab hanuana ela Aranon sinavaina isena ai, ena tano hetoana ai, bae hedavari eto. ");
INSERT INTO meu_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Bena Balak ese Balaam e hereva henia, eto, Gwau-kau na siaia, na boirimu ani? Dahaka dainai o gwau edeede? Lau na basina hanamomu diba a? ");
INSERT INTO meu_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam ese Balak e haere henia, eto, Vada nama; to lau na asi siahugu hereva ta baina gwauraia; Dirava ese udugu ai baine atoa herevana, una mo baina gwauraia. ");
INSERT INTO meu_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Bena Balaam na Balak ida ela, Kiriata-husoto ai e kau. ");
INSERT INTO meu_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Bena Balak ese boubou ḡaudia e aladia, boromakau bona mamoe, Balaam bona ia e bamoa lohiadia ahudia e siaidia dekediai. ");
INSERT INTO meu_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Daba ai Balak ese Balaan e hakaua dara, Bamoto-Baal ela; unu amo e roha lao, gabu kahikahidia aie nohova taudia na e nenedia. ");
INSERT INTO meu_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam ese Balak e hamaoroa, eto, Ihaboulaina patadia hitu ba lareba iniseni ai; boromakau mamaruanedia hitu bona mamoe mamaruanedia hitu danu bavabi heḡaeḡae. ");
INSERT INTO meu_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Bena Balak ese Balaam ena hereva heḡereḡerena e karaia. Bena Balak bona Balaam ese ihaboulaina patadia ta ta latadiai boromakau maruanena ta bona mamoe maruanena ta e haḡoledia oho. ");
INSERT INTO meu_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Bena Balaam ese Balak e hamaoroa, eto, Emu ḡole-oho boubouna badibadinai ba gini. Lau be bainala, reana Iehova nadekegu ai bainema eiava; bena ede baine hamaorogu toma ma baina hamaoromu. Bena ororo ta ai e dare dae. ");
INSERT INTO meu_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Bena Dirava na ia ida e hedavari. Balaam ese e hereva henia, eto, Lau na ihaboulaina patadia hitu vada na abi heḡaeḡae, bona ta ta latadiai boromakau maruanena ta bona mamoe maruanena ta vada na haḡoledia oho. ");
INSERT INTO meu_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Bena Iehova ese Balaam baine gwaurai herevadia e henia, eto, A lou lao Balak; dekenai, unu ba hamaoroa toma. ");
INSERT INTO meu_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Taunabunai ia na e lou lao ia dekenai; Moab lohiadia iboudiai na unuseni ai gigini, iena ḡole-oho bouboudia badibadidiai. ");
INSERT INTO meu_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Bena Balaam na e haroro, eto, Balak ese Aram amo e boirigu, Moab pavapavana ese mairiveina ororodia amo e boirigu; Aoma, eto, Iakob ba uduguiraia, Aoma, Israel ba ihi-ihiraia. ");
INSERT INTO meu_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","A Dirava ese se uduguiraiamu tauna na Ede baina uduguiraia toma? Iehova ese se ihi-ihiraiamu tauna na Ede baina ihi-ihiraia toma? ");
INSERT INTO meu_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Haga amo na itaiamu, Ororo amo na haḡereamu, Ia na noho-edea besena, Bese loḡora ida asie duahia hebou. ");
INSERT INTO meu_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Iakob ḡahuna daika ese baine hagaua? Israel oreana ta daika ese baine duahidia? Kara maoromaoro tauna ena mase ai baina mase, Egu mauri baine doko iena mauri dokona heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Bena Balak ese Balaam e gwau henia, eto, Ede vada o karagu toma? Inaigu iuduguiraidia totona na boirimu, a oi ese ihanamodia herevadia mo vada o gwaurai. ");
INSERT INTO meu_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","A Balaam e haere, eto, Iehova ese vada e henigu herevadia na basina gwaurai a? ");
INSERT INTO meu_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Bena Balak ma e hamaoroa, eto, Mani a bamogu, gabu ta ma baitala; unu amo ba itadia, a kahikahidia taudia mo ba itadia, iboudiai basio itadia; unuseni ai ba uduguiraidia. ");
INSERT INTO meu_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Bena ia ese e hakaua lao, Sofimi tanona ai, ela bona Pisga ororona; l dorina; unuseni ai ihaboulaina patadia hitu ma e lareba, bona ta ta latadiai boromakau maruanena ta bona mamoe maruanena ta e haḡoledia oho. ");
INSERT INTO meu_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Bena Balaam ese Balak e hamaoroa, eto, Emu ḡole-oho boubouna badibadinai ba gini; lau bainala, Iehova ida baia hedavari. ");
INSERT INTO meu_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Bena Iehova na Balaam dekena ema, baine gwaurai herevadia e henia, eto, A lou lao Balak dekenai, unu ba hamaoroa toma. ");
INSERT INTO meu_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Taunabunai ia na e lou lao, Balak e davaria, ena ḡole-oho boubouna badibadinai gini, Moab lohiadia ida. Bena Balak ese e nanadaia, eto, Iehova na ede e gwau toma? ");
INSERT INTO meu_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Bena Balaam ma e haroro, eto, Balak e, a tore isi, a kamonai! Siporo natuna e, a kamonai henigu! ");
INSERT INTO meu_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Dirava na dia taunimanima, mai ena koikoi; Dia taunimanima natuna, mai ena lalo rua. Vada e hereva: basine karaia a? Vada e gwauraia: basine haḡuḡurua a? ");
INSERT INTO meu_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Vada e haḡanigu, baina hanamodia; Ia ese vada e hanamodia; ena hahenamo iabi-ohona asi dibagu. ");
INSERT INTO meu_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Kara dika ta Iakob enai se itaia, Kara havara ta Israel enai se davaria; Iehova edia Dirava ese e bamodia, Pavapava gadona na bogaragidiai. ");
INSERT INTO meu_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Dirava ese Aigupto amo e hakaudia lasi; Idia na uda boromakaudia mai doadia na heheto. ");
INSERT INTO meu_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Mea karadia na asi goadadia Iakob enai, Babalau karadia na asi siahudia Israel enai. Harihari Iakob bona Israel bae herevalaidia, Baeto “Dirava na ede vada e karadia toma?” ");
INSERT INTO meu_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","O itaia, ina bese na e tore isimu, leona hahinena na heto; E gini toremu, leona na heto; Basine hekure ela bona baine hadareredia taudia hidiodia baine ani, Bona raradia baine inu. ");
INSERT INTO meu_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Bena Balak ese Balaam e haḡania, eto, Basio uduguiraidia bona basio hanamodia. ");
INSERT INTO meu_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","A Balaam ese Balak e haere henia, eto, Na hamaoromu, ani, nato “Iehova ese e gwauriadiamu herevadia iboudiai na baina kara”. ");
INSERT INTO meu_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Bena Balak ese Balaam e hamaoroa, eto, Mani aitala, gabu idauna ta; reana unuseni ai Dirava baine ura oi ese inaigu ba uduguiraidia. ");
INSERT INTO meu_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Taunabunai, Balak ese Balaam e hakaua lao, raruosi na Peoro dorina ela; unu amo e roha lao, tano ḡaḡaena e itaia. ");
INSERT INTO meu_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Bena Balaam ese Balak e hamaoroa, eto, Ihaboulaina patadia hitu ma ba lareba iniseni ai, bona boromakau mamaruanedia hitu bona mamoe mamaruanedia hitu ma ba henigu. ");
INSERT INTO meu_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Bena Balak ese Balaam ena hereva heḡereḡerena e karaia, boromakau maruanena ta bona mamoe maruanena ta e haḡoledia oho, ihaboulaina patadia ta ta latadiai. ");
INSERT INTO meu_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balaam lalona vada e parara Iehova ena ura be Israel baine hanamodia; una dainai ia na se raka siri, nega gunadia heḡereḡeredia, kara henuidia se kara. Ia na tano ḡaḡaena e haḡerea, ");
INSERT INTO meu_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","e roha lao, Israel iduhudia ta ta ena taruha ena taruha ai e itadia. Bena Dirava ena Lauma ese e rohea, ");
INSERT INTO meu_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","e haroro Iou, eto, Balaam Beoro ena hereva bini; Matana vada e papa tauna ena hereva bini; ");
INSERT INTO meu_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Dirava ena hereva e kamonaimu tauna, Siahu-idoinai Diravana hairaina e itaiamu Bena e toma dihomu to matana se hakapuna tauna, Ena hereva bini. ");
INSERT INTO meu_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Iakob e, emu kalaga na namo herea, Israel e, emu taruha na ḡoeva dae; ");
INSERT INTO meu_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Sinavai kouradia na heheto, Sinavai isena umadia na heheto, Aloe audia Iehova ese vada e hadodia na heheto, Sida audia ranu gabudia ai na heheto. ");
INSERT INTO meu_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Ranu na ena hodu amo baine aru, Ia garana na sinavai momo isedia ai bae noho, Ia pavapavana na Agag baine hereaia, Iena basileia baine herea dae. ");
INSERT INTO meu_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Dirava ese Aigupto amo vada e hakaua lasi; Ia na mai doana, uda boromakauna na heto; Ia ese inaina baine hadareredia, Turiadia baine hakwaidudia, Ena diba amo baine tarakidia. ");
INSERT INTO meu_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Ia na e hekuremu leona na heto, E laḡa animu leona hahinena na heto, Daika ese baine haoa? Bae hanamomu taudia na bae hanamodia, Bae uduguiraimu taudia na bae uduguiraidia. ");
INSERT INTO meu_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Bena Balak ese Balaam e badu henia, imana ruaosi e pata hekapu, e gwau henia, eto, Inaigu iuduguiraidia totona na boirimu, to oi na nega hatoi vada o hanamodia. ");
INSERT INTO meu_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","A lou haraḡa, emu gabu baola; lau na dagi namona baina henimu nato, to Iehova ese vada e rumu, baina henimu nato dagina na basio abia. ");
INSERT INTO meu_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Bena Balaam ese Balak e haere henia, eto, Emu gwaukau taudia na hamaorodia, ani, nato ");
INSERT INTO meu_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","“Ena be Balak ese ena ruma, mai ena silver idoinai bona ena gold idoinai ida, bema henigu, to Iehova ena hereva basinama ha-idaua diba; sibogu egu ura ai kara namonata eiava kara dikana ta basinama karaia diba, a Iehova ena hereva mo baina gwauraia”. ");
INSERT INTO meu_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Benaini, egu gabu taudia baina lou henidia; a guna baina hamaoromu, ina bese taudia ese oiemu bese taudia ede bae karadia toma dina gabedia ai. ");
INSERT INTO meu_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Bena ma e haroro, eto, Balaam Beoro ena hereva bini; Matana vada e papa tauna ena hereva bini; ");
INSERT INTO meu_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Dirava ena hereva e kamonaimu tauna, Herea Mikamika ena aonega ai e aonegamu tauna, Siahu-idoinai Diravana hairaina e itaiamu Bena e toma dihomu to matana se hakapumu tauna, Ena hereva bini. ");
INSERT INTO meu_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Na itaiamu, to dia ina harihari; Na roha heniamu, to dia gabu kahirana ai; Hisiu ta Iakob ena amo baine dae, Dagi auna ta Israel ena amo baine heabi isi; Moab baguna baine huaria, Set garana iboudiai kwaradia baine huaridia, ");
INSERT INTO meu_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom taudia baine luludia lasi, Seiri taudia, ana inai taudia, baine ha-oredia. Israel baine kwalimu, ");
INSERT INTO meu_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Iakob baine lohia; Hanua taudia na ta basine roho mauri. ");
INSERT INTO meu_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ia ese Amalek e haḡerea, bena ini e haroro toma: Amalek na herea-dae besena, A dokona ai baine hebua tari. ");
INSERT INTO meu_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Bena Kene taudia e haḡeredia, ma e haroro, eto, Emu ruma na auka, Emu kohoro na hagahaga nadina ai, ");
INSERT INTO meu_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","To Kain baine hebua tari, Asuru ese baine abimu mauri. ");
INSERT INTO meu_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ma e haroro, eto, Inaio, Dirava ini baine kara toma, Bena daika baine roho mauri? ");
INSERT INTO meu_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Lagatoi na Kitim amo baema, Asuru bona Ebere bae hahisidia, Bena idia danu bae hebua tari. ");
INSERT INTO meu_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Una murinai Balaam e tore isi, ena gabu ela; Balak danu e raka oho. ");
INSERT INTO meu_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israel taudia na Sitim ai e nohova; una negana ai idia na Moab hahinedia ida e kara havarava. ");
INSERT INTO meu_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Badina be unu hahine ese e boiridia, edia boubou karadia ai bae heduru; bena Israel taudia na ela, boubou ḡaudia e ani, bona Moab taudia edia dirava e toma henidia diho. ");
INSERT INTO meu_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Unuhetomana Israel taudia ese Peoro ena Baal e toma henia diho; bena Iehova ese Israel taudia e badu henidia. ");
INSERT INTO meu_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Bena Iehova ese Mose e hamaoroa, eto, Iduhu lohiadia iboudiai bavabidia, dina siahuna ai ba taudia dae, Iehova vairanai; unu amo Iehova ena badu ḡaraḡara na Israel taudia edia amo baine heabi oho. ");
INSERT INTO meu_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Nena Mose ese Israel edia hahemaoro taudia e hamaorodia, eto, Umui ta ta emui iduhu taudia hahidaosi Moab hahinedia ida e kara havara bona Peoro ena Baal e toma henia diho na bavaladia mase. ");
INSERT INTO meu_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Una negana ai Mose bona Israel oreana taudia iboudiai na hebou kalagana iduarana ai e hebou mai taitaidia ida. Bena idia vairadiai Israel tauna ta be Midian hahinena ta e hakaua lao, varavarana dekediai. ");
INSERT INTO meu_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Fineha Eleasara, hahelaḡa tauna Aaron tubuna, ese e itadia, bena e tore isi, hebou e rakatania, io e abia imana ai; ");
INSERT INTO meu_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","bena una Israel tauna murina amo e raka, ela bona ena kalaga ai e raka vareai, unuseni ai ia ese raruosi e gwadadia mase, tau bona hahine danu. Unu amo dai-hanai gorerena e doko Israel ai; ");
INSERT INTO meu_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ḡau tamona gerebu-rua daha-hani be gorere ese e hamasedia. ");
INSERT INTO meu_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Fineha Eleasara, hahelaḡa tauna Aaron tubuna, ese egu badu na Israel taudia edia amo vada e abia oho, badina be lauegu vaḡeḡe ai e vaḡeḡe idia bogaragidiai; una dainai egu vaḡeḡe ai asina aladia ore. ");
INSERT INTO meu_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Taunabunai baoto: Lau na ia ida baia herohemaino; ");
INSERT INTO meu_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","emai herohemaino toana be ia bona ia garana na hahelaḡa taudia ai baela, ela bona hanaihanai; badina be ena Dirava vaḡeḡena ai e vaḡeḡe, unu amo herohemaino karana vada e karaia, Israel taudia daidiai. ");
INSERT INTO meu_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Hari Israel tauna, Midian hahinena ida e gwadadia mase tauna, ladana na Simiri Salu, Simeon iduhuna lohiana ta. ");
INSERT INTO meu_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","A Midian hahinena, e gwadaia mase hahinena, ladana na Kosobi Suru; hari Suru na iduhu ta lohiana Midian ai. ");
INSERT INTO meu_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Iehova ese Mose ma e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Midian taudia ba tuari henidia, vada ba hadareredia; ");
INSERT INTO meu_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","badina be idia ese edia kara hedibaḡani amo vada e tuari henimui, Peoro dainai vada e dibaḡanimui, bona taihudia Kosobi, Midian lohiana natuna, dainai; Peoro bagunai gorere ese e butumui tao dinana ai e gwadaia mase hahinena bunai. ");
INSERT INTO meu_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Gorere vada e doko murinai, Iehova ese Mose bona Eleasara Aaron, hahelaḡa tauna, e hereva henidia, eto, ");
INSERT INTO meu_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Israel oreana taudia ibouboudiai ba duahidia, laḡani ruahui vada e hanai taudia iboudiai. Iduhu ta ta amo ba duahidia, tuari mai dibadia taudia iboudiai Israel ai. ");
INSERT INTO meu_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Bena Mose bona hahelaḡa tauna Eleasara ese taunimanima e hamaorodia, Moab taorana ai, Ioridane sinavaina badibadinai, Ieriko ai, eto, ");
INSERT INTO meu_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Laḡani ruahui vada e hanai taudia ba duahidia, Iehova ese Mose e haḡania heḡereḡerena. Israel taudia, Aigupto amo e raka lasi, ladadia bini. ");
INSERT INTO meu_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben na Israel natuna roboana. Ia natuna be Hanok, Hanok iduhuna e havaraia tauna; bona Palu, Palu iduhuna e havaraia tauna; ");
INSERT INTO meu_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","bona Hesron, Hesron iduhuna e havaraia tauna; bona Karami, Karami iduhuna e havaraia tauna. ");
INSERT INTO meu_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Ruben ena iduhu idoinai bunai: edia numera be 43,730. ");
INSERT INTO meu_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Palu natuna ta be Eliab. ");
INSERT INTO meu_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eliab natuna be Nemuele bona Datan bona Abiram. Hari Datan bona Abiram, be hebou ese e abidia.a hidi, bena idia raruosi bona Kora ese Mose bona Aaron e heai henidia, bona Iehova danu e heai henia, ");
INSERT INTO meu_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ela bona tano ese e hadonodia, idia bona Kora bona Kora ena orea taudia, bena iboudiai e mase. Una negana ai danu lahi ese taunimanima sinahu-rua imahui e aladia mase, mata-hakani ḡauna ai ela. ");
INSERT INTO meu_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Ḡau tamona, Kora natuna na asie mase. ");
INSERT INTO meu_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simeon natuna mai edia iduhu bini: Nemuele, Nemuele iduhuna e havaraia tauna; bona Iamin, Iamin iduhuna e havaraia tauna; bona Iakin, Iakin iduhuna e havaraia tauna; ");
INSERT INTO meu_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","bona Sera, Sera iduhuna e havaraia tauna; bona Saul, Saul iduhuna e havaraia tauna. ");
INSERT INTO meu_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Simeon ena iduhu idoinai bunai: edia numera be 22,200. ");
INSERT INTO meu_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gad natuna mai edia iduhu bini: Sefon, Sefon iduhuna e havaraia tauna; bona Hagi, Hagi iduhuna e havaraia tauna; bona Suni, Suni iduhuna e havaraia tauna; ");
INSERT INTO meu_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","bona Osni, Osni iduhuna e havaraia tauna; bona Eri, Eri iduhuna e havaraia tauna; ");
INSERT INTO meu_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","bona Arod, Arod iduhuna e havaraia tauna; bona Areli, Areli iduhuna e havaraia tauna. ");
INSERT INTO meu_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Gad natuna edia iduhu bunu: edia numera be 40,500. ");
INSERT INTO meu_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Iuda natuna be Ere bona Onan; a idia na Kanaan tanona ai e mase. ");
INSERT INTO meu_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Iuda natuna mai edia iduhu bini: Sela, Sela iduhuna e havaraia tauna; bona Perese, Perese iduhuna e havaraia tauna; bona Sera, Sera iduhuna e havaraia tauna. ");
INSERT INTO meu_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Perese natuna be Hesron, Hesron iduhuna e havaraia tauna, bona Hamulu, Hamulu iduhuna e havaraia tauna. ");
INSERT INTO meu_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Iuda ena iduhu idoinai bunai: edia numera be 76,500. ");
INSERT INTO meu_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Isakara natuna mai edia iduhu bini: Tola, Tola iduhuna e havaraia tauna; bona Puva, Punu iduhuna e havaraia tauna; ");
INSERT INTO meu_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","bona Iasub, Iasub iduhuna e havaraia tauna; bona Simron, Simron iduhuna e havaraia tauna. ");
INSERT INTO meu_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Isakara ena iduhu idoinai bunai: edia numera be 64,300.");
INSERT INTO meu_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Sebulun natuna mai edia iduhu bini: Sered, Sered iduhuna e havaraia tauna; bona Elon, Elon iduhuna e havaraia tauna; bona Ialeel, Ialeel iduhuna e havaraia tauna. ");
INSERT INTO meu_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Sebulun ena iduhu idoinai bunai: edia numera be 60,500. ");
INSERT INTO meu_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Iosef natuna mai edia iduhu bini: Manase bona Efraim. ");
INSERT INTO meu_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manase natuna bini: Makiri, Makiri iduhuna e havaraia tauna; bona Gilead Makiri, Gilead iduhuna e havaraia tauna. ");
INSERT INTO meu_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Gilead natuna bini: Iesere, Iesere iduhuna e havaraia tauna; bona Helek, Helek iduhuna e havaraia tauna; ");
INSERT INTO meu_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","bona Asriel, Asriel iduhuna e havaraia tauna; bona Sekem, Sekem iduhuna e havaraia tauna; ");
INSERT INTO meu_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","bona Semida, Semida iduhuna e havaraia tauna; bona Hefere, Hefere iduhuna e havaraia tauna. ");
INSERT INTO meu_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Selofehad Hefere na asi natuna maruanena ta, hahine mo; Selofehad natuna hahinedia ladadia na Mahala bona Noa bona Hogla bona Milka bona Tirisa. ");
INSERT INTO meu_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Manase ena iduhu idoinai bunai: edia numera be 52,700. ");
INSERT INTO meu_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Efraim natuna mai edia iduhu bini: Sutela, Sutela iduhuna e havaraia tauna; bona Bekere, Bekere iduhuna e havaraia tauna; bona Tahan, Tahan iduhuna.e havaraia tauna. ");
INSERT INTO meu_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Sutela natuna be Eran, Eran iduhuna e havaraia tauna. ");
INSERT INTO meu_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Efraim natuna edia iduhu bunu: edia numera be 32,500. Iosef garana bunu, edia iduhu ta ta ai. ");
INSERT INTO meu_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Beniamina natuna mai edia iduhu bini: Bela, Bela iduhuna e havaraia tauna; bona Asbel, Asbel iduhuna e havaraia tauna; bona Ahiram, Ahiram iduhuna e havaraia tauna; ");
INSERT INTO meu_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","bona Sefufam, Sufam iduhuna e havaraia tauna; bona Hufam, Hufam iduhuna e havaraia tauna. ");
INSERT INTO meu_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Bela natuna na Arad bona Naaman. Arad ese Arad iduhuna e havaraia, bona Naaman ese Naaman iduhuna e havaraia. ");
INSERT INTO meu_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Beniamina natuna edia iduhu bunu: edia numera be 45,600. ");
INSERT INTO meu_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dan natuna be Suhama; ia na Suhama iduhuna e havaraia tauna; Dan ena iduhu idoinai bunai. ");
INSERT INTO meu_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Suhama iduhuna ena numera be 64,400. ");
INSERT INTO meu_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Asere natuna mai edia iduhu bini: Imna, Imna iduhuna e havaraia tauna; bona Isvi, Isvi iduhuna e havaraia tauna; bona Beria, Beria iduhuna e havaraia tauna. ");
INSERT INTO meu_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Beria natuna bini: Hebere, Hebere iduhuna e havaraia tauna; bona Malkiel, Malkiel iduhuna e havaraia tauna. ");
INSERT INTO meu_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asere natuna hahinena ladana be Sera. ");
INSERT INTO meu_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Asere natuna edia iduhu bunu: edia numera be 53,400. ");
INSERT INTO meu_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Napatali natuna mai edia iduhu bini: Iaseel, Iaseel iduhuna e havaraia tauna; bona Guni, Guni iduhuna e havaraia tauna; ");
INSERT INTO meu_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","bona Iesere, Iesere iduhuna e havaraia tauna; bona Silem, Silem iduhuna e havaraia tauna. ");
INSERT INTO meu_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Napatali iduhuna idoinai binai: edia numera be 45,400. ");
INSERT INTO meu_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Israel taudia ibouboudiai e duahidia be 601,730. ");
INSERT INTO meu_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Iehova ese Mose e hamaoroa, eto. ");
INSERT INTO meu_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Tano na ba haria, ini taunimanima edia; ladadia bona edia numera heḡereḡeredia ai ba haria. ");
INSERT INTO meu_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Iduhu badana be tano badana ba henia, a iduhu maraḡina be tano maraḡina ba henia: iduhu ta ta ahudia ba henidia edia numera heḡereḡeredia. ");
INSERT INTO meu_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","A edia inoḡo be mari amo bae abi; senedia edia iduhu ladadia heḡereḡeredia ahudia bae abi. ");
INSERT INTO meu_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Iduhu badadia ai bona iduhu maraḡidia ai, edia inoḡo na mari amo bae abi. ");
INSERT INTO meu_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Levi taudia danu edia iduhu ta ta ai e duahidia. Gereson be Gereson iduhuna e havaraia tauna; Kohat be Kohat iduhuna e havaraia tauna; Merari be Merari iduhuna e havaraia tauna. ");
INSERT INTO meu_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Levi iduhudia bini: Libni bona Heberon bona Mali bona Musi bona Kora. Kohat na Amram tamana. ");
INSERT INTO meu_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amram adavana ladana na Iokebed, Levi natuna hahinena, Aigupto ai e vara. Ia natuna Amram enai e abidia be Aaron bona Mose bona taihudia Miriama. ");
INSERT INTO meu_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaron natuna be Nadab bona Abihu bona Eleasara bona Itamara; ");
INSERT INTO meu_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","a Nadab, bona Abihu e mase, lahi ida; idauna Iehovavairanai bae hahelaḡaia eto negana ai. ");
INSERT INTO meu_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Levi taudia e duahidia, edia numera be 23,000; una be mamaruane hua ta vada e hanaia taudia edia numera. Israel taudia ida asie duahidia hebou, badina be tano iharina ai idia na asi.ahudia, Israel taudia bogaragidiai. ");
INSERT INTO meu_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Ini iboudiai be Mose bona Eleasara, hahelaḡa tauna, ese e duahidia; Moab taorana ai, Ioridane sinavaina isena ai, Ieriko ai, unuseni ai e duahidia. ");
INSERT INTO meu_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","A Mose bona Aaron, hahelaḡa tauna, ese Sinai tano-ḡaḡaena ai e duahidia taudia na ta dia mauri; ");
INSERT INTO meu_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","badina be Iehova ese vada e herevalaidia, eto “Tano ḡaḡaena ai bae mase”. Taunabunai ta dia mauri; Kaleb lefune bona Iosua Nunu, idia raruosi mo sibodia dounu e mauri nohova. ");
INSERT INTO meu_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Una negana ai Selofehad Hefere natuna hahinedia na e raka kahira. Hari Hefere na Gilead natuna; Gilead be Makiri natuna; Makiri be Manase natuna. Taunabunai, idia na Manase Iosef ena iduhu hahinedia Hahine ladadia be Mahala bona Noa bona Hogla bona Milka bona Tirisa. ");
INSERT INTO meu_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Idia na Mose bona hahelaḡa tauna Eleasara bona iduhu lohiadia bona hebou taudia iboudiai vairadiai e gini, hebou kalagana iduarana ai, eto, ");
INSERT INTO meu_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Tamamai na tano ḡaḡaena ai e mase: ia na dia Kora ida Iehova e heai henia oreana tauna ta, to ia sibona ena kara dika dainai e mase. Ia na asi natuna maruanena ta. ");
INSERT INTO meu_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Badina be dahaka tamamai ladana na ena iduhu amo baine heabi oho, asi natuna maruanena dainai? Tamamai varavarana bogaragidiai ai ahumai ba henimai. ");
INSERT INTO meu_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Mose ese idia sivaraidia na Iehova e hamaorolaia. ");
INSERT INTO meu_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Bena Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Selofehad natuna hahinedia edia hereva na maoro; tamadia varavarana bogaragadiai ahudia ba henidia; tamadia ahuna na idia ese bae abia. ");
INSERT INTO meu_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Ina danu, Israel taudia ba hamaorodia, baoto: Tau ta baine mase, asi natuna mase maruanena, natuna hahinena ese ia ahuna baine abia; ");
INSERT INTO meu_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","bema asi natuna hahinena danu, ahuna na tadikakana ba henia; ");
INSERT INTO meu_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","bema asi tadikakana, ahuna na tamana lahaidia ba henidia; ");
INSERT INTO meu_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","a bema asi:tamana lahaina ta, ahuna na varavara-dosina ba henia, ia ese baine abia. Ina na taravatu bona haheḡani Israel taudia ediai. Iehova ese Mose vada e henia heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Iehova ese Mose e haḡania, eto, Ina Abarim ororona ai ba dara dae, ba roha lao, Israel taudia vada na henidia tanona do ba itaia. ");
INSERT INTO meu_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ba itaia murinai oi na tubu tama dekediai ba hahebou, kakamu Aaron heḡereḡerena; ");
INSERT INTO meu_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","badina be Sin tano-ḡaḡaena ai umui raruosi ese o gwau edeede henigu, hebou taudia ese e heai henigu negana ai, ranu gabuna ai asio rimodaigu idia vairadiai. Una ranu ladana na Meriba; ia na Kade kahana ai, Sin tanoḡaḡaena ai. ");
INSERT INTO meu_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Bena Mose ese Iehova e haere henia, eto, ");
INSERT INTO meu_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Mani emu kara, Iehova, taunimanima iboudiai laumadia edia Dirava, ese tau ta baine abia hidi, ina orea taudia baine biagudia. ");
INSERT INTO meu_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Ia be vairadiai baine raka lasi bona vairadiai baine raka vareai; baine hakaudia lasi bona baine hakaudia vareai. Iehova ena orea taudia na basie noho kava, mamoe asi ireḡudia na heheto. ");
INSERT INTO meu_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Bena Iehova ese Mose e haḡania, eto, Iosua Nunu avabia: ia be lauma ese vada e rohea tauna; oi imamu na ia tubuana ai bavato kau. ");
INSERT INTO meu_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Bena ba haginia, hahelaḡa tauna Eleasara vairanai bona hebou taudia iboudiai vairadiai; bena idia vairadiai dagi ba henia. ");
INSERT INTO meu_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Oiemu siahu amo ba hasiahua; bena Israel oreana taudia iboudiai ese ia bae kamonai henia edia hebou ai. ");
INSERT INTO meu_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Ia be hahelaḡa tauna Eleasara vairanai baine gini, bena Eleasara ese ia dainai Iehova ena ura baine tahua, Urim ena amo; bena iena hereva dainai bae raka lasi bona iena hereva dainai bae raka vareai, ia bona Israel oreana taudia iboudiai. ");
INSERT INTO meu_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Bena Mose ese Iehova ena haheḡani heḡereḡerena mo e karaia: Iosua e abia, hahelaḡa tauna Eleasara bona hebou taudia iboudiai vairadiai e haginia; ");
INSERT INTO meu_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","bena imana na ia tubuana ai e atodia kau, dagi e henia, Iehova ena haheḡani Mose ena amo e henia heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Iehova ese Mose e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Israel taudia na ini ba haḡanidia toma, baoto: Egu boubou ḡaudia, Iahi ai o gabumu agu, bonana namo ḡaudia egu, ba lalodia tao bona ba henigu, nega korikoridia iboudiai. ");
INSERT INTO meu_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Ma ba hamaorodia, baoto: Lahi boubouna binai Iehova ba henia, dina ta ta amo mamoe natudia mamaruanedia, laḡani tamona ḡaudia asi bebeka-bebekadia, rua rua amo ba heni, emu ḡole-ohoboubouna ela hanaihanai. ");
INSERT INTO meu_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Mamoe natuna ta be daba ai ba henia, iharuana be adorahi ai ba henia. ");
INSERT INTO meu_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Flaoa namo-hereana efa ta ba karoaia, karoagwauta, bona dehoro negari-negarina hini ta ba karoaia, karoa hani; benaflaoa karoa ta bona dehoro karoa ta bavabi, ba bulo, ba gabu. ");
INSERT INTO meu_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Ina na ḡole-oho boubouna, dina iboudiai ba hahelaḡaia, Sinai ororona ai na haḡanimui heḡereḡerena; ia na bonana namo ḡauna, lahi boubouna, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Inuinu bouboudia danu ba heni: vine ranuna hini ta ba karoaia, karoa hani, bena karoa ta mamoe natuna ta ida, ma karoa ta mamoe natuna ta ida, unu ba heni toma; gabu helaḡana ai hari vine ranuna ba seia Iehova ena; emui inuinu boubouna bunai. ");
INSERT INTO meu_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Mamoe natuna iharuana na adorahi ai ba hahelaḡaia, flaoa boubouna bona inuinu boubouna danu, daba ai o hahelaḡadia heḡereḡerena; ia na lahi boubouna, bonana namo ḡauna, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Dina Helaḡa ai, mamoe natudia mamaruanedia rua, laḡani tamona ḡaudia asi bebeka-bebekadia, ba hahelaḡadia; bona flaoa namo-hereana efata ba karoaia, karoa gwauta, bena karoa rua dehoro ida ba bulo, bena ba hahelaḡaia; inuinu boubouna danu ba seia. ");
INSERT INTO meu_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Dina Helaḡa iboudiai ḡole-oho bouboudia unu ba heni toma, dina kavakava ena ḡole-oho boubouna bonaena inuinu boubouna ida ba heni hebou. ");
INSERT INTO meu_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Hua matamatadia ai Iehova ena ḡole-oho boubouna na ini ba heniatoma: boromakau natudia mamaruanedia rua, mamoe maruanena ta, bona mamoe natudia mamaruanedia hitu, laḡani tamona ḡaudia asi bebeka-bebekadia. ");
INSERT INTO meu_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Flaoa namo-hereana efa ta ba karoaia, karoa gwauta, bena karoa toi toibe dehoro ida ba bulo, boromakau natudia ta ta ida ba heni; bona karoa rua be dehoro ida ba bulo, mamoe maruanena ida ba heni. ");
INSERT INTO meu_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Ma efa ta ba karoaia, karoa gwauta, bena karoa ta ta be dehoro ida ba bulo, mamoe natudia ta ta ida ba heni. Ini be ḡole-oho boubouna ḡaudia, bonana namoḡaudia; bae haḡoledia oho, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","A edia inuinu bouboudia be iniheto: vine ranuna hini ta ba karoaia, karoa rua, bena karoa ta ta ba sei, boromakau natudia ta ta edia; ma hini ta ba karoaia, karoa toi, bena karoa ta ba seia, mamoe maruanena ena; ma hini rua ba karoadia, karoa hani hani amo, bena karoa ta ta ba sei, mamoe natudia ta ta edia. Ini na hua ta ta edia ḡole-oho boubou ḡaudia, laḡani huadia iboudiai lalodiai. ");
INSERT INTO meu_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Nani maruanena ta danu ba hahelaḡaia; ia na kara-dika iabi-ohona boubouna Iehova enai. Ini iboudiai na dina kavakava ena ḡole-oho boubouna bona ena inuinu boubouna ida ba heni hebou. ");
INSERT INTO meu_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Hua gini-gunana ena dina ihagwauta-hanina be Iehova ena Lagau-hanai. ");
INSERT INTO meu_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Ina hua ena dina ihagwauta-imana na aria dinana: dina hitu lalodia iasie hatubua flaoana mo bae ania. ");
INSERT INTO meu_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Dina gini-gunana ai hebou helaḡana bavabia. Una dina ai ḡaukara badana ta basio karaia, ");
INSERT INTO meu_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","a lahi boubouna ba haḡolea oho, Iehova ena: boromakau natudia mamaruanedia rua, mamoe maruanena ta, bona mamoe natudia mamaruanedia hitu, iboudiai na asi bebeka-bebekadia ḡaudia mo. ");
INSERT INTO meu_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Edia flaoa bouboudia danu ba haḡole oho: flaoa namo-hereana efa ta ba karoaia, karoa gwauta. Karoa toi toi bedehoro ida ba bulo, boromakau natudia ta ta ida ba heni; bona karoa rua be dehoro ida ba bulo, mamoe maruanena ida ba heni. ");
INSERT INTO meu_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Ma efa ta ba karoaia, karoa gwauta; bena karoa ta ta be dehoro ida ba bulo, mamoe natudia hituosi ta ta ida ba heni. ");
INSERT INTO meu_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Nani maruanena ta danu ba hahelaḡaia, emui kara-dika iabi-ohona boubouna, herohemaino ḡauna. ");
INSERT INTO meu_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Ini ḡau bevaia: daba iboudiai o haḡole oho ḡaudia ida ba heni hebou. ");
INSERT INTO meu_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Dina hituosi lalodiai unu mo ba kara toma, dina ta ta ai: boubou vamuna ba haḡolea oho, bonana namo ḡauna Iehova ena; ia bona dina kavakava ena ḡole-oho boubouna bona ena inuinu boubouna ba heni hebou. ");
INSERT INTO meu_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Dinaihahituna ai hebou helaḡana bavabia, una dina ai ḡaukara badana ta basio karaia. ");
INSERT INTO meu_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Uma anidia ba utu matama dinana ai, emui pura ariana ai flaoa matamatana boubouna ba hahelaḡaia, Iehova ena; una negana ai hebou helaḡana bavabia, bona ḡaukara badana ta basio karaia. ");
INSERT INTO meu_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Ḡole-oho boubouna bahahelaḡaia, bonana namo ḡauna Iehova ena: boromakau natudia mamaruanedia rua, mamoe maruanena ta, bona mamoe natudia mamaruanedia hitu, laḡani tamona ḡaudia. ");
INSERT INTO meu_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Edia flaoa bouboudia danu ba haḡole oho: flaoa namohereana efa ta ba karoaia, karoa gwauta. Karoa toi toi be dehoro ida ba bulo, boromakau natudia ta ta ida ba heni; bona karoa rua be dehoro ida ba bulo, mamoe maruanena ida ba heni. ");
INSERT INTO meu_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Ma efa ta ba karoaia, karoa gwauta; bena karoa ta ta be dehoro ida ba bulo, mamoe natudia hituosi ta ta ida ba heni. ");
INSERT INTO meu_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Nani maruanena ta danu ba hahelaḡaia, emui herohemaina ḡauna. ");
INSERT INTO meu_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Ini ḡau be vaia emui ḡole-oho bouboudia mai edia flaoa bouboudia ida ba heni hebou. Ba ita, asi bebeka-bebekadia ḡaudia mo ba hahelaḡadia. Inuinu bouboudia danu ba sei. ");
INSERT INTO meu_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Hua ihahituna ena dina gini-gunana ai, umui na hebou helaḡana ta bavabia; una dina ai ḡaukara badana ta basio karaia. Una dina ai danu kibi ba hiriri, ");
INSERT INTO meu_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","bona ḡole oho boubouna ba hahelaḡaia, bonana namo ḡauna Iehova ena: boromakau natuna maruanena ta; mamoe maruanena ta; bona mamoe natudia mamaruanedia hitu, laḡani tamona ḡaudia, asi bebeka-bebekadia. ");
INSERT INTO meu_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Edia flaoa bouboudia danu ba haḡole oho: a flaoa namo-hereana efa ta ba karoaia, karoa gwauta. Karoa toi dehoro ida; a babulo, boromakau ida ba heni; bona karoa rua dehoro ida ba bulo, mamoe maruanena ida ba heni. ");
INSERT INTO meu_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","Ma efa ta ba karoaia, karoa gwauta, bena karoa ta ta be dehoro ida ba bulo, mamoe natudia hituosi ta ta ida ba heni. ");
INSERT INTO meu_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Nani maruanena ta danu ba hahelaḡaia, kara-dika iabi-ohona ḡauna, emui herohemaino ḡauna. ");
INSERT INTO meu_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Ini ḡau be hua matamatana ena ḡole-oho boubouna mai ena flaoa boubouna ida, bona dina kavakava ena ḡole-oho boubouna mai ena flaoa boubouna bona mai edia inuinu bouboudia ida, ba heni hebou, taravatu heḡereḡeredia. Idia na bonana namo ḡauna, Iahi boubouna, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Hua ihahituna ena dina ihagwautana ai, umui na hebou helaḡana ta bavabia. Ba vaga, bona ḡaukara badana ta basio karaia. ");
INSERT INTO meu_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Una dina ai ḡole-oho, boubouna ba hahelaḡaia, bonana namo ḡauna Iehova ena: boromakau natuna maruanena ta; mamoe maruanena ta; bona mamoe natudia mamaruanedia hitu, laḡani tamona ḡaudia, asi bebeka-bebekadia. ");
INSERT INTO meu_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Edia flaoa bouboudia danu ba haḡole oho: flaoa namo-hereana efa ta ba karoaia, karoa gwauta. Karoa toi dehoro ida ba bulo, boromakau ida ba heni; bona karoa rua dehoro ida ba bulo, mamoe maruanena ida ba heni. ");
INSERT INTO meu_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","Ma efa ta ba karoaia, karoa gwauta, bena karoa ta ta be dehoro ida ba bulo, mamoe natudia hituosi ta ta ida ba heni. ");
INSERT INTO meu_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Nani maruanena ta danu ba hahelaḡaia, kara-dika iabi-ohona boubouna. Ini be herohemaino boubouna ida bona ḡole-oho boubouna, dina iboudiai e heni louloumu ḡauna, mai ena flaoa boubouna bona edia inuinu bouboudia ida, ba heni hebou. ");
INSERT INTO meu_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Hua ihahituna ena dina ihagwauta-imana ai, umui na hebou helaḡanata bavabia. Ḡaukara badana ta basio karaia; dina hitu lalodiai aria ba karaia, Iehova ena. ");
INSERT INTO meu_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Emui ḡole-oho boubouna na lahi ai ba haḡolea oho, bonana namo ḡauna Iehova ena: boromakau natudia mamaruanedia gwauta-toi; mamoe mamaruanedia rua; bona mamoe natudia mamaruanedia gwauta-hani, laḡani tamona ḡaudia, asi bebeka-bebekadia. ");
INSERT INTO meu_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Edia flaoa bouboudia ḡaudia danu ba haḡole oho: flaoa namo-hereana efa tauratoi bae karoadia, karoa gwauta gwauta amo. Bena karoa toi toi be boromakau gwauta-toiosi ta ta ida ba heni; karoa rua rua amo be mamoe mamaruanedia ruaosi ida ba heni; ");
INSERT INTO meu_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","bona karoa ta ta be mamoe natudia gwauta-haniosi ta ta ida ba heni. ");
INSERT INTO meu_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Nani maruanena ta danu ba hahelaḡaia, kara-dika iabi-ohona boubouna. Ini iboudiai be dina kavakava ena ḡole-oho boubouna, mai ena flaoa boubouna bona ena inuinu boubouna ida, ba heni hebou. ");
INSERT INTO meu_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Aria dinana iharuana ai, emui boubou be boromakau natudia mamaruanedia gwauta-rua, mamoe mamaruanedia rua, bona mamoe natudiamamaruanedia gwauta-hani, laḡani tamona ḡaudia, asi bebeka-bebekadia. ");
INSERT INTO meu_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Flaoa bouboudia bona inuinu bouboudia danu ba heni, boromakau ta ta edia, mamoe mamaruanedia ta ta edia, bona mamoe natudia ta ta edia, taravatu heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Nani maruanena ta danu ba hahelaḡaia kara-dika iabi-ohona boubouna. Ini iboudiai be dina kavakava ena ḡole-oho boubouna, mai ena flaoa boubouna bona edia inuinu bouboudia ida, ba heni hebou. ");
INSERT INTO meu_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Dina ihatoina ai emui boubou be boromakau mamaruanedia gwauta-ta, mamoe mamaruanedia rua, bona mamoe natudia mamaruanedia gwauta-hani, laḡani tamona ḡaudia, asi bebeka-bebekadia. ");
INSERT INTO meu_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Flaoa bouboudia bona inuinu bouboudia danu ba heni, boromakau ta ta edia, mamoe mamaruanedia ta ta ta edia, bona mamoe natudia ta ta edia, taravatu heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Nani maruanena ta danu ba hahelaḡaia, kara-dika iabi-ohona boubouna. Ini iboudiai be dina kavakava ena ḡole-oho boubouna, mai ena flaoa boubouna bona ena inuinu boubouna ida ba heni hebou. ");
INSERT INTO meu_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Dina ihahanina ai emui boubou be boromakau mamaruanedia gwauta, mamoe mamaruanedia rua, bona mamoe natudia mamaruanedia gwauta-hani, laḡani tamona ḡaudia, asi bebeka-bebekadia. ");
INSERT INTO meu_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Flaoa bouboudia bona inuinu bouboudia danu ba heni, boromakau ta ta edia, mamoe mamaruanedia ta ta edia, bona mamoe natudia ta ta edia, taravatu heḡereḡeredia. ");
INSERT INTO meu_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Nani maruanena ta danu ba hahelaḡaia, kara-dika iabi-ohona boubouna. Ini iboudiai be dina kavakava ena ḡole-oho boubouna, mai ena flaoa boubouna bona ena inuinu boubouna ida ba heni hebou. ");
INSERT INTO meu_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Dina iha-imana ai emui boubou be boromakau mamaruanedia taurahani-ta, mamoe mamaruanedia rua, bona mamoe natudia mamaruanedia gwauta-hani, laḡani tamona ḡaudia, asi bebeka-bebekadia. ");
INSERT INTO meu_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Flaoa bouboudia bona inuinu bouboudia danu ba heni, boromakau ta ta edia, mamoe mamaruanedia ta ta edia, bona mamoe natudia ta ta edia, taravatu heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Nani maruanena ta danu ba hahelaḡaia, kara-dika iabi-ohona boubouna. Ini iboudiai be dina kavakava ena ḡole-oho boubouna, mai ena flaoa boubouna bona ena inuinu boubouna ida, ba heni hebou. ");
INSERT INTO meu_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Dina ihatauratoina ai emui boubou be boromakau mamaruanedia taurahani, mamoe mamaruanedia rua, bona mamoe natudia mamaruanedia gwauta-hani, laḡani tamona ḡaudia, asi bebeka-bebekadia. ");
INSERT INTO meu_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Flaoa bouboudia bona inuinu bouboudia danu ba heni, boromakau ta ta edia, mamoe mamaruanedia ta ta edia, bona mamoe natudia ta ta edia, taravatu heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Nani maruanena ta danu ba hahelaḡaia, kara-dika iabi-ohona boubouna. Ini iboudiai be dina kavakava ena ḡole-oho boubouna, mai ena flaoa boubounabona ena inuinu bouboudia ida, ba heni hebou. ");
INSERT INTO meu_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Dina ihahituna ai, emui boubou be boromakau mamaruanedia hitu, mamoe mamaruanedia rua, bona mamoe natudia mamaruanedia gwauta-hani, laḡani tamona ḡaudia, asi bebeka-bebekadia. ");
INSERT INTO meu_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Flaoa bouboudia bona inuinu bouboudia danu ba heni, boromakau ta ta edia, mamoe mamaruanedia ta ta edia, bona mamoe natudia ta ta edia, taravatu heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Nani maruanena ta danu ba hahelaḡaia, kara-dika iabi-ohona boubouna. Ini iboudiai be dina kavakava ena ḡole-oho boubouna, mai ena flaoa boubouna bona ena inuinu boubouna ida, ba heni hebou. ");
INSERT INTO meu_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Dina ihataurahanina ai, umui na hebou helaḡana ta bavabia; una dina ai ḡaukara badana ta basio karaia. ");
INSERT INTO meu_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Ḡole-oho boubouna ba haḡolea oho, bonana namo ḡauna, Iehova ena: boromakau maruanena ta, mamoe maruanena ta, bona mamoe natudia mamaruanedia hitu, laḡani tamona ḡaudia, asi bebeka-bebekadia. ");
INSERT INTO meu_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Flaoa boubouna bona inuinu bouboudia danu baheni, boromakau; ena, bona mamoe maruanena ena, bona mamoe natudia ta ta edia, taravatu heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Nani maruanena ta danu ba hahelaḡaia, kara-dika iabi-ohona boubouna. Ini iboudiai be dina kavakava ena ḡole-ohoboubouna, mai ena flaoa boubouna bona ena inuinu boubouna ida, ba heni hebou. ");
INSERT INTO meu_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Ini iboudiai na Iehova ba henia, emui aria dinadia ai, emui gwau-hamata ḡaudia bona emui herahia ḡaudia ida. Emui ḡole-oho bouboudia bona emui flaoa bouboudia bona emui inuinu bouboudia bona emui herohemaino bouboudia unu ba heni toma. ");
INSERT INTO meu_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Bena Mose ese ini hereva iboudiai na Israel taudia e hamaorolaidia, Iehova ese ia e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Mose ese Israel iduhudia lohiadia e hereva henidia, eto, Iehova ena haheḡani binai: ");
INSERT INTO meu_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","tau ta ese Iehova baine gwau henia hamata, eiava Iehova vairanai baine gwau hamata kara ta baine karaia, ia na basine koikoi; ena gwau hamata do baine hamomokania. ");
INSERT INTO meu_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Tamana ena ruma ai nohona ai, hane-ulato ta ese Iehova baine gwau henia hamata, bona Iehova vairanai baine gwau hamata kara ta baine karaia, ");
INSERT INTO meu_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","bena tamana ese ena gwau hamata baine kamonai a hereva ta basine gwauraia, una hane-ulato ena gwau hamata baine gini. ");
INSERT INTO meu_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","A ena gwau hamata baine kamonai negana ai tamana ese baine gwaua tao, ena gwau hamata na asi anina: Iehova ese danu baine gwaua tao, badina be hane-ulato tamana ese e gwaua tao. ");
INSERT INTO meu_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Hane-ulato ese ena gwau hamata karana do basine haḡuḡurua negana ai baine headava, ");
INSERT INTO meu_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","bena adavana ese ena gwau hamata sivaraina baine kamonai dinana ai hereva ta basine gwauraia, una hahine ena gwau hamata baine gini, anina do baine karaia. ");
INSERT INTO meu_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","A baine kamonai dinana ai adavana ese baine gwaua tao, ena gwau hamata na asi anina; Iehova ese danu baine gwaua tao. ");
INSERT INTO meu_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Vabu ta, eiava diho hahinena ta, ena gwau hamata do baine gini, anina do baine karaia. ");
INSERT INTO meu_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Bema adavana dekenai e nohova ai na e gwau hamata, ");
INSERT INTO meu_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","bena adavana na e kamonai a hereva ta se gwauraia; gwauraia bona se gwaua tao, ena gwau hamata do baine gini, anina baine karaia. ");
INSERT INTO meu_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","A bema e kamonai dinana ai adavana ese e gwaua tao, ena gwau hamata na basine gini: adavana ese vada e gwaua tao; Iehova ese danu baine gwaua tao. ");
INSERT INTO meu_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Hahine ena gwau hamata adavana ese baine hamomokania diba, eiava baine gwaua tao diba. ");
INSERT INTO meu_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","A dina haida baela, adavana ese hereva ta basine gwauraia, una be ena gwau hamata hamomokania karana; vada e hamomokania, badina be e kamonai dinana ai ia na se hereva. ");
INSERT INTO meu_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","A baine kamonai murinai baine gwaua tao, hahine ena kerere be ia ese baine huaia. ");
INSERT INTO meu_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Iehova ena haheḡani bunu, ia ese Mose e henia: tau mai adavana ida taravatudia, bona tau mai natuna kekenina ida taravatudia, kekeni na tamana ena ruma nohona ai. ");
INSERT INTO meu_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Iehova ese Mose na e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Midian taudia ese Israel taudia vada e ala-ala henidia davana na bavala-ala henidia; una murinai tubu tama dekediai ba hahebou. ");
INSERT INTO meu_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Taunabunai Mose ese Israel taudia e hamaorodia, eto, Umui bogaragimui amo haida ese edia tuari ḡaudia bae abi heḡaeḡae, Midian taudia bae tuari henidia, edia kara davana Iehova ese vada e gwauraia do ba kara henidia. ");
INSERT INTO meu_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Israel iduhudia ta ta amo tuari taudia daha-ta daha-ta ba siaidia. ");
INSERT INTO meu_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Taunabunai Israel taudia loḡora edia amo iduhu ta ta edia daha-ta ta ta e siaidia: tuari taudia iboudiai be gerebu-ta daha-rua. ");
INSERT INTO meu_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Bena Mose ese e siaidia, bae tuari; iduhu ta ta amo daha-ta ta ta e siaidia. Hahelaḡa tauna Fineha Eleasara danu e siaia; ia ese gabu helaḡana kohudia imana ai e abi kau, bona tuari kibidia danu. ");
INSERT INTO meu_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Bena idia ese Midian taudia e tuari henidia, Iehova ese Mose e haḡania heḡereḡerena; bena mamaruanedia iboudiai e aladia ore. ");
INSERT INTO meu_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Midian pavapavadia laimaosi danu e aladia mase: Evi bona Rekem bona Suru bona Huru bona Reba. Balaam Beoro danu dare amo e alaia mase. ");
INSERT INTO meu_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Midian hahinedia mai natudia ida Israel taudia ese e abidia mauri; edia boromakau iboudiai bona edia mamoe iboudiai bona edia kohu idoinai danu e abi. ");
INSERT INTO meu_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Edia hanua iboudiai bona edia taruha iboudiai e doudia ore; ");
INSERT INTO meu_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","bena e abi kohudia e laohai, bona ubu-ubu ḡaudia bona taunimanima danu e hakaudia lao. ");
INSERT INTO meu_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Bena abi-mauri taudia bona seri bona kohu na e laohaidia, Mose bona hahelaḡa tauna Eleasara dekediai, Israel taudia edia hebou ai e hahedinaraidia, edia taruha ai, Ieriko ai, Moab taorana ai, Ioridane sinavaina isena ai. ");
INSERT INTO meu_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Bena Mose bona hahelaḡa tauna Eleasara bona orea lohiadia na e raka lasi dekediai, taruha murimurinai idia ida e hedavari. ");
INSERT INTO meu_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Bena Mose ese tuari lohiadia, daha-ta ta ta biagudia bona sinahu ta ta biagudia, tuari amovada e lou mai, na e badu henidia; ");
INSERT INTO meu_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","e gwau henidia, eto, Dahaka dainai hahine iboudiai o hamauridia? ");
INSERT INTO meu_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","A laloa, idia ese Balaam ena hereva amo Israel taudia e hahekwakwanaidia, Peoro ororona ai, bena gorere ese Iehova ena orea taudia e hamasedia. ");
INSERT INTO meu_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Taunabunai, memero iboudiai bavaladia mase, bona hahine iboudiai danu; ");
INSERT INTO meu_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","a kekeni bona ulato na ba hamauridia, bavabidia emui. ");
INSERT INTO meu_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Bena dina hitu taruha murimurinai ba noho, taunimanima o aladia mase eiava mase taudia ediai o dau kau taumui iboumui ai. Dina ihatoina ai bona dina ihahituna ai ba haheḡoeva, bona emui abi-mauri kekenidia bona ulatodia ba haḡoevadia. ");
INSERT INTO meu_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Emui, dabua danu, bona kopi eiava nani huidia eiava au amo e kara taudia, iboudiai ba haḡoevadia. ");
INSERT INTO meu_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Bena hahelaḡa tauna Eleasara ese tuari ela taudia e hamaorodia, eto, Haheḡani binai, Iehova ese Mose vada e henia: ");
INSERT INTO meu_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","gold bona silver bona auri labora-labora bona auri bona tin bona lead, ");
INSERT INTO meu_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","lahi ai ba gabu diba ḡaudia, iboudiai na lahi ai ba gabudia, bena bae ḡoeva. A ranu helaḡa ai ba huridia danu; bona basio gabu diba ḡaudia danu ranu ai ba huridia. ");
INSERT INTO meu_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Bena dina ihahituna ai emui dabua ba huridia, bena ba ḡoeva. Una murinai umui na taruha lalonai ba raka vareai. ");
INSERT INTO meu_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Iehova ese Mose e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Tuari ai e abi ḡaudia, taunimanima bona ubu-ubu ḡaudia, ba hagaudia, oi bona hahelaḡa tauna Eleasara bonaorea lohiadia ese. ");
INSERT INTO meu_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Bena ba haridia, ahu rua: ta be tuari ela taudia ahudia, a ta be kone-noho taudia ahudia. ");
INSERT INTO meu_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Bena tuari ela taudia ahudia ai, sinahu ima ima amo ta ta ba hahelaḡadia Iehova ena, taunimanima bona boromakau bona doniki bona mamoe; ");
INSERT INTO meu_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","idia ahudia amo bavabidia, hahelaḡa tauna Eleasara ba henia, boubou ḡaudia ai baela, baine dudui isi Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","A kone-noho taudia ahudia ai, imahui imahui amo ta ta ba hahelaḡadia, taunimanima bona boromakau bona doniki bona mamoe; bena Levi taudia, Iehova ena dubu e reḡuamu taudia, ba henidia. ");
INSERT INTO meu_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Bena Eleasara bona Mose na unu e kara toma, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Tuari taudia ese vada e abidia mauri ḡaudia bini: mamoe 675,000, ");
INSERT INTO meu_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","boromakau 72,000, ");
INSERT INTO meu_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","doniki 61,000, ");
INSERT INTO meu_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","bona taunimanima 32,000, iboudiai na kekeni bona ulato. ");
INSERT INTO meu_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Tuari ela taudia ahudia bini: mamoe 337,500, ");
INSERT INTO meu_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","unu amo Iehova ahuna na 675; ");
INSERT INTO meu_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","boromakau 36,000, unu amo Iehova ahuna na 72; ");
INSERT INTO meu_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","doniki 30,500, unu amo Iehova ahuna na 61; ");
INSERT INTO meu_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","bona taunimanima 16,000, unu amo Iehova ahuna na 32. ");
INSERT INTO meu_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Mose ese Iehova ahuna e abia, boubou ḡauna hahelaḡa tauna Eleasara e henia, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Kone-noho taudia ahudia, Mose ese tuari ela taudia ahudia amo ehididia ḡaudia, ");
INSERT INTO meu_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","na iniheto: mamoe 337,500, ");
INSERT INTO meu_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","boromakau 36,000, ");
INSERT INTO meu_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","doniki 30,500, ");
INSERT INTO meu_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","bona taunimanima 16,000. ");
INSERT INTO meu_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Bena idia ahudia ai Mose ese imahui imahui amo ta ta e abidia, taunimanima bona ubu-ubu ḡaudia; bena ia ese Levi taudia, Iehova ena dubu e reḡuava taudia, e henidia, Iehova ese Mose e haḡania heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Bena tuari lohiadia, daha-ta ta ta biagudia bona sinahu ta ta biagudia, ese Mose e raka henia kahi, ");
INSERT INTO meu_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","eto, Emu hesiai taudia ese tuari taudia ai henumai ai vada e duahidia ore, ta se boio. ");
INSERT INTO meu_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Bena herahia ḡaudia vada a mailaidia, Iehova ena, gold ḡaudia tuari ai e abi: ima vaḡivaḡidia bona bae vaḡivaḡidia bona kwakikwaki vaḡivaḡidia, bona gadei, bona ageva; emai herohemaino ḡaudia Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Bena Mose bona hahelaḡa tauna Eleasara ese hari gold ḡaudia idau-idau idia imadia amo e abidia. ");
INSERT INTO meu_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Hari gold idoinai, daha-ta ta ta biagudia bona sinahu ta ta biagudia ese e mailaia, edia herahia ḡauna Iehova bae henia eto, ena metau be sekele 16,750. ");
INSERT INTO meu_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Badina be tuari taudia ta ta ese edia kohu vada e gogo una tuari ai. ");
INSERT INTO meu_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Bena Mose bona hahalaḡa tauna Eleasara ese hari daha ta ta biagudia bona sinahu ta ta biagudia e heni gold-na e abia, hebou kalagana ai e vareailaia, Iehova vairanai Israel taudia ihelalolaidia ḡaudia a ai bainela totona. ");
INSERT INTO meu_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Ruben bona Gad garadia edia seri na momo herea; bena idia ese lasere tanona bona Gilead tanona e itadia, idia na tano namohereadia, seri iubulaidia. ");
INSERT INTO meu_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Taunabunai unu iduhu ruaosi taudia na Mose dekena ela, Mose bona hahelaḡa tauna Eleasara bona hebou biagudia e hereva henidia, eto, ");
INSERT INTO meu_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Ataroto bona Dibon bona lasere bona Nimra bona Hesebon bona Eleale bona Sebam bona Nebo bona Beon tanodia bini, ");
INSERT INTO meu_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","Iehova ese Israel oreana tauda imada ai vada e heni, na seri iubulaidia tanodia namodia; bona ai bini emu hesiai taumai emai seri na momo herea. ");
INSERT INTO meu_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Idia ma eto, Oi lalomu bema namo emai ai, mani emu kara ina tano boma henimai, emai tano; basio hakaumai hanai, Ioridane sinavaina unukahana ai. ");
INSERT INTO meu_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","A Mose ese Ruben bona Gad iduhudia taudia e gwau henidia, eto, Varavaramui ma bae ha tuari, a umui be iniseni ai ba helai diho a? ");
INSERT INTO meu_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Dahaka dainai Israel taudia lalodia ba hamanokadia, Iehova ese vada e henidia tanona ai basie raka vareai o tomu? ");
INSERT INTO meu_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Tamamui na unu e kara toma, lau ese Kade-baranea amo na siaidia tano bae hasinadoa negana ai. ");
INSERT INTO meu_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Idia na ela, Eskol kourana ai e lasi, tano e itaia, bena e lou, Israel taudia lalodia e hamanokadia, Iehova ese vada e henidia tanona ai basie raka vareai eto. ");
INSERT INTO meu_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Una dina ai Iehova ena badu e vara, bena e gwau hamata, eto ");
INSERT INTO meu_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","“Momokani, Israel taudia Aigupto amo vada e raka lasi, laḡani ruahui vada e hanai taudia iboudiai, ta ese lau vada na gwauraia hamata, Abraham bona Isaak bona Iakob baina henidia nato, tanona basine itaia, lasi vaitani, badina be idia na asie abidadama henigu; ");
INSERT INTO meu_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","una dainai Kaleb lefune, Kenisi tauna, bona Iosua Nunu mo bae itaia, badina be idia raruosi mo Iehova vada e abidadama henia”. ");
INSERT INTO meu_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Una negana ai Iehova ese Israel taudia e badu henidia, e siaidia lao, laḡani hari-ahui tano ḡagaena ai e loaloava, ela bona Iehova vairanai e kara havara uruna idoinai vada e mase ore. ");
INSERT INTO meu_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Matona, umui na tamamui gabudia ai vada o vara isi, kara havara uruna ta, Iehova ena badu Israel latanai ihabadana. ");
INSERT INTO meu_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Badina be umui na ia iḡavana amo ba raka siri, ia ese idia ma baine siaidia tano ḡaḡaena ai ma bae noho; bena ina bese idoinai baine dika umui daimui ai. ");
INSERT INTO meu_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Bena idia na e raka henia kahi, eto, Iniseni ai maḡu baia kara, emai seri ikoulaidia, bona hanua baia hadai, natumai maraḡidia bae noholai. ");
INSERT INTO meu_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","A tuari be baia tuari, Israel taudia vairadiai baiala, ela bona edia gabu ai baia hakaudia lao. Ḡau; au tamona, natumai maraḡidia be hanua mai maḡudia lalodiai bae noho, ina tano taudia daidiai. ");
INSERT INTO meu_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","A ai be emai ruma basia lou heni ela bona Israel taudia iboudiai ahudia bae abi. ");
INSERT INTO meu_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Ai ahumai na idia ida Ioridane sinavaina unukahana ai eiava gabu ta ai basia abi, badina be ahumai na Ioridane sinavaina inikahana ai vada a abi, mairiveina kahana ai. ");
INSERT INTO meu_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Bena Mose ese e haere henidia, eto, Ene boma kara toma: emui tuari ḡaudia bavabi, Iehova vairanai ba raka lasi, tuari baola. ");
INSERT INTO meu_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Emui tuari taudia iboudiai na Ioridane sinavaina bae hanaia, Iehova vairanai, ela bona ana inai taudia na vairadiai baine luludia Iasi, ");
INSERT INTO meu_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","bona tano idoinai na Iehova ena tano ai bae halaoa. Una murinai vada ba lou mai, asi emui kerere Iehova vairanai bona Israel taudia vairadiai; bena ina tano bavabia emui, Iehova vairanai. ");
INSERT INTO meu_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","A ene basioma kara toma, umui na ba kerere Iehova vairanai: emui kara dika davana do bavabia. ");
INSERT INTO meu_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Benaini, hanua ba hadai, natumui maraḡidia bae noholai; bona maḡu ba kara, emui mamoe edia. Una murinai emui gwau hamata ba hamomokania. ");
INSERT INTO meu_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Bena Gad bona Ruben iduhudia taudia ese Mose e haere henia, eto, Ai bini emu hesiai taumai na oi lohia taumu emu haheḡani heḡereḡerena baia karaia. ");
INSERT INTO meu_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Natumai maraḡidia bona adavamai bona emai mamoe bona emai boromakau na iniseni ai bae noho, Gilead hanuadia ai; ");
INSERT INTO meu_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","a ai bini, emu hesiai taumai, na Iehova vairanai baia hanai, tuari mai dibamai taumai iboumai ai, baia tuari, oi lohia taumu emu haheḡani heḡereḡerena. ");
INSERT INTO meu_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Taunabunai, Mose ese idia herevadia na hahelaḡa tauna Eleasara bona Iosua Nunu bona Israel iduhudia lohiadia e haḡanilaidia; ");
INSERT INTO meu_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","eto, Bema Gad bona Ruben iduhudia taudia na umui ida Ioridane sinavaina bae hanaia, mai edia tuari ḡaudia, Iehova vairanai, bena tano idoinai bavabia emui, umui ese Gilead tanona do ba henidia, edia tano. ");
INSERT INTO meu_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","A edia tuari ḡaudia basie abidia, umui ida basie hanai, idia na umui ida ahumui bae abi Kanaan tanona ai. ");
INSERT INTO meu_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Bena Gad bona Ruben iduhudia taudia eto, Iehova ese emu hesiai taumai vada e haḡanimai heḡereḡerena, unu baia kara toma. ");
INSERT INTO meu_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Emai tuari ḡaudia imamai ai baia abi, Iehova vairanai baia hanai, Kanaan tanona ai; bena ahumai ba henimai Ioridane sinavaina inikahana ai. ");
INSERT INTO meu_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Taunabunai Mose ese Gad iduhuna bona Ruben iduhuna bona Manase Iosef ena iduhu kahana na Sihon, Amoro pavapavana, bona Og, Basan pavapavana, edia basileia e henidia, edia tano idoidiai bona edia hanua iboudiai. ");
INSERT INTO meu_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Bena Gad iduhuna taudia ese ini hanua mai maḡudia e hadai: Dibon bona Ataroto bona Aroere, ");
INSERT INTO meu_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","bona Atroto-sofan bona lasere bona logobeha, ");
INSERT INTO meu_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","bona Bete-nimra bona Bete-haran. Edia seri maḡudia danue kara. ");
INSERT INTO meu_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Ruben iduhuna taudia danu hanua mai maḡudia e hadai: Hesebon bona Eleale bona Kiriataimi, ");
INSERT INTO meu_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","bona Nebo bona Baal-meono (ini ruaosi ladadiae ha-idau) bona Sibma. Idia e hadai hanuadia na ladadia idaudia e henidia. ");
INSERT INTO meu_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","A Makiri Manase ena iduhu taudia na Gilead tanona ela, bena e abia, Amoro taudia unuseni ai e nohova na e luludia lasi. ");
INSERT INTO meu_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Bena Mose ese Gilead tanona na Makiri Manase e henia, ena noho gabuna. ");
INSERT INTO meu_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Bena Iairi Manase ela, Gilead hanuadia e abidia, ladadia e hato Havoto-iairi. ");
INSERT INTO meu_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","BonaNoba na ela, Kenat tanona mai ena hanua ida e abidia, ladana e hatoa Noba, ia e nemaia. ");
INSERT INTO meu_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Israel taudia edia laolao daladia bini. Mose bona Aaron ese orea ta ta ai Aigupto amo e hakaudia lasi negana ai, ");
INSERT INTO meu_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Iehova ese Mose e haḡania, bena Mose ese edia taruha sivaraidia bona edia tore-isi sivaraidiae tore. Edia tore-isi bona edia taruha herevadia bini: ");
INSERT INTO meu_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","hua gini-gunana ena dina ihagwauta-imana ai, idia na Ramese amo e raka lasi; lagau-hanai murina dinana ai Israel taudia na Iehova ena siahu ai e raka lasi, Aigupto taudia iboudiai vairadiai, ");
INSERT INTO meu_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Aigupto taudia ese natudia roboadia e guridia dinana ai. Badina be Iehova ese natudia roboadia vada e aladia mase, bona edia dirava danu vada e hahemaoro henidia. ");
INSERT INTO meu_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Taunabunai Israel taudia na Ramese amo ela, bona Sukoto ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Sukoto amo e tore isi, ela, Etam ai e taruha, tano ḡagaena isena ai. ");
INSERT INTO meu_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Etam amo e tore isi, e lou ela, Pi-hahiroto ai e kau: una na Baal-sefon mairiveina kahana ai. Bena Migdol ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Ma e laolao, Hahiroto badina amo ela, davara e rakaia hanai, tano ḡaḡaena ai e kau; bena dina toi idia na Etam tano-ḡaḡaena ai e laolao, Mara ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Mara amoe tore isi, ela, Elim ai e kau. Una gabu ai ranu guridia na gwauta-rua, bona pamu audia na hitu-ahui. Bena unuseni ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Elim amoe tore isi, ela, Davara Kakakakana isena ai e taruha; ");
INSERT INTO meu_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","unu amo ma ela, Sin tano-ḡaḡaena ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Sin tano-ḡaḡaena amo e tore isi, ela, Dofka ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Dofka amo e tore isi, ela, Alusu ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Alusu amo e tore isi, ela, Refidim ai e taruha; unuseni ai inuinu ranuna ai e dabu. ");
INSERT INTO meu_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Refidim amo e tore isi, ela, Sinai tano-ḡaḡaena ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Sinai tano-ḡaḡaena amo e tore isi, Kibroto-hatava ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Kibroto-hatava amo e tore isi, ela, Haseroto ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Haseroto amo e tore isi, ela, Ritma ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Ritma amo e tore isi, ela, Rimon-perese ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Rimon-perese amo e tore isi, ela, Libna ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Libna amo etore isi, ela, Risa ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Risa amo e tore isi, ela, Kehelata ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Kehelata amo e tore isi, ela, Sefere ororona ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Sefere ororona amo e tore isi, ela, Harada ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Harada amo e tore isi, ela, Makeloto ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Makeloto amo e tore isi, ela, Tahata ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Tahata amo e tore isi, ela, Tera ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Tera amo e tore isi, ela, Mitka ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Mitka amo e tore isi, ela, Hasamona ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Hasamona amo e tore isi, ela, Moseroto ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Moseroto amo e tore isi, ela, Bene-iakan ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Beneiakan amo e tore isi, ela, Horo-hagidigad ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Horo-hagidigad amo e tore isi, ela, Iotobata ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Iotobata amo e tore isi, ela, Abrona ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Abrona amo e tore isi, ela, Esiono-gebere ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Esiono-gebere amo e tore isi, ela, Sin tano-ḡaḡaena ai e taruha (ladanata be Kade). ");
INSERT INTO meu_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Kade amo e tore isi, ela, Horo ororona ai e taruha, Edom tano hetoana ai. ");
INSERT INTO meu_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Bena hahelaḡa tauna Aaron na ororo ai e dara dae, Iehova ena haheḡani dainai. Unuseni ai e mase, laḡani hari-ahui vada ela Israel taudia Aigupto tanona amo e raka Iasi murinai. Hua be hua iha-imana; dina be dina ginigunana. ");
INSERT INTO meu_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aaron ena vara laḡanidia na sinahu-ta ruahui toi, Horo ororonaai e mase negana ai. ");
INSERT INTO meu_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Israel taudia vada ema harina na Kanaan lohiana ta, Arada pavapavana, ese e kamonai. Ia be diho kahana ai e nohova, Kanaan ai. ");
INSERT INTO meu_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Horo ororona amo e tore isi, ela, Salmona ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Salmona amo e tore isi, ela, Punon ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Punon amo e tore isi, ela, Oboto ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Oboto amo e tore isi, ela, Ie-abarim ai e taruha, Moab tanona ai. ");
INSERT INTO meu_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Ie amo e tore isi, ela, Dibon-gad ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Dibon-gad amo e tore isi, ela, Almon-diblataim ai e taruha. ");
INSERT INTO meu_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Almon diblataim amo e tore isi, ela, Abarim ororodia ai e taruha, Nebo vairanai. ");
INSERT INTO meu_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Abarim ororodia amo e tore isi, ela, Ieriko ai e taruha, Ioridane sinavaina isena ai, Moab taorana ai. ");
INSERT INTO meu_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Edia taruha na Ioridane sinavaina isena ai, Bet-iesimoto amo ela bona Abele-sitim, Moab taorana ai. ");
INSERT INTO meu_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Bena Ieriko ai, Ioridane sinavaina isena ai, Moab taorana ai, Iehova ese Mose e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Israel taudia ba hamaorodia, baoto: Ioridane sinavaina ba hanaia, Kanaan tanona ai ba kau, negana ai, ");
INSERT INTO meu_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","una tano taudia iboudiai na vairamui ai ba luludia lasi; edia nadi helaḡadia iboudiai ba ḡiḡidia rohoroho, edia kaivakuku iboudiai ba doudia, edia atai gabudia helaḡadia iboudiai ba habuadia tari. ");
INSERT INTO meu_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Tano bavabia emui, ba noholaia: badina be tano na vada na henimui, emui tano korikori. ");
INSERT INTO meu_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Tano na mari amo ba haria, iduhu ta ta ahuna ahuna bae abi: iduhu badana be tano badana ba henia, iduhu maraḡina be tano maraḡina ba henia. Tau ta ese mari ai tano ta baine abia, una na iena tano. ");
INSERT INTO meu_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","A tano taudia iboudiai basioma luludia lasi vairamui ai, bae noho taudia na ḡahu vairamui ai eiava ginigini kopimui ai na heheto bae hahekwarahimui, ba noholaia tanona ai. ");
INSERT INTO meu_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Bena idia baina kara henidia nato karadia na umui baina kara henimui. ");
INSERT INTO meu_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Iehova ese Mose e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Israel taudia ba haḡanidia, baoto: Kanaan tanona na emui tano, ela bona ena hetoa iboudiai. Kanaan tanona ai ba kau negana ai, ");
INSERT INTO meu_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","emui tano hetoana diho kahana ai na Sin tano-ḡaḡaena amo Edom hetoana ai bainela, ela bona Tadi (Gohuna mairiveina kahana. ");
INSERT INTO meu_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Unu amo Akrabim ororona diho kahana amo bainela, ela bona Sin. Unu amo ia na Kade-baranea diho kahana amo bainela, ela bona Hasara-adara, ela bona Asamon; ");
INSERT INTO meu_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Asamon amo bainela, ela bona Aigupto Dokana, ma unu amo kone ai baine lasi. ");
INSERT INTO meu_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Lahara kahana ai, emui hetoa na Davara Badana konena; emui tano hetoana bunai, lahara kahana ai. ");
INSERT INTO meu_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Mirigini kahana ai, emui hetoa na Davara Badana amo bainela, ela bona Horo ororona. ");
INSERT INTO meu_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Horo ororona amo bainela, Hamat kahana ai, ela bona Sedad. ");
INSERT INTO meu_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Unu amo ma bainela, Sifron kahana ai, ela bona Hasara-enan. Mirigini kahana ai emui hetoa bunai. ");
INSERT INTO meu_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Mairiveina kahana ai, emui hetoa na Hasara-enan amo bainela, elabona Sefam; ");
INSERT INTO meu_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","bona Sefam amo bainela, ela bona Ribla, Ain mairiveina kahana ai; unu amo ma bainela, ela bona Kinerete Gohuna mairiveina kahana. ");
INSERT INTO meu_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Unu amo emui hetoa na Ioridane sinavaina, ela bona Tadi Gohuna. Ini hetoa lalodiai e miamu tanodia iboudiai na umui emui. ");
INSERT INTO meu_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Bena Mose ese Israel taudia e haḡanidia, eto, Ina tano na emui tano; mari ai ba haria. Iehova vada e hereva, iduhu taurahani-ta bona iduhu ta kahana ese bae abia. ");
INSERT INTO meu_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Badina be Ruben iduhuna taudia bona Gad iduhuna taudia bona Manase iduhuna kahana taudia na edia tano vada e abia: iduhu lohiadia ta ta ese ahudia vada e abi. ");
INSERT INTO meu_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Hari iduhu ruaosi mai kahana ese ahudia vada e abi, Ieriko ai, Ioridane sinavaina mairiveina kahana ai, daba e reremu kahana ai. ");
INSERT INTO meu_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Iehova ese Mose ma e hamaoroa, eto, ");
INSERT INTO meu_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","Tano iharina bae biagua taudia ladadia bini: Eleasara, hahelaḡa tauna; bona Iosua Nunu; ");
INSERT INTO meu_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","bona iduhu ta ta amo iduhu lohiadia ta ta bavabidia hidi, tano iharina bae biagua. ");
INSERT INTO meu_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Ladadia bini: Iuda iduhuna amo, Kaleb lefune; ");
INSERT INTO meu_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Simeon iduhuna amo, Semuel Amihud; ");
INSERT INTO meu_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Beniamina iduhuna amo, Elidad Kislon; ");
INSERT INTO meu_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Dan iduhuna amo, Buki Iogli, edia lohia ta; ");
INSERT INTO meu_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Iosef garana amo, Haniel Efod, Manase iduhuna lohiana, ");
INSERT INTO meu_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","bona Kemuel Siftan, Efraim iduhuna lohiana; ");
INSERT INTO meu_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Sebulun iduhuna amo, Elisafan Paranaka, edia lohia ta; ");
INSERT INTO meu_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Isakara iduhuna amo, Paltiel Asan, edia lohia ta; ");
INSERT INTO meu_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Asere iduhuna amo, Ahihud Selomi, edia lohia ta; ");
INSERT INTO meu_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Napatali iduhuna amo Pedahele Amihud, edia lohia ta. ");
INSERT INTO meu_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Tataudia bunu, Iehova ese e haḡanidia, tano bae haria, Israel taudia ahudia bae henidia, Kanaan tanona ai. ");
INSERT INTO meu_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Ieriko ai, Ioridane sinavaina isena ai, Moab taorana ai, Iehova ese Mose ma e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","Israel taudia ba haḡanidia, bae abia tanona lalonai Levi taudia na hanua bae henidia, mai hetabira tanodia ida. ");
INSERT INTO meu_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Hanua be bae noholaidia, bona hetabira tanodia ai edia boromakau bona edia mamoe bona edia ubu-ubu ḡaudia idau-idau bae reḡudia. ");
INSERT INTO meu_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Hari hetabira tanodia Levi taudia ba henidia na hanua maḡuna amo baela, ela bona kiubit daha-ta, hanua kahadia iboudiai. ");
INSERT INTO meu_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Hanua murimurina ai ba hahetohoa, mairiveina kahana ai kiubit daha-rua, diho kahana ai kiubit daha-rua, lahara kahana ai kiubit daha-rua, bona mirigini kahana ai kiubit daha-rua; hanua be bogaraginai. Tano unubadana bae abia, edia ubu-ubu ḡaudia na una tano ai bae reḡudia. ");
INSERT INTO meu_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Levi taudia ba henidia hanuadia tauratoi be roho-mauri hanuadia bae gwaurai, ala-ala tauna naediai baine heau kau, bena baine mauri; bona ma hanua hari-ahui rua danuba henidia. ");
INSERT INTO meu_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Levi taudia ba henidia hanuadia bae hari-ahui taurahani; iboudiai na mai hetabira tanodia. ");
INSERT INTO meu_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Ini hanua na Israel taudia ahudia amo ba henidia: iduhu badadia amo momo bavabi; iduhu maraḡidia amo gadoi mo bavabi. Iduhu ta ta ese ahudia amo Levi taudia ahudia bae henidia. ");
INSERT INTO meu_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Iehova ese Mose ma e hereva henia, eto, ");
INSERT INTO meu_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","Israel taudia ba hamaorodia, baoto: Ioridane sinaavaina ba hanaia, Kanaan tanona ai ba kau, negana ai, ");
INSERT INTO meu_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","hanua haida bavabidia hidi, emui roho-mauri hanuadia. Bena taunimanima ta baine hapadidia tauna na unu baine heau lao. ");
INSERT INTO meu_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Unu hanua lalodiai mase tauna varavarana ese basine alamui diba; hahepadidi tauna na basie alaia ela bona hebou ese baine hahemaoro henia. ");
INSERT INTO meu_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Levi taudia ba henidia hanuadia tauratoi be emui roho-mauri hanuadia ai ba halaodia: ");
INSERT INTO meu_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","hanuatoi Ioridane sinavaina inikahana ai, bona hanua toi Kanaan tanona ai, ba henidia, roho-mauri hanuadia ai baela. ");
INSERT INTO meu_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Unu hanua tauratoiosi na rohomauri hanuadia ai baela, Israel taumui emui, bona idau taudia bogaragimui ai e noho hedoamu taudia edia: taunimanima ta baine hapadidia tauna na unu hanua baine heau lao. ");
INSERT INTO meu_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","A tau ta ese bamona na auri amo baine botaia mase, ia na roroma tauna: vada bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Eiava nadi imana ai baine abia, bamona baine tutulaia, bena baine mase, ia na roroma tauna: vada bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Eiava au ta imana ai baine abia, bamona baine botaia mase, ia na roroma tauna: vada bae alaia mase. ");
INSERT INTO meu_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Mase tauna varavarana ese roroma tauna baine davaria negana ai, ia ese baine alaia mase. ");
INSERT INTO meu_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Bamona na badu ai e gwadaia mase tauna, eiava bamona ialana e bani henia tauna, ");
INSERT INTO meu_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","eiava bamona na imana amo e tutua mase mai baduna ida tauna, una tau bae alaia mase. Ia na roroma tauna: mase tauna varavarana ese baine davaria negana ai, ia ese baine alaia mase. ");
INSERT INTO meu_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","A tau ta, asi ena badu, ese bamona bema gwadaia, eiava bema hodoa, ");
INSERT INTO meu_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","eiava nadi amo bema tutua mase, bena bamona bema mase, a ia be bamona se inai henia bon