﻿USE sofia;
DROP TABLE IF EXISTS sofia.met_vpl;
CREATE TABLE met_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES met_vpl WRITE;
INSERT INTO met_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Mugamugau sibuna, Urana tongtongia sabaluna xaung titi. ");
INSERT INTO met_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Titia babung te, xola mana axamang tela. Labiana kaukau miawa ubuna, saing Urana Aningonoa tangaxa etuaʼm tek ubuna. ");
INSERT INTO met_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Baing Urana harua ba, “Lulianoa sok,” baing luliana sok. ");
INSERT INTO met_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Urana bagu ba luliana xai. Baing hata luliana xaung labiana. ");
INSERT INTO met_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Urana uxu luliana ba, “Xaidap,” saing uxu labiana ba, “Yambong.” Tauna, yambonga ila sup, buraragina sok—xaidap taininauba. ");
INSERT INTO met_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Baing Urana harua ba, “Ganangana sok lia mana langa bu hata langdi.” ");
INSERT INTO met_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Baing Urana tongtongia ganangana saing hata lang hawama xaung lang etuama. Sok bila ba. ");
INSERT INTO met_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Urana uxu ganangana ba, “Sabaluna.” Tauna, yambonga ila sup, buraragina sok—xaidap luwauba. ");
INSERT INTO met_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Baing Urana harua ba, “Langa wa hawa sabalunia gugunia mana long taininau bu long mamasana sok.” Baing sok bila ba. ");
INSERT INTO met_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Urana uxu long mamasana ba, “Titi,” saing uxu lang guguniangama ba, “Tek.” Baing Urana bagu saing yaha mana. ");
INSERT INTO met_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Baing Urana harua ba, “Titia libu axamang xangxana disok: angingadi xaung xuyadingdi, xaung xaidi xaung maradingdi, taining tainina disu mana xadingdi.” Baing sok bila ba. ");
INSERT INTO met_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Titia libu axamang xangxana disok: anginga xaung xuyadingdi, xaung xaidi maradingdi, taining tainina disu mana xadingdi. Baing Urana bagu ba xai. ");
INSERT INTO met_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Tauna, yambonga ila sup, buraragina sok—xaidap tuwauba. ");
INSERT INTO met_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Baing Urana harua ba, “Luliandi disok sabalunia bu dahata xaidap xaung yambong. Namuxidingdi bing dahatanga nianigesakdi xaung xaidapdi xaung nianidi. ");
INSERT INTO met_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Lulianadi disina sabalunia bu disaxaxanga titia.” Baing sok bila ba. ");
INSERT INTO met_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Baing Urana tongtongia luliang sabanga luwa, luliang sapsambagiak wasa mana xaidaba xaung luliang kaxukana wasa mana yambonga. Tongtongia hatungdi xauna. ");
INSERT INTO met_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Baing Urana tadi sabalunia bu disaxaxanga titia, ");
INSERT INTO met_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","duwasa mana xaidaba xaung yambonga, xaung bu dahata luliana xaung labiana. Baing Urana bagu ba xai. ");
INSERT INTO met_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Tauna, yambonga ila sup, buraragina sok—xaidap luwadi luwadiuba. ");
INSERT INTO met_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Baing Urana harua ba, “Tega baxagi mana asaxa walingam xangxana. Mangdi disok doti makisi sabalunia etuaʼm titia.” ");
INSERT INTO met_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Binabu Urana xap masok asaxa tekkam sabangadi xaung asaxa tekkam xangxang teladi dibaxagi mana tega, disu mana xadingdi, xaung mang xangxana, disu mana xadingdi. Baing Urana bagu ba xai. ");
INSERT INTO met_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Baing Urana sina guxama nadi. Harua ba, “Axapsaxi asok xumana saing abaxagi mana tega. Mangdi xauna disok xumana titia.” ");
INSERT INTO met_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Tauna, yambonga ila sup, buraragina sok—xaidap luwadi luwadi hiliadingauba. ");
INSERT INTO met_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Baing Urana harua ba, “Asaxa xangxana disok titia, disu mana xadingdi: morudi, asaxadi dahaxa mua titia, xaung abungindi, disu mana xadingdi.” Baing sok bila ba. ");
INSERT INTO met_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Urana tongtongia asaxa abunginadi disu mana xadingdi, xaung asaxa longgalo dahaxa mua titia, disu mana xadingdi. Baing Urana bagu ba xai. ");
INSERT INTO met_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Baing Urana harua ba, “Tatongtongia lipudi disok bila kira sibura li. Bing duwa etua mana song tekkamdi xaung mang sabalunamdi, etua mana morudi xaung titi longgalo xaung axamang longgalo dahaxa mua titia.” ");
INSERT INTO met_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Binabu Urana tongtongia lipudi disok bila ing sibuna, maxuna, tongtongiadi disok bila ina, tongtongiadi lup haing. ");
INSERT INTO met_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Baing Urana sina guxama nadi. Harua ba, “Axapsaxi asok xumana. Abaxagi mana titia saing awa etua mana. Awa etua mana song tekkamdi xaung mang sabalunamdi xaung asaxa longgalo dahaxa mua titia.” ");
INSERT INTO met_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Baing Urana harua ba, “Bagu ngasina anginga xuyanam longgalo duwa titia nang xaung xai maranam longgalo nang. Bagula duwa angiaimdi. ");
INSERT INTO met_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Baing asaxa titiam longgalo, mang sabalunam longgalo xaung asaxa longgalo dahaxa mua titia—ngasina tatubang xaung xailong gamatang longgalo nadi. Bagula duwa angiadingdi.” Baing sok bila ba. ");
INSERT INTO met_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Urana bagu axamang longgalo tongtongiadi, saing xai sibuna. Tauna, yambonga ila sup, buraragina sok—xaidap tuwa tuwauba. ");
INSERT INTO met_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Baing ina naga, Urana tongtongia sabaluna xaung titi masup, xaung axamang longgalo duwa maluxu manadi. ");
INSERT INTO met_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Xaidap 7 Urana bagu oxatandi tuxudi ba disup, baing yagua mana xaidapka 7 mana oxatandi. ");
INSERT INTO met_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Binabu Urana sina guxama mana xaidapka 7, mogu maina, namua na xaidapka yagua mana oxatang longgalo tuxudi bungina tongtongia axamandi. ");
INSERT INTO met_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Naxuyanga li baxanga bungina sabaluna xaung titi disok, bungina Toxoratamona ");
INSERT INTO met_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Muga bing xai xaung tatubang disok teguyu, namua na Toxoratamona Urana sina kuya mari titia teguyu saing lipu tela wa teguyu bu tuxu oxatua titia. ");
INSERT INTO met_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ning uxua haing titia bu titi longgalo langiding. ");
INSERT INTO met_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Baing Toxoratamona Urana tongtongia lipua mana titi gagabinoa. Yubua yang walingama maluxu yungxang gininginia, saing lipua sok lipu walingama. ");
INSERT INTO met_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Baing Toxoratamona Urana tongtongia umanga tela sanga karagia, mana long tela yanoa Iden. La ba ta lipua tongtongia ba. ");
INSERT INTO met_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Baing Toxoratamona Urana libu xai xangxana disok titia, bagungadinga (da)xai sibuna xaung daxai mana xangingua. Maluxu mana umanga baguba xai luwa duwa: xaiya sina walinga xaung xaiya sina xabianga mana xai xaung diana. ");
INSERT INTO met_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Lang tela luki masok sangua titia Iden ba sina langa na umangua. La ba maxania hata gatung luwa luwa. ");
INSERT INTO met_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Gatung mugamugangama yanoa Pison. Hokhogia maluxu titia Habila, titia gol wa mana ba. ");
INSERT INTO met_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Baing gol ba xai sibuna. Delium xaung oniks duwa la ba xauna. ");
INSERT INTO met_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Gatung luwa yanoa Gihon. Hokhogia maluxu titia Kus. ");
INSERT INTO met_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Gatung tuwa yanoa Taigris, luki maluxu Asiria rubinia sanga karagia. Baing gatung luwa luwa yanoa Yupretis. ");
INSERT INTO met_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Toxoratamona Urana xap lipua saing ta umangia Iden bu tuxu oxatua titia saing wasa mana. ");
INSERT INTO met_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Baing Toxoratamona Urana bili lipua ba, “Ung sanga ba oxong xai marang longgalo umangia li, ");
INSERT INTO met_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ning labu oxong xai marandi mana xaiya sina xabianga mana xai xaung dianau tai. Namua na bungina oxong, maxuna bagula umati.” ");
INSERT INTO met_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Baing Toxoratamona Urana harua ba, “Xai te mana lipua ing ganina wa. Bagula ngatongtongia rianoa bu sok haulinganoa.” ");
INSERT INTO met_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Muga Toxoratamona Urana xap titia saing tongtongia asaxa xaung mang xangxana masup. Tauna, xapdi ma rangua lipua bu lungu yaya baru bagula uxudi. Baing baru yanta lipua uxudi bing ding yadingdi. ");
INSERT INTO met_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Lipua sina yayadi na moru longgalo, mang sabalunam longgalo xaung asaxa abunging longgalo. Ne riang tela ba hauli lipua te. ");
INSERT INTO met_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Binabu Toxoratamona Urana libu lipua kinu hadali. Kinuyu, baing xap rubing tela saing usiti yabanoa muli sanggia. ");
INSERT INTO met_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Baing Toxoratamona Urana tongtongia haing tela mana rubina xap sangua luba, saing xap ma rangua lipua. ");
INSERT INTO met_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Baing lipua harua ba, “Ina naga! Alaing riagu sibuna. Tuanoa tuaguamdi, xaung sangganoa sanggaguama. Bagula ngauxu ba, ‘Haing’, namua na Urana xap sangua Lup.” ");
INSERT INTO met_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Mana namua baguli lup tela yunga baungtibundi saing taga rangua haininoa, baing tang disok lipu taininau. ");
INSERT INTO met_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Baing lipua haininoa tang duwa mulang, ne tang memeyading te. ");
INSERT INTO met_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Moxa kubolung murakkama dali asaxa abunging longgalo Toxoratamona Urana tongtongiadi. Ma rangua hainga saing xusunga ba, “Maxuna Urana biliangtang ba, ‘Labu axang xai marang longga duwa umangiau tai’?” ");
INSERT INTO met_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Baing hainga harua na moxua ba, “Tam sanga ba tam gaxang xai marandi umangia, ");
INSERT INTO met_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ning Urana harua ba, ‘Labu axang xai marandi mana xaiya li liwe umangiau tai, saing labu aringgu tai, nam tang gamati.’ ” ");
INSERT INTO met_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","“Ne moxua harua na hainga ba, “Tegu. Bagula amati te. ");
INSERT INTO met_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Urana harua bila ba namua na xabia ba bungina axang maranoa bagula tang maxaimdi daxaxa ding, saing bagula axabia xai xaung diana, bila Urana xabia.” ");
INSERT INTO met_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Hainga bagu xaiya ba marandi (da)xai mana xangingua xaung gumanging sibuna, saing muruna mana xabiangua bagula sina na. Baing ina naga, xap saing xang. Saking sina (hataina) na ayuana, saing xang. ");
INSERT INTO met_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Baing tang maxading daxaxa ding, saing tang dibagu daxabia ba duwa mulang. Binabu dahatu xaiya pik londi, saing dahaxam mana kaukau dingtang sibuding. ");
INSERT INTO met_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Bungbung, longa xaringa, baing luba haininoa tang dilungu Toxoratamona Urana haxa umangia, baing dihisa mana Toxoratamona Urana liwe mana xai umangamdi. ");
INSERT INTO met_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ne Toxoratamona Urana wagi mana luba ba, “Uwa bi?” ");
INSERT INTO met_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Baing haxuya ba, “Ngalungung uhaxa umangia, saing ngamaxuwa namua na ngawa mulang. Binabu ngahisa.” ");
INSERT INTO met_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Baing xusunga ba, “Gaxarea balaung ba uwa mulang? Oxong xai marana mana xaiya ngabiliung mana ba?” ");
INSERT INTO met_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Luba harua ba, “Haingga ba usina ba wa rangua nga—ina sina xai marana nanga, saing ngaxang.” ");
INSERT INTO met_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Saking Toxoratamona Urana xusunga hainga ba, “Uraxata ulibu bila ba?” Hainga harua ba, “Moxua tuxu murak manga, saing ngaxang.” ");
INSERT INTO met_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Binabu Toxoratamona Urana harua na moxua ba, “Ulibu bila ba, binabu “Mauxanganoa xapkung ganim liwe mana moru longgalo xaung asaxa abunging longgalo! Bagula uhaxa gamomia saing bagula oxong gagap mana xaidap longgalo walingamia. ");
INSERT INTO met_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Baing bagula ngata bixua wa lia mana haing xaung ung, xaung wa lia mana bakbaginoa xaung bakbagima, bagula bakbaginoa taha toxoma, saing bagula utaha king tambonga.” ");
INSERT INTO met_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Harua na hainga ba, “Bagula ngalibu salak hayauxingama xapkung sok sabanga sibuna, saing bagula uxunumia salak sabanga bungina uhayau garadi. Murungama bagula sabanga mana ayuam, ne bagula wa etua maung.” ");
INSERT INTO met_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Baing harua na lupka ba, “Ulungu hainima saing oxong xai marana ngabiliung mana ba, ‘Labu oxonggu tai.’ “Mana namua ulibu bila ba, mauxanganoa xap titia, bagula umakasa sibuna mana oxop angingua mana bu oxong, mana xaidap longgalo walingamia. ");
INSERT INTO met_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Waxu ruxunamdi xaung tatubang diandi bagula disok umangama, saing bagula oxong anginga abungindi. ");
INSERT INTO met_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Bagula salaksalaga xap ramramoma, bungina oxop oxong angingua, laing umati ugoxoya muli titia ngatongtongiaung mana ba, namua na uwa titi gagabinoa, saing bagula ugoxoya mala mana titi gagabinoa muli.” ");
INSERT INTO met_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Luba Adam uxu haininoa Ip, namua na sok lipu walingam longgalo bauding. ");
INSERT INTO met_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Baing Toxoratamona Urana tongtongia imang asaxa sangganamdi na Adam haininoa tang saing sausaudi. ");
INSERT INTO met_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Baing Toxoratamona Urana harua ba, “Bagu luba sok bila kiria tela, namua na xabia xai xaung diana. Ne xai te nabu raria rimana saing kiri xai marandi mana xaiya sina walinga. Nam xang bu wa bungingbunginalo.” ");
INSERT INTO met_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Binabu Toxoratamona Urana suka luba tang mala sangua Umanga Iden, ba ki titia Urana tongtongia mana ba. ");
INSERT INTO met_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Suka luba mala masup, baing ta kerubimdi Umanga Iden sanga karagia, xaung ta waxang sabanga yap manandi bilikbiliga mana ba xukxugia sanga long longgalo bu soxauti daxangua ila mana xaiya sina walingua. ");
INSERT INTO met_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam kinu rangua haininoa Ip, baing gamona saing hayau gara lup tela. Harua ba, “Toxoratamona hauli nga ngaxap gara lup tela.” Binabu uxu ba Ken. ");
INSERT INTO met_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Kimuya hayau kixinginoa Ebal. Tauna, Ebal sok lipu sipsip wasanganama, saing Ken sok lipu umangam(a). ");
INSERT INTO met_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Bunging tela Ken xap anginga umangam tela(di) ma hanania(di) mala rangua Toxoratamona. ");
INSERT INTO met_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Baing Ebal xauna xap hananiangua ma—sipsibing matuaudi mututungading oranamdi. Baing Toxoratamona yaha mana Ebal xaung hananianganoa, ");
INSERT INTO met_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ne yaha mana Ken xaung hananianganoa te. Binabu Ken atin disala haringina saing ramramonoa haring. ");
INSERT INTO met_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Baing Toxoratamona harua na Ken ba, “Baruta atim disala xaung ramramoma haring? ");
INSERT INTO met_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Nabu ulibu xai, bagula ngaxapkung. Ne nabu ulibu xai te, bing kubolu diana yai xalumia, ragung usok baing. Muruna ba xapkung, ning uhaxi bu udali.” ");
INSERT INTO met_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Xaidap tela Ken bala kixinginoa Ebal ba, “Tala umangia.” Tang duwa umangia, baing Ken taha kixinginoa Ebal mati. ");
INSERT INTO met_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Baing Toxoratamona xusunga Ken ba, “Kixingima Ebal kabi?” Haxuya ba, “Ngaxabia te. Baruta? Nga kixingigua lipuxing wasangama?” ");
INSERT INTO met_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Binabu Toxoratamona harua ba, “Uraxata bila ba? Ulungu! Kixingima sibinoa wa titia ba wagi manga. ");
INSERT INTO met_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Titia xaxa suxungunoa ba nung kixingima sibunoa bungina mati rimamia. Binabu hatata guxam dianoa xapkung. Titia ribaina maung. ");
INSERT INTO met_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Bungina uki titia, bagula ua te. Bagula uwa lipu yabam teguam xaung uhaxahaxa mauli titia.” ");
INSERT INTO met_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ken harua na Toxoratamona ba, “Mauxangana ngaxap li tubu buk manga. ");
INSERT INTO met_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Laku, hatata usuka nga sangua titia, saing bagula ngawa maxamia muli te. Bagula ngawa lipu yabagu teguam xaung ngahaxahaxa mauli titia. Lipu gaxarea sok manga bagula ung nga mati.” ");
INSERT INTO met_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Baing Toxoratamona harua na ba, “Tegu! Nabu lipu tela unggung, bing bagula xap salaga dali ungia bila 7.” Baing Toxoratamona ta mogungua mana Ken, nam lipu tela sok mana bu ung mati. ");
INSERT INTO met_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Binabu Ken ila sangua Toxoratamona maxanoa saing rung mana titia Nod. Titia ba wa Iden sanga karagia. ");
INSERT INTO met_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ken kinu rangua haininoa, baing gamona saing hayau gara lup tela, yanoa Inok. ");
INSERT INTO met_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Baing Inok xapsaxi Irat. Irat xapsaxi Mehuyael. Mehuyael xapsaxi Metusael. Metusael xapsaxi Lamek. ");
INSERT INTO met_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek yau haing luwa. Tela yanoa Ada saing tela yanoa Sila. ");
INSERT INTO met_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada hayau Yabal. Yabal bing adi duwa mana numa mokiamdi xaung adi moruamdi mugangadinga. ");
INSERT INTO met_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Kixinginoa yanoa Yubal. Yubal bing adi dahali hap xaung adi diyup panggeriang mugangadinga. ");
INSERT INTO met_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila xauna hayau gara lup tela, yanoa Tubal-Ken. Tongtongia axamang oxatamdi mana bras xaung ain. Tubal-Ken hamunganoa yanoa Nama. ");
INSERT INTO met_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamek harua na hainindi tang ba, “Ada Sila, tang galungu nga to, hainigudi axap haruangagua to. Ngaung lipu tela namua na taha nga, Gananung tela uda nga, binabu ngataha mati. ");
INSERT INTO met_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Lipu gaxarea ung Ken bing xap salaga dali inia 7, ne nga ngaharua ba, lipu gaxarea ung nga, bing xap salaga dali inia 77.” ");
INSERT INTO met_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam kinu muli rangua haininoa, baing hayau gara lup tela. Harua ba, “Urana sina gara tela muli nanga ba xap Ebal yabanoa, namua na Ken ung mati.” Binabu uxu ba Set. ");
INSERT INTO met_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set xauna garanoa, saing uxu ba Enos. Mana bungina baguba lipudi dungguti disabu mana Toxoratamona, duxu yanoa. ");
INSERT INTO met_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adam bakbagindi bila li. Bungina Urana tongtongia lipudi, tongtongiadi disok bila ina. ");
INSERT INTO met_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Tongtongiadi lup haing, saing sina guxama nadi. Tongtongiadi laing sup, baing uxudi ba, “lipudi.” ");
INSERT INTO met_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam nianindi 130, baing xapsaxi gara lup tela sok bila ing sibuna—maxuna sok bila ina. Uxu ba Set. ");
INSERT INTO met_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adam wa niani 800 muli kimuya mana xapsaxi Set, saing xapsaxi gara teladi muli, lupdi xaung haingdi. ");
INSERT INTO met_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Bila balau Adam nianindi 930, saing mati. ");
INSERT INTO met_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set nianindi 105, baing xapsaxi Enos. ");
INSERT INTO met_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Set wa niani 807 muli kimuya mana xapsaxi Enos, saing xapsaxi gara teladi muli, lupdi xaung haingdi. ");
INSERT INTO met_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Bila balau Set nianindi 912, saing mati. ");
INSERT INTO met_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos nianindi 90, baing xapsaxi Kenan. ");
INSERT INTO met_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enos wa niani 815 muli kimuya xapsaxi Kenan, saing xapsaxi gara teladi muli, lupdi xaung haingdi. ");
INSERT INTO met_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Bila balau Enos nianindi 905, saing mati. ");
INSERT INTO met_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan nianindi 70, baing xapsaxi Mahalalel. ");
INSERT INTO met_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan wa niani 840 muli kimuya mana xapsaxi Mahalalel, saing xapsaxi gara teladi muli, lupdi xaung haingdi. ");
INSERT INTO met_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Bila balau Kenan nianindi 910, saing mati. ");
INSERT INTO met_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel nianindi 65, baing xapsaxi Yaret. ");
INSERT INTO met_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalalel wa niani 830 muli kimuya mana xapsaxi Yaret, saing xapsaxi gara teladi muli, lupdi xaung haingdi. ");
INSERT INTO met_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Bila balau Mahalalel nianindi 895, saing mati. ");
INSERT INTO met_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaret nianindi 162, baing xapsaxi Inok. ");
INSERT INTO met_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yaret wa niani 800 muli kimuya mana xapsaxi Inok, saing xapsaxi gara teladi muli, lupdi xaung haingdi. ");
INSERT INTO met_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Bila balau Yaret nianindi 962, saing mati. ");
INSERT INTO met_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Inok nianindi 65, baing xapsaxi Metusela. ");
INSERT INTO met_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Inok haxa rangua Urana 300 niani muli kimuya mana xapsaxi Metusela, saing xapsaxi gara teladi muli, lupdi xaung haingdi. ");
INSERT INTO met_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Bila balau Inok nianindi 365. ");
INSERT INTO met_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Inok haxa rangua Urana, ning Urana xap mala, binabu lipudi dibagu muli te. ");
INSERT INTO met_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela nianindi 187, baing xapsaxi Lamek. ");
INSERT INTO met_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metusela wa niani 782 muli kimuya mana xapsaxi Lamek, saing xapsaxi gara teladi muli, lupdi xaung haingdi. ");
INSERT INTO met_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Bila balau Metusela nianindi 969, saing mati. ");
INSERT INTO met_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek nianindi 182, baing xapsaxi gara lup tela. ");
INSERT INTO met_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Baing harua ba, “Bagula tatua makasangaroa xaung salaga taxap mana titia li Toxoratamona sina guxam diana na. Binabu uxu ba Noa. ");
INSERT INTO met_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamek wa niani 595 muli kimuya mana xapsaxi Noa, saing xapsaxi gara teladi muli, lupdi xaung haingdi. ");
INSERT INTO met_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Bila balau Lamek nianindi 777, saing mati. ");
INSERT INTO met_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa nianindi 500, baing xapsaxi Siem, Ham, Yapet tung. ");
INSERT INTO met_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Bungina lipudi dungguti disok xumana titia, saing dahayau nanuhangidingdi. ");
INSERT INTO met_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Adi duwa bila Urana dibagu ba lipudi nanuhangidingdi gumangiding sibuna. Baing daxap baruamtadi sanga mana murungadingdi, saing diyaudi. ");
INSERT INTO met_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Baing Toxoratamona harua ba, “Aningogua sina walinga ba bagula wa rangua lipudi bungingbunginalo te, namua na ding axamang titiamdi. Bagula nianidingdi didali 120 te.” ");
INSERT INTO met_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Nepildi duwa titia mana bungina baguba xaung kimuya xauna. Mana bungina baguba, adi duwa bila Urana dikinu rangua lipudi nanuhangidingdi, saing dahayau garadi. Lipuadi ba mugauamdi haringiding sibuna haungingia, saing ramramoding sabanga(di). ");
INSERT INTO met_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Toxoratamona bagu ba lipudi kuboluding diandi ditubu buk titia, saing bagu ba hatumingading longgalo muruding mana axamang diana bungingbunginalo ing ganina. ");
INSERT INTO met_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Baing Toxoratamona ayangang sibuna ba tongtongia lipudi titia, saing gamona mauxana buk. ");
INSERT INTO met_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Binabu Toxoratamona harua ba, “Bagula ngasisia axamang longgalo ngatongtongiadi sangua titia—lipudi xaung asaxadi xaung asaxadi dahaxa mua titia xaung mang sabalunamdi. Namua na ayangagu sibuna ba ngatongtongiadi.” ");
INSERT INTO met_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ne Toxoratamona yaha mana Noa. ");
INSERT INTO met_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Noa naxuyanganoa bing bila li. Noa lipu maringina. Liwe mana lipudi mana bungina baguba, xola mana kubolu diana. Noa haxa rangua Urana. ");
INSERT INTO met_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa garang tuwa, yadingdi bing Siem, Ham xaung Yapet. ");
INSERT INTO met_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ne lipu titiamdi didoa sibuna Urana maxania, saing titia baxagi mana lipudi kuboluding dudunamdi. ");
INSERT INTO met_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Urana bagu lipu titiamdi, saing bagu didoa sibuna, namua na ding longgalo kuboludingdi didoa buk. ");
INSERT INTO met_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Binabu Urana harua na Noa ba, “Ngahau hatumingagua ba ngasahi lipu longgalo, namua na dilibu titia baxagi mana kuboluding dudunamdi. Maxuna bagula ngahanggalangiadi xaung titi(a).” ");
INSERT INTO met_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","“Utongtongia waga sabanga tela mana xaiya goper. Utongtongia numa lundi maluxu mana, saing usami xasu tagangama lunia xaung ubunia. ");
INSERT INTO met_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Utongtongia bila li: Maxaxayanganoa bing 135 mita, tubunganoa bing 22 mita, xaung maxaxayanganoa mahaing bing 13 mita. ");
INSERT INTO met_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Utongtongia uronganoa mana, ne uyunga ganangana wa hawa mana laing rubunganoa bila mita hataina. Utongtongia xalua waga rubinia, saing utongtongia saxuming tuwa maluxu mana—hawama, liama, xaung etuama. ");
INSERT INTO met_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Ulungu to. Bagula nga ngaxap silinga sabanga masok titia bu hanggalangia axamang walingam longgalo hawa sabalunia, axamang yagangam longgalo. Axamang longgalo duwa titia bagula dimati. ");
INSERT INTO met_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ne bagula ngahau haruangua ranguaung. Baing bagula uluxu wagia—ung xaung garamdi, hainima, xaung garamdi hainidingdi. ");
INSERT INTO met_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Baing oxop asaxa luwa luwa mana asaxa xangxang longgalo maluxu wagia, moning tela xaung hagaxang tela. Oxopdi mala ranguaung bu duwa. ");
INSERT INTO met_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Luwa luwa mana mang longgalo xaung asaxa longgalo, xaung asaxa longgalo dahaxa mua titia. Ding bagula dima ranguaung bu duwa. ");
INSERT INTO met_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Baing ung (g)oxop anginga xangxana mala ranguaung, saing uhaxurudi wagia, bu disok angingadi mang xaung mading.” ");
INSERT INTO met_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noa libu bila ba. Libu axamang longgalo Urana tabina ba. ");
INSERT INTO met_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Baing Toxoratamona harua na Noa ba, “Uluxu wagia, ung xaung bakbagim longgalo, namua na ngabagung ganim umaring liwe mana lipu titiam longgalo. ");
INSERT INTO met_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Oxop moning 7 xaung hagaxang 7 mana asaxa sigixingam xadingdi ranguaung. Baing asaxa sigixinga teguamdi bing oxop luwa luwa, monina xaung hagaxana. ");
INSERT INTO met_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Bila balau mana mang xadingdi, oxop moning 7 xaung hagaxag 7. Ulibu bila ba bu garadingdi disok xumana titia kimuya. ");
INSERT INTO met_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Xaidap 7 disup to, baing bagula ngasoxi kuya mari titia laing xaidap 40 (xaung) yambong 40 (disup). Bagula ngasahi axamang titiam longgalo ngatongtongiadi.” ");
INSERT INTO met_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Baing Noa libu axamang longgalo Toxoratamona tabina ba. ");
INSERT INTO met_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa nianindi 600 bungina silinga sabanga sok titia. ");
INSERT INTO met_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Baing ina naga, Noa gabu garandi, haininoa xaung dingtung hainidingdi diluxu wagia bu silingua xapdi te. ");
INSERT INTO met_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Asaxa sigixingamdi xaung asaxa sigixinga teguamdi, mangdi, xaung asaxadi dahaxa mua titia, ");
INSERT INTO met_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","luwa luwa mana monindi xaung hagaxandi, ding dahaing wagia mala rangua Noa, bila Urana tabina Noa ba. ");
INSERT INTO met_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Xaidap 7 disup, baing silingua sok titia. ");
INSERT INTO met_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Bungina Noa nianindi 600, mana xaidap 17 mana sobak luwa, mana xaidapka ba titia xaxaina saing lang maxandi sililiga mahaing, saing sabaluna xaluxindi daxaxa ding. ");
INSERT INTO met_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Baing kuya sabanga mu titia laing xaidap 40 yambong 40. ");
INSERT INTO met_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Mana xaidapka baguba Noa gabu garang tuwadi Siem, Ham xaung Yapet, digabu haininoa xaung dingtung hainidingdi diluxu wagia. ");
INSERT INTO met_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Baing asaxa abungindi, xading longgalo, morudi, xading longgalo, asaxadi dihaxa mua titia, xading longgalo, mangdi xading longgalo, xaung bina banggitonggamdi xading longgalo, ding dahaing wagia mala ranguadi. ");
INSERT INTO met_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Luwa luwa mana asaxa walingam longgalo dahaing wagia mala rangua Noa. ");
INSERT INTO met_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Asaxadi diluxu bing monindi xaung hagaxandi mana asaxa walingam longgalo, bila Urana tabina Noa ba. Dahaing masup, baing ina naga, Toxoratamona riba waga xaluxinoa. ");
INSERT INTO met_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Xaidap 40 silingua sok sok titia. Baing langa dudu mahaing saing xuru wagua mahaing etua sibuna mana titia. ");
INSERT INTO met_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Langa dudu mahaing sabanga sibuna saing dali titia, saing wagua oti etuaʼm lang ubunoa. ");
INSERT INTO met_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Langa dali titia haringing sibuna laing kau bimbi sabanga longgalo. ");
INSERT INTO met_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Langa dudu mahaing saing dali bimbi longgalo laing suana bila 6 mita. ");
INSERT INTO met_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Axamang walingam longgalo etua mana titia dimati—mangdi, morudi, asaxa abungindi, asaxa longgalo dahaxa mua titia, xaung lipu longgalo. ");
INSERT INTO met_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Axamang longgalo duwa etua mana titi mamasana, adi longgalo diyaga yang walingama yungxadingia ba, dimati. ");
INSERT INTO met_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Urana sisia axamang walingam longgalo sangua titia—lipudi xaung asaxadi xaung asaxadi dahaxa mua titia xaung mang sabalunamdi. Ding longgalo disup sibuna. Noa ing ganina wa, gabu adi duwa rangua wagia ba. ");
INSERT INTO met_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Silinga sabangua dali titia laing xaidap 150. ");
INSERT INTO met_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ne Urana hatumia Noa muli xaung asaxa abungindi xaung morudi duwa rangua wagia. Baing libu yanga yubua titia, saing langa xaya xaya mari. ");
INSERT INTO met_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Lang maxandi xaung sabaluna xaluxindi diriba ding, saing kuya sabalunam sabangua moti. ");
INSERT INTO met_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Langa xaya xaya mari. Xaidapka 150 disup, ");
INSERT INTO met_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","baing ina naga, mana xaidap 17 mana sobak 7 wagua taga mana bimbi tela mana titia Ararat. ");
INSERT INTO met_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Langga xaya xaya mari laing sobak 10. Baing mana xaidap mugamugangama mana sobak 10 bimbiadi disok sabasabia. ");
INSERT INTO met_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Xaidap 40 disup, baing Noa xaxa suanga tongtongia wagia, ");
INSERT INTO met_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","saing soxi okok tela mala. Ila ma laing langa mamasa titia. ");
INSERT INTO met_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Baing soxi baxaliku mala, bu bagu nabu langa mamasa titia. ");
INSERT INTO met_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ne baxaliku bagu long tela ba yagua te, namua na langa baxagi mana long longgalo. Binabu goxoya ma muli rangua wagia. Ta rimanoa masok saing xap baxaliku muli maluxu wagia rangua. ");
INSERT INTO met_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ragu xaidap 7 muli, baing soxi baxaliku mala muli. ");
INSERT INTO met_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Bungbung sibuna baing baxaliku goxoya ma muli, taranga xaiya olip long haun tela suxungunia! Baing ina naga, Noa xabia ba langa maxa ba. ");
INSERT INTO met_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ragu xaidap 7 muli, baing soxi baxaliku mala muli. Ning bungina li, goxoya ma rangua muli te. ");
INSERT INTO met_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noa nianindi 601, baing mana xaidap mugamugangama mana sobak mugamugangama mana niani baguba, langa mamasa titia. Baing Noa xaxa uronga hataing tela saing bagu ba titi ubunoa mamasa. ");
INSERT INTO met_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Xaidap 27 mana sobak luwa titia mamasa masup. ");
INSERT INTO met_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Baing Urana harua na Noa ba, ");
INSERT INTO met_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Uri mala sangua wagua, ung gugabu hainima xaung garamdi digabu hainidingdi. ");
INSERT INTO met_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Oxop asaxa walingam longgalo duwa ranguaung mari—mangdi xaung asaxadi xaung asaxa longgalo dahaxa mua titia. Oxopdi mari bu dibaxagi titia, xaung daxapsaxi disok xumana titia.” ");
INSERT INTO met_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Binabu Noa ri mala, gabu garandi xaung haininoa xaung dingtung hainidingdi. ");
INSERT INTO met_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Baing asaxa abunging longgalo, moru longgalo, mang longgalo, xaung asaxa longgalo dahaxa mua titia, ding diri mala sangua wagua, dahaxa bakbak mari. ");
INSERT INTO met_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Baing Noa tongtongia kabukabu hananiangam tela ba hanania na Toxoratamona. Baing xap asaxa sigixingam teladi xaung mang sigixingam teladi, saing taudi mana ba hananiadi na Toxoratamona. ");
INSERT INTO met_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Bungina Toxoratamona yuyu samisami ba, bing yaha mana hananianua. Baing harua na ing sibuna ba, “Labu ngahanggalangia titia muli bu haxuya lipudi kuboluding diandiu tai. Heku hatumingadingdi dibaxagi mana kubolu diandi mana bungina duwa garauyu. Xauna, labu ngahanggalangia axamang walingamdi muliu tai, bila ngalibu hatata ba. ");
INSERT INTO met_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Mana bungina titia wauyu, bunging umangama xaung xauyangama, bunging xaringana xaung salianoa, bunging xaidapkam xaung kuyam, yambong xaung xaidap, bagula disup te.” ");
INSERT INTO met_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Baing Urana sina guxama na Noa xaung garandi, harua ba, “Axapsaxi asok xumana, saing abaxagi mana titia. ");
INSERT INTO met_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Maxuwanga sabanga bagula xap asaxa longgalo mana namua ang. Asaxa titiam longgalo, mang sabalunam longgalo, asaxa longgalo dahaxa mua titia xaung song tekkam longgalo bagula dimaxuwang. Ngatadi rimaimia. ");
INSERT INTO met_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Axamang walingam longgalo, axamandi dima dila, ding longgalo bagula duwa anginga mang. Bila muga ngasina xauyangadi nang, hatata ngasina axamang longgalo nang. ");
INSERT INTO met_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Ning labu axang asaxa mututungang sibinamgu tai. Siba bing walinga namu. ");
INSERT INTO met_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Baing maxuna lipua sibinoa haxuyanganoa nabu tela ung. Bagula ngata asaxua haruangia mana. Xauna, bagula ngata lipua haruangia, nabu ung lipu tela mati. ");
INSERT INTO met_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Lipu gaxarea ung lipu tela mati, ing sibuna bagula mati lipudi rimadingia, namua na Urana tongtongia lipudi disok bila ing sibuna.” ");
INSERT INTO met_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ne ang ba, axapsaxi asok xumana, abaxagi mana titia saing asok xumana mana.” ");
INSERT INTO met_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Baing Urana harua na Noa gabu garandi ba, ");
INSERT INTO met_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Alungu to. Hatata nga ngahau haruangua ranguang xaung bakbagindi disok kimuya, ");
INSERT INTO met_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","xaung axamang walingam longgalo duwa ranguang—mangdi, morudi, asaxa abungindi, xaung adi disok sangua wagua ranguang—axamang walingam longgalo duwa titia. ");
INSERT INTO met_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ngahau haruangua ranguang bila li: Bagula axamang walingam longgalo dimati silingia muli te. Bagula silinga tela muli sok ba hanggalangia titia te.” ");
INSERT INTO met_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Baing Urana harua ba, “La li mogunga mana haruangua ngahau liwe makira xaung liwe mana axamang walingam longgalo duwa ranguang. Haruanga li bagula wa rangua lipu longgalo dima kimu mang. ");
INSERT INTO met_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ngata moxa babuna mugabia, saing bagula wa mogunga mana haruangua ngahau liwe manga xaung axamang titiamdi. ");
INSERT INTO met_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Bunging bungina ngasina mugapdi dikau titia xaung dibagu moxa babunoa maluxu mugapdi, ");
INSERT INTO met_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","bagula ngahatumia muli haruangua ngahau liwe manga xaung ang xaung asaxa walingam longgalo. Bagula langadi disi muli bu dahanggalangia axamang walingamdi te. ");
INSERT INTO met_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Bunging bungina moxa babuna wa mugabia, bagula ngabagu saing ngahatumia muli haruanga bungingbunginaloama ngahau liwe mana Urana xaung asaxa walingam longgalo duwa titia.” ");
INSERT INTO met_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Baing Urana harua na Noa ba, “Alali mogungua mana haruangua ngahau liwe manga xaung asaxa walingam longgalo duwa titia.” ");
INSERT INTO met_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noa garang tuwa disok sangua wagua yadingdi bing Siem, Ham xaung Yapet. (Ham Kenan tibuna.) ");
INSERT INTO met_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Gara tuwadi ba Noa garandi, saing lipu longgalo etua mana titia li disok mana dingtung. ");
INSERT INTO met_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa lipu umangam, ina lipu mugamugangam mana xuma wain umanganoa. ");
INSERT INTO met_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Bunging tela nung wain tela saing kakahana. Baing kinu mulang maluxu numang mokiamia. ");
INSERT INTO met_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Baing Ham, Kenan tibuna, bagu tibung mulanginoa, binabu sok mala saing baxanga na sabangandi. ");
INSERT INTO met_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Saking Siem Yapet tang daxap imanga saing doxoxi disui ubudingia mala numa mokiamia, saing daxabubua tibuding mulanginoa. Bungina dilibu bila ba, dibagu halianga bu dibagu tibuding mulanginoa te. ");
INSERT INTO met_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Bungina Noa baguti saing hatuminganoa xai muli, saing lungu ba baru kubolunta garang kimuama libu mana, ");
INSERT INTO met_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","bing harua ba, “Mauxanganoa bing xap Kenan! Bagula wa lipu oxata olanggam sibuna mana sabangandi.” ");
INSERT INTO met_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Baing harua xauna ba, “Taiti Toxoratamona yanoa, Siem Urana inia! Kenan bagula wa lipu oxata olanggam mana Siem. ");
INSERT INTO met_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ngaxusunga Urana ba libu Yapet titinoa tubu, xaung ba libu bakbagindi dirung xai rangua Siem bakbagindi, xaung ba Kenan wa lipu oxata olanggam mana.” ");
INSERT INTO met_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Kimuya mana silingua Noa wa niani 350. ");
INSERT INTO met_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noa nianindi disok 950, baing mati. ");
INSERT INTO met_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noa garang tuwadi Siem, Ham xaung Yapet, bakbagidingdi bila li. Daxapsaxi gara xumana kimuya mana silingua. ");
INSERT INTO met_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yapet garang lupdi bing: Gomer, Megok, Madai, Yaban, Tubal, Mesek xaung Tiras. ");
INSERT INTO met_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer garang lupdi bing: Askenas, Ripat xaung Togarma. ");
INSERT INTO met_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yaban garang lupdi bing: Elisa xaung Tasis. Kitdi xaung Dodandi disok mana Yaban xauna. ");
INSERT INTO met_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Bakbakkadi li disok lipu tekkamgadi dila dirung mauli mana titidinga tek rubinia mutumutia. Bakbak taining tainina xuading, bakbagiding xaung numanumading.) ");
INSERT INTO met_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham garang lupdi bing: Kus, Isip, Put xaung Kenan. ");
INSERT INTO met_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus garang lupdi bing: Seba, Habila, Sapta, Rama xaung Sapteka. Rama garang lupdi bing: Seba xaung Dedan. ");
INSERT INTO met_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus garang lup tela muli yanoa Nimrot. Ina lipu mugamugangam mana titia sok lipu haungingam haringina. ");
INSERT INTO met_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ina lipu idangam haringina Toxoratamona maxania. Namua naga daharua ba, “Lipua li bila Nimrot, lipu idangam haringina Toxoratamona maxania.” ");
INSERT INTO met_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Long sabanggadi wa xatamoxi manadi muga bing: Babel, Erek, Akat xaung Kalne. Long sabanggadi ba duwa titia Sinar. ");
INSERT INTO met_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Sauya titia ba saing ila titia Asiria, saing tongtongia long sabanggadi li: Ninibe, Rehobotir, Kala ");
INSERT INTO met_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","xaung Resen, long sabangga wa liwe mana Ninibe xaung Kala. ");
INSERT INTO met_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Isip tibuna mana bakbakkadi li mugangadinga: Lutdi, Anamdi, Lehapdi, Naptudi, ");
INSERT INTO met_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusdi, Kasludi (Pilistiadi disok manadi) xaung Kaptordi. ");
INSERT INTO met_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenan bakbakkadi li tibuding: Saidon garang matuaua, Hitdi, ");
INSERT INTO met_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebusdi, Amordi, Girgasdi, ");
INSERT INTO met_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hibdi, Arkdi, Sindi, ");
INSERT INTO met_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arbatdi, Semardi xaung Hamatdi. Kimuya Kenan bakbaging taining tainina dila hataing hataina. ");
INSERT INTO met_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Titi raguna Kenan dirung mana ba ungguti mana long sabangga Saidon saing ila bila long sabangga Gerar laing long sabangga Gasa. Baing ragudinga xugia bila long sabanggadi Sodam, Gomora, Adma xaung Seboyim laing long sabangga Lasa. ");
INSERT INTO met_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Bakbakkadi ba Ham garandi. Bakbak taining tainina bakbagiding, xuading, titiding xaung numanumading. ");
INSERT INTO met_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Siem Yapet sabanganoa, saing garang lupdi xauna. Siem Eberdi mugangadinga. ");
INSERT INTO met_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Siem garang lupdi bing: Elam, Asur, Arpaksat, Lud xaung Aram. ");
INSERT INTO met_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram garang lupdi bing: Us, Hul, Geter xaung Mas. ");
INSERT INTO met_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksat Sela tibuna, saing Sela Eber tibuna. ");
INSERT INTO met_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber garang lup luwa: Tela yanoa Pelek, namua na bungina wa lipu titiamdi dutu ding. Kixinginoa yanoa Yoktan. ");
INSERT INTO met_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan garadi bagudi li tibuding: Almodat, Selep, Hasarmabet, Yera, ");
INSERT INTO met_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO met_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO met_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opir, Habila xaung Yobap. Ding longgalo Yoktan garandi. ");
INSERT INTO met_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Titia bakbakkadi li duwa mana, raguna ungguti long sabanggaga Mesa ila bila Separ, wa mana xaxagandi duwa karagia. ");
INSERT INTO met_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Bakbakkadi ba Siem garandi. Bakbak taining tainina bakbagiding, xuading, titiding xuang numanumading. ");
INSERT INTO met_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Bakbakkadi ba disok mana Noa garandi. Suxingadingdi bila ba, numanumadingdi bila ba. Mana bakbakkadi ba, numanuma longgalo disok manadi saing dila dirung mauli mana titi longgalo kimuya mana silinga sabangua. ");
INSERT INTO met_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Muga lipu titiam longgalo xuading taininau, haruanga tela te. ");
INSERT INTO met_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Lipudi dila dila duwa karagia, baing disok mana goma sabanga tela wa titia Sinar, saing dirung la ba. ");
INSERT INTO met_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Baing daharua na ding ba, “Ama, tatongtongia birikdi, tataudi yabia bu daharing.” Binabu ditongtongia axamandi birigia. Ditongtongia saingia te. Baing ditaga birikdi mana kolta. Ditaga mana simen te. ");
INSERT INTO met_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Saking daharua ba, “Ama, tatongtongia long sabanga tela nakira xaung numa maxaxayam tela haing mala laing sok taxa sabalunia. Bila balau bagula ramramora sabanga, nam tasup mala mana titi longgalo hataing hataina.” ");
INSERT INTO met_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Baing Toxoratamona ri ma ba bagu long sabangga xaung numa maxaxaya lipu titiamgadi ditongtongia. ");
INSERT INTO met_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Baing Toxoratamona harua ba, “Lipadi li bakbak taininau xuading taininau. Nabu dungguti ba dilibu bila li, bing bagula dilibu axamang longgalo dahau hatumingadinga ba dilibudi. ");
INSERT INTO met_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ama, tari mala bu talibudi dahasuxi mana xuadinga bu daxabia riadingdi xuadingdi te.” ");
INSERT INTO met_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Binabu Toxoratamona utudi saing disup mala mana titi longgalo hataing hataina, saing disauya oxatua mana long sabangga ba. ");
INSERT INTO met_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Namua naga duxu long sabangga ba Babel. Namua na Toxoratamona libu lipu titiam longgalo dahasuxi mana xuadinga. Baing utudi saing disup mala mana titi longgalo hataing hataina. ");
INSERT INTO met_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Siem bakbagindi bila li. Niani luwa kimuya mana silinga sabangua, Siem nianindi 100, baing xapsaxi Arpaksat. ");
INSERT INTO met_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Kimuya mana xapsaxi Arpaksat, Siem wa niani 500 muli saing garang teladi muli, haing xaung lup. ");
INSERT INTO met_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpaksat nianindi 35, baing xapsaxi Sela. ");
INSERT INTO met_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Kimuya mana xapsaxi Sela, Arpaksat wa niani 403 muli saing garang teladi muli, haing xaung lup. ");
INSERT INTO met_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela nianindi 30, baing xapsaxi Eber. ");
INSERT INTO met_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Kimuya mana xapsaxi Eber, Sela wa niani 403 muli saing garang teladi muli, haing xaung lup. ");
INSERT INTO met_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber nianindi 34, baing xapsaxi Pelek. ");
INSERT INTO met_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Kimuya mana xapsaxi Pelek, Eber wa niani 430 muli saing garang teladi muli, haing xaung lup. ");
INSERT INTO met_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelek nianindi 30, baing xapsaxi Reu. ");
INSERT INTO met_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Kimuya mana xapsaxi Reu, Pelek wa niani 209 muli saing garang teladi muli, haing xaung lup. ");
INSERT INTO met_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu nianindi 32, baing xapsaxi Seruk. ");
INSERT INTO met_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Kimuya mana xapsaxi Seruk, Reu wa niani 207 muli saing garang teladi muli, haing xaung lup. ");
INSERT INTO met_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruk nianindi 30, baing xapsaxi Nahor. ");
INSERT INTO met_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Kimuya mana xapsaxi Nahor, Seruk wa niani 200 muli saing garang teladi muli, haing xaung lup. ");
INSERT INTO met_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor nianindi 29, baing xapsaxi Tera. ");
INSERT INTO met_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Kimuya mana xapsaxi Tera, Nahor wa niani 119 muli saing garang teladi muli, haing xaung lup. ");
INSERT INTO met_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera nianindi 70, baing xapsaxi Ebram, Nahor xaung Haran. ");
INSERT INTO met_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera bakbagindi bila li. Tera xapsaxi Ebram, Nahor xaung Haran. Baing Haran xapsaxi Lot. ");
INSERT INTO met_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Bungina Tera wauyu, Haran mati yabania Ur, mana Kaldia titidinga. ");
INSERT INTO met_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ebram Nahor tang diyau. Ebram haininoa yanoa Sarai, saing Nahor haininoa yanoa Milka, Haran nanuhanginoa. Haran Milka Iska tang tibuna. ");
INSERT INTO met_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ne Sarai wa xuhi, garan te. ");
INSERT INTO met_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera xap garanoa Ebram, longanoa Sarai (Ebram haininoa), xaung garang ranggina Lot (Haran garanoa), saing gabudi diyunga long sabangga Ur wa Kaldia titidingia, saing dibo ba dila titia Kenan. Ne dila daxanga lia disok mana longga Haran, saing dirung la ba. ");
INSERT INTO met_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera nianindi 205, baing mati mana longga Haran. ");
INSERT INTO met_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Tauna, Toxoratamona harua na Ebram ba, “Usauya titima, bakbagimdi xaung tibum sibindi, saing ula mana titia bagula ngahatanga naung. ");
INSERT INTO met_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Bagula ngalibu bakbagimdi disok bakbak sabanga sibuna, saing bagula ngasina guxama naung. Bagula ngalibu yama sok sabanga sibuna, saing bagula uwa guxam na lipudi. ");
INSERT INTO met_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Bagula ngasina guxama na lipu gaxarea disina guxama naung, saing bagula ngasina mauxanganoa na lipu gaxarea dilibu doa maung. Baing mana ung bagula numanuma longgalo daxap guxama.” ");
INSERT INTO met_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Binabu Ebram ila, bila Toxoratamona bala ba, saing Lot ila rangua. Ebraham nianindi bila 75 bungina sauya longga Haran. ");
INSERT INTO met_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Xap haininoa Sarai, sabanganoa garanoa Lot, xaung xalingidingdi xaung lipuxiding oxatamdi daxapdi Haran, saing dimesa dahaxa mala titia Kenan. Disok Kenan, ");
INSERT INTO met_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","baing dahaxa maluxu mana titia ba laing disok mana xai sabangga wa More, haxek mana longga Sekem. Mana bungina baguba Kenandi duwa mana titia baguba. ");
INSERT INTO met_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Baing Toxoratamona owa masok mana Ebram saing harua ba, “Bagula ngasina titia li na bakbagima.” Binabu Ebram tongtongia kabukabu hananiangam tela la ba bu sabu mana Toxoratamona owa masok rangua. ");
INSERT INTO met_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Sup, baing mesa saing ila bila xaxagandi duwa Betel sanga karagia, saing tongtongia tabalaxainoa la ba. Betel wa yuwaxa xaung Ai wa karagia. La ba tongtongia kabukabu hananiangam tela bu sabu mana Toxoratamona saing uxu yanoa. ");
INSERT INTO met_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Sup, baing Ebram mesa ila muli, haxahaxa mala laing sok mana long xolianoa Negep. ");
INSERT INTO met_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Tauna, gesaga sok mana titia ba. Binabu Ebram ri mala Isip bu wa lobu la ba monga, namua na gesak sabanga sok. ");
INSERT INTO met_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Dila disok Isip raguna dibo ba diluxu, baing Ebram harua na haininoa Sarai ba, “Ulungu to. Ngaxabia ba ung haing gumanging sibuna. ");
INSERT INTO met_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Bungina Isipdi dibagung bagula daharua ba, ‘Haininoa naga.’ Baing ina naga, bagula dung nga mati bu daxapkung. ");
INSERT INTO met_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ubaladi ba ung hamungagua, bu dilibu xai manga namua na muruding maung, saing mana namua ba walingagua bagula sup te.” ");
INSERT INTO met_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Baing ina naga, bungina Ebram luxu Isip, Isipdi dibagu ba Sarai gumanging sibuna. ");
INSERT INTO met_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Baing bungina xaitamoxidinga Pero lipuxing yanamindi dibagu, dibaxanga gumanginganoa na Pero. Binabu daxap maluxu xaitamoxi numania. ");
INSERT INTO met_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Pero libu xai mana Ebram namua na hagaxa ba Sarai moxongonoa, saing Ebram xap sipsipdi, bulmakaudi, donki monindi xaung hagaxandi, haing lup oxata olanggamdi, xaung kameldi. ");
INSERT INTO met_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ne Toxoratamona libu businga sabangadi daxap Pero gabu lipu numanamdi, namua na xap Ebram haininoa Sarai. ");
INSERT INTO met_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Binabu Pero wagi Ebram ma saing harua ba, “Uria nga baru? Baruta ubaxanga maringina nanga te? Hainima baing! ");
INSERT INTO met_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Uharua ba, ‘Hamungagua’! Namua naga ngaxap bila hainigua. Ai, oxop hainima saing tang gala!” ");
INSERT INTO met_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Baing Pero tabina lipuxindi, binabu disuka Ebram gabu haininoa xaung xalinging longgalo mala. ");
INSERT INTO met_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Binabu Ebram haing sangua Isip mala titia Negep, gabu haininoa xaung xalinging longgalo. Lot xauna ila rangua. ");
INSERT INTO met_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","(Ebram xalinging xumana. Morung xumana, silba xaung gol inia xumana xauna.) ");
INSERT INTO met_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Baing sauya Negep, haxa mala tongtongia tongtongia tabalaxaindi mala laing sok mana longga Betel, mana longga wa lia mana Betel xaung Ai, longga waleu tabalaxainoa wa mana ba. ");
INSERT INTO met_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Longga baguba waleu tongtongia kabukabu hananiangama muga mana ba. La ba Ebram sabu mana Toxoratamona saing uxu yanoa muli. ");
INSERT INTO met_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Baing Lot haxa mala rangua Ebram, ing xauna sipsibindi xaung memendi xaung bulmakau iniadi xaung lipuxing xumana. ");
INSERT INTO met_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ne titia ba sanga mana tang duwa xauna te, namua na tang xalingiding xumana buk. ");
INSERT INTO met_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Binabu hagamiangua sok liwe mana Ebram morung wasanganamdi xaung Lot morung wasanganamdi. (Mana bungina baguba Kenandi xaung Peresdi duwa xauna mana titia baguba.) ");
INSERT INTO met_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Binabu Ebram harua na Lot ba, “Kitam sip taininau, binabu heku mana mauxanganoa wa liwe makira, xaung liwe mana morum wasanganamdi xaung morugu wasanganamdi. ");
INSERT INTO met_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ubagu, titi sabangga li sangaʼm kitam. Xai ba tautu kira. Umogu ung murungama. Nabu ula xong, bagula ngala rimamo. Nabu ula rimamo, bagula ngala xong.” ");
INSERT INTO met_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Baing Lot bagu mauli saing bagu Langga Yodan long gomang longgalo ila longga Soar titi oranam. Langing xumana bila Toxoratamona umanganoa xaung bila titia Isip. (Bungina baguli muga mana Toxoratamona hanggalangia long sabangga Sodam xaung Gomora.) ");
INSERT INTO met_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Binabu Lot mogu Langga Yodan titing gomang longgalo naina. Baing ina naga, mesa ila sanga karagia. Bila balau tang dutu ding. ");
INSERT INTO met_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ebram rungguyu mana titia Kenan. Ne Lot ila rung liwe mana long sabanggadi duwa long gomania, saing tongtongia tabalaxainoa haxek mana long sabangga Sodam. ");
INSERT INTO met_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ne Sodamdi diang sibundi, saing kuboluding diandi ditubu sibuna Toxoratamona maxania. ");
INSERT INTO met_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot sup mala, baing Toxoratamona harua na Ebram ba, “Umesa ubagu mauli mana sanga kanggua, sanga bukang, sanga karagia xaung sanga yuwaxa. ");
INSERT INTO met_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Titi longgalo hatata ubagudi, bagula ngasinadi naung xaung bakbagima. Bagula angia bungingbunginalo. ");
INSERT INTO met_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Bagula ngalibu bakbagimdi disok xumana buk bila titia gagabindi, bu nabu lipu tela sanga ba titi titia gagabindi, bing sanga ba titi bakbagimdi. ");
INSERT INTO met_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Umesa, uhaxa mauli mana titi maxaxayanganoa xaung tubunganoa, namua na ngasina naung.” ");
INSERT INTO met_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Binabu Ebram kisinga tabalaxainoa mala rung haxek mana longga Hebron, mana Mamre xaing sabangadi rubinia. La ba tongtongia kabukabu hananiangama bu sabu mana Toxoratamona. ");
INSERT INTO met_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Bila bungina baguba, xaitamoxi luwadi luwadi digugunia ba dahaunggana bixuadingdi. Yadingdi bing: Amrapel (xaitamoxi mana Sinar), Ariok (xaitamoxi mana Elasar), Kedorlaomer (xaitamoxi mana Elam) xaung Tidal (xaitamoxi mana Goyim). ");
INSERT INTO met_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Dila dahaunggana xaitamoxiadi li: Bera (xaitamoxi mana Sodam), Birsa (xaitamoxi mana Gomora), Sinap (xaitamoxi mana Adma), Semeber (xaitamoxi mana Seboyim) xaung xaitamoxi mana Bela (longga ba yan tela Soar). ");
INSERT INTO met_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Adi bixuading luwadi luwadi hiliadinga ba dila digugunia mana Long Gomana Sidim (duxu ba Long Gomana Mana Tek Matiana xauna), daxauxau ba dahaung. ");
INSERT INTO met_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Haunginga namuxinoa bing Kedorlaomer haxi mana xaitamoxi luwadi luwadi hiliadinga ba digim takisia na. Bila balau laing niani 12. Ne mana niani 13 hauxading. ");
INSERT INTO met_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Baing mana niani 14 Kedorlaomer gabu riandi xaitamoxi luwa hilianadi ba dila dahaunggana bixuadingdi. Mana daxangua (disok manadi teguyu), dahaunggana didali Repadi mana Longga Asterot Karnaim, Susdi mana longga Ham, Emdi mana Sabe Kiriataim, ");
INSERT INTO met_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","xaung Hordi mana xaxagandi duwa mana titia Seir. Kedorlaomer gabu riandi dahaunggana bixuadinggadi ba mala laing titia El Paran, haxek mana long xoliana. ");
INSERT INTO met_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Sup, baing digoxoya mala muli mana longga En Mispat (yan tela Kades). Didali long longgalo maluxu mana Amalekdi titidinga, xaung didali Amordi duwa longga Hasason-Tamar xauna. ");
INSERT INTO met_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ne adi muga hauxading mana ba, xaitamoxi mana Sodam xaung xaitamoxi mana Gomora xaung xaitamoxi mana Adma xaung xaitamoxi mana Seboyim xaung xaitamoxi mana Bela (longga ba yan tela Soar), ding dahaxa maxixinga mala saing digugunia gugunianga gugunianga mana Long Gomana Sidim ba dahaunggana ");
INSERT INTO met_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Kedorlaomer (xaitamoxi mana Elam), Tidal (xaitamoxi mana Goyim), Amrapel (xaitamoxi mana Sinar) xaung Ariok (xaitamoxi mana Elasar). Bila balau xaitamoxi luwadi luwadi dahaunggana luwadi luwadi hiliadinga. ");
INSERT INTO met_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ne Long Gomana Sidim baxagiʼm banggum koltamdi, saing bungina xaitamoxidi mana Sodam xaung Gomora bakbagidingdi dituba ba digiti mala, teladi xungdi mari manadi, ne teladi diluki mahaing mana xaxagandi. ");
INSERT INTO met_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Binabu Kedorlaomer gabu riandi daxap Sodam Gomora xalingidingdi xaung angiadingdi. Baing dilauba. ");
INSERT INTO met_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Baing dituxu Lot, Ebram sabanganoa garanoa, xaung xalingindi saing daxai mala xauna, namua na wa Sodam. ");
INSERT INTO met_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ne lipu tela giti mala sangua haungingua, ma rangua Ebram, HIbru tela, saing baxanga na. Mana bungina baguba Ebram tabalaxainoa wa Mamre xaing sabangadi rubinia. Mamre Amor tela, kixinging luwa, yadingdi Eskol xaung Aner. Tung dahau haruangua rangua Ebram ba dahauli ding nabu haungingua sok. ");
INSERT INTO met_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ebram lungu ba daxap sibinoa Lot mala, baing wagi lipuxing haungingamga 318 dima digugunia. Ding ba lipuxing oxatamdi disok numania xaung daxabia haungingua. Ebram gabu lipuxindi dila duxu xaitamoxi luwadi luwadi ba mala laing long sabangga Dan. ");
INSERT INTO met_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Baing yambong Ebram utu lipuxindi gugunianga gugunianga, saing dahaungganadi. Didalidi duxudi mala laing longga Hoba, wa long sabangga Damaskas sanga kanggua. ");
INSERT INTO met_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Bila balau daxap xalaxala longgalo muli saing daxap sibinoa Lot xaung xalingindi, xaung haingdi xaung lipu teladi ma muli. ");
INSERT INTO met_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ebram dali xaitamoxi Kedorlaomer gabu riandi laing sup, baing goxoya ma muli. Baing xaitamoxi mana Sodam sok ma bu gugunia mana Long Gomana Sabe (yan tela Long Gomana Xaitamoxi). ");
INSERT INTO met_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Baing Melkisadek xaitamoxi mana long sabangga Salem ma. Ina lipu hananiangam mana Urana Eta Loam Sibuna. Xap salanga xaung wain ma, ");
INSERT INTO met_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","saing sina guxama na Ebram, harua ba, “Urana Eta Loam Sibuna, Lipua tongtongia long xaiya xaung titia, sina guxama na Ebram. ");
INSERT INTO met_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Urana Eta Loam Sibuna ta bixuamdi rimamia, binabu taiti yanoa.” Baing Ebram sina hataing 10 mana axamang longgalo xap haungingia na Melkisadek. ");
INSERT INTO met_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Xaitamoxi mana Sodam harua na Ebram ba, “Usina lipudi digoxoya ma nanga, ne oxop xalaxaladi naung.” ");
INSERT INTO met_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ning Ebram harua na xaitamoxi mana Sodam ba, “Ngaiti rimagua bu ngahau haruangua rangua Toxoratamona, Urana Eta Loam Sibuna, Lipua tongtongia sabalauna xaung titi. Ngahau bila li: ");
INSERT INTO met_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Bagula ngaxap xalingim tela monga te. Tegu sibuna. Heku waxu ragangam kimbo waxu xai sangang raganganam. Nam kimuya uharua ba, ‘Ngalibu Ebram sok lipu xalaxalam.’ ");
INSERT INTO met_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Bagula nga ngaxap axamang tela nanga te. Angingua lipuxigudi daxang masup, sanga ba. Ning uyunga riagu luwa hiliana dila rangua nga ba, Aner, Eskol, Mamre ba tung daxap sinagidingdi.” ");
INSERT INTO met_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Bunging tela disup, baing Toxoratamona sina haruangua na Ebram mana axamang tela bila mibingua. Harua ba, “Ebram, labu umaxuwau tai. Nga bila xaim haunginga soxautinganama, Haxuyangama bagula sabanga sibuna.” ");
INSERT INTO met_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ning Ebram harua ba, “Toxoratamona Urana ngayua, Bagula usina baraxinta nanga, namua na nga garagu te? Lipua bagula xap xalingigudi bungina ngamati bing lipu Damaskasiam Elieser.” ");
INSERT INTO met_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Baing Ebram harua muli ba, “Bagu usina gara tela nanga te, binabu lipu numaguamga li bagula xap xalingigu longgalo.” ");
INSERT INTO met_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Baing Toxoratamona sina haruangua na ba, “Tegu! Lipua li bagula lipu xalingim xabinganama te. Garam sibuna sok mana ung sibum sibima bagula lipu xalingim xabinganama.” ");
INSERT INTO met_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Baing xap masok sabasabia saing harua ba, “Ubagu mahaing sabalunia, saing utiti hatungdi. Sanga ba utitidi?” Baing harua na ba, “Bagula bakbagimdi disok xumang sibuna bila ba.” ");
INSERT INTO met_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ebram hatum haringina mana Toxoratamona, binabu uxu ba lipu maringina. ");
INSERT INTO met_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Baing harua na ba, “Nga Toxoratamona. Ngaxapkung masok sangua longga Ur wa Kaldia titidingia bu ngasina titia baguli naung ba oxop bila ung titima.” ");
INSERT INTO met_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ne Ebram harua ba, “O Toxoratamona Urana ngayua, bagula ngaxabia baru ba ngaxap titia li bila ngayua?” ");
INSERT INTO met_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Baing harua na ba, “Oxop axadi bagudi li ma rangua nga. Oxop bulmakau hagaxang tela, meme hagaxang tela xaung sipsip moning tela, taining taining nianing tuwa, xaung baxaliku tela xaung gumak tela.” ");
INSERT INTO met_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Baing xapdi masup ma rangua, ning saha asaxadi hataing luwa saing riridi hataing hataina maxixinga luwa. Ne mang luwadi ba ning sahadi te. ");
INSERT INTO met_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Baing buntuk teladi diri mana asaxadi ba, ne Ebram xudi mala. ");
INSERT INTO met_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Xaidaba bo ba riuba, baing kinunga ung Ebram. Kinu hadali baing labiang sabanga kau, binabu maxuwanga sabanga xap. ");
INSERT INTO met_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Baing Toxoratamona harua na Ebram ba, “Ngabo ba uxabia sibuna ba bakbagimdi bagula duwa lipu titi telamdi mana titi tela dingia te. Bagula duwa lipu oxata olanggamdi la ba, saing bagula daxap salaga bila ba laing niani 400. ");
INSERT INTO met_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ne bagula ngasuxuya bakbakka dituxu oxatading olanggamdi manadi ba. Sup, baing bagula disok sangua titia ba xaung xalaxala xumana. ");
INSERT INTO met_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ne ung ba, bagula umati mosiu, saing bagula dikimanggung bungina uwa duanga sibuna. ");
INSERT INTO met_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Bungina maxixingam luwadi luwadi disup to, tauna bagula digoxoya ma muli la li. Sanga digoxoya ma sap te, namua na ngabo ba ngasina salaga na Amordi mana kuboluding diandi, ne kuboluding diandi dibaxagi teguyu.” ");
INSERT INTO met_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Xaidaba ri saing yambong lo, baing bori yapkam tela bunuxu ba xaung nagung tela lu ba dowa masok saing dahaxa liwe mana asaxa hatainadi ba. ");
INSERT INTO met_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mana xaidapka baguba Toxoratamona hau haruangua na Ebram, saing harua ba, “Ngasina titia li na bakbagimdi. Titi ragunoa bing ungguti mana langga Isip ila laing sok mana lang sabangga duxu ba Yupretis, ");
INSERT INTO met_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","titia ba hatata moxonadi li duwa mana: Kenidi, Kenisdi, Kadmondi, ");
INSERT INTO met_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hitdi, Peresdi, Repadi, ");
INSERT INTO met_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amordi, Kenandi, Girgasdi, xaung Yebusdi.” ");
INSERT INTO met_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Tauna, Ebram haininoa Sarai hayau na te. Ne Sarai haining oxata olanggam tela, Isip tela yanoa Hagar. ");
INSERT INTO met_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Binabu Sarai harua na Ebram ba, “Ulungu nga to. Toxoratamona soxauti nga ba ngahayau te. Ula ukinu rangua hainigu oxata olanggama. Bola mana daxanga naga bakbagigua bagula sok.” Baing Ebram nai mana Sarai haruanganoa. ");
INSERT INTO met_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Binabu Ebram haininoa Sarai xap haining oxata olanggama Hagar, haing Isipkama, saing sina na ayuanoa Ebram bila haininoa. Mana xaidapka baguba Ebram wa mana titia Kenan niani 10. ");
INSERT INTO met_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Kinu rangua Hagar, saing gamona. Bungina Hagar bagu xabia ba gamona, ungguti ba hauxana mana haining haringinoa Sarai. ");
INSERT INTO met_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Baing Sarai harua na Ebram ba, “Namua mauxangana li xap nga bing ung baing! Nga ngata hainigu oxata olanggama ranguaung ba uhatabu. Baing ina naga, hatata xabia ba gamona, binabu hauxana manga. Ngawagi mana Toxoratamona ba suxuya gaxarea libu doa—ung kimbo nga!” ");
INSERT INTO met_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Baing Ebram harua ba, “Ulungu nga to. Hainim oxata olanggama wa hawa maung. Binabu ulibu baraxing baraxinta uhatum ba xai mana.” Saking Sarai libu doa mana Hagar laing sauya mala. ");
INSERT INTO met_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Toxoratamona uleginama sok mana Hagar haxek mana lang maxamaxang tela wa long xoliania, mana daxanga ila longga Sur. ");
INSERT INTO met_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Baing harua ba, “Hagar, Sarai haining oxata olanggama, uma bi ma, saing ula bi?” Haxuya ba, “Ngasauya hainigu haringinoa Sarai saing ngaluki ma.” ");
INSERT INTO met_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Toxoratamona uleginama harua na ba, “Ugoxoya mala muli rangua hainim haringinoa saing uwa hawa mana.” ");
INSERT INTO met_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Baing Toxoratamona uleginama harua muli ba, “Bagula ngalibu bakbagimdi disok xumang sibuna, sanga mana lipudi dititidi te.” ");
INSERT INTO met_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Baing Toxoratamona uleginama harua muli na ba, “Ulungu to, gamom saing bagula uhayau gara lup tela. Bing uxu yanoa ba Ismael, namua na Toxoratamona lungu tinangingam mauxanganama. ");
INSERT INTO met_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Bagula wa bila donki abungina, bagula xukxugia lipu longgalo, saing lipu longgalo bagula duxukxugia, saing bagula wa sibing longgalo bixuadinga.” ");
INSERT INTO met_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagar sina yaya baguli na Toxoratamona harua na ba: “Ung Urana ubagu nga.” Namua na harua ba, “Ngabagu Urana bagu nga ba.” ");
INSERT INTO met_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Namua naga duxu lang maxamaxana ba Ber-Lahai-Roi. Wauyu la ba, liwe mana longgadi Kades xaung Beret. ");
INSERT INTO met_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Binabu Hagar hayau garang luba na Ebram, saing Ebram uxu yanoa ba Ismael. ");
INSERT INTO met_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ebram nianidi 86 bungina Hagar hayau Ismael na. ");
INSERT INTO met_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ebram nianindi 99, baing Toxoratamona owa masok mana, saing harua ba, “Nga Urana Haringing Sibuna. Bing ulibu kubolu maringing sibuna maxagia xaung oxola mana kubolu dian tela. ");
INSERT INTO met_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Baing bagula ngahau haruangugua liwe mana kitam, saing bagula ngalibu bakbagimdi disok xumang sibuna.” ");
INSERT INTO met_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Baing Ebram gung king tuxundi mari, ta ramramonoa titia, saing Urana harua na ba, ");
INSERT INTO met_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ulungu to. Haruangua nga ngahau ranguaung bing: Bagula uwa numanuma xumana mugangadinga. ");
INSERT INTO met_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Hatata ila bagula duxu yama Ebram te. Bagula duxung ba Ebraham. Namua na ngamogung ba usok numanuma xumana mugangadinga. ");
INSERT INTO met_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Bagula ngalibu bakbagimdi disok xumana buk, bu duwa numanumadi, saing teladi bagula disok xaitamoxidi. ");
INSERT INTO met_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Bagula ngahau haruanga li liwe mana kitam xaung bakbagimdi disok kimu, saing bagula wa bungingbunginalo. Haruanga ngahau bing: Ngawa Urana ungia xaung Urana mana bakbakgimdi disok kimu. ");
INSERT INTO met_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Titia Kenan hatata uwa lobu mana, bagula ngasina ba wa ungia xaung bakbagimgadi disok kimuya maung dingia bungingbunginalo. Baing bagula ngawa Urana dingia.” ");
INSERT INTO met_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Baing Urana harua na Ebraham ba, “Ne ung ba, bing ung gusu mana haruangua ngahau ba, ung xaung bakbagimdi disok kimu bing asu mana. ");
INSERT INTO met_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Haruangua ngahau ranguaung xaung bakbagimdi disok kimu, haruangua asu mana bing: Lup longgalo liwe mang bing axuxu sanggadingdi. ");
INSERT INTO met_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Axuxu sanggaimdi ba mogu haruangua ngahau liwe makira. ");
INSERT INTO met_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Hatata saing ila, gara lup longgalo liwe mang, bungina xaidabidingdi 8 bing axuxu sanggadingdi. Adi li xauna: lipuxim oxata olanggamdi baudingdi dahayaudi numaimia xaung adi agimdi rangua bakbak teladi—adi bakbagim sibundi te. ");
INSERT INTO met_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Heku baudingdi dahayaudi numaimia kimbo agimdi, ding longgalo bing axuxu sanggadingdi. Bila balau haruangua ngahau ranguang bagula mogunganoa mana sanggaimdi bu hatanga wa bungingbunginalo. ");
INSERT INTO met_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Lup gaxarea xap sangga xuxungan te bing asuka sangua bakbagima namua na dali haruangua ngahau ranguang ba.” ");
INSERT INTO met_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Baing Urana harua na Ebraham muli ba, “Ne hainima Sarai ba, hatata ila uxu yanoa ba Saraiu tai. Yanoa bagula Sara. ");
INSERT INTO met_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Bagula ngasina guxama na, saing daxanga naga bagula ngasina gara lup tela naung. Bagula ngasina guxama na bu wa numanuma xumana mugangadinga. Teladi bagula disok bakbakdi xaitamoxidingdi.” ");
INSERT INTO met_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Baing Ebraham gung king tuxundi mari, ta ramramonoa titia, saing masisi saing hatum ba, “Nianigudi 100. Bagula ngasok gara tibuna baru? Baing Sara nianindi 90. Bagula hayau gara baru?” ");
INSERT INTO met_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Baing Ebraham harua na Urana ba, “Bola unai mana Ismael xap guxamingama!” ");
INSERT INTO met_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Baing Urana harua ba, “Tegu. Hainima Sara bagula hayau gara lup naung, bing uxu yanoa ba Aisak. Bagula ngahau haruangua rangua xaung bakbagindi disok kimu, saing bagula wa bungingbunginalo. ");
INSERT INTO met_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ne Ismael ba, ngalungung baing. Maxuna bagula ngasina guxama na. Bagula ngalibu bakbagindi disok xumana buk. Bagula sok yanam haringing 12 tibuding, saing bagula garandi disok bakbak sabanga sibuna. ");
INSERT INTO met_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ning Aisak naga bagula ngahau haruangagua rangua, lipua Sara bagula hayau naung bila sobakka baguli niani etuama.” ");
INSERT INTO met_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Harua rangua Ebraham laing sup, baing Urana sauya saing haing. ");
INSERT INTO met_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Mana xaidapka naga Ebraham xap garanoa Ismael xaung lipuxing oxata olanggam longgalo dahayaudi numania xaung adi gimdi, lup longgalo duwa numania, xapdi mala saing xuxu sanggadingdi, bila Urana bala ba. ");
INSERT INTO met_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ebraham nianindi 99 bungina duxuxu sangganoa, ");
INSERT INTO met_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","saing garanoa Ismael nianindi 13. ");
INSERT INTO met_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Mana xaidapka naga duxuxu Ebraham Ismael tang sanggadingdi. ");
INSERT INTO met_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Baing duxuxu Ebraham lipuxing oxata olanggam longgalo sanggadingdi xauna, adi dahayaudi numania xaung adi gimdi rangua bakbak teladi. Duxuxu lup numanam longgalo rangua Ebraham. ");
INSERT INTO met_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Toxoratamona owa masok mana Ebraham muli mana Mamre xaing sabangadi rubinia. Xaidaba sala, saing Ebraham rung xahing xaluxinia. ");
INSERT INTO met_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Bagu mahaing saing hata sibuna li bagu lipu tuwa dili maxania. Bungina bagudi, mesa yunga xahing xaluxinoa saing luki mala ranguadi, saing gung king tuxundi turu mari titia. ");
INSERT INTO met_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Harua ba, “Lipu sabanga, nabu uyaha manga, bing uwa mongaita rangua nga lipuxim oxatama. ");
INSERT INTO met_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Uyunga lipuxigu oxatama xap langa ma bu adamia kimdi to. Tauna, ayagua xai namuya li. ");
INSERT INTO met_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Uyunga ngaxap anginga teladi ma nang bu haringiang to, tauna ala. Namua na ama rangua nga lipuxim oxatama.” Baing daharua ba, “Sangau, ulibu bila uharua ba.” ");
INSERT INTO met_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Binabu Ebraham ila sap xahia rangua Sara saing harua ba, “Ugogolinga! Oxop wit gagabing xai sibuna minang tuwa! Uxaningxaning salangadi saing utaudi.” ");
INSERT INTO met_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Saking luki mala rangua bulmakaung bakbakka saing mogu tutubing dungmananganam tela. Xap mala rangua lipuxing oxatama ba tutu tau sap. ");
INSERT INTO met_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Baing xap bulmakau suing langina xaung sis xaung bulmakau mututungana tau ba ma, saing sinadi nadi. Daxang mua, baing Ebraham li haxek ranguadi xai tela namuya. ");
INSERT INTO met_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Duxusunga ba, “Hainima Sara kabi?” Haxuya ba, “Bagu wa xahi lunia.” ");
INSERT INTO met_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Baing tela harua ba, “Bagula ngagoxoya ma muli mana sobakka baguli niani etuama, saing hainima Sara bagula sep ing sibung garang luba.” Ne Sara lungu haruanganoa, namua na wa xahi xaluxinia lipua ba ubunia. ");
INSERT INTO met_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ebraham Sara tang duwa duanga ba, binabu Sara nianing hayauxingamdi disup ba. ");
INSERT INTO met_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Baing ina naga Sara masisi lunia saing hatum ba, “Sanggangua xabati ba, xaung ayuagua wa duanga ba. Ne hatata bagula yahangua bila li xap nga baru?” ");
INSERT INTO met_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Baing Toxoratamona harua na Ebraham ba, “Baruta Sara masisi saing harua ba, ‘Nga muganga buk, binabu bagula ngahayau baru?’ ");
INSERT INTO met_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Axamang tela haxi buk mana Toxoratamona te. Bagula ngagoxoya ma muli mana sobakka baguli niani etuama bila menau ngamogu ba, saing Sara bagula sep ing sibung garang luba.” ");
INSERT INTO met_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara maxuwa binabu hatiam saing harua ba, “Nga ngamasisi te.” Ne harua ba, “Tegu, umasisi baing.” ");
INSERT INTO met_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Lipu tuwadi ba dimesa dilauba, baing tung dibagu mari mala mana long sabangga Sodam. Baing Ebraham haxa mala ranguadi ba yungadi daxangia. ");
INSERT INTO met_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Baing Toxoratamona harua ba, “Bagula ngayameng hatumingagua ngahau ba mana Ebraham? Tegu. ");
INSERT INTO met_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Maxung sibuna Ebraham bakbagindi bagula disok numanuma haringina, bagula ramramoding sabanga. Baing mana ina, bagula numanuma titiam longgalo daxap guxama. ");
INSERT INTO met_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Namua na ngamogu bu tabina garandi xaung bakbagidingdi dima kimu ba disu mana Toxoratamona daxanganoa, bu dilibu kuboluadi daxai xaung dimaring. Baing ina naga, bagula ngalibu haruanga longgalo mana Ebraham bila ngahau ba.” ");
INSERT INTO met_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Baing Toxoratamona harua ba, “Ngalungu harungianga xumang sibuna daharungia long sabangga Sodam Gomora tang. Kuboludingdi didoa sibuna. ");
INSERT INTO met_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Binabu bagula ngari mala bu ngabagu nabu kuboluadi dilibudi bila haruanga ngalungu ba. Nabu tegu, bing bagula ngaxabia.” ");
INSERT INTO met_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Sup, baing lipu luwadi duxugia dahaxa mala Sodam. Ne Ebraham wauyu, li mua Toxoratamona maxania. ");
INSERT INTO met_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Baing Ebraham ila haxek rangua saing xusunga ba, “Maxuna bagula uhanggalangia lipu kubolu maringinamdi xaung lipu kubolu dianamdi xauna? ");
INSERT INTO met_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Nabu lipu kubolu maringinam 50 duwa mana long sabangga ba. Maxuna, bagula uhanggalangia longga ba masup? Bola uyungadi duwa bu lipu maringingam 50 ba disup te? ");
INSERT INTO met_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Labu uhatumia ulibu bila bau tai—ung lipu kubolu maringinamdi xaung lipu kubolu dianamdi xauna dimati. Bagula bila ulibu kubolu taininau mana lipu kubolu maringinamdi xaung lipu kubolu dianamdi. Labu uhatumia ulibu bila bau tai! Lipu titiam longgalo Suxuyangadinggama bing libu maringina, maxuna?” ");
INSERT INTO met_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Baing Toxoratamona harua ba, “Nabu ngabagu lipu kubolu maringinam 50 duwa mana long sabangga Sodam, bing bagula ngayunga ding longgalo duwa bu 50 ba disup te.” ");
INSERT INTO met_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Baing Ebraham harua muli ba, “Toxoratamona, ngausinga ngaungguti ngaharua naung bila ba, ne nga bila gagap xaung hayata ing ganina. Ne ngabo ba ngaharua muli. ");
INSERT INTO met_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Heku lipu maringinam 50, nabu ngaunia 5 mana titingadinga. Bagula uhanggalangia longga ba masup namua na 5 ba duwa te?” Baing Toxoratamona harua ba, “Nabu ngabagu lipu maringinam 45 duwa la ba, bagula ngahanggalangia te.” ");
INSERT INTO met_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Baing Ebraham harua muli na ba, “Bola 40 ding ganiding duwa la ba, bing baruta?” Baing Toxoratamona harua ba, “Mana namua 40 duwa, bing bagula ngalibu te.” ");
INSERT INTO met_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Baing Ebraham harua ba, “Toxoratamona, sanga ba atim disala manga te. Ne ngabo ba ngaharua muli. Bola 30 ding ganiding duwa la ba, bing baruta?” Baing Toxoratamona haxuya ba, “Mana namua ngabagu 30 duwa, bing bagula ngalibu te.” ");
INSERT INTO met_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Baing Ebraham harua ba, “Toxoratamona, ngaharua naung xumana bila ba, ne ngabo ba ngaharua muli. Bola 20 ding ganiding duwa la ba, bing baruta?” Baing Toxoratamona harua ba, “Mana namua ngabagu 20 duwa, bing bagula ngahanggalangia te.” ");
INSERT INTO met_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Baing Ebraham harua ba, “Toxoratamona, sanga ba atim disala manga te. Ne ngabo ba ngaharua bunging tela muli. Bola 10 ding ganiding duwa la ba, bing baruta?” Baing Toxoratamona harua ba, “Mana namua ngabagu 10 duwa, bing bagula ngahanggalangia te.” ");
INSERT INTO met_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Toxoratamona harua rangua Ebraham laing sup, baing ilauba. Baing Ebraham goxoya mala numia muli. ");
INSERT INTO met_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Yambong baing Urana uleginam luwadi ba tang disok mana long sabangga Sodam. Baing Lot rung mua gugunianga yabania haxek mana long sabangga ba xaluxinia. Bagudi, baing mesa ila ranguadi, saing gung king tuxundi turu mari titia. ");
INSERT INTO met_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Harua ba, “Lipu sabanga luwa mana, nga lipuxim oxatama. Xai mana tang gama numagia. Sanga ba tang gadamia kimdi akinu to. Tauna buraraging sibuna amesa ahaxa muli.” Ne tang dahaxuya ba, “Tegu. Bagula tam gakinu gugunianga yabania li.” ");
INSERT INTO met_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ne Lot haxi dingtang buk, binabu tang dila rangua numania. Tongtongia taungua na dingtang, tau salanga salalangang teguam, saing tang daxang. ");
INSERT INTO met_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Tang dikinu teguyu, baing Sodam lupdi, ding longgalo, gananundi digabu lipu haringindi, dima dilip numua. ");
INSERT INTO met_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Duwagi Lot ba, “Lipuadi yambong dima ranguaung duwa bi? Oxopdi masok ma ranguam bu am gakinu ranguadi.” ");
INSERT INTO met_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot sok mala ranguadi xaluya saing riba. ");
INSERT INTO met_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Baing harua ba, “Riagu mana, ngaxusungang haringina ba alibu kubolu diana li te. ");
INSERT INTO met_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Alungu to. Nga nanuhangigu luwa, ne tang dikinu rangua lup tela teguyu. Bagula ngaxap dingtang masok mala ranguang bu asahi murungaima mana dingtang. Ne lipu luwadi li, labu alibu axamang tela mana dingtanggu tai, namua na duwa lobudi numagia binabu ngawasa manadi.” ");
INSERT INTO met_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ne dahaxuya ba, “Uhaya!” Baing daharua ba, “Yabama la li te, binabu maring ba ubiliamgu tai! Kubolua am galibu maung bagula doa sibuna mana kubolua am galibu mana dingtang!” Baing dahayuyu mala rangua Lot ba dutu saha xalua. ");
INSERT INTO met_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ne lobu luwa tang dita rimadingdi masok dituxu Lot saing daxai maluxu, saing diriba xalua. ");
INSERT INTO met_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Baing tang dilibu lipuadi duwa xaluya ba maxading dahaxatu, gananundi digabu lipu haringindi. Binabu disaisai mana xalua susu. ");
INSERT INTO met_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Baing lobuadi ba duxusunga Lot ba, “Ung bakbagim teladi muli duwa la li? Longamdi? Garamdi? Kimbo teladi duwa mana long sabangga li? Oxopdi masok sangua longga li, ");
INSERT INTO met_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","namua na bagula tam gahanggalangia long sabangga li masup. Toxoratamona lungu harungianga sabanga sibuna daharungia longga li, binabu soxiamtam ba am gahanggalangia.” ");
INSERT INTO met_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Baing ina naga, Lot ila rangua lipu luwadi dahau gabisia mana diyau nanuhangindi, saing baladi ba, “Tang gamesa sap bu asauya long sabangga li! Namua na Toxoratamona bo ba hanggalangia long sabangga liuba.” Ne gananung luwadi ba tang dahagaxa ba harua halinga. ");
INSERT INTO met_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Longa usa, baing Urana uleginam luwadi dahaxi Lot ba, “Umesa sap! Oxop hainima xaung nanuhangim luwadi duwa la li mala. Nam usup rangua longga li lipuxindi bungina daxap doa.” ");
INSERT INTO met_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ning halisi. Binabu lobudi ba tang dituxu rimanoa xaung hainina xaung nanuhangindi rimadingdi saing daxaidi masok sangua long sabangga ba, duwa sangau. Namua na Toxoratamona usinga. ");
INSERT INTO met_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Tang daxaidi masok laing sup, baing hata sibuna li tela harua ba, “Aluki mala sap nam amati! Labu axugia saing abagu ma muliu tai. Xaung labu ayagua monga mana long gomanau tai! Aluki mala bimbiadi lo sap nam asup!” ");
INSERT INTO met_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ne Lot harua na dingtang ba, “O lipu sabanga luwa mana, tegu! Sanga ba ngalibu bila ba te. ");
INSERT INTO met_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Alungu nga lipuxim oxatam to. Alibu kubolu xai sibuna manga xaung ahauli nga sabanga bu ngamati te. Ne sanga ba ngaluki mala bimbiadi lo te, nam hanggalangiangua xap nga saing ngamati. ");
INSERT INTO met_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Abagu, long tela wa hataina lo. Haxek sanga mana ngaluki mala ngasok mana. Long kaxukana ba. Anai ba nga ngaluki mala mana. Ubagu ba kaxukana, a? Baing ina naga, bagula ngadali hanggalangiangua.” ");
INSERT INTO met_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Baing haxuya na ba, “Sangau. Bagula nganai mana xusungangama li xauna. Bagula ngahanggalangia long kaxukana ba te. ");
INSERT INTO met_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ne uluki mala sap, namua na sanga ba ngalibu axamang tela te, laing usok mana longga ba to.” (Namua naga duxu longga ba Soar.) ");
INSERT INTO met_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Xaidaba haingguba, baing Lot sok mana longga Soar. ");
INSERT INTO met_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Baing Toxoratamona libu siang salpa buyamang yabinamdi diri mana long sabangga Sodam xaung Gomora. Toxoratamona naga sinadi mari sangua sabalunoa. ");
INSERT INTO met_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Bila balau hanggalangia long sabanggadi ba xaung long gomana ba masup. Lipu longgalo duwa manadi xaung axamang longgalo dahaing mana titia ba disup. ");
INSERT INTO met_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ne Lot haininoa bagu goxoya mala kimu, baing xugia sok mosak saing li bila tuxa tela. ");
INSERT INTO met_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Buraraging sibuna baing Ebraham mesa saing goxoya mala muli mana longga muga li Toxoratamona maxania. ");
INSERT INTO met_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Bagu mari mala mana Sodam xaung Gomora, xaung mana goma longgalo, saing bagu yap bunuxuyanoa buxuixui mahaing mana titia ba, bila yap sabangua tau raxang tela. ");
INSERT INTO met_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Baing ina naga, bungina Urana hanggalangia long sabanggadi duwa gomania, hatumia muli Ebraham, saing xap Lot sangua hanggaliangua sahi long sabanggadi Lot wa mana ba. ");
INSERT INTO met_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Tauna, Lot gabu nanuhanging luwa disauya longga Soar saing dila dirung bimbia, namua na maxuwa ba wa Soar. Gabu nanuhanging luwa duwa guhia. ");
INSERT INTO met_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Xaidap tela matuaua harua na kixinginoa ba, “Tibura wa duanga ba, saing titia li lup te ba kinu rangua kitam, bila lipu titiamdi dilibu. ");
INSERT INTO met_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Tala talibu tibura nung wain laing kakahana bu takinu rangua. Baing ina naga, bakbagira sanga ba sup te xaung tibura bagula wa mugangadinga.” ");
INSERT INTO met_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Yambongga baguba baing tang dilibu tibuding nung wain laing kakahana, saing matuaua ila kinu rangua. Ne ina xabia bungina nanuhanginoa ma kinu kimbo mesa ila te. ");
INSERT INTO met_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Buragina baing matuaua harua na kixinginoa ba, “Bagu, bunggu ngakinu rangua tibugu. Yambong bagula talibu nung wain laing kakahana muli. Baing ula ukinu rangua bu bakbagira sanga ba sup te xaung tibura bagula wa mugangadinga. ");
INSERT INTO met_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Binabu yambongga baguba dilibu tibuding nung wain laing kakahana muli, saing nanunoa ila kinu rangua. Ne ina xabia bungina nanuhanginoa ma kinu kimbo mesa ila te. ");
INSERT INTO met_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Baing ina naga, Lot nanuhanging luwadi tang gamoding mana tibuding. ");
INSERT INTO met_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Matuaua hayau gara lup, saing uxu yanoa ba Moap. Lipuadi hatata tauxudi Moapdi, mugangadinga naga. ");
INSERT INTO met_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nanunoa xauna hayau gara lup, saing uxu yanoa Ben-Ammi. Lipuadi hatata tauxudi Amondi, mugangadinga naga. ");
INSERT INTO met_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ebraham sauya longga wa mana, saing haxahaxa mala bila titia Negep saing rung liwe mana longga Kades Sur tang. Baing kimuya ila rung mana longga Gerar. ");
INSERT INTO met_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","La ba Ebraham bala lipudi mana haininoa Sara ba, “Hamungagua.” Binabu Abimelek, xaitamoxi mana Gerardi, soxi lipuxindi mala ba daxap Sara ma rangua. ");
INSERT INTO met_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ne yambong tela Urana ma rangua Abimelek mibingia, saing bala ba, “Haxek sibuna bagula umati! Namua na haingga oxop ba yaungam.” ");
INSERT INTO met_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ne Abimelek kinu rangua Sara teguyu, binabu harua ba, “Toxoratamona, bagula uhanggalangia bakbakka doxola mana kubolu dianoa? ");
INSERT INTO met_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ing sibuna harua nanga ba, “Hamungagua,” maxuna? Xauna Sara ing sibuna harua ba, “Moxongogua,” maxuna? Kubolugua ngalibu su hatumingagua te. Ngasigixinga.” ");
INSERT INTO met_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Baing Urana harua na mibingia ba, “Wane, ngaxabiau. Kuboluma li su hatumingama te. Namua naga ngasoxautiung ba ukinu rangua te, binabu ulibu kubolu dianoa maxagia te. ");
INSERT INTO met_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ne hatata bing usuka haingga ba mala muli rangua ayuana. Namua na lipua ba lipuxigu suxunguxunguama. Binabu bagula sabu maung bu hauliung ba sanga ba uwa. Ning nabu usuka mala muli te, bing maxung sibuna bagula ugabu lipuxim longgalo amati.” ");
INSERT INTO met_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Buragina buraraging sibuna, baing Abimelek wagi yanamindi dima. Baxanga nadi mana baraxinta sok, baing dimaxuwa sibuna. ");
INSERT INTO met_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Baing Abimelek wagi Ebraham ma, saing harua ba, “Uraxata mam? Ngalibu kubolu diang baruamta naung? Ne ulibu kubolu diang sibung haruangang sulingama xap nga xaung lipuxigu yonggaxiguamdi. Kubolua ulibu manga ba maring te.” ");
INSERT INTO met_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Baing Abimelek xusunga Ebraham ba, “Mana baru namuxinta ulibu bila ba?” ");
INSERT INTO met_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ebraham haxuya ba, “Ngahatum ba, ‘Longga li moxondi dimaxuwa Urana te. Baing bagula dung nga mati bu daxap hainigua. ");
INSERT INTO met_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Xauna, maxuna hamungagua baing. Tam tibumam taininau, ne baugu xan tela. Ne ngayau. ");
INSERT INTO met_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Bungina Urana bala nga ba ngasauya tibugu numanoa ngahaxahaxa mauli, ngabala ba, ‘Kubolu xai sibuna ulibu manga bing: Long baruamta tam tala mana, bing uharua ba “Moxongogua.” ’ ” ");
INSERT INTO met_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Baing Abimelek xap sipsipdi, bulmakaudi xaung haing lup oxata olanggamdi dima saing sinadi na Ebraham, saing sina haininoa Sara muli na. ");
INSERT INTO met_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Baing Abimelek harua ba, “Ubagu titi longga baguli bing ngayuadi. Urung mana long baruamta murum mana.” ");
INSERT INTO met_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Baing harua na Sara ba, “Ubagu, ngasina siang silba 1,000 na moxongoma. Alali mogu lipu longgalo duwa ranguaung maxadingia ba oxola sibuna mauxangana.” ");
INSERT INTO met_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Baing Ebraham sabu na Urana, saing Urana hamaringia Abimelek, haininoa xaung haining oxata olanggamdi bu sanga ba dahayau muli. ");
INSERT INTO met_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Namua na Toxoratamona soxauti gara daxanganoa mana Abimelek haining numanam longgalo namua na xap Ebraham haininoa Sara. ");
INSERT INTO met_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Toxoratamona su mana haruanganoa saing libu xai mana Sara bila hau haruanga muga ba. ");
INSERT INTO met_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Baing Sara gamona saing hayau gara lup tela na Ebraham bungina wa duanga, taxa mana bungina Urana hau haruanga muga mana ba. ");
INSERT INTO met_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Baing Ebraham sina yaya Aisak na gara Sara hayau ba. ");
INSERT INTO met_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Garanoa Aisak xaidabindi 8, baing Ebraham xuxu sangganoa bila Urana tabina. ");
INSERT INTO met_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ebraham nianindi 100 bungina Sara hayau garanoa Aisak. ");
INSERT INTO met_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Baing Sara harua ba, “Urana hauli nga ba ngamasisi, saing lipu longgalo dilungu alali bagula dimasisi rangua nga.” ");
INSERT INTO met_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Saking harua ba, “Muga lipu gaxarea sanga ba bala Ebraham ba, ‘Sara bagula ta su na gara’? Ning ngahayau gara na bungina wa duanga!” ");
INSERT INTO met_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Aisak tubu saing yunga sua, baing mana xaidapka naga Ebraham tuxu taunga sabanga ba dimogu. ");
INSERT INTO met_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ne Sara bagu haing Isipkama Hagar garanoa, gara ba hayau na Ebraham ba, masisia Aisak. ");
INSERT INTO met_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Binabu harua na Ebraham ba, “Usuka haing oxata olanggama garanoa tang mala, namua na labu haing oxata olanggama garanoa ba xap xalingim telau tai! Bungina umati, garagua Aisak ing ganina bagula xap.” ");
INSERT INTO met_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Haruanga ba libu Ebraham hatuminganoa mauxang sibuna, namua na Ismael xauna garanoa. ");
INSERT INTO met_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ne Urana harua na Ebraham ba, “Labu hatumingama mauxana mana garama haing oxata olanggama tanggu tai. Baraxing baraxinta Sara harua naung, bing ulibu, namua na garam xumana ngahau haruangua ranguaung manadi ba, bagula disok mana Aisak. ");
INSERT INTO met_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ne bagula ngalibu haing oxata olanggam garang bakbagindi disok numanuma xauna, namua na garama xauna.” ");
INSERT INTO met_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Buraging buraraging sibuna baing Ebraham mesa xap anginga xaung asaxa sangganoa baxagi mana langa, saing sinadi na Hagar. Tadi yaxunia, sina garanoa na, saing soxi dingtang mala. Tang dila baing dahaxa mauli maluxuʼm long xoliana Berseba. ");
INSERT INTO met_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Langga wa asaxa sanggania ila sup, baing yunga gara matabu xai kaxukan tela namuya. ");
INSERT INTO met_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Baing ila rung hasoya monga, maxaxayanganoa bila gulu tela dahang mala, namua na hatum ba, “Ngabo ba ngabagu garua mati te.” Hagar rung mua la ba, baing ungguti tang haringina. ");
INSERT INTO met_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Urana lungu garua tang mua, saking Urana uleginama wagi masok ma long xaiya mana Hagar ba, “Hagar, mauxangama baru? Labu umaxuwau tai. Urana lungu garua tang mua mana longga wa mana ba. ");
INSERT INTO met_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Umesa. Ula uhauli ba mesa utatua atindi. Namua na bagula ngalibu garandi disok bakbak xumang sibuna.” ");
INSERT INTO met_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Baing Urana hatanga lang bangguming tela na. Binabu ila xu asaxa sangganoa, saing sina na garua ba nung. ");
INSERT INTO met_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Urana wa rangua garua saing tubu. Wa long xoliania, saing ruanginoa haring. ");
INSERT INTO met_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Rung mana Long Xoliana Paran, baing bauna xap haing Isipkam tela ma ba wa haininoa. ");
INSERT INTO met_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Mana bungina baguba, Abimelek gabu lipuxing haungingamdi yanamidinga Pikol tang dila rangua Ebraham saing harua ba, “Urana wa ranguaung mana axamang longgalo ulibudi ba. ");
INSERT INTO met_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Binabu uharingia haruangama xaung Urana yanoa uharua maxung sibuna nanga ba bagula utuxu murak manga te, xaung mana garagudi te, xaung mana bakbagigudi dima kimuya te. Ulibu kubolu xaiyua nanga xaung na lipuadi duwa mana numanuma li uwa lobu mana ba, bila waleu ma ngalibu kubolu xaiyua naung ba.” ");
INSERT INTO met_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Baing Ebraham harua ba, “Ngaharua maxung sibuna bila ba.” ");
INSERT INTO met_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Sup, baing Ebraham hati Abimelek mana langing bangguming tela Abimelek lipuxing oxatamdi dimogu bila dingia. ");
INSERT INTO met_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ne Abimelek harua ba, “Ngaxabia lipu gaxarea libu te. Ubala nga nulana te. Hata sibuna li ngalungu.” ");
INSERT INTO met_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Binabu Ebraham xap sipsipdi xaung bulmakaudi ma saing sinadi na Abimelek, saing tang dahau haruangua. ");
INSERT INTO met_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ne Ebraham ta sipsip hagaxang tutubing 7 halianga. ");
INSERT INTO met_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Baing Abimelek xusunga Ebraham ba, “Baru namuxinta uta sipsip hagaxang tutubing 7 halianga?” ");
INSERT INTO met_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Haxuya ba, “Oxop sipsip hagaxang tutubing 7 bagudi li. Bila balau bagula uhatanga ba hatumingara taininau ba ngaki lang banggumina li.” ");
INSERT INTO met_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Binabu duxu longga ba Berseba, namua na tang dahau haruangua la ba. ");
INSERT INTO met_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Tang dahau haruangua Berseba laing sup, baing Abimelek gabu lipuxing haungingamdi yanamidinga Pikol tang digoxoya mala mana Pilistiadi titidinga. ");
INSERT INTO met_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ebraham rang xaiya tamaris tela Berseba, saing uxu Toxoratamona yanoa la ba, sabu mana Urana Bungingbunginaloama. ");
INSERT INTO met_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Baing Ebraham wa lobu bunging maxaxaya monga mana Pilistiadi titidinga. ");
INSERT INTO met_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Bunging tela disup, baing Urana tuba Ebraham. Wagi mana ba, “Ebraham!” Haxuya ba, “Ngawau.” ");
INSERT INTO met_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Baing harua ba, “Oxop garama mala, garam taininau Aisak, garamga murum sibuna mana ba, saing ula mana titia Moraya. La ba, mana bimbi tela bagula ngahatanga naung, ung garama mati uhanania nanga etuaʼm yaba laing tau masup.” ");
INSERT INTO met_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Buraraging sibuna, baing Ebraham mesa, xauxau donkixinoa saing xap Aisak xaung lipuxing oxatam luwadi. Baing lua xai sanga mana hananianga taungama saing dila mana longga Urana bala mana ba. ");
INSERT INTO met_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Xaidap tuwa, baing Ebraham bagu mahaing mala saing bagu longga wa hasoya monga. ");
INSERT INTO met_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Baing Ebraham bala lipuxing oxatamdi ba, “Tang gawa mua la li rangua donkia li. Gara tam gala hata lo. Tam gasabu, saing tam gagoxoya ma ranguang muli.” ");
INSERT INTO met_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Baing Ebraham xap xaidi mana hananianga taungam saing tadi garanoa Aisak yaxunia. Baing ing sibuna xap yaba xaung waxanga saing raidi. Tang dahaxa mala, ");
INSERT INTO met_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","baing Aisak harua na tibuna Ebraham ba, “Tibugu?” Haxuya ba, “Garagua, ngawau.” Aisak xusunga ba, “Yaba xaung xaiyadi bagudili, ne sipsip tutubina mana hananianga taungama kabi?” ");
INSERT INTO met_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ebraham haxuya ba, “Garagua, Urana ing sibuna bagula sina sipsip tutubina mana hananianga taungama.” Baing tang dahaxa malau. ");
INSERT INTO met_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Tang disok mana longga Urana bala mana ba, baing Ebraham tongtongia kabukabu hananiangama la ba saing gatia xaidi etua mana. Goxi garanoa Aisak saing hakinu mahaing kabukabu hananiangamia, etuaʼm xaidi. ");
INSERT INTO met_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Baing ina naga, Ebraham raria rimanoa saing xap waxanga bu ung garanoa mati. ");
INSERT INTO met_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Baing tegu. Toxoratamona uleginama wagi masok ma long xaiya mana ba, “Ebraham! Ebraham!” Baing haxuya ba, “Ngawau.” ");
INSERT INTO met_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Harua ba, “Labu ung garamau tai. Labu ulibu axamang tela manau tai. Namua na hatata ngaxabia ba maxung sibuna uwa hawa mana Urana. Ngabagung uxauxau ba uhanania garama nanga, usaxangia garam taininau te.” ");
INSERT INTO met_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Baing Ebraham bagu mahaing saing bagu sipsip moning tela wa haxek, salamindi digasi’m xai rimandi. Baing ila saing xap ma hanania etuaʼm yaba laing tau masup bu xap Aisak yabanoa. ");
INSERT INTO met_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Binabu Ebraham uxu longga ba, “Toxoratamona Bagula Sina.” Bila balau ma laing hatata lipudi daharua ba, “Etua mana Toxoratamona bimbixinoa, bagula sina.” ");
INSERT INTO met_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Baing Toxoratamona uleginama wagi muli masok ma long xaiya mana Ebraham. ");
INSERT INTO met_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Harua ba, “Nga Toxoratamona ngaharua bila li: Ngaharingia haruangagua nga sibugu yagia ngaharua maxung sibuna. Mana namua ulibu bila li, usaxangia garama te, garam taininau baing, ");
INSERT INTO met_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","maxung sibuna bagula ngasina guxama naung saing bagula ngalibu bakbagimdi disok xumang sibuna bila hatungdi duwa sabalunia xaung bila ulangulangdi duwa tek rubinia. Bakbagimdi bagula didali bixuadingdi daxap long sabanga dingiadi. ");
INSERT INTO met_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Baing mana bakbagimdi bagula ngaguxam bakbak titiam longgalo, namua na usu mana haruangagua.” ");
INSERT INTO met_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Baing Ebraham tang digoxoya mala muli rangua lipuxing oxatamdi, saing gabudi dahaxa mala Berseba. Baing Ebraham wa Berseba. ");
INSERT INTO met_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Bunging tela disup, baing Ebraham xap haruang(u)a ba “Milka xauna hayau garadi na kixingima Nahor. ");
INSERT INTO met_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Yadingdi bing: Us matuaua, kixinginoa Bus, Kemuel (Aram tibuna), ");
INSERT INTO met_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keset, Haso, Pildas, Yitlap, xaung Betuel.” ");
INSERT INTO met_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(Betuel Rebeka tibuna.) Milka hayau gara lup 8 bagudi li na Ebraham kixinginoa Nahor. ");
INSERT INTO met_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor yau hainging oxatam olanggam tela, yanoa Reuma. Ina xauna hayau gara lupdi, yadingdi Teba, Gaham, Tahas xaung Maka. ");
INSERT INTO met_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara nianindi 127. Walingang nianidi bila ba, ");
INSERT INTO met_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","baing mati mana longga Kiriat-Arba (tauxu ba Hebron) mana titia Kenan. Baing Ebraham luxu ba usinga Sara xaung tangia. ");
INSERT INTO met_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Baing Ebraham mesa yunga Sara sangganoa saing ila harua rangua Hitdi. Harua ba, ");
INSERT INTO met_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ngawa lobu xaung lipu titi telama liwe mang. Ngaxusungang ba anai mana ngagim titi (hataing) tela mang ba wa gobagobua bu sanga ba ngakimang hainigua.” ");
INSERT INTO met_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hitdi dahaxuya na Ebraham ba, ");
INSERT INTO met_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Lipu sabanga (mana), ulungu to. Uwa yanam haringina liwe mam. Umogu gobagobamam xai sibuna tela saing ukimang matiama la ba. Amia tela sanga ba biliung mana gobagobanoa bu ukimang matiama te.” ");
INSERT INTO met_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Baing Ebraham mesa saing turu mana titi moxonadi Hitdi. ");
INSERT INTO met_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Baing harua nadi ba, “Nabu anai mana ngakimang matiagu, bing alungu nga to. Ahauli nga axusunga Sohar garanoa Epron ");
INSERT INTO met_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","bu sina guhia wa Makpela nanga. Moxonoa, wa titing ragunia. Axusunga ba sina nanga mana giminaging maringina maxaimia bu wa gobagobagu kimangingam.” ");
INSERT INTO met_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Lipu Hitama Epron rung la ba liwe mana bakbagindi saing haxuya na Ebraham mana maxadinga mana lipu longgalo dima long sabanga gamgamingang xaluxinia. ");
INSERT INTO met_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Harua ba, “Lipu sabanga (mana), ulungu to. Talibu bila ba te. Ngasina titia naung olang, xaung ngasina naung guhia wa mana olang. Ngasina naung olang bakbagigudi maxadingia. Ula ukimang matiama.” ");
INSERT INTO met_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Baing Ebraham turu mana titi moxondi. ");
INSERT INTO met_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Baing mana long moxondi maxadinga harua na Epron ba, “Ngabo ba ulungu nga. Bagula ngagim titia ba giminaginoa. Oxop siangigua bu sanga ba ngakimang matiagu la ba.” ");
INSERT INTO met_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Epron haxuya na Ebraham ba, ");
INSERT INTO met_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Lipu sabanga (mana), ulungu to. Titi giminaginoa siang silba 400. Ne giminaga ba axamang olang liwe makitam. Ula ukimang matiama.” ");
INSERT INTO met_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ebraham nai mana Epron giminaginoa saing hangalia na giminaga mogu Hitdi maxadingia. Siang silba 400 naga, mauxanganoa bila lipu sianggamdi dahangalia. ");
INSERT INTO met_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Baing ina naga, bila balau Epron titinoa wa Makpela, longga Mamre sanga karagia, sok Ebraham inia. Xap titia xaung guhia wa mana xaung xai longgalo dili maluxuʼm ragunoa. ");
INSERT INTO met_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Ila mana Ebraham rimanoa Hitdi maxadingia, adi digugunia long sabangga ba xaluxinia. ");
INSERT INTO met_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Laing sup, baing Ebraham kimang haininoa Sara guhia wa Makpela, longga Mamre sanga karagia (wa haxek mana longga Hebron), mana titi sabanggaa Kenan. ");
INSERT INTO met_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Baing ina naga, titia ba xaung guhia wa mana yunga Hitdi rimadingia saing ila Ebraham rimania ba sok gobagobang kimangingama. ");
INSERT INTO met_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ebraham wa duanga ba, saing Toxoratamona sina guxama na bu axamang walinganamdi disok xai. ");
INSERT INTO met_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Baing Ebraham wagi lipuxing oxatama wasa mana xalinging longgalo ba ma, saing harua na ba, “Uta rimama babagu hanggaxobinia. ");
INSERT INTO met_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ngabo ba uharingia haruangama xaung Toxoratamona yanoa, Urana long xaiyam xaung titiam. Uhau haruangua ba bagula oxop haing tela ba sok garagua haininoa rangua Kenandi li te, titia ba ngarung mana baing. ");
INSERT INTO met_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ning ula yabagia rangua bakbagigudi bu oxop hainga ba garagua Aisak yau.” ");
INSERT INTO met_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Lipu oxatamga ba xusunga ba, “Ne bola hainga hauxana ba goxoya ma titia li rangua nga. Bagula ngaxap Aisak mala la ba bu rung liwe mana bakbagimdi yabamia?” ");
INSERT INTO met_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Baing Ebraham harua ba, “Labu oxop garagua mala la bau tai. ");
INSERT INTO met_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Toxoratamona, Urana long xaiyama, lipua xap nga sangua tibugu numanoa xaung bakbagigudi titidinga, lipua harua nanga xaung hau haruangua rangua nga ba, “Bagula ngasina titia li na bakbagima”—ina naga bagula soxi uleginama muga naung bu sanga ba oxop hainga la ba bu garagua yau. ");
INSERT INTO met_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Nabu hainga hauxana ba goxoya ma ranguaung, bing sangau, heku mana haruanga li uhau rangua nga ba. Ning labu oxop garagua mala la bau tai!” ");
INSERT INTO met_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Binabu lipuxing oxatama ta rimanoa lipuxing haringinoa Ebraham babang hanggaxobinia, saing hau haruangua ba su mana haruanganoa. ");
INSERT INTO met_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Baing lipu oxatama xap lipuxing haringing kameling 10 doxoxi lipuxing hairnging yahangang xai sibundi, saing ila. Haxa mala titia Aram-Naharaim, saing ila mana long sabangga Nahor rung mana ba. ");
INSERT INTO met_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Sok, baing libu kameldi dikinu haxek mana lang banggumina longga rubunia. Bungbung baing. Xaidap maxanoa haingdi dila ba duxu lang. ");
INSERT INTO met_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Baing sabu ba, “O Toxoratamona, Urana mana lipuxigu haringina Ebraham, ngaxusunga ba ulibu oxatagua aningona hatata xaung ba uhatanga kubolung xaiyua na lipuxigu haringina Ebraham. ");
INSERT INTO met_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Bagu baing ngali lang maxamaxana li rubinia, saing long moxondi nanuhangidingdi disok ma bu duxu lang. ");
INSERT INTO met_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Bagula ngaxusunga haing nanung tela ba, ‘Sanga ba uta borima mari bu nganung monga?’ Nabu harua ba, ‘Unung, saing bagula ngasina langa na kamelimdi xauna.’ Nabu bila ba, bing ngabo ba ina naga umogu (ma)na lipuxim oxatama Aisak. Nabu sok bila ba, bing bagula ngaxabia ba uhatanga kubolum xaiyua na lipuxigu haringina.” ");
INSERT INTO met_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Lipu oxatama sahi sabunganoa teguyu, baing Rebeka sok xoxi borina. Betuel nanuhanginoa. Betuel Nahor Milka tang garading luba. Nahor Ebraham kixinginoa. ");
INSERT INTO met_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Haing nanuna ba gumanging sibuna. Xabia luba teguyu, lup tela kinu rangua te. Ri lang maxamaxania, xu lang saing goxoya mahaing muli. ");
INSERT INTO met_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Lipu oxatama luki masok rangua saing harua ba, “Sanga ba usina lang kaxukana borimia nanga bu nganung?” ");
INSERT INTO met_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Baing harua ba, “Lipu haringina, unung.” Baing tatua borinoa mari sap saing tuxu rimania bu nung. ");
INSERT INTO met_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Nung sanga ba baing hainga harua ba, “Bagula ngasina langa na kamelimdi xauna laing dinung sanga ba.” ");
INSERT INTO met_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Binabu matu borinoa masup mari sap asaxa minania, luki muli lang bangguminia bu xu muli, bila balau laing kamelindi dinung sanga ba. ");
INSERT INTO met_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ne lipua harua te, ina bagu hainga ing ganina ba xabia ba Toxoratamona libu oxatanoa aningona, kimbo tegu. ");
INSERT INTO met_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kamel dinung laing sup, baing lipua wangia raxu yungxam gol tela xaung raxu rimam gol luwa. Gimagiding sabanga, saing raxu rimandi mauxading. ");
INSERT INTO met_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Baing xusunga ba, “Ung gaxarea nanuhanginoa? Sanga ba ubala nga ba ganangana wa tibum numania sanga mana am gakinu yambong?” ");
INSERT INTO met_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Haxuya ba, “Nga Betuel nanuhanginoa, ina Nahor Milka tang garadinga.” ");
INSERT INTO met_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Harua muli ba, “Am tatubang xaung anginga xumana sanga mana kamelimdi, xaung numa ganangana sanga mana akinu mana xauna.” ");
INSERT INTO met_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Baing lipua gung king tuxundi mari, saing sabu mana Toxoratamona. ");
INSERT INTO met_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Baing harua ba, “Ngaiti Toxoratamona yanoa, Urana mana lipuxigu haringinoa Ebraham. Maxung sibuna libu xai mana lipuxigu haringinoa, kubolunoa xung mari te. Toxoratamona muga manga mana haxangagua bu nga ngama taxa rangua lipuxigu haringing bakbagindi.” ");
INSERT INTO met_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Baing haing nanunoa luki mala numia saing bala bauna numanamdi mana axamandi disok. ");
INSERT INTO met_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Tauna, Rebeka moxongonoa yanoa Laban. Bagu raxu ngeli hamunganoa yungxania xaung raxudi mana rimandi, saing lungu Rebeka naxuya mana lipua ba harua baru na. Baing ina naga, hata sibuna li luki masok saing bagu lipua li lang maxamaxania, haxek rangua kameldi. ");
INSERT INTO met_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Baing Laban harua ba, “Ung lipu tela Toxoratamona sina guxama na(ung)! Uma tala numia. Uli sabasabia li baru? Ngaxauxau numua xaung kameldi yabadinga masup.” ");
INSERT INTO met_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Binabu lipua tang dila numia, saing Laban lipuxindi duwangia kameldi, saing disina tatubang xaung anginga na kameldi, saing daxap langa ma bu lipua gabu riandi didamia kidingdi. ");
INSERT INTO met_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Sup, baing daxap anginga (di)ma, ne Ebraham lipuxing oxatama harua ba, “Bagula ngaxang te laing ngabaxanga haruangagua to.” Baing Laban harua ba, “Sangau. Uharua to.” ");
INSERT INTO met_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Binabu harua ba, “Nga Ebraham lipuxing oxatama. ");
INSERT INTO met_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Toxoratamona sina guxam sabanga na lipuxigu haringinoa, binabu xalinging xumana. Sina xalaxala na bila sipsipdi xaung memedi, bulmakaudi, silba xaung gol, haing lup oxata olanggamdi, xaung kameldi xaung donkidi. ");
INSERT INTO met_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Baing bungina lipuxigu haringing haininoa Sara nianindi xumana, hayau gara lup tela na lipuxigu haringinoa. Baing ina naga sina xalinging longgalo na gara ba. ");
INSERT INTO met_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Baing lipuxigu haringinoa haxi ba ngahau haruanga li, harua nanga ba, ‘Labu oxop haing tela ba sok garagua haininoa rangua Kenandi liu tai, titia ba ngarung mana baing. ");
INSERT INTO met_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ne ula rangua tibugu sibindi xaung bakbagigudi, saing oxop hainga ranguadi ba garagua yau.’ ");
INSERT INTO met_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Baing ngaxusunga lipuxigu haringinoa ba, ‘Bola hainga hauxana ba goxoya ma rangua nga, bing (bagula) ngaraxata?’ ");
INSERT INTO met_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Baing haxuya ba, ‘Toxoratamona, lipua ngasu mana bungingbunginalo, bagula soxi uleginama ila ranguaung bu libu haxangama aningona. Bila balau bagula oxop haing tela rangua nga sibugu bakbagigudi xaung tibugu sibindi bu garagua yau. ");
INSERT INTO met_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ne nabu ula rangua bakbagigudi saing hauxading mana soxi mala ranguaung, bing sangau, heku mana haruanga li ngalibu uhau rangua nga ba. Mauxanganoa bagula xapkung te.’ ");
INSERT INTO met_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Menau ngama lang maxamaxania, baing ngasabu ba, ‘O Toxoratamona, Urana mana lipuxigu haringina Ebraham, nabu ung murungama, bing ulibu haxangagua ngama mana ba aningona. ");
INSERT INTO met_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Bagu baing ngali lang maxamaxana li rubinia. Nabu haing nanung tela sok ma bu xu lang, saing ngaharua na ba, “Sanga ba nganung monga mana borima?” ");
INSERT INTO met_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Baing nabu harua nanga ba, “Unung, saing bagula ngasina langa na kamelimdi xauna,” baing ina naga, Toxoratamona, ngaxusunga ba hainga naga umogu mana lipuxigu haringing garanoa.’ ");
INSERT INTO met_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Ngasahi sabungagua hatumingagia teguyu, baing Rebeka sok ma, xoxi borinoa yaxunia. Ri mala lang maxamaxania saing xu lang, saing ngaharua na ba, ‘Sanga ba usina langa nanga bu ngagung?’ ");
INSERT INTO met_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Tatua borinoa yaxunoa mari sap saing harua ba, ‘Unung, saing bagula ngasina langa na kamelimdi xauna.’ Binabu nganung, saing sina langa na kameldi xauna. ");
INSERT INTO met_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Ngaxusunga ba, ‘Ung gaxarea nanuhanginoa?’ “Harua ba, ‘Nga Betuel nanuhanginoa, ina Nahor Milka tang garadinga.’ “Baing ngasu raxu yungxania saing ngata raxudi mana rimandi. ");
INSERT INTO met_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Baing ngagung kigu tuxundi mari, saing ngasabu mana Toxoratamona. Ngaiti Toxoratamona yanoa, Urana mana lipuxigu haringina Ebraham. Ina muga manga mana haxangagua bu ngama taxa rangua lipuxigu haringing kixinging garanoa ba sok garang haininoa. ");
INSERT INTO met_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Tauna, nabu maxung sibuna abo ba alibu xai mana lipuxigu haringinoa, bing abaxanga nanga. Nabu tegu, bing abaxanga nanga xauna. Bila balau bagula ngaxabia ngaria baru.” ");
INSERT INTO met_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Baing Laban Betuel tang dahaxuya ba, “Maxuna, Toxoratamona libu axa li sok. Heku mana tam haruangamamdi. ");
INSERT INTO met_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Abagu, Rebeka wau. Oxop saing tang gala. Sanga ba yau lipuxim haringing garanoa, bila Toxoratamona harua baing.” ");
INSERT INTO met_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ebraham lipuxing oxatanoa lungu haruangadinga, baing gung king tuxundi mari titia Toxoratamona maxania. ");
INSERT INTO met_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Sup, baing wangia yauyaunga silba xaung gol, xaung imangdi, saing sinadi na Rebeka. Baing sina yahanga siang sabanggamdi na moxongonoa xaung bauna. ");
INSERT INTO met_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Baing gabu riandi daxang dinung saing dikinu la ba yambong. Buraraging sibuna dimesa, baing lipua harua ba, “Ngabo ba ngagoxoya mala muli rangua lipuxigu haringinoa.” ");
INSERT INTO met_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ne Rebeka moxongonoa bauna tang daharua ba, “Am gabo ba haing nanunoa wa ranguam laing bila xaidap 10 disup to, tauna ila.” ");
INSERT INTO met_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ne harua nadi ba, “Labu ahalisia ngau tai. Namua na Toxoratamona libu oxatagua aningona ba. Ngabo ba ngagoxoya mala muli rangua lipuxigu haringinoa hatata.” ");
INSERT INTO met_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Baing daharua ba, “Tawagi mana haing nanunoa ba taxusunga to.” ");
INSERT INTO met_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Binabu duwagi Rebeka ma, saing duxusunga ba, “Ubo ba ula rangua lipua li?” Baing harua ba, “Wane, bagula ngala.” ");
INSERT INTO met_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Binabu disoxi sibiding Rebeka mala, gabu hainga wasa mana bungina wa gara kambagina ba, Ebraham lipuxing oxatama xaung riandi. ");
INSERT INTO met_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Baing disina guxama na Rebeka, daharua ba, “Hamungamam, bagula uxapsaxi gara 1,000 xumang sibuna. Bagula bakbagimdi didali bixuadingdi, daxap long sabanga dingiadi.” ");
INSERT INTO met_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Baing Rebeka gabu haining oxatamdi daxauxau saing dirung kameldi ubudingia saing disu mana Ebraham lipuxing oxatama mala. Bila balau lipu oxatama xap Rebeka saing ila. ");
INSERT INTO met_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Tauna, mana bungina baguba Aisak goxoya ma sangua Ber-Lahai-Roi, saing wa titia Negep. ");
INSERT INTO met_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Bungbung tela ila raxangia bu hatum mua. Baing bagu mahaing saing bagu kameldi dima baing. ");
INSERT INTO met_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Saking Rebeka bagu mahaing xauna saing bagu Aisak. Baing hixi mari sangua kamel ");
INSERT INTO met_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","saing xusunga lipu oxatama ba, “Gaxarea haxa raxangia ma rangua kira?” Baing haxuya ba, “Lipuxigu haringinoa.” Binabu Rebeka xap toxong imanganoa saing saku ramramonoa. ");
INSERT INTO met_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Baing lipu oxatama naxuya na Aisak mana axamandi libudi. ");
INSERT INTO met_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Baing Aisak xap Rebeka mala bauna Sara numang mokiamia, Baing yau. Binabu sok haininoa, saing murung sibuna mana. Baing xap ati tatuanganama kimuya mana bauna matianoa. ");
INSERT INTO met_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ebraham yau haing tela muli yanoa Ketura. ");
INSERT INTO met_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Hayau garadi li na Ebraham: Simran, Yoksan, Medan, Midian, Isbak xaung Sua. ");
INSERT INTO met_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan Seba Dedan tang tibuding. Dedan bakbakingdi Asurdi, Letusdi xaung Leumdi. ");
INSERT INTO met_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian garandi Epa, Eper, Hanok, Abida xaung Elda. Ding longga Ketura bakbagindi. ");
INSERT INTO met_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ebraham sina xalinging longgalo na Aisak. ");
INSERT INTO met_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ne garadi haining oxatamdi dahayaudi ba, sina yahangadi nadi saing bungina wauyu soxidi mala sangua garanoa Aisak, soxidi mala titia wa sanga karagia. ");
INSERT INTO met_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ebraham wa laing nianindi 175. ");
INSERT INTO met_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Baing ina naga, yaganganoa sup saing mati bungina muganga. Duanga, nianindi dibaxagi, saing kinu rangua mugangandi. ");
INSERT INTO met_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Garang Aisak Ismael tang dikimang guhia wa Makpela, longga Mamre sanga karagia. Guhia ba wa mana Epron titinoa, Sohar garanoa, lipu Hitam. ");
INSERT INTO met_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Titia ba, Ebraham gim rangua Hitdi ba. Dikimang la ba rangua haininoa Sara. ");
INSERT INTO met_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Kimuya mana Ebraham matianoa, Urana sina guxama na garanoa Aisak. Mana bungina baguba, Aisak wa mana Ber-Lahai-Roi. ");
INSERT INTO met_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ismael bakbagindi bila li. Ebraham garanoa. Haing Isikpama Hagar, Sara haining oxata olanggama, hayau na. ");
INSERT INTO met_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismael garang lupdi yadingdi bila li. Ungguti mana matuaua ila mari. Nebaiot Ismael garang matuaua, kimuya Kedar, Atbel, Mipsam, ");
INSERT INTO met_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO met_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadat, Tema, Yetur, Napis xaung Kedema. ");
INSERT INTO met_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ismael garang lup 12 disok yanamdi mana bakbak 12 ba daxap yadingdi. Taining tainina ding ganangading xaung tabalaxayading. ");
INSERT INTO met_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael wa laing nianindi 137. Yaganganoa sup saing mati, saing kinu rangua mugangandi. ");
INSERT INTO met_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Bakbagindi dirung mana titia liwe mana Habila xaung Sur, haxek mana Isip bila sanga Asur wa mana. Baing bakbakkadi li dirung xai rangua ding te. ");
INSERT INTO met_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ebraham garanoa Aisak bakbagindi bila li. Ebraham Aisak tibuna. ");
INSERT INTO met_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisak nianindi 40 baing yau Rebeka. Rebeka tibuna Betuel, Aram tela yabanoa Padan-Aram. Rebeka moxongonoa Laban, lipu Aramgam. ");
INSERT INTO met_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Aisak sabu na Toxoratamona ba hauli haininoa, namua na xuhiana. Toxoratamona lungu sabunganoa, saing Rebeka gamona. ");
INSERT INTO met_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Garadi dahaung lunia, saing harua ba, “Baruta alali sok manga?” Binabu ila ba xusunga Toxoratamona. ");
INSERT INTO met_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Toxoratamona harua na ba, “Numanuma luwa duwa gamomia, saing bakbak luwa bagula disok sanguaung, dutu ding. Bakbak tela haringinganoa bagula dali tela, saing sabangua bagula tuxu kixinginoa oxatanoa.” ");
INSERT INTO met_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Tauna, xaidap hayauxingama sok, baing gara haragaragangandi duwa gamonia baing. ");
INSERT INTO met_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Gara mugamungama sok sabuxana, saing sangganoa bukbuxana bila imang buxama. Binabu duxu yanoa ba Iso. ");
INSERT INTO met_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Sup, baing kixinginoa sok, rimanoa tuxu Iso king tambonga. Binabu duxu yanoa ba Yekop. Aisak nianindi 60 bungina Rebeka hayau haragaraganganadi ba. ");
INSERT INTO met_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Neng sabangandi ditubu, baing Iso ruanginoa yabina, lipu onganam. Ne Yekop lipu mamugina, wa tabalaxaya(u). ");
INSERT INTO met_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisak muruna mana Iso, namua na yaha ba xang asaxa abungindi xapdi. Ne Rebeka muruna mana Yekop. ");
INSERT INTO met_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Xaidap tela Yekop bori, baing Iso goxoya ongania ma. Haringinganoa sup saing gesaging sibuna. ");
INSERT INTO met_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Harua na Yekop ba, “Sap! Oxop axamang sabuxana ubori ba ma bu ngaxang. Haringingagu sup saing gesagu sibuna.” (Binabu duxu yan tela ba Idom.) ");
INSERT INTO met_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ne Yekop harua ba, “Sangau, ne muga uyunga yabama matuaua mala rangua nga to.” ");
INSERT INTO met_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Iso harua ba, “Laku, ngabo ba ngamatiuba! Yabagu matuaua sanga ba hauli nga baru?” ");
INSERT INTO met_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ne Yekop harua ba, “Uhau haruangua rangua nga to.” Binabu hau haruangua rangua saing yunga yabang matuaua na Yekop. ");
INSERT INTO met_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Baing Yekop sina salanga na Iso xaung anginga boringam sabuxana tongtongia mana lentil marandi. Xang nung, baing mesa ilauba. Bila balau Iso hatanga ba yabang matuaua axamang olang hatumingania. ");
INSERT INTO met_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Tauna, gesaga sok mana titia ba, bila gesaga sok muga mana bungina Ebraham. Baing Aisak ila (mana) longga Gerar rangua Abimelek Pilistia xaitamoxidinga. ");
INSERT INTO met_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Toxoratamona owa masok rangua Aisak saing harua ba, “Labu uri mala Isipku tai. Uwa mana titia bagula ngabaxanga naung mana ba. ");
INSERT INTO met_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Uwauyu mana titia li monga to, saing bagula ngawa ranguaung xaung bagula ngasina guxama naung. Namua na bagula ngasina titia longga li naung xaung bakbagimdi. Bila balau bagula ngalibu haruangua ngahau rangua tibum Ebraham aningona. ");
INSERT INTO met_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Bagula ngalibu bakbagimdi disok xumang sibuna bila hatungdi duwa sabalunia, saing bagula ngasina titi longga li nadi. Baing mana bakbagimdi bagula ngaguxam bakbak titiam longgalo, ");
INSERT INTO met_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","namua na Ebraham su mana haruangagua, saing libu tabinangagu longgalo xaung hanaunaungagu longgalo.” ");
INSERT INTO met_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Binabu Aisak wauyu mana longga Gerar. ");
INSERT INTO met_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Bungina longga ba moxondi duxusunga mana haininoa, harua ba, “Hamungagua.” Namua na maxuwa ba harua ba, “Hainigua.” Hatum ba, “Bola longga li moxondi ung nga mati bu daxap Rebeka, namua na gumangina.” ");
INSERT INTO met_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aisak wa mana longga ba maxaxaya monga, baing Pilistia xaitamoxidinga Abimelek bagu suangia mari saing bagu Aisak yaha mana haininoa Rebeka. ");
INSERT INTO met_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Binabu Abimelek wagi Aisak ma saing harua ba, “Si! Hainima baing! Baruta uharua ba, ‘Hamungagua’?” Aisak haxuya na ba, “Namua na ngahatum ba, ‘Nam ngamati namua na dibo ba daxap hainigua.’” ");
INSERT INTO met_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Baing Abimelek harua ba, “Uraxata mam! Nabu lipuxigu tela kinu rangua hainima, bagula ulibu am gaxap mauxanganoa mana kubolu diana ba!” ");
INSERT INTO met_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Binabu Abimelek tabina lipuxing longgalo ba, “Lipu gaxarea hanggalangia lipua li kimbo haininoa bagula am gaung mati.” ");
INSERT INTO met_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aisak xuma mana titia ba, saing mana niani naga xauya anginga dali xumangama bila 100. Namua na Toxoratamona sina guxama na. ");
INSERT INTO met_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Sok lipu xalaxalam, saing xalingindi ditubutubu mala. ");
INSERT INTO met_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Sipsibindi, bulmakaundi xaung lipuxing oxatamdi xumang sibuna sanga mana Pilistiadi dibagulinga. ");
INSERT INTO met_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Binabu Pilistiadi diyaxang lang bangguming longgalo tibuna lipuxing oxatamdi diki mana bungina tibuna Ebraham. ");
INSERT INTO met_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Sup, baing Abimelek harua na Aisak ba, “Usauyam, namua na haringingama tubu buk saing (u)daliam sibuna.” ");
INSERT INTO met_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Binabu Aisak sauya longga ba, saing ila tongtongia tabalaxaya mana long gomana wa mana titia Gerar saing wa la ba. ");
INSERT INTO met_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Baing ki muli lang banggumindi diki bungina tibuna Ebraham. Pilistiadi diribadi kimuya mana Ebraham mati. Aisak uxu yadingdi bila tibuna uxudi muga. ");
INSERT INTO met_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Aisak lipuxing oxatamdi diki long gomania saing disok mana lang maxamaxang tela la ba. ");
INSERT INTO met_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ne Gerar lipuxiding morung wasanganamdi dahakhaxi rangua Aisak iniadi, daharua ba, “Langga li amia!” Binabu Aisak uxu lang banggumina ba Esek, namua na dahakhaxi rangua. ");
INSERT INTO met_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Baing diki lang bangguming tela muli, ne dahakhaki mana langga ba xauna. Binabu uxu yanoa ba Sitna. ");
INSERT INTO met_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Sauya, saing ila ki lang bangguming tela muli, saing lipu tela hakhaxinga mana te. Uxu yanoa ba Rehobot, harua ba, “Hatata Toxoratamona sina gananga sabanga nakira saing bagula oxataroa aningona xumana titia li.” ");
INSERT INTO met_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kimuya Aisak sauya longga ba saing haing mala mana Berseba. ");
INSERT INTO met_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Yambongga baguba Toxoratamona owa masok ranuga saing harua ba, “Nga Urana mana tibum Ebraham. Labu umaxuwau tai, namua na ngawa ranguaung. Bagula ngasina guxama naung saing bagula ngalibu bakbagimdi disok xumana, namua na ung lipuxigu oxatama Ebraham garanoa.” ");
INSERT INTO met_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Baing Aisak tongtongia kabukabu hananiangam tela la ba bu sabu mana Toxoratamona saing uxu yanoa. Tongtongia tabalaxayanoa la ba, saing lipuxing oxatamdi diki lang bangguming tela. ");
INSERT INTO met_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Dikiyu, baing Abimelek yunga longga Gerar ma rangua Aisak. Baing Ahusat, lipua sina hatuminga na, xaung Pikol, lipuxing haungingamdi yanamidinga, tang digabu Abimelek ma. ");
INSERT INTO met_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Aisak xusungadi ba, “Baruta ama rangua nga? Nulana hauxaim manga saing asuka nga mala.” ");
INSERT INTO met_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Dahaxuya ba, “Am gabagu galanga ba Toxoratamona wa ranguaung. Binabu am gabo ba haruanga haungam wa liwe makira. Tahau haruangua bila li: ");
INSERT INTO met_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Labu ulibu doa mamgu tai. Bila am galibu doa maung te. Bungingbunginalo am galibu xai maung saing am gasoxiung mala xaung gamogamu mosiu. Baing bagu hatata Toxoratamona sina guxama naung baing.” ");
INSERT INTO met_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Binabu tongtongia taungua manadi, saing daxang dinung. ");
INSERT INTO met_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Buraging buraraging sibuna dimesa saing dahau haruangua. Baing Aisak soxidi mala, saing dila xaung gamogamu mosiu. ");
INSERT INTO met_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Mana xaidapka naga Aisak lipuxing oxatamdi dima saing dibaxanga mana lang banggumina diki, daharua ba, “Am gasok mana langa!” ");
INSERT INTO met_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Binabu uxu ba Siba. Baing ina naga, ma laing hatata duxu longga ba Berseba. ");
INSERT INTO met_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Iso nianindi 40, baing yau Beri nanuhanginoa Yudit. Beri Hit tela. Xauna yau Elon nanuhanginoa Basemat. Elon Hit tela xauna. ");
INSERT INTO met_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Haing luwadi ba dilibu Aisak Rebeka tang gamoding didoa mana dingtang. ");
INSERT INTO met_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aisak wa duanga saing maxandi dilaba laing sanga ba bagu te, baing wagi sabangua Iso ba ma saing harua ba, “Garagua.” Baing haxuya ba, “Ngawau.” ");
INSERT INTO met_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Aisak harua ba, “Ulungu to. Ngawa duanga baing, saing ngaxabia xaidabigu matiama te. ");
INSERT INTO met_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Binabu oxop gulum ruangima, saing ula ongania bu uida asaxa manga. ");
INSERT INTO met_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Uxauxau anginga dauyana murugu mana saing oxop ma rangua nga bu ngaxang, bu sanga ba ngasina guxama naung to. Sup, baing sanga ba ngamati.” ");
INSERT INTO met_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ne Rebeka lungu Aisak harua na garanoa Iso. Bungina Iso ila ongania ba ida asaxa xaung xap ma muli, ");
INSERT INTO met_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka harua na garanoa Yekop ba, “Ulungu to. Ngalungulungu tibuma harua na sabangama Iso ba, ");
INSERT INTO met_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Oxop asaxa ma saing uxauxau anginga dauyana bu ngaxang, bu sanga ba ngasina guxama naung Toxoratamona maxania to. Sup, baing sanga ba ngamati.’ ");
INSERT INTO met_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Tauna, garagua, ulungu haruangagua usu maringina mana. ");
INSERT INTO met_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Usok mala mana morudi saing oxop meme tutubing luwa ditubu dima, bu ngaxauxau anginga dauyana mana tibum, bila muruna mana. ");
INSERT INTO met_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Baing oxop mala rangua tibum ba xang, bu sanga ba sina guxama naung muga mana mati.” ");
INSERT INTO met_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yekop harua na bauna Rebeka ba, “Ne sabangagua Iso sanggandi bukbuxading ne ngaxola. ");
INSERT INTO met_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Bola tibugu xunumia sanggagua? Bagula xabia ba ngatuxu muraga mana, saing bagula ngaxap guxam diana manga, ning guxam xai, tegu.” ");
INSERT INTO met_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Bauna harua ba, “Garagua, uyunga guxam diana ba xap nga. Ne ula ulibu haruangagua maringina. Usok mala oxop memedi dima rangua nga.” ");
INSERT INTO met_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Binabu Yekop ila xapdi ma rangua bauna, saing xauxau anginga dauyana, bila tibuna muruna mana. ");
INSERT INTO met_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Baing Rebeka xap sabangua Iso imanging xai sibundi duwa numia, saing sausau nanunoa Yekop manadi. ");
INSERT INTO met_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Baing kaukau king rimandi xaung giduna mana meme tutubing sanggandi. ");
INSERT INTO met_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Baing sina anginga dauyana xaung salanga xauxaudi ba na Yekop. ");
INSERT INTO met_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Binabu ila rangua tibuna saing harua ba, “Tibugu.” Haxuya ba, “Wane. Garagua, ung baruamta?” ");
INSERT INTO met_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yekop harua na tibuna ba, “Nga Iso garam matuaua. Ngalibu bila uharua baing. Umesa urung ba oxong asaxa teladi, bu sanga ba usina guxama nanga.” ");
INSERT INTO met_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Aisak xusunga garanoa ba, “Garagua, usok mana sap baru?” Haxuya ba, “Toxoratamona Urana ungia libu idangagua aningona.” ");
INSERT INTO met_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Baing Aisak harua na Yekop ba, “Garagua, uma haxek bu ngaringgung bu ngaxabia ba maxuna ung garagua Iso, bo.” ");
INSERT INTO met_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yekop ila haxek rangua tibuna. Baing Aisak ring, saing harua ba, “Waxungtuanoa Yekop inia, ne rimandi Iso iniadi.” ");
INSERT INTO met_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Baing bagu xabia te, namua na rimandi buxading bila Iso iniadi. Binabu xauxau ba sina guxama na. ");
INSERT INTO met_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ne xusunga ba, “Maxung sibuna ung garagua Iso?” Haxuya ba, “Nga ba.” ");
INSERT INTO met_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Baing Aisak harua ba, “Garagua, oxop ma rangua nga bu sanga ba ngaxang asaxua utau ba. Saking bagula ngasina guxamingagua naung.” Yekop xap ma rangua saing xang, saing xap wain ma xauna saing nung. ");
INSERT INTO met_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Baing tibuna Aisak harua na ba, “Garagua, uma haxek saing ulibu nga.” ");
INSERT INTO met_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Binabu ila haxek saing libu. Baing ina naga, Aisak yuyu imanging saminganoa bila Iso, binabu sina guxama na saing harua ba, “A, garagua saminganoa bila saminga mana umangua Toxoratamona sina guxama na. ");
INSERT INTO met_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ngaxusunga Urana ba sina naung hinaxaga ri long xaiya ma xaung titi orana, bu ubaxagi mana wit xaung wain. ");
INSERT INTO met_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ngaxusunga ba numanumadi dituxu oxatama, xaung bakbakdi digung kiding tuxudingdi maung. Ngaxusunga ba uwa kixingimdi lipuxiding sabanga xaung baum garandi digung kiding tuxudingdi maung. Ngaxusunga ba lipu gaxarea disina mauxanganoa naung bing daxap mauxanganoa, xaung lipu gaxarea disina guxama naung bing daxap guxama.” ");
INSERT INTO met_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisak sina guxama masup, Yekop yunga tibuna Aisak saing sok mala, baing hata sibuna li sabanganoa Iso goxoya ma mana idanganoa. ");
INSERT INTO met_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ina xauna xauxau anginga dauyana saing xap ma rangua tibuna. Baing harua na tibuna ba, “Tibugu, umesa urung ba oxong asaxa teladi, bu sanga ba usina guxama nanga.” ");
INSERT INTO met_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Tibuna Aisak harua na ba, “Ung gaxarea?” Haxuya ba, “Nga garama. Garam matuaua Iso.” ");
INSERT INTO met_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Baing Aisak lulu haringing sibuna saing harua ba, “Ne menau gaxarea ida, xap asaxa ma saing su nanga? Ngaxang ba, menau uma teguyu baing. Ngasina guxama na, baing maxung sibuna ina bagula xap guxamga ba!” ");
INSERT INTO met_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Iso lungu tibuna haruanga ba, baing gamona mauxana buk saing xaba haringina, harua ba tibuna ba, “O tibugu! Usina guxama nanga xauna!” ");
INSERT INTO met_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ne harua ba, “Kixingima ma langua nga, saing xap guxamingama baing.” ");
INSERT INTO met_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Iso harua ba, “Namua naga yanoa Yekop. Tuxu muraga manga bunging luwa li. Muga xap yabagu matuaua naina, baing hatata xap guxamingagua naina!” Baing xusunga ba, “Ne guxama wauyu sanga mana usina nanga?” ");
INSERT INTO met_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Aisak haxuya na Iso ba, “Ngamogu ba wa lipu sabanga etua maung masup, xaung ngamogu ba bakbagindi dituxu oxatandi, xaung ngaharua ba bagula baxagi mana wit xaung wain. Garagua, bila balau, binabu baraxinta wauyu ba ngalibu maung?” ");
INSERT INTO met_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Iso harua na tibuna ba, “Tibugu, ung guxamingam taininau ing ganina? O tibugu, usina guxama nanga xauna!” Baing Iso tang haringina. ");
INSERT INTO met_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Tibuna Aisak haxuya na ba, “Yabama bagula wa hasoya mana titi orana, hasoya mana hinaxaga ri etua long xaiya ma. ");
INSERT INTO met_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Bagula uhaung waxangia bu oxop runginama, saing bagula utuxu kixingima oxatanoa. Ne bungina uhau hatumingama ba uyamu, bagula uhitixiya gotinganoa sangua waxumtuanoa.” ");
INSERT INTO met_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Tauna, Iso hauxang sibuna mana Yekop namua na tibuna sina guxama na kixinginoa bila ba. Binabu harua hatumingania ba, “Haxek bagula tibugu mati, baing sinianoa sok. Sup, baing bagula ngaung kixingigua Yekop mati.” ");
INSERT INTO met_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ne dibaxanga sabangua Iso haruanganoa na Rebeka, binabu wagi garang nanunoa Yekop ma saing harua na ba, “Ulungu to. Sabangama Iso tatua atindi mana hatumingua bo ba unggung mati. ");
INSERT INTO met_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Binabu garagua ulungu haruangagu li: Umesa ugiti mala rangua moxongogua Laban mana titia Haran. ");
INSERT INTO met_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ula uwa rangua monga laing sabangama atindi daxaringa. ");
INSERT INTO met_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Sabangama ating salianoa sup xaung halingalinga kubolua ulibu mana to, tauna bagula ngasina haruangua ba ugoxoya ma muli. Bola tang gamati mana xaidap taininau, ne xai te nabu ayanga na bila ba xap nga!” ");
INSERT INTO met_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Baing Rebeka harua na Aisak ba, “Hauxagu sibuna mana haing Hittamgadi li. Nabu Yekop xap hainga liwe mana titia li moxong nanuhangindi, adi Hitdi bila haing luwadi li, bing ngabo ba ngamati.” ");
INSERT INTO met_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Binabu Aisak wagi Yekop ma saing sina guxama na. Baing tabina ba, “Labu oxop hainga rangua haing Kenangamgu tai. ");
INSERT INTO met_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Umesa ula mana titia Padan-Aram, mana baum tibuna Betuel numanoa, saing oxop hainima la ba. Uyau toxongoma Laban nanuhanging tela. ");
INSERT INTO met_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ngaxusunga Urana Haringing Sibuna ba sina guxama naung saing sina gara xumana naung xaung libu bakbagimdi disok xumang sibuna laing disok numanuma xumana. ");
INSERT INTO met_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ngaxusunga ba sina guxamga sina na Ebraham ba naung xaung na bakbagimdi, bu sanga ba udali oxop titia hatata uwa lobu mana ba, titia Urana sina na Ebraham baing.” ");
INSERT INTO met_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Binabu Aisak soxi Yekop mala, saing ila Padan-Aram rangua Laban, Betuel garang luba, Aram tela. Rebeka moxongonoa, Iso Yekop tang bauding. ");
INSERT INTO met_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Tauna, Iso lungu ba Aisak sina guxama na Yekop saing soxi mala mana Padan-Aram bu xap hainga la ba. Lungu ba bungina Aisak sina guxama na, tabina ba labu xap hainga rangua haing Kenangamgu tai. ");
INSERT INTO met_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Lungu xauna ba Yekop lungu baungtibundi haruangadinga saing ila (mana) Padan-Aram. ");
INSERT INTO met_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Baing ina naga, Iso bagu xabia ba tibuna Aisak hauxana mana haing Kenangamdi, ");
INSERT INTO met_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","binabu ila rangua Ebraham garang tela Ismael bakbaginoa, saing yau Mahalat, Ismael nanuhanginoa xaung Nebaiot hamunganoa. Hauna li gugu haining luwa yaudi ba. ");
INSERT INTO met_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yekop yunga Berseba saing haxa mala mana longga Haran. ");
INSERT INTO met_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Sok mana long tela, saing kinu la ba, namua na xaidaba ri masup. Xap longga ba sianging tela, ta toxong hangaxobinia bila kandilong, saing kinu. ");
INSERT INTO met_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Mip saing bagu taxaga, namua wa titia, uxunoa haing mala long xaiya. Baing Urana uleginamdi dahaing diri mana mua. ");
INSERT INTO met_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","La ba etua mana baing Toxoratamona li mua, saing harua ba, “Nga Toxoratamona, Urana mana tibum (ranggina) Ebraham xaung Urana mana Aisak. Titia hatata ukinu mana bagula sina naung xaung na bakbagimdi. ");
INSERT INTO met_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Bakbagimdi bagula disok xumana bila titia gagabindi, saing bagula duxa duxa mala mana sangga yuwaxa xaung sangga karaga, xaung mala mana sangga kanggua xaung sangga bukang. Baing guxama ngasina naung xaung na bakbagimdi bagula xap bakbak titiam longgalo. ");
INSERT INTO met_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ulungu to. Ngawa ranguaung saing bagula ngawasa maung mana longlonga ula manadi, saing bagula ngaxapkung ma mana titia li muli. Bagula ngasauyaung te, laing ngalibu haruanga longgalo ngahau ranguaung manadi ba.” ");
INSERT INTO met_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yekop baguti (muli) saing harua ba, “Maxung sibuna Toxoratamona wa mana longga li, ne (muga/menau) ngaxabia (alaba) te.” ");
INSERT INTO met_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Maxuwa saing harua ba, “Ngahixi mana longga li. Urana numana naga, xaung long xaiya xaluxinoa.” ");
INSERT INTO met_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Buraraging sibuna Yekop xap sianga kinu toxonoa mari mana ba saing rang mali bu wa mogungua saing matu guxenga etua mana. ");
INSERT INTO met_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Uxu longga ba Betel. Ne muga duxu longga ba Lus. ");
INSERT INTO met_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Baing Yekop hau haruangua rangua Urana, harua ba, “Nabu Urana bagula wa rangua nga xaung bagula wasa manga mana haxangagu li, xaung bagula sina anginga xaung imangdi nanga, ");
INSERT INTO met_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","bu ngagoxoya ma muli tibugu numania xai, bing Toxoratamona bagula (wa) Urana ngayua. ");
INSERT INTO met_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Baing siangga li ngarang mali bagula Urana numanoa. Baing (mana) xalaxala longgalo sinadi nanga, bagula ngasina hataing 10 na.” ");
INSERT INTO met_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Baing Yekop haxa malauyu, saing ila sok mana titia mana lipu karagamdi. ");
INSERT INTO met_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Bagu mala saing bagu lang bangguming tela raxangia. Baing sipsip bakbak tuwa dikinuʼm tabu rubinia, namua na moxondi disinadi lang mana lang banggumina ba. Sianga rabauti lang bangguming xuanoa ba sabanga. ");
INSERT INTO met_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Bungina sipsip bakbak longgalo dima digugunia la ba, lipu sipsip wasanganamdi bagula ditutuxuya sianga mala sangua lang bangguming xuanoa bu disina langa na sipsibadi. Sup, baing diriba lang bangguming xuanoa muli siangia. ");
INSERT INTO met_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Baing Yekop xusunga lipu sipsip wasanganamdi ba, “Riagu mana, yabaima bi?” Dahaxuya ba, “Yabamam Haran.” ");
INSERT INTO met_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Xusungadi ba, “Axabia Laban, Nahor garanoa?” Dahaxuya ba, “Wane. Am gaxabiau.” ");
INSERT INTO met_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Baing Yekop xusungadi ba, “Wa xai(yu)?” Daharua ba, “Wa xai(yu). Bagu nanuhanginoa Retsel ma xaung sipsipdi (lo).” ");
INSERT INTO met_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Harua ba, “Bagu xaidap liauyu. Xaidap maxanoa mana agugunia sipsibadi teguyu. Asina langa na sipsibadi saing axapdi mala raxangia muli bu daxang.” ");
INSERT INTO met_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Dahaxuya ba, “Tegu. Am sanga te. Sipsip bakbak longgalo digugunia ma to, ditutuxuya sianga mala sangua lang bangguming xuanoa, tauna am gasina langa na sipsibadi.” ");
INSERT INTO met_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yekop harua nadiyu, baing Retsel sok xaung tibuna sipsibindi, namua na ina haing sipsip wasanganama. ");
INSERT INTO met_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yekop bagu toxongonoa Laban nanuhanginoa Retsel xaung Laban sipsibindi, baing ila tutuxuya sianga sangua lang bangguming xuanoa saing sina langa na toxongonoa sipsibindi. ");
INSERT INTO met_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Baing Yekop libu Retsel saing ungguti tang. ");
INSERT INTO met_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Baing Yekop bala Retsel ba tibuna sibinoa, xaung Rebeka garanoa. Binabu luki mala baxanga na tibuna. ");
INSERT INTO met_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban lungu ba toxongonoa Yekop ma, baing hata sibuna li luki mala masok mana. Yoxoa xaung libu saing xap ma numia. Baing Yekop naxuya na axadi disok mana. ");
INSERT INTO met_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Baing Laban harua na ba, “Maxung sibuna kitam sip tainina.” Yekop wa rangua sobak tela ila sup, ");
INSERT INTO met_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","baing Laban harua na ba, “Ung sibigua, ung sanga ba uwaxata olang manga te. Ubala nga giminaga murum mana ba.” ");
INSERT INTO met_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Tauna, Laban nanuhanging luwa. Sabangua yanoa Lea xaung nanunoa yanoa Retsel. ");
INSERT INTO met_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea maxandi didoa, ne Retsel sangganoa xai sibuna xaung gumangina. ");
INSERT INTO met_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yekop murung sibuna mana Retsel, binabu harua ba, “Bagula ngatuxu oxatama niani 7 to. Tauna, unai mana ngayau nanuhangima (nanuma) Retsel.” ");
INSERT INTO met_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban harua ba, “Xai ba ngasina naung, nam ngasina na lipu tela. Binabu uwa mua rangua nga.” ");
INSERT INTO met_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Binabu Yekop waxata niani 7 ba xap Retsel, ne disup sap bila xaidap unrangina hatumingania, namua na muruna buk mana. ");
INSERT INTO met_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Disup, baing Yekop harua na Laban ba, “Usina hainigua nanga. Xaidabigudi disup, saing ngabo ba ngakinu rangua.” ");
INSERT INTO met_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Binabu Laban wagi lipu longgalo mana longga ba ma, saing tongtongia taungua. ");
INSERT INTO met_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ning yambongga baguba xap nanuhanginoa Lea mala rangua Yekop, saing kinu rangua. ");
INSERT INTO met_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Laban sina haining oxata olanggama Silpa na nanuhanginoa Lea ba sok haining oxata olanggama.) ");
INSERT INTO met_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Buraragina baing si! Lea baing! Binabu Yekop harua na Laban ba, “Uraxata manga? Ngawaxata ba ngayau Retsel, a? Baruta ulangua nga?” ");
INSERT INTO met_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban haxuya ba, “Kubolua sina nanunoa muga mana matuaua ba yau, am laliamdi kubolumama te. ");
INSERT INTO met_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Uragu sande tela laing yaunga taungana li sup to. Tauna, bagula am gasina nanunoa naung xauna. Ne bagula utuxu oxatua manga niani 7 muli mana.” ");
INSERT INTO met_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Binabu Yekop libu bila ba. Sahi sande baguba mana Lea, baing Laban sina nanuhanginoa Retsel na ba sok haininoa. ");
INSERT INTO met_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Laban sina haining oxata olanggama Bilha na nanuhanginoa Retsel ba sok haining oxata olanggama.) ");
INSERT INTO met_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Baing ina naga, Yekop kinu rangua Retsel xauna, saing murungang sibuna mana Retsel dali murungang sibuna mana Lea. Baing tuxu Laban oxatanoa niani 7 muli. ");
INSERT INTO met_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Toxoratamona bagu ba Yekop muruna mana Lea buk te, baing hauli Lea ba gamona. Ne Retsel wa xuhi. ");
INSERT INTO met_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Binabu Lea gamona saing hayau gara lup tela. Uxu yanoa (ba, cf) Ruben, namua na harua bila li: “Toxoratamona bagu mauxangagua baing. Binabu hatata bagula ayuagu murung sibuna manga.” ");
INSERT INTO met_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Gamona muli, saing hayau gara lup tela muli. Baing harua ba, “Toxoratamona lungu ba ayuagu murung sibuna manga te, binabu sinasina gara luba li nanga xauna.” Binabu uxu yanoa ba Simion. ");
INSERT INTO met_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Baing Lea gamona muli, saing hayau gara lup tela. Baing harua ba, “Sup baing. Hatata bagula ayuagu taga rangua nga, namua na ngahayau gara lup tuwa na.” Binabu uxu yanoa Libai. ");
INSERT INTO met_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Gamona muli, saing hayau gara lup tela muli. Baing harua ba, “Hatata bagula ngaiti Toxoratamona yanoa.” Binabu uxu yanoa Yuda. Baing ina naga, Lea sup mana hayauxingua. ");
INSERT INTO met_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Retsel bagu ba hayau gara tela na Yekop te, baing bagulinga mana hamunganoa. Binabu harua na Yekop ba, “Usina garadi nanga! Tegu bing ngamati.” ");
INSERT INTO met_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yekop atin disala mana Retsel, saing harua ba, “Ngawa Urana te! Ina naga soxauti gamoma ba!” ");
INSERT INTO met_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Baing harua ba, “Bagu Bilha hainigu oxata olanggamga li. Ukinu rangua, bu hayau gara tela bu ngaxapkuti. Bila balau bagula nga xauna ngaxap bakbaga masok.” ");
INSERT INTO met_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Binabu Retsel sina haining oxata olanggama Bilha na bila haininoa. Baing Yekop kinu rangua, ");
INSERT INTO met_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","saing gamona saing hayau gara lup tela na. ");
INSERT INTO met_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Baing Retsel harua ba, “Urana suxuya kubolugua saing harua ba maringina. Lungu xusungagua saing sina gara lup tela nanga.” Binabu uxu yanoa ba Dan. ");
INSERT INTO met_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Retsel haining oxata olanggama Bilha gamona muli saing hayau gara lup tela muli mana Yekop. ");
INSERT INTO met_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Baing Retsel harua ba, “Malimaligua rangua hamungagua haringing sibuna, saing ngadali baing.” Binabu uxu yanoa ba Naptali. ");
INSERT INTO met_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea bagu ba sup mana hayauxingua, baing xap haining oxata olanggama Silpa saing sina na Yekop bila haininoa. ");
INSERT INTO met_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Baing Lea haining oxata olanggama Silpa hayau gara lup tela na Yekop. ");
INSERT INTO met_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Baing Lea harua ba, “Kubolu dalingam xap nga baing!” Binabu uxu yanoa ba Gad. ");
INSERT INTO met_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Baing Lea haining oxata olanggama Silpa hayau gara lup tela muli na Yekop. ");
INSERT INTO met_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Baing Lea harua ba, “Gamogua yaha sibuna! Haingdi bagula duxu nga ba haing yahangam.” Binabu uxu yanoa ba Aser. ");
INSERT INTO met_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Tauna, bunging wit xauyanganam sok, baing Ruben ila umangia saing bagu mandirek marang teladi, saing xapdi ma rangua bauna Lea. Baing Retsel harua na Lea ba, “Garama madirek marandi ba, sanga ba usina teladi nanga?” ");
INSERT INTO met_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ne Lea harua na ba, “Oxop ayuagu masup! Sanga maung te? Bagula oxop garagua mandirek marandi xauna?” Retsel harua ba, “Sangau. Sanga ba Yekop kinu ranguaung hatata yambong, nabu uhakhaxuya garam mandirek marandi nanga.” ");
INSERT INTO met_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Bungbung Yekop goxoya umangia ma, baing ina naga Lea sok mala gugunia daxangia saing harua ba, “Bing uma ukinu rangua nga hatata yambong. Namua na ngagimgung mana garagua mandirek marandi.” Binabu Yekop kinu rangua (mana) yambongga baguba. ");
INSERT INTO met_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Urana lungu Lea sabunganoa, saing gamona muli saing hayau gara lup luwadi luwadi hiliadinga na Yekop. ");
INSERT INTO met_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Baing Lea harua ba, “Urana sina giminaga nanga namua na ngasina hainigu oxata olanggama na ayuagu.” Binabu uxu yanoa ba Isakar. ");
INSERT INTO met_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Baing Lea gamona muli, saing hayau gara lup 6 na Yekop. ");
INSERT INTO met_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Baing Lea harua ba, “Urana sina yahanga xai nanga. Hatata ila bagula ayuagu iti yagua, namua na ngahayau gara lup 6 na.” Binabu uxu yanoa ba Sebulun. ");
INSERT INTO met_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Kimuya monga Lea hayau haing nanung tela saing uxu yanoa ba Daina. ");
INSERT INTO met_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Baing Urana hatumia Retsel muli saing lungu sabunganoa, saing hauli ba gamona. ");
INSERT INTO met_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Gamona saing hayau gara lup tela, saing harua ba, “Urana unia memeyagua ba.” ");
INSERT INTO met_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Uxu yanoa ba Yosep, saing harua ba, “Ngasabu ba Toxoratamona sina gara lup tela muli nanga.” ");
INSERT INTO met_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Retsel hayau Yosep masup, baing Yekop harua na Laban ba, “Unai mana ngagoxoya muli mala mana nga sibugu yabagua xaung titigua. ");
INSERT INTO met_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Unai mana hainigudi xaung garagudi ngatuxu oxatama manadi ba digabu nga bu ngala, namua na uxabia ba ngatuxu oxatama xai.” ");
INSERT INTO met_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ne Laban harua na ba, “Nabu uhatum xai manga, bing usauya nga te. Ngatuxu tuak saing ngaxap xabianga ba Toxoratamona sina guxama nanga namua na uwa rangua nga.” ");
INSERT INTO met_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Baing Laban harua muli ba, “Umogu gimingagima, saing bagula ngagim.” ");
INSERT INTO met_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yekop harua na ba, “Ung sibum uxabia ngatuxu oxatama haringina baru, xaung morumdi bakbagidingdi ditubu baru bungina ngawasa manadi. ");
INSERT INTO met_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Muga morumdi xumana buk te, ne hatata titingandi ditubu sibuna, saing Toxoratamona sina guxama naung long baruamta ngawa mana. Ning hatata raxata manga? Bungintabi sanga ba ngahauli nga sibugu bakbagigua?” ");
INSERT INTO met_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban xusunga ba, “Ubo ba ngasina baraxinta naung?” Haxuya ba, “Heku mana usina axamang tela nanga. Ne, nabu ulibu bila li manga, bagula (ngahaxang xaung) ngawasa mana murumdiyu. Hatumingagua bila li. ");
INSERT INTO met_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Unai mana hatata ngala ngasuxuya murum longgalo, saing bagula ngaunia sipsip baruamtadi mugiximugixindi, sipsip tutubing baruamtadi dimutuxu xaung meme baruamtadi mugixigixindi. Bagula duwa giminagigua. ");
INSERT INTO met_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Bila balau, kimuya bunging bungina usuli mana morudi usinadi nanga mana giminagigua, bagula uxabia ba maxuna ngasu mana haruangagua. Meme baruamtadi mugixigixindi te duwa liwe mana ngayuadi, kimbo sipsip tutubing baruamtadi dimutuxu te, bagula uxabia ba ngahanaidi.” ");
INSERT INTO met_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban harua ba, “Sangau. Talibu bila uharua ba.” ");
INSERT INTO met_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ne xaidapka baguba Laban unia meme moning longgalo mugixigixindi, xaung meme hagaxang longgalo mugixigixindi, adi longgalo hataindi dusa, xaung sipsip tutubing longgalo dimutuxu, saing tadi garang lupdi rimadingia bu duwasa manadi. ");
INSERT INTO met_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Baing ta ganangana bila xaidap luwa hiliana haxanganoa liwe maina xaung Yekop. Ne Yekop wasa mana Laban morundi bakbagidingdi duwauyu. ");
INSERT INTO met_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Baing Yekop taxiti xaiyadi talia, poplar xaung plen rimadingia, saing suki sanggading teladi bu hatanga rimading luding usamandi masok maxixinga maxixinga. ");
INSERT INTO met_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Baing rang xaidi rimading kisingamdi mahaing mana mina nungingamdi, bu duwa morudi bakbagiding maxadingia bungina dima dinung. Bungina bakbagidingdi sobagiding hagatangama sok saing dima ba dinung, ");
INSERT INTO met_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","dahagata xaidi rimadingdi maxadingia. Baing ina naga, dahayau gara mugixigixindi. ");
INSERT INTO met_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yekop hata tutubinadi sangua Laban bakbagindi saing tadi halianga. Ne bunging hagatangama xugia iniadi mala ba dibagu Laban morung mugixigixindi xaung morung mutuxundi. Bila balau libu bakbagindi disok ditubu, saing tadi rangua Laban morundi te. ");
INSERT INTO met_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Bunging bungina hagaxang haringindi duwa mana bunging hagatangama, Yekop bagula rang xai rimandi mali mana minadi asaxadi maxadingia bu dahagata haxek manadi. ");
INSERT INTO met_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ne adi haringing teguamdi, tadi la ba te. Bila balau haringing teguamdi duwa Laban iniadi, ne haringindi duwa Yekop iniadi. ");
INSERT INTO met_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Baing ina naga, Yekop xalingindi ditubu sibuna. Sipsibing memeng bakbagindi disok sabanga, haining lipuxing oxata olanggam xumana, xaung kamel donki iniadi xumana. ");
INSERT INTO met_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yekop xap haruanga ba Laban garang lupdi daharua ba, “Yekop xap tibura xalinging longgalo masup saing xap xalinging longgalo masok mana tibura xalingindi.” ");
INSERT INTO met_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Baing Yekop bagu ba Laban ramramonoa xugia mana saing hatuminganoa wa rangua bila muga te. ");
INSERT INTO met_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Baing Toxoratamona harua na Yekop ba, “Ugoxoya mala muli mana tibum titinoa xaung rangua bakbagimdi, saing bagula ngawa ranguaung.” ");
INSERT INTO met_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Binabu Yekop sina haruanga mala rangua Retsel Lea tang ba tang disok ma mana longga morundi bakbagidingdi duwa mana ba. ");
INSERT INTO met_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Harua na dingtang ba, “Ngabagu ba tibuim ramramonoa xugia manga saing hatuminganoa wa rangua nga bila muga te. Ne Urana tibugu inia wa rangua nga ba. ");
INSERT INTO met_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Tang gaxabiau, ngatuxu oxatua mana angtang tibuim xaung haringingagu longgalo. ");
INSERT INTO met_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ne tibuim langua nga bila xugia giminagigua bunging 10. Ning Urana soxauti bu hanggalangia nga te. ");
INSERT INTO met_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Nabu harua ba, ‘Mugixigixindi bagula duwa giminagima,’ bing bakbakkadi dahayau mugixigixindi. Baing bungina xugia hatuminganoa saing harua ba, ‘Maxixingamdi bagula duwa giminagima,’ bing bakbakkadi dahayau maxixingamdi. ");
INSERT INTO met_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Bila balau Urana sasaxaki tibuim morundi saing sinadi nanga. ");
INSERT INTO met_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Bunging tela mana sobak hagatangama, ngamip saing ngabagu meme moninadi dahaing mana hagaxandi duwa mugixigixindi. ");
INSERT INTO met_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Baing mana mibingagua Urana uleginama harua nanga ba, ‘Yekop.’ Ngahaxuya ba, ‘Ngawau.’ ");
INSERT INTO met_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Baing harua ba, ‘Ubagu mahaing, saing bagula ubagu ba meme moninadi dahaing mana hagaxandi duwa mugixigixindi. Wa bila ba namua na ngabagu masup axamang longgalo Laban libudi maung. ");
INSERT INTO met_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nga Urana ngaowa masok maung mana Betel, longga urang sianga mali bu wa mogungua saing umatu guxenga etua mana, xaung longga uhau haruangua rangua nga. Tauna hata sibuna li umesa usauya titia li ugoxoya mala yabamia.’ ” ");
INSERT INTO met_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Baing Retsel Lea tang dahaxuya ba, “Bungina tibumam mati, bagula am gaxap xalinging (sinaging) tela te. Tegu sibuna! ");
INSERT INTO met_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Kubolunoa libu mamtam bila tam (haing) titi telamdi! Namua na gotigamam xap sanga mana te. Tegu. Sahi olang sianga ugim na mamtam xauna! ");
INSERT INTO met_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Axalaxala longgalo Urana uniadi sangua tibumam bing amiadi xaung garamamdi dingiadi. Binabu ulibu baraxing baraxinta Urana balaung mana ba.” ");
INSERT INTO met_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Binabu Yekop mesa saing ta hainindi garandi etua mana kameldi, ");
INSERT INTO met_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","saing soxi sipsip meme bakbagidingdi dila dimuga mana, xaung axalaxaladi xapdi mana titia Padan-Aram. Baing haxa mala mana titia Kenan, titia tibuna Aisak wa mana ba. ");
INSERT INTO met_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Muga, bungina dibo ba dilauba, Laban ila bu xuxuya sipsibing buxandi, baing Retsel hanai tibuna babung numanamdi. ");
INSERT INTO met_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Xauna, Yekop tuxu muraga mana lipu Aramgam Laban, bila baxanga gitinganoa na te. ");
INSERT INTO met_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Binabu giti mala xaung xalinging longgalo, kisi Langga Yupretis, saing ila bila xaxagandi duwa mana titia Gileat. ");
INSERT INTO met_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Xaidap luwa hiliana, baing dibala Laban ba Yekop giti mala. ");
INSERT INTO met_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Binabu xap bakbagindi saing xu Yekop mala. Xaidap 7 baing sok haxek mana Yekop mana xaxagandi duwa mana titia Gileat. ");
INSERT INTO met_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ne yambonga baguba Urana ma rangua lipua Aramgam Laban mibingia, saing harua na ba, “Umaxania. Labu uharua haruanga maxuwangam tela na Yekopku tai.” ");
INSERT INTO met_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Tauna, Yekop tongtongia tabalaxayanoa mana xaxagandi duwa mana titia Gileat bila bungina Laban sok mana. Baing Laban gabu bakbagindi ditongtongia tabalaxayadinga la ba xauna. ");
INSERT INTO met_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Baing Laban harua na Yekop ba, “Uraxata? Utuxu muraga manga, saing uxai nanuhangigudi mala bila haungingua salak yabanamdi! ");
INSERT INTO met_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Baruta ugiti mala hisangia, utuxu muraga manga bila ba? Nabu ubaxanga nanga, bing sanga ba ngayungaung daxangia xaung yahangua xaung duwaya dahali wagadi xaung hapdi? ");
INSERT INTO met_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Baing tegu. Usina gangana ba ngalibu garagu ranggindi xaung nanuhangigudi, ngayungadi daxangia te. Kuboluma kakahang sibuna! ");
INSERT INTO met_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Sanga ba ngahanggalangiang. Ne yambong Urana tibum inia harua nanga ba, ‘Umaxania. Labu uharua haruanga maxuwangam tela na Yekopku tai.’ ");
INSERT INTO met_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ngaxabiau, ula namua na atima mana yabama. Ning uraxata uhanai urana ngayuadi babudingdi?” ");
INSERT INTO met_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Baing Yekop haxuya na Laban ba, “Ngagiti mala hisangia namua na ngamaxuwa. Nam usasaxaki nanuhangimadi sangua nga.” ");
INSERT INTO met_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ne nabu ubagu ba amia tela tuxu urana ungiadi babudingdi, lipua ba walinganoa sup. Bakbagiradi maxadingia ung sibum usai mana axalaxala ungiadi. Nabu tela wa la li rangua nga, bing oxop mala.” Ne Yekop xabia ba Retsel hanai babuadi te. ");
INSERT INTO met_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Binabu Laban luxu mana Yekop numang mokiama xaung luxu mana Lea numang mokiama xaung luxu mana haing oxata olanggam luwa numading mokiama. Saisai sus. Baing ina naga, sok Lea numang mokiama ma saing luxu mana Retsel inia. ");
INSERT INTO met_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ne Retsel xap babu numanamdi saing yamengdi maluxuʼm axamang rungingama ta etua mana kamel. Baing rung etua manadi bila ba. Tauna, Laban saisai maluxuʼm numa mokiama susu. ");
INSERT INTO met_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Retsel harua na tibuna ba, “Tibugu, ugamia ngau tai, ne sanga ba ngamesa (ngali) maxamia te, namua na ngadamu.” Binabu saisaiyu mana babung numanamdi, baing susu. ");
INSERT INTO met_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Baing Yekop atindi disala saing gamia Laban ba, “Ngalibu baru mauxanganta? Ngalibu baru kubolu dianta ba uxu nga? ");
INSERT INTO met_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Usaisai masup mana xalingigu longgalo saing ubagu baraxinta ungia? Nabu ubagu xalingim tela, bing uta masok sabasabia li bakbagimdi bakbagigudi maxadingia, bu sanga ba disuxuya kitam baruamta maring! ");
INSERT INTO met_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Niani 20 li ngawa ranguaung. Sipsibindi xaung memeimdi dahayau doa te. Xauna, ngaxang memem monin tela te. ");
INSERT INTO met_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Adi asaxa abungindi disingsingdi ba, ngaxapdi ma ngahatangadi naung te. Tegu. Nga sibugu ngagimdi naung! Uhaxi ba ngagim asaxa baruamta dahanaidi, heku dahanai xaidap kimbo yambong. ");
INSERT INTO met_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Rungingagua bila li: Xaidap salianoa tatua nga, yambong xaringingoa bila balau, xaung kinunga xap nga te. ");
INSERT INTO met_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Bila balau niani 20 li ngawa numamia! Ngawaxata niani 14 bu ngaxap nanuhangim luwa, xaung naini 6 ngawaxata muli bu ngaxap sipsip meme bakbakkadi li. Baing uxugia giminagigua bunging 10! ");
INSERT INTO met_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Nabu Urana tibugu inia, Urana Ebraham inia xaung Urana Maxuwangam Aisak inia—nabu wa rangua nga te, bing maxuna bagula usoxi nga mala olang ngaxola. Ning Urana bagu salaga ngaxap xaung makasangagua, saing bunggu gamiaung.” ");
INSERT INTO met_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban haxuya na Yekop ba, “Hainggadi li nanuhangigudi, garuadi li garagudi, xaung asaxa bakbagidingdi ngayuadi. Xalaxaladi li ubagudi ngayuadi. Ne hatata daxanga te ba ngaxap nanuhangigudi kimbo garadi dahayaudi muli. ");
INSERT INTO met_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Binabu uma kitam tahau haruangua, xaung tatongtongia axamang tela ba hauli kitam tahatumia haruangua muli.” ");
INSERT INTO met_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Binabu Yekop xap siang maxaxaya tela saing rang mali bila mogungua. ");
INSERT INTO met_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Baing Yekop harua na sibindi ba, “Atagia siangdi.” Baing daxap siangdi ma dahaxurudi, saing daxang la ba haxarunga rubinia. ");
INSERT INTO met_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban uxu haxurunga ba Yegar-Sahaduta, ne Yekop uxu ba Galet. ");
INSERT INTO met_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban harua ba, “Haxurunga li mogungua hauli kitam tahatumia muli haruangua tahau hatata.” Namua naga duxu ba Galet. ");
INSERT INTO met_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Xauna, duxu ba Mispa, namua na Laban harua ba, “Taxusunga Toxoratamona ba bagu kitam xai ba tasu mana haruanga li hatata saing ila, bungina tawa xauna te. ");
INSERT INTO met_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Nabu ulibu doa mana nanuhangigudi kimbo nabu oxop haing tela muli, bing uhatumia muli ba, heku lipu tela bagu kubolura te, Urana bagu!” ");
INSERT INTO met_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Baing Laban harua muli na Yekop ba, “Ubagu haxurunga li xaung siang maxaxaya ngarang mali liwe makitam. ");
INSERT INTO met_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Haxurunga li mogungua, xaung siang maxaxaya li mogungua. Tang duwa ragu. Bagula ngadali haxurunga li ngala rubima bu ngahanggalangiaung te, saing bagula udali haxurunga xaung siang maxaxaya li ula rubigu bu uhanggalangia nga te. ");
INSERT INTO met_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Taxusunga Urana mana mugangaradi—Urana mana Ebraham xaung Urana mana Nahor—ba wa lipu suxuyangam liwe makitam.” Binabu Yekop haringia haruanganoa mana yaya mana Urana Maxuwangam tibuna Aisak inia saing harua maxung sibuna. ");
INSERT INTO met_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Hanania hananiangua la ba long xaxaganamia saing wagi bakbagindi ma taungia. Daxang masup, baing dikinu la ba. ");
INSERT INTO met_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Buragina buraraging sibuna Laban libu garang ranggindi xaung nanuhangindi saing sina guxama nadi. Sup, baing goxoya mala muli yabania. ");
INSERT INTO met_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yekop xauna yunga longga baguba. Haxa mala baing Urana uleginamdi digugunia. ");
INSERT INTO met_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yekop bagudi baing harua ba, “Alali Urana tabalaxayanoa!” Binabu uxu longga ba yanoa Mahanaim. ");
INSERT INTO met_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yekop soxi uleginamdi dimuga mana mala rangua sabanganoa Iso mana titia Seir wa mana numanuma Idom. ");
INSERT INTO met_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Tabinadi ba, “Aharua na lipuxigu sabanga Iso bila li: ‘Lipuxim oxatama Yekop harua ba ngawa rangua Laban ila ila laing hatata. ");
INSERT INTO met_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Nga bulmakaugudi xaung donkigudi, sibsibigudi xaung memegudi, xaung lubigu hainigu oxata olanggamdi. Ngasina ulekka li na lipuxigu sabanga namua na ngabo ba uhatum xai manga.’ ” ");
INSERT INTO met_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Bungina Yekop uleginamdi digoxoya ma rangua, daharua ba, “Am gala rangua sabangama Iso, saing hatata ma ba guguniaung, saing lipu 400 digabu ma.” ");
INSERT INTO met_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yekop maxuwa buk xaung hatum xumana. Binabu hata lipuadi duwa rangua xaung sipsip meme bakbagidingdi xaung bulmakaudi xaung kameldi xauna ba disok bakbak luwa. ");
INSERT INTO met_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Hatum ba, “Nabu Iso ma wasoso bakbak tela, bola bakbaga wauyu sanga ba (di)giti mala.” ");
INSERT INTO met_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Baing Yekop sabu ba, “O Urana mana tibugu ranggina Ebraham xaung mana tibugu Aisak, O Toxoratamona, nulana uharua nanga ba, ‘Ugoxoya mala muli mana yabama xaung rangua bakbagimdi, saing bagula ngalibu xai maung.’ ");
INSERT INTO met_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Nga lipuxim oxatama, ne kubolugua sanga mana kubolu xaiyadi ulibudi nanga xaung kubolu haruanga sulinganama uhatanga nanga te. Waleu ngakisi mana Langga Yodan, ne ngatuxu tuki ing ganina. Ning hatata ngasok tabalaxai luwa. ");
INSERT INTO met_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ngaxusungaung ba oxop nga muli sangua sabangagua Iso rimanoa, namua na ngamaxuwa ba bagula ma wasoso nga, xaung garadi xaung baudingdi xauna. ");
INSERT INTO met_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ning waleu uharua nanga ba, ‘Maxuna bagula ngalibu xai maung, saing bagula ngalibu bakbagimdi disok xumana bila ulangulang(di) (du)wa tegia, sanga mana lipudi dititidi te.’ ” ");
INSERT INTO met_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yambong kinu la ba. Baing mogu xalinging hataina li ba sina na sabanganoa Iso bila yahangua: ");
INSERT INTO met_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","meme hagaxang 200 xaung moning 20, sipsip hagaxang 200 xaung moning 20, ");
INSERT INTO met_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kamel hagaxang 30 digabu garadingdi, bulmakau hagaxang 40 xaung moning 10, xaung donki hagaxang 20 xaung moning 10. ");
INSERT INTO met_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Haburadi bakbakkadi saing mogu lipuxing oxatam teladi ba duwasa mana bakbak taining tainina. Baing bala lipuxing oxatamdi ba, “Amuga manga, ne ata ganangana liwe mana moru(di) bakbak(giding) taining tainina.” ");
INSERT INTO met_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Hanaunau mugamugangama ba, “Bungina sabangagua Iso guguniaung saing xusungaung ba, ‘Ung gaxarea lipuxing oxatama? Ula bi? Ne morudi bagudi li gaxarea iniadi?’ ");
INSERT INTO met_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","bing uhaxuya ba, ‘Ding lipuxim oxatama Yekop iniadi. Ding yahanga sina na lipuxigu sabanga Iso. Bagu ma kimuya mam baing.’ ” ");
INSERT INTO met_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Bila balau hanaunau luxama xaung tuwama xaung teladi disu mana morudi bakbagidingdi ba: “Bungina ugugunia Iso bing aharua taininau na.” ");
INSERT INTO met_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Xauna, bing aharua ba, ‘Bagu lipuxim oxatama Yekop ma kimuya mam baing.’ ” Namua na hatum ba, “Bagula ngatatua ating salianoa xaung yahangadi li ngasinadi muga. Kimuya, bungina ngabagu, bola xap nga xai.” ");
INSERT INTO met_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Binabu Yekop yahangandi dimuga mana, ne ing sibuna wa tabalaxaya (mana) yambong baguba. ");
INSERT INTO met_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Yambong baguba Yekop mesa saing xap haining luwa, haining oxata olanggam luwa, xaung garang 11, saing kisi langga Yabok (uruxuna). ");
INSERT INTO met_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Xapdi saing soxidi mala mana lang hataina masup, baing sina xalinging longgalo makisi (mala). ");
INSERT INTO met_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Baing Yekop ing ganina wa. Ne yambongga baguba lipu tela ma haunggana laing xaidap. ");
INSERT INTO met_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Bungina lipua bagu xabia ba sanga ba dali Yekop te, ring xambaming namu, saing Yekop xambaminoa hasiana bungina tang dahaung mua. ");
INSERT INTO met_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Baing lipua harua ba, “Uyunga nga mala, namua na xaidaba haingguba.” Ne Yekop haxuya ba, “Tegu. Usina guxama nanga to, tauna bagula ngayungaung mala.” ");
INSERT INTO met_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Lipua xusunga ba, “Ung yama ga tela?” Haxuya ba, “(Nga) Yekop.” ");
INSERT INTO met_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Baing lipua harua ba, “Bagula duxu yama ba Yekop muli te, ne bagula duxu ba Isrel. Namua na uhanggana Urana xaung lipudi saing udalidi. ");
INSERT INTO met_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yekop harua ba, “Ubala nga yama.” Ne haxuya ba, “Uraxata uxusunga mana yagua?” Baing sina guxama la ba. ");
INSERT INTO met_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Binabu Yekop uxu longga ba Peniel, namua na harua ba, “Ngabagu Urana ramramonoa, ne ngamati te.” ");
INSERT INTO met_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Xaidaba haing bungina Yekop yunga Peniel, saing haxa doa mana namua xambaminoa. ");
INSERT INTO met_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Binabu waleu ma hatata, Isreldi daxang asaxa waxunoa sigi xambam namu te, namua na lipua ring Yekop xambaminoa haxek mana waxunoa. ");
INSERT INTO met_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yekop bagu mahaing saing bagu Iso ma rangua lipuxing 400. Binabu hata garadi mana Lea, Retsel xaung haining oxata olanggam luwadi (ba). ");
INSERT INTO met_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ta haing oxata olanggamdi digabu garadingdi muga, Lea gabu garandi kimu mana, saing Retsel Yosep tang dima kimu sibuna. ");
INSERT INTO met_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ing sibuna ila muga manadi. Haxa mala bila sabanganoa, saing gung king tuxundi mari, saing turu mari titia. Libu bila ba bunging 7 laing sok haxek mana sabanganoa. ");
INSERT INTO met_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ne Iso luki mala ba gugunia saing yoxoa. Hibua rimandi taxiya waxungtuania saing libu, saing tang ditang. ");
INSERT INTO met_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Baing Iso bagu mahaing saing bagu haingdi digabu garadi. Xusunga ba, “Adi li digabung gaxarea?” Yekop haxuya ba, “Urana atin dimoti manga, lipuxim oxatama, saing sina garadi li nanga.” ");
INSERT INTO met_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Baing haing oxata olanggamdi dima haxek saing dituru mari titia. ");
INSERT INTO met_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Bila balau Lea gabu garandi disok saing dituru mari titia. Kimu sibuna Yosep Retsel tang disok, saing tang dituru mari titia xauna. ");
INSERT INTO met_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Iso harua ba, “Baruta mana morudi bakbagiding xumana menau ngasok manadi?” Haxuya ba, “Lipuxigu sabanga, ngasina yahanga li bu uhatum xai manga.” ");
INSERT INTO met_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ne Iso harua ba, “Kixingigu, morugudi sanga manga. Utuxu axadi li naung sibum.” ");
INSERT INTO met_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ne Yekop harua ba, “Tegu ke. Nabu uhatum xai manga, bing oxop yahangagu li ngasina naung. Ngabagu ramramoma. Bila ngabagu Urana ramramonoa, namua na oxop nga uhatum xai manga. ");
INSERT INTO met_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ngabo ba oxop yahanga li ngasina naung, namua na Urana atin dimoti manga, saing morugudi sanga manga.” Baing ina nanga, mana namua Yekop haxi, Iso xap. ");
INSERT INTO met_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Baing Iso harua ba, “Tauna, talauba. Bagula ngamuga maung.” ");
INSERT INTO met_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ne Yekop harua na ba, “Lipuxigu sabanga, uxabia ba garadi daharing buk te. Xauna, ngahatum hatum xumana mana sipsip xaung bulmakau hagaxandi garadingdi dinam (manadi) ba. Bing ngawasa manadi xai. Nabu ngalibudi dahaxa sap buk xaidap tela muli, bagula ding longgalo dimati. ");
INSERT INTO met_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Binabu lipuxigu sabanga, ula muga manga lipuxim oxatam to. Bagula ngama(ma) mosimos bila morudi xaung garadi dibo ba dahaxa ma, laing ngasok mana lipuxigu sabanga mana titia Seir.” ");
INSERT INTO met_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Iso harua ba, “Sangau. Ne ngabo ba ngayunga lipuxigu oxatam teladi ranguaung bu daxapkang ma. Sangau?” Ne Yekop haxuya ba, “Heku. Lipuxigu sabanga, kubolua oxop nga uhatum xai manga sanga ba.” ");
INSERT INTO met_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Binabu mana xaidapka baguba Iso haxa goxoya mala muli mana titia Seir. ");
INSERT INTO met_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ne Yekop haxa mala mana longga Sukot, saing tongtongia numa maina xaung tongtongia xahidi mana morundi. Binabu duxu longga ba Sukot. ");
INSERT INTO met_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Bila balau, Yekop yunga titia Padan-Aram, saing ma ma goxoya ma muli mana titia Kenan. Sok mosiu mana long sabangga Sekem, saing tongtongia tabalaxayanoa long sabangga ba singia. ");
INSERT INTO met_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Gim siang silba 100 na Hamor garandi, mana titi hataina (ba) tongtongia tabalaxayanoa mana. Sekem Hamor garang tela. ");
INSERT INTO met_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Tongtongia kabukabu hananiangam la ba, saing uxu ba El-Elohe-Isrel. ");
INSERT INTO met_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Xaidap tela Yekop Lea tang nanuhanginoa Daina sok mala bu bagu hainggadi duwa mana titia ba. ");
INSERT INTO met_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ne lipu tela yanoa Sekem wa. Hamor, Hib tela, titia ba yanaminoa, garanoa. Bungina Sekem bagu Daina, bing tuxu saing libu kubolu memayana mana. ");
INSERT INTO met_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ne atina taga mana Daina, Yekop nanuhanginoa. Murung sibuna mana haing nanuna ba saing harua hayaganga na. ");
INSERT INTO met_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Binabu Sekem harua na tibuna Hamor ba, “Oxop haing nanuna li nanga bu ngayau.” ");
INSERT INTO met_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yekop xap haruangua kubolu musuna xap nanuhanginoa Daina, ne garandi duwa ongania duwasa mana morundi. Binabu libu axamang tela te laing digoxoya ma numia. ");
INSERT INTO met_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Baing Sekem tibuna Hamor ila rangua Yekop bu hangixaya rangua. ");
INSERT INTO met_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Tang dahangixayauyu, baing Yekop garandi diyunga ongania digoxoya ma muli taxa mana bungina dilungu naxuyangua. Hatumingading mauxading xaung atiding disala buk, namua na kubolua Sekem libu bungina kinu rangua Yekop nanuhanginoa diang sibuna Isreldi maxadingia. Kubolua na bila ba labu lipu tela libu bila bau tai. ");
INSERT INTO met_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ne Hamor harua nadi ba, “Garagu Sekem atina taga mana nanuhangima. Sanga ba usina na bu tang diyau?” ");
INSERT INTO met_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Atongtongia yaungadi ranguam. Asina nanuhangimdi nam xaung axap nanuhamimamdi nang. ");
INSERT INTO met_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Sanga ba arung liwe mam. Titia xaxaina nang. Awa mana, ahaxa mauli mana ang murungaima mana, saing agim titia mana.” ");
INSERT INTO met_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Baing Sekem harua na Daina tibuna xaung moxongondi ba, “Nabu ahatum xai mana xusungagua, bing bagula ngasina nang baraxing baraxinta axusunga mana. ");
INSERT INTO met_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Amogu gotik xaung yahangua abo ba ngasina nang giminagindi. Heku sabanga baru, bagula ngagim bila axusunga. Ne ngabo sibuna ba asina haing nanunoa nanga bu sok hainigua.” ");
INSERT INTO met_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ne Yekop garandi dilangua Sekem tibuna Hamor tang bungina dahaxuya nadi, namua na Sekem libu kubolu musuna na hamungadinga. ");
INSERT INTO met_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Daharua nadi ba, “Sanga ba am galibu bila bau tai. Sanga ba am gasina hamungamama na lipu sangga xuxungang teguam tela te. Nabu am galibu bila ba, bagula am gaxap memaya sabanga. ");
INSERT INTO met_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Bagula am ganai mana haruangaima nabu alibu axamang taininau ing ganina: Muga bing asok bila am. Axuxu lubim longgalo sanggadingdi to. ");
INSERT INTO met_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Sup, baing bagula am gasina nanuhangimamdi nang xaung am gaxap nanuhangimdi mam. Bagula am garung liwe mang xaung am gasok bakbak taininau ranguang. ");
INSERT INTO met_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ne nabu ang ganai mana axuxu sanggaimdi te, bagula am gaxap hamungamama am gasauyang mala.” ");
INSERT INTO met_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Haruangadinga xai mana Hamor garanoa Sekem tang. ");
INSERT INTO met_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Baing gananuna Sekem halisi ba libu haruangadinga te, namua na muruna buk mana Yekop hanuhanginoa. Sekem yanoa sabanga sibuna tibung bakbaging longgalo maxadingia. ");
INSERT INTO met_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Binabu Hamor garanoa Sekem tang dila long sabangga xaluxinoa bu daharua rangua long sabangga ba lipuxindi. Tang daharua ba, ");
INSERT INTO met_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Lipuadi li dirung mosiu ranguam. Bagu titira sabanga, sanga manadi. Tayungadi duwa titiria xaung dahaxa mauli mana ding murungadinga mana. Sanga ba tayau nanuhangidingdi saing sanga ba diyau kiriadi. ");
INSERT INTO met_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ne lipuadi bagula dinai mana duwa rangua kira bila bakbak taininau nabu talibu axamang taininau ing ganina. Dahaxi ba lubira longgalo duxuxu sanggadingdi bila ding sibuding to. ");
INSERT INTO met_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ahatum to. Nabu talibu bila ba, bagula xalingidingdi xaung moruding longgalo disok kiriadi, a? Binabu tanai mana haruangadinga, saing bagula dirung liwe makira.” ");
INSERT INTO met_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Tauna, lup longgalo digugunia long sabangga xaluxinia dinai mana Hamor garanoa Sekem tang haruangadinga, saing duxuxu long sabangga ba lubing longgalo sanggadingdi. ");
INSERT INTO met_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Xaidap tuwa sanggading disalauyu, baing Yekop garang luwa Simion xaung Libai, Daina moxongondi, tang daxap waxangiding sabangadi saing diwasoso long sabangga ba bungina dimaxania te, saing tang dung lup longgalo mati. ");
INSERT INTO met_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Tang dung mati Hamor garanoa Sekem tang waxangidingia, saing daxap Daina ma sangua Sekem numanoa saing dila. ");
INSERT INTO met_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Sup baing Yekop garandi dila disok mana matiadi saing daxap xalaxaladi duwa mana long sabangga ba mala, namua na kubolu musuna xap hamungadinga la ba. ");
INSERT INTO met_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Daxap sipsibidingdi xaung bulmakaudingdi xaung donkidingdi xaung baraxing baraxinta dingia duwa maluxuʼm long sabangga ba xaung singia. ");
INSERT INTO met_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Xalingiding longgalo, garading longgalo, hainiding longgalo, xalaxala longgalo duwa numadingia, dituxudi daxapdi mala. ");
INSERT INTO met_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Sup, baing Yekop harua na Simion Libai tang ba, “Ang galibu mauxangang sabanga xap nga. Alibu ngabuya Kenandi xaung Peresdi maxadingia, adi duwa mana titia li. Kira lipu xumana buk te, saing nabu digugunia ding duwasoso nga, bagula nga ngagabu bakbagigudi am gahanggalang.” ");
INSERT INTO met_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ne tang dahaxuya ba, “Baruta? Xai mana libu kubolua na hamungamama bila haing daxangam?” ");
INSERT INTO met_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Baing Urana harua na Yekop ba, “Umesa uhaing mala mana longga Betel saing urung la ba. Utongtongia kabukabu hananiangam la ba nanga Urana ba owa masok maung bungina igiti mala sangua sabangama Iso.” ");
INSERT INTO met_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Binabu Yekop harua na sibindi xaung adi duwa rangua ba, “Aunia urana long telamdi babudingdi, saing alibuang asok sigixinga Urana maxania xaung asau imang haundi. ");
INSERT INTO met_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Sup, baing bagula tamesa tahaing mala mana longga Betel. La ba bagula ngatongtongia kabukabu hananiangam na Urana, Urana ba lungu nga mana xaidapka mauxanganoa xap nga xaung wa rangua nga long baruamta ngala mana.” ");
INSERT INTO met_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Binabu disina urana long telamdi babuding longgalo na Yekop xaung disina raxuadi duwa tangadingliania na, saing Yekop yaxangdi hawa mana xaiya ok haxek mana longga Sekem. ");
INSERT INTO met_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Baing ina naga, dahaxa mala, baing Urana libu maxuwanga sabanga xap lipuadi duwa mana longgadi duwa singia (manadi) bu duxu Yekop bakbagindi te. ");
INSERT INTO met_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Baing Yekop gabu lipuadi duwa rangua disok mana longga Lus mana titia Kenan. (Lus Betel yang mugangua.) ");
INSERT INTO met_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","La ba tongtongia kabukabu hananiangam, saing uxu longga ba yanoa ba El-Betel, namua na la ba Urana hatangaina masok na bungina giti mala sangua sabanganoa. ");
INSERT INTO met_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Duwa mana longga baguba, baing Debora, hainga wasa mana Rebeka bungina wa gara kambagina ba, mati saing dikimang hawa mana xaiya ok wa hawa mana longga Betel. Binabu duxu xaiya ba Alon-Bakut. ");
INSERT INTO met_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Kimuya mana Yekop yunga titia Padan-Aram goxoya ma titia Kenan, Urana owa masok mana muli saing sina guxama na. ");
INSERT INTO met_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Urana harua na ba, “Hatata yama Yekop, ne bagula duxu yama ba Yekop muli te. Tegu. Bagula yama Isrel.” Binabu sina yaya Isrel na. ");
INSERT INTO met_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Baing Urana harua na ba, “Nga El-Sadai. Oxopsaxi usok xumana. Bagula usok numanuma xaung numanuma xumang teladi xauna, saing bagula bakbagim teladi disok xaitamoxidi. ");
INSERT INTO met_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Titia waleu ngasina na Ebraham xaung Aisak ba, hatata ngasina naung xauna. Baing bagula ngasina na bakbagimdi dima kimu maung.” ");
INSERT INTO met_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Urana harua laing sup, baing yunga la ba saing haing mala. ");
INSERT INTO met_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yekop rang siang maxaxaya tela ba mogu longga Urana harua rangua ba, saing matu wain xaung olip guxenganoa etua mana bila hananiangua (ila rangua Urana). ");
INSERT INTO met_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Binabu Yekop uxu longga ba Urana harua rangua ba (yanoa ba) Betel. ");
INSERT INTO met_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Tauna, diyunga longga Betel dahaxahaxa mala mana longga Eprat. Duwa hasoya monga, baing Retsel xunumia gara ruha saing makasa sibuna ba hayau. ");
INSERT INTO met_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Makasanganoa sapsambagiak, baing haing hayauxingama harua na ba, “Umaxuwau tai, namua na uhayau lup tela muli!” ");
INSERT INTO met_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Retsel yaganganoa bo ba supkuba, namua na (bo ba) matiuba, baing sina yaya Ben-Oni na garanoa. Ne tibuna sina yaya Benyamin na. ");
INSERT INTO met_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Retsel mati ba, saing ding dikimang daxangua ila mana Eprat rubinia. (Eprat Betlehem yang muganga.) ");
INSERT INTO met_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yekop rang siang maxaxaya tela etua mana gobagobanoa. Retsel gobagobang siang mogunganama, saing wauyu laing hatata (li). ");
INSERT INTO met_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isrel haxa mala muli, dali Migdal-Eder saing tongtongia tabalaxayanganoa hataina mana. ");
INSERT INTO met_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Isrel wa mana titia baguba, baing Ruben ila kinu rangua Bilha, tibuna haining oxatama (yau ba), saing Yekop lungu naxuyanga baguba. Yekop garang lup 12: ");
INSERT INTO met_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea garandi bing: Ruben, Yekop garang matuaua, Simion, Libai, Yuda, Isakar xaung Sebulun. ");
INSERT INTO met_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Retsel garandi bing: Yosep xaung Benyamin. ");
INSERT INTO met_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Retsel haining oxatama Bilha garandi bing: Dan xaung Naptali. ");
INSERT INTO met_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lea haining oxatama Silpa garandi bing: Gad xaung Aser. Adi li Yekop garang lupdi. Wa mana titia Padan-Aram bungina baudingdi dahayaudi na. ");
INSERT INTO met_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yekop goxoya ma rangua tibuna Aisak mana longga Mamre, haxek mana longga Kiriat-Arba. (Kiriat-Arba Hebron yang muganga.) Longga baguba longga Ebraham xaung Aisak tang duwa lobu mana ba. ");
INSERT INTO met_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aisak wa laing nianindi 180. ");
INSERT INTO met_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Baing yaganganoa sup saing mati bungina duanga. Niandi dibaxagi saing kinu rangua mugangandi. Baing garandi Iso Yekop tang dikimang. ");
INSERT INTO met_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iso bakbagindi bila li (Iso yan tela Idom). ");
INSERT INTO met_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso xap hainindi rangua Kenan haingdi. Tela yanoa Ada, Hit tela Elon nanuhanginoa. Tela yanoa Oholibama, Hib tela Sibeon nanuhanginoa. ");
INSERT INTO met_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Xauna, xap Basemat, Ismael nanuhanginoa xaung Nebaiot hamunganoa. ");
INSERT INTO met_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada hayau Elipas na Iso, Basemat hayau Ruel, ");
INSERT INTO met_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","saing Oholibama hayau Yeus, Yalam xaung Kora. Adi li Iso garang lupdi baudingdi dahayaudi na mana titia Kenan. ");
INSERT INTO met_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Baing Iso xap hainindi, garang lupdi, hanuhangindi, xaung lipuxing numanam longgalo, morundi, asaxang longgalo, xalinging longgalo xap mana titia Kenan. Xapdi saing ila titi tela halianga mana kixinginoa Yekop. ");
INSERT INTO met_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Tang xalingidingdi ditubu buk ba duwa xauna. Titia tang duwa mana ba sanga mana dingtang te, namua na morudingdi xumana buk. ");
INSERT INTO met_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Binabu Iso (yan tela Idom) ila rung mana xaxagandi duwa mana titia Seir. ");
INSERT INTO met_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iso Idomdi mugangadinga. Dirung mana xaxagandi duwa mana titia Seir. Bakbagindi bila li. ");
INSERT INTO met_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Adi li Iso garang lupdi yadingdi: Elipas, Iso haininoa Ada garanoa, xaung Ruel, Iso haininoa Basemat garanoa. ");
INSERT INTO met_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elipas garang lupdi bing: Teman, Omar, Sepo, Gatam xaung Kenas. ");
INSERT INTO met_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Iso garanoa Elipas yau haining oxata olanggama xauna, yanoa Timna. Hayau Amalek. Adi ba Iso haininoa Ada garang rangging lupdi. ");
INSERT INTO met_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ruel garang lupdi bing: Nahat, Sera, Sama xaung Misa. Adi ba Iso haininoa Basemat garang rangging lupdi. ");
INSERT INTO met_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Iso haininoa Oholibama, Ana nanuhanginoa xaung Sibeon nanuhanging ranggina. Oholibama garang lupdi hayau na Iso bing:: Yeus, Yalam xaung Kora. ");
INSERT INTO met_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Iso garang lup teladi disok yanamdi. Iso garang matuaua Elipas garandi disok yanamdi bing: Yanamdi Teman, Omar, Sepo, Kenas, ");
INSERT INTO met_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam xaung Amalek. Adi li yanamdi duwa mana titia Idom, tibudinga Elipas. Ding Ada garang ranggindi. ");
INSERT INTO met_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Iso garanoa Ruel garandi disok yanamdi bing: Nahat, Sera, Sama xaung Misa. Adi li yanamdi duwa mana titia Idom, tibudinga Ruel. Ding Iso haininoa Basemat garang ranggindi. ");
INSERT INTO met_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Iso haininoa Oholibama garandi disok yanamdi bing: Yeus, Yalam xaung Kora. Adi li yanamdi, garadi mana Iso hanining Oholibama, Ana nanuhanginoa. ");
INSERT INTO met_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Adi li Iso garang lupdi (yan tela Idom). Xauna, adi li bakbagidingdi yanamidingdi. ");
INSERT INTO met_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Sdeir Hor tela, bakbaga wa titia ba muga. Garang lupdi bing: Lotan, Sobal, Sibeon, Ana, ");
INSERT INTO met_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Eser xaung Disan. Adi li Seir garandi duwa mana titia Idom. Hordi yanamidingdi. ");
INSERT INTO met_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan garang lupdi bing: Hori xaung Heman. Timna Lotan hamunganoa. ");
INSERT INTO met_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal garang lupdi bing: Alban, Manahat, Ebal, Sepo xaung Onam. ");
INSERT INTO met_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibion garang lupdi bing: Aya xaung Ana. Ana baguli lipua naga sok muga mana lang maxamaxang salianamdi long xoliania bungina wasa mana tibuna Sibion donkindi. ");
INSERT INTO met_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana garandi bing: Dison xaung Oholibama. Oholibama Ana nanuhanginoa. ");
INSERT INTO met_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison garang lupdi bing: Hemdan, Esban, Itran xaung Keran. ");
INSERT INTO met_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser garang lupdi bing: Bilhan, Saban xaung Akan. ");
INSERT INTO met_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan garang lupdi bing: Us xaung Aran. ");
INSERT INTO met_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Adi li Hordi yanamidingdi: Lotan, Sobal, Sibeon, Ana, ");
INSERT INTO met_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Eser xaung Disan. Adi li Hordi yanamidingdi duwa etua mana titiading taining tainina mana titia Seir. ");
INSERT INTO met_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Adi li xaitamoxidi duwa etua mana titia Idom, muga mana xaitamoxi tela wa etua mana Isreldi: ");
INSERT INTO met_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, Beor garanoa, sok xaitamoxi mana Idom. Long sabangga inia yanoa Dinhaba. ");
INSERT INTO met_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela mati, baing Yobap, Sera garanoa, xap yabanoa sok xaitamoxi. Yabanoa Bosra. ");
INSERT INTO met_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobap mati, baing Husam mana titia Temandi duwa mana ba xap yabanoa sok xaitamoxi. ");
INSERT INTO met_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam mati, baing Hadat, Bedat garanoa, xap yabanoa sok xaitamoxi. Long sabangga inia Abit. Ila haunggana Midiandi saing dalidi mana titia Moap. ");
INSERT INTO met_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadat mati, baing Samla xap yabanoa sok xaitamoxi. Yabanoa Masreka. ");
INSERT INTO met_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla mati, baing Saul xap yabanoa sok xaitamoxi. Yabanoa Rehobot, langga Yupretis rubinia. ");
INSERT INTO met_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul mati, baing Bal-Hanan, Akbor garanoa, xap yabanoa sok xaitamoxi. ");
INSERT INTO met_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Bal-Hanan, Akbor garanoa, mati, baing Hadar xap yabanoa sok xaitamoxi. Long sabangga inia yanoa Pau. Haining yanoa Mehetabel, Matret nanuhanginoa xaung Mesahap nanuhanging ranggina. ");
INSERT INTO met_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Adi li yanamdi dima rangua Iso. Bakbagidingdi xaung titiadingdi disu mana yadingdi. Ding bing: Timna, Alba, Yetet, ");
INSERT INTO met_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO met_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas, Teman, Mipsar, ");
INSERT INTO met_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Makdiel, xaung Iram. Adi li Idomdi yanamidingdi, yadingdi dimogu titiadi duwa mana ba. Ala ba Iso bakbagindi. Idomdi mugangadinga. ");
INSERT INTO met_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yekop rung mana titia Kenan, titia tibuna wa bila lobu mana ba. ");
INSERT INTO met_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yekop bakbaging naxuyanganoa bila li. Yosep gananuna. Bungina nianing 17, wasa mana sipsipdi xaung memedi rangua sabangandi, ding ba garadi mana Bilha Silpa tang, tibuna hainindi. Baing Yosep ma naxuya na tibuna mana sabangandi kuboluding diandi (dilibudi). ");
INSERT INTO met_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isrel murungang sibunoa mana Yosep dali inia mana garang longgalo, namua na hayauxinganoa sok bungina muganga. Binabu tongtongia imang maxaxaya gumangina mana. ");
INSERT INTO met_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Sabangandi dibagu daxabia ba ina naga tibudinga muruna buk mana, dali ding longgalo maxania, baing hauxading sibuna mana saing sanga ba daharua xai na te. ");
INSERT INTO met_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yambong tela Yosep mip (mibingua). Baing bungina naxuya na sabangandi, hauxading buk mana. ");
INSERT INTO met_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Naxuya nadi ba, “Alungu mibingagua (to): ");
INSERT INTO met_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Kira tawa umangia tagoxi wit tambingdi. Ne hatata sibuna li tambingigua mesa mali, saing tambingimdi (dima) digugunia taxiya ngayua saing dituru mari (titia) mana.” ");
INSERT INTO met_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Sabangandi daharua na ba, “Uhatum ba bagula usok xaitamoximama, a? Maxuna uhatum ba bagula uwa etua mam?” Baing ina naga, hauxangadinga mana tubu sibuna, namua na naxuya nadi mana mibinganoa bila ba. ");
INSERT INTO met_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Baing mip mibinga tela muli saing naxuya na sabangandi. Harua ba, “Alungu to. Ngamip mibinga tela muli. Hata sibuna li xaidaba, sobaga xaung hatung 11 dituru mari (titia) manga.” ");
INSERT INTO met_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Naxuya na sabangandi ing ganina te. Naxuya na tibuna xauna. Ne tibuna gamia saing harua ba, “Mibingama na baru? Bagula ngagabu baum xaung sabangamdi am gama am gaturu mari (titia) maxamia, a?” ");
INSERT INTO met_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Sabangandi dibagulinga mana, ne tibuna tuxu axa ba hatumingania. ");
INSERT INTO met_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Tauna, Yosep sabangandi dila Sekem singia bu duwasa mana tibudinga sipsibindi xaung memendi bungina daxangxangia. ");
INSERT INTO met_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Baing Isrel harua na Yosep ba, “Uxabiau, sabangamdi duwasa mua mana sipsipdi xaung memedi bungina daxangxangia Sekem singia. Ngabo ba ngasoxiung mala ranguadi.” Haxuya ba, “Sangau.” ");
INSERT INTO met_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Binabu tibuna harua na ba, “Ula ubagu nabu sabangamdi xaung sipsipdi memedi duwa xai, bo? Sup, baing ugoxoya ma muli ubaxanga nanga.” Baing ina naga, soxi mala. sangua titi gomana wa Hebron. Yosep yunga titi gomana wa Hebron ila sok mana Sekem, ");
INSERT INTO met_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","baing lipu tela bagu haxa hasuxi mana titia ba, saing xusunga ba, “Usaiʼm baraxinta?” ");
INSERT INTO met_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Haxuya ba, “Ngasai mana sabangagudi. Baru yabanta duwasa mana sipsibidinggadi daxangxangia? Sangaʼm ubaxanga nanga?” ");
INSERT INTO met_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Baing lipua harua ba, “Disup mala. Ngalungu daharua ba, ‘Tala Dotan.’” Binabu Yosep su mana sabangandi mala saing bagudi mana longga Dotan singia. ");
INSERT INTO met_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ne dibagu ma hasoya, saing muga mana sok manadi, disai daxanga ba dung mati. ");
INSERT INTO met_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Daharua nading ba, “Bagu lipu mibingama ma lo. ");
INSERT INTO met_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Tala taung mati saing tating sangganoa mari mana lang bangguminadi li tela. Bagula taharua ba, ‘Asaxa abungin tela xang (masup).’ Baing ina naga, bagula tabagu mibingandi aningoding baru!” ");
INSERT INTO met_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben lungu daharua bila ba, ne ina bo ba xap Yosep muli sangua rimadingia. Binabu harua ba, “Taung matiu tai. ");
INSERT INTO met_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Tamatu sibinoa mari titiau tai. Tating mari mana lang banggumina li wa long xoliania, ne labu tahanggalangiau tai.” Ruben harua bila ba bu xap muli sangua rimadingia saing xap mala rangua tibuna muli. ");
INSERT INTO met_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Binabu bungina Yosep sok mana sabangandi, dituxu dunia imanging maxaxaya sangua, imang gumangina sau ba. ");
INSERT INTO met_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Sup, baing daxap mala diting mari lang banggumina. Ne bangguma xola, langin te. ");
INSERT INTO met_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Sup, baing dirung ba daxang. Hata sibuna li dibagu mahaing saing dibagu bakbakka Ismael sogamdi dima hata mana titia Gileat. Kamelidingdi doxoxi tangadi dibaxagi mana guxenga baxiam, xalaxala saminam teladi, xaung xai susuna mer. Dahaxahaxa mari mala Isip ba disinadi. ");
INSERT INTO met_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda harua na sabangandi kixingindi ba, “Nabu taung kixingiroa mati, takau(kau) sibinoa, alaba bagula hauli kira baru? ");
INSERT INTO met_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Xai ba tasina na Ismaeldi siangia. Ne tata rimaradi manau tai. Tahatum to. Kixingiroa, sibira taininau baing.” Baing sabangandi kixingindi dinai mana haruanga li. ");
INSERT INTO met_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Binabu bungina Midia sogamdi dima dibo ba didalidi(uba), sabangandi daxai mahaing sangua lang banggumina, saing disina na Ismaeldi siangia, daxap siang silba 20 mana. Baing Midiadi daxap mala Isip. ");
INSERT INTO met_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Bungina Ruben goxoya ma lang banggumina muli, hixi (mana) namua na bagu Yosep te. Binabu sing imangindi bu hatanga ba hatuminganoa mauxana. ");
INSERT INTO met_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Goxoya mala rangua kixingindi saing harua ba, “Garua wa te! Bagula ngaraxata?” ");
INSERT INTO met_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Baing daxap Yosep imanging maxaxaya, dung meme tela, saing ditai imangua sibia. ");
INSERT INTO met_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Daxap imang gumanginoa mala rangua tibudinga saing daharua ba, “Am gasok mana imangga li. Ubagu xai to. Bola garama imanging maxaxaya.” ");
INSERT INTO met_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Bagu xabia saing harua ba, “Garagu imanging maxaxaya naga! Asaxa abunging tela xang (masup). Maxuna sing(sing) Yosep saha.” ");
INSERT INTO met_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Baing Yekop sing imangindi bu hatanga ayangana buk, saing sau imang usingangamdi saing tangtang mana garanoa xaidap xumana. ");
INSERT INTO met_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Garang lup longgalo xaung nanuhanging longgalo dima bu ditatua atindi, ne hauxana mana ati tatuanganam. Harua ba, “Tegu. Bagula ngatangtang mua laing ngamati ngala rangua matiadi yabadingia.” Binabu tibuna tangtang mua mana. ");
INSERT INTO met_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Bunging taininau mana Isip, Midiadi disina Yosep siangia na Potipar, Isip xaitamoxidinga Pero yanaming tela wa etua mana lipu haungingam(ga)di duwasa mana Pero xaung numanoa. ");
INSERT INTO met_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Bila bungina baguba Yuda sauya sabangandi kixingindi saing ri mala ba wa rangua Adulam tela yanoa Hira. ");
INSERT INTO met_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","La ba Yuda bagu haing (nanung) tela, Kenan tela yanoa Sua nanuhanginoa. Yau saing kinu rangua. ");
INSERT INTO met_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Gamona saing hayau gara lup tela. Baing Yuda uxu yanoa ba Er. ");
INSERT INTO met_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Gamona muli saing hayau gara lup tela, saing uxu yanoa ba Onan. ");
INSERT INTO met_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Hayau gara lup tela muli, saing uxu yanoa ba Sela. Bungina hayau, dirung mana longga Kesip. ");
INSERT INTO met_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Garadi ditubu, baing Yuda xap haing tela (ma)na garang matuaua Er. Yanoa Tamar. ");
INSERT INTO met_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ne Yuda matuaua Er kubolundi didoa sibuna Toxoratamona maxania, binabu Toxoratamona ung mati. ");
INSERT INTO met_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Baing Yuda harua na Onan ba, “Ukinu rangua sabangama haininoa, usu mana bakbagira hanaunaunga ba oxopsaxi garadi mana sabangama bu bakbaginoa sup te, namua na ung bisanoa.” ");
INSERT INTO met_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ne Onan xabia ba garua bagula inia te, binabu bunging bungina kinu rangua sabangang haininoa, yunga langinoa matu (olang) mari titia, nam xapsaxi gara tela mana sabanganoa. ");
INSERT INTO met_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Kubolua libu doa sibuna Toxoratamona maxania, binabu Toxoratamona ung mati xauna. ");
INSERT INTO met_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Baing Yuda harua na longanoa Tamar ba, “Uwa taba baing. Ugoxoya mala tibum numania uwa la ba laing garagua Sela tubu to.” Harua bila ba namua na hatum ba, “Nam ina mati xauna, bila sabangandi.” Binabu Tamar ila wa tibuna numania. ");
INSERT INTO met_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Bunging maxaxaya sup, baing Yuda haininoa mati (Sua nanuhanginoa (baing)). Yuda sinianoa ila sup, baing haing mala mana longga Timna, rangua lipuadi duxuxuya sipsibindi (buxadingdi). Baing rianoa Hira, lipu Adulamgama, gabu mala. ");
INSERT INTO met_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Dibala Tamar ba, “(Bagu) Longama haing (mua) mala mana Timna bu xuxuya sipsibindi (buxadingdi).” ");
INSERT INTO met_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamar bagu xabia ba Sela tubu masup, ne dahamaringia yaungadinga teguyu. Binabu unia imanging tapkamdi, saing saku toxonoa bu yameng ramramonoa bila haing daxangamdi dilibu, saking rung mari longga Enaim xaluxinia, wa mana daxanga ila Timna. ");
INSERT INTO met_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Bungina Yuda bagu, hagaxa ba haing daxangam tela, namua na saku ramramonoa. ");
INSERT INTO met_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Binabu ila rangua daxanga rubinia saing harua ba, “Uma ngabo ba ngakinu ranguaung.” Ne bagu xabia ba longanoa te. Baing hainga xusunga ba, “Ne bagula usina baraxinta nanga bu ngakinu ranguaung?” ");
INSERT INTO met_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Harua ba, “Nga memegudi. Bagula ngasina tutubing tela mala ranguaung.” Baing harua ba, “(Wane.) Nabu usina axamang tela bu mogu haruangama laing usina memea.” ");
INSERT INTO met_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Harua ba, “Bagula ngasina baraxinta naung bu mogu haruangagua?” Haxuya ba, “Raxuma hatanga yama mogunganoa xaung waxunoa, xaung tukia wa rimamia.” Binabu sinadi na saing kinu rangua. Baing gamona. ");
INSERT INTO met_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Baing Tamar mesa ila, saing unia imanga saku toxonoa, sau imanging tapkamdi muli. ");
INSERT INTO met_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Kimuya Yuda sina meme tutubinoa mala lipu Adulama Hira rimania, bu xap haruangang mogunganoa muli sangua hainga. Ne sai(sai) sus(u). ");
INSERT INTO met_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Baing xusunga long moxon(a)di ba, “Haing daxangama waxata mana Kenan sabunga(ding) numanoa wa ba? Rung mana longga Enaim daxanga rubinia.” Ne daharua ba, “Tegu. Haing daxangam tela waxata mana Kenan sabungading numanoa wa la li te.” ");
INSERT INTO met_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Binabu goxoya mala rangua Yuda saing harua ba, “Ngabagu te. Xauna, long moxon(a)di daharua ba, ‘Haing daxangam tela waxata mana Kenan sabunga(ding) numanoa wa la li te.’ ” ");
INSERT INTO met_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Baing Yuda harua ba, “Heku. Axadi ba bing tuxu bila iniadi. Nam dimasisia kitam. Bagu ngasina meme tutubina li na baing, ne usaisai sus.” ");
INSERT INTO met_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Bila sobak tuwa disup, baing dibala Yuda ba, “Longama Tamar libu kubolu miaxuama. Baing ina naga, hatata gamona.” Baing Yuda harua ba, “Axap mala tarama mati!” ");
INSERT INTO met_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ne bungina daxap Tamar mala, sina ulega rangua longanoa harua ba, “Nga gamogu mana axadi bagudi li moxonoa. Ubagu axadi li xai to. Gaxarea raxuna hatanga yang mogunganoa xaung waxunoa xaung tukinoa li? Uxabia?” ");
INSERT INTO met_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda bagu xabiadi saing harua ba, “Xola mana mauxanganoa, ne nga tegu. Namua na ngasina na garagua Sela ba yau te.” Baing Yuda kinu rangua muli te. ");
INSERT INTO met_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Bungina Tema bo ba hayau, bagu haragaragangang lupdi duwa gamonia baing. ");
INSERT INTO met_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Mana bungina hayau, tela ta rimanoa masok. Binabu haing hayauxingama xap waxu sabuxana saing goxi mana rimanoa, saing harua ba, “Gara baguli sok muga.” ");
INSERT INTO met_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ne bungina gara ba xai ramanoa maluxu muli, sabanganoa sok. Baing haingga ba harua ba, “Utu masok muga baru?” Binabu duxu yanoa ba Peres. ");
INSERT INTO met_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Sup, baing sabanganoa sok xaung waxu sabuxanoa wa rimania, saing duxu yanoa ba Sera. ");
INSERT INTO met_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Tauna, Ismaeldi daxai Yosep mala Isip, saing lipu Isipkama Potipar gim. Potipar Isip xaitamoxidinga Pero yanaming tela wa etua mana lipu haungingam(ga)di duwasa mana Pero xaung numanoa. ");
INSERT INTO met_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Toxoratamona wa rangua Yosep, binabu axamandi libudi aningoding xai sibuna, saing wa mana lipuxing haringing numanoa, lipu Isipkama. ");
INSERT INTO met_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Lipuxing haringinoa bagu xabia ba Toxoratamona wa rangua xaung Toxoratamona libu axamang longgalo libudi rimania aningoding xai sibuna, ");
INSERT INTO met_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","baing yaha sibuna mana Yosep saing mogu ba sok lipuxing haulingama. Potipar mogu ba wa etua mana numanoa, saing ta xalinging longgalo rimania bu wasa mana(di). ");
INSERT INTO met_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ungguti bungina ta etua mana numanoa xaung xalinging longgalo saing ila, Toxoratamona sina guxama na lipu Isipkama gabu lipuxing numanamdi, namua na Yosep wa ranguadi. Toxoratamona guxaminganoa wa mana axamang longgalo Potipar iniadi, baraxing baraxinta duwa numia xaung baraxing baraxinta duwa umangia xauna. ");
INSERT INTO met_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Binabu Potipa yunga Yosep (ba) wasa mana xalinging longgalo. Yosep wa etua mana axamandi, binabu hatum xumana mana axamang tela te. Hatum mana anginga baruamta xang ing ganina. Tauna, Yosep sangganoa haringing sibuna saing bagunganoa xai sibuna. ");
INSERT INTO met_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Bunging tela disup, baing lipuxing haringing haininoa maxandi dahaxi mana Yosep saing harua ba, “Uma ukinu rangua nga.” ");
INSERT INTO met_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ning Yosep hauxana. Bala ba, “(Bagu) Lipuxigu haringina mogu nga ba ngawa etua mana xalaxala numanam longgalo. Hatumiadi te. Xalinging longgalo tadi rimagia bu ngawasa mana(di). ");
INSERT INTO met_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ngawa yanam mugamugangama mana numa li. Lipuxigu haringina Soxauti nga mana axamang tela te, ung ganim, namua na ung hainima. Binabu ngalibu doa bila ba baru? Nabu ngalibu bila ba, bing ngalibu kubolu diang sibuna na Urana!” ");
INSERT INTO met_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Xaidap taining tainina xusunga xusunga Yosep, ne hauxana ba kinu rangua. Hauxana ba wa haxek mana xauna. ");
INSERT INTO met_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ne xaidap tela Yosep luxu numia bu tuxu oxatanoa, saing numa lipuxing oxatam tela wa maluxu mana te. ");
INSERT INTO met_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Haingga ba tuxu(ti) Yosep imanginoa saing harua ba, “Uma ukinu rangua nga!” Yosep tataguxa laing hasiana, ne yunga imanginoa rimania bungina giti mala sangua numua. ");
INSERT INTO met_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Bagu Yosep yunga imanginoa rimania bungina giti mala sangua numua, ");
INSERT INTO met_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","baing wagi numang lipuxing oxatamdi saing harua nadi ba, “Abagu! Ayuagu xap Hibru tela ma rangua kira bu daudau kira! Luxu ma haxi ba kinu rangua nga, ne ngaxaba haringina. ");
INSERT INTO met_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Bungina lungu ngaxaba haringina, yunga imanginoa rubigia saing giti mala sangua numua.” ");
INSERT INTO met_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Tabu imanginoa rubinia laing Yosep lipuxing haringinoa goxoya ma numia. ");
INSERT INTO met_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Baing naxuya na bila li: “Hibru oxata olanggama ba oxop ma rangua kira, ma rangua nga bu daudau nga! ");
INSERT INTO met_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ne bungina ngaxaba haringina, yunga imanginoa rubigia saing giti mala sangua numua.” ");
INSERT INTO met_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Yosep lipuxing haringinoa lungu naxuyangua mala, saing haininoa harua na ba, “Lipuxim oxata olanggama libu kubolua na bila ba nanga!” Bungina lungu alaba, atin disala haringina. ");
INSERT INTO met_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Yosep lipuxing haringinoa xap mala saing ta salak yabania, longga dituxu xaitamoxi lipuxing salak yabanamdi mana ba. Baing wa la ba salak yabania. ");
INSERT INTO met_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ne Toxoratamona wa rangua Yosep. Libu xai mana, saing libu salak yabang yananminoa yaha mana. ");
INSERT INTO met_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Binabu salak yabang yanaminoa ta salak yabanam longgalo Yosep rimania. Oxata baruamta sok la ba, ina naga wa etua mana. ");
INSERT INTO met_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Salak yabang yanaminoa hatumia oxata tela wa hawa mana Yosep (rimanoa) te, namua na Toxoratamona wa rangua Yosep, saing oxata baruamta tuxu, Toxoratamona libu aningong xai sibuna. ");
INSERT INTO met_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Bunging tela disup, baing lipu wain guangam mana Isip xaitamoxidinga xaung lipu salanga taungam mana tang dilibu kubolu diana mana lipuxiding haringinoa, Isip xaitamoxidinga. ");
INSERT INTO met_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Xaitamoxia Pero atin disala mana yanaming luwa, lipu waingam mugamugangama xaung lipu salangam mugamugangama, ");
INSERT INTO met_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","saing tabina ba dita dingtang mana salak yabang taininau Yosep wa mana ba, mana numa salak yabanama lipu haungingamdi yanamidinga wasa mana ba. ");
INSERT INTO met_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Lipu haungingamdi yanamidinga mogu Yosep ba wa etua mana dingtang, saing wasa manadi. Duwa salak yabania bunging maxaxaya, ");
INSERT INTO met_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","baing yambong taininau tang dimip la ba mana salak yabanoa duwa mana ba. Lipu waingama mana Isip xaitamoxidinga xaung lipu salangama mana tang dimip, saing mibinga tela ing namuxinoa, saing tela ing namuxinoa. ");
INSERT INTO met_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Buraging buraragina Yosep ma ranguadi, baing bagu (ba) dingtang dahatum xumana. ");
INSERT INTO met_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Binabu xusunga Pero yanamidinggadi duwa salak yabania rangua ba, “Hatata ramramoimdi ayangading baru?” ");
INSERT INTO met_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Tang dahaxuya ba, “Amtam gamip, ne taxola mana lipu tela ba baxanga namuxidingdi nam.” Baing Yosep harua na dingtang ba, “Baxanga mibinga namuxidingdi (bing) Urana oxatanoa. Anaxuya mibingaimdi nanga (to).” ");
INSERT INTO met_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Binabu lipu waingam mugamugangama naxuya mibinganoa na Yosep. Harua na ba, “(Mana) mibingagua ngabagu wain xana maxagia, ");
INSERT INTO met_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","saing xana baguli rimang tuwa. Hata sibuna li londi disok, oxandi disok, saing aningonoa sok saing dimoya. ");
INSERT INTO met_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Pero xubanoa wa rimagia, saing ngaxap wain maran(a)di saing ngayukiyukidi bu langidinga ri Pero xubania, saking ngasina xubua na.” ");
INSERT INTO met_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Baing Yosep harua na ba, “Mibingama namuxinoa bing: xai rimang tuwa (bing) xaidap tuwa. ");
INSERT INTO met_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Xaidap tuwa baing bagula Pero iti toxoma saing taung oxatam yabanoa muli, saing bagula usina Pero xubanoa, bila ulibu muga bungina uwa lipuxing waingama. ");
INSERT INTO met_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ne bungina axamandi duwa xai maung, bing uhatumia nga muli. Ngabo ba ulibu xai manga ba ubaxanga nga na Pero bu yunga nga sangua salak yabana li. ");
INSERT INTO met_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Namua na dahanai nga daxai nga ma sangua Hibrudi titimama baing. La li xauna, ngalibu kubolu diang tela te. Dita nga olang mana salak yabana li.” ");
INSERT INTO met_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Lipu salanga mugamugangama bagu xabia ba Yosep baxanga (mibinga) namuxing xai, baing harua na Yosep ba, “Nga xauna ngamip: hata sibuna li daba tuwa dibaxagi mana salanga duwa riringa toxogia. ");
INSERT INTO met_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Daba etuama baxagi mana salanga xai xangxana bila Pero muruna manadi. Ne mangdi daxangxangdi sangua daba wa toxogia.” ");
INSERT INTO met_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Baing Yosep harua ba, “Mibinga namuxinoa bing: Daba tuwa (bing) xaidap tuwa. ");
INSERT INTO met_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Xaidap tuwa baing bagula Pero iti toxoma—sanguaung baing, saing bagula disu sanggama xaiya dirang mali. Baing mangdi bagula dima daxangxang mututungama.” ");
INSERT INTO met_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tauna, xaidap tuwa baing Pero xaidabing hayauxingama sok, saing tongtongia taunga sabanga mana yanaming longgalo. Iti lipu waingam mugamugangam xaung lipu salanga mugamugangam tang toxodingdi yanamidingdi maxadingia. ");
INSERT INTO met_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ta lipu waingam mugamugangama oxatang yabanoa muli, saing sina Pero xubanoa na muli. ");
INSERT INTO met_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ne (tabina ba di)su lipu salanga mugamugangam sangganoa xaiya (di)rang mali, (taininau) bila Yosep harua na dingtang bungina baxanga (mibingading) namuxidingdi na dingtang. ");
INSERT INTO met_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ning lipu waingam mugamugangama hatumia Yosep muli te. Halingalinga. ");
INSERT INTO met_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Niani luwa disup baing xaitamoxi Pero mip mibinga bila li: Li Langga Nail rubinia. ");
INSERT INTO met_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Hata sibuna li bulmakau 7 disok sangua langga. Bagungadingdi daxai (sibuna) xaung dungmanangading. Baing daxang tatubanga(di) (du)(wa) lang rubinia. ");
INSERT INTO met_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Hata sibuna li bulmakau 7 teladi disok sangua Nail kimuya manadi. Bagungadingdi didoa (sibuna) xaung toatuading. Baing dila dili haxek mana bulmakau dungmanangandi lang rubinia. ");
INSERT INTO met_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Baing bulmakaudi bagungadingdi didoa xaung toatuading daxang bulmakaudi bagungadingdi daxai xaung dungmanangading 7 masup ba! Saking Pero baguti (muli). ");
INSERT INTO met_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Kinu muli, saing mip muli bila li: Hata sibuna li wit marang 7 disok mana wit tuang taininau. Daxai xaung ditubu. ");
INSERT INTO met_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Hata sibuna li wit marang 7 teladi dahaxa kimuya manadi. Toatuading xaung yang karagam salianoa libudi dimutuxu. ");
INSERT INTO met_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Baing wit marang toatuadingdi dingaru masup wit marandi daxai xaung ditubu. Saking Pero baguti (muli). Baing bagu xabia ba mibingua. ");
INSERT INTO met_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Buraragina baing hatum xumana, binabu wagi Isip lipuxing sintukkam longgalo xaung Isip lipuxing xabianga maringinam longgalo dima. Pero baxanga mibinganoa nadi, ne tela sanga ba baxanga namuxinoa na te. ");
INSERT INTO met_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Baing lipu waing guanga mugamugangama harua na Pero ba, “Hatata ngahatumia muli mauxangan tela ngalibu. ");
INSERT INTO met_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Waleu atim disala mamtam lipuxim oxatamdi, saing uta nga salak yabania xaung lipu salanga taunga mugamugangama. Tam gawa la ba hawa mana lipu haungingamdi yanamidinga rimanoa. ");
INSERT INTO met_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Yambong taininau tam gamip (tela tela). Baing mibingang namuxing tela, saing ngayua tela. ");
INSERT INTO met_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ne Hibru gananung tela wa la ba ranguamtam. Lipu oxatama mana lipu haungingamdi yanamidinga. Tam ganaxuya mibingamamdi na, saing baxanga mibingadi namuxiding taining tainina namtam. ");
INSERT INTO met_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Baing axamandi disok maxung sibuna bila baxanga namtam ba. Ngaxap muli yabagu oxatama, saing lipu tela disu sangganoa xaiya dirang mali.” ");
INSERT INTO met_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Binabu Pero wagi Yosep ma, saing daxap sap masok sangua salak yabanoa. Gasi laing sup, baing sau imang xaidi saing luxu ma li Pero maxania. ");
INSERT INTO met_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pero harua na Yosep ba, “Ngamip, ne lipu tela sanga ba baxanga namuxinoa te. Ning ngalungudi dinaxuya maung ba, daharua ba bungina ulungu mibinga, bing sanga ba ubaxanga namuxinoa.” ");
INSERT INTO met_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ne Yosep haxuya na Pero ba, “Nga sanga te. Ning Urana bagula baxanga namuxinoa bu hatumingama maxana.” ");
INSERT INTO met_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Baing xaitamoxia harua na Yosep ba, “Mana mibingagua ngali Langga Nail rubinia. ");
INSERT INTO met_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Hata sibuna li bulmakau 7 disok sangua langga. Dungmanangading xaung bagungadingdi daxai (sibuna). Baing daxang tatubanga(di) (du)(wa) lang rubinia. ");
INSERT INTO met_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Bulmakau 7 teladi disok kimuya manadi. Daxabati, bagungadingdi didoa (sibuna) xaung toatuading. Mana Isip long longgalo ngabagu bulmakau doyandi (na) bila ba te. ");
INSERT INTO met_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Baing bulmakau toatuanadi bagungadingdi didoa ba daxang masup bulmakau dungmanangan 7 disok muga ba. ");
INSERT INTO met_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Daxang masup, ne bagu gamodingdi bila daxang teguyu. Tegu. Bagungadingdi didoa bila muga baing. Saking ngabaguti (muli). ");
INSERT INTO met_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Mibinga tela baing ngabagu wit marang 7 disok mana wit tuang taininau. Ditubu xaung daxai. ");
INSERT INTO met_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Wit marang 7 teladi dahaxa kimuya manadi. Daxabati, toatuading xaung yang karagam salianoa libudi dimutuxu. ");
INSERT INTO met_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Baing wit marang toatuadingdi dingaru masup wit marandi daxai. Ngabaxanga mibingadi li na lipu sintukkamdi, ne tela sanga ba baxanga namuxinoa nanga te.” ");
INSERT INTO met_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Baing Yosep harua na Pero ba, “Mibingamdi tang (namuxiding) taininau. Urana hatanga naung axamanoa bo ba libu(ba). ");
INSERT INTO met_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bulmakau xai 7 (bing) niani 7, xaung wit marang xai 7 (bing) niani 7. Mibingamdi tang (namuxiding) taininau. ");
INSERT INTO met_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Bulmakau toatuang 7 bagudingdi didoa ba disok kimuya (bing) niani 7. Wit marang 7 doxola xaung yang karagam salianoa libudi dimutuxu ba, bila balau xauna. (Ding/Tang) Gesak sabanga 7. ");
INSERT INTO met_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Bila ngabalaung baing. Urana hatanga naung axamanoa bo ba libu(ba). ");
INSERT INTO met_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","(Bagu) Niani 7 dimau bagula anginga baxagi sibuna maluxuʼm titia Isip. ");
INSERT INTO met_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ne gesak sabanga niani 7 bagula dima kimu manadi. Baing niani anginga baxagingamdi bagula dahanggalang mana Isipdi hatumingadinga. Gesak sabangua bagula hanggalangia titia. ");
INSERT INTO met_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Bagula dahatumia muli niani anginga baxagingamdi te, namua na gesak sabangua ma kimu mana ba bagula doa sibuna. ");
INSERT INTO met_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Namua mibingama xibua bing Urana hau hatuminganoa haringina mana ba, saing Urana bagula libu sok sap. ");
INSERT INTO met_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Baing ina naga, xai ba usai mana lipu tela hatuminganoa maxaya xaung xabianganoa maring, saing uta etua mana titia Isip. ");
INSERT INTO met_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Xai ba umogu yanamdi duwasa mana Isip titing longgalo, bu daxap hataina luwadi luwadi hiliadinga mana Isip xauyanganoa mana niani anginga xumanam 7. ");
INSERT INTO met_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Baing xai ba daxap anginga niani xaiyamgadi li dimayu, saing duwaxata hawa maung bu dahaxuru mana long sabanggadi bu bagula anginga wa. Xai ba duwasa xai mana. ");
INSERT INTO met_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Anginga ba bagula saxangiangua mana titia, bu sanga ba lipudi daxang bungina gesak sabanga niani 7 xap Isip, nam gesak sabangua hanggalangia titia.” ");
INSERT INTO met_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Pero xaung yanamindi dilungu haruanga baguba saing xai maxadingia. ");
INSERT INTO met_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Baing Pero harua nadi ba, “Aningoningo mana uranadi wa mana lipua li. Bagula tabagu lipu tela muli bila li bu tuxu oxata li te.” ");
INSERT INTO met_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Baing Pero harua na Yosep ba, “Urana hatanga axamanadi li masok naung, binabu lipu tela hatuminganoa maxaya xaung xabianganoa maring bila ung te. ");
INSERT INTO met_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Bagula uwa yanama etua mana numagua, saing lipuxigu longgalo bagula duwa hawa mana haruangama. Nga xaitamoxia ganigu bagula ngawa etua maung.” ");
INSERT INTO met_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Saking Pero harua na Yosep ba, “Ulungu to. Hatata ngataung etua mana Isip titing longgalo.” ");
INSERT INTO met_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Baing Pero unia rimang uxung raxunoa hatanga yang mogunganoa saing sau mana Yosep rimang uxunoa. Baing yauyau Yosep mana imang xai sibuna, saing hing gimunggimung gol waxungtuania. ");
INSERT INTO met_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Baing bala Yosep ba rung etua mana wilka mogu mana lipuxing luwama. Lipudi dimuga mana saing duwagi ba, “Ahayaʼm daxangua!” Bila balau Pero ta Yosep etua mana Isip titing longgalo. ");
INSERT INTO met_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Baing Pero harua na Yosep ba, “Nga xaitamoxia Pero. Ne labu lipu tela wa Isip libu axamang tela olanggu tai. Unai mana to.” ");
INSERT INTO met_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Baing Pero sina yaya Sapenat-Panea na Yosep, saing sina haing tela na Yosep, yanoa Asenat. Tibuna Potipera, lipu hananiangam mana long sabangga On. Baing Yosep ila ma wa etua mana titia Isip. ");
INSERT INTO met_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yosep nianindi 30 bungina ungguti ba tuxu oxatua mana Pero xaitamoxia mana Isip. Baing Yosep sok mala sangua Pero saing haxa mauli mana Isip hataing longgalo. ");
INSERT INTO met_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Mana niani anginga xumanam 7 titia aningong xumana. ");
INSERT INTO met_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Baing mana nianidi bagudi ba disok mana titia Isip, Yosep gung anginga(di) saing ta(di) mana long sabangadi. Mana long sabanga taining tainina ta angingadi dahaing mana umangadi duwa singia. ");
INSERT INTO met_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Angingadi Yosep gungdi xumang sibuna bila ulangulang(di) (du)wa tegia, laing sauya titinga buninganoa, namua na titingua tubu buk. ");
INSERT INTO met_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Niani gesakkamdi disok teguyu, baing Yosep haininoa Asenat hayau gara lup luwa na. Asenat tibuna Potipera, lipu hananiangam mana long sabangga On. ");
INSERT INTO met_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Baing Yosep uxu matuaua yanoa Manase, saing harua ba, “Namua na Urana libu ngahalingalinga mauxangagudi xaung tibugu bakbagindi.” ");
INSERT INTO met_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Gara lup luwa yanoa Yosep uxu ba Epraim, saing harua ba, “Namua na Urana libu ngaxapsaxi mana titia ngaxap mauxanganoa mana ba.” ");
INSERT INTO met_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Isip nianing anginga baxagingam 7 disup, ");
INSERT INTO met_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","baing niani gesakkam 7 dungguti bila Yosep harua ba. Gesak sabangua sok mana titi longgalo, ne mana titia Isip anginga wa(u). ");
INSERT INTO met_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Bungina Isip longgalo duxunumia gesaga xapdi, lipuadi ditang rangua Pero ba uliadi anginga. Baing Pero harua na Isip longgalo ba, “Ala rangua Yosep. Alibu baraxinta balang mana ba.” ");
INSERT INTO met_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Bungina gesaga xap Isip titing longgalo, Yosep xaxa anginga numandi saing sina anginga siangia na Isipdi, namua na gesaga doa sibuna mana Isip titing longgalo. ");
INSERT INTO met_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Baing ina naga, numanuma longgalo dima mana Isip rangua Yosep bu digim anginga, namua na gesaga doa sibuna mana titi hataing longgalo. ");
INSERT INTO met_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Bungina Yekop lungu ba angingadi duwa Isip bu lipudi digim, harua na garandi ba, “Baruta arung olang abaguam mua? ");
INSERT INTO met_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ngalungu ba angingadi duwa mana Isip. Ari mala agim teladi nakira, bu tawa nam tamati.” ");
INSERT INTO met_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Baing Yosep sabangang 10 diri mala mana Isip bu digim wit. ");
INSERT INTO met_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ne Yekop soxi Yosep kixinginoa Benyamin mala ranguadi te, namua na maxuwa. Nam mauxanganoa xap. ");
INSERT INTO met_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Binabu Isrel garandi xauna duwa rangua adi dila Isip bu digim wit, namua na gesak sabangua xap titia Kenan xauna. ");
INSERT INTO met_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Tauna, Yosep wa gabana mana Isip, lipua sina wit na Isip longgalo. Binabu, bungina Yosep sabangandi disok, digung kiding tuxundi dituru mari titia. ");
INSERT INTO met_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yosep bagu sabangandi, saing hata sibuna li bagu xabiadi. Ne gau ba xabiadi te saing harua haringina nadi, xusungadi ba, “Ama bi?” Dahaxuya ba, “Am gama Kenan ma. Am gabo ba am gagim anginga.” ");
INSERT INTO met_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yosep bagu xabai sabangandi, ne (ding ba) dibagu daxabia (ina) te. ");
INSERT INTO met_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Baing Yosep hatumia muli mibingan(a)di mipdi manadi. Baing harua nadi ba, “Ang lipu bagubagungamdi! Ama bu asaiʼm titimam hataing baruamtadi duwa olang.” ");
INSERT INTO met_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Baing dahaxuyu ba, “Lipu(ximam) sabanga, tegu. Am lipuxim oxatamdi am gama ba am gagim anginga. ");
INSERT INTO met_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Am longga(lo) lipu taininau garandi. Am lipuxim oxatamdi am lipu haruanga maxunamdi. Am lipu bagubagungamdi te.” ");
INSERT INTO met_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ne harua nadi ba, “Tegu! Ama bu asaiʼm titimam hataing baruamtadi duwa olang.” ");
INSERT INTO met_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Baing daharua ba, “Am lipuximam oxatamdi am neng sabangang 12, lipu taininau garandi, wa titia Kenan. Kixingimama hatata wa rangua tibumam, saing tela hanggalang.” ");
INSERT INTO met_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ne Yosep haxi ba, “Bila ngabalang ba: ang lipu bagubagungamdi! ");
INSERT INTO met_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Bagula ngatubang bila li: Ngaharua maxung sibuna mana Pero yania, kixingima bing ma la li to. Nabu tegu, bing sanga ba asauya titia li te. ");
INSERT INTO met_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Asoxi angia tela mala bu xap kixingima ma. Ne ang teladi bagula awa salak yabania, bu ngatuba haruangaima, ngabagu ba aharua maxuna kimbo tegu. Nabu tegu, bing ngahau haruangua maxung sibuna Pero yania, ang lipu bagubagungamdi baing!” ");
INSERT INTO met_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Baing tadi salak yabania (laing/mana) xaidap luwa hiliana. ");
INSERT INTO met_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Xaidap luwa hiliana sok, baing Yosep harua nadi ba, “Ngawa hawa mana Urana. Binabu alibu bila li saing bagula (ngayunga) awa: ");
INSERT INTO met_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","nabu ang lipu haruanga maxunamdi, angia tela wauyu salak yabania li awa mana ba, saing angia teladi ba, ala saing axap wit mala rangua bakbakgimdi gesagiding sibuna. ");
INSERT INTO met_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ning axap kixingima ma rangua nga, bu ahatanga ba haruangaima maxuna, xaung bu bagula amati te.” Baing dinai mana haruanganoa. ");
INSERT INTO met_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Baing daharua nading ba, “Maxung sibuna taxap salaga mana kubolua talibu mana kixingiroa. Tabagu hatuminganoa mauxana baru bungina xusunga kira haringina ba tausi (mana), ne talungu te. Namua naga mauxangana li xap kira.” ");
INSERT INTO met_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Baing Ruben haxuya ba, “Ngabalang ba labu alibu kubolu diana na garuau tai. Maxuna? Ne alungu nga te. Bagu baing! Hatata sibing haxuyanganoa sok!” ");
INSERT INTO met_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Daharua xuadinga saing dahagaxa ba Yosep lungudi te. Dahagaxa bila ba namua na lipu (haruanga xugiangam) tela wa liwe mading xugia haruangua. ");
INSERT INTO met_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Baing Yosep xugia mala sanguadi saing ungguti tang. Sup, baing goxoya ma saing harua nadi muli. Baing bala lipuxing oxatamdi ba dituxu Simion, saing digoxi maxadingia. ");
INSERT INTO met_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yosep tabina lipuxing oxatamdi ba digam tangadingdi mana wit, xaung ba dita lipu taining tainina sianginoa maluxuʼm tangania, xaung ba disina anginga nadi mana haxangadinga. Baing dilibu bila ba. Laing sup, ");
INSERT INTO met_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","baing sabangandi dita witdi mahaing donkidingia saing dila. ");
INSERT INTO met_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Dila disok mana long tela ditongtongia tabalaxaya ba dikinu, baing dingia tela xaxa tanganoa ba xap anginga bu haxang donkinoa. Baing bagu sianginoa wa tanga xuania baing. ");
INSERT INTO met_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Harua na sabangandi kixingindi ba, “Abagu! Dahaxuya siangigua. Wa tangagia li!” Dilungu alaba baing aningodingdi dila baing. Dilulu, duxugia ranguading saing daharua ba, “Urana raxata makira?” ");
INSERT INTO met_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Bungina disok rangua tibudinga Yekop mana titia Kenan, dibaxanga axamang longgalo disok manadi na. Daharua ba, ");
INSERT INTO met_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Yanam sabangua wa etua mana titi ba, harua haringina nam, saing su haruangua nam bila am gabagubagu titia. ");
INSERT INTO met_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ne am gaharua na ba, ‘Am lipu haruanga maxunamdi. Am lipu bagubagungamdi te. ");
INSERT INTO met_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Am neng sabangang 12, lipu taininau garandi. Tela hanggalang, saing kixingimama hatata wa rangua tibumam mana titia Kenan.’ ");
INSERT INTO met_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Baing lipua wa yanam sabangua etua mana titia ba harua nam ba, ‘Bagula ngaxabia ba ang lipu haruanga maxunamdi bila li: Angia tela wauyu la li rangua nga, saing axap anginga mana bakbagimdi gesagiding sibuna saing ala. ");
INSERT INTO met_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ning axap kixingima ma rangua nga, bu sanga ba ngaxabia ba ang lipu bagubungamdi te, ne ang lipu haruanga maxunamdi. Baing ina naga, bagula ngayunga sabangam tela mala ranguang muli, saing sanga ba ahakhaxuya mana titia li.’ ” ");
INSERT INTO met_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Bungina dimatu tangadingdi mari, laku, lipu taining tainina siangin(di) (du)wa (la ba) maluxuʼm tanganoa baing! Baing bungina ding digabu tibuding dibagu siangidingdi, dimaxuwa sibuna. ");
INSERT INTO met_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Tibudinga Yekop harua nadi ba, “Ang galibu garagudi dahanggalang! Yosep sup! Simion sup! Baing hatata abo ba axap Benyamin mala sangua nga xauna. Axadi bagudili duxukxugia manga!” ");
INSERT INTO met_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Baing Ruben harua na tibuna ba, “Nabu ngaxap ma muli ranguaung te, bing sanga ba ung garagu lup tang. Uta rimagia bu ngawasa mana, saing bagula ngaxap ma muli ranguaung.” ");
INSERT INTO met_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ne Yekop harua ba, “Tegu sibuna. Bagula garagua ri mala la ba ranguang te. Sabanganoa mati (ba) saing ing ganina wa. Toxogulondi dusa baing. Nabu xap doa haxangaimia, bagula alibu ayangagu buk (bu) ngari mala matiadi yabadingia.” ");
INSERT INTO met_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Tauna, gesaga doauyu mana titia Kenan. ");
INSERT INTO met_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Daxang wit Isrel garanadi daxap mana Isip masup, baing tibudinga harua nadi ba, “Agoxoya mala muli saing agim anginga muli nakira.” ");
INSERT INTO met_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ne Yuda harua na ba, “Lipua balam haringina ba, ‘Nabu kixingima ma ranguang te, bing sanga ba abagu ramramogua muli te.’ ");
INSERT INTO met_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Nabu unai ba usoxi kixingimama (mala) ranguam, bing bagula am gari mala am gagim anginga naung. ");
INSERT INTO met_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ne nabu unai te bagula am gari mala te, namua na lipua harua nam ba, ‘Nabu kixingima ma ranguang te, bing sanga ba abagu ramramogua muli te.’ ” ");
INSERT INTO met_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Isrel harua ba, “Baruta axap mauxangana li manga mana abaxanga na lipua ba kixingim tela wau?” ");
INSERT INTO met_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Dahaxuya ba, “Lipua xusunga xusungam mam xaung bakbakgimama. Xusungam ba, ‘Tibuim wauyu? Kixingim tela?’ Binabu am gahaxuya xusungangandi. Si, bungina harua ba am gaxap kixingimama mari xauna, sanga ba am gaxabia bagula harua bila ba baru?” ");
INSERT INTO met_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Baing Yuda harua na tibuna Isrel ba, “Usoxi gananunoa mala rangua nga, saing bagula am gamesa am gala, bu kira tagabu garamamdi tawa nam tamati mana gesaga. ");
INSERT INTO met_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ngahau haruangua ba nga sibugu bagula ngawasa mana. Usu haruangua nanga nabu ngasu mana haruangagua te. Nabu ngaxap ma ranguaung muli ngata maxamia te, bagula mauxanganoa taga manga bungingbunginalo. ");
INSERT INTO met_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nabu nulana tahalisi te, sanga ba am gala am gama bunging luwa masup.” ");
INSERT INTO met_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Baing tibudinga Isrel harua nadi ba, “Nabu daxanga tela te, bing alibu bila li: Agam tangaimdi mana anginga xai sibundi mana titia li, saing axapdi mari asinadi na lipua bila yahangua. Axap axadi bagudili: guxenga baxiam, dungungu langina, xalaxala saminam teladi, xai susuna mer, talia xaung xai marana duxu ba pistasio. ");
INSERT INTO met_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Axibua siangadi (nulana) dita mana tangaimdi xuadinga ba, axap mala. Tela giminakkam, tela haxuyangam bu ahaxuya siangidinga. Bola dituxurara. ");
INSERT INTO met_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Axap kixingima xauna, saing amesa sap ala rangua lipua ba muli. ");
INSERT INTO met_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ngaxusunga Urana Haringing Sibuna ba libu axap usingangua rangua lipua ba, bu bagula yunga sabangaima (gabu) Benyamin tang digoxoya ma ranguang. Ne nga ba, nabu garagudi dahanggalang, bing bagula dahanggalang.” ");
INSERT INTO met_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Binabu lipuadi daxap yahangadi xaung siangadi dixibuadi, xaung Benyamin xauna. Baing dimesa sap diri mala Isip, saing dila dili Yosep maxania. ");
INSERT INTO met_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Bungina Yosep bagu Benyamin ma ranguadi, harua na lipuxing numang wasanganama ba, “Oxop lipuadi li mala numagia. Ututu bulmakau tela saing uxauxau taungua. Namua na bagula daxang rangua nga xaidap lia.” ");
INSERT INTO met_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Lipua libu bila Yosep bala ba saing xapdi mala Yosep numania. ");
INSERT INTO met_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ne dimaxuwa bungina dibagu (ba) xapdi mala Yosep numania. Dahatum ba, “Bola namua daxap kira ma la li bing sianga dita muli maluxuʼm tangamamdi nulana. Bo ba wasaso kira saing tuxu kira bu (libu) tasok lipuxing oxata olanggamdi, saing xap donkiradi xauna.” ");
INSERT INTO met_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Binabu dila rangua Yosep lipuxing numang wasanganama saing daharua na numa xuania. ");
INSERT INTO met_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Daharua ba, “Lipuximam sabanga, sanga ba am gaharua ranguaung? Nulana am gari ma bu am gagim anginga. ");
INSERT INTO met_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ne mana longga am gatongtongia tabalaxaya mana ba, am gaxaxa tangamamdi saing am taining tainina am gabagu siangamamdi mana tangamamdi xuadingia—taxa mana giminaginoa baing! Binabu am gaxap ma muli ranguam. ");
INSERT INTO met_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Xauna am gaxap siang teladi muli ranguam bu am gagim anginga. Am gaxabia gaxarea ta siangiroa maluxuʼm tangamamdi te.” ");
INSERT INTO met_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Haxuya ba, “Awa mosiu. Labu amaxuwau tai. Urana angia, Urana mana tibuim, ta siangadi ba maluxuʼm tangaimdi. Bila axap xalaxala hisangamdi. Siangima ngaxap baing.” Baing xap Simion ma ranguadi. ");
INSERT INTO met_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Lipu numa wasanganama xap lipuadi maluxu Yosep numania, sina langa nadi bu didamia kidingdi, saing haxang donkidingdi. ");
INSERT INTO met_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Daxauxau yahangadingdi mana bungina Yosep bagula sok xaidap lia, namua na dilungu ba bagula daxang la ba. ");
INSERT INTO met_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yosep ma numia, baing disina yahangadi daxapdi ma numia na, saing . Baing digung kiding tuxundi dituru mari titia maxania. ");
INSERT INTO met_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Baing Yosep xusungadi mana rungingadinga, saing xusungadi ba, “Tibuim, duanga abala nga mana ba, wauyu?” ");
INSERT INTO met_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Dahaxuya ba, “Lipuxim oxatama tibumam wa xaiyu.” Baing duwa hawa mana binabu dituru mari titia muli na. ");
INSERT INTO met_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Bungina bagu mauli, bagu kixinginoa Benyamin, tang bauding taininau, baing xusunga ba, “Kixingim sibunoa li, gananuna abala nga mana ba?” Baing harua ba, “Garagua, ngaxusunga Urana ba atin dimoti maung.” ");
INSERT INTO met_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Baing Yosep atina mana kixinginoa buk, bo ba tangguba, binabu sok mala sap. Baing luxuʼm numang lung tela saing tang la ba. ");
INSERT INTO met_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Sup, baing damia ramramonoa saing haringia hatuminganoa muli. Goxoya ma, saing harua ba, “Asu aningadi.” ");
INSERT INTO met_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Disu Yosep angiandi mana ing sibung kabukabunoa, disu sabangandi angiadinga mana tela, saing Isipkadi daxang rangua Yosep dirung halianga, namua na Isipdi daxang rangua Hibrudi te. Urana dingiadi bilidi. ");
INSERT INTO met_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Bungina Yosep sabangandi dirung maxania mana yabadingdi lipuxing oxatamdi dimogu manadi, dihixi mana dibagu mading, namua na dibagu daxabia ba rungingadinga su mana hayauxingadingdi, matuaua ila sup mana nanunoa. ");
INSERT INTO met_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Daxap angiadinga Yosep kabukabunoa disu nadi, baing Benyamin angianoa dali dingiadi bila luwadi luwadi hiliadinga. Baing ina naga, diyaha sibuna rangua Yosep saing dinung wain laing sanga mading. ");
INSERT INTO met_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Sup, baing Yosep tabina lipuxing numang wasanganama ba, “Ugamgam anginga mana lipuadi tangadingdi laing dibaxagi sibuna, saing uta taining tainina sianginoa muli tangang xuania. ");
INSERT INTO met_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Saking uta xubagua, xuba silba baing, nanunoa tangang xuania xaung angiang sianging giminakkamdi.” Baing libu bila Yosep bala ba. ");
INSERT INTO met_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Longa usianam, baing disoxi lipuadi mala xaung donkidingdi. ");
INSERT INTO met_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Disok mala sangua long sabangga, dila hasoya (buk) te, baing Yosep harua na lipuxing numang wasanganama ba, “Umesa usu mana lipuadi ba. Bungina usok manadi bing uxusungadi ba, ‘Ahaxuya kubolumam xaiyua xaung kubolu diana (nam) baru? ");
INSERT INTO met_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Xuba naga yanamigua nung mana, xaung tuxu tuak mana, a? Kuboluima diang sibuna!’ ” ");
INSERT INTO met_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ila sok manadi, baing baxanga haruanga li nadi. ");
INSERT INTO met_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ne daharua na ba, “Lipuximam sabanga, uharua haruanga na bila ba baru? Am lipuxim oxatamdi sanga ba am galibu axamang tela bila ba te! ");
INSERT INTO met_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Si! Uxabia ba sianga(di) (du)wa tangamamdi xuadingia am gaxap(di) titia Kenan ma muli. Binabu baruta bagula am gahanai silba kimbo gol mana yanamim(a) numania? ");
INSERT INTO met_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Lipuxim oxatam baruamta ubagu tuxu xuba ba, bing mati. Baing amia teladi bagula am gasok lipuxim oxata olanggamdi.” ");
INSERT INTO met_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Haxuya ba, “Sangau. Bila aharua ba. Ne lipu gaxarea ngabagu tuxu ba bagula sok lipuxigu oxata olanggama. Ang teladi axola mana mauxanganoa, binabu sanga ba ala.” ");
INSERT INTO met_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Baing diyungia sap tangadingdi mari titia, saing daxaxadi. ");
INSERT INTO met_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Baing sai mana, ungguti mana sabangadinga laing sup mana kixingidinga. Baing ina naga, bagu xubua Benyamin tangania. ");
INSERT INTO met_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Dibagu baing dising imangidingdi bu dahatanga dusi sibuna. Baing dita tangadingdi mahaing muli mana donkidingdi saing digoxoya mala muli long sabangia. ");
INSERT INTO met_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yosep wauyu numia bungina Yuda gabu sabangandi kixingindi diluxu ma, saing hata sibuna li digung kiding tuxundi dituru mari titia maxania. ");
INSERT INTO met_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yosep harua nadi ba, “Alibu baru kubolunta (li)? Lipua na bila nga ba sanga ba ngatuxu tuak baing. Axabia alaba te?” ");
INSERT INTO met_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda haxuya ba, “Lipuximam sabanga, am haruanga te. Bagula am gahatanga ba am gaxola mana mauxanganoa baru? Urana hatanga lipuxim oxatamdi mauxangadinga sabasabia. Lipuximam sabanga, bagu bagula am longgalo am gasok lipuxim oxata olanggamdi, am xaung lipua dibagu xubua mana tanganoa ba.” ");
INSERT INTO met_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ne Yosep harua ba, “Tegu. Sanga ba ngalibu bila ba te. Lipua dibagu tuxu xubua ing ganina bagula sok lipuxigu oxata olanggama. Ang teladi sanga ba agoxoya mala rangua tibuim xaung gamogamu mosiu.” ");
INSERT INTO met_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Baing Yuda ila haxek rangua saing harua ba, “Lipuxigu sabanga, ngausinga ngatautitiung, ne ngaxusungaung ba ulungu haruangagua to. Maxuna uwa hasusu mana Pero (ing sibuna), ne nga, lipuxim oxatama, ngaxusungaung ba atim disala manga te. ");
INSERT INTO met_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Lipuxigu sabanga, muga uxusungam lipuxim oxatamdi ba, ‘Ang tibuima kimbo kixingima?’ ");
INSERT INTO met_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Baing am gahaxuya ba, ‘Am tibumam ne wa duanga ba, xaung kixingimam, bauna hayau na tibumam bungina wa duanga. Nanunauyu. Bauna hayau luwa, ne sabanganoa mati ba. Ing ganina wau(yu). Baing tibuna muruna buk mana.’ ");
INSERT INTO met_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Baing uharua nam lipuxim oxatamdi ba, ‘Axap mari manga bu nga sibugu ngabagu.’ ");
INSERT INTO met_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Baing am gahaxuyaung lipuximam sabanga ba, ‘Gananunoa sanga ba sauya tibuna te. Nabu sauya, bagula tibuna mati.’ ");
INSERT INTO met_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ne ubalam lipuxim oxatamdi ba, ‘Nabu kixingima ri ma ranguang te, bing sanga ba abagu ramramogua muli te.’ ");
INSERT INTO met_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Bungina am gagoxoya mala rangua tibumam lipuxim oxatama, am ga baxanga haruangama na. ");
INSERT INTO met_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Baing tibumam harua ba, ‘Agoxoya mala muli saing agim anginga muli nakira. ");
INSERT INTO met_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ne am gaharua ba, ‘Sanga ba am gari mala te. Nabu unai ba usoxi kixingimama (mala) ranguam, bing bagula am gala. Nabu kixingimama wa ranguam te, bing sanga ba am gabagu lipua ramramonoa muli te.’ ");
INSERT INTO met_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Baing tibumam lipuxim oxatama harua nam ba, ‘Ang gaxabia ba hainigua hayau gara luwa nanga. ");
INSERT INTO met_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Tela hanggalang ba, saing ngaharua ba, “Maxuna asaxa abunging tela sing(sing) saha.” Baing ngabagu muli te. ");
INSERT INTO met_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Toxogulondi dusa baing. Nabu axap gananuna li sangua nga xauna saing xap doa, bagula alibu ayangagu buk (bu) ngari mala matiadi yabadingia.’ ");
INSERT INTO met_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Baing ina naga, nabu ngagoxoya mala rangua tibugu lipuxim oxatama saing gananunoa wa ranguam te. Tibugu walinganoa taga mana gananunoa walinganoa baing. ");
INSERT INTO met_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Bungina bagu gananunoa wa ranguam te, bagula mati. Toxolondi dusa baing. Am lipuxim oxatamdi bagula am galibu ayangana buk (bu) ri mala matiadi yabadingia. ");
INSERT INTO met_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Nga lipuxim oxatama ngahau haruangua ba ngawasa mana gananunoa. Ngaharua ba, ‘Tibugu, nabu ngaxap ma ranguaung muli te, bagula mauxanganoa taga manga maxamia bungingbunginalo!’ ");
INSERT INTO met_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Baing ina nga, lipuxigu sabanga, ngaxusungaung ba unai mana nga lipuxim oxatama ngaxap gananuna yabanoa, binabu ngawa lipuxim oxata olanggama la li. Baing unai mana gananunoa goxoya mala muli rangua sabangandi. ");
INSERT INTO met_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Nabu gananunoa wa rangua nga te, bagula ngagoxoya mala muli rangua tibugu baru? Tegu! Nam ngabagu salaga xap tibugua.” ");
INSERT INTO met_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yosep tuba ba haringia hatuminganoa lipuxing oxatamdi maxadingia susu. Baing harua haringina ba, “Ang longgalo asok sabasabia!” Binabu ing ganina wa rangua sabangandi bungina hatangaina masok nadi. ");
INSERT INTO met_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Baing tang sabanga buk sanga mana Isipdi dilungu, saing adi duwa Pero numania dilungu mana xauna. ");
INSERT INTO met_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Baing Yosep harua na kixingindi ba, “Nga Yosep naga! Tibugu wauyu?” Ne sabangandi sanga ba dahaxuya te, namua na dimaxuwa buk (mana) li la ba maxadingia. ");
INSERT INTO met_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Baing Yosep harua na sabangandi ba, “Ama haxek rangua nga.” Dila haxek, baing harua ba, “Nga kixingima naga, Yosep, kixingima asina siangia bila lipu oxata olanggama mala Isip. ");
INSERT INTO met_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ne hatata labu gamoimdi mauxading kimbo atim disala mang mana asina nga siangia la li, namua na Urana soxi nga muga mang bu ngasoxauti matiyua mana xap lipudi. ");
INSERT INTO met_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Namua na gesak sabanga xap titia niani luwa li masup, saing niani luwadi luwadi hiliadinga dimayu bagula lipudi duxuma daxauya te. ");
INSERT INTO met_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ne Urana soxi nga muga mang bu libu bakbakgim hataina (bagula) duwauyu etuaʼm titia li, xaung bu angia xumana amati te. ");
INSERT INTO met_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Baing ina naga, ang ba asoxi nga ma la li te. Tegu. Urana baing. Libu nga ngasina haruangua na Pero bila ngawa tibuna. Baing libu ngasok Pero numang yanaminoa xaung ngawa etua mana Isip hataing longgalo. ");
INSERT INTO met_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Binabu agogolinga mala mahaing rangua tibugu saing aharua na ba, ‘Garama Yosep harua bila li: Urana libu nga ngawa etua mana Isip hataing longgalo. Uri ma rangua nga. Labu uhalisiu tai. ");
INSERT INTO met_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Bagula urung mana titia Gosen, saing bagula uwa haxek manga, ung gabu garamdi xaung garam ranggindi, xaung morumdi xaung xalingim longgalo. ");
INSERT INTO met_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Bagula ngawasa maung la ba, namua na gesak sabanga nianing luwadi luwadi hiliadinga (muli) dimauyu. Nam ugabu bakbagimdi xaung adi ungiadi asok haxugina.’ ");
INSERT INTO met_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Bagu baing! Ang maxaimdi dibagu, kixingigu Benyamin maxandi xauna. Suxungugua naga harua nang baing! ");
INSERT INTO met_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Abaxanga na tibugu mana ngaxap yaya sabanga mana Isip, xaung mana axamandi abagudi ba. Baing agogolinga mala axap tibugu mari la li.” ");
INSERT INTO met_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Harua laing sup, baing hibua rimandi taxiya kixinginoa Benyamin waxungtuania saing tang, saing Benyamin hibua saing tang xauna. ");
INSERT INTO met_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Baing libu sabangang longgalo saing tangiadi. Sup, baing sabangandi dungguti daharua rangua. ");
INSERT INTO met_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Naxuyangua Yosep sabangandi dima (ba) ila sok mana Pero numanoa, baing Pero gabu yanamindi diyaha. ");
INSERT INTO met_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Baing Pero harua na Yosep ba, “Ubala sabangamdi ba, ‘Alibu bila li: Ata axamandi mahaing mana asaxaimdi saing agoxoya mala titia Kenan. ");
INSERT INTO met_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Baing axap tibuim xaung bakbagimdi dima muli rangua nga. Bagula ngasina titi xai sibuna nang, tela dali mana Isip te, saing bagula axang axamandi disok mana titia ba orana.’ ");
INSERT INTO met_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Ngatabinaung xauna ba ubaladi ba, ‘Alibu bila li: Axap wilka Isipkam teladi sanga mana garaimdi xaung hainimdi, saing axap tibuim saing ama. ");
INSERT INTO met_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Heku mana xalingimdi, namua na xalaxala Isipkam xai sibundi diraguang.’ ” ");
INSERT INTO met_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Isrel garandi dilibu bila ba. Yosep sina wilkadi nadi, bila Pero tabina ba, xaung sina anginga sanga mana haxangadinga xauna. ");
INSERT INTO met_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Baing sina imanga haundi na ding taining tainina. Ne Benyamin ba, sina siang silba 300 xaung imang haung luwadi luwadi hiliadinga na. ");
INSERT INTO met_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Baing sina axadi li na tibuna: donki 10 dibaxagi mana xalaxala Isipkam xai sibundi, xaung donki hagaxang 10 dibaxagi mana wit xaung salanga xaung anginga teladi sanga mana haxanganoa. ");
INSERT INTO met_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Baing soxi sabangandi mala, saing bungina dila, harua nadi ba, “Labu ahakhaxi daxangiau tai!” ");
INSERT INTO met_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Binabu diyunga Isip dahaing mala mana titia Kenan rangua tibudinga Yekop. ");
INSERT INTO met_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Baing dibala ba, “Yosep wauyu! Maxuna, wa Isip titing longgalo yanaminoa.” Yekop hatuminganoa rangaxak. Hatum haringina mana haruangadinga te. ");
INSERT INTO met_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ne bungina dibaxanga Yosep haruangang longgalo harua nadi ba na, saing bungina bagu wilkadi Yosep sinadi ma bu sia mala, tibudinga Yekop hatuminganoa xai muli. ");
INSERT INTO met_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Baing Isrel harua ba, “Sangau! Garagua Yosep wauyu. Bing ngala ngabagu muga mana ngamati (teguyu).” ");
INSERT INTO met_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Binabu Isrel haxa mala xaung xalinging longgalo, saing dila disok mana longga Berseba. Baing hanania (hananiangadi) mala rangua Urana mana tibuna Aisak. ");
INSERT INTO met_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Baing yambong Urana wagi mana Isrel mana axamang tela bila mibinga ba, “Yekop! Yekop!” Baing haxuya ba, “Ngawau.” ");
INSERT INTO met_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Baing Urana harua ba, “Nga Urana. Nga Urana mana tibum. Labu umaxuwa ba uri mala Isipku tai. Namua na bagula ngalibu bakbagimdi disok numanuma haringina la ba. ");
INSERT INTO met_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Bagula nga sibugu ngari mala Isip ranguaung, saing bagula ngaxapkung mahaing muli xauna. Baing bungina umati, Yosep ing sibung rimanoa bagula matai maxaimdi.” ");
INSERT INTO met_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Baing Yekop mesa ba yunga Berseba, saing garandi dita tibudinga Yekop xaung garadingdi xaung hainidingdi mana wilkadi Pero sinadi ma bu sia. ");
INSERT INTO met_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Baing daxap morundi mala xauna xaung xalingidingdi daxap mana titia Kenan. Binabu Yekop gabu bakbaging longgalo dila Isip. ");
INSERT INTO met_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Garandi, garang ranggindi, nanuhangindi, xaung nanuhanging ranggindi—bakbaging longgalo dila Isip rangua. ");
INSERT INTO met_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yayadi bagudi li Isrel garandi yadingdi dila Isip (Yekop xaung bakbagindi): Ruben Yekop garang matuaua. ");
INSERT INTO met_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben garang lupdi bing: Hanok, Palu, Hesron xaung Karmi. ");
INSERT INTO met_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simion garang lupdi bing: Yemuel, Yamin, Ohat, Yakin, Sohar xaung Saul. Saul bauna Kenan tela. ");
INSERT INTO met_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Libai garang lupdi bing: Gerson, Kohat xaung Merari. ");
INSERT INTO met_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda garang lupdi bing: Er, Onan, Sela, Peres xaung Sera (ne Er Onan tang dimati mana titia Kenan ba). Peres garang lupdi bing: Hesron xaung Hamul. ");
INSERT INTO met_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakar garang lupdi bing: Tola, Puba, Yop xaung Simron. ");
INSERT INTO met_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulun garang lupdi bing: Seret, Elon xaung Yalel. ");
INSERT INTO met_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Adi bagudili gara lupkadi Lea hayau na Yekop mana titia Padan-Aram. Hayau nanuhanginoa Daina xauna. Garang lupkadi xaung nanuhanginadi li ding disok 33. ");
INSERT INTO met_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad garang lupdi bing: Sipion, Hagi, Suni, Esbon, Eri, Arodi xaung Areli. ");
INSERT INTO met_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser garang lupdi bing: Imna, Isba, Isbi xaung Beria. Hamungadinga Sera. Beria garang lupdi bing: Heber xaung Malkiel. ");
INSERT INTO met_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Adi bagudili garadi Yekop xapsaxi rangua Silpa, haing oxatama Laban sina na nanuhanginoa Lea. Ding disok 16. ");
INSERT INTO met_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yekop garang lupkadi Retsel hayau bing Yosep xaung Benyamin. ");
INSERT INTO met_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yosep garang lup(ka)di Asenat hayau mana Isip bing Manase xaung Epraim. Asenat nanuhangina mana Potipera, lipu hananiangam mana long sabangga On. ");
INSERT INTO met_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin garang lupdi bing: Bela, Beker, Asbel, Gera, Naman, Ehi, Ros, Mupim, Hupim xaung Art. ");
INSERT INTO met_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Adi bagudili gara lupkadi Retsel hayau na Yekop. Ding disok 14. ");
INSERT INTO met_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan garang lup bing: Husim. ");
INSERT INTO met_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naptali garang lupdi bing: Yasel, Guni, Yeser xaung Silem. ");
INSERT INTO met_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Adi bagudili gara lupkadi Bilha hayau na Yekop. Bilha haing oxatama Laban sina na nanuhanginoa Retsel. Ding disok 7. ");
INSERT INTO met_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Adi dila mana Isip rangua Yekop, adi ing sibung bakbagindi, bing ding disok 66. Ne titinga ba xola mana garandi hainidingdi. ");
INSERT INTO met_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Xauna, Yosep haininoa hayau gara lup luwa na mana Isip. Binabu Yekop bakbaginoa dila duwa Isip, ding disok 70. ");
INSERT INTO met_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Tauna, Yekop soxi Yuda muga mana mala rangua Yosep ba hatanga daxangua ila Gosen nadi to. Bungina disok mana titia Gosen, ");
INSERT INTO met_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosep tabina (lipuxing oxatamdi) ba daxauxau wilka inia, saing haing mala Gosen bu gugunia tibuna Isrel. Bungina Yosep sok mana, hibua rimandi taxiya tibuna waxungtuania saing tang bunging maxaxaya. ");
INSERT INTO met_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isrel harua na Yosep ba, “(Ina naga.) Sangau nabu ngamati hatata, namua na nga sibugu ngabagu ramramoma saing ngaxabia ba uwauyu.” ");
INSERT INTO met_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Baing Yosep harua na sabangandi xaung tibung bakbagindi ba, “Bagula ngahaing mala ngabaxanga na Pero, saing bagula ngaharua na ba, ‘Sabangagudi xaung tibugu bakbagindi nulana dirung mana titia Kenan ba, ding dima rangua nga. ");
INSERT INTO met_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Lipuadi lipu sipsip wasanganamdi. Duwasa mana morudi, saing daxap sipsibidingdi, memedingdi, bulmakaudingdi xaung xalingiding longgalo ma.’ ");
INSERT INTO met_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Bungina Pero wagiang ama saing xusunga ba, ‘Baru oxatanta atuxu?’ ");
INSERT INTO met_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","bing ahaxuya ba, ‘Am lipuxim oxatamdi am gawasa mana morudi ungguti mana bungina am garauyu ma laing hatata, bila mugangamamdi dilibu.’ Baing ina naga, bagula nai mana arung mana titia Gosen, namua na Isipdi hauxading sibuna mana lipu sipsip wasanganam longgalo.” ");
INSERT INTO met_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Baing Yosep ila luxu Pero maxania saing bala ba, “Tibugu gabu sabangagudi disauya Kenan saing dima disok ba. Daxap morudingdi xaung xalingiding longgalo ma xauna. Hatata duwa titia Gosen.” ");
INSERT INTO met_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yosep xap sabangang luwadi luwadi hiliadinga mala saing tadi mali Pero maxania. ");
INSERT INTO met_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pero xusunga neng sabangandi ba, “Baru oxatanta atuxu?” Dahaxuya ba, “Am lipuxim oxatamdi am lipu sipsip wasanganamdi bila mugangamamdi. ");
INSERT INTO met_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Am gabo ba am gawa monga mana titia li. Namua na gesaga doa sibuna titia Kenan saing morumamdi doxola mana tatubang ba daxang. Binabu am gaxusungaung ba unai mana am lipuxim oxatamdi am garung mana titia Gosen.” ");
INSERT INTO met_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Baing Pero harua na Yosep ba, “Tibum gabu sabangamdi dima ranguaung, ");
INSERT INTO met_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","saing titia xaxaina maung. Uta tibum xaung sabangamdi marung mana baru titi hatainta xai sibuna. Sanga ba dirung mana titia Gosen. Xauna, nabu uxabia ba teladi lipu gagaxungamdi, bing utadi etua mana nga sibugu morugudi.” ");
INSERT INTO met_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Baing Yosep xap tibuna Yekop maluxu saing ta mali Pero maxania. Yekop sina guxama na Pero laing sup, ");
INSERT INTO met_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","baing Pero xusunga ba, “Nianimdi baru?” ");
INSERT INTO met_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Baing Yekop harua na Pero ba, “Ngahaxa mauli mana titia li sanga mana niani 130. Nianigudi xumana buk te, dahasusu mana mugangagudi te, ne walingagua baxagi mana mauxangandi.” ");
INSERT INTO met_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Baing Yekop sina guxama na Pero saing yunga mala. ");
INSERT INTO met_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Binabu Yosep libu bila Pero tabina ba, saing ta tibuna xaung sabangandi marung mana titia Isip, saing sina titia xai sibuna nadi, yanoa Rameses, dali Isip titing longgalo. ");
INSERT INTO met_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Xauna, Yosep wasaʼm tibuna gabu sabangandi xaung tibung bakbaging longgalo mana angingua, sanga mana garadingdi titidinga. ");
INSERT INTO met_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ne titia ba hataing longgalo doxola mana angingua, namua na gesak sabangua doa sibuna. Gesak sabangua libu numanuma Isip Kenan tang lipuxidingdi haringingadingdi disup. ");
INSERT INTO met_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yosep sina sina wit siangia na lipudi ba digim, saing bila balau gugunia gugunia Isipdi xaung Kenandi siangiding longgalo. Baing sina mala Pero numania. ");
INSERT INTO met_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Bungina Isipdi xaung Kenandi siangidingdi disup, Isipdi dila rangua Yosep saing daharua ba, “Uliam anging(u)a. Nam am gamati maxamia! Namua na siangimam longgalo disup.” ");
INSERT INTO met_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Baing Yosep haxuya ba, “Nabu siangimdi disup, bing axap moruimdi dima asinadi nanga. Bagula ngasina aningua nang bu ahakhaxuya rangua nga. ");
INSERT INTO met_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Binabu daxap morudingdi ma rangua Yosep, saing haxuya aningua nadi mana hosidingdi, sipsibidingdi xaung memedingdi, xaung bulmakaudingdi xaung dongkidingdi. Bila balau, xaidi mala laing niani ba sup. Haxuya angingua nadi mana moruding longgalo. ");
INSERT INTO met_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Niani baguba ila sup, niani tela sok, baing dima rangua saing daharua ba, “Lipuximam sabanga, am sanga ba am gayameng mauxangamama maung te. Siangimamdi disup xaung morumamdi ungiadi baing. Am goxola axamang tela ba am gasina naung. Am sanggamamdi xaung titimama ding ganiding (duwa). ");
INSERT INTO met_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Am gamati maxamia baru? Titimama haxugina baru? Ugimgam xaung titimama bu haxuya angingamama, saing bagula am gawa Pero lipuxing oxata olanggamdi xaung titimama bagula inia. Uliam anginga marandi bu am gawa nam am gamati xaung titia haxugina.” ");
INSERT INTO met_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Binabu Yosep gim titia longgalo duwa Isip na Pero. Isip longgalo disina titidingdi, namua na gesak sabangua doa buk manadi. Titia longgalo disok Pero iniadi. ");
INSERT INTO met_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Baing libu lipudi disok lipu oxata olanggamdi, mana Isip titing subingang tela ila sup tela. ");
INSERT INTO met_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ning gim Isip lipuxing hananiangamdi titidinga te, namua na daxap sinaga rangua Pero, saing sinaga Pero sina nadi ba sanga mana angiadinga. Namua naga disina titidinga te. ");
INSERT INTO met_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yosep harua na lipudi ba, “Alungu to. Hatata ngagimgang xaung titima na Pero. Tauna, anginga maranadi li angia bu axumadi umangia. ");
INSERT INTO met_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ne bungina axauya, bing asina hataina luwadi luwadi hiliadinga na Pero. Hataindi duwauyu bing angiadi bu axumadi umangia xaung duwa angiaimdi sanga mang, bakbagimdi xaung garamdi.” ");
INSERT INTO met_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Baing daharua ba, “Lipu sabanga, uhauliam sabanga bu am gamati te. Am gabo ba uyaha mam, binabu am ganai mana am gawa Pero lipuxing oxata olanggamdi.” ");
INSERT INTO met_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Binabu Yosep ta hanaunaunga tela mana titia Isip wa laing hatata bila li: hataing luwadi luwadi hiliadinga mana xauyanga longgalo disok titia bing Pero inia. Lipu hananiangamdi titidinga ing ganina sok Pero inia te. ");
INSERT INTO met_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Tauna, Isreldi dirung mana titia Gosen mana titi sabangga Isip. Daxap titia la ba, saing daxapsaxi gara xumana saing titidinga tubu sibuna. ");
INSERT INTO met_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yekop rung mana titia Isip laing niani 17. Binabu Yekop walingang nianindi 147. ");
INSERT INTO met_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Isrel matianoa ma haxek, baing wagi garanoa Yosep ba ma rangua, saing harua na ba, “Nabu uyaha manga, bing uta rimama babagu hanggaxobinia saing uhau haruangua ba bagula ulibu xai manga xaung usu mana haruangama bila li: Labu ukimang nga (mana) Isipku tai. ");
INSERT INTO met_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Tegu. Bungina ngayagua rangua mugangagudi, oxoxi sanggagua mala sangua Isip, saing ukimang nga gobagobadingia.” Haxuya ba, “Bagula ngalibu bila uharua (ba).” ");
INSERT INTO met_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yekop haxi ba, “Uharingia haruangua uhau.” Binabu Yosep haringia haruangua hau ba, saing Isrel turu mari uxaingania bu harua xai sibuna. ");
INSERT INTO met_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Bunging tela disup, baing dibala Yosep ba, “Tibum busi.” Binabu xap garang Manase Epraim tang mala rangua bu dila dibagu tibuna. ");
INSERT INTO met_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Baing lipudi dibala Yekop ba, “Garama Yosep ma ba bagung.” Binabu Isrel haringiaina saing mesa marung uxaingia. ");
INSERT INTO met_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Baing Yekop harua na Yosep ba, “Urana Haringing Sibuna owa masok manga mana longga Lus mana titia Kenan. Sina guxama nanga, ");
INSERT INTO met_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","saing harua nanga ba, ‘(Bagu) bagula ngasina gara xumana naung xaung libu bakbagimdi disok xumang sibuna. Bagula ngalibu usok numanuma xumana, saing bagula ngasina titia li na bakbagim(ga)di disok kimuya maung ba wa dingia bungingbunginalo.’ ");
INSERT INTO met_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Muga mana ngama la li Isip ranguaung, hainima hayau gara lup luwa naung. Hatata ngamogu tang disok ngayuadi. Epraim Manase tang bagula ngayuadi, bila Ruben Simion tang ngayuadi. ");
INSERT INTO met_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ne gara baruamtadi disok kimuya mana dingtang bagula unigadi, saing kimuya bungina dituxu sinaga mana titia na bakbak taining tainina disok manga, bagula daxap sinagidingdi hawa mana sabangading tang yadingdi. ");
INSERT INTO met_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Namua ngalibu bing ngausinga sibuna baum Retsel. Mati daxangia bungina ngayunga titia Padan ngagoxoya ma titia Kenan, haxek monga mana longga Eprat. Binabu ngakimang daxanga ila Eprat rubinia.” (Hatata duxu Eprat ba Betlehem.) ");
INSERT INTO met_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Isrel bagu Yosep garang tang, baing xusunga ba, “Adi li gaxarea iniadi?” ");
INSERT INTO met_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yosep haxuya ba, “Tang garaguadi Urana sinadi nanga la li Isip.” Baing Isrel harua ba, “Oxop dingtang ma haxek manga bu (sanga ba) ngasina guxama na dingtang.” ");
INSERT INTO met_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ne Isrel maxandi dilaba namua na wa duanga, saing bagu xai te. Binabu Yosep xap garandi ma haxek rangua, saing tibuna libu dingtang saing hibua dingtang. ");
INSERT INTO met_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Baing Isrel harua na Yosep ba, “Waleu ngahagaxa ba bagula ngabagu ramramoma muli te, ne hatata Urana libu ngabagu garamdi xauna!” ");
INSERT INTO met_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Baing Yosep yungiadi sangua Isrel king tuxundi mari, saing gung tuxundi turu mari titia. ");
INSERT INTO met_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Baing Yosep xap dingtang, Epraim wa rimamo mala Isrel rimang xong, saing Manase wa xong mala Isrel rimang rimamo, saing xapdi ma haxek rangua. ");
INSERT INTO met_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ne Isrel raria rimang rimamo saing ta (etua mana) Epraim toxonoa, heku nanunoa, saing bali rimandi, ta rimang xong (etua mana) Manase toxonoa, heku Manase matuaua. ");
INSERT INTO met_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Baing sina guxama na Yosep saing xusunga Urana ba, “Urana ba mugangagua Ebraham tibugu Aisak tang dahaxa walingadingia sanga mana daxanganoa, Urana ba wa lipuxigu wasangama mana hayauxingagua ma laing hatata, ");
INSERT INTO met_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Uleginama ba xap nga muli sangua hanggalangianga longgalo— ngaxusunga ba sina guxama na gara luwadi li. Ngaxusunga ba yagua taga mana dingtang xaung mugangagu Ebraham tibugu Aisak tang yadingdi ditaga mana dingtang, bu lipudi dahatumia yayadi li muli, xaung ngaxusunga ba tang bakagidingdi disok xumana mana titia.” ");
INSERT INTO met_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yosep bagu tibuna ta rimang rimamoa etua mana Epraim toxonoa, baing hatuminganoa mauxana. Binabu tuxuti tibuna rimanoa bu ta etua mana Manase toxonoa. ");
INSERT INTO met_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Baing Yosep harua na tibuna ba, “Tibugu, tegu. Matuaua baguli. Uta rimam rimamoa etua mana toxonoa.” ");
INSERT INTO met_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ne tibuna hauxana saing harua ba, “Garagua, ngaxabiau. Kubolua ngalibu ngaxabiau. Ing xauna bagula sok bakbak, saing ing xauna bagula xap yaya sabanga. Ning kixinging yanoa bagula dali, saing bakbaginoa bagula baxagi sanga mana numanuma xumana.” ");
INSERT INTO met_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Binabu mana xaidapka baguba sina guxama na dingtang, harua ba, “Bungina Isreldi disina guxamdi, bagula duxu yaimdi bila li: ‘Urana libu xai maung bila (libu mana) Epraim Manase tang.’ ” Bila balau ta Epraim muga mana Manase. ");
INSERT INTO met_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Baing Isrel harua na Yosep ba, “Ulungu to. Haxek sibuna bagula ngamati, ne Urana bagula wa ranguang saing xapkang muli mala mana mugangaimdi titidinga. ");
INSERT INTO met_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Baing hatata ngasina titi hataing tela muli naung dali sinaga ngasina na sabangamdi. Titia ba longga Sekem bimbing rubina ngaxap bungina ngahaunggana Amordi xaung waxangigu sabanga xaung ruangigua.” ");
INSERT INTO met_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Baing Yekop wagi garandi ma saing harua ba, “Agugunia taxiya nga bu ngabaxanga nang axamandi bagula disok mang kimu. ");
INSERT INTO met_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Ang Yekop garang mana, agugunia alungu to. Alungu tibuim Isrel haruanganoa xai. ");
INSERT INTO met_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ruben, ung garagu matuaua, ung haringingagua, hayauxingama hatanga haringingagua muga. Yama wa mugamuga, haringingama wa mugamuga. ");
INSERT INTO met_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ne uhalunglung bila lang silingama, binabu bagula uwa mugamuga muli te, namua na uhaing mana tibum uxainganoa, ukinu rangua hainigua, udongdongia yaungagua bila ba. ");
INSERT INTO met_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simion Libai tang maxang taininau, Waxangiding sabangadi dituxudi dilibu doa mana lipu teladi. ");
INSERT INTO met_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Labu hatumingagu taininau mana haruangading dianau tai, labu ngagabudi mana guguniangadingdiu tai. Namua na mana atiding disala tang dung lipudi mati, saing tang duxuxu bulmakaudi kiding waxuwaxundi mana murungadinga ing ganina. ");
INSERT INTO met_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ngabo ba daxap doa mana atiding salianoa, namua na haring buk, xaung mana gamiangadinga, namua na doa buk! Bagula ngalibudi dutu ding mauli liwe mana Yekop bakbaginoa xaung duwa olang olang mauli mana titia Isrel. ");
INSERT INTO met_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yuda, ung ba, sabangamdi kixingimdi bagula diti yama. Rimama bagula tuxu bixuamdi waxudingtuandi. Bagula tibum garang lupdi dituru disina yaya naung. ");
INSERT INTO met_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda, ung bila layon tutubing tela, Garagua, ung asaxa oxong masup, umesa ula ba. Bila layon haringina urung mari ukinu. Gaxarea sanga ba haringiaina ba tautitiung? ");
INSERT INTO met_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Tuki xaitamoxiama sanga ba sup mana Yuda garandi te, bagula taining tainina tuxu yanama tukinoa, laing lipua (naga) tuki (wa) inia sok saing numanumadi dila hawa mana. ");
INSERT INTO met_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Yuda wain marandi bagula dibaxagi buk, bu sanga ba goti donkinoa wain xania, saing yunga donki tutubinoa ba xang longindi xauna. Nabu muruna, sanga ba damia imangindi mana wain. ");
INSERT INTO met_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Maxandi bagula disabuxa namua na waining xumana, Waindi bagula dusa namua na nung kau suing langing xumana. ");
INSERT INTO met_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sebulun bagula wa tek rubinia saing mata xaidi bagula duwa la ba mana wagadi. Bagula titing ragunoa ila bila long sabangga Saidon. ");
INSERT INTO met_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakar bila donki haringing tela, kinu titia liwe mana tambingdi. ");
INSERT INTO met_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Bungina bagu titinoa xai mana yaguangua baru xaung xai mana rung mana baru, bagula xating tuandi bu xoxi axamang mauxangamdi, saing bagula tuxu oxatua mana teladi bila lipu oxata olanggama. ");
INSERT INTO met_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan bagula suxuya bakbagindi mauxangadingdi, bila Isrel bakbagindi yanamiding teladi dilibu. ");
INSERT INTO met_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan bagula wa bila moxa tela hisa daxanga rubinia. Bungina lipu haungingamdi diluki etua hosidi dima, bagula gaxu kiding tambongdi bu lipua rung hosia bagula xung mari ubunia. ");
INSERT INTO met_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Toxoratamona, ngata ragunga mana oxop nga muli. ");
INSERT INTO met_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Baing Gad, bagula lipu hanaunggamdi dima dahaunggana, ne bagula xugia mala saing xudi haungganadi. ");
INSERT INTO met_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aser angianoa bagula dau sibuna, saing bagula xauxau anginga xaidi sanga mana xaitamoxidi. ");
INSERT INTO met_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naptali bila diya hagaxana luki mauli mana ing murunganoa, bila diya hagaxana hayau gara gumangindi. ");
INSERT INTO met_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yosep bila wain xana ua xai sibuna, bila wain xana wa lang maxang rubinia, rimandi dahaing mala etua mana gamgamingua. ");
INSERT INTO met_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Lipu ruanggamdi dahaunggana haringing sibuna, atiding disala mana binabu dahang mana. ");
INSERT INTO met_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ne Yosep taguxa ruanginoa te, rimandi gagaxungadingguyu, namua na Yekop Urana Haringing Sibuna inia haringia rimania, namua na Lipu Sipsip Wasanganama, Sianga Mana Isrel, hauli, ");
INSERT INTO met_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Yosep, tibum Urana inia, ina ung haulingama. Urana Haringing Sibuna sina guxamdi naung, guxamgadi diri sabalunia ma, guxamgadi dahaing suania ma, guxamgadi bila gara xumana oxopsaxidi. ");
INSERT INTO met_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Guxamgadi nga tibum ngasinadi naung didali guxamgadi dima mana bimbi mugauamdi, didali guxamgadi dima mana xaxagang bungingbunginaloamdi. Guxamgadi longgali bagula daxap Yosep, lipua wa yanama liwe mana sabangandi. ");
INSERT INTO met_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benyamin bila koma abungina sing saha asaxadi. Buraragina xang asaxadi ungdi ba. Bungbung tuxu sinak mana axadi xapdi ba.” ");
INSERT INTO met_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Adi li Isrel bakbaging 12. Haruangadi bagudi li tibuding harua nadi bungina sina guxamdi nadi. Sina guxama nadi sanga mana ding taining tainina. ");
INSERT INTO met_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Sup, baing tabinadi ba, “Haxek sibuna bagula ngala ngakinu rangua bakbagigudi. Akimang nga rangua mugangagudi mana guhia wa mana Epron titinoa, lipu Hitam. ");
INSERT INTO met_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Guhia ba Makpela, haxek mana longga Mamre mana titia Kenan, guhia ba Ebraham gim xaung titia rangua Epron lipu Hitam bu wa gobagoba (yabanoa). ");
INSERT INTO met_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","La ba dikimang Ebraham haininoa Sara tang, la ba dikimang Aisak haininoa Rebeka tang, saing la ba ngakimang Lea. ");
INSERT INTO met_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Titia xaung guhia wa mana, Ebraham gim rangua Hitdi.” ");
INSERT INTO met_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yekop tabina garandi bila ba, baing iti kindi uxaingia muli, yaganganoa sup saing kinu rangua mugangandi (matiadi yabadingia). ");
INSERT INTO met_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Baing Yosep hibua tibung ramramonoa, tang mana saing libu. ");
INSERT INTO met_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Baing Yosep tabina lipu baxiamgadi dituxu oxatanoa ba dita baxi mana tibun(o)a Isrel sangganoa, nam buya. Binabu lipu baxiamdi dilibu bila ba, ");
INSERT INTO met_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","dituxu oxatading baxiama sanga mana xaidap 40, namua na oxatadinga xap xaidapkadi na bila ba. Baing Isipdi ditangia sanga mana xaidap 70. ");
INSERT INTO met_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Bunging usingangama ila sup, baing Yosep harua na Pero lipuxing oxatamdi ba, “Nabu ayaha manga, bing axap haruangagua mala rangua Pero. Abala ba, ");
INSERT INTO met_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Tibugu haxi ba ngahau haruangua rangua, harua ba, “Ulungu to. Haxek sibuna (bagula) ngamatiuba. Ukimang nga guhia gobagobia ngaki manga mana titia Kenan.” Binabu ngaxusungaung ba uyunga nga ba ngahaing mala ngakimang tibugu to. Tauna ngagoxoya ma.’ ” ");
INSERT INTO met_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pero haxuya ba, “Uhaing mala saing ukimang tibuma. bila haxi ba uhau haruangua ba.” ");
INSERT INTO met_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Binabu Yosep haing mala ba kimang tibuna. Pero yanaming longgalo digabu Yosep mala, adi bila numang yanamindi xaung titia Isip yanamindi. ");
INSERT INTO met_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yosep xap bakbaging numanam longgalo xaung sabangandi digabu bakbagidingdi xaung tibung bakbaging numanamdi mala xauna. Garadingdi ding ganiding digabu morudingdi duwauyu Gosen. ");
INSERT INTO met_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Wilkadi xaung lipuadi dirung mana hosidi xauna dahaing mala rangua. Buranga sabanga dila baing. ");
INSERT INTO met_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Dila disok mana longga dihitixiya wit sangsangdi mana Atat, haxek mana Langga Yodan, baing ditangia haringing sibuna. La ba Yosep usi tibuna sanga mana xaidap 7. ");
INSERT INTO met_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kenandi duwa la ba dibagu lipuadi dusi mana longga dihitixiya wit sangsangdi mana Atat, baing daharua ba, “Isipdi ditangia haringing sibuna mana lipu tela mati.” Namua naga longga ba haxek mana Langga Yodan duxu ba Abel-Misraim. ");
INSERT INTO met_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Baing ina naga, Yekop garang lupdi dilibu bila tabinadi ba. ");
INSERT INTO met_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Disia sangganoa mala titia Kenan saing dikimang mana guhia wa Makpela, haxek mana longga Mamre, guhia ba Ebraham gim xaung titia rangua Epron lipu Hitam bu wa gobagoba (yabanoa). ");
INSERT INTO met_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yosep kimang tibuna laing sup, baing gabu sabangandi xaung lipua longgalo dila rangua bu dikimang tibunoa, digoxoya muli mana Isip. ");
INSERT INTO met_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yosep sabangandi dibagu ba tibuding(a) mati, baing daharua ba, “Hatata baru? Bola Yosep hatuminganoa doa makira saing bagula haxuya kubolu dianadi talibudi mana ba.” ");
INSERT INTO met_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Binabu disina haruangua mala rangua Yosep. Daharua ba, “Muga mana tibuma mati, tabinam ba, ");
INSERT INTO met_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Aharua na Yosep bila li: “Ngaxusungaung ba uyunga sabangamdi kuboluding dianadi dilibudi maung, namua na dilibu doa sibuna maung.” ’ Binabu hatata am Urana tibum inia lipuxing oxatamdi, am gaxusungaung ba uyunga kubolumam dianadi am galibudi maung.” Bungina haruangadinga sok rangua, Yosep tang. ");
INSERT INTO met_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Baing sabangandi dima dituru mari titia maxania. Dahaura ba, “Am lipuxim oxata olanggamdi!” ");
INSERT INTO met_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ning Yosep harua nadi ba, “Labu amaxuwau tai. Sanga ba ngaxap Urana yabanoa? Tegu! ");
INSERT INTO met_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ang ba hatumingaima bing abo ba ahanggalangia nga, ne Urana hatuminganoa bing bo ba libu xai bu libu bila hatata tabagu, xap lipu xumang sibuna muli nam dimati. ");
INSERT INTO met_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Baing ina naga, labu amaxuwau tai. Bagula ngawasa mang xaung (mana) garaimdi (baing).” Baing tatua atidingdi xaung haruanga mosiu harua nadi ba. ");
INSERT INTO met_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yosep rung mana Isip rangua tibuna bakbagindi. Yosep wa sanga mana niani 110. ");
INSERT INTO met_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Baing bagu Epraim garandi garadingdi disok. Baing bungina Manase garang Makir garandi disok, ditadi Yosep babania. Bila balau disok Yosep iniadi xauna. ");
INSERT INTO met_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Kimuya baing Yosep harua na sabangandi ba, “Haxek sibuna bagula ngamati. Ne maxung sibuna Urana bagula hauliang saing xapkang sangua titia li mahaing mana titia hau haruangua ba sina na Ebraham Aisak xaung Yekop.” ");
INSERT INTO met_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Baing Yosep haxi mana Isrel garandi dahau haruangua saing harua ba, “Maxung sibuna Urana bagula hauliang, saing mana bungina baguba bing asia tuagudi mahaing sangua titia li.” ");
INSERT INTO met_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Binabu Yosep mati bungina nianindi 110. Baing dita baxi mana sangganoa, nam buya. Sup, baing dita sangganoa mana bokis tela tabu mana Isip. ");
INSERT INTO met_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Alali harua mana Yesu, Urana Lipuxing Mogunganama, mugangandi. Yesu mugangandi Xaitamoxi Debit xaung Ebraham tang. ");
INSERT INTO met_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebraham Aisak tibuna. Aisak Yekop tibuna. Yekop Yuda gabu sabangandi xaung kixingindi tibuding. ");
INSERT INTO met_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda Peres Sera tang tibuding (ne tang bauding Tema). Peres Hesron tibuna. Hesron Ram tibuna. ");
INSERT INTO met_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram Aminadap tibuna. Aminadap Nason tibuna. Nason Salmon tibuna. ");
INSERT INTO met_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon Boas tibuna (bauna Rehap). Boas Obet tibuna (bauna Rut). Obet Yesi tibuna. ");
INSERT INTO met_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesi Xaitamoxi Debit tibuna. Debit Solomon tibuna (bauna Batsiba, muga Yuraya haininoa). ");
INSERT INTO met_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon Rehaboam tibuna. Rehaboam Abitsa tibuna. Abitsa Asa tibuna. ");
INSERT INTO met_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Yehosapat tibuna. Yehosapat Yehoram tibuna. Yehoram Usaya muganganoa. ");
INSERT INTO met_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaya Yotam tibuna. Yotam Ahas tibuna. Ahas Hesakaya tibuna. ");
INSERT INTO met_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesakaya Manasa tibuna. Manasa Amon tibuna. Amon Yosaya tibuna. ");
INSERT INTO met_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaya Yekonaya xaung kixingindi tibuding (duwa bungina Babilondi didali Isreldi, daxaidi mala titidingia bu duwa lipuxiding salak yabanamdi). ");
INSERT INTO met_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kimuya mana Babilondi daxai Isreldi mala Babilon bu duwa lipuxiding salak yabanamdi: Yekonaya Sealtiel tibuna. Sealtiel Serubabel tibuna. ");
INSERT INTO met_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel Abiud tibuna. Abiud Eliakim tibuna. Eliakim Aso tibuna. ");
INSERT INTO met_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso Sedok tibuna. Sedok Akim tibuna. Akim Eliud tibuna. ");
INSERT INTO met_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud Eliesa tibuna. Eliesa Matan tibuna. Matan Yekop tibuna. ");
INSERT INTO met_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yekop Yosep tibuna. Yosep Maria ayuana. Maria hayau Yesu, ina duxu ba Urana Lipuxing Mogunganama. ");
INSERT INTO met_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Baing ina naga, bakbakkadi mana Ebraham laing Xaitamoxi Debit bing 14, baing 14 mana bungina Debit laing Babilondi daxai Isreldi mala Babilon bu duwa lipuxiding salak yabanamdi, baing 14 mana bungina Babilondi daxai Isreldi mala Babilon laing bungina Urana Lipuxing Mogunganama. ");
INSERT INTO met_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Naxuyanga mana Yesu Kristo sok bing bila li. Bauna Maria dahau gabisia mana ba bagula yau Yosep. Ne muga mana tang duwa xauna teguyu, Maria bagu ina ba gamona. Ne Urana Aningonoa haringinganoa libu. ");
INSERT INTO met_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yosep, lipua lipudi dibagu bila ayuanoa, bing lipu maringing tela. Binabu hau hatumingua ba taxiti haruanga dahau ba. Ne bo ba sina memeya na te, binabu hatum ba taxiti lipudi maxadingia te. ");
INSERT INTO met_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Hatum mana malauyu, baing Toxoratamona uleginam tela sok mana maluxu mibingia. Harua ba, “Yosep, Xaitamoxi Debit garanoa, labu umaxuwau tai mana ulibu doa nabu uyau Maria. Bila ba te. Namua na gara ba wa gamonia bing Urana Aningonoa haringinganoa xap masok. Binabu oxop hainima. ");
INSERT INTO met_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Baing bagula hayau gara lup tela, saing usina yaya Yesu na, namua na bagula xap lipudi muli sangua kuboluding diandi.” ");
INSERT INTO met_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Axadi bagudi li disok bu libu Toxoratamona haruanganoa aningona, harua waleu lipuxing suxunguxunguama Aisaya suxungunia ba: ");
INSERT INTO met_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Alungu to! Haing nanung tela xabia luba teguyu bagula gamona! Bagula hayau gara lup tela, saing bagula duxu ba Imanyuel, namuxina ba, ‘Urana wa rangua kira.’ ” ");
INSERT INTO met_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Bungina Yosep mesa, libu haruanga Toxoratamona uleginama tabina, saing xap Maria ila numia bila haininoa. ");
INSERT INTO met_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ne kinu rangua te laing hayau garang lup. Baing sina yaya Yesu na. ");
INSERT INTO met_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria hayau Yesu longga Betlehem wa probinsia Yudia mana bungina Xaitamoxi Herot. Kimuya, lipu hatung suxinganam teladi titidinga wa Yudia karagia ba dima long sabangga Yerusalem, ");
INSERT INTO met_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","saing duxusunga ba, “Gara wa Yudadi xaitamoxidinga wa bi? Am gabagu hatunging hayauxingama bungina haing, saing am gama bu am gasabu mana.” ");
INSERT INTO met_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Xaitamoxi Herot lungu haruanga baguba, baing hatum xumana. Yerusalem longgalo xauna dahatum xumana. ");
INSERT INTO met_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tauna, wagi lipu hananiangamdi yanamidingdi digabu lipu hanaunaunga tubatubainganamdi dima. Dima digugunia, baing xusungadi ba, “Urana lipuxing suxunguxunguamdi dibaxanga ba Urana Lipuxing Mogunganama bauna bagula hayau bi?” ");
INSERT INTO met_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Dahaxuya ba, “Longga Betlehem mana probinsia li Yudia, namua na Urana lipuxing suxunguxunguama Maika bung ba: ");
INSERT INTO met_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘O longga Betlehem mana Yudia, uwa long olang sibuna maluxuʼm Yudia te, namua na yanam tela bagula sok sanguang, bagula sok lipuxigu Isreldi lipuxiding wasanganama bila lipu tela wasa mana sipsipdi.’ ” ");
INSERT INTO met_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Baing Herot sina haruanga na lipu hatung suxinganamdi hisangia, xusungadi ba dima rangua. Xusungadi saing xap xabianga mana bunging maringina dibagu hatunga muga. ");
INSERT INTO met_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Soxidi mala longga Betlehem saing baladi ba, “Ala asai haringina mauli mana gara ba. Abagu laing sup baing agoxoya ma abala nga bu sanga ba ngamala ngasabu mana xauna!” ");
INSERT INTO met_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Dilungu xaitamoxi haruanganoa laing sup, baing dilauba. Baing hatungga ba muga dibagu karagia, ina muga manadi laing wa mua etua mana longga gara ba wa mana. ");
INSERT INTO met_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bungina dibagu hatungga ba, gamodingdi diyaha sibuna ba! ");
INSERT INTO met_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Disok numia, diluxu saing dibagu gara gabu bauna Maria, baing digung kiding tuxundi mari saing disabu mana. Saking daxaxa tangadingdi saing disina yahanga xaitamoxiamdi na. Disina gol, xai susung saminamdi xaung baxi tela duxu ba mer. ");
INSERT INTO met_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ne bungina dibo ba digoxoya mala titidingia, dinaxu daxanga xan tela, namua na Urana baladi haringina mibingia ba labu digoxoya mala rangua Herotku tai. ");
INSERT INTO met_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Dila masup baing Toxoratamona uleginam tela sok mana Yosep mibingia. Harua ba, “Umesa! Ugabu gara xaung bauna tung gagiti mala numanuma Isip. Awa la ba laing ngabalang ba sanga mana agoxoya ma, namua na Xaitamoxi Herot bagula sai mana garua bu ung mati.” ");
INSERT INTO met_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Baing ina naga, Yosep mesa, xap gara bauna tang mana yambongga baguba, saing tung digiti mala numanuma Isip. ");
INSERT INTO met_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Duwa la ba laing Herot mati. Ala baguli libu Toxoratamona haruanganoa aningona waleu lipuxing suxunguxunguama Hosea bung ba: “Ngawagi garagua ma sangua numanuma Isip.” ");
INSERT INTO met_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Bungina Herot xabia ba lipu hatung suxinganamdi dituxu murak mana, atin disala buk. Baing soxi lipu haungingamdi mala longga Betlehem xaung longga duwa singia bu dung gara lupdi nianiding luwa saing hawa mati, namua na lipu hatung suxinganamdi dibala mana xaidapka dibagu hatungga sok muga ba. ");
INSERT INTO met_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kubolu diana li libu haruanga aningona Urana lipuxing suxunguxunguama Yeremaya bung waleu ba: ");
INSERT INTO met_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Dilungu waxutu tela longga Rama— tangtang saing hatangitangi sabanga. Retsel tangia garandi, hauxana mana lipudi ditatua atindi, namua na garandi disup ba.” ");
INSERT INTO met_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kimuya mana Herot mati, baing Toxoratamona uleginam tela sok mana Yosep mibingia Isip. ");
INSERT INTO met_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Bala ba, “Umesa saing ugabu gara xaung bauna, tung gagoxoya mala numanuma Isrel, namua na lipudi dituba ba disahi gara ba walinganoa dimati masup.” ");
INSERT INTO met_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Binabu mesa, xap gara bauna tang saing tung dila numanuma Isrel. ");
INSERT INTO met_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ne bungina lungu ba Akelias xap tibuna Herot yabanoa saing sok Yudia xaitamoxidinga, maxuwa mana ila bila ba. Baing Urana sina haruanga na mana mibinga tela, bala ba sanga ba wa titia Yudia te, nam mauxanganoa xap. Binabu diyunga dila titia Galili, ");
INSERT INTO met_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","duwa mana long tela duxu ba Nasaret. Alali libu haruanga aningona Urana lipuxing suxunguxunguam mugauamdi daharua mana Lipuxing Mogunganama ba: “Bagula duxu ba lipu Nasaretiam tela.” ");
INSERT INTO met_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mana bungina baguba Lipu Suguangama Yon ungguti baxanga haruanganoa Yudia long xoliania. ");
INSERT INTO met_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Baxanga ba, “Axugia hatumingaimdi, namua na Long Xaiya Yonggaxinoa wa haxek ba.” ");
INSERT INTO met_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ina naga waleu sibuna Urana lipuxing suxunguxunguama Aisaya baxanga mana bungina harua ba, “Waxutu tela wagi mua long xoliania ba, ‘Axauxau daxangua mana Toxoratamona, atongtongia daxanga maringindi mana.’ ” ");
INSERT INTO met_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yon imanginoa ditongtongia mana kamel buxandi, saing goxi waxu asaxa sangganam tela wagigia ulenia. Angianoa bing munrikidi xaung bina bila dungungu langina. ");
INSERT INTO met_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Baing Yerusalemdi, Yudia long longgalo xaung long longgalo duwa haxek mana Langga Yodan ding dila rangua. ");
INSERT INTO met_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Baing bungina ditula kuboluding diandi, suguadi mana Langga Yodan. ");
INSERT INTO met_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ne bungina bagu Parisi xaung Sadyusi xumana dima mana longga sugua lipudi, harua nadi ba, “Ang bila moxa diang garandi! Gaxarea balang ba aluki mala, agiti Urana ating salianoa ma yu? ");
INSERT INTO met_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kuboluim aningondi duwa bi? Muga bing alibu kubolu xai bu hatanga ba axugia hatumingaimdi. ");
INSERT INTO met_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Heku aharua nam bila li: ‘Kira mugangaroa Ebraham. Binabu Urana sanga ba hanggalangia kira te.’ Namua na ngabalang ba Urana sanga ba xugia sianggadi li mala disok Ebraham bakbagindi. ");
INSERT INTO met_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Urana xauxau masup ba hanggalangiang nabu axugia kuboluim diandi te! Bila lipu tela ta galisia matabu xai namuya, bu tui mari saing ting mala yabia nabu aningon te. ");
INSERT INTO met_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nga ba ngasuguang mana langa bu hatanga ba axugia hatumingaimdi ba. Ning lipu tela ma kimu manga, haringinganoa dali haringingagua. Sanga mana ba ngarai xaing sanggandi te, namua na yanoa dali ngayua sibuna. Bagula suguang mana Urana Aningonoa. Ne lipu gaxarea dahatum haringina mana te, bagula taudi yabia. ");
INSERT INTO met_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Xauxau ba hata lipu xaidi xaung lipu diandi, bila lipu wit umangang oxatanamdi dihitixiya sangsangdi mana witdi. Bagula gugunia lipu xaidi numania bila lipu oxatamdi digung wit maluxu anginga numania. Ne lipu diandi, bagula taudi maluxu yap subingang teguamia bila ditau sangsangdi.” ");
INSERT INTO met_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mana bungina baguba Yesu yunga titia Galili saing ila mana Langga Yodan bu xap langa Yon rimania. ");
INSERT INTO met_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ne Yon tuba ba bili. Harua ba, “Baruta uma rangua nga? Taibu ung ba ung gusugua nga!” ");
INSERT INTO met_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu haxuya na ba, “Hatata bing ulibu bila ngaharua, namua na mana daxanga naga talibu Urana murunganoa.” Saking Yon nai mana. ");
INSERT INTO met_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu xap langa masup, baing haing sangua langa. Hata sibuna li long xaiya xaxaina saing bagu Urana Aningonoa ri ma mana bila baxaliku saing rung mana. ");
INSERT INTO met_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Baing waxutu tela sok ma long xaiya, harua ba, “Alali garagu sibuna, nga murugu sibuna mana. Ngayaha sibuna mana.” ");
INSERT INTO met_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Baing Urana Aningonoa xai Yesu mahaing long xoliania bu xaungadi yanamidinga tuba. ");
INSERT INTO met_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Saha mana angingua laing xaidap yambong 40 disup, baing gesagina. ");
INSERT INTO met_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Lipu tubaikkama ma rangua saing harua ba, “Nabu ung Urana Garanoa, bing ubala sianggadi li bu duxugia salanga.” ");
INSERT INTO met_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ne Yesu haxuya ba, “Urana Xuanoa harua ba: “ ‘Lipudi sanga ba daxap walinga mana salanga ing ganina te. Walinga sibuna ma mana Urana haruangang longgalo dima suxungunia.’ ” ");
INSERT INTO met_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Baing xaungadi yanamidinga xai mahaing long sabangga Urana inia Yerusalem saing ta mahaing etua sibuna Urana Numang urongania. ");
INSERT INTO met_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Harua na ba, “Nabu ung Urana Garanoa, bing uhixi mari la li. Namua na Urana Xuanoa harua ba: “ ‘Bagula tabina uleginamdi maung bu duwasa xai maung. Bagula ditiung rimadingia nam utua kima siangia.’ ” ");
INSERT INTO met_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu haxuya ba, “Urana Xuanoa harua xauna ba: ‘Labu uta Toxoratamona, Urana ungia, tubaigiau tai.’ ” ");
INSERT INTO met_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Baing xaungadi yanamidinga xai mahaing bimbi eta loam tela saing hatanga xaitamoxidi yonggaxiding longgalo xaung haringingadingdi na. ");
INSERT INTO met_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Baing harua na ba, “Bagula ngasina axadi li naung bu uwa etua manadi, nabu ugung kim tuxundi saing usabu manga.” ");
INSERT INTO met_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Baing Yesu harua na ba, “Satan, usauya! Namua na Urana Xuanoa harua ba: “ ‘Usabu mana Toxoratamona, Urana ungia, saing utuxu ing oxatanoa ing ganina.’ ” ");
INSERT INTO met_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Baing xaungadi yanamidinga sauya, saing Urana uleginamdi dima dahauli Yesu. ");
INSERT INTO met_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Bungina Yesu lungu haruanga ba dita Yon salak yabania, yunga probinsia Yudia saing ila titia Galili. ");
INSERT INTO met_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Muga ila longga Nasaret, baing yunga saing ila long sabangga Kaperneam, wa Lang Gamolingana Galili rubinia mana titiadi Sebulan xaung Naptali. ");
INSERT INTO met_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Alali libu haruanga aningona Urana lipuxing suxunguxunguama Aisaya bung ba: ");
INSERT INTO met_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Mana titia Sebulan xaung titia Naptali, lang gamolingang rubinia, Langga Yodan hataina— mana titia Galili Yuda Teguam xumana duwa mana ba— ");
INSERT INTO met_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","lipuadi ba dirung labiania dibagu nagung sabanga saxaxangia daxangua. Baing mana adi duwa titia maxuwanga matiama xapdi, nagung tela saxaxangiadi.” ");
INSERT INTO met_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mana bungina baguba saing ila, Yesu ungguti ba baxanga ba, “Axugia hatumingaimdi, namua na Long Xaiya Yonggaxinoa wa haxek ba.” ");
INSERT INTO met_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Xaidap tela Yesu haxa Lang Gamolingana Galili rubinia, baing bagu neng sabangandi—Saimon duxu ba Pita gabu kixinginoa Andru. Tang diting amagua lang gamolingania, namua na dingtang lipu xuningamdi. ");
INSERT INTO met_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu harua nadi ba, “Tang gama anaxu manga, saing bagula ngalibuang asok lipu xuningam mana lipudi.” ");
INSERT INTO met_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Baing hata sibuna li tang diyunga amagadingdi saing dinaxu mana. ");
INSERT INTO met_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Haxa monga mala baing bagu neng sabangang teladi—Sebedi garanoa Yems gabu kixinginoa Yon. Tang duwa maluxuʼm waga tela rangua tang tibuding Sebedi, dahamaringia amagadingdi. Yesu wagi mana dingtang dima xauna. ");
INSERT INTO met_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Baing hata sibuna li tang diyunga wagadinga xaung tibuding, saing tang dinaxu mana. ");
INSERT INTO met_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu haxa mauli maluxu titia Galili, tubatuba maluxuʼm sabungading numandi xaung long longgalo baxanga ulek xaiyua mana Yonggawa. Baing hamaringia businga xangxang longgalo liwe mana lipudi. ");
INSERT INTO met_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Naxuyanganoa ila mana titia Siria hataing longgalo, baing lipudi dahau lipu longgalo businga xangxana daxapdi, adi salak sabanga xapdi, adi xaungadi duwa manadi, adi asaxa garanoa haing manadi xaung adi rimading kiding dahamati ma rangua, saing hamaringiadi. ");
INSERT INTO met_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Buranga sabangadi mana titia Galili, titia Dekapolis, long sabangga Yerusalem, titia Yudia xaung Langga Yodan hataina, ding disu mana. ");
INSERT INTO met_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Bungina Yesu bagu burangadi, haing mana bimbi tela. Rung mari bu tubatuba lipuxindi dinaxu mana, baing dima rangua. ");
INSERT INTO met_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Baing tubatubadi bila li: ");
INSERT INTO met_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Lipudi daxabia diraxap mana Urana kubolundi, duwa xai, namua na Long Xaiya Yonggaxinoa bing dingia. ");
INSERT INTO met_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Lipudi ayangading hatumingadingia mana kuboludingdi, duwa xai, namua na Urana bagula tatua atidingdi. ");
INSERT INTO met_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Lipudi diti yadingdi te, duwa xai, namua na bagula sina titi longgalo nadi. ");
INSERT INTO met_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Lipudi dahaxi mana dilibu kubolu maringindi bila dahaxi mana anginga lang, duwa xai, namua na Urana bagula sina haringinga nadi bu dilibu ing murunganoa. ");
INSERT INTO met_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Lipudi dusinga lipudi, duwa xai, namua na Urana bagula usingadi xauna. ");
INSERT INTO met_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Lipudi dahatumia Urana murunganoa ing ganina, duwa xai, namua na bagula dibagu Urana. ");
INSERT INTO met_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Lipu aningoxamdi, duwa xai, namua na Urana bagula uxudi ba garandi. ");
INSERT INTO met_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Lipudi daxap doa mana kubolu maringindi dilibudi, duwa xai, namua na Long Xaiya Yonggaxinoa bing dingia. ");
INSERT INTO met_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Bungina anaxu manga saing lipudi didaudauang, disina salaga nang xaung dilangua saing daharua haruanga diang xangxana mang, awa xai. ");
INSERT INTO met_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ayaha sibuna gamoimia saing ayaha, namua na haxuyangaim sabanga raguang long xaiya. Ahatumia, waleu disina salak taininau na Urana lipuxing suxunguxunguamdi. ");
INSERT INTO met_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ang bila mosaga. Ang sanga ba ata lipu titiamdi daxanga maringinia bu walingadingdi didau bila mosak sanga ba hauli angingadi didau. Ning nabu dauyanoa sup, bing aria baru bu mosaga dau muli? Tegu. Mosakka na bila ba sanga mana axamang tela te. Bagula diting mari titia saing lipudi bagula diruha. ");
INSERT INTO met_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ang bila lulianoa. Ang sanga ba ahauli lipu titiamdi ba dibagu daxabia Urana haruangang maxunama. Bila lipudi dibagu long sabanga wa xaxagania nagungindi dilu, sanga ba lipu longgalo dibagu kuboluimdi. ");
INSERT INTO met_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ne, lipudi ditung nagung tela saing dikaukau minia te. Tegu. Dita mahaing yabania bu sina luliana na lipu numam longgalo. ");
INSERT INTO met_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bila balau, ata kuboluim xaidi sabasabia bu lipu longgalo dibagudi, bu ding longgalo bagula diti Tibuim long xaiyam yanoa. ");
INSERT INTO met_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Labu ahatum ba ngama bu ngahitixiya hanaunaunga Urana sina na Moses kimbo lipuxing suxunguxunguamdi haruangadingdiu tai. Tegu. Ngama ba haruangadingdi aningoding. ");
INSERT INTO met_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Maxung sibuna ngabalang ba, laing sabaluna xaung titi disup, hanaunaunga hataing kaxukang tela sanga ba hanggalang monga te. Tegu. Hataing longgalo bagula disok to. ");
INSERT INTO met_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Binabu nabu udali hanaunaunga kaxukang sibung tela ing ganina saing utubatuba lipu teladi ba dilibu taininau, bagula uwa lipu kimuam sibuna mana Long Xaiya Yonggaxinoa. Ning lipu gaxarea su mana Urana hanaunaungandi saing tubatubadi bagula xap yaya sabanga Long Xaiya Yonggaxinia. ");
INSERT INTO met_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ne alungu to: Parisidi xaung lipu hanaunaunga tubatubainganamdi kuboludinga mana disu mana Urana, nabu adali kubolua ba te, maxung sibuna sanga ba aluxu Long Xaiya Yonggaxinia te! ");
INSERT INTO met_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ang galungu masup haruanga mugangaradi daxap waleu ba, ‘Labu ung lipu tela matiu tai. Nabu ung lipu tela mati, bing bagula uwa haruangia.’ ");
INSERT INTO met_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ning ngabalang ba lipu gaxarea gamia tela, ina wa haruangia. Baing nabu uharua na tela ba, ‘Ung lipu olang,’ sanga ba Sanhidron Kaunsilidi disuxuyaung. Nabu uharua na tela ba, ‘Kakaham sibuna!’ sanga ba Urana tinggung mari long salakkam yabinia. ");
INSERT INTO met_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Binabu, nabu uli kabukabu hananiangamia mana Urana Numanoa, uhanania hananiangama mala rangua Urana, saing la ba uhatum muli mana lipu tela wa haruangia maung, ");
INSERT INTO met_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bing uyunga hananiangama kabukabu hananiangam rubinia. Ula ulibu lipua ba atin daxaringa to. Sup baing uma uhanania hananiangama mala rangua Urana. ");
INSERT INTO met_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Uhamaringia haruangua sap rangua bixuama xaiung haruangia. Ulibu bungina uwauyu daxangia, nam ganangana sup, saing taung lipu suxuyangam rimania, ina taung lipu salak yabang wasanganama rimania, saing ina taung salak yabania. ");
INSERT INTO met_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Maxung sibuna ngabalaung ba, bagula diyungaung masok sangua sap te. Bagula uwa laing ugim haxuyangama masup to. ");
INSERT INTO met_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ang galungu masup haruangua ba: ‘Labu ukinu rangua gaxarea uyau teguyu bau tai.’ ");
INSERT INTO met_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ning ngabalang ba lipu gaxarea bagu haing tela xaung maxandi digatila mana, bing libu kubolu diana ba—kinu rangua hatumingania. ");
INSERT INTO met_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nabu maxam rimamo xaiung bu ulibu kubolu diana, bing uhasi uting mala. Nabu sanggam hatainoa hanggalang saing ula long xaiya, bing xai buk. Nam sanggam longgalo duwa bu ditinggung mari long salakkamia. ");
INSERT INTO met_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Baing nabu rimam rimamo xaiung bu ulibu kubolu diana, bing utaxiti uting mala. Nabu sanggam hatainoa hanggalang saing ula long xaiya, bing xai buk. Nam sanggam longgalo duwa bu uri long salakkamia. ");
INSERT INTO met_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Lipu teladi daharua ba: ‘Nabu lipu tela bo ba taxiti yaunganoa bing sina xailonga na haininoa ing ganina.’ ");
INSERT INTO met_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ning ngabalang ba lipu gaxarea taxiti yaunganoa, ne haininoa haxa mauli rangua lipu tela te, bing ta haininoa daxanga diania mana yaungua. Baing lipu gaxarea yau haing yaunga taxitinganamga ba libu kubolu diana mana yaunga daxanganoa. ");
INSERT INTO met_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Haruanga tela muli ang galungu masup mugangaradi daxap waleu ba, ‘Labu utaxiti haruangamau tai. Ulibu haruanga longgalo uhau rangua Toxoratamona.’ ");
INSERT INTO met_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ning ngabalang ba, labu uharingia haruangama xaung haruanga telau tai! Nabu uxu ba long xaiya bu haringia haruangama, ina Urana xaitamoxi kabukabunoa. ");
INSERT INTO met_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Baing nabu uxu ba titia, ina longga yagua kindi mana. Baing nabu uharingia xaung Yerusalem, bing alaba long sabanga mana Xaitamoxi Sabanga. ");
INSERT INTO met_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Labu uharingia xaung haruanga ‘Mana toxoguau!’ tai, namua na sanga ba uxugia toxolom tela sok usamana kimbo mutuxuna te. ");
INSERT INTO met_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Uharua bila li ing ganina: ‘Wane, bagula ngalibu,’ kimbo ‘Tegu. Bagula ngalibu te’. Haruangama sanga ba. Bungina uharingia haruangama xaung haruanga tela, alaba ma rangua lipu diana ba. ");
INSERT INTO met_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ang galungu masup haruanga ba, ‘Nabu lipu tela hanggalangia maxama, bing uhanggalangia inia xauna. Nabu lipu tela taha saha waim tela, bing utaha saha inia xauna.’ ");
INSERT INTO met_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ning ngabalang ba, labu uhaxuya lipua doa maunggu tai. Nabu lipu tela tahaung manggaxobim rimamo, bing uxugia tela rangua xauna. ");
INSERT INTO met_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nabu lipu tela bo ba xaiung haruangia bu xap giminaga ranguaung xaung xap imangim lunama, bing usina imangim maxaxaya na xauna. ");
INSERT INTO met_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nabu lipu tela bila kiap haxi mana oxoxi xalingindi mala laing kilomita tela, bing oxoxidi laing kilomita luwa. ");
INSERT INTO met_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Usina na lipu gaxarea xusungaung, saing labu uyamu lipudi dibo ba daxap axamang tela ranguanggu tai. ");
INSERT INTO met_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ang galungu masup haruanga ba, ‘Ung murung sibuna mana riamdi saing hauxam sibuna mana bixuamdi.’ ");
INSERT INTO met_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ning ngabalang ba: Ang muruim sibuna mana bixuaimdi saing asabu mana lipuadi disina salaga nang! ");
INSERT INTO met_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mana kubolua ba, bagula ahatanga ba awa Tibuim wa long xaiya garang sibundi. Namua na sina xaidap lulianoa na lipu diandi xaung lipu xaidi xauna, saing sina kuya mari mana lipu maringindi xaung lipu maringing teguamdi xauna. ");
INSERT INTO met_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nabu ung murum sibuna mana lipuadi muruding sibuna maung ing ganina, bagula axap haxuyanga baruamta? Lipu takis xabinganam diandi xauna, dilibu bila ba. ");
INSERT INTO met_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nabu ulibu kubolu xai na riamdi ing ganina, bing kuboluma xan tela baru? Lipudi daxabia Urana te xauna dilibu bila ba. ");
INSERT INTO met_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Binabu alibu kubolu maringing sibuna, bila Tibuim long xaiyam libu kubolu maringing sibuna. ");
INSERT INTO met_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Amaxania. Labu alibu kuboluim xaidi lipudi maxadingia bu dahatum xai manggu tai. Nabu alibu bila ba, bing haxuyangaim te rangua Tibuim wa long xaiya. ");
INSERT INTO met_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Binabu bungina usina yahangua na lipu raxabinganam tela, labu uhabingia sabanga manau tai. Labu asoxi lipudi diyup toxidi muga mang mana Yudadi sabungading numandi xaung mana daxangadiu tai. Lipu manang luwadi dilibu bila ba bu lipudi dibagu, diti yadingdi. Maxung sibuna ngabalang ba, daxap haxuyangadinga masup. ");
INSERT INTO met_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ne ung ba, bungina usina haulingua na lipu haxugindi, labu uyunga lipudi daxabia baraxinta ulibu tai. ");
INSERT INTO met_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Usina yahangamdi hisangia, baing Tibum, ina xabia axamang hisangam longgalo, bagula haxuya kuboluma. ");
INSERT INTO met_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Baing bungina asabu, labu alibu bila lipu manang luwadi dilibu tai. Ding diyaha sibuna mana disabu mana daxanga sokindi kimbo Yudadi sabungading numandi bu lipudi dibagudi. Maxung sibuna ngabalang ba, daxap haxuyangadinga masup. ");
INSERT INTO met_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ning bungina usabu, uluxu numam lunia, uriba xalua saing usabu na Tibum, ina lipu tela bagu te. Bagung mana longga lipu tela sanga ba bagung te, saing bagula sina haxuyangua naung. ");
INSERT INTO met_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Baing bungina usabu, labu uharua harua olang bila lipudi daxabia Urana te dilibu tai. Dahatum ba nabu daharua haruanga marang xumana, bing urana dingiadi bagula dilungudi. ");
INSERT INTO met_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Labu awa bila dinggu tai, namua na Tibuim xabia rangrang axadi araxap manadi muga mana axusunga. ");
INSERT INTO met_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Binabu asabu bila li: “Tibumam, uwa long xaiya, yama am gabo ba lipu longgalo dahatum ba maringing sibuna. ");
INSERT INTO met_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Yonggaxima bing ma. Am gabo ba lipu titiamdi dilibu ung murungama, bila dilibu long xaiya. ");
INSERT INTO met_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Uliam anginga sanga mana xaidapka baguli. ");
INSERT INTO met_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Uyunga kubolumam diandi, bila am gayunga lipu longgalo kuboluding diandi dilibudi mam. ");
INSERT INTO met_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Saing labu uyungam mala tubaigiau tai, ning oxopkam muli sangua lipu diana rimanoa. ");
INSERT INTO met_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Nabu ayunga lipudi kuboluding diandi bungina dilibudi mang, bing Tibuim long xaiyama bagula yunga kuboluim diandi xauna. ");
INSERT INTO met_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ning nabu ayunga lipudi kuboluding diandi te, bing Tibuim bagula yunga kuboluim diandi te. ");
INSERT INTO met_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Bungina asaha mana angingua, labu alibu bagungaimdi ayangading bila lipu manang luwadi dilibu tai. Dituba ba ramramoding ayangading bu lipudi daxabia ba disaha mana angingua. Maxung sibuna ngabalang ba, daxap haxuyangadinga masup. ");
INSERT INTO met_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ning bungina asaha mana angingua, ahitia toxoloimdi xaung adamia ramramoimdi. ");
INSERT INTO met_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Baing bagula lipudi dibagu daxabia te asaha mana angingua. Tibuim, ina lipudi dibagu te, ing ganina bagula bagu. Baing Tibuim, ina bagu axamang longgalo hisangia, bagula haxuya nang. ");
INSERT INTO met_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Labu agugunia xalaxaladi mang la li titiau tai, longga binadi daxangdi xaung rosiandi dahanggalangiadi, longga lipu hanaunggamdi dutu saha ramanga dahanai. Tegu. ");
INSERT INTO met_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Agugunia xalaxaladi long xaiya, longga binadi daxangdi te xaung rosiandi dahanggalangiadi te, longga lipu hanaunggamdi dutu saha ramanga dahanai te. ");
INSERT INTO met_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Longga xalingimdi duwa mana, la ba murungaima wa xauna. ");
INSERT INTO met_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Maxua bila sangga nagunginoa. Nabu maxaimdi daxai, luliadinga saxaxangia sanggaim longgalo. ");
INSERT INTO met_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ne nabu didoa, sanggaim longgalo bagula dibaxagi mana labianoa. Baing nabu lulianoa lu maluxu mang laba, bing labiana ba tubu baru! ");
INSERT INTO met_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Lipu tela sanga ba waxata mana lipu haringing luwa te, namua na bagula murung sibuna mana tela saing hauxang sibuna mana tela, kimbo bagula waxata xai mana tela saing atin didoa mana tela. Bila balau, sanga ba awa hawa mana Urana xaung xalaxaladi xauna te. ");
INSERT INTO met_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Binabu ngabalang ba, labu ahatum xumana mana walingaimdiu tai, axang baraxintau, anung baraxintau, kimbo mana sanggaimdiu, asau baraxintau tai. Walinga axamang angingam ing ganina te. Sangga axamang imanggam ing ganina te. ");
INSERT INTO met_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ahatumia mangdi: Duxuma te, daxauya te, digugunia angiadinga numa guguniangamia te. Ne Tibuim long xaiyam haxangdi. Baing ang gadalidi maxania! ");
INSERT INTO met_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Baruta? Sanga ba hatumingaim xumana sigi xaidap taininau mana walingaimdi? Tegu! ");
INSERT INTO met_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Baing baruta ahatum xumana mana imangdi? Ahatumia haidangadi, dahaing baru. Duwaxata te, ditongtongia imangidingdi te. ");
INSERT INTO met_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ning ngabalang ba, haidangadi ba gumangidinga xai sibuna mana Xaitamoxi Solomon yauyaungandi, ina waleu yauyau xai sibuna ba. ");
INSERT INTO met_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nabu Urana libu bila ba mana haidanga abungindi, hatata duwa, ne buragina lipudi ditaudi yabia, bing maxung sibuna bagula yauyauang xai sibuna. Ang hatumingaim haringina kaxukana buk! ");
INSERT INTO met_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Binabu labu ahatum xumanau mana axadi bau tai. Labu aharua bila liu tai: ‘Bagula taxang baraxinta?’ kimbo ‘Bagula tanung baraxinta?’ kimbo ‘Bagula tasau baraxinta?’ ");
INSERT INTO met_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Namua na lipudi daxabia Urana te disaisai mana axadi ba, saing Tibuim long xaiyama xabia ba araxap manadi. ");
INSERT INTO met_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ne asai mana Urana Yonggaxinoa xaung kubolung maringina muga mana axamang longgalo, bing bagula uliang mana axadi ba xauna. ");
INSERT INTO met_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Binabu labu ahatum xumana mana buraginau tai, namua na buragina bagula xap ing sibuna mauxangandi dima. Hatata mauxangandi sanga mana hatata. ");
INSERT INTO met_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Labu asuxuya lipu teladiu tai bu Urana suxuyang xauna te. ");
INSERT INTO met_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Namua na Urana bagula suxuya kuboluimdi mana kubolua asuxuya teladi mana. Raguna ahatumia bungina asuxuya lipudi bing raguna taininau Urana bagula hatumia bungina suxuyang. ");
INSERT INTO met_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Baruta ubagu xai sangsangina wa riama maxania, ne uhatumia tuxa wa ung sibum maxamia te? ");
INSERT INTO met_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Baruta uharua na riama ba, ‘Riagu, ngabo ba ngaunia xai sangsangina sangua maxama,’ bungina tuxua wa ung sibum maxamia? ");
INSERT INTO met_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ung lipu manang luwa, muga bing unia tuxua sangua maxama, baing kimuya sanga ba ubagu maringina bu unia xai sangsangina sangua riama maxanoa. ");
INSERT INTO met_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Labu asina axamang Urana iniadi na lipudi duwa bila komadiu tai, nam duxugia dawasoso nang. Labu ating yauyaungaim xai sibundi rangua lipudi duwa bila buxudi, nam dahatumiadi te saing diruharuhadi. ");
INSERT INTO met_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Axusunga xusunga bing bagula Urana uliang. Asaisai bing bagula abagu. Aringring bing bagula xalua xaxaina mang. ");
INSERT INTO met_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Namua na lipu gaxarea duxusunga bing bagula daxap. Lipu gaxarea disai bing bagula dibagu. Saing lipu gaxarea diringring bing xalua bagula xaxaina manadi. ");
INSERT INTO met_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Nabu angia tela garanoa xusunga tibuna mana salanga, bing bola tibuna bagula ulia maramara? Tegu. ");
INSERT INTO met_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kimbo nabu xusunga mana song tela, bing bola tibuna bagula ulia moxa? Tegu sibuna. ");
INSERT INTO met_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tauna, ang ba lipu kubolu dianamdi, ning ang gaxabia xai mana aulia garaimdi yahanga xaidi. Baing ina naga, Tibuim wa long xaiya bungingbunginalo dali kuboluimdi, binabu bagula sina yahanga xai sibundi na lipu gaxarea duxusunga manadi! ");
INSERT INTO met_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Binabu baru kubolunta abo ba lipudi dilibu mang, bing alibu taininau manadi. Alali bing namua naga mana hanaunaunga longgalo Moses bungdi, xaung namua naga mana haruanga longgalo Urana lipuxing suxunguxunguamdi dibungdi waleu. ");
INSERT INTO met_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Sanga ba aluxu Urana Yonggaxinia mana xalu hisianganoa ing ganina. Daxanga ila long hanggalangiangamia tubu, xaluxinoa sabanga, saing lipu xumana diluxu mana. ");
INSERT INTO met_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ning xalua ila walinga bing kaxukang sibuna, saing daxanganoa makasa mana lipudi dinaxu mana, saing lipu unrangina ing ganina disok mana. ");
INSERT INTO met_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Amaxania mana lipudi dilangua duwa Urana lipuxing suxunguxunguamdi. Dima ranguang daharua haruanga xai sibuna bu dituxu murak mang. Ding bila koma abungindi disau sipsip sanggadingdi bu dila haxek mana sipsipdi bu dahanggalangiadi. ");
INSERT INTO met_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bagula axabia dilangua baru? Ahatumia xaidi. Sanga ba axabiadi mana maradingdi. Lipudi dikiri wawai mana waxu ruxunamdi te, dikiri unggak mana axexu te. ");
INSERT INTO met_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Bila balau, xai xai ua marang xaidi, ne xai diana ua marang diandi. ");
INSERT INTO met_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Xai xai sanga ba ua marang diandi te, saing xai diana sanga ba ua marang xaidi te. ");
INSERT INTO met_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Baing xai longga dua marang xaidi te, dituidi mari saing ditingdi mala yabia. ");
INSERT INTO met_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Baing ina naga, bila abagu xai marandi saing axabia xaiya na bila baru, baing sanga ba axabia lipudi mana kuboludingdi xauna. ");
INSERT INTO met_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Lipu longgalo duxu nga ba, ‘Toxoratamona ngayua,’ bagula diluxu Long Xaiya Yonggaxinia te. Tegu. Lipu gaxarea dilibu Tibugu wa long xaiya murunganoa ing ganina bagula diluxu. ");
INSERT INTO met_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mana Xaidap Suxuyangam lipu xumana bagula daharua nanga ba, ‘Toxoratamona ngayua! Am gaxap Urana suxungunoa saing am gabaxanga yamia, saing mana yama am gasuka xaungadi mala xaung am galibu axamang haringing xumana yamia!’ ");
INSERT INTO met_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Baing bagula ngabaladi rangrang ba, ‘Ngaxabiang te. Asauya nga alauba, ang lipu kubolu dianamdi!’ ");
INSERT INTO met_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Binabu lipudi dilungu haruangagudi saing dilibudi, ding bila lipu xabianga maringinam tongtongia numanoa etua long sianggamia. ");
INSERT INTO met_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kuya mu, langa si, saing yanga yubua sabanga mana numa ba, ne galaina mari te, namua na tuxadi dili etua mana siangdi. ");
INSERT INTO met_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ne lipudi dilungu haruangagudi saing dilibudi te, ding bila lipu kakahana tongtongia numua etua ulangulangia. ");
INSERT INTO met_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kuya mu, langa si, saing yanga yubua sabanga mana numa ba, saing galaina mari xaung bibinga sabanga.” ");
INSERT INTO met_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Bungina Yesu sahi haruanganoa, burangadi dihixi mana tubatubainganoa, ");
INSERT INTO met_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","namua na tubatubadi xaung haringinga sibuna, bila lipuxiding hanaunaunga tubatubainganamdi te. ");
INSERT INTO met_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu yunga xaxagana saing ri mala, baing buranga sabangadi disu mana. ");
INSERT INTO met_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Lipu saksaxam tela ma saing gung king tuxundi mari maxania saing harua ba, “Toxoratamona, nabu ung murum, ung sanga ba usahi busingagua bu ngasok sigixinga.” ");
INSERT INTO met_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Baing Yesu ta rimanoa mala saing ring. Bala ba, “Nga murugu, usok sigixinga!” Hata sibuna li businga saksaxa sup mana. ");
INSERT INTO met_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Baing Yesu harua na ba, “Labu ubala lipu tela manau tai. Ne muga ula, uhatangaung na lipu hananiangama. Hatata usok xai, bing usina hananianga mana sigixingama bila Moses hanaunau ba, binabu lipudi bagula daxabia ba busingama sup.” ");
INSERT INTO met_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Bungina Yesu luxu long sabangga Kaperneam, Rom lipu haungingam 100 yanamiding tela ma rangua, saing xusunga mana haulingua. ");
INSERT INTO met_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Harua ba, “Toxoratamona, lipuxigu oxata olanggam kinu uxaingia, king rimandi dahamati, saing salak sabanga xap.” ");
INSERT INTO met_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu harua na ba, “Bagula ngama ngasahi businganoa.” ");
INSERT INTO met_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ne Rom lipu haungingam 100 yanamidinga haxuya na ba, “Toxoratamona, nga lipu xai te sanga mana uluxu numagia. Ne usina haruanga ing ganina baing lipuxigu oxata olanggam bagula sok xai muli. ");
INSERT INTO met_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngaxabiau, namua na nga xauna ngawa hawa mana lipuxigu yayamdi, saing lipu haungingam duwa hawa manga, disu mana haruangagua xauna. Ngabala tela ba, ‘Ula,’ saing ila. Ngabala tela ba, ‘Uma,’ saing ma. Ngaharua na lipuxigu oxata olanggama ba, ‘Ulibu bila li,’ saing libu.” ");
INSERT INTO met_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu lungu laing sup, saing hixi mana. Harua na lipudi disu mana ba, “Maxung sibuna ngabalang ba, hatuminga haringina li sabanga baing! Ngabagu bila li mana Isrel tela te. ");
INSERT INTO met_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ngabalang ba, Yuda Teguam xumana mana titi hataing longgalo—mana sanga karaga xaung yuwaxa—bagula dima dirung rangua Ebraham, Aisak, Yekop tung mana taungua Long Xaiya Yonggaxinia. ");
INSERT INTO met_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ne Isrel xumana—adi Urana xauxau taungua manadi—bagula tingdi mala sabasabia, labiania, longga lipudi ditang haringina saing digaxu waidingdi.” ");
INSERT INTO met_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Baing Yesu harua na Rom lipu haungingam 100 yanamidinga ba, “Ugoxoya mala numia. Bagula sok bila uhatum haringina bagula sok.” Baing ina naga, lipuxing oxatama sok xai taxa mana bungina baguba. ");
INSERT INTO met_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu ila luxu Pita numania, baing bagu Pita haininoa bauna kinu uxaingia, busi saing sanggandi disala. ");
INSERT INTO met_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu ring rimanoa saing sangga salianoa sup. Baing mesa saing xauxau angingua mana Yesu. ");
INSERT INTO met_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yambongguba baing lipudi daxap lipuadi xaungadi duwa manadi ma, baing suka xaungadi mala mana haruanganoa, saing sahi lipu busingamdi busingadingdi. ");
INSERT INTO met_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Alali libu Urana lipuxing suxunguxunguama Aisaya haruanganoa aningona: “Xap busingaradi mala saing unia busingara mauxangandi.” ");
INSERT INTO met_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu bagu buranga taxiya, baing bala lipuxindi dinaxu mana ba dikisi lang gamolingang hataina. ");
INSERT INTO met_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Baing lipu hanaunaunga tubatubainganam tela ma rangua, saing harua na ba, “Lipu Tubatubaingam, long baruamta ula mana, bagula nganaxu maung baing.” ");
INSERT INTO met_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu haxuya ba, “Koma abungindi ding ginangiding, mangdi ding numading, ne Lipua Ma Rangua Urana ina numang te ba kinu.” ");
INSERT INTO met_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Lipu tela naxu mana Yesu harua na ba, “Toxoratamona, uyunga nga bu ngala ngakimang tibugu to.” ");
INSERT INTO met_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ne Yesu bala ba, “Lipudi dahatum haringina manga te duwa bila dimati Urana maxania. Uyunga lipuadi ba dikimang matiadingdi, ne ung ba unaxu manga.” ");
INSERT INTO met_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Baing Yesu haing wagia saing lipuxindi dinaxu mana disu dahaing xauna. ");
INSERT INTO met_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Hata sibuna li, malasu sabanga mesa lang gamolingania, saing rubadi dimakmatuxuya maluxu wagia. Ne Yesu kinuʼm tabu. ");
INSERT INTO met_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Lipudi dinaxu mana dila dahaunghaung, daharua ba, “Toxoratamona, uhauliam! Tabo ba tangarauba!” ");
INSERT INTO met_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Harua nadi ba, “Baruta amaxuwa? Hatumingaim haringina kaxukana buk!” Baing mesa saing bili yanga xaung rubadi. Baing ina naga, tega manilu sibuna. ");
INSERT INTO met_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Lipuadi ba dihixi mana saing duxusunga ding ba, “Lipua li ina baru? Tabina lipudi ding ganiding te. Tabina yanga rubadi tang xauna, saing tang disu mana haruanganoa.” ");
INSERT INTO met_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu ila sok lang gamolingang hataina mana longga Gadaradi titidinga, baing lipu luwa xaungadi duwa manadi ba disok sangua guhadi gobagoba dima digugunia. Dingtang abunging sibundi, binabu sanga ba lipudi dahaxa mana daxanga ba te. ");
INSERT INTO met_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Duwagi ba, “Urana Garanoa, bagula uraxata mam? Xaidap salak sinaiginama ma teguyu, ne bola uma la li bu usina salak sabanga mam, bo?” ");
INSERT INTO met_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ne buxu nangnang bakbak sabanga tela disoya mua haxek monga. ");
INSERT INTO met_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Xaungadi duxusunga Yesu haringina ba, “Nabu usukam mala, bing usoxiam maluxuʼm buxu nangnang bakbakka ba.” ");
INSERT INTO met_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Harua nadi ba, “Tauna, alauba.” Baing ina naga, disok sangua saing diluxu mana buxudi, saing buxu nangnang bakbak longgalo diluki haringing sibuna mari long diania maluxu lang gamolingania, saing dingara langia. ");
INSERT INTO met_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Lipu buxu wasanganamdi diluki mala, dila mana longa saing dibaxanga axadi ba, dibaxanga baraxinta sok mana lipu luwa menau xaungadi duwa mana dingtang ba xauna. ");
INSERT INTO met_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Baing lipu longgalo mana longga ba disok ma bu dibagu Yesu. Dibagu laing sup, baing duxusunga haringina ba sauya titidinga. ");
INSERT INTO met_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu haing wagia. Dikisi lang gamolingana saing diri yabania. ");
INSERT INTO met_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Lipu teladi daxap lipu tela king rimandi dahamati ba ma rangua, kinu uxaingia. Yesu bagu hatumingading haringina, baing harua na lipu king rimandi dahamati ba, “Garagua, gamoma sanga ba wa mosiu! Kubolum diandi disup.” ");
INSERT INTO met_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ne lipu hanaunaunga tubatubainganam teladi daharua nading ba, “Lipua li harungia Urana!” ");
INSERT INTO met_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu xabia hatumingadinga, binabu xusungadi ba, “Baruta ahatum diana gamoimia bila ba? ");
INSERT INTO met_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Baru haruanganta mosiu mana ngaharua: ‘Kubolum diandi disup’ kimbo ‘Umesa uhaxa’? ");
INSERT INTO met_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ning hatata bagula ngahatanga nang ba Lipua Ma Rangua Urana ina sanga haringinga etua mana titia li bu yunga kubolu diandi.” Saking harua na lipua king rimandi dahamati ba, “Umesa, oxop uxaingama saing ula numia.” ");
INSERT INTO met_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Baing ina naga, lipua mesa saing ila numania. ");
INSERT INTO met_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Buranga dibagu, baing dihixi mana. Baing diti Urana yanoa mana sina haringinga sabanga xaung yaya na lipu tela bu libu bila ba. ");
INSERT INTO met_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu sauya longga ba, saing haxa mala. Baing bagu Matyu rung mua numa takis xabinganamia. Yesu bala ba, “Unaxu manga.” Baing ina naga, Matyu mesa saing naxu manauba. ");
INSERT INTO met_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Matyu xusunga Yesu gabu lipuxindi dinaxu mana ba dima daxang rangua. Baing lipu takis xabinganam xumana digabu lipu kubolu dianam xumana dima xauna. ");
INSERT INTO met_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisidi dibagu, baing duxusunga lipuxindi dinaxu mana ba, “Baruta lipuxim tubatubaingama xang rangua lipu takis xabinganamdi xaung lipu kubolu dianamdi?” ");
INSERT INTO met_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu lungu haruanga baguba, baing harua ba, “Lipu baxiamdi dahauli lipu businga teguamdi te. Tegu. Dahauli lipu busingamdi.” ");
INSERT INTO met_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Harua muli ba, “Ala atubatuba mana Urana Xuanoa li namuxinoa: ‘Nga murugu mana ausinga lipudi. Nga murugu mana hananiangadi te.’ Namua na ngama ba ngawagi lipu maringindi te. Tegu. Ngama ba ngawagi lipu kubolu dianamdi.” ");
INSERT INTO met_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kimuya Lipu Suguangama Yon lipuxindi dinaxu mana dima rangua Yesu saing duxusunga ba, “Bunging xumana am xaung Parisidi am gasaha mana angingua bu am gahatanga ba am gabo ba Urana yaha mam, ning lipuximdi dinaxu maung ba tegu. Baruta?” ");
INSERT INTO met_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu haxuya ba, “Nabu lipu tela hatata bo ba yau. Riandi sanga ba dusinga bungina wauyu ranguadi baru? Tegu. Kimuya bungina lipu teladi daxap lipua ba mala sangua ding, mana bungina baguba bagula disaha mana angingua.” ");
INSERT INTO met_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Lipu tela labu raga imang hataing xabatingang tela mana imang muganguau tai, namua na bungina damia, hataina ba bagula xating saing sing imang mugangua, saing singingua bagula tubu. ");
INSERT INTO met_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ne lipudi labu digua wain hauna mari mana meme sanggang mugangadiu tai. Nabu dilibu bila ba, bing wain hauna bagula sing saha meme sanggandi, wain bagula matuxuya masup mari, saing meme sanggandi bagula didoa. Tegu. Wain hauna bing digua mari mana meme sanggang haundi. Binabu dingtang xauna duwa xai.” ");
INSERT INTO met_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu harua muauyu, baing lipu yayam tela ma gung king tuxundi maxania saing harua ba, “Nanuhangigua hatata sibuna li mati. Ne uma uta rimama mana, baing bagula wa muli.” ");
INSERT INTO met_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu mesa saing ila rangua, lipuxindi dinaxu mana xauna. ");
INSERT INTO met_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Hata sibuna li haing tela siba ri mua mana niani 12 ma sok ubunia. Harua naina ba, “Nabu ngaring imanginoa ing ganina, bagula ngasok xai muli.” Binabu ring imanging sihinoa. ");
INSERT INTO met_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu xugia mala rangua saing bagu. Harua ba, “Nanuhangigua, gamoma sanga ba wa mosiu. Hatumingam haringina hamaringiaung.” Baing haingga ba sok xai taxa mana bungina baguba. ");
INSERT INTO met_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Bungina Yesu luxu lipu yayam numania, bagu lipu panggeriang yubinganamdi diyup olai usingangamdi digabu buranga dibibi sabanga. ");
INSERT INTO met_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Harua ba, “Asauya. Haing nanunoa mati te, kinuʼm tabu ing ganina.” Ne dimasisia. ");
INSERT INTO met_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kimuya mana ditadi sabasabia, Yesu luxu mala saing tuxu rimanoa, saing haing nanuna ba mesauba. ");
INSERT INTO met_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Naxuyanga li sup mala titia baguba. ");
INSERT INTO met_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu sauya longga baguba, baing lipu luwa maxa haxatiandi tang disu mana, saing duwagi ba, “Xaitamoxi Debit Garanoa ba, usingamtam!” ");
INSERT INTO met_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Diluxuʼm numa wa mana ba, baing Yesu xusunga dingtang ba, “Tang gahatum haringina ba sanga ba ngahamaringangtang?” Tang dahaxuya ba, “Toxoratamona, wane!” ");
INSERT INTO met_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Baing ring tang maxadingdi saing harua ba, “Mana namua ahatum haringina ba, bing bagula maxaimdi disok xai.” ");
INSERT INTO met_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Baing maxading daxaxa ding, saing tang dibagu muli. Baing Yesu baladi haringina ba, “Labu tang gaharua na lipu tela mana baguliu tai.” ");
INSERT INTO met_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ning tang disok dinaxuya naxuya mauli mana titia ba hataing longgalo. ");
INSERT INTO met_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tang disok mala, baing lipu tela xaunga wa mana xaung sanga ba harua tate daxap ma rangua Yesu. ");
INSERT INTO met_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu suka xaungua mala masup, baing lipua menau mumguti ba harua. Baing buranga dihixi mana, daharua ba, “Waleu ma, axamang tela bila li sok Isrel te.” ");
INSERT INTO met_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ne Parisidi daharua ba, “Suka xaungadi mala mana xaungadi yanamidinga haringinganoa.” ");
INSERT INTO met_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu haxa mauli mana titia ba long sabangadi long kaxukandi, tubatuba maluxuʼm Yudadi sabungading numandi, saing baxanga baxanga ulek xaiyua mana Urana Yonggaxinoa. Saing hamaringia businga xangxang longgalo. ");
INSERT INTO met_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Bungina bagu burangadi, usingadi namua na mauxangandi daxapdi xaung sanga ba dahauli ding te, bila sipsipdi doxola mana lipuxiding wasangama. ");
INSERT INTO met_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Baing harua na lipuxindi dinaxu mana ba, “Lipudi daxauxau masup ba dilungu haruangagua bila xauyanga sabanga wa umangia, ne lipu oxatam xumana buk te. ");
INSERT INTO met_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Binabu asabu na umanga Moxonoa ba soxi lipu oxatamdi mala bu daxauya umanganoa.” ");
INSERT INTO met_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu wagi lipuxing 12 dinaxu mana ba dima rangua saing sina yaya nadi bu disuka xaungadi mala xaung bu disahi businga xangxang longgalo. ");
INSERT INTO met_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aposel 12 ba yadingdi bing: muga, Saimon (duxu ba Pita), kixinginoa Andru, Yems (Sebedi garanoa), kixinginoa Yon, ");
INSERT INTO met_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip, Bartolomyu, Tomas, Matyu (lipu takis xabinganama), Yems (Alpias garanoa), Tadias, ");
INSERT INTO met_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon (duxu ba Selat, namua na bakbagindi dibo ba disuka Romdi mala), Yudas Iskariot (ina ta Yesu bixuandi rimadingia). ");
INSERT INTO met_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu soxi aposel 12 mala xaung hanaunaunga bagudi li: “Labu ala rangua Yuda Teguamdi kimbo longgadi mana Samariadiu tai. Tegu. ");
INSERT INTO met_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ala rangua Isreldi—Urana sipsibindi dahanggalang. ");
INSERT INTO met_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ala abaxanga nadi haruanga baguli: ‘Long Xaiya Yonggaxinoa wa haxek ba.’ ");
INSERT INTO met_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ahamaringia lipu busingamdi, alibu matiadi ba dimesa muli, ahamaringia lipudi saksaxa xapdi ba, saing asuka xaungadi mala. Haulingua axap rangua Urana, axap olang. Binabu asina haulingua olang na lipudi xauna. ");
INSERT INTO met_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Labu arai sianga ranguanggu tai—gol te, silba te, kimbo siang tela te. ");
INSERT INTO met_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Labu arai tanga, imang tela muli, xai sanggandi muli, kimbo tukiu tai. Labu axapdi malau tai, namua na lipudi dituxu oxatua bing sanga ba daxap haulingua rangua lipuadi dahaulidi. ");
INSERT INTO met_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Long sabanga long kaxukang baruamta aluxu mana, bing asai mana lipu xai maringing tela wa la ba, saing awa mana numanoa laing ayunga longga baguba. ");
INSERT INTO met_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bungina aluxu numa tela, bing axusunga Urana ba libu xai mana lipuadi duwa mana numa ba. ");
INSERT INTO met_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nabu lipuadi duwa mana numa baguba daxai, bing Urana bagula libu gamogamu mosiu wa ranguadi. Nabu daxai te, bing Urana bagula ta gamogamu mosiu goxoya ma muli ranguang. ");
INSERT INTO met_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nabu lipu teladi daxapkang te, kimbo dilungu haruangaima te, bungina asauyadi bing atingting gagapdi duwa kim lunia mala bu daxabia ba duwa haruangia. ");
INSERT INTO met_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Maxung sibuna ngabalang ba, mana xaidap suxuyangama, salaga lipuadi duwa mana longga ba bagula daxap, bagula sabanga mana salaga long sabanggadi Sodam xaung Gomora daxap. ");
INSERT INTO met_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Bagu ngasoxiang mala bila sipsipdi dila liwe mana koma abungindi. Binabu amaxania bila moxadi dimaxania mana bixuadingdi, saing alibu kubolu xai bila baxalikudi. ");
INSERT INTO met_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Xauna, amaxania mana lipudi. Bagula dituxuang, ditang kaunsilidi rimadingia, saing bagula digusiang mana Yudadi sabungading numandi. ");
INSERT INTO met_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bagula daxapkang mala haruangia gabanadi xaung xaitamoxidi maxadingia namua na anaxu manga. Ne alaba ganangana mana abaxanga nga nadi xaung Yuda Teguamdi. ");
INSERT INTO met_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ne bungina daxapkang, labu ahatum xumanau tai mana haruanga baruamta bagula aharua. Urana bagula sina haruanga nang taxa mana bungina baguba. ");
INSERT INTO met_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Namua na ang sibuim bagula abaxanga te. Tegu. Tibuim Aningonoa bagula baxanga suxunguimia. ");
INSERT INTO met_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Lipudi bagula dita sabangadingdi, kixingidingdi haruangia bu lipudi dungdi mati. Baing tibudingdi bagula dilibu kubolu taininau mana garadingdi. Garadingdi bagula disok bixua mana baudingtibudingdi saing disinadi na lipudi bu dungdi mati. ");
INSERT INTO met_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Lipu longgalo bagula hauxading sibuna mang, namua na yagua wa ranguang. Ne lipu gaxarea dili haringina laing xaidabiding matiama, Urana bagula xapdi muli. ");
INSERT INTO met_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bungina axap salaga mana long tela, bing agiti mala mana long tela. Maxung sibuna ngabalang ba, Lipua Ma Rangua Urana bagula goxoya ma muga mana asup mana ala mana long taining tainina maluxuʼm Isrel. ");
INSERT INTO met_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Lipua wa tubatubaingia yanoa dali lipuxing tubatubaikkam yanoa te. Lipu oxata olanggam yanoa dali lipuxing haringinoa yanoa te. ");
INSERT INTO met_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Lipua wa tubatubaingia ba wa bila lipuxing tubatubaikkama bing sanga ba. Lipu oxata olanggama wa bila lipuxing haringina bing sanga ba. Baing nga ba nga bila numa moxona saing duxu nga ba Belsabul, binabu bagula daharungiang sibuna ang lipu numaguamdi! ");
INSERT INTO met_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ning labu amaxuwa manadiu tai. Namua na axamang longgalo duwa ulumia bagula disok sabasabia, saing axamang longgalo dihisa bagula disok menea. ");
INSERT INTO met_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Bila balau, baru haruanganta ngabalang labiania, bing aharua luliania. Baru haruanganta ngahabolabola tangaimliania, bing awagi gananga liwe. ");
INSERT INTO met_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Labu amaxuwau tai mana lipuadi dibo ba dung sanggaimdi mati. Sanga ba dahanggalangia aningoimdi te. Ning amaxuwa mana ina sanga ba hanggalangia aningoningo sangga tang long salakkamia. ");
INSERT INTO met_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mangdi axamang olangdi. Sanga ba agim luwa mana siang kaxukang mukiring tela. Ne bungina mang tela xung mati mari titia, Tibuim xabiau. ");
INSERT INTO met_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Urana xabia axamang longgalo duwa mang xauna. Xabia toxoloim baru duwa mana toxoimdi! ");
INSERT INTO met_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Baing ina naga, labu amaxuwau tai. Adali sibuna mangdi Urana maxania. ");
INSERT INTO met_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Lipu gaxarea dibaxanga na lipudi ba dinaxu manga, bing bagula ngabaxanga Tibugu wa long xaiya maxania ba ding ngayuadi. ");
INSERT INTO met_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ne lipu gaxarea dahatiam manga lipudi maxadingia, bing bagula ngahatiam manadi Tibugu wa long xaiya maxania. ");
INSERT INTO met_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ahagaxa ba ngama bu ngaxap gamogamu mosiama ma titia? Tegu. Ngama bu ngaxap gamogamu mosiama ma te. Ngama bu ngaxap waxang sabanga ma. ");
INSERT INTO met_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Namua na ngama bu ngaxugia “ ‘lup teladi bixuading mana tibudingdi, haing teladi bixuading mana baudingdi, haing yaungamdi bixuading mana ayuading baudingdi. ");
INSERT INTO met_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Bixuaimdi bagula duwa lipu numaimgamdi!’ ");
INSERT INTO met_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Lipu gaxarea muruding sibuna mana tibuding kimbo bauding sabanga manga, bing daxai te ba ditaga rangua nga. Kimbo nabu lipu gaxarea muruding sibuna mana garading lupdi kimbo nanuhangidingdi sabanga manga, bing daxai te ba ditaga rangua nga. ");
INSERT INTO met_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Lipu gaxarea doxoxi xaiding balingama saing dinaxu manga te, bing daxai te ba ditaga rangua nga. ");
INSERT INTO met_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Lipu gaxarea dituxu haringina walingadinga, bing bagula dahanggalang. Ne lipu gaxarea diyunga walingadinga bu dinaxu manga, bing bagula daxap walinga sibuna. ");
INSERT INTO met_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Lipu gaxarea daxapkang, bing daxap nga. Saing lipu gaxarea daxap nga, bing daxap ina soxi nga ma ba. ");
INSERT INTO met_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Lipu gaxarea daxap Urana lipuxing suxunguxunguam tela namua na ina Urana lipuxing suxunguxunguama, bing bagula daxap Urana lipuxing suxunguxunguam haxuyanganoa. Saing lipu gaxarea daxap lipu maringing tela namua na ina lipu maringina bagula daxap lipu maringina haxuyanganoa. ");
INSERT INTO met_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Baing nabu usina xuba lang xaringanam na lipuxigudi dinaxu manga yaya teguam tela namua na ina lipuxigua naxu manga, bing maxung sibuna ngabalang ba, Urana bagula haxuya naung.” ");
INSERT INTO met_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu hanaunau lipuxing 12 dinaxu mana ba masup, baing ila bu tubatuba xaung baxanga mana longgadi Galili. ");
INSERT INTO met_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yon wa salak yabania, saing bungina lungu oxata Kristo libu ba, soxi lipuxindi dinaxu mana mala ");
INSERT INTO met_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","bu duxusunga ba, “Ung ba, ung lipua Urana mogu ba ma, kimbo am garagu mana telauyu?” ");
INSERT INTO met_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu haxuya ba, “Ang gagoxoya mala rangua Yon saing anaxuya mana axadi alungudi abagudi ba: ");
INSERT INTO met_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Lipu maxa haxatiandi dibagu muli, lipuadi kidingdi didoa dahaxa muli, lipu saksaxamdi busingading disup, lipu tangalia haxatiandi dilungu muli, matiadi dimesa muli, xaung lipu haxugindi dilungu ulek xai baxanganganoa. ");
INSERT INTO met_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Lipu gaxarea dibagu nga saing hatumingading haringindi xungdi mari te, bing bagula Urana guxamdi.” ");
INSERT INTO met_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yon lipuxindi dinaxu mana dilauba, baing Yesu ungguti harua na buranga mana Yon, harua ba, “Bungina ala long xoliania ba abagu Yon waleu, asaiʼm lipua na bila baru? Bola asaiʼm rambuk tela yanga lili? Tegu. ");
INSERT INTO met_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ne ala asaiʼm lipua na bila baru? Bola lipu tela sau imang gumangindi? Tegu. Bagu lipuadi disau imang gumangindi duwa mana numa xaitamoxiamdi. ");
INSERT INTO met_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ne ala asaiʼm lipua na bila baru? Urana lipuxing suxunguxunguam tela? Ina naga. Ne ngaharua maxung sibuna nang, Urana lipuxing suxunguxunguama Yon dali adi duwa waleu. ");
INSERT INTO met_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ina naga waleu sibuna Malakai bung mana bungina bung haruanga Urana harua na Lipuxing Mogunganama, harua ba: “ ‘Bagu bagula ngasoxi lipuxigu ulekkama muga naung, bu hamaringia daxangama ila muga maung.’ ");
INSERT INTO met_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Maxung sibuna ngabalang ba, mana lipu longgalo duwa waleu ma ba, bing tela dali Lipu Suguangama Yon te. Ning lipu gaxarea daxap yaya kaxukang sibuna maluxu Long Xaiya Yonggaxinia, ding didali Yon. ");
INSERT INTO met_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Baing mana waleu Lipu Suguangama Yon ungguti baxanga laing hatata, lipudi dahaxi sibuna saing dahaung ba diluxu Long Xaiya Yonggaxinia. ");
INSERT INTO met_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Namua na muga mana Yon ma, Urana lipuxing suxunguxunguam longgalo xaung hanaunaunga Moses bung, ding dibagu ma laing bungina hatata. ");
INSERT INTO met_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Baing nabu sanga ba axap haruangagua, bing bagula abagu Yon ina Elaitsa, lipua dibaxanga ba bagula ma. ");
INSERT INTO met_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Lipu gaxarea tangadingliana, bing dilungu haruanga baguli. ");
INSERT INTO met_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Bagula ngating haruanga babung baruamta mana lipu hatatam kuboludinga? Ding bila garadi dahali nawa yabania, digamia riadingdi ba: ");
INSERT INTO met_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ ‘Am gayup olai yahangamdi mana panggeriang mang, ne asiga te. Am gawaya olai matiam, ne atang te.’ ");
INSERT INTO met_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Bila balau, ayaha mana Yon tam te! Ahatumia, Yon ma saing xang salanga te, nung wain te, ne daharua ba, ‘Xaunga wa mana!’ ");
INSERT INTO met_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Lipua Ma Rangua Urana ma saing xang nung, ne daharua ba, ‘Abagu, lipua lo xang xaung nung wain buk, saing wa lipu takis xabinganamdi xaung lipu kubolu dianamdi riadinga!’ Ne lipuadi dahatum sibuna mana kuboluadi Yon tam galibudi, bagula dibagu daxabia ba tam gasu mana xabianga maringina.” ");
INSERT INTO met_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mana long sabanga teladi Yesu libu axamang haringing xumana, ne duxugia hatumingadingdi te. Binabu mana bungina baguba gamiadi. ");
INSERT INTO met_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Harua ba, “Korasindi, laku, mauxanganoa xapkang yu! Betsaidadi, laku, mauxanganoa xapkang yu! Axamang haringindi disok liwe mang, nabu waleu sibuna disok liwe mana Tayadi xaung Saidondi, bing ding sanga ba duxugia hatumingadingdi, disau imang usingangamdi saing dirung hayatia lo. ");
INSERT INTO met_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ne ngabalang ba, mana xaidap suxuyangama, salaga axap bagula sabanga mana salaga Taya, Saidon daxap. ");
INSERT INTO met_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ne ang Kaperneamdi ba, bola bagula ditiang eta lo sibuna? Tegu sibuna. Bagula ari hawa sibuna Matiadi Yabadingia. Axamang haringindi disok liwe mang, nabu waleu sibuna disok liwe mana Sodam, bing long sabangga ba sanga ba wa laing xaidapka baguli. ");
INSERT INTO met_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ne ngabalang ba, mana xaidap suxuyangama, salaga axap bagula sabanga mana salaga Sodam daxap.” ");
INSERT INTO met_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mana bungina baguba, Yesu harua ba, “Tibugu, Toxoratamona mana sabalunoa xaung titia, ngaiti yama namua na uyameng axadi li mana lipuadi dahatumia ba daxabia xai buk, saing uhatangadi na lipuadi duwa bila garadi ba. ");
INSERT INTO met_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Maxuna, Tibugu, ulibu bila ba namua na alali ung murungama xai. ");
INSERT INTO met_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tibugu ta axamang longgalo rimagia ba. Lipu tela xabia Gara te. Tibugu ing ganina xabiau. Baing lipu tela xabia Tibugu te. Garanoa ing ganina xabiau. Garanoa xaung lipu gaxarea Garanoa mogudi ba daxap xabianga mana. ");
INSERT INTO met_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ama rangua nga, ang gaxarea haringingaimdi disup xaung axoxi mauxangandi, baing bagula ngasina yaguangua nang. ");
INSERT INTO met_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Ngabo ba ngahauliang ba taxoxidi, bila bapalo luwa duwaxata xauna mana xai taininau digoxi mana dingtang. Sanga ba amakasa mana alibu axadi ngaxusungang ba alibu manga te. Axap tubatubaingagua ata gamoimia saing asu mana haruangagua, namua na nga lipu xaringana saing ngatatua nga. Alibu bila ba bing bagula aningoimdi duwa mosiu.” ");
INSERT INTO met_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mana bungina baguba, mana Xaidap Yaguangam tela, Yesu gabu lipuxindi dinaxu mana dahaxa makisi mana wit umangang tela. Lipuxindi dinaxu mana gesagiding, binabu dungguti daxauya wit marang teladi saing daxangdi. ");
INSERT INTO met_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Parisidi dibagu, baing daharua na ba, “Ubagu! Lipuximdi dinaxu maung dilibu oxata hanaunaungaradi dibili kira ba talibu mana Xaidap Yaguangama.” ");
INSERT INTO met_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu haxuya ba, “Axa mugangaroa Debit libu waleu, atiti ba ne baruta ahatumia te? Mana bungina ina gabu guguniangandi gesagiding ba. ");
INSERT INTO met_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Luxu Urana Numania, saing gabu guguniangandi daxang salanga dita Urana maxania. Anginga baguba bilingam. Lipu hananiangam ding ganiding sanga ba daxang. ");
INSERT INTO met_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Xauna, Xaidap Yaguangam hanaunaunganoa atiti ba ne baruta ahatumia te? Bungina lipu hananiangamdi dituxu oxatadinga Urana Numania didali hanaunaunga baguba, ne dilibu kubolu diana Urana maxania te, namua na sina oxata ba nadi. ");
INSERT INTO met_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ngabalang ba, lipu tela wa la li yanoa dali Urana Numang yanoa! ");
INSERT INTO met_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bing ahatumia Urana haruangana baguli: ‘Nga murugu mana ausinga lipudi. Nga murugu mana hananiangadi te.’ Nabu axabia rangrang haruanga baguba namuxina, bing sanga ba asu haruanga na lipuxigudi dinaxu manga te. Ding dilibu kubolu dian tela Urana maxania te. ");
INSERT INTO met_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Lipua Ma Rangua Urana wasa mana Xaidap Yaguangama, binabu sanga ba nai mana baru kubolunta lipuxindi dilibu mana.” ");
INSERT INTO met_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu sauya longga baguba, saing ila luxu Yudadi sabungading numania. ");
INSERT INTO met_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","La ba bagu lipu tela rimanoa mati saing toatuana. Parisidi disai daxanga tela ba dita Yesu haruangia, binabu duxusunga ba, “Hanaunaunga harua ba sangau mana tahamaringia lipudi mana Xaidap Yaguangam?” ");
INSERT INTO met_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Harua nadi ba, “Nabu angia tela sipsibinoa xung mari banggumia mana Xaidap Yaguangam, bing xai mahaing, maxuna? ");
INSERT INTO met_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ne lipu walinganoa sabanga mana sipsip walinganoa! Wane, tasu mana hanaunaunga bungina talibu kubolu xai mana Xaidap Yaguangam.” ");
INSERT INTO met_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Baing harua na lipua ba, “Uraria rimama.” Baing ina naga, raria rimanoa saing sok xai dup, bila tela baing! ");
INSERT INTO met_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ne Parisidi disok sangua saing digugunia bu disai daxanga tela bu dung Yesu mati. ");
INSERT INTO met_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ne Yesu xabia hatumingadinga. Binabu sauya longga ba, saing lipu xumana disu mana. Hamaringia lipuxiding busingam longgalo, ");
INSERT INTO met_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ne bilidi ba dinaxuya mana ina gaxarea. ");
INSERT INTO met_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Alali libu Urana haruanganoa lipuxing suxunguxunguama Aisaya bung ba aningona: ");
INSERT INTO met_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Bagu lipuxigu oxatama, ina ngamogu ba. Nga murugu sibuna mana, ngayaha sibuna mana. Bagula ngata Aningogua maluxu mana, saing bagula habingia ba Urana bagula suxuya numanumadi maringina. ");
INSERT INTO met_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Bagula hakhaxi kimbo xaba sabanga te, bagula tubatuba xaung haruanga sabanga daxangia te. ");
INSERT INTO met_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Bagula tatua lipudi haringingading teguamdi bila hamunanggia rambukdi te, baing bagula taxiti haxugindi haruangadinga bila ung nagunga mati te. Bagula libulibu kubolunoa laing xaiyua dali dianoa. ");
INSERT INTO met_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Baing ina naga, numanumadi bagula dahatum haringina diragu ba libu axamang xaidi manadi.” ");
INSERT INTO met_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mana bungina baguba lipu tela xaunga wa mana xaung sanga ba harua bagu tate daxap ma rangua Yesu. Hamaringia binabu harua muli xaung bagu muli. ");
INSERT INTO met_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Buranga dihixi mana, saing duxusunga ding ba, “Bola lipua li Xaitamoxi Debit Garanoa, Urana Lipuxing Mogunganama?” ");
INSERT INTO met_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ning Parisidi dilungu haruanga baguba, baing daharua ba, “Belsabul, xaungadi yanamidinga, ing ganina sina haringinga na lipua li bu suka xaungadi mala.” ");
INSERT INTO met_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu xabia hatumingadingdi, binabu harua nadi ba, “Nabu yongga tela dutu ding, bing bagula dahanggalang. Nabu long sabanga tela kimbo numa tela dutu ding, bing bagula disup. ");
INSERT INTO met_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ne nabu Satan suka Satan mala, bing utuina, haunggana ina baing. Yonggaxinoa sanga ba li te. ");
INSERT INTO met_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ang gaharua ba ngasuka xaungadi mana yanamidinga Belsabul haringinganoa. Ne ang lipuximdi dinaxu mang, disuka xaungadi xauna. Ne disukadi mana gaxarea haringinganoa? Bola aharua ba Belsabul haulidi xauna? Baing ina naga, lipuximdi dinaxu mang oxatadinga ba hatanga haruangaima asu manga ba maring te. ");
INSERT INTO met_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ne mana namua ngasuka xaungadi mana Urana Aningong haringinganoa, bing hatanga ba Urana Yonggaxinoa ma, sok mang. ");
INSERT INTO met_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Kimbo, lipu tela sanga ba luxu lipu haringingam numania bila Satan numanoa saing hanai xalingindi olang te. Tegu. Muga bing goxigoxi to. Tauna, hanai numania. ");
INSERT INTO met_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Lipu gaxarea dirau nga te, bing bixuagudi. Lipu gaxarea duwaxata rangua nga te bu am gaxai lipudi mala rangua Urana, bing disukadi mala sangua Urana. ");
INSERT INTO met_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Baing ina naga, ngabalang ba, kubolu diang longgalo xaung haruanga diang longgalo daharungiadi mana Urana, ina sanga ba yungadi, ning kubolua harungia Urana Aningonoa, bing bagula yunga te. ");
INSERT INTO met_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Baing lipu gaxarea daharua diana mana Lipua Ma Rangua Urana, bing Urana bagula yunga kuboluding diandi. Ning lipu gaxarea daharua diana mana Urana Aningonoa, bing bagula yunga kuboluding dianoa te, mana xaidapkadi bagudi li, kimbo bunging kimuam sibuna ma yu. ");
INSERT INTO met_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Sanga ba taxabia xaidi mana maradingdi. Nabu xai tela xai, bing marandi bagula daxai. Nabu xai tela diana, bing marandi bagula didoa. ");
INSERT INTO met_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ang bila moxa diang gugunianga tela! Ang lipu diandi sanga ba aharua haruanga xai tela baru? Namua na lipu suxungunoa baxanga sabasabia axadi hatuminganoa baxagi manadi ba. ");
INSERT INTO met_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Lipua xai, hatuminganoa baxagi mana hatuminga xai saing ua bila ba. Baing lipu diana, hatuminganoa baxagi mana hatuminga diana saing ua bila ba. ");
INSERT INTO met_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ne ngabalang ba, mana xaidap suxuyangama, Urana bagula libu lipudi dahatum muli mana haruangading olang longgalo daharua ba, saing bagula suxuyadi manadi. ");
INSERT INTO met_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Haruanga aharua ba bagula hatanga ba alibu diana te, saing Urana bagula harua ba awa maringina, kimbo alibu kubolu diana, saing bagula harua ba awa doa.” ");
INSERT INTO met_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Baing Parisi teladi xaung lipu hanaunaunga tubatubainganam teladi daharua na Yesu ba, “Lipu Tubatubaikkam, am gabo ba am gabagu ulibu axamang haringing tela bu hatanga nam ba Urana soxiung ma.” ");
INSERT INTO met_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ne haxuya ba, “Lipu hatatamdi diang sibundi xaung diyamu Urana namua na disaisai ba dibagu axamang haringina. Ne axamang haringing taininau ing ganina bagula dibagu ba: Bagula wa bila axamana sok mana Urana lipuxing suxunguxunguama Yona. ");
INSERT INTO met_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yona wa song sabanga gamonia xaidap tuwa yambong tuwa. Bila balau bagula Lipua Ma Rangua Urana wa titia gamonia xaidap tuwa yambong tuwa. ");
INSERT INTO met_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Waleu sibuna Yona baxanga na lipu Ninibeamdi saing duxugia hatumingadingdi. Ne hatata tela dali sibuna Yona wa la li, ne hauxaim ba axugia hatumingaimdi. Binabu bungina Urana suxuya lipudi, Ninibedi bagula dimesa saing dili Urana maxania ranguang, saing disu haruanga nang lipu hatatamdi. ");
INSERT INTO met_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Waleu sibuna Xaitamoxi Haing mana numanuma Siba ma titi subingania ma bu lungu Solomon xabiangang maringina. Ne hatata tela dali sibuna Solomon wa la li, ne hauxaim ba alungu haruanganoa. Binabu bungina Urana suxuya lipudi, haingga ba bagula mesa saing li Urana maxania ranguang, saing su haruanga nang lipu hatatamdi. ");
INSERT INTO met_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Bungina xaunga tela sok ma sangua lipu tela, ila luxu mana long xoliandi bu sai yaguanga, baing tegu. ");
INSERT INTO met_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Baing harua ba, ‘Bagula ngagoxoya mala mana numa muga ngawa mana baing.’ Bungina sok mana, bagu lipua ba wa bila numa sogoxoyangam, wa maringina ba, ne wa olang. ");
INSERT INTO met_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Baing ila xap xaunga 7 diang sibundi mana ina, dima diluxu saing duwa mana. Baing ina naga, hatata walinganoa sok doa sibuna mana muga. Alaba bagula sok mang lipu diang hatatamdi.” ");
INSERT INTO met_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu sina haruanga na lipudiyu, baing bauna gabu kixingindi dili mua sabasabia, dibo ba daharua rangua. ");
INSERT INTO met_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Lipu tela bala ba, “Baum gabu kixingimdi dili mua sabasabia, dibo ba daharua ranguaung.” ");
INSERT INTO met_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Haxuya ba, “Gaxarea baugu? Gaxarea kixingigudi?” ");
INSERT INTO met_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Baing mogu lipuxindi dinaxu mana saing harua ba, “Adi bagudi li bila baugu xaung kixingigudi. ");
INSERT INTO met_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Lipu gaxarea dilibu Tibugu wa long xaiya murunganoa bing kixingigua, hamungagua xaung baugu.” ");
INSERT INTO met_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mana xaidapka baguba, Yesu sok sangua numa ba, ila lang gamolingang rubinia saing rung mari. ");
INSERT INTO met_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Baing buranga sabangadi dima digugunia taxiya, binabu haing wagia. Baing rung mari la ba, lipudi dili titia, saing tubatubadi bila ba. ");
INSERT INTO met_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Baxanga haruanga babung xumana nadi. Tela bing: “Lipu umangam tela ila umangia bu ting wit xuyandi. ");
INSERT INTO met_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tingdi saing teladi diri daxangia, saing mangdi dima daxangxangiadi. ");
INSERT INTO met_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Teladi diri long sianggamia, mana longga titi sibun te. Dahaxa sap namua na titia ba tubu te. ");
INSERT INTO met_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ne bungina xaidaba haing, xanidi saing dimutuxu namua na oxaxadingdi diri te. ");
INSERT INTO met_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Xuyang teladi diri long waxu ruxunamia, baing disok, dihibuadi binabu oxading te. ");
INSERT INTO met_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ne xuyang teladi diri mana titi xaiya saing dua xai. Oxang tela dua 100, tela dua 60 saing tela dua 30. ");
INSERT INTO met_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Lipu gaxarea tangadingliana, bing dilungu haruanga baguli.” ");
INSERT INTO met_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Lipuxindi dinaxu mana dima rangua duxusunga ba, “Baruta uharua na lipudi mana haruanga babundi?” ");
INSERT INTO met_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Haxuya ba, “Haruanga hisangamdi mana Long Xaiya Yonggaxinoa, Urana nai ba axap xabiangua manadi baing. Ning teladi tegu. ");
INSERT INTO met_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Lipu gaxarea daxap haruangagua, Urana bagula sina xabianga tela muli nadi, saing bagula dibaxagi mana. Lipu gaxarea dilungu te, xabianga dahagaxa ba dingia, Urana bagula xap sanguadi. ");
INSERT INTO met_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Namua naga ngabaxanga haruanga babundi nadi, bu: “dibagubagu mua ne dibagu daxabia te, dilungulungu mua ne daxabia rangrang te. ");
INSERT INTO met_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Alali libu Urana haruanganoa lipuxing suxunguxunguama Aisaya bung aningona: “ ‘Bagula alungulungu mua ne axabia rangrang te, bagula abagubagu mua ne abagu axabia te. ");
INSERT INTO met_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Namua na lipuadi li hatumingadingdi diriba ding, tangadingliandi hauxading ba dilungu haruangua, saing dimatai. Nam dibagu maxadingia, nam dilungu mana tangadingliandi, nam daxabia xai hatumingadingia, nam duxugia rangua nga ba ngalibudi disok xai muli.’ ");
INSERT INTO met_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ne Urana libu xai mang. Maxaimdi dibagu daxabia, saing tangaimliandi dilungu rangrang. ");
INSERT INTO met_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Maxung sibuna ngabalang ba, Urana lipuxing suxunguxunguam xumana xaung lipu maringing xumana mugauamdi, hatumingadingdi dahaxi ba dibagu axadi abagudi, ne dibagudi te. Hatumingadingdi dahaxi ba dilungu haruangadi alungudi, ne dilungudi te. ");
INSERT INTO met_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Tauna alungu namuxina mana haruanga babuna mana lipua ting wit xuyandi: ");
INSERT INTO met_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Xuyandi diri daxangia bila lipuadi dilungu haruanga mana Yonggaxinoa saing daxabia rangrang te. Baing lipu dianoa ma unia Urana haruanganoa sangua hatumingadingdi. ");
INSERT INTO met_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Xuyandi diri long sianggamia bila lipuadi dilungu Urana haruanganoa, saing hata sibuna li daxap, gamodingdi diyaha. ");
INSERT INTO met_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ne dahatum haringina mongaita ing ganina namua na oxaxadingdi diraxap. Xungdi mari sap, bungina mauxangandi daxapdi kimbo bungina daxap salaga mana namua dahatum haringina mana Urana haruanganoa. ");
INSERT INTO met_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Xuyanadi diri long waxu ruxunamia bila lipuadi dilungu haruanganoa, ne dahatum xumana buk mana titia li mauxangandi, xaung xalaxaladi dituxu murak manadi, dihibuadi, saing marandi dua te. ");
INSERT INTO met_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ne xuyanadi diri titi xaiya bila lipuadi dilungu Urana haruanganoa saing daxabia rangrang. Oxading, saing lipu teladi dua 100, teladi dua 60, teladi dua 30, didali xuyadingdi bila ba.” ");
INSERT INTO met_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu harua haruanga babung tela muli nadi ba: “Long Xaiya Yonggaxinoa bila lipu tela ting wit xuyang xaidi umangia. ");
INSERT INTO met_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ne yambonga ma, lipu oxatamdi dikinu, baing bixuanoa ma ting tatubang diang xuyandi liwe mana witdi, saing ila. ");
INSERT INTO met_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Witdi dahaing, dibo ba oxading, baing tatubang diandi xauna dahaing. ");
INSERT INTO met_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Umanga moxona lipuxing oxatamdi dila rangua, saing daharua ba, ‘Lipu Sabanga, umanga uting wit xuyang xaidi mana baxagi mana tatubang diandi! Disok baru?’ ");
INSERT INTO met_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Haxuya ba, ‘Bixua tela libu baing!’ “Lipu oxatamdi duxusunga ba, ‘Ubo ba am gala am gaxupdi?’ ");
INSERT INTO met_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Haxuya ba, ‘Tegu. Nam axup wit oxaxandi xauna. ");
INSERT INTO met_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ayunga tang dahaing xauna laing xauyangua. Saking mana bungina baguba bagula ngabala lipu xauyangamdi ba muga digugunia tatubang diandi, dibibi tambingdi bu ditaudi, saing digugunia witdi ditadi numagu xauyanga gugunianganamia.’ ” ");
INSERT INTO met_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu harua haruanga babung tela muli nadi ba: “Long Xaiya Yonggaxinoa bila mastat xuyang kaxukang sibung tela, lipu tela xap mala xuma umangia. ");
INSERT INTO met_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kaxukang sibuna mana anginga longgalo, ne bungina haing, sok sabanga mana axamang longgalo lipudi duxumadi umangia. Haing saing sok sabanga bila xai tela, saing mangdi dima ditongtongia numadingdi mana rimandi.” ");
INSERT INTO met_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu harua haruanga babung tela muli nadi ba: “Long Xaiya Yonggaxinoa bila yis, axamana libu salanga salalanga. Hainga xap teladi saing xaningxaningdi xaung wit gagabing bori sabanga tuwa laing hasangia salanga hataing longgalo, libu salalanga.” ");
INSERT INTO met_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu harua axadi bagudi li na buranga mana haruanga babundi. Baing harua nadi sabasabia te, harua haruanga babundi ing ganina. ");
INSERT INTO met_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Alaba libu Urana lipuxing suxunguxunguam tela haruanganoa bung waleu aningona: “Bagula ngaharua nang mana haruanga babundi. Bagula ngabaxanga haruanga babundi bu ngatubatuba axadi ngayamengdi mana titi soginganoa ma laing hatata.” ");
INSERT INTO met_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tauna, yunga burangadi duwa sabasabia, saing luxu numia. Lipuxindi dinaxu mana dima rangua saing daharua ba, “Sanga ba ubaxanga haruanga babuna mana tatubang diandi duwa umangia namuxinoa nam?” ");
INSERT INTO met_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Haxuya ba, “Lipua ting wit xuyang xaidi bing Lipua Ma Rangua Urana. ");
INSERT INTO met_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Umanga bing titia, saing wit xuyang xaidi bing Long Xaiya Yonggaxing lipuxindi. Tatubang diandi bing lipu dianoa lipuxindi. ");
INSERT INTO met_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Bixua xuma tatubang diandi liwe mana witdi bing xaungadi yanamidinga. Xauyanga bing titi xaidabing subinganoa, saing lipu xauyangamdi bing Urana uleginamdi. ");
INSERT INTO met_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Bila duxup tatubang diandi saing ditaudi yabia, bagula wa bila ba mana titi xaidabing subinganoa. ");
INSERT INTO met_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Lipua Ma Rangua Urana bagula soxi uleginamdi mala, saing bagula dunia axadi dilibu kubolu diandi disok xaung lipuadi didali Urana hanaunaunganoa ba sangua Yonggaxinoa. ");
INSERT INTO met_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Baing bagula ditingdi maluxu yap saliang sibunia, longga ba lipudi bagula ditang haringina saing bagula digaxu waidingdi. ");
INSERT INTO met_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Baing ina naga, lipu maringindi bagula disaxaxangia bila xaidaba maluxuʼm Tibuding Yonggaxinoa. Lipu gaxarea tangadingliana, bing dilungu haruanga baguli. ");
INSERT INTO met_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Long Xaiya Yonggaxinoa bila xalaxala siang sabanga sibung tela hisa umangia. Bungina lipu tela bagu, yameng muli, yaha sibuna saing ila sina xalingindi masup bu gim umanga ba. ");
INSERT INTO met_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Xauna, Long Xaiya Yonggaxinoa bila lipu siang oxatanam tela sai mana saluwa guang lunam gumangindi. ");
INSERT INTO met_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bungina bagu xai sibung tela, ila sina xalingindi masup bu gim. ");
INSERT INTO met_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Xauna, Long Xaiya Yonggaxinoa bila amaga diyungia mari lang gamolingania saing daxap song xangxana. ");
INSERT INTO met_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bungina baxagi, lipu xuningamdi daxai mahaing lang rubinia. Baing dirung digugunia song xaidi mana dabadi, ne dihitixiya diandi. ");
INSERT INTO met_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Xaidap subinganoa bagula wa bila ba. Urana uleginamdi bagula dima dahata lipu diandi sangua lipu maringindi, ");
INSERT INTO met_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","saing diting diandi maluxu yap saliang sibunia, longga ba lipudi bagula ditang haringina saing bagula digaxu waidingdi.” ");
INSERT INTO met_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu xusungadi ba, “Axabia axadi bagudi li rangrang?” Dahaxuya ba, “Wane, am gaxabiau.” ");
INSERT INTO met_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Baing harua nadi ba, “Binabu lipu hanaunaunga tubatubainganam longgalo daxap tubatubaingua mana Long Xaiya Yonggaxinoa bila numa moxong tela, ina xap xalinging haundi xaung mugangadi sangua numang luna gugunia xalinging xaidi mana.” ");
INSERT INTO met_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu sahi haruanga babundi ba, baing sauya longga baguba. ");
INSERT INTO met_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ila, sok yabania Nasaret, baing ungguti tubatuba lipudi Yudadi sabungading numania, saing dihixi mana haruanganoa. Daharua ba, “Si, lipua li xap xabianga maringina li bi? Gaxarea sina haringingua na ba libu axamang haringindi bagudi li? ");
INSERT INTO met_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Lipua li, ina lipu numa tongtongianganama garanoa ing ganina, bo? Bauna yanoa Maria, kixingindi Yems, Yosep, Saimon xaung Yudas, bo? ");
INSERT INTO met_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Hamungandi duwa la li rangua kira, bo? Binabu xap xabianga xaung haringinga bagudi li bi?” ");
INSERT INTO met_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Baing gamodingdi didoa mana saing hauxading ba dahatum haringina mana. Saking Yesu baladi ba, “Urana lipuxing suxunguxunguama xap yaya sabanga mana long longgalo. Ning yabania, maluxu mana bakbagindi xaung numanoa, bing ditatua.” ");
INSERT INTO met_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Baing libu axamang haringing xumana buk la ba te, namua na dahatum haringina mana te. ");
INSERT INTO met_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mana bungina baguba Galilidi yanamidinga Herot Antipas lungu naxuyangadi mana Yesu, ");
INSERT INTO met_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","saing harua na lipuxindi disina hatuminga na ba, “Lipua li Lipu Suguangama Yon naga. Mesa muli mana matiyua! Namua naga ina sanga ba libu axamang haringinadi ba.” ");
INSERT INTO met_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herot harua bila ba namua na yau Herodias, sabanganoa Pilip haininoa. Binabu Yon hanaunau hanaunau Herot ba, “Kubolua oxop sabangama haininoa sangaʼm daxangua te.” Baing ina naga, Herot soxi lipuxing haungingamdi ba dituxu Yon, digoxi dita salak yabania, namua na bo ba libu Herodias yaha. ");
INSERT INTO met_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Bo ba ung Yon mati, ne maxuwa mana lipudi, namua na dahatum ba Yon bing Urana lipuxing suxunguxunguam tela. ");
INSERT INTO met_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ning mana xaidapka Herot hatumia nianinoa, ina tongtongia taunga, saing Herodias nanuhanginoa siga liwe manadi. Baing Herot yaha sibuna mana. ");
INSERT INTO met_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Binabu hau hatumingua rangua bu sina baraxinta xusunga mana ba na, saing xusunga Urana ba hanggalangia nabu su mana haruanganoa te. ");
INSERT INTO met_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Bauna yu nanuhanginoa binabu xusunga ba, “Ngabo ba uximguti Lipu Suguangama Yon waxungtuanoa, uta toxona minia saing oxop ma usina nanga.” ");
INSERT INTO met_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Baing xaitamoxi hatumia, ne gamonoa mauxana. Ne mana namua harua maxung sibuna lipuadi dima taungania maxadingia, baing tabina ba dilibu axa haing nanunoa xusunga mana ba. ");
INSERT INTO met_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Binabu lipu haungingama ila salak yabania saing ximguti Yon waxungtuanoa la ba. ");
INSERT INTO met_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ta toxonoa minia saing rai ma, sina na haing nanunoa, baing ina rai mala rangua bauna. ");
INSERT INTO met_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Baing Yon lipuxindi dinaxu mana dima daxap sangganoa mala, saing dikimang. Sup baing dila dinaxuya na Yesu. ");
INSERT INTO met_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu lungu haruanga mana dung Yon mati, baing sauya longga ba, gabu lipuxindi dinaxu mana dahaing wagia dila long xoliania. Ne burangadi dilungu ila ba, saing disauya long xumana, disu mana kidingia mala. ");
INSERT INTO met_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu ri titia, bagu buranga sabanga, baing gamona usingadi saing hamaringia lipuxiding busingamdi. ");
INSERT INTO met_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bungbung sibunauba, baing lipudi dinaxu mana dima rangua, saing daharua ba, “La li long olang, saing yambongguba. Usoxi buranga dila mana long teladi duwa singia bu digim anginga nading.” ");
INSERT INTO met_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu haxuya ba, “Heku. Sanga ba dila te. Ang ba auliadi bu daxang.” ");
INSERT INTO met_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Dahaxuya ba, “Am salangamam luwadi luwadi hiliadinga xaung songimam luwa ing ganina.” ");
INSERT INTO met_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Harua ba, “Axapdi ma rangua nga.” ");
INSERT INTO met_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Baing bala lipudi ba dirung tatubangia. Yesu xap salanga luwadi luwadi hiliadinga ba xaung song luwa ba saing bagu mahaing long xaiya, harua xai sibuna mala rangua Urana, saing utu sahadi. Saking sinadi na lipudi dinaxu mana, saing dituxu sinak na burangua. ");
INSERT INTO met_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Lipu longgalo daxang sanga ba. Baing lipudi dinaxu mana digugunia anginga hataindi duwauyu, digam daba 12 dibaxagi. ");
INSERT INTO met_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mana lipu longgalo daxang, lupdi titingadinga bila 5,000. Dititi haing garadi te! ");
INSERT INTO met_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sup, baing Yesu haxi lipudi dinaxu mana ba dahaing wagia, dimuga mana mala lang gamolingang rubing hatainia. Ing sibuna wa kimuya mua saing bala lipudi ba dahatibaxaya mala. ");
INSERT INTO met_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kimuya mana harua xai sibuna nadi, ing sibuna haing mala xaxagania bu sabu. Yambongguba, baing ing ganina wa la ba. ");
INSERT INTO met_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ne wagua wa hasoya tek liwe, saing yanga ma yunia saing rubadi dahaunggana. ");
INSERT INTO met_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Haxek sibuna xaidap, baing Yesu ila ranguadi, haxa tek ubunia. ");
INSERT INTO met_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Lipudi dinaxu mana dibagu haxa tek ubunia, baing dimaxuwa buk. Daharua ba, “Tauxai tela!” saing dimaxuwa sibuna daxaba. ");
INSERT INTO met_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ne hata sibuna li Yesu harua nadi ba, “Awa haringina gamoimia! Nga naga. Labu amaxuwau tai.” ");
INSERT INTO met_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Baing Pita wagi mana ba, “Toxoratamona, nabu maxung sibuna ung ba, bing ubala nga ba ngahaxa ma ranguaung tek ubunia.” ");
INSERT INTO met_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Harua ba, “Sangau, uma.” Baing Pita sauya wagua saing ri mala, haxa tek ubunia mala rangua Yesu. ");
INSERT INTO met_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ne bagu yang sabanga, baing maxuwa, saing ungguti da. Baing wagi ba, “Toxoratamona, uhauli nga!” ");
INSERT INTO met_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hata sibuna li Yesu raria rimanoa mala saing tuxuti. Harua ba, “Hatumingam haringina kaxukana buk. Baruta hatumingam luwa?” ");
INSERT INTO met_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bungina tang dahaing wagia muli, yanga mati. ");
INSERT INTO met_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Baing lipuxindi dinaxu mana duwa wagia diti yanoa. Daharua ba, “Maxung sibuna ung Urana Garanoa!” ");
INSERT INTO met_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Dikisi mala masup, baing diri titia Genesaret. ");
INSERT INTO met_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Longga ba moxondi dibagu daxabia Yesu, baing disina haruanga mala rangua lipudi duwa mana titia ba hataing longgalo. Lipudi dahau lipu busingam longgalo ma rangua, ");
INSERT INTO met_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","saing duxusunga haringina ba nai lipu busingamdi ba diring imanging sihinoa ing ganina. Baing lipu busingam gaxarea diring ba disok xai dup. ");
INSERT INTO met_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mana bungina baguba, Parisi teladi digabu lipu hanaunaunga tubatubainganam teladi diyunga Yerusalem dima rangua Yesu. Duxusunga ba, ");
INSERT INTO met_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Baruta lipuximdi dinaxu maung didali mugangaradi kuboludinga? Bungina dibo ba daxang, didamia rimadingdi maringina mana kubolua ba te!” ");
INSERT INTO met_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu haxuya ba, “Baruta adali Urana hanaunaunganoa bu asu mana mugangaradi kuboludinga? ");
INSERT INTO met_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Namua na Urana harua ba, ‘Uwa hawa mana baumtibumdi,’ xaung ‘Lipu gaxarea daharua diana na baudingtibudingdi bing dungdi mati.’ ");
INSERT INTO met_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ne ang ba, ang gaharua ba maring nabu lipu tela bala baungtibundi ba, ‘Ngausinga, sanga ba ngahauliang te. Namua na ngahau haruangua ba ngaulia Urana axadi sanga ba ngahauliang manadi.’ ");
INSERT INTO met_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Bila balau, aharua ba heku mana duwa hawa mana baudingtibudingdi. Baing ina naga, aunia Urana Xuanoa saing ata kuboluima ba xap yabanoa. ");
INSERT INTO met_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ang lipu manang luwamdi! Ang ba waleu sibuna Aisaya harua maxung sibuna mang bungina bung Urana haruanganoa mari bila li: ");
INSERT INTO met_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘Bakbakka baguli diti yagua suxungudingia ing ganina, ne hatumingadingdi duwa hasoya manga. ");
INSERT INTO met_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Disabu manga olang, namua na tubatubaingadingdi dima rangua lipudi ing ganina.’ ” ");
INSERT INTO met_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tauna, Yesu wagi lipudi dima rangua saing harua ba, “Alungu saing ahatumia xai to. ");
INSERT INTO met_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Baraxinta luxu lipua suxungunia sanga ba libu ina musuna Urana maxania te. Ne baraxinta sok sangua lipua suxungunoa libu ina musuna.” ");
INSERT INTO met_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Baing lipudi dinaxu mana dima rangua saing duxusunga ba, “Bola uxabia ba Parisidi dilungu haruangama saing gamodingdi didoa mana?” ");
INSERT INTO met_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Haxuya ba, “Parisidi ba bila xauyangadi Tibugu wa long xaiya xumadi te, saing bagula xup ding longgalo. ");
INSERT INTO met_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Asauyadi. Ding bila lipu maxa haxatiandi dimuga mana lipu maxa haxatiandi, daxaidi mala. Nabu lipu maxa haxatiang tela xai lipu maxa haxatiana mala, bing bagula dingtang xauna xungdi mari banggumia.” ");
INSERT INTO met_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita harua ba, “Ubaxanga haruanga babunoa namuxina nam.” ");
INSERT INTO met_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Xusungadi ba, “Baruta? Hatumingaimdi dimaring teguyu? ");
INSERT INTO met_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Axadi axangdi diluxu suxunguimia, didali gamoimdi, saking diri mala tinrungia. ");
INSERT INTO met_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ne haruanga sok hatumingaimia ma. Axa ba libuang musuim. ");
INSERT INTO met_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Namua na axamandi disok sangua lipu hatumingania bing: hatum doa, ung lipua mati, kinu rangua gaxarea yau teguyu, libu kubolu miaxuam, hanai, langua xaung hanggalangia lipu tela yanoa. ");
INSERT INTO met_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Axadi bagudi li dilibuang musuim. Ne bungina axang xaung rimaim damianga teguamdi, axa ba sanga ba libuang musuim Urana maxania te.” ");
INSERT INTO met_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tauna, Yesu sauya titia Galili saing ila titia long sabangga Taya xaung Saidon tang duwa mana ba. ");
INSERT INTO met_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Haing Kenanggam tela (ina Yuda Teguam), wa mana titia ba ma rangua, wagi ba, “Toxoratamona, Xaitamoxi Debit Garanoa ba, usinga nga! Nanuhangigua xap salak sabanga mana xaungua wa mana.” ");
INSERT INTO met_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ne Yesu haxuya haruanga tela na te. Baing lipuxindi dinaxu mana dima rangua dibala ba, “Usoxi mala, namua na tautiti kira, ma kimuya makira xabaxaba haringina buk.” ");
INSERT INTO met_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Harua na haingga ba, “Urana soxi nga ma bu ngahauli Isreldi ding ganiding. Ding bila sipsipdi dahanggalang.” ");
INSERT INTO met_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Hainga ma saing gung king tuxundi maxania, xusunga muli ba, “Toxoratamona, uhauli nga!” ");
INSERT INTO met_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Haxuya ba, “Garagudi daxang muga to, namua na maring te mana ngaxap garadi angiadingdi saing ngatingdi mala na komadi.” ");
INSERT INTO met_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Harua ba, “Toxoratamona, maxung sibuna. Ne axamang tela xauna maxunau, komadi daxang anginga xuxundi diri saxumingia bungina moxodingdi daxang kabukabia!” ");
INSERT INTO met_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Baing Yesu haxuya ba, “Haing, hatumingam haringina tubu! Xusungangama ngalibu baing.” Baing hata sibuna li nanuhanginoa sok xai dup. ");
INSERT INTO met_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu goxoya mala Lang Gamolingana Galili, haxa rubinia. Baing haing mana xaxagang tela saing rung mari. ");
INSERT INTO met_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Buranga sabangadi dima rangua, daxap lipu kidingdi dahamati, lipu maxa haxatiandi, lipu kidingdi didoa, lipu mumgutingamdi, xaung xumana muli ma. Dahakinudi mari Yesu maxania, saing hamaringia ding longgalo. ");
INSERT INTO met_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Buranga dihixi mana! Lipu gaxarea mumgutingamdi daharua, lipu gaxarea kidingdi didoa disok xai, lipu gaxarea kidingdi dahamati dahaxa, saing lipu gaxarea maxa haxatiandi dibagu muli! Baing diti Urana Isreliam yanoa. ");
INSERT INTO met_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu wagi lipuxindi dinaxu mana dima rangua saing harua ba, “Gamogua usinga lipuadi li. Duwa rangua nga xaidap tuwa, saing anginga disup. Gesagiding ba. Hauxagu ba ngasoxidi mala bila ba, nam dimakmatia daxangia.” ");
INSERT INTO met_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Lipuxindi dinaxu mana dahaxuya ba, “Ne maluxu mana long xoliana li, bagula kira taxap anginga bi bu tahaxang buranga sabanga bila li?” ");
INSERT INTO met_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu xusungadi ba, “Ang salangaimdi baru?” Dahaxuya ba, “7 xaung song kaxukang teladi, xumana buk te.” ");
INSERT INTO met_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Baing bala burangua ba dirung titia. ");
INSERT INTO met_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Baing xap salanga 7 xaung songdi, harua xai sibuna na Urana manadi, saing utu sahadi. Sinadi na lipudi dinaxu mana, saing dituxu sinak na lipudi. ");
INSERT INTO met_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ding longgalo daxang sanga ba. Kimuya, lipudi dinaxu mana digugunia hataindi duwauyu, digam daba 7 dibaxagi. ");
INSERT INTO met_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mana lipu longgalo daxang, lupdi titingadinga bila 4,000. Dititi haing garadi te. ");
INSERT INTO met_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu harua xai sibuna saing buranga dahatibaxaya, saking haing wagia saing luki mala titia Magadan. ");
INSERT INTO met_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisidi digabu Sadyusidi dima rangua Yesu saing dituba. Duxusunga ba libu axamang haringina bu hatanga nadi ba Urana soxi ma. ");
INSERT INTO met_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Haxuya ba, “Bungina bungbung sibunauba aharua ba, ‘Sabaluna sabuxa. Longa xai ba.’ ");
INSERT INTO met_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Baing bungina buraragina aharua ba, ‘Sabaluna sabuxa, mugapdi musuding. Binabu longa bagula doa.’ Ang sanga ba abagu axabia sabalung kubolunoa, ne sanga ba abagu axabia axadi Urana libudi hatata te! ");
INSERT INTO met_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ang lipu hatatamdi ang diang sibundi xaung ayamu Urana, namua na asaisai ba abagu axamang haringina. Ne axamang haringing taininau ing ganina bagula abagu ba: Bagula wa bila axamana sok mana Urana lipuxing suxunguxunguama Yona.” Harua laing sup, baing yungadi, ilauba. ");
INSERT INTO met_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesu gabu lipuxindi dinaxu mana dikisi lang gamolingana mala, ne lipuxindi dinaxu mana dahalingalinga ba daxap salanga mala. ");
INSERT INTO met_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Harua nadi ba, “Amaxania mana axamana libu salanga salalanga ma rangua Parisidi xaung Sadyusidi.” ");
INSERT INTO met_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Dahangixaya haruanga baguba liwe mading ba, “Bola harua bila ba namua na taxap salanga tela ma te.” ");
INSERT INTO met_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu xabia baraxinta daharua mana, baing xusungadi ba, “O, ang bina. Hatumingaim haringina haringing buk te. Baruta ahangixaya liwe mang mana axola salanga? ");
INSERT INTO met_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Abagu saing axabia rangrang teguyu? Ahatumia muli axamang tela te? Bungina ngahaxang lipu 5,000 xaung salanga luwadi luwadi hiliadinga, agam daba baru mana salanga duwauyu? ");
INSERT INTO met_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kimbo, bungina ngahaxang lipu 4,000 xaung salanga 7, agam daba baru mana salanga duwauyu? ");
INSERT INTO met_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Baruta axabia haruangagua namuxinoa te? Ngaharua mana salanga te. Ngaharua muli ba, ‘Amaxania mana axamana ma rangua Parisidi xaung Sadyusidi libu salanga salalanga.’ ” ");
INSERT INTO met_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Baing ina naga, daxabia rangrang ba harua mana axamana libu salanga salalanga te, baladi ba dimaxania mana Parisidi xaung Sadyusidi tubatubaigiding murakkamdi, nam baxagi manadi bila axamana libu salanga salalanga. ");
INSERT INTO met_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu ila longga Sisaria Pilipai titidinga, baing xusunga lipuxindi dinaxu mana ba, “Lipudi daharua ba Lipua Ma Rangua Urana gaxarea sibuna?” ");
INSERT INTO met_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Dahaxuya ba, “Teladi daharua ba ung ba Lipu Suguangama Yon. Teladi daharua ba Elaitsa. Ne teladi daharua ba Yeremaya kimbo Urana lipuxing suxunguxunguam tela muli.” ");
INSERT INTO met_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Baing xusungadi ba, “Ne ang ba, ang gaharua ba nga gaxarea?” ");
INSERT INTO met_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita haxuya ba, “Ung Urana Lipuxing Mogunganama, Urana walingam Garanoa.” ");
INSERT INTO met_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu haxuya ba, “Saimon, Yon garanoa, Urana yaha maung, namua na Tibugu long xaiyam hatanga alali naung. Oxop xabianga ba rangua lipu titiamdi te. ");
INSERT INTO met_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Baing ngabalaung bila li. Ung Pita, namuxinoa ‘siang.’ Baing etua mana siangga li bagula ngatongtongia sabungagua. Baing Matiadi Yabadinga haringinganoa bagula dali te. ");
INSERT INTO met_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Bagula ngauliaung axamana xaxa Long Xaiya Yonggaxinoa xaluxinoa. Baraxing baraxinta ubili titia, Urana xauna bagula bili long xaiya, saing baraxing baraxinta unai titia, Urana xauna bagula nai long xaiya.” ");
INSERT INTO met_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Baing bili lipuxindi dinaxu mana ba labu dibala lipu tela ba ina Urana Lipuxing Mogunganamau tai. ");
INSERT INTO met_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mana bungina baguba saing ila, Yesu ungguti baxanga rangrang na lipuxindi dinaxu mana ba Urana murunganoa bing ina bagula ila long sabangga Yerusalem, xap salaga mana lipu haringindi, lipu hananiangamdi yanamidingdi xaung lipu hanaunaunga tubatubainganamdi rimadingia. Baing bagula dung mati, saing mana xaidap tuwa bagula mesa muli. ");
INSERT INTO met_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Baing Pita xap mala singia saing ungguti bili ba labu harua nadi bila bau tai. Harua ba, “Toxoratamona, tegu sibuna! Sanga ba sok maung te!” ");
INSERT INTO met_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu xugia mala saing harua na Pita ba, “Satan, uhaya! Ubo ba usoxauti daxangagua. Uhatumia bila Urana hatumia te. Uhatumia bila lipu titiamdi.” ");
INSERT INTO met_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Baing Yesu harua na lipuxindi dinaxu mana ba, “Lipu gaxarea dibo ba dinaxu manga, bing dahalingalinga murungadinga, diti doxoxi xaiding balingamdi, saing dinaxu manga. ");
INSERT INTO met_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Namua na lipu gaxarea dituxu haringina walingadinga, bing bagula dahanggalang. Ne lipu gaxarea diyunga walingadinga bu dinaxu manga, bing bagula daxap walinga sibuna. ");
INSERT INTO met_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nabu lipu tela xap axamang titiam longgalo, ne ina walinganoa hanggalang, bing axadi bagudi li bagula daxap ina muli baru? Baraxinta sanga ba lipu tela sina bu haxuya walinganoa? Tegu. ");
INSERT INTO met_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ngaharua bila ba namua na Lipua Ma Rangua Urana bagula ma Tibuna ralania xaung uleginamdi, saing bagula haxuya lipu taining tainina mana kubolua dilibu. ");
INSERT INTO met_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Maxung sibuna ngabalang ba, ang teladi awa la li, bagula amati teguyu saing bagula abagu Lipua Ma Rangua Urana ma bila xaitamoxi.” ");
INSERT INTO met_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Xaidap 6 disup, baing Yesu xap Pita, Yems, kixinginoa Yon, saing xai dingtung mahaing bimbi sabanga tela, ne ding ganiding duwa. ");
INSERT INTO met_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","La ba, Yesu xugia maxadingia. Ramramonoa sina bila xaidaba, saing imangindi disok usamang sibuna bila lulianoa. ");
INSERT INTO met_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hata sibuna li, Moses Elaitsa tang dowa masok tung maxadingia, tang daharua rangua Yesu. ");
INSERT INTO met_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita harua na Yesu ba, “Toxoratamona, xai sibuna tawa la li. Nabu ung murum, bagula ngatongtongia xahi tuwa—tela naung, tela na Moses, xaung tela na Elaitsa.” ");
INSERT INTO met_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita haruauyu, baing mugap tela luliang sibuna kaudi, saing waxutu tela sok mugabia ma, harua ba, “Alali Garagu sibuna, nga murugu sibuna mana. Angtung galungu haruanganoa!” ");
INSERT INTO met_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Lipudi dinaxu mana Yesu tung dilungu, baing dimaxuwa sibuna. Tung digung kidingdi mari, dita ramramodingdi titia. ");
INSERT INTO met_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ne Yesu ma rangua dingtung saing ringdi. Harua ba, “Angtung gamesa. Labu amaxuwau tai.” ");
INSERT INTO met_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tung dibagu mahaing, baing dibagu Yesu ing ganina wa. ");
INSERT INTO met_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tauna diyunga bimbia ba, diri malauyu, saing Yesu bilidi ba, “Labu abala lipu tela mana axamana abagu tai, laing kimuya mana Lipua Ma Rangua Urana mesa muli mana matiyua.” ");
INSERT INTO met_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Baing lipuxindi dinaxu mana duxusunga ba, “Baruta lipu hanaunaunga tubatubainganamdi daharua ba Elaitsa bagula goxoya ma muga mana Urana Lipuxing Mogunganama ma?” ");
INSERT INTO met_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu haxuya ba, “Maxung sibuna, Elaitsa ma muga bu hamaringia axamandi to. ");
INSERT INTO met_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ne ngabalang ba, Elaitsa ma ba, ne dibagu daxabia te, saing dilibu ding murungadinga mana. Baing bila balau bagula Lipua Ma Rangua Urana xap salaga rimadingia.” ");
INSERT INTO met_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Baing ina naga, lipudi dinaxu mana tung daxabia rangrang ba harua mana Lipu Suguangama Yon. ");
INSERT INTO met_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Bimbi namuya Yesu gabu lipuxing tuwa dinaxu mana disok mana burangua, baing lipu tela ma rangua saing gung king tuxundi maxania. ");
INSERT INTO met_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Harua ba, “Toxoratamona, usinga garagua. Bunging xumana asaxa garanoa haing mana saing xap salak sabanga. Bunging xumana xung mari yabia kimbo langia. ");
INSERT INTO met_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Binabu ngaxap ma rangua lipuximdi dinaxu maung, ne ding sanga ba dahamaringia te.” ");
INSERT INTO met_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Haxuya ba, “Ai, ang hatatamdi ahatum haringin te. Kuboluimdi dimaring te. Xaidap baru bagula ngawauyu ranguang saing ngaxap salaga mang? Axap gara ba ma rangua nga to.” ");
INSERT INTO met_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu bili xaungua, saing sok sangua gara ba, saing hata sibuna li businganoa sup. ");
INSERT INTO met_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kimuya lipudi dinaxu mana dima duxusunga hisangia ba, “Baruta am sanga ba am gasuka mala te?” ");
INSERT INTO met_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Haxuya ba, “Hatumingaim haringindi kaxukading buk, binabu ang sanga te. Ahatumia: Mastat xuyandi kaxukang sibuna, ne dahaing disok sabanga sibuna. Bila balau, nabu hatumingaim haringindi ditubu laing maxung sibuna ahatum haringina ba Urana bagula libu bila axusunga ba, bing sanga ba alibu axamang longgalo! Bila aharua na bimbia li ba, ‘Uyunga yabama ula hataina lo’, baing bagula ila.” ");
INSERT INTO met_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Bungina lipudi dinaxu mana digugunia muli titia Galili, Yesu baladi ba, “Bagula dita Lipua Ma Rangua Urana bixuandi rimadingia. ");
INSERT INTO met_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Bagula dung mati, ne kimuya mana xaidap tuwa, bagula Urana iti mesa muli.” Baing lipudi dinaxu mana dibaxagi mana usingangua. ");
INSERT INTO met_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu gabu lipuxindi dinaxu mana dila disok long sabangga Kaperneam, baing lipudi daxap takis mana Urana Numanoa dima rangua Pita saing duxusunga ba, “Bola Lipuxim Tubatubaingam gim takis mana Urana Numanoa, bo?” ");
INSERT INTO met_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Haxuya ba, “Wane.” Baing Pita ila luxu numia. Ne Pita harua teguyu, baing Yesu xusunga muga ba, “Saimon, uhatum baru? Xaitamoxi titiamdi daxap takis rangua ding sibuding lipuxidingdi, kimbo daxap rangua lipu titi telamgadi didalidi ba?” ");
INSERT INTO met_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita haxuya ba, “Daxap rangua lipu titi telamgadi didalidi ba.” Baing Yesu bala ba, “Binabu ding sibuding lipuxidingdi digim te. ");
INSERT INTO met_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ning, sanga ba talibu gamodingdi didoa makira te, binabu uri mala lang gamolingania saing uting kaila mala langia. Song mugamugangam uxuni, bing uxaxa suxungunoa, baing bagula ubagu siang silba mukiring tela wa maluxu. Oxop mala ugim kitam takisiradi.” ");
INSERT INTO met_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Bila bungina baguba, lipudi dinaxu mana Yesu dima rangua saing duxusunga ba, “Gaxarea mugamuga Long Xaiya Yonggaxinia?” ");
INSERT INTO met_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Wagiʼm gara tela ma saing ta mali liwe manadi. ");
INSERT INTO met_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Baing harua ba, “Maxung sibuna ngabalang ba, nabu axugia hatumingaimdi saing asok bila gara kaxukandi te, bing sanga ba aluxuʼm Long Xaiya Yonggaxinoa te. ");
INSERT INTO met_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Binabu lipu gaxarea ditatua ding bila gara li duwa mugamuga Long Xaiya Yonggaxinia. ");
INSERT INTO met_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Baing lipu gaxarea daxap gara bila li mana yagua, bing daxap nga. ");
INSERT INTO met_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ne lipu gaxarea xai lipu tela hatum haringina manga daxanga diania, heku lipua ba yan tate bila gara kaxukana li, Urana bagula sina salaga na. Nabu digoxi siang sabanga waxungtuania, saing diting mari miawia ngara, bing salaga xap bagula kaxukana mana salaga xap yu Urana rimania. ");
INSERT INTO met_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Laku, lipu titiamdi, mauxanganoa xapdi yu, namua na daxai lipudi daxanga diania! Maxuna, kubolu dianadi li bagula disok. Ne usinga sibuna mana lipua libudi disok rimania. ");
INSERT INTO met_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nabu rimama kimbo kima libung ulibu kubolu diana, bing utaxiti uhitixiya. Xai buk mana uluxu walinga maxaxayamia xaung rimam taininau kimbo kim taininau. Nam rimam luwa kimbo kim luwa ne ditinggung yap subingang teguamia. ");
INSERT INTO met_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Baing nabu maxama libung ulibu kubolu diana, bing uhasi uhitixiya. Xai buk mana uluxu walinga maxaxayamia xaung maxam taininau. Nam maxam luwa ne ditinggung mari long salakkam yabinia. ");
INSERT INTO met_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Amaxania, nam ahatum ba tela liwe mana garadi li wa olang. Namua na ngabalang ba Urana uleginamdi duwasa mana garadi ba taining tainina, bungingbunginalo dibagu Tibugu long xaiyam ramramonoa. ");
INSERT INTO met_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ahatum baru? Nabu lipu tela sipsibing 100 saing tela hanggalang, bola ila sai mana, maxuna? Wane. Bagula sauya 99 duwa xaxagania saing ila sai mana tela hanggalang. ");
INSERT INTO met_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Maxung sibuna ngabalang ba, nabu xap, bing yaha buk mana, saing yahanganoa sabanga mana 99 dahanggalang te. ");
INSERT INTO met_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Bila balau Tibuim wa long xaiya muruna te mana tela maluxuʼm garadi li hanggalang. ");
INSERT INTO met_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nabu riam hatuminga haringinama libu kubolu diana maung, ula ubagu, saing bungina angtang ganim awa, bing uhamaringia kubolunoa. Nabu lungu haruangama, bing xai sibuna, wa riama muli. ");
INSERT INTO met_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ne nabu lungu haruangama te, bing oxop lipu tela kimbo luwa mala ranguaung, bu lipu luwa kimbo tuwa sanga dibagu daxabia axamang longgalo uharua na. ");
INSERT INTO met_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Baing nabu hauxana mana lungudi, bing oxop haruangama mala rangua sabunga lipuxindi. Baing ina naga, nabu hauxana mana lungu lipu sabungamdi haruangadinga, bing ubagu bila lipu tela xabia Urana te xaung bila lipu takis xabinganam tela. ");
INSERT INTO met_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Maxung sibuna ngabalang ba, baraxing baraxinta abili titia, Urana xauna bagula bili long xaiya, saing baraxing baraxinta anai titia, Urana xauna bagula nai long xaiya. ");
INSERT INTO met_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Haruanga tela muli ngabalang ba, nabu angia luwa tang hatumingading taininau la li titia mana axamang tela axusunga mana, bagula Tibugu wa long xaiya libu mang. ");
INSERT INTO met_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Namua na longga bila lipudi dinaxu manga luwa kimbo tuwa digugunia namua na dinaxu manga, bing ngawa liwe manadi.” ");
INSERT INTO met_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Baing Pita ma rangua Yesu saing xusunga ba, “Toxoratamona, riagu hatuminga haringinama sanga libu kubolu diana nanga bunging baru, saing ngayunga kubolunauyu? Bola laing bunging 7?” ");
INSERT INTO met_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu haxuya ba, “Ngabalaung ba, bunging 7 tegu. Ning bunging 77. ");
INSERT INTO met_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Bila li: Long Xaiya Yonggaxinoa bila xaitamoxi tela bo ba lipuxing oxatamdi dima dahamaringia haxuyangadinga rangua. ");
INSERT INTO met_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ungguti oxata hamaringia haxuyangadi, baing daxap lipu tela ma rangua, haxuyanganoa xumang sibuna bila 10 milyan kina. ");
INSERT INTO met_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Sanga ba gim te, binabu xaitamoxi tabina ba disina lipua ba gabu haininoa, garandi xaung xalingindi masup bu duwa lipu oxata olanggamdi bu gim haxuyanganoa. ");
INSERT INTO met_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Lipu oxatama ba gung king tuxundi maxania, ta ramramonoa titia. Xusunga haringina ba, ‘Usinga uragu manga, baing bagula ngahaxuya siang longgalo ngaxap ranguaung.’ ");
INSERT INTO met_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Lipuxing haringina usinga, yunga haxuyanganoa, saing yunga lipua ba mala. ");
INSERT INTO met_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ning lipu oxatama sok mala, baing ila sok mana riang oxatam tela xap siang bila 10 kina rangua saing haxuya teguyu. Tuxu haringina saing ungguti tuxuti mana waxungtuanoa. Harua na ba, ‘Ugim haxuyangama hata sibuna li!’ ");
INSERT INTO met_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Riang oxatama gung king tuxundi maxania saing xusunga haringina ba, ‘Uragu manga, baing bagula ngahaxuya naung.’ ");
INSERT INTO met_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ne hauxana. Libu diting lipua ba salak yabania laing sanga ba gim haxuyanganoa. ");
INSERT INTO met_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Lipu oxatam teladi dibagu libu bila ba, baing gamodingdi didoa saing dila dibaxanga na lipuxiding haringina mana axamang longga disok. ");
INSERT INTO met_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Baing ina naga, xaitamoxi wagiʼm lipu oxatama ba ma. Harua ba, ‘Ung lipu oxatam diang sibuna! Uxusunga nga haringina saing ngayunga siang xumang longgalo naung. ");
INSERT INTO met_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ngausinga maung baing. Binabu baruta usinga xauna mana riam oxatama te?’ ");
INSERT INTO met_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Lipuxing haringina atin disala, baing ta lipu salak yabang wasanganamdi rimadingia bu disina salak sabanga na laing gim haxuyanganoa masup. ");
INSERT INTO met_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Bila balau Tibugu wa long xaiya bagula libu kubolu taininau nang taining tainina, nabu hauxaim hatumingaimia mana ayunga riaimdi kuboluding diandi.” ");
INSERT INTO met_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu sahi haruanga baguba, baing yunga titia Galili saing ila titia Yudia wa Langga Yodan hataina. ");
INSERT INTO met_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Buranga sabangadi disu mana, saing sahi busingadingdi la ba. ");
INSERT INTO met_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parisi teladi dima rangua bu dituba. Binabu duxusunga ba, “Hanaunaunga harua ba sangau mana lipu tela taxiti yaunganoa mana ing murunganoa?” ");
INSERT INTO met_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Haxuya ba, “Bola atiti haruanga wa Urana Xuania harua ba mugamugau sibuna Urana ‘tongtongiadi lup haing.’ ");
INSERT INTO met_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Baing harua ba, ‘Mana namua baguli lup tela yunga baungtibundi saing taga rangua haininoa, baing tang disok lipu taininau.’ ");
INSERT INTO met_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Baing ina naga, tang duwa luwauyu te, tang duwa bila lipu taininau. Binabu, baraxinta Urana taga masup, labu lipua taxitiu tai.” ");
INSERT INTO met_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Duxusunga ba, “Nabu bila ba, bing Moses harua sangau mana lipua bung taxiti yaunga xailongina saing suka hainga mala baru?” ");
INSERT INTO met_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu haxuya ba, “Gamoim diriba ding, binabu Moses nai mana ataxiti yaungua. Ning alaba mugamugau sibuna Urana hatuminganoa te. ");
INSERT INTO met_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ngabalang ba, lipu gaxarea taxiti yaunganoa, ne haininoa haxa mauli rangua lipu tela te, bing bungina yau haing tela muli bing libu kubolu diana mana yaunga daxanganoa.” ");
INSERT INTO met_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Lipudi dinaxu mana daharua na ba, “Nabu bila ba liwe mana neng mondi, bing xai sibuna lipudi diyau te!” ");
INSERT INTO met_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu haxuya ba, “Lipu longgalo sanga ba daxap tubatubainga baguli te. Tegu. Ding gaxarea Urana sina haringinga nadi ding ganiding. ");
INSERT INTO met_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Lipu teladi diyau te, namua na sanga ba dikinu xai rangua haing te, namua na sanggading didoa bungina bauding dahayaudi. Lipu teladi diyau te, namua na sanga ba dikinu xai rangua haing te, namua na lipu teladi dahasi maradingdi. Baing lipu teladi dahau hatumingadinga ba diyau te, bu dituxu Urana oxatanoa xai sibuna maluxuʼm Long Xaiya Yonggaxinoa. Lipu gaxarea sanga ba daxap haruanga baguli, bing daxap.” ");
INSERT INTO met_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Baing lipu teladi daxap gara kaxukandi ma rangua Yesu bu ta rimandi manadi xaung bu sabu manadi. Ne lipudi dinaxu mana dibili lipuadi daxapdi ma. ");
INSERT INTO met_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ne Yesu harua ba, “Ayunga garadi ma rangua nga. Labu abilidiu tai! Namua na lipuadi duwa bila garadi bagudi li, Long Xaiya Yonggaxinoa dingia.” ");
INSERT INTO met_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Baing ta rimandi manadi saing xusunga Urana ba sina guxama nadi. Saking yunga longga baguba saing ila. ");
INSERT INTO met_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tauna, lipu tela ma rangua Yesu saing xusunga ba, “Lipu Tubatubaingam, ngaria axamang xai baruamta bu ngaxap walinga subingang teguam?” ");
INSERT INTO met_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu haxuya ba, “Baruta uxusunga nga mana baraxinta xai? Urana ing ganina xai. Nabu ubo ba oxop walinga subingang teguama, bing usu mana hanaunaungadi Urana sinadi na Moses.” ");
INSERT INTO met_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Xusunga ba, “Baruamtadi?” Yesu haxuya ba, “ ‘Labu ung matiu tai. Labu ukinu rangua tela uyau teguyu bau tai. Labu uhanaiu tai. Labu usu haruanga languangamgu tai. ");
INSERT INTO met_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Uwa hawa mana baumtibumdi,’ xaung ‘ung murum sibuna mana riam longgalo bila ung murum sibuna maung.’ ” ");
INSERT INTO met_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Gananuna haxuya ba, “Hanaunaunga longga bagudi li ngasu manadi. Ngaraxap mana baraxintauyu?” ");
INSERT INTO met_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu haxuya ba, “Nabu ubo ba usok maringing sibuna, bing ula, usina xalingimdi masup. Usina giminagidingdi na lipu haxugindi, bing bagula oxop axamang maxung sibundi maluxu long xaiya. Saking uma, unaxu manga.” ");
INSERT INTO met_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Lungu haruanga baguba, baing ila, ayangang sibuna, namua na xalingindi xumang sibuna. ");
INSERT INTO met_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Baing Yesu harua na lipuxindi dinaxu mana ba, “Maxung sibuna ngabalang ba, makasa mana lipu xalaxalam tela luxu Long Xaiya Yonggaxinia. ");
INSERT INTO met_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ngabalang muli ba, lipu xalaxalama bo ba luxu Urana Yonggaxinia, makasanganoa dali kamel tela ila luxu saxang ginanginia.” ");
INSERT INTO met_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Lipudi dinaxu mana dilungu haruanga ba, baing dihixi buk mana. Duxusunga ba, “Si! Nabu bila ba, bing lipu gaxarea bagula daxap walinga subingang teguama?” ");
INSERT INTO met_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu bagu maringina manadi saing harua ba, “Lipu ding sibuding sanga tate, ne Urana ina sanga mana axamang longgalo.” ");
INSERT INTO met_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita harua na ba, “Ai! Am ba, am gayunga axamandi masup bu am ganaxu maung. Bagula am gaxap baraxinta?” ");
INSERT INTO met_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu harua nadi ba, “Maxung sibuna ngabalang ba, bungina axamandi disok hauna xaung bungina Lipua Ma Rangua Urana rung mana xaitamoxi kabukabuna ralanam inia, ang ba anaxu manga bagula arung mana xaitamoxi kabukabung 12 xauna, xaung bagula asuxuya Isrel bakbakka 12. ");
INSERT INTO met_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Baing lipu gaxarea dahatumia nga saing diyunga yabadingdi, sabangadingdi, kixingidingdi, hamungadingdi, baudingtibudingdi, kimbo garadingdi, bing bagula daxap haxuyangadinga bila 100 muli xaung bagula daxap walinga subingang teguama. ");
INSERT INTO met_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ne xumana duwa mugamugangia bagula duwa kimuya. Baing xumana duwa kimuya bagula duwa mugamugangia. ");
INSERT INTO met_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Urana sina haxuyangua na lipudi bila li. Kubolunoa libu Long Xaiya Yonggaxinia bila titi moxong tela, buraraging sibuna ila bu sai lipu oxatamdi ba duwaxata waining umangania. ");
INSERT INTO met_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hau haruanga ba gim xaidap taininau giminaginoa nadi. Baing soxidi mala umangania. ");
INSERT INTO met_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Tauna, bila 9:00 buraragina ila nawa yabania saing bagu lipu teladi dili olang. ");
INSERT INTO met_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Baladi ba, ‘Ang xauna ala awaxata wainigu umangania, baing bungina xaidaba sup bagula ngagimgang giminak maringina.’ ");
INSERT INTO met_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Binabu dilauba. “Bila xaidap lia xaung 3:00 bungbung ila libu taininau. ");
INSERT INTO met_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Bila 5:00 ila muli saing bagu lipu teladi dili olang xauna. Xusungadi ba, ‘Baruta ali olang la li oxata te? Xaidaba supkuba!’ ");
INSERT INTO met_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Dahaxuya ba, ‘Namua na lipu tela sina oxatua nam te.’ “Baladi ba, ‘Ala awaxata wain umangania xauna.’ ");
INSERT INTO met_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Yambongguba, baing wain umangang moxonoa bala lipuxing oxatam mugamugangama ba, ‘Uwagi lipu oxatamdi ma saing ugim oxatadingdi. Ungguti mana lipu kimuamdi to ila lipudi dima muga.’ ");
INSERT INTO met_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Lipudi daxap oxatua bila 5:00 dima daxap xaidap tela giminaginoa. ");
INSERT INTO met_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Binabu, bungina lipudi daxap oxatua muga ba dima, dahagaxa ba bagula daxap siang xumana. Ning ding xauna daxap xaidap tela giminaginoa. ");
INSERT INTO met_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Dibagu giminagidingdi, baing dungguti daharungia titia moxonoa ba, ");
INSERT INTO met_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ai, lipuadi li daxap oxatua kimu ba duwaxata auwa taininau ing ganina, saing ugimdi hasusu mam am gamakasa buraragina sup ma hatata, saing xaidaba xaniam haringina.’ ");
INSERT INTO met_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Haxuya tela ba, ‘Riagu, ngalibu doa maung te. Menau ung gunai mana xaidap tela giminaginoa, maxuna? ");
INSERT INTO met_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Oxop giminagima saing ulauba. Nga murugu mana ngasina giminak taininau na lipu kimuama bila ngasina naung. ");
INSERT INTO met_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nga siangigua, maxuna? Maring ba ngalibu murungagua mana. Nabu ngabo ba ngalibu kubolu xai na lipu teladi, bing uharungia nga baru?’ ” ");
INSERT INTO met_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Baing Yesu harua ba, “Bila balau teladi duwa kimuya bagula duwa mugamugangia, saing teladi duwa mugamugangia bagula duwa kimuya.” ");
INSERT INTO met_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu haing mala mana long sabangga Yerusalem, baing xap lipu 12 dinaxu mana ding ganiding mala singia saing harua nadi ba, ");
INSERT INTO met_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Alungu to. Tahaing Yerusalemguba, saing bagula dita Lipua Ma Rangua Urana lipu hananiangamdi yanamidingdi xaung lipu hanaunaunga tubatubainganamdi rimadingia. Bagula dita haruangia baing bagula dahau haruangua ba dung mati. ");
INSERT INTO met_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Baing bagula dita Yuda Teguamdi rimadingia bu didaudau, digusi, dung mati xai balingamia. Ne kimuya mana xaidap tuwa bagula Urana iti mesa muli!” ");
INSERT INTO met_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kimuya Sebedi garandi Yems Yon tang bauding ma rangua Yesu xaung dingtang. Gung king tuxundi mari maxania saing xusunga Yesu ba libu axamang tela mana. ");
INSERT INTO met_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu xusunga ba, “Ubo ba ngalibu baru maung?” Harua ba, “Ngabo ba unai mana garaguadi li bu tang dirung mana rubimdi Yonggaximia, tela rung rimamo, tela rung xong, daxap yaya bila ba.” ");
INSERT INTO met_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu bala dingtang ba, “Tang gaxabia te axusunga baru. Sanga ba tang ganung mana xuba salakkam bila nganung mana?” Tang dahaxuya ba, “Wane, amtam sangau.” ");
INSERT INTO met_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu bala dingtang ba, “Maxuna, xuba nganung mana, bagula tang ganung mana xauna. Ning lipu gaxarea rung mana rimagu rimamo kimbo xong, nga sanga ba ngamogu te. Tegu. Tibugu xauxau kabukabuadi ba masup na moxodingdi.” ");
INSERT INTO met_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Baing bungina lipu 10 dinaxu mana dilungu bila ba, gamodingdi didoa mana neng sabanganadi ba. ");
INSERT INTO met_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesu wagidi ma digugunia saing harua ba, “Ang gaxabiau, Yuda Teguamdi yanamidingdi duwa etua manadi diti ding. Yanamidingdi dahaxi ba lipudi disu mana haruangadinga. ");
INSERT INTO met_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Heku awa bila ba. Tegu. Lipu gaxarea bo ba wa sabanga liwe mang, bing wa ang lipuxim haulingama, ");
INSERT INTO met_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","saing lipu gaxarea bo ba wa mugamuga liwe mang, bing wa lipuxim oxata olanggam. ");
INSERT INTO met_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Namua na Lipua Ma Rangua Urana ing sibuna ma bu lipudi dahauli te. Tegu. Ma bu hauli lipudi, xaung yunga walinganoa bu gim muli lipu xumana.” ");
INSERT INTO met_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu gabu lipuxindi dinaxu mana disauya long sabangga Yeriko, baing buranga sabanga disu mana. ");
INSERT INTO met_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Lipu maxa haxatiang luwa dirung mua daxanga rubinia. Tang dilungu ba Yesu ma ila bila ba, baing duwagi ba, “Toxoratamona, Xaitamoxi Debit Garanoa ba, usingamtam!” ");
INSERT INTO met_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Burangua dibili dingtang saing daharua ba, “Tang gadik!” Dibili susu, tang dahaxi buk saing duwagi sabanga ba, “Toxoratamona, Xaitamoxi Debit Garanoa ba, usingamtam!” ");
INSERT INTO met_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu li mua saing wagi na dingtang ba, “Tang gabo ba ngariangtang baru?” ");
INSERT INTO met_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tang dahaxuya ba, “Toxoratamona, tam gabo ba tam gabagu.” ");
INSERT INTO met_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu usinga dingtang saing ring tang maxadingdi. Hata sibuna li maxadingdi disok xai dup, saing tang disu mana. ");
INSERT INTO met_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu gabu lipuxindi dinaxu mana dima haxek monga mana long sabangga Yerusalem, baing disok haxek mana longga Betpets wa Xaxagana Olip. Yesu soxi lipuxing luwa dinaxu mana mala, ");
INSERT INTO met_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","harua nadi ba, “Tang galuxu mana longga wa mugamugangia to. Haxek sibuna ba aluxu, bagula abagu donki tela digoti la ba, gabu garanoa wa rubinia. Tang galubadi saing axai dingtang ma rangua nga. ");
INSERT INTO met_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nabu lipu tela libu haruanga tela mangtang, bing tang gabala ba, ‘Toxoratamona oxatana mana dingtang.’ Baing bagula soxidi ma sap.” ");
INSERT INTO met_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Axa li sok bu Urana haruanganoa aningona, harua waleu lipuxing suxunguxunguama Sekaraya suxungunia ba: ");
INSERT INTO met_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Abala lipu Xaxagana Sayongamdi ba, ‘Bagu xaitamoxima ma ranguang. Tatuaina, rung etua mana donki tela, rung etua mana donki tela garanoa.’ ” ");
INSERT INTO met_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yesu lipuxing luwa dinaxu mana tang dila dilibu haruanganoa. ");
INSERT INTO met_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tang daxai donki gabu garanoa tang ma rangua, saing tang diting imangiding sabangadi mahaing mana dingtang. Baing Yesu rung etua manadi. ");
INSERT INTO met_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Buranga sabanga duxa imangiding sabangadi daxangia bu dahatanga ba lipu yayam sabanga, saing teladi ditaxiti xai rimandi saing duxadi daxangia. ");
INSERT INTO met_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Burangadi dimuga mana gabu burangadi disu mana ding duwagi ba, “Taiti Urana yanoa mana Xaitamoxi Debit Garanoa ba!” “Urana sina guxama na lipua li ma mana Toxoratamona yanoa ba!” “Taiti Urana Eta Loam Sibuna yanoa!” ");
INSERT INTO met_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu luxu Yerusalem bila ba, baing long sabangga ba lipuxing longgalo dihixi mana, saing duxusunga ba, “Lipua li gaxarea?” ");
INSERT INTO met_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Baing burangua dahaxuya ba, “Lipua li Yesu, Urana lipuxing suxunguxunguam ma mana Nasaret wa titia Galili.” ");
INSERT INTO met_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu luxu Urana Numang yabania saing suka lipuadi digim disina axamandi mana sianga maluxu Urana Numania masokkuba. Matuxuya lipu siang hakhaxuyanganamdi kabukabudingdi xaung lipu gumak sinaikkamdi kabukabuding rungingamdi. ");
INSERT INTO met_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Harua nadi ba, “Aisaya bung Urana Xuania ba Urana harua ba, ‘Numagua bagula duxu ba numa sabungam,’ ne ang gaxugia mala bila ‘guha tela lipu hanaunggamdi dihisa maluxu mana!’ ” ");
INSERT INTO met_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Lipu maxa haxatiandi xaung lipu kidingdi didoa dima rangua Yesu Urana Numania, saing hamaringiadi. ");
INSERT INTO met_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ne lipu hananiangamdi yanamidingdi digabu lipu hanaunaunga tubatubainganamdi dibagu axamang haringing xaidi libudi, saing dilungu garadi duwagi Urana Numang yabania ba, “Taiti Urana yanoa mana Xaitamoxi Debit Garanoa ba.” Binabu gamodingdi didoa mana. ");
INSERT INTO met_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Saking duxusunga Yesu ba, “Ai, ulungu garadi li haruangadinga?” Yesu haxuya ba, “Wane, ngalungu baing. Ne, bola atiti Urana Xuanoa te? Haruanga li wa mana Olaidi, lipu buningam harua na Urana ba: “ ‘Utubatuba garadi xaung gara kambagindi ba disina yaya naung.’ ” ");
INSERT INTO met_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Baing sauyadi saing sok long sabangga mala, ila longga Betani, saing kinu la ba. ");
INSERT INTO met_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Buraraging sibuna Yesu haxa mala long sabangga muli, baing gesagina. ");
INSERT INTO met_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bagu xai xangingam tela duxu ba pik daxanga rubinia. Ila haxek mana bu sai mana marandi, ne bagu londi ding ganiding duwa. Baing harua na xaiya ba, “Sanga ba ua muli te!” Baing hata sibuna li xaiya ba mutuxu. ");
INSERT INTO met_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Lipudi dinaxu mana dibagu, baing dihixi mana. Duxusunga ba, “Xaiya pik mutuxu sap buk baru?” ");
INSERT INTO met_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu baladi ba, “Maxung sibuna ngabalang ba, nabu ang hatumingaim haringing sibuna, hatumingaim luwa te, bing sanga ba alibu taininau bila ngalibu mana xaiya pikka li. Baing bagula adali axa na bila aharua na bimbia li ba, ‘Umesa, utinggung mari tegia,’ baing bagula sok. ");
INSERT INTO met_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nabu ahatum haringina saing asabu, bing baraxing baraxinta axusunga mana, bagula axap.” ");
INSERT INTO met_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu luxu Urana Numang yabania saing ungguti tubatuba lipudi. Baing lipu hananiangamdi yanamidingdi xaung lipu haringindi dima rangua saing duxusunga ba, “Oxop yaya ba rangua gaxarea bu ulibu axadi bagudi li? Gaxarea mogung ba ulibudi?” ");
INSERT INTO met_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu haxuya ba, “Bagula ngaxusungang xusunganga tela to. Nabu abaxanga nanga, bing bagula ngabaxanga ngaxap yaya ba rangua gaxarea bu ngalibu axadi bagudi li. ");
INSERT INTO met_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Tauna, bungina Yon sugua lipudi—Gaxarea sina yaya na bu libu? Urana kimbo lipudi?” Dahangixaya liwe mading ba, “Nabu taharua ba, ‘Urana sina,’ bing bagula xusunga kira ba, ‘Ne baruta ahatum haringina mana Yon te?’ ");
INSERT INTO met_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ne nabu taharua ba, ‘Lipudi disina,’ bing tamaxuwa lipudi bagula dahanggalangia kira, namua na dahatum ba Yon ba Urana lipuxing suxunguxunguam tela.” ");
INSERT INTO met_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Baing ina naga, dahaxuya ba, “Am gaxabia te.” Baing Yesu haxuya ba, “Tauna, nga xauna, bagula ngabalang te ba gaxarea sina yaya nanga bu ngalibu axadi bagudi li. ");
INSERT INTO met_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ahatumia baru? Lipu tela garang lup luwa. Ila rangua sabangua saing harua ba, ‘Garagua, hatata ula uwaxata wain umangania.’ ");
INSERT INTO met_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Haxuya ba, ‘Tegu. Hauxagu.’ Ne kimuya xugia hatuminganoa saing ila. ");
INSERT INTO met_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Baing tibuding ila rangua kixinginoa saing harua maxang taininau. Haxuya ba, ‘Wane tibugu.’ Ne ila teke. ");
INSERT INTO met_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Luwa baruamta libu tibuding murunganoa?” Dahaxuya ba, “Mugamugangama.” Baing Yesu baxanga namuxinoa ba, “Maxung sibuna ngabalang ba, lipu takis xabinganamdi xaung haing daxangamdi diluxu Urana Yonggaxinia muga mang. ");
INSERT INTO met_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Namua na Lipu Suguangama Yon ma ranguang bu hatanga nang kubolu maringina daxanganoa, ne ahatum haringina mana te. Ning lipu takis xabinganamdi xaung haing daxangamdi dahatum haringina. Baing abagu axa ba sok, ne axugia hatumingaimdi te, ahatum haringina mana te. ");
INSERT INTO met_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Alungu haruanga babung tela muli to. Titi moxong tela xuma wain umangang tela. Tongtongia gamgaminga taxiya, saba wain marang ruhangam yabana mari siangia, saing tongtongia xahi wasangam maxaxayam tela. Saking sina na lipu umangamdi, duwaxata bu daxap marang hataindi nading, saing ing sibuna ila haxa mauli hasoya. ");
INSERT INTO met_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Bunging moyangama sok, baing soxi lipuxing haulingamdi mala rangua lipu umanga wasanganamdi bu daxap wain marang hataindi ranguadi. ");
INSERT INTO met_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ne lipu umanga wasanganamdi dituxu lipuxing haulingamdi, ditaha tela, dung tela mati, saing daxatu tela siangia. ");
INSERT INTO met_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Baing kimuya soxi lipu haulingam teladi muli nadi, titingadinga dali mugamugangamdi soxidi mala, saing dilibu kubolu taininau manadi. ");
INSERT INTO met_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kimu sibuna, soxi garanoa mala ranguadi. Hatum ba, ‘Bagula dilungu garagu haruanganoa.’ ");
INSERT INTO met_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ning bungina lipu umanga wasanganamdi dibagu garanoa, daharua nading ba, ‘Moxona garanoa lo. Kimuya bagula xap tibuna xalingindi. Tala taung mati, bing xalingindi bagula dima rimaria.’ ");
INSERT INTO met_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Binabu dituxu diting mala sangua umangua saing dung mati. ");
INSERT INTO met_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Tauna, ahatum baru? Bungina wain umangang moxonoa ma, bagula ria lipu umanga wasanganamgadi ba baru?” ");
INSERT INTO met_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Lipu yayamdi dahaxuya ba, “Bagula hanggalangia lipu dianadi ba sibuna laing dimati, saing ta umangua lipu wasanganam teladi rimadingia, saing mana bunging moyangama bagula disina hataina na ina sap.” ");
INSERT INTO met_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Baing Yesu xusungadi ba, “Haruanga li wa Urana Xuania, atiti ba ne baruta ahatumia te? Harua ba, “ ‘Sianga lipu numa tongtongianganamdi dihitixiya bila diana, sok siang mugamugangam bu haringia numa rubing longgalo. Toxoratamona libu axa baguli sok, saing am gabagu, xai sibuna maxamamia.’ ");
INSERT INTO met_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Binabu ngabalang ba Urana bagula unia Yonggaxinoa sangua rimaimdi saing sina na bakbak tela bagula daxap aningonoa masok. ");
INSERT INTO met_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Lipu gaxarea xungdi mari mana siangga li bagula duxurutiti, saing lipu gaxarea siangga li xung mari manadi, bagula dimunanggi.” ");
INSERT INTO met_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Lipu hananiangamdi yanamidingdi digabu Parisidi dilungu Yesu haruangang babundi, baing daxabia ba su haruangadi ba nadi. ");
INSERT INTO met_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Disai daxanga bu dituxu, ning dimaxuwa mana burangua, namua na lipudi dahatum ba Yesu Urana lipuxing suxunguxunguam tela. ");
INSERT INTO met_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu baladi haruanga babung teladi muli. Harua ba, ");
INSERT INTO met_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Long Xaiya Yonggaxinoa bila li. Xaitamoxi tela xauxau taunga yaungam sabanga mana garang luba. ");
INSERT INTO met_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Xauxau masup, baing soxi lipuxing oxatamdi mala rangua lipuadi xusungadi ba dima ba, bu duwagidi ma. Ne hauxading! ");
INSERT INTO met_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Baing soxi lipu oxatam teladi muli mala bu dibaladi ba, ‘Taunga xauxau masup ba. Bapalodi xaung kau dungmanangandi ditutudi masup, axadi daxauxau ba. Ama yaunga taungania.’ ");
INSERT INTO met_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ne lipudi xusungadi ba dima ba, dahatumia te saing dila dituxu ding oxatadingdi. Tela ila umangia, tela ila mana sianging oxatanoa. ");
INSERT INTO met_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Teladi dituxu uleginamdi, dilibu doa manadi saing dungdi mati. ");
INSERT INTO met_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Xaitamoxi atin disala haringina, saing soxi lipuxing haungingamdi mala bu dahanggalangia lipu ungingamgadi ba xaung bu ditung yabadinga. ");
INSERT INTO met_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Baing bala lipuxing oxatamdi ba, ‘Yaunga taunganoa xauxau ba, ne lipudi ngaxusungadi ba dima ba, ding lipu xaidi te ba dima. ");
INSERT INTO met_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ala mana daxanga soking longgalo, saing axusunga lipu gaxarea abagudi ba dima yaunga taungania.’ ");
INSERT INTO met_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Binabu lipu oxatamdi dila mana daxangadi saing daxap lipu gaxarea dibagudi, lipu xaidi xaung lipu diandi, saing dima dirung numa xangingamia saing baxagi sibuna. ");
INSERT INTO met_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ne bungina xaitamoxi luxu ma bu bagu lipudi, bagu lipu tela sau yauyaunga yaungam te bila lipudi disau xaidap yaungamia. ");
INSERT INTO met_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Xusunga ba, ‘Riagu, usau yauyaunga yaungamdi te. Uluxu ma baru?’ Ne lipua ba haruangan te. ");
INSERT INTO met_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Baing xaitamoxi bala lipu taunga oxatanamdi ba, ‘Agoxi kindi rimandi, saing ating mala sabasabia, labiania, longga lipudi ditang haringina saing digaxu waidingdi.’ ” ");
INSERT INTO met_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Baing Yesu harua ba, “Alungu to. Urana wagi lipu xumana, ne mogu taining tainina ing ganina ba diluxu ma.” ");
INSERT INTO met_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Baing Parisidi dila digugunia bu dahau hatumingua ba dilibu Yesu harua haruanga tela sanga ba disu haruanga mana. ");
INSERT INTO met_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Disoxi lipuxidingdi dinaxu manadi digabu Herot bakbaging teladi mala bu digugunia rangua. Daharua ba, “Lipu Tubatubaingam, am gaxabia ba ung lipu haruanga maxunama. Utubatuba Urana daxanganoa xaung haruanga maxuna, saing uhatum xumana mana lipudi hatumingadinga te. Ulibu hasusu mana lipu longgalo, heku lipu yayamdi kimbo lipu yaya teguamdi. ");
INSERT INTO met_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tauna, ubaxanga nam. Maring mana tagim takis mala na Sisa, kimbo doa? Uhatum baru?” ");
INSERT INTO met_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ne Yesu xabia hatumingading diana saing harua ba, “Ang lipu manang luwadi! Baruta atuba ba atuxu murak manga? ");
INSERT INTO met_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ahatanga siang mukiring tela nanga agim mala na Sisa.” Daxap Rom siang mukiring tela ma, ");
INSERT INTO met_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","baing xusungadi ba, “Gaxarea babunoa li? Gaxarea yanoa wa mana?” ");
INSERT INTO met_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Dahaxuya ba, “Sisa naga.” Baing harua nadi ba, “Tauna, axadi Sisa iniadi, asinadi na Sisa, saing axadi Urana iniadi, asinadi na Urana.” ");
INSERT INTO met_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Dilungu haruanga baguba, baing dihixi mana. Baing disauya dilauba. ");
INSERT INTO met_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mana xaidapka baguba gugunianga Sadyusi telamdi dima rangua Yesu bu duxusunga mana axamang tela. Ding dahatiam mana lipudi bagula dimesa muli. ");
INSERT INTO met_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Daharua ba, “Lipu Tubatubaingam, Moses bung Urana Xuania ba, ‘Nabu lipu tela mati garang tate, bing kixinginoa bagula yau sabanganoa tabinoa bu tang daxap garadi masok, saking sabanganoa bakbagindi bagula disup te.’ ");
INSERT INTO met_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tauna, bunging tela neng sabangang 7 duwa liwe mam. Mugamugangama yau saing mati garang tate, binabu kixinginoa yau tabinoa. ");
INSERT INTO met_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Luwa xaung hiliadinga kubolu taininau, ila ila laing disup. ");
INSERT INTO met_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Baing ina naga, hainga mati. ");
INSERT INTO met_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tauna, kimuya, bungina lipudi dimesa muli, bing haingga ba bagula wa gaxarea haininoa sibuna? Namua na 7 ding diyau ba.” ");
INSERT INTO met_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu haxuya ba, “Hatumingaimdi didoa, namua na axabia Urana Xuanoa te xaung haringinganoa. ");
INSERT INTO met_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bungina lipudi dimesa muli, bagula lup haing diyau ding te. Bila balau bagula duwa bila Urana uleginamdi duwa long xaiya. ");
INSERT INTO met_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ne mana haruangua mana lipudi dimesa muli—ngabo ba ngaxusungang to. Atiti Urana Xuanoa harua mana axa ba, ne baruta ahatumia te? Kimu sibuna mana mugangaradi Ebraham, Aisak xaung Yekop tung dimati ba, Urana harua ba, ");
INSERT INTO met_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ngawa Urana mana Ebraham, Urana mana Aisak, xaung Urana mana Yekop.’ Binabu ina Urana mana lipu matiandi te. Tegu. Ina Urana mana lipu gamatandi.” ");
INSERT INTO met_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Burangadi dilungu haruanganoa, baing dihixi mana tubatubainganoa. ");
INSERT INTO met_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Bungina Parisidi dilungu ba Yesu libu Sadyusidi dimumguti, bing digugunia bu dituba muli. ");
INSERT INTO met_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Dingia tela xabia hanaunaungua xai sibuna. Baing tuba Yesu mana xusunganga baguli: ");
INSERT INTO met_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Lipu Tubatubaingam, hanaunaunga Urana sina na Moses baruamta mugamuga?” ");
INSERT INTO met_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu haxuya ba, “ ‘Bing ung murum sibuna mana Toxoratamona, Urana ungia, mana gamom longgalo xaung lum longgalo xaung hatumingam longgalo.’ ");
INSERT INTO met_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hanaunaunga baguli sabanga, xaung mugamugangam sibuna. ");
INSERT INTO met_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Baing luwa bing bila mugamugangama: ‘Bing ung murum sibuna mana riam longgalo bila ung murum sibuna maung.’ ");
INSERT INTO met_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Hanaunaunga luwa li bing namuxina mana hanaunaunga longgalo Moses bung xaung mana haruanga longgalo Urana lipuxing suxunguxunguamdi dibung.” ");
INSERT INTO met_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisidi diguguniauyu taxiya Yesu, baing xusungadi ba, ");
INSERT INTO met_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ahatum baru mana Urana Lipuxing Mogunganama? Gaxarea garanoa?” Dahaxuya ba, “Xaitamoxi Debit Garanoa.” ");
INSERT INTO met_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Harua nadi ba, “Tauna, baruta Urana Aningonoa sina hatuminga na Debit, saing Debit uxu lipua ba ‘Toxoratamona’? Namua na Debit harua ba, ");
INSERT INTO met_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Toxoratamona harua na Toxoratamona ngayua ba: “Urung kabukabu yayam wa rimagu rimamo rubinia, laing ngata bixuamdi hawa maung.” ’ ");
INSERT INTO met_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nabu Debit uxu ba ‘Toxoratamona,’ bing ina wa Debit garanoa xauna baru?” ");
INSERT INTO met_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Dingia tela sanga ba haxuya Yesu haruanganoa te. Baing kimuya mana bungina baguba, lipu longgalo dimaxuwa mana dituba mana xusunganga tela muli. ");
INSERT INTO met_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kimuya Yesu harua na burangadi xaung lipuxindi dinaxu mana ba, ");
INSERT INTO met_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Lipu hanaunaunga tubatubainganamdi xaung Parisidi ding lipu yayamdi bu dibaxanga hanaunaunga Urana sina na Moses namuxinoa. ");
INSERT INTO met_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Binabu alungu asu mana haruangadinga. Ne kubolua dilibudi, labu asu manadiu tai. Tegu. Namua na disu mana ding haruangadinga te. ");
INSERT INTO met_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bila dibibi axamang mauxangang sibundi, ditadi etua mana lipudi yaxudingdi bu doxoxi, ne dahaulidi monga te. Hauxading. ");
INSERT INTO met_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Kubolu longgalo dilibudi, dilibudi bu lipudi dibagudi. Digoxi raxu sabungam sabangadi toxodingia rimadingia, saing digoxi waxu maxaxayadi mana imangiding sihindi bu lipudi dahatum ba disu mana Urana maringina. ");
INSERT INTO met_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ding muruding buk mana dirung mana kabukabu yayamdi mana taungadi xaung mana dirung mana kabukabu mugamugangamdi mana sabunga numandi. ");
INSERT INTO met_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Muruding buk mana lipudi ditidi daharua xaidap xai nadi mana nawa yabandi xaung mana duxudi ba ‘Lipu Tubatubaikkam.’ ");
INSERT INTO met_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ne labu anai mana lipu tela uxuang ba ‘Lipu Yayamgu’ tai, namua na ang lipuxim yayam taininau ing ganina, saing ang longgalo awa hasusu bila riaim riaim. ");
INSERT INTO met_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Baing labu auxu lipu titiam tela ba ‘Tibuimgu’ tai, namua na Urana wa long xaiya ing ganina ang Tibuim. ");
INSERT INTO met_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Baing labu anai mana lipu tela uxuang ba ‘Lipu Tubatubaikkamgu’ tai, namua na ang lipuxim tubatubaikkam taininau, ina Urana Lipuxing Mogunganama. ");
INSERT INTO met_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Lipuxim yayama bing wa lipuxim haulingam. ");
INSERT INTO met_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Urana bagula tatua lipu gaxarea diti yadingdi, saing bagula sina yaya na lipu gaxarea ditatua ding. ");
INSERT INTO met_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Laku, ang lipu hanaunaunga tubatubainganamdi agabu Parisidi, ang lipu manang luwamdi! Mauxanganoa xapkang yu! Asoxauti Long Xaiya Yonggaxing xaluxinoa mana lipudi ramramodinga. Ang sibuim aluxu te, saing asoxauti teladi ba diluxu xauna. ");
INSERT INTO met_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Laku, ang lipu hanaunaunga tubatubainganamdi agabu Parisidi, ang lipu manang luwamdi! Mauxanganoa xapkang yu! Namua na ahaxahaxa mauli titia tegia bu alibu lipu taininau ing ganina hatum haringina mana tubatubaingaima. Saking bungina xugia ma rangua hatumingaima, alibu sok long salakkam lipuxing sibuna, alibu dali sibuna ang kuboluim diandi! ");
INSERT INTO met_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Laku, namua na ang bila lipu maxa haxatiandi atuba ba axai lipudi mala! Mauxanganoa xapkang yu! Aharua ba, ‘Nabu lipu tela haringia haruanganoa xaung Urana Numanoa, bing axamang olang. Ne nabu haringia haruanganoa xaung gol wa Urana Numania, bing su mana haruanganoa.’ ");
INSERT INTO met_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ang lipu maxa haxatiang kakahandi! Baraxinta mugamuga Urana maxania? Gol wa Urana Numania, kimbo Urana Numanoa sina yaya na gol ba? Urana Numanoa baing! ");
INSERT INTO met_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Haruanga tela muli aharua ba, ‘Nabu lipu tela haringia haruanganoa xaung kabukabu hananiangam, bing axamang olang. Ne nabu haringia haruanganoa xaung hananiangua wa etua mana, bing su mana haruanganoa.’ ");
INSERT INTO met_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ang lipu maxa haxatiandi! Baraxinta mugamuga Urana maxania? Hananiangua, kimbo kabukabu hananiangam sina yaya na hananiangua ba? Kabukabu hananiangama baing! ");
INSERT INTO met_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bungina lipu tela haringia haruanganoa xaung kabukabu hananiangamga ba, ina haringia haruanganoa xaung kabukabua xaung axamang longgalo duwa etua mana. ");
INSERT INTO met_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Baing lipu gaxarea haringia haruanganoa xaung Urana Numanoa ba, ina haringia haruanganoa xaung Urana Numanoa xaung Lipua wa maluxu mana. ");
INSERT INTO met_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Baing lipu gaxarea haringia haruanganoa xaung long xaiya ba, ina haringia haruanganoa xaung Urana xaitamoxi kabukabung rungingama, xaung Lipua rung mana kabukabua ba. ");
INSERT INTO met_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Laku, ang lipu hanaunaunga tubatubainganamdi agabu Parisidi, ang lipu manang luwamdi! Mauxanganoa xapkang yu! Asina hataina 10 mana axamang kaxukang sibundi duwa umangaimia. Ne ahalingalinga axamang hanaunaungam sabangadi—suxuyanga maringina, usinganga xaung hatuminga haringina. Maring bing asina hataina 10, wane, ne labu ahalingalinga axamang hanaunaungam sabangadiu tai. ");
INSERT INTO met_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ang bila lipu maxa haxatiandi atuba ba axai lipudi mala! Kubolua alibu bungina ahatumia axamang kaxukandi ne ahalingalinga axamang sabangadi bila ata hunghung ba soxauti nimnim tela nanggolia bu angaru te, ning angaru kamel tela xaung langga ba! ");
INSERT INTO met_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Laku, ang lipu hanaunaunga tubatubainganamdi agabu Parisidi, ang lipu manang luwamdi! Mauxanganoa xapkang yu! Kubolua alibu bila adamia xuba mina ubudingdi, ne ludingia dibaxagi mana axadi axapdi mana kubolu samoyana xaung ati haringina. ");
INSERT INTO met_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ang Parisi maxa haxatiandi! Muga bing adamia ludingdi, baing ubudingdi bagula sigixinga xauna. ");
INSERT INTO met_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Laku, ang lipu hanaunaunga tubatubainganamdi agabu Parisidi, ang lipu manang luwamdi! Mauxanganoa xapkang yu! Ang bila guhia gobagobadi disami usamana. Ding gumangiding sabasabia, ne ludingia dibaxagi mana matia tuandi xaung axamang musunamdi. ");
INSERT INTO met_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Bila balau, sanggaimia lipudi dibaguang bila lipu maringindi, ne luimia abaxagi mana mana luwa xaung kubolua adali hanaunaungua. ");
INSERT INTO met_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Laku, ang lipu hanaunaunga tubatubainganamdi agabu Parisidi, ang lipu manang luwamdi! Mauxanganoa xapkang yu! Atongtongia guha gobagoba gumangindi mana Urana lipuxing suxunguxunguamdi mugangaimdi dungdi mati ba, saing ayauyau lipu maringindi gobagobadingdi. ");
INSERT INTO met_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Saking aharua ba, ‘Nabu tawa bungina mugangaradi, bing tagugudi taung Urana lipuxing suxunguxunguamdi te.’ ");
INSERT INTO met_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ne bungina aharua bila ba, asu haruanga nang sibuim ba ang naga awa mugangaimdi dung Urana lipuxing suxunguxunguamdi ba garadingdi. ");
INSERT INTO met_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tauna alauba, asahi kubolu diandi mugangaimdi dungguti ba! ");
INSERT INTO met_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ang moxadi! Ang moxa diang garandi! Bagula agiti mala sangua suxuyangua soxi lipudi mari long salakkamia baru? ");
INSERT INTO met_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Binabu alungu to. Bagula ngasoxi Urana lipuxing suxunguxunguamdi xaung lipu xabianga maringindi xaung lipu tubatubaingamdi mala ranguang. Teladi bagula aungdi mati xai balingamia. Teladi bagula agusidi mana sabungaim numandi, axudi mala mana long sabangadi taining tainina, asina salaga nadi. ");
INSERT INTO met_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Baing ina naga, lipu maringing longgalo sibidingdi bagula duwa rimaimia—ungguti mana dung lipu maringina Ebal, ma ma laing Barakaya garanoa Sekaraya ina awa haruangia mana, dung liwe mana kabukabu hananiangam xaung Urana Numang luna. ");
INSERT INTO met_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Maxung sibuna ngabalang ba, lipu hatatamdi bagula duwa haruangia mana ding longgalo sibidingdi. ");
INSERT INTO met_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Yerusalem, Yerusalem, ang gaung Urana lipuxing suxunguxunguamdi mati, saing lipudi Urana soxidi nang axatudi siangia mati. Bunging xumang sibuna ngabo ba ngagugunia lipuximdi, bila muxaxu hagaxana gugunia garandi hawa mana banggitongindi, ne hauxaim! ");
INSERT INTO met_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Bagu Urana yunga yabaima saing xola. ");
INSERT INTO met_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Namua na ngabalang ba, bagula abagu nga muli te, laing xaidaba aharua ba, ‘Urana sina guxama na lipua li ma mana Toxoratamona yanoa ba.’ ” ");
INSERT INTO met_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu sauya Urana Numang yabania saing haxa mala, baing lipuxindi dinaxu mana dima rangua. Dibo ba dahatanga Urana Numang numandi na. ");
INSERT INTO met_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ne xusungadi ba, “Abagu numadi ba? Maxung sibuna ngabalang ba, xaidaba ma yu bungina siang tela bagula wa etua mana rianoa te. Tegu. Bagula ding longgalo disup mari.” ");
INSERT INTO met_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kimuya, Yesu rung Xaxagania Olip. Lipudi dinaxu mana ding ganiding dima rangua, saing daharua ba, “Ubaxanga nam, bungintabi bagula axadi bagudi li disok? Baing baraxinta bagula sok muga bu hatanga malingama bo ba sokkuba, xaung bu hatanga xaidap subinganoa bo ba mauba?” ");
INSERT INTO met_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu haxuya ba, “Amaxania, nam lipu tela langlanguang. ");
INSERT INTO met_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Namua na xumana bagula dima dilangua daxap yagua saing bagula daharua ba, ‘Nga Urana Lipuxing Mogunganama baing.’ Bagula dituxu murak mana lipu xumana. ");
INSERT INTO met_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Bagula alungu haruanga mana haungingadi duwa haxek, duwa hasoya, ne amaxania—labu ahixi manadiu tai. Axadi na bila ba bagula disok to, ne subinganoa sok teguyu. ");
INSERT INTO met_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Numanumadi bagula dimesa dahaunggana ding, saing yonggadi bagula dilibu taininau. Gesak sabangadi xaung noxiga sabangadi bagula disok long xangxana. ");
INSERT INTO met_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ne axadi bagudi li unggutingua ing ganina, bila bungina haing tela ungguti xunumia salak hayauxingamdi. ");
INSERT INTO met_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Baing bagula dituxuang, disina salaga nang, xaung dunggang mati. Bagula numanumadi hauxading sibuna mang namua na anaxu manga. ");
INSERT INTO met_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mana bungina baguba, xumana bagula diyamu mana dahatum haringina manga, saing bagula dita riadingdi bixuadingdi rimadingia saing bagula hauxading sibuna mana ding. ");
INSERT INTO met_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Lipudi dilangua ba ding Urana lipuxing suxunguxunguamdi bagula dimesa, saing bagula dituxu murak mana lipu xumana. ");
INSERT INTO met_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kubolu diana bagula tubu, binabu lipu xumana murungadinga bagula mati. ");
INSERT INTO met_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ne lipu gaxarea dili haringina laing matiading xaidabidingdi, Urana bagula xapdi muli. ");
INSERT INTO met_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Baing ulek xaiya li mana Long Xaiya Yonggaxinoa, lipudi bagula dibaxanga titi hataing longgalo bu numanuma longgalo dilungu ba. Baing ina naga, xaidap subinganoa bagula ma. ");
INSERT INTO met_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ne muga mana titia sup, bagula abagu ‘axamang maxuwangam hanggalangiangam’ li mua long bilingamia maluxu Urana Numania—axamana ba Urana lipuxing suxunguxunguama Danyel harua mana.” (Lipu gaxarea dititi haruanga baguli bing dahatumia haruanga li xai!) ");
INSERT INTO met_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Baing lipudi duwa titia Yudia bing diluki mala bimbia. ");
INSERT INTO met_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Lipudi duwa numa ubunia, labu diri numia digam xalingiding teladiu tai. ");
INSERT INTO met_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Lipudi duwa umangia, labu digoxoya numia bu daxap imangiding sabangadiu tai. ");
INSERT INTO met_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Baing usinganga buk mana haingdi gamoding xaung hainggadi disina sua na garadingdi mana bungina baguba! ");
INSERT INTO met_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Asabu ba gitingaima sanga ba sok bunging kuyama kimbo Xaidap Yaguangam te. ");
INSERT INTO met_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Namua na salaga mana bungina baguba bagula dali salaga mana bunging longgalo, ungguti mana Urana tongtongia axamandi laing hatata, saing kimuya mauxangana bila bagula hasusu muli te. ");
INSERT INTO met_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ne bungina baguba, nabu Urana raxapkuti te, bing lipu longgalo bagula disup. Ne mana namua hatumia lipuadi ina mogudi ba ing ganina, ina bagula raxapkuti. ");
INSERT INTO met_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Baing mana bungina baguba, nabu lipu tela harua nang ba, ‘Abagu, alali Urana Lipuxing Mogunganama!’, kimbo lipu tela harua ba, ‘Abagu, la lo!’, bing labu ahatum haringina manau tai. ");
INSERT INTO met_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Namua na lipudi bagula dima dilangua ba ding Urana Lipuxing Mogunganama kimbo dilangua ba ding Urana lipuxing suxunguxunguamdi. Bagula disok dilibu axamang haringing sibung xangxana bu dilanglangua lipudi. Bagula dituba ba dibagu nabu sanga ba dilanglangua lipuadi Urana mogudi ba xauna. ");
INSERT INTO met_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Alungu. Ngabaxanga alali nang muga bu amaxania. ");
INSERT INTO met_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Baing ina naga, nabu lipu tela balang ba, ‘Abagu, wa long xoliania,’ bing labu asok malau tai. Baing nabu balang ba, ‘Wa la li, hisa numa lunia,’ bing labu ahatum haringina manau tai! ");
INSERT INTO met_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ahatumia. Bungina abagu bilikbiliga, ralanoa su sabalung subingang longgalo, ungguti karagia ila yuwaxia. Bila balau, Lipua Ma Rangua Urana malinganoa, bagula lipu longgalo dibagu daxabia. ");
INSERT INTO met_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nabu matia tela wa mana long tela, bagula matikomkomdi digugunia la ba. ");
INSERT INTO met_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Haxek sibuna kimuya mana bunging salakkamga ba, “ ‘xaidaba bagula laba, saing sobaga bagula sina te, hatungdi bagula xungdi mari sangua sabalunoa, saing axamang haringindi duwa sabalunia bagula dilulu.’ ");
INSERT INTO met_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Baing ina naga, bagula lipudi dibagu axamang tela sabalunia hatanga ba Lipua Ma Rangua Urana ma, saing numanuma titiamdi bagula dahatangitangi. Bagula dibagu Lipua Ma Rangua Urana ma mana mugap sabalunamdi xaung haringinganoa xaung ralang sabanga. ");
INSERT INTO met_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Baing toxi bagula sau sabanga, saing bagula soxi Urana uleginamdi mala hataing hataina, bu digugunia lipuadi ina mogudi ba mana titi subingang tela mala subingang tela. ");
INSERT INTO met_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Abagu xaiya pik saing axap xabianga mana: Bungina rimandi digamata saing lona, axabia ba gesaga sokkuba. ");
INSERT INTO met_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bila balau, bungina abagu axadi bagudi li disok, axabia ba xaidaba wa haxek ba, wa xaluya baing. ");
INSERT INTO met_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Maxung sibuna ngabalang ba, bagula lipu hatatamdi disup teguyu, laing axadi bagudi li disok to. ");
INSERT INTO met_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sabaluna xaung titi bagula disup, ne xuagu marandi sanga ba disup te. ");
INSERT INTO met_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ne lipu tela xabia xaidaba xaung xaidap maxanoa te mana axadi bagudi li bagula disok. Urana uleginamdi daxabia te. Urana Garanoa xauna, ina xabia te. Tibugu ing ganina xabiau. ");
INSERT INTO met_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Lipua Ma Rangua Urana malinganoa bagula wa bila Noa xaidabinoa. ");
INSERT INTO met_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Muga mana langa si sabanga, lipudi daxang, dinung, diyau ding laing xaidapka Noa luxu wagia ba. ");
INSERT INTO met_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Lipudi daxabia baraxinta bagula sok te, laing langa si saing xapdi mala. Bagula wa bila ba bungina Lipua Ma Rangua Urana ma. ");
INSERT INTO met_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Lipu luwa bagula duwa umangia. Tela bagula daxap, ne tela bagula diyunga. ");
INSERT INTO met_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Haing luwa bagula dahamunanggia wit marandi siangia. Tela bagula daxap, ne tela bagula diyunga. ");
INSERT INTO met_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Binabu amaxania, namua na axabia xaidaba te Toxoratamona angia bagula ma. ");
INSERT INTO met_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ne ahatumia: Nabu numa moxonoa xabia muga xaidap maxanoa lipu hanaunggama bagula ma, bing sanga ba maxania saing yunga numanoa te bu hanai. ");
INSERT INTO met_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Binabu ang xauna bing axauxau bungingbunginalo, namua na Lipua Ma Rangua Urana bagula ma bungina ahagaxa ba bagula ma te. ");
INSERT INTO met_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Lipu oxatam xabiangang xai xaung tuxu oxatang longgalo xai, lipua na bila baru? Ahatumia. Bila lipua numa moxonoa mogu ba ulia lipuxing haulingamdi angiadinga mana bungina mogu ba. ");
INSERT INTO met_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nabu lipu oxatamga ba tuxu oxatanoa bungina moxonoa goxoya ma, bing numa moxonoa bagula yaha sibuna mana. ");
INSERT INTO met_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Maxung sibuna ngabalang ba, bagula mogu ba wasa mana xalinging longgalo. ");
INSERT INTO met_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ne nabu lipu oxatamga ba lipu diana, saing balaina ba, ‘Lipuxigua haringina bagula goxoya ma sap te.’ ");
INSERT INTO met_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Baing ungguti taha riang haulingamdi, saing xang nung xaung lipudi dinung lang haringina buk. ");
INSERT INTO met_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Numa moxonoa bagula goxoya ma mana xaidap tela lipu oxatama hagaxa te xaung xaidap maxanoa xabia te. ");
INSERT INTO met_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Numa moxonoa bagula hanggalangia lipuxing oxatama saing ta mana longga lipu manang luwamdi duwa, longga ba lipudi ditang haringina saing digaxu waidingdi. ");
INSERT INTO met_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Mana bungina baguba Long Xaiya Yonggaxinoa bagula bila haing nanung 10 daxap nagungidingdi, saing disok mala bu digugunia lipu tela ma bu yau haing tela. ");
INSERT INTO met_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Luwadi luwadi hiliadinga hatumingadingdi dimaring te, saing luwadi luwadi hiliadinga hatumingadingdi daxai. ");
INSERT INTO met_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Haing nanung kakahandi dirai nagungidingdi, ne daxap guxenga teladi muli mala te. ");
INSERT INTO met_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ne luwadi luwadi hiliadinga hatumingadingdi daxai ba, duxu guxenga tela mana nanggoladingdi, diraidi mala xaung nagungidingdi. ");
INSERT INTO met_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ne lipu yaunga haunama ma sap te, binabu maxadingdi dikinu saing dikinu. ");
INSERT INTO met_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Yambong lia dilungu lipu tela wagi ba, ‘Ai! Lipu yaunga haunama ma! Ama to, agugunia!’ ");
INSERT INTO met_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Baing haing nanunadi ba dimesa dahamaringia nagungidingdi. ");
INSERT INTO met_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Haing kakahandi daharua na adi hatumingadingdi daxai ba, ‘Si! Nagungimamdi dibo ba dimatiuba. Auliam guxengaim teladi.’ ");
INSERT INTO met_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ne dahaxuya ba, ‘Tegu. Amiadi bagula sanga mana kira longgalo te. Ala rangua lipu sinaikkamdi, bu agim teladi nang.’ ");
INSERT INTO met_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ne bungina dahaxa mala bu digim guxenga, lipu yaunga haunama sok baing. Haing nanunadi daxauxau masup diluxu rangua mana yaunga taunganoa, saing lipudi diriba xalua. ");
INSERT INTO met_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Kimuya, haing nanung teladi digoxoya ma, saing dili sabasabia duwagi ba, ‘Lipu Sabanga! Lipu Sabanga! Uxaxa xalua mam!’ ");
INSERT INTO met_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ne haxuya ba, ‘Maxung sibuna ngabalang ba, ngaxabiang te.’ ” ");
INSERT INTO met_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Baing Yesu sahi haruanganoa ba, “Binabu ang xauna, bing amaxania! Namua na axabia xaidaba xaung xaidap maxanoa te Lipua Ma Rangua Urana bagula goxoya ma. ");
INSERT INTO met_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Tela muli baing. Mana bungina baguba Long Xaiya Yonggaxinoa bagula wa bila li. Lipu tela bo ba ila mana long hasoyam tela. Wagi lipuxing oxatamdi ma saing ta xalingindi rimadingia bu duwasa manadi. ");
INSERT INTO met_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sina tanga gol luwadi luwadi hiliadinga na tela, tanga gol luwa na tela, saing tela sina tanga gol taininau na. Sina na taining tainina sanga mana ding xabiangading wasanganamdi. Sup, baing ilauba. ");
INSERT INTO met_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Lipu oxatama xap tanga gol luwadi luwadi hiliadinga ungguti sap ba tuxu oxata sianggama, saing xibuadi, baing disok tanga gol luwadi luwadi hiliadinga muli. ");
INSERT INTO met_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bila balau, lipua xap tanga gol luwa xibuadi, baing disok luwa muli. ");
INSERT INTO met_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ne lipu oxatama xap tanga gol taininau ila ki bangguma saing yameng lipuxing haringina siangindi. ");
INSERT INTO met_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Bunging maxaxaya sup, baing lipu oxatamdi lipuxiding haringina goxoya ma. Wagidi ma bu lungu diraxata mana siangindi. ");
INSERT INTO met_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Lipua xap tanga gol luwadi luwadi hiliadinga xapdi ma xaung luwadi luwadi hiliadinga muli. Harua ba, ‘Lipu sabanga, usina tanga gol luwadi luwadi hiliadinga nanga bu ngawasa manadi. Ubagu, ngaxap luwadi luwadi hiliadinga muli ba.’ ");
INSERT INTO met_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Lipuxing haringina haxuya ba, ‘Xai sibuna! Ung lipu oxatam xai, utuxu oxatama xai! Uwasa xai mana axamang kaxukandi, binabu bagula ngataung etua mana axamang xumana. Uma tayaha xauna!’ ");
INSERT INTO met_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Lipua xap tanga gol luwa ma xauna, saing harua ba, ‘Lipu sabanga, usina tanga gol luwa nanga bu ngawasa manadi. Ubagu, ngaxap luwa muli ba.’ ");
INSERT INTO met_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Lipuxing haringina haxuya ba, ‘Xai sibuna! Ung lipu oxatam xai, utuxu oxatama xai! Uwasa xai mana axamang kaxukandi, binabu bagula ngataung etua mana axamang xumana. Uma tayaha xauna!’ ");
INSERT INTO met_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Baing ina naga, lipua xap tanga gol taininau ma. Harua ba, ‘Lipu sabanga, ngaxabia ba ung lipu yabina. Oxop xalaxaladi lipu teladi duwaxata manadi. Oxop angingadi lipu teladi duxumadi. ");
INSERT INTO met_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ngamaxuwa maung, binabu ngala ngayameng siangima titia. Ubagu, siangima baguli.’ ");
INSERT INTO met_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ne lipuxing haringina haxuya ba, ‘Ung lipu oxatam diana! Ubuma haring! Nabu uxabia ngaxap xalaxaladi lipu teladi duwaxata manadi, saing ngaxap angingadi lipu teladi duxumadi, ");
INSERT INTO met_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","bing baruta uta siangigua maluxuʼm numa sianggam te? Baing bungina ngagoxoya ma bing ngaxap muli xaung siang dalingam teladi xauna.’ ");
INSERT INTO met_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Baing tabina lipuxing oxatam teladi ba, ‘Axap tanga sangua saing asina na lipua tuxu 10. ");
INSERT INTO met_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Lipu gaxarea dituxu oxata xai mana axadi daxapdi ba, bagula ngasina teladi muli nadi, saing bagula dibaxagi mana. Ne lipu gaxarea dituxu oxata xai mana axadi daxapdi ba te, baraxinta ding dituxudi, bagula ngaxapdi sanguadi muli. ");
INSERT INTO met_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Baing lipu oxatam dianoa ba, ahitixiya mala sabasabia, labiania, longga lipudi ditang haringina saing digaxu waidingdi.’ ");
INSERT INTO met_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Bungina Lipua Ma Rangua Urana ma ralania, gabu Urana uleginamdi, bagula rung mana kabukabung xaitamoxiamia. ");
INSERT INTO met_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Numanuma longgalo bagula digugunia maxania, baing bagula hata lipudi bila lipu sipsip wasanganam tela hata memedi sangua sipsipdi. ");
INSERT INTO met_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Bagula ta sipsipdi rimang rimamo, memedi xong. ");
INSERT INTO met_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Baing Xaitamoxi bagula harua na lipuadi duwa rimang rimamo ba, ‘Ang ba, Tibugu guxamgang. Ama to. Ama axap Yonggaxinoa xauxau mang ba bungina tongtongia axamandi. Xauxau bu sina nang. ");
INSERT INTO met_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Namua na, waleu gesagigu saing aulia nga anginga. Waxugutuanoa mamasa saing aulia nga lang. Ngawa lipu long telama saing axap nga mala maluxu numaimia. ");
INSERT INTO met_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ngaxola mana imangdi saing aulia nga teladi. Ngabusi saing awasa manga. Ngawa salak yabania saing ama lobu rangua nga.’ ");
INSERT INTO met_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Saking lipu maringindi bagula dahaxuya ba, ‘Toxoratamona, bungintabi am gabagung gesagim saing am gauliaung anginga? Bungintabi am gabagung waxumtuanoa mamasa saing am gauliaung lang? ");
INSERT INTO met_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Bungintabi am gabagung uwa lipu long telama saing am gaxapkung maluxu? Bungintabi am gabagung oxola mana imangdi saing am gauliaung teladi? ");
INSERT INTO met_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Bungintabi am gabagung ubusi kimbo uwa salak yabania saing am gala lobu ranguaung?’ ");
INSERT INTO met_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Xaitamoxi bagula haxuya ba, ‘Maxung sibuna ngabalang ba, baraxing baraxinta alibu mana tela mana riagu yaya teguamgadi li, bila axadi bagudi li alibudi manga.’ ");
INSERT INTO met_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Baing Xaitamoxi bagula xugia rangua lipuadi duwa rimang xong saing harua nadi ba, ‘Ang lipuadi Urana sina dianoa nang, ahaya sangua nga! Ari mala yap subingang teguamia Urana xauxau mana Satan gabu xaungandi! ");
INSERT INTO met_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Namua na, waleu gesagigu saing aulia nga anginga te. Waxugutuanoa mamasa saing aulia nga lang te. ");
INSERT INTO met_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ngawa lipu long telama saing axap nga maluxu numaimia te. Ngaxola mana imangdi saing aulia nga teladi te. Ngabusi ngawa salak yabania saing awasa manga te.’ ");
INSERT INTO met_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Saking bagula dahaxuya ba, ‘Toxoratamona, bungintabi am gabagung gesagim kimbo waxumtuanoa mamasa kimbo uwa lipu long telama kimbo oxola mana imangdi kimbo ubusi kimbo uwa salak yabania, saing am gahauliung te?’ ");
INSERT INTO met_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Baing bagula haxuya ba, ‘Maxung sibuna ngabalang ba, baraxing baraxinta alibu mana tela mana riagu yaya teguamgadi li te, bila axadi bagudi li alibudi manga te.’ ");
INSERT INTO met_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Baing bagula dila daxap salak subingang teguama, ne lipu maringindi bagula dila daxap walinga subingang teguama.” ");
INSERT INTO met_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu harua axadi li masup, baing harua na lipuxindi dinaxu mana ba, ");
INSERT INTO met_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ang gaxabiau, xaidap luwa baing Taunga Dalingama bagula sok. Mana bungina baguba bagula dita Lipua Ma Rangua Urana bixuandi rimadingia bu dung mati xai balingamia.” ");
INSERT INTO met_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mana bungina baguba lipu hananiangamdi yanamidingdi digabu lipudi lipuxiding haringindi, ding digugunia lipu hananiangam mugamugangama numania, yanoa Kayapas. ");
INSERT INTO met_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Dahau hatuminga tela ba dilanglangua bu dituxu Yesu bu dung mati. ");
INSERT INTO met_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ne daharua ba, “Labu talibu maluxuʼm bunging Taungamau tai, nam lipudi diti haunginga sabangua.” ");
INSERT INTO met_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu wa longga Betani mana Saimon lipu saksaxama numanoa (businganoa sup ba). Wa la ba, ");
INSERT INTO met_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","rung kabukabia, xang mua, baing haing tela ma rangua, tuxu nanggola siang alabastam, guxenga saminam giminak xumanam wa maluxu mana. Baing matu mari Yesu toxonia. ");
INSERT INTO met_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lipuxindi dinaxu mana dibagu, baing gamodingdi didoa. Daharua ba, “Si, sahi guxenga saminamga ba olang baru? ");
INSERT INTO met_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Xai nabu tasina na lipudi bu digim bu siangga ba tasina na lipu haxugindi. Giminaginoa sabanga sibuna!” ");
INSERT INTO met_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu xabia daharua baru, binabu harua ba, “Atautiti haingga li baru? Libu axamang xai sibuna manga. ");
INSERT INTO met_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Lipu haxugindi duwa ranguang bunging longgalo. Ne nga ba, bagula ngawa ranguang bunging longgalo te. ");
INSERT INTO met_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Haingga li matu guxenga sanggagia bu xauxau nga muga mana kimangingagua. ");
INSERT INTO met_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Maxung sibuna ngabalang ba, mana baru rubinta lipudi dibaxanga ulek xaiyua mana titi longgalo, bagula lipudi dilungu haingga li naxuyanganoa bu dahatumia muli.” ");
INSERT INTO met_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Baing tela mana Lipu 12, ina duxu ba Yudas Iskariot, ila rangua lipu hananiangamdi yanamidingdi. ");
INSERT INTO met_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Xusungadi ba, “Nabu ngasina Yesu rimaimia, bing bagula asina baraxinta nanga?” Baing dititi disina siang silba mukiring 30 na. ");
INSERT INTO met_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mana bungina baguba saing ila, sai daxanga ba ta Yesu rimadingia. ");
INSERT INTO met_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mana xaidap mugamugangam mana Taunga Mana Salanga Salalangang Teguama, lipudi dinaxu mana dima rangua Yesu duxusunga ba, “Ubo ba am gala mana long baruamta bu am gaxauxau axamandi bu oxong Taunga Dalingam angianoa?” ");
INSERT INTO met_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Baladi ba, “Ala aluxu long sabangia, baing bagula abagu lipu tela. Abala ba, ‘Lipu Tubatubaingama harua ba: Xaidabigua ma haxek ba. Bagula ngagabu lipuxigudi dinaxu manga am gaxang Taunga Dalingam angianoa numamia.’ ” ");
INSERT INTO met_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Baing ina naga, lipuadi dinaxu mana ba dilibu Yesu haruanganoa saing daxauxau Taunga Dalingam angianoa la ba. ");
INSERT INTO met_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yambongguba, baing Yesu gabu Lipu 12 daxang kabukabia. ");
INSERT INTO met_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Daxang mua, baing harua ba, “Maxung sibuna ngabalang ba, angia tela bagula ta nga bixuagudi rimadingia.” ");
INSERT INTO met_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ding gamoding mauxading, baing ding taining tainina duxusunga ba, “Toxoratamona, nga te, bo?” ");
INSERT INTO met_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Haxuya ba, “Lipua bagula ta nga bixuagudi rimadingia, angia tela menau tai salanga mari minia rangua nga. ");
INSERT INTO met_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Lipua Ma Rangua Urana bagula mati bila dibung waleu Urana Xuania. Ne laku, mauxanganoa bagula xap lipua ta Lipua Ma Rangua Urana bixuandi rimadingia! Xai buk mana lipua ba nabu waleu bauna hayau te.” ");
INSERT INTO met_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Baing Yudas, lipua bo ba ta bixuandi rimadingia, xusunga xauna ba, “Lipu Tubatubaingam, nga te, bo?” Baing Yesu bala ba, “Wane, ung ba.” ");
INSERT INTO met_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Daxang mua, baing Yesu xap salangua, harua xai sibuna na Urana, saing utu saha. Sina na lipuxindi dinaxu mana, saing harua ba, “Axap axang. Alali mututungagua.” ");
INSERT INTO met_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Baing xap xubua, saing harua xai sibuna na Urana. Sina nadi saing harua ba, “Ang taining tainina anung. ");
INSERT INTO met_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Alali sibigua mana hau Urana haruanganoa haringina, matuxuya mari bu yunga lipu xumana kuboluding diandi. ");
INSERT INTO met_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ngabalang ba, bagula nganung wain muli te laing xaidapka nganung hauna ranguang maluxu Tibugu Yonggaxinia.” ");
INSERT INTO met_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Duwaya olai tela masup, baing disok mala dila Xaxagania Olip. ");
INSERT INTO met_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Dahaxa mala, baing Yesu baladi ba, “Yambongga baguli bagula ang longgalo ang gayunga nga bungina abagu axadi disok manga, namua na Urana haruangana li wa Xuania: “ ‘Bagula ngataha sipsipdi lipuxiding wasanganama mari, baing sipsipdi bagula dahalukiana.’ ");
INSERT INTO met_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ne kimuya mana ngamesa muli, bagula ngamuga mala nang titia Galili.” ");
INSERT INTO met_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita harua na ba, “Heku nabu lipu longgalo diyungaung, nga bagula tegu.” ");
INSERT INTO met_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Baing Yesu haxuya ba, “Maxung sibuna ngabalaung ba, hatata yambong, muga mana muxaxua xatu, bagula uhatiam manga bunging tuwa.” ");
INSERT INTO met_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ne Pita haxi ba, “Heku nabu ngamati ranguaung, nga bagula ngahatiam maung te!” Baing lipu longgalo dinaxu mana, daharua taininau. ");
INSERT INTO met_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Baing Yesu gabu lipuxindi dinaxu mana dila long tela duxu ba Getsemani, saing harua nadi ba, “Arung mua la li, ngabo ba ngala yata lo ngasabu to.” ");
INSERT INTO met_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Xap Pita gabu Sebedi garandi Yems Yon tang mala rangua. Baing ayangana xaung gamona mauxang sibuna. ");
INSERT INTO met_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Baing harua na dingtung ba, “Lugua ayangana buk, bila ngabo ba ngamatiuba. Awa mua la li, awasa xai rangua nga.” ");
INSERT INTO met_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ila monga, saing yungaina mari titia, saing sabu ba, “Tibugu, nabu daxanga tela wa, bing unia xuba salakkamga li mala sangua nga. Ne heku usu mana nga murungagua, ne usu mana ung murungama.” ");
INSERT INTO met_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Baing goxoya ma rangua lipuxing tuwa dinaxu mana, bagudi dikinu matabu, saing harua na Pita ba, “Sanga mana awasa xai rangua nga mana auwa taininau te? ");
INSERT INTO met_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Awasa saing asabu mua, nam tubaiga xapkang. Maxuna, luimdi muruding, ne sanggaimdi haringingading te.” ");
INSERT INTO met_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Baing Yesu ila muli bu sabu ba, “Tibugu, nabu daxanga tela wa te bu nganung xuba salakkamga li te, bing sangau, usu mana ung murungama.” ");
INSERT INTO met_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Goxoya ma, baing bagu muli dikinu matabu, namua na maxading dikinu. ");
INSERT INTO met_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Binabu yungadi ila muli saing sabu muli, harua taininau bila menau. ");
INSERT INTO met_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Baing goxoya ma rangua lipuxing tuwa dinaxu mana, saing harua nadi ba, “Angtung gakinuyu xaung ayaguauyu baru? Angtung gabagu to! Xaidap maxanoa ma ba. Disina Lipua Ma Rangua Urana mala lipu kubolu dianamdi rimadingiauba. ");
INSERT INTO met_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Angtung gamesa, talauba! Abagu, lipua bo ba sina nga mala nadi, ina sok lo!” ");
INSERT INTO met_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu haruauyu, baing Yudas, ina mana Lipu 12 tela, sok. Gabu buranga sabanga dima, dirai waxang sabangadi xaung xaidi. Lipu hananiangamdi yanamidingdi digabu lipudi lipuxiding haringindi disoxidi ma. ");
INSERT INTO met_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudas bo ba sina Yesu nadi, muga hamaringia hatangangua tela ranguadi, harua nadi ba, “Lipua ba ngalibu, lipua naga. Atuxu.” ");
INSERT INTO met_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Binabu Yudas ila taxa rangua Yesu sap, saing harua ba, “Lipu Tubatubaingama, yambong xai!” saing libu. ");
INSERT INTO met_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu harua ba, “Riagu, axa uma bu ulibu, bing ulibu.” Baing lipudi dima dita rimadingdi mana Yesu, saing dituxu haringina. ");
INSERT INTO met_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ne lipu tela wa rangua Yesu xai waxanging sabanga masok, ting mana lipu hananiangam mugamugangama lipuxing oxata olanggama, saing taxiti tanganglianoa. ");
INSERT INTO met_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu bala ba, “Uta waxangim sabanga goxoya mala yabania. Lipu gaxarea dahaung waxangia bagula dimati waxangia. ");
INSERT INTO met_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Bola uxabia te, sanga ba ngaxusunga Tibugu, saing hata sibuna li bagula soxi uleginamdi didali bakbak 12 bu dahauli nga. ");
INSERT INTO met_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ne nabu ngalibu, bing Urana Xuanoa bagula aningona baru? Daharua ba bagula sok bila li.” ");
INSERT INTO met_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Baing Yesu harua na burangua ba, “Ai, ang gama xaung waxang sabangadi xaung xaidi bu atuxu agoxi nga, bila nga lipu hanaunggam tela, bo? Xaidapxaidapka lo ngarung ngatubatuba maluxu Urana Numang yabania, ning atuxu nga te. ");
INSERT INTO met_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ne axadi li disok bu haruangadi Urana lipuxing suxunguxunguamdi dibungdi waleu bagula aningoding.” Baing lipuxindi dinaxu mana disauya saing diluki mala. ");
INSERT INTO met_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Baing lipuadi dituxu Yesu daxai mala lipu hananiangam mugamugangama Kayapas numania. La ba, lipu hanaunaunga tubatubainganamdi digabu lipu haringindi digugunia ma. ");
INSERT INTO met_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita su mana Yesu mala, ne wa hasoya monga. Su mana mala laing lipu hananiangam mugamugangama numang rubinia. Baing luxu saing rung mua rangua lipu wasangamdi bu bagu baraxinta bagula sok. ");
INSERT INTO met_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Lipu hananiangamdi yanamidingdi digabu lipu haringing longgalo duwa Yuda Kaunsilidi, ding disai haruanga languangam tela bu dung Yesu mati mana. ");
INSERT INTO met_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Dibagu lipu xumana dinai mana disu haruanga languangam na, ne haruangadinga sanga te. Disaisai laing lipu luwa dima ");
INSERT INTO met_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","disu haruanga ba, “Lipua li harua ba, ‘Nga sanga mana ngaxui mari Urana Numanoa, baing kimuya mana xaidap tuwa, bagula ngatongtongia muli.’ ” ");
INSERT INTO met_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Baing lipu hananiangam mugamugangama mesa saing harua na Yesu ba, “Haxuyangam te? Baru mana haruanga li disu maung?” ");
INSERT INTO met_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ning Yesu mumguti. Baing lipu hananiangam mugamugangama harua na ba, “Ngatabinaung ba ubaxanga maxuna nam mana Urana walingam maxania ba: Ung ba Urana Lipuxing Mogunganama? Ung Urana Garanoa, kimbo tegu?” ");
INSERT INTO met_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu haxuya ba, “Wane, bila ung guharua ba. Ne haruanga tela muli ngabaxanga nang ba: Kimuya bagula abagu Lipua Ma Rangua Urana rung Urana Haringinga rimang rimamo rubinia, xaung bagula abagu ma xaung mugap long xaiyamdi.” ");
INSERT INTO met_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Baing lipu hananiangam mugamugangama sing ina imangindi bu hatanga ba gamona doa, saing harua ba, “Harungia Urana! Harua ba wa hasusu rangua Urana! Heku tasaiʼm lipu tela muli su haruangua na. Ang galungu masup. ");
INSERT INTO met_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ang gahatum baru?” Dahaxuya ba, “Lipu kubolu dianam! Bing mati mana kubolunoa!” ");
INSERT INTO met_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Baing digipgip ramramonia saing ditaha rimadingia. Teladi duda ");
INSERT INTO met_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","saing daharua ba, “Uhatanga ba ung Urana lipuxing suxunguxunguama! Ung Urana Lipuxing Mogunganama, ubaxanga namguba. Gaxarea tahaung?” ");
INSERT INTO met_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita rung mua sabasabia, maluxu numa gamgamingania, baing haing haulingam tela sok ma saing harua ba, “Ung xauna, uwa rangua Yesu Galiliama.” ");
INSERT INTO met_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ne hatiam ding longgalo maxadingia. Harua ba, “Baraxinta uharua mana ngaxabia te.” ");
INSERT INTO met_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Baing ila numa xaluxing yabania. La ba haing haulingam tela muli bagu, saing harua na lipuadi duwa la ba, “Lipua li wa rangua Yesu Nasaretiama.” ");
INSERT INTO met_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Hatiam muli, harua ba, “Ngabaxanga Urana maxania ba ngaxabia lipua ba te!” ");
INSERT INTO met_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mena, lipudi dili mauli la ba dima rangua Pita saing daharua ba, “Maxung sibuna, ung dingia tela, namua na waxumtuanoa hatangaung sabasabia.” ");
INSERT INTO met_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tauna Pita harua haringing sibunauba. Harua ba nabu langua bing sangau, wa haruangia rangua Urana, saing harua ba, “Maxung sibuna, Urana maxania, ngaxabia lipua ba te!” Baing ina naga, hata sibuna li muxaxua xatu. ");
INSERT INTO met_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Saking Pita hatumia muli Yesu haruanganoa ba: “Muga mana muxaxua xatu, bagula uhatiam manga tuwa.” Baing sok mala, tang haringing sibuna. ");
INSERT INTO met_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Buraraging sibuna baing lipu hananiangamdi yanamidingdi digabu lipudi lipuxiding haringindi dahau hatumingadingdi ba dung Yesu mati baru. ");
INSERT INTO met_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Digoxi, daxai mala, saing dita gabana Pailat rimania. ");
INSERT INTO met_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yudas, lipua ta Yesu bixuandi rimadingia, bagu xabia bagula dung mati, baing baxagi mana usingangua mana kubolunoa. Binabu xap siang silba mukiring 30 mala muli rangua lipu hananiangamdi yanamidingdi xaung lipu haringindi. ");
INSERT INTO met_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Baladi ba, “Ngalibu kubolu diana. Lipua ngata rimaimia ba libu kubolu dian tela te.” Dahaxuya ba, “Axamang amia te. Ung mauxangama baing!” ");
INSERT INTO met_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Binabu Yudas ting sianga mala maluxu Urana Numania. Baing sauyadi saing ila mumu ina. ");
INSERT INTO met_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Lipu hananiangamdi yanamidingdi ditagia siang silba mukirinadi ba saing daharua ba, “Siangga li siang sipkam, binabu hanaunaunga bili kira ba labu tata rangua Urana Numang sianginoau tai.” ");
INSERT INTO met_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Binabu dahau hatumingua mana siangga ba digim lipu bori tongtongianganama titinoa. Baing duxugia mala sok gobagoba tela mana dikimang lipu titi telamdi mana. ");
INSERT INTO met_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Namua naga duxu titia ba Titi Sipkamguyu. ");
INSERT INTO met_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Baing mana kubolua ba, dilibu haruanga Urana lipuxing suxunguxunguama Yeremaya bung waleu ba aningona. Harua ba, “Daxap siang silba mukiring 30 bagudiba—giminaginoa Isreldi dimogu mana lipua ba, ");
INSERT INTO met_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","saing digim lipu bori tongtongianganama titinoa, bila Toxoratamona tabina nga.” ");
INSERT INTO met_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tauna, mana bungina baguba Yesu li mua gabana maxania, baing gabana xusunga ba, “Ung ba xaitamoxi Yuda dingia?” Yesu haxuya ba, “Wane, bila ung guharua ba.” ");
INSERT INTO met_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Baing lipu hananiangamdi yanamidingdi digabu lipu haringindi disu haruanga mana, ne haxuya tela te. ");
INSERT INTO met_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Saking Pailat xusunga ba, “Bola ulungu haruanga xumana disudi maung, bo?” ");
INSERT INTO met_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ning Yesu haruangan te. Haxuya haruangading kaxuketa tela te. Binabu gabana hixi sibuna mana. ");
INSERT INTO met_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ne mana Taunga Dalingam niani taining tainina, Pailat kubolunoa ba ina yunga lipu salak yabanam tela gaxarea gaxarea burangua dimogu. ");
INSERT INTO met_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Niani baguba lipu salak yabanam tela xap yaya sabanga mana kubolung diandi wa, yanoa Barabas. ");
INSERT INTO met_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Binabu bungina buranga digugunia ma, Pailat xusungadi ba, “Baru lipuxinta ang gabo ba ngayunga nang? Barabas, kimbo Yesu duxu ba Urana Lipuxing Mogunganama?” ");
INSERT INTO met_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Xusunga bila ba, namua na xabiau yanamidingdi gamodingdi didoa mana Yesu, binabu dita rimania. ");
INSERT INTO met_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat rung mana kabukabu suxuyangama, baing haininoa soxi ulega ma rangua ba: “Labu ulibu axamang tela mana lipu maringina bau tai. Namua na yambong ngamip mana, saing gamogua mauxang sibuna.” ");
INSERT INTO met_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ning lipu hananiangamdi yanamidingdi digabu lipu haringindi diti buranga hatumingadingdi ba duxusunga Pailat ba yunga Barabas saing ung Yesu mati. ");
INSERT INTO met_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Binabu gabana xusunga muli ba, “Lipu baruamta mana luwadi li ang gabo ba ngayunga nang?” Dahaxuya ba, “Barabas.” ");
INSERT INTO met_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Baing Pailat xusungadi ba, “Ne ngaria baru mana Yesu li duxu ba Urana Lipuxing Mogunganama?” Ding longgalo dahaxuya ba, “Ung mati xai balingamia!” ");
INSERT INTO met_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailat xusungadi ba, “Baruta? Libu kubolu diang baruamta?” Ne duwagiwagi haringina ba, “Ung mati xai balingamia!” ");
INSERT INTO met_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat bagu daxap haruanganoa te. Ne bagu haunginga sabanga bo ba mesauba. Binabu xap mina langing tela saing damia rimandi lipudi maxadingia. Harua ba, “Sanga ba ngawa haruangia mana lipua li sibindi te. Ang mauxangaima baing!” ");
INSERT INTO met_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Baing lipu longgalo dahaxuya ba, “Uyunga sibinoa wa mam am gagabu garamamdi!” ");
INSERT INTO met_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Baing ina naga, yunga Barabas nadi. Ne tabina lipuxing haungingamdi ba digusi Yesu. Sup, baing ta Yesu lipu haungingamdi rimadingia bu dung mati xai balingamia. ");
INSERT INTO met_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Baing gabana lipuxing haungingamdi daxai Yesu maluxu gabman numania (duxu ba Piretoriam), saing duwagi guguniangading haungingam longgalo dima digugunia taxiya. ");
INSERT INTO met_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Dunia imangindi sangua saing disausau imang maxaxaya sabuxang tela mana. ");
INSERT INTO met_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Saking ditaling waxu ruxunam bila xaitamoxi muxubinoa saing dita toxonia. Dita nunu bila xaitamoxidi dituxu rimang rimamo, saing digung kiding tuxundi maxania bila duwa hawa mana saing didaudau ba, “Uwa bungingbunginalo, xaitamoxi Yuda dingia!” ");
INSERT INTO met_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Digipgip, saing daxap nunua saing ditahataha toxonia. ");
INSERT INTO met_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Didaudau laing sup, baing dunia imang sabuxanoa sangua, saing disausau ing sibung imangindi mana muli. Saking daxai mala bu dung mati xai balingamia. ");
INSERT INTO met_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Dahaxa malau, baing lipu haungingamdi disok mana lipu Sairinam tela, yanoa Saimon, saing daxap dilibu xoxi Yesu xaing balingama. ");
INSERT INTO met_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Dila disok long tela duxu ba Golgota (namuxinoa ba Toxotaxu Guang Yabana). ");
INSERT INTO met_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","La ba disina wain tela daxaning axamang mabiang tela duxu ba gal na bu nung. Ne bungina tuba, hauxana saing nung te. ");
INSERT INTO met_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Digoxi diti mahaing masup, baing dahali halinga tela bu dibagu gaxarea daxap imangindi. ");
INSERT INTO met_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Dirung la ba bu duwasa mana. ");
INSERT INTO met_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Etua mana toxonoa digoxi xai tela dibung haruanga disu na mana ba: Lipua li Yesu, Xaitamoxi Yuda Dingia. ");
INSERT INTO met_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Digoxi lipu hanaunggam luwa rangua, tela wa rimamo, tela wa xong. ");
INSERT INTO met_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Lipudi dahaxa dahadalia daharua diana na, ditingting toxodingdi mala ");
INSERT INTO met_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","saing daharua ba, “Uharua bagula uxui Urana Numanoa mari, saing utongtongia muli mana xaidap tuwa, bing ung guhauliung! Nabu ung Urana Garanoa, bing uri ma sangua xai balingamga ba!” ");
INSERT INTO met_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Lipu hananiangamdi yanamidingdi, lipu hanaunaunga tubatubainganamdi xaung lipu haringindi xauna, ding didaudau bila ba. ");
INSERT INTO met_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Daharua ba, “Hauli lipu teladi ba, ne sanga ba hauli ing sibuna te! Nabu Xaitamoxi Isreliama, bing ri ma sangua xai balingamga bauba bu am gabagu am gahatum haringina mana. ");
INSERT INTO met_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ina hatum haringina mana Urana saing harua ba, ‘Nga Urana Garanoa.’ Baing ina naga, nabu Urana muruna mana, bing Urana sanga ba hauli hatata.” ");
INSERT INTO met_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bila balau lipu hanaunggam luwa digoxi dingtang rangua, tang didaudau xauna. ");
INSERT INTO met_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Xaidap liauba, baing labianoa kaukau titia masup laing bungbung. ");
INSERT INTO met_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Bila 3:00 bungbung Yesu wagi sabanga ba, “Eli, Eli, lema sabaktani?” namuxina ba, “Urana ngayua, Urana ngayua, baruta uyunga nga?” ");
INSERT INTO met_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lipu teladi dili la ba dilungu alaba, baing daharua ba, “Wagi mana Elaitsa.” ");
INSERT INTO met_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hata sibuna li dingia tela luki mala saing xap garumu tela, saing tai maluxuʼm wain mabiana laing baxagi. Sup, baing su xai tela mana saing iti mahaing, sina na Yesu ba nung. ");
INSERT INTO met_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ne dingia teladi daharua ba, “Taragu to! Tabagu nabu Elaitsa ma bu hauli to.” ");
INSERT INTO met_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Baing Yesu wagi sabanga muli, saing yunga aningonoa mala. ");
INSERT INTO met_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Taxa mana bungina baguba, imang sabangga silola mua maluxu Urana Numania singina hataing luwa etua laing sok ha lo. Titia taguxa, siangdi dutu ding. ");
INSERT INTO met_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Baing guha gobagobadi dutu ding daxaxa ding, saing Urana lipuxing xumana dimati masup, sanggadingdi dimesa muli. ");
INSERT INTO met_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Disok sangua gobagobadi, saing kimuya mana Yesu mesa muli ba, diluxu long sabangga Urana mogu inia Yerusalem, saing lipu xumana dibagudi. ");
INSERT INTO met_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Lipu haungingamdi yanamidinga gabu lipu haungingamdi dili rangua duwasa mana Yesu, ding dibagu noxigua xaung axamang teladi disok, baing dimaxuwa sibuna. Daharua ba, “Maxung sibuna, lipua li Urana Garanoa naga!” ");
INSERT INTO met_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Haing xumana duwa la ba, dili hasoya monga, dibagu mua. Bungina Yesu wa titia Galili saing ma, dinaxu mana saing dahauli. ");
INSERT INTO met_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Dingia tela bing Maria Magdalam, tela Yems Yosep tang bauding yanoa Maria, xaung tela Yems Yon tang bauding. ");
INSERT INTO met_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Yambonga bo ba sokkuba, baing lipu xalaxalam tela mana longga Erimatea, yanoa Yosep, ma. Ina lipu tela naxu mana Yesu xauna. ");
INSERT INTO met_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ila rangua Pailat, xusunga mana Yesu sangganoa, saing Pailat tabina lipuxing haungingamdi ba disina na. ");
INSERT INTO met_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosep xap sangganoa mari, saku mana imang sigixingang xai sibung tela, ");
INSERT INTO met_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","saing ta maluxu mana ing sibung guhanoa gobagoba haun tela disaba sianga maluxu mala. Ditutuxuya siang sabanga ma rangguti guhia gobagoba xuania. Baing dilauba. ");
INSERT INTO met_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalam gabu Maria tela dirung haxek guhia gobagobia, tang dibagu. ");
INSERT INTO met_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Xaidap Xauxaungama ila sup, baing lipu hananiangamdi yanamidingdi digabu Parisidi dila rangua Pailat. ");
INSERT INTO met_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Dibala ba, “Lipu Sabanga, am gahatumia muli haruanga tela lipu murakkamga ba harua bungina wauyu. Harua ba, ‘Kimuya mana xaidap tuwa bagula ngamesa muli.’ ");
INSERT INTO met_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Binabu am gabo ba utabina lipuxim haungingamdi ba duwasa mana guhia gobagobia ba laing xaidap tuwa. Nam lipuxindi dinaxu mana dila dahanai sanggua saing dibala lipudi ba mesa muli mana matiyua! Nabu bila ba, bing murakka li bagula dali muraga bungina langua ba ina Urana Lipuxing Mogunganama baing.” ");
INSERT INTO met_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat haxuya ba, “Tauna, axap lipu wasangamdi mala saing aharingia sanga mana xabiangaima.” ");
INSERT INTO met_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Baing ina naga, dila daharingia guhia gobagoba bila li: Ditaga sianga, dita raguna mana bu bili, saing dita lipu haungingamdi mali bu duwasa mana. ");
INSERT INTO met_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Xaidap Yaguangama ila sup, baing mana xaidap mugamugangam mana sande baguba, xaidaba haingguba, Maria Magdalam gabu Maria tela dila bu dibagu guhia gobagobia. ");
INSERT INTO met_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Hata sibuna li noxiga sabanga sok! Namua na Toxoratamona uleginam tela ri long xaiya ma, saing ila guhia gobagobia, tutuxuya sianga mala singia saing rung mana. ");
INSERT INTO met_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Bagunganoa bila bilikbilik, saing imangindi dusa bila mugap. ");
INSERT INTO met_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Lipu wasangamdi dimaxuwa sibuna mana, saing dilulu. Saking disok bila matiandi. ");
INSERT INTO met_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Urana uleginama harua na haingdi ba, “Labu amaxuwau tai, namua na ngaxabia ba tang gasai mana Yesu, ina dung mati xai balingamia ba. ");
INSERT INTO met_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wa la li te! Mesa muli ba, bila harua ba. Tang gama abagu longga muga sangganoa tabu mana ba. ");
INSERT INTO met_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Saking tang gala sap abala lipuxindi dinaxu mana ba, ‘Yesu mesa muli mana matiyua saing muga nang mala Galili. Bagula abagu la ba.’ Ahatumia axamandi ngabalangtang ba.” ");
INSERT INTO met_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Baing ina naga, haingdi tang diluki sap mala sangua guha gobagobia, dimaxuwa ne gamodingdi diyaha sibuna, saing diluki mala bu dibaxanga na lipuxindi dinaxu mana. ");
INSERT INTO met_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Hata sibuna li Yesu sok mana dingtang. Harua ba, “Buraraging xai.” Tang dima rangua, dituxu kindi saing disabu mana. ");
INSERT INTO met_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Baing Yesu harua nadi ba, “Labu amaxuwau tai. Ala abaxanga na riagudi ba dila Galili, saing bagula dibagu nga la ba.” ");
INSERT INTO met_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Haingdi tang diluki malau, baing lipu wasangam teladi dila diluxu long sabangia, saing dinaxuya na lipu hananiangamdi yanamidingdi mana axadi disok ba. ");
INSERT INTO met_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Lipu hananiangamdi yanamidingdi digugunia rangua lipu haringindi saing dahau hatumingua. Dulia lipu haungingamdi siang xumana. ");
INSERT INTO met_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Dibaladi ba, “Aharua bila li: ‘Lipuxindi dinaxu mana dima yambong bungina am gakinu saing dahanai sangganoa mala.’ ");
INSERT INTO met_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nabu haruanga li ila sok gabana tangangliania, bing bagula am gahamaringia haruanga rangua, bu mauxanganoa xapkang te.” ");
INSERT INTO met_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Binabu lipu wasangamdi daxap sianga saing disu mana lipu yayamdi haruangadinga. Baing naxuyanga baguli oti mauli liwe mana Yudadi, saing dinaxuya hatatauyu. ");
INSERT INTO met_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Baing lipudi dinaxu mana 11 dila titia Galili, dila bimbia Yesu baladi ba dila mana ba. ");
INSERT INTO met_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Dibagu, baing disabu mana, ne teladi hatumingading luwa. ");
INSERT INTO met_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Baing Yesu ma ranguadi saing baladi ba, “Tibugu ulia nga haringinga bu ngawa etua mana axamang longgalo mana long xaiya xaung titia. ");
INSERT INTO met_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Binabu, ala atubatuba haruangagua mana numanuma longgalo bu disok lipudi dinaxu manga. Asuguadi mana Tibugu, Garanoa xaung Aningonoa tung yadingdi. ");
INSERT INTO met_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Atubatubadi ba disu mana haruanga longgalo ngahanaunauang manadi ba. Bagu maxung sibuna bagula ngawa ranguang bungingbunginalo, laing xaidap subinganoa.” ");
INSERT INTO met_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Unggutinga mana ulek xaiyua mana Yesu Kristo, Urana Garanoa. ");
INSERT INTO met_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ungguti bila waleu Urana lipuxing suxunguxunguama Aisaya bung ba: “Bagu bagula ngasoxi lipuxigu ulekkama muga naung, bu hamaringia daxangama.” ");
INSERT INTO met_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Waxutu tela wagi mua long xoliania ba, ‘Axauxau daxangua mana Toxoratamona, atongtongia daxanga maringindi mana.’ ” ");
INSERT INTO met_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Binabu Lipu Suguangama Yon sok mana long xoliana ba, baxanga baxanga na lipudi bu duxugia hatumingadingdi, saing daxap langa bu hatanga ba, saing Urana bagula yunga kuboluding diandi. ");
INSERT INTO met_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yudia long longgalo xaung Yerusalem longgalo dila rangua Yon. Baing bungina ditula kuboluding diandi, suguadi mana Langga Yodan. ");
INSERT INTO met_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yon sau imanga ditongtongia mana kamel buxandi, saing goxi waxu asaxa sangganam tela wagigia ulenia. Xang munrikidi xaung bina bila dungungu langina. ");
INSERT INTO met_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Baing baxanga mua ba, “Lipu tela ma kimu manga, haringinganoa dali haringingagua. Sanga mana ba ngayuyu mari ngaunia xaing sanggandi te, namua na yanoa dali ngayua sibuna. ");
INSERT INTO met_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nga ba ngasuguang mana langa, ne ina bagula suguang mana Urana Aningonoa.” ");
INSERT INTO met_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mana bungina baguba Yesu yunga longga Nasaret mana titia Galili saing ma. Baing xap langa Yon rimania maluxu Langga Yodan. ");
INSERT INTO met_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Baing bungina sauya langa saing haing mauyu, hata sibuna li bagu long xaiya xaxaina saing Urana Aningonoa ri ma mana bila baxaliku. ");
INSERT INTO met_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Baing waxutu tela sok ma long xaiya, harua ba, “Ung Garagu sibuna, nga murugu sibuna maung. Ngayaha sibuna maung.” ");
INSERT INTO met_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hata sibuna li Urana Aningonoa libu ila long xoliania. ");
INSERT INTO met_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Baing wa long xoliania xaidap 40, saing Satan tuba. Asaxa abungindi duwa xauna. Baing Urana uleginamdi dahauli. ");
INSERT INTO met_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kimuya mana dita Yon salak yabania, Yesu ila titia Galili saing baxanga ulek xaiyua ma rangua Urana. ");
INSERT INTO met_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yesu harua ba, “Xaidapka Urana mogu ma ba. Urana Yonggaxinoa ma haxek ba. Axugia hatumingaimdi saing ahatum haringina mana ulek xaiyua.” ");
INSERT INTO met_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Bungina Yesu naxu Lang Gamolingana Galili rubinia, bagu neng sabangandi Saimon Andru tang diting amagua lang gamolingania, namua na dingtang lipu xuningamdi. ");
INSERT INTO met_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Baing Yesu harua nadi ba, “Tang gama anaxu manga, saing bagula ngalibuang asok lipu xuningam mana lipudi.” ");
INSERT INTO met_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Baing hata sibuna li tang diyunga amagadingdi saing dinaxu mana. ");
INSERT INTO met_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu haxa monga mala, baing bagu Yems, Sebedi garanoa, xaung kixinginoa Yon, duwa wagadingia, dahamaringia amagadingdi. ");
INSERT INTO met_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Hata sibuna li wagidi, saing diyunga tibuding Sebedi wagia xaung lipuxing oxatamdi, saing tang dinaxu mana. ");
INSERT INTO met_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Dila disok long sabangga Kaperneam. Baing bungina Xaidap Yaguangama sok, Yesu luxu Yudadi sabungading numania saing ungguti tubatuba lipudi. ");
INSERT INTO met_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Baing dihixi mana tubatubainganoa, namua na tubatubadi xaung haringinga sibuna, bila lipu hanaunaunga tubatubainganamdi te. ");
INSERT INTO met_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hata sibuna li, la ba sabungading numania, lipu tela xaunga wa mana xaba ba, ");
INSERT INTO met_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu Nasaretiam, uma bu uraxata mam? Bola uma ba uhanggalangiam? Ngaxabiaunggu, ung Urana Lipuxing Mogu Naina!” ");
INSERT INTO met_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu bili ba, “Udik! Usok ma sangua lipua li!” ");
INSERT INTO met_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Baing xaunga libu lipua lulu haringina, xaba haringina, saing sok sangua. ");
INSERT INTO met_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Baing lipu longgalo dihixi mana, ne duxusunga liwe mading ba, “Baraxinta sok? Tubatubainga haun tela saing harua bila lipu yayam tela! Tabina xaungadi saing disu mana haruanganoa!” ");
INSERT INTO met_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Baing Yesu naxuyanganoa ila sap mana long longgalo maluxu Galili. ");
INSERT INTO met_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu yunga sabungading numanoa, baing gabu Yems, Yon dila rangua Saimon, Andru tang numadingia. ");
INSERT INTO met_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon haininoa bauna busi, sanggandi disala saing kinuʼm tabu xabia. Baing dibala Yesu mana. ");
INSERT INTO met_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Binabu ila rangua haingga ba, tuxu rimanoa saing iti mesa saing rung. Baing sangga salianoa sup, saing xauxau angingua nadi. ");
INSERT INTO met_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Bungina xaidaba ri daxap lipu busingamdi xaung adi xaungadi duwa manadi ding longgalo dima rangua Yesu. ");
INSERT INTO met_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Lipu longgalo digugunia mua numa xaluxinia, ");
INSERT INTO met_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","saing Yesu sahi busingadi mana lipu xumana dibusi mana businga xangxana. Suka xaungadi, saing bilidi ba daharuau tai, namua na daxabia ba ina Urana Garanoa. ");
INSERT INTO met_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Buraraging sibuna, labauyu, baing Yesu mesa ila long xolian tela, saing sabu mua. ");
INSERT INTO met_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimon gabu riandi dila disai mana, ");
INSERT INTO met_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ne bungina disok mana, dibala ba, “Lipu longgalo disai maung!” ");
INSERT INTO met_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu haxuya nadi ba, “Heku, tala mana long teladi duwa haxek, bagula ngabaxanga nadi to. Namua na oxata naga ngama mana ba.” ");
INSERT INTO met_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Baing haxa mauli maluxu titia Galili long longgalo, baxanga maluxuʼm sabungading numandi saing suka xaungadi. ");
INSERT INTO met_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lipu saksaxam tela ma rangua Yesu, gung king tuxundi, saing xusunga haringina ba, “Nabu ung murum, ung sanga ba usahi busingagua bu ngasok sigixinga.” ");
INSERT INTO met_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Baing Yesu usinga sibuna, ta rimanoa mala saing ring, saing bala ba, “Nga murugu, usok sigixinga!” ");
INSERT INTO met_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Hata sibuna li businga saksaxa sup mana, saing sok sigixinga. ");
INSERT INTO met_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu soxi mala sap, saing harua haringina na ba, ");
INSERT INTO met_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Labu ubala lipu tela manau tai. Ne muga ula, uhatangaung na lipu hananiangama. Hatata usok xai, bing usina hananianga mana sigixingama bila Moses hanaunau ba, binabu lipudi bagula daxabia ba busingama sup.” ");
INSERT INTO met_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ne lipua ba ila saing baxanga mauli na lipu longgalo, naxuyangua ilauba. Baing Yesu sanga ba ila mana long tela lipudi maxadingia te. Ina wa singia long xoliania, ne lipudi mana long longgalo dimau ranguau. ");
INSERT INTO met_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Xaidap teladi disup, baing Yesu ila muli longga Kaperneam. Bungina lipudi dilungu ba wa numia, ");
INSERT INTO met_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","lipu xumana dima digugunia, sanga mana ganangang te. Haxek sibuna xaluya xauna, ganangang tela wa olang te saing Yesu baxanga Urana Xuanoa nadi mua. ");
INSERT INTO met_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Lipu teladi dima, luwadi luwadi dahau lipu king rimandi dahamati ba ma rangua. ");
INSERT INTO met_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ne longa baxagi, sanga mana daxap busingama ma haxek rangua Yesu te. Binabu daxap mahaing numa ubunia saing daxaxa numa long tela mana longga Yesu wa ba, saking diyungia kabukabu lipu busingama kinu mana ba mari. ");
INSERT INTO met_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu bagu hatumingading haringina, baing harua na lipu king rimandi dahamati ba, “Garagua, kubolum diandi disup.” ");
INSERT INTO met_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ne lipu hanaunaunga tubatubainganam teladi dirung mua la ba saing hatumingadingia dahatum ba, ");
INSERT INTO met_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Baruta lipua li harua bila ba? Harungia Urana! Gaxarea sanga ba yunga kubolu diandi? Urana ing ganina!” ");
INSERT INTO met_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ne hata sibuna li Yesu xabia hatumingania ba dahatum baru hatumingadingia, saing harua nadi ba, “Baruta ahatum hatumingaimia bila ba? ");
INSERT INTO met_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Baru haruanganta mosiu mana ngaharua na lipua ba: ‘Kubolum diandi disup’ kimbo ‘Umesa, oxop uxaingama uhaxa’? ");
INSERT INTO met_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ning hatata bagula ngahatanga nang ba Lipua Ma Rangua Urana ina sanga haringinga etua mana titia li bu yunga kubolu diandi.” Saking harua na lipu king rimandi dahamati ba, ");
INSERT INTO met_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ngabalaung, umesa oxop uxaingama saing ula numia.” ");
INSERT INTO met_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Baing ina naga, hata sibuna li lipua mesa, xap uxainganoa saing haxa mala lipu longgalo maxadingia. Baing dihixi mana saing diti Urana yanoa, daharua ba, “Si! Mugau ma am gabagu axa na bila li te.” ");
INSERT INTO met_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tauna, Yesu ila muli Lang Gamolingana Galili rubinia. Buranga sabanga dima rangua saing ungguti baxangangua nadi. ");
INSERT INTO met_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Bungina haxa mala, bagu Alpias garanoa Libai rung mua numa takis xabinganamia saing bala ba, “Unaxu manga.” Baing ina naga, Libai mesa saing naxu manauba. ");
INSERT INTO met_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kimuya, ila xang Libai numania. Baing lipu takis xabinganam xumana gabu lipu kubolu dianam xumana daxang rangua Yesu gabu lipuxindi dinaxu mana, namua na lipu xumang sibuna dinaxu mana. ");
INSERT INTO met_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bungina lipu hanaunaunga tubatubainganamdi mana bakbakka Parisi dibagu Yesu xang rangua lipu kubolu dianamdi xaung lipu takis xabinganamdi, duxusunga lipuxindi dinaxu mana ba, “Baruta ina xang rangua lipu takis xabinganamdi xaung lipu kubolu dianamdi?” ");
INSERT INTO met_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu lungu haruanga baguba, baing harua nadi ba, “Lipu baxiamdi dahauli lipu businga teguamdi te. Tegu. Dahauli lipu busingamdi. Bila balau, ngama ba ngawagi lipu maringindi te. Tegu. Ngama ba ngawagi lipu kubolu dianamdi.” ");
INSERT INTO met_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mana bungina baguba, lipudi dinaxu mana Yon xaung Parisidi ding disaha mana angingua. Baing lipu teladi dima duxusunga Yesu ba, “Bunging xumana lipudi dinaxu mana Yon xaung lipudi dinaxu mana Parisidi ding disaha mana angingua bu dahatanga ba dibo ba Urana yaha manadi, ning lipuximdi dinaxu maung ba tegu. Baruta?” ");
INSERT INTO met_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Baing Yesu haxuya nadi ba, “Nabu lipu tela hatata bo ba yau. Riandi sanga ba disaha mana angingua bungina wauyu ranguadi? Tegu. Bungina lipua bo ba yau wauyu ranguadi sanga ba disaha mana angingua te. ");
INSERT INTO met_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ne kimuya bungina lipu teladi daxap lipua ba mala sangua ding, mana xaidapka baguba bagula disaha mana angingua. ");
INSERT INTO met_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Lipu tela labu raga imang hataing xabatingang tela mana imang muganguau tai. Nabu libu bila ba, bungina damia, hataina ba bagula xating saing sing mugangua, saing singingua bagula tubu. ");
INSERT INTO met_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Lipu tela labu gua wain hauna mari mana meme sanggang mugangadiu tai. Nabu libu bila ba, bing wain bagula sing saha meme sanggandi, binabu wain xaung meme sanggandi disup xauna. Tegu. Wain hauna bing gua mari mana meme sanggang haundi.” ");
INSERT INTO met_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mana Xaidap Yaguangam tela, Yesu gabu lipuxindi dinaxu mana dahaxa malau daxangia, dikisi mana wit umangang tela. Lipuxindi dinaxu mana dungguti daxauya wit marang teladi namua na gesagiding. ");
INSERT INTO met_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Saking Parisidi duxusunga ba, “Ai, baruta dilibu oxata hanaunaungaradi dibili kira ba talibu mana Xaidap Yaguangama?” ");
INSERT INTO met_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Baing Yesu haxuya nadi ba, “Axa mugangaroa Debit libu waleu, atiti ba ne baruta ahatumia te? Mana bungina ina gabu guguniangandi duwa mana bunging dianoa, gesagiding saing angiading te. ");
INSERT INTO met_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiata wa lipu hananiangam mugamugangama baing Debit luxu Urana Numania, saing xang salanga dita Urana maxania. Anginga baguba bilingam. Lipu hananiangam ding ganiding sanga ba daxang. Ne Debit, ina xap teladi saing xang. Baing sina teladi na guguniangandi xauna.” ");
INSERT INTO met_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Saking Yesu harua nadi ba, “Urana mogu Xaidap Yaguangam bu sok mauxana mana lipudi te, ina mogu bu hauli lipudi. ");
INSERT INTO met_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Binabu Lipua Ma Rangua Urana wasa mana Xaidap Yaguangama xauna.” ");
INSERT INTO met_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Bunging tela, Yesu luxu Yudadi sabungading numania saing lipu tela wa la ba, rimanoa mati saing toatuana. ");
INSERT INTO met_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Baing duwasa mana Yesu xai bu dibagu nabu bagula hamaringia lipua mana Xaidap Yaguangam kimbo tegu, namua na dibo ba dita haruangia. ");
INSERT INTO met_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Baing harua na lipua rimanoa mati ba, “Umesa uli lipudi maxadingia.” ");
INSERT INTO met_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Saking harua nadi ba, “Baru kubolunta naxu mana hanaunaunga mana Xaidap Yaguangam: Talibu xai kimbo talibu doa, tahauli kimbo taung?” Ne ding dimumguti mua. ");
INSERT INTO met_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Baing Yesu atin disala, bagu mauli manadi. Hatuminganoa mauxana namua na hatumingading diriba ding, saing harua na lipua ba, “Uraria rimama.” Raria, saing rimanoa sok xai dup. ");
INSERT INTO met_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Baing Parisidi disok sangua, dila digugunia rangua Herot bakbagindi bu dahangixaya bu disai daxanga tela bu dung Yesu mati. ");
INSERT INTO met_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu gabu lipuxindi dinaxu mana diyunga longga ba mala lang gamolingania saing buranga sabanga Galiliamdi disu mana. ");
INSERT INTO met_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Bungina dilungu axadi Yesu libudi, lipudi dima rangua mana titia Yudia, long sabangga Yerusalem, titia Idumea, titiadi duwa Langga Yodan hataina xaung titiadi duwa mauli mana long sabanggadi Taya, Saidon. ");
INSERT INTO met_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Baing bungina bagu buranga baguba, bala lipuxindi dinaxu mana ba daxauxau xai wagang tela bu haing mana, nam lipudi dibura mana. ");
INSERT INTO met_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Bila balau namua na hamaringia busingam xumana. Binabu lipu busingamdi dahayuyu ma haxek haxek ba diring. ");
INSERT INTO met_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Baing bungina xaungadi dibagu, xungdi mari maxania saing daxaba ba, “Ung Urana Garanoa!” ");
INSERT INTO met_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ne Yesu bilidi haringina ba dinaxuya mana ina gaxarea. ");
INSERT INTO met_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu haing mala xaxagania, baing wagi ma rangua gaxarea muruna manadi, saing dima rangua. ");
INSERT INTO met_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Mogu lup 12 uxudi ba aposeldi sanga mana duwa rangua xaung sanga mana soxidi mala bu dibaxanga ");
INSERT INTO met_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","xaung haringiadi bu disuka xaungadi. ");
INSERT INTO met_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Lipua 12 ba mogudi bing: Saimon (sina yaya Pita na), ");
INSERT INTO met_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yems kixinginoa Yon (Sebedi garandi, ne sina yaya Boanerges na dingtang, namuxinoa bing Kaxap Garandi), ");
INSERT INTO met_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Pilip, Bartolomyu, Matyu, Tomas, Yems (Alpias garanoa), Tadias, Saimon (duxu ba Selat, namua na bakbagindi dibo ba disuka Romdi mala), ");
INSERT INTO met_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yudas Iskariot (ina ta Yesu bixuandi rimadingia). ");
INSERT INTO met_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu goxoya mala saing luxu mana numa tela. Baing lipu xumana digugunia muli, sanga mana Yesu gabu lipudi dinaxu mana sanga ba daxang te. ");
INSERT INTO met_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ne bungina Yesu bakbagina dilungu bila ba, dila ba daxap ma sanguadi, namua na daharua ba, “Ina kakahana ba.” ");
INSERT INTO met_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Baing lipu hanaunaunga tubatubainganamdi diri Yerusalem ma daharua ba, “Belsabul wa mana! Suka xaungadi mala mana yanamidinga haringinganoa.” ");
INSERT INTO met_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Baing Yesu wagidi dima rangua saing harua babu nadi ba, “Satan sanga ba suka ing sibuna baru? ");
INSERT INTO met_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nabu yongga tela dutu ding, bing bagula disup. ");
INSERT INTO met_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nabu numa tela dutu ding, bing bagula disup. ");
INSERT INTO met_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Baing ina naga, nabu Satan haunggana ing sibuna saing utuina, bing sanga ba li te, ne subinganoa ma ba. ");
INSERT INTO met_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ne lipu tela sanga ba luxu lipu haringingam numania bila Satan numanoa saing hanai xalingindi olang te. Tegu. Muga bing goxigoxi to. Tauna, hanai numania. ");
INSERT INTO met_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Maxung sibuna ngabalang ba, kubolu diang longgalo lipudi dilibudi, xauna haruanga diang longgalo daharungiadi mana Urana, ina sanga ba yungadi. ");
INSERT INTO met_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ning lipu gaxarea daharungia Urana Aningonoa, bing bagula yunga kuboluding dianoa te. Bagula wa ranguadi bungingbunginalo.” ");
INSERT INTO met_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Harua bila ba namua na daharua ba xaunga wa mana. ");
INSERT INTO met_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Baing Yesu bauna gabu kixingindi disok. Dili mua sabasabia saing disoxi lipu tela maluxu bu wagi ma. ");
INSERT INTO met_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Baing lipu buranga dirung taxiya, saing dibala ba, “Baum gabu kixingimdi duwa sabasabia, disai maung.” ");
INSERT INTO met_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Baing haxuya ba, “Gaxarea baugu? Gaxarea kixingigudi?” ");
INSERT INTO met_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Baing bagu mauli mana lipuadi dirung taxiya saing harua ba, “Adi bagudi li bila baugu xaung kixingigudi! ");
INSERT INTO met_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Lipu gaxarea dilibu Urana murunganoa bing kixingigua, hamungagua xaung baugu.” ");
INSERT INTO met_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu ungguti tubatuba muli lang gamolingang rubinia. Baing buranga sabanga dima digugunia taxiya, binabu haing wagia. Baing rung mari mana tek lia, lipudi dili titia, lang rubinia. ");
INSERT INTO met_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tubatubadi axamang xumana mana haruanga babundi saing maluxu mana tubatubainganoa harua ba, ");
INSERT INTO met_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Alungu to! Lipu umangam tela ila umangia bu ting wit xuyandi. ");
INSERT INTO met_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tingdi saing teladi diri daxangia, saing mangdi dima daxangxangiadi. ");
INSERT INTO met_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Teladi diri long sianggamia, mana longga titi sibun te. Dahaxa sap namua na titia ba tubu te. ");
INSERT INTO met_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ne bungina xaidaba haing, xanidi saing dimutuxu namua na oxaxadingdi diri te. ");
INSERT INTO met_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Xuyang teladi diri long waxu ruxunamia, baing disok, dihibuadi binabu oxading te. ");
INSERT INTO met_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ne xuyang teladi diri mana titi xaiya. Dahaxa, dahaing saing dua xai. Oxang tela dua 30, tela dua 60 saing tela dua 100.” ");
INSERT INTO met_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Baing Yesu harua ba, “Lipu gaxarea tangadingliana, bing dilungu haruanga baguli.” ");
INSERT INTO met_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Bungina buranga disup mala, baing Lipu 12 rangua lipu teladi ding duxusunga mana haruanga babunadi ba. ");
INSERT INTO met_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Baing baladi ba, “Haruanga hisangamdi mana Urana Yonggaxinoa, Urana nai ba axapdi baing. Ne lipu singamdi daxap haruanga babundi ing ganina ");
INSERT INTO met_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","bu, “ ‘Dibagubagu mua ne dibagu daxabia te, dilungulungu mua ne daxabia rangrang te. Nam duxugia hatumingadingdi baing bagula ngayunga kuboluding diandi!’ ” ");
INSERT INTO met_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Baing Yesu harua nadi ba, “Axabia haruanga babuna baguba namuxinoa te? Nabu bila ba, bing bagula axabia haruanga babung teladi namuxidingdi baru? ");
INSERT INTO met_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Lipua ting wit xuyandi bila tela ting Urana haruanganoa. ");
INSERT INTO met_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Lipu teladi, hatumingadingdi bila daxanga ubuna, longga xuyandi diri mana. Dilungu Urana haruanganoa, ne haxek sibuna ba, Satan ma unia Urana haruanganoa sanguadi. ");
INSERT INTO met_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Lipu teladi bila xuyandi diri long sianggamia. Dilungu Urana haruanganoa, saing daxap sap, gamodingdi diyaha mana. ");
INSERT INTO met_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ne dahatum haringina mongaita ing ganina namua na oxaxadingdi diraxap. Xungdi mari sap, bungina mauxangandi daxapdi kimbo bungina daxap salaga mana namua dahatum haringina mana Urana haruanganoa. ");
INSERT INTO met_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Baing lipu teladi bila xuyanadi diri long waxu ruxunamia. Dilungu haruanganoa, ");
INSERT INTO met_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ne dahatum xumana buk mana titia li mauxangandi, xaung xalaxaladi dituxu murak manadi, murungadingdi mana axamang xangxana xauna daxapdi, dihibuadi, saing marandi dua te. ");
INSERT INTO met_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ne xuyanadi diri titi xaiya bila lipuadi dilungu Urana haruanganoa, daxap dita hatumingadingia saing oxading. Lipu teladi dua 30, teladi dua 60, teladi dua 100, didali xuyadingdi bila ba.” ");
INSERT INTO met_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu baladi ba, “Aria baru? Atung nagung tela, ning akaukau minia kimbo ata hawa mana kabukabua? Tegu. Ata mahaing yabania. ");
INSERT INTO met_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Namua na axamandi dihisa duwa bila ba sanga mana disok menea. Baing axamandi duwa ulumia duwa bila ba sanga mana disok sabasabia. ");
INSERT INTO met_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Lipu gaxarea tangadingliana, bing dilungu haruanga baguli.” ");
INSERT INTO met_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Baladiyu ba, “Ahatum xai mana baraxinta alungu. Maxang taininau ulibu mana baraxinta ulungu, bing bagula oxop maxang taininau muli bila ba, baing bagula oxop tela muli. ");
INSERT INTO met_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Lipu gaxarea daxap haruangagua, Urana bagula sina xabianga tela muli nadi. Lipu gaxarea dilungu te, xabianga dahagaxa ba dingia, Urana bagula xap sanguadi.” ");
INSERT INTO met_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu harua muli ba, “Urana Yonggaxinoa bila li. Lipu tela ting wit xuyandi umangia. ");
INSERT INTO met_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Baing kinu yambong, mesa buraragina haxa mauli, saing xuyanadi ba dahaxa, dahaing baru, lipua ba xabia te. ");
INSERT INTO met_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Titia ing ganina libu disok. Muga haxadingdi disok, saking oxadingdi disok, baing aningodingdi disok. ");
INSERT INTO met_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Bungina aningodingdi dimoya, baing lipua ba saba, namua na xauyangua sok ba.” ");
INSERT INTO met_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu harua muli ba, “Bagula ngaharua baru mana Urana Yonggaxinoa bu ngabaxanga mana? Baru haruanga babunta bagula ngatuba? ");
INSERT INTO met_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Bila mastat xuyang kaxukang sibung tela lipudi duxumadi umangia. Kaxukang sibuna mana xuyang longgalo. ");
INSERT INTO met_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ne bungina duxuma bing haing saing sok sabanga mana anginga longgalo lipudi duxumadi umangia. Ta rimandi disok sabanga, sanga mana mangdi ditongtongia numadingdi maluxu yonggaxinia.” ");
INSERT INTO met_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Baing bungina Yesu tubatubadi, harua haruanga babung xumana bila bagudi li, sanga mana ditadi hatumingadingia. ");
INSERT INTO met_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Harua nadi sabasabia te, harua haruanga babundi ing ganina. Ne bungina gabu lipuxindi dinaxu mana ding ganiding duwa, baxanga namu longgalo nadi. ");
INSERT INTO met_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mana xaidapka baguba, yambonga sokkuba baing Yesu harua na lipuxindi dinaxu mana ba, “Takisi mala lang gamolingang hataina.” ");
INSERT INTO met_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Baing diyunga burangua, dahaing mana xai wagana Yesu wa mana ba, saing daxap mala xauna. Baing xai wagang teladi dila ranguadi. ");
INSERT INTO met_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kimuya yang haringina mesa, baing rubadi dimakmatuxuya maluxu wagia, saing bo ba da. ");
INSERT INTO met_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ne Yesu wa waga abinia, kinuʼm tabu kandilongia. Binabu lipudi dinaxu mana dahaunghaung saing daharua na ba, “Laku, Lipu Tubatubaingam, uhatum makira te? Tabo ba tangarauba!” ");
INSERT INTO met_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Baing mesa, bili yanga saing harua na rubadi ba, “Asauya! Awa mosiu!” Baing yanga mati, saing tega manilu sibuna. ");
INSERT INTO met_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Baing harua na lipuxindi dinaxu mana ba, “Amaxuwa baru? Ang hatumingaim haringin te?” ");
INSERT INTO met_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Baing dihixi buk mana, saing duxusunga ding ba, “Lipua li ina baru? Tabina lipudi ding ganiding te. Tabina yanga rubadi tang xauna, saing tang disu mana haruanganoa.” ");
INSERT INTO met_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Dila dikisi lang gamolingania disok mana Gerasadi titidinga. ");
INSERT INTO met_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu ri xai wagania ma, baing lipu tela xaunga wa mana sok gobagobia ma sok mana Yesu. ");
INSERT INTO met_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Lipua ba numanoa wa guhia gobagobia, ne lipu tela haringinganoa sanga mana goxigoxi te. Waxu haringina xauna, sanga mana te. ");
INSERT INTO met_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Namua na bunging xumana digoxi king rimandi, ne rambaxuti waxu haringindi mana rimandi saing taha saha waxu haringindi mana kindi. Lipu tela haringinganoa sanga mana bili te. ");
INSERT INTO met_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yambong xaidap longgalo, haxa mauli gobagobia xaung xaxagandi, xaba mauli saing taxitaxina mana siangdi. ");
INSERT INTO met_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Bagu Yesu wa hasoyauyu, baing luki ma gung king tuxundi maxania. ");
INSERT INTO met_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Wagi sabanga ba, “Yesu, Urana Etuam Sibuna Garanoa, bagula uraxata manga? Ngaxusungaung haringina Urana maxania ba usina salaga nangau tai.” ");
INSERT INTO met_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Wagi sabanga bila ba namua na muga Yesu harua ba, “Ung xaunga, usok sangua lipua li!” ");
INSERT INTO met_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Baing Yesu xusunga ba, “Ung yama ga tela?” Haxuya ba, “Yagua Buranga, namua na am xumana.” ");
INSERT INTO met_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Baing xusunga xusunga Yesu haringina ba labu sinadi mala sangua titia bau tai. ");
INSERT INTO met_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ne buxu nangnang bakbak sabanga tela disoya mua xaxagang rubinia ba. ");
INSERT INTO met_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Xaungadi duxusunga Yesu haringina ba, “Usoxiam maluxuʼm buxudi, unaiam bu am galuxu manadi.” ");
INSERT INTO met_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Baing naidi. Baing xaungadi disok sangua, saing diluxu mana buxudi. Saking buxu nangnang bakbakka ba diluki haringing sibuna mari long diania maluxu lang gamolingania saing dingara. Buxudi bila 2,000. ");
INSERT INTO met_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Lipu buxu wasanganamdi diluki mala saing dibaxanga na lipuadi duwa long sabangadi xaung kaxukandi. Baing lipudi disok mala bu dibagu baraxinta sok ba. ");
INSERT INTO met_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bungina dima rangua Yesu, dibagu lipua menau xaunga xumang sibuna duwa mana ba. Dibagu rung mua, sau imangdi xaung hatuminganoa maring dup, baing dimaxuwa. ");
INSERT INTO met_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Lipuadi menau dibagu ba, dinaxuya na lipu teladi mana baraxinta sok mana lipua menau xaunga duwa mana ba, xaung baraxinta sok mana buxudi xauna. ");
INSERT INTO met_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Baing ina naga, dungguti duxusunga Yesu haringina ba sauya titidinga. ");
INSERT INTO met_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu bo ba haing xai wagania, baing lipua menau xaungadi duwa mana ba xusunga Yesu haringina ba ila rangua. ");
INSERT INTO met_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ne Yesu nai mana te, ne harua na ba, “Ula yabamia rangua bakbagimdi. Ubaladi ba Toxoratamona libu baru maung xaung usingaung baru.” ");
INSERT INTO met_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Baing lipua ila saing ungguti baxanga na long longgalo duwa maluxu Dekapolis ba Yesu libu baru mana. Baing lipu longgalo dihixi mana. ");
INSERT INTO met_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kimuya Yesu haing wagia, saing kisi muli mala lang gamolingang rubing hataina. Kisi mala baing buranga sabanga dima digugunia ma taxiya, lang rubinia. ");
INSERT INTO met_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Baing Yudadi sabungading numang yanamiding tela ma, yanoa Yairus. Bagu Yesu saing gung king tuxundi Yesu kinia, ");
INSERT INTO met_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","saing xusunga haringina ba, “Nanuhangigua haxek sibuna ba mati. Laku, uma uta rimamdi mana, baing bagula sok xai muli saing wa.” ");
INSERT INTO met_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Baing ina naga, Yesu tang dila. Buranga sabanga disu mana saing dibura mana. ");
INSERT INTO met_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Haing tela siba ri mua mana niani 12 wa la ba. ");
INSERT INTO met_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Haingga ba ila rangua lipu baxiam xumana, ne xap salak xumana maluxu mana haulingadingdi saing siangindi disup. Ditubatuba sus. Sok xai monga te, businganoa sok sabanga. ");
INSERT INTO met_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Haingga ba lungu Yesu naxuyanganoa, binabu hakhaxasilia mana lipudi masok Yesu ubunia saing ring imanginoa, ");
INSERT INTO met_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","namua na hatum ba, “Nabu ngaring imanginoa ing ganina, bagula ngasok xai muli.” ");
INSERT INTO met_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Baing hata sibuna li sipka ri mua ba moti saing xunumia sanggania businganoa sup. ");
INSERT INTO met_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Baing Yesu xunumia sap maluxuʼm ing sibuna bila haringingua yunga. Xugia mala rangua lipudi saing xusunga ba, “Gaxarea ring imangigua?” ");
INSERT INTO met_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Baing lipuxindi dinaxu mana daharua na ba, “Ai, ubagu lipudi dibura buk maung, ne baruta uxusunga ba, ‘Gaxarea ring nga?’ ” ");
INSERT INTO met_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ne Yesu bagu mauli, sai mana gaxarea libu bila ba. ");
INSERT INTO met_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Saking haingga ba, ina xabiau baraxinta sok mana ba, binabu maxuwa saing lulu ma gung king tuxundi kinia. Baing baxanga maxung sibuna. ");
INSERT INTO met_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Baing ina naga, Yesu bala ba, “Nanuhangigua, hatumingam haringina hamaringiaung. Ula xaung gamogamu xai, salaga sup ba.” ");
INSERT INTO met_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Harua mua ne lipu teladi disok, dima mana Yairus numanoa, Yudadi sabungading numang yanamidingga ba. Daharua ba, “Nanuhangima mati ba. Heku usina makasangua na Lipu Tubatubaingama.” ");
INSERT INTO met_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ne Yesu hatumia haruangadinga te, bala Yudadi sabungading numang yanamidinga ba, “Umaxuwau tai. Uhatum haringina manga ing ganina.” ");
INSERT INTO met_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bili lipudi ba dimau tai. Ne nai mana Pita, Yems kixinginoa Yon tung disu mana. ");
INSERT INTO met_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bungina disok yanama numania, Yesu bagu buranga dibibi sabanga, lipudi dahatangitangi saing daxaba haringina. ");
INSERT INTO met_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Luxu saing harua nadi ba, “Abibi sabanga saing ahatangitangi baru? Haing nanunoa mati te, kinuʼm tabu ing ganina.” ");
INSERT INTO met_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ne dimasisia. Yesu sukadi masok laing sup, baing xap haing nanunoa baungtibundi xaung lipuxing tuwa dinaxu mana duwa rangua, saing diluxu mana longga haing nanunoa wa ba. ");
INSERT INTO met_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu tuxu rimanoa saing harua na ba, “Talita kum!” (namuxinoa bing “Haing nanuna, ngabalaung ba umesa!”). ");
INSERT INTO met_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Baing hata sibuna li mesa saing haxa mauli (nianindi 12). Dibagu saing dihixi mana. ");
INSERT INTO met_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Baing bilidi ba dibaxanga na lipu telau tai. Baing baladi ba dulia haing nanuna ba anginga teladi bu xang. ");
INSERT INTO met_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu sauya longga baguba, saing ila sok yabania Nasaret. Ina gabu lipuxindi dinaxu mana ding dila. ");
INSERT INTO met_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Baing mana Xaidap Yaguangam ungguti tubatuba Yudadi sabungading numania. Baing lipu xumana dilungu dihixi mana haruanganoa. Daharua ba, “Si, lipua li xap haruangadi bagudi li bi? Gaxarea sina xabianga maringina na? Libu axamang haringindi buk baru! ");
INSERT INTO met_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Lipua li, lipu numa tongtongianganam ing ganina, bo? Maria garanoa, kixingindi Yems, Yosep, Yudas xaung Saimon saing hamungandi duwa la li rangua kira, bo?” Baing gamodingdi didoa mana. ");
INSERT INTO met_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Baing Yesu harua nadi ba, “Urana lipuxing suxunguxunguama xap yaya sabanga mana long longgalo. Ning yabania, maluxu mana bakbagindi, bing ditatua.” ");
INSERT INTO met_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Sanga ba libu axamang haringing sibung tela la ba te. Ta rimandi mana lipu unrangindi dibusi ing ganina, saing hamaringiadi. ");
INSERT INTO met_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Baing hixi manadi, namua na dahatum haringina mana te. Tauna, Yesu haxa mauli saing tubatuba long taining tainina duwa singia. ");
INSERT INTO met_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Baing wagi Lipu 12 dima rangua saing soxidi mala luwa luwa, sina yaya nadi bu disuka xaungadi mala. ");
INSERT INTO met_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tabinadi ba, “Bungina ala, labu axap xalingim haxangamdi malau tai. Axap anginga, tanga, xaung siang te. Axap tuki ing ganina. ");
INSERT INTO met_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Asau xai sanggandi xaung imang, ning axap imang muli malau tai. ");
INSERT INTO met_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Bungina aluxu mana long tela saing ditang mana numa tela, awa mana numa ba laing ayunga longga baguba. ");
INSERT INTO met_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nabu long tela daxapkang te, kimbo dilunguang te, bungina asauyadi bing atingting gagapdi duwa kim lunia mala bu daxabia ba duwa haruangia.” ");
INSERT INTO met_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Baing ina naga, dila dibaxanga ba lipudi duxugia hatumingadinga. ");
INSERT INTO met_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Disuka xaunga xumana mala, disabaxaya guxenga mana lipu busingamdi saing libudi disok xai. ");
INSERT INTO met_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Xaitamoxi Herot Antipas lungu axamang longgalo Yesu libudi ba, namua na Yesu naxuyanganoa tubu. Lipu teladi daharua ba, “Ina Lipu Suguangama Yon naga mesa muli mana matiyua. Mana namua naga ina sanga ba libu axamang haringinadi ba.” ");
INSERT INTO met_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ne teladi daharua ba, “Ina Elaitsa.” Baing teladi daharua ba, “Tegu, ina Urana lipuxing suxunguxunguam tela, bila Urana lipuxing suxunguxunguam mugauamdi.” ");
INSERT INTO met_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ne bungina Herot lungu haruanga baguli, harua ba, “Yon ba, lipua ngaximguti waxungtuanoa ba, mesa muli saing wa!” ");
INSERT INTO met_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Harua bila ba namua na yau Herodias, sabanganoa Pilip haininoa. Binabu Yon hanaunau hanaunau Herot ba, “Kubolua oxop sabangama haininoa sangaʼm daxangua te.” Baing ina naga, Herodias atin disala mana Yon saing bo ba ung mati. Sai daxanga tela baing tegu, namua na Herot maxuwa mana Yon, bagu Yon lipu maringina Urana mogu naina binabu wasa mana. Herot hatuminganoa mauxana bungina harua rangua Yon, ning murunauyu mana lungu. Ne bo ba libu Herodias yaha, binabu soxi lipuxing haungingamdi ba dituxu Yon, digoxi dita salak yabania. ");
INSERT INTO met_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Baing ina naga, Herodias bagu gananganoa sok mana. Mana xaidapka Herot hatumia nianinoa, ina tongtongia taunga saing gugunia lipuxing yanamindi, lipuxing haungingam yanamidingdi xaung Galili lipu toxondi, ding dima diyaha rangua. ");
INSERT INTO met_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Baing Herodias nanuhanginoa luxu mala saing siga xai maxadingia. Baing Herot gabu lipudi dima taungania ba diyaha sibuna mana. Binabu xaitamoxi harua na haing nanunoa ba, “Bagula ngalibu baru maung? Baraxinta ung murum mana saing uxusunga mana, bagula ngasina naung.” ");
INSERT INTO met_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Baing xaitamoxi xusunga Urana ba hanggalangia nabu su mana haruanganoa te, saing harua ba, “Baraxinta uxusunga nga mana ba, bagula ngasina naung. Nabu ubo ba ngahata yonggaxigua mana hataing luwa saing ngasina tela naung, bagula ngalibu.” ");
INSERT INTO met_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Baing sok mala saing xusunga bauna ba, “Ngaxusunga mana baraxinta?” Baing bauna haxuya ba, “Uxusunga mana Lipu Suguangama Yon toxona ba.” ");
INSERT INTO met_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Goxoya mala sap rangua xaitamoxi saing harua ba, “Ngabo ba uximguti Lipu Suguangama Yon waxungtuanoa, uta toxona minia saing usina nanga hata sibuna li.” ");
INSERT INTO met_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Baing xaitamoxi hatumia, ne gamonoa mauxana buk. Ne mana namua harua maxung sibuna lipuadi dima taungania maxadingia, baing bo ba sukoxoya haruanganoa te. ");
INSERT INTO met_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Binabu hata sibuna li tabina lipu haungingam tela, soxi mala bu xap Yon toxonoa ma. Lipu haungingamga ba ila ximguti waxungtuanoa salak yabania. ");
INSERT INTO met_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Baing ta toxonoa minia saing rai ma, sina na haing nanunoa, saing sina na bauna. ");
INSERT INTO met_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Bungina lipuxindi dinaxu mana dilungu, dila daxap Yon sangganoa mala saing dikimang guhia gobagobia. ");
INSERT INTO met_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aposeldi digoxoya ma rangua Yesu saing dibaxanga mana oxata longgalo dilibu xaung ditubatuba baru. ");
INSERT INTO met_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Baing lipu xumana dila dima mua, sanga ba ganangang te mana Yesu gabu lipuxindi dinaxu mana daxang, binabu bala lipuxindi dinaxu mana ba, “Ang ganim ama tala long xoliania, tayagua to.” ");
INSERT INTO met_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Baing ding ganiding dahaing wagia dila long xoliania. ");
INSERT INTO met_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ne bungina dila, lipu xumana dibagudi saing daxabiadi ba, baing lipu xumana mana long longgalo diluki kidingia mala, saing disok muga manadi. ");
INSERT INTO met_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu ri titia, bagu buranga sabanga, baing gamona usingadi, namua na duwa bila sipsipdi doxola lipuxiding wasangama. Baing ungguti tubatubadi mana axamang xumana. ");
INSERT INTO met_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Bungbung sibunauba, baing lipuxindi dinaxu mana dima rangua, saing daharua ba, “La li long olang, saing yambongguba. ");
INSERT INTO met_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Usoxi lipudi dila mana long teladi duwa singia sanga mana digim anginga nading bu daxang.” ");
INSERT INTO met_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ne Yesu haxuya haruangadinga ba, “Ang ba auliadi bu daxang.” Baing daharua na ba, “Si, am gala am gagim baru? Giminaginoa sanga mana lipu tela waxata sobak 8!” ");
INSERT INTO met_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Baing harua nadi ba, “Ang salangaimdi baru? Ala abagu to.” Dititi laing sup baing digoxoya ma rangua Yesu saing dibala ba, “Salanga luwadi luwadi hiliadinga xaung song luwa.” ");
INSERT INTO met_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Baing Yesu bala lipu xumang sibuna ba dirung gugunianga gugunianga tatubang gamatania. ");
INSERT INTO met_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Baing dirung maxixinga. Mana maxixinga teladi lipu 100 duwa, mana teladi 50 duwa. ");
INSERT INTO met_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu xap salanga luwadi luwadi hiliadinga ba xaung song luwa ba, saing bagu mahaing long xaiya, harua xai sibuna mala rangua Urana, saing utu saha salangadi. Saking sinadi na lipudi dinaxu mana bu dituxu sinak na lipudi. Utuutu song luwa xauna na lipudi. ");
INSERT INTO met_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Lipu longgalo daxang sanga ba. ");
INSERT INTO met_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Baing lipudi dinaxu mana digugunia salanga xaung song hataindi duwauyu, digam daba 12 dibaxagi. ");
INSERT INTO met_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mana lipu longgalo daxang, lup ding ganiding titingadinga bila 5,000. ");
INSERT INTO met_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sup, baing Yesu haxi lipuxindi dinaxu mana ba dahaing wagia, dimuga mana mala lang gamolingang rubing hatainia, mana longga Betsaida. Ing sibuna wa kimuya mua saing bala lipudi ba dahatibaxaya mala. ");
INSERT INTO met_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kimuya mana harua xai sibuna nadi, haing mala xaxagania bu sabu. ");
INSERT INTO met_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Yambongguba, baing lipudi dinaxu mana duwa wagia tek liwe. Ne Yesu ing ganina wa xaxaganiauyu. ");
INSERT INTO met_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Baing bagu dimakasa mana dui, namua na yanga ma waga yunia. Haxek sibuna xaidap, baing Yesu ila ranguadi, haxa tek ubunia. Haxek sibuna dalidi, ");
INSERT INTO met_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ne dibagu haxa tek ubunia, baing dahagaxa ba tauxai tela. Daxaba doa sibuna, ");
INSERT INTO met_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","namua na dibagu saing dimaxuwa buk. Ne hata sibuna li harua nadi ba, “Awa haringina gamoimia! Nga naga. Labu amaxuwau tai.” ");
INSERT INTO met_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Baing haing ranguadi wagia saing yanga mati. Dihixi haringing sibuna mana, ");
INSERT INTO met_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","namua na daxabia rangrang mana salangadi ba te. Hatumingading diriba dingguyu. ");
INSERT INTO met_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Dikisi mala masup, baing diri titia Genesaret, saing digoti wagadinga lang rubinia. ");
INSERT INTO met_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Diri wagia masup, baing hata sibuna li lipudi dibagu daxabia Yesu. ");
INSERT INTO met_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Lipudi diluki mauli mana titia baguba, dibaxanga na lipudi. Bungina lipudi dilungu wa mana long tela, dahau lipu busingamdi duwa uxaingadingia dima rangua. ");
INSERT INTO met_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Baing long baruamta luxu mana, long sabanga, kaxukana, hataing hataina, lipudi daxap lipu busingamdi dima nawa yabania. Duxusunga haringina ba nai lipu busingamdi ba diring imanging sihinoa ing ganina. Baing lipu busingam gaxarea diring ba disok xai dup. ");
INSERT INTO met_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisidi digabu lipu hanaunaunga tubatubainganam teladi diyunga Yerusalem digugunia ma rangua Yesu, ");
INSERT INTO met_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","saing dibagu lipu teladi dinaxu mana Yesu daxang xaung rimading musuna, didamiadi muga te. ");
INSERT INTO met_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Parisidi xaung Yudadi disu mana mugangadingdi kuboludinga, bing didamia rimadingdi muga to, tauna daxang. ");
INSERT INTO met_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Bungina digoxoya nawa yabania, nabu dibo ba daxang, bing didamia to. Baing disu mana mugangadingdi kuboluding teladi, bila didamia xubadi, nanggoladi xaung boridi.) ");
INSERT INTO met_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Baing Parisidi digabu lipu hanaunaunga tubatubainganamdi duxusunga Yesu ba, “Baruta lipuximdi dinaxu maung disu mana mugangaradi kuboludinga te? Ne daxang xaung rimading musundi baru?” ");
INSERT INTO met_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu haxuya nadi ba, “Ang lipu manang luwamdi. Ang ba waleu sibuna Aisaya harua maxung sibuna mang bungina bung Urana haruanganoa mari bila li: “ ‘Bakbakka baguli diti yagua suxungudingia ing ganina, ne hatumingadingdi duwa hasoya manga. ");
INSERT INTO met_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Disabu manga olang, namua na tubatubaingadingdi dima rangua lipudi ing ganina.’ ");
INSERT INTO met_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ayunga Urana hanaunaungandi masup, saing atuxu haringina lipudi kuboludinga ing ganina.” ");
INSERT INTO met_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Baing Yesu harua nadi ba, “Ang xai sibuna buk mana adali Urana hanaunaungandi bu asu mana ang kuboluimdi! ");
INSERT INTO met_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses harua ba, ‘Uwa hawa mana baumtibumdi,’ xaung, ‘Lipu gaxarea daharua diana na baudingtibudingdi bing dungdi mati.’ ");
INSERT INTO met_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ne ang ba, ang gaharua ba maring nabu lipu tela bala baungtibundi ba, ‘Ngausinga, sanga ba ngahauliang te. Namua na ngahau haruangua ba ngaulia Urana axadi sanga ba ngahauliang manadi.’ ");
INSERT INTO met_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Bila balau, abilidi mana dahauli baudingtibudingdi muliu tai. ");
INSERT INTO met_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Baing ina naga, aunia Urana Xuanoa saing ata kuboluima ba xap yabanoa. Baing alibu axamang xumana bila ba.” ");
INSERT INTO met_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Baing Yesu wagi lipudi muli dima rangua saing harua ba, “Ang longgalo alungu nga saing ahatumia xai to. ");
INSERT INTO met_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Baraxinta lipua xang sanga ba libu ina musuna Urana maxania te. Ne baraxinta sok sangua lipua libu ina musuna.” ");
INSERT INTO met_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kimuya, yunga lipudi saing luxu numia, lipuxindi dinaxu mana duxusunga mana haruanga babuna ba. ");
INSERT INTO met_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Baing xusungadi ba, “Baruta? Hatumingaimdi dimaring te? Axadi lipua xangdi sanga ba dilibu musuna te, ");
INSERT INTO met_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","namua na diluxu hatumingania te, ne diluxu gamonia saing diri mala tinrungia.” (Mana haruanga li, Yesu baxanga ba anginga longgalo duwa sigixinga.) ");
INSERT INTO met_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Harua muli ba, “Haruanga sok hatumingania ma. Axa ba libu musuna, ");
INSERT INTO met_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","namua na axadi disok sangua lipu hatumingania bing: hatum doa, libu kubolu miaxuam, hanai, ung lipua mati, kinu rangua gaxarea yau teguyu, ");
INSERT INTO met_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","xawa, libu kubolu diandi, langua, hali mauli bila komadi, harua kimu, hanggalangia lipu tela yanoa, itina, saing libu kubolu kakahana. ");
INSERT INTO met_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Axamang dianadi bagudi li disok hatumingia saing libu lipua musuna.” ");
INSERT INTO met_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu yunga longga baguba saing ila titia long sabangga Taya wa mana ba. Luxu mana numa tela saing muruna te mana lipu tela xabia ba wa. Ne sanga ba wa hisangia te. Tegu. ");
INSERT INTO met_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Baing ina naga, bungina haing tela lungu wa la ba, ila rangua sap saing gung king tuxundi Yesu kinia, namua na xaunga tela wa mana nanuhanginoa. ");
INSERT INTO met_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Haingga baguba, xuanoa Grik, ne yabang sibuna Siroponisia, Yuda tela te. Xusunga Yesu haringina ba suka xaunga mala sangua nanuhanginoa. ");
INSERT INTO met_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Baing Yesu harua na ba, “Garagudi daxang muga to, namua na maring te mana ngaxap garadi angiadingdi saing ngatingdi mala na komadi.” ");
INSERT INTO met_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ne haxuya ba, “Toxoratamona, maxung sibuna. Ne axamang tela xauna maxunau, komadi duwa kabukabu hanggaxobinia, ding daxang garadi angiading xuxundi.” ");
INSERT INTO met_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Baing Yesu bala ba, “Mana namua uhaxuya xai sibuna, bing sanga ba ugoxoya malauba. Xaungua yunga nanuhangima ba.” ");
INSERT INTO met_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ila numia, saing bagu garanoa kinu kabukabia, xaungua yunga ba. ");
INSERT INTO met_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Baing Yesu yunga Taya titing hataina, haxa makisi Saidon, ri Lang Gamolingania Galili, sup mala Dekapolis titing hataina. ");
INSERT INTO met_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","La ba lipudi daxap lipu tela ma rangua Yesu. Lipua ba tangangliandi dahaxatu xaung sanga mana harua xai te. Duxusunga haringina ba ta rimanoa mana. ");
INSERT INTO met_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kimuya mana Yesu xap lipua mala singia sangua lipudi, simbaxang rimang uxundi maluxu mana lipua ba tangangliang ginangindi. Saking gip saing ring lipua mananoa. ");
INSERT INTO met_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Bagu mahaing long xaiya, yagua haringina saing harua na ba, “Epata!” (Namuxina bing “Axaxang!”) ");
INSERT INTO met_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hata sibuna li, tangangliandi daxaxa ding, mananoa bisa, saing harua xai dupkuba. ");
INSERT INTO met_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Baing Yesu bilidi ba dibaxanga na lipu telau tai. Bilibilidi sus, daharing buk ba dinaxuya mana mauli. ");
INSERT INTO met_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Baing lipudi dihixi buk mana, daharua ba, “Libu axamang longgalo xai. Libu lipudi tangadingliandi dahaxatu dilungu xaung lipudi daharua te daharua.” ");
INSERT INTO met_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mana bungina baguba, buranga sabanga digugunia muli. Anginga disup, binabu Yesu wagi lipuxindi dinaxu mana dima rangua saing harua nadi ba, ");
INSERT INTO met_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Gamogua usinga lipuadi li. Duwa rangua nga xaidap tuwa, saing anginga disup. ");
INSERT INTO met_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Gesagiding ba. Nabu ngasoxidi mala numadingia bila ba, bagula dimakmatia daxangia, namua na teladi dima hasoya.” ");
INSERT INTO met_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Lipuxindi dinaxu mana dahaxuya ba, “Tawa long xoliania. Ne kira taxap anginga bi bu tahaxangdi?” ");
INSERT INTO met_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu xusungadi ba, “Ang salangaimdi baru?” Dahaxuya ba, “7.” ");
INSERT INTO met_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Baing bala burangua ba dirung titia. Baing xap salanga 7, harua xai sibuna na Urana manadi, saing utu sahadi. Baing sinadi na lipuxindi dinaxu mana bu dituxu sinak na lipudi. Baing dilibu bila ba. ");
INSERT INTO met_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Dituxu song kaxukang teladi xauna. Baing harua xai sibuna na Urana manadi, saing bala lipuxindi dinaxu mana ba dituxu sinak. ");
INSERT INTO met_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Lipudi daxang sanga ba. Kimuya, lipudi dinaxu mana digugunia hataindi duwauyu, digam daba 7 dibaxagi. ");
INSERT INTO met_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bila lup 4,000 duwa. Soxidi mala, ");
INSERT INTO met_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","baing hata sibuna li gabu lipuxindi dinaxu mana dahaing wagia saing diluki mala titia Dalmanuta. ");
INSERT INTO met_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisidi dima dungguti dahakhaxi rangua Yesu. Dibo ba dituba, binabu duxusunga ba libu axamang haringing tela bu hatanga ba Urana soxi ma. ");
INSERT INTO met_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Hatuminganoa mauxang sibuna saing harua ba, “Baruta lipu hatatamdi disaisai ba dibagu axamang haringina? Maxung sibuna ngabalang ba, bagula dibagu axamang haringing tela te. Tegu sibuna.” ");
INSERT INTO met_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Baing yungadi, haing wagia muli saing kisi mala lang gamolingang hataina. ");
INSERT INTO met_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Lipudi dinaxu mana dahalingalinga ba daxap salanga ma. Dituxu taininau ing ganina wagia. ");
INSERT INTO met_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu harua haringina nadi ba, “Amaxania mana axamana libu salanga salalanga ma rangua Parisidi xaung Herot.” ");
INSERT INTO met_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dahangixaya haruanga baguba liwe mading saing daharua nading ba, “Bola harua bila ba namua na taxola salanga.” ");
INSERT INTO met_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu xabia baraxinta daharua mana, baing xusungadi ba, “Baruta ahangixaya mana axola salanga? Abagu saing axabia rangrang teguyu? Hatumingaim diriba ding? ");
INSERT INTO met_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ang maxaimgu, ne abagu te? Ang tangaliaimgu, ne alungu te? Ne ahatumia muli axamang tela te? ");
INSERT INTO met_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Bungina ngautu saha salanga luwadi luwadi hiliadinga mana lipu 5,000, agam daba baru mana salanga duwauyu?” Dahaxuya ba, “12.” ");
INSERT INTO met_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ne, bungina ngautu saha salanga 7 mana lipu 4,000, agam daba baru mana salanga duwauyu?” Dahaxuya ba, “7.” ");
INSERT INTO met_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Baing xusungadi ba, “Ne, axabia rangrang teguyu?” ");
INSERT INTO met_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Disok longga Betsaida, baing lipudi daxai lipu tela maxandi dahaxatu ma rangua, saing duxusunga Yesu haringina ba ring. ");
INSERT INTO met_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu xai lipua ba rimania mala sangua longa. Gip maxandi saing ta rimandi mana, baing xusunga ba, “Ubagu axamang tela, kimbo?” ");
INSERT INTO met_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Lipua ba bagu mauli saing harua ba, “Wane, ngabagu lipudi bila xaidi dahaxa mauli.” ");
INSERT INTO met_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Baing Yesu ta rimandi mana maxandi muli. Baing ina naga, lipua bagu haringina, sok xai dup saing bagu axamandi xai. ");
INSERT INTO met_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu soxi mala numia, saing harua ba, “Labu uluxu mana longau tai.” ");
INSERT INTO met_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu gabu lipuxindi dinaxu mana dila longgadi duwa singia Sisaria Pilipai. Dahaxa malau saing xusungadi ba, “Lipudi daharua ba nga gaxarea sibuna?” ");
INSERT INTO met_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Dahaxuya ba, “Teladi daharua ba ung ba Lipu Suguangama Yon. Teladi daharua ba Elaitsa. Ne teladi daharua ba ung Urana lipuxing suxunguxunguam tela.” ");
INSERT INTO met_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Baing Yesu xusungadi ba, “Ne ang ba, ang gaharua ba nga gaxarea?” Pita haxuya ba, “Ung Urana Lipuxing Mogunganama.” ");
INSERT INTO met_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Baing Yesu bilidi ba labu dibala lipu tela manau tai. ");
INSERT INTO met_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Baing ungguti tubatubadi ba Lipua Ma Rangua Urana bagula xap salak xumana. Lipu haringindi, lipu hananiangamdi yanamidingdi xaung lipu hanaunaunga tubatubainganamdi bagula dihitixiya, dung mati, ne kimuya mana xaidap tuwa bagula mesa muli. ");
INSERT INTO met_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Harua sabasabia nadi mana ala baguba. Baing Pita xap mala singia saing ungguti bili ba labu harua nadi bila bau tai. ");
INSERT INTO met_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ne Yesu xugia mala, bagu lipuxindi dinaxu mana, bili Pita saing harua ba, “Satan, uhaya! Uhatumia bila Urana hatumia te. Uhatumia bila lipu titiamdi.” ");
INSERT INTO met_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Baing wagi buranga xaung lipuxindi dinaxu mana dima rangua saing harua ba, “Lipu gaxarea dibo ba dinaxu manga, bing dahalingalinga murungadinga, diti doxoxi xaiding balingamdi, saing dinaxu manga. ");
INSERT INTO met_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Namua na lipu gaxarea dituxu haringina walingadinga, bing bagula dahanggalang. Ne lipu gaxarea diyunga walingadinga bu dinaxu manga xaung ulek xaiyua, bing bagula daxap walinga sibuna. ");
INSERT INTO met_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nabu lipu tela xap axamang titiam longgalo, ne ina walinganoa hanggalang, bing axadi bagudi li bagula daxap ina muli baru? ");
INSERT INTO met_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Baraxinta sanga ba lipu tela sina bu haxuya walinganoa? Tegu. ");
INSERT INTO met_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Lipu hatatam diyunga Urana xaung dilibu kubolu diang xangxana. Ne maluxu manadi, lipu gaxarea memeyading manga xaung haruangagua, bing kimuya Lipua Ma Rangua Urana bagula memeyana manadi xauna, bungina ma liwe mana Tibuna ralanoa, xaung ma rangua Urana uleginam maringindi.” ");
INSERT INTO met_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Baing baladi ba, “Maxung sibuna ngabalang ba, ang teladi awa la li, bagula amati teguyu saing bagula abagu Urana Yonggaxinoa ma xaung haringingana.” ");
INSERT INTO met_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Xaidap 6 disup, baing Yesu xap Pita, Yems, Yon dingtung, saing xaidi mahaing bimbi sabanga tela, ne ding ganiding duwa. La ba, Yesu xugia maxadingia. ");
INSERT INTO met_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Imangindi disina saing disok usamang sibuna. Lipu titiam tela sanga ba libu imangdi dusa bila ba te. ");
INSERT INTO met_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Baing Elaitsa Moses tang dowa masok tung maxadingia, tang daharua rangua Yesu. ");
INSERT INTO met_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Baing Pita harua na Yesu ba, “Lipu Tubatubaingam, xai sibuna tawa la li. Amtum gabo ba am gatongtongia xahi tuwa—tela naung, tela na Moses, xaung tela na Elaitsa.” ");
INSERT INTO met_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita harua olang bila ba, namua na tung dimaxuwa sibuna, binabu xabia te mana baru haruanganta. ");
INSERT INTO met_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Baing mugap tela sok saing kaudi. Waxutu tela sok mugabia ma, harua ba, “Alali Garagu sibuna, nga murugu sibuna mana. Angtung galungu haruanganoa!” ");
INSERT INTO met_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hata sibuna li dingtung dibagu mauli, dibagu lipu tela te. Yesu ing ganina wa ranguadi. ");
INSERT INTO met_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tauna diyunga bimbia ba, diri malauyu, saing Yesu bilidi ba labu dibala lipu tela mana axamana dibagu tai, laing kimuya mana Lipua Ma Rangua Urana mesa muli mana matiyua. ");
INSERT INTO met_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Dihisa mana haruanganoa rangua ding, ne dahangixaya nading ba haruangua “mesa muli mana matiyua” namuxinoa baru. ");
INSERT INTO met_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Baing duxusunga ba, “Baruta lipu hanaunaunga tubatubainganamdi daharua ba Elaitsa bagula goxoya ma muga mana Urana Lipuxing Mogunganama ma?” ");
INSERT INTO met_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu haxuya nadi ba, “Maxung sibuna, Elaitsa ma muga bu hamaringia axamandi to. Ne baruta Urana Xuanoa baxanga ba Lipua Ma Rangua Urana bagula xap salak sabanga xaung lipudi diyamu? ");
INSERT INTO met_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ne ngabalang ba, Elaitsa ma ba, saing dilibu ding murungadinga mana, bila Urana Xuanoa baxanga mana baing.” ");
INSERT INTO met_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Bimbi namuya Yesu gabu dingtung disok mana lipu teladi dinaxu mana, dibagu buranga sabanga digugunia taxiyadi, saing lipu hanaunaunga tubatubainganamdi dahakhaxi mua ranguadi. ");
INSERT INTO met_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Baing bungina lipudi dibagu Yesu sok, dihixi mana saing diluki mala rangua, daharua xaidap xai na. ");
INSERT INTO met_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Baing xusungadi ba, “Ahakhaxi mana baraxinta?” ");
INSERT INTO met_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Lipu tela liwe mana burangua haxuya ba, “Lipu Tubatubaingam, ngaxap garagua ma ranguaung, namua na xaunga wa mana, libu harua tate. ");
INSERT INTO met_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Bungina xaunga ba tuxu haringina bing ting mari titia, gaugauna, gaxu waindi saing haringharing. Menau ngaxusunga lipuximdi dinaxu maung ba disuka xaungua mala, ne ding sanga te.” ");
INSERT INTO met_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Baing Yesu harua nadi ba, “Ai, ang hatatamdi ahatum haringin te. Xaidap baru bagula ngawauyu ranguang? Xaidap baru bagula ngaxap salaga mang? Axap gara ba ma rangua nga to.” ");
INSERT INTO met_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Binabu daxap ma rangua. Bungina xaungua bagu Yesu, hata sibuna li libu gara ba lulu haringina. Xung mari titia saing tutuxuya mauli, gaunggauna. ");
INSERT INTO met_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Baing Yesu xusunga tibuna ba, “Bunging baru wa bila ba?” Haxuya ba, “Bungina kaxukanauyu sok bila ba. ");
INSERT INTO met_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Bunging xumana ting mahaing yabia saing ting mari langia bu ung mati. Ne nabu ung sanga mana ulibu axamang tela, bing usingam saing uhauliam.” ");
INSERT INTO met_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Baing Yesu harua ba, “Baruta uharua ba, ‘Nabu ung sanga mana’? Axamang longgalo axamang olang mana lipua hatum haringina.” ");
INSERT INTO met_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Hata sibuna li tibuna xaba ba, “Ngahatum haringina, ne hatumingagua haringina raxap. Uhauli nga!” ");
INSERT INTO met_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Bungina Yesu bagu buranga digugunia dima haxek sibuna rangua, bili xaungua ba, “Ung xaunga ulibu harua te xaung lungu te, ngatabinaung ba usok ma sangua saing uluxu muli manau tai.” ");
INSERT INTO met_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Baing xaungua xaba saing libu lulu haringina saking sok ma sangua. Gara ba wa bila matia tela, binabu lipu xumana daharua ba, “Mati lo.” ");
INSERT INTO met_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ne Yesu tuxu rimania, iti mesa saing li. ");
INSERT INTO met_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kimuya Yesu luxu numia, baing lipuxindi dinaxu mana duxusunga hisangia ba, “Baruta am sanga ba am gasuka mala te?” ");
INSERT INTO met_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Haxuya nadi ba, “Sabungua ing ganina sanga ba suka xaunga na bila li. Daxanga tela te.” ");
INSERT INTO met_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Diyunga longga baguba saing dahaxa maluxu Galili. Yesu hauxana ba lipudi daxabia ba wa bi, ");
INSERT INTO met_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","namua na tubatuba lipuxindi dinaxu mana. Baladi ba, “Bagula dita Lipua Ma Rangua Urana bixuandi rimadingia. Bagula dung mati, ne kimuya mana xaidap tuwa, bagula mesa muli.” ");
INSERT INTO met_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ne daxabia rangrang haruanga ba namua te, saing dimaxuwa ba duxusunga mana. ");
INSERT INTO met_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Dila Kaperneam. Bungina wa numia Yesu xusungadi ba, “Ahakhaxi mana baraxinta bungina ahaxa daxangia?” ");
INSERT INTO met_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ne daharua te, namua na daxangia dahakhaxi liwe mading mana gaxarea wa mugamuga. ");
INSERT INTO met_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Baing Yesu rung mari, wagi Lipu 12 dima, saing harua ba, “Lipu gaxarea bo ba wa mugamuga, bing wa kimu sibuna xaung lipu haulingam mana lipu longgalo.” ");
INSERT INTO met_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Xap gara tela saing ta liwe manadi. Saking iti mahaing, sep saing baladi ba, ");
INSERT INTO met_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Lipu gaxarea daxap gara bila li mana yagua, bing daxap nga. Saing lipu gaxarea daxap nga, bing daxap nga ganigu te. Tegu. Daxap ina soxi nga ma ba.” ");
INSERT INTO met_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yon harua na ba, “Lipu Tubatubaingam, am gabagu lipu tela suka xaungadi mala mana yama. Ne, am gabili, namua na kiria tela te.” ");
INSERT INTO met_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ne Yesu harua ba, “Labu abiliu tai, namua na lipu gaxarea dilibu axamang haringina mana yagua, bing sanga ba daharua diana manga sap te. ");
INSERT INTO met_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Lipu gaxarea dilibu doa makira te, bing kira riaradi. ");
INSERT INTO met_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Maxung sibuna ngabalang ba, lipu gaxarea disina langa nang mana yagua namua na ung Kristo bakbaging tela, bing maxung sibuna Urana bagula haxuya nadi. ");
INSERT INTO met_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Lipu gaxarea xai lipu tela hatum haringina manga daxanga diania, heku lipua ba yan tate bila gara kaxukana li, Urana bagula sina salaga na. Nabu digoxi siang sabanga waxungtuania, saing diting mari tegia, bing salaga xap bagula kaxukana mana salaga xap yu Urana rimania. ");
INSERT INTO met_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Nabu rimama libung ulibu kubolu diana, bing utaxiti. Xai buk mana uluxu walinga maxaxayamia xaung rimam taininau. Nam rimam luwa ne uluxu long salakkamia, la ba yaba mati te. ");
INSERT INTO met_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Baing nabu kima libung ulibu kubolu diana, bing utaxiti. Xai buk mana uluxu walinga maxaxayamia xaung kim taininau. Nam kim luwa ne ditinggung mari long salakkamia. ");
INSERT INTO met_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Baing nabu maxama libung ulibu kubolu diana, bing uhasi. Xai buk mana uluxu Urana Yonggaxinia xaung maxam taininau. Nam maxam luwa ne ditinggung mari long salakkamia. ");
INSERT INTO met_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","La ba, “ ‘moxamoxa daxangxangiadi, moxamoxadi ba dimati te, saing yap subingang teguama taudi.’ ");
INSERT INTO met_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Bagula yaba ri mana lipu longgalo bila mosak ri mana anginga. ");
INSERT INTO met_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mosak axamang xai. Ne nabu dauyanoa sup, bing aria baru bu mosaga dau muli? Tegu. Mosaga libu angingadi didau, baing ina naga asok bila mosak xai saing arung mosiu ranguang.” ");
INSERT INTO met_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tauna, Yesu yunga longga baguba saing kisi Langga Yodan hataina mala titia Yudia. Buranga dila rangua muli saing tubatubadi, ina kubolunoa naga. ");
INSERT INTO met_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisi teladi dima, dibo ba dituba binabu duxusunga ba, “Hanaunaungua harua ba sangau mana lipu tela taxiti yaunganoa, kimbo tegu?” ");
INSERT INTO met_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Haxuya nadi ba, “Moses hanaunauang baru?” ");
INSERT INTO met_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Daharua ba, “Moses nai ba lipua bung taxiti yaunga xailongina saing suka hainga mala.” ");
INSERT INTO met_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ne Yesu harua nadi ba, “Gamoim diriba ding, binabu Moses bung hanaunaunga baguli nang. ");
INSERT INTO met_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ne mugau sibuna, bungina Urana tongtongia axamandi, ‘tongtongiadi lup haing.’ ");
INSERT INTO met_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Mana namua baguli lup tela yunga baungtibundi saing taga rangua haininoa, ");
INSERT INTO met_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","baing tang disok lipu taininau.’ Baing ina naga, tang duwa luwauyu te, tang duwa bila lipu taininau. ");
INSERT INTO met_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Binabu, baraxinta Urana taga masup, labu lipua taxitiu tai.” ");
INSERT INTO met_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Bungina duwa numia muli, lipudi dinaxu mana duxusunga Yesu mana haruanga baguba. ");
INSERT INTO met_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Baing harua nadi ba, “Lipu gaxarea taxiti yaunganoa saing yau haing tela muli, bing libu kubolu diana na haininoa mana yaunga daxanganoa. ");
INSERT INTO met_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Baing nabu hainga taxiti yaunganoa saing yau lup tela muli, bing libu kubolu diana mana yaunga daxanganoa.” ");
INSERT INTO met_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Lipu teladi daxap gara kaxukandi ma rangua Yesu bu ta rimandi manadi. Ne lipudi dinaxu mana dibilidi. ");
INSERT INTO met_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Bungina Yesu bagu dilibu bila ba, hatuminganoa doa manadi saing baladi ba, “Ayunga garadi dima rangua nga, labu abilidiu tai, namua na lipuadi duwa bila garadi bagudi li, Urana Yonggaxinoa dingia. ");
INSERT INTO met_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Maxung sibuna ngabalang ba, lipu gaxarea diyunga ding te ba duwa hawa mana Urana bila garadi dilibu, bing sanga ba diluxu Urana Yonggaxinia te.” ");
INSERT INTO met_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Baing iti garadi mahaing saing sepdi, ta rimandi manadi, saing xusunga Urana ba sina guxama nadi. ");
INSERT INTO met_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu mesa ungguti haxa mala, baing lipu tela luki ma rangua saing gung king tuxundi maxania. Xusunga ba, “Lipu Tubatubaingam Xai, ngaria baru bu ngaxap walinga subingang teguama?” ");
INSERT INTO met_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Baing Yesu haxuya ba, “Baruta uxu nga ba xai? Lipu tela xai te. Urana ing ganina xai. ");
INSERT INTO met_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Uxabia hanaunaungadi: ‘Ung matiu tai, ukinu rangua tela uyau teguyu bau tai, uhanaiu tai, usu haruanga languangamgu tai, ulanglangua lipu tela bu oxop xalingindi olanggu tai, uwa hawa mana baumtibumdi.’ ” ");
INSERT INTO met_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Baing baxanga na Yesu ba, “Lipu Tubatubaingam, bungina ngawa garauyu ma laing hatata, hanaunaunga longga bagudi li ngasu manadi.” ");
INSERT INTO met_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu bagu mua mana, murung sibuna mana, saing harua ba, “Axamang tela uraxap mana. Ula usina xalingimdi masup. Usina giminagidingdi na lipu haxugindi, bing bagula oxop axamang maxung sibundi maluxu long xaiya. Saking uma, unaxu manga.” ");
INSERT INTO met_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Bungina lungu haruanga baguba, baing ila, ayangang sibuna, namua na xalingindi xumang sibuna. ");
INSERT INTO met_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Baing Yesu bagu mauli, harua na lipuxindi dinaxu mana ba, “Laku, lipu xalaxalamdi dimakasa sibuna mana diluxu Urana Yonggaxinia!” ");
INSERT INTO met_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Baing lipudi dinaxu mana dihixi mana haruanganoa. Ne Yesu harua nadi muli ba, “Gananuna mana, makasa sibuna mana lipudi diluxu Urana Yonggaxinia! ");
INSERT INTO met_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Lipu xalaxalama bo ba luxu Urana Yonggaxinia, makasanganoa dali kamel tela ila luxu saxang ginanginia.” ");
INSERT INTO met_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Baing dihixi buk mana, saing duxusunga ding ba, “Si! Nabu bila ba, bing lipu gaxarea bagula daxap walinga subingang teguama?” ");
INSERT INTO met_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu bagudi saing harua ba, “Lipu ding sibuding sanga tate, ne Urana ina sanga. Urana ina sanga mana axamang longgalo.” ");
INSERT INTO met_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita harua na ba, “Ai! Am ba, am gayunga axamandi masup bu am ganaxu maung.” ");
INSERT INTO met_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu haxuya ba, “Maxung sibuna ngabalang ba, lipu gaxarea dahatumia nga xaung ulek xaiyua saing diyunga yabadingdi, sabangadingdi, kixingidingdi, hamungadingdi, baudingtibudingdi, garadingdi, kimbo umangadingdi, ");
INSERT INTO met_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","bing bagula daxap 100 muli mana bungina hatata. Bagula daxap axamang xumana: yabadingdi, sabangadingdi, kixingidingdi, hamungadingdi, baudingdi, garadingdi, umangadingdi, saing xauna, bagula daxap salakdi. Ne kimu sibuna, bagula daxap walinga subingang teguama. ");
INSERT INTO met_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ne xumana duwa mugamugangia bagula duwa kimuya. Baing xumana duwa kimuya bagula duwa mugamugangia.” ");
INSERT INTO met_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Dahaxa daxangia, Yesu muga manadi, dahaing mala mana long sabangga Yerusalem. Lipudi dinaxu mana dihixi mana, saing lipudi disu manadi dimaxuwa. Baing xap Lipu 12 mala singia muli, saing baxanga nadi ba baraxinta bagula sok mana. ");
INSERT INTO met_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Baladi ba, “Alungu to. Tahaing Yerusalemguba, saing bagula dita Lipua Ma Rangua Urana lipu hananiangamdi yanamidingdi xaung lipu hanaunaunga tubatubainganamdi rimadingia. Bagula dita haruangia baing bagula dahau haruangua ba dung mati. Baing bagula dita Yuda Teguamdi rimadingia. ");
INSERT INTO met_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Baing bagula didaudau, daxanubia, digusi, saing dung mati. Ne kimuya mana xaidap tuwa bagula mesa muli.” ");
INSERT INTO met_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Baing Yems, Yon, Sebedi garandi, tang dima rangua Yesu saing daharua na ba, “Lipu Tubatubaingam, tam gabo ba ulibu mam baraxing baraxinta tam gaxusungaung mana ba.” ");
INSERT INTO met_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Baing xusungadi ba, “Tang gabo ba ngalibu baru mang?” ");
INSERT INTO met_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Baing tang dahaxuya ba, “Kimuya bungina urung kabukabu ralanamia, tam gabo ba tam garung mana rubimdi, tela rung rimamo, tela rung xong, tam gaxap yaya bila ba.” ");
INSERT INTO met_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ne Yesu harua nadi ba, “Tang gaxabia te axusunga baru. Sanga ba tang ganung mana xuba salakkam bila nganung mana? Kimbo sanga ba axap lang matiama bila ngaxap?” ");
INSERT INTO met_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Dahaxuya na ba, “Wane, amtam sangau.” Baing Yesu bala dingtang ba, “Maxuna, xuba nganung mana, bagula tang ganung mana xauna, saing langga ba ngaxap, bagula tang gaxap xauna. ");
INSERT INTO met_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ning lipu gaxarea rung mana rimagu rimamo kimbo xong, nga sanga ba ngamogu te. Tegu. Urana xauxaudi masup na moxodingdi.” ");
INSERT INTO met_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Baing bungina lipu 10 dinaxu mana dilungu bila ba, gamodingdi didoa mana Yems Yon tang. ");
INSERT INTO met_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu wagidi ma digugunia saing harua nadi ba, “Ang gaxabiau, Yuda Teguamdi yanamidingdi duwa etua manadi diti ding. Yanamidingdi dahaxi ba lipudi disu mana haruangadinga. ");
INSERT INTO met_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ne heku awa bila ba. Tegu. Lipu gaxarea bo ba wa sabanga liwe mang, bing wa ang lipuxim haulingama. ");
INSERT INTO met_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Baing lipu gaxarea bo ba wa mugamuga liwe mang, bing wa lipu oxata olanggam mana lipu longgalo. ");
INSERT INTO met_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Namua na Lipua Ma Rangua Urana ing sibuna ma bu lipudi dahauli te. Tegu. Ma bu hauli lipudi, xaung yunga walinganoa bu gim muli lipu xumana.” ");
INSERT INTO met_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Disok Yeriko. Yesu gabu lipuxindi dinaxu mana xaung buranga sabanga, ding diyunga long sabangga ba, baing lipu maxa haxatiang tela, Batimeas (namuxina ba “Timeas garanoa”), rung mua daxanga rubinia, xusunga lipudi olang olang mana sianga. ");
INSERT INTO met_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bungina lungu ba Yesu Nasaretiam ma, ungguti wagi ba, “Yesu, Xaitamoxi Debit Garanoa ba, usinga nga!” ");
INSERT INTO met_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Baing lipu xumana dibili, dibala ba, “Udik!” Dibalabala sus, haxi buk saing wagi sabanga ba, “Xaitamoxi Debit Garanoa ba, usinga nga!” ");
INSERT INTO met_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Baing Yesu li mua saing harua ba, “Awagi ma.” Baing duwagi lipua maxandi dahaxatu, daharua ba, “Uyaha! Umesa, wagiung baing.” ");
INSERT INTO met_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Baing ting imanging xabubungama mala singia, hixi mesa saing ma rangua Yesu. ");
INSERT INTO met_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Baing Yesu xusunga ba, “Ubo ba ngariaung baru?” Lipua maxandi dahaxatu harua na ba, “Lipu Tubatubaingam, ngabo ba ngabagu.” ");
INSERT INTO met_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Baing Yesu harua na ba, “Ulauba, hatumingam haringina hamaringiaung.” Hata sibuna li maxandi disok xai dup, saing su mana Yesu daxangia. ");
INSERT INTO met_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu gabu lipuxindi dinaxu mana dima haxek monga mana long sabangga Yerusalem, baing disok haxek mana long luwa Betpets, Betani duwa Xaxagania Olip. Yesu soxi lipuxing luwa dinaxu mana mala, ");
INSERT INTO met_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","harua nadi ba, “Tang galuxu mana longga wa mugamugangia to. Haxek sibuna ba aluxu, bagula abagu donki haun tela digoti la ba, lipu tela rung mana teguyu. Tang galuba saing axai ma. ");
INSERT INTO met_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nabu lipu tela xusungang ba, ‘Baruta tang galibu bila ba?’, bing tang gabala ba, ‘Toxoratamona oxatana mana. Bagula soxi ma muli sap.’ ” ");
INSERT INTO met_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Baing dilauba, dibagu donki hauna lipudi digoti numa tela xaluxing singia, wa daxanga sabangia. Bungina diluba, ");
INSERT INTO met_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","lipu teladi dili mua la ba duxusunga ba, “Tang garaxata? Baruta aluba donki ba?” ");
INSERT INTO met_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Baing tang dahaxuya bila Yesu harua nadi ba. Dilungudi baing tang dilauba. ");
INSERT INTO met_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Baing daxap donki ma rangua Yesu, diting imangiding sabangadi mahaing, saking Yesu rung etua mana. ");
INSERT INTO met_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Lipu xumana duxa imangiding sabangadi daxangia bu dahatanga ba lipu yayam sabanga, saing teladi ditaxiti xai rimandi umangia saing duxadi daxangia. ");
INSERT INTO met_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Baing lipudi dimuga mana gabu lipudi disu mana ding duwagi ba, “Taiti Urana yanoa!” “Urana sina guxama na lipua li ma mana Toxoratamona yanoa ba!” ");
INSERT INTO met_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Urana sina guxama na mugangaroa Debit Yonggaxinoa, bagula sok muli!” “Taiti Urana Eta Loam Sibuna yanoa!” ");
INSERT INTO met_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Baing Yesu luxu Yerusalem saing luxu Urana Numang yabania. Haxa mauli maluxu, bagu axamandi laing sup baing yambongguba. Binabu gabu Lipu 12 dila disok mala Betani. ");
INSERT INTO met_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Buragina baing diyunga Betani, dilauba saing Yesu gesagina. ");
INSERT INTO met_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bagu mala saing bagu xai xangingam tela duxu ba pik, lonam. Ila haxek mana bu sai mana marandi. Sok mana, baing tegu, long ding ganiding duwa namua na xaiya pik nianinoa teguyu. ");
INSERT INTO met_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Baing harua na xaiya ba, “Sanga ba lipu tela xang maramdi muli te.” Baing lipuxindi dinaxu mana dilungu haruanga baguba. ");
INSERT INTO met_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bungina disok Yerusalem, Yesu luxu Urana Numang yabania saing suka lipuadi digim disina axamandi mana sianga maluxu Urana Numania masokkuba. Matuxuya lipu siang hakhaxuyanganamdi kabukabudingdi xaung lipu gumak sinaikkamdi kabukabuding rungingamdi. ");
INSERT INTO met_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Baing bili lipudi mana disiasia axamandi mala ma makisi Urana Numang yabaniau tai. ");
INSERT INTO met_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Baing tubatubadi, harua nadi ba, “Aisaya bung Urana Xuania ba Urana harua ba, “ ‘Numagua bagula duxu ba numa sabungam mana numanuma longgalo.’ Ne ang gaxugia mala bila ‘guha tela lipu hanaunggamdi dihisa maluxu mana!’ ” ");
INSERT INTO met_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Lipu hananiangamdi yanamidingdi digabu lipu hanaunaunga tubatubainganamdi dilungu haruanga baguba, baing dungguti disai daxanga tela bu dung Yesu mati. Dimaxuwa mana, namua na lipu buranga dihixi mana tubatubainganoa. ");
INSERT INTO met_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yambong baing disok sangua long sabangga ba. ");
INSERT INTO met_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Buraragina bungina dahaxa malau, dibagu xaiya pik. Mutuxu masup, oxaxandi xauna. ");
INSERT INTO met_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita hatum muli saing harua na Yesu ba, “Lipu Tubatubaingam, ubagu lo! Xaiya pik ugamia ba, mutuxu ba!” ");
INSERT INTO met_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu haxuya nadi ba, “Ahatum haringina mana Urana. ");
INSERT INTO met_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Maxung sibuna ngabalang ba, lipu gaxarea harua na bimbia li ba, ‘Umesa, utinggung mari tegia’, xaung hatumingang luwa te, ne hatum haringina mana axa harua mana ba bagula sok, bing bagula Urana libu mana. ");
INSERT INTO met_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Binabu ngabalang ba, baraxing baraxinta axusunga sabungia, nabu ahatum haringina bila axap masup ba, bing bagula axap. ");
INSERT INTO met_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Baing bungina ali asabu mua, nabu ahatum muli mana axamang diana lipu tela libu mang, bing ayunga kubolunoa. Baing ina naga Tibuim, ina wa long xaiya, bagula yunga kuboluim diandi xauna.” ");
INSERT INTO met_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu gabu lipudi dinaxu mana disok Yerusalem muli. Bungina Yesu haxa mua maluxu Urana Numang yabania, lipu hananiangamdi yanamidingdi, lipu hanaunaunga tubatubainganamdi xaung lipu haringindi dima rangua, ");
INSERT INTO met_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","duxusunga ba, “Oxop yaya ba rangua gaxarea bu ulibu axadi bagudi li? Gaxarea mogung ba ulibudi?” ");
INSERT INTO met_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu haxuya ba, “Bagula ngaxusungang xusunganga tela to. Ahaxuya xusungangagua, bing bagula ngabaxanga ngaxap yaya ba rangua gaxarea bu ngalibu axadi bagudi li. ");
INSERT INTO met_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tauna, bungina Yon sugua lipudi—Gaxarea sina yaya na bu libu? Urana kimbo lipudi? Abaxanga nanga!” ");
INSERT INTO met_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dahangixaya liwe mading ba, “Nabu taharua ba, ‘Urana sina,’ bing bagula xusunga kira ba, ‘Ne baruta ahatum haringina mana Yon te?’ ");
INSERT INTO met_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ne nabu taharua ba, ‘Lipudi disina,’ bing laku!” (Dimaxuwa lipudi, namua na lipu longgalo dahatum ba Yon ba Urana lipuxing suxunguxunguam sibung tela.) ");
INSERT INTO met_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Baing ina naga, dahaxuya ba, “Am gaxabia te.” Baing Yesu haxuya ba, “Tauna, nga xauna, bagula ngabalang te ba gaxarea sina yaya nanga bu ngalibu axadi bagudi li.” ");
INSERT INTO met_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Baing ungguti harua babudi na Yudadi yanamidinggadi ba, harua ba, “Lipu tela xuma wain umangang tela. Tongtongia gamgaminga taxiya, saba wain marang ruhangam yabana mari siangia, saing tongtongia xahi wasangam maxaxayam tela. Saking sina na lipu umangamdi, duwaxata bu daxap marang hataindi nading, saing ing sibuna ila haxa mauli hasoya. ");
INSERT INTO met_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Bunging moyangama sok, baing soxi lipuxing haulingam tela mala rangua lipu umanga wasanganamdi bu xap wain marang hataindi ranguadi. ");
INSERT INTO met_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ning dituxu ditaha saing disuka olang mala. ");
INSERT INTO met_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Baing soxi lipuxing haulingam tela muli nadi. Ne ditaha toxonia saing dilibu doa mana, disina memeya na. ");
INSERT INTO met_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Baing soxi tela muli mala, baing dung mati. Soxisoxi xumana mala: Teladi ditahadi, teladi dungdi mati. ");
INSERT INTO met_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ne lipu taininau wauyu: Garanoa, ina murung sibuna mana. Kimu sibuna soxi mala ranguadi. Hatum ba, ‘Bagula dilungu garagu haruanganoa.’ ");
INSERT INTO met_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ne lipu umanga wasanganamgadi ba daharua nading ba, ‘Moxona garanoa lo. Kimuya bagula xap tibuna xalingindi. Tala taung mati, bing xalingindi bagula dima rimaria.’ ");
INSERT INTO met_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Binabu dituxu, dung mati saing diting mala sangua umangua. ");
INSERT INTO met_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ahatum baru? Wain umangang moxonoa bagula riadi baru? Bagula ma ung lipu umanga wasanganamgadi ba mati, saing sina umangua na teladi. ");
INSERT INTO met_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Haruanga li wa Urana Xuania, atiti ba ne baruta ahatumia te? Harua ba, “ ‘Sianga lipu numa tongtongianganamdi dihitixiya bila diana, sok siang mugamugangam bu haringia numa rubing longgalo. ");
INSERT INTO met_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Toxoratamona libu axa baguli sok, saing am gabagu, xai sibuna maxamamia.’ ” ");
INSERT INTO met_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Harua laing sup, baing disai daxanga bu dituxu, namua na daxabia ba su haruanga babuna baguba manadi. Ne dimaxuwa mana lipu buranga duwa, binabu diyunga saing dila. ");
INSERT INTO met_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kimuya yanam teladi disoxi Parisi teladi digabu Herot bakbaging teladi mala rangua Yesu. Dibo ba dilanglangua bu harua haruanga tela maringing te. ");
INSERT INTO met_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Baing dila rangua, daharua ba, “Lipu Tubatubaingam, am gaxabia ba ung lipu haruanga maxunama. Uhatum xumana mana lipudi hatumingadinga te. Ulibu hasusu mana lipu longgalo, heku lipu yayamdi kimbo lipu yaya teguamdi. Ne utubatuba Urana daxanganoa xaung haruanga maxuna.” Tauna, duxusunga ba, “Maring mana tagim takis mala na Sisa, kimbo doa? ");
INSERT INTO met_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tagim kimbo tegu?” Ne Yesu xabia muragidinga, binabu xusungadi ba, “Baruta atuba ba atuxu murak manga? Axap siang tela ma bu ngabagu to.” ");
INSERT INTO met_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Baing daxap siang mukirina ma, saing xusungadi ba, “Gaxarea babunoa li? Gaxarea yanoa wa mana?” Dahaxuya ba, “Sisa naga.” ");
INSERT INTO met_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Baing Yesu harua nadi ba, “Axadi Sisa iniadi, asinadi na Sisa, saing axadi Urana iniadi, asinadi na Urana.” Baing dihixi mana haruanganoa. ");
INSERT INTO met_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Baing Sadyusidi dila rangua. Ding dahatiam mana lipudi bagula dimesa muli. Duxusunga Yesu ba, ");
INSERT INTO met_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Lipu Tubatubaingam, Moses bung haruanga tela makira Urana Xuania ba: Nabu lipu tela mati, sangua haininoa, ne garang tate, bing kixinginoa bagula yau sabanganoa tabinoa bu tang daxap garadi masok, saking sabanganoa bakbagindi bagula disup te. ");
INSERT INTO met_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tauna, bunging tela neng sabangang 7 duwa. Mugamugangama yau haing tela saing mati, garang tate. ");
INSERT INTO met_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Bing kixinginoa ma kimu mana mugamugangama yau tabinoa saing mati, garang tate. Hiliadinga kubolu taininau. ");
INSERT INTO met_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bila balau, disup baing ina naga, hainga mati. ");
INSERT INTO met_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tauna, kimuya, bungina lipudi dimesa muli, bing haingga ba bagula wa gaxarea haininoa sibuna? Namua na 7 ding diyau ba.” ");
INSERT INTO met_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu haxuya ba, “Namua naga hatumingaimdi didoa. Ang gaxabia Urana Xuanoa te xaung haringinganoa. ");
INSERT INTO met_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bungina lipudi dimesa muli, bagula lup haing diyau ding te. Bila balau bagula duwa bila Urana uleginamdi duwa long xaiya. ");
INSERT INTO met_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ne mana haruangua mana lipudi dimesa muli—ngabo ba ngaxusungang to. Atiti xailongga Moses bung mana axa ba, ne baruta ahatumia te? Mana hataina naxuya mana xai kaxukana yaba wa mana ba, kimu sibuna mana mugangaradi Ebraham, Aisak xaung Yekop tung dimati ba, Urana harua na Moses ba, ‘Ngawa Urana mana Ebraham, Urana mana Aisak, xaung Urana mana Yekop.’ ");
INSERT INTO met_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Binabu ina Urana mana lipu matiandi te. Tegu. Ina Urana mana lipu gamatandi. Ang ba, hatumingaimdi dirabang masup!” ");
INSERT INTO met_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Lipu hanaunaunga tubatubainganam tela ma saing lungudi dahakhaxi mua. Lungu Yesu haxuya nadi xai, binabu xusunga ba, “Hanaunaunga baruamta mugamuga?” ");
INSERT INTO met_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu haxuya ba, “Mugamugangama bing bila li: ‘Ang Isreldi, alungu! Toxoratamona Urana kiria, ing ganina wa Toxoratamona. ");
INSERT INTO met_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bing ung murum sibuna mana Toxoratamona, Urana ungia, mana gamom longgalo xaung lum longgalo xaung hatumingam longgalo xaung haringingam longgalo.’ ");
INSERT INTO met_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Luwa bing bila li: ‘Bing ung murum sibuna mana riam longgalo bila ung murum sibuna maung.’ Hanaunaunga tela dali bagudi li te.” ");
INSERT INTO met_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Lipua ba haxuya na ba, “Lipu Tubatubaingam, haruangama maring. Maxung sibuna uharua ba Urana taininau ing ganina, ne tela muli te. ");
INSERT INTO met_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Saing murura sibuna mana, mana gamora longgalo xaung hatumingara longgalo xaung haringingara longgalo. Saing murura sibuna mana riara longgalo bila murura sibuna makira. Hanaunaunga luwadi bagudi li didali hananianga asaxam longgalo ditau xaung hananianga teladi.” ");
INSERT INTO met_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu lungu lipua ba haxuya haruanga bila lipu xabiangam, baing harua na ba, “Uwa hasoya mana Urana Yonggaxinoa te.” Baing kimuya mana bungina baguba, lipu longgalo dimaxuwa mana dituba mana xusunganga tela muli. ");
INSERT INTO met_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu baxanga mua maluxu Urana Numang yabania, baing harua ba, “Baruta lipu hanaunaunga tubatubainganamdi daharua ba Urana Lipuxing Mogunganama wa Debit garanoa? ");
INSERT INTO met_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Debit ing sibuna, Urana Aningonoa sina hatumingua na, baxanga ba: “ ‘Toxoratamona harua na Toxoratamona ngayua ba: “Urung kabukabu yayam wa rimagu rimamo rubinia, laing ngata bixuamdi hawa maung.” ’ ");
INSERT INTO met_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nabu Debit ing sibuna uxu ba ‘Toxoratamona,’ bing ina wa Debit garanoa xauna baru?” Baing buranga sabanga diyaha sibuna ba dilungu haruanganoa. ");
INSERT INTO met_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tubatuba mala, baing harua nadi ba, “Amaxania mana lipu hanaunaunga tubatubainganamdi. Ding muruding buk mana disau imang maxaxaya bu dahaxa mauli, saing dibo ba lipudi ditidi daharua xaidap xai nadi mana nawa yabandi. ");
INSERT INTO met_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ding muruding buk mana dirung mana kabukabu mugamugangamdi mana sabunga numandi, saing dibo ba dirung kabukabu yayamdi mana taungadi. ");
INSERT INTO met_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Dilanglangua tapdi bu dahanai xalingidingdi, saing disabu maxaxaya bu disok xai lipudi maxadingia. Kimuya, mana xaidap subinganoa, bagula daxap salak sabanga.” ");
INSERT INTO met_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu ila rung singia long sinaikkamia, bagu lipudi ditata siangdi maluxu Urana Numang siang yabania. Lipu xalaxalam xumana dita siang xumana maluxu. ");
INSERT INTO met_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ne tap haxuging tela ma saing ta siang kaxukang mukiring luwa maluxu, disok bila toia taininau. ");
INSERT INTO met_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu wagi lipuxindi dinaxu mana ma rangua saing harua nadi ba, “Maxung sibuna ngabalang ba, tap haxugina sinainganoa dali sianga lipu longgalo dita maluxu siang yabania. ");
INSERT INTO met_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Namua na lipu teladi disina hataing kaxukana mana siangiding xumana. Ne tapka ba, raxap sibuna saing sina sianging longgalo, siangindi disup mana gim anginga xaung axamandi.” ");
INSERT INTO met_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Bungina Yesu sok sangua Urana Numanoa, lipuxing tela naxu mana harua na ba, “Lipu Tubatubaingam, ubagu! Sianggadi li ditubu baru! Numa gumanging sibundi baru!” ");
INSERT INTO met_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu haxuya ba, “Ubagu numa xai sibunadi li? Xaidaba ma yu bungina siang tela bagula wa etua mana rianoa te. Tegu. Bagula ding longgalo disup mari.” ");
INSERT INTO met_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu rung Xaxagania Olip saing bagu makisi mala Urana Numania. Baing Pita, Yems, Yon digabu Andru ding ganiding duwa, baing duxusunga ba, ");
INSERT INTO met_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ubaxanga nam, bungintabi bagula axadi bagudi li disok? Baing baraxinta bagula sok muga bu hatanga ba axadi li dibo ba disokkuba?” ");
INSERT INTO met_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu harua nadi ba, “Amaxania, nam lipu tela langlanguang. ");
INSERT INTO met_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Lipu xumana bagula dima dilangua daxap yagua saing bagula daharua ba, ‘Nga lipua naga Urana soxi ma!’ Bagula dituxu murak mana lipu xumana. ");
INSERT INTO met_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Bungina alungu haruanga mana haungingadi duwa haxek, duwa hasoya, bing amaxania—labu ahixi manadiu tai. Axadi na bila ba bagula disok to, ne subinganoa sok teguyu. ");
INSERT INTO met_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Numanumadi bagula dimesa dahaunggana ding, saing yonggadi bagula dilibu taininau. Noxiga sabangadi bagula disok mana long xangxana, saing gesak sabangadi bagula disok xauna. Ne axadi bagudi li unggutingua ing ganina, bila bungina haing tela ungguti xunumia salak hayauxingamdi. ");
INSERT INTO met_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ang gawasa xai mang. Bagula ditang haruangia kaunsilidi maxadingia, saing digusiang maluxuʼm Yudadi sabungading numandi. Bagula ali gabanadi xaung xaitamoxidi maxadingia, namua na anaxu manga. Ne alaba ganangana mana abaxanga nga nadi. ");
INSERT INTO met_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Baing muga, bagula lipudi dibaxanga ulek xaiyua na numanuma longgalo. ");
INSERT INTO met_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Bungina dituxuang daxaiang mala haruangia, labu ahatum xumanau tai mana haruanga baruamta bagula aharua. Abaxanga haruanga baruamta Urana sina nang taxa mana bungina baguba. Namua na ang sibuim bagula abaxanga te. Tegu. Urana Aningonoa bagula baxanga suxunguimia. ");
INSERT INTO met_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Lipudi bagula dita sabangadingdi, kixingidingdi haruangia bu lipudi dungdi mati. Baing tibudingdi bagula dilibu kubolu taininau mana garadingdi. Garadingdi bagula disok bixua mana baudingtibudingdi saing disinadi na lipudi bu dungdi mati. ");
INSERT INTO met_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Lipu longgalo bagula hauxading sibuna mang, namua na yagua wa ranguang. Ne lipu gaxarea dili haringina laing matiading xaidabidingdi, Urana bagula xapdi muli. ");
INSERT INTO met_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ne muga mana titia sup, bagula abagu ‘axamang maxuwangam hanggalangiangam’ li mua long bilingamia maluxu Urana Numania.” (Lipu gaxarea dititi haruanga baguli bing dahatumia haruanga li xai!) “Baing lipudi duwa titia Yudia bing diluki mala bimbia. ");
INSERT INTO met_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Lipudi duwa numa ubunia, labu diri numia digam xalingiding teladiu tai. ");
INSERT INTO met_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Lipudi duwa umangia, labu digoxoya numia bu daxap imangiding sabangadiu tai. ");
INSERT INTO met_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Baing usinganga buk mana haingdi gamoding xaung hainggadi disina sua na garadingdi mana bungina baguba! ");
INSERT INTO met_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Asabu ba sanga ba sok bunging kuyama te, ");
INSERT INTO met_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","namua na salaga mana xaidapkadi bagudi ba bagula dali salaga mana bunging longgalo, ungguti mana Urana tongtongia axamandi laing hatata saing kimuya mauxangana bila bagula hasusu muli te. ");
INSERT INTO met_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ne bungina baguba, nabu Toxoratamona raxapkuti te, bing lipu longgalo bagula disup. Ne mana namua hatumia lipuadi ina mogudi ba ing ganina, ina raxapkuti. ");
INSERT INTO met_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Baing mana bungina baguba, nabu lipu tela harua nang ba, ‘Abagu, alali Urana Lipuxing Mogunganama!’, kimbo lipu tela harua ba, ‘Abagu, la lo!’, bing labu ahatum haringina manau tai. ");
INSERT INTO met_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Namua na lipudi bagula dima dilangua ba ding Urana Lipuxing Mogunganama kimbo dilangua ba ding Urana lipuxing suxunguxunguamdi. Bagula disok dilibu axamang haringing xangxana bu dilanglangua lipudi. Bagula dituba ba dibagu nabu sanga ba dilanglangua lipuadi Urana mogudi ba xauna. ");
INSERT INTO met_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Binabu awasa xai! Ngabaxanga axadi li nang muga bu amaxania. ");
INSERT INTO met_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ne mana bungina baguba, kimuya mana bunging salakkamga ba sup, “ ‘xaidaba bagula laba, saing sobaga bagula sina te, ");
INSERT INTO met_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","hatungdi bagula xungdi mari sangua sabalunoa, saing axamang haringindi duwa sabalunia bagula dilulu.’ ");
INSERT INTO met_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Mana bungina baguba lipudi bagula dibagu Lipua Ma Rangua Urana ma mana mugapdi xaung haringinganoa sabanga xaung ralana. ");
INSERT INTO met_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Baing bagula soxi Urana uleginamdi mala hataing hataina bu digugunia lipuadi ina mogudi ba mana titi subingang tela mala subingang tela. ");
INSERT INTO met_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Abagu xaiya pik saing axap xabianga mana: Bungina rimandi digamata saing lona, axabia ba gesaga sokkuba. ");
INSERT INTO met_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bila balau, bungina abagu axadi bagudi li disok, axabia ba xaidaba wa haxek ba, wa xaluya baing. ");
INSERT INTO met_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Maxung sibuna ngabalang ba, bagula lipu hatatamdi disup teguyu, laing axadi bagudi li disok to. ");
INSERT INTO met_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Sabaluna xaung titi bagula disup, ne xuagu marandi sanga ba disup te. ");
INSERT INTO met_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ne lipu tela xabia xaidaba xaung xaidap maxanoa te mana axadi bagudi li bagula disok. Urana uleginamdi daxabia te. Urana Garanoa xauna, ina xabia te. Tibugu ing ganina xabiau. ");
INSERT INTO met_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Amaxania! Awasa xai mua! Namua na ang gaxabia te mana bungina baguba bagula sok. ");
INSERT INTO met_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Bila lipu tela ila hasoya. Yunga numua saing ta xalingindi lipuxing oxatamdi rimadingia bu duwasa manadi. Sina oxatua na lipu taining tainina, saing tabina lipua wasa mana xalua ba wasa xai. ");
INSERT INTO met_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Binabu amaxania, namua na axabia te bungintabi numa moxonoa bagula goxoya ma. Ma bungbung, kinunga lia, bungina muxaxua xatu, kimbo buraraging sibuna, ang gaxabia te. ");
INSERT INTO met_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nabu ma sap, labu baguang akinu matabu tai. ");
INSERT INTO met_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Haruanga ngabalang mana ba, ngabala lipu longgalo: ‘Awasa xai!’ ” ");
INSERT INTO met_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kimuya mana xaidap luwa disup, baing bagula taunga sabanga luwa disok: Taunga Dalingam xaung Taunga mana Salanga Salalangang Teguama. Baing lipu hananiangamdi yanamidingdi digabu lipu hanaunaunga tubatubainganamdi ding disai daxanga hisangam ba dituxu Yesu bu dung mati. ");
INSERT INTO met_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Baing daharua ba, “Labu talibu maluxuʼm bunging Taungamau tai, nam lipudi diti haunginga sabangua.” ");
INSERT INTO met_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu wa longga Betani mana Saimon lipu saksaxama numanoa (businganoa sup ba). Wa la ba, rung kabukabia, xang mua, baing haing tela ma rangua, tuxu nanggola siang alabastam baxagi mana guxenga saminam ditongtongia mana xai tela duxu ba nad. Daxaningxaning axamang tela mana te, binabu giminaginoa sabanga sibuna. Baing tahauti nanggola xuanoa ba saing matu mari Yesu toxonia. ");
INSERT INTO met_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ne lipu teladi duwa, hatumingadingdi didoa saing duxusunga liwe mading ba, “Si, baruta sahi guxenga saminamga ba olang? ");
INSERT INTO met_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Xai nabu tasina guxenga li na lipudi bu digim bu siangga ba tasina na lipu haxugindi. Giminaginoa sanga mana lipu tela waxata xaidap 300 giminaginoa!” Baing digamia haingga ba. ");
INSERT INTO met_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ne Yesu harua ba, “Ayunga. Atautiti baru? Libu axamang xai sibuna manga. ");
INSERT INTO met_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Lipu haxugindi duwa ranguang bunging longgalo, saing bunging bungina abo ba ahaulidi, sanga ba ahaulidi. Ne nga ba, bagula ngawa ranguang bunging longgalo te. ");
INSERT INTO met_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Axamana haingga ba sanga ba libu, libu ba. Matu guxenga sanggagia bu xauxau nga muga mana kimangingagua. ");
INSERT INTO met_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Maxung sibuna ngabalang ba, mana baru rubinta lipudi dibaxanga ulek xaiyua mana titi longgalo, bagula lipudi dilungu haingga li naxuyanganoa bu dahatumia muli.” ");
INSERT INTO met_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Baing Yudas Iskariot, ina tela mana Lipu 12, ila rangua lipu hananiangamdi yanamidingdi bu hamaringia daxanga tela mana ta Yesu rimadingia. ");
INSERT INTO met_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Baing dilungu diyaha sibuna, saing dahau haruangua ba disina sianga na. Binabu sai daxanga ba ta Yesu rimadingia. ");
INSERT INTO met_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Baing xaidap mugamugangam mana Taunga mana Salanga Salalangang Teguama sok. Mana xaidapka baguba, Yudadi kuboludinga bing dahanania sipsip tutubina mana Taunga Dalingam. Baing lipuxindi dinaxu mana duxusunga Yesu ba, “Ubo ba am gala mana long baruamta bu am gaxauxau axamandi bu oxong Taunga Dalingam angianoa?” ");
INSERT INTO met_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Baing soxi lipuxing luwa dinaxu mana mala, saing harua na dingtang ba, “Ala aluxu long sabangia. Lipu tela xuru bori langinam bagula sok mangtang. Tang gasu mana. ");
INSERT INTO met_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Bungina abagu luxu mana numa tela, bing tang gabala numa moxonoa ba, ‘Lipu Tubatubaingama xusunga ba: Lobu numa lunam kabila mana ngaxang Taunga Dalingam angianoa rangua lipuxigudi dinaxu manga?’ ");
INSERT INTO met_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Baing bagula hatanga nangtang numa luna sabanga etuam tela, kabukabudi duwa masup mana. La ba, axauxau angingua nakira.” ");
INSERT INTO met_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Baing ina naga, lipuadi dinaxu mana tang dilauba, tang diluxu long sabangia saing tang dibagu axamandi duwa bila Yesu baxanga nadi ba. Binabu daxauxau Taunga Dalingam angianoa la ba. ");
INSERT INTO met_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Yambongguba, baing Yesu gabu Lipu 12 dima. ");
INSERT INTO met_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dirung daxang mua, baing Yesu harua ba, “Maxung sibuna ngabalang ba, angia tela bagula ta nga bixuagudi rimadingia. Lipu tela xang rangua nga.” ");
INSERT INTO met_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ding gamoding mauxadingguba, baing ding taining tainina duxusunga ba, “Nga te, bo?” ");
INSERT INTO met_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu haxuya nadi ba, “Ang Lipu 12 tela baing, ina tai salanga mari minia rangua nga. ");
INSERT INTO met_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Lipua Ma Rangua Urana bagula mati bila dibung waleu Urana Xuania. Ne laku, mauxanganoa bagula xap lipua ta Lipua Ma Rangua Urana bixuandi rimadingia! Xai buk mana lipua ba nabu waleu bauna hayau te.” ");
INSERT INTO met_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Daxang mua, baing Yesu xap salangua, harua xai sibuna na Urana, saing utu saha. Sina na lipuxindi dinaxu mana, saing harua ba, “Axap. Alali mututungagua.” ");
INSERT INTO met_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Baing xap xubua, harua xai sibuna na Urana, saing sina nadi. Baing ding taining tainina dinung mana. ");
INSERT INTO met_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Baing harua nadi ba, “Alali sibigua mana hau Urana haruanganoa haringina, matuxuya mari bu hauli lipu xumana. ");
INSERT INTO met_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Maxung sibuna ngabalang ba, bagula nganung wain muli te laing xaidapka nganung hauna maluxu Urana Yonggaxinia.” ");
INSERT INTO met_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Duwaya olai tela masup, baing disok mala dila Xaxagania Olip. ");
INSERT INTO met_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu baladi ba, “Bagula ang longgalo ayunga nga, namua na Urana haruangana li wa Xuania: “ ‘Bagula ngataha sipsipdi lipuxiding wasanganama mari, baing sipsipdi bagula dahalukiana.’ ");
INSERT INTO met_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ne kimuya mana ngamesa muli, bagula ngamuga mala nang titia Galili.” ");
INSERT INTO met_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita harua na ba, “Heku nabu lipu longgalo diyungaung, nga bagula tegu.” ");
INSERT INTO met_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Baing Yesu haxuya ba, “Maxung sibuna ngabalaung ba, hatata yambong, muga mana muxaxua xatu luwa, bagula uhatiam manga bunging tuwa.” ");
INSERT INTO met_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ne Pita haxi sibuna ba, “Heku nabu ngamati ranguaung, nga bagula ngahatiam maung te!” Baing ding longgalo daharua taininau. ");
INSERT INTO met_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Dila long tela duxu ba Getsemani, baing Yesu harua na lipuxindi dinaxu mana ba, “Arung mua la li, ngabo ba ngasabu to.” ");
INSERT INTO met_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Xap Pita, Yems, Yon dingtung mala xauna. Baing ayangang sibuna xaung gamona mauxang sibuna. ");
INSERT INTO met_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Baing harua na dingtung ba, “Lugua ayangana buk, bila ngabo ba ngamatiuba. Awa mua la li, awasa xai.” ");
INSERT INTO met_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ila monga saing yungaina mari titia, sabu ba nabu daxanga tela wa, bing bunging diana ba bagula dali. ");
INSERT INTO met_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Baing sabu ba, “Mama, Tibugu! Ung sanga ba ulibu axamang longgalo. Unia xuba salakkamga li mala sangua nga. Ne heku usu mana nga murungagua, ne usu mana ung murungama.” ");
INSERT INTO met_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Baing goxoya ma rangua dingtung, bagudi dikinuyu matabu, saing harua na Pita ba, “Saimon, ukinu baru? Sanga mana uwasa xai mana auwa taininau te? ");
INSERT INTO met_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Awasa saing asabu mua, nam tubaiga xapkang. Maxuna, luimdi muruding, ne sanggaimdi haringingading te.” ");
INSERT INTO met_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Baing Yesu ila muli bu sabu bila menau. ");
INSERT INTO met_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Goxoya ma, baing bagu muli dikinu matabu, namua na maxading dikinu. Ne daxabia te daharua baru na. ");
INSERT INTO met_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bunging tuwa goxoya ma, harua nadi ba, “Angtung gakinuyu xaung ayaguauyu? Sanga ba! Xaidap maxanoa ma ba. Abagu, disina Lipua Ma Rangua Urana mala lipu kubolu dianamdi rimadingiauba. ");
INSERT INTO met_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Angtung gamesa, talauba! Abagu, lipua bo ba sina nga mala nadi, ina sok lo!” ");
INSERT INTO met_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu haruauyu, baing hata sibuna li Yudas, ina mana Lipu 12 tela, sok. Gabu buranga dima, dirai waxang sabangadi xaung xaidi. Lipu hananiangamdi yanamidingdi, lipu hanaunaunga tubatubainganamdi xaung lipu haringindi, ding disoxidi ma. ");
INSERT INTO met_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas bo ba sina Yesu nadi, muga hamaringia hatangangua tela ranguadi, harua nadi ba, “Lipua ba ngalibu, lipua naga. Atuxu saing axai mala lia mana lipu wasangamdi.” ");
INSERT INTO met_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tauna, Yudas ila taxa rangua Yesu sap, saing harua ba, “Lipu Tubatubaingama!” saing libu. ");
INSERT INTO met_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Baing dita rimadingdi mana Yesu saing dituxu haringina. ");
INSERT INTO met_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ne lipu tela li haxek, xai waxanging sabanga masok, ting mana lipu hananiangam mugamugangama lipuxing oxata olanggama, saing taxiti tanganglianoa. ");
INSERT INTO met_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Baing Yesu harua nadi ba, “Ai, ang gama xaung waxang sabangadi xaung xaidi bu atuxu agoxi nga, bila nga lipu hanaunggam tela, bo? ");
INSERT INTO met_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Xaidapxaidapka lo ngawa ranguang, ngatubatuba maluxu Urana Numang yabania, ning atuxu nga te. Ne alali sok bu Urana Xuanoa aningona.” ");
INSERT INTO met_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Baing lipuxindi dinaxu mana disauya saing diluki mala. ");
INSERT INTO met_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Gananung tela, sau imang usamang tela ing ganina, ina su mana Yesu mala. Lipudi dituba ba dituxu, ");
INSERT INTO met_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ne luki sangua imanginoa, saing luki mulang mala. ");
INSERT INTO met_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Baing daxai Yesu mala lipu hananiangam mugamugangama numania. La ba, lipu hananiangamdi yanamidingdi, lipu haringindi xaung lipu hanaunaunga tubatubainganamdi, ding digugunia ma. ");
INSERT INTO met_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita su mana mala, ne wa hasoya monga. Su mana mala laing luxu lipu hananiangam mugamugangama numang rubinia. Baing rung mua rangua lipu wasangamdi saing biding yap. ");
INSERT INTO met_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Lipu hananiangamdi yanamidingdi digabu lipu haringing longgalo duwa Yuda Kaunsilidi, ding disai haruanga tela bu dung Yesu mati mana, ning ding sanga te. ");
INSERT INTO met_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Lipu xumana dima dilanglangua mana, ne naxuyangadingdi maxang taininau te. ");
INSERT INTO met_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ne lipu teladi dimesa disu haruanga languangam mala rangua Yesu bila li, daharua ba, ");
INSERT INTO met_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Am galungu harua ba, ‘Bagula ngaxui Urana Numana li mari, lipudi ditongtongia, baing kimuya mana xaidap tuwa, bagula ngatongtongia tela, lipudi ditongtongia te.’ ” ");
INSERT INTO met_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ning haruangadinga maxang taininau te xauna. ");
INSERT INTO met_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Baing lipu hananiangam mugamugangama mesa, li liwe lipudi maxadingia, saing xusunga Yesu ba, “Haxuyangam te? Baru mana haruanga li disu maung?” ");
INSERT INTO met_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ning Yesu mumguti, haxuya haruanga tela te. Baing lipu hananiangam mugamugangama xusunga muli ba, “Ung ba Urana Lipuxing Mogunganama? Ung Urana Garanoa, Urana taiti yanoa ba?” ");
INSERT INTO met_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Baing Yesu harua ba, “Nga baing. Baing bagula abagu Lipua Ma Rangua Urana rung Urana Haringinga rimang rimamo rubinia, xaung bagula abagu ma xaung mugap long xaiyamdi.” ");
INSERT INTO met_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Lipu hananiangam mugamugangama sing ina imangindi bu hatanga ba gamonoa doa, saing harua ba, “Heku tasaiʼm lipu tela muli su haruangua na! ");
INSERT INTO met_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ang galungu masup, harungia Urana! Ang gahatum baru?” Baing dahau hatumingua saing daharua ba lipu diana, bing mati mana kubolunoa. ");
INSERT INTO met_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Baing teladi dungguti daxanubia. Disaku maxandi, ditaha rimadingia, saing daharua ba, “Uhatanga ba ung Urana lipuxing suxunguxunguama! Ubaxanga ba gaxarea tahaung!” Baing lipu wasangamdi daxap mala, ditaha. ");
INSERT INTO met_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita wauyu hawa, maluxu numa gamgamingania, baing haing haulingam tela mana lipu hananiangam mugamugangama haxa mala. ");
INSERT INTO met_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Bungina bagu Pita biding yap, bagu haringina mana, saing harua ba, “Ung xauna, uwa rangua Yesu, lipu Nasaretiama.” ");
INSERT INTO met_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ne hatiam saing harua ba, “Ne ngaxabia baraxinta uharua mana te.” Baing Pita ila numa xaluxing yabania. ");
INSERT INTO met_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Haing haulingamga ba bagu wa la ba, baing harua na lipudi dili mauli ba, “Lipua li, dingia tela.” ");
INSERT INTO met_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ne hatiam muli. Mena, lipudi dili mauli la ba daharua na Pita ba, “Maxung sibuna, ung dingia tela, namua na ung Galili tela.” ");
INSERT INTO met_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ne Pita harua haringing sibunauba. Harua ba nabu langua bing sangau, wa haruangia rangua Urana, saing harua ba, “Maxung sibuna, Urana maxania, ngaxabia lipua aharua mana ba te.” ");
INSERT INTO met_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Baing ina naga, hata sibuna li, muxaxua xatu muli. Baing Pita hatumia muli haruangua menau Yesu harua na ba, “Muga mana muxaxua xatu luwa, bagula uhatiam manga bunging tuwa.” Binabu Pita tang haringing sibuna. ");
INSERT INTO met_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Buraraging sibuna baing lipu hananiangamdi yanamidingdi digabu lipu haringindi, lipu hanaunaunga tubatubainganamdi, Sanhidron masup, ding digugunia dahangixaya ba diria baru. Baing ina naga, digoxi Yesu, daxai mala, saing dita Pailat rimania. ");
INSERT INTO met_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Baing Pailat xusunga ba, “Ung ba xaitamoxi Yuda dingia?” Baing Yesu haxuya na ba, “Wane, bila ung guharua ba.” ");
INSERT INTO met_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Lipu hananiangamdi yanamidingdi disu haruanga xumana mana. ");
INSERT INTO met_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Baing Pailat xusunga muli ba, “Uhaxuya haruanga tela te baru? Bola ulungu haruanga xumana disudi maung, bo?” ");
INSERT INTO met_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ning Yesu haxuya haruanga tela te, binabu Pailat hixi mana. ");
INSERT INTO met_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ne mana Taunga Dalingam niani taining tainina, Pailat kubolunoa ba ina yunga lipu salak yabanam tela gaxarea gaxarea haing lup duxusunga mana. ");
INSERT INTO met_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mana bungina baguba, lipu tela yanoa Barabas rung salak yabania rangua lipuadi diti haungingua rangua gabman, dung lipudi mati. ");
INSERT INTO met_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tauna, burangua dila haxek rangua Pailat, dungguti duxusunga ba libu kubolunoa bila libu ba. ");
INSERT INTO met_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Baing Pailat xusungadi ba, “Ang gabo ba ngayunga xaitamoxi Yuda dingia nang?” ");
INSERT INTO met_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Xusunga bila ba, namua na xabiau lipu hananiangamdi yanamidingdi gamodingdi didoa mana Yesu, binabu dita rimania. ");
INSERT INTO met_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ne lipu hananiangamdi yanamidingdi diyumyum burangua bu dahaxi mana Pailat yunga Barabas nadi, ne Yesu tegu. ");
INSERT INTO met_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Baing Pailat xusungadi ba, “Ne ngaria baru mana lipua auxu ba xaitamoxi Yuda dingia?” ");
INSERT INTO met_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Duwagi ba, “Ung mati xai balingamia!” ");
INSERT INTO met_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Baing Pailat xusungadi ba, “Baruta? Libu kubolu diang baruamta?” Ne duwagiwagi haringina ba, “Ung mati xai balingamia!” ");
INSERT INTO met_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Baing ina naga, Pailat bo ba libu burangua diyaha, binabu yunga Barabas nadi. Ne tabina lipuxing haungingamdi ba digusi Yesu. Sup, baing ta Yesu lipu haungingamdi rimadingia bu dung mati xai balingamia. ");
INSERT INTO met_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Lipu haungingamdi daxai Yesu mala diluxu gabman numania (duxu ba Piretoriam) saing duwagi guguniangading haungingam longgalo dima. ");
INSERT INTO met_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Disausau imang maxaxaya sikokop tela mana, saking ditaling waxu ruxunam bila xaitamoxi muxubinoa, saing dita toxonia. ");
INSERT INTO met_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Baing dungguti duwagi mana ba, “Uwa bungingbunginalo, xaitamoxi Yuda dingia!” ");
INSERT INTO met_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Daxap nunua, ditahataha toxonia, digipgip saing digung kiding tuxundi bila duwa hawa mana. ");
INSERT INTO met_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Didaudau laing sup, baing dunia imang sikokop sangua, saing disausau ing sibung imangindi mana muli. Saking daxai mala bu dung mati xai balingamia. ");
INSERT INTO met_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Lipu Sairinam tela, yanoa Saimon, Aleksanda Rupas tibuding, ina sok sangua umangadi ma saing haxa mala. Baing daxap dilibu xoxi Yesu xaing balingama. ");
INSERT INTO met_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Daxap Yesu mala longga duxu ba Golgota (namuxinoa ba Toxotaxu Guang Yabana). ");
INSERT INTO met_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Baing dituba ba disina wain tela daxaning baxi tela duxu ba mer mana, ning nung te. ");
INSERT INTO met_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Baing digoxi xai balingamia saing diti mahaing. Lipu haungingamdi dahali halinga tela bu dibagu gaxarea bagula daxap imangindi. ");
INSERT INTO met_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mana 9:00 buraragina digoxi Yesu xai balingamia. ");
INSERT INTO met_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mana xai tela dibung haruanga disu na mana ba: Xaitamoxi Yuda Dingia. ");
INSERT INTO met_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Digoxi lipu hanaunggam luwa rangua, tela wa rimamo, tela wa xong. ");
INSERT INTO met_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Lipudi dahaxa dahadalia daharua diana na, ditingting toxodingdi mala saing daharua ba, “Ha! Uharua bagula uxui Urana Numanoa mari, saing utongtongia muli mana xaidap tuwa, ");
INSERT INTO met_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","bing ung guhauliung! Uri ma sangua xai balingamga ba!” ");
INSERT INTO met_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Lipu hananiangamdi yanamidingdi digabu lipu hanaunaunga tubatubainganamdi xauna, ding didaudau liwe mading bila ba. Daharua ba, “Hauli lipu teladi ba, ne sanga ba hauli ing sibuna te! ");
INSERT INTO met_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nabu Urana Lipuxing Mogunganama, Xaitamoxi Isreliama, bing ri ma sangua xai balingamga bauba bu am gabagu am gahatum haringina.” Lipu luwa digoxi dingtang rangua, tang didaudau xauna. ");
INSERT INTO met_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mana xaidap lia labianoa kaukau titia masup laing bungbung. ");
INSERT INTO met_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mana 3:00 bungbung Yesu wagi sabanga ba, “Eli, Eli, lema sabaktani?” namuxina ba, “Urana ngayua, Urana ngayua, baruta uyunga nga?” ");
INSERT INTO met_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Lipu teladi dili la ba dilungu alaba, baing daharua ba, “Bagu wagi mana Elaitsa.” ");
INSERT INTO met_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Lipu tela luki mala, tai garumu tela maluxuʼm wain mabiana laing baxagi. Sup, baing su xai tela mana saing iti mahaing, sina na Yesu ba nung. Baing harua ba, “Taragu to! Tabagu nabu Elaitsa ma bu xap mari to.” ");
INSERT INTO met_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Baing Yesu wagi sabanga saing mati. ");
INSERT INTO met_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Imang sabangga silola mua maluxu Urana Numania singina hataing luwa etua laing sok ha lo. ");
INSERT INTO met_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Baing lipu haungingamdi yanamidinga, ina li mua Yesu maxania. Bungina bagu mati baru, harua ba, “Maxung sibuna, lipua li Urana Garanoa naga.” ");
INSERT INTO met_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Haing teladi dili hasoya monga, dibagu mua. Maria Magdalam rangua Maria, Yems kaxukana xaung Yoses bauding, xaung Salome dingtung duwa maluxu ranguadi. ");
INSERT INTO met_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bungina Yesu wa titia Galili, hainggadi bagudi li dinaxu mana saing dahauli. Haing xumana bungina digabu Yesu dahaing mala Yerusalem, ding xauna duwa la ba. ");
INSERT INTO met_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Axadi bagudi li disok mana Paraide, Yudadi duxu xaidapka ba Xaidap Xauxaungam, ma muga mana Xaidap Yaguangam. Yambongguba, binabu ");
INSERT INTO met_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yosep Erimateam, Yuda Kaunsiliding tela, haringiaina saing ila rangua Pailat, xusunga mana Yesu sangganoa. Yosep yanoa xai lipudi maxadingia, ragu xauna mana Urana Yonggaxinoa sok. ");
INSERT INTO met_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat hixi mana saing hatum ba, “Maxundi, mati lo?” Baing wagi lipu haungingamdi yanamidinga ma saing xusunga ba, “Yesu mati lo?” ");
INSERT INTO met_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bungina Pailat lungu lipu haungingamdi yanamidinga baxanga ba Yesu mati ba, bing nai mana Yosep xap Yesu sangganoa mala. ");
INSERT INTO met_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Binabu Yosep gim imang xai sibung tela, saing xap Yesu sangganoa mari, saku imangia saing ta maluxu mana guha gobagoba tela disaba sianga maluxu mala. Baing ditutuxuya siang sabanga ma rangguti guha gobagoba xuania. ");
INSERT INTO met_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdalam, Maria Yoses bauna dingtang dibagu longga dita sangganoa ba. ");
INSERT INTO met_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Xaidap Yaguangama ila sup, yambongguba baing Maria Magdalam xaung Maria, Yems bauna, xaung Salome dingtung digim guxenga baxiam saminam bu dila disabaxaya Yesu sangganoa mana. ");
INSERT INTO met_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mana xaidap mugamugangam mana sande baguba, buraraging sibuna, xaidaba haingguba, dahaxa mala guhia gobagobia. ");
INSERT INTO met_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Baing duxusunga ding ba, “Gaxarea bagula tutuxuya sianga mala sangua guha xuanoa gobagobia makira?” ");
INSERT INTO met_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ne bungina dibagu mala, dibagu siang sabangga ba ditutuxuya mala ba. ");
INSERT INTO met_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bungina diluxu guhia gobagobia, dibagu gananung tela sau imang usamang maxaxaya, rung rubina rimamo saing dihixi mana. ");
INSERT INTO met_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Baing harua nadi ba, “Ahixi manau tai. Ang gasai mana Yesu Nasaretiam, lipua digoxi xai balingamia ba. Mesa muli ba! Wa la li te. Abagu longga dita sangganoa matabu mana ba. ");
INSERT INTO met_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Alauba, abala lipuxindi dinaxu mana digabu Pita ba, ‘Muga nang mala Galili. Bagula abagu la ba, bila balang ba.’ ” ");
INSERT INTO met_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Baing disok saing diluki mala sangua guha gobagobia, ne dihixi mana xaung dimaxuwa dilulu. Baing dibaxanga na lipu tela te, namua na dimaxuwa. ");
INSERT INTO met_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Bungina Yesu mesa muli buraraging sibuna xaidap mugamugangam mana Sande baguba, owa masok muga rangua Maria Magdalam, haingga waleu Yesu suka xaunga 7 mana ba. ");
INSERT INTO met_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria ila saing baxanga na lipuadi dahaxa mauli rangua Yesu ba, ding dusinga saing ditang mua. ");
INSERT INTO met_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bungina dilungu Yesu mesa muli xaung Maria bagu, dahatum haringin te. ");
INSERT INTO met_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kimuya, lipu luwadi dinaxu mana disok sangua long sabangia saing dahaxa mala. Baing Yesu owa masok muli ranguadi, ne sok xan tela. ");
INSERT INTO met_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Digoxoya mala saing dibaxanga na riading teladi dinaxu mana, ne dahatum haringin te. ");
INSERT INTO met_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kimuya, bungina Lipu 11 dirung daxang mua, Yesu owa masok ranguadi. Gamiadi namua na dahatum haringin te xaung hatumingading diriba ding mana haruanga lipuadi dibagu bungina mesa muli dibaxanga nadi ba. ");
INSERT INTO met_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Baladi ba, “Ala mana titi longgalo, abaxanga ulek xaiyua na lipu longgalo. ");
INSERT INTO met_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Lipu gaxarea dahatum haringina xaung daxap langa bing bagula Urana xapdi muli, ne lipu gaxarea dahatum haringin te bagula duwa haruangia saing dahanggalang. ");
INSERT INTO met_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Baing lipu gaxarea dahatum haringina bagula dilibu axamang haringindi bila li: Mana yagua bagula disuka xaungadi, bagula daharua mana xuaxua teladi daxabiadi te, ");
INSERT INTO met_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","nabu dituxu moxadi kimbo dinung lang diana ung lipudi mati, bing axadi bagudi li sanga ba dahanggalangiadi te, tegu. Baing bagula dita rimadingdi mana lipu busingamdi, bing disok xai muli.” ");
INSERT INTO met_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Toxoratamona Yesu baxanga nadi laing sup, baing Urana xap mahaing long xaiya saing rung mana Urana rimang rimamo rubinia. ");
INSERT INTO met_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Baing lipudi dinaxu mana dila dibaxanga mana titi longgalo. Baing Toxoratamona haulidi mana oxatua, saing libu axamang haringindi disok bu daharingia haruangadinga. ");
INSERT INTO met_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Lipu sabanga Tiopalas: Lipu xumana dituba rimadingdi ba dibung mari naxuyanga mana axadi Urana libudi liwe mam. ");
INSERT INTO met_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Naxuyangadi ba am gaxap rangua lipuadi dibagu axamandi muga sibuna maxadingia, ding lipu Urana Xuanoa baxanganganamdi. Dinaxuya naxuya nam saing am galungu ba. ");
INSERT INTO met_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Binabu, ngahatum ba xai mana ngabung naxuyanga ba mari naung, bu nganaxuya maringina mana axadi disok ba. Oxatua li ngatuxu waleu ma hatata, nga sibugu ngabagu rangrang mana naxuyangadingdi, ngaxusunga xusungadi mana namuxing longgalo bu ngaxabia rangrang. ");
INSERT INTO met_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ngalibu bila ba bu utiti uxabia rangrang ba axadi lipudi ditubatubaung mana, bing maxung sibuna. ");
INSERT INTO met_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mana bungina Herot, xaitamoxi mana titia Yudia, baing lipu hananiangam tela wa, yanoa Sekaraya. Abitsa bakbaging hananiangam tela. Haininoa Elisabet tang mugangadinga Aron. ");
INSERT INTO met_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tang dimaring Urana maxania, disu maringing sibuna mana Toxoratamona hanaunaungang longgalo. ");
INSERT INTO met_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ning garading te, namua na Elisabet wa xuhi, saing tang nianiding xumana. ");
INSERT INTO met_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Xaidap tela Sekaraya gabu bakbagindi dituxu hananianga oxatanoa Urana maxania. ");
INSERT INTO met_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Disu mana kuboludinga, baing dahali halinga tela bu Urana hatanga ba lipu gaxarea bagula luxu Toxoratamona Numang lunia bu tau bunuxuyang saminam, baing dimogu Sekaraya. ");
INSERT INTO met_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Baing xaidap maxanoa mana ditau bunuxuyang saminam ma, saing luxuba. Bungina luxu baing buranga digugunia mua sabasabia, disabu na Urana. ");
INSERT INTO met_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Disabu baing Toxoratamona uleginam tela owa masok mana Sekaraya, li mana kabukabu bunuxuyang saminam hananiangam rubina rimamo. ");
INSERT INTO met_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Baing Sekaraya bagu, saing maxuwangua xap saing lulu. ");
INSERT INTO met_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ning uleginama harua na ba, “Sekaraya, labu umaxuwau tai! Sabungama Urana lungu ba. Hainima Elisabet bagula hayau gara lup tela naung, bing usina yaya Yon na. ");
INSERT INTO met_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Bagula gamoma yaha sabanga sibuna mana. Lipu xumana bagula gamodingdi diyaha bungina gara ba sok, ");
INSERT INTO met_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","namua na bagula xap yaya sabanga Toxoratamona maxania. Labu nung wain kimbo lang haringing telau tai, bu hatanga ba Urana inia, saing bungina wa bauna gamoniauyu baing bagula baxagi mana Urana Aningonoa. ");
INSERT INTO met_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Baing bagula xugia Isrel xumana digoxoya ma rangua Toxoratamona, Urana dingia. ");
INSERT INTO met_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Baing Urana Aningonoa bagula hauli ba baxanga haruanga haringinam, bila Elaitsa waleu ba. Bagula muga mana Toxoratamona bu libu tibuding muruding sibuna mana garadingdi, xaung libu lipu kubolu dianamdi daxap hatuminga xai rangua lipu maringindi. Baing bagula libu bila ba bu xauxau lipudi mana bungina Toxoratamona ma.” ");
INSERT INTO met_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekaraya harua na uleginama ba, “Ai, alali sanga te! Nga duanga, saing hainigua nianindi xumana baing. Binabu bagula ngahatum haringina mana haruangama baru?” ");
INSERT INTO met_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Baing uleginama haxuya ba, “Nga Gebirel. Ngali mua Urana maxania, saing soxi nga ba ngaharua naung xaung ngabaxanga ulek xaiya li naung. ");
INSERT INTO met_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ning bagu uhatum haringina mana haruangagua te, binabu suxunguma bagula mauxana, saing sanga ba uharua te laing xaidapka haruangagua sok ba. Bagula sok maxuna mana xaidabinoa.” ");
INSERT INTO met_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Baing buranga diragu mana Sekaraya mua sabasabiauyu, dahatum xumana ba baruta wa maxaxaya Urana Numania. ");
INSERT INTO met_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bungina sok ma, bing sanga ba harua nadi te. Baing ina naga, hatanga babu rimania ing ganina, binabu daxabia ba bagu axamang maxang tela maluxu Urana Numania. ");
INSERT INTO met_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Bungina xaidabing oxatam disup, baing goxoya mala numia. ");
INSERT INTO met_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kinu rangua haininoa Elisabet. Xaidap teladi disup, baing Elisabet gamona. Baing Elisabet wa hisangia sobak luwadi luwadi hiliadinga. ");
INSERT INTO met_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elisabet harua naina ba, “Toxoratamona hauli nga baing. Mana bungina baguli libu xai manga, saing hitixiya memeyagua sangua lipudi maxadingdi.” ");
INSERT INTO met_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet gamona sobak 6 baing Urana soxi uleginama Gebirel mala long tela duxu ba Nasaret wa titia Galili. ");
INSERT INTO met_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Soxi mala rangua haing nanung tela, ina dahau gabisia ba yau lipu tela, yanoa Yosep, Xaitamoxi Debit bakbaging tela. Haing nanuna ba yanoa Maria. ");
INSERT INTO met_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Uleginama sok mana saing harua ba, “Xaidap xai. Toxoratamona wa ranguaung. Libu xai maung baing!” ");
INSERT INTO met_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria lungu haruanganoa ba, baing hatum xumana mana ba baru namuxinta. ");
INSERT INTO met_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ne uleginama harua na ba, “Maria, Urana yaha sibuna maung, labu umaxuwau tai. ");
INSERT INTO met_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Baing ina naga, bagula gamom saing uhayau gara lup tela, bing uxu yanoa ba Yesu. ");
INSERT INTO met_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ina bagula xap yaya sabanga saing bagula duxu ba Urana Eta Loam Sibuna Garanoa. Toxoratamona Urana bagula sina muganganoa Xaitamoxi Debit yonggaxinoa na. ");
INSERT INTO met_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Baing bagula wa xaitamoxi mana Yudadi, Yekop bakbagindi, bungingbunginalo. Yonggaxinoa sanga ba sup te.” ");
INSERT INTO met_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Baing Maria xusunga uleginama ba, “Alaba bagula sok baru, namua na ngakinu rangua lipu tela te?” ");
INSERT INTO met_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Baing uleginama haxuya ba, “Urana Aningonoa bagula ri ma ranguaung, baing Urana Eta Loam Sibuna haringinganoa bagula kaung. Binabu, gara wa gamomia bagula duxu ba lipua Urana mogu naina xaung Urana Garanoa. ");
INSERT INTO met_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Bagu bakbagima Elisabet wa xanronggi, ne bagula hayau gara tela! Ina duxu ba xuhiana ba, ne gamona mana sobak 6. ");
INSERT INTO met_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Uhixi manau tai, namua na Urana sanga ba libu axamang longgalo.” ");
INSERT INTO met_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Baing Maria haxuya ba, “Bagu nga Toxoratamona lipuxing oxatama. Binabu ina libu manga bila uharua ba.” Saking uleginama yunga saing ila. ");
INSERT INTO met_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ila sup baing Maria xauxau, ila sap mala long tela wa titia Yudia wa etuaʼm bimbidi. ");
INSERT INTO met_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Haxa mala laing sup, baing luxu Sekaraya numania saing harua xaidap xai na Elisabet. ");
INSERT INTO met_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Bungina Elisabet lungu Maria baing ina naga, Elisabet garang kambagina wa gamonia ba xukxugia, saing Urana Aningonoa luxu mana Elisabet bu baxagi mana. ");
INSERT INTO met_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Wagi sabanga ba, “Urana libu xai sibuna maung mana haing longgalo, saing libu xai sibuna mana garama bagula uhayau baing! ");
INSERT INTO met_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ne uma rangua nga baru? Nga haing olang. Ung bagula usok Toxoratamona ngayua bauna! ");
INSERT INTO met_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ngaxabia alaba namua na hata sibuna li waxumtuanoa ri mana tangaguliandi, baing gara wa gamogia xukxugia namua na yaha sibuna. ");
INSERT INTO met_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Urana yaha maung, namua na haruanga ba Toxoratamona balaung mana ba, uhatum haringina bagula sok baing!” ");
INSERT INTO met_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Baing Maria harua ba: “O, lugua iti Toxoratamona yanoa ");
INSERT INTO met_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","saing aningogua yaha sibuna mana Urana, Lipuxigu Xabingama Muli, ");
INSERT INTO met_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","namua na hatumia nga, nga haing olang, lipuxing oxatam ing ganina. Bagu hatata saing ila, bagula lipu longgalo daharua ba, ‘Urana yaha maung’, ");
INSERT INTO met_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","namua na Ing Haringing Sibuna libu axamang sabangadi manga, yanoa ing ganina maringing sibuna. ");
INSERT INTO met_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Usinganganoa ila rangua lipu gaxarea duwa hawa mana, lipu hatatamdi ila laing kimuamdi. ");
INSERT INTO met_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Libu oxata haringina rimania, suka lipudi diti ding ludingia mala hataing hataina. ");
INSERT INTO met_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tatua xaitamoxi haringindi, ne iti lipu olangdi. ");
INSERT INTO met_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Sina axamang xaidi na lipu gaxarea gesagiding bu dibaxagi, ne sina axamang tela na lipu xalaxalamdi te. ");
INSERT INTO met_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Hau haruangua waleu ba bungingbunginalo usinga mugangaroa Ebraham xaung bakbaginoa disok kimu. Hatumia muli haruanganoa, binabu hatata hauli Isrel lipuxing oxatamdi.” ");
INSERT INTO met_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria wa rangua Elisabet laing bila sobak tuwa disup ba, baing goxoya mala yabania. ");
INSERT INTO met_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Baing ina naga, bungina gara ruha Elisabet, baing hayau gara lup tela. ");
INSERT INTO met_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yabanamdi xaung bakbagindi dilungu Toxoratamona hatanga usinganga sabanga na, binabu digabu diyaha ranguauba. ");
INSERT INTO met_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Xaidabing 8 sokkuba, baing dima ba duxuxu gara ba sangganoa, dibo ba disina tibuna Sekaraya yanoa na, ");
INSERT INTO met_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ning bauna harua ba, “Tegu! Yanoa bagula tauxu ba Yon.” ");
INSERT INTO met_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Dibala ba, “Ai, bakbagim tela yanoa bila ba te.” ");
INSERT INTO met_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Baing ina naga, dahatanga babudi rimadingia na tibuna, bu daxabia ba ina muruna mana baru yanta. ");
INSERT INTO met_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Xusunga mana xailong buningam tela, saing bung, “Yanoa ba Yon.” Baing dihixi mana. ");
INSERT INTO met_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Hata sibuna li suxungunoa xaxaina muli, saing mananoa bisa, baing haruauba, iti Urana yanoa. ");
INSERT INTO met_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Baing maxuwangua xap yabanam longgalo, saing naxuyangua ila mana long longgalo duwa titia Yudia duwa etuaʼm bimbidi. ");
INSERT INTO met_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ding longgalo dilungu naxuyanga ba dahatumhatum mana, saing duxusunga ding ba, “Gara ba bagula sok bila lipua na bila baru?” Daharua bila ba namua na Toxoratamona haringinganoa wa rangua. ");
INSERT INTO met_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tibuna Sekaraya baxagi mana Urana Aningonoa saing xap Urana suxungunoa, saing baxanga muga mana axamang teladi bagula disok kimuya ba: ");
INSERT INTO met_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Taiti Toxoratamona, Urana Isreliam, yanoa, namua na ri ma saing xap kira lipuxindi muli sangua bixuaradi rimadingia ba. ");
INSERT INTO met_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Liwe mana lipuxing oxatama Xaitamoxi Debit bakbaginoa ba, rang lipu haringing tela mali bu xap kira muli. ");
INSERT INTO met_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Waleu sibuna mana lipuxing suxunguxunguamdi mogudi naina, ina harua ba, ");
INSERT INTO met_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","bagula xap kira muli sangua bixuaradi xaung lipudi hauxading sibuna makira rimadingia, ");
INSERT INTO met_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","bu hatanga usingangua na mugangaradi, saing hatumia muli ba hau haruangang maringina, ");
INSERT INTO met_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","haruanga maxunamga ba harua maxuna na mugangaroa Ebraham ba: ");
INSERT INTO met_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","bagula xap kira muli sangua bixuaradi rimadingia, baing libu kira hatumingara dimaxuwa te bu tatuxu oxatanoa, ");
INSERT INTO met_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","bagula libu kira tawa iniadi sibuna, saing hauli kira ba talibu kubolu maringina maxania mala mana walingara longgalo. ");
INSERT INTO met_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Baing ung ba, garagua, bagula duxung ba, Urana Eta Loam Sibuna lipuxing suxunguxunguama, namua na bagula umuga mana Toxoratamona bu uxauxau daxangua mana, ");
INSERT INTO met_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","bu sina xabianga mana xabinga muli na lipuxindi, bungina Urana yunga kuboluding diandi, ");
INSERT INTO met_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","namua na Urana kiria usinga sibuna lunia, baing bagula ma rangua kira bila xaidaba haing, ");
INSERT INTO met_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","bu saxaxangia lipuadi duwa labiania xaung lipuadi matia kaudi, bu ta kira gamogamu mosiam daxangania.” ");
INSERT INTO met_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Baing ina naga, gara ba tubu saing aningong hatumingana xaxaina. Ila wa long xoliania laing bungina tuxu oxatanoa Isreldi maxadingia. ");
INSERT INTO met_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Bila bungina Elisabet hayau Yon, Romdi yanamidinga Sisa Augastas tabina lipu longgalo duwa hawa mana Romdi ba, bagula daxap yadingdi bu daxap takis manadi. ");
INSERT INTO met_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Alali bunging mugamugangam dititi lipudi bungina Kwairinias wa gabana mana probinsia Siria.) ");
INSERT INTO met_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Baing ina naga, lipu longgalo dila mana mugangadingdi yabadingdi bu dibung yadingdi mari. ");
INSERT INTO met_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Binabu Yosep xauna yunga titia Galili mana longga Nasaret, goxoya mahaing titia Yudia long tela duxu ba Betlehem, Xaitamoxi Debit yabania, namua na ina Debit sibing tela. ");
INSERT INTO met_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Haing mala xaung Maria bu tang dita yadingdi. Tang dila namua na dahau gabisia manadi. Ne Maria gamona. ");
INSERT INTO met_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Bungina disok mana longga ba, lobu numana ganangan te, binabu duwa bulmakau numania. Gara ruha Maria la ba, saing hayau garang matuaua, gara ba lup. Kaukau mana imang hataindi saing tuxuyaʼm tabu asaxadi minadingia. ");
INSERT INTO met_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tauna, mana yambongga baguba, lipu sipsip wasanganam teladi duwa singia, duwasa mana sipsibiding bakbak sabanga raxangia. ");
INSERT INTO met_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Urana uleginam tela owa masok manadi, baing Toxoratamona ralanoa saxaxangia taxiyadi, saing dimaxuwa haringing sibuna. ");
INSERT INTO met_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ning uleginama baladi ba, “Labu amaxuwau tai! Bagu ngaxap ulek xaiyua ma ranguang. Haruanga li bagula lipu longgalo gamodingdi diyaha sibuna mana. ");
INSERT INTO met_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mana xaidapka baguli, ala Xaitamoxi Debit yabania, haing tela hayau Lipuxim Xabingama Muli. Ina Kristo, Toxoratamona. ");
INSERT INTO met_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Hatanganganoa bing: Bagula abagu gara kambaging tela dikaukau mana imang hataindi saing kinuʼm tabu asaxadi minadingia.” ");
INSERT INTO met_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Hata sibuna li uleginam bakbak sabanga dowa masok rangua uleginama, diti Urana yanoa, daharua ba, ");
INSERT INTO met_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Taiti Urana yanoa eta lo sibuna, saing hawa titia li sina gamogamu mosiu na lipu longgalo yaha manadi ba.” ");
INSERT INTO met_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Daharua laing sup, diyungadi dila long xaiya, baing lipu sipsip wasanganamdi daharua nading ba, “Talauba. Tala hata Betlehem, tabagu baraxinta sok, axa Toxoratamona bala kira mana ba.” ");
INSERT INTO met_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Binabu dila sap saing dibagu Yosep, Maria tang digabu gara kambagina, ina kinuʼm tabu asaxadi minadingia. ");
INSERT INTO met_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Dibagu laing sup, saing dinaxuya mana uleginama harua baru mana gara ba, ");
INSERT INTO met_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","baing ding longgalo dilungu ba, dihixi mana naxuyangadinga. ");
INSERT INTO met_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ne Maria ba, ta haruangadi ba hatumingania saing hatumiadi mua. ");
INSERT INTO met_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Lipu sipsip wasanganamdi digoxoya mala, diti Urana yanoa mana axadi dibagudi saing dilungudi ba, namua na disok taxa bila uleginama baladi ba. ");
INSERT INTO met_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mana xaidabing 8 duxuxu sangganoa, disina yaya Yesu na, yaya ba uleginama bala Maria muga bungina gamona mana teguyu. ");
INSERT INTO met_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Xaidap sigixinganama bila hanaunaunga mana Moses harua ba sokkuba. Binabu Yosep Maria tang daxap Yesu mala long sabangga Yerusalem bu dahatanga na Toxoratamona. ");
INSERT INTO met_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Dilibu bila ba namua na Toxoratamona hanaunaunganoa harua ba, “Gara lup mugamugangam longgalo bing dimogu ba Toxoratamona iniadi.”) ");
INSERT INTO met_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Xauna, ding dibo ba disina hananiangua bu disu mana Toxoratamona hanaunaunganoa, tabinadi ba dahananiaʼm axadi bagudi li: “baxaliku luwa kimbo gumak kaxukang luwa.” ");
INSERT INTO met_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Baing ina naga, lipu tela wa Yerusalem, yanoa Simion. Maring saing haxa rangua Urana. Ragu mua mana Urana xap Isreldi muli. Baing Urana Aningonoa wa rangua. ");
INSERT INTO met_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Urana Aningonoa baxanga na masup ba sanga ba mati te laing bagu Kristo to, lipua Toxoratamona mogu ba. ");
INSERT INTO met_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Urana Aningonoa xai mala Urana Numang yabania. Baing ina naga, Yesu baungtibundi daxap maluxu bu dahatanga na Urana, bila Urana hanaunaunganoa harua ba. ");
INSERT INTO met_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion sep saing iti Urana yanoa, harua ba: ");
INSERT INTO met_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Toxoratamona, bila uharua maxuna ba, hatata uyunga nga lipuxim oxatama ba ngamati mosiu. ");
INSERT INTO met_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Namua na nga sibugu maxagudi dibagu xabinga muli ma ranguaung, ");
INSERT INTO met_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","alaba uxauxau numanuma longgalo maxadingia. ");
INSERT INTO met_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ina bagula wa bila nagung ba saxung daxangama mana Yuda Teguamdi, saing bagula libu ung lipuxim Isreldi daxap yaya sabanga.” ");
INSERT INTO met_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Gara baungtibundi dihixi mana haruangua Simion harua mana ba. ");
INSERT INTO met_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Saking Simion baladi ba Urana bagula guxamdi, saing harua na bauna Maria ba, “Bagu gara li, Urana mogu namua mana Isrel xumana bagula xungdi mari, xumana bagula dimesa. Bagula wa bila hatanganga tela, ne bagula daharungia, ");
INSERT INTO met_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","sanga mana hatanga lipu xumana hatumingadingdi duwa gamodingia sabasabia. Baing ung ba, axamang diandi dilibudi mana bagula libu uxunumia bila waxang tela su luma.” ");
INSERT INTO met_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Baing xanronggi tela Urana lipuxing suxunguxunguama wa, yanoa Ana, Panuel garanoa, xaung Asa bakbaging tela. Wa rangua ayuana niani 7 kimuya mana diyau, ");
INSERT INTO met_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","baing ayuana mati saing wa tap laing hatata nianing 84. Sauya Urana Numanoa te, ne iti Urana yanoa xaidap yambong, saha mana angingua saing sabu mua. ");
INSERT INTO met_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simion harua laing sup, baing hata sibuna li Ana sok manadi saing harua xai sibuna na Urana, saing naxuya naxuya mana gara ba na lipu gaxarea diragu mua mana Urana ba xap Yerusalemdi muli sangua bixuadingdi rimadingia. ");
INSERT INTO met_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosep Maria tang dilibu axamang longgalo Toxoratamona hanaunaunganoa harua manadi laing sup, baing digoxoya mala titia Galili, yabadinga longga Nasaret. ");
INSERT INTO met_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Baing ina naga, gara ba tubu saing sok haringina. Baxagi mana hatuminga xai, saing Urana yaha sibuna mana. ");
INSERT INTO met_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Niani taining tainina baungtibundi dahaing mala long sabangga Yerusalem mana Taunga Dalingam. ");
INSERT INTO met_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tauna, nianing 12 baing ding dahaing mala mana Taungua, disu mana kuboludinga. ");
INSERT INTO met_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Taunga xaidabindi disup, baing baungtibundi digoxoya mala yabadingiauba. Baing gananuna Yesu wauyu Yerusalem, ning baungtibundi tang daxabia te. ");
INSERT INTO met_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Dahagaxa ba haxa mala rangua bakbagidingdi, baing dahaxa mala xaidap tela. Baing ina naga, disai mana rangua bakbagidingdi xaung riadingdiuba. ");
INSERT INTO met_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Disaisai sus, binabu digoxoya mala Yerusalem muli bu disai mana. ");
INSERT INTO met_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kimuya mana xaidap tuwa baing dibagu, wa Urana Numang yabania, rung mua rangua lipu tubatubaingamdi, lungudi saing xusunga xusungadi. ");
INSERT INTO met_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ding longgalo dilungu haruanganoa dihixi mana xabianganoa xaung haxuyangandi. ");
INSERT INTO met_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bungina baungtibundi dibagu, tang dihixi mana. Bauna harua na ba, “Garagu, baruta ulibu bila ba mamtam? Bagu tibum tam gahatum xumana, tam gasaisai maung baing!” ");
INSERT INTO met_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Xusungadi ba, “Tang gasai manga baru? Sanga ba ngawa long tela te, ne ngawa Tibugu numania ing ganina. Axabia alaba te?” ");
INSERT INTO met_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ne tang daxabia rangrang haruangang namuxina harua na dingtang te. ");
INSERT INTO met_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Baing ri mala ranguadi Nasaret saing bungingbunginalo su mana haruangadinga. Ning bauna ta axadi ba hatumingania saing tuxudi mua. ");
INSERT INTO met_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Baing Yesu tubu. Hatuminganoa xai xauna tubu. Urana yaha sibuna mana, saing lipudi diyaha xauna. ");
INSERT INTO met_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taibirias wa Romdi yanamidinga Sisa niani 15 saing Pontias Pailat wa gabana mana titia Yudia, Herot wa etua mana titia Galili, kixinginoa Pilip wa etua mana titiadi Ituria xaung Tirakonaitas, Lisanias wa etua mana titia Abalin, ");
INSERT INTO met_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","xaung Anas, Kayapas tang duwa Yudadi lipuxiding hananiangam mugamugangamdi. Baing mana bungina baguba Urana sina haruanganoa na Yon, Sekaraya garanoa, bungina wa long xoliania. ");
INSERT INTO met_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Binabu ila haxa mauli maluxuʼm titi longgalo duwa Langga Yodan singia. Baxanga baxanga na lipudi bu duxugia hatumingadingdi, saing daxap langa bu hatanga ba, saing Urana bagula yunga kuboluding diandi. ");
INSERT INTO met_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yon lipua naga Urana lipuxing suxunguxunguama Aisaya bung waleu sibuna mana bila li: “Waxutu tela wagi mua long xoliania ba, ‘Axauxau daxangua mana Toxoratamona, atongtongia daxanga maringindi mana. ");
INSERT INTO met_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Goma longgalo bagula dibaxagi mahaing, bimbi xaung xaxagang longgalo bagula diri hawa. Daxangadi doga bagula disok maringina, daxangadi xurungxurungiding bagula disok gomading. ");
INSERT INTO met_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Baing lipu titiam longgalo bagula dibagu Urana xap kira muli baru.’ ” ");
INSERT INTO met_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Buranga dima rangua Yon bu daxap langa rangua. Harua nadi ba, “Ang bila moxa diang garandi! Gaxarea balang ba aluki mala, agiti Urana ating salianoa ma yu? ");
INSERT INTO met_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kuboluim aningondi duwa bi? Muga bing alibu kubolu xai bu hatanga ba axugia hatumingaimdi. Heku aharua nam bila li: ‘Kira mugangaroa Ebraham. Binabu Urana sanga ba hanggalangia kira te.’ Namua na ngabalang ba Urana sanga ba xugia sianggadi li mala disok Ebraham bakbagindi. ");
INSERT INTO met_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Urana xauxau masup ba hanggalangiang nabu axugia kuboluim diandi te! Bila lipu tela ta galisia matabu xai namuya, bu tui mari saing ting mala yabia nabu aningon te.” ");
INSERT INTO met_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Buranga dingia teladi duxusunga ba, “Laku, am garia baru bu Urana hanggalangiam te?” ");
INSERT INTO met_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yon haxuya nadi ba, “Nabu angia tela imanging luwa bing hauli lipu gaxarea xola, saing nabu angia tela angiana bing libu kubolu taininau.” ");
INSERT INTO met_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Lipu takis xabinganam teladi dima xauna ba daxap langa. Duxusunga ba, “Lipu tubatubaingam, am garia baru bu Urana yaha mam?” ");
INSERT INTO met_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Baladi ba, “Axap sianga sanga mana gabman mogu ba axap ing ganina. Labu axap tela muliu tai.” ");
INSERT INTO met_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Baing lipu haungingam teladi duxusunga ba, “Am ba, am garia baru?” Haxuya ba, “Labu alibu lipudi dimaxuwa kimbo asu haruanga languangam nadi bu disina sianga olang nanggu tai. Ang gawa mosiu mana sianga lipuxim haringindi digimgang mana.” ");
INSERT INTO met_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lipudi diragu dibagu mua mana Urana Lipuxing Mogunganama ma. Ding longgalo duxusunga ding hatumingadingia ba bola Yon lipua naga kimbo tegu. ");
INSERT INTO met_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Binabu Yon haxuya nadi ba, “Nga ba ngasuguang mana langa. Ning lipu tela haringinganoa dali haringingagua ma yu. Sanga mana ba ngaunia xaing sanggandi te, namua na yanoa dali ngayua sibuna. Bagula suguang mana Urana Aningonoa. Ne lipu gaxarea dahatum haringina mana te, bagula taudi yabia. ");
INSERT INTO met_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Xauxau ba hata lipu xaidi xaung lipu diandi, bila lipu wit umangang oxatanamdi dihitixiya sangsangdi mana witdi. Bagula gugunia lipu xaidi numania bila lipu oxatamdi digung wit maluxu anginga numania. Ne lipu diandi, bagula taudi maluxu yap subingang teguamia bila ditau sangsangdi.” ");
INSERT INTO met_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yon tubatubadi haruanga xumana mana ulek xaiyua, bala lipudi ba duxugia kuboludinga. ");
INSERT INTO met_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ning bungina gamia Galilidi yanamidinga Herot mana xap Herodias, sabanganoa haininoa, xaung axamang diandi libudi, ");
INSERT INTO met_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","baing Herot libu kubolu hauna muli: Ta Yon salak yabania. ");
INSERT INTO met_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Muga, bungina Yon sugua lipuadi ba, Yesu xap langa xauna. Baing Yesu sabuba. Sabu mua saing long xaiya xaxaina, ");
INSERT INTO met_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","saing Urana Aningonoa ri ma mana, bagunganoa bila baxaliku. Baing waxutu tela sok ma long xaiya, harua ba, “Ung Garagu sibuna, nga murugu sibuna maung. Ngayaha sibuna maung.” ");
INSERT INTO met_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu ungguti oxatanoa bungina nianindi bila 30. Lipudi dahagaxa ba tibuna Yosep. Yosep tibuna Heli. ");
INSERT INTO met_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli tibuna Matat. Matat tibuna Libai. Libai tibuna Melki. Melki tibuna Yanai. Yanai tibuna Yosep. ");
INSERT INTO met_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosep tibuna Matatias. Matatias tibuna Amos. Amos tibuna Nahum. Nahum tibuna Esli. Esli tibuna Nagai. ");
INSERT INTO met_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai tibuna Mat. Mat tibuna Matatias. Matatias tibuna Semein. Semein tibuna Yosek. Yosek tibuna Yoda. ");
INSERT INTO met_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda tibuna Yoanan. Yoanan tibuna Resa. Resa tibuna Serubabel. Serubabel tibuna Sealtiel. Sealtiel tibuna Neri. ");
INSERT INTO met_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri tibuna Melki. Melki tibuna Adi. Adi tibuna Kosam. Kosam tibuna Elmadam. Elmadam tibuna Er. ");
INSERT INTO met_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er tibuna Yosua. Yosua tibuna Elieser. Elieser tibuna Yorim. Yorim tibuna Matat. Matat tibuna Libai. ");
INSERT INTO met_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Libai tibuna Simion. Simion tibuna Yuda. Yuda tibuna Yosep. Yosep tibuna Yonam. Yonam tibuna Eliakim. ");
INSERT INTO met_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim tibuna Melea. Melea tibuna Mena. Mena tibuna Matata. Matata tibuna Natan. Natan tibuna Debit. ");
INSERT INTO met_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Debit tibuna Yesi. Yesi tibuna Obet. Obet tibuna Boas. Boas tibuna Salmon. Salmon tibuna Nason. ");
INSERT INTO met_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason tibuna Aminadap. Aminadap tibuna Atmin. Atmin tibuna Arni. Arni tibuna Hesron. Hesron tibuna Peres. Peres tibuna Yuda. ");
INSERT INTO met_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda tibuna Yekop. Yekop tibuna Aisak. Aisak tibuna Ebraham. Ebraham tibuna Tera. Tera tibuna Naho. ");
INSERT INTO met_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naho tibuna Seruk. Seruk tibuna Reu. Reu tibuna Pelek. Pelek tibuna Eber. Eber tibuna Sela. ");
INSERT INTO met_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela tibuna Kainan. Kainan tibuna Arpaksat. Arpaksat tibuna Sem. Sem tibuna Noa. Noa tibuna Lamek. ");
INSERT INTO met_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek tibuna Metusela. Metusela tibuna Inok. Inok tibuna Yared. Yared tibuna Mahalalel. Mahalalel tibuna Kenan. ");
INSERT INTO met_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan tibuna Inos. Inos tibuna Set. Set tibuna Adam. Adam tibuna Urana. ");
INSERT INTO met_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu baxagi mana Urana Aningonoa baing yunga Langga Yodan saing goxoya malauba. Goxoya mala baing Urana Aningonoa xai mauli maluxu long xoliania. ");
INSERT INTO met_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","La ba, Satan tuba sanga mana xaidap 40. Mana xaidapkadi bagudi ba, Yesu xang axamang tela te. Laing sup, baing gesagina. ");
INSERT INTO met_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Baing Satan harua na ba, “Nabu ung Urana Garanoa, bing ubala siangga li bu xugia salanga.” ");
INSERT INTO met_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu haxuya ba, “Urana Xuanoa harua ba: ‘Lipudi sanga ba daxap walinga mana salanga ing ganina te.’ ” ");
INSERT INTO met_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Satan xai mahaing long eta loam tela saing hatanga sap xaitamoxidi yonggaxiding longgalo duwa titia na. ");
INSERT INTO met_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Baing harua na ba, “Bagula ngasinadi naung bu uwa etua manadi, baing bagula oxop gumangiding xaung haringingading, namua na longgadi ba ngayuadi, baing sanga ba ngasinadi na lipu gaxarea nga murugu mana. ");
INSERT INTO met_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Binabu axadi ba bagula disok ungiadi nabu usabu manga.” ");
INSERT INTO met_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ne Yesu haxuya ba, “Urana Xuanoa harua ba: “ ‘Usabu mana Toxoratamona, Urana ungia, saing utuxu ing oxatanoa ing ganina.’ ” ");
INSERT INTO met_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Baing Satan xai mari long sabangga Yerusalem saing ta mahaing etua sibuna Urana Numang urongania. Harua na ba, “Nabu ung Urana Garanoa, bing uhixi mari la li. ");
INSERT INTO met_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Namua na Urana Xuanoa harua ba: “ ‘Bagula tabina uleginamdi maung bu duwasa xai maung. ");
INSERT INTO met_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Bagula ditiung rimadingia, nam utua kima siangia.’ ” ");
INSERT INTO met_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu haxuya ba, “Urana Xuanoa harua ba: ‘Labu uta Toxoratamona Urana ungia tubaigiau tai.’ ” ");
INSERT INTO met_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan tuba muraging longgalo mana Yesu laing sup, baing yunga ba ragu bunging xai tela bu tuba muli. ");
INSERT INTO met_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu goxoya mala titia Galili xaung Urana Aningong haringinganoa. Naxuyanganoa ila mana long longgalo duwa singia. ");
INSERT INTO met_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tubatubadi maluxuʼm sabungading numandi, saing ding longgalo diti yanoa. ");
INSERT INTO met_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Baing ina naga, ila sok Nasaret, longga tubu mana ba. Xaidap Yaguangam sokkuba, baing luxu sabungading numania namua na ina kubolunoa. Baing mesa bu hatanga bo ba titi Urana Xuanoa nadi. ");
INSERT INTO met_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Disina Urana lipuxing suxunguxunguama Aisaya xailongina na. Walalia, saing bagu hataina bung ba: ");
INSERT INTO met_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Toxoratamona Aningonoa wa rangua nga, namua na mogu nga bu ngabaxanga ulek xaiyua na lipu haxugindi. Soxi nga bu ngabaxanga ba lipu salak yabanamdi, Urana uniadi, lipu maxa haxatiandi, dibagu muli, lipuadi lipudi ditatuadi dilibu doa manadi, Urana uniadi, ");
INSERT INTO met_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","xaung bunging xai mana Toxoratamona sokkuba.” ");
INSERT INTO met_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Titi laing sup, baing luki xailonga, sina muli na lipu oxatama, saing rung mari bu tubatubadi. Ding longgalo duwa sabungading numania dita maxa mana mua. ");
INSERT INTO met_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tauna, ungguti haruanganoa, harua nadi ba, “Hatata abagu haruanga li aningona maxaimia.” ");
INSERT INTO met_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ding daharua xai mana, saing dihixi mana haruanga xaidi baxangadi suxungunia. Ne teladi duxusunga ba, “Lipua li Yosep garanoa ing ganina, bo?” ");
INSERT INTO met_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Baing Yesu baladi ba, “Maxung sibuna, kimuya bagula abala nga haruanga muganga li: ‘Lipu baxiam, uhamaringiaung ung sibum!’ Namuxina bing: ‘Ulibu axamang haringindi la li yabamia bila am galungu ulibu longga Kaperneam lo.’ ” ");
INSERT INTO met_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Baing harua ba, “Maxung sibuna ngabalang ba, Urana lipuxing suxunguxunguama bing lipudi dilungu haruanganoa yabania te. ");
INSERT INTO met_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Maxung sibuna, tap xumana duwa Isrel bungina Elaitsa. Baing xaidap sabanga niani tuwa xaung sobak 6, saing gesak sabanga xap lipu longgalo duwa Isreldi titidingia ba. ");
INSERT INTO met_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ne Urana soxi Elaitsa mala rangua teladi te. Tegu. Soxi mala longga Sarapat haxek mana long sabangga Saidon, bu hauli Yuda Teguam tap tela. ");
INSERT INTO met_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Xauna, xumana duwa Isrel saksaxading bungina Urana lipuxing suxunguxunguama Elisa. Ning dingia tela sok sigixinga te. Tegu. Neman, Yuda Teguam tela mana numanuma Siria, ing ganina sok xai.” ");
INSERT INTO met_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Lipu longgalo duwa maluxu sabungading numania, bungina dilungu haruanga baguba, atiding disala haringina. ");
INSERT INTO met_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dimesa, disuka mala sangua longa. Longga ba, wa mana xaxagang tela. Daxap mala xaxagang rubinia bu diting mari rabanganiauba. ");
INSERT INTO met_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ning haxa taxa maluxuʼm burangua saing ilauba. ");
INSERT INTO met_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Baing ri mala long sabangga Kaperneam, titia Galili long tela, saing mana Xaidap Yaguangamdi ila tubatuba lipudi. ");
INSERT INTO met_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Dihixi mana tubatubainganoa, namua na haruanganoa haring sibuna. ");
INSERT INTO met_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","La ba, sabungading numania, lipu tela wa. Xaunga, aningoningo sigixinga teguam, wa mana. Xaba haringina ba, ");
INSERT INTO met_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Si! Yesu Nasaretiam, uma bu uraxata mam? Bola uma ba uhanggalangiam? Ngaxabiaunggu, ung Urana Lipuxing Mogu Naina!” ");
INSERT INTO met_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu bili ba, “Udik! Usok ma sangua lipua li!” Baing xaunga ting lipua ba mari maxadingia, saing sok sangua, ne hanggalangia lipua ba te. ");
INSERT INTO met_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Lipu longgalo dihixi mana, saing dahangixaya liwe mading ba, “Tubatubainganoa haringing sibuna! Harua bila lipu yayam xaung lipu haringingam, saing bila balau tabina xaungadi saing disok sangua!” ");
INSERT INTO met_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Baing Yesu naxuyanganoa ila mana long longgalo duwa singia. ");
INSERT INTO met_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu yunga sabungading numanoa saing ila Saimon numania. Saimon haininoa bauna busi saing sanggandi disala haringing sibuna, saing duxusunga Yesu ba hauli. ");
INSERT INTO met_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Baing ila yuyu mari rangua, bili salaga saing sup. Baing hata sibuna li mesa, saing xauxau angingua nadi. ");
INSERT INTO met_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Xaidaba bo ba riuba, baing lipudi daxap lipu busingam xangxana longgalo dima rangua Yesu, saing ta rimandi mana taining tainina, libu disok xai dup. ");
INSERT INTO met_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Baing xaungadi disok sangua lipu xumana, daxaba ba, “Ung Urana Garanoa!” Ning gamiadi saing bilidi ba daharuau tai, namua na daxabia ba ina Urana Lipuxing Mogunganama. ");
INSERT INTO met_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Buraraging sibuna baing Yesu ila mana long xolian tela. Lipudi disai mana, baing bungina disok mana, dituba daharua na ba yungadiu tai. ");
INSERT INTO met_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ning harua ba, “Bagula ngabaxanga ulek xaiyua mana Urana Yonggaxinoa na long teladi xauna, namua na Urana soxi nga ma mana namua baguba.” ");
INSERT INTO met_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Baing ina naga, haxa mauli titia Yudia, baxanga maluxuʼm sabungading numandi. ");
INSERT INTO met_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Xaidap tela Yesu li mua Genesaret Lang Gamolingang rubinia, lipudi dibura ditaxiya saing dilungu Urana Xuanoa. ");
INSERT INTO met_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Li saing bagu xai wagang luwa digotidi lang rubinia. Moxodingdi, lipu xuningamdi, diyungadi la ba, didamia amagadingdi mua. ");
INSERT INTO met_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Baing Yesu haing mana xai wagang tela, Saimon inia, saing xusunga ba yu mala monga bu oti. Baing ina naga, rung mari xai wagania saing tubatuba lipudi. ");
INSERT INTO met_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tubatuba laing sup, baing bala Saimon ba, “Ui mala lang suania, saing ayungia amagaimdi mari bu axap songdi.” ");
INSERT INTO met_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon haxuya ba, “Lipu Sabanga, am gamakasa laing yambonga sup. Am gatubatuba sus. Ne namua na ubala nga, baing sangau, bagula ngayungia amagadi mari muli.” ");
INSERT INTO met_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Diyungiadi laing sup, baing ina naga, amagadi dibaxagi mana song xumang sibuna, dibo ba disingguba. ");
INSERT INTO met_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Binabu duwagi riadingdi duwa xai wagang tela ba dima dahaulidi. Dima digabudi digam xai wagandi dibaxagi sibuna. Baing tang dibo ba didauba. ");
INSERT INTO met_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Saimon gabu riandi duwa rangua dihixi mana song xumang sibuna ba daxapdi. Yems, Yon, dingtang Sebedi garandi, lipu xuningamdi xaung Saimon, dingtang xauna dihixi mana. Bungina Saimon, yan tela Pita, bagu songgadi ba, gung king tuxundi Yesu kinia saing harua ba, “Toxoratamona, usauya nga, namua na nga lipu kubolu dianama!” ");
INSERT INTO met_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ne Yesu harua na Saimon ba, “Labu umaxuwau tai. Hatata saing ila, bagula oxop lipudi bila oxop songdi ba.” ");
INSERT INTO met_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Baing ina naga, daxai xaiding wagandi mahaing uruxunia, diyunga xalingidingdi lipu teladi rimadingia, saing dinaxu mana Yesu. ");
INSERT INTO met_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Xaidap tela Yesu wa maluxuʼm long tela, baing lipu tela, saksaxa baxagiʼm sangganoa, haxa mauba. Bungina bagu Yesu, tingina mari saing gung king tuxundi, xusunga haringina ba, “Toxoratamona, nabu ung murum, ung sanga ba usahi busingagua bu ngasok sigixinga.” ");
INSERT INTO met_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Baing Yesu ta rimanoa mala saing ring. Bala ba, “Nga murugu, usok sigixinga!” Hata sibuna li businga saksaxa sup mana. ");
INSERT INTO met_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Baing Yesu harua haringina na ba, “Labu ubala lipu tela manau tai. Ne muga ula, uhatangaung na lipu hananiangama. Hatata usok xai, bing usina hananianga mana sigixingama bila Moses hanaunau ba, binabu lipudi bagula daxabia ba busingama sup.” ");
INSERT INTO met_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ning naxuyanganoa tubu, ila long longgalo, binabu lipu buranga dima bu dilungu xaung bu sahi busingadingdi. ");
INSERT INTO met_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ne bunging xumana yunga lipudi, ila mana long xoliandi bu sabu. ");
INSERT INTO met_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Xaidap tela, Yesu tubatuba lipudi. Tubatubadi baing Parisidi digabu lipu hanaunaunga tubatubainganamdi, dima sangua long xumana duwa Galili xaung Yudia, xaung long sabangga Yerusalem, ding dirung mua la ba. Baing Toxoratamona sina haringingua na Yesu bu hamaringia lipu busingamdi. ");
INSERT INTO met_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Lipu teladi dima, dahau lipu king rimandi dahamati ba ma. Dituba ba daxap maluxu numa lunia bu dita mari Yesu maxania. ");
INSERT INTO met_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Disai daxanga susu, namua na lipudi dibura buk. Baing ina naga, dahaing taxagia mala numa ubunia saing daxaxa numa long tela, saking diyungia kabukabu lipu busingama kinu mana ba mari liwe burangia, taxa Yesu maxania. ");
INSERT INTO met_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu bagu hatumingading haringina, baing harua ba, “Riagu, kubolum diandi disup.” ");
INSERT INTO met_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ne Parisidi digabu lipu hanaunaunga tubatubainganamdi dahatum hatumingadingia ba, “Lipua li baru lipuxinta? Harungia Urana! Gaxarea sanga ba yunga kubolu diandi? Urana ing ganina!” ");
INSERT INTO met_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu xabiau dahatum baru, saing xusungadi ba, “Baruta ahatum hatumingaimia bila ba? ");
INSERT INTO met_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Baru haruanganta mosiu mana ngaharua: ‘Kubolum diandi disup’ kimbo ‘Umesa uhaxa’? ");
INSERT INTO met_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ning hatata bagula ngahatanga nang ba Lipua Ma Rangua Urana ina sanga haringinga etua mana titia li bu yunga kubolu diandi.” Saking harua na lipu king rimandi dahamati ba, “Ngabalaung, umesa oxop uxaingama saing ula numia.” ");
INSERT INTO met_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hata sibuna li mesa maxadingia, xap uxainganoa menau kinu mana saing ila numiauba. Ila saing iti Urana yanoa. ");
INSERT INTO met_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Lipu longgalo dihixi mana, saing diti Urana yanoa. Suxunguding daxaxa ding mana, saing daharua ba, “Hatata kira tabagu axamang xan tela sibuna.” ");
INSERT INTO met_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kimuya mana baguba, Yesu ila sangua longga ba, saing bagu lipu takis xabinganam tela yanoa Libai, rung mua numa takis xabinganamia. Yesu harua na ba, “Unaxu manga.” ");
INSERT INTO met_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Baing ina naga, Libai mesa, yunga oxatanoa saing naxu manauba. ");
INSERT INTO met_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Baing Libai tongtongia taunga sabanga tela numania mana Yesu. Baing lipu takis xabinganam buranga xaung lipu teladi daxang ranguadi. ");
INSERT INTO met_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ne Parisidi digabu lipu hanaunaunga tubatubainganamdi duwa mana sabungadinga dahati lipuxindi dinaxu mana ba, “Baruta axang anung rangua lipu takis xabinganamdi xaung lipu kubolu dianamdi?” ");
INSERT INTO met_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu haxuya nadi ba, “Lipu baxiamdi dahauli lipu businga teguamdi te. Tegu. Dahauli lipu busingamdi. ");
INSERT INTO met_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Bila balau, ngama ba ngawagi lipu maringindi te. Tegu. Ngama ba ngawagi lipu kubolu dianamdi, ba duxugia hatumingadingdi.” ");
INSERT INTO met_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Daharua na ba, “Bunging xumana lipuadi dinaxu mana Yon disaha mana angingua bu dahatanga ba dibo ba Urana yaha manadi, saing disabu maluxuʼm bungina bagudi ba. Lipudi dinaxu mana Parisidi xauna, dilibu bila ba. Ning ungiadi daxang dinunggu. Baruta?” ");
INSERT INTO met_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu haxuya nadi ba, “Nabu lipu tela hatata bo ba yau. Sanga ba alibu riandi disaha mana angingua bungina wauyu ranguadi? Tegu. ");
INSERT INTO met_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ne kimuya bungina lipu teladi daxap lipua ba mala sangua ding, mana xaidapkadi bagudi ba bagula disaha mana angingua.” ");
INSERT INTO met_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Baladi mana haruanga babuna li: “Lipu tela labu sing imang haung hataina saing raga mana imang muganguau tai. Nabu libu bila ba, bing bagula sing imang hauna, saing imang haung hataina sanga ba wa taininau mana mugangua te. ");
INSERT INTO met_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ne lipu tela labu gua wain hauna mari mana meme sanggang mugangadiu tai. Nabu libu bila ba, bing wain hauna bagula sing saha meme sanggandi, wain bagula matuxuya masup mari, saing meme sanggandi bagula didoa. ");
INSERT INTO met_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Tegu. Wain hauna bing digua mari mana meme sanggang haundi. ");
INSERT INTO met_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Baing lipu gaxarea dinung wain muganga bagula dibo ba dinung haunua te, namua na daharua ba, ‘Muganga dauyang sibuna.’ ” ");
INSERT INTO met_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mana Xaidap Yaguangam tela, Yesu gabu lipuxindi dinaxu mana dahaxa makisi mana wit umangang tela. Lipuxindi dinaxu mana daxauya wit marang teladi, diyukiyukidi rimadingia saing daxang maradingdi, namua na gesagiding. ");
INSERT INTO met_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ne Parisi teladi duxusunga ba, “Baruta alibu oxatua hanaunaungaradi dibili kira ba talibu mana Xaidap Yaguangama?” ");
INSERT INTO met_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu haxuya nadi ba, “Axa mugangaroa Debit libu waleu, atiti ba ne baruta ahatumia te? Mana bungina ina gabu guguniangandi gesagiding ba. ");
INSERT INTO met_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Luxu Urana Numania, saing xap salanga dita Urana maxania. Anginga baguba bilingam. Lipu hananiangam ding ganiding sanga ba daxang. Ne Debit, ina xap teladi saing xang. Baing sina teladi na guguniangandi xauna.” ");
INSERT INTO met_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Saking Yesu harua nadi ba, “Lipua Ma Rangua Urana wasa mana Xaidap Yaguangama, binabu sanga ba nai mana baru kubolunta lipuxindi dilibu mana.” ");
INSERT INTO met_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mana Xaidap Yaguangam tela muli Yesu luxu Yudadi sabungading numania saing tubatubauba. Lipu tela wa la ba, rimang rimamo mati saing toatuana. ");
INSERT INTO met_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Parisidi digabu lipu hanaunaunga tubatubainganamdi duwasa mana Yesu xai, bu dibagu nabu bagula hamaringia mana Xaidap Yaguangam kimbo tegu, namua na disai daxanga tela ba dita haruangia. ");
INSERT INTO met_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ne Yesu xabiau dahatum baru hatumingadingia, saing harua na lipua rimanoa mati ba, “Umesa uli lipudi maxadingia.” Baing mesa saing li la ba. ");
INSERT INTO met_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Baing Yesu harua nadi ba, “Ngaxusungang ba, baru kubolunta naxu mana hanaunaunga mana Xaidap Yaguangam: Talibu xai kimbo talibu doa, tahauli kimbo tahanggalangia?” ");
INSERT INTO met_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Bagu mauli manadi, saing harua na lipua ba, “Uraria rimama.” Baing ina naga, libu saing rimanoa sok xai dup. ");
INSERT INTO met_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ne atiding disala haringina saing dungguti dahangixaya nading ba dilibu baru mana Yesu. ");
INSERT INTO met_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Xaidap tela Yesu haing mala xaxagania bu sabu, saing sabu na Urana mala laing yambonga sup. ");
INSERT INTO met_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Buraragina baing wagi lipudi dinaxu mana ba dima rangua saing mogu 12 manadi, uxudi ba aposeldi. ");
INSERT INTO met_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Lupkadi ba: Saimon (Yesu sina yaya Pita na), Andru (Pita kixinginoa), Yems, Yon (Yems kixinginoa), Pilip, Bartolomyu, ");
INSERT INTO met_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas, Yems (tela, tibuna Alpias), Saimon (duxu ba Selat, namua na bakbagindi dibo ba disuka Romdi mala), ");
INSERT INTO met_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas (tibuna Yems tela muli), Yudas Iskariot (tela, ina ta Yesu bixuandi rimadingia). ");
INSERT INTO met_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu gabudi diri mala, saing li mana long gomang tela. Lipuxing buranga dinaxu mana duwa la ba xaung lipu xumana dima mana titia Yudia long longgalo, mana Yerusalem, xaung dima mana Taya, Saidon titidinga, long sabanga luwadi ba duwa tegia. ");
INSERT INTO met_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Dima bu dilungu xaung dima bu sahi busingadingdi. Lipudi xaunga duwa manadi disok xai, ");
INSERT INTO met_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","saing lipu longgalo dituba ba diring, namua na Urana haringinganoa sok ma sangua saing sahi ding longgalo busingadingdi. ");
INSERT INTO met_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Bagu mauli mana lipuxindi dinaxu mana, saing harua ba, “Ang haxugindi, bing awa xai, namua na Urana Yonggaxinoa bing angia. ");
INSERT INTO met_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ang gesagim hatata, bing awa xai, namua na gesagima bagula sup. Ang gatang hatata, bing awa xai, namua na bagula amasisi. ");
INSERT INTO met_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Bungina lipudi hauxading sibuna mang, bungina diyamuang saing didaudauang saing daharua ba yaimdi didoa namua na asu mana Lipua Ma Rangua Urana, bungina dilibu bila ba, awa xai. ");
INSERT INTO met_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Mana bungina baguba ayaha sibuna gamoimia saing asaki, namua na haxuyangaim sabanga raguang long xaiya. Ahatumia, waleu mugangadingdi dilibu taininau mana Urana lipuxing suxunguxunguamdi ba. ");
INSERT INTO met_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ning ang lipu xalaxalamdi, laku, mauxanganoa xapkang yu, namua na axap walinga xaiyua masup ba. ");
INSERT INTO met_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ang gaxang sanga ba hatata, laku, mauxanganoa xapkang yu, namua na bagula ang gesagim. Ang gamasisi hatata, laku, mauxanganoa xapkang yu, namua na bagula ausi atang. ");
INSERT INTO met_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Bungina lipu longgalo daharua xai mang, laku, mauxanganoa xapkang yu, namua na waleu mugangadingdi daharua xai mana lipu murakkamdi dilangua daxap Urana suxungunoa saing dibaxanga ba. ");
INSERT INTO met_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ne ang gaxarea alungu nga, ngabalang ba: Ang muruim sibuna mana bixuaimdi, alibu xai mana lipuadi hauxading sibuna mang, ");
INSERT INTO met_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","axusunga Urana ba libu xai mana lipuadi dilibu guxam diana mang, asabu mana lipuadi dilibu doa mang. ");
INSERT INTO met_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nabu lipu tela tahaung manggaxobim hataina, bing uxugia tela rangua xauna. Nabu lipu tela xap imangim maxaxaya, bing ubili mana xap imangim lunamau tai. ");
INSERT INTO met_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Usina na lipu longgalo duxusungaung. Baing nabu tela xap xalingim tela mala, bing abala ba haxuyau tai. ");
INSERT INTO met_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kubolu taininau abo ba lipuadi dilibu mang, bing alibu taininau manadi. ");
INSERT INTO met_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nabu ang muruim sibuna mana lipudi muruding sibuna mang, lipu gaxarea bagula diti yaimdi? Si! Lipu kubolu dianamdi xauna, muruding sibuna mana lipudi muruding sibuna manadi. ");
INSERT INTO met_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Baing nabu alibu xai mana lipuadi dilibu xai mang, lipu gaxarea bagula diti yaimdi? Si! Lipu kubolu dianamdi xauna dilibu bila ba. ");
INSERT INTO met_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Baing nabu asina axamang tela ba abo ba dahaxuya nang, lipu gaxarea bagula diti yaimdi? Si! Lipu kubolu dianamdi xauna, disina na lipu kubolu dianamdi, dibo ba dahaxuya nadi haxuyangading longgalo. ");
INSERT INTO met_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ning ngabo ba ang muruim sibuna mana bixuaimdi, alibu xai manadi, saing asina nadi, heku mana axap haxuyanganoau tai. Baing haxuyangaima bagula sabanga sibuna, saing bagula awa Urana Eta Loam Sibuna garang sibundi, namua na ina libu xai xauna mana lipuadi daharua xai sibuna na te, xaung mana lipu diandi. ");
INSERT INTO met_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ausinga lipu longgalo, bila Urana Tibuim usinga lipu longgalo. ");
INSERT INTO met_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Labu asuxuya lipu teladiu tai, bing Urana bagula suxuyang te. Labu aung lipudi mati hatumingaimiau tai, bing Urana bagula tang haruangia te. Ayunga lipudi kuboluding diandi, bing bagula Urana yunga angiadi. ");
INSERT INTO met_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Asina, baing bagula Urana sina nang. Bungina Urana sina axamandi, sina xumana, gamgamdi mari, yungyungixaya, gam teladi xauna laing makmatuxuya mari bu sinadi nang. Maxang taininau asina, bing bagula axap maxang taininau muli bila ba.” ");
INSERT INTO met_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Baladi haruanga babuna li xauna, harua ba, “Nabu lipu luwa tang maxading dahaxatu, bing sanga ba tela xai rianoa mala? Tegu. Bagula dingtang xauna xungdi mari banggumia baing! ");
INSERT INTO met_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Lipua wa tubatubaingia yanoa dali lipuxing tubatubaikkam yanoa te. Ne bungina xap xabianga masup, bing sok bila lipuxing tubatubaikkam. ");
INSERT INTO met_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Baruta ubagu xai sangsangina wa riama maxania, ne uhatumia tuxa wa ung sibum maxamia te? ");
INSERT INTO met_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Saing baruta uharua na riama ba, ‘Riagu, ngabo ba ngaunia xai sangsangina sangua maxama,’ bungina ung sibum ubagu tuxa wa maxamia te? Ung lipu manang luwa, muga bing unia tuxa sangua maxama, baing kimuya sanga ba ubagu maringina bu unia xai sangsangina sangua riama maxanoa. ");
INSERT INTO met_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Lipudi bila xaidi. Xai xai ua marang diandi te, saing xai diana ua marang xaidi te. ");
INSERT INTO met_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Xai taining tainina ua ing sibung marandi, bila tabagu taxabia baing. Lipudi dikiri wawai mana waxu ruxunamdi te, dikiri unggak mana axexu te. ");
INSERT INTO met_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Bila balau, lipu xai, hatuminganoa baxagi mana hatuminga xai saing ua bila ba. Baing lipu diana, hatuminganoa baxagi mana hatuminga diana saing ua bila ba. Namua na suxungunoa baxanga sabasabia axadi hatuminganoa baxagi manadi bila ba. ");
INSERT INTO met_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Baruta auxu nga ba, ‘Toxoratamona ngayua,’ ne asu mana haruangagua te? ");
INSERT INTO met_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Lipu gaxarea dima rangua nga, dilungu haruangagua saing dilibudi, bagula ngahatanga nang ba lipuadi na bila baru. ");
INSERT INTO met_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Bila lipu tela tongtongia numua, ki gapdi mari laing sok mana sianga saing rang tuxadi mali. Bungina langa si sabanga ma, bo ba xup numa ba, ne sanga ba taguxa te, namua na lipua ba tongtongia xai. ");
INSERT INTO met_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ning lipudi dilungu haruangagua saing dilibudi te, ding bila lipu tela tongtongia numua titia, tuxang tate. Bungina langa si sabanga ma, xup numa ba saing hata sibuna li galaina mari, baing doa masup.” ");
INSERT INTO met_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu baxanga axadi ba na lipudi laing sup, baing ila luxu mana long sabangga Kaperneam. ");
INSERT INTO met_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","La ba, Rom lipu haungingam 100 yanamiding tela wa. Ina xaung lipuxing oxata olanggam tela, muruna buk mana. Busi saing bo ba matiuba. ");
INSERT INTO met_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yanamga ba lungu naxuyangua mana Yesu, saing soxi Yuda lipuxiding haringing teladi mala rangua, bu duxusunga ba ma sahi lipuxing oxatama businganoa. ");
INSERT INTO met_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bungina disok mana Yesu, duxusunga haringina, daharua ba, “Lipua li lipu xai, sanga ba ulibu mana. ");
INSERT INTO met_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Namua na murung sibuna mana kira Yudadi saing tongtongia sabungamam numanoa.” ");
INSERT INTO met_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Binabu Yesu ila ranguadiuba. Dila duwa hasoya mana numua te, baing yanamga ba soxi riandi mala rangua bu daharua na ba, “Toxoratamona, heku umakasa buk, namua na nga lipu xai te sanga mana uluxu numagia. ");
INSERT INTO met_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Namua naga ngama ranguaung te. Ngabagu ba nga lipu xai te ba ngama. Ne usina haruanga ing ganina baing lipuxigu oxata olanggam bagula sok xai muli. ");
INSERT INTO met_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngaxabiau, namua na nga xauna ngawa hawa mana lipuxigu yayamdi, saing lipu haungingam duwa hawa manga, disu mana haruangagua xauna. Ngabala tela ba, ‘Ula,’ saing ila. Ngabala tela ba, ‘Uma,’ saing ma. Ngaharua na lipuxigu oxata olanggama ba, ‘Ulibu bila li,’ saing libu.” ");
INSERT INTO met_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu lungu laing sup, saing hixi mana. Xugia mala rangua buranga disu mana, saing harua ba, “Ngabalang ba, hatuminga haringina li sabanga baing! Ngabagu bila li mana Isrel tela te.” ");
INSERT INTO met_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Baing ina naga, uleginamdi digoxoya mala numia, saing dibagu lipu oxatama sok xai dup. ");
INSERT INTO met_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kimuya, Yesu ila long tela duxu ba Nain. Lipuxindi dinaxu mana digabu buranga sabanga dahaxa mala rangua. ");
INSERT INTO met_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sok haxek longga gamgamingang xaluxinia, baing lipudi dahau matia tela masok ma sangua longga ba. Gananuna ba ing ganina bauna hayau, saing bauna ba tap. Baing buranga sabanga mana longga ba dima xauna. ");
INSERT INTO met_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bungina Toxoratamona bagu tapka ba, baing gamonoa usinga saing harua ba, “Utanggu tai.” ");
INSERT INTO met_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Baing ila haxek saing ring kilauna, saing lipuadi dahau mala dili mua. Harua ba, “Gananuna, ngabalaung ba, umesa!” ");
INSERT INTO met_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Baing ina naga, matia ba mesa rung saing harua. Baing Yesu sina na bauna muli. ");
INSERT INTO met_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Maxuwanga xap lipudi saing diti Urana yanoa. Daharua ba, “Urana lipuxing suxunguxunguam sabanga tela sok makira ba. Urana ri ma ba hauli lipuxindi ba.” ");
INSERT INTO met_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Naxuyanga li mana Yesu ila mana long longgalo duwa titia Yudia xaung singia. ");
INSERT INTO met_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Lipudi dinaxu mana Yon dibaxanga na mana axadi Yesu libudi ba. Baing wagi dingia luwadi, ");
INSERT INTO met_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","soxi dingtang mala rangua Toxoratamona bu duxusunga ba, “Ung ba, ung lipua Urana mogu ba ma, kimbo am garagu mana telauyu?” ");
INSERT INTO met_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Baing dilauba. Dila disok mana Yesu, baing daharua ba, “Lipu Suguangama Yon soxiamtam gama ranguaung bu tam gaxusungaung ba, ‘Ung ba, ung lipua Urana mogu ba ma, kimbo am garagu mana telauyu?’ ” ");
INSERT INTO met_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Taxa mana bungina baguba Yesu sahi xumana busingading xaung salagiding, libu lipuadi xaungadi duwa manadi disok xai, saing libu lipuadi maxading dahaxatu dibagu muli. ");
INSERT INTO met_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Baing ina naga, Yesu haxuya na Yon uleginamdi ba, “Tang gagoxoya mala rangua Yon saing anaxuya mana axadi abagudi alungudi ba: Lipu maxa haxatiandi dibagu muli, lipuadi kidingdi didoa dahaxa muli, lipu saksaxamdi busingading disup, lipu tangalia haxatiandi dilungu muli, matiadi dimesa muli, xaung lipu haxugindi dilungu ulek xai baxanganganoa. ");
INSERT INTO met_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Lipu gaxarea dibagu nga saing hatumingading haringindi xungdi mari te, bing bagula Urana guxamdi.” ");
INSERT INTO met_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yon uleginamdi dila, baing Yesu ungguti harua na buranga mana Yon, harua ba, “Bungina ala long xoliania ba abagu Yon waleu, asaiʼm lipua na bila baru? Bola asaiʼm rambuk tela yanga lili? Tegu. ");
INSERT INTO met_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ne ala asaiʼm lipua na bila baru? Bola lipu tela sau imang gumangindi? Tegu. Bagu lipuadi disau imang siang sabanggamdi xaung xalingiding xumana, ding duwa mana numa xaitamoxiamdi. ");
INSERT INTO met_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ne ala asaiʼm lipua na bila baru? Urana lipuxing suxunguxunguama? Ina naga. Ne ngaharua maxung sibuna nang, Urana lipuxing suxunguxunguama Yon dali adi duwa waleu. ");
INSERT INTO met_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ina naga waleu sibuna Malakai bung mana bungina bung haruanga Urana harua na Lipuxing Mogunganama, harua ba: “ ‘Bagu bagula ngasoxi lipuxigu ulekkama muga naung, bu hamaringia daxangama ila muga maung.’ ");
INSERT INTO met_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ngabalang ba, mana lipu longgalo duwa waleu ma ba, bing tela dali Yon te. Ning lipu gaxarea daxap yaya kaxukang sibuna maluxu Urana Yonggaxinia, ding didali Yon.” ");
INSERT INTO met_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Haing lup longgalo, lipu takis xabinganamdi xauna, bungina dilungu haruanga ba, dinai ba Urana kubolunoa maxuna, namua na daxap langa rangua Yon ba. ");
INSERT INTO met_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ning Parisidi digabu lipuadi daxabia hanaunaunga xai sibuna, ding hauxading mana Urana daxanganoa, binabu daxap langa rangua Yon te. ");
INSERT INTO met_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Baing Yesu harua muli ba, “Bagula ngating haruanga babung baruamta mana lipu hatatam kuboludinga? ");
INSERT INTO met_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ding bila garadi dahali nawa yabania, digamia riadingdi ba: “ ‘Am gayup olai yahangamdi mana panggeriang mang, ne asiga te. Am gawaya olai matiam, ne atang te.’ ");
INSERT INTO met_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bila balau, ayaha mana Yon tam te! Ahatumia, Lipu Suguangama Yon ma, saing xang salanga te, nung wain te, ne aharua ba, ‘Xaunga wa mana!’ ");
INSERT INTO met_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Lipua Ma Rangua Urana ma saing xang nung, ne aharua ba, ‘Abagu, lipua lo xang xaung nung wain buk, saing wa lipu takis xabinganamdi xaung lipu kubolu dianamdi riadinga!’ ");
INSERT INTO met_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ne lipuadi dahatum sibuna mana kuboluadi Yon tam galibudi, bagula dibagu daxabia ba tam gasu mana xabianga maringina.” ");
INSERT INTO met_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tauna, Parisi tela xusunga Yesu ba ma bu xang rangua. Baing ina naga, ila numania saing kinuʼm tabu kabukabu xangingam rubinia. ");
INSERT INTO met_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Baing haing kubolu dianam tela mana long sabangga ba, bungina lungu ba Yesu xang Parisi numania, xap nanggola siang alabastam, guxenga saminam xai sibuna wa mana. Xap ma, ");
INSERT INTO met_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","baing ila gung king tuxundi Yesu king lunia saing tangguba. Maxang langin diri Yesu kinia saing sisiadi toxolonia, libu kindi bu hatanga ba wa hawa mana saing matu guxenga saminama mari manadi. ");
INSERT INTO met_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ne Parisi ba xusunga Yesu ma ba, bungina bagu alaba, hatum ba, “Ai, nabu lipua li Urana lipuxing suxunguxunguam maxunama, bing sanga ba xabia gaxarea ringring xaung ina haingga na baru. Haingga ba haing kubolu dianam.” ");
INSERT INTO met_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Baing ina naga, Yesu bala ba, “Saimon, ngabo ba ngabaxanga haruanga tela naung.” Haxuya ba, “Tauna, Lipu Tubatubaingam, ubaxanga.” ");
INSERT INTO met_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu harua ba, “Lipu luwa daxap sianga rangua lipu sianggam tela. Tela xap 500 siang, ne tela xap 50. ");
INSERT INTO met_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Dingtang sanga ba dahaxuya sianga te, namua na ding siangiding te. Binabu lipua ba yunga tang haxuyangadingdi. Tauna, baru lipuxinta bagula murung sibuna buk mana?” ");
INSERT INTO met_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon haxuya ba, “Bola lipua ba xap siang xumana saing haxuyanganoa sup.” Yesu harua ba, “Uhaxuya maringina.” ");
INSERT INTO met_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Baing xugia mala rangua hainga saing harua na Saimon ba, “Ubagu haingga li? Ngaluxu ma numamia, ne usu mana kuboluradi te. Usina langa nanga ba ngadamia kigudi te. Ne ina ba, damia kigudi maxang langinia saing sisia toxolonia. ");
INSERT INTO met_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ulibu nga te, ne ina ba, ina libulibu kigudi mana menau ngaluxu laing hatata. ");
INSERT INTO met_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Usabaxaya toxogua guxengia te, ne ina ba, ina sabaxaya kigudi guxenga saminamia. ");
INSERT INTO met_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Baing ina naga, ngabalaung ba, ina kubolung diang xumana, binabu murung sibuna manga namua na ngayungadi masup. Ne lipu gaxarea kuboluding diang monga disup bing muruding monga ing ganina.” ");
INSERT INTO met_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Saking Yesu harua na hainga ba, “Ngayunga kubolum diandi.” ");
INSERT INTO met_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Lipudi dikinu kabukabu rubinia rangua dungguti daharungia liwe mading ba, “Lipua li bing hatum ba ing sibuna Urana, harua ba sanga ba yunga kubolu diandi!” ");
INSERT INTO met_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ne Yesu harua na hainga ba, “Hatumingam haringina xapkung muli sangua kubolum diandi. Ula xaung gamogamu xai.” ");
INSERT INTO met_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kimuya, Yesu haxa mauli mana titia ba long sabangadi long kaxukandi, saing baxanga baxanga ulek xaiyua mana Urana Yonggaxinoa. Lipu 12 dahaxa xauna. ");
INSERT INTO met_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Haing teladi Yesu suka xaungadi manadi ba saing sahi busingadingdi ba, ding xauna dahaxa xauna. Hainggadi ba: Maria (duxu ba Magdalam), ina Yesu suka xaunga 7 mana ba, ");
INSERT INTO met_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yoana, Kusa haininoa, Kusa ba wasa mana Xaitamoxi Herot numanoa, Susana, xaung haing xumana muli. Hainggadi ba disina xalingiding teladi bu dahauli Yesu gabu lipuxindi dinaxu mana. ");
INSERT INTO met_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Baing lipudi dima rangua Yesu mana long longgalo, saing buranga sabanga diguguniauba. Digugunia saing baladi mana haruanga babuna li, harua ba, ");
INSERT INTO met_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Lipu umangam tela ila umangia bu ting wit xuyandi. Tingdi saing teladi diri daxangia, lipudi diruhadi saing mangdi daxangxangiadi. ");
INSERT INTO met_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Teladi diri long sianggamia, baing bungina dahaxa, dimutuxu namua na titia langin te. ");
INSERT INTO met_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Xuyang teladi diri long waxu ruxunamia, baing dahaing xauna, dihibuadi binabu oxading te. ");
INSERT INTO met_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ne xuyang teladi diri titi xaiya. Dahaxa, dahaing saing dua xai. Didali xuyadingdi bila 100 muli.” Harua laing sup, baing wagi ba, “Lipu gaxarea tangadingliana, bing dilungu haruanga baguli.” ");
INSERT INTO met_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Lipuxindi dinaxu mana duxusunga ba baxanga haruanga babuna ba namuxinoa. ");
INSERT INTO met_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Harua ba, “Haruanga hisangamdi mana Urana Yonggaxinoa, Urana nai ba axap xabiangua manadi baing. Ne mana lipu teladi ngaharua nadi mana haruanga babundi bu “ ‘dibagubagu mua ne dibagu daxabia te, dilungulungu mua ne daxabia rangrang te.’ ");
INSERT INTO met_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Namuxina mana haruanga babunoa bing: Wit xuyandi bila Urana haruanganoa. ");
INSERT INTO met_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Xuyandi diri daxangia bila lipudi dilungu, baing Satan ma unia Urana haruanganoa sangua hatumingadingdi bu dahatum haringina te, saing daxap walinga subingang teguam te. ");
INSERT INTO met_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Xuyandi diri long sianggamia bila lipuadi dilungu Urana haruanganoa, daxap saing gamodingdi diyaha mana. Ne dahatum haringina mongaita ing ganina namua na oxaxadingdi diraxap. Xungdi mari bungina mauxangandi daxapdi. ");
INSERT INTO met_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Xuyanadi diri long waxu ruxunamia bila lipuadi dilungu, ne dila dahatum xumana buk mana walinga mauxanganamdi, xaung xalingidingdi xaung yahangadingdi dihibuadi, saing marandi dua xai te. ");
INSERT INTO met_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ne xuyanadi diri titi xaiya bila lipuadi hatumingadingdi daxai xaung dimaring. Dilungu Urana haruanganoa, dituxuʼm tabu hatumingadingia, saing dili haringina, marandi dua xai. ");
INSERT INTO met_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Lipu tela sanga ba tung nagung tela saing kaukau minia te, kimbo ta hawa kabukabia te. Tegu. Ta mahaing yabania bu lipudi diluxu sanga ba dibagu saxaxanganoa. ");
INSERT INTO met_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Binabu xabiangadi dihisa bagula disok menea. Baing xabiangadi duwa ulumia bagula disok sabasabia. ");
INSERT INTO met_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Binabu ahatum xai mana baraxinta alungu. Lipu gaxarea daxap haruangagua, Urana bagula sina xabianga tela muli nadi. Lipu gaxarea dilungu te, xabianga dahagaxa ba dingia, Urana bagula xap sanguadi.” ");
INSERT INTO met_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Xaidap tela Yesu bauna gabu kixingindi dima ba dibagu, ne sanga ba dila haxek rangua te, namua na lipudi dibura buk. ");
INSERT INTO met_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Lipu tela bala ba, “Baum gabu kixingimdi dili mua sabasabia, duxusunga maung.” ");
INSERT INTO met_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Baing haxuya ba, “Baugu xaung kixingigudi bing lipu gaxarea dilungu Urana Xuanoa saing dilibu.” ");
INSERT INTO met_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Xaidap tela Yesu harua na lipuxindi dinaxu mana ba, “Takisi mala lang gamolingang hataina.” Baing ina naga, dahaing mana xai wagang tela saing dilauba. ");
INSERT INTO met_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Dui mala, baing Yesu kinuba. Baing yang haringina mesa, binabu langa makmatuxuya maluxu wagia, saing dibo ba didoauba. ");
INSERT INTO met_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Lipudi dinaxu mana dila dahaunghaung, daharua ba, “Lipu Sabanga, Lipu Sabanga, tabo ba tangarauba!” Mesa saing bili yanga xaung rubadi dahalunglung ba. Baing yanga mati, saing tega manilu. ");
INSERT INTO met_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Xusungadi ba, “Hatumingaim haringindi kadi bi?” Dimaxuwa, dihixi mana binabu duxusunga ding ba, “Lipua li ina baru? Tabina lipudi ding ganiding te. Tabina yanga tega tang xauna, saing tang disu mana haruanganoa.” ");
INSERT INTO met_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Diluki mala diri longga Gerasadi titidingia, wa lang gamolingang hataina mana titia Galili. ");
INSERT INTO met_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu ri mala titia baing ina naga, lipu tela mana longga ba, xaungadi duwa mana, ma sok manauba. Lipua ba, bunging maxaxaya sau imang tela te, wa mana numa tela te. Tegu. Yabanoa wa mana guhadi gobagobia. ");
INSERT INTO met_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Bunging xumana xaungua xap, heku lipudi dituxu digoxi king rimandi duwasa mana, lipua taha saha waxu haringindi saing xaungua suka mala mana long xoliandi. Bungina lipua ba bagu Yesu, luki ma gung king tuxundi maxania. Baing Yesu tabina xaunga ba sok ma sangua lipua. Ning sok ma sap te. Tegu. Libu lipua wagi sabanga ba, “Yesu, Urana Etuam Sibuna Garanoa, bagula uraxata manga? Ngaxusungaung haringina ba usina salaga nangau tai.” ");
INSERT INTO met_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu xusunga ba, “Ung yama ga tela?” Haxuya ba, “Buranga,” namua na xaunga xumana diluxu mana ba. ");
INSERT INTO met_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Baing duxusunga xusunga haringina ba tabinadi ba diri Mabiau tai. ");
INSERT INTO met_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ne buxu nangnang bakbak sabanga tela disoya mua xaxagang rubinia ba. Xaungadi duxusunga Yesu haringina ba naidi ba diluxu manadi, baing naidi. ");
INSERT INTO met_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Baing ina naga, disok sangua lipua, diluxu mana buxudi, saing buxu nangnang bakbakka ba diluki haringing sibuna mari long diania maluxu lang gamolingania saing dingara. ");
INSERT INTO met_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bungina lipu buxu wasanganamdi dibagu baraxinta sok, diluki mala saing dibaxanga na lipuadi duwa long sabangadi xaung kaxukandi. ");
INSERT INTO met_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Baing ina naga, lipudi dila bu dibagu baraxinta sok. Bungina disok mana Yesu, dibagu lipua menau xaungadi duwa mana, rung haxek Yesu kinia, sau imangdi xaung hatuminganoa maring dup, baing dimaxuwa. ");
INSERT INTO met_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Lipuadi menau dibagu ba, dinaxuya na lipudi ba Yesu hauli lipua mana xaungadi baru. ");
INSERT INTO met_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Baing ina naga, Gerasa lipu longgalo duxusunga Yesu ba sauyadi, namua na maxuwanga sabanga xapdi. Binabu haing xai wagania, goxoya malauba. ");
INSERT INTO met_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Lipua menau xaungadi duwa mana ba xusunga Yesu haringina ba ila rangua. Ne Yesu soxi mala, harua ba, ");
INSERT INTO met_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ugoxoya mala numia saing ubaladi ba Urana libu baru maung.” Saking lipua ila, baxanga mauli mana longga ba Yesu libu baru mana. ");
INSERT INTO met_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu goxoya mala lang gamolingang hataina, baing buranga daharua xaidap xai na, namua na diragu mua mana. ");
INSERT INTO met_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Baing lipu tela yanoa Yairus mauba. Ina Yudadi sabungading numang yanamiding tela. Ma gung king tuxundi Yesu kinia, saing xusunga haringina ba ma rangua numania, ");
INSERT INTO met_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","namua na nanuhanginoa, taininau ing ganina saing nianindi 12, haxek sibuna bo ba mati. Baing dilauba. Dahaxa mala saing lipu buranga dahabisia buk. ");
INSERT INTO met_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Haing tela siba ri mana mua niani 12 wa la ba, ne lipu tela sanga ba sahi businganoa te. ");
INSERT INTO met_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ila sok Yesu ubunia saing ring imanging sihinoa, baing ina naga, hata sibuna li sipka ri mua ba moti. ");
INSERT INTO met_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu xusunga ba, “Gaxarea ring nga?” Ding longgalo dahatiam laing sup, baing Pita harua ba, “Ai, Lipu Sabanga, lipudi dibura buk maung, dahabisibisiung baing.” ");
INSERT INTO met_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ne Yesu harua ba, “Lipu tela ring nga. Namua na ngaxunumia haringingua yunga nga.” ");
INSERT INTO met_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Baing haingga ba xabia ba sanga ba hisa te, binabu lulu ma, saing gung king tuxundi kinia. Baxanga lipudi maxadingia ba baruta ring xaung hata sibuna li sok xai baru. ");
INSERT INTO met_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Baing ina naga, Yesu bala ba, “Nanuhangigua, hatumingam haringina hamaringiaung. Ula xaung gamogamu xai.” ");
INSERT INTO met_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Harua mua ne lipu tela sok, ma mana Yairus numanoa, Yudadi sabungading numang yanamidingga ba. Harua ba, “Nanuhangima mati ba. Heku usina makasangua na Lipu Tubatubaingama.” ");
INSERT INTO met_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ne Yesu lungu haruanga ba saing bala Yairus ba, “Umaxuwau tai. Uhatum haringina manga ing ganina, baing bagula sok xai.” ");
INSERT INTO met_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bungina sok Yairus numania, bili lipudi ba diluxu tai. Nai mana Pita, Yems, Yon xaung haing nanuna baungtibundi ding ganiding diluxu. ");
INSERT INTO met_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Lipuadi duwa la ba dahatangitangi saing daxaba mua mana. Baing Yesu baladi ba, “Asauya. Mati te, kinuʼm tabu ing ganina.” ");
INSERT INTO met_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ne dimasisia, namua na daxabia ba mati ba. ");
INSERT INTO met_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ning tuxu rimanoa saing harua ba, “Haing nanuna, umesa!” ");
INSERT INTO met_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Baing ina naga, aningonoa goxoya ma xurula sangganoa, saing hata sibuna li mesa. Baing Yesu baladi ba dulia haing nanuna ba anginga. ");
INSERT INTO met_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Baungtibundi dihixi mana, ne bilidi ba dibaxanga na lipu tela mana baraxinta sokku tai. ");
INSERT INTO met_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Baing Yesu wagi Lipu 12 dima digugunia, saing sina haringinga xaung yaya nadi bu disuka xaungadi mala xaung bu disahi busingadi. ");
INSERT INTO met_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Soxidi mala bu dibaxanga mana Urana Yonggaxinoa xaung bu dahamaringia lipu busingamdi. ");
INSERT INTO met_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Baladi ba, “Bungina ala, labu axap xalingim haxangamdi malau tai. Axap tuki, tanga, anginga, siang, imang tela muliu tai. ");
INSERT INTO met_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Numa baruamta ditang mana, bing awa mana laing ayunga longga baguba. ");
INSERT INTO met_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Long baruamta daxapkang te, bungina asauya longga baguba bing atingting gagapdi duwa kim lunia mala bu daxabia ba duwa haruangia.” ");
INSERT INTO met_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Baing ina naga, dilauba. Dahaxa mauli mana long longgalo, dibaxanga ulek xaiyua saing disahi lipudi busingadingdi. ");
INSERT INTO met_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galilidi yanamidinga Herot Antipas lungu axamang longgalo Yesu libudi ba. Baing hatum xumana mana, namua na teladi daharua ba Yesu bing Yon naga mesa muli mana matiyua. ");
INSERT INTO met_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Teladi daharua ba Elaitsa sok muli. Teladi daharua ba Urana lipuxing suxunguxunguam mugauam tela mesa saing wa muli. ");
INSERT INTO met_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ne Herot harua ba, “Ngaximguti Yon waxungtuanoa ba. Ning lipua li baru lipuxinta ngalungu axadi li mana?” Baing sai daxanga ba bagu Yesu. ");
INSERT INTO met_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bungina aposeldi digoxoya ma, dibaxanga na Yesu baraxintadi dilibudi. Baing xapdi saing disauya lipudi, ding ganiding dila long tela duxu ba Betsaida. ");
INSERT INTO met_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ne burangadi dilungu ila ba, saing disu mana. Xapdi saing tubatubadi mana Urana Yonggaxinoa, saing sahi busingadi mana lipu gaxarea dibusi. ");
INSERT INTO met_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Bungbung sibunauba, baing Lipu 12 dima rangua, daharua ba, “Usoxi burangua dila mana long teladi duwa singia, bu disai anginga xaung long kinungam. Namua na longga baguli long olang.” ");
INSERT INTO met_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Haxuya ba, “Ang ba auliadi teladi bu daxang.” Baing dahaxuya ba, “Am salangamam luwadi luwadi hiliadinga xaung songimam luwa. Nabu ubo ba am gahaxangdi, bing am gala am gagim anginga sanga mana buranga li to.” ");
INSERT INTO met_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Daharua bila ba namua na lup ding ganiding duwa la ba bila 5,000.) Baing harua na lipuxindi dinaxu mana ba, “Alibu dirung maxixinga bila 50 mana gugunianga taining tainina.” ");
INSERT INTO met_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Dilibu haruanganoa, baing lipu longgalo dirung mari. ");
INSERT INTO met_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu xap salanga luwadi luwadi hiliadinga ba xaung song luwa ba saing bagu mahaing long xaiya, harua xai sibuna mala rangua Urana, saing utu sahadi. Saking sinadi na lipudi dinaxu mana bu dituxu sinak na burangua. ");
INSERT INTO met_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Lipu longgalo daxang sanga ba. Baing lipudi dinaxu mana digugunia anginga hataindi duwauyu, digam daba 12 dibaxagi. ");
INSERT INTO met_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Bunging tela Yesu ing ganina sabu. Lipuxindi dinaxu mana duwa la ba xauna, baing xusungadi ba, “Lipudi daharua ba nga gaxarea sibuna?” ");
INSERT INTO met_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Dahaxuya ba, “Teladi daharua ba ung ba Lipu Suguangama Yon. Teladi daharua ba Elaitsa. Ne teladi daharua ba ung Urana lipuxing suxunguxunguam mugauam tela umesa saing uwa muli.” ");
INSERT INTO met_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Baing xusungadi ba, “Ne ang ba, ang gaharua ba nga gaxarea?” Pita haxuya ba, “Ung Urana Lipuxing Mogunganama.” ");
INSERT INTO met_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu bilidi haringina ba labu dibala lipu tela manau tai. ");
INSERT INTO met_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Baing harua ba, “Lipua Ma Rangua Urana bagula xap salak xumana. Lipu haringindi, lipu hananiangamdi yanamidingdi xaung lipu hanaunaunga tubatubainganamdi bagula dihitixiya, dung mati, ne mana xaidap tuwa bagula mesa muli.” ");
INSERT INTO met_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Baing harua na ding longgalo ba, “Lipu gaxarea dibo ba dinaxu manga, bing dahalingalinga murungadinga, xaidap taining tainina diti doxoxi xaiding balingamdi, saing dinaxu manga. ");
INSERT INTO met_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Lipu gaxarea dituxu haringina walingadinga, bing bagula dahanggalang. Ne lipu gaxarea diyunga walingadinga bu dinaxu manga, bing bagula daxap walinga sibuna. ");
INSERT INTO met_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nabu lipu tela xap axamang titiam longgalo, ne ina walinganoa hanggalang, bing axadi bagudi li bagula daxap ina muli baru? ");
INSERT INTO met_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Lipu gaxarea memeyading manga xaung haruangagua, bing kimuya Lipua Ma Rangua Urana bagula memeyana manadi, bungina ma liwe mana ralanoa, liwe mana Tibuna ralanoa xaung liwe mana Urana uleginam maringindi raladinga. ");
INSERT INTO met_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Maxung sibuna ngabalang ba, ang teladi awa la li, bagula amati teguyu saing bagula abagu Urana Yonggaxinoa.” ");
INSERT INTO met_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu harua haruanga baguba saing bila xaidap 8 disup, baing xap Pita, Yon, Yems dingtung mala ranguaina saing dahaing mana bimbi tela ba sabu. ");
INSERT INTO met_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesu sabu mua saing ramramonoa xugia xan tela. Imangindi disina bila bilikbilik ralandi. ");
INSERT INTO met_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Lipu luwa, Moses xaung Elaitsa, ");
INSERT INTO met_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","tang dowa masok, long xaiya ralanoa lu taxiyadi, saing daharua rangua Yesu. Daharua mana ilainganoa haxek bagula sok kimuya mana sahi oxatanoa long sabangga Yerusalem. ");
INSERT INTO met_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kinungua ung Pita gabu riandi, ne bungina dibaguti, dibagu Yesu ralanoa xaung lipu luwa ba dili rangua. ");
INSERT INTO met_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moses Elaitsa tang dibo ba diyunga Yesuba, baing Pita harua na Yesu ba, “Lipu Sabanga, xai sibuna tawa la li. Amtum gabo ba am gatongtongia xahi tuwa—tela naung, tela na Moses, xaung tela na Elaitsa.” (Pita xabia te mana baru haruanganta.) ");
INSERT INTO met_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Bungina Pita harua, mugap tela sok saing kaudi, saing tung dimaxuwa bungina mugaba kaudi. ");
INSERT INTO met_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Waxutu tela sok mugabia ma, harua ba, “Alali Garagu sibuna, lipua ngamogu ba. Angtung galungu haruanganoa!” ");
INSERT INTO met_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Waxutua harua laing sup, baing tung dibagu Yesu ing ganina wa. Tung dihisa mana alaba rangua ding, saing mana bungina baguba daharua na lipu tela mana baraxinta dibagu te. ");
INSERT INTO met_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Buragina baing diri mala bimbia. Disok saing buranga sabanga digugunia rangua Yesu. ");
INSERT INTO met_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Lipu tela burangia wagi ba, “Lipu Tubatubaingam, ngaxusungaung haringina ba uhauli garagua. Nga garagu taininau ing ganina. ");
INSERT INTO met_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Bunging xumana xaunga tuxu haringina bing libu xaba hata sibuna li, ting mari, libu lulu haringina saing gaunggauna. Xaungua yunga monga te, saing hanggalangia sibuna mua. ");
INSERT INTO met_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Menau ngaxusunga haringina lipuximdi dinaxu maung ba disuka mala, ne ding sanga te.” ");
INSERT INTO met_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Baing Yesu harua nadi ba, “Ai, ang hatatamdi ahatum haringin te. Kuboluimdi dimaring te. Xaidap baru bagula ngawauyu ranguang saing ngaxap salaga mang? Oxop garama ma la li to.” ");
INSERT INTO met_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Gananuna mauyu baing xaungua ting mari titia saing libu lulu haringina. Ne Yesu bili xaungua, hamaringia gananuna, saing sina muli na tibuna. ");
INSERT INTO met_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Baing ding longgalo dihixi mana Urana haringingang sabanga. Lipudi dihixiyu mana axamandi Yesu libudi, baing Yesu harua na lipuxindi dinaxu mana ba, ");
INSERT INTO met_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Alungu xai mana hatata ngaharua nang ba: Bagula dita Lipua Ma Rangua Urana bixuandi rimadingia.” ");
INSERT INTO met_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ne daxabia rangrang haruanga ba namua te. Hisa manadi bu daxap xai te, ne dimaxuwa ba duxusunga mana. ");
INSERT INTO met_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Hakhaxinga tela mesa liwe manadi mana dingia baruamta bagula wa mugamuga manadi. ");
INSERT INTO met_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu xabia hatumingadinga, binabu xap gara tela saing ta mali ranguaina. ");
INSERT INTO met_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Baing harua nadi ba, “Lipu gaxarea daxap gara bila li mana yagua, bing daxap nga. Saing lipu gaxarea daxap nga, bing daxap ina soxi nga ma ba. Baing lipu gaxarea wa kimu sibuna mang bing wa mugamuga.” ");
INSERT INTO met_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yon harua ba, “Lipu Sabanga, am gabagu lipu tela suka xaungadi mala mana yama. Am gatuba ba am gabili, namua na kiria tela te.” ");
INSERT INTO met_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ne Yesu harua ba, “Labu abiliu tai, namua na lipu gaxarea dilibu doa mang te, bing ang riaimdi.” ");
INSERT INTO met_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Xaidapka mana Yesu bagula haing mala long xaiya ma haxekkuba, baing Yesu haringia hatuminganoa saing ila long sabangga Yerusalem. ");
INSERT INTO met_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Baing soxi lipu ulekkamdi dimuga mala, diluxu mana long tela wa titia Samaria bu daxauxau axamandi mana. ");
INSERT INTO met_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ne lipudi mana longga baguba daxap Yesu te, namua na haxa mala long sabangga Yerusalem. ");
INSERT INTO met_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Lipuxing luwadi Yems Yon tang dinaxu mana dibagu kuboludinga, baing tang duxusunga ba, “Toxoratamona, ubo ba tawagi yaba ri long xaiya ma bu taudi?” ");
INSERT INTO met_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ne Yesu xugia mala ranguadi saing bili dingtang, ");
INSERT INTO met_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","saing didalidi dila mana long tela muli. ");
INSERT INTO met_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Dahaxa mala daxangia, saing lipu tela harua na Yesu ba, “Long baruamta ula mana, bagula nganaxu maung baing.” ");
INSERT INTO met_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu haxuya ba, “Koma abungindi ding ginangiding, mangdi ding numading, ne Lipua Ma Rangua Urana ina numang te ba kinu.” ");
INSERT INTO met_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu harua na lipu tela muli ba, “Unaxu manga.” Ning lipua haxuya ba, “Toxoratamona, uyunga nga bu ngala ngakimang tibugu to.” ");
INSERT INTO met_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu harua na ba, “Lipudi dahatum haringina manga te duwa bila dimati Urana maxania. Uyunga lipuadi ba dikimang matiadingdi, ne ung ba ula ubaxanga Urana Yonggaxinoa.” ");
INSERT INTO met_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ne tela muli harua ba, “Toxoratamona, bagula ngasu maung. Ne uyunga nga bu ngagoxoya mala ngaharua xai na bakbagigudi to.” ");
INSERT INTO met_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu haxuya ba, “Nabu lipu tela ui xai wagania, ne bungingbunginalo bagu mala muli kimuya, bing sanga ba tuxu oxatua Urana Yonggaxinia te.” ");
INSERT INTO met_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kimuya, Toxoratamona mogu lup 72 teladi muli, saing soxidi mala luwa luwa bu dimuga mana long longgalo Yesu bo ba ila manadi. ");
INSERT INTO met_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Baladi ba, “Lipudi daxauxau masup ba dilungu haruangaima bila xauyanga sabanga wa umangia, ne lipu oxatam xumana buk te. Binabu asabu na umanga Moxonoa ba soxi lipu oxatamdi mala bu daxauya umanganoa. ");
INSERT INTO met_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Alauba! Bagu ngasoxiang mala bila sipsip tutubindi dila liwe mana koma abungindi. ");
INSERT INTO met_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Daba sianggam, tanga, xai sanggandi, araidi malau tai. Saing ahalisi mana aharua rangua lipu tela asok mana daxangiau tai. ");
INSERT INTO met_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Bungina aluxuʼm numa tela, bing muga aharua ba, ‘Gamogamu mosiu wa ranguang.’ ");
INSERT INTO met_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nabu lipu gamogamu mosiam tela wa la ba, bing gamogamu mosiu bagula ila mana. Ning tegu, bing gamogamu mosiu bagula goxoya ma muli ranguang. ");
INSERT INTO met_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Awa mana numa ba, axang anung baraxing baraxinta duliang, namua na lipudi dituxu oxatua bing giminagiding. Ahixihixi mana numadiu tai. ");
INSERT INTO met_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Bungina aluxu long tela saing daxapkang, bing axang baraxing baraxinta duliang. ");
INSERT INTO met_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Asahi busingadi mana lipu busingamdi duwa la ba, saing abaxanga nadi ba, ‘Urana Yonggaxinoa ma haxek ranguang ba.’ ");
INSERT INTO met_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ne bungina aluxu mana long tela saing daxapkang te, ang gala ali mana daxangadingdi saing aharua ba, ");
INSERT INTO met_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Yabaima gagabindi ditaga kimam lunia, am gatingtingdi bu hatanga ba awa haruangia. Ne ahatumia alali: Urana Yonggaxinoa ma haxek ba.’ ");
INSERT INTO met_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ngabalang ba, mana xaidap subinganoa, salaga lipuadi duwa mana longga ba bagula daxap, bagula sabanga mana salaga long sabangga Sodam daxap. ");
INSERT INTO met_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasindi, laku, mauxanganoa xapkang yu! Betsaidadi, laku, mauxanganoa xapkang yu! Axamang haringindi disok liwe mang, nabu waleu sibuna disok liwe mana Tayadi xaung Saidondi, bing ding sanga ba duxugia hatumingadingdi, disau imang usingangamdi saing dirung hayatia lo. ");
INSERT INTO met_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ne mana xaidap suxuyangama, salaga axap bagula sabanga mana salaga Taya, Saidon daxap. ");
INSERT INTO met_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ne ang Kaperneamdi ba, bola bagula ditiang eta lo sibuna? Tegu sibuna. Bagula ari hawa sibuna Matiadi Yabadingia. ");
INSERT INTO met_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Lipu gaxarea dilunguang bing dilungu nga. Lipu gaxarea diyamuang bing diyamu nga. Ne lipu gaxarea diyamu nga bing diyamu Urana, ina soxi nga ma ba.” ");
INSERT INTO met_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kimuya Lipu 72 digoxoya ma, gamodingdi diyaha, saing daharua ba, “Toxoratamona, am gauxu yama, baing lipudi disu mana haruangamama, saing xaungadi xauna, disu mana.” ");
INSERT INTO met_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu harua ba, “Ngabagu Satan xung mari bila bilikbilik ri sangua sabalunoa! ");
INSERT INTO met_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Bagu ngasina haringingua nang masup, bu aruha moxadi xaung xahengxahengdi xaung bu adali bixua haringinganoa. Axamang tela sanga ba hanggalangiang te. ");
INSERT INTO met_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ning heku gamoimdi diyaha mana xaungadi disu mana haruangaimdi. Axamang sabanga gamoimdi diyaha mana bing Urana bung yaimdi mari long xaiya ba.” ");
INSERT INTO met_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mana bungina baguba Urana Aningonoa libu Yesu gamonoa yaha sibuna, binabu harua ba, “Tibugu, Toxoratamona mana sabalunoa xaung titia, ngaiti yama namua na uyameng axadi li mana lipuadi dahatumia ba daxabia xai buk, saing uhatangadi na lipuadi duwa bila garadi ba. Maxuna, Tibugu, ulibu bila ba namua na alali ung murungama xai.” ");
INSERT INTO met_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Baing harua muli ba, “Tibugu ta axamang longgalo rimagia ba. Lipu tela xabia Gara te. Tibugu ing ganina xabiau. Baing lipu tela xabia Tibugu te. Garanoa ing ganina xabiau. Garanoa xaung lipu gaxarea Garanoa mogudi ba daxap xabianga mana.” ");
INSERT INTO met_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Bungina ding ganiding duwa, xugia mala rangua lipuxindi dinaxu mana, saing harua nadi ba, “Urana libu xai mang. Maxaimdi dibagu axadi ba daxabiadi. ");
INSERT INTO met_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Namua na ngabalang ba, Urana lipuxing suxunguxunguam xumana xaung xaitamoxi xumana mugauamdi, dibo ba dibagu axadi abagudi, ne dibagudi te. Dibo ba dilungu haruangadi alungudi, ne dilungudi te.” ");
INSERT INTO met_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Bunging tela, lipu tela xabia hanaunaungua xai sibuna mesa ba tuba Yesu. Xusunga ba, “Lipu Tubatubaingam, ngaria baru bu ngaxap walinga subingang teguam?” ");
INSERT INTO met_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu haxuya ba, “Dibung baru mana Urana hanaunaunganoa? Utiti baru?” ");
INSERT INTO met_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Haxuya ba, “ ‘Bing ung murum sibuna mana Toxoratamona Urana ungia mana gamom longgalo xaung lum longgalo xaung hatumingam longgalo xaung haringingam longgalo’, xaung ‘Bing ung murum sibuna mana riam longgalo bila ung murum sibuna maung.’ ” ");
INSERT INTO met_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu haxuya ba, “Ina naga, uhaxuya xai. Ulibu bila ba baing bagula oxop walinga subingang teguama.” ");
INSERT INTO met_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ne lipua ba bo ba hatanga ba kubolunoa sanga mana walinga subingang teguama, binabu xusunga Yesu ba, “Ne gaxarea riagua?” ");
INSERT INTO met_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Baing Yesu haxuya haruanga babung tela ba, “Yuda tela yunga long sabangga Yerusalem, ri mala long sabangga Yeriko. Baing ina naga, lipu hanaunggamdi dituxuba. Dunia imangindi sangua, ditahataha saing diyunga bila ba. Baing lipua bo ba matiuba. ");
INSERT INTO met_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mana bungina baguba, Yuda hananiangam tela haxa daxangia ma. Bungina bagu lipua ba, kisi daxanga hataina saing dali. ");
INSERT INTO met_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Bila balau, lipu tela ma muli, lipu Urana Numang oxatanam tela. Bungina sok mana longga lipua wa mana ba, kisi hataina saing dali. ");
INSERT INTO met_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ne Samaria tela haxa ma, sok mana longga lipua wa mana ba. Bungina bagu, usingauba. ");
INSERT INTO met_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ila rangua saing matu guxenga xaung wain mari mana saxandi. Haudi laing sup, baing ta mahaing ing sibung donki inia, xai mala lobu numang tela saing wasa xai mana. ");
INSERT INTO met_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Buragina baing xap siang silba mukiring luwa saing sinadi na lobu numang moxonoa. Harua ba, ‘Uwasa mana. Bungina ngagoxoya ma, nabu sianggadi ba sanga tate, bagula ngahaxuya teladi muli naung.’ ");
INSERT INTO met_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Tauna, mana dingtung baruamta uhatum ba riana mana lipua xap doa mana lipu hanaunggamdi?” ");
INSERT INTO met_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Lipua xabia hanaunaunga xai sibuna haxuya ba, “Lipua ba usinga.” Baing Yesu bala ba, “Ula. Ulibu bila ba.” ");
INSERT INTO met_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu gabu lipuxindi dinaxu mana dahaxa mala, disok mana long tela. Baing ina naga, haing tela wa la ba, yanoa Marta, xap Yesu mala numania. ");
INSERT INTO met_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta ba kixinginoa, yanoa Maria. Maria ma rung mua haxek Toxoratamona kinia saing lungu haruanganoa. ");
INSERT INTO met_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ne Marta hatum xumana buk mana xauxau axamandi manadi. Binabu ma rangua Yesu saing harua ba, “Toxoratamona, kixingigua yunga nga ba nga ganigu ngatuxu oxata sabangga li. Bola uhatum manga te? Ubala ba hauli nga!” ");
INSERT INTO met_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ne Toxoratamona haxuya ba, “Marta, Marta, uhatum xumana buk, gamoma doa mana axamang xumana, ");
INSERT INTO met_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ning axamang sabanga taininau ing ganina bing uhatum mana. Axa Maria bo ba xap bing axamang xai sibuna. Bagula ngaunia sangua te.” ");
INSERT INTO met_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Bunging tela Yesu sabu long tela. Sabu laing sup, baing lipuxing tela naxu mana harua na ba, “Toxoratamona, utubatubam ba am gasabu, bila Yon tubatuba lipuxindi dinaxu mana.” ");
INSERT INTO met_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Harua nadi ba, “Bungina asabu, aharua bila li: “ ‘Tibumam, yama am gabo ba lipu longgalo dahatum ba maringing sibuna. Yonggaxima bing ma. ");
INSERT INTO met_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Xaidap taining tainina uliam anginga sanga mana xaidapka ba. ");
INSERT INTO met_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Uyunga kubolumam diandi, bila am gayunga lipu longgalo kuboluding diandi dilibudi mam. Saing labu uyungam mala tubaigiau tai.’ ” ");
INSERT INTO met_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Baing Yesu harua nadi ba, “Nabu lipu tela yambong lia ila rangua rianoa saing harua ba, ‘Riagu, ngabo ba ulia nga salanga tuwa, ");
INSERT INTO met_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","namua na riagu tela haxa mauli ba ma rangua nga, ne nga angiagu te ba ngaulia.’ ");
INSERT INTO met_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Baing lipua wa numa lunia haxuya ba, ‘Usina makasanga nangau tai. Xalua ribaina ba, saing ngagabu garagudi am gakinu ba. Sanga ba ngamesa ngauliaung axamang tela te.’ ");
INSERT INTO met_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ngabalang ba, ing rianoa, ne mana namua baguli bagula hauli te. Tegu. Ning namua na rianoa xusunga xusunga buk, baing bagula mesa ulia saing sahi murunganoa, namua na hauxana ba yanoa doa. ");
INSERT INTO met_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Binabu ngabalang ba, axusunga xusunga bing bagula Urana uliang. Asaisai bing bagula abagu. Aringring bing bagula xalua xaxaina mang. ");
INSERT INTO met_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Namua na lipu gaxarea duxusunga bing bagula daxap. Lipu gaxarea disai bing bagula dibagu. Saing lipu gaxarea diringring bing xalua bagula xaxaina manadi. ");
INSERT INTO met_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Nabu angia tela garanoa xusunga tibuna mana song tela, bing bola tibuna bagula ulia moxa? Tegu. ");
INSERT INTO met_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kimbo nabu xusunga mana hataxuna, bing bola tibuna bagula ulia xahengxaheng? Tegu sibuna. ");
INSERT INTO met_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tauna, ang ba lipu kubolu dianamdi, ning ang gaxabia xai mana aulia garaimdi yahanga xaidi. Baing ina naga, Tibuim wa long xaiya bungingbunginalo dali kuboluimdi, binabu bagula sina Aningonoa na lipu gaxarea duxusunga mana!” ");
INSERT INTO met_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Xaidap tela Yesu suka xaunga mala, libu lipu tela harua tate. Xaunga ila sup, baing lipua menau mumguti ba harua. Baing buranga dihixi mana. ");
INSERT INTO met_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ne dingia teladi daharua ba, “Suka xaungadi mala mana yanamidinga Belsabul haringinganoa.” ");
INSERT INTO met_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ne teladi dibo ba dituba, binabu duxusunga ba libu axamang haringing tela bu hatanga ba Urana soxi ma. ");
INSERT INTO met_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu xabia hatumingadingdi, binabu harua nadi ba, “Nabu yongga tela dutu ding, bing bagula dahanggalang. Nabu numa tela dutu ding, bing bagula disup. ");
INSERT INTO met_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ne nabu Satan utuina, sina haringinga nanga bu ngasuka ing xaungandi bila aharua ba, bing yonggaxinoa sanga ba li baru? ");
INSERT INTO met_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ang gaharua ba ngasuka xaungadi mana yanamidinga Belsabul haringinganoa. Ne ang lipuximdi dinaxu mang, disuka xaungadi xauna. Ne disukadi mana gaxarea haringinganoa? Bola aharua ba Belsabul haulidi xauna? Baing ina naga, lipuximdi dinaxu mang oxatadinga ba hatanga haruangaima asu manga ba maring te. ");
INSERT INTO met_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ne namua ngasuka xaungadi mana Urana rimang haringinganoa, bing hatanga ba Urana Yonggaxinoa ma, sok mang. ");
INSERT INTO met_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Bungina lipu haringingama tuxu guluna waxangina saing wasa mana ing sibung numanoa, bing xalingindi duwa sangau. ");
INSERT INTO met_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ne bungina lipu haringinganoa dali inia ma haunggana, saing hanggalangia, bing xap guluna waxangina menau lipua hatum haringina manadi mala, saing tuxu sinak mana xalingindi. ");
INSERT INTO met_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Lipu gaxarea dirau nga te, bing bixuagudi. Lipu gaxarea duwaxata rangua nga te bu am gaxai lipudi mala rangua Urana, bing disukadi mala sangua Urana. ");
INSERT INTO met_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Bungina xaunga tela sok ma sangua lipu tela, ila luxu mana long xoliandi bu sai yaguanga, baing tegu. Baing harua ba, ‘Bagula ngagoxoya mala mana numa muga ngawa mana baing.’ ");
INSERT INTO met_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bungina sok mana, bagu lipua ba wa bila numa sogoxoyangam, wa maringina ba, ne wa olang. ");
INSERT INTO met_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Baing ila xap xaunga 7 diang sibundi mana ina, dima diluxu saing duwa mana. Baing ina naga, hatata walinganoa sok doa sibuna mana muga.” ");
INSERT INTO met_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu harua mana axadi ba, baing haing tela wa burangia wagi ba, “Xai sibuna mana hainga hayaung saing sina sua naung!” ");
INSERT INTO met_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ning Yesu haxuya ba, “Heku. Xai sibuna mana lipuadi dilungu Urana Xuanoa saing disu mana.” ");
INSERT INTO met_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Buranga dimauyu, baing Yesu harua ba, “Lipu hatatamdi diang sibundi. Disaisai ba dibagu axamang haringina. Ne axamang haringing taininau ing ganina bagula dibagu ba: Bagula wa bila axamana sok mana Urana lipuxing suxunguxunguama Yona. ");
INSERT INTO met_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yona wa hatangangua na Ninibedi. Bila balau, bagula Lipua Ma Rangua Urana wa hatangangua na lipu hatatamdi. ");
INSERT INTO met_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Waleu sibuna Xaitamoxi Haing mana numanuma Siba ma titi subingania ma bu lungu Solomon xabiangang maringina. Ne hatata tela dali sibuna Solomon wa la li, ne hauxaim ba alungu haruanganoa. Binabu bungina Urana suxuya lipudi, haingga ba bagula mesa saing li Urana maxania ranguang, saing su haruanga nang lipu hatatamdi. ");
INSERT INTO met_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Waleu sibuna Yona baxanga na lipu Ninibeamdi saing duxugia hatumingadingdi. Ne hatata tela dali sibuna Yona wa la li, ne hauxaim ba axugia hatumingaimdi. Binabu bungina Urana suxuya lipudi, Ninibedi bagula dimesa saing dili Urana maxania ranguang, saing disu haruanga nang lipu hatatamdi. ");
INSERT INTO met_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Lipu tela sanga ba tung nagung tela saing ta long hisangamia te, kimbo kaukau minia te. Tegu. Ta mahaing yabania bu lipudi diluxu sanga ba dibagu saxaxanganoa. ");
INSERT INTO met_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Maxama bila sanggama nagunginoa. Bungina maxamdi daxai, luliadinga saxaxangia sanggam longgalo. Ne bungina didoa, sanggam longgalo dilaba. ");
INSERT INTO met_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Binabu uwasa xai mana lulianoa wa maluxu maung bu laba te. ");
INSERT INTO met_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nabu sanggam longgalo dibaxagi mana luliana, long tela laba te, bing bagula saxaxangana masup, bila bungina nagung saxaxanganoa saxaxangiaung.” ");
INSERT INTO met_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu harua laing sup, baing Parisi tela xusunga Yesu ba ma bu xang rangua. Baing ina naga, ila numania saing kinuʼm tabu kabukabu xangingamia. ");
INSERT INTO met_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ne Parisi hixi mana Yesu kubolunoa, namua na damia rimandi muga mana xang te. ");
INSERT INTO met_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Baing Toxoratamona harua na ba, “Ang Parisidi, kubolua alibu bila adamia xuba mina ubudingdi, ne ludingia dibaxagi mana axadi axapdi mana kubolu samoyana xaung kubolu diandi. ");
INSERT INTO met_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ang lipu kakahandi! Urana tongtongia sabasabam, saing tongtongia luna xauna, maxuna? ");
INSERT INTO met_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Asina haulinga taxa luimia na haxugindi, baing ina naga, bagula abagu awa sigixinga Urana maxania. ");
INSERT INTO met_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ang Parisidi, laku, mauxanganoa xapkang yu! Asina hataina 10 mana axamang kaxukang sibundi duwa umangaimia. Ne ahalingalinga suxuyanga maringina xaung kubolua muruim sibuna mana Urana. Maring bing asina hataina 10, wane, ne labu ahalingalinga kubolu teladi bau tai. ");
INSERT INTO met_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ang Parisidi, laku, mauxanganoa xapkang yu, namua na ang muruim buk mana arung mana kabukabu mugamugangamdi mana sabunga numandi, xaung ang muruim buk mana lipudi ditiang daharua xaidap xai nang mana nawa yabandi. ");
INSERT INTO met_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Laku, mauxanganoa xapkang yu, namua na awa bila gobagoba ragung teguamdi, lipu dahaxa mala diruhadi daxabia te.” ");
INSERT INTO met_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Lipu tela xabia xai sibuna mana hanaunaunga haxuya Yesu haruanganoa ba, “Lipu Tubatubaingam, bungina uharua bila ba na Parisidi, utatuam xauna.” ");
INSERT INTO met_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu haxuya nadi ba, “Baing ang lipuadi axabia hanaunaunga xai sibuna, laku, mauxanganoa xapkang yu, namua na ata mauxangandi etua mana lipudi, ding sanga ba doxoxi xai te. Saing ang sibuim ahaulidi monga te. ");
INSERT INTO met_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Laku, mauxanganoa xapkang yu, namua na atongtongia guha gobagoba gumangindi mana Urana lipuxing suxunguxunguamdi, ne ang mugangaimdi dungdi mati ba. ");
INSERT INTO met_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Baing ina naga, anai mana axa mugangaimdi dilibu baing. Ding ba dung Urana lipuxing suxunguxunguamdi ba mati, saing ang ba, ang gayauyau guhia gobagobadingdi olang—ne ang gasu mana haruangadinga te! ");
INSERT INTO met_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Namua naga Urana, xabianganoa tubu, harua ba, ‘Bagula ngasoxi lipuxigu suxunguxunguamdi xaung aposeldi nadi. Teladi bagula dungdi mati, teladi bagula disina salaga nadi.’ ");
INSERT INTO met_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Binabu lipu hatatamdi, bagula duwa haruangia mana siba ri mana Urana lipuxing suxunguxunguam longgalo, siba mana titia soginganoa, ");
INSERT INTO met_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","mana Ebal, ma ma laing Sekaraya ina dung liwe mana kabukabu hananiangam xaung Urana Numang luna. Maxung sibuna ngabalang ba, lipu hatatamdi bagula duwa haruangia mana ding longgalo sibidingdi. ");
INSERT INTO met_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Laku, ang lipuadi axabia hanaunaunga xai sibuna, mauxanganoa xapkang yu, namua na ayameng Urana xaluxing xabiangama mana lipudi. Ang sibuim aluxu Urana xabiangania te, saing asina makasangua na lipu teladi dibo ba diluxu xauna.” ");
INSERT INTO met_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu bo ba ilauba, baing Parisidi digabu lipu hanaunaunga tubatubainganamdi dungguti daharungia haringina, saing duxusunga xusunga xumang sibuna ");
INSERT INTO met_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","bu dituxu murak mana ba harua mana axamang tela bu dita haruangia. ");
INSERT INTO met_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mana bungina baguba buranga sabanga sibuna digugunia, laing dahabisibisi diruha ding, baing Yesu ungguti baxanga muga na lipuxindi dinaxu mana, harua ba, “Amaxania, nam asok lipu manang luwamdi bila Parisidi. Kuboludinga kisi mana teladi bila yis, axamana libu salanga salalanga ba, hasangia salanga hataing longgalo. ");
INSERT INTO met_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Axamang longgalo duwa ulumia bagula disok sabasabia, saing axamang longgalo dihisa bagula disok menea. ");
INSERT INTO met_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Bila balau, baru haruanganta aharua labiania bagula dilungu luliania, saing baru haruanganta ahabolabola numa lunia bagula duwagi gananga liwe. ");
INSERT INTO met_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Riagu mana, ngabalang ba amaxuwau tai mana lipuadi dibo ba dung sanggaimdi mati, saing kimuya sanga ba dilibu axamang tela muli mang te. ");
INSERT INTO met_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ne nga bagula ngahatanga nang ba gaxarea bing amaxuwa mana: Amaxuwa mana ina sanga ba ung lipudi saing kimu haringinganoa sanga ba tingdi mari long salakkamia. Maxung sibuna, ngabalang ba, amaxuwa mana! ");
INSERT INTO met_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mangdi axamang olangdi. Sanga ba agim luwadi luwadi hiliadinga mana siang kaxukang mukiring luwa. Ne Urana sanga ba halingalinga tela te! ");
INSERT INTO met_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Maxuna, Urana xabia axamang longgalo duwa mang xauna. Xabia toxoloim baru duwa mana toxoimdi! Baing ina naga, labu amaxuwau tai. Adali sibuna mangdi Urana maxania. ");
INSERT INTO met_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ngabalang ba, lipu gaxarea dibaxanga na lipudi ba dinaxu manga, bing Lipua Ma Rangua Urana bagula baxanga Urana uleginamdi maxadingia ba dinaxu mana. ");
INSERT INTO met_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ne lipu gaxarea dahatiam manga lipudi maxadingia, bing bagula ngahatiam manadi Urana uleginamdi maxadingia. ");
INSERT INTO met_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Baing lipu gaxarea daharua diana mana Lipua Ma Rangua Urana, bing Urana bagula yunga kuboluding diandi. Ning lipu gaxarea daharungia Urana Aningonoa, bing bagula yunga kuboluding dianoa te. ");
INSERT INTO met_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Bungina dituxuang daxaiang mala haruangia mana Yudadi sabungading numandi, ba ali xaitamoxidi xaung yanamdi maxadingia, bing labu ahatum xumana buk mana ahauliang xaung baru haruanganta bagula aharua manau tai. ");
INSERT INTO met_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Namua na Urana Aningonoa bagula tubatubang baru haruanganta bagula aharua taxa mana bungina baguba.” ");
INSERT INTO met_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Lipu tela wa burangia harua na Yesu ba, “Lipu Tubatubaingam, ubala sabangagua ba hata xalaxala hataindi nanga tibumam yungadi rangua amtam bungina mati ba.” ");
INSERT INTO met_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu haxuya ba, “Lipu, gaxarea mogu nga ba ngawa lipu suxuyangam kimbo lipu aningoxam mangtang?” ");
INSERT INTO met_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Baing harua nadi ba, “Amaxania! Awasa xai, nam kubolu xawangam xangxana xapkang. Nabu lipu tela xalinging xumana bing axadi bagudi ba sanga ba disina walingua na te.” ");
INSERT INTO met_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Baing baladi haruanga babuna baguli ba: “Lipu xalaxalam tela umanganoa ua xumana. ");
INSERT INTO met_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Hatumiaina ba, ‘Ngaria baru? Nga numagu angingam sabanga te ba ngagugunia angiagudi.’ ");
INSERT INTO met_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Baing ina naga, harua ba, ‘Bagula ngalibu bila li. Bagula ngaxui numagu angingamdi mari, saing bagula ngatongtongia haung sabangadi. Baing bagula ngagugunia xauyangagudi xaung angiagudi la ba. ");
INSERT INTO met_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Baing bagula ngaharua nanga ba, “Nga angiagu xumana ngaguguniadi ba. Sangaʼm niani xumana. Ngarung mosiu, ngaxang, nganung xaung ngayaha.” ’ ");
INSERT INTO met_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ning Urana harua na ba, ‘Ung lipu kakahana! Yambongga baguli ung bagula umati. Baing gaxarea bagula xap xalaxaladi uxauxaudi masup maung? Tegu!’ ");
INSERT INTO met_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Lipu gaxarea digugunia xalingidingdi, ne hatumingadingdi dimesa mana Urana te, bing bagula duwa bila ba.” ");
INSERT INTO met_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Baing Yesu harua na lipuxindi dinaxu mana ba, “Binabu ngabalang ba, labu ahatum xumana mana walingaimdiu tai, axang baraxintau, kimbo mana sanggaimdiu, asau baraxintau tai. ");
INSERT INTO met_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Walinga axamang angingam ing ganina te. Sangga axamang imanggam ing ganina te. ");
INSERT INTO met_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ahatumia okokdi: Duxuma te, daxauya te. Ding numading guguniangam te, ding numading angingam te. Ne Urana haxangdi. Baing ang gadali mangdi maxania! ");
INSERT INTO met_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Baruta? Sanga ba hatumingaim xumana sigi xaidap taininau mana walingaimdi? Tegu! ");
INSERT INTO met_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Sanga ba alibu axamang kaxukana li te, binabu baruta ahatum xumana mana axamang teladi? ");
INSERT INTO met_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ahatumia haidangadi, dahaing baru. Duwaxata te, ditongtongia imangidingdi te. Ning ngabalang ba, haidangadi ba gumangidinga xai sibuna mana Xaitamoxi Solomon yauyaungandi, ina waleu yauyau xai sibuna ba. ");
INSERT INTO met_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nabu Urana libu bila ba mana haidanga abungindi, hatata duwa, ne buragina lipudi ditaudi yabia, bing maxung sibuna bagula yauyauang xai sibuna. Ang hatumingaim haringina kaxukana buk! ");
INSERT INTO met_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Baing ina naga, mana baraxinta bagula axang anung, labu ahatum asai xumana bukku tai. ");
INSERT INTO met_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Namua na lipudi daxabia Urana te disaisai mana axadi ba, saing Tibuim xabia ba araxap manadi. ");
INSERT INTO met_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ne asai mana Yonggaxinoa ing ganina, bing bagula uliang mana axadi ba xauna. ");
INSERT INTO met_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Sipsip guguniangagu kaxukana mana, amaxuwau tai, namua na Tibuim gamonoa yaha ba sina Yongga nang. ");
INSERT INTO met_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Asina xalingimdi bu asina giminagidingdi na lipu haxugindi, baing bagula axap axamandi long xaiya. Long xaiya xalingindi bagula muganga te, bagula disup te, bagula tela hanaidi te, bagula binadi dahanggalangiadi te. ");
INSERT INTO met_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Longga xalingimdi duwa mana, la ba murungaima wa xauna. ");
INSERT INTO met_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Axauxauang bu atuxu oxatua saing atung nagungimdi, ");
INSERT INTO met_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","bila lipudi diragu lipuxiding haringina goxoya taunga yaungamia ma. Diragu goxoya ma bu daxaxa xalua mana sap bungina ma ringring. ");
INSERT INTO met_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bagula wa xai mana lipu haulingamgadi ba, nabu lipuxiding haringina goxoya ma saing bagudi duwasa xai. Maxung sibuna ngabalang ba, lipuxiding haringina ba bagula sausau imanging oxatamdi bu haulidi saing baladi ba dirung kabukabia bu haxangdi. ");
INSERT INTO met_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bagula wa xai mana lipu haulingamgadi ba bungina lipuxiding haringina bagudi daxauxau masup ba, nabu lipuxiding haringina goxoya ma yambong sibuna kimbo buraraging sibuna. ");
INSERT INTO met_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ne ahatumia: Nabu numa moxonoa xabia muga xaidap maxanoa lipu hanaunggama bagula ma, bing sanga ba yunga numanoa te bu hanai. ");
INSERT INTO met_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ang xauna bing axauxau bungingbunginalo, namua na Lipua Ma Rangua Urana bagula ma bungina ahagaxa ba bagula ma te.” ");
INSERT INTO met_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Baing Pita xusunga ba, “Toxoratamona, ubaxanga haruanga babuna li nam ganimam, kimbo na lipu longgalo xauna?” ");
INSERT INTO met_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Toxoratamona haxuya ba, “Lipu wasangam xabiangang xai xaung tuxu oxatang longgalo xai, lipua na bila baru? Ahatumia. Bila lipua numa moxonoa mogu ba ulia lipuxing haulingamdi angiadinga mana bungina mogu ba. Baing ila haxa mauli. ");
INSERT INTO met_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nabu lipu oxatamga ba tuxu oxatanoa bungina moxonoa goxoya ma, bing numa moxonoa bagula yaha sibuna mana. ");
INSERT INTO met_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Maxung sibuna ngabalang ba, bagula mogu ba wasa mana xalinging longgalo. ");
INSERT INTO met_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ne nabu lipu oxatamga ba balaina ba, ‘Lipuxigua haringina bagula goxoya ma sap te,’ binabu ungguti taha lup haing haulingamdi, xang xumana saing nung lang haringina buk. ");
INSERT INTO met_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Numa moxonoa bagula goxoya ma mana xaidap tela lipu oxatama hagaxa te xaung xaidap maxanoa xabia te. Numa moxonoa bagula hanggalangia lipuxing oxatama saing ta mana longga lipudi disu maringina mana te duwa. ");
INSERT INTO met_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Lipu haulingamdi ding daxabia lipuxiding haringina murunganoa saing daxauxau te, dilibu lipuxiding haringina murunganoa te, bagula ditahadi xumang sibuna. ");
INSERT INTO met_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ning lipu gaxarea daxabia te, saing dilibu lipuxiding haringina murunganoa te, bagula ditahadi xumana buk te. Lipu gaxarea Urana sina xumana nadi, bing sanga ba dirung olang te. Tegu. Urana bo ba lipuadi ba bagula aningoding xai sibuna. ");
INSERT INTO met_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ngama bu ngating yaba titia. Ne nga murugu buk ba lu masup! ");
INSERT INTO met_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ning bagula ngaxap langa, ne bagula sala. Ngahatum xumang sibuna mana, saing ngabo ba xaidapka ba ma, bu sup sap! ");
INSERT INTO met_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ahagaxa ba ngama bu ngaxap gamogamu mosiama ma titia? Tegu. Ngama ba ngaxap utungua ma. ");
INSERT INTO met_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Bagula duwa utungia, namua na teladi dahatum haringina manga, ne teladi tegu. Mana hatata saing ila bagula bakbak luwadi luwadi hiliadinga dutu ding ba disok bixuadi. Luwa hiliana bagula dutu disok bixuadi mana luwa, saing luwa bagula dutu disok bixuadi mana tuwa. ");
INSERT INTO met_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bagula duwa bila ba. Tibuna bagula sok bixua mana garang luba, saing garanoa bagula sok bixua mana tibuna. Bauwa bagula sok bixua mana nanuhanginoa, saing nanuhanginoa bagula sok bixua mana bauna. Haing tela bagula sok bixua mana bisanoa, saing bisanoa bagula sok bixua mana hainga.” ");
INSERT INTO met_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu bala burangua ba, “Bungina abagu mugap tela sok yuwaxa, bing hata sibuna li aharua ba, ‘Kuya ma lo,’ saing ma. ");
INSERT INTO met_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Baing bungina yanga ma karagia, aharua ba, ‘Bagula xaidaba xani,’ baing sok bila ba. ");
INSERT INTO met_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ang lipu manang luwamdi! Ang sanga ba abagu titia sabalunoa saing axabia namuxinoa. Ne baruta axabia axadi Urana libudi hatata te? ");
INSERT INTO met_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Alibu kubolu maringina! Hatata ganangana angia. Ahatum to. ");
INSERT INTO met_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bungina uhaxa mala haruangia rangua bixuama, muga utuba haringina ba ahamaringia haruangua sap daxangia. Nam xaiung mala rangua lipu suxuyangama, saing lipu suxuyangama bagula taung lipu ruanggam rimania, saing lipu ruanggama bagula taung salak yabania. ");
INSERT INTO met_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ngabalaung ba, bagula diyungaung masok sangua sap te. Bagula uwa laing ugim haxuyangama masup to.” ");
INSERT INTO met_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mana bungina baguba, lipu teladi duwa dinaxuya na Yesu mana gabana Pailat ung Galili teladi mati bungina dahanania. ");
INSERT INTO met_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu haxuya ba, “Ang gahatum Galiliadi ba kuboludinga diang sibuna mana Galili longgalo, saing alali naga daxap salaga bila ba? ");
INSERT INTO met_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ngabalang ba, tegu! Ne nabu ang gaxugia hatumingaima te, bing bagula ahanggalang xauna. ");
INSERT INTO met_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ne lipuadi 18 ba dimati bungina numa maxaxaya wa Siloam galaina mari manadi, ahatum ba kuboludinga diang sibuna mana Yerusalem longgalo kuboludinga? ");
INSERT INTO met_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ngabalang ba, tegu! Ne nabu ang gaxugia hatumingaima te, bing bagula ahanggalang xauna.” ");
INSERT INTO met_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Baing baladi haruanga babuna baguli: “Lipu tela xuma xai pik tela wain umangania. Ila sai mana marandi susu. ");
INSERT INTO met_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Binabu harua na lipua wasa mana wain umanganoa ba, ‘Niani tuwa ngama ngasaisai mana xaiya pikka li marandi susu. Utui mari! Sahi titi orandi baru?’ ");
INSERT INTO met_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ne haxuya ba, ‘Lipu sabanga, uyunga mali niani tela muli. Bagula ngaki taxiya saing ngata asaxa taindi mana. ");
INSERT INTO met_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nabu ua niani etuam, bing xai sibuna! Nabu tegu, bing utui mari.’ ” ");
INSERT INTO met_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mana Xaidap Yaguangam tela Yesu tubatuba maluxuʼm Yudadi sabungading numang tela. ");
INSERT INTO met_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Haing tela wa, xaungua hanggalangia laing niani 18 saing sanggandi didoa. Bungingbunginalo yuyu saing sanga li maringina te. ");
INSERT INTO met_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Bungina Yesu bagu, wagi ma rangua saing harua na ba, “Haing, busingama sup ba.” ");
INSERT INTO met_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Baing ta rimandi mana, saing hata sibuna li, li maringina saing iti Urana yanoa. ");
INSERT INTO met_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ne sabungading numang yanaminoa gamonoa doa, namua na Yesu hamaringia haingga ba mana Xaidap Yaguangam, binabu harua na lipudi ba, “Xaidap 6 duwa mana oxatua. Binabu ama bu asok xai mana xaidapkadi ba. Ne mana Xaidap Yaguangam, tegu!” ");
INSERT INTO met_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Toxoratamona haxuya na ba, “Ang lipu manang luwamdi! Mana Xaidap Yaguangam ang taining tainina aluba bulmakau angia kimbo donki angia yabadingia saing axai mala bu nung. Maxuna? ");
INSERT INTO met_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Haingga li Yuda tela, muganganoa Ebraham, ne Satan goxi sanga mana niani 18, bunging maxaxayam. Laku, mana Xaidap Yaguangam baruta sanga ba xap haulingua te mana axamanoa goxi?” ");
INSERT INTO met_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bungina harua bila ba, bixuandi memeyading. Ne lipudi diyaha sibuna mana axamang xai sibundi libudi. ");
INSERT INTO met_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Baing Yesu harua ba, “Urana Yonggaxinoa bila baru? Baru haruangang babunta bagula ngatuba mana? ");
INSERT INTO met_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bila mastat xuyang kaxukang sibung tela lipu tela xap mala xuma umangia. Haing saing sok sabanga bila xai tela, saing mangdi ditongtongia numadingdi mana rimandi.” ");
INSERT INTO met_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Harua muli ba, “Baru haruanga babunta bagula ngatuba mana Urana Yonggaxinoa? ");
INSERT INTO met_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bila yis, axamana libu salanga salalanga. Hainga xap teladi saing xaningxaningdi xaung wit gagabing bori sabanga tuwa laing hasangia salanga hataing longgalo, libu salalanga.” ");
INSERT INTO met_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu haing mala long sabangga Yerusalemguyu, haxa maluxuʼm long kaxukana sabangadi. ");
INSERT INTO met_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Lipu tela xusunga ba, “Toxoratamona, bagula lipu unrangindi ding ganiding daxap walinga subingang teguama?” Harua nadi ba, ");
INSERT INTO met_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Atuba haringina ba aluxu xalu hisiangania, namua na ngabalang ba, xumana bagula dituba ba diluxu, ne ding sanga te. ");
INSERT INTO met_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Bungina numa moxona mesa riba xalua, bagula ali sabasabia, awagi saing axusunga haringina ba, ‘Lipu Sabanga, uxaxa xalua mam!’ “Ne bagula haxuya ba, ‘Ngaxabiang te. Yabaima bi?’ ");
INSERT INTO met_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Baing bagula aharua ba, ‘Am gaxang, am ganung ranguaung, saing utubatubam mana yabamam daxangandi!’ ");
INSERT INTO met_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ne bagula haxuya ba, ‘Ngaxabiang te, ngaxabia yabaima te. Asauya nga alauba, ang lipu kubolu dianamdi!’ ");
INSERT INTO met_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Baing bagula abagu Ebraham, Aisak, Yekop tung xaung Urana lipuxing suxunguxunguam longgalo, ding diluxu Urana Yonggaxinia. Ne ang ba, bungina ngasukang mala, bagula atang haringina saing agaxu waimdi. ");
INSERT INTO met_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yuda Teguamdi bagula dima mana titi hataing longgalo—mana sanga yuwaxa, karaga, kanggua, xaung bukang—bagula dima dirung mana taungua Urana Yonggaxinia. ");
INSERT INTO met_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Bagu maxung sibuna, teladi duwa kimuya bagula duwa mugamugangia, saing teladi duwa mugamugangia bagula duwa kimuya.” ");
INSERT INTO met_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mana bungina baguba Parisi teladi dima rangua Yesu saing daharua na ba, “Uyunga longga li saing ula long tela. Xaitamoxi Herot bo ba unggung mati.” ");
INSERT INTO met_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Haxuya ba, “Ala abaxanga na hugaiya ba, ‘Bagula ngasuka xaungadi mala saing bagula ngahamaringia lipudi hatata xaung buragina, baing mana xaidap tuwa bagula ngasahi oxatagua.’ ");
INSERT INTO met_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ning hatata, buragina, rarauti bagula ngahainghaing mala Yerusalemguyu, namua na Urana lipuxing suxunguxunguamdi dimati mana long olangdi te. Urana lipuxing suxunguxunguamdi dimati Yerusalem ing ganina! ");
INSERT INTO met_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Yerusalem, Yerusalem, ang gaung Urana lipuxing suxunguxunguamdi mati, saing lipudi Urana soxidi nang axatudi siangia mati. Bunging xumang sibuna ngabo ba ngagugunia lipuximdi, bila muxaxu hagaxana gugunia garandi hawa mana banggitongindi, ne hauxaim! ");
INSERT INTO met_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Bagu Urana yunga yabaima saing xola. Ngabalang ba, bagula abagu nga muli te, laing xaidaba aharua ba, ‘Urana sina guxama na lipua li ma mana Toxoratamona yanoa ba.’ ” ");
INSERT INTO met_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Xaidap Yaguangam tela, Yesu ila xang Parisi yanamiding tela numania, saing dibagubagu nabu libu kubolu tela. ");
INSERT INTO met_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Lipu tela rung maxania gabuxana. ");
INSERT INTO met_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu xusunga Parisidi xaung lipudi daxabia hanaunaunga xai sibuna ba, “Hanaunaungua harua ba sangau mana tahamaringia lipudi mana Xaidap Yaguangam, kimbo tegu?” ");
INSERT INTO met_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ne dahaxuya te. Binabu ta rimandi mana lipua ba, libu sok xai saing soxi mala. ");
INSERT INTO met_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Baing xusungadi ba, “Nabu angia tela garanoa kimbo bulmakau inia xung mari lang bangguminia mana Xaidap Yaguangam, bing xai mahaing sap, maxuna?” ");
INSERT INTO met_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Baing haruangading te. ");
INSERT INTO met_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Bungina bagu lipudi dima taungia dirung mana kabukabu yayamdi, baladi mana haruanga babuna li: ");
INSERT INTO met_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bungina lipu tela wagiung ba uma mana taunga yaungam tela, oxop kabukabu yayamgu tai. Nam lipu yayam tela, yanoa dali ungia, ma. ");
INSERT INTO met_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nabu oxop, taunga moxonoa, ina xusungang saing tang gama, bagula ma ranguaung saing balaung ba, ‘Usina kabukabuma na lipua li.’ Binabu bagula ula urung kabukabu olanggam sibung tela saing bagula memeyam. ");
INSERT INTO met_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Alibu bila bau tai. Ning bungina ula taungia, oxop kabukabu olanggam sibuna, bu bungina taunga moxonoa ma, bagula harua naung ba, ‘Riagu, uma urung kabukabu xaiya.’ Saking lipu longgalo duwa la ba bagula dibagu taunga moxonoa sina yaya naung. ");
INSERT INTO met_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Alibu bila ba, namua na Urana bagula tatua lipu gaxarea diti yadingdi, saing bagula sina yaya na lipu gaxarea ditatua ding.” ");
INSERT INTO met_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Baing Yesu harua na taunga moxonoa ba, “Bungina utongtongia taungua, bing uxusunga riamdi, sabangamdi, kixingimdi, bakbagimdi, kimbo lipu xalaxalamdi numading duwa haxek ranguaunggu tai. Namua na sanga ba dahaxuya naung nabu duxusungaung ba uma taungadingia. ");
INSERT INTO met_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tegu. Bungina utongtongia taungua, bing uxusunga lipu haxugindi, lipuadi kiding rimading dahamati, lipuadi kiding didoa xaung lipuadi maxading dahaxatu, ");
INSERT INTO met_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","baing bagula Urana libu xai maung. Lipuadi na bila ba sanga ba dahaxuya naung te. Bagula oxop haxuyangama bungina lipuadi dimaring Urana maxania dimesa muli.” ");
INSERT INTO met_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Bungina lipu tela rung rangua kabukabia lungu alaba, harua na Yesu ba, “Lipu gaxarea bagula daxang taungia Urana Yonggaxinia bing gamodingdi diyaha sibuna.” ");
INSERT INTO met_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu haxuya ba, “Lipu tela xauxau taunga sabanga tela saing wagi lipu xumana dima. ");
INSERT INTO met_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tauna, taunga xaidabinoa sok saing soxi lipuxing oxatama mala bu bala lipuadi xusungadi ba dima ba, ‘Ama to, axamandi ngaxauxaudi masup ba.’ ");
INSERT INTO met_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ning ding longgalo hauxading, dungguti daharua singia. Mugamugangama harua ba, ‘Hata sibuna li ngagim umanga hauna. Ngala ngabagu to. Sanga ba ngama te.’ ");
INSERT INTO met_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Tela harua ba, ‘Hata sibuna li ngagim bulmakau 10, saing ngala ngatubadi to. Sanga ba ngama te.’ ");
INSERT INTO met_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Tela harua ba, ‘Hata sibuna li ngayau, binabu sanga ba ngama te.’ ");
INSERT INTO met_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Baing lipu oxatama goxoya ma, saing baxanga na lipuxing haringinoa. Baing numa moxona atin disala saing tabina lipuxing oxatama ba, ‘Ula sap mana long daxangang sabanga kaxukandi, saing oxop lipu haxugindi dima, lipuadi kiding rimading dahamati dima, lipuadi maxading dahaxatu dima xaung lipuadi kiding didoa dima.’ ");
INSERT INTO met_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Kimuya lipu oxatama ma harua na ba, ‘Lipu sabanga, ngalibu haruangama, ne gananganoa wauyu.’ ");
INSERT INTO met_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Baing lipu oxatam lipuxing haringinoa bala ba, ‘Usauya longa, ula daxanga sabanga kaxukandi duwa ongania, ubala lipu longgalo ba dima bu numagua baxagi. ");
INSERT INTO met_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ngabalaung ba, lipuadi muga ngawagidi ba dima ba, bagula daxang rangua nga taungagia te.’ ” ");
INSERT INTO met_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Buranga sabangadi dahaxa mauli rangua Yesu, baing xugia mala ranguadi saing harua ba, ");
INSERT INTO met_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nabu lipu tela ma rangua nga, saing murunganoa mana tibuna xaung bauna, mana haininoa xaung garandi, mana sabangandi xaung kixingindi xaung hamungandi, xaung mana ing sibuna walinganoa, nabu murunganoa manadi dali murunganoa manga, bing sanga ba su mangau tai. ");
INSERT INTO met_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Baing lipu gaxarea doxoxi xaiding balingama te, bing sanga ba disok lipudi dinaxu mangau tai. ");
INSERT INTO met_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Bila li. Nabu angia tela bo ba tongtongia numa sabanga tela. Muga bing hamaringia hatuminganoa, saing hatumia sianginoa bu xabia ba sanga mana, kimbo tegu. Maxuna? ");
INSERT INTO met_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nam ungguti tongtongia saing siangindi disup. Lipu longgalo dibagu bagula dimasisia, ");
INSERT INTO met_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","daharua ba, ‘Abagu lipua ba kakahana. Ungguti oxatua, ne sanga ba sahi te!’ ");
INSERT INTO met_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Kimbo nabu xaitamoxi tela bagula haunggana xaitamoxi tela. Muga bing hamaringia hatuminganoa saing hatumia lipuxing haungingamdi 10,000 sanga ba didali bixua haungingamdi 20,000 dima. Maxuna? ");
INSERT INTO met_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nabu sanga te, bungina bixuanoa wa hasoyauyu, bagula soxi ulekkamdi mala rangua bu duxusunga ba, ‘Ngaria baru bu tahau haruanga gamogamu taininam?’ ");
INSERT INTO met_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Bila balau, ahatum to. Lipu gaxarea diyunga xalingidingdi muga te, bing sanga ba disok lipudi disu manga te. ");
INSERT INTO met_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ang bila mosaga. Mosak axamang xai. Ang sanga ba ata lipu titiamdi daxanga maringinia bu walingadingdi didau bila mosak sanga ba hauli angingadi didau. Ning nabu dauyanoa sup, bing aria baru bu mosaga dau muli? Tegu. ");
INSERT INTO met_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mosakka na bila ba sanga mana umangua te, saing lipudi daxaningxaning xaung asaxa taindi bu haringia titi orandi te. Diting mala olang. “Lipu gaxarea tangadingliana, bing dilungu haruanga baguli.” ");
INSERT INTO met_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bunging tela, lipu takis xabinganam xumana xaung lipu kubolu dianam xumana digugunia taxiya Yesu bu dilungu. ");
INSERT INTO met_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ne Parisidi digabu lipu hanaunaunga tubatubainganamdi daharungia ba, “Lipua li yaha mana lipu kubolu dianamdi saing xang ranguadi.” ");
INSERT INTO met_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Baing Yesu baladi mana haruanga babuna li: ");
INSERT INTO met_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nabu angia tela sipsibing 100 saing tela hanggalang. Bagula sauya 99 raxangia saing ila sai mana sipsipka hanggalang, maxuna? Wane, bagula saisai laing bagu. ");
INSERT INTO met_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Baing bungina xap, gamonoa yaha saing hakisi mahaing ");
INSERT INTO met_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","saing ila numia. Baing wagi riandi xaung lipuadi numadingdi duwa haxek mana ba dima digugunia, saing harua ba, ‘Ayaha rangua nga. Ngabagu sipsibigua hanggalang ba.’ ");
INSERT INTO met_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ngabalang ba, bila balau Urana gamona yaha sibuna mana lipu kubolu dianam taininau xugia hatuminganoa mana lipu maringing 99 oxatading te ba duxugia hatumingadingdi.” ");
INSERT INTO met_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Harua muli ba, “Nabu haing tela sianging silba mukiring 10 saing tela hanggalang. Bagula tung nagung tela, sogoxoya numua saing sai mana, maxuna? Wane, bagula saisai laing bagu. ");
INSERT INTO met_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Baing bungina bagu, wagi riandi xaung lipuadi numadingdi duwa haxek mana ba dima digugunia, saing harua ba, ‘Ayaha rangua nga. Ngabagu siangigu mukirina hanggalang ba.’ ");
INSERT INTO met_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Bila balau, ngabalang ba, yahanga sabanga wa mana longga Urana uleginamdi duwa mana bungina lipu dianam taininau xugia hatuminganoa.” ");
INSERT INTO met_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu harua muli ba, “Lipu tela wa, garang lup luwa. ");
INSERT INTO met_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kixinginoa harua na tibuna ba, ‘Tibugu, xalingim hataindi bagula dima rimagia bungina umati, ngabo ba usinadi nanga.’ Binabu tibuding hata xalingindi na dingtang. ");
INSERT INTO met_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Xaidap teladi disup, baing kixinginoa gugunia xalinging longgalo, ila long hasoyam tela saing sahi siangindi olang mana kubolu titiamdi. ");
INSERT INTO met_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Siangindi disup, baing gesak sabanga xap titia ba saing ungguti gesaginauba. ");
INSERT INTO met_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Binabu ila xap oxatua mana titi moxong tela la ba. Lipua ba soxi mala bu wasa mana buxundi. ");
INSERT INTO met_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Hatum xumana ba xang buxudi angiadinga, ne lipu tela hauli te. ");
INSERT INTO met_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Bungina hatuminganoa maring muli, harua ba, ‘Tibugu lipuxing oxatam longgalo angiading xumang sibuna, ne ngawa la li, ngadongia gesaga saing ngabo ba ngamatiuba! ");
INSERT INTO met_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Bagula ngamesa ngagoxoya mala rangua tibugu, saing bagula ngaharua na ba: Tibugu, ngalibu kubolu diana mana Urana xaung ung. ");
INSERT INTO met_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ngaxai te sanga mana uxu nga ba ung garama. Umogu nga lipuxim oxatam tela.’ ");
INSERT INTO met_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Binabu mesa ila rangua tibuna. “Ning wa hasoyauyu, tibuna bagu saing baxagi mana usingangua mana. Luki mala rangua garanoa, hibua saing libu. ");
INSERT INTO met_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Garanoa harua na ba, ‘Tibugu, ngalibu kubolu diana mana Urana xaung ung. Ngaxai te sanga mana uxu nga ba ung garama.’ ");
INSERT INTO met_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ning tibuna harua na lipuxing oxatamdi ba, ‘Ala sap axap imang maxaxaya xai sibuna ma bu asau mana. Asau raxu tela rimang uxunia bu hatanga ba ngasina yaya na garagua muli, saing asau xai sanggandi mana kindi. ");
INSERT INTO met_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Axap bulmakau tutubing dungmananganama ma bu aung mati. Tatau, gamoradi diyaha. ");
INSERT INTO met_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Namua na bila garagua li mati ba saing wa muli. Hanggalang ba, saing goxoya ma muli.’ Binabu ditau, gamodingdi diyahauba. ");
INSERT INTO met_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Mana bungina baguba, sabanganoa wa umangiauyu. Bungina sok haxek numia, lungu duwaya disiga. ");
INSERT INTO met_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Baing wagi lipu oxatam tela ma, saing xusunga ba baraxinta sok. ");
INSERT INTO met_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Haxuya ba, ‘Kixingima ma lo, saing tibum ung bulmakau tutubing dungmananganama, namua na goxoya ma, wa xai la li muli ba.’ ");
INSERT INTO met_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ne sabanganoa atin disala saing hauxana ba luxu mala. Baing tibuna sok ma, saing xusunga haringina ba luxu. ");
INSERT INTO met_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ne haxuya na tibuna ba, ‘Ai, ubagu! Niani xumana ngawaxata haringina maung, saing ngadali haruangama te. Ne utongtongia taunga kaxukang tela manga te bu ngayaha rangua riagudi. ");
INSERT INTO met_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ne garamga ba, hanggalangia xalingim longgalo mala mana haing daxangamdi. Hatata goxoya ma, baing ung gung bulmakau tutubing dungmananganamga ba saing utau mana!’ ");
INSERT INTO met_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Tibuna harua ba, ‘Garagu, bungingbunginalo uwa rangua nga, saing xalingigu longgalo ungiadi. ");
INSERT INTO met_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ne hatata bagula tatau saing tayaha, namua na bila kixingimga li mati ba, saing wa muli. Hanggalang ba, saing goxoya ma muli.’ ” ");
INSERT INTO met_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu bala lipuxindi dinaxu mana ba, “Lipu xalaxalam tela ina lipuxing tela wasa mana xalingindi. Ne lipu teladi dibala lipu xalaxalama ba lipuxing haulingama hanggalangia siangindi. ");
INSERT INTO met_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Baing wagi ma saing xusunga ba, ‘Ngalungu ba uria baru? Xalingigu baruamtadi duwa rimamia, ubungdi mari, namua na sanga ba uwasa mana xalingigudi muli te.’ ");
INSERT INTO met_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Lipu haulingam hatum xumana saing hatum ba, ‘Si, hatata bagula ngaria baru? Lipuxigu haringina hitixiya oxatagua. Ngaharing te sanga ba ngaki, saing memeyagu ba ngaxusunga lipudi olang olang mana sianga. ");
INSERT INTO met_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A, ngaxabiau ngaria baru, bu bungina oxatagua sup ba, sanga ba lipudi bagula diyaha ba duwasa manga numadingia.’ ");
INSERT INTO met_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Baing wagi lipu taining tainina haxuyangading duwauyu rangua lipuxing haringina dima. Baing xusunga mugamugangama ba, ‘Oxop baraxinta rangua lipuxigu haringina?’ ");
INSERT INTO met_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Haxuya ba, ‘Olip guxengana dram 16.’ “Lipu xalaxala wasanganama bala ba, ‘Oxop xailongim baxangangam, urung sap saing usisia ubung 8 ing ganina.’ ");
INSERT INTO met_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Baing xusunga tela ba, ‘Ne, haxuyangama baru?’ “Haxuya ba, ‘Wit daba 100.’ “Bala ba, ‘Oxop xailongim baxangangam saing usisia ubung 80 ing ganina.’ ");
INSERT INTO met_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Lipuxing haringina iti lipu diang oxatamga ba yanoa, namua na libu kubolua bila lipu hatumingam. Lipu titiamgadi li daxabia xai sibuna mana duwasa xai sibuna mana ding sibuding. Baing didali lipu lulianamdi mana kubolua baguli. ");
INSERT INTO met_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ngabalang ba, aulia mauli mana xalingim titiamdi bu axap riaim riaim mang, sanga mana bunging sianggam sup ba, bing bagula daxapkang bungina asok long xaiya, longga ba numadi duwa xai bungingbunginalo. ");
INSERT INTO met_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Lipu gaxarea duwasa xai mana axamang kaxukandi, bing lipudi daxabia ba ding sanga ba duwasa xai mana xumana. Lipu gaxarea dilibu kubolu languangam mana axamang kaxukandi, bing bagula dilibu taininau mana xumana. ");
INSERT INTO met_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Baing nabu ang gawasa xai te mana xalaxala titiamdi, bing gaxarea bagula ta xalaxala maxung sibunamdi rimaimia? ");
INSERT INTO met_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Baing nabu ang gawasa xai mana lipu tela xalingindi te, bing gaxarea bagula sina nang ang sibuimiadi? ");
INSERT INTO met_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Lipu oxatama sanga ba waxata mana lipu haringing luwa te, namua na bagula murung sibuna mana tela, saing hauxang sibuna mana tela, kimbo bagula waxata xai mana tela, saing atin didoa mana tela. Bila balau, sanga ba awa hawa mana Urana xaung xalaxaladi xauna te.” ");
INSERT INTO met_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parisidi dilungu Yesu haruanganoa saing ditabia yungxadingdi, namua na muruding buk mana sianga. ");
INSERT INTO met_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Harua nadi ba, “Ang ba, ang gabo lipu longgalo dibaguang ba dahatum ba ang maringindi. Ne Urana xabia hatumingaimdi. Axadi haing lup diti hatumingadingia, Urana hauxang sibuna manadi. ");
INSERT INTO met_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Buningadi mana hanaunaunga xaung Urana lipuxing suxunguxunguamdi xailongidingdi, lipudi duwa hawa manadi laing bungina Yon. Ne ungguti mana bungina Yon, ulek xaiyua mana Urana Yonggaxinoa ngabaxanga, saing lipu longgalo dahayuyu ma bu diluxu. ");
INSERT INTO met_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sabaluna xaung titi bagula disup. Ning hanaunaunga hataing kaxukang tela sanga ba hanggalang monga te. ");
INSERT INTO met_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Lipu gaxarea taxiti yaunganoa saing yau haing tela muli, bing libu kubolu diana mana yaunga daxanganoa. Baing lipu gaxarea yau haing yaunga taxitinganamga ba libu kubolu diana mana yaunga daxanganoa. ");
INSERT INTO met_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Lipu xalaxalam tela wa, sau imang sikokop xaung imang gumangindi, saing wa xai sibuna xaidap taining tainina. ");
INSERT INTO met_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Haxek mana numang gamgamingang xaluxinoa, lipu haxuging tela kinuʼm tabu, yanoa Lasaras. Ina businganoa saksaxa ");
INSERT INTO met_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","saing muruna ba xang baraxing baraxinta diri mana lipu xalaxalama kabukabunoa. Baing komadi dima diramram saxandi. ");
INSERT INTO met_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Xaidap tela lipu haxugina ba mati saing Urana uleginamdi doxoxi mala ba wa haxek rangua muganganoa Ebraham. Lipu xalaxalama mati xauna, saing dikimang. ");
INSERT INTO met_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Rung matiadi yabadingia, saing xap salak sabanga. Bagu mahaing saing bagu Ebraham wa hasoya, saing Lasaras wa rangua. ");
INSERT INTO met_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Baing wagi ba, ‘Tibugu Ebraham, usinga nga saing usoxi Lasaras ma bu tai rimang uxuna langia saing haxaringia managua, namua na ngaxap salaga buk mana yapka li.’ ");
INSERT INTO met_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ne Ebraham haxuya ba, ‘Garagu, uhatum muli bungina uwauyu, walingama baxagi mana axamang xaidi, ne Lasaras xap axamang diandi. Ne hatata wa xai la li, saing ung ba oxop salak sabanga la ba. ");
INSERT INTO met_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Axamang tela muli, liwe makira gubinangang sabanga tela wau, ne lipu gaxarea duwa la li dibo ba dikisi mala ranguang, ding sanga te. Ne ang xauna, sanga ba akisi ma ranguam te.’ ");
INSERT INTO met_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Haxuya ba, ‘Ne tibugu, ngaxusungaung haringing sibuna ba usoxi Lasaras mala tibugu numania, ");
INSERT INTO met_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","namua na nga kixingigu luwadi luwadi hiliadinga. Nai ba harua haringina nadi, nam bagula dima mana long salakkamga li xauna.’ ");
INSERT INTO met_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ne Ebraham haxuya ba, ‘Moses hanaunaunganoa xaung Urana Lipuxing Suxunguxunguamdi buningadingdi duwa. Sanga ba dilungudi.’ ");
INSERT INTO met_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Harua ba, ‘Tibugu Ebraham, tegu. Ne nabu matia tela ila ranguadi, bagula duxugia hatumingadingdi.’ ");
INSERT INTO met_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Harua na ba, ‘Nabu dilungu Moses xaung Urana Lipuxing Suxunguxunguamdi haruangadinga te, bing bagula dahatum haringina te nabu lipu tela mesa muli gobagobia.’ ” ");
INSERT INTO met_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu harua na lipuxindi dinaxu mana ba, “Axadi daxai lipudi daxanga diania bagula dima, ne usinga sibuna mana lipua libudi disok rimania. ");
INSERT INTO met_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nabu digoxi siang sabanga lipua na bila ba waxungtuania, saing diting mari tegia namua na libu dingia tela mana nanunadi li xung mari, bing salaga xap bagula kaxukana mana salaga xap yu Urana rimania. ");
INSERT INTO met_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Binabu amaxania mang. “Nabu riama libu kubolu diana, uhanaunau. Nabu xugia hatuminganoa, bing uyunga kubolunoa. ");
INSERT INTO met_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nabu libu kubolu diana maung bunging 7 mana xaidap tela, saing bunging 7 goxoya ma saing harua ba, ‘Ngaxugia hatumingagua,’ bing uyunga kubolunoa.” ");
INSERT INTO met_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposeldi daharua na Toxoratamona ba, “Uhauli hatumingamam haringindi ba ditubu!” ");
INSERT INTO met_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Haxuya ba, “Nabu hatumingam haringina kaxukana bila mastat xuyana, bing bila li: Ung sanga ba ubala xaiya li ba, ‘Uxupkung sangua titia li, saing ula uranggung tegia,’ saing bagula su mana haruangama. ");
INSERT INTO met_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Gaxarea angia tela ina lipuxing oxatam, waxata umangia kimbo wasa mana sipsipdi, ne bungina goxoya ma numia harua na ba, ‘Uma, urung oxong to’? Uharua bila ba? ");
INSERT INTO met_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tegu. Harua bila li: ‘Usugu, utau angiagua, saing oxop ma sanga ba ngaxang nganung to. Baing kimuya sanga ba oxong unung.’ ");
INSERT INTO met_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bagula harua xai sibuna na lipuxing oxatama namua na libu oxatanoa? Tegu. ");
INSERT INTO met_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Bila balau, bungina asahi oxataimdi Urana sinadi nang ba, xai nabu aharua ba, ‘Heku Urana harua xai nam. Am lipu oxata olanggamdi. Am galibu oxatua sina nam ing ganina.’ ” ");
INSERT INTO met_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu haing mala long sabangga Yerusalemguyu, baing naxu mana titiadi Samaria Galili ragudinga. ");
INSERT INTO met_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bungina luxu mana long tela, baing lipu 10, businga saksaxama xapdi, disok mana. Dili hasoya monga ");
INSERT INTO met_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","saing duwagi haringina ba, “Yesu, Lipu Sabanga, usingam!” ");
INSERT INTO met_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Bungina bagudi, harua ba, “Ala, ahatangang na lipu hananiangamdi.” Dahaxa mala, baing ina naga, disok xai dup, disigixinga. ");
INSERT INTO met_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Dingia tela, bungina bagu sok xai dup, goxoya ma, wagi haringina saing iti Urana yanoa. ");
INSERT INTO met_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Gung king tuxundi Yesu kinia, saing harua xai sibuna. Ne lipua ba Samaria tela, Yuda tela te. ");
INSERT INTO met_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu xusunga ba, “10 disok xai dup. Ne ngabagu taininau ing ganina! ");
INSERT INTO met_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Baruta teladi digoxoya ma diti Urana yanoa te? Lipu titi telamga li ing ganina ma iti Urana yanoa.” ");
INSERT INTO met_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Baing harua na ba, “Umesa ulauba. Hatumingam haringina hamaringiaung.” ");
INSERT INTO met_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Bunging tela Parisidi duxusunga Yesu ba bungintabi Urana Yonggaxinoa bagula ma, baing haxuya ba, “Bungina Urana Yonggaxinoa ma, sanga ba axamandi disok bila hatangangua lipudi dibagu maxadingia te. ");
INSERT INTO met_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ne lipu tela te sanga ba harua ba, ‘Wa la li,’ kimbo ‘Wa la ba,’ namua na Urana Yonggaxinoa wa liwe mang.” ");
INSERT INTO met_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Baing harua na lipuxindi dinaxu mana ba, “Xaidapdi dima yu bungina abo sibuna ba abagu Lipua Ma Rangua Urana xaidabing tela, ne sanga ba abagu te. ");
INSERT INTO met_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Lipudi bagula dibalang ba, ‘Wa la ba!’ kimbo ‘Wa la li!’ Aluki asu manadiu tai. ");
INSERT INTO met_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ahatumia. Bungina abagu bilikbiliga, ralanoa su sabalung subingang longgalo. Bila balau, mana Lipua Ma Rangua Urana xaidabinoa, bagula lipu longgalo dibagu daxabia. ");
INSERT INTO met_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ne muga bagula xap salak xumana saing lipu hatatamdi bagula dihitixiya. ");
INSERT INTO met_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Lipua Ma Rangua Urana xaidabinoa bagula wa bila Noa xaidabinoa. ");
INSERT INTO met_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Lipudi daxang, dinung, diyau ding laing xaidapka Noa luxu wagia ba. Baing langa si sabanga saing ung ding longgalo mati. ");
INSERT INTO met_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Bila balau mana Lot xaidabinoa. Lipudi daxang xaung dinung. Digim xaung disina. Duxuma xaung ditongtongia. ");
INSERT INTO met_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ne bungina Lot yunga long sabangga Sodam, yap xaung siang yapkamdi diri sabalunia ma saing ung ding longgalo mati. ");
INSERT INTO met_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Bagula wa bila ba mana xaidaba Lipua Ma Rangua Urana sok sabasabia. ");
INSERT INTO met_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mana xaidapka baguba lipu gaxarea duwa numa ubunia, ne xalingidingdi duwa maluxu, labu diluxu bu daxapdiu tai. Bila balau, lipu gaxarea duwa umangia, labu digoxoya mala numiau tai. ");
INSERT INTO met_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ahatumia Lot haininoa naxuyanganoa! ");
INSERT INTO met_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Lipu gaxarea dituba ba dituxu haringina walingadinga, bing bagula dahanggalang. Ne lipu gaxarea diyunga walingadinga bu dinaxu manga, bing bagula daxap walinga sibuna. ");
INSERT INTO met_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ngabalang ba, mana bungina baguba, lipu luwa bagula tang dikinu mana uxainga taininau yambong. Tela bagula daxap, ne tela bagula diyunga. ");
INSERT INTO met_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Haing luwa bagula tang dahamunanggia wit marandi. Tela bagula daxap, ne tela bagula diyunga.” ");
INSERT INTO met_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Duxusunga ba, “Toxoratamona, bagula axadi li disok bi?” Haxuya ba, “Nabu matia tela wa mana long tela, bagula matikomkomdi digugunia la ba.” ");
INSERT INTO met_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Baing Yesu bala lipuxindi dinaxu mana ba mana haruanga babung tela, bu hatanga nadi ba bing dili haringina disabusabu, saing sanga ba diyunga kubolua ba te. ");
INSERT INTO met_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Harua ba, “Mana long sabanga tela lipu suxuyangam tela wa. Maxuwa mana Urana te. Hatumia lipudi te. ");
INSERT INTO met_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Baing mana long sabangga baguba tap tela wa. Bunging xumana ma xusunga xusunga ba, ‘Uhauli nga mana bixuagua.’ ");
INSERT INTO met_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Muga lipu suxuyangama lungu te. Ne kimuya harua na ing sibuna ba, ‘Ngamaxuwa mana Urana te. Ngahatumia lipudi te, ");
INSERT INTO met_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ne mana namua tapka li tauti nga buk, bagula ngahauli sanga ba yunga kubolunoa bu ngayagua!’ ” ");
INSERT INTO met_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Baing Toxoratamona harua ba, “Alungu lipu suxuyangam maringing teguama haruanganoa. Hauli tapka ba sap te. ");
INSERT INTO met_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ning Urana, maxung sibuna bagula hauli lipuadi mogudi ba, ding duwagi buraragina, xaidap liwe xaung yambong. Bagula libu diragu maxaxaya? ");
INSERT INTO met_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ngabalang ba, bagula haulidi sap. Ning bungina Lipua Ma Rangua Urana ma, bagula bagu lipu tela hatum haringina mana, kimbo tegu?” ");
INSERT INTO met_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Lipu teladi dahatum haringina mading bila ding ganiding dimaring, saing ditatua lipudi. Binabu Yesu baladi mana haruanga babuna baguli: ");
INSERT INTO met_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Lipu luwa dahaing Urana Numania bu tang disabu. Parisi tela xaung lipu takis xabinganam tela. ");
INSERT INTO met_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisi mesa saing sabu mana ing sibuna ba, ‘Urana, ngaharua xai sibuna maung ba ngawa bila lipu teladi te—lipu hanaunggamdi, lipu diandi, lipudi dahaxa mauli rangua yaungamdi—kimbo bila lipu takis xabinganamga li. ");
INSERT INTO met_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ngasaha mana angingua xaidap luwa maluxu mana sande tela, saing ngasina hataing 10 naung mana axadi dima rimagia.’ ");
INSERT INTO met_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ning lipu takis xabinganama li hasoya monga. Memeyana buk mana bagu mahaing long xaiya. Ne turu mari saing harua ba, ‘Urana, usinga nga, nga lipu kubolu dianam.’ ");
INSERT INTO met_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ngabalang ba, bungina goxoya mala numia, lipua li wa maringina Urana maxania, ne tela tegu. Namua na Urana bagula tatua lipu gaxarea diti yadingdi, saing bagula sina yaya na lipu gaxarea ditatua ding.” ");
INSERT INTO met_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Lipudi daxap gara kambagindi ma rangua Yesu bu ta rimandi manadi. Bungina lipudi dinaxu mana dibagu alali, dibilidi. ");
INSERT INTO met_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ning Yesu wagi garadi dima rangua saing harua ba, “Ayunga garadi ma rangua nga, labu abilidiu tai, namua na lipuadi duwa bila garadi bagudi li, Urana Yonggaxinoa dingia. ");
INSERT INTO met_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Maxung sibuna ngabalang ba, lipu gaxarea diyunga ding te ba duwa hawa mana Urana bila garadi dilibu, bing sanga ba diluxu Urana Yonggaxinia te.” ");
INSERT INTO met_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yanam tela xusunga Yesu ba, “Lipu Tubatubaingam Xai, ngaria baru bu ngaxap walinga subingang teguama?” ");
INSERT INTO met_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Baing Yesu haxuya ba, “Baruta uxu nga ba xai? Lipu tela xai te. Urana ing ganina xai. ");
INSERT INTO met_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ne mana xusungangama, uxabia hanaunaungadi: ‘Ukinu rangua tela uyau teguyu bau tai, ung matiu tai, uhanaiu tai, usu haruanga languangamgu tai, uwa hawa mana baumtibumdi.’ ” ");
INSERT INTO met_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Harua ba, “Bungina ngawa garauyu ma laing hatata, hanaunaunga longga bagudi li ngasu manadi.” ");
INSERT INTO met_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Bungina Yesu lungu alaba, harua na ba, “Axamang tela uraxap mana. Ula usina xalingimdi masup. Usina giminagidingdi na lipu haxugindi, bing bagula oxop axamang maxung sibundi maluxu long xaiya. Saking uma, unaxu manga.” ");
INSERT INTO met_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Bungina lungu haruanga baguba, ayangang sibuna, namua na xalingindi xumang sibuna. ");
INSERT INTO met_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu bagu saing harua ba, “Laku, lipu xalaxalamdi dimakasa sibuna mana diluxu Urana Yonggaxinia! ");
INSERT INTO met_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Maxung sibuna, lipu xalaxalama bo ba luxu Urana Yonggaxinia, makasanganoa dali kamel tela ila luxu saxang ginanginia.” ");
INSERT INTO met_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Lipudi dilungu haruanga baguba duxusunga ba, “Si! Nabu bila ba, bing lipu gaxarea bagula daxap walinga subingang teguama?” ");
INSERT INTO met_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu haxuya nadi ba, “Lipu ding sibuding sanga tate, ne Urana ina sanga.” ");
INSERT INTO met_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita harua na ba, “Ai! Am ba, am gayunga axamandi masup bu am ganaxu maung.” ");
INSERT INTO met_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu harua nadi ba, “Maxung sibuna ngabalang ba, lipu gaxarea dahatumia Urana Yonggaxinoa saing diyunga yabadingdi, hainidingdi, sabangadingdi, kixingidingdi, baudingtibudingdi, kimbo garadingdi, ");
INSERT INTO met_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","bing bagula daxap haxuyangading xumana mana bungina hatata, saing mana kimu sibuna, bagula daxap walinga subingang teguama.” ");
INSERT INTO met_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu xap Lipu 12 mala singia saing baladi ba, “Alungu to. Tahaing mala mana long sabangga Yerusalemguba. Axamang longgalo Urana lipuxing suxunguxunguamdi dibung mana Lipua Ma Rangua Urana ba, bagula aningodingdi disok maxuna. ");
INSERT INTO met_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bagula dita Yuda Teguamdi rimadingia. Baing bagula didaudau, daharua diana mana, daxanubia, ");
INSERT INTO met_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","digusi, dung mati. Ne kimuya mana xaidap tuwa bagula mesa muli.” ");
INSERT INTO met_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ne lipudi dinaxu mana daxabia alali rangrang te. Namuxina hisa manadi, saing daxabia haruanganoa rangrang te. ");
INSERT INTO met_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Dahaxa mala disok long sabangga Yeriko, baing lipu maxa haxatiang tela rung mua daxanga rubinia, xusunga lipudi olang olang mana sianga. ");
INSERT INTO met_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Bungina lungu buranga didali, xusunga ba diraxata. ");
INSERT INTO met_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Dibala ba, “Yesu Nasaretiam ma ila lo.” ");
INSERT INTO met_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Baing wagi ba, “Yesu, Xaitamoxi Debit Garanoa ba, usinga nga!” ");
INSERT INTO met_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Lipuadi dimuga mana burangua dibili, dibala ba, “Udik!” Dibalabala sus, haxi buk saing wagi sabanga ba, “Xaitamoxi Debit Garanoa ba, usinga nga!” ");
INSERT INTO met_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Baing Yesu li mua saing bala lipudi ba daxap lipua ma rangua. Bungina ma haxek, Yesu xusunga ba, ");
INSERT INTO met_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ubo ba ngariaung baru?” Haxuya ba, “Toxoratamona, ngabo ba ngabagu.” ");
INSERT INTO met_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Baing Yesu harua na ba, “Maxamdi disok xai dup. Hatumingam haringina hamaringiaung.” ");
INSERT INTO met_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hata sibuna li maxandi disok xai dup, saing su mana Yesu, iti Urana yanoa. Bungina lipudi dibagu alaba, ding xauna diti Urana yanoa. ");
INSERT INTO met_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu luxu Yeriko saing kisi mala. ");
INSERT INTO met_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Lipu tela wa la ba, yanoa Sakias, lipu takis xabinganamdi yanamiding tela, lipu xalaxalam. ");
INSERT INTO met_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Bo ba bagu Yesu lipua na bila baru, ne sanga te, namua na raxap saing lipu xumana dahaxa ditaxiya Yesu. ");
INSERT INTO met_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Binabu luki muga mala, saing haing mana xai gusak tela ba bagu, namua na Yesu ma bila ba. ");
INSERT INTO met_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Bungina Yesu sok mana longga baguba, bagu mahaing saing harua na ba, “Sakias, uri ma sap. Hatata bagula ngawa ranguaung numamia.” ");
INSERT INTO met_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Baing ri ma sap, yaha sibuna saing xap Yesu. ");
INSERT INTO met_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Lipu longgalo dibagu alali daharungia ba, “Baruta ila wa rangua lipu kubolu dianamga ba?” ");
INSERT INTO met_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Bungina duwa numia, Sakias mesa saing harua na Toxoratamona ba, “Toxoratamona, ubagu! Hatata bagula ngautu xalingigudi lia, saing ngasina hataing tela na lipu haxugindi. Nabu ngalanglangua lipu teladi mana axamang tela, bing bagula ngahaxuya luwadi luwadi muli nadi.” ");
INSERT INTO met_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu harua na ba, “Hatata Urana xap numa li moxondi muli, namua na lipua li xauna Ebraham bakbaging tela. ");
INSERT INTO met_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Baing Lipua Ma Rangua Urana ma bu sai mana lipudi dahanggalang saing xapdi muli.” ");
INSERT INTO met_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Dima haxek long sabangga Yerusalem, saing lipudi dilungu Yesu haruanganoa ba, ding dahagaxa ba Urana Yonggaxinoa bagula ungguti sap. Binabu baladi mana haruanga babuna li: ");
INSERT INTO met_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Yanam tela ila long hasoyam tela bu dimogu ba sok xaitamoxi, saking bagula goxoya ma. ");
INSERT INTO met_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Muga baing wagi lipuxing oxatam 10 dima, saing sina siang gol tela na taining tainina. Harua ba, ‘Awaxata mana siangga li laing ngagoxoya ma.’ ");
INSERT INTO met_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ne lipu yabanamdi hauxading sibuna mana, saing disoxi ulekkamdi kimuya mana bu daharua ba, ‘Hauxamam mana lipua li sok xaitamoximam.’ ");
INSERT INTO met_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Baing tegu, sok xaitamoxi, saing goxoya ma yabania. Baing wagi lipuxing oxatamdi sina sianga nadi ba dima bu lungu diraxata manadi, daxap tela muli baru. ");
INSERT INTO met_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Mugamugangama ma saing harua ba, ‘Lipu sabanga, ngawaxata mana siangima saing ngaxap 10 muli.’ ");
INSERT INTO met_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Xaitamoxi bala ba, ‘Xai sibuna! Ung lipu oxatam xai! Namua na uwasa xai mana axamang kaxukandi, binabu ngataung etua mana long sabangga 10.’ ");
INSERT INTO met_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Tela ma saing harua ba, ‘Lipu sabanga, ngawaxata mana siangima saing ngaxap 5 muli.’ ");
INSERT INTO met_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Xaitamoxi bala ba, ‘Ngataung etua mana long sabangga 5.’ ");
INSERT INTO met_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Baing lipu oxatam tela muli ma saing harua ba, ‘Lipu sabanga, siangimga li ngasina naung muli. Ngatibu saing ngayameng mana long tela. ");
INSERT INTO met_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ngamaxuwa maung, namua na ung lipu yabina. Oxop xalaxala lipu teladi duwaxata manadi. Oxop angingadi lipu teladi duxumadi.’ ");
INSERT INTO met_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Lipuxing haringina haxuya ba, ‘Ung lipu oxatam diana! Bagula ngasuxuyaung mana ung sibum haruangama! Uxabia nga, nga lipu yabina. Ngaxap xalaxaladi lipu teladi duwaxata manadi. Ngaxap angingadi lipu teladi duxumadi. ");
INSERT INTO met_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ne baruta uta siangigua maluxuʼm numa sianggam te? Baing bungina ngagoxoya ma bing ngaxap muli xaung siang dalingam teladi xauna.’ ");
INSERT INTO met_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Baing xaitamoxi harua na lipudi dili singia ba, ‘Axap sianginoa sangua, saing asina na lipua tuxu 10.’ ");
INSERT INTO met_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Daharua ba, ‘Lipu sabanga, lipua ba tuxu 10 masup!’ ");
INSERT INTO met_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Baing haxuya ba, ‘Ngabalang ba, lipu gaxarea dituxu oxata xai mana axadi daxapdi ba, bagula ngasina teladi muli nadi. Ne lipu gaxarea dituxu oxata xai mana axadi daxapdi ba te, baraxinta ding dituxudi, bagula ngaxapdi sanguadi muli. ");
INSERT INTO met_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ne bixuagudi hauxading mana ngasok xaitamoxidinga, axapdi ma saing aungdi mati maxagia.’ ” ");
INSERT INTO met_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kimuya mana Yesu harua alaba, ila muga mahaing long sabangga Yerusalem. ");
INSERT INTO met_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Disok haxek mana long luwa Betpets, Betani duwa Xaxagania Olip. Baing soxi lipuxing luwa dinaxu mana mala, harua nadi ba, ");
INSERT INTO met_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Tang galuxu mana longga wa mugamugangia to. Haxek sibuna ba aluxu, bagula abagu donki haun tela digoti la ba, lipu tela rung mana teguyu. Tang galuba saing axai ma. ");
INSERT INTO met_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nabu lipu tela xusunga ba, ‘Baruta tang galuba?’, bing tang gabala ba, ‘Toxoratamona oxatana mana.’ ” ");
INSERT INTO met_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Lipuadi Yesu soxidi mala muga dilauba, dibagu bila bala dingtang ba. ");
INSERT INTO met_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bungina diluba, moxondi duxusungadi ba, “Baruta tang galuba donki ba?” ");
INSERT INTO met_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tang dahaxuya ba, “Toxoratamona oxatana mana.” ");
INSERT INTO met_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tang daxap ma rangua Yesu, diting imangiding sabangadi mahaing donki, saing dahauli Yesu ba rung etua mana. ");
INSERT INTO met_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Baing haxa mala, saing lipudi duxa imangiding sabangadi daxangia bu dahatanga lipu yayam sabanga. ");
INSERT INTO met_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Bungina sok haxek mana longga daxanga ri mala Xaxagana Olip, lipu longgalo dinaxu mana dungguti duwagi diyaha, diti Urana yanoa sabanga mana axamang haringindi dibagudi ba, daharua ba, ");
INSERT INTO met_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Urana sina guxama na Xaitamoxi baguli ma mana Toxoratamona yanoa ba!” “Gamogamu mosiam wa liwe mana Urana xaung am lipuxindi, saing taiti Urana Eta Loam Sibuna yanoa!” ");
INSERT INTO met_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Parisi teladi duwa burangia daharua na Yesu ba, “Lipu Tubatubaingam, ubili lipuximdi dinaxu maung ba!” ");
INSERT INTO met_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Haxuya ba, “Ngabalang ba, nabu dimumguti, bing maxung sibuna siangdi bagula duwagi.” ");
INSERT INTO met_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Bungina ma haxek Yerusalem saing bagu long sabangua, tang mana, ");
INSERT INTO met_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","harua ba, “Ngabo ba hatata axabia mana daxanga xap gamogamu mosiama masok, baing tegu, hisa mang. ");
INSERT INTO met_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Xaidapdi dima yu bungina bixuaimdi bagula dilipkang disoxautiang mana rubing longgalo, diki titia gamgamingaimia bu ditongtongia daxanga etua mana, saing dihixi diluxu daxapkang. ");
INSERT INTO met_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bagula dahanggalangiang xaung garaimdi maluxu gamgamingaimia. Bagula diyunga siang tela wa etua mana rianoa te, namua na hatumingaimdi diriba ding, saing abagu axabia te xaidapka Urana hauliang ma ba.” ");
INSERT INTO met_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Baing luxu Urana Numang yabania saing suka lipuadi disina axamandi mana sianga maluxu Urana Numania masokkuba. ");
INSERT INTO met_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Harua nadi ba, “Aisaya bung Urana Xuania ba Urana harua ba, ‘Numagua bagula duxu ba numa sabungam’, ne ang gaxugia mala bila ‘guha tela lipu hanaunggamdi dihisa maluxu mana!’ ” ");
INSERT INTO met_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Xaidap longgalo tubatuba Urana Numania. Ne lipu hananiangamdi yanamidingdi, lipu hanaunaunga tubatubainganamdi digabu lipudi yanamiding teladi disai daxanga tela bu dung mati. ");
INSERT INTO met_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Disaisai sus, namua na lipu longgalo dahaxi buk ba dilungu haruanganoa. ");
INSERT INTO met_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Xaidap tela bungina Yesu tubatuba lipudi, baxanga ulek xaiyua Urana Numang yabania, baing lipu hananiangamdi yanamidingdi, lipu hanaunaunga tubatubainganamdi xaung lipu haringindi dima rangua. ");
INSERT INTO met_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Daharua ba, “Ubaxanga nam ba oxop yaya ba rangua gaxarea bu ulibu axadi bagudi li. Gaxarea mogung ba ulibudi?” ");
INSERT INTO met_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Haxuya ba, “Bagula ngaxusungang xusunganga tela to. Abaxanga nanga. ");
INSERT INTO met_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Bungina Yon sugua lipudi—Gaxarea sina yaya na bu libu? Urana kimbo lipudi?” ");
INSERT INTO met_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dahangixaya liwe mading ba, “Nabu taharua ba, ‘Urana sina,’ bing bagula xusunga kira ba, ‘Ne baruta ahatum haringina mana Yon te?’ ");
INSERT INTO met_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ne nabu taharua ba, ‘Lipudi disina,’ bing lipu longgalo bagula daxatu kira siangia mati, namua na dahatum ba Yon Urana lipuxing suxunguxunguam tela.” ");
INSERT INTO met_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Binabu dahaxuya ba, “Am gaxabia te ma rangua gaxarea.” ");
INSERT INTO met_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Baing ina naga, haxuya ba, “Tauna, nga xauna, bagula ngabalang te ba gaxarea sina yaya nanga bu ngalibu axadi bagudi li.” ");
INSERT INTO met_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Baing bala lipudi mana haruanga babung tela, harua ba, “Lipu tela xuma wain umangang tela, sina na lipu umangamdi, duwaxata bu daxap marang hataindi nading, saing ing sibuna ila haxa mauli hasoya niani xumana. ");
INSERT INTO met_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Bunging moyangama sok, baing soxi lipuxing haulingam tela mala rangua lipu umanga wasanganamdi bu xap wain marang hataindi ranguadi. Ning lipu umanga wasanganamdi ditaha, saing disuka olang mala. ");
INSERT INTO met_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Baing soxi lipuxing haulingam tela muli nadi, ne ditaha xauna, saing dilibu doa mana, disina memeya na, saing disuka olang mala. ");
INSERT INTO met_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Baing soxi tela muli mala saing duxuxu disuka mala. ");
INSERT INTO met_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Binabu wain umangang moxona harua naina ba, ‘Ngaria baru? Bagula ngasoxi garagua, ina nga murugu sibuna mana. Bola bagula dilungu haruanganoa.’ ");
INSERT INTO met_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ning bungina lipu umanga wasanganamdi dibagu, daharua nading ba, ‘Moxona garanoa lo. Kimuya bagula xap tibuna xalingindi. Taung mati, bing xalingindi bagula dima rimaria.’ ");
INSERT INTO met_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Binabu diting mala sangua umangua saing dung mati. “Tauna, ahatum baru? Wain umangang moxonoa bagula riadi baru? ");
INSERT INTO met_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Bagula ma ung lipu umanga wasanganamgadi ba mati, saing sina umangua na teladi.” Bungina lipudi dilungu alaba, daharua ba, “Laku, sanga ba sok bila te!” ");
INSERT INTO met_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ne Yesu bagu taxa manadi saing xusungadi ba, “Nabu aharua bila ba, bing baru namuxinta mana Urana Xuanoa ba: “ ‘Sianga lipu numa tongtongianganamdi dihitixiya bila diana, sok siang mugamugangam bu haringia numa rubing longgalo’? ");
INSERT INTO met_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Lipu gaxarea xungdi mari mana siangga ba bagula duxurutiti, saing lipu gaxarea siangga ba xung mari manadi, bagula dimunanggi.” ");
INSERT INTO met_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Lipu hanaunaunga tubatubainganamdi digabu lipu hananiangamdi yanamidingdi disai daxanga bu dituxu hata sibuna li, namua na daxabia ba su haruanga babuna baguba manadi. Ne dimaxuwa mana lipudi. ");
INSERT INTO met_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Duwasa haringina mana, baing disoxi lipu bagubagungamdi, ne dilangua ba ding lipu maxunamdi. Dituba ba dilanglangua Yesu bu harua haruanga tela maring te. Dituba bila ba bu dituxu dita haruangia gabana maxania. ");
INSERT INTO met_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Binabu lipu bagubagungamdi daharua na ba, “Lipu Tubatubaingam, am gaxabia ba ung lipu haruanga tubatubaik maxunam, ulibu hasusu mana lipu longgalo, saing utubatuba Urana daxanganoa xaung haruanga maxuna. ");
INSERT INTO met_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tauna, ubaxanga nam. Maring mana tagim takis mala na Sisa, kimbo doa?” ");
INSERT INTO met_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ne Yesu xabia muragidinga saing harua nadi ba, ");
INSERT INTO met_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ahatanga siang mukiring tela nanga. Gaxarea babunoa li? Gaxarea yanoa wa mana?” Dahaxuya ba, “Sisa naga.” ");
INSERT INTO met_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Baing harua nadi ba, “Tauna, axadi Sisa iniadi, asinadi na Sisa, saing axadi Urana iniadi, asinadi na Urana.” ");
INSERT INTO met_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Baing ina naga, sanga ba dilanglangua bu harua doa lipudi maxadingia te. Dihixi mana haxuyanganoa, binabu dimumguti. ");
INSERT INTO met_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Baing bakbakka Sadyusi teladi dima rangua bu duxusunga mana axamang tela. Ding dahatiam mana lipudi bagula dimesa muli. ");
INSERT INTO met_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Daharua ba, “Lipu Tubatubaingam, Moses bung haruanga tela makira Urana Xuania ba nabu lipu tela mati, sangua haininoa, ne garang tate, bing kixinginoa bagula yau sabanganoa tabinoa bu tang daxap garadi masok, saking sabanganoa bakbagindi bagula disup te. ");
INSERT INTO met_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tauna, bunging tela neng sabangang 7 duwa. Mugamugangama yau haing tela saing mati, garang tate. ");
INSERT INTO met_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Bing kixinginoa ma kimu mana mugamugangama yau tabinoa saing mati, garang tate. ");
INSERT INTO met_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Hiliadinga kubolu taininau. Bila balau laing disup, ");
INSERT INTO met_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","baing ina naga, hainga mati. ");
INSERT INTO met_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tauna, kimuya, bungina lipudi dimesa muli, bing haingga ba bagula wa gaxarea haininoa sibuna? Namua na 7 ding diyau ba.” ");
INSERT INTO met_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu haxuya ba, “Lup haingdi duwa hawa titia li diyau. ");
INSERT INTO met_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ne kimuya lipu gaxarea Urana harua ba dimaring ba dimesa muli bu duwa long xaiya bagula diyau ding te, ");
INSERT INTO met_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","saing sanga ba dimati muli te, namua na duwa bila Urana uleginamdi. Ding Urana garandi, namua na itidi dimesa muli mana matiyua. ");
INSERT INTO met_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moses hatanga nakira ba ding longgalo dimati bagula dimesa muli. Bungina bung xailonginoa, mana hataina naxuya mana xai kaxukana yaba wa mana ba, kimu sibuna mana mugangaradi Ebraham, Aisak xaung Yekop tung dimati ba, uxu Toxoratamona ba ‘Urana mana Ebraham, Urana mana Aisak, xaung Urana mana Yekop.’ ");
INSERT INTO met_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Binabu ina Urana mana lipu matiandi te. Tegu. Ina Urana mana lipu gamatandi, namua na lipu longgalo duwa gamatana maxania.” ");
INSERT INTO met_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Lipu hanaunaunga tubatubainganam teladi daharua ba, “Lipu tubatubaingam, uharua xai sibuna!” ");
INSERT INTO met_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Baing lipudi dimaxuwa mana dituba mana xusunganga tela muli. ");
INSERT INTO met_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Baing Yesu xusungadi ba, “Baruta lipudi daharua ba Urana Lipuxing Mogunganama wa Xaitamoxi Debit Garanoa? ");
INSERT INTO met_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mana Olaidi Xailongidinga Debit ing sibuna baxanga mana Urana Lipuxing Mogunganama ba: “ ‘Toxoratamona harua na Toxoratamona ngayua ba: “Urung kabukabu yayam wa rimagu rimamo rubinia, ");
INSERT INTO met_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","laing ngata bixuamdi hawa maung.” ’ ");
INSERT INTO met_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Debit uxu ba ‘Toxoratamona.’ Tauna, ina wa Debit garanoa xauna baru?” ");
INSERT INTO met_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Lipu longgalo dilungu mua, baing Yesu harua na lipuxindi dinaxu mana ba, ");
INSERT INTO met_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Amaxania mana lipu hanaunaunga tubatubainganamdi. Ding muruding buk mana disau imang maxaxaya bu dahaxa mauli, saing dibo ba lipudi ditidi daharua xaidap xai nadi mana nawa yabandi. Ding muruding buk mana dirung mana kabukabu mugamugangamdi mana sabunga numandi, saing dibo ba dirung mana kabukabu yayamdi mana taungadi. ");
INSERT INTO met_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Dilanglangua tapdi bu dahanai xalingidingdi, saing disabu maxaxaya bu disok xai lipudi maxadingia. Kimuya, mana xaidap subinganoa, bagula daxap salak sabanga.” ");
INSERT INTO met_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu bagu mauli saing bagu lipu xalaxalamdi ditata siangdi maluxu Urana Numang siang yabania. ");
INSERT INTO met_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Bagu tap haxuging tela xauna ta siang kaxukang mukiring luwa maluxu, disok bila toia taininau. ");
INSERT INTO met_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Harua ba, “Maxung sibuna ngabalang ba, tap haxugina sinainganoa dali lipu teladi. ");
INSERT INTO met_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Namua na lipu teladi disina hataing kaxukana mana siangiding xumana. Ne tapka ba, raxap sibuna saing sina sianging longgalo, siangindi disup mana gim anginga xaung axamandi.” ");
INSERT INTO met_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Lipuxing teladi dinaxu mana dibagu Urana Numanoa, saing daharua ba sianging gumangindi, xaung yauyaungandi daxai sibuna, lipudi disinadi na Urana ba yauyau Numanoa. Ne Yesu harua ba, ");
INSERT INTO met_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Axadi ba abagudi, xaidaba ma yu bungina siang tela bagula wa etua mana rianoa te. Tegu. Bagula ding longgalo disup mari.” ");
INSERT INTO met_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Duxusunga ba, “Lipu Tubatubaingam, bungintabi bagula axadi bagudi li disok? Baing baraxinta bagula sok muga bu hatanga ba axadi li dibo ba disokkuba?” ");
INSERT INTO met_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Haxuya ba, “Amaxania, nam lipu teladi dilanglanguang. Namua na xumana bagula dima dilangua daxap yagua saing bagula daharua ba, ‘Nga lipua naga Urana soxi ma,’ xaung, ‘Xaidaba mauba.’ Asu manadiu tai. ");
INSERT INTO met_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Bungina alungu haunginga sabangadi bibingadinga, bing amaxuwau tai. Namua na axadi na bila ba bagula disok to, ne subinganoa sok teguyu.” ");
INSERT INTO met_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Baing harua nadi ba, “Numanumadi bagula dimesa dahaunggana ding, saing yonggadi bagula dilibu taininau. ");
INSERT INTO met_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Noxiga sabangadi bagula disok, saing gesak sabangadi xaung businga sabangadi bagula disok mana long xangxana. Hatanganga maxuwanga sabangadi bagula disok sabalunia. ");
INSERT INTO met_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ne muga manadi, bagula dituxuang disina salaga nang. Bagula ditang haruangia mana Yudadi sabungading numandi, saing daxaiang mala salak yabania, saing bagula daxapkang mala haruangia xaitamoxidi xaung gabanadi maxadingia, namua na anaxu manga. ");
INSERT INTO met_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ne alaba ganangana mana abaxanga nga nadi. ");
INSERT INTO met_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ning muga aharingiang bu ahatum xumanau tai mana aharua baru. ");
INSERT INTO met_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Namua na bagula ngasina haruanga xaung hatuminga maringina nang, bu bixuaimdi sanga ba dahaxiang te, sanga ba duxugia haruangaima te. ");
INSERT INTO met_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bauimtibuimdi, sabangaimdi, kixingimdi, bakbagimdi xaung riaimdi bagula ditang bixuaimdi rimadingia, saing bagula dung angia teladi mati. ");
INSERT INTO met_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Lipu longgalo bagula hauxading sibuna mang namua na yagua wa ranguang. ");
INSERT INTO met_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ning sanga ba ahanggalang te. ");
INSERT INTO met_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ali haringina mana hatumingaim haringina. Mana daxanga naga bagula axap walinga subingang teguama. ");
INSERT INTO met_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Bungina abagu lipu haungingamdi dilip long sabangga Yerusalem, axabia ba haxek sibuna longga ba bagula doa. ");
INSERT INTO met_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Baing lipu gaxarea duwa titia Yudia bing diluki mala bimbia, lipu gaxarea duwa maluxu long sabangga li Yerusalem bing disauya, saing lipu gaxarea duwa sabasabia bing diluxu mana long sabangga liu tai. ");
INSERT INTO met_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Namua na xaidapka baguba Urana mogu Xuania mana haxuya kuboluding diandi sokkuba. ");
INSERT INTO met_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Baing usinganga buk mana haingdi gamoding xaung hainggadi disina sua na garadingdi mana bungina baguba! Salak sabanga bagula sok titia li, saing Urana ating salianoa bagula xap lipuadi ba. ");
INSERT INTO met_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bixuadingdi bagula dima dungdi mati. Lipu gaxarea dimati te bagula dituxudi saing daxaidi mala mana long teladi. Yuda Teguamdi bagula dahanggalangia Yerusalem laing Yuda Teguamdi xaidabidingdi disup. ");
INSERT INTO met_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Mana bungina baguba, hatangangadi bagula disok mana xaidaba, sobaga xaung hatungdi. La li titia, numanumadi bagula dimaxuwa dahatum xumang sibuna bungina dilungu tega halunglung saing bibi sabanga. ");
INSERT INTO met_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Lipudi bagula dimakmatia namua na dimaxuwa sibuna, dahatum xumana mana baraxinta bagula sok mana titia, namua na axamang haringindi duwa sabalunia bagula dilulu. ");
INSERT INTO met_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mana bungina baguba lipudi bagula dibagu Lipua Ma Rangua Urana ma mana mugap tela xaung haringinganoa xaung ralang sabanga. ");
INSERT INTO met_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bungina axadi bagudi li dungguti disok, amesa abagu mahaing, namua na xaidaba mana Urana xapkang muli sangua bixuaimdi rimadingia ma haxekkuba.” ");
INSERT INTO met_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Baing baladi mana haruanga babuna li: “Abagu xaiya pik xaung xai longgalo. ");
INSERT INTO met_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bungina loding, ang sibuim abagu saing axabia ba gesaga sokkuba. ");
INSERT INTO met_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Bila balau, bungina abagu axadi bagudi li disok, axabia ba Urana Yonggaxinoa ma haxekkuba. ");
INSERT INTO met_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Maxung sibuna ngabalang ba, bagula lipu hatatamdi disup teguyu, laing axadi bagudi li disok to. ");
INSERT INTO met_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sabaluna xaung titi bagula disup, ne xuagu marandi sanga ba disup te. ");
INSERT INTO met_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Awasa xai, labu ahatum xumana mana walingaima mana titia liu tai. Labu anung lang haringina buk xaung kakahaimgu tai, saing labu alibu kubolu diandiu tai. Nam xaidapka baguba bagula tuxuang bila bitinga tuxu asaxua. ");
INSERT INTO met_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Namua na bagula ma bila ba mana lipu longgalo duwa titia li. ");
INSERT INTO met_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Bungingbunginalo amaxania, saing asabu ba bagula agiti sangua axamandi bagula disok, asabu sanga ba ali Lipua Ma Rangua Urana maxania.” ");
INSERT INTO met_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Xaidap taining tainina Yesu tubatuba Urana Numania, saing bungbung taining tainina ila sangua bu wa Xaxagania Olip. ");
INSERT INTO met_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Baing buraraging sibuna lipu longgalo dima Urana Numania bu dilungu. ");
INSERT INTO met_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Taunga Mana Salanga Salalangang Teguama sokkuba. Yan tela bing Taunga Dalingam. ");
INSERT INTO met_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Baing lipu hananiangamdi yanamidingdi digabu lipu hanaunaunga tubatubainganamdi ding disai daxanga ba dung Yesu mati, namua na dimaxuwa lipudi bagula diti haunginga sabangua. ");
INSERT INTO met_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Baing ina naga, Satan luxu mana Yudas, duxu ba Iskariot, ina tela mana Lipu 12. ");
INSERT INTO met_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Baing Yudas ila rangua lipu hananiangamdi yanamidingdi digabu lipu haungingam duwasa mana Urana Numanoa yanamidingdi. Baing hangixaya ranguadi ba ta Yesu rimadingia baru. ");
INSERT INTO met_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Diyaha sibuna saing dibala ba bagula disina sianga na. ");
INSERT INTO met_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Naidi saing sai daxanga ba ta Yesu rimadingia. Ragu laing bungina buranga duwa rangua te. ");
INSERT INTO met_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tauna, Taunga Mana Salanga Salalangang Teguama sok. Mana xaidapka baguba, Yudadi kuboludinga bing dahanania sipsip tutubina mana Taunga Dalingam. ");
INSERT INTO met_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu soxi Pita Yon tang mala, bala dingtang ba, “Tang gala axauxau axamandi bu taxang Taunga Dalingam angianoa.” ");
INSERT INTO met_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Duxusunga ba, “Ubo ba tam gala mana long baruamta bu am gaxauxau?” ");
INSERT INTO met_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Baladi ba, “Bagu bungina tang galuxu long sabangia, lipu tela xuru bori langinam bagula sok mangtang. Tang gasu mana mala laing asok mana numa ina luxu mana ba, ");
INSERT INTO met_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","saing aharua na numa moxonoa ba, ‘Lipu Tubatubaingama xusunga ba: Lobu numa lunam kabila mana ngaxang Taunga Dalingam angianoa rangua lipuxigudi dinaxu manga?’ ");
INSERT INTO met_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Baing bagula hatanga nangtang numa luna sabanga etuam tela, kabukabudi duwa masup mana. La ba, axauxau angingua.” ");
INSERT INTO met_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Baing ina naga, tang dilauba, saing tang dibagu axamandi duwa bila Yesu baxanga nadi ba. Binabu daxauxau Taunga Dalingam angianoa la ba. ");
INSERT INTO met_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Xaidap maxanoa sokkuba, baing Yesu gabu aposel iniadi daxang kabukabia. ");
INSERT INTO met_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Baing harua nadi ba, “Nga murugu sibuna mana ngaxang angingua mana Taunga Dalingam ranguang muga mana ngaxap salaga. ");
INSERT INTO met_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Namua na ngabalang ba, nga bagula ngaxang alali muli te laing namua sok maxuna Urana Yonggaxinia.” ");
INSERT INTO met_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Baing xap wain xubanoa, harua xai sibuna na Urana, saing harua ba, “Axap, atuxu sinak mana liwe mang. ");
INSERT INTO met_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Namua na ngabalang ba bagula nganung wain muli te laing Urana Yonggaxinoa ma.” ");
INSERT INTO met_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Baing xap salangua, saking harua xai sibuna na Urana. Sup, baing utu saha, sina nadi, saing harua ba, “Alali mututungagua, ngasina bu hauliang. Alibu alali bu ahatumia nga muli.” ");
INSERT INTO met_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kimuya mana daxang, bila balau xap xubua, harua ba, “Xuba li haruanga haunua, Urana hau mana sibigua, matuxuya mari bu hauliang. ");
INSERT INTO met_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ne bagu, lipua wa kabukabia li bagula ta nga bixuagudi rimadingia, ina rung rangua nga bila riagua. ");
INSERT INTO met_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Lipua Ma Rangua Urana bagula mati bila Urana mogu ba. Ne laku, mauxanganoa bagula xap lipua ba ta bixuandi rimadingia.” ");
INSERT INTO met_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Baing dungguti duxusunga liwe mading ba dingia gaxarea bagula libu. ");
INSERT INTO met_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Baing lipudi dinaxu mana dahakhaxi mana gaxarea bagula wa mugamuga liwe mading. ");
INSERT INTO met_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu harua nadi ba, “Xaitamoxi mana Yuda Teguamdi diyaha ba dahatanga nadi ba ding haringingading. Ning duxu ding ba ‘Lipu Sinaikkamdi’. ");
INSERT INTO met_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ne heku awa bila ba. Tegu. Lipu gaxarea liwe mang bo ba wa mugamuga, bing kuboluna wa bila kaxukana. Yanamim gaxarea, bing kuboluna wa bila lipu haulingam. ");
INSERT INTO met_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Namua na lipu baruamta muga, lipua ba rung kabukabu xangingamia, kimbo ina sina angingua? Lipua rung? Maxung sibuna. Ne nga ngawa liwe mang bila lipu haulingam. ");
INSERT INTO met_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ang ba awa rangua nga, saing aluki sangua nga te bungina mauxangandi daxap nga. ");
INSERT INTO met_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Binabu ngasina Yonggaxigua nang, bila Tibugu sina nanga, ");
INSERT INTO met_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","bu ang garung ang gaxang mana kabukabugua Yonggaxigia, saing bu arung mana xaitamoxi kabukabundi saing asuxuya Isrel bakbakka 12. ");
INSERT INTO met_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Saimon, Saimon, bagu Satan xusunga Urana ba tubang bila lipudi diting wit mahaing bu ditibaxaya yoxodi mala. ");
INSERT INTO met_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ne ngasabu maung masup ba hatumingam haringina bagula xung mari masup te. Kimu, bungina ugoxoya ma rangua nga, bing uharingia riamdi bu dili haringina muli.” ");
INSERT INTO met_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ne haxuya ba, “Toxoratamona, ngaxauxau hatumingagua masup ba ngala salak yabania ranguaung, saing sanga ba ngamati ranguaung xauna.” ");
INSERT INTO met_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Baing Yesu haxuya ba, “Pita, ngabalaung ba, hatata muga mana muxaxua xatu, bagula uhatiam manga bunging tuwa.” ");
INSERT INTO met_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Baing Yesu xusungadi ba, “Waleu bungina ngasoxiang mala, axola mana tanga sianggam, tanga xaung xai sanggandi, bing araxap mana axamang tela kimbo tegu?” Dahaxuya ba, “Tegu.” ");
INSERT INTO met_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Harua nadi ba, “Ne hatata, gaxarea ung tangam sianggam kimbo tangam, bing oxop mala. Gaxarea oxola mana waxang sabanga bing usina imangima bu ugim tela, ");
INSERT INTO met_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","namua na dibung Urana Xuania ba, ‘Baing dimogu ina lipu dian tela.’ Baing ngabalang ba haruanga li bagula sok maxuna manga. Maxung sibuna, baraxinta dibung mari manga, aningonoa sok maxunauba.” ");
INSERT INTO met_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Lipudi dinaxu mana daharua ba, “Toxoratamona, ubagu, waxang sabanga luwadi li.” Baing harua ba, “Sanga lo.” ");
INSERT INTO met_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu ila sangua saing haing Xaxagania Olip, bila ina kubolunoa ba. Baing lipuxindi dinaxu mana dila xauna. ");
INSERT INTO met_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Disok saing harua nadi ba, “Asabu, nam tubaiga xapkang.” ");
INSERT INTO met_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sauyadi saing ila monga, bila lipua ting sianga mala, gung king tuxundi saing sabu ba, ");
INSERT INTO met_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tibugu, nabu ung murungama, bing unia xuba salakkamga li mala sangua nga. Ne heku usu mana murungagua, ne usu mana ung murungama.” ");
INSERT INTO met_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Baing Urana uleginam tela ri long xaiya ma, owa masok mana, saing haringia. ");
INSERT INTO met_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Gamonoa mauxang sibuna, binabu sabu haringing sibuna, saing salaksalaginoa sok bila sip marandi saing diri titia. ");
INSERT INTO met_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Sabu masup saing mesa goxoya ma rangua lipuxindi dinaxu mana, bagudi dikinu matabu, haringingading disup namua na ayangading buk. ");
INSERT INTO met_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Xusungadi ba, “Akinu baru? Amesa asabu, nam tubaiga xapkang.” ");
INSERT INTO met_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu haruauyu, baing buranga tela sok, saing lipua duxu ba Yudas, ina mana Lipu 12 tela, muga manadi. Ma haxek rangua Yesu bu libu, ");
INSERT INTO met_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ne Yesu xusunga ba, “Yudas, uraxata ulibu Lipua Ma Rangua Urana bu usina mala bixuandi rimadingia?” ");
INSERT INTO met_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bungina lipuadi dinaxu mana Yesu dibagu baraxinta bo ba sokkuba, duxusunga ba, “Toxoratamona, am gating waxangimam sabangadi manadi?” ");
INSERT INTO met_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Baing dingia tela ting waxanginoa mana lipu hananiangam mugamugangama lipuxing oxata olanggama, saing taxiti tangangliang rimamo. ");
INSERT INTO met_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ne Yesu harua ba, “Asauya!” Baing ring lipua tanganglianoa saing sok xai muli. ");
INSERT INTO met_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Baing Yesu harua na lipu hananiangamdi yanamidingdi, lipu haungingamdi duwasa mana Urana Numana yanamidingdi, xaung lipu haringindi dima bu dituxu ba, “Ai, ang gama xaung waxang sabangadi xaung xaidi bila nga lipu hanaunggam tela, bo? ");
INSERT INTO met_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Xaidapxaidapka lo ngawa ranguang, ngatubatuba Urana Numang yabania, ning atuxu nga te. Ne hatata ang xaidabima, xaidaba mana labiang haringinganoa wa etua mana axamandi.” ");
INSERT INTO met_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kimuya mana dituxu, daxai mala lipu hananiangam mugamugangama numania. Pita su manadi mala, ne wa hasoya monga. ");
INSERT INTO met_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ning bungina dibura yaba liwe mana numa yabana, dirungguba, baing Pita rung mari ranguadi. ");
INSERT INTO met_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Haing haulingam tela bagu rung mari yabia. Bagu haringina mana saing harua ba, “Lipua li wa rangua Yesu xauna.” ");
INSERT INTO met_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ne hatiam mana. Harua ba, “Haing, ngaxabia lipua ba teke.” ");
INSERT INTO met_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mongaita baing lipu tela bagu saing harua ba, “Ung xauna, ung dingia tela.” Ne Pita haxuya ba, “Lipu, nga riadinga te!” ");
INSERT INTO met_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Auwa tela ila sup baing tela muli harua haringina ba, “Maxung sibuna lipua li wa rangua, namua na Galili tela.” ");
INSERT INTO met_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pita haxuya ba, “Lipu, baraxinta uharua mana ba, ngaxabia teke!” Pita harua masup teguyu baing muxaxua xatu. ");
INSERT INTO met_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Toxoratamona xugia saing bagu maringina mana Pita. Baing Pita hatumia muli Toxoratamona haruanganoa menau harua mana ba, “Muga mana muxaxua xatu hatata, bagula uhatiam manga tuwa.” ");
INSERT INTO met_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Baing ina naga, Pita sok mala, tang haringing sibuna. ");
INSERT INTO met_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Lipuadi duwasa mana Yesu dungguti didaudau ditaha. ");
INSERT INTO met_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Disaku maxandi saing daharua ba, “Uhatanga ba ung Urana lipuxing suxunguxunguama! Ubaxanga, gaxarea tahaung?” ");
INSERT INTO met_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Baing daharua haruanga diang xumana na. ");
INSERT INTO met_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Buraraging sibuna baing lipudi lipuxiding haringindi, lipu hananiangamdi yanamidingdi xaung lipu hanaunaunga tubatubainganamdi digugunia. Baing lipudi duwasa mana Yesu daxai ma kaunsilidi bagudi li maxadingia. ");
INSERT INTO met_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kaunsilidi daharua ba, “Nabu ung Urana Lipuxing Mogunganama, bing ubaxanga nam.” Ne Yesu haxuya nadi ba, “Nabu ngabalang, bing bagula ahatum haringina mana haruangagua te. ");
INSERT INTO met_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Baing nabu ngaxusungang, bing bagula ahaxuya te. ");
INSERT INTO met_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ne hatata saing ila, Lipua Ma Rangua Urana bagula rung mana Urana haringingam kabukabung yayam wa rimang rimamo rubinia.” ");
INSERT INTO met_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ding duxusunga ba, “Baruta? Ubaxanga ba ung Urana Garanoa?” Haxuya ba, “Ang sibuim aharua ba. Nga baing.” ");
INSERT INTO met_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Baing daharua ba, “Heku tasaiʼm lipu tela muli su haruangua na! Kira talungu masup mana ing sibung suxungunoa.” ");
INSERT INTO met_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Baing ina naga, yanamgadi ba ding longgalo dimesa daxai Yesu mala rangua gabana Pailat. ");
INSERT INTO met_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Baing dungguti disu haruanga mana, daharua ba, “Am gabagu ba lipua li bo ba tam Yudadi daxanga diania. Biliam ba am gasina takis na Sisau tai. Harua ba xaitamoxi tela, Urana Lipuxing Mogunganama.” ");
INSERT INTO met_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Binabu Pailat xusunga Yesu ba, “Ung ba xaitamoxi Yuda dingia?” Baing Yesu haxuya ba, “Wane, bila ung guharua ba.” ");
INSERT INTO met_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Baing Pailat baxanga na lipu hananiangamdi yanamidingdi xaung buranga ba, “Ngabagu ina libu kubolu dian tela te.” ");
INSERT INTO met_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ne dahaxi, daharua ba, “Haxa mauli titia Yudia saing yumyum lipu longgalo mana tubatubainganoa. Ungguti mana titia Galili saing ma masup la li.” ");
INSERT INTO met_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat lungu alaba baing xusungadi ba nabu Yesu Galili tela. ");
INSERT INTO met_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Bungina lungu ba maxuna, Yesu wa hawa mana Xaitamoxi Herot, tauna, soxi mala rangua, namua na Herot wa mana long sabangga Yerusalem mana bungina baguba. ");
INSERT INTO met_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bungina Herot bagu Yesu, yaha sibuna, namua na mana bunging maxaxaya bo ba bagu. Lungu naxuyanganoa, baing bo ba bagu tongtongia axamang haringina. ");
INSERT INTO met_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Xusunga xusunga xumana, ne Yesu haxuya tela te. ");
INSERT INTO met_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Lipu hananiangamdi yanamidingdi digabu lipu hanaunaunga tubatubainganamdi dili la ba, saing disu haruanga haringina mana. ");
INSERT INTO met_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Baing Herot gabu lipuxing haungingamdi didaudau. Disausau imang gumangina mana, bu didaudau bila ina xaitamoxi tela, saing disoxi goxoya mala rangua Pailat. ");
INSERT INTO met_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mana xaidapka baguba Herot Pailat tang disok bila dingtang riading riading—muga mana bungina baguba tang duwa bixua mading. ");
INSERT INTO met_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat wagi lipu hananiangamdi yanamidingdi, lipu haringindi xaung lipudi dima, ");
INSERT INTO met_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","saing harua nadi ba, “Ang gaxap lipua li ma rangua nga bila lipua ta lipudi daxanga diania. Ngaxusunga xusunga maxaimia, ne ngabagu ing kubolung dian tela te. ");
INSERT INTO met_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot xauna bagu ing kubolung dian tela te. Namua naga soxi goxoya ma rangua nga muli. Alungu to! Libu axamang tela bu mogu ba mati te. ");
INSERT INTO met_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Binabu bagula ngagusi, saing bagula ngayunga mala.” ");
INSERT INTO met_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Baing ding duwagi bila waxutu taininau, duwagi ba, “Oxop lipua li mala bu mati! Uyunga Barabas nam!” ");
INSERT INTO met_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas dita salak yabania namua na iti haungingua long sabangga Yerusalem rangua gabman, xaung ung lipu tela mati.) ");
INSERT INTO met_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Mana namua Pailat bo ba yunga Yesu mala, xusungadi muli. ");
INSERT INTO met_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ning duwagiwagi ba, “Ung mati xai balingamia! Ung mati xai balingamia!” ");
INSERT INTO met_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Bunging tuwa xusungadi muli, harua ba, “Baruta? Libu kubolu diang baruamta? Ngabagu kubolu tela bu ngaung mati mana te. Binabu bagula ngagusi, saing bagula ngayunga mala.” ");
INSERT INTO met_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ne duwagi haringing sibuna ba ung mati xai balingamia. Dahaxi buk, saing haxingadinga dali, ");
INSERT INTO met_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","binabu Pailat hau hatuminganoa ba nai mana haruangadinga. ");
INSERT INTO met_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Baing lipua ba wa salak yabania namua na iti haungingua xaung ung lipu tela mati, lipua ba duxusunga mana, Pailat yunga mala, saing soxi Yesu mala bu mati bila muruding mana. ");
INSERT INTO met_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Daxai Yesu malau, baing dituxu Saimon, lipu tela mana long sabangga Sairin, ina sok sangua umangadi ma. Dilibu xoxi xai balingama saing ma kimu mana Yesu. ");
INSERT INTO met_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lipu xumana disu mana mala. Haingdi xauna disu mana, saing ditangia haringing sibuna. ");
INSERT INTO met_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ne Yesu xugia mala ranguadi saing harua nadi ba, “Haing Yerusalemgam mana, atangia ngau tai! Atangiang xaung garaimdi. ");
INSERT INTO met_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bagu namua na xaidaba ma bungina bagula aharua ba, ‘Xai sibuna mana haingdi duwa xuhi, mana haingdi dahayau te xaung haingdi disina suidingdi te!’ ");
INSERT INTO met_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Baing “ ‘bagula daharua na bimbidi ba, “Autuang mari mam!” Saing bagula daharua na xaxagandi ba, “Ayaxanggam!” ’ ");
INSERT INTO met_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Namua na nga bila xaiya gamata, saing abagu kubolua dilibu manga baing. Ne ang bila xaiya mutuxu—bagula diriang baru?” ");
INSERT INTO met_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Lipu diang luwa, daxai dingtang xaung Yesu mala bu dung dingtung mati. ");
INSERT INTO met_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Dila disok mana longga duxu ba Toxotaxu Guana. La ba digoxi xai balingamia xaung lipu diang luwadi ba, tela wa rimamo, tela wa xong. ");
INSERT INTO met_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu harua ba, “Tibugu, uyunga kuboluding diandi, namua na baraxinta dilibu, daxabia te.” Baing dahali halinga tela bu dibagu gaxarea bagula daxap imangindi. ");
INSERT INTO met_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Lipudi dili dibagu mua, saing lipudi yanamidingdi ditabia yungxadingdi mana. Daharua ba, “Hauli lipu teladi ba. Tauna, nabu ina Kristo ma rangua Urana, Urana Lipuxing Mogunganama, bing hauli ing sibuna.” ");
INSERT INTO met_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Lipu haungingamdi xauna, dima didaudau. Disina wain mabiana na ");
INSERT INTO met_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","saing daharua ba, “Nabu ung xaitamoxi Yuda dingia, bing ung guhauliung!” ");
INSERT INTO met_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mana xai tela digoxi etua mana toxonoa, dibung haruanga tela harua ba: Xaitamoxi Yuda Dingia. ");
INSERT INTO met_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Lipu tela digoxi xauna la ba ting haruanga daudaungam na, harua ba, “Ai, bola ung Urana Lipuxing Mogunganama, bo? Uhauliung saing uhauli amtam xauna!” ");
INSERT INTO met_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ning rianoa bili ba, “Baruta umaxuwa mana Urana te? Ung xauna dunggung bila ina. ");
INSERT INTO met_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Dilibu xai dung kira mana kubolura diandi, namua na kuboluradi giminagidinga naga. Ne lipua li libu kubolu dian tela te.” ");
INSERT INTO met_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Baing harua ba, “Yesu, bungina uluxu Yonggaximia, bing uhatumia nga muli.” ");
INSERT INTO met_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu haxuya ba, “Maxung sibuna ngabalaung ba, mana xaidapka baguli bagula uwa rangua nga long walinga xaiyamia.” ");
INSERT INTO met_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Xaidap liauba, baing labianoa kaukau titia masup laing bungbung. ");
INSERT INTO met_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Xaidaba sina te. Baing imang sabangga silola mua maluxu Urana Numania singina hataing luwa. ");
INSERT INTO met_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Baing Yesu wagi sabanga ba, “Tibugu, ngata aningogua mala rimamia.” Harua laing sup, baing matiuba. ");
INSERT INTO met_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Lipu haungingamdi yanamidinga bagu baraxinta sok, binabu iti Urana yanoa saing harua ba, “Maxung sibuna, lipua li lipu maringina.” ");
INSERT INTO met_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bungina lipuadi digugunia la ba dibagu axadi ba, dituru saing digoxoya mala. ");
INSERT INTO met_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ne lipudi daxabia Yesu, digabu haingdi disu mana ma titia Galili, ding dili hasoya monga, dibagu mua mana axadi bagudi ba. ");
INSERT INTO met_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Lipu tela wa, yanoa Yosep, Yuda Kaunsiliding tela, lipu xai xaung maringina. ");
INSERT INTO met_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ne ina nai mana yanam riandi hatumingadinga xaung kuboludinga te. Yabanoa titia Yudia long tela duxu ba Erimatea, saing ragu mana Urana Yonggaxinoa ma. ");
INSERT INTO met_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ila rangua Pailat saing xusunga mana Yesu sangganoa. ");
INSERT INTO met_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Baing xap mari, saku mana imang xai sibung tela, saing ta maluxu mana guha gobagoba tela disaba sianga maluxu mala. Dikimang matia tela maluxu mana teguyu. ");
INSERT INTO met_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Xaidapka ba Paraide, duxu ba Xaidap Xauxaungam, saing Xaidap Yaguangam ma haxek sibunauba. ");
INSERT INTO met_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Haingdi dima titia Galili rangua Yesu ma ba, disu mana Yosep saing dibagu guha gobagobua, xaung ta Yesu sangganoa mari maluxu mana baru. ");
INSERT INTO met_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Baing digoxoya mala numia saing daxauxau guxenga baxiam saminam bu disabaxaya Yesu sangganoa. Ne diyagua mana Xaidap Yaguangam bu disu mana hanaunaungua. ");
INSERT INTO met_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mana xaidap mugamugangam mana sande baguba, buraraging sibuna haingdi daxap guxenga baxiam saminam daxauxau ba, saing dila guhia gobagobia. ");
INSERT INTO met_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Disok saing dibagu ba sianga wa xuania te, ");
INSERT INTO met_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ne bungina diluxu, dibagu Toxoratamona Yesu sangganoa te. ");
INSERT INTO met_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Dahatumhatum mana, baing hata sibuna li lipu luwa disau imangdi disina bila bilikbiliga, dili haxek manadi. ");
INSERT INTO met_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Dimaxuwa sibuna binabu digung kiding tuxundi mari, saing dituru mari titia. Ne lipuadi ba tang daharua nadi ba, “Ang gasai mana lipu walingam mana long matiama baru? ");
INSERT INTO met_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wa la li te. Mesa muli ba! Ahatumia muli harua baru bungina wauyu ranguang titia Galili: ");
INSERT INTO met_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Lipua Ma Rangua Urana bagula dita lipu kubolu dianamdi rimadingia bu dung mati xai balingamia, saing mana xaidap tuwa bagula mesa muli.’ ” ");
INSERT INTO met_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Baing ina naga, dahatumia haruanganoa muli. ");
INSERT INTO met_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Digoxoya guha gobagobia ma, baing dibaxanga axadi li na Lipu 11 xaung na lipu teladi disu mana. ");
INSERT INTO met_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Hainggadi ba dibaxanga na aposeldi bing Maria Magdalam, Yoana, Yems bauna Maria, dingtung digabu teladi. ");
INSERT INTO met_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ne dahatum haringina mana haingdi haruangadinga te, namua na dahatum ba haruanga kakahana. ");
INSERT INTO met_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ning Pita mesa saing luki mala guhia gobagobia. Nenia maluxu, saing bagu imang xaidi disaku mana ba duwa olang. Baing goxoya ma saing hatum hatum mana baraxinta sok ba. ");
INSERT INTO met_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mana xaidapka baguba dingia luwa tang dila mana long tela duxu ba Imeas, wa hasoya monga mana long sabangga Yerusalem, bila 11 kilomita. ");
INSERT INTO met_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tang dahangixaya liwe mading mana baraxinta disok ba. ");
INSERT INTO met_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tang dahaxa malau, dahangixayau, baing Yesu ing sibuna sok rangua dingtang saing gabudi dahaxa mala, ");
INSERT INTO met_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ne axamang tela soxautidi bu dibagu daxabia te. ");
INSERT INTO met_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Xusunga dingtang ba, “Tang gahangixaya mana baraxinta bungina ahaxa mala?” Tang dili mua, ramramodingdi ayangading. ");
INSERT INTO met_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Dingia tela, yanoa Kliopas, xusunga ba, “Si, ung Yerusalem lobuam taininau ung ganim uxabia baraxinta sok la ba mana xaidapkadi bagudi li te?” ");
INSERT INTO met_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Xusunga ba, “Baraxintadi?” Tang dahaxuya ba, “Axadi disok mana Yesu Nasaretiam. Ina Urana lipuxing suxunguxunguam tela ba, ina haruanganoa xaung kuboluna, daharing haringing sibuna mana Urana xaung lipudi maxadingia. ");
INSERT INTO met_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ne lipu hananiangamdi yanamidingdi digabu lipuximam haringindi, ding dita Romdi rimadingia bu dung mati, saing digoxi xai balingamia. ");
INSERT INTO met_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ne am ba, am gahatum gamomamia ba lipua ba bagula hauli Isreldi sangua bixuaradi rimadingia. Baing axamang tela muli, hatata xaidap tuwa disup mana axadi bagudi ba disok. ");
INSERT INTO met_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Tela bing haing teladi ranguam dilibu am gahixi mana haruangadinga. Menau buraraging sibuna dila guhia gobagobia, ");
INSERT INTO met_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ne dibagu sangganoa te. Disai susu. Digoxoya ma dibalam ba dibagu Urana uleginam luwa tang dibaladi ba gamata muli! ");
INSERT INTO met_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Baing riamam teladi dila guhia gobagobia dibagu bila haingdi dibaxanga ba, ne dibagu Yesu te.” ");
INSERT INTO met_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Baing Yesu baladi ba, “Angtang kakahaim baru? Gamoim diriba ding bu ahatum haringina sap te mana Urana lipuxing suxunguxunguamdi haruangadinga! ");
INSERT INTO met_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Maxung sibuna lipuadi ba daharua ba Kristo bagula xap salaga muga, saing kimuya bagula xap yaya sabanga.” ");
INSERT INTO met_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Baing ungguti mana Moses xaung Urana Lipuxing Suxunguxunguamdi xailongidingdi, saing baxanga rangrang na dingtang ba haruanga wa Urana Xuania harua mana ina ba. ");
INSERT INTO met_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Disok haxek mana longga dibo ba dila mana ba, baing Yesu libu bila bagula dali longga ba. ");
INSERT INTO met_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ne tang duxusunga haringina ba, “Uwa ranguamtam, namua na yambongguba. Xaidaba riuba.” Binabu ila bu wa ranguadi. ");
INSERT INTO met_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bungina wa ranguadi kabukabu xangingamia, xap salanga, harua xai sibuna na Urana mana, utu saha saing ungguti sina nadi. ");
INSERT INTO met_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Baing ina naga, maxading daxaxa ding saing tang daxabia ba Yesu naga, saing hata sibuna li hanggalang muli maxadingia. ");
INSERT INTO met_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Duxusunga ding ba, “Ai, maxung sibuna hatumingaradi diyaha sibuna bungina baxanga nakira daxangia, bungina tubatuba kira rangrang mana Urana Xuanoa?” ");
INSERT INTO met_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Hata sibuna li dimesa saing digoxoya mala Yerusalem. La ba dibagu Lipu 11 xaung teladi digugunia, ");
INSERT INTO met_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","saing daharua na dingtang ba, “Maxung sibuna! Toxoratamona mesa muli saing owa masok rangua Saimon.” ");
INSERT INTO met_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Baing tang dinaxuya baraxinta sok daxangia, saing dibagu daxabia Yesu bungina utu saha salanga baru. ");
INSERT INTO met_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Dinaxuyauyu, baing Yesu ing sibuna sok manadi, li liwe manadi saing baladi ba, “Gamoimdi duwa mosiu.” ");
INSERT INTO met_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Dihixi mana, dimaxuwa, dahagaxa ba tauxai tela. ");
INSERT INTO met_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Baladi ba, “Ahatum xumana baru? Baruta hatuminga luwa dimesa hatumingaimia mana nga gaxarea? ");
INSERT INTO met_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Abagu rimagudi xaung kigudi. Nga baing! Aring nga bu axabia. Tauxai mututungana xaung tuandi bila nga te.” ");
INSERT INTO met_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Harua laing sup, baing hatanga rimandi xaung kindi nadi. ");
INSERT INTO met_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Hatumingadingdi daharing teguyu, namua na dihixi mana diyaha mana, binabu xusungadi ba, “Angiaimgu?” ");
INSERT INTO met_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Baing disina song waxungam tela na, ");
INSERT INTO met_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","saing xap, xang maxadingia. ");
INSERT INTO met_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Baladi ba, “Haruanga baguli ngabaxanga nang bungina ngawa ranguang nulana ba: Axamang longgalo duwa mana Moses Hanaunaungandi, Urana Lipuxing Suxunguxunguamdi xaung Olaidi, bing aningoding disok to.” ");
INSERT INTO met_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Baing xaxa hatumingadinga bu daxabia Urana Xuanoa rangrang. ");
INSERT INTO met_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Baladi ba, “Urana Xuanoa harua ba, Urana Lipuxing Mogunganama bing xap salaga muga baing mesa muli mana xaidap tuwa. ");
INSERT INTO met_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Saking ungguti mana long sabangga Yerusalem, mana yanoa bagula lipudi dibaxanga mana titi longgalo ba lipudi duxugia hatumingadingdi, baing bagula Urana yunga kuboludingdi. ");
INSERT INTO met_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ang ba lipuadi abagu axadi li, saing bagula abaxanga na lipudi manadi. ");
INSERT INTO met_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Bagu bagula ngasina axamanoa nang ba Tibugu hau haruangua ba bagula sina—Aningona baing. Ning muga awa maluxu mana long sabangga li laing axap Urana haringinganoa.” ");
INSERT INTO met_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Baing muga manadi masok, saing dila haxek mana longga Betani. La ba iti rimandi saing guxamdi. ");
INSERT INTO met_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Haruauyu baing ina naga, yungadi, Urana xap mahaing long xaiya. ");
INSERT INTO met_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Baing diti yanoa saing digoxoya mala long sabangga Yerusalem, gamodingdi diyaha sibuna. ");
INSERT INTO met_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Baing xaidap taining tainina dila duwa Urana Numania, diti Urana yanoa. ");
INSERT INTO met_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mugamugau sibuna, Haruanga wau. Haruanga ba wa rangua Urana, saing Haruanga ba Urana naga. ");
INSERT INTO met_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Wa rangua Urana mugamugau sibuna. ");
INSERT INTO met_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ina naga Urana xap axamang longgalo masok mana. Axamang longgalo disok, disok mana daxanga tela te. Disok mana ing sibuna. ");
INSERT INTO met_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Walinga namua wa rangua, saing walinga ba sina lulianoa na lipu longgalo. ");
INSERT INTO met_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lulianoa saxaxangia labianoa, ne labianoa sanga ba dali te. ");
INSERT INTO met_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Lipu tela Urana soxi ma, yanoa Yon. ");
INSERT INTO met_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ma bila lipu baxangangam, bu baxanga luliana ba, bu lipu longgalo sanga ba dilungu dahatum haringina mana. ");
INSERT INTO met_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ing sibuna luliana ba te, ne ma bu baxanga luliana ba. ");
INSERT INTO met_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Baing luliang sibuna sina lulianoa na lipu longgalo ba, ri ma titiauba. ");
INSERT INTO met_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ma wa titia. Ina naga Urana xap axamang longgalo duwa titia masok mana. Baing tegu. Lipu titiamdi dibagu daxabia te. ");
INSERT INTO met_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ila yabania, ne bakbagindi daxap te. ");
INSERT INTO met_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ne lipu gaxarea daxap, lipu gaxarea dahatum haringina mana yanoa, lipuadi ba ina libudi disok Urana garandi. ");
INSERT INTO met_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Disok Urana garandi mana baudingtibudingdi sibidingdi te, kimbo mana lipu tela murunganoa te, kimbo mana namua lipu tela bo ba xap garadi disok bila ina te. Tegu. Urana ing sibuna libudi disok garandi. ");
INSERT INTO met_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Baing Haruanga sok lipu, saing ma wa liwe mam. Am gabagu ralanoa ba, ralanoa mana Gara taininau baguli, ma rangua Tibuna. Baxagi mana kubolua atin dimoti xaung haruanga maxunama. ");
INSERT INTO met_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yon baxanga mana. Wagi saing harua ba, “Lipua naga ngaharua mana ba, ‘Lipu tela ma kimu manga, yanoa dali ngayua namua na wa muga mana bungina ngasok teguyu.’ ” ");
INSERT INTO met_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kubolua atin dimoti baxagi sibuna mana. Saing mana kuboluna li kira longgalo taxap guxam tela, saing tela, saing ila. ");
INSERT INTO met_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Namua na hanaunaungua ma Moses rimania, ne kubolua atin dimoti xaung haruanga maxunama ma Yesu Kristo rimania. ");
INSERT INTO met_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Waleu ma lipu tela bagu Urana te, ne Urana Taininau ba, wa Tibuna rubinia, ing ganina baxanga Urana nakira. ");
INSERT INTO met_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yon baxanga bungina Yudadi yanamidingdi disoxi lipu hananiangamdi xaung Libaidi duwa Yerusalem mala rangua bu duxusunga ba, “Ung gaxarea?” ");
INSERT INTO met_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Baing tula maringina nadi, yamengina te, harua sabasabia ba, “Nga ba nga Urana Lipuxing Mogunganama te.” ");
INSERT INTO met_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Baing duxusunga ba, “Ne ung gaxarea? Ung Elaitsa?” Baing harua ba, “Nga te.” Baing duxusunga ba, “Ung Urana Lipuxing Suxunguxunguama am garagu mana ba?” Haxuya ba, “Tegu.” ");
INSERT INTO met_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Binabu duxusunga muli ba, “Ne ung gaxarea? Ubaxanga nam bu sanga ba am gahaxuya haruanga maringina na lipuadi disoxiam ma. Uharua baru mana ung sibum?” ");
INSERT INTO met_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Baing Yon haxuya Urana lipuxing suxunguxunguama Aisaya haruanganoa nadi ba, “Nga lipua naga waxungtuanoa wagi mua long xoliania ba, ‘Atongtongia daxanga maringina mana Toxoratamona.’ ” ");
INSERT INTO met_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","(Adi duxusunga Yon ba Parisidi disoxidi ma.) ");
INSERT INTO met_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Baing duxusunga ba, “Nabu ung Urana Lipuxing Mogunganama te, ung Elaitsa te, xaung ung Urana Lipuxing Suxunguxunguama te, bing baruta usugua lipudi?” ");
INSERT INTO met_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yon haxuya nadi ba, “Nga ba ngasugua lipudi mana langa, ne lipu tela li mua liwe mang, ang ba axabia te. ");
INSERT INTO met_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ina naga ma kimu manga, ne sanga mana ba ngaunia xaing sanggandi te, namua na yanoa dali ngayua sibuna.” ");
INSERT INTO met_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Axadi bagudi li disok mana longga Betani, Langga Yodan hataina, longga Yon sugua lipudi mana. ");
INSERT INTO met_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Buragina baing Yon bagu Yesu ma rangua saing harua ba, “Bagu Urana Sipsibing Tutubina, ina sisia lipu titiamdi kuboluding diandi! ");
INSERT INTO met_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Lipua naga ngaharua mana ba, ‘Lipu tela ma kimu manga, yanoa dali ngayua namua na wa muga mana bungina ngasok teguyu.’ ");
INSERT INTO met_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Muga nga sibugu ngabagu ngaxabia te, ne namua ngama ngasugua lipudi mana langa bing sanga ba Isreldi dibagu daxabia.” ");
INSERT INTO met_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Baing Yon baxanga bu dahatum haringina mana: “Ngabagu Urana Aningonoa ri ma mana bila baxaliku, saing wa mana. ");
INSERT INTO met_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Muga nga sibugu ngabagu ngaxabia te, ning bungina Urana soxi nga ma bu ngasugua lipudi mana langa, ina harua nanga ba, ‘Lipua ubagu Aningogua ri ma wa mana, ina naga bagula sugua lipudi mana Aningogua.’ ");
INSERT INTO met_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nga ba ngabagu axadi ba, baing ina naga ngabaxanga ba lipua ba Urana Garanoa.” ");
INSERT INTO met_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Buragina baing Yon li mua la ba muli rangua lipuxing luwa dinaxu mana. ");
INSERT INTO met_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Bungina bagu Yesu ma ila, harua ba, “Bagu Urana Sipsibing Tutubina naga!” ");
INSERT INTO met_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Lipuxing luwa dinaxu mana ba dilungu haruanga baguba, baing dila dinaxu mana Yesu. ");
INSERT INTO met_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Baing Yesu xugia mala rangua dingtang, bagu dingtang dinaxu mana saing xusungadi ba, “Abo mana baraxinta?” Tang daharua ba, “Rabai” (namuxina Lipu Tubatubaingama), “uwa mana numa baruamta?” ");
INSERT INTO met_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Haxuya na dingtang ba, “Tang gama abagu.” Binabu dila dibagu numa wa mana ba, saing duwa rangua mana xaidapka ba. Bungbung bila 4:00. ");
INSERT INTO met_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Baing Andru, Saimon Pita kixinginoa, bing dingtangia tela muga lungu Yon haruanganoa saing naxu mana Yesu. ");
INSERT INTO met_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Baing yunga Yesu saing hata sibuna li ila sai mana sabanganoa Saimon, saing bala ba, “Am gabagu Urana Lipuxing Mogunganama baing.” (Haruanga Urana Lipuxing Mogunganama namuxina bing Kristo.) ");
INSERT INTO met_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Baing xap ma rangua Yesu. Yesu bagu saing harua na ba, “Ung Saimon, Yon garanoa. Ne hatata ila, bagula duxu yama ba Sipas” (bungina duxugia yaya baguli, namuxinoa bing Pita). ");
INSERT INTO met_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Buragina baing Yesu hau hatumingua ba ila titia Galili. Sok mana Pilip saing harua na ba, “Unaxu manga.” ");
INSERT INTO met_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Baing Pilip, yabanoa longga Betsaida. Andru Pita tang yabadinga xauna. ");
INSERT INTO met_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip ila sok mana Natanyel, saing bala ba, “Am gabagu lipua Moses bung mana bungina bung hanaunaungua, saing Urana lipuxing suxunguxunguamdi dibung mana xauna. Ina Yesu Nasaretiam, Yosep garanoa.” ");
INSERT INTO met_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Baing Natanyel haxuya na ba, “Nasaret! Sanga ba axamang xai tela sok ma mana longga ba te.” Pilip harua na ba, “Uma ubagu to.” ");
INSERT INTO met_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Bungina Yesu bagu Natanyel haxa mauyu, harua mana ba, “Bagu lipua li Isrel sibung tela. Kubolu languangam tela wa mana te.” ");
INSERT INTO met_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Baing Natanyel xusunga ba, “Uxabia nga baru?” Baing Yesu haxuya ba, “Muga mana Pilip wagi maung, ngabagung urung xaiya pik namuya.” ");
INSERT INTO met_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Baing ina naga Natanyel baxanga ba, “Lipu Tubatubaingam, ung Urana Garanoa, ung Xaitamoxi Isreliama!” ");
INSERT INTO met_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Baing Yesu harua na ba, “Ung guhatum haringina namua na ngaharua ba ngabagung xaiya pik namuya. Ne kimuya bagula ubagu axamang haringindi didali axa li.” ");
INSERT INTO met_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Baing harua muli ba, “Maxung sibuna ngabalang ba, bagula abagu long xaiya xaxaina, xaung Urana uleginamdi dahaing diri mana Lipua Ma Rangua Urana.” ");
INSERT INTO met_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Xaidap luwa disup, baing yaunga taungam tela sok longga Kena mana titia Galili. Yesu bauna wa la ba, ");
INSERT INTO met_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","saing duxusunga Yesu gabu lipuxindi dinaxu mana ba dima taungia xauna. ");
INSERT INTO met_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Wain disup baing Yesu bauna harua na ba, “Wainiding disup lo.” ");
INSERT INTO met_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu haxuya na ba, “Baugu, axamang ngayua te. Bunging ngayua teguyu.” ");
INSERT INTO met_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Baing bauna harua na lipu oxatamdi ba, “Alibu baraxinta balang mana ba.” ");
INSERT INTO met_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Baing nanggola sianggam sabanga 6 duwa haxek, oxatadinga bing Yudadi didamia ding bu disu mana hanaunaungadinga, tubungadinga sanga mana bila 80 ila 120 litadi mana taining tainina. ");
INSERT INTO met_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu harua nadi ba, “Axu nanggoladi langia.” Binabu duxudi laing masok xuadingia. ");
INSERT INTO met_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Baing baladi ba, “Tauna, asolia teladi saing axap mala rangua taunga lipuxing wasanganama.” Dilibu laing sup, ");
INSERT INTO met_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","baing taunga lipuxing wasanganama tuba langga xugia masup mala sok wain ba. Ina xabia te daxap bi, ning lipu oxatamdi disolia ba daxabiau. Baing wagi lipu yaunga haunama ila singia ");
INSERT INTO met_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","saing harua ba, “Bungingbunginalo lipudi daxap wain xai sibunama masok muga. Baing bungina lipudi dinung haringing sibuna, daxap wain siang kaxukanama ma. Ning usaxangia wain xai sibuna laing hatata oxop ma.” ");
INSERT INTO met_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Alali axamang haringing mugamugangama Yesu libu, libu mana longga Kena mana titia Galili. Binabu hatanga ralanoa sabasabia, saing lipuxindi dinaxu mana dahatum haringina mana. ");
INSERT INTO met_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kimuya baing Yesu ri mala long sabangga Kaperneam gabu bauna, kixingindi xaung lipuxindi dinaxu mana. Baing duwa la ba xaidap teladi. ");
INSERT INTO met_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Baing Taunga Dalingama mana Yudadi ma haxekkuba, baing Yesu haing mala long sabangga Yerusalem. ");
INSERT INTO met_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Maluxu mana Urana Numang yabanoa bagu lipuadi disina bulmakaudi, sipsipdi xaung baxalikudi, xaung lipu teladi dirung mana kabukabudi dahakhaxuya siangdi. ");
INSERT INTO met_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Binabu xap waxu kaxukandi hip waxu gusingam tela, saing suka lipuadi ba sangua Urana Numang yabanoa, ding digabu sipsibidingdi xaung bulmakaudingdi. Tibaxaya lipu siang hakhaxuyanganamdi siangidingdi saing matuxuya kabukabudingdi. ");
INSERT INTO met_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Bala lipudi disina baxalikudi ba, “Axapdi mala! Labu axugia Tibugu numanoa mala sok nawau tai!” ");
INSERT INTO met_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Lipuxindi dinaxu mana dahatum muli haruanga Aisaya bung Urana Xuania ba, “Murungagua mana numama haring buk bila yaba tau lugua.” ");
INSERT INTO met_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Baing Yudadi yanamidingdi dahaxi mana, duxusunga ba, “Bagula ulibu axamang haringina baru bu uhatanga nam ba ung yaya sabanga bu ulibu bila li?” ");
INSERT INTO met_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Baing Yesu haxuya nadi ba, “Axui Urana Numana baguli, baing bagula ngaiti muli mana xaidap tuwa.” ");
INSERT INTO met_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yudadi yanamidingdi dahaxuya ba, “Baruta? Urana Numana baguli, lipudi duwaxata niani 46 ba ditongtongia, ning ung ba bagula uiti muli mana xaidap tuwa?” ");
INSERT INTO met_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ning Urana Numana Yesu harua mana ba, bing sangganoa baing. ");
INSERT INTO met_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kimuya mana mesanganoa muli, lipuxindi dinaxu mana dahatum muli mana haruanganoa. Baing ina naga, dahatum haringina mana Urana Xuanoa xaung haruanga Yesu harua mana ba. ");
INSERT INTO met_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu wa Yerusalem mana Taunga Dalingama, baing lipu xumana dibagu axamang haringindi libudi saing dahatum haringina mana yanoa. ");
INSERT INTO met_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ning Yesu hatum haringina manadi te, namua na xabia lipu longgalo hatumingadingdi. ");
INSERT INTO met_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Raxap mana lipu tela baxanga lipudi kuboludingdi na te, namua na xabia axamandi duwa maluxu lipudi hatumingadingia. ");
INSERT INTO met_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tauna, lipu tela wa, Parisi tela yanoa Nikodimas. Yudadi yanamiding tela. ");
INSERT INTO met_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ila rangua Yesu yambong saing harua na ba, “Lipu Tubatubaingam, am gaxabia ba ung lipu tubatubaingam tela ma rangua Urana. Namua na lipu tela te sanga ba libu axamang haringindi ulibudi nabu Urana wa rangua te.” ");
INSERT INTO met_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu haxuya haruanganoa bila li: “Maxung sibuna ngabalaung ba, lipu gaxarea hayauxingang luwa te, sanga ba bagu Urana Yonggaxinoa te.” ");
INSERT INTO met_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimas xusunga ba, “Nabu lipu tela wa duanga, bing dahayau muli baru? Baruta luxu muli bauna gamonia saing hayau muli?” ");
INSERT INTO met_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu haxuya ba, “Maxung sibuna ngabalaung ba, nabu lipu hayauxinganoa sok mana lang xaung Urana Aningonoa te, bing sanga ba luxu Urana Yonggaxinia te. ");
INSERT INTO met_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Axa sangga xap masok bing sangga, saing axa Urana Aningonoa xap masok bing aningoningo. ");
INSERT INTO met_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Uraxata uhixi mana haruangagua ba, ‘Bing axap hayauxinga luwa?’ ");
INSERT INTO met_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yanga yubua long baruamta muruna mana. Ulungu bibinganoa, ne sanga ba uxabia long baruamta ma mana kimbo ila mana te. Bila balau mana lipudi daxap hayauxingading haunua rangua Urana Aningonoa.” ");
INSERT INTO met_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimas xusunga ba, “Alaba sanga ba sok baru?” ");
INSERT INTO met_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu haxuya na ba, “Ung ba ung Isrel lipu tubatubaingam sabanga, ne uxabia axadi bagudi li te? ");
INSERT INTO met_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Maxung sibuna ngabalaung ba, am gaharua mana axadi am gaxabiadi ba, saing am gabaxanga axadi am gabagudi, ning ang gaxap haruangamama te, ang gahatum haringina mana te. ");
INSERT INTO met_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ngaharua nang mana axamang titiamdi saing ahatum haringin te. Binabu nabu ngaharua nang mana axamang long xaiyamdi, bing bagula ahatum haringina manadi baru? ");
INSERT INTO met_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Waleu ma lipu tela luxu long xaiya te. Ne Lipua Ma Rangua Urana ri long xaiya ma—ing ganina luxu. ");
INSERT INTO met_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Bila Moses goxi moxa babunoa xaiya saing iti mahaing long xoliania, bila balau Lipua Ma Rangua Urana bing bagula diti mahaing, ");
INSERT INTO met_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","bu lipu longgalo dahatum haringina mana sanga ba daxap walinga subingang teguama. ");
INSERT INTO met_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Namua na Urana muruna buk mana lipu titiam longgalo, binabu sina Garang taininau nadi, bu lipu gaxarea dahatum haringina mana bagula dahanggalang te. Tegu. Bagula daxap walinga subingang teguama. ");
INSERT INTO met_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Namua na Urana soxi Garanoa ma titia bu sina salaga nadi mana kuboluding diandi te. Tegu. Soxi ma bu xap lipu titiamdi muli. ");
INSERT INTO met_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Lipu gaxarea dahatum haringina mana bagula daxap salaga mana kuboluding diandi te, ning lipu gaxarea dahatum haringina te dahanggalang masup haruangia, namua na dahatum haringina mana Urana Garang taininau te. ");
INSERT INTO met_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Urana haruangang suxuyanganama bing: Lulianoa ri ma titia, ning lipudi muruding sibuna mana labianoa. Muruding sibuna mana lulianoa te, namua na kuboludingdi didoa. ");
INSERT INTO met_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Lipu longgalo dilibu kubolu diandi hauxading sibuna mana lulianoa, saing bagula disok luliania te, nam kuboludingdi disok sabasabia. ");
INSERT INTO met_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ning lipu gaxarea su mana haruanga maxunama ma luxu luliania, bu sanga ba lipudi dibagu maringina ba axadi libudi, libudi mana Urana haringinganoa.” ");
INSERT INTO met_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kimuya baing Yesu gabu lipuxindi dinaxu mana dila titia Yudia. La ba wa ranguadi saing sugua lipudi. ");
INSERT INTO met_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Baing Yon xauna sugua lipudi longga Ainon haxek mana longga Salim, namua na lang xumana duwa mana longga baguba, xaung lipu xumana dima bu daxap langa. ");
INSERT INTO met_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Axadi li disok muga mana dita Yon salak yabania.) ");
INSERT INTO met_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tauna, hakhaxinga tela sok liwe mana lipudi dinaxu mana Yon xaung Yuda tela. Dahakhaxi mana Yudadi kuboludinga didamia axamandi bu disok sigixinga Urana maxania. ");
INSERT INTO met_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Baing dima rangua Yon daharua na ba, “Lipu Tubatubaingam, lipua muga wa ranguaung Langga Yodan hataina—lipua ubaxanga mana—lipua ba hatata sugua lipudi, saing lipu longgalo dila rangua!” ");
INSERT INTO met_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yon haxuya haruangadinga ba, “Nabu Urana wa long xaiya sina axamang tela na lipu tela te, bing sanga ba lipua ba xap te. ");
INSERT INTO met_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ang sibuim alungu haruangagua ngaharua masup ba, ‘Nga Urana Lipuxing Mogunganam te, ne soxi nga muga mana.’ ");
INSERT INTO met_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Bila li: Mana yaunga taungam, lipua yau hainga ing ganina yanoa sabanga. Lipu yaunga haunam rianoa li haxek rangua saing yaha bu hauli, saing yaha sibuna bungina lungu waxungtuanoa. Bila balau ngayaha, saing hatata yahanga ba baxagi manga. ");
INSERT INTO met_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Lipua ba yanoa bing tubu mala, saing ngayua bing ri. ");
INSERT INTO met_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Lipua ri long xaiya ma, ina wa etua mana lipu longgalo. Ne lipu titiam ina yabanoa, ina lipu titiam, saing harua bila lipu titiam. Lipua ri long xaiya ma, ina wa etua mana lipu longgalo. ");
INSERT INTO met_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Baxanga axadi bagudi lungudi, ning lipu tela xap haruanganoa te. ");
INSERT INTO met_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ne lipu gaxarea xap haruanganoa ba hatanga hatuminganoa masok ba Urana lipu maxunam. ");
INSERT INTO met_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Namua na lipua Urana soxi ma ba baxanga Urana haruanganoa, namua na Urana sina Aningonoa na masup, subingan tate. ");
INSERT INTO met_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tibuna murung sibuna mana Garanoa saing ta axamandi rimania. ");
INSERT INTO met_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Lipu gaxarea hatum haringina mana Garanoa xap walinga subingang teguama, ning lipu gaxarea lungu haruanganoa te bagula bagu walingua te, namua na Urana ating salianoa wa mana.” ");
INSERT INTO met_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesu xabia Parisidi dilungu ba xap lipu xumana disu mana saing suguadi. Saing lipuxindi titingadinga dali Yon lipuxindi. ");
INSERT INTO met_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ne Yesu ing sibuna sugua lipudi te, lipuxindi dinaxu mana disuguadi. ");
INSERT INTO met_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Xabia dilungu bila ba, binabu yunga titia Yudia saing goxoya mala titia Galili muli. ");
INSERT INTO met_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ne daxanga ila mana ba kisi mala mana titia Samaria. ");
INSERT INTO met_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Baing sok mana long tela wa Samaria duxu ba Sikar, wa haxek mana titia waleu sibuna Yekop sina na garanoa Yosep. ");
INSERT INTO met_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Baing Yekop langing banggumina wa la ba. Yesu sangganoa malai mana haxangua, binabu rung mari lang bangguming rubinia. Bila xaidap liauba. ");
INSERT INTO met_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Bungina haing Samariam tela ma bu solia lang, Yesu harua na ba, “Sanga mana ulia nga lang?” ");
INSERT INTO met_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Lipuxindi dinaxu mana dila masup gananga sabangia ba bu digim anginga.) ");
INSERT INTO met_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Binabu haing Samariama harua na ba, “Ung Yuda tela xaung nga haing Samariam. Uxusunga nga ba ngauliaung lang baru?” (Xusunga bila ba namua na Yudadi ditaga rangua Samariadi te.) ");
INSERT INTO met_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Baing Yesu haxuya na ba, “Nabu uxabia yahangua Urana bo ba sina, xaung lipua xusungaung ba ulia lang, nabu uxabia axadi ba, bing bagula uxusunga saing bagula uliaung lang walingam.” ");
INSERT INTO met_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Hainga harua na ba, “Lipu sabanga, ung goxola mana nanggola ba usolia lang saing lang banggumina suana. Bagula oxop lang walingamga ba bi? ");
INSERT INTO met_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ung ba yama dali mugangamama Yekop? Ina sina lang banggumina li nam saing ing sibuna nung mana, ina xaung garandi xaung morundi.” ");
INSERT INTO met_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu haxuya na ba, “Lipu longgalo dinung langga li bagula langa ungdi muli, ");
INSERT INTO met_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ning lipu gaxarea dinung langga ngasina, sanga ba langa ungdi muli te. Maxung sibuna, langga ngasina bagula sok lang maxana maluxu mana, bokboga mahaing bungingbunginalo, bu sina walinga subingang teguama.” ");
INSERT INTO met_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Hainga harua na ba, “Lipu sabanga, ulia nga langga ba bu langa ung nga muliu tai. Heku mana ngama la li bu ngasolia lang muli.” ");
INSERT INTO met_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu bala ba, “Ula ubala ayuam, tang gama to.” ");
INSERT INTO met_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Hainga haxuya na ba, “Ayuagu te.” Yesu harua na ba, “Uharua maxung sibuna bungina uharua ayuam te. ");
INSERT INTO met_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Maxung sibuna, ayuamdi luwadi luwadi hiliadinga ba, saing lipua hatata uwa rangua ayuam te. Haruangama maxung sibuna.” ");
INSERT INTO met_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Hainga harua na ba, “Lipu sabanga, hatata ngabagung Urana lipuxing suxunguxunguam tela. ");
INSERT INTO met_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Binabu ubaxanga nanga: Mugangamamdi disabu mana bimbia li, ne ang Yudadi ahaxi mana longga tasabu mana bing Yerusalem. Gaxarea harua maxuna?” ");
INSERT INTO met_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu harua na ba, “Haing, uhatum haringina mana haruangagua li: Xaidaba mauba, bagula asabu mana Tibura mana bimbia li te xaung bagula asabu mana Yerusalem xauna te. ");
INSERT INTO met_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ang Samariadi asabu mana Urana ne axabia ina te. Ne am Yudadi am gasabu mana Urana saing am gaxabiau, namua na Urana daxanganoa mana xap lipudi muli wa ranguam. ");
INSERT INTO met_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ning xaidaba mauba saing ma masup bungina lipu sabunga maxunamdi bagula disabu mana Tibura xaung Aningong haringinganoa xaung haruanga maxunama. Namua na Tibura muruna mana lipua na bila ba disabu mana. ");
INSERT INTO met_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Urana ina aningoningo, saing lipuxing sabungamdi bing disabu mana xaung Aningong haringinganoa xaung haruanga maxunama.” ");
INSERT INTO met_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Hainga harua na ba, “Ngaxabia Urana Lipuxing Mogunganama bagula ma. Ina lipua duxu ba Kristo. Baing bungina ma, bagula baxanga axamang longgalo nam.” ");
INSERT INTO met_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Baing ina naga, Yesu harua na ba, “Nga ba, lipua harua naung ba, nga naga.” ");
INSERT INTO met_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hata sibuna li lipuxindi dinaxu mana digoxoya ma, saing dihixi mana, namua na dibagu harua rangua haing tela. Ne dingia tela xusunga te ba, “Ubo mana baraxinta?” kimbo “Baruta uhangixaya rangua?” ");
INSERT INTO met_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Baing hainga yunga nanggolanoa la ba, saing goxoya mala ganangia saing harua na lipudi ba, ");
INSERT INTO met_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ama to, abagu lipu tela bala nga axamang longgalo ngalibudi ba. Bola lipua ba Urana Lipuxing Mogunganama?” ");
INSERT INTO met_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Baing ina naga, diyunga gananga disok saing dahaxa mala rangua Yesu. ");
INSERT INTO met_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Dahaxa malauyu, baing lipuxindi dinaxu mana dibala haringina ba, “Lipu Tubatubaingam, oxong to.” ");
INSERT INTO met_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ne harua nadi ba, “Nga angiagua ang gaxabiadi te.” ");
INSERT INTO met_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Baing lipuxindi dinaxu mana daharua nading ba, “Bola lipu tela xap anginga ma ulia?” ");
INSERT INTO met_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu harua nadi ba, “Angiagua bing ngasu mana lipua soxi nga ma ba murunganoa, xaung bing ngasahi oxatanoa. ");
INSERT INTO met_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ang gaxabia haruanga li: ‘Sobak luwadi luwadi disup to, baing bunging xauyangam.’ Ne ngabalang ba, axaxa maxaimdi abagu umangadi! Lipuadi dima lo, ding bila anginga dimoya masup ba lipudi daxauya. ");
INSERT INTO met_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Hatata lipu xauyangama xap giminaginoa. Xauya anginga mana walinga subingang teguama, bu sanga ba lipu marang tinginganama gabu lipu xauyangam tang diyaha xauna. ");
INSERT INTO met_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Binabu haruanga li lipudi daharua mana ba maxuna: ‘Tela ting marandi saing tela xauya.’ ");
INSERT INTO met_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ngasoxiang mala bu axauya axadi atuxu oxatua manadi te. Teladi dimakasa mana oxatua masup, saing ang ba axauya axamang xaidi mana oxatadingdi.” ");
INSERT INTO met_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria xumana mana longga baguba dahatum haringina mana Yesu, namua na haingga ba baxanga ba, “Bala nga axamang longgalo ngalibudi ba.” ");
INSERT INTO met_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Binabu bungina Samariadi disok mana, duxusunga haringina ba wa ranguadi, saing wa xaidap luwa. ");
INSERT INTO met_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Baing xumana muli dahatum haringina mana namua na dilungu haruanganoa. ");
INSERT INTO met_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Daharua na haingga ba, “Am gahatum haringina mana hatata, ne mana namua haruangama ing ganina te. Hatata am sibumam am galungu, saing am gaxabia maxung sibuna lipua li lipua Urana mogu ba xap lipu titiamdi muli.” ");
INSERT INTO met_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Xaidap luwa disup baing Yesu yunga longga ba saing ila titia Galili. ");
INSERT INTO met_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Muga Yesu ing sibuna baxanga haruanga maina ba, “Urana lipuxing suxunguxunguama xap yaya sabanga mana ing sibung yabania te.”) ");
INSERT INTO met_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Bungina sok titia Galili, Galilidi daxap xai. Namua na dibagu masup axamang longgalo libudi long sabangga Yerusalem bungina Taunga Dalingam, namua na ding dila taungia xauna. ");
INSERT INTO met_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Binabu goxoya mala muli mana longga Kena mana titia Galili, longga muga xugia langa bu sok wain ba. Ne mana long sabangga Kaperneam xaitamoxi lipuxing tela wa, garanoa busi. ");
INSERT INTO met_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bungina lipua ba lungu ba Yesu yunga titia Yudia ma Galili, ila rangua saing xusunga haringina ba ri ma hamaringia garanoa, namua na haxek sibuna bo ba matiuba. ");
INSERT INTO met_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Binabu Yesu harua na ba, “Nabu abagu axamang haringing xuman te, bing bagula ahatum haringina te.” ");
INSERT INTO met_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ne yanama harua na ba, “Lipu sabanga, uri ma sap! Nam garagua mati.” ");
INSERT INTO met_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu haxuya ba, “Ugoxoya mala. Garama bagula wau.” Lipua hatum haringina mana Yesu haruanganoa saing ila. ");
INSERT INTO met_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ri malauyu, baing lipuxing oxata olanggamdi disok mana, dibala ba garanoa sok xai. ");
INSERT INTO met_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Bungina xusungadi ba xaidap maxanoa baru garanoa sok xai, daharua na ba, “Sanggang salianoa sup nulau 1:00 xaidap.” ");
INSERT INTO met_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Baing ina naga, tibuna hatum muli ba bungina baguba xaidap maxanoa naga Yesu harua na mana ba, “Garama bagula sok xai.” Binabu gabu lipuxing numanamdi dahatum haringina. ");
INSERT INTO met_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Baing alaba axamang haringing luwa Yesu libu Galili, kimuya mana yunga titia Yudia. ");
INSERT INTO met_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kimuya baing Yesu haing mala Yerusalem bungina Yudadi dituxu taunga tela. ");
INSERT INTO met_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Baing mana Yerusalem, haxek mana Gamgaminga Xaluxing Sipsipkam, lang gamolingang tela wa, duxu Aram xuania ba Betesda. Xahi luwadi luwadi hiliadinga duwa rubinia. ");
INSERT INTO met_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Baing mana xahiadi ba, lipu busingam xumana dikinuʼm tabu—lipu maxa haxatiandi, lipu kidingdi didoa xaung lipu rimading kiding dahamati. ");
INSERT INTO met_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tela wa la ba, king rimandi dahamati niani 38. ");
INSERT INTO met_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu bagu kinuʼm tabu la ba saing lungu ba businganoa xap bunging maxaxaya, baing xusunga ba, “Ubo ba usok xai?” ");
INSERT INTO met_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Lipu busingama haxuya na ba, “Lipu sabanga, ngaxola mana lipu tela hauli nga ba ngari langia bungina bokboga. Bungina ngatuba ba ngari maluxu, lipu teladi diri langia muga manga.” ");
INSERT INTO met_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Baing Yesu harua na ba, “Umesa! Oxop uxaingama saing uhaxa.” ");
INSERT INTO met_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hata sibuna li lipua sok xai dup, xap uxainganoa saing haxa. Alaba sok mana Xaidap Yaguangama, ");
INSERT INTO met_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","binabu Yudadi yanamidingdi daharua na lipua sok xai ba, “Hatata Xaidap Yaguangama! Hanaunaungua bili mana oxoxi uxaingama.” ");
INSERT INTO met_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ne haxuya nadi ba, “Lipua hamaringia nga ba harua nanga ba, ‘Oxop uxaingama saing uhaxa.’ ” ");
INSERT INTO met_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Binabu duxusunga ba, “Lipua balaung ba oxop uxaingama saing uhaxa ba gaxarea?” ");
INSERT INTO met_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ne Yesu luxu mana burangua wa la ba saing bagu te, bala mana yanoa te, binabu lipua ba xabia te. ");
INSERT INTO met_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mena baing Yesu bagu lipua ba Urana Numang yabania, saing harua na ba, “Ubagu, usok xai muli baing. Usauya kubolua ulibu kubolu diandi ba, nam bunging diang sibuna xapkung.” ");
INSERT INTO met_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Lipua ila saing bala Yudadi yanamidingdi ba, “Lipua hamaringia nga bing Yesu.” ");
INSERT INTO met_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Binabu Yudadi yanamidingdi dungguti disina salaga na Yesu, namua na libu axadi ba mana Xaidap Yaguangama. ");
INSERT INTO met_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ne Yesu haxuya nadi ba, “Tibugu bungingbunginalo tuxu oxatanoa ma ma laing hatata, saing nga xauna ngatuxu oxatua.” ");
INSERT INTO met_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Namua naga Yudadi dahaxi sibuna mana disai daxanga ba dung mati. Namua na dali hanaunaungadingdi mana Xaidap Yaguangama ing ganina te. Tegu. Xauna harua ba Urana ina Tibuna naga, saing mana haruanga ba libu ina hasusu rangua Urana. ");
INSERT INTO met_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu haxuya haruangadinga bila li: “Maxung sibuna ngabalang ba, Urana Garanoa sanga ba libu axamang tela mana ing sibung murunganoa te. Ne axamang baruamta bagu Tibuna libu, ina libu ing ganina, namua na baraxinta Tibuna libu, bing Garanoa libu xauna. ");
INSERT INTO met_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Namua na Tibuna murung sibuna mana Garanoa saing hatanga axadi libudi na. Baing bagula hatanga na oxata haringing teladi bo ba Garanoa libudi. Baing ina naga, oxatadi ba bagula didali axadi abagudi li, bu ahixi manadi. ");
INSERT INTO met_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Namua na Tibuna iti matiadi mesa saing sina walinga nadi, baing bila balau Garanoa sina walinga na lipu gaxarea muruna manadi. ");
INSERT INTO met_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Xauna, Tibuna suxuya lipu tela te. Ning ta oxata suxuyangam longgalo Garanoa rimania. ");
INSERT INTO met_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Libu bila ba bu lipu longgalo disina yaya na Garanoa bila disina yaya na Tibuna. Lipu gaxarea disina yaya na Garanoa te, lipuadi ba disina yaya na Tibuna soxi ma ba te. ");
INSERT INTO met_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Maxung sibuna ngabalang ba, lipu gaxarea dilungu haruangagua saing dahatum haringina mana ina soxi nga ma, ding daxap walinga subingang teguama, saing bagula daxap salaga mana kuboludingdi te. Ne diyunga matiyua, saing dikisi mala walingia. ");
INSERT INTO met_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Maxung sibuna ngabalang ba, xaidaba mauba saing ma ba, bungina matiadi bagula dilungu Urana Garanoa waxungtuanoa, saing lipu gaxarea dilungu bagula duwa. ");
INSERT INTO met_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Namua na daxanga walingama wa Tibuna rimania, saing bila balau ta daxanga walingama Garanoa rimania xauna. ");
INSERT INTO met_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Baing Tibuna sina yaya na bu suxuya lipudi namua na ina Lipua Ma Rangua Urana. ");
INSERT INTO met_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Labu ahixi mana haruangagua liu tai, namua na xaidaba ma yu bungina lipu longgalo duwa gobagobadingia bagula dilungu Lipua Ma Rangua Urana waxungtuanoa, ");
INSERT INTO met_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","saing disok sanguadi. Lipu gaxarea dilibu kubolu xaidi bagula dimesa muli bu daxap walinga subingang teguama. Ne lipu gaxarea dilibu kubolu diandi bagula dimesa muli bu daxap suxuyanga salakkama.” ");
INSERT INTO met_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yesu haruauyu, harua ba, “Mana nga murungagua sanga ba ngalibu axamang tela te. Ne ngasuxuya lipudi bila Tibugu bala nga ing ganina. Saing suxuyangagua maring, namua na ngasai daxanga mana ngalibu murungagua te, ngasai daxanga mana ngalibu ina soxi nga ma ba murunganoa. ");
INSERT INTO met_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nabu nga ganigu ngabaxanga nga, bing sanga ba lipudi daharua ba haruangagua maxun te. ");
INSERT INTO met_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ne tela wa, baxanga nga. Tibugu baing. Saing ngaxabia haruanganoa manga bing maxuna. ");
INSERT INTO met_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Ang ba asoxi ulekdi mala rangua Lipu Suguangama Yon saing baxanga haruanga maxunama. ");
INSERT INTO met_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ne baxangangua haringia ngayua ma rangua lipudi te. Ning ngaharua mana Yon baxanganganoa bu ahatum haringina saing Urana bagula xapkang muli. ");
INSERT INTO met_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yon bila nagung tela lu binabu sina lulianoa nang, saing ang gayaha mana lulianoa mongaita. ");
INSERT INTO met_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ne baxanganga hatanga nga masok tela wa, dali Yon haruanganoa baxanga nga. Oxatagua baing. Namua na oxatua Tibugu sina nanga bu ngasahi ba, oxata ba baxanga ba Tibugu soxi nga ma. ");
INSERT INTO met_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Baing Tibugu, ina soxi nga ma, ina naga baxanga nga. Waxungtuanoa alungu bunging tela te, saing babunoa abagu bunging tela te, ");
INSERT INTO met_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","saing haruanganoa wa maluxu mang te, namua na ahatum haringina mana lipua soxi ma ba te. ");
INSERT INTO met_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Awaxata haringina ba axap xabianga mana Xuanoa, namua na ahagaxa ba nabu atubatuba manadi bing bagula axap walinga subingang teguama. Xuana naga baxanga nga ba, ");
INSERT INTO met_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ning hauxaim ba ama rangua nga bu axap walinga ba. ");
INSERT INTO met_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Yaya sabanga lipudi dibo ba disina nanga, ngahatumia te, ");
INSERT INTO met_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ne ngaxabianggu. Ngaxabia ba maluxu mang, ang muruim mana Urana te. ");
INSERT INTO met_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ngama Tibugu yania, saing ang gaxap nga te. Ning nabu lipu tela ma ing sibung yania, bing bagula axap. ");
INSERT INTO met_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ang muruim mana axap yaya ranguang, ning muruim mana axap yaya rangua Urana taininau te. Binabu sanga ba ahatum haringina baru? ");
INSERT INTO met_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Bola ahatum ba bagula ngatang haruangia Tibugu maxania? Tegu. Lipua tang haruangia bing Moses, lipua ata ragunga mana, ahagaxa ba hauliang. ");
INSERT INTO met_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nabu maxuna ahatum haringina mana Moses, bing sanga ba ahatum haringina manga xauna, namua na bung haruangua manga. ");
INSERT INTO met_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ning nabu ahatum haringin te mana haruanganoa bung, bing bagula ahatum haringina mana haruangagua baru?” ");
INSERT INTO met_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kimuya, Yesu kisi mala Lang Gamolingania Galili hataina. (Lang gamolingana ba yan tela Taibirias.) ");
INSERT INTO met_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Baing buranga sabanga disu mana, namua na dibagu axamang haringindi libudi bungina hamaringia lipu busingamdi. ");
INSERT INTO met_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Baing Yesu haing mala mana xaxagang tela saing rung mari rangua lipuxindi dinaxu mana. ");
INSERT INTO met_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Baing Yudadi Taungading Dalingama ma haxekkuba. ");
INSERT INTO met_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Bungina Yesu bagu mahaing saing bagu buranga sabanga dima rangua, harua na Pilip ba, “Bagula tagim salanga bi bu lipuadi li daxang?” ");
INSERT INTO met_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Xusunga bila ba bu tuba ing ganina, namua na xabia masup baraxinta bagula libu. ");
INSERT INTO met_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilip haxuya na ba, “Lipu tela waxata sobak 8 giminaginoa sanga ba gim salanga sanga mana taining tainina daxang monga monga te!” ");
INSERT INTO met_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Lipuxindi dinaxu mana tela, yanoa Andru, Saimon Pita kixinginoa, harua ba, ");
INSERT INTO met_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Bagu gananung tela li. Songing luwa xaung salanga luwadi luwadi hiliadinga ditongtongia mana bali. Ning anginga kaxukana bila li sanga mana buranga li baru?” ");
INSERT INTO met_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu harua ba, “Abala lipudi ba dirung mari.” Tatubang xumana duwa la ba, saing dirung mari. Lupdi ding ganiding bila 5,000. ");
INSERT INTO met_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Baing Yesu xap salangadi, harua xai sibuna mala rangua Urana, saing tuxu sinak mana lipuadi dirung ba, saing daxang sanga ba. Libu taininau mana songdi xauna. ");
INSERT INTO met_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ding longgalo daxang sanga ba, baing harua na lipuxindi dinaxu mana ba, “Agugunia anginga hataindi duwauyu, nam teladi didoa olang.” ");
INSERT INTO met_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Binabu diguguniadi saing digam daba 12 dibaxagi mana anginga hataindi duwauyu mana salanga luwadi luwadi hiliadinga lipuadi daxang ba. ");
INSERT INTO met_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Lipudi dibagu axamang haringina ba Yesu libu, baing dungguti daharua ba, “Maxung sibuna lipua li Urana Lipuxing Suxunguxunguama mogu ba ma titia.” ");
INSERT INTO met_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ne Yesu xabia ba dibo ba dituxu dimogu xaitamoxidinga, binabu yungadi muli saing haing mala xaxagania bu ing ganina wa. ");
INSERT INTO met_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Bungbung sibuna baing lipuxindi dinaxu mana diri mala lang gamolingania. ");
INSERT INTO met_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Baing dahaing wagia bu dikisi mala long sabangga Kaperneam, wa lang gamolingang hataina. Labianoa sok, ne Yesu ma ranguadi teguyu. ");
INSERT INTO met_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yang haringina yubua saing rubadi dahaung. ");
INSERT INTO met_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Dui mala bila kilomita luwadi luwadi hiliadinga, baing dibagu Yesu sok haxek wagia, haxa tek ubunia, baing dimaxuwa buk. ");
INSERT INTO met_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ne harua nadi ba, “Nga naga. Labu amaxuwau tai.” ");
INSERT INTO met_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Baing ina naga, diyaha ba daxap mahaing wagia. Baing hata sibuna li wagua sok tek rubinia dila mana ba. ");
INSERT INTO met_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Buragina baing buranga duwa lang gamolingang hataina ba dibagu daxabia xai wagang tela wa te. Nulau taininau ing ganina wa—wagua lipuxindi dinaxu mana dahaing dila mana ba. Daxabia Yesu ila ranguadi te, ne ding ganiding dila. ");
INSERT INTO met_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Baing Taibirias wagading teladi diri haxek mana longga lipudi daxang salangua kimuya mana Toxoratamona harua xai sibuna mala rangua Urana. ");
INSERT INTO met_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Buranga dibagu daxabia Yesu wa te xaung lipuxindi dinaxu mana xauna duwa te, binabu dahaing mana xai waganadi ba saing dila long sabangga Kaperneam bu disai mana Yesu. ");
INSERT INTO met_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bungina disok mana Yesu lang gamolingang hataina, duxusunga ba, “Lipu Tubatubaingam, bungintabi uma la li?” ");
INSERT INTO met_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu haxuya nadi ba, “Maxung sibuna ngabalang ba, ang gaxang salangadi sanga ba, saing mana namua naga asai manga. Ne mana axamang haringindi ngalibudi, tegu. ");
INSERT INTO met_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Labu awaxata mana axap anginga dibuyau tai. Tegu. Bing awaxata mana axap anginga wa bungingbunginalo, anginga mana walinga subingang teguama. Lipua Ma Rangua Urana bagula sina nang. Namua na Tibuna sina yaya sabanga na bu libu bila ba.” ");
INSERT INTO met_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Baing duxusunga ba, “Bagula am garia baru bu am gatuxu oxatadi Urana muruna manadi?” ");
INSERT INTO met_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu haxuya nadi ba, “Urana oxatanoa bila li: Bing ahatum haringina mana lipua soxi ma ba.” ");
INSERT INTO met_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Binabu duxusunga ba, “Axamang haringing baruamta bagula ung ba ulibu bu am gabagu, binabu am gahatum haringina maung? Bagula uria baru? ");
INSERT INTO met_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mugangaradi daxang anginga duxu ba ‘manna’ long xoliania, bila dibung Urana Xuania ba, ‘Sina salanga ma long xaiya nadi bu daxang.’ ” ");
INSERT INTO met_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Baing Yesu harua nadi ba, “Maxung sibuna ngabalang ba, lipua sina salanga ma long xaiya nang bing Moses tate. Ne Tibugu sina salanga maxunama ma long xaiya nang. ");
INSERT INTO met_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Namua na salangua Urana sina, ina lipua ri long xaiya ma saing sina walinga na lipu titiamdi.” ");
INSERT INTO met_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Baing daharua na ba, “Lipu Sabanga, usina salanga ba nam bungingbunginalo!” ");
INSERT INTO met_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Baing Yesu baxanga nadi ba, “Nga ba salanga walingam. Lipu gaxarea ma rangua nga bagula gesagina te, saing lipu gaxarea hatum haringina manga bagula langa ung te. ");
INSERT INTO met_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ning ngabalang masup ba, abagu nga ne ahatum haringina te. ");
INSERT INTO met_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Lipuadi Tibugu sinadi nanga, bagula dima rangua nga, saing lipu gaxarea ma rangua nga, bagula ngasuka te. ");
INSERT INTO met_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Namua na ngari long xaiya ma bu ngasu mana nga murungagua te. Ne ngama bu ngasu mana ina soxi nga ma ba ing murunganoa. ");
INSERT INTO met_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Baing ina soxi nga ma, ing murunganoa bing: Lipu longgalo sinadi nanga, bagula ngayunga tela hanggalang te. Ne bagula ngaitidi mesa muli xaidap subingania. ");
INSERT INTO met_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Namua na Tibugu murunganoa bing lipu longgalo dibagu Garanoa xaung dahatum haringina mana bagula daxap walinga subingang teguama, saing bagula ngaitidi mesa muli xaidap subingania.” ");
INSERT INTO met_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Baing ina naga, Yudadi dungguti daharungia namua na harua ba, “Nga salanga ri long xaiya ma.” ");
INSERT INTO met_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Daharua ba, “Lipua li Yesu, Yosep garanoa naga? Baungtibundi, am gaxabia dingtanggu. Binabu hatata harua ba ina ri long xaiya ma baru?” ");
INSERT INTO met_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Baing Yesu haxuya nadi ba, “Labu aharungia nga liwe manggu tai. ");
INSERT INTO met_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Lipu tela sanga ba ma rangua nga mana ing murunganoa te. Tegu. Tibugu soxi nga ma, xai hatuminganoa to bu ma rangua nga, saing bagula ngaiti mesa muli xaidap subingania. ");
INSERT INTO met_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Urana lipuxing suxunguxunguama Aisaya bung ba: ‘Bagula ding longgalo daxap tubatubaingua rangua Urana.’ Lipuadi dilungu Tibugu haruanganoa xaung daxap tubatubainganoa, ding dima rangua nga. ");
INSERT INTO met_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Lipu tela bagu Tibugu te. Ina ma rangua Urana ing ganina bagu Tibugu. ");
INSERT INTO met_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Maxung sibuna ngabalang ba, lipu gaxarea hatum haringina, ina xap walinga subingang teguama. ");
INSERT INTO met_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nga salanga walingama. ");
INSERT INTO met_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Heku mugangaimdi daxang anginga duxu ba manna long xoliania. Ding dimati ba. ");
INSERT INTO met_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ning salanga baguli ri long xaiya ma, bu lipu gaxarea daxang sanga ba dimati te. ");
INSERT INTO met_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nga ba salanga walingam ri long xaiya ma. Lipu gaxarea xang salanga li, bing bagula wa bungingbunginalo. Baing salanga li bagula ngasina bu lipu titiamdi daxap walingua, bing mututungagua.” ");
INSERT INTO met_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Baing Yudadi dungguti dahakhaxi haringina liwe mading ba, “Lipua li sanga sina mututunganoa nam bu am gaxang baru?” ");
INSERT INTO met_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Binabu Yesu harua nadi ba, “Maxung sibuna ngabalang ba, nabu axang Lipua Ma Rangua Urana mututunganoa te xaung anung sibinoa te, bing walingua sanga ba wa maluxu mang te. ");
INSERT INTO met_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Lipu gaxarea daxang mututungagua xaung dinung sibigua bing daxap walinga subingang teguama, saing bagula ngaitidi mesa xaidap subingania. ");
INSERT INTO met_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Namua na mututungagua anginga maxunam xaung sibigua nunginga maxunam. ");
INSERT INTO met_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Lipu gaxarea daxang mututungagua xaung dinung sibigua, ditaga rangua nga, xaung ngataga ranguadi xauna. ");
INSERT INTO met_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tibugu wa bungingbunginalo, ina soxi nga ma. Binabu mana ing haringinganoa ngawa bungingbunginalo. Binabu lipu gaxarea daxang mututungagua bagula duwa namua na ngaharingiadi bila ba. ");
INSERT INTO met_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Alali salangua ri long xaiya ma. Mugangaimdi daxang anginga duxu ba manna, saing dimati. Ning lipu gaxarea daxang salanga li bagula duwa bungingbunginalo.” ");
INSERT INTO met_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Baxanga haruanganoa ba bungina tubatuba lipudi Yudadi sabungading numania Kaperneam. ");
INSERT INTO met_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Lipuxindi dinaxu mana dilungu haruangana ba, baing xumana daharua ba, “Tubatubaikka li haxi baru! Gaxarea sanga ba xap?” ");
INSERT INTO met_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ne Yesu xabia hatumingania lipuxindi dinaxu mana daharungia bila ba. Binabu xusungadi ba, “Baruta? Haruanga li hanggalangia hatumingaimdi? ");
INSERT INTO met_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Baing nabu abagu Lipua Ma Rangua Urana haing mala longga wa muga, bing baruta? ");
INSERT INTO met_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Urana Aningonoa ba sina walingua. Sangga sanga ba hauliang monga te. Haruanga nga ngabaxanga nang ba ma rangua Urana Aningonoa saing sina walingua. ");
INSERT INTO met_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ning angia teladi ahatum haringin te.” (Yesu harua bila ba namua na lipu gaxarea dahatum haringina mana te, ina xabiadi muga. Xabia lipu gaxarea bagula ta bixuandi rimadingia xauna.) ");
INSERT INTO met_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Haruauyu, harua ba, “Namua naga ngabalang ba lipu tela sanga ba ma rangua nga mana ing murunganoa te. Tibugu xai hatuminganoa to bu ma rangua nga.” ");
INSERT INTO met_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Baing mana xaidapka baguba saing ila, lipuxindi xumana dinaxu mana diyamu saing diyunga. Dinaxu mana muli te. ");
INSERT INTO met_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Binabu Yesu xusunga Lipu 12 ba, “Baruta? Ang xauna abo ba ayunga nga?” ");
INSERT INTO met_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Baing Saimon Pita haxuya na ba, “Toxoratamona, bagula am gala rangua gaxarea? Ung ganim haruangama mana walinga subingang teguama. ");
INSERT INTO met_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Am gahatum haringina xaung am gaxabia ba ung Urana Lipuxina Mogu Naina.” ");
INSERT INTO met_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Baing Yesu haxuya nadi ba, “Maxuna ngamoguang Lipu 12, bo? Ning angia tela, ina bila xaungadi yanamidinga!” ");
INSERT INTO met_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Harua mana Yudas, Saimon Iskariot garanoa, ina Lipu 12 tela, ne kimuya ta bixuandi rimadingia.) ");
INSERT INTO met_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kimuya, Yesu haxa mauli titia Galili. Bo ba haxa mauli maluxuʼm titia Yudia te, namua na Yudadi yanamidingdi disai daxanga ba dung mati. ");
INSERT INTO met_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ne, bungina Yudadi Taungading Xahiamdi ma haxek, ");
INSERT INTO met_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesu kixingindi daharua na ba, “Usauya titia baguli saing ula titia Yudia, bu lipuximdi dinaxu maung dibagu axamang haringindi ulibudi. ");
INSERT INTO met_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Namua na nabu lipu tela bo ba ramramo sabanga, bing bagula tuxu oxatanoa hisangia te. Nabu ulibu oxatadi li, xai mana uhatangaung na lipu titiam longgalo.” ");
INSERT INTO met_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kixingindi daharua bila ba namua na ding xauna dahatum haringina mana te. ");
INSERT INTO met_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Binabu Yesu baladi ba, “Xaidabigua ma teguyu. Ne xaidap longgalo daxai mang. ");
INSERT INTO met_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Lipu titiamdi sanga ba hauxading sibuna mang te, ning hauxading sibuna manga namua na nga ngabaxanga ba kuboludingdi didoa. ");
INSERT INTO met_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ang ba ahaing mala Taungia. Ne hatata nga ba bagula ngahaing mala mana Taunga baguba te, namua na xaidabigu sibunoa ma teguyu.” ");
INSERT INTO met_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Harua bila ba laing sup, baing wa Galiliyu. ");
INSERT INTO met_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ning, kimuya mana kixingindi dahaing mala Taungia masup, haing mala xauna, ne ila sabasabia te, ila hisangia. ");
INSERT INTO met_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tauna, mana Taunga Yudadi yanamidingdi disai mana saing duxusunga ba, “Lipua ba kabila?” ");
INSERT INTO met_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Baing buranga daharungia ila ma liwe mading. Tela dahakhaxi ba, “Lipu xai.” Ne teladi daharua ba, “Tegu, tuxu murak mana lipudi.” ");
INSERT INTO met_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ne lipu tela harua sabasabia mana te, namua na dimaxuwa mana Yudadi yanamidingdi. ");
INSERT INTO met_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Taunga xaidabindi dila lia, baing Yesu haing mala Urana Numang yabania saing ungguti ba tubatuba lipudi. ");
INSERT INTO met_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yudadi dihixi mana haruanganoa. Daharua ba, “Lipua ba ila numa tubatubaikkamia te, ning xap xabiangua bi?” ");
INSERT INTO met_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Binabu Yesu haxuya nadi ba, “Tubatubaingagua ngayua te. Ma rangua ina soxi nga ma. ");
INSERT INTO met_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Lipu gaxarea dahamaringia hatumingadingdi ba disu mana Urana murunganoa, bagula daxabia xai mana tubatubaikka li ma rangua gaxarea. Bagula daxabia ba ma rangua Urana kimbo ngaharua mana nga sibugu hatumingagua ing ganina. ");
INSERT INTO met_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Lipu gaxarea harua mana ing sibung hatuminganoa ing ganina, bo ba xap yaya naina. Ne lipu gaxarea waxata bu sina yaya na ina soxi ma, lipua ba lipu haruanga maxunama, xola mana languangua. ");
INSERT INTO met_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses sina hanaunaungua nang, bo? Ning angia tela su mana te. Baruta atuba ba aung nga mati?” ");
INSERT INTO met_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Buranga dahaxuya ba, “Xaunga wa maung! Gaxarea bo ba unggung mati?” ");
INSERT INTO met_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu harua nadi ba, “Ngalibu axamang haringing taininau mana Xaidap Yaguangama, saing ang longgalo ahixi mana. ");
INSERT INTO met_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ne ang gawaxata mana Xaidap Yaguangama xauna, bungina asu mana Moses hanaunaunganoa mana axuxu sangga. (Ne Moses ungguti kubolua taxuxu lipudi sanggadingdi te, kubolua ba ma rangua mugangaradi muga mana Moses.) ");
INSERT INTO met_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Baing ina naga, abo ba adali Moses hanaunaunganoa te, binabu axuxu garadi sanggadingdi mana Xaidap Yaguangama. Bila balau, bing baruta agamia nga mana kubolugua ngahamaringia lipu tela sanggang longgalo mana Xaidap Yaguangama? ");
INSERT INTO met_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Labu asuxuya kuboludi olang maxaimiau tai. Bing asuxuya kuboludi mana suxuyanga maringina.” ");
INSERT INTO met_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tauna, Yerusalem teladi dungguti duxusunga ding ba, “Lipua ba lipua yanamiradi dibo ba dung mati naga? ");
INSERT INTO met_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Baing bagu hatata wa, tubatuba sabasabia lo, saing duxukxugia te! Bola yanamiradi daxabia ba maxung sibuna ina Urana Lipuxing Mogunganama? ");
INSERT INTO met_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ning am gaxabia lipua li yabanoa. Ne bungina Urana Lipuxing Mogunganama ma, lipu tela bagula xabia yabanoa te.” ");
INSERT INTO met_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu tubatuba Urana Numang yabaniauyu, baing harua sabanga ba, “Ang gaxabia nga, saing ang gaxabia yabaguau? Ne ngama la li mana nga murungagua te. Ina soxi nga ma, ina lipu haruanga maxunama. Saing ang gaxabia ina te. ");
INSERT INTO met_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nga ba ngaxabia ina, namua na ngama rangua, saing soxi nga ma.” ");
INSERT INTO met_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Baing ina naga disai daxanga ba dituxu, ne rimading tela haing mana te, namua na xaidabinoa ma teguyu. ");
INSERT INTO met_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ne lipu xumana mana burangua dahatum haringina mana. Daharua ba, “Bungina Urana Lipuxing Mogunganama ma, axamang haringindi libudi sanga ba didali axamang haringindi lipua li libudi te!” ");
INSERT INTO met_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parisidi dilungulungu buranga dahabolabola haruanga bila ba liwe mading. Binabu lipu hananiangamdi yanamidingdi digabu Parisidi disoxi lipu Urana Numang wasanganamdi mala bu dituxu Yesu. ");
INSERT INTO met_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Baing Yesu harua ba, “Ngawa ranguang bunging gamoita, saking bagula ngala rangua ina soxi nga ma. ");
INSERT INTO met_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Bagula asai manga, ne bagula asok manga te. Saing longga nga ngawa mana, sanga ba ang gala mana te.” ");
INSERT INTO met_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Baing Yudadi yanamidingdi daharua nading ba, “Bagula lipua ba ila bi bu sanga ba tasok mana te? Bagula ila rangua bakbagira duwa hataing hataina rangua Grikdi titi telamdi bu tubatuba Grikdi? ");
INSERT INTO met_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Haruangang namuxina baru? Namua na harua ba, ‘Bagula asai manga, ne bagula asok manga te.’ Baing xauna harua ba, ‘Longga nga ngawa mana, sanga ba ang gala mana te.’ ” ");
INSERT INTO met_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Taunga xaidabing kimuama ma, xaidabing sabangua baing, saking Yesu mesa saing harua sabanga ba, “Lipu gaxarea langa ung, bing sanga ba ma rangua nga bu nung. ");
INSERT INTO met_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Lipu gaxarea hatum haringina manga, Urana Xuang haruanganoa bagula aningona, saing lang walingama bagula luki sangua lunoa.” ");
INSERT INTO met_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Bungina harua bila ba, harua mana Urana Aningonoa lipudi dahatum haringina mana ba bagula daxap kimuya. Mana xaidapka ba Urana Aningonoa ma teguyu, namua na Yesu xap ralanoa teguyu. ");
INSERT INTO met_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Buranga dilungu haruanga li, baing teladi daharua ba, “Maxung sibuna lipua li Urana Lipuxing Suxunguxunguama tata ragunga mana baing.” ");
INSERT INTO met_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Teladi daharua ba, “Ina Urana Lipuxing Mogunganama.” Baing teladi duxusunga ba, “Urana Lipuxing Mogunganama sanga ba sok ma sangua Galili baru? ");
INSERT INTO met_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Urana Xuanoa harua ba Lipuxing Mogunganama bagula sok maluxuʼm Xaitamoxi Debit bakbaginoa, mana longga Betlehem, Debit yabania.” ");
INSERT INTO met_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Binabu lipudi dahata ding mana Yesu gaxarea. ");
INSERT INTO met_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Teladi dibo ba dituxu, ning tela ta rimang tela mana te. ");
INSERT INTO met_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sup, baing lipu Urana Numang wasanganamdi digoxoya mala rangua lipu hananiangamdi yanamidingdi xaung Parisidi. Yanamidingdi duxusungadi ba, “Baruta atuxu axap ma te?” ");
INSERT INTO met_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Lipu wasangamdi dahaxuya ba, “Waleu ma lipu tela harua bila lipua ba te!” ");
INSERT INTO met_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parisidi dibaladi ba, “Baruta? Tuxu murak mang xauna? ");
INSERT INTO met_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Lipu yanamiding tela kimbo Parisi tela hatum haringina mana? Tegu! ");
INSERT INTO met_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ning buranga li dahasuxi mana hanaunaungua. Urana bagula hanggalangiadi.” ");
INSERT INTO met_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ne Nikodimas, dingia tela muga ila rangua Yesu ba, xusunga ba, ");
INSERT INTO met_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Hanaunaungaroa harua xai mana lipu tela xap salaga nabu talungu muga te bu taxabia kubolunoa? Tegu. Talungu to.” ");
INSERT INTO met_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Dahaxuya ba, “Bola ung ba yabama titia Galili xauna? Usai haruanga Urana Xuania to, baing bagula ubagu uxabia Urana lipuxing suxunguxunguam tela mesa sangua Galili te.” ");
INSERT INTO met_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Baing taining tainina dila ding numadingia. ");
INSERT INTO met_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ne Yesu ila Xaxagana Olip. ");
INSERT INTO met_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Buraraging sibuna Yesu ila Urana Numang yabania muli. Lipudi dima digugunia taxiya, saing rung mari saing tubatubadi. ");
INSERT INTO met_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Lipu hanaunaunga tubatubainganamdi digabu Parisidi dituxu haing tela bungina kinu mua rangua lipu tela, ina ayuanoa te, daxap ma. Dita mali buranga maxadingia ");
INSERT INTO met_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","saing daharua na Yesu ba, “Lipu Tubatubaingam, am gatuxu haingga li bungina kinu rangua lipu tela ayuanoa te. ");
INSERT INTO met_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Baing mana Moses hanaunaunganoa, harua ba taxatu hainggadi na bila ba siangia mati. Ne ung ba uharua baru?” ");
INSERT INTO met_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Daharua bila ba bu dituba, bu daxap namua bu disu haruanga na. Ne Yesu yuyu mari saing ungguti ba bung titia rimang uxunia. ");
INSERT INTO met_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Duxusunga xusunga mala, baing Yesu mesa li maringina saing harua nadi ba, “Nabu angia tela xola mana kubolu diana, bing sanga ba ting sianga muga mana.” ");
INSERT INTO met_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yesu yuyu mari muli saing bung titia. ");
INSERT INTO met_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ne bungina dilungu haruanganoa, dila taining tainina, muga lipu haringindi dila, gananundi dila kimu. Disup mala baing Yesu ing ganina wa rangua haingga ba li maxania. ");
INSERT INTO met_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu mesa li maringina saing xusunga ba, “Haing, lipuadi ba dila bi? Tela wauyu bu su haruanga naung te?” ");
INSERT INTO met_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Harua ba, “Lipu Sabanga, tela wa te.” Baing Yesu harua ba, “Nga xauna bagula ngasu haruanga naung te. Ula, saing hatata labu ulibu kubolu diana muliu tai.” ");
INSERT INTO met_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu harua na lipudi muli, harua ba, “Nga titi lulianoa. Lipu gaxarea naxu manga bagula haxa labiania te, ning bagula xap luliang walingam.” ");
INSERT INTO met_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Parisidi duxukxugia ba, “Ung sanga ba uhatanga ba haruangama maxuna te, namua na oxola mana lipu tela haringia haruangama. Haruanga ubaxangaung mana haruanga olang.” ");
INSERT INTO met_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu haxuya nadi ba, “Heku ngabaxanga nga, haruangagua maxuna, namua na ngaxabia longga ngama mana saing ngaxabia longga ngala mana. Ning ang gaxabia longga ngama mana kimbo longga ngala mana te. ");
INSERT INTO met_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ang ba asu mana lipu titiamdi kuboludinga bungina asuxuya. Ne ngasuxuya lipu tela te. ");
INSERT INTO met_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ning nabu ngasuxuya, bing kubolugu ngasuxuya mana bagula maring, namua na nga ganigu ngasuxuya te, ne ngagabu Tibugu soxi nga ma ba tam gasuxuya. ");
INSERT INTO met_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mana ang hanaunaungaima dibung ba nabu lipu luwa tang dibaxanga taininau, bing haruangadinga maxuna. ");
INSERT INTO met_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ngabaxanga nga. Saing lipu tela baxanga nga bing Tibugu soxi nga ma ba.” ");
INSERT INTO met_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Binabu duxusunga ba, “Tibum wa bi?” Yesu haxuya ba, “Ang gaxabia nga te, xaung Tibugu xauna te. Nabu axabia nga, bing bagula axabia Tibugu xauna.” ");
INSERT INTO met_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Harua haruanga ba bungina wa Urana Numang yabania, haxek mana longga dita siang hananiangama. Ning lipu tela tuxu te, namua na xaidabinoa ma teguyu. ");
INSERT INTO met_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu harua nadi muli ba, “Bagula nga ngasauyang, saing bagula asai manga, ne bagula amatia kuboluim diandi. Longga nga ngala mana, sanga ba ang gama mana te.” ");
INSERT INTO met_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Binabu Yudadi yanamidingdi duxusunga liwe mading ba, “Bagula ina ung ina mati? Bola namua harua ba, ‘Longga ngala mana, sanga ba ang gama mana te’?” ");
INSERT INTO met_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ne harua nadi ba, “Ang ba lipu hawamdi, nga ba lipu etaloama. Ang ba lipu titiamdi, ne nga ba lipu titiam tela te. ");
INSERT INTO met_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Namua naga ngabalang ba bagula amatia kuboluim diandi. Nabu ahatum haringina te ba nga ina, bing maxung sibuna bagula amatia kuboluim diandi.” ");
INSERT INTO met_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Duxusunga ba, “Ung gaxarea?” Yesu haxuya ba, “Nga lipua ngaharua mana waleu ma hatata naga. ");
INSERT INTO met_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nga haruangagu xumana sanga ba ngasuxuyang manadi. Ne ina soxi nga ma, ina lipu haruangang maxunam. Ngabala lipu titiamdi haruanga ngalungu rangua ing ganina.” ");
INSERT INTO met_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Daxabia ba harua nadi mana Tibuna te. ");
INSERT INTO met_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Binabu Yesu harua ba, “Bungina aiti Lipua Ma Rangua Urana mahaing, bagula axabia ba nga ina, xaung ngalibu axamandi mana murungagua te. Ne ngaharua bila Tibugu tubatuba nga ing ganina. ");
INSERT INTO met_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Lipua soxi nga ma ba, ina wa rangua nga, saing yunga nga ganigu ngawa te. Namua na bungingbunginalo ngalibu axadi dilibu yaha.” ");
INSERT INTO met_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Harua bila ba, baing bunging taininau lipu xumana dahatum haringina mana. ");
INSERT INTO met_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Baing Yesu harua na Yudadi dahatum haringina mana ba, “Nabu asu mana haruangagua, bing awa lipuxigu sibundi dinaxu manga. ");
INSERT INTO met_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Baing bagula axabia haruanga maxunama, saing haruanga maxunamga ba bagula lubang bu ayunga walinga oxata olanggama.” ");
INSERT INTO met_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Dahaxuya na ba, “Am Ebraham bakbagindi, saing am gawa lipu tela lipuxing oxata olanggamdi bunging tela te. Uharua ba bagula haruanga ba lubam bu am gayunga walinga oxata olanggama baru?” ");
INSERT INTO met_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu haxuya nadi ba, “Maxung sibuna ngabalang ba, lipu longgalo dilibu kubolu diandi, ding duwa kubolu diana lipuxing oxata olanggamdi. ");
INSERT INTO met_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Lipu oxata olanggamdi duwa maluxuʼm numa moxong bakbaginoa bungingbunginalo te. Ning numa moxong garanoa wa maluxuʼm bakbaginoa bungingbunginalo. ");
INSERT INTO met_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Baing ina naga, nabu Urana Garanoa lubang bu ayunga walinga oxata olanggama, bing maxung sibuna bagula agiti mala sangua axadi digoxiang. ");
INSERT INTO met_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ngaxabia ang Ebraham bakbagindi. Ning abo ba aung nga mati, namua na hauxaim mana asina ganangang tela maluxu mang ba axap haruangagua. ");
INSERT INTO met_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ngaharua nang mana axadi ngabagudi bungina ngawa rangua Tibugu, saing ang ba alibu axadi alungudi rangua tibuim.” ");
INSERT INTO met_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Dahaxuya na ba, “Ebraham tibumam.” Yesu harua nadi ba, “Nabu ang Ebraham garang sibundi, bing bagula alibu kuboluadi Ebraham libudi. ");
INSERT INTO met_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ning bila li: Ang gahaxi ba aung nga mati namua na ngaharua nang haruanga maxunama ngalungu rangua Urana. Ebraham libu bila ba te. ");
INSERT INTO met_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ang galibu kuboluadi tibuim libudi.” Baing dibala ba, “Am ba am gasok olang daxangia te! Am Tibumam taininau ing ganina—Urana!” ");
INSERT INTO met_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu harua nadi ba, “Nabu maxuna Urana Tibuim, bagula muruim sibuna manga, namua na ngama rangua Urana saing hatata ngawa la li. Ngama mana nga murungagua te, ning ina soxi nga ma. ");
INSERT INTO met_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Baruta haruangagua sok rangrang mang te? Namua bing hauxaim mana alungu tubatubaingagua. ");
INSERT INTO met_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ang ba tibuim xaungadi yanamidinga garandi. Baing abo ba alibu tibuim murunganoa. Mugamugau sibuna ma ina lipu ungingam, tuxu haruanga maxunam te, namua na haruanga maxunama wa maluxu mana te. Bungina langua, harua ina xuana, namua na ina lipu languangam xaung languanga tibuna. ");
INSERT INTO met_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ne ang gahatum haringina mana haruangagua te, namua na nga ngaharua haruanga maxunam! ");
INSERT INTO met_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sanga ba angia tela hatanga maringina ba nga lipu kubolu dianam? Tegu? Nabu haruangagua maxuna, baruta ahatum haringina mana te? ");
INSERT INTO met_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Lipu gaxarea Urana iniadi bing dilungu Urana haruanganoa. Namua alungu te bing ang Urana iniadi te.” ");
INSERT INTO met_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yudadi yanamidingdi dahaxuya na ba, “Am gaharua maringina ba ung Samaria tela xaung xaunga tela wa maung?” ");
INSERT INTO met_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Baing Yesu haxuya ba, “Xaunga wa manga te. Ngaiti Tibugu yanoa, ne ang gatatua yagua. ");
INSERT INTO met_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ngasai yaya manga te. Ne tela sai yaya manga, saing ing ganina lipu suxuyangama. ");
INSERT INTO met_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Maxung sibuna ngabalang ba, lipu gaxarea su mana haruangagua, matiyua sanga ba xap te.” ");
INSERT INTO met_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Harua bila ba baing Yudadi yanamidingdi daharua na ba, “Si, hatata am gaxabia ba xaunga wa maung sibuna! Ebraham mati ba, Urana lipuxing suxunguxunguamdi dimati xauna, ne ung guharua ba lipu gaxarea su mana haruangama, matiyua sanga ba xap te. ");
INSERT INTO met_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Baruta? Ung gudali mugangaroa Ebraham? Mati ba, Urana lipuxing suxunguxunguamdi dimati xauna. Ung gahatumiaung lipua na baru?” ");
INSERT INTO met_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu haxuya ba, “Nabu ngaiti yagua, bing yagua axamang olang. Ne Tibugu, ina iti yagua. Ina aharua ba Urana angia. ");
INSERT INTO met_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ang gaxabia ina te, ne nga ngaxabiau. Nabu ngaharua ba ngaxabia te, bagula ngawa lipu languangam bila ang. Ning maxung sibuna ngaxabia saing ngasu mana haruanganoa. ");
INSERT INTO met_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tibuim Ebraham gamona yaha ba bagula bagu xaidabigua. Bagu ba, saing yaha.” ");
INSERT INTO met_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Binabu Yudadi yanamidingdi daharua na ba, “Nianimdi 50 teguyu! Ubagu Ebraham baru?” ");
INSERT INTO met_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Baing Yesu harua nadi ba, “Maxung sibuna ngabalang ba, muga mana Ebraham sok teguyu, ngawa!” ");
INSERT INTO met_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Harua bila ba, baing daxap siangdi ba daxatu, ning hisa manadi saing yunga Urana Numang yabania mala. ");
INSERT INTO met_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu haxa mala, baing bagu lipu tela maxandi dahaxatu. Waleu bauna hayau bila ba. ");
INSERT INTO met_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Baing lipuxindi dinaxu mana duxusunga ba, “Lipu Tubatubaingam, gaxarea libu kubolu diana ba maxandi dahaxatu mana bungina hayauxinganoa? Lipua li kimbo baungtibundi?” ");
INSERT INTO met_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu haxuya ba, “Lipua li kubolung diana libu maxandi dahaxatu te, xaung baungtibundi kuboluding diandi xauna dilibu te. Ning axa li sok bu Urana oxatanoa sanga ba sok sabasabia mana walinganoa. ");
INSERT INTO met_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Hatata xaidap, binabu tatuxu ina soxi nga ma oxatanoa. Yambonga ma yu, saing lipu tela sanga ba waxata mana bungina baguba te. ");
INSERT INTO met_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Hatata bungina ngawa titiauyu, ngawa luliang titiam.” ");
INSERT INTO met_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Harua laing sup, baing gip titia, xaningxaning titia xaung gaugaung langindi laing bangabina, saing sabaxaya lipua ba maxandi. ");
INSERT INTO met_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Baing harua na ba, “Ula, usugu mana lang gamolingana Siloam.” (Siloam namuxinoa bing “Disoxi.”) Binabu lipua ba ila sugu, saing goxoya mala numia saing bagu xai dup! ");
INSERT INTO met_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yabanamdi xaung lipuadi muga dibagu xusunga lipudi olang olang mana sianga ding duxusunga ba, “Lipua ba gaxarea? Lipua muga rung xusunga lipudi olang olang mana sianga?” ");
INSERT INTO met_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Teladi daharua ba, “Ina naga.” Teladi daharua ba, “Tegu. Ne lipu tela bagunganoa taininau.” Ne ing sibuna haxi ba, “Nga naga!” ");
INSERT INTO met_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Binabu duxusunga ba, “Ne maxamdi daxaxa ding baru?” ");
INSERT INTO met_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Haxuya ba, “Lipua duxu ba Yesu xaningxaning bangaba saing sabaxaya maxagudi. Bala nga ba ngala Siloam ngasugu. Binabu ngala ngasugu, baing ina naga ngabagu dup.” ");
INSERT INTO met_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Duxusunga ba, “Lipua ba kabila?” Harua ba, “Ngaxabia te.” ");
INSERT INTO met_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tauna, daxap lipua muga maxandi dahaxatu ba ma rangua Parisidi. ");
INSERT INTO met_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ne xaidaba Yesu xaningxaning bangaba saing xaxa lipua ba maxandi bing Xaidap Yaguangama. ");
INSERT INTO met_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Binabu Parisidi duxusunga xauna ba, “Maxam disok xai baru?” Haxuya ba, “Ta bangaba maxagia, saing ngasugu, baing ina naga hatata ngabagu dup.” ");
INSERT INTO met_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Parisi teladi daharua ba, “Lipua ba ma rangua Urana te, namua na su mana Xaidap Yaguangam hanaunaunganoa te.” Ne teladi duxusunga ba, “Ne lipu kubolu dianama sanga ba libu axamang haringindi bila ba baru?” Binabu dahata ding. ");
INSERT INTO met_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Baing ina naga, duxugia mala rangua lipua muga maxandi dahaxatu, saing duxusunga muli ba, “Uharua baru mana lipua ba? Namua na xaxa maxamdi.” Baing haxuya ba, “Ina Urana lipuxing suxunguxunguam tela.” ");
INSERT INTO met_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yudadi yanamidingdi dahatum haringina teguyu ba muga maxandi dahaxatu saing kimuya daxaxa, laing duwagi baungtibundi dima. ");
INSERT INTO met_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Duxusunga dingtang ba, “Lipua li garaima? Lipua li tang gaharua ba bauna hayau maxandi dahaxatu? Ne hatata bagu baru?” ");
INSERT INTO met_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Baing baungtibundi dahaxuya ba, “Tam gaxabia ba tam garamama, saing tam gaxabia ba bauna hayau maxandi dahaxatu. ");
INSERT INTO met_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ning hatata bagu baru, kimbo gaxarea xaxa maxandi, tam gaxabia te. Axusunga. Ina lipu sabanga, binabu sanga ba ing sibuna baxangaina.” ");
INSERT INTO met_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Baungtibundi daharua bila ba namua na dimaxuwa Yudadi yanamidingdi, namua na yanamidingdi dahau hatumingua masup ba lipu gaxarea dibaxanga ba Yesu ina Urana Lipuxing Mogunganama bagula dibilidi mana dila digugunia Yudadi sabungading numania. ");
INSERT INTO met_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Namua naga baungtibundi daharua ba, “Ina lipu sabanga. Axusunga.” ");
INSERT INTO met_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tauna, duwagi lipua muga maxandi dahaxatu ba ma muli saing daharua na ba, “Bing uiti Urana yanoa ubaxanga maxuna maxania. Am gaxabia ba lipua ba lipu kubolu dianama.” ");
INSERT INTO met_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Baing haxuya ba, “Lipua ba lipu kubolu dianam kimbo tegu, ngaxabia te. Axamang taininau ngaxabia bing muga maxagudi dahaxatu, ne hatata ngabagu dup!” ");
INSERT INTO met_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Baing duxusunga muli ba, “Raxata maung? Xaxa maxamdi baru?” ");
INSERT INTO met_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Haxuya nadi ba, “Ngabalang masup saing alungu te. Abo ba alungu muli baru? Bola ang gabo ba asok lipuxindi dinaxu mana ba xauna?” ");
INSERT INTO met_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Saking didaudau ba, “Ung ba lipua unaxu mana! Am ba am Moses lipuxindi am ganaxu mana! ");
INSERT INTO met_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Am gaxabia ba Urana harua na Moses, ne lipua ba, am gaxabia longga ma mana te.” ");
INSERT INTO met_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Baing lipua haxuya ba, “Si! Ngahixi sibuna mana haruangaima baing! Ang gaxabia longga ma mana te, ne xaxa maxagudi. ");
INSERT INTO met_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Taxabia ba Urana lungu lipu kubolu dianamdi te. Tegu. Lungu lipu gaxarea duwa hawa mana xaung disu mana murunganoa. ");
INSERT INTO met_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mugamugau sibuna ma, talungu ba lipu tela xaxa lipu maxandi dahaxatu bungina hayauxinganoa te. ");
INSERT INTO met_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nabu lipua ba ma rangua Urana te, bing sanga ba libu axamang tela te.” ");
INSERT INTO met_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Dahaxuya na ba, “Baruta? Kubolu diandi dibaxagi maung mana bungina hayauxingama! Baing ubo ba utubatubam?” Baing duxu masok mala. ");
INSERT INTO met_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu lungu ba duxu mala, baing ila sok mana saing harua ba, “Uhatum haringina mana Lipua Ma Rangua Urana?” ");
INSERT INTO met_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Baing lipua xusunga ba, “Lipu sabanga, ina gaxarea? Ubaxanga nanga bu sanga ba ngahatum haringina mana.” ");
INSERT INTO met_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Baing Yesu harua na ba, “Ubagu ba. Ina naga harua ranguaung.” ");
INSERT INTO met_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Baing lipua harua ba, “Toxoratamona, ngahatum haringina.” Saking sabu mana. ");
INSERT INTO met_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Baing Yesu harua ba, “Ngari ma titia li bu ngasuxuya lipudi. Bila balau, binabu lipu maxa haxatiandi bagula dibagu, xaung lipudi dibagu bagula maxading dahaxatu.” ");
INSERT INTO met_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parisi teladi duwa haxek rangua dilungu ba harua bila ba saing daharua ba, “Baruta? Am lipu maxa haxatiandi xauna?” ");
INSERT INTO met_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Baing Yesu harua nadi ba, “Nabu ang lipu maxa haxatiandi, bing bagula axola mana kubolu diandi. Ning hatata aharua ba maxaimdi dibagu, binabu kuboluim diandi duwauyu.” ");
INSERT INTO met_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu haruauyu, harua ba, “Maxung sibuna ngabalang ba, lipu gaxarea luxu sipsip gamgamingang xaluxinia te, ne laxuwa mari gamgamingia long tela, rimandi didoa xaung ina lipu hanaunggam. ");
INSERT INTO met_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Lipua luxu xaluxinia, ina lipu sipsibiding wasanganama. ");
INSERT INTO met_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Lipu xalu wasanganama xaxa xalua mana lipua ba, saing sipsipdi dilungu lipua ba waxungtuanoa. Uxu sipsibing taining tainina yadingdi, saing xaidi masok. ");
INSERT INTO met_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Xap iniadi masok laing sup, baing muga manadi, saing sipsibindi disu mana, namua na daxabia waxungtuanoa. ");
INSERT INTO met_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ning bagula disu mana lipu xan tela te, ne bagula diluki mala sangua namua na daxabia lipu xan tela waxungtuanoa te.” ");
INSERT INTO met_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu harua haruanga babuna ba, ne lipudi daxabia haruanganoa rangrang te. ");
INSERT INTO met_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Binabu Yesu harua nadi muli ba, “Maxung sibuna ngabalang ba, nga sipsipdi xaluxidinga. ");
INSERT INTO met_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Lipu longgalo dima muga manga, rimadingdi didoa xaung ding lipu hanaunggamdi, ne sipsipdi dilungudi te. ");
INSERT INTO met_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nga xalua. Lipu gaxarea ma rangua nga saing luxu, bagula Urana xap muli. Bagula luxu xaung sok, saing bagula sok mana tatubang xaiyua bu xang. ");
INSERT INTO met_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Lipu hanaunggama ma bu hanai xaung ung xaung hanggalangia ing ganina. Nga ngama bu daxap walinga xaung dibaxagi mana. ");
INSERT INTO met_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nga lipu sipsip wasanganam xaiyua. Lipu sipsip wasanganam xaiyua yunga walinganoa bu hauli sipsipdi. ");
INSERT INTO met_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Lipu gaxarea sipsip moxonoa gim bu wasa mana sipsipdi, lipua ba lipu sipsip wasanganam sibuna te, saing sipsipdi iniadi te. Bungina bagu koma abunginoa ma, bagula yunga sipsipdi saing giti mala. Baing ina naga, koma abunginoa sasaxaki tela saing teladi dahalukiana. ");
INSERT INTO met_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Lipua ba giti mala, namua na waxata siangia saing murunganoa wa rangua sipsipdi te. ");
INSERT INTO met_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Nga lipu sipsip wasanganam xaiyua. Ngaxabia sipsibigudi, saing sipsibigudi daxabia nga, ");
INSERT INTO met_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","bila Tibugu xabia nga, xaung ngaxabia ina. Binabu ngayunga walingagua bu ngahauli sipsipdi. ");
INSERT INTO met_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nga sipsibigu teladi duwa sipsipkadi li gamgamingading lunia te. Bing bagula ngaxapdi ma xauna, saing bagula dilungu waxugutuanoa. Baing bagula sipsip bakbaging taininau wa rangua lipu sipsip wasanganam taininau ing ganina. ");
INSERT INTO met_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tibugu murung sibuna manga, namua na, ngayunga walingagua bu ngaxap muli. ");
INSERT INTO met_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Lipu tela xap walingagua mala sangua nga te. Tegu. Nga ngayunga walingagua mana murungagua. Nga haringingagua ba ngayunga, saing nga haringingagua ba ngaxap muli. Tabinanga ba ngaxap rangua Tibugu.” ");
INSERT INTO met_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yudadi dilungu haruanga ba, baing dahata ding muli. ");
INSERT INTO met_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Dingia xumana daharua ba, “Xaunga wa mana xaung kakahang sibuna. Baruta alungu?” ");
INSERT INTO met_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ning teladi daharua ba, “Haruanga li lipu tela xaunga wa mana sanga ba harua bila te. Xaunga sanga ba xaxa lipu maxa haxatiana maxandi? Tegu!” ");
INSERT INTO met_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Baing Yudadi taungading tela sok Yerusalem. Dahatumia muli Xaidapka Daxaxa Urana Numanoa. Bunging xaringana, ");
INSERT INTO met_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","baing Yesu wa Urana Numang yabania, haxa mana longga duxu ba Solomon Numa Nanung Sabasabia. ");
INSERT INTO met_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Baing Yudadi digugunia taxiya saing daharua ba, “Bungintabi bagula ulibu gamomamdi dimaxana saing ubalam ba ung gaxarea? Nabu ung Urana Lipuxing Mogunganama, bing ubaxanga rangrang nam.” ");
INSERT INTO met_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu haxuya nadi ba, “Ngabalang masup, ne ahatum haringin te. Axamang haringindi ngalibudi Tibugu yania dahatanga nang ba nga gaxarea, ");
INSERT INTO met_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ne ang ba ahatum haringin te, namua na ang sipsibigudi te. ");
INSERT INTO met_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipsibigudi dilungu waxugutuanoa. Ngaxabiadi, saing disu manga. ");
INSERT INTO met_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ngasina walinga subingang teguama nadi, saing sanga ba disup te. Lipu tela sanga ba sasaxakidi sangua rimagua te. ");
INSERT INTO met_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tibugu sinadi nanga ba, ina dali lipu longgalo. Lipu tela sanga ba sasaxakidi sangua Tibugu rimanoa te. ");
INSERT INTO met_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nga Tibugu tam taininau.” ");
INSERT INTO met_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yudadi daxap siangdi muli bu daxatu, ");
INSERT INTO met_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ne Yesu harua nadi ba, “Ngahatanga nang axamang haringing sibundi disok Tibugu haringingania. Baing axamang haringing baruamta abo ba axatu nga siangia mana ba?” ");
INSERT INTO met_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yudadi dahaxuya na ba, “Axamang tela mana axadi li te, ne am gabo ba am gaxatung siangia namua na uharungia Urana. Ung ba ung lipu ing ganina, ne ubaxanga ba ung Urana.” ");
INSERT INTO met_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu haxuya nadi ba, “Haruanga li dibung hanaunaungaimia, saing bola axabia te? Harua Urana haruanganoa ba, ‘Ngaharua ba awa uranadi.’ ");
INSERT INTO met_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Urana harua haruanga ba. Baing axabia ba haruanga tela wa Xuania sanga ba xugia te. Baing ina naga, nabu lipuadi Urana sina haruanganoa nadi ba uxudi ba ‘uranadi’, ");
INSERT INTO met_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","bing baruta aharua ba ngaharungia Urana bungina ngaharua ba, ‘Nga Urana Garanoa’? Namua na Tibugu mogu nga saing soxi nga ma titia. ");
INSERT INTO met_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nabu ngatuxu Tibugu oxatanoa te, bing labu ahatum haringina mangau tai. ");
INSERT INTO met_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ning ngatuxu oxatanoa baing. Baing ina naga, nabu ahatum haringina manga te, bing ahatum haringina mana axamang haringindi, bu axabia rangrang ba Tibugu taga rangua nga, saing ngataga rangua.” ");
INSERT INTO met_vpl VALUES ("JN10_39","073_