﻿USE sofia;
DROP TABLE IF EXISTS sofia.meq_vpl;
CREATE TABLE meq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES meq_vpl WRITE;
INSERT INTO meq_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Anaŋ ɗerewel i məzele i bəba təte hay i Yesu Kəriste: Yesu Kəriste na, slala i Davit ada Davit na, slala i Abraham. Bəba təte i Yesu hay na, anaŋ: ");
INSERT INTO meq_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham a lah məwe Izak. Izak a wa Zakob. Zakob a wa Yahuda ta malamar ŋgay hay. ");
INSERT INTO meq_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda a wa Fares tə Zara, may tay na, Tamar. Fares a wa Hesron. Hesron a wa Aram. ");
INSERT INTO meq_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram a wa Aminadab. Aminadab a wa Nasoŋ. Nasoŋ a wa Salmoŋ. ");
INSERT INTO meq_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmoŋ a wa Booz, may i Booz na, Rahab. Booz a wa Obed, may i Obed na, Rut. Obed a wa Zese. ");
INSERT INTO meq_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Zese a wa bəy Davit. Davit a wa Salomoŋ, may i Salomoŋ na, ŋgwas i Uri. ");
INSERT INTO meq_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomoŋ a wa Robowam. Robowam a wa Abiya. Abiya a wa Asaf. ");
INSERT INTO meq_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaf a wa Zozafat. Zozafat a wa Zoram. Zoram a wa Oziyas. ");
INSERT INTO meq_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziyas a wa Yotam. Yotam a wa Akaz. Akaz a wa Ezekiyas. ");
INSERT INTO meq_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiyas a wa Manase. Manase a wa Amoŋ. Amoŋ a wa Zoziyas. ");
INSERT INTO meq_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zoziyas a wa Yekoniya ta malamar ŋgay hay. A wa tay ha na, ahəl nakə tə gəs tay beke eye hay a Babilon aye. ");
INSERT INTO meq_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ma dəba eye nakə ti ye tay ha a Babilon aye na, Yekoniya a wa Salatiyel. Salatiyel a wa Zorobabel. ");
INSERT INTO meq_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel a wa Abihod. Abihod a wa Eliyakim. Eliyakim a wa Azor. ");
INSERT INTO meq_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor a wa Sadok. Sadok a wa Akim. Akim a wa Eliyod. ");
INSERT INTO meq_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyod a wa Eleyazar. Eleyazar a wa Matan. Matan a wa Zakob. ");
INSERT INTO meq_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zakob a wa Yusufa tuk. Neŋgeye na, zal i Mari nakə a wa Yesu, tə zalay Kəriste aye. ");
INSERT INTO meq_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","A gəs abəra ka Abraham hus ka Davit na, slala kuro gər eye faɗ. Ada a gəs abəra ka Davit hus ahəl nakə tə gəs tay ha Israyel hay a Babilon aye na, slala kuro gər eye faɗ. Sa na, a gəs abəra ka məgəse tay ha Israyel hay a Babilon hus ka Kəriste na, slala kuro gər eye faɗ. ");
INSERT INTO meq_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Anaŋ ma kəkay nakə tə wa Yesu Kəriste aye. May ŋgay na, tə zalay Mari, neŋgeye mədel i Yusufa. Ane tuk na, ahəl nakə ta zla bo zuk bay aye na, kiye a yay a Mari ta gədaŋ i Məsəfəre Tsəɗaŋŋa eye. ");
INSERT INTO meq_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusufa mədel ŋgay na, neŋgeye ndo i deɗek kame i Mbəlom. A say məndəɗe horoy ka Mari kame i ndo hay bay. A dzala mə gər ŋgay məgəre ha mədel ŋgay ta məkal. ");
INSERT INTO meq_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Həlay nakə neŋgeye faya ma dzaliye andza niye na, gawla i Mbəlom a bəzay ha bo ma məsine, a gwaɗay: «Yusufa, slala i Davit, kâ dzədzar məzle mədel yak Mari bay. Hərwi kiye a yay a Mari na, ta gədaŋ i Məsəfəre Tsəɗaŋŋa eye. ");
INSERT INTO meq_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ma wiye wawa hasləka eye, ada nəkar ka zaleye Yesu, hərwi ma təmiye tay ha gwala ŋgay hay abəra mə mezeleme tay.» ");
INSERT INTO meq_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Wu neheye tebiye tə ndislew na, hərwi ada wu nakə Bəy Maduweŋ a tsik tə bazlam i ndo məɗe ha bazlam ŋgay aye mâ ge bo. A gwaɗ: ");
INSERT INTO meq_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Anaŋ dem nakə a sər zal zuk bay aye ma hutiye wawa, ma wiye wawa hasləka eye, ta zaleye Emanuyel.» ");
INSERT INTO meq_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusufa a pəɗeke abəra ka məndzehəre na, a ge wu nakə gawla i Mbəlom a gwaɗay ge aye. A zla na Mari andza ŋgwas ŋgay a gay ŋgay. ");
INSERT INTO meq_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ane tuk na, ta dzapa zuk bay hus a pat nakə Mari a wa na wawa hasləka eye. Ada Yusufa ma zaleye na, Yesu. ");
INSERT INTO meq_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tə wa Yesu na, ma Betelehem ka dala i Yahuda, a həlay nakə Herod neŋgeye bəy bagwar eye aye. Ma dəba eye tə wa na Yesu na, ndo matəkay ɗəre a wurzla hay ti yaw mə bəzay, tə ndislew a Zerozelem, ");
INSERT INTO meq_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ta tsətsah, tə gwaɗ: «Bəy i Yahuda hay nakə tə wa na anəke aye na, məŋgay? Nəmaa ŋgatay a wurzla ŋgay eye a tsaraw mə bəzay ada nəmaa yaw na, məɗəslay ha gər.» ");
INSERT INTO meq_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bəy Herod a tsəne bazlam tay niye na, a kwasay gər haladzay tə siye i ndo neheye ma Zerozelem aye tebiye. ");
INSERT INTO meq_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","A zalatay a bagwar i ndo neheye tə vəlaway wu a Mbəlom aye ta ndo neheye tə dzaŋgawa bazlam i Mbəlom mapala eye, a tsətsah fataya a gwaɗatay: «Tə wa Kəriste na, məŋgay?» ");
INSERT INTO meq_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ta mbəɗay faya, tə gwaɗay: «Tə wa Kəriste na, ma Betelehem, ka dala i Yahuda. Hərwi ndo məɗe ha bazlam i Mbəlom a watsa, a gwaɗ: ");
INSERT INTO meq_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Nəkar Betelehem ka dala i Yahuda, nəkar na, makətsa bo eye mə walaŋ i gəma neheye ka dala i Yahuda aye bay. Hərwi bəy nakə ma tsəkuriye tay ha Israyel ndo ga hay aye na, ma deyeweye abəra ma nəkar.”» ");
INSERT INTO meq_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yawa! Herod a zalatay a ndo matəkay ɗəre a wurzla hay ta məkal. A tsətsah fataya, a gwaɗatay: «Ka ŋgatumay a wurzla ŋgay eye a tsaraw na, a həlay waray?» ");
INSERT INTO meq_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tsa na, a slər tay ha a Betelehem, a gwaɗatay: «Dum, pəlum na wawa eye niye lele. Ka hutum na na, dumara ɗumeŋ ha hərwi ada neŋ dərmak nâ ye məɗəslay ha gər.» ");
INSERT INTO meq_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ndo neheye tə tsəne bazlam i bəy na, tə həl bo, ti ye. Ahəl nakə faya ta diye na, tə ŋgatay a wurzla nakə a tsaraw mə bəzay aye faya ma diye kame tay. A husa ka gər i gay nakə wawa mə ɗəma aye na, a lətse. ");
INSERT INTO meq_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tə ŋgatay andza niye na, ɗərev tay a rah ta məŋgwese. ");
INSERT INTO meq_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tə fələkwa a gay, ti ye naha, tə ŋgatay a wawa ta may ŋgay Mari. Ta dəkway gurmets, tə ɗəslay ha gər. Tsa na, tə pəla ha wu tay hay, tə vəlay wu kəriye a wawa niye. Tə vəlay gura, wu andaya tə zalay eŋseŋs ada ta mir. ");
INSERT INTO meq_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ma dəba eye Mbəlom a tsikatay ma məsine, a gwaɗatay: «Kâ mbəɗum gər ta təv i Herod sa bay.» Tə tsəne andza niye na, tə həl bo, ti ye a gəma tay ta tsəveɗ mekeleŋ eye. ");
INSERT INTO meq_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ahəl nakə ndo matəkay ɗəre a wurzla hay ti ye wu tay na, gawla i Mbəlom a yaw ka təv i Yusufa ma məsine. A gwaɗay: «Lətse, zla na wawa ta may ŋgay, hwayum a Ezipt. Ndza mə ɗəma hus a pat nakə na gwaɗakeye maw aye, bəna Herod faya ma pəliye wawa nakay məkəɗe na.» ");
INSERT INTO meq_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yusufa a tsəne andza niye na, a lətse, a ye tay ha wawa ta may ŋgay a Ezipt ta həvaɗ. ");
INSERT INTO meq_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tə ndza mə ɗəma hus a pat nakə Herod a mət aye. Wu neheye tebiye na, hərwi ada wu nakə Bəy Maduweŋ a tsik tə bazlam i ndo məɗe ha bazlam ŋgay aye mâ ge bo parakka, a gwaɗ: «Na zalay a wawa ga mâ yaw abəra mə Ezipt.» ");
INSERT INTO meq_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herod a zəba faya ndo matəkay ɗəre a wurzla hay ta vay gər na, a ndalay haladzay. Tsa na, a slər ndo hay, a vəlatay tsəveɗ ka məkəɗe wawa hasləka eye tebiye a dazlay ka neheye a sla məve sulo bay aye ma Betelehem ada ma gəma neheye tə mbay naha aye. ");
INSERT INTO meq_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Andza niye, maa ge bo na, bazlam i Zeremi ndo məɗe ha bazlam i Mbəlom nakə a tsik aye, a gwaɗ: ");
INSERT INTO meq_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Mawude a tsənew abəra ma gəma i Rama, mətuwe tə zlazlay haladzay mə ɗəma. Rasel faya ma tuwiye wawa ŋgay hay. Ɗaɗa a say məgəse ɗərev abəra ka mətuwe bay, hərwi wawa ŋgay hay andaya sa bay.» ");
INSERT INTO meq_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ma dəba eye Herod a mət na, gawla i Mbəlom a yaw ka təv i Yusufa ma məsine ma Ezipt. ");
INSERT INTO meq_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","A gwaɗay: «Lətse, zla na wawa ta may ŋgay ada mbəɗa gər a gəma i Israyel, hərwi ndo neheye ta pəla tsəveɗ ka wawa nakay məkəɗe na aye na, ta mət.» ");
INSERT INTO meq_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yusufa a tsəne andza niye na, a zla na wawa ta may ŋgay, a mbəɗa gər a gəma i Israyel. ");
INSERT INTO meq_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ane tuk na, Yusufa a tsəne Arkelawos kə ndza a bəy i bəba ŋgay Herod ka dala i Yahuda na, a dzədzar haladzay mede a ɗəma. Məsine a gay sa, Mbəlom a ɗay ha wu nakə ma giye. Tsa na, a ye a Galile. ");
INSERT INTO meq_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","A ye, a ndza ma wuzlahgəma nakə tə zalay Nazaret aye. Andza niye wu neheye a ge bo na, andza i ndo məɗe ha bazlam i Mbəlom neheye tə tsik aye. A gwaɗ: «Ta zaleye na, ndo i Nazaret.» ");
INSERT INTO meq_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","A həlay niye na, Yuhana madzəhuɓe ndo a yam a ndohwaw mə kəsaf i Yahuda, a ɗawa ha bazlam i Mbəlom, ");
INSERT INTO meq_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","a gwaɗawa: «Mbəɗum ha mede kurom, hərwi Bəy i Mbəlom bəse tə nəkurom.» ");
INSERT INTO meq_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yuhana na, ndo nakə Ezay ndo məɗe ha bazlam i Mbəlom a tsik faya, a gwaɗ: «Ndo faya ma wudiye mə kəsaf, a gwaɗ: Lambaɗumay tsəveɗ a Bəy Maduweŋ, lambaɗumay tsəveɗ hay fehe lele tâ hədzak bay.» ");
INSERT INTO meq_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yuhana a pawa ka bo na, petekeɗ maŋgara eye ta məkwets i zləgweme. A ɓarawa bəzihuɗ ŋgay na, ta həzlay. A ndayawa mə kəsaf niye na, heyew ta wum. ");
INSERT INTO meq_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ndo neheye ma Zerozelem aye, ka dala i Yahuda tebiye, ada ta ndo neheye tə mbay naha a magayam i Yurdum aye tebiye tə yawa ka təv i Yuhana. ");
INSERT INTO meq_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tə ɗawa ha mezeleme tay hay parakka kame i ndo hay, ada Yuhana a dzəhuɓawa tay ha a yam mə magayam nakə tə zalay Yurdum aye. ");
INSERT INTO meq_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yuhana a zəba ɗəre, Farisa hay ta Saduke hay haladzay ta diye ka təv ŋgay hərwi ada mâ dzəhuɓ tay ha a yam na, a gwaɗatay: «Wawa i palas hay! Maa ɗakum ha hwayum abəra ka sariya i Mbəlom nakə bəse kə ndzew aye na, way? ");
INSERT INTO meq_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Anəke na, gum məsler neheye ŋgwalak eye, ada ndo hay ta səriye ha ka mbəɗum ha mede kurom aye tuk. ");
INSERT INTO meq_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kâ dzalum mə gər kurom: “Nəmay na, wawa i Abraham hay sa na, ma ta gamay mey?” bay! Sərum ha na, Mbəlom ma sliye faya məge tay ha kwar neheye anaŋ aye wawa i Abraham hay. ");
INSERT INTO meq_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ɓa hadzaya maləva bo eye məɗəse tay ha dərizl i gərɗaf hay fəroɗ abəra ka dala. Dərizl i gərɗaf neheye tebiye tə wa hohway ŋgwalak eye bay aye na, ta ɗəsiye tay ha ada ta kaliye tay ha ako.» ");
INSERT INTO meq_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","«Neŋ na, na dzəhuɓiye kurom ha a yam tsa hərwi məɗe ha na, ka mbəɗum ha mede kurom. Ane tuk na, ndo nakə ma deyeweye kame ga aye na, neŋgeye a ze ga ta gədaŋ. Neŋ na sla matsakway ahaya tahərak ŋgay hay abəra mə sik bay. Neŋgeye na, ma dzəhuɓiye kurom ha ta Məsəfəre Tsəɗaŋŋa eye ada ta ako. ");
INSERT INTO meq_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wu mahəve daw andaya mə həlay. Ma ŋgəniye tay ha daw ta dzəndzar. Daw na, ma hayay gər ma həliye na a de. Ada dzəndzar na, ma dziye a ako nakə ma mbatiye ɗaɗa bay aye.» ");
INSERT INTO meq_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ma dəba eye na, Yesu a yaw abəra ma Galile hus a magayam i Yurdum. A yaw ka təv i Yuhana hərwi ada Yuhana mâ dzəhuɓ ha a yam. ");
INSERT INTO meq_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yuhana a wuɗa bay. A gwaɗay a Yesu: «Neŋ ɗuh nakə na diye naha ka təv yak ka dzəhuɓiye ga ha a yam aye tuk na, ada nəkar ɗuh ka deyeweye ka təv ga na, kəkay!» ");
INSERT INTO meq_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ane tuk na, Yesu a mbəɗay faya, a gwaɗay: «Təma, mâ ge bo andza niye anəke. Wu nakə Mbəlom a tsətsah aye ka gakweye andza nakə a tsik aye.» Yuhana a təma bazlam i Yesu nakə a tsikay aye. A dzəhuɓ ha Yesu a yam tuk. ");
INSERT INTO meq_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","A dzəhuɓ ha a yam tsa na, Yesu a tsalaw abəra ma yam. Kwayaŋŋa magərmbəlom a həndək tuwaŋ, ada Yesu a ŋgatay a Məsəfəre i Mbəlom a mbəzlaw andza bodobodo, a yaw a ndza faya. ");
INSERT INTO meq_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tsa na, mətsike me a tsənew mə mbəlom, a gwaɗ: «Nakay na, wawa ga, na wuɗa na haladzay. Ɗərev ga faya ma ŋgwasiye tə neŋgeye.» ");
INSERT INTO meq_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ma dəba eye na, Məsəfəre i Mbəlom a ye ha Yesu a makulkwandah hərwi ada Fakalaw mâ səpat na. ");
INSERT INTO meq_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu a ndza məhəne kuro kuro faɗ, həpat həvaɗ ze mənde wu mənday. Ma dəba eye na, may a wur faya. ");
INSERT INTO meq_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Fakalaw, ndo masəpete ndo a yaw, a həndzəɗ ka təv i Yesu, a gwaɗay: «Taɗə kə ge nəkar Wawa i Mbəlom na, gwaɗatay a kwar neheye tâ təra wu mənday ada kâ nda!» ");
INSERT INTO meq_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu a mbəɗay faya, a gwaɗay: «Mawatsa eye mə bazlam i Mbəlom na, ndo zezeŋ ma ndziye na, ta wu mənday ɗekɗek tsa bay, ane tuk na, ma ndziye tə bazlam nakə Mbəlom a tsik aye tebiye.» ");
INSERT INTO meq_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Fakalaw a ye ha a Zerozelem, gəma tsəɗaŋŋa eye. A ye ha ka gər i gay i məɗəslay ha gər a Mbəlom, ");
INSERT INTO meq_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","a gwaɗay: «Taɗə kə ge nəkar Wawa i Mbəlom na, kal ha bo abəra ka gər i gay nakay ka dala. Hərwi mawatsa eye mə bazlam i Mbəlom na, a gwaɗ: “Mbəlom ma gwaɗateye a gawla ŋgay hay tâ dzəna kar. Tâ kəndawa kar hərwi ada sik yak mâ ndzay a kwar bay.”» ");
INSERT INTO meq_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu a mbəɗay faya, a gwaɗay: «Mawatsa eye mə bazlam i Mbəlom na, a gwaɗ: “Kâ dza ha Bəy Maduweŋ yak Mbəlom bay.”» ");
INSERT INTO meq_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Fakalaw a zla na a ye ha ka gər i mahəmba zəbol eye, a bəzay ha bəy i məndzibəra tə zlele nakə mə ɗəma aye tebiye. ");
INSERT INTO meq_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","A gwaɗay a Yesu: «Ka dəkweŋ gurmets ada ka ɗəsleŋ ha gər na, na vəlakeye ha a nəkar tebiye.» ");
INSERT INTO meq_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu a gwaɗay: «Fakalaw, do abəra kanaŋ! Hərwi mawatsa eye mə bazlam i Mbəlom na, a gwaɗ: “Ɗəslay ha gər a Bəy Maduweŋ yak Mbəlom, ada ka geye məsler na, a neŋgeye nəte ŋgweŋ.”» ");
INSERT INTO meq_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ka təv eye niye na, Fakalaw a gər ha. Gawla i Mbəlom hay ti yaw ka təv i Yesu, tə vəlay wu mənday. ");
INSERT INTO meq_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ahəl nakə Yesu a tsəne ta gəs na Yuhana madzəhuɓe ndo a yam aye na, a ye a Galile. ");
INSERT INTO meq_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ahəl nakə faya ma diye na, a ye ta Nazaret təday, tsa na, a ye abəra mə ɗəma, a ye a Kafernahum ka tsakay i dəlov i Galile, ma gəma i Zabulon ta Naftali. ");
INSERT INTO meq_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","A ge bo andza niye na, andza nakə Ezay ndo məɗe ha bazlam i Mbəlom a tsik aye, a gwaɗ: ");
INSERT INTO meq_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Nəkurom ndo neheye ma gəma i Zabulon ta Naftali, ta nəkurom neheye ka tsəveɗ mede a dəlov, ta diye i magayam i Yurdum aye, a nəkurom neheye ma Galile mandza eye mə walaŋ i ndo neheye Yahuda hay bay aye! ");
INSERT INTO meq_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nəkurom slala neheye mandza eye ma ləvoŋ aye na, ka ŋgatumay a dzaydzay bagwar eye. Nəkurom neheye mandza eye ma gəma i mezek i mədahaŋ aye na, dzaydzay ka dəvakum.» ");
INSERT INTO meq_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","A həlay niye kwayaŋŋa Yesu a dazlay məɗe ha bazlam i Mbəlom a ndo hay. A gwaɗawa: «Mbəɗum ha mede kurom, hərwi Bəy i Mbəlom ka həndzəɗaw.» ");
INSERT INTO meq_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu faya ma diye ta tsakay i dəlov i Galile na, a ndzay a gər a ndo wuray sulo ta malamar ŋgay. Neŋgeɗ na, Simoŋ nakə tə zalay Piyer neŋgeye ta malamar ŋgay Aŋdəre. Nəteye ndo məgəse kəlef hay, faya ta kaliye gadaŋ tay a dəlov. ");
INSERT INTO meq_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu a gwaɗatay: «Dumara, pumeŋ bəzay. Anəke faya ka həlumeye kəlef, ane tuk na, na təriye kurom ha ndo məhəlaw ndo hay.» ");
INSERT INTO meq_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kwayaŋŋa tə gər ha gadaŋ tay hay, tə pay bəzay a Yesu. ");
INSERT INTO meq_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesu a ye kame dəreŋ tsekweŋ sa na, a ndzatay a gər a ndo mekeleŋ eye sulo ta malamar ŋgay sa, Yakuba ta Yuhana wawa i Dzebede hay. Nəteye mə kwalalaŋ i yam tay ta bəba tay Dzebede, faya ta lambaɗiye gadaŋ tay hay. Yesu a zalatay. ");
INSERT INTO meq_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tə tsəne na, kwayaŋŋa tə gər ha kwalalaŋ i yam ta bəba tay, tə pay bəzay a Yesu. ");
INSERT INTO meq_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu a həhalawa ka dala i Galile tebiye. A tətikawatay a ndo hay mə gay i maɗuwule me i Yahuda hay. A ɗawa ha Labara Ŋgwalak eye i Bəy i Mbəlom ada a mbəlawa tay ha ndo i ɗəvats hay ta ndo neheye matəra eye hay tebiye mə walaŋ i ndo hay. ");
INSERT INTO meq_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Labara i Yesu a ɗa zləm kwa ka dala i Siri tebiye. Tə həlayaw ndo neheye faya ta siye ɗəretsətseh ta ɗəvats hay wal wal aye, ndo neheye fakalaw mə bo tay aye, ndo neheye mahorvov a gatay aye, ada ta ndo neheye matəra eye hay. Yesu a mbəl tay ha. ");
INSERT INTO meq_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ndo hay haladzay mbərzəzza tə paway bəzay a Yesu. Ti yaw ma Galile, ma dala i Dekapol, ma Zerozelem, abəra ka dala i Yahuda ada ka dala nakə ma diye ŋgeɗ i magayam i Yurdum aye. ");
INSERT INTO meq_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu a ŋgatatay a ndo hay haladzay ta diye naha ka təv ŋgay na, a tsal ŋgway a gər i mahəmba. A ye naha a ndza ka dala. Gawla ŋgay hay ta zəŋgal na ti ye ka təv ŋgay. ");
INSERT INTO meq_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","A dazlay matətikatay, a gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Məŋgwese ka ndo neheye tə sər ha mə ɗərev tay nəteye mətawak eye hay aye, hərwi Bəy i Mbəlom na, i nəteye. ");
INSERT INTO meq_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","«Məŋgwese ka ndo neheye faya ta tuwiye, hərwi Mbəlom ma matay naha ɗərev. ");
INSERT INTO meq_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","«Məŋgwese ka ndo neheye ta rəh ha gər tay aye, hərwi nəteye na, Mbəlom ma vəlateye məndzibəra. ");
INSERT INTO meq_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","«Məŋgwese ka ndo neheye may a wur fataya ada yam a gatay aye hərwi marəhe ha gər a Mbəlom, hərwi Mbəlom ma vəlateye wu nakə a satay aye. ");
INSERT INTO meq_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","«Məŋgwese ka ndo neheye faya ta giye ŋgwalak a siye i ndo hay aye, hərwi Mbəlom ma gateye a ɗəma ŋgwalak dərmak. ");
INSERT INTO meq_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","«Məŋgwese ka ndo neheye ɗərev tay tsəɗaŋŋa kame i Mbəlom aye, hərwi nəteye na, ta ŋgateye a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","«Məŋgwese ka ndo neheye nəteye faya ta miye tay ha ka bo ndo hay hərwi ada tâ ndza zay aye, hərwi Mbəlom ma zalateye na, wawa ga hay. ");
INSERT INTO meq_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","«Məŋgwese ka ndo neheye faya ta sateye ɗəretsətseh hərwi nakə faya ta giye məsler nakə a yay a gər a Mbəlom aye, hərwi Bəy i Mbəlom na, i tay. ");
INSERT INTO meq_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«Məŋgwese ka nəkurom taɗə ndo hay ta tsaɗakum, ta sakum ɗəretsətseh, ada taɗə faya ta tsikiye fakuma wu neheye ŋgwalak eye bay ada ta rawiye fakuma me hərwi nakə ka dzalum ha ka neŋ aye. ");
INSERT INTO meq_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ŋgwasum haladzay, ɗərev kurom mâ rah ta məŋgwese, hərwi Mbəlom ma ta vəlakumeye magogoy kurom bagwar eye mə mbəlom. Sərum ha na, andza niye ta gatay ɗəretsətseh a ndo məɗe ha bazlam i Mbəlom neheye tə lahakumaw aye.» ");
INSERT INTO meq_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesu a gwaɗatay sa: «Nəkurom ka tərum ka məndzibəra na, andza sluwal nakə a vəɗ ma ala aye. Ane tuk na, taɗə sluwal a vəɗ sa bay na, ta sliye matəre ha mâ vəɗ həraɓəɓa sa na, ma kəkay? Ma giye ŋgama ka wuray sa bay. Ta kutsiye ha, ndo hay ta mbərasliye na tə sik. ");
INSERT INTO meq_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Nəkurom na, dzaydzay i məndzibəra. Huɗgay nakə ta ɗəzl na ma tsaholok aye na, ma ŋgahiye bo təta bay. ");
INSERT INTO meq_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ta pa ako ka lalam na, ta hurəkwiye faya gəse bay. Ta piye na ɗuh na, ka wu məpe lalam hərwi ada mâ dəvatay a ndo neheye mə gay aye tebiye. ");
INSERT INTO meq_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Andza niye dərmak, mede kurom mâ zəba kame i ndo hay andza dzaydzay nakə ma dəvateye a ndo hay aye, hərwi ada siye tâ ŋgatay a ŋgwalak nakə faya ka gumeye ada tâ zambaɗay a Bəba kurom mə mbəlom.» ");
INSERT INTO meq_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yesu a gwaɗatay sa: «Kâ dzalum mə gər kurom na yaw na, hərwi məmbete ha bazlam i Musa mapala eye tə matətike i ndo məɗe ha bazlam i Mbəlom hay bay. Na yaw hərwi məmbete ha bay. Ane tuk na, na yaw na, mandəve ha wu nakə bazlam i Musa mapala eye ada wu nakə ndo i maslaŋ i Mbəlom hay tə tsik məge aye ɗuh. ");
INSERT INTO meq_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Hərwi niye neŋ faya na tsikakumeye, sərum ha, kə ge magərmbəlom ta dala nəteye andaya huya na, ndəray ma sliye məmbete ha wuray kwa tsekweŋ abəra mə bazlam mapala eye bay. Kwa “i”, kəgəbay wu nakə mawatsa eye tsekweŋ bəbay na, ma mbatiye bay, wu tebiye ma giye bo təday. ");
INSERT INTO meq_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Hərwi niye, ndoweye kə gər ha bazlam mapala eye nəte, kwa tsekweŋ eye, ada faya ma ɗatay ha a ndo hay tâ ge andza neŋgeye na, neŋgeye ma təriye tsekweŋ ma Bəy i Mbəlom. Ane tuk na, taɗə ndoweye ka rəhay ha gər a bazlam mapala ada ka tətikatay a siye i ndo hay tâ rəhay ha gər dərmak na, neŋgeye ma təriye bagwar eye ma Bəy i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Hərwi niye neŋ faya na gwaɗumeye sa: Kə ge ka rəhumay ha gər a bazlam i Musa mapala eye a ze i ndo neheye tə dzaŋgawa bazlam i Mbəlom mapala eye ta Farisa hay bay aye na, ka deyumeye a Bəy i Mbəlom bay.» ");
INSERT INTO meq_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yesu a gwaɗatay sa: «Nəkurom na, ka tsənum wu nakə tə tsikatay a bəba təte kurom hay aye. Tə gwaɗatay na: “Kâ kəɗ gər i ndo bay. Ndoweye kə kəɗ gər i ndo na, ta diye ha kame i sariya.” ");
INSERT INTO meq_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ane tuk na, neŋ faya na gwaɗakumeye: Taɗə ndoweye kə ge mevel ka malamar ŋgay na, ɗa ta diye ha kame i ndo məge sariya. Taɗə ndoweye kə gwaɗay a malamar ŋgay: “Nəkar matərakahaŋ eye” na, ɗa ta diye ha kame i ndo mələve dala hay, ta geye sariya. Ada taɗə ndoweye kə gwaɗay a malamar ŋgay: “Nəkar ka dze” na, ta kaliye ha a ako nakə ɗaɗa ma mbatiye bay aye. ");
INSERT INTO meq_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«Agəla a saka mələtse məvəle wu a Mbəlom, a həlay niye wetete a makaw a gər zəgəle andaya ka bo ta malamar yak na, ");
INSERT INTO meq_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","gər ha wu yak niye kame i təv məvəlay wu a Mbəlom. Do, ta pəsum ha a bo təday, zay mâ ge mə walaŋ kurom ada maw, vəlay wu a Mbəlom tuk. ");
INSERT INTO meq_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Taɗə ka gum a bo wuray ta ndo, nəkurom ka tsəveɗ faya ka deyumeye a sariya na, mum ha ka bo bazlam, sərum bo bəna, mâ ye kar ha kame i ndo məge sariya təday bay. Hərwi ki ye kar ha ka təv i ndo məge sariya hay na, ta vəlay kar ha a həlay i sidzew hay. Ta kaliye kar ha a daŋgay. ");
INSERT INTO meq_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Faya na gwaɗakeye: Sər ha na, kə ge ka hama suloy nakə kutoŋ məheme, ka vəl ha bay na, ka deyeweye abəra ma daŋgay bay.» ");
INSERT INTO meq_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yesu a gwaɗatay sa: «Nəkurom na, ka tsənum, tə gwaɗ: “Kâ ge madama bay.” ");
INSERT INTO meq_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ane tuk na, neŋ faya na gwaɗakumeye: Ndoweye ka zəba ka ŋgwas, kə ge faya ɗəre a say a bor i bo ŋgay na, ɓa kə ge madama mə ɗərev ŋgay ta ŋgwas eye niye tsɨy. ");
INSERT INTO meq_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kə ge ɗəre i həlay i mənday yak ma dəɗiye kar ha a mezeleme na, ŋgwaɗ na ada kâ kal ha dəreŋ abəra tə nəkar. Ŋgama vərezl i bo yak nəte mâ dze tə bəmalə nakə ta kaliye ha bo yak tebiye a ako aye. ");
INSERT INTO meq_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kə ge həlay i mənday yak ma dəɗiye kar ha a mezeleme na, ɗəs na ada kâ kal ha dəreŋ tə nəkar. Ŋgama vərezl i bo yak nəte mâ dze tə bəmalə nakə bo yak tebiye ma diye a ako aye.» ");
INSERT INTO meq_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yesu a gwaɗatay sa: «Ahəl niye, tə gwaɗ sa: “Taɗə ndoweye kə say mahəhar na ŋgwas ŋgay na, kutoŋ mâ watsay ɗerewel i mahəhere a həlay.” ");
INSERT INTO meq_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ane tuk na, neŋ faya na gwaɗumeye: Ndoweye ka həhar na ŋgwas ŋgay kəriye kə ge madama bay na, ki ye a zal na, neŋgeye a təra ha ndo məge madama. Ada ndo nakə a zla ŋgwas nakə ta həhar na aye bəbay kə ge madama.» ");
INSERT INTO meq_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yesu a gwaɗatay sa: «Nəkurom ka tsənum wu nakə tə tsikatay ahəl niye a bəba təte kurom hay aye. Tə gwaɗ: “Kâ mbaɗa tə parasay eye bay. Ane tuk na, wu nakə ka mbaɗa kame i Mbəlom ka gwaɗ ka giye na, ge na.” ");
INSERT INTO meq_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ane tuk na, neŋ faya na gwaɗakumeye: Kâ mbaɗum bay tebiye. Kâ mbaɗum ta mbəlom bay hərwi Mbəlom mandza eye na, mə ɗəma. ");
INSERT INTO meq_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kâ mbaɗum ta dala bay hərwi dala na, təv məpe sik i Mbəlom. Kâ mbaɗum ta Zerozelem bay hərwi Zerozelem na, wuzlahgəma i Bəy bagwar eye. ");
INSERT INTO meq_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kâ mbaɗa tə gər yak bay, hərwi ka sliye faya matəre ha məkwets i gər yak kuɗekuɗek kəgəbay zeŋzeŋ na, ka sliye faya bay. ");
INSERT INTO meq_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kə ge ayaw na, gwaɗum ayaw! Kə ge aʼay na, gwaɗum aʼay ɗekɗek tsa. Wu nakə ta səkah ha faya sa aye na, a yaw abəra mə Fakalaw.» ");
INSERT INTO meq_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yesu a gwaɗatay sa: «Nəkurom na, ka tsənum wu nakə tə tsik ahəl niye aye. Tə gwaɗ: “Taɗə ndoweye ka huyaslay ha ɗəre a ndo na, ta huyaslay ha a ɗəma dərmak, ada ndoweye kə həɓay ha zler a ndo na, ta həɓay ha a ɗəma zler dərmak.” ");
INSERT INTO meq_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ane tuk na, neŋ faya na gwaɗakumeye: Taɗə ndoweye kə gakum seweɗ na, kâ mumay ha a ɗəma bay. Ɗuh taɗə ndoweye kə faka ka maholom i həlay i mənday na, mbəɗay ha maholom i həlay i gula dərmak mâ faka faya. ");
INSERT INTO meq_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Taɗə a say a ndoweye mede kar ha kame i ndo məge sariya hərwi məzle fakaya abəra məkelkabo yak wawa eye na, gəray ha faya kələmedze eye, mâ zla na dərmak. ");
INSERT INTO meq_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Taɗə a say a ndoweye məgaka kutoŋ, a gwaɗaka: “Zleŋ na wu ga anaŋ amba daladal” na, səkahay ha faya zlay na dəreŋ lele. ");
INSERT INTO meq_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ndoweye ka tsətsah fakaya wu na, vəlay. Ndoweye ka tsətsah fakaya gwedere i wu na, kâ kərahay ha bay, vəlay.» ");
INSERT INTO meq_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yesu a gwaɗatay sa: «Ka tsənum wu nakə tə tsik ahəl niye aye, tə gwaɗ: “Wuɗa ndo i məgeɗ yak, nay ɗəre a ndo məne ɗəre yak.” ");
INSERT INTO meq_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ane tuk na, neŋ faya na gwaɗumeye: Wuɗum ndo məne ɗəre kurom hay. Ɗuwulumay me a Mbəlom hərwi ndo neheye faya ta sakumeye ɗəretsətseh aye. ");
INSERT INTO meq_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ka gum andza niye na, ka tərumeye wawa i Bəba kurom Mbəlom neŋgeye mə mbəlom. Hərwi pat ŋgay a dəvatay a ndo i seweɗ hay ada a dəvatay a ndo i ŋgwalak hay. A pa yam ŋgay hərwi ndo neheye mede tay lele aye ada hərwi ndo neheye mede tay lele bay aye dərmak. ");
INSERT INTO meq_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Taɗə agəna ka wuɗum na, ndo neheye ta wuɗa kurom aye ɗekɗek na, magogoy waray nakə Mbəlom ma vəlakumeye? Kwa ndo matsekele dzaŋgal hay tə ge a ze i kurom. ");
INSERT INTO meq_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ada taɗə faya ka tsikumateye me a malamar kurom hay ɗekɗek na, ada wu nakə ka gum a ze ndo hay aye na, wuye mey? Kwa ndo neheye tə sər Mbəlom bay aye na, tə ge a ze i kurom. ");
INSERT INTO meq_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tərum na, ndo ŋgwalak eye hay mə wu hay tebiye andza Bəba kurom mə mbəlom, neŋgeye ŋgwalak eye.» ");
INSERT INTO meq_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesu a gwaɗatay sa: «Gum metsehe! A sakum məge wu nakə bazlam mapala eye a tsətsah fakuma gum aye na, kâ gum kame i ndo hay tebiye bay hərwi ada tâ zəba fakuma bay. Ka gum andza niye bay na, Bəba kurom mə mbəlom ma vəlakumeye magogoy kurom bay. ");
INSERT INTO meq_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«A saka məvəle wu a ndo i mətawak na, kâ vəlay parakka kame i ndo hay bay. Ndo i bəbərek hay tə vəlawa andza niye mə gay i maɗuwule me ada ka mazlazlaŋ i tsəveɗ aye hay. Nəteye ta pəla ndo hay tâ ɗəslatay ha gər. Faya na gwaɗakumeye: Nəteye na, ɓa ta huta magogoy tay tsɨy. ");
INSERT INTO meq_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nəkar na, taɗə ka vəleye wu a ndo i mətawak tə həlay i mənday na, həlay i gula yak mâ sər faya bay. ");
INSERT INTO meq_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Andza niye, wu nakə ka vəliye na, vəl ta məkal. Bəba yak Mbəlom a ŋgatay a wu nakə ka vəl ta məkal aye. Neŋgeye ma vəlakeye magogoy.» ");
INSERT INTO meq_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yesu a gwaɗatay sa: «Ahəl nakə ka ɗuwulumeye me a Mbəlom aye na, kâ gum andza i ndo i bəbərek hay bay. Nəteye na, ta wuɗa maɗuwule me mə gay i maɗuwule me ta mələtse ada ka mazlazlaŋ i tsəveɗ hərwi ada ndo hay tebiye tâ ŋgatatay. Neŋ faya na gwaɗakumeye: Sərum ha, nəteye na, ɓa ta huta magogoy tay tsɨy. ");
INSERT INTO meq_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ane tuk na, nəkar na, ahəl nakə a saka maɗuwulay me a Mbəlom aye, do a gay i məhəne yak. Dərəzl ka bo ada ɗuwulay me a Bəba yak Mbəlom. Kwa nəkar maŋgaha eye abəra ka ndo hay na, neŋgeye andaya tə nəkar ma vəlakeye magogoy yak. ");
INSERT INTO meq_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ahəl nakə faya ka ɗuwulumeye me na, kâ ɗuwulum vəɗvəɗ haladzay andza i ndo neheye tə sər Mbəlom bay aye bay. Tə dzala mə gər tay ta ɗuwulay me a Mbəlom vəɗvəɗ haladzay na, Mbəlom ma tsəniye tay na. ");
INSERT INTO meq_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kâ gum andza nəteye bay, hərwi Mbəlom Bəba kurom ɓa kə sər ha wu nakə a sakum aye kwa ahəl nakə ka tsətsah zuk bay aye.» ");
INSERT INTO meq_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yesu a gwaɗatay sa: «Ka ɗuwulumeye me na, gwaɗum andza nakay: Bəba may nakə mə mbəlom aye, kwa way mâ sər ha, məzele yak na, tsəɗaŋŋa. ");
INSERT INTO meq_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bəy yak mâ yaw a walaŋ may. Wu nakə a saka aye mâ ge ka məndzibəra andza nakə mə mbəlom aye dərmak. ");
INSERT INTO meq_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Vəlamay wu mənday nakə ma slameye bəgom aye. ");
INSERT INTO meq_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pəsamay ha mənese andza nakə nəmay bəbay nəmaa pəsatay ha a ndo neheye tə gamay mənese aye. ");
INSERT INTO meq_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tsəpa may, hərwi ada Fakalaw mâ səpat may bay. Ane tuk na, təmamay ahaya abəra mə həlay i Fakalaw. Hərwi nəkar na, Bəy ka gər i bəy, nəkar gədaŋ ada nəkar məzlaɓ eye ka tor eye. Amen! ");
INSERT INTO meq_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Andza niye, taɗə kə pəsumatay ha mənese a ndo neheye tə gakum mənese aye na, Bəba kurom mə mbəlom ma pəsakumeye ha dərmak. ");
INSERT INTO meq_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ane tuk na, ka pəsumatay ha mənese a ndo neheye tə gakum mənese aye bay na, Bəba kurom Mbəlom ma pəsakumeye ha mənese kurom bay dərmak.» ");
INSERT INTO meq_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yesu a gwaɗatay sa: «Taɗə faya ka gumeye daliyam na, kâ gum andza ndo i bəbərek hay bay. Nəteye na, ta mbəɗawa ha ɗəre tay andza ta mətiye hərwi ada ndo hay tâ zəba fataya nəteye faya ta giye daliyam. Faya na gwaɗumeye: Sərum ha nəteye na, ta huta magogoy tay tsɨy. ");
INSERT INTO meq_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ane tuk na, a saka ka giye daliyam na, bara ɗəre ada faɗa mal ka məkwets i gər yak lele. ");
INSERT INTO meq_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Andza niye, ndo hay ta səriye ha nəkar faya ka giye daliyam bay. Ane tuk na, Bəba yak nakə mandza eye ma təv maŋgaha eye neŋgeye nəte ŋgweŋ a sər ha. Faya ma ŋgateye a wu nakə maŋgaha eye faya ka giye aye. Ada mata vəlaka magogoy yak na, neŋgeye.» ");
INSERT INTO meq_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yesu a gwaɗatay sa: «Kâ hayumay gər a zlele ka məndzibəra bay hərwi mətul hay ta reŋgez ta nasiye ha tebiye. Məkal hay bəbay ta sləliye gay kurom hay ta həliye zlele niye. ");
INSERT INTO meq_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Hayumay gər a zlele kurom na, a mbəlom. Mə ɗəma na, mətul hay ta reŋgez ta nasiye ha bay, məkal hay ta sliye faya mede makəle ahaya bay. ");
INSERT INTO meq_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Hərwi ɗərev yak mandza eye na, ma təv nakə zlele yak mə ɗəma aye.» ");
INSERT INTO meq_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yesu a gwaɗatay sa: «Ɗəre yak na, andza lalam ma dəviye dzaydzay a bo yak tebiye. Taɗə ɗəre yak a zəba kwetseh kwetseh lele na, bo yak kətsek mə dzaydzay. ");
INSERT INTO meq_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ane tuk na, taɗə ɗəre yak lele bay na, bo yak kətsek ma ləvoŋ. Yaw, taɗə dzaydzay mə nəkar kə mbata na, nəkar mandza eye ma ləvoŋ zəŋzəŋ eye.» ");
INSERT INTO meq_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yesu a gwaɗatay sa: «Ndəray ma sliye məge məsler a ndo i gay ŋgay hay sulo bay. Hərwi pat neŋgeɗ na, ma geye seweɗ a ndo ŋgay neŋgeɗ, ma wuɗiye na neŋgeɗ lele. Kəgəbay ma gəseye me a ndo neŋgeɗ, a ndo neŋgeɗ ma gəseye me bay tebiye. Nəkurom bəbay, ka slumeye faya məge məsler a Mbəlom ada a suloy sulo sulo bay.» ");
INSERT INTO meq_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yesu a gwaɗatay sa: «Hərwi niye, neŋ faya na tsikakumeye: Kâ dzalum gər hərwi wu mənday kəgəbay hərwi wu məsay, kəgəbay hərwi petekeɗ bay. Hərwi məsəfəre na, a ze wu mənday ada bo kurom na, a ze petekeɗ segey. ");
INSERT INTO meq_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Zəbum ka ɗiyeŋ hay təday. Ta sləga bay, tə pala wu tay tə hayay gər a wuray a de bay. Ane tuk na, Bəba kurom mə mbəlom faya ma vəlateye wu mənday. Nəkurom na, ka zum tay ha ɗiyeŋ ha haladzay. ");
INSERT INTO meq_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","«Way nakə mə walaŋ kurom ma sliye faya masəkah ha məndze ŋgay ka məndzibəra ta mədzele gər ŋgay nakə faya ma dzaliye aye na, way? ");
INSERT INTO meq_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Faya ka dzalumeye ka petekeɗ na, hərwi mey? Zəbum ka məvurze i guzer hay mə pesl təday. Tə ge məsler bay, tə ŋgar petekeɗ bay. ");
INSERT INTO meq_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Faya na gwaɗakumeye, kwa Salomoŋ nakə zlele eye haladzay aye, ɗaɗa kə pa ka bo petekeɗ andza məvurze i guzer niye hay bay. ");
INSERT INTO meq_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Andza niye Mbəlom na, faya ma pateye ka bo petekeɗ a guzer hay ka bəgom nakay. Tədœ na, guzer niye hay ta kuliye. Ta kula na, ta kaliye tay ha a ako. Kə ge andza niye na, nəkurom ɗuh Mbəlom ma pakumeye petekeɗ ka bo ma ziye i guzer hay bəɗaw? Kwa a nəkurom neheye mədzal gər tsekweŋ aye bəɗaw! ");
INSERT INTO meq_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","«Kâ gwaɗum: Nəmaa ndiye mey? Nəmaa siye mey? Nəmaa piye ka bo mey na, kâ dzalum bay. ");
INSERT INTO meq_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Maa pəla wu neheye na, ndo neheye tə sər Mbəlom bay aye. Ane tuk na, Bəba kurom mə mbəlom a sər wu nakə a sakum aye. ");
INSERT INTO meq_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lahum mapəle na, Bəy i Mbəlom təday ada tə wu nakə a yay a gər a Mbəlom aye. Ma vəlakumeye siye i wu hay tebiye sa. ");
INSERT INTO meq_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","«Kâ dzalum ka wu nakə tədœ aye bay. Tədœ na, ma dzaleye a gər ŋgay. Ka pat məsləlaw na, ɗəretsətseh ŋgay eye ɗa.» ");
INSERT INTO meq_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesu a gwaɗatay sa: «Kâ gumatay sariya a ndo hay bay hərwi ada Mbəlom mâ gakum sariya bay dərmak. ");
INSERT INTO meq_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Hərwi Mbəlom ma gakumeye sariya andza nakə faya ka gumateye a siye i ndo hay aye dərmak. Ma ləvakumeye wu tə wu nakə ka ləvawumatay wu a ndo hay aye. ");
INSERT INTO meq_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nəkar na, ka ŋgatay a tsakwal mə ɗəre i malamar yak. Ane tuk na, mayako nakə mə ɗəre yak aye ka ŋgatay bay na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ma kəkay nakə ka sliye məgwaɗay a malamar yak: “Malamar ga, ehe gər ga ha nâ zlaka ahaya tsakwal abəra mə ɗəre yak”, ada ɗuh mə ɗəre yak eye na, mayako gəlawwa. ");
INSERT INTO meq_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nəkar ndo i bəbərek, lah faya məzle ahaya mayako abəra mə ɗəre yak təday ada ka ŋgateye a ɗəre kwetseh kwetseh. Ka zlaya ahaya tsakwal abəra mə ɗəre i malamar yak tuk. ");
INSERT INTO meq_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Wu nakə tsəɗaŋŋa eye na, kâ vəlumatay a kəra hay bay. Ka vəlumatay na, ta mbəɗiye gər fakuma, ta ŋguraɗiye kurom ha. Wu i maslawa kurom hay na, kâ kutsumatay ha a madəras hay bay bəna ta hatsakumeye faya tə sik.» ");
INSERT INTO meq_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yesu a gwaɗatay sa: «Tsətsahum, ta vəlakumeye, pəlum, ka hutumeye, fumay a məgeɗ, ta həndəkakumeye abəra ma məgeɗ. ");
INSERT INTO meq_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Hərwi kwa way ka tsətsah na, ta vəleye, kwa way ka pəla na, ma hutiye, ada kwa way kə fay a məgeɗ na, ta həndəkeye abəra ma məgeɗ. ");
INSERT INTO meq_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","«Way mə walaŋ kurom taɗə wawa ŋgay a tsətsah faya wu mənday na, ma vəleye kwar ɗaw? ");
INSERT INTO meq_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kəgəbay a tsətsah fakaya kəlef na, ka vəleye dədœ ɗaw? ");
INSERT INTO meq_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nəkurom neheye sadzək ŋgwalak eye hay bay aye ka sərum məvəle wu ŋgwalak eye hay a wawa kurom hay ɗuh tuk na, ada Bəba kurom mə mbəlom ma ziye məvəle wu ŋgwalak eye a ndo neheye ta tsətsah faya aye bəɗaw?» ");
INSERT INTO meq_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yesu a gwaɗatay sa: «Wu nakə a sakum ndo hay tâ gakum aye na, gumatay a siye i ndo hay. Nakay na, wu nakə bazlam i Musa mapala eye ta ɗerewel i ndo məɗe ha bazlam i Mbəlom hay faya ta tətikateye a ndo hay aye.» ");
INSERT INTO meq_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yesu a gwaɗatay sa: «Fələkum ta məgeɗ nakə hala bay aye. Hərwi məgeɗ nakə zlabatam eye ada tsəveɗ nakə a wur bo mede tə ɗəma bay aye na, tsəveɗ mede ha ndo a mədze. Ndo neheye faya ta diye tə ɗəma aye na, nəteye haladzay. ");
INSERT INTO meq_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ane tuk na, məgeɗ nakə hala bay aye na, ma diye ha ndo a sifa. Tsəveɗ mede tə ɗəma na, a wur bo haladzay. Ndo neheye faya ta diye tə ɗəma aye na, nəteye haladzay bay.» ");
INSERT INTO meq_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yesu a gwaɗatay sa: «Gum metsehe ta ndo neheye tə gwaɗ nəteye ndo məɗe ha bazlam i Mbəlom aye. Ta deyeweye a walaŋ kurom andza təɓaŋ hay. Azlakwa bay mə huɗ i bo tay na, nəteye andza kəra i pesl neheye tereŋgez eye haladzay aye. ");
INSERT INTO meq_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ka sərumeye tay ha ka bo abəra na, ta məsler tay nakə faya ta giye aye. Ka slumeye faya maŋgəle hohway i werepezl abəra ka dərizl i gərɗaf i dak ɗaw? Ada ka slumeye faya maŋgəle hohway i gurov abəra ka dərizl i gərɗaf i tsetsiv ɗaw? ");
INSERT INTO meq_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Andza niye, dərizl i gərɗaf nakə ŋgwalak eye na, ma wiye hohway ŋgwalak eye hay. Ane tuk na, dərizl i gərɗaf ɗəvats eye na, ma wiye hohway ŋgwalak eye bay dərmak. ");
INSERT INTO meq_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Dərizl i gərɗaf ŋgwalak eye na, ma wiye hohway i dərizl i gərɗaf ɗəvats eye bay, ada dərizl i gərɗaf ɗəvats eye na, ma wiye hohway i dərizl i gərɗaf ŋgwalak eye bay. ");
INSERT INTO meq_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Dərizl i gərɗaf nakə ma wiye hohway ŋgwalak eye bay aye na, ta ɗəsiye na ada ta kutsiye ha a ako. ");
INSERT INTO meq_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Andza niye, ka sərumeye ha ka bo abəra ndo məɗe ha bazlam i Mbəlom ta parasay eye na, ta məsler tay nakə faya ta giye aye.» ");
INSERT INTO meq_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yesu a gwaɗatay sa: «Sərum ha, ndo neheye faya ta tsikeŋeye: “Bəy Maduweŋ, Bəy Maduweŋ” tə bazlam aye na, ta diye tebiye a Bəy i Mbəlom bay. Mata de na, ndo neheye faya ta giye wu nakə a say a Bəba ga mə mbəlom aye. ");
INSERT INTO meq_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ahəl nakə aza na deyeweye məgatay sariya a ndo hay aye na, ndo hay haladzay ta gweɗeŋeye: “Bəy Maduweŋ, Bəy Maduweŋ, nəmaa ɗa ha bazlam i Mbəlom ta məzele yak, nəmaa həhar fakalaw abəra ka ndo hay ta məzele yak, nəmaa ge masuwayaŋ hay haladzay ta məzele yak bəɗaw?” ");
INSERT INTO meq_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yaw, na tsikateye parakka: “Ɗaɗa na sər kurom ha bay, nəkurom neheye ka gawum mənese aye, dum abəra ka təv ga.”» ");
INSERT INTO meq_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesu a gwaɗatay sa: «Andza niye, kwa way kə tsəne bazlam neheye ada ka rəhay ha gər na, neŋgeye a ndzəkit bo ndo nakə a tsah, a ɗəzl gay ŋgay ka pəlaɗ aye. ");
INSERT INTO meq_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yam a pa, mazaw a rah a magayam, mətasl a vəzl ta gədaŋ ada mazaw ta mətasl ti yaw ta gədaŋ ka gay niye. Ane tuk na, ka mbəzl bay hərwi mədok eye mapa eye lele ka pəlaɗ. ");
INSERT INTO meq_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ane tuk na, kwa way kə tsəne bazlam, ada ka rəhay ha gər bay na, neŋgeye a ndzəkit bo ndo i matərakahaŋ nakə a ɗəzl gay ŋgay ka hewiyeŋ aye. ");
INSERT INTO meq_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Yam a pa, mazaw a rah a magayam, mətasl a vəzl ta gədaŋ ada ti yaw ka gay niye ta gədaŋ. Gay niye a mbəzl hele hele.» ");
INSERT INTO meq_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ahəl nakə Yesu a ndəv ha mətsike me ŋgay aye na, matətike ŋgay niye a gatay hərɓaɓəkka a ndo neheye ka təv ŋgay aye tebiye. ");
INSERT INTO meq_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Hərwi neŋgeye na, a tsikatay andza i ndo neheye tə dzaŋgawa bazlam i Mbəlom mapala eye bay, neŋgeye a tsik ta məzlaɓ i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ahəl nakə Yesu a mbəzlaw abəra mə mahəmba aye na, ndo hay haladzay tə pay bəzay. ");
INSERT INTO meq_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ahəl nakə faya ta diye na, ndo wuray madəgwaɗa eye a həndzəɗ naha ka təv ŋgay, a dəkway gurmets a huvo, a gwaɗay: «Ŋgalaka, taɗə kə saka na, ka sliye faya matəre ga ha tsəɗaŋŋa.» ");
INSERT INTO meq_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu a nduɗa ha həlay ŋgay, a lamay. Tsa na, a gwaɗay: «A seŋ na, təra tsəɗaŋŋa!» Kwayaŋŋa ndo madəgwaɗa eye niye a təra tsəɗaŋŋa. ");
INSERT INTO meq_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tsa na, Yesu a gwaɗay: «Tsəne lele: Kâ tsik wu nakay a ndəray bay. Ane tuk na, do ta bəzay ha bo a ndo məvəlaway wu a Mbəlom ada vəl wu nakə Musa a tsik aye hərwi məɗatay ha a ndo hay tebiye na, ka təra tsəɗaŋŋa.» ");
INSERT INTO meq_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu a ndisl a Kafernahum. Bagwar i sidzew i Roma hay a həndzəɗ naha ka təv ŋgay, a tsətsah faya madzəne, ");
INSERT INTO meq_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","a gwaɗay: «Bəy Maduweŋ, ndo i məsler ga mahəna eye mətagay. Neŋgeye ɗəvats eye, ka təra, a wur faya haladzay.» ");
INSERT INTO meq_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu a mbəɗay faya, a gwaɗay: «Na diye na mbəliye ha.» ");
INSERT INTO meq_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Bagwar i sidzew niye a gwaɗay: «Bəy Maduweŋ, neŋ na sla ɗa nəkar kâ ye a gay ga bay. Ane tuk na, ka tsik bazlam yak nəte na, ndo i məsler ga ma mbəliye. ");
INSERT INTO meq_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Neŋ na, faya na rəhay ha gər a bagwar ga ada sidzew ga hay ta rəheŋ ha gər dərmak. Na gwaɗay a ndo nəte mə walaŋ tay “Do!” na, ma diye. Na gwaɗay a ndo neŋgeɗ “Dara!” na, ma deyeweye. Na gwaɗay a beke ga “Ge nakay!” na, ma giye.» ");
INSERT INTO meq_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu a tsəne bazlam ŋgay neheye na, a yay a gər haladzay, a gwaɗatay a ndo neheye faya ta pay bəzay aye: «Neŋ faya na tsikakumeye, sərum ha, ɗaɗa na ndzay a gər a ndo ta mədzal gər eye haladzay andza nakay ma slala i Israyel hay bay. ");
INSERT INTO meq_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Sərum ha na, ndo hay haladzay ta deyeweye abəra mə bəzay i mbəlom ada abəra ma məgəma, ta ndiye ka bo wu mənday ta Abraham, ta Izak ada ta Zakob ma Bəy i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ane tuk na, ndo neheye haɓe ta diye a Bəy i Mbəlom aye na, ta kutsiye tay ha abəra, a ləvoŋ. Mə ɗəma na, ta tuwiye tə mahəpəɗe zler eye.» ");
INSERT INTO meq_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tsa na, Yesu a gwaɗay a bagwar i sidzew niye: «Do wu yak a mətagay. Hərwi wu nakə ka dzala ha aye na, ma giye bo.» A həlay niye, kwayaŋŋa ndo i məsler i sidzew niye a mbəl. ");
INSERT INTO meq_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ma dəba eye na, Yesu a ye a gay i Piyer. A ye naha a ndzay a gər a mese i Piyer ŋgwas eye mahəna eye, maraɓaraɓ a gay. ");
INSERT INTO meq_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu a ye ka təv ŋgay, a ye naha a lamay həlay. Tsa na, maraɓaraɓ a ndala faya abəra, a lətse, a gay mbəlok a Yesu. ");
INSERT INTO meq_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Huwa a ge na, tə həlaw ndo neheye fakalaw mə bo tay aye a Yesu. A həhar fataya abəra fakalaw niye hay tə bazlam ŋgay. A mbəl tay ha ndo i ɗəvats hay tebiye dərmak. ");
INSERT INTO meq_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Andza niye, Yesu a ge na, wu nakə Ezay ndo məɗe ha bazlam i Mbəlom a tsik ahəl niye, a gwaɗ: «Kə zla fakwaya abəra bəle kway, ada kə zla fakwaya abəra ɗəvats kway hay.» ");
INSERT INTO meq_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu a zəba faya ndo hay haladzay ka təv ŋgay na, a gwaɗatay a gawla ŋgay hay: «Takwa ka me i dəlov, a diye neŋgeɗ.» ");
INSERT INTO meq_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tə həl bo, ta diye na, ndo mədzaŋgawa bazlam i Mbəlom mapala eye a həndzəɗ naha ka təv ŋgay, a gwaɗay: «Miter, kwa a ŋgay ka diye na, na pakeye bəzay.» ");
INSERT INTO meq_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu a mbəɗay faya: «Mezerew hay na, bəɗ tay andaya hərwi məhəne mə ɗəma, ɗiyeŋ hay dərmak gay tay andaya. Ane tuk na, neŋ Wawa i Ndo na, təv ga andaya nakə na həniye mə ɗəma hərwi mazəzukwe bo aye bay.» ");
INSERT INTO meq_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ndo nəte mə walaŋ i gawla i Yesu hay a gwaɗay: «Bəy Maduweŋ, vəleŋ tsəveɗ nâ ye, nâ la na bəba ga təday.» ");
INSERT INTO meq_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu a mbəɗay faya: «Peŋ bəzay, gər ha mədahaŋ hay tâ la bo tay.» ");
INSERT INTO meq_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu a tsal a kwalalaŋ i yam na, gawla ŋgay hay tə pay bəzay. ");
INSERT INTO meq_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ahəl nakə faya ta diye, tə husa a wuzlah i dəlov aye na, kwayaŋŋa mətasl bagwar eye a ge haladzay. Yam a tsal ka bo ɗaŋgwala haladzay. Kə sər mede ha kwalalaŋ i yam a huɗ i yam. Ane tuk na, Yesu na, neŋgeye mandzahəra eye. ");
INSERT INTO meq_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Gawla ŋgay hay ta həndzəɗ naha ka təv ŋgay, ta pəɗeke ha, tə gwaɗay: «Bəy Maduweŋ, təma may ha tey? Nəkway faya ka dzakweye.» ");
INSERT INTO meq_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tsa na, Yesu a gwaɗatay: «Ka dzədzarum andza niye na, hərwi mey? Nəkurom na, məpe mədzal gər a kətsakum.» A lətse, a gay me a mətasl ta yam. Tsa na, tə ndza ɗeɗik. ");
INSERT INTO meq_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","A gatay hərɓaɓəkka a ndo hay tebiye, tə gwaɗ: «Nakay na, ndo waray nakə mətasl ta yam tə gəsay me aye na, way?» ");
INSERT INTO meq_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ahəl nakə Yesu a ye a diye i dəlov neŋgeɗ, ka dala i Gadara hay na, ndo hay sulo tə ndohwaw abəra mə walaŋ i tsəvay hay. Ti yaw mədzəgər tə Yesu. Ndo neheye sulo eye fakalaw mə bo tay aye, nəteye seweɗ eye hay haladzay. Ndəray a sla mede ta tsəveɗ eye niye bay. ");
INSERT INTO meq_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ta wuda, tə gwaɗ: «A nəkar Wawa i Mbəlom, a saka ka nəmay na, mey? Ka yaw məgamay ɗəretsətseh na, həlay eye kə ndislew zuk ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ka təv eye niye dəreŋ tsəfa ta nəteye na, madəras hay andaya haladzay faya ta ndiye wu mənday. ");
INSERT INTO meq_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Fakalaw niye hay tə gay amboh a Yesu, tə gwaɗay: «Taɗə a saka mahəhere may na, slər may ha a bo i madəras taɗay eheye.» ");
INSERT INTO meq_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tsa na, Yesu a gwaɗatay: «Dum!» Tsa na, tə yaw abəra mə bo i ndo neheye sulo aye, ti ye tə fələkwa a bo i madəras niye hay. Kwayaŋŋa madəras niye hay tebiye tə mbəzlaw abəra ma təv eye andaya sərpalahha, tə kuts a dəlov tebiye, tə dze a ɗəma. ");
INSERT INTO meq_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ndo neheye faya ta tsəkuriye madəras niye hay aye ta hway, ti ye a wuzlahgəma. Ti ye naha ta təkəratay wu nakə a ge bo aye ada wu nakə a ge bo ta ndo neheye sulo aye. ");
INSERT INTO meq_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tsa na, ndo neheye mə wuzlahgəma aye ti yaw mata dzəgər tə Yesu. Ti yaw, tə ŋgatay a Yesu na, tə gay amboh haladzay, tə gwaɗay: «Do abəra ka dala may.» ");
INSERT INTO meq_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ma dəba eye na, Yesu a tsal a kwalalaŋ i yam, a tasaw abəra ma dəlov niye, a ye a gəma ŋgay. ");
INSERT INTO meq_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ndo hay tə zlay naha ndo wuray matəra eye mahəna eye ka sləlah. Yesu a zəba ka mədzal gər i ndo niye hay na, a gwaɗay a ndo niye matəra eye: «Wawa ga, ɗərev mâ ye fakaya abəra bay. Na pəsaka ha mezeleme yak hay.» ");
INSERT INTO meq_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Siye i ndo mədzaŋgawa bazlam i Mbəlom mapala eye tə dzala mə gər tay, tə gwaɗ: «Ndo nakay na, kə tsalay ka gər a Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu a səratay naha ka wu nakə tə dzala mə gər tay aye, a gwaɗatay: «Ka dzalum mədzal gər nakə ŋgwalak eye bay aye na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Maa da me məgweɗe: “Mezeleme yak kə pəsa” na, waray, kəgəbay “Lətse, do” na, maa da me mə ɗəma na, waray? ");
INSERT INTO meq_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","A seŋ na, sərum ha neŋ Wawa i Ndo na, gədaŋ ga andaya məpəsatay ha mezeleme a ndo hay ka məndzibəra.» Tsa na, Yesu a gwaɗay a ndo niye matəra eye: «Lətse, zla sləlah yak, do a mətagay.» ");
INSERT INTO meq_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ndo niye a lətse, a ye a mətagay. ");
INSERT INTO meq_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ndo hay tə ŋgatay andza niye na, ta dzədzar haladzay. Tə ɗəslay ha gər a Mbəlom, tə gwaɗ: «Zambaɗakway a Mbəlom hərwi kə vəlatay gədaŋ a ndo hay haladzay.» ");
INSERT INTO meq_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu a lətse, a ye abəra ma təv niye. Neŋgeye faya ma diye na, a ŋgatay ndo wuray məzele ŋgay Mata, mandza eye mə gay i matsekele dzaŋgal. Yesu a gwaɗay: «Dara, peŋ bəzay!» Mata a lətse a pay bəzay a Yesu. ");
INSERT INTO meq_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ahəl nakə Yesu faya ta ndiye wu mənday ta gawla ŋgay hay mə gay i Mata aye na, siye i ndo matsekele dzaŋgal hay ta ndo i mezeleme hay ti yaw faya tə ndiye ka bo wu mənday dziye. ");
INSERT INTO meq_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisa hay tə ŋgatay andza niye na, ta tsətsah ka gawla i Yesu hay, tə gwaɗatay: «Miter kurom faya ta ndiye wu ka bo dziye ta ndo matsekele dzaŋgal hay ada ta ndo i mezeleme hay na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu a tsəne bazlam tay niye na, a gwaɗ: «Ndo neheye wuray a gatay bay nəteye zayzay aye na, ta pəliye ndo i sidem bay. Mata pəle ndo i sidem na, ndo neheye ɗəvats eye hay aye. ");
INSERT INTO meq_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Dum, bazlam nakay a say məgweɗe mey na, tətikum. Mbəlom a gwaɗ: “A seŋ na, gumay ŋgwalak a ndo bəna gənaw neheye ka kəɗumeŋeye bay.” Na yaw məzalatay a ndo neheye tə gwaɗay a gər tay nəteye ŋgwalak eye hay aye bay, ane tuk na, məzalatay a ndo i mezeleme hay ɗuh.» ");
INSERT INTO meq_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ma dəba eye na, gawla i Yuhana madzəhuɓe ndo a yam hay ti ye ka təv i Yesu, ti ye naha, ta tsətsah faya, tə gwaɗay: «Nəmay ta Farisa hay na, nəmay faya nəmaa giye daliyam, gawla yak hay tə ge daliyam təbey na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu a mbəɗatay faya, a gwaɗatay: «Nəteye na, ta giye daliyam bay, hərwi nəteye na, andza mə magurlom i məzle dahəlay. Ahəl nakə zal i dahəlay ka təv tay mba aye na, ndo neheye mazala eye a magurlom i məzle dahəlay aye na, ta sliye faya mətuwe bay. Ane tuk na, pat eye ma slaweye ta gəsiye fataya abəra zal i dahəlay niye. Pat eye niye na, ta giye daliyam tuk. ");
INSERT INTO meq_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Andza niye, ndəray ma nasiye ha petekeɗ weɗeye mətepe ka petekeɗ guram eye bay. Hərwi ahəl nakə ta bariye na aye na, petekeɗ weɗeye ma ŋgərɗiye ha petekeɗ guram eye, petekeɗ guram eye ma səkahiye maŋgureɗe ma ziye nakə kurre aye. ");
INSERT INTO meq_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Sa na, ndo ma mbəɗiye guzom lelem eye a gwezem i həzlay guram eye bay na, ka sərum təbəɗew? Hərwi ta mbəɗa a ɗəma na, guzom niye lelem eye kə kwasa na, həzlay niye guram eye ma ndohwiye. Guzom dərmak səktih ma mbəɗiye ka dala ada gwezem ma nasiye. Ane tuk na, guzom lelem eye ta mbəɗiye na, a gwezem i həzlay weɗeye dərmak.» ");
INSERT INTO meq_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ahəl nakə Yesu faya ma tsikateye andza niye na, bəy wuray a yaw ka təv i Yesu, a dəkway gurmets, a gwaɗay: «Dem ga kə mət. Ane tuk na, dara pa faya həlay yak, tsa na, ma mbəliye.» ");
INSERT INTO meq_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu a lətse ta gawla ŋgay hay, tə pay bəzay a bəy niye. ");
INSERT INTO meq_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ŋgwas wuray andaya ɗəvats eye, bambaz a mbəɗawayaw abəra mə huɗ. Ɗəvats niye kə ndza faya məve kuro gər eye sulo. A həndzəɗ naha ka Yesu ta dəba, a lamay a me i petekeɗ ŋgay nets. ");
INSERT INTO meq_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Andza niye, a dzala mə gər ŋgay, a gwaɗ: «Na lamay a petekeɗ ŋgay nets na, na mbəliye.» ");
INSERT INTO meq_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tsa na, Yesu a mbəɗa me a dəba, a ŋgatay, a gwaɗay: «Tete dem ga! Mədzal gər yak kə mbəl kar ha.» Kwayaŋŋa ŋgwas niye a mbəl. ");
INSERT INTO meq_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu a ndisl a gay i bəy niye tuk. A ye naha a ŋgatay a ndo məfe fagam hay ta ndo hay haladzay faya ta tuwiye. ");
INSERT INTO meq_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tsa na, a gwaɗatay: «Dum abəra kanaŋ! Dem nakay kə mət bay, neŋgeye mandzahəra eye.» Ane tuk na, ndo hay tə tsəne andza niye na, wuyi tə ŋgwasa faya. ");
INSERT INTO meq_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ta həharatay ahaya ndo hay abəra na, Yesu a fələkwa a gay. A ye naha a gəs dem niye mə həlay, dem niye a lətse. ");
INSERT INTO meq_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Labara eye a ɗa a zləm ma gəma niye tebiye. ");
INSERT INTO meq_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","A həlay nakə Yesu faya ma diye abəra ka təv niye na, guluf hay sulo tə pay bəzay tə mawude eye, tə gwaɗay: «Yesu, Wawa i Davit, nəmaâ gaka mə bo təbəɗew!» ");
INSERT INTO meq_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu a ndisl a gay ŋgay, a fələkwa a ɗəma na, guluf niye hay ta həndzəɗ naha ka təv ŋgay. Yesu, a tsətsah fataya, a gwaɗatay: «Ka dzalum na, na sliye məmbəle kurom ha ɗaw?» Ta mbəɗay faya, tə gwaɗay: «Ayaw, Bəy Maduweŋ.» ");
INSERT INTO meq_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yesu a lamay a ɗəre tay, a gwaɗatay: «Mbəlom mâ vəlakum andza nakə faya ka həbumeye ta mədzal gər kurom nakə ka pum faya aye.» ");
INSERT INTO meq_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tsa na, ɗəre tay a həndək. Yesu a gatay me, a gwaɗatay: «Tsənum lele, ndəray mâ sər ha wu nakay bay.» ");
INSERT INTO meq_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ane tuk na, ti ye tə ɗa ha labara i Yesu ma gəma niye tebiye. ");
INSERT INTO meq_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","A həlay nakə ndo neheye sulo, ɗəre tay a həndək ti ye abəra mə ɗəma na, tə zlaw ndo wuray a Yesu. Ndo niye madəda eye hərwi fakalaw mə bo ŋgay. ");
INSERT INTO meq_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu a həhar faya abəra məsəfəre niye ŋgwalak eye bay aye. Tsa na, a tsik me wulaŋaŋa lele. A gatay a ndo niye hay wadəŋ wadəŋ. Tə gwaɗ: «Ɗaɗa ndo kə ŋgatay a slala i wu nakay nəte ma Israyel bay!» ");
INSERT INTO meq_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ane tuk na, Farisa hay tə ŋgatay andza niye na, tə gwaɗ: «Maa vəlay gədaŋ ka mahəhere fakalaw hay na, bəy i fakalaw hay!» ");
INSERT INTO meq_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu a həhalawa ma wuzlahgəma hay ta gəma hay. A tətikawa tay a ndo hay mə gay i maɗuwule me hay, a ɗawa ha Labara Ŋgwalak eye i Bəy i Mbəlom, a mbəlawa tay ha ndo i ɗəvats hay tebiye ada ndo matəra eye hay tebiye. ");
INSERT INTO meq_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesu a zəba ka ndo neheye haladzay aye na, tə gay mə bo haladzay, hərwi mədzal gər tay makwasa eye ada ta ge bəle. Nəteye andza təɓaŋ neheye ndo mətsəkure tay andaya bay aye. ");
INSERT INTO meq_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","A gwaɗatay a gawla ŋgay hay: «Wu mənday andaya haladzay məpele ka dala. Ane tuk ndo məpele na abəra ka dala na, nəteye haladzay bay. ");
INSERT INTO meq_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Hərwi niye, gumay amboh a ndo i guvah mâ səkah ha ndo i məsler hay hərwi məpele wu mənday abəra ka dala.» ");
INSERT INTO meq_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu a zalatay a gawla ŋgay hay kuro gər eye sulo. A vəlatay gədaŋ ka mahəhere məsəfəre neheye ŋgwalak eye bay aye abəra ka ndo hay, ada məmbəle tay ha ndo i ɗəvats hay ta ndo neheye matəra eye aye. ");
INSERT INTO meq_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Məzele i ndo i maslaŋ ŋgay neheye kuro gər eye sulo aye na, anaŋ: Təday Simoŋ nakə tə zalay Piyer aye ta malamar ŋgay Aŋdəre, Yakuba ta malamar ŋgay Yuhana, nəteye sulo tay eye wawa i Dzebede, ");
INSERT INTO meq_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip ta Bartelemi, Tomas ta Mata, neŋgeye ndo matsekele dzaŋgal, Yakuba wawa i Alfe, Tade, ");
INSERT INTO meq_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoŋ ndo məge vəram hərwi dala ŋgay, Yudas Iskariyot ndo məge ɗaf ka Yesu. ");
INSERT INTO meq_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu a slər ndo i maslaŋ ŋgay neheye kuro gər eye sulo aye, a tsikatay gər i bazlam hay, a gwaɗatay: «Kâ yum a gay i ndo neheye nəteye Yahuda bay aye bay, kâ fələkum a gəma i Samari hay bay. ");
INSERT INTO meq_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Dum ɗuh na, ka təv i Israyel hay, hərwi nəteye andza təɓaŋ madza eye hay. ");
INSERT INTO meq_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ka deyumeye ka tsəveɗ na, ɗumatay ha, gwaɗumatay: “Bəy i Mbəlom ka həndzəɗaw mazlambar tə nəkurom.” ");
INSERT INTO meq_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mbəlum tay ha ndo i ɗəvats hay, mbəlum tay ha mədahaŋ hay, mbəlum tay ha ndo madəgwaɗa eye hay, həharum fakalaw abəra mə bo i ndo hay. Ka hutum gədaŋ neheye na, kəriye, nəkurom dərmak vəlumatay a ndo hay kəriye. ");
INSERT INTO meq_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ka deyumeye na, kâ zlum gura bay, kâ həlum suloy bay, kwa kwar i suloy kâ həlum a gwezem kurom hay bay. ");
INSERT INTO meq_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kâ zlum gwezem i mahəhele kurom hay bay, kâ həlum petekeɗ i məkelkabo kurom hay sulo sulo bay, kâ həlum tahərak bay, kwa sakwal kâ zlum bay. Andza niye ndo məge məsler na, kutoŋ ma hutiye wu mənday ŋgay.» ");
INSERT INTO meq_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yesu a gwaɗatay sa: «Ka ndislum a wuzlah gay kəgəbay a gəma na, pəlum ndo nakə neŋgeye maləva bo eye ka matəme kurom aye. Ndzum mə gay i ndo niye hus a pat nakə ka deyumeye kurom abəra ma təv niye aye. ");
INSERT INTO meq_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ahəl nakə faya ka fələkumeye a gay i ndo na, gwaɗum: “Mbəlom mâ vəlakum zay!” ");
INSERT INTO meq_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Taɗə ndo i gay niye hay ta təma kurom na, məpəse me i zay kurom ma ndziye fataya. Ane tuk na, taɗə ta təma kurom bay na, muma ahaya fataya abəra məpəse me i zay kurom. ");
INSERT INTO meq_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Taɗə ka fələkum a gay i ndo kəgəbay a wuzlah gay, ndo neheye mə ɗəma aye ta kərah matəme kurom kəgəbay məpe zləm ka bazlam kurom na, dum kurom abəra ma təv niye ada tətəkum ha bətekwew i gəma tay abəra ka sik kurom hay. ");
INSERT INTO meq_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Neŋ faya na gwaɗakumeye: Sərum ha pat i sariya i Mbəlom na, sariya tay ma diye me ma ziye i ndo i Sodom ta Gomora.» ");
INSERT INTO meq_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesu a gwaɗatay: «Anaŋ, na sləriye kurom hay andza təɓaŋ hay a walaŋ i ndo neheye andza kəra i pesl hay aye. Tərum andza dədœ neheye faya ta tsəpiye bo tay aye, ada ndzum mənese mâ ge andaya fakuma bay andza bodobodo. ");
INSERT INTO meq_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Gum metsehe, hərwi ndo hay ta diye kurom hay kame i sariya, ta ndaɓiye kurom ta mandalaɓa mə gay i maɗuwule me hay. ");
INSERT INTO meq_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ta diye kurom ha kame i ndo mələve dala hay ada kame i bəy hay hərwi ga, hərwi ada kâ slum faya məte mbal ga ta deɗek kame tay ada kame i ndo neheye Yahuda hay bay aye. ");
INSERT INTO meq_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ahəl nakə faya ta diye kurom ha kame i sariya aye na, ɗərev mâ ye fakuma abəra bay. Kâ gwaɗum: “Nəmaa ta gwaɗiye kəkay? Nəmaa tsikiye na, mey?” bay. A həlay niye, Mbəlom ma vəlakumeye bazlam neheye ka tsikumeye aye. ");
INSERT INTO meq_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Andza niye mata tsike me na, nəkurom bay. Mata tsike me mə nəkurom na, Məsəfəre i Bəba kurom Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Yesu a gwaɗatay sa: «Ndo hay ta vəliye ha malamar tay hay ada tâ kəɗ tay ha, bəba hay ta giye ta wawa tay hay andza niye dərmak. Wawa hay ta natay ɗəre a bəba tay hay, ta kəɗiye tay ha. ");
INSERT INTO meq_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ndo hay tebiye ta nakumeye ɗəre hərwi ga. Ane tuk na, ndo nakə kə səmay naha hus ka mandəve aye na, Mbəlom ma təmiye ha. ");
INSERT INTO meq_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Taɗə agəna ta sakum ɗəretsətseh ma gəma nakə nəkurom mə ɗəma aye na, hwayum a gəma neŋgeɗ. Neŋ faya na gwaɗakumeye: Sərum ha, neŋ Wawa i Ndo na maweye na, ka dzum ha gər mahəhele ma gəma neheye ka dala i Israyel aye tebiye zuk bay.» ");
INSERT INTO meq_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yesu a gwaɗatay: «Ndo nakə faya ma tətikiye wu aye na, ma ziye ndo matətikay wu bay. Ndo i məsler ma ziye ndo i gay ŋgay bay. ");
INSERT INTO meq_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Taɗə ndo nakə faya ta tətikiye wu aye ka təra andza ndo matətikay wu ada ndo i məsler ka təra andza ndo i gay ŋgay na, niye na, ɗa. Taɗə ta zalay a ndo i gay “Bedzabul” na, ta tsaɗateye a ndo i ŋgay hay ma ziye i ŋgay bəɗaw?» ");
INSERT INTO meq_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Hərwi niye, kâ dzədzarumatay a ndo hay bay. Wu nakə tebiye maŋgaha eye na, ta ɗiye ha, ada wu nakə tə tsikawa ta məkal aye na, ta ɗiye ha. ");
INSERT INTO meq_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Wu nakə faya na tsikakumeye ma ləvoŋ aye na, masumay a mətsike parakka mə dzaydzay ta həpat. Wu nakə ta tsikakumeye ka zləm tə məsəsəkwe aye na, wudum ha kələrra ka gər i gay. ");
INSERT INTO meq_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kâ dzədzarumatay a ndo neheye ta kəɗiye slo i bo kurom aye bay. Nəteye na, ta sliye faya mədze ha məsəfəre kurom bay. Dzədzarumay ɗuh a Mbəlom nakə ma sliye mədze ha bo kurom ta məsəfəre kurom eye dzay a ako nakə ma mbatiye bay ka tor eye aye. ");
INSERT INTO meq_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Sisi hay sulo ta səkəmiye tə dala nəte na, ka sərum təbəɗew? Ane tuk na, kwa nəte mə walaŋ i ɗiyeŋ hay ma dəɗiye bay, say kə yay a gər a Bəba Mbəlom mâ dəɗ. ");
INSERT INTO meq_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","I kurom na, kwa məkwets i gər kurom bəbay, Mbəlom kə pasla na. ");
INSERT INTO meq_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Hərwi niye, kâ dzədzarum bay, nəkurom ka zum tay ha sisi niye hay.» ");
INSERT INTO meq_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yesu a gwaɗatay sa: «Taɗə ndoweye kə tsik parakka kame i ndo hay: “Neŋ gawla i Yesu” na, neŋ dərmak na tsikiye kame i Bəba ga mə mbəlom: “Ndo nakay na, gawla ga.” ");
INSERT INTO meq_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ane tuk na, taɗə ndoweye kə tsik kame i ndo hay neŋgeye gawla ga bay na, neŋ dərmak na tsikiye kame i Bəba ga mə mbəlom: “Ndo nakay na, gawla ga bay.”» ");
INSERT INTO meq_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Kâ dzalum neŋ na yaw, nâ zlaw zay ka məndzibəra na, kâ dzalum bay. Na yaw na, na zlaw zay bay, na zlaw na, maslalam ɗuh. ");
INSERT INTO meq_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Na yaw na, maŋgəne tay ha ka bo abəra ndo hay. Wawa hasləka eye ta bəba ŋgay, dem ta may ŋgay, ŋgwas ta may i zal ŋgay, ");
INSERT INTO meq_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ndo hay mə gay tay ta niye a bo ɗəre.» ");
INSERT INTO meq_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Yesu a gwaɗatay sa: «Ndoweye ka wuɗa bəba ŋgay ta may ŋgay ka ze neŋ na, neŋgeye ma sliye məndze ka təv ga bay. Ndoweye ka wuɗa wawa ŋgay hasləka eye tə dem ŋgay a ze neŋ na, neŋgeye ma sliye məndze ka təv ga bay. ");
INSERT INTO meq_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ndoweye kə zla mayako mazləlmbaɗa eye kə peŋ bəzay bay na, neŋgeye ma sliye məndze ka təv ga bay. ");
INSERT INTO meq_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ndo nakə a say mətəme ha məsəfəre ŋgay aye na, ma dziye ha ɗuh. Ane tuk na, ndo nakə ma dziye ha məsəfəre ŋgay hərwi ga aye na, ma hutiye a ɗəma ɗuh.» ");
INSERT INTO meq_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yesu a gwaɗatay sa: «Taɗə ndoweye ka təma kurom na, ka təma na, neŋ. Ada taɗə ndoweye ka təma ga na, a təma ndo nakə a sləra ga ahaya aye. ");
INSERT INTO meq_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ndoweye ka təma ndo məɗe ha bazlam i Mbəlom hərwi nakə neŋgeye ndo məɗe ha bazlam i Mbəlom aye na, ma hutiye magogoy nakə ta vəleye a ndo məɗe ha bazlam aye. Ndoweye ka təma ndo nakə ŋgwalak eye kame i Mbəlom aye hərwi nakə neŋgeye ŋgwalak eye kame i Mbəlom aye na, ma hutiye magogoy nakə ta vəleye a ndo nakə ŋgwalak eye kame i Mbəlom aye. ");
INSERT INTO meq_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Neŋ faya na gwaɗakumeye: Sərum ha na, taɗə ndoweye kə vəlay yam gəsiyem nəte matasla eye a ndo nakə makətsa eye mə walaŋ i gawla ga hay hərwi nakə neŋgeye gawla ga aye na, magogoy ŋgay ma dziye bay.» ");
INSERT INTO meq_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu a ndəv ha bazlam ŋgay neheye a tsikatay a gawla ŋgay hay kuro gər eye sulo aye na, a həl bo abəra ka təv niye a ye mata tətikatay a ndo hay ada məɗatay ha ma wuzlah gay neheye ka dala niye aye. ");
INSERT INTO meq_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ahəl niye na, Yuhana madzəhuɓe ndo a yam neŋgeye ma daŋgay. A tsəne ndo hay faya ta tsikiye ka Kəriste ada ka məsler ŋgay nakə faya ma giye aye. Tsa na, a slər siye i ŋgal mə walaŋ i gawla ŋgay hay, ");
INSERT INTO meq_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","hərwi matsətsehe ka Yesu: «Nəkar na, Kəriste nakə ma deyeweye aye ɗaw? Kəgəbay nəmaâ həba ndo mekeleŋ ɗaw?» Ti ye ta tsətsah ka Yesu andza niye. ");
INSERT INTO meq_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu a mbəɗatay faya: «Dum təkərumay a Yuhana wu nakə ka tsənum aye ada wu nakə ka ŋgatumay aye. ");
INSERT INTO meq_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Gwaɗumay na, guluf hay tə ŋgatay a ɗəre, ndo matəra eye hay ti ye lele, ndo madəgwaɗa eye ta mbəl suwuɗ suwuɗ, mandək hay tə tsəne zləm, mədahaŋ hay ta lətsew a sifa, ndo i mətawak ta tsəne Labara Ŋgwalak eye. ");
INSERT INTO meq_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Məŋgwese ka gər i ndo nakə kə gər ha mədzele gər abəra ka neŋ bay aye!» ");
INSERT INTO meq_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Gawla i Yuhana niye hay ti ye abəra mə ɗəma na, Yesu a dazlay mətsikatay a ndo neheye ka təv ŋgay aye ka Yuhana. A gwaɗatay: «Ka yum a kəsaf mata zəbaw na, ka mey? Ka zəbumaw ka guzer nakə mətasl faya ma ɓəliye ha aye ɗaw? Aʼay andza niye bay. ");
INSERT INTO meq_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ada ka yum, ka zəbumaw na, ka mey? Ka zəbumaw na, ka ndo malambaɗa bo eye tə petekeɗ lele eye ɗaw? Tsukuɗu kəkay? Ane tuk na, ndo neheye tə petekeɗ ka bo lele aye na, nəteye mandza eye mə gay i bəy bagwar eye hay. ");
INSERT INTO meq_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ka yum mata zəbaw na, ka wuye mey? Ka zəbumaw na, ka ndo məɗe ha bazlam i Mbəlom ɗaw? Ayaw, neŋgeye ndo məɗe ha bazlam i Mbəlom ada neŋ faya na gwaɗakumeye, neŋgeye a ze ndo məɗe ha bazlam i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yuhana na, ndo nakə tə watsa a Ɗerewel aye, Mbəlom a gwaɗ: “Neŋ na sləriye naha ndo məɗe ha bazlam ga kame yak. Ma lambaɗakeye na tsəveɗ.” ");
INSERT INTO meq_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","«Neŋ faya na gwaɗakumeye: Sərum ha na, mə walaŋ i ndo zezeŋ hay tebiye ndo nakə a ze Yuhana madzəhuɓe ndo a yam aye na, andaya bay. Ane tuk na, ndo nakə neŋgeye tsekweŋ makətsa eye ma Bəy i Mbəlom aye na, a ze Yuhana. ");
INSERT INTO meq_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kwa ahəl nakə Yuhana madzəhuɓe ndo a yam a tsikawa bazlam i Mbəlom a ndo hay aye hus anəke na, ndo məne ɗəre i Mbəlom hay faya ta giye vəram ta Bəy i Mbəlom ada tə dzawa faya bo matsəpe na. ");
INSERT INTO meq_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ɗerewel i ndo məɗe ha bazlam i Mbəlom hay tə ɗerewel i Musa ta ɗa ha Bəy i Mbəlom hus a həlay i Yuhana madzəhuɓe ndo a yam. ");
INSERT INTO meq_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Taɗə a sakum mədzal ha na, Yuhana neŋgeye Eliya tə watsa faya mə Ɗerewel i Mbəlom, tə ɗa ha tə gwaɗ ma deyeweye. ");
INSERT INTO meq_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ndo nakə zləm andaya faya mətsəne aye na, mâ tsəne lele!» ");
INSERT INTO meq_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yesu a gwaɗatay sa: «Ndo neheye bəgom aye na, na ndzəkitiye tay ha bo na, tə way? Ta ndzəkit bo na, ta wawa neheye mandza eye ka pəlaɗ nakə ndo hay tə hayawa faya gər aye, siye hay faya ta wudatay naha a siye hay. Tə gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Nəmaa fakum naha fagam i məhetse, ka hatsum bay, nəmaa gakum naha dəmes i mədahaŋ na, ka tuwum bay.” ");
INSERT INTO meq_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Andza niye Yuhana madzəhuɓe ndo a yam a yaw, kə nda wu mənday, kə sa wu məse bay na, tə gwaɗ: “Neŋgeye na, məsəfəre nakə ŋgwalak eye bay aye mə bo ŋgay.” ");
INSERT INTO meq_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Neŋ Wawa i Ndo, na yaw, na nda wu mənday ada na sa wu məse na, tə gwaɗ: “Zəbum faya, ndo nakay i ŋgay a dzala na, ka wu mənday ada ka məse guzom. Neŋgeye na, dzam i ndo matsekele dzaŋgal hay ta ndo i mezeleme hay.” Ane tuk na, Metsehe i Mbəlom ma bəziye na, ta məsler neheye ma giye aye.» ");
INSERT INTO meq_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ma dəba eye na, Yesu a pa bo ka məmatay ha mənese a gəma neheye a ge mə ɗəma masuwayaŋ haladzay aye, ane tuk na, ndo i gəma niye hay ta mbəɗa ha mede tay bay. A gwaɗ: ");
INSERT INTO meq_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«A nəkurom ndo i gəma i Koraziŋ hay, tuwum bo kurom, hərwi ɗəretsətseh ka gər kurom! A nəkurom ndo i gəma i Betesayda hay, tuwum bo kurom hərwi ɗəretsətseh ka gər kurom. Hərwi taɗə masuwayaŋ neheye na ge mə gay kurom aye nâ ge ma gəma i Tir ta gəma i Sidoŋ na, atay na, ndo i gəma niye hay ta dzaliye bo tay ta tuwiye, ta pa ka bo taɓay manasa eye ada ta kutsiye bətekwew maləməts a gər hərwi məɗe ha na, ta gər ha mezeleme tay. ");
INSERT INTO meq_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Hərwi niye neŋ faya na gwaɗakumeye: Pat nakə Mbəlom ma gateye sariya a ndo hay aye na, sariya kurom ma diye me ma ziye i ndo i gəma i Tir ta Sidoŋ. ");
INSERT INTO meq_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","«Nəkurom ndo i gəma i Kafernahum hay, ka dzalum nəkurom na, Mbəlom ma ta həliye kurom a mbəlom wal ɗaw? Aʼay! Nəkurom ɗuh na, Mbəlom ma ta mbəzliye kurom ha na, a təv məndze i mədahaŋ hay. Hərwi masuwayaŋ neheye na ge ma gəma kurom aye tâ ge ma gəma i Sodom na, haɓe atay gəma nakay ma giye andaya bəgom. ");
INSERT INTO meq_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Andza niye, neŋ faya na gwaɗakumeye, pat nakə Mbəlom ma gateye sariya a ndo hay aye na, sariya kurom ma diye me ma ziye i ndo i gəma i Sodom hay.» ");
INSERT INTO meq_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ma məndze tsekweŋ na, Yesu a gwaɗ: «A nəkar Bəba Mbəlom, ndo mələve magərmbəlom ta dala. Na gaka sɨsœ hərwi nəkar ka ɗatay ha wu nakə maŋgaha eye a ndo neheye tə sər wuray bay aye. Ada ka ŋgaha abəra ka ndo i ndaraw hay ta ndo neheye nəteye tə sər wu aye. ");
INSERT INTO meq_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ayaw, Bəba Mbəlom, a yaka a gər a nəkar hərwi mâ ge bo andza niye.» ");
INSERT INTO meq_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","A gwaɗatay: «Bəba ga kə vəleŋ wu hay tebiye. Ndəray a sər wawa bay, maa sər na, Bəba. Ndəray a sər Bəba bay, maa sər na, neŋ wawa ŋgay ada maa sər na ndo neheye a seŋ məɗatay ha aye.» ");
INSERT INTO meq_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yesu a gwaɗatay sa: «A nəkurom neheye faya ka zlumeye wu mamba eye ada nəkurom madagər eye, dumara ka təv ga, neŋ na vəlakumeye mazəzukwe bo. ");
INSERT INTO meq_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Rəhumeŋ ha gər, na tətikakumeye wu lele eye, hərwi neŋ ndo səkeffe eye, na gakumeye ɗəretsətseh bay. Ta deɗek ka hutumeye mazəzukwe bo. ");
INSERT INTO meq_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Wu nakə na piye fakuma aye na, a wur bo məzle bay, wu nakə na vəlakumeye, ka zlumeye na, a mba bay.» ");
INSERT INTO meq_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pat i mazəzukw bo na, Yesu ta gawla ŋgay hay ti ye ta guvah wuray. Ma guvah eye niye tə ge a ɗəma na, wuye andaya tə zalay bəle. Ahəl nakə faya ta diye na, may a wur ka gawla i Yesu hay, tə pa bo ka məhəɓe wu niye tə nda. ");
INSERT INTO meq_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farisa hay tə ŋgatatay na, tə gwaɗay a Yesu: «Zəba, gawla yak hay ta giye wu nakə bazlam i Mbəlom mapala eye a ge faya me pat i mazəzukw bo aye na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu a mbəɗatay faya: «Ɗaɗa ka dzaŋgum wu nakə Davit a ge aye təbəɗew? May a wur faya ta ndo ŋgay hay. ");
INSERT INTO meq_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tsa na, a fələkwa a madzawadzawa i məɗəslay ha gər a Mbəlom ta ndo ŋgay hay. A ye naha, a zla makwala nakə tə vəlay a Mbəlom aye, a nda. A vəlatay a ndo ŋgay hay dərmak, tə nda. Bazlam i Mbəlom mapala eye a vəl tsəveɗ ka mənde na, a ndo məvəlay wu a Mbəlom ɗekɗek bəɗaw? ");
INSERT INTO meq_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","«Kəgəbay ka dzaŋgum wu nakay mə ɗerewel i Musa bəɗaw? Pat i mazəzukw bo na, ndo məvəlay wu a Mbəlom mə gay i məɗəslay ha gər a Mbəlom ta rəhay ha gər a pat i mazəzukw bo bay, ta ge məsler. Ane tuk na, ta ge mənese bay. ");
INSERT INTO meq_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Neŋ faya na gwaɗakumeye, wu nakə a ze gay i məɗəslay ha gər a Mbəlom aye na, andaya kanaŋ. ");
INSERT INTO meq_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","«Tə watsa a Ɗerewel i Mbəlom na, Mbəlom a gwaɗ: “A seŋ na, gumay ŋgwalak a ndo bəna, gənaw neheye ka kəɗumeŋeye bay.” Taɗə ka tsənum wu nakay na, ndo neheye ta ge wuray bay aye na, kâ gəsum tay ha bay. ");
INSERT INTO meq_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Hərwi maa ləvay gər a pat i mazəzukw bo na, Neŋ Wawa i Ndo.» ");
INSERT INTO meq_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu a ye abəra ka təv niye, a ye a gay i maɗuwule me. ");
INSERT INTO meq_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mə ɗəma na, ndoweye andaya həlay ŋgay maməta eye. A satay a ndo hay məmay ha mənese a Yesu, ta tsətsah faya tə gwaɗay: «Tsəveɗ andaya məmbəle ha ndo pat i mazəzukw bo ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu a mbəɗatay faya: «Taɗə ndo nəte mə walaŋ kurom təɓaŋ ŋgay andaya nəte, təɓaŋ ŋgay niye a dəɗ a bəɗiyem pat i mazəzukw bo na, ma zla ahaya abəra mə ɗəma bəɗaw? ");
INSERT INTO meq_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kə ge andza niye na, ndo zezeŋ a ze təɓaŋ bəɗaw? Bazlam kway mapala eye kə vəl tsəveɗ ka məge ŋgwalak a ndo pat i mazəzukw bo!» ");
INSERT INTO meq_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tsa na, Yesu a gwaɗay a ndo niye: «Nduɗa ha həlay yak!» Ndo niye a nduɗa ha həlay ŋgay. Tsa na, a mbəl lele andza həlay neŋgeɗ. ");
INSERT INTO meq_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Sototo, Farisa hay ti yaw abəra mə gay, ti ye tə haya gər. Tə ma ha ka bo bazlam, ta hutiye tsəveɗ ka məkəɗe Yesu na, kəkay. ");
INSERT INTO meq_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ahəl nakə Yesu a sər ha Farisa hay faya ta pəliye tsəveɗ ka məkəɗe na na, a ye abəra ka təv niye. Ndo hay haladzay tə pay bəzay, a mbəl tay ha ndo i ɗəvats hay tebiye. ");
INSERT INTO meq_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tsa na, a gatay me, a gwaɗatay: «Neŋ way na, kâ tsikumay a ndəray bay.» ");
INSERT INTO meq_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","A ge andza niye na, hərwi ada wu neheye Ezay ndo məɗe ha bazlam i Mbəlom a tsik aye tâ ge bo: ");
INSERT INTO meq_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Mbəlom a gwaɗ: «Ndo i məsler ga nakə na zla aye na, anaŋ, na wuɗa na haladzay, məŋgwese ga tebiye ka gər ŋgay. Na sləriye naha Məsəfəre ga ka neŋgeye, ma ɗatay ha deɗek ga a ndo hay tebiye. ");
INSERT INTO meq_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ta təriye ta ndəray bay, ma wudiye wuray bay, ndəray ma tsəniye faya abəra mabəbəle wuray ka mazlazlaŋ i tsəveɗ bay. ");
INSERT INTO meq_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Guzer nakə mahədzaka eye na, ma həɓiye ha bay, Ako nakə ndœzœzœ ka lalam faya ma mbatiye na, ma ndəvay həlay ma mbatiye ha bay, Ma giye andza niye hus ka vəlatay məŋgwese a ndo neheye deɗek eye hay aye. ");
INSERT INTO meq_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ndo hay tebiye ta piye mədzal gər tay na, ka neŋgeye.» ");
INSERT INTO meq_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tə zlayaw ndo wuray guluf eye ada a sər mətsike me bay hərwi fakalaw mə bo ŋgay. Yesu a mbəl ha. Tsa na, ndo niye a tsik me lele ada a ŋgatay a ɗəre lele. ");
INSERT INTO meq_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","A gatay a ndo hay hərɓaɓəkka, nəteye tebiye, tə gwaɗ: «Ndo nakay ma giye na, Wawa i Davit!» ");
INSERT INTO meq_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Farisa hay tə ŋgatay a wu nakə a ge bo aye na, tə gwaɗ: «Maa vəlay gədaŋ ka mahəhere fakalaw hay na, Bedzabul bəy i fakalaw hay!» ");
INSERT INTO meq_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ane tuk na, Yesu a səratay naha ka wu nakə tə dzala aye, a gwaɗatay: «Taɗə ndo i gəma hay ta ŋgəna, faya ta giye vəram mə walaŋ tay na, gəma niye ma dziye. Taɗə ndo i wuzlahgəma hay kəgəbay ndo hay ma bəɗgay tay faya ta kəɗiye bo na, wuzlahgəma niye kəgəbay bəɗgay niye ma ndziye huya bay. ");
INSERT INTO meq_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Taɗə Fakalaw tə Fakalaw ta həhariye bo tay, ma giye magazləga ka bo ŋgay eye, ada bəy ŋgay ma ndziye huya na, ma kəkay? ");
INSERT INTO meq_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ka gwaɗum maa vəleŋ gədaŋ ka mahəhere fakalaw na, Bedzabul. Ane tuk na, a dzam kurom hay na, maa vəlatay gədaŋ ka mahəhere fakalaw hay na, way? Andza niye, dzam kurom hay faya ta ɗiye ha na, deɗek andaya mə nəkurom bay. ");
INSERT INTO meq_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Maa vəleŋ gədaŋ a neŋ ka mahəhere fakalaw na, Məsəfəre i Mbəlom. Andza məgweɗe na, Bəy i Mbəlom ɓa ki yaw tsɨy hus ka təv kurom. ");
INSERT INTO meq_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Ndəray ma sliye məfələkwe a gay i ndo i gədaŋ məhəla ahaya wu ŋgay bay. Ma ta sliye faya məfələkwe na, ma lahiye mədzewe na təday. Kə dzawa na tuk na, ma sliye faya mede a gay, mahəla ahaya wu ŋgay hay tuk.» ");
INSERT INTO meq_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","A gwaɗatay sa: «Ndo nakə neŋgeye tə neŋ bay aye na, neŋgeye ndo i vəram ga. Ndo nakə ka dzəna ga ka məhayatay gər a ndo ga hay bay aye na, ma həhariye tay ha kweye kweye. ");
INSERT INTO meq_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Hərwi niye, neŋ faya na tsikakumeye: Taɗə ndo zezeŋ kə ge mezeleme kwa waray tebiye, kəgəbay kə tsalay ka gər a Mbəlom na, Mbəlom ma pəsay ha mezeleme ŋgay. Ane tuk na, ndoweye kə tsalay ka gər a Məsəfəre Tsəɗaŋŋa eye na, Mbəlom ma pəsay ha mezeleme ŋgay bay. ");
INSERT INTO meq_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Taɗə ndoweye kə tsik wu nakə ŋgwalak eye bay aye ka neŋ Wawa i Ndo na, Mbəlom ma pəsay ha mezeleme ŋgay. Ane tuk na, taɗə kə tsik wu nakə ŋgwalak eye bay aye ka Məsəfəre Tsəɗaŋŋa eye na, Mbəlom ma pəsay ha mezeleme ŋgay bay, kwa anəke, kwa ka məndzibəra nakə ma deyeweye kame aye. ");
INSERT INTO meq_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Kə ge dərizl i gərɗaf ŋgwalak eye na, hohway ŋgay hay ŋgwalak eye. Kə ge dərizl i gərɗaf eye ŋgwalak eye bay na, hohway ŋgay hay ŋgwalak eye bay. Andza niye ta səriye ha dərizl i gərɗaf nakay ŋgwalak eye na, abəra ka hohway ŋgay hay. ");
INSERT INTO meq_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","A nəkurom wawa i palas neheye! Nəkurom ŋgwalak eye hay bay. Ada ka slumeye faya mətsike wu neheye ŋgwalak eye hay na, ma kəkay? Hərwi kwa way a ndohwa ahaya na, wu nakə maraha eye mə ɗərev ŋgay aye. ");
INSERT INTO meq_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ndo nakə ŋgwalak eye na, ma giye wu ŋgwalak eye hay hərwi mə ɗərev ŋgay na, wu neheye ŋgwalak eye dərmak. Ndo nakə seweɗ eye na, ma giye wu neheye seweɗ eye hərwi ɗərev ŋgay maraha eye tə wu neheye seweɗ eye. ");
INSERT INTO meq_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Neŋ faya na tsikakumeye: Pat nakə Mbəlom ma gateye sariya a ndo hay aye na, bazlam neheye mətsike kəriye kəriye kwa way ma mbəɗay faya a gər ŋgay. ");
INSERT INTO meq_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Andza niye, Mbəlom ma gwaɗiye ka ge mənese bay kəgəbay ka ge mənese ka bazlam neheye ka tsik aye.» ");
INSERT INTO meq_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ndo mədzaŋgawa bazlam i Mbəlom mapala eye ta Farisa hay, tə gwaɗay a Yesu: «Miter, a samay na, gamay masuwayaŋ.» ");
INSERT INTO meq_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu a mbəɗatay faya: «Ndo neheye a həlay nakay na, nəteye seweɗ eye hay, nəteye ta mbəɗay dəba a Mbəlom, faya ta tsətsahiye masuwayaŋ. Ane tuk na, ma dəba i masuwayaŋ i Zonas ndo məɗe ha bazlam i Mbəlom nakə tə ŋgatay aye na, ta ŋgateye a masuwayaŋ mekeleŋ eye bay. ");
INSERT INTO meq_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Hərwi, Zonas kə ndza pat eye mahkar ada həvaɗ eye mahkar ma kutes i kəlef bagwar eye. Andza niye dərmak neŋ Wawa i Ndo na ndziye pat eye mahkar ada həvaɗ eye mahkar ma tsəvay. ");
INSERT INTO meq_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ahəl nakə ndo i Ninive hay tə tsəne labara nakə Zonas a tsikatay aye na, ta mbəɗa ha mede tay. Ndo andaya kanaŋ bəgom a ze Zonas. Hərwi niye, ahəl nakə Mbəlom ma gateye sariya a ndo hay aye na, ndo i gəma i Ninive ta deyeweye ta lətsiye kame i ndo neheye bəgom aye ta matay ha mənese. ");
INSERT INTO meq_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","«Ŋgwas wuray andaya, neŋgeye bəy bagwar eye, a yaw abəra ma diye i tsakay. A yaw mətsəne bazlam i Salomoŋ neheye maraha eye ta metsehe aye. Ndo andaya kanaŋ a ze ha Salomoŋ. Hərwi niye, ahəl nakə Mbəlom ma gateye sariya a ndo hay aye na, ŋgwas nakay bəy bagwar eye ma deyeweye abəra ma diye i tsakay, ma lətsiye kame i ndo neheye ma matay ha mənese aye.» ");
INSERT INTO meq_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Fakalaw ki yaw abəra mə bo i ndo na, ma diye ma dzədziye mə kəsaf, ma pəliye təv mazəzukw bo. Kə huta bay na, ");
INSERT INTO meq_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ma gwaɗeye a gər ŋgay: “Na mbəɗiye gər a gay ga nakə na yaw abəra mə ɗəma aye.” Ma mbəɗiye gər, kə ye naha kə ŋgatay a gay wuray mə ɗəma bay, mafaɗa eye lele ada malambaɗa eye. ");
INSERT INTO meq_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tsa na, ma diye ma həlaweye siye i məsəfəre neheye seweɗ eye hay wene wene ta ze neŋgeye aye tasəla. Ta fələkwiye a gay, ta ndziye mə ɗəma. Ka mandəve eye na, wu niye ma miye ka ndo niye ma ziye nakə kurre aye. Ma giye bo ta ndo neheye ŋgwalak eye bay bəgom aye na, andza niye.» ");
INSERT INTO meq_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ahəl nakə Yesu faya ma tsikateye me a ndo hay aye, may ŋgay ta malamar ŋgay hay ti ye naha. Tə lətse ma bəra, ta pəla tsəveɗ mətsikay me a Yesu. ");
INSERT INTO meq_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ndo nəte a ye ka təv i Yesu, a gwaɗay: «Zəba, may yak ta malamar yak hay nəteye ma bəra, a satay mətsikaka me.» ");
INSERT INTO meq_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu a mbəɗatay faya: «May ga na, way? Malamar ga hay na, way hay?» ");
INSERT INTO meq_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tsa na, a zəkwa həlay ka gawla ŋgay hay, a gwaɗ: «May ga ta malamar ga hay na, nəteye anaŋ. ");
INSERT INTO meq_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Hərwi taɗə ndoweye kə ge wu nakə a say a Bəba ga mə mbəlom na aye, neŋgeye malamar ga, ada may ga.» ");
INSERT INTO meq_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Pat eye niye na, Yesu a yaw abəra mə gay, a ye a ndza ka me i dəlov. ");
INSERT INTO meq_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ndo hay haladzay tə haya gər ka təv ŋgay. Hərwi niye a tsal a kwalalaŋ i yam wuray ka gər i yam a ndza a ɗəma. Ndo hay tebiye tə ndza ka me i dəlov. ");
INSERT INTO meq_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesu a tətikatay wu haladzay a ndo niye hay ta dzeke. A gwaɗatay: «Ndo wuray a ndohwaw abəra mə gay. A həl hulfe, a ye ha a pesl mata sləge. ");
INSERT INTO meq_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","A ye naha na, a dazlay a masləge. Ahəl nakə faya ma kutsiye hulfe ŋgay a guvah aye na, siye hay tə kuts ka tsakay i tsəveɗ. Ɗiyeŋ hay ti yaw, tə pala na tebiye. ");
INSERT INTO meq_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Hulfe mekeleŋ eye a dəɗ ka sik i pəlaɗ, təv nakə bətekwew andaya faya haladzay bay aye. Hulfe niye hay tə ndzohwaw bəse tsa. Tə ndzohwaw bəse na, hərwi bətekwew andaya ka sik i pəlaɗ niye bay. ");
INSERT INTO meq_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ane tuk na, pat a tsaraw, a zla faya abəra ŋgulak na, a fəka tay ha hulfe niye hay tə ndzohwaw aye. Tə kula heryew heryew hərwi ta huta bəɗ məpe zləlay haladzay bay. ");
INSERT INTO meq_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Neŋgeɗ a dəɗ a gay i dak. Dak niye hay tə gəl. Tsa na, dak niye hay tə ŋgəɗətsa na hulfe niye a ndzohwaw aye, kwa hulfe niye hay ta ge bo bay ada ta nah bay. ");
INSERT INTO meq_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Siye sa na, tə kuts ka təv lele eye, tə ndzohwaw na, lele. Tə gəl ada tə nah, gər eye həɓəts həɓəts lele. Mə walaŋ tay niye na, neheye hohway tay hay makwehe nəte na, wur eye a ge temerre, neŋgeɗ sa na, kuro kuro məkwa, ada siye kuro kuro mahkar.» ");
INSERT INTO meq_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu a ndəv ha andza niye na, a gwaɗatay: «Ndo nakə zləm andaya faya na, mâ tsəne!» ");
INSERT INTO meq_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ma dəba eye na, gawla ŋgay hay ta həndzəɗ naha ka təv ŋgay, ta tsətsah faya: «Ka tsikatay me a ndo hay ta dzeke na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu a mbəɗatay faya: «Nəkurom na, Mbəlom kə ɗakum ha wu nakə maŋgaha eye ma bəy ŋgay aye. Ane tuk na, a nəteye na, kə ɗatay ha bay. ");
INSERT INTO meq_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Andza niye, ndo nakə wu ŋgay andaya na, ta səkahay ha sa ada i ŋgay ma giye haladzay. Ane tuk na, ndo nakə wuray ŋgay andaya bay aye na, kwa tsekweŋ eye nakə andaya faya aye na, ta buwiye na. ");
INSERT INTO meq_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Hərwi niye na tsikatay me ta dzeke na, nəteye ta zəbiye faya tə ɗəre tay, ane tuk na, ta ŋgateye bay. Ta pay zləm, ane tuk na, ta tsəniye tə zləm tay bay, ta səriye bay. ");
INSERT INTO meq_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Andza niye, wu nakə Ezay ndo məɗe ha bazlam i Mbəlom a ɗa ha aye na, kə ge bo deɗek. Mbəlom a gwaɗ: “Ka tsənumeye lele, ane tuk na, ka sərumeye bay. Ka zəbumeye faya lele, ane tuk na, ka ŋgatumeye bay. ");
INSERT INTO meq_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ndo neheye na, ta kula ha gər tay toŋgwa toŋgwa. Ta dəka na zləm tay, ta dərəzl na ɗəre tay. A satay məŋgatay tə ɗəre tay bay, a satay mətsəne tə zləm tay bay, a satay məsəre tə metsehe tay bay. Taɗə a satay mambəɗe ha mede tay na, na mbəliye tay ha dərmak.” ");
INSERT INTO meq_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Ane tuk na, nəkurom na, ka hutum məŋgwese. Ka ŋgatumay a ɗəre, ada ka tsənum tə zləm kurom. ");
INSERT INTO meq_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Neŋ faya na gwaɗakumeye: Sərum ha na, ndo məɗe ha bazlam i Mbəlom hay haladzay, ndo deɗek eye haladzay a satay haɓe məŋgatay a wu nakə faya ka ŋgatumeye, ane tuk na, ta ŋgatay bay. A satay mətsəne wu nakə faya ka tsənumeye, ane tuk na, ta tsəne bay.» ");
INSERT INTO meq_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Dzeke i ndo masləge nakay a say məgweɗe mey na, tsənum. ");
INSERT INTO meq_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ndo neheye tə tsəne bazlam i Bəy i Mbəlom aye ada tə tsəne zləm bay aye na, ta ndzəkit bo ta tsakay tsəveɗ nakə hulfe a dəɗ faya aye. Fakalaw a yaw, a buwa na wu nakə ta sləga a ɗərev tay aye. ");
INSERT INTO meq_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Siye hay ta ndzəkit bo tə sik i pəlaɗ nakə hulfe a kuts faya aye. Tə tsəne bazlam i Mbəlom na, ta təma kwayaŋŋa tə məŋgwese eye. ");
INSERT INTO meq_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ane tuk na, ta gəray tsəveɗ a bazlam i Mbəlom ada mâ pa zləlay a ɗərev tay bay. Tə dzala ha faya na, tsekweŋ tsa. Ɗəretsətseh kəgəbay madzəgur me a ndzatay a gər hərwi bazlam i Mbəlom. Tsa na, tə gər ha mədzele gər abəra ka Mbəlom ta bəse. ");
INSERT INTO meq_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Siye hay sa na, ta ndzəkit bo ta hulfe neheye tə kuts a gay i dak hay aye. Tə tsəne bazlam i Mbəlom, ane tuk na, mədzal gər ka wu i məndzibəra, bor i zlele a ye tay a bo. Wu niye hay tə ŋgəɗətsa na bazlam i Mbəlom nakə mə ɗərev tay aye. Tsa na, bazlam i Mbəlom kə wa hohway mə ɗərev tay bay. ");
INSERT INTO meq_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ndo mekeleŋ eye hay ta ndzəkit bo ta dala nakə lele aye. Hulfe a kuts faya na, a ndzohw lele. Nəteye tə tsəne bazlam i Mbəlom na, ta təma a ɗərev tay lele. Bazlam i Mbəlom a gəl mə ɗərev tay lele ada a nah. Neŋgeɗ makwehe nəte na, wur eye a ge temerre, neŋgeɗ sa na, kuro kuro məkwa, siye kuro kuro mahkar.» ");
INSERT INTO meq_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu a tsikatay dzeke mekeleŋ eye, a gwaɗatay: «Bəy i Mbəlom a ndzəkit bo na, ta ndo wuray a sləga hulfe lele eye a guvah ŋgay. ");
INSERT INTO meq_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ta həvaɗ, ahəl nakə ndo hay tebiye ka məndzehəre na, ndo məne ɗəre i ndo niye a ye a sləgay a ɗəma daw zuŋgo a walaŋ i daw ŋgay niye. Tsa na, a ye ŋgway. ");
INSERT INTO meq_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ahəl nakə wu hay tə ndzohw, faya ta diye tə gər aye na, daw zuŋgo niye hay tə ndzohwaw dərmak. ");
INSERT INTO meq_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ndo i məsler hay ti yaw tə gwaɗay a ndo i guvah: “Ndo i gay may, ka sləga a guvah yak na, hulfe lele tuk na, ada daw zuŋgo a yaw a ɗəma na, məŋgay?” ");
INSERT INTO meq_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ndo niye a mbəɗatay faya: “Maa ge wu niye na, ndo məne ɗəre ga.” Ndo i məsler hay tə tsətsah faya, tə gwaɗay: “A saka nəmaâ ye məŋgweɗe ahaya abəra mə ɗəma daw zuŋgo ɗaw?” ");
INSERT INTO meq_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","A gwaɗatay: “Aʼay, kâ ŋgwaɗum bay, ka ta ŋgwaɗumeye ka bo dziye ta daw. ");
INSERT INTO meq_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Gərum tay ha tâ nah ka bo dziye hus a həlay i mədze. A həlay i mədze na, na gwaɗateye a ndo i məsler hay: Dzum na daw zuŋgo təday. Ɓarum na ada kâ dzumay a ako. Daw na, hayumay gər ada kâ pum na a de ga.”» ");
INSERT INTO meq_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu a tsikatay dzeke mekeleŋ eye sa, a gwaɗatay: «Bəy i Mbəlom a ndzəkit bo na, wur i ɓəzaŋ nakə ndo a zla a sləga a guvah ŋgay. ");
INSERT INTO meq_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mə walaŋ i wur i wu hay tebiye na, neŋgeye tsekweŋ. Ane tuk na, a ndzohw, a gəl na, a ze ala neheye tə sləga ka dədaŋ aye tebiye. A təra andza gərɗaf, ɗiyeŋ hay tə ŋgar gay tay hay ka hawal eye hay.» ");
INSERT INTO meq_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu a tsikatay dzeke sa, a gwaɗatay: «Bəy i Mbəlom a ndzəkit bo na, gəɗe nakə ŋgwas a həl tsekweŋ a dzapa ha ta gufa aye. Gufa niye na, haladzay. A həlaɓ tay ha ka bo na, gufa niye mahəlaɓa eye a kwasa a həmbət.» ");
INSERT INTO meq_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu a tətikatay wu ŋgay hay tebiye a ndo hay na, ta dzeke. A tsikawatay me ze mətsike ta dzeke bay. ");
INSERT INTO meq_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A tsikawa andza niye na, hərwi ada wu nakə ndo məɗe ha bazlam i Mbəlom a tsik aye mâ ge bo. Mbəlom a gwaɗ: «Na tsikateye wu na, ta dzeke. Na ɗatay ha wu neheye maŋgaha eye kwa abəra ka madazlay i məge məndzibəra aye.» ");
INSERT INTO meq_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu a ndəv ha mətsike me na, a gər tay ha ndo hay, a ye a gay. Ahəl nakə neŋgeye mə gay aye na, gawla ŋgay hay ti ye ka təv ŋgay. Ti ye naha, ta tsətsah faya, tə gwaɗay: «Ɗamay ha dzeke i daw zuŋgo nakə ma guvah aye.» ");
INSERT INTO meq_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu a mbəɗatay faya: «Ndo nakə a sləga wur i wu ŋgwalak eye na, neŋ Wawa i Ndo. ");
INSERT INTO meq_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Guvah na, məndzibəra. Wur i wu ŋgwalak eye na, ndo neheye ma Bəy i Mbəlom aye. Daw zuŋgo na, ndo neheye ta rəhay ha gər a Fakalaw aye. ");
INSERT INTO meq_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ndo məne ɗəre nakə a sləga daw zuŋgo aye na, Fakalaw. Mədze wu abəra ka dala na, mandəve i məndzibəra nakə Mbəlom ma ndəviye ha aye. Ndo i məsler hay na, gawla i Mbəlom hay. ");
INSERT INTO meq_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Andza nakə tə həl daw zuŋgo tə dzay a ako aye na, Mbəlom ma ndəviye ha məndzibəra andza niye dərmak. ");
INSERT INTO meq_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Neŋ Wawa i Ndo na sləraweye gawla i Mbəlom hay. Ta həliye tay ha abəra ma Bəy i Mbəlom ndo neheye tebiye faya ta səpatiye tay ha ndo hay a mezeleme aye ta ndo neheye faya ta giye wu nakə ŋgwalak eye bay aye. ");
INSERT INTO meq_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ta kutsiye tay ha a ako bagwar eye. Mə ɗəma na, ta tuwiye tə mahəpəɗe zler eye. ");
INSERT INTO meq_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ane tuk na, ndo neheye tə pay naha faya a Mbəlom aye na, ta dəviye wuzl wuzl andza pat ma Bəy i Bəba tay Mbəlom. Ndo nakə zləm andaya faya aye na, mâ tsəne!» ");
INSERT INTO meq_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesu a gwaɗatay sa: «Bəy i Mbəlom a ndzəkit bo tə zlele nakə tə la na a guvah aye. Ndo a huta na zlele eye niye ada a la na, a ŋgaha na sa. A yay a gər haladzay. A ye a səkəm ha wu ŋgay hay tebiye ada a səkəm guvah niye.» ");
INSERT INTO meq_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","A gwaɗatay sa: «Bəy i Mbəlom a ndzəkit bo sa na, ndo masəkəm ha wu hay. Ma pəliye wu i maslawa neheye a le haladzay aye. ");
INSERT INTO meq_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kə huta wu nakə a ze tay ha siye hay tə məle aye na, ma diye ma səkəmiye ha wu ŋgay hay tebiye ka tsakala. Suloy aye na, ma səkəma ahaya wu i maslawa niye.» ");
INSERT INTO meq_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","A gwaɗatay sa: «Bəy i Mbəlom a ndzəkit bo na, ta gadaŋ. Ta kal a dəlov na, ma gəsaweye kəlef wal wal haladzay. ");
INSERT INTO meq_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Gadaŋ niye kə rah tə kəlef na, ta vaha ahaya abəra ma yam. Ta vaha ahaya na, ta ndziye toŋ, ta paliye kəlef ŋgwalak eye hay. Ta piye tay ha a kəteh. Siye neheye ŋgwalak eye bay aye na, ta miye tay ha. ");
INSERT INTO meq_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ma giye bo pat nakə Mbəlom ma ndəviye ha məndzibəra eye na, andza niye. Gawla i Mbəlom hay ta deyeweye ta ŋgəniye tay ha ka bo abəra ndo i seweɗ hay ta ndo ŋgwalak eye hay. ");
INSERT INTO meq_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ndo i seweɗ hay na, ta kutsiye tay ha a ako. Mə ɗəma na, ta tuwiye tə mahəpəɗe zler eye.» ");
INSERT INTO meq_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu a tsətsah fataya, a gwaɗatay: «Wu neheye tebiye na tsik aye na, ka tsənum ɗaw?» Ta mbəɗay faya: «Ayaw, nəmaa tsəne.» ");
INSERT INTO meq_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","A gwaɗatay: «Andza niye, ndo mədzaŋgawa bazlam i Mbəlom mapala eye a təra gawla ma Bəy i Mbəlom na, a ndzəkit bo ndo i gay nakə faya ma ndohwa ahaya zlele ŋgay abəra mə wu nakə weɗeye ada abəra mə wu nakə guram aye.» ");
INSERT INTO meq_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ahəl nakə Yesu a ndəv ha mətsikatay dzeke neheye aye na, a ye abəra ka təv eye niye. ");
INSERT INTO meq_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","A ye a Nazaret, gəma nakə a gəl mə ɗəma aye. Mə ɗəma na, a ye a gay i maɗuwule me. A ye naha a pa bo ka matətikatay wu a ndo hay. A gatay a ndo neheye tebiye mə ɗəma aye hərɓaɓəkka. Tə gwaɗawa: «A hutaw metsehe nakay na, məŋgay? Maa vəlay gədaŋ ka məge masuwayaŋ neheye na, way? ");
INSERT INTO meq_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Neŋgeye na, wawa i Mari ada bəba ŋgay na, ndo matsətseɗe mayako bəɗa? Malamar ŋgay hay na, Yakuba, Yusufa, Simoŋ ada Yuda bəɗa? ");
INSERT INTO meq_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ada malamar ŋgay dem eye hay nəteye andaya mə walaŋ kway bəɗa? Maa vəlay gədaŋ nakay tebiye na, way?» ");
INSERT INTO meq_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yawa, hərwi wu neheye tebiye aye, ndo i gəma niye hay ta kərah mədzal ha ka Yesu. Yesu a gwaɗatay: «Ndo məɗe ha bazlam i Mbəlom na, ndo hay ta təma na ada tə ɗəslay ha gər kwa məŋgay. Ane tuk na, ma gəma ŋgay nakə tə wa mə ɗəma ada mə gay ŋgay na, ta rəhay ha gər bay.» ");
INSERT INTO meq_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma Nazaret na, Yesu kə ge masuwayaŋ haladzay bay hərwi ta dzala ha bay. ");
INSERT INTO meq_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","A həlay niye na, Herod neŋgeye bəy ka dala i Galile, a tsəne faya ta tsikiye ka Yesu. ");
INSERT INTO meq_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herod a gwaɗatay a ndo i məsler ŋgay hay: «Ndo niye ma giye na, Yuhana madzəhuɓe ndo a yam. Kə mbəlaw abəra ma mədahaŋ. Hərwi niye nakə a huta gədaŋ ka məge masuwayaŋ.» ");
INSERT INTO meq_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Andaya kə ndza haladzay, Herod a zla Herodiyad, ŋgwas i malamar ŋgay Filip. Hərwi niye, Yuhana a gwaɗaway: «Ta vəl tsəveɗ məzle ŋgwas nakay bay.» Tsa na, Herod a gwaɗatay a ndo hay tâ gəs na Yuhana, tâ dzawa na ada tâ pa na a daŋgay. ");
INSERT INTO meq_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","A say a Herod məkəɗe na Yuhana, ane tuk na, a dzədzaratay a ndo hay, hərwi ndo hay tə dzala Yuhana na, ndo məɗe ha bazlam i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pat i magurlom i məwe Herod na, dem i Herodiyad a hats kame i ndo neheye Herod a zalatay a magurlom aye. Məhetse i dem niye a yay a gər a Herod. ");
INSERT INTO meq_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tsa na, a mbaɗay a dem niye, a gwaɗay: «Wu nakə ka tsətsah tebiye na vəlakeye.» ");
INSERT INTO meq_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Dem niye tə ma ha ka bo bazlam ta may ŋgay. Tsa na, a ye a gwaɗay a Herod: «Ɗəseŋew gər i Yuhana madzəhuɓe ndo a yam ka bəgəlam.» ");
INSERT INTO meq_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Andza niye na, a yay a gər a bəy bay. Ane tuk na, ɓa kə mbaɗa kame i ndo neheye mazala eye hay a magurlom aye. A vəl tsəveɗ, tâ ye tâ ɗəsayaw. ");
INSERT INTO meq_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A slər ndo a gay i daŋgay, mâ ɗəsaw gər i Yuhana madzəhuɓe ndo a yam. ");
INSERT INTO meq_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ndo a ye, a ɗəsaw gər i Yuhana a pa ahaya ka bəgəlam. Tə vəlay a dem niye. Dem niye a vəlay a may ŋgay. ");
INSERT INTO meq_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Gawla i Yuhana hay tə tsəne na, ti yaw, tə zla ahaya mədahaŋ i Yuhana abəra ma daŋgay tə la na. Tsa na, ti ye tə ɗa ha wu nakə a ge bo aye a Yesu. ");
INSERT INTO meq_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu a tsəne labara niye na, a ye mahəŋgeye tə kwalalaŋ i yam hərwi mede a təv dəreŋ eye abəra ka ndo hay. Ane tuk na, ndo hay ta sər faya. Ti yaw abəra ma wuzlahgəma hay, tə pay bəzay a Yesu. ");
INSERT INTO meq_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","A ndisl a təv niye na, a mbəzlaw abəra mə kwalalaŋ i yam. A ŋgatatay a ndo hay haladzay na, tə gay mə bo. A mbəl tay ha ndo i ɗəvats tay neheye tə həl naha aye. ");
INSERT INTO meq_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Huwa a ge na, gawla i Yesu hay ta həndzəɗ ka təv i Yesu, tə gwaɗay: «Mazlambar həvaɗ ada təv nakay kəsaf. Gwaɗatay a ndo hay tâ ye a wuzlahgəma hay hərwi ada tâ ye, tâ səkəmaw wu mənday.» ");
INSERT INTO meq_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu a mbəɗatay faya, a gwaɗatay: «Tâ ye bay. Bo kurom eye vəlumatay wu mənday.» ");
INSERT INTO meq_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tə gwaɗay: «Makwala andaya fakwaya kanaŋ na, tapa zlam tə kəlef sulo tsɨy tuk na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu a gwaɗatay: «Həlumeŋ ahaya.» ");
INSERT INTO meq_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tsa na, a gwaɗatay a ndo hay: «Ndzum ka dala!» Yesu a həl makwala neheye tapa zlam tə kəlef sulo aye. A zəba ɗəre a mbəlom, a gay naha sɨsœ a Mbəlom. A ŋgəna ha makwala niye hay ada a vəlatay a gawla ŋgay hay. Gawla ŋgay hay ta ŋgənatay a ndo hay. ");
INSERT INTO meq_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kwa way a nda ka mərehe. Gawla i Yesu hay tə hayay gər a siye nakə a ləkaw aye na, a rah a gwaŋ kuro gər eye sulo. ");
INSERT INTO meq_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ndo neheye tə nda makwala niye na, hasləka hay ta giye gwezem zlam. Ŋgwas hay ta wawa hay na, ta pasla tay ha bay. ");
INSERT INTO meq_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kwayaŋŋa Yesu a gatay kutoŋ a gawla ŋgay hay tâ tsal a kwalalaŋ i yam, tâ lahay kame mede a diye i dəlov neŋgeɗ həlay nakə bo ŋgay eye ma gwaɗateye a ndo hay «Dum kurom» aye. ");
INSERT INTO meq_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ndo hay ti ye wu tay na, Yesu a tsal a tsaholok mahəŋgeye hərwi maɗuwulay me a Mbəlom. Həvaɗ a ge na, neŋgeye huya ma tsaholok niye. ");
INSERT INTO meq_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kwalalaŋ i yam nakə gawla ŋgay hay mə ɗəma aye, dəreŋ ta dala, wuɗək wuɗək ma wuzlah i yam. Mətasl faya ma vəzliye haladzay, a say məme ha kwalalaŋ i yam ta dəba ada yam faya ma ɓəliye ha kwalalaŋ i yam haladzay. ");
INSERT INTO meq_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ta mbəlomɗa na, Yesu a ye ka təv i gawla ŋgay hay ka gər i yam tə sik. ");
INSERT INTO meq_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tə ŋgatay a Yesu faya ma diye ka təv tay ka gər i yam tə sik na, ta dzədzar haladzay, tə gwaɗ: «Ma giye na, wu matəre ka ndo!» Ta wuda ka bo tə madzədzar eye. ");
INSERT INTO meq_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ane tuk na, Yesu a gwaɗatay: «Tete kurom! Kâ dzədzarum bay. Nakay na, neŋ!» ");
INSERT INTO meq_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kwayaŋŋa Piyer a tsikay naha me, a gwaɗay: «Bəy Maduweŋ, kə ge nəkar na, vəleŋ tsəveɗ nâ ye naha ka təv yak ka gər i yam tə sik.» ");
INSERT INTO meq_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu a mbəɗay faya, a gwaɗay: «Dara.» Tsa na, Piyer a ndohwaw abəra mə kwalalaŋ i yam, a pa bo ka mede ka gər yam hərwi mədze gər tə Yesu. ");
INSERT INTO meq_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ane tuk na, a zəba mətasl faya ma vəzliye haladzay na, a dzədzar. A dazlay məndərmeɗe a yam. Tsa na, a wuda ka bo: «Bəy Maduweŋ, təma ga ha tey!» ");
INSERT INTO meq_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kwayaŋŋa, Yesu a bəzay naha həlay a Piyer, a gəs na, a gwaɗay: «Mədzal gər yak hala bay. Ka ge ha mədzal gər yak sulo sulo na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tə tsal a kwalalaŋ i yam sulo tay eye. Tsa na, mətasl a ndza ɗeɗik, a vəzl sa bay. ");
INSERT INTO meq_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Gawla ŋgay neheye mə kwalalaŋ i yam aye ta dəkway gurmets a Yesu, tə gwaɗay: «Nəkar na, Wawa i Mbəlom deɗek!» ");
INSERT INTO meq_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesu ta gawla ŋgay hay tə tas abəra ma dəlov na, tə ndisl a gəma i Genesaret. ");
INSERT INTO meq_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ndo i təv niye tə sər ha Yesu ki yaw. Ti ye tə tsikatay a ndo hay tebiye Yesu ki yaw. Ndo hay tə tsəne na, tə həlaw ndo i ɗəvats hay tebiye ka təv i Yesu. ");
INSERT INTO meq_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tə gay amboh a Yesu, tə gwaɗay: «Ndo i ɗəvats hay tâ ye naha tâ lamay a me i petekeɗ yak nets na, tsɨy.» Tsa na, ndo i ɗəvats neheye ta lamay aye na, ta mbəl tebiye. ");
INSERT INTO meq_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Farisa hay ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye ti yaw abəra ma Zerozelem, ti ye ka təv i Yesu, tə gwaɗay: ");
INSERT INTO meq_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Gawla yak hay ta rəhay ha gər a kule i bəba təte kway hay bay na, hərwi mey? Ahəl nakə ta ndiye ɗaf aye na, tə bara həlay andza i kule i bəba təte kway hay təbey na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu a mbəɗatay faya, a gwaɗatay: «Nəkurom, ka rəhumay ha gər a bazlam i Mbəlom mapala eye bay hərwi kule i bəba təte kurom hay na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Andza niye, Mbəlom a gwaɗ: “Rəhay ha gər a bəba yak ta may yak.” A gwaɗ sa: “Ndoweye kə tsaɗay a bəba ŋgay ta may ŋgay na, kutoŋ tâ kəɗ na a bəɗ.” ");
INSERT INTO meq_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ane tuk na, nəkurom faya ka gwaɗumateye a ndo hay: “Ka slumeye faya məgwaɗatay a bəba kurom hay ta may kurom hay: Haɓe na, nəmaa dzəniye kurom. Ane tuk na, nəmaa vəlay ha a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kâ rəhumay ha gər a bəba kurom sa bay.” Andza niye, faya ka mbatumeye ha Ɗerewel i Mbəlom hərwi kule kurom. ");
INSERT INTO meq_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nəkurom na, ndo i bəbərek hay! Ezay ndo məɗe ha bazlam i Mbəlom a tsik fakuma na, deɗek. A tsik ahəl niye, Mbəlom a gwaɗ: ");
INSERT INTO meq_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ndo neheye ta zembeɗeŋ na, tə bazlam ɗekɗek tsa, ɗərev tay na, dəreŋ tə neŋ. ");
INSERT INTO meq_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nəteye faya ta zembeɗeŋeye kəriye, ane tuk na, kəriye bəna deɗek bay. Wu nakə faya ta tətikateye a ndo hay aye na, bazlam mapala eye i ndo hay tsa.”» ");
INSERT INTO meq_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tsa na, Yesu a zalatay a ndo hay haladzay, a gwaɗatay: «Pum zləm ada tsənum wu nakay. ");
INSERT INTO meq_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Maa nas ha ndo na, wu nakə a ye a bazlam aye bay. Ane tuk na, maa nas ha ndo na, wu nakə a yaw abəra mə bazlam aye.» ");
INSERT INTO meq_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Gawla i Yesu hay ta həndzəɗ naha ka təv i Yesu, tə gwaɗay: «Bazlam yak neheye ka tsik aye kə ndalatay a Farisa hay na, ka sər təbəɗew?» ");
INSERT INTO meq_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu a mbəɗatay faya, a gwaɗatay: «Dərizl i gərɗaf neheye Bəba ga nakə mə mbəlom a zəv bay aye na, ta ŋgwaɗiye tay ha abəra mə ɗəma. ");
INSERT INTO meq_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Gərum tay ha, nəteye na, guluf neheye faya ta gəsatay həlay a guluf hay aye. Guluf ma gəseye həlay a guluf neŋgeɗ na, nəteye salamay ta dəɗiye a bəɗ.» ");
INSERT INTO meq_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tsa na, Piyer a gwaɗay: «Ɗamay ha dzeke nakay.» ");
INSERT INTO meq_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu a gwaɗatay: «Nəkurom dərmak, ka sərum zuk bay ɗaw? ");
INSERT INTO meq_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wu nakə a ye tə bazlam aye na, ma diye a kutes ada ma deyeweye abəra mə bo na, ka sərum təbəɗew? ");
INSERT INTO meq_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ane tuk na, wu nakə a yaw abəra mə bazlam aye na, a yaw mə ɗərev ada maa nas ha ndo na, neŋgeye. ");
INSERT INTO meq_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Andza niye, maa yaw abəra mə ɗərev na, mədzal gər neheye ŋgwalak eye bay aye, məkəɗe gər i ndo, məge madama, mede nakə ŋgwalak eye bay aye, məge məkal, maraw me kame i sariya, maŋgəlay bəzay a ndo hay. ");
INSERT INTO meq_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Wu nakə ma nasiye ha ndo aye na, neheye anaŋ aye. Ane tuk na, mənde wu mənday ze məbere həlay andza kule i bəba təte kway na, ma nasiye ha ndo bay.» ");
INSERT INTO meq_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ma dəba eye na, Yesu a lətse abəra ma təv niye, a ye ka dala i Tir ada a Sidoŋ. ");
INSERT INTO meq_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mə ɗəma na, ŋgwas i Kanan wuray a ndzawa ka dala eye niye. Yesu a ndisl naha na, a ye ka təv ŋgay. A pa bo ka mawude, a gwaɗay: «Bəy Maduweŋ, Wawa i Davit, nâ gaka mə bo təbəɗew! Dem ga andaya mətagay, məsəfəre nakə ŋgwalak eye bay aye faya ma geye ɗəretsətseh haladzay.» ");
INSERT INTO meq_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ane tuk na, Yesu a mbəɗay faya kwa tsekweŋ bay tebiye. Gawla ŋgay hay ta həndzəɗ ka təv ŋgay, ta tsətsah faya, tə gwaɗay: «Həhar na ŋgwas nakay, hərwi faya ma pakweye bəzay tə mawude ŋgay neheye.» ");
INSERT INTO meq_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu a mbəɗatay faya, a gwaɗatay: «Mbəlom a sləra ga ahaya na, hərwi ndo i Israyel hay, nəteye neheye andza təɓaŋ mədze eye hay aye.» ");
INSERT INTO meq_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ane tuk na, ŋgwas niye a ye naha, a dəkway gurmets a huvo, a gwaɗay: «Bəy Maduweŋ, dzəna ga!» ");
INSERT INTO meq_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu a mbəɗay faya, a gwaɗay: «Məzle wu mənday i wawa hay, məkalatay ha a kəra hay na, lele bay.» ");
INSERT INTO meq_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ŋgwas niye a gwaɗay faya: «Bəy Maduweŋ, ka tsik na, deɗek. Ane tuk na, taɗə ndo i gay faya ma ndiye wu mənday na, kəra hay ta diye ta paliye neheye a kutsaw faya abəra aye.» ");
INSERT INTO meq_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tsa na, Yesu a mbəɗay faya a ŋgwas niye, a gwaɗay: «Ŋgwas, mədzal gər yak nakə ka neŋ aye na, haladzay. Wu nakə ka tsətsah aye na, mâ ge bo andza nakə a saka aye.» Kwayaŋŋa dem ŋgay a mbəl. ");
INSERT INTO meq_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ma dəba eye na, Yesu a lətse abəra ka təv niye, a ye ka me i dəlov i Galile. A ye naha a tsal a mahəmba. Mə ɗəma na, a ndza ka dala. ");
INSERT INTO meq_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ndo hay haladzay ti ye naha ka təv ŋgay. Tə həlay naha ndo neheye ta dzəgəɗasla aye, guluf hay, ndo matəra eye, mandək hay ada tə siye i ndo i ɗəvats hay. Ti ye naha, tə həna tay ha kame i Yesu ada a mbəl tay ha. ");
INSERT INTO meq_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","A gatay a ndo hay hərɓaɓəkka, hərwi tə ŋgatay a mandək hay faya ta tsikiye me lele, ndo matəra eye hay ta mbəl, ndo neheye ta dzəgəɗaslawa aye ti ye lele, guluf hay tə ŋgatay a ɗəre kwetseh kwetseh. Ndo niye hay tə gwaɗ: «Nəmaa zambaɗaka a nəkar Mbəlom i Israyel hay!» ");
INSERT INTO meq_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu a zalatay a gawla ŋgay hay, a gwaɗatay: «Ndo neheye na, tə geŋ mə bo haladzay hərwi anaŋ məhəne mahkar na, nəteye ka təv ga ada wu mənday andaya fataya bay. A seŋ məgwaɗatay “Dum kurom” ze mənde wu mənday bay. Ta giye bəle ka tsəveɗ.» ");
INSERT INTO meq_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Gawla ŋgay hay tə gwaɗay: «Mə kəsaf nakay na, ka hutakweye wu mənday ɗa məvəlatay a ndo neheye haladzay aye na, məŋgay?» ");
INSERT INTO meq_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu a gwaɗatay: «Tapa i makwala andaya fakuma na, nday?» Ta mbəɗay faya, tə gwaɗay: «Tasəla. Ada kəlef wawa eye hay andaya tsakway dərmak.» ");
INSERT INTO meq_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tsa na, Yesu a gwaɗatay a ndo hay tâ ndza ka dala. ");
INSERT INTO meq_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yesu a həl tapa i makwala neheye tasəla aye tə kəlef niye hay, a gay naha sɨsœ a Mbəlom. A ŋgəna ha ada a vəlatay a gawla ŋgay. Tsa na, gawla ŋgay hay tə vəlatay a ndo hay. ");
INSERT INTO meq_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ndo hay tebiye tə nda ka mərehe andza nakə a satay aye. Tə hayay gər a siye neheye a ləkaw aye na, a rah a kəteh tasəla. ");
INSERT INTO meq_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ndo neheye tə nda wu mənday niye na, hasləka hay nəteye gwezem faɗ, ŋgwas hay ta wawa hay mə ɗəma bay. ");
INSERT INTO meq_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ma dəba eye na, Yesu a gwaɗatay a ndo hay: «Dum kurom a mətagay kurom hay tuk.» Neŋgeye a tsal a kwalalaŋ i yam, a ye ka dala i Magadan. ");
INSERT INTO meq_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisa hay ta Saduke hay ta həndzəɗ ka təv i Yesu. A satay məhəle faya abəra suwat. Ta tsətsah faya, tə gwaɗay: «Gamay masuwayaŋ nakə ma ɗiye ha ka yaw abəra ka təv i Mbəlom aye.» ");
INSERT INTO meq_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu a mbəɗatay faya, a gwaɗatay: «Nəkurom ka zəbum ka pat faya ma dəɗiye na, ka gwaɗum: “Tədœ na, pat ma dəviye lele hərwi mbəlom a zəba ndozza.” ");
INSERT INTO meq_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tə mekedœ pərik ka ŋgatumay mbəlom a zəba andza pat na, ka gwaɗum: “Bəgom na, yam ma piye.” Andza niye ka sərum maŋgəne ha ka bo abəra həlay nakə ma giye tə mazəbe ka mbəlom, ada wu neheye faya ta giye bo anəke aye a say məgweɗe mey na, ka sərum bay na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ndo neheye a həlay nakay na, nəteye seweɗ eye hay, nəteye ta mbəɗay dəba a Mbəlom, faya ta tsətsahiye masuwayaŋ. Ane tuk na, ma dəba i masuwayaŋ i Zonas ndo məɗe ha bazlam i Mbəlom nakə tə ŋgatay aye na, ta ŋgateye a masuwayaŋ mekeleŋ eye bay.» Tsa na, Yesu a gər tay ha, a ye ŋgway. ");
INSERT INTO meq_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesu ta gawla ŋgay hay tə tsal a kwalalaŋ i yam, ti ye ka dəlov, tə tas a diye neŋgeɗ. Ti ye na, ta mətsa ha gər ta məzle makwala ka həlay. ");
INSERT INTO meq_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu a gwaɗatay: «Gum metsehe! Tsəpum gər kurom abəra ka gəɗe i Farisa hay ta Saduke hay.» ");
INSERT INTO meq_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nəteye tə tsəne andza niye, tə kəɗ wuway mə walaŋ tay, tə gwaɗ: «A tsik andza niye na, hərwi nakə ka mətsakwa ha gər ta məzlaw makwala aye.» ");
INSERT INTO meq_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu a səratay naha ka wu nakə faya ta dzaliye faya aye, a gwaɗatay: «Nəkurom na, mədzal gər a kətsakum. Ka kəɗum wuway ka makwala na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Hus anəke ki yakum a mədzal gər kurom zuk bay ɗaw? Makwala tapa zlam, ndo hay gwezem zlam tə nda ada siye ka hayumay gər na, gwaŋ nday na, a makumaw a gər təbəɗew? ");
INSERT INTO meq_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ada makwala nakə tapa tasəla, ndo hay gwezem faɗ tə nda aye na, kə makumaw a gər bəɗaw? Ka hayumay gər a siye na, kəteh nday? ");
INSERT INTO meq_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Na gwaɗakum: Tsəpum gər kurom abəra ka gəɗe i Farisa hay ada i Saduke hay. Na tsikakum ka makwala bay na, ka sərum təbəɗew?» ");
INSERT INTO meq_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Gawla i Yesu hay tə sər ha tuk Yesu a tsikatay «Tsəpum gər kurom» na, abəra ka gəɗe nakə a kwasawa ha wu aye bay. Ane tuk na, ta tsəpiye gər tay na, abəra ka matətike i Farisa hay ta Saduke hay. ");
INSERT INTO meq_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ma dəba eye na, Yesu ta gawla ŋgay hay ti ye ka dala i Sezare Filipi. Tə ndisl a ɗəma na, a tsətsah ka gawla ŋgay hay, a gwaɗatay: «Ndo hay tə gwaɗ ka neŋ Wawa i Ndo na, neŋ way?» ");
INSERT INTO meq_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ta mbəɗay faya, tə gwaɗay: «Ndo mekeleŋ eye hay tə gwaɗ nəkar na, Yuhana madzəhuɓe ndo a yam. Ndo siye hay tə gwaɗ nəkar na, Eliya. Ndo siye hay sa na, tə gwaɗ nəkar Zeremi kəgəbay nəkar nəte mə walaŋ i siye i ndo məɗe ha bazlam i Mbəlom hay.» ");
INSERT INTO meq_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu a gwaɗatay: «Ada nəkurom ka gwaɗum i kurom, neŋ na, way?» ");
INSERT INTO meq_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoŋ Piyer a mbəɗay faya, a gwaɗay: «Nəkar na, Kəriste, Wawa i Mbəlom nakə ta sifa aye.» ");
INSERT INTO meq_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu a gwaɗay: «Məŋgwese ka gər yak Simoŋ wawa i Zonas hərwi maa ɗaka ha deɗek nakay na, ndo zezeŋ bay. Ane tuk na, maa ɗaka ha na, Bəba ga mə mbəlom. ");
INSERT INTO meq_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Neŋ faya na gwaɗakeye: Nəkar na, Piyer, andza məgweɗe pəlaɗ. Na hayay gər a ndo ga hay na, ka pəlaɗ eye nakay andza pəlaɗ nakə ta ɗəzliye faya gay aye. Gədaŋ i mədahaŋ ma sliye məgatay wuray kwa tsekweŋ bay. ");
INSERT INTO meq_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Na vəlakeye kəle i mahəndəke məgeɗ i Bəy i Mbəlom. Wu nakə ka kərah ka məndzibəra aye na, ta kərahiye mə mbəlom. Wu nakə ka təma ka məndzibəra aye na, ta təmiye mə mbəlom.» ");
INSERT INTO meq_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tsa na, Yesu a gatay me a gawla ŋgay hay lele, a gwaɗatay: «Neŋ na, Kəriste, kâ tsikumay a ndəray bay.» ");
INSERT INTO meq_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Yesu a dazlay məɗatay ha a gawla ŋgay hay parakka, a gwaɗatay: «Kutoŋ na diye a Zerozelem ada madugula i Yahuda hay, bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta ndo neheye tə dzaŋgawa bazlam i Mbəlom mapala eye ta seŋeye ɗəretsətseh. Ta kəɗiye ga ada məhəne sulo mamahkar eye na, na lətseweye abəra ma mədahaŋ.» ");
INSERT INTO meq_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piyer a zalay a Yesu kətsah mahəŋgeye, a gay me, a gwaɗay: «Bəy Maduweŋ, Mbəlom mâ tsəpa kar. Ta deɗek wuray ma gakeye bay.» ");
INSERT INTO meq_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ane tuk na, Yesu a mbəɗa me, a gwaɗay a Piyer: «Do abəra ka təv ga! Do a dəba, nəkar na, Fakalaw. Faya ka ŋgiye fagaya ɓalay. Ka dzala gər andza Mbəlom bay, ka dzala gər na, andza i ndo zezeŋ.» ");
INSERT INTO meq_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesu a gwaɗatay a gawla ŋgay hay sa: «A say a ndoweye məpeŋ bəzay na, mâ gər ha wu nakə a say a ɗərev ŋgay aye. Mâ zla mayako mazləlmbaɗa eye ada mâ peŋ bəzay. ");
INSERT INTO meq_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Andza niye, ndo nakə a say mətəme ha məsəfəre ŋgay aye na, ma dziye ha ɗuh. Ane tuk na, ndo nakə ma dziye ha məsəfəre ŋgay hərwi ga aye na, ma hutiye na ɗuh. ");
INSERT INTO meq_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Taɗə ndoweye kə huta zlele i məndzibəra tebiye a neŋgeye, ane tuk na, kə dze ha məsəfəre ŋgay na, ŋgama eye na, mey? Wu andaya nakə ndo ma sliye mambəɗa ahaya məsəfəre ŋgay na, mey? ");
INSERT INTO meq_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Neŋ Wawa i Ndo na deyeweye ta gawla i Mbəlom hay ma məzlaɓ i Bəba ga. Na yaw na, na vəleye kwa a way wu i madagər ŋgay andza məsler ŋgay neheye a ge aye. ");
INSERT INTO meq_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Neŋ faya na gwaɗakumeye: Sərum ha na, ndo siye hay mə walaŋ kurom neheye anəke kanaŋ aye na, ta mətiye zuk bay, ta ŋgeteŋeye a neŋ Wawa i Ndo, na deyeweye andza bəy təday.» ");
INSERT INTO meq_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ma dəba i məhəne məkwa na, Yesu a zla Piyer, Yakuba ada Yuhana malamar i Yakuba. A ye tay ha a gər i mahəmba zəbol eye, dəreŋ abəra ta ndo hay. ");
INSERT INTO meq_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mə ɗəma na, Yesu a mbəɗa ka ɗəre tay. Ɗəre ŋgay a dəv andza pat, ada petekeɗ ŋgay hay ta təra herre kuɗekuɗek a dəv dzaydzay. ");
INSERT INTO meq_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kwayaŋŋa gawla i Yesu neheye mahkar aye tə ŋgatatay a Musa ta Eliya nəteye faya ta tsikiye me tə Yesu. ");
INSERT INTO meq_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tsa na, Piyer a gwaɗay a Yesu: «Bəy Maduweŋ, lele na, ndzakwa kanaŋ. Taɗə a saka na, na kəruwakumeye madzawadzawa mahkar, nəte i yak, nəte i Musa ada nəte i Eliya.» ");
INSERT INTO meq_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ahəl nakə Piyer faya ma tsikiye me mba aye na, pazlay herre a mbəzlaw fataya. Ma pazlay niye na, mətsike me a tsənew abəra mə ɗəma, a gwaɗ: «Nakay na, wawa ga. Na wuɗa na haladzay. Na ŋgwasa tə neŋgeye. Pumay zləm a wu nakə ma tsikakumeye.» ");
INSERT INTO meq_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Gawla i Yesu neheye mahkar aye tə tsəne andza niye na, tə dəɗ dəbuz dəbuz daʼar ka dala. Zluwer a gatay haladzay. ");
INSERT INTO meq_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu a həndzəɗ naha ka təv tay, a tətal fataya ada a gwaɗatay: «Lətsum! Zluwer mâ gakum bay.» ");
INSERT INTO meq_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Gawla i Yesu niye hay tə zla gər ka mbəlom, ta zəba ɗəre, tə ŋgatay na, a Yesu mahəŋgeye. ");
INSERT INTO meq_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ahəl nakə faya ta mbəzlaweye abəra mə mahəmba aye na, Yesu a gwaɗatay: «Wu nakə ka ŋgatumay aye na, kâ tsikumay a ndəray bay hus a pat nakə neŋ Wawa i Ndo na lətseweye abəra ma mədahaŋ aye.» ");
INSERT INTO meq_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tsa na, gawla ŋgay hay ta tsətsah faya, tə gwaɗay: «Ndo neheye tə dzaŋgawa bazlam i Mbəlom mapala eye tə gwaɗ na, Eliya ma lahaweye madayaw təday na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu a mbəɗatay faya, a gwaɗatay: «Deɗek, Eliya ma deyeweye ma lambaɗiye tay ha wu hay tebiye. ");
INSERT INTO meq_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ane tuk na, neŋ faya na tsikakumeye, Eliya na, ɓa ki yaw. Ndo hay ta sər na bay. Ta gay wu nakə a satay aye. Nəteye ta geŋeye ɗəretsətseh a neŋ Wawa i Ndo andza niye dərmak.» ");
INSERT INTO meq_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Gawla ŋgay hay tə tsəne i tay na, Yesu a tsikatay ka Yuhana madzəhuɓe ndo a yam. ");
INSERT INTO meq_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesu ta gawla ŋgay tə ndislew ka təv i ndo hay na, ndo wuray a həndzəɗ ka təv i Yesu, a ye naha a dəkway gurmets kame ŋgay. ");
INSERT INTO meq_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ada a gwaɗay: «Bəy Maduweŋ, wawa ga a gaka mə bo təbəɗew? Mahorvov a gay, faya ma geye ɗəretsətseh haladzay. A kalawa ha a ako kəgəbay a yam. ");
INSERT INTO meq_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na zlatayaw a gawla yak hay, ane tuk na, tə sla faya məmbəle ha bay.» ");
INSERT INTO meq_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu a gwaɗ: «Nəkurom neheye anəke, ka dzalum ha ka Mbəlom bay aye. Na ndziye ka təv kurom na, hadzəgay? Na zliye ŋgatay hərwi kurom məndze hadzəgay? Ahe! Zlumeŋ ahaya wawa eye kanaŋ!» ");
INSERT INTO meq_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tə zlay naha wawa niye. Yesu a gay me a məsəfəre nakə ŋgwalak eye bay aye. Tsa na, a ndohwaw abəra mə bo i wawa niye. Kwayaŋŋa wawa niye a mbəl. ");
INSERT INTO meq_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ahəl nakə Yesu ta gawla ŋgay hay, nəteye mahəteye na, gawla ŋgay hay ta həndzəɗ naha ka təv ŋgay, tə gwaɗay: «Ada nəmay na, nəmaa sla faya mahəhere məsəfəre nakay təbey na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu a mbəɗatay faya, a gwaɗatay: «Hərwi nakə ka dzalum ha ka neŋ haladzay bay aye. Neŋ faya na tsikakumeye, sərum ha taɗə məpe mədzal gər kurom mâ ge tsekweŋ andza wur i ɓəzaŋ na, ka slumeye məgwaɗay a mahəmba nakay: “Lətse abəra kanaŋ, do kataɗay.” Ma lətsiye, ma diye. Wuray kwa tsekweŋ ma dakumeye me bay.  ");
INSERT INTO meq_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ada slala i məsəfəre nakay ma ndohwaweye andza niye tsa bay. Ma ndohwaweye na, ma rəzlay a gər tə maɗuwule me ada ta daliyam.» ");
INSERT INTO meq_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Pat wuray na, Yesu ta gawla ŋgay hay, nəteye mahaya gər eye ma Galile. Yesu a gwaɗatay: «Neŋ Wawa i Ndo na, ta gəsiye ga, ta vəlateye ga ha a həlay a ndo hay. ");
INSERT INTO meq_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ta kəɗiye ga mədahaŋ eye, ada ma məhəne mamahkar eye na, na lətseweye abəra ma mədahaŋ.» Gawla ŋgay hay tə tsəne andza niye na, a ndalatay haladzay. ");
INSERT INTO meq_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ahəl nakə Yesu ta gawla ŋgay hay tə ndisl a Kafernahum aye na, ndo neheye tə hayaway gər a dzaŋgal i gay məvəlay wu a Mbəlom aye, ta həndzəɗ ka təv i Piyer, ta tsətsah faya, tə gwaɗay: «Miter kurom na, ma vəliye dzaŋgal i gay məvəlay wu a mbəlom təbəɗew?» ");
INSERT INTO meq_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piyer a mbəɗatay faya, a gwaɗatay: «Ma vəliye.» Tsa na, Piyer a ye a gay. A ye naha kwayaŋŋa Yesu a lah mətsikay me, a gwaɗay: «Simoŋ, ka dzala mə gər yak na, kəkay? Bəy i məndzibəra ma hutiye dzaŋgal tə wu nakə tə ɓar məvəle aye na, mə həlay i way? Mə həlay i ndo i dala eye niye hay tsukuɗu mə həlay i bərakəzaŋ hay ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piyer a mbəɗay faya, a gwaɗay: «Bərakəzaŋ hay.» Yesu a gwaɗay: «Ndo i dala eye niye hay ta vəliye bay. ");
INSERT INTO meq_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ane tuk na, vəlamatay bəna ma ndalateye. Hərwi niye zla wu məgəse kəlef yak, do ka me i dəlov. Ka ye na, kal a ɗəma wu məgəse kəlef. Kəlef nakə a lah faya aye na, gəs na ada kâ həndəkay ha bazlam. Ka hutiye kwar i suloy nəte mə ɗəma, zla ahaya ada kâ vəlamatay dzaŋgal may.» ");
INSERT INTO meq_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","A həlay niye na, gawla i Yesu hay ta həndzəɗ ka təv i Yesu, ta tsətsah faya, tə gwaɗay: «Mata təre bagwar eye ma Bəy i Mbəlom na, way?» ");
INSERT INTO meq_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu a tsəne andza niye na, a zalay a wawa, a lətse ha a wuzlah tay, ");
INSERT INTO meq_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","tsa na, a gwaɗatay: «Neŋ faya na tsikakumeye: Sərum ha na, taɗə ka mbəɗum ha mede kurom, ka tərum andza wawa nakay bay na, ka deyumeye a Bəy i Mbəlom bay. ");
INSERT INTO meq_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Taɗə ndoweye ka təra ha bo ŋgay wawa eye andza wawa nakay na, ma təriye bagwar eye ma Bəy i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ada ndoweye ka təma na wawa nakay lele andza wawa nakay anaŋ eye hərwi nakə a wuɗa ga aye na, a təma na neŋ. ");
INSERT INTO meq_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ndoweye ka səpat ndo nəte mə walaŋ i wawa neheye tə dzala ha ka neŋ aye a mezeleme na, ŋgama tâ ɓaray maɗiz i kwar a ɗay ada tâ kal ha a huɗ i bəlay.» ");
INSERT INTO meq_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Yesu a gwaɗatay sa: «Ɗəretsətseh ka gər i ndo i məndzibəra neheye faya ta səpatiye tay ha ndo hay a mezeleme aye. Ta deɗek, wu niye hay na, ma giye andaya huya. Ane tuk na, ɗəretsətseh ka gər i ndo nakə ma səpatiye ndo a mezeleme aye. ");
INSERT INTO meq_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Taɗə həlay yak kəgəbay sik yak ma diye kar ha a mezeleme na, ɗəs tay ha ada kuts tay ha dəreŋ tə nəkar. Ŋgama mede a sifa tə həlay yak nəte kəgəbay tə sik yak nəte tə bəmalə nakə ta kaliye kar ha a ako nakə ma mbatiye ɗaɗa bay tə həlay yak sulo kəgəbay tə sik yak sulo aye. ");
INSERT INTO meq_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Taɗə ɗəre yak ma diye kar ha a mezeleme na, ŋgwaɗ na ada kâ kal ha dəreŋ tə nəkar. Ŋgama mede a sifa tə ɗəre yak nəte tə bəmalə nakə ta kaliye kar ha a ako nakə ɗaɗa ma mbatiye bay tə ɗəre yak sulo aye.» ");
INSERT INTO meq_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yesu a gwaɗatay sa: «Gum metsehe! Kâ zəbum ka ndo neheye makətsa eye hay aye andza wu kəriye bay. Neŋ faya na gwaɗakumeye, gawla i Mbəlom tay hay nəteye andaya pat pat ka təv i Bəba ga mə mbəlom.  ");
INSERT INTO meq_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Hərwi neŋ Wawa i Ndo na yaw hərwi mətəme tay ha ndo neheye ta dze aye.» ");
INSERT INTO meq_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","A gwaɗatay sa: «Nəkurom ka dzalum na, kəkay? Taɗə ndo təɓaŋ ŋgay andaya temerre, ada nəte mə walaŋ i təɓaŋ niye a dze na, ma gəriye ha kuro kuro tsɨɗ gər eye tsɨɗ mə mahəmba, ma diye mapəla ahaya nakə a dze aye. ");
INSERT INTO meq_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Neŋ faya na tsikakumeye: Taɗə kə huta na na, ɗərev ŋgay ma ŋgwasiye haladzay hərwi təɓaŋ niye nəte aye a ze neheye kuro kuro tsɨɗ gər eye tsɨɗ ta dze təbey aye. ");
INSERT INTO meq_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Andza niye dərmak, Bəba kurom nakə mə mbəlom aye a say na, ndəray kway nəte mə walaŋ i ndo neheye makətsa eye mâ dze bay.» ");
INSERT INTO meq_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesu a gwaɗatay sa: «Taɗə malamar yak kə gaka mənese na, do ka təv ŋgay tsikay faya ahəl nakə nəkurom sulo tə neŋgeye aye. Taɗə ka təma bazlam yak na, kə təma ha abəra mə mezeleme. ");
INSERT INTO meq_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Taɗə ka təma bazlam yak bay na, dum ka təv ŋgay ta ndo nəte kəgəbay ta ndo sulo. Andza niye, maŋgəne ha sariya na, ta ndo hay sulo kəgəbay ndo hay mahkar. ");
INSERT INTO meq_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ane tuk na, ka təma bazlam kurom bay na, tsikatay a ndo məpe mədzal gər hay ka neŋ. Ka kərah bazlam i ndo məpe mədzal gər hay ka Kəriste na, gər ha zəba faya andza ndo nakə a sər Mbəlom bay aye kəgəbay andza ndo matsekele dzaŋgal. ");
INSERT INTO meq_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Neŋ faya na gwaɗakumeye: Sərum ha na, wu neheye tebiye ka kərahum ka məndzibəra aye na, ta kərahiye mə mbəlom dərmak. Wu neheye tebiye ka təmum ka məndzibəra aye na, ta təmiye mə mbəlom dərmak. ");
INSERT INTO meq_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Neŋ faya na gwaɗakumeye sa: Sərum ha na, taɗə ndo hay sulo ka məndzibəra ta dzapa ayaw ka wu nakə ta tsətsahiye tə maɗuwule me aye na, Bəba ga mə mbəlom ma vəlateye wu nakə ta tsətsah aye. ");
INSERT INTO meq_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Hərwi ndo sulo kəgəbay mahkar ta haya gər ka maɗuwulay me a Mbəlom ta məzele ga na, neŋ andaya mə walaŋ tay.» ");
INSERT INTO meq_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Piyer a həndzəɗ ka təv i Yesu, a tsətsah faya, a gwaɗay: «Bəy Maduweŋ, taɗə malamar ga kə geŋ mənese na, na pəsay ha sik nday? Madzəga tasəla ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu a gwaɗay: «Na gwaɗakeye madzəga tasəla bay, ane tuk na, sik kuro kuro tasəla madzəga tasəla. ");
INSERT INTO meq_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«Hərwi niye, Bəy i Mbəlom a ndzəkit bo ta bəy wuray a say matsətsehe gwedere ŋgay ka ndo məge məsler ŋgay hay. ");
INSERT INTO meq_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","A dazlay a məsler na, tə gəsay naha ndo i məsler ŋgay gwedere ŋgay faya suloy maliyoŋ haladzay a pasla bo bay. ");
INSERT INTO meq_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ndo niye na, wuray ŋgay andaya məheme ha gwedere niye bay. Bəy niye a gwaɗ ma səkəmiye ha andza beke, neŋgeye, ŋgwas ŋgay, wawa ŋgay hay tə wu ŋgay tebiye hərwi məheme ha gwedere ŋgay. ");
INSERT INTO meq_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ndo məge məsler ŋgay niye a dəkway gurmets, a gay amboh, a gwaɗay: “Amboh, zleŋ ŋgatay, na hamakeye suloy tebiye.” ");
INSERT INTO meq_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tsa na, a gay mə bo a bəy niye, a gəray ha gwedere niye ada a gər ha a ye ŋgway. ");
INSERT INTO meq_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Ndo məge məsler niye a ndohwaw abəra na, tə dzəgər ta mandala ŋgay nakə tə gawa məsler salamay aye. Gwedere ŋgay andaya ka mandala ŋgay niye kwar i suloy temerre. A gəs na ndo niye məmbərlew keeŋŋek, a gwaɗay: “Hemeŋ gwedere ga!” ");
INSERT INTO meq_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mandala ŋgay niye a dəkway gurmets, a gay amboh, a gwaɗay: “Zleŋ ŋgatay, na hamakeye.” ");
INSERT INTO meq_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ndo məge məsler niye a kərah. A gəs mandala ŋgay niye a kal ha a daŋgay. Ma ndziye mə ɗəma hus a pat nakə kə hamay gwedere ŋgay aye. ");
INSERT INTO meq_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Siye i ndo məge məsler i bəy niye tə ŋgatay a wu nakə a ge bo aye na, a ndalatay. Ti ye mata təkəray a ndo i gay tay. ");
INSERT INTO meq_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","«Ndo i gay tay a tsəne andza niye na, a zalay a ndo məge məsler ŋgay niye. A yaw na, a gwaɗay: “Nəkar na, ŋgwalak i ndo bay. Na gəraka ha gwedere ga tebiye hərwi nakə ka geŋ amboh aye. ");
INSERT INTO meq_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nəkar dərmak na, mandala yak mâ gaka mə bo andza nakə nəkar ka geŋ mə bo aye dərmak.” ");
INSERT INTO meq_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","A ndalay a ndo i gay tay haladzay. Tsa na, a slər ndo məge məsler ŋgay niye a daŋgay hərwi məgay ɗəretsətseh. Ma həbiye hus kə hama gwedere ka bo bəra tebiye.» ");
INSERT INTO meq_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu a gwaɗatay: «Taɗə kwa way kə pəsay ha mənese a malamar ŋgay peteh abəra mə ɗərev bay na, Bəba ga mə mbəlom ma giye kurom ha andza niye dərmak.» ");
INSERT INTO meq_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu a ndəv ha bazlam ŋgay niye hay na, a lətse abəra ka dala i Galile, a ye ka dala i Yahuda a diye neŋgeɗ i magayam i Yurdum. ");
INSERT INTO meq_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ndo hay mbərzəzza haladzay ta zəŋgal na. A mbəl tay ha ndo hay abəra ma ɗəvats tay hay. ");
INSERT INTO meq_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisa hay ta həndzəɗ ka təv i Yesu. A satay məhəle faya abəra suwat. Ta tsətsah faya, tə gwaɗay: «Bazlam kway mapala eye kə vəl tsəveɗ ka mahəhere ŋgwas hərwi kwa i wu waray waray ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu a mbəɗatay faya, a gwaɗatay: «Ka dzaŋgum wu nakə mawatsa eye mə Ɗerewel i Mbəlom aye təbəɗew? Ka madazlay na, Mbəlom a ge hasləka ada ŋgwas, ");
INSERT INTO meq_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ada a gwaɗ: “Hərwi niye hasləka ma gəriye ha bəba ŋgay ta may ŋgay, ta ndziye ta ŋgwas ŋgay. Ada nəteye ta təriye na, bo nəte.” ");
INSERT INTO meq_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Andza niye, nəteye sulo sa bay, ane tuk na, andza ndo nəte.» Yesu a gwaɗatay sa: «Ndo zezeŋ mâ ŋgəna ha wu nakə Mbəlom a dzapa ha aye bay.» ");
INSERT INTO meq_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farisa hay tə gwaɗay: «Musa a gwaɗ hasləka ma ta həhariye na ŋgwas ŋgay na, mâ watsay ɗerewel i mahəhere a həlay a ŋgwas ŋgay. Ada a tsik andza niye na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu a mbəɗatay fay, a gwaɗatay: «Musa a vəlakum tsəveɗ ka mahəhere ŋgwas kurom hay na, hərwi ɗərev kurom makula eye toŋgwa toŋgwa. Ane tuk na, ka madazlay na, andza niye bay. ");
INSERT INTO meq_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Neŋ faya na tsikakumeye, kwa way ka həhar na ŋgwas ze məndzay a gər ka məge madama na, ada kə zla a ɗəma ŋgwas mekeleŋ eye na, kə ge madama.» ");
INSERT INTO meq_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Gawla ŋgay hay tə gwaɗay: «Taɗə bazlam i hasləka ta ŋgwas andza niye na, ŋgama məzle ŋgwas bay.» ");
INSERT INTO meq_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu a mbəɗatay faya, a gwaɗatay: «Ndo hay tebiye ta sliye faya matəme matətike nakay bay. Ane tuk na, Mbəlom ma vəlateye gədaŋ a siye hay matəme. ");
INSERT INTO meq_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ndo siye hay tə sla faya məzle ŋgwas bay na, hərwi wu mekeleŋ eye hay wal wal. Ndo siye hay tə wa tay ha andza niye, bo tay a say ŋgwas bay. Ndo siye hay na, ta daɗak tay ha hərwi ada tâ zla ŋgwas bay. Siye hay ta zla ŋgwas bay na, hərwi Bəy i Mbəlom. Ndo nakə kə sla faya matəme matətike nakay aye na, mâ təma.» ");
INSERT INTO meq_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ma dəba eye na, ndo hay tə həl naha wawa hay ka təv i Yesu hərwi ada mâ pa fataya həlay ada mâ ɗuwulay me a Mbəlom hərwi tay. Ane tuk na, gawla ŋgay hay tə ŋgatatay a ndo hay faya ta həliye naha wawa hay ka təv i Yesu na, tə gatay me. ");
INSERT INTO meq_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu a gwaɗatay: «Gərum tay ha wawa hay tâ yaw ka təv ga. Kâ həharum tay ha bay, hərwi Bəy i Mbəlom mavəla eye na, a slala i ndo neheye andza wawa neheye.» ");
INSERT INTO meq_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yesu a pa həlay ka wawa niye hay hərwi məpe fataya ŋgama. Tsa na, a ye ŋgway abəra ka təv niye. ");
INSERT INTO meq_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ndo wuray a yaw ka təv i Yesu, a tsətsah, a gwaɗay: «Miter, na giye wu ŋgwalak eye na, mey nakə ada na hutiye sifa nakə ma ndəviye bay aye?» ");
INSERT INTO meq_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu a mbəɗay faya, a gwaɗay: «Ka tsətsahiye fagaya wu ka gər i wu ŋgwalak eye na, hərwi mey? Ndo ŋgwalak eye na, Mbəlom nəte ŋgweŋ. Taɗə a saka məhute sifa ka təv i Mbəlom na, rəhay ha gər a bazlam ŋgay mapala eye.» ");
INSERT INTO meq_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ndo niye a tsətsah ka Yesu: «Bazlam mapala eye waray hay?» Yesu a mbəɗay faya, a gwaɗay: «Kâ kəɗ gər i ndo bay, kâ ge madama bay, kâ ge məkal bay, kâ raw me ka ndo kame i sariya bay, ");
INSERT INTO meq_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","rəhatay ha gər a bəba yak ta may yak. Ada wuɗa ndo i məgeɗ yak dərmak andza ka wuɗa na gər yak.» ");
INSERT INTO meq_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Gawla niye a gwaɗay a Yesu: «Bazlam neheye mapala eye na rəhay ha gər tebiye. Maa ləkeŋew məge na, sa mey?» ");
INSERT INTO meq_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu a gwaɗay: «Kə saka matəre ndo ŋgwalak eye na, do ta səkəm ha wu yak ada kâ ŋgənatay suloy aye a ndo mətawak eye hay. Ka ge andza niye na, ka hutiye zlele mə mbəlom. Tsa na, dara peŋ bəzay.» ");
INSERT INTO meq_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Gawla niye a tsəne andza niye na, a ye ŋgway ta mevel eye hərwi zlele ŋgay na, haladzay. ");
INSERT INTO meq_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu a gwaɗatay a gawla ŋgay hay: «Neŋ faya na gwaɗakumeye, sərum ha, mawura bo eye hərwi ndo i zlele hay mede a Bəy i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ada neŋ faya na gwaɗakumeye anaŋ sa: Tə bəmalə nakə ndo i zlele ma diye a Bəy i Mbəlom aye na, ŋgama zləgweme mâ ye ta bəɗ i ləpəre.» ");
INSERT INTO meq_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Gawla ŋgay hay tə tsəne bazlam ŋgay niye hay andza niye na, a gatay hərɓaɓəkka, tə gwaɗ: «Ane tuk na, kə ge andza niye na, mata sle mətəme na, way?» ");
INSERT INTO meq_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu a zəba fataya, a gwaɗatay: «Ndəray ma sliye mətəme bay, ane tuk na, Mbəlom na, wuray a zay gədaŋ təbey.» ");
INSERT INTO meq_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Piyer a mbəɗay naha faya, a gwaɗay: «Tsəne! Nəmay anaŋ, nəmaa gər ha wu hay tebiye hərwi məpaka bəzay na, kəkay? Mata ge bo tə nəmay na, mey?» ");
INSERT INTO meq_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu a gwaɗatay: «Neŋ faya na gwaɗakumeye: Sərum ha na, neŋ Wawa i Ndo na ndziye ka təv məndze i bəy ta məzlaɓ ma məndzibəra weɗeye. Nəkurom neheye ka pumeŋ bəzay aye, ka ndzumeye ka təv məndze i bəy kuro gər eye sulo dərmak hərwi məgatay sariya a gwala i Israyel hay kuro gər eye sulo. ");
INSERT INTO meq_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ada ndo neheye tebiye tə gər ha gay tay, malamar tay hasləka eye hay ta malamar tay dem eye hay, bəba tay, may tay, wawa tay hay, guvah tay hay hərwi məzele ga aye na, ta hutiye a ɗəma ma ziye madzəga temerre ada ta hutiye sifa nakə ma ndəviye bay aye. ");
INSERT INTO meq_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mə walaŋ i ndo neheye anəke nəteye ndo i me hay aye na, haladzay ta təriye ndo i dəba ada mə walaŋ i ndo neheye anəke nəteye ndo i dəba hay aye na, haladzay ta təriye ndo i me.» ");
INSERT INTO meq_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Bəy i Mbəlom a ndzəkit bo na, ndo wuray a ndohwaw abəra mə gay mekedœ pərik hərwi mapəle ndo məge məsler hay a guvah ŋgay. ");
INSERT INTO meq_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tə ge tsakala i məfəte hwapat na, kwar i suloy nəte. ");
INSERT INTO meq_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ta ɓəre tsɨɗ i mekedœ na, a ye sa. A ye a ndzatay a gər a siye hay faya ta giye məsler bay, nəteye malətsa eye kəriye. ");
INSERT INTO meq_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","A gwaɗatay: “Nəkurom dərmak dum fətumeŋ guvah ga, na vəlakumeye wu i madagər kurom lele.” ");
INSERT INTO meq_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ndo niye hay tə tsəne andza niye na, ti ye a guvah ŋgay niye. Ndo niye a ye mapəle ndo i məsler hay ta magərhəpat, ada ta ɓəre mahkar i huwa a ge andza niye sa. ");
INSERT INTO meq_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ta ɓəre zləm na, a ye sa. A ye a huta ndo hay nəteye malətsa eye. A tsətsah fataya, a gwaɗatay: “Nəkurom mandza eye kanaŋ hwapat ze məge məsler na, hərwi mey?” ");
INSERT INTO meq_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ta mbəɗay faya, tə gwaɗay: “Hərwi ndəray kə həl may a məsler bay.” A gwaɗatay: “Nəkurom dərmak dumara, dum a guvah ga.” ");
INSERT INTO meq_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Huwa a ge na, ndo i guvah a zalay a ndo mələvay gər a məsler ŋgay, a gwaɗay: “Zalatay a ndo məge məsler hay, vəlatay wu i madagər tay. Dazlay ta ndo neheye na həl tay duk aye ada kâ ndəv ha ta ndo neheye na lah məhəle tay kurre aye.” ");
INSERT INTO meq_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ndo neheye ta dazlay a məsler ta ɓəre zləm i huwa aye na, ti ye naha kwa way a təma kwar i suloy nəte. ");
INSERT INTO meq_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ndo neheye ta dazlay kurre aye ti yaw. Tə dzala mə gər tay na, ta təmiye ma ziye i ndo neheye. Ane tuk na, tə vəlatay kwa way kwar i suloy nəte. ");
INSERT INTO meq_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ta təma na, ta guŋguz ka ndo i guvah, ");
INSERT INTO meq_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","tə gwaɗ: “Ndo neheye ti yaw ma dəba may aye, tə ge məsler na, ɓəre nəte tsa tuk na, ada ka vəlamay wu madagər may andza i tay na, kəkay? Nəmay na, nəmaa sa ɗəretsətseh mə pat hwapat ada nəmaa səmay naha a merəɓe.” ");
INSERT INTO meq_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ndo i guvah niye a mbəɗay faya a ndo nəte mə walaŋ tay, a gwaɗay: “Dzam ga, na gaka mənese bay. Ka gama tsakala i məge məsler pat eye nəte na, kwar i suloy nəte bəɗaw? ");
INSERT INTO meq_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Zla wu i madagər, do. A seŋ na vəliye a ndo nakə a yaw ma dəba yak andza nakə na vəlaka aye dərmak. ");
INSERT INTO meq_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Neŋ na, tsəveɗ ga andaya məge wu nakə a seŋ aye ta suloy ga. Kəgəbay nəkar na, sələk eye hərwi nakə neŋ ŋgwalak i ndo aye ɗaw?” ");
INSERT INTO meq_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Andza niye, ndo i dəba hay ta təriye ndo i me hay, ndo i me hay ta təriye ndo i dəba hay.» ");
INSERT INTO meq_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ahəl nakə Yesu faya ma diye a Zerozelem aye na, a həl gawla ŋgay hay kuro gər eye sulo təv tay wal. Nəteye faya ta diye ka tsəveɗ na, a gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Tsənum, anəke na, faya ka deyekweye a Zerozelem. Mə ɗəma na, neŋ Wawa i Ndo ta vəlateye ga ha a həlay a bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ada a ndo neheye tə dzaŋgawa bazlam i Mbəlom mapala eye. Ta geŋeye sariya i məkəɗe, ");
INSERT INTO meq_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ada ta vəlateye ga ha a ndo neheye tə sər Mbəlom bay aye. Ta ŋgweseŋeye dəla abəra mə gər, ta ndaɓiye ga ta mandalaɓa. Ta dariye ga ka mayako mazləlmbaɗa eye. Ma məhəne mamahkar eye na, na lətseweye abəra ma mədahaŋ.» ");
INSERT INTO meq_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ma dəba eye na, ŋgwas i Dzebede a ye ka təv i Yesu ta wawa ŋgay hay. A ye naha a dəkw gurmets kame i Yesu hərwi matsətsehe faya wu. ");
INSERT INTO meq_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu a gwaɗay: «A saka mey?» A mbəɗay faya a Yesu, a gwaɗay: «Na tsətsah fakaya na, aza ahəl nakə ka ndza a bəy yak aye na, vəlatay tsəveɗ a wawa ga neheye sulo aye tâ ndza ka təv yak, nəte ta diye i həlay i mənday ada neŋgeɗ ta diye i həlay i gula yak tey.» ");
INSERT INTO meq_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu a mbəɗay faya, a gwaɗay: «Ka sərum wu nakə ka tsətsahumeye aye bay. Ka slumeye faya məse ɗəretsətseh nakə na siye aye ɗaw?» Ta mbəɗay faya, tə gwaɗay: «Nəmaa sliye faya.» ");
INSERT INTO meq_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu a gwaɗatay: «Deɗek, ka sumeye ɗəretsətseh andza neŋ nakə na siye ɗəretsətseh aye. Ane tuk na, məndze ta diye i həlay i mənday ga kəgəbay ta diye i həlay i gula ga na, mata tsike na, neŋ bay. Təv məndze niye na, i ndo neheye Bəba ga a ləvatay ha bo aye wu tay.» ");
INSERT INTO meq_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Siye i gawla i Yesu hay kuro, tə tsəne bazlam niye na, tə ge mevel ka gawla i Yesu neheye sulo ta malamar ŋgay aye. ");
INSERT INTO meq_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesu a zalatay tebiye ka təv ŋgay, a gwaɗatay: «Nəkurom ka sərum ha na, bəy bagwar eye ka məndzibəra faya ta ləviye ndo hay ta gədaŋ ada ndo bagwar eye hay ta ɓərəkiye ha gədaŋ tay ka siye i ndo hay. ");
INSERT INTO meq_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ane tuk na, mâ ge andza niye mə walaŋ kurom bay. Ɗuh na, kə ge ndəray mə walaŋ kurom a say matəre bagwar eye na, mâ təra ndo i məsler kurom. ");
INSERT INTO meq_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kə ge ndəray mə walaŋ kurom a say matəre ndo i me na, mâ təra beke kurom. ");
INSERT INTO meq_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Andza niye, neŋ Wawa i Ndo na yaw na, hərwi ada ndo hay tâ geŋ məsler bay. Na yaw ɗuh na, hərwi məgatay məsler a ndo hay ada məvəle ha məsəfəre ga hərwi məmbəle tay ha ndo hay haladzay.» ");
INSERT INTO meq_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ahəl nakə Yesu ta gawla ŋgay hay ti yaw abəra ma Zeriko aye na, ndo hay haladzay tə payaw bəzay. ");
INSERT INTO meq_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Guluf hay sulo nəteye mandza eye ka tsakay i tsəveɗ. Tə tsəne Yesu faya ma diye ta tsəveɗ eye niye na, tə pa bo ka mawude, tə gwaɗ: «Bəy Maduweŋ, Wawa i Davit, nəmaâ gaka mə bo təbəɗew?» ");
INSERT INTO meq_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ndo hay tə gatay me hərwi ada tâ ndza ɗikɗik, ane tuk na, tə zaka ha mawude haladzay, tə gwaɗ: «Bəy Maduweŋ, Wawa i Davit, nəmaâ gaka mə bo təbəɗew?» ");
INSERT INTO meq_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu a lətse, a zalatay, a tsətsah fataya: «A sakum nâ ge hərwi kurom na, mey?» ");
INSERT INTO meq_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ta mbəɗay faya, tə gwaɗay: «Bəy Maduweŋ, a samay na, həndəkamay na ɗəre tey.» ");
INSERT INTO meq_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu a tsəne andza niye na, tə gay mə bo. A lamay a ɗəre tay, kwayaŋŋa ndo neheye sulo aye tə ŋgatay a ɗəre. Tsa na, tə pay bəzay a Yesu. ");
INSERT INTO meq_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu ta gawla ŋgay hay, nəteye mazlambar bəse ta Zerozelem na, tə ndisl a gəma i Betifadze ka Mahəmba i Tetəɗœz. Yesu a slər gawla ŋgay sulo kame, a gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«Dum naha a gəma nakə kame kurom aye. Ka ndislum naha na, ka ndzumeye a gər a zuŋgo ta wawa ŋgay maɓara eye. Pəluma tay ahaya ada kâ yumeŋa tay ahaya. ");
INSERT INTO meq_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Taɗə ta tsikakum wuray na, mbəɗumatay faya: “A say a Bəy Maduweŋ.” Tsa na, ta gəriye kurom ha.» ");
INSERT INTO meq_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Wu nakay a ge bo na, andza i ndo məɗe ha bazlam i Mbəlom nakə a tsik aye, a gwaɗ: ");
INSERT INTO meq_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Gwaɗumatay a ndo neheye ma gəma i Zerozelem aye: Zəba, bəy yak faya ma diye naha ka təv yak! Neŋgeye maləɓa eye, neŋgeye mandza eye ka zuŋgo ada ka zuŋgo wawa eye.» ");
INSERT INTO meq_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Gawla i Yesu neheye sulo aye, ti ye tə ge andza nakə Yesu a tsikatay aye. ");
INSERT INTO meq_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ti ye, tə gəsaw zuŋgo niye ta wawa eye salamay. Ti ye ahaya, tə pa fataya petekeɗ hay ada Yesu a ndza faya. ");
INSERT INTO meq_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ndo hay haladzay mbərzəzza ta fətəl petekeɗ tay hay ka tsəveɗ, siye hay tə həɓaw slambah i dərizl i gərɗaf hay ta fətəl ka tsəveɗ. ");
INSERT INTO meq_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ndo neheye kame i Yesu ta ndo neheye ma dəba ŋgay aye na, ta wuda, tə gwaɗ: «Zambaɗakway a Wawa i Davit! Mbəlom mâ pa ŋgama ka ndo nakə faya ma deyeweye ta məzele i Bəy Maduweŋ aye. Zambaɗakway a Mbəlom, neŋgeye nakə mə mbəlom aye!» ");
INSERT INTO meq_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ahəl nakə Yesu a ndisl a Zerozelem aye na, a gatay a ndo neheye ma wuzlahgəma aye wadəŋ wadəŋ. Ta tsətsah, tə gwaɗ: «Ndo nakay na, way?» ");
INSERT INTO meq_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ndo hay ta mbəɗatay faya: «Yesu, ndo məɗe ha bazlam i Mbəlom, neŋgeye ndo i Nazaret ka dala i Galile.» ");
INSERT INTO meq_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu a ndisl a Zerozelem na, a ye a dalamətagay i gay i məɗəslay ha gər a Mbəlom. A ye naha na, a həhar tay ha ndo masəkəme wu hay ta ndo neheye ta səkəmiye ha wu hay aye. A pay həlay a tabal i ndo mambəɗe ha suloy, a mbəzl ha təv məndze i ndo masəkəme ha bodobodo hay. ");
INSERT INTO meq_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tsa na, a gwaɗatay: «Mawatsa eye mə Ɗerewel i Mbəlom na: “Ta zaleye a gay ga na, gay i maɗuwule me. Ane tuk na, nəkurom ka tərum ha lar i məkal hay na, kəkay?”» ");
INSERT INTO meq_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Guluf hay ta ndo matəra eye hay, ti ye ka təv i Yesu a gay i məɗəslay ha gər a Mbəlom. Yesu a mbəl tay ha. ");
INSERT INTO meq_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta ndo neheye tə dzaŋgawa bazlam i Mbəlom mapala eye tə ŋgatay a masuwayaŋ nakə Yesu a ge aye ta mawude i wawa neheye faya ta wudiye mə gay i məɗəslay ha gər a Mbəlom: «Məzlaɓ mâ ndza ka Wawa i Davit» aye na, wu neheye a ndalatay haladzay. ");
INSERT INTO meq_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tə gwaɗay a Yesu: «Ka tsəne wu nakə wawa neheye faya ta tsikiye bəɗaw?» Yesu a mbəɗatay faya: «Ayaw, na tsəne. Nəkurom na, ka dzaŋgum bazlam nakə mawatsa eye mə Ɗerewel aye ɗaɗa təbəɗew? “A saka nakə wawa hay ada ta wawa neheye faya ta siye wah mba aye tâ zambaɗaka.”» ");
INSERT INTO meq_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tsa na, a gər tay ha, a yaw abəra ma wuzlahgəma, a ye a Betani, a həna mə ɗəma. ");
INSERT INTO meq_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tədœ eye pərik i mekedœ, ahəl nakə faya ma maweye a wuzlahgəma aye na, may a wur faya. ");
INSERT INTO meq_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","A ŋgatay a gurov ka tsakay i tsəveɗ. A ye a bəzay i dərizl i gərɗaf niye. Ane tuk na, a ŋgatay na, a slambah ɗekɗek, mawa eye bay. A gwaɗay a gurov niye: «Ka wiye hohway ɗaɗa sa bay.» Kwayaŋŋa gurov niye a kula. ");
INSERT INTO meq_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Gawla ŋgay hay tə ŋgatay andza niye, a gatay masuwayaŋ. Tə gwaɗay a Yesu: «Gurov nakay a kula kwayaŋŋa tsa na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu a gwaɗatay: «Neŋ faya na tsikakumeye: Sərum ha na, taɗə ka dzalum ha ka neŋ ada ka gum hay mədzal gər kurom gərəŋ gərəŋ bay na, ka slumeye faya məge wu nakə na gay a gurov nakay aye. Kwa a mahəmba, ka slumeye məgwaɗay: “Lətse abəra kanaŋ, ta kal ha bo a bəlay”, ada ma giye bo. ");
INSERT INTO meq_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Taɗə ka dzalum ha ka neŋ tə ɗərev kurom peteh na, ka hutumeye wu nakə ka tsətsahumeye tə maɗuwule me a Mbəlom aye tebiye.» ");
INSERT INTO meq_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu a ye, a fələkwa a gay i məɗəslay ha gər a Mbəlom. A ye naha a dazlay a matətikatay. Ahəl nakə faya ma tətikiye na, bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta madugula i Yahuda hay, ti ye naha ka təv ŋgay. Ta tsətsah faya, tə gwaɗay: «Ka ge wu neheye na, ta gədaŋ waray? Maa vəlaka gədaŋ aye na, way?» ");
INSERT INTO meq_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu a mbəɗatay faya, a gwaɗatay: «Neŋ dərmak na tsətsahiye fakuma matsətsehe nəte, taɗə ka mbəɗumeŋew faya na, na ge wu neheye ta gədaŋ waray na, na tsikakumeye. ");
INSERT INTO meq_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Maa slər ha Yuhana madzəhuɓe ndo a yam na, way? Mbəlom tsukuɗu, ndo hay ɗaw?» Tə ma ha ka bo bazlam mə walaŋ tay, tə gwaɗ: «Ka mbəɗakweye faya na, kəkay? Taɗə ka gwaɗakway, maa slər ha Mbəlom, Yesu ma gwaɗakweye: “Ka dzalum ha bay na, kemey?” ");
INSERT INTO meq_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ane tuk na, taɗə ka gwaɗakway, maa sləraw Yuhana na, ndo hay, dzədzarakwa ta ndo hay hərwi ndo hay tebiye ta dzala ha Yuhana neŋgeye ndo məɗe ha bazlam i Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hərwi niye ta mbəɗay faya a Yesu, tə gwaɗay: «Nəmaa sər bay.» Yesu a gwaɗatay: «Neŋ bəbay na ge wu neheye ta gədaŋ i way na, na tsikakumeye bay.» ");
INSERT INTO meq_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu a gwaɗ sa: «Ka dzalum ka dzeke nakay na, kəkay? Ndoweye andaya wawa ŋgay hay sulo. A gwaɗay a wawa makurre eye: “Wawa ga, do bəgom ta ge məsler ma guvah.” ");
INSERT INTO meq_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wawa ŋgay a mbəɗay faya, a gwaɗay: “Na diye bay.” Məndze tsekweŋ na, a dzala ha ka bazlam ŋgay niye, a ye a guvah. ");
INSERT INTO meq_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Bəba a ye ka təv i wawa masulo eye a tsikay andza niye sa. Wawa ŋgay a mbəɗay faya, a gwaɗay: “Bəba ga, na diye.” Ane tuk na, ki ye bay. ");
INSERT INTO meq_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mə walaŋ i wawa neheye sulo aye, maa ge wu nakə a say a bəba ŋgay aye na, waray?» Ta mbəɗay faya, tə gwaɗay: «Wawa makurre eye.» Yesu a gwaɗatay: «Neŋ faya na tsikakumeye, sərum ha ndo matsekele dzaŋgal hay ta ŋgwas neheye tə gawa madama aye ta lahakumeye a Bəy i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yuhana madzəhuɓe ndo a yam ki yaw kə ɗakum ha tsəveɗ deɗek eye. Ka dzalum ha faya bay. Ɗuh ndo matsekele dzaŋgal ta ŋgwas neheye tə gawa madama aye ta dzala ha faya. Kwa ka ŋgatumay bəbay na, ka mbəɗum ha mədzal gər kurom hərwi mədzele ha faya bay.» ");
INSERT INTO meq_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tsənum dzeke mekeleŋ eye sa: «Ndoweye andaya a ɗəs guvah. A zəv a ɗəma dərizl i gərɗaf haladzay. Dərizl i gərɗaf niye hay na, tə wa hohway. A lawara na ta zleɗ, a ŋgar a ɗəma təgwaɗ hərwi maɗɨtse a ɗəma hohway ada a ɗəzl a ɗəma gay i matsəpe wu bagwar eye. Ma dəba eye a səkəmatay ha a ndo hay hərwi məve nəte. Tsa na, a ye a gəma mekeleŋ eye dəreŋ. ");
INSERT INTO meq_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","«Həlay i maŋgəle hohway i gərɗaf ŋgay niye hay a sla na, a slər ndo i məsler ŋgay hay ka təv i ndo neheye ta səkəm guvah ŋgay aye hərwi ada tâ vəlayaw hohway i gərɗaf ŋgay hay. ");
INSERT INTO meq_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ane tuk na, ndo niye hay, tə ŋgatatay na, tə gəs makurre eye tə ndaɓa na lele. Tə gəs masulo eye, tə kəɗ na mədahaŋ eye ada tə kəɗ mamahkar eye tə kwar. ");
INSERT INTO meq_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ndo i guvah a slər ndo i məsler mekeleŋ eye hay, nəteye haladzay ta ze neheye kurre aye. Ane tuk na, ndo niye hay tə ge tay andza neheye kurre eye. ");
INSERT INTO meq_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ka mandəve ŋgay eye na, a slər wawa ŋgay. A dzala, a gwaɗ: “Wawa ga na, ta rəhay ha gər, ta geye wuray bay.” ");
INSERT INTO meq_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ane tuk na, ndo niye hay, tə ŋgatay a wawa i ndo i guvah na, tə gwaɗ mə walaŋ tay: “Anaŋ magedze ŋgay nakə ma ta ndiye na guvah ŋgay aye, ki yaw! Takwa, kəɗakwa na ada guvah nakay ma mətsakweye a nəkway!” ");
INSERT INTO meq_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ti ye tə gəs wawa niye, ti ye ha dəreŋ ta guvah. Ti ye naha, tə kəɗ na.» ");
INSERT INTO meq_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu a tsətsah fataya a gwaɗatay: «Ndo i guvah ki yaw na, ma giye tay ha ndo neheye na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ta mbəɗay faya, tə gwaɗay: «Ma kəɗiye ndo məkəɗe ndo niye hay abəra mə ɗəma, ma sakatay naha bay tebiye. Ma həliye a ɗəma ndo mekeleŋ eye hay ada ta vəleye hohway i gərɗaf ŋgay hay a həlay nakə kə nah aye.» ");
INSERT INTO meq_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tsa na, Yesu a gwaɗatay: «Ɗaɗa ka dzaŋgum wu nakə tə watsa a Ɗerewel i Mbəlom aye təbəɗew? A gwaɗ: “Kwar nakə ndo maɗəzle gay hay tə kal ha aye na, matəra kwar lele eye a ze siye i kwar hay na, neŋgeye ɗuh. Maa gwaɗ kwar niye matəra kwar nakə lele eye hərwi maɗəzle gay na, Mbəlom. Niye na, məsler i Mbəlom hərwi kway.”» ");
INSERT INTO meq_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesu a gwaɗatay sa: «Neŋ faya na tsikakumeye, nəkurom na, ta zliye fakuma abəra Bəy i Mbəlom ta vəlay ha a ndo mekeleŋ eye hay neheye faya ta giye wu nakə a say aye. ");
INSERT INTO meq_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kwa way kə dəɗ ka kwar niye na, ma toliye. Ada kwar niye kə dəɗ ka ndoweye na, ma ləgəriye na kərɗik kərɗik andza mereɓek.» ");
INSERT INTO meq_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta Farisa hay tə tsəne dzeke i Yesu niye hay na, tə sər a tsik ka nəteye. ");
INSERT INTO meq_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ta pəla tsəveɗ məgəse na. Ane tuk na, ta dzədzaratay a ndo hay hərwi ndo hay tə dzala Yesu na, ndo məɗe ha bazlam i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu a tsikatay dzeke mekeleŋ eye sa, a gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Bəy i Mbəlom a ndzəkit bo na, anaŋ andza nakay. Bəy a ge magurlom i mabəzləme gər i dahəlay i wawa ŋgay. ");
INSERT INTO meq_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","A slər gawla ŋgay hay, tâ ye tâ zalatayaw a ndo hay tâ yaw tâ nda ɗaf i mabəzləme gər i dahəlay. Ane tuk na, ndo neheye tə zalatay aye na, ta kərah mede. ");
INSERT INTO meq_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","A slər gawla ŋgay mekeleŋ eye hay sa. A gwaɗatay: “Dum, gwaɗumatay a ndo neheye na zalatay aye na, tâ yaw. Na da wu mənday anəke, na kəɗ gəsaŋ i sla ga hay ta neheye magəla eye hay lele aye na kəɗ, wu hay maləva bo eye tsɨy. Dumara a mənde ɗaf i mabəzləme gər i dahəlay.” ");
INSERT INTO meq_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ane tuk na, ndo neheye tə zalatay aye na, ta pa zləm ka bazlam tay niye bay. Ti ye ka məge məsler tay hay. Ndo neŋgeɗ a ye a guvah, ndo mekeleŋ eye a ye masəkəme ha wu ŋgay hay. ");
INSERT INTO meq_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ndo siye hay tə gəs tay hay gawla i ndo niye, tə gatay ɗəretsətseh, tə kəɗ tay ha mədahaŋ eye hay. ");
INSERT INTO meq_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","«Bəy niye a tsəne andza niye na, a ndalay. A slər sidzew hay, ti ye ka mabəbazl tay ada tə mədzay ako a gəma tay. ");
INSERT INTO meq_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tsa na, a gwaɗatay a ndo i məsler ŋgay hay: “Ɗaf i mabəzləme gər i dahəlay mada eye haladzay, ane tuk na, ndo neheye na zalatay aye na, ta sla mənde bay. ");
INSERT INTO meq_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hərwi niye, dum ka tsəveɗ bagwar eye hay, zalumatayaw a ndo neheye ka ndzumatay a gər aye, tâ yaw ka mənde ɗaf.” ");
INSERT INTO meq_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ndo i məsler ŋgay hay ti ye. Ti ye naha tə hayay gər a ndo neheye tə ndzatay a gər aye tebiye, ndo ŋgwalak eye hay ta ndo neheye ŋgwalak eye bay aye. Gay i magurlom a rah ta ndo hay. ");
INSERT INTO meq_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Bəy a fələkwa a gay hərwi mazəbe ka ndo neheye a zalatay aye tuk. A ye naha a ŋgatay a ndo nəte petekeɗ i magurlom i mabəzləme gər i dahəlay andaya faya bay. ");
INSERT INTO meq_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","A gwaɗay: “Dzam ga, petekeɗ i magurlom i mabəzləme gər i dahəlay andaya fakaya bay sa na, ka fələkwaw kanaŋ ma kəkay?” Ane tuk na, ndo niye ka mbəɗay faya bay. ");
INSERT INTO meq_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tsa na, bəy a gwaɗatay a ndo i məsler ŋgay hay: “Dum naha, dzawumay na həlay tə sik, kalum ha abəra a ləvoŋ. Mə ɗəma na, ta tuwiye tə mahəpəɗe zler eye.”» ");
INSERT INTO meq_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Andza niye, Yesu a gwaɗ: «Ndo hay haladzay mazala eye hay, ane tuk na, ndo neheye tə pala tay ha aye na, nəteye haladzay bay.» ");
INSERT INTO meq_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisa hay ti ye, tə haya gər. Tə ma ha ka bo bazlam mə walaŋ tay hərwi mapəle tsəveɗ ma kəkay nakə ta həliye suwat abəra ka Yesu tə matsətsehe faya abəra bazlam aye. ");
INSERT INTO meq_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ta ndəv ha məhay gər na, tə slər siye i ndo hay mə walaŋ i gawla tay hay ta siye i ndo i Herod ka təv i Yesu. Ti ye naha, tə gwaɗay: «Miter, nəmaa sər ha nəkar, ka tsik na, deɗek. Nəkar faya ka tətikateye a ndo hay deɗek ka mede nakə a say a Mbəlom aye. Ka dzədzaray a wu nakə ndo hay ta dzaliye təbey ada ka ŋgəna tay ha ka bo bəra ndo hay təbey. ");
INSERT INTO meq_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Hərwi niye, tsikamay wu nakə ka dzala faya aye: Bazlam kway mapala eye kə vəl tsəveɗ məvəle dzaŋgal a bəy i Roma tsukuɗu kə vəl tsəveɗ məvəle bay ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ane tuk na, Yesu a sər tay naha ka mədzal gər tay nakə ŋgwalak eye bay aye. A gwaɗatay: «A nəkurom ndo i bəbərek hay, ka həlumeye fagaya abəra suwat na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ehey bəzumeŋ ha suloy nakə tə vəlawa dzaŋgal eye təday.» Tə zlayaw kwar suloy nəte, tə vəlay. ");
INSERT INTO meq_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tsa na, Yesu a gwaɗatay: «Mandzəkit bo nakay ta məzele nakay faya na, i way?» ");
INSERT INTO meq_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ta mbəɗay faya, tə gwaɗay: «I bəy i Roma.» Yesu a gwaɗatay: «Aya! Wu i bəy i Roma na, vəlumay ha a bəy i Roma ŋgway. Wu i Mbəlom na, vəlumay ha a Mbəlom ŋgway.» ");
INSERT INTO meq_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tə tsəne andza niye na, a matay ha hərɓaɓəkka. Tə gər ha Yesu, ti ye wu tay. ");
INSERT INTO meq_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Pat eye niye, Saduke hay ti ye ka təv i Yesu. Azlakwa bay Saduke hay na, nəteye tə dzala ha tə gwaɗ: «Ka mət na, mələtsew abəra ma mədahaŋ andaya sa bay.» Ta tsətsah ka Yesu, tə gwaɗay: ");
INSERT INTO meq_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Miter, Musa a gwaɗ: “Taɗə ndoweye a mət ze məwe wawa na, malamar ŋgay mâ zla madakway i ŋgwas niye. Ma zliye na, hərwi ada hulfe i ndo niye a mət aye mâ dze bay.” ");
INSERT INTO meq_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ndo hay andaya nəteye tasəla ta malamar hay. Malamar tay makurre eye a zla dahəlay. A mət ze məwe wawa hay, malamar ŋgay masulo eye a zla ŋgwas niye. ");
INSERT INTO meq_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Malamar ŋgay masulo eye a mət ze məwe wawa dərmak. Malamar tay mamahkar a ge andza niye, nəteye niye tasəla tebiye tə mət ze məwe wawa. ");
INSERT INTO meq_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nəteye tebiye tə mət na, ŋgwas a mət dərmak. ");
INSERT INTO meq_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ada pat nakə mədahaŋ hay ta lətseweye abəra ma mədahaŋ aye na, ŋgwas niye ma təriye na, i way? Hərwi nəteye tebiye ta zla ŋgwas niye.» ");
INSERT INTO meq_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu a mbəɗatay faya, a gwaɗatay: «Faya ka vumay gər a bo kurom hərwi ka sərum wu nakə mawatsa eye mə Ɗerewel i Mbəlom aye bay ada ka sərum gədaŋ i Mbəlom bay. ");
INSERT INTO meq_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Andza niye, ahəl nakə ta lətseweye abəra ma mədahaŋ aye na, hasləka hay ta ŋgwas hay ta zliye bo sa bay. Ane tuk na, ta ndziye na, andza gawla i Mbəlom neheye mə mbəlom aye. ");
INSERT INTO meq_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ka bazlam i mələtsew abəra ma mədahaŋ na, ɗaɗa ka dzaŋgum wu nakə Mbəlom a tsikakum mə Ɗerewel ŋgay aye təbəɗew? A gwaɗ: ");
INSERT INTO meq_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Neŋ na, Mbəlom i Abraham, Mbəlom i Izak, Mbəlom i Zakob.” Mbəlom na, neŋgeye Mbəlom i mədahaŋ hay bay, neŋgeye Mbəlom i ndo neheye ta ndziye huya ta sifa aye.» ");
INSERT INTO meq_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ndo neheye tebiye tə tsəne matətike ŋgay niye a tətikatay aye na, a gatay hərɓaɓəkka. ");
INSERT INTO meq_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farisa hay tə tsəne Yesu a sla ka Saduke hay tə bazlam na, tə haya gər. ");
INSERT INTO meq_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ndo nəte mə walaŋ tay na, neŋgeye ndo mədzaŋgawa bazlam i Mbəlom mapala eye, a ye ka təv i Yesu, a say məhəle faya abəra suwat. A tsətsah ka Yesu, a gwaɗay: ");
INSERT INTO meq_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Miter, mə walaŋ i bazlam i Mbəlom mapala eye hay, bagwar eye na, waray?» ");
INSERT INTO meq_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu a mbəɗay faya, a gwaɗay: «“Wuɗa Bəy Maduweŋ Mbəlom yak tə ɗərev yak tebiye, ta məsəfəre yak tebiye, ada tə metsehe yak tebiye.” ");
INSERT INTO meq_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Bazlam mapala eye bagwar eye ada nakə ŋgwalak eye a ze siye hay aye na, anaŋ. ");
INSERT INTO meq_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Bazlam mapala eye nakə a ze siye hay aye andza makurre eye anaŋ: “Wuɗa ndo i məgeɗ yak andza ka wuɗa na gər yak.” ");
INSERT INTO meq_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bazlam i Musa mapala eye tebiye ada matətike i ndo məɗe ha bazlam i Mbəlom tebiye a dzapa a huɗ i bazlam neheye mapala eye sulo aye.» ");
INSERT INTO meq_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Yesu a tsətsah bazlam ka Farisa neheye mahaya gər aye, a gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Ka dzalum ka Kəriste na, kəkay? Neŋgeye wawa i way?» Tə gwaɗay: «Neŋgeye Wawa i Davit.» ");
INSERT INTO meq_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu a gwaɗatay: «Ada ma kəkay Davit a ma ha bazlam i Məsəfəre Tsəɗaŋŋa eye nakə a tsik ahəl niye, a zalay “Bəy Maduweŋ ga” aye ɗaw? Hərwi Davit a gwaɗ: ");
INSERT INTO meq_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Bəy Maduweŋ Mbəlom a gwaɗay a Bəy Maduweŋ ga na: Dara ndza tə həlay i mənday ga hus a pat nakə neŋ, na piye tay ha ndo məne ɗəre hay a huɗ i sik yak aye.” ");
INSERT INTO meq_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Taɗə Davit kə zalay a Kəriste “Bəy Maduweŋ” tuk na, ada Kəriste neŋgeye wawa i Davit na, ma kəkay?» ");
INSERT INTO meq_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mə walaŋ i Farisa niye hay ndəray kwa nəte ka mbəɗay ka bazlam ŋgay niye bay. A dazlay pat eye niye, kwa way a dzədzar matsətsehe faya matsətsehe neheye kəriye. ");
INSERT INTO meq_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ma dəba eye na, Yesu a gwaɗatay a ndo hay mahaya gər eye haladzay ta gawla ŋgay hay: ");
INSERT INTO meq_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Ndo mədzaŋgawa bazlam i Mbəlom mapala eye ta Farisa hay məsler tay na, məɗatay ha bazlam i Musa mapala eye a ndo hay. ");
INSERT INTO meq_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Rəhumatay ha gər ada gum wu neheye tebiye faya ta tsikakumeye. Ane tuk na, kâ gum andza nəteye bay, hərwi faya ta giye wu nakə faya ta tsikiye bay. ");
INSERT INTO meq_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nəteye faya ta hayeye gər a wu neheye tə mba a zla bo bay, faya ta piye ka gər i ndo hay. Ane tuk na, bo tay eye kwa məlamay ta wur həlay, ta kərah madzəne ndo hay. ");
INSERT INTO meq_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","«Məsler tay faya ta giye na, hərwi ada ndo hay tâ zəba fataya, tâ gwaɗ nəteye ŋgwalak eye hay. Mahoɗok neheye tə mbəkwawa ada tə ɓarawa ka bo aye na, bagwar aye hay. Ta səkahawa ha me i petekeɗ tay ta zəbol. ");
INSERT INTO meq_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ma təv nakə ndo hay tə haya gər ka mənde wu mənday aye na, ta wuɗa məndze ka təv nakə ŋgwalak eye ada mə gay i maɗuwule me, ta ndziye na, ka təv nakə ndo hay ta ŋgatateye aye. ");
INSERT INTO meq_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","A satay ndo hay tâ tsikatay me mə walaŋ i ndo hay haladzay ada tâ zalatay “Miter” hay. ");
INSERT INTO meq_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Ane tuk na, nəkurom na, ndəray mâ zalakum ndo “Miter” hay təbey. Hərwi, Miter kurom na, nəte tsa. Nəkurom tebiye na, ta malamar hay. ");
INSERT INTO meq_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kâ zalumay a ndəray ka məndzibəra nakay “Bəba” bay. Hərwi Bəba kurom na, nəte, neŋgeye mə mbəlom. ");
INSERT INTO meq_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kâ pəlum tâ zalakum “bagwar may hay” bay. Hərwi bagwar kurom na, Kəriste nəte tsa. ");
INSERT INTO meq_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ndo nakə bagwar eye mə walaŋ kurom aye na, mâ təra ndo i məsler kurom. ");
INSERT INTO meq_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kwa way kə say matəre bagwar eye kame i ndo hay na, Mbəlom ma təriye ha wawa eye ɗuh. Kwa way ka təra ha gər ŋgay wawa eye na, Mbəlom ma təriye ha bagwar eye ɗuh.» ");
INSERT INTO meq_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«A nəkurom ndo mədzaŋgawa bazlam i Mbəlom mapala eye ta Farisa hay, nəkurom na, ndo i bəbərek hay, ɗəretsətseh ka gər kurom hərwi faya ka dərəzlumatay na tsəveɗ mede a Bəy i Mbəlom a ndo hay. Bo kurom eye a sakum mede bay ada ndo neheye a satay mede aye, a sakum məgəre tay ha tâ ye bay.  ");
INSERT INTO meq_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«A nəkurom ndo mədzaŋgawa bazlam i Mbəlom mapala eye ta Farisa hay, nəkurom na, ndo i bəbərek hay. Ɗəretsətseh ka gər kurom hərwi faya ka buwumeye wu abəra ka madakway i ŋgwas hay. Ka ɗuwulawum me vəɗvəɗ hərwi ada ndo hay tâ gwaɗ nəkurom ndo ŋgwalak eye hay. Hərwi niye, ta gakumeye sariya kurom na, ma ziye siye i ndo hay, ta sakakumeye naha bay. ");
INSERT INTO meq_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«A nəkurom ndo mədzaŋgawa bazlam i Mbəlom mapala eye ta Farisa hay, nəkurom na, ndo i bəbərek hay. Ɗəretsətseh ka gər kurom hərwi faya ka həhalumeye ka dala ada ka bəlay hərwi ada ndo hay tâ pakum bəzay. Ka hutum ndo nəte na, ka tərumeye ndo nakə ma hutiye sariya i Mbəlom ma ziye kurom madzəga sulo aye. ");
INSERT INTO meq_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«A nəkurom neheye ka tərum andza guluf hay faya ka lakumeye tay ha ndo hay aye, ɗəretsətseh ka gər kurom. Faya ka gwaɗumeye: “Taɗə ndoweye kə mbaɗa tə gay i məɗəslay ha gər a Mbəlom na, andza kə mbaɗa bay, a tsik bazlam mətsike tsa. Ane tuk na, taɗə ndoweye kə mbaɗa ta gura i gay i məɗəslay ha gər a Mbəlom na, kutoŋ ma giye wu nakə a mbaɗa ha aye.” ");
INSERT INTO meq_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","A nəkurom ndo i matərakahaŋ hay, nəkurom guluf eye hay. Wu nakə ŋgwalak eye ɗuh na, mey? Gura tsukuɗu gay i məɗəslay ha gər a Mbəlom nakə ma təriye ha gura tsəɗaŋŋa eye ɗaw? ");
INSERT INTO meq_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Faya ka gwaɗumeye sa: “Taɗə ndoweye kə mbaɗa ta təv məvəlay wu a Mbəlom na, andza kə mbəɗa bay, a tsik bazlam mətsike tsa. Ane tuk na, kə mbaɗa tə wu nakə tə vəlay a Mbəlom mapa eye ka təv məvəlay wu a Mbəlom aye na, kutoŋ ma giye wu nakə a mbaɗa ha aye.” ");
INSERT INTO meq_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nəkurom na, guluf eye hay, ŋgwalak eye ɗuh na, mey? Wu nakə tə vəlay a Mbəlom aye tsukuɗu, kəgəbay təv məvəlay wu a Mbəlom nakə ma təriye ha tsəɗaŋŋa wu nakə tə vəlay kəriye a Mbəlom aye ɗaw? ");
INSERT INTO meq_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Hərwi niye, ndoweye kə mbaɗa ta təv məvəlay wu a Mbəlom na, a mbaɗa ta təv məvəlay wu a Mbəlom ada tə wu neheye faya aye tebiye. ");
INSERT INTO meq_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ndoweye kə mbaɗa tə gay i məɗəslay ha gər a Mbəlom na, a mbaɗa ta gay i məɗəslay ha gər a Mbəlom ada ta Mbəlom nakə mandza eye mə ɗəma aye. ");
INSERT INTO meq_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ndoweye kə mbaɗa ta magərmbəlom na, a mbəɗa ta təv məndze i Mbəlom ada ta ndo nakə mandza eye mə ɗəma aye. ");
INSERT INTO meq_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«A nəkurom ndo mədzaŋgawa bazlam i Mbəlom mapala eye ta Farisa hay, nəkurom na, bəbərek eye hay. Ɗəretsətseh ka gər kurom hərwi ka hayumay gər a slambah i ala kurom hay tebiye na, mə kuro na, ka zlawum nəte ka vəlawumay a Mbəlom. Ada ka gərum ha məge wu ŋgwalak eye mə bazlam i Mbəlom mapala eye ɗuh na, kəkay? Andza məgweɗe məge wu nakə a ye ka bo məge aye, məge wu ŋgwalak eye a ndo hay, məpe mədzal gər ka Mbəlom. Anaŋ wu nakə a ye ka bo məge aye, ze məgər ha siye bay. ");
INSERT INTO meq_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nəkurom ka tərum na, andza guluf neheye faya ta lakiye tay ha ndo hay aye. Faya ka palumeye madzendzew hay abəra ma yam kurom nakə faya ka sum aye, ane tuk na, ka gərum ha a ɗəma zləgweme. ");
INSERT INTO meq_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«A nəkurom ndo mədzaŋgawa bazlam i Mbəlom mapala eye ta Farisa hay, nəkurom na, bəbərek eye hay. Ɗəretsətseh ka gər kurom hərwi nəkurom faya ka tsakaɗumeye dəba i gəsiyem ta dəba i səra lele. Ane tuk na, huɗ eye maraha eye tə wu neheye ka kəlum aye ada tə wu nakə a say a bor i bo kurom aye. ");
INSERT INTO meq_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","A nəkurom Farisa neheye ka tərum andza guluf hay aye, tsakaɗum na huɗ i gəsiyem kurom təday ada dəba eye bəbay ma zəbiye lele dərmak. ");
INSERT INTO meq_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«A nəkurom ndo mədzaŋgawa bazlam i Mbəlom mapala eye ta Farisa hay, nəkurom bəbərek eye hay. Ɗəretsətseh ka gər kurom hərwi nəkurom ka ndzəkitum bo na, tsəvay neheye ta lambaɗ tay ha dəba eye lele, a zəba kuɗekuɗek. Tə le ka ɗəre mazəbe fataya haladzay. Ane tuk na, mə huɗ eye na, maraha eye ta mətasl i mədahaŋ hay ada tə wu neheye maza eye tebiye. ");
INSERT INTO meq_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nəkurom na, andza niye dərmak. Ka ɗəre i ndo hay na, ka gwaɗum nəkurom ndo i deɗek hay. Ane tuk na, mə ɗərev kurom na, nəkurom maraha eye ta bəbərek ada ta mənese. ");
INSERT INTO meq_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«A nəkurom ndo mədzaŋgawa bazlam i Mbəlom mapala eye ta Farisa hay, nəkurom na, bəbərek eye hay. Ɗəretsətseh ka gər kurom hərwi faya ka ɗəzlumeye tsəvay i ndo məɗe ha bazlam i Mbəlom hay, ada faya ka lambaɗumeye tsəvay i ndo neheye tə pay bəzay a Mbəlom ta deɗek aye. ");
INSERT INTO meq_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ada ka gwaɗum: “Taɗə nəmaa ge andaya a həlay i bəba təte may neheye tə kəɗawa ndo məɗe ha bazlam i Mbəlom hay aye na, nəmaa dzapiye ta nəteye hərwi məkəɗe tay ha bay.” ");
INSERT INTO meq_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Andza niye, bo kurom eye tə gər kurom ka sərum ha nəkurom wawa i ndo neheye tə kəɗ tay ha ndo məɗe ha bazlam i Mbəlom hay aye. ");
INSERT INTO meq_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Lele, ndəɗikum ka məsler i bəba təte kurom huya! ");
INSERT INTO meq_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","«Nəkurom na, dədœ hay, wawa i palas hay! Ka slumeye mətəme abəra ka sariya i ako nakə ma mbatiye bay aye na, kəkay? ");
INSERT INTO meq_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Hərwi niye, tsənum lele: Na slərakumeye naha ndo məɗe ha bazlam i Mbəlom hay, ndo neheye ta tsah aye, ndo neheye ta tətikakumeye. Ka kəɗumeye tay ha siye hay, ka darumeye tay ha siye ha ka mayako mazləlmbaɗa eye, siye ka ndaɓumeye tay ha ta mandalaɓa mə gay i maɗuwule me kurom hay ada siye ka həharumeye tay ha ka gəma ka gəma. ");
INSERT INTO meq_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Andza niye, ndo neheye ka kəɗum tay ahəl niye kəriye ta ge mənese bay aye na, mənese eye ma dəɗiye na, ka gər kurom. A dazlay ka Abel ndo məpay naha faya a Mbəlom hus ka Zakari wawa i Baraki nakə ka kəɗum mə walaŋ i təv məvəlay wu a Mbəlom ta təv nakə tsəɗaŋŋa eye. ");
INSERT INTO meq_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Neŋ faya na gwaɗakumeye: Sərum ha na, wu neheye tə ge ahəl niye tebiye na, sariya i Mbəlom ma dəɗiye ka ndo neheye anəke aye.» ");
INSERT INTO meq_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesu a dazlay mətuwe Zerozelem. A gwaɗ: «Nəkurom ndo i Zerozelem hay, nəkurom ndo i Zerozelem hay. Nəkurom neheye ka bəbazlum tay ha ndo məɗe ha bazlam i Mbəlom hay ada ka kəɗum tay ha ndo neheye Mbəlom a slərakum naha aye tə kwar. Sik nday nakə a seŋ məhayakum gər ka təv ga andza mandzekwer nakə ma hayatay gər a wawa ŋgay hay a huɗ i gwezleviyek ŋgay aye. Ane tuk na, ka wuɗum bay! ");
INSERT INTO meq_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Hərwi niye, gay kurom ma təriye rəgay. ");
INSERT INTO meq_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Andza niye, neŋ faya na gwaɗakumeye: Ma dazleye anəke ka ŋgatumeŋeye sa bay hus ahəl nakə ka gwaɗumeye: “Mbəlom mâ pa ŋgama ka ndo nakə faya ma deyeweye tə məzele i Bəy Maduweŋ aye!”» ");
INSERT INTO meq_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu a ndohwaw abəra mə gay i məɗəslay ha gər a Mbəlom. Ahəl nakə faya ma diye ŋgway aye na, gawla ŋgay hay ti ye naha ka təv ŋgay hərwi a satay məɗay ha ta ɗəzl gay i məɗəslay ha gər a Mbəlom ada siye i gay hay na, kəkay. ");
INSERT INTO meq_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu neŋgeye a gwaɗatay: «Faya ka ŋgatumeye a wu neheye tebiye na gwaɗ ba? Sərum ha kame na, ka ŋgatumeye a kwar kwa nəte ka gər i kwar ŋgeɗ bay. Ta mbəzliye ha hele hele.» ");
INSERT INTO meq_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu a ye, a tsal a Mahəmba i Tetəɗœz. Ahəl nakə neŋgeye mandza eye na, gawla ŋgay hay ti ye ka təv ŋgay mahəteye, ti ye ta tsətsah faya, tə gwaɗay: «Tsikamay, wu neheye ta ta giye bo na, kəɗay? Ada ŋgoɗgor waray nakə ma ɗiye ha mazlambar ka maweye ada məndzibəra mazlambar ma ndəviye aye?» ");
INSERT INTO meq_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu a mbəɗatay faya, a gwaɗatay: «Gum metsehe! Ndəray mâ səpat kurom bay. ");
INSERT INTO meq_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Hərwi ndo hay haladzay ta deyeweye ta məzele ga. Kwa way ma gwaɗiye: “Neŋ na, Kəriste!” Ada ta səpatiye ndo hay haladzay. ");
INSERT INTO meq_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ka tsənum ndo hay faya ta giye vəram bəse tə nəkurom kwa neheye dəreŋ tə nəkurom aye na, kâ dzədzarum bay. Hərwi wu neheye na, kutoŋ ta ndisleweye. Ane tuk na, mandəve i məndzibəra zuk bay. ");
INSERT INTO meq_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Slala ŋgeɗ ta giye vəram ta slala neŋgeɗ, bəy ta bəy ta giye vəram. Mandərzlaŋ ma giye, dala ma ɓəliye ma gəma hay wal wal. ");
INSERT INTO meq_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wu neheye tebiye ta giye bo na, andza məwe wawa nakə a dazlay a ŋgwas aye.» ");
INSERT INTO meq_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Ma dəba eye na, ndo hay ta gəsiye kurom hərwi ada tâ gakum ɗəretsətseh, ta kəɗiye kurom. Slala i ndo hay tebiye ta nakumeye ɗəre hərwi ga. ");
INSERT INTO meq_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","A həlay niye na, ndo hay haladzay ta gəriye ha məpe mədzal gər abəra ka neŋ. Ta həliye ka bo me ada ta niye a bo ɗəre mə walaŋ tay nəte nəte. ");
INSERT INTO meq_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ndo neheye tə gwaɗ nəteye ndo məɗe ha bazlam i Mbəlom aye haladzay ta deyeweye. Ta səpatiye ndo hay haladzay. ");
INSERT INTO meq_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mənese ma səkahiye haladzay. Hərwi niye, mawuɗe bo i ndo hay haladzay ma nəkiɗiye. ");
INSERT INTO meq_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ane tuk na, ndoweye kə səmay naha hus ka mandəve aye na, Mbəlom ma təmiye ha. ");
INSERT INTO meq_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ta ɗiye ha Labara Ŋgwalak eye i Bəy i Mbəlom a ndo i məndzibəra hay tebiye hərwi ada ndo neheye tə sər Mbəlom bay aye tâ tsəne. Tsa na, məndzibəra ma ndəviye.» ");
INSERT INTO meq_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesu a gwaɗatay: «Ka ŋgatumeye a wuray maga zluwer eye andza mazəlatoŋgo, ma lətsiye a təv nakə tsəɗaŋŋa eye, andza nakə Daniyel ndo məɗe ha bazlam i Mbəlom kə tsik faya. (Ndoweye kə dzaŋga na, mâ tsəne lele.) ");
INSERT INTO meq_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ndo neheye ka dala i Yahuda aye, ta ŋgatay a wu niye na, tâ hway a mahəmba hay. ");
INSERT INTO meq_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ndo nakə neŋgeye ka gər i gay aye na, mâ mbəzlaw ka dala hərwi mede məhəlaw wu ŋgay hay abəra mə gay ŋgay bay. ");
INSERT INTO meq_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ndo nakə neŋgeye ma guvah aye na, mâ mbəɗa gər a mətagay ŋgay məzlaw petekeɗ ŋgay bay. ");
INSERT INTO meq_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pat eye niye na, ɗəretsətseh wene wene eye na, ka gər i ŋgwas neheye tə bo sulo aye ada ka ŋgwas neheye faya ta vəlateye wah a wawa tay hay aye! ");
INSERT INTO meq_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ɗuwulumay me a Mbəlom hərwi mahway nakə ka hwayumeye mâ ge a həlay i mətasl bay kəgəbay pat i mazəzukw bo bay. ");
INSERT INTO meq_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Andza niye, a həlay niye na, ndo hay ta siye ɗəretsətseh haladzay. Kwa ahəl nakə Mbəlom a ge məndzibəra aye hus anəke na, ɗaɗa ndəray kə sa ɗəretsətseh andza niye bay ada ɗaɗa ma giye bo andza niye sa bay. ");
INSERT INTO meq_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Taɗə Mbəlom mâ nəkiɗ ha abəra ka pat i ɗəretsətseh bay na, ndəray kwa nəte ma təmiye bay. Ane tuk na, a nəkiɗ ha hərwi ndo ŋgay neheye a pala aye. ");
INSERT INTO meq_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Taɗə ndəray kə gwaɗakum: “Zəbum! Kəriste anaŋ!” kəgəbay “Neŋgeye atay!” na, kâ təmum bazlam ŋgay bay. ");
INSERT INTO meq_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Andza niye, ndo masəpete ndo hay ta deyeweye. Ta gwaɗiye nəteye na, ndo məɗe ha bazlam i Mbəlom, kəgəbay ndo mətəme ha ndo nakə Mbəlom a sləraweye. Nəteye na, ta giye masuwayaŋ hay ada tə wu neheye ma giye hərɓaɓəkka aye hərwi taɗə ma giye bo na, masəpete tay ha ndo neheye Mbəlom a pala aye. ");
INSERT INTO meq_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Anaŋ, na tsikakum ka bo abəra kurre. Pum a zləm lele. ");
INSERT INTO meq_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Taɗə ta gwaɗakum: “Kəriste anaŋ mə pesl”, kâ yum bay, kəgəbay ta gwaɗakum: “Neŋgeye anaŋ maŋgaha bo eye kanaŋ” na, kâ təmum bay. ");
INSERT INTO meq_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Neŋ Wawa i Ndo, na deyeweye na, andza mawutseɗe i mbəlom nakə ta ŋgateye kwa tə waray aye. ");
INSERT INTO meq_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Andza niye, təv nakə wu maməta eye mə ɗəma aye na, magoduk hay ta hayiye gər a ɗəma.» ");
INSERT INTO meq_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Kwayaŋŋa ɗəretsətseh niye hay ta ye abəra mə ɗəma na, pat ma giye andaya sa bay ada kiye ma dəviye bay. Wurzla hay dərmak ta kutsaweye abəra ka magərmbəlom, ada wu neheye gədaŋ eye ka magərmbəlom aye ta ɓəliye haladzay. ");
INSERT INTO meq_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pat eye niye na, ndo hay ta ŋgateye a wu nakə ma ɗiye ha neŋgeye faya ma deyeweye aye ka magərmbəlom. Ndo i məndzibəra hay tebiye ta tuwiye ka bo. Ta ŋgeteŋeye a neŋ Wawa i Ndo na deyeweye ma pazlay ta gədaŋ ada ta məzlaɓ eye haladzay. ");
INSERT INTO meq_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ta fa tolom bagwar eye na, ma sləraweye gawla i Mbəlom hay, ta hayay gər a ndo neheye a pala tay ha aye abəra ka kokway i məndzibəra tebiye kwa ka waray ka waray.» ");
INSERT INTO meq_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yesu a gwaɗatay: «Tsənum dzeke i gurov təday. Ka ŋgatumay a gurov ka ɗuɗa na, ka sərum ha gwaduvay kə ge, mazlambar yam ma piye bəɗaw? ");
INSERT INTO meq_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Andza niye, ka ŋgatumay a wu neheye tebiye ta ndislew na, sərum ha neŋ Wawa i Ndo mazlambar na deyeweye, neŋ ka məgeɗ. ");
INSERT INTO meq_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Neŋ faya na gwaɗakumeye: Sərum ha na, wu nakay tebiye ma giye bo na, ndo neheye anəke aye ta mət zuk bay. ");
INSERT INTO meq_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Magərmbəlom ta dala ta dziye, bazlam ga na, ɗaɗa ma dziye bay.» ");
INSERT INTO meq_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yesu a gwaɗatay sa: «Ma deyeweye pat waray na, ndəray kwa nəte a sər bay. Ada ma deyeweye ahəl waray na, ndəray a sər həlay eye bay sa. Kwa gawla i Mbəlom hay mə mbəlom, kwa neŋ Wawa ŋgay bəbay, nəmaa sər bay. Maa sər pat eye na, Mbəlom Bəba ga nəte ŋgweŋ. ");
INSERT INTO meq_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Wu nakə a ge bo a həlay i Nuhu aye na, pat nakə neŋ Wawa i Ndo na deyeweye na, ma ta giye bo andza niye dərmak. ");
INSERT INTO meq_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Hərwi ahəl nakə yam ka dazlay a məpe zuk bay aye na, ndo hay tə ndayawa wu mənday, tə sawa wu məsay, tə zlawa dahəlay ada tə vəlawa dem tay hay a zal hus a pat nakə Nuhu a fələkwa a kwalalaŋ i yam aye. ");
INSERT INTO meq_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ta sər ka bo bay hus a həlay nakə yam a yaw a həl tay ha tebiye. Ahəl nakə neŋ Wawa i Ndo na deyeweye na, ma giye andza niye dərmak. ");
INSERT INTO meq_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","«A həlay niye na, ndo hay sulo ma guvah na, ta zliye nəte, ta gəriye ha neŋgeɗ. ");
INSERT INTO meq_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ŋgwas hay sulo ta ləgəriye na, ta zliye nəte ta gəriye ha neŋgeɗ. ");
INSERT INTO meq_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Hərwi niye, ndzum na, tsezlezleŋŋe bəna ka sərum pat nakə Bəy Maduweŋ kurom ma maweye bay. ");
INSERT INTO meq_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","«Tsənum wu nakay lele: Ndo i gay mâ sər həlay nakə məkal ma deyeweye ma kəliye na aye na, ma ndzahəriye bay. Ma ndziye tsezlezleŋŋe, ma gəriye ha məkal mâ fələkwa a gay ŋgay bay. ");
INSERT INTO meq_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Hərwi niye, nəkurom dərmak ləvum bo, hərwi neŋ Wawa i Ndo na maweye ahəl waray na, ka sərumeye bay.» ");
INSERT INTO meq_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesu a gwaɗatay: «Ndo i məsler ŋgwalak eye ada ma giye məsler tə metsehe lele eye na, way? Neŋgeye na, ndo nakə ndo i gay ŋgay a gwaɗay “Gatay gər a siye i ndo məge məsler ga hay. Vəlatay wu mənday tə həlay eye.” ");
INSERT INTO meq_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Məŋgwese ka gər i ndo məge məsler niye taɗə ndo i gay ŋgay ki yaw, kə ndzay a gər neŋgeye faya ma giye məsler andza nakə tə tsikay aye. ");
INSERT INTO meq_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Neŋ faya na gwaɗakumeye: Sərum ha na, ndo i gay ŋgay ma gəray ha zlele ŋgay tebiye mâ ləvay gər. ");
INSERT INTO meq_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","«Ane tuk na, taɗə ndo məge məsler niye ŋgwalak eye bay na, ma gwaɗeye a gər ŋgay: “Ndo i gay ga faya ma gaweye mahonok, ma deyeweye bəse bay”, ");
INSERT INTO meq_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ma piye bo məndeɓe siye i ndo neheye faya ta giye məsler dziye. Ma ndiye wu mənday ada ma siye wu məsay ta ndo məkweye hay. ");
INSERT INTO meq_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ndo i gay ŋgay ma maweye na, ka həlay nakə faya ma həbiye bay aye ada a sər bay aye. ");
INSERT INTO meq_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ki yaw na, ma vəleye ɗəretsətseh haladzay, ma həhariye na ndo i məsler niye. Ma kaliye ha a təv i ndo i bəbərek hay. Mə ɗəma na, ta tuwiye tə mahəpəɗe zler eye.» ");
INSERT INTO meq_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu a gwaɗatay: «A həlay niye na, Bəy i Mbəlom ma ndzəkitiye bo na, tə merehe i dem hay kuro. Tə həl lalam tay hay, ti ye hərwi mədzəgər tə zal i dahəlay. ");
INSERT INTO meq_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mə walaŋ i merehe i dem neheye kuro aye, zlam na, matərakahaŋ eye hay, siye hay zlam na, metsehe tay andaya. ");
INSERT INTO meq_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Merehe i dem neheye zlam matərakahaŋ aye, tə həl lalam tay na, ta ləva ha bo tə mal bay. ");
INSERT INTO meq_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Merehe i dem neheye zlam metsehe tay andaya aye na, tə həl lalam tay ada kwa way a ləva ha bo tə mal ma dos. ");
INSERT INTO meq_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Zal i dahəlay ki yaw bəse bay. Merehe i dem niye hay tebiye məndzehəre a gatay, tə ndzahəra. ");
INSERT INTO meq_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Ta magərhəvaɗ na, mawude a tsəne. “Anaŋ zal i dahəlay kə ndzew! Lətsum ka mbəlom, dum ta dzum gər.” ");
INSERT INTO meq_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Merehe i dem niye hay ta pəɗeke abəra ka məndzehəre, ta dazlay mələve bo ta lalam tay hay. ");
INSERT INTO meq_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Merehe i dem neheye matərakahaŋ aye na, ta tsətsah mal ka merehe i dem neheye metsehe tay andaya aye, tə gwaɗatay: “Mbəɗumamay mal a lalam may hay tsekweŋ tey hərwi faya ta mbatiye.” ");
INSERT INTO meq_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Merehe i dem neheye metsehe tay andaya aye, ta mbəɗatay faya, tə gwaɗatay: “Aʼay, andaya haladzay ma sliye a nəmay ada a nəkurom bay. Hwayum naha bəse ɗuh ka təv i ndo i tsakala, səkəmumaw.” ");
INSERT INTO meq_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ahəl nakə ti ye masəkəmaw mal aye na, zal i dahəlay a ndislew. Merehe i dem neheye zlam maləva bo aye na, tə fələkwa ka bo tə neŋgeye a gay i magurlom i məzle dahəlay. A dərəzl a məgeɗ. ");
INSERT INTO meq_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Məndze zərat na, siye i merehe i dem niye hay tə maw. Tə maw na, tə gwaɗ: “Bəy Maduweŋ, Bəy Maduweŋ, həndəkamay abəra ma məgeɗ!” ");
INSERT INTO meq_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ane tuk na, zal i dahəlay a gwaɗatay: “Neŋ faya na gwaɗakumeye ta deɗek, na sər kurom bay.” ");
INSERT INTO meq_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Hərwi niye, ndzum tsezlezleŋŋe bəna pat eye kwa həlay eye na, ka sərum bay.» ");
INSERT INTO meq_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu a gwaɗatay sa: «Ma giye bo andza ndo i gay nakə a say mede a tsekene aye. A zalatay a ndo i məsler ŋgay hay, a gər ha zlele ŋgay a həlay tay. ");
INSERT INTO meq_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A vəlay kwa a way ka gədaŋ ŋgay. A vəlay a ndo ŋgeɗ kwar i suloy temerre zlam, a ndo ŋgeɗ temerre sulo, a ndo mamahkar eye temerre nəte. Tsa na, a ye ŋgway. ");
INSERT INTO meq_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","«Ndo i məsler nakə tə vəlay kwar i suloy temerre zlam aye na, a ye a mbəɗa ha həlay kwayaŋŋa. A huta faya kwar i suloy temerre zlam sa. ");
INSERT INTO meq_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ndo nakə tə vəlay kwar i suloy temerre sulo aye na, a ge ha andza niye dərmak. A huta faya kwar i suloy temerre sulo. ");
INSERT INTO meq_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ane tuk na, ndo nakə tə vəlay kwar i suloy temerre nəte aye na, a ye a la bəɗ, a ŋgaha na suloy i ndo i gay ŋgay niye a ɗəma. ");
INSERT INTO meq_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Aza a ndzaw məve tsakway na, ndo i gay i ndo i məsler niye hay a maw. Tsa na, a say məpesle na suloy ŋgay nakə a vəlatay aye. ");
INSERT INTO meq_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ndo nakə a vəlay kwar i suloy temerre zlam aye, a ye ka təv ŋgay, a gwaɗay: “Ndo i gay ga, ka vəleŋ na, kwar i suloy temerre zlam. Anaŋ na huta faya kwar i suloy temerre zlam.” ");
INSERT INTO meq_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ndo i gay ŋgay a gwaɗay: “Lele haladzay, nəkar na, ndo i ŋgwalak ada ndo i deɗek. Nəkar ndo i deɗek kwa mə wu neheye tsekweŋ aye, na pakeye wu haladzay a həlay. Dara ŋgwasama ka bo tə neŋ.” ");
INSERT INTO meq_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ndo i məsler nakə a vəlay kwar i suloy temerre sulo aye, a ye naha, a gwaɗay: “Ndo i gay ga, ka vəleŋ kwar i suloy temerre sulo. Anaŋ na huta faya kwar i suloy temerre sulo.” ");
INSERT INTO meq_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ndo i gay ŋgay a gwaɗay: “Lele, nəkar na, ndo i ŋgwalak ada ndo i deɗek. Nəkar ndo i deɗek kwa mə wu neheye tsekweŋ aye, na pakeye wu haladzay a həlay. Dara ŋgwasama ka bo tə neŋ.” ");
INSERT INTO meq_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ndo nakə tə vəlay kwar i suloy temerre nəte aye, a ye naha a gwaɗay: “Ndo i gay ga, na sər ha, nəkar na, ndo makula gər eye. Ka dziye wu nakə ka sləga bay aye, ka hayay gər a wu nakə ka zəv bay aye. ");
INSERT INTO meq_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Na dzədzar, hərwi niye na ye na ŋgaha kwar i suloy yak a bəɗ. Anaŋ suloy yak.” ");
INSERT INTO meq_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ndo i gay ŋgay a gwaɗay: “Nəkar na, ndo i məsler nakə ŋgwalak eye bay aye ada sœ eye. Ka sər na, na dziye wu nakə na sləga bay aye ada na hayay gər a wu nakə na zəv bay aye ba? ");
INSERT INTO meq_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Meeneŋ na, peŋ na suloy a bank. A həlay i məmaw ga na, na həla ahaya suloy ga ta magogoy eye faya. ");
INSERT INTO meq_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Həlum faya abəra kwar i suloy niye temerre nəte aye. Vəlumay ha faya a ndo nakə kwar i suloy andaya faya gwezem aye. ");
INSERT INTO meq_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Hərwi ndo nakə wu ŋgay andaya aye na, ta səkahay ha sa. Ane tuk na, ndo nakə wu ŋgay andaya bay aye na, kwa tsekweŋ eye nakə andaya faya aye na, ta zliye na faya abəra. ");
INSERT INTO meq_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Gəsum na ndo nakay ma giye ŋgama bay aye. Kalum naha abəra a ləvoŋ. Mə ɗəma na, ta tuwiye tə mahəpəɗe zler eye.”» ");
INSERT INTO meq_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesu a gwaɗatay sa: «Ahəl nakə neŋ Wawa i Ndo na deyeweye ma məzlaɓ ga ta gawla i Mbəlom hay tebiye aye na, na ndziye ka dzaŋga i bəy ga ta məzlaɓ. ");
INSERT INTO meq_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ndo i məndzibəra hay tebiye ta hayiye gər ka təv ga ada na ŋgəniye ha ka bo abəra ndo hay ta ndo siye hay andza ndo mətsəkure ma ŋgəniye tay ha təɓaŋ hay ta wak hay. ");
INSERT INTO meq_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ka ŋgəna tay ha na, ma piye tay ha təɓaŋ hay a diye i həlay i mənday ŋgay ada ma piye tay ha wak hay a diye i həlay i gula ŋgay. ");
INSERT INTO meq_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«Bəy ma gwaɗateye a ndo neheye tə həlay i mənday ŋgay aye: “Dumara, nəkurom neheye Mbəlom Bəba ga a pa fakuma ŋgama aye, ka ndzumeye ma bəy ga nakə Mbəlom a ləvakum ha bo kwa ahəl nakə kə ge məndzibəra zuk bay aye. ");
INSERT INTO meq_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Hərwi ahəl niye, may a wur fagaya na, ka vəlumeŋ wu mənday, yam a geŋ na, ka vəlumeŋ yam məsay, neŋ mbəlok eye na, ka təmum ga a gay kurom, ");
INSERT INTO meq_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","petekeɗ andaya fagaya bay na, ka pumeŋ ka bo petekeɗ, neŋ ɗəvats eye na, ka gumeŋ gər, neŋ ma daŋgay na, ka yum ka zəbumeŋew ɗəre.” ");
INSERT INTO meq_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«Ndo neheye tə gawa wu nakə a yay a gər a Mbəlom aye na, ta mbəɗeye faya, ta gwaɗeye: “Bəy Maduweŋ, nəmaa ŋgataka may a wur fakaya ada nəmaa vəlaka wu mənday na, kəɗay? Yam a gaka ada nəmaa vəlaka yam məsay na, kəɗay? ");
INSERT INTO meq_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nəmaa ŋgataka nəkar mbəlok eye ada nəmaa təma kar a gay may na, kəɗay? Petekeɗ fakaya bay ada nəmaa paka ka bo petekeɗ na, kəɗay? ");
INSERT INTO meq_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nəmaa ŋgataka nəkar ɗəvats eye kəgəbay nəkar ma daŋgay ada nəmaa ye mazəbakaw ɗəre na, kəɗay?” ");
INSERT INTO meq_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","«Bəy ma mbəɗateye faya, ma gwaɗateye: “Neŋ faya na gwaɗakumeye, sərum ha, kwa mey ka gumay a ndo wawa eye tsekweŋ mə walaŋ i malamar ga hay na, ka gum niye na, a neŋ.” ");
INSERT INTO meq_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ma dəba eye bəy ma gwaɗateye a ndo neheye tə həlay i gula ŋgay aye: “Dum abəra ka təv ga, nəkurom neheye Mbəlom a vəlakum mezeleme aye! Dum a ako nakə ma mbatiye ɗaɗa bay Mbəlom a ləvatay ha bo a Fakalaw ta gawla ŋgay hay aye. ");
INSERT INTO meq_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Hərwi, ahəl nakə may a wur fagaya na, ka vəlumeŋ wu mənday bay. Yam a geŋ na, ka vəlumeŋ yam bay, ");
INSERT INTO meq_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Neŋ mbəlok eye na, ka təmum ga a gay kurom bay, petekeɗ andaya fagaya bay na, ka pumeŋ ka bo petekeɗ bay, neŋ ɗəvats eye ada neŋ ma daŋgay na, ka gumeŋ gər bay.” ");
INSERT INTO meq_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«Nəteye dərmak ta mbəɗeye faya, ta gwaɗeye: “Nəmaa ŋgataka may a wur fakaya, yam a gaka, nəkar mbəlok eye, ɗəvats eye kəgəbay ma daŋgay nəmaa gaka gər bay na, kəɗay?” ");
INSERT INTO meq_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","«Bəy ma mbəɗateye faya, ma gwaɗateye: “Neŋ faya na gwaɗakumeye: Sərum ha na, wu nakə ka slum faya məgay a ndo wawa eye tsekweŋ mə walaŋ i ndo neheye bay na, ka gumeŋ a neŋ bay dərmak.”» ");
INSERT INTO meq_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yesu a gwaɗatay: «Nəteye, ta diye ta hutiye na, ɗəretsətseh nakə ma ndəviye bay ka tor eye. Ndo neheye tə ge wu nakə a yay a gər a Mbəlom aye na, ta diye a sifa nakə ma ndəviye bay aye.» ");
INSERT INTO meq_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ahəl nakə Yesu a ndəv ha matətike aye na, a gwaɗatay a gawla ŋgay hay: ");
INSERT INTO meq_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Ka sərum ha magurlom i Pak a zəkaw na, məhəne sulo. Neŋ Wawa i Ndo ta gəsiye ga hərwi ada tâ dar ga ka mayako mazləlmbaɗa eye.» ");
INSERT INTO meq_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","A həlay niye na, bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta madugula i Yahuda hay tə haya gər a gay i Kayif, bagwar i ndo məvəlaway wu a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tə ma ha ka bo bazlam mə walaŋ tay, a satay məgəse Yesu ta məkal ada məkəɗe na. ");
INSERT INTO meq_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ane tuk na, tə gwaɗ: «Kâ gəsakwa na tə magurlom nakay bay bəna, ndo hay ta gəriye kway ha bay.» ");
INSERT INTO meq_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu neŋgeye ma gəma i Betani, mə gay i ndo wuray tə zalay Simoŋ. Ndoweye niye a ndzawa na, ɗəvats i madəgweɗe a gaway. ");
INSERT INTO meq_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ahəl nakə faya ta ndiye wu mənday aye na, ŋgwas wuray a ye naha ka təv i Yesu ta dos mə həlay a le haladzay, maraha eye tə mal nakə a ze huŋŋa tsakala eye haladzay aye. A mbəɗa mal niye ka gər i Yesu. ");
INSERT INTO meq_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Gawla ŋgay hay tə ŋgatay na, a yatay a gər bay, tə gwaɗ: «A nas ha mal nakay na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ŋgama meeneŋ mâ səkəm ha na, ma hutiye ha suloy haladzay ada ma pateye suloy eye a ndo i mətawak hay.» ");
INSERT INTO meq_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu a səratay naha a gər ka bazlam tay niye, a gwaɗatay: «Ka kwasumeye gər a ŋgwas nakay na, hərwi mey? Wu nakə a ge hərwi ga aye na, lele haladzay. ");
INSERT INTO meq_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ndo i mətawak hay na, nəteye ka təv kurom huya. Ane tuk na, neŋ na, na ndziye tə nəkurom huya bay. ");
INSERT INTO meq_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Neŋgeye ka mbəɗa mal ka bo ga hərwi mələve ha bo i məzle ga a bəɗ. ");
INSERT INTO meq_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Neŋ faya na gwaɗakumeye, sərum ha: Kwa a ŋgay ta ɗiye ha Labara Ŋgwalak eye nakay ka məndzibəra tebiye na, ta tsikiye ka ŋgwas nakay hərwi wu nakə a ge aye. Ndo hay ta mətsiye ha gər bay.» ");
INSERT INTO meq_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ndo nəte mə walaŋ i gawla i Yesu hay kuro gər eye sulo, məzele ŋgay Yudas Iskariyot, a ye ka təv i bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye. ");
INSERT INTO meq_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","A ye naha, a gwaɗatay: «Taɗə na pəlakum tsəveɗ məgəse Yesu na, ka vəlumeŋeye mey?» Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom tə paslay kwar i suloy kuro kuro mahkar, tə vəlay. ");
INSERT INTO meq_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","A dazlay pat eye niye Yudas a pəla həlay nakə lele eye hərwi məge ɗaf ka Yesu aye. ");
INSERT INTO meq_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pat makurre i magurlom nakə tə ndayawa wu mənday nakə gəɗe faya bay aye na, gawla i Yesu hay ti ye ka təv i Yesu, tə gwaɗay: «A saka nəmaa daka ɗaf i magurlom i Pak na, ka waray?» ");
INSERT INTO meq_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu a gwaɗatay: «Dum a wuzlahgəma, a gay i ndoweye andaya, gwaɗumay: “Miter a gwaɗ: Həlay eye i ga kə slaw. Na ndiye ɗaf i Pak ta gawla ga hay na, mə gay yak.”» ");
INSERT INTO meq_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Gawla i Yesu hay ti ye tə ge wu nakə Yesu a tsikatay aye. Tə da wu mənday i Pak mə ɗəma. ");
INSERT INTO meq_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Huwa a ge na, Yesu ta gawla ŋgay hay kuro gər eye sulo ti ye tə ndza, ta dazlay a mənde wu mənday. ");
INSERT INTO meq_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","A həlay nakə nəteye faya ta ndiye wu mənday aye na, Yesu a gwaɗatay: «Neŋ faya na gwaɗakumeye: Sərum ha na, ndo nəte mə walaŋ kurom ma giye fagaya ɗaf.» ");
INSERT INTO meq_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","A ndalatay a gawla ŋgay hay tebiye. Tsa na, ta dazlay matsətsehe faya, nəte ta nəte: «Bəy Maduweŋ, neŋ ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu a mbəɗatay faya, a gwaɗatay: «Mata ge fagaya ɗaf na, ndo nakə faya nəmaa tələkiye həlay a səra salamay aye. ");
INSERT INTO meq_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Neŋ Wawa i Ndo na mətiye andza nakə Ɗerewel i Mbəlom a tsik aye. Ane tuk na, ɗəretsətseh ka gər i ndo nakə ma giye ɗaf ka neŋ Wawa i Ndo aye. Ndo niye na, ŋgama meeneŋ tâ wa na bay.» ");
INSERT INTO meq_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudas, ndo nakə ma giye ɗaf ka Yesu aye, a tsətsah faya: «Neŋ ɗaw, Miter?» Yesu a mbəɗay faya, a gwaɗay: «Andza nakə ka tsik aye.» ");
INSERT INTO meq_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ahəl nakə faya ta ndiye ɗaf aye na, Yesu a zla peŋ, a gay naha sɨsœ a Mbəlom. Ma dəba eye na, a ŋgəna ha peŋ niye, a vəlatay a gawla ŋgay hay, a gwaɗatay: «Zlum, ndayum. Nakay na, bo ga.» ");
INSERT INTO meq_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ma dəba eye a zla gəvet, a gay naha sɨsœ a Mbəlom. Ma dəba eye a vəlatay, a gwaɗatay: «Sum nəkurom tebiye. ");
INSERT INTO meq_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nakay na, bambaz ga nakə Mbəlom ma ɓariye dzam ta ndo hay aye. Ta mbəɗiye ha na, hərwi məpəse ha mezeleme i ndo hay haladzay. ");
INSERT INTO meq_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Neŋ faya na tsikakumeye, na ta siye wu məse nakay sa bay hus a pat nakə ka ta sakweye weɗeye ma bəy i Bəba ga Mbəlom aye.» ");
INSERT INTO meq_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ma dəba eye, ta zambaɗay a Mbəlom ta dəmes na, ti ye tə tsal a Mahəmba i Tetəɗœz. ");
INSERT INTO meq_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ma dəba eye na, Yesu a gwaɗatay a gawla ŋgay hay: «Bəgom ta həvaɗ nakay nəkurom tebiye ka gərumeye ga ha. Hərwi mawatsa eye mə Ɗerewel i Mbəlom, a gwaɗ: “Na ta kəɗiye na ndo mətsəkure tay, ada təɓaŋ niye hay mahaya gər eye ta ŋgəniye gər kweye kweye kwa a ŋgay.” ");
INSERT INTO meq_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ane tuk na, na mbəlaw abəra ma mədahaŋ na, na həbiye kurom ma Galile.» ");
INSERT INTO meq_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piyer a mbəɗay faya, a gwaɗay: «Kwa siye i ndo hay ta gər kar ha na, neŋ na gəriye kar ha ɗaɗa təbey.» ");
INSERT INTO meq_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu a mbəɗay faya, a gwaɗay: «Neŋ faya na gwaɗakeye: Sər ha na, bəgom ta həvaɗ nakay dzagulok ma ta zlahiye na, ɓa ka gwaɗ sik mahkar ka sər neŋ bay.» ");
INSERT INTO meq_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piyer a gwaɗay: «Na sər kar bay na, na tsikiye ɗaɗa bay, kwa taɗə ka mətameye ka bo salamay.» Siye i gawla ŋgay hay tebiye tə tsik andza niye dərmak. ");
INSERT INTO meq_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu ta gawla ŋgay hay tə ndisl a təv eye andaya tə zalay Getsemene. Mə ɗəma na, a gwaɗatay: «Ndzum kanaŋ. Na diye, na ɗuwulay naha me a Mbəlom kataɗay.» ");
INSERT INTO meq_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tsa na, ti ye ta Piyer ada ta wawa i Dzebede hay sulo. Tə ndisl a ɗəma na, mevel i Yesu a dazlay məwure faya ada a dzədzar haladzay. ");
INSERT INTO meq_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","A gwaɗatay: «Ɗərev ga na, kə rah tə ɗəretsətseh i mədahaŋ. Nəkurom na, ndzum kanaŋ, ndzakwa na, tsezlezleŋŋe.» ");
INSERT INTO meq_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A ye abəra ka təv niye izaɗ tsekweŋ, a ye naha a kal ha bo ka dala bərut daʼar ka dala. A ɗuwulay naha me a Mbəlom, a gwaɗ: «Bəba ga, taɗə ma giye bo na, zla fagaya abəra ɗəretsətseh nakay na siye tey. Ane tuk na, kâ ge andza nakə a seŋ a neŋ aye bay, ge andza nakə a saka a nəkar aye.» ");
INSERT INTO meq_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","A maw ka təv i gawla ŋgay neheye mahkar aye na, nəteye mandzahəra eye. A gwaɗay a Piyer: «Andza niye, ka slum faya məndze tə neŋ tsezlezleŋŋe tə ɗəre kwa ɓəre nəte bay na, kəkay? ");
INSERT INTO meq_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ndzum tə ɗəre tsezlezleŋŋe ada ɗuwulumay me a Mbəlom hərwi ada kâ dəɗum a masəpete i Fakalaw bay. Məsəfəre na, a say məge wu lele eye, ane tuk na, gədaŋ kurom andaya məsəmay naha a masəpete i Fakalaw bay.» ");
INSERT INTO meq_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A ye fataya abəra masulo eye sa, a ye naha a ɗuwulay me a Mbəlom. A gwaɗ: «Bəba, taɗə ka sliye məzle fagaya abəra ɗəretsətseh nakay na siye bay na, vəleŋ gədaŋ nâ sa andza nakə a saka a nəkar aye.» ");
INSERT INTO meq_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tsa na, a maw ka təv i gawla ŋgay neheye sa. A ndzatay a gər na, nəteye mandzahəra eye. Tə mba faya məndze tə ɗəre kwa tsekweŋ bay tebiye. ");
INSERT INTO meq_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","A gər tay ha, a ye sa. A ɗuwulay me a Mbəlom andza nakə meeneŋ eye. ");
INSERT INTO meq_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tsa na, a maw ka təv i gawla ŋgay hay, a gwaɗatay: «Faya ka ndzahərumeye sa ada faya ka zəzəkumeye bo ba? Gum metsehe, anəke na, həlay eye kə slaw. Neŋ Wawa i Ndo ta vəlay ga ha a həlay i ndo i mezeleme hay tuk. ");
INSERT INTO meq_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Lətsum, takwa ta dzakwa gər! Zəbum, ndo nakə ma giye fagaya ɗaf aye, kə ndzew.» ");
INSERT INTO meq_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ahəl nakə Yesu faya ma tsikiye me mba aye na, pəslaŋ Yudas neŋgeye nakə nəte mə walaŋ i gawla i Yesu hay kuro gər eye sulo aye, a ye naha. Ti ye naha ta ndo hay haladzay ta maslalam tay hay ada ta sakwal tay hay. Maa slər tay naha na, bagwar hay i ndo neheye tə vəlaway wu a Mbəlom ta madugula i Yahuda hay. ");
INSERT INTO meq_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudas ndo məgatay ɗaf ka Yesu aye ɓa kə ɗatay ha wu nakə ma giye. A gwaɗatay: «Ndo nakə na ye na gəs na ka bo təmbolok təmbolok aye na, neŋgeye! Gəsum na.» ");
INSERT INTO meq_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yudas a həndzəɗ naha kwayaŋŋa ka təv i Yesu, a gwaɗay: «Zay ɗaw, Miter!» Tsa na, a gəs na ka bo təmbolok təmbolok. ");
INSERT INTO meq_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tsa na, Yesu a mbəɗay faya, a gwaɗay: «Dzam ga, wu nakə ka yaw məge na, ge na.» Tsa na, siye i ndo hay ti ye naha, tə wuya kura ka Yesu, tə gəs na. ");
INSERT INTO meq_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ndo nəte mə walaŋ i ndo neheye nəteye tə Yesu aye, a ŋgwaɗaw maslalam ŋgay mbəhhat, a fay ha a ndo i məsler i bagwar i ndo məvəlaway wu a Mbəlom, a ɗəsay na zləm fats ka dala. ");
INSERT INTO meq_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tsa na, Yesu a gwaɗay: «Ma ha maslalam yak a gay ŋgay eye hərwi ndo neheye ta giye vəram ta maslalam aye na, ta bəbazliye tay ha ta maslalam dərmak. ");
INSERT INTO meq_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Neŋ na sliye məzalay a Bəba ga Mbəlom, mâ sləreŋew gawla ŋgay hay gwezem haladzay anəke na, ka sər təbəɗew? ");
INSERT INTO meq_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ane tuk na, kə ge andza niye na, wu nakə tə watsa a Ɗerewel i Mbəlom ma giye bo na, ma kəkay kəla?» ");
INSERT INTO meq_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yesu a gwaɗatay a ndo hay: «Ka yumaw fagaya ta maslalam kurom hay ada ta sakwal kurom hay andza ta gəsiye ndo i məkal ɗaw? Pat pat neŋ mandza eye mə gay i məɗəslay ha gər a Mbəlom, na tətikawa, ka gəsum ga bay! ");
INSERT INTO meq_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ane tuk na, wu neheye tebiye tə ge bo aye na, hərwi ada wu nakə ndo məɗe ha bazlam i Mbəlom hay tə watsa mə Ɗerewel i Mbəlom aye tâ ge bo.» Tsa na, gawla ŋgay hay tə gər ha, ta hway faya abəra. ");
INSERT INTO meq_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ma dəba eye ndo neheye tə gəs Yesu aye na, ti ye ha Yesu a gay i Kayif bagwar i ndo məvəlaway wu a Mbəlom. Mə ɗəma na, ndo mədzaŋgawa bazlam i Mbəlom mapala eye ta madugula i Yahuda hay, nəteye mahaya gər eye. ");
INSERT INTO meq_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ahəl nakə faya ta diye ha Yesu aye na, Piyer a pay bəzay ma dəba dəreŋ hus a dalamətagay i gay i bagwar i ndo məvəlaway wu a Mbəlom. A ye naha a fələkwa a dalamətagay, a ndza ka təv i ndo niye hay faya ta tsəpiye məgeɗ aye. A say mazəbe faya ta giye ha tə Yesu na, kəkay. ");
INSERT INTO meq_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta madugula i Yahuda hay tebiye ta pəla ndo hay hərwi maraw faya me hərwi məgay sariya i məkəɗe na. ");
INSERT INTO meq_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ndo hay haladzay ti ye naha ta raw faya me. Ane tuk na, ta huta tsəveɗ məkəɗe na bay. Ka mandəve ŋgay eye na, ndo hay sulo ti ye naha, tə gwaɗ: ");
INSERT INTO meq_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Ndo nakay a gwaɗ: “Na sliye faya mambəzle ha gay i məɗəslay ha gər a Mbəlom ada ma məhəne mahkar na, na ɗəzliye na weɗeye.”» ");
INSERT INTO meq_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tə tsəne andza niye na, bagwar i ndo məvəlaway wu a Mbəlom a lətse, a gwaɗay a Yesu. «Ka mbəɗatay faya a ndo neheye təbəɗew? Tə tsik fakaya na, mey?» ");
INSERT INTO meq_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ane tuk na, Yesu a ndza ŋgway tete. Bagwar i ndo məvəlaway wu a Mbəlom a gwaɗay: «Neŋ faya na tsətsahiye fakaya tə məzele i Mbəlom nakə ma ndziye ka tor eye, mbəɗeŋew faya: Nəkar na, Kəriste Wawa i Mbəlom ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu a gwaɗay faya: «Andza nakə ka tsik aye. Ane tuk na, sərum ha, ma dazlay anəke, ka ŋgatumeŋeye a neŋ Wawa i Ndo na ndziye tə həlay i mənday i Mbəlom, neŋgeye nakə gədaŋ eye ka gər i wu hay tebiye aye. Ka ŋgatumeŋeye sa na, ma magərmbəlom na deyeweye ma pazlay.» ");
INSERT INTO meq_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Bagwar i ndo məvəlaway wu a Mbəlom a tsəne andza niye na, a ndalay haladzay. A ŋguraɗa ha petekeɗ ŋgay, a gwaɗ: «Kə tsalay ka gər a Mbəlom! Ka pəlakweye na, sa mey, na gwaɗ ka tsənum wu nakə a tsik aye. ");
INSERT INTO meq_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nəkurom ka dzalum na, kəkay?» Ndo hay ta mbəɗay faya, tə gwaɗay: «Neŋgeye ndo məge mənese, təɗe məkəɗe na.» ");
INSERT INTO meq_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tsa na, ta tufay slesleɓ ka ɗəre a Yesu, tə fay ta məpeɗe həlay, siye hay tə fay ka maholom. ");
INSERT INTO meq_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Tə gwaɗay: «Kəriste, nəkar ndo məɗe ha bazlam i Mbəlom ba! Tsikamay, maa faka na, way?» ");
INSERT INTO meq_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piyer na, neŋgeye mandza eye ma dalamətagay ma bəra. Ŋgwas wuray a gawa məsler mə gay i bagwar i ndo məvəlaway wu a Mbəlom niye, a həndzəɗ ka təv i Piyer, a gwaɗay: «Nəkar dərmak na, ndo i Yesu, ndo i Galile.» ");
INSERT INTO meq_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ane tuk na, Piyer a ɗay bərakəzaŋ a Yesu kame i ndo niye hay tebiye, a gwaɗ: «Aʼay, na sər wu nakə a saka mətsikeŋ aye bay.» ");
INSERT INTO meq_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ma dəba eye Piyer a ye a ndza sləp ka həlay məgeɗ. Ŋgwas wuray a ye ka təv ŋgay, a gwaɗatay a ndo neheye ka təv niye aye: «Ndo nakay tə ndzawa tə Yesu ndo i Nazaret!» ");
INSERT INTO meq_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piyer a ɗay bərakəzaŋ a Yesu masulo eye. A mbaɗa, a gwaɗ: «Aʼay, na gwaɗum na sər ndo niye bay tiya!» ");
INSERT INTO meq_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ma dəba i məndze tsekweŋ na, ndo neheye ka təv niye aye, ta həndzəɗ ka təv i Piyer, tə gwaɗay: «Ta deɗek, nəkar dərmak na, nəte mə walaŋ i gawla i Yesu hay. Hərwi mətsike me nakə faya ka tsikiye na, a ɗa ha təv yak nakə ka yaw abəra mə ɗəma aye.» ");
INSERT INTO meq_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tsa na, Piyer a gwaɗ: «Kə ge na raw me na, Mbəlom mâ geŋ ɗəretsətseh. Na mbaɗa na, ta deɗek na sər na ndo nakay bay.» Kwayaŋŋa dzagulok a zlaha. ");
INSERT INTO meq_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bazlam i Yesu nakə a tsik aye a mayaw a gər a Piyer. Yesu a gwaɗay: «Dzagulok ma ta zlahiye na, ɓa ka gwaɗ sik mahkar ka sər neŋ bay.» Tsa na, Piyer a yaw abəra ma dalamətagay, a tuwa tsɨɗuk tsɨɗuk. ");
INSERT INTO meq_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pərik i mekedœ na, bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta madugula i Yahuda hay tə ma ha ka bo bazlam tebiye hərwi məkəɗe na Yesu. ");
INSERT INTO meq_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tə dzawa na Yesu ada ti ye ha a gay i Pilat ŋgomna i dala i Yahuda, ndo i Roma. Tə vəlay ha a Pilat. ");
INSERT INTO meq_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yudas, ndo nakə a ge ɗaf ka Yesu aye, a zəba ta gəs na Yesu a sariya na, a dzala ka wu nakə a ge aye na, ŋgwalak eye bay. A həl kwar i suloy nakə tə vəlay kuro kuro mahkar aye, a matay naha a bagwar hay i ndo neheye tə vəlaway wu a Mbəlom ta madugula i Yahuda hay. ");
INSERT INTO meq_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","A ye naha a gwaɗatay: «Na ge mənese, hərwi na ge ɗaf ka ndo nakə kə ge mənese bay aye.» Ta mbəɗay faya, tə gwaɗay: «Bazlam yak bəna, i may mey tey.» ");
INSERT INTO meq_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudas a kutsatay naha suloy niye mə gay i məɗəslay ha gər a Mbəlom. Tsa na, a ye a həruwa bo ta ləɓer, a mət. ");
INSERT INTO meq_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom tə həl sulo niye, tə gwaɗ: «Suloy nakay na, bazlam kway mapala eye kə vəlakway tsəveɗ məpe na a gay i məɗəslay ha gər a Mbəlom bay. Suloy nakay na, i məkəɗe gər i ndo.» ");
INSERT INTO meq_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ma dəba eye, madugula i Yahuda hay tə ma ha ka bo bazlam mə walaŋ tay hərwi suloy niye na, ta səkəm guvah abəra ka ndo məŋgere gərwa. A guvah eye niye na, ta liye a ɗəma slele hay. ");
INSERT INTO meq_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hərwi niye, hus ka bəgom tə zalay a guvah eye niye na, Guvah i Bambaz. ");
INSERT INTO meq_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Andza niye, a ɗa ha na, bazlam i Zeremi ndo məɗe ha bazlam i Mbəlom nakə a tsik aye. A gwaɗ: «Tə həl kwar i suloy kuro kuro mahkar, niye na tsakala nakə ndo i Israyel hay tə gwaɗ ta vəliye hərwi ŋgay aye. ");
INSERT INTO meq_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ada ta səkəm ha guvah abəra ka ndo məŋgere gərwa andza nakə Bəy Maduweŋ Mbəlom a gweɗeŋ ge aye.» ");
INSERT INTO meq_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu neŋgeye kame i Pilat. Pilat a tsətsah faya, a gwaɗay: «Nəkar na, bəy i Yahuda hay deɗek ɗaw?» Yesu a gwaɗay faya: «Nəkar ka tsik segey.» ");
INSERT INTO meq_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta madugula hay tə ɗəs parasay ka Yesu haladzay. Ane tuk na, Yesu ka mbəɗatay faya bay. ");
INSERT INTO meq_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilat a gwaɗay: «Wu neheye faya ta tsikiye fakaya tebiye aye na, ka tsəne təbəɗew?» ");
INSERT INTO meq_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ane tuk na, Yesu ka mbəɗay faya kwa tsekweŋ bay. Niye na, a gay wadəŋ wadəŋ a Pilat. ");
INSERT INTO meq_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Magurlom i Pak kə ndzew na, ŋgomna a gərawa ha ndo i daŋgay nəte, ndo nakə a satay a ndo hay aye. ");
INSERT INTO meq_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A həlay niye na, ndoweye andaya neŋgeye seweɗ eye ma daŋgay, tə zalay Barabas. ");
INSERT INTO meq_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ndo hay tə haya gər haladzay. Pilat a tsətsah fataya, a gwaɗatay: «A sakum nâ gərakum ha na, way? Barabas tsukuɗu Yesu nakə tə zalay Kəriste aye ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilat a sər ha tə gəsay naha Yesu na, tə ge faya na, sələk kəriye. ");
INSERT INTO meq_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ahəl nakə Pilat mandza eye ka təv məge sariya aye na, ŋgwas ŋgay a slər ndo ka təv ŋgay, a ye naha a gwaɗay: «Kâ gay wuray a ndo nakay bay, hərwi kə ge mənese bay. Ta həvaɗ nakay, na sa ɗəretsətseh haladzay ma məsine hərwi ŋgay.» ");
INSERT INTO meq_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta madugula hay tə vəlatay gədaŋ a ndo hay, ta tsətsah ka Pilat mâ gəratay ha Barabas. Yesu na, mâ kəɗ na. ");
INSERT INTO meq_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilat a gwaɗatay: «Na gərakumeye ha ndo i daŋgay nəte. Mə walaŋ tay nəte a sakum nâ gərakum ha na, way?» Ta mbəɗay faya. «Gəramay ha na, Barabas!» ");
INSERT INTO meq_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilat a tsətsah fataya, a gwaɗatay: «Ada na geye a Yesu nakə tə zalay Kəriste aye na, mey?» Nəteye tebiye tə gwaɗay: «Dar na ka mayako mazləlmbaɗa eye!» ");
INSERT INTO meq_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilat a gwaɗatay: «Neŋgeye a ge na, mənese waray?» Ane tuk na, ta səkah ha mawude haladzay ta gədaŋ, tə gwaɗ: «Dar na ka mayako mazləlmbaɗa eye!» ");
INSERT INTO meq_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilat a zəba faya ma sliye məge wuray kwa tsekweŋ bay ada ndo hay faya ta dazleye mawude haladzay na, a təɗ yam, a bara həlay kame i ndo niye hay, a gwaɗatay: «Mənese i məkəɗe ndo nakay na, ka gər ga bay. Mənese eye na, ka gər kurom.» ");
INSERT INTO meq_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ndo hay tebiye ta mbəɗay faya, tə gwaɗay: «Ayaw, nəmaa təma. Mənese i məkəɗe ndo nakay mâ yaw ka gər may ada ka wawa may hay.» ");
INSERT INTO meq_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tsa na, Pilat a gəratay ha Barabas. Yesu na, a ndaɓa na ta mandalaɓa, a vəlatay ha a sidzew hay hərwi ada tâ ye tâ dar na ka mayako mazləlmbaɗa eye. ");
INSERT INTO meq_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ma dəba eye na, sidzew i Pilat hay ti ye ha Yesu a gay i ŋgomna. Ti ye naha, tə haya gər a sidzew hay tebiye. ");
INSERT INTO meq_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ta tsəkw faya abəra petekeɗ ŋgay hay. Tə pa faya petekeɗ ndozza eye. ");
INSERT INTO meq_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tə ɗəsaw dak tə slapa na ka bo, ta pay a gər a Yesu andza dzagwa i bəy. Tə vəlay sakwal a həlay. Ta dəkway gurmets a huvo ada tə ŋgwasa faya, tə gwaɗay: «Zay ɗaw, bəy i Yahuda hay?» ");
INSERT INTO meq_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ta tuf faya slesleɓ ada ta buwa faya abəra sakwal nakə mə həlay aye, tə fay ha ka gər. ");
INSERT INTO meq_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ta ndəv ha məŋgwese faya na, ta tsəkw faya abəra petekeɗ ndozza eye niye, tə ma ha faya petekeɗ ŋgay hay. Ti ye ha hərwi madar na ka mayako mazləlmbaɗa eye. ");
INSERT INTO meq_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ahəl nakə sidzew hay faya ta diye ha Yesu, ta tasiye abəra mə walaŋ gay aye na, tə dzəgər ta ndo i Siren, məzele ŋgay Simoŋ. Tə gay kutoŋ ka məzle mayako mazləlmbaɗa eye nakə ta dariye faya Yesu aye. ");
INSERT INTO meq_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tə ndisl a təv eye andaya tə zalay Golgwata, andza məgweɗe: «Təv i mətasl i gər». ");
INSERT INTO meq_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tə vəlay guzom madzapa eye tə wuye ɗuwekeke eye. Yesu a ndzaka na, a say bay. ");
INSERT INTO meq_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ma dəba eye na, ta dar na Yesu ka mayako mazləlmbaɗa eye. Tə ge tsakwal ka petekeɗ ŋgay hərwi məsəre mata hute na, way. Tsa na, ta ŋgəna ha a bo mə walaŋ tay. ");
INSERT INTO meq_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tsa na, tə ndza mə ɗəma hərwi matsəpe na Yesu. ");
INSERT INTO meq_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tə watsa gər i bazlam nakə tə kəɗ na faya Yesu aye, tə gwaɗ: «Nakay na, Yesu bəy i Yahuda hay.» Ta law na zal ka gər ŋgay. ");
INSERT INTO meq_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ta dar ndo i məkal hay sulo ka tsakay i Yesu, nəte tə həlay i mənday, neŋgeɗ tə həlay i gula. ");
INSERT INTO meq_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ndo neheye ti yawa ta təv niye na, tə ɓəlawa ha gər tay hay tekəm tekəm tə mətsaɗay pəleslesle. ");
INSERT INTO meq_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Tə gwaɗaway: «Hey! Nəkar haɓe a saka mambəzl ha gay i məɗəslay ha gər a Mbəlom ada ka gwaɗ ma məhəne mahkar na, ka ɗəzl na aye na, təv i wu yak aye na, məŋgay tuk? Nəkar təma ha bo yak eye tey! Kə ge nəkar Wawa i Mbəlom na, mbəzlaw abəra ka mayako nakay mazləlmbaɗa eye.» ");
INSERT INTO meq_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye ada ta madugula i Yahuda hay tə ŋgwasa ka Yesu. Tə gwaɗ: ");
INSERT INTO meq_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Kə təma tay ha siye i ndo hay tuk na, a sla faya mətəme ha gər ŋgay təbəɗew? A gwaɗ neŋgeye bəy i Israyel hay sa na, mâ mbəzlaw abəra ka mayako mazləlmbaɗa eye ada nəmaa dzaliye ha. ");
INSERT INTO meq_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A dzala ha ka Mbəlom sa na, a gwaɗ neŋgeye Wawa i Mbəlom. Kə ge Mbəlom a wuɗa na na, mâ təma ha anəke.» ");
INSERT INTO meq_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ndo i məkal neheye sulo ta dar tay naha ka tsakay ŋgay aye, tə tsaɗay andza niye dərmak. ");
INSERT INTO meq_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","A dazlay ta magərhəpat, ləvoŋ a ge ka dala niye tebiye tekəɗəgəm. A ge na, hus a ɓəre mahkar i huwa. ");
INSERT INTO meq_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ma giye ɓəre mahkar i huwa, Yesu a wuda ta magala kələrra, a gwaɗ: «Eli, Eli, lama sabaktani?» Andza məgweɗe: «Mbəlom ga, Mbəlom ga, ka gər ga ha na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Siye i ndo neheye ka təv aye niye tə tsəne na, tə gwaɗ: «Faya ma zaleye a Eliya!» ");
INSERT INTO meq_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kwayaŋŋa ndo nəte mə walaŋ tay niye a hway, a ye naha a zla wuye andaya kofkoffa. A tsəhuɓ ha a wuye guyakaka. A hak ka gwavəkw. Tsa na, a pay naha ka bazlam a Yesu hərwi ada mâ ɗəvətse. ");
INSERT INTO meq_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ane tuk na, siye i ndo hay tə gwaɗ: «Ŋgatay, zəbakwa faya təday, Eliya ma deyeweye ma təmiye ha ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ane tuk na, Yesu a wuda ta magala kələrra. Tsa na, a mət. ");
INSERT INTO meq_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","A həlay niye kwayaŋŋa, petekeɗ nakə a ŋgəna ha gay i məɗəslay ha gər a Mbəlom sulo aye, a ta ka bo bəra sulo tsaŋŋa kwa abəra mə gəma hus ka dala. Dala a ɓəl, hotokom hay ta ŋgəma wudəgər wudəgər. ");
INSERT INTO meq_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tsəvay hay ta həndək, ndo məpe mədzal gər hay ka Mbəlom haladzay neheye tə mət aye tə mbəlaw. ");
INSERT INTO meq_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tə ndohwaw abəra ma tsəvay. Ma dəba i mələtsew i Yesu abəra ma mədahaŋ na, ti ye a Zerozelem, gəma tsəɗaŋŋa eye. Mə ɗəma na, ndo hay haladzay ta ŋgatatay. ");
INSERT INTO meq_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Bagwar i sidzew ta sidzew niye hay faya ta həbiye ka Yesu dziye, tə ŋgatay dala a ɓəl tə wu neheye a ge bo aye tebiye na, zluwer a gatay haladzay, tə gwaɗ: «Ta deɗek, ndo nakay na, Wawa i Mbəlom!» ");
INSERT INTO meq_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ŋgwas hay haladzay nəteye malətsa eye dəreŋ faya ta zəbiye naha faya. Tə payaw bəzay a Yesu kwa abəra ma gəma i Galile, tə gaway məsler. ");
INSERT INTO meq_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mə walaŋ tay niye hay na, Mari nakə a yaw abəra ma gəma i Magədala aye, Mari maya i Yakuba ta Yusufa ada ta maya i wawa i Dzebede hay. ");
INSERT INTO meq_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Huwa a ge na, ndo wuray zlele eye a yaw. Neŋgeye ndo i gəma i Arimate, məzele ŋgay Yusufa. Neŋgeye dərmak, gawla i Yesu. ");
INSERT INTO meq_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A ye ka təv i Pilat, a tsətsah faya mədahaŋ i Yesu. Pilat a vəlay tsəveɗ ka məzle mədahaŋ i Yesu. ");
INSERT INTO meq_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufa a ye a zla na mədahaŋ i Yesu abəra ka mayako mazləlmbaɗa eye, a zla rəkwat a mbəkwa na. ");
INSERT INTO meq_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","A pa na a tsəvay nakə a la ka geseh weɗeye hərwi ŋgay eye ŋgway aye. Tsa na, a bədəŋgwal beber bagwar eye hərwi madərəzle faya. A dərəzl faya na, a ye ŋgway. ");
INSERT INTO meq_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari i Magədala ta Mari neŋgeɗ nəteye andaya mandza eye ɗəgerger bəse ta tsəvay. ");
INSERT INTO meq_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tədœ eye andza məgweɗe pat nakə a mbay naha a pat i mələve bo i mazəzukw bo aye, bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta Farisa hay, ti ye dziye a gay i Pilat. ");
INSERT INTO meq_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ti ye naha, tə gwaɗay: «Ŋgalaka, nəmaa yaw ka təv yak na, hərwi wu nakə ndo i parasay nakay a tsik ahəl niye aye na, ka mamayaw a gər. A gwaɗ: “Ma dəba i məhəne mahkar na, na lətseweye abəra ma mədahaŋ.” ");
INSERT INTO meq_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Gwaɗatay a sidzew hay na, tâ tsəpa na tsəvay lele hus a məhəne mamahkar eye bəna gawla ŋgay hay ta deyeweye ta kəliye na. Ma dəba eye ta gwaɗateye a ndo hay: “Yesu kə lətsew abəra ma mədahaŋ.” Parasay ŋgay ma səkahiye wene wene eye ma ziye nakə kurre aye.» ");
INSERT INTO meq_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat a gwaɗatay: «Həlum sidzew hay anaŋ dum tay ha ka tsəvay, tâ tsəpa andza nakə a sakumeye.» ");
INSERT INTO meq_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tə həl bo ti ye. Ti ye naha tə ləva bo tə matsəpe tsəvay. Tə slərəɓa na me i tsəvay, tə gəs na əŋgəts lele. Tsa na, tə pa sidzew hay ka matsəpe na. ");
INSERT INTO meq_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ma dəba i pat i mazəzukw bo na, pat i luma i sidzew ta mekedœ, Mari i Magədala ta Mari neŋgeɗ ti ye mazəbe ka tsəvay. ");
INSERT INTO meq_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tə ndisl naha kwayaŋŋa na, dala a ɓəl haladzay dzekiɓ dzekiɓ hərwi gawla i Mbəlom a mbəzlaw mə mbəlom, a yaw a bədəŋgwal beber abəra ka tsəvay, toŋ a ndza faya. ");
INSERT INTO meq_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Gawla i Mbəlom niye na, a dəv andza mawutseɗe ada petekeɗ ŋgay a sləɗe haladzay herre. ");
INSERT INTO meq_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Zluwer a gatay a sidzew neheye faya ta tsəpiye tsəvay aye. Ta dzədzar haladzay, ta təra andza nəteye maməta eye hay tsaɗək tsaɗək. ");
INSERT INTO meq_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Gawla i Mbəlom a gwaɗatay a ŋgwas niye hay: «Kâ dzədzarum bay. Na sər nəkurom faya ka pəlumeye Yesu, ndo nakə ta dar na ka mayako mazləlmbaɗa eye aye. ");
INSERT INTO meq_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Neŋgeye andaya kanaŋ bay, kə lətsew abəra ma mədahaŋ andza nakə a tsik aye. Dumara zəbum ka təv nakə tə həna ha faya kwa. ");
INSERT INTO meq_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Dum bəse ta gwaɗumatay a gawla ŋgay hay na: “Yesu kə lətsew abəra ma mədahaŋ, ma lahakumeye a Galile. Ka ŋgatumeye mə ɗəma.” Anaŋ wu nakə na tsikakum aye.» ");
INSERT INTO meq_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ŋgwas niye hay ta hway abəra ka tsəvay bəse. Zluwer a gatay, ane tuk na, ɗərev tay maŋgwasa eye. Ta hway məɗatay ha labara eye a gawla i Yesu hay. ");
INSERT INTO meq_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kwayaŋŋa, Yesu a yaw tə dzəgər ta nəteye, a gwaɗatay: «Na tsikakum me!» Ŋgwas niye hay ta həndzəɗ naha ka təv ŋgay, ta dəkway gurmets a huvo. Tə gəs na abəra mə sik ada tə ɗəslay ha gər. ");
INSERT INTO meq_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu a gwaɗatay: «Kâ dzədzarum bay. Dum gwaɗumatay a malamar ga hay na, tâ ye a Galile. Ta ŋgeteŋeye mə ɗəma.» ");
INSERT INTO meq_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ahəl nakə ŋgwas hay faya ta diye abəra ka tsəvay, nəteye ka tsəveɗ aye na, siye i sidzew neheye faya ta həbiye ka tsəvay aye ti ye a walaŋ i gay. Ti ye naha ta təkər wu nakə a ge bo aye tebiye a bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye. ");
INSERT INTO meq_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bəy hay i ndo neheye tə vəlaway wu a Mbəlom aye tə haya gər ta madugula i Yahuda hay. Tə ma ha ka bo bazlam mə walaŋ tay. Tə vəlatay suloy haladzay a sidzew neheye ta tsəpa tsəvay aye. ");
INSERT INTO meq_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Tə gwaɗatay: «Wu nakə ka təkərumateye a ndo hay aye na, anaŋ: “Ahəl nakə nəmay mandzahəra eye ta həvaɗ aye na, gawla i Yesu hay ta yaw, ta kəla na mədahaŋ i Yesu.” ");
INSERT INTO meq_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Taɗə ŋgomna kə tsəne na, ma gakumeye wuray bay. Nəmaa səriye wu nakə nəmaa tsikiye.» ");
INSERT INTO meq_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sidzew hay tə həl suloy nakə tə vəlatay aye. Ti ye tə ɗəs parasay andza nakə tə tsikatay aye. Andza niye, bazlam nakay a ɗa zləm a Yahuda hay tebiye hus ka bəgom. ");
INSERT INTO meq_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ma dəba eye na, gawla i Yesu hay kuro gər eye nəte ti ye a Galile. Ti ye naha, tə tsal a mahəmba nakə Yesu a gwaɗatay «Tsalum a ɗəma» aye. ");
INSERT INTO meq_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tə ndisl a ɗəma na, tə ŋgatay a Yesu, tə ɗəslay ha gər. Ane tuk na, siye mə walaŋ tay ta dzala ha faya ta deɗek eye bay. ");
INSERT INTO meq_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu a həndzəɗ ka təv tay, a gwaɗatay: «Mbəlom kə vəleŋ gədaŋ mə mbəlom ada ka məndzibəra. ");
INSERT INTO meq_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Hərwi niye, dum ha bazlam ga ka təv i ndo i gəma hay tebiye, tərum tay ha gawla ga hay. Dzəhuɓum tay ha a yam ta məzele i Bəba Mbəlom, tə məzele i Wawa ŋgay ada tə məzele i Məsəfəre Tsəɗaŋŋa eye. ");
INSERT INTO meq_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tətikumatay bazlam neheye na tsikakumeye. Tâ rəhay ha gər tebiye, tâ dzala ha faya. Ada neŋ, na ndziye tə nəkurom pat pat hus ka mandəve i məndzibəra.»");
INSERT INTO meq_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Labara ŋgwalak eye nakə a tsik ka Yesu Kəriste Wawa i Mbəlom aye, a dazlay ");
INSERT INTO meq_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","andza nakə mawatsa eye mə ɗerewel i Ezay ndo məɗe ha bazlam i Mbəlom aye, a gwaɗ: «Neŋ Mbəlom, na sləriye naha ndo məɗe ha bazlam ga kame yak. Ma lambaɗakeye na tsəveɗ. ");
INSERT INTO meq_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Faya ma wudiye mə kəsaf, a gwaɗ: Lambaɗumay tsəveɗ a Bəy Maduweŋ, lambaɗumay tsəveɗ hay fehe lele, tâ hədzak bay.» ");
INSERT INTO meq_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Andza niye, Yuhana madzəhuɓe ndo a yam a ndohwaw mə kəsaf. A tsikatay me a ndo hay, a gwaɗatay: «Mbəɗum ha mede kurom. Dzəhuɓum bo a yam ada Mbəlom ma pəsakumeye ha mənese kurom hay.» ");
INSERT INTO meq_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ndo neheye ma Zerozelem ada ka dala i Yahuda ti ye tebiye. Tə yawa ka təv i Yuhana. Tə ɗawa ha mezeleme tay hay parakka kame i ndo hay ada Yuhana a dzəhuɓawa tay ha a yam mə magayam nakə tə zalay Yurdum aye. ");
INSERT INTO meq_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yuhana niye na, petekeɗ ŋgay maŋgara eye ta məkwets i zləgweme ada a ɓarawa bəzihuɗ ŋgay na, ta həzlay. A ndayawa mə kəsaf niye na, heyew ta wum. ");
INSERT INTO meq_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Anaŋ labara nakə a tsik aye sa, a gwaɗ: «Ndo mekeleŋ eye ma deyeweye kame ga, neŋgeye na, gədaŋ eye a ze ga. Na sliye mahəndzəɗe ka təv ŋgay, məpəlay ha ləɓer i tahərak ŋgay bay tebiye. ");
INSERT INTO meq_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Neŋ na, na dzəhuɓ kurom ha a yam tsa. Neŋgeye na, ma dzəhuɓiye kurom ha ta Məsəfəre Tsəɗaŋŋa eye.» ");
INSERT INTO meq_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ma məhəne niye na, Yesu a yaw ma Nazaret ka dala i Galile. A ndislew na, Yuhana a dzəhuɓ na a yam mə magayam nakə tə zalay Yurdum aye. ");
INSERT INTO meq_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","A həlay nakə faya ma tsalaweye abəra ma yam aye na, a ŋgatay a magərmbəlom a ta ka bo bəra ndzaɗəɗəɗa. Tsa na, Məsəfəre i Mbəlom a mbəzlaw ka Yesu andza bodobodo. ");
INSERT INTO meq_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ada mətsike me a tsənew abəra mə mbəlom, a gwaɗ: «Nəkar na, wawa ga. Na wuɗa kar haladzay. Ɗərev ga faya ma ŋgwasiye tə nəkar.» ");
INSERT INTO meq_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kwayaŋŋa Məsəfəre i Mbəlom a zla na a makulkwandah. ");
INSERT INTO meq_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yesu a ndza mə kəsaf məve kuro kuro faɗ. Mə ɗəma na, a say a Fakalaw masəpete na ada mədəɗe ha a mezeleme. Mə kəsaf niye na, wu i pesl hay mə ɗəma haladzay. Gawla i Mbəlom hay ti yaw ka təv i Yesu, tə vəlay wu mənday. ");
INSERT INTO meq_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ma dəba eye na, tə gəs na Yuhana a daŋgay. Tə gəs na Yuhana na, Yesu a ye a Galile. A ɗa ha Labara Ŋgwalak eye i Mbəlom mə ɗəma. ");
INSERT INTO meq_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","A gwaɗ: «Həlay eye kə ndislew tuk, mbəɗum ha mede kurom. Təmum Labara Ŋgwalak eye i Mbəlom a ɗərev kurom hərwi Bəy i Mbəlom ka həndzəɗaw.» ");
INSERT INTO meq_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu a zəŋgal me i dəlov i Galile. Ahəl nakə faya ta zəŋgaliye me i dəlov niye aye na, a ŋgatay a ndo məgəse kəlef hay sulo. Niye hay na, Simoŋ ta malamar ŋgay Aŋdəre, faya ta kaliye gadaŋ tay a dəlov. ");
INSERT INTO meq_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Tsa na, Yesu a gwaɗatay: «Dumara, pumeŋ bəzay. Anəke faya ka həlumeye kəlef, ane tuk na, na təriye kurom ha ndo məhəlaw ndo hay.» ");
INSERT INTO meq_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tə tsəne na, tə gər ha gadaŋ tay hay, tə pay bəzay a Yesu. ");
INSERT INTO meq_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu a ye kame tsekweŋ na, a ŋgatay a Yakuba ta malamar ŋgay Yuhana. Nəteye na, wawa i Dzebede hay. A ŋgatatay na, nəteye mə kwalalaŋ i yam faya ta lambaɗiye gadaŋ tay hay. ");
INSERT INTO meq_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kwayaŋŋa Yesu a zalatay. Tə tsəne məzele i Yesu na, tə gər ha bəba tay Dzebede mə kwalalaŋ i yam ta ndo i məsler ŋgay hay, tə pay bəzay a Yesu. ");
INSERT INTO meq_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu ta gawla ŋgay hay ti ye a wuzlahgəma i Kafernahum. Pat i mazəzukw bo na, Yesu a ye a gay i maɗuwule me. Mə ɗəma na, a tətikatay a ndo hay. ");
INSERT INTO meq_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ndo hay tə tsəne matətike ŋgay nakə a tətikatay aye na, a gatay hərɓaɓəkka. Hərwi neŋgeye a tətikatay andza i ndo neheye tə dzaŋgawa bazlam i Mbəlom mapala eye bay. Ane tuk na, i ŋgay a tətikatay na, ta məzlaɓ eye. Hərwi bazlam niye hay ti yaw na, abəra mə neŋgeye ŋgway. ");
INSERT INTO meq_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ahəl nakə faya ma tətikateye a ndo hay aye na, ndo wuray məsəfəre lele bay eye, paf a ye naha a gay i maɗuwule me niye. Tsa na, a wuda ta magala kələrra. ");
INSERT INTO meq_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","A gwaɗ: «Nəkar Yesu ndo i Nazaret, mey yak ka nəmay na, mey? Ka yaw na, mata dze may ha ɗaw? Nəkar way na, na sər ha lele: Nəkar na, ndo nakə tsəɗaŋŋa Mbəlom a sləraw aye.» ");
INSERT INTO meq_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tsa na, Yesu a gay me, a gwaɗay: «Ndza ɗikɗik. Dara abəra mə bo i ndo nakay.» ");
INSERT INTO meq_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kwayaŋŋa məsəfəre lele bay eye a ɓəl ha ndo niye ta gədaŋ tə mawude eye kələrra. Tsa na, a yaw abəra mə bo i ndo niye. ");
INSERT INTO meq_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ka təv niye na, a gatay a ndo hay daɓək daɓək, hərɓaɓəkka. Tə gwaɗ mə walaŋ tay: «Eh! Eh! Nakay na, wu wuray? Labara nakay a tsik aye na, ta məzlaɓ eye. Nakay na, ndo waray, a gatay me a məsəfəre lele bay eye hay ada tə gəsay me na, ndo waray.» ");
INSERT INTO meq_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Labara i Yesu a ɗa a zləm kwayaŋŋa ka dala i Galile tebiye. ");
INSERT INTO meq_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ma dəba eye na, Yesu ta gawla ŋgay hay ti ye abəra mə gay i maɗuwule me niye, ti ye a gay i Simoŋ ta Aŋdəre. Nəteye ti ye dziye ta Yakuba ada ta Yuhana. ");
INSERT INTO meq_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tə ndisl naha na, mese i Simoŋ mahəna eye mə gay, maraɓaraɓ a gay. Tsa na, tə gwaɗay a Yesu: «Mese i Simoŋ lele bay.» ");
INSERT INTO meq_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu a ye ka təv ŋgay a gay. A ye naha na, a gəs na abəra mə həlay, a lətse ha ka mbəlom. Tsa na, maraɓaraɓ a ndala faya abəra. A ye, a gatay mbəlok. ");
INSERT INTO meq_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ta huwa ma dəba i pat mədəɗe na, ndo hay tə həlaw ndo i ɗəvats hay haladzay ta ndo neheye fakalaw mə bo tay aye. ");
INSERT INTO meq_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ndo i gəma niye hay tebiye tə haya gər ka məgeɗ i gay nakə Yesu mə ɗəma aye. ");
INSERT INTO meq_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ndo neheye ɗəvats a gatay wal wal aye na, Yesu a mbəl tay ha ada a həhar fakalaw abəra ka ndo hay haladzay dərmak. Ane tuk na, Yesu a ŋgərəz fataya, a gwaɗatay: «Kâ tsikum me bay.» Hərwi nəteye na, Yesu neŋgeye way na, tə sər na. ");
INSERT INTO meq_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pərik, mbəlomɗa i dzagulok məzlehe na, Yesu a lətse, a ndohwaw abəra mə gay. Tsa na, a ye dəreŋ abəra ma wuzlahgəma. A ye na, a təv nakə ndəray andaya mə ɗəma bay aye. A ye a ɗəma mata ɗuwule me. ");
INSERT INTO meq_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoŋ ta siye i gawla ŋgay hay ta pəɗeke abəra ka məndzehəre na, ta ŋgatay a Yesu bay. Tsa na, ti ye ta pəla na Yesu. ");
INSERT INTO meq_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ka təv nakə faya ta pəliye na aye na, ta huta na. Tə gwaɗay: «Ndo hay haladzay faya ta pəliye kar.» ");
INSERT INTO meq_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu a gwaɗatay: «Kwa ta pəliye ga bəbay na, takwa a təv mekeleŋ. Ka deyekweye na, a gəma neheye bəse bəse aye. Na ɗiye ha bazlam i Mbəlom mə ɗəma dərmak. Na yaw na, hərwiye.» ");
INSERT INTO meq_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","A ndəv ha mətsike me ŋgay niye na, a lətse a ye a həhal ka dala i Galile tebiye. A ɗawa ha bazlam i Mbəlom mə gay i maɗuwule me ada a həharawa fakalaw abəra ka gər mavuwe hay. ");
INSERT INTO meq_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pat wuray na, ndo wuray madəgwaɗa eye a ye ka təv i Yesu. A ye naha na, a dəkw gurmets kame i Yesu. A tsətsah ka Yesu, a gwaɗay: «Kə saka na, ka sliye faya matəre ga ha tsəɗaŋŋa.» ");
INSERT INTO meq_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu a zəba faya na, a gay mə bo. A nduɗa ha həlay ŋgay, a lamay. Tsa na, a gwaɗay: «A seŋ na, təra tsəɗaŋŋa!» ");
INSERT INTO meq_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tsa na, ɗəvats i madəgweɗe a ye faya abəra. A mbəl suwuɗ suwuɗ lele. ");
INSERT INTO meq_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ane tuk na, Yesu a gay me, ada a gwaɗay: ");
INSERT INTO meq_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Do, ka diye wu yak na, tsəne lele hədzakay zləm.» Tsa na, Yesu a gwaɗay: «Tsəne lele: Kâ tsik wu nakay a ndəray bay. Ane tuk na, do ta bəzay ha bo a ndo məvəlay wu a Mbəlom ada vəl wu nakə Musa a tsik aye hərwi məɗatay ha a ndo hay tebiye na, ka təra tsəɗaŋŋa.» ");
INSERT INTO meq_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma dəba eye na, ndo niye a ye. A ye naha ɗuh na, a pa bo ka matəkəratay wu nakə a təra tə neŋgeye aye a ndo hay. Yesu kə sla faya mabəz ha bo ma wuzlahgəma sa bay. A ndzawa na, dəreŋ ta wuzlahgəma, ma təv neheye ndo hay mə ɗəma haladzay bay aye. Ada huya, ndo hay ti yawa ka təv ŋgay kwa məŋgay, kwa məŋgay. ");
INSERT INTO meq_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","A ndza məhəne tsakway na, Yesu a mbəɗa gər a Kafernahum. Ndo hay tə tsəne Yesu kə maw a Kafernahum, neŋgeye mə gay nakə a ndzawa mə ɗəma aye na, ");
INSERT INTO meq_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ndo hay ti ye, tə haya gər haladzay ka təv ŋgay. Tə rah a gay niye ɓərits. Kwa ma bəra, ka me i məgeɗ bəbay, təv andaya bay hərwi ndo hay. Tə haya gər andza niye na, hərwi Yesu a tətikawatay bazlam i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ahəl nakə Yesu faya ma tətikateye bazlam i Mbəlom a ndo hay aye na, ndo hay faɗ tə zlay naha ndo matəra eye madzawa eye ka sləlah. ");
INSERT INTO meq_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ta pəla tsəveɗ mede ha ka təv i Yesu na, ta huta tsəveɗ bay, hərwi ndo hay haladzay ka tsəveɗ. Tsa na, tə tsal ka gər i gay niye. Gər i gay niye na, fatata. Tə sləl bəɗ. Ta ɗaŋgar ha ta təv nakə Yesu mə ɗəma aye. Tə mbəzla ha ndo matəra eye niye ta ləɓer ka təv i Yesu ta sləlah ŋgay niye dzay. ");
INSERT INTO meq_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu a zəba ka mədzal gər tay nakə tə dzala ha faya na, a gwaɗay a ndo niye matəra eye: «Wawa ga, na pəsaka ha mezeleme yak hay.» ");
INSERT INTO meq_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mə gay niye na, ndo mədzaŋgawa bazlam i Mbəlom mapala eye, nəteye andaya mandza eye dərmak. Tə tsəne andza niye na, tə dzala mə gər tay, tə gwaɗ: ");
INSERT INTO meq_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Ndo nakay a tsik me i ŋgay andza niye na, kəkay? Nakay na, a tsalay ka gər a Mbəlom. Bəna way nakə ɗa məpəsay ha mezeleme a ndo aye? Maa sla məpəsay ha mezeleme a ndo na, Mbəlom nəte ŋgweŋ bəna, way?» ");
INSERT INTO meq_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tsa na, Yesu a sər wu nakə tə dzala mə gər tay aye, a gwaɗatay: «Ka dzalum andza niye mə gər kurom na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Maa da me məgwaɗay a ndo matəra eye: “Mezeleme yak kə pəsa” na, waray, kəgəbay “Lətse zla sləlah yak do” na, maa da me mə ɗəma na, waray? ");
INSERT INTO meq_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","A seŋ na, sərum ha neŋ Wawa i Ndo na, gədaŋ ga andaya məpəsatay ha mezeleme a ndo hay ka məndzibəra.» Tsa na, a gwaɗay a ndo niye matəra eye: ");
INSERT INTO meq_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Faya na gwaɗakeye, lətse, zla sləlah yak, do a mətagay.» ");
INSERT INTO meq_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yesu a tsikay andza niye na, kwayaŋŋa a lətse, a zla sləlah ŋgay. A ye kame i ndo niye hay mahaya gər eye duwak duwak lele, a yaw abəra. Ndo niye hay mbərzəzza eye tə ŋgatay na, a gatay hərɓaɓəkka. Ta zambaɗay a Mbəlom tə gwaɗ: «Eh! Eh! Nakay na, gədaŋ i Mbəlom bəna, ka ŋgatakway a wu andza nakay ɗaɗa bay.» ");
INSERT INTO meq_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ma dəba eye na, Yesu a mbəɗa gər, a ye ka me i dəlov nakə tə zalay dəlov i Galile aye. Ndo hay haladzay tə yawa naha ka təv ŋgay. A tətikawatay bazlam i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yesu a ndəv ha matətike, a lətse faya ma diye ka tsəveɗ na, a ndzay a gər a ndo matsekele dzaŋgal ka təv i məsler ŋgay. Ndo niye na, tə zalay Levi. Neŋgeye na, wawa i Alfe. Yesu a gwaɗay: «Dara, peŋ bəzay!» Tsa na, Levi a lətse a pay bəzay. ");
INSERT INTO meq_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pat wuray na, Yesu ta gawla ŋgay hay tə nda wu mənday mə gay i Levi. Ndo matsekele dzaŋgal hay ada ta ndo i mezeleme hay tə nda wu mənday dziye tage Yesu. Nəteye tebiye tə pay bəzay a Yesu. ");
INSERT INTO meq_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mə ɗəma na, ndo neheye tə dzaŋgawa bazlam i Mbəlom mapala eye a ndo hay aye ta Farisa hay, nəteye andaya dərmak. Tə ŋgatay a Yesu faya ma ndiye wu mənday ta ndo i mezeleme hay na, tə gwaɗatay a gawla i Yesu hay: «A nda wu mənday ka təv eye nəte ta ndo matsekele dzaŋgal hay ada ta ndo i mezeleme hay na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu a tsəne bazlam tay niye na, a gwaɗatay: «Ndo neheye wuray a gatay bay nəteye zayzay aye na, ta pəliye ndo i sidem bay. Mata pəle ndo i sidem na, ndo neheye ɗəvats eye hay aye. Na yaw məzalatay a ndo neheye tə gwaɗay a gər tay nəteye ŋgwalak eye hay aye bay, ane tuk na, məzalatay a ndo i mezeleme hay ɗuh.» ");
INSERT INTO meq_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Pat wuray na, gawla i Yuhana hay ta Farisa hay, ta ge daliyam andza nakə tə gawa ma slala tay aye. Ndo hay tə yaw ta tsətsah ka Yesu, tə gwaɗay: «Gawla i Yuhana ta Farisa hay nəteye na, ta ge daliyam. Ada hərwi mey gawla yak hay tə ge daliyam bay na, kemey?» ");
INSERT INTO meq_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu a mbəɗatay faya, a gwaɗatay: «Nəteye na, ta giye daliyam bay, hərwi nəteye na, andza mə magurlom i məzle dahəlay. Ahəl nakə zal i dahəlay ka təv tay mba aye na, ndo neheye mazala eye a magurlom i məzle dahəlay na, ta giye daliyam ɗaw? Ahəl nakə zal i dahəlay andaya mba na, ta sliye faya məge daliyam bay. ");
INSERT INTO meq_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ane tuk na, pat eye ma slaweye na, ta gəsiye fataya abəra zal i dahəlay niye. Pat eye niye na, ta giye daliyam tuk. ");
INSERT INTO meq_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Bazlam nakay na, andza petekeɗ guram eye tə weɗeye. Ta nasiye ha petekeɗ weɗeye mətepe ka petekeɗ guram eye bay. Hərwi taɗə ta tapa petekeɗ weɗeye ka guram eye na, petekeɗ weɗeye ma ŋgərɗiye ha petekeɗ guram eye. Tsa na, ma ŋguraɗiye. Petekeɗ guram eye niye ma səkahiye maŋgureɗe haladzay. ");
INSERT INTO meq_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","«Sa na, ndo ma mbəɗiye guzom lelem eye a gwezem i həzlay guram eye bay na, ka sərum ha təbəɗew. Hərwi ta mbəɗa a ɗəma na, guzom niye lelem eye kə kwasa na, həzlay niye guram eye ma ndohwiye. Guzom dərmak səktih ma mbəɗiye ka dala. Ane tuk na, guzom lelem eye ta mbəɗiye na, a gwezem i həzlay weɗeye dərmak.» ");
INSERT INTO meq_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pat i mazəzukw bo na, Yesu ta gawla ŋgay hay ti ye ta guvah wuray. Ma guvah niye tə ge a ɗəma na, wuye andaya tə zalay bəle. Gawla i Yesu hay tə həɓ wu niye, tə nda. ");
INSERT INTO meq_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farisa hay tə ŋgatatay na, tə gwaɗay a Yesu: «Zəba, gawla yak hay ta giye wu nakə bazlam i Mbəlom mapala eye a ge faya me pat i mazəzukw bo aye na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu a mbəɗatay faya, a gwaɗatay: «Ɗaɗa ka dzaŋgum wu nakə Davit a ge ahəl niye aye təbəɗew? May a wur faya ta ndo ŋgay hay. ");
INSERT INTO meq_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tsa na, a ye a fələkwa a madzawadzawa i məɗəslay ha gər a Mbəlom. A ye naha, a zla makwala nakə tə vəlay a Mbəlom aye. A nda. A vəlatay a ndo ŋgay hay dərmak, tə nda. Bazlam i Mbəlom mapala eye a vəl tsəveɗ ka mənde na, a ndo məvəlay wu a Mbəlom ɗekɗek bəɗaw? Wu nakay a ge bo na, ahəl nakə Abiyatar neŋgeye bagwar eye i ndo məvəlaway wu a Mbəlom aye.» ");
INSERT INTO meq_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu a gwaɗatay sa: «Mbəlom a vəl pat i mazəzukw bo na, ada mâ dzəna ndo zezeŋ bəna, Mbəlom a ge ndo zezeŋ hərwi məpay bəzay bay.» ");
INSERT INTO meq_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","A gwaɗatay: «Maa ləvay gər a pat i mazəzukw bo na, neŋ Wawa i Ndo.» ");
INSERT INTO meq_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pat eye andaya na, Yesu a ye a gay i maɗuwule me. Mə ɗəma na, ndoweye andaya həlay ŋgay maməta eye. ");
INSERT INTO meq_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ndo mekeleŋ eye hay andaya mə gay i maɗuwule me niye dərmak. Tə dzala mə gər tay, tə gwaɗ: «Zəbakwa faya lele, ŋgatay ma mbəliye ha ndo nakay maməta həlay eye pat i mazəzukw bo ɗaw?» Tə tsik andza niye na, hərwi məhəle faya bəra suwat. ");
INSERT INTO meq_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu a gwaɗay a ndo niye həlay ŋgay maməta eye: «Lətse ka niye kame i ndo hay tebiye.» ");
INSERT INTO meq_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tsa na, Yesu a tsətsah ka ndo neheye ta zəbiye faya aye. A gwaɗatay: «Bazlam kway mapala eye a vəl tsəveɗ məge na, mey? A gwaɗ: Gum ŋgwalak pat i mazəzukw bo tsukuɗu, gum na, seweɗ ɗaw? Məmbəle ha ndo tsukuɗu məgər ha mâ mət ɗaw?» Ane tuk na, ta mbəɗay faya bay. ");
INSERT INTO meq_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu a zəba fataya na, a ndalay haladzay, hərwi ta kula ha mədzele gər tay. Tsa na, a gwaɗay a ndo niye həlay maməta eye: «Nduɗa ha həlay yak.» A nduɗa ha na, həlay ŋgay a mbəl suwuɗ suwuɗ. ");
INSERT INTO meq_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tsa na, Farisa hay ti yaw a bəra mə gay i maɗuwule me niye. Tə haya gər ta ndo i Herod hay. Tə haya gər na, hərwi ta hutiye tsəveɗ ka məkəɗe Yesu na, kəkay. ");
INSERT INTO meq_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu ta gawla ŋgay hay ti yaw abəra mə gay i maɗuwule me niye dərmak. Ti ye ka me i dəlov nakə tə zalay dəlov i Galile aye. Ndo hay haladzay tə patay bəzay. Ndoweye neheye na, ti yaw abəra ma Galile, ti yaw abəra ka dala i Yahuda ");
INSERT INTO meq_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","kwa ndo neheye ma Zerozelem aye dərmak. Ti yaw abəra ka dala i Idume ada ta ndo neheye ta diye i magayam i Yurdum aye, ti yaw abəra ma gəma neheye tə mbay naha a Tir ta Sidoŋ aye. Ndo neheye ti yaw haladzay ka təv i Yesu aye na, hərwi tə tsəne wu nakə Yesu a gawa aye. ");
INSERT INTO meq_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesu a ŋgatatay a ndo neheye haladzay ti ye naha ka təv ŋgay aye na, a gwaɗatay a gawla ŋgay hay: «Ləvum bo ta kwalalaŋ i yam. Na tsaliye a ɗəma, hərwi ada ndo hay tâ dzəgəɗ ga ha bay.» ");
INSERT INTO meq_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Andza nakə Yesu a mbəlawa tay ha ndo i ɗəvats hay haladzay aye na, ndo i ɗəvats hay tebiye ta hway ka təv ŋgay hərwi matətele faya. ");
INSERT INTO meq_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ndo neheye fakalaw mə bo tay aye tə ŋgatay a Yesu na, tə kal ha bo kame i Yesu. Ta wuda, tə gwaɗ: «Nəkar na, Wawa i Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ane tuk na, Yesu a gatay me, a gwaɗatay: «Neŋ way na, kâ tsikumay a ndəray bay.» ");
INSERT INTO meq_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tsa na, Yesu a zalatay a ndo neheye a say mə ɗərev ŋgay aye. Tə tsal a tsaholok. ");
INSERT INTO meq_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ma tsaholok niye na, a pala ndo i maslaŋ ŋgay hay kuro gər eye sulo abəra mə walaŋ tay niye. A pala tay ha na, hərwi ada ta ndziye dziye ada ma sləriye tay ha mata ɗa ha labara i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma vəlatay gədaŋ ka mahəhere fakalaw abəra ka ndo hay dərmak. ");
INSERT INTO meq_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Məzele i ndo neheye Yesu a pala tay ha kuro gər eye sulo aye na, anaŋ: Simoŋ nakə Yesu a pa faya məzele Piyer, ");
INSERT INTO meq_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakuba ta malamar ŋgay Yuhana, nəteye wawa i Dzebede, a pa fataya məzele na, Bowenerges, andza məgweɗe wawa i maləve i Mbəlom, ");
INSERT INTO meq_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ada Aŋdəre, Filip, Bartelemi, Mata, Tomas, Yakuba wawa i Alfe, Tade, Simoŋ ndo məge vəram hərwi dala ŋgay, ");
INSERT INTO meq_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ada Yudas Iskariyot ndo məge ɗaf ka Yesu. ");
INSERT INTO meq_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ma dəba eye na, Yesu a maw a gay nakə a ndzawa mə ɗəma aye. Tsa na, slala i ndo neheye tə yawa naha ka təv ŋgay haladzay aye na, ti ye naha ka təv ŋgay haladzay sa. Hərwi niye, Yesu ta gawla ŋgay hay tə huta həlay i mənde ɗaf kwa tsekweŋ bay tebiye. ");
INSERT INTO meq_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ndo ŋgay hay tə tsəne andza niye na, ti ye mata gəsa ahaya Yesu. Hərwi tə gwaɗ: «Neŋgeye na, andza gər mavuwe.» ");
INSERT INTO meq_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ndo neheye tə dzaŋgawa bazlam i Mbəlom mapala eye ti yaw abəra ma Zerozelem, tə gwaɗawa: «Yesu na, Bedzabul mə bo ŋgay.» Siye hay tə gwaɗawa: «Maa vəlay gədaŋ ka mahəhere fakalaw na, bəy i fakalaw hay.» ");
INSERT INTO meq_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu a zalatay a ndo niye hay a tsikatay me ta dzeke, a gwaɗatay: «Bəy i Fakalaw tə Fakalaw ta həhariye bo tay na, ma kəkay? ");
INSERT INTO meq_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Taɗə gəma ka ŋgəna, faya ta giye magazləga mə walaŋ tay na, gəma niye ma hutiye gədaŋ məndze huya ɗaw? ");
INSERT INTO meq_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Taɗə ndo hay mə gay tay faya ta giye magazləga mə walaŋ tay na, ndo neheye mə gay niye na, ta hutiye gədaŋ məndze huya ɗaw? ");
INSERT INTO meq_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ka dzalum na, bəy i Fakalaw ma həhariye bo ŋgay ɗaw? Ka həhar bo ŋgay na, gədaŋ ŋgay ma ndziye bay, ma dziye. ");
INSERT INTO meq_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«Ka sərum təbəɗew ndo ma sliye faya məfələkwe a gay i ndo i gədaŋ məhəla ahaya wu ŋgay bay. Ma ta sliye məfələkwe na, ma lahiye mədzewe na təday. Kə dzawa na tuk na, ma sliye faya mede a gay, mahəla ahaya wu ŋgay hay tuk. ");
INSERT INTO meq_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Sərum ha na, Mbəlom ma pəsatay ha mezeleme a ndo hay. Kwa bazlam tay nakə ta tsik lelebay ka Mbəlom aye na, Mbəlom ma pəsatay ha. ");
INSERT INTO meq_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ane tuk na, anaŋ ndo kə tsalay ka gər a Məsəfəre Tsəɗaŋŋa eye na, ɗaɗa ma hutiye məpəse me təbey. Mezeleme ŋgay ma ndziye ka tor eye.» ");
INSERT INTO meq_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu a tsikatay andza niye na, hərwi tə gwaɗawa: «Neŋgeye na, gər mavuwe.» ");
INSERT INTO meq_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","May i Yesu ta malamar i Yesu hay tə ndisl naha tuk. Tə ndisl naha na, tə lətse ma bəra. Tsa na, tə slər ndo məzalay naha a Yesu. ");
INSERT INTO meq_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ka təv eye niye na, ndo hay haladzay mandza eye. Tə lawara na Yesu a wuzlah. Ndo nakə tə slər naha aye a gwaɗay a Yesu: «Pa zləm təday. May yak ta malamar yak hay faya ta tsətsahiye kar ma bəra.» ");
INSERT INTO meq_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu a mbəɗay faya, a gwaɗay: «May ga ta malamar ga hay na, way hay?» ");
INSERT INTO meq_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tsa na, a zəba ka ndo niye hay, a dzaha gər tuwzik ada a gwaɗ: «May ga ta malamar ga hay na, nəteye anaŋ. ");
INSERT INTO meq_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Hərwi matəra malamar ga ta may ga na, ndo neheye faya ta giye wu nakə a say a Mbəlom aye.» ");
INSERT INTO meq_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu a ye mata ɗa ha labara i Mbəlom ka me i dəlov nakə tə zalay dəlov i Galile aye sa. Ndo hay haladzay tə haya gər ka təv ŋgay. Tsa na, Yesu a tsal a kwalalaŋ i yam ada a ndza a ɗəma. Kwalalaŋ i yam niye na, ka gər i dəlov i Galile niye. Ndo neheye haladzay tə haya gər ka təv ŋgay aye na, nəteye mandza eye ka dala bəse ka pəpəz i dəlov. ");
INSERT INTO meq_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A tətikawatay wu hay haladzay ta dzeke. Ada matətike ŋgay nakə faya ma tətikateye na, a gwaɗawatay: ");
INSERT INTO meq_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Tsənum! Ndo wuray a ndohwaw abəra mə gay. A həl hulfe ŋgay, a ye ha a pesl mata sləge. ");
INSERT INTO meq_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","A ye naha na, a dazlay a masləge. Ahəl nakə faya ma kutsiye hulfe ŋgay a guvah aye na, siye hay tə kuts ka tsakay i tsəveɗ. Ɗiyeŋ hay ti yaw, tə pala na tebiye. ");
INSERT INTO meq_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Hulfe mekeleŋ eye a dəɗ ka sik i pəlaɗ, təv nakə bətekwew andaya faya haladzay bay aye. Hulfe niye hay tə ndzohwaw bəse tsa. Tə ndzohwaw bəse na, hərwi bətekwew andaya ka sik i pəlaɗ niye bay. ");
INSERT INTO meq_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ane tuk na, pat a tsaraw, a zla faya abəra ŋgulak na, a fəka na hulfe neheye tə ndzohwaw aye. Tə kula heryew heryew hərwi ta huta bəɗ məpe zləlay haladzay bay. ");
INSERT INTO meq_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Neŋgeɗ a dəɗ a gay i dak. Dak niye hay tə gəl. Tsa na, dak niye hay tə ŋgəɗətsa na hulfe niye a ndzohwaw aye, kwa hulfe niye hay ta ge bo bay ada ta nah bay. ");
INSERT INTO meq_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Siye sa na, tə kuts ka təv lele eye, tə ndzohwaw na, lele. Tə gəl ada tə nah, gər eye həɓəts həɓəts lele. Mə walaŋ tay niye na, neheye hohway tay hay makwehe nəte na, wur eye kuro kuro mahkar, siye hay a ge kuro kuro məkwa, mekeleŋ eye hay a ge temerre.» ");
INSERT INTO meq_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu a ndəv ha andza niye na, a gwaɗatay: «Ndo nakə zləm andaya mətsəne aye na, mâ tsəne lele!» ");
INSERT INTO meq_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ahəl nakə Yesu ta ndo neheye tə ndzawa ka təv ŋgay ada ta gawla ŋgay hay ti ye abəra ka təv i ndo niye hay haladzay aye, ka təv nakə nəteye mahəteye na, gawla ŋgay hay ta tsətsah faya tə gwaɗay: «Dzeke niye a say məgweɗe na, mey?» ");
INSERT INTO meq_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu a mbəɗatay faya, a gwaɗatay: «Nəkurom na, Mbəlom kə ɗakum ha wu nakə maŋgaha eye ma bəy ŋgay aye. Ane tuk na, ndo siye hay ta tsəniye wu hay na, ta dzeke. ");
INSERT INTO meq_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Andza niye nəteye na, “Ta zəbiye faya tə ɗəre tay ada ta ŋgateye bay. Ta tsəne tə zləm tay ada ta səriye ha andza məgweɗe mey na, ta səriye ha bay. Bəna ta ta maweye ka təv i Mbəlom ada Mbəlom ma ta pəsatay ha mezeleme tay.”» ");
INSERT INTO meq_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tsa na, Yesu a gwaɗatay: «Nəkurom, ka tsənum dzeke nakay a say məgweɗe mey na, ka tsənum bəɗaw? Ka tsənum dzeke nakay bay na, ada ka sərumeye siye i dzeke mekeleŋ eye hay na, ma kəkay tuk? ");
INSERT INTO meq_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","A say məgweɗe na, anaŋ: Ndo masləge a sləga bazlam i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ndo mekeleŋ eye hay ta ndzəkit bo andza tsakay i tsəveɗ. Bazlam i Mbəlom a dəɗ ka tsakay i tsəveɗ eye niye. Ndo neheye tə tsəne aye na, Fakalaw a yaw a buwa na bazlam i Mbəlom niye masləga eye ma nəteye. ");
INSERT INTO meq_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","«Siye hay ta ndzəkit bo sik i pəlaɗ nakə hulfe a kuts faya aye. Nəteye tə tsəne bazlam i Mbəlom kwayaŋŋa na, ta təma tə məŋgwese. ");
INSERT INTO meq_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ane tuk na, ta gəray tsəveɗ a bazlam i Mbəlom ada mâ pa zləlay a ɗərev tay bay. Tə dzala ha faya na, tsekweŋ tsa. Ma dəba eye ɗəretsətseh kəgəbay madzəgur me a ndzatay a gər hərwi bazlam i Mbəlom. Tsa na, tə gər ha mədzele gər abəra ka Mbəlom ta bəse. ");
INSERT INTO meq_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","«Ndo mekeleŋ eye hay ta ndzəkit bo ta hulfe nakə a dəɗ a gay i dak aye. Tə tsəne bazlam i Mbəlom, ");
INSERT INTO meq_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ane tuk na, mədzal gər ka wu i məndzibəra, bor i zlele ada ta bor i wu mekeleŋ eye hay wal wal yuh a ye tay a bo. Wu niye hay tə ŋgəɗətsa na bazlam i Mbəlom nakə mə ɗərev tay aye. Tsa na, bazlam i Mbəlom dərmak kə wa hohway mə ɗərev tay bay. ");
INSERT INTO meq_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","«Ndo mekeleŋ eye hay ta ndzəkit bo ta dala nakə lele aye. Hulfe a kuts faya na, a ndzohw lele. Nəteye tə tsəne bazlam i Mbəlom na, ta təma a ɗərev tay lele. Bazlam i Mbəlom a gəl mə ɗərev tay lele ada a nah. Neŋgeɗ, makwehe nəte na, wur eye kuro kuro mahkar, neŋgeɗ sa na, wur eye kuro kuro məkwa ada siye temerre.» ");
INSERT INTO meq_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tsa na, Yesu a tsikatay dzeke sa, a gwaɗatay: «Ndo ma zlaweye lalam ŋgay ma piye faya ako ada ma hurəkwiye faya gəse ɗaw? Kəgəbay, ma piye na a dəba i sləlah ɗaw? Ma piye na ɗuh na, ka wu məpe lalam bəɗaw? ");
INSERT INTO meq_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ma piye na ka wu məpe lalam na, hərwi ada ɗəre mâ zəba dzaydzay ada wu neheye ɗəre a ŋgatay bay aye na, mâ zəba lele. Wu neheye maŋgaha eye ta ta zəbiye mə dzaydzay. ");
INSERT INTO meq_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ndo nakə zləm andaya mətsəne aye na, mâ tsəne lele!» ");
INSERT INTO meq_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesu a gwaɗatay sa: «Gumay metsehe a wu nakə ka tsənum aye! Ndoweye kə pay zləm lele na, Mbəlom ma səkaheye ha mətsəne, hərwi ada mâ tsəne lele. Hərwi Mbəlom ma ləvakumeye wu tə wu nakə ka ləvawumatay wu a ndo hay aye. ");
INSERT INTO meq_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Hərwi ndo nakə wu ŋgay andaya na, ta səkahay ha sa. Ane tuk na, ndo nakə wuray ŋgay andaya bay aye na, kwa tsekweŋ eye nakə andaya faya aye na, ta buwiye na.» ");
INSERT INTO meq_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu a gwaɗatay sa: «Anaŋ Bəy i Mbəlom a ndzəkit bo na, andza ndo wuray a həl hulfe a ye a sləga na a guvah ŋgay. ");
INSERT INTO meq_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ma dəba eye huwa a ge na, ndo niye a ye ŋgway a mətagay. Ta həvaɗ na, a ndzahərawa ada ta həpat na, a pəɗekawa abəra ka məndzehəre, a lətsawa ka mbəlom. Ahəl nakə faya ma giye andza niye na, hulfe nakə masləga aye a ndzohw ada faya ma gəliye. Neŋgeye na, wu nakə a sləga aye faya ma gəliye ma kəkay na, a sər bay. ");
INSERT INTO meq_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Dala a ndzohwa ahaya wu niye ka gər bo ŋgay. A ndzohw a dazlay na, səmber aye ka me i bəɗ. Tsa na, a ye tə gər. Ma dəba eye na, a pa wur ada a nah lele. ");
INSERT INTO meq_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","A nah tsa na, ndo i guvah a zla bembek ŋgay a ye mata dze na wu ŋgay niye hərwi həlay məpele wu abəra ka dala kə sla.» ");
INSERT INTO meq_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu a gwaɗatay sa: «Ka ndzəkitakway ha Bəy i Mbəlom sa tə mey? Ka dəɗakwatay ha labara nakay a zləm a ndo hay na, ta dzeke waray? ");
INSERT INTO meq_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Anaŋ Bəy i Mbəlom a ndzəkit bo sa na, andza wur i ɓəzaŋ. Ahəl nakə ta sləgiye mba na, mə walaŋ i wur i wu neheye ka məndzibəra tebiye na, neŋgeye tsekweŋ. ");
INSERT INTO meq_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ane tuk na, ta sləga na, ma ndzohwiye. Kə ndzohw na, ma gəliye a ze ala neheye tə sləga ka dədaŋ aye tebiye. A təra andza gərɗaf, ɗiyeŋ hay ta ŋgariye faya gay tay ada mezek eye ma gateye ŋgama.» ");
INSERT INTO meq_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Andza niye, Yesu a tsikawatay labara ŋgay a ndo hay tebiye na, ta dzeke andza nakay anaŋ eye. A tsikawatay na, wu nakə ndo neheye ta sliye faya mətsəne lele aye. ");
INSERT INTO meq_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yesu a tsikawatay wu hay na, ze mətsike ta dzeke bay. A tsikawatay na, ta dzeke. Ane tuk na, ahəl nakə nəteye mahəteye ta gawla ŋgay hay aye na, dzeke eye a say məgweɗe mey na, a ɗawatay ha tebiye. ");
INSERT INTO meq_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pat eye niye huwa a ge na, Yesu a gwaɗatay a gawla ŋgay hay: «Lətsakwa! Takwa! Tasakwa a diye i dəlov neŋgeɗ.» ");
INSERT INTO meq_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tə lətse, tə gər tay ha ndo hay ka niye. Gawla ŋgay hay tə zla na ta kwalalaŋ i yam nakə neŋgeye mə ɗəma aye. Siye i kwalalaŋ i yam mekeleŋ eye hay andaya bəse ka təv ŋgay sa. ");
INSERT INTO meq_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ahəl nakə faya ta diye, ta tasiye a diye i dəlov neŋgeɗ aye na, vavəray bagwar eye a ge haladzay. Yam a tsal ka bo ɗaŋgwala wekit wekit ada faya ma viye a kwalalaŋ i yam niye, mazlambar ma rahiye a ɗəma. ");
INSERT INTO meq_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu na, neŋgeye ŋgway duk ma dəba, mə huɗ i kwalalaŋ niye ada neŋgeye mandzahəra eye. Gər ŋgay mapa eye ka təv gər. Gawla ŋgay hay ta dzədzar haladzay, ta pəɗeke ha abəra ka məndzehəre tə gwaɗay: «Ndo matətike ndo, faya ka mətakweye na, a gaka mə gər təbəɗew?» ");
INSERT INTO meq_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tsa na, Yesu a pəɗeke abəra ka məndzehəre. A lətse, a ŋgərəz ka mətasl, a gay me ada a gwaɗay a dəlov niye: «Ndza ɗikɗik!» Kwayaŋŋa mətasl a gər ha məge. Məɓəle i wuray kwa tsekweŋ andaya sa bay. ");
INSERT INTO meq_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tsa na, Yesu a gwaɗatay a gawla ŋgay hay: «Ka dzədzarum kate na, hərwi mey? Ka dzalum ga ha zuk bəɗaw?» ");
INSERT INTO meq_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kwayaŋŋa ta dzədzar haladzay, tə gwaɗ a bo mə walaŋ tay: «Nakay i ŋgay ndo waray nakə a gay me a mətasl ta yam na, tə gəsay me aye?» ");
INSERT INTO meq_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ma dəba eye na, Yesu ta gawla ŋgay hay tə ndisl a diye i dəlov niye. Təv eye niye ti ye a ɗəma aye na, dala i Geraseni hay. Tə ndisl a ɗəma na, tə mbəzlaw abəra mə kwalalaŋ i yam. ");
INSERT INTO meq_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu a mbəzlaw abəra mə kwalalaŋ i yam na, kwayaŋŋa ndo wuray a ndohwaw abəra mə walaŋ i tsəvay hay, hərwi mede ka təv i Yesu. Ndoweye niye na, məsəfəre lele bay eye mə bo. ");
INSERT INTO meq_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","A ndzawa na, mə walaŋ i tsəvay hay. Ndəray kwa nəte a mba faya məgəse ada mədzewe na bay. Kwa mədzewe tə tsalalaw bəbay na, ndəray a mba faya bay. ");
INSERT INTO meq_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Haɓe tə dzawaway na sik tə səselek ada tə paway tsalalaw a həlay. Wu neheye tə dzawa ha aye na, a ŋgəzlah ndərtsətsətse. Ndəray kwa nəte a mba faya məgəse na bay. ");
INSERT INTO meq_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ta huwa, kwa ta həpat a həhalawa na, mə walaŋ i tsəvay hay ada mə mahəmba. A həhalawa na, tə mawude eye ada a tawa bo ŋgay tə kwar tsuraɗ tsuraɗ. ");
INSERT INTO meq_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Gər mavuwe niye a ŋgatay naha a Yesu dəreŋ na, a hway ka təv ŋgay. A hway naha na, a dəkway gurmets a huvo. ");
INSERT INTO meq_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Tsa na, a wuda ta gədaŋ, a gwaɗ: «Nəkar Yesu Wawa i Mbəlom Fetek, ka wuɗa ka neŋ na, mey? Amboh tə məzele i Mbəlom, kâ geŋ wuray bay.» ");
INSERT INTO meq_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","A tsik andza niye na, hərwi Yesu a gwaɗaway: «Nəkar fakalaw, dara abəra mə bo i ndo nakay!» ");
INSERT INTO meq_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu a tsətsah faya, a gwaɗay: «Məzele yak way?» Fakalaw a mbəɗay faya a Yesu, a gwaɗay: «Məzele ga Haladzay, hərwi nəmay haladzay.» ");
INSERT INTO meq_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tsa na, a gay amboh a Yesu haladzay hərwi ada Yesu mâ həhar na dəreŋ abəra ka dala niye bay tey. ");
INSERT INTO meq_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Azlakwa bay, mə mahəmba wuray ka təv eye niye na, madəras hay andaya faya ta tsəkuriye tay ha. ");
INSERT INTO meq_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Fakalaw niye hay mə bo i ndo niye tə gay amboh a Yesu, tə gwaɗay: «Amboh, gər may ha nəmaâ ye a bo i madəras taɗaheye.» ");
INSERT INTO meq_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu a vəlatay tsəveɗ. Tsa na, məsəfəre lele bay eye ti yaw abəra mə bo i ndo niye ti ye tə fələkwa a bo i madəras niye hay. Madəras niye hay haladzay ta giye gwezem sulo ta hwayaw abəra ma tsaholok niye ti ye tə kuts a dəlov, tə dze a ɗəma. ");
INSERT INTO meq_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ndo mətsəkure madəras neheye tə ŋgatay andza niye na, ta hway, ti ye a wuzlahgəma mata ɗatay ha labara niye a ndo hay ada a ndo neheye nəteye dəreŋ ta wuzlahgəma aye. Tsa na, ndo hay ti yaw mata zəbe naha ka wu nakə a ge bo aye. ");
INSERT INTO meq_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ndo niye hay tə ndislew ka təv i Yesu na, tə ŋgatay a ndo nakə fakalaw hay tə ndzawa mə bo ŋgay haladzay aye. Tə ŋgatay na, mandza eye, petekeɗ ka bo ada neŋgeye lele bəna andza nakə a ndzawa aye bay. Tə ŋgatay andza niye na, ta dzədzar. ");
INSERT INTO meq_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ndo neheye labara i gər mavuwe ta madəras hay a ge bo ka ɗəre tay aye na, nəteye dərmak ta təkəratay labara eye a ndo neheye ti ye naha, nəteye ta ŋgatay təbey aye. ");
INSERT INTO meq_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tə tsəne na, tə gay amboh a Yesu, tə gwaɗay: «Amboh, do abəra ma gəma may.» ");
INSERT INTO meq_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ahəl nakə Yesu faya ma tsaliye a kwalalaŋ i yam aye na, ndo niye a mbəl hərwi fakalaw hay ti yaw abəra mə bo ŋgay na, a gwaɗay a Yesu: «Amboh nâ paka bəzay tey?» ");
INSERT INTO meq_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ane tuk na, Yesu kə vəlay tsəveɗ ka məpay bəzay bay. Yesu a gwaɗay: «Do! Ta bəzay ha bo a ndo yak hay. Təkəratay ŋgwalak nakə Bəy Maduweŋ a ge hərwi yak aye.» ");
INSERT INTO meq_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","A tsəne andza niye na, a lətse a ye a dala nakə tə zalay Dekapol aye. A ndisl a ɗəma na, a dazlay matəkəratay wu nakə Bəy Maduweŋ a ge hərwi ŋgay aye. Ndo neheye tebiye tə tsəne labara niye na, a gatay masuwayaŋ. ");
INSERT INTO meq_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ma dəba eye na, Yesu ta gawla ŋgay hay tə maw tə kwalalaŋ i yam ka dəlov niye. Tə maw a diye neŋgeɗ. Tə ndisl a ɗəma na, ndo hay haladzay ti ye ka təv ŋgay. Ndo hay ti ye ka təv ŋgay na, neŋgeye ka me i dəlov niye mba. ");
INSERT INTO meq_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bəy i gay i maɗuwule me wuray tə zalay Dzayrus, a ye naha dərmak. A ŋgatay a Yesu na, a dəkway gurmets a huvo. ");
INSERT INTO meq_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","A gay amboh a Yesu, a gwaɗay: «Dem ga wuray hala bay faya ma mətiye. Amboh, dara ta peŋ faya həlay ada mâ mbəl tey.» ");
INSERT INTO meq_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu a tsəne andza niye na, a həl bo, ti ye salamay. Ahəl nakə faya ma diye na, ndo hay haladzay gədəbille tə pay bəzay ada faya ta ŋgəɗətsiye na kwa tə waray, tə waray. ");
INSERT INTO meq_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ŋgwas wuray andaya dərmak. Ŋgwas eye niye na, ɗəvats eye. Bambaz a mbəɗawayaw abəra mə huɗ. Ɗəvats eye niye kə ndza faya məve kuro gər eye sulo. ");
INSERT INTO meq_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ki ye ha a gay i ndo i sidem hay wal wal haladzay. A sa ɗəretsətseh kəriye bəna, kə huta zay bay. Kə dze ha suloy ŋgay haladzay ka sidem ada kə gay ŋgama kwa tsekweŋ bay. Ɗuh ɗəvats niye a zaka faya. ");
INSERT INTO meq_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Ŋgwas niye a tsəne wu nakə ndo hay faya ta tsikiye ka gər i Yesu aye na, a ye a walaŋ i ndo niye hay Yesu mə ɗəma aye. A dzala mə gər ŋgay, a gwaɗ: «Na lamay a petekeɗ ŋgay na, na mbəliye segey.» Tsa na, a ye tsəriɗ tsəriɗ mə walaŋ i ndo niye hay. A ndisl bəse ka təv i Yesu ta dəba na, a lamay a petekeɗ i Yesu. ");
INSERT INTO meq_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","A ye a lamay nets na, kwayaŋŋa bambaz niye a mbəɗawayaw faya abəra a tərəts tsandzaŋ. A sər ha mə bo ŋgay na, kə mbəl abəra ma ɗəvats ŋgay niye. ");
INSERT INTO meq_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kwayaŋŋa Yesu a sər ha gədaŋ ki yaw abəra mə bo ŋgay. Tsa na, a mbəɗa me a diye i ndo neheye faya ta pay naha bəzay ma dəba aye. A tsətsah, a gwaɗ: «Maa lamay a petekeɗ ga na, way?» ");
INSERT INTO meq_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Gawla ŋgay hay ta mbəɗay faya, tə gwaɗay: «Ka gwaɗiye “Maa lemeŋ way” na, ka ŋgatay a ndo neheye haladzay faya ta ŋgəɗətsiye kar təbəɗew?» ");
INSERT INTO meq_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ane tuk na, Yesu a zəba ɗəre ka təv niye pərwasla hərwi ada mâ ŋgatay a ndo nakə a lamay a petekeɗ ŋgay aye. ");
INSERT INTO meq_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ŋgwas niye a lamay a petekeɗ i Yesu aye na, a dzədzar slaɓ slaɓ, hərwi a sər ha wu nakə a ge bo tə neŋgeye. A ye a dəkway gurmets a huvo a Yesu. Tsa na, a ɗay ha wu nakə deɗek aye a Yesu. ");
INSERT INTO meq_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu a gwaɗay: «Dem ga, mədzal gər yak kə mbəl kar ha. Do wu yak barbarra. Ka mbəl abəra ma ɗəvats yak nakay na, ka tor eye.» ");
INSERT INTO meq_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ahəl nakə Yesu faya ma tsikeye a ŋgwas niye andza niye na, ndo hay ti yaw mə gay i Dzayrus. Ti yaw na, ka təv i Dzayrus. Tə gwaɗay: «Dem yak kə mət, ka wurɗeye me a miter na, sa meriye?» ");
INSERT INTO meq_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ane tuk na, Yesu na, kə pa gər ka bazlam tay niye bay. Yesu a gwaɗay a Dzayrus: «Kâ dzədzar bay, dzala ha ka neŋ tsa na, tsɨy.» ");
INSERT INTO meq_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tsa na, a lətse, a ye. Ahəl nakə faya ma diye na, a gatay me a ndo hay ada tâ zəŋgal na bay. A vəlay tsəveɗ mede ka bo dziye na, a Piyer, a Yakuba ta malamar ŋgay Yuhana. ");
INSERT INTO meq_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tə ndisl naha a gay i Dzayrus bəy i gay i maɗuwule me na, Yesu a zəba ɗəre na, ndo hay faya ta tuwiye taŋgof taŋgof, siye hay faya ta tuwiye tə mawude eye ndəŋndəŋ. ");
INSERT INTO meq_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu a ŋgatay andza niye na, a fələkwa a gay, a ye naha a gwaɗatay a ndo neheye mə gay aye: «Mədzəɗay ta mətuway nakay na, kemey? Wawa nakay na, kə mət bay, neŋgeye mandzahəra eye.» ");
INSERT INTO meq_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ndo hay wuyi tə ŋgwasa faya. Tsa na, a həharataya ahaya abəra. Maa ləkaw ka təv ŋgay mə gay na, bəba ta may i wawa ta gawla ŋgay neheye mahkar ti ye ka bo dziye. Nəteye, ti ye tə fələkwa a gay nakə wawa mahəna eye mə ɗəma aye. ");
INSERT INTO meq_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tə ndisl naha na, Yesu a gəs dem niye abəra mə həlay ada a gwaɗay: «Talita kum!» (Andza məgweɗe: «Dem, faya na gwaɗakeye, lətse!») ");
INSERT INTO meq_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tsa na, dem niye kwayaŋŋa hurum a lətse. A ye tə sik ŋgay kuteŋ kuteŋ. Məve i dem niye na, kuro gər eye sulo. Tsa na, ndo niye hay tə ŋgatay a wu niye a ge bo aye na, a gatay masuwayaŋ. ");
INSERT INTO meq_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tsa na, Yesu a gwaɗatay: «Wu nakay na ge aye na, kâ ɗumay ha a ndəray bay.» A gwaɗatay a bəba ta may i dem niye: «Vəlumay wu mənday ada mâ nda.» ");
INSERT INTO meq_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ma dəba eye na, Yesu ta gawla ŋgay hay, tə lətse abəra ka təv niye, ti ye a gəma nakə Yesu a gəl mə ɗəma aye. ");
INSERT INTO meq_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pat i mazəzukw bo na, a ye a gay i maɗuwule me. Mə ɗəma na, ndo hay haladzay. A ɗatay ha bazlam i Mbəlom. Tə tsəne bazlam i Mbəlom nakə a tsikatay aye na, a gatay hərɓaɓəkka. Tə gwaɗ: «A hutaw labara nakay na, məŋgay? Maa vəlay ndaraw nakay na, way? Masuwayaŋ nakay faya ma giye na, a yaw məŋgay? ");
INSERT INTO meq_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Neŋgeye na, ndo matsətseɗe mayako bəɗa? Ada neŋgeye na, wawa i Mari bəɗa? Malamar ŋgay hay na, Yakuba, Zozes, Yuda ada Simoŋ bəɗa? Malamar ŋgay dem aye hay dərmak nəteye ka təv kway kanaŋ, nəkway dziye bəɗaw?» Hərwi wu neheye tebiye ndo i Nazaret hay ta kərah məpe mədzal gər ka Yesu. ");
INSERT INTO meq_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu a gwaɗatay: «Ndo məɗe ha bazlam i Mbəlom na, ndo hay ta təma na ada tə ɗəslay ha gər kwa məŋgay. Ane tuk na, ma gəma ŋgay mə walaŋ i ndo ŋgay hay ta malamar ŋgay hay na, tə ɗəslay ha gər bay.» ");
INSERT INTO meq_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Hərwi niye, Yesu kə sla məge masuwayaŋ i wuray kwa tsekweŋ bay tebiye. Wu nakə a ge aye na, a pa həlay ka ndo wuray hay ɗəvats eye hay ada tâ mbəl abəra ma ɗəvats. ");
INSERT INTO meq_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ka təv eye niye, a gay wadəŋ wadəŋ a Yesu hərwi nakə ta dzala ha bay aye. Tsa na, a lətse a ye a gəma mekeleŋ eye hay bəse ta gəma ŋgay niye. A ye na, mata ɗatay ha bazlam i Mbəlom a ndo hay. ");
INSERT INTO meq_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Pat wuray na, Yesu a zalatay a gawla ŋgay hay kuro gər eye sulo, a gwaɗatay: «Na sləriye kurom ha a gəma hay wal wal. Ka deyumeye na, sulo sulo.» Tsa na, a vəlatay gədaŋ ka mahəhere məsəfəre neheye ŋgwalak eye bay aye abəra ka ndo hay. ");
INSERT INTO meq_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","A gwaɗatay: «Ka deyumeye na, kâ zlum wuray a həlay bay. Sakwal na, ka zlumeye kəla. Ane tuk na, kâ zlum wu mənday bay. Kwa ɓəɓoro, kwa suloy kâ pum a gwezem bay. ");
INSERT INTO meq_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tahərak na, pum a sik, ane tuk na, kâ həlum petekeɗ i məkelkabo kurom hay sulo, sulo bay.» ");
INSERT INTO meq_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yesu a gwaɗatay sa: «Ka ndislum a gəma nakə ka deyumeye a ɗəma aye na, ndzum mə gay nakə ta təma kurom tə məŋgwese aye. Kâ yum kurom abəra mə gay niye bəse tsa bay. Ndzum mə ɗəma hus a pat nakə ka deyumeye a gəma mekeleŋ eye. ");
INSERT INTO meq_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Taɗə ndo i gəma niye ka deyumeye a ɗəma, ta təma kurom bay ada agəna ta kərah məpe zləm ka bazlam kurom na, dum kurom abəra ma gəma niye. Ahəl nakə ka yumaw kurom, nəkurom ka tsəveɗ mazlambar ka gərumeye ha tsəveɗ i gəma niye na, tətəkum ha bətekwew i gəma niye abəra ka sik kurom hay. Niye na, ta səriye ha ta təma kurom bay.» ");
INSERT INTO meq_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yesu a ndəvatay ha me ŋgay niye a tsikatay aye na, tə həl bo ti ye. Tə ndisl a gəma niye hay na, ta dazlay a məɗe ha bazlam i Mbəlom a ndo hay. Tə gwaɗatay a ndo i gəma niye hay: «Mbəɗum ha mede kurom» ");
INSERT INTO meq_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ada ta həhar fakalaw abəra ka ndo hay. Tə faɗa mal ka ndo neheye ɗəvats eye hay aye. Tə mbəl tay ha abəra ma ɗəvats niye. Ndo neheye tə mbəl tay ha aye na, nəteye haladzay. ");
INSERT INTO meq_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesu a ɗa a zləm haladzay a gəma hay wal wal tebiye. Kwa bəy nakə tə zalay Herod aye kə tsəne labara i Yesu dərmak. Ndo mekeleŋ eye hay tə gwaɗ ka Yesu: «Neŋgeye na, Yuhana madzəhuɓe ndo a yam kə lətsew abəra ma mədahaŋ. Hərwi niye nakə a huta gədaŋ ka məge masuwayaŋ.» ");
INSERT INTO meq_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Siye hay na, tə gwaɗ: «Neŋgeye na, Eliya ndo məɗe ha bazlam i Mbəlom niye ahəl niye.» Siye hay tə gwaɗ: «Neŋgeye na, ndo i maslaŋ i Mbəlom nəte mə walaŋ i ndo məɗe ha bazlam i Mbəlom neheye ahəl niye aye.» ");
INSERT INTO meq_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herod a tsəne andza niye na, a gwaɗ: «Ndo niye na, Yuhana nakə ahəl niye na ɗəs faya abəra gər eye na, kə lətsew abəra ma tsəvay.» ");
INSERT INTO meq_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod a tsik andza niye na, hərwi maa vəl tsəveɗ ka məgəse Yuhana na, bo ŋgay eye. Tə gəs na ada tə pa na a daŋgay. Tə pay səselek a sik. Herod a ge andza niye na, hərwi Yuhana a gay me ka mabuwe Herodiyad ŋgwas i malamar ŋgay nakə tə zalay Filip aye. ");
INSERT INTO meq_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","A gəs Yuhana a pa na a daŋgay na, hərwi Yuhana a gwaɗay: «Bazlam i Mbəlom a ge me ka mabuwe ŋgwas i malamar yak.» ");
INSERT INTO meq_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yuhana a tsik andza niye na, a ndalay a Herodiyad. A say haɓe məkəɗe Yuhana. Herodiyad a sla məkəɗe na Yuhana bay na, hərwi Herod. ");
INSERT INTO meq_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hərwi mey na? Herod na, a dzədzaraway a Yuhana. A dzədzaraway na, a sər ha Yuhana na, neŋgeye ndo lele eye, kə ge mənese bay. Herod a ge faya me hərwi ada tâ kəɗ na bay. A tsəne andza niye na, a dzədzar haladzay. Haɓe ɗuh a pawa zləm ka bazlam i Yuhana na, lele. Aya ane a sla faya matəme bay. ");
INSERT INTO meq_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pat eye andaya na, Herodiyad a huta tsəveɗ ka məkəɗe Yuhana tuk. Pat eye niye na, Herod a ge magurlom i pat i məwe ŋgay. A zalatay a ndo ŋgay neheye bagwar eye ma məsler ka dala ŋgay aye. A zalay a bagwar i sidzew hay ada ta ndo neheye ka dala i Galile məzele tay a ɗa a zləm aye. Ti ye naha tebiye a magurlom niye. ");
INSERT INTO meq_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Anəke na, dem i Herodiyad niye a ye, a fələkwa ka təv i ndo neheye mahaya gər eye. A ye naha na, a dazlay a məhetse. Məhetse i dem niye a hats eye na, a le ka bəy ta ndo neheye a zalatay a magurlom aye. Bəy a zalay a dem niye a gwaɗay: «Nəkar na, tsətsah fagaya wu nakə a saka aye, na vəlakeye.» ");
INSERT INTO meq_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A mbaɗay tsaɗ tsaɗ, a gwaɗay: «Kwa mey mey! Ka tsətsah na, na vəlakeye. Kwa dala, na ɗəsakeye faya abəra, na vəlakeye ha a nəkar ka ləviye.» ");
INSERT INTO meq_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tsa na, dem niye a yaw abəra, a ye ka təv i may ŋgay. A gwaɗay a may ŋgay: «May ga, bəy a gweɗeŋ “Tsətsah wu nakə a saka aye, na vəlakeye” na, na tsətsah faya na, mey?» May ŋgay a gwaɗay: «Tsətsah na, mâ ɗəsaka gər i Yuhana madzəhuɓe ndo a yam.» ");
INSERT INTO meq_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Dem niye a ma ta bəse ka təv i bəy. A ye naha a tsətsah wu nakə a say aye tuk. A gwaɗay a bəy: «A seŋ na, vəleŋ gər i Yuhana madzəhuɓe ndo a yam ka bəgəlam anəke kiyye.» ");
INSERT INTO meq_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Bəy a tsəne andza niye na, a ndalay haladzay, hərwi a say məkəɗe na Yuhana bay. Kwa a ndalay bəbay na, a sla makərahay ha bay hərwi ɓa ka mbərəm məmbeɗe kame i ndo neheye mazala eye a magurlom aye. ");
INSERT INTO meq_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","A zalay a sidzew ŋgay nəte, a gwaɗay: «Do bəse! Tâ ɗəsaw gər i Yuhana madzəhuɓe ndo a yam ada kâ pa ahaya ka bəgəlam.» Sidzew niye a ye. A ye naha na, a fələkwa a gay i daŋgay, a ɗəs gər i Yuhana. ");
INSERT INTO meq_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tsa na, a pa ahaya ka bəgəlam. A zla ahaya a vəlay a dem niye. Dem niye a təma, a ye ha a vəlay a may ŋgay dərmak. ");
INSERT INTO meq_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Gawla i Yuhana hay tə tsəne, ta ɗəs gər abəra ka Yuhana na, ti yaw tə zla ahaya mədahaŋ i Yuhana abəra ma daŋgay, tə pa na a bəɗ. ");
INSERT INTO meq_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu kə slər ndo i maslaŋ ŋgay hay mata ɗa ha bazlam i Mbəlom. Anəke na, tə maw tuk. Tə maw ka təv i Yesu, ta təkəray wu nakə tə gaw aye ada tə matətike nakə ta tətikatayaw a ndo hay aye. ");
INSERT INTO meq_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Azlakwa bay ka təv nakə nəteye mə ɗəma aye na, ndo hay haladzay faya ta diye naha ka təv tay ada siye hay haladzay faya ta mbəɗiye gər wu tay. Yesu ta gawla ŋgay hay ta huta həlay i mənde wu mənday kwa tsekweŋ bay tebiye. Yesu a zəba faya andza niye na, a gwaɗatay a gawla ŋgay hay: «Takwa kway abəra kanaŋ, takwa a təv nakə ndo hay andaya bay aye ta zəzukwakwa bo mə ɗəma.» ");
INSERT INTO meq_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tsa na, tə lətse, tə tsal a kwalalaŋ i yam, ti ye a təv nakə ndəray andaya mə ɗəma bay aye. ");
INSERT INTO meq_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ahəl nakə faya ta diye na, ndo hay haladzay ta ŋgatatay faya ta diye. Tə sər ha faya ta diye wu tay. Tsa na, ndo hay ti yaw abəra ma gəma hay wal wal ta hway tə sik, ka məndisle a təv nakə Yesu ta gawla ŋgay hay ta diye a ɗəma aye. ");
INSERT INTO meq_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu ta gawla ŋgay hay tə ndisl naha na, Yesu a mbəzlaw abəra ma kwalalaŋ i yam. A zəba ɗəre na, ndo hay mbərzəzza mahaya gər eye. A zəba fataya na, tə gay mə bo haladzay. Hərwi ndo neheye ta ndzəkit bo na, andza təɓaŋ neheye ndo mətsəkure tay andaya bay aye. Tsa na, a dazlay mətsikatay labara hay wal wal haladzay. ");
INSERT INTO meq_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mazlambar huwa faya ma giye na, gawla a Yesu ta həndzəɗ ka təv i Yesu tə gwaɗay: «Anəke huwa kə ge ada təv nakay kəsaf na, kəkay? Ndo neheye tebiye ta ndeyeweye wu mənday na, məŋgay? ");
INSERT INTO meq_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ŋgama gwaɗatay tâ ye mata səkəmaw wu mənday ma wuzlahgəma ada mə gay i ndo neheye tə mbay naha a wuzlahgəma aye.» ");
INSERT INTO meq_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu a mbəɗatay faya, a gwaɗatay: «Nəkurom eye vəlumatay wu mənday!» Gawla ŋgay hay ta tsətsah faya, tə gwaɗay: «Nəmaa hutaweye dala masəkəmaw wu mənday a ndo neheye ɗa ta rahiye na, məŋgay?» ");
INSERT INTO meq_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu a gwaɗatay: «Tapa i makwala nakə andaya fakuma aye na, nday? Ehey! Dum, zəbum ahaya təday!» Tə tsəne andza niye na, ti ye ta zəba ka makwala niye, nəteye tapa nday. Ta zəbaw faya na, ti yaw tə gwaɗay a Yesu: «Makwala andaya na, tapa zlam tə kəlef sulo.» ");
INSERT INTO meq_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ma dəba eye, Yesu a gwaɗatay: «Dum naha gwaɗumatay a ndo hay tâ ndza ka bəruk ka bəruk, ka guzer.» Guzer niye na, beremeffe a ndzohwaw mba. ");
INSERT INTO meq_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Gawla i Yesu hay tə tsikatay a ndo niye hay andza niye. Tə ndza ka guzer niye. Ta nar bo na, siye nəteye temerre temerre. Siye hay kuro kuro zlam kuro kuro zlam. ");
INSERT INTO meq_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tə ndza na, Yesu a həl tapa i makwala niye zlam tə kəlef niye sulo aye. Tsa na, a zəba ɗəre a mbəlom, a gay naha sɨsœ a Mbəlom. A ndəv ha məgay naha sɨsœ a Mbəlom na, a ŋgəna ha makwala niye. A vəlatay a gawla ŋgay hay, a gwaɗatay: «Vəlumatay a ndo hay.» Tsa na, ti ye ta ŋgənatay a ndo neheye mandza eye tebiye. Yesu a həl kəlef neheye sulo aye, a ŋgənatay ha faya a ndo niye hay mandza eye tebiye sa. ");
INSERT INTO meq_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kwa way a nda makwala niye tə kəlef eye ka mərehe. ");
INSERT INTO meq_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ma dəba eye na, gawla i Yesu hay, ti ye naha, tə hayay gər a siye i makwala tə kəlef eye nakə a ləkaw aye. Tə hayay gər na, a rah a gwaŋ kuro gər eye sulo. ");
INSERT INTO meq_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ndo neheye tebiye tə nda makwala niye aye na, hasləka hay na, gwezem zlam. ");
INSERT INTO meq_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ma dəba eye kwayaŋŋa na, Yesu a gwaɗatay a gawla hay ŋgay: «Tsalum a kwalalaŋ i yam, dum ka gər i dəlov nakay a diye neŋgeɗ. Ka deyumeye na, a diye i gəma i Betesayda. Dum kame! Na ndziye kurom naha a ɗəma.» Tsa na, tə lətse ti ye. Yesu na, a tsikatay me a ndo neheye a ndatay ha wu mənday aye. A gwaɗatay: «Dum kurom a mətagay kurom hay tuk.» ");
INSERT INTO meq_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ma dəba eye na, ndo neheye ti ye wu tay na, Yesu a tsal a tsaholok. A ye na, mata ɗuwule me. ");
INSERT INTO meq_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Həvaɗ a ge na, ahəl nakə gawla i Yesu hay faya ta diye, tə ndisl a wuzlah i dəlov. Yesu na, neŋgeye mahəŋgeye ka dala mba, kə həl bo mede zuk bay. ");
INSERT INTO meq_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Gawla ŋgay hay faya ta giye ɗəretsətseh hərwi mətasl a ge ta gədaŋ ta diye tay, a say məme ha kwalalaŋ i yam ta dəba. Yesu a ŋgatatay na, nəteye faya ta siye ɗəretsətseh. Mbəlomɗa i dzagulok məzlehe na, Yesu a həl bo a ye ka təv tay tsəpak tsəpak ka gər i yam tə sik. A həndzəɗ bəse ta nəteye na, a say məlahatay kame. ");
INSERT INTO meq_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tə ŋgatay a Yesu faya ma diye ka gər i yam tə sik na, tə gwaɗ ma giye na, wu matəre ka ndo. Ta wuda. ");
INSERT INTO meq_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nəteye niye tebiye tə ŋgatay na, ta dzədzar haladzay. Ane tuk na, neŋgeye a tsikatay naha me, a gwaɗatay: «Tete kurom! Kâ dzədzarum bay. Nakay na, neŋ!» ");
INSERT INTO meq_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tsa na, a həndzəɗ ka təv i kwalalaŋ i yam. A tsal ka təv tay a kwalalaŋ i yam na, mətasl a ndza ɗeɗik. Tsa na, a gatay hərɓaɓəkka a gawla ŋgay hay. ");
INSERT INTO meq_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","A gatay hərɓaɓəkka na, hərwi ta sər ha gədaŋ i Yesu zuk bay. Kwa masuwayaŋ nakə Yesu a ge ta wu mənday aye bəbay na, huya ta pa na a mədzele gər tay bay, hərwi ta kula ha gər tay. ");
INSERT INTO meq_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ma dəba eye nakə Yesu ta gawla ŋgay hay tə tas abəra ma dəlov niye aye na, tə ndisl a gəma eye andaya tə zalay Genesaret. Tə ndisl a ɗəma na, tə ɓar na, kwalalaŋ i yam tay ka pəpəz i dəlov niye. ");
INSERT INTO meq_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tə mbəzlaw abəra ma kwalalaŋ i yam na, ndo neheye ma gəma niye aye tə sər na Yesu. ");
INSERT INTO meq_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ta hway məzalatayaw a ndo hay kwa məŋgay kwa məŋgay, ta həlatay ahaya ndo i ɗəvats hay a Yesu. Kwa ma gəma waray waray Yesu a yawa na, tə həlaway naha ndo i ɗəvats hay ta sləlah. ");
INSERT INTO meq_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kwa Yesu a ye na, a ŋgay, kwa a gəma wawa eye, kwa a gəma bagwar eye, kwa ndo neheye mandza eye ma dəba i gəma aye bəbay na, ndo hay tə haya gər ka təv məhay gər. Tə həlawayaw ndo i ɗəvats hay. Tə gaway amboh a Yesu hərwi ada mâ vəlatay tsəveɗ a ndo i ɗəvats hay tâ lamay na, a me i petekeɗ ŋgay tsa. Ndo neheye ta lamay aye na, nəteye tebiye ta mbəl. ");
INSERT INTO meq_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pat wuray na, Farisa hay ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye, tə yaw ma Zerozelem. Tə yaw tə haya gər ka təv i Yesu. ");
INSERT INTO meq_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tə ŋgatay a siye i gawla i Yesu hay na, tə nda wu mənday andza niye ze məbere həlay. Andza məgweɗe na, ta bara həlay andza nakə kule i bəba təte tay hay a tsikatay aye bay. ");
INSERT INTO meq_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Hərwi mey na, Farisa hay nəteye ta Yahuda hay tebiye na, tə ɗəslaway ha gər a kule i bəba təte tay hay. Ta bara həlay lele andza nakə mə kule tay bay na, ta ndiye ɗaf bay. ");
INSERT INTO meq_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Taɗə ta maw mə luma na, ta bariye həlay təday ada ta ndiye ɗaf. Sa na, tə ɗəslaway ha gər a siye i kule tay hay wal wal, andza matsekeɗe gəse, gəzla ta səŋgəle i ɓəre. ");
INSERT INTO meq_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Anəke na, Farisa hay ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye ta tsətsah ka Yesu, tə gwaɗay: «Gawla yak hay tə ɗəslay ha gər a kule i bəba təte kway təbey na, kemey? Tə nda ɗaf ze məbere həlay andza i kule i bəba təte kway hay na, kemey?» ");
INSERT INTO meq_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu a tsəne andza niye na, a mbəɗatay faya, a gwaɗatay: «Nəkurom na, ndo i bəbərek hay andza nakə Ezay ndo maslaŋ i Mbəlom a watsa ahəl niye! A watsa na, Mbəlom a gwaɗ: “Ndo neheye ta zembeɗeŋ na, tə bazlam ɗekɗek tsa, ɗərev tay na, dəreŋ tə neŋ. ");
INSERT INTO meq_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nəteye faya ta zembeɗeŋeye kəriye, ane tuk na, kəriye bəna deɗek bay. Wu nakə faya ta tətikateye a ndo hay aye na, bazlam mapala eye i ndo hay tsa.”» ");
INSERT INTO meq_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesu a gwaɗatay sa: «Ka gərum ha bazlam i Mbəlom mapala eye hərwi məɗəslay ha gər a kule i ndo hay ɗuh na, kəkay!» ");
INSERT INTO meq_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","A gwaɗatay sa: «Asah! Ka gərum ha bazlam i Mbəlom mapala eye na, dəreŋ tə nəkurom, hərwi məgay gər a kule i bəba təte kurom hay lele ɗuh! ");
INSERT INTO meq_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa a gwaɗ: “Rəhay ha gər a bəba yak ta may yak bəɗaw!” A gwaɗ sa: “Ndoweye kə tsaɗay a bəba ŋgay ta may ŋgay na, kutoŋ tâ kəɗ na bəɗaw!” ");
INSERT INTO meq_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nəkurom na, ka təmum bazlam nakay bay. Nəkurom faya ka tətikumatay a ndo hay na, kule i kurban tə məgweɗe a bəba kurom ta may kurom na: “Wu nakə na sliye faya məvəlaka haɓe hərwi madzəne kar aye na, kurban” (andza məgweɗe zlele nakə mavəla eye hərwi Mbəlom aye). ");
INSERT INTO meq_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ma dəba eye na, a sakum ndo mâ dzəna bəba ŋgay ta may ŋgay sa bay. ");
INSERT INTO meq_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Andza niye, faya ka nasumeye ha bazlam i Mbəlom tə kule nakə faya ka tətikumatay a ndo hay aye. Ada faya ka gumeye wu hay haladzay andza nakay sa.» ");
INSERT INTO meq_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ma dəba eye na, Yesu a zalatay a ndo hay. Ti ye naha ka təv ŋgay. Ti ye naha na, a gwaɗatay: «Nəkurom tebiye pum zləm ada tsənum wu nakay. ");
INSERT INTO meq_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Wu nakə ndo ma ndiye a huɗ aye na, ma nasiye ha ndo ka təv i Mbəlom bay. Mata nas ha ndo na, wu nakə a yaw abəra mə ɗərev i ndo aye. ");
INSERT INTO meq_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ndo nakə zləm andaya faya na, mâ tsəne!» ");
INSERT INTO meq_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu a ndəv ha andza niye na, a ye ŋgway a gay. Gawla ŋgay hay ta zəŋgal na a gay. Ti ye naha ta tsətsah tə gwaɗay: «Dzeke nakə meeneŋ ka tsik aye na, mbəɗaw bo na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu a gwaɗatay: «Nəkurom dərmak na, ka sərum bəɗaw? Wu mənday nakə ndo ma ndiye a huɗ eye na, ma nasiye ha ɗərev i ndo zezeŋ bay. ");
INSERT INTO meq_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Hərwi wu mənday nakə ndo zezeŋ a nda aye na, a ye a ɗərev bay. A ye na, a kutes tsa ada ma deyeweye abəra mə bo.» Bazlam i Yesu nakay a ɗa ha na, kwa wu mənday waray waray na, ndo ma ndiye. ");
INSERT INTO meq_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesu a gwaɗatay sa na: «Wu nakə ma nasiye ha ndo ka təv i Mbəlom aye na, wu nakə a yaw abəra mə ɗərev aye. ");
INSERT INTO meq_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Hərwi mədzal gər lelebay eye a yaw na, abəra mə ɗərev. Ta diye a mede nakə ŋgwalak eye bay aye, məge məkal, məkəɗe gər i ndo, ");
INSERT INTO meq_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","məge madama, məwe bor ka wu i ndo, məge seweɗ, məvatay gər a ndo hay, məge zlərwek, məge sələk, maŋgəlay bəzay a ndo hay, məɗəslay ha gər a bo, matəre ha bo andza gər mavuwe. ");
INSERT INTO meq_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wu neheye tebiye lelebay aye na, a yaw abəra mə bo i ndo zezeŋ. Wu neheye lelebay aye na, ma nasiye ha ndo ka təv i Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ma dəba eye na, a lətse a ye abəra ka təv niye. A ye ka dala i Tir ada a Sidoŋ. A ye a gay eye andaya mə ɗəma. A ye a ɗəma na, a say haɓe ndəray mâ sər ha neŋgeye ka niye bay. Ane tuk na, neŋgeye na, a sla məŋgehe bo bay. ");
INSERT INTO meq_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ŋgwas wuray andaya ka dala i Tir eye niye. Neŋgeye na, slala i Yahuda hay təbey. Tə wa na ma gəma nakə tə zalay Fenisi aye. Fenisi na, neŋgeye ka dala i Siri. Ŋgwas eye niye na, dem ŋgay andaya mahorvov a gay. A tsəne labara i Yesu nakə ndo hay faya ta tsikiye na, a ye ka təv i Yesu ta bəse. A ye naha a dəkway gurmets a Yesu, a gwaɗay: «Amboh! Fakalaw faya ma giye ha ɗəretsətseh tə dem ga, həhar faya abəra tey.» ");
INSERT INTO meq_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ane tuk na, Yesu a gwaɗay a ŋgwas niye na, «Gər ga ha! Neŋ na, na dzəniye slala ga təday andza nakə ta vəlateye wu mənday a wawa hay aye təday ada tâ rah. Məzle wu mənday i wawa hay məkalatay a wawa i kəra hay na, lele bay.» ");
INSERT INTO meq_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ŋgwas a mbəɗay faya, a gwaɗay: «Andza niye, bəy ga. Kwa neŋ Yahuda hay bay bəbay na, ka sliye faya madzəne ga segey. Hərwi kwa wawa hay faya ta ndiye wu mənday na, nakə a dəɗaw fataya abəra mə bazlam aye na, wawa i kəra hay ta paliye, ta ndiye bəɗaw?» ");
INSERT INTO meq_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu a tsəne andza niye na, a gwaɗay a ŋgwas: «Bazlam yak nakə ka mbəɗeŋew faya ye na, lele. Do a mətagay, fakalaw ki yaw abəra mə bo i dem yak.» ");
INSERT INTO meq_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tsa na, ŋgwas niye a maw a mətagay na, dem ŋgay mahəna eye ka təv məhəne. Fakalaw ki ye faya abəra. ");
INSERT INTO meq_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ma dəba eye na, Yesu a lətse abəra ma gəma i Tir. A həl bo, a ye ta gəma eye andaya tə zalay Sidoŋ ada ta dala nakə tə zalay Dekapol aye. A yaw tə ɗəma na, hərwi məmaw ka tsakay i dəlov i Galile. ");
INSERT INTO meq_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","A ndislew a ɗəma na, tə zlay naha ndo wuray mandək aye. Tə gay amboh a Yesu, tə gwaɗay: «Amboh! Pa həlay ka ndo may nakay ada mâ mbəl abəra ma ɗəvats ŋgay nakay tey.» ");
INSERT INTO meq_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tsa na, Yesu a gay wiyaw a mandək niye mahəŋgeye, ti ye dəreŋ abəra ka təv i ndo hay. Ti ye naha na, a pay wur həlay a zləm i mandək niye. A pay wur həlay na, a zləm sulo sulo. A tuf slesleɓ ka wur həlay a lamay ha a ɗərneh i ndo niye. ");
INSERT INTO meq_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tsa na, a zəba ɗəre a mbəlom. A ma ha məsəfəre ŋgək a bəzihuɗ. Tsa na, a gwaɗay a ndo niye: «Effata!» Andza məgweɗe: «Zləm yak mâ həndək!» ");
INSERT INTO meq_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kwayaŋŋa zləm i ndo niye a həndək. A tsəne zləm lele tuk. Wu nakə a ɓaray na ɗərneh a tsik ha me lelebay eye na, a pəla tuk. A tsik me wulaŋaŋa lele tuk. ");
INSERT INTO meq_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ma dəba eye na, Yesu a gatay me a ndo niye hay tebiye, a gwaɗatay: «Kâ ɗum ha wu nakə na ge aye a ndəray bay.» Yesu a gatay me məɗe ha na, nəteye tə zaka ha məɗe ha wu i Yesu niye a giye ɗuh. ");
INSERT INTO meq_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wu nakə Yesu a ge aye na, a gatay masuwayaŋ a ndo hay. Tə gwaɗ: «Wu nakə Yesu a ge tebiye aye na, lele haladzay. Neŋgeye na, kwa ndo mandək eye hay, ka həndəkatay na zləm, tə tsəne zləm lele. Kwa ndo neheye tə tsik me bay aye na, ka lambaɗatay ha ɗərneh tay, tə tsik me lele.» ");
INSERT INTO meq_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pat wuray na, ndo hay haladzay tə haya gər ka təv i Yesu sa. Yesu a zəba fataya na, may a wur fataya. Ada wu mənday andaya fataya bay. Yesu a zalatay a gawla ŋgay hay, a gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Ndo neheye na, tə geŋ mə bo haladzay, hərwi anaŋ məhəne mahkar na, nəteye ka təv ga ada wu mənday andaya fataya bay. ");
INSERT INTO meq_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Na gwaɗatay: “Dum kurom ze mənde wu mənday” na, may ma kəɗiye tay ha ka tsəveɗ, ta ndisliye a mətagay tay hay bay. Hərwi ndo siye hay mə walaŋ tay na, nəteye dəreŋ.» ");
INSERT INTO meq_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Gawla ŋgay hay ta mbəɗay faya, tə gwaɗay: «Anəke mə kəsaf nakay na, ka hutakweye wu mənday ɗa məvəlatay a ndo neheye na, məŋgay?» ");
INSERT INTO meq_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu a tsətsah ka gawla ŋgay hay, a gwaɗatay: «Makwala andaya fakuma na, tapa nday?» Tsa na, ta mbəɗay faya, tə gwaɗay: «Makwala andaya famaya na, tapa tasəla.» ");
INSERT INTO meq_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tsa na, Yesu a gwaɗatay a ndo niye hay tâ ndza ka dala. A ye, a həlaw makwala neheye tapa tasəla aye. A gay naha sɨsœ a Mbəlom. A gay naha sɨsœ a Mbəlom na, a ŋgəna ha ɗaf niye, a vəlatay a gawla ŋgay ada tâ vəlatay a ndo hay tebiye. Gawla ŋgay hay tə vəlatay makwala niye a ndo hay. ");
INSERT INTO meq_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kəlef andaya ka gawla ŋgay hay tsakway sa. Yesu a həl kəlef niye, a gay naha sɨsœ a Mbəlom. A vəlatay a gawla ŋgay hay. A gwaɗatay: «Ŋgənumatay a ndo hay dərmak.» ");
INSERT INTO meq_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Makwala tə kəlef niye na, kwa way a nda ɓəh ɓəh ka mərehe. Gawla i Yesu hay tə hayay gər a bəmalə nakə a ləkaw aye na, kəteh tasəla. ");
INSERT INTO meq_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ndo neheye tə nda ɗaf aye na, ta giye gwezem faɗ. Ma dəba eye na, Yesu a gwaɗatay: «Dum kurom tuk!» ");
INSERT INTO meq_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tsa na, Yesu a tsal ŋgway a kwalalaŋ i yam ta gawla ŋgay hay. Ti ye a gəma wuray tə zalay Daləmanuta. ");
INSERT INTO meq_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tə ndisl a Daləmanuta na, Farisa hay ti ye naha ka təv tay. Ti ye naha na, ta dazlay mətsike me ta Yesu, hərwi a satay məhəle faya abəra suwat. Ta tsətsah ka Yesu, tə gwaɗay: «Gamay masuwayaŋ nakə ma ɗiye ha ka yaw abəra ka təv i Mbəlom aye.» ");
INSERT INTO meq_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu a tsəne bazlam tay nakə tə tsik aye na, a ma ha məsəfəre ŋgək a bəzihuɗ, a gwaɗatay: «Nəkurom ndo neheye tə ɗəre ka tsətsahumeye masuwayaŋ sa na, kemey? Anaŋ na tsikakumeye ta deɗek: Ɗaɗa ndəray ma gakumeye masuwayaŋ bay!» ");
INSERT INTO meq_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tsa na, Yesu a gər tay ha. A tsal ŋgway a kwalalaŋ i yam, a ye a tas abəra ma dəlov niye a diye neŋgeɗ. ");
INSERT INTO meq_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Gawla i Yesu hay ta zəba wu tay hay na, ta mətsa ha gər tə masəkəme makwala. Andaya fataya mə kwalalaŋ i yam na, tapa nəte tsa. ");
INSERT INTO meq_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ahəl nakə faya ta diye na, Yesu a gatay ɗaf, a gwaɗatay: «Gum metsehe! Tsəpum gər kurom abəra ka gəɗe i Farisa hay tə bəmalə i Herod.» ");
INSERT INTO meq_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Gawla ŋgay hay tə tsəne andza niye na, tə ma ha ka bo bazlam mə walaŋ tay. Tə gwaɗ: «A tsikakway na, hərwi nakə makwala andaya fakwaya bay aye!» ");
INSERT INTO meq_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tsa na, Yesu a səratay naha ka wu nakə faya ta miye ha a bo mə walaŋ tay aye. A gwaɗatay: «Ka ŋgurumeye bo kurom hərwi makwala nakə andaya fakuma bay aye na, kemey? Ada ka tsənum zuk bəɗaw? Ka pum a mədzal gər kurom təbəɗew? Mədzal gər kurom na, madərəzla eye kəla ɗaw? ");
INSERT INTO meq_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","«Ɗəre andaya fakuma ada kâ ŋgatumay a ɗəre bəɗaw? Zləm andaya fakuma hərwi mətsəne ada kâ tsənum bəɗaw? «Ada kə makumaw a gər təbəɗew? ");
INSERT INTO meq_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Na ge tə makwala na, kəkay? Na ŋgəna ha makwala tapa zlam na, ndo hay gwezem zlam tə nda bəɗaw? Ada nakə a ləkaw ka hayumay gər na, gwaŋ nday?» Ta mbəɗay faya, tə gwaɗay: «Gwaŋ kuro gər eye sulo.» ");
INSERT INTO meq_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu a gwaɗatay sa: «Makwala neheye tapa tasəla aye na ŋgənatay a ndo hay gwezem faɗ aye na, nakə a ləkaw a rah na, kəteh nday?» Ta mbəɗay faya, tə gwaɗay: «Kəteh tasəla.» ");
INSERT INTO meq_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesu a gwaɗatay: «Aya! Ada ka sərum ha sa bəɗaw?» ");
INSERT INTO meq_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tsa na, tə ndisl a gəma wuray tə zalay Betesayda. Mə ɗəma na, tə gəsay naha həlay a ndoweye andaya guluf eye ka təv i Yesu. Tə gay amboh a Yesu. Tə gwaɗay: «Tətal ka ndo may anaŋ ada mâ ŋgatay a ɗəre tey.» ");
INSERT INTO meq_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu a gəs ndo niye guluf eye mə həlay, a ye ha abəra ma wuzlahgəma. Ti ye naha na, Yesu a tuf slesleɓ ka ɗəre i guluf niye. A pa faya həlay, a tsətsah faya a gwaɗay: «Ka ŋgatay a wu ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Guluf niye a zəba ɗəre na, a gwaɗay a Yesu: «Na ŋgatay a ndo hay. Na ŋgatatay na, andza gərɗaf hay, ane tuk na, faya ta diye.» ");
INSERT INTO meq_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tsa na, Yesu a pay həlay ka ɗəre sa. Ɗəre i guluf niye na, a mbəl lele. A ŋgatay a ɗəre kulir kulir tuk. ");
INSERT INTO meq_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu a gwaɗay: «Anəke na, do wu yak a mətagay tuk. Kâ ye ta wuzlahgəma bay kəla.» ");
INSERT INTO meq_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ma dəba eye na, Yesu ta gawla ŋgay hay tə lətse, ti ye abəra ma gəma niye. Ti ye a gəma neheye bəse tə mbay naha a gəma i Sezare Filipi aye. Ahəl nakə nəteye ka tsəveɗ faya ta diye na, Yesu a tsətsah ka gawla ŋgay hay, a gwaɗatay: «Ndo hay tə gwaɗ fagaya neŋ na, way?» ");
INSERT INTO meq_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ta mbəɗay faya tə gwaɗay: «Siye hay tə gwaɗ nəkar na, Yuhana madzəhuɓe ndo a yam, ndo mekeleŋ eye hay tə gwaɗ nəkar na, Eliya, siye hay tə gwaɗ nəkar na, nəte mə walaŋ i ndo məɗe ha bazlam i Mbəlom hay.» ");
INSERT INTO meq_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesu a tsətsah fataya, a gwaɗatay: «Ada nəkurom ka gwaɗum i kurom, neŋ na, way?» Tsa na, Piyer a mbəɗay faya, a gwaɗay: «Nəkar na, Kəriste.» ");
INSERT INTO meq_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tsa na, Yesu a gatay me, a gwaɗatay: «Kâ tsikumay a ndəray bay.» ");
INSERT INTO meq_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tsa na, Yesu a pa bo ka mətsikatay me a zləm. A gwaɗatay: «Neŋ Wawa i Ndo na, kutoŋ na siye ɗəretsətseh haladzay. Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom ta ndo neheye tə dzaŋgawa bazlam i Mbəlom mapala eye ada siye i madugula hay na, nəteye ta wuɗiye ga bay. Ta kaliye ga ha, ta ta kəɗiye ga. Ane tuk na, na həniye sulo mamahkar eye na, na lətseweye abəra ma mədahaŋ.» ");
INSERT INTO meq_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A ɗatay ha parak parak lele ka həmbər mətsikatay bay. Tsa na, Piyer a zalay kətsah mahəŋgeye, a gay me. ");
INSERT INTO meq_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesu a mbəɗa me ka təv i gawla ŋgay siye hay. A zəba naha fataya. A gay me a Piyer, kutik kutik, a gwaɗay: «Do abəra ka təv ga. Do a dəba, nəkar na, Fakalaw. Ka dzala gər andza Mbəlom bay, ka dzala gər na, andza i ndo zezeŋ.» ");
INSERT INTO meq_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tsa na, Yesu a zalatay a ndo hay ta gawla ŋgay hay. A gwaɗatay a nəteye tebiye: «A say a ndoweye məpeŋ bəzay na, mâ gər ha wu nakə a say a ɗərev ŋgay aye. Mâ zla mayako mazləlmbaɗa eye ada mâ peŋ bəzay. ");
INSERT INTO meq_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Andza niye, ndo nakə a say mətəme ha məsəfəre ŋgay aye na, ma dziye ha ɗuh. Ane tuk na, ndo nakə ma dziye ha məsəfəre ŋgay hərwi ga ada hərwi Labara Ŋgwalak eye na, ma təmiye ha ɗuh. ");
INSERT INTO meq_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Taɗə ndoweye kə huta zlele i məndzibəra tebiye a neŋgeye, ane tuk na, kə dze ha məsəfəre ŋgay na, ŋgama ŋgay aye na, mey? ");
INSERT INTO meq_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Wu andaya nakə ndo zezeŋ ma sliye faya məvəle hərwi mambəɗa ahaya məsəfəre ŋgay aye ɗaw? ");
INSERT INTO meq_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","«Nəkurom ndo neheye anəke aye, nəkurom na, mə walaŋ i ndo neheye tə sər Mbəlom bay, faya ta giye mezeleme aye. Taɗə ndoweye ka kərah ga ada kə ɗatay ha bazlam ga a ndo hay bay na, neŋ dərmak na ta kərahiye na. Na ta kərahiye na na, ahəl nakə neŋ Wawa i Ndo na deyeweye ta məzlaɓ i Bəba Mbəlom ada ta gawla i Mbəlom hay aye.» ");
INSERT INTO meq_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu a gwaɗatay sa: «Sərum ha na, ndo siye hay mə walaŋ kurom neheye anəke kanaŋ aye, nəteye na, ta mətiye zuk bay. Ta ta mətiye na, ta ŋgateye tə ɗəre tay a Bəy i Mbəlom nakə ma ləviye bəy ŋgay ta gədaŋ aye təday.» ");
INSERT INTO meq_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ma dəba i məhəne məkwa na, Yesu a zalay a Piyer, a Yakuba ta Yuhana, ti ye tə tsal a mahəmba zəbol eye. Ahəl nakə nəteye mə mahəmba niye mahəteye na, bo i Yesu a mbəɗa ka ɗəre tay. ");
INSERT INTO meq_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Petekeɗ ŋgay a mbəɗa herre kuɗekuɗek. Məsləɗe i petekeɗ niye na, ndəray kwa nəte ka məndzibəra ma sliye məsləɗe ha andza niye na, andaya bay. ");
INSERT INTO meq_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kwayaŋŋa gawla i Yesu neheye mahkar aye tə ŋgatatay a Eliya ta Musa nəteye faya ta tsikiye me tə Yesu. ");
INSERT INTO meq_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tsa na, Piyer a gwaɗay a Yesu: «Miter ga! Lele na, ndzakwa kanaŋ. Nəmaa kəruwakumeye madzawadzawa mahkar, nəte i yak, nəte i Musa ada nəte i Eliya.» ");
INSERT INTO meq_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piyer a tsik andza niye na, hərwi a sər wu nakə ma tsikiye bay. Hərwi nəteye neheye mahkar aye na, ta dzədzar haladzay. ");
INSERT INTO meq_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pazlay a mbəzlaw mə mbəlom, a dərəzl tay ha. Ma pazlay niye na, bazlam a tsənew abəra mə gəma, a gwaɗ: «Nakay na, wawa ga. Na wuɗa na haladzay. Pumay zləm a wu nakə ma tsikakumeye!» ");
INSERT INTO meq_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tsa na, gawla i Yesu neheye mahkar aye ta zəba ɗəre na, ndəray andaya sa bay. Andaya ka təv niye na, Yesu mahəŋgeye. ");
INSERT INTO meq_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ahəl nakə faya ta mbəzlaweye abəra mə mahəmba aye na, Yesu a gwaɗatay: «Wu nakə ka ŋgatumay aye na, kâ təkərumay a ndəray bay hus a pat nakə neŋ, Wawa i Ndo na lətsew abəra ma mədahaŋ aye təday.» ");
INSERT INTO meq_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ta təma bazlam nakə Yesu a tsikatay aye. Anəke na, ta tsətsah mə walaŋ tay, tə gwaɗ: «Mələtsew abəra ma mədahaŋ na, andza məgweɗe mey?» ");
INSERT INTO meq_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tsa na, gawla ŋgay hay ta tsətsah faya, tə gwaɗay: «Ndo neheye tə dzaŋgawa bazlam i Mbəlom mapala eye tə gwaɗ na, Eliya ma lahaweye madayaw təday na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu a mbəɗatay faya, a gwaɗatay: «Andza niye, Eliya ma lahaweye madayaw. Ma lambaɗiye tay ha wu hay tebiye təday. Ta watsa ka gər i Wawa i Ndo dərmak. Tə watsa na, tə gwaɗ: “Neŋgeye na, ma siye ɗəretsətseh haladzay ada ta zəbiye faya andza ndo bay” bəɗaw? ");
INSERT INTO meq_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Na tsikakumeye parakka: Eliya na, ɓa ki yaw tsɨy. Ndo hay ta gay wu nakə a satay aye. Bazlam i Mbəlom kə tsik faya andza niye.» ");
INSERT INTO meq_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tə ndisl ka təv i siye i gawla ŋgay hay na, tə ndzay naha a gər a ndo hay haladzay tə lawara tay ha a wuzlah. Ndo neheye tə dzaŋgawa bazlam i Mbəlom mapala eye aye ta gawla i Yesu hay faya ta kəɗiye wuway a bo. ");
INSERT INTO meq_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ndo hay tə ŋgatay a Yesu faya ta diye naha ka təv tay ta gawla ŋgay neheye mahkar aye na, a gatay hərɓaɓəkka. Tsa na, ta hway ka təv ŋgay mata tsikay me. ");
INSERT INTO meq_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","A gwaɗatay: «Ka kəɗum wuway ta nəteye ka wuye mey?» ");
INSERT INTO meq_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tsa na, ndoweye andaya mə walaŋ i ndo niye hay a mbəɗayaw faya, a gwaɗay: «Miter, neŋ na zlakaw wawa ga, hərwi mahorvov a gay. A gay na, a ɓaraway ka bazlam ŋgəts. ");
INSERT INTO meq_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mahorvov a gəsawa na. A gəsawa na na, kwa ka waray. A kalawa ha ka dala ɓəra ɓəra. Makukufay a yawaw faya abəra ada a həpəɗawa zler ada a sarawa ha. Na tsətsah ka gawla yak neheye ta həhar faya bəra mahorvov tey na, tə mba faya mahəhere bay.» ");
INSERT INTO meq_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu a tsikatay parakka a ndo niye hay, a gwaɗatay: «Nəkurom neheye anəke ka dzalum ha ka Mbəlom bay aye! Na ndziye ka təv kurom na, hadzəgay? Na zliye ŋgatay hərwi kurom na, məndze hadzəgay? Ahe! Zlumeŋ ahaya wawa eye kanaŋ.» ");
INSERT INTO meq_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ti ye, tə zlayaw wawa niye. Fakalaw niye mə bo i wawa niye a ŋgatay a Yesu na, a ɓəl ha wawa niye ta gədaŋ. Wawa niye a dəɗ. Tsa na, a tambolom ha ka dala tambolom tambolom. Makukufay a yaw ka bazlam. ");
INSERT INTO meq_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu a gwaɗay a bəba i wawa niye: «Wu nakay a gay na, kə ndza faya hadzəgay?» Bəba i wawa niye a mbəɗay faya, a gwaɗay: «Wu nakay a dazlay na, neŋgeye wawa eye mba. ");
INSERT INTO meq_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Fakalaw a kalawa ha a ako ada a yam hərwi ada mâ mət. Taɗə ka sliye faya na, amboh dzəna may tey.» ");
INSERT INTO meq_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu a mbəɗay faya, a gwaɗay: «Ka gwaɗ na, “Taɗə ka sliye faya na, dzəna may tey” ba! Ane tuk na, hərwi ndo nakə kə dzala ha ka neŋ aye na, wuray andaya ma giye bo hərwi ŋgay bay na, andaya bay.» ");
INSERT INTO meq_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tsa na, bəba i wawa niye a wuda ta magala, a gwaɗ: «Na dzala ha! Səkeheŋ ha mədzele ka nəkar.» ");
INSERT INTO meq_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ahəl nakə Yesu ta bəba i wawa niye faya ta tsikiye me aye na, ndo hay ta hway naha haladzay ka təv tay. Yesu ka zəba ndo hay faya ta diye naha na, a ŋgərəz ka fakalaw, a gwaɗ: «Nəkar fakalaw nakay matəra ha ndo mandək eye ada mətsike me bay aye na, faya na gwaɗakeye dara abəra mə bo i wawa nakay. Kâ ma faya mede a bo i wawa nakay ɗaɗa sa bay!» ");
INSERT INTO meq_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Fakalaw niye a wuda, a ɓəl ha wawa niye ta gədaŋ. Tsa na, a ndohwaw abəra mə bo i wawa niye. Wawa niye ma kaleye zləva andza ma mətiye. Ndo hay haladzay ka niye tə gwaɗ: «Wawa nakay na, kə mət.» ");
INSERT INTO meq_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yesu a gəs na mə həlay, a lətse ha. Wawa niye a lətse ka mbəlom. ");
INSERT INTO meq_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tsa na, Yesu ta gawla ŋgay hay, ti ye abəra ka niye, ti ye a mətagay. Ahəl nakə nəteye mahəteye mətagay na, ta tsətsah faya tə gwaɗay: «Nəmay, nəmaa mba faya mahəhere fakalaw abəra ka wawa niye təbey na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu a mbəɗatay faya: «Ka ɗuwulumay me a Mbəlom bay na, ka slumeye faya mahəhere slala i Fakalaw niye bay.» ");
INSERT INTO meq_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu ta gawla ŋgay hay tə lətse, ti ye abəra ma təv niye. Ti ye a təv mekeleŋ eye ta dala i Galile. Yesu a say na, ndo hay tâ sər ha təv nakə neŋgeye mə ɗəma aye bay. ");
INSERT INTO meq_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","A say ndo hay tâ sər faya bay na, hərwi faya ma tətikateye a gawla ŋgay hay. A tətikawatay a gawla ŋgay hay na, a gwaɗawatay: «Neŋ Wawa i Ndo na, ta gəsiye ga, ta vəlateye ga ha a həlay a ndo hay. Ta kəɗiye ga mədahaŋ eye, ada ma məhəne mamahkar eye na, na lətseweye abəra ma mədahaŋ.» ");
INSERT INTO meq_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ane tuk na, gawla ŋgay hay ta tsəne me ŋgay niye a say məgweɗe mey na, ta tsəne bay. Ada ta dzədzar matsətsehe faya. ");
INSERT INTO meq_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tsa na, tə ndisl a Kafernahum. Ti ye naha, ti ye a gay nakə tə ndzawa mə ɗəma aye. Ahəl nakə nəteye mə gay niye na, Yesu a tsətsah fataya, a gwaɗatay: «Meeneŋ faya ka deyekweye ka tsəveɗ na, ka tsikum mə walaŋ kurom na, ka wuye mey?» ");
INSERT INTO meq_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ta mbəɗay faya a Yesu bay. Hərwi ahəl nakə faya ta diye ka tsəveɗ aye na, ta tsətsah ka bo mə walaŋ tay, tə gwaɗ: «Ndo nakə neŋgeye bagwar eye a ze ndo mə walaŋ kway nakay aye na, way?» ");
INSERT INTO meq_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu a ndza ka dala. Tsa na, a hayay gər a gawla ŋgay hay kuro gər eye sulo ka təv ŋgay. A gwaɗatay: «Ndo nakə a say matəre bagwar eye ka gər i ndo hay aye na, mâ həna ha gər ɗuh. Sa na, mâ təra ndo məgay məsler a ndo hay tebiye.» ");
INSERT INTO meq_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tsa na, Yesu a zla wawa tsekweŋ, a lətse ha a wuzlah tay. A gəs na wawa niye kurup kurup ka bo lele. ");
INSERT INTO meq_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Tsa na, a gwaɗatay: «Ndoweye ka təma na wawa nakay lele andza wawa nakay anaŋ eye hərwi nakə a wuɗa ga aye na, a təma na, neŋ. Ndoweye ka təma ga na, a təma neŋ mahəgeye bay. A təma na, ndo nakə a sləra ga ahaya dərmak.» ");
INSERT INTO meq_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ma dəba eye na, Yuhana a gwaɗay a Yesu: «Miter, nəmaa ŋgatay a ndoweye faya ma həhariye fakalaw abəra mə bo i ndo ta məzele yak. A samay haɓe məgay me hərwi neŋgeye na, ndo kway bay.» ");
INSERT INTO meq_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu a mbəɗay faya, a gwaɗay: «Kâ gumay me bay. Hərwi ndoweye kə ge masuwayaŋ tə məzele ga na, ma tsikiye fagaya wu nakə lelebay aye bay. ");
INSERT INTO meq_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Hərwi ndo nakə kə nakway ɗəre bay aye na, neŋgeye ndo kway.» ");
INSERT INTO meq_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yesu a gwaɗatay sa: «Ndoweye kə vəlakum yam məse hərwi nakə ka pumeŋ bəzay a neŋ Kəriste aye na, sərum ha ta deɗek, magogoy ŋgay ma dziye bay.» ");
INSERT INTO meq_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesu a gwaɗatay sa: «Ndoweye ka səpat ndo nəte mə walaŋ i wawa neheye tə dzala ha ka neŋ aye a mezeleme na, ŋgama tâ ɓaray maɗiz i kwar a ɗay ada tâ kal ha a huɗ i bəlay. ");
INSERT INTO meq_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Taɗə həlay yak ma dəɗiye kar ha a mezeleme na, ɗəs na. Ŋgama huta məsəfəre ka təv i Mbəlom tə həlay yak nəte tə bəmalə nakə ta kaliye kar ha a ako nakə ma mbatiye ɗaɗa bay tə həlay yak sulo aye.  ");
INSERT INTO meq_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mə ɗəma na, mətul neheye tə nda ndo aye na, tə mət bay, ada ako nakə ɗaɗa ma mbatiye bay aye. ");
INSERT INTO meq_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Taɗə sik yak ma dəɗiye kar ha a mezeleme na, ɗəs na. Ŋgama ɗuh na, fələkwa a Bəy i Mbəlom tə sik yak nəte tə bəmalə nakə ta kaliye kar ha a ako tə sik yak sulo aye.  ");
INSERT INTO meq_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Hərwi mə ɗəma na, mətul neheye tə nda ndo aye na, tə mət bay, ada ako nakə ɗaɗa ma mbatiye bay aye. ");
INSERT INTO meq_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ada kə ge taɗə ɗəre yak ma dəɗiye kar ha a mezeleme na, ŋgwaɗ na. Ŋgama ɗuh na, fələkwa a Bəy i Mbəlom tə ɗəre yak nəte tə bəmalə nakə ta kaliye kar ha a ako nakə ɗaɗa ma mbatiye bay tə ɗəre yak sulo aye. ");
INSERT INTO meq_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mə ɗəma na, mətul neheye tə nda ndo aye na, tə mət bay, ada ako nakə ɗaɗa ma mbatiye bay aye.» ");
INSERT INTO meq_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yesu a gwaɗatay sa: «Andza ako nakə ndo məvəɗe ma vəɗiye ha wu aye na, ndo neheye tə dzala ga ha ta siye ɗəretsətseh hərwi mede tay. Sluwal dərmak andza niye, ta giye ka ala na, ada mâ vəɗ. ");
INSERT INTO meq_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sluwal na, wu nakə lele aye. Ane tuk na, taɗə sluwal a tsəhən bay na, ta giye ha sa kəkay ada mâ tsəhən na? Wewer andaya matəra ha lele sa bay. Nəkurom dərmak na, tərum andza sluwal nakə a tsəhən lele aye. Mə walaŋ kurom na, ndzum barbarra.» ");
INSERT INTO meq_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ma dəba eye na, Yesu ta gawla ŋgay hay tə lətse, ti ye abəra ma Kafernahum, ti ye ka dala i Yahuda. Tsa na, tə lətse, ti ye tə tas magayam i Yurdum. Mə ɗəma na, ndo hay haladzay tə haya gər ka təv ŋgay sa. Tsa na, a tsikatay bazlam i mbəlom andza nakə a tsikawatay aye. ");
INSERT INTO meq_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farisa hay ti ye naha ka təv ŋgay. Ti ye naha ka təv ŋgay na, hərwi a satay məhəle faya abəra suwat. Ta tsətsah faya tə gwaɗay: «Bazlam kway mapala eye kə vəl tsəveɗ a ndo ka mahəhere ŋgwas ŋgay ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu a mbəɗatay faya na, tə matsətsehe dərmak. A gwaɗatay: «Bazlam mapala eye waray nakə Musa a vəlakum a tsik ka mahəhere ŋgwas na?» ");
INSERT INTO meq_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tə gwaɗay: «Musa a gwaɗ na, taɗə ndoweye a say mahəhere ŋgwas ŋgay na, mâ watsay ɗerewel i mahəhere a həlay. Kə watsay na, ada mâ həhar na tuk. Ndo hay ta səriye ha manaŋ ka həhar na ŋgwas ŋgay na, ka ɗerewel niye.» ");
INSERT INTO meq_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tsa na, Yesu a gwaɗatay: «Musa a watsakum gər i bazlam mapala eye nakay andza nakay na, hərwi ɗərev kurom nakə makula eye toŋgwa toŋgwa. ");
INSERT INTO meq_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ahəl niye ka madazlay na, andza niye bay. Hərwi mawatsa eye ka madazlay i məge məndzibəra na: “Mbəlom a ge hasləka ada ŋgwas. ");
INSERT INTO meq_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Hərwi niye hasləka ma gəriye ha bəba ŋgay ta may ŋgay, ta ndziye ta ŋgwas ŋgay. ");
INSERT INTO meq_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ada nəteye ta təriye na, bo nəte.” Andza niye, nəteye sulo sa bay, ane tuk na, andza ndo nəte.» ");
INSERT INTO meq_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yesu a gwaɗatay sa: «Ndo zezeŋ mâ ŋgəna ha wu nakə Mbəlom a dzapa ha aye bay.» ");
INSERT INTO meq_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yesu ta gawla ŋgay hay ti ye wu tay. Ahəl nakə nəteye mə gay ta gawla ŋgay hay aye na, gawla ŋgay hay ta tsətsah sa, tə gwaɗay: «Bazlam niye ka tsik eye na, andza məgweɗe mey?» ");
INSERT INTO meq_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu a mbəɗatay faya, a gwaɗatay: «Taɗə ndoweye ka həhar na ŋgwas ŋgay ada kə zla a ɗəma ŋgwas mekeleŋ eye na, kə ge madama. Kə gay mənese a ŋgwas ŋgay kurre eye. ");
INSERT INTO meq_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Taɗə ŋgwas a wuɗa na zal ŋgay sa bay, a zla zal mekeleŋ eye dərmak na, kə ge madama.» ");
INSERT INTO meq_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ma dəba aye na, ndo hay tə həl naha wawa hay a Yesu hərwi ada mâ pa fataya həlay ada tâ huta ŋgama. Ane tuk na, gawla ŋgay hay tə gatay me a ndo niye hay tə həlay naha wawa hay aye. ");
INSERT INTO meq_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu a ŋgatay andza niye na, a yay a gər bay. A ndalay. A gwaɗatay a gawla ŋgay hay: «Gərum tay ha wawa hay tâ yaw ka təv ga! Kâ həharum tay hay bay, hərwi Bəy i Mbəlom mavəla eye na, a slala i ndo neheye andza wawa neheye. ");
INSERT INTO meq_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Sərum ha na, ndoweye ka təma Bəy i Mbəlom andza wawa neheye bay na, ma diye a Bəy i Mbəlom bay.» ");
INSERT INTO meq_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tsa na, a zla wawa niye hay a həlay nəte ta nəte. A pa fataya ŋgama. ");
INSERT INTO meq_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu ta gawla ŋgay hay tə lətse, ta diye na, ndoweye a yaw ka təv ŋgay mahway mahway. A ndisl ka təv ŋgay na, a dəkway gurmets kame ŋgay, a gwaɗay: «Miter lele eye, na hutiye sifa nakə ma ndəviye bay aye na, na giye na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu a gwaɗay: «Ka zeleŋ ndo lele eye na, kemey? Ndo lele eye na, Mbəlom nəte ŋgweŋ. ");
INSERT INTO meq_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ka sər bazlam i Mbəlom mapala eye ɗaw? Bazlam i Mbəlom mapala eye a gwaɗ na: “Kâ kəɗ gər i ndo bay, kâ ge madama bay, kâ ge məkal bay, kâ raw me ka ndo kame i sariya bay, kâ vay gər a ndo bay, rəhatay ha gər a bəba yak ta may yak.”» ");
INSERT INTO meq_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ndo niye a gwaɗay: «Miter, gər i bazlam mapala eye neheye ka paslaweye na, na hənay ha gər kwa ma wawa.» ");
INSERT INTO meq_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu a ndazl na na, a wuɗa na haladzay. Tsa na, a gwaɗay: «A ləkaw fakaya abəra na, wu nəte. Anəke na, do ta səkəm ha zlele yak hay tebiye ada kâ ŋgənatay suloy aye a ndo i mətawak hay. Ka ge andza niye na, ka ta hutiye zlele mə mbəlom. Tsa na, dara, peŋ bəzay.» ");
INSERT INTO meq_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ndo niye a tsəne bazlam niye na, ɗərev a həɓay. A ye ŋgway ta mevel eye, hərwi zlele ŋgay na, haladzay. ");
INSERT INTO meq_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu a ŋgatay a ndo niye a ye ŋgway na, a zəba ka gawla ŋgay niye hay tə lawara na a wuzlah aye. A gwaɗatay: «Kay! Hərwi ndo i zlele na, mede a Bəy i Mbəlom i ŋgay na, mada me eye haladzay.» ");
INSERT INTO meq_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Gawla ŋgay hay tə tsəne bazlam niye na, a vəlatay madzədzere. Ane tuk na, Yesu a gwaɗatay sa: «Wawa ga hay! Mede a Bəy i Mbəlom na, mada me eye haladzay! ");
INSERT INTO meq_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tə bəmalə nakə ndo i zlele ma diye a Bəy i Mbəlom aye na, ŋgama zləgweme mâ ye ta bəɗ i ləpəre.» ");
INSERT INTO meq_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tsa na, a gatay wadəŋ wadəŋ a gawla ŋgay hay. Tə gwaɗ mə walaŋ tay: «Ane tuk na, kə ge andza niye na, mata sle mətəme na, way?» ");
INSERT INTO meq_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu a zəba fataya, a gwaɗatay: «Ndəray ma sliye mətəme bay. Ane tuk na, Mbəlom ma sliye mətəme ha ndo. Hərwi neŋgeye na, wuray a zay gədaŋ təbey.» ");
INSERT INTO meq_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tsa na, Piyer a gwaɗay: «Tsəne! Nəmay anaŋ, nəmaa gər ha wu hay tebiye hərwi məpaka bəzay na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu a mbəɗatay faya a gwaɗatay: «Sərum ha! Ndoweye kə gər ha gay ŋgay, malamar ŋgay hasləka eye hay ta malamar ŋgay dem eye hay, may ŋgay, bəba ŋgay, wawa ŋgay hay, guvah ŋgay hərwi ga ada hərwi Labara Ŋgwalak eye na, ");
INSERT INTO meq_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","anəke ahəl kway nakay ma hutiye a ɗəma gay hay, malamar hasləka eye hay, malamar dem eye hay, maya hay, wawa hay, guvah hay na, haladzay a ze nakə a gər ha aye. Kəla na, ta geye ɗəretsətseh haladzay dərmak. Aza kame na, ma hutiye sifa nakə ma ndəviye bay aye. ");
INSERT INTO meq_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mə walaŋ i ndo neheye anəke nəteye ndo i me hay aye na, haladzay ta təriye ndo i dəba ada mə walaŋ i ndo neheye anəke nəteye ndo i dəba hay aye na, haladzay ta təriye ndo i me.» ");
INSERT INTO meq_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu ta gawla ŋgay hay, tə həl bo, tə lətse hərwi mede a Zerozelem. Anəke na, nəteye ka tsəveɗ faya ta diye. Kame tay na, Yesu. Gawla ŋgay niye hay ta dzədzar. Ndo neheye tə patay bəzay faya ta diye ka bo dziye ta dzədzar haladzay. Yesu a zalatay a gawla ŋgay niye hay kuro gər eye sulo aye abəra mə walaŋ i ndo niye hay kətsah sa. Ka təv niye na, a tsikatay wu nakə ma ta təriye ka gər ŋgay aye. ");
INSERT INTO meq_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","A gwaɗatay: «Tsənum, anəke na, faya ka deyekweye a Zerozelem. Mə ɗəma na, neŋ Wawa i Ndo ta vəlateye ga ha a həlay a bagwar i ndo neheye tə vəlaway wu a Mbəlom aye ada a ndo neheye tə dzaŋgawa bazlam i Mbəlom mapala eye. Ta geŋeye sariya i məkəɗe. Ta vəlay ga ha a həlay i ndo neheye tə sər Mbəlom bay aye. ");
INSERT INTO meq_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nəteye na, ta ŋgweseŋeye dəla abəra mə gər. Ta tufeŋeye slesleɓ a ɗəre. Ta ndaɓiye ga ta mandalaɓa. Tsa na, ada ta kəɗiye ga tuk. Aya ane, ma dəba i məhəne mahkar na, na lətseweye abəra ma mədahaŋ.» ");
INSERT INTO meq_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ma dəba aye na, Yakuba ta Yuhana wawa i Dzebede hay ta həndzəɗ ka təv ŋgay, tə gwaɗay: «Bəy Maduweŋ may, a samay na, gamay wu nakə a samay matsətsehe fakaya aye?» ");
INSERT INTO meq_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu a gwaɗatay: «A sakum nâ ge hərwi kurom na, wuye mey?» ");
INSERT INTO meq_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ta mbəɗay faya tə gwaɗay: «Wu nakə nəmaa tsətsah fakaya aye na, ahəl nakə aza ka ndziye ma bəy yak na, vəlamay tsəveɗ nəmaâ ndza ka təv yak, nəte ta diye i həlay i mənday ada neŋgeɗ ta diye i həlay i gula yak tey.» ");
INSERT INTO meq_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ane tuk na, Yesu a gwaɗatay: «Ka sərum wu nakə ka tsətsahumeye aye bay? Ka slumeye məse ɗəretsətseh nakə na siye aye ɗaw? Ka slumeye faya matəme tâ dzəhuɓ kurom ha a ɗəretsətseh nakə ta dzəhuɓiye ga ha a ɗəma aye ŋgway ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ta mbəɗay faya, tə gwaɗay: «Nəmaa sliye faya.» Yesu a gwaɗatay: «Andza niye deɗek, ɗəretsətseh nakə na ta siye na, ka ta sumeye. Ɗəretsətseh nakə ta dzəhuɓiye ga ha a ɗəma aye na, ta dzəhuɓiye kurom ha a ɗəma. ");
INSERT INTO meq_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ane tuk na, məndze ta diye i həlay i mənday ga kəgəbay ta diye i həlay i gula ga na, mata tsike na, neŋ bay. Təv məndze niye na, i ndo neheye Mbəlom a ləvatay ha bo aye wu tay.» ");
INSERT INTO meq_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Siye i gawla ŋgay neheye kuro aye tə tsəne bazlam niye na, a ndalatay haladzay. Tə ge mevel ka Yakuba ta Yuhana. ");
INSERT INTO meq_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hərwi niye Yesu a zalatay tebiye ka təv ŋgay, a gwaɗatay: «Ka sərum ha na, ndo neheye ta zəba fataya andza bəy bagwar eye ka məndzibəra faya ta ləviye ndo hay ta gədaŋ ada ndo bagwar eye hay ta ɓərəkiye ha gədaŋ tay ka siye i ndo hay. ");
INSERT INTO meq_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ane tuk na, mâ ge andza niye mə walaŋ kurom bay. Ɗuh na, kə ge ndəray mə walaŋ kurom a say matəre bagwar eye na, mâ təra ndo i məsler kurom. ");
INSERT INTO meq_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ada taɗə ndo mə walaŋ kurom a say matəre ndo i me na, mâ təra beke i ndo hay tebiye ɗuh. ");
INSERT INTO meq_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kwa neŋ Wawa i Ndo na yaw na, hərwi ada ndo hay tâ geŋ məsler bay. Na yaw ɗuh na, hərwi məgatay məsler a ndo hay ada məvəle ha məsəfəre ga hərwi məmbəle tay ha ndo hay haladzay.» ");
INSERT INTO meq_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu ta gawla ŋgay hay tə ndisl a gəma i Zeriko. Ahəl nakə ti yaw abəra ma gəma niye na, ndo hay haladzay tə patayaw bəzay. Faya ta diye na, tə ndzay a gər a guluf wuray faya ma rəkiye wu mandza eye ka tsakay i tsəveɗ. Məzele ŋgay na, Bartime, andza məgweɗe wawa i Time. ");
INSERT INTO meq_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Guluf niye a tsəne taɗakay faya ma diye na, Yesu ndo i Nazaret na, a wuda, a gwaɗ: «Yesu, Wawa i Davit, nâ gaka mə bo təbəɗew?» ");
INSERT INTO meq_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ndo hay haladzay tə gay me, tə gwaɗay: «Ka bəbəl mey? Ndza ɗikɗik!» Neŋgeye na, a səkah ha mawude sa ɗuh: «Wawa i Davit, nâ gaka mə bo təbəɗew?» ");
INSERT INTO meq_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tsa na, Yesu a lətse, a gwaɗatay: «Dum zalumeŋayaw, mâ yaw.» Ti ye tə zalay a guluf niye, tə gwaɗay: «Ɗərev mâ ye fakaya abəra bay. Lətse! Dara, faya ta zalakeye.» ");
INSERT INTO meq_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tsa na, a lətse hurum, a kal ha petekeɗ i mətasl ŋgay əvez ka dala. A ndapa a mbəlom, tsa na, a ye ka təv i Yesu. ");
INSERT INTO meq_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu a tsətsah faya, a gwaɗay: «A saka nâ ge hərwi yak na, mey?» Guluf niye a mbəɗay faya, a gwaɗay: «Miter, a seŋ na, nâ ŋgatay a ɗəre sa tey.» ");
INSERT INTO meq_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tsa na, Yesu a gwaɗay: «Ka pa mədzal gər yak ka neŋ ta deɗek. Do, ka mbəl!» Tsa na, guluf niye a ŋgatay a ɗəre kwetseh kwetseh lele. A pay bəzay a Yesu. ");
INSERT INTO meq_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Anəke na, Yesu ta gawla ŋgay hay, nəteye bəse ta Zerozelem. Nəteye mə mahəmba nakə tə zalay Mahəmba i Tetəɗœz aye. Ka mahəmba eye niye na, gəma i Betifadze ta Betani andaya. Mə ɗəma na, Yesu a slər tay ha gawla ŋgay hay sulo, a gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«Dum a gəma nakə kame kurom aye. Ka ndislum naha a ɗəma na, ka ndzumeye a gər a zuŋgo wawa eye ɗa məzle ndo maɓara eye. Ndəray kə ndza faya ɗaɗa zuk bay. Pəlumaw ada kâ yumeŋ ahaya. ");
INSERT INTO meq_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ndəray kə gwaɗakum: “Ka pəlumeye zuŋgo eye məge ha mey?” na, gwaɗumay: “A say a Bəy Maduweŋ. Ma ta ma ahaya kanaŋ bəse, ma ndziye bay.”» ");
INSERT INTO meq_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tsa na, ti ye a gəma niye. Ti ye naha a ɗəma na, tə huta zuŋgo niye wawa aye maɓara eye ma bəra ka məgeɗ, ka tsakay i tsəveɗ. Tsa na, tə pəla ha zuŋgo niye. ");
INSERT INTO meq_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mə ɗəma na, ndo hay andaya mandza eye. Tə gwaɗatay: «Ka gumeye ka niye mey? Ka pəlumeye zuŋgo eye məge ha mey?» ");
INSERT INTO meq_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tsa na, ta mbəɗatay faya andza nakə Yesu a tsikatay naha aye. Ndo niye hay tə tsəne andza niye na, tə gər tay ha. Tsa na, ti ye ha zuŋgo niye. ");
INSERT INTO meq_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ti ye ahaya zuŋgo niye a Yesu na, ta fətəl faya petekeɗ tay hay. Tsa na, a ndza ka zuŋgo niye. ");
INSERT INTO meq_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ndo hay haladzay ta fətəl petekeɗ tay hay ka tsəveɗ. Siye hay tə pa hawal i gərɗaf neheye tə ɗəsaw ma guvah hay aye hərwi məɗəslay ha gər a Yesu dərmak. ");
INSERT INTO meq_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ndo neheye kame i Yesu ta ndo neheye ma dəba ŋgay aye na, ta wuda, tə gwaɗ: «Zambaɗakway a Mbəlom! Mâ pa ŋgama ka ndo nakə faya ma deyeweye tə məzele i Bəy Maduweŋ aye! ");
INSERT INTO meq_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mbəlom mâ pa ŋgama ka bəy i bəba kway Davit! Zambaɗakway a Mbəlom, neŋgeye nakə mə mbəlom aye!» ");
INSERT INTO meq_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tsa na, tə ndisl a Zerozelem. Tə ndisl naha a Zerozelem na, ti ye a gay i məɗəslay ha gər a Mbəlom. A ndisl naha na, a zəba ka wu nakə ndo hay faya ta giye mə ɗəma aye. Ma dəba eye na, ti ye ta gawla ŋgay hay a gəma i Betani. Ti ye a ɗəma na, hərwi mazlambar pat faya ma dəɗiye. ");
INSERT INTO meq_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tədœ eye na, Yesu ta gawla ŋgay hay tə lətse abəra ma gəma i Betani, tə ma a Zerozelem. Ka tsəveɗ faya ta diye na, may a wur ka Yesu. ");
INSERT INTO meq_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A ŋgatay naha a dərizl i gərɗaf wuray andza gurov slambah faya haladzay. Tsa na, a ye mata zəbaw faya. A gwaɗ: «Iŋgeɗhay na hutiye hohway ŋgay eye na ndiye.» A ye, a ndisl naha ka təv i dərizl i gərɗaf niye na, kakupkuppa slambah ɗekɗek bəna, hohway andaya bay. Hərwi kə ndisl ahəl ŋgay məwe bay. ");
INSERT INTO meq_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tsa na, Yesu a gwaɗay a dərizl i gərɗaf niye: «Ndəray mâ nda hohway yak ɗaɗa sa bay!» Tsa na, gawla ŋgay hay ta tsəne. ");
INSERT INTO meq_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ma dəba eye na, tə ndisl a Zerozelem sa. Yesu a ye naha na, a ye a dalamətagay i gay i məɗəslay ha gər a Mbəlom. A ye naha na, a dazlay mahəhere tay ha ndo masəkəme wu hay ta ndo neheye ta səkəmiye hay wu hay aye. A pay həlay a tabal i ndo mambəɗe ha suloy, a mbəzl ha təv məndze i ndo masəkəme ha bodobodo hay. ");
INSERT INTO meq_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","A gatay me a ndo məzle wu i tsakala kwa waray waray mede ha ta dalamətagay i gay i məɗəslay ha gər a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","A ɗatay ha lele, a gwaɗatay: «Mawatsa eye mə Ɗerewel i Mbəlom na: “Ta zaleye a gay ga na, gay i maɗuwule me i slala i ndo hay wal wal tebiye.” Ane tuk na, nəkurom ka tərum ha lar i məkal hay na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye, tə tsəne wu nakə Yesu a gawa aye na, ta dzədzar hərwi ndo hay ta wuɗa bazlam i Yesu niye a tsikatay aye. Ta pəla tsəveɗ ka məkəɗe na Yesu. ");
INSERT INTO meq_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ta huwa pat pizze na, Yesu ta gawla ŋgay hay tə lətse, ti ye abəra ma Zerozelem. ");
INSERT INTO meq_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tədœ eye pərik i mekedœ na, Yesu ta gawla ŋgay hay tə ma a Zerozelem. Ahəl nakə faya ta diye na, tə ŋgatay a dərizl i gərɗaf niye andza gurov aye. Dərizl i gərɗaf niye na, makula eye hus ta zləlay eye dzay. ");
INSERT INTO meq_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piyer a ŋgatay na, bazlam i Yesu nakə a tsikay a dərizl i gərɗaf niye a mayaw a gər. Tsa na, a gwaɗay a Yesu: «Miter, zəba ka dərizl i gərɗaf nakə ka vəlay mezeleme aye na, kə kula.» ");
INSERT INTO meq_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu a mbəɗatay faya, a gwaɗatay: «Gərumay ha mədzal gər kurom a Mbəlom! ");
INSERT INTO meq_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Sərum ha lele, ndoweye kə gwaɗay a mahəmba nakay: “Lətse abəra kanaŋ, ta kal ha bo a bəlay”, kə ge a tsik ta mədzal gər nəte na, Mbəlom ma təmiye na. Ada mâ sər ha na, ma giye bo andza nakə a tsətsah aye. ");
INSERT INTO meq_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hərwi niye faya na tsikakumeye: Taɗə ka ɗuwulum me, ka tsətsahum wu ka Mbəlom na, dzalum ha na, ɓa ka hutum tsɨy. Mbəlom ma vəlakumeye. ");
INSERT INTO meq_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Agəna nəkurom ta magum eye ta ndo na, ka ta ɗuwulumeye me a Mbəlom na, dum pəsum ha bo təday. Ada Mbəlom Bəba kurom mə mbəlom ma pəsakumeye ha dərmak.  ");
INSERT INTO meq_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Taɗə nəkurom mandza eye huya ta magum eye na, Bəba kurom nakə mə mbəlom aye ma pəsakumeye ha bay dərmak.» ");
INSERT INTO meq_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ma dəba eye na, tə ma a Zerozelem tuk. Yesu a ye a dalamətagay i gay i məɗəslay ha gər a Mbəlom. Ahəl nakə faya ma həhaliye mə ɗəma aye na, bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye ada ta madugula siye hay, ti ye ka təv i Yesu. ");
INSERT INTO meq_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ti ye naha na, ta tsətsah faya, tə gwaɗay: «Ka ge wu neheye na, ta gədaŋ waray? Maa vəlaka gədaŋ eye na, way?» ");
INSERT INTO meq_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu a mbəɗatay faya, a gwaɗatay: «Neŋ dərmak na tsətsahiye fakuma matsətsehe nəte, taɗə ka mbəɗumeŋew faya na, na ge wu neheye ta gədaŋ waray na, na tsikakumeye. ");
INSERT INTO meq_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Maa sləraw Yuhana madzəhuɓe ndo a yam na, way? Maa sləraw na, Mbəlom tsukuɗu ndo hay ɗaw? Mbəɗumeŋew faya tey.» ");
INSERT INTO meq_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tsa na, tə tsik mə walaŋ tay, tə gwaɗ: «Ka mbəɗakweye faya na, kəkay? Taɗə ka gwaɗakwa, maa slər ha Mbəlom, Yesu ma gwaɗakweye: “Ka dzalum ha ka wu nakə Yuhana a tsik aye bay na, kemey?” ");
INSERT INTO meq_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ada ka mbəɗakweye faya məgweɗe maa sləraw Yuhana na, ndo hay, ka tsikakweye təta bay.» Tə tsik təta bay na, hərwi ndo hay tebiye tə sər ta deɗek Yuhana na, ndo məɗe ha bazlam i Mbəlom. Ta dzədzar mətsike andza niye hərwi ndo hay. ");
INSERT INTO meq_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ta mbəɗay faya a Yesu, tə gwaɗay: «Nəmaa sər bay.» Yesu a gwaɗatay: «Neŋ bəbay na ge wu neheye ta gədaŋ i way na, na tsikakumeye bay.» ");
INSERT INTO meq_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ma dəba eye na, Yesu a tsikatay me ta dzeke, a gwaɗatay: «Ndoweye a ɗəs guvah. A zəv a ɗəma dərizl i gərɗaf haladzay. Dərizl i gərɗaf niye hay na, tə wa hohway aye. A ndəv ha mazəve na, a lawara na həndits ta zleɗ. Tsa na, a lambaɗ a ɗəma təgwaɗ hərwi maɗɨtse a ɗəma hohway i dərizl i gərɗaf niye hay. A ɗəzl a ɗəma təv matsəpe wu. A ndəv ha malembeɗe guvah ŋgay niye na, a həl ndo i məfəte hay ada tâ fətay na. Bo ŋgay aye a ye a tsekene. ");
INSERT INTO meq_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","«Həlay i maŋgəle hohway i dərizl i gərɗaf niye hay kə sla. A slər ndo nəte mə walaŋ i ndo i məsler ŋgay hay hərwi ada tâ vəlayaw faya abəra i ŋgay. ");
INSERT INTO meq_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tsa na, ndo i məsler niye a ye. A ye naha na, ndo neheye faya ta tsəpiye guvah aye tə gəs na. Tə ndaɓa na ada ta həhara ahaya həlay kəriye. ");
INSERT INTO meq_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ndo i guvah a ŋgatay andza niye na, a slər ndo neŋgeɗ. A ye naha na, kurah tə wuya faya məkəɗe na. Tə kəɗ na ka gər, tə tsaɗay pəleslesle. ");
INSERT INTO meq_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ndo i guvah niye a zla ndo i məsler ŋgay mamahkar eye, a slər na sa. Neŋgeye na, tə kəɗ na mədahaŋ eye. Ndo i guvah niye a slər ndo wal wal sa. Tə ge tay ha andza niye dərmak. Siye hay tə ndaɓa tay ha, siye tə kəɗ tay mədahaŋ eye hay. ");
INSERT INTO meq_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","«Anəke a zəkayaw a ndo i guvah niye na, wawa ŋgay nəte nakə a wuɗa na haladzay aye. A slər na wawa ŋgay niye nəte aye. Hərwi a dzala a gwaɗ: “Wawa ga na, ta rəhay ha gər, ta geye wuray bay.” ");
INSERT INTO meq_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","«Wawa niye a ye. Tə ŋgatay na, tə gwaɗ mə walaŋ tay: “Aya! Anaŋ magedze ŋgay nakə ma ta ndiye na guvah ŋgay aye, ki yaw! Takwa, kəɗakwa na, ada guvah nakay ma mətsakweye a nəkway!” ");
INSERT INTO meq_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tsa na, ti ye faya, tə gəs na. Tə kəɗ na. Tə kal ha mədahaŋ eye dəreŋ abəra ma guvah niye.» ");
INSERT INTO meq_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tsa na, Yesu a tsətsah fataya a gwaɗatay: «Ndo i guvah ma giye anəke na, kəkay? Ndo i guvah niye ma deyeweye na, ma gəsiye tay ha ndo niye hay, ma kəɗiye tay ha. Ada ma həliye a ɗəma ndo mekeleŋ eye hay. ");
INSERT INTO meq_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ka dzaŋgum bazlam nakay mə Ɗerewel i Mbəlom bəɗaw? Mə ɗəma mawatsa eye na, a gwaɗ: “Kwar nakə ndo maɗəzle gay hay tə kal ha aye na, maa təra kwar lele eye a ze siye kwar hay na, neŋgeye ɗuh. ");
INSERT INTO meq_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Maa gwaɗ kwar niye mâ təra kwar nakə lele eye hərwi maɗəzle gay na, Mbəlom. Niye na, məsler i Mbəlom hərwi kway.”» ");
INSERT INTO meq_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Madugula i Yahuda hay tə sər ha a tsik andza niye na, ka nəteye. Tsa na, ta pəla tsəveɗ məgəse na. Ane tuk na, tə gər ha, ti ye wu tay hərwi ta dzədzar ma ta ndalateye a ndo hay. ");
INSERT INTO meq_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ma dəba eye na, tə slər Farisa hay ta ndo hay ŋgal mə walaŋ i ndo i Herod. Ti ye ka təv i Yesu hərwi məhəle faya abəra suwat. ");
INSERT INTO meq_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ti ye naha tə gwaɗay: «Miter, nəmaa sər ha nəkar ka tsik na, deɗek. Ka dzədzaray a wu nakə ndo hay ta dzaliye təbey ada ka ŋgəna tay ha ka bo bəra ndo hay təbey. Faya ka tətikateye a ndo hay deɗek ka mede nakə a say a Mbəlom aye. Ane tuk na, a samay matsətsehe fakaya: Bazlam kway mapala eye kə vəl tsəveɗ məvəle dzaŋgal a bəy i Roma tsukuɗu kə vəl tsəveɗ məvəle bay? Lele məvəle bay tsukuɗu, lele məvəle ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yesu a sər ha a satay məhəle faya abəra suwat. Tsa na, a gwaɗatay: «A sakum məhəle fagaya abəra suwat na ka mey? Ehe zlumeŋew kwar i suloy təday, a seŋ mazəbe faya.» ");
INSERT INTO meq_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tə zlay naha kwar i suloy nəte. Tə vəlay. A təma kwar i suloy niye a zəba faya. Tsa na, a tsətsah, a gwaɗatay: «Mandzəkit bo nakay ta məzele nakay faya na, i way?» Tə gwaɗay: «I bəy i Roma ada mawatsa eye faya na, məzele ŋgay.» ");
INSERT INTO meq_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tsa na, Yesu a gwaɗatay: «Aya! Wu i bəy i Roma na, vəlumay ha a bəy i Roma ŋgway. Wu i Mbəlom na, vəlumay ha a Mbəlom ŋgway.» Tə tsəne bazlam i Yesu niye na, a gatay hərɓaɓəkka. ");
INSERT INTO meq_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ma dəba eye na, Saduke hay ti ye ka təv i Yesu. Azlakwa bay Saduke hay na, nəteye tə dzala ha tə gwaɗ: «Ka mət na, mələtsew abəra ma mədahaŋ andaya sa bay.» ");
INSERT INTO meq_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ti ye ta tsətsah ka Yesu, tə gwaɗay: «Miter, bazlam nakə Musa a watsamay a bazlam i Mbəlom mapala eye na, anaŋ. A gwaɗ: “Taɗə ndo a mət a gər ha ŋgwas ŋgay, ta wa zuk bay na, mata zle na madakway i ŋgwas niye na, malamar i ndo niye a mət aye bəɗaw? Ma zliye na, hərwi ada hulfe i ndo niye a mət aye mâ dze bay.” ");
INSERT INTO meq_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Aya andaya ahəl niye ndo ta malamar ŋgay hay tasəla. Malamar tay bagwar eye a zla dahəlay. A zla dahəlay na, a mət. A mət na, ta wa ta dahəlay ŋgay niye a zla aye bay. ");
INSERT INTO meq_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Məmbager ŋgay a zla na madakway i ŋgwas niye. Tsa na, a mət ze məwe wawa ta ŋgwas niye. Malamar tay mamahkar eye a ge ha andza niye dərmak. ");
INSERT INTO meq_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nəteye niye tasəla tə zla ŋgwas niye na, tə mət tebiye. Ndəray nəte mə walaŋ tay ta wa wawa ta ŋgwas niye bay. Ma dəba eye nəteye niye tebiye tə mət na, ŋgwas a mət dərmak. ");
INSERT INTO meq_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Pat nakə aza ndo hay ta lətseweye abəra ma mədahaŋ aye na, ŋgwas niye ma mətseye na, a way? Hərwi mey na, nəteye niye tasəla aye ta zla na ka ŋgwas!» ");
INSERT INTO meq_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu a mbəɗatay faya, a gwaɗatay: «Andza niye bay. Kâ vumay gər a mədzal gər kurom bay. Ka tsikum andza niye na, hərwi ka sərum wu nakə mawatsa eye mə Ɗerewel i Mbəlom aye bay ada ka sərum gədaŋ i Mbəlom bay. ");
INSERT INTO meq_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ahəl nakə ta lətseweye abəra ma mədahaŋ aye na, hasləka hay ta ŋgwas hay ta zliye bo sa bay. Ane tuk na, ta ndziye na, andza gawla i Mbəlom neheye mə mbəlom aye. ");
INSERT INTO meq_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Bazlam nakə a tsik ka mələtsew abəra ma mədahaŋ aye na, ka dzaŋgum ɗaɗa mə ɗerewel i Musa təbəɗew? A ɗa ha na, bazlam nakə Mbəlom a tsikayaw mə gay i dak niye dzaydzay andza faya ma təmiye na aye. Ka təv eye niye na, Mbəlom a gwaɗay a Musa: “Neŋ na, Mbəlom i Abraham, Mbəlom i Izak, Mbəlom i Zakob.” ");
INSERT INTO meq_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mbəlom na, neŋgeye Mbəlom i mədahaŋ hay bay, neŋgeye Mbəlom i ndo neheye ta ndziye huya ta sifa aye. Nəkurom ka dzum tsəveɗ hərwi nakə ka gwaɗum mələtsew abəra ma mədahaŋ andaya bay aye.» ");
INSERT INTO meq_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ahəl nakə Yesu ta Saduke hay faya ta tsikiye me aye na, ndo mədzaŋgawa bazlam i Mbəlom mapala eye andaya dərmak, faya ma piye zləm. A tsik ma mədzele gər ŋgay, a gwaɗ: «Yawa! Yesu a mbəɗatay faya a Saduke hay na, lele.» Tsa na, a həndzəɗ ka təv i Yesu. A tsətsah ka Yesu a gwaɗay: «Bazlam i Mbəlom mapala eye nakə a ze siye hay aye na, waray?» ");
INSERT INTO meq_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu a gwaɗay: «Bazlam i Mbəlom nakə mapala eye a ze siye hay aye na, anaŋ: “Nəkurom Israyel hay, pum zləm! Bəy Maduweŋ Mbəlom kway na, neŋgeye Bəy Maduweŋ nəte ŋgweŋ. ");
INSERT INTO meq_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Wuɗa Bəy Maduweŋ Mbəlom yak tə ɗərev yak tebiye, ta məsəfəre yak tebiye, tə metsehe yak tebiye, ada ta gədaŋ yak peteh.” ");
INSERT INTO meq_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Bazlam mapala eye masulo eye anaŋ sa: “Wuɗa ndo i məgeɗ yak dərmak andza ka wuɗa na gər yak.” Bazlam i Mbəlom mapala eye maze neheye sulo aye na, andaya sa bay.» ");
INSERT INTO meq_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tsa na, ndo mədzaŋgawa bazlam i Mbəlom mapala eye a gwaɗay a Yesu: «Lele haladzay ŋgalaka! Wu nakə ka tsik aye na, deɗek. Bəy Maduweŋ na, neŋgeye Mbəlom nəte. Ma dəba ŋgay na, Mbəlom mekeleŋ eye andaya bay. ");
INSERT INTO meq_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kwa way mâ wuɗa Mbəlom tə ɗərev ŋgay tebiye, ta ndaraw ŋgay tebiye. Ada mâ wuɗa ndo i məgeɗ ŋgay dərmak andza a wuɗa na gər ŋgay. Niye na, a ze məfəkay naha slo i gənaw a Mbəlom tə məvəlay naha siye i wu hay wal wal.» ");
INSERT INTO meq_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu a ŋgatay ndo niye a mbəɗay faya na, tə metsehe lele. Tsa na, a gwaɗay a ndo niye: «Nəkar na, bəse tə mede a Bəy i Mbəlom.» Ma dəba eye na, horoy a gatay a ndo hay matsətsehe faya bazlam. ");
INSERT INTO meq_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ahəl niye na, Yesu a tətikawatay a ndo hay mə gay i məɗəslay ha gər a Mbəlom. A tsətsah ka ndo hay, a gwaɗatay: «Ndo mədzaŋgawa bazlam i Mbəlom mapala eye tə gwaɗ Kəriste neŋgeye na, Wawa i Davit na, kəkay? ");
INSERT INTO meq_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Hərwi kwa Davit na, a tsik ta Məsəfəre Tsəɗaŋŋa eye, a gwaɗ: “Bəy Maduweŋ Mbəlom a gwaɗay a Bəy Maduweŋ ga na: Dara, ndza tə həlay i mənday ga, hus a pat nakə neŋ, na piye tay ha ndo məne ɗəre yak hay a huɗ i sik yak aye.” ");
INSERT INTO meq_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«Davit tə gər ŋgay na, kə zalay a Kəriste “Bəy Maduweŋ” tuk na, Kəriste ma təriye wawa ŋgay na, kəkay?» Bazlam i Yesu niye a tsik eye na, a yatay a gər a ndo niye hay faya ta pay zləm aye. ");
INSERT INTO meq_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wu nakə faya ma tətikateye aye na, anaŋ. A gwaɗatay: «Həbum gər kurom abəra ka ndo mədzaŋgawa bazlam i Mbəlom mapala eye hay. Nəteye i tay ta wuɗa mahəhele na, ta rəkwat eye. Ka təv məhay gər na, a satay ndo hay tâ tsikatay me ta məɗəslatay ha gər. ");
INSERT INTO meq_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kwa mə gay i maɗuwule me na, ta pəlawa i tay na, təv məndze nakə kame i ndo hay aye, ndo hay ta ŋgatateye lele. Mə magurlom, ta wuɗa na, təv məndze ŋgwalak eye. ");
INSERT INTO meq_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wu nakə tə vəlawatay a madakway i ŋgwas hay aye na, tə ndayawa na. Tə ɗuwulawa me na, vəɗvəɗ a ndəv bəse bay hərwi ada ndo hay tâ gwaɗ fataya nəteye ndo ŋgwalak eye hay. Slala i ndo neheye andza nakay aye na, Mbəlom ma giye fataya sariya na, ma ziye ndo siye hay!» ");
INSERT INTO meq_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ma dəba eye na, Yesu a ndza bəse ta təv nakə ndo hay tə pawa a ɗəma suloy mə gay i məɗəslay ha gər a Mbəlom. Ahəl nakə ndo hay faya ta piye suloy a wu məpe suloy aye na, Yesu faya ma zəbiye ka ndo hay ta piye suloy eye na, kəkay. Ndo i zlele hay haladzay tə pa a ɗəma suloy haladzay. ");
INSERT INTO meq_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Madakway i ŋgwas wuray mətawak eye a ye naha dərmak. A ye naha a pa a ɗəma koɓo sulo. Koɓo ŋgay niye na, a sla dala nəte bay. ");
INSERT INTO meq_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu a ŋgatay a madakway i ŋgwas niye na, a zalatay a gawla ŋgay, a gwaɗatay: «Sərum ha, madakway i ŋgwas nakay na, maa vəl dala haladzay a ze i ndo hay na, neŋgeye. ");
INSERT INTO meq_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Hərwi ndo mekeleŋ eye hay tə vəl na, abəra ka siye. A gatay mə gər sa bay. Ane tuk na, madakway i ŋgwas nakay mətawak eye na, a vəl ha tebiye, siye andaya sa bay.» ");
INSERT INTO meq_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ahəl nakə Yesu a yaw abəra ma dalamətagay i gay i məɗəslay ha gər a Mbəlom aye na, ndo nəte mə walaŋ i gawla hay a gwaɗatay: «Miter! Zəba ka gay nakay tey. Ma ɗəzliye na, bagwar eye ada kwar neheye ta ɗəzl ha aye na, bagwar eye hay ada tə le haladzay!» ");
INSERT INTO meq_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu a mbəɗay faya a gwaɗay: «Zəba gay nakay na, ka ŋgatumeye a kwar kwa nəte ka gər i kwar ŋgeɗ bay. Ta mbəzliye ha hele hele.» ");
INSERT INTO meq_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ma dəba eye na, Yesu a tsal a mahəmba nakə tə zalay Mahəmba i Tetəɗœz aye. A ye naha na, a ndza ɗəgerger tə gay i məɗəslay ha gər a Mbəlom. A mahəmba niye ti ye na, tage Piyer, Yakuba, Yuhana, ta Aŋdəre tsa bəna ndo hay tebiye bay. Mə mahəmba niye na, ta tsətsah faya tə gwaɗay: ");
INSERT INTO meq_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Tsikamay, wu neheye ta ta giye bo na, kəɗay? Ada ŋgoɗgor waray nakə nəmaa səriye ha na, wu neheye tebiye ta ndisleweye aye?» ");
INSERT INTO meq_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tsa na, a dazlay mətsikatay, a gwaɗatay: «Gum metsehe lele! Ndəray mâ səpat kurom bay. ");
INSERT INTO meq_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Hərwi ndo hay haladzay ta deyeweye ta məzele ga. Kwa way ma gwaɗiye: “Neŋ na, Kəriste!” Ada ta səpatiye ndo hay haladzay. ");
INSERT INTO meq_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ka tsənum ndo hay faya ta giye vəram bəse tə nəkurom kwa neheye dəreŋ tə nəkurom aye na, kâ dzədzarum bay. Wu neheye na, kutoŋ ta ndisleweye. Ane tuk na, niye na, mandəve i məndzibəra zuk bay. ");
INSERT INTO meq_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Slala ŋgeɗ ta giye vəram ta slala neŋgeɗ, bəy ta bəy ta giye vəram. Dala ma ɓəliye ma gəma hay wal wal, ada mandərzlaŋ ma giye. Wu neheye ta giye bo na, andza məwe wawa nakə a dazlay a ŋgwas aye. ");
INSERT INTO meq_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Ɗəretsətseh neheye ta ndzakum a gər na, gumay metsehe a gər lele. Hərwi mey na, hərwi ndo hay ta gəsiye kurom, ta diye kurom ha a gay i sariya. Ta ndaɓiye kurom ta mandalaɓa mə gay i maɗuwule me hay. Ta diye kurom kame i ndo mələve dala hay ada kame i bəy hay, hərwi nakə ka pumeŋ bəzay a neŋ aye. Niye na, ta səriye ha ka pumay bəzay na, a Mbəlom deɗek. ");
INSERT INTO meq_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wu neheye ta giye bo andza niye na, hərwi ada ndo i məndzibəra hay tebiye tâ tsəne Labara Ŋgwalak eye. ");
INSERT INTO meq_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Taɗə ta gəs kurom, ta diye kurom ha kame i ndo məge sariya hay na, kâ dzalum nəmaa ta gwaɗiye kəkay na, kâ dzədzarum bay. Ta ye kurom ha na, tsikum wu nakə a yakumaw a mədzal gər aye. Hərwi ma deyeweye na, abəra mə nəkurom bay. Mata ɗakum ha wu nakə ka tsikumeye na, Məsəfəre Tsəɗaŋŋa eye. ");
INSERT INTO meq_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Həlay eye ma slaweye na, ndo hay ta vəliye ha malamar tay hay ada tâ kəɗ tay ha, bəba hay ta giye ta wawa tay hay andza niye dərmak. Wawa hay ta natay ɗəre a bəba tay hay, ta kəɗiye tay ha. ");
INSERT INTO meq_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ndo hay tebiye ta nakumeye ɗəre hərwi ga. Ane tuk na, ndoweye kə səmay naha hus ka mandəve aye na, Mbəlom ma təmiye ha.» ");
INSERT INTO meq_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesu a gwaɗatay sa: «Ka ŋgatumeye a wuray maga zluwer eye andza mazəlatoŋgo. Wuye niye na, ma ta ndziye ka təv nakə haɓe ma ndziye faya bay aye. (Ndoweye kə dzaŋga na, mâ tsəne lele.) Ndo neheye ka dala i Yahuda aye, ta ŋgatay a wu niye na, tâ hway a mahəmba hay. ");
INSERT INTO meq_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ndo nakə neŋgeye ka gər i gay aye na, mâ mbəzlaw hərwi məzlaw wu mə gay bay. Kə mbəzlaw na, mâ hway ɗuh. ");
INSERT INTO meq_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ada ndo nakə neŋgeye ma guvah aye na, mâ mbəɗa gər a mətagay ŋgay məzlaw petekeɗ ŋgay bay. ");
INSERT INTO meq_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pat eye niye na, ɗəretsətseh wene wene eye na, ka gər i ŋgwas neheye tə bo sulo aye ada ka ŋgwas neheye faya ta vəlateye wah a wawa tay hay aye! ");
INSERT INTO meq_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Gumay amboh a Mbəlom, hərwi ada wu neheye mâ ge bo a həlay i mətasl bay. ");
INSERT INTO meq_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Hərwi mey na, pat eye niye na, ɗəretsətseh bagwar eye. Slala i ɗəretsətseh niye ma ta deyeweye na, kə ge bo ɗaɗa bay kwa ka gər nakə Mbəlom a ge məndzibəra aye hus anəke. Ada slala i ɗəretsətseh niye na, ɗaɗa ma ta giye andaya sa bay. ");
INSERT INTO meq_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Taɗə Mbəlom mâ zla həlay eye bəna, ndəray kwa nəte ma təmiye bay. Ane tuk na, a nəkiɗ ha hərwi ndo ŋgay neheye a pala aye. ");
INSERT INTO meq_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Taɗə ndəray kə gwaɗakum: “Zəbum! Kəriste anaŋ!” kəgəbay “Zəbum! Neŋgeye atay!” na, kâ təmum bazlam ŋgay bay. ");
INSERT INTO meq_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Andza niye, ndo masəpete ndo hay ta deyeweye. Ta gwaɗiye nəteye na, ndo məɗe ha bazlam i Mbəlom, kəgəbay ndo mətəme ha ndo nakə Mbəlom a sləraweye. Nəteye na, ta giye masuwayaŋ hay ada tə wu neheye ma giye hərɓaɓəkka aye hərwi taɗə ma giye bo na, masəpete tay ha ndo neheye Mbəlom a pala aye. ");
INSERT INTO meq_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nəkurom na, gum metsehe lele! Na tsikakum ka bo abəra kurre.» ");
INSERT INTO meq_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Ma dəba i ɗəretsətseh neheye na, pat eye niye na, pat ma giye andaya sa bay ada kiye ma dəviye bay. ");
INSERT INTO meq_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Wurzla hay dərmak ta kutsaweye abəra ka magərmbəlom ada wu neheye gədaŋ eye ka magərmbəlom aye ta ɓəliye haladzay. ");
INSERT INTO meq_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tsa na, ndo hay ta ŋgeteŋeye a neŋ Wawa i Ndo na deyeweye ma pazlay ta gədaŋ haladzay ada ta məzlaɓ eye. ");
INSERT INTO meq_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kwayaŋŋa ma sləraweye gawla i Mbəlom hay, ta hayay gər a ndo neheye a pala tay ha aye abəra ka kokway i məndzibəra tebiye kwa ka waray ka waray ka təv ŋgay.» ");
INSERT INTO meq_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","A gwaɗatay: «Tsənum dzeke i gurov təday. Ka ŋgatumay a gurov ka ɗuɗa na, ka sərum ha gwaduvay kə ge, mazlambar yam ma piye bəɗaw? ");
INSERT INTO meq_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Andza niye ahəl nakə ka ŋgatumay a wu neheye ta ndislew na, sərum ha neŋ Wawa i Ndo mazlambar na deyeweye, neŋ ka məgeɗ. ");
INSERT INTO meq_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Neŋ faya na gwaɗakumeye: Sərum ha na, wu nakay tebiye ma giye bo na, ndo neheye anəke aye ta mət zuk bay. ");
INSERT INTO meq_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Magərmbəlom ta dala ta dziye, bazlam ga na, ɗaɗa ma dziye bay.» ");
INSERT INTO meq_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Ma deyeweye pat waray na, ndəray kwa nəte a sər bay. Ada ma deyeweye ahəl waray na, ndəray a sər həlay eye bay sa. Kwa gawla i Mbəlom hay mə mbəlom, kwa neŋ wawa ŋgay bəbay, nəmaa sər bay. Maa sər pat eye na, Mbəlom Bəba ga nəte ŋgweŋ. ");
INSERT INTO meq_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Gum metsehe bəna, kâ dzədzarum bay, hərwi ka sərum ma deyeweye kəɗay na, ka sərum həlay eye bay. ");
INSERT INTO meq_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ma deyeweye na, andza ndo i gay nakə a say mede a tsekene aye. A ye na, a gəratay ha gay ŋgay a ndo i məsler ŋgay hay ada tâ gay gər a bəɗgay ŋgay lele. A vəl məsler kwa a way. A ndo matsəpe məgeɗ na, a gwaɗay: “Tsəpa na lele, kâ ndzahəra bay.” ");
INSERT INTO meq_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nəkurom dərmak andza niye. Ndzum na, tsezlezleŋŋe, hərwi ka sərum ndo i gay ma deyeweye ta huwa, agəna ta magərhəvaɗ, agəna ta mbəlom ɗa, agəna ta mekedœ, ndəray a sər bay. ");
INSERT INTO meq_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Agəna ma deyeweye həf na, ma ndzakum a gər nəkurom mandzahəra eye bay. ");
INSERT INTO meq_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Wu nakə faya na tsikakumeye na, na tsikateye a ndo hay tebiye. Na gwaɗateye: Kâ ndzahərum bay! Ndzum tsezlezleŋŋe!» ");
INSERT INTO meq_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A zəkaw məhəne sulo nakə Yahuda hay ta hatsiye magurlom i Pak ada ta mənde wu mənday nakə tə zalay peŋ aye na, gəɗe faya bay. Ahəl niye na, bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye faya ta pəliye tsəveɗ ka məgəse Yesu ta məkal hərwi ada tâ kəɗ na. ");
INSERT INTO meq_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tə gwaɗ mə walaŋ tay: «Kâ gəsakwa na tə magurlom nakay bay bəna, ndo hay ta gəriye kway ha bay.» ");
INSERT INTO meq_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ahəl niye na, Yesu ma gəma i Betani, mə gay i ndo wuray tə zalay Simoŋ. Ndoweye niye a ndzawa na, ɗəvats i madəgweɗe a gaway. Ahəl nakə faya ta ndiye wu mənday aye na, ŋgwas wuray a ye a fələkwa ka təv tay dos ŋgay mə həlay maraha eye tə mal nakə a ze huŋŋa aye. Mal niye na, tsakala eye haladzay. A ye naha na, a həɓ ha me i dos niye məɗakw. Tsa na, a mbəɗa mal niye ka gər i Yesu. ");
INSERT INTO meq_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ndo neheye ka təv i Yesu aye na, siye hay a ndalatay haladzay. Tə gwaɗ mə walaŋ tay: «Asah! Ŋgwas nakay a nas ha mal nakay na, kemey? ");
INSERT INTO meq_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ta səkəm ha na, ta hutiye dala haladzay segey? Ada dala aye na, ta sliye məvəlatay a ndo i mətawak hay bəɗaw!» Tə may ha mənese haladzay a ŋgwas niye. ");
INSERT INTO meq_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesu a gwaɗatay: «Ɗuh bay, gərum ha ŋgwas nakay na, səfek. Ka kwasumeye gər a ŋgwas nakay na, hərwi mey? Wu nakə a ge hərwi ga aye na, lele haladzay. ");
INSERT INTO meq_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ndo i mətawak hay na, nəteye ka təv kurom huya. Kə sakum məgatay ŋgwalak a mətawak hay na, ka mbumeye faya məgatay kwa kəɗay. Ane tuk na, neŋ na, na ndziye tə nəkurom huya bay. ");
INSERT INTO meq_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ŋgwas nakay a geŋ na, wu nakə gədaŋ ŋgay a mba faya məge aye. Neŋgeye na, kə lah mambəɗe ka bo ga mal nakə haɓe ta giye fagaya pat nakə ta piye ga a bəɗ aye. ");
INSERT INTO meq_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Neŋ faya na gwaɗakumeye, sərum ha: Kwa a ŋgay ta ɗiye ha Labara Ŋgwalak eye ka məndzibəra tebiye na, ta tsikiye ka ŋgwas nakay hərwi wu nakə a ge aye. Ndo hay ta mətsiye ha gər bay.» ");
INSERT INTO meq_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ndo nəte mə walaŋ i gawla i Yesu niye hay kuro gər eye sulo aye, a ye ka təv i bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye. Məzele ŋgay na, Yudas Iskariyot. A ye hərwi a say məge ɗaf ka Yesu. ");
INSERT INTO meq_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye tə tsəne labara nakə a tsikatay aye na, a yatay a gər haladzay. Tsa na, tə gwaɗay: «Nəmaa vəlakeye dala.» Yudas a maw abəra ka təv tay na, a yaw a pəla wewer ada həlay nakə lele eye hərwi məge ɗaf ka Yesu aye. ");
INSERT INTO meq_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pat makurre i magurlom nakə tə ndayawa wu mənday nakə gəɗe faya bay aye na, tə kəɗawa təɓaŋ hərwi məde wu mənday i Pak. Pat eye niye na, gawla i Yesu hay ta tsətsah, tə gwaɗay a Yesu: «A saka nəmaâ ye mata daka ɗaf i magurlom i Pak na, ka waray?» ");
INSERT INTO meq_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesu a tsəne andza niye na, a slər gawla ŋgay hay sulo ka me, a gwaɗatay: «Dum a wuzlahgəma! Ka yum naha na, ka ndzumeye a gər a ndo faya ma zliye yam ta gəzla eye. Ka ŋgatumay na, pumay bəzay. ");
INSERT INTO meq_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Gay nakə ma fələkwiye a ɗəma aye na, fələkum dərmak ada kâ tsətsahum ka ndo i gay niye, gwaɗumay: “Miter a gwaɗaka: Gay nakə nəmaa ndiye mə ɗəma wu mənday i magurlom i Pak ta gawla ga hay aye na, məŋgay?” ");
INSERT INTO meq_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ka tsətsahum andza niye na, ma ɗakumeye faya ka gay nakə ka gər i gay neŋgeɗ aye. Huɗ i gay niye na, bagwar eye. Wu hay mə ɗəma maləva bo eye tsɨy. Wu neheye ka gakweye ha məsler aye tebiye andaya mə ɗəma. Ka dumeye wu mənday i magurlom i Pak na, mə ɗəma.» ");
INSERT INTO meq_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Gawla ŋgay niye hay sulo aye tə lətse, ti ye a wuzlahgəma. Ti ye naha na, tə ndzay a gər andza nakə Yesu a tsikatay aye. Tsa na, tə da wu mənday i Pak mə ɗəma. ");
INSERT INTO meq_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Huwa a ge na, Yesu ta gawla ŋgay hay kuro gər eye sulo, ti ye a gay niye tuk. ");
INSERT INTO meq_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ahəl nakə faya ta ndiye wu mənday aye na, Yesu a gwaɗatay: «Neŋ faya na gwaɗakumeye: Sərum ha na, ndo nəte mə walaŋ kway nakay ka ndayakweye wu mənday dziye na, ma giye fagaya ɗaf.» ");
INSERT INTO meq_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Gawla ŋgay hay tə tsəne andza niye na, a ndalatay. Tsa na, kwa way a tsətsah faya, tə gwaɗay: «Neŋ ɗaw? Neŋ ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu a mbəɗatay faya a gwaɗatay: «Ndo nəte mə walaŋ kurom neheye kuro gər eye sulo aye. Mata ge fagaya ɗaf na, ndo nakə faya ka ndayakweye wu mənday dziye aye. ");
INSERT INTO meq_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Neŋ Wawa i Ndo na mətiye andza nakə Ɗerewel i Mbəlom a tsik aye. Ane tuk na, ɗəretsətseh ka gər i ndo nakə ma giye ɗaf ka neŋ Wawa i Ndo aye. Ndo niye na, ŋgama meeneŋ tâ wa na bay.» ");
INSERT INTO meq_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ahəl nakə faya ta ndiye ɗaf aye na, Yesu a zla peŋ, a gay naha sɨsœ a Mbəlom. Ma dəba eye na, a ŋgəna ha peŋ niye, a vəlatay a gawla ŋgay hay, a gwaɗatay: «Zlum. Nakay na, bo ga.» ");
INSERT INTO meq_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","A zla gəvet maraha eye tə wu məse, a gay naha sɨsœ a Mbəlom. Ma dəba eye a vəlatay tə sa tebiye tay eye. ");
INSERT INTO meq_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu a gwaɗatay sa: «Nakay na, bambaz ga nakə Mbəlom ma ɓariye dzam ta ndo hay aye. Ta mbəɗiye ha na, hərwi ndo hay haladzay. ");
INSERT INTO meq_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Neŋ faya na tsikakumeye, na ta siye wu məse nakay sa bay hus a pat nakə na ta siye weɗeye ma Bəy i Mbəlom aye.» ");
INSERT INTO meq_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ma dəba eye, ta zambaɗay a Mbəlom ta dəmes na, ti ye tə tsal a Mahəmba i Tetəɗœz. ");
INSERT INTO meq_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ahəl nakə faya ta diye ka tsəveɗ aye na, Yesu a gwaɗatay a gawla ŋgay hay: «Nəkurom neheye tebiye ka gərumeye ga ha, ka hwayumeye kurom. Mawatsa eye mə bazlam i Mbəlom na: “Na ta kəɗiye na ndo mətsəkure tay ada təɓaŋ hay ta ŋgəniye gər kweye kweye kwa a ŋgay.”» ");
INSERT INTO meq_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yesu a gwaɗatay sa: «Ane tuk na, na mbəlaw abəra ma mədahaŋ na, na həbiye kurom ma Galile.» ");
INSERT INTO meq_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piyer neŋgeye na, a gwaɗay: «Kwa siye i ndo hay ta gər kar ha na, neŋ na, na gəriye kar ha bay.» ");
INSERT INTO meq_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tsa na, Yesu a mbəɗay faya a Piyer a gwaɗay: «Neŋ faya na gwaɗakeye: Sər ha na, bəgom ta həvaɗ nakay, dzagulok ma ta zlahiye sik sulo na, ɓa ka gwaɗ sik mahkar ka sər neŋ bay.» ");
INSERT INTO meq_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piyer a mbəɗay faya sa: «Na sər kar bay na, na tsikiye ɗaɗa bay, kwa taɗə ka mətameye ka bo salamay.» Siye i gawla ŋgay hay tebiye tə tsik andza niye dərmak. ");
INSERT INTO meq_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tsa na, tə ndisl a təv wuray tə zalay Getsemene. Tə ndisl naha na, Yesu a gwaɗatay a gawla ŋgay hay: «Ndzum kanaŋ! Neŋ na, na diye na ta ɗuwuliye me.» ");
INSERT INTO meq_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yesu a ye na, nəteye ti ye dziye tage Piyer, Yakuba ada Yuhana. Tə ndisl naha na, ɗərev a ye abəra ka Yesu, a dzədzar haladzay. ");
INSERT INTO meq_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","A gwaɗatay: «Ɗərev ga na, kə rah tə ɗəretsətseh i mədahaŋ. Nəkurom na, ndzum kanaŋ tsezlezleŋŋe!» ");
INSERT INTO meq_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","A ye izaɗ abəra ka təv i gawla ŋgay neheye mahkar aye. A ye naha na, a kal bo ka dala bərut tə huɗ. A ɗuwulay naha me a Mbəlom a gwaɗ: «Taɗə ma giye bo na, həlay i ɗəretsətseh nakay mâ ye fagaya abəra vuw tey.» ");
INSERT INTO meq_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","A gwaɗ: «Abba, Bəba ga, nəkar na, wuray a wuraka bo təbey. Zla fagaya abəra ɗəretsətseh nakay na siye tey. Kwa mey na, andza nakə a saka a nəkar aye bəna, andza nakə a seŋ a neŋ aye bay.» ");
INSERT INTO meq_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ma dəba eye, a maw ka təv i gawla ŋgay neheye mahkar aye. A maw a ndzatay a gər na, nəteye mandzahəra eye. Tsa na, a zalay a Piyer a gwaɗay: «Simoŋ, ka ndzahəra ɗaw? Nəkar na, ka mba faya məndze tə ɗəre kwa ɓəre nəte təbəɗew? ");
INSERT INTO meq_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ndzum tə ɗəre tsezlezleŋŋe ada ɗuwulumay me a Mbəlom hərwi ada kâ dəɗum a masəpete i Fakalaw bay. Məsəfəre na, a say məge wu lele eye, ane tuk na, gədaŋ kurom andaya məsəmay naha a masəpete i Fakalaw bay.» ");
INSERT INTO meq_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yesu a ndəv ha na, a ye abəra ka təv tay izaɗ sa. A ye mata ɗuwule me. A ye naha a tsik na, bazlam ŋgay neheye a tsik kurre aye. ");
INSERT INTO meq_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tsa na, a maw ka təv i gawla ŋgay neheye sa. A ndzatay a gər na, nəteye mandzahəra eye. Tə mba faya məndze tə ɗəre kwa tsekweŋ bay tebiye. Ta pəɗeke abəra ka məndzehəre na, tə sər wu nakə ta tsikiye bay. Yesu a ye mata ɗuwule me sa. ");
INSERT INTO meq_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A maw mamahkar eye na, a gwaɗatay: «Huya faya ka ndzahərumeye ɗaw? Nəkurom faya ka zəzəkumeye bo kurom ba? Anəke na, ka ndəv tsɨy, həlay eye kə ndislew tuk! Neŋ Wawa i Ndo ta vəlay ga ha a həlay i ndo i mezeleme hay tuk. ");
INSERT INTO meq_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Lətsum, takwa, ta dzakwa gər! Zəbum, ndo nakə ma giye fagaya ɗaf aye, kə ndzew.» ");
INSERT INTO meq_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ahəl nakə Yesu faya ma tsikiye me mba aye na, pəslaŋ Yudas neŋgeye nakə nəte mə walaŋ i gawla i Yesu hay kuro gər eye sulo aye, a ye naha. Ti ye naha ta ndo hay haladzay ta maslalam tay hay ada ta sakwal tay hay. Maa slər tay naha na, bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye ada ta madugula hay. ");
INSERT INTO meq_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas ndo məgatay ɗaf ka Yesu aye ɓa kə ɗatay ha wu nakə ma giye. A gwaɗatay: «Ndo nakə na ye, na gəs na ka bo təmbolok təmbolok aye na, neŋgeye! Gəsum na. Ka deyumeye ha na, tsəpum na lele.» ");
INSERT INTO meq_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yudas a ndisl naha na, a həndzəɗ kwayaŋŋa ka təv i Yesu, a gwaɗay: «Miter!» Tsa na, a gəs na ka bo təmbolok təmbolok. ");
INSERT INTO meq_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ndo niye hay tə ŋgatay andza niye na, kwayaŋŋa tə gəs na Yesu. ");
INSERT INTO meq_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ka təv niye ndo nəte mə walaŋ tay, pəkat a ŋgwaɗaw maslalam ŋgay. Tsa na, a fay ha a ndo i məsler i bagwar i ndo məvəlaway wu a Mbəlom, a ɗəsay na zləm fats ka dala. ");
INSERT INTO meq_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu a gwaɗatay: «Ka yumaw fagaya ta maslalam kurom hay ada ta sakwal kurom andza ta gəsiye ndo i məkal ɗaw? ");
INSERT INTO meq_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Pat pat na ndzawa ka təv kurom. Na tətikawa mə gay i məɗəslay ha gər a Mbəlom na, ka gəsum ga bay. Wu neheye a ge bo na, hərwi ada mâ ge bo andza nakə Ɗerewel i Mbəlom a tsik aye.» ");
INSERT INTO meq_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tə gəs na Yesu na, gawla ŋgay hay ta hway kweye kweye tə gər ha. ");
INSERT INTO meq_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Faya ta diye ha Yesu na, ndo wuray gawla aye a zəŋgal na Yesu. Ka bo ŋgay na, gwedere tsa. Ndo neheye faya ta diye ha Yesu aye tə ge andza ta gəsiye na gawla niye na, ");
INSERT INTO meq_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","a gər ha gwedere ŋgay ŋguɗek, a hway ŋgway bo kəriye. ");
INSERT INTO meq_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ti ye ha Yesu na, a gay i bagwar i ndo məvəlaway wu a Mbəlom aye. Mə ɗəma na, bagwar hay i ndo neheye tə vəlaway wu a Mbəlom tebiye, madugula hay ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye tebiye nəteye mahaya gər eye. ");
INSERT INTO meq_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyer neŋgeye na, a zəŋgal naha Yesu dəreŋ ma dəba. A ye naha a fələkwa a dalamətagay i bagwar i ndo məvəlaway wu a Mbəlom niye. Mə ɗəma na, a ndza ka təv i ndo niye hay faya ta tsəpiye məgeɗ aye. A ye naha a ndza ka ako ka təv tay niye. ");
INSERT INTO meq_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta madugula i Yahuda hay tebiye ta pəla ndo hay hərwi maraw faya me hərwi məgay sariya i məkəɗe na. Ane tuk na, ta huta faya mənese bay. ");
INSERT INTO meq_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ndo hay haladzay ta raw faya me. Ane tuk na, maraw me tay niye ki ye tay faya bay. Kwa way a tsik i ŋgay wal. ");
INSERT INTO meq_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Siye i ndo mekeleŋ aye hay tə lətse, ta raw me ka Yesu, tə gwaɗ: ");
INSERT INTO meq_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Nəmaa tsəne faya abəra a gwaɗ: “Na mbəzliye ha gay i məɗəslay ha gər a Mbəlom nakay ndo hay ta ɗəzl eye ada ma məhəne mahkar na, na ɗəzliye a ɗəma mekeleŋ nakə tə həlay i ndo zezeŋ bay aye.”» ");
INSERT INTO meq_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kwa tə tsik andza niye bəbay na, huya bazlam tay niye ki ye tay ka bo bay. ");
INSERT INTO meq_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tsa na, bagwar i ndo məvəlaway wu a Mbəlom a lətse tsəkwaɗ kame i ndo hay. A tsətsah ka Yesu, a gwaɗay: «Ka mbəɗatay faya a ndo neheye təbəɗew? Tə tsik fakaya na, mey?» ");
INSERT INTO meq_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ka bazlam tay niye na, Yesu ka mbəɗatay faya bay. Kə tsikatay faya kwa tsekweŋ bay tebiye. Bagwar i ndo məvəlaway wu a Mbəlom niye a tsətsah faya sa: «Nəkar na, Kəriste Wawa i Mbəlom nakə nəmay faya nəmaa zambaɗeye ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu a mbəɗay faya a gwaɗay: «Neŋ na, neŋgeye. Ma dazlay anəke, ka ŋgatumeŋeye a neŋ Wawa i Ndo na ndziye tə həlay i mənday i Mbəlom, neŋgeye nakə gədaŋ eye ka gər i wu hay tebiye aye. Ka ŋgatumeŋeye sa na, ma magərmbəlom na deyeweye ma pazlay.» ");
INSERT INTO meq_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Bagwar i ndo məvəlaway wu a Mbəlom a tsəne andza niye na, a ndalay haladzay. A ŋguraɗa ha petekeɗ ŋgay. Tsa na, a gwaɗ: «Ka pəlakweye na, sa mey? ");
INSERT INTO meq_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ka tsənum wu nakə a tsik aye bəɗaw? A tsalay ka gər a Mbəlom. Niye na, ka dzalum na, kəkay?» Ndo niye hay tebiye tə gay sariya i məkəɗe na. ");
INSERT INTO meq_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kwayaŋŋa siye i ndo mekeleŋ eye hay tə wuya faya kurah. Ta tufay slesleɓ a ɗəre. Tə mbuzay na ɗəre ada tə kəɗ na. Tə gwaɗay: «Nəkar ndo məɗe ha bazlam i Mbəlom ba! Tsikamay, maa faka na, way?» Tsa na, tə vəlatay ha a həlay a ndo matsəpe gay i bəy i ndo məvəlaway a Mbəlom. Nəteye tə gəs na ada tə fay ka maholom pura pura. ");
INSERT INTO meq_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piyer na, neŋgeye andaya huya ma dalamətagay ka dala. Ŋgwas nakə a gawa məsler mə gay i bagwar i ndo məvəlaway wu a Mbəlom aye, a ye naha a ndzay a gər a Piyer. ");
INSERT INTO meq_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","A ŋgatay a Piyer mandza eye ka ako. A zəba faya ndzuzle, a gwaɗay: «Nəkar dərmak na, ndo i Yesu, ndo i Nazaret na gwaɗ bəɗa?» ");
INSERT INTO meq_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piyer a tsəne na, a gwaɗay a ŋgwas niye: «Aʼay! Na sər wu nakə a saka mətsike aye bay. Na sər bay tebiye.» Tsa na Piyer a ye abəra ma dalamətagay. A ye a lətse sləp ka həlay i məgeɗ madayaw abəra. Kwayaŋŋa dzagulok a zlaha. ");
INSERT INTO meq_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Piyer a ye a ndza sləp ka həlay i məgeɗ na, ŋgwas niye kə ŋgatay naha. Tsa na, a masay ha slala i bazlam ŋgay nakə a tsikay a Piyer kame i ndo neheye mə ɗəma aye. «Ndo nakay na, nəte mə walaŋ tay.» ");
INSERT INTO meq_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piyer a tsəne na, a gwaɗ: «Na sər ndo niye bay.» Məndze tsekweŋ na, ndo neheye ka təv eye niye tə gwaɗay sa: «Nəkar na, mə walaŋ tay, nəkurom dziye. Nəkar na, ndo i Galile!» ");
INSERT INTO meq_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Piyer a mbaɗa a gwaɗ: «Na sər ndo nakə ka tsikum faya aye bay. Kə ge na raw me na, Mbəlom mâ geŋ ɗəretsətseh.» ");
INSERT INTO meq_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kwayaŋŋa dzagulok a zlaha masulo aye. Tsa na, bazlam i Yesu nakə a tsik aye a mayaw a gər a Piyer tuk. Yesu a gwaɗay: «Dzagulok ma ta zlahiye sik sulo na, ɓa ka gwaɗ sik mahkar ka sər neŋ bay.» Piyer a dzala ha ka bazlam i Yesu nakə a tsikay aye na, a hwayaw abəra. A ye a tuwa tsɨɗuk tsɨɗuk. ");
INSERT INTO meq_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pərik i mekedœ, bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta madugula hay ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye ada ta madugula hay tebiye, tə haya gər. Tə haya gər na, hərwi mətsike mə walaŋ tay məge ha Yesu na, kəkay? Ta ndəv ha məhay gər na, tə dzawa na Yesu ada ti ye ha a gay i Pilat. Ti ye naha na, tə vəlay ha a Pilat. ");
INSERT INTO meq_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat, neŋgeye na, a tsətsah ka Yesu, a gwaɗay: «Nəkar na, bəy i Yahuda hay deɗek ɗaw?» Yesu a mbəɗay faya, a gwaɗay: «Nəkar ka tsik segey.» ");
INSERT INTO meq_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye tə ɗəs parasay haladzay ka Yesu. ");
INSERT INTO meq_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ma dəba eye na, Pilat a tsətsah faya sa, a gwaɗay: «Nəkar na, ka mbəɗa faya bay na, kəkay? Ka tsəne wu neheye faya ta tsikiye fakaya haladzay aye təbəɗew!» ");
INSERT INTO meq_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ada kwa Yesu ka həndək bazlam ndœ mambəɗay faya sa bay tebiye. Tsa na, a gay wadəŋ wadəŋ a Pilat. ");
INSERT INTO meq_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ka məve, ta giye magurlom nakə tə zalay Pak aye na, Pilat a gərawa ha ndo i daŋgay nəte. A gər ha na, ndo nakə ta tsətsahawa aye. ");
INSERT INTO meq_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Azlakwa ahəl niye na, ndoweye andaya tə zalay Barabas, neŋgeye ma daŋgay. Neŋgeye mə walaŋ i ndo neheye tə nay ɗəre a bəy i dala i hay aye. Tə gəs tay na, hərwi tə kəɗ ndo ahəl i magazləga tay niye. ");
INSERT INTO meq_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Anəke na, ndo hay tebiye ti ye a gay i Pilat. Ti ye naha a ɗəma na, kwa way a tsətsah ka Pilat wu nakə a təmawatay na andza nakə ta tsətsahawa aye. ");
INSERT INTO meq_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Tsa na, Pilat a mbəɗatay faya a gwaɗatay: «A sakum nâ gərakum ha na, bəy i Yahuda hay ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilat a sər ha bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye tə gəsay naha Yesu na, tə ge faya na, sələk kəriye. ");
INSERT INTO meq_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye, nəteye ɗuh na, tə vəlatay gədaŋ a ndo hay ada məgwaɗay a Pilat mâ gəratay ha na, Barabas bəna, Yesu bay. ");
INSERT INTO meq_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilat a gwaɗatay a ndo hay sa: «A sakum nâ ge ha ta ndo nakay ka zalumay bəy i Yahuda hay aye na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tsa na, ndo hay ta mbəɗay faya tə mawude, tə gwaɗay: «Dar na ka mayako mazləlmbaɗa eye!» ");
INSERT INTO meq_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat a tsətsah fataya, a gwaɗatay: «Neŋgeye a ge na, mənese waray?» Ane tuk na, ta səkah ha mawude haladzay ta gədaŋ, tə gwaɗ: «Dar na ka mayako mazləlmbaɗa eye!» ");
INSERT INTO meq_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilat a say məŋgwasatay ha ɗərev a ndo niye hay. Andza niye a gəratay ha Barabas. Yesu na, a ndaɓa na ta mandalaɓa, a vəlatay ha a sidzew hay hərwi ada tâ ye tâ dar na ka mayako mazləlmbaɗa eye. ");
INSERT INTO meq_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sidzew hay ti ye ha Yesu a huɗ i gay i ŋgomna ada tə zalatay a siye i sidzew hay tebiye, ti ye dərmak. ");
INSERT INTO meq_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Mə ɗəma na, ta tsəkw faya abəra petekeɗ ŋgay hay. Tə zla petekeɗ ndozza eye, tə kalay ka bo. Tə ɗəsaw dak tə slapa na ka bo, tə pay a gər a Yesu andza dzagwa i bəy. ");
INSERT INTO meq_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tsa na, ta dazlay mətsikay me. Tə gwaɗay: «Zay ɗaw? A nəkar bəy i Yahuda hay!» ");
INSERT INTO meq_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tə tsikay andza niye na, ada tə fay ka gər ta sakwal. Ta tufay slesleɓ a ɗəre. Ta dəkway gurmets kame ŋgay hərwi mətsikay me andza bəy. ");
INSERT INTO meq_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ta ndəv ha məŋgwese faya na, ta tsəkw faya abəra petekeɗ nakə tə kalay ka bo ndozza aye ada tə may ha ka bo petekeɗ ŋgay hay. Tsa na, tə gəs ahaya abəra hərwi mede ha mata dar na ka mayako mazləlmbaɗa eye. ");
INSERT INTO meq_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ahəl nakə faya ta diye ha Yesu mata dar na ka mayako mazləlmbaɗa eye na, pəslaŋ ndo wuray məzele ŋgay Simoŋ. Neŋgeye na, ndo i Siren, neŋgeye bəba i Aləgəzandər ta Rufus. Neŋgeye faya ma diye ta təv niye. Neŋgeye a maw abəra mə pesl. Sidzew hay tə ŋgatay na, tə gay kutoŋ ka məzle mayako mazləlmbaɗa eye nakə ta dariye faya Yesu aye. ");
INSERT INTO meq_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tsa na, ti ye ha Yesu a təv eye andaya tə zalay Golgwata, andza məgweɗe: Təv i mətasl i gər. ");
INSERT INTO meq_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tə ndisl naha a ɗəma na, a satay a sidzew niye hay məvəlay guzom madzapa eye tə wuye andaya tə zalay mir. Ane tuk na, a say a Yesu bay, a kərah məse. ");
INSERT INTO meq_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma dəba eye na, ta dar na Yesu ka mayako mazləlmbaɗa eye. Ta dar na na, tə ge tsakwal ka petekeɗ ŋgay hay. Tə ge andza niye na, məsəre ha mata zle na, way? ");
INSERT INTO meq_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ta dar na Yesu ka mayako mazləlmbaɗa eye na, ta mekedœ ta ɓəre tsɨɗ. ");
INSERT INTO meq_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tə watsa ka palalam eye andaya gər i bazlam nakə tə kəɗ na faya Yesu aye. Gər i bazlam nakə tə watsa aye na, anaŋ: «Neŋgeye na, bəy i Yahuda hay.» ");
INSERT INTO meq_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pat niye na, ta dar məkal hay sulo ka mayako mazləlmbaɗa eye ka tsakay i Yesu dərmak. Ta dar tay na, nəte tə həlay i mənday, neŋgeɗ tə həlay i gula.  ");
INSERT INTO meq_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Anaŋ andza nakay wu nakə bazlam i Mbəlom a tsik aye na, a gwaɗ: «Neŋgeye na, tə pasla na a walaŋ i ndo i seweɗ hay.» ");
INSERT INTO meq_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ndo neheye ti yawa ta təv niye na, tə ɓəlawa ha gər tay hay tekəm tekəm tə mətsaɗay pəleslesle. Tə gwaɗay: «Hey! Nəkar haɓe a saka mambəzl ha gay i məɗəslay ha gər a Mbəlom ada ka gwaɗ ma məhəne mahkar na, ka ɗəzl na aye na, təv i wu yak aye na, məŋgay tuk? ");
INSERT INTO meq_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nəkar təma ha bo yak aye tey! Mbəzlaw abəra ka mayako nakay mazləlmbaɗa eye!» ");
INSERT INTO meq_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye a ndo hay tə ŋgwasa ka Yesu andza niye dərmak. Tə tsik mə walaŋ tay, tə gwaɗ: «Kə təma tay ha siye i ndo hay tuk na, a sla faya mətəme ha gər ŋgay təbəɗew? ");
INSERT INTO meq_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kəriste, Bəy i Israyel hay mâ mbəzlaw abəra ka mayako mazləlmbaɗa eye anəke! Taɗə nəmaa ŋgatay kə mbəzlaw abəra ka mayako mazləlmbaɗa eye na, nəmay nəmaa dzaliye ha ka neŋgeye.» Ndo neheye ta dar tay ka tsakay i Yesu aye tə tsaɗa na Yesu dərmak. ");
INSERT INTO meq_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Magərhəpat a ge na, ləvoŋ a ge ka dala niye tebiye tekəɗəgəm. A ge na, hus a ɓəre mahkar i huwa. ");
INSERT INTO meq_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ta ɓəre mahkar eye niye na, Yesu a wuda ta magala kələrra, a gwaɗ: «Eluya, Eluya, lama sabaktani?» Andza məgweɗe: «Mbəlom ga, Mbəlom ga, ka gər ga na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Siye i ndo neheye ka təv aye niye tə tsəne na, tə gwaɗ: «Pum zləm təday, faya ma zaleye a Eliya!» ");
INSERT INTO meq_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tsa na, ndo nəte mə walaŋ tay niye, a hway, a ye a zlaw wuye kofkoffa. A tələka ha a wuye andaya guyakaka, wu niye a rah a ɗəma. Tsa na, a hak na ka gwavəkw zəbol eye, a pay naha ka bazlam a Yesu ada mâ ɗəvətse abəra mə ɗəma wu niye. Ndoweye niye a gwaɗ: «Ŋgatay, zəbakwa faya təday, aza Eliya ma deyeweye mambəzla ahaya ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ane tuk na, Yesu a wuda ta magala kələrra. Tsa na, a mət. ");
INSERT INTO meq_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","A mət na, kwayaŋŋa petekeɗ nakə a ŋgəna ha gay i məɗəslay ha gər a Mbəlom sulo aye, a ta ka bo bəra sulo tsaŋŋa kwa abəra mə gəma hus ka dala. ");
INSERT INTO meq_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Bagwar i sidzew i Roma hay, neŋgeye andaya malətsa eye kame i Yesu, Yesu a mət ma kəkay na, a ŋgatay. Tsa na, a gwaɗ: «Ta deɗek, ndo nakay na, Wawa i Mbəlom!» ");
INSERT INTO meq_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ŋgwas wuray hay andaya ka təv eye niye dərmak. Nəteye dəreŋ faya ta zəbiye naha faya. Mə walaŋ tay niye andaya na, Mari nakə a yaw ma gəma i Magədala aye, Salome ada ta Mari may i Yakuba nakə gawla aye, may tay ta Zozes. ");
INSERT INTO meq_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nəteye na, ta zəŋgalawa na Yesu ada tə gaway məsler ahəl nakə Yesu, neŋgeye ka dala i Galile aye. Ka təv eye niye na, siye i ŋgwas hay andaya haladzay. Nəteye, tə yaw ka bo dziye tage Yesu abəra ma Zerozelem. ");
INSERT INTO meq_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Huwa ɓa ka mbərəm məge tsɨy. Pat eye niye na, pat mələve bo i Yahuda hay, andza məgweɗe pat məhəne mə gay i pat i mazəzukw bo. ");
INSERT INTO meq_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ta huwa eye niye na, ndo wuray tə zalay Yusufa a yaw. Neŋgeye ndo i gəma i Arimate. Yusufa na, neŋgeye nəte mə walaŋ i bagwar i ndo məge sariya dərmak. Neŋgeye dərmak faya ma həbiye Bəy i Mbəlom. A gəs ɗərev ka dzədzar bay, a ye a gay i Pilat mata tsətsahaw mədahaŋ i Yesu. ");
INSERT INTO meq_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat a tsəne ɓa Yesu kə mət na, a gay wadəŋ wadəŋ. Tsa na, a zalay a bagwar i sidzew niye. A tsətsah faya abəra, a gwaɗay: «Yesu a mət na, kə ndza haladzay ɗaw?» ");
INSERT INTO meq_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ma dəba eye bagwar i sidzew niye a mbəɗay faya na, tsa na, a vəlay tsəveɗ a Yusufa ka məzle mədahaŋ i Yesu. ");
INSERT INTO meq_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufa a ye a səkəmaw rəkwat. A səkəmaw na, a maw a mbəzla ahaya mədahaŋ i Yesu abəra ka mayako mazləlmbaɗa eye. Tsa na, a mbəkwa na mədahaŋ a ɗəma. A zla na a ye, a pa na a tsəvay. Tsəvay niye na, tə la ka geseh ka təv nakə sərpalahha aye. A pa na a ɗəma na, a bədəŋgwalaw faya beber bagwar eye ka madərəzl na tsəvay niye. ");
INSERT INTO meq_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari i Magədala ta Mari may i Zozes na, faya ta zəbiye ka təv nakə tə pa na Yesu aye. ");
INSERT INTO meq_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pat i mazəzukw bo a ye abəra mə ɗəma na, Mari i Magədala, Mari may i Yakuba ta Salome, ti ye ta səkəm mal huŋŋa eye, hərwi a satay məwetse ka mədahaŋ i Yesu. ");
INSERT INTO meq_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pat i luma i sidzew i mekedœ ŋgwas neheye ti ye ka me tsəvay. Tə husa na, pat faya ma tsaraweye tərɗassa. ");
INSERT INTO meq_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ahəl nakə faya ta diye na, ta tsətsah ka bo mə walaŋ tay, tə gwaɗ: «Mata bədəŋgwalakway na beber abəra ka me i tsəvay na, way?» ");
INSERT INTO meq_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tə ndisl naha na, ta zəba ɗəre. Ta zəba ɗəre na, tə ŋgatay a beber niye bagwar eye ta dərəzl ha ka tsəvay aye na, ɓa mabədəŋgwala eye faya abəra, madzaka eye ka tsakay tsɨy. ");
INSERT INTO meq_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ti ye naha na, tə fələkwa a tsəvay niye. Ti ye na tə ŋgatay a ndo gawla aye. Neŋgeye mandza eye ta diye i həlay i mənday. Ndoweye niye na, tə petekeɗ kweɗek kweɗek eye ka bo. Petekeɗ eye niye faya na, zəbol eye təzl. Ŋgwas niye hay tə ŋgatay andza niye ta dzədzar slaɓ slaɓ. ");
INSERT INTO meq_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ane tuk na, a gwaɗatay: «Kâ dzədzarum bay. Faya ka pəlumeye na, Yesu ndo i Nazaret, neŋgeye nakə ta dar na ka mayako mazləlmbaɗa eye. Neŋgeye andaya kanaŋ bay, kə mbəlaw abəra ma mədahaŋ. Ehey! Zəbum, təv nakə tə həna ha faya aye na, anaŋ. ");
INSERT INTO meq_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Dum anəke ta tsikumatay faya a gawla ŋgay hay ada kâ ɗumay ha a Piyer lele. Gwaɗumatay na, ma lahakumeye a Galile. Ka ŋgatumeye mə ɗəma andza nakə a tsikakum eye.» ");
INSERT INTO meq_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tə tsəne andza niye na, tə ndohwaw abəra na, ta hway dəreŋ abəra ka təv i tsəvay niye. Ta hway na, hərwi zluwer a gatay, faya ta dzədzariye. Ta təkəray a ndəray kwa tsekweŋ bay tebiye hərwi zluwer a gatay. ");
INSERT INTO meq_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Pat i luma i sidzew pərik i mekedœ na, Yesu a lətsew abəra ma mədahaŋ. A lətsew na, a bəzay ha bo kurre a Mari nakə a yaw abəra ma Magədala aye. Neŋgeye na, ŋgwas nakə Yesu a həhar faya abəra fakalaw hay tasəla aye. ");
INSERT INTO meq_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","A ye a təkəratay a ndo neheye tə ndzawa tage Yesu aye. A ye naha na, faya ta tuwiye hərwi mədahaŋ i Yesu. A təkəratay wu nakə a ge bo tə neŋgeye. ");
INSERT INTO meq_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tə tsəne wu nakə a tsikatay aye, a gwaɗatay: «Yesu na, kə mbəlaw abəra ma mədahaŋ, neŋ na, na ŋgatay bəna mey na!» Ndo neheye ta təma bazlam ŋgay niye a tsikatay aye bay. ");
INSERT INTO meq_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ma dəba eye na, Yesu a mbəɗa ha bo ŋgay wal a bəzatay ha bo a gawla ŋgay hay sulo. A bəzatay ha bo na, ahəl nakə nəteye ka tsəveɗ faya ta diye a gəma aye. ");
INSERT INTO meq_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ndo niye hay sulo aye tə maw a Zerozelem. Tə maw na, ta təkəray wu nakə tə ŋgatay aye a siye i gawla i Yesu hay. Nəteye ta təmatay na bay ŋgway huya. ");
INSERT INTO meq_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ma dəba eye sa na, Yesu a bəzatay ha bo a gawla ŋgay hay kuro gər eye nəte. A bəzatay ha bo na, ahəl nakə nəteye faya ta ndiye ɗaf aye. Tsa na, a gatay me hərwi mədzele gər tay nakə andaya bay aye, ada hərwi ta dzala ha ka wu nakə ndo neheye tə tsikatay kurre, tə gwaɗatay: «Nəmaa ŋgatay a Yesu kə lətsew abəra ma mədahaŋ» aye na, ta dzala ha bay. ");
INSERT INTO meq_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tsa na, a gwaɗatay: «Anəke na, dum ka kokway i məndzibəra tebiye. Ɗum ha Labara Ŋgwalak eye a ndo zezeŋ tebiye ka məndzibəra. ");
INSERT INTO meq_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ndo nakə kə tsəne ada kə dzala ga ha tə ɗərev nəte ada ta dzəhuɓ ha a yam aye na, ma təmiye. Ndo nakə kə dzala ga ha bay aye na, Mbəlom ma ta giye faya sariya ");
INSERT INTO meq_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ta ta səriye ha ndo neheye ta dzala ga ha ta deɗek na, ma kəkay? Nəteye na, ta sliye faya mahəhere fakalaw abəra mə bo i ndo tə məzele ga. Ta tsikiye me tə bazlam i gəma hay wal wal. ");
INSERT INTO meq_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kwa taɗə ta gəs dədœ tə həlay, kwa tə sa muwar na, ma gateye wuray kwa tsekweŋ bay tebiye. Ta piye həlay ka ndo i ɗəvats hay na, ta mbəliye.» ");
INSERT INTO meq_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yesu Bəy Maduweŋ a tsikatay andza niye na, a tsal ŋgway a mbəlom. A ye na, a ndza tə həlay i mənday i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Gawla ŋgay hay dərmak ti ye mata ɗa ha bazlam ŋgwalak eye niye Yesu a tsikatay aye kwa a ŋgay. Bəy Maduweŋ a dzənawa tay ha ada a vəlawatay gədaŋ ka məge wu neheye a ge masuwayaŋ aye. Maa ɗa ha tə tsik bazlam i Mbəlom ta gədaŋ i Yesu na, masuwayaŋ nakə tə gawa aye.");
INSERT INTO meq_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","A nəkar Tiyofil ŋgwalak i ndo, ndo hay haladzay ɓa ta vəl ha gər tay məwetse labara nakə Yesu a ge mə walaŋ may aye. ");
INSERT INTO meq_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tə watsa na, wu nakə nəteye tə tsəne abəra ka ndo neheye tə ɗa ha bazlam i Mbəlom aye. Nəteye neheye na, ta ŋgatay tə ɗəre tay kwa ka madazlay ŋgay aye. ");
INSERT INTO meq_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aya! Neŋ dərmak a seŋ məwatsaka naha ka gər i bazlam eye nakay, hərwi na pəla na bəzay i bazlam nakay kwa ka madazlay ŋgay eye. ");
INSERT INTO meq_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Anəke na, nəkar dərmak ka sliye faya məsəre ha bazlam nakay ta tətikaka aye na, deɗek. ");
INSERT INTO meq_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ahəl nakə Herod neŋgeye bəy ka dala i Yahuda aye na, ndoweye andaya tə zalay Zakari. Neŋgeye na, gwala i Abiya, ndo məvəlay wu a Mbəlom aye. Məzele i ŋgwas ŋgay na, Elizabet. Neŋgeye dərmak na, gwala i Aroŋ bagwar i ndo məvəlaway wu a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nəteye salamay tay eye kame i Mbəlom na, ndo lele eye hay. Wu neheye Mbəlom a tsik aye tə bazlam mapala eye na, tə pay bəzay tə metsehe lele. ");
INSERT INTO meq_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ane tuk na, wawa tay andaya bay. Hərwi Elizabet na, a wa bay. Dəlay eye. Sa na, nəteye guram eye tsɨy. ");
INSERT INTO meq_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Anəke na, həlay i ndo neheye tə zalatay Abiya hay aye kə sla hərwi məfəkay naha wu a Mbəlom. Andza nakə ndo neheye tə vəlaway naha wu a Mbəlom tə pawa faya bo aye na, tə ge duk a way. Duk a way nakə tə ge aye na, a dəɗ ka Zakari. Mata fəkay naha wu ma təv niye tsəɗaŋŋa eye mə gay i məɗəslay ha gər a Mbəlom na, neŋgeye. Tsa na, a fələkwa a təv niye mata fəkay naha wu a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ahəl nakə Zakari faya ma fəkay naha wu a Mbəlom mə gay aye na, ndo hay haladzay ma bəra faya ta ɗuwuliye me. ");
INSERT INTO meq_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","A həlay niye na, gawla i Mbəlom a yaw a bəzay ha bo a Zakari. A lətse tə həlay i mənday i təv nakə tə fəkaway naha faya wu a Mbəlom aye. ");
INSERT INTO meq_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakari a ŋgatay na, a dzədzar haladzay, zluwer a gay. ");
INSERT INTO meq_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ane tuk na, gawla i Mbəlom niye a gwaɗay: «Zakari, kâ dzədzar bay. Ɓa Mbəlom kə tsəne maɗuwule me yak. Elizabet, ŋgwas yak ma ta wakeye wawa hasləka eye. Ka ta zaleye Yuhana. ");
INSERT INTO meq_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ɗərev yak ma ta ŋgwasiye haladzay. Pat i məwe ŋgay na, ndo hay haladzay ta ŋgwasiye hərwi ŋgay. ");
INSERT INTO meq_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Neŋgeye na, ma ta təriye bagwar eye, ndo məgay məsler a Bəy Maduweŋ. Ɗaɗa ma ta siye guzom bay. Kwa wu nakə makwasa eye na, ma ndzakiye bay. Məsəfəre Tsəɗaŋŋa eye ma ndziye faya kwa mə huɗ i may ŋgay. ");
INSERT INTO meq_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ma ta matay ahaya Israyel hay haladzay ka təv i Bəy Maduweŋ tay Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Maa lahayaw madayaw kame a Bəy Maduweŋ na, neŋgeye. Ma tsikateye me a ndo hay ta məzlaɓ bagwar eye andza i Eliya hərwi ada bəba hay tâ sər bo ta wawa tay hay. Ma matay ahaya ndo neheye ta rəhay ha gər a Mbəlom bay aye ka təv i Mbəlom. Ma təriye tay ha ndo ŋgwalak eye hay. Ma ta tsətsaliye tay ha ndo neheye nəteye maləva bo eye hərwi Bəy Maduweŋ aye.» ");
INSERT INTO meq_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ane tuk na, Zakari a gwaɗay a gawla i Mbəlom: «Na səriye ha wu nakay ka tsikeŋ aye deɗek na, kəkay? Neŋ na, ɓa guram eye, ŋgwas ga dərmak na, guram eye tuk na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Gawla i Mbəlom a mbəɗay faya, a gwaɗay: «Neŋ Gabəriyel. Neŋ na, ka təv i Mbəlom. A sləra ga ahaya mətsikaka bazlam nakay ada nâ zlakaw Labara Ŋgwalak eye. ");
INSERT INTO meq_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ane tuk na, ka dzala ha ka bazlam nakay bay sa na, wu nakay ma giye bo ka səriye mətsike me bay hus a pat nakə ta wiye na wawa niye aye.» ");
INSERT INTO meq_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ndo neheye faya ta həbiye Zakari ma bəra aye na, a gatay wadəŋ wadəŋ. Tə gwaɗ: «Zakari kə yaw abəra bay, kwa meeneŋ na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zakari a yaw abəra na, a sla faya mətsike me bay. Tsa na, ndo neheye ma bəra aye tə sər wu ka bəzay ha bo a Zakari mə gay. A tsikatay me na, tə həlay tsa. Neŋgeye huya mandək eye. ");
INSERT INTO meq_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Həlay i məge məsler i Zakari mə gay i Mbəlom a ndəv na, a ye a mətagay. ");
INSERT INTO meq_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ma dəba i kiye tsakway na, wawa a dəɗay a huɗ a Elizabet. Kiye zlam na, a ŋgahawa bo mə gay. A gwaɗ mə ɗərev ŋgay: ");
INSERT INTO meq_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Anəke na, Bəy Maduweŋ kə ŋgeteŋ. Kə vəleŋ wawa. Ndo hay ta ŋgwasiye fagaya sa bay.» ");
INSERT INTO meq_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kiye a yay a Elizabet məkwa na, Mbəlom a slər gawla ŋgay Gabəriyel a gəma wuray tə zalay Nazaret ka dala i Galile. ");
INSERT INTO meq_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","A slər ha na, a gay i dem eye andaya mədel i ndo wuray tə zalay Yusufa gwala i Bəy Davit. Tə zalay a dem eye niye na, Mari. ");
INSERT INTO meq_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gawla i Mbəlom niye a fələkwa a gay i Mari, a ye naha a gwaɗay: «Na tsikaka me Mari, Bəy Maduweŋ kə gaka ŋgwalak.» ");
INSERT INTO meq_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mari a tsəne andza niye na, a dzədzar a gwaɗ mə ɗərev ŋgay: «Mətsike me niye na, andza məgweɗe mey?» ");
INSERT INTO meq_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Gawla i Mbəlom a gwaɗay: «Kâ dzədzar bay Mari, Mbəlom a wuɗa kar. ");
INSERT INTO meq_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wawa ma dəɗakeye a huɗ. Ka ta wiye wawa niye na, hasləka eye. Ka ta zaleye Yesu. ");
INSERT INTO meq_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Neŋgeye na, ma ta təriye bagwar eye. Ta ta zaleye Wawa i Mbəlom Fetek mə gəma. Bəy Maduweŋ Mbəlom ma təriye ha bəy bagwar eye andza bəba təte ŋgay Davit: ");
INSERT INTO meq_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Neŋgeye ma ta ləviye tay ha Israyel hay ka tor eye. Bəy ŋgay na, ma ndəviye bay.» ");
INSERT INTO meq_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari a gwaɗay a gawla i Mbəlom niye: «Wuye ma ta giye bo na, kəkay? Neŋ na, na sər zal zuk bay tuk na, kəkay!» ");
INSERT INTO meq_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Gawla i Mbəlom a mbəɗay faya: «Məsəfəre Tsəɗaŋŋa eye ma mbəzlaweye fakaya. Gədaŋ i Mbəlom Fetek ma ndziye fakaya andza mezek. Yawa! Wawa niye ka ta wiye na, ta zaleye Tsəɗaŋŋa, Wawa i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Zəba dem i bəba yak Elizabet kwa neŋgeye guram eye bəbay na, anəke kiye kə yay məkwa. ");
INSERT INTO meq_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Hərwi wuray a zay gədaŋ a Mbəlom təbey.» ");
INSERT INTO meq_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tsa na, Mari a gwaɗay a gawla i Mbəlom: «Neŋ ndo i məsler i Bəy Maduweŋ. Mâ ge bo andza nakə ka tsik aye.» Tsa na, gawla i Mbəlom a ye ŋgway. ");
INSERT INTO meq_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ma dəba i məndze tsekweŋ na, Mari a lətse a ye ta bəse a gəma eye andaya mə mahəmba i Yahuda. ");
INSERT INTO meq_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","A ye na, a gay i Zakari. A ye naha a ndisl na, a fələkwa a gay. A tsikay me a Elizabet. ");
INSERT INTO meq_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabet a tsəne mətsike me i Mari na, wawa a hats mə huɗ ŋgay. Məsəfəre Tsəɗaŋŋa eye a mbəzlaw ka Elizabet. ");
INSERT INTO meq_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tsa na, Elizabet a wuda, a gwaɗ: «Nəkar na, Mbəlom kə pa fakaya ŋgama a ze siye i ŋgwas hay tebiye. Ŋgama mâ ndza ka wawa niye ka wiye. ");
INSERT INTO meq_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","May i Bəy Maduweŋ ga a yaw ka təv ga na, kəkay! Neŋ təday na, way! ");
INSERT INTO meq_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Na gwaɗ ka ŋgatay ba! Ahəl nakə ka tsikeŋ me aye na, wawa a ɓəl tə məŋgwese eye mə huɗ ga. ");
INSERT INTO meq_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nəkar na, ɗərev yak maŋgwasa eye hərwi wu nakə Bəy Maduweŋ a tsik aye na, ka təma, ma giye bo!» ");
INSERT INTO meq_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tsa na, Mari a gwaɗ: «Na zambaɗeye a Bəy Maduweŋ tə ɗərev ga peteh. ");
INSERT INTO meq_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ɗərev ga kə ŋgwasa haladzay hərwi Mbəlom nakə a təma ga ha aye. ");
INSERT INTO meq_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ka zəba fagaya tsekweŋ mə walaŋ i ndo neheye neŋ ndo i məsler ŋgay. Ndo neheye anəke aye ta ndo neheye ta ta wiye tay ha aye na, ta gweɗeŋeye “Nəkar na, ɗərev yak maŋgwasa eye.” ");
INSERT INTO meq_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Hərwi Mbəlom bagwar eye kə ge wu nakə lele aye hərwi ga. Neŋgeye na, Mbəlom tsəɗaŋŋa eye. ");
INSERT INTO meq_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Neŋgeye na, ŋgwalak ŋgay ɗaɗa a ndəv təbey. Ndo neheye ta rəhay ha gər aye na, ŋgwalak ŋgay ma ndziye huya ta nəteye. ");
INSERT INTO meq_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ka bəz ha gədaŋ ŋgay, ka həhar tay ha ndo neheye tə ɗəslay ha gər a bo tay aye. ");
INSERT INTO meq_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ka həhar tay ha bəy hay abəra ka təv məndze i bəy tay hay. Kə vəlatay gədaŋ a ndo i mətawak hay. ");
INSERT INTO meq_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ndo neheye may a gatay aye na, kə vəlatay wu mənday. Ndo i mezeleme hay na, ka həhar tay ha. ");
INSERT INTO meq_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ki yaw madzəne tay hay Israyel hay, ndo i məsler ŋgay hay. Mbəlom na, kə mətsa ha gər ta ŋgwalak ŋgay bay. ");
INSERT INTO meq_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kə ge andza nakə a tsikatay a bəba təte kway hay ahəl niye aye. A tsikay a Abraham ada a gwala i Abraham hay tebiye ka tor eye.» ");
INSERT INTO meq_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari a ndza mə gay i Elizabet kiye mahkar. Tsa na, a ye a mətagay. ");
INSERT INTO meq_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Anəke na, kiye i Elizabet kə sla məwe. A wa wawa hasləka eye. ");
INSERT INTO meq_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ndo ŋgay hay ta ndo i məgeɗ ŋgay hay tə tsəne Mbəlom kə gay ŋgwalak a Elizabet na, ti ye mata ŋgwese ka bo dziye. ");
INSERT INTO meq_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wawa a həna tsamahkar na, ndo hay ti yaw mata ɗəse na wawa niye. A satay haɓe məpe faya məzele na, Zakari, tə məzele i Bəba ŋgay. ");
INSERT INTO meq_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ane tuk na, may i wawa niye, a gwaɗatay: «Aʼay! Ta zaleye na, Yuhana.» ");
INSERT INTO meq_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tə gwaɗay: «Məzele andaya andza niye ma gwala yak bay tuk na, kəkay!» ");
INSERT INTO meq_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tsa na, ta tsətsah ka bəba ŋgay wulək wulək tə həlay. Tə gwaɗay: «A saka məpe məzele ka wawa na, way?» ");
INSERT INTO meq_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakari a tsətsah fataya palalam nakə tə watsawa faya aye. Tə zlayaw. Tsa na, a watsa: «Məzele ŋgay na, Yuhana.» Tsa na, a gatay wadəŋ wadəŋ tebiye tay eye. ");
INSERT INTO meq_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kwayaŋŋa bazlam i Zakari a həndək ka mətsike me. Tsa na, a zambaɗay a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ndo i məgeɗ hay tebiye ta dzədzar. Ndo i gəma niye hay tebiye hus a mahəmba i Yahuda tə tsikawa faya. ");
INSERT INTO meq_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kwa way a tsəne bazlam niye na, tə dzalawa faya mə gər tay, tə gwaɗawa: «Wawa nakay ma ta təriye na, mey?» Ta deɗek, gədaŋ i Bəy Maduweŋ ka gər ŋgay. ");
INSERT INTO meq_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Məsəfəre Tsəɗaŋŋa eye a mbəzlaw ka Zakari, bəba i wawa niye. Tsa na, a ɗa ha, a gwaɗ: ");
INSERT INTO meq_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Zambaɗakway a Bəy Maduweŋ kway Mbəlom i Israyel hay. Neŋgeye kə mbəzlaw a walaŋ kway hərwi məmbəle kway hay. ");
INSERT INTO meq_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Neŋgeye kə slərakwayaw ndo gədaŋ eye hərwi mətəme kway hay. Neŋgeye na, gwala i Davit ndo i məsler i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Bazlam nakay na, Mbəlom ɓa kə tsikatay a ndo məɗe ha bazlam ŋgay tsəɗaŋŋa eye hay ahəl niye. ");
INSERT INTO meq_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","A gwaɗ na, ma ta təmiye kway ha abəra mə həlay i ndo i vəram kway hay, ada mə həlay i ndo neheye tebiye tə nakway ɗəre aye. ");
INSERT INTO meq_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kə gatay ŋgwalak ŋgay a bəba kway hay. Ma mətsiye ha gər ta dzam nakə a ɓar eye bay. ");
INSERT INTO meq_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Mbəlom ɓa ka mbərəm məmbaɗay a bəba təte kway Abraham. ");
INSERT INTO meq_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","A gwaɗ: Ma ta təmiye kway ha abəra mə həlay i ndo i vəram kway hay na, hərwi ada kâ slakwa faya məgay məsler tə madzədzar eye sa bay. ");
INSERT INTO meq_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","A ge andza niye na, hərwi ada kâ tərakwa ndo ŋgay hay. Ka tərakweye na, ndo ŋgay tsəɗaŋŋa eye hay huya ma məndze kway. ");
INSERT INTO meq_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nəkar na, wawa ga, ta ta zalakeye na, ndo məɗe ha bazlam i Mbəlom Fetek, hərwi nəkar na, ka laheye kame a Bəy Maduweŋ, ka lambaɗeye na tsəveɗ. ");
INSERT INTO meq_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ka ta tsikateye a ndo ŋgay hay ma deyeweye mətəme tay ha. Ma ta pəsatay ha mənese tay hay. ");
INSERT INTO meq_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mbəlom kway na, ŋgwalak ŋgay a ndəv bay. Andza niye, dzaydzay ŋgay ma dəvakweye andza pat nakə faya ma tsaraweye. ");
INSERT INTO meq_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tsa na, ma dəvateye dzaydzay a ndo neheye ma mezek i mədahaŋ aye. Ma lakiye kway ka tsəveɗ i zay.» ");
INSERT INTO meq_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yawa! Yuhana a gəl na, metsehe ŋgay a səkah kame kame. A lətse a ye a kəsaf. A ndza mə ɗəma hus a pat nakə a bəzatay ha bo parakka a Israyel hay aye. ");
INSERT INTO meq_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ahəl niye tə wa Yuhana madzəhuɓe ndo a yam na, Agustus neŋgeye bəy i Roma. Anəke na, a gwaɗatay a ndo hay tâ pasla ndo hay ka dala ŋgay tebiye. ");
INSERT INTO meq_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nakay na, makurre i məpesle ndo nakə tə pasla ahəl niye Kiriniyus a ləvawa gəma i Siri ka dala i Roma aye. ");
INSERT INTO meq_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kwa way a ye mata wetse məzele ŋgay na, ma gəma ŋgay. ");
INSERT INTO meq_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Andza niye, Yusufa neŋgeye ma ndziye ma gəma i Nazaret ka dala i Galile. A tsəne na, a ye ka dala i Yahuda ma gəma nakə tə zalay Betelehem aye. Gəma nakə tə wa mə ɗəma bəba təte ŋgay Davit aye. ");
INSERT INTO meq_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","A ye na, ta Mari mədel ŋgay tə bo sulo eye mata wetse məzele tay. ");
INSERT INTO meq_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ahəl nakə nəteye ma Betelehem aye na, həlay i məwe wawa i Mari kə sla. ");
INSERT INTO meq_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","A wa malkwara ŋgay niye na, hasləka eye. A mbuza na a petekeɗ, a həna ha a təv mənde wu mənday i gənaw hay hərwi ta huta təv mə gay i mbəlok hay bay. ");
INSERT INTO meq_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma gəma niye na, ndo mətsəkure gənaw hay andaya tə hənawa mə pesl, tə tsəkurawa gənaw tay hay ta həvaɗ. ");
INSERT INTO meq_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Gawla i Mbəlom a mbəzlaw a bəzatay ha bo. Təv niye nəteye mə ɗəma aye na, a dəv dzaydzay ta gədaŋ i Bəy Maduweŋ. Tsa na, ndo mətsəkure gənaw niye hay ta dzədzar. ");
INSERT INTO meq_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ane tuk na, Gawla i Mbəlom niye a gwaɗatay: «Kâ dzədzarum bay! Na zlakumaw na, Labara Ŋgwalak eye. Ndo hay haladzay ta ŋgwasiye hərwi bazlam nakay. ");
INSERT INTO meq_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bəgom ta həvaɗ nakay ta wakum ndo mətəme kurom ha ma Betelehem, ma gəma i Davit. Neŋgeye na, Kəriste, Bəy Maduweŋ. ");
INSERT INTO meq_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Dum ta zəbumaw faya. Ka ŋgatumeye a wawa eye. Ka sərumeye ha neŋgeye na, hərwi mambuza eye mə petekeɗ. Ma həniye ma təv mənday wu i gənaw hay.» ");
INSERT INTO meq_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kwayaŋŋa, gawla i Mbəlom hay haladzay tə yaw ka təv i gawla i Mbəlom niye ta zambaɗay a Mbəlom tə gwaɗ: ");
INSERT INTO meq_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Ŋgama mâ təra mə mbəlom məgəma, ka gər i ndo hay tebiye. Zay mâ təra ka məndzibəra mə walaŋ i ndo neheye Mbəlom a wuɗa tay ha aye.» ");
INSERT INTO meq_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tsa na, gawla i Mbəlom hay ti ye wu tay a mbəlom. Ti ye wu tay na, ndo mətsəkure gənaw hay tə gwaɗ mə walaŋ tay: «Lətsakwa, takwa hus a Betelehem ta zəbakwaw ka wu nakə a ge bo aye, nakə Bəy Maduweŋ a ɗakway ha aye.» ");
INSERT INTO meq_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ti ye ta bəse a Betelehem. Tə ndisl naha a ɗəma na, tə ŋgatay a Mari ta Yusufa ada ta wawa ndəriz niye mahəna eye ma təv mənday wu i gənaw hay. ");
INSERT INTO meq_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tə ŋgatay andza niye na, ta təkəratay wu nakə gawla i Mbəlom a tsikatay ka gər i wawa niye aye. ");
INSERT INTO meq_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kwa way a tsəne wu nakə ndo mətsəkure gənaw hay ta təkər aye na, a gatay hərɓaɓəkka. ");
INSERT INTO meq_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mari na, wu neheye tə tsik aye na, a pa na tebiye a gər a dzalawa faya. ");
INSERT INTO meq_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tsa na, ndo mətsəkure gənaw hay tə maw wu tay. Tə ɗəslay ha gər a Mbəlom ta zambaɗay hərwi wu nakə tə tsəne ada tə ŋgatay aye na, kə ge bo andza nakə tə tsikatay aye. ");
INSERT INTO meq_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Məhəne tasəla a ge matsamahkar eye na, həlay i məɗəse wawa kə sla. A pa faya məzele Yesu. Məzele niye na, məzele nakə gawla i Mbəlom a tsikay a Mari ahəl niye kə huta huɗ zuk bay aye. ");
INSERT INTO meq_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Həlay i məbere bo tay ka ɗəre i Mbəlom kə sla andza bazlam i Mbəlom mapala eye nakə Musa a watsa aye. Andza niye, Yusufa ta Mari tə zla wawa, ti ye ha a Zerozelem mata bəzay ha a Bəy Maduweŋ, ");
INSERT INTO meq_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","hərwi mawatsa eye mə ɗerewel i Musa na: «Malkwara i wawa hasləka eye na, i Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ada andza nakə mawatsa eye mə ɗerewel i Musa na, ti ye tə vəlay maydagwar sulo kəgəbay bodobodo sulo a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Yawa! Ndoweye andaya ma Zerozelem, məzele ŋgay Simeyoŋ. Neŋgeye na, ŋgwalak i ndo, ka təma bazlam i Mbəlom lele. Faya ma həbiye ndo mətəme tay ha Israyel hay. Simeyoŋ na, Məsəfəre Tsəɗaŋŋa eye ka neŋgeye. ");
INSERT INTO meq_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Məsəfəre Tsəɗaŋŋa eye ɓa kə tsikay, a gwaɗay: «Ka ta mətiye na, ka ŋgateye a Kəriste nakə Bəy Maduweŋ ma sləraweye təday.» ");
INSERT INTO meq_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Anəke na, Simeyoŋ a ye a gay i məɗəslay ha gər a Mbəlom ta gədaŋ i Məsəfəre i Mbəlom. Ahəl niye na, bəba i Yesu hay ti ye naha tə fələkwa a gay ta wawa məge andza nakə bazlam i Musa mapala eye a tsik aye. ");
INSERT INTO meq_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tsa na, Simeyoŋ a zla wawa niye a həlay, a zambaɗay a Mbəlom, a gwaɗ: ");
INSERT INTO meq_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Bəy Maduweŋ ga, anəke na, gər ha ndo i məsler yak mâ ye ŋgway, mâ mət tə zay, hərwi ka ge wu nakə ka tsik aye. ");
INSERT INTO meq_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Na ŋgatay tə ɗəre ga a ndo mətəme ha ndo yak nakə ka sləraw aye. ");
INSERT INTO meq_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ka ləva ha bo na, hərwi ndo hay tebiye. ");
INSERT INTO meq_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ndo nakə ka sləraweye na, neŋgeye na, dzaydzay nakə ma dəvateye a ndo hay tebiye ka məndzibəra ada neŋgeye ma vəlateye məzlaɓ a ndo yak hay Israyel hay.» ");
INSERT INTO meq_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Bəba ta may i Yesu na, a gatay hərɓaɓəkka hərwi bazlam i Simeyoŋ niye a tsik aye. ");
INSERT INTO meq_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tsa na, Simeyoŋ a pa fataya ŋgama i Mbəlom. A gwaɗay a Mari may i wawa niye: «Wawa nakay na, Israyel hay haladzay ta dəɗiye faya. Andza niye, ndo hay haladzay ta maweye ka təv i Mbəlom hərwi ŋgay. Ma ta ɗatay ha məsler i Mbəlom na, neŋgeye. Ane tuk na, ndo hay ta kərahiye na. ");
INSERT INTO meq_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Wu nakə maŋgaha eye ma mədzal gər kwa i way i way na, ma bəziye ha parakka. Nəkar dərmak Mari, ɗəretsətseh ma ta ŋgəniye ha ka bo bəra ɗərev yak andza maslalam.» ");
INSERT INTO meq_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ŋgwas wuray andaya guram eye ketef ketef, məzele ŋgay Anna. Neŋgeye na, ndo məɗe ha bazlam i Mbəlom. Dem i Fanuwel gwala i Aser. Ahəl nakə neŋgeye dem eye na, a ye a zal. A ndza mə zal məve tasəla na, zal ŋgay niye a mət. ");
INSERT INTO meq_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tsa na, ki ye a zal sa bay, a ndza ŋgway madəgway i ŋgwas eye. Məve ŋgay na, kuro kuro tsamahkar gər eye faɗ. Ma məndze ŋgay na, a gaway məsler a Mbəlom. A yawa a gay i məɗəslay ha gər a Mbəlom ta həvaɗ kwa ta həpat pat pat. A ɗuwulaway me a Mbəlom. A gawa daliyam. ");
INSERT INTO meq_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","A ye a gay i məɗəslay ha gər a Mbəlom na, ahəl nakə Simeyoŋ faya ma tsikiye me mba aye. A ye naha, a gay naha sɨsœ a Mbəlom. A tsik ka wawa niye a ndo neheye faya ta həbiye madayaw i ndo mətəme ha ndo nakə ma təmiye ha Zerozelem aye. ");
INSERT INTO meq_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yusufa ta Mari ta ndəv ha məge wu nakə mawatsa eye mə bazlam i Mbəlom mapala eye na, ta mbəɗa gər a gəma tay a Nazaret ka dala i Galile. ");
INSERT INTO meq_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wawa niye faya ma gəliye na, gədaŋ tə metsehe ŋgay a səkah kame kame, ŋgama i Mbəlom tə neŋgeye. ");
INSERT INTO meq_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ka məve na, Yusufa ta Mari ti yawa a magurlom i Pak a Zerozelem. ");
INSERT INTO meq_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu a ge məve kuro gər eye sulo na, ti ye dziye ta bəba ŋgay hay andza nakə ti yawa aye. ");
INSERT INTO meq_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Magurlom a ndəv na, tə maw a mətagay. Yesu na, kə mətsa ma Zerozelem. Bəba ŋgay hay ta sər faya bay. ");
INSERT INTO meq_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nəteye tə dzala mə gər tay na, Yesu neŋgeye ta ndo neheye ti ye ka bo dziye. Tə ndza hwapat ka mede. Ta huwa na, tə pa bo ka mapəle na mə walaŋ i gwala tay hay ada mə walaŋ i dzam tay hay. ");
INSERT INTO meq_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ta pəla na na, ta huta na bay. Ta mbəɗa gər a Zerozelem tə mapəle na haladzay. ");
INSERT INTO meq_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ma dəba i məhəne mahkar, ti ye naha tə huta na mə gay i məɗəslay ha gər a Mbəlom. Neŋgeye ma ndziye mə walaŋ i ndo mədzaŋgawa bazlam i Mbəlom mapala eye, faya ma piye zləm ka bazlam ada faya ma tsətsahiye fataya bazlam hay. ");
INSERT INTO meq_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ndo niye hay tə tsəne wu nakə faya ma tsikiye na, a gatay hərɓaɓəkka hərwi ndaraw ŋgay ada tə mambəɗe ka bazlam nakə a mbəɗawatay faya aye. ");
INSERT INTO meq_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bəba ŋgay hay tə ŋgatay andza niye na, a gatay hərɓaɓəkka. May ŋgay a gwaɗay: «Wawa ga, ka gamay andza niye na, hərwi mey? Nəmay ta bəba yak na, faya nəmaa pəliye kar. Mədzal gər may ka dzədza haladzay.» ");
INSERT INTO meq_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A gwaɗatay: «Ka pəlumeye ga na, hərwi mey? Neŋ na, na ndziye mə gay i bəba ga na, ka sərum təbəɗew.» ");
INSERT INTO meq_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ane tuk na, ta tsəne wu nakə Yesu a tsikatay aye bay. ");
INSERT INTO meq_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tsa na, Yesu a lətse ti ye ta bəba ŋgay hay a Nazaret. Yesu na, a hənawatay ha gər lele. May ŋgay a pa na bazlam niye a gər ŋgay. ");
INSERT INTO meq_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu a gəl na, metsehe ŋgay a səkah kame kame. A yay a gər a Mbəlom haladzay ada ndo hay ta zambaɗaway haladzay. ");
INSERT INTO meq_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ahəl niye na, Tiber neŋgeye bəy i Roma. Kə va ma bəy kuro gər eye zlam. Poŋos Pilat, bəy nakə ka dala i Yahuda aye. Herod neŋgeye a ləva dala i Galile. Malamar ŋgay Filip na, a ləva dala i Iture ta Trakonitit, Lisaniyas i ŋgay na, a ləva dala i Abilen. ");
INSERT INTO meq_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Bagwar i ndo məvəlaway wu a Mbəlom na, Han ta Kayif. Ahəl niye na, Yuhana wawa i Zakari na, mə makulkwandah. Mbəlom a tsikayaw me a slər na. ");
INSERT INTO meq_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tsa na, Yuhana a dazlay mahəhele gəma neheye tə mbay naha a magayam i Yurdum aye tebiye. A gwaɗawatay a ndo hay: «Mbəɗum ha mede kurom. Dzəhuɓum bo a yam ada Mbəlom ma pəsakumeye ha mənese kurom hay.» ");
INSERT INTO meq_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Andza niye, nakay na, wu nakə mawatsa eye mə ɗerewel i Ezay ndo məɗe ha bazlam i Mbəlom aye, a gwaɗ: «Ndo faya ma wudiye mə kəsaf, a gwaɗ: “Lambaɗumay tsəveɗ a Bəy Maduweŋ, lambaɗumay tsəveɗ hay fehe lele, tâ hədzak bay! ");
INSERT INTO meq_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Loloŋ hay tebiye ta ta rahiye fəɗeɗe! Mahəmba hay ta tsaholok hay ta ta miye ka dala faɗaɗa! Tsəveɗ neheye mahədzaka eye hay ta ta lambaɗiye tay hay dandər dandər lele! Tsəveɗ neheye tsərsloslo tə kwar aye hay ta ta ləviye fehe lele! ");
INSERT INTO meq_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mbəlom ma təmiye tay ha ndo hay kəkay na, ndo hay tebiye ta ŋgateye.”» ");
INSERT INTO meq_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ndo hay haladzay ti yawa naha ka təv i Yuhana hərwi ada mâ dzəhuɓ tay ha a yam. Yuhana a gwaɗawa tay: «Wawa i palas hay! Maa ɗakum ha hwayum abəra ka sariya i Mbəlom nakə bəse kə ndzew aye na, way? ");
INSERT INTO meq_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Anəke na, gum məsler neheye ŋgwalak eye ndo hay ta səriye ha ka mbəɗum ha mede kurom aye tuk. Ka dzalum mə gər kurom “Nəmay na, wawa i Abraham hay sa na, ma ta gamay mey bay!” Sərum ha na, Mbəlom ma sliye faya məge tay ha kwar neheye anaŋ aye wawa i Abraham hay! ");
INSERT INTO meq_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ɓa hadzaya maləva bo eye məɗəse tay ha dərizl i gərɗaf hay ta zləlay eye dzay tebiye. Dərizl i gərɗaf neheye tebiye tə wa hohway ŋgwalak eye bay aye na, ta ɗəsiye tay ha ada ta kaliye tay ha ako.» ");
INSERT INTO meq_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ndo hay ta tsətsah faya, tə gwaɗay: «Nəmaa giye na, mey?» ");
INSERT INTO meq_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A mbəɗatay faya, a gwaɗatay: «Ndo nakə məkelkabo ŋgay sulo aye na, mâ vəlay nəte a ndo nakə i ŋgay andaya bay aye. Ndo nakə wu mənday ŋgay andaya na, tâ ŋgəna ta ndo nakə i ŋgay andaya bay aye.» ");
INSERT INTO meq_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ndo matsekele dzaŋgal hay ti ye naha hərwi madzəhuɓe bo a yam dərmak. Ta tsətsah ka Yuhana tə gwaɗay: «Miter, nəmaa giye na, mey!» ");
INSERT INTO meq_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A mbəɗatay faya a gwaɗatay: «Kâ təmum wu abəra ka ndo mâ ze nakə bəy i dala a gwaɗakum təmum aye bay.» ");
INSERT INTO meq_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sidzew hay ta tsətsah andza niye dərmak: «Ada nəmay na, nəmaa giye mey tey?» A gwaɗatay: «Kâ buwum suloy abəra ka ndo ta gədaŋ bay. Kâ rawum me ka ndo hərwi matəme faya bəra suloy bay. Ɗuh həbum na, madagər kurom nakə ta vəlakumeye ka kiye aye.» ");
INSERT INTO meq_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ndo hay ta dazlay mədzele ka wu nakə ma giye bo aye, tə dzalawa mə gər tay tə gwaɗ: «Ma giye Yuhana na, Kəriste.» ");
INSERT INTO meq_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yuhana a gwaɗatay a nəteye niye tebiye: «Neŋ na, na dzəhuɓiye kurom ha a yam tsa. Ndo mekeleŋ eye ma deyeweye kame ga, neŋgeye na, gədaŋ eye a ze ga. Na sliye mahəndzəɗe ka təv ŋgay məpəlay ha ləɓer i tahərak ŋgay bay tebiye. Neŋgeye, ma dzəhuɓiye kurom ha ta Məsəfəre Tsəɗaŋŋa eye ada ta ako. ");
INSERT INTO meq_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wu mahəve daw andaya mə həlay. Ma ŋgəniye tay ha daw ta dzəndzar. Daw na, ma hayay gər ma həliye na a de. Ada dzəndzar na, ma dziye a ako nakə ma mbatiye ɗaɗa bay aye.» ");
INSERT INTO meq_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yuhana a ɗawatay ha Labara Ŋgwalak eye tə məvəlatay gədaŋ tə bazlam hay wal wal. ");
INSERT INTO meq_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yuhana kə gay me a Herod hərwi a zla Herodiyad ŋgwas i malamar ŋgay. Ada Yuhana kə gay me ka wu hay wal wal. ");
INSERT INTO meq_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herod a səkah ha məge mənese sa. A gəs na Yuhana a daŋgay. ");
INSERT INTO meq_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ma dəba aye Yuhana a dzəhuɓ tay hay ndo hay tebiye a yam na, a dzəhuɓ ha Yesu a yam dərmak. A həlay nakə faya ma ɗuwuliye me aye na, magərmbəlom a həndək tuwaŋ. ");
INSERT INTO meq_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tsa na, Məsəfəre Tsəɗaŋŋa a mbəzlaw faya, ɗəre a ŋgatay andza bodobodo. Tsa na, mətsike me a tsənew abəra mə mbəlom a gwaɗ: «Nəkar na, wawa ga. Na wuɗa kar haladzay. Ɗərev ga faya ma ŋgwasiye tə nəkar.» ");
INSERT INTO meq_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu a dazlay a məge məsler na, məve ŋgay ma giye kuro kuro mahkar. Ndo hay tə dzala tə gwaɗ neŋgeye na, wawa i Yusufa. Yusufa wawa i Heli ");
INSERT INTO meq_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli wawa i Matat, Matat wawa i Levi, Levi wawa i Melki, Melki wawa i Zanay, Zanay wawa i Yusufa, ");
INSERT INTO meq_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusufa wawa i Matatiyas, Matatiyas wawa i Amos, Amos wawa i Nahum, Nahum wawa i Esəli, Esəli wawa i Nagay, ");
INSERT INTO meq_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay wawa i Maat, Maat wawa i Matatiyas, Matatiyas wawa i Semeyin, Semeyin wawa i Zozek, Zozek wawa i Zoda, ");
INSERT INTO meq_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zoda wawa i Yohanan, Yohanan wawa i Resa, Resa wawa i Zorobabel, Zorobabel wawa i Salatiyel, Salatiyel wawa i Neri, ");
INSERT INTO meq_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri wawa i Melki, Melki wawa i Addi, Addi wawa i Kozam, Kozam wawa i Elmadam, Elmadam wawa i Er, ");
INSERT INTO meq_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er wawa i Zozowe, Zozowe wawa i Eliyezer, Eliyezer wawa i Zorim, Zorim wawa i Matat, Matat wawa i Levi, ");
INSERT INTO meq_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi wawa i Simeyoŋ, Simeyoŋ wawa i Yahuda, Yahuda wawa i Yusufa, Yusufa wawa i Zonam, Zonam wawa i Eliyakim, ");
INSERT INTO meq_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim wawa i Meliya, Meliya wawa i Mena, Mena wawa i Matata, Matata wawa i Natan, Natan wawa i Davit, ");
INSERT INTO meq_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davit wawa i Zese, Zese wawa i Obed, Obed wawa i Booz, Booz wawa i Salmoŋ, Salmoŋ wawa i Nasoŋ, ");
INSERT INTO meq_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasoŋ wawa i Aminadab, Aminadab wawa i Admiŋ, Admiŋ wawa i Arni, Arni wawa i Hesron, Hesron wawa i Fares, Fares wawa i Yahuda, ");
INSERT INTO meq_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda wawa i Zakob, Zakob wawa i Izak, Izak wawa i Abraham, Abraham wawa i Tara, Tara wawa i Nakor, ");
INSERT INTO meq_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakor wawa i Serok, Serok wawa i Ragu, Ragu wawa i Falek, Falek wawa i Eber, Eber wawa i Sala, ");
INSERT INTO meq_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala wawa i Kaynam, Kaynam wawa i Arfadzad, Arfadzad wawa i Sem, Sem wawa i Nuhu, Nuhu wawa i Lamek, ");
INSERT INTO meq_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek wawa i Matosalem, Matosalem wawa i Henok, Henok wawa i Iyaret, Iyaret wawa i Maleleyel, Maleleyel wawa i Kaynam. ");
INSERT INTO meq_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynam Wawa i Enos, Enos wawa i Set, Set wawa i Adam, Adam neŋgeye na, Wawa i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ma dəba eye Məsəfəre Tsəɗaŋŋa a rahay a bo i Yesu na, a ye abəra ka təv i magayam i Yurdum niye. Tsa na, Məsəfəre Tsəɗaŋŋa eye a ye ha a makulkwandah. ");
INSERT INTO meq_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mə ɗəma na, Yesu kə ndza məhəne kuro kuro faɗ, Fakalaw a say masəpete na. Ma məndze niye na, Yesu kə nda wu mənday kwa tsekweŋ bay tebiye. Ka mandəve i məhəne niye hay na, may a wur faya tuk. ");
INSERT INTO meq_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tsa na, Fakalaw a yaw ka təv ŋgay, a gwaɗay: «Taɗə kə ge nəkar Wawa i Mbəlom na, gwaɗay a kwar nakay mâ təraka wu mənday.» ");
INSERT INTO meq_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu a mbəɗay faya: «Mawatsa eye mə bazlam i Mbəlom na: “Ndo zezeŋ ma ndziye na, ta wu mənday ɗekɗek bay.”» ");
INSERT INTO meq_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Fakalaw a ye ha ka gər i gəma. Kwayaŋŋa a bəzay ha bəy i məndzibəra tebiye. ");
INSERT INTO meq_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","A bəzay ha na, a gwaɗay: «Na vəlakeye a nəkar hərwi gədaŋ ta zlele neheye ma bəy i dala neheye tebiye mavəla eye a neŋ. Na sliye faya məvəle kwa a way andza nakə a seŋ aye. ");
INSERT INTO meq_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Taɗə ka dəkweŋ gurmets na, na vəlakeye ha tebiye a nəkar.» ");
INSERT INTO meq_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu a mbəɗay faya: «Mawatsa eye mə bazlam i Mbəlom na, a gwaɗ: “Ɗəslay ha gər a Bəy Maduweŋ yak Mbəlom, ada ka geye məsler na, a neŋgeye nəte ŋgweŋ.”» ");
INSERT INTO meq_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Fakalaw a ye ha a gəma i Zerozelem, ka gər i gay i məɗəslay ha gər a Mbəlom. Tə ndisl a ɗəma na, a gwaɗay a Yesu: «Taɗə kə ge nəkar Wawa i Mbəlom sa na, kal ha bo abəra ka gər i gay nakay ka dala. ");
INSERT INTO meq_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Hərwi mawatsa eye mə bazlam i Mbəlom na, a gwaɗ: “Mbəlom ma gwaɗateye a gawla ŋgay hay na, tâ dzəna kar, tâ tsəpa kar. ");
INSERT INTO meq_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tâ kəndawa kar, hərwi ada sik yak mâ ndzay a kwar bay.”» ");
INSERT INTO meq_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu a mbəɗay faya a gwaɗay: «Mawatsa eye mə bazlam i Mbəlom na, a gwaɗ: “Kâ dza ha Bəy Maduweŋ yak Mbəlom bay.”» ");
INSERT INTO meq_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Fakalaw a ndəv ha wewer ŋgay tebiye hərwi masəpete Yesu. Ma dəba eye na, a ye ŋgway abəra ka təv i Yesu hus a pat mekeleŋ eye. ");
INSERT INTO meq_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ma dəba eye na, Yesu a mbəɗa gər a Galile. A ye na, neŋgeye maraha eye ta gədaŋ i Məsəfəre i Mbəlom. Mə ɗəma na, məzele ŋgay a ɗa zləm a gəma hay tebiye. ");
INSERT INTO meq_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","A tətikawatay bazlam i Mbəlom a ndo hay mə gay i maɗuwule me. Ndo hay tebiye ta zambaɗaway. ");
INSERT INTO meq_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ma dəba eye Yesu a lətse, a ye a gəma i Nazaret. Nazaret na, gəma nakə a gəl mə ɗəma aye. Pat i mazəzukw bo na, a lətse a ye a gay i maɗuwule me andza nakə a gawa ha aye. Mə ɗəma na, a lətse hərwi mədzeŋge bazlam i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tsa na, ti ye naha tə zlayaw ɗerewel i Ezay ndo məɗe ha bazlam i Mbəlom, tə vəlay. Tsa na, a pəla ha ɗerewel niye. A pəla ha na, a huta təv nakə mawatsa eye, a gwaɗ: ");
INSERT INTO meq_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Məsəfəre i Bəy Maduweŋ ka gər ga. A zla ga, a sləra ga ahaya na, hərwi məzlatayaw Labara Ŋgwalak eye a ndo i mətawak hay. A sləra ga ahaya na, hərwi məɗatay labara i mətəme a ndo i daŋgay hay. A sləra ga ahaya hərwi mahəndəkatay na ɗəre a guluf hay. A sləra ga ahaya na, mətəme tay ha, ndo neheye faya ta gateye ɗəretsətseh aye. ");
INSERT INTO meq_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Məɗe ha məve nakə Mbəlom ma gateye ŋgwalak ŋgay a ndo hay aye na, kə ndislew.» ");
INSERT INTO meq_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu a ndəv ha mədzeŋge andza niye na, a paɗa na ɗerewel niye. A may ha a ndo məge məsler i gay i maɗuwule me niye. Tsa na, a ye a ndza ŋgway. Ndo niye hay tebiye mə gay i maɗuwule me aye na, ta zəba ka Yesu. ");
INSERT INTO meq_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tsa na, Yesu a dazlay mətsikatay, a gwaɗatay: «Nəkurom neheye faya ka pumay zləm a wu nakə faya na tsikakumeye na, wu nakə na dzaŋga mə Ɗerewel i Mbəlom aye na, ɓa kə ge bo bəgom tsɨy.» ");
INSERT INTO meq_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ndo niye hay tebiye tə tsik faya, tə gwaɗ: «Ndo nakay na, lele.» Ada Bazlam i Yesu niye a tsikatay aye na, bazlam niye ŋgwalak eye a gatay hərɓaɓəkka. Tə gwaɗ: «Neŋgeye na, wawa i Yusufa na gwaɗ bəɗa?» ");
INSERT INTO meq_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu a gwaɗatay sa: «Ta deɗek, nəkurom ka tsikumeŋeye bazlam i dzeke nakay anaŋ aye. Ka gweɗumeŋeye: “Nəkar ndo mətəme ha ndo, təma ha bo yak aye tey.” Nəmaa tsəne wu neheye ka ge ma Kafernahum aye. Anəke na, ge ma gəma yak andza neheye ka ge ma Kafernahum aye dərmak.» ");
INSERT INTO meq_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tsa na, a gwaɗatay sa: «Sərum ha ndo məɗe ha bazlam i Mbəlom na, kwa nəte ta təma na ma gəma ŋgay nakə tə wa na mə ɗəma aye bay. ");
INSERT INTO meq_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Sa tsa na, sərum ha ahəl i Eliya ndo i maslaŋ i Mbəlom na, madakway i ŋgwas hay haladzay ma Israyel. Ahəl niye na, yam kə pa bay məve mahkar ta kiye məkwa. Mandərzlaŋ bagwar eye a ge ka dala niye tebiye. ");
INSERT INTO meq_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Madakway i ŋgwas hay andaya ma Israyel, ane tuk na, Mbəlom kə slər Eliya a gay i madakway i ŋgwas hay kwa nəte bay tebiye. Ane tuk na, Mbəlom a slər Eliya na, a gay i madakway i ŋgwas wuray a ndzawa ka dala i Səripta ma gəma i Sidoŋ. ");
INSERT INTO meq_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ahəl i Elize ndo məɗe ha bazlam i Mbəlom na, ndo madəgwaɗa eye hay haladzay ka dala i Israyel. Mbəlom kə mbəl tay ha ndo niye madəgwaɗa eye hay kwa nəte bay, a mbəl ha na, Namaŋ ndo i gəma i Siri.» ");
INSERT INTO meq_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ndo niye hay tebiye mə gay i maɗuwule me aye tə tsəne bazlam ŋgay niye na, a ndalatay haladzay. ");
INSERT INTO meq_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tsa na, tə lətse, tə pay həlay a Yesu. Ti ye ahaya abəra ma wuzlahgəma, ti ye ha a gər i mahəmba i Nazaret. Gəma i Nazaret ma geye na, ka mahəmba eye niye. Tə tsal ha a ɗəma na, hərwi madzəgəɗa ahaya a zavay. ");
INSERT INTO meq_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ane tuk na, Yesu a ye mə walaŋ tay tsəriɗ tsəriɗ a ye ŋgway. ");
INSERT INTO meq_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ma dəba eye na, Yesu a lətse a ye a Kafernahum. Kafernahum na, wuzlahgəma i Galile. Pat i mazəzukw bo na, pat pat a tətikawatay a ndo hay. ");
INSERT INTO meq_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ndo hay tə tsəne matətike ŋgay niye na, a gatay hərɓaɓəkka. Hərwi matətike ŋgay nakə a tətikatay aye ta məzlaɓ eye. ");
INSERT INTO meq_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Azlakwa bay mə gay i maɗuwule me niye na, ndoweye andaya gər a vuway. A wuda ta gədaŋ kələrra, a gwaɗ: ");
INSERT INTO meq_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Nəkar Yesu ndo i Nazaret, mey yak ka nəmay na, mey? Ka yaw na, mata dze may ha ɗaw? Nəkar way na, na sər ha lele: Nəkar na, ndo nakə tsəɗaŋŋa Mbəlom a sləraw aye!» ");
INSERT INTO meq_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tsa na, Yesu a gay me, a gwaɗay: «Ndza ɗikɗik! Dara abəra mə bo i ndo nakay!» Tsa na, fakalaw a kal ha ndo niye kame i ndo niye hay ɓərra. Tsa na, a ndohwaw abəra mə bo i ndo niye. Kə gay wuray a ndo niye kwa tsekweŋ bay. ");
INSERT INTO meq_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ka təv niye na, a gatay a ndo hay daɓək daɓək, hərɓaɓəkka. Tə gwaɗ mə walaŋ tay: «Eh! Eh! Nakay na, bazlam waray! Nakay i ŋgay na, ndo waray a tsik me ta məzlaɓ eye! A gatay me ta gədaŋ a məsəfəre lele bay eye hay na, tə gəsay me ada tə ndohwaw abəra mə bo ndo nakay aye!» ");
INSERT INTO meq_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Labara i Yesu a ɗa a zləm ma gəma niye tebiye. ");
INSERT INTO meq_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ma dəba eye na, Yesu a yaw abəra mə gay i maɗuwule me niye. A həl bo a ye a gay i Simoŋ. A ye naha na, mese i Simoŋ lele bay. Maraɓaraɓ a gay haladzay. Tsa na, tə gwaɗay a Yesu: «Maraɓaraɓ a gay a mese i Simoŋ, dzəna na tey!» ");
INSERT INTO meq_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu a lətse, a ye ka təv ŋgay. A ye naha na, a guɗuk faya. A ŋgərəz ka maraɓaraɓ niye ta gədaŋ. Tsa na, maraɓaraɓ niye a ndala abəra ka ŋgwas niye. Kwayaŋŋa a gatay mbəlok. ");
INSERT INTO meq_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ma dəba eye pat a dəɗ na, ndo hay tə həlayaw ndo neheye ɗəvats mə bo tay tebiye a Yesu. Kwa slala i ɗəvats waray waray na, tə həlayaw a Yesu. Yesu a pa fataya həlay nəte nəte tay eye. A mbəl tay ha abəra ma ɗəvats tay niye hay. ");
INSERT INTO meq_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","A həhar fakalaw hay abəra mə bo i ndo hay haladzay dərmak. Fakalaw niye hay ta wuda, tə gwaɗay: «Nəkar na, Wawa i Mbəlom!» Ane tuk, na, Yesu a ŋgərəz fataya. A gwaɗatay: «Kâ tsikum me bay.» Hərwi nəteye na, tə sər ha Yesu na, Kəriste. ");
INSERT INTO meq_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ɗəre a tsaɗa kwayaŋŋa na, Yesu a lətse a ndohwaw, a yaw abəra mə gay. A ye dəreŋ abəra ma wuzlahgəma. A ye a təv nakə ndəray andaya mə ɗəma bay aye. Ndo hay haladzay ta zəba ɗəre na, ta ŋgatay a Yesu bay. Tsa na, ta pəla na. Tə huta na Yesu na, a satay Yesu mâ ye fataya abəra bay, mâ ndza ta nəteye huya. ");
INSERT INTO meq_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ane tuk na, Yesu a gwaɗatay: «Na diye a gəma mekeleŋ eye hay, na ta ɗatay ha Labara Ŋgwalak eye i Bəy i Mbəlom dərmak. Mbəlom a sləra ga ahaya na, hərwiye.» ");
INSERT INTO meq_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tsa na, a lətse, a ye a ɗawa ha bazlam i Mbəlom mə gay i maɗuwule me neheye ka dala i Yahuda aye. ");
INSERT INTO meq_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Pat wuray na, Yesu a ye ka me i dəlov i Genesaret. A ye na, a lətse ka me i dəlov i Genesaret niye. Ka təv eye niye na, ndo hay haladzay faya ta lawariye na hərwi mətsəne bazlam i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesu a ŋgatay a kwalalaŋ i yam hay sulo ka ɗakal. Ndo məgəse kəlef hay tə mbəzlaw abəra mə ɗəma, faya ta bariye gadaŋ tay hay. ");
INSERT INTO meq_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tsa na, Yesu a ye, a tsal a kwalalaŋ i yam neŋgeɗ. Kwalalaŋ i yam niye na, i Simoŋ. Tsa na, a gay amboh a Simoŋ, a gwaɗay: «Amboh, həndzəɗ ga ha tsekweŋ a bəra ka ɗakal.» Simoŋ a ge ha andza niye. Yesu a ndza a kwalalaŋ i yam niye na, a pa bo ka matətikatay bazlam i Mbəlom a ndo niye hay. ");
INSERT INTO meq_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","A ndəv ha matətikatay a ndo hay na, a gwaɗay a Simoŋ: «Həndzəɗ ha kwalalaŋ i yam dəreŋ, a təv nakə sɨɗuk aye, a wuzlah i dəlov. Ka ye ha na, nəkar ta ndo məpaka bəzay yak hay kalum gadaŋ kurom hay a yam hərwi məgəse kəlef.» ");
INSERT INTO meq_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoŋ a mbəɗay faya, a gwaɗay: «Ŋgalaka, nəmaa ye gər haladzay ta həvaɗ hərwi məgəse kəlef ada kwa nəte nəmaa gəs bay. Aya ane nəkar ka tsikeŋ, nâ ge sa na, na kaliye gadaŋ hay a yam.» ");
INSERT INTO meq_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tsa na, tə kal gadaŋ tay niye hay a yam. Tə kal a ɗəma na, kəlef hay ti ye a gadaŋ tay niye hay haladzay. Gadaŋ tay niye hay a dazlay a maŋgəzlehe ndərtsətse hərwi kəlef kə rah a ɗəma ka zal naha. ");
INSERT INTO meq_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tsa na, tə gatay naha wiyaw a mandala tay neheye mə kwalalaŋ i yam neŋgeɗ aye hərwi ada tâ yaw tâ dzəna tay tey. Mandala tay niye hay ti yaw. Tə vaha ahaya gadaŋ niye hay abəra ma yam. Tə rah ha, kwalalaŋ i yam niye hay sulo aye tə kəlef. Kwalalaŋ i yam niye hay ta sər masəleme a huɗ i yam hərwi maraha eye hay haladzay. ");
INSERT INTO meq_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoŋ Piyer a ŋgatay andza niye na, a ye a dəkway gurmets a huvo a Yesu. A gwaɗay: «Do wu yak abəra ka təv ga Bəy Maduweŋ, hərwi neŋ na, ndo i mezeleme!» ");
INSERT INTO meq_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoŋ a dzədzar haladzay. Ndo niye hay nəteye dziye ta dzədzar andza Simoŋ dərmak. Ta dzədzar na, hərwi kəlef niye tə gəs haladzay aye. ");
INSERT INTO meq_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Andza niye, ndo məpay bəzay a Simoŋ, ta dzədzar dərmak. Ndo neheye tə paway bəzay a Simoŋ aye na, Yakuba ta Yuhana wawa i Dzebede hay. Ane tuk na, Yesu a gwaɗay a Simoŋ: «Kâ dzədzar bay. Nəkar na, ka ta həlaweye ndo hay ka təv ga.» ");
INSERT INTO meq_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tsa na, tə ma tay ahaya kwalalaŋ i yam tay hay ka ɗakal. Tə gər ha wu tay niye hay tebiye tə pay bəzay a Yesu. ");
INSERT INTO meq_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pat wuray na, Yesu a ye a wuzlahgəma wuray. Ahəl nakə neŋgeye mə ɗəma aye na, paf ndo wuray madəgwaɗa eye a ye naha. A ŋgatay a Yesu na, a kal ha bo kame ŋgay. Dəbuz daʼar ka dala, a gay amboh a Yesu, a gwaɗay: «Ŋgalaka, taɗə kə saka na, ka sliye faya matəre ga ha tsəɗaŋŋa.» ");
INSERT INTO meq_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu a tsəne andza niye na, a nduɗa ha həlay ŋgay, a lamay. Tsa na, a gwaɗay: «A seŋ na, təra tsəɗaŋŋa!» Kwayaŋŋa ɗəvats i madəgweɗe a ndala abəra ka ndo niye. ");
INSERT INTO meq_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu a gwaɗay: «Tsəne lele: Kâ tsik wu nakay a ndəray bay. Ane tuk na, do ta bəzay ha bo a ndo məvəlaway wu a Mbəlom ada vəl wu nakə Musa a tsik aye hərwi məɗatay ha a ndo hay tebiye na, ka təra tsəɗaŋŋa.» ");
INSERT INTO meq_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kwa andza niye bəbay na, labara i Yesu a ɗa a zləm haladzay. Ndo hay haladzay tə hayawa gər ka təv ŋgay hərwi məpay zləm a bazlam ŋgay. Siye hay ti yawa ka təv ŋgay hərwi ada mâ mbəl tay ha abəra ma ɗəvats tay hay. ");
INSERT INTO meq_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ane tuk na, Yesu na, a yawa a təv neheye dəreŋ aye. A yawa a ɗəma mata ɗuwule me. ");
INSERT INTO meq_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pat wuray na, Yesu faya ma tətikateye a ndo hay. Farisa hay ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye, nəteye andaya dərmak. Ti yaw na, ma gəma neheye ka dala i Galile aye tebiye, ma Zerozelem ada abəra ma Yahuda. Yesu a mbəlawa tay ha ndo i ɗəvats hay ta gədaŋ i Bəy Maduweŋ Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ahəl nakə Yesu faya ma tətikateye a ndo hay aye na, ndo hay, tə zlay naha ndo wuray matəra eye madzawa eye ka sləlah. Ta pəla tsəveɗ mede ha məpe kame i Yesu. ");
INSERT INTO meq_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ane tuk na, ta huta tsəveɗ mede məfələkwa ha a gay bay, hərwi ndo hay haladzay ka tsəveɗ. Tsa na, tə tsal ka gər i gay niye. Tə sləl bəɗ ɗəgerger tə Yesu. Tə mbəzla ha ndo niye ta sləlah eye dzay tə walaŋ i ndo niye hay kame i Yesu. ");
INSERT INTO meq_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu a ŋgatay a mədzal gər i ndo niye hay na, a gwaɗay a ndo matəra eye niye: «Dzam ga, na pəsaka ha mezeleme yak hay.» ");
INSERT INTO meq_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ndo mədzaŋgawa bazlam i Mbəlom mapala eye ta Farisa hay tə tsəne bazlam i Yesu niye na, tə tsik mə walaŋ tay, tə gwaɗ: «Nakay na, ndo waray i ŋgay a tsalay ka gər a Mbəlom aye! Way nakə ɗa məpəsay ha mezeleme a ndo na, way. Maa sla məpəsay ha mezeleme a ndo na, Mbəlom nəte ŋgweŋ bəna, way?» ");
INSERT INTO meq_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tsa na, Yesu a sər wu nakə tə dzala mə gər tay aye, a gwaɗatay: «Ka dzalum andza niye mə gər kurom na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Maa da me məgweɗe: “Mezeleme yak kə pəsa” na, waray, kəgəbay “Lətse, do” na, maa da me mə ɗəma na, waray? ");
INSERT INTO meq_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","A seŋ na, sərum ha neŋ Wawa i Ndo na, gədaŋ ga andaya məpəsatay ha mezeleme a ndo hay ka məndzibəra.» Tsa na, a gwaɗay a ndo matəra eye: «Faya na gwaɗakeye, lətse, zla sləlah yak do a mətagay!» ");
INSERT INTO meq_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kwayaŋŋa ndo niye a lətse hurum kame i ndo niye hay tebiye. A zla sləlah ŋgay niye tə zla ahaya. A ye kame i ndo niye hay duwak duwak tə mazambaɗay a Mbəlom. A ye a mətagay. ");
INSERT INTO meq_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ndo niye hay mbərzəzza aye tə ŋgatay andza niye na, a gatay hərɓaɓəkka. Ta zambaɗay a Mbəlom. Tə dzədzar haladzay ada tə gwaɗ: «Bəgom na, ka ŋgatakway a wu məge masuwayaŋ eye!» ");
INSERT INTO meq_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ma dəba eye na, Yesu a lətse a yaw abəra mə gay niye. Yesu faya ma diye na, a ŋgatay a ndo matsekele dzaŋgal mandza eye ka təv i məsler ŋgay. Ndo niye na, tə zalay Levi. Yesu a gwaɗay: «Dara, peŋ bəzay!» ");
INSERT INTO meq_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tsa na, Levi a lətse, a gər ha wu ŋgay hay tebiye, a pay bəzay a Yesu. ");
INSERT INTO meq_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ma dəba eye ti ye a gay i Levi. Ti ye naha na, Levi a datay wu mənday. Tə nda wu mənday niye na, nəteye haladzay tə ndo matsekele dzaŋgal ha ada tə siye i ndo hay haladzay. ");
INSERT INTO meq_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisa hay ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye tə ŋgatay a Yesu faya ma ndiye ɗaf ta ndo i mezeleme hay na, tə tsik faya wu nakə lelebay aye. Tə gwaɗatay a gawla i Yesu hay: «Ka ndayum wu mənday ada ka sum wu ka təv manəte eye ta ndo matsekele dzaŋgal hay ada ta ndo i mezeleme hay na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu a tsəne bazlam tay niye na, a mbəɗatay faya, a gwaɗatay: «Ndo neheye wuray a gatay bay nəteye zayzay aye na, ta pəliye ndo i sidem bay. Mata pəle ndo i sidem na, ndo neheye ɗəvats eye hay aye. ");
INSERT INTO meq_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na yaw məzalatay a ndo neheye tə gwaɗay a gər nəteye ŋgwalak eye hay aye bay, ane tuk na, məzalatay a ndo i mezeleme hay ɗuh, hərwi ada tâ mbəɗa ha mede tay.» ");
INSERT INTO meq_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ta tsətsah ka Yesu, tə gwaɗay: «Gawla i Yuhana ta gawla i Farisa hay tə gawa daliyam ada ta ɗuwulawa. Ane tuk na, gawla yak hay i tay tə ndayawa wu mənday ada tə sawa wu məse na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu a mbəɗatay faya: «Ka dzalum na, nəteye na, ta giye daliyam ɗaw? Ta giye bay hərwi nəteye na, andza mə magurlom i məzle dahəlay. Ahəl nakə zal i dahəlay ka təv tay mba aye na, ndo neheye mazala eye a magurlom i məzle dahəlay na, ta giye daliyam bay. ");
INSERT INTO meq_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ane tuk na, pat eye ma slaweye na, ta gəsiye fataya abəra zal i dahəlay niye. Pat eye niye na, ta giye daliyam tuk.» ");
INSERT INTO meq_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu a tsikatay dzeke nakay sa. A gwaɗatay: «Ɗaɗa ndəray ma ɗəsiye petekeɗ weɗeye mətepe ka petekeɗ guram eye bay. Hərwi taɗə ta tapa petekeɗ weɗeye ka guram eye na, petekeɗ weɗeye ma ŋgərɗiye ha petekeɗ guram eye niye. Ta nasiye ha petekeɗ weɗeye. Petekeɗ weɗeye ta guram eye ta diye ka bo bay. ");
INSERT INTO meq_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Sa na, ndo ma mbəɗiye guzom lelem eye a gwezem i həzlay guram eye bay na, ka sərum təbəɗew? Hərwi ta mbəɗa a ɗəma na, guzom niye lelem eye kə kwasa na, həzlay guram eye ma ndohwiye. Guzom dərmak səktih ma mbəɗiye ka dala ada gwezem ma nasiye. ");
INSERT INTO meq_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ane tuk na, guzom lelem eye ta mbəɗiye na, a gwezem i həzlay weɗeye dərmak. ");
INSERT INTO meq_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Sərum ha ndo kə sa guzom makwasa eye na, ma dəba eye na, ma siye lelem eye sa bay. Hərwi tə gwaɗ: “Guzom makwasa eye na, lele.”» ");
INSERT INTO meq_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pat i mazəzukw bo na, Yesu ta gawla ŋgay hay ti ye ta guvah wuray. Ma guvah eye niye tə ge a ɗəma na, wuye andaya tə zalay bəle. Gawla i Yesu hay tə həɓ wu niye. Ta gugwah na wu niye ada tə nda. ");
INSERT INTO meq_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Siye i Farisa hay ta ŋgatatay. Tsa na, tə gwaɗatay: «Ka gum wu nakə bazlam i Mbəlom mapala eye a ge faya me pat i mazəzukw bo aye na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu a mbəɗatay faya a gwaɗatay: «Ɗaɗa ka dzaŋgum wu nakə Davit a ge ahəl niye aye təbəɗew? May a wur faya ta ndo ŋgay hay. ");
INSERT INTO meq_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tsa na, a ye, a fələkwa a madzawadzawa i məɗəslay ha gər a Mbəlom. A ye naha, a zla makwala nakə tə vəlay a Mbəlom aye. A nda. A vəlatay a ndo ŋgay hay dərmak, tə nda. Bazlam i Mbəlom mapala eye a vəl tsəveɗ ka mənde na, a ndo məvəlaway wu a Mbəlom ɗekɗek bəɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu a gwaɗatay sa: «Maa ləvay gər a pat i mazəzukw bo na, Wawa i Ndo.» ");
INSERT INTO meq_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pat eye andaya pat i mazəzukw bo na, Yesu a ye a gay i maɗuwule me. A ye naha a pa bo ka matətikatay a ndo hay. Mə ɗəma na, ndoweye andaya həlay i mənday ŋgay maməta eye. ");
INSERT INTO meq_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mə gay i maɗuwule me niye na, ndo mədzaŋgawa bazlam i Mbəlom mapala eye ta Farisa hay nəteye andaya. Faya ta zəbiye ka Yesu. Tə dzala mə gər tay, tə gwaɗ: «Zəbakwa faya lele, ŋgatay ma mbəliye ha ndo nakay maməta həlay eye pat i mazəzukw bo ɗaw?» Tə tsik andza niye na, hərwi məhəle faya bəra suwat. ");
INSERT INTO meq_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ane tuk na, Yesu a sər ha mədzal gər tay. A gwaɗay a ndo niye həlay ŋgay maməta eye: «Lətse, do, lətse ka niye, kame i ndo hay tebiye.» Ndo niye a lətse ka niye. ");
INSERT INTO meq_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tsa na, Yesu a gwaɗatay: «Na tsətsahiye fakuma: Bazlam kway mapala eye a vəl tsəveɗ məge na, mey? A gwaɗ: Gum ŋgwalak pat i mazəzukw bo tsukuɗu, gum na, seweɗ ɗaw? Məmbəle ha ndo pat i mazəzukw bo tsukuɗu məgər ha mâ mət ɗaw?» Ane tuk na, ta mbəɗay faya bay. ");
INSERT INTO meq_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesu a zəba fataya. Tsa na, a gwaɗay a ndo niye həlay maməta eye «Nduɗa ha həlay yak.» A nduɗa ha na, həlay ŋgay a mbəl a təra lele suwuɗ suwuɗ. ");
INSERT INTO meq_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tsa na, a ndalatay a ndo mədzaŋgawa bazlam i Mbəlom mapala eye ta Farisa hay. Tə tsik ma walaŋ tay ta hutiye tsəveɗ ka məkəɗe Yesu na, kəkay. ");
INSERT INTO meq_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ahəl niye Yesu a ye, a tsal a tsaholok hərwi maɗuwule me. A ndza ma tsaholok niye huyup ka maɗuwulay naha me a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ɗəre a tsaɗa na, a zalatay a gawla ŋgay hay ka təv ŋgay. Ti ye naha. Tsa na, a pala mə walaŋ tay niye ndo kuro gər eye sulo. A zalatay ndo i maslaŋ hay. ");
INSERT INTO meq_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nəteye na: Simoŋ nakə a pa faya məzele Piyer aye, ta malamar ŋgay Aŋdəre, Yakuba ta Yuhana, Filip ta Bartelemi, ");
INSERT INTO meq_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mata ta Tomas, Yakuba wawa i Alfe, Simoŋ ndo məge vəram hərwi dala ŋgay, ");
INSERT INTO meq_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda wawa i Yakuba, Yudas Iskariyot ndo məge ɗaf ka Yesu. ");
INSERT INTO meq_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu ta gawla ŋgay niye hay, tə mbəzlaw abəra ma tsaholok niye. Ti yaw tə ndza ka təv eye andaya barbara eye fatata. Gawla ŋgay hay ka təv eye niye haladzay. Ndo hay haladzay mbərzəzza andaya ka təv eye niye dərmak. Ndo niye hay na, ti yaw abəra kwa ma Zerozelem ka dala i Yahuda ada mə Tir ta Sidoŋ gəma neheye tə mbay naha a bəlay aye. ");
INSERT INTO meq_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ndo niye hay ti yaw ka təv ŋgay na, mata pay zləm a bazlam ŋgay ada hərwi mâ mbəl tay ha abəra ma ɗəvats tay hay wal wal. Ndo neheye məsəfəre lele bay eye hay mə bo tay aye na, kə mbəl tay hay. ");
INSERT INTO meq_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kwa way a pəla tsəveɗ məlamay nets tsa hərwi gədaŋ a yaw abəra mə bo ŋgay. Ndo neheye ta lamay aye na, a mbəl tay ha tebiye. ");
INSERT INTO meq_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu a zəba ka gawla ŋgay hay na, a gwaɗatay: «A nəkurom ndo i mətawak hay, ŋgwasum hərwi Bəy i Mbəlom na, i kurom. ");
INSERT INTO meq_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","A nəkurom neheye may a wur fakuma anəke aye, ŋgwasum hərwi Mbəlom ma vəlakumeye wu nakə a sakum aye. A nəkurom neheye faya ka tuwumeye anəke aye, ŋgwasum hərwi ka ta ŋgwasumeye. ");
INSERT INTO meq_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nəkurom neheye ndo hay faya ta gakum eye ɗəretsətseh aye, kwa ta kal kurom ha, kwa ta tsaɗakum, kwa ta tsik fakuma wu nakə lelebay eye hərwi nakə ka dzalum ha Wawa i Ndo aye na, ŋgwasum. ");
INSERT INTO meq_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Aza pat nakə wu neheye ta ndzakum a gər aye na, mbərzlum tə məŋgwese eye hərwi Mbəlom ma ta vəlakumeye magogoy kurom bagwar eye mə mbəlom. Aya ane, sərum ha na, bəba təte tay hay tə gatay a ndo məɗe ha bazlam i Mbəlom hay na, andza niye. ");
INSERT INTO meq_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","A nəkurom ndo i zlele hay, ɗəretsətseh ka gər kurom hərwi ɓa ka hutum magogoy kurom tsɨy. ");
INSERT INTO meq_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","A nəkurom neheye hawa i wu a gakum bay aye wu kurom andaya anəke haladzay aye, ɗəretsətseh ka gər kurom hərwi may ma ta wuriye fakuma. A nəkurom neheye faya ka ŋgwasumeye anəke aye, ɗəretsətseh ka gər kurom hərwi ka ta ndzumeye ta mədzal gər aye ada ka tuwumeye. ");
INSERT INTO meq_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","A nəkurom neheye ndo hay tə gwaɗ fakuma nəkurom ŋgwalak i ndo hay aye, ɗəretsətseh ka gər kurom. Hərwi bəba təte tay hay tə gwaɗawa ka ndo neheye tə gwaɗ nəteye ndo məɗe ha bazlam i Mbəlom aye ta səpatawa ndo hay ahəl niye na, andza niye.» ");
INSERT INTO meq_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Ane tuk na, na tsikakumeye a nəkurom neheye faya ka pumeŋeye zləm aye: Wuɗum ndo məne ɗəre kurom hay. Gumatay ŋgwalak a ndo neheye tə nakum ɗəre aye. ");
INSERT INTO meq_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pum ŋgama ka ndo neheye faya ta vəlakumeye mezeleme aye. Ɗuwulumay me a Mbəlom hərwi ndo neheye faya ta gakumeye ɗəretsətseh aye. ");
INSERT INTO meq_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","«Taɗə ndoweye kə faka ka maholom na, mbəɗay ha maholom i diye neŋgeɗ. Ndoweye ka buwa faka abəra kələmedze yak na, gər ha mâ zla na faya məkelkabo yak i huɗ aye. ");
INSERT INTO meq_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","«Ndo ka tsətsah fakaya wu na, vəlay ada taɗə ndoweye kə zla faka abəra wu yak na, kâ tsətsah faya bay. ");
INSERT INTO meq_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","«Ka gwaɗum ndo hay tâ gakum ŋgwalak na, gumatay ŋgwalak a ndo hay dərmak. ");
INSERT INTO meq_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Kâ wuɗum ndo neheye ta wuɗa kurom aye ɗekɗek bay. Taɗə ka wuɗum ndo neheye ta wuɗa kurom aye ɗekɗek na, ka dzalum na, ka hutumeye merəɓe kurom ɗaw? Kwa ndo i mezeleme hay ta wuɗa ndo neheye ta wuɗa tay ha aye dərmak! ");
INSERT INTO meq_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ada taɗə ka gumatay ŋgwalak a ndo neheye faya ta gakumeye ŋgwalak aye ɗekɗek na, ka dzalum na, ka hutumeye merəɓe kurom ɗaw? Kwa ndo i mezeleme hay na, tə ge andza niye. ");
INSERT INTO meq_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","«Taɗə ka vəlumateye wu a ndo neheye ka sərum ha nəteye ta sliye məmakum ha aye na, ka dzalum na, ka hutumeye merəɓe kurom ɗaw? Kwa ndo i mezeleme hay tə vəlawa wu na, a ndo i mezeleme hay andza nəteye hərwi ada tâ matay ha andza nakə tə vəlatay aye! ");
INSERT INTO meq_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ɗuh bay, wuɗum ndo məne ɗəre kurom hay! Gumatay ŋgwalak. Ka vəlumatay wu na, kâ gwaɗum tâ makum ha a ɗəma bay. Mbəlom ma ta vəlakumeye a ɗəma magogoy kurom na, haladzay. Nəkurom ka ta tərumeye wawa i Mbəlom Fetek. Hərwi neŋgeye na, a wuɗa ndo i həzay hay ta ndo i seweɗ hay dərmak. ");
INSERT INTO meq_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tərum ndo məge ŋgwalak hay andza Bəba kurom Mbəlom, neŋgeye ndo i ŋgwalak. ");
INSERT INTO meq_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Kâ gum sariya ka ndo bay. Mbəlom dərmak ma gakumeye sariya bay. Kâ rawum me ka ndo hay bay. Mbəlom bəbay ma rawiye fakuma me bay. Pəsumatay ha mənese a ndo hay, Mbəlom dərmak ma pəsakumeye ha mənese kurom. ");
INSERT INTO meq_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","«Vəlumatay wu a ndo hay, Mbəlom dərmak ma vəlakumeye. Mbəlom ma vəlakumeye na, ma rahakumeye ha lele. Ma dzədzakakumeye ha a gwezem kurom hay na, madzədzeke madzədzeke. Mbəlom ma ləvakumeye wu tə wu nakə ka ləvawumatay ha wu a ndo hay aye dərmak.» ");
INSERT INTO meq_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu a tsikatay ta dzeke mekeleŋ eye sa, a gwaɗatay: «Guluf ma sliye məgəsay həlay a guluf neŋgeɗ ɗaw? Nəteye salamay tay eye ta dəɗiye a bəɗ. ");
INSERT INTO meq_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ndo nakə faya ma tətikiye wu aye na, ma ziye ndo matətikay wu bay. Ane tuk na, ndo nakə faya ta tətikay wu kə sər tsɨy na, ma təriye andza ndo matətikay wu.» ");
INSERT INTO meq_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","A gwaɗatay sa: «Nəkar na, ka ŋgatay a tsakwal mə ɗəre i malamar yak. Ane tuk na, mayako nakə mə ɗəre yak aye ka ŋgatay bay na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kəkay, ka sliye məgweɗe: “Malamar ga, ehey nâ zlaka ahaya tsakwal abəra mə ɗəre yak” na, ɗuh i yak aye mayako gəlawwa ka ŋgatay bay na, kəkay? Nəkar ndo i bəbərek, lah faya məzle ahaya mayako abəra mə ɗəre yak təday ada ka ŋgateye a ɗəre kwetseh kwetseh. Ka zlaya ahaya tsakwal abəra mə ɗəre i malamar yak tuk.» ");
INSERT INTO meq_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesu a gwaɗatay sa: «Sərum ha na, dərizl i gərɗaf lele eye na, ma wiye hohway i dərizl i gərɗaf nakə lele bay aye bay, andza niye dərizl i gərɗaf lele bay eye ma wiye hohway i gərɗaf nakə lele eye bay aye. ");
INSERT INTO meq_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ka sərakwa ka bo abəra dərizl i gərɗaf hay ta hohway tay hay. Ka slumeye faya maŋgəle hohway i gurov abəra ka wuradak bay ada ka slumeye maŋgəle hohway i təroz abəra ka dzəgew bay. ");
INSERT INTO meq_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sərum ha na, ndo nakə ŋgwalak eye na, ma giye wu ŋgwalak eye hay hərwi mə ɗərev ŋgay na, wu neheye ŋgwalak eye dərmak. Ndo nakə seweɗ eye na, ma giye wu neheye seweɗ eye hərwi ɗərev ŋgay maraha eye tə wu neheye seweɗ eye. Hərwi kwa way a ndohwa ahaya na, wu nakə maraha eye mə ɗərev ŋgay aye.» ");
INSERT INTO meq_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesu a gwaɗatay sa: «Ka zalumeŋ a neŋ “Bəy Maduweŋ, Bəy Maduweŋ” na, hərwi mey? Ada wal faya ka gumeye wu nakə na tsikakum aye bay sa tuk na, kəkay? ");
INSERT INTO meq_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tsənum, na ɗakumeye ha ndo nakə a peŋ bəzay ta ɗeɗik aye. Neŋgeye na, a pay zləm a bazlam ga lele. Kə pay zləm na, a ge ha məsler tə bazlam nakə a tsəne aye. ");
INSERT INTO meq_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Neŋgeye a ndzəkit bo na, ta ndo nakə a say maɗəzle gay aye. A dazlay na, a la na mədok i gay sɨɗuk lele. A ndəv ha məle na, a ɗəzla ahaya mədok i gay ŋgay niye ma bəɗ tə kwar lele. Tsa na, a ŋgar na gay niye tuk. Yam a pa na, mazaw a yaw ŋgəf ka gay ŋgay niye na, ɗaɗa a mba faya mambəzle ha bay, hərwi maɗəzla eye lele. ");
INSERT INTO meq_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Aya ane tuk na, ndo nakə a tsəne bazlam ga ada kə ge ha məsler bay na aye, neŋgeye dərmak a ndzəkit bo ndo nakə a say məge gay aye. Ane tuk na, a dazlay kwayaŋŋa ze məle na mədok eye. A pa na mədok eye təhas ka dala tsa. A ndəv na, yam a pa. Mazaw i magayam hay ŋgəf ti yaw ka gay niye na, kwayaŋŋa bərem a mbəzl, tsekək yam a həl na gay niye. A mbəzl na, liyeh liyeh kwa tsekweŋ ka ləkaw bay.» ");
INSERT INTO meq_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu a ndəv ha mətsikatay a ndo niye hay ka təv ŋgay aye na, a həl bo a ye a Kafernahum. ");
INSERT INTO meq_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ma Kafernahum na, ndo i Roma wuray andaya neŋgeye bagwar i sidzew. Ndo i məsler ŋgay andaya a wuɗa na haladzay. Ndoweye niye na, bo a wur faya haladzay. ");
INSERT INTO meq_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Bagwar i sidzew niye a tsəne ndo hay faya ta tsikiye ka Yesu na, a slər ndo hay mə walaŋ i madugula i Yahuda hay. A slər tay ha na, hərwi ada tâ zalayaw mâ yaw mâ mbəl ha ndo i məsler ŋgay niye. ");
INSERT INTO meq_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ndo niye hay ti ye, tə ndisl ka təv i Yesu na, ta dazlay məgay amboh haladzay. Tə gwaɗay: «Bagwar i sidzew may a gwaɗaka: “Dara mbəleŋ ha ndo i məsler ga tey.” Ka ye, ka dzəna na ndoweye niye na, lele. ");
INSERT INTO meq_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Neŋgeye na, ndo lele eye. A wuɗa slala kway haladzay. Ada maa ɗəzlakway gay i maɗuwule me na, neŋgeye.» ");
INSERT INTO meq_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesu a tsəne andza niye na, a lətse, ti ye ka bo dziye. Mazlambar nəteye bəse tə gay i bagwar i sidzew. Bagwar i sidzew niye a sləraw ndo hay ka təv i Yesu. Ti yaw tə gwaɗay: «Bəy Maduweŋ, tə gwaɗaka na, kâ ye gər madayaw sa bay. Neŋ na sla ɗa, nəkar kâ ye a gay ga bay. ");
INSERT INTO meq_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Hərwi niye, neŋ həreŋ na sla mede naha ka təv yak bay. Ane tuk na, ka tsik bazlam yak nəte na, ndo i məsler ga ma mbəliye segey. ");
INSERT INTO meq_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Neŋ na, faya na rəhay ha gər a bagwar ga ada sidzew ga hay ta rəheŋ ha gər dərmak. Na gwaɗay a ndo nəte mə walaŋ tay “Do!” na, ma diye. Na gwaɗay a ndo neŋgeɗ “Dara!” na, ma deyeweye. Na gwaɗay a beke ga “Ge nakay!” na, ma giye.» ");
INSERT INTO meq_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu a tsəne bazlam i bagwar i sidzew niye na, a yay a gər lele. A mbəɗa me a diye i ndo neheye ta zəŋgal naha aye. A gwaɗatay: «Sərum ha na, ɗaɗa neŋ na huta slala i mədzal gər nakay bay, kwa ma Israyel.» ");
INSERT INTO meq_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tsa na, ndo neheye tə sləra tay ahaya aye ta mbəɗa gər a gay i bagwar i sidzew niye. Ti ye naha na, ndo i məsler i sidzew niye kə mbəl tsɨy. Neŋgeye zay zay! ");
INSERT INTO meq_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ma dəba eye na, Yesu a ye a gəma eye andaya tə zalay Nay. Gawla ŋgay hay tə ndo hay haladzay tə pay bəzay. ");
INSERT INTO meq_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ahəl nakə mazlambar ta ndisliye ta fələkwiye a wuzlahgəma niye na, tə dzəgər ta ndo hay faya ta zliye mədahaŋ ta diye ha ka me tsəvay. Maa mət na, wawa i madakway i ŋgwas wuray. Wawa ŋgay na, nəte eye niye. Ndo i gəma niye haladzay tə laka na ŋgwas niye ka ɗa tsəvay. ");
INSERT INTO meq_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yesu a ŋgatay na, madakway i ŋgwas niye a gay mə bo, a gwaɗay: «Kâ tuwa sa bay.» ");
INSERT INTO meq_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tsa na, a ye a lamay a hubok niye faya ta zliye ha mədahaŋ aye. Ndo məzle mədahaŋ hay tə lətse. Yesu a gwaɗ: «Gawla, faya na gwaɗakeye, lətse!» ");
INSERT INTO meq_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mədahaŋ niye a lətse, a ndza. Tsa na, a dazlay a mətsike me. Yesu a zla na a vəlay a may ŋgay. ");
INSERT INTO meq_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ndo niye hay tebiye ka təv eye niye ta dzədzar. Nəteye tebiye ta zambaɗay a Mbəlom, tə gwaɗ: «Ndo məɗe ha bazlam i Mbəlom bagwar eye ki yaw a walaŋ kway! Mbəlom ki yaw madzəne ndo ŋgay hay.» ");
INSERT INTO meq_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Wu niye Yesu a ge aye a ɗa zləm ka dala i Yahuda tebiye ta dala neheye a mbay naha aye. ");
INSERT INTO meq_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Gawla i Yuhana hay ta təkər wu neheye Yesu a ge aye a Yuhana. Yuhana a tsəne na, a zal ndo hay mə walaŋ i gawla ŋgay niye hay sulo. ");
INSERT INTO meq_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tsa na, a slər tay ha ka təv i Bəy Maduweŋ Yesu. A slər tay ha na, tâ ye tâ tsətsah faya, tâ gwaɗay: «Nəkar na, Kəriste nakə ma deyeweye aye ɗaw? Kəgəbay nəmaâ həba ndo mekeleŋ ɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Gawla i Yuhana niye sulo eye ti ye. Tə ndisl ka təv i Yesu na, tə gwaɗay: «Yuhana madzəhuɓe ndo a yam a sləramaya ahaya ka təv yak matsətsehe fakaya, a gwaɗ nəmaâ gwaɗaka: Nəkar na, Kəriste nakə ma deyeweye aye ɗaw? Kəgəbay nəmaâ həba ndo mekeleŋ ɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ahəl eye niye, Yesu faya ma mbəliye tay ha ndo hay haladzay abəra ma ɗəvats ada tə bo nakə a wurawa fataya aye. A mbəl tay ha gər mavuwe hay, a həndəkatay na ɗəre a guluf hay. ");
INSERT INTO meq_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tsa na, Yesu a mbəɗatay ka bazlam i ndo niye hay Yuhana a slər tay naha ka təv ŋgay aye tuk, a gwaɗatay: «Gwaɗumay na, guluf hay tə ŋgatay a ɗəre, ndo matəra eye hay ti ye lele, ndo madəgwaɗa eye ta mbəl suwuɗ suwuɗ, mandək hay tə tsəne zləm, mədahaŋ hay ta lətsew a sifa, ndo i mətawak ta tsəne Labara Ŋgwalak eye.» ");
INSERT INTO meq_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yesu a gwaɗatay sa: «Məŋgwese ka gər i ndo nakə kə gər ha mədzal gər abəra ka neŋ bay aye!» ");
INSERT INTO meq_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Gawla i Yuhana hay ti ye wu tay na, Yesu a dazlay mətsike ka gər i Yuhana. A tsikatay a ndo hay haladzay, a gwaɗatay: «Ka yum a kəsaf mata zəbaw na, ka mey? Ka zəbumaw ka guzer nakə mətasl faya ma ɓəliye ha aye ɗaw? Aʼay andza niye bay. ");
INSERT INTO meq_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Aya ane kəla ka yum ka zəbumaw na, ka mey? Ka zəbumaw na, ka ndo malambaɗa bo eye tə petekeɗ lele eye ɗaw? Tsukuɗu kəkay? Ane tuk na, ndo neheye tə pa ka bo petekeɗ lele eye ada wu tay hay lele eye na, nəteye mandza eye na, mə gay i bəy hay. ");
INSERT INTO meq_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ka yum mata zəbaw na, ka wuye mey? Ka zəbumaw na, ka ndo məɗe ha bazlam i Mbəlom ɗaw? Ayaw, neŋgeye ndo məɗe ha bazlam i Mbəlom ada neŋ faya na gwaɗakumeye, neŋgeye a ze ndo məɗe ha bazlam i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yuhana na, ndo nakə tə watsa a Ɗerewel aye, Mbəlom a gwaɗ: “Neŋ na sləriye naha ndo məɗe ha bazlam ga kame yak. Ma lambaɗakeye na tsəveɗ.”» ");
INSERT INTO meq_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu a gwaɗatay sa: «Sərum ha na, mə walaŋ i ndo zezeŋ hay tebiye ndo nakə a ze Yuhana aye na, andaya bay. Ane tuk na, ndo nakə neŋgeye tsekweŋ makətsa eye ma Bəy i Mbəlom aye na, a ze Yuhana.» ");
INSERT INTO meq_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ndo hay tebiye tə pa zləm ka bazlam ŋgay, kwa ndo matsekele dzaŋgal hay. Hərwi tə sər wu nakə a tsik aye na, bazlam i Mbəlom deɗek. Ada Yuhana ka dzəhuɓ tay ha a yam deɗek. ");
INSERT INTO meq_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ane tuk na, Farisa hay ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye ta kal ha wu nakə a say a Mbəlom haɓe məge hərwi tay aye ada ta kərah Yuhana madzəhuɓe tay hay a yam. ");
INSERT INTO meq_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu a gwaɗatay sa: «Na ndzəkitiye tay hay ndo neheye bəgom aye na, tə mey? Na ndzəkitiye tay ha bo na, tə mey? ");
INSERT INTO meq_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ta ndzəkit bo na, ta wawa neheye mandza eye ka pəlaɗ nakə ndo hay tə hayawa faya gər aye. Siye hay faya ta wudatay naha a siye hay, tə gwaɗatay: “Nəmaa fakum naha fagam i məhetse, ka hatsum bay, nəmaa gakum naha dəmes i mədahaŋ na, ka tuwum bay.” ");
INSERT INTO meq_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Andza niye, Yuhana madzəhuɓe ndo a yam, a ndayawa wu mənday bay, a sawa guzom bay. Nəkurom ka gwaɗum: “Neŋgeye na, məsəfəre nakə ŋgwalak eye bay aye mə bo ŋgay.” ");
INSERT INTO meq_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Neŋ Wawa i Ndo na yaw, na nda wu mənday ada na sa wu məse, ka gwaɗum: “Zəbum ka ndo nakay. A dzala i ŋgay na, ka wu mənday ada ka məse guzom. Neŋgeye na, dzam i ndo matsekele dzaŋgal hay ta ndo i mezeleme hay.” ");
INSERT INTO meq_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ane tuk na, wawa i Mbəlom hay tebiye tə sər ha, metsehe i Mbəlom na, deɗek.» ");
INSERT INTO meq_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisa wuray a zalay a Yesu mata nde wu mənday mə gay ŋgay. Yesu a ye a gay i ndo niye. Ti ye naha na, ta dazlay a mənde wu mənday. ");
INSERT INTO meq_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma gəma niye na, ŋgwas wuray andaya mezeleme aye. A tsəne Yesu andaya mə gay i Farisa niye faya ta ndiye wu mənday na, a ye a gay i ndo niye. Dos ŋgay mə həlay maraha eye tə mal nakə a ze huŋŋa aye. ");
INSERT INTO meq_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","A ye naha, a lətse a dəba i Yesu bəse tə sik ŋgay hay. Tsa na, a tuwa ta yam ɗəre. A bara na sik i Yesu ta yam ɗəre ŋgay niye. Tsa na, a takaɗ na ta məkwets i gər ŋgay. A gəs na ka bo sik niye ada a mbəɗa faya mal ŋgay niye tuk. ");
INSERT INTO meq_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farisa niye a zalay a Yesu ka wu mənday aye a ŋgatay andza niye na, a tsik ma mədzele gər ŋgay, a gwaɗ: «Ndo nakay na, ndo məɗe ha bazlam i Mbəlom bay! Ŋgwas nakay faya ma tətaliye faya aye na, mezeleme eye. Ada ŋgwas nakay mezeleme eye na, a sər ha bəɗaw!» ");
INSERT INTO meq_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tsa na, Yesu a sər wu nakə Farisa niye a dzala aye. A gwaɗay a Farisa niye: «Simoŋ, a seŋ mətsikaka wu andaya.» Simoŋ a mbəɗay faya: «Tsik me, Miter.» ");
INSERT INTO meq_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu a gwaɗay: «Ndoweye hay andaya sulo. Ndoweye niye hay sulo aye na, gwedere i ndo fataya. Ndo neŋgeɗ na, ma hamiye kwar i suloy temerre zlam. I ndo neŋgeɗ ma hamiye suloy kuro kuro zlam. ");
INSERT INTO meq_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ane tuk na, ndo neheye sulo aye na, tə sla məheme gwedere i ndo niye bay. Ndo niye a gəratay ha gwedere ŋgay a nəteye neheye sulo aye tebiye.» Yesu a təkəray andza niye na, a gwaɗay: «Mə walaŋ tay neheye sulo aye mata wuɗe ndo niye ka zal na, way?» ");
INSERT INTO meq_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoŋ a mbəɗay, a gwaɗay: «Na dzala maa wuɗa ndo niye ka zal na, ndo nakə kwar i suloy faya temerre zlam aye.» Yesu a gwaɗay faya: «Deɗek, ka mbəɗa faya na, lele.» ");
INSERT INTO meq_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tsa na, Yesu a mbəɗa me a diye i ŋgwas. A gwaɗay a Simoŋ: «Simoŋ ka ŋgatay a ŋgwas nakay ba? Na yaw na, a gay yak ɗuh bəɗaw? Ada nəkar ka təɗeŋew yam hərwi məbere ha sik ga bay. Aya ane, ŋgwas nakay na, kə bereŋ na sik ga ta yam ɗəre ŋgay ada ka takaɗ na ta məkwets i gər ŋgay bəɗaw? ");
INSERT INTO meq_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nəkar, ka təma ga a gay yak tə məgəse ga ka bo bay. Ane tuk na, neŋgeye na, kwa i madayaw ga kanaŋ na, faya ma gəsiye ka bo sik ga. ");
INSERT INTO meq_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nəkar na, ka mbəɗeŋ mal ka gər bay. Ane tuk na, neŋgeye na, ka mbəɗeŋ mal ka sik. ");
INSERT INTO meq_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Hərwi niye sər ha na, mawuɗe bo ŋgay nakə a wuɗa ga haladzay aye. A ɗa ha na, mezeleme ŋgay neheye a ge haladzay aye na, na pəsay ha tebiye. Ane tuk na, i ndo nakə tə pəsay ha mezeleme ŋgay tsekweŋ aye na, neŋgeye dərmak a wuɗa ndo na, tsekweŋ dərmak.» ");
INSERT INTO meq_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tsa na, Yesu a gwaɗay a ŋgwas niye: «Ŋgwas, mezeleme yak kə pəsa.» ");
INSERT INTO meq_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ndo niye hay faya ta ndiye wu mənday dziye, tə tsik mə walaŋ tay, tə gwaɗ: «Nakay i ŋgay ndo wuray a dza bo ka məpəsay ha mənese a ndo aye?» ");
INSERT INTO meq_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Aya ane, Yesu a gwaɗay a ŋgwas niye: «Mədzal gər yak kə mbəl kar ha. Do wu yak barbarra.» ");
INSERT INTO meq_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ma dəba eye na, Yesu a ye a walaŋ i gay hay ta gəma hay. A ye a həhal mə ɗəma na, a ɗa ha Labara Ŋgwalak eye i Bəy i Mbəlom mə ɗəma tebiye. Gawla ŋgay hay kuro gər eye sulo tə paway bəzay. ");
INSERT INTO meq_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ŋgwas neheye Yesu a həhar fataya abəra fakalaw aye ta neheye a mbəl tay ha abəra ma ɗəvats aye ta zəŋgal na dərmak. Nəteye na: Mari nakə tə zalay Mari Magədala eye, Yesu a həhar faya abəra Fakalaw hay tasəla aye; ");
INSERT INTO meq_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Zan ŋgwas i Kuza neŋgeye ndo məgəse dala i Herod; Suzan; ada ta ŋgwas hay wal wal neheye ta dzənawa Yesu ta gawla ŋgay hay tə wu tay hay aye. ");
INSERT INTO meq_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ndo hay haladzay ti ye naha ma gəma hay wal wal. Yesu a ŋgatay a ndo niye hay ti ye naha haladzay tə haya gər ka təv ŋgay na, a tsikatay me ta dzeke a gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Ndo wuray a ndohwaw abəra mə gay. A həl hulfe ŋgay a ye ha a pesl mata sləge. A ye naha na, a dazlay a masləge. Ahəl nakə faya ma kutsiye hulfe ŋgay a guvah aye na, siye hay tə kuts ka tsakay i tsəveɗ. Hulfe niye na, ndo hay ta mbərasla na, ɗiyeŋ hay tə pala na tebiye. ");
INSERT INTO meq_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Siye a dəɗ ka sik i pəlaɗ. Tə ndzohwaw na, kwayaŋŋa tə kula heryew heryew. Tə kula na, hərwi ta huta yam ma bəɗ bay. ");
INSERT INTO meq_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Neŋgeɗ a dəɗ a gay i dak. Dak niye hay tə gəl. Tsa na, dak niye hay tə ŋgəɗətsa na hulfe niye a ndzohwaw aye, kwa hulfe niye hay ta ge bo bay ada ta nah bay. ");
INSERT INTO meq_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ane tuk na, siye hay tə kuts ka təv lele eye. Tə ndzohwaw ada tə gəl. Tə gəl na, tə nah lele. Makwehe nəte na, wur eye faya temerre.» Yesu a gwaɗatay sa: «Ndo nakə zləm andaya faya mətsəne aye na, mâ tsəne lele!» ");
INSERT INTO meq_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ma dəba eye na, gawla ŋgay hay ta tsətsah faya, tə gwaɗay: «Dzeke nakə ka tsik aye na, a say məgweɗe mey?» ");
INSERT INTO meq_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu a mbəɗatay faya, a gwaɗatay: «Nəkurom na, Mbəlom kə ɗakum ha wu nakə maŋgaha eye ma bəy ŋgay aye. Ane tuk na, ndo siye hay ta tsəniye wu hay na, ta dzeke. Andza niye: “Ta sliye mazəbe faya, ane tuk na, ta ŋgateye bay. Ta sliye faya mətsəne, ane tuk na, andza məgweɗe mey na, ta tsəniye bay.”» ");
INSERT INTO meq_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesu a gwaɗatay sa: «Dzeke nakay a say məgweɗe na, anaŋ: Hulfe na, bazlam i Mbəlom ");
INSERT INTO meq_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ndo siye hay ta ndzəkit bo ta tsakay i tsəveɗ nakə hulfe a kuts faya aye. Nəteye na, tə tsəne bazlam i Mbəlom. Tsa na, Fakalaw a yaw a buwa na bazlam i Mbəlom niye tə tsəne aye abəra mə ɗərev tay. A buwa na na, hərwi ada tâ dzala ha faya bay ada tâ təma bay. ");
INSERT INTO meq_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Siye hay ta ndzəkit bo ta təv nakə bətekwew andaya faya haladzay bay aye. Tə tsəne bazlam i Mbəlom ada ta təma tə məŋgwese eye lele. Ane tuk na, ta huta məpe zləlay mə bazlam i Mbəlom bay. Ɗəretsətseh tə masəpete i Fakalaw a ndzatay a gər na, tə gər ha mədzele gər abəra ka Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Hulfe neheye tə kuts a gay i dak hay aye na, ta ndzəkit bo ta ndo neheye tə tsəne bazlam i Mbəlom aye. Ane tuk na, bor i məndzibəra, bor i zlele, ta bor i wu mekeleŋ eye hay wal wal a ye tay a bo. Wu niye hay tə ŋgəɗətsa na bazlam i Mbəlom nakə mə ɗərev tay aye. Bazlam i Mbəlom dərmak kə huta məvəle hohway bay. ");
INSERT INTO meq_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Hulfe nakə a kuts ka təv lele eye na, ta ndzəkit bo ta ndo neheye tə tsəne bazlam i Mbəlom aye na, tə pa na a ɗərev tay lele. Tə gay metsehe lele. Bazlam i Mbəlom a gəl mə ɗərev tay, tə nah lele.» ");
INSERT INTO meq_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesu a tsikatay dzeke sa, a gwaɗatay: «Ɗaɗa ndo ma zlaweye lalam ŋgay ma piye faya ako ada ma hurəkwiye faya gəse ɗaw? Kəgəbay ma piye na a dəba i sləlah ɗaw? Ɗuh ma piye na na, ka wu məpe lalam hərwi ada ndo neheye ta fələkwiye a gay aye mâ dəvatay dzaydzay. ");
INSERT INTO meq_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sərum ha na, wu neheye maŋgaha eye hay aye na, ta zəbiye ŋgəray ŋgəray ta həpat. Ada wu neheye ndo hay tə sər bay aye na, ndo hay ta ta səriye mə dzaydzay.» ");
INSERT INTO meq_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","A gwaɗatay sa: «Gumay metsehe a mətsəne wu nakə ka pawumay zləm aye. Hərwi ndoweye kə pay zləm lele na, Mbəlom ma səkahiye ha mətsəne ada mâ tsəne lele. Ane tuk na, ndo nakə a say mətsəne bay aye na, kwa tsekweŋ eye nakə a tsəne aye na, ta buwiye na.» ");
INSERT INTO meq_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","May i Yesu ta malamar i Yesu hay ta pəla na Yesu. Ta pəla na na, ta huta na Yesu. Ane tuk na, ta ndisl ka təv ŋgay bay hərwi ndo hay haladzay ka tsəveɗ. ");
INSERT INTO meq_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tə gwaɗay a Yesu: «May yak ta malamar yak hay, nəteye ma bəra faya ta tsətsahiye kar. A satay məŋgataka.» ");
INSERT INTO meq_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ane tuk na, Yesu a mbəɗatay faya, a gwaɗatay: «May ga ta malamar ga hay na, ndo neheye faya ta pay zləm a bazlam i Mbəlom ada faya ta giye wu nakə bazlam i Mbəlom a tsik aye.» ");
INSERT INTO meq_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pat wuray na, Yesu a gwaɗatay a gawla ŋgay hay: «Tsalakwa a kwalalaŋ i yam takwa a diye i dəlov neŋgeɗ.» Tsa na, tə tsal a kwalalaŋ i yam, ti ye. ");
INSERT INTO meq_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ahəl nakə faya ta diye ka gər i yam aye na, Yesu a ndzahəra. A ndzahəra na, kwayaŋŋa mətasl a vəzl ka gər i dəlov niye ta gədaŋ. Tsa na, kwalalaŋ i yam a rah ta yam mazlambar ta kutsiye a yam. ");
INSERT INTO meq_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Gawla ŋgay hay ta həndzəɗ ka təv ŋgay. Ta wuda ka bo, ta pəɗeke ha Yesu abəra ka məndzehəre. Tə gwaɗay: «Bəy may, Bəy may, ka mətakweye!» Tsa na, Yesu a pəɗeke, a gay me a mətasl ada a yam. Kwayaŋŋa mətasl a ndza ɗeɗik. Məɓəle i wuray kwa tsekweŋ andaya sa bay. ");
INSERT INTO meq_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesu a gwaɗatay a gawla ŋgay hay: «Ka yum ha mədzal gər kurom aye a ŋgay!» Ane tuk na, ta dzədzar haladzay. A gatay hərɓaɓəkka. Tə gwaɗ mə walaŋ tay: «Nakay na, ndo wuray? A gatay me a mətasl ta yam na, tə gəsay me aye!» ");
INSERT INTO meq_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu ta gawla ŋgay hay tə ndisl a gəma i Geraseni nakə ta diye i dəlov niye tə zalay dəlov i Galile aye. Niye na, bəse kame i dala i Galile. ");
INSERT INTO meq_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu a mbəzlaw abəra mə kwalalaŋ i yam na, ndo wuray a ndzawa ma wuzlahgəma, a ŋgatay a Yesu na, a yaw ka təv ŋgay. Ndoweye niye na, gər a vuway. Kə ndza haladzay a pawa ka bo petekeɗ sa bay ada a hənawa mə gay bay sa tsa. Ane tuk na, a hənawa mə walaŋ i tsəvay hay. ");
INSERT INTO meq_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","A ŋgatay a Yesu na, kwayaŋŋa a wuda ta gədaŋ. A kal ha bo kame i Yesu. Tsa na, a gwaɗay: «Nəkar na, Yesu Wawa i Bəy Mbəlom Fetek. Ka wuɗa ka neŋ na, mey? Amboh kâ geŋ wuray bay tey.» ");
INSERT INTO meq_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","A tsik andza niye na, hərwi Yesu a gwaɗaway a fakalaw: «Dara abəra mə bo i ndo nakay.» Tə dzawaway na sik tə səselek ada tə paway tsalalaw a həlay. Ane tuk na, a ŋgəzlahawa ha wu niye hay tə dzawawa na aye ndərtsətsətse ada fakalaw a yawa ha a təv dəreŋ aye hay abəra mə walaŋ i gay, a kəsaf. ");
INSERT INTO meq_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu a tsətsah faya, a gwaɗay: «Məzele yak na, way?» Fakalaw niye a mbəɗay faya a gwaɗay: «Məzele ga na, Haladzay.» A tsikay a Yesu andza niye na, hərwi nəteye haladzay mə bo i ndo niye. ");
INSERT INTO meq_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Fakalaw niye hay tə gay amboh a Yesu hərwi ada mâ kuts tay a bəɗ nakə kutsɨk bagwar eye aye bay. ");
INSERT INTO meq_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ka təv eye niye na, madəras hay andaya faya ta pəliye wu mənday tay hay ma tsaholok wuray. Fakalaw niye hay mə bo i ndo niye tə gay amboh a Yesu hərwi ada mâ vəlatay tsəveɗ məfələkwe a bo i madəras niye hay. Yesu a vəlatay tsəveɗ mede a bo i madəras niye hay. ");
INSERT INTO meq_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tsa na, fakalaw niye hay ti yaw abəra mə bo i ndo niye ti ye, tə fələkwa a bo i madəras hay. Madəras niye haladzay aye ta hwayaw abəra ka mahəmba niye. Ti yaw tə kuts a dəlov niye tebiye, tə dze a ɗəma. ");
INSERT INTO meq_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ndo mətsəkure madəras niye hay tə ŋgatay andza niye na, ta hway, ti ye a wuzlahgəma mata ɗatay ha labara niye a ndo hay ada a ndo neheye nəteye dəreŋ ta wuzlahgəma aye hay. ");
INSERT INTO meq_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tsa na, ndo hay tə tsəne na, ti yaw mata zəbe naha ka wu nakə a ge bo aye. Ti yaw tə ndislew ka təv i Yesu na, tə ŋgatay a ndo niye fakalaw hay ti yaw abəra mə bo ŋgay aye mandza eye ka təv i Yesu. Anəke na, petekeɗ ka bo ada neŋgeye lele, andza nakə a ndzawa aye sa bay. Tə ŋgatay andza niye na, ta dzədzar. ");
INSERT INTO meq_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ndo neheye labara i gər mavuwe a ge bo ka ɗəre tay aye nəteye dərmak ta təkəratay labara eye a ndo niye hay ti ye naha, nəteye ta ŋgatay təbey aye. Gər mavuwe niye a mbəl kəkay na, ta təkəratay. ");
INSERT INTO meq_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tə tsəne na, ndo i dala i Geraseni niye tebiye ta tsətsah ka Yesu tə gwaɗay: «Do abəra ka dala may» hərwi ta dzədzar haladzay. Tsa na, Yesu a tsal a kwalalaŋ i yam hərwi mede abəra ka dala niye. ");
INSERT INTO meq_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ndo nakə fakalaw hay ti yaw abəra mə bo ŋgay aye, a gay amboh a Yesu ada Yesu mâ vəlay tsəveɗ mâ zəŋgal na. Ane tuk na, Yesu kə vəlay tsəveɗ ka məpay bəzay bay. A gwaɗay: ");
INSERT INTO meq_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Do a mətagay yak! Təkəratay a ndo hay wu nakə Mbəlom a ge hərwi yak aye, kwa tsekweŋ ka gər ha faya abəra bay.» Tsa na, ndo niye a ye a təkər wu nakə Yesu a ge hərwi ŋgay aye ma wuzlah gay tebiye. ");
INSERT INTO meq_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu a maw ma diye i dəlov a diye neŋgeɗ na, ndo hay haladzay faya ta həbiye na. Ndo niye hay tə ŋgatay a Yesu na, ta təma na lele. ");
INSERT INTO meq_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tsa na, ndo wuray tə zalay Dzayrus a ye naha dərmak. Neŋgeye na, bəy i gay i maɗuwule me. A ye naha a dəkway gurmets a huvo a Yesu. A gay amboh a Yesu, a gwaɗay: «Amboh kâ ma a gay ga tey.» ");
INSERT INTO meq_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","A say Yesu mâ ye a gay ŋgay na, hərwi dem ŋgay andaya nəte məve ŋgay ma giye kuro gər eye sulo. Dem eye niye na, bo a wur faya ma mətiye. Ahəl nakə Yesu faya ma diye na, ndo hay haladzay faya ta ŋgəɗətsiye na kwa tə waray kwa tə waray. ");
INSERT INTO meq_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ŋgwas wuray andaya dərmak. Ŋgwas eye niye na, ɗəvats eye. Bambaz a mbəɗawayaw abəra mə huɗ. Ɗəvats eye niye kə ndza faya məve kuro gər eye sulo. Kə dze ha zlele ŋgay haladzay a gay i ndo i sidem hay. Ane tuk na, ndəray nəte kə sla faya məmbəle ha bay. ");
INSERT INTO meq_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A ye a walaŋ i ndo niye hay. Tsa na, a həndzəɗ ka təv i Yesu ta dəba, a lamay a me i petekeɗ i Yesu. Kwayaŋŋa bambaz nakə a mbəɗawayaw faya abəra aye a tərəts. A huta zay. ");
INSERT INTO meq_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu a tsətsah, a gwaɗ: «Maa lemeŋ, way?» Nəteye tebiye tə sər maa lamay way na, tə sər bay. Piyer a gwaɗay: «Bəy ga, ka gwaɗiye “Maa lemeŋ way” na, ka ŋgatay tə lawara kar ada faya ta ŋgəɗətsiye kar kwa tə waray kwa tə waray təbəɗew.» ");
INSERT INTO meq_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Aya ane tuk na, Yesu a gwaɗ: «Ndəray kə lemeŋ, hərwi na sər ha gədaŋ ki yaw abəra mə bo ga.» ");
INSERT INTO meq_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ŋgwas niye a sər ta huta na na, a ye ka təv i Yesu tə madzədzere eye. A ye a dəkway gurmets a huvo a Yesu. A təkəray, a lamay hərwi mey ada a mbəl kwayaŋŋa na, a təkəray kame i ndo niye hay tebiye. ");
INSERT INTO meq_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu a gwaɗay: «Dem ga, mədzal gər yak kə mbəl kar ha. Do wu yak barbarra.» ");
INSERT INTO meq_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ahəl nakə Yesu faya ma tsikeye a ŋgwas niye andza niye na, ta sləraw ndo abəra mə gay i bəy i gay i maɗuwule me niye tə zalay Dzayrus aye. A yaw a gwaɗay: «Dem yak kə mət. Kâ wurɗay me a Miter sa bay.» ");
INSERT INTO meq_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ane tuk na, Yesu kə tsəne, a gwaɗay a Dzayrus: «Kâ dzədzar bay, dzala ha ka neŋ tsa na tsɨy, dem yak ma mbəliye.» ");
INSERT INTO meq_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tə ndisl naha a gay i Dzayrus na, kə vəlatay tsəveɗ a ndo hay məfələkwe a gay bay. Ti ye na, ta Piyer, Yuhana ta Yakuba ɗekɗek tsa ta bəba ada ta may i wawa. ");
INSERT INTO meq_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mə gay i mədahaŋ niye na, ndo hay tebiye taŋgof taŋgof, siye faya ta ndəviye kuɗa hərwi wawa niye a mət aye. Yesu a ye naha na, a gwaɗatay: «Kâ tuwum bay. Dem nakay na, kə mət bay, neŋgeye mandzahəra eye.» ");
INSERT INTO meq_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ane tuk na, ndo niye hay tə ŋgwasay dəla mə gər, tə sər lele dem niye na, kə mət. ");
INSERT INTO meq_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesu a ye naha na, a gəs na dem niye mə həlay ada a gwaɗay ta gədaŋ: «Wawa, lətse!» ");
INSERT INTO meq_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Dem niye a mbəl. Kwayaŋŋa a lətse tsəkwaɗ. Yesu a gwaɗatay: «Vəlumay wu mənday.» ");
INSERT INTO meq_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tsa na, bəba ta may i wawa a gatay hərɓaɓəkka. Ane tuk na, Yesu a gwaɗatay: «Wu nakay a təra aye na, kâ tsikumay a ndəray bay.» ");
INSERT INTO meq_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Pat wuray na, Yesu a zalatay a gawla ŋgay hay kuro gər eye sulo, a hayatay gər. A vəlatay gədaŋ ta məzlaɓ ka mahəhere fakalaw hay abəra ka ndo hay tebiye ada məmbəle tay ha abəra ma ɗəvats tay hay. ");
INSERT INTO meq_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ma sləriye tay ha na, mata ɗa ha Bəy i Mbəlom ada məmbəle tay ha ndo hay. ");
INSERT INTO meq_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","A tsikatay me a zləm, a gwaɗatay: «Ka deyumeye na, kâ zlum wuray a həlay bay tebiye. Kwa sakwal, kwa gwezem, kwa wu mənday, kwa suloy ada kwa way mâ zla petekeɗ i məkelkabo sulo bay. ");
INSERT INTO meq_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ka ndislum a gəma nakə ka deyumeye a ɗəma aye na, ndzum mə gay nakə ta təma kurom tə məŋgwese aye. Kâ yum kurom abəra mə gay niye bəse tsa bay. Ndzum mə ɗəma hus a pat nakə ka deyumeye a gəma mekeleŋ eye. ");
INSERT INTO meq_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ada ma gəma nakə ta wuɗa matəme kurom təbey aye na, dum abəra ma gəma tay. Ahəl nakə nəkurom ka tsəveɗ mazlambar ka gərumeye ha tsəveɗ i gəma niye na, tətəkum ha bətekwew i gəma tay abəra ka sik kurom hay. Niye na, ta səriye ha ta təma kurom bay.» ");
INSERT INTO meq_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yesu a ndəvatay ha bazlam ŋgay niye na, tə həl bo ti ye tuk. Ti ye na, ta həhal ma gəma hay tebiye. Tə ɗa ha Labara Ŋgwalak eye. Tə mbəl tay ha ndo i ɗəvats hay kwa məŋgay məŋgay. ");
INSERT INTO meq_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Azlakwa bay, Herod neŋgeye bəy ka dala i Galile, a tsəne wu nakə faya ma giye bo aye na, a vəlay mədzal gər haladzay. Hərwi ndo hay tə gwaɗ: «Yuhana madzəhuɓe ndo a yam kə mbəlaw abəra ma mədahaŋ.» ");
INSERT INTO meq_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Siye hay tə gwaɗ: «Ma giye maa yaw na, Eliya.» Siye hay tə gwaɗ sa: «Neŋgeye na, ndo məɗe ha bazlam i Mbəlom nəte mə walaŋ i ndo məɗe ha bazlam i Mbəlom niye hay ahəl niye a lətsew abəra ma mədahaŋ.» ");
INSERT INTO meq_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ane tuk na, Herod a gwaɗ: «Yuhana na, maa ɗəs faya abəra gər na, neŋ. Ada ndo nakay na tsəne ndo hay faya ta tsikiye faya na, way?» Tsa na, a pəla tsəveɗ məŋgatay a Yesu. ");
INSERT INTO meq_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Anəke na, ndo i maslaŋ hay tə maw tuk. Tə maw ka təv i Yesu ta təkəray wu nakə tə gaw aye. Ma dəba aye na, Yesu ta ndo i maslaŋ ŋgay hay ti ye abəra ka təv niye. Ti ye a təv aye andaya bəse ta gəma nakə tə zalay Betesayda aye. ");
INSERT INTO meq_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ane tuk na, ndo hay ta sər fataya. Tsa na, tə patay bəzay. Yesu a ŋgatatay na, a təma tay ha. A ɗatay ha Bəy i Mbəlom ada a mbəl tay ha ndo i ɗəvats hay. ");
INSERT INTO meq_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mazlambar huwa faya ma giye na, gawla i Yesu hay ta həndzəɗ ka təv i Yesu. Ti ye naha tə gwaɗay: «Gwaɗatay a ndo neheye na, tâ ye a wuzlahgəma ada a gay i ndo neheye tə mbay naha a wuzlahgəma aye. Tâ ye mata həne mə ɗəma ada mata nde wu mənday bəna, kəkay? Hərwi nəkway anaŋ na, ma təv nakə dəreŋ aye.» ");
INSERT INTO meq_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ane tuk na, Yesu a gwaɗatay: «Nəkurom eye vəlumatay wu mənday!» Ta mbəɗay faya, tə gwaɗay: «Tapa i makwala andaya na, zlam ada kəlef hay sulo tsa. A saka na, nəmaâ ye mata səkəmaw wu mənday hərwi ndo neheye tebiye ɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ndo neheye tebiye ka təv i Yesu aye na, hasləka hay ta giye gwezem zlam. Yesu a gwaɗatay a gawla ŋgay hay: «Dum gwaɗumatay a ndo hay tâ ndza ka dala. Tâ ndza bəruk i ndo kuro kuro zlam, kuro kuro zlam.» ");
INSERT INTO meq_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tsa na, gawla ŋgay hay ta təma wu nakə a tsikatay aye. Ti ye tə tsikatay a ndo niye hay andza niye. Tə ndza bəruk kuro kuro zlam, kuro kuro zlam. ");
INSERT INTO meq_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tsa na, Yesu a həl tapa i makwala zlam tə kəlef niye hay sulo aye. A zəba ɗəre a mbəlom ada a gay naha sɨsœ a Mbəlom hərwi wu mənday niye. A ŋgəna ha ada a vəlatay a gawla ŋgay hay hərwi ada nəteye dərmak tâ ŋgənatay a ndo hay. ");
INSERT INTO meq_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Gawla i Yesu hay ta ŋgənatay wu mənday niye a ndo hay. Kwa way a nda wu mənday niye ka mərehe. Tə hayay gər a bəmalə nakə a zəkaw aye na, a rah gwaŋ hay kuro gər eye sulo. ");
INSERT INTO meq_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pat wuray na, Yesu faya ma ɗuwuliye me mahəŋgeye. Gawla ŋgay hay ti ye ka təv ŋgay. Tə ndisl naha na, Yesu a tsətsah fataya, a gwaɗatay: «Ndo hay tə gwaɗ fagaya, neŋ na, way?» ");
INSERT INTO meq_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ta mbəɗay faya, tə gwaɗay: «Siye hay tə gwaɗ nəkar na, Yuhana madzəhuɓe ndo a yam. Ndo mekeleŋ eye hay tə gwaɗ nəkar na, Eliya. Siye hay tə gwaɗ nəkar na, nəte mə walaŋ i ndo məɗe ha bazlam i Mbəlom niye hay ahəl niye a lətsew abəra ma mədahaŋ.» ");
INSERT INTO meq_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesu a tsətsah fataya, a gwaɗatay: «Ada nəkurom ka gwaɗum i kurom, neŋ na, way?» Tsa na, Piyer a gwaɗay: «Nəkar na, Kəriste, ndo nakə Mbəlom a sləraw aye.» ");
INSERT INTO meq_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tsa na, Yesu a gatay me, a gwaɗatay: «Kâ ɗumay ha a ndəray bay.» ");
INSERT INTO meq_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","A gwaɗatay sa: «Neŋ Wawa i Ndo na, kutoŋ na siye ɗəretsətseh haladzay. Madugula i Yahuda hay, bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye na, nəteye ta wuɗiye ga bay. Ta kaliye ga ha, ta ta kəɗiye ga. Ane tuk na, na həniye sulo mamahkar eye na, na lətseweye abəra ma mədahaŋ.» ");
INSERT INTO meq_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tsa na, Yesu a zalatay a ndo hay ta gawla ŋgay hay ka təv ŋgay. A gwaɗatay a nəteye tebiye: «A say a ndoweye məpeŋ bəzay na, mâ gər ha wu nakə a say a ɗərev ŋgay aye. Mâ zla mayako mazləlmbaɗa eye ada mâ peŋ bəzay pat pat. ");
INSERT INTO meq_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Andza niye, ndo nakə a say mətəme ha məsəfəre ŋgay aye na, ma dziye ha ɗuh. Ane tuk na, ndo nakə ma dziye ha məsəfəre ŋgay hərwi ga aye na, ma təmiye ha ɗuh. ");
INSERT INTO meq_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Taɗə ndoweye kə huta zlele i məndzibəra tebiye a neŋgeye, ane tuk na, kə dze ha məsəfəre ŋgay na, ŋgama ŋgay aye na, mey? ");
INSERT INTO meq_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","«Taɗə ndoweye ka kərah ga ada kə ɗatay ha bazlam ga a ndo hay bay na, neŋ dərmak na ta kərahiye na. Na ta kərahiye na na, ahəl nakə neŋ Wawa i Ndo na deyeweye ta məzlaɓ ga ada ta məzlaɓ i Bəba Mbəlom ada ta gawla i Mbəlom hay aye.» ");
INSERT INTO meq_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yesu a gwaɗatay sa: «Sərum ha na, ndo siye hay mə walaŋ kurom neheye anəke kanaŋ aye, nəteye na, ta mətiye zuk bay. Ta ta mətiye na, ta ŋgateye tə ɗəre tay a Bəy i Mbəlom nakə ma ləviye bəy ŋgay ta gədaŋ aye təday.» ");
INSERT INTO meq_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ma dəba i bazlam ŋgay niye a tsik aye a ndza məhəne tsamahkar na, a zalay a Piyer, a Yuhana, ada a Yakuba, ti ye tə tsal a mahəmba. Ti ye a ɗəma na, mata ɗuwule me. ");
INSERT INTO meq_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ahəl nakə Yesu faya ma ɗuwuliye me aye na, ɗəre ŋgay a mbəɗa. Petekeɗ ŋgay a mbəɗa herre kuɗekuɗek, a sləɗa haladzay. ");
INSERT INTO meq_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kwayaŋŋa, ndo hay sulo ti yaw ka təv ŋgay. Nəteye faya ta tsikiye me. Ndoweye niye hay na, Musa ta Eliya. ");
INSERT INTO meq_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ti yaw na, tə dzaydzay i Mbəlom. Tə tsik ka məsler i Yesu nakə ma ta ndəviye ha ta mədahaŋ ŋgay ma Zerozelem aye. ");
INSERT INTO meq_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ahəl nakə ndo niye hay sulo aye faya ta tsikiye me ta Yesu aye na, Piyer ta ndo neheye nəteye dziye na, nəteye mandzahəra eye. Ane tuk na, ta pəɗeke abəra ka məndzehəre. Ta pəɗeke na, tə ŋgatay a dzaydzay i Yesu ada tə ndo niye hay sulo malətsa eye hay ka təv i Yesu aye. ");
INSERT INTO meq_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ka təv nakə ndo niye hay ta diye wu tay abəra ka təv i Yesu aye na, Piyer a gwaɗay a Yesu: «Bəy ga! Lele na, ndzakwa kanaŋ. Nəmaa kəruwakumeye madzawadzawa mahkar, nəte i yak, nəte i Musa ada nəte i Eliya.» Piyer a tsik andza niye na, a sər wu nakə ma tsikiye bay. ");
INSERT INTO meq_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ahəl nakə faya ma tsikiye andza niye na, pazlay a mbəzlaw a dərəzl tay ha dezəgələm. Gawla i Yesu niye hay mahkar eye tə ŋgatay a pazlay niye a dərəzl tay ha aye na, ta dzədzar haladzay. ");
INSERT INTO meq_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma pazlay niye na, mətsike me a tsənew abəra mə ɗəma, a gwaɗ: «Nakay na, wawa ga. Na zla na, neŋgeye. Pumay zləm a wu nakə ma tsikakumeye!» ");
INSERT INTO meq_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ma dəba i bazlam niye, tə ŋgatay na, a Yesu mahəŋgeye. Gawla i Yesu niye mahkar aye wu nakə tə ŋgatay aye na, ta təkəray a ndəray zuk bay. Tə ndza wu tay tete. ");
INSERT INTO meq_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tədœ eye na, Yesu ta gawla ŋgay niye hay mahkar aye, tə mbəzlaw abəra mə mahəmba. Faya ta mbəzlaweye na, ndo hay haladzay ti yaw mədze gər tə Yesu. ");
INSERT INTO meq_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mə walaŋ i ndo niye haladzay aye na, ndoweye andaya a pa bo ka mawude. A gwaɗ: «Miter! Amboh zəba ka wawa ga nakay tey! Wawa ga mekeleŋ eye andaya bay. Neŋgeye nəte ŋgweŋ. ");
INSERT INTO meq_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Fakalaw a gəsawa na. A gəsawa na na, ta gədaŋ. A wudawa ka bo ada a kalawa ha ka dala ɓəra ɓəra. Makukufay a yawaw ka bazlam. A gawa ha ɗəretsətseh haladzay ada a yawa faya abəra bəse bay. ");
INSERT INTO meq_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Na gatay amboh a gawla yak hay tâ həhar faya abəra fakalaw tey na, tə mba faya bay.» ");
INSERT INTO meq_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu a tsəne andza niye na, a wuda, a gwaɗ: «Nəkurom neheye anəke, ka dzalum ha ka Mbəlom bay aye. Na zliye ŋgatay hərwi kurom na, məndze hadzəgay. Ahe! Do, zla ahaya wawa yak eye kanaŋ!» ");
INSERT INTO meq_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tsa na, Bəba i wawa a ye a zla ahaya wawa niye. Ahəl nakə wawa niye ma ta husiye naha ka təv i Yesu kəɗiyya na, mahorvov a kal ha ka dala ɓəra. A tambolom ha ka dala ta gədaŋ. Kwayaŋŋa Yesu a ŋgərəz ka mahorvov niye. A mbəl ha wawa ada a vəlay ha a bəba ŋgay. ");
INSERT INTO meq_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ndo niye hay tebiye ka təv niye a gatay hərɓaɓəkka. Tə gwaɗ: «Ta deɗek Mbəlom na, gədaŋ eye.» Nəteye tebiye a gatay hərɓaɓəkka. Yesu a gwaɗatay a gawla ŋgay hay: ");
INSERT INTO meq_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Wu nakə na ɗakumeye ha anəke aye na, pum na a wuzlah i mədzal gər kurom lele: Neŋ Wawa i Ndo na, ta gəsiye ga, ta vəlateye ga ha a həlay a ndo hay.» ");
INSERT INTO meq_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ane tuk na, gawla ŋgay hay ta tsəne bazlam ŋgay niye bay. Mətsəne ŋgay eye andza məgweɗe kəkay na, maŋgaha eye hərwi ada tâ tsəne bay. Ada zluwer a gatay matsətsehe ka Yesu ka gər i bazlam eye niye. ");
INSERT INTO meq_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Gawla i Yesu hay ta dazlay məkəɗe wuway mə walaŋ tay. Tə kəɗ wuway na, məsər ha bagwar eye mə walaŋ tay na, way? ");
INSERT INTO meq_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ane tuk na, Yesu a səratay naha ka wu nakə tə dzala aye. Tsa na, a zla wawa. A lətse ha ka təv ŋgay. ");
INSERT INTO meq_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","A gwaɗatay: «Ndoweye ka təma na wawa nakay lele hərwi nakə a wuɗa ga aye na, a təma na, neŋ. Ndoweye ka təma ga na, a təma na, ndo nakə a sləra ga ahaya aye. Hərwi ndo nakə wawa eye mə walaŋ kurom aye, maa təra bagwar eye na, neŋgeye ɗuh.» ");
INSERT INTO meq_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ma dəba eye na, Yuhana a gwaɗay: «Bəy Maduweŋ, nəmaa ŋgatay a ndoweye faya ma həhariye fakalaw abəra ka ndo ta məzele yak. A samay haɓe məgay me hərwi neŋgeye na, mə walaŋ kway bay.» ");
INSERT INTO meq_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ane tuk na, Yesu a mbəɗay faya a gwaɗay: «Kâ gumay me bay. Hərwi ndo nakə kə nakum ɗəre bay aye na, neŋgeye ndo kurom.» ");
INSERT INTO meq_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Həlay nakə kutoŋ Yesu ma diye abəra ka məndzibəra aye mazlambar kə ndislew. Tsa na, a həl bo ta deɗek eye mede a Zerozelem. ");
INSERT INTO meq_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","A slər ndo i məsler ŋgay hay kame. Ti ye naha tə fələkwa a gəma i Samari hərwi mede mələve ha bo tə mede i Yesu nakə ma diye a ɗəma aye. ");
INSERT INTO meq_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ane tuk na, ndo i gəma niye hay ta wuɗa mâ ye naha a gəma tay bay. Ta wuɗa bay na, hərwi nakə faya ma diye ta diye i Zerozelem aye. ");
INSERT INTO meq_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yakuba ta Yuhana tə tsəne andza niye na, tə gwaɗay a Yesu: «Bəy Maduweŋ! A saka na, nəmaâ tsətsahaw ako mə mbəlom mâ mbəzlaw fataya matəma tay ha abəra mə ɗəma ɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu a tsəne me tay niye na, a mbəɗa me ka təv tay a gatay me. ");
INSERT INTO meq_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tsa na, ti ye a gəma mekeleŋ eye. ");
INSERT INTO meq_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ahəl nakə nəteye ka tsəveɗ faya ta diye na, ndo wuray a yaw ka təv i Yesu, a gwaɗay: «Kwa a ŋgay ka diye na, na pakeye bəzay.» ");
INSERT INTO meq_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu a gwaɗay: «Mezerew hay na, bəɗ tay andaya hərwi məhəne mə ɗəma, ɗiyeŋ hay dərmak gay tay andaya. Ane tuk na, neŋ Wawa i Ndo na, təv ga andaya nakə na həniye mə ɗəma hərwi mazəzukwe bo aye bay.» ");
INSERT INTO meq_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu a gwaɗay a ndo mekeleŋ eye: «Peŋ bəzay.» Ane tuk na, ndo niye a gwaɗay a Yesu: «Bəy ga! Vəleŋ tsəveɗ nâ ye, nâ la na bəba ga təday.» ");
INSERT INTO meq_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu a mbəɗay faya a gwaɗay: «Gər ha mədahaŋ hay tâ la bo tay. Nəkar, do ta ɗa ha Bəy i Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ndo mekeleŋ eye a yaw ka təv i Yesu sa a gwaɗay: «Bəy Maduweŋ, neŋ na, na pakeye bəzay. Aya ane, vəleŋ tsəveɗ nâ ye, nâ tsikatayaw me a ndo i gay ga hay təday.» ");
INSERT INTO meq_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu a ɗa ha parakka, a gwaɗay: «Ndoweye faya ma fətiye tə sla hay na, ma sliye faya mazəbe ɗəre ta dəba bay. Andza niye ndoweye niye na, ma sliye faya məge məsler i Bəy i Mbəlom bay.» ");
INSERT INTO meq_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ma dəba eye na, Yesu a pala gawla ŋgay mekeleŋ eye hay kuro kuro tasəla gər eye sulo hərwi məsləre tay ha. A slər tay ha na, sulo sulo kame ŋgay, a wuzlahgəma hay tebiye ada a təv neheye bo ŋgay eye a say mede a ɗəma aye dərmak. ");
INSERT INTO meq_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","A pala tay ha na, a gwaɗatay: «Wu mənday andaya haladzay məpele ka dala. Ane tuk na, ndo məpele na abəra ka dala na, nəteye haladzay bay. Hərwi niye, gumay amboh a ndo i guvah mâ səkah ha ndo i məsler hay hərwi məpele wu mənday abəra ka dala. ");
INSERT INTO meq_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","«Dum! Na sləriye kurom ha na, nəkurom ka tərum andza wawa i təɓaŋ hay a wuzlah i ndo neheye nəteye andza kəra i pesl hay aye. ");
INSERT INTO meq_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ka deyumeye na, kâ həlum suloy a həlay bay, kâ zlum ɓəɓoro bay, kâ həlum tahərak kurom hay a sik bay, kâ lətsum ka tsəveɗ hərwi mətsikay me a ndo bay. ");
INSERT INTO meq_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","«A gay nakə ka deyumeye a ɗəma aye na, lahum məgweɗe: “Zay mâ ndza ka gay nakay.” ");
INSERT INTO meq_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Taɗə ndəray ka təma kurom mə gay niye lele na, zay kurom ma ndziye ka gay niye. Taɗə ka təma zay kurom bay na, mum ha zay kurom. ");
INSERT INTO meq_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ndo nakə ka təma kurom aye na, ndzum mə gay ŋgay. Wu nakə ta vəlakumeye na, ndayum, ada sum wu məse nakə ta vəlakumeye, hərwi ndo məge məsler na, kutoŋ ma hutiye merəɓe ŋgay. ");
INSERT INTO meq_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","«Taɗə ka ndislum a wuzlahgəma waray waray ta təma kurom na, ndayum wu nakə ta vəlakumeye. ");
INSERT INTO meq_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mbəlum tay ha ndo i ɗəvats niye hay ma gəma niye ada kâ gwaɗumatay a ndo i gəma niye hay: “Bəy i Mbəlom ka həndzəɗaw fakuma.” ");
INSERT INTO meq_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ane tuk na, kâ yum kwa a gəma waray, waray, ta təma kurom bay na, dum kurom abəra ma gəma niye. Dum ka tsəveɗ ada gwaɗumatay a ndo hay tebiye: ");
INSERT INTO meq_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Burhway i gəma kurom nakay a mətsamay ka sik aye na, nəmaa tətəkwakum na kurom. Ɗuh bay! Sərum ha na, Bəy i Mbəlom ka həndzəɗaw fakuma.” ");
INSERT INTO meq_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Sərum ha pat i sariya i Mbəlom na, sariya i ndo i gəma niye na, ma ziye i gəma i Sodom.» ");
INSERT INTO meq_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesu a gwaɗ sa: «A nəkurom ndo i gəma i Koraziŋ hay, tuwum bo kurom, hərwi ɗəretsətseh ka gər kurom! A nəkurom ndo i gəma i Betesayda hay, tuwum bo kurom hərwi ɗəretsətseh ka gər kurom. Hərwi taɗə masuwayaŋ neheye na ge mə gay kurom aye nâ ge ma gəma i Tir ta gəma i Sidoŋ na, atay na, ndo i gəma niye hay ta dzaliye bo tay ta tuwiye, ta pa ka bo taɓay manasa eye ada ta kutsiye bətekwew maləməts a gər hərwi məɗe ha na, ta gər ha mezeleme tay. ");
INSERT INTO meq_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hərwi niye, pat nakə Mbəlom ma gateye sariya a ndo hay aye na, sariya kurom ma diye me ma ziye i ndo i gəma i Tir ta Sidoŋ. ");
INSERT INTO meq_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","«Nəkurom ndo i gəma i Kafernahum hay, ka dzalum nəkurom na, Mbəlom ma ta həliye kurom a mbəlom wal ɗaw? Aʼay! Nəkurom ɗuh na, Mbəlom ma ta mbəzliye kurom ha na, a təv məndze i mədahaŋ hay.» ");
INSERT INTO meq_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu a gwaɗatay a gawla ŋgay sa: «Ndoweye kə pa zləm ka bazlam kurom ada ka təma na, a təma na, neŋ. Ndoweye ka təma kurom bay na, a təma bay na, neŋ. Ndoweye ka təma ga bay na, a təma bay na, ndo nakə a sləra ga ahaya aye.» Ndoweye neheye kuro kuro tasəla gər eye sulo aye ti ye. ");
INSERT INTO meq_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Anəke na, gawla i Yesu niye hay kuro kuro tasəla gər eye sulo aye tə maw tuk. Tə maw na, tə məŋgwese eye mə ɗərev tay lele. Tə gwaɗay a Yesu: «Bəy Maduweŋ, kwa fakalaw hay ta rəhamay ha gər tə məzele yak.» ");
INSERT INTO meq_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu a mbəɗatay faya a gwaɗatay: «Na ŋgatay a Fakalaw a dəɗaw mə gəma andza mawutseɗe i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Anaŋ tsənum! Na vəlakum gədaŋ ka mandəresle tay ha dədœ hay ta hərdəde hay ada ka mandəresle na gədaŋ i ndo məne ɗəre kurom tebiye. Wuray kwa tsekweŋ ma gakumeye bay. ");
INSERT INTO meq_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ane tuk na, kâ ŋgwasum hərwi nakə fakalaw hay ta rəhakum ha gər aye bay. Ŋgwasum ɗuh na, hərwi məzele kurom hay mawatsa eye mə mbəlom.» ");
INSERT INTO meq_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kwayaŋŋa Məsəfəre Tsəɗaŋŋa eye a rahay a bo a Yesu. Tsa na, a wuda tə məŋgwese eye, a gwaɗ: «A nəkar Bəba Mbəlom, ndo mələve magərmbəlom ta dala, na gaka sɨsœ hərwi nəkar ka ɗatay ha wu nakə maŋgaha eye a ndo neheye tə sər wuray bay aye, ada ka ŋgaha abəra ka ndo i ndaraw hay ta ndo neheye nəteye tə sər wu aye. Ayaw, Bəba Mbəlom, a yaka a gər a nəkar hərwi mâ ge bo andza niye.» ");
INSERT INTO meq_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yesu a gwaɗ sa: «Bəba ga kə vəleŋ wu hay tebiye. Wawa i Mbəlom way na, ndəray a sər bay. Maa sər na, Bəba Mbəlom nəte ŋgweŋ. Ada Bəba way na, ndəray a sər bay. Maa sər na, neŋ wawa ŋgay ada maa sər na ndo neheye a seŋ məɗatay ha aye.» ");
INSERT INTO meq_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tsa na, Yesu a mbəɗa me ka təv i gawla ŋgay hay, a gwaɗatay a nəteye mahəteye: «Ŋgwasum hərwi wu nakə faya ka ŋgatumay aye! ");
INSERT INTO meq_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Hərwi sərum ha na, ndo məɗe ha bazlam i Mbəlom hay ta bəy hay haladzay a satay haɓe məŋgatay a wu nakə faya ka ŋgatumeye, ane tuk na, ta ŋgatay bay. A satay mətsəne wu nakə faya ka tsənumeye, ane tuk na, ta tsəne bay.» ");
INSERT INTO meq_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ndo mədzaŋgawa bazlam i Mbəlom mapala eye andaya ka təv eye niye dərmak. A lətse a tsətsah ka Yesu, a gwaɗay: «Miter, na giye na mey, nakə ada nâ huta sifa nakə ma ndəviye bay aye? A tsikay andza niye na, hərwi məhəle faya abəra suwat.» ");
INSERT INTO meq_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu a gwaɗay: «Ka dzaŋga mə ɗerewel i Musa, a gwaɗ na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ndo niye a mbəɗay faya: «A gwaɗ na: “Wuɗa na Bəy Maduweŋ Mbəlom yak tə ɗərev yak tebiye, ta məsəfəre yak tebiye, ta gədaŋ yak peteh, ada tə metsehe yak tebiye.” Ada: “Wuɗa ndo i məgeɗ yak dərmak andza ka wuɗa na gər yak.”» ");
INSERT INTO meq_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu a gwaɗay: «Təɗe! Ka mbəɗa faya lele. Ge andza niye ada ka hutiye məsəfəre.» ");
INSERT INTO meq_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ane tuk na, ndo mədzaŋgawa bazlam i Mbəlom mapala eye niye a say məgwaɗay a gər ŋgay na, neŋgeye ndo i deɗek. A tsətsah ka Yesu a gwaɗay: «Ada matəra ndo nakə na wuɗiye andza neŋ aye na, way?» ");
INSERT INTO meq_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu a mbəɗay faya a gwaɗay: «Ndo wuray a yaw abəra ma Zerozelem ma diye a Zeriko. Məkal hay tə mbəzla faya. Ta buwa faya abəra wu ŋgay hay tebiye. Tə kəɗ na lehhe. Tsa na, ta hway wu tay. Tə gər ha ndo niye maɓərzla eye. ");
INSERT INTO meq_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","«Ndo məvəlay wu a Mbəlom wuray andaya a mbəzlaw ta tsəveɗ eye niye. A ŋgatay a ndo niye na, a ŋgəɗay tsaŋgəhha dəreŋ. A ye ta tsəveɗ mekeleŋ eye. ");
INSERT INTO meq_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","«Andza niye, ndo i Levit wuray a ndisl ka təv eye niye, a ŋgatay a ndo niye na, a ŋgəɗay dəreŋ. A ye ŋgway ta tsəveɗ mekeleŋ eye. ");
INSERT INTO meq_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","«Ane tuk na, ndo i Samari wuray a ye naha. Faya ma diye a mahəhele, a ndisl ka təv niye. A ŋgatay a ndo niye na, a gay mə bo haladzay. ");
INSERT INTO meq_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","A həndzəɗ naha ka təv i ndo niye lele. A pəla ha gwezem ŋgay. A zlaw guzom a baray na abəra ka mbəlak. A mbəɗa faya mal ada a ɓaray faya lele. A ndəv ha na, a zla na ka gər i zuŋgo ŋgay a ye ha a gay i mbəlok hay. A gay gər mə ɗəma lele. ");
INSERT INTO meq_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","«Tədœ eye ma ta diye ŋgway na, a tələka həlay a gwezem, a zlaw kwar i suloy sulo. A vəlay a ndo məge məsler mə gay i mbəlok niye hay. A gwaɗay: “Gay gər a ndo nakay lele. Aza na maweye tə fanaŋ na, na makeye ha wu nakə ka dze ha haladzay hərwi ŋgay aye.”» ");
INSERT INTO meq_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu a gwaɗay sa: «Ka nəkar na, mə walaŋ i ndo neheye mahkar aye, matəra ndo i məgeɗ i ndo nakay məkal hay tə kəɗ na aye na, way?» ");
INSERT INTO meq_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ndo mədzaŋgawa bazlam i Mbəlom mapala eye niye a mbəɗa faya a Yesu a gwaɗay: «Ndo nakə a gay ŋgwalak aye.» Yesu a gwaɗay: «Aya! Nəkar dərmak do ge andza niye.» ");
INSERT INTO meq_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu ta gawla ŋgay hay tə həl bo, ti ye a gəma mekeleŋ eye. Ahəl nakə nəteye ka tsəveɗ faya ta diye na, a ye a gəma wuray. Mə ɗəma na, ŋgwas eye andaya tə zalay Marta a təma na a gay ŋgay. ");
INSERT INTO meq_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ŋgwas niye na, malamar ŋgay andaya tə zalay Mari. Neŋgeye na, a ndza ka təv i Yesu faya ma piye zləm ka matətike i Yesu. ");
INSERT INTO meq_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Azlakwa bay Marta i ŋgay na, faya ma giye məsler hay wal wal ma ləver. A yaw ka təv i Yesu. A yaw na, a gwaɗay: «Bəy Maduweŋ, na gaka mə bo təbəɗew? Malamar ga a gər ga ha mahəgeye ka məge məsler hay wal wal tebiye na, kəkay. Gwaɗay mâ yaw, mâ dzəna ga.» ");
INSERT INTO meq_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bəy Maduweŋ a mbəɗay faya a gwaɗay: «Marta, Marta nəkar na, ka vəlay ha mədzal gər ada ka hatsay ɗuh a məsler haladzay na, kəkay? ");
INSERT INTO meq_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ane tuk na, wu nəte ka nəkar na, kə mətsa fakaya abəra. Mari ɗuh na, kə zla wu nakə lele aye. Ɗaɗa ndəray ma sliye məzle faya abəra bay.» ");
INSERT INTO meq_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Pat wuray na, Yesu a ɗuwulay me ma təv eye andaya. A ndəv ha maɗuwule me na, ndo nəte mə walaŋ i gawla ŋgay hay a tsətsah faya, a gwaɗay: «Bəy Maduweŋ, tətikamay maɗuwule me a Mbəlom andza i Yuhana nakə a tətikatay a gawla ŋgay hay ahəl niye.» ");
INSERT INTO meq_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu a gwaɗatay: «Ka ɗuwulumay me na, ka gwaɗumeye: Bəba may, kwa way mâ sər ha, məzele yak na, tsəɗaŋŋa. Ndo hay tebiye tâ zambaɗaka. Bəy yak mə gəma mâ ge bo ka təv may dərmak, ");
INSERT INTO meq_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","vəlamay wu mənday nakə ma slameye pat pat aye, ");
INSERT INTO meq_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pəsamay ha mənese may, hərwi nəmay dərmak nəmaa pəsatay ha a ndo neheye tə gamay mənese aye. Tsəpa may hərwi ada Fakalaw mâ səpat may bay.» ");
INSERT INTO meq_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu a gwaɗatay sa: «Agəla ndo nəte mə walaŋ kurom dzam ŋgay andaya. Ane tuk na, a ye ka təv i dzam ŋgay niye ta magərhəvaɗ. A ye naha a tsətsah a gwaɗay: “Dzam ga amboh vəleŋ tapa i ɗaf mahkar tey. ");
INSERT INTO meq_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Hərwi ndo nəte mə walaŋ i dzam ga hay a yaw a mahəhele. A ndislew anəke a gay ga. Ane tuk na, wuray andaya məvəlay bay.” ");
INSERT INTO meq_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ndo niye mə gay aye a mbəɗayaw faya, a gwaɗay: “Gər ga ha, kâ wurɗeŋ me bay! Na dərəzl na məgeɗ ga tsɨy. Neŋ ta wawa ga hay nəmaa həna tsɨy. Na sliye faya mələtse məvəlaka ɗaf sa bay.”» ");
INSERT INTO meq_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yesu a gwaɗatay sa: «Sərum ha na, kwa taɗə a say mələtse bay bəbay na, ma lətsiye ma vəleye wu nakə a say aye. Ma vəleye na, hərwi a gay amboh haladzay bəna hərwi dzam bay. ");
INSERT INTO meq_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Neŋ faya na tsikakumeye: Tsətsahum, ta vəlakumeye, pəlum, ka hutumeye, fumay a məgeɗ, ta həndəkakumeye abəra ma məgeɗ. ");
INSERT INTO meq_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Hərwi kwa way ka tsətsah na, ta vəleye, kwa way ka pəla na, ma hutiye, ada kwa way kə fay a məgeɗ na, ta həndəkeye abəra ma məgeɗ. ");
INSERT INTO meq_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«Way mə walaŋ kurom taɗə wawa ŋgay ka tsətsah faya kəlef na, ma vəleye dədœ ɗaw? ");
INSERT INTO meq_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kəgəbay ka tsətsah faya ɗəsle na, ma vəleye hərdəde ɗaw? ");
INSERT INTO meq_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nəkurom neheye sadzək ŋgwalak eye hay bay aye ka sərum məvəle wu ŋgwalak eye hay a wawa kurom hay ɗuh tuk na, ada Bəba kurom mə mbəlom ma ziye kurom ha ta məvəle Məsəfəre Tsəɗaŋŋa eye a ndo neheye ta tsətsah faya aye bəɗaw!» ");
INSERT INTO meq_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pat wuray na, Yesu faya ma həhariye fakalaw abəra mə bo i ndoweye andaya a təra ha mandək eye. Fakalaw a yaw abəra mə bo i ndo niye na, ndo niye a tsik me lele. A gatay a ndo niye hay mahaya gər eye hərɓaɓəkka. ");
INSERT INTO meq_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ndo mekeleŋ eye hay mə walaŋ tay niye na, tə gwaɗ: «Maa vəlay gədaŋ ka mahəhere fakalaw hay na, Bedzabul bəy i fakalaw hay.» ");
INSERT INTO meq_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ndo mekeleŋ eye hay na, a satay məhəle faya abəra suwat. Ta tsətsah faya tə gwaɗay: «Gamay masuwayaŋ nakə ma ɗiye ha ka yaw abəra ka təv i Mbəlom aye.» ");
INSERT INTO meq_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ane tuk na, Yesu a səratay naha ka mədzal gər tay. A gwaɗatay: «Taɗə ndo i gəma hay ta ŋgəna, faya ta giye vəram mə walaŋ tay na, gəma niye ma dziye. Gəma mekeleŋ eye ma dufiye na. Taɗə ndo hay mə gay tay faya ta giye magazləga mə walaŋ tay na, ndo niye hay mə gay niye ta hutiye gədaŋ məndze huya bay. ");
INSERT INTO meq_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Taɗə Fakalaw tə Fakalaw ma giye magazləga ka bo ŋgay na, ka dzalum na, bəy ŋgay ma ndziye huya na, ma kəkay? Sa na, ka gwaɗum maa vəleŋ gədaŋ ka mahəhere fakalaw na, Bedzabul. ");
INSERT INTO meq_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ka gwaɗum maa vəleŋ gədaŋ ka mahəhere fakalaw na, Bedzabul. Ane tuk na, a dzam kurom hay na, maa vəlatay gədaŋ ka mahəhere fakalaw hay na, way? Andza niye, dzam kurom hay faya ta ɗiye ha na, deɗek andaya mə nəkurom bay. ");
INSERT INTO meq_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Maa vəleŋ gədaŋ a neŋ ka mahəhere fakalaw na, gədaŋ i Mbəlom. Andza məgweɗe na, Bəy i Mbəlom ɓa ki yaw tsɨy hus ka təv kurom.» ");
INSERT INTO meq_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Yesu a gwaɗatay sa: «Ndo gədaŋ eye tə wu həlay ŋgay na, ma tsəpiye gay ŋgay lele wuray ma tətaliye ka zlele ŋgay kwa tsekweŋ bay. ");
INSERT INTO meq_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ane tuk na, taɗə ndo mekeleŋ eye a ze neŋgeye ta gədaŋ ki yaw na, ma buwiye faya abəra wu həlay ŋgay niye hay a səmawa ha ka bo aye. Ada ma həliye zlele i ndo niye ma ŋgənatay ha a ndo hay tebiye.» ");
INSERT INTO meq_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Yesu a gwaɗatay sa: «Ndo nakə neŋgeye tə neŋ bay aye na, neŋgeye ndo məneŋ ɗəre. Ndo nakə ka dzəna ga bay aye na, neŋgeye ɗuh ndo məneseŋ ha məsler.» ");
INSERT INTO meq_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesu a gwaɗatay sa: «Fakalaw ki yaw abəra mə bo i ndo na, ma diye ma dzədziye mə kəsaf ma pəliye təv mazəzukw bo. Kə huta bay na, ma gwaɗeye a gər ŋgay: “Na mbəɗiye gər a gay ga nakə na yaw abəra mə ɗəma aye.” ");
INSERT INTO meq_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ma mbəɗiye gər, kə ye naha kə ŋgatay a gay mafaɗa eye lele ada malambaɗa eye. ");
INSERT INTO meq_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tsa na, ma diye ma həlaweye siye i məsəfəre neheye seweɗ eye hay wene wene ta ze neŋgeye aye tasəla. Ta fələkwiye a gay, ta ndziye mə ɗəma. Ka mandəve eye na, wu niye ma miye ka ndo niye ma ziye nakə kurre aye.» ");
INSERT INTO meq_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ahəl nakə faya ma tsikiye andza niye na, ŋgwas wuray mə walaŋ i ndo niye hay haladzay aye, a wuda a gwaɗ: «Məŋgwese ka gər i ŋgwas nakə a wa kar aye ada ka sa wah ŋgay aye.» ");
INSERT INTO meq_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ane tuk na, Yesu a mbəɗay faya a gwaɗay: «Məŋgwese ɗuh na, ka gər i ndo neheye faya ta pay zləm a bazlam i Mbəlom ada faya ta giye andza nakə a tsik aye.» ");
INSERT INTO meq_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ka təv nakə ndo hay faya ta səkahiye naha haladzay ka təv i Yesu aye na, Yesu a pa bo ka mətsike, a gwaɗ: «Ndo neheye anəke aye na, lele eye hay bay. Ta tsətsahiye nâ gatay masuwayaŋ na, kəkay! Asah! Ma dəba i masuwayaŋ i Zonas ndo məɗe ha bazlam i Mbəlom nakə tə ŋgatay aye na, ta ŋgateye a masuwayaŋ mekeleŋ eye bay. ");
INSERT INTO meq_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Hərwi Zonas a təra na, masuwayaŋ ka gər i ndo i gəma i Ninive hay. Andza niye neŋ Wawa i Ndo na təriye masuwayaŋ a ndo neheye anəke aye dərmak. ");
INSERT INTO meq_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ŋgwas wuray andaya neŋgeye bəy bagwar eye, a yaw abəra ma diye i tsakay. A yaw mətsəne bazlam i Salomoŋ neheye maraha eye ta metsehe aye. Ndo andaya kanaŋ a ze ha Salomoŋ. Hərwi niye, ahəl nakə Mbəlom ma gateye sariya a ndo hay aye na, ŋgwas nakay bəy bagwar eye ma deyeweye abəra ma diye i tsakay, ma lətsiye kame i ndo neheye mamatay ha mənese. ");
INSERT INTO meq_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Pat i sariya i Mbəlom na, ndo i gəma i Ninive hay ta deyeweye. Ta lətsiye kame i ndo neheye anəke aye ta matay ha mənese. Hərwi ndo i gəma i Ninive hay tə tsəne bazlam i Mbəlom nakə Zonas a tsikatay aye na, ta gər ha mezeleme. Ndo andaya kanaŋ a ze Zonas bəɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesu a gwaɗatay sa: «Ɗaɗa ndo ma zlaweye lalam ŋgay ma piye faya ako ma ŋgahiye na kəgəbay ma hurəkwiye faya gəse ɗaw? Ma piye na ɗuh na, ka wu məpe lalam hərwi ada ndo neheye ta fələkwiye a gay aye mâ dəvatay dzaydzay. ");
INSERT INTO meq_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","«Ɗəre yak na, andza lalam ma dəviye dzaydzay a bo yak tebiye. Taɗə ɗəre yak a zəba kwetseh kwetseh lele na, bo yak kətsek mə dzaydzay. Ane tuk na, taɗə ɗəre magulufa eye na, bo yak ma ləvoŋ. ");
INSERT INTO meq_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ge metsehe lele bəna, wu nakə ma vəlakeye dzaydzay aye mâ təra ləvoŋ bay. ");
INSERT INTO meq_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Taɗə bo yak kətsek mə dzaydzay, təv kwa tsekweŋ ma ləvoŋ bəna, niye na bo yak tebiye mə dzaydzay. Niye na, andza lalam nakə dzaydzay ŋgay aye faya ma dəvakeye dzaydzay aye.» ");
INSERT INTO meq_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu a ndəv ha mətsike me na, Farisa wuray a zalay ka mənde wu mənday a gay ŋgay. Ti ye ta dazlay a mənde wu mənday. ");
INSERT INTO meq_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisa niye a zəba ka Yesu na, a gay wadəŋ wadəŋ. A gay wadəŋ wadəŋ na, hərwi Yesu kə bara həlay andza i kule tay nakə a tsik aye bay. ");
INSERT INTO meq_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bəy Maduweŋ a gwaɗay: «Nəkurom Farisa hay na, ka tsakaɗum na, dəba i gəsiyem ta dəba i bəgəlam, ane tuk na, nəkurom maraha eye ta mədzele ka makəle, ka məge seweɗ. ");
INSERT INTO meq_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nəkurom na, matərakahaŋ eye hay. Sərum ha na, Mbəlom nakə a ge dəba i wu hay aye na, maa ge huɗ eye na, neŋgeye dərmak bəɗaw? ");
INSERT INTO meq_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ɗuh na, wu neheye ma gəse ada neheye ka bəgəlam kurom hay na, vəlumatay a mətawak hay ada wu hay tebiye ma təriye hərwi kurom tsəɗaŋŋa. ");
INSERT INTO meq_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Ane tuk na, nəkurom Farisa hay na, ɗəretsətseh ka gər kurom. Hərwi ka hayumay gər a slambah i ala kurom hay tebiye na, mə kuro na, ka zlawum nəte ka vəlawumay a Mbəlom. Azlakwa ɗuh faya ka gərumeye ha deɗek tə mawuɗe bo i Mbəlom eye. Anaŋ gum wu nakə a ye ka bo məge aye, ze məgər ha siye bay. ");
INSERT INTO meq_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Nəkurom Farisa hay, ɗəretsətseh ka gər kurom. Hərwi mə gay i maɗuwule me na, ka wuɗum məndze ka təv məndze nakə ŋgwalak aye. Ada ka wuɗum tâ tsikakum me ta məɗəslakum ha gər ka təv məhay gər i ndo hay tebiye. ");
INSERT INTO meq_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","«Nəkurom na, ɗəretsətseh ka gər kurom. Nəkurom na, ka ndzəkitum bo andza tsəvay neheye ndo hay faya ta həhaliye faya tə ŋgatay bay aye!» ");
INSERT INTO meq_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ndo nəte mə walaŋ i ndo mədzaŋgawa bazlam i Mbəlom mapala eye hay a gwaɗay a Yesu: «Miter, ka tsik andza niye na, ka tsaɗa nəmay dərmak.» ");
INSERT INTO meq_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu a mbəɗay faya a gwaɗay: «Nəkurom ndo mədzaŋgawa bazlam i Mbəlom mapala eye hay dərmak, ɗəretsətseh ka gər kurom! Nəkurom na, faya ka pumeye wu mamba eye ka ndo hay. Nəkurom eye kwa ta wur həlay nets ka lamumay madzəne tay ha bay. ");
INSERT INTO meq_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«Ɗəretsətseh ka gər kurom! Hərwi nəkurom faya ka ɗəzlumeye tsəvay male eye hay. Tsəvay niye hay na, i ndo məɗe ha bazlam i Mbəlom niye hay ahəl niye bəba təte kurom hay tə kəɗ tay ha aye. ");
INSERT INTO meq_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Andza niye, ka bəzum ha na, nəkurom ma məsler i bəba təte kurom niye ahəl niye. Nəteye ta kəɗ tay hay ndo məɗe ha bazlam i Mbəlom. Nəkurom i kurom na, faya ka ɗəzlumeye ka tsəvay tay aye hay. ");
INSERT INTO meq_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Hərwi niye Mbəlom ta ndaraw ŋgay kə tsik ahəl niye, a gwaɗ: “Neŋ Mbəlom na sləratay naha ndo məɗe ha bazlam ga hay ta ndo i maslaŋ ga hay. Na slər tay naha na, ta kəɗiye tay hay siye mə walaŋ tay, ada siye hay ta gateye ɗəretsətseh.” ");
INSERT INTO meq_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","A nəkurom ndo neheye bəgom aye, Mbəlom ma ta tsətsahiye fakuma ndo məɗe ha bazlam ŋgay neheye ka kəɗum tay ha zla anəke bay, kwa ka gər nakə Mbəlom a ge məndzibəra aye. ");
INSERT INTO meq_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Mbəlom ma tsətsahiye na, kwa ka məkəɗe i Abel hus ka Zakari nakə tə kəɗ na mə walaŋ i təv məvəlay wu a Mbəlom tə gay i məɗəslay ha gər a Mbəlom aye. ");
INSERT INTO meq_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Nəkurom ndo mədzaŋgawa bazlam i Mbəlom mapala eye, ɗəretsətseh ka gər kurom. Nəkurom na, ka dərəzlumatay na məgeɗ i məsəre wu a ndo hay. Nəkurom eye na, ka deyumeye a ɗəma bay. Ada ndo neheye a satay məfələkwe a ɗəma aye na, faya ka kərahumatay eye tsəveɗ məfələkwe a ɗəma.» ");
INSERT INTO meq_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu a ndəv ha mətsike me na, a yaw abəra mə gay niye. Ndo mədzaŋgawa bazlam i Mbəlom mapala eye ta Farisa hay ta payaw bəzay abəra. Ti yaw na, tə wuya ka Yesu tə bazlam i tereŋgez hay wal wal. Ta tsətsah faya gər i bazlam hay wal wal tebiye. ");
INSERT INTO meq_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ta tsətsah faya andza niye na, hərwi ada mâ tsik bazlam nakə ŋgwalak eye bay aye. Ada a satay məhəle faya abəra suwat. ");
INSERT INTO meq_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ahəl niye na, ndo hay haladzay ta haya gər. Nəteye ta giye gwezem wiye. Faya ta mbərasliye bo ka sik tay hay. Ka təv eye niye na, Yesu a lah mətsikatay me a gawla ŋgay hay təday. A gwaɗatay: «Tsəpum gər kurom abəra ka gəɗe i Farisa hay. Andza məgweɗe bəbərek tay nakə faya ta giye aye. ");
INSERT INTO meq_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Wu nakə tebiye maŋgaha eye na, ta ɗiye ha, ada wu nakə tə tsikawa ta məkal aye na, ta ɗiye ha. ");
INSERT INTO meq_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hərwi niye wu nakə ka tsikum ma ləvoŋ aye na, ma ta ɗiye a zləm mə dzaydzay. Wu nakə ka tsikumay a zləm a ndo ta suksuk mə gay aye na, ndo hay ta ta tsəniye ka zavay. ");
INSERT INTO meq_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Malamar ga hay, neŋ faya na gwaɗakumeye: Kâ dzədzarumay a ndo neheye ta dziye ha slo i bo aye bay. Nəteye na, ta sliye faya məge wu mekeleŋ ma ziye nakay bay. ");
INSERT INTO meq_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ndo nakə ka dzədzarumeye na, na ɗakumeye ha: Dzədzarumay na, a Mbəlom. Ma dəba i mədahaŋ na, neŋgeye ɗuh ma kaliye kurom ha a ako nakə ma mbatiye ɗaɗa bay aye. Ayaw! Sərum ha lele! Dzədzarumay na, a neŋgeye. ");
INSERT INTO meq_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«Ka sərum təbəɗew, sisi hay zlam na, ta səkəm ta dala sulo bəɗaw? Mbəlom na, kwa nəte a mətsa ha gər bay. ");
INSERT INTO meq_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nəkurom na, ka zum tay ha ɗiyeŋ hay. Kwa məkwets i gər kurom na, Mbəlom kə pasla na. Aya ane kâ dzədzarum bay. ");
INSERT INTO meq_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Sərum ha na, ndoweye kə ɗa ha kame i do hay kə gwaɗ: “Neŋ gawla i Yesu” na, neŋ Wawa i Ndo na ta ɗiye ha neŋgeye gawla ga kame i gawla i Mbəlom hay dərmak. ");
INSERT INTO meq_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ane tuk na, taɗə ndoweye kə ɗa ha kame i ndo hay parakka a sər ga ha bay na, neŋ na tsikiye kame i gawla i Mbəlom hay, na sər na bay dərmak. ");
INSERT INTO meq_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","«Kwa kə tsik wu nakə lelebay aye ka neŋ Wawa i Ndo na, Mbəlom ma pəseye ha. Ane tuk na, ndoweye kə tsalay ka gər a Məsəfəre Tsəɗaŋŋa eye na, ma hutiye məpəse me bay. ");
INSERT INTO meq_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Taɗə ta diye kurom ha a gay i maɗuwule me ada kame i ndo mələve dala hərwi məge sariya na, kâ dzalum “Nəmaa ta giye kəkay” bay, kəgəbay “Nəmaa ta gwaɗiye mey” bay. ");
INSERT INTO meq_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mata ɗakum ha wu nakə ka tsikumeye na, Məsəfəre Tsəɗaŋŋa eye.» ");
INSERT INTO meq_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tsa na, ndoweye mə walaŋ i ndo niye hay a yaw ka təv i Yesu a gwaɗay: «Miter, gwaɗay a malamar ga na, nəmaâ ŋgəna zlele nakə bəba may a gəramay ha aye.» ");
INSERT INTO meq_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu a mbəɗay faya a gwaɗay: «Dzam ga, maa pa ga məgakum na sariya i wu kurom hay kəgəbay maŋgənakum ha zlele kurom na, maa pa ga way?» ");
INSERT INTO meq_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tsa na, a gwaɗatay a ndo hay tebiye: «Gum metsehe! Həbum gər kurom abəra ka bor i zlele. Hərwi kwa ndo neŋgeye zlele eye bəbay na, sifa ŋgay mə zlele ŋgay niye bay.» ");
INSERT INTO meq_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yesu a təkəratay dzeke, a gwaɗatay: «Ndoweye andaya zlele eye, wu ŋgay məpele abəra ka dala na, haladzay. ");
INSERT INTO meq_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","A dzala ada a tsətsahay a gər ŋgay, a gwaɗ: “Na giye kəkay? Təv andaya hərwi məhayay gər a wu ga hay bay.” ");
INSERT INTO meq_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","«A gwaɗ sa: “Wu nakə na giye na, anaŋ: Na mbəzliye ha de ga hay. Na ŋgariye a ɗəma bagwar eye hay neheye ta sliye ɗa məhayay gər a ɗəma a wu mənday ga hay tə siye i wu ga hay aye. ");
INSERT INTO meq_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na ge andza niye na, na gwaɗeye a bo ga: Bo ga! Wu ga na, haladzay. Ma ndziye məve weɗe weɗe. Anəke na, zəzukw bo tuk! Nda wu mənday, sa wu məsay ada ŋgwasa.” ");
INSERT INTO meq_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","«Ane tuk na, Mbəlom a gwaɗay a ndo niye: “Nəkar na, matərakahaŋ eye! Bəgom ta həvaɗ nakay na, ka mətiye. Ada wu neheye tebiye ka hayay gər aye na, i way tuk!”» ");
INSERT INTO meq_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu a gwaɗatay sa: «Andza niye, hərwi ndo nakə a hayay gər a zlele a bo ŋgay eye ŋgway aye. Ane tuk na, ka ɗəre i Mbəlom na, zlele eye bay.» ");
INSERT INTO meq_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu a gwaɗatay a gawla ŋgay hay: «Hərwi niye neŋ faya na tsikakumeye: Kâ dzalum gər hərwi wu mənday kəgəbay hərwi petekeɗ bay. ");
INSERT INTO meq_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Hərwi məsəfəre na, a ze wu mənday ada bo kurom na, a ze petekeɗ segey. ");
INSERT INTO meq_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Zəbum ka maŋgəhak hay təday: Nəteye na, ta sləga bay, tə pala wu tay tə hayay gər andaya bay. De tay andaya məpe a ɗəma wu tay hay bay. Kwa ada sewene tay andaya bay. Ane tuk na, Mbəlom faya ma vəlateye wu mənday. Nəkurom na, ka zum ɗiyeŋ hay bəɗaw? ");
INSERT INTO meq_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","«Way nakə mə walaŋ kurom ma sliye faya masəkah ha məndze ŋgay ka məndzibəra ta mədzele gər ŋgay nakə faya ma dzaliye aye na, way? ");
INSERT INTO meq_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Aya! Ka wu nakə tsekweŋ aye na, ka slum faya məge ɗuh bay tuk na, ka dzalumeye ka wu siye na hərwi mey? ");
INSERT INTO meq_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ehey zəbum ka guzer neheye mavurza eye təday! Nəteye na, tə ge məsler i wuray bay, tə ŋgar petekeɗ bay. Faya na gwaɗakumeye, kwa Salomoŋ nakə zlele eye haladzay aye, ɗaɗa kə pa ka bo petekeɗ andza məvurze i guzer neheye bay. ");
INSERT INTO meq_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Andza niye Mbəlom na, faya ma pateye ka bo petekeɗ a guzer hay ka bəgom nakay. Tədœ na, guzer niye ta kuliye. Ta kula na, ta kaliye tay ha ako. Kə ge andza niye na, nəkurom ɗuh Mbəlom ma pakumeye petekeɗ ka bo ma ziye i guzer hay bəɗaw? Kwa a nəkurom neheye mədzal gər tsekweŋ aye bəɗaw! ");
INSERT INTO meq_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","«Ka ndəɗikum gər huya ka mədzele ka wu nakə ka ta ndayumeye tə wu məse aye bay. ");
INSERT INTO meq_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Maa pəla wu neheye na, ndo neheye tə sər Mbəlom bay aye. Nəteye na, ta zəzukway bo a mapəle bay tebiye. Ane tuk na, Bəba kurom mə mbəlom a sər wu nakə a sakum aye. ");
INSERT INTO meq_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lahum mapəle na, Bəy i Mbəlom ada wu siye hay na, Mbəlom ma vəlakumeye. ");
INSERT INTO meq_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nəkurom neheye haladzay bay aye, kâ dzədzarum bay! Hərwi ki yay a gər a Mbəlom Bəba kurom kə vəlakum təv məndze ma bəy ŋgay. ");
INSERT INTO meq_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","«Nəkurom ɗuh səkəmum ha wu kurom hay ada vəlumatay suloy eye a ndo i mətawak hay. Ŋgarum gwezem neheye ta nasiye bay aye. Ada ka hayumay gər a ɗəma a zlele kurom nakə mə mbəlom aye. Mə ɗəma na, məkal ma sliye mede faya bay. Kwa mətul ma ndisliye faya bay. ");
INSERT INTO meq_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Hərwi ɗərev kurom mandza eye na, ma təv nakə zlele kurom mə ɗəma aye.» ");
INSERT INTO meq_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Ɓarum na bəzihuɗ kurom hərwi məge məsler. Pum ako ka lalam kurom hay mâ mbata bay. ");
INSERT INTO meq_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tərum na, andza ndo məge məsler neheye ndo i gay a gəratay ha gay ŋgay, a ye məzle dahəlay aye. Nəteye na, ta həbiye na hus ahəl nakə ma maweye abəra ma məzle dahəlay aye. Kə maw kə fay a məgeɗ na, ta həndəkeye na məgeɗ. ");
INSERT INTO meq_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Məŋgwese ka gər i ndo i məsler niye hay ndo i gay tay kə ndislew na, ma ndzateye a gər nəteye mandzahəra eye bay. Sərum ha lele! Ndo i gay niye ma ɓariye bəzihuɗ ŋgay ta wu i məɓere bəzihuɗ. Ma zalateye a ndo i məsler ŋgay hay. Ma ndziye tay ha ka təv məndzay. Ma vəlateye wu mənday. ");
INSERT INTO meq_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kwa taɗə a maw na, ta magərhəvaɗ kwa kə gaw mahonok ka zay magərhəvaɗ, ki yaw kə ndislew fataya faya ta həbiye na ta ndzahəra bay na, məŋgwese ka gər tay.» ");
INSERT INTO meq_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yesu a gwaɗatay sa: «Tsənum wu nakay lele: Ndo i gay mâ sər həlay nakə məkal ma deyeweye ma kəliye na aye na, ma gəriye ha gay ŋgay məkal mâ yaw mâ sləlay na bay. ");
INSERT INTO meq_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nəkurom dərmak ləvum bo, hərwi neŋ Wawa i Ndo na maweye ahəl waray na, ka sərumeye bay.» ");
INSERT INTO meq_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tsa na, Piyer a tsətsah faya a gwaɗay: «Bəy Maduweŋ, dzeke nakay ka ndzəkit ha bo na, hərwi may ɗekɗek tsukuɗu hərwi ndo hay tebiye ɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bəy Maduweŋ a mbəɗay faya, a gwaɗay: «Ndo i məsler ŋgwalak eye ada ma giye məsler tə metsehe lele eye na, way? Neŋgeye na, ndo nakə ndo i gay ŋgay a gwaɗay: “Gatay gər a siye i ndo məge məsler ga hay. Vəlatay wu mənday tə həlay eye.” ");
INSERT INTO meq_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Məŋgwese ka gər i ndo məge məsler niye taɗə ndo i gay ŋgay ki yaw, kə ndzay a gər neŋgeye faya ma giye məsler andza nakə tə tsikay aye. ");
INSERT INTO meq_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Neŋ faya na gwaɗakumeye: Sərum ha na, ndo i gay ŋgay ma gəray ha zlele ŋgay tebiye mâ ləvay gər. ");
INSERT INTO meq_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","«Ane tuk na, ndo i məsler kə gwaɗay a gər ŋgay: “Maka! Ndo i gay ga ma maweye bəse bay.” Tsa na, a pa bo ka məndeɓe ndo i məsler hasləka eye siye hay ta ndo i məsler ŋgwas eye hay. Taɗə a nda wu mənday, a sa wu məsay ada a kwaya, ");
INSERT INTO meq_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ndo i gay ŋgay ma maweye na, ka həlay nakə faya ma həbiye bay aye ada a sər bay aye. Ki yaw na, ma vəleye ɗəretsətseh haladzay, ma həhariye na ndo i məsler niye. Ma kaliye ha a təv i ndo neheye ta təma bazlam i Mbəlom bay aye. ");
INSERT INTO meq_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Taɗə ndo i məsler a sər ha wu nakə ndo i gay ŋgay a say mâ gay aye, ane tuk na, ndo i məsler kə ləva ha bo bay kəgəbay kə ge andza nakə a say a ndo i gay ŋgay aye bay na, ta geye ɗəretsətseh haladzay. ");
INSERT INTO meq_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Aya ane tuk na, ndo i məsler nakə a sər wu nakə a say a ndo i gay ŋgay mâ gay na bay na, ada kə ge wu nakə ɗa i məndeɓe na na, ta ndaɓiye na haladzay bay. Ndo nakə tə vəlay haladzay aye na, ta tsətsahiye faya haladzay dərmak. Ndo nakə tə gəray ha wu a həlay haladzay aye na, ta tsətsahiye faya haladzay wene wene aye.» ");
INSERT INTO meq_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Neŋ na yaw na, na zlaw ako məkele ka dala. A seŋ na, mâ vat anəke. ");
INSERT INTO meq_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ane tuk na, ta dzəhuɓiye ga ha a ɗəretsətseh təday, a seŋ mə ɗərev ga na, kə ge bo tsɨy. ");
INSERT INTO meq_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ka dzalum na zlaw ka məndzibəra na, zay ɗaw? Na gwaɗakumeye aʼay! Na zlaw na, maŋgəne. ");
INSERT INTO meq_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ma dazleye anəke, ndo hay zlam mə gay na, ta ŋgəniye ndo mahkar ta kəɗiye bo ta ndo neheye sulo aye. Ndo hay sulo ta kəɗiye bo ta ndo neheye mahkar aye. ");
INSERT INTO meq_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bəba ta wawa ŋgay ta səriye bo bay, wawa ta bəba ŋgay ta səriye bo bay. Maya tə dem ŋgay ta səriye bo bay ada dem ta may ŋgay ta səriye bo bay. Maya i zal ta dahəlay i wawa ŋgay ta səriye bo bay ada dahəlay i wawa ta may i zal ŋgay ta səriye bo bay.» ");
INSERT INTO meq_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu a gwaɗawatay a ndo niye hay tebiye dərmak sa: «Nəkurom na, ka ŋgatumay a pazlay kə lətsew tə məgəma na, ka gwaɗum bəse tsa, yam ma piye ada yam ma piye deɗek. ");
INSERT INTO meq_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Taɗə ka ŋgatumay a mətasl ka vəzlaw ta diye i Salawa na, ka gwaɗum merəɓe ma giye. Ada merəɓe ma giye deɗek. ");
INSERT INTO meq_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nəkurom na, ndo məvay gər a ndo hay. Ka sərum maŋgəne tay ha wu i dala tə wu i magərmbəlom na, tə waray. Ada həlay nakə anəke aye ka sərum bay na, kəkay? ");
INSERT INTO meq_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Hərwi mey, nəkurom na, ka sərum maŋgəne ha ka bo abəra wu nakə lele bay aye tə wu nakə deɗek aye bay na, ka mey? ");
INSERT INTO meq_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Taɗə ndo ka wuda fakaya, faya ka deyumeye kame i ndo məge sariya na, lambaɗum ha bazlam eye ka tsəveɗ ahəl nakə faya ka deyumeye mba aye. Kə ge andza niye bay na, ndo niye ki ye kar ha ka təv i ndo məge sariya na, ndo məge sariya ma vəliye kar ha a həlay i sidzew. Sidzew ma kaliye kar ha a daŋgay. ");
INSERT INTO meq_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Sər ha na, kwa a ləkaw fakaya dala nəte ka hama na bay na, ka deyeweye abəra ma daŋgay bay.» ");
INSERT INTO meq_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ahəl niye na, ndo hay ti yaw ka təv i Yesu. Ti ye naha ta təkəray tə gwaɗay: «Ahəl niye na, Pilat kə kəɗ siye i ndo i Galile hay. A kəɗ tay ha ahəl nakə faya ta vəlay wu a Mbəlom aye. A dzapa ha bambaz tay tə bambaz i gənaw neheye tə kəɗay a Mbəlom aye.» ");
INSERT INTO meq_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu a mbəɗatay faya a gwaɗatay: «Ka dzalum na, Galile neheye ta bəbazl tay ha aye na, ta ze siye i Galile hay tə mezeleme ɗaw? ");
INSERT INTO meq_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Neŋ faya na tsikakumeye, aʼay andza niye bay! Ane tuk na, taɗə ka gərum ha mezeleme kurom bay na, nəkurom tebiye ka mətumeye andza nəteye dərmak. ");
INSERT INTO meq_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tsukuɗu ndo niye hay kuro gər eye tsamahkar aye gay zəbol eye a mbəzl fataya ma Silowe ka dala i Zerozelem aye na, ka dzalum na, ta ze tay ha siye i ndo i dala i Zerozelem tə mezeleme ɗaw? ");
INSERT INTO meq_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Neŋ faya na tsikakumeye andza niye bay. Ane tuk na, taɗə ka gərum ha mezeleme kurom bay na, nəkurom tebiye ka mətumeye andza nəteye.» ");
INSERT INTO meq_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tsa na, Yesu a tsikatay dzeke, a gwaɗatay: «Ndoweye andaya a zəv dərizl i gərɗaf wuray andza gurov a guvah ŋgay. Pat wuray na, a ye mata ŋgəlaw hohway i gərɗaf niye. A ye naha na, dərizl i gərɗaf niye kə wa bay. ");
INSERT INTO meq_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ndo i guvah niye a gwaɗay a ndo matsəpay na guvah niye: “Zəba! Kə ge anəke məve mahkar na yawaw mata pəle naha hohway i dərizl gərɗaf nakay. Ane tuk na, na huta faya hohway bay. Ma neseŋeye ha təv ma guvah kəriye na, hərwi mey? Ɗəs na abəra mə ɗəma!” ");
INSERT INTO meq_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ane tuk na, ndo matsəpay na guvah niye a mbəɗay faya a gwaɗay: “Ndo i gay ga, biyeŋ na, gər ha. Na leye bəɗ ka tsakay eye tuwwe. Na lay na, na peye bərbur. ");
INSERT INTO meq_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Na ge ha andza niye na, agəna ka viye neŋgeɗ na, ma wiye. Kə wa bay na, ka ɗəsiye na tuk.”» ");
INSERT INTO meq_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesu faya ma tətikatay a ndo hay mə gay i maɗuwule me pat i mazəzukw bo. ");
INSERT INTO meq_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ŋgwas wuray andaya ɗəvats eye mə ɗəma dərmak. Ɗəvats niye kə ndza faya məve kuro gər eye tsamahkar. Fakalaw a təra ha. A guɗuk ha a mba faya mələtse dzik bay. ");
INSERT INTO meq_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu a ŋgatay a ŋgwas niye na, a zalay. Tsa na, a gwaɗay: «Ka mbəl abəra ma ɗəvats yak.» ");
INSERT INTO meq_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yesu a pa faya həlay. A pa faya həlay na, kwayaŋŋa a lətse dzik lele. Tsa na, ŋgwas niye a zambaɗay a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ane tuk na, wu nakə Yesu a ge, a mbəl ha ndo pat i mazəzukw bo aye na, a ndalay a bəy i gay i maɗuwule me. A tsikatay a ndo hay a gwaɗatay: «Pat andaya məkwa hərwi məge məsler. Kâ mbəlamay ha ndo na, pat niye hay bəna, pat i mazəzukw bo bay!» ");
INSERT INTO meq_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bəy Maduweŋ a mbəɗay faya a gwaɗay: «Nəkurom tebiye na, ndo neheye ta məvay gər a ndo aye! Pat i mazəzukw bo na, kwa way a pəla ha sla ŋgay kəgəbay zuŋgo ŋgay mede ha ka məse yam bəɗaw? ");
INSERT INTO meq_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ŋgwas nakay gwala i Abraham, Fakalaw a dzawa na na, neŋgeye məve kuro gər eye tsamahkar. A ye ka bo məpəle ha abəra ma mədzewe pat i mazəzukw bo bəɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bazlam i Yesu niye a mbəɗatay faya andza niye na, horoy a gatay a ndo məne ɗəre ŋgay niye hay tebiye. Ane tuk na, ndo hay tebiye na, məsler i Yesu niye a gawa aye, a ye tay a gər haladzay. ");
INSERT INTO meq_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu a gwaɗ: «Bəy i Mbəlom a ndzəkit bo na, wuye mey? ");
INSERT INTO meq_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bəy i Mbəlom a ndzəkit bo na, andza wur i ɓəzaŋ nakə ndo a zla a sləga ka dədaŋ aye. A sləga na na, a ndzohw. A gəl, a təra andza gərɗaf, ɗiyeŋ hay tə ŋgar gay tay hay ka hawal eye hay.» ");
INSERT INTO meq_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu a gwaɗatay sa: «Na ndzəkit ha Bəy i Mbəlom sa na, ta wuye mey? ");
INSERT INTO meq_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bəy i Mbəlom a ndzəkit bo na, gəɗe nakə ŋgwas a həl tsekweŋ a dzapa ha ta gufa aye. Gufa niye na, haladzay. A həlaɓ tay ha ka bo na, gufa niye mahəlaɓa eye a kwasa a həmbot.» ");
INSERT INTO meq_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu a həl bo ma diye a Zerozelem na, a ye ta wuzlahgəma ada ta gəma hay. Faya ma diye na, a ɗawa ha bazlam i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ahəl nakə faya ma tsikateye bazlam i Mbəlom aye na, ndoweye a tsətsah faya a gwaɗay: «Bəy Maduweŋ, mata təme na, ndo ma i ŋgal eye ɗaw?» Yesu a mbəɗa faya a tsikatay a ndo niye hay tebiye, a gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Gum gədaŋ məfələkwe ta tsəveɗ nakə maŋgəɗətse aye. Faya na gwaɗakumeye ndo hay haladzay ta pəliye tsəveɗ məfələkwe ada ta hutiye tsəveɗ sa bay. ");
INSERT INTO meq_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Hərwi ndo i gay kə lətse ka dərəzl a məgeɗ na, ka ndzumeye ma bəra. Ka fumeye a məgeɗ ŋgay. Ka gwaɗumeye naha: “Bəy Maduweŋ, həndəkamay na məgeɗ tey.” «Ma mbəɗakumaweye faya, ma gwaɗakumeye: “Ka yumaw məŋgay, na sər kurom ha bay.” ");
INSERT INTO meq_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","«Aya! Ka gwaɗumeye: “Ka ndayakwa wu mənday ada ka sakwa wu məsay dziye tə nəkar. Ka tətikamay bazlam i Mbəlom ka təv neheye ma gəma may aye.” ");
INSERT INTO meq_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","«Ma gwaɗakumeye sa: “Ka yumaw məŋgay na, na sər kurom ha bay, a nəkurom ndo məge mezeleme hay. Dum abəra ka təv ga!” ");
INSERT INTO meq_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","«Mə ɗəma na, ta tuwiye tə mahəpəɗe zler eye. Ka ŋgatumeye a Abraham, a Izak, a Zakob ta ndo məɗe ha bazlam i Mbəlom hay ma Bəy i Mbəlom. Nəkurom na, ta dərəzliye fakuma abəra. ");
INSERT INTO meq_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ndo hay ta deyeweye abəra mə bəzay, ma məgəma ta deyeweye ma diye i yam ada ta deyeweye ma diye i tsakay. Nəteye tebiye ta diye a Bəy i Mbəlom. Ta ndziye ta ndiye wu mənday mə ɗəma. ");
INSERT INTO meq_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ane tuk na, ndo neheye nəteye ndo i dəba hay anəke aye na, ta təriye ndo i me hay, ndo i me hay ta təriye ndo i dəba hay.» ");
INSERT INTO meq_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Yesu a ndəv ha mətsike me na, kwayaŋŋa Farisa wuray ta həndzəɗ naha ka təv ŋgay, tə gwaɗay: «Lətse do a bəra kanaŋ! Do a təv mekeleŋ eye bəna, a say a Herod məkəɗe kar.» ");
INSERT INTO meq_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu a mbəɗatay faya a gwaɗatay: «Dum gwaɗumay a mezerew niye na, na həhariye fakalaw abəra ka ndo hay ada na mbəliye tay ha ndo hay abəra ma ɗəvats bəgom tə tədœ təday. Ka pat mamahkar eye na, na ndəviye ha məsler ga. ");
INSERT INTO meq_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ane tuk na, na ndisliye ha mede ga bəgom, tədœ ada tədœ taɗay təday. Hərwi ta kəɗiye ndo məɗe ha bazlam i Mbəlom ma təv mekeleŋ na, a ye ka bo bay. A ye ka bo ta kəɗiye na ma Zerozelem.» ");
INSERT INTO meq_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yesu a dazlay mətuwe Zerozelem. A gwaɗ: «Nəkurom ndo i Zerozelem hay, nəkurom ndo i Zerozelem hay. Nəkurom neheye ka bəbazlum tay ha ndo məɗe ha bazlam i Mbəlom hay ada ka kəɗum tay ha ndo neheye Mbəlom a slərakum naha aye tə kwar! Sik nday nakə a seŋ məhayakum gər ka təv ga andza mandzekwer nakə ma hayatay gər a wawa ŋgay hay a huɗ i gwezleviyek ŋgay aye. Ane tuk na, ka wuɗum bay! ");
INSERT INTO meq_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Andza niye, neŋ faya na gwaɗakumeye: Ma dazleye anəke ka ŋgatumeŋeye sa bay hus ahəl nakə ka gwaɗumeye: “Mbəlom mâ pa ŋgama ka ndo nakə faya ma deyeweye ta məzele i Bəy Maduweŋ aye!”» ");
INSERT INTO meq_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pat i mazəzukw bo na, Yesu a ye a gay i bəy i Farisa wuray hay mata ndayaw wu mənday. Ndo hay niye tebiye mə ɗəma aye faya ta zəzuriye na Yesu. ");
INSERT INTO meq_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ndo wuray andaya ɗəvats eye, bo ŋgay mazlambara eye. Neŋgeye malətse eye kame i Yesu. ");
INSERT INTO meq_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu a dazlay a mətsike me, a tsətsah ka ndo mədzaŋgawa bazlam i Mbəlom mapala eye hay ta Farisa hay. A gwaɗatay: «Bazlam kway mapala eye kə vəl tsəveɗ məmbəle ha ndo pat i mazəzukw bo tsukuɗu kə vəl bəɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ane tuk na, a satay mambəɗay faya bay. Yesu a gəs ndo niye ɗəvats eye mə həlay. Tsa na, a mbəl ha. A gwaɗay: «Do wu yak a mətagay.» ");
INSERT INTO meq_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tsa na, a gwaɗatay a ndo niye hay: «Taɗə ndo mə walaŋ kurom, wawa ŋgay kəgəbay sla ŋgay kə dəɗ a bəɗiyem pat i mazəzukw bo na, ma diye kwayaŋŋa ma zla ahaya abəra mə ɗəma bəɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ndo niye hay ta mba faya mambəɗay faya bay. ");
INSERT INTO meq_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu a ge ŋgoɗgor ka ndo neheye tə zalatay ka wu mənday aye. A ge fataya ŋgoɗgor na, hərwi tə lah ka təv məndzay lele eye. Hərwi niye a tsikatay a ndo niye hay tebiye ta dzeke. ");
INSERT INTO meq_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","A gwaɗatay: «Taɗə ndo kə zalaka a magurlom i məzle dahəlay na, kâ ye kâ ndza ka təv məndzay lele eye bay. Ka ndza ka təv məndzay lele eye na, agəna ta zalay a ndo nakə a ze kar aye dərmak. ");
INSERT INTO meq_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ada ndo nakə a zalakum ta ndo niye, ki yaw na, ma gwaɗakeye: “Lətse! Gəray ha təv məndzay a ndo nakay.” Ka lətsiye, ka diye ka təv məndze nakə duk aye na, horoy ma gakeye. ");
INSERT INTO meq_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ɗuh bay, taɗə ta zalaka na, do ndza ka təv məndzay nakə lelebay duk ma dəba aye, hərwi ada ahəl nakə ndo nakə a zalaka ki yaw na, ma gwaɗakeye: “Dzam ga, dara ndza ka təv məndzay lele eye. Andza niye, nəkar, ka təriye kame i ndo niye mazala eye hay tebiye na, ndo bagwar eye.” ");
INSERT INTO meq_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Hərwi ndoweye ka səgər ha bo ŋgay na, ta təriye ha wawa eye. Ndoweye kə həna ha gər, a təra ha bo ŋgay wawa eye na, ta səgəriye ha bagwar eye.» ");
INSERT INTO meq_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tsa na, Yesu a gwaɗay a ndo nakə a zalay aye: «Taɗə ka vəliye wu mənday a ndo hay na, kâ zalatay a dzam yak, a malamar yak hay, a gwala yak hay, a ndo i zlele hay bay, hərwi nəteye na, ta sliye faya məzalaka. Ta hamakeye wu mənday nakə ka vəlatay aye. ");
INSERT INTO meq_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ane tuk na, taɗə ka vəlateye wu mənday i magurlom a ndo hay na, zalatay a ndo i mətawak hay, a ndo videl eye hay, a ndo matəra eye hay, ada a guluf hay. ");
INSERT INTO meq_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ka ge andza niye na, ka ta hutiye məŋgwese pat nakə ndo i ŋgwalak hay ta lətseweye abəra ma mədahaŋ aye. Nəteye na, wu tay andaya məvəlatay a ɗəma bay. Mata vəlatay a ɗəma na, Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ndo niye hay tebiye tə tsəne bazlam i Yesu niye na, ndo nəte mə walaŋ tay a gwaɗay a Yesu: «Məŋgwese ka ndo nakə ma ta ndiye wu mənday ma Bəy i Mbəlom aye.» ");
INSERT INTO meq_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu a mbəɗay faya a gwaɗay: «Pat wuray na, ndoweye andaya a da wu mənday haladzay. A da wu mənday niye na, a zalatay a ndo hay haladzay ka mənde. ");
INSERT INTO meq_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Həlay i mənde wu mənday a sla na, a slər ndo i məsler ŋgay mata zalatayaw a ndo hay. Mâ gwaɗatay tâ yaw anəke hərwi wu mənday maləva bo eye tsɨy. ");
INSERT INTO meq_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«Ndo i məsler a həl bo a ye a gwaɗatay dumara. Ane tuk na, kwa way a may ha me. Ndo makurre eye a gwaɗay a ndo i məsler: “Na slay mede naha bay. Na səkəm guvah anəke na zəbaweye faya təday. Pəsa ga ha, mâ ndalaka bay.” ");
INSERT INTO meq_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","«Ndo neŋgeɗ a gwaɗay: “Na səkəm sla hay anəke sulo sulo zləm, na diye na ta dziye tay ha təday. Amboh pəsa ga ha, na slay naha bay. Mâ ndalaka bay.” ");
INSERT INTO meq_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","«Ndo mekeleŋ eye a gwaɗay sa: “Na zla dahəlay anəke hərwi niye na slay naha mede naha bay.” ");
INSERT INTO meq_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Ndo i məsler niye a maw a mətagay. A ye ka təv i ndo i gay ŋgay. A təkəray bazlam i ndo niye hay a ndo i gay ŋgay. Ndo i gay ŋgay a tsəne andza niye na, a ndalay haladzay. A gwaɗay a ndo i məsler ŋgay: “Do bəse ka təv məhay gər hay, ka tsəveɗ i walaŋ i gay hay. Zalatayaw a ndo i mətawak hay, a ndo videl eye hay, a guluf hay, a ndo matəra eye hay, tâ yaw kanaŋ.” ");
INSERT INTO meq_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«Ndo i məsler a ye a zalatayaw a slala i ndo niye hay. A maw a gwaɗay a ndo i gay ŋgay: “Ndo i gay ga na ge məsler nakə ka tsikeŋ aye, ane tuk na, təv andaya ndo hay ta rah a ɗəma bay.” ");
INSERT INTO meq_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","«Tsa na, ndo i gay ŋgay a gwaɗay: “Do ka tsəveɗ neheye a ye a gəma wawa eye hay ada ka tsəveɗ neheye a ye ta tsakay i dzal aye. Gatay kutoŋ tâ yaw ada gay ga mâ rah ta ndo hay ɓirtsitse. ");
INSERT INTO meq_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Neŋ faya na gwaɗakum eye: Ndo neheye tə lah məzalatay kurre ta yaw bay aye na, ndəray kwa nəte mə walaŋ tay ta ndzakiye ɗaf ga bay.”» ");
INSERT INTO meq_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ndo hay haladzay tə paway bəzay a Yesu. Ahəl nakə faya ta diye ka tsəveɗ aye na, Yesu a mbəɗa me ka təv i ndo niye hay faya ta pay bəzay aye, a gwaɗatay a nəteye niye tebiye: ");
INSERT INTO meq_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Ndo nakə a say matəre gawla ga aye na, mâ wuɗa bəba ŋgay, may ŋgay, ŋgwas ŋgay, wawa ŋgay hay, malamar ŋgay hasləka eye hay kwa malamar ŋgay dem eye hay, mâ wuɗa tay ha mâ ze neŋ bay, kwa məgwaɗay a gər ŋgay neŋ eye mâ ze neŋ bay, bəna, ma sliye faya matəre gawla ga bay. ");
INSERT INTO meq_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ndoweye kə zla mayako mazləlmbaɗa eye kə peŋ bəzay bay na, ma sliye faya matəre gawla ga bay. ");
INSERT INTO meq_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Taɗə ndo mə walaŋ kurom a say məge gay na, ma ndziye ada ma pasliye suloy nakə ma dziye ha ka məge gay, ma zəbiye faya ma sleye ɗa mandəve ha məsler ɗaw. ");
INSERT INTO meq_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Andza niye taɗə kə dzala faya dze bay. A pa naha mədok eye ɗekɗek tsa, ka ndəv ha maɗəzle bay na, ndo hay ta ŋgatay na, ta ŋgwasiye faya. ");
INSERT INTO meq_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ta gwaɗiye: “Ndo nakay a dazlay a maɗəzle gay tuk na, kə mba faya mandəv ha məsler eye bay!” ");
INSERT INTO meq_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«Andza niye bəy nakə sidzew ŋgay hay gwezem kuro aye na, ma diye mata ge vəram ta bəy nakə sidzew ŋgay hay gwezem kuro kuro sulo aye ɗaw? Ma ta diye madazlay a vəram na, ma ndziye ma dzaliye gər lele təday. Ma tsətsahiye a gər ŋgay: “Anəke na, ta sidzew ga hay gwezem kuro na, na sliye faya məge vəram ta bəy nakə sidzew ŋgay hay gwezem kuro kuro sulo aye ɗaw?” ");
INSERT INTO meq_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Taɗə ma sliye faya bay na, ma sləriye ndo hay ka təv i bəy niye ahəl nakə neŋgeye dəreŋ mba aye. Ma tsətsahiye naha faya məndze zay.» ");
INSERT INTO meq_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yesu a gwaɗatay sa: «Andza niye mə walaŋ kurom dərmak, taɗə ndoweye kə gər ha wu ŋgay tebiye bay na, ma sliye faya matəre gawla ga bay.» ");
INSERT INTO meq_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yesu a tsikatay dzeke mekeleŋ eye sa, a gwaɗatay: «Ayaw sluwal na, wu nakə lele aye. Ane tuk na, taɗə sluwal a vəɗ sa bay na, ta sliye matəre ha mâ vəɗ həraɓəɓa sa na, ma kəkay? ");
INSERT INTO meq_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ta sliye faya məge ha məsler sa bay. Kwa məkutse a guvah andza bərbur bəbay na, ma giye ŋgama bay. Ta kutsiye ha a bəra. Ndo nakə zləm andaya faya mətsəne aye na, mâ tsəne lele!» ");
INSERT INTO meq_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pat wuray na, ndo matsekele dzaŋgal hay ta siye i ndo i mezeleme hay tebiye ti ye ka təv i Yesu. Nəteye niye tebiye ti ye na, mata pay zləm a bazlam i Yesu. ");
INSERT INTO meq_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farisa hay ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye tə ŋgatay a Yesu ta ndo niye hay na, tə may ha mənese a Yesu, tə gwaɗ: «Ndo nakay i ŋgay a təma tay ha ndo i mezeleme hay ada ta ndiye ka bo wu mənday ka təv manəte eye na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesu a səratay naha ka wu nakə faya ta tsikiye. A mbəɗatay faya ta dzeke, a gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Taɗə ndəray mə walaŋ kurom təɓaŋ ŋgay hay andaya temerre ada a dze faya abəra nəte mə walaŋ i təɓaŋ ŋgay niye hay na, ma gəriye ha kuro kuro tsɨɗ gər eye tsɨɗ eye niye hay, ma diye mapəla ahaya nəte eye niye a dze aye ma huta ahaya təday bəɗaw? ");
INSERT INTO meq_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Taɗə kə huta na na, ɗərev ŋgay ma ŋgwasiye haladzay. Ma pa ahaya təɓaŋ ŋgay niye ka dzegwem, ");
INSERT INTO meq_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ma zla ahaya a mətagay. Kə zla ahaya na, ma zalateye a dzam ŋgay hay ta ndo i məgeɗ ŋgay hay ada ma gwaɗateye: “Dumara ŋgwasakwa ka bo dziye hərwi təɓaŋ ga nakə a dze aye na, na huta na.”» ");
INSERT INTO meq_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yesu a gwaɗatay sa: «Taɗə ndo nəte kə gər ha mezeleme ŋgay na, sərum ha na, məŋgwese ma giye andaya ka təv i Mbəlom mə mbəlom andza niye dərmak, a ze ndo neheye kuro kuro tsɨɗ gər eye tsɨɗ ta zəba ka bo tay andza mezeleme andaya fataya təbey, a satay məgəre ha mezeleme tay bay aye.» ");
INSERT INTO meq_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesu a gwaɗatay sa: «Kəgəbay, ŋgwas waray nakə kwar i suloy andaya kuro ada a dze faya abəra nəte na, ma piye ako ka lalam, ma faɗiye na gay ŋgay ada ma pəliye na tə marəzlay a gər eye lele ma hutiye na təday. ");
INSERT INTO meq_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kə huta na na, ma zalateye a dzam ŋgay hay ta ndo i məgeɗ ŋgay hay. Ma gwaɗateye: “Dumara, ŋgwasakwa ka bo dziye hərwi na huta na kwar i suloy ga nakə a dze aye.”» ");
INSERT INTO meq_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yesu a gwaɗatay sa: «Sərum ha, taɗə ndo nəte kə gər ha mezeleme ŋgay na, məŋgwese andaya mə walaŋ i gawla i Mbəlom hay.» ");
INSERT INTO meq_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu a gwaɗatay sa: «Ndoweye andaya na, wawa ŋgay hay sulo. ");
INSERT INTO meq_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Pat wuray na, bo wawa eye nakə a tsətsah ka bəba ŋgay, a gwaɗay: “Bəba ga, zlele yak nakə ka ŋgənamay ha aza ta malamar ga aye na, vəleŋ faya abəra i ga anəke.” Bəba tay a tsəne andza niye na, a ŋgənatay ha zlele ŋgay a wawa ŋgay niye hay sulo aye. ");
INSERT INTO meq_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","«A ndza məhəne tsekweŋ na, wawa niye bo wawa eye a həl zlele nakə bəba ŋgay a vəlay aye, a səkəm ha. Ma dəba eye na, a həl bo a ye ha ka bo ta suloy niye a gəma dəreŋ eye. A ndisl a gəma niye na, a dazlay a məge wu nakə lelebay aye. A nas ha suloy niye tebiye. ");
INSERT INTO meq_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","«Suloy niye a ndəv faya abəra tebiye na, mandərzlaŋ bagwar eye a ge ma gəma eye niye. Wawa niye a huta wu mənday sa bay. ");
INSERT INTO meq_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tsa na, a ye mata pəle məsler. A huta məsler niye na, mə gay i ndo wuray ma gəma eye niye. Ndo niye a slər ha a pesl mata tsəkure madəras hay. ");
INSERT INTO meq_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ahəl nakə neŋgeye faya ma tsəkuriye madəras hay aye na, may a wur faya. A say haɓe mənde wu mənday nakə tə vəlawatay a madəras hay aye na, ndəray kə vəlay bay. ");
INSERT INTO meq_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«Tsa na, a dazlay mədzele ka ɗəretsətseh ŋgay. A dzala ka məndze ŋgay nakə mə gay i bəba ŋgay aye, a gwaɗ: “Mə gay i bəba na, ndo i məsler ŋgay hay faya ta ndiye wu mənday lele ada a ze naha fataya abəra. Ada neŋ tuk na, na mətiye tə may kanaŋ na, kəkay! ");
INSERT INTO meq_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ŋgama anəke na, na həliye bo na miye ka təv i bəba ga. Na ye na, na gwaɗeye: Bəba ga, na ge mənese kame i Bəba Mbəlom ada kame yak. ");
INSERT INTO meq_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Anəke na, na sla tâ zeleŋ wawa yak sa bay. Təra ga ha andza ndo i məsler yak tsa.” ");
INSERT INTO meq_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","A dzala andza niye na, a həl bo a mbəɗa gər a gay i bəba ŋgay. «Mazlambar ma ndisliye a gay i bəba ŋgay na, bəba ŋgay a ŋgatay naha dəreŋ. A ŋgatay naha na, a gay mə bo haladzay. Tsa na, a hway ka təv ŋgay. A ye naha a gəs na ka bo təmbolok təmbolok tə məŋgwese eye lele. ");
INSERT INTO meq_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yawa! Wawa niye a gwaɗay: “Bəba ga, neŋ na, na ge mənese kame i Mbəlom ada kame yak. Neŋ na, na sla tâ zeleŋ wawa yak sa bay.” ");
INSERT INTO meq_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","«Ane tuk na, bəba ŋgay a zalatay a ndo i məsler ŋgay hay, a gwaɗatay: “A niye bəse! Dum naha, zlumaw rəkwat nakə a le haladzay aye ada kalumay ka bo. Dum naha, zlumaw matsəraɗ, pumay a wur i həlay ada həlumaw tahərak, pumay a sik. ");
INSERT INTO meq_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Gəsumaw sla niye magəla eye, kəɗum. Ndayakwa ada ka hatsakweye. ");
INSERT INTO meq_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Hərwi wawa ga nakay na, haɓe na gwaɗ kə mət, anəke na, neŋgeye andaya tə ɗəre. Haɓe kə dze, anəke na, na huta na. Anəke na, ɗərev ga kə ŋgwasa.” Tsa na, ta dazlay a məhetse tuk. ");
INSERT INTO meq_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Ahəl nakə faya ta hatsiye aye na, wawa ŋgay bagwar eye mə pesl ma guvah. Həlay i madayaw ŋgay a mətagay a sla na, a həlaw bo abəra ma guvah. A yaw mazlambar bəse tə gay i bəba ŋgay na, a tsəne məhetse ta gaŋgaŋ eye dəɓtsim dəɓtsim. ");
INSERT INTO meq_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tsa na, a zalay a ndo nəte mə walaŋ i ndo i məsler i bəba ŋgay hay, a tsətsah faya a gwaɗay: “Maa ge mə gay kway bəgom na, mey?” ");
INSERT INTO meq_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ndo i məsler i bəba ŋgay niye a mbəɗay faya a gwaɗay: “Faya ta hatsiye hərwi malamar yak kə maw ma təv eye. Ada bəba yak a kəɗ sla niye magəla eye hərwi kə huta na wawa ŋgay, neŋgeye andaya zayzay lele, wuray kə gay bay.” ");
INSERT INTO meq_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«Wawa bagwar eye a tsəne andza niye na, a ndalay haladzay. A kərah mede a mətagay. Bəba ŋgay a yaw ka təv ŋgay, a gay amboh. A gwaɗay: “Dara a mətagay.” ");
INSERT INTO meq_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ane tuk na, wawa ŋgay a mbəɗay faya a gwaɗay: “Tsəne wu nakə na tsikakeye təday. Kwa anəke bay, na gaka məsler na, məve haladzay ada ɗaɗa na kərah bazlam yak ɗaw? Ka vəleŋ wawa i voʼar ada nâ ge ha magurlom ta dzam ga hay tey na, ka vəleŋ ɗaw? ");
INSERT INTO meq_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ane tuk na, anaŋ wawa yak nakay a nasaka ha zlele ka ŋgwas hay aye na, anəke a maw na, ka kəɗay sla sa na, kəkay?” ");
INSERT INTO meq_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«Bəba ŋgay a mbəɗay faya a gwaɗay: “Wawa ga, mâ ndalaka bay. Nəkar mandza eye na, huya ka təv ga ada zlele ga hay tebiye na, i yak bəɗaw? ");
INSERT INTO meq_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","A ye ka bo təɗe məge magurlom tə məŋgwese eye na, lele ŋgway. Hərwi malamar yak nakay na gwaɗ na, kə mət. Anəke na, neŋgeye andaya tə ɗəre. Haɓe kə dze, anəke na, na huta na!”» ");
INSERT INTO meq_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ma dəba eye na, Yesu a gwaɗatay a gawla ŋgay hay sa: «Ndoweye andaya zlele eye, ndo məpesle suloy ŋgay andaya. Ti ye naha tə gwaɗay a ndo i zlele niye: “Ndo məpaslaka na suloy yak na, faya ma nasakeye ha zlele yak.” ");
INSERT INTO meq_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","«Ndo i zlele niye a tsəne andza niye na, a zalay a ndo məpesle suloy ŋgay niye a gwaɗay: “Na tsəne ndo hay tə tsik ka nəkar na, mey? Suloy nday na, pesleŋ na ka ge ha na, wu waray wu waray, hərwi nəkar na, ka sliye faya matəre ndo i məsler ga sa bay.” ");
INSERT INTO meq_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«Ndo məpesle suloy niye a tsik mə gər ŋgay, a gwaɗ: “Ndo i gay ga ma həhariye ga abəra ma məsler ŋgay ada na giye na, kəkay? Ada kwa gədaŋ ga andaya məfəte sa bay tuk na, kəkay? Na gwaɗ na rəkiye na, horoy ma geŋeye. ");
INSERT INTO meq_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ah! Na sər na giye hərwi ada ndo hay ta təmiye ga a gay tay taɗə ta kal ga ha abəra ma məsler na!” ");
INSERT INTO meq_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«A ye a zalatay a ndo neheye gwedere i ndo i gay ŋgay andaya fataya aye nəte ta nəte. Ti ye naha. Tsa na, a gwaɗay a ndo kurre eye: “Gwedere i ndo i gay ga fakaya na, nday?” ");
INSERT INTO meq_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","«Ndo niye a mbəɗay faya a gwaɗay: “Dos i mal temerre.” Ndo məpesle suloy niye a gwaɗay: “Ɗerewel i gwedere yak anaŋ. A niye ndza bəse, watsa a ɗəma na, dos i mal kuro kuro zləm tsa.” ");
INSERT INTO meq_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","«Tsa na, a gwaɗay a ndo neŋgeɗ: “Ada nəkar na, gwedere i ndo i gay ga fakaya na, nday?” Ndo niye a mbəɗay faya a gwaɗay: “Taɓay i bəle temerre.” «Ndo məpesle suloy niye a gwaɗay: “Ɗerewel i gwedere yak anaŋ. A niye ndza bəse, watsa a ɗəma taɓay i bəle kuro kuro tsamahkar tsa.” ");
INSERT INTO meq_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","«Ndo i gay ŋgay a ŋgatay andza niye na, a zambaɗay a ndo məpesle suloy ŋgay hərwi a ge məsler ta bəbərek. Andza niye, ndo neheye tə sər Mbəlom bay aye na, tə dzala ka wu nakə ma ta giye bo kame aye. Ta wuɗa bo mə walaŋ tay. Nəteye bəbərek eye hay ta ze ha ndo i Mbəlom hay.» ");
INSERT INTO meq_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu a səkah ha me ŋgay niye, a gwaɗatay: «Neŋ faya na gwaɗumeye sa: Gum ŋgwalak tə zlele i məndzibəra nakay lele. Hərwi taɗə ka ndəv fakuma abəra na, ka ta hutumeye sifa nakə ma ndəviye bay aye. ");
INSERT INTO meq_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","«Ndo nakə a ge wu wawa eye hay ta tsəveɗ eye na, ma giye wu bagwar eye hay ta tsəveɗ eye dərmak. Ndo nakə kwa wu wawa eye hay a ge na ta tsəveɗ eye bay aye na, wu bagwar eye hay dərmak ma giye na ta tsəveɗ eye bay. ");
INSERT INTO meq_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ada taɗə ka mbum faya məge məsler ta tsəveɗ eye lele tə zlele i məndzibəra nakay bay na, mata vəlakum zlele lele eye na, way? ");
INSERT INTO meq_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Taɗə ka sərum məgay gər a wu i ndo hay bay na, mata vəlakum wu kurom neheye ka ləvumay gər aye na, way? ");
INSERT INTO meq_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Ndəray ma sliye məge məsler a ndo i gay ŋgay hay sulo bay. Hərwi pat neŋgeɗ na, ma geye seweɗ a ndo i gay ŋgay neŋgeɗ, ma wuɗiye na neŋgeɗ lele. Kəgəbay ma gəseye me a ndo neŋgeɗ, a ndo neŋgeɗ na, ma gəseye me bay tebiye. Nəkurom bəbay ka slumeye faya məge məsler a Mbəlom ada a suloy sulo sulo bay.» ");
INSERT INTO meq_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisa hay tə tsəne bazlam i Yesu neheye a tsik aye tebiye. Tə ŋgwasa ka Yesu hərwi nəteye na, ta wuɗa suloy haladzay. ");
INSERT INTO meq_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu a gwaɗatay a Farisa niye hay: «Nəkurom ka təv ɗəre i ndo hay na, ka gwaɗum nəkurom ndo lele eye hay. Ane tuk na, Mbəlom na, a sər ɗərev kurom hay. Hərwi wu nakə ndo hay tə gwaɗ bagwar eye na, ka təv ɗəre i Mbəlom na, lele bay tebiye. ");
INSERT INTO meq_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Həlay i bazlam i Musa mapala eye tə ɗerewel i ndo məɗe ha bazlam i Mbəlom hay kə ndza hus a həlay i Yuhana madzəhuɓe ndo a yam. Kwa abəra ahəl niye na, tə ɗawa ha Labara Ŋgwalak eye i Bəy i Mbəlom. Həlay nakay na, kwa way a ge gədaŋ hərwi məfələkwe a Bəy i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Magərmbəlom ta dala na, ta ndəviye. Ane tuk na, kwa wu tsekweŋ ma dziye abəra mə bazlam ga mapala eye bay. ");
INSERT INTO meq_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Ndoweye ka həhar na ŋgwas ŋgay ada kə zla a ɗəma ŋgwas mekeleŋ eye na, kə ge madama. Ada ndoweye kə zla ŋgwas nakə zal ŋgay a həhar na aye na, kə ge madama dərmak.» ");
INSERT INTO meq_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu a gwaɗatay sa: «Ndoweye andaya zlele eye. Neŋgeye a pawa ka bo petekeɗ nakə a le haladzay aye ada masəkəme ŋgay eye na, suloy haladzay. Neŋgeye mandza eye pat pat ma wiya ada wu mənday ŋgay na, lele. ");
INSERT INTO meq_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ndoweye andaya dərmak məzele ŋgay Lazar. Neŋgeye na, mətawak eye, wuray ŋgay andaya bay. Bo ŋgay tebiye na, mbəlak eye ɗekɗek. A yaw ka məgeɗ i ndo i zlele niye. A hənawa mə ɗəma. ");
INSERT INTO meq_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A say haɓe mənde batatuk i wu mənday nakə a kutsawa abəra ka təv mənde wu mənday i ndo i zlele niye. Ane tuk na, kəra hay tə yawa naha ka təv ŋgay mandekeɗe mbəlak ŋgay niye ɗuh. ");
INSERT INTO meq_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Ma dəba eye na, Lazar a mət. Gawla i Mbəlom hay tə zla na ka təv i Abraham. Ndo niye zlele eye a mət dərmak. Tsa na, tə la na. ");
INSERT INTO meq_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ndo niye zlele eye na, a sawa ɗəretsətseh haladzay ma təv məndze i mədahaŋ hay. A zəba ɗəre, a ma ha ɗəre a gəma na, a ŋgatay naha a Abraham ta Lazar nəteye ka təv manəte eye dəreŋ tə neŋgeye. ");
INSERT INTO meq_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","A zalay naha a Abraham, a gwaɗay: “Bəba ga Abraham, na gaka mə bo təbəɗew? Amboh slər Lazar na, mâ tələka wur həlay ŋgay a yam ada mâ təkweŋew ka ɗərneh mageŋ zayya tey. Hərwi neŋ faya na siye ɗəretsətseh haladzay ma ako nakay.” ");
INSERT INTO meq_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«Ane tuk na, Abraham a gwaɗay naha: “Wawa ga, sər ha na, ka huta ka məndzibəra na, haladzay. Lazar neŋgeye na, kə sa ɗəretsətseh haladzay. Anəke na, neŋgeye mandza eye barbarra, ma ndiye i ŋgay tey. Anəke nəkar na, ka siye ɗəretsətseh dərmak tey. ");
INSERT INTO meq_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ada sa tsa na, bəɗ zəbol eye mə walaŋ kway. Andza niye ndo neheye a satay mede naha a diye kurom aye na, ta sliye faya mede naha bay. Ada madayaw abəra ka təv kurom a təv may bəbay na, ma tasiye bo bay.” ");
INSERT INTO meq_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Ndo i zlele niye a gwaɗay naha a Abraham: “Amboh, slər Lazar a gay i bəba ga, ");
INSERT INTO meq_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","malamar ga hay andaya zlam. Mâ ye mâ gatay ɗaf na, tâ yaw a təv i ɗəretsətseh nakay bay.” ");
INSERT INTO meq_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«Abraham a mbəɗay faya, a gwaɗay: “Malamar yak hay na, Musa ta ndo məɗe ha bazlam i Mbəlom hay andaya ta ɗatay ha. Tâ pay zləm a bazlam tay.” ");
INSERT INTO meq_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","«Ndo i zlele niye a gwaɗay a Abraham: “Niye na, ma sliye ɗa bay, bəba ga Abraham. Ane tuk na, taɗə ndəray a maw abəra ma bəɗ, a ye ka təv tay na, ta mbəɗiye ha mede tay.” ");
INSERT INTO meq_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","«Abraham a gwaɗay: “Taɗə ta pay zləm a Musa ta ndo məɗe ha bazlam i Mbəlom hay bay na, kwa ndo mâ lətsew abəra ma mədahaŋ, mâ ye ka təv tay bəbay na, ta tsəniye bay.”» ");
INSERT INTO meq_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu a gwaɗatay a gawla ŋgay hay: «Wu hay andaya haladzay ta səpatiye tay ha ndo hay ka məge mezeleme. Kutoŋ ma giye bo andza niye. Ane tuk na, ɗəretsətseh ka gər i ndo nakə ma səpatiye ndo hay ka məge mezeleme aye. ");
INSERT INTO meq_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ŋgama tâ ɓaray maɗiz i kwar a ɗay ada tâ kal ha a huɗ i bəlay tə bəmalə nakə ma səpatiye nəte mə walaŋ i wawa neheye tsekweŋ tsekweŋ ka məge mezeleme aye. ");
INSERT INTO meq_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Anəke na, gum metsehe lele, həbum gər kurom. «Taɗə malamar yak kə gaka mənese na, tsikay faya ta tsəfetsəfe aye. Ada taɗə kə gər ha mezeleme ŋgay na, pəsay ha mezeleme ŋgay. ");
INSERT INTO meq_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Taɗə a gaka mənese mə walaŋ i məhəne nəte sik tasəla ada faya ma deyeweye ka təv yak məgwaɗaka: “Na nasaka, amboh pəsa ga ha” na, pəsa ha.» ");
INSERT INTO meq_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ndo i maslaŋ i Yesu hay ta tsətsah, tə gwaɗay a Yesu: «Bəy Maduweŋ, səkahamay ha mədzal gər ka nəkar tey.» ");
INSERT INTO meq_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bəy Maduweŋ a mbəɗatay faya a gwaɗatay: «Taɗə ta deɗek mədzal gər kurom mâ ge andaya tsekweŋ andza wur i ɓəzaŋ na, ka slumeye faya məgwaɗay a dərizl i gərɗaf i kuvoray nakay: “Ŋgwaɗ abəra kanaŋ, do ta zəv bo a bəlay” na, ma gəsakumeye me.» ");
INSERT INTO meq_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesu a gwaɗatay sa: «Way nakə mə walaŋ kurom, ndo i məsler ŋgay faya ma fəteye ma guvah agəna ma tsəkureye na gənaw ŋgay hay, kə maw a mətagay na, ndo i gay ŋgay ma gwaɗeye: “Dara bəse, nda ɗaf” ɗaw? ");
INSERT INTO meq_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ane tuk na, ma gwaɗeye ɗuh na: “Do naha, deŋew ɗaf ga. Mbəɗaw ka bo petekeɗ mekeleŋ hərwi məhəleŋew ɗaf ga. Ahəl nakə neŋ faya na ndiye ada na siye wu məse aye na, ma dəba eye nəkar dərmak ka sliye faya mənde wu mənday ada ka siye wu məse.” Ndo i gay ŋgay ma tsikeye andza niye bəɗaw? ");
INSERT INTO meq_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ka dzalum na, ma geye sɨsœ a ndo i məsler ŋgay niye hərwi kə gay na wu nakə a tsikay ge aye ɗaw? ");
INSERT INTO meq_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","«Nəkurom dərmak andza niye, taɗə ka gum məsler nakə Mbəlom a gwaɗakum “gum” aye na, gwaɗum ɗuh na: “Nəmay ndo məge məsler tsa hərwi nəmay, nəmaa ge na, məsler nakə təɗe a ye ka bo nəmaa giye.”» ");
INSERT INTO meq_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu faya ma diye a Zerozelem na, a ye tə kokway nakə a ŋgəna ha dala i Samari ta dala i Galile aye. ");
INSERT INTO meq_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mazlambar ma ta ndisliye a gəma wuray na, ndo madəgwaɗa eye hay kuro ta hway naha a satay mədzəgər tage Yesu. Tə lətse dəreŋ. ");
INSERT INTO meq_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tsa na, ta wuda ta gədaŋ, tə zalay naha a Yesu, tə gwaɗ: «Yesu, Bəy! Nəmaâ gaka mə bo təbəɗew!» ");
INSERT INTO meq_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu a ŋgatatay, a gwaɗatay naha: «Dum ta bəzumay ha bo a ndo neheye tə vəlaway wu a Mbəlom aye.» Nəteye faya ta diye mata bəzatay ha bo a ndo məvəlaway wu a Mbəlom na, tə mbəl suwuɗ suwuɗ. ");
INSERT INTO meq_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ndo nəte mə walaŋ tay a zəba ka bo ŋgay na, kə mbəl suwuɗ suwuɗ. A mbəɗa gər ka təv i Yesu pəlasl. A ye tə mazambaɗay naha a Mbəlom ta magala. ");
INSERT INTO meq_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","A ye naha na, a kal ha bo kame i Yesu ta daʼar luz ka dala. A gay sɨsœ haladzay a Yesu. Ndoweye niye na, ndo i Samari hay. ");
INSERT INTO meq_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu a gwaɗ: «Na gwaɗ tə mbəl na, kuro tebiye bəɗaw? Neheye tsɨɗ eye na, nəteye məŋgay? ");
INSERT INTO meq_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ndəray kə dzala mə walaŋ tay madayaw məgay naha sɨsœ a Mbəlom bay. Ɗuh mayaw na, bərakəzaŋ nakay ɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tsa na, Yesu a gwaɗay a bərakəzaŋ niye: «Lətse! Do wu yak, mədzal gər yak nakə ka dzala ha ka neŋ aye kə mbəl kar ha.» ");
INSERT INTO meq_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pat wuray na, Farisa hay ta tsətsah ka Yesu, tə gwaɗay: «Bəy i Mbəlom ma ta deyeweye na, kəɗay?» Yesu a mbəɗatay faya a gwaɗatay: «Bəy i Mbəlom ma deyeweye na, ndo hay ta ŋgateye bay. ");
INSERT INTO meq_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ta gwaɗiye: “Zəbum neŋgeye anaŋ kanaŋ” kəgəbay “Neŋgeye atay” bay. Hərwi sərum ha Bəy i Mbəlom na, neŋgeye mə walaŋ kurom.» ");
INSERT INTO meq_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tsa na, a gwaɗatay a gawla ŋgay hay: «Həlay eye ma deyeweye ma sakumeye məŋgatay a Wawa i Ndo kwa pat eye nəte tsa, ane tuk na, ka ŋgatumeye bay. ");
INSERT INTO meq_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ta gwaɗumeye: “Zəbum atay!” Kəgəbay “Zəbum neŋgeye anaŋ!” Ane tuk na, kâ yum bay, kâ hwayum faya bay. ");
INSERT INTO meq_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Pat eye ma deyeweye neŋ Wawa i Ndo na deyeweye na, andza mawutseɗe i mbəlom nakə a wutseɗe na, dzaydzay ŋgay eye a dəv kwa abəra mə bəzay i mbəlom hus a məgəma aye. Na deyeweye na, andza niye. ");
INSERT INTO meq_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ane tuk na, na siye ɗəretsətseh haladzay təday ada ndo neheye anəke aye ta kaliye ga ha.» ");
INSERT INTO meq_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«Wu nakə a ge bo a həlay i Nuhu aye na, pat nakə neŋ Wawa i Ndo na deyeweye na, ma ta giye bo andza niye dərmak. ");
INSERT INTO meq_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ahəl niye na, ndo hay tə ndayawa wu mənday ada tə sawa wu məsay, tə zlawa dahəlay hay ada tə vəlawa dem tay hay a zal hus a pat nakə Nuhu a fələkwa a kwalalaŋ i yam aye. Yam bagwar eye a rah ka məndzibəra a dze tay ha siye i ndo hay tebiye. ");
INSERT INTO meq_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","«Sa na, ma ta təriye andza a həlay i Lot: Ndo hay tə ndayawa wu mənday ada tə sawa wu məsay. Ta səkəmawa wu hay ada ta səməkawa ha. Ta zəvawa dərizl i gərɗaf hay ada ta ɗəzlawa gay tay hay. ");
INSERT INTO meq_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ane tuk na, pat nakə Lot a lətse a yaw abəra ma gəma i Sodom aye na, ako a paw abəra mə mbəlom andza yam ada tə wuye andaya a təma wafafafa, a dze tay ha ndo i gəma niye hay tebiye. ");
INSERT INTO meq_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Pat nakə neŋ Wawa i Ndo na deyeweye na, ma ta təriye andza niye dərmak. ");
INSERT INTO meq_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Pat eye niye na, ndo nakə ka gər i gay ada wu ŋgay hay mə gay aye na, mâ mbəzlaw hərwi məzlaw wu mə gay bay. Andza niye ndo nakə ma guvah aye na, mâ maw a mətagay bay. ");
INSERT INTO meq_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Wu nakə a ge bo ta ŋgwas i Lot aye na, mâ mətsakum gər bay! ");
INSERT INTO meq_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ndo nakə ka pəla mətəme ha məsəfəre ŋgay aye na, ma ta dziye ha ɗuh. Ane tuk na, ndo nakə ma dziye ha məsəfəre ŋgay hərwi ga aye na, ma təmiye ha ɗuh. ");
INSERT INTO meq_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","«Sərum ha pat eye niye ta həvaɗ na, ndo hay sulo mahəna eye ka sləlah na, ta zliye nəte, ta gəriye ha neŋgeɗ. ");
INSERT INTO meq_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ŋgwas hay sulo ta ləgəriye salamay ka ber, ta zliye nəte, ta gəriye ha neŋgeɗ.  ");
INSERT INTO meq_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Hasləka hay sulo ma guvah ta fətiye, ta zliye nəte, ta gəriye ha neŋgeɗ.» ");
INSERT INTO meq_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Gawla ŋgay hay ta tsətsah faya tə gwaɗay: «Wu niye ma ta giye bo andza niye na, ka waray Bəy Maduweŋ.» Yesu a mbəɗatay faya a gwaɗatay: «Təv nakə wu maməta eye mə ɗəma aye na, magoduk hay ta hayiye gər a ɗəma.» ");
INSERT INTO meq_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ma dəba eye, Yesu a tsikatay dzeke hərwi məɗe tay ha na, tâ ɗuwulay me a Mbəlom huya tâ ye gər maɗuwule me bay. ");
INSERT INTO meq_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","A gwaɗatay: «Ndo məge sariya wuray ma gəma eye andaya. Ndoweye niye na, madzədzere i Mbəlom mə ɗərev ŋgay təbey, ada ndo a gay mə gər bay sa. ");
INSERT INTO meq_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Madakway i ŋgwas andaya ma gəma eye niye dərmak. Madakway i ŋgwas niye a yawa ka təv ŋgay pat pat hərwi mâ gay na sariya ŋgay tey. A gwaɗay a ndo məge sariya niye: “Gamay na sariya ta ndo məne ɗəre ga anaŋ tey.” ");
INSERT INTO meq_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","«Kə ndza haladzay ndo məge sariya a kəma məge sariya i madakway i ŋgwas niye bay. A dzala mə gər ŋgay a gwaɗ: “Ayaw! Neŋ na dzala gər ka Mbəlom bay ada kwa ndo a geŋ mə gər bay, ");
INSERT INTO meq_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ane tuk na, madakway i ŋgwas nakay faya ma wurɗeŋeye me, ŋgama na geye na sariya ŋgay təday bəna, ma gəriye ha madayaw ka təv ga bay.”» ");
INSERT INTO meq_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Bəy Maduweŋ a gwaɗatay sa: «Tsənum wu nakə ndo məge sariya niye ŋgwalak eye bay a tsik aye! ");
INSERT INTO meq_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ada Mbəlom neŋgeye na, ma dzəniye ndo ŋgay hay bəɗaw? Taɗə faya ta tuway naha bo na, ma giye mahonok madzəne tay ɗaw? ");
INSERT INTO meq_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Sərum ha na, ma dzəniye tay ta bəse. Ane tuk na, aza neŋ Wawa i Ndo na deyeweye na, na hutiye ndo mədzal gər hay ka neŋ ŋgway ɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu a tsikatay dzeke mekeleŋ eye sa. Dzeke niye na, hərwi ndo neheye tə dzala tə gwaɗ nəteye ka ɗəre i Mbəlom na, ŋgwalak eye hay ada nəteye ta zəba ka siye i ndo hay na, andza ndo hay bay. ");
INSERT INTO meq_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","A gwaɗatay: «Ndoweye hay andaya sulo, ti ye a gay i məɗəslay ha gər a Mbəlom mata ɗuwulay me a Mbəlom. Ndo neŋgeɗ na, ndo Farisa, neŋgeɗ na, ndo matsekele dzaŋgal. ");
INSERT INTO meq_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","«Ti ye naha na, ndo Farisa niye a lətse təv ŋgay wal. A gwaɗ mə ɗərev ŋgay: “A! A! Mbəlom ga, na gaka naha sɨsœ hərwi neŋ na, andza siye i ndo hay təbey. Nəteye na, məkal eye hay, ndo ŋgwalak eye hay bay. Tə gawa madama. Neŋ na, na gaka naha sɨsœ hərwi neŋ andza ndo matsekele dzaŋgal nakay təbey. ");
INSERT INTO meq_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mə luma nəte na, na gawa daliyam sik sulo. Wu ga kuro na, na vəlawa nəte.”» ");
INSERT INTO meq_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«Ndo matsekele dzaŋgal neŋgeye na, a lətse dəreŋ. Kwa kə lətse ha gər mazəbe ɗəre a mbəlom bay tebiye. Ane tuk na, a gwaɗ: “Mbəlom! Na gaka mə bo tey hərwi neŋ na, ndo i mezeleme.”» ");
INSERT INTO meq_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu a gwaɗatay: «Sərum ha na, ndo matsekele dzaŋgal nakay a ye a ŋgway a mətagay na, neŋgeye ka təv i Mbəlom na, lele. Ane tuk na, ndo Farisa niye neŋgeye na, andza niye təbey. Hərwi ndo nakə a say tâ gwaɗ neŋgeye bagwar eye na, Mbəlom ma təriye ha wawa eye ɗuh. Ndo nakə a təra ha bo ŋgay wawa eye kame i ndo hay aye na, Mbəlom ma təriye ha bagwar eye ɗuh.» ");
INSERT INTO meq_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ma dəba eye na, ndo hay tə həl naha wawa tsekweŋ tsekweŋ eye hay a Yesu hərwi ada mâ pa fataya həlay ada tâ huta ŋgama. Ane tuk na, gawla ŋgay hay tə gatay me a ndo niye hay tə həlay naha wawa hay aye. ");
INSERT INTO meq_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yesu a gwaɗatay a wawa hay: «Həndzəɗumaw ka təv ga.» A gwaɗatay a gawla ŋgay hay: «Gərum tay ha wawa hay, tâ yaw ka təv ga! Kâ həharum tay ha bay, hərwi Bəy i Mbəlom mavəla eye na, a slala i ndo neheye andza wawa neheye. ");
INSERT INTO meq_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sərum ha na, ndoweye ka təma Bəy i Mbəlom andza wawa neheye bay na, ma diye a Bəy i Mbəlom bay.» ");
INSERT INTO meq_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Bəy i Yahuda wuray a tsətsah ka Yesu, a gwaɗay: «Miter lele eye, na hutiye sifa nakə ma ndəviye bay aye na, na giye na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu a gwaɗay: «Ka zeleŋ ndo lele eye na kemey? Ndo lele eye na, Mbəlom nəte ŋgweŋ. ");
INSERT INTO meq_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ka sər bazlam i Mbəlom mapala eye ɗaw? Bazlam i Mbəlom mapala eye a gwaɗ na: Kâ ge madama bay, kâ kəɗ gər i ndo bay, kâ ge məkal bay, kâ raw me ka ndo kame i sariya bay, rəhatay ha gər a bəba yak ta may yak.» ");
INSERT INTO meq_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ndo niye a mbəɗay faya a gwaɗay: «Gər i bazlam mapala eye neheye ka paslaw aye na, na hənay ha gər kwa ma wawa.» ");
INSERT INTO meq_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu a tsəne andza niye na, a gwaɗay: «A zəkaw fakaya abəra wu nəte sa: Anəke na, do ta səkəm ha zlele yak hay tebiye ada kâ ŋgənatay suloy eye a ndo i mətawak hay. Ka ge andza niye na, ka ta hutiye zlele mə mbəlom. Tsa na, dara, peŋ bəzay.» ");
INSERT INTO meq_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ane tuk na, ndo niye a tsəne bazlam niye na, a ndalay haladzay hərwi zlele ŋgay na, haladzay. ");
INSERT INTO meq_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu a zəba faya na, a ndalay, a gwaɗ: «Hərwi ndo i zlele na, mede a Bəy i Mbəlom i ŋgay na, mada me eye haladzay. ");
INSERT INTO meq_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tə bəmalə nakə ndo i zlele ma diye a Bəy i Mbəlom aye na, ŋgama zləgweme mâ ye ta bəɗ i ləpəre.» ");
INSERT INTO meq_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ndo neheye tə tsəne bazlam i Yesu nakə a tsik aye na, tə gwaɗ: «Ane tuk na, kə ge andza niye na, mata sle mətəme na, way?» ");
INSERT INTO meq_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu a mbəɗatay faya, a gwaɗatay: «Ndəray ma sliye mətəme bay. Ane tuk na, Mbəlom ma sliye mətəme ha ndo.» ");
INSERT INTO meq_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tsa na, Piyer a gwaɗay: «Tsəne! Nəmay anaŋ, nəmaa gər ha gay may hərwi məpaka bəzay na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu a gwaɗatay: «Sərum ha, ndoweye kə gər ha gay ŋgay, ŋgwas ŋgay, malamar ŋgay hasləka eye hay ta malamar ŋgay dem eye hay, bəba ŋgay ta may ŋgay, wawa ŋgay hay hərwi Bəy i Mbəlom na, ");
INSERT INTO meq_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","anəke ahəl kway nakay ma hutiye a ɗəma haladzay ada kame na, ma hutiye sifa nakə ma ndəviye bay aye.» ");
INSERT INTO meq_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu a zalatay a gawla ŋgay niye hay kuro gər eye sulo aye abəra mə walaŋ i ndo hay kətsah. Tsa na, a gwaɗatay: «Tsənum! Anəke na, ka tsalakweye a Zerozelem. Mə ɗəma na, wu nakə ndo məɗe ha bazlam i Mbəlom hay tə watsa ahəl niye ka gər i neŋ Wawa i Ndo aye na, ma giye bo tuk. ");
INSERT INTO meq_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ta vəlateye ga ha a ndo neheye tə sər Mbəlom bay aye. Ta ŋgwasiye fagaya, ta tseɗeŋeye, ta tufeŋeye slesleɓ a ɗəre. ");
INSERT INTO meq_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ta ndaɓiye ga ta mandalaɓa ada ta kəɗiye ga. Ane tuk na, ma məhəne mamahkar eye na, na lətseweye abəra ma mədahaŋ.» ");
INSERT INTO meq_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ane tuk na, gawla ŋgay hay ta tsəne wu nakə a tsik aye bay. A ge fataya bazlam nakə Yesu a tsik aye a say məgweɗe mey na, maŋgaha eye. A tsik na, ka gər i wu waray na, tə sər bay. ");
INSERT INTO meq_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mazlambar Yesu ma ndisliye a Zeriko na, guluf wuray andaya mandza eye ka tsakay i tsəveɗ, a rəkawa wu ka ndo hay. ");
INSERT INTO meq_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","A tsəne ndo hay faya ta diye ka tsəveɗ na, a gwaɗatay: «Labara i mey?» ");
INSERT INTO meq_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ta mbəɗay faya, tə gwaɗay: «Yesu ndo i Nazaret ma diye tə faʼanaŋ.» ");
INSERT INTO meq_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Guluf niye a tsəne andza niye na, a wuda ta magala, a gwaɗ: «Yesu, Wawa i Davit, nâ gaka mə bo təbəɗew?» ");
INSERT INTO meq_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ndo neheye tə lah naha kame aye na, tə gay me a guluf niye hərwi ada mâ bəbəl wuray bay, mâ ndza ɗikɗik. Ɗuh a zaka ha mawude haladzay ta magala, a gwaɗ: «Wawa i Davit, nâ gaka mə bo təbəɗew!» ");
INSERT INTO meq_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu a ndisl naha na, a lətse, a gwaɗatay: «Dum gəsumayaw həlay kanaŋ.» Tsa na, ti ye tə gəsayaw həlay. A ndisl naha ka təv i Yesu na, Yesu a tsətsah faya, a gwaɗay: ");
INSERT INTO meq_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«A saka nâ ge hərwi yak na, mey?» Guluf niye a mbəɗay faya, a gwaɗay: «Bəy ga, a seŋ na, nâ ŋgatay a ɗəre sa tey.» ");
INSERT INTO meq_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tsa na, Yesu a gwaɗay: «Yawa lele, mədzal gər yak nakə ka dzala ga ha aye na, kə mbəl kar ha.» ");
INSERT INTO meq_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kwayaŋŋa guluf niye a ŋgatay a ɗəre. A pay bəzay a Yesu. A zambaɗay a Mbəlom. Ndo niye hay haladzay aye tə ŋgatay a wu nakə a ge bo aye na, nəteye tebiye ta zambaɗay a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu a ndisl a Zeriko na, a ye ta wuzlahgəma i Zeriko niye. ");
INSERT INTO meq_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ahəl nakə faya ma diye na, ndoweye andaya tə zalay Zase, neŋgeye andaya dərmak. Neŋgeye na, zlele eye. Neŋgeye bagwar i ndo matsekele dzaŋgal hay. ");
INSERT INTO meq_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A pəla tsəveɗ məŋgatay a Yesu na, way. Ane tuk na, kə ŋgatay bay hərwi ndo hay haladzay ada neŋgeye na, dakwel eye. ");
INSERT INTO meq_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","A hway ka me, a ye naha a tsal a gərɗaf i kuvoray. A tsal a gərɗaf na, hərwi məŋgatay a Yesu nakə ma diye ta tsəveɗ niye aye. ");
INSERT INTO meq_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu a ndisl naha a bəzay i gərɗaf i kuvoray niye na, a zla gər ka mbəlom, a zəba ɗəre a gərɗaf niye. A ŋgatay naha a Zase. Tsa na, a gwaɗay naha: «Zase, mbəzlaw bəse. Bəgom na diye na ta ndziye mə gay yak.» ");
INSERT INTO meq_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zase a tsəne andza niye na, a mbəzlaw bəse. Tsa na, ti ye ka bo a gay ŋgay. Ti ye naha na, a təma tay ha tə məŋgwese lele. ");
INSERT INTO meq_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ndo hay tə ŋgatay andza niye na, a ndalatay. Ta ŋgəlay bəzay a Yesu. Tə gwaɗ: «Ndo nakay a ye mata ndze mə gay i ndo i mezeleme ɗaw!» ");
INSERT INTO meq_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zase neŋgeye a lətse kame i Bəy Maduweŋ a gwaɗay: «Tsəne Bəy Maduweŋ ga! Anəke na, na ŋgəniye ha zlele ga wuɗak, na ŋgənatay ha a mətawak hay. Ada taɗə na zla suloy abəra ka ndoweye ka zal na, na may ha ŋgway a ɗəma madzəga faɗ.» ");
INSERT INTO meq_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu a tsəne andza niye na, a gwaɗay: «Bəgom mətəme ki yaw a gay yak hərwi nəkar na, wawa i Abraham dərmak. ");
INSERT INTO meq_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Hərwi neŋ Wawa i Ndo na yaw na, mapəle ndo neheye madza eye hay ada mətəme tay ha.» ");
INSERT INTO meq_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ndo niye hay faya ta pay zləm a bazlam ŋgay niye hay na, Yesu a tsikatay dzeke sa. A tsik dzeke niye na, mazlambar ma ndisliye a Zerozelem. Ndo hay tə dzala na, tə gwaɗ: «Mazlambar Bəy i Mbəlom ma deyeweye tuk.» ");
INSERT INTO meq_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Wu nakə Yesu a tsikatay aye na, anaŋ, a gwaɗatay: «Ndoweye andaya neŋgeye na, gwala i bəy hay. A ye a gəma dəreŋ eye hərwi ada tâ pa ahaya a bəy. Ta pa na a bəy na, ma maweye ma ləviye ndo ŋgay hay. ");
INSERT INTO meq_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ma ta həliye bo ma diye na, a zalatay a ndo i məsler ŋgay hay kuro. Nəteye niye kuro aye ti ye naha. Ti ye naha na, a ŋgənatay kwar i suloy. A vəlatay kwar i suloy nəte nəte tay aye. Kwar i suloy niye nəte na, suloy mə ɗəma haladzay. A gwaɗatay: “Mbəɗum ha həlay hus a pat nakə na maw aye.” ");
INSERT INTO meq_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","«Ane tuk na, ndoweye niye a say bəy aye na, ndo i gəma ŋgay hay ta wuɗa na bay. Tə slər ndo hay ma dəba ŋgay hərwi tâ ye tâ gwaɗatay na: “A samay ndo nakay mâ təra bəy may bay.” ");
INSERT INTO meq_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Ada ɗuh huya ta pa na a bəy. Tə pa na a bəy na, a maw a gəma ŋgay tuk. A maw na, a zalatay a ndo i məsler ŋgay niye hay a ŋgənatay kwar i suloy aye hərwi məsəre ha magogoy nakə tə huta faya aye. ");
INSERT INTO meq_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","«Ndo makurre eye a ye naha, a gwaɗay: “Ndo i gay ga, kwar i suloy nakə ka vəleŋ aye na, na huta faya kuro.” ");
INSERT INTO meq_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","«Bəy niye a gwaɗay: “Nəkar na, ndo i məsler lele eye deɗek. Anəke na, na piye kar a bəy, ka ləviye gəma kuro hərwi məsler nakə tsekweŋ aye ka ge na ta tsəveɗ eye.” ");
INSERT INTO meq_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«Ndo masulo eye a ye naha a gwaɗay: “Ndo i gay ga, suloy niye ka vəleŋ eye na, na huta faya zlam.” ");
INSERT INTO meq_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","«Bəy a gwaɗay a ndo niye: “Nəkar na, na piye kar bəy eye, ka ləviye gəma zlam.” ");
INSERT INTO meq_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Ma dəba eye na, ndo neŋgeɗ a ye naha a gwaɗay: “Ndo i gay ga, kwar i suloy yak nakə ka vəleŋ aye anaŋ. Na ləva faya bo lele na mbuza na a petekeɗ, na ŋgaha na lele. ");
INSERT INTO meq_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Na dzədzaraka haladzay, hərwi nəkar na, ndo makula gər eye. Wu yak bay na, ka zliye tsa, ka sləga bay na, ka dziye tsa.” ");
INSERT INTO meq_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«Bəy niye a mbəɗay faya a gwaɗay: “Nəkar na, ndo i məsler nakə ŋgwalak eye bay aye. Maa gəs kar a sariya na, bazlam yak eye wu yak. Ka sər ha kurre neŋ na, ndo makula gər eye, ada kwa wu ga bay na, na zliye, na sləga bay na, na dziye tsa na, ");
INSERT INTO meq_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ada ka mey, meeneŋ na, peŋ na suloy a gay nakə tə pawa a ɗəma suloy aye. Atay ka məmaw ga na, na diye na həlaweye abəra mə ɗəma na, na hutiye faya magogoy.” ");
INSERT INTO meq_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«Tsa na, a gwaɗatay a ndo neheye ka təv aye niye: “A niye zlum faya abəra kwar i suloy niye. Vəlumay faya a ndo nakə kwar i suloy andaya faya kuro aye.” ");
INSERT INTO meq_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","«Ndo niye hay ta mbəɗay faya tə gwaɗay: “Bəy may, neŋgeye na, kwar i suloy ŋgay andaya kuro segey!” ");
INSERT INTO meq_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","«Bəy niye a gwaɗatay: “Sərum ha na, ndo nakə wu ŋgay andaya na, ta səkahay ha sa. Ane tuk na, ndo nakə wu ŋgay andaya bay aye na, kwa tsekweŋ eye nakə andaya faya aye na, ta zliye na faya abəra. ");
INSERT INTO meq_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ane tuk na, ndo neheye a satay nâ təra bəy tay bay aye na, dum naha, gəsumatay ahaya ada kâ kəɗum tay ha ka ɗəre ga kanaŋ.”» ");
INSERT INTO meq_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu a ndəv ha mətsike me niye andza niye na, a ye a ndzatay kame a ndo hay mede a Zerozelem. ");
INSERT INTO meq_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mazlambar ta husiye a gəma i Betifadze ta Betani bəse ta mahəmba nakə tə zalay Mahəmba i Tetəɗœz aye na, a slər gawla ŋgay hay kame sulo. ");
INSERT INTO meq_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","A gwaɗatay: «Dum a gəma nakə kame kurom aye. Ka ndislum naha na, ka ndzumeye a gər a zuŋgo wawa eye maɓara eye ndəray kə ndza faya ɗaɗa zuk bay. Pəlumaw ada kâ yumeŋ ahaya kanaŋ. ");
INSERT INTO meq_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Taɗə ndəray ka tsətsah fakuma: “Ka pəlumeye na zuŋgo eye a ŋgay” na, gwaɗumay: “A say a Bəy Maduweŋ.”» ");
INSERT INTO meq_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ndo i məsler niye hay sulo aye tə həl bo ti ye. Ti ye naha na, tə ndzay a gər andza nakə Yesu a tsikatay aye. ");
INSERT INTO meq_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tsa na, ta dazlay a məpəle zuŋgo niye. Ahəl nakə nəteye faya ta pəliye zuŋgo niye na, ndo i zuŋgo niye a gwaɗatay: «Ka pəlumeye na zuŋgo eye hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ta mbəɗay faya tə gwaɗay: «A say a Bəy Maduweŋ.» ");
INSERT INTO meq_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Gawla i Yesu neheye sulo aye, ti ye ahaya zuŋgo niye a Yesu. Ti ye ahaya na, ta fətəl faya petekeɗ tay hay. Tsa na, tə tsal ha faya Yesu. ");
INSERT INTO meq_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Faya ta diye na, ndo hay ta fətəl petekeɗ tay hay ka tsəveɗ nakə Yesu faya ma diye tə ɗəma aye. ");
INSERT INTO meq_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mazlambar faya ta ndisliye a Zerozelem ta tsəveɗ nakə ma mbəzlaw ta Mahəmba i Tetəɗœz aye na, gawla ŋgay hay tebiye ta dazlay a mazambaɗay a Mbəlom tə məŋgwese eye lele ada tə mawude ta magala ŋgəlakaka hərwi masuwayaŋ nakə tə ŋgatay Yesu a ge aye. ");
INSERT INTO meq_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Tə gwaɗawa: «Mbəlom mâ pa ŋgama ka Bəy nakə faya ma deyeweye tə məzele i Bəy Maduweŋ aye!» «Zay mə mbəlom, ada zambaɗakway a Mbəlom, neŋgeye nakə mə mbəlom aye!» ");
INSERT INTO meq_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mə walaŋ i ndo niye hay haladzay aye na, Farisa hay andaya. Tə gwaɗay a Yesu: «Miter, gwaɗatay a gawla yak hay tâ gər ha mabəbəle wuray.» ");
INSERT INTO meq_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu a mbəɗatay faya a gwaɗatay: «Sərum ha na, kwa nəteye ta ndza ɗikɗik bəbay na, kwar hay ta wudiye!» ");
INSERT INTO meq_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ahəl nakə Yesu a ndisl neŋgeye bəse tə wuzlahgəma i Zerozelem aye na, a ŋgatay na, a tuwa. ");
INSERT INTO meq_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","A gwaɗ: «A nəkar Zerozelem, taɗə bəgom ka sər wu nakə ma sliye faya məvəlaka zay aye na, haɓe ka təmiye abəra mə ɗəretsətseh. Ane tuk na, anəke na, maŋgaha eye faka abəra, ka sliye faya məŋgatay bay! ");
INSERT INTO meq_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pat i ɗəretsətseh hay ta deyeweye fakaya. Ndo məne ɗəre yak hay ta deyeweye tə wu həlay tay ta lawariye kar tuwzik, ta dərəzliye kar. Ta ŋgəɗətsiye kar kwa tə waray tə waray. ");
INSERT INTO meq_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ta bəbazliye kurom ta ndo yak hay tebiye. Kwa kwar ka gər i kwar ta gəriye ha bay, ta mbəzliye ha tebiye hele hele. Hərwi mey andza niye na? Hərwi nəkar na, pat nakə Mbəlom ma yaw mata dzəne kar aye na, ka sər ha bay!» ");
INSERT INTO meq_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu a ndisl a Zerozelem na, a ye a dalamətagay i gay i məɗəslay ha gər a Mbəlom. A ye naha na, a dazlay mahəhere ndo məge tsakala hay abəra ma dalamətagay i gay i məɗəslay ha gər a Mbəlom niye. A gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","«Mawatsa eye mə Ɗerewel i Mbəlom na: “Gay ga ma ta təriye na, gay i maɗuwule me.” Ane tuk na, nəkurom ka tərum ha lar i məkal hay na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu a tsikawatay bazlam i Mbəlom a ndo hay pat pat mə gay i məɗəslay ha gər a Mbəlom. Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye hay ada ta madugula hay, ta pəla tsəveɗ ka məkəɗe na Yesu. ");
INSERT INTO meq_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ane tuk na, ta gəsiye na ma kəkay na, tə sər bay. Ta huta faya tsəveɗ məgəse na bay. Hərwi ndo hay tebiye faya ta pay zləm a wu nakə faya ma tətikateye na, tə metsehe eye lele. ");
INSERT INTO meq_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pat wuray na, Yesu faya ma tətikateye a ndo hay ada faya ma ɗateye ha Labara Ŋgwalak eye ma dalamətagay i gay i məɗəslay ha gər a Mbəlom. Ahəl nakə faya ma tətikateye na, bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye hay ada ta madugula hay ti ye ka təv i Yesu. ");
INSERT INTO meq_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ti ye naha ta tsətsah faya tə gwaɗay: «Ka ge wu neheye na, ta gədaŋ waray? Maa vəlaka gədaŋ aye na, way, tsikamay?» ");
INSERT INTO meq_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu a mbəɗatay faya, a gwaɗatay: «Neŋ dərmak na tsətsahiye fakuma: ");
INSERT INTO meq_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Maa sləraw Yuhana madzəhuɓe ndo a yam na, way? Maa sləraw na, Mbəlom tsukuɗu ndo hay ɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ane tuk na, tə tsik mə walaŋ tay tə gwaɗ: «Ka mbəɗakweye faya na, kəkay? Taɗə ka gwaɗakwa, maa slər ha Mbəlom, Yesu ma gwaɗakweye: “Ka dzalum ha ka wu nakə Yuhana a tsik aye bay na, kemey?” ");
INSERT INTO meq_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ada taɗə ka gwaɗakwa maa sləraw Yuhana na, ndo hay, ndo hay tebiye ta kaliye kway tə kwar, ta kəɗiye kway. Hərwi tə sər ha ta deɗek Yuhana na, ndo məɗe ha bazlam i Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ta mbəɗay faya a Yesu, tə gwaɗay: «Maa sləra ahaya Yuhana ndo madzəhuɓe ndo a yam way na, nəmaa sər bay.» ");
INSERT INTO meq_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu a gwaɗatay: «Neŋ bəbay na ge wu neheye ta gədaŋ i way na, na tsikakumeye bay.» ");
INSERT INTO meq_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ma dəba eye na, Yesu a tsikatay me a ndo hay ta dzeke, a gwaɗatay: «Ndoweye andaya a ɗəs guvah. A zəv a ɗəma gərɗaf hay haladzay. Dərizl i gərɗaf niye hay na, tə wa hohway. A ndəv ha mazəve na, a həl ndo i məfəte hay ada tâ fətay na. Bo ŋgay aye a ye a tsekene. A ye na, ma ndzaweye haladzay. ");
INSERT INTO meq_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","«Həlay i maŋgəle hohway i gərɗaf niye hay kə sla. A slər ndo nəte mə walaŋ i ndo i məsler ŋgay hay hərwi ada tâ vəlayaw faya abəra i ŋgay. Ndo i məsler ŋgay a həl bo a ye. A ye naha na, ndo neheye faya ta tsəpiye guvah aye, tə gəs na. Tə ndaɓa na ada ta həhar na həlay kəriye. ");
INSERT INTO meq_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","«Ndo i guvah a ŋgatay andza niye na, a slər ndo neŋgeɗ sa. Ndo niye a həl bo a ye. A ye naha na, tə gəs na ada tə ndaɓa na dərmak. Tə tsaɗay pəleslesle, ta həhar na. Ta vəlay wuray kwa tsekweŋ bay. ");
INSERT INTO meq_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ndo i guvah a slər ndo mamahkar eye sa. Ndo niye a ye na, tə gay mbəlak. Tsa na, tə kala ahaya abəra ma guvah niye. ");
INSERT INTO meq_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«Ndo i guvah niye a gwaɗ: “Na giye anəke na, kəkay? Na sləriye wawa ga nakay nəte na wuɗa na haladzay aye təday. Agəla neŋgeye na, ta rəhay ha gər, ta geye wuray bay.” ");
INSERT INTO meq_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","«Ane tuk na, tə ŋgatay a wawa niye na, tə tsik mə walaŋ tay tə gwaɗ: “Aya! Anaŋ magedze ŋgay nakə ma ta ndiye na guvah ŋgay aye, ki yaw! Kəɗakwa na, ada guvah nakay ma mətsakweye a nəkway!” ");
INSERT INTO meq_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tsa na, ti ye faya, tə gəs na. Tə kəɗ na. Tə kal ha mədahaŋ eye abəra ma guvah niye.» Tsa na, Yesu a tsətsah fataya a gwaɗatay: «Ndo i guvah ma giye tay ha anəke na, kəkay? ");
INSERT INTO meq_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ndo i guvah niye ma deyeweye ma gəsiye tay ha ndo niye hay, ma kəɗiye tay ha. Kə kəɗ tay ha na, ma həliye a ɗəma ndo mekeleŋ eye hay.» Ndo hay tə tsəne wu niye hay a tsik aye na, tə gwaɗ: «Wu niye andza niye na, ma giye bo bay.» ");
INSERT INTO meq_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ane tuk na, Yesu a zəba fataya a gwaɗatay: «Dzeke nakay mə Ɗerewel i Mbəlom aye a say məgweɗe na, kəkay? “Kwar nakə ndo maɗəzle gay hay tə kal ha aye na, matəra kwar lele eye a ze siye i kwar hay na, neŋgeye ɗuh.” ");
INSERT INTO meq_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","«Kwa way kə dəɗ ka kwar niye na, ma toliye. Ada kwar niye kə dəɗ ka ndoweye na, ma ləgəriye na kərɗik kərɗik andza mereɓek.» ");
INSERT INTO meq_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ndo mədzaŋgawa bazlam i Mbəlom mapala eye hay ta bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye hay ta pəla tsəveɗ kwayaŋŋa ka məgəse na Yesu hərwi tə sər ha Yesu a tsik dzeke niye na, ka nəteye. Ane tuk a, ta dzədzaratay a ndo hay. ");
INSERT INTO meq_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ma dəba eye na, ta dazlay a matsəpe na Yesu. Tə slər ndo ka təv ŋgay. Ndo niye hay tə slər tay ha aye na, tə ge ha gər tay andza nəteye ndo lele eye hay kame i Mbəlom. Ndo niye hay na, a satay mapəle mənese abəra ka Yesu mə bazlam ŋgay neheye ma tsikiye aye. Taɗə ta huta faya abəra mənese na, ta sliye faya məvəlay a həlay a ndo məvəle dala tuk. Hərwi bəy i Roma na, neŋgeye gədaŋ eye ada maa ləva dala i Roma na, neŋgeye. ");
INSERT INTO meq_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ndo neheye tə slər tay ha aye na, ti ye ka təv i Yesu. Ti ye naha ta tsətsah faya andza nakay, tə gwaɗay: «Miter, nəmaa sər ha nəkar ka tsik na, deɗek. Ka ŋgəna tay ha ka bo bəra ndo hay təbey. Ka gwaɗ ada faya ka tətikateye a ndo hay na, wu neheye deɗek aye. ");
INSERT INTO meq_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ane tuk na, a samay matsətsehe fakaya, bazlam kway mapala eye kə vəl tsəveɗ məvəle dzaŋgal a bəy i Roma tsukuɗu kə vəl tsəveɗ məvəle bay ɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ane tuk na, Yesu a sər ha, a satay məhəle faya abəra suwat. Tsa na, a gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Ehey bəzumeŋ ahaya kwar i suloy təday.» Ta bəzay ha kwar i suloy niye. A gwaɗatay: «Mandzəkit bo nakay ta məzele nakay faya na, i way?» Ta mbəɗay faya, tə gwaɗay: «I bəy i Roma.» ");
INSERT INTO meq_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tsa na, Yesu a gwaɗatay: «Aya! Wu i bəy i Roma na, vəlumay ha a bəy i Roma ŋgway. Wu i Mbəlom na, vəlumay ha a Mbəlom ŋgway.» ");
INSERT INTO meq_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ka gər i bazlam niye Yesu a tsikatay kame i ndo hay tebiye na, ta huta faya abəra mənese bay tebiye. Ɗuh bazlam ŋgay nakə a tsikatay aye na, a gatay hərɓaɓəkka, a dərəzlatay ka bazlam. ");
INSERT INTO meq_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ma dəba eye na, siye i Saduke hay ti ye ka təv i Yesu. Saduke hay na, ndo neheye tə gwaɗ: «Ka mət na, mələtsew abəra ma mədahaŋ andaya sa bay» aye. ");
INSERT INTO meq_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ti ye naha, ta tsətsah ka Yesu, tə gwaɗay: «Miter, bazlam nakə Musa a watsamay a bazlam i Mbəlom mapala eye na, anaŋ. A gwaɗ: “Taɗə ndo a mət a gər ha ŋgwas ŋgay ta wa zuk bay na, mata zle na madakway i ŋgwas niye na, malamar i ndo niye a mət aye” bəɗaw? Ma zliye na, hərwi ada hulfe i ndo niye a mət aye mâ dze bay. ");
INSERT INTO meq_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yaw! Andaya ahəl niye ndo ta malamar ŋgay hay tasəla. Malamar tay makurre eye a zla dahəlay. A zla dahəlay na, a mət. A mət na, ta wa ta dahəlay ŋgay niye a zla aye bay. ");
INSERT INTO meq_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Məmbager ŋgay a zla na madakway i ŋgwas niye. A zla na, a mət. ");
INSERT INTO meq_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Malamar tay mamahkar eye a zla. A zla na, a mət. Siye hay tebiye tə ge andza niye dərmak. Nəteye neheye tasəla aye tə zla ŋgwas niye na, tə mət tebiye. Ndəray kwa nəte mə walaŋ tay ta wa ta ŋgwas niye bay. ");
INSERT INTO meq_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ka mandəve ŋgay eye na, ŋgwas niye a mət dərmak. ");
INSERT INTO meq_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pat nakə aza mədahaŋ hay ta lətseweye abəra ma mədahaŋ aye na, ŋgwas niye ma mətseye na, a way? Hərwi nəteye niye tasəla eye ta zla na ka ŋgwas!» ");
INSERT INTO meq_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu a mbəɗatay faya, a gwaɗatay: «Hasləka ta ŋgwas neheye ka məndzibəra nakay anaŋ aye na, ta zliye bo. ");
INSERT INTO meq_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ane tuk na, ndo neheye Mbəlom a pala tay ha, nəteye ta ndziye ka məndzibəra nakə weɗeye na, ta lətseweye abəra ma mədahaŋ na, ta zliye bo nakay na, zal kəgəbay, ŋgwas na, ta zliye bo sa bay. ");
INSERT INTO meq_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nəteye na, ta mətiye sa bay. Ta ndziye na, andza gawla i Mbəlom hay. Nəteye wawa i Mbəlom hay, hərwi ta lətsew abəra ma mədahaŋ a məsəfəre. ");
INSERT INTO meq_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","«Mələtsew abəra ma mədahaŋ na, ka sərakwa ha mədahaŋ hay ta lətseweye abəra ma bəɗ na, hərwi bazlam i Musa nakə a tsik ahəl niye aye. A ɗa ha na, bazlam nakə Mbəlom a tsikayaw mə gay i dak niye dzaydzay andza faya ma təmiye na aye. A zalay a Bəy Maduweŋ na, “Mbəlom i Abraham, Mbəlom i Izak, Mbəlom i Zakob.” ");
INSERT INTO meq_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A tsik andza niye na, hərwi Mbəlom na, neŋgeye Mbəlom i mədahaŋ hay bay, neŋgeye Mbəlom i ndo neheye ta ndziye huya ta sifa aye. Ta ndziye ma sifa na, hərwi Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Siye i ndo mədzaŋgawa bazlam i Mbəlom mapala eye tə tsəne andza niye na, tə gwaɗ: «Miter, bazlam yak niye ka tsik aye na, təɗe.» ");
INSERT INTO meq_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tə tsikay andza niye na, hərwi horoy a gatay matsətsehe faya wu hay. ");
INSERT INTO meq_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu a gwaɗatay: «Ndo hay tə gwaɗ ka Kəriste na, neŋgeye Wawa i Davit na, kəkay? ");
INSERT INTO meq_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ɗuh Davit tə gər ŋgay a gwaɗ ma ɗerewel i Dəmes hay na: “Bəy Maduweŋ Mbəlom a gwaɗay a Bəy Maduweŋ ga na: Dara, ndza tə həlay i mənday ga, ");
INSERT INTO meq_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hus a pat nakə na piye tay ha ndo məne ɗəre yak hay a huɗ i sik yak aye.” ");
INSERT INTO meq_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«Ane tuk na, Davit na, kə zalay a Kəriste “Bəy Maduweŋ” tuk na, ada ndo hay ta gwaɗiye wawa ŋgay na, ma kəkay?» ");
INSERT INTO meq_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ahəl nakə ndo hay faya ta pay zləm a bazlam ŋgay nakə faya ma tsikateye na, Yesu a gwaɗatay a gawla ŋgay hay: ");
INSERT INTO meq_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Həbum gər kurom abəra ka ndo mədzaŋgawa bazlam i Mbəlom mapala eye hay. Nəteye i tay ta wuɗa mahəhele na, ta rəkwat eye. Ka təv məhay gər na, ta wuɗa ndo hay tâ tsikatay me ta məɗəslatay ha gər. Mə gay i maɗuwule me na, ta pəlawa i tay na, təv məndze nakə kame i ndo hay aye, ndo hay ta ŋgatateye lele. Mə magurlom, ta wuɗa na, təv məndze ŋgwalak eye. ");
INSERT INTO meq_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Wu nakə tə vəlawatay a madakway i gwas hay aye na, tə ndayawa na. Tə ɗuwulaway me a Mbəlom na, vəɗvəɗ a ndəv bəse bay hərwi ada ndo hay tâ gwaɗ fataya nəteye ndo ŋgwalak eye hay. Slala i ndo neheye andza nakay aye na, Mbəlom ma giye fataya sariya na, ma ziye i ndo siye hay.» ");
INSERT INTO meq_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ma dəba eye, Yesu a zəba ka bo bəra ɗəre na, a ŋgatay a ndo i zlele hay ta piye suloy a wu məpe suloy mə gay i məɗəslay ha gər a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yesu a ŋgatay a madakway i ŋgwas wuray mətawak eye, a ye naha a pa a ɗəma koɓo sulo dərmak. ");
INSERT INTO meq_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu a gwaɗatay: «Sərum ha madakway i ŋgwas nakay na, kə vəl dala haladzay a ze i ndo hay tebiye. ");
INSERT INTO meq_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Hərwi ndo mekeleŋ eye hay tə vəl na, abəra ka siye. A gatay mə gər sa bay. Ane tuk na, madakway i ŋgwas nakay mətawak eye na, a vəl ha tebiye, siye andaya sa bay.» ");
INSERT INTO meq_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ndo mekeleŋ eye hay tə tsik ka gay i məɗəslay ha gər a Mbəlom. Tə gwaɗ: «Gay nakay na, a le. Kwar neheye ta ɗəzl ha aye na, tə le. Ada wu neheye tə vəlay a Mbəlom aye, tə le.» Ane tuk na, Yesu a gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Wu nakə faya ka zəbumeye faya aye na, pat mekeleŋ eye na, ka ŋgatumeye a kwar kwa nəte ka gər i kwar ŋgeɗ bay. Ta mbəzliye ha hele hele.» ");
INSERT INTO meq_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ndo niye hay ka təv eye niye ta tsətsah faya, tə gwaɗay: «Miter, wu neheye ka tsik aye ta giye bo na, kəɗay? Ŋgoɗgor waray nakə nəmaa səriye ha na, wu neheye tebiye ta ndisleweye aye?» ");
INSERT INTO meq_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu a mbəɗatay faya, a gwaɗatay: «Gum metsehe lele! Ndəray mâ səpat kurom bay. Hərwi ndo hay haladzay ta deyeweye ta məzele ga. Kwa way ma gwaɗiye: “Neŋ na, Kəriste, həlay eye kə ndislew!” Ane tuk na, kâ pumatay bəzay bay. ");
INSERT INTO meq_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ka tsənum ndo hay faya ta giye vəram ta ndo neheye ta niye ɗəre a bo aye na, kâ dzədzarum bay. Wu neheye na, kutoŋ ta ndisleweye təday. Ane tuk na, niye na, mandəve i məndzibəra zuk bay.» ");
INSERT INTO meq_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesu a gwaɗatay sa: «Slala ŋgeɗ ta giye vəram ta slala neŋgeɗ, bəy ta bəy ta giye vəram. ");
INSERT INTO meq_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dala ma ɓəliye, ada mandərzlaŋ ma giye, ɗəvats i magədama haladzay ma gateye a ndo hay ma gəma hay wal wal. Wu neheye a ge masuwayaŋ eye tə wu mekeleŋ eye hay wal wal ma dzədzariye tay ha ndo hay, ta ta deyeweye mə mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Ane tuk na, wu niye hay ta deyeweye na, ta gakumeye ɗəretsətseh. Ta gəsiye kurom a gay i maɗuwule me, ta gakumeye sariya ada ta dərəzliye fakuma a gay i daŋgay. Ta gəsiye kurom, ta diye kurom ha kame i bəy hay ada kame i ndo mələve dala hay hərwi ga. ");
INSERT INTO meq_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Niye na, həlay eye i kurom məhəle mbal i gər ga tuk. ");
INSERT INTO meq_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pat eye kə ndislew na, gəsum ɗərev lele. Kâ dzədzarum mə ɗərev kurom anəke na: “Mata mbəɗe famaya abəra me way?” na, kâ dzalum bay. ");
INSERT INTO meq_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Neŋ eye na ɗakumeye ha bazlam nakə ka tsikumeye ada ndaraw nakə kwa ndo məne ɗəre kurom hay ta sliye faya mədəɗe kurom ha ta sariya bay aye. ");
INSERT INTO meq_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","«Kwa bəba kurom hay ta may kurom hay ta giye fakuma ɗaf. Malamar kurom hay, wurbəba kurom hay ta dzam kurom hay ta giye fakuma ɗaf. Ta gəsiye kurom ada ta gakumeye sariya i mədahaŋ a siye hay haladzay mə walaŋ kurom. ");
INSERT INTO meq_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ndo hay tebiye ta nakumeye ɗəre hərwi ga. ");
INSERT INTO meq_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ane tuk na, sərum ha na, məkwets i gər kurom kwa nəte ma dziye bay. ");
INSERT INTO meq_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Gum gədaŋ lele. Ka ta mbəlumeye ha məsəfəre kurom hay na, andza niye.» ");
INSERT INTO meq_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Taɗə ka ŋgatumay a vəram kə lətsew, ta lawara Zerozelem na, sərum ha mazlambar ta mbəzliye ha bəse tuk. ");
INSERT INTO meq_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ndo neheye ka dala i Yahuda aye, ta ŋgatay a wu niye na, tâ hway a mahəmba hay. Ndo neheye nəteye ma wuzlah gay i Zerozelem aye na, tâ hwayaw abəra mə ɗəma dəreŋ ada ndo neheye mə gəma aye na, tâ hway a wuzlah gay bay. ");
INSERT INTO meq_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","«Hərwi pat eye niye na, pat nakə Mbəlom ma giye sariya ŋgay aye tuk. Niye na, andza nakə ndo i maslaŋ hay tə tsik faya mə Ɗerewel i Mbəlom ma ta giye bo aye. ");
INSERT INTO meq_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Pat eye niye na, ɗəretsətseh wene wene eye na, ka gər i ŋgwas neheye tə bo sulo aye ada ka ŋgwas neheye faya ta vəlateye wah a wawa tay hay aye! Ayaw! Ndo i gəma neheye ta ta siye ɗəretsətseh haladzay hərwi Mbəlom ma ta gateye ɗəretsətseh. ");
INSERT INTO meq_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ndo niye hay tə sər Mbəlom bay aye siye hay ta kəɗiye tay ha ta maslalam. Siye hay ta gəsiye tay ha beke eye hay, ta diye tay ha a gəma hay wal wal. Ndo neheye tə sər Mbəlom bay aye ta deyeweye, ta mbəzliye ha Zerozelem hele hele. Ta ndziye mə ɗəma na, hus ahəl tay nakə ka ndəv aye.» ");
INSERT INTO meq_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesu a gwaɗatay sa: «Pat eye niye wu niye hay ta dazlay na, ka pat, ka kiye, ka wurzla hay, wu məge masuwayaŋ wal wal ta bəziye ha bo. Ma ta giye na, andza mətasl nakə a vəzl haladzay vəvəva a ɓəl ha dəlov i yam wekit wekit aye. Ndo i məndzibəra hay tebiye ta dzədzariye, ma vəlateye mədzal gər. ");
INSERT INTO meq_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ndo hay haladzay ta ta mətiye tə zluwer i wu niye hay. Andza niye wu neheye gədaŋ eye ka magərmbəlom aye ta ɓəliye haladzay. ");
INSERT INTO meq_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","«Ma dəba eye na, ndo hay ta ŋgeteŋeye a neŋ Wawa i Ndo na deyeweye ma pazlay ta gədaŋ ada ta məzlaɓ eye haladzay. ");
INSERT INTO meq_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aza ka ŋgatumay a wu niye hay ta dazlay məndislew na, ləvum bo lele ada zlum gər kurom ka mbəlom, hərwi Mbəlom ma ta təmiye kurom ha bəse tuk.» ");
INSERT INTO meq_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu a tsikatay dzeke sa, a gwaɗatay: «Zəbum ka gurov ada ka dərizl i gərɗaf hay tebiye kwa! ");
INSERT INTO meq_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ka ŋgatumatay ta gəgar ha ka bo abəra slambah hay ada ta dazlay a maɗuɗe na, ka sərum ha gwaduvay kə ge, mazlambar yam ma piye bəɗaw! ");
INSERT INTO meq_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Andza niye ka ŋgatumay a wu neheye ta ndislew na, sərum ha Bəy i Mbəlom neŋgeye bəse tə nəkurom. ");
INSERT INTO meq_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","«Neŋ faya na gwaɗakumeye: Sərum ha na, wu nakay tebiye ma giye bo na, ndo neheye anəke aye ta mət zuk bay. ");
INSERT INTO meq_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Magərmbəlom ta dala ta dziye, bazlam ga na, ɗaɗa ma dziye bay.» ");
INSERT INTO meq_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Gumay metsehe a bo kurom. Kâ gərumay ha ɗərev kurom a wu məse bay, kâ kwayum bay ada kâ vəlumay ha mədzal gər kurom a wu i məndzibəra bay. Ka gumeye metsehe a bo kurom na, hərwi ada sariya i Mbəlom mâ ndzakum a gər həf bay. ");
INSERT INTO meq_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Hərwi pat eye ma deyeweye na, ndo hay tebiye ka məndzibəra ta səriye ka bo bay. Ma mbəzliye tay ha təɓəts andza ɓalay nakə a mbəzl wu aye. ");
INSERT INTO meq_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ndzum tsezlezleŋŋe, ɗuwulumay me a Mbəlom pat pat. Ka gum andza niye na, ka hutumeye gədaŋ ka məsəmay naha a wu neheye tebiye ta ndzakumeye a gər aye. Andza niye ka mbumeye faya mələtse ka təv ga, neŋ Wawa i Ndo.» ");
INSERT INTO meq_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ta həpat na, Yesu a tətikawa tay ha ndo hay ma dalamətagay i gay i məɗəslay ha gər a Mbəlom, ta huwa na, a yawa mata həne ma tsaholok nakə tə zalay Mahəmba i Tetəɗœz aye. ");
INSERT INTO meq_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Pərik i mekedœ na, ndo hay ti yawa a gay i məɗəslay ha gər a Mbəlom mata pay zləm a matətike i Yesu. ");
INSERT INTO meq_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Magurlom nakə tə zalay magurlom i Pak aye na, mazlambar ta hatsiye. Ahəl i magurlom tay niye na, tə ndayawa wu mənday tay nakə tə zalay «peŋ» aye na, gəɗe faya bay. ");
INSERT INTO meq_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","A həlay i magurlom eye niye na, bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta ndo neheye tə dzaŋgawa bazlam i Mbəlom mapala eye aye ta pəla tsəveɗ ka məkəɗe na Yesu. Ane tuk na, ta dzədzar ta ndo hay. ");
INSERT INTO meq_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Fakalaw a fələkway a bo a Yudas nakə tə zalay Iskariyot aye. Neŋgeye na, nəte mə walaŋ i gawla i Yesu niye hay kuro gər eye sulo, aye. ");
INSERT INTO meq_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yudas a həl bo a ye ka təv i bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ada ka təv i bagwar i sidzew neheye ta tsəpawa gay i məɗəslay ha gər a Mbəlom aye. A ye na, hərwi mapəle tsəveɗ ka məge ɗaf ka Yesu. ");
INSERT INTO meq_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","A yatay a gər a ndo niye hay haladzay, tə gwaɗay: «Nəmaa vəlakeye dala.» ");
INSERT INTO meq_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas a tsəne andza niye na, a təma bazlam tay niye. Tsa na, a maw abəra ka təv tay, a ye a pəla wewer ada həlay nakə lele eye hərwi məge ɗaf ka Yesu ndo hay ta səriye faya bay aye. ");
INSERT INTO meq_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yaw! Ahəl nakə tə ndayawa wu mənday nakə gəɗe faya bay aye na, pat i məkəɗe təɓaŋ hərwi məde wu mənday i Pak aye kə husaw tuk. ");
INSERT INTO meq_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu a slər Piyer ta Yuhana, a gwaɗatay: «Dum ta dumakway wu mənday i magurlom i Pak nakə ka ndayakweye.» ");
INSERT INTO meq_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Piyer ta Yuhana ta tsətsah faya, tə gwaɗay: «A saka nəmaâ daka ɗaf na, ka waray?» ");
INSERT INTO meq_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu a mbəɗatay faya, a gwaɗatay: «Tsənum lele! Taɗə faya ka deyumeye, ka ndislum a wuzlahgəma na, ka ndzumeye a gər a ndo faya ma zliye yam ta gəzla aye. Pumay bəzay hus a gay nakə ma fələkwiye a ɗəma aye, ");
INSERT INTO meq_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ada gwaɗumay a ndo i gay niye: “Miter a tsətsah fakaya, a gwaɗaka: Gay nakə nəmaa ndiye wu mənday i magurlom i Pak ta gawla ga hay aye na, məŋgay?” ");
INSERT INTO meq_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ka tsətsahum andza niye na, ma ɗakumeye faya ka gay nakə ka gər i gay neŋgeɗ aye. Huɗ i gay niye na, bagwar eye. Wu hay maləva bo eye mə ɗəma. Ka dumeye wu mənday i magurlom i Pak na, mə ɗəma.» ");
INSERT INTO meq_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Gawla i Yesu niye hay sulo eye tə həl bo ti ye. Ti ye naha na, tə ndzay a gər andza nakə Yesu a tsikatay aye. Tsa na, tə da wu mənday i Pak mə ɗəma. ");
INSERT INTO meq_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Həlay i mənde wu mənday niye a sla na, Yesu ta ndo i maslaŋ ŋgay hay ti ye naha, tə ndza hərwi mənde wu mənday. ");
INSERT INTO meq_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","A gwaɗatay: «Na ta giye ɗəretsətseh na, a seŋ haladzay mənde wu mənday i magurlom i Pak nakay tage nəkurom təday. ");
INSERT INTO meq_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ayaw! Neŋ faya na tsikakumeye, ɗaɗa na ta ndiye wu mənday nakay sa bay hus a pat nakə deɗek ŋgay eye ma giye bo ma Bəy i Mbəlom aye.» ");
INSERT INTO meq_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ma dəba eye na, a zla gəvet, a rah ha ta wu məsay. A gay naha sɨsœ a Mbəlom. Tsa na, a gwaɗ: «Zlum gəvet nakay ada kâ sum wu məsay nakay mə ɗəma aye. ");
INSERT INTO meq_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Neŋ faya na tsikakumeye, na ta siye wu məse nakay sa bay ka madazlay anəke hus a pat nakə Bəy i Mbəlom ma deyeweye aye.» ");
INSERT INTO meq_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tsa na, a zla peŋ, a gay naha sɨsœ a Mbəlom. Ma dəba eye na, a ŋgəna ha peŋ niye, a vəlatay a gawla ŋgay hay, a gwaɗatay: «Nakay na, bo ga, mavəla eye hərwi kurom. Gum ha andza nakay huya hərwi ada kâ dzalum ha ka neŋ.» ");
INSERT INTO meq_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ma dəba i mənde wu mənday niye na, a zla gəvet, a gwaɗatay: «Wu məse nakay na, bambaz ga nakə Mbəlom ma ɓariye dzam ta ndo hay aye. Ta mbəɗiye ha na, hərwi kurom. ");
INSERT INTO meq_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ane tuk na, zəbum ndo nakə ma giye fagaya ɗaf aye na, faya ka ndayakweye wu mənday dziye. ");
INSERT INTO meq_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Neŋ Wawa i Ndo na mətiye andza nakə Ɗerewel i Mbəlom a tsik aye. Ane tuk na, ɗəretsətseh ka gər i ndo nakə ma giye fagaya ɗaf aye.» ");
INSERT INTO meq_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Gawla ŋgay hay tə tsəne andza niye na, ta dazlay a matsətsehe ka bo mə walaŋ tay, tə gwaɗ: «Way nakə mata ge andza niye mə walaŋ kway na, way?» ");
INSERT INTO meq_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ma dəba eye na, gawla i Yesu hay ta dazlay məkəɗe wuway mə walaŋ tay haladzay, tə gwaɗ: «Way nakə mə walaŋ kway nakay neŋgeye bagwar eye na, way?» ");
INSERT INTO meq_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu a gwaɗatay: «Bəy bagwar eye i gəma hay faya ta ləviye bəy hay. Ndo neheye gədaŋ tay andaya aye na, a satay dzam ta ndo hay. ");
INSERT INTO meq_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ane tuk na, nəkurom na, kâ gum andza nəteye təbey! Ɗuh na, ndo nakə bagwar eye na, mâ təra andza wawa eye tsekweŋ ada ndo nakə ma ləviye ndo hay aye na, mâ təra ndo i məsler. ");
INSERT INTO meq_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","«Ayaw! Bagwar eye na, way tuk? Ndo nakə neŋgeye mandza eye ta geye məsler ka həlay aye tsukuɗu ndo məge məsler ba? Bagwar eye na, ndo nakə ta geye məsler aye bəɗaw? Andza niye, neŋ nakay anaŋ mə walaŋ kurom anəke aye, neŋ na, andza ndo i məsler. ");
INSERT INTO meq_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«Nəkurom na, ka ndzum ka təv ga. Ka zlum ŋgatay ma wuzlah i ɗəretsətseh nakə tə geŋ aye haladzay. ");
INSERT INTO meq_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Neŋ bəbay na, na vəlakumeye Bəy i Mbəlom andza bəba ga Mbəlom nakə a vəleŋ aye. ");
INSERT INTO meq_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ka ndayumeye ada ka sumeye wu məsay tage neŋ ma Bəy ga, ada ka ta ndzumeye ka təv məndze i bəy hərwi məge sariya ka gwala i Israyel neheye kuro gər eye sulo aye.» ");
INSERT INTO meq_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu a gwaɗay a Simoŋ Piyer: «Simoŋ, Simoŋ tsəne! Fakalaw kə huta gədaŋ məɓəle kurom ha, ma həviye kurom andza mahəve daw nakə ta həvawa hərwi maŋgəne tay ha ka bo abəra ta dzəndzar aye. ");
INSERT INTO meq_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ane tuk na, neŋ na ɗuwulay me a Mbəlom hərwi yak. Na ɗuwulay me a Mbəlom na, hərwi ada mədzal gər yak ka neŋ mâ ge bəle bay. Ka tsətsah məpəse me na, vəlatay gədaŋ a malamar yak hay.» ");
INSERT INTO meq_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piyer a gwaɗay: «Bəy Maduweŋ, neŋ na, maləva bo eye kwa mede a daŋgay ka deyemeye salamay. Kwa məməte, ka mətameye salamay!» ");
INSERT INTO meq_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu a mbəɗay faya, a gwaɗay: «Ka tsik na, deɗek ŋgway ɗaw Piyer. Tsəne! Na tsikakeye, bəgom nakay dzagulok ma ta zlahiye na, ɓa ka gwaɗ sik mahkar ka sər neŋ bay.» ");
INSERT INTO meq_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu a gwaɗatay a gawla ŋgay hay sa: «Ahəl niye na slər kurom ha ze dala, ze gwezem, ze tahərak mə sik na, wuray kə kətsakum ɗaw?» Ta mbəɗay faya: «Wuray kwa tsekweŋ kə kətsamay bay.» ");
INSERT INTO meq_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu a gwaɗatay: «Anəke ɗuh na, ndo nakə suloy ŋgay andaya aye na, mâ həl. Ndo nakə gwezem ŋgay andaya aye na, mâ zla dərmak. Ada ndo nakə maslalam ŋgay andaya bay aye na, mâ səkəm ha rəkwat ŋgay ada mâ səkəm maslalam. ");
INSERT INTO meq_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Hərwi mawatsa eye mə Ɗerewel i Mbəlom na, tə gwaɗ: “Neŋgeye na, ndo hay tə pasla na a walaŋ i ndo i məkəɗe ndo hay.” Na tsikakumeye: Wu nakə Ɗerewel i Mbəlom a tsik aye na, ma giye bo tebiye.» ");
INSERT INTO meq_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Gawla ŋgay hay tə gwaɗay: «Bəy Maduweŋ, maslalam hay anaŋ sulo.» Yesu a mbəɗatay faya, a gwaɗatay: «Niye na, ɗa kə sla.» ");
INSERT INTO meq_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ma dəba aye na, Yesu a ye abəra ka təv niye, a ye a tsal a Mahəmba i Tetəɗœz andza nakə a gawa ha aye. Gawla ŋgay hay tə pay bəzay. ");
INSERT INTO meq_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tə ndisl naha a ɗəma na, Yesu a gwaɗatay: «Ɗuwulumay me a Mbəlom hərwi ada kâ dəɗum a masəpete i Fakalaw bay.» ");
INSERT INTO meq_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tsa na, a gər tay ha gawla ŋgay hay. A ye abəra ka təv tay əzaɗ dəreŋ tsekweŋ tsa. A ye naha a dəkw gurmets ka dala, a ɗuwulay me a Mbəlom, ");
INSERT INTO meq_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","a gwaɗ: «Bəba, taɗə ka wuɗa na, zla fagaya abəra ɗəretsətseh nakay na siye tey! Ane tuk na, ge na, andza nakə a saka aye bəna, andza nakə a seŋ a neŋ aye bay.»  ");
INSERT INTO meq_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tsa na, gawla i Mbəlom a mbəzlaw mə mbəlom, a yaw a bəzay ha bo hərwi məvəlay gədaŋ. ");
INSERT INTO meq_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu a dzədzar, mədzal gər ŋgay a mbəɗa haladzay. A ɗuwulay me a Mbəlom ta gədaŋ sa. Merəɓe nakə faya aye na, a təra andza bambaz nakə a təkw ka dala təluk təluk aye. ");
INSERT INTO meq_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","A ndəv ha maɗuwulay me a Mbəlom na, a mbəɗa gər ka təv i gawla ŋgay hay. A ye naha a ndzatay a gər na, nəteye mandzahəra eye. Madagər a gatay hərwi ɗərev a ndalatay. ");
INSERT INTO meq_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","A gwaɗatay: «Lətsum, ɗuwulumay me a Mbəlom hərwi ada kâ dəɗum a masəpete i Fakalaw bay.» ");
INSERT INTO meq_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ahəl nakə Yesu faya ma tsikiye me mba aye na, ndo hay haladzay ti ye naha. Maa ndzatay naha kame na, Yudas neŋgeye nakə nəte mə walaŋ i gawla i Yesu hay kuro gər eye sulo aye. A ye naha bəse ka təv i Yesu hərwi məgəse na ka bo təmbolok təmbolok. ");
INSERT INTO meq_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ane tuk na, Yesu a gwaɗay: «Yudas, ka giye ɗaf ka neŋ Wawa i Ndo na, ta məgəse ga ka bo təmbolok təmbolok ɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Gawla i Yesu hay tə ŋgatay a wu niye hay faya ma giye bo andza niye na, ta tsətsah faya, tə gwaɗay: «Bəy Maduweŋ, nəmaa watsa tay ta maslalam ɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tsa na, ndo nəte mə walaŋ tay a fay a ndo i məsler i bagwar i ndo məvəlaway wu a Mbəlom, a ɗəsay na zləm i həlay i mənday fats ka dala. ");
INSERT INTO meq_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ane tuk na, Yesu a gwaɗatay a gawla ŋgay hay: «Gərum tay ha, niye na, ɗa.» Tsa na, a lamay a zləm i ndo niye, a paha suwuɗ suwuɗ. ");
INSERT INTO meq_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tsa na, Yesu a tsikatay a bagwar i ndo neheye tə vəlaway wu a Mbəlom aye, a bagwar hay i ndo matsəpe gay i məɗəslay ha gər a Mbəlom hay ada a madugula i Yahuda niye hay ti ye naha faya mata gəse na aye, a gwaɗatay: «Ka yumaw fagaya ta maslalam kurom hay ada ta sakwal kurom andza ta gəsiye ndo i məkal ɗaw? ");
INSERT INTO meq_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ada pat pat ka ndzawakwa ka bo dziye mə gay i məɗəslay ha gər a Mbəlom na, ka pəlum tsəveɗ məgəse ga bay. Ane tuk na, i kurom na, həlay eye kə sla tuk, ada həlay i ndo nakə ma ləvoŋ aye ma bəziye ha gədaŋ ŋgay.» ");
INSERT INTO meq_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tə gəs na Yesu, ti ye ha a gay i bagwar i ndo məvəlaway wu a Mbəlom. Piyer na, a patay naha bəzay ma dəba dəreŋ. ");
INSERT INTO meq_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ma dalamətagay i gay niye na, ta vat ako ma wuzlah eye. Ndo hay nəteye mandza eye ka ako eye niye. Piyer a ye naha a ndza ka təv tay dərmak. ");
INSERT INTO meq_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ŋgwas wuray andaya a gawa məsler mə gay eye niye a ŋgatay a Piyer mandza eye ka ako. A zəba faya, a ndazl na Piyer lele. Tsa na, a gwaɗ: «Nəkar dərmak na, ndo i Yesu.» ");
INSERT INTO meq_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ane tuk na, Piyer a mbəɗay faya a ŋgwas niye, a gwaɗay: «Aʼay! Na sər na bay!» ");
INSERT INTO meq_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Məndze tsekweŋ na, ndo mekeleŋ eye a ŋgatay a Piyer, a gwaɗay: «Nəkar dərmak na, nəte mə walaŋ i gawla i Yesu hay!» Piyer a gwaɗay a ndo niye: «Aʼay! Neŋ na mə walaŋ tay bay.» ");
INSERT INTO meq_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","A ndza ma dəba eye tsekweŋ mazlambar ɓəre nəte na, ndo mekeleŋ eye a tsik sa, a gwaɗ: «Ta deɗek ndo nakay na, tə ndzawa tə Yesu dərmak! Sa tsa na, neŋgeye ndo i Galile hay.» ");
INSERT INTO meq_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ane tuk na, Piyer a mbəɗay faya, a gwaɗay: «A saka məgweɗe mey na, na sər bay.» Kwayaŋŋa ahəl nakə faya ma tsikiye me mba aye na, dzagulok a zlaha. ");
INSERT INTO meq_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Bəy Maduweŋ a mbəɗa bo, a ndazl naha Piyer ndzuzle a ɗəre. Tsa na, wu nakə Yesu a tsikay a Piyer aye na, a mayaw a gər tuk. A gwaɗay na: «Bəgom dzagulok ma ta zlahiye na, ɓa ka gwaɗ sik mahkar ka sər neŋ bay.» ");
INSERT INTO meq_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tsa na, Piyer a yaw abəra ma dalamətagay, a tuwa tsɨɗuk tsɨɗuk. ");
INSERT INTO meq_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ndo neheye ta tsəpawa Yesu aye, tə ŋgwasawa ka Yesu ada tə kəɗawa na. ");
INSERT INTO meq_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tə mbuzaway na ɗəre ada ta tsətsahawa faya, tə gwaɗaway: «Nəkar na, Kəriste ba! Tsikamay, maa faka na, way?» ");
INSERT INTO meq_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ada tə tsikaway wu siye hay haladzay hərwi mətsaɗay a Yesu. ");
INSERT INTO meq_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ɗəre a tsaɗa na, madugula i Yahuda hay, bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye hay tə haya gər. Tsa na, ti ye ha Yesu kame i sariya tay. ");
INSERT INTO meq_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ti ye naha ta tsətsah faya, tə gwaɗay: «Nəkar na, Kəriste ɗaw? Tsikamay tey!» Yesu a mbəɗatay faya, a gwaɗatay: «Kwa taɗə na tsikakum bəbay na, ka təmumeye bay, ");
INSERT INTO meq_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ada taɗə na tsətsah fakuma na, ka mbəɗumeŋeye faya bay. ");
INSERT INTO meq_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ane tuk na, sərum ha kwa anəke Wawa i Ndo ma ndziye tə həlay i mənday i Mbəlom gədaŋ eye.» ");
INSERT INTO meq_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tsa na, nəteye niye tebiye tə gwaɗay: «Azlakwa nəkar na, Wawa i Mbəlom ɗaw?» Yesu a mbəɗatay faya, a gwaɗatay: «Bo kurom eye ka gwaɗum neŋ neŋgeye.» ");
INSERT INTO meq_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tə tsəne andza niye na, tə gwaɗ: «Ka pəlakweye na, sa mey. Ɓa bo kway eye ka tsənakwa wu neheye a tsik tə bazlam ŋgay aye.» ");
INSERT INTO meq_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ma dəba eye na, ndo niye hay tebiye tə lətse, ti ye ha Yesu a gay i Pilat. ");
INSERT INTO meq_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tə ndisl naha a ɗəma na, ta dazlay a məɗəse parasay ka Yesu haladzay, tə gwaɗ: «Nəmaa ndzay a gər a ndo nakay na, faya ma tsəviye tay ha ndo may hay a pesl. A gwaɗatay na: “Kâ vəlumay dzaŋgal a bəy i Roma bay” ada a gwaɗ neŋgeye Kəriste, bəy bagwar eye.» ");
INSERT INTO meq_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilat a tsətsah ka Yesu, a gwaɗay: «Nəkar na, bəy i Yahuda hay deɗek ɗaw?» Yesu a mbəɗay faya, a gwaɗay: «Nəkar ka tsik segey.» ");
INSERT INTO meq_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilat a gwaɗatay a bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ada a ndo hay tebiye: «Neŋ na, na huta mənese nakə ma gəsiye na ndo nakay a sariya aye na, na huta bay.» ");
INSERT INTO meq_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ane tuk na, ndo hay tebiye tə gwaɗay ta magala: «Faya ma tsəviye tay ha ndo hay tə matətike ŋgay nakə a tətikawatay aye. A dazlay məge andza niye na, ka dala i Galile. A həhal ha ka dala i Yahuda tebiye ada kə ya ahaya kanaŋ anəke a Zerozelem sa.» ");
INSERT INTO meq_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilat a tsəne bazlam tay niye na, a tsətsah, a gwaɗ: «Ndo nakay na, ndo i Galile ɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tə gwaɗay faya: «Yesu na, ndo i Galile.» Azlakwa maa ləva Galile na, bəy nakə tə zalay Herod aye. Pat eye niye na, neŋgeye andaya ma Zerozelem. Tsa na, Pilat a gwaɗatay: «Dum ha Yesu ka təv i Herod.» ");
INSERT INTO meq_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod a ŋgatay a Yesu na, ɗərev ŋgay a ŋgwasa haladzay. Kə tsəne ndo hay tə tsikawa ka Yesu ada a say məŋgatay a Yesu na, kwa anəke bay. A say na, Yesu mâ gay masuwayaŋ ka təv ŋgay. ");
INSERT INTO meq_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","A tsətsah wu hay haladzay ka Yesu. Ane tuk na, Yesu ka mbəɗay faya wuray kwa tsekweŋ bay. ");
INSERT INTO meq_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye, ta ye naha dərmak. Tə ɗəs parasay ka Yesu haladzay ta gədaŋ. ");
INSERT INTO meq_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod ta sidzew ŋgay hay tə tsəne andza niye na, tə tsaɗay a Yesu ada tə ŋgwasa faya haladzay. Tə pa faya petekeɗ nakə a le haladzay aye. Tsa na, tə ma ha a gay i Pilat. ");
INSERT INTO meq_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kurre na, Herod ta Pilat na, ta wuɗa bo bay, tə nay ɗəre a bo. Pat eye niye na, ta təra ta dzam eye tuk. ");
INSERT INTO meq_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ma dəba eye na, Pilat a zalatay a bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye, a bəy i dala hay ta ndo i gəma hay tebiye. ");
INSERT INTO meq_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","A gwaɗatay: «Ka gəsumeŋew ndo nakay ka gwaɗum na, faya ma tsəviye tay ha ndo hay a pesl ba! Ada na tsətsah faya bazlam, ane tuk na, na huta faya mənese nakə ma gəsiye na ta sariya aye bay. Ka ɗəsum faya parasay. ");
INSERT INTO meq_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod Aŋtipas bəbay kə huta faya mənese bay, hərwi niye kə makwaya ahaya kway. Ndo nakay na, kə ge wuray kwa tsekweŋ nakə məkəɗe na aye bay. ");
INSERT INTO meq_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hərwi niye, na ndaɓiye na ta mandalaɓa ada na gəriye ha.»  ");
INSERT INTO meq_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ka viye ka viye na, Pilat a gərawatay ha ndo abəra ma daŋgay nəte hərwi magurlom i Pak. ");
INSERT INTO meq_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Andza niye ndo hay tə tsəne bazlam i Pilat niye na, tə pa bo ka mawude ta gədaŋ, nəteye tebiye tə gwaɗ: «Kəɗ na ndo nakay, gəramay ha na, Barabas!» ");
INSERT INTO meq_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas na, tə gəs na hərwi a kəɗ ndo ahəl nakə tə ge magazləga ma wuzlahgəma aye. ");
INSERT INTO meq_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","A say a Pilat məgər ha Yesu. A tsikatay a ndo niye hay sa. ");
INSERT INTO meq_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ndo niye hay tebiye ta wuda, tə gwaɗ: «Dar na ka mayako mazləlmbaɗa eye! Dar na ka mayako mazləlmbaɗa eye!» ");
INSERT INTO meq_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilat a gwaɗatay mamahkar eye sa: «Neŋgeye a ge na, mənese waray? Neŋ na, na huta faya mənese nakə məkəɗe na aye na, na huta bay. Hərwi niye, na ndaɓiye na ta mandalaɓa na, ada na gəriye ha.» ");
INSERT INTO meq_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ane tuk na, ndo hay tə tsəne andza niye na, ta səkah ha mawude haladzay ta gədaŋ, tə gwaɗ: «Dar na ka mayako mazləlmbaɗa eye!» Tsɨy mawude tay niye a gay zləm a Pilat. ");
INSERT INTO meq_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tsa na, a təma andza i ndo hay nakə a satay aye. ");
INSERT INTO meq_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","A gəratay ha Barabas andza nakə a satay aye. Azlakwa ɗuh Barabas tə gəs na a daŋgay na, hərwi a kəɗ ndo ahəl nakə tə ge magazləga ta ndo i Roma hay aye. Yesu na, Pilat a vəlatay ha a ndo hay, a gwaɗatay: «Gumay wu nakə andza a sakum məgay aye!» ");
INSERT INTO meq_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ahəl nakə faya ta diye ha Yesu ka təv nakə ta kəɗiye na mə ɗəma aye na, tə dza gər ka tsəveɗ ta ndoweye andaya tə zalay Simoŋ a maw abəra mə pesl. Neŋgeye na, ndo i gəma i Siren. Sidzew hay tə gəs na tə gay kutoŋ ka məzle mayako niye mazləlmbaɗa eye hərwi ada mâ zla naha ma dəba i Yesu. ");
INSERT INTO meq_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ndo hay haladzay tə pay bəzay a Yesu. Ŋgwas hay haladzay faya ta tuwiye hərwi ŋgay. ");
INSERT INTO meq_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu a mbəɗa bo ka təv i ŋgwas niye hay faya ta tuwiye, a gwaɗatay: «A nəkurom ŋgwas i Zerozelem hay, kâ tuwum hərwi ga bay. Ɗuh na, tuwum hərwi bo kurom ada hərwi wawa kurom hay. ");
INSERT INTO meq_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Hərwi həlay eye ma deyeweye, ta gwaɗiye: “Məŋgwese ka gər i ŋgwas neheye ɗaɗa ta wa bay aye ada neheye ɗaɗa wawa kə sa wah tay bay aye!” ");
INSERT INTO meq_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ndo hay ta gwaɗeye a mahəmba hay: “Amboh mbəzlaw famaya tey!” Ada ta gwaɗeye a tsaholok hay: “Amboh ŋgaha may tey!” ");
INSERT INTO meq_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ayaw! Ta gay wu nakay andza nakay a mayako ŋgəɗiz eye na, ada mayako makula eye na, ma giye na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ti ye ha Yesu ka təv nakə ta kəɗiye na aye na, ta gəs naha ndo wuray hay sulo tə ge mənese hərwi madar tay ha ka mayako tage Yesu dziye. ");
INSERT INTO meq_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tə ndisl naha ka təv niye tə zalay Təv i Mətasl i Gər aye. Sidzew hay ta dar na Yesu ka mayako mazləlmbaɗa eye na, ka təv eye niye. Ta dar tay ha ndo niye hay sulo tə ge mənese aye dərmak, nəte tə həlay i mənday, neŋgeɗ tə həlay i gula. ");
INSERT INTO meq_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu a gwaɗ: «Bəba ga, pəsatay ha mənese tay hərwi wu nakə ta giye na, tə sər bay.» Sidzew hay tə ge tsakwal ka petekeɗ ŋgay hərwi məsəre ha petekeɗ mamətsa eye na, a way. Tsa na, ta ŋgəna ha a bo petekeɗ niye. ");
INSERT INTO meq_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ndo hay tebiye nəteye ka təv eye niye faya ta zəbiye ka Yesu. Bagwar i madugula i Yahuda hay tə ŋgwasa ka Yesu, tə gwaɗ: «Neŋgeye na, kə təma tay ha siye i ndo hay sa na, mâ təma ha bo ŋgay tey. Taɗə kə ge neŋgeye na, Kəriste, neŋgeye nakə Mbəlom a zla na aye na, mâ təma ha gər ŋgay tey.» ");
INSERT INTO meq_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sidzew hay tə ŋgwasa ka Yesu dərmak, ta həndzəɗ naha ka təv ŋgay tə vəlay wuye andaya guyakaka. ");
INSERT INTO meq_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Tə gwaɗay: «Kə ge nəkar bəy i Yahuda hay na, təma ha bo yak aye tey!» ");
INSERT INTO meq_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ka mayako niye mazləlmbaɗa eye na, ta law naha faya palalam wuray zal ka gər i Yesu, tə watsa: «Nakay na, bəy i Yahuda hay.» ");
INSERT INTO meq_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ndo nəte mə walaŋ i ndo niye sulo tə ge mənese, ta dar tay ka bo dziye tage Yesu aye a tsaɗay a Yesu. A gwaɗay: «Ka gwaɗ nəkar na, Kəriste sa na, təma ha gər yak ada kâ təma may ha tey!» ");
INSERT INTO meq_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ane tuk na, ndo neŋgeɗ a may ha mənese a gwaɗay: «Ka sər Mbəlom təbəɗew? Nəkar anəke ta kəɗiye kar andza neŋgeye dərmak. ");
INSERT INTO meq_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ane tuk na, i may ta kəɗ may na, təɗe bəna, ta kəɗiye may ka wu nakə ka gama lele bay aye. Neŋgeye na, kə ge mənese kwa tsekweŋ bay.» ");
INSERT INTO meq_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tsa na, a gwaɗay a Yesu: «Pat nakə ka deyeweye andza bəy bagwar eye na, kâ mətsa ga ha gər bay, dzala fagaya tey.» ");
INSERT INTO meq_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu a mbəɗay faya, a gwaɗay: «Neŋ faya na tsikakeye: Sər ha na, bəgom nakay ka ta ndzameye tə nəkar mə mbəlom.» ");
INSERT INTO meq_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ma giye mazlambar magərhəpat, ləvoŋ a ge ka dala niye tebiye tekəɗəgəm. A ge na, hus a ɓəre mahkar i huwa. ");
INSERT INTO meq_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Pat a ndərmaɗa a təv eye. Tsa na, petekeɗ nakə a ŋgəna ha ka bo abəra gay i məɗəslay ha gər a Mbəlom sulo aye a ŋguraɗa tsaŋŋa ma wuzlah. ");
INSERT INTO meq_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu a wuda ta magala kələrra, a gwaɗ: «Bəba, na gər ha məsəfəre ga a həlay yak.» A tsik andza niye na, a mət tuk. ");
INSERT INTO meq_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Bagwar i sidzew i Roma hay a ŋgatay a wu niye a ge bo aye na, a zambaɗay a Mbəlom, a gwaɗ: «Ta deɗek ndo nakay na, ndo lele eye.» ");
INSERT INTO meq_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ndo neheye haladzay ti ye mata zəbaw faya aye, tə ŋgatay a wu nakə a ge bo aye na, a ndalatay haladzay, ti ye wu tay a mətagay. ");
INSERT INTO meq_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Dzam i Yesu hay ta ŋgwas neheye tə payaw bəzay kwa abəra ma Galile aye nəteye malətsa eye dəreŋ faya ta zəbiye ka wu nakə ma giye bo aye. ");
INSERT INTO meq_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ndoweye andaya tə zalay Yusufa. Neŋgeye ŋgwalak i ndo. Neŋgeye nəte mə walaŋ i ndo məge sariya hay dərmak. ");
INSERT INTO meq_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Neŋgeye na, kə ndza ta nəteye ka məge bəbərek tay ada ka məsler tay niye tə ge aye na, kə ndza ta nəteye bay. Neŋgeye na, ndo i gəma i Arimate. Gəma eye niye mə ɗəma na, Yahuda hay. Neŋgeye faya ma həbiye Bəy i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","A ye a gay i Pilat. A ye naha a tsətsah faya tsəveɗ ka məzle mədahaŋ i Yesu. ");
INSERT INTO meq_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilat a vəlay tsəveɗ ka mədahaŋ i Yesu. Tsa na, a ye a mbəzla ahaya mədahaŋ i Yesu abəra ka mayako mazləlmbaɗa eye. A mbəkwa na mədahaŋ niye ta rəkwat. A zla na a ye ha, a pa na a tsəvay nakə mala eye ka geseh aye. Tsəvay eye niye na, ta pa a ɗəma mədahaŋ ɗaɗa zuk bay. ");
INSERT INTO meq_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pat eye niye na, pat i luma i dezele. Andza məgweɗe pat i mələve bo i pat i mazəzukw bo ada pat i mazəzukw bo ma dazleye. ");
INSERT INTO meq_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ŋgwas neheye tə pay naha bəzay a Yesu kwa abəra ma Galile aye, ti ye ka bo dziye ta Yusufa. Ta zəba ka tsəvay ada ta zəba faya Yusufa a pa na mədahaŋ i Yesu na, kəkay. ");
INSERT INTO meq_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tsa na, tə maw a mətagay. Tə maw na, tə ləva ha bo tə mal ada tə wurde hərwi mambəɗe ka mədahaŋ i Yesu. Ane tuk na, pat i mazəzukw bo na, ta zəzukw bo. Hərwi bazlam i Mbəlom mapala eye a ge me məge məsler pat i mazəzukw bo. ");
INSERT INTO meq_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pat i luma i sidzew pərik i mekedœ na, ŋgwas niye hay ti ye ka me tsəvay. Tə zla mal tay niye hay tə ləva ha bo aye ka həlay. ");
INSERT INTO meq_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tə ndisl naha na, tə ŋgatay a beber nakə ta dərəzl ha ka tsəvay aye mabədəŋgwala eye faya abəra, madzaka eye dzakka ka tsakay aye. ");
INSERT INTO meq_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tə fələkwa a ɗəma na, ta ŋgatay a mədahaŋ i Bəy Maduweŋ Yesu bay. ");
INSERT INTO meq_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tə sər wu nakə ta dzaliye bay. Kwayaŋŋa ndo hay sulo ti yaw dzərik kame tay ta bəzatay ha bo. Petekeɗ tay hay ka bo na, a dəv haladzay. ");
INSERT INTO meq_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tə ŋgatay a ndo niye hay sulo aye na, ta dzədzar haladzay. Ta rəh gər tay hay ka dala rəhe rəhe. Ndo niye hay sulo aye tə gwaɗatay: «Ka pəlumeye ndo nakə neŋgeye andaya tə ɗəre mə walaŋ i mədahaŋ hay na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Neŋgeye andaya kanaŋ bay, kə lətsew abəra ma mədahaŋ. Wu nakə a tsikakum ahəl niye neŋgeye ma Galile mba aye na, mâ makumaw a mədzal gər. ");
INSERT INTO meq_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","A gwaɗ na: “Kutoŋ neŋ Wawa i Ndo na, tâ vəlay ga ha a həlay i ndo i mezeleme hay. Ta dariye ga na, ka mayako mazləlmbaɗa eye, ada kə həna sulo ma mamahkar eye na, na lətseweye abəra ma mədahaŋ.”» ");
INSERT INTO meq_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tə tsəne andza niye na, bazlam i Yesu niye a tsikawatay aye a matayaw a gər tuk. ");
INSERT INTO meq_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tsa na, ti ye abəra ka me tsəvay niye. Ti ye ta təkəratay labara niye a gawla i Yesu niye hay ta zəkaw kuro gər eye nəte aye ada a siye i ndo neheye tə paway bəzay a Yesu aye dərmak. ");
INSERT INTO meq_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mə walaŋ i ŋgwas niye hay na, Mari nakə a yaw ma gəma i Magədala aye, Zan ta Mari may i Yakuba ada ŋgwas neheye nəteye ka bo dziye ta təkəratay labara i bazlam aye niye a ndo i maslaŋ i Yesu hay. ");
INSERT INTO meq_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ane tuk na, ndo niye tə tsəne bazlam tay niye hay ta təkəratay aye na, ta təma bay, ta zəba faya andza bazlam i matərakahaŋ. ");
INSERT INTO meq_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ane tuk na, Piyer a lətse a hway ka me tsəvay mata zəbaw. A ndisl naha ka me tsəvay na, a zəba ɗəre a tsəvay niye zərəɗ. A ŋgatay naha na, a rəkwat nakə tə mbəkwa ha Yesu aye ɗekɗek. Tsa na, a mbəɗa gər a mətagay. Wu niye a ge bo aye na, a gay hərɓaɓəkka. ");
INSERT INTO meq_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pat eye niye gawla i Yesu hay sulo mə walaŋ tay niye hay, tə həl bo ti ye a gəma nakə tə zalay Imayus aye. Gəma niye na, dəreŋ tsəfa ta Zerozelem. Taɗə ka diye tə sik abəra ma Zerozelem na, ka giye ka tsəveɗ ɓəre sulo. ");
INSERT INTO meq_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ahəl nakə faya ta diye na, faya ta tsikiye ka wu nakə a ge bo aye tebiye. ");
INSERT INTO meq_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ahəl nakə nəteye faya ta tsikiye me ada faya ta kəɗiye wuway ka gər i wu nakə a ge bo aye na, Yesu a yaw a həndzəɗ ka təv tay. Ti ye ka tsəveɗ eye nəte. ");
INSERT INTO meq_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Faya ta ŋgateye a Yesu ane tuk na, tə sər na bay hərwi wuye a gwaɗatay ta sər na bay. ");
INSERT INTO meq_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu a tsətsah fataya, a gwaɗatay: «Ka tsikum na, ka gər i bazlam i mey?» Tə tsəne andza niye na, tə lətse. Ɗərev a ndalatay haladzay. ");
INSERT INTO meq_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ndo nəte mə walaŋ tay niye sulo aye na, məzele ŋgay Kəleyopas, a gwaɗay: «Wu nakə a ge bo ma məhəne neheye ka sər bay na, nəkar mbəlok eye ma Zerozelem kəla ɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","A mbəɗay faya, a gwaɗay: «Maa ge mey?» Ta mbəɗay faya, tə gwaɗay: «Wu nakə a ge tə Yesu ndo i Nazaret aye na, ka tsəne təbəɗew? Neŋgeye na, ndo məɗe ha bazlam i Mbəlom. Məsler nakə a gawa aye tə bazlam nakə a tsikawa kame i Mbəlom ada kame i ndo aye hay na, ta gədaŋ eye ");
INSERT INTO meq_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta bagwar kway hay tə gəs na. Tə vəlay ha a Pilat, a gay sariya i məkəɗe. Ma dəba aye na, ta dar na ka mayako mazləlmbaɗa eye. ");
INSERT INTO meq_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nəmaa dzala haɓe mə gər may na, nəmaa gwaɗ mata təma tay ha Israyel hay na, neŋgeye. Ane tuk na, zle ka wu neheye a ge bo aye, kə ge məhəne mahkar bəgom. ");
INSERT INTO meq_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Sa tsa na, siye i ŋgwas neheye mə walaŋ may ta vəlamay madzədzere. Kə ma may ha hərɓaɓəkka. Hərwi ta wula pərek i mekedœ ka me tsəvay, ");
INSERT INTO meq_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ane tuk na, ta huta na mədahaŋ i Yesu bay. Ta mbəɗaw gər, tə maw ka təv may na, ta təkəramay, tə gwaɗ gawla i Mbəlom hay ta bəzatay ha bo ada gawla i Mbəlom niye hay tə gwaɗatay na, Yesu andaya tə ɗəre. ");
INSERT INTO meq_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nəmaa tsəne andza niye na, siye i ndo mə walaŋ may hay ti ye ka me tsəvay sa. Ti ye, tə huta na, andza i ŋgwas niye hay ta təkəramay aye. Ane tuk na, ta ŋgatay a Yesu bay.» ");
INSERT INTO meq_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesu a gwaɗatay: «Nəkurom ndo neheye metsehe andaya fakuma bay aye. Wu neheye ndo məɗe ha bazlam i Mbəlom hay tə ɗa ha kurre na, a mbakum a mədzal gər kurom təbəɗew? ");
INSERT INTO meq_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ka sərum təbəɗew, Kəriste ma diye a bəy ŋgay na, ma giye ɗəretsətseh haladzay təday.» ");
INSERT INTO meq_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tsa na, a ɗatay ha wu nakə tə tsik ka neŋgeye mə Ɗerewel i Mbəlom aye tebiye. Ma dazlay mə ɗerewel i Musa ada mede ha hus a ɗerewel i ndo məɗe ha bazlam i Mbəlom hay. ");
INSERT INTO meq_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ahəl nakə faya ta diye, tə ndisl bəse ta gəma nakə faya ta diye a ɗəma aye na, Yesu a ge andza ma zliye tsəveɗ ŋgay. ");
INSERT INTO meq_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ane tuk na, ndo niye hay tə gwaɗay: «Kâ ye a təv eye bay, ndza tə nəmay. Hərwi ɗəre faya ma gəsiye ada mazlambar həvaɗ segey.» Tsa na, tə fələkwa a gay wuray, a ndza ta nəteye. ");
INSERT INTO meq_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yesu a pa bo ka mənde wu mənday ta nəteye. A zla peŋ, a gay naha sɨsœ a Mbəlom. Tsa na, a ŋgənatay ha peŋ niye ada a vəlatay. ");
INSERT INTO meq_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kwayaŋŋa ɗəre tay a həndək, tə sər na tuk. Ane tuk na, ta zəba ɗəre na, neŋgeye andaya ka təv tay sa bay kə gər tay ha. ");
INSERT INTO meq_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tə gwaɗ mə walaŋ tay: «Ahəl nakə faya ma ɗakway ha Ɗerewel i Mbəlom ka tsəveɗ aye na, wuye mə ɗərev may andza ako!» ");
INSERT INTO meq_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ndo niye sulo aye tə lətse kwayaŋŋa ta mbəɗa gər a Zerozelem. Tə ndisl naha a wuzlah gay na, tə ndzay a gər a gawla i Yesu neheye kuro gər eye nəte aye tə siye i ndo mekeleŋ eye hay nəteye mahaya gər eye. ");
INSERT INTO meq_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ndo niye hay tə ŋgatatay a ndo neheye sulo aye na, tə gwaɗatay: «Ta deɗek Bəy Maduweŋ kway kə lətsew abəra ma mədahaŋ, Simoŋ kə ŋgatay!» ");
INSERT INTO meq_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nəteye dərmak ta təkəratay wu nakə a ge bo ta nəteye ka tsəveɗ aye. Tə gwaɗatay: «Nəmaa ŋgatay a Yesu ada nəmaa sər na na, ahəl nakə a ŋgənamay peŋ aye.» ");
INSERT INTO meq_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ahəl nakə nəteye faya ta tsikiye me mba aye na, Yesu a yaw a walaŋ tay slekərtik. Tsa na, a gwaɗatay: «Zay mâ ndza fakuma!» ");
INSERT INTO meq_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Gawla ŋgay niye hay ta dzədzar, zluwer a gatay haladzay. Hərwi tə dzala ma giye na, manakasla. ");
INSERT INTO meq_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ane tuk na, Yesu a gwaɗatay: «Ka dzədzarum andza niye na, hərwi mey? Ada ka dzalum mə gər kurom andza niye na, kemey? ");
INSERT INTO meq_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Zəbum ka həlay ga tə sik ga. Na gwaɗ neŋ deɗek ŋgway bəɗaw? Tətalum fagaya ada zəbum fagaya lele. Hərwi sərum ha manakasla na, slo faya bay ada mətasl mə ɗəma andza neŋ nakə faya ka zəbumeye fagaya aye bay.» ");
INSERT INTO meq_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","A tsikatay andza niye na, a bəzatay ha vavay nakə ka həlay ŋgay hay ada ka sik ŋgay hay. ");
INSERT INTO meq_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Məŋgwese a rah a ɗərev i gawla ŋgay niye hay ada a gatay hərɓaɓəkka. Ada huya ta dzala ha faya zuk bay. Tsa na, Yesu a tsətsah fataya, a gwaɗatay: «Wu mənday andaya fakuma ɗaw?» ");
INSERT INTO meq_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ti ye naha tə zlayaw siye i kəlef mafəka eye nəte, tə vəlay. ");
INSERT INTO meq_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yesu a təma kəlef niye ada a həpəɗ kame tay. Tsa na, a gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","«Ahəl niye neŋ tə nəkurom mba aye na, na tsikakum, na gwaɗawakum: Wu nakə tə watsa ka gər ga mə ɗerewel i Musa, mə ɗerewel i ndo məɗe ha bazlam i Mbəlom hay ada mə ɗerewel i Dəmes hay aye na, kutoŋ wu niye ma giye bo.» ");
INSERT INTO meq_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tsa na, Yesu a həndəkatay ha metsehe hərwi ada tâ sər Ɗerewel i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","A gwaɗatay sa: «Wu nakə tə watsa mə Ɗerewel i Mbəlom aye na, anaŋ: Kəriste na, ma ta giye ɗəretsətseh, ada məhəne sulo mamahkar eye na, ma lətseweye abəra ma mədahaŋ. ");
INSERT INTO meq_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ada ma sləriye ndo hay ka məɗatay ha bazlam i Mbəlom a slala i ndo i məndzibəra hay tebiye tâ gər ha mezeleme hərwi ada Mbəlom mâ pəsatay ha mənese tay hay. Tâ dazlay na, ma Zerozelem. ");
INSERT INTO meq_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Maa təra ndo i məhəle mbal i wu nakay ma giye bo tebiye na, nəkurom. ");
INSERT INTO meq_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ada neŋ eye na sləraweye fakuma wu nakə Bəba a gwaɗ ma vəlakumeye. Nəkurom na, ndzum ma wuzlah gay. Həbum gədaŋ i Mbəlom nakə ma vəlakumeye mə mbəlom aye.» ");
INSERT INTO meq_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ma dəba eye na, Yesu a həl gawla ŋgay hay abəra ma gəma niye, a ye tay ha a təv nakə bəse ta gəma i Betani aye. Mə ɗəma na, a zla həlay ka mbəlom. Tsa na, a pa fataya ŋgama. ");
INSERT INTO meq_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ahəl nakə faya ma piye fataya ŋgama aye na, a ye fataya abəra, a tsal ka təv i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nəteye na, tə ɗəslay ha gər ada ta mbəɗa gər a Zerozelem ta məŋgwese eye haladzay mə ɗərev tay. ");
INSERT INTO meq_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ti yawa a gay i məɗəslay ha gər a Mbəlom pat pat, ta zambaɗaway a Mbəlom.");
INSERT INTO meq_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ahəl nakə Mbəlom kə ge məndzibəra zuk bay aye na, ndo nakə tə zalay bazlam i Mbəlom aye na, neŋgeye andaya. Neŋgeye na, ta Mbəlom ada neŋgeye na, Mbəlom. ");
INSERT INTO meq_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ahəl nakə Mbəlom kə ge məndzibəra zuk bay aye na, neŋgeye andaya ta Mbəlom ");
INSERT INTO meq_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Mbəlom a ge wu hay tebiye na, tə həlay ŋgay. Wu kwa nəte nakə Mbəlom a ge ze neŋgeye na, andaya bay. ");
INSERT INTO meq_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Maa vəl sifa a ndo hay na, neŋgeye. Sifa niye na, a vəlatay dzaydzay a ndo hay. ");
INSERT INTO meq_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Dzaydzay niye ma dəviye ma ləvoŋ ada ləvoŋ kə mbata ha bay. ");
INSERT INTO meq_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ahəl niye na, Mbəlom a sləraw ndoweye andaya tə zalay Yuhana. ");
INSERT INTO meq_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","A yaw na, məɗatay ha dzaydzay eye niye a ndo hay hərwi ada ndo hay tebiye tâ tsəne bazlam ŋgay ada tâ dzala ha ka bazlam ŋgay. ");
INSERT INTO meq_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yuhana neŋgeye na, dzaydzay niye ma dəvateye a ndo hay aye bay. Neŋgeye a yaw na, mata ɗatay ha a ndo hay tsa. ");
INSERT INTO meq_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Dzaydzay niye na, dzaydzay deɗek eye ma deyeweye ka məndzibəra, ma dəvateye dzaydzay a ndo hay tebiye. ");
INSERT INTO meq_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ndo nakə tə zalay bazlam i Mbəlom aye na, ki yaw ka məndzibəra. Kwa taɗə Mbəlom a ge məndzibəra tə həlay ŋgay bəbay na, ndo hay ta sər na bay. ");
INSERT INTO meq_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","A yaw na, a təv ŋgay, ane tuk na, ndo ŋgay hay ta təma na bay. ");
INSERT INTO meq_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ane tuk na, ndo mekeleŋ eye hay na, ta təma na ada ta dzala ha. Nəteye na, kə vəlatay tsəveɗ matəre wawa i Mbəlom hay. ");
INSERT INTO meq_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ta təra wawa i Mbəlom hay na, andza nakə ndo hay faya ta wiye bo ka məndzibəra aye bay ada hərwi nakə a satay a ndo hay aye bay. Ane tuk na, ta təra wawa i Mbəlom hay na, hərwi Mbəlom eye ŋgway a vəlatay məsəfəre weɗeye. ");
INSERT INTO meq_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Neŋgeye nakə tə zalay bazlam i Mbəlom aye na, ka təra ndo zezeŋ ada ki yaw kə ndza mə walaŋ kway. Neŋgeye na, a gatay ŋgwalak a ndo hay haladzay. Ka bəzakway ha deɗek i Mbəlom. Nəmaa ŋgatay a məzlaɓ ŋgay. Maa vəlay məzlaɓ niye na, Mbəlom Bəba ŋgay. A vəlay na, a wawa ŋgay niye nəte aye. ");
INSERT INTO meq_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yuhana faya ma ɗatay ha a ndo hay, a wuda kələrra a gwaɗ: «Ndo nakə na tsik faya aye na, neŋgeye anaŋ. Ahəl niye na gwaɗ na: “Ndoweye andaya ma deyeweye ma dəba ga a ze ga, hərwi neŋgeye na, andaya kwa ahəl nakə ta wa ga zuk bay aye.”» ");
INSERT INTO meq_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Andza niye nəkway tebiye ka hutakwa ŋgwalak ŋgay, kə pa fakwaya ŋgama ada ma piye fakwaya ŋgama ŋgay huya. ");
INSERT INTO meq_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mbəlom a vəlakway bazlam ŋgay mapala eye na, tə həlay i Musa. Ane tuk na, ŋgwalak ŋgay ta deɗek ŋgay a vəlakway na, tə həlay i Yesu Kəriste. ");
INSERT INTO meq_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ndəray ɗaɗa kə ŋgatay a Mbəlom bay. Ane tuk na, wawa ŋgay niye nəte aye mandza eye ka təv i bəba ŋgay aye, neŋgeye na, Mbəlom. Mbəlom neŋgeye kəkay na, ka bəzakway ha. ");
INSERT INTO meq_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Pat wuray na, bagwar i Yahuda neheye ma Zerozelem aye tə slər ndo məvəlay wu a Mbəlom hay ta Levit hay ka təv i Yuhana mata tsətsehe faya: «Nəkar təday na, way?» ");
INSERT INTO meq_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ti ye ta tsətsah faya na, ka kərah mambəɗatay faya bay. Ane tuk na, a tsikatay parakka kame i ndo hay tebiye. A gwaɗatay: «Neŋ na, Kəriste bay.» ");
INSERT INTO meq_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ta tsətsah faya, tə gwaɗay: «Ada nəkar na way? Nəkar na, Eliya ndo məɗe ha bazlam i Mbəlom niye ahəl niye ɗaw?» Yuhana a mbəɗatay faya, a gwaɗatay: «Aʼay.» Ta tsətsah faya sa, tə gwaɗay: «Nəkar na, ndo məɗe ha bazlam i Mbəlom nakə faya nəmaa həbiye ɗaw?» Yuhana a mbəɗatay faya, a gwaɗatay: «Aʼay.» ");
INSERT INTO meq_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tə gwaɗay: «Ada tebiye nəkar kəla na, way? Ɗamay ha tey hərwi nəmaa ta tsikateye a ndo neheye tə sləra may ahaya aye. Bo yak eye ka gwaɗ nəkar na, way?» ");
INSERT INTO meq_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yuhana a gwaɗatay: «Neŋ na, ndo nakə Ezay ndo məɗe ha bazlam i Mbəlom a tsik faya ahəl niye, a gwaɗ ka neŋ na: “Ndo nakə faya ma wudiye mə kəsaf a gwaɗ: Lambaɗumay tsəveɗ a Bəy Maduweŋ fehe lele, mâ hədzak bay.”» ");
INSERT INTO meq_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mə walaŋ i ndo neheye tə slər tay naha ka təv i Yuhana aye na, Farisa hay andaya mə walaŋ tay. ");
INSERT INTO meq_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ti ye naha tə gwaɗay: «Taɗə nəkar na, Kəriste bay, nəkar Eliya bay, nəkar ndo məɗe ha bazlam i Mbəlom nakə faya nəmaa həbiye bay na, ada faya ka dzəhuɓiye tay ha ndo hay a yam na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yuhana a mbəɗatay faya, a gwaɗatay: «Neŋ na, na dzəhuɓiye ndo hay na, a yam tsa, aya ane ndo andaya mə walaŋ kurom ka sərum na bay. ");
INSERT INTO meq_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Neŋgeye na, ma deyeweye kame ga. Na sliye mahəndzəɗe ka təv ŋgay məpəlay ha ləɓer i tahərak ŋgay bay tebiye.» ");
INSERT INTO meq_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Wu niye a ge bo tebiye na, ma gəma i Betani, ma diye i magayam i Yurdum ka təv nakə Yuhana a dzəhuɓawa a ɗəma ndo hay a yam aye. ");
INSERT INTO meq_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tədœ eye na, Yuhana a ŋgatay a Yesu faya ma deyeweye ka təv ŋgay. Tsa na, a gwaɗ: «Wawa i təɓaŋ nakə Mbəlom ma vəliye hərwi məpəsatay ha mezeleme i ndo hay aye na, atay ma deyeweye. ");
INSERT INTO meq_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Na gwaɗ: “Ndo ma deyeweye ma dəba ga, neŋgeye a ze ga, hərwi neŋgeye na, kwa ahəl nakə ta ge məndzibəra zuk bay aye na, neŋgeye andaya.” Na tsik na, ka neŋgeye. ");
INSERT INTO meq_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Neŋ kurre na, neŋgeye way na, na sər na bay. Ane tuk na, neŋ na yaw na, madzəhuɓe tay ha ndo hay a yam tsa, ada məɗatay ha a Israyel hay hərwi ada tâ sər na.» ");
INSERT INTO meq_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yuhana a ɗatay ha, a gwaɗatay sa: «Na ŋgatay a Məsəfəre i Mbəlom faya ma mbəzlaweye abəra mə mbəlom andza bodobodo. A yaw a ndza ka gər ŋgay. ");
INSERT INTO meq_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ahəl niye na, neŋgeye way na, na sər ha zuk bay. Ane tuk na, Mbəlom nakə a sləra ga ahaya madzəhuɓe ndo hay a yam aye na, a gweɗeŋ: “Ka ta ŋgateye a Məsəfəre ma mbəzlaweye abəra mə mbəlom ma ndziye ka gər i ndo. Mata dzəhuɓe tay ha ndo hay ta Məsəfəre Tsəɗaŋŋa eye na, neŋgeye.” ");
INSERT INTO meq_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ada neŋ na, na ŋgatay, na ɗa ha. Ta deɗek neŋgeye na, Wawa i Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tədœ eye na, Yuhana ta gawla ŋgay hay sulo ti ye ka təv eye niye sa. ");
INSERT INTO meq_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","A ŋgatay a Yesu faya ma diye na, a gwaɗ: «Nakay na, wawa i təɓaŋ i Mbəlom nakə a vəl aye.» ");
INSERT INTO meq_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Gawla i Yuhana niye hay sulo aye tə tsəne andza niye na, tə pay bəzay a Yesu. ");
INSERT INTO meq_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Faya ta diye na, Yesu a zəba ɗəre a dəba, a ŋgatatay faya ta pay bəzay. A tsətsah fataya, a gwaɗatay: «Ka pəlum mey?» Tə gwaɗay: «Rabi, təv yak nakə ka ndzawa mə ɗəma aye na, ka waray?» (Rabi na, andza məgweɗe «Miter»). ");
INSERT INTO meq_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu a mbəɗatay faya, a gwaɗatay: «Dumara, takwa, ka ŋgatumeye a təv ga nakə neŋ na ndzawa mə ɗəma aye.» Tsa na, ti ye. Ti ye naha tə ŋgatay a təv nakə neŋgeye mandza eye mə ɗəma aye. Ti ye na, ma giye ɓəre faɗ. Tə ndza ka bo dziye hus a həvaɗ. ");
INSERT INTO meq_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ndo nəte mə walaŋ tay niye tə tsəne bazlam i Yuhana niye a tsik aye ada tə pay bəzay a Yesu aye na, məzele ŋgay Aŋdəre. Neŋgeye malamar i Simoŋ Piyer. ");
INSERT INTO meq_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Aŋdəre a ndzay a gər kurre na, a malamar ŋgay Simoŋ. A gwaɗay: «Nəmaa ŋgatay a ndo nakə Mbəlom a pay dzagwa i bəy a gər aye.» Andza məgweɗe, Kəriste. ");
INSERT INTO meq_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","A laka ha Simoŋ ka təv i Yesu. Tsa na, Yesu a zəba faya, a gwaɗay: «Nəkar na, Simoŋ, wawa i Yuhana. Ta ta zalakeye na, Sefas.» Andza məgweɗe Piyer. ");
INSERT INTO meq_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tədœ eye na, a say a Yesu mede a Galile. Ahəl nakə faya ma diye na, a ndzay a gər a Filip, a gwaɗay: «Dara, peŋ bəzay!» ");
INSERT INTO meq_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip neŋgeye na, ndo i gəma i Betesayda, gəma nakə Aŋdəre ta Piyer ti yaw abəra mə ɗəma aye dərmak. ");
INSERT INTO meq_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ma dəba aye na, Filip a ye a ndzay a gər a Nataniyel, a gwaɗay: «Ndo nakə Musa a watsa faya mə ɗerewel ŋgay ada ndo məɗe ha bazlam i Mbəlom hay tə watsa faya ahəl niye aye nəmaa ŋgatay. Neŋgeye na, Yesu, ndo i gəma i Nazaret wawa i Yusufa.» ");
INSERT INTO meq_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniyel a gwaɗay faya: «Ka dzala na, wu lele eye ma sliye faya madayaw abəra ma gəma i Nazaret ɗaw?» Filip a mbəɗay faya, a gwaɗay: «Dara, ka ŋgateye.» ");
INSERT INTO meq_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu a ŋgatay a Nataniyel faya ma diye naha ka təv ŋgay na, a tsik ka Nataniyel, a gwaɗ: «Ndo i Israyel nakə ɗeɗəŋ eye na, anaŋ. Neŋgeye na, maraw me andaya faya kwa tsekweŋ bay.» ");
INSERT INTO meq_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyel a tsətsah faya, a gwaɗay: «Ka sər ga ha na, ma kəkay?» Yesu a mbəɗay faya a gwaɗay: «Ahəl nakə Filip kə zalakaw zuk bay aye na, na ŋgataka, nəkar mə bəzay i gurov.» ");
INSERT INTO meq_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tsa na, Nataniyel a gwaɗay: «Miter, nəkar na, Wawa i Mbəlom, nəkar Bəy bagwar eye i Israyel hay!» ");
INSERT INTO meq_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu a mbəɗay faya, a gwaɗay: «Andza niye, ka dzala ha ka neŋ na, hərwi na gwaɗaka na ŋgataka naha mə bəzay i gurov aye ɗaw? Nəkar na, ka ta ŋgateye a wu bagwar eye hay ta ziye nakay anaŋ aye!» ");
INSERT INTO meq_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu a gwaɗay sa: «Sərum ha na, ka ŋgatumeye a magərmbəlom ma həndəkiye tuwaŋ. Gawla i Mbəlom hay ta tsaliye ada ta mbəzlaweye ka gər ga, neŋ Wawa i Ndo!» ");
INSERT INTO meq_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Məhəne sulo ma dəba i mədzəgər i Yesu ta Nataniyel na, mabəzləme gər i dahəlay a ge bo ma gəma i Kana, ka dala i Galile. May i Yesu andaya mə ɗəma. ");
INSERT INTO meq_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ta zalay a Yesu ta gawla ŋgay hay dərmak. ");
INSERT INTO meq_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Faya magurlom ma giye na, guzom a ndəv fataya abəra. May i Yesu a gwaɗay a wawa ŋgay Yesu: «Guzom andaya sa bay. Ka ndəv na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu a mbəɗay faya, a gwaɗay: «May ga, wu nakə neŋ na giye na, mata tsikeŋ na, nəkar ɗaw? Həlay ga kə slaw zuk bay.» ");
INSERT INTO meq_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","May i Yesu a tsəne andza niye na, a ye a gwaɗatay a ndo i məsler hay: «Gum wu nakə ma tsikakumeye tebiye.» ");
INSERT INTO meq_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ka təv eye niye na, gah hay andaya məkwa. Gah niye hay məkwa aye na, Yahuda hay ta mbəɗawa a ɗəma yam ka məbere wu hay ada tə həlay andza nakə bazlam tay mapala eye a tsik aye. Gah niye hay na, yam ma diye a ɗəma ma giye kalawah zlam, zlam. ");
INSERT INTO meq_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu a gwaɗatay a ndo i məsler hay: «Dum naha təɗumaw yam, rahum ha a gah neheye tsesləsle tsesləsle.» Ndo i məsler niye hay ti ye tə təɗaw yam. Tə rah ha a gah niye hay tsesləsle tsesləsle. ");
INSERT INTO meq_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yesu a gwaɗatay: «Anəke na, təɗum yam nakay, zlumay naha a ndo mələvay gər a magurlom, mâ ndzaka na.» Ndo i məsler hay tə zlay naha yam niye. ");
INSERT INTO meq_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ndo mələvay gər a magurlom niye a ndzaka na, yam niye a təra guzom aye. A ndzaka na, guzom eye a yaw məŋgay na, a sər bay. Ane tuk na, ndo i məsler neheye tə təɗ yam aye na, nəteye tə sər ha. Yesu a zalay a zal i dahəlay, ");
INSERT INTO meq_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","a gwaɗay: «Kwa way kə zalatay a ndo hay na, ma vəlateye guzom nakə a tsəhən aye təday. Ta sa haladzay na, ma vəlateye nakə a tsəhən bay aye tuk. Ane tuk na, nəkar na, ka pa na nakə lele eye wu yak hus anəke na, kəkay!» ");
INSERT INTO meq_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nakay na, makurre i masuwayaŋ nakə Yesu a lah məge aye. A ge na, ma Kana ka dala i Galile. Andza niye Yesu a bəz ha məzlaɓ ŋgay. Hərwi niye gawla ŋgay hay tə dzala ha ka Yesu. ");
INSERT INTO meq_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ma dəba aye na, Yesu a ye a Kafernahum ta may ŋgay, ta malamar ŋgay hay ada ta gawla ŋgay hay. Tə ndza mə ɗəma məhəne tsakway. ");
INSERT INTO meq_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Magurlom i Yahuda hay nakə tə zalay Pak aye na, mazlambar kə ndzew bəse. Hərwi niye, Yesu a həl bo a ye a Zerozelem. ");
INSERT INTO meq_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","A ndisl a Zerozelem na, a ye a dalamətagay i gay i məɗəslay ha gər a Mbəlom. A ye naha a ɗəma na, a ndzay a gər a ndo masəkəme ha sla hay, ta təɓaŋ, ta maydagwar hay. A ndzay naha a gər a ndo mambəɗe suloy hay mandza eye hay ka wu məpe wu tay hay dərmak. ");
INSERT INTO meq_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tsa na, a zla ləɓer, a slapa ha ka bo, a təra ha mandalaɓa. A ye a həhar tay ha ndo niye hay abəra dəreŋ, tə sla tay hay, ta təɓaŋ tay hay tebiye abəra mə gay i məɗəslay ha gər a Mbəlom. A kwats ha suloy i ndo mambəɗe suloy ka dala, a pay həlay a wu məpe wu tay niye hay. ");
INSERT INTO meq_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","A gwaɗatay a ndo masəkəme ha maydagwar hay: «Həlum wu kurom neheye abəra kanaŋ! Kâ tərum ha gay i Bəba ga, gay i məge tsakala mə ɗəma bay.» ");
INSERT INTO meq_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Gawla ŋgay hay tə ŋgatay andza niye na, wu nakə mawatsa eye mə Ɗerewel i Mbəlom aye a matayaw a gər. Tə watsa na, tə gwaɗ: «Gay yak nakay na, na wuɗa na haladzay. Mədzal gər ga peteh, na pa na a ɗəma.» ");
INSERT INTO meq_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Bagwar i Yahuda hay ta tsətsah faya, tə gwaɗay: «Ka sliye faya məge na, masuwayaŋ waray nakə ada nəmay nəmaa səriye ha ta vəlaka tsəveɗ ka məge wu andza nakay aye?» ");
INSERT INTO meq_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu a mbəɗatay faya, a gwaɗatay: «Mbəzlum ha gay i məɗəslay ha gər a Mbəlom nakay. Ma məhəne mahkar na, na lətsiye ha ka mbəlom.» ");
INSERT INTO meq_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tə gwaɗay: «Gay nakay nəmaa ndza faya ka maɗəzle na, məve kuro kuro faɗ gər eye məkwa tuk na, ada nəkar i yak na, ma məhəne mahkar tsa na, ka ɗəzl na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ane tuk na, gay i məɗəslay ha gər a Mbəlom niye Yesu a tsik faya aye na, a tsik dzeke ka bo ŋgay. ");
INSERT INTO meq_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ahəl nakə Yesu a mət ada a lətsew abəra ma mədahaŋ aye na, bazlam ŋgay niye a tsik aye a matayaw a gər a gawla ŋgay hay. Pat eye niye na, tə dzala ha ka wu nakə mawatsa eye mə Ɗerewel i Mbəlom aye ada ka bazlam ŋgay nakə a tsik aye. ");
INSERT INTO meq_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ahəl nakə Yesu neŋgeye ma Zerozelem ada neŋgeye mə magurlom i Pak aye na, kə ge wu neheye a ge masuwayaŋ haladzay aye. Andza niye, ndo hay haladzay ta ŋgatay a masuwayaŋ niye hay ada ta dzala ha ka Yesu. ");
INSERT INTO meq_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ane tuk na, Yesu na, kə pa mədzal gər ŋgay ka nəteye bay hərwi neŋgeye a sər tay ha tebiye, ");
INSERT INTO meq_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ada neŋgeye na, ndo məɗay ha wu nakə mə bo i ndo zezeŋ aye ka həlay təbey hərwi bo ŋgay eye a sər ha wu nakə mə ɗərev i ndo zezeŋ aye. ");
INSERT INTO meq_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ndoweye andaya məzele ŋgay Nikodem. Neŋgeye na, bagwar eye mə walaŋ i ndo neheye tə ləvawa Yahuda hay aye. Neŋgeye na, Farisa hay. ");
INSERT INTO meq_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Pat wuray na, a ye ka təv i Yesu ta həvaɗ. A ye naha, a gwaɗay: «Miter, nəmaa sər ha Mbəlom a sləra kar ahaya na, ka matətikamay wu hay deɗek, hərwi ndəray ma sliye faya məge masuwayaŋ andza nakə ka ge aye bay taɗə gədaŋ i Mbəlom andaya faya bay na, ma sliye faya bay.» ");
INSERT INTO meq_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu a mbəɗay faya, a gwaɗay: «Sər ha na, ndoweye kə wa bo weɗeye bay na, ma sliye faya mede a Bəy i Mbəlom bay.» ");
INSERT INTO meq_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodem a tsətsah faya a gwaɗay: «Ndo guram eye tsɨy tuk na, ma wiye bo weɗeye sa na, kəkay? Ma sliye faya məme a huɗ i may ŋgay ada ta wiye na masulo eye sa ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu a mbəɗay faya, a gwaɗay: «Sər ha na, ta dzəhuɓ kar ha a yam ada ta Məsəfəre i Mbəlom bay na, ka sliye faya mede a Bəy i Mbəlom bay. ");
INSERT INTO meq_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ndo nakə ndo zezeŋ a wa aye na, ndo zezeŋ ŋgway. Ada ndo nakə tə wa na ta Məsəfəre i Mbəlom aye na, məsəfəre ŋgway. ");
INSERT INTO meq_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Bazlam nakə na gwaɗaka “wum bo masulo” aye na, mâ gaka wadəŋ wadəŋ bay. ");
INSERT INTO meq_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mətasl a vəzl a təv nakə a say aye. Ka tsəne mavəzle ŋgay eye, ane tuk na, a yaw məŋgay ada ma diye a ŋgay na, ka sər bay. Ma giye bo ta ndo nakə tə wa na ta Məsəfəre i Mbəlom aye na, andza nakay.» ");
INSERT INTO meq_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodem a gwaɗay: «Ada tebiye wuye ma giye bo na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu a mbəɗay faya a gwaɗay: «Nəkar ndo matətikay wu a ndo hay nakə bagwar eye ma gwala i Israyel aye. Ane tuk na, ka sər wu neheye bay na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sər ha na, nəmaa tsikakum na, wu nakə nəmaa sər aye ada ka gər i wu nakə nəmaa ŋgatay aye. Ane tuk na, a sakum matəme wu nakə nəmaa ɗakum ha aye bay. ");
INSERT INTO meq_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Na tsikakum ka wu nakay ka məndzibəra aye ka təmum bay. Ada kəkay taɗə na tsikakum ka wu nakə mə mbəlom aye na, ka təmumeye ɗaw? ");
INSERT INTO meq_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","«Ndəray ɗaɗa kə tsal a mbəlom bay. Ndo nakə neŋ Wawa i Ndo aye nəte ŋgweŋ. ");
INSERT INTO meq_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Andza nakə ahəl niye Musa a lətse ha ɓəre nakə tə vəɗ na andza dədœ ka mayako mə makulkwandah aye na, andza niye neŋ Wawa i Ndo kutoŋ ta lətsiye ga ha ka mayako dərmak, ");
INSERT INTO meq_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","hərwi ada kwa way kə dzala ha ka neŋ Wawa i Ndo na, ma hutiye sifa nakə ma ndəviye bay aye. ");
INSERT INTO meq_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Hərwi Mbəlom a wuɗa məndzibəra na, haladzay. Hərwi niye a sləraw Wawa ŋgay felik eye hərwi ada kwa way kə dzala ha faya na, ma dziye sa bay. Ane tuk na, ma hutiye sifa nakə ma ndəviye bay aye. ");
INSERT INTO meq_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mbəlom a sləraw Wawa ŋgay ka məndzibəra na, hərwi ada mâ ge sariya ka ndo hay bay. A sləra ahaya na, hərwi ada ndo hay tâ təma ɗuh. ");
INSERT INTO meq_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","«Ndo nakə kə dzala ha ka Wawa i Mbəlom aye na, sariya ma ta gəsiye na bay. Ane tuk na, ndo nakə kə dzala ha bay aye na, ɓa sariya kə gəs na, hərwi kə dzala ha ka felik i Wawa i Mbəlom bay. ");
INSERT INTO meq_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Sariya ma ta gəsiye ndo hay ta tsəveɗ waray na, ma ta gəsiye tay ha na, andza nakay: Dzaydzay ki yaw ka məndzibəra. Ane tuk na, ndo hay ta wuɗa dzaydzay niye bay. Nəteye ta wuɗa ɗuh na, ləvoŋ, hərwi tə gawa na, wu neheye lele bay aye hay. ");
INSERT INTO meq_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kwa way kə ge mənese na, a ma nay ɗəre a dzaydzay. Ma həndzəɗiye ta təv i dzaydzay bay, hərwi a say wu ŋgay neheye a gawa lele bay aye na, mâ zəba bay, a dzədzar. ");
INSERT INTO meq_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ane tuk na, ndo nakə a gawa wu lele eye hay aye na, neŋgeye ma zəbiye mə dzaydzay hərwi ada ndo hay tâ ŋgatay a wu neheye lele a ge aye, ada tâ sər ha maa ge məsler mə neŋgeye na, Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ma dəba aye na, Yesu ta gawla ŋgay hay tə lətse ti ye ka dala i Yahuda. Tə ndza mə ɗəma ada ta dzəhuɓawa ndo hay a yam. ");
INSERT INTO meq_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ahəl niye na, Yuhana a dzəhuɓawa ndo hay a yam dərmak. A dzəhuɓawa tay ha ndo hay na, ma gəma i Enon bəse ta gəma i Salim hərwi dəlov andaya haladzay ma təv eye niye. Ndo hay ti yawa naha ka təv ŋgay ada a dzəhuɓawa tay ha a yam. ");
INSERT INTO meq_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ahəl niye na, ta gəs na Yuhana a daŋgay zuk bay. ");
INSERT INTO meq_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pat wuray na, siye i gawla i Yuhana hay ta dazlay a məkəɗe wuway ta ndo i Yahuda wuray ka məbere wu hay ta məndze tsəɗaŋŋa. ");
INSERT INTO meq_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Gawla i Yuhana niye hay ti ye ka təv i Yuhana, ti ye naha tə gwaɗay: «Miter, ndo niye ahəl niye ka dzum gər ma diye i magayam i Yurdum ka tsik faya aye na, faya ma dzəhuɓiye tay ha ndo hay a yam ada ndo hay tebiye faya ta diye ka təv ŋgay tuk na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yuhana a mbəɗatay faya a gwaɗatay: «Taɗə Mbəlom kə vəlay bay na, ndəray ma sliye məhute bay tebiye. ");
INSERT INTO meq_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Bo kurom eye ka slumeye faya məhəle mbəl ga, na gwaɗakum: “Neŋ na, Kəriste bay. Ane tuk na, Mbəlom a sləra ga ahaya, nâ lahayaw kame tsa.” ");
INSERT INTO meq_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ndo nakə a zla dahəlay aye na, dahəlay niye na, i ŋgay ŋgway. Ane tuk na, dzam i zal i dahəlay niye na, ma lətsiye sləp ka tsakay ŋgay ada ma piye zləm ka bazlam ŋgay. Kə tsəne bazlam ŋgay niye faya ma piye faya zləm aye na, ma ŋgwasiye haladzay. Andza niye məŋgwese niye anəke na, i ga haladzay dərmak. ");
INSERT INTO meq_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Neŋgeye na, mâ səkah kame kame, neŋ na, na nəkiɗ. ");
INSERT INTO meq_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Ndo nakə a yaw abəra mə mbəlom aye na, neŋgeye ka gər i ndo hay tebiye. Ndo nakə neŋgeye ka məndzibəra aye na, neŋgeye ndo i məndzibəra ŋgway ada ma tsikiye na, ka wu i məndzibəra hay. Ane tuk na, ndo nakə a yaw abəra ka təv i Mbəlom aye na, neŋgeye ka gər i ndo hay tebiye. ");
INSERT INTO meq_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ma tsikiye na, ka wu nakə a ŋgatay ada a tsəne aye. Ane tuk na, wu nakə a tsik aye na, ndəray ma təmiye bay. ");
INSERT INTO meq_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ndoweye ka təma bazlam ŋgay nakə a tsik aye na, niye na, faya ma ɗiye ha wu nakə Mbəlom a tsik aye na, deɗek. ");
INSERT INTO meq_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ndo nakə Mbəlom a sləraw aye na, faya ma tsikiye na, bazlam i Mbəlom, hərwi Mbəlom kə rah ha ta Məsəfəre ŋgay. ");
INSERT INTO meq_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bəba ŋgay a wuɗa na wawa ŋgay ada kə vəlay mələve i bəy ŋgay. ");
INSERT INTO meq_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ndo nakə kə dzala ha ka Wawa i Mbəlom aye na, ma hutiye sifa nakə ma ndəviye bay aye. Ndo nakə a kərah mədzala ha ka Wawa i Mbəlom aye na, ma hutiye sifa niye təbey. Mevel i Mbəlom ma ta ndziye faya.» ");
INSERT INTO meq_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisa hay tə tsəne, ndo hay tə pay bəzay a Yesu ada a dzəhuɓawa tay ha ndo hay a yam na, haladzay a ze i Yuhana. ");
INSERT INTO meq_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Azlakwa ta deɗek eye na, Yesu a dzəhuɓawa tay ha ndo hay a yam bay. Maa dzəhuɓawa tay ha ndo hay a yam na, gawla ŋgay hay bəna, bo ŋgay eye bay. ");
INSERT INTO meq_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ahəl nakə Yesu a tsəne wu nakə Farisa hay tə tsik faya na, a həl bo abəra ka dala i Yahuda a ye ka dala i Galile. ");
INSERT INTO meq_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tsəveɗ mede a Galile na, ta dala i Samari. ");
INSERT INTO meq_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ahəl nakə faya ma diye na, a ndisl a təv aye andaya ka dala i Samari tə zalay Sikar. Təv niye na, bəse ta guvah nakə Zakob a vəlay a wawa ŋgay Yusufa ahəl niye aye. ");
INSERT INTO meq_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ada bəɗiyem nakə Zakob a la ahəl niye andaya ka təv aye niye. Yesu a ndisl ka bəɗiyem niye na, ki ye gər, a ndza ka tsakay i bəɗiyem niye. Məndisle nakə Yesu a ndisl naha ka təv aye niye na, ma giye magərhəpat. ");
INSERT INTO meq_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ahəl nakə gawla i Yesu hay ti ye mata səkəmaw wu mənday mə walaŋ gay na, ŋgwas i Samari wuray a ye naha mata təɗe yam. A yaw na, Yesu a gwaɗay: «Təɗəŋew yam nâ sa tey.» ");
INSERT INTO meq_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ŋgwas i Samari niye a gwaɗay a Yesu: «Na gwaɗ nəkar na, Yahuda hay bəɗa! Ada ka tsətsahiye yam ka neŋ ŋgwas i Samari na, kəkay?» Ŋgwas niye a tsik andza niye na, hərwi Yahuda hay tə dzawa gər a bo ta Samari hay bay. ");
INSERT INTO meq_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu a mbəɗay faya, a gwaɗay: «Taɗə ka sər wu nakə Mbəlom ma vəliye ada ka sər neŋ nakə na tsətsah fakaya yam aye na, nəkar ɗuh ka tsətsahiye fagaya yam nakə ma vəliye sifa aye ada na vəlakeye.» ");
INSERT INTO meq_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ŋgwas niye a gwaɗay faya: «Bəy ga, wu mətəɗe yam andaya fakaya bay ada bəɗiyem eye na, sɨɗuk tuk na, ka hutiye yam nakə ma vəliye sifa a ndo aye na, ma kəkay? ");
INSERT INTO meq_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Maa lamay bəɗiyem nakay na, bəba təte kway Zakob. Bo ŋgay eye kə sa yam ma bəɗiyem nakay. Wawa ŋgay hay ta gənaw ŋgay hay ta sa yam ma bəɗiyem nakay dərmak. Ada nəkar ka dzala na, ka ze na Zakob ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu a mbəɗay faya, a gwaɗay: «Kwa way kə sa yam nakay na, yam ma geye sa. ");
INSERT INTO meq_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ane tuk na, ndoweye kə sa yam nakə neŋ na vəleye na, ɗaɗa yam ma geye sa bay. Yam nakə na vəleye na, ma təriye andza bəɗiyem nakə a ŋgəz waɗ waɗ aye ada ma vəleye sifa nakə ma ndəviye bay aye.» ");
INSERT INTO meq_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ŋgwas niye a gwaɗay: «Bəy ga, vəleŋ yam eye niye tey hərwi ada yam mâ geŋ sa bay ada nâ yaw ɗaɗa mətəɗe naha yam kanaŋ sa bay.» ");
INSERT INTO meq_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu a gwaɗay: «Do, pəla ahaya zal yak ada kâ yumaw kanaŋ.» ");
INSERT INTO meq_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ŋgwas niye a mbəɗay faya, a gwaɗay: «Zal ga andaya bay.» Yesu a gwaɗay: «Ka gwaɗ zal yak andaya bay na, ka tsik na, deɗek. ");
INSERT INTO meq_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Hərwi zal yak hay na, zlam ada ndo nakə anəke nəkurom mandza eye salamay aye na, zal yak bay. Ka tsik na, deɗek.» ");
INSERT INTO meq_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tsa na, ŋgwas niye a gwaɗay: «Ah! Bəy ga, na sər ha nəkar na, ndo məɗe ha bazlam i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bəba təte may Samari hay tə ɗəslaway ha gər a Mbəlom na, mə gər i gəma nakay. Ane tuk na, nəkurom Yahuda hay na, ka gwaɗum i kurom təv məɗəslay ha gər a Mbəlom na, ma Zerozelem.» ");
INSERT INTO meq_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu a gwaɗay: «Ŋgwas nakay, dzala ha ka wu nakə na tsikakeye, həlay eye ma deyeweye na, ndo hay ta ɗəslay ha gər a Bəba Mbəlom na, mə gər i gəma nakay ɗekɗek kəgəbay ma Zerozelem ɗekɗek tsa bay. ");
INSERT INTO meq_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nəkurom Samari hay ka sərum wu nakə ka ɗəslumay ha gər aye bay. Nəmay Yahuda hay na, nəmaa sər, hərwi Mbəlom a bəzatay ha tsəveɗ i mətəme a ndo hay na, ta Yahuda hay. ");
INSERT INTO meq_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ane tuk na, həlay eye ma deyeweye ɓa həlay eye anaŋ tsɨy, Məsəfəre i Mbəlom ma vəliye gədaŋ a ndo neheye a satay məɗəslay ha gər a Bəba Mbəlom ta deɗek eye na, ta ɗəslay ha gər ta deɗek Mbəlom ma pəliye na, slala i ndo niye hay. ");
INSERT INTO meq_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mbəlom na, məsəfəre. Hərwi niye ndo neheye ta ɗəslay ha gər aye na, tâ ɗəslay ha gər na, ta deɗek ada ta gədaŋ i məsəfəre.» ");
INSERT INTO meq_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ŋgwas niye a gwaɗay: «Na sər ha na, ndo nakə Mbəlom a pay dzagwa i bəy a gər aye ma deyeweye (andza məgweɗe Kəriste). Aza ki yaw na, ma ɗakway ha wu hay tebiye.» ");
INSERT INTO meq_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu a mbəɗay faya, a gwaɗay: «Neŋ nakə faya na tsikakeye me anəke, neŋ eye.» ");
INSERT INTO meq_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ahəl nakə Yesu ta ŋgwas niye faya ta tsikiye me na, gawla i Yesu hay tə maw tuk. Tə ŋgatay a Yesu faya ta tsikiye me ta ŋgwas niye na, a gatay hərɓaɓəkka. Ane tuk na, ndəray kwa nəte mə walaŋ tay ka tsətsah ka Yesu, kə gwaɗay: «Ka pəla abəra ka ŋgwas eye mey?» kəgəbay «Ka tsikumeye me ta ŋgwas eye na, hərwi mey?» na, ndəray ka tsətsah faya bay. ");
INSERT INTO meq_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ŋgwas niye a gər ha kalawah ŋgay ka bəɗiyem, a mbəɗa gər a walaŋ gay. A ye naha a gwaɗatay a ndo hay: ");
INSERT INTO meq_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Dumara, zəbum ka ndo wuray anaŋ eye təday, a pesleŋ na wu nakə na gawa ahəl niye aye tebiye. Ma giye na, Kəriste nakə Mbəlom a gwaɗ ma sləraweye aye.» ");
INSERT INTO meq_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ndo hay tə tsəne bazlam i ŋgwas niye a tsikatay aye na, ti yaw abəra mə walaŋ gay, ti yaw ka təv i Yesu. ");
INSERT INTO meq_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ahəl nakə ŋgwas niye a ye a walaŋ gay aye, gawla i Yesu hay nəteye faya ta geye amboh a Yesu mâ nda wu mənday, tə gwaɗay: «Miter may, nda wu mənday!» ");
INSERT INTO meq_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ane tuk na, Yesu a mbəɗatay faya a gwaɗatay: «Wu mənday ga andaya nakə na ndiye, nəkurom ka sərum bay.» ");
INSERT INTO meq_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Gawla ŋgay hay tə tsəne andza niye na, tə tsik mə walaŋ tay, tə gwaɗ: «Ma giye na, ndəray kə zlayaw wu mənday kəla ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu a gwaɗatay: «Wu mənday ga na, məge wu nakə a say a ndo nakə a sləra ga ahaya aye ada mandəve ha məsler nakə a vəleŋ a gweɗeŋ ge aye. Matəra wu mənday ga na, neŋgeye.» ");
INSERT INTO meq_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yesu a gwaɗatay sa: «Dzeke andaya, a gwaɗ: “A ləkaw kiye faɗ na, ta dziye wu mənday abəra ka dala.” Ane tuk na, neŋ ɗuh na gwaɗakumeye: Ehey, zəbum ka guvah hay lele, təday. Wu hay na, ta nah tsɨy. Kə sla mədze. ");
INSERT INTO meq_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ndo nakə ma dziye na wu mənday abəra ka dala aye na, ma hutiye merəɓe ŋgay ada ma hayay gər a wu mənday niye. Wu mənday na, andza məgweɗe ndo neheye ta huta sifa nakə ma ndəviye bay ka tor aye. Andza niye ndo masləge ta ndo mədze wu abəra ka dala na, ta ŋgwasiye salamay. ");
INSERT INTO meq_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Hərwi dzeke nakə a gwaɗ: “Ndo neŋgeɗ ma sləgiye, ndo neŋgeɗ na, ma dziye na abəra ka dala”, a tsik na, deɗek. ");
INSERT INTO meq_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na slər kurom a guvah mata dze na wu mənday nakə ka fətumay bay aye, ka təmumay a həlay a ndo hay tsa.» ");
INSERT INTO meq_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ndo i dala i Samari niye hay haladzay tə dzala ha ka Yesu. Tə dzala ha na, hərwi ŋgwas niye a ɗatay ha parakka a gwaɗatay: «A pesleŋ wu nakə na gawa ahəl niye tebiye.» ");
INSERT INTO meq_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samari niye hay tə ndisl naha ka təv i Yesu na, ta tsətsah ka Yesu, tə gwaɗay: «Ndza ka təv may tey.» Yesu a təma bazlam tay niye, a ndza ka təv tay məhəne sulo. ");
INSERT INTO meq_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yesu a tsikawatay bazlam i Mbəlom. Tə tsəne na, ndo siye hay haladzay tə dzala ha ka Yesu sa. ");
INSERT INTO meq_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ndo niye hay tə gwaɗay a ŋgwas niye: «Anəke nəmaa dzala ka Yesu na, hərwi wu nakə ka təkəramay aye sa bay. Nəmaa dzala ha na, hərwi nakə nəmaa tsəne wu nakə bo ŋgay eye a tsik aye. Ada nəmaa sər ha neŋgeye na, ndo mətəme ha ndo i məndzibəra hay deɗek.» ");
INSERT INTO meq_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu a ndza ka təv niye məhəne sulo na, a həl bo a ye abəra ka təv niye, a ye a Galile. ");
INSERT INTO meq_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Bo i Yesu eye a tsik, tə gər ŋgay, a gwaɗ: «Ndo məɗe ha bazlam i Mbəlom na, ta rəhay ha gər ma gəma ŋgay bay.» ");
INSERT INTO meq_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Azlakwa ɗuh Yesu a ndisl a Galile na, ndo i dala niye hay ta təma na lele tə məŋgwese eye hərwi nəteye dərmak ta ye a magurlom i Pak niye ma Zerozelem aye ada a həlay i magurlom niye na, ta ŋgatay a wu nakə Yesu a ge aye. ");
INSERT INTO meq_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Andza niye, Yesu a mbəɗa gər a Kana ka dala i Galile sa, gəma nakə a təra ha yam guzom eye. Ndo məge məsler i bəy bagwar eye wuray andaya, wawa ŋgay ɗəvats eye ma gəma i Kafernahum. ");
INSERT INTO meq_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","A tsəne Yesu kə maw abəra ma Yahuda neŋgeye ka dala i Galile na, a həl bo a ye ka təv i Yesu. A ye naha a gay amboh a Yesu, a gwaɗay: «Amboh tama a Kafernahum, ta mbəleŋ ahaya wawa ga andaya ɗəvats eye faya ma mətiye tey.» ");
INSERT INTO meq_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu a gwaɗay: «Nəkurom na, taɗə na ge masuwayaŋ eye bay na, ka dzalumeye ha bay na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ndo məge məsler niye a mbəɗay faya, a gwaɗay: «Bəy ga, tama bəse bəna wawa ga ma ta mətiye.» ");
INSERT INTO meq_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu a gwaɗay: «Mbəɗa gər a mətagay, wawa yak ma mbəliye.» Ndo niye a dzala ha ka bazlam i Yesu niye a tsikay aye. A ma a mətagay. ");
INSERT INTO meq_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ahəl nakə ndo niye faya ma diye a mətagay, neŋgeye ka tsəveɗ mba na, ndo i məsler ŋgay hay ti yaw, tə ŋgəlayaw gər həf ka tsəveɗ tə gwaɗay: «Wawa yak kə mbəl!» ");
INSERT INTO meq_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","A tsətsah fataya, a gwaɗatay: «Wuye a gay ŋgama na, kəɗay?» Ta mbəɗay faya, tə gwaɗay: «A gay ŋgama na, məveneŋ ta ɓəre nəte i huwa.» ");
INSERT INTO meq_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","A sər ha həlay niye na, tits həlay nakə Yesu a gwaɗay: «Wawa yak ma mbəliye» aye. Tsa na, neŋgeye ta ndo i gay ŋgay hay tebiye tə dzala ha ka Yesu. ");
INSERT INTO meq_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nakay na, masuwayaŋ masulo eye nakə a ge ma Galile aye. A ge na, ahəl nakə a maw abəra ma Yahuda aye. ");
INSERT INTO meq_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ma dəba eye na, magurlom i Yahuda hay andaya ma Zerozelem. Hərwi niye, Yesu a ye a magurlom i Yahuda niye hay ma Zerozelem aye. ");
INSERT INTO meq_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ma Zerozelem niye na, dəlov wuray andaya bəse ta Məgeɗ i Təɓaŋ hay nakə ti yawa tay ha tə ɗəma a walaŋ gay aye. Tə zalay a dəlov eye niye tə bazlam i Yahuda hay na, Baytidzata. Ka tsakay i dəlov niye na, galak andaya maŋgəna eye zlam. ");
INSERT INTO meq_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ndo i ɗəvats hay haladzay tə hənawa mə ɗəma: Guluf hay, ndo matəra eye, ndo neheye sik tay maməta eye hay. Ta həbawa yam nakə ma ɓəliye wekit wekit aye. ");
INSERT INTO meq_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Hərwi həlay eye andaya gawla i Mbəlom a mbəzlawaw, a ɓəlawa ha. Kə ɓəl ha na, ndo nakə kə lah kurre məkal ha bo a yam niye gawla i Mbəlom a ɓəl ha aye na, kə mbəl abəra ma ɗəvats ŋgay. Kwa ɗəvats eye na, kəkay kəkay, ma mbəliye. ");
INSERT INTO meq_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mə walaŋ i ndo i ɗəvats niye hay na, ndoweye andaya kə ndza ma ɗəvats məve kuro kuro mahkar gər eye tsamahkar. ");
INSERT INTO meq_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu a ndisl a təv i ndo i ɗəvats niye hay na, a ŋgatay a ndo niye mahəna eye ada a tsəne na, ndo niye kə ndza ma ɗəvats məve haladzay. A tsətsah faya, a gwaɗay: «A saka məmbəle ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ndo niye ɗəvats eye a gwaɗay: «Ahəl nakə yam faya ma ɓəliye na, ndəray andaya məzle ga, məkele ga ha a ɗəma bay. Na gwaɗ na dziye faya bo məkele ha bo a ɗəma na, ndo mekeleŋ eye a leheŋ a ɗəma.» ");
INSERT INTO meq_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu a tsəne andza niye na, a gwaɗay: «Lətse, zla təv məhəne yak, do wu yak!» ");
INSERT INTO meq_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kwayaŋŋa ndo niye a mbəl. A zla təv məhəne ŋgay ada a pa bo ka mede. Azlakwa bay, wu niye a ge bo na, pat i mazəzukw bo. ");
INSERT INTO meq_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Bəy i Yahuda hay tə ŋgatay a ndo niye a mbəl eye faya ma zliye təv məhəne na, tə gwaɗay: «Bəgom na, pat i mazəzukw bo sa na, tsəveɗ andaya məzle hubok pat i mazəzukwe bay.» ");
INSERT INTO meq_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","A mbəɗatay faya, a gwaɗatay: «Ndo nakə a mbəl ga ha aye, a gweɗeŋ: “Zla təv məhəne yak do wu yak.”» ");
INSERT INTO meq_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ndo niye hay ta tsətsah faya: «Ndoweye i ŋgay way nakə ma gwaɗakeye: “Zla təv məhəne yak ada kâ ye ha” pat i mazəzukw bo na, way?» ");
INSERT INTO meq_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ane tuk na, ndo niye a sər ndo nakə a mbəl ha aye bay, hərwi Yesu ki ye ŋgway abəra ka təv niye, kə gər tay ha ndo niye hay haladzay aye. ");
INSERT INTO meq_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ma dəba aye na, Yesu tə dza gər ta ndo nakə a mbəl ha aye mə gay i məɗəslay ha gər a Mbəlom, a gwaɗay: «Anəke na, ka mbəl tuk. Kâ ge mənese sa bay. Ka ge mənese na, wu ma ta gakeye ma ziye nakə a gaka aye.» ");
INSERT INTO meq_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ma dəba eye ndo niye a ye, a gwaɗatay a bəy i Yahuda hay: «Maa mbəl ga ha na, Yesu.» ");
INSERT INTO meq_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tsa na, bəy i Yahuda niye hay ta dazlay məgay seweɗ a Yesu hərwi nakə a mbəl ha ndo pat i mazəzukw bo aye. ");
INSERT INTO meq_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ane tuk na, Yesu a mbəɗatay faya, a gwaɗatay: «Bəba ga faya ma giye məsler na, pat pat ada neŋ na giye andza niye dərmak.» ");
INSERT INTO meq_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Bəy i Yahuda hay tə tsəne bazlam i Yesu niye na, ta səkah ha mapəle tsəveɗ məkəɗe na. A satay məkəɗe na Yesu na, hərwi a rəhay ha gər a pat i mazəzukw bo bay, ɗekɗek bay. Ane tuk na, hərwi nakə a gwaɗ Mbəlom na, bəba ŋgay aye. Andza məgweɗe a ləva ha gər ŋgay ta Mbəlom. ");
INSERT INTO meq_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu a mbəɗatay faya, a gwaɗatay: «Sərum ha na, neŋ na sliye faya ka məge wu tə həlay ga aye tsa bay. Na giye na, wu nakə na ŋgatay Bəba ga a gawa aye. Wu nakə Bəba ga a gawa aye na, neŋ wawa ŋgay na giye dərmak. ");
INSERT INTO meq_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Bəba ga a wuɗa neŋ wawa ŋgay, ada ma ɗeŋeye ha wu nakə a gawa aye tebiye. Ma ɗeŋeye ha məsler bagwar eye sa a ze wu neheye ada aza ma gakumeye hərɓaɓəkka. ");
INSERT INTO meq_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","«Andza nakə Bəba Mbəlom a mbəl ha ndo hay abəra ma mədahaŋ ada faya ma vəlateye sifa aye na, andza niye neŋ wawa ŋgay na vəliye sifa a ndo neheye a seŋ aye. ");
INSERT INTO meq_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","«Ada sa na, Bəba ma giye sariya tə həlay ŋgay aye bay. Kə vəleŋ gədaŋ a həlay ga ka məge sariya. ");
INSERT INTO meq_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","A ge ha andza niye na, hərwi ada ndo hay tebiye tâ ɗəsleŋ ha gər andza nakə ndo hay faya ta ɗəslay ha gər a neŋgeye Bəba Mbəlom aye. Taɗə ndoweye kə ɗəsleŋ ha gər a neŋ wawa ŋgay bay na, kə ɗəslay ha gər a Bəba ga nakə a sləra ga ahaya bay dərmak.» ");
INSERT INTO meq_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Yesu a gwaɗatay sa: «Sərum ha na, ndoweye kə pay zləm a bazlam ga neheye na tsik aye ada kə dzala ha ka Mbəlom nakə a sləra ga ahaya aye na, kə huta sifa nakə ma ndəviye bay aye. Mbəlom ma ta geye sariya bay. Neŋgeye na, ɓa ki ye abəra ka tsəveɗ i məməte. Ka dazlay a məndze ma sifa nakə ka tor eye. ");
INSERT INTO meq_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","«Ayaw! Sərum ha na, pat eye ma deyeweye, ɓa ɗuh pat eye anaŋ ki yaw tsɨy, ahəl nakə ndo neheye nəteye andza mədahaŋ hay ta tsəniye wu nakə Wawa i Mbəlom a tsik aye. Ndo neheye ta pay zləm ada ta dzala ha ka wu nakə na tsik aye na, ta mbəliye. ");
INSERT INTO meq_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mbəlom na, gədaŋ ŋgay andaya ma vəliye sifa a ndo. Andza niye kə vəleŋ gədaŋ a neŋ wawa ŋgay ma vəliye sifa a ndo dərmak. ");
INSERT INTO meq_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ada kə vəleŋ gədaŋ a neŋ wawa ŋgay məge sariya ka ndo hay. A vəleŋ gədaŋ məge sariya ka ndo hay na, hərwi neŋ Wawa i Ndo. ");
INSERT INTO meq_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","«Mâ gakum masuwayaŋ bay, hərwi pat eye ma deyeweye na, mədahaŋ neheye ma bəɗ ta tsəniye bəɗiɗay ga. ");
INSERT INTO meq_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ta tsəne na, ta lətseweye abəra ma mədahaŋ. Ndo neheye ahəl niye tə gawa wu ŋgwalak eye na, ta lətseweye abəra ma mədahaŋ, ta hutiye sifa nakə ma ndəviye bay aye. Ada ndo neheye tə gawa wu ŋgwalak eye bay aye na, ta lətseweye abəra ma mədahaŋ i tay na, ta gəsiye tay a sariya. ");
INSERT INTO meq_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Neŋ na, na sliye faya məge wuray ka gər bo ga bay. Na giye sariya na, andza nakə Mbəlom a tsikeŋ aye ada sariya ga nakə na giye na, deɗek hərwi na pəla na, wu nakə a yeŋ a gər a neŋ eye bay. Ane tuk na, na giye na, wu nakə a yay a gər a ndo nakə a sləra ga ahaya aye.» ");
INSERT INTO meq_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yesu a gwaɗatay sa: «Taɗə na ta mbal i gər ga na, ndo hay ta gwaɗiye deɗek bay.» ");
INSERT INTO meq_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ane tuk na, mata həle mbal i gər ga na, ndo mekeleŋ eye ada na sər ha ndo məhəle mbal ga na, ma həliye, ta deɗek. ");
INSERT INTO meq_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ka slərum ndo hay ka təv i Yuhana ada kə tsikakum wu nakə deɗek eye. ");
INSERT INTO meq_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Neŋ na, na pa gər ka məhəle mbal i ndo təbey. Ɗuh na tsikakum andza niye na, hərwi ada kâ hutum mətəme. ");
INSERT INTO meq_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ahəl niye, Yuhana na, a təra andza lalam nakə ta piye faya ako hərwi ada mâ ɗakum ha deɗek aye. Ma məndze tsakway na, ka təmum bazlam ŋgay ada ka ŋgwasum hərwi dzaydzay ŋgay niye. ");
INSERT INTO meq_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","«Ane tuk na, i ga na, wu mekeleŋ eye neheye a ze bazlam i Yuhana nakə a tsik ta həliye mbal i gər ga aye na, anaŋ. Neŋ faya na tsikiye ka məsler nakə Bəba ga a vəleŋ a gweɗeŋ “ge” aye. Wu neheye faya ta bəziye ha masləra ga ahaya na, Mbəlom deɗek. ");
INSERT INTO meq_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","«Ada Bəba ga nakə a sləra ga ahaya na, ma həliye mbal ga. Ane tuk na, ka tsənum bəɗiɗay ŋgay ɗaɗa bay ada ka ŋgatumay ɗaɗa bay. ");
INSERT INTO meq_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ka təmum bazlam ŋgay hay, ta ndza mə ɗərev kurom bay hərwi ka dzalum ha ka neŋ wawa ŋgay nakə a sləraw aye bay. ");
INSERT INTO meq_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","«Ada nəkurom na, faya ka dzaŋgumeye Ɗerewel i Mbəlom pat pat hərwi ka pum mədzal gər kurom na, ka gwaɗum ka hutumeye mə ɗəma sifa nakə ma ndəviye bay aye. Bazlam i Mbəlom neheye tə həl mbal na, i gər ga. ");
INSERT INTO meq_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Azlakwa ɗuh a sakum madayaw ka təv ga məhute sifa nakə deɗek aye bay na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Yesu a gwaɗatay: «Ka dzalum na, a seŋ ndo hay tâ zembeɗeŋ ɗaw? Aʼay! Neŋ na, mədzal gər ga a ye ka mazembeɗe nakə ndo hay ta zambaɗawatay a siye i ndo hay aye təbey. ");
INSERT INTO meq_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ane tuk na, nəkurom na, andza neŋ təbey. Na sər ha ta deɗek, ka wuɗum Mbəlom bay. ");
INSERT INTO meq_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na yaw na, maa sləra ga ahaya na, Bəba ga Mbəlom ada ka wuɗum matəme ga bay. Ane tuk na, taɗə ndo mekeleŋ eye mâ yaw ta gədaŋ ŋgay na, ka təmumeye na. ");
INSERT INTO meq_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","A sakum na, ndo hay tâ zambaɗakum. Ɗuh Mbəlom nakə deɗek eye na, ka wuɗum mazambaɗay bay. Ada taɗə nəkurom andza niye deɗek na, ka dzalumeye ha fagaya ma kəkay? ");
INSERT INTO meq_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","«Ane tuk na, kâ dzalum na, na ta makumeye ha mənese kame i Bəba ga bay. Mata makum ha mənese na, Musa neŋgeye nakə ka pum faya mədzal gər kurom aye. ");
INSERT INTO meq_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Taɗə ka dzalum ha ka Musa ta deɗek na, haɓe ka dzalum ha ka neŋ, hərwi Musa a watsa na, ka neŋ. ");
INSERT INTO meq_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Taɗə ka dzalum ha ka wu nakə Musa a watsa aye bay na, ka dzalumeye ka wu nakə faya na tsikiye na, ma kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ma dəba aye na, Yesu a lətse, a ye a tas a diye i dəlov i Galile. Dəlov niye na, tə zalay dəlov i Tiber dərmak. ");
INSERT INTO meq_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ndo hay haladzay tə paway bəzay. Tə paway bəzay na, hərwi nakə tə ŋgataway a masuwayaŋ neheye a gawa aye. Masuwayaŋ niye a gawa aye na, a mbəlawa tay ha ndo i ɗəvats hay. ");
INSERT INTO meq_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu ta gawla ŋgay hay tə tsal a mahəmba, ti ye tə ndza mə ɗəma. ");
INSERT INTO meq_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Magurlom i Yahuda hay nakə tə zalay Pak aye na, mazlambar kə ndzew. ");
INSERT INTO meq_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu a zəba ɗəre na, a ŋgatay a ndo hay haladzay ta diye naha ka təv ŋgay. Tsa na, a tsətsah ka Filip, a gwaɗay: «Ka hutakwaweye məsəkəmaw wu mənday ɗa məvəlatay a ndo neheye tebiye na, məŋgay?» ");
INSERT INTO meq_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu a tsikay a Filip andza niye na, mazəbe ka mədzal gər i Filip. Hərwi Yesu na, a sər wu nakə ma giye. ");
INSERT INTO meq_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip a mbəɗay faya a gwaɗay: «Kwa taɗə ka səkəmakwaw wu mənday ta dinar sulo, kwa way ada mâ huta tsekweŋ tsekweŋ bəbay na, ma slateye bay.» ");
INSERT INTO meq_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ndo mekeleŋ eye mə walaŋ i gawla ŋgay hay, məzele ŋgay Aŋdəre malamar i Simoŋ Piyer, a gwaɗay: ");
INSERT INTO meq_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Wawa wuray anaŋ kanaŋ na, tapa i makwala andaya faya zlam tə kəlef hay sulo. Ane tuk na, hərwi ndo neheye haladzay aye na, ma sliye mey?» ");
INSERT INTO meq_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tsa na, Yesu a gwaɗatay a gawla ŋgay hay: «Dum gwaɗumatay a ndo hay tâ ndza tebiye ka dala.» Ka təv eye niye na, guzer andaya haladzay beremeffe a ndzohwaw mba. Gawla ŋgay hay ti ye, tə gwaɗatay a ndo hay, ndzum ka dala. Ndo niye hay tebiye tə ndza ka dala. Hasləka hay ɗekɗek ta giye gwezem zlam. ");
INSERT INTO meq_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ndo niye hay tebiye tə ndza na, Yesu a zla makwala niye, a gay naha sɨsœ a Mbəlom, a ŋgəna ha. A ŋgəna ha na, a vəlatay a ndo niye hay mandza eye. A həl kəlef niye hay, a ge ha andza niye sa. Tə nda makwala niye tə kəlef aye ka mərehe tay. ");
INSERT INTO meq_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tə nda makwala niye tə rah lele na, Yesu a gwaɗatay a gawla ŋgay hay: «Hayumay gər a siye nakə a zaw aye kwa tsekweŋ mâ dze bay.» ");
INSERT INTO meq_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tsa na, tə hayay gər a makwala nakə a zaw abəra ka ndo neheye tə nda aye. Tə hayay gər na, a rah a gwaŋ kuro gər eye sulo. ");
INSERT INTO meq_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ndo hay tə ŋgatay a masuwayaŋ niye Yesu a ge nakə a bəz ha gədaŋ i Yesu aye na, tə gwaɗ: «Ndo nakay na, ndo məɗe ha bazlam i Mbəlom deɗek. Neŋgeye na, ndo məɗe ha bazlam i Mbəlom nakə tə tsik faya ahəl niye tə gwaɗ ma deyeweye ka məndzibəra aye.» ");
INSERT INTO meq_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu a sər ha ndo niye hay ta deyeweye ta piye na a bəy ta gədaŋ na, a mbəɗa gər, a tsal ŋgway a tsaholok niye sa. A tsal na, mahəŋgeye. ");
INSERT INTO meq_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Huwa a ge na, gawla i Yesu hay tə mbəzla ka me i dəlov. ");
INSERT INTO meq_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ti ye naha na, tə tsal a kwalalaŋ i yam, ta dazlay mətese a diye neŋgeɗ mede a gəma i Kafernahum. Ahəl nakə faya ta diye na, həvaɗ kə ge fataya tsɨy, ada Yesu kə husa ka təv tay zuk bay. ");
INSERT INTO meq_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Dəlov niye a dazlay məɓəle haladzay wekit wekit hərwi mətasl a ge ta gədaŋ. ");
INSERT INTO meq_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ta ye ma giye kilomiter zlam kəgəbay məkwa na, tə ŋgatay a Yesu faya ma diye naha ka təv i kwalalaŋ yam tay, ka gər i yam tə sik. Tə ŋgatay na, ta dzədzar haladzay. ");
INSERT INTO meq_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ane tuk na, Yesu a gwaɗatay: «Kâ dzədzarum bay. Nakay na, neŋ!» ");
INSERT INTO meq_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Gawla ŋgay hay a satay məgəsay naha mə həlay a kwalalaŋ i yam. Kwayaŋŋa kwalalaŋ i yam niye a husa dənuts ka me i dəlov ka dala, ka təv nakə a satay mede a ɗəma aye. ");
INSERT INTO meq_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tədœ eye na, ndo niye hay haladzay eye tə ze naha ma diye i dəlov niye ta pəla Yesu. Ta sər ha na, kwalalaŋ i yam ka təv eye niye na, nəte. Tə sər ha na, Yesu kə tsal a kwalalaŋ i yam niye bay. Ane tuk na, gawla ŋgay hay ti ye na, mahətay eye. ");
INSERT INTO meq_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Siye i ndo hay ti yaw tə kwalalaŋ i yam tay hay abəra ma gəma i Tiber, tə ndislew tə ndzay a gər a ndo hay ka me i dəlov niye bəse ta təv nakə ndo hay tə nda wu mənday mə ɗəma aye, wu mənday nakə Yesu a zla a gay naha sɨsœ a Mbəlom ada a vəlatay a ndo niye hay aye. ");
INSERT INTO meq_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ndo hay ta zəba ɗəre na, Yesu andaya bay ada gawla ŋgay hay bəbay nəteye andaya ka təv niye bay na, tə tsal a kwalalaŋ i yam niye hay, ti ye a Kafernahum mata pəle na Yesu. ");
INSERT INTO meq_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ti ye tə huta na Yesu ka me i dəlov niye ta diye neŋgeɗ. Ti ye tə gwaɗay: «Miter, ka ndislew kanaŋ na, sa kəɗay?» ");
INSERT INTO meq_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu a mbəɗatay faya, a gwaɗatay: «Ayaw! Sərum ha na, ka pəlum ga na, hərwi nakə ka ndayum wu mənday ka rahum ɓəh ɓəh lele aye bəna, hərwi nakə ka tsənum masuwayaŋ nakə na giye a say məgweɗe mey na, ka tsənum bay. ");
INSERT INTO meq_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kâ gum məsler hərwi wu mənday nakə ma nasiye aye bay. Ɗuh gum məsler na, hərwi wu mənday nakə ma nasiye bay ma ndziye huya ada ma vəliye sifa nakə ma ndəviye bay ka tor eye. Wu mənday niye na, neŋ Wawa i Ndo na vəlakumeye. Na vəlakumeye na, hərwi Bəba Mbəlom kə vəleŋ gədaŋ ka məge.» ");
INSERT INTO meq_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ta tsətsah faya tə gwaɗay: «Nəmaa giye na, məsler waray nakə ma deyeye a gər a Mbəlom aye?» ");
INSERT INTO meq_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu a mbəɗatay faya, a gwaɗatay: «Məsler nakə a yay a gər a Mbəlom ka gumeye na, dzalum ha ka neŋ ndo nakə a sləra ga ahaya aye.» ");
INSERT INTO meq_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tə gwaɗay: «Kə ge andza niye na, nəmaa ta dzaliye ha fakaya na, ka bəzamay ha masuwayaŋ waray? Kəgəbay ka giye na, məsler waray? ");
INSERT INTO meq_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Hərwi ahəl niye bəba təte kway hay ti yaw abəra mə Ezipt, nəteye mə makulkwandah na, tə nda wu mənday nakə a yaw mə mbəlom tə zalay man aye. Andza nakə tə watsa mə Ɗerewel i Mbəlom aye na, tə gwaɗ: “Mbəlom kə vəlatay wu mənday nakə a yaw mə Mbəlom aye, tə nda.”» ");
INSERT INTO meq_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu a mbəɗatay faya, a gwaɗatay: «Sərum ha na, wu mənday nakə ahəl niye Musa a vəlakum mə makulkwandah aye na, wu mənday nakə a yaw abəra mə mbəlom aye ta deɗek bay. Ane tuk na, wu mənday nakə bəba ga Mbəlom ma vəlakumaweye abəra mə mbəlom aye na, nakə ta deɗek aye. ");
INSERT INTO meq_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Hərwi wu mənday niye Mbəlom ma vəlakumeye na, neŋ ndo nakə na mbəzlaw abəra mə mbəlom aye, ada wu mənday niye na, ma vəlateye sifa a ndo i məndzibəra hay.» ");
INSERT INTO meq_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tə gwaɗay: «Bəy may, vəlamay wu mənday niye huya tey.» ");
INSERT INTO meq_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu a tsikatay parakka, a gwaɗatay: «Wu mənday nakə ma vəliye sifa a ndo hay aye na, neŋ. Ndoweye ki yaw ka təv ga ada kə dzala ha ka neŋ na, may ma wuriye faya ɗaɗa bay, yam ma geye ɗaɗa sa bay. ");
INSERT INTO meq_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ane tuk na, ɓa na tsikakum ka ŋgatumeŋ ada ka dzalum ga ha wal bay. ");
INSERT INTO meq_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ndo neheye Bəba ga a vəleŋ tay ha aye na, ta deyeweye ka təv ga. Ada ndo nakə ki yaw ka təv ga aye na, ɗaɗa na kaliye ha bay. ");
INSERT INTO meq_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Hərwi na mbəzlaw abəra mə mbəlom na, ka məge wu nakə a yeŋ a gər a neŋ aye bay, ane tuk na, məge məsler nakə a yay a gər a ndo nakə a sləra ga ahaya aye. ");
INSERT INTO meq_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Məsler nakə a say a ndo nakə a sləra ga ahaya aye na, waray? Ndo neheye a vəleŋ tay ha a həlay aye na, kwa nəte na dziye tay ha bay tebiye. Ane tuk na, na ta mbəliye tay ha abəra ma mədahaŋ pat i sariya. ");
INSERT INTO meq_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Wu nakə a say a Bəba ga na, anaŋ: Ndo neheye ta zəba ka neŋ wawa ŋgay ada ta dzala ha fagaya aye na, tâ huta sifa nakə ma ndəviye bay ka tor eye. Pat i sariya na, neŋ na ta mbəliye tay ha abəra ma mədahaŋ.» ");
INSERT INTO meq_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yahuda niye hay ta dazlay məse bazlam ka Yesu, hərwi nakə a gwaɗatay: «Neŋ na, wu mənday nakə a mbəzlaw abəra mə mbəlom aye.» ");
INSERT INTO meq_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tə gwaɗ: «Na gwaɗ Yesu neŋgeye na, wawa i Yusufa bəɗaw? Ka sərakwa bəba ŋgay ta may ŋgay lele tuk na, ada ma sliye faya anəke məgweɗe neŋgeye na, a mbəzlaw abəra mə mbəlom na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu a mbəɗatay faya, a gwaɗatay: «Gərum ha məse fagaya bazlam mə walaŋ kurom! ");
INSERT INTO meq_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Taɗə Bəba ga ki ye ahaya ndoweye ka təv ga bay na, ma sliye faya madayaw ka təv ga bay. Bəba ga nakə a sləra ga ahaya aye ki ye ahaya ndoweye ka təv ga na, neŋ na ta mbəliye ha abəra ma mədahaŋ pat i sariya. ");
INSERT INTO meq_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ahəl niye ndo məɗe ha bazlam i Mbəlom hay tə watsa mə Ɗerewel i Mbəlom, tə gwaɗ: “Mbəlom neŋgeye ma ta ɗatay ha bazlam ŋgay a ndo hay.” Ndoweye kə tsəne bazlam i Mbəlom Bəba ga ada ka tətik na, ma deyeweye ka təv ga. ");
INSERT INTO meq_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Azlakwa andza məgweɗe ndəray ɗaɗa kə ŋgatay a Bəba ga bay, maa ŋgatay na, neŋ ndo nakə na yaw abəra ka təv ŋgay aye nəte ŋgweŋ. ");
INSERT INTO meq_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","«Sərum ha na, ndo nakə kə dzala ha ka neŋ aye na, kə huta sifa nakə ma ndəviye bay ka tor eye. ");
INSERT INTO meq_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Neŋ na, wu mənday nakə ma vəliye sifa a ndo hay aye. ");
INSERT INTO meq_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ahəl niye na, bəba təte kurom hay tə nda wu mənday nakə tə zalay man aye mə makulkwandah, ada huya tə mət ŋgway. ");
INSERT INTO meq_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ane tuk na, ndoweye kə nda wu mənday nakə a yaw abəra mə mbəlom aye na, ma ta mətiye bay. ");
INSERT INTO meq_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Neŋ na, wu mənday nakə ma vəliye sifa, a mbəzlaw abəra mə mbəlom aye. Ndoweye kə nda wu mənday nakay na, ma mətiye bay, ma ndziye ka tor eye. Wu mənday nakə na vəliye na, bo ga. Na vəliye na, hərwi ada ndo i məndzibəra hay tâ huta sifa.» ");
INSERT INTO meq_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yahuda hay tə kəɗ faya wuway mə walaŋ tay haladzay hərwi bazlam i Yesu niye a tsik aye. Ta tsətsah tə gwaɗ: «Ndo nakay ma vəlakweye bo ŋgay ada ka ndayakweye na, ma kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu a gwaɗatay: «Ayaw! Sərum ha na, taɗə ka ndayum bo ga, neŋ Wawa i Ndo, bay ada ka sum bambaz ga bay na, ka hutum sifa bay. ");
INSERT INTO meq_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ndoweye kə nda bo ga ada kə sa bambaz ga na, kə huta sifa nakə ma ndəviye bay aye ada pat i sariya na, na ta mbəliye ha abəra ma mədahaŋ. ");
INSERT INTO meq_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Hərwi bo ga na, wu mənday nakə deɗek aye ada bambaz ga na, wu məse nakə deɗek aye. ");
INSERT INTO meq_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ndoweye ma ndiye bo ga ada ma siye bambaz ga na, ma ndziye huya mə neŋ ada neŋ na ndziye mə neŋgeye. ");
INSERT INTO meq_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bəba ga nakə a sləra ga ahaya na, neŋgeye ma ndziye huya ada neŋ na ndziye huya na, hərwi neŋgeye. Andza niye ndoweye kə nda bo ga na, neŋgeye dərmak ma ndziye huya hərwi neŋ. ");
INSERT INTO meq_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","«Wu mənday nakə a mbəzlaw mə mbəlom aye na, anaŋ: Neŋgeye andza nakə bəba təte kurom hay tə nda ahəl niye mə makulkwandah aye təbey. Tə nda wu mənday niye na, huya tə mət ŋgway. Ane tuk na, ndoweye kə nda wu mənday nakay na, ma ndziye ka tor eye.» ");
INSERT INTO meq_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu a tsik bazlam neheye na, ahəl nakə neŋgeye faya ma tətikateye a ndo hay mə gay i maɗuwule me ma gəma i Kafernahum aye. ");
INSERT INTO meq_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Gawla i Yesu niye hay tə tsəne bazlam i Yesu niye a tsik aye na, siye hay haladzay mə walaŋ tay tə gwaɗ: «Bazlam nakay na, mawura bo eye. Mata mbe faya məpay zləm na, way?» ");
INSERT INTO meq_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu a səratay naha faya ka wu nakə faya ta tsikiye ka gər ŋgay aye. Hərwi niye a gwaɗatay: «Bazlam ga nakə na tsik aye na, a ndalakum ɗaw? ");
INSERT INTO meq_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Taɗə ka ŋgatumay a neŋ Wawa i Ndo faya na tsaliye a təv ga nakə na mbəzlaw abəra mə ɗəma aye na, ada ka gwaɗumeye kəkay? ");
INSERT INTO meq_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mata vəle sifa a ndo hay na, Məsəfəre i Mbəlom. Ndo hay na, ta sliye faya məhute sifa niye ta gədaŋ tay bay. Bazlam neheye na tsikakum aye maa vəleŋ na, Məsəfəre i Mbəlom ada bazlam neheye ta vəliye sifa a ndo hay aye. ");
INSERT INTO meq_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ane tuk na, siye hay mə walaŋ kurom na, ta dzala ha ka neŋ bay.» Ayaw! Ɓa kwa ka madazlay na, Yesu a sər ha neheye ta dzaliye ha faya bay aye ada a sər ha ndo nakə ma ta giye faya ɗaf aye. ");
INSERT INTO meq_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yesu a gwaɗatay sa: «Hərwi niye na gwaɗakum: Taɗə Bəba ga kə vəlay tsəveɗ bay na, ndəray ma sliye faya madayaw ka təv ga bay.» ");
INSERT INTO meq_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ma dəba eye na, gawla ŋgay hay haladzay tə gər ha ti ye wu tay. Ta pay bəzay sa bay. ");
INSERT INTO meq_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tsa na, Yesu a tsətsah ka ndo i maslaŋ ŋgay hay kuro gər eye sulo, a gwaɗatay: «Nəkurom dərmak a sakum mede wu kurom ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoŋ Piyer a gwaɗay: «Bəy ga, bazlam yak nakə faya ka tsikiye na, ma vəlameye sifa nakə ma ndəviye bay aye. Nəmaa pay bəzay na, a way sa way? ");
INSERT INTO meq_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nəmay nəmaa dzala kar ha ada nəmaa sər ha nəkar na, ndo nakə tsəɗaŋŋa Mbəlom a sləraw aye.» ");
INSERT INTO meq_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu a mbəɗatay faya, a gwaɗatay: «Na gwaɗ mapala kurom kuro gər eye sulo na, neŋ bəɗaw? Ada azlakwa ndo nəte mə walaŋ kurom neŋgeye na, Fakalaw.» ");
INSERT INTO meq_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","A tsik andza niye na, ka Yudas wawa i Simoŋ Iskariyot. Hərwi Yudas na, kwa neŋgeye nəte mə walaŋ i ndo i maslaŋ i Yesu hay kuro gər eye sulo bəbay na, ma ta giye ɗaf ka Yesu na, neŋgeye. ");
INSERT INTO meq_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ma dəba aye na, Yesu a həhal ka dala i Galile tebiye a say mede ka dala i Yuda bay hərwi a satay a bagwar i Yahuda hay məkəɗe na. ");
INSERT INTO meq_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ahəl niye na, magurlom i Yahuda hay nakə tə zalay Magurlom i Madzawadzawa aye kə ndzew mazlambar. ");
INSERT INTO meq_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Hərwi niye malamar ŋgay hay tə gwaɗay: «Do abəra kanaŋ do a dala i Yahuda hərwi ada gawla yak hay nəteye tâ ŋgatay a məsler nakə ka giye dərmak. ");
INSERT INTO meq_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Taɗə a say a ndoweye ndo hay tâ sər na na, ma sliye faya məŋgehe na wu nakə ma giye bay. Faya ka giye məsler neheye andza nakay sa na, ge wu neheye, ada ndo hay tebiye tâ sər kar ha.» ");
INSERT INTO meq_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Malamar ŋgay niye hay tə tsikay andza niye na, kwa bo tay eye bəbay ta dzala ha ka Yesu bay. ");
INSERT INTO meq_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu a gwaɗatay: «I ga na, həlay eye kə slaw zuk bay. Ane tuk na, i kurom na, kwa həlay waray waray, lele tsa. ");
INSERT INTO meq_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nəkurom na, ndo i məndzibəra hay ta sliye faya mənakum ɗəre təbey. Ane tuk na, neŋ na, ta neŋeye ɗəre hərwi na gwaɗawa məsler tay nakə faya ta giye na, lele bay. ");
INSERT INTO meq_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nəkurom eye, dum a magurlom niye. Neŋ na, na diye bay, hərwi ga na, həlay eye kə ndislew zuk bay.» ");
INSERT INTO meq_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","A tsikatay ka bo abəra bazlam niye andza niye na, a ndza ŋgway ma Galile. ");
INSERT INTO meq_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Malamar ŋgay hay ti ye a magurlom i madzawadzawa niye na, Yesu a ye dərmak. A zəŋgal tay naha ma dəba. Ane tuk na, a ndisl naha a ɗəma na, ka bəz ha bo parakka bay. A ŋgaha bo. ");
INSERT INTO meq_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bagwar i Yahuda hay mə magurlom niye, ta pəla na Yesu, ta tsətsah ka ndo hay, tə gwaɗ: «Neŋgeye i ŋgay tebiye na, məŋgay?» ");
INSERT INTO meq_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ndo hay haladzay tə kəɗ faya wuway haladzay. Siye hay tə gwaɗ: «Ndo nakay na, neŋgeye ndo lele eye.» Siye hay tə gwaɗ: «Aʼay! Neŋgeye na, faya ma səpatiye tay ha ndo hay.» ");
INSERT INTO meq_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ane tuk na, ndəray kwa nəte a sla faya mətsike bazlam niye parakka bay hərwi ndo hay tebiye ta dzədzar ta bagwar i Yahuda hay. ");
INSERT INTO meq_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Magurlom niye məzaw ŋgay eye mazlambar ka ndəv na, Yesu a ye a gay i məɗəslay ha gər a Mbəlom. A ye naha a pa bo ka matətikatay a ndo hay. ");
INSERT INTO meq_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Bazlam ŋgay niye faya ma tətikateye a ndo hay aye na, a gatay a bagwar i Yahuda hay hərɓaɓəkka, tə gwaɗ: «Ndo nakay kə dzaŋga bay tuk na, ada a sər wu haladzay na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu a mbəɗatay faya a gwaɗatay: «Bazlam nakay faya na tsikakumeye na, a yaw mə neŋ bay. A yaw mə Mbəlom neŋgeye nakə a sləra ga ahaya aye. ");
INSERT INTO meq_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ndoweye kə say məge wu nakə a yay a gər a Mbəlom aye na, ma səriye bazlam ga nakə na tsik aye a yaw abəra mə Mbəlom kəgəbay a yaw ma mədzal gər ga. ");
INSERT INTO meq_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ndo nakə a tsik bazlam nakə a yaw ma mədzal gər ŋgay aye na, a say ndo hay tâ ɗəslay ha gər. Ane tuk na, ndo nakə faya ma tətikateye a ndo hay hərwi ada ndo hay tâ ɗəslay ha gər a ndo nakə a sləra ahaya na, neŋgeye ndo i deɗek. Neŋgeye na, maraw me andaya mə neŋgeye bay. ");
INSERT INTO meq_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Na gwaɗ maa vəlakum bazlam i Mbəlom mapala eye na, Musa bəɗaw? Ada ndəray kwa nəte mə walaŋ kurom ka rəhay ha gər bay. Ada a sakum məkəɗe ga na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ndo hay ta mbəɗay faya a Yesu, tə gwaɗay: «Nəkar na, fakalaw mə bo yak kəla ɗaw? Mapəla tsəveɗ məkəɗe kar na, way?» ");
INSERT INTO meq_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu a gwaɗatay: «Na ge masuwayaŋ nəte pat i mazəzukw bo na, a gakum hərɓaɓəkka a nəkurom tebiye. ");
INSERT INTO meq_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Sərum ha, Musa kə tsikakum ɗəsum tay ha wawa kurom hay. Maa dazlay məge andza niye na, bəba təte kurom hay bəna Musa bay. Andza niye na, ka ɗəsawum wawa kurom hay pat i mazəzukw bo. ");
INSERT INTO meq_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ka ɗəsum wawa pat i mazəzukw bo na, hərwi ada marəhay gər a bazlam i Mbəlom mapala eye nakə Musa a vəlakum aye. Ada na mbəl ha ndo abəra ma ɗəvats pat i mazəzukw bo ɗuh na, ka gum fagaya mevel na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kâ gum sariya ka ndo tə wu nakə ka ŋgatumay tə ɗəre aye tsa bay. Ɗuh gum na, ta tsəveɗ deɗek eye.» ");
INSERT INTO meq_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Siye i ndo i Zerozelem hay, tə gwaɗ: «Ndo nakə ta pəla məkəɗe na aye na, neŋgeye bəɗaw? ");
INSERT INTO meq_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Zəbum faya tey: Faya ma tsikiye me parakka mə walaŋ i ndo hay tebiye, ada ta gwaɗay wuray kwa tsekweŋ bay tebiye. Ma giye na, bəy kway hay tə sər neŋgeye Kəriste nakə Mbəlom a gwaɗ ma sləraweye kəla ɗaw? ");
INSERT INTO meq_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ane tuk na, ma giye na, andza niye bay bəna Kəriste ma deyeweye na, a yaw məŋgay na, ndəray ma səriye bay. Ndo nakay a yaw məŋgay na, ka sərakwa.» ");
INSERT INTO meq_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Andza niye, Yesu faya ma tətikateye a ndo hay mə gay i məɗəslay ha gər a Mbəlom mba, a tsik me ta magala, a gwaɗ: «Ka sərum ga ha azlakwa ɗaw? Neŋ na yaw məŋgay na, ka sərum ha. Ane tuk na, na yaw na, ka gər bo ga bay. Ndo nakə a sləra ga ahaya na, neŋgeye ndo i deɗek. Nəkurom ka sərum na bay. ");
INSERT INTO meq_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Neŋ na, na sər na hərwi na yaw na, abəra ka təv ŋgay ada maa sləra ga ahaya na, neŋgeye.» ");
INSERT INTO meq_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Andza niye, ta pəla tsəveɗ məgəse na Yesu. Ane tuk na, ndəray kə gəs na bay hərwi həlay ŋgay aye kə ndisl a ɗəma zuk bay. ");
INSERT INTO meq_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ndo hay haladzay tə dzala ha ka Yesu. Tə gwaɗ: «Ndo nakay ma giye na, Kəriste. Ndo mekeleŋ eye ma deyeweye ma giye masuwayaŋ ma ziye i ndo nakay ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisa hay tə tsəne wu neheye ndo hay faya ta tsikiye ka Yesu tə masəsəkwe aye. Nəteye ta bagwar hay i ndo neheye tə vəlaway wu a Mbəlom hay tə haya gər, tə slər sidzew neheye ta tsəpawa gay i məɗəslay ha gər a Mbəlom aye hərwi ada tâ ye, tâ gəsaw Yesu. ");
INSERT INTO meq_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu a ŋgatay andza niye na, a gwaɗ: «Neŋ andaya ka təv kurom ma məndze tsekweŋ mba. Tsa na, na miye gwa ka təv i ndo nakə a sləra ga ahaya aye. ");
INSERT INTO meq_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ka ta pəlumeye ga ada ka ta hutumeye ga bay hərwi ka slumeye faya mede a təv nakə neŋ na diye a ɗəma aye bay.» ");
INSERT INTO meq_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tsa na, Yahuda hay ta tsətsah mə walaŋ tay, tə gwaɗ: «Ma diye na, a ŋgay nakə ada ka slakweye faya məhute na bay aye. Ma diye na, a walaŋ i Yahuda neheye nəteye mandza eye mə walaŋ i Gərek hay aye kəla ɗaw? Ada ma ta tətikateye a Gərek hay kəla ɗaw? ");
INSERT INTO meq_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Bazlam ŋgay niye a gwaɗ: “Ka ta pəlumeye ga, ada ka ta hutumeye ga bay hərwi ka slumeye faya mede a təv nakə neŋ na diye a ɗəma aye bay.” A tsik andza niye na, andza məgweɗe mey?» ");
INSERT INTO meq_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pat i mandəve i magurlom na, pat nakə bagwar aye. Pat eye niye Yesu a lətse, a tsik me ta magala, a gwaɗ: «Taɗə ndoweye yam a gay na, mâ yaw ka təv ga mâ sa. ");
INSERT INTO meq_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ndoweye kə dzala ha ka neŋ na, “yam nakə ma vəliye sifa aye ma ŋgəziye waɗ waɗ mə ɗərev ŋgay” andza nakə tə watsa ahəl niye mə Ɗerewel i Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu a tsik andza niye na ka Məsəfəre i Mbəlom. Ndo neheye ta dzala ha ka Yesu aye na, ta hutiye Məsəfəre niye. Ahəl nakə Yesu a tsik andza niye na, Məsəfəre ki yaw zuk bay hərwi Yesu kə tsal a təv nakə Mbəlom ma ɗəslay ha gər aye zuk bay. ");
INSERT INTO meq_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ndo hay tə tsəne bazlam i Yesu nakə a tsik aye na, siye i ndo hay tə gwaɗ: «Ta deɗek ndo nakay na, ndo məɗe ha bazlam i Mbəlom nakə faya ka həbakweye aye!» ");
INSERT INTO meq_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Siye hay tə gwaɗ: «Neŋgeye na, Kəriste!» Ane tuk na, siye hay tə gwaɗ sa: «Kəriste na, ma deyeweye abəra ka dala i Galile ɗaw? ");
INSERT INTO meq_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tə watsa mə Ɗerewel i Mbəlom na, tə gwaɗ Kəriste ma deyeweye na, abəra ma gwala i Davit ada ma Betelehem, gəma nakə Davit a ndzawa mə ɗəma aye.» ");
INSERT INTO meq_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Andza niye, bazlam a ye tay ka bo a ndo hay bay hərwi Yesu. ");
INSERT INTO meq_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ndo siye hay a satay məgəse na Yesu. Ane tuk na, ndəray kwa nəte kə lamay bay. ");
INSERT INTO meq_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sidzew neheye ta tsəpawa gay i məɗəslay ha gər a Mbəlom hay, tə maw ka təv i bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta Farisa hay. Anəke tə maw na, ndo neheye ta tsətsah fataya, tə gwaɗatay: «Ka gəsumaw Yesu bay na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Sidzew matsəpe gay i məɗəslay ha gər a Mbəlom niye hay ta mbəɗatay faya, tə gwaɗatay: «Ndəray kə tsik me ɗaɗa andza ndo nakay bay!» ");
INSERT INTO meq_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisa hay tə gwaɗatay: «Nəkurom dərmak ka səpat kurom ɗaw? ");
INSERT INTO meq_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ka ŋgatumay a ndəray mə walaŋ may bəy i Farisa hay ada mə walaŋ i bəy hay i ndo neheye tə vəlaway wu a Mbəlom aye hay kə dzala ha ka ndo niye ɗaw? ");
INSERT INTO meq_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ane tuk na, maa dzala ha ka Yesu eye na, ndo kəriye hay, tə sər bazlam i Musa mapala eye bay. Nəteye na, Mbəlom kə vəlatay mezeleme.» ");
INSERT INTO meq_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodem neŋgeye nəte mə walaŋ i Farisa niye hay dərmak. Neŋgeye ndo nakə a ye ka təv i Yesu ahəl niye aye. A gwaɗatay a siye i Farisa niye hay: ");
INSERT INTO meq_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Bazlam kway mapala eye kə vəlakway tsəveɗ məgay sariya a ndo andza niye kəriye tsa bay. Tsənakwa wu nakə ma tsikiye ada wu nakə a ge aye təday.» ");
INSERT INTO meq_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ta mbəɗay faya, tə gwaɗay: «Nəkar na, ndo i Galile dərmak ɗaw? Dzaŋga bazlam i Mbəlom lele təday ada ka səriye ha na, ndo məɗe ha bazlam i Mbəlom kwa nəte ma deyeweye abəra ma Galile bay.»  ");
INSERT INTO meq_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kwa way a tsəne andza niye na, a ye ŋgway a mətagay. ");
INSERT INTO meq_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu a tsal a Mahəmba i Tetəɗœz. ");
INSERT INTO meq_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ta mekedœ pərik na, a mbəɗawa gər a gay i məɗəslay ha gər a Mbəlom. A ye naha a ndza ka dzaŋga. Ndo hay haladzay ti ye naha ka təv ŋgay. Tsa na, a dazlay a matətikatay. ");
INSERT INTO meq_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ahəl nakə faya ma tətikateye a ndo hay aye na, ndo mədzaŋgawa bazlam i Mbəlom mapala eye ta Farisa hay tə gəsay naha ŋgwas wuray tə tatsa na ka məge madama. Tə gəs naha, tə lətse ha kame i ndo hay tebiye. ");
INSERT INTO meq_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tə gwaɗay a Yesu: «Miter, ŋgwas nakay tə tatsa na na, neŋgeye faya ma giye madama. ");
INSERT INTO meq_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Bazlam i Musa mapala eye a gwaɗ na, ka ndzumay a gər a slala i ŋgwas andza nakay na, kəɗum na tə kwar. Ada nəkar ka gwaɗ faya na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tə tsikay andza niye na, məhəle faya abəra suwat hərwi ada məhute faya mənese. Ane tuk na, Yesu a tsəne andza niye na, a rəh gər ŋgay ka dala. A pa bo ka məzehe ka dala ta wur həlay. ");
INSERT INTO meq_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ndo neheye na, nəteye ta tsətsahiye faya huya. Hərwi niye Yesu a lətse, a gwaɗatay: «Mə walaŋ kurom nakay ndo nakə ɗaɗa kə ge mezeleme bay aye mâ lahay ha məkalay kwar təday.» ");
INSERT INTO meq_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tsa na, Yesu a rəh gər ka dala sa. A ma ka məzehe ka dala. ");
INSERT INTO meq_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tə tsəne bazlam i Yesu niye a tsikatay aye na, tə gəɗ nəte ta nəte. Maa lah mede na, madugula hay. Yesu ta ŋgwas niye tə ze naha sulo tsɨy. Ŋgwas niye malətse eye huya kame i Yesu. ");
INSERT INTO meq_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu a lətse, a gwaɗay: «Ŋgwas nakay, ndo neheye tə gəsa kar ahaya na, nəteye məŋgay? Ndəray kə gəs kar ta sariya bay sadzək ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ŋgwas niye a mbəɗay faya, a gwaɗay: «Aʼay bəy.» Yesu a gwaɗay: «Neŋ bəbay na, sariya ga ma gəsiye kar bay. Do wu yak, ane tuk na, kâ ge mezeleme sa bay.» ");
INSERT INTO meq_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ma dəba eye na, Yesu a tsikatay a ndo hay, a gwaɗatay: «Neŋ na, dzaydzay nakə ma dəviye ka məndzibəra aye. Ndoweye kə peŋ bəzay na, ma ndziye ma ləvoŋ sa bay, ma hutiye dzaydzay, dzaydzay nakə ma vəliye sifa a ndo hay aye.» ");
INSERT INTO meq_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisa hay tə gwaɗay: «Nəkar na, bo yak eye ka həl mbal i gər yak eye tsa ɗaw? Bazlam yak nakə ka tsik aye na, deɗek bay.» ");
INSERT INTO meq_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu a mbəɗatay faya, a gwaɗatay: «Kwa neŋ eye na həl mbal i gər na, wu nakə na tsik aye na, deɗek. Hərwi na sər təv nakə na yaw abəra mə ɗəma aye ada təv nakə na diye a ɗəma aye. Ane tuk na, nəkurom na, təv ga nakə na yaw abəra mə ɗəma aye ada təv nakə na diye a ɗəma aye na, ka sərum bay. ");
INSERT INTO meq_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nəkurom na, faya ka gumateye sariya a ndo hay na, andza i ndo i məndzibəra hay. Neŋ na, na giye sariya a ndəray təbey. ");
INSERT INTO meq_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kwa taɗə na giye sariya bəbay na, sariya ga na giye ta tsəveɗ eye. Hərwi na giye sariya na, mahəgeye bay. Nəmaa giye na, ta Bəba ga. Maa sləra ga ahaya na, neŋgeye. ");
INSERT INTO meq_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mawatsa eye mə bazlam kurom mapala eye na, a gwaɗ: “Taɗə ndo hay sulo bazlam tay kə ge nəte na, wu niye na, deɗek.” ");
INSERT INTO meq_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Andza niye, neŋ na, na tsikiye ka bo ŋgway ada Bəba nakə a sləra ga ahaya ma tsikiye ka neŋ.» ");
INSERT INTO meq_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ta tsətsah faya, tə gwaɗay: «Bəba yak eye na, məŋgay?» Yesu a mbəɗatay faya, a gwaɗatay: «Ka sərum ga ha bay ada ka sərum Bəba ga bay. Taɗə ka sərum neŋ na, ka sərumeye Bəba ga.» ");
INSERT INTO meq_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu a tsik bazlam niye hay na, ahəl nakə faya ma tətikateye bazlam ŋgay a ndo hay mə gay i məɗəslay ha gər a Mbəlom aye. Neŋgeye mandza eye ta təv nakə tə pawa a ɗəma wu kəriye a Mbəlom aye. Ndəray kə gəs na bay hərwi həlay ŋgay eye kə sla zuk bay. ");
INSERT INTO meq_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu a gwaɗatay sa: «Na diye gwa. Na ye na, ka pəlumeye ga. Ane tuk na, ka mətumeye mə mezeleme kurom. Ka slumeye faya mede a təv nakə neŋ na diye a ɗəma aye bay.» ");
INSERT INTO meq_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yahuda hay tə gwaɗ mə walaŋ tay: «A gwaɗ ka slakweye mede a təv nakə ma diye a ɗəma aye bay na, ma kəɗiye bo ŋgay kəla ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu a gwaɗatay: «Nəkurom ka wum bo na, ka məndzibəra. Neŋ na yaw na, mə mbəlom. Nəkurom na, ndo i məndzibəra hay. Ane tuk na, neŋ na, ndo i məndzibəra təbey. ");
INSERT INTO meq_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hərwi niye na gwaɗakum na: “Ka mətumeye mə mezeleme kurom.” Kə ge ka dzalum ha neŋ ndo nakə neŋgeye aye bay na, ta deɗek ka mətumeye mə mezeleme kurom.» ");
INSERT INTO meq_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ta tsətsah faya, tə gwaɗay: «Nəkar na, way?» Yesu a mbəɗatay faya, a gwaɗatay: «Neŋ na, ndo nakə na tsikakum kwa ahəl nakə na dazlay mətsikakum bazlam ga aye. ");
INSERT INTO meq_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Wu andaya haladzay mətsike ka gər kurom ada sariya ma gəsiye kurom tə wu niye hay. Ane tuk na, ndo nakə a sləra ga ahaya na, neŋgeye ndo i deɗek ada wu nakə na tsikateye a ndo hay aye, maa tsikeŋ na, neŋgeye.» ");
INSERT INTO meq_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesu a tsikatay ka Bəba Mbəlom na, nəteye ta tsəne bay. ");
INSERT INTO meq_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesu a gwaɗatay sa: «Ka lətsum ga ha, ka kəɗum neŋ Wawa i Ndo na, neŋ ndo nakə neŋgeye aye ka sərumeye ha. Ka sərumeye ha wu nakə na ge aye na, ka gər bo ga tsa bay. Na tsik na, wu nakə Bəba a tsikeŋ aye ɗekɗek tsa. ");
INSERT INTO meq_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ndo nakə a sləra ga ahaya na, neŋgeye tə neŋ. Kə gər ga ha mahəgeye bay hərwi faya na giye na, wu nakə a yay a gər aye.» ");
INSERT INTO meq_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kwayaŋŋa ndo hay haladzay tə dzala ha ka Yesu hərwi bazlam ŋgay niye a tsik aye. ");
INSERT INTO meq_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu a gwaɗatay a Yahuda neheye tə dzala ha faya: «Ka pumay bəzay a bazlam ga na, ka tərumeye gawla ga hay ta deɗek. ");
INSERT INTO meq_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Andza niye ka sərumeye deɗek. Ada ma təma kurom ahaya abəra ma beke deɗek.» ");
INSERT INTO meq_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tə tsəne andza niye, ta mbəɗay faya, tə gwaɗay: «Nəmay na, gwala i Abraham hay ada ɗaɗa nəmaa təra beke hay bay. Ane tuk na, ka gwaɗ nəmaa təmaweye abəra ma beke na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu a mbəɗatay faya, a gwaɗatay: «Ayaw! Sərum ha na, ndo nakə faya ma giye mezeleme aye na, neŋgeye ka təra beke i mezeleme. ");
INSERT INTO meq_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Beke na, ma ndziye huya mə gay i ndo i gay ŋgay bay. Wawa, neŋgeye na, ma ndziye huya mə gay i bəba ŋgay. ");
INSERT INTO meq_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Andza niye, neŋ wawa Mbəlom na təma kurom ahaya abəra ma beke na, ka tərumeye beke hay sa bay. ");
INSERT INTO meq_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Na sər ha nəkurom na, gwala i Abraham hay. Ane tuk na, faya ka pəlumeye tsəveɗ ka məkəɗe ga hərwi ka kərahum bazlam ga. ");
INSERT INTO meq_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Neŋ, na tsik na, wu nakə na ŋgatayaw abəra ka təv i Bəba aye. Nəkurom ka gum na, wu nakə bəba kurom a tsikakum aye.» ");
INSERT INTO meq_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ta mbəɗay faya, tə gwaɗay: «Bəba may na, Abraham.» Yesu a gwaɗatay: «Taɗə nəkurom wawa i Abraham hay na, ka gumeye andza Abraham bəɗaw? ");
INSERT INTO meq_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Neŋ, na tsikawakum na, deɗek nakə na tsənew ka Mbəlom aye. Kwa mâ ge andza niye bəbay na, nəkurom faya ka pəlumeye tsəveɗ məkəɗe ga. Abraham na, neŋgeye kə ge andza niye təbey. ");
INSERT INTO meq_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nəkurom na, faya ka gumeye wu nakə bəba kurom a gawa aye.» Tə gwaɗay: «Nəmay na, madazla hay bay. Wawa neheye madazla aye hay na, ndəray a sər bəba tay hay bay. Bəba may na, Mbəlom nəte ŋgweŋ.» ");
INSERT INTO meq_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu a gwaɗatay: «Taɗə Mbəlom Bəba kurom na, ka wuɗumeye ga. Hərwi neŋ na, na yaw mə Mbəlom ada neŋ kanaŋ na, hərwi ŋgay. Na yaw ka gər bo ga bay, maa sləra ga ahaya na, neŋgeye. ");
INSERT INTO meq_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Wu nakə faya na tsikiye ka tsənum bay na, hərwi mey? Ka tsənum bay na, hərwi ka slum faya matəme bazlam ga bay. ");
INSERT INTO meq_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","«Bəba kurom na, Fakalaw ada a yakum a gər məge na, wu nakə bəba kurom a wuɗa aye. Neŋgeye ndo məkəɗe ndo kwa anəke bay. Neŋgeye na, a say deɗek təbey hərwi deɗek andaya mə neŋgeye bay. Maraw me na, wu ŋgay hərwi neŋgeye ndo i maraw me. Maraw me waray waray na, a yaw abəra na, ma neŋgeye. ");
INSERT INTO meq_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","«Ane tuk na, neŋ na, na tsik deɗek. A sakum mədzele ha ka neŋ bay na, hərwi nakə na tsik deɗek aye. ");
INSERT INTO meq_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Way nakə mə walaŋ kurom ma gwaɗiye ka neŋ, na ge mənese na, way? Na tsikakum deɗek na, ka dzalum ha faya bay na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kə ge ndoweye wawa i Mbəlom na, ma pay zləm a bazlam i Mbəlom. Nəkurom ka pumay zləm a bazlam ga bay na, hərwi nakə nəkurom wawa i Mbəlom hay bay aye.» ");
INSERT INTO meq_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bagwar i Yahuda hay tə gwaɗay a Yesu: «Nəmaa gwaɗ nəkar ndo i Samari ada fakalaw mə bo yak na, nəmaa tsik na, deɗek.» ");
INSERT INTO meq_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu a mbəɗatay faya, a gwaɗatay: «Fakalaw andaya mə bo ga bay. Neŋ faya na ɗəslay ha gər a Bəba ga. Nəkurom na, ka wuɗum məɗəsleŋ ha gər bay. ");
INSERT INTO meq_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Neŋ na, na ɗəslay gər a bo ga bay. Ɗuh ndo nakə a say məɗəsleŋ ha gər aye na, andaya. Mata ge sariya eye na, neŋgeye. ");
INSERT INTO meq_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ayaw! Sərum ha na, taɗə ndoweye ka rəhay ha gər a bazlam ga na, ma mətiye ɗaɗa bay.» ");
INSERT INTO meq_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yahuda hay tə gwaɗay: «Anəke nəmaa sər ha tuk. Fakalaw andaya mə bo yak. Abraham kə mət, ada ndo məɗe ha bazlam i Mbəlom hay ta mət tuk na, ada nəkar ka gwaɗ ndoweye ka rəhay ha gər a bazlam yak na, ma mətiye ɗaɗa bay na, kəkay? ");
INSERT INTO meq_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nəkar na, ka ze bəba may Abraham ɗaw? Neŋgeye na, kə mət ada ndo məɗe ha bazlam i Mbəlom hay ta mət dərmak. Nəkar na, way?» ");
INSERT INTO meq_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu a mbəɗatay faya, a gwaɗatay: «Taɗə neŋ na ɗəslay ha gər a bo ga na, ma geŋeye ŋgama bay. Maa ɗəsleŋ ha gər na, Bəba ga. Neŋgeye na, ndo nakə ka gwaɗum Mbəlom kurom aye. ");
INSERT INTO meq_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ane tuk na, ka sərum na bay. Neŋ na, na sər na. Taɗə na gwaɗawa na sər na bay na, neŋ ndo i maraw me andza nəkurom. Ane tuk na, na sər na ada neŋ faya na rəhay ha gər a bazlam ŋgay. ");
INSERT INTO meq_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mbəlom kə tsikay a bəba təte kurom Abraham ma ŋgateye a pat i madayaw ga ada Abraham na, ɗərev ŋgay kə ŋgwasa. Abraham a ŋgatay a pat eye na, məŋgwese kə rah a ɗərev ŋgay.» ");
INSERT INTO meq_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yahuda hay tə gwaɗay: «Nəkar məve kə husa məve kuro kuro zlam zuk bay tuk na, ka ŋgatayaw a Abraham aye na, məŋgay?» ");
INSERT INTO meq_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu a mbəɗatay faya, a gwaɗatay: «Ayaw! Sərum ha na, kwa ahəl nakə ta wa na Abraham zuk bay aye na, neŋ andaya.» ");
INSERT INTO meq_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tə tsəne andza niye na, tə pala kwar, a satay məkele na Yesu. Ane tuk na, Yesu a ŋgaha bo, ada a gəɗaw abəra mə gay i məɗəslay ha gər a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Pat wuray Yesu faya ma diye ka tsəveɗ na, a ŋgatay a ndo wuray guluf eye. Tə wa na na, guluf eye. ");
INSERT INTO meq_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Gawla i Yesu hay tə ŋgatay a guluf niye na, ta tsətsah ka Yesu, tə gwaɗay: «Miter, tə wa na ndo nakay guluf eye na, hərwi mezeleme ŋgay ŋgway tsukuɗu hərwi mezeleme i bəba ŋgay hay ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu a mbəɗatay faya, a gwaɗatay: «Tə wa na guluf eye na, hərwi mezeleme ŋgay bay, ada hərwi mezeleme i bəba hay ŋgay wal bay. Neŋgeye guluf eye na, hərwi ada ndo hay tâ ŋgatay a gədaŋ i Mbəlom nakə ma giye bo tə neŋgeye aye. ");
INSERT INTO meq_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Anəke pat andaya mba na, kutoŋ ka gakweye məsler i ndo nakə a sləra ga ahaya aye. Mazlambar həvaɗ ma giye. Həvaɗ kə ge na, ndəray ma sliye faya məge məsler sa bay. ");
INSERT INTO meq_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ahəl nakə neŋ andaya ka məndzibəra mba aye na, neŋ na, dzaydzay nakə ma dəviye ka məndzibəra aye.» ");
INSERT INTO meq_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu a ndəv ha mətsike me na, a tuf slesleɓ ka dala, a həlaɓ bətekwew tsekweŋ ta slesleɓ ŋgay niye. Tsa na, a ndaɗ, a faɗay ka ɗəre i guluf niye. ");
INSERT INTO meq_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","A gwaɗay: «Do ta bara ɗəre a dəlov nakə tə zalay Silowe aye.» Silowe na, andza məgweɗe «Masləra eye». Guluf niye a ye. A ye naha a bara ɗəre ŋgay. A maw na, a ŋgatay a ɗəre tuk. ");
INSERT INTO meq_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ndo i məgeɗ ŋgay hay ta ndo neheye tə ŋgataway ka tsəveɗ faya ma rəkiye na, tə gwaɗ: «Nakay na, ndo niye a ndzawa ka tsəveɗ a rəkawa aye bəɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ndo siye hay tə gwaɗ: «Deɗek, neŋgeye.» Ndo mekeleŋ eye hay tə gwaɗ: «Aʼay! Neŋgeye bay. Ane tuk na, a ndzəkit bo neŋgeye.» Ndo niye a gwaɗatay: «Neŋ eye deɗek ŋgway.» ");
INSERT INTO meq_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ta tsətsah faya, tə gwaɗay: «Ɗəre yak a həndək na, ma kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","A mbəɗatay faya, a gwaɗatay: «Ndo nakə tə zalay Yesu aye a həlaɓ bətekwew tsekweŋ, a feɗeŋ ka ɗəre ada a gweɗeŋ: “Do a dəlov i Silowe ta bara ɗəre mə ɗəma.” Tsa na, na həl bo na ye. Na ye naha, na bara ɗəre ga na, ɗəre ga a həndək, na ŋgatay a ɗəre!» ");
INSERT INTO meq_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ta tsətsah faya sa, tə gwaɗay: «Ndoweye niye anəke neŋgeye məŋgay?» A mbəɗatay faya, a gwaɗatay: «Neŋgeye ka waray na, na sər bay.» ");
INSERT INTO meq_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ma dəba aye na, ti ye ha ndo niye ɗəre ŋgay a həndək aye ka təv i Farisa hay. ");
INSERT INTO meq_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Azlakwa Yesu a həlaɓ bətekwew ada a həndəkay na ɗəre a guluf niye na, pat i mazəzukw bo i Yahuda hay. ");
INSERT INTO meq_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Hərwi niye Farisa hay, nəteye dərmak ta tsətsah faya, tə gwaɗay: «Ɗəre yak a həndək sadzək na, ma kəkay?» Ndo niye a gwaɗatay: «Yesu a feɗeŋ bətekwew ka ɗəre ada na bara ɗəre. Tsa na, na ŋgatay a ɗəre tuk.» ");
INSERT INTO meq_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Siye hay mə walaŋ i Farisa hay, tə gwaɗ: «Ndo niye a ge wu niye na, a yaw abəra ka təv i Mbəlom bay. Bazlam kway mapala eye a gwaɗ nakə a ge məsler pat i mazəzukw bo aye. Ka rəhay ha gər təbey.» Ane tuk na, ndo mekeleŋ eye hay mə walaŋ tay tə gwaɗ: «Ndo i mezeleme ma sliye faya məge slala i masuwayaŋ nakay na, ma kəkay?» Mə walaŋ tay niye na, bazlam a ye tay ka bo bay, nəteye mawuna eye. ");
INSERT INTO meq_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Farisa niye hay ta tsətsah ka ndo niye ɗəre ŋgay a həndək aye sa, tə gwaɗay: «Ada nəkar ka gwaɗ ka ndo niye a həndəkaka ha ɗəre aye, neŋgeye na, way?» A mbəɗatay faya, a gwaɗatay: «Neŋgeye na, ndo məɗe ha bazlam i Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ndo niye a ndzawa ahəl niye guluf eye ada anəke ɗəre ŋgay ka həndək na, bagwar i Yahuda hay ta dzala ha deɗek bay. Hərwi niye tə zalay a bəba ŋgay ta may ŋgay hərwi matsətsehe fataya. ");
INSERT INTO meq_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ta tsətsah fataya, tə gwaɗatay: «Nakay na, wawa kurom deɗek ɗaw? Ka gwaɗum ka wum na guluf eye na, deɗek ɗaw? Ada anəke a ŋgatay a ɗəre na, ma kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Bəba ta may i ndo niye ta mbəɗatay faya, tə gwaɗatay: «Nəmaa sər ha ta deɗek neŋgeye na, wawa may ada nəmaa wa na guluf eye. ");
INSERT INTO meq_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ane tuk na, wu nakə a təra tə neŋgeye ada anəke a ŋgatay a ɗəre tuk aye na, nəmaa sər bay. Ndo nakə a həndəkay na ɗəre aye na, nəmaa sər wal bay. Tsətsahum ka bo ŋgay eye. Neŋgeye na, wawa eye sa bay, ma sliye faya mambəɗakum ka bazlam nakə ka tsətsahumeye faya aye.» ");
INSERT INTO meq_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tə tsik andza niye na, hərwi ta dzədzar ta bagwar i Yahuda hay. Hərwi ɓa bagwar i Yahuda hay ta ɓar bazlam nəte. Ndo nakə kə gwaɗ Yesu na, neŋgeye Kəriste na, tâ həhara ahaya abəra mə gay i maɗuwule me tay. ");
INSERT INTO meq_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Hərwi niye ta mbəɗay faya bay. Ane tuk na, tə gwaɗ: «Neŋgeye wawa eye sa bay, tsətsahum ka bo ŋgay eye.» ");
INSERT INTO meq_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Farisa hay tə zalay a ndo niye ɗəre ŋgay a həndək aye masulo eye sa, tə gwaɗay: «Tsikamay deɗek kame i Mbəlom, hərwi nəmaa sər ha ndo niye na, ndo i mezeleme.» ");
INSERT INTO meq_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","A mbəɗatay faya, a gwaɗatay: «Neŋgeye ndo i mezeleme, na sər bay, ndo i mezeleme bay na sər bay. Ane tuk na, wu nakə na sər aye na, haɓe na ndzawa na, guluf eye, anəke na, na ŋgatay a ɗəre.» ");
INSERT INTO meq_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ta tsətsah faya, tə gwaɗay: «Ka ŋgatay a ɗəre na, a ge ka nəkar na, kəkay? A həndəkaka ha ɗəre yak na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","A mbəɗatay faya, a gwaɗatay: «Ɓa na təkərakum tsɨy, ka wuɗum məpay zləm bay. A sakum mətsəne sa na, hərwi mey? A sakum matəre gawla ŋgay hay dərmak kəla ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tə tsəne andza niye na, tə tsaɗay pəleslesle. Tə gwaɗay: «Gawla i ndo niye na, nəkar! Nəmay na gawla i Musa hay. ");
INSERT INTO meq_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nəmaa sər Mbəlom a tsikay me ahəl niye na, a Musa. Ane tuk na, ndo niye ɗuh a yaw məŋgay na, nəmaa sər na bay.» ");
INSERT INTO meq_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ndo niye a mbəɗatay faya, a gwaɗatay: «Wu nakə na tsəne aye na, a geŋ hərɓaɓəkka! Ndo nakə a həndəkeŋ na ɗəre aye ka gwaɗum ka sərum təv ŋgay nakə a yaw abəra mə ɗəma aye bay na, kəkay! ");
INSERT INTO meq_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ka sərakwa ha Mbəlom na, ma pay zləm a bazlam i ndo i mezeleme hay bay. Ane tuk na, faya ma pay zləm kwa a way ka rəhay ha gər ada faya ma giye wu nakə a say aye. ");
INSERT INTO meq_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ɗaɗa ndəray kə tsəne ta həndəkay na ɗəre a ndo nakə tə wa na guluf eye bay. ");
INSERT INTO meq_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Taɗə ndo nakay a yaw na, abəra ka təv i Mbəlom bay na, ma sliye faya məge wuray bay.» ");
INSERT INTO meq_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ta mbəɗay faya, tə gwaɗay: «Nəkar kwa ahəl nakə tə wa kar aye na, nəkar mə mezeleme. A saka matətikamay dərmak ɗaw?» Tsa na, ta həhar na abəra mə gay i maɗuwule me. ");
INSERT INTO meq_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu a tsəne ta həhar na ndo niye a həndəkay na ɗəre aye abəra mə gay i maɗuwule me na, a pa bo ka mapəle na. A huta na ndo niye na, a gwaɗay: «Ka dzala ha neŋ Wawa i Ndo ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ndo niye a mbəɗay faya a Yesu, a gwaɗay: «Bəy Maduweŋ ga, Wawa i Ndo nakə a seŋ na dzaliye ha faya aye na, way. Ɗeŋ ha tey.» ");
INSERT INTO meq_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu a mbəɗay faya, a gwaɗay: «Nəkar ka ŋgatay. Neŋgeye nakə faya ma tsikakeye me anəke aye.» ");
INSERT INTO meq_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ndo niye a gwaɗay: «Bəy Maduweŋ, na dzala kar ha.» Tsa na, a dəkway gurmets a huvo a Yesu. ");
INSERT INTO meq_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu a gwaɗ: «Na yaw ka məndzibəra na, hərwi maŋgəne tay ha ndo neheye faya ta pay bəzay a Mbəlom abəra ta ndo neheye tə pay bəzay a Mbəlom bay aye. Ada ndo neheye tə ŋgatay a ɗəre bay aye na, ta ŋgateye a ɗəre, ndo neheye tə ŋgatay aye na, ta təriye guluf eye hay.» ");
INSERT INTO meq_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisa niye hay ka təv ŋgay aye tə tsəne na, ta tsətsah faya, tə gwaɗay: «Nəkar ka gwaɗ nəmay na, guluf eye hay dərmak ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu a mbəɗatay faya, a gwaɗatay: «Taɗə nəkurom guluf eye hay na, haɓe ka gumeye mezeleme bay. Aya ane ka gwaɗum ɗuh na, nəkurom guluf eye hay bay sa na, hərwi niye ka ndzumeye huya mə mezeleme.» ");
INSERT INTO meq_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu a gwaɗatay sa: «Sərum ha na, ndoweye kə fələkwa a gay i təɓaŋ ta məgeɗ bay, a fələkwa ta təv mekeleŋ eye wal na, neŋgeye məkal ada ndo mabuwe tay ha təɓaŋ hay. ");
INSERT INTO meq_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ane tuk na, ndo nakə ma fələkwiye ta məgeɗ aye na, neŋgeye ndo mətsəkure təɓaŋ hay. ");
INSERT INTO meq_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","«Ndo matsəpe məgeɗ i gay i təɓaŋ hay ka həndək na məgeɗ a ndo mətsəkure təɓaŋ hay na, ma fələkwiye a ɗəma. Kə fələkwa a ɗəma na, ma zaliye a təɓaŋ ŋgay hay ta məzele. Ta tsəne məzele tay na, ma pəla tay ahaya abəra. ");
INSERT INTO meq_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kə pəla tay ahaya abəra tebiye na, ma ndzateye kame. Kə ndzatay kame na, ta pay bəzay hərwi tə sər bəɗiɗay ŋgay. ");
INSERT INTO meq_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ane tuk na, ndo nakə tə sər na bay aye na, ta pay bəzay bay. Ta pay bəzay bay na, hərwi tə sər bəɗiɗay ŋgay bay.» ");
INSERT INTO meq_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu a tsikatay bazlam niye ta dzeke. Ane tuk na, wu nakə Yesu a say mətsike aye na, ta tsəne bay. ");
INSERT INTO meq_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Hərwi niye Yesu a gwaɗatay sa: «Sərum ha na, məgeɗ i gay i təɓaŋ hay na, neŋ. ");
INSERT INTO meq_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ndo neheye tə leheŋew madayaw aye nəteye na, məkal hay, ndo mabuwe ndo hay. Təɓaŋ hay ta piye zləm ka bazlam tay bay. ");
INSERT INTO meq_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Neŋ na, məgeɗ. Ndoweye kə fələkwa tə neŋ na, na ta təmiye ha. Neŋgeye na, ma sliye faya məfələkwe a gay ada ma deyeweye abəra andza nakə a say aye. Ma ndziye na, barbarra, ma hutiye wu mənday. ");
INSERT INTO meq_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Məkal ma deyeweye i ŋgay na, hərwi makəle təɓaŋ hay, məkəɗe tay ha ada hərwi mənese tay ɗekɗek tsa. Neŋ na yaw na, hərwi ada ndo hay tâ huta sifa. Sifa niye ta hutiye na, ma ndəviye bay ka tor eye. ");
INSERT INTO meq_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Neŋ na, ndo mətsəkure təɓaŋ hay ta lele eye. Ndo mətsəkure təɓaŋ ta lele eye na, neŋgeye maləva bo eye məvəle məsəfəre ŋgay hərwi təɓaŋ ŋgay hay. ");
INSERT INTO meq_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ndo nakə a ge məsler hərwi suloy aye na, neŋgeye ndo mətsəkure wu ta lele eye bay. Kə ŋgatay a kəra i pesl faya ma deyeweye ka təɓaŋ hay na, ma huye ma gəriye tay ha təɓaŋ hay. Kəra i pesl niye ma həhariye tay ha təɓaŋ niye hay ma gəsiye tay ha, siye hay ta hwiye kweye kweye a təv eye. A ge andza niye na, hərwi təɓaŋ niye na, i ŋgay bay. ");
INSERT INTO meq_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Andza niye, ndo nakə a ge məsler hərwi suloy aye na, ma gateye gər a təɓaŋ hay lele bay. ");
INSERT INTO meq_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","«Neŋ na, ndo mətsəkure təɓaŋ hay ta lele eye. Na sər tay ha təɓaŋ ga hay, nəteye dərmak tə sər ga ha. ");
INSERT INTO meq_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Andza nakə Bəba ga a sər ga ha andza neŋ na sər Bəba ga aye. Ada na vəliye məsəfəre ga hərwi təɓaŋ ga hay. ");
INSERT INTO meq_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Təɓaŋ ga mekeleŋ eye hay nəteye andaya ma zləget nakay bay, nəteye ma təv eye. Ane tuk na, kutoŋ na hayateye gər ka təv ga dərmak. Ta tsəniye na, bəɗiɗay ga. Ta dzapiye ka təv ma nəte eye, ndo mətsəkure tay ha na, nəte dərmak. ");
INSERT INTO meq_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«Bəba ga a wuɗa ga. A wuɗa ga na, hərwi nakə neŋ na vəliye ha məsəfəre ga aye. Ada na sər ha na hutiye na məsəfəre ga sa. ");
INSERT INTO meq_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ndəray ma sliye faya məzle fagaya abəra məsəfəre ga ta gədaŋ bay. Mata vəle ha na, neŋ eye. Neŋ na, gədaŋ andaya məvəle ha məsəfəre ga ada gədaŋ andaya məhute na. Nakay na, wu nakə bəba ga a gweɗeŋ ge aye.» ");
INSERT INTO meq_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Bagwar i Yahuda hay tə tsəne bazlam i Yesu niye a tsik andza niye na, ta ŋgəna. ");
INSERT INTO meq_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ndo siye hay haladzay mə walaŋ tay tə gwaɗ: «Ma giye na, fakalaw mə bo ŋgay! Ka pakweye zləm a bazlam i gər mavuwe na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ndo mekeleŋ eye hay tə gwaɗ: «Ndo nakə fakalaw mə bo ŋgay aye na, ma tsikiye me andza niye bay. Ada fakalaw na, ma sliye faya mahəndəkay na ɗəre a guluf ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ahəl niye na, Yahuda hay tə pa magurlom i gay i məɗəslay ha gər a Mbəlom nakə tə ma ha ka mbəlom ma Zerozelem aye sa. Tə hatsawa magurlom niye na, ka məve. Tə hatsawa na, ahəl i mətasl. Anəke na, həlay i məhetse magurlom niye kə sla tuk. ");
INSERT INTO meq_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Pat wuray na, Yesu andaya mə magurlom niye dərmak faya ma həhaliye. Faya ma həhaliye na, mə mazambal i gay i məɗəslay ha gər a Mbəlom nakə tə zalay mazambal i Salomoŋ aye. ");
INSERT INTO meq_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bagwar i Yahuda hay tə lawara na Yesu, tə gwaɗay: «Taɗə nəkar Kəriste na, tsikamay parakka. Nəmaa həbiye nakə ada ka tsikameye na, hus kəɗay?» ");
INSERT INTO meq_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu a mbəɗatay faya, a gwaɗatay: «Ɓa na tsikakum tsɨy, ane tuk na, ka dzalum ha bay. Məsler nakə faya na giye na, na ge na, ta gədaŋ i Bəba ga. Mata bəzakum ha neŋ way na, məsler nakə faya na giye. ");
INSERT INTO meq_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ane tuk na, nəkurom ka dzalum ha bay, hərwi nəkurom na, ndo ga hay bay. ");
INSERT INTO meq_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","«Ndo ga hay na, ta pay zləm a bazlam ga andza təɓaŋ neheye ta pay zləm a ndo mətsəkure tay ha aye. Na sər tay ha ada nəteye ta peŋeye bəzay dərmak. ");
INSERT INTO meq_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Na vəlateye sifa nakə ma ndəviye bay aye. Nəteye na, ɗaɗa ta mətiye bay ada ndəray ma sliye faya mabuwe tay ha abəra mə həlay ga bay. ");
INSERT INTO meq_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bəba ga a vəleŋ tay ha a həlay ga, neŋgeye na, bagwar eye a ze wu hay tebiye. Ada ndəray ma sliye faya mabuwe wuray abəra mə həlay i Bəba ga bay. ");
INSERT INTO meq_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Bəba tə neŋ na, nəmay nəte.» ");
INSERT INTO meq_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bagwar i Yahuda hay tə tsəne bazlam ŋgay niye na, tə həl kwar a həlay, a satay məkəɗe na tə kwar sa. ");
INSERT INTO meq_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu a gwaɗatay: «Na ge wu lele eye hay haladzay ta gədaŋ i Bəba ga ada ka ŋgatumay tə ɗəre kurom. Mə walaŋ i wu neheye na ge aye, a sakum məkele ga tə kwar faya aye na, wu waray?» ");
INSERT INTO meq_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bagwar i Yahuda niye hay ta mbəɗay faya tə gwaɗay: «Nəmaa kəɗiye kar tə kwar ɗuh na, hərwi məsler lele eye nakə ka giye aye bay. Nəmaa kəɗiye kar tə kwar na, hərwi ka tsalay ka gər a Mbəlom. Nəkar na, ndo zezeŋ tuk na, ka gwaɗ nəkar Mbəlom na, ma kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu a mbəɗatay faya, a gwaɗatay: «Mawatsa eye mə ɗerewel kurom na, Mbəlom a gwaɗ: “Nəkurom mbəlom hay.” ");
INSERT INTO meq_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ka sərakwa ha na, wu nakə mawatsa eye mə Ɗerewel i Mbəlom aye na, ma ndziye andza niye huya. Ndo neheye a tsikatay bazlam aye taɗə Mbəlom a zalatay mbəlom hay aye na, ");
INSERT INTO meq_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","neŋ nakə Mbəlom a zla ga ada a sləra ga ahaya ka məndzibəra aye na, na ze tay ha bəɗaw? Neŋ na gwaɗ neŋ Wawa i Mbəlom. Nəkurom ka gwaɗum faya na tsaleye ka gər a Mbəlom, na tsalay ka gər na, ma kəkay? ");
INSERT INTO meq_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Taɗə faya na giye məsler i Bəba ga bay na, ka dzalum ha ka bazlam ga nakə na tsikakumeye bay. ");
INSERT INTO meq_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ane tuk na, taɗə faya na giye məsler ŋgay na, kwa ka təmum bazlam ga bay bəbay na, dzalum ha ka neŋ hərwi məsler nakə faya na giye aye hərwi ada ka sərumeye ha parakka neŋ ta Bəba ga na, nəmay nəte.» ");
INSERT INTO meq_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tə tsəne bazlam i Yesu niye na, kwayaŋŋa ta pəla tsəveɗ məgəse na sa. Ane tuk na, kə təma fataya abəra. ");
INSERT INTO meq_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ma dəba aye na, Yesu a həl bo, a ma a diye i magayam i Yurdum, magayam nakə Yuhana madzəhuɓe ndo a yam a dzəhuɓawa ndo hay a ɗəma aye. Yesu a ndza ŋgway mə ɗəma. ");
INSERT INTO meq_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ndo hay ti ye naha ka təv ŋgay haladzay. Ti ye naha na, tə gwaɗawa: «Yuhana kə ge masuwayaŋ kwa nəte bay. Ane tuk na, wu nakə a tsik tebiye ka ndo nakay aye na, deɗek.» ");
INSERT INTO meq_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ndo hay haladzay tə dzala ha ka Yesu. ");
INSERT INTO meq_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Ndoweye andaya tə zalay Lazar. A ndzawa na, ma gəma i Betani. Malamar ŋgay hay Marta ta Mari tə ndzawa ma gəma eye niye. Mari na, ŋgwas nakə ma ta mbəɗiye mal ka sik i Yesu ada ma ta takaɗiye na ta məkwets i gər ŋgay aye. Pat wuray na, Lazar a dəɗ a ɗəvats. ");
INSERT INTO meq_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Hərwi niye malamar ŋgay niye hay sulo eye tə slər ndo ka Yesu. Ndo niye a ye a gwaɗay: «Bəy Maduweŋ, dzam yak nakə ka wuɗa na haladzay aye na, ɗəvats a gay.» ");
INSERT INTO meq_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu a tsəne andza niye na, a gwaɗ: «Lazar ma mətiye ta ɗəvats niye bay. Ɗəvats niye a gay na, hərwi ada ndo hay tâ ŋgatay a məzlaɓ i Mbəlom ada ta zembeɗeŋeye a neŋ Wawa i Mbəlom dərmak.» ");
INSERT INTO meq_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu na, a wuɗa Marta ta malamar ŋgay Mari ada a wuɗa Lazar. ");
INSERT INTO meq_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yesu a tsəne Lazar neŋgeye ɗəvats eye na, ki ye bəse bay. A ndza ma təv ŋgay niye neŋgeye mə ɗəma aye məhəne sulo. ");
INSERT INTO meq_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ma dəba i məhəne niye sulo eye na, a gwaɗatay a gawla ŋgay hay: «Takwa abəra kanaŋ, makwa ka dala i Yahuda.» ");
INSERT INTO meq_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Gawla ŋgay hay ta mbəɗay faya, tə gwaɗay: «Eh! Miter may, kə ndza haladzay bay nakə ndo niye hay mə ɗəma aye a satay məkəɗe kar tə kwar tuk na, ada ka makweye a ɗəma sa na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu a gwaɗatay: «A dazlay ka mekedœ hus a huwa na, pat a dəv dzaydzay bəɗaw? Taɗə ndoweye ma həhaliye ta həpat na, ma ndəfiye sik bay hərwi dzaydzay i məndzibəra faya ma dəviye ka təv ŋgay. ");
INSERT INTO meq_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ane tuk na, taɗə ndoweye ma həhaliye ta həvaɗ na, ma ndəfiye sik hərwi ləvoŋ zəŋzəŋ, dzaydzay andaya ka təv ŋgay bay.» ");
INSERT INTO meq_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu a tsikatay bazlam niye hay na, ma dəba aye a gwaɗatay sa: «Dzam kway Lazar na, kə ndzahəra. Ane tuk na, na diye na ta pəɗekiye abəra ka məndzehəre.» ");
INSERT INTO meq_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Gawla ŋgay hay ta mbəɗay faya, tə gwaɗay: «Bəy Maduweŋ, kə ge neŋgeye məndzehəre eye na, ma mbəliye.» ");
INSERT INTO meq_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu neŋgeye a say məgweɗe ɗuh na, Lazar kə mət. Ane tuk na, nəteye tə dzala na, tə gwaɗ Yesu a tsik ka məndzehəre nakə deɗek aye. ");
INSERT INTO meq_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Andza niye Yesu a tsikatay parakka, a gwaɗatay: «Lazar kə mət bay. ");
INSERT INTO meq_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ane tuk na, ɗəvats a gəs Lazar na, neŋ andaya ka təv ŋgay bay. Na ye bay na, hərwi kurom. A ge bo andza niye na, hərwi ada nəkurom kâ dzalum ha ka neŋ. Hərwi niye ɗərev ga maŋgwasa eye. Lətsakwa, takwa ta zəbakwaw faya.» ");
INSERT INTO meq_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas ndo nakə tə zalay Mawsa aye, a gwaɗatay a siye i gawla i Yesu hay: «Takwa, mətakwa ka bo ta Bəy Maduweŋ kway.» ");
INSERT INTO meq_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu ta gawla ŋgay hay tə husa a gəma niye na, ɓa Lazar kə ge məhəne faɗ ma tsəvay. ");
INSERT INTO meq_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Gəma i Betani na, bəse ta Zerozelem. Ka diye abəra ma Betani a Zerozelem na, a sla kilomiter mahkar bay. ");
INSERT INTO meq_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yahuda hay haladzay ta ye naha mata gatayaw azekw a Marta ta Mari i mədahaŋ i malamar tay Lazar. ");
INSERT INTO meq_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta a tsəne Yesu kə ndzew, neŋgeye bəse ka tsəveɗ faya ma deyeweye na, a lətse, a ye mata dzəgər tə Yesu. Mari neŋgeye na, mandza eye mətagay. ");
INSERT INTO meq_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta a ye naha tə dzəgər tə Yesu na, a gwaɗay a Yesu: «Bəy Maduweŋ ga, taɗə ka ge andaya kanaŋ na, haɓe malamar ga ma mətiye bay. ");
INSERT INTO meq_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Na sər ha kwa anəke bəbay na, wu nakə ka tsətsah aye na, Mbəlom ma vəlakeye.» ");
INSERT INTO meq_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu a mbəɗay faya, a gwaɗay: «Malamar yak ma lətseweye abəra ma mədahaŋ.» ");
INSERT INTO meq_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta a mbəɗay faya, a gwaɗay: «Na sər, ahəl nakə aza məndzibəra ma ndəviye, ndo hay tebiye ta lətseweye abəra ma mədahaŋ aye na, neŋgeye dərmak ma lətseweye abəra ma mədahaŋ.» ");
INSERT INTO meq_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu a gwaɗay: «Neŋ na, ndo mətəme ha ndo abəra ma mədahaŋ ada ndo məvəle sifa a ndo hay. Ndoweye kə dzala ha ka neŋ na, kwa kə mət bəbay na, ma hutiye a ɗəma sifa nakə ma ndəviye bay aye. ");
INSERT INTO meq_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ndo kə dzala ha ka neŋ na, məsəfəre ŋgay ma dziye bay. Ma ndziye ka tor eye. Ka dzala ha bəɗaw Marta?» ");
INSERT INTO meq_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta a gwaɗay faya: «Ayaw Bəy Maduweŋ, na dzala nəkar na, Kəriste. Nəkar na, Wawa i Mbəlom niye tə gwaɗ ma deyeweye ka məndzibəra aye.» ");
INSERT INTO meq_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta a tsik ka bo abəra andza niye na, a mbəɗa gər a mətagay mata zalayaw a malamar ŋgay Mari. A ye naha a tsikay me ta suksuk eye, a gwaɗay: «Bəy Maduweŋ ki yaw, faya ma zalakeye. A gwaɗaka dara.» ");
INSERT INTO meq_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mari a tsəne andza niye na, kwayaŋŋa a lətse, a ye bəse ka təv i Yesu. ");
INSERT INTO meq_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Azlakwa Yesu na, kə husa a gəma niye zuk bay. Neŋgeye huya ka təv nakə tə dzəgər ta Marta aye. ");
INSERT INTO meq_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ndo neheye ti ye naha a gay i Mari mata gatay azekw aye, tə ŋgatay a Mari a lətse, a yaw abəra na, tə payaw bəzay. Tə gwaɗ ma giye na, ma diye ka tsəvay mata tuwe. ");
INSERT INTO meq_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mari a ye na, ka təv i Yesu. A husa ka təv nakə Yesu mə ɗəma aye. A ŋgatay a Yesu na, a dəkw gurmets kame ŋgay, a gwaɗay: «Bəy Maduweŋ, taɗə ka ge andaya kanaŋ na, haɓe malamar ga ma mətiye bay.» ");
INSERT INTO meq_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu a zəba ka Mari na, faya ma tuwiye ada ndo neheye ti ye naha dziye faya ta tuwiye dərmak. Tsa na, ɗərev a ndalay haladzay, a mbəɗay ha mədzal gər. ");
INSERT INTO meq_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","A tsətsah fataya, a gwaɗatay: «Ka lum na na, ka waray?» Ta mbəɗay faya, tə gwaɗay: «Bəy Maduweŋ, dara nəmaa ɗakeye faya.» ");
INSERT INTO meq_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu a tuwa. ");
INSERT INTO meq_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ndo niye hay tə gwaɗ: «Zəbum faya tey, a wuɗa Lazar haladzay!» ");
INSERT INTO meq_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ane tuk na, ndo siye hay mə walaŋ tay, tə gwaɗ: «Ka həndəkay ha ɗəre a guluf, Lazar mâ mət bay na, a sla faya məge təbəɗew?» ");
INSERT INTO meq_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ɗərev a ndalay a Yesu sa. A ye ka tsəvay. Tsəvay niye na, andza lar. Tə pa na mədahaŋ i Lazar na, a lar niye. Ta dərəzl me i tsəvay niye na, ta beber bagwar eye. ");
INSERT INTO meq_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu a gwaɗatay: «Həndəkum faya abəra beber nakay.» Marta malamar i mədahaŋ niye a gwaɗay: «Bəy Maduweŋ, kə ge ma tsəvay məhəne faɗ tuk na, anəke na, ma ziye bəɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu a mbəɗay faya, a gwaɗay: «Na tsikaka bəɗaw? Ka dzala ha ka neŋ na, ka ŋgateye a məzlaɓ i Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ta həndək faya abəra beber niye. Ta həndək faya abəra na, Yesu a zəba ɗəre a mbəlom. A gwaɗ: «Bəba ga na gaka naha sɨsœ haladzay hərwi wu nakə na tsətsah naha fakaya na, ka tsəneŋ na. ");
INSERT INTO meq_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na sər ha wu nakə na tsətsahiye naha fakaya aye na, ka tsəneŋeye na huya. Na tsik wene wene aye na, hərwi ndo neheye kanaŋ ka təv ga aye, tâ dzala ha maa sləra ga ahaya na, nəkar.» ");
INSERT INTO meq_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","A tsikay naha a Mbəlom andza niye na, a zalay a Lazar ta magala, a gwaɗ: «Ndohwaw abəra.» ");
INSERT INTO meq_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tsa na, Lazar a ndohwaw abəra. A ndohway na, tə petekeɗ niye tə pa na ka bo a tsəvay aye tebiye. Həlay tə sik ŋgay hay mambəkwa eye ada gər ŋgay mambəkwa eye dərmak. Yesu a gwaɗatay: «Pəlum faya abəra petekeɗ niye ada kâ gərum ha mâ ye ŋgway.» ");
INSERT INTO meq_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ndo neheye ta ye mata gayaw azekw a Mari ada ta ŋgatay a masuwayaŋ niye Yesu a ge aye na, ndo hay haladzay ta dzala ha ka Yesu. ");
INSERT INTO meq_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ane tuk na, ndo siye hay ti ye ka təv i Farisa hay. Ti ye naha ta təkəratay wu nakə Yesu a ge aye. ");
INSERT INTO meq_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom hay ta Farisa hay tə hayay gər a bagwar i Yahuda hay tebiye. Tə haya gər na, tə gwaɗ: «Ndo nakay na, faya ma giye masuwayaŋ hay haladzay huya. Ka gakweye ha na, kəkay? ");
INSERT INTO meq_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Taɗə ka gərakwa ha andza niye na, ndo hay tebiye ta dzaliye ha faya. Ndo hay tebiye ta pay bəzay na, ndo i Roma hay ta deyeweye ta mbəzliye ha gay i məɗəslay ha gər a Mbəlom ada ta bəbazliye tay ha ndo kway hay.» ");
INSERT INTO meq_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ndoweye andaya mə walaŋ tay, məzele ŋgay Kayif. Bəy i bagwar i ndo məvəlaway wu a Mbəlom ka viye aye niye na, neŋgeye. A gwaɗatay: «Ka sərum wuray kwa tsekweŋ bay. ");
INSERT INTO meq_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ŋgama ndo nəte mâ mət hərwi ndo hay tebiye tə bəmalə nakə ndo kway hay tebiye ta dziye aye.» ");
INSERT INTO meq_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Wu nakə a tsik aye na, a yaw abəra ma mədzal gər ŋgay bay. Ka viye eye niye na, neŋgeye bagwar i ndo məvəlaway wu a Mbəlom. Hərwi niye Mbəlom a vəlay gədaŋ mətsike ka wu nakə ma giye bo kame aye, Yesu ma mətiye hərwi Yahuda hay tebiye. ");
INSERT INTO meq_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ane tuk na, ma mətiye na, hərwi Yahuda hay ɗekɗek bay. Ma mətiye hərwi ndo i Mbəlom neheye kweye kweye ka məndzibəra tebiye dərmak aye, hərwi ada mâ həla tay ahaya tebiye tâ ndza ka təv eye nəte. ");
INSERT INTO meq_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Hərwi bazlam i Kayif niye a tsik aye na, pat eye niye ta dazlay mapəle tsəveɗ ka məkəɗe na Yesu. ");
INSERT INTO meq_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hərwi niye Yesu a həhalawa na, a bəzawa ha bo parakka mə walaŋ i Yahuda hay sa bay. Ane tuk na, a ye ŋgway dəreŋ a gəma wuray tə zalay Efrayim. Gəma niye na, bəse tə kəsaf. Tə ndza mə ɗəma ta gawla ŋgay hay. ");
INSERT INTO meq_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Magurlom i Yahuda hay nakə tə zalay Pak aye mazlambar kə ndzew. Ndo hay haladzay ti yaw abəra ma gəma hay wal wal, ti ye a Zerozelem. Ti ye na, magurlom niye kə sla zuk bay. Ti ye hərwi ada tâ bara bo andza i kule tay nakə a tsik aye. ");
INSERT INTO meq_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ahəl nakə nəteye mə ɗəma aye na, ta pəla Yesu. Ta tsətsah ka bo mə walaŋ tay ma gay i məɗəslay ha gər a Mbəlom niye, tə gwaɗ: «Ma deyeweye a magurlom bəɗaw? Ka dzalum na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tə tsik andza niye na, hərwi bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta Farisa hay tə gwaɗ: «Ndoweye kə sər təv i Yesu nakə neŋgeye mə ɗəma aye na, mâ ɗatay ha hərwi ada ta diye faya ta gəsiye na.» ");
INSERT INTO meq_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Məhetse i magurlom i Pak a zəkaw məhəne məkwa na, Yesu a mbəɗa gər, a ye a gəma i Betani. Betani na, gəma nakə Lazar mandza eye mə ɗəma aye. Lazar na, ndo nakə Yesu a mbəl ha abəra ma mədahaŋ aye. ");
INSERT INTO meq_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yesu a husa naha a Betani na, tə day wu mənday. Marta na, neŋgeye faya ma vəleye wu mənday a Yesu. Lazar na, neŋgeye mə walaŋ i ndo neheye tə nda wu mənday dziye tə Yesu aye. ");
INSERT INTO meq_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ahəl nakə faya ta ndiye wu mənday aye na, Mari a zla dos maraha eye tə mal nakə a ze huŋŋa aye. Mal niye na, tsakala eye haladzay. Mal niye na, tə ge ta dərizl i gərɗaf aye andaya tə zalay nardi. A zla mal niye, a mbəɗa ka sik i Yesu. A takaɗ na mal niye ta məkwets i gər ŋgay. Məze i mal niye huŋŋa eye a rah a gay niye nəteye mə ɗəma aye. ");
INSERT INTO meq_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yudas Iskariyot na, neŋgeye nəte mə walaŋ i gawla i Yesu hay, neŋgeye ma ta giye ɗaf ka Yesu. A ŋgatay a mal niye Mari a mbəɗa ka sik i Yesu aye na, a gwaɗ: ");
INSERT INTO meq_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Ass! Ta səkəm ha mal niye bay na, hərwi mey? Haɓe ta səkəm ha na, ka hutakweye ha suloy haladzay segey? Ada dala eye na, ta sliye məvəlatay a mətawak hay bəɗaw!» ");
INSERT INTO meq_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","A tsik andza niye na, hərwi neŋgeye məkal. Maa gəsa ha dala na, neŋgeye. Ane tuk na, a həlawa faya abəra ka dala aye niye. A dzala andza niye na, ka mətawak hay ɗekɗek bay. ");
INSERT INTO meq_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu a gwaɗay: «Gər ha ŋgwas nakay na, səfek. A ge andza niye na, hərwi neŋgeye a ge fagaya na, wu nakə ta zliye ga ha a bəɗ aye. ");
INSERT INTO meq_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ndo i mətawak hay na, nəteye ka təv kurom huya. Ane tuk na, neŋ na, na ndziye tə nəkurom huya bay.» ");
INSERT INTO meq_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yahuda hay haladzay tə tsəne Yesu neŋgeye ma Betani na, tə həl bo ti ye. Ti ye na, ka təv i Yesu ɗekɗek bay. Ti ye na, a satay məŋgatay a Lazar nakə Yesu a mbəl abəra ma mədahaŋ aye. ");
INSERT INTO meq_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hərwi niye bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye tə haya gər hərwi a satay məkəɗe na Lazar dərmak. ");
INSERT INTO meq_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","A satay məkəɗe na Lazar na, hərwi ndo hay haladzay tə patay bəzay sa bay, tə dzala ha ka Yesu hərwi ŋgay. ");
INSERT INTO meq_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tədœ eye na, ndo neheye haladzay ti ye naha a magurlom i Pak aye na, tə tsəne Yesu faya ma diye naha a Zerozelem dərmak. ");
INSERT INTO meq_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ti ye tə ɗəsaw hawal i gərɗaf wuray a ndzəkit bo təɓah məgəse ha mə həlay. Ti ye mata dzəgər tə Yesu ka tsəveɗ. Ahəl nakə faya ta diye na, ta wuda, tə gwaɗ: «Zambaɗakway a Mbəlom! Mbəlom mâ pa ŋgama ka ndo nakə faya ma deyeweye ta məzele i Bəy Maduweŋ aye! Mbəlom mâ pa ŋgama ka Bəy i Israyel hay!» ");
INSERT INTO meq_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu a ŋgatay a zuŋgo wuray na, a ndza faya andza nakə mawatsa eye mə Ɗerewel i Mbəlom, Mbəlom a gwaɗ: ");
INSERT INTO meq_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Nəkar gəma i Zerozelem, kâ dzədzar bay! Zəba, bəy yak faya ma diye naha mandza eye ka zuŋgo wawa eye.» ");
INSERT INTO meq_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ahəl niye na, gawla i Yesu hay tə sər bazlam niye a tsik ka Yesu na, tə sər zuk bay. Ahəl nakə Mbəlom a bəz ha məzlaɓ i Yesu, a matayaw a gər aye na, bazlam i Mbəlom kə tsik faya andza niye deɗek ada ndo hay tə ge andza niye dərmak. ");
INSERT INTO meq_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ahəl nakə Yesu a zalay naha a Lazar a tsəvay, a mbəl ha abəra ma mədahaŋ aye na, ndo hay andaya haladzay ka təv eye niye. Ndo niye hay ta təkər wu nakə tə ŋgatay Yesu a ge aye a ndo hay. ");
INSERT INTO meq_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Hərwi niye ndo hay haladzay ti ye mata dzəgər tə Yesu. Ndo niye hay tə tsəne Yesu na, kə ge masuwayaŋ niye. ");
INSERT INTO meq_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Farisa hay tə ŋgatay andza niye na, tə tsik mə walaŋ tay, tə gwaɗ: «Zəbum kwa, wu nakə faya ka gakweye tebiye na, ma gakweye ŋgama bay! Ndo hay tebiye ta pay bəzay.» ");
INSERT INTO meq_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ahəl nakə ndo hay ti ye a magurlom i Pak mata ɗəslay ha gər a Mbəlom aye na, Gərek hay andaya mə walaŋ tay. ");
INSERT INTO meq_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Gərek niye hay ti ye ka təv i Filip. Filip neŋgeye ndo i gəma i Betesayda ka dala i Galile. Ti ye naha tə gwaɗay a Filip: «Ŋgalaka, a samay məŋgatay a Yesu tey.» ");
INSERT INTO meq_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip a tsəne na, a ye a tsikay a Aŋdəre. Tsa na, ti ye tə tsikay a Yesu. ");
INSERT INTO meq_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu a gwaɗatay: «Həlay eye kə sla anəke tuk, Mbəlom ma ɗatay ha məzlaɓ ga i neŋ Wawa i Ndo, a ndo hay.» ");
INSERT INTO meq_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yesu a gwaɗatay sa: «Sərum ha na, ta sləga hulfe i wu nəte a bəɗ bay na, ma ndziye andza niye ma səkahiye bay. Taɗə ta sləga na, ma ndzohwiye. Nakay a ndzohwaw abəra aye na, ma gəliye ada ma giye wur haladzay. ");
INSERT INTO meq_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ndoweye ka wuɗa sifa ŋgay na, ma dziye ha ɗuh. Ndoweye ka kərah məgay gər a sifa ŋgay hərwi ga na, ma hutiye sifa nakə ma ndəviye bay aye. ");
INSERT INTO meq_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Taɗə kə say a ndoweye məgeŋ məsler na, mâ peŋ bəzay. Andza niye ndo i məsler ga na, ma ndziye ka təv nakə neŋ na ndziye mə ɗəma aye dərmak. Ndo nakə ma geŋeye məsler aye na, Bəba ga ma ɗəslay ha gər.» ");
INSERT INTO meq_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesu a gwaɗatay sa: «Anəke na, ɗərev ki ye fagaya abəra. Ada na gwaɗiye na, kəkay? Na gwaɗeye a Bəba: “Bəba ga, zla fagaya abəra ɗəretsətseh nakay tey” na, na tsikiye ɗaw? Aʼay! Na tsikiye andza niye bay, hərwi na yaw ka məndzibəra na, hərwi ada nâ sa ɗəretsətseh nakay. ");
INSERT INTO meq_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Na gwaɗiye ɗuh na, Bəba, ge wu nakə ndo hay ta səriye na na, nəkar bagwar eye.» A tsik andza niye na, mətsike me a tsənew abəra mə mbəlom, a gwaɗ: «Ɓa na mbərəm məɗa ha məzlaɓ ga nakə ndo hay ta ɗəsleŋeye ha gər aye ada na ɗatay ha məzlaɓ ga sa.» ");
INSERT INTO meq_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ndo neheye nəteye haladzay ka təv eye niye, tə tsəne mətsike me niye a tsənew mə mbəlom aye, tə gwaɗ: «Maa ləv na, maləve i mbəlom.» Siye hay tə gwaɗ: «Maa tsikayaw me na, gawla i Mbəlom!» ");
INSERT INTO meq_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ane tuk na, Yesu a mbəɗatay faya, a gwaɗatay: «Mətsike me nakay a tsənew mə mbəlom aye na, hərwi kurom bəna hərwi ga bay. ");
INSERT INTO meq_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nakay na, həlay nakə Mbəlom ma gateye sariya a ndo hay aye tuk. Anəke na, Mbəlom ma həhariye na bəy i məndzibəra nakay. ");
INSERT INTO meq_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Neŋ na, ta gəsiye ga, ta dariye ga ka mayako mazləlmbaɗa eye, ta lətsiye ga ha ka bo ka mbəlom. Ta lətse ga ha na, na zalateye a ndo hay tebiye tâ yaw ka təv ga.» ");
INSERT INTO meq_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu a tsik andza niye na, ka məməte ŋgay. Ma ta mətiye kəkay na, a ɗa ha neŋgeye. ");
INSERT INTO meq_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ndo hay tə gwaɗay: «Mə ɗerewel i Mbəlom na, tə watsa, tə gwaɗ: “Kəriste na, ma ndziye na, huya.” Ada ka gwaɗiye Wawa i Ndo na, ta ta dariye na ka mayako na, ma kəkay? Wawa i Ndo na, way?» ");
INSERT INTO meq_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu a gwaɗatay: «Anəke na, dzaydzay andaya mə walaŋ kurom. Ane tuk na, ma ndziye na, tsekweŋ tsa. Ahəl nakə dzaydzay andaya mba aye na, dum kame hərwi ada ləvoŋ mâ ndzakum a gər həf bay. Hərwi ndo nakə faya ma diye ma ləvoŋ aye na, a sər təv nakə ma diye a ɗəma aye bay. ");
INSERT INTO meq_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ahəl nakə dzaydzay niye faya ma dəviye na, dzalum ha faya hərwi ada kâ tərum ndo i dzaydzay hay.» Yesu a tsik bazlam niye andza niye na, a ye a ŋgaha bo abəra ka nəteye. ");
INSERT INTO meq_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kwa taɗə kə ge masuwayaŋ haladzay ka ɗəre tay bəbay na, Yahuda hay haladzay ta dzala ha faya bay. ");
INSERT INTO meq_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Wu nakay a ge andza niye na, hərwi ada wu nakə Ezay ndo məɗe ha bazlam i Mbəlom a tsik ahəl niye mâ ge bo. A gwaɗ: «Bəy Maduweŋ, maa təma bazlam yak nakə nəmaa ɗa ha aye na, way? Bəy Maduweŋ, ka bəzay ha gədaŋ yak na, a way?» ");
INSERT INTO meq_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Hərwi niye ndo hay tə dzala ha ka Yesu bay na, hərwi mey? Ezay a gwaɗ: ");
INSERT INTO meq_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Mbəlom ka təra tay ha guluf eye hay, ka dərəzlatay ka metsehe tay. A satay məŋgatay tə ɗəre bay, a satay məsəre tə metsehe tay bay. Taɗə a satay mambəɗe ha mede tay na, na təmiye tay ha dərmak.» ");
INSERT INTO meq_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ezay a tsik wu niye na, hərwi neŋgeye kə ŋgatay a məzlaɓ i Yesu ada a tsikawa faya. ");
INSERT INTO meq_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kwa Ezay kə tsik andza niye bəbay na, bagwar i Yahuda hay haladzay ta dzala ha ka Yesu. Ane tuk na, tə dzala ha ka Yesu na, ta məkal. Ta ɗa ha bay hərwi ta dzədzaray a Farisa hay. Ta dzədzar na, hərwi ta həhariye tay abəra mə gay i maɗuwule me tay. ");
INSERT INTO meq_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","A satay na, ndo tâ zambaɗatay, ɗuh Mbəlom mâ zambaɗatay bay. ");
INSERT INTO meq_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ma dəba eye na, Yesu a wuda kələrra, a gwaɗ: «Ndoweye kə dzala ha ka neŋ na, ta deɗek a dzala ha ka neŋ bay. Ane tuk na, a dzala ha na, ka ndo nakə a sləra ga ahaya aye. ");
INSERT INTO meq_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ndoweye kə ŋgeteŋ na, a ŋgatay a ndo nakə a sləra ga ahaya aye. ");
INSERT INTO meq_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Neŋ na, na yaw ka məndzibəra andza dzaydzay nakə a dəv aye, hərwi ada kwa way kə dzala ha ka neŋ na, ma ndziye ma ləvoŋ sa bay. ");
INSERT INTO meq_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","«Taɗə ndoweye kə tsəne bazlam nakay ada kə pay bəzay bay na, mata gay sariya na, neŋ bay. Hərwi neŋ na yaw ka məndzibəra na, mata gatay sariya a ndo hay bay, ane tuk na, hərwi mətəme tay ha. ");
INSERT INTO meq_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Taɗə ndoweye ka təma ga bay ada ka kərah bazlam ga na, sariya ma ta gəsiye na. Sariya ma ta gəsiye na pat nakə məndzibəra ma ndəviye na, hərwi a kərah bazlam ga. ");
INSERT INTO meq_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","«Andza niye, bazlam nakay na tsik aye na, na tsik ta mədzal gər ga bay. Ane tuk na, maa gweɗeŋ tsik nakay na, Bəba ga nakə a sləra ga ahaya aye. ");
INSERT INTO meq_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ada na sər wu nakə a gweɗeŋ aye na, ma vəliye sifa nakə ma ndəviye bay a ndo hay. Andza niye wu nakə na tsikiye aye na, na tsik na, andza nakə Bəba ga a gweɗeŋ tsik aye.» ");
INSERT INTO meq_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Həlay i magurlom i Pak mazlambar kə husaw a ɗəma. Yawa! Yesu a sər həlay ŋgay nakə ma diye abəra ka məndzibəra aye kə sla. Ma miye ŋgway ka təv i Bəba ŋgay. Yesu a wuɗa ndo ŋgay neheye ka məndzibəra aye huya. Anəke Yesu ka bəzatay ha na, a wuɗa tay ha tə ɗərev ŋgay peteh. ");
INSERT INTO meq_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pat eye niye ta huwa na, Yesu ta gawla ŋgay faya ta ndiye ɗaf. Ɓa Fakalaw ka mbərəm məvəlay bazlam a Yudas wawa i Simoŋ Iskariyot hərwi ada mâ ge ɗaf ka Yesu. ");
INSERT INTO meq_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu a sər ha Bəba ŋgay kə vəlay gədaŋ ka mələve wu hay tebiye. Yesu a sər ha neŋgeye a yaw abəra ka təv i Mbəlom ada ma miye na, ka təv i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Hərwi niye Yesu a gər ha mənde wu mənday, a lətse. A tsəkw ka bo abəra petekeɗ. A ye naha a zla petekeɗ i matekeɗe yam abəra ka bo, a ɓar ha bəzay i huɗ. ");
INSERT INTO meq_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ma dəba aye na, a mbəɗa yam a gandayah. Tsa na, a dazlay məbere tay na sik a gawla ŋgay hay. A ndəv ha məbere tay na sik na, a pəla haya petekeɗ matekeɗe yam niye abəra mə bəzay i huɗ, a takaɗ yam abəra ka sik. ");
INSERT INTO meq_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","A ndisl ka təv i Simoŋ Piyer na, Simoŋ Piyer a gwaɗay: «Bəy Maduweŋ, mata bereŋ na sik ɗuh na, nəkar ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu a mbəɗay faya, a gwaɗay: «Wu nakə faya na giye anəke aye na, ka səriye bay, ane tuk na, ka səriye mba.» ");
INSERT INTO meq_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piyer a gwaɗay: «Aʼay! Ka ta bereŋeye na sik ɗaɗa bay.» Yesu a mbəɗay faya, a gwaɗay: «Taɗə na baraka na sik bay na, ka dzapameye nəte tə nəkar sa bay.» ");
INSERT INTO meq_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoŋ Piyer a tsəne andza niye na, a gwaɗay: «Bəy Maduweŋ, kâ bereŋ na sik ɗekɗek tsa bay. Bereŋ na həlay ga hay ta gər ga dərmak.» ");
INSERT INTO meq_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu a gwaɗay: «Ndo nakə kə bara na bo ŋgay aye na, ndəluɓ andaya ka bo ŋgay bay. Ma bariye bo sa bay. Ma bariye na, sik ɗekɗek tsa. Nəkurom, ndəluɓ andaya fakuma bay, nəkurom tsəɗaŋŋa. Ane tuk na, ndo nəte na, ndəluɓ faya.» ");
INSERT INTO meq_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu a sər ndo nakə ma ta giye faya ɗaf aye. Hərwi niye a gwaɗ nəteye tebiye mabara eye hay bay. ");
INSERT INTO meq_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","A ndəv ha məbaratay na sik na, a zla petekeɗ ŋgay a ma ha ka bo. A ye, a ma ka təv mənde ɗaf tay niye, a ndza. Tsa na, a gwaɗatay: «Ka sərum wu nakə na gakum aye ɗaw? ");
INSERT INTO meq_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nəkurom faya ka zalumeŋeye “ndo mədzeŋge ndo” ada “Bəy Maduweŋ”. Ka tsikum andza niye na, lele deɗek. Neŋ na, andza niye deɗek. ");
INSERT INTO meq_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Neŋ ɗuh ndo mədzeŋge ndo ada Bəy Maduweŋ, na barakum na sik, nəkurom dərmak kutoŋ barum sik kurom hay a bo nəte nəte mə walaŋ kurom. ");
INSERT INTO meq_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Na bəzakum ha wu nakə ka gumeye hərwi ada nəkurom dərmak kâ gum a bo mə walaŋ kurom andza nakə neŋ na ge aye. ");
INSERT INTO meq_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ayaw! Sərum ha na, ndo i məsler ma ziye ha ndo i gay ŋgay bay, ada ndo i məsler na, ma ziye ha ndo nakə a slər na aye bay. ");
INSERT INTO meq_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Anəke na, ka sərumeye ha tuk. Taɗə ka gum ha məsler tə wu neheye na, ka hutumeye məŋgwese. ");
INSERT INTO meq_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Na tsik na, ka nəkurom tebiye kurom aye bay. Neŋ na, na sər ndo neheye na pala tay aye. Ane tuk na, bazlam nakə tə watsa mə Ɗerewel i Mbəlom aye na, ma giye bo andza nakə tə watsa aye. Mawatsa eye na, a gwaɗ: “Ndo nakə nəmaa nda ɗaf salamay aye na, ka təra ndo məne ɗəre ga.” ");
INSERT INTO meq_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Na tsikakum ka bo abəra anəke na, hərwi ada wu nakay aza kə husaw na, ka dzalumeye ha neŋ na, neŋ. ");
INSERT INTO meq_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","«Neŋ faya na tsikakumeye parakka: Sərum ha, ndoweye ka təma ndo nakə neŋ na slər ha aye na, a təma na, neŋ dərmak. Ada ndo nakə ka təma ga aye na, a təma na, ndo nakə a sləra ga ahaya aye.» ");
INSERT INTO meq_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ma dəba i bazlam niye Yesu a tsik aye na, ɗərev ŋgay a ye faya abəra. A tsikatay parakka, a gwaɗatay: «Neŋ faya na gwaɗakumeye: Sərum ha na, ndo nəte mə walaŋ kurom ma giye fagaya ɗaf.» ");
INSERT INTO meq_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Gawla ŋgay hay tə tsəne andza niye na, tə ma ha ka bo ɗəre mə walaŋ tay tebiye. Ane tuk na, Yesu a tsik ka way na, tə sər kwa tsekweŋ bay tebiye. ");
INSERT INTO meq_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ndo nəte mə walaŋ i gawla i Yesu hay, ndo nakə Yesu a wuɗa na haladzay aye, neŋgeye mandza eye ka təv i Yesu. ");
INSERT INTO meq_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoŋ Piyer a gay naha mbətsekw tə ɗəre hərwi ada mâ tsətsah ka Yesu, a tsik andza niye na, ka way. ");
INSERT INTO meq_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mandərkwasla i Yesu niye a həndzəɗ naha gər ka təv i Yesu, a tsətsah faya, a gwaɗay: «Bəy Maduweŋ, ka tsik na, ka way?» ");
INSERT INTO meq_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu a mbəɗay faya, a gwaɗay: «Na ɗəsiye peŋ ada na giye faya ala. Ndo nakə na vəlay aye na, mata ge fagaya ɗaf na, neŋgeye.» Tsa na, Yesu a ɗəs peŋ, a ge faya ala, a vəlay a Yudas wawa i Simoŋ Iskariyot. ");
INSERT INTO meq_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudas a təma peŋ niye na, kwayaŋŋa Fakalaw a yay a mədzal gər. Yesu a gwaɗay: «Wu nakə ka giye na, ge na anəke bəse!» ");
INSERT INTO meq_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ndo neheye nəteye mandza eye tage Yesu aye, Yesu a tsik andza niye hərwi mey na, ndəray kwa nəte mə walaŋ tay niye a sər bay. ");
INSERT INTO meq_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudas na, neŋgeye ndo məgəse suloy. Hərwi niye siye i gawla i Yesu hay tə dzala na, Yesu a gwaɗay mâ ye mata səkəmakwayaw wu mənday hərwi magurlom i Pak. Kəgəbay a gwaɗay mâ ye mâ vəlatay wu a mətawak hay. ");
INSERT INTO meq_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ahəl nakə Yudas a təma peŋ niye na, kwayaŋŋa a yaw abəra. Niye na, ta həvaɗ. ");
INSERT INTO meq_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ma dəba eye Yudas a yaw abəra na, Yesu a gwaɗ: «Anəke na, məzlaɓ ga i Wawa i Ndo ma bəziye parakka ada ndo hay ta ŋgateye a məzlaɓ i Mbəlom hərwi ga dərmak. ");
INSERT INTO meq_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na bəzatay ha məzlaɓ i Mbəlom a ndo hay, Mbəlom dərmak ma bəzatay ha məzlaɓ i wawa ŋgay a ndo hay tə wu nakə faya ma giye aye. Ma giye mahonok mabəzatay ha bay. ");
INSERT INTO meq_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Wawa ga hay, na ndziye tə nəkurom haladzay sa bay. Na ye fakuma abəra na, ka pəlumeye ga. Ane tuk na, wu nakə na tsikatay a bagwar i Yahuda hay aye na, na tsikakumeye anəke. “Təv nakə neŋ na diye a ɗəma aye na, ka slumeye faya mede a ɗəma bay.” ");
INSERT INTO meq_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Na tsikakumeye bazlam mapala eye weɗeye. Bazlam mapala eye weɗeye na, waray? Wuɗum bo nəte nəte mə walaŋ kurom. Andza neŋ nakə na wuɗa kurom aye na, kutoŋ wuɗum bo nəte nəte mə walaŋ kurom dərmak. ");
INSERT INTO meq_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Taɗə ka wuɗum bo nəte nəte mə walaŋ kurom na, ndo hay tebiye ta səriye ha nəkurom gawla ga hay.» ");
INSERT INTO meq_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoŋ Piyer a tsətsah faya, a gwaɗay: «Bəy Maduweŋ, ka diye na, a ŋgay?» Yesu a mbəɗay faya, a gwaɗay: «Anəke na, ka sliye faya məpeŋ bəzay a təv nakə na diye a ɗəma aye bay. Ane tuk na, həlay eye ma slaweye aza ka peŋeye bəzay.» ");
INSERT INTO meq_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piyer a gwaɗay: «Bəy Maduweŋ, na sliye faya məpaka bəzay anəke bay na, hərwi mey? Neŋ maləva bo eye məvəle ha məsəfəre ga hərwi yak.» ");
INSERT INTO meq_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu a mbəɗay faya, a gwaɗay: «Nəkar maləva bo məvəle ha məsəfəre yak hərwi ga ta deɗek ŋgway ɗaw? Na tsikakeye parakka, sər ha na, dzagulok ma ta zlahiye na, ɓa ka gwaɗ sik mahkar ka sər neŋ bay.» ");
INSERT INTO meq_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu a gwaɗatay a gawla ŋgay hay: «Ɗərev mâ ye fakuma abəra bay. Dzalum ha ka Mbəlom ada dzalum ha ka neŋ dərmak. ");
INSERT INTO meq_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Gay hay andaya haladzay mə gay i Bəba ga. Taɗə təv andaya bay na, haɓe na gwaɗakumeye bəɗaw? Na diye na ta lambaɗakumeye təv nakə ka ta ndzumeye mə ɗəma aye. ");
INSERT INTO meq_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na ye, na lambaɗakumaw təv na, na maweye mata həle kurom ka təv ga, hərwi ada nəkurom dərmak ka ndzumeye ma təv nakə neŋ mə ɗəma aye. ");
INSERT INTO meq_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nəkurom na, ka sərum tsəveɗ nakə a ye a təv nakə na diye a ɗəma aye.» ");
INSERT INTO meq_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas a gwaɗay: «Bəy ga, təv nakə ka diye a ɗəma aye na, nəmaa sər bay. Nəmaa sliye faya məsəre tsəveɗ niye na, ma kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu a mbəɗay faya, a gwaɗay: «Neŋ na, tsəveɗ, deɗek ada sifa. Ndoweye ki yaw ta təv ga bay na, ma sliye faya mede ka təv i Bəba ga bay. ");
INSERT INTO meq_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Taɗə ka sərum neŋ na, ka sərumeye Bəba ga dərmak. Kwa anəke ka sərum na ka ŋgatumay.» ");
INSERT INTO meq_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip a gwaɗay: «Bəy ga, ɗamay ka Bəba yak tsa na, tsɨy ɗa may.» ");
INSERT INTO meq_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu a mbəɗay faya, a gwaɗay: «Na ndza ka təv kurom na, haladzay ada ka sər ga ha bay ŋgway huya ɗaw Filip? Ndoweye kə ŋgeteŋ a neŋ na, a ŋgatay na, a Bəba ga. Ada ka gwaɗ: “Ɗamay ka Bəba yak” na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Neŋ ta Bəba ga, nəmay mandza eye nəte na, ka dzala ha təbəɗew? Bazlam neheye na tsikawakum a nəkurom tebiye na, ti yaw abəra mə neŋ ɗekɗek bay. Na tsik na, i Bəba ga nakə nəmay mandza eye nəte aye. Maa ge məsler mə neŋ na, neŋgeye. ");
INSERT INTO meq_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Taɗə na gwaɗakum: “Neŋ ta Bəba, Bəba ga tə neŋ, nəmay nəte” na, dzalum ha faya. Dzalum ha ka məsler neheye na gawa aye kwa. ");
INSERT INTO meq_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","«Ayaw! Neŋ faya na gwaɗakumeye: Sərum ha na, ndoweye kə dzala ha ka neŋ na, ma giye məsler neheye neŋ faya na giye dərmak. Ma ta giye na, ma ziye neheye anəke aye, hərwi neŋ na, na diye ka təv i Bəba ga. ");
INSERT INTO meq_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ka tsətsahum kwa mey ta məzele ga na, na gakumeye na tebiye, hərwi ada neŋ Wawa i Mbəlom nâ bəz ha məzlaɓ i Bəba. ");
INSERT INTO meq_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ka tsətsahum kwa mey ta məzele ga na, na vəlakumeye.» ");
INSERT INTO meq_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesu a gwaɗatay sa: «Taɗə ka wuɗum ga na, ka rəhumeye ha gər a bazlam ga mapala eye. ");
INSERT INTO meq_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Neŋ, na geye amboh a Bəba ga mâ slərakumaw ndo mekeleŋ mâ dzəna kurom hərwi ada mâ ndza huya ka təv kurom. ");
INSERT INTO meq_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ma slərakumaweye na, Məsəfəre nakə ma ɗakumeye ha deɗek aye. Məndzibəra na, ma sliye faya məhute təbey hərwi kə ŋgatay bay, ma səriye na bay sa. Nəkurom na, ka sərumeye hərwi ma ndziye na, ka təv kurom ada ma ndziye huya mə nəkurom. ");
INSERT INTO meq_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Hərwi niye, na gəriye kurom ha mahəkuromeye andza wur mətawak hay bay. Na maweye ka təv kurom. ");
INSERT INTO meq_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ma məndze tsekweŋ na, ndo i məndzibəra hay ta ŋgeteŋeye sa bay. Nəkurom na, ka ta ŋgatumeŋeye hərwi neŋ na ndziye ta sifa ga huya ada nəkurom dərmak ka ndzumeye ma sifa huya. ");
INSERT INTO meq_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pat eye niye na, ka sərumeye neŋ madzapa eye ta Bəba ga, nəkurom madzapa eye tə neŋ ada neŋ madzapa eye tə nəkurom. ");
INSERT INTO meq_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«Ndoweye kə pa na bazlam ga mapala eye a gər, ada ka rəhay ha gər na, neŋgeye na, a wuɗa ga. Bəba ga ma wuɗiye na ndo nakə a wuɗa ga aye, neŋ dərmak na wuɗiye na ada na bəzay ha bo ga.» ");
INSERT INTO meq_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Gawla i Yesu andaya məzele ŋgay Yuda. Neŋgeye na, Yudas Iskariyot bay. A gwaɗay a Yesu: «Bəy ga, ka bəziye ha bo a nəmay ɗekɗek, ka bəziye ha bo a ndo i məndzibəra hay bay na, ma giye bo ma kəkay?» ");
INSERT INTO meq_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu a mbəɗay faya, a gwaɗay: «Ndoweye ka wuɗa ga na, ma rəheye ha gər a bazlam ga. Bəba ga ma wuɗiye na. Nəmaa deyeweye ka təv ŋgay. Neŋ ta Bəba nəmaa ndziye mə gay ŋgay. ");
INSERT INTO meq_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ndo nakə a wuɗa ga bay aye na, ma rəheye ha gər a bazlam ga bay. Kâ mətsum ha gər tə wu nakə na tsik aye bay. Wu nakə ka tsənum na tsik aye na, a yaw mə neŋ bay. A yaw na, ka təv i Bəba ga neŋgeye nakə a sləra ga ahaya aye. ");
INSERT INTO meq_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Na tsikakum ka bo abəra bazlam nakay anəke na, hərwi neŋ andaya ka təv kurom mba. ");
INSERT INTO meq_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mazlambar Bəba ga ma sləraweye Məsəfəre Tsəɗaŋŋa eye a bərəm ga, ma dzəniye kurom. Neŋgeye na, ma tətikakumeye wu hay tebiye ada bazlam ga neheye na tsikawakum aye na, mâ makum ahaya a gər tebiye. ");
INSERT INTO meq_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Anəke na diye gwa na, na vəlakumeye məndze zay a ɗərev kurom. Məndze nakə ɗərev kurom ma ndziye zay aye na, na vəlakumeye andza i məndzibəra bay. Ɗərev mâ ye fakuma abəra bay. Kâ dzədzarum bay. ");
INSERT INTO meq_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ɓa ka tsənum, na gwaɗakum: Na diye gwa. Ane tuk na, na maweye ka təv kurom. Taɗə ka wuɗum ga na, ka ŋgwasumeye hərwi na diye na, ka təv i Bəba ga. Bəba ga, neŋgeye na, bagwar eye a ze ga. ");
INSERT INTO meq_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","«Wu neheye ta ndislew zuk bay. Na tsikakum ka bo abəra anəke na, hərwi ada aza ta ndislew na, kâ dzalum ha ka wu neheye na tsikakum aye. ");
INSERT INTO meq_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Na ta tsikakumeye wuray andaya haladzay sa bay. Na tsikakumeye wuray haladzay sa bay na, hərwi mey? Hərwi bəy i ndo i məndzibəra hay faya ma deyeweye. Ane tuk na, gədaŋ ŋgay andaya kwa tsekweŋ mələve ga bay. ");
INSERT INTO meq_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ane tuk na, ndo i məndzibəra hay tâ sər ha na, na wuɗa Bəba ga ada neŋ faya na giye andza nakə Bəba a gweɗeŋ ge aye. «Anəke na, lətsum takwa abəra kanaŋ!» ");
INSERT INTO meq_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu a gwaɗatay a gawla ŋgay hay sa: «Neŋ na, andza dərizl i gərɗaf deɗek eye. Bəba ga na, a təra andza ndo i guvah. ");
INSERT INTO meq_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Hawal neheye tə wa bay aye na, ma ɗəsiye tay ha. Hawal neheye tə wa aye na, ma kəkaliye fataya abəra hərwi ada tâ wa hohway haladzay. ");
INSERT INTO meq_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Wu neheye na tətikakum aye na, ka təra kurom ha tsəɗaŋŋa, andza dərizl i gərɗaf nakə ta kəkal na aye. ");
INSERT INTO meq_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ndzum na, madzapa eye ka neŋ andza neŋ nakə madzapa eye tə nəkurom aye. Hawal kə ge neŋgeye ka dərizl ŋgay eye bay na, ma sliye faya məwe ka gər bo ŋgay bay, mâ ndza ka dərizl ŋgay. Andza niye, nəkurom ka dzapum tə neŋ bay na, ka mbumeye faya məge wuray lele eye bay.» ");
INSERT INTO meq_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yesu a gwaɗatay sa: Neŋ na, andza dərizl i gərɗaf, nəkurom hawal eye hay. Ndoweye kə dzapa tə neŋ ada na dzapa ta neŋgeye na, ma wiye hohway haladzay andza dərizl i gərɗaf. Hərwi ze neŋ na, ka slumeye məge wuray lele eye bay. ");
INSERT INTO meq_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ndoweye kə dzapa tə neŋ bay na, Mbəlom ma kərahiye na. Ma təriye andza hawal i dərizl i gərɗaf nakə tə ɗəs faya abəra aye. Ta kaliye ha ada ma kuliye. Kə kula na, ta hayay gər ada ta dziye a ako, ma təmiye. ");
INSERT INTO meq_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","«Taɗə ka ndzum nəkurom madzapa eye ka neŋ ada ka pum na bazlam ga a ɗərev na, tsətsahum wu nakə a sakum aye, ka hutumeye. ");
INSERT INTO meq_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Taɗə faya ka gumeye ŋgwalak huya na, faya ka bəzumatay ha a ndo hay, nəkurom gawla ga hay. Kə ge andza niye na, ndo hay ta zambaɗeye a Bəba ga. ");
INSERT INTO meq_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","«Na wuɗa kurom andza nakə Bəba a wuɗa ga aye. Ndzum huya madzapa eye ka neŋ ada ka sərumeye ha na, na wuɗa kurom. ");
INSERT INTO meq_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Taɗə ka rəhumay ha gər a bazlam ga mapala eye na, ka ndzumeye nəkurom madzapa eye ka neŋ ada ka sərumeye ha na wuɗa kurom huya, andza neŋ nakə na rəhay ha gər a bazlam i Bəba ga mapala eye ada neŋ madzapa eye tə neŋgeye ada na sər ha a wuɗa ga huya. ");
INSERT INTO meq_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Na tsikakum wu neheye na, hərwi ada ɗərev kurom mâ ŋgwasa andza neŋ nakə ɗərev ga maŋgwasa eye dərmak. Andza niye məŋgwese ma rahiye a ɗərev kurom lele. ");
INSERT INTO meq_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","«Bazlam ga nakə na tsikakumeye na, waray? Bazlam nakə na tsikakumeye na, wuɗum bo nəte nəte mə walaŋ kurom andza neŋ nakə na wuɗa kurom aye. ");
INSERT INTO meq_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ndoweye kə dze ha məsəfəre ŋgay hərwi dzam ŋgay hay na, mawuɗe bo maze niye na, andaya sa bay. ");
INSERT INTO meq_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Taɗə ka gum wu nakə na gwaɗum gum aye na, nəkurom dzam ga hay. ");
INSERT INTO meq_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Na zalakumeye ndo i məsler ga hay sa bay hərwi ndo i məsler na, a sər wu nakə ndo i gay ŋgay ma giye bay. Ɗuh na zalakumeye dzam ga hay hərwi na ɗakum ha wu nakə Bəba a ɗeŋ ha aye tebiye. ");
INSERT INTO meq_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nəkurom ka zlum ga bay. Ɗuh maa pala kurom na, neŋ hərwi ada kâ pumeŋ bəzay. Na slər kurom ha dərmak, kâ yum mata ge wu nakə lele eye ada wu niye lele eye ma ndziye huya. Andza niye, ka tsətsahum wu hay tebiye ta məzele ga na, Bəba ga ma vəlakumeye. ");
INSERT INTO meq_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Wu nakə na tsikakumeye anəke aye na, wuɗum bo nəte nəte mə walaŋ kurom.» ");
INSERT INTO meq_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesu a gwaɗatay sa: «Taɗə ndo i məndzibəra ta nakum ɗəre na, sərum ha ɓa kurre tə nay ɗəre na, a neŋ. ");
INSERT INTO meq_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Taɗə nəkurom ndo i məndzibəra hay na, ta wuɗiye kurom hərwi nəkurom ndo tay hay. Ane tuk na, ka təra andza niye bay. Na pala kurom abəra mə walaŋ tay. Nəkurom ka tərum ndo tay hay sa bay. Tə nakum ɗəre na, hərwi nakə nəkurom ndo tay hay sa bay aye. ");
INSERT INTO meq_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","«Kâ mətsum ha gər tə bazlam nakə na tsikakum aye bay. Na gwaɗ ndo i məsler na, a ze ndo i gay ŋgay bay. A seŋ məgwaɗakum na, taɗə ta geŋ ɗəretsətseh na, ta gakumeye ɗəretsətseh a nəkurom dərmak. Ndo neheye ta rəhay ha gər a bazlam ga aye na, ta dzaliye i kurom dərmak. ");
INSERT INTO meq_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ɗəretsətseh nakə ta gakumeye na, hərwi nakə nəkurom gawla ga hay aye. Tə ge andza niye na, hərwi tə sər ndo nakə a sləra ga ahaya aye bay. ");
INSERT INTO meq_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","«Taɗə na yaw na tsikatay bazlam i Mbəlom bay na, sariya ma gəsiye tay ha hərwi mezeleme tay bay. Ane tuk na, anəke na yaw, na tsikatay. Anəke ta sliye faya mətsike “nəmaa sər mezeleme bay” na, ta sliye faya bay. ");
INSERT INTO meq_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ndoweye kə neŋ ɗəre na, a nay ɗəre a Bəba ga dərmak. ");
INSERT INTO meq_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Taɗə ɓa na mbərəm məge məsler neheye ndəray ɗaɗa kə ge bay aye na, haɓe Mbəlom ma gəsiye tay ha a sariya ŋgay bay. Azlakwa anəke na, ta ŋgatay a məsler ga hay ada faya ta namay ɗəre ta bəba ga. ");
INSERT INTO meq_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ane tuk na, a ge andza niye na, hərwi ada mâ təra andza nakə ndo tay hay ta watsa mə Ɗerewel i Mbəlom aye. Tə watsa, tə gwaɗ: “Tə neŋ ɗəre na, kəriye bəna na ge mənese bay.”» ");
INSERT INTO meq_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Yesu a gwaɗatay sa: «Ndo nakə ma deyeweye madzəne kurom aye na, ma deyeweye. Ma deyeweye na, mə həlay i Bəba ga. Na ye ka təv i Bəba ga na, na slərakumaweye. Ndoweye niye na, Məsəfəre Tsəɗaŋŋa aye. Neŋgeye ma ɗateye ha deɗek a ndo hay. Ki yaw na, ma tsikiye ka neŋ. ");
INSERT INTO meq_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nəkurom dərmak ka ta tsikumeye ka neŋ hərwi ahəl nakə na dazlay a məsler aye na, nəkurom tə neŋ hus bəgom.» ");
INSERT INTO meq_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Na tsikakum wu neheye ka bo abəra anəke na, hərwi ada kâ gərum ha mədzele ka neŋ bay. ");
INSERT INTO meq_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ta ta həhara kurom ahaya abəra mə gay i maɗuwule me. Həlay eye ma deyeweye, ndo hay ta kəɗiye kurom, ada ta dzaliye mə gər tay na: “Nəmaa ge na, wu nakə a yay a gər a Mbəlom aye.” ");
INSERT INTO meq_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ta giye andza niye na, hərwi nəteye tə sər Bəba ga bay ada tə sər neŋ bay. ");
INSERT INTO meq_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Na tsikakum ka bo abəra anəke na, hərwi ada ahəl nakə faya ta gakumeye andza niye na, bazlam nakə na tsikakum aye mâ makumaw a gər.» Yesu a gwaɗatay sa: «Na tsikakum kurre bay na, hərwi neŋ ka təv kurom mba. ");
INSERT INTO meq_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Anəke na, na miye gwa ka təv i ndo nakə a sləra ga ahaya aye. Ndəray kwa nəte mə walaŋ kurom ma tsətsahiye təv ga nakə na diye a ɗəma aye bay. ");
INSERT INTO meq_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ane tuk na, ma ndalakumeye haladzay hərwi nakə na gwaɗakum na, na diye gwa aye. ");
INSERT INTO meq_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ayaw! Sərum ha lele, na ye fakuma abəra ɗuh i kurom na, lele. Andza niye taɗə na ye gwa bay na, ndo nakə ma deyeweye mata dzəne kurom aye na, ma deyeweye sa bay. Ane tuk na, na ye na, na sləra ahaya. ");
INSERT INTO meq_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","«Ki yaw na, ma bəzatay ha a ndo i məndzibəra hay na, nəteye faya ta giye mezeleme, ma bəzatay ha tsəveɗ nakə deɗek aye, ada ma bəzatay ha sariya i Mbəlom nakə ma ta giye. ");
INSERT INTO meq_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mezeleme nakə ma bəzatay ha aye, a ɗa ha na, nəteye ta dzala ga ha bay. ");
INSERT INTO meq_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ta səriye ha tsəveɗ nakə deɗek eye na, tsəveɗ məpeŋ bəzay a neŋ hərwi na miye ka təv i Bəba ga. Ka ta ŋgatumeŋeye sa bay. ");
INSERT INTO meq_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","A bəzatay ha sariya na, hərwi ɓa Mbəlom kə gəs bəy i məndzibəra nakay a sariya.» ");
INSERT INTO meq_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Yesu a gwaɗatay sa: «Wu neheye na tsikakum zuk bay aye na, andaya haladzay. Ane tuk na, na tsikakum anəke na, ka slumeye faya mətsəne bay. ");
INSERT INTO meq_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Məsəfəre niye ma ɗatay ha tsəveɗ i deɗek a ndo hay. Ki yaw na, ma ɗakumeye ha tsəveɗ niye deɗek eye tebiye. Ma ta tsikiye na, ka gər bo ŋgay bay. Ane tuk na, ma ta tsikiye na, wu nakə a tsənew ka Mbəlom aye. Ma ɗakumeye ha wu nakə ma giye bo kame aye. ");
INSERT INTO meq_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ndo hay ta ɗəsleŋeye ha gər hərwi ŋgay. Hərwi wu neheye ma ɗakumeye ha aye na, ti yaw abəra mə neŋ. ");
INSERT INTO meq_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Wu neheye mə həlay i Bəba ga tebiye na, i ga dərmak. Hərwi niye na gwaɗakum na, wu nakə Məsəfəre ma ta ɗakumeye ha aye na, ma deyeweye abəra na, mə neŋ.» ");
INSERT INTO meq_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesu a gwaɗatay: «Məndze tsekweŋ na, ka ŋgatumeŋeye sa bay. Ada məndze tsekweŋ na, ka ŋgatumeŋeye sa.» ");
INSERT INTO meq_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Siye hay mə walaŋ i gawla ŋgay hay tə tsəne andza niye na, tə gwaɗ mə walaŋ tay: «A say məgweɗe na, kəkay? A gwaɗ: “Məndze tsekweŋ na, ka ŋgatumeŋeye sa bay ada məndze tsekweŋ na, ka ŋgatumeŋeye sa.” Ada a gwaɗakway sa na: “Ka ŋgatumeŋeye sa bay, hərwi na miye ka təv i Bəba” na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Məndze tsekweŋ” niye a tsik aye na, andza məgweɗe mey? Ka sərakwa wu nakə a say mətsike aye bay.» ");
INSERT INTO meq_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu a sər ha a satay a gawla ŋgay hay matsətsehe faya bazlam. A gwaɗatay: «Ka tsikum mə walaŋ kurom na, ka bazlam nakə na gwaɗ “məndze tsekweŋ na, ka ŋgatumeŋeye sa bay ada məndze tsekweŋ na, ka ŋgatumeŋeye sa” ɗaw? ");
INSERT INTO meq_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","«Ayaw! Sərum ha na, ka ta tuwumeye, ka wudumeye ka bo haladzay. Ndo i məndzibəra hay na, ta ŋgwasiye. Ɗərev ma ndalakumeye haladzay, ane tuk na, ɗəretsətseh kurom ma təriye məŋgwese. ");
INSERT INTO meq_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ma giye na, andza məwe wawa nakə a dazlay a ŋgwas aye. Ahəl nakə wawa a dazlay a ŋgwas aye na, ɗərev a ndalay hərwi ɗəretsətseh. Ane tuk na, kə wa na wawa tsɨy na, ma mətsiye ha gər tə ɗəretsətseh. Ma ŋgwasiye hərwi wawa nakə a wa, a yaw ka məndzibəra aye. ");
INSERT INTO meq_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Andza niye nəkurom mə ɗəretsətseh anəke dərmak. Ane tuk na, na ta ŋgatakumeye, ka ta ŋgwasumeye haladzay, ndəray ma sliye faya mabuwe fakuma abəra məŋgwese niye bay. ");
INSERT INTO meq_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«Pat eye niye na, ka ta tsətsahumeye fagaya sa bay. Sərum ha na, kwa mey ka tsətsahum ta məzele ga na, Bəba ma vəlakumeye. ");
INSERT INTO meq_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hus anəke ka tsətsahum wuray ta məzele ga zuk bay. Tsətsahum, ka hutumeye ada məŋgwese ma rahiye a ɗərev kurom lele.» ");
INSERT INTO meq_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesu a gwaɗatay: «Na tsikakum wu neheye tebiye na, ta dzeke. Həlay eye ma deyeweye, na tsikakumeye ta dzeke sa bay. Ane tuk na, na ta tsikakumeye ka gər i Bəba ga parakka. ");
INSERT INTO meq_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Pat eye niye na, ka tsətsahumeye wu hay ka Bəba ga ta məzele ga. Agəla ka gwaɗumeye na, na ta tsətsahiye faya wu hərwi kurom. Aʼay! Bo kurom eye ka tsətsahumeye tə bazlam kurom. ");
INSERT INTO meq_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bəba, bo ŋgay eye a wuɗa kurom. A wuɗa kurom na, hərwi nəkurom ka wuɗum ga ada ka dzalum ha neŋ na yaw na, abəra ka təv i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Na yaw na, ma təv i Bəba ga ada na yaw ka məndzibəra. Anəke na, na gəriye ha məndzibəra, na miye ka təv i Bəba ga.» ");
INSERT INTO meq_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Gawla ŋgay hay tə gwaɗay: «Yawa! Anəke faya ka tsik me na, parakka tuk. Ka tsik ta dzeke sa bay. ");
INSERT INTO meq_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Anəke nəmaa sər ha, ka sər wu hay tebiye. Ndo ma ta tsətsahiye fakaya bazlam na, ɓa ka sər tsɨy. Hərwi niye nəmaa dzala kar ha, nəmaa sər ka yaw na, abəra ka təv i Mbəlom deɗek.» ");
INSERT INTO meq_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu a mbəɗatay faya, a gwaɗatay: «Ka dzalum ha na, anəke ɗaw? ");
INSERT INTO meq_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pat eye ma deyeweye, ɓa ka mbərəm madayaw tsɨy. Pat eye niye na, ka ŋgənumeye gər kweye kweye kwa way ma miye a mətagay ŋgay. Ka gərumeye ga ha mahəgeye. Aʼay! Ta deɗek na, neŋ mahəgeye bay. Bəba ga, neŋgeye tə neŋ. ");
INSERT INTO meq_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","«Na tsikakum wu neheye kurre ada nəkurom neheye madzapa eye tə neŋ aye na, hərwi ada kâ ndzum zay. Ka məndzibəra na, ka gumeye ɗəretsətseh. Ane tuk na, ɗərev mâ ye fakuma abəra bay, hərwi neŋ na, na ŋgwasa ka məndzibəra.» ");
INSERT INTO meq_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu a tsikatay ka bo abəra bazlam niye na, a zəba ɗəre a mbəlom, a gwaɗ: «Bəba ga, i ga na, həlay eye kə husaw tuk. Bəzatay ha məzlaɓ ga a ndo hay ada neŋ wawa yak nâ bəzatay ha məzlaɓ yak dərmak. ");
INSERT INTO meq_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nəkar na, ka vəleŋ gədaŋ ka gər i ndo hay tebiye hərwi ada nâ vəlatay sifa nakə ma ndəviye bay aye a ndo neheye ka vəleŋ tay naha a həlay aye. ");
INSERT INTO meq_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Sifa niye ma ndəviye bay aye na, andza məgweɗe ta sər kar ha, nəkar na, Mbəlom deɗek eye nəte ŋgweŋ, ada ta sər neŋ Yesu Kəriste nakə ka sləratayaw aye. ");
INSERT INTO meq_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","«Ahəl nakə neŋ ka məndzibəra aye na, na ɗa ha məzlaɓ yak a ndo hay, hərwi na ndəv ha məsler nakə ka sləra ga ahaya faya məge aye. ");
INSERT INTO meq_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Anəke na, Bəba ga, vəleŋ məzlaɓ ka ɗəre yak andza məzlaɓ ga ahəl nakə nəmay salamay, məndzibəra andaya zuk bay aye. ");
INSERT INTO meq_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Ndo neheye ka pala tay ha abəra ka məndzibəra aye ada ka vəleŋ tay ha a həlay ga aye, tə sər kar ha na, hərwi ga. Nəteye tebiye na, i yak hay ada ka vəleŋ tay ha a həlay ga. Nəteye faya ta rəhay ha gər a bazlam yak. ");
INSERT INTO meq_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Tə sər ha wu neheye ka vəleŋ tebiye aye na, a yaw mə nəkar. ");
INSERT INTO meq_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Bəna na tsikatay bazlam nakə ka gweɗeŋ tsikatay aye. Ta təma lele. Ta sər ha ta deɗek na yaw na, abəra ma nəkar. Ada ta dzala ha maa sləra ga ahaya na, nəkar. ");
INSERT INTO meq_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Na ɗuwulakeye naha me hərwi tay, bəna hərwi ndo i məndzibəra hay bay. Na ɗuwulakeye naha me na, hərwi ndo neheye ka vəleŋ tay ha aye. Nəteye na, ndo yak hay. ");
INSERT INTO meq_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ndo ga hay na, ndo yak hay dərmak, ada ndo yak hay na, ndo ga hay. Nəteye ta ɗatay ha məzlaɓ ga a ndo hay. ");
INSERT INTO meq_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Anəke na, na miye naha ka təv yak. Na gəriye ha məndzibəra, nəteye ta ndziye ka məndzibəra. Bəba ga, nəkar nakə tsəɗaŋŋa eye, tsəpa tay ha ta gədaŋ yak nakə ka vəleŋ aye. Tsəpa tay ha hərwi ada tâ təra madzapa eye nəteye andza nəkar tə neŋ, nəmay madzapa eye nəte. ");
INSERT INTO meq_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ahəl nakə nəmaa ndzawa huya dziye na, neŋ na tsəpawa tay ha. Na tsəpawa tay ha ta gədaŋ yak nakə ka vəleŋ aye. Na tsəpa tay lele, ndəray kwa nəte kə dze bay. Maa dze na, ndo nakə tə watsa faya mə Ɗerewel i Mbəlom tə gwaɗ ma ta dziye a ako nakə ma mbatiye bay aye. ");
INSERT INTO meq_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«Anəke na, na diye naha ka təv yak. Na tsik andza niye na, ahəl nakə neŋ ka məndzibəra mba aye hərwi ada məŋgwese ga mâ rah a ɗərev tay. ");
INSERT INTO meq_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Na tsikatay bazlam yak nakə ka gweɗeŋ tsikatay aye. Ane tuk na, ndo i məndzibəra hay faya ta natay ɗəre hərwi nəteye na, ndo tay hay bay andza neŋ nakə neŋ ndo tay bay aye. ");
INSERT INTO meq_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Na ɗuwulakeye naha me na, hərwi nakə kâ həl tay naha abəra ka məndzibəra aye bay. Ɗuh na ɗuwulakeye naha me na, tsəpa tay ha hərwi ada Fakalaw mâ gatay wuray bay. ");
INSERT INTO meq_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Hərwi nəteye na, ndo i məndzibəra hay bay andza neŋ nakə ndo i məndzibəra bay aye. ");
INSERT INTO meq_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","«Bəzatay ha deɗek hərwi ada tâ təra kətsek tebiye i yak hay. Hərwi bazlam yak na, deɗek. ");
INSERT INTO meq_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Andza nəkar nakə ka sləra ga ahaya ka məndzibəra aye na, neŋ kanaŋ dərmak faya na sləriye tay ka məndzibəra ka məge məsler. ");
INSERT INTO meq_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Na vəlaka ha bo ga tebiye hərwi tay hərwi ada nəteye tebiye tâ təra ndo yak hay. ");
INSERT INTO meq_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Na ɗuwulakeye naha me na, hərwi nəteye ɗekɗek tsa bay. Na ɗuwulakeye naha me hərwi ndo neheye ta piye zləm ka bazlam tay ada aza ta dzaliye ha ka neŋ. ");
INSERT INTO meq_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Na ɗuwulakeye naha me hərwi ada nəteye tebiye tâ təra nəte. Bəba, tâ ndza madzapa eye tə nəmay andza nəkar nakə madzapa eye tə neŋ aye ada neŋ madzapa eye tə nəkar aye. Tâ təra na, nəte madzapa eye tə nəmay hərwi ada ndo i məndzibəra hay tâ dzala ha maa sləra ga ahaya na, nəkar. ");
INSERT INTO meq_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Na vəlatay məzlaɓ nakə ka vəleŋ aye hərwi ada tâ təra nəte andza nəkar tə neŋ, nəmay nəte. ");
INSERT INTO meq_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Neŋ madzapa eye ta nəteye andza nəkar nakə madzapa eye tə neŋ aye hərwi ada tâ təra nəte, ada ndo i məndzibəra hay tâ sər na, nəkar ka sləra ga ahaya ada ka wuɗa tay ha andza nakə ka wuɗa neŋ aye. ");
INSERT INTO meq_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Bəba, a seŋ na, ndo neheye ka vəleŋ tay ha a həlay aye na, ta ndziye ma təv nakə na ta ndziye mə ɗəma aye dərmak hərwi ada tâ ŋgatay a məzlaɓ ga. Ka wuɗa ga na, kwa ahəl nakə məndzibəra andaya zuk bay aye ada hərwi niye ka vəleŋ məzlaɓ aye. ");
INSERT INTO meq_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","«Bəba ga nəkar na, ndo i deɗek. Ndo i məndzibəra hay tə sər kar ha bay. Ane tuk na, neŋ na sər kar ha ada ndo neheye mə həlay ga aye tə sər maa sləra ga ahaya na, nəkar. ");
INSERT INTO meq_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Tə sər kar ha na, hərwi ga ada ta səriye kar ha hərwi ga dərmak hərwi ada tâ wuɗa siye i ndo mekeleŋ eye hay andza nakə ka wuɗa ga aye ada neŋ dərmak nâ ndza mə ɗərev tay.» ");
INSERT INTO meq_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu a ndəv ha maɗuwulay naha me a Mbəlom na, a həl bo ta gawla hay, ti ye a diye i magayam wuray tə zalay Sedroŋ. Ka təv aye niye na, dədaŋ andaya ta zəv a ɗəma gərɗaf hay. Tsa na, ti ye a ɗəma ta gawla ŋgay hay. ");
INSERT INTO meq_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudas ndo nakə a ge ɗaf ka Yesu aye a sər təv eye niye. A sər na, hərwi Yesu ta gawla ŋgay hay ti yawa a ɗəma. ");
INSERT INTO meq_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yudas a ye a dədaŋ niye ta sidzew i Roma hay, tə siye i sidzew neheye ta tsəpawa gay i məɗəslay ha gər a Mbəlom. Maa slər tay naha na, bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ada ta Farisa hay. Ti ye na, tə wu i həlay hay, ta lalam tay hay ada siye ta dəv ako. Maa həl tay naha na, Yudas. ");
INSERT INTO meq_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Azlakwa bay Yesu na, ɓa kə sər wu nakə ma ta giye bo tə neŋgeye. Mazlambar faya ta ndisliye naha ka təv tay na, Yesu a həndzəɗ naha ka təv tay. A tsətsah fataya, a gwaɗatay: «Ka pəlum way?» ");
INSERT INTO meq_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ta mbəɗay faya, tə gwaɗay: «Nəmaa pəla Yesu ndo i Nazaret.» Yesu a gwaɗatay: «Yesu na, neŋ eye.» Yudas ndo nakə a gatay ɗaf ka Yesu aye malətsa eye ka təv i sidzew niye hay. ");
INSERT INTO meq_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tə tsəne i Yesu nakə a gwaɗatay: «Yesu na, neŋ eye» ta ma ta dəba, tə dəɗ ka dala tolololo. ");
INSERT INTO meq_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu a tsətsah fataya sa, a gwaɗatay: «Ka pəlum way?» Tə gwaɗ: «Yesu ndo i Nazaret.» ");
INSERT INTO meq_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu a mbəɗatay faya, a gwaɗatay: «Ɓa na gwaɗakum Yesu na, neŋ tsɨy. Taɗə ka pəlum neŋ na, gərum tay ha siye i ndo hay, tâ ye wu tay.» ");
INSERT INTO meq_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Andza niye, wu nakə Yesu a tsik aye na, ma giye bo andza nakə a tsik aye. A gwaɗ: «Bəba, ndo neheye ka vəleŋ tay ha a həlay aye na, kwa nəte kə dze fagaya abəra bay.» ");
INSERT INTO meq_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoŋ Piyer na, maslalam andaya faya. A ŋgwaɗaw maslalam ŋgay niye a fay ha a ndo i məsler i bagwar i ndo məvəlaway wu a Mbəlom. A ɗəsay na zləm i həlay i mənday fats ka dala. Ndo i məsler niye tə zalay na, Malkus. ");
INSERT INTO meq_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ane tuk na, Yesu a gwaɗay a Piyer: «Ma ha maslalam yak a gay ŋgay eye. Ɗəretsətseh nakə Bəba a vəleŋ aye na, na siye bəɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Sidzew niye hay ta bəy tay ada ta ndo neheye ta tsəpawa gay i məɗəslay ha gər a Mbəlom aye, tə gəs na Yesu. Tsa na, tə dzawa na. ");
INSERT INTO meq_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tə lah mede ha Yesu na, a gay i Han təday. Han na, neŋgeye mese i Kayif. Anəke ka viye niye na, Kayif neŋgeye bagwar i ndo məvəlaway wu a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayif na, ndo nakə a gwaɗatay a bagwar i Yahuda hay: «Tə bəmalə nakə ndo hay tebiye ta dziye na, ŋgama ndo nəte mâ mət.» ");
INSERT INTO meq_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoŋ Piyer ta gawla i Yesu neŋgeɗ nəte ta zəŋgal na Yesu. Bagwar i ndo məvəlaway wu a Mbəlom a sər na gawla i Yesu niye neŋgeɗ eye. Hərwi niye neŋgeye na, ti ye a dalamətagay i bagwar i ndo məvəlaway wu a Mbəlom tə Yesu salamay. ");
INSERT INTO meq_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ane tuk na, Piyer neŋgeye na, a ndza ma bəra, sləp ka həlay i məgeɗ i dalamətagay niye. Gawla i Yesu niye bagwar i ndo məvəlaway wu a Mbəlom a sər na aye na, a maw. A yaw ka təv i dem nakə faya ma tsəpiye məgeɗ aye a tsikay me a dem niye hərwi ada mâ vəlay tsəveɗ a Piyer. Piyer a fələkwa a dalamətagay tuk. ");
INSERT INTO meq_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ahəl nakə faya ta diye na, ŋgwas nakə a gawa məsler mə gay i ndo məvəlaway wu a Mbəlom aye, a gwaɗay a Piyer: «Nəkar na, gawla i ndo nakay dərmak ba?» Piyer a mbəɗay faya a gwaɗay: «Aʼay neŋ na, gawla ŋgay bay!» ");
INSERT INTO meq_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Mətasl a ge haladzay. Hərwi niye ndo i məsler hay ta ndo neheye ta tsəpawa gay i məɗəslay ha gər a Mbəlom ta vat ako. Nəteye mandza eye faya. Piyer neŋgeye mandza eye ka ako niye dərmak ta nəteye dziye. ");
INSERT INTO meq_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ma dəba aye na, bagwar i ndo məvəlaway wu a Mbəlom a tsətsah ka Yesu ka gər i gawla ŋgay hay ada ka matətike ŋgay nakə a tətikawa aye. ");
INSERT INTO meq_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu a mbəɗay faya a gwaɗay: «Na tsikawatay bazlam parakka kame i ndo hay tebiye. Na tətikawatay a ndo hay na, mə gay i maɗuwule me ada mə gay i məɗəslay ha gər a Mbəlom ma təv nakə Yahuda hay tə hayawa gər a ɗəma aye. Na tsik wuray ɗaɗa ta məkal bay. ");
INSERT INTO meq_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ada ka tsətsahiye fagaya bazlam na, hərwi mey? Wu nakə na tsikawa aye na, tsətsah ka ndo neheye tə tsəne aye. Nəteye na, tə sər wu nakə na tsik aye.» ");
INSERT INTO meq_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu a tsik andza niye na, kwayaŋŋa ndo nəte mə walaŋ i ndo matsəpe gay i məɗəslay ha gər a Mbəlom a fay a Yesu. A gwaɗay: «Ta mbəɗaway ka bazlam a bagwar i ndo məvəlaway wu a Mbəlom na, andza niye ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu a gwaɗay a ndo niye: «Kə ge na tsik wu nakə lele bay aye na, ɗa ha wu nakə na tsik lele bay aye. Taɗə na tsik lele na, ka kəɗ ga hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tsa na, Han a slər ha Yesu a gay i Kayif bagwar i ndo məvəlaway wu a Mbəlom. Ti ye ha Yesu na, madzawa eye huya. ");
INSERT INTO meq_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ahəl nakə ti ye ha Yesu a gay i Kayif aye na, Piyer neŋgeye ma dalamətagay, mandza eye ka ako. Ta tsətsah faya, tə gwaɗay: «Nəkar na, gawla i ndo nakay dərmak bəɗaw?» Piyer a ɗay bərakəzaŋ a Yesu, a gwaɗ: «Aʼay, neŋ gawla ŋgay bay!» ");
INSERT INTO meq_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ndo mə walaŋ i ndo i məsler i bagwar i ndo məvəlaway wu a Mbəlom andaya ka təv eye niye. Ndoweye niye na, gwala i ndo nakə Piyer a ɗəs faya abəra zləm ahəl nakə tə gəs na Yesu aye. A gwaɗay: «Nəkar na, gawla ŋgay. Na ŋgataka nəkurom tə Yesu ma dədaŋ bəɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ane tuk na, Piyer a ɗay bərakəzaŋ a Yesu sa, a gwaɗay: «Aʼay, neŋ bay!» Piyer a ndəv ha mətsike andza niye na, kwayaŋŋa dzagulok a zlaha. ");
INSERT INTO meq_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ɗəre a tsaɗa pərik i mekedœ na, tə ma ahaya Yesu abəra mə gay i Kayif. Ti ye ha a gay i Pilat ndo i sik i bəy i Roma hay. Ane tuk na, bəy i Yahuda hay ta fələkwa a gay i Pilat bay. Ti ye a ɗəma bay na, hərwi a satay məndze tsəɗaŋŋa ada ta sliye faya mənde wu mənday i Pak. ");
INSERT INTO meq_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Hərwi niye Pilat ndo i sik i bəy i Roma hay, a yaw abəra mə gay. A yaw ka təv tay, a tsətsah fataya, a gwaɗatay: «Ka gəsum ahaya ndo nakay na, a gakum mey?» ");
INSERT INTO meq_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ta mbəɗay faya, tə gwaɗay: «Taɗə kə ge mənese bay na, nəmaa gəsaka ahaya ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Hərwi niye Pilat a mbəɗatay faya, a gwaɗatay: «Kə ge andza niye na, bo kurom eye dum ha ta gumay sariya andza nakə bazlam kurom mapala eye a tsikakum aye.» Ta mbəɗay faya, tə gwaɗay: «Nəmay na, tsəveɗ may andaya məge sariya i məkəɗe ndo bay.» ");
INSERT INTO meq_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Andza nakay bazlam nakə Yesu a tsik ahəl niye a ge bo aye. Ɓa kə ɗa ha məməte ŋgay nakə ma ta mətiye. ");
INSERT INTO meq_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilat a mbəɗa gər a gay. A ye naha a zalayaw a Yesu, a tsətsah faya, a gwaɗay: «Nəkar na, bəy i Yahuda hay deɗek ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu a mbəɗay faya, a gwaɗay: «Ka tsik andza niye na, bo yak eye ka dzala tsukuɗu, siye i ndo hay tə tsikaka ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilat a gwaɗay: «Ka tsikeŋ andza niye na, neŋ Yahuda hay təɗew? Maa gəsa kar ahaya na, ndo yak hay ta bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye bəna neŋ təɗew? Tə gəsa kar ahaya na, ka ge na, mey?» ");
INSERT INTO meq_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu a mbəɗay faya, a gwaɗay: «Bəy ga na, ka məndzibəra nakay bay. Taɗə bəy ga ka məndzibəra nakay na, ndo i məsler ga hay ta giye vəram hərwi ada ndəray mâ gəs ga məvəlay ga ha a bəy i Yahuda hay bay. Ane tuk na, bəy ga na, ka məndzibəra nakay bay.» ");
INSERT INTO meq_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilat a gwaɗay: «Azlakwa nəkar na, bəy ɗaw?» Yesu a gwaɗay: «Maa tsik na, nəkar. Neŋ bəy deɗek. Tə wa ga, na yaw ka məndzibəra na, ka məɗe ha deɗek. Ndo neheye tə sər deɗek aye na, ta təmiye bazlam ga.» ");
INSERT INTO meq_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilat a gwaɗay a Yesu: «Deɗek na, wuye mey?» Pilat a tsik bazlam ŋgay niye na, a yaw abəra mə gay sa. A ye ka təv i bəy i Yahuda niye hay ma bəra aye. A gwaɗatay: «Neŋ na, na huta faya abəra mənese bay. ");
INSERT INTO meq_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ane tuk na, a say a kule kurom, nâ gərakum ha ndo i daŋgay nəte hərwi magurlom i Pak. A sakum nâ gərakum ha na, bəy i Yahuda hay ɗaw?» ");
INSERT INTO meq_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tə tsəne andza niye na, ta wuda ta magala, tə gwaɗ: «Gəramay ha na, Barabas bəna neŋgeye bay!» Azlakwa Barabas na, ndo i galak ɗuh. ");
INSERT INTO meq_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilat a vəlatay tsəveɗ a sidzew hay tâ gəs na Yesu ada tâ ndaɓa na ta mandalaɓa. ");
INSERT INTO meq_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sidzew hay tə ɗəsaw dak tə slapa na ka bo, ta pay a gər a Yesu andza dzagwa i bəy. Tə kalay ka bo petekeɗ ndozza eye. ");
INSERT INTO meq_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tsa na, ta həndzəɗ naha ka təv ŋgay, tə gwaɗay: «Zay ɗaw, bəy i Yahuda hay!» Tə fay ka maholom. ");
INSERT INTO meq_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilat a yaw abəra mə gay sa, a gwaɗatay a ndo hay: «Tsənum təday! Na gəsakuma ahaya Yesu abəra. Sərum ha neŋ na, na huta faya abəra mənese bay.» ");
INSERT INTO meq_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tə gəsa ahaya Yesu abəra tuk. Dzagwa i dak mə gər ada petekeɗ ka bo ndozza. Pilat a gwaɗatay: «Ndo nakay na, anaŋ!» ");
INSERT INTO meq_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta ndo matsəpe gay i məɗəslay ha gər a Mbəlom hay tə ŋgatay a Yesu na, tə pa bo ka mawude ta magala. Tə gwaɗ: «Dar na ka mayako mazləlmbaɗa eye! Dar na ka mayako mazləlmbaɗa eye!» Ane tuk na, Pilat a gwaɗatay: «Bo kurom eye gəsum na ada kâ yum kâ darum na ka mayako mazləlmbaɗa eye. Neŋ na, na huta faya mənese bay.» ");
INSERT INTO meq_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bəy i Yahuda hay ta mbəɗay naha faya, tə gwaɗay: «Nəmay na, bazlam may mapala eye andaya, ada andza bazlam may mapala eye a tsik na, kutoŋ məkəɗe na, hərwi a gwaɗ: “Neŋ na, Wawa i Mbəlom.”» ");
INSERT INTO meq_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilat a tsəne bazlam tay neheye faya ta tsikiye na, a dzədzar haladzay. ");
INSERT INTO meq_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","A fələkwa a gay sa, a ye naha a tsətsah ka Yesu, a gwaɗay: «Ka yaw na, məŋgay?» Ane tuk na, Yesu ka mbəɗay faya bay. ");
INSERT INTO meq_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Andza niye Pilat a gwaɗay: «A saka mətsikeŋ me a neŋ bəɗaw? Neŋ na, gədaŋ ga andaya məgər kar ha ada gədaŋ ga andaya madere kar ka mayako mazləlmbaɗa eye na, ka sər təbəɗew?» ");
INSERT INTO meq_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu a mbəɗay faya, a gwaɗay: «Kə ge Mbəlom kə vəlaka ga ha a həlay bay na, ka sliye faya məgeŋ wuray kwa tsekweŋ bay tebiye. Hərwi niye ndo məgəsa ga ahaya məvəlaka ga ha a həlay na, mənese ŋgay a ze i yak.» ");
INSERT INTO meq_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ka təv eye niye kwayaŋŋa na, Pilat a pəla tsəveɗ məgər ha Yesu. Ane tuk na, bəy i Yahuda hay ta wuda ta magala, tə gwaɗ: «Ka gər ha ndo nakay na, nəkar dzam i bəy i Roma sa bay. Ndoweye kə gwaɗ neŋgeye bəy na, neŋgeye ndo məne ɗəre i bəy i Roma.» ");
INSERT INTO meq_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilat a tsəne bazlam tay niye hay na, a ye ahaya Yesu abəra. A ye ka təv nakə dala eye maɗəzla eye tə beleler aye. Tə bazlam i Yahuda hay na, Gabata. A ndza ka təv niye hərwi məge sariya. ");
INSERT INTO meq_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pat niye na, pat i luma i dezele, mazlambar magərhəpat. Ada həlay i magurlom i Pak. Pilat a gwaɗatay a Yahuda hay: «Bəy kurom anaŋ.» ");
INSERT INTO meq_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ane tuk na, tə tsəne bazlam i Pilat niye na, tə pa bo ka mawude, tə gwaɗay: «Kəɗ! Kəɗ! Dar na ka mayako mazləlmbaɗa eye!» Pilat a gwaɗatay: «Nâ dar na bəy kurom ka mayako mazləlmbaɗa eye ɗaw?» Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta mbəɗay faya: «Bəy may na, bəy i Roma nəte ŋgweŋ.» ");
INSERT INTO meq_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Andza niye, Pilat a vəlatay ha Yesu a həlay a sidzew hay hərwi ada tâ ye tâ dar na ka mayako mazləlmbaɗa eye. Sidzew hay ti ye ha Yesu mata kəɗe na. ");
INSERT INTO meq_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu a zla mayako mazləlmbaɗa eye niye ta ta dariye na faya aye, a ye ahaya abəra ma wuzlah gay. A ye ha a təv nakə tə zalay Təv i Mətasl i Gər aye. Tə zalay tə bazlam i Yahuda hay na, Golgwata. ");
INSERT INTO meq_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Mə ɗəma na, sidzew hay ta dar na Yesu ka mayako mazləlmbaɗa eye. Ta dar naha ndo hay sulo ka mayako mazləlmbaɗa eye ka tsakay i Yesu, nəte tə həlay i mənday, neŋgeɗ tə həlay i gula, Yesu ma wuzlah. ");
INSERT INTO meq_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat a watsa bazlam ŋgay nakə tə kəɗ na faya ka palalam. A law zal ka gər i Yesu. A watsa na, a gwaɗ: «Yesu ndo i Nazaret, bəy i Yahuda hay.» ");
INSERT INTO meq_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yahuda hay haladzay tə dzaŋgawa bazlam niye mawatsa eye, hərwi təv nakə ta dar faya Yesu aye na, bəse ta wuzlah gay. Ada wu niye tə watsa aye na, tə bazlam i gəma hay wal wal mahkar: Tə bazlam i Yahuda hay, i Roma hay ada ta Gərek hay. ");
INSERT INTO meq_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye tə dzaŋga bazlam niye na, ti ye ka təv i Pilat, tə gwaɗay: «Ka watsa faya “Bəy i Yahuda hay” meriye. Watsa faya na: “Ndo nakay a gwaɗ: Neŋ na, bəy i Yahuda hay.”» ");
INSERT INTO meq_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilat a gwaɗatay: «Wu nakə neŋ na watsa aye na, ma ndziye andza niye.» ");
INSERT INTO meq_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sidzew hay ta dar na Yesu ka mayako mazləlmbaɗa eye na, tə zla petekeɗ ŋgay aye. Ta ŋgəna ha faɗ, kwa way a zla nəte. Tə zla məkelkabo ŋgay nakə maŋgara eye andza niye məmbele andaya faya bay aye sa. ");
INSERT INTO meq_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tə tsik mə walaŋ tay, tə gwaɗ: «Petekeɗ nakay na, kâ ŋguraɗakwa ha bay. Ane tuk na, gakwa faya tsakwal hərwi məsəre ha mata zle na, way.» Andza niye, wu nakay a ge bo aye na, andza nakə mawatsa eye mə Ɗerewel i Mbəlom aye, tə gwaɗ: «Ta ŋgəna ha petekeɗ ga mə walaŋ tay ada tə ge faya tsakwal ka məkelkabo ga.» Wu nakə sidzew hay tə ge aye na, anaŋ. ");
INSERT INTO meq_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Bəse ta təv i mayako niye mazləlmbaɗa eye ta dar faya Yesu aye na, may i Yesu ta malamar i may ŋgay, Mari ŋgwas i Kəlopas ada ta Mari nakə a yaw ma gəma i Magədala aye, nəteye malətsa eye ka təv eye niye. ");
INSERT INTO meq_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu a ŋgatay a may ŋgay ta gawla ŋgay nakə a wuɗa na haladzay aye. A gwaɗay a may ŋgay: «May ga, wawa yak anaŋ.» ");
INSERT INTO meq_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ma dəba aye a gwaɗay a gawla ŋgay niye a wuɗa na haladzay aye: «May yak anaŋ.» Pat eye niye gawla i Yesu niye a wuɗa na haladzay aye a zla na Mari a gay ŋgay. ");
INSERT INTO meq_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ma dəba eye na, Yesu a sər ha wu nakə Mbəlom a sləra ahaya faya məge aye na, ka ndəv tebiye tuk. Yesu a gwaɗ: «Yam a geŋ.» A tsik andza niye hərwi ada wu nakə tə dzaŋgawa mə Ɗerewel i Mbəlom aye mâ ge bo. ");
INSERT INTO meq_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Gəzla wuray andaya maraha eye tə wuye andaya guyakaka. Sidzew niye hay tə zla wuye kofkoffa, tə tələka a wu niye. Tsa na, ta hak na a mayako. Tə pay naha ka bazlam a Yesu. ");
INSERT INTO meq_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu a ɗəvətse wu niye na, a gwaɗ: «Wu tebiye ka ndəv!» Gər ŋgay a kal gəzuk. Tsa na, a mət. ");
INSERT INTO meq_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tə kəɗ na Yesu na, pat i məhəne mə gay i mazəzukw bo. Pat i mazəzukw bo eye niye na, a ze ha siye hay, hərwi magurlom andaya pat eye niye. Hərwi niye a satay a bəy i Yahuda hay mədahaŋ mâ ndza ka mayako mazləlmbaɗa eye pat i mazəzukw bo bay. Ti ye ta tsətsah ka Pilat mâ vəlatay tsəveɗ ka məhəɓe sik i ndo niye hay ada məzla ahaya abəra ka mayako. ");
INSERT INTO meq_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tsa na, sidzew hay ti yaw ka təv i ndo neheye ta dar ka mayako mazləlmbaɗa eye tage Yesu aye. Tə həɓay ha sik a ndo makurre eye. Tsa na, tə həɓay ha a ndo neŋgeɗ. ");
INSERT INTO meq_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tə ndisl ka təv i Yesu na, ta zəba faya na, kə mət tsɨy. Neŋgeye na, ta həɓay ha sik ŋgay hay təbey. ");
INSERT INTO meq_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ane tuk na, ndo nəte mə walaŋ i sidzew hay a ye naha a təz na dzəham i Yesu ta suwal. Kwayaŋŋa bambaz ta yam ta mbəɗaw. ");
INSERT INTO meq_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Neŋ nakə na watsa na bazlam neheye na, na ŋgatay tə ɗəre ga ada wu nakə na watsa aye na, deɗek eye. Na ŋgatay tə ɗəre ga, na sər ha na tsik na, deɗek. Na watsa na, hərwi ada nəkurom dərmak kâ dzalum ha faya. ");
INSERT INTO meq_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Wu neheye a ge bo na, hərwi ada wu nakə mawatsa eye mə Ɗerewel i Mbəlom aye mâ ge bo, a gwaɗ: «Mətasl ŋgay hay na, kwa nəte ta həɓiye ha bay.» ");
INSERT INTO meq_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tə watsa mə Ɗerewel i Mbəlom sa, tə gwaɗ: «Ta ta zəbiye na, ka ndo nakə ta təzay na aye.» ");
INSERT INTO meq_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ndoweye andaya tə zalay Yusufa, neŋgeye ndo i gəma i Arimate. Neŋgeye gawla i Yesu, ane tuk na, ta məkal, hərwi a dzədzar ta bəy i Yahuda hay. A ye a tsətsah tsəveɗ məzle mədahaŋ i Yesu ka Pilat. A ye a tsətsah na, Pilat a gwaɗay faya ayaw. Yusufa a maw, a zla na mədahaŋ i Yesu. ");
INSERT INTO meq_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodem ndo nakə a ye ka təv i Yesu ta həvaɗ aye, a ye naha dərmak. Neŋgeye a zla naha mal madzapa eye a ze huŋŋa. Wuye niye hay tebiye ma giye kilo kuro kuro mahkar. ");
INSERT INTO meq_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yusufa ta Nikodem nəteye salamay tə zla mədahaŋ i Yesu. Tə mbəkwa ta rəkwat ada ta wats faya mal niye hay huŋŋa eye andza nakə Yahuda hay tə gawa ahəl nakə tə lawa mədahaŋ hay aye. ");
INSERT INTO meq_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ma təv niye ta dar na Yesu ka mayako mazləlmbaɗa eye na, guvah andaya. Ma guvah niye na, tsəvay weɗeye mala eye mə ɗəma. Ta pa a ɗəma mədahaŋ ɗaɗa zuk bay. ");
INSERT INTO meq_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pat eye niye na, pat i mələve bo i pat i mazəzukw bo i Yahuda hay ada tsəvay niye na, bəse. Hərwi niye Yusufa ta Nikodem tə zla Yesu tə pa na a tsəvay. ");
INSERT INTO meq_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pərik i mekedœ pat i luma i sidzew na, Mari i Magədala a ye ka me tsəvay. A ye na, həvaɗ mə ɗəma mba, ɗəre a zəba bay. Ta dərəzl ka tsəvay niye na, tə beber bagwar eye. Mari a ye naha na, beber madərəzla eye ka tsəvay sa bay, ta həndək faya abəra. ");
INSERT INTO meq_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mari a ŋgatay andza niye na, a hway ka təv i Simoŋ Piyer ta gawla nakə Yesu a wuɗa na haladzay aye. A ye naha a gwaɗatay: «Bəy Maduweŋ andaya ma tsəvay sa bay, ta zla na. Ada nəmaa sər təv nakə tə pa na a ɗəma aye bay.» ");
INSERT INTO meq_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tsa na, Piyer ta gawla i Yesu niye neŋgeɗ eye tə lətse, ti ye ka tsəvay niye. ");
INSERT INTO meq_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nəteye salamay ta hway ka me tsəvay. Ane tuk na, gawla i Yesu niye neŋgeɗ eye a hway bəse a ze Piyer. Neŋgeye a lah məndisle ka tsəvay. ");
INSERT INTO meq_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","A ndisl ka tsəvay na, a zəba ɗəre a ɗəma zərəɗ. A ŋgatay na, a petekeɗ neheye tə mbəkwa na Yesu aye mə ɗəma. Ane tuk na, kə fələkwa a ɗəma bay. ");
INSERT INTO meq_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoŋ Piyer na, a ndisl naha ma dəba. A ye naha a fələkwa a tsəvay, a zəba ka petekeɗ neheye tə mbəkwa na Yesu aye na, mə ɗəma. ");
INSERT INTO meq_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Piyer a zəba ka petekeɗ nakə ta nduɗay ha gər a Yesu aye dərmak. Petekeɗ niye na, madzapa eye tə siye hay bay. Mapaɗa eye, təv ŋgay wal. ");
INSERT INTO meq_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tsa na, gawla i Yesu neŋgeɗ eye, ndo nakə a lah naha kurre, a fələkwa a tsəvay dərmak. A zəba faya andza niye na, a dzala ha. ");
INSERT INTO meq_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Gawla i Yesu hay na, wu nakə mə Ɗerewel i Mbəlom a tsik, a gwaɗ Yesu na, kutoŋ ma lətseweye abəra ma mədahaŋ aye na, ta sər zuk bay. ");
INSERT INTO meq_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tsa na, gawla i Yesu niye sulo eye ta mbəɗa gər a mətagay. ");
INSERT INTO meq_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mari neŋgeye na, malətse eye ma bəra bəse ka təv i tsəvay faya ma tuwiye. Faya ma tuwiye na, a rəh ha gər a tsəvay, a zəba ɗəre a ɗəma. ");
INSERT INTO meq_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","A ŋgatay naha a gawla i Mbəlom hay sulo tə petekeɗ ka bo kuɗekuɗek. Nəteye mandza eye ka təv nakə tə pa faya mədahaŋ i Yesu aye. Neŋgeɗ ta diye i gər ada neŋgeɗ ta diye i sik. ");
INSERT INTO meq_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Gawla i Mbəlom niye hay sulo aye ta tsətsah ka Mari, tə gwaɗay: «Ŋgwas niye, ka tuwa mey?» Mari a mbəɗatay faya, a gwaɗatay: «Na tuwa na, hərwi ta zla na Bəy Maduweŋ ga ada na sər təv nakə tə pa na a ɗəma aye bay.» ");
INSERT INTO meq_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Mari a ndəv ha mətsike andza niye na, a mbəɗa bo, a ŋgatay a Yesu malətse eye ka təv niye. Mari a sər ha neŋgeye bay. ");
INSERT INTO meq_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu a tsətsah faya, a gwaɗay: «Ŋgwas ka tuwa mey? Ka pəla way?» Mari a dzala mə gər ŋgay na, ma giye na, ndo i guvah. Hərwi niye a gwaɗay: «Sadzək bay, kə ge maa zla na nəkar na, ɗeŋ ha təv nakə ka pa na a ɗəma aye. Na diye na ta zla ahaya.» ");
INSERT INTO meq_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu a gwaɗay: «Mari!» Mari a mbəɗa me ka təv ŋgay, a gwaɗay tə bazlam i Yahuda hay: «Raboni!» Andza məgweɗe: «Miter ga!» ");
INSERT INTO meq_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu a gwaɗay: «Kâ lemeŋ bay, hərwi na tsal ka təv i Bəba ga zuk bay. Ane tuk na, do gwaɗatay a malamar ga hay na, na tsaliye ka təv i Bəba ga, neŋgeye Bəba kurom dərmak, Mbəlom ga, neŋgeye Mbəlom kurom dərmak.» ");
INSERT INTO meq_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tsa na, Mari i Magədala a ye ka təv i gawla i Yesu hay. A ye a gwaɗatay: «Na ŋgatay a Bəy Maduweŋ kway!» A təkəratay wu nakə Yesu a tsikay aye. ");
INSERT INTO meq_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ta huwa eye niye pat i luma i sidzew, gawla i Yesu hay nəteye mahaya gər eye mə gay. Ta dərəzl ka bo a gay lele hərwi ta dzədzar ta bəy i Yahuda hay. Tsa na, Yesu a ye naha slekərtik a wuzlah tay. A gwaɗatay: «Zay mâ ndza fakuma!» ");
INSERT INTO meq_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","A tsikatay andza niye na, a bəzatay ha vavay nakə ka həlay ŋgay hay ada ka dzəham ŋgay aye. Gawla ŋgay hay tə ŋgatay andza niye na, ɗərev tay a ŋgwasa haladzay hərwi tə ŋgatay a Bəy Maduweŋ. ");
INSERT INTO meq_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu a gwaɗatay sa: «Zay mâ ndza fakuma! Andza nakə Bəba a sləra ga ahaya aye na, neŋ na sləriye kurom dərmak.» ");
INSERT INTO meq_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ma dəba i bazlam ŋgay niye na, a vəzl fataya, a gwaɗatay: «Təmum Məsəfəre Tsəɗaŋŋa eye! ");
INSERT INTO meq_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ndo neheye ka pəsumatay ha mezeleme tay hay aye na, Mbəlom ma pəsateye ha mezeleme tay hay. Ndo neheye ta kərah məpəse ha mezeleme aye na, Mbəlom ma kərahiye məpəsatay ha mezeleme tay dərmak.» ");
INSERT INTO meq_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas nakə tə zalay Mawsa neŋgeye nəte mə walaŋ i gawla i Yesu. Azlakwa bay ahəl nakə Yesu a ye a bəzatay ha bo a gawla ŋgay aye na, neŋgeye andaya bay. ");
INSERT INTO meq_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Siye i gawla i Yesu hay tə gwaɗay: «Nəmaa ŋgatay a Bəy Maduweŋ.» Ane tuk na, Tomas a mbəɗatay faya, a gwaɗatay: «Na ŋgatay a vavay i mbəlak i poŋte ka həlay ŋgay bay, na pa wur həlay ga a bəɗ i poŋte bay ada na pa wur həlay ga a bəɗ i suwal nakə ka dzəham ŋgay aye bay na, na dzaliye ha faya bay.» ");
INSERT INTO meq_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","A ndza ma dəba eye luma nəte na, gawla i Yesu hay tə haya gər sa. Pat eye niye na, Tomas andaya ta nəteye tuk. Ta dərəzl na məgeɗ lele. Yesu a ye naha a lətse a wuzlah tay, a gwaɗ: «Zay mâ ndza fakuma!» ");
INSERT INTO meq_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tsa na, a gwaɗay a Tomas: «Tələkaw wur həlay kanaŋ ada zəba ka həlay ga hay. Zlaw həlay yak ada tələkaw a dzəham ga. Gər ha mədzele gər sulo sulo, dzala ha ka neŋ nəte ŋgweŋ.» ");
INSERT INTO meq_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas a mbəɗay faya, a gwaɗay: «Ta deɗek, nəkar na, Bəy Maduweŋ ga ada Mbəlom ga.» ");
INSERT INTO meq_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu a gwaɗay: «Ka dzala ha ka neŋ na, hərwi nakə ka ŋgeteŋ aye. Məŋgwese ka ndo neheye tə dzala ha ka neŋ ze məŋgeteŋ aye.» ");
INSERT INTO meq_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu a ge masuwayaŋ siye hay haladzay kame i gawla ŋgay hay. Ane tuk na, na watsa tay ha a ɗerewel nakay bay. ");
INSERT INTO meq_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Na watsa wu neheye na, hərwi ada kâ dzalum ha Yesu neŋgeye na, Kəriste, neŋgeye Wawa i Mbəlom, ada ka hutumeye sifa ma neŋgeye hərwi ka pum mədzal gər ka neŋgeye. ");
INSERT INTO meq_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ma dəba aye na, Yesu a bəzatay ha bo a gawla ŋgay hay sa. A bəzatay ha bo na, ka me i dəlov i Tiber. A bəzatay bo na, kəkay? ");
INSERT INTO meq_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Pat eye niye siye i gawla i Yesu hay nəteye ka təv manəte eye. Nəteye na, Simoŋ Piyer, Tomas nakə tə zalay Mawsa aye, Nataniyel ndo i gəma i Kana ka dala i Galile, wawa i Dzebede hay ada tə siye i gawla i Yesu hay sulo. ");
INSERT INTO meq_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoŋ Piyer a gwaɗatay: «Na diye na ta gəsiye kəlef.» Siye hay tə gwaɗay: «Nəmay dərmak nəmaa diye, takwa dziye.» Tsa na, tə həl bo ti ye, tə tsal a kwalalaŋ i yam. Ta dazlay a məgəse kəlef. Ane tuk na, ta həvaɗ eye niye na, ta gəs kəlef kwa nəte bay tebiye. ");
INSERT INTO meq_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ɗəre a dazlay a mətseɗe na, Yesu a ye naha a lətse ka me i dəlov niye. Ane tuk na, gawla ŋgay hay ta sər ha Yesu bay. ");
INSERT INTO meq_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tsa na, Yesu a gwaɗatay: «Ka gəsum kəlef ɗaw, wawa ga hay?» Ta mbəɗay faya, tə gwaɗay: «Aʼay!» ");
INSERT INTO meq_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu a gwaɗatay: «Kalum gadaŋ ta diye i həlay i mənday kurom təday, ka gəsumaweye.» Tə kal gadaŋ a yam na, tə gəs kəlef haladzay. Tə mba faya məvahaw gadaŋ abəra ma yam bay. ");
INSERT INTO meq_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tsa na, gawla i Yesu nakə Yesu a wuɗa na haladzay aye a gwaɗay a Piyer: «Nakay na, Bəy Maduweŋ!» Simoŋ Piyer a tsəne andza niye: «Nakay na, Bəy Maduweŋ» na, a zla petekeɗ ŋgay a kal ka bo hərwi ɓa ka tsoloka ka bo abəra. Tsa na, a kal ha bo a yam. ");
INSERT INTO meq_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Gawla i Yesu siye hay tə maw ta kwalalaŋ i yam ta məvaha ahaya gadaŋ niye maraha eye tə kəlef aye. Nəteye haɓe na, dəreŋ tə ɗakal bay. Ta ze ka bo abəra na, dal tsa. ");
INSERT INTO meq_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tə ndislew, tə mbəzlaw ka dala na, tə ŋgatay a ako ka təv eye niye kəlef faya ada peŋ andaya dərmak. ");
INSERT INTO meq_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu a gwaɗatay: «Həlumaw abəra ka kəlef kurom niye hay ka gəsumaw aye, fəkakwa.» ");
INSERT INTO meq_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoŋ Piyer a tsal a kwalalaŋ i yam. A ye naha, a vaha ahaya gadaŋ niye maraha eye tə kəlef bagwar eye hay. Kəlef neheye na, nəteye temerre tə kuro kuro zlam gər eye mahkar. Gadaŋ niye kwa tsekweŋ ka ŋgəzlah bay, ada azlakwa kəlef mə ɗəma maraha eye haladzay. ");
INSERT INTO meq_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu a gwaɗatay a gawla ŋgay hay: «Dumara ndayakwa!» Ndo kwa nəte mə walaŋ tay ka tsətsah faya, kə gwaɗay: «Nəkar way?» na, ka tsətsah bay. Hərwi tə sər ha neŋgeye na, Bəy Maduweŋ. ");
INSERT INTO meq_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu a həndzəɗ naha ka təv tay, a zla a vəlatay a gawla ŋgay hay. A zla kəlef dərmak a vəlatay. ");
INSERT INTO meq_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kwa ahəl nakə Yesu a lətsew abəra ma mədahaŋ aye, a bəzatay ha bo a gawla ŋgay hay aye na, nakay na, mamahkar eye. ");
INSERT INTO meq_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ma dəba i mənde ɗaf na, Yesu a gwaɗay a Simoŋ Piyer: «Simoŋ wawa i Yuhana, ka wuɗa ga a ze i ndo neheye ɗaw?» Simoŋ Piyer a mbəɗay faya, a gwaɗay: «Ayaw Bəy Maduweŋ! Ka sər ha na wuɗa kar segey.» Yesu a gwaɗay: «Gatay gər a wawa i təɓaŋ ga hay lele.» ");
INSERT INTO meq_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu a tsətsah faya masulo eye sa, a gwaɗay: «Simoŋ wawa i Yuhana, ka wuɗa ga ɗaw?» Simoŋ Piyer a mbəɗay faya, a gwaɗay: «Ayaw Bəy Maduweŋ, ka sər ha na wuɗa kar segey.» Yesu a gwaɗay: «Gatay gər a təɓaŋ ga hay.» ");
INSERT INTO meq_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tsa na, a tsətsah mamahkar eye sa: «Simoŋ wawa i Yuhana ka wuɗa ga ɗaw?» Yesu a masay ha a Piyer mamahkar eye: «Ka wuɗa ga ɗaw?» aye na, a ndalay. A mbəɗay faya, a gwaɗay: «Bəy Maduweŋ, nəkar na, ka sər wu tebiye. Ka sər ha na wuɗa kar!» Yesu a gwaɗay: «Gatay gər a təɓaŋ ga hay. ");
INSERT INTO meq_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Neŋ faya na gwaɗakeye: Sər ha na, ahəl niye nəkar gawla eye na, ka ɓarawa bəzihuɗ tə həlay yak eye ada ka yawa na, a təv nakə a saka aye. Ahəl nakə ka ge guram aye na, ka gəsiye na həlay ka mbəlom, ada ndo mekeleŋ eye ma ɓarakeye na bəzihuɗ ada ma diye kar ha a təv nakə a saka bay aye.» ");
INSERT INTO meq_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu a tsik bazlam neheye na, a ɗay ha məməte nakə Piyer ma ta mətiye na, kəkay. Məməte ŋgay niye na, ma bəziye ha məzlaɓ i Mbəlom. Tsa na, Yesu a gwaɗay a Piyer: «Peŋ bəzay.» ");
INSERT INTO meq_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piyer a mbəɗa bo a zəba ɗəre a dəba na, a ŋgatay a gawla i Yesu nakə Yesu a wuɗa na haladzay aye. Ahəl niye, ahəl nakə faya ta ndiye ɗaf aye, maa həndzəɗ ka təv i Yesu ada maa tsətsah: «Bəy Maduweŋ mata ge fakaya ɗaf way?» na, neŋgeye. ");
INSERT INTO meq_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piyer a ŋgatay na, a tsətsah ka Yesu, a gwaɗay: «Bəy Maduweŋ, mata gay a neŋgeye mey?» ");
INSERT INTO meq_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu a mbəɗay faya, a gwaɗay: «Taɗə a seŋ mâ ndza ka bəra hus ahəl nakə na maweye na, me yak faya mey tey? Nəkar na, peŋ bəzay!» ");
INSERT INTO meq_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Labara nakay a dəɗatay a zləm a ndo məpe mədzal gər hay ka Yesu na, gawla i Yesu niye Yesu a tsik faya andza niye na, ma mətiye bay. Azlakwa Yesu kə gwaɗay a Piyer ma mətiye bay na, kə tsikay bay. Ane tuk na, a gwaɗay na: «Taɗə a seŋ mâ ndza ka bəra hus ahəl nakə na maweye na, me yak faya mey tey?» ");
INSERT INTO meq_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Wu neheye tebiye Yesu a ge aye na, maa ɗa ha ada maa watsa na, gawla i Yesu niye Yesu a wuɗa na haladzay aye. Ada nəmaa sər ha na, wu neheye a ɗa ha aye na, deɗek. ");
INSERT INTO meq_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Siye i wu neheye Yesu a ge na, nəteye haladzay. Taɗə ta watsa tebiye ka ɗerewel nəte ta nəte na, ɗerewel niye hay təv ma slateye ka məndzibəra bay.");
INSERT INTO meq_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","A nəkar Tiyofil, mə ɗerewel ga nakə kurre na watsaka naha aye na, məsler i Yesu nakə a ge, tə matətike nakə a tətik tay ha ndo hay aye tebiye, na pasla a ɗəma, kwa ka madazlay i məsler ŋgay, ");
INSERT INTO meq_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hus ka mede ŋgay a mbəlom. Ahəl nakə ki ye ŋgway a mbəlom zuk bay aye na, kə ɗatay ha wu hay ta gədaŋ i Məsəfəre Tsəɗaŋŋa eye a ndo neheye a pala tay andza ndo i maslaŋ hay aye. ");
INSERT INTO meq_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ma dəba i məməte ŋgay na, kə lətsa abəra ma mədahaŋ ka bəzatay ha bo a ndo i maslaŋ ŋgay hay lele, a ɗatay ha na, neŋgeye andaya. Kə ndza ka təv i gawla ŋgay hay məhəne kuro kuro faɗ. Ma məhəne niye kuro kuro faɗ eye na, a tsikawatay bazlam i Bəy i Mbəlom nakə ma ta ləviye. ");
INSERT INTO meq_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pat eye andaya Yesu faya ta ndiye wu mənday ta gawla ŋgay hay na, a gwaɗatay: «Kâ yum abəra ma Zerozelem zuk bay. Həbum wu nakə na gwaɗakum Bəba Mbəlom a gwaɗ ma vəlakumeye. ");
INSERT INTO meq_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yuhana neŋgeye a dzəhuɓawa tay ha ndo hay na, a yam. Ane tuk na, nəkurom na, ma məndze aza mba tsekweŋ na, nəkurom ta dzəhuɓiye kurom ha a Məsəfəre Tsəɗaŋŋa eye.» ");
INSERT INTO meq_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ndo neheye ka təv i Yesu aye, ta tsətsah faya, tə gwaɗay: «Bəy Maduweŋ, ka ta matay ha bəy a ndo i Israyel hay na, pat eye niye ɗaw?» ");
INSERT INTO meq_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu a mbəɗatay faya, a gwaɗatay: «Pat eye kəɗay na, mata səre na, nəkurom bay. Mata tsike na, Bəba ga, neŋgeye nəte ŋgweŋ gədaŋ ŋgay andaya məge. ");
INSERT INTO meq_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ane tuk na, ka ta hutumeye gədaŋ ahəl nakə Məsəfəre Tsəɗaŋŋa eye ma mbəzlaweye fakuma aye. Ka ta tərumeye ndo məɗe ha labara ga ma Zerozelem, ka dala i Yahuda, ka dala i Samari ada ka kokway i məndzibəra tebiye.» ");
INSERT INTO meq_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ma dəba i bazlam ŋgay niye hay na, a tsal ha a mbəlom. Ahəl nakə gawla ŋgay hay faya ta zəbiye faya na, pazlay a ŋgaha na abəra ka ɗəre tay. ");
INSERT INTO meq_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yesu faya ma tsaliye na, nəteye faya ta zəbiye naha faya huya. Tsa na, ndo hay sulo tə petekeɗ kweɗek kweɗek eye hay ti yaw ka təv tay, ");
INSERT INTO meq_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","tə gwaɗatay: «A nəkurom Galile hay, faya ka mətsumeye mazəbe ɗəre a magərmbəlom na, hərwi mey? Yesu na, ki ye fakuma abəra a mbəlom. Ma ta maweye na, andza nakə ka ŋgatumay, a ye fakuma abəra aye.» ");
INSERT INTO meq_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ndo i maslaŋ i Yesu hay tə tsəne andza niye na, tə mbəzlaw abəra ma tsaholok niye tə zalay Mahəmba i Tetəɗœz aye, ta mbəɗa gər a Zerozelem. Tsaholok niye na, bəse ta wuzlah gay. Mede abəra ma Zerozelem a ɗəma na, ma sliye ɓəre nəte bay. ");
INSERT INTO meq_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ahəl nakə tə ndisl a Zerozelem aye na, ti ye naha tə tsal a gay nakə ka gər i gay neŋgeɗ aye. Tə ndzawa pat pat na, mə ɗəma. Məzele i ndo neheye tə ndzawa mə gay niye na, Piyer, Yuhana, Yakuba ta Aŋdəre, Filip ta Tomas, Bartelemi tə Mata, Yuda wawa i Alfe, Simoŋ ndo məge vəram hərwi dala ŋgay ada Yahuda wawa i Yakuba. ");
INSERT INTO meq_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nəteye tebiye tə hayawa gər pat pat, ta ŋgwas hay, ta Mari may i Yesu ada ta malamar i Yesu. Tə hayawa gər hərwi maɗuwulay naha me a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pat wuray na, ndo məpe mədzal gər hay ka Mbəlom tə haya gər. Nəteye tebiye ta giye na, temerre tə kuro kuro sulo. Piyer a lətse a wuzlah tay, a gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Malamar ga hay, wu nakə Məsəfəre Tsəɗaŋŋa eye a tsik mə Ɗerewel i Mbəlom aye na, kə ge bo. A tsik tə bazlam i Davit. A tsik kurre ka Yudas nakə a təra ndo məɗatay tsəveɗ a ndo neheye tə gəs Yesu aye. ");
INSERT INTO meq_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudas na, neŋgeye nəte mə walaŋ may, kə huta məsler andza nəmay.» ");
INSERT INTO meq_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Suloy nakə tə vəlay hərwi məkəɗe gər i ndo aye na, Yudas a səkəm ha guvah. Mə ɗəma na, a dəɗ tə huɗ. Huɗ ŋgay a nduzl, dende ŋgay hay ti yaw a bəra tebiye. ");
INSERT INTO meq_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ndo i gəma i Zerozelem hay tə tsəne labara niye na, tə zalay a guvah niye tə me i gəma tay guvah i Hakeldama, andza məgweɗe: Guvah i Bambaz. ");
INSERT INTO meq_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Piyer a gwaɗatay sa: «Azlakwa mawatsa eye mə ɗerewel i Dəmes hay na, a gwaɗ: “Gay ŋgay mâ təra na, rəgay, ndəray mâ ndza mə gay ŋgay bay.” «Mawatsa eye sa na, a gwaɗ: “Ndo mekeleŋ eye mâ zla məsler ŋgay.” ");
INSERT INTO meq_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«Anəke na, a ye ka bo nakə ka zlakweye ndo nəte mə walaŋ i ndo neheye ta zəŋgalawa kway ahəl nakə Bəy Maduweŋ tə nəkway ka həhalawakwa ka gəma ka gəma aye. ");
INSERT INTO meq_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Kwa ahəl nakə Yuhana madzəhuɓe ndo a yam a dzəhuɓ Yesu a yam aye hus ahəl ŋgay nakə a ye abəra mə walaŋ kway a tsal a mbəlom aye na, nəteye tə nəkway. Ndoweye niye ka zlakweye na, ma ndziye tə nəkway. Ma ɗiye ha labara i mələtsew i Yesu abəra ma mədahaŋ.» ");
INSERT INTO meq_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mə walaŋ i ndo niye hay na, tə pala ndo hay sulo. Ndo niye hay sulo eye na, neŋgeɗ məzele ŋgay Yusufa nakə tə zalay Barsabas aye. Tə pa faya məzele mamahkar eye sa, tə zalay Zustus. Ada ndo neŋgeɗ tə zalay Matiyas. ");
INSERT INTO meq_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tsa na, ndo niye hay mahaya gər eye ta ɗuwulay me a Mbəlom, tə gwaɗ: «Bəy Maduweŋ, nəkar nakə ka sər ɗərev i ndo zezeŋ aye na, ɗamay ha way nakə mə walaŋ i ndo neheye sulo ka zla, ");
INSERT INTO meq_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","hərwi məge məsler yak aye, a bəram i Yudas nakə a gər ha, a ye a təv nakə a say a neŋgeye aye.» ");
INSERT INTO meq_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ta ndəv ha maɗuwule me na, tə ge tsakwal. Tsakwal a zla Matiyas, Matiyas a təra makuro gər eye sulo i ndo i maslaŋ hay. ");
INSERT INTO meq_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Magurlom i Peŋtekot a slaw na, gawla i Yesu hay nəteye mahaya gər eye ka təv manəte eye. ");
INSERT INTO meq_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ahəl nakə nəteye mahaya gər eye na, kwayaŋŋa maləve i wuye a tsənew ma magərmbəlom. Maləve i wuye niye na, andza mətasl bagwar eye. A ye fataya, mavəzle ŋgay eye a rah a gay nakə nəteye mandza eye mə ɗəma aye. ");
INSERT INTO meq_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kwayaŋŋa tə ŋgatay andza ɗərneh i ako a yaw, a ŋgəna bo, ti ye tə ndza ka gər i ndo niye hay nəte nəte tebiye. ");
INSERT INTO meq_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nəteye tebiye tə rah ta Məsəfəre Tsəɗaŋŋa eye ada ta dazlay a mətsike me tə me hay wal wal. Kwa way a tsik andza nakə Məsəfəre Tsəɗaŋŋa eye a gwaɗay tsik aye. ");
INSERT INTO meq_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Azlakwa pat eye niye na, Yahuda neheye tə paway bəzay a Mbəlom ta tsəveɗ eye, nəteye andaya. Ti yaw ma gəma neheye wal wal ka məndzibəra aye mata ndze naha məhəne tsekweŋ ma Zerozelem. ");
INSERT INTO meq_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tə tsəne maləve i wu niye na, tə haya gər tebiye. Nəteye niye tebiye a gatay wadəŋ wadəŋ. Ti ye naha na, tə ŋgatay a ndo niye hay mə gay aye. Kwa way a tsəne mətsike me i ndo məpe mədzal gər niye hay faya a tsik me tə me ŋgay ŋgway. ");
INSERT INTO meq_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nəteye neheye ti ye naha tebiye aye faya ta zəbiye fataya, ada a gatay hərɓaɓəkka. Tə gwaɗ: «Ndo neheye faya ta tsikiye me aye nəteye tebiye na, Galile hay bəɗaw? ");
INSERT INTO meq_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ada kwa way kway eye ka tsənakwa nəteye faya ta tsikiye me tə me kway na, ma kəkay? ");
INSERT INTO meq_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Mə walaŋ kway na, siye hay ti yaw ma dala i Partiya, ma Madiya ada ma Elam. Siye hay ti yaw ma dala i Mizapotami, ma Yahuda ta Kapados ada ma dala i Poŋtus, ma dala i Azi, ");
INSERT INTO meq_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ma dala i Firigiya, ma dala i Pamfeli, ma dala i Ezipt, ta dala Libiya nakə bəse ta gəma i Siren aye. Siye hay ti yaw ma Roma, ");
INSERT INTO meq_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ma dala i Kəret ta Arabi. Mə walaŋ tay niye hay na, siye hay tə wa tay nəteye Yahuda hay, siye hay madurloŋ hay ta təra Yahuda hay matəre. Ada azlakwa ka tsənakwa nəteye faya ta ɗiye tə bazlam i gəma kway hay wu neheye bagwar eye Mbəlom a ge aye.» ");
INSERT INTO meq_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nəteye tebiye a gatay wadəŋ wadəŋ, tə sər wu nakə ta dzaliye bay. Tə tsik mə walaŋ tay, tə gwaɗ: «Wu nakay na, andza məgweɗe mey?» ");
INSERT INTO meq_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Siye hay tə ŋgwasa ka ndo məpe gər niye hay ka Yesu aye, tə gwaɗ: «Ndo neheye na, ta kwaya.» ");
INSERT INTO meq_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Piyer a tsəne bazlam niye na, a lətse. Tə lətse tə siye i ndo i maslaŋ i Yesu niye hay kuro gər eye nəte aye tebiye. Piyer a lətse na, a tsik ta magala, a gwaɗatay a ndo niye hay: «Nəkurom Yahuda hay ada tə nəkurom neheye tebiye mandza eye ma Zerozelem aye, pumay zləm a bazlam ga neheye na tsikakumeye ada tsənum wu nakə a ge bo aye lele təday. ");
INSERT INTO meq_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Andza nakə ka dzalum aye na, ndo neheye ta kwaya bay. Hərwi anəke na, mekedœ mba zlezle ta kwaya tsa ɗaw? ");
INSERT INTO meq_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ane tuk na, wu nakə Zowel ndo məɗe ha bazlam i Mbəlom a tsik ahəl niye mə Ɗerewel i Mbəlom aye na, ma giye bo anəke tuk. ");
INSERT INTO meq_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Mbəlom a gwaɗ: Mata dayaw ka mandəve i məndzibəra na, wuye mey? Na vəlateye Məsəfəre ga a ndo hay tebiye. Wawa kurom hasləka eye hay tə dem kurom hay ta təriye ndo i maslaŋ ga hay. Na ta bəzatay ha wu weɗeye a gawla kurom hay. Məsine ma ta gateye a bagwar kurom hay, na tsikiye me ma nəteye. ");
INSERT INTO meq_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ayaw! Pat eye niye na, na sləratayaweye Məsəfəre ga a ndo i məsler ga hay, ta təriye ndo i maslaŋ ga hay. ");
INSERT INTO meq_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Na ta giye masuwayaŋ mə mbəlom, ada wu neheye ta gateye hərɓaɓəkka a ndo hay aye ka məndzibəra. Ndo hay ta ŋgateye a bambaz, ta ŋgateye a ako ta geŋgis eye tərɗœleŋŋa. ");
INSERT INTO meq_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Pat ma ta dəviye sa bay ada kiye ma təriye ndozza andza bambaz. Pat eye niye na, pat bagwar eye, pat məɗəslay ha gər. Wu neheye kə ge bo tebiye na, Bəy Maduweŋ ma deyeweye tuk. ");
INSERT INTO meq_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kwa way ka ɗuwulay me a Bəy Maduweŋ mâ təma ha na, Bəy Maduweŋ ma təmiye ha.” ");
INSERT INTO meq_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«A nəkurom Israyel hay, pumay zləm a wu nakə na tsikakumeye: Yesu ndo i Nazaret na, ndo nakə Mbəlom a ɗakum ha gədaŋ ŋgay tə neŋgeye. Kə ge masuwayaŋ hay wal wal mə walaŋ kurom, kə ɗakum ha neŋgeye way na, ka sərum. ");
INSERT INTO meq_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yesu, neŋgeye Mbəlom a vəlakum ha a həlay na, andza nakə a say aye. Wu nakə ka gum ta neŋgeye na, ɓa Mbəlom a sər kurre. Nəkurom ka vəlumay ha a ndo neheye lele bay aye hay hərwi ada tâ dar na ka mayako mazləlmbaɗa eye, ada kə mət. ");
INSERT INTO meq_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ane tuk na, Mbəlom kə lətse ahaya abəra na mədahaŋ. Kə mbəla ahaya abəra mə ɗəretsətseh i mədahaŋ. A ndza ma mədahaŋ huya bay na, hərwi mədahaŋ a sla faya bay. ");
INSERT INTO meq_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Hərwi Davit kə tsik faya ahəl niye, a gwaɗ: “Na ŋgataway a Bəy Maduweŋ ga huya kame ga. Neŋgeye ka tsakay ga hərwi ada nâ dzədzar bay. ");
INSERT INTO meq_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Hərwi niye ɗərev ga kə rah ta məŋgwese, ada bazlam ga faya ma giye dəmes ta məŋgwese. Bo ga ma zəzukwiye bo lele, na dzaliye wuray sa bay. ");
INSERT INTO meq_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Bəy Maduweŋ, ka gəriye ga ha ma təv məndze i mədahaŋ hay bay. Ka gəriye ha neŋ ndo məpe mədzal gər ka nəkar nâ ze ma tsəvay bay. ");
INSERT INTO meq_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ka ɗeŋ ha tsəveɗ nakə na zəŋgaliye, ma diye ga ha a sifa aye, Ka təra ga ha ndo maŋgwasa eye hərwi nəkar tə neŋ.”» ");
INSERT INTO meq_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piyer a gwaɗatay sa: «Malamar ga hay, ka bəba təte kway Davit na, na sliye faya mətsikakum parakka lele. Neŋgeye na, kə mət. Ta la na ada ka sərakwa ha tsəvay ŋgay andaya bəgom ma təv kway. ");
INSERT INTO meq_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ane tuk na, ahəl niye na, neŋgeye ndo məɗe ha bazlam i Mbəlom. A sər ha ɓa Mbəlom kə tsikay kurre, a gwaɗay: “Aza ma dəba yak na, na ta vəliye bəy yak a ndo nəte mə walaŋ i wawa yak hay.” ");
INSERT INTO meq_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","«Neŋgeye na, ɓa kə sər ha kurre Kəriste na, ma lətseweye abəra ma mədahaŋ. “Mbəlom ma gəriye ha ma təv məndze i mədahaŋ hay bay, ada bo ŋgay ma ziye ma tsəvay bay.”» ");
INSERT INTO meq_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Piyer a gwaɗatay sa: «Yesu nakə na tsik faya aye na, Mbəlom kə lətse ahaya abəra ma mədahaŋ. Nəmay tebiye nəmaa həliye na mbal ŋgay. ");
INSERT INTO meq_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ma dəba eye na, Mbəlom kə zla na Yesu, a pa na tə həlay i mənday ŋgay. Mbəlom kə vəlay Məsəfəre Tsəɗaŋŋa eye nakə Mbəlom a tsik kurre a gwaɗ ma ta vəleye aye. Neŋgeye dərmak kə vəlamayaw wu nakə anəke ka ŋgatumay ada ka tsənum aye. ");
INSERT INTO meq_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Davit na, neŋgeye kə tsal a mbəlom təbey, ane tuk na, a gwaɗ: “Bəy Maduweŋ Mbəlom a gwaɗay a Bəy Maduweŋ ga na: Dara, ndza tə həlay i mənday ga, ");
INSERT INTO meq_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hus a pat nakə neŋ, na piye ndo məne ɗəre yak hay a huɗ i sik yak hay andza wu məpe faya sik aye təday.”» ");
INSERT INTO meq_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Nəkurom Israyel hay tebiye sərum ha ta deɗek, Yesu nakə ka darum na ka mayako mazləlmbaɗa eye na, Mbəlom a təra ha Bəy Maduweŋ ada ndo mətəme ha ndo hay na, neŋgeye.» ");
INSERT INTO meq_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ndo niye hay tebiye tə tsəne bazlam niye na, ɗərev a ye fataya abəra. Ta tsətsah ka Piyer ada ka siye i ndo i maslaŋ hay, tə gwaɗ: «Malamar hay, anəke nəmaa giye na, kəkay?» ");
INSERT INTO meq_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piyer a mbəɗatay faya, a gwaɗatay: «Gərum ha mezeleme kurom ada tâ dzəhuɓ kurom ha a yam ta məzele i Yesu Kəriste hərwi ada Yesu ma pəsakumeye ha mezeleme kurom hay. Ka gum andza niye na, Mbəlom ma vəlakumeye Məsəfəre ŋgay Tsəɗaŋŋa eye. ");
INSERT INTO meq_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Hərwi Mbəlom kə tsik kurre, a gwaɗ: Ma vəlakumeye a nəkurom ada a wawa kurom hay. A gwaɗ ma vəliye a ndo neheye nəteye mandza eye dəreŋ aye dərmak. Ayaw! Bəy Maduweŋ kway Mbəlom ma vəliye Məsəfəre ŋgay a ndo neheye ma zalateye hərwi ada tâ pay bəzay aye.» ");
INSERT INTO meq_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piyer a tsikatay bazlam mekeleŋ eye hay haladzay hərwi məmatay naha ɗərev ada tâ dzala ha. A gwaɗatay: «Dumara abəra mə walaŋ i ndo neheye seweɗ eye hay. Gərumay ha bo kurom a Mbəlom mâ təma kurom ha.» ");
INSERT INTO meq_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ndo hay haladzay mə walaŋ i ndo niye hay ta təma bazlam i Piyer. Tsa na, ta dzəhuɓ tay ha a yam. Pat eye niye na, ndo hay ta giye gwezem mahkar tə pa mədzal gər ka Yesu, ta səkah tay ha ndo məpe mədzal gər hay ka Yesu. ");
INSERT INTO meq_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nəteye niye tebiye tə paway zləm a matətike i ndo i maslaŋ i Yesu neheye ta tətikawatay aye tə metsehe lele. Tə ndzawa ka təv manəte eye, tə ndayawa wu mənday ka təv manəte eye ada ta ɗuwulaway me a Mbəlom ka təv manəte eye. ");
INSERT INTO meq_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kwa way a ndzawa na, tə madzədzere eye hərwi Mbəlom a gawa masuwayaŋ wal wal tə həlay i ndo i maslaŋ i Yesu hay. ");
INSERT INTO meq_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ndo məpe mədzal gər hay ka Yesu tebiye, nəteye madzapa eye nəte, wu tay hay tebiye ta ŋgənawa ha a bo mə walaŋ tay. ");
INSERT INTO meq_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ta səkəmawa ha wu tay hay ada ta ŋgənawa ha a bo suloy eye kwa a way ɗa ka məge wu ŋgay nakə a say aye. ");
INSERT INTO meq_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tə hayawa gər pat pat a gay i məɗəslay ha gər a Mbəlom, kwa tsekweŋ ta tərətsawa ha bay. Tə ndayawa wu mənday ka təv manəte eye mə gay tay hay. Tə ndayawa wu mənday niye na, ta məŋgwese eye, maguŋguze kwa tsekweŋ andaya bay. ");
INSERT INTO meq_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ta zambaɗaway a Mbəlom ada nəteye niye hay tebiye tə yatay a gər a ndo hay. Andza niye, Bəy Maduweŋ a təmawa tay ha ndo hay pat pat, a səkah tay ha ndo məpe mədzal gər hay ka Yesu ta ndo neheye faya ma təmiye tay ha aye. ");
INSERT INTO meq_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pat wuray Piyer ta Yuhana ti ye a gay i məɗəslay ha gər a Mbəlom mata ɗuwulay me a Mbəlom. Ti ye ta ɓəre mahkar i huwa. Ndo hay ti yawa ta ɗuwulaway naha me a Mbəlom na, ta ɓəre mahkar eye niye. ");
INSERT INTO meq_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ndoweye andaya bəse ta məgeɗ i gay i məɗəslay ha gər a Mbəlom niye. Məgeɗ nakə tə zalay məgeɗ nakə a le aye. Ndoweye niye na, matəra eye kwa abəra ka məwe ŋgay. Tə zlawa naha, tə hənawa ha bəse ta məgeɗ niye pat pat. A tsətsahawa dala ka ndo neheye ti yawa naha a gay i məvəlay wu a Mbəlom aye. ");
INSERT INTO meq_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pat eye niye na, a ŋgatay a Piyer ta Yuhana ta diye, ta fələkwiye a gay i məɗəslay ha gər a Mbəlom. Tsa na, a tsətsah fataya dala. ");
INSERT INTO meq_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piyer ta Yuhana ta ndazl na lele. Tsa na, Piyer a gwaɗay: «Zəba famaya lele.» ");
INSERT INTO meq_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tsa na, ndo niye a zəba fataya, a zəzur tay ha tə metsehe lele. Neŋgeye a dzala na, ta vəleŋeye wu. ");
INSERT INTO meq_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Piyer a gwaɗay: «Dala andaya fagaya bay tebiye, ane tuk na, na vəlakeye na, wu nakə andaya fagaya aye. Neŋ faya na gwaɗakeye ta gədaŋ i Yesu Kəriste i Nazaret lətse, do!» ");
INSERT INTO meq_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tsa na, Piyer a gəs na abəra mə həlay i mənday hərwi madzəne na ka mələtse ha ka mbəlom. Kwayaŋŋa sik ŋgay hay tə mandərkukwasl ŋgay hay tə huta gədaŋ. ");
INSERT INTO meq_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","A ndapa a mbəlom tə sik ŋgay hay lele. Tsa na, a pa bo ka mede. A ye, tə fələkwa ka bo dziye ta ndo i maslaŋ i Yesu niye hay a gay i məɗəslay ha gər a Mbəlom. Ndo niye na, a ye lele ta mandepe a mbəlom tsaɗaw tsaɗaw ada tə mazambaɗay a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ndo hay tebiye tə ŋgatay faya ma diye kuteŋ kuteŋ lele ada faya ma zambaɗeye a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Tə sər ha, neŋgeye ndo nakə a rəkawa bəse ta məgeɗ nakə a le haladzay i gay i məɗəslay ha gər a Mbəlom aye na, nəteye niye tebiye ta dzədzar ada a gatay hərɓaɓəkka hərwi wu nakə a ge bo ta ndo niye aye. ");
INSERT INTO meq_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Piyer ta Yuhana nəteye mə mazambal i gay i məɗəslay ha gər a Mbəlom nakə tə zalay Mazambal i Salomoŋ aye. Ndo nakə a mbəl abəra mə matəre aye na, a wuɗa məgəre tay ha sa bay. Ndo hay haladzay ti ye naha mahway mahway hərwi nəteye tebiye a gatay hərɓaɓəkka. ");
INSERT INTO meq_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piyer a ŋgatay a ndo neheye ti ye naha haladzay aye na, a gwaɗatay andza nakay: «Nəkurom ndo i Israyel hay, ndo nakay a mbəl na, a gakum hərɓaɓəkka na, hərwi mey? Nəkurom faya ka zəbumeye famaya andza niye na, hərwi mey? Nəkurom faya ka dzalumeye mə gər kurom na, maa mbəl ha ndo nakay na, Piyer ta Yuhana hərwi bo tay eye gədaŋ eye. Tə mbəl ha na, nəteye tə pay bəzay a Mbəlom lele. Ane tuk na, aʼay andza niye bay. ");
INSERT INTO meq_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mbəlom i Abraham, Mbəlom i Izak ada Mbəlom i Zakob nakə nəteye neheye ta ɗuwulay me aye, a bəz ha məzlaɓ i ndo i məsler ŋgay Yesu. Nəkurom eye, ka vəlumay ha a həlay i Roma hay hərwi ada tâ kəɗ na ada ka kalum ha kame i Pilat. Pilat na, haɓe a say məgəre ha. ");
INSERT INTO meq_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nəkurom ka kalum ha ndo nakə ɗaɗa neŋgeye kə ge mənese bay. Neŋgeye ndo deɗek eye. A yakum a gər ɗuh matsətsehe tâ gərakum ha na, ndo məkəɗe ndo. ");
INSERT INTO meq_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Andza niye, ka kəɗum na, ndo nakə ma vəliye sifa a ndo hay aye. Ane tuk na, Mbəlom kə lətse ahaya abəra mə walaŋ i mədahaŋ hay. Nəkway tebiye ka sərakwa ha. ");
INSERT INTO meq_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ndo nakay anaŋ ka ŋgatumay, ka sərum ha aye na, maa vəlay gədaŋ na, məzele i Yesu hərwi nakə nəmaa pa mədzal gər may ka Yesu aye. Ayaw! Ndo nakay a mbəl lele ka ŋgatumay tə ɗəre kurom aye na, hərwi nakə nəmaa pa mədzal gər ka Yesu aye. ");
INSERT INTO meq_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Malamar ga hay, ahəl nakə nəkurom ta bəy kurom hay ka kalum ha Yesu aye na, neŋ na sər ha wu nakə ka gum aye na, ka sərum bay. ");
INSERT INTO meq_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ane tuk na, Mbəlom a ge na, wu nakə a tsik ahəl niye tə bazlam i ndo məɗe ha bazlam ŋgay aye. A gwaɗ: Kəriste na, ma ta giye ɗəretsətseh. ");
INSERT INTO meq_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Anəke na, mbəɗum ha mede kurom, mbəɗumaw me ka təv i Mbəlom hərwi ada mâ mbatakum ha mənese kurom hay. ");
INSERT INTO meq_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ka gum andza niye na, Bəy Maduweŋ Mbəlom ma vəlakumeye zay ada ma ta slərakumaweye Yesu ndo mətəme ha ndo nakə a zla na kurre hərwi kurom aye. ");
INSERT INTO meq_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Anəke na, kutoŋ Yesu Kəriste ma ndziye mə mbəlom təmaɗ hus a pat nakə Mbəlom ka təra ha wu hay tebiye andza nakə a ɗa ha ahəl niye tə bazlam i ndo məɗe ha bazlam ŋgay hay aye. ");
INSERT INTO meq_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musa, neŋgeye a gwaɗatay a bəba təte kway hay: “Bəy Maduweŋ kurom Mbəlom ma ta slərakumaweye ndo məɗe ha bazlam ŋgay andza neŋ na gwaɗ bəɗaw? Neŋgeye na, slala kurom. Ka ta pumay zləm a wu nakə ma ta tsikakumeye tebiye. ");
INSERT INTO meq_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ndoweye kə pay zləm a bazlam i ndo məɗe ha bazlam i Mbəlom niye bay na, ma ndziye mə walaŋ i ndo i Mbəlom hay bay. Ta kəɗiye na mədahaŋ eye.” ");
INSERT INTO meq_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","«Siye i ndo məɗe ha bazlam i Mbəlom hay dərmak ta tsik andza i Musa. Ta tsik ka wu nakə ma giye bo ahəl kway nakay anaŋ aye. Kwa Samuyel ada kwa siye i ndo maslaŋ i Mbəlom neheye ti yaw ma dəba ŋgay aye. ");
INSERT INTO meq_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Malamar ga hay, Mbəlom a tsik wu neheye tə bazlam i ndo məɗe ha bazlam ŋgay hay na, a nəkurom. Andza niye dərmak, ahəl nakə Mbəlom a ɓar dzam ta bəba təte kurom hay aye na, a gwaɗay a Abraham: “Na ta piye ŋgama ka ndo i məndzibəra hay tebiye tə həlay i wawa i huɗ yak hay. Dzam nakə Mbəlom a ɓar aye na, i kurom.” ");
INSERT INTO meq_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Andza niye, Mbəlom a sləraw ndo i məsler ŋgay na, hərwi kurom təday. A sləraw na, hərwi məpe fakuma ŋgama, ada mətsoya kurom ahaya abəra ka tsəveɗ i mənese.» ");
INSERT INTO meq_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ahəl nakə Piyer ta Yuhana, nəteye faya ta tsikateye me a ndo hay mba aye na, ndo məvəlay wu a Mbəlom hay, bəy i ndo matsəpe gay i məɗəslay ha gər a Mbəlom ada ta Saduke hay ti ye naha ka təv tay. ");
INSERT INTO meq_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ti ye naha na, tə ge ɗərev haladzay ka Piyer ta Yuhana hərwi nəteye faya ta tətikiye tay ha ndo hay, tə gwaɗatay: «Yesu kə lətsew abəra ma mədahaŋ ada mələtsew i Yesu niye a lətsew aye na, ndo hay ta sliye faya mələtsew abəra ma mədahaŋ.» ");
INSERT INTO meq_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ndo niye hay tə gəs tay ha Piyer ta Yuhana, ta dərəzl fataya a daŋgay. Ta dərəzl fataya na, ta gatay sariya zuk bay, hərwi həvaɗ kə ge tsɨy. ");
INSERT INTO meq_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mə walaŋ i ndo neheye tə tsəne matətike i Piyer ta Yuhana aye na, ndo hay haladzay ta dzala ha ka Yesu. Ndo məpe mədzal gər ka Yesu ta səkah, ndo hay tebiye ma giye gwezem zlam. ");
INSERT INTO meq_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tədœ eye i mekedœ na, bəy i Yahuda hay, madugula i Yahuda hay ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye tə haya gər a Zerozelem. ");
INSERT INTO meq_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Mə walaŋ tay niye hay tə haya gər aye na, bagwar i ndo məvəlaway wu a Mbəlom nakə tə zalay Han aye andaya, Kayif, Yuhana, Aləgəzandər ada tə siye i ndo neheye ma bəɗgay i bagwar i ndo məvəlaway wu a Mbəlom tebiye nəteye andaya. ");
INSERT INTO meq_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tə həlataya ahaya ndo i maslaŋ i Yesu niye hay sulo eye kame tay. Tsa na, ta tsətsah fataya, tə gwaɗatay: «Ka mbəlum ha ndo nakay na, ma kəkay? Ka hutumaw gədaŋ eye na, məŋgay? Ada ka mbəlum ha na, ta məzele i way?» ");
INSERT INTO meq_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ta tsətsah fataya andza niye na, kwayaŋŋa Piyer a rah ta Məsəfəre Tsəɗaŋŋa eye, a gwaɗatay: «Nəkurom bəy mələve ndo hay ta madugula hay, ");
INSERT INTO meq_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ka tsətsahumeye famaya bazlam bəgom na, hərwi nakə nəmaa gay ŋgwalak a ndo matəra eye, a mbəl ma kəkay ka tsətsahum famaya andza niye na gwaɗ ba? ");
INSERT INTO meq_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ayaw lele! Kə ge andza niye na, nəkurom sərum ha, nəkurom tebiye tə siye i ndo i Israyel hay, sərum ha na, ndo nakə a lətse kame kurom neŋgeye zay lele aye na, ta məzele i Yesu Kəriste nakə a yaw abəra na Nazaret aye. Neŋgeye ndo nakə ka darum na ka mayako mazləlmbaɗa eye ada Mbəlom a lətse ahaya abəra ma mədahaŋ aye na, neŋgeye. ");
INSERT INTO meq_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ɗerewel i Mbəlom a tsik faya, a gwaɗ: “Kwar nakə nəkurom ndo maɗəzle gay hay ka kalum ha aye na, ka təra kwar nakə ma vəleye gədaŋ a gay aye ɗuh.” ");
INSERT INTO meq_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","«Ka mbakweye faya mətəme na, tə neŋgeye nəte ŋgweŋ. Hərwi ka məndzibəra tebiye Mbəlom kə vəl ndo mekeleŋ eye nakə ma təmiye kway ha aye na, andaya bay.» ");
INSERT INTO meq_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ndo niye hay tə haya gər aye na, a gatay wadəŋ wadəŋ. Hərwi ta zəba ka Piyer ta Yuhana na, ta dzədzar bay, tə tsik me parakka. A gatay wadəŋ wadəŋ wene wene eye na, hərwi nəteye ta tətik wuray kwa tsekweŋ bay tebiye. Tə sər ha nəteye na, ndo məpay bəzay a Yesu tsa. ");
INSERT INTO meq_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ane tuk na, nəteye faya ta ŋgateye a ndo nakə a mbəl aye dərmak, neŋgeye malətsa eye ka təv tay. Tə sər wu nakə ta mbəɗatay faya a Piyer ta Yuhana aye bay. ");
INSERT INTO meq_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tsa na, tə gwaɗatay: «Dum abəra mə gay.» Piyer ta Yuhana ti yaw wu tay abəra mə ɗəma na, nəteye tə mətsa mə gay tə ma ha ka bo bazlam. ");
INSERT INTO meq_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tə gwaɗ a bo mə walaŋ tay: «Ndo neheye ka gakweye tay ha na, kəkay? Ndo i Zerozelem hay tebiye tə sər ha masuwayaŋ nakə tə ŋgatay aye parakka, maa ge na, Piyer ta Yuhana. Ka slakweye faya məmbeɗe bay. ");
INSERT INTO meq_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ane tuk na, gakwatay me ada pakwa fataya zluwer na, tâ tətikatay bazlam nakay a ndo hay tə məzele i Yesu Kəriste bay hərwi ada siye i ndo hay tâ tsəne labara i masuwayaŋ nakə tə ge aye bay.» ");
INSERT INTO meq_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ti ye tə zalatayaw. Piyer ta Yuhana ta mbəɗa naha gər ka təv tay. Ti ye naha na, tə gatay me, tə gwaɗatay: «Kâ tsikumatay kəgəbay kâ tətikumatay a ndo hay tə məzele i Yesu sa bay.» ");
INSERT INTO meq_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ane tuk na, Piyer ta Yuhana ta mbəɗatay faya, tə gwaɗatay: «Nəkurom na, dzalum ha wu nakə deɗek eye kame i Mbəlom aye təday. Lele marəhay ha gər na, a nəkurom tsukuɗu a Mbəlom ɗaw? ");
INSERT INTO meq_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nəmaa sliye faya məgər ha matətike wu nakə nəmaa ŋgatay ada nəmaa tsəne aye bay. Nəmaa tsikiye huya.» ");
INSERT INTO meq_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ndo niye hay mahaya gər eye tə tsəne andza niye na, tə pa fataya zluwer haladzay sa. Tsa na, tə gər tay hay, ti ye wu tay. Tə gər tay ha na, ta huta fataya mənese nakə ɗa məgatay ɗəretsətseh aye bay, hərwi siye i ndo hay nəteye tebiye faya ta zambaɗeye a Mbəlom hərwi wu nakə Piyer ta Yuhana tə ge aye. ");
INSERT INTO meq_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ndo niye tə mbəl ha ta masuwayaŋ aye na, məve ŋgay ma ziye məve kuro kuro faɗ. ");
INSERT INTO meq_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tə gər tay ha Piyer ta Yuhana. Tə gər tay ha na, ta mbəɗa gər, ti ye ka təv i ndo məpe mədzal hay ka Yesu. Ti ye naha na, ta təkəratay wu nakə bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta madugula hay i Yahuda hay tə tsik aye. ");
INSERT INTO meq_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tə tsəne bazlam niye na, kwayaŋŋa nəteye tebiye tə dzapa nəte, tə pa bo ka maɗuwulay me a Mbəlom. Tə gwaɗay naha a Mbəlom: «Bəy Maduweŋ, maa ge magərmbəlom ta dala, ta bəlay ada tə wu neheye mə ɗəma tebiye aye na, nəkar. ");
INSERT INTO meq_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Maa tsik me tə bazlam i bəba təte may Davit ndo i məsler i yak na, nəkar. Neŋgeye a tsik ta gədaŋ i Məsəfəre Tsəɗaŋŋa eye, a gwaɗ: “Ndo hay tebiye tə ge mevel na, kemey? Tə ma ha ka bo bazlam na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bagwar i bəy i dala i məndzibəra hay ta ləva bo məge vəram. Bəy hay ta haya gər məge vəram ta Bəy Maduweŋ Mbəlom ada ta ndo nakə a pay dzagwa i bəy a gər aye.” ");
INSERT INTO meq_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«Andza niye deɗek, ta haya gər ma gəma nakay. Herod tə Poŋos Pilat ta gəma hay ada ndo i Israyel hay ta haya gər məge vəram ka Yesu ndo i məsler yak tsəɗaŋŋa eye. Neŋgeye nakə ka pay dzagwa i bəy a gər aye. ");
INSERT INTO meq_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Wu nakə tə ge andza nakay aye na, andza i yak nakə ka tsik kurre a saka məge ta gədaŋ yak aye. ");
INSERT INTO meq_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Anəke na, Bəy Maduweŋ may, dzəna may abəra ka təv i seweɗ tay neheye tə gamay aye tey. Vəlamay gədaŋ yak ada nəmaâ ɗa ha bazlam yak ta deɗek. ");
INSERT INTO meq_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Vəlamay gədaŋ hərwi ada nəmaâ mbəl tay ha ndo hay, hərwi ada nəmaâ ge masuwayaŋ hay wal wal ta məzele i Yesu, ndo i məsler yak tsəɗaŋŋa eye.» ");
INSERT INTO meq_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ta ndəv ha maɗuwulay me a Mbəlom na, təv nakə nəteye mahaya gər eye mə ɗəma aye a ɓəl haladzay dzekiɓ dzekiɓ. Nəteye niye tebiye, Məsəfəre Tsəɗaŋŋa eye a rahatay a bo. Kwayaŋŋa tə pa bo ka məɗe ha bazlam i Mbəlom ze madzədzere. ");
INSERT INTO meq_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ndo neheye ta təra ndo məpe mədzal gər hay ka Yesu aye na, nəteye tebiye tə ndzawa na, nəte, ta wuɗa bo lele ada mədzal gər tay nəte. Ndəray kwa nəte mə walaŋ tay mətsike nakay na, wu ga na, andaya bay. Mə walaŋ tay wu tay hay tebiye ta ŋgənawa ha a bo mə walaŋ tay. ");
INSERT INTO meq_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ndo i maslaŋ i Yesu hay tə ɗawa ha bazlam i mələtsew i Bəy Maduweŋ Yesu abəra ma mədahaŋ ta gədaŋ haladzay. Tə gwaɗawa: «Nəmaa ŋgatay kə lətsew abəra ma mədahaŋ.» Ada Mbəlom a pa ŋgama haladzay ka ndo məpe mədzal gər hay. ");
INSERT INTO meq_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ndəray mə walaŋ tay kwa tsekweŋ wu a kətsay bay. Ndo neheye guvah tay hay kəgəbay gay tay andaya na, ta səkəmawa ha. Suloy i wu nakə ta səkəm ha aye na, ti yawa ahaya ");
INSERT INTO meq_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ada tə vəlawatay a ndo i maslaŋ i Yesu hay. Ma dəba eye na, ta ŋgənawa ha suloy eye kwa a way ɗa andza nakə a say aye. ");
INSERT INTO meq_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Andza niye ndoweye andaya tə zalay Yusufa. Ndo i maslaŋ i Yesu hay tə pa faya məzele na, Barnabas, andza məgweɗe: Ndo nakə ma gwaɗiye tete a siye i ndo hay aye. Neŋgeye slala ŋgay na, Levit hay. Tə wa na ma gəma nakə tə zalay Sipəre aye. ");
INSERT INTO meq_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Neŋgeye a ye, a səkəm ha guvah ŋgay. Tsa na, a zla ahaya suloy eye, a vəlatay a ndo i maslaŋ i Yesu hay. ");
INSERT INTO meq_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ane tuk na, ndoweye andaya tə zalay Ananiyas. Tə zalay a ŋgwas ŋgay Safira. Pat wuray na, ta səkəm ha guvah tay tə gwaɗ ayaw mə walaŋ tay. ");
INSERT INTO meq_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananiyas a həl faya abəra ka suloy i guvah niye, a ye ha siye a vəlatay a ndo i maslaŋ i Yesu hay. Suloy nakə a həl faya abəra aye na, ŋgwas ŋgay a sər faya lele. ");
INSERT INTO meq_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","A ye naha na, Piyer a gwaɗay: «Ananiyas, ka gəray ha ɗərev yak a Fakalaw na, hərwi mey? Ka gər ha siye i suloy i guvah yak a mətagay, ka zlaw tsekweŋ, ka raway me a Məsəfəre Tsəɗaŋŋa eye na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ahəl nakə ka səkəm zuk bay aye na, guvah yak wu yak bəna i ndəray ɗaw? Ada suloy i guvah nakə ka səkəm ha aye na, i yak bəɗaw? Ka dzala mə gər yak məge wu andza nakay na, ma kəkay? Ka raway me na, a Mbəlom bəna, a ndo hay bay.» ");
INSERT INTO meq_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiyas a tsəne bazlam niye hay na, a dəɗ abəra ka mbəlom. Kwayaŋŋa a mət tsaɗək tsaɗək. Ndo neheye tə tsəne labara niye aye na, nəteye tebiye ta dzədzar haladzay. ");
INSERT INTO meq_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","A mət na, gawla hay ti yaw tə mbəkwa na mədahaŋ. Tsa na, tə zla na, ti ye tə la na. ");
INSERT INTO meq_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mazlambar ma giye ɓəre mahkar na, ŋgwas i Ananiyas a yaw a fələkwa a gay. A yaw na, kə sər ka wu nakə a ge bo aye bay. ");
INSERT INTO meq_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","A fələkwa naha a gay na, Piyer a tsətsah faya, a gwaɗay: «Tsikeŋ, suloy i guvah kurom nakə ka səkəmum ha ta zal yak aye na, andza nakay ɗaw?» Ŋgwas niye a mbəɗay faya, a gwaɗay: «Ayaw! Nəmaa səkəm ha na, suloy eye andza nakay.» ");
INSERT INTO meq_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Piyer a gwaɗay: «Ka mum ha ka bo bazlam mə walaŋ kurom hərwi madzəgur me ka Məsəfəre i Bəy Maduweŋ na, kəkay? Tsəne, ndo neheye tə la zal yak aye, nəteye andaya malətsa eye ka məgeɗ tsɨy ada ta deyeweye ta zliye kar dərmak.» ");
INSERT INTO meq_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Piyer a tsikay andza niye na, kwayaŋŋa a dəɗ ka sik i ndo i maslaŋ i Yesu niye hay. Tsa na, a mət. Gawla hay ti yaw, tə fələkwa naha a gay. Ti ye naha na, kə mət. Tə zla na, ti ye ha tə la na ka tsakay i zal ŋgay. ");
INSERT INTO meq_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ndo məpe mədzal gər hay ka Yesu Kəriste tebiye ada tə siye i ndo neheye tə tsəne labara niye aye na, ta dzədzar haladzay. ");
INSERT INTO meq_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ndo i maslaŋ hay tə gawa masuwayaŋ wal wal haladzay mə walaŋ i ndo hay. Ndo məpe mədzal gər hay ka Yesu tə hayawa gər a dalamətagay i gay i məɗəslay ha gər a Mbəlom, mə Mazambal i Salomoŋ. ");
INSERT INTO meq_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ndo neheye tə pa mədzal gər ka Yesu təbey aye na, zluwer a gatay mede ka təv tay. Ane tuk na, ndo hay tebiye tə ɗəslatay ha gər. ");
INSERT INTO meq_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ndo hay haladzay faya ta səkahiye, hasləka hay ta ŋgwas hay tə dzala ha ka Bəy Maduweŋ. Ndo məpe mədzal gər hay ta səkah haladzay. ");
INSERT INTO meq_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Hərwi masuwayaŋ neheye ndo i maslaŋ hay tə ge aye na, ndo hay tə həlawa naha ndo i ɗəvats hay. Tə həlawa tay naha ka sləlah kəgəbay ka hubok. Tə pawa tay ha ka tsakay i tsəveɗ hərwi ada ahəl nakə Piyer ma diye tə ɗəma aye na, kwa kəkay mezek ŋgay kə husa ka ndo nəte mə walaŋ tay ma mbəliye. ");
INSERT INTO meq_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ndo hay haladzay ti yawaw abəra ma gəma neheye tə mbay naha a Zerozelem aye. Tə həlawa naha ndo i ɗəvats ta ndo neheye məsəfəre lele bay eye hay mə bo tay aye. Ndo i maslaŋ hay tə mbəl tay ha tebiye. ");
INSERT INTO meq_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Bagwar i ndo məvəlaway wu a Mbəlom ta ndo neheye tə paway bəzay aye, andza məgweɗe ta Saduke hay, tə tsəne ndo i maslaŋ hay faya ta giye masuwayaŋ haladzay na, a ndalatay, ɗərev tay a rah ta sələk. Tə ma ha ka bo bazlam, tə gwaɗ: «Gəsakwa tay ha!» ");
INSERT INTO meq_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tsa na, ti ye tə gəs tay ha. Ti ye tə pa tay a daŋgay. ");
INSERT INTO meq_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ane tuk na, ta həvaɗ ahəl nakə ndo i maslaŋ hay nəteye ma daŋgay aye na, gawla i Mbəlom a ye, a həndəkatay na məgeɗ i gay i daŋgay niye. A həlatay ahaya ndo i maslaŋ niye hay abəra mə ɗəma, a gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Dum ta ɗumatay ha labara i sifa weɗeye a ndo hay ma dalamətagay i gay i məɗəslay ha gər a Mbəlom!» ");
INSERT INTO meq_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ndo i maslaŋ hay ta təma bazlam i gawla i Mbəlom nakə a tsikatay aye. Pərik i mekedœ na, tə həl bo ti ye a dalamətagay i gay i məɗəslay ha gər a Mbəlom. Ti ye naha tə pa bo ka matətikatay a ndo hay. Bagwar i ndo məvəlaway wu a Mbəlom ta ndo neheye nəteye dziye, tə zalatay a madugula i Yahuda hay, tə haya gər. Tə ma ha ka bo bazlam mə walaŋ tay. Tsa na, tə slər ndo hay ka ndo i maslaŋ hay a gay i daŋgay, tâ ye tâ həlatay ahaya. ");
INSERT INTO meq_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ane tuk na, ndo neheye ti ye, tə husa a ɗəma na, ta huta tay ha mə gay i daŋgay bay. Tə maw ka təv i ndo neheye tə slər tay naha aye, tə matay ha labara eye. ");
INSERT INTO meq_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Tə gwaɗatay: «Nəmaa ye naha, nəmaa ndzay a gər a gay i daŋgay na, madərəzla eye lele ada ndo matsəpe məgeɗ hay nəteye andaya faya ta tsəpiye. Ane tuk na, nəmaa həndək na məgeɗ na, nəmaa huta ndəray kwa nəte bay!» ");
INSERT INTO meq_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tə tsəne labara niye andza niye na, bəy i ndo matsəpe gay i məɗəslay ha gər a Mbəlom ta bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye tə sər wu nakə ta dzaliye bay. Ta tsətsahay a gər tay, tə gwaɗ: «Matəra ta ndo i məsler niye hay na, wuye mey?» ");
INSERT INTO meq_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ahəl nakə nəteye faya ta dzaliye andza niye na, ndoweye a yaw ka təv tay, a gwaɗatay: «Tsənum! Ndo neheye ka pum tay a daŋgay aye na, nəteye faya ta tətikateye a ndo hay mə gay i məɗəslay ha gər a Mbəlom!» ");
INSERT INTO meq_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tə tsəne andza niye na, kwayaŋŋa bəy i ndo matsəpe gay i məɗəslay ha gər a Mbəlom ta ndo ŋgay hay, ti ye mata ma tay ahaya ndo i maslaŋ niye hay. Ane tuk na, ti ye tə ma tay ahaya na, ta gatay ɗəretsətseh bay hərwi ta dzədzar ta ndo hay, ta ta kaliye tay ha tə kwar. ");
INSERT INTO meq_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ti ye tə həlatay ahaya na, ti ye tay ha kame i madugula i Yahuda hay. Bagwar i ndo məvəlaway wu a Mbəlom a pa bo ka matsətsehe fataya abəra bazlam. ");
INSERT INTO meq_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","A gwaɗatay: «Nəmaa gakum me ka matətikatay a ndo hay ta məzele i Yesu bəɗaw? Ada ka gum na, mey? Nəkurom na, tsəkam matətikatay a ndo hay ma wuzlahgəma i Zerozelem tebiye na, kəkay? Ada a sakum məgweɗe maa kəɗ na ndo niye na, nəmay ɗaw?» ");
INSERT INTO meq_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piyer tə siye i ndo i maslaŋ hay ta mbəɗatay faya, tə gwaɗatay: «Marəhay ha gər na, a Mbəlom bəna a ndo hay bay. ");
INSERT INTO meq_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ka darum na Yesu ka mayako mazləlmbaɗa eye hərwi ada mâ mət. Ane tuk na, Mbəlom i bəba təte kway hay kə lətse ahaya abəra ma mədahaŋ. ");
INSERT INTO meq_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mbəlom kə lətse ahaya abəra ma mədahaŋ ta gədaŋ ŋgay. Kə pa na a bəy, neŋgeye ndo mətəme ha ndo hərwi ada Israyel hay tâ mbəɗa ha mede tay. Ta huta, Mbəlom ma pəsatay ha mezeleme tay hay. ");
INSERT INTO meq_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nəmay na, ndo məhəle mbal i wu neheye a ge bo aye, nəmay ta Məsəfəre Tsəɗaŋŋa eye nakə Mbəlom a vəlatay a ndo neheye ta rəhay ha gər aye.» ");
INSERT INTO meq_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tə tsəne bazlam niye na, a ndalatay haladzay. A satay məɗəke tay ha ndo i maslaŋ hay. ");
INSERT INTO meq_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ane tuk na, Farisa wuray andaya məzele ŋgay Gamaliyel. Neŋgeye na, ndo mədzaŋgawa bazlam i Mbəlom mapala eye. Ndo hay tebiye ta təmawa bazlam ŋgay. A lətse mə walaŋ i ndo niye hay mahaya gər eye, a gwaɗatay: «Ndo neheye tâ ye abəra kanaŋ tsekweŋ təday.» ");
INSERT INTO meq_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ndo i maslaŋ hay ti yaw abəra mə ɗəma na, a gwaɗatay: «Israyel hay, gum metsehe hərwi wu nakə a sakum məgatay a ndo neheye. ");
INSERT INTO meq_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ndo niye məzele ŋgay Tiyodas aye na, mâ makumaw a gər. A yaw ahəl niye a gwaɗ neŋgeye na, bagwar i ndo. Ndo hay ta giye temerre faɗ ta pay bəzay. Ane tuk na, ta kəɗ na. Ndo neheye tə pay bəzay aye ta ŋgəna gər tebiye. Kwa ndəray ka ləkaw bay. ");
INSERT INTO meq_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","«Ma dəba ŋgay na, ndoweye andaya dərmak, məzele ŋgay Yudas. Neŋgeye ndo i Galile. Neŋgeye a ndohwaw ahəl i məpesle ndo, kə zalatay a ndo hay haladzay ka məpay bəzay. Neŋgeye dərmak ta kəɗ na ada ndo neheye tə pay bəzay aye ta ŋgəna gər tebiye kweye kweye. ");
INSERT INTO meq_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Neŋ faya na tsikakumeye anəke, kâ mətsum ka ndo neheye bay, gərum tay ha tâ ye wu tay. Hərwi kə ge mədzal gər tay, ta məsler tay, ti yaw ma ndo hay na, ta ndziye bay. Ta dziye. ");
INSERT INTO meq_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ane tuk na, kə ge məsler tay a yaw abəra mə həlay i Mbəlom na, ka slumeye faya məmbete ha bay. Gum metsehe lele, faya ka gumeye vəram na, ka Mbəlom ɗuh!» ");
INSERT INTO meq_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ndo niye hay mahaya gər eye ta təma bazlam i Gamaliyel. Tə zalatay a ndo i maslaŋ hay sa. Ti ye naha, tə ndaɓa tay ha. Tə gwaɗatay: «Ɗaɗa kâ tsikumay me a ndəray tə məzele i Yesu sa bay.» Tsa na, tə gər tay ha. ");
INSERT INTO meq_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ndo i maslaŋ i Yesu niye hay ti yaw abəra mə walaŋ i məhay gər tay niye tə məŋgwese hərwi ɗəretsətseh nakə tə gatay hərwi məzele i Yesu aye. ");
INSERT INTO meq_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ɗuh ta tətikawa ada tə ɗawa ha mə gay i məɗəslay ha gər a Mbəlom ada mə gay tay hay pat pat tə gərawa ha bay, Yesu na, Kəriste. ");
INSERT INTO meq_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ahəl niye na, ndo məpe mədzal gər hay ka Yesu faya ta səkahiye haladzay. Ane tuk na, ndo məpe mədzal gər neheye tə tsik me i Gərek aye na, tə ge ɗərev ka ndo məpe mədzal gər neheye nəteye tə tsik bazlam i Yahuda hay aye. Tə ge ɗərev na, hərwi ahəl nakə ta ŋgənawatay wu mənday a madakway i ŋgwas hay aye na, tə vəlawatay a madakway i ŋgwas tay hay təbey. ");
INSERT INTO meq_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ndo i maslaŋ neheye kuro gər eye sulo aye, tə hayatay gər a ndo məpe mədzal gər hay ka Yesu, tə gwaɗatay: «Nəmaa gəriye ha məɗe ha bazlam i Mbəlom hərwi məmətse maŋgəne wu mənday bay. ");
INSERT INTO meq_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hərwi niye malamar hay, pəlum ndo hay tasəla mə walaŋ kurom. Ka pəlumeye na, ndo i ŋgwalak hay, ndo neheye nəteye maraha eye ta Məsəfəre Tsəɗaŋŋa eye ada tə sər gər lele aye. Nəmaa vəliye məsler i maŋgəne wu mənday na, a həlay tay. ");
INSERT INTO meq_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nəmay, nəmaa ɗuwulay me a Mbəlom ada ta məɗe ha bazlam ŋgay a ndo hay.» ");
INSERT INTO meq_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Bazlam tay niye a yatay a gər a ndo hay tebiye. Tsa na, tə pala ndo hay tasəla. Ndo makurre eye na, Etiyen, ndo nakə ta mədzal gər lele ada maraha eye ta Məsəfəre Tsəɗaŋŋa eye, Filip, Pərakor, Nikanor, Timoŋ, Parmenas ada Nikolas ndo i gəma i Aŋtiyos neŋgeye a gawa kule, ane tuk na, ahəl niye na, ka dazlay a məpay bəzay a kule i Yahuda hay. ");
INSERT INTO meq_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tsa na, ti ye tay ha ka təv i ndo i maslaŋ i Yesu hay. Ndo i maslaŋ i Yesu hay tə pa fataya həlay ada ta ɗuwulay me a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Bazlam i Mbəlom a ɗa a zləm haladzay. Ndo məpe mədzal gər hay ta səkah haladzay ma Zerozelem ada ndo məvəlay wu a Mbəlom hay haladzay tə dzala ha ka Yesu. ");
INSERT INTO meq_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etiyen na, ndo nakə nəte mə walaŋ i ndo neheye tə pala tay tasəla aye. Neŋgeye na, Mbəlom kə pa faya ŋgama haladzay. Ka tsəveɗ i Mbəlom na, neŋgeye gədaŋ eye haladzay. A gawa masuwayaŋ hay mə walaŋ i ndo hay. ");
INSERT INTO meq_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Siye i Yahuda hay nəteye andaya, tə haya gər a gay i maɗuwule me nakə tə zalay gay i maɗuwule me i beke neheye tə gər tay ha aye. Ti yaw ma gəma i Siren ada ma gəma i Aləgəzandəri, ti yaw ma dala i Silisi ada ma dala i Azi. Nəteye niye tebiye ta təma bazlam i Etiyen bay, faya ta kəɗiye wuway ta neŋgeye. ");
INSERT INTO meq_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ane tuk na, ndo niye hay tə mba ka Etiyen tə bazlam bay, hərwi maa vəlay ndaraw ka mətsike me na, Məsəfəre i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tə vəlatay wu a ndo hay, hərwi ada ndo niye hay tâ raw me tâ gwaɗ na: «Nəmaa tsəne faya abəra bazlam, faya ma tsaleye ka gər a Musa ada faya ma tsaleye ka gər a Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Tə suta faya ndo hay, madugula hay ada ta ndo mədzaŋgawa bazlam i Mbəlom mapala eye ka Etiyen. Tsa na, tə wuya kurah ka Etiyen, tə gəs na. Ti ye ha kame i madugula i Yahuda hay. ");
INSERT INTO meq_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tə həl naha ndo məɗəse faya parasay hay, tə gwaɗ: «Ndo nakay na, faya ma tsikiye wu lele bay eye ka gay i məɗəslay ha gər a Mbəlom ada ka bazlam i Musa mapala eye. ");
INSERT INTO meq_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nəmaa tsəne faya abəra a gwaɗ: Yesu ndo i Nazaret ma deyeweye, ma mbəzliye ha gay i məɗəslay ha gər a Mbəlom ada ma mbəɗiye ha kule kway nakə Musa a vəlakway aye.» ");
INSERT INTO meq_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ndo niye hay tebiye nəteye mandza eye mə gay i məhay gər aye, tə ma ha ɗəre ka Etiyen. Ta zəba faya, tə ŋgatay na, daʼar ŋgay a dəv andza i gawla i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Bagwar i ndo məvəlaway wu a Mbəlom a tsətsah ka Etiyen, a gwaɗay: «Wu nakə tə tsik fakaya na, deɗek ɗaw?» ");
INSERT INTO meq_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiyen a mbəɗay faya, a gwaɗay: «Malamar ga hay ta bəba ga hay, tsənum wu nakə na tsikakumeye təday. Mbəlom nakə a ze wu hay tebiye ta məzlaɓ aye a bəzay ha bo a bəba təte kway Abraham ka dala i Mizapotami kurre ahəl nakə ki ye a Haraŋ zuk bay aye, ");
INSERT INTO meq_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ada a gwaɗay: “Lətse abəra ma gəma yak ada gər ha ndo yak hay, do a gəma nakə na ɗakeye faya aye.” ");
INSERT INTO meq_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","«Yaw! Abraham a tsəne bazlam i Mbəlom na, a lətse abəra ma Kaladeyen hay, a ye mata ndze ma Haraŋ. Ma dəba eye bəba ŋgay a mət na, Mbəlom a zla na abəra ma Haraŋ, a ye ha a gəma nakay anaŋ nəkway mandza eye mə ɗəma aye. ");
INSERT INTO meq_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Mə ɗəma na, Mbəlom kə vəlay guvah i məda ŋgay kwa tsekweŋ bay, kwa dala tsekweŋ bəbay na, kə ɗəsay bay. Ɓa Mbəlom kə tsikay kurre, a gwaɗay: “Gəma nakay na, na ta vəlakeye ha tebiye. Aza nəkar andaya sa bay na, wawa i huɗ yak hay ta ndziye mə ɗəma, ma təriye i tay.” Ahəl niye Mbəlom a tsikay a Abraham na, wawa ŋgay andaya kwa nəte zuk bay. ");
INSERT INTO meq_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Wu nakə Mbəlom a tsikay aye na, a gwaɗay: “Wawa i huɗ yak hay ta diye, ta ndziye ma gəma i ndo hay. Mə ɗəma na, ta təriye tay beke eye hay. Ta gateye ɗəretsətseh. Ta ndziye məve temerre faɗ mə ɗəretsətseh. ");
INSERT INTO meq_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ane tuk na, na ta giye sariya ka ndo i gəma niye hay tə gatay ɗəretsətseh aye. Ma dəba eye na, ta diye abəra ma gəma nakay, ta diye ta ɗəsleŋ ha gər ma təv nakə ta ndziye mə ɗəma aye.” ");
INSERT INTO meq_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Mbəlom a ɓar dzam ta Abraham, a ɗay ha na, ta məɗəse bo. Ma dəba eye, Abraham a wa Izak, a ge məhəne tsamahkar na, a ɗəs na. Izak a wa Zakob, Izak a ɗəs na. Zakob dərmak a wa wawa hay kuro gər eye sulo. Nəteye neheye ta təra bəba təte kway hay na, Zakob a ɗəs tay ha dərmak. ");
INSERT INTO meq_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Bəba təte kway hay tə nay ɗəre a malamar tay nakə nəte mə walaŋ tay tə zalay Yusufa aye. Tə gəs na ta səkəm ha beke eye a gəma i Ezipt. Ane tuk na, Mbəlom ka tsəpa na. ");
INSERT INTO meq_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Mbəlom kə təma ahaya Yusufa abəra mə ɗəretsətseh hay tebiye. A vəlay metsehe ta ŋgwalak i bo ka ɗəre i bəy nakə a ləva Ezipt tebiye, tə zalay Farawoŋ aye. Neŋgeye a pa na bəy eye ka dala i Ezipt ada a ləvay gər a ndo neheye mə gay ŋgay aye tebiye. ");
INSERT INTO meq_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«Ma dəba eye na, mandərzlaŋ a ge ka dala i Ezipt tebiye ada ka dala i Kanan. Mandərzlaŋ niye a ge na, mandərzlaŋ bagwar eye. Ndo hay ta sa ɗəretsətseh haladzay. Bəba təte kway hay tə huta wu mənday kwa tsekweŋ bay tebiye. ");
INSERT INTO meq_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Zakob a tsəne wu mənday andaya ma Ezipt na, a slər wawa ŋgay niye hay ta təra bəba təte kway aye. A slər tay ha makurre eye. ");
INSERT INTO meq_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ta mbəɗa gər masulo eye na, Yusufa a ɗatay ha bo ada Farawoŋ bəy bagwar eye a sər ha nəteye na, gwala i Yusufa hay. ");
INSERT INTO meq_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tsa na, Yusufa a slər ndo hay ka bəba ŋgay Zakob ta ndo i gay ŋgay hay tebiye. Nəteye tebiye na, kuro kuro tasəla gər eye zləm. ");
INSERT INTO meq_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Zakob tə həl bo, ti ye a Ezipt ta ndo i gay ŋgay hay. Zakob a mət mə ɗəma ada bəba təte kway hay dərmak tə mət mə ɗəma. ");
INSERT INTO meq_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mədahaŋ tay na, tə həlawa a gəma nakə tə zalay Sisem aye. Tə pawa a tsəvay nakə Abraham a səkəm abəra ka wawa i Hamor ma gəma i Sisem ta suloy aye. ");
INSERT INTO meq_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Wu nakə Mbəlom a tsikay kurre a Abraham aye na, mazlambar həlay eye kə ndislew. Gwala kway hay tə wa bo. Ta səkah məwe bo haladzay ma Ezipt. ");
INSERT INTO meq_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Bəy nakə a sər Yusufa aye na, andaya sa bay. Tə pa na bəy weɗeye nakə faya ma ləviye dala i Ezipt aye. Neŋgeye na, a sər Yusufa bay. ");
INSERT INTO meq_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Bəy niye bagwar eye a vatay gər a bəba təte kway hay. A gawatay ɗəretsətseh haladzay ada a gawatay kutoŋ ka məkwetse wawa tay a pesl ada tâ mət. ");
INSERT INTO meq_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Həlay niye na, tə wa na Musa. Musa a le haladzay ada a yay a gər a Mbəlom. Tə wa na na, tə gəl na kiye mahkar mə gay i bəba ŋgay. ");
INSERT INTO meq_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ma dəba eye na, tə gər ha. Dem i Farawoŋ a ndzay a gər, a zla na. A ye ha a gəl na andza wawa ŋgay. ");
INSERT INTO meq_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Andza niye, Musa a gəl bo na, a zla metsehe ta ndaraw i Ezipt hay. A təra ndo ta məzlaɓ eye hərwi bazlam ŋgay neheye a tsikawa aye ta məsler neheye a gawa aye. ");
INSERT INTO meq_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Musa a ge məve kuro kuro faɗ na, a say mede mata dzəne tay ha gwala ŋgay Israyel hay. ");
INSERT INTO meq_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","A ye na, a ŋgatay a ndo i Ezipt faya ma geye ɗəretsətseh a ndo nəte mə walaŋ i Israyel hay. Tsa na, a ye naha a dzəna na ndo niye faya ta geye ɗəretsətseh aye. A kəɗ na ndo i Ezipt niye mədahaŋ eye. ");
INSERT INTO meq_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa a dzala na, Israyel malamar ŋgay hay tə sər ha Mbəlom ma ta təmiye tay ha abəra mə ɗəretsətseh tə həlay ŋgay. Ane tuk na, tə sər bay. ");
INSERT INTO meq_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tədœ eye Musa a ndzatay a gər a Israyel hay sulo faya ta kəɗiye bo. A say a Musa maŋgəne tay ha ada tâ ndza zay mə walaŋ tay. A gwaɗay: “Dzam ga, nəkurom ta malamar tuk na, ada ka gumeye ɗəretsətseh a bo kurom ta məkəɗe bo na, hərwi mey?” ");
INSERT INTO meq_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ane tuk na, ndo nakə faya ma geye ɗəretsətseh a malamar ŋgay aye na, a pay həlay a Musa, a gwaɗay: “Maa pa kar bəy ada ndo məge may sariya na, way? ");
INSERT INTO meq_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","A saka məkəɗe ga andza nakə ka kəɗ ndo i Ezipt məveneŋ aye sa ɗaw?” ");
INSERT INTO meq_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa a tsəne andza niye na, a hway, a ye ŋgway ka dala i Madiyan. Mə ɗəma na, a zla ŋgwas. Tə wa wawa hasləka eye hay sulo. ");
INSERT INTO meq_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Ma dəba i məve kuro kuro faɗ na, Musa neŋgeye huya ma gəma niye mə makulkwandah aye. Pat wuray na, neŋgeye bəse ta mahəmba i Sinay. Gawla i Mbəlom a yaw, a bəzay ha bo. Musa a ŋgatay na, ma ako ka gay i dak nakə faya ma təmiye aye. ");
INSERT INTO meq_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa a ŋgatay andza niye na, a gay hərɓaɓəkka. Ane tuk na, ahəl nakə neŋgeye faya ma həndzəɗiye naha faya bəse mazəbe faya na, a tsəne mətsike me i Bəy Maduweŋ, a gwaɗayaw: ");
INSERT INTO meq_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Neŋ Mbəlom i bəba təte yak hay, Mbəlom i Abraham, Mbəlom i Izak, ada Mbəlom i Zakob.” Musa a tsəne andza niye na, a dzədzar, zluwer a gay. Tsa na, a say mazəbe ɗəre ka ako niye sa bay. ");
INSERT INTO meq_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mbəlom a gwaɗayaw sa: “Musa, tsok na tahərak abəra mə sik, hərwi təv nakay nəkar mə ɗəma aye na, təv tsəɗaŋŋa eye. ");
INSERT INTO meq_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Faya ta gateye ɗəretsətseh a ndo ga hay ma Ezipt kəkay na, na ŋgatay. Na tsəne mətuwe tay ada na yaw na, mata mbəle tay ha. Na sləriye kar ha, do anəke a Ezipt.” ");
INSERT INTO meq_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Musa neŋgeye nakə Israyel hay tə kal ha, tə gwaɗay: “Maa pa kar bəy ada ndo məge may sariya na, way?” aye. Ane tuk na, Mbəlom a slər ka təv tay hərwi ada mâ təra bəy tay ada ndo mətəme tay ha abəra mə ɗəretsətseh na, neŋgeye. Mata sləre na ka məsler niye na, gawla i Mbəlom nakə a bəzay ha bo ma ako ka gay i dak aye. ");
INSERT INTO meq_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Maa ndzatay kame a Israyel hay məndohwaw abəra ma Ezipt na, neŋgeye. Kə ge masuwayaŋ hay wal wal mə ɗəma. Kə ge kame i Bəlay Ndozza eye ada mə makulkwandah dərmak hus a məve kuro kuro faɗ. ");
INSERT INTO meq_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","«Maa gwaɗatay a Israyel hay: “Mbəlom ma ta slərakumaweye ndo məɗe ha bazlam ŋgay andza neŋ. Ma zliye na, abəra ma gwala kurom” na, Musa. ");
INSERT INTO meq_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Sa na, ahəl nakə Israyel hay nəteye mahaya gər eye mə makulkwandah aye na, maa lətse mə walaŋ i bəba təte kway ta gawla nakə a tsikawatayaw me mə mahəmba i Sinay aye na, Musa. Gawla i Mbəlom ma tsikataweye bazlam nakə ma vəliye sifa aye ada neŋgeye ma makweye ha. ");
INSERT INTO meq_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«Ane tuk na, bəba təte kway hay ta kərah matəme bazlam ŋgay. Ta kal na a pesl. A satay mambəɗe gər ka dala i Ezipt. ");
INSERT INTO meq_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tə gwaɗay a Aroŋ: “Lambaɗamay mbəlom hay hərwi məzle kame kway. Hərwi ka sərakwa wu nakə a ndzay a gər a Musa, ndo məhəlakway ahaya abəra mə Ezipt na, ka sərakwa bay.” ");
INSERT INTO meq_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tsa na, ta lambaɗ kule andza sla wawa eye andza mbəlom tay. Tə vəlay wu a kule tay niye. Tə ge magurlom tə məŋgwese eye lele hərwi wu nakə bo tay eye ta lambaɗ aye. ");
INSERT INTO meq_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ane tuk na, Mbəlom a mbəɗatay dəba. Ma dəba eye tə ɗəslay ha gər a wurzla hay. Mbəlom a vəlay tsəveɗ andza nakə mawatsa eye mə ɗerewel i ndo məɗe ha bazlam i Mbəlom hay, Mbəlom a gwaɗ: “A nəkurom Israyel hay, wu neheye hay ka vəlawum wal wal ada ta gənaw hay məve kuro kuro faɗ aye na, a neŋ bəɗaw? ");
INSERT INTO meq_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ka zlum madzawadzawa i gay i mbəlom kurom Molok, ka zlum mandzəkit bo i wurzla i mbəlom kurom Refam. Kule kurom neheye ka gum aye na, hərwi məɗəslay ha gər. Hərwi niye na həliye kurom abəra ma gəma nakay, na diye kurom ha dəreŋ abəra ta gəma i Babilon.”» ");
INSERT INTO meq_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Etiyen a gwaɗatay sa: «Ahəl niye bəba təte kway hay nəteye mə makulkwandah na, madzawadzawa i məɗəslay ha gər a Mbəlom andaya fataya hərwi ada tâ sər ha Mbəlom andaya ta nəteye. Gay niye mapa eye na, andza nakə Mbəlom a tsikay a Musa aye. Mbəlom a gwaɗay a Musa tâ ge na gay niye na, andza nakə a ŋgatay aye. ");
INSERT INTO meq_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ma dəba eye na, bəba təte kway hay ta vəlatay ha madzawadzawa i məɗəslay ha gər a Mbəlom niye a wawa i huɗ tay hay. Ndo məndzatay kame a wawa i huɗ tay niye hay na, Zozowe. Ti ye a gəma niye na, ta zla na gay i madzawadzawa niye. Mbəlom ka həhar tay ha ndo i gəma niye abəra kame tay. Ta sla fataya. Andza niye gay i madzawadzawa a ndza ma gəma niye hus a həlay i bəy Davit. ");
INSERT INTO meq_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davit na, a yay a gər a Mbəlom haladzay. A tsətsah tsəveɗ ka Mbəlom ka maɗəzlay gay nakə wawa i huɗ i Zakob hay ta sliye faya məɗəslay ha gər a Mbəlom mə ɗəma aye. ");
INSERT INTO meq_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Maa ɗəzlay gay na, Salomoŋ. ");
INSERT INTO meq_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«Ane tuk na, Mbəlom Fetek ma ndziye mə gay neheye ndo hay ta ɗəzl aye bay. Andza nakə mawatsa eye mə ɗerewel i ndo məɗe ha bazlam i Mbəlom aye na, Mbəlom a gwaɗ: ");
INSERT INTO meq_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Təv məndze i bəy ga na, mbəlom, ada məndzibəra na, təv sik ga. Gay nakə ka ɗəzlumeŋeye na, slala i gay waray? Təv nakə ma sliye məndze mə ɗəma aye na, waray? ");
INSERT INTO meq_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Maa ge wu neheye tebiye na, neŋ bəɗaw?”» ");
INSERT INTO meq_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Etiyen a gwaɗatay sa: «A nəkurom neheye seweɗ eye hay. Ka dərəzlum na ɗərev kurom ta zləm kurom hay a məzele i Mbəlom nakə faya ma zalakumeye. A sakum mahəndəkay na ɗərev kurom a Məsəfəre Tsəɗaŋŋa eye bay. Nəkurom na, andza bəba təte kurom hay. ");
INSERT INTO meq_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ndo məɗe ha bazlam i Mbəlom waray nakə bəba təte kurom hay ta gay ɗəretsətseh bay aye? Kwa məkəɗe ta kəɗ tay ha ndo neheye tə ɗa ha madayaw i ndo nakə neŋgeye ndo i deɗek nəte ŋgweŋ aye. Ndo nakə anəke ka gum faya ɗaf ada ka kəɗum na aye na, neŋgeye. ");
INSERT INTO meq_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mbəlom kə vəlakum bazlam ŋgay mapala eye tə həlay i gawla ŋgay hay, ane tuk na, ka rəhumay ha gər bay.» ");
INSERT INTO meq_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ndo niye hay mahaya gər eye tə tsəne bazlam i Etiyen niye na, a ndalatay haladzay, ta həpəɗ zler ka Etiyen kəraw kəraw. ");
INSERT INTO meq_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ane tuk na, Etiyen na, a rah ta Məsəfəre Tsəɗaŋŋa eye. Tsa na, a zəba ɗəre a mbəlom. A ŋgatay naha a dzaydzay i Mbəlom ada a ŋgatay naha a Yesu malətsa eye tə həlay i mənday i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","A gwaɗatay a ndo niye hay: «Tsənum! Neŋ faya na ŋgateye a mbəlom mahəndəka eye ada Wawa i Ndo neŋgeye malətsa eye tə həlay i mənday i Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tə tsəne andza niye na, nəteye tebiye ta wuda haladzay ada ta dərəzl na zləm tay hay. Nəteye tebiye ka manəte eye tə mbəzla ka Etiyen məgəse. ");
INSERT INTO meq_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Tə gəs na, tə vaha na abəra mə wuzlah gay. Ti ye naha, tə pa bo ka məkele na tə kwar hərwi məkəɗe na. Ndo məhəle mbal hay ta tsok na petekeɗ tay hay, tə gər ha ka təv i gawla eye andaya tə zalay Sol. ");
INSERT INTO meq_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ahəl nakə nəteye faya ta kaliye Etiyen tə kwar aye na, Etiyen neŋgeye faya ma ɗuwuleye me a Mbəlom. Mə maɗuwule me niye faya ma ɗuwuliye na, a gwaɗ: «Bəy Maduweŋ ga Yesu, zla na məsəfəre ga.» ");
INSERT INTO meq_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tsa na, a dəkw gurmets, a wuda ta magala, a gwaɗ: «Bəy Maduweŋ ga, mezeleme nakay tə ge aye na, kâ matay ha mənese bay.» A tsik andza niye na, ma dəba eye a mət. ");
INSERT INTO meq_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Məkəɗe Etiyen nakə tə kəɗ aye na, a yay a gər a Sol. Pat eye niye na, kwayaŋŋa ta dazlay a məgatay ɗəretsətseh a ndo məpe mədzal gər hay ka Yesu Kəriste neheye ma Zerozelem aye. Ndo məpe mədzal gər hay ka Yesu ta ŋgəna gər, ta hway tebiye. Ta hway a gəma i Yahuda ada siye hay a Samari. Maa ze naha na, ndo i maslaŋ hay. ");
INSERT INTO meq_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Siye neheye tə pa mədzal gər tay deɗek ka Yesu aye, ti ye tə zla na mədahaŋ i Etiyen, tə la na. Tə tuwa na haladzay. ");
INSERT INTO meq_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sol na, a zaka ha mabəbezle tay ha ndo məpe mədzal gər hay ka Yesu. A yawa ka gay ka gay, a gəsawa ndo məpe mədzal gər hay ka Yesu, hasləka hay kwa ŋgwas. A pawa tay ha a gay i daŋgay. ");
INSERT INTO meq_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ndo neheye ta hway, ta ŋgəna gər aye na, ta həhal ka gəma ka gəma. Tə ɗawa ha bazlam i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip neŋgeye na, a ye a wuzlah i dala i Samari. A ye naha, a ɗa ha Yesu ndo mətəme ha ndo nakə Mbəlom a sləraweye. ");
INSERT INTO meq_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ndo i gəma niye hay tebiye tə tsəne bazlam i Filip ada tə ŋgatay a masuwayaŋ neheye a ge aye na, tə pay zləm a bazlam ŋgay ta səkeffe eye lele. ");
INSERT INTO meq_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Fakalaw hay tə yawaw abəra mə bo i ndo i ɗəvats hay. Tə yawaw abəra mə bo tay na, ta wudawa ka bo haladzay. Ndo neheye vərezl i bo tay maməta eye hay ta ndo neheye ta dzəgəɗasla sik tay matəra eye hay aye, ta mbəl. ");
INSERT INTO meq_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Andza niye məŋgwese bagwar eye a ge ma gəma niye. ");
INSERT INTO meq_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ahəl niye na, ndoweye andaya ka dala i Samari eye niye. Ndoweye niye na, tə zalay Simoŋ. Neŋgeye na, a gawa maharam zla anəke bay ada maharam ŋgay nakə a gawa aye na, a gawatay a ndo i gəma niye hay hərɓaɓəkka. Ma mədzal gər ŋgay na, a gwaɗ neŋgeye ŋgwalak i ndo. ");
INSERT INTO meq_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ndo hay tebiye, gawla hay ta bagwar hay, tə pa zləm na, ka neŋgeye. Tə gwaɗ: «Ndo nakay na, gədaŋ i Mbəlom bagwar eye nakə tə zalay Gədaŋ Bagwar eye.» ");
INSERT INTO meq_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tə pawa zləm ka wu ŋgay nakə a gawa aye na, lele. Hərwi maharam ŋgay nakə a gawatay masuwayaŋ a ndo hay aye na, kə ndza haladzay. ");
INSERT INTO meq_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ane tuk na, Filip a ye naha mata ɗa ha Labara Ŋgwalak eye ka Bəy i Mbəlom ada ka Yesu Kəriste na, tə dzala ha ka Yesu. Hasləka hay, ŋgwas hay, Filip a dzəhuɓ tay ha a yam. ");
INSERT INTO meq_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simoŋ neŋgeye dərmak a dzala ha ka Yesu, ta dzəhuɓ ha a yam. Neŋgeye na, a ndzawa ka təv i Filip. A ŋgataway a masuwayaŋ tə wu hay wal wal neheye Filip a gawa aye na, a gay hərɓaɓəkka. ");
INSERT INTO meq_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ndo i maslaŋ neheye nəteye ma Zerozelem aye tə tsəne ndo i gəma i Samari hay ta pa mədzal gər tay ka bazlam i Mbəlom na, tə sləratay naha Piyer ta Yuhana. ");
INSERT INTO meq_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tə həl bo, ti ye. Tə ndisl naha a ɗəma na, ta ɗuwulay me a Mbəlom hərwi ada ndo i gəma i Samari niye hay tə pa gər ka bazlam i Mbəlom aye tâ huta Məsəfəre Tsəɗaŋŋa eye. ");
INSERT INTO meq_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ahəl nakə ta dzəhuɓ tay ha a yam aye na, ta dzəhuɓ tay ha tə məzele i Yesu Bəy Maduweŋ. Ndo kwa nəte mə walaŋ tay Məsəfəre Tsəɗaŋŋa eye kə mbəzlaw faya zuk bay. ");
INSERT INTO meq_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Hərwi niye, Piyer ta Yuhana tə pa fataya həlay, ta ɗuwulay me a Mbəlom. Tsa na, tə huta Məsəfəre Tsəɗaŋŋa eye. ");
INSERT INTO meq_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoŋ a ŋgatay a ndo məpe mədzal gər hay ka Yesu tə huta Məsəfəre Tsəɗaŋŋa eye hərwi nakə ndo i maslaŋ hay tə pa fataya həlay aye na, a vəlatay suloy a Piyer ta Yuhana. ");
INSERT INTO meq_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","A gwaɗatay: «Vəlumeŋ gədaŋ eye dərmak hərwi ada ndo neheye na piye fataya həlay aye na, tâ huta Məsəfəre Tsəɗaŋŋa eye.» ");
INSERT INTO meq_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ane tuk na, Piyer a mbəɗay faya, a gwaɗay: «Dze ta suloy yak tebiye, hərwi nəkar ka dzala mə gər yak masəkəme gədaŋ i Mbəlom na, ta suloy! ");
INSERT INTO meq_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ka məsler nakay nəmay faya nəmaa giye na, ka sliye faya mədzepe tə nəmay bay hərwi ɗərev yak tsəɗaŋŋa kame i Mbəlom bay. ");
INSERT INTO meq_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ɗa ha mezeleme yak, ɗuwulay me a Bəy Maduweŋ ada agəna ma pəsakeye ha mədzal gər yak neheye lele bay eye. ");
INSERT INTO meq_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Na zəba faya na, ɗərev yak maraha eye ta bor i bo ada mezeleme kə pa kar a daŋgay.» ");
INSERT INTO meq_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoŋ a tsəne bazlam niye hay na, a gwaɗatay a Piyer ta Yuhana: «Bo kurom eye, ɗuwulumay me a Bəy Maduweŋ hərwi ga hərwi ada wu nakay ka tsikum aye mâ təra tə neŋ bay tey.» ");
INSERT INTO meq_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ma dəba eye na, Piyer ta Yuhana tə ɗa ha Yesu ada tə ɗa ha bazlam ŋgay a ndo hay. Tsa na, tə həl bo, ta mbəɗa gər a Zerozelem. Nəteye ka tsəveɗ faya ta diye na, tə ɗa ha Labara Ŋgwalak eye ma gəma hay wal wal ka dala i Samari. ");
INSERT INTO meq_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ma dəba eye na, gawla i Mbəlom a gwaɗay a Filip: «Do, ka diye na, ka zəŋgaliye tsəveɗ nakə a ye ta diye i tsakay aye, ta tsəveɗ nakə a yaw abəra ma Zerozelem a ye a gəma i Gaza aye. Tsəveɗ eye niye na, a ye tə kəsaf.» ");
INSERT INTO meq_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filip a tsəne na, kwayaŋŋa a həl bo, a ye. A husa ka tsəveɗ, faya ma diye na, a ŋgatay a ndo wuray, neŋgeye bagwar i ndo məge məsler i Bəy i Etiyopi Kandəs. Məsler ŋgay na, mələvay gər a suloy i bəy. Bəy i Etiyopi niye na, ŋgwas eye. A ye a Zerozelem mata ɗəslay ha gər a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Anəke na, faya ma maweye abəra ma Zerozelem, ma diye a mətagay. Neŋgeye mandza eye mə muta i pəles ŋgay faya ma diye ha. Neŋgeye faya ma dzaŋgiye ɗerewel i Ezay ndo məɗe ha bazlam i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Filip a ŋgatay a ndo niye na, Məsəfəre Tsəɗaŋŋa eye a gwaɗay: «Hway bəse ka tsakay i muta i pəles taɗay faya ma diye aye.» ");
INSERT INTO meq_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filip a tsəne andza niye na, a hway, a ye a həndzəɗ naha faya. Nəteye faya ta diye na, a tsəne ndo i Etiyopi niye faya ma dzaŋgiye ɗerewel i Ezay ndo məɗe ha bazlam i Mbəlom. Filip a tsətsah faya, a gwaɗay: «Wu nakə faya ka dzaŋgiye na, ka tsəne ŋgway ɗaw?» ");
INSERT INTO meq_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ndo niye a mbəɗay faya, a gwaɗay: «Kə ge ndəray kə ɗeŋ ha bay na, na sliye faya mətsəne na, ma kəkay?» Tsa na, a gwaɗay a Filip: «Tsalaw a muta i pəles ada ndza ka tsakay ga.» ");
INSERT INTO meq_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ndo niye faya ma dzaŋgiye mə ɗerewel niye na, wuye mey? Təv nakə faya ma dzaŋgiye mə ɗəma aye na, a gwaɗ: «Neŋgeye a təra andza təɓaŋ nakə tə gəs, ta diye ha ka təv nakə tə kəɗawa wu mə ɗəma aye. Neŋgeye a təra andza təɓaŋ nakə ta ɗəsiye faya abəra məkwets na, a tuwa bay aye. Ka həndək abəra ka bazlam bay tebiye. ");
INSERT INTO meq_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tə pasla na a walaŋ i ndo hay na, kəriye ada ta gay sariya i deɗek bay. Mata tsike me ka wawa ŋgay hay na, way? Ndəray kwa nəte andaya bay! Neŋgeye ta dze ha məsəfəre ŋgay abəra ka məndzibəra.» ");
INSERT INTO meq_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ndo məge məsler niye a tsətsah ka Filip a gwaɗay: «Amboh, tsikeŋ tey, ndo məɗe ha bazlam i Mbəlom a tsik niye na, ka way? A tsik na, ka bo ŋgay eye ŋgway tsukuɗu ka ndo mekeleŋ ɗaw?» ");
INSERT INTO meq_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Yawa! Filip a dazlay a məɗay ha ka təv nakə a dzaŋga aye. A ɗay ha Labara Ŋgwalak eye i Yesu. ");
INSERT INTO meq_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ahəl nakə nəteye faya ta diye aye na, tə ndisl a təv eye andaya yam mə ɗəma. Ndo məge məsler niye a gwaɗay a Filip: «Yam anaŋ, anəke mata geŋ ŋgatay abəra ka madzəhuɓe bo a yam na, mey sa mey?»  ");
INSERT INTO meq_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip a gwaɗay: «Taɗə ka pa mədzal gər yak ka Yesu na, ka sliye faya madzəhuɓe bo a yam.» Ndo niye a mbəɗay faya, a gwaɗay: «Na pa mədzal gər ka Yesu Kəriste. Neŋgeye na, Wawa i Mbəlom.» ");
INSERT INTO meq_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tsa na, a lətse ha muta i pəles ŋgay niye, tə mbəzlaw abəra mə ɗəma ta Filip. Filip ta neŋgeye salamay tə mbəzla a yam, Filip a dzəhuɓ ha a yam. ");
INSERT INTO meq_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tə tsalaw abəra ma yam na, Məsəfəre i Bəy Maduweŋ a zla na Filip. Ndo məge məsler niye kə ŋgatay a Filip sa bay. Ane tuk na, neŋgeye a ye ŋgway tə məŋgwese eye. ");
INSERT INTO meq_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip a zəba ɗəre na, neŋgeye ma gəma i Azot. Tsa na, ahəl bo ma diye a Sezare. Faya ma diye na, a ɗa ha Labara Ŋgwalak eye ka gəma, ka gəma hus a həlay nakə a ndisl ka dala i Sezare aye. ");
INSERT INTO meq_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ahəl niye na, Sol neŋgeye a dzala huya ka məzlatay zay a ndo məpe mədzal gər hay ka Yesu huya hərwi məkəɗe tay ha. A ye ka təv i bagwar i ndo məvəlaway wu a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","A ye naha a tsətsah faya ɗerewel nakə ma diye ha ka təv i bagwar i gay i maɗuwule me neheye ma Damas aye hərwi ada taɗə ndo hay andaya faya ta pay bəzay a tsəveɗ i Bəy Maduweŋ, hasləka hay kwa ŋgwas hay na, ma gəsiye tay ha ada ma diye tay ha a Zerozelem. ");
INSERT INTO meq_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tə watsay ɗerewel niye tə vəlay na, a həl bo a ye a Damas. Pol faya ma ndisliye bəse ta Damas na, dzaydzay a mbəzlaw abəra mə mbəlom, a dəv ka təv ŋgay niye. A lawara na a wuzlah. ");
INSERT INTO meq_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","A dəɗ ka dala. Tsa na, a tsəne mətsike me, a gwaɗay: «Sol, Sol, nəkar faya ka geŋeye ɗəretsətseh andza niye na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol a mbəɗay faya, a gwaɗay faya: «Nəkar eye na, way, Bəy Maduweŋ?» Mətsike me niye a mbəɗayaw faya, a gwaɗay: «Neŋ na, Yesu nakə faya ka geye ɗəretsətseh aye. ");
INSERT INTO meq_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ane tuk na, lətse do a walaŋ gay. Ka ye a ɗəma na, ta tsikakeye wu nakə ka giye.» ");
INSERT INTO meq_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ndo neheye ti ye naha ka bo dziye tə Sol aye, tə lətse ka təv niye. Kwa mətsike me, ta sla faya mətsike bay tebiye. Mətsike me nakə a tsənew mə mbəlom aye na, tə tsəne. Ane tuk na, nəteye ta ŋgatay a ndəray bay. ");
INSERT INTO meq_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol a lətse abəra ka dala. A həndək abəra ka ɗəre na, a ŋgatay a ɗəre bay tebiye. Tə gəsay həlay, ti ye ha a Damas. ");
INSERT INTO meq_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","A ye naha a ɗəma na, məhəne mahkar neŋgeye mandza eye guluf eye, a ŋgatay a ɗəre kwa tsekweŋ bay. Məhəne mahkar eye niye na, kə nda wu mənday bay ada kə sa yam bay. ");
INSERT INTO meq_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ndo məpe mədzal gər wuray ka Yesu andaya ma Damas, məzele ŋgay Ananiyas. Bəy Maduweŋ a zalay ma məsine, a gwaɗay: «Ananiyas, Ananiyas!» Ananiyas a mbəɗay faya, a gwaɗay: «Neŋ anaŋ!» ");
INSERT INTO meq_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Bəy Maduweŋ a gwaɗay: «Do anəke ka tsəveɗ nakə tə zalay “Mahədzaka eye bay” aye ada kâ ye a gay i Yudas. Ka ye naha na, tsətsah ndo i gəma i Tarsis wuray, tə zalay Sol. Neŋgeye faya ma ɗuwuleye me a Mbəlom, ");
INSERT INTO meq_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ada a ŋgatay a Ananiyas ma məsine faya ma diye naha ka təv ŋgay ada ma piye faya həlay hərwi ada mâ ŋgatay a ɗəre.» ");
INSERT INTO meq_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiyas a mbəɗay faya, a gwaɗay: «Bəy Maduweŋ, ndo niye na, ndo haladzay ta təkəreŋ ɗəretsətseh nakə faya ma gateye a ndo yak hay ma Zerozelem aye tebiye. ");
INSERT INTO meq_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ada a yaw kanaŋ na, bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ta vəlay tsəveɗ ka məgəse ndo neheye faya ta pakeye bəzay kanaŋ aye tebiye dərmak. A yaw na, hərwi niye.» ");
INSERT INTO meq_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ane tuk na, Bəy Maduweŋ a gwaɗay: «Do, hərwi na zla na ndo niye hərwi məge məsler ga. Neŋgeye na, ma ɗiye ha məzele ga a siye i gəma hay ada a bəy tay hay. Ada ma ta ɗateye ha a ndo i Israyel hay dərmak. ");
INSERT INTO meq_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Bo ga eye na ta ɗateye ha wu nakə ma giye ɗəretsətseh hərwi ga aye tebiye.» ");
INSERT INTO meq_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiyas a tsəne andza niye na, a həl bo a ye. A ye naha a fələkwa a gay nakə Sol mə ɗəma aye. A ye naha a pa həlay ka Sol, a gwaɗay: «Sol malamar ga, maa sləra ga ahaya ka təv yak na, Bəy Maduweŋ Yesu. Maa bəzaka ha bo ka tsəveɗ nakə faya ka diye ahaya aye na, neŋgeye. A sləra ga ahaya hərwi ada kâ ŋgatay a ɗəre andza nakə kurre aye ada kâ rah ta Məsəfəre Tsəɗaŋŋa eye.» ");
INSERT INTO meq_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kwayaŋŋa wuye hay tə kutsayaw abəra ka ɗəre i Sol andza dəba i kəlef, a ŋgatay a ɗəre tuk. Tsa na a lətse, a ye ta dzəhuɓ ha a yam. ");
INSERT INTO meq_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ma dəba eye, a nda wu mənday ada gədaŋ ŋgay a maw tuk. Sol a ndza məhəne tsakway ta ndo məpay bəzay a Yesu neheye ma Damas aye. ");
INSERT INTO meq_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kwayaŋŋa a dazlay a məɗe ha bazlam i Mbəlom mə gay i maɗuwule me hay. A ɗa ha parakka Yesu na, Wawa i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ndo neheye tebiye tə tsəne bazlam ŋgay niye na, a gatay hərɓaɓəkka. Ta tsətsah, tə gwaɗ: «Maa gatay ɗəretsətseh haladzay a ndo məpay bəzay a Yesu hay ma Zerozelem na, ndo nakay bəɗaw? Ada a yaw kanaŋ na, hərwi məgəse tay ha ada mede tay naha a bagwar hay i ndo neheye tə vəlaway wu a Mbəlom aye ba?» ");
INSERT INTO meq_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sol neŋgeye ɗuh gədaŋ ŋgay a səkah ka məɗe ha bazlam i Mbəlom pat pat. A ɗatay ha a Yahuda neheye ma gəma i Damas aye parakka Yesu na, Kəriste. Nəteye niye tə sər wu nakə ta tsikeye faya aye sa bay. ");
INSERT INTO meq_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ma dəba i məhəne tsakway na, Yahuda hay tə ma ha ka bo bazlam ka təv manəte eye hərwi məkəɗe na Sol. ");
INSERT INTO meq_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ane tuk na, Sol a sər tay naha ka wu tay nakə a satay məge aye. Ta tsəpawa na məgeɗ i walaŋ i gay ta həpat kwa ta həvaɗ hərwi ada taɗə ta gəs na na, ta kəɗiye na. ");
INSERT INTO meq_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Sol ta gawla ŋgay hay ti ye ta həvaɗ ka bəɗ i mavavar i zleɗ i walaŋ gay niye. Tə zla na Sol tə pa na a kəteh. Tə mbəzla ahaya tə mavavar niye dəreŋ tə walaŋ gay. ");
INSERT INTO meq_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol a ye a Zerozelem. A ndisl naha a ɗəma na, a say mədzepe ta ndo məpe mədzal gər ka Yesu hay. Ane tuk na, ndo hay tebiye ta dzədzaray, hərwi tə dzala na, tə gwaɗ neŋgeye ka təra ndo məpe mədzal gər ka Yesu ta deɗek bay. ");
INSERT INTO meq_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ane tuk na, Barnabas, neŋgeye a zla na, a ye ha ka təv i ndo i maslaŋ i Yesu hay. Ti ye naha na, a təkəratay kəkay nakə Sol a ŋgatay a Bəy Maduweŋ ka tsəveɗ i mede a Damas ada kəkay nakə Bəy Maduweŋ a tsikay me aye, ada Sol a ɗa ha bazlam i Yesu kwa ka dzədzar bay ma Damas na, kə tsikatay dərmak. ");
INSERT INTO meq_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Pat eye niye kwayaŋŋa Sol a ndza ka təv tay. A yawa ta nəteye a Zerozelem ada tə mawa ka bo dziye, a ɗawa ha bazlam i Bəy Maduweŋ parakka lele. ");
INSERT INTO meq_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","A tsikawatay bazlam i Yesu a Yahuda neheye tə tsik me i Gərek aye dərmak. Tə kəɗawa wuway haladzay. Ane tuk na, ta pəla tsəveɗ a satay məkəɗe na. ");
INSERT INTO meq_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ndo məpe mədzal gər hay ka Yesu ta təra malamar hay, tə tsəne na, tə zla na Sol abəra ka təv niye. Ti ye ha a gəma i Sezare. Ma dəba eye na, ti ye ha a gəma i Tarsis. ");
INSERT INTO meq_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yawa! Ndo məpe mədzal gər hay ka Yesu ma gəma i Yahuda, ma Galile, ada ma Samari, nəteye tebiye mandza eye zay zay lele. Nəteye faya ta hutiye gədaŋ pat pat. Ta rəhay ha gər a Bəy Maduweŋ lele. Məsəfəre Tsəɗaŋŋa eye a vəlawatay gədaŋ, a səkahawa tay ha haladzay. ");
INSERT INTO meq_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","A həlay niye na, Piyer a yawa a gəma hay tebiye. Pat wuray na, a ye a gəma i Lida. ");
INSERT INTO meq_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mə ɗəma na, ndoweye andaya tə zalay Ene, neŋgeye matəra eye. Məve tsamahkar neŋgeye mahəna eye. Ahəl nakə Piyer a ye naha aye na, a ŋgatay. ");
INSERT INTO meq_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piyer a gwaɗay: «Ene! Yesu Kəriste ma mbəliye kar ha, lətse, zla sləlah yak.» Kwayaŋŋa Ene a lətse. ");
INSERT INTO meq_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ndo i gəma i Lida hay ta ndo neheye ka barrbar i Saron aye tebiye tə ŋgatay andza niye na, ta mbəɗa ha mədzal gər tay. Tə pa mədzal gər tay ka Bəy Maduweŋ. ");
INSERT INTO meq_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ŋgwas məpe mədzal gər ka Yesu andaya məzele ŋgay Tabita. Tə zalay tə bazlam i Gərek na, Dorkas. Andza məgweɗe: Mawene. A ndzawa i ŋgay na, ma gəma i Zope. Neŋgeye a gawa ŋgwalak a ndo hay huya ada a dzənawa tay ha mətawak hay. ");
INSERT INTO meq_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","A həlay niye na, a dəɗ a ɗəvats ada a mət. A mət na, tə bara na. Tsa na, tə tsal ha a gay nakə ka gər i gay niye aye. ");
INSERT INTO meq_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Gəma i Lida na, bəse ta gəma i Zope. Ndo məpe mədzal gər ka Yesu neheye ma Zope aye tə tsəne Piyer neŋgeye ma Lida na, tə slər ndo hay sulo ka təv i Piyer, mâ yaw. Tə gwaɗay naha: «Nəmaa gaka naha amboh, dara bəse təday.» Ndo neheye sulo aye ti ye ka təv i Piyer. ");
INSERT INTO meq_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piyer a tsəne bazlam tay niye na, kwayaŋŋa a həlaw bo, ti yaw ta ndo niye hay. Piyer a husaw na, tə laka ha a gay nakə ka gər i gay neŋgeɗ mədahaŋ mə ɗəma aye. Madakway i ŋgwas hay tə ŋgatay na, ta həndzəɗ naha ka təv ŋgay ta mətuwe eye. Ta bəzay ha petekeɗ neheye Tabita a ŋgarawa ahəl nakə neŋgeye andaya tə ɗəre mba aye. ");
INSERT INTO meq_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Tsa na, Piyer a həhar tay ahaya ndo hay tebiye abəra. A dəkw gurmets, a ɗuwulay naha me a Mbəlom. A mbəɗa me ka təv i mədahaŋ. A gwaɗ: «Tabita lətse!» Tabita a həndək abəra ka ɗəre. A ŋgatay a Piyer na, a lətse, a ndza. ");
INSERT INTO meq_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piyer a gəs na abəra mə həlay, a dzəna na mələtse ha ka mbəlom. Tsa na, a zalatay a madakway i ŋgwas niye hay ta siye i ndo məpe mədzal gər hay ka Yesu tebiye. Ta ma naha ka təv ŋgay a gay. Ti ye naha na, a gwaɗatay: «Anaŋ ndo kurom kə mbəl.» ");
INSERT INTO meq_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Masuwayaŋ nakə a ge bo aye na, a ɗa a zləm ma gəma i Zope tebiye. Ndo hay haladzay tə dzala ha ka Bəy Maduweŋ. ");
INSERT INTO meq_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piyer a ndza haladzay ma Zope. A ndza na, mə gay i ndo wuray a lambaɗawa mbal, məzele ŋgay Simoŋ. ");
INSERT INTO meq_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ndo wuray ma gəma i Sezare, məzele ŋgay Korney. Neŋgeye na, bagwar i sidzew i Roma hay. Sidzew niye hay na, tə zalatay Sidzew i Itali hay. ");
INSERT INTO meq_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ndo niye na, a paway bəzay a Mbəlom ada a rəhaway naha gər a Mbəlom ta ndo i gay ŋgay hay tebiye. A dzənawa tay ha Yahuda neheye mətawak eye hay aye ada a ɗuwulaway me a Mbəlom pat pat. ");
INSERT INTO meq_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Pat wuray ta huwa ma giye ɓəre mahkar na, məsine a gay. Ane tuk na, neŋgeye tə ɗəre. A ŋgatay a gawla i Mbəlom parakka lele faya ma diye naha a gay ka təv ŋgay. A ye naha a zalay, a gwaɗay: «Korney!» ");
INSERT INTO meq_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Korney a zəba ka gawla i Mbəlom niye tə madzədzere eye, a gwaɗay: «Ka yaw na, labara i mey Bəy Maduweŋ ga?» Gawla i Mbəlom a mbəɗay faya, a gwaɗay: «Mbəlom kə tsəne maɗuwule me yak hay. Wu nakə ka vəlay a mətawak hay aye na, a yay a gər haladzay. Neŋgeye faya ma dzaliye ka nəkar, ma mətsiye kar ha gər bay. ");
INSERT INTO meq_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Anəke na, slər ndo hay a gəma i Zope, tâ ye tâ zalayaw a ndoweye andaya məzele ŋgay Simoŋ nakə tə zalay Piyer aye. ");
INSERT INTO meq_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Neŋgeye mə gay i ndoweye andaya məzele ŋgay Simoŋ, a lambaɗawa mbal. Gay ŋgay na, ka me i dəlov.» ");
INSERT INTO meq_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Gawla i Mbəlom niye a tsikay ka bo abəra na, a ye ŋgway. Korney a zalatay a ndo i məsler ŋgay hay sulo ada a zalay a sidzew nəte mə walaŋ i sidzew neheye tə gaway məsler aye. Sidzew eye niye na, ndo məpay naha faya a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","A ye naha a təkəratay wu nakə a ge bo tebiye aye. Tsa na, a slər tay ha a Zope. ");
INSERT INTO meq_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Yaw! Ndo niye hay tə həl bo, ti ye. Tədœ eye na, nəteye huya ka tsəveɗ faya ta diye. Magərhəpat na, nəteye faya mazlambar ta ndisliye a Zope. Ta magərhəpat eye niye Piyer neŋgeye dərmak a tsal ka gər i gay wuray fatata mata ɗuwulay me a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Tsa na, may a wur faya, a say mənde wu mənday. Ahəl nakə faya ta deye wu mənday aye na, wuye a gay andza məsine. ");
INSERT INTO meq_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","A ŋgatay a mbəlom mahəndəka eye ada wuye faya ma mbəzlaweye abəra mə ɗəma. Wuye niye na, andza petekeɗ mafətəla eye, bagwar eye, magəsa eye ka me eye wal wal təv faɗ, faya ma mbəzlaweye ka dala. ");
INSERT INTO meq_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mə ɗəma na, wu hay haladzay. Wu i pesl hay, gənaw hay, wu neheye tə va tə huɗ aye, ada tə ɗiyeŋ hay. ");
INSERT INTO meq_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Piyer a tsəne mətsike me, a gwaɗay: «Lətse Piyer, kəɗ wu neheye ada kâ həpəɗ!» ");
INSERT INTO meq_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ane tuk na, wu niye hay na, Yahuda hay tə ge faya me mənde. Hərwi niye Piyer a mbəɗay faya, a gwaɗay: «Ah! Aʼay Bəy Maduweŋ ga, wu nakə tə ge faya me, ka təra tsəɗaŋŋa bay aye na, na nda ɗaɗa bay. A seŋ bay.» ");
INSERT INTO meq_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Mətsike me niye a tsikayaw sa, a gwaɗay: «Wu nakə Mbəlom a gwaɗ tsəɗaŋŋa eye na, kâ zəba faya andza mandzaɗak bay.» ");
INSERT INTO meq_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","A ma ahaya bazlam niye sik mahkar. Ma dəba eye na, kwayaŋŋa wu niye a ma ŋgway a mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piyer a tsətsahay a gər ŋgay, a gwaɗ: «Wu nakay na ŋgatay aye na, a say məgweɗe mey?» Azlakwa ahəl nakə Piyer faya ma dzaliye andza niye na, ndo neheye Korney a slər tay naha aye ɓa ta tsətsah gay i Simoŋ ada nəteye anəke ka məgeɗ i məfələkwe. ");
INSERT INTO meq_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tə zal ta gədaŋ, ta tsətsah hərwi məsəre ha ta deɗek Simoŋ ndo nakə tə zalay Piyer aye neŋgeye andaya kanaŋ ɗaw. ");
INSERT INTO meq_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ane tuk na, Piyer neŋgeye faya ma dzaliye ka wu nakə a ŋgatay aye. Ahəl nakə neŋgeye faya ma dzaliye aye na, Məsəfəre i Mbəlom a gwaɗay: «Piyer, tsəne! Ndo hay anaŋ mahkar faya ta pəliye kar. ");
INSERT INTO meq_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Lətse, mbəzla ka təv tay. Do ta nəteye. Kâ dzala faya gər sulo sulo bay, hərwi maa slərataya ahaya na, neŋ.» ");
INSERT INTO meq_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piyer a tsəne andza niye na, a mbəzlaw ka təv i ndo niye hay. A gwaɗatay: «Neŋ na, ndo nakə faya ka pəlumeye aye. Ka yumaw na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ta mbəɗay faya, tə gwaɗay: «Nəmaa yaw, maa sləramaya ahaya na, bəy i sidzew, məzele ŋgay Korney. Neŋgeye na, ndo məɗəslay ha gər a Mbəlom. Neŋgeye ndo i deɗek ada Yahuda hay tebiye tə gwaɗ faya neŋgeye na, lele. Gawla i Mbəlom a gwaɗay: “Slər ndo hay ka təv i Piyer hərwi ada mâ yaw a gay yak. Ki yaw na, pay zləm a wu nakə ma tsikiye aye.”» ");
INSERT INTO meq_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tsa na, Piyer a ye tay ha a gay, a vəlatay təv məhəne hərwi həvaɗ kə ge. Tədœ eye na, tə həl bo ti ye ka bo dziye. Siye i ndo neheye ta təra ta malamar hay ma məpe mədzal gər ka Yesu aye, tə laka tay ha. ");
INSERT INTO meq_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Tədœ taɗay eye na, tə ndisl a gəma i Sezare. Korney neŋgeye na, kə haya tay gər a ndo ŋgay hay, ta dzam ŋgay, nəteye faya ta həbiye. ");
INSERT INTO meq_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ahəl nakə tə ndisl, Piyer faya ta fələkwiye a gay i Korney aye na, Korney a yaw ka təv tay. A guɗuk ka dala kame i Piyer ta məɗəslay ha gər. ");
INSERT INTO meq_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ane tuk na, Piyer a lətse ha ka mbəlom, a gwaɗay: «Lətse, hərwi neŋ na, ndo zezeŋ andza nəkar dərmak.» ");
INSERT INTO meq_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tsa na, ti ye ka bo a gay ta Korney nəteye faya ta tsikiye me. Ti ye naha na, ndo hay mahaya gər eye haladzay. ");
INSERT INTO meq_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","A gwaɗatay: «Sərum ha na, i may Yahuda hay mede a gay i slala mekeleŋ eye hay wal kəgəbay məndze ka təv manəte aye na, lele bay a wesl. Ane tuk na, Mbəlom kə ɗeŋ ha mazəbe ka ndo neŋgeye tsəɗaŋŋa təbey kəgəbay mede a gay ŋgay lele bay na, kə ɗeŋ ha andza niye bay. ");
INSERT INTO meq_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Hərwi niye, ahəl nakə ka zalumeŋ aye na, na kərah madayaw bay. Na yaw bəse. A seŋ məsəre ha, ka zalumeŋew na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korney a mbəɗay faya, a gwaɗay: «Neŋ nakə na zalaka naha aye, anəke kə ge məhəne mahkar ta ɓəre mahkar andza nakay, faya na ɗuwuleye me a Mbəlom kanaŋ mə gay ga. Neŋ faya na ɗuwuliye me na, kwayaŋŋa ndo tə petekeɗ eye ka bo herre a yaw kame ga. ");
INSERT INTO meq_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Tsa na, a gweɗeŋ: “Korney, Mbəlom kə tsəne maɗuwule me yak ada kə mətsa ha gər tə madzəne yak nakə ka dzənawa tay ha mətawak hay aye bay. ");
INSERT INTO meq_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","A gweɗeŋ slər ndo hay a gəma i Zope mata zalayaw a Simoŋ nakə tə zalay Piyer aye. Neŋgeye mandza eye mə gay i ndo wuray a lambaɗawa mbal, məzele ŋgay Simoŋ. Gay ŋgay na, ka me i dəlov.” ");
INSERT INTO meq_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Hərwi niye, na slər naha fakaya ndo hay kwayaŋŋa ada kâ yaw. Sɨsœ yak, ka təma ka yaw bəse. Anəke nəkway tebiye kanaŋ kame i Mbəlom hərwi məpay zləm a bazlam i Bəy Maduweŋ nakə a vəlaka, a gwaɗaka tsik aye.» ");
INSERT INTO meq_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Piyer a dazlay a mətsike me, a gwaɗay: «Anəke na, na sər tuk. Ndo hay tebiye kame i Mbəlom na, nəte, ka ŋgəna tay ha ka bo bəra bay. ");
INSERT INTO meq_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ndo zezeŋ tebiye, kwa neŋgeye na, ndo i gəma wuray wuray ka rəhay ha gər a Mbəlom ada kə ge wu nakə deɗek aye na, neŋgeye ka təv i Mbəlom na, lele. ");
INSERT INTO meq_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ka sərum ha Mbəlom a sləraw bazlam ŋgay na, a Israyel hay ada tâ huta zay i Mbəlom tə həlay i Yesu Kəriste. Neŋgeye na, Bəy Maduweŋ i ndo hay tebiye. ");
INSERT INTO meq_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Bazlam nakay a dazlay ma Galile ahəl nakə Yuhana madzəhuɓe ndo a yam a dzəhuɓawa tay ha ndo hay a yam aye. A gwaɗawatay a ndo hay: “Dzəhuɓum bo a yam.” Wu nakə a ge bo ma dəba eye, ma Yahuda ada ma təv mekeleŋ eye tebiye na, ka sərum. ");
INSERT INTO meq_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ka sərum ha labara i Yesu ndo i Nazaret. Mbəlom ka dzərif ha faya gədaŋ i Məsəfəre Tsəɗaŋŋa eye. Ada sa na, Yesu ka həhal gəma ha, kə ge ŋgwalak ada kə mbəl tay ha ndo neheye Fakalaw a dzawa tay ha aye. A ge andza niye na, hərwi Mbəlom andaya tə neŋgeye. ");
INSERT INTO meq_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«Nəmay na, nəmaa təra ndo məhəle mbal i wu neheye a ge aye tebiye ma gəma i Yahuda ada ka dala i Zerozelem aye. Ta kəɗ na, ka mayako mazləlmbaɗa eye. ");
INSERT INTO meq_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ane tuk na, a ge məhəne sulo, mamahkar eye na, Mbəlom kə lətse ahaya abəra ma bəɗ. Kə vəlay tsəveɗ mâ bəzamay ha bo a nəmay ndo i maslaŋ ŋgay hay, ");
INSERT INTO meq_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","bəna ka bəzatay ha bo a ndo neheye tebiye ta ŋgatay aye bay. Ane tuk na, a bəz ha bo na, a nəmay neheye Mbəlom a pala may kurre andza ndo məhəle mbal ŋgay hay aye. Ma dəba eye nakə Mbəlom a lətse ahaya abəra ma mədahaŋ aye na, nəmaa nda wu mənday ada nəmaa sa wu məse ta neŋgeye ka təv manəte eye. ");
INSERT INTO meq_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Neŋgeye a gwaɗamay: “Dum ɗumatay ha bazlam ga a ndo hay ada ɗumatay ha neŋ na, ndo nakə Mbəlom a pa na hərwi məgatay sariya a ndo neheye nəteye andaya tə ɗəre ada a ndo neheye ta mət aye hay.” ");
INSERT INTO meq_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ndo məɗe ha bazlam i Mbəlom tebiye ta tsik faya. Taɗə ndoweye kə dzala ha ka Yesu na, Mbəlom ma pəsay ha mezeleme ŋgay hay hərwi wu nakə Yesu a ge aye.» ");
INSERT INTO meq_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ahəl nakə Piyer faya ma tsikiye me mba aye na, Məsəfəre Tsəɗaŋŋa eye a mbəzlaw ka ndo neheye nəteye faya ta pay zləm a bazlam ŋgay aye tebiye. ");
INSERT INTO meq_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ndo məpe mədzal gər hay ka Yesu, neheye nəteye Yahuda hay ti yaw tage Piyer aye a gatay wadəŋ wadəŋ hərwi nakə tə ŋgatay a Məsəfəre Tsəɗaŋŋa eye a mbəzlaw ka ndo neheye nəteye Yahuda hay təbey aye. ");
INSERT INTO meq_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Hərwi niye tə tsəne nəteye faya ta tsikiye me tə bazlam neheye nəteye tə tsəne bay aye ada faya ta zambaɗeye a Mbəlom bagwar eye. Tsa na, Piyer a gwaɗ: ");
INSERT INTO meq_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Mata sle faya məge me ka madzəhuɓe tay ha ndo neheye anəke tə huta Məsəfəre Tsəɗaŋŋa eye andza nəkway na, wuye mey?» ");
INSERT INTO meq_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tsa na, a gwaɗatay: «Dzəhuɓum tay ha a yam ta məzele i Yesu Kəriste.» Ndo niye hay ta tsətsah faya mâ ndza ka təv tay məhəne tsakway tey. ");
INSERT INTO meq_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ndo i maslaŋ i Yesu hay ta malamar tay neheye ma Yuda aye tə tsəne na, ndo neheye nəteye Yahuda hay təbey aye ta təma bazlam i Mbəlom dərmak. ");
INSERT INTO meq_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Piyer a maw a Zerozelem na, ndo məpe mədzal gər hay ka Yesu nəteye neheye Yahuda hay aye tə gay me a Piyer. ");
INSERT INTO meq_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Tə gwaɗay: «Ka ye ka təv i ndo neheye nəteye Yahuda hay təbey aye ada ka nda wu mənday ta nəteye na, hərwi mey?» ");
INSERT INTO meq_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Piyer a tsəne andza niye na, a təkəratay wu nakə a ge bo aye ka madazlay hus ka mandəve aye. A gwaɗatay: ");
INSERT INTO meq_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Kurre eye na, neŋ ma gəma i Zope. Ahəl nakə neŋ faya na ɗuwuliye me aye na, wuye a geŋ andza məsine. Na ŋgatay a wuye faya ma mbəzlaweye ta təv ga. Wu niye na, andza petekeɗ mafətəla eye, bagwar eye, magəsa eye ka me eye wal wal təv faɗ, faya ma mbəzlaweye abəra mə mbəlom. A yaw na, bəse ta təv ga. ");
INSERT INTO meq_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Na zəba ɗəre a ɗəma ada na ŋgatay a wu i pesl hay, a gənaw hay, wu neheye tə va tə huɗ aye, ada ɗiyeŋ hay. ");
INSERT INTO meq_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","«Tsa na, na tsəne mətsike me, a gweɗeŋ: “Lətse Piyer, kəɗ wu neheye ada kâ həpəɗ!” ");
INSERT INTO meq_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","«Na mbəɗay faya, na gwaɗay: “Ah! Aʼay Bəy Maduweŋ, ɗaɗa na həpəɗ wu nakə tə ge faya me aye kəgəbay wu nakə tsəɗaŋŋa bay aye na, na həpəɗ ɗaɗa bay.” ");
INSERT INTO meq_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","«Na tsəne mətsike me sa, a gweɗeŋ: “Wu nakə Mbəlom a gwaɗ tsəɗaŋŋa aye na, kâ zəba faya andza mandzaɗak bay.” ");
INSERT INTO meq_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","A meseŋ ha bazlam sik mahkar. Tsa na, wu niye a ma a mbəlom tebiye. ");
INSERT INTO meq_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","«Azlakwa bay ndo hay mahkar ti ye naha kwayaŋŋa a həlay niye a gay nakə nəmay mə ɗəma aye. Tə slərataya ahaya abəra ma Sezare. ");
INSERT INTO meq_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Məsəfəre Tsəɗaŋŋa eye a gweɗeŋ: “Ka ge mahonok bay, do bəse.” Malamar neheye məkwa na həlataya ahaya kanaŋ aye na, tə laka ga ahaya a Sezare ada nəmaa ye a gay i Korney ta nəteye tebiye. ");
INSERT INTO meq_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Tsa na, a təkəramay kəkay nakə a ŋgatay a gawla i Mbəlom aye. Gawla i Mbəlom a gwaɗay: “Slər ndo a Zope, tâ ye tâ zalayaw a Simoŋ nakə tə pa faya məzele Piyer aye. ");
INSERT INTO meq_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ki yaw na, ma tsikakeye bazlam i mətəme ada a ndo yak hay tebiye.” ");
INSERT INTO meq_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«Na dazlay a mətsike me na, Məsəfəre Tsəɗaŋŋa eye a mbəzlaw fataya andza nakə a mbəzlaw fakwaya ahəl niye aye. ");
INSERT INTO meq_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Wu nakə Bəy Maduweŋ a tsik ahəl niye na, a meŋaw a gər: “Yuhana a dzəhuɓ tay ha ndo hay na, a yam ɗekɗek tsa. Ane tuk na, nəkurom na, ta dzəhuɓiye kurom a Məsəfəre Tsəɗaŋŋa eye.” ");
INSERT INTO meq_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ta deɗek, Mbəlom kə vəlatay Məsəfəre ŋgay, andza nakə a vəlakway ahəl nakə ka dzalakwa ha ka Bəy Maduweŋ Yesu Kəriste aye. Neŋ ɗa məgay me a Mbəlom na, neŋ way?» ");
INSERT INTO meq_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tə tsəne bazlam niye na, ta may ha maŋgok a Piyer sa bay. Ta zambaɗay a Mbəlom, tə gwaɗ: «Mbəlom kə vəlatay tsəveɗ a ndo neheye nəteye Yahuda hay təbey aye mambəɗe ha mede tay ada tâ huta sifa nakə deɗek aye.» ");
INSERT INTO meq_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ahəl nakə tə kəɗ Etiyen aye na, ta dazlay məgatay ɗəretsətseh a ndo məpe mədzal gər hay ka Yesu. Nəteye, ta dazlay mahway a gəma mekeleŋ eye hay. Siye hay mə walaŋ tay, ti ye a Fenisi, a Sipəre, siye hay a gəma i Aŋtiyos. Ane tuk na, nəteye niye hay tə ɗawatay ha bazlam i Mbəlom a Yahuda hay ɗekɗek. ");
INSERT INTO meq_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Siye i ndo məpe mədzal gər neheye ma gəma i Sipəre ta Siren aye ti ye a Aŋtiyos. Ti ye tə ɗatay ha labara i Bəy Maduweŋ Yesu a ndo neheye nəteye Yahuda hay bay aye dərmak. ");
INSERT INTO meq_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Gədaŋ i Bəy Maduweŋ andaya fataya. Hərwi niye ndo hay haladzay ta dzala ha ka Bəy Maduweŋ. ");
INSERT INTO meq_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ndo məpe mədzal gər ka Yesu neheye ma Zerozelem aye tə tsəne labara i malamar neheye ma Aŋtiyos aye na, tə slər Barnabas ka təv tay. ");
INSERT INTO meq_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnabas a həl bo, a ye a ɗəma, a ye naha a ŋgatay ma kəkay nakə Mbəlom a pa ŋgama ka ndo məpe mədzal gər aye na, a yay a gər haladzay. Tsa na, a vəlatay gədaŋ a nəteye niye hay tebiye ta ndza huya ka tsəveɗ i Bəy Maduweŋ. ");
INSERT INTO meq_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Andza niye, Barnabas na, ndo lele eye. Neŋgeye maraha eye ta Məsəfəre Tsəɗaŋŋa eye ada kə pa mədzal gər peteh ka Yesu. Ndo hay haladzay ta səkah, tə pa mədzal gər ka Bəy Maduweŋ. ");
INSERT INTO meq_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ma dəba eye na, Barnabas a həl bo a ye a gəma i Tarsis mata pəlaw Sol. ");
INSERT INTO meq_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","A ndisl naha a ɗəma na, a huta Sol. Ti yaw ka bo salamay a Aŋtiyos. Nəteye salamay tə ndza ma Aŋtiyos məve nəte ta ndo məpe mədzal gər hay ka Yesu. Ta tətik tay ha ndo hay haladzay ka məpe mədzal gər ka Yesu. Tə lah məzele a ndo məpay bəzay a Yesu hay ndo i Kəriste hay na, ma Aŋtiyos. ");
INSERT INTO meq_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Pat wuray na, ndo məɗe ha bazlam i Mbəlom hay tə həl bo abəra ma Zerozelem, ti ye a Aŋtiyos. ");
INSERT INTO meq_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ndo nəte mə walaŋ tay məzele ŋgay Agabus, a ɗa ha ta gədaŋ i Məsəfəre Tsəɗaŋŋa eye, a gwaɗ: «Mandərzlaŋ ma giye ka məndzibəra tebiye.» Slala i mandərzlaŋ niye na, kə ge ahəl nakə Kəlod neŋgeye bəy i Roma aye. ");
INSERT INTO meq_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","A tsik andza niye na, ndo məpe mədzal gər hay ka Yesu, tə gwaɗ: «Kwa way mâ vəl wu nakə ma sliye faya məvəle aye hərwi məsləre tay naha madzəne a malamar neheye ma Yahuda aye.» ");
INSERT INTO meq_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Tsa na, ta tsakal wu, tə sləratay naha a madugula neheye ma Yahuda aye tə həlay i Barnabas tə Sol. ");
INSERT INTO meq_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","A həlay niye na, bəy nakə tə zalay Herod aye a pa bo ka məgatay ɗəretsətseh a ndo məpe mədzal gər hay ka Yesu. ");
INSERT INTO meq_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","A kəɗ na Yakuba malamar i Yuhana ta maslalam. ");
INSERT INTO meq_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","A zəba faya ka məkəɗe Yakuba nakə a kəɗ na aye, a yay a gər a Yahuda hay. A gəs na Piyer a həlay i magurlom nakə tə zalay magurlom i peŋ nakə tə kwasa ha bay aye. ");
INSERT INTO meq_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herod a gəs na Piyer na, a pa na a daŋgay. A həl sidzew hay faɗ faɗ madzəga faɗ matsəpe na. A dzala mə gər ŋgay na, aza mâ gəsa ahaya kame i ndo hay ma dəba i magurlom ada ma geye sariya. ");
INSERT INTO meq_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Sidzew hay faya ta tsəpiye na Piyer ma daŋgay. Ane tuk na, ndo məpe mədzal gər hay ka Mbəlom nəteye faya ta ɗuwuleye me a Mbəlom pat pat hərwi Piyer. ");
INSERT INTO meq_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ta həvaɗ eye niye ɗəre ma ta tsaɗiye na, Herod ma ta geye sariya a Piyer kame i ndo hay. Piyer mandzahəra eye ma wuzlah i sidzew hay sulo. Neŋgeye madzawa eye tə tsalalaw hay sulo ada sidzew mekeleŋ eye hay sulo faya ta tsəpiye məgeɗ i gay i daŋgay niye. ");
INSERT INTO meq_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kwayaŋŋa gawla i Mbəlom a yaw a gay nakə Piyer mə ɗəma aye, wuye a dəv dzaydzay mə gay niye. Gawla i Mbəlom a lamay a Piyer, a daŋgwazla ha, a pəɗeke ha. A gwaɗay: «Lətse bəse!» Tsa na, tsalalaw hay ta ŋgəzlah ndəruts ndəruts abəra mə həlay. ");
INSERT INTO meq_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Tsa na, gawla i Mbəlom a gwaɗay: «Pa wu i bəzay i huɗ yak ada ɓar tahərak yak a sik.» Piyer a ge andza nakə gawla i Mbəlom a tsikay aye. Gawla i Mbəlom a gwaɗay sa: «Pa ka bo məkelkabo yak ada dara peŋ bəzay.» ");
INSERT INTO meq_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piyer a zəŋgal ahaya gawla i Mbəlom, ti yaw abəra mə gay i daŋgay. Kə dzala ha wu nakə gawla i Mbəlom faya ma giye deɗek na, kə dzala ha bay. A dzala ha mə gər ŋgay na, məsine a gay. ");
INSERT INTO meq_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tə tawaɗaw abəra ka sidzew neheye ka məgeɗ makurre aye, tə ndislew ka masulo eye. Tsa na, tə ndislew ka məgeɗ i ɓəre nakə madayaw a walaŋ gay aye. Tə ndisl naha faya na, məgeɗ niye a həndək bo mahəŋgeye bətaŋ kame tay. Tsa na, tə ndohwaw abəra. Ti ye ka tsəveɗ na, kwayaŋŋa gawla i Mbəlom a gər ha Piyer. ");
INSERT INTO meq_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Wu nakə a ge bo aye na, Piyer a sər tuk. Tsa na, a gwaɗ: «Anəke na, na sər ta deɗek Mbəlom kə sləraw gawla ŋgay ka təv ga, kə təma ga ahaya abəra mə həlay i bəy Herod ada mə ɗəretsətseh i Yahuda neheye tə dzala məgeŋ aye.» ");
INSERT INTO meq_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ahəl nakə Piyer a sər ha wu nakə a ge bo aye lele tuk na, a ye a gay i Mari maya i Yuhana nakə tə zalay Markus aye. Mə ɗəma na, ndo hay mahaya gər eye haladzay, nəteye faya ta ɗuwuleye me a Mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tsa na, Piyer a ye naha a fay a məgeɗ. Ndo i məsler dem eye, məzele ŋgay Rodi a tsəne, a həndzəɗ naha ka məgeɗ hərwi mahəndəke abəra ma məgeɗ. ");
INSERT INTO meq_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","A tsəne mətsike me i Piyer na, a sər ha bəɗiɗay ŋgay. Ɗərev ŋgay a ŋgwasa haladzay. Ka həndək abəra mə gay sa bay. Ɗuh a hway mata ɗatay ha a ndo hay, Piyer ma bəra. ");
INSERT INTO meq_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Tə gwaɗay: «Gər a vuwaka ɗaw?» Ane tuk na, a gwaɗatay sa: «Ta deɗek Piyer ma bəra, maraw me bay.» Tə gwaɗ: «Agəla ma giye na, gawla i Mbəlom nakə a həbawa na aye.» ");
INSERT INTO meq_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Piyer na, neŋgeye faya ma feye a məgeɗ huya. Ta həndək abəra ma məgeɗ na, tə ŋgatay a Piyer. Tsa na, a gatay hərɓaɓəkka. ");
INSERT INTO meq_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","A gatay kət kət tə həlay, tâ bəbəl wuray bay, tâ ndza ɗikɗik. Tsa na, a təkəratay ma kəkay nakə Bəy Maduweŋ a laka ahaya abəra mə gay i daŋgay aye. A gwaɗatay sa: «Ɗumay ha a Yakuba ada a siye i malamar hay.» Tsa na, a yaw abəra mə gay, a ye a təv eye. ");
INSERT INTO meq_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ɗəre a tsaɗa na, sidzew hay ta ŋgatay a Piyer bay. Wadəŋ wadəŋ a ge mə walaŋ tay haladzay. Ta tsətsah ka bo mə walaŋ tay, tə gwaɗ: «Piyer a təra mey?» ");
INSERT INTO meq_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod a tsəne Piyer kə təmaw abəra ma daŋgay na, a gwaɗatay a ndo hay: «Dum ta pəlum ahaya.» Ndo hay ti ye ta pəla na, ta huta na bay. A zalatay a ndo matsəpe niye hay, a tsətsah fataya abəra, a gwaɗatay a ndo hay: «Kəɗum tay ha sidzew neheye abəra mə ɗəma.» Ma dəba eye na, Herod a lətse abəra ma Yahuda, a ye a Sezare. A ndza mə ɗəma tsakway. ");
INSERT INTO meq_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ndo i wuzlahgəma i Tir ta Sidoŋ tə ndza ta dala i Herod. Tə huta wu mənday tay na, mə ɗəma. Ahəl niye na, wu a ndalay a Herod ka ndo i gəma i Tir ta Sidoŋ. Ndo hay tə ma ha ka bo bazlam. Tsa na, ti yaw ka təv i ndoweye andaya məzele ŋgay Bəlastus, neŋgeye ndo i sik i bəy. Tə slər na ka təv i Herod, mâ ye mâ gwaɗay: «Ɓarakwa məndze zay mə walaŋ kway.» ");
INSERT INTO meq_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herod a tsəne bazlam tay niye na, a patay pat hərwi məma ha ka bo bazlam mə walaŋ tay lele. Məpesle həlay tay kə ndisl a ɗəma tuk. Pat eye niye na, Herod a pa ka bo petekeɗ i mələve bəy ŋgay. A ndza ka təv məndze i bəy ŋgay, kame i ndo hay tebiye. A tsikatay bazlam neheye a ləva ha bo aye. ");
INSERT INTO meq_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tsa na, ndo hay ta wuda haladzay, tə gwaɗ: «Maa tsik me na, mbəlom bəna ndo zezeŋ bay!» ");
INSERT INTO meq_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herod a tsəne andza niye na, a ɗəslay ha gər a bo, kə ɗəslay ha gər a Mbəlom bay. Kwayaŋŋa gawla i Mbəlom a yaw a fay a Herod, səŋ hay tə way a huɗ. Tsa na, a mət. ");
INSERT INTO meq_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Azlakwa ɗuh, bazlam i Mbəlom a ɗa a zləm kame kame haladzay. ");
INSERT INTO meq_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas tə Sol ta ndəv ha məsləre tay nakə tə slər tay ha a Zerozelem aye na, ta mbəɗa gər a Aŋtiyos. Tə zla ahaya Yuhana nakə tə zalay Markus aye ka həlay. ");
INSERT INTO meq_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ahəl niye mə walaŋ i ndo məpe mədzal gər ka Yesu neheye ma gəma i Aŋtiyos aye na, ndo məɗe ha bazlam i Mbəlom hay ta ndo matətikawatay bazlam i Mbəlom a ndo hay andaya. Ndo i maslaŋ eye niye hay na, Barnabas, Simeyoŋ nakə tə zalay Zeŋzeŋ eye aye, Lukiyus ndo i Siren, Manayeŋ ndo nakə ta həhalawa ta Herod bəy i Galile ahəl nakə nəteye wawa eye hay mba aye, ada Sol. Herod a ləvawa na, gəma i Galile. ");
INSERT INTO meq_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pat wuray nəteye faya ta ɗəsleye ha gər a Bəy Maduweŋ ada faya ta giye daliyam na, Məsəfəre Tsəɗaŋŋa eye a gwaɗatay: «Pum tay ha Barnabas tə Sol təv tay wal hərwi məge məsler ga nakə na zalatay faya aye.» ");
INSERT INTO meq_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ta ndəv ha daliyam tə maɗuwule me na, tə pa həlay ka Barnabas tə Sol. Tsa na, tə gər tay ha, ti ye mata ge məsler i Mbəlom tuk. ");
INSERT INTO meq_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Andza nakə Məsəfəre Tsəɗaŋŋa eye a slər tay ha Barnabas tə Sol aye na, tə həl bo ti ye a gəma i Selosi. Mə ɗəma na, tə tsal a kwalalaŋ i yam, ti ye ha a gəma i Sipəre gəma nakə ma wuzlah i dəlov aye. ");
INSERT INTO meq_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tə ndisl a gəma wuray tə zalay Salamin na, tə pa bo ka məɗe ha bazlam i Mbəlom mə gay i maɗuwule me i Yahuda hay. Nəteye dziye ta Yuhana Markus, a dzənawa tay ha. ");
INSERT INTO meq_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tə tas abəra ma gəma niye ma wuzlah i yam aye na, tə husa a gəma i Pafos. Mə ɗəma na, tə ndzay a gər a maharam wuray tə zalay Bar-Yesu. Ndoweye niye na, neŋgeye ndo i Yahuda, ndo nakə a gwaɗ neŋgeye ndo məɗe ha bazlam i Mbəlom aye. ");
INSERT INTO meq_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","A ndzawa na, ka təv i bəy i gəma niye ma wuzlah i dəlov nakə tə zalay Sipəre aye. Bəy niye tə zalay na, Sergiyos Polus. Neŋgeye na, a tsah lele, a sər wu. Barnabas tə Sol tə ndisl naha na, a zalatay hərwi a say tâ tsikay bazlam i Mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ane tuk na, Bar-Yesu maharam nakə tə zalay Elenas dərmak aye, a ye a gaw maləveɗ ka təv i bəy. A say bəy mâ təra ndo məpe mədzal gər ka Yesu bay. ");
INSERT INTO meq_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Məsəfəre Tsəɗaŋŋa eye a yaw a rah a bo i Sol nakə tə zalay Pol aye dərmak. A ndazl na maharam niye. ");
INSERT INTO meq_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Tsa na, a gwaɗay: «Nəkar ndo nakə bəbərek mə bo yak haladzay aye ada nəkar seweɗ eye haladzay. Nəkar na, wawa i Fakalaw. Wu nakə lele aye na, ka nay ɗəre tebiye. Nəkar na, a saka matəra ha bazlam i Bəy Maduweŋ maraw me na, hərwi mey? ");
INSERT INTO meq_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Tsəne, anəke! Bəy Maduweŋ ma giye fakaya mevel. Ma təriye kar ha guluf eye, ka ndziye tsakway ka ŋgateye a pat sa bay.» Tsa na, kwayaŋŋa Elanas a ge guluf deɗek tətərgam həvaɗ. A ŋgatay a ɗəre bay. A mbəɗa bo tewelewele mapəle ndo məgəsay həlay. ");
INSERT INTO meq_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Bəy niye a ŋgatay a wu nakə a ge bo aye na, a dzala ha ka Yesu hərwi matətike i Pol nakə a tətik ka Bəy Maduweŋ aye kə gay hərɓaɓəkka. ");
INSERT INTO meq_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol ta ndo ŋgay hay, tə həl bo abəra ma Pafos. Tə tsal a kwalalaŋ i yam, ti ye a gəma i Perge ka dala i Pamfeli. Mə ɗəma na, Yuhana Markus a gər tay ha, a mbəɗa gər a Zerozelem. ");
INSERT INTO meq_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Barnabas tə Pol na, ti ye kame kame. Ti ye abəra mə Perge, ti ye a Aŋtiyos ka dala i Pizidi ta tsəveɗ. Pat i mazəzukw bo na, ti ye a gay i maɗuwule me. Ti ye naha tə ndza ka dala. ");
INSERT INTO meq_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ti ye naha na, faya ta dzaŋgateye mə ɗerewel i Musa ada mə ɗerewel i ndo məɗe ha bazlam i Mbəlom hay. Ma dəba eye ta ndəv ha mədzeŋge na, bəy hay i gay i maɗuwule me niye tə gwaɗatay: «Malamar ga hay, taɗə bazlam kurom andaya mətsikatay a ndo hay hərwi məvəlatay gədaŋ na, ka slumeye faya mətsike me anəke tuk.» ");
INSERT INTO meq_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pol a lətse, a zla həlay ka mbəlom, a gatay həlay kət kət, andza məgweɗe: «Ndzum ɗikɗik.» A gwaɗatay: «Nəkurom ndo i Israyel hay ada ta nəkurom siye i ndo neheye ka dzədzarumay a Mbəlom aye dərmak. Pumay zləm a bazlam nakə na tsikakumeye. ");
INSERT INTO meq_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","«Mbəlom kway nəkway ndo i Israyel hay kə pala bəba təte kway hay ahəl niye. Ahəl nakə nəteye tə ndzawa ma gəma i Ezipt aye na, Mbəlom ka səkah tay ha haladzay. Ma dəba eye na, kə həlatay ahaya ta gədaŋ i həlay ŋgay. ");
INSERT INTO meq_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Mbəlom kə gatay gər ma kəsaf məve kuro kuro faɗ. ");
INSERT INTO meq_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ma dəba eye na, ka bəbazl tay ha gəma hay tasəla abəra ka dala i Kanan. A vəlatay dala niye a ndo ŋgay Israyel hay andza i tay wu tay. ");
INSERT INTO meq_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Wu niye tebiye kə ndza ma giye məve kuro kuro faɗ gər eye zlam. Ma dəba eye na, kə pa tay ndo məge sariya hay a bəba təte kway hay. A ge andza niye na, hus a həlay nakə Samuyel neŋgeye ndo məɗe ha bazlam i Mbəlom aye. ");
INSERT INTO meq_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","«Ma dəba eye na, ta tsətsah bəy ka Mbəlom. Mbəlom a vəlatay Sayul, wawa i Kis, ma ləver i Bendzameŋ. Sayul a ndza ma bəy məve kuro kuro faɗ. ");
INSERT INTO meq_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","«Tsa na, Mbəlom a kal ha Sayul, a patay Davit andza bəy. Mbəlom a gwaɗ: “Na sər ha Davit wawa i Zese, neŋgeye na, a yeŋ a gər. Ma giye na, wu nakə a seŋ aye tebiye.”» ");
INSERT INTO meq_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Pol a gwaɗatay sa: «Ndo nəte mə walaŋ i gwala i Davit hay Mbəlom a pa na ndo mətəme tay ha Israyel hay na, Yesu. Ɓa kə tsik kurre, a gwaɗ ma vəliye. ");
INSERT INTO meq_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ahəl nakə Yesu ki yaw zuk bay aye na, Yuhana madzəhuɓe ndo a yam kə ɗa ha bazlam i Mbəlom. Kə zalatay a ndo i Israyel hay tebiye tâ mbəɗa ha mede tay ada tâ dzəhuɓ bo a yam. ");
INSERT INTO meq_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","A ndisl a həlay nakə Yuhana madzəhuɓe ndo a yam ma ndəviye ha məsler ŋgay aye na, a gwaɗawa: “Ka dzalum mə gər kurom, neŋ na, way? Neŋ na, ndo nakə nəkurom faya ka həbumeye bay. Ane tuk na, tsənum: Neŋgeye na, ma deyeweye kame ga. Neŋ na sla ɗa kwa məpəlay ha ləɓer i tahərak ŋgay bay.” ");
INSERT INTO meq_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«A nəkurom malamar ga hay, nəkurom wawa i Abraham hay ada a nəkurom siye neheye ka dzədzarumay a Mbəlom aye, Mbəlom a sləraw labara nakay na, a nəkway, kəkay nakə a təma kway ha aye. ");
INSERT INTO meq_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Andza niye, ndo i Zerozelem hay ta bəy tay hay, Yesu neŋgeye way na, ta sər ha bay. Bazlam i ndo məɗe ha bazlam i Mbəlom neheye tə dzaŋgawa pat i mazəzukw bo aye na, ta tsəne bay. Ahəl nakə tə kəɗ Yesu aye na, bazlam i ndo i məɗe ha bazlam i Mbəlom hay kə ge bo tuk. ");
INSERT INTO meq_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Kwa taɗə ta huta faya abəra mənese nakə ɗa məkəɗe aye bay bəbay na, ta tsətsah ka Pilat mâ kəɗ na ka mayako mazləlmbaɗa eye. ");
INSERT INTO meq_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Tə ge wu nakə Ɗerewel i Mbəlom a ɗa ha ka gər ŋgay aye. Ma dəba na, ti ye tə mbəzla ahaya mədahaŋ i Yesu abəra ka mayako mazləlmbaɗa eye. Ti ye ha, tə pa na a tsəvay. ");
INSERT INTO meq_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ane tuk na, Mbəlom kə mbəla ahaya abəra ma mədahaŋ. ");
INSERT INTO meq_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ma məhəne haladzay, ka bəzatay ha bo a ndo neheye ti yaw ka bo ma Galile, ti ye ka bo a Zerozelem aye. Anəke nəteye niye ta həhal ka bo dziye na, nəteye ta təra ndo məhəle mbal ŋgay hay kame i ndo i Israyel hay. ");
INSERT INTO meq_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«Nəmay eye, nəmaa yakum ahaya Labara Ŋgwalak eye. Wu nakə Mbəlom a tsik kurre a gwaɗ ma vəlateye a bəba təte kway hay aye na, ");
INSERT INTO meq_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","kə ge na hərwi kway. A ge na, a lətse ahaya Yesu abəra ma mədahaŋ. Mawatsa eye mə Ɗerewel i Dəmes hay 2, a gwaɗ: “Nəkar wawa ga. Bəgom neŋ na təra Bəba yak.” ");
INSERT INTO meq_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","«Mbəlom a lətse ahaya Yesu abəra ma mədahaŋ. A ɗa ha kurre, a gwaɗ ma ziye ma tsəvay bay. Kə tsik andza nakay, a gwaɗ: “Na ta vəlakumeye wu nakə tsəɗaŋŋa eye ada deɗek eye andza nakə na tsikay a Davit, na gwaɗay na vəlakeye aye.” ");
INSERT INTO meq_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","«Hərwi niye, kə tsik ma Dəmes hay sa, a gwaɗ: “Nəkar Mbəlom na, ka gəriye ha ndo i məsler yak mâ ze ma tsəvay bay.” ");
INSERT INTO meq_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","«Davit a həlay i məndze ŋgay na, kə ge wu nakə a yay a gər a Mbəlom aye. Ma dəba eye Davit a mət. Ta la na ka təv i bəba təte ŋgay hay ada kə ze ma tsəvay. ");
INSERT INTO meq_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ane tuk na, ndo nakə Mbəlom a lətse ahaya abəra ma mədahaŋ aye na, kə ze ma tsəvay təbey. ");
INSERT INTO meq_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","«Malamar hay, sərum na, nəmay faya nəmaa ɗakumeye ha Mbəlom a pəsatay ha mezeleme i ndo hay na, hərwi Yesu. ");
INSERT INTO meq_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ndoweye kə dzala ha ka Yesu na, Mbəlom ma pəseye ha mənese ŋgay tebiye. Bazlam i Musa mapala eye, neŋgeye na, gədaŋ ŋgay andaya məpəsakum ha mənese bay. ");
INSERT INTO meq_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","«Gum metsehe, wu nakə ndo məɗe ha bazlam i Mbəlom hay tə watsa ahəl niye na, mâ ndzakum a gər bay. Tə watsa na, tə gwaɗ: ");
INSERT INTO meq_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“A həlay kurom nakay, na giye məsler nakə ka dzalumeye ha faya bay kwa taɗə ndəray mâ təkərakum aye. Zəbum, nəkurom neheye ka zəbum ka bazlam ga andza wu lele aye bay aye, mâ gakum hərɓaɓəkka, dum mətum.”» ");
INSERT INTO meq_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol ta Barnabas ta ndəv ha bazlam tay na, ti yaw abəra mə gay i maɗuwule me. Ti yaw abəra na, ta tsətsah fataya, tə gwaɗatay: «Mumaw pat i mazəzukw bo mekeleŋ eye sa ada ka tsikumameye ka gər i labara nakay sa.» ");
INSERT INTO meq_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ahəl nakə ndo hay faya ta ŋgəniye gər aye na, Yahuda hay haladzay ta ndo neheye tə ɗəslaway ha gər a kule i Yahuda hay aye, tə patay bəzay a Pol ta Barnabas. Pol ta Barnabas tə vəlatay gədaŋ hərwi ada tâ gər ha ŋgwalak i Mbəlom sa bay. ");
INSERT INTO meq_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pat i mazəzukw bo mekeleŋ eye a slaw na, həlay a vay a ndo i gəma niye hay tebiye tə haya gər hərwi mətsəne bazlam i Bəy Maduweŋ. ");
INSERT INTO meq_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Siye i Yahuda hay tə ŋgatay a ndo neheye hay haladzay tə haya gər aye na, a ndalatay haladzay. Tə ge fataya sələk. Ta dazlay mətsike wu nakə lele bay aye ka Pol ada tə tsaɗay pəleslesle. ");
INSERT INTO meq_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pol ta Barnabas tə tsik me tə zluwer eye bay tebiye, tə gwaɗatay: «Haɓe nəmaa ɗakumeye ha bazlam i Mbəlom na, a nəkurom təday. Ane tuk na, ka dzalum na, lele bay nakə kâ hutum sifa nakə ma ndəviye bay aye. Anəke na, nəmaa diye wu may, nəmaa ta ɗateye ha a ndo neheye Yahuda hay bay aye. ");
INSERT INTO meq_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Bəy Maduweŋ a gwaɗamay na, kəkay? A gwaɗ: “Nəkar na, na pa kar andza dzaydzay ma dəvateye a ndo i məndzibəra hay tebiye, hərwi ada kâ ye ka təv neheye dəreŋ eye ka tsikatay a ndo hay, neŋ Bəy Maduweŋ na mbəliye tay ha na, kəkay?”» ");
INSERT INTO meq_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ndo neheye nəteye Yahuda hay bay aye, tə tsəne bazlam niye na, ɗərev tay a ŋgwasa haladzay, a yatay a gər. Ta dazlay a mazambaɗay a bazlam i Bəy Maduweŋ. Ndo neheye Mbəlom a pala tay ha hərwi məhute sifa nakə ma ndəviye bay aye na, nəteye tebiye tə dzala ha ka Mbəlom. ");
INSERT INTO meq_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Andza niye, bazlam i Mbəlom a ŋgəna gər ka gəma niye tebiye. ");
INSERT INTO meq_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ane tuk na, Yahuda hay tə patay me a ŋgwas zlele eye neheye tə ɗəslaway ha gər a Mbəlom aye ta ndo neheye bagwar eye, tə gatay ɗəretsətseh a Pol ta Barnabas. Ta həhar tay ha abəra ka dala niye. ");
INSERT INTO meq_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pol ta Barnabas ta tətəkw ha burhway i gəma tay abəra ka sik tay. Ti ye a gəma wuray tə zalay Ikoniyom. ");
INSERT INTO meq_vpl VALUES ("AC13_52","074_13_52","ACT","13","52