﻿USE sofia;
DROP TABLE IF EXISTS sofia.mek_vpl;
CREATE TABLE mek_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mek_vpl WRITE;
INSERT INTO mek_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iꞌina auga Iesu Kristo, iꞌa ufuꞌa apaꞌa Abraham okogai emai auga, ke kin Davide okogai emai auga, ega mauni ninina: ");
INSERT INTO mek_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham gauga auga Aisak. Aisak gauga auga Jakob. Jakob gauga auga Juda aaga akina fou. ");
INSERT INTO mek_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda gauga Peres ke Sera fou. Isa inaꞌi auga Tama. Peres gauga auga Hesron. Hesron gauga auga Ram. ");
INSERT INTO mek_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram gauga auga Amminadab. Amminadab gauga auga Nashon. Nashon gauga auga Salmon. ");
INSERT INTO mek_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon gauga auga Boas. Boas ina Rahab. Ke Boas gauga auga Obed. Obed ina auga Ruth. Obed gauga auga Jese. ");
INSERT INTO mek_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese gauga auga kin Davide. Davide gauga auga Solomon. Solomon ina auga Uriah akafa kai, isa ama Davide eakafania. ");
INSERT INTO mek_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon gauga auga Rehoboam. Rehoboam gauga auga Abaija. Abaija gauga auga Asa. ");
INSERT INTO mek_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa gauga auga Jehoshafat. Jehoshafat gauga auga Joram. Joram gauga auga Usiah. ");
INSERT INTO mek_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiah gauga auga Jotam. Jotam gauga auga Ahas. Ahas gauga auga Hesekia. ");
INSERT INTO mek_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia gauga auga Manaseh. Manaseh gauga auga Amon. Amon gauga auga Josia. ");
INSERT INTO mek_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ke Josia gauga auga Jekonia. Jekonia aaga akina fou keagu kinagai, kepamaniꞌiniꞌi keafiiꞌi kelao au aꞌiꞌi koa iꞌopoꞌi Babilon ago aꞌinai keagu. ");
INSERT INTO mek_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ke egae Babilon agogai au aꞌiꞌi koa keagu alogai, Jekonia gauga Shealtiel epamauga. Shealtiel gauga auga Serubabel. ");
INSERT INTO mek_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel gauga auga Abiud. Abiud gauga auga Eliakim. Eliakim gauga auga Asor. ");
INSERT INTO mek_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor gauga auga Sadok. Sadok gauga auga Akim. Akim gauga auga Eliud. ");
INSERT INTO mek_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud gauga auga Eleasar. Eleasar gauga auga Matan. Matan gauga auga Jakob. ");
INSERT INTO mek_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ke Jakob gauga auga Iosepa. Ke Iosepa auga Maria akafa. Ke Maria Iesu epamauga aka Mesaia keoma. ");
INSERT INTO mek_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ega koa emia, Abraham faagagai eꞌina mauni ninina 14 emia eake emai Davide faagagai. Ke Davide faagagai isafa mauni ninina 14 emia eake emai, Israel papiauꞌi kepamaniꞌiniꞌi keafiiꞌi kelao ago aꞌinai Babiloniai keagu kinagai. Ke egaꞌina kinagai eꞌina, mauni ninina 14 emia emai Mesaia emauni. ");
INSERT INTO mek_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ke pau Iesu Mesaia auga ega mauni fouga iina epea oma. Isa ina Maria auga pakoꞌa iifaga kepaapa Iosepa auniꞌi fekeamage keoma. Kai auniꞌi akeagu fou koa kai, Maria Deo ega Spiritu ega isapuai epakaisau. Iosepa Maria epakaisau auga eisa elogo kai, Deo ega Spiritu ega isapuai epakaisau auga aelogo. ");
INSERT INTO mek_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ke Iosepa Maria auniꞌi fekeamage keoma auga, Deo maagai alo opai auga kainai, Maria papiau maꞌoai agoꞌiai fepameagaina auga anina aeani. Ega puo iifa epaapa, Maria auniꞌi kepakoꞌania fekeamage keoma auga iifaga ogefakeai laaꞌi gapamia eoma. ");
INSERT INTO mek_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kai isa egaꞌina opolaga eafiia alogai, kina agaꞌo gapiai, Lopia ega agelo nipiai isa eapakina penia epainia einaka, “Iosepa, Davide okogai lomai aumu, Maria foafia emu eꞌa folaoaina, akafamu femia auga maniꞌina folopaꞌaua. Gome imoi Maria gua alogai auga, Deo ega Spiritu ega isapuai eafiia. ");
INSERT INTO mek_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Isa imoi maguaega agepamauga. Ke imoi egaꞌina, aka ‘Iesu’ fooma, gome isa ifo ega papiau laomai apala eeꞌiai kaniaꞌi ageagamauga,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Egaꞌina kapaꞌi maꞌoai ega kemia oma, ega koa Lopia profeta akeꞌiai kapaꞌina mo eifaniꞌi auꞌi koꞌaꞌi mo fekemia eoma. ");
INSERT INTO mek_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Egaꞌina kapaꞌi agaꞌo auga fouga profeta Aisaea iina epapua oma: “Ifiao aguꞌa faaga fofouga, au agaꞌo fou akefeufeu auga, ageinae imoi maguaega agepamauga. Ke papiau isa aka Immanuel akeoma.” Immanuel iꞌa malaꞌaisai auga, “Deo iꞌa fou aague,” auga eifania. ");
INSERT INTO mek_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ke Iosepa eꞌue aisama, Lopia ega agelo maagai kapaꞌina eifa kapulania auga ekapaisa. Ke Maria eafiia auniꞌi kelao ega eꞌai akafa emia. ");
INSERT INTO mek_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kai Iosepa akafa Maria fou akefeufeu mo elao imoi maguaega epamauga. Ke imoi epamauga aisama, aka Iesu eoma. ");
INSERT INTO mek_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Kai Iesu aemauni koa kai, Herod kin emia Iudea ago eꞌimaisa. Isa kin emia alogai, Iesu Iudea agogai Beteleme taoninai emauni. Ega aisama Mako auꞌi kina eꞌagau afuga kainai kemai Ierusaleme taoninai. ");
INSERT INTO mek_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ke isa Herod eega kelao kepaꞌani penia keinaka, “Iudea eꞌi kin emauni auga kapai? Lai isa ega miꞌimiꞌi kina eꞌagau afuga kainai emai aisa puo, amai amaau afagaina aoma,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kin Herod ke Ierusaleme taonina papiauꞌi maꞌoai fou iꞌina iifaga aꞌo kelogonia aisama, kegaagu auga aekainia. ");
INSERT INTO mek_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ke isa Iudea papiauꞌi eꞌi sakedote lopiaꞌi maꞌoai, ke Moses ega iifa pamalelega auꞌi maꞌoai fou eifa kaiguguiꞌi efua aisama, Mesaia kapai agemauni auga epaꞌaniaina. ");
INSERT INTO mek_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ega aisama isa keifa keinaka, “Iudea agogai Beteleme taoninai agemauni, gome profeta agaꞌo Deo ega iifa pukagai iina epapua oma: ");
INSERT INTO mek_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Oi Beteleme, Juda agogai aumu, oi alomuai au akaikiꞌa agaꞌo agemai. Isa sipi keꞌima auꞌi koa agemia, Lau eꞌu papiau Israel papiauꞌi ageꞌimaꞌi. Ega puo oi Beteleme taonina aumu, taoni eꞌelemu laaꞌi kai taoni akaikiꞌa ipaumamu,’” keoma. ");
INSERT INTO mek_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Egae kai Herod ogefakeai Mako auꞌi eifaniꞌi, ke epaꞌani peniꞌi kina kapagai ipauma miꞌimiꞌi egaꞌina eapakina auga maagai keifania. ");
INSERT INTO mek_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Egae kai eulaiꞌi Beteleme taonina kelao kai epainiꞌi einaka, “Amolao ke imoi egaꞌina fokapu felo alogaina. Ke agoisa aisama, fofiakoa iifa foulaisa ega koa lau isafa faafai isa faau afagaina laoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Egaꞌina auꞌi kin aina kelogonia efua aisama, kekailai kelao. Ke miꞌimiꞌi kina eꞌagau kaina afugai eapakina keisa auga, agoꞌiai epea elao mo imoi eagu afuga laagai eapakipo. ");
INSERT INTO mek_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Isa miꞌimiꞌi imoi eka afuga laagai eapakipo keisa aisama, aloꞌi egama alogaina. ");
INSERT INTO mek_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ke kemai egaꞌina afugai kekoko aisama, imoi ina Maria fou egae keisa. Ke kelao keloukipo imoi keau afagaina. Egae kai eꞌi amu afaꞌi akaikiꞌaꞌi keukaꞌi feꞌa kegupukiꞌi, ke pipeni amuꞌi, gold, ke mulamula fogaꞌi feloꞌi auꞌi, ke myrrh keoma auga fou kekagauꞌi imoi kepalao penia. ");
INSERT INTO mek_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Egaꞌina afegai Deo nipiai ainaꞌi epalogo Herod eega fakelao eoma puo, keaga iꞌoina keafiia kemue ifoꞌi eꞌi ago kelao. ");
INSERT INTO mek_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Isa kemue kelao afegai, Lopia ega agelo nipiai Iosepa eapakina penia epainia einaka, “Moꞌue imoi moafia ina fou amopiaukoko Isipto amolao. Ke egae mo foagu felao alapainio kai fomue pugu, gome Herod isa agekapuga gaaupugua ageoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ega puo isa gapiai eꞌue, imoi eafiia ina fou egaꞌina afuga kepuaꞌafuga Isipto ago kelao. ");
INSERT INTO mek_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ke kelao egae mo keagu elao, Herod emae. Iꞌina kapaꞌi kemia, ega koa Lopia profeta akeꞌiai kapaꞌina eifafoua auga, koꞌa mo femia, “Lau gau laifaga Isiptoai epealai.” ");
INSERT INTO mek_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herod Mako auꞌi isa kefogeisa auga elogo aisama, gua ekupu alogaina. Ke ega au auꞌi eifa kapula peniꞌi, Mako auꞌi isa maagai kina keifania elogo auga koa iꞌopoga kina maagai imoi kemauni auꞌi, Betelemeai ke pagua kainagai auꞌi aloꞌiai imoi maguae inipoꞌi gua, ke papagai auꞌi maꞌoai kegaaupuguꞌi eoma. ");
INSERT INTO mek_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Isa ega koa ekapaisa auga profeta Jeremaia Deo ega iifa pukagai kapaꞌina eifania auga koꞌa mo femia kainai ekapaisa: ");
INSERT INTO mek_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Aufalao agaꞌo Rama agogai eapepe ke epinapina alogaina aina kelogonia. Egaꞌina auga Rachel gauga puoꞌiai eapepe, ke papiau kegapaame keoma eumaka, gome isa gauga laaꞌi kemia.” ");
INSERT INTO mek_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod emae afegai, Lopia ega agelo agaꞌo Isiptoai nipiai Iosepa eapakina penia. ");
INSERT INTO mek_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ke epainia einaka, “Moꞌue imoi moafia ina fou Israel ago amolao. Gome imoi kegaaupugua keoma auꞌi kemae efua,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ega puo eꞌue imoi eafiia ina fou kemue Israel ago kelao. ");
INSERT INTO mek_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kai isa Herod gauga Akelaus ama afuga eafiia Iudea ago eꞌima auga fouga elogo aisama, ega felao auga emaniꞌi. Ke Deo nipiai isa aina epalogo afegai, Kalilea ago elao. ");
INSERT INTO mek_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ke elao taoni agaꞌo aka Nasareta taoninai eagu. Ke egaꞌina auga Deo ega iifa pukagai profeta akeꞌiai eifafoua auga koꞌa mo emia. “Isa akeifaga Nasareta auga akeoma.” ");
INSERT INTO mek_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Egaꞌina afegai inipo maꞌo kelao kai, Ioane Baptista emai Iudea agogai ago maininai einogo. ");
INSERT INTO mek_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ke ega inogoai iina eifa oma, “Emi laomai apalaꞌi amoumakalainiꞌi, gome Deo ega agofaꞌa emai kainagai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ke isa fouga Deo ega iifa pukagai profeta Aisaea iina epapua oma koa iꞌopoga mo ekapaisa: “Ago maininai aufalao agaꞌo eagaga einaka, ‘Lopia ega keaga amopakaisa ke faugai amopaꞌopaina.’” ");
INSERT INTO mek_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ioane ega tiapu auga kamelo faagaꞌiai kekapaiꞌi, ke peleta aꞌo faagaꞌiai kekapa auga uufa epaafiapia. Ke ega foꞌama auga apelaꞌopu ke memeꞌuge feina fou. ");
INSERT INTO mek_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ierusaleme taoninai, Iudea ago, ke Jordan ago fofouga papiauꞌi kepealai isa eega kelao. ");
INSERT INTO mek_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ke eꞌi laomai apalaꞌi keifafouꞌi kai, Ioane Jordan agapugegai baptismo epeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kai egaꞌina alogai Faliseo ke Saduseo ikupuga papiauꞌi maꞌo isa baptismo epipeni afuga kemai eisaꞌi aisama epainiꞌi einaka, “Oi kaapa apala ipauma gauga koa iꞌopomi. Oi laomai apala mo okapakapa kai, paukai Deo kaniami gaagamauga ooma. Kaisau epainimi oi Deo ega guakupu eegai agopiaukoko eoma? ");
INSERT INTO mek_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","9","Oi ifomi alomiai foloopolaga, ‘Lai Abraham okogai amai puo Deo gauga aumai,’ auga agoifania agekaina folooma. Gome Deo anina ageani koa aisama, iꞌina kepoꞌi Abraham gauga agepamiaꞌi agekaina. Kai oi emi laomai apalaꞌi foumakalainiꞌi, ke emi laomai apalaꞌi oumakalainiꞌi auga gouga fokapa animi fooge. Egaꞌina gouga auga au agaꞌo puaga felo eoge koa iꞌopoga, oi isafa puami felo fooge, laomai feloꞌi papiau agoꞌiai fokapaꞌi. Egae kai oi Abraham okogai omai aumi fooma. ");
INSERT INTO mek_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ke oi fologo Deo emi laomai apala afa agepenimi auga, inaina au gomegai efua ekae koa iꞌopoga. Ke au kapa anina felo aeoge auga ageisaga, loai ageiꞌafoau. ");
INSERT INTO mek_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Lau oi emi laomai apalaꞌi foumakalainiꞌi laoma puo feisai mo baptismo lapenimi. Kai muniuai agemai auga ega isapu lau eꞌu isapu ekaꞌegaina. Ke lau isa ife kamataga alaafiakae alapua afaekaina. Isa Deo ega Spiritu isapugai ke loai baptismo agepenimi. ");
INSERT INTO mek_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ke isa efua imagai poka eafiia, laiti felo auga gaafia kai apala auga gaoge meꞌe eoma. Ega kainai laiti kepaogogo afugai eapae, laiti feloꞌi auꞌi ageafiꞌi foꞌama keogeoge eꞌa agelaoainiꞌi, ke apalaꞌi auꞌi ageafiꞌi lo aealoalo auga alogai ageꞌafoꞌauꞌi akeaga.” ");
INSERT INTO mek_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ioane einoinogo kai, Iesu baptismo gaafia eoma puo Kalilea agogai epagai emai Jordan agapugegai Ioane eegai. ");
INSERT INTO mek_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kai Ioane Iesu epaapakipo ke epainia einaka, “Oi lau baptismo fopeniau kai kapa puo lau eeu lomai?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kai Iesu einaka, “Pau lau faagauai kapaꞌina femia auga mokapa. Iꞌina fakapa ega koa Deo maagai alo opai laoꞌi maiꞌi maꞌoai koꞌaꞌi mo fekemia,” eoma. Ega puo Ioane isa baptismo epeniia. ");
INSERT INTO mek_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ke Iesu baptismo mo eafiia ke fiakoa mo feisai eꞌagaukae. Ega aisama ufa eagalai, Deo ega Spiritu koofi koa iꞌopoga laagai eake eisa. ");
INSERT INTO mek_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ke ufai aufalao agaꞌo eifa einaka, “Iꞌina auga Lau Gau alou koꞌagai anina laani alogaina. Ke isa eegai alou egama alogaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Iesu Jordan Agapugegai baptismo eafiia afegai, Deo ega Spiritu Iesu epapea ago maini elaoaina, ega koa tiapolo isa feꞌopo eoma. ");
INSERT INTO mek_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ke egae ago maininai eani gopegope kapa agaꞌo aeania elao kina ke gapi 40 aisama, inaega ekimu alogaina. ");
INSERT INTO mek_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ega aisama iꞌopo auga Satani emai isa eꞌopoisa einaka, “Oi Deo Gauga koa aisama, iꞌina kepoꞌi mopainiꞌi palafa kegamia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kai Iesu einaka, “Deo ega iifa pukagai iina kepapua oma: ‘Papiau aumauni palafa mo akeania akeagu afaekaina. Kai Deo ega iifa akegai kepealai auꞌi maꞌoai isafa aniꞌi fekeani kainai fekepea ke fekeaguaina,’” eoma. ");
INSERT INTO mek_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Egae kai Satani Iesu eafiia elaoaina Ierusaleme Deo ega taoniai. Ke elaoainia mo Deo ega eꞌa ofaofa auꞌoniai kua onina ipaumagai epaapa. ");
INSERT INTO mek_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Egae kai epainia einaka, “Oi Deo Gauga koa aisama, iꞌina afugai ifomu mopiulaiso. Gome Deo ega iifa pukagai iina kepapua oma: “‘Isa oi faumuai ega agelo ageifa kapula peniꞌi akeꞌima feloiso. Ke imaꞌiai akeafiakaeiso ega koa ifemu kepoai afoloꞌanina,’” eoma. ");
INSERT INTO mek_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Kai Iesu isa ega iifa epamue einaka, “Deo ega iifa pukagai isafa iina kepapua oma: ‘Oi emu Lopia Deo foloꞌopo,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ke tiapolo Iesu eafiia pugu elao iku agaꞌo onina ipaumagai kai, agofaꞌa fofouga ega akaikiꞌa ke ega felo ala koa auga epakina. ");
INSERT INTO mek_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Egae kai epainia einaka, “Oi aloloukipo lau aloau afagainiau koa aisama, iꞌina kapaꞌi maꞌoai oi alapenio,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kai Iesu isa epainia einaka, “Satani! Eeuai moapaꞌau. Gome Deo ega iifa pukagai iina kepapua oma: ‘Emu Lopia Deo ifogamo foau afagaina, ke Isa mo ega pinauga fokapa,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ega aisama Satani Iesu epuaꞌafuga, ke Deo ega agelo kemai Iesu kepalagaina. ");
INSERT INTO mek_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Egaꞌina afegai Iesu Ioane kepatipulania auga fouga elogo aisama, emue Kalilea ago elao. ");
INSERT INTO mek_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Egae kai Nasareta taonina epuaꞌafuga elao Kapenaum taoninai eagu. Egaꞌina taonina auga aꞌu aka Kalilea keoma auga eegai, Sebulun ke Naftali auniꞌi agoꞌiai. ");
INSERT INTO mek_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iesu ega koa ekapaisa auga Deo ega iifa pukagai profeta Aisaea eifania ke iina epapua oma auga koꞌa mo emia: ");
INSERT INTO mek_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Iudea papiauꞌi laaꞌi auꞌi Sebulun ago ke Naftali ago auniꞌi, Jordan agapuge apiegai ke Kalilea aꞌuga niegai keague auꞌi! ");
INSERT INTO mek_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Egae egaꞌina papiauꞌi uminagai keague auꞌi eaea akaikiꞌa keisa. Isa mae afuga ogo koa iꞌopoga afugai keague auꞌi eaea akaikiꞌa eake egefaiꞌi.” ");
INSERT INTO mek_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Egaꞌina kinagai Iesu eꞌina Kalilea agogai einogo einaka, “Oi emi laomai apalaꞌi amoumakalainiꞌi, gome Deo ega agofaꞌa fouga emai eemiai efua,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesu kina agaꞌogai Kalilea aꞌuga foegai epea alogai, au aaga akina auniꞌi eisaꞌi. Egaꞌina auꞌi auga Saimon Peto keoma auga, ke akina Andru auniꞌi. Isa egaꞌina aꞌugai feꞌi keogeoge kai eisaꞌi gome isa inoino auꞌi. ");
INSERT INTO mek_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ega aisama Iesu isa epainiꞌi einaka, “Omai muniuai amopea. Ke lau oi papiau ipaoaꞌi aumi alapamiaimi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Peto Andru auniꞌi Iesu ega eifa oma aina kelogonia aisama, fiakoa mo eꞌi feꞌi, ke amu maꞌoai kepuaꞌafuniꞌi Iesu muninai kelao. ");
INSERT INTO mek_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ke egae ekailai elao au iꞌoina agaꞌo akina auniꞌi eisaꞌi. Isa auniꞌi auga Sebedi gauga James akina Ioane auniꞌi. Ke isa amaꞌi Sebedi fou gaagai keagu feꞌi kekapaiꞌi kegaogeꞌi keomaoma kai eisaꞌi eifaniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ega aisama isa fiakoa mo eꞌi gaaga ke amaꞌi fou kepuaꞌafuniꞌi Iesu muninai kepea. ");
INSERT INTO mek_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Egaꞌina afegai Iesu Kalilea ago fofouga alogai epea, Iudea papiauꞌi eꞌi laꞌafou afuꞌiai ekoko epamalele, ke iifa faunina Deo ega agofaꞌa fouga einogoaina. Egaꞌina alogai papiau isafa iꞌoiꞌi iꞌoiꞌi keafiꞌi auꞌi kemai maꞌoai epafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Iesu fouga epea efoufaꞌa Siria ago papiauꞌi maꞌoai kelogo. Ega puo papiau isafa iꞌoiꞌi iꞌoiꞌi keafia papiauꞌi kemaiseiniꞌi isa eegai epafeloꞌi. Isafa egaꞌina auꞌi kiekie akaikiꞌaꞌi keafiꞌi auꞌi, tiapolo aloꞌiai keagu auꞌi, isafai epakauainiꞌi faagaꞌi efaꞌiꞌi auꞌi, ke faagaꞌi kemae auꞌi. ");
INSERT INTO mek_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Iesu ega koa ekapaisa puo, papiau laꞌafou akaikiꞌagai isa muninai kepea. Egaꞌina papiauꞌi isa Kalilea agogai kemai, isa Taoni Ouꞌaga keoma taoninai kemai, isa Ierusaleme taoninai kemai, isa Iudea agogai kemai, ke isa Jordan agapuge eegai keagu auꞌi isafa kemai. ");
INSERT INTO mek_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ke Iesu papiau maꞌo laꞌafouai eisaꞌi aisama, elao iku agaꞌogai eꞌagaukae mapegai eagukipo. Ke ega imoi auꞌi kemai isa eegai. ");
INSERT INTO mek_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Egae kai epamaleleniꞌi einaka: ");
INSERT INTO mek_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Lalauꞌiai keulalu auꞌi Deo eegai kapa feloꞌi keafiꞌi, gome Deo ega agofaꞌa isa apuꞌi. ");
INSERT INTO mek_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ke keapepe auꞌi Deo eegai kapa feloꞌi keafiꞌi, gome Deo isa agepaameꞌi. ");
INSERT INTO mek_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ke ifoꞌi kepaakeꞌi eꞌeleꞌi kepamiaꞌi auꞌi Deo eegai kapa feloꞌi keafiꞌi, gome Deo aagoa isa apuꞌi agepamia. ");
INSERT INTO mek_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ke alo opai laoꞌi maiꞌi inaekimuga ke aisokupuga kepaꞌaua auꞌi Deo eegai kapa feloꞌi keafiꞌi, gome Deo isa aloꞌi agepapogua. ");
INSERT INTO mek_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ke papiau guaꞌi keania auꞌi Deo eegai kapa feloꞌi keafiꞌi, gome Deo isa guaꞌi ageania. ");
INSERT INTO mek_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ke aloꞌi elolofa auꞌi Deo eegai kapa feloꞌi keafiꞌi, gome isa Deo akeisa. ");
INSERT INTO mek_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ke gagao kekapa auꞌi Deo eegai kapa feloꞌi keafiꞌi, gome isa akeifaniꞌi Deo gauga akeomaꞌi. ");
INSERT INTO mek_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ke alo opai laoꞌi maiꞌi kekapaꞌi kainai keafi apalaniꞌi auꞌi Deo eegai kapa feloꞌi keafiꞌi, gome Deo ega agofaꞌa isa apuꞌi. ");
INSERT INTO mek_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ke lau puouai papiau oi akeifa apala penimi, akeafi apalanimi, ke pifogeai akepaagu fofoumi iifa apalaꞌi iꞌoiꞌi iꞌoiꞌi maꞌoai eemiai akeifaniꞌi aumi, Deo eegai kapa feloꞌi oafiꞌi aumi. ");
INSERT INTO mek_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ke foalogama alomi fegama alogaina, gome afa felo ufai ekae auga akaikiꞌa ipauma. Ufainagai oi alomai koa kai isa profeta isafa ega keafi apala omaꞌi.” ");
INSERT INTO mek_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ke Iesu eifa pugu einaka, “Oi auga aagoa kikimaluga koa iꞌopomi. Kai kikimalu mekiꞌaga agefua koa aisama, ala akeoma agemekiꞌa pugu? Isa ega mekiꞌa efua kainai akeafia kapa agaꞌo felo akekapa afaekaina. Kai akeafia akepuake papiau laagai akepea akegafamuꞌa. ");
INSERT INTO mek_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ke oi auga iꞌina agofaꞌa eaea koa iꞌopomi. Taoni agaꞌo iku eꞌelegai kepaapa auga akepaiꞌofake afaekaina koa iꞌopoga, oi isafa agoiꞌofake afaekaina. ");
INSERT INTO mek_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ke papiau lanepa akepaafiaua aisama, liti papagai afakeogeꞌunia. Kai lanepa kepapaꞌafa afugai akepaꞌafa, ega koa eꞌai keagu papiauꞌi maꞌoai eaea agepeniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ega koa iꞌopoga, oi isafa laomai feloꞌi fokapaꞌi emi eaea papiau laaꞌiai fopagefaua, ega koa papiau oi emi laomai feloꞌi fekeisaꞌi Amami ufai eague auga fekeifagaina.” ");
INSERT INTO mek_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ke Iesu eifa pugu einaka, “Oi foloopolaga lau Deo ega iifa Moses epenia auga, ke Profeta kapaꞌina keifania auga isafa laaꞌi mapamiaꞌi laoma puo lamai folooma. Laaꞌi. Lau lamai auga egaꞌina iifaꞌi laaꞌi fapamiaꞌi puo alamai kai koꞌaꞌi mo fapamiaꞌi laoma puo lamai. ");
INSERT INTO mek_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Iifa gome maamiai laifania. Aagoa ufa fou laaꞌi akemia kai, egaꞌina iifaꞌi alogai malele eꞌele mo, o peni kuagai afaꞌagamo mo kepaau opogaina auga afuga agaꞌomo mo ganinagai laaꞌi afaemia agelao egaꞌina iifaꞌi maꞌoai koꞌaꞌi mo akemia. ");
INSERT INTO mek_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ega puo kaisau iꞌina iifaga kapula eꞌele ipauma agaꞌomo mo ageaupea, ke papiau isafa agepamaleleniꞌi, isa ekapa koa akekapa auga Deo ega agofaꞌai akeifaga au eꞌele akeoma. Kai kaisau iꞌina iifaꞌi kaiꞌiai mo agepea ke pamaleleꞌi papiau agepamaleleniꞌi auga, Deo ega agofaꞌai akeifaga au akaikiꞌa akeoma. ");
INSERT INTO mek_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Gome lau lapainimi, oi alomi opaina Faliseo auꞌi ke pamalele auꞌi fou eꞌi alo opai afaekaꞌegaina koa aisama, Deo ega agofaꞌai afolokoko paisa.” ");
INSERT INTO mek_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ke Iesu eifa pugu einaka, “Ufainagai Moses ega iifa kainai, papiau kepainiꞌi iina keoma auga aꞌo ologonia. ‘Kai agaꞌo foloaupugua. Ke kaisau aufalao agaꞌo ageaupugua auga ega apala afa kansolo auꞌi eeꞌiai ageafia,’ keoma. ");
INSERT INTO mek_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kai lau lapainimi. Kaisau ifo aaga akina eegai gua ekupu auga ega laomai apala afa Deo eegai ageafia. Ke kaisau aaga akina mo agepaina amaꞌama auga ageoma auga kansolo auꞌi agoꞌiai iifa agepakaisa. Ke kaisau aaga akina agepaina ‘Oi kafoꞌo aumu’ ageoma auga ipeli logai agekoko ageaga. ");
INSERT INTO mek_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Ega puo oi Deo amu kepaꞌa penia afugai kapa agaꞌo Deo mopaꞌa penia loomaoma kai aamu akimu agaꞌo oi eemuai gua ekupu auga aloopolaga koa aisama, pipeni amuga egaꞌina afuga akegai fopuaꞌafuga feka. Egae kai folao aamu akimu eegai oi emu apala feꞌagegeai kakaua fou fogagao kai fomai pugu emu pipeni Deo fopaꞌa penia. ");
INSERT INTO mek_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ke aufalao agaꞌo oi iifa ipakainai agepaapaukaiso aisama, fiakoa mo egaꞌina papiauga aunimi kapa egaꞌina oko fopakaisa. Ke iifa ipakaina auga eega alolao koa kai keagai ega koa fokapa. Laaꞌi koa aisama, isa ageafio au oi emu laomai afa fepenio auga imagai agepauiso. Ke isa oi tipula afuga eꞌima auga imagai agepauiso, ke tipula afuga eꞌima auga oi tipula afugai ageꞌafo kokoiso. ");
INSERT INTO mek_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Iifa gome maamiai laifania. Oi afolopealai laaꞌi agelao emi moni fua eemiai ekae auga agopafua afeꞌaina.” ");
INSERT INTO mek_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Iesu eifa pugu einaka, “Ufainagai Moses ega iifa kainai papiau iina keifa oma aꞌo ologonia. ‘Aufalao agaꞌo fou aloamage auga fou folofeu,’ keoma. ");
INSERT INTO mek_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kai lau oi lapainimi. Kaisau ifiao o papie eisa emaaga auga, papie fou kefeu koa laoga maina apala gua alogai ekapaisa efua. ");
INSERT INTO mek_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Oi maami kaina epaafimi laomai apala okapa koa aisama, amoꞌiulaisa amopuake. Oi faagami agaꞌo fegea kai Deo ega agofaꞌai fokoko auga felo. Kai faagami fofouga mo ipeliai agoake auga apala ipauma. ");
INSERT INTO mek_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ke oi imami kaina epaafimi laomai apala okapa koa aisama, fofoua fopuake. Oi faagami agaꞌo fegea kai Deo ega agofaꞌai fokoko auga felo. Kai faagami fofouga mo ipeliai agoake auga apala ipauma.” ");
INSERT INTO mek_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ke Iesu eifa pugu einaka, “Moses ega iifa kainai iina keifa oma auga isafa aꞌo ologonia. ‘Au agaꞌo akafa agepaake auga, isa akafa epaake auga pepa fekapa fepenia,’ keoma. ");
INSERT INTO mek_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kai lau lapainimi. Kaisau akafa fou keamage ke akafa egaꞌina aufalao agaꞌo fou afakefeu mo ganinagai agepaake auga, isa akafa au iꞌoina agaꞌo fou kefeu auga laoga maina isa epagama. Ke kaisau ipaake papiega ageakafania auga, isa papie iꞌoina agaꞌo fou fakefeu auga iifaga eaupea. ");
INSERT INTO mek_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ke Iesu eifa pugu einaka, “Ufainagai Moses ega iifa kainai papiau iina kepaini omaꞌi auga isafa aꞌo ologonia. ‘Oi emi pakoꞌa niniꞌanina okapaisa auga laagai foloaopagai. Kai Lopia eegai emi pakoꞌa niniꞌanina egaꞌina okapaisa auga kainai fopea,’ keoma. ");
INSERT INTO mek_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kai lau lapainimi. Oi pakoꞌa niniꞌanina agaꞌomo mo ganinagai folokapa. Oi ufa akagai isafa pakoꞌa niniꞌanina folokapa. Gome ufa auga Deo ega aguagu afuga. ");
INSERT INTO mek_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ke oi aagoa akagai isafa pakoꞌa niniꞌanina folokapa. Gome aagoa auga Deo ife ipaapauga afuga. Ke oi Ierusaleme taonina isafa akagai pakoꞌa niniꞌanina folokapa. Gome Ierusaleme taonina auga Kin akaikiꞌa Auga ega taoni. ");
INSERT INTO mek_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ke oi ifomi kaniamiai pakoꞌa niniꞌanina folokapa. Gome oi ifomi kaniamiai fufumi agaꞌomo ganinagai keloga o umuga agopamia afaekaina. ");
INSERT INTO mek_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kai aufa kina koꞌa mo foifania, ke kapaꞌina agokapa auga ‘E’ mo fooma, ke afolokapa auga, ‘Laaꞌi’ mo fooma. Ke muniai kapaꞌina agoifania auga tiapolo eegai emai.” ");
INSERT INTO mek_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ke Iesu eifa pugu einaka, “Oi Moses ega iifa kainai papiau iina keifa oma auga aꞌo ologonia. ‘Aufalao agaꞌo au agaꞌo maaga agepalifua koa aisama, papiau egaꞌina isafa isa ima afa feoge iꞌopoga mo faagagai fekapa. Ke aufalao agaꞌo au agaꞌo nie agepalifua koa aisama, papiau egaꞌina isafa isa ima afa feoge iꞌopoga mo faagagai fekapa,’ keoma. ");
INSERT INTO mek_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kai lau lapainimi. Papiau apala agaꞌo oi eemuai apala afekapa koa aisama, ima afa folooge. Ke aufalao agaꞌo meꞌemu kaina afepoa koa aisama, apie foailao meꞌemu lafanina kaina isafa fepoa. ");
INSERT INTO mek_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ke aufalao agaꞌo iifa ipakainai gapaapaukaiso kai emu tiapu iꞌiuka gaafia ageoma koa aisama, afemu tiapuga isafa feafia. ");
INSERT INTO mek_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ke aufalao agaꞌo agepaafio fou 2 kilomita amopea ageoma koa aisama, fou 4 kilomita fopea. ");
INSERT INTO mek_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ke kaisau kapaꞌina agegoinimi auga fopenia, ke kaisau eemiai kapa agaꞌo gaafia kai muniai fepenimueimi ageoma auga folomuniapua, kapaꞌina gaafia eoma auga fopenia.” ");
INSERT INTO mek_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ke Iesu eifa pugu einaka, “Moses ega iifa kainai papiau iina keifa oma auga aꞌo ologonia. ‘Alomi koꞌagai emi eꞌa ipafe auꞌi aniꞌi foani. Kai emi ou auꞌi auga alomi koꞌagai aniꞌi foloani,’ keoma. ");
INSERT INTO mek_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kai lau lapainimi. Alomi koꞌagai emi ou auꞌi aniꞌi foani, ke keafi apalanimi auꞌi fauꞌiai fomegamega. ");
INSERT INTO mek_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ega koa Amami ufai eague auga gauga agomia agekaina. Gome Deo kina epaaga papiau feloꞌi ke apalaꞌi ma ganinagai maꞌoai laaꞌiai egefaopu. Ke imu epaꞌaua alo opai ke alo opai laaꞌi auꞌi isafa epeniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ega kainai oi papiau animi keani auꞌi mo aniꞌi agoani koa aisama, Deo eegai egaꞌina laoga mainai afa felo agoafia ma? Ke tax isafina auꞌi isafa laomai apala ikapa auꞌi mo ganinagai ega koa akekapa ma? ");
INSERT INTO mek_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ke oi aami akimi mo agopamegoniꞌi koa aisama, oi kapaꞌina okapa auga papiau isaꞌi kapaꞌina kekapa auga faagagai okaꞌegainiꞌi ma? Oi kapa agaꞌo alokapa isa alokaꞌegainiꞌi. Gome Deo akelogonia papiauꞌi isafa ega koa kekapa. ");
INSERT INTO mek_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ega puo oi Amami ufai eague auga alo opai laoꞌi maiꞌi alo epogu koa iꞌopoga, oi isafa Isa koa iꞌopoga fomia alo opai laoꞌi maiꞌi alomi fepogu.” ");
INSERT INTO mek_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ke Iesu eifa pugu einaka, “Foisa felo oi emi laomai feloꞌi papiau kegaisa ooma puo papiau agoꞌiai folokapa. Gome oi ega agokapa oma koa aisama, Amami ufai eague auga eegai afa felo afoloafia. ");
INSERT INTO mek_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ega puo oi ulalu papiauꞌi amu openiꞌi aisama pifoge auꞌi kekapa koa iꞌopoꞌi folokapa. Isa auga papiau isa kegaisaꞌi au akaikiꞌaꞌi kegapamiaꞌi keoma puo, laꞌafou afuꞌiai ke peapea afuꞌiai papiau agoꞌiai keapa eꞌi laomai felo auga fiꞌi keipina auꞌi kekapa koa iꞌopoga kekapa. Iifa gome maamiai laifania. Isa eꞌi laomai afa keafiia efua. ");
INSERT INTO mek_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kai oi ulalu papiauꞌi amu agopeniꞌi aisama, imami kaina kapaꞌina ekapa auga imami lafanina faelogo. ");
INSERT INTO mek_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ega koa fokapa ogefakeai egaꞌina laoga maina fokapa. Ega agokapa oma koa aisama, Amami laomai ogefakeai okapa eisa auga afa felo agepenimi.” ");
INSERT INTO mek_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ke Iesu eifa pugu einaka, “Oi agomegamega aisama pifoge auꞌi kemegamega koa iꞌopoga folomegamega. Gome pifoge auꞌi kegamegamega keoma aisama, papiau isa fekeisaꞌi auga anina keani alogaina puo laꞌafou afuꞌiai, ke keaga kiuꞌiai keapa kemegamega. Iifa gome maamiai laifania. Isa eꞌi laomai afa keafiia efua. ");
INSERT INTO mek_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kai oi agomegamega aisama, folao emi eꞌa alogai oi mo ologo afugai fokoko paꞌafi fokupuga kai, Amami eaguega kai aloisaisa auga fomegamega penia. Ega agokapa oma koa aisama, Amami ogefakeai kapaꞌina okapa eisa auga afa felo agepenimi. ");
INSERT INTO mek_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ke oi agomegamega aisama, Deo akelogonia auꞌi niniꞌani aniꞌi laaꞌi maꞌo keifaniꞌi auꞌi koa folomia. Gome isa kepamia niniꞌani maꞌo keifaniꞌi puogai Deo ainaꞌi agelogo keoma. ");
INSERT INTO mek_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ega puo oi auga isa kekapa koa folokapa. Gome oi Amami kapaꞌina agogoina auga alogoina koa kai elogo efua. ");
INSERT INTO mek_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ega puo oi iina fomegamega oma: ‘Amamai ufai loague aumu, Akamu galolofa aoma. ");
INSERT INTO mek_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ke emu agofaꞌa gamai. Oi emu logoai kapaꞌina anina loani ufai kekapa auga iꞌopoga mo aagoai isafa gaikapa. ");
INSERT INTO mek_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Aufa kina foꞌamaga pau mopenimai. ");
INSERT INTO mek_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ke lai papiau eꞌi apala aꞌagegeainiꞌi koa iꞌopoga, Oi isafa lai emai apala moꞌagegeainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ke mopapeaimai iꞌopo apalaꞌi aloꞌiai falakoko, ke tiapolo apala auga eegai mopapealaimai.’” ");
INSERT INTO mek_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Oi papiau eꞌi apala foꞌagegeainiꞌi, gome oi papiau eemiai apala kekapa auꞌi eꞌi apala agoꞌagegeainiꞌi koa aisama, Amami ufai eague auga isafa, oi emi apala ageꞌagegeainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kai oi papiau eꞌi apala afoloꞌagegeainiꞌi koa aisama, Amami ufai eague auga isafa, oi emi apala afaeꞌagegeainiꞌi.” ");
INSERT INTO mek_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ke Iesu eifa pugu einaka, “Oi agoani gopegope aisama, pifoge auꞌi kekapa koꞌa iꞌopoga folokapa alomi faemafu. Gome isa keani gopegope aisama, papiau isa keani gopegope auga fekeisa keoma puo, iisaꞌi keafi lilifua. Iifa gome maamiai laifania, isa eꞌi laomai afa keafiia efua. ");
INSERT INTO mek_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kai oi agoani gopegope aisama, maami foikua ke oili kaniamiai fooge. ");
INSERT INTO mek_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ega koa oi oani gopegope auga papiau folopakinaꞌi kai, oi Amami eaguega kai aloisaisa auga mo fopakina. Ke oi Amami kapaꞌina ogefakeai okapa eisa auga afa felo agepenimi.” ");
INSERT INTO mek_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ke Iesu eifa pugu einaka, “Oi ifomi faumiai inae aagoa amuꞌiai folopaꞌamuꞌamu. Gome aagoa amuꞌi auga moamoa ke mokemoke ageafiꞌi akelifu. Ke painao auꞌi isafa oi emi eꞌa akeaupea egaꞌina amuꞌi akepainaoniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ega puo inae aagoa amuꞌiai folopaꞌamuꞌamu kai, oi ifomi faumiai ufa amuꞌiai fopaꞌamuꞌamu. Gome amu ufai kekae auꞌi moamoa ke mokemoke afaeafiꞌi afakelifu. Ke painao auꞌi isafa eꞌa afakeaupea afakepainaoniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Lau ega laifa oma, gome oi alomiai afu kapagai opaꞌamuꞌamu afugai, guami fofouga isafa egae ooge.” ");
INSERT INTO mek_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ke Iesu eifa pugu einaka, “Oi maami auga imaaumi fofouga ega eaea. Ega puo oi maami felo koa aisama, imaaumi fofouga eaea agepogu. ");
INSERT INTO mek_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kai oi maami apala ipauma koa aisama, imaaumi fofouga umina agepogu. Ega puo oi alomiai eaea egaꞌina auga umina koa aisama, umina egaꞌina oi imaaumi fofouga agepalifu afeꞌaina.” ");
INSERT INTO mek_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ke Iesu eifa pugu einaka, “Kai agaꞌo lopia auniꞌi eꞌi kalaꞌafi agemia afaekaina. Isa alo koꞌagai agaꞌo anina afaeani, ke agaꞌo alo koꞌagai anina ageani, o isa alo koꞌagai agaꞌo ega iifa kainai agepea kai, agaꞌo auga alo koꞌagai ega iifa kainai afaepea. Ega koa iꞌopoga mo, Deo ke moni fou eꞌi pinauga agokapa agaꞌonia mo afaekaina. ");
INSERT INTO mek_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ega puo iifa gome maamiai laifania, oi emi agu opopo folopaꞌaua. Egaꞌina auga kapaꞌina agoania, o agoinu auga opopo folopaꞌaua. Ke imaaumi isafa opopo folopaꞌaua. Egaꞌina auga kapaꞌina agoiꞌiuka auga opopo folopaꞌaua. Oi emi agu auga kapa akaikiꞌa foꞌama aekaꞌegaina ma? Ke imaaumi auga kapa akaikiꞌa ipauma, tiapu aekaꞌegaina ma? Koꞌa ipauma. Oi emi agu ke imaaumi fou kapa akaikiꞌaꞌi ipaumaꞌi. ");
INSERT INTO mek_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Maami galao ufa ineiꞌi amoisaꞌi. Isa kapa agaꞌo akefauga, o foꞌama agaꞌo foꞌama isoge eꞌagai akeꞌoamenia aeka. Ega mo ganinagai oi Amami ufai eague auga isa epaanianiꞌi. Oi auga kapa akaikiꞌami ufa ineiꞌi alokaꞌegainiꞌi ma? ");
INSERT INTO mek_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Oi epomiai kaisau opopoai kina maaga agaꞌomo koa ega aguagu laagai eogeaua ifo ega agu epo epamaefania? Kai agaꞌo laaꞌi. ");
INSERT INTO mek_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ega puo kapa puo oi tiapu kapa agoiꞌiuka auga opopo opaꞌaua? Maami galao ago alo kaikaiꞌi ala keuki oma auga amoisaꞌi. Isa akepinauga ke kapa agaꞌo fekeꞌiuka auga pinaugaga agaꞌo akekapa. ");
INSERT INTO mek_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kai lapainimi, Solomon epaꞌamuꞌamu alogai mo ganinagai, ega tiapu agaꞌomo mo ganinagai kaikai egaꞌina eꞌi felo aekaꞌegaina. ");
INSERT INTO mek_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Deo ago alo mukimukiꞌi pau kekae kai fafoko akemae, loai akeꞌafoauꞌi mo ganinagai, kaikaiꞌi tiapu felo ipauma koa epeniꞌi keiꞌiukaꞌi, iisaꞌi felo ipauma emia. Ega koa aisama, oi Deo maagai kapa akaikiꞌami ipaumami puo, oi tiapu maꞌo afaepenimi afoloꞌiukaꞌi ma? Oi pakoꞌa eꞌele aumi! Iifa gome Isa oi tiapu maꞌo agepenimi agoiꞌiukaꞌi. ");
INSERT INTO mek_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ega puo foloopopo foloifa, ‘Kapaꞌina agaania?’, o ‘Kapaꞌina againu?’ o ‘Kapaꞌina agaiꞌiuka?’ folooma. ");
INSERT INTO mek_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Gome Deo akelogonia papiauꞌi auga egaꞌina kapaꞌi mo opopoꞌi kepaꞌauꞌi, ke muniꞌiai kepiau. Kai oi Amami ufai eague auga egaꞌina kapaꞌi maꞌoai aniꞌi oani auga elogo efua. ");
INSERT INTO mek_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ega puo Deo ega agofaꞌa, ke ega alo opai laoꞌi maiꞌi fokapu kakauꞌi. Egae kai egaꞌina kapaꞌi maꞌoai aniꞌi oani auꞌi isafa egaꞌina fou laagai ageogeaua. ");
INSERT INTO mek_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ega puo oi fafoko opopo folopaꞌaua. Gome fafoko kapaꞌina agemia auga ifo opopo agepaꞌaua. Aufa kina auga ifo ega opopo egome mo ekae.” ");
INSERT INTO mek_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ke Iesu eifa pugu einaka, “Aufalao agaꞌo kapa agaꞌo ekapaisa auga oi alomiai isa felo o apala ekapaisa folooma. Laaꞌi koa aisama, oi kapa agaꞌo alokapa aisama, aufalao agaꞌo isafa alogai oi felo o apala lokapaisa ageoma. ");
INSERT INTO mek_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gome felo o apala alomiai agoopolaga agoifania aisama, Deo isafa oi eemiai ega koa agekapa. Ke aufalao agaꞌo ega laomai felo o apala afa ala openi oma auga iꞌopoga mo, Deo oi afa ega agepenimi omaimi. ");
INSERT INTO mek_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Kapa puo oi aami akimi maaꞌiai au keilina aeapuga eꞌele ekae auga oisa kai, oi ifomi maamiai au uꞌufa akaikiꞌa ekae auga gefa aloauga? ");
INSERT INTO mek_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Oi aufa kina maamiai au uꞌufa ekaega maami ekaisapua kai, ala koa aami akimi opainiꞌi oinaka, ‘Aau o akiu, maamuai amaꞌama eꞌele maafilaisa ooma?’ ");
INSERT INTO mek_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Pifoge aumi! Foufai ifomi maamiai au uꞌufa ekae auga foafilaisa kai, maami ofakaegai aami akimi maaꞌiai iili aeapuga ekae auga agoafilaisa agekaina. ");
INSERT INTO mek_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ke Deo maagai kapaꞌina elolofa ooma ooge meꞌe auga, oafia amuꞌe folopeniꞌi. Ke kapa agaꞌo afa akaikiꞌagai oꞌafa auga oafia uma folopiu peniꞌi. Kai ega agokapa oma koa aisama, uma kapa felo egaꞌina auga ifeꞌiai akegafamuꞌa kai, akeꞌafoaipini oi eemi akefai akeꞌiꞌiokaimi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ke Iesu eifa pugu einaka, “Fopinoi ke agoafia. Fokapuga ke agokapulaisa. Ke paꞌafi foꞌinipa ke paꞌafi ageagalai. ");
INSERT INTO mek_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Gome kaisau epinoi auga kapaꞌina egoina auga eafia. Ke kaisau kapa agaꞌo ekapuga aepakipo auga ekapulaisa. Ke kaisau paꞌafi eꞌinipa auga paꞌafi eagalai. ");
INSERT INTO mek_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ke oi epomiai kaisau auga gauga isa agegoina palafa ageoma aisama, kepo agepenia? ");
INSERT INTO mek_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ke kaisau gauga isa agegoina maꞌa ageoma aisama, kaapa agepenia? ");
INSERT INTO mek_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Oi laomai apala ikapa aumi mo ganinagai, pipeni felo gaumi ipeniꞌi ologo. Kai oi Amami ufai eague auga felo ipauma puo, kaisau Isa egoina auga pipeni feloꞌi maꞌo mo agepenia papiau agekaꞌegainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ega puo kapa maꞌoai agokapaꞌi alogai, papiau oi eemiai kapaꞌina fekekapa ooma auga mo isa eeꞌiai fokapa. Gome Moses ega iifa ke profeta maꞌoai eꞌi iifa maꞌoai ega fokapa oma keoma kepapua ekae.” ");
INSERT INTO mek_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ke Iesu eifa pugu einaka, “Oi auga paꞌafi ake eꞌelegai fokoko. Gome keaga ake akaikiꞌa auga elao afu apala ipauma papiau epalifuꞌi afugai epealai. Ke egaꞌina afuga paꞌafina ake akaikiꞌa. Ega puo papiau maꞌo egaꞌina paꞌafinai kekoko. ");
INSERT INTO mek_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kai keaga elao papiau agu pagai maunina keafia afugai epealai auga ake eꞌele, ke paꞌafina isafa ake eꞌele. Ega puo papiau isaꞌi mo egaꞌina paꞌafinai kekoko.” ");
INSERT INTO mek_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ke Iesu eifa pugu einaka, “Profeta pifogeꞌi eemi kefai auꞌi foisa feloꞌi. Isa faagaꞌi afe auga sipi koa iꞌopoga kai aloꞌi auga, ago alo amuꞌeꞌi aꞌiꞌi koa iꞌopoꞌi. ");
INSERT INTO mek_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ke isa papiau kapaꞌi auꞌi eꞌi laomaisai agoisaꞌi agologo. Ke papiau ini gufugai aupua puaga akeafia agekaina ma? Ke ini gufugai au aka fik keoma auga isafa puaga akeafia agekaina ma? Laaꞌi afaekaina! ");
INSERT INTO mek_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ega koa iꞌopoga, au felo auga puaga felo eoge kai, au apala auga puaga apala eoge. ");
INSERT INTO mek_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ke au felo auga anina apala afaeoge, ke au apala auga anina felo afaeoge. ");
INSERT INTO mek_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Au kapaꞌi aniꞌi felo afakeoge auꞌi akeagaꞌi loai akeꞌafoauꞌi. ");
INSERT INTO mek_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ega puo profeta pifogeꞌi auꞌi, au puagai aisa alogo koa iꞌopoga, isa isafa eꞌi laomaisai isa kaisau auga agoisaꞌi agologo.” ");
INSERT INTO mek_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ke Iesu eifa pugu einaka, “Papiau lau, ‘Lopia, Lopia,’ keomaisau auꞌi maꞌoai mo ufai Deo ega agofaꞌai afakekoko. Kai kaisau lau Amau ega logoai kapa maꞌoai ekapa auga mo egaꞌina agofaꞌagai agekoko. ");
INSERT INTO mek_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Egaꞌina kina maꞌo lau akepainiau, ‘Lopia, Lopia, lai oi akamuai profeta koa iꞌopoga emu iifa papiau maaꞌiai aifafoua, ke oi akamuai tiapolo papiau aloꞌiai keagu auꞌi apapealaiꞌi, ke oi akamuai mirakulo maꞌo akapaiꞌi,’ akeoma. ");
INSERT INTO mek_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ega aisama lau isa maaꞌiai alaifa gomeisa mo alainaka, ‘Lau oi egae alalogonimi mo emai pau. Oi Deo ega iifa kaiꞌiai alopeapea aumi eeuai amokailai,’ alaoma.” ");
INSERT INTO mek_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ke Iesu eifa pugu einaka, “Ega puo papiau maꞌoai lau eꞌu iifa aꞌo kelogo ke kekapa auꞌi auga, ikifa auga fopa laagai eꞌa epaapa auga koa iꞌopoꞌi. ");
INSERT INTO mek_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Au egaꞌina ega eꞌa uuꞌuga fopai efaunia kai eꞌa epaapa. Ega puo imu eꞌau, ke kou elai, ke ameku epua ega eꞌa epuaisa mo ganinagai aepoi. ");
INSERT INTO mek_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kai papiau maꞌoai lau eꞌu iifa aꞌo kelogo kai kaiꞌiai akepea auꞌi auga, kafoꞌo auga ega eꞌa figuai epaapa auga koa iꞌopoꞌi. ");
INSERT INTO mek_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ega puo imu eꞌau, ke kou elai eꞌa eauniia, ke ameku epua eꞌa epuaisa aisama, epoi eauoka aꞌo akaikiꞌa ipauma emia.” ");
INSERT INTO mek_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesu egaꞌina kapaꞌi maꞌoai epamalele efua aisama, egae kelaꞌafou auꞌi maꞌoai isa ega pamalele eegai keopofua ke kekauai alogaina. ");
INSERT INTO mek_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Gome isa Moses ega iifa pamalelega auꞌi koa aepamalele kai, Deo ega isapu eafia auga koa epamalele. ");
INSERT INTO mek_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iesu iku mapegai eapa epamalele efua eake emai aisama, papiau laꞌafou akaikiꞌagai isa muninai kepea. ");
INSERT INTO mek_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Egaꞌina alogai au molumolu isafaga eafia auga emai Iesu agogai eanifeꞌu kai eifa einaka, “Lopia, oi lau mopafeloisau alooma koa aisama, alopafeloisau agekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ega aisama Iesu ima ekalaisa elao au faagagai eafiau kai eifa einaka, “Lau lalogo oi mapafeloiso laoma puo, felomu momia,” eoma. Ke fiakoa mo au faaga felo emia. ");
INSERT INTO mek_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ega aisama Iesu isa epainia einaka, “Foisa oi faagamuai kapaꞌina emia auga kai agaꞌo maagai foloifania. Kai opainai folao sakedote eeꞌiai faagamu fopakinaꞌi. Ke isa oi faagamu felo emia auga fekeisa, papiau fekepakinaꞌi. Ke faagamu felo emia laoga maina Moses ega iifai eifa kapula penio auga kainai, amu Deo fopaꞌa penia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Egaꞌina afegai Iesu elao Kapenaum taoninai ekoko aisama, Roma ifani auꞌi 100 eꞌimaꞌi lopiaga emai isa eegai egoinia gapalagaina eoma. ");
INSERT INTO mek_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ke eifa einaka, “Lopia, lau eꞌu kalaꞌafi faaga fofouga emae paguai ekae ekiekie alogaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ega aisama Iesu einaka, “Lau alafai alapafelo,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kai ifani lopiaga iifa epamue einaka, “Lopia, lau au eꞌeleu puo, oi fomai lau eꞌu eꞌai fokoko auga afaekaina. Foloafipugu eꞌu eꞌa folomai kai, moifa mo eꞌu kalaꞌafi felo gamia. ");
INSERT INTO mek_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gome lau ifou isafa eꞌu lopia akaikiꞌaꞌi papaꞌiai lapinauga, ke eꞌu ifani auꞌi isafa papauai kepinauga. Lau iꞌina auꞌi agaꞌo lapaina, ‘Molao’ laoma aisama, elao. Ke agaꞌo lapaina, ‘Momai,’ laoma aisama, emai. Ke eꞌu kalaꞌafi lapaina, ‘iꞌina mokapa,’ laoma aisama, ekapa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ke Iesu ifani lopiaga ega eniniꞌani oma aina elogonia aisama, ekauai alogaina, ke eꞌafoaipini papiau isa muninai kepea auꞌi epainiꞌi einaka, “Iifa gome maamiai laifania. Israel papiauꞌi epoꞌiai kai agaꞌo iina epakoꞌa omaisau auga alaisa koa. ");
INSERT INTO mek_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Lapainimi, kina fuagai papiau maꞌo kina eꞌagaukae afuga kaina, ke kina eake afuga kainai akemai Abraham, Aisak, ke Iakobo fou Deo ega agofaꞌai, miamia akaikiꞌagai afuꞌi akeafia akeagu. ");
INSERT INTO mek_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kai Israel papiauꞌi Deo ega agofaꞌa papiauꞌi auga, afegai uminagai akepiulaiꞌi, egae akeapepe nieꞌi akeapalolia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ke Iesu eniniꞌani afegai, ifani lopiaga epainia einaka, “Molao! Oi lopakoꞌania koa iꞌopoga mo ageikapa,” eoma. Ke ifani lopiaga ega kalaꞌafi egaꞌina kina maagai mo felo emia. ");
INSERT INTO mek_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Egaꞌina afegai Iesu ke ega imoi fou kelao Peto ega eꞌai ekoko. Egae Peto gafa papiega auama isafa eafiia petiai eka eisa. ");
INSERT INTO mek_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ke Iesu papie ima eafi opogaina aisama, auama isafaga isa epuaꞌafuga. Ke eꞌuegekae foꞌama egakunia epeniiꞌi keaniia. ");
INSERT INTO mek_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ke epagapigapi aisama, papiau maꞌo tiapolo aloꞌiai keagu auꞌi kemaiseiniꞌi Iesu eegai. Ke isa eifa mo tiapolo kepealai, ke isafa papiauꞌi maꞌoai epafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Iesu ega koa ekapaisa auga, Deo ega iifa pukagai profeta Aisaea iina eifa oma auga pau koꞌa mo emia: “Isa iꞌa aꞌa apoke laoꞌi maiꞌi maꞌoai eafiꞌauꞌi apuga epamia, ke aꞌa isafa epuaiꞌi.” ");
INSERT INTO mek_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Egaꞌina afegai papiau maꞌo alogaina kemai Iesu keapa lofe. Ega puo ega imoi eifa kapula peniꞌi, gaaga agaꞌo kegaisa gaaguka gapagai aꞌu apie galao eoma. ");
INSERT INTO mek_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Egaꞌina alogai Moses ega iifa pamalelega auga agaꞌo emai Iesu epainia einaka, “Pamalele aumu, oi ala folao mo ganinagai, munimuai alafai paisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ega aisama Iesu einaka, “Ago alo amuꞌeꞌi eꞌi feu afuga apu inegai ekae, ke ufa ineiꞌi isafa niiꞌi ekae. Kai Papiau Aumauni Gauga auga, kania feogeaua felaagai afuga agaꞌo laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ke Iesu ega imoi agaꞌo Iesu epainia einaka, “Lopia, mologoainiau malao amau mafufu kakaua kai alamai munimuai alapea,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kai Iesu isa epainia einaka, “Lalauꞌi emae auꞌi ifoꞌi eꞌi mae kegafufuga. Kai oi auga mai muniuai mopea,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iesu egaꞌina eifania afegai, gaagai eaguka ke ega imoi isafa gaagai keaguka. ");
INSERT INTO mek_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ke kelao alogai, fiakoa mo lanina akaikiꞌa ipauma emai egaꞌina aꞌuga mo epea oma. Ega puo goiso emai gaaga laagai eꞌafo pagainia. Kai egaꞌina alogai Iesu eka efeu. ");
INSERT INTO mek_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ega puo Iesu ega imoi kelao kepagonia kai kepainia keinaka, “Lopia, kaniaꞌa moagamauga! Iꞌa agakogo!” keoma. ");
INSERT INTO mek_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ke Iesu isa epainiꞌi einaka, “Oi pakoꞌa eꞌele ipauma aumi. Kapa puo oi ega omaniꞌi oma?” eoma. Egae kai eꞌuegekae ameku aꞌu fou efinaiꞌi, ke kapa maꞌoai keꞌolo. ");
INSERT INTO mek_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Au maꞌoai egaꞌina gaagagai keaguka auꞌi ega koa emia keisa aisama, kekauai alogaina keopofua ke kepaꞌani keinaka, “Iꞌina au kapa? Isa ameku, aꞌu mo ganinagai aina keafia,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Egaꞌina afegai kelao apiegai Kadara papiauꞌi keagu agogai keofau keꞌagaukae keagai kepea. Ega aisama au auniꞌi aloꞌiai tiapolo keagu auꞌi laai kemai Iesu fou kepiaogai. Isa keꞌeꞌefa alogaina puo kai agaꞌo ega mo aepeapea oma. ");
INSERT INTO mek_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Isa Iesu keisa aisama, tiapolo isa aloꞌiai keagu auꞌi keagaga keinaka, “Deo Gauga aumu, kapaꞌina lai eemaisai anina loani? Oi emu kina aekaina koa kai lomai lai mopakiekie alogainimai ma looma?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Egaꞌina alogai afaꞌagamo aakai koa iꞌopoga auga, uma maꞌopaꞌi kelaꞌafou keapa keanimai. ");
INSERT INTO mek_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ega puo tiapolo Iesu kegoinia keinaka, “Oi lai alopapealaimai koa aisama, foulaimai falao uma egaꞌina maꞌopaꞌi kelaꞌafou keapae auꞌi aloꞌiai fakoko,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ke Iesu isa elogoainiꞌi ke epainiꞌi einaka, “Amolao,” eoma. Ega puo tiapolo egaꞌina auꞌi auniꞌi aloꞌiai kepealai kelao uma aloꞌiai kekoko. Ke uma kekauai laꞌafouai poupouai kepiau keake kelao aꞌuai kekogo kemae. ");
INSERT INTO mek_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ke egae keapa uma keꞌimaꞌi auꞌi kepiau kelao taoniai kapaꞌina kemia auꞌi maꞌoai keifafouꞌi. Ke au aloꞌiai tiapolo keagu auꞌi isafa, faagaꞌiai kapaꞌina emia auga papiau maaꞌiai keifafoua. ");
INSERT INTO mek_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ega aisama taoni papiauꞌi maꞌoai kelao Iesu kegaisa keoma. Ke keisa aisama, kapaꞌina ekapaisa auga maniꞌina kepaꞌaua puo kegoinia eꞌi ago gapuaꞌafuga keoma. ");
INSERT INTO mek_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ega puo Iesu gaagai eaguka pugu, egaꞌina aꞌugai epagai emai ifo ega taoninai eofau. ");
INSERT INTO mek_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ega aisama au isaꞌi au agaꞌo faaga fofouga emae auga ileai eka kai kepuaisa Iesu eega kemaiseina. Ke Iesu egaꞌina auꞌi maꞌoai, ke faaga fofouga emae auga isa agepafelo auga kepakoꞌania eisa aisama, faaga fofouga emae auga epainia einaka, “Gauagai, alomu gakapula, oi emu laomai apalaꞌi laꞌagegeainiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ega aisama Moses ega iifa pamalelega auꞌi isa ifoꞌi mo epoꞌiai keifa keinaka, “Deo mo papiau eꞌi laomai apala ageꞌagegeainiꞌi. Iꞌina auga Deo eegai eifa apala!” keoma. ");
INSERT INTO mek_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ke Iesu isa kapaꞌina keopolaga auga elogo puo epainiꞌi einaka, “Kapa puo oi alomiai opola apala mo oopolaniꞌi? ");
INSERT INTO mek_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Niniꞌani auniꞌi epoꞌiai kapa auga mameꞌa foifania ooma, ‘Emu laomai apalaꞌi laꞌagegeainiꞌi,’ o ‘Moꞌue mopea?’ Oi oopolaga lau egaꞌina auga ega laomai apalaꞌi laꞌagegeainiꞌi auga agoisa afaekaina ooma puo niniꞌani mameꞌa mo laifania ooma. ");
INSERT INTO mek_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kai lau Papiau Aumauni Gauga au agofaꞌai papiau eꞌi laomai apalaꞌi faꞌagegeainiꞌi isapuga laafiia auga agoisa,” eoma. Egae kai Iesu au faaga fofouga emae auga epainia einaka, “Lau lapainio, oi lofelo efua moꞌue emu ile moafia emu eꞌa molao,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ke au egaꞌina eꞌuegekae ega ile eafiia ega eꞌa elao. ");
INSERT INTO mek_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Laꞌafou papiauꞌi iina koa emia keisa aisama kemaniꞌi alogaina. Ke Deo papiau isapu ega koa epeniiꞌi mirakulo kekapa auga au akaikiꞌa kepamia. ");
INSERT INTO mek_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Egaꞌina afegai Iesu ekailai elao alogai, tax isafina auga agaꞌo aka Mateo tax keogeoge afugai eagu epinauga eisa. Ega aisama Iesu isa epainia einaka, “Lau muniuai mopea,” eoma. Ke Mateo eꞌue Iesu muninai epea. ");
INSERT INTO mek_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Egaꞌina afegai Iesu Mateo ega eꞌai fou gapigapi foꞌamaga kegaania keoma alogai, tax keafia auꞌi maꞌo, ke tax keafia auꞌi koa iꞌopoꞌi laomai apalaꞌi kekapaꞌi auꞌi isafa maꞌo kemai Iesu ke ega imoi fou keagu keaniani. ");
INSERT INTO mek_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Faliseo auꞌi iina koa emia keisa aisama, anina akeani puo Iesu ega imoi kepaꞌani peniꞌi keinaka, “Kapa puo oi emi pamalele auga tax keafia auꞌi, ke laomai apala kekapa auꞌi fou keaniani?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iesu isa eꞌi paꞌani aꞌo elogonia puo epainiꞌi einaka, “Papiau akeisafa auꞌi toketa anina akeani kai, keisafa auꞌi mo toketa anina keani. ");
INSERT INTO mek_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ega koa iꞌopoga, lau lamai auga papiau Deo maagai aloꞌi opaina auꞌi faifaniꞌi puo alamai. Kai Deo maagai laomai apalaꞌi kekapa auꞌi faifaniꞌi, eꞌi apala fekeumakalainiꞌi Deo fekeaipenia laoma puo lamai. Ega puo folao iꞌina iifaga kapaꞌina eifania auga fomaleleaina oko fokapulaisa: ‘Lau guani anina laani kai, amu opaꞌa peniau auga aniꞌi alaani.’” ");
INSERT INTO mek_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Egaꞌina alogai Ioane ega imoi kemai Iesu kepaꞌani penia keinaka, “Ala koa iꞌopoga lai ke Faliseo auꞌi fou aani gopegope kai, oi emu imoi fou auga aloani gopegope?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ke Iesu iifa epamue einaka, “Papiau amage mamaga auga ega miamia kemai auꞌi, amage mamaga auga fou keaguega kai aloꞌi emafu gouga akekapa agekaina ma? Laaꞌi, afaekaina! Kai kina agaꞌo agemai amage mamaga auga isa eeꞌiai akeafiꞌaua aisama, egae kai isa akeani gopegope,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ke Iesu isa maaꞌiai eifa pugu einaka, “Kai agaꞌo tiapu aina mamaga aeafia, afe tiapuga ufaina ine aekaiapua. Gome isa ega koa agekapa koa aisama, tiapu mamaga egaꞌina, afe tiapuga ufaina ageꞌiꞌina, ke ine akaikiꞌa ipauma agemia. ");
INSERT INTO mek_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ega koa iꞌopoga, papiau fino mamaga afakeafia fino pute ufainagai afakepaꞌefauka. Kai isa ega koa akekapa koa aisama, fino mamaga pute ufaina efugugu puo ageauꞌiꞌina. Ke fino agefaka ke pute isafa agelifu afeꞌai. Laaꞌi, isa ega koa afakekapa kai, fino mamaga akeafia fino pute mamagai akeꞌefauka, ega koa auniꞌi kaiꞌialao akeka felo. ");
INSERT INTO mek_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iesu eniniꞌani laolao kai, Iudea papiauꞌi eꞌi laꞌafou afuga eꞌima auga agaꞌo emai Iesu agogai eanifeꞌu kai eifa einaka, “Lau gau ifiaoga pau mo emae. Kai mai alao faagagai imamu mo moogeaua kai, isa agemaunimue ageagu,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ega puo Iesu eꞌuegekae egaꞌina auga, ke ifo ega imoi isafa fou kelao. ");
INSERT INTO mek_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Egaꞌina alogai papie agaꞌo inipo 12 alogai ifamomogu isafaga eafia auga emai Iesu afe tiapuga eafi opogaina. ");
INSERT INTO mek_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Gome isa ifo mo alogai einaka, “Lau isa tiapuga mo alaafi opogaina koa aisama, felou alamia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ega aisama papie egaꞌina Iesu tiapuga eafi opogaina auga gamuga eoponia puo, eꞌafoaipini papie eisa ke epainia einaka, “Gau ifiaomu, folomaniꞌi. Oi emu pakoꞌa epafeloiso,” eoma. Ke egaꞌina kina maagai mo papie felo emia. ");
INSERT INTO mek_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ke Iesu elao Iudea papiauꞌi eꞌi laꞌafou afuga eꞌima auga ega eꞌai ekoko. Ke egae mae filikoga keipina auꞌi, ke laꞌafou akaikiꞌa aꞌoaꞌo maꞌo kekapaisa auꞌi eisaꞌi. ");
INSERT INTO mek_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ega aisama egaꞌina papiauꞌi epainiꞌi einaka, “Oi amokani. Ifiao aemae kai efeu,” eoma. Kai egaꞌina papiauꞌi ifiao emae auga kelogo puo, Iesu kepaꞌaua keaꞌalaina. ");
INSERT INTO mek_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ke laꞌafou papiauꞌi maꞌoai kepapealaiꞌi afegai aisama, Iesu ifo mo ekoko elao ifiao imagai eafi, ke ifiao emaunimue eꞌue eagu. ");
INSERT INTO mek_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iesu egaꞌina ekapaisa auga fouga egaꞌina ago fofouga epeaisa. ");
INSERT INTO mek_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iesu ifiao epamaunimue afegai, ekailai elao alogai, maakimiꞌi auꞌi auniꞌi isa muninai kemai keagaga keinaka, “Davide okogai lomai aumu, guamai moania!” keoma. ");
INSERT INTO mek_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ke Iesu elao eꞌa agaꞌo alogai ekoko aisama, isa isafa kemai egaꞌina eꞌagai, ke Iesu isa epaꞌani peniꞌi einaka, “Oi lau egaꞌina alakapa agekaina auga opakoꞌania ma?” eoma. Ke isa iifa kepamue keinaka, “E Lopia lai apakoꞌania,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ega puo isa maaꞌi eafi opogaina kai, epainiꞌi einaka, “Oi opakoꞌania koa iꞌopoga mo faagamiai gamia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ke maaꞌi felo emia afu keisa. Egae kai epaini kapulaniꞌi einaka, “Foisa, kai agaꞌo iꞌina fouga faelogo,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kai isa kelao Iesu fouga ago fofouga alogai keifafoua. ");
INSERT INTO mek_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ke Iesu eꞌai ega imoi fou kepealai alogai, papiau isa au agaꞌo akeafu tiapolo alogai eagu puo, aeniniꞌani auga isa eega kemaiseina. ");
INSERT INTO mek_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ke Iesu tiapolo epapealaisa aisama, akeafu auga egaꞌina eꞌina eniniꞌani. Laꞌafou papiauꞌi maꞌoai kapaꞌina emia keisa aisama, kekauai keopofua ke keifa keinaka, “Kapa iina koa agaꞌo Israel agogai emia alaisaisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kai Faliseo auꞌi auga Iesu eegai kepikupa puo keifa keinaka, “Isa tiapolo eꞌi lopia aka isapugai tiapolo epapealaiꞌi,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Egaꞌina afegai Iesu taoni ke pagua maꞌoai aloꞌi epeaiꞌi Iudea papiauꞌi eꞌi laꞌafou afuꞌiai ekoko epamalele. Ke iifa faunina Deo ega agofaꞌa fouga einogoaina. Egaꞌina alogai papiau isafa apala keafia auꞌi kemai eegai epafeloꞌi. Ke isafa iꞌoiꞌi iꞌoiꞌi isafa kemai epafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ke Iesu laꞌafou papiauꞌi eisaꞌi guaꞌi eani alogaina. Gome isa sipi koa iꞌopoꞌi kai iꞌimaꞌi auga agaꞌo laaꞌi keafipugu, ke kai agaꞌo isa fepalagainiꞌi auga papiauga agaꞌo laaꞌi auga eisa. ");
INSERT INTO mek_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ega aisama ega imoi epainiꞌi einaka, “Iifa faunina aꞌo fekelogo papiauꞌi maꞌo auga, laiti anina maꞌo eoge efua iꞌaina kina ekainia koa iꞌopoga, papiau maꞌo kefua keague kai pinauga auꞌi maꞌo laaꞌi. ");
INSERT INTO mek_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ega puo laiti iꞌaina Lopiaga amogoina pinauga auꞌi maꞌo gaulaiꞌi, isa ega laiti afugai kegapinauga,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Egaꞌina afegai Iesu ega imoi 12 eifa kaiguguꞌi. Ke kekaigugu aisama, tiapolo maꞌoai fekepapealaiꞌi, ke isafa apalaꞌi ke isafa iꞌoiꞌi iꞌoiꞌi keafiꞌi auꞌi fekepafeloꞌi isapuga epeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iesu ega imoi 12 akaꞌi inamoꞌe: Eufai auga Saimon, Peto keoma auga, ke akina Andru. Sebedi gauga James, ke akina Ioane. ");
INSERT INTO mek_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip ke Batolomeo. Tomas ke Mateo tax eafia auga. James Alfeus gauga ke Tadius. ");
INSERT INTO mek_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon, Silot auga, ke Judas Iskariot Iesu eꞌafaꞌafalaina auga. ");
INSERT INTO mek_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iesu iꞌina auꞌi, auꞌi 12 eulaiꞌi alogai epainiꞌi einaka, “Oi Iudea papiauꞌi laaꞌi auꞌi epoꞌiai folokoko, ke Samaria papiauꞌi isafa eꞌi taoni agaꞌogai folokoko. ");
INSERT INTO mek_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kai Israel papiauꞌi laomai apalaꞌi kekapaꞌi, sipi kegea koa iꞌopoꞌi auꞌi eeꞌi folao. ");
INSERT INTO mek_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ke agolao aisama, iꞌina iifaga foinogonia, ‘Deo ega agofaꞌa emai kainagai’ fooma. ");
INSERT INTO mek_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ke isafa papiauꞌi fopafeloꞌi, mae auꞌi fopamaunimueꞌi, molumolu isafaga keafia auꞌi faagaꞌi fopafelo, ke tiapolo papiau aloꞌiai keagu auꞌi fopapealaiꞌi. Isapu iꞌina oafi aagenia mo koa iꞌopoga, oi isafa fopipeni aage mo. ");
INSERT INTO mek_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ke emi peleta paotina alogai gold, silifa, o moni agaꞌo folouka. ");
INSERT INTO mek_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ke agolao alogai peagege aumi koa folokagakaga, feꞌa agaꞌo foloafia, tiapu eo agaꞌo foloafia, kamata isafa eo agaꞌo foloafia, ke iꞌini foloafia. Gome pinauga auga ega pinauga afa feafia paisa. ");
INSERT INTO mek_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ke taoni o pagua kapagai agokoko aisama, aufalao agaꞌo oi fou agoagu agekaina auga fokapuga foisa fou foagu. Ke egae mo foagu felao egaꞌina afuga fopuaꞌafuga. ");
INSERT INTO mek_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ke eꞌa alogai agokoko aisama, egae papiau keagu auꞌi fopakoꞌainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ke isa oi emi pamego akeafia aloꞌi agegama aisama, emi gagao egaꞌina eꞌagai feka. Kai isa oi emi pamego afakeafia aloꞌi afaegama koa aisama, emi gagao eemi femue femai pugu. ");
INSERT INTO mek_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ke kai agaꞌo afakeifa kokoimi o ainami afakelogo koa aisama, eꞌa egaꞌina o taoni egaꞌina agopuaꞌafuga aisama, keumakalainimi auga gouga fokapa ifemi aeapuga foauopuaina. ");
INSERT INTO mek_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Iifa gome maamiai laifania. Muni Deo papiau eꞌi laomai felo, o apala afa agepeniꞌi aisama, taoni ke pagua egaꞌina oi keumakalainimi auꞌi afa apala ipauma agepeniꞌi. Ke afa apala egaꞌina auga Sodom ke Komora fou papiauꞌi eꞌi laomai apala afa agepeniꞌi auga afa agekaꞌegaina. ");
INSERT INTO mek_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ke amoisa, lau oi sipi koa iꞌopomi laulaimi amuꞌe aꞌiꞌi eeꞌi olao. Ega puo oi kaapa maaga egoa felo kai epea koa iꞌopoga foikifa, ke koofi koa fomia kai agaꞌo faaga folopalifua,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Iesu ega imoi epainiꞌi pugu einaka, “Oi papiau foisa feloꞌi. Gome isa oi akeafimi kansolo imaꞌiai akepaaumi, ke eꞌi laꞌafou afuꞌiai akegapukimi. ");
INSERT INTO mek_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ke lau puouai papiau akeafimi akelaoainimi kafana, ke kin agoꞌiai iifa agopakaisa. Ega koa egae lau fou isa maaꞌiai, ke Iudea papiauꞌi laaꞌi auꞌi isafa maaꞌiai agoifafoua. ");
INSERT INTO mek_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kai oi akeafimi isa imaꞌiai akepaaumi aisama, kapaꞌina agoifania o niniꞌani ala agoifa oma auga opopo folopaꞌaua. Ega kinagai oi kapaꞌina agoifania auga Deo agepenimi agoifania. ");
INSERT INTO mek_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Gome oi ifomi afoloniniꞌani kai, Amami Deo ega Spiritu oi akemiai ageniniꞌani. ");
INSERT INTO mek_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Egaꞌina kinaꞌi aloꞌiai papiau ifoꞌi aaꞌi akiꞌi akeafiꞌi papiau iꞌoiꞌi imaꞌiai akepaauꞌi akemae. Ke ama ageoge gauga ageafia papiau iꞌoiꞌi imaꞌiai agepaaua. Ke imoi inaꞌi amaꞌi fou akeaipagai, ke inaꞌi amaꞌi akeafiꞌi akelaoainiꞌi papiau isa akeaupuguꞌi. ");
INSERT INTO mek_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ke lau akau puogai papiau maꞌoai aloꞌi koꞌagai oi animi afakeani kai, kaisau agekapula lau agepakoꞌaniau mo agelao fuagai auga kania ageisagamau. ");
INSERT INTO mek_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ke afu agaꞌogai akeafi apalanimi aisama, fopiaukoko folao afu agaꞌogai foagu. Iifa gome maamiai laifania. Oi Israel ago taoniꞌi maꞌoai aloꞌiai afolopea lau fou afoloifa afeꞌaina koa kai, lau Papiau Aumauni Gauga au alamue alamai pugu. ");
INSERT INTO mek_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ke malele imoina, ega pamalele auga aekaꞌegaina, ke pinauga auga, ega lopia aekaꞌegaina. ");
INSERT INTO mek_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kai malele imoina, ega pamalele auga koa iꞌopoga agemia, ke pinauga auga ega lopia auga koa iꞌopoga agemia agekaina koa aisama ekainia. Ega puo lau eꞌa inagome au keifaniau Belsabul, tiapolo lopiaga keomaisau koa aisama, oi lau muniuai opea kainai famili agaꞌomogai omai aumi, lau faagauai kekapa koa iꞌopoga oi faagamiai akekapa kai, oi auga akepalifu alogainimi akeifanimi Belsabul akeoma afaefuafua. ");
INSERT INTO mek_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ega puo oi egaꞌina papiauꞌi oisaꞌi folomaniꞌi. Gome kapaꞌina ogefakeai kekae auꞌi muni akepafokiꞌi. Ke kapaꞌina eifania auga maꞌoai agefoufaꞌa papiau maꞌoai akelogo. ");
INSERT INTO mek_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ke kapaꞌina uminagai maamiai laifania auga, kinai foifafoua, ke kapaꞌina ainamiai laifa kekefa mo auga, ofaofai foapa foifafoua. ");
INSERT INTO mek_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ke kaisau oi imaaumi akeaupugua kai lalaumi afakeaupugua auꞌi folomaniꞌiainiꞌi. Kai kaisau oi lalaumi ke imaaumi fou ipeliai ageꞌafolaiꞌi agolifu afeꞌai auga fomaniꞌiaina. ");
INSERT INTO mek_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Oi ologo iilo gua penimaeꞌi auniꞌiai keꞌafaꞌafalainiꞌi. Kai agaꞌomo mo ganinagai afaeꞌualai aage mo, Amaꞌa Deo agelogo kai ageꞌualai. ");
INSERT INTO mek_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ke oi kaniamiai fufu mo ganinagai pika euki auga Amami Deo epaau afeꞌaina elogo. ");
INSERT INTO mek_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ega puo folomaniꞌi, gome oi afami auga iilo maꞌo afaꞌi ekaꞌegaina. ");
INSERT INTO mek_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ke kaisau lau elogoniau auga papiau maaꞌiai koꞌa ageifania aisama, lau isafa ufai Amau Deo agogai, isa koꞌa lalogonia alaoma. ");
INSERT INTO mek_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kai kaisau papiau agoꞌiai lau agepuniaiainiau auga, lau isafa ufai Amau Deo agogai isa alapuniaiaina. ");
INSERT INTO mek_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ke oi foloopolaga lau lamai aagoai auga gagao lamaiseina folooma. Lau lamai auga gagao famaiseina puo alamai kai, ifani aꞌifaga famaiseina laoma puo lamai. ");
INSERT INTO mek_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Gome lau lamai auga lau puouai iina agemia oma: ‘Au agaꞌo ama auniꞌi akeloꞌu akepipaini, ke ifiao ina auniꞌi akeloꞌu akepipaini, ke papie gafa papiega fou akeloꞌu akepipaini. ");
INSERT INTO mek_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ega koa agemia, au agaꞌo ifo ega famili ipauma fou akeꞌou.’ ");
INSERT INTO mek_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Kaisau ina ama aniꞌi ageani alogaina kai lau aniu afaeani alogaina auga, lau eꞌu imoi agemia afaekaina. Ke kaisau gauga maguaega o papiega anina ageani alogaina kai lau aniu afaeani alogaina auga, lau eꞌu imoi agemia afaekaina. ");
INSERT INTO mek_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ke kaisau ega koloti afaepua muniuai afaepea auga, lau eꞌu imoi agemia afaekaina. ");
INSERT INTO mek_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ke kaisau ifo kania gaagamauga eoma auga ega agu agepagea. Kai kaisau lau puouai ega agu agepagea auga, ega agu mamaga agekapulaisa. ");
INSERT INTO mek_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ke kaisau oi eifa kokoimi auga lau eifa kokoisau. Ke kaisau lau eifa kokoisau auga, lau eulaisau Auga eifa koko. ");
INSERT INTO mek_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kaisau aufalao agaꞌo profeta puo eifa koko auga, profeta auga afa ala eafi oma koa iꞌopoga, isa isafa afa ega koa ageafia. Ke kaisau aufalao agaꞌo alo opaina puo eifa koko auga, alo opai auga, afa ala eafi oma koa iꞌopoga, isa isafa afa ega koa ageafia. ");
INSERT INTO mek_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ke kaisau papiau eꞌele iꞌina agaꞌo lau eꞌu imoi kainai fei kekeꞌa kaputina agepenia ageinu auga, iifa koꞌa maamiai laifania, isa afa kapa feafia auga ");
INSERT INTO mek_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesu ega imoi 12 egaꞌina iifaꞌi kapulaꞌi epeniiꞌi efua aisama, Kalilea ago taoniꞌiai gapamalele ke gainogo eoma puo, egae ekailai elao. ");
INSERT INTO mek_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Ioane Baptista tipula eꞌagai eaguega kai, Iesu kapaꞌina ekapaisa auga fouga elogo aisama, ega imoi eulaiꞌi kelao Iesu kepaꞌani penia keinaka, “Au agaꞌo agemai keoma auga oi, o aufalao agaꞌo iꞌoina ma faꞌima?” keoma ");
INSERT INTO mek_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ke Iesu isa epainiꞌi einaka, “Omue olao kapaꞌina aꞌo ologo, ke oisa auga Ioane maagai foifania. ");
INSERT INTO mek_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Isa fopaina, maakimiꞌi auꞌi afu keisa, melo auꞌi kepea, molumolu isafaga keafia auꞌi faagaꞌi felo emia, ainaꞌi efua auꞌi aꞌoaꞌo kelogo, mae auꞌi kemaunimue, ke iifa faunina ulalu papiauꞌi maaꞌiai iifafouga emia fooma. ");
INSERT INTO mek_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ke kaisau lau fauai afaeꞌualai auga, Deo eegai kapa feloꞌi eafiꞌi auga.” ");
INSERT INTO mek_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ke Ioane ega imoi kekailai kelao alogai, Iesu eꞌina Ioane fouga laꞌafou papiauꞌi maaꞌiai eifania einaka, “Kapaꞌina foisa ooma puo opealai ago maini olao? Ameku inipo epua auga amoisa ooma puo, olao ma? ");
INSERT INTO mek_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Egaꞌina laaꞌi koa aisama, kapaꞌina foisa ooma puo, olao? Au afe tiapuga feloꞌi eiꞌiukaꞌi auga foisa ooma puo olao ma? Laaꞌi, kaisau tiapu feloꞌi keiꞌiukaꞌi auꞌi, kin eaguagu eꞌagai keague. ");
INSERT INTO mek_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ega puo kapaꞌina foisa ooma puo, olao egae? Profeta agaꞌo foisa ooma puo olao ma? E, iifa gome maamiai laifania, Ioane auga profeta kai, isa auga profeta maꞌoai ekaꞌegainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Gome isa fouga Deo ega iifaga pukagai iina kepapua oma: “‘Lau eꞌu iifa ipapea auga oi agomuai alaulai kakaua, Isa oi emu keaga agepakaisa,’ keoma ");
INSERT INTO mek_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Iifa gome maamiai laifania, papiau aumauni maꞌoai papie guaꞌiai kemauni auꞌi epoꞌiai, kai agaꞌo aeꞌagaukae Ioane Baptista ega akaikiꞌa aekaꞌegaina. Ega mo ganinagai Deo ega agofaꞌai au eꞌele agaꞌo eague auga, Ioane Baptista ekaꞌegaina. ");
INSERT INTO mek_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ke Ioane Baptista Deo ega iifa eifafoua mo emai pau iꞌina kina alogai lau iifa faunina Deo ega agofaꞌa fouga papiau maaꞌiai laifafoua. Ke papiau kefaꞌiꞌi keuniaimoimo, Deo ega agofaꞌai kegakoko keoma auꞌi egaꞌina afuga keafia. ");
INSERT INTO mek_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Gome Moses ega iifa, ke profeta maꞌoai pau kapaꞌina agemia auga keifafoua mo emai Ioane Baptista miagai. ");
INSERT INTO mek_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ke oi Ioane opakoꞌania koa aisama, isa auga Elaija agemai keoma auga egamoꞌe emai. ");
INSERT INTO mek_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kaisau aina ekae auga, aina gapaau felo ainau galogo. ");
INSERT INTO mek_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Pau papiauꞌi auga kapaꞌina koa fou alaafiopoꞌi agekaina? Isa auga imoi eꞌeleꞌi afaꞌafa afugai keagu imoi iꞌoiꞌi isaꞌi kepainiꞌi iina keoma auꞌi koa iꞌopoꞌi: ");
INSERT INTO mek_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Lai oi faumiai filiko apaꞌopuania kai, oi alogefa, ke lai apepe iifina aifinia kai, oi aloapepe. ");
INSERT INTO mek_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Gome Ioane Baptista emai eani gopegope foꞌama aeania, ke fino aeinu aisama, isa keifa ‘Ioane alogai tiapolo eaguega,’ keoma. ");
INSERT INTO mek_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ke Papiau Aumauni Gauga emai eaniani ke fino einu aisama, isa keifa, ‘Amoisa, isa eaniani mogemoge, einu alogaina, ke laomai apala kekapa auꞌi, ke tax keafia auꞌi isafa ekefaꞌaꞌi emia,’ keoma. Kai aufalao agaꞌo ega laomaisai aisa, isa ikifa auga ma auga alogo.” ");
INSERT INTO mek_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Egae kai Iesu taoni kapaꞌi aloꞌiai ega mirakulo maꞌo ekapaiꞌi auꞌi, eꞌi laomai apalaꞌi akeumakalainiꞌi puo, eꞌina efinaiꞌi einaka: ");
INSERT INTO mek_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Korasin ke Betsaida taonina papiaumi, oi agomiai mirakulo maꞌo lakapaiꞌi oisaꞌi kai alopakoꞌaniau puo, Deo eegai afa apala ipauma agoafia! Kai oi agomiai mirakulo lakapaiꞌi auꞌi Taire ke Sidoni taoniꞌiai makapaꞌi koa aisama, egaꞌina papiauꞌi eꞌi laomai apalaꞌi kekapaꞌi auga fiakoa mo ofuofu tiapuꞌi fekeiꞌiukaꞌi, ke agafa fekeafia faagaꞌi fekeꞌafa. Ke pau laaꞌi eꞌi laomai apalaꞌi fekeumakalainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kai maamiai laifa gomeisamo. Oi Korasin ke Betsaida taoniꞌi papiaumi, kina fuagai Deo papiau eꞌi laomai felo o apalaꞌi afa agepeniꞌi aisama, Taire ke Sidoni taoniꞌi papiauꞌi eꞌi laomai apalaꞌi afa eꞌele mo akeafia kai, oi auga emi laomai apalaꞌi afa akaikiꞌa ipauma agoafia. ");
INSERT INTO mek_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ke oi Kapenaum taonina papiaumi, oi oopolaga akami akaikiꞌa puo ageafiakaemi ufai ma ooma? Laaꞌi, oi auga agoake ipeli papa ipauma agolao. Gome oi agomiai mirakulo lakapaꞌi auꞌi Sodom taoninai makapaꞌi koa aisama, isa eꞌi laomai apalaꞌi fekeumakalainiꞌi Deo fekeaipenia puo, ala agaꞌo fakeoma, eꞌi taoniai fekeagu mo femai pau kina. ");
INSERT INTO mek_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kai iifa gome maamiai laifania, oi Kapenaum taonina papiaumi, kina fuagai Deo papiau eꞌi laomai felo, o apala afa agepeniꞌi aisama, oi afa apala ipauma agepenimi. Ke afa apala egaꞌina auga Sodom, ke Komora fou papiauꞌi eꞌi laomai apala afa agepeniꞌi auga agekaꞌegaina.” ");
INSERT INTO mek_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Egae kai Iesu eifa einaka, “O Amau, aagoa ufa fou Lopiaga Aumu, tenkiu lapenio. Gome oi kapa maꞌoai lau laifaniꞌi, ke lakapaiꞌi auꞌi ikifa auꞌi, ke malele auꞌi fou eeꞌiai loogefakeꞌi. Kai papiau imoi eꞌeleꞌi koa iꞌopoꞌi ikifa, ke malele maꞌo laaꞌi auꞌi eeꞌiai lopaofakaea. ");
INSERT INTO mek_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","E, Amau, gome egaꞌina auga oi alomu epagama alogaina kainai ega koa emia. ");
INSERT INTO mek_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Lau Amau kapa maꞌoai lau imauai epaaua. Ke kai agaꞌo Gauga aelogonia kai Ama auga mo Gauga elogonia. Ke kai agaꞌo Ama aelogonia kai, Gauga auga mo Ama elogonia. Ke Gauga Ama kaisau fepakinaꞌi eoma auꞌi mo, Ama kaisau auga epalogoniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ke oi maꞌoai emi aguai oafipugu alogaina aumi, ke emi aguai meau akaikiꞌa faagamiai kekae aumi lau eeu fomai. Ke lau oi laagai alapenimi. ");
INSERT INTO mek_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Lau alou gagafe, ke lau ifou eꞌeleu lapamiaisau puo, lau fou alao alogai eeuai fomalele. Ke oi lau eeuai lalaumi ega laagai afuga agokapulaisa. ");
INSERT INTO mek_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Gome oi lau fou kaiꞌalao amia auga emameꞌa, ke eꞌu iifa laifaniꞌi kaiꞌiai fopea laoma meauga auga eꞌilikae,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Egaꞌina afegai Iudea papiauꞌi Deo keau afagaina kinagai, Iesu ega imoi fou palafa kefauga agogai peapea afugai kepea pagai. Egaꞌina alogai Iesu ega imoi inaeꞌi ekimu puo, palafa puaga isa auꞌaagai kefaipoga keaniia. ");
INSERT INTO mek_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Faliseo auꞌi Iesu ega imoi ega kekapa oma keisaꞌi aisama, Iesu kepainia keinaka, “Moisa! Oi emu imoi Deo aau afagaina kinagai lai emai kagakaga kainai keifa apua auga kekapa,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ega aisama isa iifa epamue einaka, “Ufainagai Davide ega au fou inaeꞌi ekimu aisama, kapaꞌina ekapaisa auga fouga Deo ega iifa pukagai alokuapina ma? ");
INSERT INTO mek_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Isa Deo ega eꞌai ekoko, ke palafa Deo kepalao penia, Moses ega iifa kainai keifa apua isa fakeania kai, sakedote mo fekeania keoma auga eafiia ega au fou keaniia. ");
INSERT INTO mek_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ke Moses ega iifa kainai Deo isau afagaina kinagai pinauga laaꞌi eoma kai, sakedote Deo ega eꞌa alogai kepinauga amu Deo kepaꞌa penia aisama, egaꞌina iifaga keaupea mo ganinagai, isa laomai apala akekapaisa auga fouga Deo ega iifa pukagai alokuapina ma? ");
INSERT INTO mek_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Lau lapainimi. Pau au agaꞌo Deo ega eꞌa ekaꞌegaina auga emai efua. Lau auga isa. ");
INSERT INTO mek_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ke oi iꞌina iifaga, ‘Lau guani anina laani kai amu opaꞌa peniau auga aniꞌi alaani,’ auga kapaꞌina eifania auga oko amologo koa aisama, papiau kapa apala agaꞌo akekapa auga, eꞌi laomai apala afa fekeafia auga foloifania. ");
INSERT INTO mek_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gome Papiau Aumauni Gauga auga Deo isau afagaina kina Lopiaga auga.” ");
INSERT INTO mek_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesu egaꞌina afuga epuaꞌafuga aisama, elao Iudea papiauꞌi eꞌi laꞌafou afugai ekoko. ");
INSERT INTO mek_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Egae au agaꞌo ima emelo auga eagu. Faliseo auꞌi keaga agaꞌo kekapunia Iesu kegapaagu fofoua keoma puo, kepaꞌani penia keinaka, “Deo isau afagaina kinagai, papiau aufalao agaꞌo kepafelo auga ekainia ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ke Iesu isa epainiꞌi einaka, “Deo isau afagaina kinagai oi emi sipi agaꞌo ipuai afeꞌualai koa aisama, afololao afololaꞌaua ma? ");
INSERT INTO mek_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Papiau aumauni auga kapa akaikiꞌa ipauma sipi ekaꞌegaina. Ega puo Deo isau afagaina kinaꞌiai papiau felo kekapa auga ekainia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Egae kai ima emelo auga epainia einaka, “Imamu mokalaisa,” eoma. Ke au ima ekalaisa aisama, ima felo ipauma ima apie koa iꞌopoga emia. ");
INSERT INTO mek_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kai Faliseo auꞌi kepealai kelao Iesu ala fekeaupugu oma auga iifaga kepaapa. ");
INSERT INTO mek_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iesu Faliseo auꞌi kapaꞌina fekekapa keoma auga elogo puo, egaꞌina afuga epuaꞌafuga ekailai elao. Egaꞌina alogai papiau maꞌo isa muninai kepea, ke keisafa auꞌi maꞌoai epafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kai ainaꞌi epalogo isa kaisau auga fakeifafoua eoma. ");
INSERT INTO mek_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iesu ega ekapa oma auga, Deo ega iifa pukagai profeta Aisaea eifafoua auga koꞌa mo femia eoma: ");
INSERT INTO mek_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Amoisa! Lau eꞌu pinauga auga lakinaga auga inamoꞌe, Lau alou koꞌagai isa anina laani, ke eegai alou egama alogaina. Lau eꞌu Spiritu isa alapenia, ke isa agofaꞌa papiauꞌi eꞌi laomai felo, o apala auga fouga maaꞌiai ageifafoua. ");
INSERT INTO mek_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Isa afaeloꞌu, o afaeagagapea, ke kai agaꞌo peapea afuꞌiai isa aina afaelogo. ");
INSERT INTO mek_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Isa papiau inipo keuki lilifu koa iꞌopoꞌi auꞌi afaefaiponiꞌi. Ke papiau imaauꞌiai, ke lalauꞌiai keapoke lanepa uikina efua lanepa agealo koa iꞌopoga auꞌi, lanepa koa afaeipialoꞌi agelao papiau maꞌoai eꞌi laomai afa agepeniꞌi ke kapa maꞌoai agepalutiniꞌi kinagai kai. ");
INSERT INTO mek_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ke agofaꞌa papiauꞌi eꞌi afiaꞌama isa aka eegai akeoge.” ");
INSERT INTO mek_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Egaꞌina afegai papiau au agaꞌo tiapolo ake epaafua, ke maaga epakimiꞌinia auga Iesu eega kemaiseina. Ke Iesu isa epafelo ega koa eniniꞌani, ke afu isafa eisa. ");
INSERT INTO mek_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ega aisama papiau maꞌoai kekauai alogaina keifa keinaka, “Davide okogai agemai keoma auga inamoꞌe maꞌe afemia?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kai Faliseo auꞌi papiau ega keifa oma ainaꞌi kelogonia aisama, keifa keinaka, “Isa tiapolo eꞌi lopia Belsabul mo aka isapugai tiapolo epapealaiꞌi,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Iesu isa kapaꞌina keifania, ke opoꞌiai kapaꞌina emai auga elogo puo epainiꞌi einaka, “Agofaꞌa agaꞌo ifo ageaupea koa aisama, agelifu afeꞌai. Ke taoni agaꞌo papiauꞌi ifoꞌi mo akeaupeaꞌi koa aisama, taoni egaꞌina ageapa afaekaina. Ke eꞌa agaꞌogai famili ifoꞌi mo akeaupeaꞌi koa aisama, eꞌa egaꞌina isafa ageapa afaekaina. ");
INSERT INTO mek_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ega koa iꞌopoga, Satani ageoge Satani mo agepapealaisa koa aisama, isa ifo eaupea. Ega puo ala koa iꞌopoga isa ega agofaꞌa ageapa? ");
INSERT INTO mek_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ke lau Belsabul aka isapugai tiapolo lapapealaiꞌi koa aisama, oi emi papiau auga kaisau aka isapugai tiapolo kepapealaiꞌi? Ega puo isa oi kapaꞌina oifania auga koꞌa o pifoge auga akeifafoua. ");
INSERT INTO mek_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kai lau Deo ega Spiritu ega isapuai tiapolo lapapealaiꞌi koa aisama, Deo ega agofaꞌa emai oi eemiai efua. ");
INSERT INTO mek_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ke lau lapaꞌani pugu. Aufalao agaꞌo au kapula agaꞌo afaegope kakaua koa aisama, ala koa iꞌopoga ega eꞌai agekoko ega amu ageafiꞌi agekaina? Isa agegope kakaua kai, ega eꞌai agekoko ega amu agepainaoniꞌi agekaina. ");
INSERT INTO mek_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Kaisau lau afeuai aeaulao auga, lau fou laaꞌi, ke kaisau lau fou papiau alapakai guguainiꞌi auga, papiau epakaniniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ega puo maamiai laifa gomeisamo. Laomai apalaꞌi maꞌoai ke Deo eegai keifa apala auꞌi eꞌi apala Deo ageꞌagegeainiꞌi. Kai kaisau Deo ega Spiritu eegai keifa apala auꞌi, eꞌi apala Deo afaeꞌagegeainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ke kaisau Papiau Aumauni Gauga eegai iifa apala agaꞌo ageifania auga, Deo isa ega apala ageꞌagegeaina. Kai kaisau Deo ega Spiritu eegai iifa apala agaꞌo ageifania auga, Deo isa ega apala iꞌina agofaꞌagai, pau o muni ganinagai afaeꞌagegeaina.” ");
INSERT INTO mek_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ke Iesu eifa pugu einaka, “Au agaꞌo felo, o apala auga puagai kekapulaisa. Ega puo au agaꞌo felo agopamia aisama, puaga felo ageoge, o au agaꞌo apala agopamia aisama, puaga apala ageoge. ");
INSERT INTO mek_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Oi ikifa aumi, kaapa apala ipauma auga gauga koa iꞌopomi. Oi laomai apala ikapa aumi puo, ala koa kapa felo agaꞌo agoifania agekaina? Gome kapaꞌina papiau guaꞌi alo epogu auga, akeꞌiai epealai keifania. ");
INSERT INTO mek_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ega koa iꞌopoga, au felo auga, gua alogai kapa feloꞌi alogai eogeꞌi keka auꞌi, feloꞌi akegai kepealai eifaniꞌi. Kai au apala auga, gua alogai kapa apalaꞌi eogeꞌi keka auꞌi, apalaꞌi mo akegai kepealai eifaniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kai lapainimi. Kina fuagai Deo papiau eꞌi laomai felo, o apala afa agepeniꞌi aisama, papiau eꞌi niniꞌaniai keniniꞌani aage mo mo ganinagai, kapa maꞌoai kapa puo keifaniꞌi auꞌi Deo maagai akeifafoua. ");
INSERT INTO mek_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gome Deo oi emi iifai afa felo agepenimi, ke ifomi emi iifai afa apala agoafia.” ");
INSERT INTO mek_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Egaꞌina afegai Faliseo auꞌi ke Moses ega iifa pamalelega auꞌi isaꞌi Iesu kepaꞌani penia keinaka, “Pamalele aumu, lai anina aani oi eemuai mirakulo gouga agaꞌo amaisa aoma,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kai Iesu einaka, “Papiau apalaꞌi ipaumaꞌi Deo kapaꞌina eifania akepakoꞌania ke kainai akepea puo, eꞌi laomaisai amage auꞌi kai papie iꞌoiꞌi fou kefeu auꞌi koa iꞌopoꞌi auꞌi, mirakulo gouga agaꞌo gaikapa auga paꞌanina kepaꞌani. Kai mirakulo gouga agaꞌo afalakapa kai, profeta Jona faagagai kapaꞌina emia auga mo gouga agemia. ");
INSERT INTO mek_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Gome ufainagai Jona kina oiso ke gapi oiso maꞌa akaikiꞌa gua alogai eka koa iꞌopoga, Papiau Aumauni Gauga kina oiso ke gapi oiso aꞌisa alogai ageka. ");
INSERT INTO mek_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninife taonina papiauꞌi Jona einogo aina kelogonia aisama, eꞌi laomai apalaꞌi keumakalainiꞌi. Kai pau Jona ekaꞌegaina auga emai einogonimi ganinagai alopakoꞌania. Ega puo muni Deo papiau eꞌi laomai felo, o apala afa agepeniꞌi aisama, Ninife taonina papiauꞌi akeꞌue akeifa, pau papiaumi afa apala amoafia akeoma. ");
INSERT INTO mek_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ke South kuinina isafa aaka ipaumagai mo ganinagai, emai Solomon ega ikifa aꞌo elogonia. Kai pau Solomon ega ikifa ekaꞌegaina auga emai efua kai oi isa aina alologo. Ega puo muni Deo papiau eꞌi laomai felo, o apala afa agepeniꞌi aisama, South kuinina egaꞌina isafa ageꞌue ageifa, pau papiaumi afa apala amoafia ageoma.” ");
INSERT INTO mek_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ke Iesu eifa pugu einaka, “Tiapolo apala agaꞌo au agaꞌo alogai epealai aisama, elao afu eogogo afugai elao emai laagai afuga ekapuga kai aeisa. ");
INSERT INTO mek_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ega aisama ifo alogai einaka, ‘Lau eꞌa lapuaꞌafuga auga eꞌa alamue alalao pugu,’ eoma. Ke elao egaꞌina eꞌagai aisama, kai agaꞌo egaꞌina eꞌagai laaꞌi kai, eꞌa egaꞌina keꞌamunia alo felo, ke amu maꞌoai mo kepakokopai eisa. ");
INSERT INTO mek_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ega aisama elao tiapolo iꞌoiꞌi auꞌi imagea gua, isa ega apala kekaꞌegaina auꞌi emaiseiniꞌi fou kelao egaꞌina eꞌagai kekoko keagu. Ke fuagai aisama, au egaꞌina ega agu elifu alogaina, ufainagai ala eagu oma auga aguga ekaꞌegaina. Pau iꞌina papiaumi apalami ipaumami aumi, ega koa iꞌopoga mo faagamiai agemia.” ");
INSERT INTO mek_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesu laꞌafou papiauꞌi maaꞌiai eniniꞌani laolao kai, isa ina ke akina fou kemai afegai keapa fou keganiniꞌani keoma. ");
INSERT INTO mek_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ega aisama laꞌafouai aufalao agaꞌo Iesu epainia einaka, “Oi inamu ke akimu fou kemai afegai kepae fou amoniniꞌani keoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ke Iesu isa ega iifa epamue einaka, “Kaisau lau inau, ke kaisau lau akiu?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Egae kai ega imoi auꞌi epaꞌaniniꞌi kai eifa einaka, “Iꞌina auꞌi lau inau, ke akiu. ");
INSERT INTO mek_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Gome kaisau lau Amau ufai eague Auga ega logoai mo kapa maꞌoai kekapaꞌi auꞌi, lau inau, ke akiu, ke afakuau,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Egaꞌina kinagai mo, Iesu eꞌai epealai elao aꞌu niegai eagu. ");
INSERT INTO mek_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ega aisama laꞌafou akaikiꞌa ipauma kemai keapa lofe puo, elao gaagai eaguka kai papiau maꞌoai auga foeai mo keapa. ");
INSERT INTO mek_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Egae kai kapa maꞌo palapoleai papiau maaꞌiai eifania einaka, “Au oga efauga auga agaꞌo, au ogaꞌi gafauniꞌi eoma puo, epealai elao ega umai. ");
INSERT INTO mek_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ke au ogaꞌi eꞌafokaꞌi alogai, isaꞌi paisoai peapea afugai keꞌualai, ke inei keake keaniiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ke isaꞌi fopa laagai aꞌisa afaꞌagamo mo eka auga laagai keꞌualai. Ke aꞌisa afaꞌagamo puo keꞌomo kefiaisakoa mo. ");
INSERT INTO mek_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kai kina eꞌagau egagaiꞌi aisama, gagamuꞌi laaꞌi puo gagauꞌi kekala kemae. ");
INSERT INTO mek_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ke au oga isaꞌi auꞌi ini mogogo aloꞌiai keꞌualai, ke keuki kai ini mogogo keuki keꞌagau keafipuguꞌi. ");
INSERT INTO mek_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kai isaꞌi auꞌi aꞌisa felogai keꞌualai. Ke egaꞌina auꞌi keuki keꞌagau kepua, aniꞌi keoge felo alogaina. Ke aniꞌi keogeiꞌi auga, au oga agaꞌomo alogai anina 100, 60, o 30 eogeiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kaisau aina ekae auga, aina gapaaua kapaꞌina laifania auga aꞌo galogo,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Egae kai Iesu ega imoi kemai kepaꞌani penia keinaka, “Kapa puo papiau maaꞌiai Deo ega iifa loifania aisama palapoleai loniniꞌani?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ega aisama Iesu einaka, “Deo ega agofaꞌa logo fouga ogefake auga oi epeniimi efua kai isa aepeniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Lau ega laifa oma, gome kaisau eegai amu kekae auꞌi, Deo isa maꞌo agepenia amu agealogai alogaina eegai akeka. Ke kaisau eegai amu oisomo mo kekae auꞌi, oisomo mo eegai kekae auꞌi mo ganinagai, Deo egaꞌina amuꞌi isa ageafania. ");
INSERT INTO mek_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Lau iꞌina iifaga kainai papiau maaꞌiai palapoleai Deo ega iifa laifania: “Isa maaꞌiai keisa mo ganinagai, akeisa koa iꞌopoga. Ke aꞌo kelogo mo ganinagai, aꞌo akelogo koa iꞌopoga, ke kapaꞌina eifania auga isafa oko akelogo. ");
INSERT INTO mek_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Isa faagaꞌiai ega koa emia auga, profeta Aisaea Deo ega iifa pukagai iina epapua oma auga koꞌa mo emia: ‘Oi aufa kina mo Deo ega iifa aꞌo agologo kai, kapaꞌina eifania auga oko afolologo. Oi aufa kina kapaꞌina emia auga agoisa kai, kapaꞌina emia auga oko afolologo. ");
INSERT INTO mek_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Gome iꞌina papiauꞌi guaꞌinoka auꞌi. Isa ainapaauai auga, ainaꞌi efua koa iꞌopoga, ke maaꞌi kepafufua. Kai ega koa fakekapa koa aisama, isa kapaꞌina emia auga maaꞌiai fekeisa, ke kapaꞌina keifania auga ainaꞌiai aꞌo fekelogo. Ke kapaꞌina eifania auga guaꞌiai oko fekelogo, ke eꞌi laomai apalaꞌi fekemuniꞌi, ke lau isa fapaponiꞌi papiau feloꞌi fapamiaꞌi.’ ");
INSERT INTO mek_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Kai oi auga, pau maamiai lau kapaꞌina lakapa auga oisa, ke kapaꞌina laifaniꞌi auꞌi ainamiai aꞌo ologo. Ega puo oi maami ke ainami fou Deo eegai kapa feloꞌi keafiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Gome iifa gome mo maamiai laifania. Profeta maꞌo ke alo opai auꞌi maꞌo isafa oi pau kapaꞌina oisa auga alafai kegaoma kegaisa keoma kai akeisa. Ke kapaꞌina pau aꞌo ologo auga aꞌo kegalogo keoma kai aꞌo akelogonia. ");
INSERT INTO mek_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ega puo pau ainami fopaaua, au ega umai au ogaꞌi efauniꞌi auga palapole kapaꞌina eifania auga oko alapakaisa ainau fologo. ");
INSERT INTO mek_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Aufalao agaꞌo Deo ega agofaꞌa fouga aꞌo elogonia kai egaꞌina iifaga kapaꞌina eifania auga oko aelogo. Ega aisama tiapolo emai egaꞌina iifaga au oga koa iꞌopoga gua alogai kefauga auga eafilaisa. Egaꞌina auga au oga uma alogai peapea afugai keꞌualai auꞌi. ");
INSERT INTO mek_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kai au ogaꞌi kepo laagai aꞌisa afaꞌagamo eka auga laagai keꞌualai auꞌi auga, aufalao agaꞌo Deo ega iifa aꞌo elogo ke alogamai eafia auga. ");
INSERT INTO mek_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kai isa Deo ega iifa au oga koa alogai efauga auga gagamuga aeoge puo, Deo ega iifa alogai eka epo aemaefa. Gome isa Deo ega iifa kainai kina apalaꞌi eafiꞌi, o papiau isa keafi apalania aisama, eapoke eꞌualai. ");
INSERT INTO mek_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ke au ogaꞌi ini mogogo alogai keꞌualai auꞌi auga, aufalao agaꞌo Deo ega iifa aꞌo elogo eafia. Kai isa agu felo opopo, ke iꞌina agofaꞌa amuꞌiai gapaꞌamuꞌamu eoma auga isa kefoge, ke egaꞌina kapaꞌi Deo ega iifa au oga koa isa alogai euki auga eafipugua anina agaꞌo aeoge. ");
INSERT INTO mek_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kai au ogaꞌi aꞌisa felogai keꞌualai auꞌi auga, aufalao agaꞌo Deo ega iifa aꞌo elogo, ke Deo ega iifa kapaꞌina eifania auga isafa oko elogo. Isa Deo ega iifa au oga koa iꞌopoga auga alogai euki, epua felo alogaina, au oga agaꞌomo alogai anina 100, 60, o 30 eoge. ");
INSERT INTO mek_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ke Iesu palapole iꞌoina agaꞌo laꞌafou papiauꞌi maaꞌiai eifania pugu einaka, “Deo ega agofaꞌa auga, au agaꞌo laiti anina feloꞌi eafiꞌi ega agoai efauniꞌi auga koa iꞌopoga. ");
INSERT INTO mek_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kai gapiai papiau kefeufeu kai, isa ega ou auga afa apala puaꞌi eafiiꞌi emai ega laiti egaꞌina epoꞌiai efauniꞌi kai ekailai elao. ");
INSERT INTO mek_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pau laiti afa apala egaꞌina fou keuki agaꞌomo kelao laiti eꞌina eꞌafoisa aisama, afa egaꞌina isafa kefokilai. ");
INSERT INTO mek_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Ega aisama ago inagome auga ega pinauga auꞌi isa eega kemai kepainia einaka, ‘Au akaikiꞌa aumu, oi laiti anina felo emu agoai lofaunia kai, afa apalaꞌi auꞌi kapai kemai egae keuki?’ keoma. ");
INSERT INTO mek_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Isa einaka, ‘Lau eꞌu ou auga iina koa ekapaisa,’ eoma. “Ega aisama pinauga auꞌi au akaikiꞌa kepaꞌani penia keinaka, ‘Oi anina loani lai falao afa apalaꞌi egaꞌina fafuauꞌi ma looma?’ keoma. ");
INSERT INTO mek_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Kai au akaikiꞌa einaka, ‘Laaꞌi, gome oi afa apalaꞌi agofuauꞌi alogai laiti isafa afofuauꞌi. ");
INSERT INTO mek_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Amopuaꞌafuniꞌi fou kaiꞌialao kegauki galao laiti iꞌaina kinagai kai. Egaꞌina kinagai laiti iꞌaina papiauꞌi alapainiꞌi, ‘Afa apalaꞌi amopakai guguai kakauꞌi amoꞌofaꞌi ega koa loai feiuma. Egae kai laiti mo amopakai guguaina amomaiseiniꞌi eꞌa akaikiꞌa foꞌama keogeoge afugai amooge alaoma,’” eoma. ");
INSERT INTO mek_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ke Iesu palapole iꞌoina agaꞌo laꞌafou papiauꞌi maaꞌiai eifania einaka, “Deo ega agofaꞌa auga, au aka mastad oga aufalao agaꞌo eafiia ega agoai efauga auga koa iꞌopoga. ");
INSERT INTO mek_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Au maꞌoai ogaꞌi epoꞌiai mastad oga auga eꞌele ipauma mo ganinagai, euki aisama, au akaikiꞌa emia, uma alo aupu gagauꞌi auꞌi maꞌoai ekaꞌegainiꞌi, ega koa ufa ineiꞌi kemai agagai keiꞌoau,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ke Iesu palapole iꞌoina agaꞌo laꞌafou papiauꞌi maaꞌiai eifania pugu einaka, “Deo ega agofaꞌa auga, papie agaꞌo palafa ipaufuga mulamula eafia palafa maꞌo fou eoge lapuinia kai, fei eꞌefa efiuga kai epuaꞌafuga eka, ke mulamula egaꞌina palafa fofouga alogai epinauga palafa egaꞌina epaufua auga koa iꞌopoga,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesu Deo ega agofaꞌa fouga laꞌafou papiauꞌi maaꞌiai palapoleai mo eifania. Ke kapa agaꞌo aeifa ofakaea kai maꞌoai palapoleai moaꞌina eifaniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Iesu ega koa ekapaisa ega koa profeta Deo ega iifa pukagai iina kepapua oma auga koꞌa mo emia: “Lau akeu alapaagalaisa palapoleai alaniniꞌani, lau agofaꞌa egama mo alogai kapa maꞌoai kekafake auꞌi alaifafouꞌi.” ");
INSERT INTO mek_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iesu palapole laꞌafou papiau maaꞌiai eifania efua aisama, epuaꞌafuniꞌi elao eꞌa alogai ekoko. Ke ega imoi auꞌi kemai isa kepainia keinaka, “Afa apalaꞌi agoai keuki auga palapole kapaꞌina eifania auga maamaisai oko mopakaisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ke isa einaka, “Au laiti anina felo efauga auga Papiau Aumauni Gauga. ");
INSERT INTO mek_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ke agoai laiti efauga auga, iꞌina agofaꞌa. Ke laiti anina felo auꞌi Deo gauga, Deo ega agofaꞌai akekoko auꞌi. Ke afa apalaꞌi auga laomai apala inagome auga gauga auꞌi. ");
INSERT INTO mek_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ke ou auga afa apalaꞌi efauniꞌi auga tiapolo. Ke laiti iꞌaina kina ekaina auga, kina fua fouga eifania, ke laiti iꞌaina papiauꞌi auga agelo. ");
INSERT INTO mek_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Ke afa apalaꞌi kefuauꞌi loai keumaꞌi koa iꞌopoga, kina fuagai isafa ega koa agemia. ");
INSERT INTO mek_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ega kinagai Papiau Aumauni Gauga, ega agelo ageulaiꞌi akelao, isa ega agofaꞌai papiau laomai apalaꞌi kepagamaꞌi auꞌi, ke laomai apalaꞌi kekapa afa apalaꞌi koa iꞌopoꞌi kemia auꞌi akefuauꞌi. ");
INSERT INTO mek_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Egae kai akeafiꞌi lo eufa emoge auga alogai akeꞌafo kokoꞌi, egae akeapepe nieꞌi akeapalolia. ");
INSERT INTO mek_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ega aisama papiau kapaꞌi Deo maagai aloꞌi opaina auꞌi, isa Amaꞌi ega agofaꞌai akeagu, kina eaga eaea koa iꞌopoga, isa isafa akeaga ega akeeaea oma. Kaisau aina ekae auga aina gapaaua ainau galogo,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ke Iesu eifa pugu einaka, “Deo ega agofaꞌa auga, kapa agaꞌo afa akaikiꞌa agoai keogefake auga koa iꞌopoga. Ke au agaꞌo egaꞌina kapa afa akaikiꞌa auga ekapulaisa aisama, eafiia eogefake pugu. Egae kai ekailai elao alogamai ega amu maꞌoai eꞌafaꞌafalainiꞌi kai, monina eafiia emue emai egaꞌina ago eꞌafaisa. ");
INSERT INTO mek_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ke Deo ega agofaꞌa auga, afaꞌafa auga agaꞌo ouꞌou felo ipauma ekapuga gaꞌafa eoma auga koa iꞌopoga. ");
INSERT INTO mek_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ke isa ouꞌou felo ipauma agaꞌo afa akaikiꞌa auga ekapulaisa aisama, elao ega amu maꞌoai eꞌafaꞌafalainiꞌi monina eafiia emai egaꞌina ouꞌouga eꞌafaisa.” ");
INSERT INTO mek_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ke Iesu palapole iꞌoina agaꞌo eifania pugu einaka, “Deo ega agofaꞌa auga, inoino auꞌi feꞌi aꞌuai keoge maꞌa iꞌoina iꞌoina kemai keofa auga koa iꞌopoga. ");
INSERT INTO mek_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ke feꞌi ake epogu aisama, inoino auꞌi feꞌi kelaꞌaua foeai. Egae kai keagukipo maꞌa feloꞌi auꞌi keafiiꞌi kepakai guguainiꞌi aleꞌa alogai keukaiꞌi kai, apalaꞌi auꞌi kepuakeꞌi. ");
INSERT INTO mek_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kina fuagai isafa ega koa iꞌopoga agemia. Ega kinagai agelo akemai papiau aloꞌi opaina auꞌi, ke papiau apalaꞌi auꞌi fou akeꞌeaꞌi. ");
INSERT INTO mek_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Egae kai papiau apalaꞌi auꞌi lo eufa emoge auga alogai akeꞌafo kokoꞌi, egae akeapepe nieꞌi akeapalolia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iesu egaꞌina palapoleꞌi maꞌoai eifaniꞌi afegai, ega imoi epaꞌani peniꞌi einaka, “Egaꞌina kapaꞌi kapaꞌina keifania auga okoꞌi ologo afeꞌai ma?” eoma. Ke isa keinaka, “E, okoꞌi alogo,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ega aisama epainiꞌi einaka, “Ega puo Moses ega iifa pamalelega auꞌi maꞌoai Deo ega agofaꞌa fouga aꞌo kelogo auꞌi auga, eꞌa inagome auga ega amu isoge eꞌa alogai amu afaꞌi akaikiꞌaꞌi auꞌi, mamaꞌi ke ufaiꞌi isafa fou eafilaiꞌi ofakaegai eogeꞌi auga koa iꞌopoꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesu egaꞌina palapoleꞌi maꞌoai eifaniꞌi efua aisama, afu egaꞌina epuaꞌafuga ekailai elao. ");
INSERT INTO mek_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ke emai Nasareta, isa ifo ega taoniai aisama, egae laꞌafou afugai eꞌina papiau epamaleleniꞌi. Ke papiau isa ega pamalele aꞌo kelogonia, ke kekauai alogaina kepaꞌani keinaka, “Iꞌina auga iꞌina ikifaga ke mirakulo isapuꞌi kapai eafiiꞌi? ");
INSERT INTO mek_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Isa eꞌa ipaapa auga gauga laaꞌi ma? Ke isa ina aka Maria laaꞌi, ke akina James, Joseph, Saimon ke Judas laaꞌi ma? ");
INSERT INTO mek_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ke isa afakua maꞌoai iꞌa fou inae alaagu ma? Iifa gome isa egaꞌina auga paisa. Ega puo iꞌina auga egaꞌina kapaꞌi maꞌoai kapai eafiiꞌi?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ke egaꞌina papiauꞌi Iesu keumakalaina. Kai Iesu isa epainiꞌi einaka, “Profeta agaꞌo ifo ega taoniai, ifo ega papiau auꞌi mo isa au akaikiꞌa afakepamia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ke papiau isa akepakoꞌania kainai, egae mirakulo maꞌo aekapaiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Egaꞌina alogai kin Herod Kalilea ago eꞌima lopiaga Iesu fouga elogo. ");
INSERT INTO mek_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ke ega pinauga auꞌi epainiꞌi einaka, “Iꞌina auga Ioane Baptista maeai emaunimue. Ega kainai mirakulo isapuꞌi isa faagagai kepinauga,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herod ega eifa oma, gome isa Iesu fouga aelogo koa kai, isa ifo akina Filip akafa Herodias eakafania puogai Ioane Baptista eafiia egopeisa tipulai epaagua. ");
INSERT INTO mek_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Gome Ioane Baptista isa epainia einaka, “Oi ifomu akimu akafa loakafania auga keifa apua kai lokapaisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ioane tipulai eagu alogai, Herod isa gaaupugua eoma kai papiau emaniꞌiainiꞌi, gome papiau Ioane profeta keomaisa. ");
INSERT INTO mek_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kai Herod ega mauni kina miamiaga ekapaisa aisama, Herodias gauga ifiaoga emai isa maꞌoai agoꞌiai egefa, ke Herod alo epagama alogaina. ");
INSERT INTO mek_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ega kainai Herod ifiao egaꞌina maagai epakoꞌania eifa, kapaꞌina mo agegoina auga agepenia eoma. ");
INSERT INTO mek_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ke ifiao egaꞌina, ina isa kapaꞌina fegoina eoma maagai eifania auga Herod maagai eifania einaka, “Lau anina laani Ioane Baptista kania litiai gakauka gamai maisa laoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ega aisama kin Herod alo emafu alogaina kai ega pakoꞌa iifaga kainai, ke ega laꞌafou auꞌi kaiꞌiai, ifiao kapaꞌina egoina auga gaikapa eoma. ");
INSERT INTO mek_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ke ega au auꞌi kelao Ioane tipulai eaguega kai aiso kefoua. ");
INSERT INTO mek_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ke litiai kania kepakauka kemaiseina ifiao imagai kepaaua, ke ifiao eafiia elao ina epeniia. ");
INSERT INTO mek_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ke Ioane Baptista ega imoi auꞌi kemai isa imaauga keafiia kelao kefufunia. Egae kai kelao Iesu maagai Ioane emae auga fouga keifania. ");
INSERT INTO mek_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesu kapaꞌina emia auga fouga elogo aisama, ogefakeai gaagai eaguka ekailai afu oapuga agaꞌo elao. Ke papiau isa ala elao auga fouga kelogo aisama, taoniai kepealai laꞌafouai ifeꞌiai isa muninai kelao. ");
INSERT INTO mek_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iesu gaagai eake ke laꞌafou papiauꞌi eisaꞌi aisama, guaꞌi eani alogaina, ke keisafa auꞌi epafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ke epagapigapi emaiseina aisama, ega imoi isa eega kemai kepainia keinaka, “Iꞌina afuga oapuga ipauma, ke pau epagapigapi efua. Laꞌafou mopakanina ega koa fekelao paguai ifoꞌi eꞌi foꞌama agaꞌo fekeꞌafa fekeania,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kai Iesu isa epainiꞌi einaka, “Isa afu agaꞌo afakelao. Kai oi isa kapa agaꞌo amopeniꞌi kegaania,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ega aisama Iesu ega imoi isa kepainia keinaka, “Lai eemaisai palafa ima ke maꞌa gua mo kekae,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ke Iesu einaka, “Amoafiꞌi amomaiseiniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ke papiau epainiꞌi mukimukiai kegaagukipo eoma. Ke papiau keagukipo aisama, palafa ima ke maꞌa gua fou eafiiꞌi ufa eakae penia Deo maagai tenkiu eifania, efaiponiꞌi kai ega imoi epeniiꞌi keꞌeaisa papiau kepeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ke papiau maꞌoai keaniani aloꞌi ekainia. Ke keaniani afegai, Iesu ega imoi palafa ameꞌafuꞌi ke isa kepuaꞌafuniꞌi auꞌi fou kepakai guguainiꞌi aleꞌa 12 akeꞌi kepapoguꞌi. ");
INSERT INTO mek_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Papiau egae keaniani auꞌi, au mo kepaauniꞌi auga, auꞌi maꞌoai mo 5000 koa iꞌopoga kai, imoi ke papie fou auga akepaauniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Egae kai Iesu laꞌafou epakanina alogai, fiakoa mo ega imoi epainiꞌi gaagai keaguka keufai kepagai apie kelao. ");
INSERT INTO mek_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ke Iesu laꞌafou epakanina afegai, ifogamo elao iku mapegai emegamega. Ke epaꞌumina emaiseina aisama, ifogamo ipauma egaꞌina afugai eapa. ");
INSERT INTO mek_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kai isa ega imoi auꞌi gaagai kelao aꞌu ipuainagai. Egaꞌina alogai goiso emai isa keaguka gaagaga eauniia elaomo emai. Ke gaaga felao auga aekainia epaafipugu alogainiꞌi, gome ameku gaaga eaoapua. ");
INSERT INTO mek_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ke gani eegai, Iesu aꞌu laagai epea isa eeꞌi elao. ");
INSERT INTO mek_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ke Iesu ega imoi isa aꞌu laagai epea keisa aisama, keagaga keinaka, “Isage,” keoma, ke ogeꞌi egea puo keagagapea. ");
INSERT INTO mek_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kai Iesu fiakoa mo isa epainiꞌi einaka, “Alomi gakapula! Folomaniꞌi, iꞌina lau,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ke Peto einaka, “Lopia, koꞌa oi koa aisama, mopainiau fei laagai mapea eemu mafai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ke Lopia einaka, “Mai,” eoma. Ega aisama Peto gaagai eapaopu fei laagai epea Iesu eega elao. ");
INSERT INTO mek_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kai ameku epua eisa aisama, emaniꞌi ke eꞌina ekogo alogai eagaga einaka, “Lopia, kaniau moagamauga,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ega aisama Iesu fiakoa mo ima ekalaisa Peto eafiia ke epainia einaka, “Pakoꞌa eꞌele aumu. Kapa puo eeuai opomu lopamaꞌo?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ke isa gaagai keꞌagaukae aisama, ameku eapakipo. ");
INSERT INTO mek_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Egae gaagai keaguka auꞌi isa ega koa ekapaisa keisa aisama, keau afagaina keinaka, “Iifa koꞌa, oi Deo gauga paisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ke kepagai kelao apiegai aisama, Kenesaret taoninai keofau. ");
INSERT INTO mek_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ke egaꞌina ago auꞌi Iesu kaisau auga keisa felo aisama, iifa keulaisa taoni egaꞌina eegai keagu papiauꞌi maꞌoai ainaꞌi kepalogo. Ke egaꞌina papiauꞌi isafa auꞌi maꞌoai Iesu eega kemaiseiniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ke kegoinia isafa papiauꞌi galogoainiꞌi afe tiapuga kua mo kegaafi opogaina keoma. Ke maꞌoai isa keafi opogaina auꞌi feloꞌi kemia. ");
INSERT INTO mek_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Egaꞌina afegai Faliseo auꞌi ke Moses ega iifa pamalelega auꞌi Ierusaleme taoninai kemai Iesu kepaꞌani penia keinaka: ");
INSERT INTO mek_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kapa puo oi emu imoi papiau apaoꞌi eꞌi kagakaga laagai keaopagai? Gome isa imaꞌi akeikua kai keaniani!” keoma. ");
INSERT INTO mek_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ega aisama Iesu isa eꞌi iifa epamue einaka, “Ke oi aumi kapa puo, emi kagakaga mo faugai Deo ega iifa kapulaꞌi auꞌi oaupeaꞌi? ");
INSERT INTO mek_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Lau oi lapaꞌani penimi gome Deo eifa, ‘Inamu amamu fou fopalopianiꞌi,’ ke ‘Aufalao agaꞌo ina ama ageifa apala penia aisama, feisaupugu,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kai oi oifa au agaꞌo ina o ama agepaina, ‘Pipalagai kapaꞌi mo lau eeuai oafiiꞌi auꞌi pipeni Deo apuga,’ ooma. ");
INSERT INTO mek_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ke egaꞌina pipeniꞌiai isa ina ama faepalopianiꞌi ooma. Ega koa okapa oi emi kagakaga mo kainai opea kai, Deo ega iifa auga laaꞌi opamia. ");
INSERT INTO mek_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Pifoge aumi! Ufainagai profeta Aisaea oi pau kapaꞌina agokapa auga fouga Deo ega iifa pukagai epapua auga koꞌa: ");
INSERT INTO mek_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Iꞌina papiauꞌi fifinaꞌiai mo lau kepalopianiau kai, guaꞌi auga aaka ipaumagai. ");
INSERT INTO mek_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ke isa eꞌi pamalele auga, papiau aumauni iifa kepaapaꞌi auꞌi. Ega puo lau keau afagai aageniau mo,’” eoma. ");
INSERT INTO mek_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesu egaꞌina eifania afegai, laꞌafou papiauꞌi eifaniꞌi eega kemai kai epainiꞌi einaka, “Ainami fopaꞌaua, iꞌina iifaga kapaꞌina eifania auga oko fologo. ");
INSERT INTO mek_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kapaꞌina au ake alogai ekoko auga, isa aepaofua kai, kapaꞌina isa akegai epealai auga isa epaofua,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ega aisama isa ega imoi kemai kepainia keinaka, “Oi ega loifa oma Faliseo auꞌi aꞌo kelogonia aisama, aloꞌi lopalifua auga alologo ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kai Iesu isa eꞌi iifa afa palapoleai epamue einaka, “Au maꞌoai lau Amau ufai eague auga, aefauniꞌi auꞌi gagamuꞌiai akefuauꞌi. ");
INSERT INTO mek_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Amopuaꞌafuniꞌi, isa maakimiꞌi auꞌi koa iꞌopoꞌi maakimiꞌi papiauꞌi kepapeaꞌi. Ke maakimiꞌi auga agaꞌo maakimiꞌi auga mo agaꞌo agepapea koa aisama, auniꞌi kaiꞌialao ipuai akeꞌualai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ega aisama Peto Iesu epainia einaka, “Palapole iꞌina maamaisai oko mopakaisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ega aisama Iesu ega imoi epaꞌani peniꞌi einaka, “Oi lau kapaꞌina laifaniꞌi auꞌi okoꞌi alologo felo koa ma? ");
INSERT INTO mek_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Aufalao agaꞌo foꞌama akegai ekoko aisama, elao inaega alogai ke imaaugai epealai pugu auga aloisa ma? ");
INSERT INTO mek_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kai kapaꞌina au akegai kepealai auꞌi gua alogai kemai. Egaꞌina iifaꞌi isa kepaofua. ");
INSERT INTO mek_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gome papiau guaꞌi alogai kepealai auꞌi auga, opola apalaꞌi, papiau isaupugua, papiau keamage kai papiau iꞌoina agaꞌo fou akeamage auga fou kefeu, ifiao oꞌoae fou kefeu, painao, pifogeai papiau kepaagu fofouꞌi, Deo ke papiau fou eeꞌiai keifa apala auꞌi. ");
INSERT INTO mek_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Egaꞌina laoꞌi maiꞌi papiau agaꞌo alo kepaofua. Kai ima aeikua kai eaniani auga papiau alo aepaofua,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesu egaꞌina iifaga eifania afegai, Iudea papiauꞌi eꞌi ago epuaꞌafuga elao Iudea papiauꞌi laaꞌi auꞌi eꞌi agoai, Taire ke Sidoni taoniꞌi agogai ekoko. ");
INSERT INTO mek_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ega aisama Kanaan papiega agaꞌo egaꞌina ago eegai emai Iesu eegai maisapepega mo eifa einaka, “Lopia, Davide okogai lomai aumu, guau moania! Tiapolo lau gau papiega alogai eague, epakiekie alogaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kai Iesu iifa agaꞌo aeifania. Ega puo isa ega imoi kemai kegoi peni kapulania keinaka, “Moula gakailai galao, gome isa iꞌa muniꞌaisai eagaga aeapakipo paisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ega aisama Iesu einaka, “Lau auga Israel papiauꞌi laomai apalaꞌi kekapaꞌi, sipi kegea koa iꞌopoꞌi auꞌi mo fauꞌiai Deo eulaisau lamai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ega aisama papie egaꞌina emai Iesu agogai eanifeꞌu kai eifa einaka, “Lopia, mopalagainiau,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ke Iesu einaka, “Imoi eꞌi palafa faafia amuꞌe fapiu peniꞌi auga felo laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kai papie einaka, “Iifa koꞌa Lopia kai, amuꞌe mo ganinagai isa eꞌi lopia eaniani alogai ega teipoloai foꞌama ameꞌafuꞌi keaꞌopu auꞌi keaniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Iesu papie egaꞌina ega eifa oma aina elogonia aisama, eifa einaka, “Papie, oi emu pakoꞌa akaikiꞌa ipauma lau eeuai loogeisa. Ega puo kapaꞌina loifania gaikapa looma auga ageikapa paisa,” eoma. Ke egaꞌina kina maagai mo papie egaꞌina gauga felo emia. ");
INSERT INTO mek_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Egaꞌina afegai Iesu egaꞌina afuga epuaꞌafuga Kalilea aꞌuga foega nie mo elao. Egae kai elao iku mapegai eagukipo. ");
INSERT INTO mek_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Egaꞌina alogai papiau laꞌafou akaikiꞌagai isa eega kemai. Ke kemai alogai, kemelo auꞌi, maakimiꞌi auꞌi, isafai kemelo auꞌi, akeafu auꞌi, ke isafa iꞌoiꞌi maꞌo keafiꞌi auꞌi isafa kemaiseiniꞌi Iesu agogai kepakalaꞌi. Ke Iesu isa epafelo afeꞌainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Papiau ainaꞌi efua auꞌi aꞌoaꞌo kelogonia, ke kemelo auꞌi, ke isafai kemelo auꞌi fou epafeloꞌi, ke maakimiꞌi auꞌi afu keisa auga keisaꞌi aisama, kekauai alogaina keopofua. Ke isa Israel papiauꞌi eꞌi Deo Au Akaikiꞌa kepamia. ");
INSERT INTO mek_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iesu papiau epafeloꞌi afegai, ega imoi eifa kaiguguiꞌi kai, epainiꞌi einaka, “Iꞌina papiauꞌi guaꞌi laania, gome isa lau fou kina oiso inae aagu, ke pau foꞌama agaꞌo eeꞌiai laaꞌi afakeania. Lau isa inaeꞌi maikimuga mo falaulaiꞌi fakelao laoma. Kai alaulaiꞌi akelao koa aisama, keagai maaꞌi afepiu afekeꞌualai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ega aisama Iesu ega imoi keinaka, “Afu oapuga iina koa auga kapai palafa isa akeania agekaina auga agaafia laꞌafou iina koa agapaanianiꞌi agekaina?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ega aisama Iesu isa epaꞌani peniꞌi einaka, “Palafa iuma pika eemiai kekae?” eoma. Ke isa keinaka, “Palafa iuma imagea gua, ke maꞌa eꞌeleꞌi pika koa mo eemaisai kekae,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ke Iesu papiau epainiꞌi aagoai keagukipo. ");
INSERT INTO mek_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Egae kai palafa iumaꞌi imagea gua, ke maꞌa fou eafiiꞌi Deo tenkiu epeniia efua aisama, efaiponiꞌi kai ega imoi epeniiꞌi. Ke ega imoi palafa keafiiꞌi laꞌafou papiauꞌi kepeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ke papiau maꞌoai keaniani aloꞌi ekainia. Papiau keaniani afegai, Iesu ega imoi palafa ameꞌafuꞌi keaꞌopu auꞌi kepakai guguainiꞌi aleꞌa imagea gua akeꞌi kepapoguꞌi. ");
INSERT INTO mek_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ega kinagai papiau keaniani auꞌi, au mo kepaauniꞌi auga auꞌi maꞌoai mo 4000 kai, papie imoi fou auga akepaauniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Iesu laꞌafou epakanina afegai, ega imoi fou gaagai keaguka kelao Makadan taonina ago niegai. ");
INSERT INTO mek_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Egaꞌina afegai Faliseo auꞌi ke Saduseo auꞌi kemai Iesu keꞌopoisa, ke kepainia gou agaꞌo ufa guagai gakapa kegaisa keoma. ");
INSERT INTO mek_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ega aisama Iesu einaka, “Epagapigapi aisama oi oifa, ‘Pau ufa gua epito puo gapiai imu afaeꞌau,’ ooma. ");
INSERT INTO mek_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ke amagai aisama oifa, ‘Pau ufa gua epito, ke apuapu ufa gua ekaisapua puo kina apala agemia,’ ooma. Oi ufa guagai kapaꞌina emia oisa aisama, kina kapa auga oifania ekaina. Kai pau Mesaia emai efua auga gouga kapaꞌina mo kemia oisaꞌi mo ganinagai, pau kina kapa auga agoifania afaekaina. ");
INSERT INTO mek_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Papiau apalaꞌi ipaumaꞌi Deo kapaꞌina eifania akepakoꞌania ke kainai akepea auꞌi, eꞌi laomaisai amage papiauꞌi kai papiau iꞌoiꞌi fou kefeu auꞌi koa iꞌopoꞌi auꞌi auga, mirakulo gouga agaꞌo gaikapa keoma paꞌanina kepaꞌani. Kai mirakulo gouga agaꞌo afalakapa kai Jona faagagai gou emia auga mo agemia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kai kepagai kelao aꞌu apiegai aisama, Iesu ega imoi keꞌagege palafa akeafia. ");
INSERT INTO mek_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Egaꞌina alogai Iesu isa epainiꞌi einaka, “Faliseo auꞌi ke Saduseo auꞌi eꞌi palafa ipaufuga mulamula auga foisa felo, ke eegai ifomi foꞌimaimi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ega aisama Iesu ega imoi isa egaꞌina eifania auga fouga, ifoꞌi mo epoꞌiai keifania keinaka, “Iꞌa palafa agaꞌo alaafia kainai isa ega eifa oma,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kai Iesu isa kapaꞌina keifania auga elogo puo epainiꞌi einaka, “Oi pakoꞌa eꞌele aumi. Kapa puo oi palafa agaꞌo eemiai laaꞌi auga fouga oifania? ");
INSERT INTO mek_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Oi lau kapaꞌina laifania auga oko alologo felo koa ma? Ke lau palafa iumaꞌi ima mo laafiiꞌi papiau 5000 lapaanianiꞌi, ke aleꞌa pika opapoguꞌi auga aloopolaga ma? ");
INSERT INTO mek_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ke palafa imagea gua mo kai papiau 4000 lapaanianiꞌi, ke aleꞌa pika opapoguꞌi auga isafa aloopolaga ma? ");
INSERT INTO mek_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ala koa iꞌopoga lau palafa fouga oi maamiai alaifania auga oko alologo koa? Lau palafa fouga alaifania kai, oi Faliseo auꞌi ke Saduseo auꞌi fou eꞌi palafa ipaufuga mulamula auga foisa felo, ke eegai ifomi foꞌimaimi laoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Iesu egaꞌina eifania aisama, ega imoi isa mulamula palafa alogai keoge auga fouga aeifania kai, Faliseo ke Saduseo auꞌi eꞌi pamalele palafa ipaufuga mulamula koa iꞌopoga auga fekeisa felo, ke eegai ifoꞌi fekeꞌimaꞌi auga fouga eifania auga kelogo. ");
INSERT INTO mek_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Egaꞌina afegai Iesu ega imoi fou kelao Sisarea Filipi taoninai kekoko aisama, epaꞌani peniꞌi einaka, “Papiau, lau Papiau Aumauni Gauga au keifaniau kaisau keoma?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ke isa keinaka, “Isaꞌi keifa oi auga Ioane Baptista maeai emaunimue emai keoma, ke isaꞌi keifa oi profeta Elaija keoma kai, isaꞌi auꞌi oi profeta Jeremaia, o ufaina profetaꞌi agaꞌo keoma,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ega aisama Iesu isa epaꞌani peniꞌi einaka, “Ke oi auga lau kai ooma?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ke Saimon Peto keoma auga iifa epamue einaka, “Oi auga Mesaia, Deo eague aoniamo Auga Gauga aumu,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ega aisama Iesu eifa einaka, “Saimon Jona gauga aumu. Oi Deo eegai kapa feloꞌi loafiꞌi aumu! Gome pau mo kapaꞌina loifania auga papiau aumauni oi akepalogonio kai lau Amau ufai eague Auga epalogonio loifania. ");
INSERT INTO mek_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Saimon, iifa koꞌa maamuai laifania. Pau oi alaifanio Peto alaoma. (Peto iꞌa malaꞌaisai auga fopa.) Ke fopa egaꞌina laagai lau eꞌu iifi eꞌa alapaapa. Ke ipeli paꞌafina isapuga iifi eꞌa egaꞌina papiauꞌi afaepalutiniꞌi afaelaꞌa pagainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ke lau oi Deo ega agofaꞌa paꞌafina fopaagalaisa auga isapuga alapenio. Ke kapaꞌina aagoai loifaꞌapua auga, ufai isafa Deo ageifaꞌapua, ke kapaꞌina aagoai alologoaina auga, ufai isafa Deo agelogoaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Iesu egaꞌina iifaga eifania afegai, ega imoi ainaꞌi epalogo, isa Mesaia auga fouga kai agaꞌo maagai fakeifania eoma. ");
INSERT INTO mek_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ke egaꞌina kinagai Iesu eꞌina ega imoi maaꞌiai isa ega mae fouga eifania. Egaꞌina auga isa felao Ierusaleme taoninai, papiau isa Iudea au akaikiꞌaꞌi auꞌi, sakedote lopiaꞌi, ke Moses ega iifa pamalelega auꞌi imaꞌiai fekepaaua, ke kapa maꞌo mo fauꞌiai isa fekepakiekie fekeaupugua kai kina oiso aisama, femaunimue pugu auga fouga maaꞌiai eifania. ");
INSERT INTO mek_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ega aisama Peto isa eafiapia kai eꞌina efinaisa einaka, “Lopia, laaꞌi afaekaina. Egaꞌina kapaꞌi oi faagamuai afakemia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kai Iesu isa eaipenia kai epainia einaka, “Satani, muniu mai lao! Oi lau ifeu faꞌanina faꞌualai koa kapa lomia eꞌu keaga lokaisapua. Oi Deo kapaꞌina fekapa eoma auga aloopolaga kai papiau aumauni kapaꞌina fekekapa keoma auga mo loopolaga,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Egae kai ega imoi maꞌoai epainiꞌi einaka, “Aufalao agaꞌo lau muniuai gapea eoma koa aisama, isa ifo feꞌagegeaina kai ega koloti fepua muniuai fepea. ");
INSERT INTO mek_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Gome kaisau ifo ega agu maunina kania gaagamauga eoma auga ega agu agepagea. Kai kaisau lau puouai ifo ega agu maunina agepagea auga agu pagai maunina agekapulaisa. ");
INSERT INTO mek_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Gome au agaꞌo agofaꞌa fofouga apuga agemia kai lalauga agepagea auga, kapa felo agaꞌo isa eegai agemia ma? Ke au agaꞌo lalauga agepagea koa aisama, kapaꞌina agepipeni lalauga ageafimue pugu? ");
INSERT INTO mek_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Gome Papiau Aumauni Gauga Ama ega eaea, ke ega isapu akaikiꞌagai ega agelo fou akemai aisama, egaꞌina kinagai isa papiau kapaꞌina kekapa auga kainai mo afa agepeniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Iifa koꞌa maamiai laifania. Oi isami inae oapae aumi mae gamuga afoloopo agelao Papiau Aumauni Gauga ega afuai agemai agoisa kai agomae,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Egae kai kina imagea elao afegai aisama, Iesu, Peto, James, ke akina Ioane fou eꞌafeiniꞌi epapeaꞌi ifoꞌi mo kelao iku agaꞌo eꞌagau alogaina auga ikugai keꞌagaukae. ");
INSERT INTO mek_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Egae isa auꞌi oiso agoꞌiai Iesu eponi. Ke kua maaga auga kina eaga eaea koa emia, ke afe tiapuga auga eeaea ekelo alogaina, eaea keloga koa iꞌopoga emia. ");
INSERT INTO mek_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ega aisama Moses Elaija auniꞌi isa agoꞌiai keapafoki Iesu fou keniniꞌani keisaꞌi. ");
INSERT INTO mek_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ke Peto Iesu epainia einaka, “Lopia, lai oi fou amai inae auga felo ipauma. Oi anina loani koa aisama, lau inae efeꞌefe oiso alakapaꞌi, agaꞌo oi apumu, agaꞌo Moses apuga, ke agaꞌo Elaija apuga agemia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Peto eniniꞌani laolao kai, apuapu maiꞌeaeaga emai eumiapuꞌi, ke aufalao agaꞌo aina apuapuai emai eifa einaka, “Iꞌina auga Lau Gau, anina laani alogaina auga, ke eegai alou egama. Oi isa aina foafia!” eoma. ");
INSERT INTO mek_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iesu ega imoi oiso egaꞌina aꞌo kelogonia aisama, keꞌualai aꞌisaai keomukipo ke kemaniꞌi alogaina. ");
INSERT INTO mek_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kai Iesu emai isa faagaꞌi eafi opogaina kai epainiꞌi einaka, “Folomaniꞌi amoꞌuegekae” eoma. ");
INSERT INTO mek_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ke kekiakae aisama, kai agaꞌo egae akeisa kai Iesu ifogamo keisa. ");
INSERT INTO mek_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Egae kai ikuai keake kemai alogai Iesu isa eifa kapula peniꞌi einaka, “Kapaꞌina pau oisa auga, kai agaꞌo maagai foloifania felao Papiau Aumauni Gauga maeai femaunimue afegai kai foifafoua,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ega aisama ega imoi oiso isa kepaꞌani penia keinaka, “Ega koa aisama, kapa puo Moses ega iifa pamalelega auꞌi keifa Elaija feufai femai keoma?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ke Iesu iifa epamue einaka, “Iifa koꞌa, Elaija feufai femai, ega koa kapa maꞌoai feoge opainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kai lapainimi, Elaija emai ke papiau isa keisa efua kai akelogo, ke faagagai kapa maꞌoai kegakapaꞌi keoma auꞌi kekapa afeꞌainiꞌi. Ega koa iꞌopoga, Papiau Aumauni Gauga isa imaꞌiai agekiekie,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Iesu ega eifa oma aisama, ega imoi isa Ioane Baptista fouga eifania auga kelogo. ");
INSERT INTO mek_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Egae kai kemai laꞌafou papiauꞌi eeꞌiai aisama, au agaꞌo emai Iesu ife foꞌinai eanifeꞌu kai eifa einaka: ");
INSERT INTO mek_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Lopia, lau gau gua moania. Isa eaguagu epakauaina faaga efaꞌiꞌi, ke epogai kapaꞌina emia auga aelogo puo, eꞌualai lo laagai ekauau ke feisai isafa eꞌualai. Ega koa ekapa ifo faaga epakiekie alogaina. ");
INSERT INTO mek_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Lau isa lamaiseina oi emu imoi eeꞌiai kai, oi emu imoi aekainiꞌi akepafelo,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iesu iꞌina aꞌo elogonia aisama eifa einaka, “O, oi maꞌoai pau alomi koꞌagai alopakoꞌaniau, ke emi pakoꞌa alopapinauga felo papiaumi. Lau inae kina pika fou afaagu, ke kina pika alou eemiai afaafiapia mo afelaolao? Lau inae afalaagu pagainia mo kai emi pakoꞌa eeuai alooge kapulania. Imoi eeu amomaiseina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Egaꞌina imoina kemaiseina aisama, Iesu tiapolo imoi alogai eagu auga efinaisa epealai. Ke egaꞌina kina maagai mo imoi felo emia. ");
INSERT INTO mek_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Egaꞌina afegai Iesu ega imoi ogefakeai kemai kepaꞌani penia keinaka, “Kapa puo lai tiapolo amapapealaisa aoma aekainimai?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ke Iesu iifa epamue einaka, “Gome oi emi pakoꞌa eꞌele ipauma puo, tiapolo amopapealaisa ooma aekainimi. Iifa koꞌa maamiai laifania. Oi emi pakoꞌa au oga eꞌele ipauma aka mastad oga koa iꞌopoga agemia koa aisama, iku iꞌina agopaina, ‘Inae mokailai molao egae,’ agooma aisama, iku egaꞌina agepea agelao egae. Ke kapa agaꞌo eemiai afaeꞌinoka kai maꞌoai agokapaꞌi agekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Egaꞌina afegai Iesu ega imoi fou kemai Kalilea agogai kekaigugu aisama, epainiꞌi einaka, “Papiau Aumauni Gauga akeꞌafaꞌafalaina papiau imaꞌiai akepaaua. ");
INSERT INTO mek_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ke egaꞌina papiauꞌi isa akeaupugua kai kina oiso alogai maeai agemaunimue pugu,” eoma. Iesu ega eifa oma ega imoi aina kelogonia aisama, aloꞌi emafu alogaina. ");
INSERT INTO mek_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Egae kai Iesu ega imoi fou kemai Kapenaum taoninai kekoko aisama, au papiau imaꞌiai tax monina silifa auniꞌi keafiafia auꞌi Peto eega kemai kepaꞌani penia keinaka, “Oi emi pamalele auga tax Deo ega eꞌai keoge auga eoge o aeoge?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ke Peto iifa epamue einaka, “E, isa tax eogeoge,” eoma. Egae kai Peto emai eꞌai ekoko aisama, Iesu eniniꞌani kaukau Peto epaꞌani penia einaka, “Peto oi ala loopola oma? Aagoa kiniꞌi kaisau eeꞌiai pinauga afa moniꞌi, ke tax keafiꞌi? Isa ifoꞌi gauꞌi eeꞌiai, o papiau iꞌoiꞌi eeꞌiai?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ke Peto einaka, “Papiau iꞌoiꞌi eeꞌiai,” eoma. Ega aisama Iesu einaka, “Ega koa aisama, isa gauꞌi auga kapa agaꞌo afakeoge. ");
INSERT INTO mek_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kai iifaga laaꞌi, aloꞌi afapalifua puo, molao aꞌuai naku mopiuga. Ke maꞌa kapa alolaꞌau kakaua auga, ake foofa, ke egae silifa monina pani aloisaꞌi. Egaꞌina monina foafia folao auniꞌa aꞌa tax fooge,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ke egaꞌina kinagai mo, Iesu ega imoi kemai kepaꞌani penia keinaka, “Deo ega agofaꞌai, papiau kapa auga au akaikiꞌa ipauma?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ega aisama Iesu imoi eꞌele agaꞌo eifaga emai epoꞌiai epaapa. ");
INSERT INTO mek_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Egae kai eifa einaka, “Iifa koꞌa maamiai laifania. Oi afoloponi ifomi imoi eꞌelemi koa afolopamiaimi koa aisama, oi Deo ega agofaꞌai afolokoko mo laaꞌi. ");
INSERT INTO mek_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ega puo kaisau ifo epaake imoi eꞌele iꞌina auga koa epamia auga, Deo ega agofaꞌai au akaikiꞌa ipauma. ");
INSERT INTO mek_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ke kaisau lau akauai imoi eꞌele iina koa agaꞌo eifa koko auga, lau eifa kokoisau. ");
INSERT INTO mek_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Kai kaisau iꞌina imoina eꞌele agaꞌo lau epakoꞌaniau auga laomai apala agepakina agekapa koa aisama, felo auga isa aisogai foꞌama kepaikumuꞌa kepo akaikiꞌa feipaaukopa kai, aꞌu moaina ipaumagai feiꞌafolai fekogo,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Iesu eifa pugu einaka, “Iꞌina agofaꞌa, kapa maꞌo mo faagaꞌiai papiau epaꞌualaiꞌi puogai, Deo iꞌina agofaꞌa afa apala fepenia laoma. Egaꞌina kapaꞌi auga fekemai paisa puo kemai kai, au kapa faagagai egaꞌina kapaꞌi kemai auga, Deo isa afa apala fepenia laoma! ");
INSERT INTO mek_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ke oi imamu o ifemu afepapeaiso laomai apala afokapa koa aisama, fofoua. Oi fomelo o faagamu agaꞌo femou, ega koa Deo ega agofaꞌai fokoko auga felo ipauma. Kai imamu o ifemu auniꞌi kekaega kai lo aealoalo auga alogai fekepiu kokoiso auga apala ipauma. ");
INSERT INTO mek_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ke maamu afepapeaiso laomai apala afokapa koa aisama foꞌiulaisa. Oi maamu agaꞌomogai Deo ega agofaꞌai fokoko auga felo ipauma. Kai maamu auniꞌi kekaega kai, lo aealoalo auga alogai fekepiu kokoiso auga apala ipauma,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Iesu eifa pugu einaka, “Oi auga imoi eꞌeleꞌi iꞌina auꞌi agaꞌo foloisa papaꞌi. Gome imoi eꞌeleꞌi iꞌina auꞌi eꞌi agelo aufa kina lau Amau ufai eague auga agogai keapa isa fouꞌi keifania aefuafua. ");
INSERT INTO mek_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ke au agaꞌo sipi 100 eegai keapae, ke agaꞌo afepea gea koa aisama, sipi 99 ikuai afaepuaꞌafuniꞌi kai, afaelao egaꞌina egea auga afaekapuga ma? Oi ala oopola oma? ");
INSERT INTO mek_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Iifa koꞌa maamiai laifania, isa agelao agekapuga paisa, ke sipi egaꞌina ageisa aisama, egaꞌina agaꞌomo ekapulaisa auga alogama eꞌele laaꞌi agepamia. Ke egaꞌina alogama auga sipi 99 alogamaꞌi agekaꞌegaina. ");
INSERT INTO mek_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ega koa iꞌopoga, oi Amami ufai eague auga anina mo aeani, imoi eꞌeleꞌi iꞌina agaꞌo fegea eoma.” ");
INSERT INTO mek_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Iesu eifa pugu einaka, “Oi aamu akimu agaꞌo eemuai laomai apala agekapa koa aisama, folao oi aunimi mo epomiai isa kapaꞌina eemuai epalifua auga, maagai foifania fopaꞌopaina. Ke isa oi ainamu ageafia koa aisama, oi isa fou omia efua. ");
INSERT INTO mek_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kai isa oi ainamu afaeafia koa aisama, papiau agaꞌomo, o gua fou folao, ega koa kapaꞌina emia auga papiau gua, o oiso egaꞌina kapa fekeisa, iifa koꞌaꞌi maꞌoai fekelogo, ke fekeifafoua. ");
INSERT INTO mek_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ke isa egaꞌina papiauꞌi lomaiseiniꞌi auꞌi ainaꞌi afaeafia koa aisama, pakoꞌa papiauꞌi maaꞌiai foifafoua. Ke isa pakoꞌa papiauꞌi mo ganinagai, ainaꞌi afaeafia koa aisama, Deo akelogo auꞌi, o tax keafia laomai apalaꞌi kekapaꞌi auꞌi eeꞌiai ala lokapa oma koa iꞌopoga mo isa eegai fokapa. ");
INSERT INTO mek_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Iifa koꞌa maamiai laifania. Kapaꞌina aagoai oifaꞌapua auga ufai Deo isafa ageifaꞌapua. Ke kapaꞌina inae aagoai agologoaina auga, ufai Deo isafa agelogoaina. ");
INSERT INTO mek_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ke lapainimi pugu. Aagoai oi epomiai papiau auniꞌi akepakoꞌania kapa agaꞌomo akegoina aisama, lau Amau ufai eague auga, oi kapaꞌina ogoina auga faumiai agekapa. ");
INSERT INTO mek_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Gome papiau gua, o oiso lau akauai kekaigugu aisama, lau isafa egae isa epoꞌiai laague,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ega aisama Peto Iesu eega emai epaꞌani penia einaka, “Lopia, lau aau o akiu eeuai laomai apala agaꞌo agekapa koa aisama, ega laomai apala iꞌagegeaina pika fapamia? Imagea gua fapamia ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ke Iesu einaka, “Lau lapainio, imagea gua folopamia kai 77 fopamia. ");
INSERT INTO mek_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ega puo Deo ega agofaꞌa auga iina koa iꞌopoga. Kin agaꞌo ega pinauga auꞌi isa eegai keapitole auꞌi eꞌi apitole oko kegapakaisa eoma. ");
INSERT INTO mek_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Egaꞌina ekapaisa alogai, au agaꞌo isa eegai talent monina 10,000 eapitole auga isa eega kemaiseina. ");
INSERT INTO mek_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kai isa egaꞌina monina afa feoge auga eegai laaꞌi aekainia kainai, au akaikiꞌa eifa kapula isa ifo ke akafa gauga, ke kapa maꞌoai eegai kekae auꞌi fou fekeꞌafaꞌafalainiꞌi, ega apitole afa feoge eoma. ");
INSERT INTO mek_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ega aisama au egaꞌina isa agogai eꞌualai eanifeꞌu kai egoinia einaka, ‘Eeuai alomu moafiapia mo, ke lau oi emu kapa maꞌoai afaꞌi alapenimueiso,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ega aisama pinauga auga ega au akaikiꞌa isa gua eaniia, ke ega apitole maꞌoai laaꞌi epamia, epapealaisa elao. ");
INSERT INTO mek_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Kai pinauga auga egaꞌina elao aisama, pinauga auga agaꞌo isa fou kepinauga auga isa eegai denari monina 100 eapitole auga eisa. Ega aisama eafiia aiso epepekia kai epaini kapulania einaka, ‘Kapaꞌina lau eeuai loapitoleaina auga afa mopenimueisau,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ega aisama au egaꞌina fou kepinauga auga isa agogai eꞌualai eanifeꞌu kai egoinia einaka, ‘Eeuai alomu moafiapia mo, ke lau oi emu moni afa alapenimueiso,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Kai isa egaꞌina auga gua aeania, ekailai elao tipula auꞌi epainiꞌi au egaꞌina keafiia tipula eꞌagai kepaagua, egae mo feagu felao ega apitole afa feoge kai fepealai eoma. ");
INSERT INTO mek_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kai pinauga auꞌi iꞌoiꞌi isaꞌi kapaꞌina emia auga keisa aisama, aloꞌi emafu alogaina. Ke kelao eꞌi au akaikiꞌa maagai kapa maꞌoai kemia auꞌi keifaniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ega aisama au akaikiꞌa pinauga auga apala auga eifa koko emai kai epainia einaka, ‘Oi pinauga apala aumu. Oi lau logoiniau emu apitole laaꞌi mapamiaꞌi looma puo maꞌoai laaꞌi lapamiaꞌi. ");
INSERT INTO mek_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Lau oi guamu laaniia emu apitole laaꞌi lapamia koa iꞌopoga, oi fou opinauga auga isafa gua foania ega apitole laaꞌi fopamia auga aekainia ma?’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ke au akaikiꞌa guakupuai pinauga auga tipula afugai kepinauga auꞌi imaꞌiai epaaua, egae feagu mo felao ega apitole maꞌoai afaꞌi feoge afeꞌaina kai fepealai eoma. ");
INSERT INTO mek_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Oi aamu o akimu eemuai apala ekapaisa auga guamu alo ipaumagai afoloꞌagegeaina koa aisama, lau Amau ufai eague auga isafa oi faagamuai ega koa iꞌopoga mo agekapa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesu egaꞌina iifaꞌi eifaniꞌi efua aisama, Kalilea ago epuaꞌafuga elao Jordan agapuge apiegai, Iudea ago nie kaina agogai ekoko. ");
INSERT INTO mek_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ke laꞌafou akaikiꞌa isa muninai kepea, ke egae keisafa auꞌi maꞌoai epafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Egaꞌina alogai Faliseo auꞌi isaꞌi isa kegaꞌopo keoma eega kemai kepaꞌani penia keinaka, “Au agaꞌo akafa fou epoꞌiai kapa agaꞌomo elifu, o kapa maꞌo kelifu kainai ifo ega logoai akafa gapaake ageoma auga ekainia ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ega aisama Iesu iifa epamue einaka, “Deo agofaꞌa epagama mo alogai, ‘agaꞌo maguae, ke agaꞌo papie epagama.’ ");
INSERT INTO mek_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ke eifa, ‘Egaꞌina kainai au ina ama agepuaꞌafuniꞌi akafa auniꞌi akeagufou, ke auniꞌi auga imaauꞌiai agaꞌomo agemia,’ eoma. Egaꞌina fouga Deo ega iifa pukagai alokuapina ma? ");
INSERT INTO mek_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Deo ega eifa oma kainai, isa auga papiau auniꞌi laaꞌi kai agaꞌomo kemia. Ega puo kapaꞌina Deo eogefoua agaꞌomo epamia auga, papiau aumauni fakeaupea,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ega aisama Faliseo auꞌi kepaꞌani pugu keinaka, “Ega koa aisama, kapa puo Moses eifa au agaꞌo akafa gapaake ageoma aisama, papie ipaake pepa fepapua fepenia kai feulaisa felao eoma?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ke Iesu iifa epamue einaka, “Moses oi elogoainimi akafami fopaakeꞌi eoma, gome oi guami eꞌinoka alogaina. Kai Deo agofaꞌa epagama alogai ega aekapa oma. ");
INSERT INTO mek_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Iifa gome maamiai laifania. Kaisau akafa au iꞌoina agaꞌo fou afakefeu mo ganinagai agepaake, ke papie iꞌoina agaꞌo ageakafania koa aisama, Deo maagai auga, isa papie iꞌoina agaꞌo fou kefeu, laomai apala kekapa” eoma. ");
INSERT INTO mek_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Iesu ega imoi iꞌina iifaga aꞌo kelogonia aisama keifa keinaka, “Au papie auniꞌi epoꞌiai ega koa aisama, afalaamage auga felo ipauma,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kai Iesu einaka, “Oi oifa felo kai, papiau maꞌoai iꞌina pamalelega fekeafia apuꞌi fekepamia auga afaekaina. Kai kaisau fauꞌiai iꞌina pamalelega kepagama auꞌi mo akeafia apuꞌi akepamia agekaina. ");
INSERT INTO mek_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Gome au isaꞌi keogeoge auꞌi, isa ega kemauni oma, ke isaꞌi auga papiau isa imoi fakepamauniꞌi keoma puo, faagaꞌiai papie imoi fekeafia afuga auga keafilaisa. Kai isaꞌi auga Deo ega agofaꞌa faugai fekepinauga keoma kainai afakeamage. Ega puo kaisau iifa iꞌina ageafia apuga agepamia koa, feafia apuga fepamia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Egaꞌina afegai papiau Iesu ima imoi eꞌeleꞌi kaniaꞌiai feogeaua, ke fauꞌiai femegamega keoma puo kemaiseiniꞌi eegai. Kai Iesu ega imoi papiau imoi kemaiseiniꞌi auꞌi kefinaiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ega aisama Iesu isa epainiꞌi einaka, “Imoi eꞌeleꞌi folokaisapuꞌi eeu kegamai, gome Deo ega agofaꞌa auga papiau imoi eꞌeleꞌi iina koaꞌi kemia auꞌi apuꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ke ima imoi kaniaꞌiai eogeaua fauꞌiai emegamega efua aisama, egaꞌina afuga epuaꞌafuga. ");
INSERT INTO mek_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Iesu ekailai elao alogai, au agaꞌo emai, epaꞌani penia einaka, “Pamalele aumu, kapaꞌina felo fakapa, agu pagai maunina faafia?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ega aisama Iesu einaka, “Iꞌina agofaꞌagai kai agaꞌo felo laaꞌi kai, Deo ifogamo mo felo ipauma. Ega puo kapa puo kapaꞌina felo auga paꞌanina lau lopaꞌani peniau? Oi agu pagai maunina afugai mokoko looma koa aisama, Deo ega iifa kapulaꞌi kaiꞌiai fopea,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ke au egaꞌina epaꞌani einaka, “Deo ega iifa kapulaꞌi kapaꞌi auꞌi kaiꞌiai fapea looma?” eoma. Ke Iesu einaka, “Kai agaꞌo foloaupugua, au agaꞌo akafa fou folofeu, folopainao, ke pifogeai papiau folopaagu fofouꞌi. ");
INSERT INTO mek_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ke inamu amamu fopalopianiꞌi. Ke ifomu animu loani koa iꞌopoga, emu eꞌa ipafe auꞌi isafa aniꞌi ega foani oma,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ega aisama au aguꞌa egaꞌina eifa einaka, “Egaꞌina iifaꞌi maꞌoai laafiꞌiniꞌi kai kapaꞌina auga alakapa koa?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ke Iesu iifa epamue einaka, “Oi Deo maagai alomu opaina ipauma gamia looma koa aisama, molao emu amu maꞌoai moꞌafaꞌafalainiꞌi ulalu papiauꞌi mopeniꞌi. Egae kai fomai muniuai fopea. Ega koa ufai alopaꞌamuꞌamu,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kai au aguꞌa egaꞌina epaꞌamuꞌamu alogaina puo iꞌina iifaga aꞌo elogonia aisama, alomafuai ekailai elao. ");
INSERT INTO mek_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ega aisama Iesu ega imoi epainiꞌi einaka, “Iifa gome maamiai laifania. Paꞌamuꞌamu auga agaꞌo Deo ega agofaꞌai gakoko ageoma auga ageꞌinoka alogaina. ");
INSERT INTO mek_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ke lapainimi pugu. Kamelo agaꞌo tiapu ikaina nilaga inegai gapagai ageoma auga afaeꞌinoka alogaina. Kai paꞌamuꞌamu auga Deo ega agofaꞌai gakoko ageoma auga ageꞌinoka alogaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Iesu ega imoi iꞌina iifaga aꞌo kelogonia aisama kekauai alogaina, ke Iesu kepaꞌani penia keinaka, “Ega koa aisama, kai mo kaniaꞌi ageisagamau?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ega aisama Iesu isa maaꞌi alo ipauma eisa kai epainiꞌi einaka, “Papiau eeꞌiai iꞌina kapaꞌi akemia afaekaina kai Deo eegai auga, kapa maꞌoai akemia agekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ega aisama Peto einaka, “Moisa! Lai emai kapa maꞌoai apuaꞌafuniꞌi oi munimuai apea. Ega puo lai faumaisai kapaꞌina ekae agaafia?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ega aisama Iesu ega imoi maꞌoai epainiꞌi einaka, “Iifa gome maamiai laifania. Kina fuagai kapa maꞌoai mamaꞌi akemia, ke Papiau Aumauni Gauga ufai ega isapu akaikiꞌa eafia afugai ageagu aisama, oi lau muniuai opea aumi isafa, isapu akaikiꞌa afuꞌi 12 agoafiꞌi agoagu, Israel ikupuga 12 papiauꞌi, ke papiau maꞌoai isafa eꞌi laomai felo, o apala auga afa agopeniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ke kaisau lau akau faugai eꞌi eꞌa, aaꞌi akiꞌi, afakuaꞌi, inaꞌi amaꞌi, gauꞌi, o eꞌi ago kepuaꞌafuniꞌi auꞌi, kapaꞌina kepuaꞌafuga auga laagai 100 ageisogeau. Ke fuagai agu pagai maunina isafa apuꞌi agemia. ");
INSERT INTO mek_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kai papiau maꞌo pau keufai auꞌi akemuniai, ke maꞌo pau kemuniai auꞌi akeufai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ke Iesu palapole agaꞌo eifania pugu einaka, “Lau ega laifa oma, gome Deo ega agofaꞌa auga iina koa iꞌopoga. Ago inagome auga agaꞌo amagai ipauma epealai elao au isaꞌi afaꞌi feoge ega fino umagai fekepinauga eoma. ");
INSERT INTO mek_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ke pinauga auꞌi eisaꞌi aisama, elogo isa denari agaꞌomo agepeniꞌi eoma kai eulaiꞌi kelao ega fino umagai kepinauga. ");
INSERT INTO mek_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ke amagai kina maaga 9 oꞌclock koa iꞌopoga aisama, epealai elao afaꞌafa afugai au isaꞌi kapa agaꞌo akekapaisa keapa aage mo eisaꞌi. ");
INSERT INTO mek_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ega aisama epainiꞌi einaka, ‘Oi isafa folao lau eꞌu fino uma alogai fopinauga, ke lau oi kapaꞌina foafia laoma auga alapenimi,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ega puo isa kelao umai kepinauga. “Ke kina maaga atiafa koa iꞌopoga alogai, ke 3 oꞌclock koa iꞌopoga alogai isafa epealai elao iꞌopoga mo ekapaisa. ");
INSERT INTO mek_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ke 5 oꞌclock koa iꞌopoga alogai elao pugu aisama, isaꞌi egae keapa paisa eisaꞌi. Ega aisama epaꞌani peniꞌi einaka, ‘Kapa puo kina fofouga inae oapa aage mo kapa agaꞌo alokapaisa mo emai egapigapi?’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ke isa keinaka, ‘Kai agaꞌo aemai lai afamai aeogeisa puo inae aapa aage mo emai egapigapi,’ keoma. “Ega aisama fino ago inagome auga isa epainiꞌi einaka, ‘Ega koa aisama, oi isafa olao lau eꞌu fino uma alogai amopinauga,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ke epaꞌumina aisama, fino uma inagome auga ega pinauga auꞌi eꞌimaꞌi auga epainia einaka, ‘Pinauga auꞌi moifaniꞌi kegamai kai, muniai kemai auꞌi faagaꞌiai foꞌina, eꞌi moni fopeniꞌi felao, keufai kemai auꞌi faagaꞌiai fofua,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ke pinauga auꞌi 5 oꞌclock koa iꞌopoga kemai auꞌi, kemai agaꞌo agaꞌo denari agaꞌomo keafiia. ");
INSERT INTO mek_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ega puo pinauga auꞌi keufai kemai auꞌi keopolaga denari maꞌo akeafiꞌi keoma. Kai isa maꞌoai isafa denari agaꞌomo agaꞌomo keafiia. ");
INSERT INTO mek_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ke isa denari agaꞌomo keafiia aisama, ago inagome auga eegai keifa mugumugu. ");
INSERT INTO mek_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ke keifa keinaka, ‘Iꞌina auꞌi muniai kemai kina maaga agaꞌomo mo kepinauga kai, lai auga pinauga meauga akapaisa, ke kinai kina isapuga aapa apua emai egapi kai, isa lai fou iꞌopo agaꞌomo lopamiaimai,’ keoma. ");
INSERT INTO mek_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Kai ago inagome auga, pinauga auga agaꞌo epainia einaka, ‘Ekefaꞌau, oi ifomi ologo denari agaꞌomo foafia ooma, faugai opinauga. Ke lau oi eemuai kapa apala agaꞌo alakapaisa. ");
INSERT INTO mek_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ega puo emu moni mo moafia molao. Lau anina laani au muniai emai auga isafa moni oi loafia koa iꞌopoga mo mapenia laoma. ");
INSERT INTO mek_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ke lau ifou eꞌu moni faagagai kapaꞌina makapa laoma auga falakapa ma? O lau lagafegafe puo oi lopikupa ma?’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Egae kai Iesu eifa einaka, “Ega koa iꞌopoga kaisau keufai auꞌi akemuniai, ke kaisau kemuniai auꞌi akeufai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Egaꞌina afegai Iesu Ierusaleme taonina elao alogai, ega imoi 12 eꞌafeiniꞌi kelao meꞌegai kai epainiꞌi einaka: ");
INSERT INTO mek_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Amoisa. Iꞌa Ierusaleme taonina alao kai egae Papiau Aumauni Gauga akeꞌafaꞌafalaina sakedote lopiaꞌi ke Moses ega iifa pamalelega auꞌi imaꞌiai akepaaua. Ke egaꞌina auꞌi isa femae iifaga akepaapa. ");
INSERT INTO mek_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ke akeafia Iudea papiauꞌi laaꞌi auꞌi imaꞌiai akepaaua. Ke isa Papiau Aumauni Gauga akepaꞌaua akegapuka, ke kolotiai akeauꞌuꞌua agemae. Kai kina oiso aisama, isa maeai agemaunimue,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Egaꞌina afegai Sebedi gauga auꞌi inaꞌi fou kemai Iesu agogai keanifeꞌu kai Iesu kapa felo agaꞌo isa gauga fepeniꞌi eoma. ");
INSERT INTO mek_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ega aisama Iesu papie egaꞌina epaꞌani penia einaka, “Oi kapaꞌina anina loani?” eoma. Ke isa einaka, “Moifa koꞌania. Oi alolao emu agofaꞌai aisama, lau gau iꞌina auniꞌi, agaꞌo oi kaimuai feagu, ke agaꞌo lafanimuai feagu laoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kai Iesu Sebedi gauga auniꞌi epainiꞌi einaka, “Oi kapaꞌina ogoina auga oko alologo kai ogoi aageniau mo. Oi lau kiekie kaputina alainu auga agoinu ma?” eoma. Ke isa keinaka, “E, lai oi kiekie kaputina aloinu auga againu agekaina,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ega aisama Iesu isa epainiꞌi einaka, “Koꞌa, oi lau eꞌu kaputiai kapaꞌina alainu auga agoinu kai, kaiuai o lafaniuai foagu auga lau alakapa afaekaina. Egaꞌina afuga auga lau Amau papiau kapaꞌi afuꞌi epafua ekae auꞌi agepeniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Iesu ega imoi ouꞌaga isa ega eifa oma aina kelogonia aisama, Sebedi gauga auniꞌi eeꞌiai guaꞌi ekupu alogaina. ");
INSERT INTO mek_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iesu isa eifa kaiguguiꞌi kai epainiꞌi einaka, “Oi ologo Iudea papiauꞌi laaꞌi auꞌi, eꞌi lopia ago keꞌima auꞌi, eꞌi lopia isapugai isa keꞌimaꞌi. Ke isa eꞌi au akaikiꞌaꞌi auꞌi, eꞌi isapuai isa keꞌimaꞌi. ");
INSERT INTO mek_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kai oi auga ega koa folokapa kai, epomiai kaisau akaikiꞌa gamia eoma auga, oi maꞌoai emi pinauga auga femia. ");
INSERT INTO mek_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ke epomiai isafa kaisau gaufai eoma auga, oi emi kalaꞌafi koa iꞌopoga femia. ");
INSERT INTO mek_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ke Papiau Aumauni Gauga isafa papiau isa ega pinauga fekekapa eoma aemai kai, fepalagainiꞌi ifo imaauga fepipeni papiau maꞌo eꞌi laomai apalaꞌi afaꞌi feoge eoma puo emai.” ");
INSERT INTO mek_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Egaꞌina afegai Iesu ega imoi fou Jeriko taonina kepuaꞌafuga Ierusaleme taonina kelao alogai, laꞌafou akaikiꞌa isa muniꞌiai kepea. ");
INSERT INTO mek_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Amoisa! Egaꞌina alogai maakimiꞌi auꞌi auniꞌi keaga niegai Iesu epea pagai aꞌo kelogonia aisama, keagaga keinaka, “Lopia, Davide okogai lomai aumu, guamai moania,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kai laꞌafou papiauꞌi isa kefinaiꞌi komo kegaoma keoma. Kai isa keagaga alogaina paisa keinaka, “Lopia, Davide okogai lomai aumu, guamai moania,” keoma pugu. ");
INSERT INTO mek_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ega aisama Iesu eapakipo eifaniꞌi kai epaꞌani peniꞌi einaka, “Kapaꞌina anina oani eemiai makapa ooma?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ke isa keinaka, “Lopia, lai anina aani afu amaisa aoma,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iesu isa ega keifa oma ainaꞌi elogonia aisama, guaꞌi eaniia puo maaꞌi eafi opogaina. Ega aisama fiakoa mo maaꞌi felo emia, ke isa muninai kepea. ");
INSERT INTO mek_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Egae kai Iesu ke ega imoi fou kemai Ierusaleme taonina kelaisapia, ke kemai Olifa ikugai Betfake paguagai aisama, Iesu ega imoi auniꞌi eulai kakauꞌi kelao. ");
INSERT INTO mek_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ke epainiꞌi einaka, “Pagua agomiai auga olao ke agokoko mo alogai, egae donki ke gauga aguꞌa fou ufeai kepaaukopaꞌi keapae agoisaꞌi. Isa auniꞌi fogupukiꞌi fomaiseiniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ke aufalao agaꞌo iifa agaꞌo afeifania koa aisama, fopaina Lopia, aniꞌi eani fooma. Ke isa fiakoa mo donki gauga fou agelogoainiꞌi agomaiseiniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Iꞌina kapa emia ega koa profeta Deo ega iifa pukagai kapaꞌina kepapua auga koꞌa emia. ");
INSERT INTO mek_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sion gauga ifiaoga amopaina: ‘Moisa, oi emu kin eemu efai moisa. Isa ifo eꞌele epamia donki laagai eaguka, egaꞌina auga isa donki gauga laagai eaguka efai.’” ");
INSERT INTO mek_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Iesu ega imoi auniꞌi kelao, ke Iesu isa epainiꞌi koa iꞌopoga mo kekapaisa. ");
INSERT INTO mek_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ke donki gauga fou kemaiseiniꞌi, ke afeꞌi tiapuꞌi keafiiꞌi laaꞌiai kepagapu pagainiꞌi, ke Iesu donki agaꞌo laagai eaguka. ");
INSERT INTO mek_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ke laꞌafou akaikiꞌa ipauma papiauꞌi afeꞌi tiapuꞌi keagai kekauniꞌi, ke isaꞌi au agaꞌi kefouꞌi keagai kelapaiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Egae kai laꞌafou papiauꞌi keufai kepea auꞌi, ke muniai kepea auꞌi keagaga keinaka, “Hosana, Davide okogai emai auga amaau afagaina!” “Lopia akagai emai auga, Deo eegai kapa feloꞌi eafiꞌi!” “Auꞌoniai keagu auꞌi, Hosana kegaoma isa kegaau afagaina!” keoma. ");
INSERT INTO mek_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ke Iesu elao Ierusaleme taoninai ekoko aisama, taoni alogai keagu papiauꞌi maꞌoai aꞌoaꞌo akaikiꞌa kekapaisa, ke kepaꞌani keinaka, “Iꞌina kaisau?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ke laꞌafou papiauꞌi Iesu muninai kemai auꞌi keinaka, “Iꞌina auga Iesu profeta auga, Kalilea agogai Nasareta taoninai emai auga,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ke Iesu elao Deo ega eꞌai ekoko. Ke egae papiau amu keꞌafaꞌi auꞌi, ke keꞌafaꞌafalainiꞌi auꞌi fou euokaꞌi. Ke moni keau pagainia papiauꞌi eꞌi teipolo, ke keagu koofi ineiꞌi keogeꞌi keꞌafaꞌafalainiꞌi teipoloꞌi isafa epaefo pagainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ke egaꞌina papiauꞌi epainiꞌi einaka, “Deo ega iifa pukagai profeta Deo aina fouga iina kepapua oma, ‘Lau eꞌu eꞌa akeifaga megamega eꞌa’ akeoma. Kai oi ‘iꞌina eꞌa painao auꞌi eꞌi aguagu afuga opamia,’” eoma. ");
INSERT INTO mek_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ke maakimiꞌi auꞌi, ke melo auꞌi fou Deo ega eꞌa Iesu eega kemai ke isa epafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kai sakedote lopiaꞌi, ke Moses ega iifa pamalelega auꞌi, Iesu kapa akaikiꞌaꞌi ekapaiꞌi keisa, ke imoi keagaga, ‘Hosana, Davide okogai emai auga amaau afagaina,’ keoma ainaꞌi kelogonia aisama, guaꞌi ekupu alogaina. ");
INSERT INTO mek_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ke Iesu kepaꞌani penia keinaka, “Imoi kapaꞌina keifania auga ainaꞌi lologo ma?” keoma. Ke Iesu einaka, “E, lau isa kapaꞌina keifania auga ainaꞌi lalogo. Kai Deo ega iifa pukagai kepapua keifa, ‘Oi imoi eꞌeleꞌi, ke imoi uꞌuai auꞌi fifinaꞌiai au afagai loogeisa keifaniꞌi,’ keoma auga fouga, alokuapina ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ke epuaꞌafuniꞌi epealai elao Betani taoninai, ke gapiai egae efeu. ");
INSERT INTO mek_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Egani amagai ipauma Iesu emue Ierusaleme taonina elao pugu alogai inaega ekimu. ");
INSERT INTO mek_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ke fik auga agaꞌo keaga niegai eapa eisa puo, elao anina agaꞌo ekae ma auga gaisa eoma. Kai anina agaꞌo aeisa kai gagauga mo eisaꞌi aisama eifa einaka, “Oi animu agaꞌo foloogeoge pugu,” eoma. Ke fiakoa mo au eogogo. ");
INSERT INTO mek_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Iesu ega imoi fik auga eogogo keisa aisama, kekauai alogaina ke kepaꞌani keinaka, “Ala koa iꞌopoga fik auga eogogo efiaisakoa mo?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ke Iesu einaka, “Iifa koꞌa maamiai laifania. Oi lau kapaꞌina laifania auga agopakoꞌania ke opomi gua afaemia koa aisama, pau fik auga eegai kapaꞌina lakapaisa auga mo afolokapa kai iku iꞌina isafa agopaina, ‘Ifomu molao aꞌuai moꞌafolaiso,’ agooma aisama, oifania koa iꞌopoga agemia. ");
INSERT INTO mek_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ke megamegai kapaꞌina Deo ogoina gapenimi ooma auga alomi koꞌagai agopakoꞌania koa aisama, kapa maꞌoai agoafiꞌi paisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ke Iesu Deo ega eꞌa alogai ekoko ke egae epapamalele laolao kai, sakedote lopiaꞌi ke Iudea au akaikiꞌaꞌi auꞌi fou kemai Iesu eegai kai kepaꞌani penia keinaka, “Isapu kapagai iꞌina kapaꞌi lokapaꞌi? Ke kai isapu epeniio ega koa lokapa?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ke Iesu einaka, “Lau isafa oi paꞌani agaꞌomo alapaꞌani penimi. Ke afa agopamue koa aisama, egae kai lau isapu kapagai iꞌina kapaꞌi lakapaꞌi auꞌi fouꞌi maamiai alaifania. ");
INSERT INTO mek_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ioane baptismo epipeni auga isapuga kapai emai? Ufai Deo eegai emai, o papiau aumauni eeꞌiai emai?” eoma. Ega aisama ifoꞌi mo epoꞌiai keifa keinaka, “Iꞌa Ioane ega isapu ufai emai agaoma koa aisama, isa iꞌa agepaꞌani peniꞌa, ‘Ega koa aisama, kapa puo isa alopakoꞌania?’ ageoma. ");
INSERT INTO mek_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kai iꞌa agaifa, isa ega isapu papiau aumauni eeꞌiai emai agaoma koa aisama, papiau Ioane profeta auga keoma puo, amaniꞌi ega afalaifa oma,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ega puo isa keinaka, “Lai alalogo,” keoma. Ega aisama Iesu isa epainiꞌi einaka, “Ega koa aisama, lau isafa isapu kapagai iꞌina kapaꞌi lakapaꞌi auga, oi maamiai afalaifania,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Egae kai Iesu palapole agaꞌo eifania einaka, “Oi ala oopola oma? Au agaꞌo gauga maguaeꞌi auniꞌi fou keagu. Kina agaꞌo isa elao gauga faꞌaniauga epainia einaka, ‘Gau, pau folao lau eꞌu fino umagai fopinauga,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Kai isa einaka, ‘Lau afalalao afalapinauga,’ eoma kai, muniai eopo pagai elao epinauga. ");
INSERT INTO mek_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Egae kai au egaꞌina elao gauga faꞌaniauga epaina koa iꞌopoga mo, gauga agaꞌo isafa ega epaini oma. Ke gauga egaꞌina einaka, ‘Au akaikiꞌa aumu, alalao alapinauga,’ eoma kai aelao aepinauga. ");
INSERT INTO mek_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Au gauga auniꞌi epoꞌiai, kapa auga ama kapaꞌina anina eani auga ekapaisa?” eoma. Ke isa keinaka, “Gauga faꞌaniauga auga,” keoma. Ega aisama Iesu isa epainiꞌi einaka, “Iifa koꞌa maamiai laifania, tax isafina auꞌi, ke peage lapau papieꞌi auꞌi fou keufai oi agomiai Deo ega agofaꞌai kekoko. ");
INSERT INTO mek_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Gome Ioane emai alo opai keagaga epakinaimi kai, oi isa alopakoꞌania kai, tax isafina auꞌi, ke peage lapau papieꞌi fou mo isa kapaꞌina eifania auga kepakoꞌania. Kai oi auga egaꞌina kapaꞌi oisaꞌi mo ganinagai, emi laomai apalaꞌi alopuaꞌafuniꞌi, ke isa alopakoꞌania,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ke Iesu eifa pugu einaka, “Ainami amopaaua palapole agaꞌo alaifania aꞌo amologo. Ega kinagai ago inagome auga agaꞌo ega fino uma agaꞌo ekapaisa. Egae kai pou fagapuga ekapa lofe, ke fino ikapa afuga isafa eapiia, ke au fekeapa afu fekeꞌima auga taoaga epaapa. Ke kapa maꞌoai epafuaꞌi aisama, uma alogai kepinauga papiauꞌi isaꞌi epaꞌimaꞌi kepapinaugania. Kai isa ifo auga ekailai afu agoma agaꞌo elao. ");
INSERT INTO mek_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ke fino iꞌafe kina ekainia aisama, ago inagome auga ega pinauga auꞌi eulaiꞌi kelao uma epaꞌimaꞌi auꞌi eeꞌiai ega fino anina afa kegaafia eoma. ");
INSERT INTO mek_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Kai uma keꞌima auꞌi, isa ega pinauga auꞌi keafi apalaniꞌi, agaꞌo keauniia, agaꞌo keaupugua, ke agaꞌo kepoai kefounia. ");
INSERT INTO mek_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ega aisama ega pinauga auꞌi eulai kakauꞌi auꞌi koa laaꞌi kai, pau auga isa auꞌi kekaꞌegaina auꞌi eulaiꞌi kelao kai, uma keꞌima auꞌi isa isafa faagaꞌiai ega koa kekapaisa. ");
INSERT INTO mek_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ke fuagai aisama, ifo gauga eulaisa elao. Ke eifa einaka, ‘Laopolaga lau gau au akaikiꞌa akepamia,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Kai fino uma keꞌima auꞌi isa gauga keisa aisama, ifoꞌi mo keifa keinaka, ‘Iꞌina auga ago inagome auga gauga puo ago inagome agemae aisama, iꞌina ago isa apuga agemia. Ega puo amaaupugua ega koa iꞌina ago muni isa apuga femia koa auga, iꞌa apuꞌa agemia,’ keoma. ");
INSERT INTO mek_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ke keafiia fino uma afegai keꞌafolaisa kai keaupugua. ");
INSERT INTO mek_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ega puo uma inagome agemai aisama, uma keꞌima auꞌi faagaꞌiai kapaꞌina agekapa?” ");
INSERT INTO mek_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ke isa keinaka, “Isa egaꞌina auꞌi apalaꞌi puo agepalifu afeꞌainiꞌi. Egae kai papiau feloꞌi muni fino anina iꞌafe kina agekaina aisama, anina afa akeafia isa akepenia auꞌi fino uma egaꞌina agepeniꞌi akeꞌima,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ke Iesu isa epainiꞌi einaka, “Oi Deo ega iifa pukagai iꞌina iifaga alokuapina ma? “‘Eꞌa ipaapa auꞌi kepo uuꞌuga keumakalaina auga, kiuga uuꞌuga kapula ipauma emia. Egaꞌina kapa auga Lopia ifo ekapaisa, ke iꞌa maaꞌaisai egaꞌina kapa felo ipauma.’ ");
INSERT INTO mek_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ega puo egaꞌina iifaga koa iꞌopoga, lau oi maamiai laifa gomeisamo. Deo ega agofaꞌa oi eemiai ageafiꞌaua, ke ageafia papiau kapaꞌi pinauga egaꞌina akekapa felo anina ageoge auꞌi agepeniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“Ke kepo egaꞌina ega isapu akaikiꞌa. Ega puo kaisau egaꞌina kepo ageumakalaina afaepakoꞌania auga, ega laomai apala afa ageafia. Egaꞌina auga kapa agaꞌo kepo laagai eꞌualai emuꞌamuꞌa koa iꞌopoga, isa kepo egaꞌina laagai ageꞌualai ageaumuꞌa agelifu afeꞌai. Ke kaisau ega laomai apala afa puogai, kepo egaꞌina isa laagai ageꞌualai aisama, isa agemuꞌamuꞌa agelifu afeꞌai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sakedote lopiaꞌi ke Faliseo auꞌi Iesu ega palapole aꞌo kelogonia aisama, Iesu isa fouꞌi eifania auga kelogo. ");
INSERT INTO mek_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ega puo keaga agaꞌo kekapunia kegaafia kegagope keoma. Kai laꞌafou papiauꞌi Iesu profeta agaꞌo auga kepakoꞌania puo, kemaniꞌiainiꞌi kapa agaꞌo akekapaisa. ");
INSERT INTO mek_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ke Iesu palapole agaꞌo isa maaꞌiai eifania pugu einaka: ");
INSERT INTO mek_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Deo ega agofaꞌa auga, kin agaꞌo gauga ega amagelofe miamiaga ekapa koa iꞌopoga. ");
INSERT INTO mek_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Isa ega pinauga auꞌi eulaiꞌi kelao papiau iifa epeniꞌi miamia fekemai eoma auꞌi fekepainiꞌi fekemai eoma. Kai egaꞌina papiauꞌi mai anina akeani. ");
INSERT INTO mek_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ke ega pinauga auꞌi iꞌoiꞌi eulaiꞌi kelao pugu kai, epainiꞌi einaka, ‘Olao papiau kapaꞌi mo iifa lapeniꞌi auꞌi fopainiꞌi, gapigapi foꞌamaga lapafua ekae fooma. Ke lau eꞌu polomakau maguaega apaoga, ke eꞌu aꞌo kefaꞌa auꞌi fou keaupuguꞌi keifaiꞌi kefua kekae, ke kapa maꞌoai isafa kefua kekae. Ega puo amagelofe miamiaga fomai fooma,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Kai papiau egaꞌina epoꞌiai kai agaꞌo isa ega iifa gefa aeaunia. Agaꞌo elao ega agoai epinauga, ke agaꞌo elao ega titoai ega amu eꞌafaꞌafalainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ke iꞌoiꞌi isaꞌi auꞌi kin ega pinauga auꞌi egaꞌina keafiiꞌi keauniiꞌi, keafi apalaniꞌi, ke keaupuguiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kin egaꞌina fouga elogo aisama, gua ekupu alogaina. Ke ega ifani auꞌi eulaiꞌi kelao auau auꞌi egaꞌina keaupugu afeꞌainiꞌi, ke eꞌi taoni keumaisa. ");
INSERT INTO mek_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Egae kai ega pinauga auꞌi epainiꞌi einaka, ‘Amagelofe miamia kina ekainia kai iifa lapeniꞌi fekemai laoma auꞌi iina fekemai auga laisaꞌi aekainia. ");
INSERT INTO mek_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ega puo olao keaga kiuꞌiai kai mo egae agoisaꞌi auꞌi iifa fopeniꞌi iꞌina miamia fekemai,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ega puo pinauga auꞌi kelao keagai papiau kapaꞌi mo egae keisaꞌi auꞌi, feloꞌi apalaꞌi fou maꞌoai kepainiꞌi kemai. Ke miamia kemai auꞌi amagelofe miamiaga afuga egaꞌina ake kepapogua. ");
INSERT INTO mek_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Kai kin emai miamia kemai auꞌi gaisaꞌi eoma aisama, epoꞌiai au agaꞌo amagelofe tiapuga aeꞌiuka eisa. ");
INSERT INTO mek_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ke epaꞌani penia einaka, ‘Ekefaꞌau, oi amagelofe tiapuga aloiꞌiuka kai ala looma inae lokoko?’ eoma. Kai au egaꞌina iifa agaꞌo aeifania. ");
INSERT INTO mek_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ega aisama kin ega pinauga auꞌi epainiꞌi einaka, ‘Amoafia ima ife amogopeꞌi kai afegai uminagai amoꞌafolaisa. Egae isa ageapepe nie ageapalolia,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Egae kai Iesu eifa einaka, “Isa ega ekapa oma, gome Deo papiau maꞌo iifa epeniiꞌi ega miamia fekelao eoma kai, ekinaniꞌi auꞌi auga, auꞌi maꞌo laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Egae kai Faliseo auꞌi kepealai kelao iifa kepaapa, Iesu ifo ega niniꞌaniai fekepaoa keoma. ");
INSERT INTO mek_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ke isa eꞌi imoi, ke Herod ega au fou keulaiꞌi kelao Iesu kepaꞌani penia keinaka, “Pamalele aumu, lai alogo oi auga iifa koꞌa mo loifania. Ke iifa koꞌagai mo Deo ega keaga papiau lopamaleleniꞌi. Ke papiau oi eemuai ala keopola oma auga gefa aloauga. Gome oi papiau afeꞌi aloisa. ");
INSERT INTO mek_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ega puo lai oi apaꞌani penio. Sisa tax fapenia auga ekainia o aekainia ma auga moifania amalogo aoma?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kai Iesu isa eꞌi opola apalagai kepaꞌani auga elogo puo epainiꞌi einaka, “Pifoge aumi. Kapa puo lau oꞌopoisau? ");
INSERT INTO mek_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Silifa monina oafia tax oogeoge auga amopakinaisau,” eoma. Ke au egaꞌina denari monina agaꞌo keafiia kepeniia. ");
INSERT INTO mek_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ke Iesu egaꞌina monina eafiia epakinaꞌi kai epaꞌani peniꞌi einaka, “Iꞌina faagagai kai lalauga, ke kai aka ekae?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ke isa keinaka, “Sisa,” keoma. Ega aisama Iesu isa epainiꞌi einaka, “Ega puo kapaꞌina Sisa apuga auga Sisa fopenia, ke kapaꞌina Deo apuga auga Deo fopenia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Isa Iesu ega eifa oma aina kelogonia aisama, kekauai alogai keopofua. Ke Iesu kepuaꞌafuga kekailai kelao. ");
INSERT INTO mek_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ke egaꞌina kinagai mo, Saduseo auꞌi papiau maeai afakemaunimue keoma auꞌi, Iesu paꞌani agaꞌo kegapaꞌani penia keoma kemai eegai. ");
INSERT INTO mek_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ke kepainia keinaka, “Pamalele aumu. Moses ega iifa alogai eifa, au agaꞌo ageamage kai gauga agaꞌo afaepamauga agemae koa aisama, aafuga isa akina feakafania ega koa au emae auga gauga agaꞌo femauni eoma. ");
INSERT INTO mek_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pau lai epomaisai oꞌoae auꞌi imagea gua keagu. Faꞌaniauga eamage kai imoi laaꞌi emae. Ega puo akafa epuaꞌafuga isa akina egaꞌina papiega eakafania. ");
INSERT INTO mek_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kai isa isafa ega koa iꞌopoga mo faagagai emia, ke isa muninai emauni auga isafa ega koa faagagai emia. Ega mo eoma elao eke afifua auga faagagai efua. ");
INSERT INTO mek_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ke fuagai papie isafa emae. ");
INSERT INTO mek_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ega puo papiau akemaunimue pugu aisama, kaisau auga papie akafa ipauma agemia? Gome isa maꞌoai papie egaꞌina keakafania,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kai Iesu einaka, “Oi Deo ega iifa alologo ke ega isapu ala koa auga isafa oko alologo puo, oapagea efua. ");
INSERT INTO mek_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Papiau maeai akemaunimue aisama, afakeamage ke afakepaamageniꞌi kai, isa auga ufa ageloꞌi koa iꞌopoꞌi akemia. ");
INSERT INTO mek_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ke Deo papiau maeai akemaunimue fouga oi maamiai eifania auga, ega iifa puka alogai alokuapina ma? ");
INSERT INTO mek_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Abraham, Aisak, ke Iakobo ufainagai kemae mo ganinagai, Deo ago alogai lo eufa auga alogai Moses eapakina penia aisama eifa, ‘Lau Abraham, Aisak, ke Iakobo fou eꞌi Deo,’ eoma. Ega puo Deo auga kemae umamo auꞌi eꞌi Deo laaꞌi kai, kemae kai keague auꞌi eꞌi Deo,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Laꞌafou papiauꞌi iꞌina pamalelega aꞌo kelogonia aisama, kekauai alogaina. ");
INSERT INTO mek_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kai Faliseo auꞌi Iesu Saduseo auꞌi akeꞌi eafunia fouga kelogo aisama, isa kelao kelaꞌafou. ");
INSERT INTO mek_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Egae kai pamalele auga Moses ega iifa elogo felo auga agaꞌo, Iesu eꞌopoisa, iina epaꞌani peni oma einaka: ");
INSERT INTO mek_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Pamalele aumu. Moses ega iifa kapulaꞌi aloꞌiai iifa kapa auga akaikiꞌa ipauma?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ke Iesu einaka, “‘Oi alomu koꞌagai, guamu fofougai, alomu fofougai, ke imaaumu fofougai emu Lopia Deo anina foani.’ ");
INSERT INTO mek_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iꞌina iifaga auga eufai, ke iifa akaikiꞌa ipauma. ");
INSERT INTO mek_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ke iifa gua auga, eufai auga fou afaꞌagamo iꞌopoꞌi mo koa iꞌopoga. Egaꞌina auga, oi alomu koꞌagai ifomu animu loani koa iꞌopoga, emu eꞌa ipafe auga anina ega foani oma. ");
INSERT INTO mek_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moses ega iifa ke profeta maꞌoai eꞌi iifa, iꞌina iifaꞌi auniꞌi aloꞌiai kekae,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Ke Faliseo auꞌi egae kekaigugu keapaega kai, Iesu isa epaꞌani peniꞌi einaka, “Oi Mesaia eegai ala oopola oma? Ke isa kaisau gauga ooma?” eoma. Ke isa keinaka, “Isa auga Davide okogai agemai auga,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Ega aisama Iesu isa epainiꞌi einaka, “Ala koa iꞌopoga, Davide Deo ega Spirituai eniniꞌani aisama, isa Mesaia eifaga ‘Lopia’ eoma? Gome isa eifa, “‘Lopia lau eꞌu Lopia epainia einaka: “Kaiuai moagu felaolao, oi emu ou auꞌi ifemu guagai alaogeꞌi alogafapiꞌi,” ’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davide isa eifaga Lopia eoma koa aisama, ala koa iꞌopoga isa Davide okogai agemai?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kai isa epoꞌiai kai agaꞌo iifa agaꞌo aeifania Iesu ega paꞌani afa aepamue. Ke egaꞌina kina afegai, kemaniꞌi kai agaꞌo isa paꞌani agaꞌo aepenia pugu. ");
INSERT INTO mek_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Egae kai Iesu laꞌafou papiauꞌi ke ega imoi fou epainiꞌi einaka: ");
INSERT INTO mek_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Moses ega iifa pamalelega auꞌi, ke Faliseo auꞌi fou auga Moses afuga keafia, ke isa iifa papiau kepeniꞌi kaiꞌiai fekepea keoma. ");
INSERT INTO mek_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ega puo oi isa ainaꞌi foafia, ke kapa maꞌoai kepainimi fokapaꞌi keoma auꞌi fokapaꞌi. Kai kapaꞌina kekapa auga folokapa, gome isa kapaꞌina keifania auga akekapa. ");
INSERT INTO mek_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ke isa meau akaikiꞌa keꞌofa papiau fagoꞌiai keogeaua kepua, ke meau iꞌoina iꞌoina papiau kepeniꞌi kaiꞌiai kegapea keoma. Kai ifoꞌi akelogoainiꞌi imaꞌi kekeꞌe agaꞌomo mo ganinagai akeafiakae, egaꞌina papiauꞌi akepalagainiꞌi fagoꞌiai meau akeafiopua. ");
INSERT INTO mek_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Kai isa kapa maꞌoai kekapaꞌi auga, papiau fekeisaꞌi keoma puo kekapaꞌi. Ega puo isa feꞌa eꞌele Deo ega iifa faagagai kepapua auga akaikiꞌa kepamia kai kaniaꞌiai o fagoꞌiai keoge. Ke afeꞌi tiapuga kuagai ufe koa iꞌopoꞌi kepaꞌau opuꞌi, tiapu kepakaikaiꞌi auꞌi kepamaefa alogainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ke anina keani miamia kinaꞌiai ke Iudea papiauꞌi eꞌi laꞌafou afuꞌiai au akaikiꞌaꞌi keaguagu auꞌi mo afuꞌiai fekeagu keoma. ");
INSERT INTO mek_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ke anina keani afaꞌafa afuꞌiai papiau isa fekepamegoniꞌi keoma. Ke anina keani, papiau isa fekeifaniꞌi ‘Rabai’ fekeomaꞌi keoma. ");
INSERT INTO mek_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Kai oi auga fakeifanimi ‘Rabai,’ fakeoma, gome oi emi Pamalele Auga agaꞌomo. Ke isa auga Kristo. Ke oi maꞌoai auga isa papagai ke oi maꞌoai aami akimi. ");
INSERT INTO mek_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ke aagoai kai agaꞌo foloifaga ‘amau’ folooma, gome oi Amami koꞌa ipauma agaꞌomo, ke isa auga ufai eague. ");
INSERT INTO mek_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Egaꞌina mo laaꞌi kai, kai agaꞌo oi fakeifanimi pamalele aumi fakeoma. Gome oi emi pamalele auga agaꞌomo, ke egaꞌina auga Kristo. ");
INSERT INTO mek_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kai oi epomiai kaisau akaikiꞌa ipauma auga, oi emi pinauga auga agemia. ");
INSERT INTO mek_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Gome kaisau ifo akaikiꞌa epamia auga, Deo isa au eꞌele agepamia. Kai kaisau ifo eꞌele epamia auga, Deo isa au akaikiꞌa agepamia. ");
INSERT INTO mek_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Moses ega iifa pamalelega aumi ke Faliseo aumi fou pifoge aumi! Deo oi afa apala fepenimi laoma! Gome oi papiau Deo ega agofaꞌai fekekoko auga paꞌafina okupuga. Ega koa okapa oi ifomi alokoko, ke papiau egae kegakoko keoma auꞌi isafa alologoainiꞌi akekoko. ");
INSERT INTO mek_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Moses ega iifa pamalelega aumi ke Faliseo aumi fou pifoge aumi! Deo oi afa apala ipauma fepenimi laoma! Gome oi ago maꞌoai ke aꞌu afuꞌi maꞌoai opafuaꞌi kai, papiau agaꞌomo alo opaponia munimiai epea. Ke isa oi fou omia aisama, oi isa opalifu alogaina, ke oi isa tiapolo gauga opamia. Ke oi emi laomai apala auga agaꞌomo mo koa iꞌopoga kai, isa ega laomai apala auga gua koa iꞌopoga emia, oi emi laomai apala ekaꞌegaina. ");
INSERT INTO mek_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Moses ega iifa pamalelega aumi ke Faliseo aumi, oi auga maakimiꞌi auꞌi koa iꞌopomi papiau opapea meꞌeꞌi aumi! Deo oi afa apala fepenimi laoma! Gome oi papiau opainiꞌi oifa, aufalao agaꞌo Deo ega eꞌa akagai pakoꞌa niniꞌanina agekapa auga kapa agaꞌo laaꞌi ooma. Kai isa Deo ega eꞌa alogai gold eka auga akagai pakoꞌa niniꞌanina agekapa aisama, egaꞌina niniꞌanina isa egope koa iꞌopoga puo laaꞌi agepamia afaekaina ooma. ");
INSERT INTO mek_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Oi kafoꞌo maakimiꞌi aumi! Kapaꞌina auga kapa akaikiꞌa: Gold, o Deo ega eꞌa gold epalolofania auga kapa akaikiꞌa? ");
INSERT INTO mek_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ke oi iina oifa oma isafa, ‘Aufalao agaꞌo Deo amu opaꞌa penia afugai pakoꞌa niniꞌanina agekapa auga kapa agaꞌo laaꞌi ooma. Kai aufalao agaꞌo pipeni amuga egaꞌina afugai ekaega auga laagai pakoꞌa niniꞌanina agekapa auga, egaꞌina niniꞌanina isa egope koa iꞌopoga puo laaꞌi agepamia afaekaina,’ ooma. ");
INSERT INTO mek_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Oi maakimiꞌi aumi! Kapaꞌina auga kapa akaikiꞌa: pipeni amuga, o Deo amu opaꞌa penia afuga pipeni epalolofania auga kapa akaikiꞌa? Iifa koꞌa Deo amu opaꞌa penia afuga auga kapa akaikiꞌa. ");
INSERT INTO mek_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ega puo kaisau Deo amu kepaꞌa penia afugai eapa pakoꞌa niniꞌanina ekapa auga, afu egaꞌinagai mo pakoꞌa niniꞌanina aekapa kai kapa maꞌoai egae kekae auꞌi isafa laaꞌiai pakoꞌa niniꞌanina ekapa. ");
INSERT INTO mek_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ke kaisau Deo ega eꞌa akagai pakoꞌa niniꞌanina ekapa auga, eꞌa mo akagai pakoꞌa niniꞌanina aekapa kai, Deo egae alogai eague auga isafa akagai pakoꞌa niniꞌanina ekapa. ");
INSERT INTO mek_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ke ufa auga Deo ega aguagu afuga. Ega puo kaisau ufa akagai pakoꞌa niniꞌanina ekapa auga, Deo ega aguagu afuga, ke Deo egae eague auga akagai pakoꞌa niniꞌanina ekapa. ");
INSERT INTO mek_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Moses ega iifa pamalelega aumi, ke Faliseo aumi auga pifoge aumi! Deo oi afa apala fepenimi laoma! Gome oi emi foꞌama gamuga feloꞌi fekepamiaꞌi kapaꞌi auꞌi ouꞌaga alogai, agaꞌomo oafilaisa Deo opalao penia. Egaꞌina kapaꞌi akaꞌi mint, dill ke cummin. Kai oi Moses ega iifai kapa akaikiꞌaꞌi fouꞌi eifaniꞌi auꞌi oumakalainiꞌi. Egaꞌina auga oi papiau eeꞌiai Deo maagai laomai felo fokapa, ke papiau guaꞌi foania. Ke oi Deo fopakoꞌania. Oi Moses ega iifa muniai laifaniꞌi auꞌi fokapaꞌi, ke kapaꞌina okapa kakaua auga isafa foloumakalaina fokapa. ");
INSERT INTO mek_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Oi maakimiꞌi auꞌi koa iꞌopomi, papiau opapea meꞌeꞌi. Oi emi apala Deo maagai auga, kaputi alogai aguma koa iꞌopoga eꞌele eka oisa aisama, oafilaisa. Kai emi apala Deo maagai akaikiꞌa ipauma kamelo koa iꞌopoga mo ganinagai, kaputi alogai eka oisa kai, aloisa koa iꞌopoga oinu okogopa. Ega koa okapa, kapa eꞌeleꞌi muniꞌiai opea kai, Deo maagai kapa akaikiꞌa auga oumakalaina. ");
INSERT INTO mek_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Moses ega iifa pamalelega aumi ke Faliseo aumi fou pifoge aumi! Deo oi afa apala fepenimi laoma! Gome oi afemi, kaputi ke liti afe koa iꞌopoga auga oikua iisa felo ipauma. Kai oi alomi, kaputi liti fou aloꞌi koa iꞌopoga auga aloikua eofu afeꞌai. Oi alomi auga aꞌao epogu, ke kapa maꞌoai apalaꞌi omaaniꞌi auꞌi, ke kapa oi alomi fekepagama alogaina auꞌi mo oi alomi epogu. ");
INSERT INTO mek_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Faliseo aumi, maami ekimiꞌi! Kaputi ke liti aloꞌi foiku kakaua kai, afeꞌi isafa felo agemia. ");
INSERT INTO mek_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Moses ega iifa pamalelega aumi ke Faliseo aumi fou pifoge aumi! Deo oi afa apala fepenimi laoma! Gome oi afemi auga, la keꞌima felo iisa felo ipauma koa iꞌopoga. Kai alomi auga, la alogai kapa ofuꞌi maꞌoai, ke papiau agaꞌo imaauga efoka, ke uniaga mo ekae koa iꞌopoga. ");
INSERT INTO mek_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ega koa iꞌopoga, papiau eeꞌiai oi afemiai auga, alo opai papiaumi koa iꞌopomi. Kai alomi auga, pifoge ke laomai apalaꞌi ipaumaꞌi epogu. ");
INSERT INTO mek_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Moses ega iifa pamalelega aumi, ke Faliseo aumi fou pifoge aumi! Deo oi afa apala fepenimi laoma! Gome oi profeta ke alo opai auꞌi kemae auꞌi fou eꞌi la okapaiꞌi ke opakaikaiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ke oifa oinaka, ‘Lai ufumai apamai miaꞌiai amaagu koa aisama, lai isa fou agaꞌomo falamia profeta egaꞌina ifaꞌi falapafaka,’ ooma. ");
INSERT INTO mek_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Oi ega ooma puo, oi ifomi papiau profeta egaꞌina keaupuguꞌi auꞌi oi ufumi apami auga koꞌa mo oifafoua. ");
INSERT INTO mek_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ke oi ufumi apami laomai apala keꞌinaisa auga laagai amoapau amopafua. ");
INSERT INTO mek_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Oi auga kaapa ke kaapa apala ipauma auga gauga aumi! Oi ipeliai emi laomai apala afa foafia auga eegai ala agopiaukoko oma? ");
INSERT INTO mek_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Oi ufumi apami laomai apala keꞌinaisa auga laagai foapau fopafua laoma puo lau profeta, ikifa auꞌi, ke eꞌu iifa pamalelega auꞌi laulaiꞌi eemi kefai. Egaꞌina papiauꞌi epoꞌiai isaꞌi agoaupuguꞌi, ke isaꞌi kolotiai agoauꞌuꞌuꞌi. Ke isaꞌi emi laꞌafou afuꞌiai agogapukiꞌi, ke isaꞌi auꞌi agoulaꞌi taoni agaꞌo agaꞌo aloꞌiai agokoko agofai agolaoaina. ");
INSERT INTO mek_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ega koa agokapa, aagoai papiau aloꞌi opaina auꞌi ifaꞌi efaka auꞌi maꞌoai eꞌi puo oi agopuo. Egaꞌina auga pau mo okapa auga mo laaꞌi kai, Apele faagagai ageꞌina agemai, Berakaia gauga, profeta Sakaraia Deo ega eꞌa, ke aꞌo Deo opaꞌa penia afuga fou epoꞌiai keaupugua auga isafa eꞌi puo oi agopuo. ");
INSERT INTO mek_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Iifa koꞌa maamiai laifania, egaꞌina kapaꞌi maꞌoai oi pau oague aumi faagamiai akemia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Egae kai Iesu Ierusaleme taonina eisa gua eaniia puo epapinapina einaka, “O Ierusaleme, Ierusaleme! Ierusaleme taoninai oagu papiaumi. Oi profeta oaupuguiꞌi, ke Deo papiau eemiai eulaiꞌi auꞌi isafa kepoai ofoupuguiꞌi. Ke oꞌolo ina papiega gauga epakai guguainiꞌi panina papagai epakaisogoniꞌi koa iꞌopoga, lau isafa kina maꞌo alou koꞌagai oi gaumi maafi kaiguguiꞌi laoma kai, oi opamafua anina aloani. ");
INSERT INTO mek_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Maami galao oi emi eꞌa maini emia ekae, kai agaꞌo egae laaꞌi amoisa. ");
INSERT INTO mek_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Gome lau lapainimi. Oi lau afoloisau pugu agelao agoifa, ‘Lopia akagai emai auga Deo eegai kapa feloꞌi eafiꞌi,’ agooma kai agoisau pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu Deo ega eꞌa epuaꞌafuga elao alogai, ega imoi muninai kemai Deo ega eꞌa gaisa keoma kepakina. ");
INSERT INTO mek_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ega aisama Iesu isa epaꞌani peniꞌi einaka, “Iꞌina kapaꞌi maꞌoai oisaꞌi ma? Iifa koꞌa maamiai laifania. Kepo iꞌina eꞌagai oisaꞌi auꞌi, agaꞌomo ganinagai agaꞌo laagai ekauau afoloisa kai maꞌoai akeafiꞌi akepiulaiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Egae kai Iesu elao Olifa ikugai eagu alogai, ega imoi ogefakeai kelao kepaꞌani penia keinaka, “Gaika iꞌina kapaꞌi akemia, ke oi emu mai kina ke agofaꞌa ega fua kinagai gou kapa agemia auga maamaisai moifania?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ke Iesu einaka, “Foisa felo kai agaꞌo faefogeimi. ");
INSERT INTO mek_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Gome papiau maꞌo lau akauai akemai akeifa, ‘Lau Mesaia,’ akeoma, ke maꞌo akefogeꞌi. ");
INSERT INTO mek_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ke oi ifani kemia auga aꞌo agologo, ke ifani akemia auga fouga akeifania aꞌo agologo kai, foisa egaꞌina kapaꞌi aꞌoꞌi agologoniꞌi aisama, folomaniꞌi. Egaꞌina kapaꞌi auga fekemia auga mo akemia kai agofaꞌa ega fua auga muni kai agemai. ");
INSERT INTO mek_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Agofaꞌa fofouga alogai, ago, ago fou akepipaini, ke kin, kin fou akepipaini. Ke kafokau akaikiꞌaꞌi akemai ke magea akaikiꞌaꞌi akemia, afu iꞌoiꞌi iꞌoiꞌi papiauꞌi akepalifuꞌi. ");
INSERT INTO mek_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Iꞌina kapaꞌi akemia auga, papie agaꞌo inaegai gamauni eoma eꞌina ekiekie auga kiekie koa iꞌopoga. ");
INSERT INTO mek_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Egae kai oi akeafimi papiau imaꞌiai akepaaumi, ke isa oi akeafi apalanimi, ke akeaupuguimi. Ke lau akau puogai ago maꞌoai papiauꞌi aloꞌi koꞌagai oi animi afakeani. ");
INSERT INTO mek_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Egaꞌina agemia kinagai, papiau maꞌo eꞌi pakoꞌa akepuaꞌafuga, ke isa ifoꞌi mo epoꞌiai agaꞌo agaꞌo akeꞌafaꞌafalainiꞌi, ke aloꞌi koꞌagai aniꞌi afakeani. ");
INSERT INTO mek_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ke profeta pifogeꞌi maꞌo akeꞌue, papiau maꞌo akefogeꞌi. ");
INSERT INTO mek_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ke laomai apala auga maꞌo agemia papiau maꞌo laomai apalaꞌi akekapaꞌi puo, papiau maꞌo aloꞌi koꞌagai papiau aniꞌi keani auga isapuga agekekeꞌa. ");
INSERT INTO mek_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kai kaisau ageapa kapula mo agelao fuagai auga, kania ageisagamau. ");
INSERT INTO mek_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ke iifa faunina Deo ega agofaꞌa fouga lau laifania auga, agofaꞌa fofouga alogai akeinogonia, ega koa ago maꞌoai papiauꞌi egaꞌina fouga koꞌa auga akeifafoua afegai kai, agofaꞌa ega fua kina agemai. ");
INSERT INTO mek_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ega puo kapa agaꞌo profeta Daniel fouga eifania auga kapa iisa maniꞌina ipauma, Deo eifa ainaꞌau penia auga, afu lolofagai ageapa agoisa aisama, fiakoa mo egaꞌina afuga fopuaꞌafuga femaini. Iꞌina kapaꞌina eifania auga kaisau ekuapina auga oko felogo. ");
INSERT INTO mek_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ke papiau Iudea agogai keagu auꞌi isafa fekepiau iku fekelao. ");
INSERT INTO mek_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ke kaisau mo eꞌa ofaofagai keapa kelaagai auꞌi fakeake eꞌi eꞌa alogai, kapa agaꞌo fakeafia. ");
INSERT INTO mek_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ke agoai kepinauga auꞌi isafa, fakelao eꞌi eꞌai afeꞌi tiapuꞌi fakeafiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ega kinagai papie inaeꞌiai, ke imoi kepaꞌuꞌi auꞌi kina apala ipauma ageafiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kai oi fomegamega ega koa iꞌina kapa inipo aupu, o Deo oau afagaina kinagai faemia. ");
INSERT INTO mek_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Gome egaꞌina kinagai kina apalaꞌi ipaumaꞌi akemia, kiekie akaikiꞌaꞌi akemia. Ke egaꞌina kapa agemia auga, agofaꞌa egama mo alogai kiekie agaꞌo emia emai pau koa iꞌopoga auga laaꞌi, ke muni isafa kiekie agaꞌo egaꞌina kiekiega koa iꞌopoga afaemia pugu. ");
INSERT INTO mek_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ke Lopia kina egaꞌina faefoua ofolaꞌo faepamia koa aisama, kai agaꞌo faeagu. Kai ekinaniꞌi auꞌi fauꞌiai kina egaꞌina agepafoꞌoania. ");
INSERT INTO mek_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ega kinagai aufalao agaꞌo afeifa, ‘Mesaia inamoꞌe, amoisa,’ afeoma, o ‘Mesaia egamoꞌe,’ afeoma koa aisama, aina folopakoꞌania. ");
INSERT INTO mek_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Gome mesaia pifogeꞌi ke profeta pifogeꞌi akeapafoki, gou ke mirakulo akaikiꞌaꞌi akekapaꞌi. Ke afekainiꞌi koa aisama, Deo ekinaniꞌi auꞌi mo ganinagai akefogeꞌi. ");
INSERT INTO mek_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Amoisa! Lau egaꞌina kina aemai koa kai maamiai iꞌina kapaꞌi laifaniꞌi, ega koa oi fofua foagu laoma. ");
INSERT INTO mek_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ega puo aufalao agaꞌo oi afepainimi afeinaka, ‘Isa egae ago maininai,’ afeoma koa aisama, folopealai ago maini fololao. Ke afeifa, ‘Isa inamoꞌe eꞌa alogai eague,’ afeoma koa aisama, aina folopakoꞌania. ");
INSERT INTO mek_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Gome kimage kina eꞌagau afugai eafi auga elao mo kina eake afugai koa iꞌopoga, Papiau Aumauni Gauga ega mai kina auga ega koa iꞌopoga agemia papiau maꞌoai akeisa agekaina. ");
INSERT INTO mek_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Gome mae agaꞌo kapai eka auga, paili isafa egae kekaigugu. Ega koa iꞌopoga, gaika iꞌina kapaꞌi akemia aisama, agologo agofiakoa. ");
INSERT INTO mek_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ke kina apalaꞌi egaꞌina akemia afeꞌiai mo, “‘kina agepaꞌumina, ke gafa afaepoa, miꞌimiꞌi ufai akeaꞌopu, ke ufai kapa maꞌoai akepigugu.’ ");
INSERT INTO mek_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ke ega kinagai Papiau Aumauni Gauga emai auga gouga, ufa guagai agefoki akeisa. Ega aisama aagoai ago fofouga papiauꞌi Papiau Aumauni Gauga akepakoꞌania auꞌi akeapepe akepinapina. Egae kai Papiau Aumauni Gauga isapu, ke eaea akaikiꞌagai ufai apuapuai agemai akeisa. ");
INSERT INTO mek_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ke isa fiꞌi aꞌogai ega agelo ageulaiꞌi akemai, ke isa ameku, afu paniai epua emai afuꞌiai, ufa apiegai akeꞌina akemai akelao ufa apiegai papiau kapaꞌi mo ekinaniꞌi auꞌi akepakai guguainiꞌi.” ");
INSERT INTO mek_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ke Iesu eifa pugu einaka, “Pau oi au aka fik auga faagagai kapaꞌina emia auga foisa fomalele. Isa aga eikina eꞌina gagauga eoge aisama, oi ologo kinafaꞌa kina emai efua ooma. ");
INSERT INTO mek_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ega koa iꞌopoga, oi egaꞌina kapaꞌi akemia agoisaꞌi aisama, fologo egaꞌina kina emai kainagai emi paꞌafi akegai mo ekae fooma. ");
INSERT INTO mek_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Iifa koꞌa maamiai laifania. Pau papiauꞌi akemae koa kai egaꞌina kapaꞌi maꞌoai akemia akeisaꞌi kai akemae. ");
INSERT INTO mek_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ke aagoa ufa fou akefua laaꞌi akemia kai, lau eꞌu iifa auga afaefua laaꞌi afaemia.” ");
INSERT INTO mek_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ke Iesu eifa pugu einaka, “Kai agaꞌo egaꞌina kapa gaika kina, ke kina maaga kapagai agemia auga aelogo. Ke agelo mo ganinagai akelogo, ke Gauga isafa aelogo kai, Amaꞌa Deo mo elogo. ");
INSERT INTO mek_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kai Papiau Aumauni Gauga agemai pugu kina auga, papiau Noa miagai ala kekapa oma koa iꞌopoga mo akekapa. ");
INSERT INTO mek_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Gome Noa miagai kou akaikiꞌa aemai koa kai, papiau keaniani keinu keamage, ke kepaamageꞌi mo elao Noa sikuna alogai ekoko. ");
INSERT INTO mek_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ke isa kapaꞌina agemia auga oko agaꞌo akelogo mo elao, kou akaikiꞌa emai maꞌoai kekogo afeꞌai. Papiau Aumauni Gauga agemai aisama, papiau ega koa iꞌopoga mo akekapa. ");
INSERT INTO mek_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Au auniꞌi agoai kepinapinauga kai, Deo agaꞌo ageafiꞌaua, ke agaꞌo agepuaꞌafuga. ");
INSERT INTO mek_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ke papie auniꞌi palafa ipaikumuꞌa kapa akeafia palafa kepapaikumuꞌa kai, Deo agaꞌo ageafiꞌaua, ke agaꞌo agepuaꞌafuga. ");
INSERT INTO mek_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ega puo fofua foagu isa ega mai pugu kina foꞌima. Gome kina kapagai oi emi Lopia agemai auga alologo. ");
INSERT INTO mek_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kai oi iꞌina iifaga kapaꞌina eifania auga oko fologo: Eꞌa inagome auga painao auga gapiai kina maaga kapagai agemai auga galogo koa aisama, isa ega eꞌa feꞌima puo, painao auga isa ega eꞌa faeaupea. ");
INSERT INTO mek_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ega puo oi fofua foagu, gome oi Papiau Aumauni Gauga agemai kina maaga aloꞌima auga kina maagai agemai. ");
INSERT INTO mek_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ega koa aisama, kaisau auga alo koꞌagai pinauga ekapa, ke ikifa auga? Isa auga isa ega au akaikiꞌa ageoge, isa pinauga auꞌi maꞌoai feꞌimaꞌi isapuga agepenia, ke eꞌi aniani kina maaga agekaina aisama, eꞌi foꞌama isafa fepeniꞌi fekeania eoma auga. ");
INSERT INTO mek_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ke au akaikiꞌa agemue agemai, isa ega pinauga epeniia auga agekapa ageisa aisama, kapa feloꞌi pinauga auga egaꞌina agepenia. ");
INSERT INTO mek_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Iifa koꞌa maamiai laifania, au akaikiꞌa pinauga auga egaꞌina epinauga felo puo, ega kapa maꞌoai isa imagai ageoge ageꞌima. ");
INSERT INTO mek_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kai pinauga auga iina afeifa oma auga amoopolaga, ‘Lau eꞌu au akaikiꞌa elao paakai paakai agemai,’ ageoma. ");
INSERT INTO mek_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ke ageꞌuegekae isa fou kepinauga auꞌi ageauniꞌi, ke ageaniani aage mo, ke inuinu auꞌi fou akeinuinu. ");
INSERT INTO mek_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ke pinauga auga egaꞌina, ega koa agekapa alogai, isa ega au akaikiꞌa aeꞌima kinagai, ke kina maaga kapagai agemai auga aelogo auga kina maagai agemai. ");
INSERT INTO mek_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ega aisama au akaikiꞌa ageoge, pinauga auga egaꞌina ageafia ageau kapulania, ke pifoge papiauꞌi keagu afugai agepaagua, ke egae isa ageapepe, nie ageapalolia. ");
INSERT INTO mek_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Iesu eifa pugu einaka, “Ega kinagai Deo ega agofaꞌa auga iina koa iꞌopoga agemia. Ifiao aguꞌaꞌi faagaꞌi fofouga auꞌi ouꞌaga, au agaꞌo fou akefeufeu auꞌi eꞌi lanepa keafiiꞌi amage mamaga auga kegaisa keoma kelao. ");
INSERT INTO mek_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Egaꞌina ifiaoꞌi epoꞌiai ima auꞌi ikifa ifiaoꞌi kai, ima auꞌi kalaꞌau ifiaoꞌi. ");
INSERT INTO mek_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ke kalaꞌau ifiaoꞌi ima eꞌi lanepa keafiiꞌi kai, oili eo agaꞌo akeafia. ");
INSERT INTO mek_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kai ikifa ifiaoꞌi auga eꞌi lanepa, ke oili oga eꞌeleꞌi aloꞌiai kepaꞌefaukaꞌi keafiiꞌi kelao. ");
INSERT INTO mek_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ke kelao kai amage mamaga auga aepaafiafi aemai puo, maꞌoai keagu keꞌimaisa alogai maaꞌi efeu puo kefeu. ");
INSERT INTO mek_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Isa kefeu elao fafueuꞌo aisama, aufalao agaꞌo eagaga einaka, ‘Amage mamaga auga emai inamoꞌe, opealai omai amoisa,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ega aisama egaꞌina ifiaoꞌi faagaꞌi fofouga auꞌi ouꞌaga, au agaꞌo fou akefeufeu auꞌi kekauai keꞌue eꞌi lanepa kepaafiauꞌi. ");
INSERT INTO mek_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ke kalaꞌau ifiaoꞌi auꞌi ikifa ifiaoꞌi kepainiꞌi keinaka, ‘Lai emai lanepa afaꞌagamo akealo puo, amogafegafe oili afa amopenimai,’ keoma. ");
INSERT INTO mek_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Kai ikifa ifiaoꞌi keinaka, ‘Lai oili afa oi agapenimi aisama, fou kaiꞌalao oili agapapinauga afaekaina. Ega puo oili afalapenimi kai, oi olao kaisau oili keꞌafaꞌafalaina auꞌi eeꞌiai ifomi emi oili amoꞌafa,’ keoma. ");
INSERT INTO mek_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ke isa oili iꞌafa kelaoega kai, amage mamaga auga emai. Ke ifiao oili keafi umamo auꞌi, isa fou amagelofe miamiaga alogai kekoko, ke paꞌafi kekupunia. ");
INSERT INTO mek_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Egaꞌina afegai ifiao ima oili iꞌafa kelao auꞌi isafa kemai keifa keinaka, ‘Lopia, lopia paꞌafi mopaagalaisa lai amai amakoko aoma,’ keoma. ");
INSERT INTO mek_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Kai isa iifa epamue einaka, ‘Iifa koꞌa maamiai laifania. Lau oi kaisau alalogonimi,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Ega puo amu maꞌoai fopafuaꞌi fofua foagu. Gome oi Papiau Aumauni Gauga gaika kina agemai, o kina maaga kapagai agemai auga alologo,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Egae kai Iesu eifa pugu einaka, “Deo ega agofaꞌa auga iina koa iꞌopoga. Au agaꞌo afu agoma galao eoma alogai, ega pinauga auꞌi eifa kaiguguꞌi, ke ega amu isa imaꞌiai epaaua keꞌimaiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Egaꞌina alogai pinauga auga agaꞌo, talent monina ima epeniia, ke agaꞌo talent monina gua mo epeniia, ke agaꞌo auga talent monina agaꞌomo epeniia. Ega koa ekapaisa auga, isa kapa agaꞌo akekapa agekaina eisa auga koa iꞌopoga, moni isafa ega koa epeniiꞌi. Egae kai isa ekailai afu agoma elao. ");
INSERT INTO mek_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Au talent monina ima eafia auga, fiakoa mo elao ega moni egaꞌina epapinauga, ke ima mo laagai eogeaua. ");
INSERT INTO mek_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ke au talent monina gua eafia auga isafa elao, moni egaꞌina epapinauga, ke laagai gua mo eogeaua pugu. ");
INSERT INTO mek_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kai au talent monina agaꞌomo eafia auga elao, apu eapiia ega au akaikiꞌa ega moni egae eogefake efufunia. ");
INSERT INTO mek_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ke kina epo emaefa afegai, au akaikiꞌa egaꞌina emue emai ega pinauga auꞌi eeꞌiai, ke moni epapealaisa isa epeniiꞌi auga oko gapakaisa eoma. ");
INSERT INTO mek_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ega puo au talent monina ima eafia auga, ima mo laagai eogeaua auga fou eafiiꞌi emai kai, eifa einaka, ‘Au akaikiꞌa aumu, oi lau lopakoꞌaniau talent monina ima lopeniiau. Ke lau ima mo laagai laogeaua moisa,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ega aisama isa ega au akaikiꞌa eifa einaka, ‘Oi lopinauga felo, pinauga felo aumu, ke kapaꞌina lapeniio fokapa laoma auga alomu koꞌagai lokapaisa. Ke oi amu oisomo lapeniio auꞌi alomu koꞌagai lokapa feloꞌi. Ega puo kapa maꞌo oi alapenio aloꞌimaꞌi. Ke mai emu au akaikiꞌa ega alogama auga fou amoalogama,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Egaꞌina afegai au talent monina gua eafia auga isafa emai eifa einaka, ‘Au akaikiꞌa aumu, oi lau lopakoꞌaniau talent gua lopeniiau. Ke lau gua mo laagai laogeaua moisa,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ega aisama isa ega au akaikiꞌa iifa epamue einaka, ‘Oi lopinauga felo, pinauga felo aumu, ke kapaꞌina lapeniio fokapa laoma auga alomu koꞌagai lokapaisa. Ke amu oisomo lapeniio auꞌi alomu koꞌagai lokapa feloꞌi. Ega puo lau oi kapa maꞌo alapenio aloꞌimaꞌi. Ke mai emu au akaikiꞌa ega alogama auga fou amoalogama,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Egaꞌina afegai au talent agaꞌomo monina eafia auga emai eifa einaka, ‘Au akaikiꞌa aumu, lau lalogo oi guaꞌinoka aumu, ke kapa agaꞌo alofauga kai aufalao agaꞌo efauga auga anina loafia. Ke kapa agaꞌo aloꞌafoka auga afugai au puaꞌi lopakai guguainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ega puo lamaniꞌi lalao emu talent monina apuai laogefake. Egaꞌina monina oi apumu inamoꞌe moisa,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ke isa ega au akaikiꞌa iifa epamue einaka, ‘Oi apolo ke pinauga apala ipauma aumu! Oi lau kapa agaꞌo alafauga kai anina laafia, ke afu agaꞌogai au ogaꞌi alaꞌafokaꞌi kai aniꞌi laafiꞌi auga lologo ma? ");
INSERT INTO mek_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Oi ega loopola oma koa aisama, lau eꞌu moni panika auꞌi eeꞌiai fooge, ega koa lamue lamai aisama, moni egaꞌina laagai agaꞌo fekeogeaua faafia. ");
INSERT INTO mek_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“‘Isa eegai talent monina agaꞌomo ekaega auga amoafania, au talent monina ouꞌaga eegai kekae auga amopenia. ");
INSERT INTO mek_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gome papiau maꞌoai eeꞌiai amu maꞌo kekae mo ganinagai, maꞌo akeafia, ke eeꞌiai amu akepuapua. Ke kaisau eegai kapa agaꞌo laaꞌi mo ganinagai, kapaꞌina isa eegai ekae auga akeafania. ");
INSERT INTO mek_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ke pinauga auga egaꞌina kapa agaꞌo aepapagama auga amoafia, eꞌa afe uminagai amopiulaisa, egae isa ageapepe nie ageapalolia,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ke Iesu eifa pugu einaka, “Papiau Aumauni Gauga Kin agemia, eaea ke isapu akaikiꞌagai ega agelo aloꞌi elolofa auꞌi maꞌoai fou akemai pugu aisama, isa ega aguagu afugai ageagu, ke ufa eaea ke isapuga akaikiꞌa auga alogai ageaguka agemai. ");
INSERT INTO mek_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Egaꞌina alogai ago maꞌoai papiauꞌi isa agogai akepakai guguainiꞌi, ke sipi iꞌima auga sipi nani fou eꞌeaꞌi aufa afuꞌiai epaapaꞌi koa iꞌopoga, isa papiau agaꞌo agaꞌo ageꞌeaꞌi aufa afuꞌi agepeniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ke isa papiau feloꞌi sipi koa iꞌopoꞌi auꞌi kaina kainai agepaapaꞌi kai, papiau apalaꞌi nani koa iꞌopoꞌi auꞌi lafanina kaina agepaapaꞌi. ");
INSERT INTO mek_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Egae kai Kin ageoge papiau isa kaina kainai keapa auꞌi agepainiꞌi ageinaka, ‘Lau Amau eegai kapa feloꞌi oafiꞌi aumi, oomai agofaꞌa egama mo alogai, lau Amau ega agofaꞌa oi apumi eoma auga amoafia apumi gamia. ");
INSERT INTO mek_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gome lau inaeu ekimu aisama, oi lau kapa agaꞌo openiiau laaniia. Ke aisou ekupu aisama, kapa agaꞌo openiiau lainu. Ke lau au aꞌiu lamia aisama, oi lau oifa kokoisau. ");
INSERT INTO mek_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ke tiapu anina laani aisama, tiapu opaiꞌiukaisau, ke laisafa aisama, oi oꞌimaisau. Ke lau tipulai laagu aisama, omai oisau.’ ");
INSERT INTO mek_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ega aisama alo opai papiauꞌi isa akepaina akeinaka, ‘Lopia, gaika oi inaemu ekimu aisao foꞌama apeniio loaniia, o aisomu ekupu kapa agaꞌo apeniio loinu? ");
INSERT INTO mek_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ke gaika oi au aꞌimu lomia, ke lai oi aifa kokoiso, o tiapu anina loani aisama, tiapu apaiꞌiukaiso? ");
INSERT INTO mek_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ke gaika loisafa aꞌimaiso, o tipulai loagu afai aisao?’ akeoma. ");
INSERT INTO mek_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ke Kin iifa agepamue ageinaka, ‘Iifa koꞌa maamiai laifania. Kapaꞌina mo lau aau akiu eꞌeleꞌi iꞌina agaꞌo eegai okapaisa auga, lau eeuai okapaisa,’ ageoma. ");
INSERT INTO mek_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Egae kai papiau lafanina kaina keapa auꞌi agepainiꞌi ageinaka, ‘Oi Deo afa apala epeniimi aumi, lau eeuai okailai olao, tiapolo ega agelo fou fauꞌiai Deo lo aealoalo afuga ekapaisa efua ekaega auga afugai amokoko. ");
INSERT INTO mek_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gome lau inaeu ekimu kai, oi lau kapa agaꞌo alopeniau alaania, ke aisou ekupu kai, oi kapa agaꞌo alopeniau alainu. ");
INSERT INTO mek_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ke lau au aꞌiu lamia kai, aloifa kokoisau, ke lau tiapu anina laani kai, oi lau tiapu agaꞌo alopaiꞌiukaisau. Ke lau laisafa kai, aloꞌimaisau, ke tipulai laagu kai, alomai aloisau,’ ageoma. ");
INSERT INTO mek_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ega aisama isa isafa iifa akepamue akeinaka, ‘Lopia, gaika oi inaemu ekimu, o aisomu ekupu, o au aꞌimu lomia, o tiapu anina loani, o loisafa, o tipulai loagu aisao kai alapalagainio?’ akeoma. ");
INSERT INTO mek_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ke Kin iifa agepamue ageinaka, ‘Iifa koꞌa maamiai laifania. Kapaꞌina mo lau aau akiu eꞌeleꞌi iꞌina agaꞌo eegai alokapaisa auga, lau eeuai alokapaisa,’ ageoma. ");
INSERT INTO mek_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Egae kai papiau apalaꞌi auꞌi afu aoniamo afa apala ipauma fekeafia auga afuga akelao kai, alo opai papiauꞌi auga, Deo agu pagai maunina epeniꞌi afuga akelao,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Iesu egaꞌina kapaꞌi maꞌoai eifaniꞌi efua aisama, ega imoi epainiꞌi einaka, “Kina auniꞌi mo kekae Pasover miamiaga agemia auga oi ologo. Ke egaꞌina kinagai Papiau Aumauni Gauga papiau imaꞌiai akepaaua kolotiai akeauꞌuꞌua,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Egaꞌina alogai sakedote lopiaꞌi ke Iudea au akaikiꞌa auꞌi fou sakedote lopia faꞌa aka Kaiafas ega eꞌa akaikiꞌagai kekaigugu. ");
INSERT INTO mek_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ke isa keaga agaꞌo kekapunia ogefakeai Iesu fekeafia fekegope, ke fekeaupugua keoma. ");
INSERT INTO mek_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kai keinaka, “Iꞌa miamia kinagai egaꞌina falakapa, o laaꞌi koa aisama, papiau epoꞌiai kelele ke aꞌoaꞌo akaikiꞌa afemia,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Egaꞌina afegai Iesu elao Betani taoninai au agaꞌo aka Saimon, Iesu isa molumolu isafaga eafiia kai, epafelo auga ega eꞌai eagu. ");
INSERT INTO mek_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Egaꞌina alogai papie agaꞌo oga eꞌele alogai oili foga felo ipauma, ke afa akaikiꞌa ipauma auga eafiia emai Iesu eaniani laolao kai, egaꞌina oilina kania eꞌefaisa. ");
INSERT INTO mek_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kai Iesu ega imoi papie ega ekapa oma keisa aisama, guaꞌi ekupu alogaina ke keifa keinaka, “Kapa puo egaꞌina oilina epalifu aagenia mo? ");
INSERT INTO mek_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Gome egaꞌina oilina afa akaikiꞌagai feiꞌafalai ke monina ulalu papiauꞌi ipeniꞌi femia,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kai Iesu isa kapaꞌina keifania auga elogo aisama epainiꞌi einaka, “Kapa puo iꞌina papiega opaakekuania? Ega koa folokapa gome isa kapa felo ipauma lau eeuai ekapaisa. ");
INSERT INTO mek_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Gome ulalu auꞌi auga aufa kina mo eemiai akeagu kai, lau auga oi fou afalaagu mo afaelaolao. ");
INSERT INTO mek_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ke isa oili foga felo iꞌina lau kaniauai eꞌefaisa aisama, lau imaau ifufuga agemia auga, pau ekapa umania mo. ");
INSERT INTO mek_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Iifa koꞌa maamiai laifania. Agofaꞌa fofouga alogai kapai mo iifa faunina lau fou akeinogonia aisama, iꞌina papiega lau faagauai kapaꞌina ekapaisa auga isafa akeopolaga akeifafoua,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Egae kai Iesu ega imoi 12 epoꞌiai agaꞌo aka Judas Iskariot sakedote lopiaꞌi eeꞌi elao. ");
INSERT INTO mek_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ke epaꞌani einaka, “Iesu oi imamiai alapaaua koa aisama, kapaꞌina lau agopeniau?” eoma. Ega puo isa silifa monina 30 kepaauga kepeniia. ");
INSERT INTO mek_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ega aisama egaꞌina kinagai eꞌina keaga agaꞌo ekapunia Iesu sakedote lopiaꞌi imaꞌiai gapaaua eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Egaꞌina afegai palafa ipaufuga mulamula laaꞌi kai, palafa maini mo keania miamiaga aka Pasover kinagai aisama, Iesu ega imoi kemai isa kepaꞌani penia keinaka, “Kapai Pasover miamiaga foꞌamaga fapafua feka foania looma?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ke Iesu einaka, “Olao taoni alogai okoko, egae au agaꞌo agoisa, ke fopaina foinaka, ‘Pamalele auga eifa: Lau eꞌu kina emai ekainia puo, eꞌu imoi fou oi emu eꞌai Pasover miamiaga fakapa eoma fooma.’” ");
INSERT INTO mek_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ega puo Iesu ega imoi kelao Iesu eifania koa kekapaisa, ke egae Pasover foꞌamaga kepafua eka. ");
INSERT INTO mek_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Epagapigapi aisama, Iesu ega imoi 12 fou teipoloai keagukipo kegaaniani keoma. ");
INSERT INTO mek_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ke keaniani laolao kai epainiꞌi einaka, “Iifa koꞌa maamiai laifania. Oi epomiai agaꞌo lau ageꞌafaꞌafalainiau,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ega aisama aloꞌi emafu alogaina, ke keꞌina agaꞌo agaꞌo isa kepainia keinaka, “Lopia, lau ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ke Iesu einaka, “Kaisau lau fou imamai litiai agakaopua auga lau ageꞌafaꞌafalainiau. ");
INSERT INTO mek_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ke Papiau Aumauni Gauga agelao fouga kepapua auga, iꞌopoga mo faagagai agemia. Kai au kapa Papiau Aumauni Gauga ageꞌafaꞌafalaina auga, Deo isa afa apala ipauma agepenia! Kai au egaꞌina faemauni koa aisama, fefelo alogaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ega aisama Judas Iesu ageꞌafaꞌafalaina auga epaꞌani einaka, “Rabai, lau ma?” eoma. Ega aisama Iesu einaka, “E! Oi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ke keaniani laolao kai Iesu palafa eafiia Deo maagai tenkiu eifania, efaipoga ega imoi epeniiꞌi kai einaka, “Amoafia amoania. Inaꞌina lau imaau,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Egae kai fino kaputina eafiia, Deo maagai tenkiu eifania, ega imoi epeniiꞌi kai, eifa einaka, “Maꞌoai amoafia amoinu. ");
INSERT INTO mek_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Iꞌina auga lau ifau, Deo ke papiau fou epoꞌiai pakoꞌa kapula mamaga gouga lakapa auga. Ke iꞌina ifa, Deo papiau maꞌo eꞌi laomai apalaꞌi feꞌagegeainiꞌi puogai agefaka. ");
INSERT INTO mek_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kai maamiai laifania, lau fino puaga iꞌina feina afalainu pugu agelao egaꞌina kinagai lau Amau ega agofaꞌai kai, oi fou fino mamaga againu pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ke Deo isau afagaina iifina keifinia efua aisama, kekailai Olifa ikuga kelao. ");
INSERT INTO mek_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Egae kai Iesu ega imoi epainiꞌi einaka, “Iꞌina gapinai oi maꞌoai lau puouai agoꞌualai, gome lau fou Deo ega iifa pukagai iina kepapua oma: “‘Lau sipi iꞌima auga alaauga, ke sipi maꞌoai akekani afeꞌai.’ ");
INSERT INTO mek_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kai lau alamaunimue afegai, oi agomiai alaufai alalao Kalilea agogai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ega aisama Peto eifa einaka, “Isa maꞌoai oi puomuai fekeꞌualai mo ganinagai, lau auga afalaꞌualai laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kai Iesu einaka, “Iifa koꞌa maamuai laifania. Pau gapiai oꞌolo aeagaga koa kai, oi lau alopuniaiainiau oiso alopamia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Kai Peto eifa pugu einaka, “Lau oi auniꞌa kaiꞌalao mo famae ma ganinagai, oi afalapuniaiainio laaꞌi,” eoma. Ke Iesu ega imoi iꞌoiꞌi maꞌoai isafa, isa eifania koa keifania. ");
INSERT INTO mek_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Egae kai Iesu ega imoi fou kelao afu aka Ketsemani, ke egae epainiꞌi einaka, “Inae amoagu kai malao egamogae mamegamega,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ke Iesu Peto, ke Sebedi gauga auniꞌi James, ke Ioane fou eafiiꞌi fou kelao, ke kapaꞌina mo faagagai akemia auꞌi eopolaniꞌi alo emafu alogaina, ke opolaga elao mo emai. ");
INSERT INTO mek_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Egae kai isa epainiꞌi einaka, “Lau eꞌu alomafu kiekie auga akaikiꞌa ipauma puo, famae koa ganinagai agekaina. Oi inae foagu, folofeu lau fou faꞌimaꞌima,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Egae kai isa epuaꞌafuniꞌi elao afaꞌagamo aakai kai, eꞌualai aꞌisaai eomu kipo kai, emegamega einaka, “Amau, afekaina koa aisama, iꞌina kiekie kaputina eeuai moafiꞌaua. Kai lau anina laani auga faeikapa kai, oi anina loani auga gaikapa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Egae kai emue elao ega imoi oiso kefeu eisaꞌi. Ega aisama Peto epaꞌani penia einaka, “Oi aumi, kina maaga agaꞌomo lau fou faagu faꞌimaꞌima auga afaekaina ma? ");
INSERT INTO mek_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Foagu foꞌimaꞌima ke fomegamega ega koa iꞌopo apalaꞌi aloꞌiai afolokoko. Oi lalaumi auga gaagu gaꞌimaꞌima ke gamegamega eoma kai, imaaumi auga eapoke,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Egae kai emue kai, emegamega pugu einaka, “Amau, iꞌina kiekie kaputina afoloafiꞌaua alainu kai kiekie egaꞌina agefua koa aisama, kapaꞌina anina loani auga gaikapa laoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ke emue elao ega imoi kefeu eisaꞌi, gome maaꞌi emeau. ");
INSERT INTO mek_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ega puo epuaꞌafuniꞌi emue elao megamega iꞌopoga mo eifania oiso epamia pugu. ");
INSERT INTO mek_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Egae kai emue elao ega imoi eeꞌiai, ke epainiꞌi einaka, “Oi ofeu olaagai aefua koa ma? Kina maaga emai efua. Maami galao Papiau Aumauni Gauga laomai apalaꞌi kekapa auꞌi imaꞌiai keꞌafaꞌafalaina amoisa. ");
INSERT INTO mek_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Amoꞌue alao. Lau eꞌafaꞌafalainiau auga emai!” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesu eniniꞌani laolao kai, ega imoi auꞌi 12 epoꞌiai agaꞌo Judas keoma auga emai isa eeꞌiai. Ke sakedote lopiaꞌi, ke au akaikiꞌaꞌi papiau keꞌimaꞌi auꞌi fou au keulaiꞌi auꞌi, laꞌafou akaikiꞌagai ifani aꞌifaꞌi ke kopi fou keafiiꞌi isa fou kemai. ");
INSERT INTO mek_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Kai Judas Iesu eꞌafaꞌafalaina auga egaꞌina auꞌi fou Iesu eega akelao koa kai epainiꞌi einaka, “Alagoapa auga egamoꞌe. Isa foafia!” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ega puo kelao Iesu eegai aisama, Judas Iesu epamegonia einaka, “Pamalele aumu, oi loague ma?” eoma, ke egoapia. ");
INSERT INTO mek_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ke Iesu einaka, “Ekefaꞌau, kapaꞌina ikapa lomai auga mokapa,” eoma. Ega aisama au Judas fou kemai auꞌi keapalai, Iesu keafiia kegopeisa. ");
INSERT INTO mek_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Egaꞌina alogai Iesu fou kelao auꞌi agaꞌo ega ifani aꞌifaga efuaua, sakedote lopia faꞌa ega pinauga auga agaꞌo eauniia ke aina efoua. ");
INSERT INTO mek_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kai Iesu isa epainia einaka, “Oi emu ifani aꞌifaga afugai moukamue, gome kai imaꞌiai aꞌifa eka auga aꞌifai akemae. ");
INSERT INTO mek_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Oi loopolaga lau Amau alaifaga aisama, Isa fiakoa mo lau fauai agelo 6000 aua aua eꞌi ikupu auꞌi 12 alogai afakemai ma looma? Iifa koꞌa Isa ega koa agekapa agekaina. ");
INSERT INTO mek_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kai Isa ega agekapa oma koa aisama, Isa ifo ega iifa pukagai lau fou keifania iina famae oma keoma auga ala ageoma agemai agekoꞌa?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Egae kai eꞌafoaipini laꞌafou isa isafina kemai auꞌi epainiꞌi einaka, “Lau painao au, o eemiai kelele akaikiꞌa agaꞌo lakapaisa ma puo, ifani aꞌifaꞌi kopi fou oafiiꞌi omai amoafiau ooma? Aufa kina mo Deo ega eꞌai laagu lapamalele kai aloafiau alogopeisau. ");
INSERT INTO mek_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kai iꞌina kapaꞌi kemia ega koa Deo ega iifa pukagai profeta kapaꞌina kepapua auga koꞌa femia kainai kemia,” eoma. Egaꞌina papiauꞌi Iesu keafiia kegopeisa aisama, ega imoi maꞌoai Iesu kepuaꞌafuga kepiau. ");
INSERT INTO mek_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Au Iesu keafia auꞌi kelaoaina sakedote lopiaꞌi, ke au akaikiꞌaꞌi papiau keꞌimaꞌi auꞌi sakedote lopia faꞌa Kaiafas afugai kelaꞌafou keagu auga eegai. ");
INSERT INTO mek_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Kai egaꞌina alogai Peto Iesu muninai aakai epakaisa epea elao, ke epapea ukiniꞌi elao mo sakedote lopia faꞌa ega afu afegai. Ke ekoko imaꞌima auꞌi fou keagu kai kapaꞌina agemia auga feisa eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Egaꞌina alogai sakedote lopiaꞌi ke kansolo auꞌi maꞌoai pifoge niniꞌaniꞌi kekapuniꞌi koꞌaꞌi koa fekepamiaꞌi, Iesu fekepaagu fofoua, ke fekeaupugua keoma. ");
INSERT INTO mek_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ke papiau maꞌo kemaiseiniꞌi Iesu kapa agaꞌo aekapaisa auga, pifogeai koꞌa ekapaisa keoma mo ganinagai, isa Iesu fekeaupugua auga keagaga agaꞌo akekapulaisa. Kai fuagai au auniꞌi keapalai. ");
INSERT INTO mek_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ke isa keifa keinaka, “Iꞌina auga eifa, ‘Lau Deo ega eꞌa alaauoka agekaina kai, kina oiso alogai alapaapa pugu,’ eoma aina alogonia,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ega aisama sakedote lopia faꞌa eꞌue eapa kai Iesu epainia einaka, “Iꞌina auꞌi niniꞌani kapaꞌi oi eemuai keifaniꞌi? Oi iifa agaꞌo afolopamue ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kai Iesu komo mo eoma. Ke sakedote lopia faꞌa Iesu epainia pugu einaka, “Lau Deo eague aoniamo auga agogai pakoꞌa niniꞌaninai oi laifa kapula penio, koꞌa mo foifania. Oi Mesaia, Deo Gauga aumu ma auga maamaisai moifania?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ke Iesu einaka, “E! Oi loifania koa iꞌopoga, lau Deo gauga paisa. Kai oi maꞌoai lapainimi: Muni oi Papiau Aumauni Gauga Deo Au Akaikiꞌa Auga kaina kainai ageagu, ufai apuapuai agemai agoisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ega aisama sakedote lopia faꞌaga ifo afe tiapuga eꞌiꞌinia kai eifa einaka, “Isa Deo eegai eifa apala! Kapa puo isa fekeifafoua papiauꞌi agaꞌo fokapuga femai pugu? Amoisa, isa Deo eifa apala penia auga pau ifoꞌa ainaꞌaisai eake. ");
INSERT INTO mek_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Oi maꞌoai ala oopola oma?” eoma. Ke isa keinaka, “Isa femae auga ekainia,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Egae kai egaꞌina papiauꞌi Iesu kua maaga keꞌupeisa, ke imaꞌi kepafufua kai keauniia, ke isaꞌi isa kepoaisa. ");
INSERT INTO mek_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ke kepainia keinaka, “Mesaia aumu, kaisau eaunio auga profeta koa momia moifania?” keoma. ");
INSERT INTO mek_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pau egaꞌina alogai Peto isafa egae sakedote lopia faꞌa ega eꞌa afegai eagu. Egaꞌina alogai sakedote lopia faꞌa ega pinauga ifiaoga agaꞌo emai isa epainia einaka, “Oi isafa Iesu Kalilea auga fou olao omaimai aumu agaꞌo,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kai isa egae keagu auꞌi maꞌoai mo agoꞌiai epuniai einaka, “Oi kapaꞌina loifania auga oko alalogo,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Egae kai elao pealai paꞌafina akegai, ke egae ifiao iꞌoina agaꞌo isa eisa aisama, papiau egae keapa auꞌi epainiꞌi einaka, “Iꞌina auga Iesu Nasareta auga fou kelao kemaimai auga,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kai Peto iifa koꞌa ipauma keifania auga kagakaga gouga ekapaisa kai epuniai pugu einaka, “Lau au egaꞌina alalogonia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ke keagu afaꞌagamo aisama, egae keapa auꞌi kelao Peto eegai ke kepainia keinaka, “Koꞌa oi isafa Iesu ega imoi agaꞌo, gome oi emu niniꞌaniai akapulaiso,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ega aisama Peto ifo mo eifa apala penia, ke kagakaga kainai pakoꞌa iifaga kekapa auga gouga ekapaisa kai eifa einaka, “Iifa gome, lau au egaꞌina alalogonia,” eoma. Ke fiakoa mo oꞌolo eagaga. ");
INSERT INTO mek_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ega aisama Peto Iesu kapa eoma auga iifaga eopolaga: “Oꞌolo aeagaga koa kai lau alopuniaiainiau oiso alopamia,” eoma. Ke epealai elao afegai kai, eapepe alogaina. ");
INSERT INTO mek_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Egani amagai ipauma, sakedote lopiaꞌi ke au akaikiꞌaꞌi egaꞌina fou kepakoꞌania keifa Iesu femae keoma. ");
INSERT INTO mek_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ke keafiia kegopeisa kepapea kelaoaina kafana Pilato imagai kepaaua. ");
INSERT INTO mek_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kai Judas Iesu eꞌafaꞌafalaina auga, Iesu femae keoma auga eisa aisama, alo ekiekie alogaina puo, silifa monina 30 kepenia auga emueaina elaoaina sakedote lopiaꞌi ke au akaikiꞌaꞌi fou epeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ke einaka, “Lau laomai apala lakapaisa, gome lau au agaꞌo laomai apala agaꞌo aekapaisa auga, laꞌafaꞌafalaina,” eoma. Ke isa keinaka, “Egaꞌina lai eemaisai auga kapa agaꞌo laaꞌi. Oi ifomu emu opopo, ala alooma koa ifomu,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ke Judas moni egaꞌina Deo ega eꞌa alogai epiunialao eka kai, ekailai elao ifo ekopa. ");
INSERT INTO mek_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ke sakedote lopiaꞌi moni egaꞌina keafiia ke keinaka, “Iꞌina monina Deo ega eꞌa alogai moni aogeoge afugai faoge auga keifa apua. Gome iꞌina monina auga papiau agaꞌo ifa efaka auga monina,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ega puo ifoꞌi epoꞌiai kepakoꞌania oga ikapa auga ega ago keꞌafaisa. Ke egaꞌina afugai afu iꞌoina papiauꞌi, Ierusaleme taonina papiauꞌi laaꞌi auꞌi kefufuniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ega kainai egaꞌina ago kepafaala, ifa ago keoma. Ke aka egaꞌina pau ekae paisa. ");
INSERT INTO mek_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Egaꞌina kapa emia ega koa Deo profeta Jeremaia akegai eifafoua iifaga koꞌa emia: ‘Israel papiauꞌi isa afa silifa monina 30 kepamia, ke egaꞌina monina keafiia oga ikapa auga ega ago keꞌafaisa. ");
INSERT INTO mek_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ke ega koa emia auga, Lopia lau epainiau koa iꞌopoga mo emia.’ ");
INSERT INTO mek_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kai egaꞌina alogai Iesu kafana Pilato agogai eapa iifa epakaisa. Pilato isa epaꞌani penia einaka, “Oi Iudea papiauꞌi eꞌi kin ma?” eoma. Ke Iesu einaka, “E, oi loifania koa iꞌopoga,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kai sakedote lopiaꞌi ke au akaikiꞌaꞌi fou isa kepaagu fofoua aisama, eꞌi iifa afa agaꞌo aepamue. ");
INSERT INTO mek_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ega aisama Pilato isa epaꞌani penia einaka, “Oi isa kapa maꞌo mo faagaꞌiai keniniꞌani kepaagu fofouso auga ainaꞌi alologo ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kai Iesu isa kepaagu fofoua auga iifaꞌi agaꞌomo ganinagai afa aepamue puo, kafana Pilato ekauai alogaina. ");
INSERT INTO mek_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kai egaꞌina kina auga Pasover miamiaga kina. Ke egaꞌina kinagai, kafana ekapakapa koa iꞌopoga laꞌafou papiauꞌi tipula auga agaꞌo kekinaga auga epapapealaisa. ");
INSERT INTO mek_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ega kinagai tipula auga agaꞌo apala ipauma, papiau maꞌoai kelogo afeꞌaina auga aka Barabas eagu. ");
INSERT INTO mek_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ega puo laꞌafou papiauꞌi kekaigugu aisama, Pilato isa epaꞌani peniꞌi einaka, “Anina oani au kapa mapapealaisa ooma? Barabas, o Iesu keifaga Mesaia keoma auga mapapealaisa ooma?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Isa ega epaꞌani oma, gome papiau egaꞌina auꞌi Iesu eegai kepikupa kainai keafiia isa imagai kepaaua auga elogo. ");
INSERT INTO mek_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ke Pilato ega agu afugai eagu papiau eꞌi laomai felo o apala afa epeniꞌi afugai eaguega kai, isa akafa iifa eulaisa einaka, “Au egaꞌina kapa apala agaꞌo aekapaisa auga faagagai kapa agaꞌo folokapa. Gome lau pau lanipi, ke nipiai au egaꞌina puogai kiekie akaikiꞌa laafiia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kai sakedote lopiaꞌi, ke au akaikiꞌaꞌi fou laꞌafou papiauꞌi aloꞌi keaniia, Pilato fekegoina Barabas fepapealaisa kai, Iesu auga femae keoma. ");
INSERT INTO mek_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ke Kafana Pilato isa epaꞌani peniꞌi einaka, “Iꞌina auꞌi auniꞌi epoꞌiai kaisau mapapealaisa oi eemi gafai ooma?” eoma. Ke isa keinaka, “Barabas mopapealaisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ke isa epaꞌani pugu einaka, “Ega koa aisama, Iesu Mesaia keoma auga faagagai kapaꞌina fakapa ooma?” eoma. Ke isa maꞌoai keinaka, “Kolotiai moauꞌuꞌua,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ega aisama Pilato isa epaꞌani peniꞌi pugu einaka, “Kapa puo isa kolotiai maauꞌuꞌua ooma? Isa laomai apala ipauma kapa ekapaisa?” eoma. Kai isa keagaga alogaina paisa keinaka, “Kolotiai moauꞌuꞌua,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ke Pilato Iesu fepealai auga keagaga agaꞌo ekapunia aeisa kai, aꞌoaꞌo akaikiꞌa mo eꞌuegekae auga eisa. Ega aisama fei eafiia laꞌafou agoꞌiai ima eikuisa kai eifa einaka, “Au iꞌina alo opai auga ifa agefaka auga lau eꞌu puo laaꞌi kai, oi emi puo!” eoma. ");
INSERT INTO mek_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ke papiau maꞌoai keinaka, “Isa ifa agefaka auga lai ke gaumai fou emai puo,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilato papiau ega keifa oma ainaꞌi elogonia aisama, Barabas epapealaisa eeꞌi elao kai, ega imoi epainiꞌi Iesu kegapukia kai, Roma ifani auꞌi imaꞌiai epaaua, kolotiai fekeauꞌuꞌua eoma. ");
INSERT INTO mek_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Egae kai kafana Pilato ega ifani auꞌi Iesu keafiia kafana eagu eꞌagai kekokoaina kai, ifani auꞌi fofouga kemaiseiniꞌi keapa lofe. ");
INSERT INTO mek_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Egae kai tiapuga kepaiꞌiulaisa kai, ifani auꞌi tiapu keiꞌiuka tiapuga iisa pitoga kai eaea auga agaꞌo isa kepaiꞌiuka. ");
INSERT INTO mek_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Egae kai aꞌifu keafipoꞌe kin kaniaꞌiai kraon keogeoge auga koa kepamia kaniagai keogeisa. Ke inipo auga keafiia iꞌini koa kepamia ima kainai kepaafia, ke agogai keanifeꞌu kai kepaꞌaua keaꞌalaina keinaka, “Iudea papiauꞌi eꞌi kin, amaau afagaina!” keoma. ");
INSERT INTO mek_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Egae kai keꞌupeisa, ke inipo auga imagai keafiia kania keauniia ke keauauga pugu. ");
INSERT INTO mek_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ke ifani auꞌi Iesu kepaꞌaua ke keauniia afegai, eꞌi tiapu kepaiꞌiuka auga kepaiꞌiulaisa kai, ifo afe tiapuga kepaiꞌiukamue pugu. Egae kai kolotiai kegaauꞌuꞌua keoma, kepapea kelaoaina. ");
INSERT INTO mek_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ifani auꞌi Iesu kolotiai kegaauꞌuꞌua keoma kelaoaina alogai, Sairene auga agaꞌo aka Saimon fou kepiaogai. Ke ifani auꞌi isa kepamaniꞌinia Iesu ega koloti epuaisa fou kelao. ");
INSERT INTO mek_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ke kelao mo afu aka Kolkota keoma auga afugai. Kolkota iꞌa malaꞌaisai auga Papiau Kaniaꞌi Uniaga afuga. ");
INSERT INTO mek_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Egae ifani auꞌi Iesu fino aukelo fou keoge lapuinia auga kepeniia gainu keoma kai, Iesu einu opogaina gamuga eoponia aisama eumaka aeinu. ");
INSERT INTO mek_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Egae kai kolotiai keauꞌuꞌua afegai, Iesu afe tiapuga kapa kaisau ageafia auga kagakaga kainai keꞌopoisa, opuaga kepaꞌaua. Ke ifoꞌi mo epoꞌiai afe tiapuga keꞌeaisa. ");
INSERT INTO mek_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Egae kai egae keagukipo kai, keagu keꞌimaisa. ");
INSERT INTO mek_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ke kania laagai isa kapa puo kolotiai keauꞌuꞌua auga iifaga iina kepapua oma keauꞌuꞌua eka: ");
INSERT INTO mek_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ke painao auꞌi auniꞌi isafa isa fou kolotiai keauꞌuꞌuiꞌi, agaꞌo kaina kainai ke agaꞌo lafanina kaina. ");
INSERT INTO mek_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ke papiau egae kepea pagai auꞌi isa keifa apala penia ke kaniaꞌi keꞌafoisa. ");
INSERT INTO mek_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ke keinaka, “Oi loifa Deo ega eꞌa aloauoka kai, kina oiso alogai alopaapamue pugu looma! Ega kainai ifomu kaniamu moagamauga! Ke oi Deo Gauga koa aisama, kolotiai moake!” keoma. ");
INSERT INTO mek_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ega koa iꞌopoga sakedote lopiaꞌi, Moses ega iifa pamalelega auꞌi, ke au akaikiꞌaꞌi fou isafa isa kepaꞌaua keinaka: ");
INSERT INTO mek_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Isa papiau isaꞌi kaniaꞌi eagamauga kai, ifo auga kania ageagamauga afaekaina. Ke isa Israel papiauꞌi eꞌi kin koa aisama, pau ifo kolotiai gaake ega koa faisa fapakoꞌania. ");
INSERT INTO mek_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Isa Deo epakoꞌania. Ke isa eifa, ‘Lau Deo Gauga,’ eoma puo, Deo isa anina eani koa aisama, Deo isa kania gaagamauga,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ega koa iꞌopoga, painao auꞌi auniꞌi isa fou kolotiai keauuꞌuiꞌi auꞌi isafa, iifa apalaꞌi isa eegai keifaniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Iesu kolotiai keauꞌuꞌua afegai, atiafai elao 3 oꞌclock alogai umina akaikiꞌa egaꞌina ago fofouga eumi apua. ");
INSERT INTO mek_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ke kina maaga 3 oꞌclock koa iꞌopoga aisama, Iesu eagaga akaikiꞌa einaka, “Eloi, Eloi, lama sabaktani?” eoma. Egaꞌina niniꞌanina iꞌa malaꞌaisai auga, “Eꞌu Deo, eꞌu Deo kapa puo lopuaꞌafuniau?” eoma. ");
INSERT INTO mek_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Papiau isaꞌi egae keapa auꞌi Iesu ega eifa oma aina kelogonia aisama, keifa keinaka, “Isa Elaija eifaga,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ke fiakoa mo epoꞌiai au agaꞌo epiau elao tiapu manipina eafiia, fino piꞌigugai eiꞌiupia, inipo augai egopeisa kai, Iesu epeniia gainu eoma. ");
INSERT INTO mek_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kai isaꞌi auꞌi keinaka, “Mopuaꞌafuga kai Elaija agemai isa kania ageagamauga ma auga amaisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ke Iesu eagaga akaikiꞌa pugu afegai aisama, lalauga epuaꞌafuga emae. ");
INSERT INTO mek_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ega aisama tiapu akaikiꞌa Deo ega eꞌa alogai keꞌeꞌe pagainia auga ipuainagai aꞌuoniai eꞌiꞌipea eake papagai, ke aagoa epigugu, ke fopa kefafapea. ");
INSERT INTO mek_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Egaꞌina alogai la akeꞌi keagalai, ke Deo ega papiau kemae auꞌi maꞌo imaauꞌiai kemaunimue. ");
INSERT INTO mek_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ke isa kemaunimue laai kepealai kai Iesu emaunimue aisama, kelao Deo ega taoni Ierusalemeai kekoko papiau maꞌo keapakina peniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Iesu emae alogai ifani lopiaga, ifani auꞌi 100 eꞌimaꞌi auga, ke egae keapa Iesu keꞌima auꞌi fou kafokau akaikiꞌa eꞌue, ke kapa maꞌoai kemia auꞌi keisaꞌi. Ega aisama kemaniꞌi alogaina ke keifa keinaka, “Iifa gome isa Deo Gauga paisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ke papie maꞌo isafa egae aakai mo keapa kai maaꞌi elao Iesu keisa. Egaꞌina papieꞌi auga, Kalilea agogai Iesu muninai kepeapea kapaꞌina mo anina eani aisama, kepapalagaina auꞌi. ");
INSERT INTO mek_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Papie egaꞌina epoꞌiai Maria Makdalena, James ke Iosepa fou inaꞌi aka Maria, ke Sebedi gauga auꞌi inaꞌi. ");
INSERT INTO mek_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Iesu emae kinagai epagapigapi aisama, paꞌamuꞌamu auga agaꞌo Arimatea taoninai emai auga aka Iosepa emai. Isa ifo isafa Iesu ega imoi agaꞌo emia. ");
INSERT INTO mek_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Isa Pilato eega elao Iesu imaauga feafia auga pinoina epinoi. Ke Pilato ega imoi eifa kapula peniꞌi Iesu imaauga isa kegapenia eoma. ");
INSERT INTO mek_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ke Iosepa Iesu imaauga eafiia tiapu felo ipauma aka linen tiapugai emokaisa. ");
INSERT INTO mek_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Egae kai eafiia elaoaina ifo la mamaga fopai eapi kanina auga alogai epakala. Ke kepo akaikiꞌa la egaꞌina ake epae apua kai ekailai elao. ");
INSERT INTO mek_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ke Maria Makdalena ke Maria agaꞌo auga fou la apie kaina keagu. ");
INSERT INTO mek_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Iesu laai keogeisa kina auga, Deo keau afagaina kina agogai auga, ke pinauga kepafua afeꞌaina kinagai. Ke egani aisama, sakedote lopiaꞌi ke Faliseo auꞌi fou Pilato eega kelao. ");
INSERT INTO mek_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ke kepainia keinaka, “Au akaikiꞌa aumu. Pifoge auga egaꞌina aemae koa kai iina eifa oma auga aopolaga puo amai, ‘Kina oiso afegai alamaunimue,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ega puo moifa kapulania isa laaga ake kegakaisapua, ke kina oiso imaꞌima gamia. Omaꞌe kai ega imoi isa imaauga afekepainaoga kai papiau maaꞌiai afekeifa isa maeai emauni afekeoma. Ke isa ega koa akekapa koa aisama, pifoge akaikiꞌa agemia. Egaꞌina auga pifoge ufaina isa ekapa kakaua auga agekaꞌegaina,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ega aisama Pilato einaka, “Oi eemiai imaꞌima auꞌi keague. Olao la amoꞌima, ke la ala agoꞌima felo oma auga okapa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ega puo isa imaꞌima auꞌi fou kelao Iesu keoge auga laaga paꞌafina kekaisapua, ke kai agaꞌo faepaagalaisa auga gouga paꞌafi akegai keogeisa. Ke au isaꞌi isafa egae kepaapaꞌi la keꞌimaisa. ");
INSERT INTO mek_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Iudea papiauꞌi Deo keau afagaina kina epagai, ke egani iifi agaꞌo alogai kina eufai auga kinagai amagai ipauma Maria Makdalena, ke Maria agaꞌo auga auniꞌi Iesu laaga kegaisa keoma kelao. ");
INSERT INTO mek_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ke amoisa, kafokau akaikiꞌa ipauma eꞌue, gome Lopia ega agelo agaꞌo ufai eake emai, ke elao la akegai fopa kepae apua auga epaemue kai laagai eagu. ");
INSERT INTO mek_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Isa iisa auga kimage eafi eaea koa iꞌopoga, ke ega tiapu auga keloga snou koa iꞌopoga. ");
INSERT INTO mek_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ega aisama egae keapa keꞌimaꞌima auꞌi, agelo egaꞌina kemaniꞌiai alogaina kepigugu, ke mae auꞌi koa kemia. ");
INSERT INTO mek_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Agelo papie epainiꞌi einaka, “Folomaniꞌi. Gome lau lalogo oi Iesu kolotiai keauꞌuꞌua auga okapuga. ");
INSERT INTO mek_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Isa eifania koa iꞌopoga, isa emaunimue inae laaꞌi. Omai isa eka afuga amoisa. ");
INSERT INTO mek_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Egae kai ofiakoa olao ega imoi auꞌi amopainiꞌi: ‘Isa maeai emaunimue, ke agomiai ageufai agelao Kalilea ago. Oi agolao egae isa agoisa.’ Pau lau oi lapainimi efua,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ega aisama papie maniꞌiai ke alogamai fiakoa mo kekailai kelao, ke kepiau Iesu ega imoi auꞌi ipainiꞌi kelao. ");
INSERT INTO mek_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ke fiakoa mo Iesu eapafoki fou kepiaogai, ke epamegoniꞌi einaka, “Oi oague ma?” eoma. Ega aisama isa kelao Iesu ife foꞌinai keomukipo ifegai keafi kai keau afagaina. ");
INSERT INTO mek_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ega aisama Iesu isa epainiꞌi einaka, “Folomaniꞌi kai olao lau eꞌu imoi opainiꞌi Kalilea ago kegalao egae isa lau akeisau,” eoma. ");
INSERT INTO mek_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Papie egaꞌina Iesu ega imoi ipainiꞌi kelaolao kai, imaꞌima auꞌi isaꞌi kelao Ierusaleme taoninai kapa maꞌoai kemia auꞌi sakedote lopiaꞌi maaꞌiai keifania. ");
INSERT INTO mek_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ke sakedote lopiaꞌi kelao au akaikiꞌaꞌi auꞌi fou kelaꞌafou, ke kapaꞌina fekekapa auga iifaga kepaapa. Egae kai ifani auꞌi la keꞌima auꞌi moni akaikiꞌa ipauma kepeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ke kepainiꞌi keinaka, “Oi foifa, ‘Lai gapiai afeufeu kai, Iesu ega imoi kemai isa imaauga kepainaoga fooma.’ ");
INSERT INTO mek_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ke oi ofeu auga fouga kafana agelogo aisama, lai agalao kapaꞌina isa alo aekainia auga oko agapakapaisa, ke kelele agaꞌo oi eemi afaemai,” keoma. ");
INSERT INTO mek_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ega puo ifani auꞌi moni keafiia ke kepainiꞌi koa kekapaisa. Ke isa kapaꞌina keifania auga fouga Iudea papiauꞌi epoꞌiai epea kepalofe aisoge mo emai pau kina. ");
INSERT INTO mek_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Egae kai Iesu ega imoi auꞌi 11 auꞌi kelao Kalileai Iesu epainiꞌi iku fekelao eoma auga ikugai. ");
INSERT INTO mek_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ke isa Iesu keisa aisama, keau afagaina kai epoꞌiai isaꞌi auga aloꞌi kepamaꞌo. ");
INSERT INTO mek_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ega aisama Iesu emai eeꞌiai eapa kai epainiꞌi einaka, “Deo, ufai ke aagoai isapu maꞌoai lau epeniiau. ");
INSERT INTO mek_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ega puo olao agofaꞌai ago maꞌoai papiauꞌi lau eꞌu imoi opamiaꞌi. Ke Ama, Gauga ke Deo ega Spiritu akagai papiau baptismo fopeniꞌi. ");
INSERT INTO mek_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ke kapa maꞌoai oi maamiai laifa kapulaniꞌi auꞌi isa fopamaleleniꞌi, ega koa kaiꞌiai fekepea. Ke iifa gome maamiai laifania, lau oi eemiai alaagu mo agelao agofaꞌa ega fua auga kina agemai kai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iifa faunina Iesu Kristo, Deo gauga fouga auga inae eꞌina. ");
INSERT INTO mek_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Profeta Aisaea Deo ega iifa pukagai iina epapua oma: Deo eifa, “Lau eꞌu iifa ipapea auga oi agomuai alaulai kakaua, emu keaga agepakaisa.” ");
INSERT INTO mek_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Aufalao agaꞌo ago maininai eagaga, ‘Lopia faugai keaga amopakaisa, amopaꞌopaina,’” eoma. ");
INSERT INTO mek_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Egaꞌina iifaga kainai, Ioane emai ago maininai eapa papiau einogoniꞌi eꞌi laomai apalaꞌi kegaumakalainiꞌi, ega koa Deo eꞌi laomai apalaꞌi feꞌagegeainiꞌi, ke baptismo fekeafia eoma. ");
INSERT INTO mek_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Egaꞌina alogai Iudea ago paguaꞌi papiauꞌi ke Ierusaleme taonina papiauꞌi maꞌoai kepealai Ioane eega kelao. Egae eꞌi laomai apalaꞌi keifafouꞌi kai, Jordan agapugegai baptismo epeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ioane auga kamelo faaga puinai tiapu kekapa auga eiꞌiuka, ke peleta aꞌo faagaꞌiai kekapa auga uufagai epaaga, ke ago alo memeꞌuge feina ke apelaꞌopu fou eaniiꞌi. ");
INSERT INTO mek_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Isa egae Jordan agapugegai papiau kelaꞌafou auꞌi epainiꞌi einaka, “Aufalao agaꞌo lau muniuai agemai auga akaikiꞌa ipauma. Isa lau ekaꞌegainiau puo, alaloukipo ife kamataga ufe mo ganinagai alagupuka afaekaina. ");
INSERT INTO mek_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ke lau auga feisai baptismo lapenimi kai, isa auga Deo ega Spiritu isapugai baptismo agepenimi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Egaꞌina kinagai Iesu Kalilea agogai, Nasareta taoninai eake emai Jordan agapugegai, ke Ioane isa baptismo epeniia. ");
INSERT INTO mek_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ke Iesu feisai eꞌagau aisama, ufa eagalai eisa, ke Deo ega Spiritu, koofi koa emia eake penia. ");
INSERT INTO mek_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ke ufai aufalao agaꞌo aina eifa opu einaka, “Oi auga lau Gau animu laani alogaina aumu, ke eemuai alou egama alogaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Egaꞌina afegai Deo ega Spiritu fiakoa mo Iesu epapealaisa elao ago maininai epakoko. ");
INSERT INTO mek_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Iesu egae ago maininai aꞌo aꞌiꞌi epoꞌiai eagu, ke kina maꞌoai mo ouꞌaga pani alogai Satani emai Iesu eꞌopoisa. Egaꞌina afegai agelo kemai kepalagaina. ");
INSERT INTO mek_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pau Ioane kepatipulania afegai, Iesu Kalilea ago elao iifa faunina Deo ega agofaꞌa fouga einogo. ");
INSERT INTO mek_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ke isa einaka, “Kina ekainia, Deo ega agofaꞌa emai efua kainagai. Ega puo emi laomai apalaꞌi amoumakalainiꞌi kai, Deo ega iifa faunina amopakoꞌania,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Egae kai Iesu elao Kalilea aꞌuga foegai epea alogai, au aka Saimon, ke akina Andru auniꞌi aꞌuai feꞌi keogeisa eisaꞌi, gome isa inoino auꞌi. ");
INSERT INTO mek_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ke Iesu isa epainiꞌi einaka, “Omai muniuai amopea. Ke lau oi papiau ipaoaꞌi aumi alapamiaimi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ke isa fiakoa mo eꞌi feꞌi kepuaꞌafuniꞌi, Iesu muninai kepea. ");
INSERT INTO mek_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ke kepea afaꞌagamo aisama, Sebedi gauga James akina Ioane auniꞌi gaagai keaguka feꞌi kekapa feloꞌi eisaꞌi. ");
INSERT INTO mek_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ke fiakoa mo isa eifaniꞌi. Ke isa amaꞌi Sebedi ke pinauga auꞌi afaꞌi keoge fou kepinauga auꞌi gaagai kepuaꞌafuniꞌi keaguega kai, kelao Iesu muninai kepea. ");
INSERT INTO mek_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ke Iesu ega imoi fou kelao Kapenaum. Ke Iudea papiauꞌi Deo keau afagaina kina emai aisama, Iesu laꞌafou afugai ekoko, eꞌina epamalele. ");
INSERT INTO mek_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ke papiau isa ega pamalele aꞌo kelogonia aisama, kekauai ke keopofua. Gome isa Moses ega iifa pamalelega auꞌi koa aepamalele kai, isapuai epamalele. ");
INSERT INTO mek_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ke Iesu epapamalele laolao kai, egae au agaꞌo tiapolo alogai eagu auga eagaga einaka, ");
INSERT INTO mek_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesu Nasareta aumu, lai mopuaꞌafunimai. Lai oi eemuai kapaꞌina akapaisa? Oi lomai lai mopalifuimai ma looma? Lau oi kaisau auga lalogo. Oi Alo Lolofa Aumu Deo Akaikiꞌa Auga eegai lomai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kai Iesu tiapolo au egaꞌina alogai eagu auga efinaisa einaka, “Komo mooma kai isa alogai mopealai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ega aisama tiapolo au epapigugunia kai, maisagaga mo au alogai epealai. ");
INSERT INTO mek_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ke papiau ega koa emia keisa aisama, kekauai alogaina keopofua, ke ifoꞌi mo epoꞌiai kepaꞌani keinaka, “Inaꞌina kapaꞌina? Pamalele mamaga maiꞌisapuga. Gome isa tiapolo apalaꞌi mo ganinagai eifa kapula peniꞌi mo aina keafia,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ke Iesu fouga Kalilea ago fofouga alogai epea efiaisakoa. ");
INSERT INTO mek_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Egae kai Iesu ega imoi, ke Ioane James fou Iudea papiauꞌi eꞌi laꞌafou afuga kepuaꞌafuga aisama, kelao Saimon ke Andru auniꞌi eꞌi eꞌai kekoko. ");
INSERT INTO mek_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kai Saimon gafa papie auama isafa eafiia petiai eka auga fouga maagai keifania. ");
INSERT INTO mek_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ke Iesu papie eega elao imagai eafi, epalagaina epaꞌuegenia. Ke fiakoa mo auama isafaga papie epuaꞌafuga, ke isa eoge foꞌama egakunia Iesu ega imoi fou epeniiꞌi keaniia. ");
INSERT INTO mek_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Egaꞌina gapigapinai kina eake epaꞌumina aisama, papiau isafa auꞌi maꞌoai, ke tiapolo aloꞌiai keagu auꞌi Iesu eega kemaiseiniꞌi. ");
INSERT INTO mek_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ke egaꞌina taonina papiauꞌi maꞌoai kemai paꞌafi akegai kelaꞌafou. ");
INSERT INTO mek_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ke Iesu, isafa iꞌoiꞌi iꞌoiꞌi keafiiꞌi auꞌi maꞌo epafeloꞌi. Ke tiapolo papiau aloꞌiai keagu auꞌi isafa epapealaiꞌi. Kai tiapolo isa kaisau auga kelogo puo, akeꞌi eafunia fakeniniꞌani eoma. ");
INSERT INTO mek_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Amagai ipauma, afu eꞌumina laolao kai, Iesu eꞌue epealai elao afu oapugai emegamega. ");
INSERT INTO mek_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ke Saimon, fou egae keagu auꞌi Iesu kekapunia. ");
INSERT INTO mek_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ke kelao keisa aisama kepainia keinaka, “Papiau maꞌoai oi kekapunio,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kai Iesu einaka, “Iꞌa afu iꞌoina agaꞌo alao. Alao pagua kainagai auꞌi aloꞌiai amakoko ega koa egae isafa fainogo laoma. Gome lau egaꞌina puogai lamai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ke Iesu Kalilea paguaꞌi maꞌoai epeaiꞌi, Iudea papiauꞌi eꞌi laꞌafou afuꞌiai einogo, ke tiapolo apalaꞌi papiau aloꞌiai keagu auꞌi epapealaiꞌi. ");
INSERT INTO mek_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ke kina agaꞌogai, au agaꞌo molumolu isafaga eafia auga emai Iesu agogai eanifeꞌu egoinia einaka, “Anina aloani koa aisama, faagau alopafelo,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ke Iesu maiguaniai ima ekalaisa au eafi opogaina kai einaka, “Anina laani faagamu felo gamia laoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Iesu egaꞌina eifania aisama, fiakoa mo molumolu isafaga au epuaꞌafuga, faaga felo emia. ");
INSERT INTO mek_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ke Iesu isa eifa kapula penia ke fiakoa mo eulaisa elao. ");
INSERT INTO mek_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Kai epainia einaka, “Foisa kai agaꞌo maagai kapaꞌina emia auga foloifania. Kai molao faagamu sakedote mopakina. Egae kai folao faagamu efelo auga laoga maina Moses eifania koa iꞌopoga mo fokapa, pipeni amuꞌi Deo fopaꞌa penia. Ega koa faagamu felo emia auga isa fepakoꞌania feifafoua,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kai au egaꞌina epealai elao kapaꞌina emia auga eꞌina eifafou ofakaenia mo, ke egaꞌina fouga epapea afu maꞌoai elao. Ega puo Iesu taoni agaꞌogai fepea ofakae auga aekainia kai, isa taoni afeꞌiai afu oapugai eagu elao emai. Ke afu agaꞌo agaꞌo papiauꞌi kepealai Iesu eega kemai aefua. ");
INSERT INTO mek_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ke kina isaꞌi kelao afegai, Iesu emue Kapenaum elao pugu aisama, emai ega paguai auga papiau kelogo. ");
INSERT INTO mek_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ega puo papiau maꞌo kelaꞌafou afu keagu pogua elao mo paꞌafi ake. Ke afe ganinagai afu maꞌoai keapa pogua kai, Iesu Deo ega iifa einogo. ");
INSERT INTO mek_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Egaꞌina alogai au auꞌi pani melo auga agaꞌo kepuaisa kai, papiau isaꞌi fou au egaꞌina Iesu eega kemaiseina. ");
INSERT INTO mek_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kai laꞌafou papiauꞌi kaiꞌiai isa Iesu eega fekelaoaina auga aekainiꞌi keisa aisama, au egaꞌina kepuaisa keꞌagaukae kelao eꞌa ofaofagai Iesu eagu kania laagai kepakaala. Ke ine agaꞌo keapi kanina aisama, egaꞌina inegai melo auga maiꞌilega mo kepake elao. ");
INSERT INTO mek_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ke Iesu egaꞌina auꞌi eꞌi pakoꞌa eisa aisama, melo auga epainia einaka, “Gau, oi emu laomai apalaꞌi laꞌagegeainiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kai Moses ega iifa pamalelega auꞌi isaꞌi egae keagu auꞌi ifoꞌi aloꞌiai keifa keinaka, ");
INSERT INTO mek_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kapa puo au iꞌina ega eifa oma, Deo eegai eifa apala? Kai agaꞌo papiau eꞌi laomai apalaꞌi ageꞌagegeainiꞌi afaekaina kai, Deo ifogamo papiau eꞌi laomai apalaꞌi ageꞌagegeainiꞌi agekaina,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kai Iesu fiakoa mo isa kapaꞌina keopolaga auga Deo ega Spiritu epalogo aisama, epainiꞌi einaka, “Kapa puo oi alomiai oopolaga, Deo mo papiau eꞌi laomai apalaꞌi ageꞌagegeainiꞌi, ke agekapa feloꞌi ooma? ");
INSERT INTO mek_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Niniꞌani auniꞌi epoꞌiai kapa auga mameꞌa, melo auga maagai foifania ooma: Emu laomai apalaꞌi laꞌagegeainiꞌi, o moꞌue emu ile moafia molao? Oi oopolaga lau egaꞌina auga ega laomai apalaꞌi laꞌagegeainiꞌi auga agoisa afaekaina ooma puo, niniꞌani mameꞌa mo laifania ooma? ");
INSERT INTO mek_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kai Lau Papiau Aumauni Gauga, iifa gome agofaꞌai papiau eꞌi laomai apalaꞌi faꞌagegeainiꞌi, ke fapafeloꞌi auga isapuga eeuai ekae, ke kapa agaꞌo agomiai foisa fologo auga alakapa,” eoma. Ke melo auga epainia einaka, ");
INSERT INTO mek_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Lau lapainio, oi lofelo efua, moꞌue emu ile moafia, emu eꞌa molao,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ke fiakoa mo melo auga papiau agoꞌiai eꞌue ega ile eafiia epealai elao. Ke keisa auꞌi kekauai alogaina, ke Deo keau afagaina keinaka, “Kapa agaꞌo iina koa emia alaisaisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Egae kai Iesu epealai aꞌu nie elao pugu. Ke papiau maꞌo laꞌafouai Iesu eega kemai, ke eꞌina epamaleleniꞌi. ");
INSERT INTO mek_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ke isa foe nie mo epea elao alogai, Iudea auga aka Lefi, Alfeus gauga Roma kamanina papagai epinauga tax eafia auga, tax keogeoge afugai eagu eisa. Ke epainia einaka, “Muniuai mopea,” eoma. Ke Lefi eꞌue Iesu muninai epea. ");
INSERT INTO mek_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Egaꞌina kinagai Iesu Lefi ega eꞌai eaniani alogai, tax isafina auꞌi maꞌo, ke tax keafia auꞌi koa iꞌopoꞌi, laomai apalaꞌi kekapa auꞌi maꞌo isafa Iesu ke ega imoi fou egae keagu keaniani. Gome isa auꞌi maꞌo Iesu muninai kepea. ");
INSERT INTO mek_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ke Moses ega iifa pamalelega auꞌi Faliseo ikupugai kemai auꞌi Iesu tax isafina auꞌi, ke tax isafina auꞌi koa iꞌopoꞌi laomai apalaꞌi kekapaꞌi auꞌi fou keaniani keisa aisama, ega imoi kepainiꞌi keinaka, “Ala koa iꞌopoga isa tax isafina auꞌi ke tax isafina auꞌi koa iꞌopoꞌi laomai apala ikapa auꞌi fou keaniani?” keoma. ");
INSERT INTO mek_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kai Iesu isa ainaꞌi elogonia aisama epainiꞌi einaka, “Papiau feloꞌi, akeisafa auꞌi toketa eega afakelao kai, keisafa papiauꞌi mo toketa eega kelao. Ega koa iꞌopoga, lau lamai auga Deo maagai alo opai papiauꞌi faifaniꞌi puo alamai. Kai laomai apalaꞌi kekapa papiauꞌi faifaniꞌi eꞌi laomai apalaꞌi fekeumakalainiꞌi laoma puo lamai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ioane Baptista ega imoi ke Faliseo auꞌi eꞌi imoi fou keani gopegope. Isa kemai Iesu eegai kai kepaꞌani penia keinaka, “Kapa puo Ioane ega imoi ke Faliseo auꞌi eꞌi imoi fou keani gopegope kai, oi emu imoi auga akeani gopegope?” keoma. ");
INSERT INTO mek_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ega puo Iesu isa epainiꞌi einaka, “Amage mamaga auga agaꞌo papiau isa ega miamia kemai auꞌi fou keaguega kai akeani gopegope agekaina ma? Laaꞌi, afaekaina. Isa amage mamaga auga fou keaguega alogai afakeani gopegope. Ega koa iꞌopoga, lau auga amage mamaga au koa iꞌopou. Ega puo lau eꞌu imoi fou aaguega kai akeani gopegope afaekaina. ");
INSERT INTO mek_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kai kina agaꞌo agemai amage mamaga auga akeafiꞌaua aisama, egae kai isa egaꞌina kinagai akeani gopegope. ");
INSERT INTO mek_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ke kai agaꞌo tiapu mamaga aina afaeafia, afe tiapuga ufaina eꞌiꞌi auga afaekai apua. Kai isa ega agekapa oma koa aisama, tiapu aina mamaga auga afe tiapuga ufaina ageꞌiꞌina, ke ine afuga akaikiꞌa agemia puo, agepalifua. ");
INSERT INTO mek_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ega koa iꞌopoga, kai agaꞌo fino mamaga eafia fino kepapaꞌefauka pute ufaina auga alogai aepaꞌefauka. Kai isa fino mamaga agefia pute ufainagai ageꞌefauka koa aisama, fino mamaga pute ufaina efugugu puo, ageauꞌiꞌina pute agepalifua. Ke fino isafa agefaka. Ega puo isa fino mamaga ageafia fino pute mamaga alogai ageꞌefauka,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Iudea papiauꞌi Deo keau afagaina kina agaꞌogai, Iesu ega imoi fou palafa uma alogai peapea afugai kepea pagai. Ega aisama Iesu ega imoi palafa aniꞌi auꞌaaꞌiai kefaiponiꞌi keafiiꞌi kepealaina. ");
INSERT INTO mek_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ke Faliseo auꞌi Iesu ega imoi ega koa kekapaisa auga keisaꞌi puo, Iesu kepainia keinaka, “Moisa! Kapa puo Deo aau afagaina kinagai oi emu imoi ega koa kekapa? Egaꞌina auga Moses ega iifa kainai keifa apua puo, fakekapa koa kai kekapa,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kai Iesu isa epainiꞌi einaka, “Davide ega au fou inaeꞌi ekimu kapa agaꞌo anina keani aisama, kapaꞌina ekapaisa auga Deo ega iifa pukagai alokuakuapina ma? ");
INSERT INTO mek_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Sakedote lopia faꞌaga aka Apiata eagu miagai, Davide elao Deo ega eꞌai ekoko palafa Deo kepalao penia sakedote mo fekeania keoma auga eafiia eaniia, ke afa ega au auꞌi isafa epeniiꞌi keaniia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ke epainiꞌi pugu einaka, “Moses ega iifa kainai keifa apua mo ganinagai, kapa agaꞌo Davide faagagai aemia. Ke papiau aumauni faugai Deo keau afagaina kina egama kai, Deo keau afagaina kina faugai papiau aumauni aegama. ");
INSERT INTO mek_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ega puo Lau Papiau Aumauni Gauga au, Deo keau afagaina kina Lopiaga au. Ega kainai lau eꞌu imoi kapaꞌina kekapa auga lau mo faniniꞌani,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Egaꞌina afegai kina agaꞌogai, Iesu Iudea papiauꞌi eꞌi laꞌafou afugai ekoko pugu, ke au agaꞌo ima emelo auga isafa egae eagu. ");
INSERT INTO mek_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ke papiau isaꞌi egae keagu Iesu keagouka, Deo keau afagaina kinagai au egaꞌina afepafelo koa aisama, fekeisa ega koa fekepaagu fofoua keoma. ");
INSERT INTO mek_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kai Iesu ima melo auga epainia einaka, “Moꞌuegekae moapalai papiau maꞌoai agoꞌiai moapa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ke au egaꞌina eꞌuegekae papiau maꞌoai agoꞌiai eapa aisama, Iesu papiau epaꞌani peniꞌi einaka, “Moses ega iifa kainai Deo aau afagaina kinagai auga, kapaꞌina fakapa auga keifa apua? Felo fakapa o apala fakapa? Ke papiau kaniaꞌi faagamauga, o faaupuguꞌi?” eoma. Kai isa komo mo keoma. ");
INSERT INTO mek_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ega puo Iesu guakupuai maaga egoaisa eisaꞌi. Ke guaꞌi eꞌinoka alogaina auga eisa puo, alo emafu alogaina. Ke ega alomafuai melo auga epainia einaka, “Imamu mokalaisa,” eoma. Ke melo auga ima ekalaisa aisama, ima felo ipauma, ima apie koa iꞌopoga emia. ");
INSERT INTO mek_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Faliseo auꞌi Iesu ega koa ekapaisa keisa afegai, kepealai kelao Herod ega imoi fou keapafou kai, Iesu ala fekeaupugu oma auga fouga keifania. ");
INSERT INTO mek_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kai Iesu ega imoi fou kepealai aꞌu nie kelao. Ke Kalilea ago papiauꞌi ke Iudea ago papiauꞌi laꞌafou akaikiꞌa ipaumagai isa muniꞌiai kelao. ");
INSERT INTO mek_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ke egae Iesu kapa maꞌoai ekapaiꞌi auga fouga kelogo aisama, Ierusaleme taoninai, Idumea taoninai, Jordan apiegai paguaꞌiai, Taire taonina eegai paguaꞌi, ke Sidoni taonina eegai paguaꞌi papiauꞌi maꞌo laꞌafou akaikiꞌagai isa eega kemai. ");
INSERT INTO mek_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ke Iesu ega imoi epainiꞌi laꞌafou akaikiꞌa ipauma emia puo gaaga eꞌele agaꞌo isa faugai fekepafua feka eoma. O laaꞌi koa laꞌafou papiauꞌi isa afekepapepe eoma. ");
INSERT INTO mek_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Gome isa papiau maꞌo epafeloꞌi, ega koa papiau maꞌo alogaina keisafa auꞌi kepikoni Iesu kegaafi opogaina keoma. ");
INSERT INTO mek_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ke Iesu papiau epafeloꞌi alogai tiapolo apalaꞌi Iesu keisa aisama, agogai keꞌualai keomukipo kai keagaga keinaka, “Oi Deo Gauga Aumu,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kai Iesu tiapolo ainaꞌi epalogo ke eifa kapula peniꞌi, ke aelogoainiꞌi isa kaisau auga akeifafoua. ");
INSERT INTO mek_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ke Iesu ikuai eꞌagaukae, ke ifo ega imoi aniꞌi eani auꞌi eifaniꞌi eega kemai. ");
INSERT INTO mek_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ke kemai aisama, auꞌi 12 ekinaniꞌi apostolo epamiaꞌi, ega koa egaꞌina auꞌi isa fou fekeagu, ke feulaiꞌi fekeinogo eoma. ");
INSERT INTO mek_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ke isapu isafa fepeniꞌi tiapolo fekepapealaiꞌi eoma. ");
INSERT INTO mek_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Isa egaꞌina auꞌi ekinaniꞌi apostolo epamiaiꞌi auꞌi akaꞌi inamoꞌe: Saimon epafaala Peto eoma auga. ");
INSERT INTO mek_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedi gauga James, ke akina Ioane Iesu epafaalaꞌi Boaneke eomaꞌi auꞌi. Boaneke auga ufa eauga auga gauga auꞌi: ");
INSERT INTO mek_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ke Andru, Filip, Batolomeo, Mateo, Tomas, James Alfeus gauga, Tadaeus, Saimon Kanaan auga. ");
INSERT INTO mek_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ke Judas Iskariot Iesu eꞌafaꞌafalaina auga isafa. ");
INSERT INTO mek_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iesu ega apostolo 12 ekinaniꞌi afegai, kelao eꞌa agaꞌogai kekoko. Egaꞌina alogai laꞌafou akaikiꞌa kekaigugu pugu puo, isa ega imoi fou keagukipo kegaaniani auga aekainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ke Iesu aaga akina iꞌina fouga kelogo aisama, kemai Iesu kegalaoaina keoma. Gome papiau iina keifa oma, “Isa ekafoꞌo,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ke Moses ega iifa pamalelega auꞌi Ierusalemeai kemai auꞌi keifa keinaka, “Iesu alogai Belsabul eague. Ke isa Belsabul, tiapolo eꞌi lopia aka isapugai tiapolo epapealaiꞌi,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ega puo Iesu isa eifaniꞌi eega kemai kai, maaꞌiai palapoleai eniniꞌani einaka, “Ala koa Satani ageoge Satani mo ageula agekaina? ");
INSERT INTO mek_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ke agofaꞌa agaꞌo ifo mo ageaupea koa aisama, ageapa afaekaina, ageꞌualai paisa. ");
INSERT INTO mek_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ke eꞌa agaꞌogai famili ifoꞌi mo akeꞌeaꞌi koa aisama, akeagu afaekaina, akeꞌualai paisa. ");
INSERT INTO mek_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ega koa iꞌopoga Satani ifo mo ega imoi fou akepipaini, akeꞌeaꞌi koa aisama, ageapa afaekaina ageꞌualai, ke ega agu fua egae agemia. ");
INSERT INTO mek_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Iifa gome aufalao agaꞌo au kapula agaꞌo afaegope kakaua koa aisama, ega eꞌai agekoko, ega eꞌa amuꞌi agepainaoniꞌi afaekaina. Kai isa egaꞌina auga agegope kakaua aisama kai, ega eꞌai agekoko ega amu agepainaoniꞌi agekaina. ");
INSERT INTO mek_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Iifa gome maamiai laifania. Papiau eꞌi laomai apalaꞌi maꞌoai, ke Deo keifa apala peni aagenia mo auꞌi eꞌi laomai apalaꞌi Deo ageꞌagegeainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kai papiau kapaꞌi Deo ega Spiritu keifa apala peni aagenia mo auꞌi, eꞌi laomai apalaꞌi egaꞌina Deo afaeꞌagegeainiꞌi. Kai eꞌi laomai apalaꞌi egaꞌina auꞌi afaꞌi akeafiꞌi aoniamo,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu ega eifa oma gome papiau isaꞌi iina keifa oma: “Tiapolo isa alogai eague,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Egae kai Iesu eꞌa alogai eagu einoinogo kai, ina ke akina fou kemai eꞌa akegai keapa. Ke aufalao agaꞌo keulaisa Iesu gapaina keoma. ");
INSERT INTO mek_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ke laꞌafou papiauꞌi Iesu keagu lofe auꞌi, Iesu kepainia keinaka, “Moisa, oi inamu ke akimu fou kekapunio afegai keapae,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kai Iesu einaka, “Kaisau auga lau inau, ke aau akiu?” eoma. ");
INSERT INTO mek_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ke maaga egoaisa papiau isa keagu lofe auꞌi eisaꞌi kai, eifa einaka, “Iꞌina auꞌi lau inau, ke aau akiu. ");
INSERT INTO mek_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Gome kaisau Deo ega logoai kapaꞌina anina eani kapaꞌi auꞌi mo ekapaꞌi auga, lau inau, akiu, ke afakuau,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ke kina agaꞌogai Iesu elao Kalilea aꞌuga foegai eapa papiau epamaleleniꞌi pugu. Ke laꞌafou akaikiꞌa ipauma kekaigugu Iesu keapa lofe. Ega puo papiau maꞌoai foeai, fei niegai keapa aꞌu keaipenia kai, Iesu auga gaagai eaguka afaꞌagamo epealai inafaꞌai. ");
INSERT INTO mek_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Egae gaagai eagu kai, palapoleai kapa maꞌo mo papiau epamaleleniꞌi. Ke ega pamaleleai iina eifa oma einaka: ");
INSERT INTO mek_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ainami amopaaua kapaꞌina alaifania auga ainau fologo! Amoisa! Au ogaꞌi ifauga auga agaꞌo, au ogaꞌi gafauniꞌi eoma puo epealai ega uma elao. ");
INSERT INTO mek_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Elao egae au ogaꞌi epiuokaꞌi alogai, isaꞌi peapea afugai keaꞌopu, ke inei keake keani afeꞌainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ke isaꞌi fopa laagai aꞌisa afaꞌagamo eka auga laagai keꞌualai. Ke aꞌisa maꞌo laaꞌi puo, keuki kefiaisakoa. ");
INSERT INTO mek_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kai kina eꞌagaukae egagaiꞌi aisama, gagamuꞌi laaꞌi kainai, gagauꞌi kekala kemae. ");
INSERT INTO mek_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ke isaꞌi ini mogogo alogai keaꞌopu ini fou keuki. Ke ini mogogo keuki keafipuguꞌi, ke puaꞌi agaꞌo akeogeisa. ");
INSERT INTO mek_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kai au ogaꞌi isaꞌi auꞌi aagoa felogai keaꞌopu. Ke keuki keꞌagau aisama, puaꞌi keogeiꞌi, ke isaꞌi puaꞌi maꞌoai mo 30 keogeiꞌi, ke isaꞌi puaꞌi 60 keogeiꞌi, ke isaꞌi puaꞌi 100 keogeiꞌi. Ega koa emia puaꞌi au ogaꞌi pika efauniꞌi auga ekaꞌegainiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iesu palapole egaꞌina eifania efua aisama, epainiꞌi einaka, “Kaisau ainami ekae auga ainami opaaua,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kai Iesu ifogamo eapa aisama, ega apostolo 12 ke ega imoi isaꞌi fou egae keagu lofe auꞌi palapole kapaꞌina eifania auga fouga kepaꞌaniaina. ");
INSERT INTO mek_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ke Iesu isa epainiꞌi einaka, “Deo oi eemiai, ega agofaꞌa fouga eogefake kai ega logoai epalogonimi. Kai papiau isaꞌi lau fou laaꞌi auꞌi maaꞌiai kapa maꞌoai palapoleai laifaniꞌi. ");
INSERT INTO mek_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ega koa, “‘aufa kina maaꞌiai akeisa kai afakeisa koa iꞌopoga, ke aufa kina aꞌo akelogo kai kapaꞌina eifania auga afakelogo. Laaꞌi koa aisama, eꞌi laomai apala afekeumakalainiꞌi, ke Deo isa eꞌi laomai apalaꞌi afeꞌagegeainiꞌi!’” eoma. ");
INSERT INTO mek_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ke epainiꞌi pugu einaka, “Oi iꞌina palapole kapaꞌina eifania auga alologo ma? Ega koa aisama, ala koa palapole maꞌoai kapaꞌina keifania auga agologo? ");
INSERT INTO mek_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Au oga efauga auga, Deo ega iifa eꞌafoka. ");
INSERT INTO mek_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Papiau isaꞌi auga, au oga keagai keꞌualai koa iꞌopoꞌi, Deo ega iifa aꞌo kelogo aloꞌiai eka. Kai Satani emai eꞌopoꞌi aisama, fiakoa mo iifa aloꞌiai eka auga eafilaisa. ");
INSERT INTO mek_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ega koa iꞌopoga mo, papiau isaꞌi auga, au ogaꞌi kepo laagai aꞌisa afaꞌagamo eka laagai keꞌualai auꞌi koa iꞌopoꞌi. Isa Deo ega iifa aꞌo kelogo aisama, alogamai mo keafia kefiakoa. ");
INSERT INTO mek_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kai aloꞌiai aeuki gagamuga laaꞌi puo, eꞌi uki epo aemaefa. Ke muniai Deo ega iifa kainai kelele akaikiꞌaꞌi faagaꞌiai emia, o papiau isa keafi apalaniꞌi aisama, fiakoa mo keꞌualai Deo ega iifa keumakalaina. ");
INSERT INTO mek_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ke papiau isaꞌi auga, au ogaꞌi ini mogogo alogai keꞌualai auꞌi koa iꞌopoꞌi. Isa Deo ega iifa aꞌo kelogonia efua. ");
INSERT INTO mek_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Kai keagu alogai aagoa iꞌina aguga opopo, ke kegapaꞌamuꞌamu opopo isa efogeiꞌi, ke kegaalogama opopoꞌi kepaꞌauꞌi. Ega puo isa kapaꞌina kemaaniꞌi auꞌi ini mogogo koa iꞌopoꞌi kemai Deo ega iifa aloꞌiai eka auga keafipuguꞌi. Ega kainai Deo ega iifa aloꞌiai eka auga aeuki anina aeoge. ");
INSERT INTO mek_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kai papiau isaꞌi auga, au ogaꞌi aꞌisa felogai keꞌualai auꞌi koa iꞌopoꞌi. Isa Deo ega iifa aꞌo kelogo keafia, ke isaꞌi puaꞌi 30, ke isaꞌi puaꞌi 60, ke isaꞌi puaꞌi 100 keogeiꞌi. Ega puo iꞌopo kina emai aisama, keafiapiꞌi mo kelaolao Deo maagai laomai feloꞌi mo kekapaꞌi, aniꞌi maꞌo keoge.” ");
INSERT INTO mek_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ke Iesu ega imoi maꞌoai maaꞌiai palapole agaꞌo eifania pugu einaka, “Oi lanepa opaafiaua omaiseina aisama, litiai opaomuapia, o peti isafa papagai opaaguꞌunia ma auga amoopolaga? Iifa gome oi ega koa alokapa kai, oafia eꞌafaꞌafa afugai opaꞌafa. ");
INSERT INTO mek_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Gome muni Deo ega iifa ogefakeai kekae auꞌi akeifafouꞌi akepafokiꞌi. Ke Deo ega iifa kapaꞌina eifania auga isafa, maꞌoai agefoufaꞌa papiau maꞌoai akelogo. ");
INSERT INTO mek_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kaisau aina ekae auga, aina gapaaua ainau galogo,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ke eifa pugu einaka, “Kapaꞌina aꞌo ologonia auga foopola felo. Kapaꞌina papiau faagaꞌiai okapa auga iꞌopoga mo oi faagamiai ageikapa. Ke oi kaisau lau ainau ologo aumi, laagai kapa maꞌo faagamiai ageikapa. ");
INSERT INTO mek_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Gome kaisau aina epaau felo Deo ega iifa aꞌo elogo felo auga, muni Deo isa maꞌo agepalogo. Kai kaisau aina aepaau felo Deo ega iifa aꞌo aelogo auga, afaꞌagamo ipauma mo elogo ganinagai ageafania.” ");
INSERT INTO mek_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ke Iesu eifa pugu einaka, “Deo ega agofaꞌa auga iina koa iꞌopoga. Au agaꞌo aꞌisaai au ogaꞌi eꞌafokaꞌi. ");
INSERT INTO mek_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Aufa kina, kinai ke gapiai efeu o eagu ma ganinagai, au oga ala keoma keꞌomo, ke keuki auga aelogo. ");
INSERT INTO mek_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Gome isa ifoꞌi aꞌisaai keuki ke aniꞌi keoge. Kai akeuki aniꞌi akeoge koa kai, keꞌina omaꞌi kekaaua, ke kegapupea kakauꞌi. Egae kai keuki akaikiꞌaꞌi kemia aisama, aniꞌi keoge. ");
INSERT INTO mek_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ke aniꞌi kemia aisama, iꞌafeꞌi kina ekaina puo, foꞌama iꞌafe aꞌifagai eganiniꞌi.” ");
INSERT INTO mek_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ke Iesu eifa pugu einaka, “Deo ega agofaꞌa auga kapaꞌina koa iꞌopoga, o palapole kapagai Deo ega agofaꞌa agaifaꞌopo? ");
INSERT INTO mek_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Deo ega agofaꞌa auga, au agaꞌo aka Mastad oga koa iꞌopoga. Mastad oga aꞌisaai ofauga aisama, aagoai au ogaꞌi maꞌoai epoꞌiai eꞌele ipauma. ");
INSERT INTO mek_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kai ofauga aisama, euki akaikiꞌa ipauma emia, ke uma alo aupu gagauꞌi maꞌoai ekaꞌegainiꞌi. Ke aga akaikiꞌaꞌi ipaumaꞌi kemia, ega koa ufa gua ineiꞌi agagai keiꞌoau ogogai kelaagai.” ");
INSERT INTO mek_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ke Iesu Deo ega iifa papiau akelogo agekaina auga, palapole maꞌo ega koa iꞌopoꞌiai maaꞌiai eifaniꞌi. ");
INSERT INTO mek_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ke Iesu niniꞌani maꞌoai eifaniꞌi auga palapoleai mo eniniꞌani. Kai egaꞌina afegai ega imoi mo fou keagu aisama, palapole kapaꞌina keifania auga okoꞌi epakai afeꞌaina. ");
INSERT INTO mek_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Egaꞌina mo kinagai epagapigapi aisama Iesu ega imoi epainiꞌi einaka, “Amapagai ofuga akaikiꞌa apie alao,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ke laꞌafou kepuaꞌafuniꞌi egae keaguega kai, Iesu ega imoi isaꞌi Iesu ala eagu oma auga iꞌopoga mo eaguega kai, isa egaꞌina gaagagai keaguka. Ke isaꞌi gaaga eꞌeleꞌi isaꞌiai keaguka fou kekailai kelao. ");
INSERT INTO mek_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ke kepagai kelaolao kai, lanina akaikiꞌa ipauma epua. Ega aisama goiso akaikiꞌaꞌi ipaumaꞌi kemai gaaga laagai keꞌafo pagainia, emia feau fufuniꞌi fekekogo. ");
INSERT INTO mek_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kai egaꞌina alogai, Iesu auga gaaga uguga kaina iifaniai eifaniau eka efeu. Ke ega imoi isa kepagonia kai, kepainia keinaka, “Pamalele Aumu, iꞌa afakogo auga opopo alopaꞌaua ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ega aisama Iesu eꞌue ameku efinaisa, ke aꞌu epainia einaka, “Moꞌolo! Moka umamo!” eoma. Ke ameku eapakipo, ke aꞌu eka umamo. ");
INSERT INTO mek_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kai Iesu ega imoi epainiꞌi einaka, “Kapa puo oi omaniꞌi alogaina? Ala koa iꞌopoga oi pakoꞌa agaꞌo eemiai laaꞌi?” eoma. ");
INSERT INTO mek_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kai isa kemaniꞌi alogaina, ke ifoꞌi mo epoꞌiai keinaka, “Iꞌina auga kaisau? Ameku ke aꞌu mo ganinagai isa aina keafia keapakipo,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Egae kai Iesu ega imoi fou aꞌuai kepagai kelao mo Kadara taonina papiauꞌi keagu agogai keofau. ");
INSERT INTO mek_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ke Iesu gaagai eapa opu aisama, fiakoa mo au agaꞌo tiapolo apala alogai eagu auga laai epealai emai Iesu epea apua. ");
INSERT INTO mek_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Isa laai mo eaguagu, ke kai agaꞌo isa tieiniai ganinagai fekegope faekaina. ");
INSERT INTO mek_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Gome kina epogai papiau iꞌina auga tieiniai ima kegopeiꞌi ke auliai ife kepaagaꞌi kai, isa tieini egaꞌina eapauꞌi, ke auli ifegai auga efaiponiꞌi. Ke kai agaꞌo iꞌina auga fepaapakipo auga aekainia. ");
INSERT INTO mek_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ke egae aufa kina, kinai ke gapiai la aloꞌiai, ke ikuai eagaga ekapaisa efai elaoaina. Ke kepo eafiiꞌi ifo faaga eifaiꞌi. ");
INSERT INTO mek_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kai iꞌina auga aakai maaga elao Iesu eisa aisama, epiau elao agogai eꞌualai eanifeꞌu. ");
INSERT INTO mek_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ke tiapolo au alogai eagu auga eagaga einaka, “Iesu, Deo ufai auꞌoniai Au Akaikiꞌa Ipauma Auga Gauga Aumu! Lau oi eemuai kapaꞌina lakapaisa? Lau afoloafi apalaniau auga, Deo maagai moifa koꞌania!” eoma. ");
INSERT INTO mek_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Gome isa epainia einaka, “Tiapolo apalamu! Egaꞌina auga alogai mopealai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Egae kai Iesu au epaꞌani penia einaka, “Oi akamu kapaꞌina?” Ke tiapolo auꞌi ealogai alogaina au egaꞌina alogai keagu puo, eifa einaka, “Lau akau Maꞌo, gome lai aumai maꞌo,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ke isa Iesu egoinia aeaponia ega koa egaꞌina afugai faepapealaiꞌi eoma. ");
INSERT INTO mek_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Egaꞌina alogai, kainagai mo iku eꞌele mapegai uma laꞌafouai keapa keaniani. ");
INSERT INTO mek_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ke tiapolo maꞌoai Iesu kegoinia keinaka, “Moulaimai uma eeꞌi alao, ke mologoainimai aloꞌiai amakoko,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ke Iesu tiapolo elogoainiꞌi puo, au alogai kepealai kelao uma aloꞌiai kekoko. Ega aisama egaꞌina umaꞌi auꞌi maꞌoai mo 2000 koa iꞌopoga auga, poupouai kepiau kelao aꞌuai kegopolai kekogo. ");
INSERT INTO mek_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ke uma kepaaniꞌi auꞌi kepiau kelao taoni, ke taoni afegai keagu papiauꞌi maꞌoai maaꞌiai iꞌina fouga keifafoua. Ke papiau kelao kapaꞌina emia auga kegaisa keoma. ");
INSERT INTO mek_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ke kelao Iesu eegai aisama, au alogai tiapolo ealogai alogai keagu auga mino felo emia, ke tiapu eiꞌiukaꞌi egae eagu keisa. Ke maꞌoai kemaniꞌi alogaina. ");
INSERT INTO mek_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ke au alogai tiapolo keagu auga faagagai kapaꞌina emia keisa auꞌi, papiau maaꞌiai keifania, ke uma isafa ala keoma auga fouꞌi keifania. ");
INSERT INTO mek_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ega aisama papiau kemaniꞌi alogaina puo, Iesu kegoi penia eꞌi ago gapuaꞌafuga keoma. ");
INSERT INTO mek_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ke Iesu emai gaagai gaaguka eoma aisama, au alogai tiapolo eagu kai, epafelo auga Iesu egoinia fou kegalao eoma. ");
INSERT INTO mek_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kai Iesu epamafua, ke epainia einaka, “Oi emu pagua aamu akimu eeꞌi molao. Ke isa maaꞌiai Lopia oi eemuai kapaꞌina mo ekapaiꞌi auꞌi, ke guamu ala eani oma epafeloiso auga foifania,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ke egaꞌina auga elao Taoni Ouꞌaga keoma auga alogai, Iesu isa faagagai kapaꞌina ekapaisa auga eꞌina eifafoua. Ke papiau maꞌoai egaꞌina aꞌo kelogonia aisama, kekauai alogaina keopofua. ");
INSERT INTO mek_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ke Iesu gaagai epagai aꞌu apie elao pugu aisama, aꞌu niegai eapaega kai, laꞌafou akaikiꞌa kemai keapa lofe. ");
INSERT INTO mek_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ke amoisa, Iudea papiauꞌi eꞌi laꞌafou afuga eꞌima auga agaꞌo aka Jairus emai egae. Ke isa Iesu eisa aisama, ife foꞌinai eꞌualai eomukipo. ");
INSERT INTO mek_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ke egoi kapulania einaka, “Gau ifiaoga eꞌele afaꞌagamo agemae. Mogafegafe momai imamu laagai moogeaua ega koa felo agemia ageagu,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ega puo Iesu au egaꞌina fou kelao. Ke elao alogai laꞌafou akaikiꞌa Iesu muninai kepea kepiꞌifu kelaoaina. ");
INSERT INTO mek_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Egaꞌina laꞌafouga alogai papie agaꞌo inipo 12 alogai ifamomogu isafaga eafiia auga isafa eapa. ");
INSERT INTO mek_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ke isa toketa maꞌo eeꞌi elao, ke isa kapa maꞌo kepeniia faaga kepakiekie alogaina. Ke ega amu maꞌoai toketa faagaꞌiai epafua afeꞌaina. Ega mo ganinagai isa aepafelo kai, ega isafa egaꞌina elifu elaoaina. ");
INSERT INTO mek_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kai isa Iesu fouga elogo aisama, laꞌafouai Iesu muninai elao afe tiapuga eafi opogaina. ");
INSERT INTO mek_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Gome ifo alogai einaka, “Lau isa afe tiapuga mo alaafi opogaina koa aisama, felou alamia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ke fiakoa mo ifa eake auga eapakipo. Ke ifo mo faagagai ega kiekie epealai efua auga gamuga eoponia. ");
INSERT INTO mek_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ke Iesu fiakoa mo faagagai isapu epealai auga elogo puo, laꞌafou alogai eꞌafoaipini epaꞌani einaka, “Kaisau lau afeu tiapuga eafi opogaina?” eoma. ");
INSERT INTO mek_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kai Iesu ega imoi isa kepainia keinaka, “Papiau maꞌo kelaꞌafou faagamu kekagu opogaina loisaꞌi kai, lopaꞌani kaisau lau eꞌu tiapu eafi opogaina looma?” keoma. ");
INSERT INTO mek_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kai Iesu maaga egoa aisoge kaisau ekapaisa auga gaisa paisa eoma. ");
INSERT INTO mek_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ke papie kapaꞌina faagagai emia auga elogo puo, emaniꞌi, maipiguguga mo emai eꞌualai Iesu ife foꞌinai eomukipo kai, maagai kapaꞌina faagagai koꞌa mo emia auga eifania. ");
INSERT INTO mek_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ke Iesu isa epainia einaka, “Gauagai, oi emu pakoꞌa kainai pau felomu lomia. Gagaoai molao, ke iꞌina kiekie gapuaꞌafu umanio mo,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesu eniniꞌani laolao kai, au isaꞌi Jairus Iudea papiauꞌi eꞌi laꞌafou afuga eꞌima auga ega eꞌai kemai kepainia keinaka, “Oi gaumu ifiaoga emae efua. Ega puo Pamalele Auga folopaafipugua,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kai Iesu isa ainaꞌi elogonia aisama, laꞌafou afuga eꞌima auga epainia einaka, “Folomaniꞌi kai mopakoꞌania mo,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iesu kai agaꞌo aelogoaina isa muninai aelao kai Peto, James, ke akina Ioane mo fou kelao. ");
INSERT INTO mek_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ke kelao laꞌafou afuga eꞌima auga ega eꞌai aisama, papiau maꞌo keapepe akaikiꞌa ke kepapinapina eisaꞌi. ");
INSERT INTO mek_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ke eaꞌi ekoko aisama epaꞌani peniꞌi einaka, “Kapaꞌina apepega, ke pinapina opaꞌaua? Imoi aemae, ekae efeu,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kai papiau ifiao emae efua auga kelogo puo, Iesu kepaꞌaua keaꞌalaina. Kai isa papiau maꞌoai epapealaiꞌi afegai aisama, ifiao ina, ama, ke ega imoi isa fou egae keapa auꞌi mo ifiao eka afugai kekoko. ");
INSERT INTO mek_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ke Iesu ifiao imagai eafi kai epainia einaka, “Talita kumi,” eoma. Talita kumi iꞌa malaꞌaisai auga, ‘Ifiao eꞌelemu lau lapainio, moꞌue!’ ");
INSERT INTO mek_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ke fiakoa mo ifiao eꞌue epea aisoge. Gome egaꞌina ifiaoga inipoga 12. Ke ifiao ina ama ke Iesu ega imoi fou iina koa emia keisa aisama, kekauai alogaina. ");
INSERT INTO mek_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kai Iesu isa epaini kapulaniꞌi kapaꞌina emia auga kai agaꞌo maagai fakeifania eoma. Ke imoi ina ama epainiꞌi kapa agaꞌo imoi kegapenia gaania eoma. ");
INSERT INTO mek_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Egae kai Iesu egaꞌina afuga epuaꞌafuga, ega imoi fou kelao ifo ega pagua. ");
INSERT INTO mek_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ke Iudea papiauꞌi Deo keau afagaina kina emai aisama, Iesu elao laꞌafou afugai eꞌina epamalele. Ke papiau maꞌo isa aina kelogonia auꞌi kekauai alogaina, ke ifoꞌi mo aloꞌiai keifa keinaka, “Iꞌina auga kapai iꞌina kapaꞌi eafiiꞌi? Ke iꞌina ikifa kapa isa kepeniia kai, mirakulo ekapaꞌi? ");
INSERT INTO mek_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Isa eꞌa ipaapa auga laaꞌi ma? Ke isa Maria gauga, ke James, Iosepa, Judas, Saimon aaꞌi laaꞌi ma? Ke afakua isafa inae fou alaagu ma?” keoma. Ke iina keifa oma keifa apala penia, ke keumakalaina. ");
INSERT INTO mek_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kai Iesu isa epainiꞌi einaka, “Pagua iꞌoina papiauꞌi auga profeta agaꞌo au akaikiꞌa kepamia keifa koko. Kai ifo ega paguai, aaga akina epoꞌiai, ke ifo ega eꞌai auga kai agaꞌo isa au akaikiꞌa aepamia aeifa koko,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ke papiau Iesu akepakoꞌania puo, egae ifo ega paguai mirakulo agaꞌo aekapaisa. Kai isafa auꞌi isaꞌi mo kaniaꞌiai ima eogeaua epafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ke Iesu papiau isa akepakoꞌania auga eisa aisama, ekauai alogaina. Ke egaꞌina afegai Iesu ekailai pagua pagua epeaiꞌi epamalele efai elaoaina. ");
INSERT INTO mek_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Iesu pagua pagua epeaiꞌi epamalele efai elao alogai, kina agaꞌogai ega apostolo 12 eifa kaiguguiꞌi kai gua gua eulaiꞌi. Ke eulaiꞌi aisama, tiapolo fekepapealaiꞌi auga isapuga epeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ke eifa kapula peniꞌi, akelao alogai palafa agaꞌo fakeafia, putepute fakeafia, egeꞌiai moni agaꞌo fakeuka kai, iꞌini mo fekeafia. ");
INSERT INTO mek_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ke kamata fekegafauka kai tiapu iꞌiuka eo agaꞌo fakeafia eoma. ");
INSERT INTO mek_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ke iina isafa epaini omaꞌi, “Afu kapagai eꞌa agaꞌogai agokoko aisama, egaꞌina mo eꞌagai foagu felao, afu egaꞌina fopuaꞌafuga. ");
INSERT INTO mek_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ke afu agaꞌogai papiau afakeifa kokoimi, o ainami afakelogo koa aisama, afu egaꞌina agopuaꞌafuga aisama, keumakalainimi gouga fokapa ifemi aeapuga foauopuaina. Iifa gome maamiai laifania. Muni Deo papiau eꞌi laomai felo, o apala afa agepeniꞌi aisama, taoni egaꞌina oi keumakalainimi auꞌi, afa apala ipauma agepeniꞌi. Ke afa apala egaꞌina auga Sodom, ke Komora fou papiauꞌi eꞌi laomai apala afa agepeniꞌi auga agekaꞌegaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ke Iesu isa epainiꞌi efua aisama, kepealai kelao papiau eꞌi laomai apalaꞌi fekeumakalainiꞌi auga inogoga keinogo. ");
INSERT INTO mek_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ke tiapolo maꞌo papiau aloꞌiai keagu auꞌi kepapealaiꞌi, ke oiliai isafa papiauꞌi kaniaꞌi keꞌefaisa, ke kepafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ega kinaꞌiai kin Herod, Iudea ago eꞌima auga Iesu fouga elogo. Gome Iesu aka afu maꞌoai mo aloꞌiai efoufaꞌa. Ke isa einaka, “Ioane Baptista emaunimue. Ega kainai mirakulo isapuꞌi isa faagagai kepinauga,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kai papiau isaꞌi keinaka, “Isa Elaija,” keoma. Ke papiau isaꞌi auga keinaka, “Isa profeta auga, o ufaina profetaꞌi koa iꞌopoꞌi agaꞌo,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kai Herod iꞌina fouga elogo aisama, ifo mo eifa einaka, “Isa auga Ioane, aiso lafoua auga. Ke isa emaunimue,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Gome Herod ifo, isa akina akafa Herodias puogai ega au auꞌi eulaiꞌi kelao Ioane keafiia kepatipulania. Gome isa Herodias eakafania. ");
INSERT INTO mek_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Isa ega koa ekapaisa, gome Ioane Herod epainia einaka, “Oi akimu akafa loakafania auga felo laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ega puo Herodias Ioane fou epoꞌiai akekua eka, ke gaaupugua eoma kai, aekainia. ");
INSERT INTO mek_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Gome Herod Ioane emaniꞌiaina, ke elogo Ioane auga alo opai ke alo lolofa auga. Ega puo isa Ioane eafiapia mo fou keagu. Ke isa Ioane aina elogonia aisama, kapa maꞌo mo ekapaiꞌi ke alogamai mo isa aina elogonia. ");
INSERT INTO mek_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ke fuagai kina felo agaꞌo Ioane femae auga kina emai. Egaꞌina auga Herod ega mauni kina emai aisama, lopia akaikiꞌaꞌi, ifani lopiaꞌi, ke Kalilea lopiaꞌi akaikiꞌaꞌi fauꞌiai miamia akaikiꞌa ekapaisa. ");
INSERT INTO mek_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ke Herodias gauga ifiaoga emai egefa, Herod ke ega laꞌafou auꞌi aloꞌi epagama aisama, Herod ifiao epainia einaka, “Kapaꞌina anina loani auga eeuai mogoina, lau oi alapenio,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ke epakoꞌania isa maagai pakoꞌa iifaga ekapaisa, ke epainia einaka, “Kapaꞌina alogoiniau auga alapenio. Oi lau eꞌu ago fofouga apie moafia alooma alogoiniau mo ganinagai alapenio,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ke ifiao elao ina epainia einaka, “Kapaꞌina alagoina?” eoma. Ke ifiao ina einaka, “Ioane Baptista kania fooma,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ke ifiao efiaisakoa mo elao Herod eegai epainia einaka, “Lau anina laani Ioane Baptista kania pau litiai gakauka mopeniau,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ke Herod iꞌina iifaga aꞌo elogonia aisama, alo emafu alogaina kai, ega pakoꞌa iifaga, ke ega laꞌafou auꞌi kaiꞌiai, ifiao ega iifa aepamafua. ");
INSERT INTO mek_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ke fiakoa mo Herod ega au, painao auꞌi eaupuguꞌi auga eifa kapula penia galao Ioane kania gamaiseina eoma. Ke isa elao tipulai Ioane aiso efoua. ");
INSERT INTO mek_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ke kania litiai eogeuka emaiseina ifiao epeniia, ke ifiao eafiia ina epeniia. ");
INSERT INTO mek_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ke Ioane ega imoi iꞌina fouga kelogo aisama, kemai imaauga keafiia kelao laai keogeisa. ");
INSERT INTO mek_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Iesu apostolo 12 eulaiꞌi auꞌi kemue kemai Iesu eegai keapa lofe kai, maagai kapaꞌina mo kekapaiꞌi, ke kepamaleleniꞌi auꞌi fouꞌi keifaniꞌi. ");
INSERT INTO mek_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ke epainiꞌi einaka, “Oi ifomi mo oomai lau fou alao, afu oapugai afa amalaagai,” eoma. Gome papiau maꞌo alogaina egae kelao kemai, ke isa ifoꞌi mo fekeagu fekelaagai auga aekainiꞌi ke fekeaniani mo ganinagai aekainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ke Iesu, ke apostolo ifoꞌi mo fou gaagai keaguka afu oapuga kelao. ");
INSERT INTO mek_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kai papiau maꞌo isa keisaꞌi kekailai auꞌi, isa kaisau auga keisa feloꞌi puo, papiau taoni maꞌo aloꞌiai keagu auꞌi ifeꞌiai kepiau keufai kelao Iesu ega apostolo fou akekoko afugai kepealai. ");
INSERT INTO mek_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ke Iesu gaagai eapa opu aisama, laꞌafou akaikiꞌa ipauma eisa. Ke eisaꞌi guaꞌi eani alogaina, gome isa auga sipi koa iꞌopoꞌi kai iꞌimaꞌi auga laaꞌi. Ke eꞌina kapa maꞌo mo epamaleleniꞌi. ");
INSERT INTO mek_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ke Iesu papiau epamaleleniꞌi mo elao kina eapa pagai aisama, ega imoi eega kemai kepainia keinaka, “Pau kina maaga efua, ke iꞌina afugai kai agaꞌo aeagu. ");
INSERT INTO mek_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ega puo moulaiꞌi kegalao ega koa pagua kainagai, ke taoni afe paguaꞌiai ifoꞌi eꞌi foꞌama agaꞌo fekeꞌafa, gome isa eeꞌiai kapa agaꞌo laaꞌi afakeania,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kai isa einaka, “Oi kapa agaꞌo isa amopeniꞌi kegaania,” eoma. Ke isa keinaka, “Egaꞌina auga lai au agaꞌo gafa imagea kuagai gua epinauga afa monina agaafia foꞌama agaꞌafa kai agekaina. Kai lai eemaisai moni ega koa laaꞌi kai, amalao moni ega koa palafa faagagai amapapinauga iꞌina papiauꞌi amapeniꞌi kegaania looma ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ke Iesu isa epaꞌani peniꞌi einaka, “Palafa pika eemiai ekae? Amolao amoisa,” eoma. Ke kelao keisa aisama kemue kemai keinaka, “Palafa ima, ke maꞌa gua,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ke ega imoi epainiꞌi papiau kegaꞌeaꞌi laꞌafou eꞌeleꞌi eꞌeleꞌiai mukimukiai kegaagukipo eoma. ");
INSERT INTO mek_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ke keꞌeaiꞌi laꞌafou isaꞌiai papiau 100, ke isaꞌiai auga papiau 50 keagu. ");
INSERT INTO mek_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ke Iesu palafa ima, maꞌa gua fou eafiiꞌi aisama, ufa eakae penia, Deo maagai tenkiu eifania, ke palafa efaiponiꞌi. Ke ega imoi epeniiꞌi papiau agoꞌiai kegaogeꞌi eoma. Ke maꞌa gua isafa eꞌeaiꞌi maꞌoai epeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ega aisama mirakulo akaikiꞌa ipauma emia, papiau maꞌoai keanipugu aloꞌi ekainia. ");
INSERT INTO mek_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Keaniani afegai, palafa maꞌa fou keaniꞌi isaꞌi, ke ameꞌafuꞌi auꞌi Iesu ega imoi kepakai guguainiꞌi, aleꞌa 12 akeꞌi kepapoguꞌi. ");
INSERT INTO mek_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ega kinagai Iesu papiau epaanianiꞌi auꞌi, au mo kepaauniꞌi auga auꞌi maꞌoai mo 5000. ");
INSERT INTO mek_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ke fiakoa mo Iesu ega imoi epainiꞌi gaagai keaguka keufai Betsaida kelao kai, isa ifo auga eapakipo laꞌafou epakaininiꞌi. ");
INSERT INTO mek_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ke isa epakaniniꞌi kelao aisama, gamegamega eoma puo elao iku agaꞌogai. ");
INSERT INTO mek_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ke epagapigapi isa ega imoi gaagai keaguka auꞌi kelao aꞌu ipuainagai aisama, Iesu ifogamo aagoai eapa. ");
INSERT INTO mek_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ke Iesu ega imoi gaaga kepokeisa kegalao keoma auga aekainiꞌi eisaꞌi, gome ameku epua apuꞌi. Ke afa emageisa aisama, aꞌu laagai epea eeꞌi elao. Ke Iesu elao isa afaꞌagamo fekaꞌegainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kai isa maaꞌi elao Iesu aꞌu laagai epea keisa aisama, keopolaga isage agaꞌo keoma puo keagagapea. ");
INSERT INTO mek_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Gome maꞌoai maaꞌi elao isa keisa, ke kemaniꞌi alogaina. Kai Iesu fiakoa mo isa epainiꞌi einaka, “Folomaniꞌi! Iꞌina lau! Alomi gakapula,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Egae kai elao eeꞌiai gaagai eapauka aisama, ameku eapakipo. Ke isa kekauai alogaina ke keopofua. ");
INSERT INTO mek_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Gome isa palafai papiau epaanianiꞌi auga gouga akelogo felo. Ke isa egaꞌina oko akelogo gome isa guaꞌi epaꞌinokania. ");
INSERT INTO mek_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ke kepagai kelao aisama, kelao Kenesaret foegai keofau egae gaaga kegopeisa. ");
INSERT INTO mek_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ke gaagai keapa opu aisama, fiakoa mo papiau Iesu keisa felo. ");
INSERT INTO mek_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ke kepiau pagua pagua aloꞌiai kekoko, isafa papiauꞌi maiꞌileꞌi mo kepuaiꞌi Iesu kapai eagu fouga kelogo auga afuga kelaoainiꞌi. Ke Iesu egaꞌina papiauꞌi maꞌoai epafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ke Iesu ala elao, pagua ma, taoni ma, taoni afe ma paguaꞌi elao ma ganinagai, papiau isafa auꞌi kemaiseiniꞌi afaꞌafa afuꞌiai kepakalaꞌi. Ke egaꞌina papiauꞌi Iesu kegoinia afe tiapuga kua mo kegaafi opogaina keoma. Ke maꞌoai isa keafi opogaina auꞌi feloꞌi kemia. ");
INSERT INTO mek_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Egae kai Faliseo auꞌi ke Moses ega iifa pamalelega auꞌi isaꞌi Ierusalemeai kemai auꞌi kemai Iesu keapa lofe. ");
INSERT INTO mek_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ke isa Iesu ega imoi eꞌi kelele agaꞌo kekapulaisa auga, isa imaꞌi akeikuisa kai imaꞌi maiofuga mo palafa keafiia keaniia keisaꞌi. ");
INSERT INTO mek_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Gome Faliseo auꞌi ke Iudea papiauꞌi ufuꞌi apaꞌi eꞌi kagakaga keafiꞌinia kainai, imaꞌi keiku felo kai keaniani. ");
INSERT INTO mek_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ke afaꞌafa afugai kemai aisama, keufele kai keaniani. Ega koa iꞌopoga, kagakaga maꞌo keafiapiꞌi. Egaꞌina auga kaputi iikuꞌi, liti iikuꞌi, ke oga iikuꞌi kagakagaꞌi.) ");
INSERT INTO mek_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ega puo Faliseo auꞌi ke Moses ega iifa pamalelega auꞌi Iesu kepaꞌani penia keinaka, “Kapa puo oi emu imoi ufu apa kagakaga kainai akepea kai, imaꞌi maiofuga mo keaniani?” keoma. ");
INSERT INTO mek_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ke Iesu einaka, “Oi pifoge aumi, malami eꞌagaꞌaga! Deo ega profeta Aisaea, ufainagai foumi Deo ega iifa pukagai eifa kakaua auga koꞌa. Egaꞌina fouga iina epapua oma: “‘Iꞌina papiauꞌi fifinaꞌiai mo Lau au akaikiꞌau kepamiaisau. Kai isa aagoa kapaꞌi mo keguakaeainiꞌi puo, aloꞌi ipauma auga Lau eeuai laaꞌi. ");
INSERT INTO mek_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ke isa papiau aumauni eꞌi iifa kepagamaꞌi auꞌi mo kaiꞌiai papiau kepamaleleniꞌi. Ega puo isa Lau keau afagainiau auga keau afagai aageniau mo.’” ");
INSERT INTO mek_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Gome oi Deo ega iifa ooge meꞌeꞌi kai, papiau aumauni eꞌi kagakaga auꞌi oafiꞌiniꞌi. Egaꞌina auꞌi, oga ke kaputi aloꞌi oikuꞌi ke kapa ega koa iꞌopoꞌi mo okapaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ke epainiꞌi pugu einaka, “Oi ala fooma Deo ega iifa fooge meꞌeꞌi, ega koa ifomi emi kagakaga foafiapi inokania auga ologo felo. ");
INSERT INTO mek_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Gome ufainagai Moses eifa einaka: ‘Inamu amamu ainaꞌi foafia fopalopianiꞌi,’ eoma. Ke iina isafa eifa oma: ‘Kaisau ina ama epaina, Deo isa afa apala fepenia eoma auga feisaupugu,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kai oi oifa, au agaꞌo ina o ama agepaina ageinaka: ‘Pipalagai kapaꞌi mo lau eeuai loafia auga, pipeni egaꞌina auga Deo ipalao penia emia,’ ooma. ");
INSERT INTO mek_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ke isa egaꞌina eifania afegai, oi isa alologoaina kapa agaꞌo aekapa ina o ama aepalagaina. ");
INSERT INTO mek_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Oi ega koa okapa emi kagakaga ofake opua aisama, Deo ega iifa kapa agaꞌo laaꞌi opamia. Ke kapa maꞌo mo isafa ega okapa omaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ke Iesu laꞌafou eifaga pugu eega kemai aisama, epainiꞌi einaka, “Maꞌoai mo ainami amopaaua ainau amologo, ke iꞌina iifaga kapaꞌina eifania auga fologo felo. ");
INSERT INTO mek_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kapa agaꞌo afegai elao au agaꞌo alogai ekoko auga isa aepaofua. Kai kapaꞌina au alogai epealai emai auga isa epaofua. ");
INSERT INTO mek_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kaisau aina ekae auga aina gapaaua,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ke Iesu laꞌafou epuaꞌafuga afegai elao eꞌai ekoko aisama, isa ega imoi egaꞌina palapole kapaꞌina eifania auga kegalogo keoma puo kepaꞌani penia. ");
INSERT INTO mek_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ke Iesu isa epainiꞌi einaka, “Oi isafa iꞌina iifaga kapaꞌina eifania auga alologo felo ma? Kapaꞌina au alogai ekoko auga isa aepaofua auga alologo felo ma? ");
INSERT INTO mek_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Gome kapaꞌina au eania auga gua fopa alogai aekoko kai, inaega alogai ekoko ke epealai pugu,” eoma. (Iesu egaꞌina eifania auga foꞌama maꞌoai aiofuꞌi eoma.) ");
INSERT INTO mek_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ke eifa pugu einaka, “Kapaꞌina au gua alogai epealai auga isa alo epaofua. ");
INSERT INTO mek_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Gome au gua alogai opola apalaꞌi kemai. Egaꞌina auga ifiao oꞌoae fou feuga, aufalao agaꞌo eamage kai papiau iꞌoina agaꞌo eamage efua auga fou kefeu aagemo, ke papiau agaꞌo fou fofeu auga opolaga. ");
INSERT INTO mek_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ke painao, auau, mogemoge, guakupu, pifoge, pikupa, papiau eꞌi kapa imaaniꞌi, papiau ipaagu fofouꞌi, ainaꞌau, ke pakafoꞌo. ");
INSERT INTO mek_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iꞌina laoꞌi maiꞌi maꞌoai au alogai kepealai kepaofua,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Egae kai Iesu Kalilea ago epuaꞌafuga elao Taire ke Sidoni taoniꞌi agoꞌiai ekoko. Ke kai agaꞌo faelogo eoma puo, elao eꞌa agaꞌogai ekoko. Kai isa elao egae auga ogefake gapamia eoma kai aekainia, papiau kelogo paisa. ");
INSERT INTO mek_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Gome papie agaꞌo gauga papiega eꞌele alogai tiapolo ekoko auga Iesu fouga elogo, ke emai Iesu ife foꞌinai eꞌualai eomukipo. ");
INSERT INTO mek_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Egaꞌina papiega auga Grik papiega, Siria, Fenisia agogai emauni. Isa Iesu egoi penia gauga papiega alogai tiapolo gapapealaisa eoma. ");
INSERT INTO mek_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kai Iesu isa epainia einaka, “Lau eꞌu papiau Iudea papiauꞌi imoi eꞌeleꞌi koa iꞌopoꞌi auꞌi alapalagai kakauꞌi aloꞌi agekaina aisama kai, oi papiau aagemi alapalagainimi. Gome imoi eꞌeleꞌi eꞌi palafa foafia amuꞌe fopeniꞌi auga felo laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kai papie einaka, “Iifa gome eꞌu Lopia kai, amuꞌe ganinagai imoi eꞌi palafa ameꞌafuꞌi teipolo papagai keaꞌopu auꞌi keaniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ke Iesu papie epainia einaka, “Loifa felo! Oi emu iifa egaꞌina kainai momue molao, tiapolo gaumu epuaꞌafuga efua,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ke papie emue ega eꞌa elao aisama, gauga petiai eka, ke tiapolo isa epuaꞌafuga eisa. ");
INSERT INTO mek_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ke Iesu Taire ke Sidoni taoniꞌi agoꞌi foega epuaꞌafuga pugu elao Kalilea aꞌugai, ke foe mo elao Taoni Ouꞌaga keoma afugai epealai. ");
INSERT INTO mek_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Egae papiau isaꞌi ainafua ke akeafu auga agaꞌo Iesu eega kemaiseina, ke kegoi penia ima kania laagai gaogeaua keoma. ");
INSERT INTO mek_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ke Iesu egaꞌina auga laꞌafouai epapealaisa auniꞌi kelao meꞌegai kai, ima kekeꞌeꞌi au ainagai ekaukaꞌi, eꞌupe, ke au egaꞌina mala eafi opogaina. ");
INSERT INTO mek_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ke ufa eakae penia eapoki kai eifa einaka, “Efata!” eoma. Efata auga iꞌa malaꞌaisai, ‘Moalai,’ fouga eifania. ");
INSERT INTO mek_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ke fiakoa mo au aina keagalai, mala emameꞌa, ke eꞌina eniniꞌani felo. ");
INSERT INTO mek_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ke Iesu papiau epaini kapulaniꞌi kapaꞌina emia auga kai agaꞌo maagai fakeifania eoma. Kai isa epainiꞌi maꞌo epamia kai agaꞌo maagai fakeifania eoma mo ganinagai, isa kelao kapaꞌina emia auga fouga keifania akeapakipo. ");
INSERT INTO mek_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ke papiau kekauai keopofua ke keifa keinaka, “Kapa maꞌoai ekapa feloꞌi. Isa ainafua auꞌi epafeloꞌi aꞌoaꞌo kelogo, ke akeafu auꞌi isafa epafeloꞌi keniniꞌani,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Egaꞌina kina aloꞌiai laꞌafou akaikiꞌa ekaigugu pugu. Kai foꞌama laaꞌi puo, Iesu ega imoi eifaniꞌi eega kemai, ke epainiꞌi einaka, ");
INSERT INTO mek_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Lau laꞌafou papiauꞌi iꞌina guaꞌi laani alogaina. Gome isa lau fou inae aagu kina oiso elao efua. Ke pau foꞌama laaꞌi afakeaniani. ");
INSERT INTO mek_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ke lau isa inaeꞌi maikimuga mo alaulaiꞌi eꞌi pagua akelao koa aisama, keagai maaꞌi agepiu akeꞌualai. Gome isa isaꞌi agomaai kemai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ke Iesu ega imoi keinaka, “Afu oapuga iina koa auga, kapai aufalao agaꞌo palafa maꞌo ageafia papiau agepaanianiꞌi?” keoma. ");
INSERT INTO mek_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ke Iesu epaꞌani einaka, “Palafa pika eemiai ekae?” eoma. Ke isa keinaka, “Imagea kuagai gua,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iesu palafa pika auga keifania elogo aisama, papiau epainiꞌi aagoai keagukipo. Ke palafa imagea kuagai gua egaꞌina eafiiꞌi Deo maagai tenkiu eifania efua aisama, efaiponiꞌi ega imoi epeniiꞌi papiau agoꞌiai kegaogeꞌi eoma. Ke Iesu ega imoi isa eifania koa kekapaisa. ");
INSERT INTO mek_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ke maꞌa eꞌeleꞌi isaꞌi isafa eeꞌiai eka puo, Iesu egaꞌina maꞌaꞌi eafiiꞌi Deo maagai tenkiu eifania kai ega imoi epainiꞌi kegafake papiau kegapeniꞌi eoma. Ke Iesu ega imoi isa eifania koa kekapaisa ");
INSERT INTO mek_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ke papiau keaniani aloꞌi ekainia. Egae kai Iesu ega imoi papiau palafa keaniꞌi isaꞌi kepuaꞌafuniꞌi auꞌi, ke ameꞌafuꞌi fou kepakai guguainiꞌi, aleꞌa imagea kuagai gua akeꞌi kepapoguꞌi. ");
INSERT INTO mek_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Papiau auꞌi maꞌoai mo 4000 koa iꞌopoga egae epaanianiꞌi. Ke keaniani afegai Iesu laꞌafou epakaniniꞌi. ");
INSERT INTO mek_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Egae kai fiakoa mo ega imoi fou gaagai keaguka Dalmanuta ago kelao. ");
INSERT INTO mek_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ke kelao Dalmanuta agogai aisama, Faliseo auꞌi kemai keꞌina Iesu kepaꞌani penia, ke keꞌopoisa kepainia gou agaꞌo ufa guagai gakapa kegaisa keoma. ");
INSERT INTO mek_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ega aisama Iesu eapoki kai eifa einaka, “Kapa puo iꞌina papiauꞌi Deo ega isapu gouga mirakulo kepaꞌaniaina? Iifa koꞌa maamiai laifania Deo ega isapu gouga iꞌina papiauꞌi afalapeniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Egae kai Iesu ega imoi fou Faliseo auꞌi kepuaꞌafuniꞌi gaagai keaguka kepagai ofuga apie kelao. ");
INSERT INTO mek_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ke kelao alogai, Iesu ega imoi keꞌagege palafa maꞌo akeafia kai, agaꞌomo gaaga alogai eka auga eisa. ");
INSERT INTO mek_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ega aisama ega imoi ainaꞌi epalogo einaka, “Maami fekiakae! Herod ke Faliseo auꞌi eꞌi pifoge auga, palafa iuma mulamula palafa alogai keoge eufu koa iꞌopoga, isa eꞌi pifoge isafa euki papiau epoꞌiai ekoko epalifuꞌi auga foisa felo,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ega aisama Iesu ega imoi ifoꞌi mo epoꞌiai iꞌina niniꞌanina fouga keifania keinaka, “Iꞌa eeꞌaisai palafa laaꞌi puo, isa ega eifa oma,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ke Iesu isa kapaꞌina fouga keifania auga elogo aisama, epaꞌani peniꞌi einaka, “Kapa puo palafa aloafiꞌi auga fouga oifania? Oi aloisa felo, ke kapaꞌina laifania auga oko alologo felo koa ma? Guami eꞌinoka alogaina! ");
INSERT INTO mek_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Oi maami ekae kai aloisa. Ainami ekae kai aꞌoaꞌo alologo koa iꞌopoga. Ke kapa agaꞌo aloopolaga ma? ");
INSERT INTO mek_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Lau palafa ima papiau 5000 fauꞌiai lafaiponiꞌi keaniia aisama, palafa akeaniꞌi eoꞌi auꞌi aleꞌa pika akeꞌi opapoguꞌi?” Ke ega imoi keinaka, “Aleꞌa 12,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ke Iesu epaꞌani pugu einaka, “Ke papiau 4000 fauꞌiai palafa imagea kuagai gua lafaiponiꞌi keaniia aisama, palafa akeaniꞌi eoꞌi auꞌi aleꞌa pika akeꞌi opapoguꞌi?” eoma. Ke isa keinaka, “Aleꞌa imagea kuagai gua,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ega aisama Iesu einaka, “Egaꞌina auga kapaꞌina eifania auga oko alologo koa ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Iesu ega imoi fou gaagai kemai Betsaida paguagai keofau. Ega aisama papiau isaꞌi maakimiꞌi auga agaꞌo Iesu eega kemaiseina, ke kegoinia gaafi opogaina keoma. ");
INSERT INTO mek_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ega aisama Iesu maakimiꞌi auga imagai eafi epapealaisa pagua afe elaoaina. Ke egae au maaga eꞌupeisa, ke ima maagai eogeaua aisama, epainia einaka, “Kapa agaꞌo loisa ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ke au ekiakae kai einaka, “Papiau laisaꞌi kai, au keuki koa iꞌopoꞌi kepealao kepeamai laisaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ega aisama Iesu ima au maagai eogeaua pugu, ke epainia gaakae eoma. Ke eakae aisama, maaga ekiakae felo emia, ke kapa maꞌoai eisa feloꞌi. ");
INSERT INTO mek_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ke Iesu au eulaisa ega eꞌa elao kai epainia einaka, “Pagua alogai folokoko,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Egae kai Iesu ega imoi fou Kalilea ago kepuaꞌafuga, ifeꞌiai Sisarea Filipi ago paguaꞌi kelao. Ke kelao keagai kepeapea kai, ega imoi epaꞌani peniꞌi einaka, “Papiau lau kaisau keoma?” eoma. ");
INSERT INTO mek_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ke isa keinaka, “Isaꞌi keifa ‘Oi Ioane Baptista emae emaunimue’ keoma. Ke isaꞌi keifa ‘Oi Elaija’ keoma. Ke isaꞌi keifa ‘Oi auga ufaina profetaꞌi agaꞌo emaunimue emai,’ keoma.” ");
INSERT INTO mek_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ega aisama Iesu isa epaꞌani peniꞌi einaka, “Ke oi, oi auga lau kai ooma?” eoma. Ega aisama Peto einaka, “Oi auga Kristo aumu,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ke Iesu ega imoi eifa kapula peniꞌi kai agaꞌo maagai isa kaisau auga fakeifania eoma. ");
INSERT INTO mek_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Egae kai Iesu eꞌina ega imoi epamaleleniꞌi. Ke maaꞌiai Papiau Aumauni Gauga kapa maꞌo mo fauꞌiai fekiekie, ke au akaikiꞌaꞌi, sakedote lopiaꞌi, ke Moses ega iifa pamalelega auꞌi isa fekeumakalaina fekeaupugua kai, kina oiso afegai femaunimue pugu auga fouga eifania. ");
INSERT INTO mek_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iesu ifo fouga iina eifa ofakae oma puo, Peto Iesu epapea auniꞌi kelao meꞌegai kai, efinaisa ega faeifa oma eoma. ");
INSERT INTO mek_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kai Iesu eꞌafoaipini ega imoi eisaꞌi kai, Peto efinaisa einaka, “Satani! Muniu mai lao. Oi auga Deo ega amu foafia auga opolaga aloafia kai, papiau aumauni eꞌi amu foafia auga opolaga loafia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Egae kai Iesu ega imoi ke laꞌafou papiauꞌi fou eifaniꞌi eega kemai kai epainiꞌi einaka, “Kaisau lau muniuai gapea eoma auga, ifo feꞌagegeaina kai ega koloti fepua muniuai fepea. ");
INSERT INTO mek_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Gome kaisau ifo kania gaagamauga eoma auga agepagea. Kai kaisau lau fauai, ke iifa faunina faugai agemae auga, ifo kania ageagamauga. ");
INSERT INTO mek_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Gome au agaꞌo agofaꞌai kapa maꞌoai ega kapa agepamia kai lalauga agepagea koa aisama, kapa felo agaꞌo isa eegai agemia ma? Laaꞌi! ");
INSERT INTO mek_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ke au agaꞌo lalauga agepagea koa aisama, kapaꞌina agepipeni lalauga ageafimue? Kapa agaꞌo laaꞌi! ");
INSERT INTO mek_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ega puo kaisau Deo anina aeani, ke iꞌina agofaꞌagai papiau Deo aina akeafia, amage koa laoga maina kekapa, ke opoꞌi aloꞌi fou apala auꞌi koa agemia lau agemeagaiainiau, ke eꞌu iifa isafa agemeagaiaina auga, Papiau Aumauni Gauga Ama ega Akaikiꞌa Isapugai, ke agelo Deo maagai aloꞌi elolofa auꞌi fou akemai aisama, isa isafa egaꞌina auga ");
INSERT INTO mek_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ke Iesu ega imoi epainiꞌi pugu einaka, “Iifa koꞌa maamiai laifania, pau isaꞌi inae keapae auꞌi, Deo ega agofaꞌa maiꞌisapuga agemai akeisa kai akemae,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kina imagea elao afegai, Iesu ega imoi Peto, James, Ioane fou eꞌafeiniꞌi kelao iku eꞌagau alogaina auga ikugai keꞌagaukae. Kelao egae ifoꞌi mo keaguega kai Iesu agoꞌiai eponi. ");
INSERT INTO mek_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Isa afe tiapuga kimage eafi eaea koa emia, ekelo alogaina snou koa iꞌopoga emia, kai agaꞌo agofaꞌai ega tiapu feikua isa ega tiapu ekelo koa femia faekaina. ");
INSERT INTO mek_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ke egae agoꞌiai Elaija Moses auniꞌi keapafoki, Iesu fou keniniꞌani keisaꞌi. ");
INSERT INTO mek_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ega aisama Peto Iesu epainia einaka, “Rabai, lai inae oi fou aague auga felo. Efeꞌefe oiso amakapaꞌi, agaꞌo oi apumu, agaꞌo Moses apuga, ke agaꞌo Elaija apuga,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peto, ke James Ioane auniꞌi isafa kemaniꞌi alogaina, ke kapaꞌina fekeifania auga akelogo puo, Peto ega eifa oma. ");
INSERT INTO mek_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Egae kai apuapu emai Iesu, Elaija ke Moses fou eumi apuꞌi, ke apuapu alogai niniꞌani aꞌo emai kelogonia, “Inaꞌina auga lau Gau, anina laani alogaina. Ega puo oi isa aina foafia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ke fiakoa mo apostolo auꞌi oiso maaꞌi kegoaisa aisama, kai agaꞌo isa fou egae akeapa akeisaꞌi kai, Iesu ifogamo egae eapa keisa. ");
INSERT INTO mek_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ke ikuai keake kemai alogai, Iesu isa epaini kapulaniꞌi kapaꞌina emia keisa auga, kai agaꞌo maagai fakeifania felao Papiau Aumauni Gauga maeai femaunimue afegai kai, fekeifafoua eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ke Peto James, ke Ioane auꞌi oiso egaꞌina iifaga aloꞌiai mo eka, ke ifoꞌi mo epoꞌiai “maeai femaunimue auga kapaꞌina,” eifania auga paꞌanina kepaꞌani. ");
INSERT INTO mek_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Egae kai isa Iesu kepaꞌani penia keinaka, “Kapa puo Moses ega iifa pamalelega auꞌi Elaija femai kaukau keoma?” ");
INSERT INTO mek_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ke isa einaka, “Elaija femai kaukau auga iifa koꞌa, ke kapa maꞌoai fepaꞌuegeniꞌi pugu. Kai kapa puo Papiau Aumauni Gauga kapa maꞌo mo fauꞌiai fekiekie alogaina, ke papiau isa fekeumakalaina auga profeta Deo ega iifa pukagai kepapua? ");
INSERT INTO mek_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kai lapainimi, Elaija emai efua kai Deo ega iifa pukagai isa fouga papiau anina keani akekapa keoma kepapua auga, iꞌopoga mo isa faagagai kekapa afeꞌaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ke Iesu ega apostolo auꞌi oiso fou kemai ega imoi isaꞌi eeꞌiai aisama, laꞌafou akaikiꞌa isa keapa lofeꞌi, ke Moses ega iifa pamalelega auꞌi fou keakekua eisaꞌi. ");
INSERT INTO mek_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ke papiau maꞌoai Iesu keisa aisama, kekauai alogaina ke kepiau apua kepamegonia. ");
INSERT INTO mek_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ke Iesu Moses ega iifa pamalelega auꞌi epaꞌani peniꞌi einaka, “Kapaꞌina akekua opaꞌaua?” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ke au agaꞌo laꞌafou alogai einaka, “Pamalele Aumu, tiapolo lau gau alogai eague ake eafunia puo aeniniꞌani. ");
INSERT INTO mek_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kina isaꞌi tiapolo imoi eafia aꞌisaai efouga, ke akegai fukofuko eaꞌalai, nie eapalolia, faaga efaꞌiꞌi. Ke lau oi emu imoi lapainiꞌi tiapolo kegapapealaisa laoma kai aekainiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ega aisama Iesu einaka, “Oi iꞌina papiaumi alomi koꞌagai lau alopakoꞌaniau! Lau inae kina pika fou afaagu, ke kina pika alou eemiai afaafiapia mo afelaolao? Imoi eeu amomaiseina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ega puo imoi kemaiseina. Ke tiapolo Iesu eisa aisama, efiaisakoa imoi imaauga fofouga epapigugunia, ke eꞌualai aꞌisaai elakalaka, akegai fukofuko eaꞌalai. ");
INSERT INTO mek_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ega aisama Iesu imoi ama epaꞌani penia einaka, “Kina pika iina emia oma?” eoma. Ke imoi ama einaka, “Eꞌelegai koa ega koa mo emai pau. ");
INSERT INTO mek_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ke tiapolo imoi gapamaea eoma puo kina isaꞌi loai eꞌafoaua o feisai eꞌafolaisa. Ega puo kapa agaꞌo afokapa koa, guamai moania mopalagainimai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ke Iesu einaka, “Afokapa koa! Kaisau epakoꞌania auga eegai kapa maꞌoai agekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ke imoi ama maaga maiꞌiuiuga mo efiaisakoa mo eagaga einaka, “Lau lapakoꞌanio. Mopalagainiau eꞌu pakoꞌa eapoke auga eegai mopapealaisau, mapakoꞌa kapulanio,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ke Iesu maaga elao papiau laꞌafouai kepiau isa eega kemai eisaꞌi aisama, tiapolo efinaisa einaka, “Akeafu, ke ainafua tiapolomu! Laifa kapula penio, imoi alogai mopealai, ke folokoko pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ke tiapolo eagagapea, imoi eafiia aꞌisaai efounia epapigugunia kai, alogai epealai. Ke imoi emae koa eka puo, papiau maꞌo egae keapa auꞌi keinaka, “Imoi emae,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kai Iesu imoi imagai eafi epaꞌuegenia eapa. ");
INSERT INTO mek_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Egaꞌina afegai Iesu emai eꞌai ekoko aisama, ega imoi ogefakeai kepaꞌani penia keinaka, “Kapa puo lai tiapolo amapapealaisa aoma aekainia?” keoma. ");
INSERT INTO mek_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ke Iesu einaka, “Tiapolo iina koa iꞌopoga auga megamegai mo akepealai agekaina kai, kapa iꞌoinai auga afaekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Iesu ega imoi fou egaꞌina afuga kepuaꞌafuga kelao Kalilea agogai kepea pagai. Egaꞌina alogai isa kapai keague auga kai agaꞌo oko faelogo eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Gome isa ega imoi gapamaleleniꞌi eoma, ke ifoꞌi mo keagu alogai ega imoi epainiꞌi einaka, “Papiau Aumauni Gauga, papiau imaꞌiai akepaaua, akeaupugua kai, kina oiso aisama agemaunimue pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ke ega imoi isa kapaꞌina eifa auga oko akelogo kai kemaniꞌi puo, akepaꞌani penia. ");
INSERT INTO mek_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Egae kai Iesu ega imoi fou kemai Kapenaum taoninai kepealai. Ke kelao eꞌa agaꞌo alogai kekoko aisama, ega imoi epaꞌani peniꞌi einaka, “Keagai kapaꞌina akekua opaꞌaua?” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kai ega iifa afa akepamue, gome isa keagai ifoꞌi epoꞌiai kaisau akaikiꞌa ipauma auga akekua kepaꞌaua. ");
INSERT INTO mek_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ke Iesu eagukipo kai, ega apostolo auꞌi 12 auꞌi eifaniꞌi, epainiꞌi einaka, “Kaisau anina eani gaufai eoma auga, femuniai ke papiau maꞌoai eꞌi kalaꞌafi koa iꞌopoga femia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Egae kai Iesu imoi eꞌele agaꞌo eafiia agoꞌiai epaapa, ke imagai eafi kai epainiꞌi einaka: ");
INSERT INTO mek_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kaisau lau akauai imoi eꞌeleꞌi eifa kokoꞌi auga, lau eifa kokoisau, ke kaisau lau eifa kokoisau auga, lau aeifa kokoisau kai, lau eulaisau auga eifa koko,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Egaꞌina afegai Iesu ega imoi agaꞌo aka Ioane Iesu epainia einaka, “Pamalele Aumu, au agaꞌo oi akamuai tiapolo epapealaiꞌi aisa aisama, apainia gaapakipo aoma, gome isa iꞌa fou laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kai Iesu einaka, “Folopaapakipo. Gome kaisau lau akauai mirakulo ekapa auga fiakoa mo afaeꞌafoaipini, afaeifa apala peniau. ");
INSERT INTO mek_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Gome kaisau iꞌa afeꞌaisai eaulao auga iꞌa fou agaꞌomo. ");
INSERT INTO mek_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Gome kaisau oi lau Kristo au eꞌu imoi puogai akauai kaputi feina agepenimi auga, iifa gome maamiai laifania, afa felo ageafia paisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ke Iesu eifa pugu einaka, “Kaisau imoi eꞌele iꞌina agaꞌo lau epakoꞌaniau auga laomai apala agaꞌo agepakina agekapa koa aisama, aisogai foꞌama kepaikumuꞌa kepo akaikiꞌa fekepaaukopa kai, aꞌuai fekeꞌafolaisa. ");
INSERT INTO mek_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ke imamu epagagapainio apala lokapa koa aisama, fofoua. Imamu agaꞌomogai agu pagai afugai alokoko auga felo kai, imamu gua lo aealoalo afugai alokoko auga apala ipauma. ");
INSERT INTO mek_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ke ifemu epagagapainio apala lokapa koa aisama, ifemu fofoua. Ifemu agaꞌomogai agu pagai afugai alokoko auga felo kai ifemu gua lo aealoalo afugai alokoko auga apala ipauma. ");
INSERT INTO mek_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ke maamu epagagapainio apala lokapa koa aisama, foꞌiulaisa. Maamu agaꞌomogai Deo ega agofaꞌai alokoko auga felo kai, maamu gua lo aealoalo afugai alokoko auga apala ipauma. ");
INSERT INTO mek_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Egaꞌina afugai ugeuge akemaemae, ke lo aealoalo. ");
INSERT INTO mek_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Gome kikimalu foꞌama epafelo koa iꞌopoga, papiau maꞌoai aloꞌi ke laomai apalaꞌi loai ageumaꞌi. ");
INSERT INTO mek_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kikimalu kapa felo kai ega mekiꞌa agefua koa aisama, ala alokapa oma alopamekiꞌania pugu? Iifa gome maamiai laifania, ifomi alomiai kikimalu mekiꞌaga feka ega koa papiau fou gagaoai foagu,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesu egaꞌina afuga epuaꞌafuga Iudea agogai epea pagai elao Jordan agapuge apiegai. Ke laꞌafou ekaigugu pugu puo, ekapakapa koa iꞌopoga ekapaisa papiau epamaleleniꞌi. ");
INSERT INTO mek_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ke Faliseo auꞌi isaꞌi Iesu eega kemai keꞌopoisa, kepaꞌani penia keinaka, “Au agaꞌo akafa agepaake auga keifa apua ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ke Iesu einaka, “Moses ega iifa alogai epaini kapulanimi kapa eoma?” ");
INSERT INTO mek_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ke isa keinaka, “Moses epapua auga au agaꞌo akafa fepaake malelega fepapua kai akafa fepaake eoma,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ega aisama Iesu einaka, “Oi guami eꞌinoka alogai kainai Moses iꞌina iifaga epapua. ");
INSERT INTO mek_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kai agofaꞌa egama mo alogai, Deo maguae papie fou epagamaꞌi. ");
INSERT INTO mek_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Egaꞌina kainai au ina ama agepuaꞌafuniꞌi akafa auniꞌi akekaifou agaꞌomo akemia. ");
INSERT INTO mek_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ke isa auniꞌi auga imaauꞌi agaꞌomo agemia. Ega kainai isa imaauꞌi auniꞌi laaꞌi kai agaꞌomo. ");
INSERT INTO mek_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ega puo Deo kapaꞌina eogefoua auga papiau aumauni faeaupea,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Iesu egaꞌina eifania afegai, eꞌai kekoko pugu aisama, ega imoi egaꞌina iifaga kapaꞌina eifania auga paꞌanina kepaꞌani penia pugu. ");
INSERT INTO mek_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ega aisama Iesu isa epainiꞌi einaka, “Au agaꞌo akafa agepaake ke papie agaꞌo ageakafania auga, papie epaake auga eegai amage koa laoga maina apala agekapa, papie iꞌoina agaꞌo fou amagelofe laaꞌi kai fou kefeu aage mo auga agemia. ");
INSERT INTO mek_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ke papie akafa agepaake au agaꞌo ageakafania auga, amage koa laoga maina apala agekapa, au iꞌoina agaꞌo fou amagelofe laaꞌi kai fou kefeu aagemo papiega agemia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Papiau gauꞌi Iesu gaafi opogainiꞌi keoma puo, eega kemaiseiniꞌi kai, Iesu ega imoi papiau kefinaiꞌi. ");
INSERT INTO mek_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kai Iesu egaꞌina eisa aisama, gua ekupu ke ega imoi epainiꞌi einaka, “Imoi eꞌeleꞌi folokaisapuꞌi eeu kegamai. Gome Deo ega agofaꞌa auga imoi iina koa iꞌopoꞌi auꞌi apuꞌi. ");
INSERT INTO mek_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Iifa gome maamiai laifania. Kaisau imoi eꞌele koa afaemia Deo ega agofaꞌa afaeafia auga, egaꞌina afugai afaekoko,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ke imoi eafiiꞌi kaniaꞌiai ima eogeaua, ke Deo ega gafegafe akaikiꞌa fekeafia eoma eifa felo peniꞌi. ");
INSERT INTO mek_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesu ekailai epea aisama, au agaꞌo isa epiau apua, agogai eomukipo, epaꞌani penia einaka, “Pamalele felo aumu, kapaꞌina fakapa agu pagai maunina faafia?” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ke Iesu einaka, “Kapa puo lau au felou loomaisau? Kai agaꞌo felo laaꞌi, Deo ifogamo felo ipauma. ");
INSERT INTO mek_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Oi Deo ega iifa Moses epenia auga maꞌoai lologo afeꞌai. Egaꞌina auga kai agaꞌo foloaupugua, amage papiauꞌi fou folofeu aagemo, folopainao, aufalao agaꞌo pifogeai folopaagu fofoua, pifogeai kapa agaꞌo foloafia, ke inamu amamu fopalopianiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ke isa einaka, “Pamalele aumu, egaꞌina kapaꞌi maꞌoai eꞌeleuai laafiꞌiniꞌi mo emai pau,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ega aisama Iesu au maaga eisa anina eani puo epainia einaka, “Kapa agaꞌomo alokapa koa. Molao emu amu maꞌoai moꞌafaꞌafalainiꞌi, ke monina ulalu auꞌi mopeniꞌi ega koa ufai alopaꞌamuꞌamu. Egae kai fomai muniuai fopea,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Au iꞌina iifaga aꞌo elogonia aisama, alo emafu alogaina, ke alokiekieai elao. Gome eegai amu maꞌo keka. ");
INSERT INTO mek_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ega aisama Iesu eꞌafoaipini ega imoi epainiꞌi einaka, “Paꞌamuꞌamu auꞌi Deo ega agofaꞌai kegakoko akeoma kai ageꞌinoka alogaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ke Iesu ega imoi iꞌina iifaga aꞌo kelogonia aisama, kekauai alogaina. Kai Iesu isa epainiꞌi pugu einaka, “Eꞌu imoi, aagoa amuꞌi kepakoꞌaniꞌi auꞌi, Deo ega agofaꞌai kegakoko akeoma kai ageꞌinoka alogaina! ");
INSERT INTO mek_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamelo tiapu ikaina nilaga inegai gapagai auga afaeꞌinoka alogaina agepagai. Kai paꞌamuꞌamu auga Deo ega agofaꞌai gakoko ageoma auga ageꞌinoka alogaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ke Iesu ega imoi kekauai alogaina ke ifoꞌi mo epoꞌiai keifa keinaka, “Ega koa aisama, kaisau koa kaniaꞌi afeisagamau?” keoma. ");
INSERT INTO mek_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kai Iesu isa maaꞌi eisa kai epainiꞌi einaka, “Papiau aumauni eeꞌiai iꞌina agemia afaekaina keoma kai, Deo eegai auga ega koa laaꞌi. Gome kapa maꞌoai Deo eegai agekaina moaꞌina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ega aisama Peto Iesu epainia einaka, “Moisa! Lai kapa maꞌoai apuaꞌafuniꞌi oi munimuai apea,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ke Iesu einaka, “Iifa koꞌa maamiai laifania. Kaisau lau puouai, ke iifa faunina puogai ega eꞌa, aaga akina, ina, ama, gauga, ke ega ago epuaꞌafuniꞌi auga pau iꞌina agofaꞌagai kapaꞌina agaꞌomo epuaꞌafuga auga laagai 100 ageafia. Egaꞌina mo laaꞌi kai, papiau isafa isa akeafi apalania, ke muni aisama agu pagai maunina ageafia. ");
INSERT INTO mek_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kai papiau maꞌo keufai auꞌi akemuniai ke kemuniai auꞌi akeufai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Egae kai Iesu ega imoi fou Ierusaleme kelao. Ke kelao keagai aisama, Iesu Ierusaleme taonina kelao auga afekeafi apalania auga maniꞌina aepaꞌaua kai ifogamo eufai epea puo, ega imoi isa keisa kekauai alogaina. Ke papiau muniꞌiai kepea auꞌi isafa isa ega koa ekapaisa keisa aisama, kemaniꞌi alogaina. Ega aisama Iesu ega imoi auꞌi 12 auꞌi eafiiꞌi meꞌe elaoainiꞌi pugu kai, kapaꞌina isa faagagai agemia auga maaꞌiai fouga eifania. ");
INSERT INTO mek_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ke eifa einaka, “Amoisa! Pau agaꞌagau Ierusaleme agalao, ke egae Iudea papiauꞌi Papiau Aumauni Gauga akeafia, eꞌi sakedote lopiaꞌi ke Moses ega iifa pamalelega auꞌi imaꞌiai akepaaua, ke femae akeoma. Egae kai akeafia Iudea papiauꞌi laaꞌi auꞌi imaꞌiai akepaaua. ");
INSERT INTO mek_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ke egaꞌina papiauꞌi isa akepaꞌaua, akeꞌupe, akegapuka, ke akeaupugua kai kina oiso aisama agemaunimue pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ega aisama Sebedi gauga, James Ioane auniꞌi Iesu eega kemai kepainia keinaka, “Pamalele aumu, lai kapaꞌina anina aani auga agagoinio fokapa aoma,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ke Iesu isa epaꞌani peniꞌi einaka, “Kapaꞌina anina oani faumiai makapa ooma?” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ke isa keinaka, “Oi kin alomia isapu akaikiꞌa aloafia aisama, fologoainimai, agaꞌo kaimuai faagu, ke agaꞌo lafanimuai faagu,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kai Iesu einaka, “Oi kapaꞌina ogoiniau auga oko alologo kai ogoiniau. Lau kiekie kaputina alainu auga agoinu ma? Ke baptismo laafia auga iꞌopoga mo agoafia ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ke isa keinaka, “Ega koa agakapa agekaina,” keoma. Ke Iesu isa epainiꞌi pugu einaka, “Koꞌa, lau kiekie kaputina alainu auga agoinu, ke baptismo laafia auga agoafia. ");
INSERT INTO mek_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kai kaiuai o lafaniuai ma foagu auga lau afalakapa. Kai Deo ifo mo kaisau fauꞌiai ekapaisa ekae ke aniꞌi eani auꞌi mo egaꞌina afuga agepeniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Iesu ega apostolo auꞌi ouꞌaga auꞌi iꞌina iifaga aꞌo kelogonia aisama, James Ioane auniꞌi eeꞌiai guaꞌi ekupu. ");
INSERT INTO mek_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kai Iesu isa maꞌoai eifa kaiguguiꞌi kai, maaꞌiai eifa einaka, “Oi ologo, agofaꞌai Iudea papiauꞌi laaꞌi auꞌi, papiau lopia keomaꞌi auꞌi, eꞌi lopia isapugai isa keꞌimaꞌi, ke au akaikiꞌaꞌi auꞌi eꞌi isapuai mo, egaꞌina papiauꞌi kepapeaꞌi. ");
INSERT INTO mek_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kai oi epomiai iina koa faemia, kaisau akaikiꞌa gamia eoma auga oi emi pinauga auga femia. ");
INSERT INTO mek_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ke kaisau gaufai eoma auga kalaꞌafi auga femia. ");
INSERT INTO mek_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Gome Papiau Aumauni Gauga emai auga kegapalagaina eoma puo aemai kai, papiau gapalagainiꞌi eoma puo emai. Ke isa papiau fauꞌiai ifo imaauga Deo agepaꞌa penia agemae papiau maꞌo kaniaꞌi ageagamauga,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Egae kai Iesu ega imoi fou kemai Jeriko taoninai. Ke laꞌafou akaikiꞌa Iesu ega imoi fou Jeriko taonina kepuaꞌafuga alogai, maakimiꞌi auga aka Patimaeus, Timaeus gauga keagai eagu epinoi. ");
INSERT INTO mek_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ke isa Iesu Nasareta auga ega epea oma fouga elogo aisama, eagaga einaka, “Iesu, Davide okogai lomai aumu, guau moania!” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kai papiau maꞌo egaꞌina auga kefinaisa kepainia komo gaoma keoma kai, eagaga ke eagaga alogaina paisa einaka, “Davide okogai lomai aumu, guau moania,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ke Iesu eapakipo kai eifa einaka, “Amoifaga,” eoma. Ega puo maakimiꞌi auga keifaga keinaka, “Alomu gagama. Moꞌue moapa. Iesu oi eifanio,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ega aisama maakimiꞌi auga fiakoa mo afe tiapuga epiumeꞌe eꞌuegekae Iesu eega elao. ");
INSERT INTO mek_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ke Iesu isa epaꞌani penia einaka, “Kapaꞌina anina loani eemuai makapa looma?” eoma. Ke maakimiꞌi auga einaka, “Pamalele aumu, maau felo gamia laoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ke Iesu einaka, “Oi emu pakoꞌa epafeloiso efua, molao,” eoma. Ke fiakoa mo au maaga felo emia, keagai Iesu muninai epea. ");
INSERT INTO mek_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Iesu ega imoi fou kemai Olifa ikugai, Ierusaleme taonina niegai, Betfake ke Betani taoniꞌiai aisama ega imoi auniꞌi eulaiꞌi keufai kelao. ");
INSERT INTO mek_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ke epainiꞌi einaka, “Amolao egaꞌina paguaga agomiai auga alogai okoko. Ke agokoko mo aisama, donki gauga kai agaꞌo aeaguaguka auga kepaaukopa agoisa. Egaꞌina donkina fogupuka fomaiseina. ");
INSERT INTO mek_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ke aufalao agaꞌo afepaꞌani kapa puo egaꞌina okapa afeoma koa aisama, foifa Lopia anina eani ke agepamue agefiakoa eoma fooma,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ke kelao keagai paꞌafi akegai donki gauga kepaaukopa keisa, ke kegupukia. ");
INSERT INTO mek_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ega aisama egae keapa papiauꞌi isaꞌi isa kepaꞌani peniꞌi keinaka, “Kapa puo donki gauga ogupuka?” keoma. ");
INSERT INTO mek_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ke isa Iesu eifania auga iꞌopoga mo keifa, ke papiau isa kelogoainiꞌi donki kepapea kelaoaina. ");
INSERT INTO mek_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ke donki gauga kemaiseina laagai afeꞌi tiapuꞌi kepagapu pagainiꞌi, ke Iesu donki laagai eaguka. ");
INSERT INTO mek_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ke papiau maꞌo afeꞌi tiapuꞌi keagai kekauniꞌi, ke isaꞌi au agaꞌi kefaiponiꞌi keagai kelapaiꞌi. ");
INSERT INTO mek_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ke keufai kepea ke muniai kepea papiauꞌi maꞌoai maialogamaꞌi mo keagaga keinaka: “Hosana!” “Davide okogai emai auga amaau afagaina!” “Lopia akagai emai Auga Deo ega gafegafe akaikiꞌa eafia!” ");
INSERT INTO mek_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Ufuꞌa Davide ega agofaꞌa agemai pugu auga Deo ega gafegafe akaikiꞌa eafia!” “Ufai auꞌoniai keague auꞌi hosana kegaoma isa kegaau afagaina!” keoma. ");
INSERT INTO mek_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ke Iesu Ierusaleme taoninai ekoko aisama, elao Deo ega eꞌai maaga egoaisa kapa maꞌoai egae keka auꞌi eisaꞌi kai, kina eake epagapigapi efua puo ega apostolo 12 fou Betani kelao. ");
INSERT INTO mek_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Egani Betani kepuaꞌafuga aisama, Iesu inaega ekimu. ");
INSERT INTO mek_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ke maaga elao agomaai fik auga maigagauga eapa eisa, ke puaga eogeisa ma gaisa eoma. Kai elao gomegai aisama, gagauga mo eisa gome ega pua kina aekainia. ");
INSERT INTO mek_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ega aisama Iesu au epainia einaka, “Puamu kai agaꞌo afaeaniania pugu,” eoma. Ke ega imoi iꞌina iifaga eifania auga aina kelogonia. ");
INSERT INTO mek_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Egae kai kemai Ierusaleme taoninai, ke Iesu elao Deo ega eꞌai ekoko egae amu keꞌafaꞌi auꞌi, ke keꞌafaꞌafalainiꞌi auꞌi fou euokaꞌi. Ke moni keau pagainia auꞌi eꞌi teipolo, ke koofi ineiꞌi keꞌafaꞌafalainiꞌi auꞌi eꞌi aguagu afuꞌi epaefo pagainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ke kai agaꞌo aelogoaina Deo ega eꞌai afaꞌafa amuꞌi aeafiꞌi aepea pagai. ");
INSERT INTO mek_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ke epamaleleniꞌi einaka, “Profeta Deo ega iifa iina kepapua oma: “‘Lau eꞌu eꞌa akeifaga megamega eꞌa akeoma.’ Kai oi pau iꞌina eꞌa, ‘painao auꞌi eꞌi feufeu afuga opamia,’” eoma. ");
INSERT INTO mek_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sakedote lopiaꞌi ke Moses ega iifa pamalelega auꞌi iꞌina iifaga aꞌo kelogonia aisama, Iesu ala fekeaupugu oma auga keagaga kekapunia. Gome isa kemaniꞌiaina. Ke isa kemaniꞌiaina, gome laꞌafou fofouga Iesu ega pamalele aꞌo kelogonia auga anina keani, ke kekauai, ke aloꞌi egama alogaina keisaꞌi. ");
INSERT INTO mek_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ke egapigapi aisama, Iesu ke ega imoi fou Ierusaleme kepuaꞌafuga kelao. ");
INSERT INTO mek_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Egani amagai keagai kepea kelao aisama, fik auga gagamugai eogogo eꞌagau elao gagaugai keisa. ");
INSERT INTO mek_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ke Peto Iesu kapaꞌina eifa auga eopolaga puo Iesu epainia einaka, “Pamalele aumu! Fik loifa apala penia auga eogogo moisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ega aisama Iesu isa maꞌoai epainiꞌi einaka, “Deo amopakoꞌania. ");
INSERT INTO mek_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Gome iifa gome maamiai laifania, aufalao agaꞌo iꞌina ikuga agepaina, ‘Molao ifomu aꞌuai moꞌafolaiso,’ ageoma, ke opo gua afaepamia kai, alo koꞌa ipaumagai agepakoꞌania koa aisama, kapaꞌina eifania auga agegama. ");
INSERT INTO mek_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ega puo lapainimi, kapaꞌina megamegai agogoina aisama, fopakoꞌania oafia efua fooma ega koa apumi agemia. ");
INSERT INTO mek_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ke agoapa agomegamega aisama, aufalao agaꞌo eemiai apala ekapaisa koa aisama, ega apala foꞌagegeaina, ega koa Amami ufai eague auga emi apala ageꞌagegeainiꞌi. ");
INSERT INTO mek_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kai oi papiau eꞌi apala afoloꞌagegeainiꞌi koa aisama, Amami ufai eague auga isafa oi emi apala afaeꞌagegeainiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Iesu ega imoi fou Ierusaleme taoninai kekoko pugu, ke elao Deo ega eꞌa alogai epea alogai, sakedote lopiaꞌi, Moses ega iifa pamalelega auꞌi, ke Iudea auꞌi akaikiꞌaꞌi auꞌi isa eega kemai. ");
INSERT INTO mek_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ke kemai eegai aisama, kepaꞌani penia keinaka, “Isapu kapagai iꞌina kapaꞌi lokapaꞌi? Ke kaisau iꞌina isapuga epeniio iꞌina kapaꞌi lokapaꞌi?” keoma. ");
INSERT INTO mek_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ke Iesu einaka, “Lau isafa paꞌani agaꞌomo oi alapenimi, ke afa fooge. Egae kai lau isapu kapagai iꞌina kapaꞌi lakapaꞌi auga maamiai alaifania. ");
INSERT INTO mek_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ioane Baptista ega baptismo ufai emai, o papiau aumauni eeꞌiai emai? Maauai amoifania!” eoma. ");
INSERT INTO mek_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ke isa ifoꞌi mo epoꞌiai iꞌina paꞌanina fouga keifania keinaka, “Agaifa ufai emai agaoma koa aisama, agepaꞌani peniꞌa ageinaka, ‘Kapa puo alapakoꞌania ageoma?’” keoma. ");
INSERT INTO mek_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ke kegaifa ‘papiau aumauni eeꞌiai emai’ kegaoma keoma kai, papiau kemaniꞌiainiꞌi, ega akeifa oma. Gome papiau maꞌo kepakoꞌania Ioane auga Deo ega profeta ipauma keoma. ");
INSERT INTO mek_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ega puo isa keinaka, “Lai alalogo,” keoma. Ke Iesu einaka, “Ega koa aisama, lau isafa isapu kapagai iꞌina kapaꞌi lakapaꞌi auga maamiai afalaifania,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Egae kai Iesu palapole agaꞌo isa maaꞌiai eifania einaka, “Au agaꞌo fino uma ekapaisa, pou fagapuga epapea lofe, fino ipaikuga afuga eapiia, ke imaꞌima taoaga agaꞌo epaapa. Ke kapa maꞌoai epafuaꞌi aisama, uma alogai kepinauga auꞌi epaꞌimaꞌi kepapinaugania. Kai isa ifo auga afu agoma elao. ");
INSERT INTO mek_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ke fino puaga iꞌafe kina ekainia aisama, fino inagome auga ega pinauga auga agaꞌo eulaisa fino uma keꞌima auꞌi eeꞌi elao, ega koa ega uma alogai fino puaga feafia eoma. ");
INSERT INTO mek_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kai fino uma keꞌima auꞌi pinauga auga keafiia keauniia ima maini keumue elao. ");
INSERT INTO mek_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ke fino uma inagome pinauga auga iꞌoina agaꞌo eulaisa eeꞌi elao pugu kai, pinauga auga egaꞌina isafa kania keau kanina kepameagaina. ");
INSERT INTO mek_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ke iꞌoina agaꞌo eulaisa pugu kai, iꞌina auga isafa keaupugua. Ke pinauga auꞌi iꞌoiꞌi maꞌo eulaiꞌi kai, isa isafa isaꞌi keauniiꞌi ke isaꞌi keaupuguꞌi. ");
INSERT INTO mek_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ke pau agaꞌomo eagu auga isa ifo gauga anina eani alogaina auga. Ke fua ipaumagai isa ifo gauga egaꞌina eulaisa aisama, ifo alogai eifa einaka, ‘Lau gau akepalopiania,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Kai pinauga auꞌi ifoꞌi epoꞌiai keinaka, ‘Iꞌina auga ago inagome auga gauga puo ago inagome agemae aisama, iꞌina ago isa apuga agemia. Ega puo amaaupugua, ega koa ago iꞌina muni isa apuga femia koa auga iꞌa apuꞌa agemia,’ keoma. ");
INSERT INTO mek_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ega puo keafiia keaupugua, ke fino uma afegai kepiulaisa. ");
INSERT INTO mek_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ke pau fino inagome auga kapaꞌina agekapa? Isa agemai pinauga auꞌi ageaupuguꞌi kai, fino uma pinauga auꞌi iꞌoiꞌi agepeniꞌi. ");
INSERT INTO mek_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Oi Deo ega iifa pukagai iꞌina iifaga ekae auga alokuakuapina ma? “‘Eꞌa ipaapa auꞌi kepo keumakalaina auga, kiuga uuꞌuga kapula ipauma emia. ");
INSERT INTO mek_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Egaꞌina kapa auga kai agaꞌo aekapaisa kai, Lopia ifo ekapaisa, ke iꞌa maaꞌaisai egaꞌina kapa felo ipauma,’” eoma. ");
INSERT INTO mek_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Iudea papiauꞌi keꞌimaꞌi auꞌi Iesu ega eifa oma aina kelogonia aisama, kelogo palapole egaꞌina auga isa fouꞌi eifania puo, guaꞌi ekupu, keaga kekapunia Iesu kegaafia kegagope keoma. Kai laꞌafou papiauꞌi kemaniꞌiainiꞌi puo, Iesu kepuaꞌafuga kelao. ");
INSERT INTO mek_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ke egaꞌina papiauꞌi Faliseo auꞌi ke Herod ega au isaꞌi fou keulaiꞌi kelao Iesu ifo ega niniꞌaniai fekepaoa keoma. ");
INSERT INTO mek_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ke isa Iesu eega kemai aisama kepainia keinaka, “Pamalele aumu, lai alogo oi iifa koꞌa mo loifania. Oi kai agaꞌo gefa aloauga, gome oi papiau eꞌi akaikiꞌa kainai alokai kai, Deo ega iifa okogai mo, ke koꞌa mo papiau lopamaleleniꞌi. Ega puo lai Sisa tax fapenia auga felo o apala? ");
INSERT INTO mek_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Lai faoge o falaoge?” keoma. Kai Iesu isa eꞌi pifoge ke eꞌi opola elogo felo puo einaka, “Kapa puo lau oꞌopoisau? Silifa monina agaꞌo amopeniau maisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ke silifa monina kemaiseina aisama, epaꞌani peniꞌi einaka, “Iꞌina kaisau lalauga ke aka,” eoma. Ke isa keinaka, “Sisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ega aisama Iesu einaka, “Ega koa aisama, kapaꞌina Sisa apuga auga, Sisa fopenia, ke kapaꞌina Deo apuga auga Deo fopenia,” eoma. Ke iꞌina iifaga aꞌo kelogonia auꞌi kekauai alogaina. ");
INSERT INTO mek_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Egae kai Saduseo auꞌi papiau maeai afakemaunimue keoma auꞌi, Iesu eega kemai kepaꞌani penia keinaka: ");
INSERT INTO mek_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Pamalele aumu, Moses Deo ega iifa lai faumaisai epapua epainimai, au agaꞌo akafa imoi agaꞌo afaepamauga kai agemae koa aisama, isa aaga o akina iꞌina afuafuga feakafania, ega koa emae auga gauga agaꞌo femauni eoma. ");
INSERT INTO mek_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ke pau oꞌoae aaꞌi akiꞌi auꞌi imagea kuagai gua keagu. Faꞌaniauga eamage kai imoi laaꞌi emae. ");
INSERT INTO mek_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Muninai akina, afuafu eakafania kai, isa isafa imoi laaꞌi emae. Ke muninai akina agaꞌo isafa iꞌopoga mo faagagai emia. ");
INSERT INTO mek_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ega koa iꞌopoga auꞌi imagea kuagai gua maꞌoai afuafu egaꞌina keakafania kai imoi laaꞌi kemae. Ke muniai afuafu egaꞌina isafa emae. ");
INSERT INTO mek_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ega puo maeai akemaunimue pugu aisama, kaisau inaꞌina papiega akafa agemia? Gome isa maꞌoai mo egaꞌina papiega keakafania,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ke Iesu einaka, “Oi Deo ega iifa ke ega isapu alologo felo puo oapagea efua. ");
INSERT INTO mek_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Gome isa maeai akemaunimue aisama, afakeamage ke afakepaamageniꞌi kai, isa ufa ageloꞌi koa iꞌopoꞌi akemia. ");
INSERT INTO mek_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ke pau maeai maunimue fouga alaifania. Ufainagai Moses auai lo eufa kai aeaga auga alogai, Deo ega iifa epapua auga alokuapina ma? Abraham Aisak ke Iakobo kemae mo ganinagai, Deo Moses iina epaini oma; ‘Lau Abraham ega Deo, ke Aisak ega Deo, ke Iakobo ega Deo,’ eoma. ");
INSERT INTO mek_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ega puo Deo auga lalauꞌiai kemae auꞌi eꞌi Deo laaꞌi kai, lalauꞌiai afakemae auꞌi eꞌi Deo. Ega puo iꞌa alogo imaauꞌa emae mo ganinagai lalauꞌa auga ageagu pagainia. Kai oi iꞌina iifaga alologo puo oapagea alogaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Iesu egaꞌina papiauꞌi fou keakeakekua kai, Moses ega iifa pamalelega auga agaꞌo emai keakekua ainaꞌi elogonia. Ke Iesu Saduseo auꞌi eꞌi paꞌani afa felo epeniiꞌi eisa puo Iesu epaꞌani penia einaka, “Deo ega iifa maꞌoai epoꞌiai iifa kapa auga akaikiꞌa ipauma?” eoma. ");
INSERT INTO mek_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ke Iesu einaka, “Israel papiaumi, ainami amopaaua! Iifa eufai auga, Lopia, aꞌa Deo auga ifogamo mo Lopia. ");
INSERT INTO mek_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ke alomi fofougai, lalaumi fofougai, opomi fofougai, ke imaaumi fofougai, emi Lopia Deo anina foani. ");
INSERT INTO mek_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ke iifa akaikiꞌa gua auga, oi ifomu animu loani koa iꞌopoga emu eꞌa ipafe auga anina ega foani oma. Iifa iꞌoina agaꞌo akaikiꞌa ipauma iina koa laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ke Moses ega iifa pamalelega auga Iesu epainia einaka, “Pamalele aumu oi iifa koꞌa loifania. Gome Deo agaꞌomo, ke kai agaꞌo laaꞌi isa ifogamo mo Deo. ");
INSERT INTO mek_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ke alomu fofougai, opomu fofougai, imaaumu fofougai Lopia anina foani, ke ifomu animu loani koa iꞌopoga papiau isafa aniꞌi ega foani oma auga iifa akaikiꞌa ipauma. Inaꞌina iifaꞌi auniꞌi auꞌi, kapaꞌina aumaꞌi Deo apaꞌa penia auꞌi, ke amu Deo apaꞌa penia auꞌi maꞌoai ekaꞌegai afeꞌainiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ke Iesu, au ega niniꞌani ikifaga aꞌo elogonia aisama, epainia einaka, “Oi Deo ega agofaꞌa eegai loapae,” eoma. Egaꞌina afegai kai agaꞌo Iesu paꞌani agaꞌo aepenia pugu. ");
INSERT INTO mek_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesu Deo ega eꞌai epapamalele lalao kai, papiau epaꞌani peniꞌi einaka, “Ala koa Moses ega iifa pamalelega auꞌi Kristo auga Davide okogai agemai keoma? ");
INSERT INTO mek_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Gome Davide ifo Deo ega Spirituai iꞌina iifaga eifania einaka: “‘Lopia lau eꞌu Lopia epainia einaka: “Kaiuai moagu felaolao Lau oi emu ou auꞌi ifemu guagai alaogeꞌi alogafapiꞌi,” ’ eoma. ");
INSERT INTO mek_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davide ifo isa eifaga Lopia eomaisa puo, pau ala koa Lopia auga Davide okogai agemai aoma? Isa Davide gauga mo laaꞌi kai, ega Lopia isafa,” eoma. Laꞌafouai papiau aageꞌi Iesu ega eniniꞌani oma aina kelogonia aisama, aloꞌi egama alogaina. ");
INSERT INTO mek_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesu ega pamaleleai eifa einaka, “Maami fogoa, pamalele auꞌi foisa feloꞌi. Isa tiapu feloꞌi mo fekeiꞌiukaꞌi fekepea aisoge, ke afaꞌafa afuꞌiai papiau isa fekepamegoniꞌi auga anina keani alogaina. ");
INSERT INTO mek_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ke isa laꞌafou afugai ke miamia alogai au akaikiꞌaꞌi mo afuꞌiai fekeagu auga anina keani alogaina. ");
INSERT INTO mek_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ke isa afuafu kefogeꞌi eꞌi kapa maꞌoai keafiꞌi ke papiau kegaisaꞌi keoma, megamega maefaꞌi keifaniꞌi. Iꞌina papiauꞌi afa apala ipauma akeafia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Egae kai Iesu moni keogeoge afuga apie kaina eagu kai papiau maꞌo kemai Deo ega eꞌai moni keogeoge afugai moni keogeisa auga eisaꞌi. Egaꞌina alogai paꞌamuꞌamu papiauꞌi maꞌo kemai moni akaikiꞌa keogeisa eisaꞌi. ");
INSERT INTO mek_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kai afuafu agaꞌo emai kopa moniꞌi auniꞌi mo eegai keka auga eogeiꞌi. Ke egaꞌina moniꞌi auga 10 toea koa iꞌopoga. ");
INSERT INTO mek_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ega aisama Iesu ega imoi eifaniꞌi eega kemai kai epainiꞌi einaka, “Iifa gome maamiai laifania. Ulalu afuafuga kapaꞌina eogeisa auga akaikiꞌa ipauma, papiau maꞌoai eꞌi pipeni ekaꞌegaina. ");
INSERT INTO mek_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Gome papiau maꞌoai kapa maꞌo eeꞌiai kekae auꞌi epoꞌiai pika koa mo keafiiꞌi kemai keogeiꞌi kai, ulalu afuafuga iꞌina oꞌamega egaꞌina mo fepalagaina auga eafiia emai eoge afeꞌaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesu ega imoi fou Deo ega eꞌa kepuaꞌafuga alogai, ega imoi agaꞌo eifa einaka, “Pamalele aumu, kepo feloꞌi ipaumaꞌi, ke Deo ega eꞌa felo ipauma kepaapa moisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kai Iesu einaka, “Iꞌina eꞌa felo ipauma loisa? Iꞌina kepo agaꞌomo ganinagai kepo agaꞌo laagai ekaauau afoloisa, maꞌoai akeaꞌopu afeꞌai,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Egaꞌina afegai Iesu elao Deo ega eꞌa epaai pagainia afugai Olifa ikugai eaguega kai Peto, James, Ioane ke Andru fou isa eega kemai ogefakeai kepaꞌani penia keinaka: ");
INSERT INTO mek_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Gaika iꞌina kapaꞌi akemia, ke gou kapaꞌi akemia aisama iꞌina kapaꞌi maꞌoai akekoꞌa auga maamaisai moifania?” keoma. ");
INSERT INTO mek_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ke Iesu einaka, “Foisa felo kai agaꞌo faefogeimi. ");
INSERT INTO mek_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Gome papiau maꞌo lau akauai akemai akeifa, ‘Lau Kristo’ akeoma ke papiau maꞌo akefogeꞌi akepapea meꞌeꞌi. ");
INSERT INTO mek_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ke ifani koꞌaꞌi akemia ke ifani fouꞌi mo agologo aisama, folomaniꞌi. Gome egaꞌina kapaꞌi auꞌi fekemia paisa puo akemia. Kai agofaꞌa iꞌina fua auga afaemai kaukau. ");
INSERT INTO mek_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Gome ago agaꞌo ago agaꞌo fou akeifani, ke agofaꞌa agaꞌo agofaꞌa agaꞌo fou akeifaniꞌi. Ke afu iꞌoiꞌi iꞌoiꞌiai kafokau agepea ke magea akaikiꞌa, ke kekele akaikiꞌa agemia. Egaꞌina kina auga papie agaꞌo einae ega mauni kina kiekieꞌi eꞌina mo koa iꞌopoga agemia. ");
INSERT INTO mek_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kai oi maami fogoa felo. Gome lau fauai oi kansolo auꞌi imaꞌiai akepaaumi, ke laꞌafou afuꞌiai oi akeaunimi, ke agofaꞌa lopiaꞌi akaikiꞌaꞌi ke kin agoꞌiai agoapa, lau fou agoifafoua. ");
INSERT INTO mek_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ke iifa faunina lau fou agofaꞌa fofouga alogai foinogoai kakaua. ");
INSERT INTO mek_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kai oi akeafimi iifa ipakainai agoapa aisama, kapaꞌina agoifania auga foloopola kakaua, ke opopo isafa folopaꞌau kakaua. Kai egaꞌina kina maagai Deo ega Spiritu kapaꞌina agepenimi auga foifania. Gome egaꞌina kinagai oi ifomi afoloniniꞌani kai, Deo ega Spiritu ageniniꞌani. ");
INSERT INTO mek_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ke egaꞌina kinagai aaga ifo akina ageꞌafaꞌafalaina akeaupugua, ke akina isafa aaga faagagai iꞌopoga mo agekapa. Ama gauga ageꞌafaꞌafalaina akeaupugua. Ke imoi akeꞌue inaꞌi amaꞌi fou akeakekua, ke inaꞌi amaꞌi papiau imaꞌiai akepaauꞌi akeaupuguꞌi. ");
INSERT INTO mek_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ke lau akau puogai papiau maꞌoai aloꞌi koꞌagai oi animi afakeani. Kai kaisau afaeapoke ageapa kapula agelao fuagai auga, kania ageisagamau.” ");
INSERT INTO mek_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Iesu eifa pugu einaka, “Kapa agaꞌo profeta Daniel fouga eifania auga kapa, iisa maniꞌina ipauma, Deo eifa ainaꞌau penia auga, afu agaꞌogai faeapa auga afugai ageapa agoisa aisama, Iudea agogai keagu auꞌi fekepiau iku fekelao. (Kaisau iꞌina fouga ekuapina auga iꞌina kapaꞌina eifania auga oko felogo.) ");
INSERT INTO mek_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ke kaisau eꞌa ofaofagai eagu auga, faeake eꞌa alogai faekoko kapa agaꞌo faeafia. ");
INSERT INTO mek_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ke kaisau agoai eapae auga faemue faelao eꞌai afe tiapuga faeafia. ");
INSERT INTO mek_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kai egaꞌina kinaꞌiai papie inaeꞌiai, ke imoi kepaꞌuꞌi auꞌi eꞌi kina apala ipauma agemia. ");
INSERT INTO mek_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ke fomegamega ega koa iꞌina kapaꞌi inipo aupu kinagai fakemia. ");
INSERT INTO mek_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Gome egaꞌina kinaꞌi kiekie auga apala ipauma agofaꞌa egama mo alogai kina kiekie ega koa iꞌopoga agaꞌo aemia mo emai pau. Ke muni kiekie agaꞌo ega koa iꞌopoga afaemia pugu. ");
INSERT INTO mek_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Egaꞌina kinaꞌiai kiekie akaikiꞌa ipauma agemia puo, Lopia egaꞌina kinaꞌi ofolaꞌoꞌi faepamiaꞌi koa aisama, kai agaꞌo kania faemauni. Kai ekinaniꞌi auꞌi fauꞌiai kina egaꞌina epafoꞌoaniꞌi. ");
INSERT INTO mek_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ke egaꞌina kinaꞌiai aufalao agaꞌo afeifa, ‘Amoisa Kristo inamoꞌe,’ afeoma, o ‘Isa egamoꞌe’ afeoma koa aisama, folopakoꞌania. ");
INSERT INTO mek_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Gome Kristo fogefogeꞌi, ke profeta fogefogeꞌi akemai, Deo ega pinauga gouga koa akekapaꞌi, ke mirakulo akekapaꞌi Deo ekinaniꞌi auꞌi kegafogeꞌi akeoma. Ke afekainiꞌi koa aisama, Deo ekinaniꞌi auꞌi mo ganinagai akefogeꞌi. ");
INSERT INTO mek_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Amoisa! Kapa maꞌoai akemia koa kai maamiai laifaniꞌi ega koa maami fogoa.” ");
INSERT INTO mek_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ke Iesu eifa pugu einaka, “Egaꞌina kiekieꞌi muniꞌiai mo, “‘kina agepaꞌumina, gafa afaepoa eaea afaepipeni. ");
INSERT INTO mek_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Miꞌimiꞌi ufai akeaꞌopu, ke ufa kapaꞌi maꞌoai akepigugu.’ ");
INSERT INTO mek_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Egae kai Papiau Aumauni Gauga isapu akaikiꞌa ipauma ageafia, ke Deo ega eaea akaikiꞌa ipaumagai apuapuai agemai akeisa. ");
INSERT INTO mek_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ke ega agelo ageulaiꞌi akelao agofaꞌa fuagai, ke akelao ufa fuagai ameku pani kepua kemai afuꞌiai ekinaniꞌi auꞌi maꞌoai akepakai guguainiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Iesu eifa pugu einaka, “Ke pau au aka fik fomaleleaina. Fik auga aga eikina gagauga eoge aisama, ologo kinafaꞌa emai kainagai ooma. ");
INSERT INTO mek_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ega puo ega koa iꞌopoga mo, egaꞌina kapaꞌi akemia agoisaꞌi aisama, Papiau Aumauni Gauga ega mai kina emai kainagai ipauma, emi paꞌafi akegai auga agologo. ");
INSERT INTO mek_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Iifa gome maamiai laifania. Pau papiauꞌi afakemae iꞌina kapaꞌi akegama akeisaꞌi kai akemae. ");
INSERT INTO mek_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ufa aagoa fou akefua laaꞌi akemia kai lau eꞌu iifa afaefua laaꞌi afaemia. ");
INSERT INTO mek_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Kai egaꞌina kina ke kina maaga kapa auga, kai agaꞌo aelogo. Agelo ufai akelogo ke Deo ifo Gauga mo ganinagai aelogo kai, Deo Ama ifogamo elogo. ");
INSERT INTO mek_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Maami fogoa ke fomegamega, gome egaꞌina kina gaika agemai auga alologo. ");
INSERT INTO mek_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Egaꞌina kina auga, au agaꞌo agoma elao aisama, ega pinauga auꞌi aua eꞌi pinauga epeniꞌi, eꞌa epaꞌimaꞌi, ke paꞌafi akegai eapa auga epaina feꞌimaꞌima eoma koa iꞌopoga. ");
INSERT INTO mek_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ega puo oi maami fogoa foꞌimaꞌima. Gome oi eꞌa inagome gaika agemai auga alologo. Isa gapigapi ma, fafuai ma, oꞌolo ageagaga kai ma, o amagai ma agemai auga alologo. ");
INSERT INTO mek_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ke afoloꞌimaimi koa aisama, isa fiakoa mo agemai, ke oi ofeu ageisami. ");
INSERT INTO mek_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kapaꞌina maamiai laifania auga papiau maꞌoai isafa maaꞌiai laifania. Maami fogoa.” ");
INSERT INTO mek_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Palafa iuma mulamula laaꞌi kai palafa maini mo keania miamia aka Pasover kina emai kainagai, kina gua mo ekaega kai sakedote lopiaꞌi, ke Moses ega iifa pamalelega auꞌi fou pifogeai Iesu ala fekeafi oma, ke fekeaupugua auga keagaga kekapunia. ");
INSERT INTO mek_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kai isa keinaka, “Miamia kinagai egaꞌina falakapa, o agakapa koa aisama, papiau aꞌoaꞌo akaikiꞌa afekapa,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ke Iesu Betaniai molumolu auga epafelo auga, aka Saimon ega eꞌai fou keaniani alogai, papie agaꞌo aupu gagauga aka nad maifoga auga gagamuga keafia oili kekapa auga, oga eꞌelegai eafiia emaiseina eaupea kai Iesu kania eꞌefaisa. ");
INSERT INTO mek_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kai papiau isaꞌi egae keagu auꞌi guaꞌi ekupu alogaina puo, ifoꞌi epoꞌiai keifa keinaka, “Iꞌina oilina afa akaikiꞌa kai, kapa puo epapinauga aagenia mo. ");
INSERT INTO mek_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Gome amaꞌafaꞌafalaina koa aisama, inipo agaꞌo pinauga afa femia, ke monina ulalu auꞌi fapeniꞌi,” keoma. Ke papie keloꞌu peni kapulania. ");
INSERT INTO mek_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ega aisama Iesu eifa einaka, “Papie opuaꞌafuga, kapa puo opaakekua? Isa kapa felo ipauma eeuai ekapaisa. ");
INSERT INTO mek_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gome ulalu auꞌi auga aufa kina mo eemiai akeagu, ke kina kapagai amopalagainiꞌi agooma agekaina kai, lau auga oi fou afalaagu mo afaelaolao. ");
INSERT INTO mek_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Papie iꞌina kapaꞌina fekapa auga mo ekapaisa. Isa lau kaniauai oili eꞌefaisa auga lau imaau akefufuga pinauga auga ekapa umania mo. ");
INSERT INTO mek_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Iifa koꞌa maamiai laifania, iifa faunina agofaꞌai akeifafoua aisama, iꞌina papiega kapaꞌina ekapaisa auga akeopolaga akeifafoua,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Egaꞌina afegai Iesu ega apostolo 12 auꞌi epoꞌiai agaꞌo aka, Judas Iskariot keoma auga, Iesu gaꞌafaꞌafalaina sakedote lopiaꞌi imaꞌiai gapaaua eoma puo eeꞌi elao. ");
INSERT INTO mek_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ke isa egaꞌina fouga kelogo aisama, aloꞌi egama alogaina, ke maagai keifa koꞌania moni akepenia keoma. Ke Judas Iesu isa imaꞌiai ala fepaau oma auga kina felo agaꞌo eꞌimaisa. ");
INSERT INTO mek_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Palafa maini iuma keania miamia aka Pasover kina eufai auga alogai, kagakaga kainai, sipi aguꞌa agaꞌo Deo kepaꞌa penia. Egaꞌina kinagai Iesu ega apostolo isa kepaꞌani penia keinaka, “Falao, kapai inaꞌina miamia foꞌamaga fakapa foania looma?” keoma. ");
INSERT INTO mek_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ega puo Iesu ega apostolo auniꞌi eulaiꞌi kai, epainiꞌi einaka, “Folao taoniai au agaꞌo oga feina eꞌupia auga agemai fou agopiaogai. Ega aisama oi isa muninai folao. ");
INSERT INTO mek_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ke agolao eꞌa kapa alogai agekoko aisama, eꞌa inagome auga fopaina, ‘Pamelele auga epaꞌani: Lau eꞌu miamia afuga eꞌa alogai auga kapai, ke eꞌu imoi fou miamia foꞌamaga kapai agaania eoma?’ fooma. ");
INSERT INTO mek_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ke isa ifo eꞌa auꞌoniai afu akaikiꞌa agaꞌo kekapa umania mo auga agepakinaimi, egae iꞌa aꞌa miamia foꞌamaga fokapa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ke Iesu ega apostolo egaꞌina auniꞌi kelao taoniai aisama, eifania auga iꞌopoga mo keisa. Ke egae miamia foꞌamaga kepafua eka. ");
INSERT INTO mek_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Epagapigapi aisama Iesu ke ega apostolo 12 auꞌi fou kemai kelaꞌafou. ");
INSERT INTO mek_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ke aniani afugai keagukipo keaniani alogai Iesu isa epainiꞌi einaka, “Iifa gome maamiai laifania, epomiai pau fou aaniani aumi agaꞌo ageꞌafaꞌafalainiau,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ke aloꞌi emafu alogaina ke agaꞌo agaꞌo kepaꞌani penia keinaka, “Lau ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ke Iesu einaka, “Egaꞌina auga, aumi 12 aumi epomiai agaꞌo, lau fou palafa litiai agaꞌiupa auga lau ageꞌafaꞌafalainiau. ");
INSERT INTO mek_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Papiau Aumauni Gauga agelao auga Deo ega iifa pukagai kepapua koa iꞌopoga mo agemia kai, kaisau Papiau Aumauni Gauga eꞌafaꞌafalaina auga afa apala ipauma ageafia. Au egaꞌina faemauni koa fefelo alogaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ke keaniani laolao kai Iesu palafa eafiia, Deo tenkiu epeniia kai efaipoga ega imoi epeniiꞌi einaka, “Amoafia amoania. Inaꞌina lau imaau,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ke fino kaputina eafiia, Deo tenkiu epeniia efua aisama, ega imoi epeniiꞌi maꞌoai keinu. ");
INSERT INTO mek_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ke Iesu einaka, “Inaꞌina auga lau ifau, papiau maꞌo fauꞌiai agefaka auga. Egaꞌina ifa auga Deo papiau fou epomiai pakoꞌa kapula gouga mamaga alakapa. ");
INSERT INTO mek_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Iifa gome maamiai laifania. Fino iꞌina au puagai emai auga, afalainu pugu agelaolao, muni Deo ega logoai kapa maꞌoai akefua afegai, Deo ega agofaꞌai kai, fino mamaga alainu pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ke Deo isau afagaina iifina keifinia efua aisama, kepealai Olifa ikuga kelao. ");
INSERT INTO mek_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesu ega imoi fou keagai kepeapea kai, epainiꞌi einaka, “Pau gapiai oi maꞌoai lau agopiauaniau. Gome Deo ega iifa pukagai iina kepapua oma: “‘Lau sipi iꞌima auga alaauga, ke sipi maꞌoai akekani.’ ");
INSERT INTO mek_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kai lau alamaunimue afegai aisama, alaufai agomiai Kalilea alalao,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kai Peto isa epainia einaka, “Maꞌoai fekepuniaiainio mo ganinagai lau oi afalapuniaiainio mo laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ke Iesu einaka, “Iifa gome maamuai laifania, pau gapiai oꞌolo agagaga gua aemia koa kai lau alopuniaiainiau oiso alopamia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kai Peto aeapakipo eifa faꞌiꞌi einaka, “Oi auniꞌa fou famae mo ganinagai, oi afalapuniaiainio,” eoma. Ke maꞌoai isafa ega mo keifa oma. ");
INSERT INTO mek_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Egaꞌina afegai Iesu ega apostolo fou kelao afu aka Ketsemani aisama, ega apostolo epainiꞌi einaka, “Inae mo foagu kai lau famegamega,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Egae kai Peto James ke Ioane eafiiꞌi fou kelao koa kai, eꞌina eopopo ekiekie, ke alo emafu alogaina. ");
INSERT INTO mek_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ke epainiꞌi einaka, “Lau eꞌu alomafu kiekie auga akaikiꞌa ipauma puo, famae koa ganinagai agekaina. Ega puo oi inae foagu foꞌimaꞌima,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Egae kai afaꞌagamo epea kua elao aakai koa iꞌopoga kai, eꞌualai aꞌisaai eomukipo emegamega, ke afekaina koa egaꞌina kiekieꞌi fekepagai eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ke ega megamegai eifa einaka, “Abba, Amau! Oi kapa maꞌoai alokapaꞌi agekaina. Ega puo iꞌina kiekie kaputina eeuai moafiꞌaua. Kai lau anina laani auga faeikapa kai, oi anina loani auga gaikapa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ke ega emegamega oma efua aisama, emue elao ke ega apostolo auꞌi oiso kefeu eisaꞌi. Ega puo Peto epainia einaka, “Saimon, lofeu ma? Kina maaga agaꞌomo afoloꞌimaꞌima ma? ");
INSERT INTO mek_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Foꞌimaꞌima ke fomegamega ega koa Satani ageꞌopoimi aisama afoloꞌualai. Oi lalaumi anina eani kai imaaumi auga eapoke,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ke emue elao pugu, ke megamega iꞌopoga mo eifania pugu. ");
INSERT INTO mek_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ke emue ega apostolo eeꞌi emai aisama, kefeu pugu eisaꞌi, gome maaꞌi emeau. Ke ega apostolo feuai kekauai Iesu keisa aisama, kapaꞌina isa maagai fekeifania auga akelogo. ");
INSERT INTO mek_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ke mue oiso epamia aisama epainiꞌi einaka, “Ofeu, olaagai alofua koa ma? Moꞌo! Kina maaga ekainia. Amoisa, Papiau Aumauni Gauga papiau apalaꞌi imaꞌiai akepaaua akeꞌafaꞌafalaina. ");
INSERT INTO mek_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Oꞌue, fou amalao! Lau eꞌafaꞌafalainiau auga emai!” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesu egaꞌina eifaifania kai, ega apostolo 12 epoꞌiai agaꞌo aka Judas auga fiakoa mo Iesu eega emai. Ke isa fou laꞌafouai kemai auꞌi ifani aꞌifaꞌi ke kopi fou keafiiꞌi kemai. Egaꞌina papiauꞌi auga sakedote lopiaꞌi, Moses ega iifa pamalelega auꞌi, ke Iudea au akaikiꞌaꞌi auꞌi keulaiꞌi kemai. ");
INSERT INTO mek_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ke au Iesu eꞌafaꞌafalaina auga gou agaꞌo agekapa Iesu akeafia auga fouga egaꞌina papiauꞌi maaꞌiai eifania einaka, “Au alagoapa auga Iesu, ke foafia iꞌima fopagome folaoaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ke Judas emai aisama, fiakoa mo Iesu eega elao einaka, “Pamalele aumu,” eoma, ke egoapia. ");
INSERT INTO mek_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ega aisama egaꞌina auꞌi kelao Iesu keafiia. ");
INSERT INTO mek_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ke au agaꞌo Iesu fou keaguagu auga ifani aꞌifaga efuaua, sakedote lopia faꞌa ega kalaꞌafi agaꞌo aina efoua. ");
INSERT INTO mek_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kai Iesu egaꞌina papiauꞌi epainiꞌi einaka, “Lau painao auꞌi koa iꞌopoꞌi oi eemiai kelele akaikiꞌa agaꞌo lakapaisa ma puo, ifani aꞌifaꞌi kopi fou oafiiꞌi omai amoafiau ooma? ");
INSERT INTO mek_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kina maꞌoai Deo ega eꞌai fou aagu lapamalele kai aloafiau. Kai Deo ega iifa pukagai kapaꞌina keifania auga koꞌa femia kainai pau oi oafiau,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ke Iesu ega apostolo maꞌoai papiau egaꞌina Iesu keafiia keisa aisama, kepuaꞌafuga kepiau afeꞌai. ");
INSERT INTO mek_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kai au aguꞌa agaꞌo tiapu agaꞌo aeꞌiuka kai tiapu manipina mo eapunia Iesu muninai epea. Ke au egaꞌina auꞌi au aguꞌa egaꞌina keafiia. ");
INSERT INTO mek_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ega aisama ega tiapu epuaꞌafuga faaga maini epiau. ");
INSERT INTO mek_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Iesu keafiia auꞌi kelaoaina sakedote lopia faꞌa eegai. Ke egae isa afugai, sakedote lopiaꞌi, Moses ega iifa pamalelega auꞌi, ke Iudea au akaikiꞌaꞌi maꞌoai kemai fou kekaigugu keagu. ");
INSERT INTO mek_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Egaꞌina alogai Peto Iesu fou epoꞌi aakai kai, muninai epea elao sakedote lopia faꞌa ega iifa ipakaina afugai ekoko. Ke egae imaꞌima auꞌi fou lo eegai keagu lo egagaisa. ");
INSERT INTO mek_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ke sakedote lopiaꞌi ke iifa ipakaina auꞌi akaikiꞌaꞌi maꞌoai Iesu fekeaupugua auga iifaga koꞌa kekapunia kai iifa koꞌa agaꞌo akekapulaisa. ");
INSERT INTO mek_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Gome papiau maꞌo pifoge iifaꞌi Iesu eegai keifaniꞌi kai, eꞌi iifa maꞌoai iꞌopoꞌi agaꞌomo aemia. ");
INSERT INTO mek_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Egae kai isaꞌi keꞌue Iesu eegai pifoge iifaꞌi iina keifa omaꞌi keinaka: ");
INSERT INTO mek_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Lai isa iina eifa oma aina alogonia: ‘Lau Deo ega eꞌa papiau imaꞌiai kepaapa auga alaauoka, ke kina oiso alogai iꞌoina agaꞌo papiau imaꞌiai afakepaapa auga alapaapa pugu,’” keoma. ");
INSERT INTO mek_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Isa ega keifa oma mo ganinagai, kapaꞌina keifania auga iꞌopoꞌi agaꞌomo akemia. ");
INSERT INTO mek_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Egae kai sakedote lopia faꞌa isa maꞌoai agoꞌiai eꞌue Iesu epaꞌani penia einaka, “Oi isa eꞌi iifa afa agaꞌo afolopamue ma? Iꞌina papiauꞌi iꞌina iifaꞌi kapaꞌi mo oi faagamuai keifaniꞌi?” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kai Iesu komo mo eoma, iifa afa agaꞌo aepamue. Ega aisama sakedote lopia faꞌa epaꞌani pugu einaka, “Oi Mesaia, Deo aau afagaina Auga Gauga aumu ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ke Iesu einaka, “E! Egaꞌina lau ke Papiau Aumauni Gauga Ama Au Akaikiꞌa Auga ima kaina kainai ageagu ke maiꞌisapuai ufa apuapuꞌiai agemai agoisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ega aisama sakedote lopia faꞌa ifo tiapuga eꞌiꞌinia ke einaka, “Moꞌo! Maaꞌiai keisa auꞌi fekeniniꞌani auga aniꞌi alaani. ");
INSERT INTO mek_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Isa Deo eifa apala peni aagenia mo aina ologonia efua. Kapaꞌina oopolaga?” eoma. Ke maꞌoai keifa apala penia femae auga iifaga kepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Egae kai papiau isaꞌi isa keꞌupeisa, maaga kemokaisa, ke imaꞌiai keauniia ke keinaka, “Kaisau pau eaunio auga profeta koa momia moifania,” keoma. Ke imaꞌima auꞌi isafa Iesu keafiia, meꞌe kepoaisa. ");
INSERT INTO mek_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Egaꞌina alogai Peto iifa ipakaina afuga papagai eaguega kai, sakedote lopia faꞌa ega kalaꞌafi ifiaoga agaꞌo ega mo epea oma. ");
INSERT INTO mek_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Isa Peto lo niegai eapa lo egagaisa eisa aisama, elao eegai eisa felo kai epainia einaka, “Oi isafa Iesu Nasareta auga fou oaguagu,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kai isa epuniai einaka, “Kapaꞌina loifania auga alalogo ke oko isafa alalogo,” eoma. Ke epealai kekoko kemai auga paꞌafina ake elao aisama, oꞌolo eagaga. ");
INSERT INTO mek_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ke elao egae ke kalaꞌafi ifiaoga agaꞌo Peto eisa pugu aisama egae keapa auꞌi epainiꞌi einaka, “Iꞌina auga isafa isa agaꞌoꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kai Peto epuniai pugu. Omaꞌe kai egae keapa auꞌi Peto kepainia pugu keinaka, “Iifa koꞌa oi isafa isa agaꞌoꞌi, gome oi Kalilea aumu, ke emu niniꞌani epafokio,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kai Peto eꞌina ifo eifa apala penia, ke maaꞌiai eifa koꞌania einaka, “Au iꞌina oifania auga alalogonia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Peto egaꞌina eifania aisama, fiakoa mo oꞌolo agagaga gua emia. Ke Peto Iesu maagai oꞌolo agagaga gua aemia koa kai agepuniaiaina oiso agepamia auga eopolaga, alo emafu eapepe alogaina. ");
INSERT INTO mek_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Amagai ipauma sakedote lopiaꞌi, Iudea au akaikiꞌaꞌi, Moses ega iifa pamalelega auꞌi, ke kansolo auꞌi fofouga kelaꞌafou Iesu faagagai kapaꞌina feikapa auga keifania kepakoꞌania. Egae kai Iesu kegopeisa kepapea kelaoaina Pilato imagai kepaaua. ");
INSERT INTO mek_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ke Iesu Pilato agogai kepaapa aisama Pilato Iesu epaꞌani penia einaka, “Oi Iudea auꞌi eꞌi kin ma?” Ke Iesu einaka, “E, oi loifania koa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ke sakedote lopiaꞌi Iesu eegai kapa maꞌo mo keifaniꞌi kepaagu fofoua. Kai Iesu iifa agaꞌo aeifania. ");
INSERT INTO mek_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ega puo Pilato Iesu epaꞌani penia pugu einaka, “Iifa agaꞌo afoloifania ma? Papiau eemuai kapa maꞌo keifaniꞌi kepaagu fofouso moisaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kai Iesu iifa agaꞌo aeifania paisa puo, Pilato ekauai alogaina. ");
INSERT INTO mek_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ega kinagai kagakaga kainai miamia kinagai papiau eꞌi iifai, tipula auga agaꞌo kepapapealaisa. ");
INSERT INTO mek_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ega kinaꞌiai au agaꞌo aka Barabas papiau aloꞌi eaniia kelele maꞌo kekapaiꞌi. Egaꞌina alogai papiau isaꞌi eaupuguꞌi puo, tipulai eagu. ");
INSERT INTO mek_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Papiau laꞌafouai kemai keagaga akaikiꞌa Pilato kepainia miamia kinagai kapaꞌina eeꞌiai ekapakapa auga gakapa keoma. ");
INSERT INTO mek_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kai Pilato isa epaꞌani peniꞌi einaka, “Oi anina oani Iudea papiauꞌi eꞌi kin mapapealaisa eemi gafai ma ooma?” ");
INSERT INTO mek_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Gome sakedote lopiaꞌi eꞌi pikupai Iesu keafiia isa imagai kepaaua auga elogo. ");
INSERT INTO mek_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kai sakedote lopiaꞌi laꞌafou papiauꞌi aloꞌi keaniia Pilato Iesu faepapealaisa kai, Barabas gapapealaisa keoma. ");
INSERT INTO mek_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ega aisama Pilato epaꞌani pugu einaka, “Ke pau Iudea papiauꞌi eꞌi kin ooma auga ala faoma ooma?” eoma. ");
INSERT INTO mek_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ke papiau keagaga pugu keinaka, “Kolotiai gaisauꞌuꞌui,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ega aisama Pilato epaꞌani einaka, “Kapa puo, kapaꞌina apala ekapaisa?” eoma. Kai isa keagaga alogaina paisa keinaka, “Kolotiai gaisauꞌuꞌui,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ega aisama Pilato papiau aloꞌi gapagama eoma puo, Barabas tipulai epapealaisa, ke ega au auꞌi Iesu kegapukia afegai aisama, papiau imaꞌiai epaaua keafiia kolotiai isauꞌuꞌua kelaoaina. ");
INSERT INTO mek_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Egaꞌina afegai ifani auꞌi Iesu keafiia kafana auga afuga, eꞌa akaikiꞌa alogai kekokoaina ke ifani auꞌi fofouga keifa kaiguguꞌi. ");
INSERT INTO mek_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Egae kai tiapu umuga eaea auga keafiia kepaapuga, aꞌifu keafipoꞌe kin kaniaꞌiai kraon keogeoge auga koa kepamia kaniagai keogeaua. ");
INSERT INTO mek_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ke keꞌina kepakoꞌaina keinaka, “Iudea auꞌi eꞌi kin, loagu felo ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ke inipo auga keafiia kania keauniia, ke keꞌupeisa. Ke kepakafoꞌonia agogai keanifeꞌu keau afagaina. ");
INSERT INTO mek_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ke kepaꞌaua efua aisama, tiapu umuga eaea faagagai eka auga keafilaisa, ke ifo afe tiapuga kepaiꞌiuka pugu, ke kepapealaisa kolotiai isauꞌuꞌua kelaoaina. ");
INSERT INTO mek_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ke kelao keagai aisama, Sairene auga aka Saimon, Aleksanda ke Rufus auniꞌi amaꞌi ega paguai eake emai keisa. Ke ifani auꞌi isa kepamaniꞌinia Iesu ega koloti gapua keoma. ");
INSERT INTO mek_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ke Iesu kelaoaina afu aka Kolkota. Iꞌa malaꞌaisai auga kania uniaga eifania. ");
INSERT INTO mek_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Egae kai fino, aupu gagauga foga ekapula auga fou keoge lapuinia kai Iesu kepeniia gainu keoma kai epamafua. ");
INSERT INTO mek_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ke Iesu kolotiai keauꞌuꞌua afegai aisama, afe tiapuga keꞌeaisa kai, agaꞌo agaꞌo kapa akeafia auga egeai keꞌopoisa keafiia. ");
INSERT INTO mek_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Iesu kolotiai keauꞌuꞌua kina maaga auga, amagai 9 oꞌclock. ");
INSERT INTO mek_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ke isa kapa puo kolotiai keauꞌuꞌua auga iifaga kania laagai kepapua keauꞌuꞌua: ");
INSERT INTO mek_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ke painao auꞌi gua isafa kolotiai keauꞌuꞌuiniꞌi, agaꞌo kaina kainai, agaꞌo lafanina kainai. ");
INSERT INTO mek_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ega koa emia auga, Deo ega iifa pukagai iina kepapua oma auga koꞌa mo emia: ‘Isa laomai apala ikapa auꞌi fou agaꞌomo kepamiaꞌi.’ ");
INSERT INTO mek_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ke papiau egae kepea pagai auꞌi keakae isa keisa, kaniaꞌi keꞌafoisa ke keinaka, “Ooo! Deo ega eꞌa aloauoka ke kina oiso alogai alopaapa pugu aumu. ");
INSERT INTO mek_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pau kolotiai moake ifomu kaniamu moagamauga,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ke ega koa iꞌopoga mo, sakedote lopiaꞌi ke Moses ega iifa pamalelega auꞌi fou ifoꞌi mo epoꞌiai Iesu kepaꞌaua keinaka, “Isaꞌi kaniaꞌi eagamauga kai, ifo kania ageagamauga afaekaina. ");
INSERT INTO mek_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Israel eꞌi kin, Mesaia aumu, pau kolotiai moake ega koa amaisao amapakoꞌanio,” keoma. Ke Iesu fou kolotiai keauꞌuꞌuiniꞌi auꞌi isafa isa keifa apala penia. ");
INSERT INTO mek_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kina maaga atiafai koa iꞌopoga aisama, umina emai aagoa fofouga eumi apua elao mo gapigapi kina maaga 3 oꞌclock eafiia. ");
INSERT INTO mek_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Egaꞌina kina maagai aisama, Iesu eagaga einaka, “Eloi, Eloi, lama sabaktani?” eoma. Egaꞌina auga iꞌa malaꞌaisai, “Eꞌu Deo, Eꞌu Deo, kapa puo lopuaꞌafuniau?” ");
INSERT INTO mek_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ke egae keapa auꞌi isaꞌi Iesu aina kelogonia aisama, keifa keinaka, “Amoisa, isa Elaija eifaga aina amologo,” keoma. ");
INSERT INTO mek_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ke au agaꞌo elao tiapu manipina eafiia, fino piꞌigugai eꞌiupia, isepeai egopeisa kai Iesu epeniia gainu eoma ke einaka, “Amopuaꞌafuga kai, Elaija agemai ageafiopua ma auga amaisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ke Iesu eagagapea afegai, laꞌaina egu fua, elaꞌafuga emae. ");
INSERT INTO mek_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ega aisama Deo ega eꞌa alogai tiapu keꞌeꞌe auga auꞌoniai ipuainagai eꞌiꞌipea eake elao papagai, gua emia. ");
INSERT INTO mek_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ke ifani lopiaga, ifani auꞌi 100 eꞌimaꞌi auga, Iesu agogai eapa, ke ala emae oma eisa aisama einaka, “Iifa gome iꞌina Deo Gauga paisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Iesu kolotiai emae alogai, papie isaꞌi agomaai keapa kai maaꞌi mo elao keisa. Egaꞌina papieꞌi epoꞌiai Maria Makdalena, Maria Joses ke James inaꞌi, ke Salome fou. ");
INSERT INTO mek_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Iꞌina papieꞌi Iesu Kalileai elao emai aisama, isa muninai kepeapea, ke kepapalagaina. Ke papie maꞌo Iesu muninai kepea Ierusaleme kemai auꞌi isafa, egae keapa. ");
INSERT INTO mek_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Egaꞌina kina auga Iudea papiauꞌi eꞌi pinauga maꞌoai kepafua afeꞌaina kina. Ke egani aisama, Iudea papiauꞌi Deo keau afagaina auga kina. ");
INSERT INTO mek_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Egaꞌina kinagai au aka Iosepa, Iudea agogai taoni aka Arimatea keoma auga eagu. Isa auga Deo ega agofaꞌa agemai auga eagu eꞌimaisa. Ke Iudea auꞌi akaikiꞌaꞌi epoꞌiai kansolo akaikiꞌa agaꞌo. Isa Iesu emae efua auga fouga elogo aisama, aimaniꞌina mo elao Pilato eegai Iesu imaauga gaafia eoma paꞌanina epaꞌani. ");
INSERT INTO mek_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kai Pilato Iesu emae efiaisakoa auga fouga elogo aisama, ekauai alogaina. Ega puo ifani lopiaga, ifani auꞌi 100 eꞌimaꞌi auga, eifaga emai kai Iesu emae efua ma auga paꞌanina epaꞌani. ");
INSERT INTO mek_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ke Pilato ifani lopiaga eegai Iesu emae auga iifaga eafiia aisama, Iesu imaauga Iosepa epeniia. ");
INSERT INTO mek_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ke Iosepa tiapu manipina felo ipauma aka linen auga eꞌafaisa, Iesu imaauga kolotiai eafiopua, tiapu manipina egaꞌinagai emokaisa. Ke fopa laaga keapi umania mo auga alogai eogeisa. Egae kai fopa akaikiꞌa paꞌafi ake epae apua. ");
INSERT INTO mek_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Makdalena, ke Maria Joses ina fou, Iesu kapai eogeisa auga afuga keisa. ");
INSERT INTO mek_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ke Iudea papiauꞌi Deo keau afagaina kina epagai aisama, Maria Makdalena, Maria James ina, ke Salome fou mae auꞌi kepakumaꞌi mulamula fogaꞌi feloꞌi auꞌi keꞌafaiꞌi, ega koa fekelao Iesu imaauga fekepakuma keoma. ");
INSERT INTO mek_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ke egani iifi agaꞌo epogai kina eufai auga kinagai aisama, isa la kelao. ");
INSERT INTO mek_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ke kelao alogai, ifoꞌi mo kepaꞌani peniꞌi keinaka, “Kaisau agepalagainiꞌa la ake paꞌafina kepo agepaelaisa?” keoma. ");
INSERT INTO mek_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kai maaꞌi elao la keisa aisama, kepo akaikiꞌa ipauma auga eelai keisa. ");
INSERT INTO mek_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ke laai kekoko aisama, au aguꞌa agaꞌo tiapu keloga ipauma eiꞌiuka kaiꞌi kaina eagu keisa ke kemaniꞌi alogaina. ");
INSERT INTO mek_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kai isa epainiꞌi einaka, “Folomaniꞌi, Iesu Nasareta auga, kolotiai keauꞌuꞌua auga okapuga kai, isa emaunimue inae laaꞌi. Isa keogeisa afuga inamoꞌe amoisa. ");
INSERT INTO mek_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kai amolao ega imoi ke Peto fou amopainiꞌi, ‘Maamiai eifania koa iꞌopoga, isa ageufai Kalilea agelao, egae agoisa,’” eoma. ");
INSERT INTO mek_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ega aisama papie kepealai kefiaisakoa mo la kepuaꞌafuga. Gome isa kemaniꞌi alogaina ke kepigugu ke kekauai alogaina. Ke kai agaꞌo maagai kapaꞌina keisa auga akeifania, gome kemaniꞌi alogaina. Ufainagai puka isaꞌi kepapuaꞌi auꞌi Mako ega pukai 16:9-20 auga laaꞌi.  ");
INSERT INTO mek_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Pau Iesu iifi agaꞌo epogai kina eufai auga kinagai amagai ipauma emaunimue aisama, Maria Makdalena alogai tiapolo imagea kuagai gua keagu kai epapealaiꞌi auga eapakina peni kakaua. ");
INSERT INTO mek_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ke Maria Makdalena elao, Iesu fou keaguagu auꞌi aloꞌi ekiekie keapeapepe kai Iesu fouga maaꞌiai eifania. ");
INSERT INTO mek_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kai isa Iesu emaunimue auga fouga maaꞌiai eifania aina kelogonia, ke eisa eoma mo ganinagai akepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Egaꞌina afegai Iesu ega imoi auniꞌi pagua kelao keagai kepeapea kai, iisa iꞌoinagai isa eapakina peniꞌi. ");
INSERT INTO mek_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ke isa kelao Iesu ega imoi isaꞌi auꞌi maaꞌiai keifania kai, isa isafa akepakoꞌaniꞌi. ");
INSERT INTO mek_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Egaꞌina afegai Iesu ega apostolo auꞌi 11 auꞌi keaniani laolao kai eapakina peniꞌi. Ke Iesu eloꞌu peniꞌi, gome isa guaꞌi eꞌinoka, aloꞌi aekapula, Iesu emaunimue keisa keifania auꞌi akepakoꞌaniꞌi. ");
INSERT INTO mek_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ke epainiꞌi einaka, “Fopealai folao iifa faunina lau fou Deo ega pagama kapaꞌi maꞌoai maaꞌiai foifafoua. ");
INSERT INTO mek_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ke kaisau agepakoꞌania ke baptismo ageafia auga kania ageisagamau. Kai kaisau afaepakoꞌania auga Deo isa afa apala agepenia. ");
INSERT INTO mek_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ke kepakoꞌania auꞌi iꞌina isapuga gouga akeafia: Isa Lau akauai tiapolo papiau aloꞌiai akepapealaiꞌi, mala mamagai akeniniꞌani. ");
INSERT INTO mek_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ke isa imaꞌiai kaapa akeafiꞌi, ke mulamula apalaꞌi akeinu mo ganinagai afaepalifuꞌi, ke isafa auꞌi faagaꞌiai imaꞌi akeogeaua auꞌi feloꞌi akemia,” eoma. ");
INSERT INTO mek_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Lopia Iesu egaꞌina iifaꞌi eifaniꞌi afegai aisama, Deo Iesu ufai eꞌagauaina ke egae Deo kaina kainai eagu. ");
INSERT INTO mek_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Egaꞌina afegai isa ega apostolo auꞌi kepealai kelao agofaꞌa fofouga maaꞌiai Deo ega iifa keinogonia, ke Lopia isa fou kepinauga puo, isapu gougai ega iifa maꞌoai koꞌaꞌi mo kemia. ");
INSERT INTO mek_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Papiau maꞌo Iesu eꞌina ega pinauga ekapaisa, ke ala epafua oma auga ifoꞌi maaꞌiai keisa. Isa kapaꞌina keisa auga kepakoꞌania, ke egaꞌina papiauꞌi epoꞌiai isaꞌi, Iesu fouga papiau maaꞌiai fekeifafoua auga pinauga kekapaisa. Ke isa egaꞌina fouꞌi maaꞌaisai keifania, ke kepapua kepeni pagainiꞌa. Ega kainai Iesu fouga keifania auga iifa koꞌa apamia, ke aloꞌa koꞌagai apakoꞌania. Ke iꞌa epoꞌaisai papiau maꞌo Iesu fouga ala eꞌina oma aꞌo kelogonia auga okogai mo kepapua. ");
INSERT INTO mek_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Teofilus, au akaikiꞌa aumu, papiau isaꞌi oi maamuai Iesu fouga keifania auga fouga lalogo. Kai lau alou koꞌagai anina laani auga, oi Iesu fouga koꞌa ipauma auga fologo laoma. Ega kainai lau ifou Iesu eꞌina kapaꞌina ekapaiꞌi fouꞌi maꞌoai okoꞌi ipaumagai lamaleleainiꞌi. Ke fuagai oi faumuai fapapua fapenio auga laopolaga felo laoma. Ega puo Iesu fouga lapapua eemu efai. ");
INSERT INTO mek_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ega kinagai Kin Herod, Iudea ago fofouga eꞌimaisa alogai, sakedote auga agaꞌo aka Sakaraia eagu. Isa sakedote ikupuga alogai gopu agaꞌo aka Abaija keoma auga gopugai emai. Isa akafa aka Elisabeta isafa sakedote lopia faꞌa aka Aaron keoma auga ega gopuai emai. ");
INSERT INTO mek_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakaraia akafa auniꞌi auga Deo maagai alo opai auꞌi, ke aloꞌi koꞌagai Deo ega iifa maꞌoai, ke sakedote laoꞌi maiꞌi maꞌoai kaiꞌiai kepea. Ega kainai kai agaꞌo isa kapa agaꞌo apala kekapaisa auga puo aepeniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ke isa imoi eega laaꞌi gome isa akafa Elisabeta eogeoge. Ke isa auniꞌi auga pau keapao alogaina. ");
INSERT INTO mek_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Sakaraia ega sakedote gopuga auꞌi Deo ega eꞌai kepinauga kinaꞌiai, isa isafa sakedote pinaugaga ekapaisa. Egaꞌina alogai Iudea papiauꞌi sakedote kekinaniꞌi kagakagagai Sakaraia kekinaga. Ke keulaisa Lopia Deo ega eꞌa alogai sakedote lopia faꞌaꞌi mo kekoko, aꞌo Deo kepaꞌa penia afugai fekoko, amu fogaꞌi feloꞌi feumaꞌi ke femegamega keoma. ");
INSERT INTO mek_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ke amu fogaꞌi feloꞌi iuma kina maaga emai aisama, papiau Deo ega eꞌa afe kaina kemegamega kai, Sakaraia ifogamo Deo ega eꞌa alogai ekoko, amu fogaꞌi feloꞌi eumaiꞌi ke emegamega. ");
INSERT INTO mek_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ega aisama Lopia ega agelo agaꞌo, aꞌo Deo kepaꞌa penia afuga kaina kainai isa eapakina penia. ");
INSERT INTO mek_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaraia agelo eisa aisama, oge egea emaniꞌi alogaina. ");
INSERT INTO mek_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kai agelo isa epainia einaka, “Sakaraia, folomaniꞌi. Gome Deo oi emu megamega aꞌo elogonia, ke lau eulaisau lamai. Oi akafamu Elisabeta imoi maguaega agepamauga. Ke imoi egaꞌina aka Ioane fooma. ");
INSERT INTO mek_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Isa oi alogama agepenimi, ke oi isa agomalaniaina. Ke papiau maꞌo isafa isa emauni auga alogama akepaꞌaua. ");
INSERT INTO mek_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Gome isa Lopia maagai au akaikiꞌa agemia. Isa fino, o mulamula inoka agaꞌo faeinu. Ke ina gua alogai ekaega kai, Deo ega Spiritu isa alo agepapogua. ");
INSERT INTO mek_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ke isa Israel papiauꞌi maꞌo agemueainiꞌi Lopia isa eꞌi Deo eega agemaiseiniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ke ufainagai Elaija Deo ega Spiritu isapuga eafiia epinauga koa iꞌopoga, isa egaꞌina isapuga ageafia. Ke Lopia aemai koa kai, isa imoi amaꞌi aloꞌi agepaefo pagainia gauꞌi akeaipeniꞌi, ke papiau Deo aina akeafia auꞌi isafa aloꞌi agepaefo pagainia, papiau Deo maagai alo opai auꞌi eꞌi ikifa keagagai akepea. Ke Lopia faugai papiau agepafuaꞌi akeagu,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ke Sakaraia agelo epainia einaka, “Egaꞌina iifaga mapakoꞌania auga afaꞌagamo eꞌinoka. Gome lau laapao alogaina ke akafau isafa eapao, imoi agaꞌo fepamauga koa kina auga efua,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ke agelo einaka, “Lau Gabriel Deo agogai laapae, ke lau Deo eulaisau oi maamuai Deo ega iifa faunina iꞌina faifafoua eoma lamai. ");
INSERT INTO mek_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ke moisa, oi akemu ageafu, afoloniniꞌani agelao lau laifaniꞌi kapaꞌi maꞌoai koꞌaꞌi akemia kinagai kai, aloniniꞌani pugu. Gome lau Deo ega iifa oi maamuai laifania auga, ega logoai ega kina agekaina aisama koꞌa mo agemia auga oi alopakoꞌania,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ke papiau Deo ega eꞌa afe kaina kemegamega auꞌi Sakaraia keꞌimaisa. Ke Sakaraia Deo ega eꞌa alogai eapa alogaina, aepealai aemai puo kekauai keopofua. ");
INSERT INTO mek_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ke epealai aisama, maaꞌiai ganiniꞌani eoma auga aekainia. Ke kelogo isa Deo ega eꞌa alogai, laulau agaꞌo eisa keoma. Gome isa imagai mo gou ekapaisa kai, akegai ganiniꞌani eoma aekainia auga keisa. ");
INSERT INTO mek_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Isa ake eafu aeniniꞌani mo elao Deo ega eꞌai ega pinauga epafua, ke ega pagua elao. ");
INSERT INTO mek_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ke egaꞌina kinaꞌi afegai, isa akafa Elisabeta einae. Ke gafa ima alogai, isa eꞌa alogai mo eagufake eagu ke eifa einaka: ");
INSERT INTO mek_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Lopia Deo lau faagauai iina koa ekapaisa. Paukai Isa ega gafegafe akaikiꞌa epeniiau, papiau epoꞌiai imoi agaꞌo alapamauga auga meagaina eafiꞌaua,” eoma. Ke isa faagagai kapaꞌina emia auga koꞌa ma auga gakapulaisa eoma puo, gafa ima eꞌa alogai eagu, Deo mo eopolaga. ");
INSERT INTO mek_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Ega kinagai ifiao faaga fofouga agaꞌo, au agaꞌo fou akefeufeu auga ifiaoga aka Maria eagu. Isa kin Davide okogai emai auga agaꞌo aka Iosepa fou fekeamage keoma auga papiau maaꞌiai keifafoua. Elisabeta einae gafa ima epagai afegai, kina agaꞌogai Deo agelo Kabriel eulaisa, Kalilea agogai, Nasareta paguaga elao. ");
INSERT INTO mek_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Agelo elao Maria eapakina penia epainia einaka, “Maria, oi loague? Lopia ega gafegafe akaikiꞌa epeniio, ke eemuai eague,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Agelo Maria epamegonia auga, pamego aage laaꞌi puo aꞌo elogonia aisama, emaniꞌi eopofua. Ke egaꞌina pamegoga kapaꞌina eifania auga oko ekapunia galogo eoma. ");
INSERT INTO mek_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Maria agelo ega iifa eopopolaga kai, agelo eifa pugu einaka, “Maria, folomaniꞌi. Deo oi ekinanio ega gafegafe akaikiꞌa epeniio. ");
INSERT INTO mek_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Fologo oi aloinae, imoi maguaega agaꞌo alopamauga. Imoi egaꞌina aka Iesu fooma. ");
INSERT INTO mek_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ke isa au akaikiꞌa ipauma agemia, ke papiau isa akeifaga Deo ufai auꞌoniai eagu, Au Akaikiꞌa Ipauma Auga Gauga akeoma. Ke imoi egaꞌina apa Davide okogai agemai. Ke ufainagai Davide isapu akaikiꞌagai Israel papiauꞌi eꞌimaꞌi koa iꞌopoga, Lopia Deo isa isapu akaikiꞌa agepenia. ");
INSERT INTO mek_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ke isa Israel papiauꞌi, Iakobo okogai kemai auꞌi aoniamo ageꞌima afeꞌainiꞌi. Ke isa agofaꞌa eꞌima auga afaefua ageka aoniamo,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ega aisama Maria eifa einaka, “Agekaina kai lau fofou au agaꞌo fou alafeufeu kai, ala koa iꞌopoga faagauai iina koa agemia agekaina?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ke agelo einaka, “Deo ega Spiritu oi ageake penio, ke Deo ufai auꞌoniai eague, Au Akaikiꞌa Ipauma Auga ega isapuai agepakaisogonio aloinae. Ega puo oi Deo maagai alo lolofa imoina alopamauga, ke papiau isa akeifaga Deo Gauga akeoma. ");
INSERT INTO mek_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Oi aamu Elisabeta isafa apaogai ganinagai imoi agaꞌo agepamauga. Ke isa eogeoge keoma auga pau einae gafa imagea elao. ");
INSERT INTO mek_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Gome Deo eegai kapa agaꞌo aeꞌinoka.” ");
INSERT INTO mek_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria agelo ega eifa oma aina elogonia aisama, eifa einaka, “Lau Lopia Deo ega pinauga ikapa papiau agaꞌo. Ega puo oi loifania koa iꞌopoga faagauai gamia,” eoma. Egaꞌina afegai agelo Maria epuaꞌafuga elao. ");
INSERT INTO mek_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Agelo Maria epuaꞌafuga afegai aisama, Maria fiakoa mo ekailai Elisabeta eega elao. Elisabeta akafa Sakaraia ega eꞌa auga, Iudea ago taonina, iku afuga agogai eapa. ");
INSERT INTO mek_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Maria egaꞌina eꞌagai ekoko Elisabeta epamegonia. ");
INSERT INTO mek_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ke Elisabeta Maria ega pamego aꞌo elogonia aisama, gua alogai imoi isafa alo egama egopokae, ke Elisabeta Deo ega Spiritu alo epogu. ");
INSERT INTO mek_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ega aisama alo egama alogaina eifa akaikiꞌa einaka, “Papie maꞌoai epoꞌiai Deo ega gafegafe akaikiꞌa epeniio, ke imoi oi alopamauga auga isafa Deo ega gafegafe akaikiꞌa epeniia! ");
INSERT INTO mek_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kai kapa puo lau papie akaikiꞌau koa iꞌopoga lamia, eꞌu Lopia ina emai eisau? ");
INSERT INTO mek_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Lau ega laifa oma, gome oi emu pamego aꞌo lalogonia mo aisama, fiakoa mo guau alogai imoi alo egama egopokae. ");
INSERT INTO mek_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Oi Lopia ega iifa loafia auga lopakoꞌania Lopia agekapa paisa looma aumu, Deo eegai kapa feloꞌi loafiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ega aisama Maria isafa alo egama alogaina puo eifa einaka: “Lau alou koꞌagai Deo laau afagaina. ");
INSERT INTO mek_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ke Deo kaniau isagamauga Auga eegai alou egama alogaina. ");
INSERT INTO mek_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Gome lau Deo ega pinauga ikapa papieu, akaikiꞌau laaꞌi kai papie mainiu. Kai Deo lau eopolaniau ega gafegafe epeniiau. Ega kainai papiau pau keague auꞌi ke muni akemai auꞌi aoniamo akeifaniau, Deo ega gafegafe akaikiꞌa epeniiau papieu akeoma. ");
INSERT INTO mek_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Gome Deo Isapu Akaikiꞌa Auga kapa maꞌoai agekapa agekaina auga, kapa akaikiꞌaꞌi lau faagauai ekapaiꞌi. Isa aka elolofa. ");
INSERT INTO mek_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ke kaisau Deo kemaniꞌiaina, ega iifa muninai kepea auꞌi guaꞌi eania. Ke pau keague auꞌi ke muni akemai auꞌi isafa eeꞌiai ega koa agekapa aoniamo. ");
INSERT INTO mek_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Isa ega isapu akaikiꞌa epapinauga, kapa akaikiꞌaꞌi ekapaꞌi, papiau kapaꞌi opoꞌiai keainaꞌau auꞌi euokaiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ke keainaꞌau auꞌi epoꞌiai, papiau keꞌimaꞌi lopiaꞌi auꞌi eꞌi lopia eafaniꞌi. Kai akeainaꞌau auꞌi, au akaikiꞌaꞌi epamiaꞌi. ");
INSERT INTO mek_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ke inaeꞌi ekimu keulalu auꞌi, amu feloꞌi epagafuniꞌi kai, paꞌamuꞌamu auꞌi imaꞌi maini epalaoꞌi. ");
INSERT INTO mek_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Deo ufainagai lau apau Abraham, ke okogai kemai auꞌi eeꞌiai pakoꞌa niniꞌanina ekapaisa. Egaꞌina iifaga afaeꞌagege, aoniamo guaꞌi ageania. Ega koa iꞌopoga, Isa ega pinauga ikapa Israel papiauꞌi guaꞌi eaniia aeꞌagegeainiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria ega eifa oma afegai, Elisabeta fou keagu gafa oiso koa iꞌopoga elao afegai kai, emue ega pagua elao. ");
INSERT INTO mek_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Egaꞌina afegai Elisabeta ega mauni kina emai ekainia aisama, imoi maguaega epamauga. ");
INSERT INTO mek_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Isa aaga akina ke eꞌa ipafe auꞌi imoi epamauga fouga kelogo aisama, eega kelao. Ke Deo isa gua eani alogaina eogeoge meagaina eafiꞌaua imoi epamauga puo, fou kealogamalaina. ");
INSERT INTO mek_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ke imoi emauni kina imagea kuagai oiso aisama, Iudea papiauꞌi eꞌi kagakaga kainai, imoi kelaoaina maguaega faaga iifalaina gouga faagagai kekapaisa. Ke imoi ama akagai kegapafaala Sakaraia kegaoma keoma. ");
INSERT INTO mek_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kai imoi ina isa epaapakipoꞌi eifa einaka, “Sakaraia folooma! Ioane amooma,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ega aisama isa kepainia keinaka, “Oi aamu akimu auꞌi epoꞌiai, kai agaꞌo aka ega koa laaꞌi,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Egae kai egaꞌina papiauꞌi Sakaraia imoi aka kapaꞌina ageoma auga imaꞌiai gouga kekapaisa kepaꞌani penia. ");
INSERT INTO mek_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ega aisama Sakaraia kapa agaꞌo kegamaiseina imoi aka gapapua eoma, gouga imagai ekapaisa. Ke kemaiseina aisama iina epapua oma, ‘Imoi aka Ioane’ eoma. Egae keapa auꞌi isa akafa eifania koa iꞌopoga mo epapua auga keisa puo, kekauai alogaina keopofua. ");
INSERT INTO mek_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ke imoi aka epapua aisama, fiakoa mo mala emameꞌa ake epaagalaisa, eniniꞌani pugu, ke Deo eau afagaina. ");
INSERT INTO mek_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ke Sakaraia ega eꞌa ipafe auꞌi keisa, ke iꞌina laoga maina fouga kelogo auꞌi maꞌoai epoꞌiai Deo kapaꞌina ekapaisa auga maniꞌina kepaꞌaua. Ke Iudea ago fofouga iku afugai keagu auꞌi maꞌoai kapaꞌina kemia auꞌi maꞌoai fouꞌi keifaniꞌi aefuafua. ");
INSERT INTO mek_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ke papiau maꞌoai imoi egaꞌina Deo ima alogai eagu auga keisa, ke egaꞌina fouga aloꞌiai eka. Ke ifoꞌi mo epoꞌiai keifa keinaka, “Imoi iꞌina auga muni ala agemia oma auga oko alalogo,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ioane ama Sakaraia mala emameꞌa eniniꞌani pugu aisama, Deo ega Spiritu alo epogu, Deo eau afagaina, ke profeta koa iꞌopoga iina eifa oma: ");
INSERT INTO mek_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Lopia Israel papiauꞌi eꞌi Deo ega papiau eopolaniꞌi emai eꞌi ou auꞌi eeꞌiai epapealaiꞌi, kaniaꞌi eagamauga. Ega puo iꞌa Isa amaau afagaina. ");
INSERT INTO mek_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Isa ega pinauga ikapa auga, kin Davide okogai au agaꞌo ekinaga eulaisa. Egaꞌina auga, Au Akaikiꞌa, iꞌa kaniaꞌa Isagamauga auga. ");
INSERT INTO mek_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Egaꞌina auga ufainagai isa ega profeta aloꞌi elolofa auꞌi akeꞌiai eifafoua auga iꞌopoga mo emia. ");
INSERT INTO mek_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Egaꞌina iifaga auga Isa Mesaia ageulaisa, iꞌa aꞌa ou auꞌi aniꞌa akeani auꞌi eꞌi isapu papagai aagu auga eeꞌiai agepapealaiꞌa eoma. ");
INSERT INTO mek_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Deo ufainagai iꞌa ufuꞌa apaꞌa guaꞌi eaniia, ke fou pakoꞌa niniꞌanina kapula ipauma kai agaꞌo laagai afaeaopagai auga ekapaisa. Ke pakoꞌa niniꞌanina kapula egaꞌina auga Deo maagai lolofaga ipauma. Egaꞌina auga Deo eopolaga puo iina ekapa oma. ");
INSERT INTO mek_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Egaꞌina auga, Deo iꞌa apaꞌa Abraham auniꞌi kepakoꞌania keifa kapulania auga. ");
INSERT INTO mek_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Iꞌina iifaga koꞌa ipauma! Deo anina eani iꞌa aꞌa ou auꞌi akeafi apalaniꞌa auga maniꞌina falapaꞌaua, ke Isa faugai fapinauga, ke faau afagaina eoma. Ega kainai Isa iꞌa aꞌa ou auꞌi imaꞌiai epapealaiꞌa. Ke Isa anina eani auga, aufa kina iꞌa Isa aau afagaina ke faugai apinauga alogai, aloꞌa koꞌagai laomai apalaꞌi faumakalainiꞌi, ke maagai alo lolofa, ke alo opai auꞌa famia eoma. Ega kainai Deo pakoꞌa niniꞌanina kapula ipauma ekapaisa. ");
INSERT INTO mek_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ke oi Ioane gau aumu, papiau oi akeifanio Deo Au Akaikiꞌa, ufai auꞌoniai eague Auga ega profeta akeoma. Gome oi Lopia Mesaia agogai aloufai alolao ega keaga alopakaisa. ");
INSERT INTO mek_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ke keaga alopakaisa alogai Deo ega papiau, Deo isa eꞌi laomai apalaꞌi ala ageꞌagegeai omaꞌi, ke kaniaꞌi ala ageagamau oma auga alopalogoniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Iifa gome iꞌa uminagai aagu Deo alalogo felo, ke aꞌa laomai apala ipauma emokaiꞌa puo amae koa iꞌopoga. Kai Deo egaꞌina auga anina aeani, gagao keagagai gapapeaiꞌa, iꞌa fou gagaoai faagu eoma. Ega kainai Deo kapa maꞌoai ekapaiꞌi auga, ega guani ke ega gafegafe akaikiꞌa epakinaiꞌa. Iꞌina auga, kina egefau eaea koa iꞌopoga ufai ageake agegefaiꞌa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Sakaraia iina eifa oma afegai, inipo epea kainai gauga Ioane Deo ega Spirituai euki eminifaꞌa. Ke eminifaꞌa afegai, elao ago maininai eagu mo elao ega pinauga kina ekainia kai, Israel papiauꞌi agoꞌiai eapafoki. ");
INSERT INTO mek_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ioane Baptista aemauni koa kai, Roma ago fofouga eꞌima lopia faꞌaga aka Augustus iifa eulaisa Roma kamanina papagai keagu auꞌi fofougai census fekekapa eoma. ");
INSERT INTO mek_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Census egaꞌina auga kafana Kurinius Siria ago eꞌima kinagai eꞌina emia. ");
INSERT INTO mek_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ke Iesu ega mauni kina ekaialiali alogai, census egaꞌina Siria ke Iudea agoꞌi fofouga alogai emia. Ega puo papiau maꞌoai agaꞌo agaꞌo kelao eꞌi mauni afugai akaꞌi fekepapua keoma. ");
INSERT INTO mek_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Iosepa ega mauni afuga auga Davide okogai kemai auꞌi afuꞌi puo, Kalilea agogai Nasareta taonina epuaꞌafuga, Iudea agogai Beteleme, Davide ega taoni keoma auga taonina elao. ");
INSERT INTO mek_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ega aisama Maria isa auniꞌi keifa koꞌania fekeamage keoma auga einae kai, fou akaꞌi fekepapua keoma puo, kelao Beteleme taonina. ");
INSERT INTO mek_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Ega aisama Maria imoi agepamauga auga kina ekainia. Kai feufeu eꞌai maꞌoai kepogu puo, eꞌa agaꞌogai fekefeu auga aekainia. Ega puo kelao iku eꞌele agaꞌo inegai sipi ke polomakau kepaanianiꞌi afugai keagu. Egae imoi faꞌaniauga maguaega epamauga, ke tiapuai emokaisa, fafaoai epakauka. ");
INSERT INTO mek_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Iesu emauni gapinai, sipi iꞌima auꞌi isaꞌi Beteleme taonina afegai, kainagai sipi keanimai afugai keagu eꞌi sipi keꞌimaꞌi. ");
INSERT INTO mek_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Egaꞌina alogai fiakoa mo Lopia ega agelo agaꞌo eapakina peniꞌi, ke Deo ega eaea akaikiꞌa ipauma eailofeꞌi. Ega aisama sipi iꞌima auꞌi kemaniꞌi alogaina. ");
INSERT INTO mek_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kai agelo isa epainiꞌi einaka, “Lau iifa faunina ipauma papiau maꞌoai aloꞌi agepagama alogaina auga iifaga lamaiseina. Ega puo folomaniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Pau oi epomiai Betelemeai, Davide ega taoniai kaniami Isagamauga Auga emauni. Isa Lopia, ke Mesaia auga. ");
INSERT INTO mek_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Oi agolao aisama, imoi agaꞌo tiapuai kemokaisa fafaoai kepakauka agoisa. Egaꞌina agoisa aisama, fologo lau kapaꞌina laifania auga koꞌa fooma,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Agelo egaꞌina eifania efua aisama, fiakoa mo ufa ageloꞌi ealogai alogaina kemai keapakina, agelo egaꞌina fou Deo keau afagaina keifi keinaka, ");
INSERT INTO mek_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Deo auꞌoniai ufai eague auga, Au Akaikiꞌa Ipauma apamia, ke aagoai Deo papiau aniꞌi eani auꞌi gagao epeniꞌi,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Agelo keifi afegai, kemue ufa kelao. Ega aisama sipi iꞌima auꞌi ifoꞌi mo epoꞌiai keifa keinaka, “Amalao Beteleme taoninai Lopia ega agelo kapaꞌina emia maaꞌaisai eifania auga amaisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ega puo fiakoa mo kelao Maria Iosepa auniꞌi, ke imoi fafaoai ekauka auga afuga kekapunia kelao kekapulaisa. ");
INSERT INTO mek_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ke imoi keisa aisama, agelo imoi egaꞌina fouga ala eifa oma auga, Iosepa Maria auniꞌi, ke papiau isaꞌi isa fou kemai auꞌi maaꞌiai keifania kepalogoniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Papiau maꞌoai sipi iꞌima auꞌi iꞌina iifaga keifania aꞌo kelogonia aisama, kekauai alogaina keopofua. ");
INSERT INTO mek_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kai Maria auga egaꞌina iifaꞌi maꞌoai kapaꞌina keifaniꞌi auꞌi, alogai mo keka eopolaniꞌi aefuafua. ");
INSERT INTO mek_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipi iꞌima auꞌi imoi keisa afegai kemue. Egaꞌina alogai agelo kapaꞌina eifaniꞌi auꞌi maꞌoai iꞌopoꞌi mo kemia keisaꞌi puo, Deo Au Akaikiꞌa kepamia keau afagaina kelaoaina. ");
INSERT INTO mek_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Imoi egaꞌina emauni kina imagea oiso aisama, Iudea papiauꞌi eꞌi kagakaga kainai, au maguaeꞌi faaga iifalaina gouga kina emai ekainia aisama, imoi faagagai egaꞌina gouga kekapaisa. Ke Maria guagai imoi aegama koa kai, agelo imoi aka epeniia auga kepeniia kepafaala Iesu keoma. ");
INSERT INTO mek_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Maria imoi epamauga emegomego puo, Iudea papiauꞌi eꞌi kagakaga kainai, kina pika koa iꞌopoga Deo maagai alo eofu. Ke alo ofuga efua kina afegai, Moses ega iifa kainai Maria Iosepa auniꞌi imoi keafiia Deo ega eꞌa kelao, Deo fekepalao penia keoma. Ega kainai imoi keafiia Ierusaleme taonina kelao, ke Deo ega eꞌai sakedote eeꞌi kelao, imoi Deo kepalao penia. ");
INSERT INTO mek_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Deo ega iifa Moses epeniia auga epoꞌiai agaꞌo auga iina epapua oma: ‘Imoi maguaeꞌi faꞌaniauꞌi auꞌi, Lopia Deo fekepalao penia, Isa apuga fekemia,’ eoma. Ega kainai Maria Iosepa auniꞌi ega kekapa oma. ");
INSERT INTO mek_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ke Moses ega iifa kainai, Maria faugai inei auniꞌi koofi koa iꞌopoꞌi, o inei eꞌeleꞌi auniꞌi fekeafiꞌi fekelao sakedote fekepeniꞌi eoma. Ega kainai Maria Iosepa auniꞌi inei keafiiꞌi kelao sakedote kepeniiꞌi. Ke sakedote Maria faugai inei egaꞌina Deo kepaꞌa penia. ");
INSERT INTO mek_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kai egaꞌina kekapaiꞌi kinagai, Ierusaleme taoninai au agaꞌo aka Simion eagu. Isa auga Deo maagai alo opaina, ke alo koꞌagai Deo ega iifa muninai epea. Isa Deo Israel papiauꞌi agepalagainiꞌi, kaniaꞌi ageagamauga auga kina eꞌimaisa, ke Deo ega Spiritu isafa isa alogai eagu. ");
INSERT INTO mek_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Deo ega Spiritu isa afaemae ageagu agelao Lopia Deo ega Mesaia ageisa afegai kai, agemae auga epalogo. ");
INSERT INTO mek_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ke Deo ega Spiritu isa epapea elao Deo ega eꞌa alogai ekoko. Ega aisama Moses ega iifa kagakagagai, imoi Iesu faugai kapaꞌina fekekapa keoma auga kainai, ina ama isa keafiia Deo ega eꞌai kekokoaina. ");
INSERT INTO mek_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ega aisama Simion elao imagai imoi eafiia kai Deo eau afagaina einaka: ");
INSERT INTO mek_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Lopia Deo Akaikiꞌa Aumu, oi emu pakoꞌa iifaga lokapaisa auga pau koꞌa mo emia. Pau oi emu pinauga au, emu gagaoai alamae. ");
INSERT INTO mek_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Gome oi papiau kaniaꞌi aloagamauga auga, pau lau ifou maauai laisa. ");
INSERT INTO mek_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Egaꞌina auga papiau maꞌoai agoꞌiai lokapaisa puo, muni maꞌoai akelogo. ");
INSERT INTO mek_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Egaꞌina auga isa Iudea papiauꞌi laaꞌi auꞌi eeꞌiai eaea agemia, Oi emu logo agepalogoniꞌi. Ke Israel papiauꞌi epoꞌiai papiau kaniaꞌi isagamauga auga emauni puo, Israel papiauꞌi akaꞌi akaikiꞌa agemia eoma. ");
INSERT INTO mek_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Imoi ina ama auniꞌi Simion imoi fouga ega eifa oma aina kelogonia aisama, kekauai alogaina keopofua. ");
INSERT INTO mek_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ke Simion Deo eau afagaina afegai, imoi ina ama ke imoi fou eeꞌiai Deo ega gafegafe akaikiꞌa iifaga epeniiꞌi. Egae kai Simion imoi ina Maria epainia einaka, “Iifa gome, iꞌina imoina Deo ega logoai ekinaga, Israel papiauꞌi maꞌo isa puogai papiau akaikiꞌaꞌi auꞌi eꞌeleꞌi akemia, ke eꞌeleꞌi auꞌi akaikiꞌaꞌi akemia. Ke egaꞌina imoina Deo eegai emai auga gouga agemia. Kai papiau isa eegai akeifa apala ke akeumakalaina. ");
INSERT INTO mek_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Egaꞌina akekapa alogai, papiau guaꞌi opoꞌi fofougai isa anina keani, o anina akeani auga agepafokiꞌi. Ke Maria, oi gaumu puo papiau akeumakalaina aloisa aisama, aufalao agaꞌo ifani aꞌifagai guafopa keoga ekiekie koa iꞌopoga, oi alomu ega agekiekie oma, guamu agemou,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ke imoi egaꞌina ina ama fou Deo ega eꞌai egaꞌina kekapaiꞌi alogai, profeta papiega agaꞌo aka Ana isafa egae eagu. Isa auga Fanuel gauga, Israel papiauꞌi eꞌi ikupu agaꞌo aka Aser keoma auga ikupugai emai. Isa ufainagai eamage, ke akafa auniꞌi inipo imagea gua mo fou keagu kai akafa emae. ");
INSERT INTO mek_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Egaꞌina afegai afuafu mo eagu elao pau eapao alogaina, inipoga 84 emia. Isa aufa kina gapi gani Deo ega eꞌai mo eagu, eani gopegope emegamega. ");
INSERT INTO mek_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Isa imoi egaꞌina ina ama fou Deo ega eꞌai keapaega kai eisaꞌi. Ega aisama eeꞌi elao Deo tenkiu epeniia. Egae kai Deo Israel papiauꞌi eꞌi ou auꞌi eeꞌiai kaniaꞌi ageagamauga keꞌima auꞌi maꞌoai maaꞌiai imoi egaꞌina fouga eifafoua. ");
INSERT INTO mek_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Iosepa Maria auniꞌi kapa maꞌoai Lopia Deo ega iifa kainai fekekapa eoma auga pinauga kekapaisa efua aisama, kemue Kalilea ago, isa afuꞌi Nasareta taonina kelao. ");
INSERT INTO mek_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Imoi egaꞌina euki eminifaꞌa, ekapula elaoaina. Egaꞌina alogai Deo ega ikifa alo epogu, ke ega gafegafe akaikiꞌa alogai eka. ");
INSERT INTO mek_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Imoi Iesu euki eminifaꞌa alogai, ina ama auniꞌi Iudea papiauꞌi eꞌi miamia agaꞌo aka Pasover kina ekainia aisama, eꞌi kagakaga kainai aufa inipoai Ierusaleme taonina kelao. ");
INSERT INTO mek_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ke Iesu inipoga 12 emia aisama, miamia egaꞌina puogai ina ama aufa inipoai kekapakapa koa iꞌopoga Ierusaleme taonina kelao. Kai pau auga Iesu isafa fou kelao. ");
INSERT INTO mek_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ke miamia egaꞌina efua aisama, Iesu ina ama auniꞌi kemue afuꞌi kelao. Ega aisama Iesu Ierusaleme taoninai eagu kai, isa ina ama auga akelogo. ");
INSERT INTO mek_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Isa keopolaga gauꞌi papiau maꞌo egaꞌina miamia puogai kemai auꞌi epoꞌiai eapauka fou kemue kelao keoma. Ega puo akekapunia kai kina agaꞌo epagai aisama, keꞌina aaꞌi akiꞌi ke ekefaꞌaꞌi fou epoꞌiai kekapunia. ");
INSERT INTO mek_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kai gauꞌi akekapulaisa puo kekapunia kemue Ierusaleme taonina kelao. ");
INSERT INTO mek_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Isa Ierusaleme taonina kepuaꞌafuga, kina oiso afegai kai, Deo ega eꞌa alogai Iudea papiauꞌi eꞌi pamalele auꞌi fou keagu keisa. Ke isa kapaꞌina keifania auga aꞌo elogonia, ke isa isafa epaꞌani peniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Pamalele auꞌi isafa isa kepaꞌani penia. Ega aisama isa eꞌi iifa epamue, niniꞌani maꞌoai okogai mo elaoaina puo, egae keagu aina kelogo auꞌi maꞌoai keopofua kapaꞌina kegakapa auga akelogo. ");
INSERT INTO mek_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ke Iesu ina ama isa imoi eꞌele kai, pamalele auꞌi fou keagu keniniꞌani auga keisa puo, kekauai alogaina. Ke ina elao eifa einaka, “Oi inae loague kai oi amamu aunimai aopopo alogaina, akapunio afu apafua. Oi lai eemaisai iina lokapa oma auga felo laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kai Iesu epaꞌani einaka, “Kapa puo lau okapuniau? Lau Amau eegai lamai puo, lau Isa ega eꞌai faagu auga alologo ma?” eoma ");
INSERT INTO mek_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kai isa kapaꞌina eifania auga, isa ina ama oko akelogo. ");
INSERT INTO mek_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Egae kai Iesu ina ama fou kemue afuꞌi Nasareta taonina kelao. Ke ina ama fou keagu alogai, kina maꞌoai ainaꞌi eafiia. Kai ina Maria Iesu faagagai kapa maꞌoai kegama auꞌi eafiapiꞌi alogai mo keka. ");
INSERT INTO mek_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ke inipo epea kainai Iesu euki eminifaꞌa. Egaꞌina alogai ega ikifa isafa euki aefuafua, ke Deo ega gafegafe eafiia, ke papiau isafa isa anina keani alogaina. ");
INSERT INTO mek_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Inipo maꞌo elao afegai, Roma kamanina eꞌima lopia faꞌaga aka Tiberius, Roma ago ke Roma papagai keagu agoꞌi maꞌoai eꞌimaiꞌi. Isa Roma agofaꞌa fofouga eꞌimaisa inipo 15 elao. Ega aisama Roma kamanina papagai, Roma auga aka Pontio Pilato Iudea ago fofouga kafanaga emia. Kai isa Iudea ago aeꞌima koa kai, kin Herod Iudea ago fofouga eaupea pani epamia. Ke pau kin Herod gauga, aka isafa Herod auga Kalilea ago eꞌimaisa. Ke isa akina Filip auga, Iturea ke Trakonitis fou agoꞌi eꞌimaiꞌi, ke au agaꞌo aka Lisanias auga Abilene ago eꞌimaisa. ");
INSERT INTO mek_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Egaꞌina kinaꞌiai Iudea auꞌi gua Anas ke Kaiafas auniꞌi sakedote lopia faꞌaꞌi kemia Iudea papiauꞌi keꞌimaiꞌi. Ega aisama Deo ega iifa Sakaraia gauga Ioane, ago maininai eagu auga eake penia. ");
INSERT INTO mek_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ega kainai ago maini epuaꞌafuga, Jordan agapuge eegai keagu paguaꞌi maꞌoai maaꞌiai eꞌina Deo ega iifa eifafoua. Isa ega niniꞌaniai papiau epainiꞌi eꞌi laomai apalaꞌi kegaumakalainiꞌi, ega koa Deo isa eꞌi laomai apalaꞌi ageꞌagegeainiꞌi, ke baptismo fekeafia eoma. ");
INSERT INTO mek_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ioane ega koa ekapaisa auga ufainagai profeta Aisaea epapua Deo ega iifa pukagai ekae koa iꞌopoga. Egaꞌina iifaga iina epapua oma: “Ago maininai aufalao agaꞌo eagaga einaka: ‘Lopia faugai keaga amopakaisa amopaꞌopaina. ");
INSERT INTO mek_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Deo laloa maꞌoai agefufuniꞌi akeꞌi akepogu, ke iku eꞌeleꞌi, akaikiꞌaꞌi maꞌoai agepaakeꞌi iꞌopoꞌi agaꞌomo akemia. Keaga kefaefa auꞌi agepaꞌopainiꞌi, ke kelifu auꞌi agekapa feloꞌi. ");
INSERT INTO mek_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ega koa agofaꞌa fofouga papiauꞌi maꞌoai agaꞌomo akemia, Deo papiau kaniaꞌi ageagamauga auga akeisa.’” ");
INSERT INTO mek_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ioane papiau eꞌi laomai apalaꞌi fekeumakalainiꞌi, ke baptismo fekeafia auga inogoga epaꞌaua alogai, papiau baptismo kegaafia keoma puo, maꞌo kepealai eega kemai. Ega aisama Ioane laꞌafou papiauꞌi epaini kapulaniꞌi einaka, “Oi laomai apalaꞌi mo okapakapaꞌi alomi aeponi kai, paukai baptismoai mo Deo kaniami ageagamauga ooma ma? Kaisau oi maamiai eifa Deo ega guakupu eegai agopiaukoko agekaina eoma? Oi ikifa aumi, kaapa apala ipauma gauga koa iꞌopomi! ");
INSERT INTO mek_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Deo anina ageani koa aisama, iꞌina kepoꞌi ageafiꞌi Abraham gauga agepagamaꞌi agekaina. Ega puo oi ifomi epomiai foloifa, ‘Lai Abraham okogai amai aumai puo, Deo gauga aumai,’ folooma kakaua. Kai oi laomai apalaꞌi foumakalainiꞌi auga gouga fokapa. Egaꞌina auga au agaꞌo euki puaga felo eoge koa iꞌopoga, oi isafa puami felo mo feoge, papiau agoꞌiai laomai feloꞌi mo fokapaꞌi. Egae kai oi Abraham okogai omai fooma. ");
INSERT INTO mek_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Oi fologo Deo emi laomai apalaꞌi afa agepenimi auga, inaina au gagamugai efua ekae auga koa iꞌopoga. Ega puo au kapa puaga felo aeoge auga ageisaga loai ageiꞌafoau,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Papiau laꞌafouai iꞌina iifaga aꞌo kelogonia aisama, Ioane kepaꞌani penia keinaka, “Ega koa aisama, lai kapaꞌina fakapa looma?” keoma. ");
INSERT INTO mek_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ioane einaka, “Kaisau eegai tiapu iꞌiuka auniꞌi kekae aisama, agaꞌo feafia kaisau eegai laaꞌi auga fepenia. Ke kaisau eegai foꞌama ekae auga, kaisau eegai foꞌama laaꞌi auga fepenia. Ega agokapa oma koa aisama emi laomai feloꞌi mo akemia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Egaꞌina papiauꞌi epoꞌiai Roma kamanina papagai keagu tax papiau imaꞌiai keafia auꞌi isafa baptismo kegaafia keoma puo, Ioane eega kemai. Kemai aisama, Ioane kepaꞌani penia keinaka, “Pamalele aumu! Lai kapaꞌina fakapa looma?” keoma. ");
INSERT INTO mek_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ioane iifa epamue einaka, “Papiau imaꞌiai moni pika foafia keoma auga mo foafia. Kai laaga foloafi aauga,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ke ifani auꞌi isaꞌi isafa Ioane kepaꞌani penia keinaka, “Lai isafa kapaꞌina fakapa looma?” keoma. Ioane iifa epamue einaka, “Oi papiau folopaafiꞌi ke folopamaniꞌiniꞌi eꞌi moni foloafia. Ke pifogeai papiau folopaagu fofouꞌi. Kai emi pinauga afa monina oafia auga mo foafia. Ke egaꞌina mo alogama fopaꞌaua,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Papiau Ioane ega inogo auga isapuai einogo aꞌo kelogonia aisama, Mesaia kaina kekai auga afiaꞌamaga akaikiꞌa emia. Ke ifoꞌi aloꞌiai keopolaga keifa keinaka, “Mesaia agemai keoma auga inamoꞌe ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ioane iꞌina iifaga elogo aisama, egaꞌina papiauꞌi maꞌoai epainiꞌi einaka, “Lau feisai baptismo lapenimi. Iifa gome lau auga au eꞌeleu. Kai muniuai agemai auga au akaikiꞌa ipauma, ega isapu lau eꞌu isapu ekaꞌegaina. Ega puo lau isa ega kamata ufe mo ganinagai alagupuka afaekaina. Isa Deo ega Spirituai ke loai baptismo agepenimi. ");
INSERT INTO mek_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Isa imagai poka ageafia laiti kepagopo afugai ageapa, laiti felo auga gaafia kai, apala auga gaoge meꞌeꞌi ageoma. Ega kainai laiti kepaogogonia afugai ageapa laiti agepagopo. Ke felo auga ageafia, laiti keogeoge afugai ageoge. Kai apala auga ageafia lo aealoalo logai ageafoꞌaua ageaga,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ioane egaꞌina mo aeifania kai, niniꞌani maꞌo iꞌoiꞌi iꞌoiꞌiai papiau magogoꞌi eauniia. Ke iifa faunina Deo papiau eꞌi laomai apalaꞌi ageꞌagegeainiꞌi auga fouga maaꞌiai eifafoua. ");
INSERT INTO mek_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kai Herod Kalilea ago eꞌima auga akina akafa aka Herodias eakafania, ke laomai apalaꞌi ipaumaꞌi isafa maꞌo ekapaꞌi puo, Ioane isa efinaisa ke epaini kapulania. ");
INSERT INTO mek_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ega aisama Herod Ioane epatipulania. Isa laomai apalaꞌi maꞌo ekapaiꞌi. Ega mo aeoma kai Ioane isafa epatipulania puo, laomai apalaꞌi egaꞌina laaꞌiai, laomai apala agaꞌo eogeaua pugu. ");
INSERT INTO mek_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Herod Ioane aepatipulania koa kai, papiau maꞌoai Ioane eega kelao baptismo epeniiꞌi. Ega aisama Iesu isafa elao baptismo eafiia. Egaꞌina alogai Iesu emegamega aisama, ufa eagalai. ");
INSERT INTO mek_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ke Deo ega Spiritu koofi imaaugai Iesu eake penia. Ega aisama Deo ufai eifa opu einaka, “Oi Lau Gau animu laani alogaina aumu. Oi eemuai alou egama alogaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesu inipoga 30 koa iꞌopoga alogai, baptismo eafiia ke eꞌina ega pinauga ekapaisa. Iesu ega mauni ninina iina eka oma. Iesu ama auga Iosepa puo, papiau isa Iosepa gauga keoma. Ke Iosepa ama auga Heli. ");
INSERT INTO mek_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli ama auga Mathat. Mathat ama auga Lefi. Lefi ama auga Melki. Melki ama auga Jannai. Jannai ama auga Iosepa. ");
INSERT INTO mek_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Iosepa ama auga Matatias. Matatias ama auga Amos. Amos ama auga Nahum. Nahum ama auga Esli. Esli ama auga Nakai. ");
INSERT INTO mek_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai ama auga Maat. Maat ama auga Matatias. Matatias ama auga Semein. Semein ama auga Josek. Josek ama auga Joda. ");
INSERT INTO mek_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda ama auga Joanan. Joanan ama auga Resa. Resa ama auga Serubabel. Serubabel ama auga Sealtiel. Sealtiel ama auga Neri. ");
INSERT INTO mek_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ama auga Melki. Melki ama auga Adi. Adi ama auga Kosam. Kosam ama auga Elmadam. Elmadam ama auga Er. ");
INSERT INTO mek_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ama auga Josua. Josua ama auga Elieser. Elieser ama auga Jorim. Jorim ama auga Mathat. Mathat ama auga Lefi. ");
INSERT INTO mek_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lefi ama auga Simion. Simion ama auga Juda. Juda ama auga Iosepa. Iosepa ama auga Jonam. Jonam ama auga Eliakim. ");
INSERT INTO mek_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim ama auga Melea. Melea ama auga Mena. Mena ama auga Matata. Matata ama auga Nathan. Nathan ama auga Davide. ");
INSERT INTO mek_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davide ama auga Jese. Jese ama auga Obed. Obed ama auga Boas. Boas ama auga Salmon. Salmon ama auga Nason. ");
INSERT INTO mek_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason ama auga Aminadab. Aminadab ama auga Ram. Ram ama auga Hesron. Hesron ama auga Peres. Peres ama auga Juda. ");
INSERT INTO mek_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda ama auga Iakobo. Iakobo ama auga Aisak. Aisak ama auga Abraham. Abraham ama auga Tera. Tera ama auga Nahor. ");
INSERT INTO mek_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor ama auga Seruk. Seruk ama auga Reu. Reu ama auga Pelek. Pelek ama auga Eber. Eber ama auga Sela. ");
INSERT INTO mek_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela ama auga Kainan. Kainan ama auga Arfaksad. Arfaksad ama auga Sem. Sem ama auga Noa. Noa ama auga Lamek. ");
INSERT INTO mek_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek ama auga Medusela. Medusela ama auga Enok. Enok ama auga Jared. Jared ama auga Mahalalil. Mahalalil ama auga Kenan. ");
INSERT INTO mek_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan ama auga Enos. Enos ama auga Set. Set ama auga Adamo. Ke Deo Adamo epagama. ");
INSERT INTO mek_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kai Iesu aeꞌina ega pinauga aekapa koa kai Jordan agapugegai baptismo eafiia. Egaꞌina alogai Deo ega Spiritu alo epogu. Egae kai Jordan epuaꞌafuga emue afuga Kalilea ago elao. Elao alogai Deo ega Spiritu epapea elao ago maininai ekoko. ");
INSERT INTO mek_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ke kina 40 alogai kapa agaꞌo aeania kai, Deo ega Spiritu isa eꞌimaisa epapea. Egaꞌina kinaꞌiai Satani isafa isa eꞌopoisa. Kina 40 efua aisama, inaega ekimu alogaina. ");
INSERT INTO mek_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ega aisama Satani Iesu eꞌopoisa pugu eifa einaka, “Oi Deo Gauga koa aisama, iꞌina kepo mopaina palafa gamia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kai Iesu einaka, “Deo ega iifa pukagai iina kepapua oma: ‘Papiau aumauni palafa ifogamo akeania akeagu afaekaina.’ Kai Deo isafa anina fekeani, ke ega iifa kainai fekeagu,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ke Satani Iesu eafiia eꞌagauaina afu agaꞌo auꞌoniai, ke fiakoa mo agofaꞌa fofouga epakina. ");
INSERT INTO mek_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Egae kai epainia einaka, “Lau iꞌina agofaꞌa isapuga maꞌoai ke kapa feloꞌi maꞌoai iꞌina agofaꞌagai kekae auꞌi isafa oi alapenio apumu akemia. Gome iꞌina agofaꞌa fofouga lau kepeniiau laꞌima. Ke lau kaisau anina laani auga alapenia agekaina. ");
INSERT INTO mek_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ega puo oi lau ainau aloafia ke aloau afagainiau koa aisama, iꞌina kapaꞌi maꞌoai oi apumu akemia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kai Iesu einaka, “Deo ega iifa pukagai isafa iina kepapua oma: ‘Emu Lopia Deo ifogamo foau afagaina, ke Isa mo ega pinauga fokapa,’” eoma. ");
INSERT INTO mek_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Egae kai Satani Iesu eafiia pugu Ierusaleme taonina elaoaina. Egae Deo ega eꞌa ofaofa kua onina ipaumagai auniꞌi keapa kai epainia einaka, “Oi Deo Gauga koa aisama, iꞌina afugai mogopolai moake. ");
INSERT INTO mek_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Gome Deo ega iifa pukagai iina kepapua oma: “‘Isa oi faumuai ega agelo ageifa kapula peniꞌi akeꞌima feloiso. ");
INSERT INTO mek_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ke agelo imaꞌiai oi akeafiakaeiso, ega koa ifemu kepoai afoloꞌanina,’” eoma. ");
INSERT INTO mek_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kai Iesu einaka, “Deo ega iifa pukagai isafa iina kepapua oma: ‘Oi emu Lopia Deo foloꞌopo,’” eoma. ");
INSERT INTO mek_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satani egaꞌina mo aekapaiꞌi kai, iꞌopo iꞌoiꞌi iꞌoiꞌiai Iesu eꞌopoisa kai aekainia. Ega aisama Satani Iesu epuaꞌafuga, kina felo agaꞌogai kai feꞌopo pugu eoma. ");
INSERT INTO mek_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Egaꞌina afegai Iesu Deo ega Spiritu isapuga alo epogu, ago maini epuaꞌafuga emue Kalilea ago elao. Egae isa eꞌina ega pinauga ekapaisa. Ega aisama isa eꞌina epinauga paguaga eegai, Kalilea ago paguaꞌi maꞌoai aloꞌiai isa fouga efoufaꞌa. ");
INSERT INTO mek_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ke Iudea eꞌi laꞌafou afugai ekoko epamalele. Ega aisama papiau maꞌoai aina kelogo auꞌi isa au akaikiꞌa kepamia keifagaina. ");
INSERT INTO mek_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kai Iesu ega pinauga ekapaisa alogai elao Nasareta taonina, efaꞌa afugai ekoko. Ke Iudea papiauꞌi Deo keau afagaina kinagai ekapakapa koa iꞌopoga elao Iudea eꞌi laꞌafou afugai ekoko. Egae Iudea papiauꞌi eꞌi kagakaga kainai, Deo ega iifa puka gakuapina eoma puo eꞌue eapa. ");
INSERT INTO mek_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ega aisama egaꞌina afugai kepipalagai auꞌi agaꞌo profeta Aisaea Deo ega iifa epapua puka ipaofe auga eafiia epeniia. Egae kai Iesu puka ipaofe eafiia epagufa epaeisakaea. Ke Deo ega iifa Aisaea iina epapua oma auga eisa ekuapinia: ");
INSERT INTO mek_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“Lopia ega Spiritu eake peniau, gome isa lau isapu epeniiau. Ega koa iifa faunina ulalu auꞌi maaꞌiai faifafoua eoma. Ke eulaisau ketipula auꞌi akepealai auga, ke maakimiꞌi auꞌi maaꞌi felo agemia auga faifafoua eoma. Ke laomai apalaꞌi maꞌoai emokaiꞌi auꞌi akepealai auga, ke Deo inipo kapagai ega gafegafe agepeniꞌi auga isafa faifafoua eoma.” ");
INSERT INTO mek_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Iesu egaꞌina iifaga ekuapinia efua aisama, puka eofeisa ke pipalagai auga epenimue pugu. Ke Iudea eꞌi kagakaga kainai gapamalele eoma puo, elao kepamalele afugai eagukipo. Ega aisama papiau laꞌafou alogai keagu auꞌi maꞌoai maaꞌi alo ipaumagai Iesu keisa. ");
INSERT INTO mek_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ke Iesu eꞌina papiau epainiꞌi einaka, “Pau kapaꞌina lakuapinia aꞌo ologonia auga, lau faagauai koꞌa emia efua,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ega aisama papiau maꞌoai Iesu akegai Deo ega gafegafe fouga epealai eifania auga kelogo. Ega puo kekauai alogaina keopofua, ke keifa felo penia. Kai isa Iosepa gauga auga kelogo aisama, fiakoa mo keifa keinaka, “Iꞌina auga Iosepa gauga laaꞌi ma? Iifa gome isa Iosepa gauga ipauma!” keoma. ");
INSERT INTO mek_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iesu egaꞌina papiauꞌi mirakulo mo fekeisa keoma auga eisa puo epainiꞌi einaka, “Oi iꞌina iifaga ologo felo: Toketa, lai mopafeloimai alooma koa aisama, oi ifomu fopafelo kakauiso. Iifa gome maamiai laifania. Oi ega oniniꞌani oma koa iꞌopoga, pau lau eeuai iina oifa oma: Kapenaum taoninai kapaꞌina mo lokapaiꞌi fouꞌi alogo auꞌi, pau oi emu paguai mokapa amaisa ooma,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Iesu eifa pugu einaka, “Koꞌa ipauma mo maamiai laifania. Profeta epoꞌiai kai agaꞌo ifo ega paguai akepakoꞌania puo afakeifa koko. ");
INSERT INTO mek_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Deo ega iifa pukagai isonioni koꞌaꞌi mo kemia auꞌi maamiai alaifaniꞌi. Ufainagai profeta Elaija eagu kinaꞌiai, inipo oiso ke gafa imagea alogai, Deo ufa ekupunia puo, imu agaꞌomo ganinagai aeake. Ega kainai Israel ago fofougai magea akaikiꞌa emia. Egaꞌina alogai afuafu maꞌo isafa egae keagu. ");
INSERT INTO mek_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kai Deo Elaija aeulaisa Israel papiauꞌi eeꞌi aelao aepalagainiꞌi. Kai eulaisa Israel papiauꞌi laaꞌi auꞌi afuꞌi, Sidoni agogai Sarefat taoninai afuafu agaꞌo egae eagu auga eega elao epalagaina. ");
INSERT INTO mek_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Egae kai profeta iꞌoina agaꞌo aka Elisa eagu kinaꞌiai, Israel agogai papiau maꞌo molumolu isafaga keafiia keagu. Kai Deo Elisa Israel papiauꞌi eeꞌiai aeulaisa kai agaꞌo aepafelo. Kai Deo isa eulaisa Israel papiauꞌi laaꞌi auꞌi afuꞌi Siria ago elao, ifani lopiaga aka Naaman, molumolu isafaga eafia auga epafelo,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Laꞌafouai papiau keagu auꞌi maꞌoai Iesu Deo agogai Israel papiauꞌi laaꞌi auꞌi akaꞌi eafiakae kai, isa auga akaꞌi epaake alogaina puo guaꞌi ekupu alogaina. ");
INSERT INTO mek_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ega puo keꞌuegekae Iesu laꞌafou egaꞌina alogai keafiia kelaꞌalaisa. Ke kelaoainia mo iku eꞌelegai, Nasareta taonina afegai kegaafia laloai kegapiulaisa gamae keoma. ");
INSERT INTO mek_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kai Iesu egaꞌina laꞌafouga papiauꞌi epoꞌiai epeauka epealai elao. ");
INSERT INTO mek_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Egaꞌina afegai Iesu Nasareta taonina ikuai auga epuaꞌafuga eake elao Kalilea agogai Kapenaum taoninai ekoko. Egae Iudea papiauꞌi Deo keau afagaina kinaꞌiai, elao laꞌafou afugai ekoko papiau epamaleleniꞌi pugu. ");
INSERT INTO mek_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Egaꞌina alogai papiau Iesu kapaꞌina eifaniꞌi auga isapuga ipauma gamuga keoponia puo, ega pamalele eegai kekauai alogaina keopofua. ");
INSERT INTO mek_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ke Iesu egaꞌina laꞌafougai epamalele alogai, au agaꞌo alogai tiapolo apala eagu auga aiso gomegai eagaga einaka: ");
INSERT INTO mek_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ei! Iesu Nasareta aumu! Lau ke tiapolo maꞌoai alogo oi auga Alo Lolofa ipauma aumu, Deo eegai lomai. Kapa puo iina lomai? Kapaꞌina lai eemaisai mokapa looma? Oi lai moauokaimai ma looma?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kai Iesu egaꞌina auga alogai tiapolo eagu auga efinaisa einaka, “Komo mooma! Au egaꞌina alogai mopealai,” eoma. Ega aisama papiau maꞌoai agoꞌiai tiapolo egaꞌina auga eafiia afuai efounia kai alogai epealai. Kai egaꞌina auga faaga agaꞌo aepalifua. ");
INSERT INTO mek_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Papiau maꞌoai kapaꞌina emia keisa aisama, kekauai alogai keopofua, ifoꞌi mo epoꞌiai keifa keinaka, “Isa isapu ipauma, ke kapula ipauma auga! Isa tiapolo eifa kapula peniꞌi aisama, aina keafia papiau aloꞌiai kepealai. Iifa gome isa ega niniꞌani kapula ipauma!” keoma. ");
INSERT INTO mek_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Iesu egaꞌina ekapaisa auga fouga Kapenaum taonina eegai paguaꞌi maꞌoai aloꞌiai epea efoufaꞌa. ");
INSERT INTO mek_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu tiapolo epapealaisa afegai, Iudea papiauꞌi eꞌi laꞌafou afuga epuaꞌafuga. Ke egaꞌina kinagai mo elao au agaꞌo aka Saimon ega eꞌai ekoko. Egae Saimon gafa papiega auama isafaga akaikiꞌa eafiia puo, faaga ekiekie alogaina. Ega aisama Iesu kepalogo kepainia gapafelo keoma. ");
INSERT INTO mek_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ega puo Iesu Saimon gafa eega elao, mape kaina eapa, eaisopu penia kai ega isapuai isafa egaꞌina efinaisa gapealai eoma. Ega aisama egaꞌina isafaga papie epuaꞌafuga. Ke fiakoa mo papie eꞌuegekae foꞌama egakunia Iesu fou keagu auꞌi epeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Iesu egaꞌina ekapaiꞌi auga papiau maꞌo kelogo. Kai egaꞌina kina auga, Iudea papiauꞌi Deo keau afagaina kina puo, Iudea papiauꞌi keifa apua, kinai fakepea aisoge agoma fakelao keoma. Ega puo keagu egapigapi kina eake aisama, papiau isafa iꞌoiꞌi iꞌoiꞌi keafia auꞌi maꞌoai kemaiseiniꞌi Iesu eegai. Ega aisama Iesu papiau agaꞌo agaꞌo kaniaꞌiai ima eogeaua epafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ke Iesu papiau maꞌo aloꞌiai tiapolo keagu auꞌi isafa epafeloꞌi. Kai egaꞌina alogai tiapolo papiau aloꞌiai keagu auꞌi Iesu Mesaia auga kelogo puo, kepealai aisama keagaga keinaka, “Oi Deo Gauga!” keoma. Kai Iesu isa Mesaia auga papiau akelogo aisama, ega pinauga afaekapa felo eoma puo tiapolo efinaiꞌi, aelogoainiꞌi akeniniꞌani pugu. ");
INSERT INTO mek_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ke egani aisama Iesu gamegamega eoma puo taoni afe, afu oapuga elao. Egaꞌina alogai papiau isa kekapunia. Ke kemai isa emegamega afugai aisama, kegoi penia faepuaꞌafuniꞌi keoma. ");
INSERT INTO mek_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kai Iesu eifa einaka, “Deo anina eani taoni iꞌoiꞌi isafa falao, egae iifa faunina Isa ega agofaꞌa fouga fainogonia eoma. Ega kainai eulaisau lamai puo alalao paisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Iesu eifania koa iꞌopoga, ekailai Iudea ago fofouga epeaiꞌi. Egaꞌina alogai Iudea papiauꞌi eꞌi laꞌafou afuꞌiai ekoko einogo efai elaoaina. ");
INSERT INTO mek_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Egaꞌina afegai kina agaꞌogai Iesu Kenesaret aꞌuga keoma auga foegai eapa einogo. Ega aisama papiau maꞌo laꞌafouai Iesu keapa lofe, Deo ega iifa eifania auga aina kegalogo keoma puo, kepikoni kepiꞌifu Iesu eega kelao. ");
INSERT INTO mek_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Egaꞌina alogai Iesu inoino gaagaꞌi auniꞌi foeai kelaꞌauꞌi kai, inoino auꞌi auga feisai keapa eꞌi inoino feꞌiꞌi keikuiꞌi eisaꞌi. ");
INSERT INTO mek_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ega aisama elao au aka Saimon keoma auga ega gaagai eꞌagaukae eapa. Ke Saimon epainia gaaga ekonilaisa afaꞌagamo fei inaega koa elao. Egae kai gaagai eagukipo kai papiau einogoniꞌi ke epamaleleniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ke Iesu eniniꞌani efua aisama, Saimon epainia einaka, “Emu pinauga auꞌi fou gaaga amopapealaisa moaina alao kai, feꞌi amooge maꞌa amoafiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Kai Saimon iifa epamue einaka, “Au akaikiꞌa aumu, lai apinauga alogai gapiai ainoino gani kai kapa agaꞌo alaafia. Kai oi loifa kainai feꞌi agaoge,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ke kelao inafaꞌai aisama, Iesu eifania koa iꞌopoga mo kekapaisa, feꞌi keogeisa. Ega aisama maꞌa ealogai alogaina feꞌiai keofa. Egaꞌina alogai feꞌi kegalaꞌaua keoma aisama, feꞌi ufeꞌi keꞌina kemou. ");
INSERT INTO mek_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ega puo isa gaaga iꞌoina agaꞌo papiauꞌi fou kepinapinauga auꞌi kemai kegapalagainiꞌi auga gouga kekapaisa. Ke egaꞌina papiauꞌi kemai kepalagainiꞌi fou feꞌi kelaꞌaua aisama, gaaga auniꞌi kaiꞌialao akeꞌi epogu. Ega puo gaaga auniꞌi kaiꞌialao mo keꞌina kefufu. ");
INSERT INTO mek_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon, Peto keoma auga Iesu ega iifai mo maꞌa maꞌo keafiiꞌi auga eisa aisama, ekauai emaniꞌi alogaina. Ke Iesu agogai aꞌisaai eomukipo kai eifa einaka, “Lopia, lau laomai apala ikapa au: Mopuaꞌafuniau molao!” eoma. ");
INSERT INTO mek_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Gome isa ega pipalagai auꞌi fou maꞌa maꞌo keafiiꞌi auga keisa kekauai kemaniꞌi alogaina. ");
INSERT INTO mek_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ke Sebedi gauga James Ioane auniꞌi Peto fou kepinapinauga auꞌi isafa kekauai kemaniꞌi alogaina. Ega aisama Iesu Saimon epainia einaka, “Folomaniꞌi. Oi maꞌa lopaoa koa iꞌopoga, pau ke kina maꞌo alogai papiau maꞌo aloafiꞌi eeu alomaiseiniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ega aisama Peto, ke fou kepinapinauga keinoino auꞌi isafa eꞌi gaaga foeai kelaꞌauꞌi afegai, kapa maꞌoai kepuaꞌafuniꞌi, Iesu muninai kepea. ");
INSERT INTO mek_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Egaꞌina afegai Iesu taoni agaꞌogai eagu aisama, au molumolu isafaga eafia auga agaꞌo isa eega emai. Ke emai Iesu eisa aisama, eꞌualai aꞌisai eomukipo kai egoinia einaka, “Lopia, oi lau mopafeloisau alooma koa aisama, alopafeloisau,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ega puo Iesu ima ekalaisa elao au faagagai eafiau kai eifa einaka, “Lau lalogo oi mapafeloiso laoma. Ega puo felomu momia,” eoma. Iesu egaꞌina eifania aisama, fiakoa mo molumolu isafaga egaꞌina auga epuaꞌafuga, faaga felo emia. ");
INSERT INTO mek_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Egae kai Iesu au egaꞌina eifa kapula penia einaka, “Oi faagamuai kapaꞌina emia auga kai agaꞌo maagai foloifania. Kai opainai folao sakedote eeꞌiai faagamu fopakinaꞌi. Isa oi faagamu felo emia auga fekeisa, ke papiau maaꞌiai fekeifafoua. Egae kai oi faagamu efelo auga laoga maina Moses ega iifa kainai fokapa, aꞌo Deo fopaꞌa penia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Iesu au egaꞌina epainia kai agaꞌo maagai faeifania eoma mo ganinagai, au epafelo auga fouga afu maꞌoai epea efoufaꞌa papiau maꞌo kelogo. Ega kainai papiau maꞌo laꞌafouai Iesu ega inogo aꞌo fekelogo, ke isafa auꞌi fepafeloꞌi keoma puo eega kemai. ");
INSERT INTO mek_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kai kina isaꞌiai ekapakapa koa iꞌopoga, gamegamega eoma puo, egaꞌina papiauꞌi epuaꞌafuniꞌi afu oapuga elao emegamega. ");
INSERT INTO mek_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kina agaꞌogai Iesu eꞌa agaꞌo alogai eagu papiau epamaleleniꞌi. Egaꞌina alogai Kalilea ke Iudea ago paguaꞌi maꞌoai, ke Ierusaleme taoninai Faliseo ikupuga auꞌi, ke Moses ega iifa pamalelega auꞌi kemai Iesu epamelele aina kelogonia. Ega aisama Lopia Deo ega Isapu akaikiꞌa Iesu epeniia isafa papiauꞌi epafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Egaꞌina alogai au isaꞌi au agaꞌo faaga fofouga emelo auga kokoꞌeai kepuaisa kemai eꞌa alogai kegakokoaina Iesu agogai kegapakala auga keagaga kekapunia. ");
INSERT INTO mek_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kai papiau maꞌo kekaigugu puo, ala fekekokoai oma auga keagaga agaꞌo akeisa. Ega puo eꞌa ofaofagai keꞌagaukae kai, ine agaꞌo kekapaisa. Ke kokoꞌe kua ufeai kegopeapiꞌi kai, egaꞌina inegai melo auga laꞌafou ipuainagai Iesu ago ipaumagai kepaake eka. ");
INSERT INTO mek_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Iesu egaꞌina papiauꞌi maꞌoai isa au egaꞌina agepafelo auga aloꞌi koꞌagai kepakoꞌania eisa puo, melo auga epainia einaka, “Ekefaꞌau, lau oi emu laomai apalaꞌi laꞌagegeainiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Iesu ega eifa oma aisama, Faliseo auꞌi ke Moses ega iifa pamalelega auꞌi, egae keagu auꞌi ifoꞌi epoꞌiai keꞌina opolaꞌi kekapunia ke keifa keinaka, “Kai agaꞌo papiau eꞌi laomai apalaꞌi ageꞌagegeainiꞌi afaekaina. Deo mo papiau eꞌi laomai apalaꞌi ageꞌagegeainiꞌi agekaina. Iꞌina au kapa kai Deo koa iꞌopoga papiau eꞌi laomai apalaꞌi eꞌagegeainiꞌi eoma? Iifa gome, isa Deo eegai eifa apala,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu egaꞌina papiauꞌi kapaꞌina keopolaga ke keifania auga elogo puo epaꞌani peniꞌi einaka, “Kapa puo oi alomiai Deo mo papiau eꞌi laomai apalaꞌi ageꞌagegeainiꞌi, ke agekapa feloꞌi auga oopolaga? ");
INSERT INTO mek_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Niniꞌani auniꞌi epoꞌiai kapa auga mameꞌa foifania ooma: Emu laomai apalaꞌi laꞌagegeainiꞌi, o moꞌue emu ile moafia molao? Oi oopolaga lau egaꞌina auga ega laomai apalaꞌi laꞌagegeainiꞌi auga agoisa afaekaina ooma puo, niniꞌani mameꞌa mo laifania ooma? ");
INSERT INTO mek_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kai lau Papiau Aumauni Gauga, iifa gome agofaꞌai papiau eꞌi laomai apalaꞌi faꞌagegeainiꞌi, ke fapafeloꞌi isapuga kapa agaꞌo agomiai agoisa agekaina auga alakapa alapalogonimi,” eoma. Egae kai Iesu melo auga epainia einaka, “Lau lapainio, oi lofelo efua moꞌue emu kokoꞌe moafia emu eꞌa molao,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ega aisama au egaꞌina fiakoa mo papiau agoꞌiai eꞌue, ekauau kokoꞌega eafiia, efelo alogama epaꞌaua, Deo eau afagaina elaoaina, elao mo ega eꞌa. ");
INSERT INTO mek_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Egae keagu papiauꞌi maꞌoai au egaꞌina efelo keisa aisama, kekauai alogaina, ke Deo keau afagaina. Ke Iesu isapu akaikiꞌagai eifa mo au efelo puo, kemaniꞌi alogaina keifa keinaka, “Lai kapa akaikiꞌa ipauma alaisaisa auga pau aisa!” keoma. ");
INSERT INTO mek_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Egaꞌina afegai Iesu eꞌa egaꞌina epuaꞌafuga elao Iudea auga agaꞌo aka Lefi, Roma kamanina papagai epinauga auga tax keogeoge eꞌa eꞌelegai eagu epinauga eisa. Ega aisama epainia einaka, “Lau muniuai mopea,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ke fiakoa mo Lefi eꞌue ega pinauga amuꞌi maꞌoai epuaꞌafuniꞌi Iesu muninai epea. ");
INSERT INTO mek_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Egae kai Iesu Lefi eifaga auga alogama epaꞌaua puo, ega eꞌai Iesu faugai miamia akaikiꞌa ekapaisa. Ke Lefi koa iꞌopoga, papiau imaꞌiai tax keafia auꞌi maꞌo laꞌafouai kemai. Ke tax keafia auꞌi koa iꞌopoꞌi laomai apalaꞌi kekapaꞌi auꞌi isafa kemai Iesu fou keagu keaniani. ");
INSERT INTO mek_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kai egaꞌina alogai, Faliseo ikupuga Moses ega iifa pamalelega auꞌi, ke Faliseo ikupuga papiauꞌi fou Iesu kapaꞌina ekapa auga kegaisa keoma puo kemai. Kai Iesu tax keafia auꞌi, ke isa koa iꞌopoꞌi laomai apalaꞌi kekapaꞌi auꞌi fou keaniani auga keisa aisama, kemai Iesu ega imoi fou ega kekapa oma auga anina akeani puo, kepaakekuaniꞌi keinaka, “Iꞌina papiauꞌi tax keafia auꞌi, ke isa koa iꞌopoꞌi laomai apalaꞌi kekapaꞌi. Kai kapa puo isa fou oaniani?” keoma. ");
INSERT INTO mek_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Kai Iesu isa ainaꞌi elogonia puo, eꞌi iifa epamue einaka, “Papiau feloꞌi akeisafa auꞌi toketa eega afakelao kai, keisafa auꞌi mo toketa eega kelao. ");
INSERT INTO mek_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ega koa iꞌopoga, lau lamai auga papiau Deo maagai alo opai auꞌi faifaniꞌi puo alamai. Kai Deo maagai laomai apalaꞌi kekapaꞌi auꞌi faifaniꞌi eꞌi apala fekeumakalainiꞌi, Deo fekeaipenia laoma puo lamai,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Egae kai Faliseo auꞌi ke pamalele auꞌi egaꞌina Iesu kepainia keinaka, “Ioane ega imoi auꞌi keani gopegope ke kemegamega aefuafua. Ke ega koa iꞌopoga mo, Faliseo ikupuga auꞌi eꞌi kagakaga aloꞌi koꞌagai muninai kepea auꞌi isafa keani gopegope ke kemegamega aefuafua. Kai oi emu imoi auꞌi akeani gopegope kai keaniani aage mo,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ega aisama Iesu isa eꞌi iifa afa palapoleai epamue einaka, “Papiau amage mamaga auga ega miamia kemai auꞌi, isa fou keagu aisama, akeani gopegope agekaina ma? Laaꞌi, afaekaina! Kai amage mamaga auga isa agepuaꞌafuniꞌi afegai aisama kai, akeani gopegope agekaina. ");
INSERT INTO mek_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ega koa iꞌopoga, lau auga amage mamaga au koa iꞌopou. Ega puo lau eꞌu imoi fou aague alogai akeani gopegope afaekaina. Kai kina agaꞌo agemai Deo lau ageafiau agelaoainiau puo lau isa alapuaꞌafuniꞌi aisama, egaꞌina kinaꞌiai kai, isa akeani gopegope agekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Egae kai Iesu palapole agaꞌo maaꞌiai eifania einaka, “Kai agaꞌo afe mamaga aeꞌiꞌina aeafia, tiapu ufainagai aekaiapia. Kai isa tiapu mamaga aina ageafia ufainagai agekaiapia koa aisama, tiapu ufaina mamaga fou akeogefoua auga iisa apala agemia. Ke egaꞌina mo laaꞌi kai, tiapu mamaga ageꞌiꞌina puo, tiapu mamaga egaꞌina agepalifua. ");
INSERT INTO mek_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ke kai agaꞌo fino mamaga aeafia fino kepapaꞌefauka pute ufainagai aepaꞌefauka. Kai isa fino mamaga ageafia egaꞌina pute ufainagai agepaꞌefauka koa aisama, fino mamaga pute ufaina efugugu puo ageauꞌiꞌina agepalifua. Ke fino isafa agefaka. ");
INSERT INTO mek_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ega kainai fino mamaga auga fino pute mamagai fouka, ega koa auniꞌi kaiꞌialao afakelifu. ");
INSERT INTO mek_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kai papiau maꞌoai kelogo fino ufaina gamuga felo puo, fino ufaina keinu auꞌi fino mamaga anina afakeani afakeinu. Ega koa iꞌopoga, papiau kagakaga ufaina anina keani auꞌi, lau eꞌu laomai mamaga auga anina afakeani,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Iudea papiauꞌi Deo keau afagaina kina agaꞌogai, Iesu ega imoi fou palafa kefauga agogai peapea afugai kepea pagai. Egaꞌina alogai Iesu ega imoi palafa puaga isa auꞌaagai kefaiponiꞌi keafiiꞌi imaꞌiai kemukuniꞌi faagaꞌi kepealai kai aniꞌi keaniiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ega aisama Faliseo auꞌi isa kepainiꞌi keinaka, “Kapa puo Deo aau afagaina kinagai Moses ega iifa kainai keifa apua auga okapa?” keoma. ");
INSERT INTO mek_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ega aisama Iesu Faliseo auꞌi epainiꞌi einaka, “Ufainagai Davide ega au fou inaeꞌi ekimu aisama, kapaꞌina ekapaisa auga fouga Deo ega iifa pukagai alokuapina ma? ");
INSERT INTO mek_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Isa Deo ega eꞌai ekoko palafa Deo kepalao penia, Moses ega iifa kainai keifa apua, sakedote mo fekeania keoma auga eafiia eaniia. Ke afa ega au auꞌi isafa epeniiꞌi keaniia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ke Iesu Faliseo auꞌi epainiꞌi pugu einaka, “Moses ega iifa kainai keifa apua ganinagai kai, Davide faagagai kapa agaꞌo aemia. Ke ega koa aisama, lau Papiau Aumauni Gauga, Deo keau afagaina kina auga Lopiaga au. Ega puo eꞌu imoi kapaꞌina kekapaisa auga lau mo faniniꞌani,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Iudea papiauꞌi Deo keau afagaina kina agaꞌo emai pugu aisama, Iesu elao Iudea papiauꞌi eꞌi laꞌafou afugai ekoko epamalele. Ega aisama au agaꞌo ima kaina emelo auga isafa egae eagu, Iesu aina elogonia. ");
INSERT INTO mek_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Egaꞌina alogai Faliseo auꞌi ke Moses ega iifa pamalelega auꞌi isafa egae keagu Iesu fekepaagu fofoua auga keagaga kekapunia. Ega kainai egaꞌina kinagai aufalao agaꞌo afepafelo koa aisama, fekeisa keoma. Ke aloꞌi koꞌagai keagu keagouka. ");
INSERT INTO mek_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kai Iesu isa kapaꞌina keopolaga auga elogo puo, ima melo auga epainia einaka, “Moꞌuegekae papiau maꞌoai agoꞌiai moapa,” eoma. Ega puo au egaꞌina eꞌuegekae eapa. ");
INSERT INTO mek_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Egae kai Iesu Faliseo auꞌi ke Moses ega iifa pamalelega auꞌi epainiꞌi einaka, “Lau oi lapaꞌani penimi. Deo keau afagaina kinagai Moses ega iifa kainai, kapaꞌina fakapa auga keifa apua: Felo fakapa o apala fakapa? Ke papiau kaniaꞌi faagamauga, o eꞌi agu fapalifua?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iesu egaꞌina eifania afegai, maaga egoaisa maꞌoai eisaꞌi. Ke ima melo auga epainia einaka, “Imamu mokalaisa,” eoma. Ke au egaꞌina ima ekalaisa aisama, ima felo ipauma emia. ");
INSERT INTO mek_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kai Faliseo auꞌi ke pamalele auꞌi Iesu ega koa ekapaisa keisa aisama, guaꞌi ekupu alogaina puo, keꞌina ifoꞌi epoꞌiai Iesu faagagai kapaꞌina fekekapa auga ninina keꞌaninia. ");
INSERT INTO mek_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Egaꞌina alogai kina agaꞌogai, Iesu gamegamega eoma puo elao ikuai. Ke egae gapi fofouga Deo emegamega penia. ");
INSERT INTO mek_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Egani aisama Iesu ega imoi maꞌoai eifaniꞌi kemai. Ke kemai aisama, epoꞌiai auꞌi 12 mo ekinaniꞌi, epafaalaꞌi apostolo eomaiꞌi, ke aekinaniꞌi auꞌi keake iku papagai isa keꞌimaiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Egaꞌina auꞌi 12 ekinaniꞌi auꞌi akaꞌi inamoꞌe: Saimon, Iesu epafaala Peto eoma auga, ke akina Andru fou. James, Ioane, Filip, Batolomeo. ");
INSERT INTO mek_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomas, James Alfeus gauga, Saimon Silot ikupuga auga. ");
INSERT INTO mek_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas James gauga, ke Judas Iskariot, Iesu eꞌafaꞌafalaina auga. ");
INSERT INTO mek_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Egaꞌina afegai Iesu ega apostolo 12 fou ikuai keake kelao afu falapagai. Egaꞌina afugai Iesu ega imoi iꞌoiꞌi isafa maꞌoai egae keapa. Ke Iudea ago fofouga papiauꞌi, Ierusaleme taonina papiauꞌi, ke Taire, Sidoni taoniꞌi niegai, foeai keagu papiauꞌi maꞌoai isafa kemai, laꞌafou akaikiꞌa ipauma egaꞌina alogai keapa. ");
INSERT INTO mek_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Egaꞌina papiauꞌi Iesu aina kegalogo, ke eꞌi isafa gapafeloꞌi keoma puo kemai. Ke tiapolo apalaꞌi papiau kepalifuꞌi auꞌi isafa kemai aisama epafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ke papiau Iesu faagagai isapu epealai isafa papiauꞌi epafeloꞌi auga keisa puo, maꞌoai kelao faaga kegaafi opogaina keoma. ");
INSERT INTO mek_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Egaꞌina alogai Iesu ega apostolo 12, ke ega imoi isaꞌi auꞌi maꞌoai fou eaipeniꞌi ke epainiꞌi einaka: “Ulalu aumi, Deo eegai kapa feloꞌi oafiꞌi, gome Deo ega agofaꞌa oi apumi. ");
INSERT INTO mek_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Inaemi ekimu aumi, Deo eegai kapa feloꞌi oafiꞌi, gome Deo inaemi agepapogua. Oapepe aumi, Deo eegai kapa feloꞌi oafiꞌi, gome muni agoaꞌa. ");
INSERT INTO mek_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Papiau Aumauni Gauga puogai papiau oi animi afakeani eeꞌiai akepapealaimi, akeifa apala penimi, ke akami apala akepamia akeumakalainimi aumi, Deo eegai kapa feloꞌi oafiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Egaꞌina kina agemai aisama, afa akaikiꞌa ipauma ufai agoafia. Ega puo alomi fegama, alogamai fogopo aisoge. Egaꞌina papiauꞌi ufuꞌi apaꞌi ega koa iꞌopoga mo Deo ega profeta faagaꞌiai kekapaisa. ");
INSERT INTO mek_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kai paꞌamuꞌamu aumi, Deo emi laomai apalaꞌi ipaumaꞌi afa agepenimi, gome oi kapa feloꞌi maꞌo pau oafi umaniꞌi mo. ");
INSERT INTO mek_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Pau oanipugu aumi, muni inaemi agekimu, gome Deo emi laomai apalaꞌi ipaumaꞌi afa agepenimi. Pau oaꞌa aumi, muni agoapepe agonioniolainimi, gome Deo emi laomai apalaꞌi ipaumaꞌi afa agepenimi. ");
INSERT INTO mek_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Papiau maꞌoai pau keifagainimi aumi, Deo emi laomai apalaꞌi ipaumaꞌi afa agepenimi, gome oi keifagainimi auꞌi ufuꞌi apaꞌi ega koa iꞌopoga mo, profeta pifogeꞌi ega keifagai omaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ke Iesu eifa pugu einaka, “Ke pau kai mo ainau ologo aumi lapainimi: Alomi koꞌagai emi ou auꞌi aniꞌi foani, ke papiau kapaꞌi aloꞌi koꞌagai animi akeani auꞌi eeꞌiai felo fokapa. ");
INSERT INTO mek_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ke papiau keifa apala penimi Deo afa apala fepenimi keoma auꞌi eeꞌiai Deo ega gafegafe agepeniꞌi auga maaꞌiai foifania. Ke keafi lilifunimi auꞌi fauꞌiai fomegamega. ");
INSERT INTO mek_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ke aufalao agaꞌo meꞌemu agepoa koa aisama, apie foailao meꞌemu apie isafa fepoa. Ke aufalao agaꞌo afemu tiapuga afeafia koa aisama, alogai loiꞌiuka tiapuga isafa folopoiseina feafia. ");
INSERT INTO mek_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ke papiau maꞌoai kapaꞌina eemiai akegoina auꞌi fopeniꞌi. Ke aufalao agaꞌo emi kapa afeafia koa aisama, foloifa kapula penia faepeni mueimi pugu. ");
INSERT INTO mek_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Papiau oi faagamiai kapaꞌina fekekapa ooma auga, oi isafa ega koa isa faagaꞌiai fokapa. ");
INSERT INTO mek_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Papiau aloꞌi koꞌagai oi animi keani auꞌi mo aniꞌi agoani koa aisama, kapa felo agaꞌo eemiai femia auga opolaga foloafia. Gome laomai apala kekapaꞌi auꞌi isafa, kaisau isa aloꞌi koꞌagai aniꞌi keani auꞌi isafa aniꞌi keani. ");
INSERT INTO mek_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ke papiau eemiai laomai felo kekapa auꞌi mo eeꞌiai laomai felo agokapa koa aisama, kapa felo agaꞌo eemiai femia auga opolaga foloafia. Gome laomai apala kekapa auꞌi isafa, kaisau isa eeꞌiai laomai felo kekapa aisama, isa isafa egaꞌina papiauꞌi eeꞌiai laomai felo kekapa. ");
INSERT INTO mek_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ke oi aufalao agaꞌo emi pipeni afa agepenimueimi mo auga amu openia koa aisama, kapa felo agaꞌo eemiai femia auga opolaga foloafia. Gome laomai apala kekapa auꞌi isafa aufalao agaꞌo amu kepenia aisama, anina keani afa fofouga fekeafimue keoma. ");
INSERT INTO mek_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kai oi alomi koꞌagai emi ou auꞌi aniꞌi foani, ke eeꞌiai laomai felo mo fokapa. Ke kapa agaꞌo agopeniꞌi aisama, isa oi imami afa fekeoge fekepenimueimi auga opolaga foloafia. Ega agokapa oma koa aisama, muni Deo eegai afa akaikiꞌa ipauma agoafia, ke Deo ufai auꞌoniai eague auga gauga agomia. Gome Isa kapa agaꞌo aufalao agaꞌo epenia kai tenkiu aepenia, ke laomai apala ekapa mo ganinagai, Isa gafegafe akaikiꞌa ipauma auga puo, egaꞌina papiauga eegai egafegafe. ");
INSERT INTO mek_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ke Oi Amami Deo guami eania koa iꞌopoga, oi isafa ega koa fokapa papiau guaꞌi foania,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","38","Ke Iesu eifa pugu einaka, “Papiau kapa agaꞌo kekapa aisama, oi alomiai felo o apala folooma. Ega koa oi papiau eꞌi laomai felo o apala afa afolopeniꞌi koa aisama, Deo isafa oi emi laomai felo o apala auga afa afaepenimi. Ke papiau kapa agaꞌo kekapa aisama, oi egaꞌina papiauꞌi eeꞌiai foloifa apala. Ega koa oi papiau eꞌi laomai eeꞌiai afoloifa apala koa aisama, Deo isafa oi emi laomai eeꞌiai afaeifa apala. Kai papiau eemiai laomai apalaꞌi akekapaꞌi koa aisama, oi isa eꞌi laomai apala foꞌagegeainiꞌi. Ega agokapa oma aisama, Deo kapa feloꞌi maꞌo paisa agepenimi, ke maꞌo eemiai kekae mo ganinagai, maꞌo mo laagai ageogeauꞌi agepenimi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesu egaꞌina eifania efua aisama, iꞌina palapole maaꞌiai eifania einaka, “Oi oopolaga maakimiꞌi auga agaꞌo maakimiꞌi mo auga agepapea agekaina ma ooma? Laaꞌi, afaekaina! Maakimiꞌi auga agaꞌo maakimiꞌi mo auga agepapea koa aisama, auniꞌi kaiꞌialao ipuai akeꞌualai. ");
INSERT INTO mek_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ega koa iꞌopoga mo, malele imoina pamalele auga agekaꞌegaina afaekaina. Kai isa ega malele agepafua koa aisama, pamalele auga fou iꞌopoꞌi mo akemia. ");
INSERT INTO mek_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Oi ifomi maamiai au uꞌufa akaikiꞌa ekae maami ekaisapua auga aloisa kai, kapa puo aami akimi maaꞌiai amaꞌama eꞌele ipauma ekae auga oisa ooma? ");
INSERT INTO mek_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Oi maamiai au uꞌufa akaikiꞌa ekae maami ekaisapua auga aloisa felo kai, ala koa aami akimi opainiꞌi oinaka, ‘Aau o akiu, maamiai amaꞌama eꞌeleꞌi maafilaiꞌi’ ooma. Pifoge aumi, afaekaina! Oi foufai ifomi maamiai au uꞌufa akaikiꞌa ekae auga foafilai kakaua. Egae kai maami ofakaegai, aami akimi maaꞌiai amaꞌama eꞌele ipauma ekae auga agoafilaisa agekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Iesu eifa pugu einaka, “Au felo auga puaga apala aeoge. Ega koa iꞌopoga au apala isafa puaga felo aeoge. ");
INSERT INTO mek_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Au kapa felo o apala auga puagai kekapulaisa. Papiau ini gufugai au aka ‘fik’ puaga afakeafia. Ke papiau ini gufugai isafa aupua puaga afakeafia. ");
INSERT INTO mek_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Au felo auga gua alogai kapa feloꞌi keka auꞌi, feloꞌi mo akegai kepealai eifaniꞌi. Ega koa iꞌopoga, au apala auga gua alogai kapa apalaꞌi kekae auꞌi, apalaꞌi mo akegai kepealai eifaniꞌi. Gome papiau guaꞌi alogai kapaꞌina epogu auga akeꞌiai epealai keifania.” ");
INSERT INTO mek_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ke Iesu eifa pugu einaka, “Kapa puo oifaniau, ‘Lopia, Lopia,’ ooma kai, kapaꞌina laifania auga alokapa? ");
INSERT INTO mek_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kaisau mo lau eeu kemai ainau kelogo, ke kainai kepea auꞌi fouꞌi maamiai alaifania. ");
INSERT INTO mek_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Egaꞌina auꞌi auga, eꞌa ipaapa auga agaꞌo fopa eapiia eake alogaina, uuꞌu efaunia, eꞌa epaapa koa iꞌopoga. Ega kainai kou emai aisama, pugepuge akaikiꞌa eꞌa eauniia kai, eꞌa ekapa felo puo aepiu aelao aemai. ");
INSERT INTO mek_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kai kaisau ainau kelogo kai kainai akepea auꞌi auga, eꞌa ipaapa auga uuꞌu laaꞌi kai aꞌisaai mo eꞌa epaapa auga koa iꞌopoga. Ke kou emai pugepuge akaikiꞌa eꞌa eauniia aisama, epoi eauoka afeꞌaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iesu iꞌina iifaꞌi maꞌoai papiau fekelogo eoma maaꞌiai eifania efua aisama, epuaꞌafuniꞌi elao Kapenaum taoninai ekoko. ");
INSERT INTO mek_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ega aisama egae Roma ifani auꞌi 100 eꞌimaꞌi lopiaga alo koꞌagai ega kalaꞌafi agaꞌo anina eani auga eisafa emia femae. ");
INSERT INTO mek_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Egaꞌina lopiaga Iesu emai auga fouga elogo puo, Iudea au akaikiꞌa auꞌi isaꞌi feulaiꞌi, Iesu eega fekelao fekegoina femai ega kalaꞌafi fepafelo eoma. ");
INSERT INTO mek_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ke egaꞌina auꞌi Iesu eega kelao aisama, kegoi kapulania keifa keinaka, “Iꞌina auga faagagai egaꞌina alokapa auga felo ipauma. Ke isa au felo puo, fou falao ega kalaꞌafi fopafelo aoma. ");
INSERT INTO mek_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Gome isa alo koꞌagai iꞌa aꞌa ago anina eani, ke iꞌa aꞌa laꞌafou afuga epaapa,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ega puo Iesu isa fou kelao. Ke Iesu elao Roma lopiaga ega eꞌa kainagai aisama, egaꞌina lopiaga ega iifa ekefaꞌa epeniiꞌi eulaiꞌi Iesu kegapaina eoma. Ke isa kemai Iesu maagai egaꞌina lopiaga ega iifa keifania keinaka, “Lopia, oi fomai lau eꞌu eꞌa alogai fokoko auga laopolaga afaekaina. Gome lau au eꞌeleu. ");
INSERT INTO mek_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Egaꞌina kainai lau ifou famai faisao mo auga laopolaga aekainia. Kai moifa mo eꞌu kalaꞌafi felo gamia. ");
INSERT INTO mek_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gome lau ifou isafa eꞌu lopia akaikiꞌaꞌi papaꞌiai lapinauga, ke eꞌu ifani auꞌi isafa lau papauai kepinauga. Lau iꞌina auga agaꞌo lapaina ‘molao’ laoma aisama elao. Ke agaꞌo lapaina ‘mai’ laoma aisama emai. Ke eꞌu kalaꞌafi auga lapaina ‘iꞌina mokapa’ laoma aisama ekapa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iesu egaꞌina iifaga aꞌo elogonia aisama, ekauai alogaina ke eꞌafoaipini muninai laꞌafou akaikiꞌa kepea auꞌi epainiꞌi einaka, “Iifa gome maamiai laifania. Israel papiauꞌi mo ganinagai epoꞌiai kai agaꞌo iina epakoꞌa omaisau alaisa koa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Egae kai Iesu egaꞌina lopiaga ekefaꞌa auꞌi eulaiꞌi kemue kelao. Ke kelao eꞌai aisama, egaꞌina lopiaga ega kalaꞌafi felo emia keisa. ");
INSERT INTO mek_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Egaꞌina afegai mo, Iesu taoni agaꞌo aka Nain keoma auga taonina elao. Ega aisama ega imoi maꞌoai ke laꞌafou akaikiꞌa fou kelao. ");
INSERT INTO mek_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ke kelao taoni paꞌafina eegai aisama, papiau mae auga agaꞌo kepuaisa kemai. Mae egaꞌina auga afuafu gauga, ega mo agaꞌomo kai emae. Ke mae egaꞌina muninai afuafu egaꞌina laꞌafou akaikiꞌa fou kepea. ");
INSERT INTO mek_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Lopia Iesu afuafu egaꞌina eisa aisama, gua eani alogaina, ke elao epainia einaka, “Foloapepe,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Egae kai Iesu elao mae kofugai eafiau aisama, papiau mae kepua auꞌi keapakipo. Ega aisama Iesu mae auga epainia einaka, “Au aguꞌamu! Lapainio moꞌue,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ega aisama mae auga eꞌue eagu, eꞌina eniniꞌani pugu. Ke Iesu au aguꞌa emaunimue auga imagai eafi ina epenimue. ");
INSERT INTO mek_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Egae keapa papiauꞌi maꞌoai iꞌina emia keisa aisama, kemaniꞌi alogaina, ke Deo keau afagaina keifa keinaka, “Lai Deo ega profeta akaikiꞌa emai epomaisai,” keoma. Ke keifa pugu keinaka, “Deo ega papiau gapalagainiꞌi eoma puo emai,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ke Iesu au epamaunimue auga fouga Iudea ago fofouga, ke Iudea ago eegai agoꞌiai isafa efoufaꞌa. ");
INSERT INTO mek_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ioane ega imoi iꞌina aꞌo kelogonia aisama, kelao Ioane Baptista maagai Iesu kapaꞌina ekapaiꞌi auga maꞌoai keifania. Ega aisama Ioane ega imoi auniꞌi eifaniꞌi kemai. ");
INSERT INTO mek_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ke eulaiꞌi kelao Iesu iina fekepaꞌani peni oma eoma, “Au agaꞌo agemai auga oi ma? O aufalao agaꞌo iꞌoina ma faꞌima?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ke iꞌina auꞌi kemai Iesu eegai aisama, kepainia keinaka, “Ioane Baptista eulaimai oi fapaꞌani penio eoma puo amai. Ioane eifa, ‘Au agaꞌo agemai auga oi ma? O aufalao iꞌoina agaꞌo ma faꞌima?’” keoma. ");
INSERT INTO mek_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ke kepaꞌani penia alogai, Iesu auga isafa eꞌeleꞌi auꞌi, isafa akaikiꞌa auꞌi, ke tiapolo apalaꞌi aloꞌiai keagu auꞌi epafeloꞌi. Ke maakimiꞌi auꞌi isafa epafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ega puo Iesu Ioane Baptista ega imoi eꞌi iifa epamue einaka, “Maakimiꞌi auꞌi amu keisaꞌi pugu, melo auꞌi kepea, molumolu auꞌi feloꞌi kemia, ainaꞌi efua auꞌi aꞌoaꞌo kelogo, mae auꞌi kemaunimue, ke ulalu auꞌi iifa faunina aꞌo kelogo. Pau oi fomue folao Ioane Baptista maagai kapaꞌina oisa ke aꞌo ologonia auga foifania. ");
INSERT INTO mek_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ke foifa, ‘Kaisau lau epakoꞌaniau ke opo gua aemia auga Deo eegai kapa feloꞌi ageafiꞌi fooma,’” eoma. ");
INSERT INTO mek_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ioane Baptista ega imoi kemue kelao afegai, Iesu Ioane Baptista fouga laꞌafou maaꞌiai eꞌina eifa einaka, “Kapaꞌina foisa ooma puo Ioane eagu afuga ago maini olao? Ameku inipo epua foisa ooma puo olao ma? ");
INSERT INTO mek_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Egaꞌina laaꞌi aisama, kapaꞌina foisa ooma puo olao? Au afe tiapuga felo eiꞌiuka foisa ooma puo olao ma? Laaꞌi ipauma! Tiapu afa akaikiꞌa keiꞌiuka auꞌi, ke aufa kina keagu felo alogaina auꞌi auga, kin eaguagu eꞌagai keagu. ");
INSERT INTO mek_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kai kapaꞌina foisa ooma puo opealai olao? Profeta agaꞌo foisa ooma puo olao ma? E, iifa gome maamiai laifania, Ioane auga profeta maꞌoai ekaꞌegainiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ega kainai isa fouga Deo iifa ega pukagai iina kepapua oma: “‘Lau eꞌu iifa ipapea auga oi agomuai alaulai kakaua, emu keaga agepakaisa.’ ");
INSERT INTO mek_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iifa gome maamiai laifania. Papiau maꞌoai papie guaꞌiai kemauni auꞌi epoꞌiai kai agaꞌo Ioane Baptista ega akaikiꞌa koa iꞌopoga laaꞌi. Kai Ioane Baptista, Deo ega agofaꞌai au eꞌele ipauma agaꞌo aekaꞌegaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Papiau tax keafiꞌi auꞌi isafa, Ioane baptismo epeniꞌi auꞌi maꞌoai Iesu ega niniꞌani aꞌo kelogonia aisama, Deo ega keaga opaina ipauma auga kepakoꞌania, ke koꞌa keoma. ");
INSERT INTO mek_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kai Faliseo auꞌi ke Moses ega iifa pamalelega auꞌi fou, Ioane eegai baptismo kepamafua akeafia auꞌi, isa fauꞌiai Deo ega logo ekapaisa auga keumakalaina. ");
INSERT INTO mek_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iesu kapaꞌina eifania auga aina akeafia puo eifa einaka, “Iꞌina papiauꞌi kapaꞌina koa fou alaogeꞌopoꞌi agekaina? Isa kaisau koa iꞌopoꞌi? ");
INSERT INTO mek_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Isa imoi eꞌeleꞌi koa iꞌopoꞌi, afaꞌafa afugai keagu ke ifoꞌi epoꞌiai iina keifa oma: “‘Lai oi faumiai filiko apaꞌopuania kai alogefa, ke lai alomafu iifina aifinia kai aloapepe.’ ");
INSERT INTO mek_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Egaꞌina iifaga koa iꞌopoga, oi kapa agaꞌo faagamiai emia kai kainai alokai. Ke oi emi laomai ega koa kainai, Ioane Baptista emai alogai palafa aeania ke fino aeinu aisama, oi oifa, ‘Isa alogai tiapolo eague’ ooma. ");
INSERT INTO mek_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kai Papiau Aumauni Gauga emai alogai, eaniani ke fino einu aisama, oi oifa, ‘Amoisa, isa eaniani mogemoge, einuinu alogaina, laomai apalaꞌi kekapa auꞌi epoꞌiai tax keafia auꞌi isafa fou kepaekefaꞌa kelao kemai’ ooma. ");
INSERT INTO mek_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kai pau lau lapainimi. Kaisau Deo aina keafia ke muninai kepea auꞌi mo ega ikifa epakinaꞌi.” ");
INSERT INTO mek_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kai Faliseo auga agaꞌo aka Saimon, Iesu eifa koko ega eꞌai fou fekeaniani eoma. Ega puo Iesu ega imoi fou Faliseo auga egaꞌina ega eꞌa kelao keagukipo kegaaniani keoma. ");
INSERT INTO mek_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ega aisama papie agaꞌo egaꞌina taoninai laomai apalagai eaguagu auga, Iesu Saimon ega eꞌai fou keaniani auga elogo. Ega puo isa mulamula foga felo ipauma kafapuga eafiia elao. ");
INSERT INTO mek_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ekoko aisama, Iesu muninai eapa ife foꞌinai eomukipo eapepe, ke eꞌina maaga iugai Iesu ife epafeisa. Egae kai fufugai Iesu ife epaigu fugania, ke ife egoapiꞌi, ke mulamula foga felo ipaumagai ife eꞌefaiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Faliseo auga egaꞌina Iesu eifa koko auga, papie egaꞌina ega koa ekapaisa eisa aisama, ifo alogai eifa einaka, ‘Iꞌina auga profeta koꞌa gamia koa aisama, kaisau isa faaga eafi opogaina auga felogo. Ke papie laomai apala ipauma ekapakapa auga isafa felogo,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iesu Faliseo auga egaꞌina kapaꞌina eopolaga auga elogo puo epainia einaka, “Saimon, kapa agaꞌo maamuai maifania laoma,” eoma. Ke Saimon eifa einaka, “Pamalele aumu, maauai moifania,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ega puo Iesu eifa einaka, “Au agaꞌo moni eegai keapiapitoleaina auga eegai au auniꞌi moni keapitoleaina. Au agaꞌo 500 denari eapitoleaina ke agaꞌo auga 50 denari eapitoleaina. ");
INSERT INTO mek_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ke auniꞌi kaiꞌialao moni fekepenimue auga aekainia. Ega puo eꞌi apitole eaꞌiniꞌi. Ega koa aisama, egaꞌina auꞌi auniꞌi epoꞌiai kaisau auga alo koꞌagai moni eegai keapitoleaina auga anina ageani alogaina. Oi moopolaga moifania,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon iifa epamue einaka, “Laopolaga, moni akaikiꞌa eapitoleaina auga,” eoma. Ke Iesu eifa pugu einaka, “Oi opolamu felo,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ke Iesu egaꞌina papiega eaipenia kai Saimon epainia pugu einaka, “Iꞌina papiega loisa. Lau oi emu eꞌa alogai lakoko aisama, kagakaga kainai ifeu foikua feina agaꞌo fopeniau koa iꞌopoga kai alopeniau. Kai isa emai aisama, maaga iugai ifeu epafeiꞌi ke fufugai epaigu fugania. ");
INSERT INTO mek_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Lau lamai aisama, kagakaga kainai foogoapiau kai alogoapiau. Kai iꞌina papiega eeu emai aisama, gaifa kokoisau eoma puo ifeu egoapia aeapakipo. ");
INSERT INTO mek_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Lau lamai aisama, kagakaga kainai au akaikiꞌau fopamiaisau oili kaniauai fooge kai aloogeisa. Kai isa mulamula foga felo ipaumagai ifeu eꞌefaisa. ");
INSERT INTO mek_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ega puo iifa gome maamuai laifania. Deo kaisau ega laomai apalaꞌi maꞌo eꞌagegeainiꞌi aisama, isa auga Deo anina eani alogaina. Kai Deo kaisau ega laomai apala eꞌeleꞌi mo eꞌagegeainiꞌi aisama, isa Deo afaꞌagamo anina eani. Deo iꞌina papiega ega laomai apalaꞌi maꞌo eꞌagegeainiꞌi puo, alo koꞌagai aniu eani auga papiau epakinaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Egae kai Iesu egaꞌina papiega epainia einaka, “Deo emu laomai apalaꞌi eꞌagegeainiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ega aisama Saimon papiau eifa kokoꞌi auꞌi ifoꞌi epoꞌiai keꞌina keifa keinaka, ‘Deo mo laomai apalaꞌi eꞌagegeainiꞌi kai, isa isafa papiau eꞌi laomai apalaꞌi eꞌagegeainiꞌi eoma. Iꞌina auga kaisau?’ keoma. ");
INSERT INTO mek_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kai Iesu egaꞌina papiega epainia einaka, “Oi lopakoꞌaniau puo Deo emu laomai apalaꞌi eꞌagegeainiꞌi, ke kaniamu eagamauga. Gagaoai molao,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Egaꞌina afegai Iesu taoni agaꞌo agaꞌo, ke pagua agaꞌo agaꞌo fou aloꞌiai ekoko iifa faunina Deo ega agofaꞌa fouga papiau maaꞌiai einogo ke eifafoua. Egaꞌina alogai ega imoi 12 isa fou kelao. ");
INSERT INTO mek_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ke papie isaꞌi aloꞌiai tiapolo apalaꞌi epapealaiꞌi, ke keisafa epafeloꞌi auꞌi isafa isa fou kelao. Egaꞌina papieꞌi epoꞌiai Maria Makdalena keoma, alogai tiapolo imagea gua epapealaiꞌi auga. ");
INSERT INTO mek_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ke Kusa, Herod ega eꞌa iꞌima kaniagai auga akafa aka Ioanna auga. Ke Susanna, ke papie maꞌo isaꞌi isafa Iesu fou kelao. Iꞌina papieꞌi ifoꞌi eꞌi amu moni fou keafiiꞌi Iesu ke ega imoi fou kepeniiꞌi kepapinauganiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ke taoni maꞌoai papiauꞌi Iesu eega kemai laꞌafou akaikiꞌa emia aisama, iꞌina palapole maaꞌiai eifania einaka: ");
INSERT INTO mek_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Au oga efauga auga agaꞌo au ogaꞌi gafauniꞌi eoma puo, epealai elao ega umai. Ke au oga eꞌafokaꞌi alogai, isaꞌi paisoai peapea afugai keꞌualai. Ke papiau au ogaꞌi egaꞌina auꞌi isaꞌi laaꞌiai kepea, ke isaꞌi auga ufa ineiꞌi keake keaniiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ke isaꞌi auga fopa laagai aꞌisa afaꞌagamo eka auga laagai keꞌualai. Kai keuki afaꞌagamo afegai, fei laaꞌi puo gagauꞌi kekala kemae. ");
INSERT INTO mek_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ke isaꞌi auga ini mogogo alogai keꞌualai ini fou keuki. Ke keuki afaꞌagamo afegai ini eafipuguꞌi. ");
INSERT INTO mek_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kai isaꞌi auga aꞌisa felogai keꞌualai keuki felo. Egaꞌina auꞌi oga agaꞌo agaꞌo kepua alogaina, agaꞌomo alogai puaga 100 eogeisa,” eoma. Iesu egaꞌina palapole eifania afegai, eifa akaikiꞌa einaka, “Kaisau ainami ekae auga ainami opaaua,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Egaꞌina afegai Iesu ega imoi egaꞌina palapole kapaꞌina eifania auga fouga kepaꞌaniaina. ");
INSERT INTO mek_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ega aisama Iesu einaka, “Deo ega agofaꞌa fouga logo ogefake kapa auga oi epeniimi efua kai, papiau isaꞌi aepalogoniꞌi auꞌi maaꞌiai palapoleai laniniꞌani, ega koa “‘Isa maaꞌiai keisa mo ganinagai afakeisa koa iꞌopoga, kapaꞌina emia auga afakelogo. Ke aꞌo kelogo mo ganinagai, kapaꞌina eifania auga afakelogo.’ ");
INSERT INTO mek_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Pau palapole egaꞌina kapaꞌina eifania auga maamiai fouga alaifania. Au oga auga Deo ega iifa. ");
INSERT INTO mek_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Paisoa peapea afugai keꞌualai auꞌi ainaꞌi kepaaua Deo ega iifa aꞌo kelogo. Kai Satani emai Deo ega iifa guaꞌi alogai eafilaisa. Ega koa isa Deo fakepakoꞌania ke Deo kaniaꞌi faeagamauga eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Fopa laagai aꞌisa afaꞌagamo eka afugai keꞌualai auꞌi, Deo ega iifa aꞌo kelogo aisama alogamai keafia. Kai fekeuki auga gagamuꞌi laaꞌi puo, Deo ega iifa afaꞌagamo kepakoꞌania kai iꞌopo kina emai aisama, keapoke keꞌualai. ");
INSERT INTO mek_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ini mogogo alogai keꞌualai auꞌi, Deo ega iifa aꞌo kelogo. Kai keagu alogai, agu felo opopo, kegapaꞌamuꞌamu opopo, ke kegaalogama opopoꞌi fou kepaꞌauꞌi puo, keapoke aloꞌiai Deo ega iifa aeuki. ");
INSERT INTO mek_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kai aꞌisa felogai keꞌualai auꞌi, Deo ega iifa aloꞌi koꞌagai ke aloꞌi felogai aꞌo kelogo keafi kapulania. Ega puo iꞌopo kina emai aisama, keafiapiꞌi mo elaolao Deo maagai laomai feloꞌi mo kekapaꞌi aniꞌi keoge,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Iesu palapole agaꞌo eifania pugu einaka, “Papiau agaꞌo lanepa epaafiaua aisama, aeafia oga alogai aepaaguka ke peti papagai isafa aeogeꞌunia. Kai lanepa kepaꞌafa afugai epaꞌafa. Ega koa papiau kapaꞌi kemai auꞌi eaea fekeisa eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Gome Deo ega iifa ogefakeai kekae auꞌi, muni Deo ageifafouꞌi agepafokiꞌi. Ke Deo ega iifa kapaꞌina eifania auga maꞌoai agefoufaꞌa papiau maꞌoai akelogo. ");
INSERT INTO mek_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ega puo pau kapaꞌina laifania auga ainami fopaau felo ainau fologo. Aufalao agaꞌo aina epaaua Deo ega iifa aꞌo elogo felo auga, muni Deo maꞌo agepalogo. Kai aufalao agaꞌo aina aepaau felo Deo ega iifa aꞌo aelogo auga, Deo isa kapaꞌina eopolaga ke afaꞌagamo ipauma elogo mo ganinagai ageafania,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Egaꞌina afegai Iesu ina ke akina fou kemai kegaisa keoma. Kai laꞌafou akaikiꞌa puo eega kegalao keoma aekainia. ");
INSERT INTO mek_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ega aisama laꞌafouai aufalao agaꞌo Iesu epainia einaka, “Oi inamu ke akimu fou afegai keapae kegaisao keoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ke Iesu einaka, “Kaisau lau Amau Deo ega iifa aꞌo kelogo ke kainai kepea auꞌi, lau inau ke aau akiu ipaumaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ke kina agaꞌogai Iesu ega imoi epainiꞌi einaka, “Ofuga akaikiꞌagai apagai apie alao,” eoma. Ega puo gaagagai keaguka kelao. ");
INSERT INTO mek_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ke kelao alogai Iesu efeuꞌafai. Iesu efeufeu kai lanina akaikiꞌa ofuga mo epea oma emai. Ega puo goiso emai gaagagai eꞌafouka, ke mae mauni epogai kelao. ");
INSERT INTO mek_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ega kainai Iesu ega imoi kelao kepagonia keinaka, “Lopia, Lopia, iꞌa agakogo,” keoma. Ega puo Iesu eꞌuegekae ameku ke goiso akaikiꞌa ipauma fou efinaiꞌi. Ega aisama fiakoa mo lanina akaikiꞌa eapakipo, ke kapa maꞌoai keꞌolo. ");
INSERT INTO mek_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ke Iesu eꞌafoaipini ega imoi epainiꞌi einaka, “Oi emi pakoꞌa lau eeuai auga kapai?” eoma. Ega aisama Iesu ega imoi kekauai keopofua kemaniꞌi alogaina ifoꞌi epoꞌiai keifa keinaka, “Iꞌina auga kaisau? Ameku ke goiso mo ganinagai epainiꞌi mo aina keafia keapakipo,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Egaꞌina afegai gaagai kelao mo Kadara taonina papiauꞌi keagu agogai keofau. Egaꞌina ago ofuga akaikiꞌa epaaipagainia apiegai auga Kalilea ago. ");
INSERT INTO mek_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iesu gaagai eake foeai aisama, Kadara taonina auga agaꞌo alogai tiapolo eagu auga emai fou kepiaogai. Egaꞌina auga inipo maꞌo tiapu laaꞌi faaga maini mo elao emai, ke eꞌai isafa aeaguagu. Kai laai mo eaguagu. ");
INSERT INTO mek_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Au egaꞌina Iesu eisa aisama, eagaga kai elao Iesu ife foꞌinai eomukipo, ke aiso gomegai eagaga einaka, “Iesu, Deo ufai auꞌoniai Au Akaikiꞌa Ipauma Auga Gauga aumu, kapaꞌina lau eeuai mokapa looma? Lagoinio, kiekie akaikiꞌa folopeniau!” eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Au egaꞌina ega eifa oma, gome Iesu tiapolo au alogai eagu auga epainia gapealai eoma. Tiapolo egaꞌina kina maꞌo au egaꞌina eafiia puo, tieniai ife ima kepaaga, ke iꞌima kepagome mo ganinagai, isa ekapula alogaina tieni eapauꞌi. Ke tiapolo isa epapea elaoaina afu oapugai elao emai. ");
INSERT INTO mek_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ke Iesu isa epaꞌani penia einaka, “Oi akamu kapaꞌina?” eoma Isa alogai tiapolo ealogai alogaina kekoko keagu puo iifa epamue einaka, “Lau akau Maꞌo,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Egae kai egaꞌina tiapoloꞌi Iesu kegoinia akeaponia, faeulaiꞌi eꞌi afu uminaga ipauma auga afuga fakelao keoma. ");
INSERT INTO mek_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Egaꞌina alogai iku eꞌele mapegai uma maꞌo keapa keanimai. Ega kainai egaꞌina tiapoloꞌi Iesu kegoi penia uma aloꞌiai gapakokoꞌi keoma puo, elogoainiꞌi fekelao eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ke tiapolo au alogai kepealai aisama, kelao uma aloꞌiai kekoko. Ke fiakoa mo egaꞌina umaꞌi kekauai, iku mapegai kepiau kelao ofuga akaikiꞌa poupougai kegopolai, feisai kekogo. ");
INSERT INTO mek_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Egae papiau isaꞌi uma kepaaniꞌi auꞌi kapaꞌina emia auga keisa aisama, kepiau kelao taoniai ke taoni afegai keagu papiauꞌi maꞌoai isafa maaꞌiai uma kekogo auꞌi fouꞌi keifania. ");
INSERT INTO mek_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ega kainai papiau kapaꞌina emia auga kegaisa keoma puo kelao. Isa kelao Iesu keisa aisama, tiapolo au alogai eagu auga alo felo emia, tiapu eiꞌiukaꞌi Iesu ife foꞌinai eagu keisa. Ega aisama kekauai kemaniꞌi alogaina. ");
INSERT INTO mek_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ke papiau kapaꞌi egae keapa Iesu au epafelo keisa auꞌi, pau mo kemai auꞌi maaꞌiai Iesu egaꞌina auga ala epafelo oma auga fouga keifania. ");
INSERT INTO mek_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ega aisama Kadara taonina ke taoni afegai keagu papiauꞌi maꞌoai kemaniꞌi alogaina puo, Iesu kepainia gapuaꞌafuniꞌi keoma. Ega puo Iesu egaꞌina afuga epuaꞌafuga, ega imoi fou gaagai keaguka kegakailai keoma. ");
INSERT INTO mek_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Egaꞌina alogai au tiapolo alogai kepealai auga Iesu egoi penia fou kegalao eoma. Kai Iesu isa eulaisa ega pagua elao alogai epainia einaka: ");
INSERT INTO mek_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Momue, emu pagua molao, ke Deo faagamuai kapaꞌina ekapaisa auga papiau maaꞌiai foifafoua,” eoma. Ke Iesu ega iifa kainai egaꞌina auga elao taoni fofouga alogai papiau maꞌoai maaꞌiai Iesu isa faagagai kapaꞌina ekapaisa auga eifafoua. ");
INSERT INTO mek_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Iesu ofuga egaꞌina apiegai epagai apie elao pugu aisama, laꞌafou egae keagu auꞌi Iesu keꞌimaisa puo keifa koko. ");
INSERT INTO mek_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ega aisama fiakoa mo Iudea papiauꞌi eꞌi laꞌafou afuga eꞌima auga aka Jairus, Iesu eega emai ife foꞌinai eomukipo kai, egoinia fou ega eꞌa kegalao eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Gome isa gauga papiega ega mo agaꞌomo inipoga 12 auga, eisafa afaꞌagamo femae koa iꞌopoga. Ega puo Iesu Jairus ega eꞌa pea epea alogai, laꞌafou papiauꞌi kepapepe fou kepea. ");
INSERT INTO mek_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Egaꞌina alogai papie agaꞌo inipo 12 alogai ifamomogu isafaga eafiia kai, kai agaꞌo aepafelo auga laꞌafou egaꞌina alogai eapauka fou kepea. ");
INSERT INTO mek_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Isa Iesu muninai elao afe tiapuga kua eafi opogaina. Ega aisama fiakoa mo ifamomogu isafaga eapakipo. ");
INSERT INTO mek_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ega aisama Iesu laꞌafou papiauꞌi epaꞌani peniꞌi einaka, “Kaisau lau eafi opogainiau?” eoma. Kai papiau maꞌoai akekapaisa keoma aisama, Peto eifa einaka, “Au akaikiꞌa Aumu, papiau laꞌafou akaikiꞌa ipauma kepikoni kepafifi puo, kai eafi opogainio auga oko alalogo,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kai Iesu eifa pugu einaka, “Lau faagauai isapu epealai puo lalogo aufalao agaꞌo epagome eꞌu tiapu eafi opogaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ega aisama papie egaꞌina ageiꞌofake afaekaina elogo puo, maipiguguga mo emai Iesu ife foꞌinai eꞌualai eomukipo. Egae kai papiau maꞌoai agoꞌiai kapa puo Iesu ega tiapu eafi opogaina, ke fiakoa mo ala eoma efelo auga eifafoua. ");
INSERT INTO mek_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Egae kai Iesu isa epainia einaka, “Gau, oi emu pakoꞌa kainai pau lofelo. Gagaoai molao,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iesu eniniꞌani laolao kai, aufalao agaꞌo Jairus Iudea papiauꞌi eꞌi laꞌafou afuga eꞌima auga ega eꞌai emai Jairus epainia einaka, “Oi gaumu emae efua puo, Pamalele auga folopaafipugua,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iesu egaꞌina iifaga aꞌo elogonia aisama, Jairus epainia einaka, “Folomaniꞌi foloopopo. Mopakoꞌania mo, isa felo agemia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ke Iesu elao mo Jairus ega eꞌai ekoko aisama, aufalao iꞌoina agaꞌo aelogoaina fou akekoko kai, Peto, Ioane, James ke imoi ina ama mo fou kekoko. ");
INSERT INTO mek_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Egaꞌina alogai papiau eꞌai keagu auꞌi maꞌoai mae laagai keapepe kepapinapina. Kai Iesu isa epainiꞌi einaka, “Foloapepe. Isa aemae, ekae efeu,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ega aisama egaꞌina papiauꞌi Jairus gauga emae auga kelogo puo, Iesu ega iifa akepakoꞌania keaꞌalaina. ");
INSERT INTO mek_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kai Iesu ifiao imagai eafi epainia einaka, “Gauagai, moꞌue!” eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ega aisama imoi lalauga emue emai, fiakoa mo eꞌue eapa. Egae kai Iesu papiau epainiꞌi foꞌama agaꞌo kegapenia gaania eoma. ");
INSERT INTO mek_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Imoi egaꞌina ina ama kekauai keopofua kai, Iesu isa epaini kapulaniꞌi kapaꞌina emia auga kai agaꞌo maagai fakeifafoua eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Egaꞌina afegai Iesu ega apostolo 12 eifa kaiguguiꞌi. Ke kekaigugu aisama, tiapolo maꞌoai fekepapealaiꞌi, ke isafa apalaꞌi keafiꞌi auꞌi fekepafeloꞌi auga kapulaga ke isapuga fou epeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ke Iesu isa feulaiꞌi fekelao Deo ega agofaꞌa fouga fekeinogoaina, ke isafa papiauꞌi fekepafeloꞌi eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Egaꞌina alogai epainiꞌi einaka, “Agolao alogai oi peagege aumi auga gouga folokapa iꞌini foloafia, feꞌa agaꞌo foloafia, foꞌama agaꞌo foloafia, ke moni agaꞌo foloafia, ke alo tiapuga iꞌiuka eo agaꞌo isafa foloafia. Ke kapa agaꞌo mo ganinagai foloafia. ");
INSERT INTO mek_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Eꞌa kapagai akeifa kokoimi aisama, egae mo foagu felao egaꞌina taonina fopuaꞌafuga. ");
INSERT INTO mek_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kai papiau afakeifa kokoimi koa aisama, taoni agopuaꞌafuga alogai keumakalainimi gouga fokapa, ifemi aeapuga foauopuaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Egae kai eulaiꞌi kelao pagua agaꞌo agaꞌo aloꞌiai kekoko, afu maꞌoai iifa faunina Iesu fouga keinogoaina, ke isafa papiauꞌi kepafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kalilea ago eꞌima lopiaga Herod Iesu ega imoi fou kapaꞌina mo kekapaiꞌi auꞌi fouꞌi maꞌoai elogo. Ke isa opo epamaꞌo, gome papiau isaꞌi keifa Ioane Baptista emaunimue keoma. ");
INSERT INTO mek_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ke isaꞌi keinaka Elaija emue emai keoma. Ke isaꞌi auga ufaina profetaꞌi agaꞌo emaunimue pugu keoma. ");
INSERT INTO mek_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ke Herod einaka, “Lau Ioane Baptista aiso lafoua kai, iꞌina auga au kapa fouga emai lalogo?” eoma. Ke keaga agaꞌo ekapunia, ala mo gaoma Iesu gaisa eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Iesu ega apostolo 12 eꞌi pinauga kepafua kemue kemai aisama, kapaꞌina mo kekapaiꞌi auꞌi maꞌoai Iesu maagai keifania. Egae kai Iesu ega apostolo mo eꞌafeiniꞌi fou keagu afuga kepuaꞌafuga kelao taoni agaꞌo aka Betsaida taoninai kepealai. ");
INSERT INTO mek_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kai laꞌafou papiauꞌi isa ala kelao auga fouga kelogo puo muniꞌiai kelao. Ke kelao aisama, Iesu eifa kokoꞌi, ke Deo ega agofaꞌa fouga maaꞌiai eifania. Ke isafa papiauꞌi kapaꞌi feloꞌi kegamia keoma auꞌi epafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ke epagapigapi efua aisama, apostolo 12 kemai Iesu kepainia keinaka, “Laꞌafou mopakanina ega koa fekelao pagua kainagai, ke taoni afe paguaꞌiai foꞌama ke feufeu afuga agaꞌo fou fekeisaꞌi. Gome iꞌa afu oapuga ipaumagai aaguega,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kai Iesu isa epainiꞌi einaka, “Oi isa kapa agaꞌo amopeniꞌi kegaania,” eoma. Kai isa keinaka, “Lai afalalao laꞌafou papiauꞌi fofouga fauꞌiai foꞌama agaꞌo afalaꞌafa koa aisama, palafa ima ke maꞌa gua mo imamaisai kekae puo akeania afaekaina,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Gome egae au auꞌi maꞌoai mo 5000 koa iꞌopoga keagu. Kai Iesu isa epainiꞌi einaka, “Papiau amoꞌeaꞌi auꞌi 50, 50 koa iꞌopoga opaaguꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ke apostolo Iesu eifania koa iꞌopoga mo kekapaisa, ke papiau maꞌoai keagukipo. ");
INSERT INTO mek_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Egae kai Iesu palafa ima maꞌa gua fou eafiiꞌi ufa eakae penia, Deo maagai tenkiu eifania ke efaiponiꞌi kai, ega imoi epeniiꞌi papiau agoꞌiai kegaogeꞌi eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ke keogeiꞌi efua aisama, mirakulo akaikiꞌa emia, papiau maꞌoai keanipugu, aloꞌi ekainia. Keaniani afegai, Iesu ega apostolo palafa maꞌa fou keaniiꞌi isaꞌi, ke ameafuꞌi fou kepakai guguainiꞌi, aleꞌa 12 akeꞌi kepapoguꞌi. ");
INSERT INTO mek_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kina agaꞌogai Iesu ifogamo emegamega alogai, ega imoi isafa isa eegai keagu. Ke emegamega afegai, ega imoi epaꞌani peniꞌi einaka, “Papiau lau kaisau keoma?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Isa iifa kepamue keinaka, “Papiau isaꞌi keifa ‘Oi auga Ioane Baptista maeai emaunimue,’ keoma. Ke isaꞌi keifa ‘Oi profeta Elaija,’ keoma. Ke isaꞌi auꞌi ‘Oi ufaina profetaꞌi agaꞌo emaunimue emai keoma,’” keoma. ");
INSERT INTO mek_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kai Iesu isa epaꞌani peniꞌi einaka, “Ke oi auga lau kai ooma?” eoma. Ega aisama Peto iifa epamue einaka, “Oi auga Deo ega Mesaia Aumu,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ega aisama Iesu imoi eifa apuꞌi Peto kapaꞌina eifania auga kai agaꞌo maagai fakeifania eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Egae kai Iesu eifa pugu einaka, “Papiau Aumauni Gauga kapa maꞌoai fauꞌiai fekiekie. Egaꞌina alogai Iudea au akaikiꞌa auꞌi, sakedote lopiaꞌi, ke Moses ega iifa pamalelega auꞌi isa fekeumakalaina ke fekeaupugua. Kai kina oiso aisama femaunimue pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Iesu egaꞌina eifania afegai, papiau kemai aisama, ega imoi, ke papiau maꞌoai fou epainiꞌi einaka, “Oi epomiai aufalao agaꞌo lau muniuai gapea eoma koa aisama, isa ifo feꞌagegeaina kai, aufa kina ifo ega koloti fepua muniuai fepea. ");
INSERT INTO mek_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Gome pau kaisau ifo kania gaagamauga eoma auga, muni Deo ega agofaꞌa afaeafia. Kai kaisau pau lau puouai ifo ega agu maunina agepagea auga, muni agu pagai maunina agekapulaisa. ");
INSERT INTO mek_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Au agaꞌo agofaꞌa fofouga ageafia kai ifo imaauga agepamaea, o ega amu maꞌoai mo agepagea afeꞌainiꞌi koa aisama, kapa felo agaꞌo isa eegai agemia ma? Laaꞌi! ");
INSERT INTO mek_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ke kaisau lau emeagaiainiau ke eꞌu iifa isafa emeagaiaina auga, muni Papiau Aumauni Gauga ega isapu akaikiꞌa, ke agelo Deo maagai aloꞌi elolofa auꞌi fou eꞌi isapu akaikiꞌa ipaumagai akemai pugu aisama, Papiau Aumauni Gauga isafa isa agemeagaiaina. ");
INSERT INTO mek_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Iifa koꞌa mo maamiai laifania. Inae oapae aumi isami Deo ega agofaꞌa afaꞌagamo agoisa, ke gamuga agoopo kai agomae,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ke Iesu egaꞌina eifania afegai kina imagea oiso elao afegai aisama, gamegamega eoma puo, Peto, Ioane ke James fou eꞌafeiniꞌi kelao ikuai keꞌagaukae. ");
INSERT INTO mek_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ke Iesu egae emegamega alogai, iisa iꞌoina emia, ke ega tiapu kimage eafi eaea koa iꞌopoga emia. ");
INSERT INTO mek_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Egaꞌina alogai Moses Elaija auniꞌi eaea akaikiꞌa ipaumagai keapakina Iesu fou keniniꞌani. Ke isa eꞌi niniꞌani alogai Iesu Ierusaleme taoninai Deo ega logoai agemae iifaga agekoꞌa auga fouga keifania. ");
INSERT INTO mek_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kai egaꞌina emia alogai, Peto, Ioane, ke James fou maaꞌi efeu alogaina puo kefeu. Kai kekauai maaꞌi ekiakae aisama, Iesu eaea akaikiꞌa ipauma eailofe, ke au auniꞌi isa fou keapa keisaꞌi. ");
INSERT INTO mek_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kai egaꞌina auꞌi auniꞌi Iesu kepuaꞌafuga kelao alogai, Peto Iesu epainia einaka, “Au Akaikiꞌa Aumu, inae faagu auga felo. Iꞌa efeꞌefe oiso fakapa, agaꞌo oi apumu, agaꞌo Moses apuga, ke agaꞌo Elaija apuga,” eoma. (Peto kapaꞌina eifania auga oko aelogo felo kai eifa aagenia mo.) ");
INSERT INTO mek_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kai Peto eniniꞌani laolao kai, apuapu emai eumi apuꞌi. Ke Peto, Ioane ke James fou apuapu alogai keapauka aisama, kemaniꞌi alogaina. ");
INSERT INTO mek_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Egaꞌina alogai aufalao agaꞌo aina ufai eake emai, eifa einaka, “Iꞌina auga Lau Gau lakinaga auga. Oi isa aina foafia!” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aufalao agaꞌo aina ufai emai auga eniniꞌani efua aisama, apostolo auꞌi oiso Iesu mo egae eapa keisa. Ke Iesu aagoai eagu epinauga alogai, apostolo auꞌi oiso kapaꞌina emia keisa auga aloꞌiai mo eka, kai agaꞌo maagai akeifania. ");
INSERT INTO mek_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ke egani Iesu, Peto, Ioane ke James fou ikuai keake kemai aisama, laꞌafou akaikiꞌa isa fou kepiaogai. ");
INSERT INTO mek_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ega aisama laꞌafou alogai au agaꞌo eagaga einaka, “Pamalele aumu, lagoinio gau moisa laoma. Gome lau gau iina mo agaꞌomo. ");
INSERT INTO mek_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kai tiapolo agaꞌo isa eafiia. Ke fiakoa mo epaagagania, eafia aꞌisaai efouga emaeꞌafu, akegai fukofuko eaꞌalai. Tiapolo isa aepuapuaꞌafuga, ke aufa kina epalifu alogaina. ");
INSERT INTO mek_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Lau oi emu imoi inae keagu auꞌi lagoi peniꞌi isa alogai tiapolo kegapapealaisa laoma kai aekainiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesu au egaꞌina ega eifa oma aina elogonia aisama, muninai kepea auꞌi maꞌoai epainiꞌi einaka, “Oi maꞌoai alomi koꞌagai alopakoꞌaniau, ke emi pakoꞌa alopapinauga felo. Lau inae kina pika fou afaagu, ke kina pika alou eemiai afaafiapia mo afelaolao? Lau inae afalaagu pagainia mo kai, emi pakoꞌa eeuai alooge kapulania,” eoma. Egae kai Iesu imoi ama epainia einaka, “Gaumu momaiseina,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ke papiau imoi keafiia kemaiseina alogai mo ganinagai, tiapolo imoi eafiia aꞌisaai efounia emaeꞌafu. Kai kemaiseina Iesu agogai aisama, Iesu tiapolo apala imoi alogai eagu auga efinaisa epapealaisa, imoi felo emia. Egae kai Iesu imoi eafiia ama epenimue. ");
INSERT INTO mek_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ke egae keapa auꞌi maꞌoai Deo ega isapu akaikiꞌa ipauma keisa puo, kekauai alogaina keopofua. Papiau maꞌoai Iesu kapaꞌina mo ekapaiꞌi auꞌi maꞌoai keisaꞌi aisama, kekauai alogaina. Ke egaꞌina kapaꞌi keopopolaniꞌi kai Iesu ega imoi epainiꞌi einaka: ");
INSERT INTO mek_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Lau pau kapaꞌina alaifania auga ainami fopaaua aꞌo fologo. Aufalao agaꞌo Papiau Aumauni Gauga ageꞌafaꞌafalaina papiau imaꞌiai agepaaua,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kai Deo ega logoai Iesu kapaꞌina eifania auga, pau fakelogo eoma puo eogefake. Ega kainai Iesu ega imoi Iesu ega niniꞌani oko akelogo felo. Ke imoi Iesu ega niniꞌaniai kapaꞌina eifania auga kegalogo keoma kai, kemaniꞌi puo akepaꞌani penia. ");
INSERT INTO mek_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Egaꞌina afegai Iesu ega imoi epoꞌiai, kaisau au akaikiꞌa ipauma femia auga akekua kepaꞌaua. ");
INSERT INTO mek_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesu egaꞌina akekua opoꞌiai emai auga elogo aisama, imoi eꞌele agaꞌo eafiia mape kaina epaapa. ");
INSERT INTO mek_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Egae kai epainiꞌi einaka, “Kaisau iꞌina imoina eꞌele lau akauai ageifa koko aisama, lau ageifa kokoisau. Ke kaisau lau ageifa kokoisau aisama, lau eulaisa auga isafa ageifa koko. Iifa gome, oi epomiai kaisau Deo ega pinauga ikapagai ifo eꞌele agepamia aisama, isa auga Deo maagai au akaikiꞌa ipauma,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Egaꞌina afegai Ioane eifa einaka, “Au akaikiꞌa aumu, au agaꞌo iꞌa fou laaꞌi kai oi akamuai tiapolo epapealaiꞌi aisa puo aꞌopoisa amapaapakipo aoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kai Iesu ega imoi epainiꞌi einaka, “Kaisau oi afemiai eaulao auga oi fou. Ega puo folopaapakipo,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Deo ega logoai Iesu ufai feꞌagauaina auga kina ekaialiali aisama, Iesu opo eoge agaꞌonia mo Ierusaleme taonina galao eoma puo pea epea. ");
INSERT INTO mek_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Egaꞌina alogai Iesu ega imoi eulaiꞌi fekeufai fekelao Samaria paguagai Iesu ageagu afuga fekekapaiꞌa eoma. Ega puo kelao egaꞌina paguagai papiau kepainiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kai kagakaga kainai Samaria papiauꞌi auga, Iudea papiauꞌi aniꞌi akeaniani. Ega kainai Iesu Ierusaleme taonina galao eoma auga aꞌo kelogonia aisama, akeifa koko. ");
INSERT INTO mek_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ega aisama Iesu ega apostolo James Ioane auniꞌi Iesu kepaꞌani penia keinaka, “Lopia, oi anina loani lai ufai lo amaifaga gaake gamai egaꞌina papiauꞌi gapamaeꞌi ma looma?” keoma. ");
INSERT INTO mek_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kai Iesu eꞌafoaipini isa auniꞌi efinaiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ke ega imoi fou kekailai pagua iꞌoina agaꞌo kelao. ");
INSERT INTO mek_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Egaꞌina afegai keagai kepea alogai, au agaꞌo emai Iesu epainia einaka, “Ala folao mo ganinagai munimuai alafai paisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ega aisama Iesu einaka, “Ago alo amuꞌeꞌi eꞌi feu afuga ekae, ke ufa ineiꞌi isafa niiꞌi ekae. Kai Papiau Aumauni Gauga auga kania feogeaua felaagai afuga agaꞌo laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Egae kai au iꞌoina agaꞌo epainia einaka, “Muniuai mopea,” eoma. Kai egaꞌina auga iifa epamue einaka, “Lopia, mologoainiau malao amau mafufu kakaua kai munimuai fapea laoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kai Iesu au egaꞌina epainia einaka, “Pakoꞌa auꞌi laaꞌi, lalauꞌi emae auꞌi mae egaꞌina kegafufuga. Kai oi molao Deo ega agofaꞌa fouga, papiau maaꞌiai moifafoua,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ke au iꞌoina mo agaꞌo eifa einaka, “Lopia, lau munimuai alapea. Kai mologoainiau malao inau amau mapamego kakauꞌi kai alamue alamai munimuai alapea,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kai Iesu einaka, “Kaisau ago kefanina aulina eafia ago efanina kai munina eisa auga, Deo ega agofaꞌa faugai agepinauga afaekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Egaꞌina afegai Lopia Iesu ega imoi iꞌoiꞌi 72 ekinaniꞌi eulaiꞌi, ke gua gua fekeufai taoni agaꞌo agaꞌo, ke afu kapaꞌi mo agelao afuga fekelao eoma. ");
INSERT INTO mek_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Egaꞌina alogai epainiꞌi einaka, “Iifa faunina aꞌo fekelogo auꞌi auga laiti iꞌaina kina ekainia koa iꞌopoga kai pinauga auꞌi maꞌo laaꞌi. Ega puo laiti iꞌaina Lopiaga amogoina ega pinauga auꞌi maꞌo gaulaiꞌi ega laiti afugai kegapinauga. ");
INSERT INTO mek_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ke pau lau oi sipi gauga koa iꞌopomi laulaimi agolao amuꞌe aꞌiꞌi epoꞌiai agokoko! ");
INSERT INTO mek_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ke agolao alogai paoti agaꞌo, o feꞌa agaꞌo foloafia. Ke kamata eo agaꞌo isafa foloafia. Ke kaisau keagai agoisa aisama folopamegoinia. ");
INSERT INTO mek_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ke eꞌa agaꞌogai agokoko aisama, iꞌina iifaga foifa kakaua. ‘Gagao iꞌina eꞌagai gaka,’ fooma. ");
INSERT INTO mek_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ke eꞌa inagome auga egaꞌina eegai gagao iifaga agoifania alo agekaina koa aisama, emi gagao isa eegai ageka. Kai laaꞌi koa aisama, gagao egaꞌina mo agemue eemi agemai pugu. ");
INSERT INTO mek_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ke eꞌa agaꞌo agaꞌo folopaao apua kai, eꞌa kapagai keifa kokoimi eꞌagai mo foagu. Ke eꞌa egaꞌinagai kapaꞌina keania ke keinu auga akepenimi aisama, foafia mo. Gome Deo ega pinauga auꞌi eꞌi pinauga afa fekeafia paisa. ");
INSERT INTO mek_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ke taoni agaꞌogai agokoko egaꞌina papiauꞌi akeifa kokoimi aisama, kapaꞌina agomiai akeoge auga mo foania. ");
INSERT INTO mek_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ke oagu afugai isafa auꞌi akeagu aisama, fopafeloꞌi ke fopainiꞌi foifa, ‘Deo ega agofaꞌa emai eemiai ekae,’ fooma. ");
INSERT INTO mek_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kai taoni agaꞌogai agokoko egaꞌina papiauꞌi afakeifa kokoimi aisama, folao taoni alogai peapea afuꞌiai foifa foinaka, ");
INSERT INTO mek_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Oi emi laomai apala kainai emi taoni aeapuga ifemai kamatagai aauopuaina apaigulaisa. Egaꞌina akapa auga oi Deo oumakalaina auga gouga akapa. Kai iifa gome fologo, Deo ega agofaꞌa emai kainagai,’ fooma. ");
INSERT INTO mek_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Iifa gome maamiai laifania, kina fuagai Deo papiau eꞌi laomai apalaꞌi afa agepeniꞌi aisama, oi keumakalainimi taonina papiauꞌi afa apala ipauma akeafia. Sodom taonina papiauꞌi afa keafiia auga eꞌele kai, isa auga afa akaikiꞌa ipauma akeafia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Iesu eniniꞌani alogai taoni kapaꞌi papiauꞌi isa akeumakalainiꞌi papiauꞌi eopolaniꞌi puo iina eifa oma, “Korasin taonina papiaumi, maamiai mirakulo lakapaiꞌi kai oumakalainiau. Ega puo Deo eegai afa apala ipauma agoafia! Betsaida taonina papiaumi, maamiai mirakulo lakapaiꞌi kai oi isafa oumakalainiau. Ega puo oi isafa Deo eegai afa apala ipauma agoafia! Oi maamiai mirakulo lakapaiꞌi auꞌi Taire ke Sidoni taoniꞌiai makapaꞌi koa aisama, egaꞌina papiauꞌi eꞌi laomai apalaꞌi kekapaiꞌi auga kekiekie puo, fiakoa mo ofuofu tiapuꞌi fekeꞌiukaꞌi, ke agafa fekeafia faagaꞌi fekeꞌafa. Ke pau laaꞌi eꞌi laomai apalaꞌi fekeumakalainiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kai oi Korasin ke Betsaida taoniꞌi papiaumi, Deo papiau eꞌi laomai apalaꞌi afa agepeniꞌi aisama, oi auga afa apala ipauma agoafia. Taire ke Sidoni taoniꞌi papiauꞌi eꞌi laomai apalaꞌi afa eꞌeleꞌi akeafiꞌi kai oi auga akaikiꞌa ipauma agoafia. ");
INSERT INTO mek_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ke oi Kapenaum taonina papiaumi, oi oopolaga akami akaikiꞌa aoniamo ageka, ageafiakaeimi ufai ma ooma? Laaꞌi ipauma! Oi aumi agoake ipeli afu uminaga ipauma agolao,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Egae kai ega imoi epainiꞌi einaka, “Kaisau oi ainami elogo auga, lau isafa ainau elogo. Ke kaisau eumakalainimi auga, lau isafa eumakalainiau. Ke kaisau lau eumakalainiau auga, lau eulaisau auga isafa eumakalaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Egaꞌina afegai Iesu ega imoi 72 eulaiꞌi auꞌi kelao eꞌi pinauga kepafua aisama, maialogamaꞌi mo kemue kemai. Ke Iesu kepainia keinaka, “Lopia, oi akamuai aifa aisama tiapolo mo ganinagai ainamai keafiia,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ega aisama Iesu eifa einaka, “Kimage eafi efiakoa koa iꞌopoga, ufai Satani ega eꞌualai oma laisa. ");
INSERT INTO mek_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Lau oi isapu akaikiꞌa lapeniimi efua. Ega puo oi kaapa aoao fou agogafamuꞌaꞌi. Ke emi ou Satani ega isapu akaikiꞌa maꞌoai afaepalifuimi. ");
INSERT INTO mek_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kai tiapolo apalaꞌi ainami keafia aisama, egaꞌina mo alogama folopaꞌaua kai Deo oi akami ufai epapua auga alogama akaikiꞌa fopaꞌaua,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Iesu ega imoi 72 kemue kemai kapa maꞌoai kekapaiꞌi auꞌi keifafouꞌi kinagai, Deo ega Spiritu Iesu alo epagama alogaina. Ke Iesu eifa einaka, “Amau, aagoa ufa fou maꞌoai Lopiaga Aumu, eꞌu imoi kapa maꞌoai kekapaiꞌi auꞌi, ikifa auꞌi malele auꞌi fou eeꞌiai loogefake. Kai eꞌu imoi, imoi eꞌeleꞌi koa iꞌopoꞌi, ikifa malele maꞌo laaꞌi auꞌi eeꞌiai lopaofakaea. E, iifa gome Amau, iꞌina auga Oi emu logoai anina loani auga koa iꞌopoga mo emia. Ega kainai lau Oi laau afagainio,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Iesu Ama Deo eau afagaina efua aisama, eifa pugu einaka, “Lau Amau kapa maꞌoai lau imauai epaaua. Ke kai agaꞌo Gauga kaisau auga aelogo kai, Ama auga mo elogo. Ke kai agaꞌo Ama kaisau auga aelogo kai, Gauga auga mo elogo. Ke Gauga kaisau ekinaniꞌi auꞌi mo Ama kaisau auga epalogoniꞌi.” ");
INSERT INTO mek_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Egae kai Iesu eꞌafoaipini ega imoi mo epainiꞌi einaka, “Kaisau maagai kapaꞌina oi oisaꞌi auꞌi eisaꞌi auga, maaga Deo eegai kapa feloꞌi eafiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Gome lau oi lapainimi, profeta maꞌo ke kin maꞌo fou oi kapaꞌina oisa auga fekeisa keoma kai akeisa. Ke kapaꞌina oi aꞌo ologo auga isafa aꞌo fekelogo keoma kai aꞌo akelogonia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Egaꞌina afegai kina agaꞌogai, Moses ega iifa pamalelega auga agaꞌo Iesu gaꞌopo eoma puo, eꞌuegekae epaꞌani penia einaka, “Pamelele aumu, kapaꞌina fakapa agu pagai maunina faafia?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ke Iesu einaka, “Moses ega iifa pukagai kapaꞌina epapua? Ke ala lokuapi oma?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ke pamalele auga iifa epamue einaka, “Oi alomu koꞌagai guamu fofougai, imaaumu fofougai, alomu fofougai, ke emu kapula fofougai emu Lopia Deo anina foani. Ke alomu koꞌagai ifomu animu loani koa iꞌopoga, emu eꞌa ipafe auꞌi isafa alomu koꞌagai aniꞌi foani,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ega aisama Iesu einaka, “Egamoꞌo loifa. Egaꞌina fokapa kai agu pagai maunina aloafia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kai pamalele auga ifo alo opaina auga papiau fepakinaꞌi eoma puo, Iesu epaꞌani penia pugu einaka, “Ega koa aisama, kaisau auga lau eꞌu eꞌa ipafe auga?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ke Iesu isa ega iifa palapoleai epamue einaka, “Au agaꞌo Ierusaleme taonina epuaꞌafuga Jeriko taonina elao. Egaꞌina alogai keagai painao auꞌi isa keafiia tiapu faagagai keafilaiꞌi. Ke keauauga keau mamaego egae kepuaꞌafuga ekaega kai kekailai kelao. ");
INSERT INTO mek_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ke egaꞌina kinagai sakedote agaꞌo kapaꞌina emia auga aelogo kai, egaꞌina keagaga eafiia elao au egaꞌina eisa. Ega aisama keaga meꞌe mo eafiia efai elao. ");
INSERT INTO mek_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Egae kai Lefi ikupuga auga, Deo ega eꞌai epipalagai auga agaꞌo emai egaꞌina afugai au egaꞌina eisa. Ke isa isafa keaga meꞌe mo eafiia efai elao. ");
INSERT INTO mek_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kai egaꞌina afegai, Samaria auga agaꞌo Iudea papiauꞌi aniꞌi akeaniani auga egaꞌina keagaga eafiia elao. Isa elao au egaꞌina keauga auga afugai mo eka eisa aisama gua eaniia. ");
INSERT INTO mek_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ke elao faaga kelifu auꞌi oili, ke fino mulamulagai eꞌefaiꞌi ke emokaiꞌi. Egae kai eafiia ifo ega donki laagai epaaguka elaoaina feufeu eꞌagai egae eꞌimaisa. ");
INSERT INTO mek_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ke egani aisama, gakailai eoma puo, denari auniꞌi eafilaiꞌi eꞌa eꞌima auga epeniia ke epainia einaka, “Iꞌina monina foafia kai au iꞌina foꞌima felo. Ke moni iꞌina afefaanio koa aisama, alamue alamai kai emu moni pika alopapinauga auga afa alapenimueiso,’ eoma.” ");
INSERT INTO mek_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Iesu iꞌina palapole eifania efua aisama, au egaꞌina epaꞌani penia einaka, “Painao auꞌi au egaꞌina keauniia auga eegai, sakedote auga, Lefi ikupuga auga, ke Samaria auga auꞌi oiso epoꞌiai, loopolaga kaisau auga isa ega eꞌa ipafe auga koa iꞌopoga emia?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ke Moses ega iifa pamalelega kania auga iifa epamue einaka, “Laopolaga, au egaꞌina gua eania auga isa ega eꞌa ipafe auga,” eoma. Ega aisama Iesu isa epainia einaka, “Oi isafa folao ega koa fokapa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Egaꞌina afegai Iesu ega imoi fou kekailai kemai pagua agaꞌogai aisama, papie aka Marta ega eꞌai eifa kokoꞌi. ");
INSERT INTO mek_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ke Marta akina aka Maria auga Lopia Iesu ife foꞌinai eagukipo kai kapaꞌina eifania auga aina elogonia. ");
INSERT INTO mek_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kai Marta auga Iesu ega imoi fou fekeaniani foꞌamaga gapafua auga pinaugaga maaga elaꞌa meꞌe. Isa emai Lopia Iesu eegai kai epainia einaka, “Lopia, lau akiu fepipalagai kai epuaꞌafuniau ifou mo lapinauga auga guau aloania ma? Mopaina gapalagainiau!” eoma. ");
INSERT INTO mek_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ega aisama Lopia iifa epamue einaka, “Marta, Marta, oi loopopo alogai, kapa maꞌo alomafuꞌi lopaꞌauꞌi. ");
INSERT INTO mek_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kai foloopopo alogaina kapa agaꞌomo moopolaga. Maria auga kapa felo ekinaga, ke kai agaꞌo egaꞌina kapa isa afaeafania,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Egaꞌina afegai kina agaꞌogai Iesu afu agaꞌogai emegamega. Emegamega efua aisama, ega imoi agaꞌo emai epainia einaka, “Lopia, Ioane Baptista ega imoi megamega epalogoniꞌi koa iꞌopoga, lai isafa megamega mopalogonimai,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ega puo Iesu ega imoi epainiꞌi einaka, “Agomegamega aisama iina fomegamega oma: “‘Amamai, Akamu Akaikiꞌa Ipauma, galolofa. Emu agofaꞌa gamai. ");
INSERT INTO mek_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Aufa kina foꞌamaga mopenimai. ");
INSERT INTO mek_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Oi emai apala maꞌoai moꞌagegeainiꞌi, gome lai papiau eemaisai apala kekapa auꞌi eꞌi apala aꞌagegeainiꞌi. Ke mopapeaimai iꞌopo apalaꞌi aloꞌiai falakoko’” eoma. ");
INSERT INTO mek_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Egae kai ega imoi epainiꞌi pugu einaka, “Amoopolaga, oi epomiai au agaꞌo ologonia auga eague. Kai kina agaꞌogai isa ekefaꞌa agaꞌo agomaai emai kai isa eegai foꞌama agaꞌo laaꞌi. Ega puo fafuai isa au agaꞌo elogo auga eega elao epainia einaka, ‘Ekefaꞌau, palafa iuma oiso mopeniau. ");
INSERT INTO mek_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Gome lau ekefaꞌau agaꞌo epea aisoge eeu emai. Kai lau eeuai foꞌama agaꞌo laaꞌi fapenia auga aekainiau,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Kai isa ekefaꞌa eꞌa alogai iifa epamue einaka, ‘Lau eꞌu paꞌafi ekupu efua, ke lau gau fou afeu puo, alaꞌuegekae foꞌama agaꞌo alapenio afaekaina. Ega puo foloꞌaugainiau,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kai iifa gome maamiai laifania. Isa ekefaꞌa mo kainai afaeꞌugekae foꞌama afaepenia. Kai isa ega piꞌaugai kainai ageꞌue kapaꞌina mo anina eani auga agepenia. ");
INSERT INTO mek_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ega puo lapainimi, Deo fogoina, Isa agepenimi. Fokapuga, agokapulaisa. Ke paꞌafi foꞌinipa, paꞌafi ageagalai. ");
INSERT INTO mek_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Gome kaisau mo kepinoi auꞌi auga, Deo isa kapaꞌina kegoina auga agepeniꞌi. Ke kekapuga auga, akekapulaisa. Ke paꞌafi keꞌinipa auꞌi auga eeꞌiai paꞌafi ageagalai. ");
INSERT INTO mek_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ke oi au aumi epomiai gaumi maꞌa akegoina koa aisama, kaapa agopeniꞌi ma? Laaꞌi ipauma! ");
INSERT INTO mek_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ke oꞌolo aoina akegoina koa aisama, aoao agopeniꞌi ma? Laaꞌi ipauma! ");
INSERT INTO mek_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Oi laomai apalaꞌi ikapa aumi kai gaumi kapa feloꞌi ipeniꞌi ologo. Kai oi Amami ufai eague auga felo ipauma. Ke Isa kaisau egoina auga apala agepenia ooma ma? Laaꞌi ipauma! Iifa gome, Isa kapa feloꞌi ipaumaꞌi maꞌoai agepenimi, ke ega Spiritu isafa agepenimi!” eoma. ");
INSERT INTO mek_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kina agaꞌogai Iesu akeafu tiapolo au agaꞌo alogai eagu auga epapealaisa. Ke tiapolo egaꞌina au epuaꞌafuga aisama, akeafu auga eniniꞌani. Ke laꞌafou papiauꞌi Iesu au egaꞌina epafelo keisa aisama, kekauai keopofua. ");
INSERT INTO mek_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kai papiau isaꞌi auga keinaka, “Isa tiapolo eꞌi lopia Belsabul aka isapugai tiapolo epapealaiꞌi,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ke isaꞌi auga Iesu keꞌopoisa kepainia ufa guagai kapa agaꞌo gouga gakapa kegaisa keoma. ");
INSERT INTO mek_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kai Iesu egaꞌina papiauꞌi kapaꞌina keopolaga auga elogo puo epainiꞌi einaka, “Agofaꞌa agaꞌo ifo ageaupea koa aisama, agelifu afeꞌai. Ke eꞌa agaꞌogai famili ifoꞌi mo akeaupeaꞌi koa aisama, egaꞌina familina ageꞌualai. ");
INSERT INTO mek_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ega koa iꞌopoga, Satani isafa ifo ega agofaꞌa ageaupea koa aisama, ala koa iꞌopoga isa ega agofaꞌa ageapa? Lau ega laifa oma, gome oi oifa lau Belsabul aka isapugai tiapolo laulaꞌi ooma. ");
INSERT INTO mek_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pau oi oifa koa iꞌopoga, lau Belsabul aka isapugai tiapolo lapapealaiꞌi koa aisama, oi epomiai papiau isaꞌi tiapolo kepapealaiꞌi auꞌi, kaisau aka isapugai tiapolo kepapealaiꞌi? Ega puo oi kapaꞌina oifania auga koꞌa o pifoge auga isa akeifafoua. ");
INSERT INTO mek_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kai lau Deo ima isapugai tiapolo lapapealaiꞌi koa aisama, Deo ega agofaꞌa emai oi eemiai efua. ");
INSERT INTO mek_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Au kapula pipaini amuꞌi maꞌoai eafiꞌi ifo ega eꞌa eꞌima aisama, ega amu maꞌoai keka felo. ");
INSERT INTO mek_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kai aufalao agaꞌo kapula ipauma auga agemai auniꞌi akepipaini aisama, isa ekapula alogai puo ageauga ega amu maꞌoai ageafiꞌi. Ke auau amuꞌi epakoꞌaniꞌi auꞌi ageafiꞌi, ke painao amuꞌamuꞌi auga ageꞌeaꞌi. Ega koa iꞌopoga, lau tiapolo lapapealaiꞌi aisama, lau eꞌu isapu isa ega isapu ekaꞌegaina. ");
INSERT INTO mek_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Kaisau lau afeuai aeaulao auga lau fou laaꞌi. Ke kaisau lau fou alamia papiau alapakai guguainiꞌi auga, papiau epakaniniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Iesu egaꞌina eifania afegai, eifa pugu einaka, “Tiapolo apala au agaꞌo alogai epealai aisama, elao ago maininai laagai afuga ekapuga kai aeisa. Ega aisama ifo alogai einaka, ‘Lau eꞌa lapuaꞌafuga auga eꞌa alamue alalao pugu,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ke elao egaꞌina eꞌagai aisama, eꞌa alo keꞌamunia ke amu maꞌoai mo kepakokopai eisa. ");
INSERT INTO mek_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ega aisama epealai elao tiapolo iꞌoiꞌi auꞌi imagea gua, isa ega apala kekaꞌegaina auꞌi emaiseiniꞌi fou kelao egaꞌina eꞌagai kekoko keagu. Ke fuagai aisama, au egaꞌina ega agu elifu alogaina, ufainagai ala eagu oma auga aguga ekaꞌegaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iesu egaꞌina iifaꞌi eifaniꞌi alogai, laꞌafouai papie agaꞌo Iesu eegai eifa akaikiꞌa einaka, “Oi inamu epamaunio ke eꞌimaiso auga Deo eegai kapa feloꞌi eafiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kai Iesu einaka, “Kaisau Deo ega iifa aꞌo kelogo ke kainai kepea auꞌi Deo eegai kapa feloꞌi keafiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Laꞌafou akaikiꞌa emia elaoaina alogai, Iesu papiau epainiꞌi einaka, “Iꞌina papiauꞌi aloꞌi apala ipauma. Isa lau Deo eegai lamai ma auga fekelogo keoma puo, mirakulo gouga kepaꞌaniaina. Kai lau mirakulo gouga agaꞌo afalakapa kai, Jona kapaꞌina ekapaisa auga mo alakapa. ");
INSERT INTO mek_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Gome Jona mirakulo agaꞌo aekapaisa kai, ega inogo auga Ninife papiauꞌi eeꞌiai mirakulo koa iꞌopoga emia. Ega koa iꞌopoga mo, Papiau Aumauni Gauga isafa iꞌina papiauꞌi eeꞌiai ega mo agekapa oma. ");
INSERT INTO mek_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ke ufainagai kin Solomon eagu miagai, South ago kuinina Siba, Solomon ega ikifa akaikiꞌa fouga elogo aisama ega ikifa aꞌo galogo eoma. Ega puo ago fuagai ipauma mo ganinagai, emai Solomon ega ikifa aꞌo elogonia. Ega kainai Deo papiau eꞌi laomai felo, o apalaꞌi afa agepeniꞌi kinagai aisama, egaꞌina kuinina ageꞌue Deo maagai iꞌina papiauꞌi eꞌi laomai apala ageoma. Pau lau Solomon ega ikifa lakaꞌegaina au inamoꞌeu. ");
INSERT INTO mek_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ke Deo papiau maꞌoai eꞌi laomai felo, o apala afa agepeniꞌi aisama, Ninife taonina papiauꞌi isafa akeꞌue Deo maagai iꞌina papiauꞌi eꞌi laomai apalaꞌi akeoma. Gome isa Jona ega inogo aꞌo kelogonia aisama, eꞌi laomai apalaꞌi keumakalainiꞌi. Ke pau lau Jona lakaꞌegaina au lamai inamoꞌeu,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ke Iesu eifa pugu einaka, “Aufalao agaꞌo lanepa epaafiaua kai ogefake afugai aepaagufake, o liti papagai isafa aeogeꞌunia. Kai eafia lanepa kepapaꞌafa afugai epaꞌafa, ega koa papiau kemai auꞌi eaea fekeisa eoma. Ega koa iꞌopoga, lau Deo ega iifa alaogefake, oi maamiai laifafoua. ");
INSERT INTO mek_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ke oi maami auga lanepa koa iꞌopoga, imaaumi fofouga epaeaea. Ke oi maami felo aisama, imaaumi fofouga isafa ageeaea afeꞌai. Kai oi maami apala koa aisama, imaaumi fofouga uminagai ageagu. ");
INSERT INTO mek_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ke alomiai eaea ekaega auga, foisa felo umina faemia. ");
INSERT INTO mek_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ega koa aisama, oi imaaumi fofouga ageeaea afeꞌai. Ke imaaumi agaꞌomo mo ganinagai afaeꞌumina koa aisama, lanepa eaea efai imaaumi egefa koa iꞌopoga, Deo ega iifa eaea koꞌa ipauma auga, alomi agepaeaea. Ega puo lau fou agologo felo,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesu eniniꞌani efua afegai aisama, Faliseo auga agaꞌo Iesu epainia fou fekelao ega eꞌai fekeaniani eoma. Ega puo Iesu elao au egaꞌina ega eꞌai ekoko fou kegaaniani keoma. ");
INSERT INTO mek_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kai Faliseo auga egaꞌina Iudea eꞌi kagakaga kainai Iesu ima aeiku kakaua kai gaaniani eoma auga eisa aisama, ekauai alogaina eopofua. ");
INSERT INTO mek_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kai Lopia isa kapaꞌina eopolaga auga elogo puo epainia einaka, “Oi Faliseo aumi amoisa. Oi auga kaputi ke liti fou afeꞌi keikuꞌi koa iꞌopoga, emi kagakaga kainai faagami afe mo oikua kai, alomi auga mogemoge ke opola apalaꞌi fou epogu. ");
INSERT INTO mek_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Oi kafoꞌo papiaumi! Deo afemi epagama auga alomi isafa aepagama ma? E! Isa oi afemi ke alomi fofouga fou epagamaꞌi. ");
INSERT INTO mek_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Oi auga emi kagakaga kainai mo ulalu auꞌi folopalagainiꞌi. Kai kapaꞌina eemiai kekae auꞌi alomi koꞌagai ulalu auꞌi fopeniꞌi fopalagainiꞌi. Ega koa aisama, Deo maagai alomi fofouga afaeofu, papiau felomi agomia. ");
INSERT INTO mek_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kai oi Faliseo aumi, Deo maagai papiau eeꞌiai laomai feloꞌi fokapaꞌi, ke alomi koꞌagai Deo anina foani auga laoꞌi maiꞌi ooge meꞌeꞌi. Kai oi emi kagakaga kainai mo opea, aupu gagauga agaꞌo aka mint, ke rue, ke uma alo aupu gagauꞌi maꞌoai oafiꞌi, oꞌuaga epoꞌiai, agaꞌomo Deo opaꞌa penia. Oi Deo amu ipaꞌa penia auga mo laoga maina okapa. Kai oi egaꞌina mo folokapa kai, laomai feloꞌi fokapaꞌi, ke alomi koꞌagai Deo anina foani. Kai ega koa alokapa puo, Deo oi emi laomai apala afa fepenimi laoma! ");
INSERT INTO mek_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Faliseo aumi, oi laꞌafou afuꞌiai, au akaikiꞌaꞌi keaguagu auꞌi mo afuꞌiai foagu auga anina oani alogaina. Ke afaꞌafa afuꞌiai papiau fekepamegonimi auga isafa anina oani alogaina. Ega puo Deo oi emi laomai apala afa fepenimi laoma! ");
INSERT INTO mek_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Ke oi afemi auga la koa iꞌopoga, ke alomi auga laai papiau agaꞌo imaauga efoka koa iꞌopoga. Kai papiau oi alomi ala efoka oma auga akelogo puo, laagai kepea pagai oi fou opea olao omai. Ke ega koa emia oi isa opagagaꞌi puo, isa oi koa iꞌopomi mo kekagakaga. Ega puo Deo oi emi laomai apala afa fepenimi laoma!” eoma. ");
INSERT INTO mek_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ega aisama Moses ega iifa pamalelega auga agaꞌo Iesu epainia einaka, “Pamalele aumu, oi Faliseo auꞌi eeꞌiai iꞌina kapaꞌi loifaniꞌi auga, lai isafa loifa apala penimai,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kai Iesu einaka, “Oi pamalele aumi, papiau meau akepua afaekaina auga openiꞌi fekepua ooma. Ke oi ifomi auga imami kekeꞌe agaꞌomo mo ganinagai aloafiakae egaꞌina papiauꞌi alopalagainiꞌi. Ega puo Deo oi emi laomai apala afa fepenimi laoma! ");
INSERT INTO mek_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Pamalele aumi, pifoge aumi! Papiau oi au akaikiꞌami fekepamiaimi ooma puo, ufumi apami profeta keaupuguꞌi auꞌi eꞌi la feloꞌi okapaiꞌi. Ega puo Deo oi emi laomai apala afa fepenimi laoma! ");
INSERT INTO mek_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Oi ufumi apami profeta keaupuguꞌi, ke oi auga isa eꞌi la okapaiꞌi. Ega puo ufumi apami kapaꞌina kekapaiꞌi auga, Deo maagai felo opamia papiau agoꞌiai ega koa okapa. ");
INSERT INTO mek_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ega kainai Deo ega ikifai eifa einaka, ‘Lau profeta ke imoi isa eeꞌiai alaulaiꞌi. Kai isa egaꞌina papiauꞌi isaꞌi akeaupuguꞌi, ke isaꞌi akeafi apalaniꞌi,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ega puo agofaꞌa eꞌina mo alogai profeta keauniiꞌi ifaꞌi efaka auga afa iꞌina papiauꞌi pau keague auꞌi akeafia. ");
INSERT INTO mek_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Egaꞌina profetaꞌi auga Apele faagagai eꞌina ifa efaka emai Sakaraia faagagai. Ke papiau isa Deo ega eꞌa alogai amu Deo kepaꞌa penia afuga, ke Deo ega eꞌa alo ipaumagai, Deo ifo mo eaguagu afuga fou epoꞌiai keaupugua ifa efaka. Iifa gome mo maamiai laifania. Iꞌina papiauꞌi pau keague auꞌi egaꞌina profetaꞌi maꞌoai kemae auga ifaꞌi afa isa akeafia. ");
INSERT INTO mek_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Pamalele aumi, Deo ega iifa kapaꞌina eifania auga oko ipauma papiau fekelogo auga okogai mo alopamaleleniꞌi puo, oi Deo ega iifa okaisapua. Oi ifomi isafa Deo ega iifa koꞌa ipauma auga alomiai aekoko felo, ke papiau Deo ega iifa aloꞌiai gakoko keoma auꞌi isafa okaisapuꞌi. Ega puo Deo oi emi laomai apala afa fepenimi laoma!” eoma. ");
INSERT INTO mek_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iesu egaꞌina eifania afegai, epuaꞌafuniꞌi elao. Egaꞌina alogai Faliseo auꞌi ke Moses ega iifa pamalelega auꞌi fou keꞌina Iesu eegai guaꞌi ekupu alogaina, paꞌani maꞌo mo kepaꞌani. ");
INSERT INTO mek_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ke keꞌimaisa kapa apala agaꞌo afeifania koa aisama, fekeafia iifa ipakainai fekepaapauka keoma. ");
INSERT INTO mek_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Egaꞌina alogai papiau maꞌo alogaina kemai Iesu eapa afugai kelaꞌafou. Ke papiau ealogai alogaina, kegapea auga aekainia kainai kepaꞌifu agaꞌo agaꞌo laaꞌiai keapau kelaoaina. Egaꞌina alogai Iesu eꞌina ega imoi epaini kakauꞌi einaka, “Faliseo auꞌi eꞌi pifoge auga palafa ipaufuga mulamula palafa alogai keoge eufu auga koa iꞌopoga. Ega kainai isa eꞌi pifoge euki papiau epoꞌiai ekoko epalifuꞌi auga foisa felo. ");
INSERT INTO mek_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ke kapa maꞌoai pifogeai keogefakeꞌi auꞌi akekapulaiꞌi akelogo. Ke amu maꞌoai keogefakeꞌi auꞌi akefoki. ");
INSERT INTO mek_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ega puo kapaꞌina gapiai oifaniꞌi papiau akelogo auꞌi, kinaisai oifafoua koa iꞌopoga akelogo. Ke eꞌa alogai oifa kekefa mo kapaꞌina oifania auga ofaofai akeifafoua koa iꞌopoga papiau maꞌoai akelogo. ");
INSERT INTO mek_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ekefaꞌau aumi, iifa gome maamiai laifania. Kaisau papiau imaauꞌi mo keaupuguꞌi auꞌi akeaupuguꞌi afegai, kapa agaꞌo afakekapa pugu puo folomaniꞌiainiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kai pau oi kaisau fomaniꞌiaina auga alapakinaimi. Isa oi imaaumi ageaupugua afegai, lalaumi ipeliai agepiulaiꞌi isapuga eafia auga fomaniꞌiaina. Koꞌa ipauma, lapainimi pugu. Oi egaꞌina auga fomaniꞌiaina paisa. ");
INSERT INTO mek_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Oi ologo iilo ima penimaeꞌi auniꞌiai mo keꞌafaꞌi. Kai Deo egaꞌina ineiꞌi agaꞌomo mo ganinagai afaeꞌagegeaina. ");
INSERT INTO mek_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ke kaniamiai fufu auga kapa agaꞌo laaꞌi mo ganinagai, Deo fufu pika keuki auga maꞌoai epaau afeꞌainiꞌi. Ega kainai Deo agogai oi afami auga iilo maꞌo afaꞌi ekaꞌegaina. Ega puo oi papiau folomaniꞌiainiꞌi kai Deo fomaniꞌiaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Iesu egaꞌina eifaniꞌi efua aisama, epainiꞌi pugu einaka, “Iifa gome maamiai laifania. Kaisau papiau maaꞌiai eifa isa lau eꞌu imoi eoma auga, lau isafa muni Deo ega agelo agoꞌiai isa lau Papiau Aumauni Gauga au, eꞌu imoi alaoma. ");
INSERT INTO mek_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kai kaisau papiau maaꞌiai lau muniuai epea auga epuniaiaina auga, muni lau isafa isa Deo ega agelo agoꞌiai alapuniaiaina. ");
INSERT INTO mek_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ke kaisau Papiau Aumauni Gauga eumakalaina auga, Deo isa ega laomai apala afa ageꞌagegeaina. Kai kaisau Deo ega Spiritu eegai eifa apala auga, Deo isa ega laomai apala afa afaeꞌagegeaina. ");
INSERT INTO mek_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ke muni papiau oi akeafimi Iudea papiau eꞌi laꞌafou afuga keꞌima, ke isapu keafia auꞌi agoꞌiai akepaapaimi aisama, oi kapaꞌina agoifania ke iimi ala agooge oma auga opopo folopaꞌaua. ");
INSERT INTO mek_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Gome Deo ega Spiritu oi kapaꞌina foifania auga agepamalelenimi agoifania,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Iesu ega imoi maaꞌiai eniniꞌani efua aisama, laꞌafou alogai au agaꞌo Iesu epainia einaka, “Pamelele aumu, lau aau mopaina lai amamai ega amu gaꞌea lau apu gapeniau laoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kai Iesu einaka, “Akiuagai, kaisau lau ekinaniau oi epomiai kapaꞌina apala, o felo auga faifania, ke afemiai faaulao eoma? Lau egaꞌina puogai alamai,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Egae kai Iesu papiau maꞌoai epainiꞌi einaka, “Mogemoge kapaꞌi maꞌoai foumakalaina. Papiau akepaꞌamuꞌamu mo puogai eꞌi agu felo agemia afaekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Egae kai Iesu iꞌina palapole papiau maaꞌiai eifania einaka, “Paꞌamuꞌamu auga agaꞌo ega umai foꞌama aniꞌi keoge felo alogaina. ");
INSERT INTO mek_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ega aisama isa ifo mo alogai eifa einaka, ‘Iꞌina foꞌamaꞌi alaafiꞌi kai isogeꞌi afuga iꞌoina agaꞌo laaꞌi. Ega puo kapaꞌina alakapa?’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Egae kai eifa einaka, ‘Lau iina alakapa oma: Foꞌama isoge afuꞌi ufaiꞌi auꞌi alaauokaꞌi kai, akaikiꞌaꞌi ipaumaꞌi alakapaꞌi. Ke egaꞌina afuꞌiai eꞌu foꞌama maꞌoai ke eꞌu amu maꞌoai fou alaogeꞌi. ");
INSERT INTO mek_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ke ifou alapainiau alainaka, ‘Oi amu feloꞌi maꞌo eemuai kekae puo, inipo maꞌo afolopinauga mo ganinagai kapa agaꞌo laaꞌi. Ke pau folopinauga foagu aage mo, foafia foania, foinu, ke foalogama mo alaoma,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Kai Deo isa epainia einaka, ‘Oi kafoꞌo aumu! Iinaꞌi mo gapinai lau oi emu agu maunina alaafiꞌaua. Ega aisama kaisau oi ifomu faumuai amu lokapaꞌi auꞌi ageafiꞌi? Oi alomae puo oi apumu afakemia’ eoma.” ");
INSERT INTO mek_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Iesu palapole egaꞌina eifania afegai eifa einaka, “Kaisau ifo faugai epaꞌamuꞌamu kai Deo faugai aepaꞌamuꞌamu auga, iina koa faagagai agemia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ke Iesu ega imoi maꞌoai epainiꞌi einaka, “Iifa gome maamiai laifania. Paꞌamuꞌamu auga faagagai iina koa agemia kainai, oi emi agu, ke kapaꞌina agoania, ke imaaumi faugai tiapu kapa agoꞌiuka auga opopo folopaꞌaua. ");
INSERT INTO mek_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gome oi emi mauni aguga auga, foꞌama ekaꞌegaina, ke imaaumi auga tiapu ekaꞌegaina. ");
INSERT INTO mek_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pau maami galao inei akaꞌi oagu amoisaꞌi. Isa kapa agaꞌo akefauga, o anina isafa akeafia. Ke isa eꞌi foꞌama isoge afuga agaꞌo laaꞌi. Ega mo ganinagai, Deo isa epaaniꞌi. Kai oi auga Deo maagai kapa akaikiꞌa ipaumami, inei okaꞌegainiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ke oi epomiai aufalao agaꞌo opopoai ega agu kina maaga agaꞌomo koa iꞌopoga epo agepamaefania agekainia ma? Laaꞌi! Kai agaꞌo ega koa agekapa afaekaina. ");
INSERT INTO mek_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Oi kapa eꞌeleꞌi iina koaꞌi mo ganinagai agokapaꞌi afaekaina kai, kapa puo amu maꞌo isaꞌi opopoꞌi opaꞌauꞌi? ");
INSERT INTO mek_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Pau maami galao ago alo kaikaiꞌi feloꞌi ipaumaꞌi auꞌi amoisaꞌi. Isa akepinauga ke tiapu akekapaꞌi. Kai iifa gome mo maamiai laifania. Ufainagai kin Solomon epaꞌamuꞌamu alogaina, ega amu maꞌoai feloꞌi mo ganinagai, egaꞌina amuꞌi eꞌi felo ago alo kaikaiꞌi eꞌi felo akekaꞌegainiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ke ago alo kaikaiꞌi egaꞌina pau kekae kai fafoko aisama, papiau akeafiꞌi loai akeꞌafoauꞌi mo ganinagai, Deo isa kaikaiꞌi felo auga, tiapu koa iꞌopoga epaiꞌiukaꞌi. Kai oi aumi kaikai egaꞌina alokaꞌegainiꞌi ma? Ke Deo kapa feloꞌi ipaumaꞌi agepenimi afaekaina ma ooma? E! Isa agepenimi paisa. Kai oi pakoꞌa eꞌele papiaumi! Oi Deo fopakoꞌania koa kai alopakoꞌania. ");
INSERT INTO mek_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ke kapaꞌina agoania ke agoinu auga foloopolaniꞌi, ke minomi egaꞌina kapaꞌi eeꞌiai folooge. Ke foloopopolainiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Gome Deo akepakoꞌania auꞌi auga, kapaꞌina kegaania ke kegainu auga mo muninai kepiau. Kai oi Amami auga kapaꞌina anina oani auga elogo felo. ");
INSERT INTO mek_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kai Deo ega agofaꞌa fokapu kakaua. Ega aisama Deo kapaꞌina mo aniꞌi oani opopoꞌi opaꞌauꞌi auꞌi isafa agepenimi. ");
INSERT INTO mek_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Oi Amami ega agofaꞌa ega alogamai epenimi. Ega puo oi aumi aemaꞌo mo ganinagai folomaniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kai emi amu amoꞌafaꞌafalainiꞌi ulalu auꞌi amopalagainiꞌi. Ega koa agokapa aisama, emi amu paoti ufai ekae auga alogai agoogeuka. Ke egaꞌina paotina afaegeagea, ke painao auga agaꞌo paoti egaꞌina eega afaemai. Ke amu paoti alogai keka auꞌi isafa afakemokemoke, ke afakegeagea. ");
INSERT INTO mek_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Gome oi emi amu mo opopoꞌi agopaꞌauꞌi aisama, egaꞌina mo kapaꞌi aniꞌi agoani,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Iesu egaꞌina iifaꞌi eifaniꞌi afegai, ega imoi maꞌoai epainiꞌi pugu einaka, “Oi pinauga ikapa auꞌi koa iꞌopoꞌi fomia, emi au akaikiꞌa gaika ega amagelofe miamiaga agefua agemai auga kina foꞌima. Ke isa agoꞌima alogai tiapu feloꞌi foiꞌiukaꞌi, lanepa fopaafiauꞌi fofua foagu, emi pinauga agoꞌina agokapa auga pinaugaga foꞌima. Ega koa isa agemai paꞌafi ageꞌinipa aisama, oi pinauga ikapa auꞌi koa iꞌopoꞌi, fiakoa foꞌuegekae isa faugai paꞌafi fopaagalaisa. ");
INSERT INTO mek_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ke au akaikiꞌa agemai, ke pinauga ikapa auꞌi isa keꞌima auꞌi auga, isa eegai kapa feloꞌi akeafiꞌi. Iifa gome maamiai laifania, isa ifo pinauga fekapa auga tiapuꞌi ageiꞌiukaꞌi, ega pinauga auꞌi agepainiꞌi aniani afugai akeagukipo. Egae kai foꞌama agekapa eeꞌi agelaoaina agepeniꞌi akeania. ");
INSERT INTO mek_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ke au akaikiꞌa egaꞌina gapi atiafagai, o gani eegai femai mo ganinagai, ega pinauga ikapa auꞌi kefua keague auꞌi isa eegai kapa feloꞌi akeafia. ");
INSERT INTO mek_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kai iꞌina iifaga kapaꞌina laifania auga fologo. Eꞌa inagome agaꞌo painao auga kina maaga kapagai agemai eꞌa ageaupea auga agelogo koa aisama, eꞌa ageꞌima puo painao auga eꞌa afaeaupea. ");
INSERT INTO mek_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ega koa iꞌopoga, Papiau Aumauni Gauga agepakauai kina maaga kapagai agemai auga alologo puo, oi isafa fofua foagu,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Iesu egaꞌina eifania afegai aisama, Peto isa epaꞌani penia einaka, “Lopia, egaꞌina palapole lai oi emu imoi mo lopainimai, o papiau maꞌoai mo lopainiꞌi?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kai Iesu Peto ega paꞌani afa palapoleai iina epamue oma einaka, “Pinauga ikapa auꞌi epoꞌiai kaisau auga eikifa, ke alo koꞌagai ega au akaikiꞌa ega eꞌa eꞌima? Au egaꞌina auga ega au akaikiꞌa isa eꞌa fofouga epaꞌima. Ke isa pinauga ikapa auꞌi maꞌoai eꞌi foꞌama fekeania auga kina maaga ekaina aisama epeniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ke au akaikiꞌa egaꞌina agemai eꞌa epaꞌima auga ega koa agekapa ageisa auga, isa eegai kapa feloꞌi ageafiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Iifa gome maamiai laifania. Au akaikiꞌa egaꞌina, eꞌa eꞌima auga amu maꞌoai agepaꞌima afeꞌaina. ");
INSERT INTO mek_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kai iina koa afemia auga amoopolaga. Eꞌa eꞌima auga ifo mo ageifa ageinaka, ‘Lau eꞌu au akaikiꞌa aepaafiafi aemai,’ ageoma. Ega puo ageꞌuegekae pinauga auꞌi maꞌoai, au ke papie fou ageauniꞌi. Ke ageinu ageaniani, ke ageinuinu alogaina. ");
INSERT INTO mek_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Isa laomai ega koa ekapakapa kai, kina maaga kapagai ega au akaikiꞌa, agepakauaina agemai auga afaelogo. Kai egaꞌina kina agemai aisama, agepakauaina ega pinauga afuga apala ageisa. Ega aisama au akaikiꞌa egaꞌina, isa ageafia afa apala ipauma agepenia. Ke pakoꞌa auꞌi laaꞌi auꞌi afuꞌiai agepiulaisa. ");
INSERT INTO mek_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ega kainai pinauga ikapa auga ega au akaikiꞌa kapaꞌina isa fekapa eoma auga elogo kai aefua aeagu aekapa koa aisama, au akaikiꞌa agemai aisama, isa ageauga kiekie akaikiꞌa agepenia. ");
INSERT INTO mek_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kai pinauga ikapa auga kapaꞌina fekapa auga aelogo puo, afa feafia koa iꞌopoga kapa agaꞌo ekapaisa koa aisama, au akaikiꞌa agemai aisama, ageauga kai kiekie eꞌelega mo agepenia. Ega koa iꞌopoga, Deo kaisau maꞌo epenia feꞌima eoma auga, muni maꞌo eegai gaafimue auga paꞌanina agepaꞌani. ");
INSERT INTO mek_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Iesu eifa pugu einaka, “Lau agofaꞌai papiau eꞌi laomai apalaꞌi faumaꞌi laoma puo, lo laafiia lamaiseina. Lo egaꞌina, laomai apalaꞌi faumaꞌi laoma auga agofaꞌai gaufa koa aisama, pau alou fegama alogaina! ");
INSERT INTO mek_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ke pau lau Deo pinauga epeniiau auga alapafua koa kai, baptismo agaꞌo kiekie akaikiꞌa ipauma auga ekae. Alou kiekiega egaꞌina ageka mo agelao egaꞌina kiekiega alaafia kai agefua. Ke lau egaꞌina kiekie laopolaga aisama, alou ekiekie alogaina. ");
INSERT INTO mek_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ke lau agofaꞌa lamai aisama, oi oopolaga gagao ma lamaiseina ooma? Laaꞌi, iifa gome mo maamiai laifania. Lau gagao alamaiseina kai agukua lamaiseina. ");
INSERT INTO mek_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Pau kina alogai famili agaꞌo alogai papiau auꞌi ima epoꞌiai lau puouai akeꞌeaꞌi. Papiau oiso akeꞌue auniꞌi akepaakekuaniꞌi, ke auniꞌi akeꞌue oiso akepaakekuaniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ke egaꞌina familina alogai akeꞌeaꞌi, ama gauga fou akeakekua, ke gauga ama fou akeakekua. Ke ina gauga ifiaoga fou akeakekua, ke ifiao ina fou akeakekua. Ke papie, gafa papiega fou akeakekua, ke papie gafa, gafa papiega fou akeakekua. Ega koa agemia famili fofouga epoꞌiai akeꞌeaꞌi. ");
INSERT INTO mek_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Egae kai Iesu laꞌafou papiauꞌi epainiꞌi einaka, “Oi apuapu epaꞌumina oisa aisama, fiakoa mo oifa imu ageake ooma ke imu eake. ");
INSERT INTO mek_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ke aꞌuai ameku epua emai aisama, oifa kina ageꞌisapu ooma ke kina eꞌisapu. ");
INSERT INTO mek_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Oi aagoai ke ufa guagai kapaꞌina mo kemia oisaꞌi aisama, ologo oifaniꞌi. Kai ala koa iꞌopoga pau kapaꞌina mo kemia auꞌi alologo aloifaniꞌi. Oi pifoge ipauma aumi! ");
INSERT INTO mek_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ke oi ifomi faumiai kapaꞌina Deo maagai felo, o apala auga kapa puo alologo felo? Egaꞌina kapaꞌi oi fologo felo koa kai alologo felo. ");
INSERT INTO mek_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Au agaꞌo oi iifa ipakainai agepaapaukaiso iifa ipakaina auga eega agolao koa aisama, agolao alogai keagai fokapula foꞌopo epomiai fogagao. Ega afaemia oma koa aisama, isa oi agelaꞌa pupugeiso iifa ipakaina afuga agelaoainio, iifa ipakainai laomai felo, o apala afa epipeni auga oi ipitimagu imagai agepauiso. Ke egaꞌina auga oi tipula afugai ageꞌafo kokoiso. ");
INSERT INTO mek_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Iifa gome maamiai laifania, oi tipula afugai afolopealai tipula eꞌa afa agooge, emi moni agopafua afeꞌaina afegai kai agopealai,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Egaꞌina alogai papiau isaꞌi egae Iesu fou keapa auꞌi, Iesu maagai Pilato Kalilea auꞌi Deo amu kepapaꞌa penia kai eaupuguꞌi ifaꞌi egaꞌina amuꞌi aloꞌiai ekoko fou elapui auga fouga keifania. ");
INSERT INTO mek_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ega aisama Iesu isa epainiꞌi einaka, “Oi oopolaga isa ega kemae oma puo, Kalilea papiauꞌi maꞌoai epoꞌiai isa auꞌi eꞌi laomai apala ipauma, Kalilea papiauꞌi eꞌi apala ekaꞌegaina ma ooma? ");
INSERT INTO mek_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Iifa gome maamiai laifania, laaꞌi ipauma! Oi emi laomai apalaꞌi afoloumakalainiꞌi koa aisama, oi maꞌoai isafa agomae afeꞌai. ");
INSERT INTO mek_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ke Siloam taoaga eꞌualai aisama, papiau 18 eaupuguꞌi auga ologo. Kai oopolaga egaꞌina papiauꞌi eꞌi laomai apala auga, Ierusaleme taoninai keagu papiauꞌi eꞌi apala ekaꞌegainiꞌi ma ooma? ");
INSERT INTO mek_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Iifa gome maamiai laifania, laaꞌi ipauma! Kai oi emi laomai apalaꞌi afoloumakalainiꞌi koa aisama, Deo oi maꞌoai emi laomai afa agepenimi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Egae kai Iesu papiau eꞌi laomai apalaꞌi fekeumakalainiꞌi eoma puo, iꞌina palapole maaꞌiai eifania einaka, “Au agaꞌo ega uma alogai ega uma eꞌima auga, au aka fik efaunia eapa. Egaꞌina afegai uma inagome elao anina agaꞌo eogeisa ma auga gaisa eoma kai anina agaꞌo aeogeisa eisa. ");
INSERT INTO mek_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ega puo elao au egaꞌina uma alo eꞌima auga epainia einaka, ‘Inipo oiso alogai fik auga anina agaꞌo eogeisa ma auga maisa laoma puo lamai kai anina agaꞌo alaisa. Kapa puo aꞌisa fepapinauga aagenia mo? Moaga mopuake!’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Kai au, uma alo eꞌima auga iifa epamue einaka, ‘Au akaikiꞌa aumu, mogafegafe inipo agaꞌomo mo mopeniau. Egaꞌina inipoga alogai gome alaꞌima alakapa felo. ");
INSERT INTO mek_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Egaꞌina alakapa afegai, inipo agaꞌogai anina ageoge koa aisama, felo puo feka. Kai anina agaꞌo afaeoge koa aisama, foaga fopuake,’ eoma.” ");
INSERT INTO mek_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Egaꞌina afegai Iudea papiauꞌi Deo keaufagaina kina agaꞌogai, Iesu laꞌafou afuga agaꞌogai papiau epamaleleniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Egaꞌina alogai melo papiega agaꞌo, tiapolo apala alogai ekoko puo, inipo 18 ofa epakopia eagu. Ega kainai gapea opai auga aekainia, elou mo epea. ");
INSERT INTO mek_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iesu egaꞌina papiega eisa aisama, eifaga elao kai epainia einaka, “Papie, oi ofamu ekopi auga eegai lapafeloiso,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Egae kai Iesu ima isa laagai eogeaua aisama, fiakoa mo ofa eꞌopai eapa opai, ke Deo eau afagaina. ");
INSERT INTO mek_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kai Iesu Deo keau afagaina kinagai papie epafelo puo, laꞌafou afuga eꞌima lopiaga gua ekupu alogaina. Ega kainai isa papiau epainiꞌi einaka, “Iifi agaꞌomo alogai, pinauga kinaꞌi imagea agaꞌomo kekae. Ega puo egaꞌina kinaꞌiai fomai fekepafeloimi kai, Deo aau afagaina kinagai folomai fakepafeloimi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ega aisama Lopia Iesu au egaꞌina ega iifa epamue einaka, “Deo oau afagaina kinagai oi epomiai au agaꞌo ega polomakau o ega donki fei fepenia eoma aisama, ega feufeu afugai aegupuka fei aepenia pagu? Oi pifoge aumi! Isa elao polomakau o donki egupuka elaoaina fei epenia. ");
INSERT INTO mek_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kai iꞌina papiega iꞌa ufuꞌa apaꞌa Abraham okogai amai auga gauga, Satani inipo 18 alogai egopeisa ofa ekopi. Kai Deo oau afagaina kinagai puo, kapaꞌina isa egopeisa auga eegai falapapealaisa ma ooma? Laaꞌi, fapapealaisa paisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iesu egaꞌina eifania aisama, anina akeani auꞌi maꞌoai kemeagai alogaina. Kai papiau auga Iesu kapa akaikiꞌaꞌi maꞌo Deo fekeifagaina kapaꞌi ekapaiꞌi keisaꞌi puo, aloꞌi egama alogaina. ");
INSERT INTO mek_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Egae kai Iesu iꞌina palapole papiau maaꞌiai eifania einaka, “Deo ega agofaꞌa auga ala koa iꞌopoga? Ke kapaꞌina fou alaafi opoꞌi? ");
INSERT INTO mek_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Egaꞌina afuga auga, au aka mastad oga eꞌele ipauma auga koa iꞌopoga. Au agaꞌo au oga egaꞌina eafiia ega umai efaunia, ke euki elao au akaikiꞌa emia. Ke ufa ineiꞌi kemai agagai keiꞌoau,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ke Iesu palapole agaꞌo eifania pugu einaka, “Deo ega agofaꞌa auga kapaꞌina fou alaoge opoꞌi? ");
INSERT INTO mek_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Egaꞌina afuga auga, papie agaꞌo palafa ipaufuga mulamula eafia palafa maꞌo fou eoge lapuinia, fei eꞌefa efiuga kai epuaꞌafuga eka, ke mulamula egaꞌina palafa fofouga alogai epinauga, palafa epaufua auga koa iꞌopoga,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Egaꞌina afegai Iesu Ierusaleme taonina pea epea alogai, taoni ke pagua agaꞌo agaꞌo aloꞌiai ekoko papiau epamaleleniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","Egaꞌina alogai aufalao agaꞌo Iesu epaꞌani penia einaka, “Lopia, papiau oisomo mo Deo kaniaꞌi ageagamauga ma?” eoma. Kai Iesu isa ega iifa epamue alogai, papiau maꞌoai mo maaꞌiai eifa einaka, “Iifa gome maamiai laifania. Papiau maꞌo akeꞌopo Deo ega agofaꞌai kegakoko akeoma kai, ega agofaꞌa paꞌafina eopeope puo maꞌo afaekainiꞌi. Ega puo oi founiaimoimo Deo ega agofaꞌa paꞌafina eopeope mo ganinagai alogai fokoko. ");
INSERT INTO mek_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ke kina agaꞌogai egaꞌina afuga inagome auga ageꞌuegekae paꞌafi agekupuga aisama, oi afegai agoapa paꞌafi agoꞌinipa agogoina agoinaka, ‘Mogafegafe paꞌafi mopaagalaisa amakoko’ agooma. “Kai isa iifa agepamue ageinaka, ‘Oi kaisau ke kapai omai okomi alalogo,’ ageoma. ");
INSERT INTO mek_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Kai oi agoinaka, ‘Lai oi fou aaniani, ke oi isafa emai keagai lopea lopamalelenimai,’ agooma. ");
INSERT INTO mek_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Kai isa iifa agepamue pugu ageinaka, ‘Oi kaisau ke kapai omai auga alalogo. Oi apala ikapa aumi, maꞌoai eeuai okailai!’ ageoma. ");
INSERT INTO mek_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ke oi isa eegai agepiulaimi, ke egae ufuꞌa apaꞌa Abraham, Aisak, Iakobo, ke profeta maꞌoai Deo ega agofaꞌai keague auꞌi agoisaꞌi. Ega aisama agoapepe niemi agoapalolia. ");
INSERT INTO mek_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ke agofaꞌa fofouga kiuga agaꞌo agaꞌogai papiau maꞌoai akemai Deo ega agofaꞌai miamia akaikiꞌa ipauma agemia, egae eꞌi agu afugai akeagu akemiamia. ");
INSERT INTO mek_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kai amoisa, iifa gome kaisau kemuniai auꞌi akeufai, ke kaisau keufai auꞌi akemuniai,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ega aisama Faliseo auꞌi isaꞌi Iesu eega kemai kepainia keinaka, “Herod oi gaaupuguiso eoma puo, iꞌina afuga mopuaꞌafuga afu iꞌoina agaꞌo molao,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kai Iesu einaka, “Folao ago alo amuꞌega, pifoge kupuga auga fopaina, ‘Lau pau papiau aloꞌiai tiapolo keagu auꞌi alapapealaiꞌi, ke isafa papiauꞌi alapafeloꞌi agelaolao kapaꞌina makapa laoma auga alapafua,’ fooma. ");
INSERT INTO mek_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Iifa gome maamiai laifania, profeta epoꞌiai kai agaꞌo Ierusaleme taonina afegai agemae afaekaina. Ega puo pau kapaꞌina lau faagauai femia mo ganinagai, alapinauga mo agelao fuagai mo agefua,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Egae kai Iesu Ierusaleme taonina eisa gua eaniia puo eifa einaka, “O Ierusaleme, Ierusaleme! Ierusaleme taoninai oagu papiaumi, oi profeta oaupuguꞌi, ke Deo papiau eemiai eulaiꞌi auꞌi isafa kepoai ofoupuguꞌi. Ke oꞌolo papiega gauga epakai guguainiꞌi panina papagai epakaisogoniꞌi koa iꞌopoga, lau isafa kina maꞌo alou koꞌagai oi lau gau aumi maafi kaiguguimi laoma kai, oi opamafuisau aniu aloani! ");
INSERT INTO mek_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Maami galao oi emi eꞌa maini ekae, kai agaꞌo egae laaꞌi amoisa. Iifa gome maamiai laifania. Oi lau afoloisau pugu mo agelao agoifa, ‘Lopia akagai emai auga Deo eegai kapa feloꞌi eafia,’ agooma kai agoisau pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Egaꞌina afegai Iudea papiauꞌi Deo keau afagaina kina agaꞌogai, Iesu Faliseo auga akaikiꞌa agaꞌo fou fekeaniani eoma puo ega eꞌa elao. Elao eꞌai ekoko aisama, egae keagu auꞌi Iesu kapa agaꞌo afekapa koa aisama fekeisa keoma puo, aloꞌi koꞌagai keagu keagouka. ");
INSERT INTO mek_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Egaꞌina alogai au agaꞌo faaga kepiufuaina puo, faaga ekiekie alogai auga Iesu agogai eagu. ");
INSERT INTO mek_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ke Iesu egaꞌina auga eisa aisama, Faliseo auꞌi ke Moses ega iifa pamalelega auꞌi fou epaꞌani peniꞌi einaka, “Pau kinagai isafa papiauga agaꞌo ipafelo auga, Moses ega iifa kainai keifa apua o akeifa apua?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Isa isafa auga fefelo auga anina keani kai, Deo keau afagaina kina puo keagu komo mo keoma. Ega puo Iesu egaꞌina auga faagagai eafi epafelo kai eulaisa elao. ");
INSERT INTO mek_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Egae kai Iesu isa epaꞌani peniꞌi pugu einaka, “Deo oau afagaina kinagai oi epomiai aufalao agaꞌo gaumu, o emu polomakau ipuai afeꞌualai koa aisama, fiakoa mo afololao afololaꞌaua ma? Iifa gome, agolao agolaꞌaua paisa!” eoma. ");
INSERT INTO mek_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kai isa komo mo keoma iifa agaꞌo akeifania. ");
INSERT INTO mek_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ke Faliseo auga egaꞌina, papiau iꞌoiꞌi isafa Iesu fou eifa kokoꞌi fou egae keagu. Kai egaꞌina papiauꞌi kelao aniani afugai au akaikiꞌaꞌi fekeagu keoma auga mo afuꞌiai keagu auga eisa. Ega aisama Iesu isa maaꞌiai iꞌina palapole eifania. ");
INSERT INTO mek_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Aufalao agaꞌo ega amagelofe miamiaga amolao amoisa iifaga afepenimi afolao afoisa koa aisama, au akaikiꞌa agaꞌo oi ekaꞌegainimi auga isafa afemai puo, au akaikiꞌaꞌi keagu afuꞌiai foloagu. ");
INSERT INTO mek_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kai oi au akaikiꞌaꞌi fekeagu keoma auga afugai afoagu koa aisama, miamia inagome auga au akaikiꞌaꞌi oi kekaꞌegainimi auꞌi isafa afekemai egaꞌina afugai fekeagu afeoma. Ke isa akemai aisama, miamia inagome auga oi agepainimi, ‘Oi oagu afuga iꞌina auꞌi amopeniꞌi kegaagu,’ ageoma. Ega aisama oi agomeagai alogaina, ke afu kepogu afeꞌai kainai, agolao papiau aageꞌi keagu auꞌi fou afuꞌiai agoagu. ");
INSERT INTO mek_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kai iifa kepenimi egaꞌina miamiaga folao keoma koa aisama, folao papiau aageꞌi keaguagu afugai foagu. Ega koa miamia ekapa auga agemai aisama agepainimi ageinaka, ‘Ekefaꞌau, amoꞌue amolao afu felogai amoagu,’ ageoma. Ega aisama oi fou miamia omai auꞌi agoꞌiai, oi au akaikiꞌami koa iꞌopoꞌi agomia. ");
INSERT INTO mek_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Gome kaisau ifo akaikiꞌa epamia auga, eꞌele agemia. Kai kaisau ifo eꞌele epamia auga, akaikiꞌa agemia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Egae kai Iesu Faliseo auga miamia egaꞌina ekapa auga epainia einaka, “Oi miamia o gaku agaꞌo alokapa papiau alopainiꞌi kegamai alooma aisama, ekefaꞌamu o emu famili ipauma, o aamu akimu o paꞌamuꞌamu auꞌi fou eꞌa opaafe auꞌi mo folopainiꞌi fakemai. Kai oi isa mo alopainiꞌi akemai koa aisama, oi imamu afa kegaoge afekeoma puo afekepainio eꞌi miamia o gaku afolao. Ega koa agemia aisama, oi imamu afa akeoge. ");
INSERT INTO mek_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kai oi miamia alokapa aisama, ulalu papiauꞌi, faagaꞌi emelo auꞌi, ifeꞌi emelo auꞌi, ke maakimiꞌi auꞌi fou fopainiꞌi fekemai fou fomiamia. ");
INSERT INTO mek_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ega alokapa oma aisama, isa oi imamu afa afakeoge mo ganinagai, Deo eegai kapa feloꞌi oi agepenio, ke pakoꞌa papiauꞌi Deo maagai aloꞌi opaina kemia auꞌi akemaunimue kinagai afa felo aloafia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Iesu fou keagu keaniani auꞌi agaꞌo Iesu ega eifa oma aina elogonia aisama epainia einaka, “Deo ega agofaꞌai miamia agemia aisama, au kapa egae ageaniani auga Deo eegai kapa feloꞌi ageafiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ega aisama Iesu au egaꞌina ega iifa palapoleai epamue einaka, “Au agaꞌo miamia akaikiꞌa gakapa eoma puo, papiau maꞌo epainiꞌi fekemai eoma. ");
INSERT INTO mek_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Egaꞌina miamia kina ekainia aisama, ega pinauga auga eulaisa elao miamia fekemai eoma auꞌi epainiꞌi einaka, ‘Kapa maꞌoai kefua kekae puo pau omai fou alao,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Kai egaꞌina papiauꞌi maꞌoai afakelao auga iifaga agaꞌomo keifania, ke aua mo eꞌi pinauga akekapa keoma. Ke epoꞌiai au agaꞌo eifa kaukau einaka, ‘Lau ago agaꞌo pau mo laꞌafaisa, ke falao faisa laoma. Ega puo lagoinio afalafai auga alomafuga folopaꞌaua,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ke au iꞌoina agaꞌo eifa einaka, ‘Lau pau mo polomakau aisoꞌiai lailai kegopeꞌi auꞌi ima laꞌafaiꞌi, ke lalao kepinauga felo ma maꞌopoꞌi laoma. Ega puo lagoinio afalafai auga alomafuga fopaꞌaua,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ke au iꞌoinaga mo agaꞌo eifa einaka, ‘Lau pau mo laamage puo alafai afaekaina,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ega puo pinauga auga miamia fekemai papiauꞌi epiauniꞌi auga, emue elao ega au akaikiꞌa maagai kapaꞌina mo keifania auga eifania. Ega aisama eꞌa inagome auga gua ekupu, ke ega pinauga auga epaini kapulania einaka, ‘Mopaafiafi molao pugu taoni alogai keaga akaikiꞌaꞌiai ke eꞌeleꞌiai isafa mokoko, ulalu auꞌi, faagaꞌi emelo auꞌi, maakimiꞌi auꞌi, ke ifeꞌi emelo auꞌi fou momaiseiniꞌi,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ega kainai pinauga auga egaꞌina elao kapaꞌina fekapa auga ekapaisa efua aisama, emue emai einaka, ‘Au akaikiꞌa aumu, kapaꞌina loifania auga lakapaisa efua kai afu ekae paisa,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ega aisama au akaikiꞌa ega pinauga auga epainia pugu einaka, ‘Molao pagua keagaꞌiai, ke epoepoai papiau keagu auꞌi momaiseiniꞌi ega koa eꞌu eꞌa ake gapogu. ");
INSERT INTO mek_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Iifa gome maamuai laifania, papiau kapaꞌi lapaini kakauꞌi kai akemai auꞌi epoꞌiai aufalao agaꞌomo mo ganinagai lau eꞌu miamia foꞌamaga afaeani opogaina,’ eoma.” ");
INSERT INTO mek_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Egaꞌina afegai papiau maꞌo laꞌafouai Iesu fou kepea. Egaꞌina alogai Iesu eꞌafoaipini isa epainiꞌi einaka: ");
INSERT INTO mek_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kaisau lau eeu emai kai ifo ina ama, akafa, gauga, aaga akina, afakua ke isa mo laaꞌi kai, ifo mo ganinagai anina ageani alogaina koa aisama, lau eꞌu imoi agemia afaekaina. ");
INSERT INTO mek_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ke kaisau ifo ega koloti afaepua, muniuai afaepea auga, lau eꞌu imoi afaemia. ");
INSERT INTO mek_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Amoopolaga, oi epomiai aufalao agaꞌo taoa agaꞌo gapaapa eoma aisama, isa ageagukipo moni pika agepapinauga taoa egaꞌina agepaapa agepafua auga, ageafiꞌopo kakaua. ");
INSERT INTO mek_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kai isa ega koa afaekapa koa aisama, ageꞌina taoa uuꞌuga mo agefauga kai afaepafua. Ega aisama papiau maꞌoai isa akeisa akepaꞌaua akeaꞌalaina ke akeinaka: ");
INSERT INTO mek_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Iꞌina auga augai aeaukipo kai taoa epaapa pau aepafua,’ akeoma. ");
INSERT INTO mek_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“O amoopolaga, kin agaꞌo ega ifani auꞌi 20,000 ke kin iꞌoina agaꞌo ega ifani auꞌi 10,000 auga fou kegaifani eoma. Ega aisama kin agaꞌo auga ega imoi oisomo mo puo, ageagukipo fou akepipaini agekaina ma, afaekaina ma auga ageisa felo kakaua kai fou akepipaini. ");
INSERT INTO mek_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kai ageisa afaekaina aisama, agoma ipaumagai akeapa kai ega imoi isaꞌi ageulai kakauꞌi gagao iifaga akelaoaina. ");
INSERT INTO mek_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ega koa iꞌopoga, oi epomiai kaisau lau eꞌu imoi gamia eoma aisama, isa feagukipo feopola felo kai muniuai fepea. Ke kapa maꞌoai ageumakalainiꞌi kai eꞌu imoi agemia agekaina. Kai kaisau kapa maꞌoai afaeumakalainiꞌi aisama, eꞌu imoi agemia afaekaina. ");
INSERT INTO mek_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Iifa gome kikimalu kapa felo. Kai kikimalu mekiꞌaga agefua aisama, ala akeoma akepamekiꞌania pugu? Akepamekiꞌania pugu afaekaina. ");
INSERT INTO mek_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ke kikimalu mekiꞌaga agefua aisama, aꞌisa o ae igoa fou akeogefouꞌi akepapinauganiꞌi agekaina ma? Laaꞌi, afaekaina! Ega puo akeafia akepuake. “Kaisau aina epaaua auga ainau galogo,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kina agaꞌogai laomai apalaꞌi kekapaꞌi auꞌi epoꞌiai tax keafia auꞌi, ke laomai apalaꞌi kekapaꞌi auꞌi isaꞌi maꞌoai kemai Iesu aina kegalogo keoma puo keapa lofe. ");
INSERT INTO mek_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kai Faliseo auꞌi ke Moses ega iifa pamalelega auꞌi fou ega koa emia keisa aisama, keifa mugumugu keinaka, “Iꞌina auga laomai apalaꞌi kekapaꞌi auꞌi mo ganinagai eifa kokoꞌi fou keaniani,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ega aisama Iesu iꞌina palapole maaꞌiai eifania einaka: ");
INSERT INTO mek_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Amoopolaga! Oi epomiai aufalao agaꞌo sipi 100 eegai keapae kai agaꞌo egea. Ega aisama isa sipi 99 afu ofakaegai afaepuaꞌafuniꞌi kai afaelao agaꞌomo egea auga afaekapuga ma? Laaꞌi, agelao agekapuga paisa! ");
INSERT INTO mek_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Ke isa agekapuga ageisa aisama, ageafia alogamai mo fagogai ageogeaua agepua ega eꞌa agelaoaina. Egae kai ekefaꞌa ke eꞌa ipafe auꞌi fou ageifa kaiguguiꞌi kai ageinaka, ‘Eꞌu sipi egea kai lakapulaisa puo omai fou amaalogama,’ ageoma. ");
INSERT INTO mek_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iifa gome maamiai laifania. Laomai apala ekapa auga agaꞌomo mo ega laomai apalaꞌi eumakalainiꞌi aisama, ufai Deo agogai alogama akaikiꞌa emia, papiau auꞌi 99 aloꞌi opaina eꞌi apala agaꞌo laaꞌi auꞌi eꞌi alogama ekaꞌegaina.” ");
INSERT INTO mek_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ke papie agaꞌo eegai silifa monina ouꞌaga kekae kai agaꞌomo epagea auga amoopolaga. Ega aisama isa lanepa afaepafiaua eaeagai eꞌa alo afaeꞌamuga, ke afu afaegagai felo afaelao afaeisa ma? Iifa gome isa lanepa agepaafiaua eaeagai eꞌa alo ageꞌamuga, ke afu agegagai felo agelao ageisa kai ageapakipo. ");
INSERT INTO mek_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ke isa moni agaꞌomo egaꞌina agekapulaisa aisama, ekefaꞌa ke eꞌa ipafe auꞌi fou ageifa kaiguguiꞌi kai ageinaka, ‘Eꞌu silifa monina egea kai lakapulaisa puo omai fou amaalogama,’ ageoma. ");
INSERT INTO mek_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Iifa gome maamiai laifania. Laomai apala ekapa auga agaꞌomo mo ega laomai apala eumakalaina aisama, Deo ega agelo agoꞌiai alogama akaikiꞌa emia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ke Iesu aeapakipo palapole agaꞌo eifania pugu einaka, “Ega kinagai au agaꞌo ke gauga auniꞌi fou keagu. ");
INSERT INTO mek_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kai kina agaꞌogai eke auga ama epainia einaka, ‘Amau, kapaꞌina lau apu looma auga pau mopeniau,’ eoma. Ega kainai ama gauga auniꞌi epoꞌiai amu eꞌeaiꞌi epeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Egaꞌina afegai epo aemaefa eke auga kapaꞌina mo isa apuga auga epakai guguainiꞌi eafiiꞌi. Egae kai eꞌa epuaꞌafuga ekailai ago agoma elao. Egae ega amu maꞌoai epalakaꞌi ekapa aage mo alogama mo ekapunia. ");
INSERT INTO mek_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ega koa ekapaisa ega kapa maꞌoai epafua afeꞌainiꞌi afegai aisama, eagu ago fofouga alogai magea akaikiꞌa emia. Ega aisama inaega ekimu eulalu alogaina. ");
INSERT INTO mek_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ega puo elao ifo elogoaina ago inagomeꞌi auga agaꞌo papagai epinauga. Egaꞌina auga isa eulaisa ega ago elao ega uma epaaniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kai inaega ekimu alogaina puo, uma foꞌama keania auga foꞌamaga gaania inaega gakapua eoma. Ke kai agaꞌo foꞌama aepenia puo aekainia. ");
INSERT INTO mek_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Kai muniai opolaga eapa opai aisama, ifo mo epainia einaka, ‘Amau ega pinauga auꞌi eeꞌiai foꞌama maꞌo paisa ekae keania ke afa eka aage mo. Kai iꞌina afugai foꞌama laaꞌi inaekimu mo maega lapaꞌaua! ");
INSERT INTO mek_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Lau alamue amau eega alalao alapaina alainaka, ‘Amau, oi ke Deo fou eemiai laomai apala ipauma lakapaisa. ");
INSERT INTO mek_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Lau oi gaumu fopamiaisau auga afaekaina. Ega puo lau oi emu pinauga auꞌi agaꞌo koa iꞌopoga fopamiaisau alaoma,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ega eopola oma aisama, eꞌuegekae ekailai ama eega elao. “Kai isa keagai epea elaolao kai, ama aakai maaga elao isa eisa. Eisa aisama gua eani alogaina, epiau gauga eega elao uufagai ekoko egoapia. ");
INSERT INTO mek_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ega aisama gauga ama epainia einaka, ‘Amau, oi ke Deo fou eemiai laomai apala ipauma lakapaisa. Lau oi gaumu fopamiaisau pugu auga afaekaina,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Kai ama ega pinauga auꞌi epainiꞌi einaka, ‘Ofiakoa! Tiapu felo ipauma omaiseina opaiꞌiuka. Ke lau eꞌu isapu lapipipeni gouga okapa ring imagai amooge. Ke lau gau koꞌa ipauma auga gouga okapa kamata opagafauka. ");
INSERT INTO mek_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ke polomakau gauga efaꞌa auga amoafia omaiseina amoaupugua kai miamia amakapa amaalogama. ");
INSERT INTO mek_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Gome lau gau iꞌina egea kai pau lakapulaisa. Emae kai pau emaunimue koa iꞌopoga,’ eoma. Ega kainai keꞌina miamia kekapaisa kealogama. ");
INSERT INTO mek_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Egaꞌina emia alogai, aaga faꞌaniauga agoai eapa epinauga. Epinauga efua emai eꞌa eegai aisama, kelaꞌafou kegefa kemiamia auga aꞌo elogonia. ");
INSERT INTO mek_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ega puo ega pinauga auꞌi agaꞌo eifaga kai kapaꞌina emia auga paꞌanina epaꞌani. ");
INSERT INTO mek_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ke ega pinauga auga einaka, ‘Oi akimu faagagai kapa agaꞌo aemia emue emai puo, amamu polomakau gauga efaꞌa auga eaupugua amiamialaina,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Aaga faꞌaniau egaꞌina iifaga aꞌo elogonia aisama, gua ekupu alogaina, eꞌai koko epamafua. Ega puo ama epealai elao egoinia fou kekoko kelao eoma. ");
INSERT INTO mek_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kai isa ama epainia einaka, ‘Moisa! Inipo maꞌo oi faumuai lalaꞌafi lapinauga, ke ainamu alapapamafua. Kai oi nani gauga agaꞌomo mo ganinagai, alopeniau ekefaꞌau fou alamiamia. ");
INSERT INTO mek_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kai gaumu iꞌina peage lapau papieꞌi faagaꞌiai emu amu epalaka afeꞌaina kai emue emai. Ega mo ganinagai oi loꞌue isa faugai polomakau gauga efaꞌa auga loaupugua omiamialaina!’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ega aisama ama eifa einaka, ‘Gauagai, oi kina maꞌo mo lau fou aagu, ke kapa maꞌoai lau apu auga oi apumu. ");
INSERT INTO mek_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kai akimu iꞌina auga egea kai lakapulaisa. Isa auga emae kai emaunimue koa iꞌopoga. Ega puo iꞌa miamia alogai akoko fou amaalogama,’ eoma.” ");
INSERT INTO mek_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu palapole egaꞌina eifania afegai, palapole iꞌoina agaꞌo ega imoi maaꞌiai eifania einaka, “Paꞌamuꞌamu auga agaꞌo au agaꞌo eafiia ega amu fofouga eꞌimaiꞌi. Kai papiau isa paꞌamuꞌamu auga ega amu epalaka keoma puo maagai keifania. ");
INSERT INTO mek_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ega puo paꞌamuꞌamu auga ega pinauga auga eifaga ekoko emai aisama epaꞌani penia einaka, ‘Oi lau eꞌu amu lopalaka auga fouga lalogo. Egaꞌina auga kapaꞌina koa lokapa? Pau oi lau eeuai afolopinauga pugu. Ega puo oi lopinauga alogai kapa maꞌoai lokapaiꞌi auꞌi fopapuaꞌi fomaiseiniꞌi faisaꞌi,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ega aisama egae epinauga auga ifo epainia einaka, ‘Eꞌu au akaikiꞌa pinauga eafaniau puo, pau kapaꞌina alakapa eꞌu agu felo agemia? Lau alakapula puo uma alo pinaugaga alakapa afaekaina. Ke papiau eeꞌiai fapinoi auga lameagai. ");
INSERT INTO mek_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kai lau pinauga iꞌina alafua aisama, papiau eꞌi eꞌai fekeifa kokoisau laoma. Ega puo pau kapaꞌina alakapa auga lalogo,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ega puo isa kapaꞌina eopolaga auga ekapaisa. Isa ega au akaikiꞌa auga eegai keapitole auꞌi eifaniꞌi kemai eegai. Ke au agaꞌo eufai emai aisama epaꞌani penia einaka, ‘Lau eꞌu au akaikiꞌa eegai amu pika loapitoleainiꞌi?’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Egaꞌina auga iifa epamue einaka, ‘Olive oilina galons maꞌoai 800 laafiiꞌi,’ eoma. “Ke pinauga auga egaꞌina, apitole auga epainia einaka, ‘Oi emu apitole pepa inamoꞌe. Moagukipo mofiakoa pepai 800 auga moauꞌafuga 400 mopapua,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ke egaꞌina afegai au iꞌoina agaꞌo emai aisama epainia einaka, ‘Lau eꞌu au akaikiꞌa eegai amu pika loapitoleainiꞌi?’ eoma. Ke apitole auga iifa epamue einaka, ‘Palafa puteꞌi maꞌoai 1000 laapitoleainiꞌi,’ eoma. “Ega aisama pinauga auga egaꞌina isa epainia einaka, ‘Oi emu apitole pepa inamoꞌe. Moafia pepai 1000 auga moauꞌafuga 800 mopapua,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Egaꞌina afegai Iesu eifa pugu einaka, “Iifa gome maamiai laifania. Au akaikiꞌa egaꞌina ega pinauga auga ima afuga apala eisa. Kai iꞌina agofaꞌa papiauꞌi keikifa alogaina, ifoꞌi kapa agaꞌo akepalifua kai akekapa akefiakoa imaꞌi afuga afoloisa. Isa auga pakoꞌa papiauꞌi eꞌi ikifa ekaꞌegaina. Ega kainai ega pinauga apala ipauma mo ganinagai, ega pinaugai efiaisakoa mo, ega opopo epafua. Ega puo isa pifogeai epinauga auga, au akaikiꞌa anina aeani. Kai ega mo ganinagai pinauga auga fiakoa mo pinauga epafua kainai au akaikiꞌa isa eifa felo penia. ");
INSERT INTO mek_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Agofaꞌa amuꞌi agoafiꞌi aisama, fiakoa mo kapa agaꞌo eeꞌiai laaꞌi auꞌi fauꞌiai egaꞌina amuꞌi fopapinauga ekefaꞌa fokapa. Ega koa agokapa emi amu agelao afeꞌai aisama, muni ekefaꞌami oi akeifa kokoimi pugu. Ega koa iꞌopoga, Deo ega agofaꞌai oi isafa ageifa kokoimi. ");
INSERT INTO mek_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ke Iesu eifa pugu einaka, “Kaisau alo koꞌagai ega pinauga eꞌele ekapa felo alogaina auga, pinauga akaikiꞌa isafa agekapa felo agekaina. Ke kaisau ega pinauga eꞌele kai pifogeai ekapa koa aisama, pinauga akaikiꞌa isafa pifogeai agekapa. ");
INSERT INTO mek_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ega kainai kai agaꞌo alo koꞌagai agofaꞌa amuꞌi afaekapa feloꞌi koa aisama, kaisau Deo ega agofaꞌai paꞌamuꞌamu koꞌa ipauma auga agepenimi agoꞌima? Kai agaꞌo afaepenimi. ");
INSERT INTO mek_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ke ega koa iꞌopoga, oi alomi koꞌagai aufalao agaꞌo ega amu afoloꞌima feloꞌi koa aisama, kaisau oi ifomi emi amu agaꞌo agepenimi agoꞌima? Kai agaꞌo afaepenimi. ");
INSERT INTO mek_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Iesu eifa pugu einaka, “Pinauga auga agaꞌo au akaikiꞌaꞌi auniꞌi eꞌi pinauga afaekapa agaꞌonia mo. Isa alo koꞌagai agaꞌo anina ageani, ke alo koꞌagai agaꞌo anina afaeani. Ke isa agaꞌo aina ageafi felo, ke agaꞌo aina afaeafi felo. Ega koa iꞌopoga, oi isafa Deo moni fou agopaapafouꞌi eꞌi pinauga agokapa afaekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Kai Faliseo auꞌi moni anina keani alogaina auꞌi Iesu ega eifa oma aina kelogonia aisama, Iesu kepaꞌaua keaꞌalaina. ");
INSERT INTO mek_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ega aisama Iesu isa epainiꞌi einaka, “Oi auga papiau agoꞌiai ifomi alo opai aumi koa iꞌopoga opamiaimi kai, Deo guami alo eisa. Gome kapaꞌina papiau maaꞌiai keisa kapa akaikiꞌa ipauma keoma auga, Deo maagai auga kapa agaꞌo laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ke Iesu eifa pugu einaka, “Moses ega iifa ke profeta eꞌi iifa papiau maaꞌiai keifafoua mo emai Ioane Baptista miagai. Ke Ioane Baptista miagai emai mo pau iꞌina kina alogai, lau iifa faunina Deo ega agofaꞌa fouga papiau maaꞌiai laifafoua. Ke papiau iꞌina iifaga aꞌo kelogonia aisama, ifoꞌi kepaafiꞌi keuniaimoimo Deo ega agofaꞌai kegakoko keoma. ");
INSERT INTO mek_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kai iifa gome, Deo ega iifa auga ufa aagoa fou ekaꞌegainiꞌi. Ega kainai aagoa ufa fou akefua laaꞌi akemia auga agemameꞌa alogaina kai, Deo ega iifa alogai peni kuagai afaꞌagamo mo kepaau opogaina auga afuga agaꞌomo mo ganinagai afaegea,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ke Iesu eifa pugu einaka, “Au agaꞌo akafa agepaake ke papie iꞌoina agaꞌo ageakafania koa aisama, amagelofe akeafia kai fou kefeu aage mo puo apala akekapa. Ke au iꞌoina agaꞌo ipaake papiega ageakafania koa aisama, amagelofe akeafia kai akefeu aage mo puo isa isafa apala akekapa. ");
INSERT INTO mek_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ke Iesu eifa pugu einaka, “Paꞌamuꞌamu auga agaꞌo tiapu feloꞌi ipaumaꞌi umuga eaea aka linen auꞌi eiꞌiukaꞌi, kina maꞌoai eagu felo ke kapa maꞌoai aniꞌi eani auꞌi eegai keka. ");
INSERT INTO mek_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Egaꞌina alogai foꞌama egoigoina auga aka Lasarus, faaga kua epogu auga isafa isa ega fagapu paꞌafina akegai eagu. ");
INSERT INTO mek_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ke amuꞌe kemai faaga kua kekemaiꞌi. Isa inaega ekimu alogaina puo alafai gaoma paꞌamuꞌamu auga eaniani teipologai foꞌama ameꞌafuꞌi keꞌualai auꞌi gaaniꞌi eoma. ");
INSERT INTO mek_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Egaꞌina afegai pinoi auga ega mae kina emai aisama emae. Ke Deo ega agelo kemai isa keafiia kelaoaina Abraham eegai kepaagua. Egae kai paꞌamuꞌamu auga isafa emae, ke papiau isa kelaoaina kefufunia. ");
INSERT INTO mek_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kai isa ipeli elao egae eagu ekiekie alogaina. Kai isa maaga ekiakae aisama, maaga elao agoma ipaumagai Abraham eegai Lasarus eagu eisa. ");
INSERT INTO mek_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ega aisama isa Abraham eifaga einaka, ‘Amau Abraham, guau moania. Lau iꞌina logai laaga faagau eꞌisapu, ke lakiekie alogaina puo Lasarus moulaisa ima kekeꞌe kuagai fei afaꞌagamo gaꞌiupa gamai malau mo gapakekeꞌania,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Kai Abraham iifa epamue einaka, ‘Gauagai, oi aagoai loagu aisama, emu agu alogai kapa maꞌoai feloꞌi mo loafiiꞌi lopapinauganiꞌi kai Deo ega iifa kaiꞌiai alopea auga moopolaga. Kai egaꞌina alogai Lasarus kapa apalaꞌi mo eafiiꞌi kai isa Deo epakoꞌania puo, Deo isa agu felo epeniia inae eague. Kai oi auga egae lokiekie alogaina. ");
INSERT INTO mek_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Egaꞌina mo laaꞌi kai, Deo iꞌa epoꞌaisai laloa akaikiꞌa ipauma ekapaisa ekae. Ega puo kaisau inae keagu auꞌi ega kegafai akeoma afaekaina. Ke ega koa iꞌopoga mo, egae keagu auꞌi isafa afakepagai iina afakemai,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ega aisama paꞌamuꞌamu auga iifa epamue einaka, “Amau lagoinio, Lasarus moulaisa amau ega eꞌa galao. ");
INSERT INTO mek_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Gome lau akiu ima egae keague. Lasarus isa ainaꞌi fepalogo ega koa isa isafa lau lakapa koa iꞌopoga fakekapa, iꞌina kiekie akaikiꞌa ipauma afuga fakemai,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Kai Abraham iifa epamue einaka, ‘Isa Moses ke profeta eꞌi iifa eeꞌiai kekae puo mopuaꞌafuniꞌi egaꞌina iifaꞌi aꞌoꞌi kegalogo,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Kai paꞌamuꞌamu auga eifa pugu einaka, ‘Laaꞌi, amau Abraham, isa eꞌi iifa aꞌo kelogo kai afakepakoꞌania. Kai mae afugai aufalao agaꞌo agelao agepainiꞌi koa aisama, ega iifa aꞌo akelogo ke eꞌi laomai apalaꞌi akeumakalainiꞌi,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Kai Abraham isa epainia pugu einaka, ‘Isa Moses ke profeta eꞌi iifa aꞌo afakelogo koa aisama, aufalao agaꞌo maeai agemaunimue agelao agepainiꞌi mo ganinagai afakepakoꞌania aina afakeafia,’ eoma.” ");
INSERT INTO mek_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu ega imoi epainiꞌi pugu einaka, “Kapaꞌina papiau eꞌi laomai apala epamia auꞌi akemai afakefuafua. Kai au kapa faagagai egaꞌina kapaꞌi kemai auga, Deo isa ega laomai apala afa fepenia laoma. ");
INSERT INTO mek_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ke kaisau apoke papiauꞌi iꞌina agaꞌo laomai apala agepakina agekapa auga, ega laomai apala ipauma agemia. Ega puo felo auga egaꞌina auga aisogai foꞌama kepaikumuꞌa kepo akaikiꞌa fekepaaukopa aꞌuai fekepiulaisa fekogo. Kai isa feagu apoke papiauga agaꞌo laomai apala fepakina fekapa auga apala ipauma. ");
INSERT INTO mek_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ega kainai kapa agaꞌo amokapa agooma aisama, foisa felo kai fokapa. “Ke aami akimi agaꞌo laomai apala agekapa aisama, fofina. Ke isa ega laomai apala ageumakalaina koa aisama, ega apala foꞌagegeaina. ");
INSERT INTO mek_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ke isa kina agaꞌomo alogai eemuai laomai apala ikapa imagea kuagai gua agepamia kai, agemue agemai ipainimu imagea kuagai gua agepamia ageinaka, ‘Lau eꞌu laomai apala laumakalaina,’ ageoma koa aisama, ega laomai apala foꞌagegeaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ke Lopia Iesu ega imoi isa kepainia keinaka, “Lai emai pakoꞌa akaikiꞌa mopamia!” keoma. ");
INSERT INTO mek_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ega aisama Lopia palapoleai eifa einaka, “Oi pakoꞌa au aka mastad oga eꞌele ipauma koa iꞌopoga mo ganinagai eemiai ageka koa aisama, apaniꞌi auga agopaina, ‘Ifomu mofuauiso molao aꞌuai mofaunio,’ agooma, ainami ageafia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ke Iesu eifa pugu einaka, “Ke oi eemiai kalaꞌafi agaꞌo eague sipi eꞌimaꞌi, o emi agoai efani auga amoopolaga. Isa ega pinauga agepafua agemai aisama, oi isa afopaina gafiakoa gaagukipo gaaniani afooma ma? Laaꞌi! ");
INSERT INTO mek_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Isa ega pinauga agepafua agemue agemai, ke afolopaina gapigapi foꞌamaga mokapa mofua moagu lau alaaniani alogai foꞌimaisau, egae kai oi ifomu foaniani afolooma ma? E, ega alooma! ");
INSERT INTO mek_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ke kalaꞌafi auga oi kapaꞌina loifania auga maꞌoai ekapaꞌi puo, maagai tenkiu afoifania ma? Laaꞌi! ");
INSERT INTO mek_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ega puo oi isafa lau kapaꞌina lapainimi auga maꞌoai okapa afeꞌainiꞌi aisama foifa, ‘Lau oi emu pinauga ikapa au. Eꞌu pinauga fakapa auga mo lakapaisa fooma,’” eoma. ");
INSERT INTO mek_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Egaꞌina afegai Iesu ega imoi fou Ierusaleme taonina pea kepea alogai, Kalilea Samaria agoꞌi fou paisoaꞌiai kepea pagai. ");
INSERT INTO mek_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ke pagua agaꞌogai kekoko aisama, molumolu isafaga keafia auꞌi, auꞌi ouꞌaga fou kepiaogai. Kai Iudea papiauꞌi eꞌi kagakaga kainai molumolu auꞌi papiau epoꞌiai fakelao fakemai keoma. ");
INSERT INTO mek_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ega puo aakai mo keapa kai aisoꞌi gomegai keagaga Iesu keifaga keinaka, “Iesu, au akaikiꞌa aumu, guamai moania!” keoma. ");
INSERT INTO mek_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ke Iesu maaga elao isa eisaꞌi aisama epainiꞌi einaka, “Amolao faagami sakedote amopakinaꞌi ega koa sakedote faagami felo emia auga emi kagakaga kainai papiau maaꞌiai fekeifafoua,” eoma. Ke Iesu ega iifa kainai, molumolu auꞌi keagai kelaolao kai faagaꞌi felo emia. ");
INSERT INTO mek_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Egaꞌina alogai molumolu auꞌi ouꞌaga epoꞌiai agaꞌo faaga felo emia eisa aisama, aiso gomegai eagaga Deo eau afagaina, ke emue Iesu eega elao. ");
INSERT INTO mek_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Elao Iesu eisa aisama, ife foꞌinai eꞌualai eomukipo tenkiu epeniia. Au egaꞌina Iesu tenkiu epenia auga Samaria auga. ");
INSERT INTO mek_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ke Iesu au egaꞌina epaꞌani penia einaka, “Oi aumi maꞌoai ouꞌaga faagami aefelo ma? Oi maꞌoai lapafeloimi. Kai imagea kuagai pani auꞌi kapai? ");
INSERT INTO mek_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Iꞌina Samaria paguama auga faemai koa iꞌopoga kai emue emai Deo eau afagaina. Kai egaꞌina isaꞌi auꞌi maꞌoai ala kelao akemai Deo akeau afagaina!” eoma. ");
INSERT INTO mek_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Egae kai Iesu au egaꞌina epainia einaka, “Moꞌue molao, oi emu pakoꞌa epafeloiso, ke kaniamu isafa eagamauga,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Kina agaꞌogai Faliseo auꞌi Deo ega agofaꞌa gaika agemai auga paꞌanina Iesu kepaꞌani penia. Ega puo Iesu eifa einaka, “Deo ega agofaꞌa emai efua epomiai kai oi alologo. Egaꞌina afuga auga kapa agaꞌo maamiai oisa felo emai koa iꞌopoga laaꞌi. Ega puo kai agaꞌo afaeisa afaeifa afaeinaka, ‘Inamoꞌe amoisa’ afaeoma. ");
INSERT INTO mek_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","O ‘Egamoꞌe amoisa’ afaeoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Iesu Faliseo auꞌi maaꞌiai eniniꞌani efua aisama, ega imoi epainiꞌi einaka, “Papiau Aumauni Gauga kina agaꞌo agekaina aisama agemue agemai. Oi alafai amooma egaꞌina kinaꞌi agaꞌomo ganinagai amoisa agooma kai, kina alologo auga kinagai agemai puo afaekainimi afoloisa. ");
INSERT INTO mek_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ke papiau oi akepainimi, ‘Papiau Aumauni Gauga inamoꞌe amoisa!’ o ‘Egamoꞌe amoisa!’ akeoma mo ganinagai, muniꞌiai folopiau fololao. ");
INSERT INTO mek_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gome Papiau Aumauni Gauga ega mai pugu kina auga, kimage koa iꞌopoga ageafi, eaea ufa apie ageafia agelao ufa apie ageafia papiau maꞌoai akeisa felo. ");
INSERT INTO mek_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kai isa ega kina aemai koa kai iꞌina papiauꞌi isa akeumakalaina kainai, kapa maꞌo mo kiekieꞌi agepaꞌau kakauꞌi. ");
INSERT INTO mek_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","“Ke Papiau Aumauni Gauga agemai kina auga, Noa miagai koa iꞌopoga. Noa sikuna ekapaisa alogai, papiau faagaꞌiai kapaꞌina agemia auga akepakoꞌania. Kai keaniani keinuinu, ifoꞌi epoꞌiai keamage elao mo Noa ega famili fou sikunai kekoko. Ke kou akaikiꞌa ipauma emai aisama, papiau epaoka afeꞌainiꞌi. Ega koa iꞌopoga, Papiau Aumauni Gauga agemai kina aisama, pau papiauꞌi isafa ega koa akekapa. ");
INSERT INTO mek_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ke Papiau Aumauni Gauga agemai kina auga isafa, Lot miagai emia koa iꞌopoga agemia. Lot miagai papiau eꞌi laomai apalaꞌi ipaumaꞌi akeumakalainiꞌi, ke Deo akepakoꞌania. Kai keaniani keinuinu, amu keafiiꞌi, ke isaꞌi keꞌafaꞌafalainiꞌi. Ke foꞌama kefauniꞌi, ke eꞌa maꞌo kepaapaꞌi. ");
INSERT INTO mek_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kai Lot ega famili fou Sodom taonina kepuaꞌafuga aisama, ufai lo ke mulamula isapuga ipauma laofaga, imu koa iꞌopoga eake papiau epaoka afeꞌainiꞌi. Ega koa iꞌopoga, Papiau Aumauni Gauga agemai kina aisama, pau papiauꞌi isafa ega koa akekapa. ");
INSERT INTO mek_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Iifa gome Papiau Aumauni Gauga ifo papiau eeꞌiai ageapafoki kina iina koa iꞌopoga. ");
INSERT INTO mek_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Egaꞌina kinagai kina maaga agaꞌo laaꞌi puo, aufalao agaꞌo eꞌa ofaofagai laagai afugai ageagu auga, ega amu eꞌa alogai kekae auga faeake faeafiꞌi. Ega koa iꞌopoga, aufalao agaꞌo agoai eapae auga kapa agaꞌo isafina faelao. ");
INSERT INTO mek_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Egaꞌina kinagai Lot akafa faagagai kapaꞌina emia auga foopolaga. ");
INSERT INTO mek_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kaisau ifo kania gaagamauga ageoma aisama, ega agu agepagea. Ke kaisau lau puouai ega agu felo agepagea aisama, ega agu afa ageafia. ");
INSERT INTO mek_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Iifa gome maamiai laifania. Egaꞌina kina gapinai, au auniꞌi afu agaꞌomogai akefeu kai Deo agaꞌo ageafiꞌaua, ke agaꞌo agepuaꞌafuga. ");
INSERT INTO mek_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Ke papie auniꞌi palafa kepapaikumuꞌa kai, Deo agaꞌo ageafiꞌaua, ke agaꞌo agepuaꞌafuga,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Iesu ega eifa oma afegai, ega imoi isa kepaꞌani penia keinaka, “Lopia, kapai iꞌina kapaꞌi akemia?” keoma. Ke Iesu einaka, “Mae agaꞌo kapai eka auga, paili isafa egae kekaigugu. Ega koa iꞌopoga, kapai iꞌina kapaꞌi akemia auga agologo agofiakoa puo afolopaꞌani,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Egae kai Iesu ega imoi aufa kina fekemegamega fakeapakipo auga fouga palapoleai maaꞌiai eifania. ");
INSERT INTO mek_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Isa einaka, “Taoni agaꞌogai iifa ipakainai, au agaꞌo papiau eꞌi niniꞌani aꞌo elogo kai, felo o apala eifania auga eagu. Isa Deo aemaniꞌiaina ke papiau isafa gefaꞌi aeaunia. ");
INSERT INTO mek_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ke egaꞌina mo taoninai afuafu agaꞌo isafa eagu. Ke isa aufa kina egaꞌina auga eega elao egoinia einaka, ‘Mogafegafe mopalagainiau lau eeuai apala ekapa auga iifa ipakainai mopaꞌopaina,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Kai kina maꞌo elao epainia mo ganinagai, au egaꞌina iifa ipakaina eumaka. Kai afuafu isafa aeapakipo, isa eega elao egoinia aefuafua. Ke fuagai aisama, iifa ipakaina auga ifo alogai eifa einaka, ‘Lau Deo alamaniꞌiaina ke papiau isafa gefaꞌi alaauga. ");
INSERT INTO mek_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Kai iꞌina afuafuga aau epaufa aefuafua puo ega iifa alapakaisa. Ega koa alakapa aisama, isa ageapakipo afaemai, ke afaepaafipuguisau pugu!’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Iesu egaꞌina palapole eifania afegai, eifa pugu einaka, “Au egaꞌina ega laomai apala, Deo ke papiau aemaniꞌiainiꞌi auga ifo mo kapaꞌina eifania auga aꞌo amologo. ");
INSERT INTO mek_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kai oi emi Deo auga felo ipauma. Ega puo Isa ekinaniꞌi auꞌi aufa kina gapi gani eega kemai keagaga penia auga ainaꞌi afaeafia, eꞌi iifa afaepakaisa ke paakai paakai ainaꞌi afaelogo ma? Koꞌa ipauma, kaisau Isa eega kelao keagaga penia auꞌi ainaꞌi agelogo paisa! ");
INSERT INTO mek_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iifa gome maamiai laifania. Isa papiau egaꞌina eꞌi iifa agepakaisa agefiakoa. Ega mo ganinagai Papiau Aumauni Gauga agemai kinagai agofaꞌai papiau maꞌoai eꞌi pakoꞌai akemegamega afakeapakipo ma ageisaꞌi? Laaꞌi ipauma! ");
INSERT INTO mek_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ke Iesu papiau ifoꞌi Deo maagai alo opai auꞌi keoma kai papiau isaꞌi auga keisa papaꞌi auꞌi kaiꞌiai iꞌina palapole eifania. ");
INSERT INTO mek_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Isa ega niniꞌaniai iina eifa oma einaka, “Faliseo auga agaꞌo ke tax eafia auga agaꞌo auniꞌi kegamegamega keoma puo kelao Deo ega eꞌai kekoko. ");
INSERT INTO mek_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Egae kai Faliseo auga egaꞌina eꞌue eapa kai emegamega Deo maagai ifo fouga eifania einaka, ‘Deo, lau auga papiau isaꞌi koa laaꞌi. Lau alou opaina, alapainao, amagelofe keafia auꞌi fou alafeu aage mo. Ke lau au iꞌina tax eafia auga koa iꞌopoga laaꞌi. ");
INSERT INTO mek_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Lau iifi agaꞌomo alogai, gope auniꞌi lapamia ke kapa maꞌoai eeuai kekae auꞌi ouꞌaga epoꞌiai agaꞌomo laoge meꞌe, Deo oi lapaꞌa penio,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Kai tax eafia auga ifo eopolaga Deo maagai ageapa afaekaina eoma puo, agomaai mo eapa ke ufa isafa aeakae penia. Kai ifo ega laomai apalaꞌi eopolaniꞌi puo olaga eauniia kai eifa einaka, ‘Deo lau laomai apala ipauma au, guau moania,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Iesu palapole egaꞌina eifania afegai, iina eifa oma einaka, “Iifa gome maamiai laifania. Kaisau ifo eau afagaina auga eꞌele agemia. Ke kaisau ifo eꞌele epamia auga akaikiꞌa agemia. Ega puo egaꞌina auꞌi auniꞌi epoꞌiai tax eafia auga Deo maagai alo opaina emia emue ega eꞌa elao. Kai Faliseo auga auga Deo maagai alo opaina aemia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kina agaꞌogai papiau Iesu imoi eꞌeleꞌi isafa gaafi opogainiꞌi keoma eega kemaiseiniꞌi. Kai Iesu ega imoi papiau iina kekapa oma keisaꞌi aisama kefinaiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kai Iesu imoi eꞌeleꞌi eifaniꞌi eega kemai kai eifa einaka, “Imoi eꞌeleꞌi folokaisapuꞌi eeu kegamai. Gome Deo ega agofaꞌa auga papiau imoi eꞌeleꞌi iina koaꞌi kemia auꞌi apuꞌi. ");
INSERT INTO mek_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Iifa gome maamiai laifania. Kaisau imoi eꞌele koa afaemia Deo ega agofaꞌa afaepakoꞌania koa aisama, Deo ega agofaꞌai afaekoko,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Egaꞌina afegai paꞌamuꞌamu auga akaikiꞌa agaꞌo Iesu epaꞌani penia einaka, “Pamalele felo aumu, lau kapaꞌina fakapa agu pagai maunina faafia?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ke Iesu isa ega iifa epamue einaka, “Kapa puo loifaniau au felou looma? Oi loopolaga lau Deo eegai lamai puo, loifaniau au felou looma, o oi ifomu opomuai lau loifaniau felou looma? Agofaꞌa fofouga alogai kai agaꞌo felo laaꞌi kai Deo ifogamo mo felo ipauma. ");
INSERT INTO mek_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ke oi Deo ega iifa Moses epeniia auꞌi aꞌoꞌi lologonia efua. Egaꞌina iifaꞌi aloꞌiai eifa: ‘Amage lofe akeafia auꞌi fou folofeu. Kai agaꞌo foloaupugua, folopainao, pifogeai papiau agaꞌo puo folopenia, ke inamu amamu fopalopianiꞌi,’” eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kai au egaꞌina eifa einaka, “Egaꞌina kapaꞌi maꞌoai eꞌeleuai laafiꞌiniꞌi mo emai pau,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iesu iꞌina aꞌo elogonia aisama, au egaꞌina epainia pugu einaka, “Maꞌoai lokapaiꞌi kai agaꞌomo alokapa koa. Emu amu maꞌoai foꞌafaꞌafalainiꞌi, monina foafia ulalu auꞌi fopeniꞌi. Ega alokapa oma aisama, emu amu aagoai loꞌafaꞌafalainiꞌi auꞌi afa ufai aloafia. Egae kai fomai muniuai fopea,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kai egaꞌina auga Iesu ega eifa oma aina elogonia aisama, eegai amu maꞌo keka puo eopolaniꞌi alo emafu alogaina. ");
INSERT INTO mek_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ke Iesu egaꞌina auga alo emafu alogaina eisa aisama, ega imoi epainiꞌi einaka, “Paꞌamuꞌamu auga Deo ega agofaꞌai gakoko ageoma auga ageꞌinoka alogaina. ");
INSERT INTO mek_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Koꞌa ipauma! Kamelo tiapu ikai nilaga inegai agekoko agekaina. Kai paꞌamuꞌamu auga Deo ega agofaꞌai gakoko auga ageꞌinoka alogaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Iesu ega imoi iꞌina iifaga aꞌo kelogonia aisama, kekauai alogaina, ke Iesu kepaꞌani penia keinaka, “Ega koa aisama, Deo kaisau kania ageagamauga? Amaopolaga aoma aekaina!” keoma. ");
INSERT INTO mek_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ke Iesu isa eꞌi iifa epamue einaka, “Kapaꞌina papiau eeꞌiai afaekaina auga, Deo eegai agekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ega aisama Peto Iesu epainia einaka, “Lai oi munimuai fapea aoma puo kapa maꞌoai apuaꞌafuniꞌi!” eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Ega aisama Iesu ega imoi epainiꞌi einaka, “Iifa gome maamiai laifania. Kaisau Deo ega agofaꞌa kainai ega eꞌa, akafa, aaga akina, ina ama fou, o gauga agepuaꞌafuniꞌi aisama, iꞌina agofaꞌagai ageagu alogai amu epuaꞌafuniꞌi mo afaeafiꞌi kai, laagai kapa iꞌoiꞌi isafa ageafiꞌi. Ke muni isa Deo ega agofaꞌai agu pagai maunina isafa ageafia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kina agaꞌogai Iesu ega apostolo 12 eꞌafeiniꞌi laꞌafou kepuaꞌafuga kelao meꞌegai kai epainiꞌi einaka, “Iꞌa Ierusaleme taonina agalao. Ke profeta Papiau Aumauni Gauga fouga kepapua auga maꞌoai, Deo ega logoai koꞌaꞌi mo egae akemia. ");
INSERT INTO mek_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Egae Iudea au akaikiꞌaꞌi auꞌi Papiau Aumauni Gauga akeafia Iudea papiauꞌi laaꞌi auꞌi imaꞌiai akepaua. Ke egaꞌina papiauꞌi isa akepaꞌaua akeaꞌalaina, akeꞌupe, akegapuka, ke akeaupugua. ");
INSERT INTO mek_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kai kina oiso aisama agemaunimue pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kai Iesu ega imoi Iesu ega niniꞌani egaꞌina maꞌoai agaꞌomo mo ganinagai oko akelogo. Ke Deo isa eeꞌiai eogefakeꞌi puo Iesu kapaꞌina fouga eifania auga oko akelogo. ");
INSERT INTO mek_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Egaꞌina afegai Iesu ega imoi fou kelao Jeriko taonina kainagai aisama, maakimiꞌi auga agaꞌo egaꞌina keagaga meꞌegai eagu epinoi. ");
INSERT INTO mek_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Isa papiau laꞌafouai kepea pagai aꞌoꞌi elogonia aisama, kapaꞌina emia auga paꞌanina epaꞌani. ");
INSERT INTO mek_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ke papiau isa kepainia keinaka, “Iesu Nasareta auga emai elao,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ega aisama maakimiꞌi auga eagaga einaka, “Iesu, Davide okogai lomai aumu, guau moania!” eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kai Iesu agogai kepea keaga keaꞌa mala auꞌi, maakimiꞌi auga kefinaisa komo gaoma keoma. Kai maakimiꞌi auga eagaga alogaina paisa einaka, “Davide okogai lomai aumu, guau moania!” eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ega aisama Iesu eapakipo papiau isaꞌi epainiꞌi au egaꞌina isa eega kegamaiseina eoma. Ke kemaiseina eegai aisama, Iesu isa epaꞌani penia einaka, ");
INSERT INTO mek_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Oi kapaꞌina anina loani eemuai makapa looma?” eoma. Ke isa einaka, “Lopia, maau gakiakae afu maisa laoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ega aisama Iesu isa epainia einaka, “Oi lopakoꞌaniau kainai, maamu gafelo,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ega aisama fiakoa mo au maaga felo emia Deo eau afagaina ke Iesu muninai epea. Egae papiau maꞌoai au maaga felo emia keisa aisama, isa isafa Deo keau afagaina. ");
INSERT INTO mek_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Egaꞌina afegai Iesu ega imoi fou Jeriko taonina alogai kekoko kepea. ");
INSERT INTO mek_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Egaꞌina taonina alogai paꞌamuꞌamu auga ke tax keafia auꞌi kaniaꞌiai auga aka Sakeo eagu. ");
INSERT INTO mek_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Iesu epea pagai alogai Sakeo Iesu kaisau auga gaisa eoma. Kai laꞌafou akaikiꞌa alogaina, ke isa paoga ofolaꞌo ipauma puo Iesu feisa auga aekainia. ");
INSERT INTO mek_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kai Sakeo Iesu ala agepea oma auga elogo. Ega puo eufai epiau elao au aka sikamo keoma augai eꞌagaukae eagu Iesu eꞌimaisa. ");
INSERT INTO mek_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ke Iesu emai au egaꞌina papagai aisama, eakae Sakeo auai eagu eisa. Ega puo epainia einaka, “Sakeo moake mofiakoa. Pau oi emu eꞌai fou agaagu,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Iesu ega eifa oma aisama, Sakeo eake efiaisakoa mo ke alogamai mo Iesu eifa koko ega eꞌa elaoaina. ");
INSERT INTO mek_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Papiau maꞌoai Sakeo Iesu eifa koko ega eꞌai fou kekoko keisa aisama, keifa mugumugu keinaka, “Iesu laomai apala ipauma ikapa auga ega eꞌai fou kekoko keaniani,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Iesu Sakeo ega eꞌai fou keagu keaniani alogai, Sakeo eꞌue Iesu epainia einaka, “Lopia moisa. Lau pau eꞌu amu fofouga ipuainagai maaupea maꞌea, apie ulalu auꞌi mapeniꞌi laoma. Ke pifogeai kaisau eeꞌiai kapa isaꞌi laafiiꞌi koa aisama, egaꞌina kapaꞌi laafiiꞌi auꞌi afaꞌi alapenimueꞌi, ke laagai pani koa iꞌopoga alaogeaua,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Ega aisama Iesu Sakeo epainia einaka, “Lau Papiau Aumauni Gauga, laomai apala kekapa Deo maagai kegea auꞌi makapuniꞌi, ke kaniaꞌi maagamauga laoma puo lamai. Ke pau kina Deo iꞌina eꞌa papiauꞌi kaniaꞌi eagamauga. Ke Sakeo ega laomai apalaꞌi epuaꞌafuniꞌi auga, ufuꞌa apaꞌa Abraham ekapakapa koa iꞌopoga, Deo maagai laomai felo ekapaisa. Ega puo Deo isa isafa kania eagamauga, ke Abraham ufuga apa emia efua,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sakeo ega eꞌai keagu papiauꞌi Iesu ega eifa oma auga aina kelogonia. Ke Iesu emai Ierusaleme taonina kainagai puo, papiau keopolaga isa Ierusaleme taoninai agekoko aisama, fiakoa mo Deo ega agofaꞌa mamaga agepaꞌuegenia keoma. Ega puo Iesu eniniꞌani aeapakipo, papiau Deo ega agofaꞌa ala fekeꞌima oma auga fouga palapoleai eifania. ");
INSERT INTO mek_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ke ega niniꞌaniai papiau epainiꞌi einaka, “Au akaikiꞌa agaꞌo lopia ifagai emauni auga, afu agoma ipauma elao egae ifo faugai kin ega isapu feafia ke femue femai eoma. ");
INSERT INTO mek_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ega puo ega pinauga auꞌi ouꞌaga eifaniꞌi kemai ke mina agaꞌo agaꞌo epeniiꞌi ke epainiꞌi einaka, ‘Lau afu agoma alalao puo moni iꞌina foafia fopapinauga felaolao alamue alamai kai fopeniau pugu,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Egae kai egaꞌina auga isa epuaꞌafuniꞌi afu agoma elao. Kai isa ega agofaꞌa papiauꞌi isa kin femia auga kepamafua, anina akeani. Ega puo egaꞌina papiauꞌi au isaꞌi keulaiꞌi isa muninai kelao kin akaikiꞌa ipauma fekepaina, au egaꞌina isa eꞌi kin faepamia keoma. ");
INSERT INTO mek_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Kai papiau isa kin faemia keoma mo ganinagai, isa kin emia paisa kai emue emai afugai pugu. Ega aisama isa ega pinauga auꞌi moni epeniꞌi kepapinauga auꞌi, egaꞌina monina ala kepapinauga oma auga feisa eoma puo eifaniꞌi kemai. ");
INSERT INTO mek_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Ke ega pinauga auga eufai emai auga isa epainia einaka, ‘Oi mina agaꞌomo lopeniiau kai lapapinauga alogai, mina ouꞌaga mo laagai laogeaua inamoꞌe,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ega aisama au akaikiꞌa einaka, ‘Eꞌu pinauga felo aumu, kapa eꞌele lapeniio kai alomu koꞌagai lopinauga felo pau akaikiꞌa lopamia puo, egaꞌina pinauga afa taoni ouꞌaga alapenio foꞌimaꞌi,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Egaꞌina afegai pinauga auga iꞌoina agaꞌo emai eifa einaka, ‘Au akaikiꞌa aumu, oi mina agaꞌomo lopeniiau kai lapapinauga alogai, mina ima mo laagai laogeaua inamoꞌe,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ega aisama au akaikiꞌa einaka, ‘Oi isafa pinauga felo aumu, lopinauga felo puo egaꞌina pinauga afa taoni ima alapenio foꞌimaꞌi,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","“Egaꞌina afegai pinauga auga iꞌoinaga mo agaꞌo emai eifa einaka, ‘Au akaikiꞌa aumu. Oi aꞌao aumu ke guamu inoka puo kapa agaꞌo oi apumu laaꞌi kai apumu lopamia. Ke kapa agaꞌo alofauga kai aufalao agaꞌo kapa felo efauga auga anina loafia. Ke moni lopeniiau auga fapapinauga felo, o fapapinauga apalania mo ganinagai lomai aisama, fofouga foafi afeꞌaina auga lalogo. Ega puo lamaniꞌi alogaina emu moni alapapinaugania kai tiapuai lamokaisa laoge meꞌe. Egaꞌina monina oi apumu auga pau inamoꞌe,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ega aisama au akaikiꞌa pinauga auga egaꞌina epainia einaka, ‘Oi pau kapaꞌina loifania auga iꞌopoga mo faagamuai alakapa. Oi laomai apala ikapa aumu! Oi lologo lau apalau guaꞌinoka au, ke kapa agaꞌo alafauga kai aufalao agaꞌo kapa felo efauga auga anina laafia looma? ");
INSERT INTO mek_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ega koa aisama, kapa puo moni lapeniio auga panikai aloogeisa. Moni panikai mooge koa aisama, pau lau lamai aisama, panikai epinauga afa agaꞌo laagai fekeogeaua faafia,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Egae kai au akaikiꞌa auga, egae keapa auꞌi epainiꞌi einaka, ‘Isa ega moni imagai amoafia au epinauga felo mina ouꞌaga eafia auga amopenia,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Kai papiau egae keapa auꞌi isa ega iifa kepamue keinaka, ‘Au akaikiꞌa aumu, isa mina ouꞌaga eafiia efua!’ keoma. ");
INSERT INTO mek_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Kai au akaikiꞌa iifa epamue einaka, ‘Iifa gome maamiai laifania. Kaisau lapaina ke ainau eafia epinauga felo auga afa felo ageafia. Ke afa felo egaꞌina pau eafia koa iꞌopoga, ke laagai maꞌo alapenia. Kaisau lapaina kai ainau aeafia aepinauga felo auga eꞌele lapenia auga mo ganinagai alaafimue pugu. ");
INSERT INTO mek_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ke lau eꞌu ou auꞌi lau kin famia, ke isa faꞌimaꞌi auga anina akeani auꞌi maꞌoai amomaiseiniꞌi inae agouai amoaupuguꞌi,’ eoma.” ");
INSERT INTO mek_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iesu egaꞌina palapole eifania afegai, eufai Ierusaleme taonina elao kai ega imoi auꞌi muniai kai kelao. ");
INSERT INTO mek_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Ke kelao Betani ke Betfake paguaꞌi kelaisapiꞌi iku aka Olifa keoma auga ikugai aisama, Ierusaleme taonina kainagai ipauma. Egaꞌina alogai Iesu ega imoi auniꞌi epainiꞌi einaka, “Folao pagua agoꞌaisai auga alogai fokoko, ke egae donki aguꞌa agaꞌo kai agaꞌo laagai aeaguaguka auga kepaaukopa eapae agoisa. Egaꞌina donkina fogupuka foafia fomaiseina inae. ");
INSERT INTO mek_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ke aufalao agaꞌo agepaꞌani penimi ageinaka, ‘Kapa puo donki ogupuka?’ ageoma koa aisama fopaina, ‘Lopia anina eani’ fooma,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ega puo egaꞌina auꞌi eulaiꞌi auꞌi kelao ke kapaꞌina eifania auga iꞌopoga mo emia keisa. ");
INSERT INTO mek_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ke donki kegupukia alogai, donki inagome auga epaꞌani einaka, “Ei, oi kapa puo donki ogupuka?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ke isa egaꞌina auga ega iifa kepamue keinaka, “Lopia anina eani puo agupukia alaoaina,” keoma. Ega aisama isa donki elogoaina keafiia kelao. ");
INSERT INTO mek_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Isa donki kemaiseina, ke afeꞌi tiapuꞌi keafiiꞌi donki laagai kepagapu pagainiꞌi. Egae kai Iesu kepalagaina eꞌagaukae donki laagai eaguka. ");
INSERT INTO mek_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ke ekailai elao alogai papiau afeꞌi tiapuꞌi keafiiꞌi keagai kekauniꞌi kai laaꞌiai epea pagai. ");
INSERT INTO mek_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ke Iesu eake elao Olifa ikuga keagaga niegai aisama, ega imoi maꞌoai ke muninai kepea auꞌi fofouga laꞌafou akaikiꞌagai, Iesu mirakulo ekapaiꞌi maꞌoai ifoꞌi maaꞌiai keisaꞌi puo, egaꞌina alogamagai aisoꞌi gomegai keꞌina keagaga Deo keau afagaina keinaka, ");
INSERT INTO mek_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Lopia akagai kin emai auga Deo eegai kapa feloꞌi eafiꞌi,” keoma. Ke keifa pugu keinaka, “Ufai Deo ke papiau aagoai fou gagagaoniꞌi, ke auꞌoniai Lopia Au Akaikiꞌa apamia aau afagaina,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kai papiau Iesu kin kepamia iina keau afagai oma auga, laꞌafou alogai Faliseo auꞌi isaꞌi anina akeani puo Iesu kepainia keinaka, “Pamalele aumu, emu imoi ke emu papiau maꞌoai mofinaꞌi ega fakeifa oma,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Kai Iesu einaka, “Iifa gome maamiai laifania. Isa komo akeoma koa aisama, kepo inamoꞌeꞌi akeagaga akeau afagainiau. Ega puo isa afalapainiꞌi komo afakeoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","42","Ke Iesu papiau fou kelao Ierusaleme taonina kelaisapia alogai, maaga elao taoni eisa aisama eapepe einaka, “Ierusaleme taonina papiaumi, iꞌina kinaꞌi agaꞌogai kapaꞌinai Deo oi fou gagao fokapa auga amologo koa aisama, fefelo alogaina. Kai paukai mo ganinagai amologo koa aisama fefelo alogai. Kai Deo oi maamiai eogefake puo alologo. ");
INSERT INTO mek_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Ke lau lamai auga Deo oi emai penimi fepalagainimi eoma koa iꞌopoga. Kai oi egaꞌina auga alologo felo. Ega puo oi emi laomai apala afa agoafia. Oi emi ou auꞌi akemai Ierusaleme taonina pouga akaikiꞌa akeapa lofeimi, afu kiuꞌi maꞌoai akeapa, akeaipa kegaaunimi akeoma auga kina agemai. Egae kai emi taoni alogai akekoko oi ke gaumi fou akeafimi aꞌisaai akegapukimi, ke taoni pougai akefounimi. Ke taoni fofouga akeauoka afeꞌaina puo kapa agaꞌomo mo ganinagai kepo laagai afaekauau afaeka,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Egae kai Iesu elao Deo ega eꞌai ekoko aisama, papiau maꞌo egae eꞌi amu keꞌafaꞌafalainiꞌi eisaꞌi. Ega aisama eꞌina afaꞌafa auꞌi euokaꞌi. ");
INSERT INTO mek_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ke epainiꞌi einaka, “Deo ega iifa pukagai iina kepapua oma: ‘Lau eꞌu eꞌa auga megamega afuga.’ Kai oi auga megamega afuga, ‘painao auꞌi afuꞌi opamia,’” eoma. ");
INSERT INTO mek_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Egaꞌina afegai Iesu aufa kina Deo ega eꞌa alogai papiau epamaleleniꞌi. Kai papiau epoꞌiai sakedote lopiaꞌi ke Moses ega iifa pamalelega auꞌi, ke papiau keꞌimaꞌi auꞌi fou keꞌopoisa Iesu kegaaupugua keoma. ");
INSERT INTO mek_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kai papiau maꞌoai Iesu ega iifa anina keani ke kainai kepea puo, kegaaupugua keagaga agaꞌo kekapunia kai aekainiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kina agaꞌogai Iesu Deo ega eꞌa alogai Deo ega iifa faunina papiau epamaleleniꞌi ke einogonia. Egaꞌina alogai sakedote lopiaꞌi, Moses ega iifa pamalelega auꞌi, ke au akaikiꞌaꞌi isafa fou kemai. ");
INSERT INTO mek_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ke isa Iesu kepainia keinaka, “Isapu kapagai iꞌina kapaꞌi lokapaꞌi, ke kai isapu epeniio ega koa lokapa auga maamaisai foifania?” keoma. ");
INSERT INTO mek_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Ega aisama Iesu einaka, “Lau isafa oi paꞌani agaꞌo alapenimi. Ioane ega inogo ke baptismo epipeni auga ufai Deo eegai emai, o papiau aumauni eeꞌiai emai auga maauai amoifania malogo?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ega aisama isa ifoꞌi mo epoꞌiai keifa keinaka, “Iꞌa Ioane ega isapu ufai Deo eegai emai agaoma koa aisama, isa iꞌa agepaꞌani peniꞌa ageinaka, ‘Kapa puo isa alopakoꞌania?’ ageoma. ");
INSERT INTO mek_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kai iꞌa agaifa, isa ega isapu papiau aumauni eeꞌiai emai,’ agaoma koa aisama, papiau iꞌa kepoai akefoupuguiꞌa, gome papiau maꞌoai Ioane profeta auga kepakoꞌania,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ega puo isa iifa kepamue keinaka, “Lai Ioane ega isapu kapai emai auga alalogo,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ega aisama Iesu isa epainiꞌi einaka, “Ega koa aisama, lau isafa isapu kapagai iꞌina kapaꞌi lakapaꞌi auga, oi maamiai afalaifania,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Egae kai Iesu iꞌina palapole papiau maaꞌiai eifania einaka, “Au agaꞌo fino ago ekapaisa ke fino efauniꞌi efua aisama, pinauga papiauꞌi isaꞌi epaꞌimaꞌi kepapinaugania. Kai isa ifo auga ekailai afu iꞌoina elao egae eagu epo emaefa. ");
INSERT INTO mek_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ke fino aniꞌi eogeiꞌi, ke iꞌafe kina ekainia aisama, fino ago inagome auga ega pinauga auga agaꞌo eulaisa elao, fino ago epaꞌimaꞌi auꞌi, fino aniꞌi afa fekepenia femaiseiniꞌi eoma. Kai egaꞌina auꞌi isa ega pinauga auga keauniia, ke ima maini keumue. ");
INSERT INTO mek_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ke fino ago inagome ega pinauga auga iꞌoinaga mo agaꞌo eulaisa elao pugu. Kai isa isafa keauniia kepameagaina ke ima maini keumue. ");
INSERT INTO mek_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ega aisama fino ago inagome ega pinauga auga iꞌoinaga mo agaꞌo eulaisa elao pugu. Kai isa faaga kepalifu alogaina keafiia fino umagai kepiulaisa. ");
INSERT INTO mek_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ega aisama fino ago inagome auga, ifo mo eifa einaka, ‘Kapaꞌina fakapa? Lau gau anina laani alogaina auga alaulaisa. Laopolaga isa auga akepalopiania fino anina afa akepenia,’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ega puo au gauga eulaisa elao, ke fino keꞌima auꞌi isa keisa aisama, ifoꞌi mo epoꞌiai kapaꞌina fekekapa auga fouga keifania keinaka, ‘Isa fino ago inagome auga gauga puo, muni fino ago inagome auga agemia. Ega puo agaaupugua aisama, fino ago iꞌina iꞌa apuꞌa agemia,’ keoma. ");
INSERT INTO mek_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ega kainai keafiia fino umagai kepiulaisa keaupugua.” Iesu egaꞌina palapole eifania efua aisama, papiau epaꞌani peniꞌi einaka, “Ega koa aisama, fino ago inagome auga isa faagaꞌiai kapaꞌina agekapa ooma? ");
INSERT INTO mek_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Isa ifo agemue agelao fino ago epaꞌimaꞌi auꞌi ageaupuguꞌi, ke fino ago papiau iꞌoiꞌi agepeniꞌi akeꞌima,” eoma. Papiau Iesu iina eifa oma aina kelogonia aisama, kelogo isa au akaikiꞌaꞌi fouꞌi eifania puo keifa keinaka, “Iina koa afaemia!” keoma. ");
INSERT INTO mek_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ega aisama Iesu papiau maaꞌi alo ipauma eisa kai epaꞌani peniꞌi einaka, “Deo ega iifa pukagai iꞌina iifaga ekae auga kapaꞌina eifania? “‘Eꞌa ipaapa auꞌi kepo uuꞌuga keumakalaina auga, kiuga uuꞌuga kapula ipauma emia.’ ");
INSERT INTO mek_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ke kepo egaꞌina ega isapu akaikiꞌa. Ega puo kaisau egaꞌina kepo ageumakalaina afaepakoꞌania auga, ega laomai apala afa ageafia. Egaꞌina auga kapa agaꞌo kepo laagai eꞌualai emuꞌamuꞌa koa iꞌopoga, isa kepo egaꞌina laagai ageꞌualai aisama ageaumuꞌa afeꞌaina. Ke kaisau ega laomai apala afa puogai, kepo egaꞌina isa laagai ageꞌualai koa aisama, isa ageaumuꞌa aeapu koa agemia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ega aisama Moses ega iifa pamalelega auꞌi ke sakedote lopiaꞌi fou kefiaisakoa mo keaga agaꞌo kekapunia Iesu kegaafia kegagope keoma. Gome Iesu palapole egaꞌina eifania auga isa fouꞌi eifania auga kelogo. Kai isa papiau kemaniꞌiainiꞌi puo Iesu akeafia akegopeisa. ");
INSERT INTO mek_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Egaꞌina afegai Moses ega iifa pamalelega auꞌi ke sakedote lopiaꞌi fou Iesu kapa agaꞌo afeifa apalania aisama, fekeafia Roma kafanaga imagai fekepaaua ega isapuai fepaꞌani penia keoma. Ega puo papiau isaꞌi keulaiꞌi pifogeai papiau feloꞌi koa kekagakaga kai, Iesu kapaꞌina ekapaisa ke eifaniꞌi auga aloꞌi koꞌagai keagu keagouka. ");
INSERT INTO mek_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Egaꞌina alogai Moses ega iifa pamalelega auꞌi ke sakedote lopiaꞌi fou au keulaiꞌi kelao auꞌi, Iesu kepaꞌani penia keinaka, “Pamalele aumu, lai alogo oi kapa maꞌoai opaiꞌi mo loifaniꞌi, ke lopamaleleniꞌi. Ke oi ulalu ma, lopia ma aumai ma ganinagai, maꞌoai eemaisai iꞌopoga mo lokapa, Deo ega keaga, ke ega iifa koꞌa auga kaiꞌiai mo lopakaiꞌi lopamalelenimai. ");
INSERT INTO mek_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kai paꞌani agaꞌomo agapenio. Roma lopia faꞌa akaikiꞌa Sisa ega tax apenia auga Moses ega iifa kainai felo o apala?” keoma. ");
INSERT INTO mek_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kai Iesu isa eꞌi niniꞌani ikifagai kegapaoa keoma auga elogo puo epainiꞌi einaka: ");
INSERT INTO mek_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Silifa monina agaꞌo amopakinaisau maisa,” eoma. Ke moni kemaiseina kepeniia eisa aisama, epaꞌani peniꞌi pugu einaka, “Kaisau lalauga ke aka fou moniai keogeisa oisa?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ke isa iifa kepamue keinaka, “Sisa lalauga ke aka fou,” keoma. Ega aisama Iesu isa epainiꞌi einaka, “Ega koa aisama, kapaꞌina Sisa apuga auga, Sisa fopenia, ke kapaꞌina Deo apuga auga, Deo fopenia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Iesu isa eꞌi iifa ega epamue oma aina kelogonia aisama, kekauai alogaina keopofua. Ke Iesu laꞌafouai kapaꞌina eifania auga ega niniꞌaniai fekepaoa keoma kai aekainiꞌi puo, keagu komo mo keoma. ");
INSERT INTO mek_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Egaꞌina afegai Saduseo ikupuga papiauꞌi, papiau maeai afakemaunimue keoma auꞌi isaꞌi Iesu eega kemai. ");
INSERT INTO mek_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ke Iesu kepaꞌani penia keinaka, “Pamalele aumu, Moses ega iifa ufainagai lai faumaisai epapua eifa, au agaꞌo aaga eamage imoi laaꞌi kai emae koa aisama, isa afuafu egaꞌina feakafania, ega koa aaga gauga agaꞌo fepamauga eoma. ");
INSERT INTO mek_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pau amoopolaga, famili agaꞌogai maguae auꞌi imagea kuagai gua keagu. Kai au faꞌaniauga eamage kai imoi laaꞌi emae. ");
INSERT INTO mek_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Faꞌaniauga muninai emauni auga afuafu egaꞌina eakafania, ke isa isafa imoi laaꞌi emae. Ke isa augai agaꞌo auga isafa afuafu egaꞌina eakafania kai, isa isafa imoi laaꞌi emae. Ke ega koa iꞌopoga mo emia elao, afifua isafa afuafu egaꞌina eakafania kai imoi laaꞌi emae. ");
INSERT INTO mek_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ke fuagai ipauma afuafu isafa emae. ");
INSERT INTO mek_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ega koa emia kai, pau isa auꞌi imagea kuagai gua afuafu egaꞌina keakafania puo, maunimue kina agemai aisama, kaisau afuafu egaꞌina akafa ipauma agemia?” keoma. ");
INSERT INTO mek_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ega aisama Iesu einaka, “Iꞌina agofaꞌa papiauꞌi auga keamage ke kepaamageꞌi. ");
INSERT INTO mek_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kai papiau keopolaga muni maeai akemaunimue ke ufai akeagu agekaina keoma auꞌi, afakeamage o afakepaamageꞌi. ");
INSERT INTO mek_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Egaꞌina auꞌi agelo koa iꞌopoꞌi puo afakemaemae. Ke maeai akemaunimue kainai Deo gauga ipaumaꞌi akemia aoniamo. ");
INSERT INTO mek_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ufainagai au agaꞌogai lo eufa alogai, Lopia Deo Moses eapakina penia. Ega aisama ufuꞌa apaꞌa Abraham, Aisak, ke Iakobo fou kemae efua kai Moses Lopia eifaga, ‘Abraham, Aisak, ke Iakobo eꞌi Deo’ eoma. Egaꞌina auga Deo ega iifa pukagai epapua ekae. Ega puo Moses isafa, papiau maeai akemaunimue auga epakinaiꞌa. ");
INSERT INTO mek_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ke Abraham, Aisak, ke Iakobo fofouga kemae kai kemaunimue Deo fou keague auga Moses elogo puo, ega eifa oma. Ega puo Deo auga mae papiauꞌi eꞌi Deo laaꞌi kai, kemae kai kemaunimue keague auꞌi eꞌi Deo,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Moses ega iifa pamalelega auꞌi isaꞌi, Saduseo eꞌi opola anina akeani auꞌi Iesu ega eifa oma aina kelogonia aisama, keifa keinaka, “Pamalele aumu, loniniꞌani felo alogaina,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Egaꞌina afegai Iesu ega logo akaikiꞌa ipauma kai agaꞌo fou akeakekua auga afaekaina keisa puo, paꞌani agaꞌo akepenia pugu. ");
INSERT INTO mek_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Egae kai Iesu Moses ega iifa pamalelega auꞌi maꞌoai epainiꞌi einaka, “Ala koa iꞌopoga papiau keifa Mesaia auga Davide okogai emai auga keoma? ");
INSERT INTO mek_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Gome ufainagai Davide ifo Deo ega iifa puka Sam alogai iina epapua oma: “‘Lopia lau eꞌu Lopia epainia einaka, “Kaiuai moagu mo felaolao emu ou auꞌi ifemu guagai alaogeꞌi alogafapiꞌi,” ’ eoma. ");
INSERT INTO mek_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davide Mesaia eifaga ‘Lopia’ eoma kai ala koa iꞌopoga papiau Mesaia Davide okogai emai auga keoma? Mesaia auga Davide okogai mo aemai kai, isa isafa Davide ega Lopia. ");
INSERT INTO mek_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Papiau maꞌoai Iesu aina kelogologo kai, Iesu ega imoi epainiꞌi einaka: ");
INSERT INTO mek_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Moses ega iifa pamalelega auꞌi foisa feloꞌi. Isa auga au akaikiꞌaꞌi fekepamiaꞌi keoma puo, au akaikiꞌaꞌi tiapu maefaꞌi keiꞌiukaꞌi mo tiapuꞌi keiꞌiukaꞌi. Ke afaꞌafa afuꞌiai papiau isa mo fekepamegoniꞌi auga anina keani alogaina. Ke anina keani laꞌafou afuꞌiai au akaikiꞌaꞌi mo fekeagu keoma auꞌi mo afuꞌiai keagu. Ke miamia aloꞌiai au akaikiꞌaꞌi mo fekeagu keoma auꞌi mo isafa afuꞌiai keagu. ");
INSERT INTO mek_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Egaꞌina mo laaꞌi kai, isa pifogeai afuafu eꞌi amu keanianilainiꞌi, ke papiau kegaisaꞌi keoma puo, megamega maefaꞌi ipaumaꞌi keifaniꞌi. Deo papiau ega koaꞌi auꞌi eꞌi laomai apalaꞌi kainai, afa apala ipauma agepeniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesu Deo ega eꞌai eagukipo ega imoi maaꞌiai egaꞌina iifaga eifaifania kai, ekiakae paꞌamuꞌamu auꞌi eꞌi amu Deo kepapalao penia afugai keogeiꞌi auga eisaꞌi. ");
INSERT INTO mek_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ke ulalu afuafuga agaꞌo isafa emai kopa moniꞌi auniꞌi eogeiꞌi auga eisa. ");
INSERT INTO mek_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ega aisama Iesu ega imoi epainiꞌi einaka, “Iifa gome maamiai laifania. Papiau maꞌo moni keogeisa kai ulalu afuafuga ega pipeni auga papiau maꞌoai eꞌi pipeni ekaꞌegaina. ");
INSERT INTO mek_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Gome iꞌina papiauꞌi maꞌoai eꞌi paꞌamuꞌamu amuꞌi epoꞌiai moni keafilaiꞌi keogeiꞌi. Kai iꞌina afuafuga ulalu ipauma, ke kopa moniꞌi auniꞌi mo eegai keka isa fekepalagaina auga eafiiꞌi Deo epalao penia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Egae kai Iesu ega imoi isaꞌi papiau eꞌi pipeni moninai ke kepo feloꞌi ipaumaꞌiai Deo ega eꞌa kekapaisa, iisa efelo alogaina auga fouga keifa. Kai Iesu eifa einaka: ");
INSERT INTO mek_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Pau kapaꞌina inae oisa auga, muni isauoka kina agemai aisama, kepo maꞌoai akeafiꞌi akepiulaiꞌi, ke kepo agaꞌomo mo ganinagai, kepo iꞌoina agaꞌo laagai afaekauau,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Iesu ega eifa oma aisama, ega imoi isa kepaꞌani penia keinaka, “Pamalele aumu, gaika kina iꞌina kapaꞌi akemia? Ke gou kapa agemia, lai agepalogonimai egaꞌina kina emai ekainia agaoma?” keoma. ");
INSERT INTO mek_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ke Iesu einaka, “Muni papiau maꞌo akepifoge lau akauai akemai, isa lau akeoma, ke egaꞌina kina emai efua akeoma. Kai oi foisa felo fakefogeimi muniꞌiai folopea. ");
INSERT INTO mek_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ke ifani agemia, ago iꞌoina iꞌoina fou epoꞌiai, aꞌoaꞌo akaikiꞌaꞌi ipaumaꞌi akemia aꞌoꞌi agologoniꞌi aisama, kina fua emai efua auga maniꞌina folopaꞌaua. Egaꞌina kapaꞌi auꞌi fekemia kakaua kai, agofaꞌa ega fua auga muni kai agemai,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Egae kai Iesu epainiꞌi pugu einaka, “Agofaꞌa fofouga alogai ago, ago fou akepipaini, ke kin, kin fou akepipaini. ");
INSERT INTO mek_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ke kafokau akaikiꞌaꞌi, magea akaikiꞌaꞌi, ke isafa apalaꞌi akemai afu iꞌoiꞌi iꞌoiꞌi papiauꞌi akepalifuꞌi. Ke maniꞌi kapaꞌi akemia, ke ufa guagai mirakulo gouꞌi akaikiꞌaꞌi akemia papiau akepamaniꞌiniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Kai egaꞌina kapaꞌi maꞌoai akemia koa kai, oi lau akau opakoꞌania kainai papiau oi akeafi apalanimi. Ke akelaoainimi laꞌafou afuꞌiai iifa agopakaisa, ke tipula afuꞌiai akepatipulanimi. Ke akeafimi kin ke kafana fou eeꞌi akelaoainimi iifa agopakaisa. ");
INSERT INTO mek_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Oi isa agoꞌiai agoapa iina koa faagamiai akemia aisama, egaꞌina laoga maina agepalagainimi lau fou alao amai auga fouga isa maaꞌiai agoifafoua. ");
INSERT INTO mek_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Kai lau oi kapaꞌina foifania auga alapalogonimi agoifania ke ikifa isafa alapenimi. Ega koa egaꞌina papiauꞌi fou iifa agopakaisa kai afaekainiꞌi, ke fou agoakekua kai afaekainiꞌi paisa. Ega puo muni kapaꞌina akemia alogai, ifomi iimi ala agooge oma auga opopo folopaꞌaua. ");
INSERT INTO mek_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ke oi ifomi inami, amami, aami akimi fou omauni auꞌi, ke aami akimi, ke ekefaꞌami mo ganinagai oi akeafimi papiau imaꞌiai akepaaumi, ke akeꞌafaꞌafalainimi. Ke egaꞌina papiauꞌi oi isami akeaupuguimi. ");
INSERT INTO mek_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ke lau puouai papiau maꞌoai aloꞌi koꞌagai oi animi afakeani. ");
INSERT INTO mek_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kai Deo afaelogoainimi koa aisama, fufumi agaꞌomo mo ganinagai afakeafi opogaina. ");
INSERT INTO mek_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ega kainai alomi fopakapulania, lau eeuai foafiaꞌama, ega koa agu pagai maunina agoafia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ke Iesu eifa pugu einaka, “Oi ifani auꞌi Ierusaleme taonina akeapa lofe agoisaꞌi aisama, agologo Ierusaleme isauoka kina auga emai efua agooma. ");
INSERT INTO mek_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Iudea agogai keagu auꞌi fekepiau iku afuga fekelao. Ke Ierusaleme taoninai keagu auꞌi taoni fekepuaꞌafuga, ke taoni afegai keagu auꞌi taoniai fakekoko. ");
INSERT INTO mek_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Gome egaꞌina kina auga, ufainagai profeta Deo ega iifa pukagai kepapua kakaua koa iꞌopoga mo agemia, Deo ega logoai Ierusaleme taonina papiauꞌi eꞌi laomai apalaꞌi afa agepeniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Egaꞌina kinaꞌiai Ierusaleme taonina papiauꞌi Deo ega guakupu afa agepeniꞌi puo, kiekie akaikiꞌa ipauma agemia. Ega kainai papie inaeꞌiai auꞌi, ke papie imoi kepaꞌuꞌi auꞌi fou fekefiakoa fekepiau auga afaekaina puo, kiekie akaikiꞌa akeafia. ");
INSERT INTO mek_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Egaꞌina papiauꞌi isaꞌi ifani aꞌifaꞌiai akeaupuguꞌi, ke isaꞌi tipula auꞌi koa iꞌopoꞌi akeafiꞌi ago iꞌoina iꞌoina akelaoainiꞌi. Ke Iudea papiauꞌi laaꞌi auꞌi ifeꞌiai Ierusaleme taonina akegafamuꞌa. Ke akepalifu afeꞌaina agelaolao taoni alogai Iudea papiauꞌi laaꞌi auꞌi agepogu, Ierusaleme taonina isa akeꞌima,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Iesu eifa pugu einaka, “Ufai kina, gafa, ke miꞌimiꞌi faagaꞌiai gou akemia. Ke aagoai aꞌu agemoge goiso akaikiꞌaꞌi ipaumaꞌi akemia aꞌoaꞌo akaikiꞌa ipauma akekapa aisama, agofaꞌa fofouga papiauꞌi akeopopo alogaina, kapaꞌina fekekapa auga afakelogo. ");
INSERT INTO mek_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ke kina, gafa, ke miꞌimiꞌi fofouga akepigugu puo, muni aagoai kapaꞌina agemia auga akelogo kainai akemaniꞌi alogaina akemaeꞌafu. ");
INSERT INTO mek_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Egaꞌina kinagai Papiau Aumauni Gauga isapu ke Deo ega eaea akaikiꞌa ipauma fou ageafiꞌi apuapuai agemai akeisa. ");
INSERT INTO mek_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kai pau laifaniꞌi auꞌi kapaꞌi akeꞌina akemia aisama, Deo kaniami ageagamauga kina emai kainagai puo, fofua foꞌue foapa foꞌima,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Egae kai Iesu iꞌina palapole eifania einaka, “Maami galao au aka fik, ke au maꞌoai isafa amoisaꞌi. ");
INSERT INTO mek_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Isa gagauꞌi mamaꞌi keogeꞌi aisama, ifomi maamiai oisaꞌi ologo, inipo aupu agemai kina ekainia ooma. ");
INSERT INTO mek_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ega koa iꞌopoga, pau lau kapaꞌina mo laifaniꞌi auꞌi akegama agoisaꞌi aisama, Deo ega agofaꞌa kina emai ekainia auga fologo. ");
INSERT INTO mek_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Iifa gome mo maamiai laifania. Iꞌina papiauꞌi agofaꞌai keaguega kai iꞌina kapaꞌi maꞌoai akemai akekoꞌa kai akemae. ");
INSERT INTO mek_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ufa aagoa fou laaꞌi akemia kai lau eꞌu iifa auga laaꞌi afakemia, akeka aoniamo,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ke Iesu eifa pugu einaka, “Oi miamia maꞌo, inuinu, ke aagoa amuꞌi mo agoguakaeainiꞌi alogai, afolologo Deo afa apala agepipeni auga kina fiakoa mo agemai, agepakauainimi agepaoaimi. Egaꞌina auga anina alaani kainai ifomi foꞌima feloimi laoma. ");
INSERT INTO mek_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Gome egaꞌina kinagai Deo agofaꞌa papiauꞌi fofouga eꞌi laomai apala afa agepeniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Oi muni kapaꞌina akemia auꞌi eeꞌiai fopiaukoko, ke Papiau Aumauni Gauga agogai agoapa aisama, afa apala faepenimi laoma. Ega puo aufa kina ifomi foꞌima feloimi, fomegamega fofua foagu,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Egaꞌina kinaꞌiai aufa kina Iesu Deo ega eꞌai epamalele ke egapigapi aisama, elao iku aka Olifa keoma auga ikugai elaagai. ");
INSERT INTO mek_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kai papiau maꞌo Iesu aina kegalogo keoma puo, amagai ipauma kelao Deo ega eꞌai kekoko keagu. ");
INSERT INTO mek_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Egae kai palafa ipaufuga mulamula laaꞌi kai palafa maini mo keania auga miamiaga aka Pasover emai ekaialiali. ");
INSERT INTO mek_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Egaꞌina alogai sakedote lopiaꞌi ke Moses ega iifa pamalelega auꞌi fou papiau kemaniꞌiainiꞌi kainai, ogefakeai Iesu fekeaupugua keoma keagaga kekapunia. ");
INSERT INTO mek_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ega aisama Iesu ega apostolo 12 epoꞌiai agaꞌo aka Judas Iskariot keoma auga alogai Satani ekoko. ");
INSERT INTO mek_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ke isa sakedote lopiaꞌi ke Deo ega eꞌa keꞌima kaniagai auꞌi eeꞌi elao, Iesu ala ageꞌafaꞌafalai oma auga fouga keifania. ");
INSERT INTO mek_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ega aisama egaꞌina papiauꞌi aloꞌi egama alogaina, ke kelogo moni fekepenia keoma. ");
INSERT INTO mek_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ke isa kapaꞌina keifania auga Judas felo eoma puo ainaꞌi eafiia. Ke elao keaga agaꞌo ekapunia laꞌafou afaemia aisama, Iesu feꞌafaꞌafalaina isa imaꞌiai fepaaua eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Egaꞌina afegai palafa ipaufuga mulamula laaꞌi kai, palafa maini mo keania miamiaga aka Pasover ke sipi gauga Deo kepaꞌa penia auga kina emai ekainia. ");
INSERT INTO mek_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ega aisama Iesu ega apostolo Peto, Ioane auniꞌi epainiꞌi einaka, “Amoufai amolao iꞌa fauꞌaisai Pasover miamiagai foꞌama agaania auga opafua gaka,” eoma. Egae kai eulaiꞌi kelao. ");
INSERT INTO mek_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ega aisama isa Iesu kepaꞌani penia keinaka, “Anina loani kapai egaꞌina foꞌamaga fapafua feka looma?” keoma. ");
INSERT INTO mek_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ke Iesu einaka, “Agolao Ierusaleme taoninai agokoko mo alogai, au agaꞌo oga eafiia fei eakoaua epuaisa auga fou agopiaogai. Isa muninai folao eꞌa kapagai agekoko auga foisa. ");
INSERT INTO mek_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Egae kai folao eꞌa inagome auga fopaina foinaka, ‘Pamalele auga epaꞌani, lau eꞌu imoi fou Pasover miamiaga foꞌamaga faania laoma kai, lai fofougai agaaniani auga afuga kapai?’ fooma. ");
INSERT INTO mek_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ke isa eꞌa auꞌoniai, afu akaikiꞌagai amu maꞌoai epafuaꞌi auga agepakinaimi. Ke folao egae miamia foꞌamaꞌi fopafuaꞌi fekeka,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ke Peto Ioane auniꞌi kelao, ke Iesu kapaꞌina maaꞌiai eifania auga iꞌopoga mo emia keisa. Ega puo egae Pasover foꞌamaga, ke amu maꞌoai kepafuaꞌi keka. ");
INSERT INTO mek_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Egae kai aniani kina maaga ekainia aisama, Iesu ega apostolo 12 fou kelao teipoloai keagukipo. ");
INSERT INTO mek_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ke Iesu isa epainiꞌi einaka, “Iifa gome maamiai laifania. Lau alakiekie koa kai oi fou Pasover miamiagai faaniani auga alou koꞌagai anina laani. ");
INSERT INTO mek_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Gome lau oi fou afalaaniani pugu agelao Pasover miamiaga pau aagoai akapa, Deo kaniami ageagamauga auga gouga muni ufai koꞌa ipauma mo agemia kai fou agaaniani pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Egae kai Iesu fino kaputina eafiia Deo maagai tenkiu eifania kai epainiꞌi einaka, “Fino kaputina iꞌina amoafia epomiai amoꞌea amoinu. ");
INSERT INTO mek_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Gome fino iꞌina au puagai emai auga afalainu pugu agelaolao muni Deo ega logoai kapa maꞌoai akefua afegai, Deo ega agofaꞌai kai alainu pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Egae kai palafa eafiia Deo maagai tenkiu eifania, efaipoga kai ega imoi epainiꞌi einaka, “Iꞌina palafaga auga lau imaau oi faumiai alapipeni auga. Muni iina koa agokapa aisama, foopolaniau kai fokapa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ega koa iꞌopoga, keaniani efua aisama Iesu fino kaputina eafiiakae kai ega imoi epainiꞌi einaka, “Iꞌina fino kaputina auga oi faumiai lau ifau agefaka auga. Ke Deo oi fou epomiai pakoꞌa kapula iifaga mamaga gouga lakapaisa. ");
INSERT INTO mek_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kai amoisa! Epomiai aufalao agaꞌo lau ageꞌafaꞌafalainiau auga isafa inae fou aague. Egaꞌina auga lau fou foꞌama agaꞌomo agaania auga. ");
INSERT INTO mek_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Papiau Aumauni Gauga auga Deo ega logoai femae eoma puo agemae kai, kaisau isa ageꞌafaꞌafalaina auga, Deo isa afa apala ipauma agepenia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ega aisama Iesu ega apostolo ifoꞌi mo epoꞌiai kaisau ega koa agekapa auga paꞌanina kepaꞌani. ");
INSERT INTO mek_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ke isa epoꞌiai papiau maaꞌiai kaisau au akaikiꞌa agemia auga isafa akekua kepaꞌaua. ");
INSERT INTO mek_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ega aisama Iesu isa epainiꞌi einaka, “Agofaꞌa papiauꞌi eꞌi kin isa kelopialainiꞌi, ke isapuai papiau keꞌimaꞌi auꞌi ifoꞌi keifaniꞌi papiau fauꞌiai kapa feloꞌi mo kekapaꞌi auꞌi keoma. ");
INSERT INTO mek_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kai oi auga egaꞌina papiauꞌi koa folomia. Oi epomiai kaisau Deo maagai au akaikiꞌa gamia eoma auga ifo eꞌele fepamia. Ke kaisau papiau eꞌimaꞌi auga, papiau feopolaniꞌi fauꞌiai fepinauga. ");
INSERT INTO mek_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Amoisa! Iꞌina papiauꞌi epoꞌiai kaisau auga au akaikiꞌa ooma? Eagukipo eaniani auga, o foꞌama eꞌea auga? Iifa gome eagukipo eaniani auga au akaikiꞌa. Kai lau oi epomiai foꞌama iꞌea auga koa iꞌopoga lamia oi faumiai lapinauga. ");
INSERT INTO mek_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Lau kina apalaꞌi aloꞌiai lakoko iꞌopo laafiiꞌi mo ganinagai, alopuaꞌafuniau fou kaiꞌalao aagu. ");
INSERT INTO mek_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ke Amau ega agofaꞌa lau epeniiau faꞌima eoma koa iꞌopoga, oi isafa apumi alapenimi agoꞌima. ");
INSERT INTO mek_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ega koa oi lau eꞌu agofaꞌai fou faagu faaniani, ke papiau foꞌimaꞌi isapuga foafia foagu, Israel ikupuga 12 papiauꞌi eꞌi laomai afa fopeniꞌi laoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Egae kai Iesu Saimon eifaga kai epainia einaka, “Saimon, Saimon akiuagai, Satani Deo egoi penia elogo oi palafa kepagopo koa iꞌopoga feꞌopoiso eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kai Saimon, Satani ageꞌopoiso alogai, kapaꞌina lopakoꞌania auga eegai foloꞌualai laoma puo faumuai lamegamega. Kai oi aloꞌualai mo ganinagai, alomu agekapula alopakoꞌaniau pugu aisama, aamu akimu eꞌi pakoꞌa fopakapulania,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Kai Saimon iifa epamue einaka, “Lopia, lau lafua laague oi fotipula ma, fomae mo ganinagai fou agalao paisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ega aisama Iesu einaka, “Peto, iifa gome maamuai laifania. Pau oꞌolo aeagaga koa kai, oi lau alologoniau auga puniaina oiso alopamia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Egae kai Iesu isa maꞌoai epaꞌani peniꞌi einaka, “Oi laulaimi mo alogai, paoti, feꞌa, o kamata iꞌoina agaꞌo aloafia alogai kapa agaꞌo eegai oafiꞌafu ma?” eoma. Ke isa iifa kepamue keinaka, “Laaꞌi,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ega aisama Iesu isa epainiꞌi pugu einaka, “Pau amofua amoagu paoti, o feꞌa eemiai kekae koa aisama amoafiꞌi, ke ifani aꞌifaꞌi eemiai laaꞌi koa aisama, afemi tiapuꞌi amoꞌafaꞌafalainiꞌi ifani aꞌifaꞌi amoꞌafaꞌi. ");
INSERT INTO mek_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Gome Deo ega iifa pukagai iina kepapua oma: ‘Isa laomai apalaꞌi kekapakapa auꞌi epoꞌiai kepaapauka laomai apala ikapa auga kepamia.’ Egaꞌina iifaga auga pau lau faagauai koꞌa mo agemia alamae. Ke iifa gome lau faagauai kapaꞌina agemia kepapua auga kina emai ekainia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Iesu ega eifa oma aisama, ega imoi isa kepainia keinaka, “Lopia, lai afua aague, aꞌifa auniꞌi inamoꞌe moisaꞌi,” keoma. Ke Iesu kapaꞌina eifania auga ega imoi oko akelogo auga eisa aisama, iifa epamue einaka, “Moꞌo ekainia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Egae kai Iesu Olifa ikuga elaolao koa iꞌopoga elao, ke ega apostolo 11 isafa muninai kelao. ");
INSERT INTO mek_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ke kelao Iesu elaolao auga afugai kepealai aisama epainiꞌi einaka, “Amomegamega ega koa Satani ageꞌopoimi aisama afoloꞌualai,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Egae kai Iesu ega imoi epuaꞌafuniꞌi, kepo kepiuga elao eꞌualai koa iꞌopoga epo, egae eanifeꞌu emegamega einaka; ");
INSERT INTO mek_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Amau, anina loani koa aisama, iꞌina kiekie akaikiꞌa kaputina eeuai moafia. Kai lau anina laani auga faeikapa kai oi anina loani auga mo gaikapa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ega aisama ufai agelo agaꞌo isa eapakina penia alo epakapulania. ");
INSERT INTO mek_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Iesu faagagai kapaꞌina agemia auga eopolaga ekiekie alogaina mo ganinagai, alo koꞌa ipaumagai emegamega. Egaꞌina alogai mamaoge ifa elolo koa iꞌopoga elolo eake aꞌisaai. ");
INSERT INTO mek_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ke Iesu emegamega efua aisama, eꞌue emue ega imoi eeꞌi elao kai kefeu eisaꞌi aisama, alo emafu alogaina. ");
INSERT INTO mek_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ke epagoniꞌi kai epaꞌani peniꞌi einaka, “Kapa puo ofeu? Amoꞌue amomegamega ega koa Satani ageꞌopoimi aisama afoloꞌualai,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iesu ega imoi epaipainiꞌi kai, papiau isaꞌi laꞌafouai Iesu ega imoi fou keagu afuga kemai. Egaꞌina laꞌafouga auga Iesu ega apostolo 12 epoꞌiai agaꞌo aka Judas keoma auga eoge isa epapeaꞌi kemai. Ke kemai aisama, Judas Iesu eega elao kagakaga kainai egoapia. ");
INSERT INTO mek_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kai Iesu Judas epaꞌani penia einaka, “Judas, oi Papiau Aumauni Gauga pigoapiai ma foꞌafaꞌafalaina looma?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Egaꞌina alogai Iesu fou keapa auꞌi kapaꞌina agemia auga keisa aisama, Iesu kepainia keinaka, “Lopia, oi anina loani, lai emai ifani aꞌifaꞌiai isa amaauniꞌi looma ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ke fiakoa mo epoꞌiai apostolo agaꞌo aꞌifa efuaua, sakedote lopia faꞌa ega pinauga auga aina kaina kaina efoua. ");
INSERT INTO mek_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kai Iesu ega imoi epainiꞌi einaka, “Amoapakipo, egaꞌina folokapa,” eoma. Ke egaꞌina auga aina eafi opogaina epafelo. ");
INSERT INTO mek_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Egae kai Iesu sakedote lopiaꞌi, Deo ega eꞌa keꞌima kaniagai auꞌi, ke Iudea au akaikiꞌaꞌi isa kegaafia keoma kemai auꞌi epainiꞌi einaka, “Lau painao auꞌi koa iꞌopoꞌi oi eemiai kelele akaikiꞌa agaꞌo lakapaisa ma puo, ifani aꞌifaꞌi kopi fou oafiiꞌi omai amoafiau ooma? ");
INSERT INTO mek_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Aufa kina mo oi fou Deo ega eꞌai aagu kai, imami agaꞌomo ganinagai faagauai aloogeaua. Kai pau Deo ega logoai Satani umina ipauma auga elogoaina fepinauga auga, kina emai efua. Ega puo kapaꞌina lau faagauai amokapa ooma auga okapa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Egae kai isa Iesu keafiia kegopeisa kepapea kelaoainia mo, sakedote lopia faꞌa ega eꞌai kekokoaina. Ega aisama Peto isafa isa muniꞌiai aakai mo epea elaoaina. ");
INSERT INTO mek_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Egaꞌina afegai ifani auꞌi iifa ipakaina afuga ipuainagai lo kepaaga keagu lofe. Ega aisama Peto isafa isa fou egae keagu. ");
INSERT INTO mek_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Egae kalaꞌafi ifiaoga agaꞌo lo eaeagai Peto eagu auga eisa. Ke isa eisa felo aisama eifa einaka, “Iꞌina auga Iesu fou keagu auga agaꞌo,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kai Peto epuniai einaka, “Laaꞌi, lau isa alalogonia,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ke keagu afaꞌagamo aisama, aufalao agaꞌo Peto eisa felo puo epainia einaka, “Oi isafa Iesu ega imoi agaꞌo,” eoma. Kai Peto iifa epamue einaka, “Lau laaꞌi!” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ke kina maaga agaꞌo elao afegai, aufalao iꞌoina agaꞌo Peto ega niniꞌani aꞌo elogonia aisama eifa faꞌiꞌi einaka, “Iꞌina auga Kalilea auga. Koꞌa ipauma isa Iesu fou kelao kemaimai auga agaꞌo,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kai Peto iifa epamue einaka, “Laaꞌi, oi kapaꞌina loifania auga oko alalogo!” eoma. Peto eniniꞌani laolao kai oꞌolo eagaga. ");
INSERT INTO mek_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ega aisama Lopia Iesu egae eapa eꞌafoaipini maaga opainai elao Peto eisa. Ke fiakoa mo Peto Lopia ega niniꞌaniai eifa, ‘Pau oꞌolo aeagaga koa kai lau alopuniaiainiau oiso alopamia,’ eoma auga iifaga eopolaga. ");
INSERT INTO mek_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ega aisama Peto egaꞌina afugai epealai elao afegai kai eapepe alogaina. ");
INSERT INTO mek_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ifani auꞌi Iesu keꞌima auꞌi keꞌina Iesu kepaꞌaua ke keauniia. ");
INSERT INTO mek_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ke maaga tiapuai kemokaisa kai kepaꞌani penia keinaka, “Kaisau oi eaunio auga profeta koa momia moifania,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ke egaꞌina mo akekapaiꞌi kai niniꞌani apalaꞌi isafa maꞌo eegai keifaniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Egani aisama, iifa ipakaina afugai au akaikiꞌaꞌi auꞌi, sakedote lopiaꞌi, ke Moses ega iifa pamalelega auꞌi fou kemai kelaꞌafou. Egae kai Iesu kemaiseina agoꞌiai kepaapa. ");
INSERT INTO mek_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ke kepaꞌani penia keinaka, “Oi Mesaia koa aisama maamaisai moifa gomeisa mo,” keoma. Ke Iesu einaka, “Lau alaifa gomeisa mo ganinagai, afolopakoꞌaniau. ");
INSERT INTO mek_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ke Mesaia kaisau auga paꞌanina alapaꞌani koa aisama, eꞌu iifa afa afolopamue. ");
INSERT INTO mek_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kai pau iina kina agelao alogai, Papiau Aumauni Gauga Deo isapu akaikiꞌa ipauma auga, ima kaina kainai ageagu agoisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ega aisama maꞌoai Iesu kepaꞌani penia keinaka, “Ega koa aisama, oi Deo Gauga ma?” keoma. Ke Iesu einaka, “Oi oifania auga koꞌa. Lau Deo Gauga paisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ega aisama keifa keinaka, “Ifo akegai eifa isa Deo Gauga eoma. Egaꞌina auga Deo eegai eifa apala puo femae. Lai ifomai ainamaisai eifa aꞌo alogonia efua. Ega puo papiau agaꞌo isa fepaꞌani penia ifo fouga feifania pugu auga apamafua,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Egae kai laꞌafou fofougai keꞌuegekae Iesu keafiia kelaoaina Roma kamanina kafanaga Iudea papiauꞌi eꞌimaꞌi auga aka Pilato agogai kepaapa. ");
INSERT INTO mek_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ke keꞌina Iesu kapaꞌina ekapaisa auga fouga iifa ipakainai keifania keinaka, “Iꞌina auga papiau ekaisapuꞌi Sisa eegai tax fakeoge eoma. Ke isa ifo eifaga Mesaia kin agaꞌo eomaisa. Ega koa ekapaisa, papiau efogeiꞌi keaga iꞌoinagai kepea auga akapulaisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ega aisama Pilato Iesu epaꞌani penia einaka, “Oi Iudea papiauꞌi eꞌi kin ma?” eoma. Ke Iesu einaka, “E! Oi loifania koa iꞌopoga, lau Iudea papiauꞌi eꞌi kin paisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ke Pilato Iesu iina epaꞌani peni oma kai kapa apala agaꞌo ekapaisa auga aekapulaisa puo, fiakoa mo sakedote lopiaꞌi ke laꞌafou papiauꞌi fou epainiꞌi einaka, “Iꞌina auga fetipula koa kapa agaꞌo ekapaisa auga alakapulaisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kai isa keifa paisa keinaka, “Iꞌina auga Kalilea agogai eꞌina emai inae ega pamaleleai Iudea papiauꞌi keagu afuꞌi maꞌoai elao, papiau aloꞌi eaniia aꞌoaꞌo akaikiꞌa epaꞌuegenia,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato egaꞌina keifania aꞌo elogonia aisama, Iesu Kalilea auga ma paꞌanina epaꞌani. ");
INSERT INTO mek_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ke Pilato Iesu Kalilea auga fouga elogo aisama, Herod Kalilea papiauꞌi eꞌimaiꞌi puo eulaisa elao isa eegai oko fepakaisa eoma. Egaꞌina kinaꞌiai Herod isafa Ierusaleme taoninai eagu puo eulaisa eega elao. ");
INSERT INTO mek_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod Iesu kapaꞌina ekapaiꞌi auga fouga elogo. Ke ifo maagai Iesu mirakulo isaꞌi fekapaꞌi feisaꞌi eoma, kina maꞌo eagu Iesu gaisa eoma kai aekainia. Ega puo Herod pau kina Iesu eisa aisama, alo egama alogaina. ");
INSERT INTO mek_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herod paꞌani maꞌo epaꞌani kai Iesu iifa agaꞌo aepamue. ");
INSERT INTO mek_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kai sakedote lopiaꞌi ke Moses ega iifa pamalelega auꞌi Iesu fou kemai auꞌi Iesu kapa koꞌaꞌi mo ekapaiꞌi ganinagai, iifa ipakainai pifogeai keifa kapulania. ");
INSERT INTO mek_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ega aisama Herod ega ifani auꞌi fou Iesu keisa papa, kepaꞌaua ke keifa apala penia. Ke Iesu ifo kin eoma auga aꞌo kelogonia puo, lopia tiapu felo keiꞌiuka auga tiapuga kepaiꞌiuka kai, keulaisa emue Pilato eega elao pugu. ");
INSERT INTO mek_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herod Pilato auniꞌi auga ou auꞌi kai, iꞌina kinagai Iesu ega iifa ipakaina kainai fou kepaekefaꞌa. ");
INSERT INTO mek_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Egae kai Pilato sakedote lopiaꞌi, Iudea papiauꞌi keꞌimaꞌi lopiaꞌi, ke papiau fou eifa kaiguguꞌi. ");
INSERT INTO mek_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ke maꞌoai kemai aisama epainiꞌi einaka, “Oi iꞌina auga papiau efogeiꞌi keaga iꞌoinagai kepea ooma eeu omaiseina. Ega kainai lau isa oi agomiai lapaꞌani penia kai, oi isa iifa ipakainai opaapauka auga kelelega agaꞌo ekapaisa auga alakapulaisa. ");
INSERT INTO mek_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod isafa isa ega kelele agaꞌo aekapulaisa puo, eumue eeu emai pugu. Oi iifa ipakainai ifomi maamiai oisa, isa femae koa kelelega agaꞌo aekapaisa. ");
INSERT INTO mek_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Ega puo eꞌu imoi akegapuka afaꞌagamo kai alapapealaisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kai kemai egae auꞌi maꞌoai ainaꞌi agaꞌomogai keagaga keinaka, “Iꞌina auga moaupugua kai Barabas mopapealaisa!” keoma. ");
INSERT INTO mek_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas auga papiau aloꞌi eaniia Ierusaleme taoninai kelele akaikiꞌa epaꞌuegenia alogai papiau eaupuguꞌi kainai tipulai eagu. ");
INSERT INTO mek_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Kai Pilato Iesu gapapealaisa eoma puo papiau epainiꞌi pugu. ");
INSERT INTO mek_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kai isa keagaga paisa keinaka, “Iesu kolotiai moauꞌuꞌua, kolotiai moauꞌuꞌua,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kai Pilato papiau ipainiꞌi oiso epamia einaka, “Kapa puo isa kolotiai amoauꞌuꞌua ooma? Isa kelele kapa ekapaisa? Lau isa femae koa kelelega agaꞌo ekapaisa auga alakapulaisa. Ega puo eꞌu imoi akegapuka mo kai alapapealaisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kai papiau Iesu kolotiai femae paisa auga aisoꞌi gomegai agagaga kepaꞌaua Pilato opo kepaefo pagainia. ");
INSERT INTO mek_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ega puo Pilato isa eꞌi pinoi kainai mo femia auga iifaga epakoꞌania. ");
INSERT INTO mek_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ega kainai Pilato kepainia koa iꞌopoga mo ekapaisa, au aka Barabas, papiau aloꞌi eania kelele akaikiꞌa epaꞌuegenia alogai papiau eaupuguꞌi auga epapealaisa. Ke Iesu isa imaꞌiai epaaua kapaꞌina faagagai akekapa koa fekekapa eoma. ");
INSERT INTO mek_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Egaꞌina afegai Roma ifani auꞌi Iesu kolotiai kegaauꞌuꞌua keoma kelaoaina. Egaꞌina alogai Sairene taonina auga aka Saimon ega paguai emai Ierusaleme taoninai ekoko aisama keafiia. Egae kai Iesu koloti epuaisa auga aekainia puo keafiia Saimon fagogai keogeisa epuaisa Iesu muninai epea. ");
INSERT INTO mek_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Egaꞌina alogai papiau maꞌo Iesu muninai kepea. Ke egaꞌina papiauꞌi epoꞌiai papie kepea Iesu puogai keapepe kepapinapina kepealaina. ");
INSERT INTO mek_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ega aisama Iesu eꞌafoaipini egaꞌina papieꞌi epainiꞌi einaka, “Ierusaleme papiemi, lau puouai foloapepe kai oi ifomi ke gaumi fou puoꞌiai amoapepe. ");
INSERT INTO mek_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Gome kina agaꞌo kiekie akaikiꞌa kina agemai. Ega aisama oi iina agoifa oma: ‘Papie keogeoge auꞌi ke imoi akepamauniꞌi auꞌi, ke uꞌuꞌiai imoi akepapaꞌuꞌi auꞌi Deo eegai kapa feloꞌi akeafiꞌi,’ agooma. ");
INSERT INTO mek_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ke egaꞌina kinagai kiekie akaikiꞌa puo, papiau fekemae fekefiakoa akeoma iku akaikiꞌaꞌi akepainiꞌi akeinaka, ‘Lai laamaisai amoꞌualai amoaupuguimai amofiakoa,’ akeoma. Ke iku eꞌeleꞌi akepainiꞌi akeinaka, ‘Amoꞌualai amofufunimai amofiakoa,’ akeoma. ");
INSERT INTO mek_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Pau lau auga au maaga maunina ipauma loai aeaga aefiakoa koa mo ganinagai, papiau iina koa keafiiau kefiaisakoa mo akeaupuguisau. Kai oi auga au eogogo koa iꞌopomi puo, egaꞌina kina agemai aisama ala akeomaimi? Isa oi kiekie akaikiꞌa ipauma akepenimi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Roma ifani auꞌi Iesu kelaoaina alogai, painao auꞌi auniꞌi isafa kolotiai kegaauꞌuꞌuꞌi keoma puo Iesu fou kelaoainiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ke kelao afu aka ‘Kania Uniaga’ keoma auga afugai aisama, egae Iesu kolotiai keauꞌuꞌua. Ke painao auꞌi auniꞌi agaꞌo Iesu lafanina kainai ke agaꞌo kaina kainai keauꞌuꞌuꞌi. ");
INSERT INTO mek_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Egaꞌina afegai Iesu eifa einaka, “Amau, kapaꞌina kekapa auga akelogo puo eꞌi laomai apalaꞌi moꞌagegeainiꞌi,” eoma. Ke ifani auꞌi ifoꞌi mo epoꞌiai kai mo Iesu afe tiapuga fekeafia auga eꞌi laomai kainai keꞌopoisa efua kai keꞌeaisa keafiiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Papiau egae keapa kepimeꞌe auꞌi, ke Iudea papiauꞌi keꞌimaꞌi lopiaꞌi fou Iesu kepaꞌaua kepakafoꞌonia keinaka, “Isa papiau isaꞌi kaniaꞌi eagamauga. Ega puo Deo isa ekinaga Mesaia koa aisama, amopuaꞌafuga ifo kania gaagamauga amaisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ke ifani auꞌi isafa kemai Iesu kepakafoꞌonia, fino epiꞌigu auga kepeniia gainu keoma. ");
INSERT INTO mek_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ke kepainia keinaka, “Oi Iudea papiauꞌi eꞌi kin koa aisama, ifomu kaniamu moagamauga,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Egae kai Iesu kania laagai iꞌina iifaga kepapua keogeisa: ‘Iꞌina auga Iudea papiauꞌi eꞌi kin,’ keoma. ");
INSERT INTO mek_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Painao auꞌi agaꞌo egae fou keꞌafa auga Iesu eifa apala penia einaka, “Oi Mesaia laaꞌi ma? Oi loifa Mesaia looma. Ega puo ifomu ke lai fou kaniamai moagamauga!” eoma. ");
INSERT INTO mek_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kai painao auga agaꞌo auga isa efinaisa einaka, “Oi Deo alomaniꞌiaina ma? Gome isa oi fou afa iꞌopoga oafia. ");
INSERT INTO mek_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Iꞌa aꞌa laomai afa aafiia auga felo, gome iꞌa kapaꞌina apala akapaisa auga afa kainai mo aafiia. Kai isa auga kapa apala agaꞌo aekapaisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Egae kai isa Iesu epainia einaka, “Iesu, oi emu agofaꞌai alokoko aisama lau foopolaniau,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ke Iesu einaka, “Iifa gome maamuai laifania. Pau oi lau fou afu felo ipaumagai agu pagai afugai agaagu,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Iesu kolotiai keauꞌuꞌua kinagai, kina maaga elao atiafai koa iꞌopoga aisama, umina akaikiꞌa ago fofouga eumi apua elao atiafa epagai 3 oꞌclock gapigapi. ");
INSERT INTO mek_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Gome kina eaea eapakipo aeaga. Ke egaꞌina alogai Deo ega eꞌai Deo mo eagu afuga tiapu ekaisapua auga tiapuga eꞌiꞌipea auniꞌi emia. Egaꞌina auga iꞌa Deo eega agalao auga keagaga epaagalaisa. ");
INSERT INTO mek_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Egaꞌina emia afegai Iesu eagagapea einaka, “Amau, lau lalau Oi imamuai laogeaua,” eoma. Iesu iꞌina iifaga eifania afegai elaꞌaꞌafuga emae. ");
INSERT INTO mek_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ke Roma ifani auꞌi 100 eꞌimaꞌi auꞌi agaꞌo egae eapa kapaꞌina mo kemia auga eisaꞌi aisama, Deo eau afagaina eifa einaka, “Iifa gome iꞌina auga Deo maagai alo opai ipauma auga,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ke papiau Iesu agemae auga fekeisa keoma kemai auꞌi, kapaꞌina mo kemia keisaꞌi aisama, aloꞌi emafu alogaina auga gouga kekapaisa, olagaꞌi keauniia kemue kelao. ");
INSERT INTO mek_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ke Iesu kelogo papiauꞌi maꞌoai kemai aakai mo keapa kai maaꞌi mo elao kapaꞌina emia auga keisa. Egaꞌina papiauꞌi epoꞌiai papie Kalileai Iesu muninai kemai auꞌi isafa egae keapa, maaꞌi mo elao kapaꞌina emia auga keisa. ");
INSERT INTO mek_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ega kinagai au aka Iosepa, Iudea agogai taoni agaꞌo aka Arimatea keoma auga taoninai emai. Isa au felo ipauma, papiau ke Deo fou maaꞌiai laomai felo ipauma auga. Isa Deo ega agofaꞌa agemai auga eꞌimaisa. ");
INSERT INTO mek_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ke isa Iudea au akaikiꞌaꞌi auꞌi epoꞌiai kansolo auga mo ganinagai, Iesu faagagai kapaꞌina fekekapa fouga keifania auga anina aeani kaiꞌiai aepea. ");
INSERT INTO mek_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Iesu emae aisama, isa Pilato eega elao Iesu imaauga feafia eoma, ke Pilato isa elogoaina. ");
INSERT INTO mek_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Egae kai isa eega elao Iesu imaauga kolotiai eafiopua. Ke Iudea papiauꞌi eꞌi kagakaga kainai, mae papiauꞌi tiapuai kemokaꞌi tiapuga eafiia Iesu imaauga emokaisa. ");
INSERT INTO mek_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ke agegani aisama Iudea papiauꞌi Deo keau afagaina kina puo, fiakoa mo afu agaꞌogai fopa mapegai la mamaga keapi kanina, kai agaꞌo aepapinauga auga alogai eogeisa. ");
INSERT INTO mek_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kalilea papieꞌi Iesu fou kelao kemai auꞌi Iosepa muninai mo kelao Iesu eoge laaga keisa, ke ala eoge oma auga isafa keisa. ");
INSERT INTO mek_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Egae kai kemue kelao paguai kai eꞌi kagakaga kainai Iesu imaauga oili, ke amu fogaꞌi feloꞌiai fekepakuma keoma auꞌi amuꞌi kepafuaꞌi keka. Kai Moses ega iifa kainai Deo keau afagaina kinagai auga kelaagai. ");
INSERT INTO mek_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Deo keau afagaina kina efua egani amagai ipauma egaꞌina papieꞌi Iesu ooga fekepakuma keoma puo, amu o kepakuma auꞌi amuꞌi kepafuaꞌi keka auꞌi keafiiꞌi la kelao. ");
INSERT INTO mek_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kelao laai aisama, kepo la ake kepae apua auga eelai keisa. ");
INSERT INTO mek_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ega puo kekoko kai Lopia Iesu imaauga akeisa. ");
INSERT INTO mek_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ega kainai keapa kapaꞌina emia auga keopopolaga kai fiakoa mo au gua tiapu eaeaꞌi, kimage koa iꞌopoga keeaea alogaina auꞌi keiꞌiukaꞌi eeꞌiai keapafoki. ");
INSERT INTO mek_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ega aisama egaꞌina papieꞌi kekauai kemaniꞌi alogaina puo keꞌualai keomukipo. Kai au auniꞌi isa kepainiꞌi keinaka, “Kapa puo oi maaga maunina auga mae auꞌi epoꞌiai okapuga? ");
INSERT INTO mek_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Iesu inae laaꞌi isa emaunimue! Ke isa oi fou Kalileai oagu alogai maamiai iina eifa oma auga amoopolaga: ");
INSERT INTO mek_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Papiau Aumauni Gauga laomai apalaꞌi kekapaꞌi auꞌi imaꞌiai fekepaaua kolotiai fekeauꞌuꞌua femae, ke kina oiso aisama femaunimue pugu,’ eoma.” ");
INSERT INTO mek_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ke au auniꞌi egaꞌina iifaga keifania efua aisama, egaꞌina papieꞌi Iesu ega iifa keopolaga. ");
INSERT INTO mek_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ke isa laai kemue kelao aisama, kapaꞌina mo kemia auga maꞌoai Iesu ega imoi auꞌi ke egae kai mo kai mo keagu auꞌi, maꞌoai maaꞌiai keifafoua. ");
INSERT INTO mek_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Egaꞌina papieꞌi kelao laai kapaꞌina kemia keisa imoi maaꞌiai keifafouꞌi auꞌi akaꞌi, Maria Makdalena, Ioanna, ke James ina Maria. Ke papie isaꞌi fou la kelao auꞌi isafa, imoi maaꞌiai keifafoua. ");
INSERT INTO mek_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kai egaꞌina papieꞌi kapaꞌina keifania auga kafoꞌo koa niniꞌaniꞌi kepamia puo, imoi maꞌoai egaꞌina iifaꞌi akepakoꞌaniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kai Peto eꞌue epiau elao laai aiso eokoko aisama, Iesu imaauga kemoka tiapuga mo egae eka eisa. Ega aisama emue kai kapaꞌina mo kemia auga oko aelogo felo puo, ekauai alogaina eopofua, ifo mo opogai eopolaniꞌi. ");
INSERT INTO mek_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Egaꞌina kinagai mo Iesu muninai kepea auꞌi auniꞌi pagua aka Emmaus kelao. Egaꞌina paguaga auga Ierusaleme taonina fou epoꞌi 11 kilomita. ");
INSERT INTO mek_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Isa kelao alogai Iesu kolotiai ala emae oma auga fouga maꞌoai keifaniꞌi kepealaina. ");
INSERT INTO mek_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Isa kepea keniniꞌani ke Iesu faagagai kapaꞌina mo kemia auꞌi fouꞌi keifaifaniꞌi kai Iesu ifo emai fou kaiꞌialao kepea. ");
INSERT INTO mek_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kai Deo isa maaꞌi ekaisapua puo kaisau isa fou kepea auga oko akelogo. ");
INSERT INTO mek_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ke Iesu isa epaꞌani peniꞌi einaka, “Oi aunimi kapaꞌina fouga oifania opealaina?” eoma. Ega aisama isa keapakipo kai Iesu keopolaga aloꞌi emafu alogaina. ");
INSERT INTO mek_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ke auniꞌi epoꞌiai agaꞌo aka Kleopas keoma auga Iesu epaꞌani penia einaka, “Ierusaleme taoninai keagu auꞌi maꞌoai kapaꞌina mo kemia auꞌi kelogo afeꞌai. Kai oi peagege aumu ma puo ifomu mo iꞌina kinaꞌiai kapaꞌina kemia auꞌi alologo?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ke Iesu isa epaꞌani peniꞌi pugu einaka, “Kapaꞌina mo kegama?” eoma. Ke isa iifa kepamue keinaka, “Iesu Nasareta auga faagagai kapaꞌina kemia auꞌi fouꞌi aifania. Isa profeta agaꞌo Deo ke papiau maꞌoai maaꞌiai ega niniꞌani, ke ega pinauga fou isapuꞌi ipaumaꞌi. ");
INSERT INTO mek_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Ega kainai isa lai Israel papiaumai Roma kamanina imaꞌiai agepapealaimai auga afiaꞌamaga apaꞌaua. Kai sakedote lopiaꞌi ke lai keꞌimaimai lopiaꞌi fou isa keafiia Roma papiauꞌi imaꞌiai kepaaua iifa ipakainai femae keoma. Ke isa kolotiai keauꞌuꞌua emae. Ke pau kina oisa elao efua. ");
INSERT INTO mek_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Egaꞌina mo laaꞌi kai papie lai Iesu fou muninai auꞌi isaꞌi pau amagai ipauma kelao laai. ");
INSERT INTO mek_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Kai isa Iesu imaauga akeisa. Egae kai isa kemue kemai lai maamaisai agelo keapakina peniꞌi keisaꞌi auga keifania. Ke agelo Iesu emaunimue fouga maaꞌiai keifania auga, lai maamaisai isafa keifania puo kepakauai alogainimai. ");
INSERT INTO mek_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Egae kai lai epomaisai papiau isaꞌi kelao laai aisama, egaꞌina papieꞌi keifania koa iꞌopoga mo keisa kai, Iesu auga egae akeisa. ");
INSERT INTO mek_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ega aisama Iesu isa epainiꞌi einaka, “Oi kafoꞌo aumi. Ufainagai profeta Mesaia auga fouga maꞌoai keifaniꞌi kai oapoke alogaina, alomi koꞌagai alopakoꞌania! ");
INSERT INTO mek_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Oi Mesaia auga iꞌina kapaꞌi fekiekielainiꞌi kai Deo ega isapu akaikiꞌa afugai fekoko auga fologo kai alologo ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Egae kai Iesu Deo ega puka maꞌoai aloꞌiai isa ifo fouga Moses faagagai eꞌina ke profeta maꞌoai kapaꞌina mo keifaniꞌi auꞌi maaꞌiai oko epakaisa. ");
INSERT INTO mek_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ke kelao isa kelao paguaga kainagai aisama, Iesu pagua iꞌoina agaꞌo koa agelao pea epea. ");
INSERT INTO mek_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kai isa auniꞌi Iesu kegoi peni kapulania keinaka, “Pau egapigapi efua kina afaꞌagamo agefua puo, moapakipo inae fou amaagu,” keoma. Ega puo Iesu isa fou kelao egae keagu. ");
INSERT INTO mek_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Egae kai kegaaniani keoma alogai Iesu palafa eafiia Deo tenkiu epeniia efaipoga epeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ega aisama aloꞌi eagalai maaꞌi ekiakae isa kaisau auga kelogo. Kai Iesu fiakoa mo isa agoꞌiai eapagea akeisa pugu. ");
INSERT INTO mek_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ega aisama isa ifoꞌi mo kepaꞌani peniꞌi keinaka, “Keagai fou apea aniniꞌani alogai, Deo ega iifa pukagai eniniꞌani aisama, isa kaisau auga falogo auga guaꞌa aeafi opogaina ma? Iifa gome isa kapaꞌina eifania auga guaꞌa eafi opogaina kai isa kaisau auga alalogo paisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ega aisama egaꞌina kinagai mo kefiaisakoa mo kemue Ierusaleme taonina kelao pugu. Egae Iesu ega apostolo 11 ke papiau isaꞌi Iesu muninai kepea auꞌi fou kekaigugu keagu auꞌi keisaꞌi. ");
INSERT INTO mek_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ke egae keagu auꞌi epoꞌiai keniniꞌani keifa keinaka, “Lopia Iesu emaunimue auga koꞌa ipauma. Ke Saimon Peto keoma auga isafa eapakina penia,” keoma. ");
INSERT INTO mek_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Egae kai egaꞌina auꞌi auniꞌi kapaꞌina mo keagai kemia ke Iesu palafa ifaipogai isa kaisau auga epalogoniꞌi auga fouga maaꞌiai keifafoua. ");
INSERT INTO mek_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Egaꞌina auꞌi auniꞌi kapaꞌina emia auga fouga keifaifania kai, Iesu ifo emai epoꞌiai eapafoki ke epainiꞌi einaka, “Deo ega gagao eemiai gaka,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kai isa Iesu keisa aisama, kekauai kemaniꞌi alogaina, ke keisa isage agaꞌo keoma puo akepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ega aisama Iesu isa epainiꞌi einaka, “Kapa puo alopakoꞌaniau, alomiai oopopo alogaina? Foloopopo. ");
INSERT INTO mek_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Imau ke ifeu amoisaꞌi. Iꞌina lau Iesu ifou imaau! Omai amoafi opogainiau amoisa. Isage auga pitioga ke uniaga laaꞌi kai, lau auga pitiou ke uniau fou kekae amoisaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Isa egaꞌina eifania afegai, ife ima fou epakinaiꞌi. ");
INSERT INTO mek_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kai kekauai alogai keopofua ke koꞌa ipauma Iesu emaunimue auga keisa puo, aloꞌi egama alogaina. Kai akepakoꞌania paisa puo Iesu isa epaꞌani peniꞌi einaka, “Oi eemiai kapa agaꞌo ekaega ma alaania?” eoma. ");
INSERT INTO mek_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ega aisama maꞌa iuma agaꞌo afa kepeniia. ");
INSERT INTO mek_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ke isa eafiia agoꞌiai keisaisa kai eaniia. ");
INSERT INTO mek_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Egae kai epainiꞌi einaka, “Moses ega iifa profeta kepapua, ke Sam puka aloꞌiai lau fou kepapuaꞌi auꞌi maꞌoai koꞌaꞌi mo fekemia. Iꞌina iifaga auga lau oi fou aaguega kai maamiai laifaniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Iesu ega eifa oma aisama, aloꞌi epaagalaisa, opoꞌi epaeaea, ega koa Deo ega iifa pukai kekae auꞌi fekelogo felo eoma. ");
INSERT INTO mek_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ke epainiꞌi einaka, “Deo ega iifa pukagai iina kepapua oma: Mesaia agekiekie agemae, ke kina oiso aisama agemaunimue. ");
INSERT INTO mek_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Egaꞌina afegai Mesaia kepakoꞌania auꞌi isa akagai papiau eꞌi laomai apalaꞌi fekeumakalainiꞌi, ke Deo isa eꞌi laomai apalaꞌi ageꞌagegeainiꞌi auga fouga Ierusaleme taoninai akeꞌina akeinogonia, ke akelao agofaꞌa fofouga papiauꞌi maꞌoai isafa maaꞌiai akeinogonia. ");
INSERT INTO mek_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Oi kapa maꞌoai maamiai oisa auga papiau maaꞌiai foifafoua. ");
INSERT INTO mek_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Lau Amau kapaꞌina epakoꞌania eifania auga eemiai alaulaisa. Alaulaisa agoafia aisama, isapu ufai ageake alomi agepapogua. Kai pau aloafia koa puo inae Ierusaleme taoninai mo foagu felao egaꞌina kinagai kai,” eoma. ");
INSERT INTO mek_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Egaꞌina afegai kina agaꞌogai Iesu egaꞌina papiauꞌi epapealaiꞌi kelao Betani taonina eegai kai, ima eafiakae eifa felo peniꞌi Deo eegai kapa feloꞌi fekeafiꞌi eoma. ");
INSERT INTO mek_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Iesu Deo ega gafegafe egaꞌina papiauꞌi epeniiꞌi alogai, Deo Iesu eafiia ufai eꞌagauaina. ");
INSERT INTO mek_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Egae kai isa Iesu keau afagaina kai maialogamaꞌi mo kemue Ierusaleme taonina kelao. ");
INSERT INTO mek_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ke egae Deo ega eꞌai aufa kina mo keagu Deo keau afagaina aefuafua. ");
INSERT INTO mek_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ufainagai aagoa ufa fou akegama koa kai Iifa eagu. Ke Iifa egaꞌina auga Iesu Deo fou keagu, ke isa ifo isafa Deo. ");
INSERT INTO mek_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ke aagoa ufa fou akegama koa kai isa Deo fou keagu. ");
INSERT INTO mek_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ke agofaꞌai kapa maꞌoai Deo epagamaꞌi auꞌi isa faagagai epagamaꞌi. Ke kapa agaꞌomo ganinagai ifo aegama kai, maꞌoai mo isa faagagai kegama. ");
INSERT INTO mek_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Isa alogai mauni ekae ke egaꞌina maunina eaea papiau aumauni eeꞌi emaiseina. ");
INSERT INTO mek_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ke eaea egaꞌina umina egefa kai umina eaea egaꞌina ageafialo afaekaina. ");
INSERT INTO mek_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kai eaea egaꞌina aemai koa kai Deo au agaꞌo aka Ioane ekinaga eulaisa emai. ");
INSERT INTO mek_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Isa emai auga eaea egaꞌina fouga koꞌa auga feifafoua, ega koa papiau maꞌoai isa aina fekelogo, ke eaea egaꞌina fekepakoꞌania eoma. ");
INSERT INTO mek_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Kai isa ifo auga eaea egaꞌina laaꞌi. Isa emai auga eaea egaꞌina fouga mo feifafoua puogai emai. ");
INSERT INTO mek_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ke afaꞌagamo omaꞌe koa kai egaꞌina eaea koꞌa ipauma, papiau maꞌoai eaea fepeniꞌi auga agemai agofaꞌai. ");
INSERT INTO mek_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Isa emai agofaꞌai ke agofaꞌa isa faagagai egama mo ganinagai, agofaꞌa isa kaisau auga aelogo. ");
INSERT INTO mek_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Isa emai ifo ega agoai ega papiau epoꞌiai eagu kai, isa ifo ega papiau isa anina akeani akeafia. ");
INSERT INTO mek_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ega mo ganinagai kaisau isa keafiia ke aka kepakoꞌania auꞌi Deo gauga fekemia auga isapuga epeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ega koa emia auga, isa papiau aumauni okoꞌiai kemauni kainai Deo gauga akemia. Ke isa papiau aumauni eꞌi iifai kemauni kainai Deo gauga akemia. Ke isa papie akafaꞌi eꞌi logoai kemauni kainai Deo gauga akemia kai, Deo ifo ega logoai kemauni kainai isa Deo gauga kemia. ");
INSERT INTO mek_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Iifa egaꞌina papiau aumauni emia emai aagoai epoꞌaisai eagu. Iꞌa isa ega eaea ke ega isapu akaikiꞌa aisa. Egaꞌina eaea ke isapuga akaikiꞌa auga Ama Deo Gauga agaꞌomo mo auga eegai emai. Ke isa gafegafe akaikiꞌa alo epogu ke Deo ega iifa koꞌa ipauma auga. ");
INSERT INTO mek_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ke Ioane isa fouga eifa koꞌania eagaga einaka, “Lau au agaꞌo fouga laifania lainaka, ‘Lau muniuai agemai auga lau ekaꞌegainiau, gome isa lau alamauni koa kai eagu,’ laoma. Egaꞌina auga isa. ");
INSERT INTO mek_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ke isa gafegafe akaikiꞌa alo epogu auga faagagai iꞌa maꞌoai kapa feloꞌi maꞌo eegai eegai aafiꞌi. ");
INSERT INTO mek_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Gome Deo papiau kapaꞌina fekekapa eoma iifaga auga Moses epeniia papiau epeniiꞌi. Kai ega gafegafe akaikiꞌa ke ega iifa koꞌa ipauma auga Iesu Kristo faagagai emai papiau keafiia. ");
INSERT INTO mek_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ke kai agaꞌo Deo aeisaisa kai, Deo Gauga agaꞌomo, ifo isafa Deo, ke Ama kaina kainai eague auga Ama kaisau auga iꞌa epalogoniꞌa. ");
INSERT INTO mek_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Pau Iudea papiauꞌi Ierusalemeai keagu auꞌi keoge sakedote auꞌi ke Lefi ikupuga auꞌi fou keulaiꞌi Ioane eega kelao, ke isa kaisau auga fekepaꞌani penia keoma aisama, iꞌina auga isa ifo fouga eifafou koꞌania auga. ");
INSERT INTO mek_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Isa kaisau auga fouga koꞌa mo eifania ke eifa ofakaea mo einaka, “Lau Mesaia laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ega aisama isa kepaꞌani pugu keinaka, “Ega koa aisama, oi kaisau? Oi Elaija ma?” keoma. Isa einaka, “Lau Elaija laaꞌi,” eoma. Ke isa keinaka, “Ke oi Profeta Aumu ma?” keoma. Isa einaka, “Laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ke kepaꞌani penia pugu keinaka, “Ega koa aisama, oi kaisau? Oi ifomu foumu ala aloifa oma? Iifa agaꞌo mopamue lai mopenimai, ega koa agalao aisama, keulaimai papiauꞌi maaꞌiai faifania,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ega aisama Ioane profeta Aisaea ega iifai isa eꞌi iifa epamue einaka, “Lau auga aufalao agaꞌo ago maininai eagaga einaka, ‘Lopia faugai keaga amopaꞌopaina’ eoma au,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ke Faliseo auꞌi isaꞌi keulaiꞌi kemai auꞌi egae keapa. ");
INSERT INTO mek_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Isa Ioane kepaꞌani penia keinaka, “Oi Mesaia laaꞌi, Elaija laaꞌi, o Profeta aumu laaꞌi looma koa aisama, kapa puo baptismo lopipeni?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ega aisama Ioane einaka, “Lau feisai mo baptismo lapipeni. Kai epomiai au agaꞌo oi alologonia auga eapae. ");
INSERT INTO mek_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Isa lau muniuai agemai auga au akaikiꞌa ipauma, ega isapu lau eꞌu isapu ekaꞌegaina. Ega kainai lau isa ife kamataga ufe mo ganinagai alagupuka afaekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Iꞌina kapaꞌi maꞌoai Jordan agapuge apiegai, afu aka Betani, Ioane baptismo epipeni afugai kemia. ");
INSERT INTO mek_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ke egani aisama, Ioane maaga elao Iesu epea isa eega emai eisa ke eifa einaka, “Maami galao Sipi Gauga Deo eegai emai, agofaꞌa papiauꞌi maꞌoai eꞌi laomai apalaꞌi epuaꞌi auga emai amoisa. ");
INSERT INTO mek_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Lau maamiai laifa kakaua auga isa fouga laifania lainaka, ‘Au agaꞌo lau muniuai agemai auga lau ekaꞌegainiau, gome isa lau alamauni koa kai eagu,’ laoma. ");
INSERT INTO mek_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Lau ifou auga isa alalogonia kai, lau lamai feisai baptismo lapipeni ega koa Israel papiauꞌi isa kaisau auga fekelogo laoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ioane egaꞌina iifaꞌi eifaniꞌi afegai, Iesu faagagai kapaꞌina emia auga fouga eifafoua einaka, “Lau Deo ega Spiritu koofi koa iꞌopoga emia ufai eake emai isa kania laagai laisa. ");
INSERT INTO mek_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Lau isa kaisau auga falalogo koa kai, lau eulaisau feisai baptismo fapipeni eoma auga epainiau einaka, ‘Au agaꞌo kania laagai Lau eꞌu Spiritu ageake ke eegai ageka aloisa auga, isa Lau eꞌu Spirituai baptismo agepipeni eoma.’ ");
INSERT INTO mek_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ke Deo kapaꞌina lau maauai eifania auga emia laisa puo, isa Deo Gauga auga koꞌa mo laifafoua,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ke egani aisama, Ioane ega imoi auniꞌi fou egaꞌina afugai mo keapa pugu. ");
INSERT INTO mek_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ke egae keapaega kai maaga elao Iesu epea pagai eisa aisama eifa einaka, “Maami galao Sipi Gauga Deo eegai emai auga amoisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ioane ega imoi auniꞌi Ioane ega eifa oma aina kelogonia aisama, kelao Iesu muninai kepea. ");
INSERT INTO mek_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ke Iesu eꞌafoaipini isa muninai kepea eisaꞌi aisama epaꞌani peniꞌi einaka, “Kapaꞌina anina oani?” eoma. Ke isa keinaka, “Rabai, oi kapai loagu?” keoma. (Rabai, iꞌa malaꞌaisai auga ‘Pamalele Aumu.’) ");
INSERT INTO mek_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ke Iesu einaka, “Omai alao lau kapai laagu auga afuga agoisa,” eoma. Ega puo isa Iesu fou kelao kapai eagu auga afuga keisa. Ke egaꞌina kinagai egae fou keagu. Ke egaꞌina kina maaga auga 4 oꞌclock gapigapi. ");
INSERT INTO mek_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ioane ega imoi auniꞌi Ioane kapa eoma aina kelogonia, ke kelao Iesu muninai kepea auꞌi agaꞌo auga aka Andru, Saimon Peto keoma auga akina. ");
INSERT INTO mek_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andru Iesu epuaꞌafuga elao aisama, kapaꞌina ekapa kakaua auga, isa felogai mo elao aaga Saimon eisa, ke epainia einaka, “Lai Mesaia akapulaisa,” eoma. Mesaia iꞌa malaꞌaisai auga, Deo ekinaga kania oiliai eꞌefa auga fouga eifania. ");
INSERT INTO mek_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ke Andru Saimon elaoaina Iesu eegai. Ke Iesu Saimon eisa aisama eifa einaka, “Oi Saimon Ioane gauga aumu. Oi akeifanio Sefas akeoma,” eoma. Sefas auga Hibru malaꞌi kai Grik malagai auga Peto. Ke iꞌa malaꞌaisai auga Fopa. ");
INSERT INTO mek_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ke egani aisama, Iesu gakailai Kalilea ago galao eoma. Egaꞌina alogai au aka Filip eisa ke epainia einaka, “Muniuai mopea,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip auga Andru Peto auniꞌi Betsaida taonina auꞌi koa iꞌopoꞌi isa isafa egaꞌina taonina auga. ");
INSERT INTO mek_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Iesu Filip eifaga afegai Filip elao Natanael eisa epainia einaka, “Ufainagai Moses Deo ega iifa pukagai au agaꞌo fouga epapua ke profeta isafa fouga kepapua auga akapulaisa. Isa auga Iesu Nasareta paguaga auga, Iosepa gauga,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Kai Natanael einaka, “Nasareta! Kapa agaꞌo felo egae agemai ma?” eoma. Ke Filip einaka, “Mai alao moisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ke Iesu Natanael isa eega emai eisa aisama, isa fouga eifania einaka, “Amoisa! Israel auga koꞌa ipauma auga inamoꞌe. Ke isa alogai pifoge kapaꞌi agaꞌo laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael Iesu ega eifa oma aina elogonia aisama epaꞌani penia einaka, “Ala looma lau lologoniau?” eoma. Ke Iesu einaka, “Filip oi aeifanio koa kai oi fik auga papagai loapaega kai laisao,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael Iesu ega eifa oma aina elogonia aisama eifa einaka, “Rabai, oi Deo Gauga aumu ke oi Israel eꞌi Kin Aumu,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ega aisama Iesu einaka, “Lau oi fik auga papagai loapa laisao laoma puo oi lau lopakoꞌaniau. Oi kapa akaikiꞌaꞌi iꞌina kapaꞌi kekaꞌegainiꞌi auꞌi akemia aloisaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ke eifa pugu einaka, “Iifa gome maamiai laifania, ufa ageagalai ke oi maꞌoai Papiau Aumauni Gauga kania laagai Deo ega agelo akeake akeꞌagau agoisaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ke kina auniꞌi kelao afegai kina oiso aisama, amagelofe miamiaga agaꞌo Kalilea agogai, Kana taoninai emia. Ke Iesu ina elao egaꞌina miamiagai. ");
INSERT INTO mek_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ke miamia inagome auga iifa eulaisa Iesu ega imoi isafa fou egaꞌina miamia kelao. ");
INSERT INTO mek_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ke miamia egaꞌinagai keaguega kai fino efua aisama, Iesu ina isa epainia einaka, “Isa eeꞌiai fino efua,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kai Iesu isa ina epainia einaka, “Papie, lau eꞌu kina aekaina koa puo, kapa puo iꞌina kapaꞌi makapaꞌi looma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kai Iesu ina pinauga auꞌi epainiꞌi einaka, “Kapaꞌina fokapa ageoma auga fokapa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Egaꞌina miamia emia alogai Iudea papiauꞌi eꞌi kagakaga kainai imaꞌi iikuga feina oga maꞌoai mo imagea aloꞌiai fei kepaꞌefaukaꞌi eeꞌiai mo kepaaguꞌi keagu. Ke oga egaꞌina aloꞌiai fei 80 liters elao 90 liters koa iꞌopoga aloꞌiai keka. ");
INSERT INTO mek_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu pinauga auꞌi epainiꞌi einaka, “Oga omaiseiniꞌi fei akeꞌi opapoguꞌi,” eoma. Ke pinauga auꞌi oga kemaiseiniꞌi fei akeꞌi kepapoguꞌi. ");
INSERT INTO mek_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Egae kai epainiꞌi einaka, “Pau afa amoakoaua amolaoaina miamia eꞌima lopiaga amopenia,” eoma. Ke pinauga auꞌi Iesu eifania koa kekapaisa. ");
INSERT INTO mek_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ke miamia eꞌima lopiaga fei fino emia auga einu opogaina. Fei keakoaua auꞌi mo fino egaꞌina kapai emai auga kelogo kai, miamia lopiaga fino egaꞌina kapai emai auga aelogo. Ega puo fei fino emia auga einu opogaina aisama, amage mamaga auga eifaga ega elao. ");
INSERT INTO mek_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ke epainia einaka, “Papiau maꞌoai fino iinuga felo auga kepapealai kakaua elao laꞌafou auꞌi keinu. Ke fino maꞌo keinu afegai kai, fino iinuga aefelo alogaina auga muniai kai keafilaisa papiau keinu. Kai oi auga fino felo ipauma auga loꞌoamenia emai fuagai kai loafilaisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iꞌina auga Iesu mirakulo ekapa kakaua auga, ke egaꞌina mirakulo auga, Kalilea agogai Kana taoninai emia. Ega koa ekapaisa, isa ega isapu ke ega eaea akaikiꞌa auga epafokia, ke ega imoi isa kepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Egaꞌina afegai Iesu ina, aaga akina, ke ega imoi fou kelao Kapenaum taonina, egae kina pika koa mo fou keagu. ");
INSERT INTO mek_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ke Iudea papiauꞌi Pasover miamiaga kekapa auga kina emai eꞌani aisama, Iesu Ierusaleme taonina elao. ");
INSERT INTO mek_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ke elao egae Deo ega eꞌai au keagu polomakau sipi, ke koofi ineiꞌi fou keꞌafaꞌafalainiꞌi, ke papiau isaꞌi auga, teipoloai keagu moni keau pagainia eisaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ke isa apaꞌu eafiia uipi ekapaisa efua aisama, aꞌo maꞌoai, polomakau ke sipi isafa fou euokaꞌi Deo ega eꞌa alogai epaꞌalaiꞌi. Ke moni keau pagainia papiauꞌi isafa eꞌi silifa monina eafiia efopuoka, ke eꞌi teipolo epaefo pagainiꞌi. ");
INSERT INTO mek_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ke koofi ineiꞌi keꞌafaꞌafalainiꞌi auꞌi epainiꞌi einaka, “Iꞌina kapaꞌi inae amopaꞌalaiꞌi! Lau Amau ega eꞌa afaꞌafa afuga folopamia!” eoma. ");
INSERT INTO mek_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ke Iesu ega imoi isa kapaꞌina ekapaisa keisa, ke ega eifa oma aina kelogonia aisama, ufainagai Iesu fouga profeta Deo ega iifa pukagai iina kepapua oma auga keopolaga, “Deo, lau alou koꞌagai oi emu eꞌa anina laani alogaina kainai, eꞌa egaꞌina faagagai kapaꞌina agemia auga lau alou agepalifua.” ");
INSERT INTO mek_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Iudea papiauꞌi Iesu ega ekapa oma keisa aisama, kepaini kapulania keinaka, “Mirakulo gouga kapa alokapa ega koa agalogo oi iꞌina kapaꞌi maꞌoai alokapaꞌi agekaina auga isapuga eemuai ekaega agaoma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ke Iesu einaka, “Deo ega eꞌa iꞌina foauoka, ke kina oiso alogai alapaꞌuegenia pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ega aisama Iudea papiauꞌi keifa keinaka, “Deo ega eꞌa iꞌina kepaapa auga inipo ouꞌaga pani kuagai imagea eafiia kai kepafua kai, oi auga kina oiso alogai alopaꞌuegenia ma looma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kai Iudea papiauꞌi Iesu Deo ega eꞌa koꞌa auga aeifania kai, isa ifo imaauga Deo ega eꞌa koa iꞌopoga auga fouga eifania auga akelogo. ");
INSERT INTO mek_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kai muniai Iesu maeai emaunimue aisama kai, ega imoi isa kapaꞌina eifania auga keopolaga. Ega aisama isa Deo ega iifa ufainagai profeta kepapuaꞌi auꞌi, ke Iesu kapaꞌina eifania auga fou kepakoꞌaniꞌi. ");
INSERT INTO mek_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pau Iesu Pasover miamiagai Ierusalemeai eagu alogai, papiau maꞌo isa mirakulo gouꞌi ekapaiꞌi keisaꞌi aisama, isa aka kepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kai Iesu alo fofouga egaꞌina papiauꞌi eeꞌiai aeogeisa, gome isa papiau maꞌoai aloꞌi ala koa auga elogo. ");
INSERT INTO mek_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ke isa aufalao agaꞌo feafia maagai papiau ala koa auga feifania faekaina, gome isa papiau aloꞌiai kapaꞌina keopolaga auga elogo efua. ");
INSERT INTO mek_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Egaꞌina kinagai Iudea papiauꞌi keꞌimaꞌi lopiaga agaꞌo Faliseo ikupugai emai auga aka Nikodemus eagu. ");
INSERT INTO mek_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Isa gapiai emai Iesu eegai kai epainia einaka, “Rabai, lai alogo oi auga pamalele aumu Deo eegai lomai. Gome Deo aufalao agaꞌo eegai aeagu auga mirakulo gouꞌi oi lokapaꞌi koa afaekapaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ke Iesu einaka, “Iifa gome maamuai laifania, au agaꞌo Deo ega mauniai afaemauni pugu koa aisama, isa Deo ega agofaꞌa ageisa afaekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Kai Nikodemus einaka, “Au agaꞌo eapao efua auga ala koa iꞌopoga agemauni pugu? Koꞌa isa afaemue ina gua alogai afaekoko, ke afaemauni pugu!” eoma. ");
INSERT INTO mek_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ke Iesu einaka, “Iifa gome maamuai laifania, au agaꞌo ega laomai apalaꞌi afaeumakalainiꞌi kai feisai ke Deo ega Spirituai baptismo afaeafia ega koa mauni mamaga afaeafia auga, Deo ega agofaꞌai agekoko afaekaina. ");
INSERT INTO mek_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Iifa koꞌa, kaisau papiau aumauni faagaꞌiai emauni auga papiau aumauni. Kai kaisau Deo ega Spirituai emauni auga mauni mamaga Deo ega Spiritu eegai emai auga eafia. ");
INSERT INTO mek_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Lau oi ‘Deo ega mauniai fomauni pugu’ laoma iifaga aꞌo lologo folokauai. ");
INSERT INTO mek_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ameku anina eani kapai gapua gamai eoma aisama, egae epua emai. Ke oi ameku epua auga aꞌo alologo kai, kapai emai o ala elao auga afoloifania. Ega koa iꞌopoga mo, papiau maꞌoai Deo ega Spirituai kemauni auꞌi isafa ala kemauni oma auga agoisa agoifania afaekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ke Nikodemus epaꞌani einaka, “Ala koa iina koa agemia agekaina?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iesu einaka, “Oi Israel papiauꞌi eꞌi pamalele aumu lakoa, alakoa iꞌopoga iꞌina kapaꞌi okoꞌi alologo? ");
INSERT INTO mek_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Iifa gome maamuai laifania. Lau ke eꞌu imoi fou kapaꞌina alogo auga fouga oi maamiai aifania, ke aisa auga koꞌa mo oi maamiai aifafoua. Ega mo ganinagai oi lai kapaꞌina koꞌa mo aifafoua auga alopakoꞌania paisa. ");
INSERT INTO mek_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ke lau aagoa kapaꞌi fouꞌi oi maamiai laifaniꞌi kai, oi lau alopakoꞌaniau paisa. Ega koa aisama ufa kapaꞌi fouꞌi maamiai alaifaniꞌi aisama, ala koa lau agopakoꞌaniau? ");
INSERT INTO mek_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ke kai agaꞌo ufa aelaolao kai, kaisau egae eake emai auga mo ufa elao. Egaꞌina auga Papiau Aumauni Gauga. ");
INSERT INTO mek_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ke ufainagai ago maininai Moses kopai kaapa iisa ekapaisa au uufagai eogeisa kai eafiakae epaapa. Ke papiau kaapa eagaiꞌi fekemae koa iꞌopoga kai, maaꞌi elao auli kaapaga egaꞌina au uufagai keisa aisama, feloꞌi kemia. Ega koa iꞌopoga, Papiau Aumauni Gauga isafa au kolotinai fekeafiakae. ");
INSERT INTO mek_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ega koa papiau maꞌoai isa akepakoꞌania auꞌi agu pagai maunina fekeafia eoma.” ");
INSERT INTO mek_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Gome Deo agofaꞌa papiauꞌi aniꞌi eani alogaina kainai, Gauga ega mo agaꞌomo auga eulaisa emai iꞌina agofaꞌa papiauꞌi eeꞌiai, ega koa kaisau mo isa akepakoꞌania auꞌi fakemae umamo kai, agu pagai maunina fekeafia eoma. ");
INSERT INTO mek_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Gome Deo, Isa Gauga iꞌina agofaꞌa papiauꞌi eꞌi laomai apalaꞌi afa fepeniꞌi puo aeulaisa aemai kai, Isa Gauga faagagai agofaꞌa papiauꞌi kaniaꞌi feagamauga eoma puo eulaisa emai. ");
INSERT INTO mek_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ega puo kaisau isa epakoꞌania auga afa apala afaepenia. Kai kaisau isa aepakoꞌania auga afa apala eafiia efua, gome isa Deo Gauga ega mo agaꞌomo auga aka aepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Deo papiau kapaꞌi ega kekapa oma auꞌi afa iina epeni omaꞌi: Eaea emai agofaꞌai kai, papiau aumauni aloꞌi koꞌagai umina anina keani kai eaea auga anina akeani, gome isa eꞌi laomai apala. ");
INSERT INTO mek_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Isa ega kekapa oma, gome kaisau laomai apala ekapa auga, alo koꞌagai eaea anina aeani, ke ega laomai apalaꞌi egaꞌina afekefoki auga maniꞌina epaꞌaua puo, afaemai eaea alogai afaekoko. ");
INSERT INTO mek_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kai kaisau Deo ega iifa koꞌa ipauma auga agugai eagu auga, elao eaea alogai ekoko. Ega koa kapaꞌina isa ekapa auga Deo anina eani kainai mo ekapa auga papiau fekeisa fekelogo eoma.” ");
INSERT INTO mek_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Egaꞌina afegai Iesu ega imoi fou kepealai kelao Iudea ago afegai, egae ega imoi mo fou keagu ke baptismo epipeni. ");
INSERT INTO mek_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ke egaꞌina alogai Ioane isafa afu aka Aenon keoma, Salim paguaga eegai mo auga afugai eapa baptismo epipeni, gome egaꞌina afuga fei afuga. Ke papiau maꞌo kemai baptismo keafiia. ");
INSERT INTO mek_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Gome iꞌina kapaꞌi auga Ioane tipulai aeagu koa kai kemia. ");
INSERT INTO mek_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Egaꞌina alogai Ioane ega imoi isaꞌi, ke Iudea auga agaꞌo fou Iudea eꞌi kagakaga kainai papiau aloꞌi ofuga iikuga emia auga akekua kepaꞌaua. ");
INSERT INTO mek_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ke isa kemai Ioane kepainia keinaka, “Rabai, au egaꞌina oi fou Jordan apiegai oapa, ke fouga loifafoua auga baptismo epipeni, ke papiau maꞌoai isa eega kelao,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kai Ioane einaka, “Au agaꞌo kapaꞌina ufai kepenia auga mo ageafia. ");
INSERT INTO mek_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Oi ifomi lau iina laifa oma auga foifafoua, ‘Lau Kristo laaꞌi kai Deo eulaisau isa agogai laufai lamai au’ fooma. ");
INSERT INTO mek_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ifiao eamage auga, au kapa isa eakafania auga apuga. Ke ekefaꞌa, amage mamaga auga eega elao auga, eagu isa eꞌima, ke aina epaaua kapaꞌina ageifania auga aina felogo eoma. Ke muniai amage mamaga auga egaꞌina eniniꞌani aina elogo aisama, alo egama alogaina. Lau auga Kristo ekefaꞌa au. Ke alogama egaꞌina auga lau apu, ke pau egaꞌina alogama laalogamalaina efua. ");
INSERT INTO mek_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Isa au akaikiꞌa femia kai lau auga eꞌeleu famia. ");
INSERT INTO mek_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ke isa auꞌoniai emai auga papiau maꞌoai ekaꞌegai afeꞌainiꞌi. Kai aagoai emai auga aagoa isa apuga, ke ega niniꞌani auga aagoa papiauꞌi keniniꞌani koa iꞌopoga mo eniniꞌani. Ke isa ufai emai auga papiau maꞌoai ekaꞌegai afeꞌainiꞌi. ");
INSERT INTO mek_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Isa kapaꞌina eisa ke aꞌo elogonia auga koꞌa mo eifafoua kai, kai agaꞌo isa ega iifa anina aeani aeafia. ");
INSERT INTO mek_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kai papiau kapa isa ega iifa egaꞌina eafia epakoꞌania auga, isa egaꞌina pakoꞌagai Deo koꞌa gome auga eoma. ");
INSERT INTO mek_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Gome Deo au agaꞌo eulaisa auga Deo ega iifa eifania, gome Deo ega Spiritu isa epenia auga, epenia afaefuafua. ");
INSERT INTO mek_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ke Ama alo koꞌagai Gauga anina eani, ke kapa maꞌoai isa imagai epaaua. ");
INSERT INTO mek_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ega puo kaisau Deo Gauga epakoꞌania auga agu pagai maunina eafia kai, kaisau Deo Gauga aepakoꞌania auga, egaꞌina maunina afaeisa, gome Deo ega guakupu isa eegai ekae,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Ke Iesu kai agaꞌo baptismo aepenia kai, ega imoi mo baptismo papiau kepeniiꞌi. Ega mo ganinagai Faliseo auꞌi auga Iesu papiau isa ega imoi epamiaꞌi ke baptismo epeniiꞌi auga fouga kelogo auga Iesu elogo. Ke isa ega koa ekapaisa auga Ioane ekapa auga ekaꞌegaina. ");
INSERT INTO mek_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ke Lopia Iesu egaꞌina fouga elogo aisama, Iudea ago epuaꞌafuga emue Kalilea ago elao pugu. ");
INSERT INTO mek_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ke ega felao auga isa Samaria ago mo fepea oma felao, gome egaꞌina keagaga auga ofolaꞌo. ");
INSERT INTO mek_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ega puo elao Samaria agogai taoni aka Sika keoma auga alogai ekoko. Egaꞌina taonina auga ufainagai Iakobo ago eꞌele gauga Iosepa epeniia auga afuga eegai. ");
INSERT INTO mek_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ke egaꞌina afugai fei ipuga Iakobo eapiia kainai kepafaala Iakobo ega ipu keoma auga eka. Ke Iesu ega imoi fou kemai ipu egaꞌina niegai aisama, kina maaga atiafa koa iꞌopoga. Ke Iesu epea eafipugu puo egaꞌina ipuga eegai eagukipo elaagai. ");
INSERT INTO mek_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ke Samaria papiega agaꞌo emai fei galaꞌa eoma aisama, Iesu isa epainia einaka, “Fei afa mopeniau mainu,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Gome Iesu ega imoi auꞌi foꞌama iꞌafa taoni kelao. ");
INSERT INTO mek_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ke Samaria papiega Iesu epainia einaka, “Oi Iudea aumu ke lau auga Samaria papieu kai kapa puo lau logoiniau fei mapenio moinu looma?” eoma. Samaria papiega ega eifa oma, gome Samaria papiauꞌi liti o kaputi kepapinauga auga Iudea papiauꞌi afakepapinauga. ");
INSERT INTO mek_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kai Iesu einaka, “Oi Deo kapaꞌina epipeni, ke kaisau oi fei egoinio auga mologo koa aisama, oi isa fogoina, ke isa oi agu pagai feina fepenio,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ega aisama papie Iesu epainia einaka, “Au akaikiꞌa aumu, oi fei isakoaua kapa agaꞌo eemuai laaꞌi ke ipu isafa eake alogaina. Ega puo kapai agu pagai feina egaꞌina aloafia? ");
INSERT INTO mek_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Lai ufumai apamai Iakobo iꞌina ipuga eapiia epeniimai. Isa iꞌina ipuga feina einu ke gauga isafa keinu. Ke gauga auꞌi eꞌi sipi polomakau fou isafa iꞌina feina keinu. Kai oi auga Iakobo lokaꞌegaina ma puo iina loifa oma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iesu einaka, “Papiau maꞌoai iꞌina feina keinu auꞌi aisoꞌi agekupu pugu. ");
INSERT INTO mek_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kai kaisau lau fei isa lapenia auga ageinu auga aiso afaekupukupu pugu. Kai fei egaꞌina isa lapenia auga isa alogai afaefuga ageꞌuki agelao ageka aoniamo, ke agu pagai maunina ageafia,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ke papie isa epainia einaka, “Au akaikiꞌa aumu, fei egaꞌina mopeniau, ega koa aisou afaekupu pugu, ke fei ilaꞌa iina afalamaimai pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ke Iesu papie epainia einaka, “Molao akafamu moifaga kai fomue fomai pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ke papie einaka, “Lau akafau agaꞌo laaꞌi,” eoma. Ega aisama Iesu papie epainia einaka, “Oi akafamu agaꞌo laaꞌi looma auga koꞌa loifania. ");
INSERT INTO mek_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Gome iifa koꞌa auga, oi au ima loakafaniꞌi, ke au pau aunimi oague auga oi akafamu laaꞌi. Oi kapaꞌina pau mo loifania auga iifa koꞌa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ke papie einaka, “Au akaikiꞌa aumu, lau lalogo oi profeta aumu. ");
INSERT INTO mek_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Lai ufumai apamai iꞌina ikugai Deo keau afagaina kai, oi Iudea aumi oifa, iꞌa Deo faau afagaina afuga auga Ierusalemeai ooma,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ke Iesu isa epainia einaka, “Papie lau mopakoꞌaniau, gome kina agaꞌo emai, ke egaꞌina kinagai oi iꞌina ikugai, o Ierusalemeai Amaꞌa Deo afoloau afagaina. ");
INSERT INTO mek_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Oi Samaria papiaumi kaisau oau afagaina auga alologo kai oau afagaina. Kai lai Iudea papiaumai auga kaisau aau afagaina auga alogo, gome papiau Kaniaꞌi Isagamauga auga Iudea papiauꞌi faagaꞌiai emai. ");
INSERT INTO mek_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ega mo ganinagai kina agaꞌo agemai, ke egaꞌina kina auga emai efua puo papiau aloꞌi koꞌagai Deo keau afagaina auꞌi Deo ega Spiritu ega isapuai, ke Deo ega iifa koꞌagai mo Deo akeau afagaina. Gome Amaꞌa Deo papiau isa ega keau afagai oma auꞌi ekapuniꞌi. ");
INSERT INTO mek_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ke Deo auga Spiritu kainai, Isa keau afagaina papiauꞌi auꞌi Deo ega Spiritu ega isapuai Isa fekeau afagaina, ke Deo ega iifa koꞌaꞌi mo kaiꞌiai fekepea Deo fekeau afagaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ke papie eifa einaka, “Lau lalogo Mesaia agemai. (Mesaia auga keifaga Kristo keoma.) Ke isa agemai aisama, lai maamaisai kapa maꞌoai ageifafou afeꞌainiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ke Iesu isa epainia einaka, “Lau oi maamuai laniniꞌani au, lau isa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ke Iesu papie maagai egaꞌina eifania afegai mo, isa ega imoi kemue kemai, ke isa papie fou keniniꞌani keisa aisama kekauai alogaina. Ke kai agaꞌo aepaꞌani aeinaka, “Kapaꞌina anina loani, o kapa puo egaꞌina papiega aunimi oniniꞌani?” aeoma. ");
INSERT INTO mek_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Ke Iesu ega imoi kemai aisama, papie ega oga fei eakoaua auga egae epuaꞌafuga ekaega kai, emue elao taoniai papiau epainiꞌi einaka, “Omai, au agaꞌo lau kapa maꞌoai lakapaiꞌi auꞌi eifaniꞌi auga amoisa. Isa Mesaia afemia isafa?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ega aisama isa taoniai kepealai Iesu eega kelao. ");
INSERT INTO mek_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ke papiau Iesu eega kemaimai kai, Iesu ega imoi isa kegoi kapulania keinaka, “Rabai, kapa agaꞌo moania,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kai Iesu isa epainiꞌi einaka, “Lau oi foꞌama oko alologo auga eeuai ekae alaania,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ega aisama Iesu ega imoi auꞌi ifoꞌi mo epoꞌiai keifa keinaka, “Aufalao agaꞌo foꞌama emaiseina eaniia ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kai Iesu isa kapaꞌina keifania auga elogo puo eifa einaka, “Lau eꞌu foꞌama auga lau eulaisau auga kapaꞌina anina eani auga fakapa ke ega pinauga fapafua. ");
INSERT INTO mek_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Oi iina aloifa oma, ‘Gafa pani mo akelao afegai kai, foꞌama isafina kina agekaina alooma ma?’ Amoisa, lau oi lapainimi, maami amopakiakaea fani afuga amoisa. Gome foꞌama aniꞌi keogeiꞌi efua iꞌafeꞌi kina ekainia. ");
INSERT INTO mek_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ke foꞌama isafina auga afa isoge emia foꞌama eafia, agu pagai maunina afugai eogeꞌi. Ega koa au foꞌama efauga auga ke au foꞌama eafia auga, auniꞌi kaiꞌialao aloꞌi fegama. ");
INSERT INTO mek_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ega kainai iꞌina iifa koꞌa ipauma, ‘Au agaꞌo auga foꞌama efauga, ke agaꞌo auga foꞌama eafia.’ ");
INSERT INTO mek_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Lau oi laulaimi olao kapaꞌina oi afipuguꞌi alopaꞌauꞌi auꞌi oafiiꞌi omaiseiniꞌi. Papiau iꞌoiꞌi isaꞌi egaꞌina afipuguga kepaꞌaua kai, oi auga isa eꞌi afipuguai foꞌama anina eoge auga olao oafiia omaiseina,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ke Samaria papiauꞌi maꞌo egaꞌina taoninai keagu auꞌi Iesu kepakoꞌania, gome papie Iesu fouga, iina eifafou oma aꞌo kelogonia. “Isa lau kapa maꞌoai lakapaiꞌi auꞌi maauai eifaniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ega puo Samaria papiauꞌi kemai Iesu eegai aisama, kegoinia egae fou kegaagu keoma. Ke Iesu egae kina auniꞌi eagu. ");
INSERT INTO mek_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ke isa ega niniꞌani kainai, papiau maꞌo mo isafa isa kepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ke egaꞌina papiauꞌi papie kepainia keinaka, “Lai oi loifa puo Iesu alapakoꞌania, gome pau lai ifomai isa aina alogonia, ke alogo isa Mesaia, iꞌina agofaꞌa papiauꞌi kaniaꞌi Isagamauga auga paisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ke kina gua afegai, Iesu egaꞌina afuga epuaꞌafuga elao Kalilea ago. ");
INSERT INTO mek_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ke Iesu ifo eifa, profeta agaꞌo ifo ega paguai auga papiau isa afakeifa koko, ke au akaikiꞌa afakepamia eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kai isa elao Kalilea agogai ekoko aisama, Kalilea papiauꞌi Iesu keifa koko, gome isa isafa Pasover miamia kinagai egae Ierusalemeai keagu Iesu kapaꞌina mo ekapaiꞌi auga keisaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ega puo Iesu emai Kalilea agogai Kana taoninai fei fino epamia auga taoninai ekoko pugu. Ke au akaikiꞌa agaꞌo Roma kamanina papagai epinauga auga gauga eisafa Kapenaum taoninai eka auga egae eagu. ");
INSERT INTO mek_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Iꞌina auga Iesu Iudea agogai emai Kalilea agogai ekoko auga fouga elogo aisama, elao Iesu eegai egoinia gaake galao gauga gapafelo eoma. Gome isa gauga afaꞌagamo agemae eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ega aisama Iesu isa epainia einaka, “Oi mirakulo gouꞌi afakemia afoloisaꞌi koa aisama, lau afolopapakoꞌaniau,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kai au akaikiꞌa egaꞌina einaka, “Au akaikiꞌa aumu, lau gau aemae koa kai, mai alao mopafelo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ke Iesu isa epainia einaka, “Molao, oi gaumu ageagu,” eoma. Ke au egaꞌina Iesu kapaꞌina isa maagai eifania auga iifaga epakoꞌania, ke ekailai elao. ");
INSERT INTO mek_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ke isa keagai epeapea kai, ega pinauga auꞌi kemai isa gauga aemae auga fouga maagai keifania keinaka, “Oi gaumu aemae, eaguega,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ke isa gauga kina maaga kapagai efelo auga paꞌanina epaꞌani aisama, ega pinauga auꞌi keinaka, “Faai kinai 1 oꞌclock auama isafaga isa epuaꞌafuga,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ega koa emia aisama, au egaꞌina elogo Iesu kina maaga egaꞌinagai isa epainia, “Oi gaumu ageagu,” eoma. Ega puo isa ifo ke ega eꞌai kai mo kai mo keagu auꞌi fofougai Iesu kepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iesu Iudea agogai emai Kalileai aisama iꞌina mirakulo ekapaisa. Ke iꞌina mirakulo auga Kalilea agogai Iesu ega mirakulo ikapa gua epamia auga. ");
INSERT INTO mek_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Egae kai kina isaꞌi kelao afegai, Iudea papiauꞌi eꞌi miamia agaꞌo Ierusalemeai emia puo Iesu Ierusaleme elao. ");
INSERT INTO mek_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ke egae Ierusalemeai paꞌafi kepafaala Sipi Paꞌafina keoma auga eegai ofuga eꞌele agaꞌo eka. Ke egaꞌina ofugaga, Hibru papiauꞌi malaꞌiai keifaga Betesda keoma. Egae paapa ima kepoai kepaapaꞌi keapa. ");
INSERT INTO mek_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ke egae, isafa papiauꞌi maꞌo kekaaka. Egaꞌina papiauꞌi auga maakimiꞌi auꞌi, ifeꞌi emelo auꞌi, ke faagaꞌi fofouga emelo auꞌi. Isa egae keka kai fei agelao agemai auga keꞌimaisa. ");
INSERT INTO mek_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Gome egae kekaega kai, Lopia ega agelo kina agaꞌo epogai mo emai fei egaꞌina epalagulagua. Ke egaꞌina emia afegai mo kaisau eufai feisai eake auga, isafa kapa eafia auga faagagai laaꞌi emia, efelo. ");
INSERT INTO mek_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ke au agaꞌo egae eka auga inipo ouꞌaga oiso kuagai imagea oiso alogai eisafa. ");
INSERT INTO mek_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iesu elao egaꞌina auga eka eisa aisama, elogo isa auga inipo ealogai eisafa eka. Ke epaꞌani penia einaka, “Oi anina loani felomu momia looma ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ke isafa auga einaka, “Au akaikiꞌa aumu, ofuga feina elagulagu alogai aufalao agaꞌo lau fepalagainiau ofugai faake auga papiauga laaꞌi. Ega puo egae maake laomaoma kai aufalao iꞌoina agaꞌo eufai lau agouai eake,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ega aisama Iesu au egaꞌina epainia einaka, “Moꞌue, emu ile moafia mopea,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ke fiakoa mo au egaꞌina felo emia, eꞌue ega ile eafiia epea. Ke mirakulo iꞌina auga Iudea papiauꞌi Deo keau afagaina kinagai emia. ");
INSERT INTO mek_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ega puo Iudea papiauꞌi au felo emia auga kepainia keinaka, “Pau kina auga Deo isau afagaina kina. Ke lai emai kagakaga auga Deo isau afagaina kinagai oi emu ile foafia fopea auga eifa apua,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kai isa einaka, “Au lau epafeloisau auga epainiau, ‘Emu ile moafia mopea eoma,’ puo lau eꞌu ile laafiia lapea,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ega aisama Iudea papiauꞌi au egaꞌina kepaꞌani penia keinaka, “Au kapa oi epainio emu ile moafia mopea eoma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ke au felo emia auga kaisau isa epafelo auga aelogo, gome Iesu papiau egae kelaꞌafou auꞌi epoꞌiai eepouka elao. ");
INSERT INTO mek_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kai muniai Iesu isa Deo ega eꞌai eisa aisama epainia einaka, “Loisa, oi felomu lomia efua. Ega puo laomai apalaꞌi folokapaꞌi pugu, o laaꞌi koa aisama, kapa apala ipauma egaꞌina isafaga ekaꞌegaina auga agaꞌo oi faagamuai afemia,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ke au egaꞌina elao Iudea papiauꞌi maaꞌiai Iesu isa epafelo auga eifania. ");
INSERT INTO mek_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ega puo Iudea papiauꞌi Iesu keafi apalania, gome isa Deo isau afagaina kinagai egaꞌina kapaꞌi ekapaiꞌi. ");
INSERT INTO mek_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kai Iesu isa epainiꞌi einaka, “Lau Amau aufa kina epinauga mo emai iꞌina kina. Ke lau isafa lapinauga,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Egaꞌina kainai Iudea papiauꞌi guakupuai keuniaimoimo keaga agaꞌo kekapunia isa kegaaupugua keoma. Gome isa Moses ega iifa kainai Deo isau afagaina kinagai papiau pinauga agaꞌo fakekapa eoma auga mo iifaga aeaupea kai, Deo isafa eifaga isa Ama eoma. Ega koa ekapaisa Deo auga isa fou iꞌopoꞌi mo epamia. ");
INSERT INTO mek_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kai Iesu Iudea papiauꞌi isa kegaaupugua keoma auga elogo aisama, iꞌina iifagai eꞌi iifa epamue einaka, “Iifa gome maamiai laifania. Gauga kapa agaꞌo ifogamo afaekapa kai, isa Ama kapaꞌina ekapa eisa auga agekapa. Gome Ama kapaꞌina mo ekapa auga Gauga isafa iꞌopoga mo ekapa. ");
INSERT INTO mek_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Gome Ama Gauga alo koꞌagai anina eani alogaina ke kapaꞌina Isa ekapa auga Gauga epakina. Ke Ama isa kapa akaikiꞌaꞌi ipaumaꞌi iꞌina kapaꞌi kekaꞌegainiꞌi auga agepakina agekapaꞌi, ega koa fokauai alogaina eoma. ");
INSERT INTO mek_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Gome Ama mae papiauꞌi epamaunimueꞌi mauni mamaga epeniiꞌi koa iꞌopoga, Gauga isafa kaisau anina eani auga mauni mamaga epenia. ");
INSERT INTO mek_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Gome Ama kai agaꞌo afa felo o apala aepenia kai, egaꞌina pinauga Gauga imagai eogeaua, isa papiau eꞌi laomai felo o apala auga afa agepeniꞌi. ");
INSERT INTO mek_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ega koa papiau maꞌoai Ama au akaikiꞌa kepamia koa iꞌopoga, Gauga isafa au akaikiꞌa fekepamia eoma. Kai kaisau Gauga au akaikiꞌa aepamia auga Ama, Gauga eulaisa auga au akaikiꞌa aepamia. ");
INSERT INTO mek_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Iifa gome maamiai laifania, kaisau lau iifa laifania auga ainau elogo, ke lau eulaisau auga epakoꞌania auga agu pagai maunina eafia, ke Deo eegai afa apala afaeafia. Kai isa mae afugai epealai, epagai agu pagai maunina afugai ekoko efua. ");
INSERT INTO mek_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Iifa gome maamiai laifania, mae auꞌi Deo Gauga aina akelogo ke kaisau isa aina kelogo ke kainai akepea auꞌi akemaunimue akeagu auga kina agemai. Pau auga egaꞌina kina emai efua kainagai. ");
INSERT INTO mek_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Gome Ama ifo eegai mauni ekae koa iꞌopoga, Ama Gauga elogoaina ega koa Gauga ifo isafa mauni eegai feka eoma. ");
INSERT INTO mek_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ke Ama Gauga isapu epeniia papiau eꞌi laomai felo o apala auga afa fepeniꞌi eoma, gome isa Papiau Aumauni Gauga. ");
INSERT INTO mek_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Oi lau iꞌina iifaga laifania ainau ologo folokauai alogaina, gome kina agaꞌo agemai aisama, papiau maꞌoai kemae laai kekae auꞌi Papiau Aumauni Gauga aina akelogo. ");
INSERT INTO mek_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ke egaꞌina papiauꞌi laai akepealai, ke kaisau laomai feloꞌi kekapaiꞌi auꞌi akeꞌue mauni mamaga akeafia. Kai kaisau laomai apalaꞌi kekapaiꞌi auꞌi, eꞌi laomai apala afa akeafia. ");
INSERT INTO mek_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Lau ifou mo kapa agaꞌo alakapa afaekaina. Kai lau papiau eꞌi laomai felo o apala auga Amau eifania aina lalogo auga mo lakapa. Ke lau papiau eꞌi laomai afa lapipeni auga laomai felogai mo lakapa, gome lau auga lau ifou anina laani auga mo alakapuga kai eulaisau auga kapaꞌina anina eani auga mo lakapuga,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ke Iesu eifa pugu einaka, “Lau ifou fou laifafoua koꞌa laoma koa aisama, lau kapaꞌina laifania auga kai agaꞌo afaelogo ke afaeifafoua puo egaꞌina iifaga auga koꞌa laaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kai aufalao iꞌoina agaꞌo lau fou eifafoua koa aisama, egaꞌina auga koꞌa epamia. Ke lau lalogo isa lau fou eifafoua auga koꞌa ipauma. ");
INSERT INTO mek_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Ke oi papiau oulaiꞌi Ioane eega kelao, ke isa iifa koꞌa mo eifania. ");
INSERT INTO mek_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Egaꞌina emia auga, papiau aumauni lau fou keifafoua auga koꞌa fapamia laoma puo ega laifa oma folooma kai, lau oi maamiai laifafoua ega koa kaniami feisagamau laoma. ");
INSERT INTO mek_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ioane auga lanepa eaga koa iꞌopoga emia eaga eaea epipeni, ke oi kina pika koa mo isa ega eaea okinaga oisa oalogamalaina. ");
INSERT INTO mek_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Kai lau fou feifafoua auga papiauga agaꞌo Ioane ekaꞌegaina auga eague. Gome pinauga lau Amau epeniiau fakapa fapafua eoma auga pau lakapa, ke egaꞌina pinaugaga, lau Amau eulaisau lamai auga koꞌa mo eifafoua. ");
INSERT INTO mek_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ke Amau lau eulaisau lamai auga, Isa ifo lau isa eegai lamai auga eifafoua. Oi isa aina alologologo, ke iisa isafa ala koa auga aloisaisa. ");
INSERT INTO mek_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ke Isa ega iifa isafa oi alomiai aeka, gome oi Isa eulaisa emai papiauga alopakoꞌania. ");
INSERT INTO mek_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Oi alomi koꞌagai Deo ega iifa puka omaleleaina, gome oopolaga egaꞌina iifaꞌiai agu pagai maunina oafia ooma. Ke Deo ega iifa egaꞌina auꞌi lau fou keifania. ");
INSERT INTO mek_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kai oi lau eeu fomai ega koa agu pagai maunina foafia auga oumakalaina. ");
INSERT INTO mek_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Lau papiau fekeau afagainiau auga lapamafua. ");
INSERT INTO mek_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kai lau oi alomi ala koa auga lalogo. Egaꞌina auga, Deo alo koꞌagai papiau maꞌoai aniꞌi eani auga laoga maina oi alomiai aeka. ");
INSERT INTO mek_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ke lau Amau akagai lamai, ke oi lau foifa kokoisau auga anina aloani. Kai papiau iꞌoina agaꞌo ifo akagai agemai koa aisama, oi isa agoifa koko. ");
INSERT INTO mek_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ke oi ifomi mo isau afagainimi auga anina oani kai, alouniaimoimo Deo ega mo agaꞌomo auga eegai au afagai emai auga alokapuga koa aisama, ala koa lau agopakoꞌaniau agekaina? ");
INSERT INTO mek_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Lau ega laifa oma mo ganinagai, lau Amau agogai oi felo o apala ma okapaisa auga puo alapenimi auga opolaga foloafia. Oi agu pagai maunina amoafia ooma auga afiaꞌamaga Moses eegai ooge puo, Moses oi felo o apala ma okapaisa auga paꞌanina agepaꞌani penimi. ");
INSERT INTO mek_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Gome oi alomi koꞌagai Moses opakoꞌania koa aisama, lau isafa fopakoꞌaniau, gome Moses lau fou epapua. ");
INSERT INTO mek_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kai oi isa kapaꞌina epapua auga alopakoꞌania puo, ala koa lau kapaꞌina laifania auga agopakoꞌania?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Iesu egaꞌina eifania afegai, epagai elao Kalilea aꞌuga kua oma kaina. Ke egaꞌina aꞌuga auga kepafaala Tiberias aꞌuga keoma. ");
INSERT INTO mek_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ke laꞌafou akaikiꞌa isa muninai kelao, gome isa mirakulo gouꞌi isafa papiauꞌi faagaꞌiai ekapaiꞌi keisa. ");
INSERT INTO mek_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ke Iesu ega imoi fou keꞌagau kelao ikuai keagukipo. ");
INSERT INTO mek_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ke egaꞌina kinagai auga Iudea papiauꞌi eꞌi miamia aka Pasover keoma auga kina emai kainagai. ");
INSERT INTO mek_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iesu ega imoi fou egae keaguega kai, maaga elao laꞌafou akaikiꞌa eega kemai eisaꞌi aisama, Filip epainia einaka, “Kapai palafa agaꞌafa papiau iꞌina akeania?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Iesu, Filip gaꞌopo eoma puo ega epaꞌani peni oma, gome isa ifo kapaꞌina agekapa auga minogai eopolaga efua. ");
INSERT INTO mek_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip einaka, “Papiau agaꞌo gafa imagea kuagai oiso epinauga auga afa monina agaafia ganinagai, palafa maꞌo afalaꞌafa, ega koa afaꞌagamo mo ganinagai iꞌina papiauꞌi maꞌoai agaꞌo agaꞌo akeꞌi ageiku opogaina afaekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Ega aisama Iesu ega imoi agaꞌo Andru, Saimon Peto keoma auga akina eifa einaka, “Imoi maguaega inamoꞌe palafa iuma eꞌeleꞌi ima, ke maꞌa eꞌeleꞌi gua eegai kekae. Kai papiau iina emaꞌo oma auga, palafa egaꞌina ke maꞌa gua auga faagaꞌiai kapa agaꞌo agapagama ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ke Iesu einaka, “Papiau amopainiꞌi kegaagukipo,” eoma. Ke egaꞌina afugai mukimuki maꞌo keuki kainai papiau keagukipo. Ke egaꞌina papiauꞌi epoꞌiai au mo auꞌi 5000 koa iꞌopoga. ");
INSERT INTO mek_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ke papiau egaꞌina keagukipo afegai, Iesu palafa iumaꞌi eafiiꞌi Deo tenkiu epeniia aisama, mirakulo akaikiꞌa emia, palafa maꞌo emia, ke ega imoi fou keꞌeaisa papiau egae keagu auꞌi pika anina keani auga kepeniiꞌi. Ke maꞌa isafa eafiiꞌi ega koa ekapaisa. ");
INSERT INTO mek_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ke papiau maꞌoai keaniani aloꞌi ekainia aisama, Iesu ega imoi epainiꞌi einaka, “Palafa ameꞌafuꞌi kekae auꞌi amopakai guguainiꞌi, ega koa agaꞌo egae faeka faelifu aage mo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ega puo ega imoi papiau palafa iumaꞌi ima egaꞌina keaniiꞌi ameꞌafuꞌi auꞌi kepakai guguainiꞌi, aleꞌa 12 akeꞌi kepapoguꞌi. ");
INSERT INTO mek_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ke egaꞌina papiauꞌi Iesu egaꞌina mirakulo gouga ekapaisa keisa aisama, keifa keinaka, “Iifa koꞌa iꞌina auga Profeta agemai agofaꞌai keoma auga inamoꞌe,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ke Iesu egaꞌina papiauꞌi isa kegapaafia kin kegapamia keoma auga elogo puo, epuaꞌafuniꞌi pugu ifogamo elao ikuai. ");
INSERT INTO mek_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ke epagapigapi aisama, Iesu ega imoi keake kelao aꞌuai. ");
INSERT INTO mek_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Egae gaagai keaguka kai, aꞌuai kepagai Kapenaum taonina kelao. Ke kelao alogai egapi efua kai kelao. Kai Iesu auga isa fou akelao. ");
INSERT INTO mek_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Egaꞌina alogai ameku kapula epua puo aꞌu emoge. ");
INSERT INTO mek_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ke isa kepoke afaꞌagamo epo emaefa, kina maaga amagai 5, o 6 oꞌclock koa iꞌopoga aisama, Iesu aꞌu laagai epea, isa keaguka gaagaga eega emai keisa. Ega aisama isa Iesu keisa isage agaꞌo keoma puo kemaniꞌi alogaina. ");
INSERT INTO mek_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kai Iesu isa epainiꞌi einaka, “Iꞌina lau puo folomaniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Iesu ega imoi Iesu ega eifa oma aina kelogonia kai, kelogo isa Iesu. Ega puo kelao gaagai keukaisa aisama, fiakoa mo gaaga elao isa afu kelao auga foegai eofau. ");
INSERT INTO mek_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ke egani aisama, laꞌafou akaikiꞌa aꞌu apie foegai keagu auꞌi gaaga agaꞌomo egae eka auga keisa kelogo. Ke Iesu ega imoi fou egaꞌina gaagagai akeaguka kai, ega imoi ifoꞌi mo gaagai keaguka kelao auga keisaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kai gaaga isaꞌi Tiberias foegai kemai auꞌi Iesu Deo tenkiu epeniia kai, palafa papiau epeniiꞌi keaniia auga afugai keofau. ");
INSERT INTO mek_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ke laꞌafou papiauꞌi Iesu ke ega imoi fou egae akeisaꞌi aisama, fiakoa mo gaagai keaguka, Iesu ikapuga Kapenaum taonina kelao. ");
INSERT INTO mek_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Papiau egaꞌina Iesu kekapuga auꞌi kemai Iesu aꞌu apiegai kekapulaisa aisama, kepaꞌani penia keinaka, “Rabai, oi gaika lomai inae?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kai Iesu isa eꞌi paꞌani afa aepamue kai, iifa iꞌoina eifania einaka, “Iifa gome maamiai laifania, oi lau mirakulo gouꞌi lakapaiꞌi auꞌi oisaꞌi puo muniuai alopea alokapuniau kai, oi palafa iumaꞌi oaniiꞌi inaemi epogu puogai lau muniuai opea. ");
INSERT INTO mek_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Oi foꞌama elifu auga faugai foloafipugu kai, foꞌama ageka aoniamo, agu pagai maunina afuga agelaoainimi auga afipuguga fopaꞌaua. Ke egaꞌina foꞌamaga auga Papiau Aumauni Gauga oi agepenimi. Gome Deo Ama auga isa Gauga egaꞌina foꞌamaga fepipeni auga gouga koꞌa isa faagagai eogeisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ega aisama kepaꞌani penia keinaka, “Lai kapaꞌina fakapa Deo ega pinauga fakapa?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ke Iesu einaka, “Deo ega pinauga auga iꞌina: Oi Isa eulaisa auga amopakoꞌania,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Ega puo Iesu kepaꞌani penia pugu keinaka, “Mirakulo gouga kapa alokapa agaisa ega koa oi agapakoꞌanio? Moses Deo ega iifa pukagai iina epapua oma: ‘Isa ufa palafaga epeniiꞌi keaniia,’ eoma. Moses ega eifa oma koa iꞌopoga, ago maininai lai ufumai apamai mana ufai keꞌualai keaniia,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kai Iesu isa epainiꞌi einaka, “Iifa gome maamiai laifania, Moses oi ufa palafaga egaꞌina aepenimi kai, lau Amau palafa koꞌa ipauma ufai emai auga oi epeniimi. ");
INSERT INTO mek_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Gome Deo ega palafa auga, kaisau ufai eake emai iꞌina agofaꞌa papiauꞌi mauni epeniꞌi auga,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ega aisama isa keinaka, “Au akaikiꞌa aumu, pau kinagai egaꞌina palafaga fopenimai faefuafua,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Iesu papiau ega keifa oma ainaꞌi elogonia aisama eifa einaka, “Palafa papiau mauni mamaga epeniꞌi auga lau. Kaisau lau eeu emai auga inaega afaekimukimu, ke kaisau lau epakoꞌaniau auga aiso afaekupukupu. ");
INSERT INTO mek_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kai lau oi lapainimi koa iꞌopoga, oi lau kapaꞌina lakapaiꞌi auꞌi oisaꞌi kai, alopakoꞌaniau paisa. ");
INSERT INTO mek_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kai Amau lau epeniau auꞌi maꞌoai eeu akemai, ke kaisau lau eeu akemai auꞌi afalaulaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Gome lau ufai laake lamai auga lau ifou anina laani auga makapa laoma puo alamai kai, lau eulaisau auga kapaꞌina anina eani auga fakapa laoma puo lamai. ");
INSERT INTO mek_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ke lau eulaisau auga anina eani Isa kaisau mo lau epeniau auꞌi agaꞌo falapageaꞌi kai, kina fuagai aisama, fapamaunimueꞌi eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Gome lau Amau anina eani auga, papiau maꞌoai maaꞌi elao Gauga keisa ke kepakoꞌania auꞌi, agu pagai maunina fekeafia eoma. Ke kina fuagai aisama, lau isa alapamaunimueꞌi mauni mamaga akeafia,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Iesu ega eifa oma aisama, Iudea papiauꞌi isa eegai keifa mugumugu, gome isa eifa, “Palafa ufai emai auga lau,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ke isa keifa mugumugu keinaka, “Iꞌina auga Iesu Iosepa gauga. Isa ina ama fou alogoniꞌi efua. Kai pau ala koa isa eifa, ‘Lau ufai lamai,’ eoma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ega aisama Iesu eifa einaka, “Oi ifomi epomiai foloifa mugumugu. ");
INSERT INTO mek_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kai agaꞌo lau eeu agemai afaekaina kai, Amau lau eulaisau auga isa lau eeu agemaiseina koa aisama, egaꞌina papiauga mo lau eeu agemai agekaina. Ke kina fuagai aisama, lau egaꞌina papiauga alapamaunimue. ");
INSERT INTO mek_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ke ega koa agemia auga ufainagai profeta Deo ega iifa pukagai iina kepapua oma, ‘Deo isa maꞌoai agepamaleleniꞌi,’ keoma. Ega koa iꞌopoga, kaisau aina epaaua lau Amau aina elogo ke eegai emalele auga lau eeu emai. ");
INSERT INTO mek_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ke kai agaꞌo Deo Ama auga aeisaisa kai, Deo eegai emai auga mo Ama eisa. ");
INSERT INTO mek_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Iifa gome maamiai laifania. Kaisau lau epakoꞌaniau auga agu pagai maunina eafia. ");
INSERT INTO mek_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Gome palafa papiau mauni mamaga epeniꞌi auga lau. ");
INSERT INTO mek_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ufainagai oi ufumi apami ago maininai mana keaniia mo ganinagai maꞌoai akeagu pagainia kai kemae. ");
INSERT INTO mek_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kai palafa ufai eake inamoꞌe. Ke kaisau egaꞌina palafaga ageania auga afaemae. ");
INSERT INTO mek_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Lau auga palafa maaga maunina ufai eake emai au. Au agaꞌo iꞌina palafaga ageania auga ageagu pagainia. Palafa iꞌina auga lau pitiou agofaꞌa papiauꞌi fauꞌiai Deo alapaꞌa penia, ega koa isa agu pagai maunina akeafia,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Iesu ega eifa oma aisama, Iudea papiauꞌi ifoꞌi mo epoꞌiai keakekua keinaka, “Ala koa iꞌina auga ifo pitioga papiau agepeniꞌi akeania eoma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kai Iesu isa epainiꞌi einaka, “Iifa gome maamiai laifania. Oi Papiau Aumauni Gauga pitioga afoloania ke ifa afoloinu koa aisama, oi alomiai mauni agaꞌo laaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kai kaisau lau pitiou eania ke ifau einu auga, agu pagai maunina eafia. Ke kina fuagai aisama, alapamaunimue mauni mamaga alapenia. ");
INSERT INTO mek_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Gome lau pitiou auga foꞌama koꞌa, ke ifau auga inuinu kapa koꞌa. ");
INSERT INTO mek_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kaisau lau pitiou eania ke ifau einu auga lau alouai eague, ke lau isa alogai laague. ");
INSERT INTO mek_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ke Ama eague aoniamo auga eulaisau koa iꞌopoga, lau Amau puogai laague. Ega puo kaisau lau pitiou eania ke ifau einu auga, lau puouai ageagu. ");
INSERT INTO mek_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Iꞌina palafaga auga ufai eake emai auga. Iꞌa ufuꞌa apaꞌa mana keaniia mo ganinagai kemae kai, kaisau iꞌina palafaga ageania auga, ageagu pagainia,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesu iꞌina kapaꞌi maꞌoai Kapenaum taoninai Iudea papiauꞌi eꞌi laꞌafou afugai epamalele alogai eifafouꞌi. ");
INSERT INTO mek_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iesu muninai kepea auꞌi egaꞌina pamalelega aꞌo kelogonia aisama, maꞌo keifa keinaka, “Pamalele egaꞌina eꞌinoka alogaina puo, kaisau egaꞌina pamalelega kainai agepea agekaina?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ke Iesu ega imoi iꞌina pamalelega puogai keifa mugumugu auga elogo aisama epainiꞌi einaka, “Iꞌina pamalelega oi alomi epalifua ma? ");
INSERT INTO mek_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Oi Papiau Aumauni Gauga afeꞌagau afelao, emai afugai afeagu afoisa aisama, kapaꞌina afokapa? ");
INSERT INTO mek_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Deo ega Spiritu auga mauni mamaga epipeni. Kai agofaꞌai papiau aumauni imaauga auga kapa agaꞌo afaepagama. Ke iifa oi maamiai laifaniꞌi auꞌi Deo ega Spiritu ega iifa, ke egaꞌina iifaꞌi mauni mamaga kepipeni. ");
INSERT INTO mek_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kai oi epomiai isami lau kapaꞌina laifania auga alopakoꞌania,” eoma. Gome Iesu eꞌina mo aisama, kaisau mo isa akepakoꞌania ke kaisau isa ageꞌafaꞌafalaina auga elogo efua puo ega eifa oma. ");
INSERT INTO mek_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ke eifa pugu einaka, “Ega kainai oi lapainimi laifa, kai agaꞌo ifo lau eeu afaemai kai, lau Amau isa agepapea eeu agemaiseina aisama kai, isa lau eeu agemai agekaina laoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Iesu ega eifa oma aisama, muninai kepea auꞌi maꞌo isa kepuaꞌafuga, ke muninai akepea pugu. ");
INSERT INTO mek_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ega aisama Iesu eꞌafoaipini ega apostolo 12 auꞌi epaꞌani peniꞌi einaka, “Oi isafa olao ma ooma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Kai Saimon Peto keoma auga einaka, “Lopia, lai kai eega agalao? Agu pagai iifaꞌi oi eemuai kekae. ");
INSERT INTO mek_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Lai apakoꞌania ke alogo oi auga Alo Lolofa Aumu Deo eegai lomai Aumu,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ega aisama Iesu einaka, “Lau oi aumi 12 aumi alakinanimi ma? Iifa gome lau oi lakinanimi kai, oi epomiai agaꞌo auga tiapolo!” eoma. ");
INSERT INTO mek_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Iesu egaꞌina eifania auga, isa ifo ega imoi 12 auga epoꞌiai agaꞌo aka Judas, au aka Saimon Iskariot gauga muniai isa ageꞌafaꞌafalaina auga fouga eifania.) ");
INSERT INTO mek_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Egaꞌina afegai Iesu Iudea papiauꞌi isa kegaaupugua keoma puo, epagome Iudea ago aelao kai Kalilea agogai mo elao emai. ");
INSERT INTO mek_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Kai Iudea papiauꞌi eꞌi miamia agaꞌo aka Efeꞌefe Miamia keoma auga kina emai kainagai aisama, Iesu akina isa kepainia keinaka, “Oi iꞌina afuga fopuaꞌafuga folao Iudea, ega koa emu imoi mirakulo lokapaꞌi auga fekeisaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Gome aufalao agaꞌo papiau maꞌoai isa kegalogo aka gafoufaꞌa eoma auga ogefakeai kapa agaꞌo aekapa. Oi iꞌina kapaꞌi lokapaꞌi kainai, moapalai ofakaegai agofaꞌa fofouga oi kaisau auga kegalogo,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Iesu akina ipaumaꞌi auꞌi ega keifa oma, gome isa ifoꞌi isafa isa akepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ega puo Iesu isa epainiꞌi einaka, “Lau kapa agaꞌo fakapa auga kina aemai koa kai, oi auga kina aage ma ganinagai kapa agaꞌo agokapa agekaina. ");
INSERT INTO mek_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Agofaꞌa papiauꞌi oi animi keani kai lau auga aniu akeani, gome lau isa kapaꞌina kekapa auga apala laoma. ");
INSERT INTO mek_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Oi egaꞌina miamia olao. Lau auga egaꞌina miamia afalafai. Gome lau eꞌu kina aekaina koa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ke egaꞌina eifania afegai, egae Kalilea agogai mo eagu. ");
INSERT INTO mek_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kai isa akina kekailai egaꞌina miamia kelao afegai, isa ifo isafa egaꞌina miamia elao. Kai elao aisama, aepea ofakae mo aelao. ");
INSERT INTO mek_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Miamia egaꞌina alogai Iudea papiauꞌi isaꞌi Iesu kekapunia ke kepaꞌani keinaka, “Egaꞌina auga kapai?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Iudea papiauꞌi ega keifa oma aisama, laꞌafou papiauꞌi keifa mugumugu isa fouga keifa kefai kelaoaina. Ke isaꞌi keinaka, “Isa au felo,” keoma. Kai isaꞌi keinaka, “Laaꞌi, isa papiau efogeꞌi,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kai papiau egaꞌina maꞌoai Iudea papiauꞌi kemaniꞌiainiꞌi kainai kai agaꞌo egaꞌina iifaga kalafaꞌai aeifania. ");
INSERT INTO mek_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Egaꞌina miamia emia elao ipuainagai aisama, Iesu elao Deo ega eꞌai ke eꞌina epamalele. ");
INSERT INTO mek_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ke Iudea papiauꞌi isa aina kelogonia aisama, kekauai alogaina ke kepaꞌani keinaka, “Iꞌina auga Deo ega iifa aemaleleaina kai ala koa malele ega koa elogo?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ega aisama Iesu einaka, “Lau eꞌu pamalele auga lau ifou apu laaꞌi. Egaꞌina pamalelega auga lau eulaisau auga eegai emai. ");
INSERT INTO mek_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Aufalao agaꞌo anina afeani Deo kapaꞌina anina eani auga gakapa afeoma koa aisama, isa lau eꞌu pamalele Deo eegai emai, o lau ifou ainau fouga laifania auga agekapulaisa. ");
INSERT INTO mek_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kaisau ifo aina fouga eifania auga, ega koa ekapa auga papiau isa au akaikiꞌa fekepamia eoma puo ekapa. Kai kaisau isa eulaisa auga au akaikiꞌa fekepamia eoma puo epinauga auga iifa koꞌa auga, ke pifoge kapaꞌi agaꞌo isa eegai afoloisa. ");
INSERT INTO mek_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ke Deo ega iifa Moses epeniia auga oi aepenimi ma? Iifa gome Moses iifa egaꞌina oi epeniimi. Kai oi epomiai kai agaꞌo Moses ega iifa egaꞌina kaiꞌiai alopea. Kai kapa puo lau amoaupuguisau ooma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ega aisama laꞌafou papiauꞌi iifa kepamue keinaka, “Oi alomuai tiapolo eague. Kaisau oi gaaupuguiso eoma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ke Iesu isa epainiꞌi einaka, “Lau mirakulo agaꞌomo mo lakapaisa kai, oi maꞌoai oisa okauai alogaina. ");
INSERT INTO mek_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ke Moses oi au maguaeꞌi faagaꞌi iifalaina gouga kagakaga epeniimi puo, Deo isau afagaina kina mo ganinagai, au maguaeꞌi faaga iifalaina gouga okapa. Kai egaꞌina kagakaga auga Moses faagagai aemai kai iꞌa ufuꞌa apaꞌa gauga fou faagaꞌiai emai. ");
INSERT INTO mek_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ke Deo isau afagaina kinagai imoi agaꞌo maguaega faaga oifalaisa, ega koa Moses ega iifa afoloaupea ooma. Ega koa aisama kapa puo lau Deo isau afagaina kinagai au faaga fofouga lapafelo auga guakupuga opaꞌaua? ");
INSERT INTO mek_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Oi papiau iisagai mo oisa papiau felo, o apala ooma auga kagakaga amopaapakipo kai, alo opai laoga mainai afa amopipeniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Iesu ega eifa oma aisama, Ierusaleme papiauꞌi isaꞌi keꞌina kepaꞌani keinaka, “Papiau iꞌina auga kegaaupugua akeoma ma? ");
INSERT INTO mek_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Amoisa! Isa inamoꞌe laꞌafouai eapae eniniꞌani kai, egaꞌina papiauꞌi iifa agaꞌo akeifania. Ke au akaikiꞌaꞌi isapu keafiia auꞌi fuagai kelogo isa Mesaia maꞌe keoma? ");
INSERT INTO mek_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kai lai iꞌina auga kapai emai auga alogo. Kai Mesaia agemai aisama, isa kapai emai auga kai agaꞌo afaelogo,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ega aisama Iesu Deo ega eꞌai epapamalele kai eifa akaikiꞌa einaka, “Koꞌa, oi lau ologoniau ke kapai lamai auga isafa ologo. Kai lau ifou mo iina alamai kai lau eulaisau auga iifa koꞌa inagome auga kai, oi Isa alologonia. ");
INSERT INTO mek_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Kai lau auga Isa lalogonia, gome lau Isa eegai lamai, ke Isa lau eulaisau,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Iesu ega eifa oma aisama, papiau isa kegaafia kegagope keoma kai, ega kina aekainia puo kai agaꞌo ima isa faagagai aeogeaua. ");
INSERT INTO mek_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ke papiau isaꞌi ega keoma mo ganinagai, laꞌafouai papiau maꞌo isaꞌi auga isa kepakoꞌania ke keifa keinaka, “Mesaia agemai aisama, isa iꞌina auga mirakulo gouꞌi ekapaꞌi auꞌi agekaꞌegaina maꞌo ma agekapaꞌi?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Faliseo auꞌi laꞌafou papiauꞌi keifa kekefa mo Iesu fouga ega keifa oma auga fouga kelogo. Ega aisama sakedote lopiaꞌi ke Faliseo auꞌi fou Deo ega eꞌa keꞌima auꞌi keulaiꞌi kelao Iesu kegaafia kegagope keoma. ");
INSERT INTO mek_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ega aisama Iesu einaka, “Lau oi fou kina epo afaemaefa agaagu. Egae kai lau eulaisau auga eega alalao. ");
INSERT INTO mek_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ega aisama oi lau agokapuniau kai afoloisau. Ke oi lau alalao afuga agomai afaekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ega aisama Iudea papiauꞌi ifoꞌi mo epoꞌiai keifa keinaka, “Au iꞌina ala agelao kai iꞌa isa agakapuga afalaisa eoma? Ke isa iꞌa aꞌa papiau Grik ago papiauꞌi epoꞌiai keagu okaoka auꞌi eeꞌi agelao, egae Grik papiauꞌi agepamaleleniꞌi ma? ");
INSERT INTO mek_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ke isa iina eifa oma ‘Oi lau agokapuniau kai afoloisau’, ke ‘Lau alalao afuga oi afolao eoma,’ auga kapaꞌina eifania?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ke miamia kina fua, miamia kina maꞌoai ekaꞌegainiꞌi auga kinagai Iesu eꞌue eapa kai eifa akaikiꞌa einaka, “Kaisau aiso ekupu auga gamai lau eeuai fei gainu. ");
INSERT INTO mek_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kaisau lau epakoꞌaniau auga, Deo ega iifa pukagai kepapua koa iꞌopoga, egaꞌina papiauga alogai mauni umamo feina ageꞌuki, agekipolai,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iesu egaꞌina eifania auga Deo ega Spiritu fouga eifania. Ke kaisau isa kepakoꞌania auꞌi muniai Deo ega Spiritu egaꞌina akeafia auga fouga eifania. Ke Iesu ega eifa oma kinagai auga, Iesu ufai aeꞌagaukae au akaikiꞌa aemia koa puo, Deo ega Spiritu aeulaisa aemai aepinauga. ");
INSERT INTO mek_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Papiau isaꞌi Iesu ega eifa oma aina kelogonia aisama keifa keinaka, “Iifa gome iꞌina auga Profeta auga,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ke isaꞌi keifa keinaka, “Isa Mesaia auga,” keoma. Kai isaꞌi auga kepaꞌani keinaka, “Mesaia ala koa Kalilea agogai agemai? ");
INSERT INTO mek_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Deo ega iifa pukagai aeifa Mesaia Davide okogai agemai, ke Beteleme Davide eagu taoninai agemai aeoma ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ega koa emia papiau Iesu puogai keꞌeaiꞌi. ");
INSERT INTO mek_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ke isaꞌi auꞌi isa kegaafia kegagope keoma kai, kai agaꞌo ima isa faagagai aeogeaua. ");
INSERT INTO mek_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ega puo Deo ega eꞌa keꞌima auꞌi kemue kelao sakedote lopiaꞌi, ke Faliseo auꞌi eeꞌiai. Ega aisama sakedote lopiaꞌi ke Faliseo auꞌi fou egaꞌina auꞌi kepaꞌani peniꞌi keinaka, “Kapa puo oi isa aloafia alomaiseina?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ke Deo ega eꞌa keꞌima auꞌi keinaka, “Kai agaꞌo egaꞌina auga eniniꞌani koa aeniniꞌani,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ega aisama Faliseo auꞌi kepaꞌani keinaka, “Isa oi isafa efogeimi ma? ");
INSERT INTO mek_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ke au akaikiꞌaꞌi isapu keafia auꞌi agaꞌo o Faliseo auga agaꞌo isa epakoꞌania o aepakoꞌania ma? ");
INSERT INTO mek_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Laaꞌi, iꞌina papiauꞌi Moses ega iifa agaꞌo akelogo auꞌi, Deo isa afa apala fepeniꞌi aoma,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Kai Faliseo auga agaꞌo aka Nikodemus, gapi agaꞌogai elao Iesu eisa auga isa epaꞌani peniꞌi einaka: ");
INSERT INTO mek_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Moses ega iifa alogai papiau agaꞌo kapa agaꞌo ekapa aisama, kapaꞌina ekapa auga fouga maamiai aeifania alologo koa kai egaꞌina papiauga afa apala feafia ma eoma?” ");
INSERT INTO mek_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kai isa keinaka, “Oi isafa Kalilea aumu ma? Ke Deo ega iifa puka alo foisa kai profeta agaꞌo Kalilea agogai emai ma auga fologo,” keoma. Ufainagai papiau isaꞌi Ioane ega puka kepapua auga 7:53 elao 8:11 auga egaꞌina pukaꞌi aloꞌiai akepapuaꞌi.  ");
INSERT INTO mek_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Egaꞌina afegai au akaikiꞌaꞌi maꞌoai kekani aua mo eꞌi eꞌa kelao. ");
INSERT INTO mek_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kai Iesu auga eꞌagaukae Olifa ikuga elao. ");
INSERT INTO mek_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ke epagapigapi alogai, Iesu elao Deo ega eꞌa afegai pugu. Ke egae papiau maꞌoai kemai keapa lofe, ke isa eagukipo epamaleleniꞌi. ");
INSERT INTO mek_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Egaꞌina alogai Moses ega iifa pamalelega auꞌi ke Faliseo auꞌi fou paafau peage lapau papiega agaꞌo, au agaꞌo fou kefeufeu kai keisaꞌi auga keafiia kemaiseina laꞌafou egaꞌina agoꞌiai kepaapa. ");
INSERT INTO mek_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Egae kai Iesu kepainia keinaka, “Pamalele aumu, iꞌina papiega au fou akeamage auꞌi fou kefeu aisa. ");
INSERT INTO mek_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ke Moses ega iifa kainai eifa kapulania eifa, papie ega koaꞌi auꞌi kepoai fafoupuguꞌi eoma. Ega puo oi kapa looma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Isa iꞌina paꞌanina kepaꞌani auga Iesu kegapaoa keagaga agaꞌo kekapunia kegapaagu fofoua keoma. Kai Iesu eloukipo aꞌisaai ima kekeꞌegai malele epapuaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ke kepaꞌani penia akeaponia aisama, eꞌue eapa kai epainiꞌi einaka, “Oi epomiai aufalao agaꞌo laomai apala agaꞌo aekapaisa auga kepo gaafia isa gafou kakaua,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Egae kai eloukipo pugu aꞌisaai malele epapua. ");
INSERT INTO mek_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Iesu ega eifa oma aisama, egae keapa aina kelogo auꞌi epoꞌiai, au apaoꞌi auꞌi keufai agaꞌomo agaꞌomo kekani kaukau. Ke papiau aguꞌaꞌi isafa agaꞌomo agaꞌomo kekanikani kai elao Iesu mo papie egaꞌina auniꞌi egae keapa. ");
INSERT INTO mek_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ega aisama Iesu eꞌue eapa kai, papie epaꞌani penia einaka, “Papie, isa kapai? Kai agaꞌo oi emu laomai apala afa aepenio ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ke papie einaka, “Au akaikiꞌa aumu, kai agaꞌo laaꞌi,” eoma. Ke Iesu einaka, “Ega koa aisama, lau isafa oi emu laomai apala afa afalapenio. Ke pau folao kai, emu laomai apala aguga fopuaꞌafuga” eoma. ");
INSERT INTO mek_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Egaꞌina afegai Iesu papiau maaꞌiai eniniꞌani pugu aisama, eifa einaka, “Agofaꞌa alogai lau auga eaea. Ega puo kaisau lau muniuai agepea auga, uminagai afaepeapea kai eaea mauni mamaga epipeni auga ageafia,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kai Faliseo auꞌi isa kepainia keinaka, “Oi inae loapae ifomu foumu loifafoua. Ega puo oi ifomu foumu ala loifafou oma auga, koꞌa laaꞌi,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Kai Iesu einaka, “Lau ifou fou laifafoua mo ganinagai, lau kapaꞌina laifafoua auga koꞌa, gome lau kapai lamai auga lalogo, ke ala alalao auga isafa lalogo. Kai oi auga, lau kapai lamai o ala alalao auga oko alologo. ");
INSERT INTO mek_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ke oi auga papiau aumauni, papiau eꞌi felo o apala fekepeniꞌi keoma auga mo laoga mainai papiau afa openiꞌi. Kai lau auga kai agaꞌo afa felo o apala feafia alaoma. ");
INSERT INTO mek_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kai lau papiau agaꞌo ega laomai felo o apala afa afapenia koa aisama, lau laomai felogai mo afa alapipeni. Gome lau ifou mo laaꞌi kai, Amau eulaisau auga aunimai aapae. ");
INSERT INTO mek_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ke Moses ega iifa epapua oi epeniimi auga alogai eifa, papiau gua kapa agaꞌomo fouga akeifafoua aisama, egaꞌina kapa koꞌa eoma. ");
INSERT INTO mek_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ega koa iꞌopoga, lau auga ifou fou laifafoua. Ke Amau lau eulaisau auga isafa lau fou eifafoua,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ega aisama isa Iesu kepaꞌani penia, “Ke oi amamu kapai?” keoma. Ke Iesu einaka, “Oi lau alologoniau ke Amau isafa alologonia. Kai oi lau amologoniau koa aisama, lau Amau isafa fologo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesu Deo ega eꞌai Deo moni kepalao penia afuga eegai eapa epamalele alogai iꞌina kapaꞌi eifaniꞌi. Ega mo ganinagai kai agaꞌo isa aeafia aegopeisa, gome isa ega kina aekainia. ");
INSERT INTO mek_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ke Iesu papiau epainiꞌi pugu einaka, “Lau oi alapuaꞌafunimi alalao, ke oi lau agokapuniau kai laomai apalaꞌi okapakapaꞌi kai lalaumiai agomae. Ega puo lau alalao afuga oi agolao afaekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ke Iesu iina eifa oma, ‘Lau alalao afuga oi agolao afaekaina eoma,’ kainai, Iudea papiauꞌi kepaꞌani keinaka, “Isa ifo ageaupugua ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kai Iesu eifa pugu einaka, “Oi auga iꞌina aagoa papiaumi kai, lau auga auꞌoni ufa papiau. Ke oi auga iꞌina agofaꞌa papiaumi kai, lau auga iꞌina agofaꞌa papiau laaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Lau lapainimi oi emi laomai apalaꞌi agokapaꞌi lalaumiai agomae laoma. Iifa gome oi lau kaisau laoma auga afolopakoꞌania koa aisama, koꞌa oi laomai apalaꞌi agokapaꞌi lalaumiai agomae paisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ega aisama isa Iesu kepaꞌani penia keinaka, “Oi kaisau?” keoma. Ke Iesu einaka, “Lau laꞌina mo ifou fou ala laifafou oma auga, lau inamoꞌeu. ");
INSERT INTO mek_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Lau kapa maꞌo kekae oi emi laomai apala o felo auga faifaniꞌi ega koa oi emi laomai felo o apala auga fologo laoma. Kai lau eulaisau lamai auga koꞌa eague, ke lau isa eegai kapaꞌina aꞌo lalogonia auga agofaꞌa papiauꞌi maaꞌiai laifania,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kai Iudea papiauꞌi Iesu isa Ama fouga isa maaꞌiai eifania kai isa akelogo. ");
INSERT INTO mek_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ega puo Iesu einaka, “Oi Papiau Aumauni Gauga kolotiai agoafiakae aisama, egae kai lau kaisau laoma auga agologo. Ke lau ifou mo kapa agaꞌo alakapa kai, Amau kapaꞌina epamaleleniau auga mo laifania auga isafa agologo. ");
INSERT INTO mek_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ke lau eulaisau auga lau fou aague. Isa lau aepuaꞌafuniau ifou mo alaagu, gome lau isa kapaꞌina alo epagama auga mo lakapa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iesu eniniꞌani alogai papiau maꞌo isa kepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Egae kai Iesu Iudea papiauꞌi isa kepakoꞌania auꞌi epainiꞌi einaka, “Oi lau eꞌu pamalele agoafi inokania koa aisama, oi lau eꞌu imoi koꞌami. ");
INSERT INTO mek_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ega aisama oi Deo ega iifa koꞌa auga agologo, ke pakoꞌa iifaga egaꞌina, oi kapaꞌina papagai kalaꞌafi koa omia oagu auga eegai agepapealaimi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ega aisama isa keinaka, “Lai auga Abraham ufuga apa aumai, ke kai agaꞌo ega kalaꞌafi alamiamia. Kai kapa puo lai kapa agaꞌo papagai akalaꞌafi auga papagai agapealai looma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Kai Iesu einaka, “Iifa gome maamiai laifania. Kaisau mo laomai apala kekapa auꞌi, isa laomai apala egaꞌina ega kalaꞌafi kemia. ");
INSERT INTO mek_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ke famili epoꞌiai kalaꞌafi auga ega eꞌa agaꞌo aepagome. Kai eꞌa inagome auga gauga, eꞌa egaꞌina isa apuga agemia aoniamo. ");
INSERT INTO mek_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ega puo Gauga oi laomai apala egaꞌina eeꞌiai agepapealaimi koa aisama, iifa gome oi egaꞌina papagai agopealai paisa. ");
INSERT INTO mek_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Lau lalogo oi Abraham ufuga apa. Ega mo ganinagai, oi alomiai auga ofua oague lau amoaupuguisau ooma. Gome lau eꞌu iifa oi alomiai fekoko auga afuga agaꞌo aeka aage mo. ");
INSERT INTO mek_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ke lau Amau agogai kapaꞌina laisa auga oi maamiai laifania, ke oi auga oi amami maamiai kapaꞌina keifania auga okapa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ega aisama isa keinaka, “Iifa gome Abraham auga lai ufumai,” keoma. Kai Iesu einaka, “Oi Abraham ufuga apa koa aisama, Abraham kapaꞌina ekapaiꞌi auꞌi fokapaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Lau kapa agaꞌo iꞌoina alakapaisa kai, Amau eegai iifa koꞌa laafia auga oi maamiai laifafoua mo ganinagai, oi lau amoaupuguisau ooma. Kai Abraham kapa ega koa agaꞌo aekapaisa. ");
INSERT INTO mek_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Oi auga, oi ifomi amami kapaꞌina kekapaisa auga mo okapa,” eoma. Kai isa keinaka, “Lai auga kalufa piakele imoimai laaꞌi kai, Amamai agaꞌomo, Deo mo ifogamo,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ega aisama Iesu isa epainiꞌi einaka, “Deo oi Amami koa aisama, lau aniu foani, gome lau Deo eegai lamai, ke pau lau inamoꞌeu. Ke lau ifou alamai kai Isa lau eulaisau lamai. ");
INSERT INTO mek_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kai kapa puo lau kapaꞌina laifania auga aꞌo aloafi felo? Oi aꞌo aloafi felo, gome oi lau kapaꞌina laifania auga ainau agologo afaekaina. ");
INSERT INTO mek_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Oi auga tiapolo gauga, ke tiapolo auga oi amami. Ega puo oi anina oani, amami kapaꞌina anina eani auga mo amokapa ooma. Agofaꞌa eꞌina mo alogai, isa iꞌina agofaꞌagai papiau eaupuguꞌi. Ke isa iifa koꞌa auga aeafia alogai aeka, gome isa alogai kapa agaꞌo koꞌa laaꞌi. Ke isa epifoge aisama, isa kapaꞌina fekapa auga mo ekapa, gome isa pifoge auga, ke isa pifoge maꞌoai amaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kai lau auga iifa koꞌa laifania kai oi lau alopakoꞌaniau! ");
INSERT INTO mek_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Oi epomiai aufalao agaꞌo lau apala lakapaisa auga ageifafoua agekaina ma? Ke laaꞌi koa aisama, lau iifa koꞌa laifania puo kapa puo lau alopakoꞌaniau? ");
INSERT INTO mek_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ke kaisau Deo gauga auga Deo kapaꞌina eifania auga aina elogo. Kai oi Deo gauga laaꞌi puo, ainami alopaaua lau ainau alologo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ega aisama Iudea papiauꞌi iifa kepamue keinaka, “Lai oi Samaria aumu, ke tiapolo alomuai eague aoma auga apifoge ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ke Iesu einaka, “Lau tiapolo alouai aeagu kai, lau auga Amau au akaikiꞌa lapamia. Kai oi auga lau au eꞌeleu opamiaisau. ");
INSERT INTO mek_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ke lau ifou fauai isapu akaikiꞌa faafia, ke au akaikiꞌau famia auga keagaga alakapuga. Kai aufalao agaꞌo auga, isa ifo au akaikiꞌa femia ke isapu akaikiꞌa feafia auga keagaga ekapuga, ke isa oi felo o apala okapa auga afa agepenimi. ");
INSERT INTO mek_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Iifa gome maamiai laifania. Kaisau lau eꞌu iifa ageafia apuga agepamia auga afaemae ke mae gamuga afaeopo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ega aisama Iudea papiauꞌi keinaka, “Pau lai alogo, oi tiapolo alomuai eague! Gome Abraham emae ke profeta maꞌoai isafa kemae kai oi loifa kaisau oi emu iifa ageafia apuga agepamia auga afaemae, ke mae gamuga afaeopo looma. ");
INSERT INTO mek_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Oi lai ufumai apamai Abraham lokaꞌegaina ma puo ega loifa oma? Isa emae ke profeta maꞌoai isafa kemae. Kai oi loopolaga oi kai looma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ke Iesu einaka, “Lau ifou akaikiꞌau alapamiaisau koa aisama, lau eꞌu akaikiꞌa egaꞌina auga kapa agaꞌo laaꞌi. Ega puo lau Amau oi oifaga emi Deo ooma auga lau au akaikiꞌau epamiaisau. ");
INSERT INTO mek_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ke oi isa alologonia mo ganinagai lau isa lalogonia. Kai lau maifa isa alalogonia maoma koa aisama, lau oi koa iꞌopomi, pifoge au famia. Kai lau isa lalogonia ke ega iifa isafa laafia apu lapamia. ");
INSERT INTO mek_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Oi ufumi Abraham lau eꞌu mai kina aeisa kai, minogai eꞌu mai kina feisa eoma eopolaga mo alo egama,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kai Iudea papiauꞌi isa kepainia keinaka, “Oi inipomu 50 aeafia koa kai ala koa Abraham loisa?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ke Iesu einaka, “Iifa gome maamiai laifania, Abraham aemauni koa kai lau laagu!” eoma. ");
INSERT INTO mek_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iudea papiauꞌi Iesu ega eifa oma aina kelogonia aisama, keloukipo kepo keafiiꞌi kegafouga keoma kai, ifo eiꞌofake Deo ega eꞌai epealai elao. ");
INSERT INTO mek_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iesu ekailai elao alogai, au agaꞌo mauniai maaga ekimiꞌi auga eisa. ");
INSERT INTO mek_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ke Iesu ega imoi isa kepaꞌani penia keinaka, “Rabai, kaisau laomai apala ekapaisa? Iꞌina auga ifo, o isa ina ama laomai apala kekapaisa puo isa maaga ekimiꞌi?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Kai Iesu einaka, “Laaꞌi, isa laomai apala aekapaisa, ke isa ina ama isafa laomai apala akekapaisa. Kai isa faagagai iina koa emia ega koa Deo ega pinauga ala koa auga isa ega agu alogai fefoki eoma. ");
INSERT INTO mek_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ke pau aegapi koa kai, iꞌa lau eulaisau auga ega pinauga fakapa, gome agegapi aisama, aufalao agaꞌo agepinauga afaekaina. ");
INSERT INTO mek_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ke lau agofaꞌai laague alogai lau agofaꞌa eaea,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ega eifa oma afegai, aꞌisa eꞌupeisa ke alo fefea eafiia miꞌiu ekapaisa kai eafiia maakimiꞌi auga maaga elakaisa. ");
INSERT INTO mek_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Egae kai epainia einaka, “Molao Siloam ofugagai moufele,” eoma. Siloam iꞌa malaꞌaisai auga iulai fouga eifania. Ega puo maakimiꞌi auga elao egaꞌina ofugagai eufele, ke maaga felo emia afu eisa emue emai ega pagua. ");
INSERT INTO mek_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ke isa ega eꞌa ipafe papiauꞌi, ke kai mo isa epinoi keisaisa auꞌi kepaꞌani keinaka, “Iꞌina auga maakimiꞌi auga eagu epipinoi auga laaꞌi ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ega aisama isaꞌi keifa egaꞌina auga egamoꞌe keoma. Ke isaꞌi keifa, “Laaꞌi, isa egaꞌina auga laaꞌi kai au agaꞌo isa iisa iꞌopoga mo auga,” keoma. Kai isa ifo eifa einaka, “Lau inamoꞌeu,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ega puo egaꞌina papiauꞌi isa kepaꞌani penia keinaka, “Ala emia oma, oi maamu ekiakae afu loisa?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ke isa einaka, “Au keifaga Iesu keoma auga miꞌiu ekapaisa maau elakaisa, ke epainiau malao Siloam ofugagai maufele eoma. Ega puo lau lalao laufele aisama, maau ekiakae afu laisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ega aisama egaꞌina papiauꞌi isa kepaꞌani penia keinaka, “Au egaꞌina kapai?” keoma. Ke isa einaka, “Lau alalogo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Egae kai egaꞌina papiauꞌi maakimiꞌi auga maaga felo emia auga keafiia kelaoaina Faliseo auꞌi eeꞌiai. ");
INSERT INTO mek_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ke Iesu alo fefeagai miꞌiu ekapaisa au maaga epakiakaea kina auga, Iudea papiauꞌi Deo keau afagaina kina. ");
INSERT INTO mek_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ega puo Faliseo auꞌi isafa au egaꞌina kepaꞌani penia maaga ala eoma felo emia auga fouga gaifania keoma. Ke isa einaka, “Isa lau maauai miꞌiu elakaisa, ke lau lalao laufele aisama, maau felo emia afu laisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ega aisama Faliseo auꞌi isaꞌi keinaka, “Iꞌina auga oi maamu epafelo auga Deo eegai aemai, gome isa iꞌa Iudea auꞌa Deo aau afagaina kina oko kainai aepea,” keoma. Kai isaꞌi keinaka, “Laomai apala ikapa auga ala koa mirakulo gouꞌi iina koaꞌi agekapaꞌi agekaina?” keoma. Ega koa emia ifoꞌi mo epoꞌiai keꞌeaiꞌi. ");
INSERT INTO mek_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ke fuagai aisama, kemuniaipini maakimiꞌi auga maaga felo emia auga kepaꞌani penia keinaka, “Isa oi maamu epakiakaea puo, fouga ala loifa oma?” keoma. Ke isa einaka, “Au egaꞌina profeta auga agaꞌo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kai Iudea papiauꞌi au egaꞌina maaga ekimiꞌi kai pau felo emia auga akepakoꞌania mo elao iifa keulaisa ina ama kemai. ");
INSERT INTO mek_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ke isa ina ama kemai aisama kepaꞌani peniꞌi keinaka, “Iꞌina oi ma gaumi? Oi isa ma mauniai maaga ekimiꞌi ooma? Ala koa isa pau afu eisa?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ke isa ina ama iifa kepamue keinaka, “Lai alogo isa lai gaumai, ke alogo isa mauniai maaga ekimiꞌi. ");
INSERT INTO mek_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kai pau ala eoma afu eisa, ke kaisau isa maaga epakiakaea auga lai alalogo. Oi isa amopaꞌani penia. Isa eminifaꞌa efua puo, ifo fouga ageifania,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Isa ina ama Iudea papiauꞌi kemaniꞌiainiꞌi puo ega keifa oma. Gome Iudea au akaikiꞌaꞌi auꞌi keifa kakaua keinaka, kaisau Iesu Mesaia ageoma auga isa eꞌi laꞌafou afugai akepapealaisa keoma. ");
INSERT INTO mek_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ega puo isa ina ama keinaka, “Isa eminifaꞌa efua puo oi isa ifo amopaꞌani penia,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ke au maaga efelo auga ipainina gua kepamia keinaka, “Oi Deo au akaikiꞌa mopamia, gome lai alogo egaꞌina auga epafeloiso auga laomai apala ikapa auga,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ke isa einaka, “Isa laomai apala ikapa auga ma auga lau alalogo. Kai kapa agaꞌomo lalogo auga, lau maau ekimiꞌi kai epafelo pau afu laisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ega aisama isa kepaꞌani penia keinaka, “Isa kapaꞌina oi faagamuai ekapaisa? Ke maamu ala epakiakae oma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ke isa einaka, “Lapainimi efua kai ainau alologonia. Kapa puo maifania ainau amologo pugu ooma? Oi isafa isa ega imoi amomia ma ooma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ega aisama egaꞌina papiauꞌi isa keifa apala penia keinaka, “Oi auga isa ega imoi, ke lai auga Moses ega imoi! ");
INSERT INTO mek_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Lai alogo Deo Moses maagai eniniꞌani kai egaꞌina auga kapai emai auga lai alalogo,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ke maaga efelo auga einaka, “Oko iꞌoina ipauma! Oi isa kapai emai auga alologo kai lau maau epakiakaea. ");
INSERT INTO mek_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ke iꞌa alogo Deo papiau laomai apalaꞌi kekapaꞌi auꞌi ainaꞌi aeafia. Kai kaisau Isa au akaikiꞌa epamia, ke ega logoai pinauga anina eani gakapa eoma auga ekapa auga aina eafia. ");
INSERT INTO mek_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ke Deo agofaꞌa epagama mo alogai, kai agaꞌo aufalao agaꞌo mauniai maaga ekimiꞌi auga maaga epakiakaea auga fouga keifania alalogologo. ");
INSERT INTO mek_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Iꞌina auga Deo eegai faemai koa aisama, kapa agaꞌo faekapa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Isa ega eifa oma aisama, Faliseo auꞌi isa kepainia keinaka, “Oi auga laomai apalagai lomauni ke lofaꞌa kai pau lai mopamalelenimai ma looma,” keoma. Ke keafiia Iudea papiauꞌi eꞌi laꞌafou afugai kepapealaisa. ");
INSERT INTO mek_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesu au maaga epafelo auga laꞌafou afugai kepapealaisa auga fouga elogo, ke elao eisa aisama epainia einaka, “Oi Papiau Aumauni Gauga lopakoꞌania ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kai au egaꞌina epaꞌani einaka, “Au akaikiꞌa aumu, isa kaisau auga maauai moifania ega koa lau isa fapakoꞌania laoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ke Iesu einaka, “Oi pau isa loisa. Iifa gome isa pau oi fou oniniꞌani,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ega aisama au egaꞌina einaka, “Lopia lau oi lapakoꞌanio,” eoma, ke eau afagaina. ");
INSERT INTO mek_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ke Iesu einaka, “Lau iꞌina agofaꞌa lamai auga papiau eꞌi laomai felo, o apala auga afa fapeniꞌi, ega koa maakimiꞌi auꞌi maaꞌi fekiakae afu fekeisa, ke maaꞌi felo auꞌi maaꞌi fekimiꞌi laoma puo lamai,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Kai Faliseo auꞌi isaꞌi egae fou keapa auꞌi Iesu aina kelogonia aisama kepaꞌani keinaka, “Aa, kapaꞌina? Lai isafa maamai ekimiꞌi ma looma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ke Iesu einaka, “Oi maami gakimiꞌi koa aisama, laomai apala okapa auga kelelega laaꞌi femia. Kai pau oi oifa oi maami felo ooma puo, egaꞌina kelelega eemiai ageka mo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ke Iesu eifa pugu einaka, “Iifa gome maamiai laifania. Aufalao agaꞌo sipi eꞌi fagapu paꞌafinai aekoko kai elao keaga iꞌoiꞌiai eꞌuapagai ekoko auga, painao auga papiau eauniꞌi kai eꞌi amu eafiꞌi auga. ");
INSERT INTO mek_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kai au kapa paꞌafiai ekoko auga sipi egaꞌina eꞌimaꞌimaꞌi auga. ");
INSERT INTO mek_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ke imaꞌima auga paꞌafi epaagalaisa isa ekoko, ke ega sipi isa aina kelogo kefiakoa. Ke isa ega sipi akaꞌiai ekae eifaniꞌi epapealaiꞌi. ");
INSERT INTO mek_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ke isa ifo ega sipi maꞌoai epapealaiꞌi afegai aisama, isa eufai kai ega sipi auga isa muninai kelao, gome sipi isa aina kelogo magakania. ");
INSERT INTO mek_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kai sipi au aꞌina akelogonia auga muninai afakelao. Iifa gome auga, sipi au aꞌina egaꞌina eegai akepiaukoko, gome isa aina akelogo magakania,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu iꞌina palapole isa maaꞌiai eifania kai kapaꞌina eifania auga oko akelogo. ");
INSERT INTO mek_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ega puo Iesu eifa pugu einaka, “Iifa gome maamiai laifania. Sipi eꞌi fagapu paꞌafina auga lau. ");
INSERT INTO mek_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ke au maꞌoai lau agouai kemai auꞌi painao auꞌi, ke isa auga painao auꞌi papiau keauniꞌi kai eꞌi amu keafiꞌi auꞌi koa iꞌopoꞌi. Kai sipi isa ainaꞌi akelogonia. ");
INSERT INTO mek_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Lau auga paꞌafi. Au kapa iꞌina paꞌafinai agekoko auga kania ageisagamau. Ke isa egaꞌina paꞌafinai agekoko agemai, ke agepealai agelao sipi eꞌi animai afuga felo ipauma agaꞌo ageisa. ");
INSERT INTO mek_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kai painao papiauga auga sipi gapainaoniꞌi, gaaupuguꞌi, ke gapalifuꞌi mo puogai emai. Kai lau lamai auga kaisau lau ainau keafia auꞌi mauni mamaga fekeafia laoma, ke egaꞌina maunina isa aloꞌiai fepogu, fepafakaua laoma puo lamai. ");
INSERT INTO mek_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ke lau auga Sipi Iꞌima felo au. Sipi iꞌima felo auga ifo elogoaina ega sipi fauꞌiai emae. ");
INSERT INTO mek_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kai au agaꞌo afa keoge sipi eꞌimaꞌi auga, sipi iꞌima inagome auga laaꞌi. Ega puo ago alo amuꞌega emai eisa aisama, sipi epuaꞌafuniꞌi epiaukoko. Ega aisama ago alo amuꞌega egaꞌina elao sipi eagaꞌi euokaꞌi kekani okaoka. ");
INSERT INTO mek_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ke au egaꞌina epiaukoko, gome isa afa keogeisa puogai epinauga kai, sipi egaꞌina ala fekeoma auga gefaꞌi agaꞌo aeauga. ");
INSERT INTO mek_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Iesu eifa pugu einaka, “Lau auga Sipi Iꞌima felo au. Gome lau Amau elogoniau koa iꞌopoga, lau isafa eꞌu sipi lalogoniꞌi, ke eꞌu sipi isafa lau kelogoniau. Ke lau ifou imaau lalogoaina, sipi fauꞌiai alamae. ");
INSERT INTO mek_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kai sipi isaꞌi iꞌina fagapuga alogai akeapapa auꞌi isafa keapae. Lau sipi egaꞌina auꞌi isafa famaiseiniꞌi fagapu iꞌina alogai fekeapa, lau eꞌu sipi fou agaꞌomo fekemia laoma. Ke egaꞌina sipiꞌi isafa lau ainau akelogo, ke maꞌoai agaꞌomo akemia lau eꞌu sipi akemia, ke lau iifou mo sipi iꞌima au alamia. ");
INSERT INTO mek_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ega kainai lau Amau alo koꞌagai lau aniu eani alogaina. Gome lau ifou imaau lalogoaina alamae. Ke alamae auga afalamae umamo kai, mauni egaꞌina faafimue pugu eoma puo alamae. ");
INSERT INTO mek_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Lau eꞌu mauni kai agaꞌo afaeafaniau kai, lau ifou lalogoainiau ega koa alakapa. Ke lau ifou imaau fapipeni auga isapuga eeuai ekae, ke faafimue pugu auga isafa isapuga eeuai ekae. Iifa kapulaga iꞌina auga lau Amau eegai laafiia,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Iesu ega eifa oma aisama, Iudea papiauꞌi ifoꞌi mo epoꞌiai keꞌeaiꞌi. ");
INSERT INTO mek_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ke papiau maꞌo keifa keinaka, “Isa tiapolo alogai eague, ekafoꞌo alogaina. Kapa puo isa aina falogo?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kai isaꞌi keifa keinaka, “Au agaꞌo alogai tiapolo eague auga ega niniꞌani aꞌo iina koa laaꞌi. Ke au agaꞌo alogai tiapolo eagu auga ala koa maakimiꞌi auga maaga agepakiakaea agekaina?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Egaꞌina afegai ufainagai Iudea papiauꞌi Deo ega eꞌa Deo kepalao penia auga miamia kina emai. Ke egaꞌina miamia kina auga inipo aupu alogai emia. ");
INSERT INTO mek_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Egaꞌina alogai Iesu elao Deo ega eꞌa alogai afu aka Solomon ega Aꞌama keoma auga afugai epea. ");
INSERT INTO mek_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ega aisama Iudea papiauꞌi kemai Iesu keapa lofe kai kepaꞌani penia keinaka, “Oi Mesaia koa aisama, maamaisai moifa gomeisa mo. Gaika koa maamaisai iifa koꞌa aloifania?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ke Iesu einaka, “Lau oi maamiai laifania efua kai oi lau alopakoꞌaniau paisa. Ke lau Amau akagai mirakulo lakapaiꞌi auꞌi lau fauai keniniꞌani. ");
INSERT INTO mek_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kai oi lau alopakoꞌaniau paisa, gome oi lau eꞌu sipi epoꞌiai laaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Lau eꞌu sipi ainau kelogo, ke lau isa lalogoniꞌi, ke isa lau muniuai kepea. ");
INSERT INTO mek_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Lau isa agu pagai maunina lapeniꞌi, ke isa afakemae laaꞌi afakemia. Ke kai agaꞌo isa lau imauai afaeafilaiꞌi. ");
INSERT INTO mek_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ke lau Amau isa lau epeniiau Auga, kapa maꞌoai ekaꞌegainiꞌi. Ega puo kai agaꞌo isa lau Amau imagai afaeafilaiꞌi. ");
INSERT INTO mek_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Gome lau ke lau Amau fou agaꞌomomai.” ");
INSERT INTO mek_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ega aisama Iudea papiauꞌi kepo keafiiꞌi isa kegafouga pugu keoma. ");
INSERT INTO mek_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kai Iesu isa epainiꞌi einaka, “Lau Amau eegai mirakulo akaikiꞌaꞌi maꞌo kemai auꞌi lakapaiꞌi lapakinaimi. Mirakulo egaꞌina epoꞌiai kapa auga puogai kepoai amofouniau ooma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Kai Iudea papiauꞌi iifa kepamue keinaka, “Lai egaꞌina mirakuloꞌi puoꞌiai amafounio alaoma. Kai oi papiau aumauni mainimu kai, ifomu Deo loomaiso auga, Deo eegai loifa apala puo amafounio aoma,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ega aisama Iesu einaka, “Ufainagai profeta Deo ega iifa pukagai Deo papiau isaꞌi eifaniꞌi deo eomaiꞌi auga fouga iina kepapua oma, ‘Lau oi deo laomaimi.’ ");
INSERT INTO mek_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Deo isa eifaniꞌi deo eomaiꞌi mo ganinagai, ega iifa isa epeniiꞌi. Ega puo Deo ega iifa egaꞌina auga, iifa koꞌa ipauma, ke ageka aoniamo. ");
INSERT INTO mek_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kai lau auga, lau Amau ekinaniau, alo lolofa au epamiaisau, eulaisau iꞌina agofaꞌa lamai. Ega puo kapa puo lau Deo Gauga laoma auga, oi oifa lau Deo eegai laifa apala ooma. ");
INSERT INTO mek_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ke lau Amau ekapa auga afalakapa koa aisama, oi lau folopakoꞌaniau. ");
INSERT INTO mek_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kai lau Amau ekapa auga lakapa koa aisama, oi lau afolopakoꞌaniau mo ganinagai, mirakulo lakapaꞌi auꞌi fopakoꞌaniꞌi, ega koa Amau lau alouai eague, ke lau Isa alogai laague auga agologo felo afaefuafua,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Iesu ega eifa oma aisama, Iudea papiauꞌi isa kegaafia pugu keoma kai, isa papiau epoꞌiai eapagea puo akeafia. ");
INSERT INTO mek_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Egaꞌina afegai Iesu Jordan agapugegai epagai elao Ioane mamagai mo baptismo epipeni auga afugai eagu. ");
INSERT INTO mek_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ke egae eaguega kai, papiau maꞌo isa eega kemai auꞌi keifa keinaka, “Ioane mirakulo gouga agaꞌo aekapaisa mo ganinagai, iꞌina auga fouga eifania auꞌi maꞌoai koꞌaꞌi moaꞌina,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ke papiau maꞌo egae Iesu kepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Egaꞌina afegai au agaꞌo aka Lasarus eisafa eka. Isa ifiao aka Maria ke aaga Marta auniꞌi eꞌi pagua aka Betani paguaga auga. ");
INSERT INTO mek_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ifiao iꞌina aka Maria auga mulamula foga felogai Lopia Iesu ife eꞌefaisa, ke fufugai epaigu fugania auga afakua aka Lasarus eisafa eka. ");
INSERT INTO mek_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ega puo Lasarus afakua gua iifa keulaisa Iesu kepainia keinaka, “Lopia, moisa oi alomu koꞌagai anina loani alogaina auga eisafa ekae,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ke Iesu iꞌina iifaga elogo aisama eifa einaka, “Isafa egaꞌina auga agelao mae afaemia kai, Deo ega akaikiꞌa ke ega isapu fou fefoki kainai isa eisafa. Ega koa isafa egaꞌina faagagai papiau, Deo Gauga au akaikiꞌa fekepamia eoma kainai ega emia oma,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu Maria aaga Marta ke afakuaꞌi Lasarus fou aniꞌi eani alogaina. ");
INSERT INTO mek_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ega mo ganinagai Lasarus eisafa fouga elogo aisama, fiakoa isa eeꞌi pagua aelao kai, kina gua mo isa eagu paguagai eagu. ");
INSERT INTO mek_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Egaꞌina afegai Iesu ega imoi epainiꞌi einaka, “Iꞌa amamue Iudea ago amalao pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kai isa ega imoi keinaka, “Rabai, pau mo egae Iudea papiauꞌi oi kepoai kegafounio keoma kai pau momue ega molao pugu looma,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ke Iesu einaka, “Kina agaꞌomo alogai kina maaga ouꞌaga laagai gua laaꞌi pagu? Au agaꞌo kinai epea koa aisama, ife afaeꞌanina, gome isa iꞌina agofaꞌa eaeagai afu eisa epea. ");
INSERT INTO mek_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kai gapiai agepea aisama kai ife ageꞌanina, gome eaea laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iesu egaꞌina iifaga eifania afegai, ega imoi epainiꞌi pugu einaka, “Iꞌa ekefaꞌaꞌa Lasarus efeu efua, alalao egae alapago ageꞌuegekae,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kai Iesu ega imoi keifa keinaka, “Lopia isa efeu koa aisama, felo agemia,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iesu Lasarus emae efua auga fouga eifania kai, isa ega imoi auga kapaꞌina eifania auga akelogo puo keopolaga efeu ipauma mo keoma. ");
INSERT INTO mek_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ega puo Iesu isa maaꞌiai eifa ofakaea einaka, “Lasarus emae efua. ");
INSERT INTO mek_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ke oi faumiai lau isa fou egae laaꞌi auga alogama lapaꞌaua, ega koa oi lau fopakoꞌaniau. Pau omai isa eega alao,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ega aisama ega imoi agaꞌomo Tomas kepafaala Didimas, iꞌa malaꞌaisai kafela keoma auga, Iesu kapaꞌina eifania auga aelogo felo puo Iesu ega imoi isaꞌi auꞌi epainiꞌi einaka, “Iꞌa isafa isa fou alao, ega koa Lopia fou kaiꞌalao famae,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ke Iesu elao Betani paguagai epealai aisama, Lasarus kina pani la alogai eka auga elogo. ");
INSERT INTO mek_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani auga Ierusaleme fou epoꞌi afaꞌagamo kilomita oiso koa iꞌopoga. ");
INSERT INTO mek_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ke Iudea papiauꞌi maꞌo kemai Marta akina Maria auniꞌi afakuaꞌi emae puo kegapaameꞌi keoma. ");
INSERT INTO mek_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta Iesu emai fouga elogo aisama, epea apua elao kai, Maria auga eꞌai mo eagu. ");
INSERT INTO mek_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ke Marta elao Iesu eisa aisama epainia einaka, “Lopia, oi inae moagu koa aisama, afakuau faemae. ");
INSERT INTO mek_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kai lalogo pau ganinagai, Deo kapaꞌina alogoina auga agepenio,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ke Iesu Marta epainia einaka, “Oi afakuamu agemaunimue pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ke Marta einaka, “Lau lalogo kina fuagai papiau maꞌoai maeai akemaunimue aisama, isa isafa agemaunimue,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ega aisama Iesu isa epainia einaka, “Papiau maeai ipamaunimueꞌi, ke mauni mamaga pipenina gome auga lau. Ega puo kaisau lau agepakoꞌaniau auga emae mo ganinagai, mauni mamaga ageafia paisa. ");
INSERT INTO mek_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ke kaisau pau eague auga, lau agepakoꞌaniau auga afaemaemae. Oi iꞌina iifaga lopakoꞌania ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ke Marta einaka, “E Lopia, lau lapakoꞌania, oi Mesaia Deo Gauga aumu, alomai inae agofaꞌai keoma auga,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ke iꞌina iifaga eifania afegai, elao akina Maria eifaga elao meꞌegai kai epainia einaka, “Pamalele auga emai efua, ke oi epaꞌaniainio,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria Iesu emai efua auga fouga elogo aisama, eꞌue efiaisakoa mo eega elao. ");
INSERT INTO mek_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Kai egaꞌina alogai Iesu auga pagua alogai aekoko kai Marta elao auniꞌi kepiaogai, egaꞌina afugai mo eapa. ");
INSERT INTO mek_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Iudea papiauꞌi Maria fou keagu kepaame auꞌi Maria eꞌue efiaisakoa mo epealai keisa aisama, keopolaga isa la apepe elao keoma puo, muninai mo kelao. ");
INSERT INTO mek_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ke Maria elao Iesu eapa afugai epealai Iesu eisa aisama, ife foꞌinai eꞌualai eomukipo kai epainia einaka, “Lopia, oi inae moagu koa aisama afakuau faemae,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iesu isa eapepe eisa, ke Iudea papiauꞌi isa fou kemai auꞌi isafa keapepe eisaꞌi aisama, guaꞌi eani alogaina, ke alo isafa ekiekie alogaina. ");
INSERT INTO mek_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ega puo epaꞌani peniꞌi einaka, “Kapai oogeisa?” eoma. Ke isa keinaka, “Lopia, ifomu momai moisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ega aisama Iesu isafa eꞌina eapepe. ");
INSERT INTO mek_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ke Iudea papiauꞌi isa eapepe keisa aisama, keifa keinaka, “Koꞌa isa anina ala eani oma auga amoisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kai egaꞌina papiauꞌi isaꞌi auꞌi keinaka, “Isa maakimiꞌi auga maaga epafelo puo, gaifa Lasarus faemae gaoma koa, femae ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iesu Maria eapepe eisa ke Iudea papiauꞌi isa fou kemai auꞌi isafa keapepe eisaꞌi guaꞌi eani alogaina, ke alo isafa ekiekie alogaina puo emai laai eapa. Ke egaꞌina laaga auga iku inegai ke fopa akaikiꞌa ake kepae apua. ");
INSERT INTO mek_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ega puo Iesu papiau egae keapa auꞌi epainiꞌi einaka, “Fopa amopaelaisa,” eoma. Kai mae auga afakua Marta einaka, “Lopia, isa kina pani emae eka puo, pau auga isa foga apala emia efua,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ega aisama Iesu eifa einaka, “Lau oi alapainio, oi lau alopakoꞌaniau aisama, Deo ega isapu ke ega eaea akaikiꞌa fou afoloisaꞌi alaoma ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ega puo fopa la ake kepae apua auga kepaelaisa. Egae kai Iesu ufa eakae penia kai eifa einaka, “Amau, ainau lologonia kainai tenkiu lapenio. ");
INSERT INTO mek_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Lau lalogo oi aufa kina mo ainau lologo kai, iꞌina papiauꞌi inae keapae auꞌi fauꞌiai iꞌina iifaga laifania, ega koa isa lau oi eemuai lamai auga fekepakoꞌania laoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iesu egaꞌina eifania efua aisama, eifa akaikiꞌa einaka, “Lasarus, mopealai mai!” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ega aisama mae auga tiapu manipina faaga ke kania fou kemoka auga faagagai kekaega kai epealai emai. Ega aisama Iesu papiau egae keapa auꞌi epainiꞌi einaka, “La tiapuga faagagai ekaega auga amoafilaisa kai amopuaꞌafuga galao,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ega puo Iudea papiauꞌi Maria iisa kemai auꞌi maꞌo Iesu kapaꞌina ekapaisa keisa aisama, Iesu kepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kai egaꞌina papiauꞌi isaꞌi auꞌi Faliseo auꞌi eeꞌi kelao Iesu kapaꞌina ekapaisa auga maaꞌiai fouga keifania. ");
INSERT INTO mek_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ega aisama sakedote lopiaꞌi, ke Faliseo auꞌi fou iifa ipakaina afugai kansolo auꞌi fou laꞌafou agaꞌo keifaga. Egaꞌina alogai ifoꞌi mo epoꞌiai kepaꞌani keinaka, “Au egaꞌina emai mirakulo gouꞌi maꞌo ekapaꞌi puo iꞌa kapaꞌina fakapa? ");
INSERT INTO mek_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Iꞌa isa maaga mo agaisaoga egaꞌina agekapaꞌi koa aisama, papiau maꞌoai isa akepakoꞌania. Ega aisama Roma kamanina papiauꞌi akemai iꞌa afuꞌa ke aꞌa ago fou akeafiꞌi,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ega aisama epoꞌiai au aka Kaiafas inipo egaꞌina alogai sakedote lopia faꞌa emia auga eifa einaka, “Oi kapa agaꞌo alologo mo laaꞌi! ");
INSERT INTO mek_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Au agaꞌomo papiau fauꞌiai femae auga felo kai, isa puogai ago fofouga papiauꞌi fekemae laaꞌi fekemia auga apala ipauma auga aloisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Isa egaꞌina iifaga eifania auga, isa ifo ega logoai aeifania kai, egaꞌina inipogai isa sakedote lopia faꞌa emia kainai, profeta koa emia Iesu Iudea ago papiauꞌi fauꞌiai agemae auga fouga eifafoua. ");
INSERT INTO mek_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kai Iesu auga egaꞌina ago papiauꞌi mo fauꞌiai afaemae kai, Deo gauga kekani okaoka ago iꞌoiꞌi iꞌoiꞌiai keagu auꞌi isafa fekemai afu agaꞌomogai fekeagu papiau agaꞌomo fekemia eoma kainai agemae. ");
INSERT INTO mek_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ega puo egaꞌina papiauꞌi egaꞌina kinagai keꞌina Iesu isaupugua iifaga kepaapa. ");
INSERT INTO mek_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ega puo Iesu Iudea papiauꞌi epoꞌiai kalafaꞌai aelao aemai kai, elao ago maini kainagai pagua agaꞌo aka Efraim, egae ega imoi fou keagu. ");
INSERT INTO mek_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ke Iudea papiauꞌi eꞌi Pasover miamiaga kina emai kainagai aisama, papiau maꞌo taoni afegai keagu auꞌi kelao Ierusaleme taoninai. Ke miamia aemia koa kai isa ifoꞌi eꞌi kagakaga kainai aloꞌi ofuga keikuisa efua kai, keagu egaꞌina miamia keꞌimaisa, alogai fekekoko keoma. ");
INSERT INTO mek_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Egaꞌina alogai isa Deo ega eꞌa eapa afugai keapa Iesu kekapunia, ke ifoꞌi mo epoꞌiai kepaꞌani keinaka, “Ala oopola oma? Isa iꞌina miamia afaemai ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kai sakedote lopiaꞌi ke Faliseo auꞌi fou papiau keifa kapula peniꞌi keifa, aufalao Iesu kapai afeisa koa, femai maaꞌiai feifa fefiakoa ega koa fekeafia fekegope keoma. ");
INSERT INTO mek_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kina imagea mo keka Pasover miamiaga agemia auga kinagai, Iesu emai Betaniai Lasarus eagu, ke maeai epamaunimue auga paguagai. ");
INSERT INTO mek_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ke egae gapigapi foꞌamaga Iesu faugai kekapaisa eka. Ke Marta foꞌama eako alogai, Lasarus auga teipoloai papiau akeaniani auꞌi fou keagu. ");
INSERT INTO mek_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Egaꞌina alogai Maria mulamula afa akaikiꞌa ipauma, ke foga felo aka nad auga eafiia emai Iesu ife eꞌefaisa. Egae kai fufugai Iesu ife epaigu fugania. Ega aisama egaꞌina eꞌa alo mulamula egaꞌina foga epogu. ");
INSERT INTO mek_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Kai Iesu ifo ega apostolo agaꞌo aka Judas Iskariot muniai isa ageꞌafaꞌafalaina auga Maria ega koa ekapaisa auga anina aeani. ");
INSERT INTO mek_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ega puo eifa einaka, “Iꞌina mulamula afa auga inipo agaꞌo papiau epinauga afa eafiia koa iꞌopoga. Ega puo kapa puo iꞌina mulamula iꞌafalaina aemia, ke monina ulalu auꞌi ipeniꞌi aemia kai isa faagagai lopafua aagenia mo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas Iskariot ega eifa oma auga, isa ulalu papiauꞌi gefaꞌi eauniia kainai ega aeifa oma kai, isa ifo painao auga kainai ega eifa oma. Isa Iesu ega imoi auꞌi eꞌi moni feꞌa eꞌimaisa kainai, feꞌa alogai moni pika keukaisa auga eafiia kapaꞌina anina eani auga eꞌafaisa ifo epalagaina. ");
INSERT INTO mek_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Kai Iesu Judas epainia einaka, “Isa mopuaꞌafuga. Isa mulamula foga felo iꞌina afa eegai ekae auga, eegai feka mo felao lau laai akefufuniau kinagai kai fepapinauga. ");
INSERT INTO mek_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Gome ulalu papiauꞌi auga oi epomiai akeagu afaefua kai lau auga oi fou afalaagu pagainia,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ke Iesu egae eaguega kai Iudea papiauꞌi Iesu egae eagu auga fouga kelogo. Ega puo laꞌafou akaikiꞌagai kemai isa mo kegaisa akeoma kai, Lasarus maeai epamaunimue auga isafa kegaisa keoma. ");
INSERT INTO mek_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ega puo sakedote lopiaꞌi iifa kepaapa Lasarus isafa fekeaupugua keoma. ");
INSERT INTO mek_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Gome isa emaunimue puogai, Iudea papiauꞌi maꞌo kepagai Iesu eega kelao kepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ke egani aisama, laꞌafou akaikiꞌa miamia kemai auꞌi Iesu Ierusaleme pea epea auga fouga kelogo. ");
INSERT INTO mek_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ega aisama isa paꞌogo agaꞌi kefaiponiꞌi keafiiꞌi kai, kepea apua keagaga keinaka: “Hosana!” “Lopia akagai emai auga Deo isa kapa feloꞌi epenia!” “Israel eꞌi Kin auga Deo eegai kapa feloꞌi eafiꞌi!” keoma. ");
INSERT INTO mek_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ke profeta Iesu fouga iina kepapua oma koa iꞌopoga, donki aguꞌa agaꞌo eisa laagai eaguka elao: ");
INSERT INTO mek_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Sion gauga ifiaoga aumu, folomaniꞌi! Oi emu kin donki gauga laagai eaguka emai moisa.” ");
INSERT INTO mek_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Iꞌina iifaga kaisau eifania auga Iesu ega imoi mamagai mo auga akelogo. Kai Iesu maeai emaunimue ufai eꞌagaukae afegai kai, iꞌina iifaga Iesu fouga eifania auga kelogo. Ke Deo ega iifa pukagai kapaꞌina kepapuaꞌi auꞌi iꞌopoꞌi mo papiau isa faagagai kekapaisa auga isafa kelogo. ");
INSERT INTO mek_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ke Iesu Lasarus emae kai la alogai eifaga epealai, epamaunimue keisa papiauꞌi laꞌafouai egaꞌina fouga keifa aefua puo efoufaꞌa. ");
INSERT INTO mek_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ke papiau maꞌo Iesu mirakulo gouga egaꞌina ekapaisa auga fouga kelogo kainai, kepea apua kegaisa keoma. ");
INSERT INTO mek_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ega puo Faliseo auꞌi ifoꞌi mo epoꞌiai keifa keinaka, “Amoisa, iꞌa aꞌa akekuai kapa agaꞌo alapagama. Maami galao papiau maꞌoai mo isa muninai kepea amoisaꞌi,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ke egaꞌina kinagai Pasover Miamia kainai, papiau kelao Deo kegaau afagaina keoma auꞌi epoꞌiai Grik papiauꞌi isaꞌi isafa fou kelao. ");
INSERT INTO mek_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ke Grik papiauꞌi egaꞌina, Filip Kalilea agogai Betsaida taoninai emai auga kegoinia keinaka, “Au akaikiꞌa aumu, lai anina aani Iesu amaisa aoma,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ke Filip elao Andru epainia, ke Andru Filip auniꞌi kaiꞌialao keoge Iesu kepainia. ");
INSERT INTO mek_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Kai Iesu einaka, “Papiau Aumauni Gauga isapu akaikiꞌa feafia, ke papiau maꞌoai isa au akaikiꞌa fekepamia fekeau afagaina auga kina maaga emai ekainia. ");
INSERT INTO mek_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Iifa gome maamiai laifania, palafa puaga afaeꞌualai aꞌisaai afaemae koa aisama, puaga maꞌo afaemia kai agaꞌomo mo agemia. Kai palafa puaga egaꞌina agemae ke ageuki pugu koa aisama, puaga maꞌo ageoge. ");
INSERT INTO mek_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ke au kapa iꞌina agofaꞌagai ifo ega agu maunina anina eani alogaina auga, ega agu agepagea. Kai au kapa iꞌina agofaꞌagai ifo ega agu maunina anina aeani auga, ageagu mo agelao agu pagai maunina ageafia. ");
INSERT INTO mek_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ke kaisau lau eꞌu pinauga ekapa auga lau muniuai fepea, gome lau kapai alaagu auga, lau eꞌu pinauga auga isafa egae ageagu. Ke kaisau lau eꞌu pinauga ekapa auga, lau Amau isa au akaikiꞌa agepamia agepalopiania. ");
INSERT INTO mek_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ke pau lau alou ekiekie alogaina kai kapaꞌina alaifania? ‘Amau kina maaga iꞌina alogai kaniau mogagaoga alaoma pagu?’ Laaꞌi, lau fakiekie puogai iꞌina kina maagai lamai. ");
INSERT INTO mek_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Amau, Oi emu isapu ke Oi au akaikiꞌamu auga papiau mopakinaꞌi, ifomu akamu akaikiꞌa fopamia,” eoma. Iesu ega eifa oma aisama, aufalao agaꞌo aina ufai emai einaka, “Lau eꞌu isapu ke eꞌu akaikiꞌa papiau lapakinaꞌi ke alapakinaꞌi pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kai laꞌafou egae keapa auꞌi aꞌoaꞌo egaꞌina kelogonia aisama, keifa ufa eauga keoma. Ke isaꞌi auꞌi keifa, agelo agaꞌo isa maagai eniniꞌani keoma. ");
INSERT INTO mek_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ega aisama Iesu einaka, “Aufalao agaꞌo aina egaꞌina ologonia auga lau fauai laaꞌi kai oi faumiai. ");
INSERT INTO mek_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Iꞌina agofaꞌa papiauꞌi eꞌi laomai felo, o apala akeafia auga kina inamoꞌe. Ke lau alamae ke alamaunimue aisama, iꞌina agofaꞌa lopiaga iꞌina agofaꞌagai alapapealaisa. ");
INSERT INTO mek_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ke lau kolotiai akeafiakaeisau aisama, papiau maꞌoai alalaꞌaꞌi eeu akemai,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iesu egaꞌina eifania auga, isa ala agemae oma auga papiau epalogoniꞌi. ");
INSERT INTO mek_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ega aisama laꞌafou papiauꞌi keifa keinaka, “Ufainagai lai Deo ega iifa pukagai alogo auga, Mesaia ageagu pagainia auga fouga alogo keoma. Ega puo ala koa oi loifa, ‘Papiau Aumauni Gauga’ kolotiai akeafiakae looma? Papiau Aumauni Gauga auga kaisau?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ega aisama Iesu isa epainiꞌi einaka, “Eaea oi eemiai ageka epo afaemaefa. Ega puo umina aemai aeafimi koa kai, eaea eemiai ekaega auga eaeagai amopea. Gome au kapa uminagai epea auga ala elao auga aelogo. ");
INSERT INTO mek_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ega puo eaea eemiai ekaega auga amopakoꞌania, ega koa oi eaea gauga fomia,” eoma. Ke eniniꞌani efua aisama, ekailai elao ke fakeisa eoma puo eiꞌofake. ");
INSERT INTO mek_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iesu mirakulo gouꞌi maꞌo Iudea papiauꞌi agoꞌiai ekapaiꞌi keisaꞌi mo ganinagai akepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ega koa emia auga profeta Aisaea iina eifa auga koꞌaꞌi mo kemia: “Lopia kaisau iꞌa aꞌa iifa aifaniꞌi auꞌi epakoꞌaniꞌi? Ke Lopia ima isapuga papiau kapaꞌi epakinaꞌi?” ");
INSERT INTO mek_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Aisaea ega eifa oma kainai papiau egaꞌina Iesu akepakoꞌania. Ke Aisaea Deo ega iifa pukagai afu agaꞌogai iina eifa oma pugu einaka: ");
INSERT INTO mek_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Isa maaꞌi epakimiꞌinia, ke guaꞌi oma ekupunia. Ega koa isa maaꞌiai kapaꞌina emia auga afakeisa, ke guaꞌi omagai kapa agaꞌo oko afakelogo, ke afakepuaipini eeu afakemai, ke lau isa feloꞌi afalapamiaꞌi.” ");
INSERT INTO mek_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaea Iesu fouga ega eifa oma, gome isa Iesu ega isapu ke ega akaikiꞌa fou eisaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ke au akaikiꞌaꞌi auꞌi epoꞌiai isafa maꞌo Iesu kepakoꞌania mo ganinagai, isa ifoꞌi eꞌi laꞌafou afugai Faliseo auꞌi isa afekepapealaiꞌi auga maniꞌina kepaꞌaua puo, eꞌi pakoꞌa akeifafoua. ");
INSERT INTO mek_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Isa ega kekapa oma, gome papiau isa fekeifagainiꞌi auga anina keani alogaina kai, Deo isa feifagainiꞌi auga afaꞌagamo anina keani. ");
INSERT INTO mek_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ke Iesu eifa akaikiꞌa einaka, “Au agaꞌo lau epakoꞌaniau aisama, lau mo aepakoꞌaniau kai lau eulaisau auga isafa epakoꞌania. ");
INSERT INTO mek_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Isa lau eisau aisama, lau eulaisau auga isafa eisa. ");
INSERT INTO mek_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ke lau eaea koa lamia lamai iꞌina agofaꞌagai ega koa kaisau lau epakoꞌaniau auga uminagai afaeagu. ");
INSERT INTO mek_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Kai kaisau lau eꞌu iifa aꞌo elogo kai kaiꞌiai aepea auga, lau isa ega laomai felo, o apala auga afa afalapenia. Gome lau lamai agofaꞌai auga papiau eꞌi laomai felo, o apala afa fapeniꞌi laoma puo alamai kai, kaniaꞌi faagamauga laoma puo lamai. ");
INSERT INTO mek_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kaisau lau eumakalainiau ke eꞌu iifa kainai aepea auga, aufalao agaꞌo isa ega laomai afa felo, o apala afa fepenia auga papiauga eague. Lau iifa egaꞌina laifania auga, kina fuagai aisama, egaꞌina iifaga isa ega laomai apala afa agepenia. ");
INSERT INTO mek_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Gome lau ifou ainau fouga alaifania kai lau Amau eulaisau auga, lau kapaꞌina faifania ke ala faifa oma eoma auga mo laifania. ");
INSERT INTO mek_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ke lau lalogo isa ega iifa kapula auga papiau epapeaꞌi kelao agu pagai maunina afugai kekoko. Ega puo kapaꞌina mo laifaniꞌi auꞌi, lau Amau epainiau maifaniꞌi eoma auꞌi mo laifaniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ke kina agaꞌomo eka Pasover miamia agemia auga kinagai, Iesu iꞌina agofaꞌa agepuaꞌafuga Ama eega agelao auga kina emai ekainia auga elogo. Ke ifo ega papiau iꞌina agofaꞌagai keagu auꞌi, alo koꞌagai aniꞌi eani alogaina mo emai pau kai, pau auga isa aniꞌi eani alogaina auga fua ipauma pau epakinaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Egaꞌina kinagai Iesu ega imoi fou gapigapi foꞌamaga keaniia. Kai egaꞌina alogai tiapolo Judas Iskariot, Saimon gauga, Iesu feꞌafaꞌafalaina auga opolaga apala alogai eogeisa efua kai, isa keagu keaniani. ");
INSERT INTO mek_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesu isa Ama kapa maꞌoai isa ega isapu papagai epamiaꞌi eꞌimaꞌi auga elogo. Ke isa Deo eegai emai ke agemue Deo eega agelao pugu auga isafa elogo. ");
INSERT INTO mek_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ega puo anianiai eꞌuegekae afe tiapuga eiꞌiuka auga eafilaisa eoge meꞌe kai, tauele uufagai egopeisa. ");
INSERT INTO mek_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Egae kai fei eafiia litiai eꞌefauka kai, eꞌina ega imoi ifeꞌi eikuisa. Ke tauele uufagai egope auga eafiia ifeꞌi epaigu fugania. ");
INSERT INTO mek_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Iesu emai Saimon, Peto keoma auga ife gaikua eoma aisama, Saimon einaka, “Lopia, oi lau ifeu aloikuꞌi ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ke Iesu einaka, “Lau kapaꞌina lakapa auga pau afoloisa kai, muniai aisama aloisa alologo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kai Peto einaka, “Laaꞌi, iifa gome ifeu afoloikuꞌi laaꞌi,” eoma. Ke Iesu einaka, “Oi ifemu afalaikuꞌi koa aisama, oi lau eꞌu imoi afolomia,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ega aisama Saimon Peto keoma auga einaka, “Lopia, ega koa aisama ifeu mo foloikuꞌi kai, imau ke kaniau isafa fou moikuꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Kai Iesu einaka, “Papiau agaꞌo eufele efua auga ife mo feikua, gome isa faaga fofouga auga aeofu. Ke oi maꞌoai auga alomi felo kai, epomiai agaꞌo auga alo eofu,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Gome Iesu kaisau isa ageꞌafaꞌafalaina auga elogo puo, aeifa isa maꞌoꞌiai aloꞌi felo aeoma. ");
INSERT INTO mek_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Iesu isa maꞌoai ifeꞌi eikuisa efua aisama, afe tiapuga eiꞌiuka pugu kai, elao afugai eagukipo. Egae kai ega imoi epaꞌani peniꞌi einaka, “Oi faagamiai kapaꞌina lakapaisa auga ologo ma? ");
INSERT INTO mek_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Oi lau oifaniau ‘Pamalele Aumu’ ke ‘Lopia’ ooma. Oi lau ega oifa oomaisau auga oifa feloisau, gome lau egaꞌina au. ");
INSERT INTO mek_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Pau lau oi emi Lopia ke emi Pamalele Au oi ifemi laikuisa koa iꞌopoga, oi isafa ifomi agaꞌo agaꞌo ifemi foikua. ");
INSERT INTO mek_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ke lau laomai felo oi lapakinaimi auga oi faumiai lakapaisa koa iꞌopoga oi isafa fokapa. ");
INSERT INTO mek_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Iifa gome maamiai laifania. Pinauga auga ega au akaikiꞌa ega akaikiꞌa aekaꞌegaina. Ega koa iꞌopoga, iifa ipapea auga kaisau isa eulaisa auga aekaꞌegaina. ");
INSERT INTO mek_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Pau iꞌina kapaꞌi ologo ke agokapaꞌi koa aisama, Deo kapa feloꞌi agepenimi. ");
INSERT INTO mek_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Lau oi maꞌoai mo foumi alaifania, gome lau kaisau mo lakinaniꞌi auꞌi lalogoniꞌi. Kai iꞌina iifaꞌi laifaniꞌi auꞌi Deo ega iifa pukagai iifa kekae auꞌi koꞌaꞌi mo fekemia kainai: ‘Kaisau lau fou lau eꞌu palafa aania auga, lau ageumakalainiau ke ageꞌafaꞌafalainiau.’ ");
INSERT INTO mek_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Lau faagauai egaꞌina kapaꞌi akemia koa kai oi maamiai laifaniꞌi, ega koa faagauai akemia aisama, lau Mesaia auga fopakoꞌania laoma. ");
INSERT INTO mek_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Iifa gome maamiai laifania. Papiau kapa lau au agaꞌo laulaisa auga ageifa koko koa aisama, isa lau eifa kokoisau. Ke kaisau lau eifa kokoisau auga, lau Amau eulaisau auga eifa koko,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iesu egaꞌina eifania afegai, alo maikiekiegai eifa einaka, “Iifa gome maamiai laifania. Oi epomiai aufalao agaꞌo lau ageꞌafaꞌafalainiau,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ega aisama Iesu ega imoi Iesu kaisau eifania auga akelogo puo ifoꞌi mo maaꞌi keisa. ");
INSERT INTO mek_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Isa ega imoi epoꞌiai agaꞌo Iesu anina eani alogaina auga Iesu eegai eagu eaniani. ");
INSERT INTO mek_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Peto keoma auga imoi egaꞌina Iesu gapaꞌani penia kaisau eifania auga gouga ekapaisa einaka, “Kaisau eifania auga mopaꞌani penia gaifania,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ke isa Iesu eega elao faagagai eꞌafeau kai epaꞌani penia einaka, “Lopia kaisau oi ageꞌafaꞌafalainio?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ke Iesu einaka, “Palafa iꞌina alaꞌiupa au kapa alapenia auga, isa lau ageꞌafaꞌafalainiau,” eoma. Egae kai palafa eafiia auga eꞌiupia kai Saimon gauga, Judas Iskariot epeniia. ");
INSERT INTO mek_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ke Judas palafa eafiia aisama, fiakoa mo Satani isa alogai ekoko. Ega aisama Iesu isa epainia einaka, “Kapaꞌina mokapa looma auga fokapa fofiakoa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kai maꞌoai egae keagu keaniani auꞌi kapa puo Iesu isa ega epaini oma auga akelogo. ");
INSERT INTO mek_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Gome Judas moni eꞌimaisa kainai isaꞌi keopolaga Iesu isa epaina, kapaꞌina miamiai akepapinauga auga gaꞌafa eoma keoma, o kapa agaꞌo ulalu papiauꞌi gapeniꞌi eoma keoma. ");
INSERT INTO mek_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas palafa eafiia aisama, fiakoa mo eꞌue epealai. Ke egaꞌina auga gapiai emia. ");
INSERT INTO mek_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas elao efua aisama, Iesu eifa einaka, “Pau Papiau Aumauni Gauga isapu akaikiꞌa eafiia, ke au akaikiꞌa emia, ke Deo isafa ega akaikiꞌa ala koa auga Papiau Aumauni Gauga faagagai eafiia efua. ");
INSERT INTO mek_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Isa faagagai Deo ega isapu ke ega akaikiꞌa ala koa auga eafiia koa aisama, Deo faagagai Isa Gauga ega akaikiꞌa, ke ega isapu ala koa auga agefoki agoisa. Ke fiakoa mo Deo isa isapu agepenia, ke au akaikiꞌa agepamia. ");
INSERT INTO mek_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Eꞌu imoi aumi, lau oi fou agaagu epo afaemaefa. Ke Iudea papiauꞌi lapainiꞌi koa iꞌopoga, pau oi isafa lapainimi. Oi lau agokapuniau kai lau ala lalao auga oi ega afololao. ");
INSERT INTO mek_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Ke lau iifa kapula mamaga oi lapenimi. Oi alomi koꞌagai agaꞌo agaꞌo animi foani. Ke lau alou koꞌagai oi animi laani koa iꞌopoga, oi isafa agaꞌo agaꞌo animi ega foani oma. ");
INSERT INTO mek_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Oi agaꞌo agaꞌo animi agoani aisama, oi lau eꞌu imoi auga papiau maꞌoai akelogo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ega aisama Saimon Peto keoma auga isa epaꞌani penia einaka, “Lopia, oi ala alolao?” eoma. Ke Iesu einaka, “Lau ala alalao auga pau muniuai afololao kai, muniai kai alomai,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ke Peto Iesu epaꞌani penia pugu einaka, “Lopia, kapa puo pau munimuai afalafai? Lau ifou lalogoainiau oi faumuai alamae,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ega aisama Iesu einaka, “Koꞌa oi lau puouai alomae ma? Iifa gome maamuai laifania. Oꞌolo aeagaga koa kai oi lau alopuniaiainiau oiso alopamia,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iesu ega imoi epainiꞌi pugu einaka, “Foloopopo alomi faemafu. Deo fopakoꞌania ke lau isafa fopakoꞌaniau. ");
INSERT INTO mek_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lau Amau ega eꞌai afu maꞌo kekae. Ke lau alalao egae oi afumi agaꞌo alaafia ageka. Laaꞌi koa aisama, egaꞌina afuga fouga maamiai falaifania. ");
INSERT INTO mek_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ke lau alalao afumi alapafua ageka aisama, alamue alamai alaafimi fou agalao, ega koa oi isafa lau kapai alaagu egae fou faagu laoma. ");
INSERT INTO mek_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ke lau afu kapa alalao auga keagaga oi ologo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ega aisama Tomas Iesu epainia einaka, “Lopia, oi ala alolao auga lai alalogo puo ala koa keaga egaꞌina agalogo?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ke Iesu einaka, “Amau ega eꞌa ke eega olao ooma auga keagaga lau. Ke lau Deo ega iifa koꞌa auga lapafokia. Ke lau mauni mamaga papiau lapeniꞌi. Ega puo kai agaꞌo ifo lau Amau eega afaelao kai, lau faagauai kai Amau eega agelao. ");
INSERT INTO mek_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Oi lau amologoniau koa aisama, lau Amau isafa fologo. Ke pau lau ologoniau ke oisau kainai, lau Amau isafa ologonia ke oisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ega aisama Filip einaka, “Lopia, oi Amamu lai mopakinaimai, ega koa alomai agekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ke Iesu einaka, “Filip, pau laaꞌi epomiai fou alao amai mo ganinagai, oi lau alologoniau koa ma? Kaisau lau eisau auga Amau isafa eisa. Ega puo kapa puo Amau mapakinaimi looma? ");
INSERT INTO mek_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Lau Amau alogai laague, ke Amau lau alouai eague auga alopakoꞌania ma? Ke iifa laifaniꞌi auꞌi lau ifou eꞌu iifa laaꞌi. Kai Amau alouai eague auga ega pinauga ekapa. ");
INSERT INTO mek_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Lau laifa Amau alogai laague, ke Amau lau alouai eague laoma auga iifaga amopakoꞌania. Ke laaꞌi koa aisama, mirakulo lakapaꞌi auꞌi gouꞌi amoisaꞌi lau Amau amopakoꞌania. ");
INSERT INTO mek_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Iifa gome maamiai laifania. Kaisau lau epakoꞌaniau auga, lau kapaꞌina lakapaꞌi auꞌi agekapaꞌi. Ke lau Amau eega alalao kainai, isa lau pinauga lakapaꞌi auꞌi mo afaekapaꞌi kai, laagai pinauga akaikiꞌaꞌi ipaumaꞌi isafa agekapaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ke lau akauai kapaꞌina agogoina auga alakapa, ega koa Gauga Ama ega akaikiꞌa ala koa auga agepafokia. ");
INSERT INTO mek_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ke oi kapa agaꞌo lau akauai agogoina auga alakapa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Iesu ega imoi epainiꞌi pugu einaka, “Oi alomi koꞌagai lau aniu oani koa aisama, lau iifa kapula oi lapenimi fokapa laoma auga agokapa. ");
INSERT INTO mek_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ke lau Amau alagoina Pipalagai Auga agaꞌo ageulai penimi. Ega koa isa oi fou agoagu aoniamo. ");
INSERT INTO mek_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ke egaꞌina auga Deo ega Spiritu, Deo ega iifa koaꞌi epafokia auga oi alomiai ageagu aoniamo. Agofaꞌa papiauꞌi Deo akelogonia auꞌi, Pipalagai Auga egaꞌina akeisaisa ke akelogonia puo akeumakalaina. Kai oi auga isa fou oagu puo, ologonia ke isa oi alomiai ageagu. ");
INSERT INTO mek_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ke lau oi isagepa koa afalapuaꞌafunimi kai, alamue eemi alafai. ");
INSERT INTO mek_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ke pau kina epo afaemaefa agofaꞌa papiauꞌi lau afakeisau kai, oi auga lau agoisau. Ke lau laague aoniamo kainai, oi isafa agoagu aoniamo. ");
INSERT INTO mek_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ke ega kinagai Deo ega Spiritu ageake penimi aisama, lau Amau alogai laague, ke oi lau alouai oague, ke lau oi alomiai laague auga agologo. ");
INSERT INTO mek_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ke kaisau lau eꞌu iifa kapula eafiꞌi kaiꞌiai epea auga, alo koꞌagai lau aniu eani auga. Ke kaisau alo koꞌagai lau aniu eani auga, lau Amau isafa alo koꞌagai isa anina ageani. Ke lau isafa alou koꞌagai isa anina alaani, ke lau ifou lau kaisau auga isa alapakina,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ega aisama Judas (Judas Iskariot laaꞌi kai, agaꞌo auga) eifa einaka, “Lopia, kapa puo oi kaisau auga lai alopakinaimai kai, agofaꞌa papiauꞌi auga afolopakinaꞌi looma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ke Iesu einaka, “Kaisau alo koꞌagai lau aniu eani auga, eꞌu pamalele kaiꞌiai agepea. Ega aisama lau Amau alo koꞌagai isa anina ageani, ke lau Amau fou isa eega agamai alogai agapagua agaagu. ");
INSERT INTO mek_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kai kaisau alo koꞌagai lau aniu aeani auga, eꞌu pamalele kaiꞌiai afaepea. Iꞌina iifaꞌi aꞌoꞌi ologoniꞌi auꞌi, lau ifou apu laaꞌi kai, Amau lau eulaisau auga apuga. ");
INSERT INTO mek_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Lau oi fou aaguega kai, iꞌina kapaꞌi maamiai laifaniꞌi. ");
INSERT INTO mek_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kai Amau Pipalagai Auga, Isa ega Spiritu, lau akauai ageulai penimi. Ke isa kapa maꞌoai agepamalelenimi, ke kapa maꞌoai maamiai laifaniꞌi auꞌi isafa agepaopolanimi afaefuafua. ");
INSERT INTO mek_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Lau gagao oi lapenimi, egaꞌina auga lau eꞌu gagao eemiai lapuaꞌafuga. Ke lau kapaꞌina lapenimi auga agofaꞌa papiauꞌi kepipeni koa iꞌopoga koa alapipeni. Ega puo foloopopo alomi faemafu ke folomaniꞌi. ");
INSERT INTO mek_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Lau alalao ke alamue eemi alamai auga fouga laifania ainau ologonia. Oi alomi koꞌagai lau aniu oani koa aisama, lau Amau ekaꞌegainiau auga eega alalao puo alogama fopaꞌaua. ");
INSERT INTO mek_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Lau egaꞌina kapaꞌi akemia koa kai maamiai laifaniꞌi, ega koa akemia aisama fopakoꞌaniau laoma. ");
INSERT INTO mek_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ke iꞌina agofaꞌa lopiaga emai puo, lau oi fou aganiniꞌani epo afaemaefa. Isa ega isapuai kapaꞌina lau faagauai ekapa auga, kapa agaꞌo lau faagauai aemia. ");
INSERT INTO mek_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Kai lau Amau anina laani, ke lau Amau kapaꞌina fakapa eoma auga iꞌopoga mo lakapa auga agofaꞌa felogo laoma,” eoma. Iesu egaꞌina iifaꞌi eifaniꞌi efua aisama, ega imoi epainiꞌi einaka, “Omai, iꞌina afuga amapuaꞌafuga alao,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ke kekailai kepea alogai Iesu ega imoi epainiꞌi einaka, “Lau auga au euki auga, ke lau Amau auga uma alogai epinauga auga. ");
INSERT INTO mek_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Isa lau faagauai au aga epealai kai puaga agaꞌo aeoge auga efoua. Kai au aga kapa puaga eoge auga ekanina, ega koa puaga maꞌo paisa feoge eoma. ");
INSERT INTO mek_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Lau Deo ega iifa oi maamiai laifaniꞌi auꞌi kaiꞌiai oi alomi ofuga auga iikuga emia efua. ");
INSERT INTO mek_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Oi lau alouai foagu ke lau oi alomiai alaagu. Au aga agaꞌo ifo puaga afaeoge. Kai isa au egaꞌinagai ageꞌafauka aisama kai puaga ageoge. Ega koa iꞌopoga, oi lau alouai afoloagu koa aisama, animi agaꞌo afolooge. ");
INSERT INTO mek_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Lau laifa pugu. Lau auga au, ke oi auga au egaꞌina aga aumi. Au agaꞌo lau alouai ageagu, ke lau isa alogai alaagu koa aisama, isa au aga koa iꞌopoga puaga maꞌo ageoge. Gome oi lau fou afalamia koa aisama, kapa agaꞌo agokapa afaekaina. ");
INSERT INTO mek_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ke kaisau lau fou afalaagu auga, au aga kefoua kepuake eka eogogo auga koa iꞌopoga. Au agaꞌi ega koa iꞌopoꞌi auꞌi keafiakaeꞌi loai kepiuauꞌi keaga. ");
INSERT INTO mek_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kai oi lau alouai agoagu, ke eꞌu iifa alomiai ageka koa aisama, kapaꞌina anina oani auga lau Amau fogoina, ke Isa oi kapaꞌina ogoina auga agepenimi. ");
INSERT INTO mek_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Oi kapaꞌina lau Amau ogoina auga agepenimi aisama, au aga puaga maꞌo eoge koa iꞌopomi agomia, ke oi lau eꞌu imoi koꞌami auga papiau akelogo. Egaꞌina agemia auga, oi faagamiai lau Amau ega akaikiꞌa ke ega isapu fou akefoki. ");
INSERT INTO mek_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Ke lau Amau alo koꞌagai lau aniu eani koa iꞌopoga, lau isafa alou koꞌagai oi animi laani. Oi lau alou koꞌagai animi laani auga agugai foagu. ");
INSERT INTO mek_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ke lau Amau kapaꞌina fakapa eoma eifa kapula peniau auga kaiꞌiai lapea kainai, lau Isa alo koꞌagai aniu eani auga laoga maina alogai laague, ke Isa alo koꞌagai lau aniu eani. Ega koa iꞌopoga oi lau kapaꞌina fokapa laoma auga kaiꞌiai mo agopea koa aisama, oi lau alou koꞌagai animi laani auga agugai agoagu. ");
INSERT INTO mek_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Lau egaꞌina iifaga oi maamiai laifania, ega koa lau alou ala egama oma auga, oi isafa alomi ega fegama oma. Ke oi emi alogama egaꞌina fepagai laoma. ");
INSERT INTO mek_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lau eꞌu iifa kapula auga iꞌina; Lau alou koꞌagai oi animi laani koa iꞌopoga, oi isafa alomi koꞌagai agaꞌo agaꞌo animi foani. ");
INSERT INTO mek_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kai agaꞌo ifo imaauga afaelogoaina ekefaꞌa faugai afaemae. Kai kaisau ifo agelogoaina ekefaꞌa egaꞌina faugai agemae auga, iifa koꞌa isa alo koꞌagai ekefaꞌa anina eani alogaina auga. Egaꞌina laoga maina auga kapa maꞌoai ekaꞌegaina. ");
INSERT INTO mek_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Oi lau kapaꞌina laifa kapulania auga agokapa aisama, oi lau ekefaꞌau. ");
INSERT INTO mek_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Lau pau oi alaifanimi eꞌu pinauga aumi alaomaimi, gome pinauga auga, ega au akaikiꞌa pinauga kapa ekapa auga aelogo. Kai lau oi laifanimi ekefaꞌau laomaimi, gome lau Amau eegai kapa maꞌoai lamaleleainiꞌi auꞌi oi lapalogonimi. ");
INSERT INTO mek_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Oi lau alokinaniau kai lau oi lakinanimi, ega koa folao puami maꞌo fooge laoma. Ke puami egaꞌina auga akeka aoniamo auꞌi puaꞌi fooge. Ega koa lau akauai kapaꞌina Amau agogoina auga agepenimi. ");
INSERT INTO mek_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Iꞌina auga lau eꞌu iifa kapula auga; Oi alomi koꞌagai agaꞌo agaꞌo animi foani,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Iesu eifa pugu einaka, “Agofaꞌa papiauꞌi oi animi afakeani koa aisama, isa lau aniu akeani kaukau auga foopolaga. ");
INSERT INTO mek_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Oi iꞌina agofaꞌa apuga amomia koa aisama, oi isa apuga ipauma koa iꞌopomi puo alo koꞌagai animi feani. Kai agofaꞌa alogai lau oi lakinanimi laafilaimi puogai, iꞌina agofaꞌa papiauꞌi oi animi akeani. ");
INSERT INTO mek_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ke lau oi maamiai iifa iꞌina laifania auga foopolaga alomiai feka: ‘Pinauga auga ega au akaikiꞌa aekaꞌegaina,’ laoma. Ke agofaꞌa papiauꞌi lau keafi apalaniau koa aisama, oi isafa akeafi apalanimi. Ke isa lau eꞌu pamalele kaiꞌiai kegapea koa aisama, oi emi pamalele isafa kaiꞌiai fekepea. ");
INSERT INTO mek_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Lau akau puogai isa oi maꞌoai ega akeafi apala omaimi, gome isa lau eulaisau auga oko akelogo. ");
INSERT INTO mek_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Lau falamai isa maaꞌiai falaniniꞌani koa aisama, isa laomai apala kekapaisa auga kelelega aloꞌiai faeka. Kai pau lau lamai ke kapaꞌina apala auga lapakinaiꞌi puo, isa laomai apala kekapa auga kelelega aloꞌiai ageka paisa. ");
INSERT INTO mek_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ke kaisau lau aniu aeani auga, lau Amau isafa anina aeani. ");
INSERT INTO mek_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Lau papiau agaꞌo pinauga aekapakapaꞌi auꞌi isa epoꞌiai lakapaiꞌi puo, isa laomai apalaꞌi kekapaꞌi auꞌi keleleꞌi aloꞌiai kekae. Ke pau isa lau mirakulo lakapaiꞌi keisaꞌi mo ganinagai, aloꞌi koꞌagai lau ke Amau fou animai akeani. ");
INSERT INTO mek_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kai iina koa emia auga, Deo ega iifa pukagai Moses ega iifa iꞌina kepapua auga koꞌa mo emia: ‘Lau kapa apala agaꞌo isa eeꞌiai alakapaisa kai isa aloꞌi koꞌagai lau aniu akeani.’ ");
INSERT INTO mek_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Pipalagai Auga Deo ega Spiritu, ke Deo ega iifa koꞌa epafokia auga lau Amau eegai alaulaisa oi eemi agemai aisama, isa lau fou koꞌa mo ageifafoua. ");
INSERT INTO mek_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kai laꞌina lapamalele aisama, oi lau fou alao amai puo, oi isafa lau fou koꞌa mo foifafoua,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ke Iesu ega imoi epainiꞌi pugu einaka, “Lau oi maamiai egaꞌina iifaꞌi maꞌoai laifaniꞌi ega koa oi keaga iꞌoina foloafia laoma. ");
INSERT INTO mek_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ke papiau oi laꞌafou afugai akepapealaimi. Ke kina agaꞌo agemai, ke egaꞌina kinagai aufalao agaꞌo oi ageaupuguimi aisama, ageopolaga isa Deo ega pinauga ekapa ageoma. ");
INSERT INTO mek_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Isa lau Amau ke lau fou akelogonimai puo, iꞌina kapaꞌi oi faagamiai akekapaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Lau iꞌina kapaꞌi maamiai laifaniꞌi, ega koa egaꞌina kina agemai aisama, kapa laoma oi ainami lapalogo auga foopolaga laoma. Ke lau iꞌina iifaꞌi oi maamiai alaifa kakauꞌi, gome lau oi fou aagu paisa.” ");
INSERT INTO mek_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ke Iesu eifa pugu einaka, “Pau lau eulaisau auga eega alalao kai, oi epomiai kai agaꞌo alopaꞌani peniau aloinaka, ‘Oi ala alolao?’ alooma. ");
INSERT INTO mek_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ke laifa lau eulaisau auga eega alalao laoma kainai, oi alomi emafu alogaina. ");
INSERT INTO mek_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kai iifa gome maamiai laifania. Lau alalao auga oi faumiai felo. Gome lau afalalao koa aisama Pipalagai Auga afaemai. Kai lau alalao koa aisama, isa alaulaisa agemai. ");
INSERT INTO mek_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ke Pipalagai Auga egaꞌina agemai aisama, agofaꞌa papiauꞌi eꞌi laomai apalaꞌi kapaꞌina auga agepakinaꞌi. Ke Deo agogai alo opai laoꞌi maiꞌi kapaꞌina auga isafa agepakinaꞌi. Ke Deo papiau eꞌi laomai felo o apala afa agepeniꞌi auga kapaꞌina auga isafa agepakinaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ke isa lau akepakoꞌaniau kainai laomai apalaꞌi kekapaꞌi auga isafa agepakinaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ke lau Amau eega alalao ke oi afoloisau pugu kainai, papiau ala fekeoma aloꞌi opaina femia auga agepakinaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ke lau puouai Deo iꞌina agofaꞌa iꞌima auga Satani ega laomai afa epeniia efua, ke Deo ageoge lau akepakoꞌaniau auꞌi eꞌi laomai apala afa agepeniꞌi auga agepakinaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Lau iifa maꞌo kekae maamiai faifaniꞌi kai maꞌoai alaifaniꞌi aꞌoꞌi agologo afaekaina. ");
INSERT INTO mek_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kai Deo ega Spiritu, Deo ega iifa koꞌa epafokia auga agemai aisama kai, isa oi agepapeaimi Deo ega iifa koꞌaꞌi auꞌi maꞌoai agepalogonimi. Ke isa ifo ega logoai afaeniniꞌani kai, isa Deo eegai kapaꞌina aꞌo elogo auga mo ageifania. Ke isa kapaꞌina muni akemai auꞌi isafa ageifaniꞌi. ");
INSERT INTO mek_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ke isa kapaꞌina lau apu auga ageafia oi maamiai ageifafoua kainai, isa lau isapu akaikiꞌa ke eaea akaikiꞌa laafia auga agepafokia ke au akaikiꞌau agepamiaisau. ");
INSERT INTO mek_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ke kapa maꞌoai lau Amau apuga auga lau apu. Ega kainai lau laifa, Deo ega Spiritu kapaꞌina lau apu auga ageafia oi maamiai ageifafoua laoma. ");
INSERT INTO mek_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ke kina emai afaꞌagamo afoloisau pugu kai muniai kina epo afaemaefa agoisau pugu,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ega aisama Iesu ega imoi isaꞌi ifoꞌi mo epoꞌiai keifa keinaka, “Isa eifa lau Amau eega alalao puo, kina emai afaꞌagamo afoloisau pugu, ke kina epo afaemaefa agoisau pugu eoma auga kapaꞌina eifania?” keoma. ");
INSERT INTO mek_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ke epoꞌiai kepaꞌani paisa keinaka, “Isa kina emai afaꞌagamo eoma auga kapaꞌina eifania? Ke isa kapaꞌina eifania auga iꞌa oko alalogo,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ega aisama Iesu isa kapaꞌina kegapaꞌani penia keoma auga elogo puo, epainiꞌi einaka, “Oi lau laifa, kina emai afaꞌagamo afoloisau, ke muniai kina epo afaemaefa agoisau pugu laoma iifaga kapaꞌina eifania auga paꞌani ifomi epomiai opaꞌani ma? ");
INSERT INTO mek_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Iifa gome maamiai laifania. Agofaꞌa papiauꞌi aloꞌi agegama alogai, oi auga agoapepe agopinapina. Oi alomi agemafu kai, emi alomafu egaꞌina agepopo alomi agegama. ");
INSERT INTO mek_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ke papie agaꞌo imoi gapamauga eoma aisama, ega mauni kina ekaina puo kiekie akaikiꞌa eafia. Kai imoi agofaꞌai emauni aisama, ega alogamai mauni kiekie egaꞌina eꞌagegeaina. ");
INSERT INTO mek_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ega koa iꞌopoga, oi isafa eemiai ega koa agemia. Pau oi emi alomafu kina kai lau oi alaisami pugu, ke alomi agegama alogaina. Ke kai agaꞌo egaꞌina alogama afaeafanimi. ");
INSERT INTO mek_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ke ega kinagai oi lau eeuai kapa agaꞌo afologoina. Iifa gome maamiai laifania. Lau akauai kapaꞌina Amau agogoina auga agepenimi. ");
INSERT INTO mek_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Oi lau fou alao amai mo alogai, ke emai mo iꞌina kinagai auga, lau akauai kapa agaꞌo lau Amau alogoinia. Kai pau lau akauai Amau amogoina, ke kapaꞌina ogoina auga agoafia ega koa alomi agegama alogaina. ");
INSERT INTO mek_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Lau palapoleai oi maamiai laniniꞌani. Kai kina agaꞌo agemai aisama, lau palapoleai oi maamiai afalaniniꞌani pugu. Kai lau Amau fouga oi maamiai alaifa ofakaea agologo. ");
INSERT INTO mek_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ke ega kinagai oi lau akauai Amau agogoina. Lau alaifa lau oi faumiai lau Amau alagoina alaoma. ");
INSERT INTO mek_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Gome oi alomi koꞌagai lau aniu oani, ke lau Amau eegai lamai auga opakoꞌania puo, lau Amau ifo isafa alo koꞌagai oi animi eani. ");
INSERT INTO mek_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Iifa gome, lau Amau eegai lamai iꞌina agofaꞌa alogai lakoko. Ke pau lau iꞌina agofaꞌa alapuaꞌafuga alamue Amau eega alalao,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ega aisama Iesu ega imoi keifa keinaka, “Moisa! Pau palapoleai aloniniꞌani kai loifa ofakaea mo ainamu alogo. ");
INSERT INTO mek_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Pau lai alogo oi kapa maꞌoai lologo. Ega puo aufalao agaꞌo oi fepaꞌani penio auga anina aloani. Iꞌina kapaꞌi kaiꞌiai oi Deo eegai lomai auga lai apakoꞌania,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ega aisama Iesu einaka, “Oi pau fuagai kai lau opakoꞌaniau. ");
INSERT INTO mek_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kai kina agaꞌo emai ke egaꞌina kina emai efua. Egaꞌina kinagai oi agokani okaoka aua mo emi pagua agolao. Kai oi lau agopuaꞌafuniau mo ganinagai, lau Amau fou aaguega puo lau ifou mo afalaagu. ");
INSERT INTO mek_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Lau iꞌina kapaꞌi maamiai laifaniꞌi, ega koa oi lau fou agaagu puogai oi gagao alomiai ageka. Iꞌina agofaꞌagai oi kiekie akaikiꞌaꞌi agoafiꞌi. Kai alomi fekapula folomaniꞌi. Lau iꞌina agofaꞌa lapalutinia efua,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesu egaꞌina iifaꞌi eifaniꞌi afegai, ufa eakae penia kai emegamega einaka, “Amau, kina emai efua. Ega puo Oi Gaumu ega isapu, ke ega akaikiꞌa ala koa auga papiau mopakinaꞌi, ega koa Oi Gaumu isafa Oi emu isapu, ke emu akaikiꞌa ala koa auga papiau fepakinaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Gome Oi isa isapu lopeniia papiau maꞌoai feꞌimaꞌi ega koa papiau maꞌoai isa lopenia auꞌi, agu pagai maunina fepeniꞌi looma. ");
INSERT INTO mek_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ke papiau agu pagai maunina kegaafia keoma auga iina koa; isa Oi ifomu mo Deo ipaumamu aumu fekelogonio, ke lau Iesu Kristo Oi loulaisau au isafa fekelogoniau looma. ");
INSERT INTO mek_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Lau Oi pinauga lopeniiau auga lakapaisa efua faagagai, Oi emu isapu ke emu akaikiꞌa ala koa auga aagoai papiau lapakinaꞌi efua. ");
INSERT INTO mek_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ke Amau, agofaꞌa aegama koa kai lau Oi fou aagu kinagai emu akaikiꞌa, ke emu isapu fou aafiia. Ke pau Oi loague agomuai emu akaikiꞌa, ke emu isapu egaꞌina fou mopakinaꞌi laoma. ");
INSERT INTO mek_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Oi papiau kapaꞌi mo agofaꞌai lopapealaiꞌi lau lopeniiau auꞌi, Oi kaisau auga lapalogoniꞌi efua. Egaꞌina papiauꞌi Oi emu papiau kai lau lopeniiau, ke isa Oi emu iifa kaiꞌiai mo kepea. ");
INSERT INTO mek_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ega puo kapa maꞌoai lopeniau auꞌi Oi eemuai kemai auga isa kelogo. ");
INSERT INTO mek_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Gome Oi iifa lau lopeniiau auꞌi isa lapeniiꞌi, ke isa egaꞌina iifaꞌi keafiiꞌi kaiꞌiai kepea. Ke lau Oi eemuai lamai auga isa kelogo felo, ke Oi lau loulaisau auga kepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Lau isa fauꞌiai lamegamega. Ke lau agofaꞌa faugai alamegamega kai papiau lau lopeniau auꞌi fauꞌiai lamegamega, gome isa Oi emu papiau. ");
INSERT INTO mek_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kapa maꞌoai lau apu kemia auꞌi Oi apumu. Ke kapa maꞌoai Oi apumi kemia auꞌi lau apu. Lau eꞌu isapu ke eꞌu akaikiꞌa ala koa auga egaꞌina kapaꞌi maꞌoai faagaꞌiai keisaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Lau Oi eemu lafai puo, agofaꞌai afalaagu mo afaelao kai isa auga iꞌina agofaꞌagai akeagu mo agelao. Ega puo Amau, Alo lolofa Aumu, Oi akamu isapuga lau lopeniau auga isapugai isa kapa apalaꞌi eeꞌiai mopakaisapuꞌi, ega koa Oi lau fou agaꞌomo amia koa iꞌopoga, isa isafa agaꞌomo kegamia laoma. ");
INSERT INTO mek_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Lau isa fou aague alogai lau aka lopeniau auga isapugai isa kapa apalaꞌi eeꞌiai lapakaisapuꞌi ke kaniaꞌi laagamauga. Ke isa epoꞌiai kai agaꞌo aegea kai Oi emu iifa koꞌa femia kainai au ipeliai emai auga mo egea. ");
INSERT INTO mek_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Lau pau Oi eemu alafai kai, lau agofaꞌai laaguega kai iꞌina kapaꞌi laifaniꞌi, ega koa lau eꞌu alogama ala koa auga isa isafa aloꞌiai fepogu laoma. ");
INSERT INTO mek_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Lau Oi emu iifa isa lapeniiꞌi ke agofaꞌa isa aniꞌi aeani. Gome isa auga lau koa iꞌopou iꞌina agofaꞌa papiauꞌi laaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Lau eꞌu megamega auga, Oi isa iꞌina agofaꞌagai foafiꞌauꞌi alaoma kai, Oi isa laomai apala ikapa auga eegai fopakaisapuꞌi laoma. ");
INSERT INTO mek_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Koꞌa ipauma, lau iꞌina agofaꞌa papiau laaꞌi koa iꞌopoga, isa isafa iꞌina agofaꞌa papiauꞌi laaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ke Oi ifomu emu iifa koꞌa ipaumagai alo lolofa auꞌi mopamiaꞌi. Iifa gome Oi emu iifa auga koꞌa ipauma. ");
INSERT INTO mek_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Oi lau loulaisau lamai agofaꞌai koa iꞌopoga, lau isafa isa laulaiꞌi kepealai iꞌina agofaꞌa kelao. ");
INSERT INTO mek_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ke isa fauꞌiai lau ifou imaau elolofa emu pinauga lakapaisa Oi lapeniio, ega koa isa isafa ifoꞌi imaauꞌi felolofa Oi emu pinauga aloꞌi koꞌagai fekekapa laoma. ");
INSERT INTO mek_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Lau eꞌu imoi auꞌi mo fauꞌiai alamegamega kai, isa lau fou akeifafoua alogai kaisau lau akepakoꞌaniau auꞌi isafa fauꞌiai lamegamega. ");
INSERT INTO mek_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ega koa Amau, Oi lau alouai loague ke lau Oi alomuai laague koa iꞌopoga, isa isafa maꞌoai agaꞌomo fekemia. Ke isa iꞌa fou agaꞌomoꞌa famia, ega koa agofaꞌa papiauꞌi Oi lau loulaisau auga fekepakoꞌania laoma. ");
INSERT INTO mek_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Oi emu isapu ke emu akaikiꞌa fou lau lopeniiau auga isa lapeniiꞌi, ega koa Oi lau fou agaꞌomo amia koa iꞌopoga, isa isafa agaꞌomo fekemia laoma. ");
INSERT INTO mek_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ke lau isa aloꞌiai faagu, ke Oi lau alouai foagu. Ke iifa gome isa moafi kaiguguꞌi agaꞌomo kegamia, ega koa Oi lau loulaisau auga agofaꞌa papiauꞌi fekelogo. Ke Oi lau aniu loani koa iꞌopoga, isa isafa aniꞌi ega loani oma auga isafa agofaꞌa papiauꞌi fekelogo laoma. ");
INSERT INTO mek_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Amau, agofaꞌa aegama koa kai lau aniu loani kainai, emu isapu ke emu akaikiꞌa fou lopeniiau. Ke pau lau anina laani papiau Oi lopeniau auꞌi, lau eꞌu aguagu afugai fekeagu, ega koa eꞌu isapu ke eꞌu akaikiꞌa fou lopeniau auga fekeisa laoma. ");
INSERT INTO mek_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Amau, Alo Opai Aumu, agofaꞌa papiauꞌi Oi akelogonio mo ganinagai lau Oi lalogonio, ke Oi lau loulaisau auga lau eꞌu imoi kelogo. ");
INSERT INTO mek_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Lau Oi kaisau auga isa lapalogoniꞌi ke alapalogoniꞌi afaefuafua ega koa Oi alomu koꞌagai lau aniu loani auga laoga maina isa aloꞌiai feka, ke lau ifou isafa isa aloꞌiai faagu laoma.” ");
INSERT INTO mek_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesu ega emegamega oma efua aisama, ega imoi fou egaꞌina afuga kepuaꞌafuga laloa aka Kidron keoma auga afugai feisai kepea pagai. Ke kelao apiegai aisama uma agaꞌo egae keisa ke egaꞌina uma alogai kekoko. ");
INSERT INTO mek_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Pau Judas, Iesu eꞌafaꞌafalaina auga egaꞌina afuga elogo, gome kina maꞌo Iesu ega imoi fou egae kelaꞌafou. ");
INSERT INTO mek_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ega puo Judas ke Faliseo auꞌi fou ifani auꞌi maꞌo, ke sakedote lopiaꞌi keulaiꞌi auꞌi isaꞌi eꞌafeiniꞌi kemai. Ke isa ikui, lanepa, ke pipaini amuꞌi fou keafiiꞌi kelao egaꞌina afugai. ");
INSERT INTO mek_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ega aisama Iesu kapaꞌina isa faagagai agemia auga maꞌoai elogo puo, elao egaꞌina papiauꞌi maꞌoai epaꞌani peniꞌi einaka, “Oi kaisau okapuga?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ke isa keinaka, “Iesu Nasareta auga akapuga,” keoma. Ke Iesu einaka, “Lau inamoꞌeu,” eoma. (Egaꞌina alogai Judas Iesu eꞌafaꞌafalaina auga isafa isa fou egae keapa.) ");
INSERT INTO mek_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ke Iesu eifa einaka, “Lau inamoꞌeu,” eoma aisama keapakua keꞌualai aꞌisaai. ");
INSERT INTO mek_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ke Iesu isa epaꞌani peniꞌi pugu einaka, “Oi kaisau okapuga?” eoma. Isa keinaka, “Iesu Nasareta auga akapuga,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ke Iesu einaka, “Lau lapainimi lau inamoꞌeu. Oi lau okapuniau koa aisama, iꞌina auꞌi amopuaꞌafuniꞌi kegalao,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Iina koa emia ega koa isa ifo iifa iina eifa oma auga koꞌa femia kainai: “Oi lau papiau lopeniau auꞌi agaꞌo alapagea.” ");
INSERT INTO mek_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Egaꞌina alogai Saimon Peto keoma auga ifani aꞌifaga egegai eka auga efuaua, sakedote lopia faꞌaga ega pinauga auga agaꞌo aina kaina kaina efoua. Pinauga auga egaꞌina aka Malkus. ");
INSERT INTO mek_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kai Iesu Peto eifa kapula penia einaka, “Oi emu ifani aꞌifaga afugai mofaukamue! Oi loopolaga lau Amau, fakiekie eoma auga kaputina falainu ma looma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Egae kai Roma ifani auꞌi maꞌo, ke ifani auꞌi 1000 eꞌimaꞌi lopiaga, ke Iudea papiauꞌi keꞌimaꞌi auꞌi fou Iesu keafiia kegopeisa. ");
INSERT INTO mek_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Egae kai keafiia Anas eega kelaoai kakaua. Anas auga Kaiafas egaꞌina inipogai sakedote lopia faꞌa emia auga gafa. ");
INSERT INTO mek_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiafas egaꞌina Iudea papiauꞌi magogoꞌi eauniia einaka, au agaꞌomo papiau maꞌoai fauꞌiai agemae auga felo eoma auga. ");
INSERT INTO mek_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Iesu keafiia kelaoaina alogai, Saimon Peto keoma auga imoi agaꞌo fou Iesu muninai mo kelao. Ke sakedote lopia faꞌa auga egaꞌina imoina auniꞌi kelogoniꞌi puo isa Iesu fou keapafou sakedote lopia faꞌa afugai kekoko. ");
INSERT INTO mek_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Kai Peto auga egaꞌina afuga paꞌafina afegai eapa isa eꞌimaisa. Iesu ega imoi egaꞌina sakedote lopia faꞌa fou kelogoniꞌi auga emue emai ifiao egae paꞌafi akegai eapa epinauga auga epainia elogo kai Peto epakoko. ");
INSERT INTO mek_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ega aisama ifiao paꞌafi akegai eapa auga Peto epaꞌani penia einaka, “Iifa gome oi egaꞌina auga ega imoi agaꞌo laaꞌi ma?” eoma. Ke Peto einaka, “Laaꞌi, lau isa ega imoi agaꞌo laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ke afu ekekeꞌa alogaina puo sakedote lopia faꞌa ega pinauga auꞌi ke papiau keꞌimaꞌi auꞌi fou lo kepaaga kai keapa lofe egagaiꞌi. Ke Peto isafa isa fou egae keapa lo egagaisa. ");
INSERT INTO mek_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Egaꞌina alogai sakedote lopia faꞌa Iesu ega pamalele ke ega imoi fou paꞌaniꞌi epaꞌani. ");
INSERT INTO mek_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ega aisama Iesu einaka, “Lau laꞌafouai papiau agoꞌiai laniniꞌani ofakae mo. Ke aufa kina oi emi laꞌafou afuꞌiai, ke Deo ega eꞌai Iudea papiauꞌi maꞌoai kemai kelaꞌafou agoꞌiai lapamalele. Ke kapa agaꞌo ogefakeai alaifania. ");
INSERT INTO mek_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kai kapa puo lopaꞌani peniau? Lau ainau kelogo auꞌi mopaꞌani peniꞌi. Moisa! Isa lau kapaꞌina laifania auga kelogo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iesu ega eifa oma aisama, Iudea papiauꞌi keꞌimaꞌi auꞌi agaꞌo egae eapa auga Iesu epoaisa kai einaka, “Isa sakedote lopia faꞌa kai ala koa ega lopaini oma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ke Iesu einaka, “Lau iifa agaꞌo laifa apalania koa aisama, egaꞌina fouga moifania. Kai lau iifa koꞌa laifa koa aisama, kapa puo lau lopoaisau?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ke Anas Iesu epaꞌani penia afegai, ima igope auga ekaega kai eulaisa sakedote lopia faꞌa Kaiafas eega elao. ");
INSERT INTO mek_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Egaꞌina alogai Saimon Peto keoma auga lo eegai eapa egagaisa alogai, egae fou keapa auꞌi isa kepainia keinaka, “Iifa gome, oi egaꞌina auga ega imoi agaꞌo laaꞌi ma?” keoma. Ke Peto epuniai einaka, “Laaꞌi, lau isa ega imoi agaꞌo laaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ega aisama sakedote lopia faꞌa ega pinauga auga agaꞌo Peto aina efoua auga aaga akina auga Peto epainia einaka, “Oi egaꞌina auga fou uma alogai oapa alaisami ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kai Peto epuniai pugu. Ega aisama fiakoa mo oꞌolo eagaga. ");
INSERT INTO mek_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Iesu Kaiafas agogai iifa epakaisa afegai, amagai ipauma keafiia Roma kafanaga ega eꞌa kelaoaina. Kai isa eꞌi kagakaga kainai aloꞌi aiofugai Pasover miamia foꞌamaga fekeania keoma puo, kafana ega eꞌai akekoko. ");
INSERT INTO mek_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ega puo Pilato emai isa eeꞌiai kai epaꞌani peniꞌi einaka, “Oi iꞌina auga kapaꞌina apala ekapaisa puo iifaga fopakaisa ooma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ke isa keinaka, “Isa painao auga laaꞌi koa aisama, lai isa oi imamuai falapaaua,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ke Pilato einaka, “Oi ifomi amoafia ke isa kapaꞌina apala ekapaisa auga, ifomi emi iifa Moses epenimi auga kainai afa amopenia,” eoma. Ega aisama Iudea papiauꞌi iifa kepamue keinaka, “Lai aufalao agaꞌo fapamaea auga isapuga eemaisai laaꞌi,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ega koa emia auga, Iesu ifo ala agemae oma eoma auga iifaga, koꞌa mo femia kainai ega emia oma. ");
INSERT INTO mek_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ke Pilato emue elao ega eꞌai Iesu eifaga kai epaꞌani penia einaka, “Oi Iudea auꞌi eꞌi kin ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ega aisama Iesu paꞌaniai isa ega iifa epamue einaka, “Egaꞌina iifaga oi ifomu opolamuai emai loifania, o papiau isaꞌi lau fou maamuai keifania ma puo loifania?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ke Pilato einaka, “Oi loopolaga lau Iudea au ma looma? Oi ifomu emu papiau ke sakedote lopiaꞌi fou oi lau imauai kepaauiso. Oi kapaꞌina lokapaisa?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ke Iesu einaka, “Lau eꞌu agofaꞌa auga iꞌina agofaꞌa alogai laaꞌi. Lau eꞌu agofaꞌa inae gamia koa aisama, eꞌu pinauga auꞌi fekemai fauai fekepipaini puo, Iudea papiauꞌi lau keafiiau auꞌi fekepaapakipoꞌi fakeafiau. Kai lau eꞌu agofaꞌa auga afu iꞌoinagai ekae,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ega puo Pilato einaka, “Ega koa aisama oi kin ma?” eoma. Ke Iesu einaka, “Oi lau kin looma auga egamoꞌe loifania. Iifa gome, egaꞌina kainai lau lamauni, ke egaꞌina kainai lau lamai iꞌina agofaꞌagai ega koa Deo ega iifa koꞌa auga faifafoua laoma. Ke papiau maꞌoai Deo ega iifa koꞌa agugai keagu auꞌi, lau ainau kelogo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Iesu ega eifa oma aisama, Pilato epaꞌani einaka, “Kapaꞌina auga iifa koꞌa?” eoma. Ke egaꞌina paꞌanina epaꞌani afegai, epealai Iudea papiauꞌi eeꞌi elao pugu epainiꞌi einaka, “Lau isa ega kelele afa agaꞌo fapenia koa auga alakapulaisa. ");
INSERT INTO mek_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kai oi emi kagakaga kainai aufa inipoai Pasover miamiagai lau tipula auga agaꞌo lapapapealaisa. Ega puo oi anina oani lau oi Iudea aumi emi kin mapapealaisa ma ooma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kai isa maꞌoai keagaga pugu keinaka, “Laaꞌi, isa laaꞌi kai Barabas anina aani,” keoma. Barabas auga painao auga apala ");
INSERT INTO mek_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Egaꞌina afegai Pilato ega ifani auꞌi epainiꞌi Iesu keafiia kelaoaina kegapukia. ");
INSERT INTO mek_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ke ifani auꞌi egaꞌina aꞌifu keafipoꞌe kin kaniaꞌiai kraon keogeoge auga koa kepamia Iesu kaniagai keogeisa. Egae kai kepaꞌaua Roma ifani lopiaꞌi auꞌi mo afeꞌi tiapuga umuga eaea keiꞌiuka auga tiapuga kepaiꞌiuka. ");
INSERT INTO mek_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ke kelao eegai kai keifa keinaka, “Iudea auꞌi eꞌi kin, amaau afagaina,” keoma. Egaꞌina keifania ke meꞌe kepoaisa. ");
INSERT INTO mek_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ke Pilato epealai emai pugu kai Iudea papiauꞌi epainiꞌi einaka, “Lau isa kelele agaꞌo ekapaisa, ke afa fapenia koa auga alakapulaisa. Ega puo lapapealaisa oi eemi lamaiseina amoisa laoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ke aꞌifu keafipoꞌe kraon koa kepamia Iesu kaniagai keoge auga eka ke afe tiapuga umuga eaea kepaiꞌiuka auga fou faagagai kekaega kai epealai emai aisama, Pilato Iudea papiauꞌi egae keapa auꞌi epainiꞌi einaka, “Au inamoꞌe amoisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sakedote lopiaꞌi ke Iudea papiauꞌi keꞌimaꞌi auꞌi Iesu keisa aisama keagaga keinaka, “Kolotiai moauꞌuꞌua! Kolotiai moauꞌuꞌua!” keoma. Kai Pilato einaka, “Lau isa ega kelele agaꞌo ekapaisa, ke afa fapenia koa auga alakapulaisa puo oi isa amoafia kolotiai amoauꞌuꞌua,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Kai Iudea papiauꞌi iifa kepamue keinaka, “Lai Moses ega iifa epeniimai eemaisai ekae. Ke egaꞌina iifaga kainai isa femae, gome isa ifo eifaga Deo Gauga eoma,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato papiau ega keifa oma ainaꞌi elogonia aisama emaniꞌi alogaina. ");
INSERT INTO mek_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ega puo ega eꞌa alogai ekoko pugu. Egae kai Iesu epaꞌani penia einaka, “Oi afu kapagai lomai?” eoma. Kai Iesu iifa agaꞌo aepamue. ");
INSERT INTO mek_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ega puo Pilato Iesu epainia pugu einaka, “Oi lau eꞌu iifa afa afolopamue ma? Oi fapapealaiso o kolotiai fapamaeiso auga isapuga lau eeuai ekaega auga aloisa ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ega aisama Iesu einaka, “Deo oi isapu epeniio puo oi lau loꞌimaisau. Ega puo papiau kapa lau oi imamuai epaauiso auga ega laomai apala akaikiꞌa ipauma auga alogai gamuga ageopo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilato Iesu ega eifa oma aina elogonia aisama, keaga agaꞌo ekapunia Iesu gapapealaisa eoma. Kai Iudea papiauꞌi keagaga paisa keinaka, “Oi iꞌina auga alopapealaisa agelao koa aisama, oi Sisa ekefaꞌa laaꞌi. Kaisau ifo eifaga kin eoma auga Sisa ega ou auga,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato papiau ega keifa oma ainaꞌi elogonia aisama, Iesu epapealaisa emai afegai, ke isa ifo auga iifa ipakainai papiau eꞌi laomai felo, o apala afa kepeniꞌi auga afugai eagu. Ke egaꞌina afuga auga kepo akaikiꞌaꞌiai aguau afuga kekapaisa puo kepafaala ‘Kepo Afuga’ keoma. Ke egaꞌina afuga Hibru malaꞌiai keifaga Kabata keoma. ");
INSERT INTO mek_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Egaꞌina kapaꞌi auga fafoko Pasover miamia agemia, ke pau atiafa koa iꞌopoga auga egaꞌina kapaꞌi kemia. Ke Pilato Iudea auꞌi epainiꞌi einaka, “Oi emi kin inamoꞌe amoisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Kai isa keagaga pugu keinaka, “Moafia molaoaina kolotiai moauꞌuꞌua,” keoma. Ke Pilato epaꞌani einaka, “Oi anina oani lau oi emi kin kolotiai maauꞌuꞌua ma ooma?” eoma. Kai sakedote lopiaꞌi iifa kepamue keinaka, “Lai emai kin iꞌoina agaꞌo laaꞌi kai Sisa mo ifogamo,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ega puo Pilato fuagai isa imaꞌiai epaaua, kolotiai kegaauꞌuꞌua eoma. Pilato Iesu isa imaꞌiai epaaua puo, ifani auꞌi kelao Iesu keafiia kelaoaina. ");
INSERT INTO mek_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ke koloti keafiia Iesu kepeniia, ke isa ifo ega koloti epuaisa elao afu aka ‘Kania Uniaga’ keoma auga afugai. Egaꞌina afuga Hibru malagai auga Kolkota keoma. ");
INSERT INTO mek_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Egae Iesu ke au auniꞌi fou kolotiai keauꞌuꞌuꞌi, agaꞌo kainai ke agaꞌo lafaninai ke isa auga ipuainagai emia. ");
INSERT INTO mek_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ke Pilato malele agaꞌo epapua umania mo kolotiai Iesu kania laagai keauꞌuꞌua. Egaꞌina malelega iina eifa oma: ");
INSERT INTO mek_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Iudea papiauꞌi maꞌo egaꞌina malelega keakae keisa kekuapinia, gome Iesu kolotiai keauꞌuꞌua afuga auga Ierusaleme taonina eegai mo. Egaꞌina malelega auga Hibru, Latin, ke Grik malaꞌiai kepapua. ");
INSERT INTO mek_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kai Iudea papiauꞌi eꞌi sakedote lopiaꞌi egaꞌina malelega keisa aisama, Pilato keloꞌu penia keinaka, “Iudea Auꞌi Eꞌi Kin folopapua kai, ‘Iꞌina auga eifa lau Iudea auꞌi eꞌi kin’ eoma auga mopapua,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kai Pilato einaka, “Lau kapaꞌina lapapua auga, lapapua efua,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ke ifani auꞌi Iesu kolotiai keauꞌuꞌua aisama, afe tiapuga auga keafiia keꞌiꞌinia pani kepamia kai, epoꞌiai agaꞌo agaꞌo keafiia. Ke ega tiapu afe tiapuga eegai auga isafa keafiia. Iꞌina tiapuga auga falapa ipauma tiapu agaꞌo fou akekaifoua. Kai papa tiapuga auga eka mo. ");
INSERT INTO mek_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ke ifani auꞌi egaꞌina tiapuga keisa aisama, ifoꞌi mo epoꞌiai keifa keinaka, “Iꞌina tiapuga falaꞌiꞌina kai, egeai amaꞌopo kaisau ageafia auga amaisa,” keoma. Egaꞌina emia ega koa Deo ega iifa pukagai, Deo ega iifa iina kepapua oma auga koꞌa mo emia. “Lau afeu tiapuga isa epoꞌiai keꞌeaisa kai egeai keꞌopoisa kaisau ageafia auga kegaisa,” keoma. Ega puo ifani auꞌi iina kekapa oma Iesu afe tiapuga keafiia. ");
INSERT INTO mek_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ke Iesu ina Maria, ke Iesu akina, ke Kleopas akafa aka Maria, ke Maria Makdalena fou egae Iesu ega koloti eegai keapa. ");
INSERT INTO mek_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ke Iesu isa ina, ke ega imoi anina eani alogaina auga fou egae keapa eisaꞌi aisama, ina epainia einaka, “Moisa! Papie, iꞌina oi gaumu,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ke imoi egaꞌina auga epainia einaka, “Moisa! Iꞌina oi inamu,” eoma. Ke egaꞌina kina afegai, Iesu ega imoi egaꞌina auga ina Maria elaoaina auniꞌi isa ega eꞌai keagu. ");
INSERT INTO mek_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ke Iesu kolotiai eꞌafaega kai, isa kapa maꞌoai fekapaꞌi eoma auga ekapaiꞌi efua, ega koa Deo ega iifa pukagai isa fouga kepapua auꞌi maꞌoai koꞌaꞌi mo kemia auga elogo puo eifa einaka, “Aisou ekupu,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Egaꞌina alogai oga agaꞌo alogai fino epiꞌigu auga ake epogu egae kainagai mo eagu. Ega puo ifani auꞌi tiapu agaꞌo finoai kekafufuinia, ke hisop keoma auga agagai kegopeisa kai, kekaaua Iesu fifinagai keogeisa gainu keoma. ");
INSERT INTO mek_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ke Iesu fino einu afegai, eifa einaka, “Mo efua,” eoma. Ke kania eogekipo emae. ");
INSERT INTO mek_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ke Iesu kolotiai keauꞌuꞌua kina auga, Iudea papiauꞌi pinauga maꞌoai kepafuaꞌi auga kina. Ke agegani auga Iudea papiauꞌi Deo keau afagaina kina kai, egaꞌina kina auga Pasover miamia kina puogai, kina akaikiꞌa ipauma agaꞌo. Ke Iudea papiauꞌi au auꞌi oiso kolotiai keꞌafa auꞌi imaauꞌi Deo keau afagaina kinagai egae kolotiai fekeꞌafa auga anina akeani. Ega puo Pilato kepainia ifeꞌi kegaauponiꞌi kegamae kai imaauꞌi fekeafiopuꞌi keoma. ");
INSERT INTO mek_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ega puo ifani auꞌi kemai au agaꞌo Iesu fou kolotiai keauuꞌuꞌi auꞌi auga agaꞌo ife keaupo kakauꞌi. Ke kelao agaꞌo isafa ife keauponiꞌi. ");
INSERT INTO mek_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kai kemai Iesu eegai aisama emae efua keisa puo, ife akeauponiꞌi. ");
INSERT INTO mek_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kai ifani auga agaꞌo ega iso eafiia Iesu mape efau kanina. Ega aisama fiakoa mo Iesu mapegai ifa fei fou kelolo. ");
INSERT INTO mek_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ke au agaꞌo kapaꞌina emia eisa auga eifafoua, ega koa oi isa fopakoꞌania eoma. Isa kapaꞌina eifania auga koꞌa, ke elogo koꞌaꞌi mo eifaniꞌi. ");
INSERT INTO mek_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Iꞌina kapaꞌi kemia auga Deo ega iifa pukagai kapaꞌina kepapuaꞌi auꞌi koꞌaꞌi mo kemia: “Isa uniaga agaꞌomo mo ganinagai afakeaupoga,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ke Deo ega iifa pukagai afu iꞌoina agaꞌogai isafa iina kepapua oma: “Papiau akeakae mape kefau kanina auga afuga akeisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Egaꞌina afegai Arimatea taonina auga aka Iosepa elao Pilato egoinia Iesu imaauga gaafia eoma. Isa isafa Iesu epakoꞌania muninai epea kai Iudea papiauꞌi emaniꞌiainiꞌi puo, ogefakeai mo Iesu muninai elao emai. Ke Pilato elogo puo isa elao Iesu imaauga eafiia. ");
INSERT INTO mek_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ke isa elao alogai Nikodemus, gapiai elao Iesu eisa auga fou kelao. Kelao aisama, Nikodemus mulamula fogaꞌi feloꞌi akaꞌi myrrh ke aloes keoma auga fou eafiiꞌi elao. Mulamula egaꞌina eꞌi meau auga 34 kilo. ");
INSERT INTO mek_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Isa Iesu imaauga keafiia aisama, auniꞌi faaga mulamula kepakuma kai, tiapu manipina aka linen keoma auga tiapugai kemokaisa. Iꞌina auga Iudea papiauꞌi eꞌi kagakagai mae auꞌi ega keomaꞌi kai laai keogeꞌi. ");
INSERT INTO mek_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ke Iesu kolotiai keauꞌuꞌua afugai uma agaꞌo eka. Ke egaꞌina uma alogai la mamaga akepapapinaugania auga eka. ");
INSERT INTO mek_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kai egaꞌina kina auga Iudea papiauꞌi pinauga maꞌoai kepafuaꞌi kina ke la egaꞌina kainagai puo, Iesu imaauga egaꞌina laagai keogeisa. ");
INSERT INTO mek_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Egani iifi kina amagai ipauma kina aeꞌagau koa kai, Maria Makdalena la elao. Ke elao laai aisama, kepo akaikiꞌa la ake kepae apua auga eelai eisa. ");
INSERT INTO mek_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ega puo epiau elao Saimon Peto keoma auga, ke Iesu ega imoi iꞌoina agaꞌo Iesu anina eani alogaina auga auniꞌi epainiꞌi einaka, “Lopia laai keafilaisa kai kapai keogeisa auga alalogo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ega puo Peto ke imoi egaꞌina fou kekailai la kelao. ");
INSERT INTO mek_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Auniꞌi kepiau kelao kai imoi egaꞌina Peto epiauꞌegaina laai epealai kaukau. ");
INSERT INTO mek_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ke isa aiso mo la alogai eokoko maaga elao Iesu kemoka tiapuꞌi keka eisaꞌi kai, la alogai aekoko. ");
INSERT INTO mek_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ke Saimon Peto keoma auga isa muninai emai aisama la alogai ekoko. Isa Iesu kemoka tiapuga egae keka eisaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ke tiapu Iesu kania kemoka auga isafa afugai mo eka eisa. Kai egaꞌina tiapuga auga ifo eofeisa meꞌegai eka, ke imaauga kemoka tiapuga auga iꞌoinagai eka eisa. ");
INSERT INTO mek_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ega aisama imoi eufai laai epealai auga isafa, Iesu eka laaga alogai ekoko. Ke isa eisa ke kapaꞌina kemia auꞌi maꞌoai epakoꞌaniꞌi. ");
INSERT INTO mek_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kai Deo ega iifa pukagai eifa Iesu maeai femaunimue eoma auga iifaga kapaꞌina eifania auga oko akelogo paisa. ");
INSERT INTO mek_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ke imoi egaꞌina auniꞌi kemue afuꞌi kelao. ");
INSERT INTO mek_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kai Maria Makdalena la afegai eapa eapepe. Ke maisapepega mo aiso la alogai eokoko. ");
INSERT INTO mek_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ega aisama agelo auniꞌi tiapu keloꞌi keiꞌiukaꞌi auꞌi Iesu imaauga eka afugai, agaꞌo kania eka kaina ke agaꞌo ife eka kaina keagu eisaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ke agelo isa kepaꞌani penia keinaka, “Papie, kapa puo loapepe?” keoma. Ke isa einaka, “Lau eꞌu Lopia keafiia kai kapai keogeisa auga alalogo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Maria egaꞌina eifania afegai eꞌafoaipini aisama, Iesu egae eapa eisa. Kai eisa aisama isa Iesu auga aelogo. ");
INSERT INTO mek_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ke Iesu eifa einaka, “Papie, kapa puo loapepe? Oi kaisau lokapuga?” eoma. Ke Maria eopolaga Iesu auga au la alogai epinauga auga eoma puo epainia einaka, “Au akaikiꞌa aumu, oi isa imaauga loafiia lolaoaina koa, kapai loogeisa auga maauai moifania ega koa malao maafia laoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Kai Iesu isa eifaga einaka, “Maria,” eoma. Ega aisama Maria Iesu eaipenia kai Hibru malagai eifa einaka, “Raboni!” eoma. Ke eega elao gaafi opogaina eoma. (Raboni iꞌa malaꞌaisai auga Pamalele Aumu.) ");
INSERT INTO mek_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kai Iesu isa epainia einaka, “Lau Amau eega alalao koa puo foloafi opogainiau. Kai molao lau eꞌu imoi auꞌi fopainiꞌi foinaka, ‘Lau lamue Amau ke oi Amami eega lalao, ke lau eꞌu Deo ke oi emi Deo eega lalao fooma,’” eoma. ");
INSERT INTO mek_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ega puo Maria Makdalena Iesu ega imoi auꞌi eeꞌi elao, ke isa Lopia eisa auga maaꞌiai fouga eifania. Ke Lopia isa maagai kapaꞌina eifania auga isafa Iesu ega imoi auꞌi maaꞌiai eifania. ");
INSERT INTO mek_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ke iifi kina egapigapi alogai, Iesu ega imoi Iudea papiauꞌi kemaniꞌiainiꞌi puo, eꞌa paꞌafiꞌi kekupuniꞌi kai alogai kekaigugu keagu. Egaꞌina alogai Iesu emai agoꞌiai eapafoki epainiꞌi einaka, “Gagao eemiai gaka,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ke egaꞌina eifania afegai, ima ife ikoko afuga, ke mape iso afuga fou epakinaꞌi. Ke Iesu ega imoi Lopia keisa aisama, aloꞌi egama alogaina. ");
INSERT INTO mek_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ega aisama Iesu eifa pugu einaka, “Gagao eemiai gaka! Lau Amau eulaisau koa iꞌopoga, oi isafa laulaimi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Egaꞌina eifania afegai, alo mapuga isapuga eipilaisa epeniiꞌi kai, epainiꞌi einaka, “Deo ega Spiritu amoafia alomiai gaagu. ");
INSERT INTO mek_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Oi papiau laomai apalaꞌi kekapaiꞌi auꞌi agoꞌagegeainiꞌi koa aisama, Deo isafa isa eꞌi apala ageꞌagegeainiꞌi. Kai isa laomai apalaꞌi kekapaiꞌi auꞌi afoloꞌagegeainiꞌi koa aisama, Deo isafa isa eꞌi apala afaeꞌagegeainiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Iesu ega imoi maꞌoai eapakina peniꞌi alogai, apostolo auꞌi 12 auꞌi epoꞌiai agaꞌo aka Tomas kafela keoma auga maaga eꞌafu. ");
INSERT INTO mek_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ega puo Iesu ega imoi Lopia Iesu keisa auga fouga isa maagai keifania aisama, isa einaka, “Lau ikoko afuga isa imagai afalaisa, ke imauai ikoko afuga afalaafi opogaina, ke imau isa mapegai afalapakoko koa aisama, kapaꞌina oifania auga afalapakoꞌania,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ke iifi agaꞌo elao afegai, Iesu ega imoi paꞌafi kekupuniꞌi eꞌa alogai keagu pugu aisama, Tomas isafa egae fou keagu. Ke paꞌafi kekupuniꞌi mo ganinagai Iesu emai epoꞌiai eapafoki ke epainiꞌi einaka, “Gagao eemiai gaka!” eoma. ");
INSERT INTO mek_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Egae kai Tomas epainia einaka, “Imamu kekeꞌe imauai mooge kai ikoko afuga moisa. Ke imamu mokalaisa mapeuai iso afugai mokaauka. Ke oi opomu gua folopamia kai mopakoꞌania,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ega aisama Tomas Iesu epainia einaka, “Eꞌu Lopia, eꞌu Deo,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kai Iesu isa epainia einaka, “Oi lau loisau puo lopakoꞌaniau kai kaisau lau aeisau kai epakoꞌaniau auga Deo eegai kapa feloꞌi eafiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesu ega imoi agoꞌiai mirakulo gouꞌi iꞌoiꞌi maꞌo ekapaiꞌi kai, iꞌina pukagai ipapuaꞌi aemia. ");
INSERT INTO mek_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kai oi Iesu Mesaia ke Deo Gauga auga fopakoꞌania, ke egaꞌina pakoꞌagai agu pagai maunina foafia eoma kainai iꞌina kapaꞌi ipapuaꞌi emia. ");
INSERT INTO mek_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Egaꞌina afegai Iesu Tiberias aꞌuga, keifaga Kalilea aꞌuga keoma auga aꞌugai ega apostolo eapakina peniꞌi pugu. Isa eapakina peniꞌi aisama iina ekapa oma: ");
INSERT INTO mek_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Peto keoma auga, Tomas kafela keoma auga, Natanael Kalilea agogai Kana taoninai emai auga, Sebedi gauga auniꞌi, ke Iesu ega imoi auniꞌi isafa fou egae keagu. ");
INSERT INTO mek_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ke egae keaguega kai, Saimon Peto keoma auga Iesu ega imoi fou egae keagu auꞌi epainiꞌi einaka, “Lau lapealai inoino lalao,” eoma. Ke isa keinaka, “Lai oi fou agafai,” keoma. Ega puo isa kelao gaagai keaguka inoino kelao kai egaꞌina gapinai maꞌa agaꞌo akeafia. ");
INSERT INTO mek_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ke egani amagai ipauma aisama, Iesu foeai eapa kai, ega imoi isa keisa ganinagai, akelogo isa Iesu. ");
INSERT INTO mek_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ega aisama Iesu isa eifaniꞌi einaka, “Ekefaꞌau, maꞌa agaꞌo alopaoa ma?” eoma. Ke isa iifa kepamue keinaka, “Laaꞌi,” keoma. ");
INSERT INTO mek_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ke Iesu epainiꞌi pugu einaka, “Emi feꞌi gaaga kaina kainai amopiulaisa ke maꞌa maꞌo agopaoaꞌi,” eoma. Ke Iesu eifania koa kekapaisa aisama, maꞌa ealogai alogaina feꞌiai keofa puo feꞌi gaagai kegalaꞌaua keoma aekainiꞌi. ");
INSERT INTO mek_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ega aisama Iesu imoi anina eani alogaina auga Peto epainia einaka, “Egaꞌina Lopia,” eoma. Ke Saimon Peto keoma auga imoi egaꞌina eifa, “Egaꞌina Lopia,” eoma aina elogonia aisama, afe tiapuga eiꞌiulaisa puo, fiakoa mo eafiia eapunia kai aꞌuai egopolai Iesu eega foe elao. ");
INSERT INTO mek_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kai imoi isaꞌi auga gaagai keaguka kai, isa muninai maꞌa feꞌiai keofa auga kelaꞌaisa foe kelaoaina, gome isa kelao foe kainagai epoꞌi 100 mita koa iꞌopoga. ");
INSERT INTO mek_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ke isa kelao foeai keofau aisama, lo eiꞌa keisa. Ke egaꞌina logai maꞌa keka keaga, ke palafa isafa egae keka keisaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ega aisama Iesu isa epainiꞌi einaka, “Maꞌa isa pau mo opaoaꞌi auꞌi amoafiꞌi omaiseiniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ke Saimon Peto keoma auga gaagai eꞌagaukae kai feꞌi foeai elaꞌaua. Ke egaꞌina feꞌinai maꞌa akaikiꞌaꞌi maꞌoai mo 153 keofa mo ganinagai feꞌi aemou. ");
INSERT INTO mek_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ke Iesu ega imoi maꞌoai epainiꞌi einaka, “Omai amagai foꞌamaga amoania,” eoma. Ke imoi maꞌoai kelogo isa Lopia Iesu puo, kai agaꞌo alo kapulagai isa aepaꞌani penia aeinaka, “Oi kaisau?” aeoma. ");
INSERT INTO mek_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ke imoi kemai aisama, Iesu emai palafa eafiia epeniiꞌi, ke maꞌa isafa eafiia epeniiꞌi keaniia. ");
INSERT INTO mek_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iesu maeai emaunimue afegai, iꞌina auga isa ega imoi eapakina peniꞌi oiso epamia auga. ");
INSERT INTO mek_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ke Iesu ega imoi keaniani afegai, Iesu Saimon Peto keoma auga epaꞌani penia einaka, “Saimon Ioane gauga aumu, imoi maꞌoai lau aniu keani kai oi auga alomu koꞌa ipaumagai lau aniu loani ma?” eoma. Ke Saimon Peto keoma auga einaka, “E, Lopia lau alou koꞌagai oi animu laani auga oi lologo,” eoma. Ega aisama Iesu isa epainia einaka, “Lau eꞌu sipi foꞌimaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ke Iesu epamue pugu einaka, “Saimon Ioane gauga aumu, oi alomu koꞌa ipaumagai lau aniu loani ma?” eoma. Ke Peto einaka, “E, Lopia, lau alou koꞌagai oi animu laani auga oi lologo,” eoma. Ke Iesu eifa einaka, “Lau eꞌu sipi foꞌimaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ke Iesu Peto ipainina oiso epamia einaka, “Saimon Ioane gauga aumu, oi alomu koꞌa ipaumagai lau aniu loani ma?” eoma. Ega aisama Peto alo emafu, gome Iesu isa iina epaꞌani peni oma oiso epamia einaka, “Oi alomu koꞌa ipaumagai lau aniu loani ma?” eoma. Ega puo Peto Iesu epainia einaka, “Lopia, oi kapa maꞌoai lologo puo lau oi animu laani auga isafa lologo,” eoma. Ke Iesu einaka, “Lau eꞌu sipi foꞌimaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Iifa gome maamuai laifania. Oi aguꞌamuai aisama, oi ifomu emu tiapu loafiiꞌi loiꞌiukaꞌi kai lokailai ala molao looma auga afuga lolao. Kai aloapao aisama, imamu alokalaisa aufalao agaꞌo oi emu tiapu agepaiꞌiukaiso, ke agepapeaiso afu agaꞌo anina aloani auga afuga agelaoainio,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iesu iina eifa oma auga Peto ala agemae oma, ke ega maeai Deo isapu akaikiꞌa auga, ke au akaikiꞌa agepamia auga fouga eifania. Ke egaꞌina eifania afegai, Iesu Peto epainia einaka, “Muniuai mopea,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ke Peto eꞌafoaipini aisama, Iesu ega imoi anina eani alogaina auga isa muniꞌiai epea eisa. Imoi egaꞌina auga Iesu ega imoi fou keaniani alogai, elao Iesu faagagai eꞌafeau kai epainia, “Lopia kai, ageꞌafaꞌafalainio?” eoma auga. ");
INSERT INTO mek_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peto isa eisa aisama Iesu epaꞌani penia einaka, “Lopia, isa auga ala agaoma?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ega aisama Iesu einaka, “Lau anina alaani isa faemae kai feagu mo felao lau famue famai pugu alaoma koa aisama, oi kapaꞌina afokapa? Oi auga muniuai mo mopea,” eoma. ");
INSERT INTO mek_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Iesu ega eifa oma kainai, Iesu ega imoi ke Iesu muninai kepea auꞌi epoꞌiai niniꞌani epea, Iesu ega imoi anina eani alogaina auga afaemae keoma. Kai Iesu isa afaemae auga iifaga aeifania kai, iina eifa oma, “Lau anina alaani isa faemae kai feagu mo felao lau famue famai pugu alaoma koa aisama, oi kapaꞌina afokapa?” eoma. ");
INSERT INTO mek_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Iesu ega imoi egaꞌina auga iꞌina kapaꞌi kemia auꞌi koꞌa mo eifafouꞌi ke fouꞌi pukai epapuaꞌi. Ke iꞌa alogo isa kapaꞌina eifaniꞌi auꞌi maꞌoai koꞌaꞌi. ");
INSERT INTO mek_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ke Iesu kapa maꞌo iꞌoiꞌi isafa ekapaiꞌi. Kai egaꞌina kapaꞌi agaꞌo agaꞌo pukai ipapuaꞌi gamia koa aisama, lau laopolaga iꞌina pukaꞌi agofaꞌa ake fepogu puo fekeka faekaina. ");
INSERT INTO mek_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilo, lau Luka Iesu fouga puka agaꞌogai lapapua kakaua lapeniio. Egaꞌina pukagai Iesu ala eꞌina oma ega pinauga ekapaisa, ke epamalele mo auꞌi fouꞌi egae lapapuaꞌi. ");
INSERT INTO mek_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Isa apostolo ekinaniꞌi auꞌi Deo ega Spiritu ega isapuai eifa kapula peniꞌi afegai, Deo isa ufai eꞌagauaina. ");
INSERT INTO mek_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kai Iesu ufai aeꞌagau koa kai, papiau Iesu keauniia, faaga kepakiekie, ke keaupugua. Kai kina oiso aisama maeai emaunimue. Ke kina ouꞌaga pani alogai ifo apostolo ekinaniꞌi auꞌi eapakina peniꞌi fou keniniꞌani. Ke Deo ega agofaꞌa fouga maaꞌiai eifania aefuafua. Ke isa iifa koꞌa emaunimue auga ega apostolo epakinaꞌi. Ega puo apostolo aloꞌi koꞌagai Iesu emaunimue auga kepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Egaꞌina kinaꞌi agaꞌogai, Iesu ega imoi fou kelaꞌafou keaniani alogai epaini kapulaniꞌi einaka, “Ierusaleme taonina folopuaꞌafuga kai Deo eifa koꞌania ega Spiritu agepenimi eoma fouga maamiai laifania auga kina foꞌima. ");
INSERT INTO mek_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Gome Ioane papiau feisai baptismo epeniiꞌi kai, oi auga kina epo afaemaefa, Deo ega Spirituai baptismo agoafia,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ega puo Iesu apostolo fou kekaigugu pugu aisama, kepaꞌani penia keinaka, “Lopia, ufainagai lai emai papiau keꞌimaꞌi lopiaꞌi koa iꞌopoꞌi, oi pau lai aloꞌimaimai alopapea feloimai ifomai emai ago agaꞌima pugu ma?” keoma. ");
INSERT INTO mek_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ke Iesu einaka, “Lau Amau ifo ega logo isapugai gaika agemia, o kina maaga kapagai agemia auga epakoꞌania efua. Ega puo oi fologo apuga laaꞌi. ");
INSERT INTO mek_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kai pau oi kapaꞌina fologo auga alaifania. Deo ega Spiritu oi ageake penimi aisama, isapu kapula ipauma alomiai ageka, Ierusaleme taonina, Iudea, ke Samaria agoꞌi maꞌoai, ke agofaꞌa maꞌoai agolao, papiau maaꞌiai lau fou koꞌa auga agoifafoua,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pau Iesu iꞌina iifaꞌi eifaniꞌi efua aisama, apostolo agoꞌiai Deo, Iesu ufai eꞌagauaina. Ke keisaisa kai apuapu Iesu eumi apua akeisa pugu. ");
INSERT INTO mek_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Apostolo aloꞌi koꞌagai maaꞌi eakae Iesu eꞌagaukae afuga keisaisa kai, fiakoa mo au auniꞌi tiapu keloꞌi keiꞌiukaꞌi eeꞌiai keapafoki. ");
INSERT INTO mek_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ke keifa keinaka, “Kalilea aumi, kapa puo egae oapae ufa oakae penia? Deo Iesu eemiai eafiꞌaua ufai eꞌagauaina pau oisa. Iesu egaꞌina Deo ufai eꞌagauaina oisa auga, muni ega koa iꞌopoga mo agemue agemai pugu,” keoma ke keapagea. Iꞌina kapaꞌi maꞌoai Olifa ikugai kemia. ");
INSERT INTO mek_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Egae kai apostolo Olifa ikuga kepuaꞌafuga kemue Ierusaleme taonina kelao. Egaꞌina afuga Ierusaleme taonina fou epoꞌi auga maefa laaꞌi, Kilomita agaꞌomo koa iꞌopoga. ");
INSERT INTO mek_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ke kelao Ierusaleme taoninai aisama, eꞌa agaꞌo auꞌoniai, papiau alogai keaguagu afugai kekoko. Peto, Ioane, James, ke Andrea; Filip, ke Tomas; Batolomeo, ke Mateo; James Alfeus gauga, Saimon Silot ikupuga auga, ke Judas Iesu eꞌafaꞌafalaina auga laaꞌi kai, au iꞌoina agaꞌo aka James keoma auga gauga fou ega kelao. ");
INSERT INTO mek_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Iꞌina auꞌi, Iesu ina Maria, ke Iesu akina maꞌoai, ke papie isaꞌi fou kekaigugu, aloꞌi opoꞌi agaꞌomogai kemegamega aefuafua. ");
INSERT INTO mek_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Egaꞌina kinaꞌiai Iesu kepakoꞌania papiauꞌi, auꞌi 120 koa iꞌopoga epoꞌiai, Peto eꞌuegekae eapa. ");
INSERT INTO mek_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Egae kai eifa einaka, “Aau akiu, ufainagai Deo ega Spiritu, Davide akegai eniniꞌani, Judas fouga eifania auga pau koꞌa emia. Isa papiau Iesu keafiia auꞌi eisaoniꞌi kelao Iesu keafiia. ");
INSERT INTO mek_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kai Iesu isa ekinaga pinauga epeniia, iꞌa fou pinauga agaꞌomo akapaisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Kai Judas laomai apala Iesu eegai ekapaisa auga afa monina eafiia. Ke egaꞌina moninai ago agaꞌo eꞌafaisa. Egae ifo epamaea auai ekopa, eꞌualai kania iina eake, inaega efoupea fofouga eaꞌalai emae. ");
INSERT INTO mek_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ierusaleme taoninai keagu papiauꞌi maꞌoai iꞌina fouga kelogo. Ega puo isa ifoꞌi malaꞌiai ago egaꞌina aka Akeldama keoma. Akeldama iꞌa malaꞌaisai auga ‘Ifa ago.’) ");
INSERT INTO mek_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Peto eniniꞌani paisa einaka, “Judas faagagai kapaꞌina agemia auga fouga, ufainagai Sam pukagai Davide epapua auga alogai iina epapua oma: “‘Isa afuga gamaini, ke kai agaꞌo isa afugai faeagu.’ Ke iꞌina isafa epapua: “‘Isa afuga aufalao agaꞌo feafia fepinauga,’” eoma. ");
INSERT INTO mek_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Ega puo anina aani, au agaꞌo Judas afuga feafia aoma. Egaꞌina auga iꞌa aꞌa Lopia Iesu fou aagu alogai, isa isafa iꞌa fou alao amaimai, ke iꞌa fou apeapea auga femia. ");
INSERT INTO mek_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ke isa Ioane Baptista eꞌina einogo eisa, ke elao mo Deo, Iesu ufai eꞌagauaina auga isafa eisa auga femia. Iꞌa egaꞌina auga fakinaga apostolo femia fou, Iesu ega maunimue fouga koꞌa auga faifafoua,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ke isa au agaꞌo aka Iosepa kai keifaga Basabas keoma, ke aka agaꞌo Justus keoma auga, ke au agaꞌo aka Matias auniꞌi keafi opoꞌi. ");
INSERT INTO mek_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Egae kai kemegamega keinaka, “Lopia, oi kapa maꞌoai lologo afeꞌai ke papiau guaꞌi alo isafa loisa. Judas apostolo pinauga epuaꞌafuga emae. Ke mae afuga oi lopenia auga afuga elao efua. Ega puo iꞌina auꞌi auniꞌi epoꞌiai agaꞌo lokinaga auga mopakinaimai Judas afuga feafia, oi emu apostolo femia aoma,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Egae kai Iosepa ke Matias auniꞌi akaꞌi kepapua, Iudea eꞌi kagakagai papiau kekinaniꞌi auga laoga maina kekapaisa. Ke Matias aka keafilaisa apostolo emia. Egaꞌina afegai egae kekaigugu kemegamega auꞌi maꞌoai kepakoꞌania, isa apostolo ipauma kepamia. Ega puo apostolo auꞌi 11 keagu kai isa kekinaga aisama, auꞌi maꞌoai 12 emia pugu. ");
INSERT INTO mek_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ke Iudea papiauꞌi eꞌi miamia kina agaꞌo aka Pentikost emai aisama, apostolo ke pakoꞌa papiauꞌi maꞌoai kemai aloꞌi agaꞌomogai afu agaꞌomogai kekaigugu. ");
INSERT INTO mek_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Egae keaguega kai, fiakoa mo ufai ameku kapula ipauma koa iꞌopoga aꞌo eake emai keagu eꞌa fofouga alo epapogua. ");
INSERT INTO mek_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ke kekiakae aisama, lo mala koa iꞌopoga eake peniꞌi, ekani okaoka isa agaꞌo agaꞌo kaniaꞌi laagai eaguau keisa. ");
INSERT INTO mek_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ke isa maꞌoai Deo ega Spiritu aloꞌi epogu, ke Deo ega Spiritu isa maaꞌiai kapaꞌina eifania auga koa iꞌopoga mo, keꞌina mala iꞌoina iꞌoinai keniniꞌani. ");
INSERT INTO mek_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Egaꞌina alogai agofaꞌa fofouga alogai Iudea papiauꞌi kapai kapai keagu aloꞌi koꞌagai Deo keau afagaina auꞌi egaꞌina miamia puogai kemai, Ierusaleme taoninai kelaꞌafou keagu. ");
INSERT INTO mek_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Egaꞌina papiauꞌi iꞌina aꞌoaꞌo kelogonia aisama, laꞌafouai kemai. Ke kapaꞌina fekekapa auga akelogo, gome apostolo ke pakoꞌa papiauꞌi mala iꞌoina iꞌoinagai keniniꞌani, ke egae kelaꞌafou auꞌi maꞌoai aua malaꞌiai isa keniniꞌani ainaꞌi kelogonia. ");
INSERT INTO mek_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ke isa kekauai alogaina, keopofua ke iina keifa oma keinaka, “Amoisaꞌi! Papiau iina keniniꞌani oma auꞌi, Kalilea auꞌi laaꞌi ma? Iifa gome isa Kalilea auꞌi! ");
INSERT INTO mek_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kai ala koa iꞌa agaꞌo agaꞌo mala amauniaina auga malagai keniniꞌani ainaꞌi alogo. ");
INSERT INTO mek_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ke iꞌa afu iꞌoina iꞌoina papiauꞌa. Iꞌa isaꞌa Patia, isaꞌa Media, isaꞌa Elamia, isaꞌa Mesopotamia, isaꞌa Iudea, isaꞌa Kapadosia, isaꞌa Pontos, ke isaꞌa Asia agoꞌi papiauꞌa. ");
INSERT INTO mek_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ke isaꞌa auga Frikia, Pamfilia, Isipto ke Libia, Sairene taonina eegai agoꞌiai amai. Ke isaꞌa Roma auꞌa laaꞌi kai, Romai aagu auꞌa. ");
INSERT INTO mek_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(Egaꞌina auꞌi isaꞌi Iudea papiauꞌi, ke isaꞌi Iudea papiauꞌi laaꞌi kai Iudea eꞌi kagakaga kainai kepea auꞌi.) Ke isaꞌa Krete keleipuaga ke Arabia ago papiauꞌa isafa. Kai ala koa, Deo kapa akaikiꞌaꞌi ekapaiꞌi auꞌi, malaꞌaisai keifaniꞌi ainaꞌi alogo ekaina,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ke isa kekauai alogaina keopofua, kapaꞌina fekekapa auga akelogo, ke ifoꞌi mo agaꞌo agaꞌo kepaꞌani peniꞌi keinaka, “Ei! Inaꞌina kapaꞌina emia kai oko alalogo?” keoma. ");
INSERT INTO mek_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kai epoꞌiai papiau isaꞌi pakoꞌa papiauꞌi kepaꞌauꞌi keaꞌalainiꞌi keifa keinaka, “Iꞌina papiauꞌi fino mamaga maꞌo keinu, kekafoꞌo,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kai laꞌafou alogai Peto apostolo auꞌi 11 fou kaiꞌialao keꞌue keapa kai eifa akaikiꞌa einaka, “Iudea aumi, ke Ierusaleme taoninai oagu aumi maꞌoai ainami opaaua, kapaꞌina emia auga fouga alaifania ainau fologo. ");
INSERT INTO mek_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Gome oi oopolaga lai ainuinu ooma kai, pau mo kina maaga 9 oꞌclock amagai megamega kina, ke iꞌina kina maagai fainuinu fakafoꞌo koa auga afaekaina. ");
INSERT INTO mek_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kai kapaꞌina pau egama auga, profeta Joel ufainagai Deo ega iifa Iudea papiauꞌi maaꞌiai eifania, ke Deo ega iifa pukagai iina epapua oma: ");
INSERT INTO mek_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“‘Deo eifa, ‘Muni kina fuaꞌiai, Lau eꞌu Spiritu papiau maꞌoai eeꞌiai alafakeopua. Ke gaumi maguaeꞌi, ke papieꞌi fou profeta koa iꞌopoꞌi akemia, Lau eꞌu iifa papiau maaꞌiai akeifafoua. Oi emi au aguꞌaꞌi Deo ega paikifa kapaꞌi laulauai akeisaꞌi, ke au apaoꞌi Deo ega paikifa kapaꞌi nipiai akenipiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Lau kepakoꞌaniau papiauꞌi, au ke papie fou, eꞌu Spiritu eeꞌiai alafakeopua, profeta koa iꞌopoꞌi akemia, eꞌu iifa papiau maaꞌiai akeifafoua. ");
INSERT INTO mek_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Ke Lau eꞌu mirakulo aꞌuoniai, ufa guagai alakapa, kina agepaꞌumina, gafa maaga ifa koa agepito. Ke aagoai agofaꞌai eꞌu isapu gouga auga, ifa, lo, ke aku akaikiꞌaꞌi ipaumaꞌi alakapaꞌi akeisaꞌi. Egae kai fuagai Lopia ega kina akaikiꞌa auga maiꞌisapuga ke maieaeagai agemai. ");
INSERT INTO mek_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Egaꞌina kina aemai koa kai, papiau maꞌoai Lau akau Lopia akeifaga auꞌi kaniaꞌi ageisagamau,’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israel papiaumi, ainami amopaaua iꞌina iifaꞌi aꞌoꞌi amologo. Iesu Nasareta auga papiau aumauni ipauma. Kai oi epomiai, Iesu Deo ega isapu epapinauga, mirakulo ke kapa akaikiꞌaꞌi maꞌo ekapaiꞌi. Oi ifomi isafa iꞌina kapaꞌi epomiai kegama oisaꞌi ologo felo alogaina. Deo iina koa ekapaiꞌi, Iesu koꞌa Isa eegai emai auga epakinaiꞌa. ");
INSERT INTO mek_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Deo muni kapaꞌina agemia elogo afeꞌai mo auga, ifo ega logoai Iesu oi imamiai fepaaua eoma. Ega kainai oi Deo oko akelogo auꞌi ologoainiꞌi, isa kolotiai keauꞌuꞌua. Ega koa okapaisa oi Iesu oaupugua. ");
INSERT INTO mek_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Iesu emae kai Deo Gauga kainai, isa femae umamo koa afaekaina. Ega puo Deo Iesu maeai epamaunimue. Egaꞌina auga aufalao agaꞌo papiau agaꞌo tipulai ekiekie kai epapealaisa auga koa iꞌopoga. ");
INSERT INTO mek_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Gome Davide ufainagai Iesu fouga iina epapua oma kai pau emai emia. “‘Lau Lopia aufa kina agouai laisa aefuafua. Gome Isa lau kaiu kaina feagu fepalagainiau, ega koa guau faekae falakaagai eoma. ");
INSERT INTO mek_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ega puo lau alou egama alogaina, eꞌu niniꞌaniai kapa maꞌoai laifaniꞌi auꞌi, oi laau afagainio. Ke alamae lalogo ganinagai, eꞌu afiaꞌama akaikiꞌa oi eemuai laoge. ");
INSERT INTO mek_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Gome oi lau lalau afolopuaꞌafuga, afu apala ipeli mae afuga afaelao. Ke emu pinauga ikapa auga, alo opaina auga isafa lopalagaina puo, imaauga agefoka afaekaina. ");
INSERT INTO mek_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Oi lau ala koa famaunimue pugu auga keagaga lopakinaisau. Ke kina maꞌoai oi agomuai alou alopagama alogaina.’ ");
INSERT INTO mek_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Aau akiu, iꞌa ufuꞌa apaꞌa, Davide fouga maamiai alaifa kapulania. Isa ufainagai emae, papiau isa kapai keogeisa auga laaga iꞌa maꞌoai aisa alogo efua. Egaꞌina laaga pau iꞌa miaꞌaisai ekae. ");
INSERT INTO mek_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ega puo Davide egaꞌina iifaga eifania auga, isa ifo fouga aeifania. Kai isa profeta auga puo, Deo maagai kapaꞌina epakoꞌania eifania auga, elogo kaukau. Egaꞌina iifaga auga, isa okogai au agaꞌo agemai, isa koa iꞌopoga Lopia akaikiꞌa, Mesaia agemia auga fouga. ");
INSERT INTO mek_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Isa kapaꞌina agemia auga elogo kaukau puo, Mesaia maeai agemaunimue auga fouga iina eifa oma: ‘Deo Mesaia imaauga mae auꞌi afuꞌiai aepuaꞌafuga aefoka,’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Mesaia egaꞌina auga Iesu. Deo isa maeai epamaunimue auga, lai maꞌoai aisa, pau koꞌa mo aifafoua. ");
INSERT INTO mek_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ke Deo isa ufai eꞌagauaina kaina kainai epaagua. Egae kai isa epakoꞌania Ama, ega Spiritu agepenimai eoma auga, Ama eegai eafiia. Pau kapaꞌina aꞌo ologo, ke oisa auga, Iesu, Spiritu egaꞌina eemaisai efakeopua. ");
INSERT INTO mek_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Gome Deo Davide imaauga ufai aeꞌagauaina mo ganinagai, isa Deo ega iifa iina eifa oma einaka: “‘Lopia lau eꞌu Lopia epainia einaka: “Kaiuai moagu felaolao, Lau oi emu ou auꞌi ifemu guagai alaogeꞌi alogafapiꞌi,’” eoma. ");
INSERT INTO mek_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Ega puo Israel papiaumi maꞌoai, iifa gome fologo, oi Iesu egaꞌina kolotiai oauꞌuꞌua kai, Deo isa epamaunimue, Lopia ke Mesaia epamia,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Papiau iꞌina iifaga aꞌo kelogonia aisama, guaꞌi ekae kemaniꞌi kepikaisai alogaina. Ke Peto ke apostolo maꞌoai fou kepaꞌani peniꞌi keinaka, “Aamai akimai kapaꞌina fakapa ooma?” keoma. ");
INSERT INTO mek_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ke Peto einaka, “Emi laomai apalaꞌi amoumakalainiꞌi. Ke Iesu amopakoꞌania, ke akagai agaꞌo agaꞌo baptismo amoafia. Ega koa Deo oi emi laomai apalaꞌi ageꞌagegeainiꞌi, ke ega ipeni Spirituga agepenimi. ");
INSERT INTO mek_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Gome Deo ifo epakoꞌania eifa, oi ke okomiai akemai auꞌi, ke agofaꞌa agomaai auꞌi maꞌoai isafa, iꞌa aꞌa Lopia Deo papiau kapaꞌi ageifaniꞌi auꞌi ega Spiritu agepeniꞌi eoma.” ");
INSERT INTO mek_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ke Peto egaꞌina mo aeifania kai niniꞌani iꞌoiꞌi iꞌoiꞌiai eifaniꞌi papiau ainaꞌi epalogo. Ke magogo kapula epeniiꞌi einaka, “Pau papiau kapaꞌi Deo aina akeafia auꞌi, afa apala agepeniꞌi. Ega puo iꞌina papiauꞌi eeꞌiai opealai, ifomi kaniami amoagamauga,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Papiau Peto iꞌina iifaꞌi eifaniꞌi aꞌoꞌi kelogonia aisama, maꞌo iifa gome keoma puo Iesu kepakoꞌania. Ke kepakoꞌania auꞌi mo baptismo keafiia. Egaꞌina kinagai papiau auꞌi 3000 koa iꞌopoga, pakoꞌa papiauꞌi eꞌi gopuai kekoko. ");
INSERT INTO mek_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ke pakoꞌa papiauꞌi fofougai, kina maꞌoai aloꞌi koꞌagai apostolo eꞌi pamalele kaiꞌiai kepea aefuafua. Ke isa aloꞌi agaꞌomogai kekaigugu Deo keau afagaina. Ke Iesu ega mae keopolaga, laꞌafouai fou kaiꞌialao keaniani ke kemegamega. ");
INSERT INTO mek_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Deo apostolo faagaꞌiai mirakulo, ke isapu akaikiꞌa gouꞌi maꞌo ekapaiꞌi. Ega puo papiau maꞌoai kekauai alogai ke kemaniꞌi. ");
INSERT INTO mek_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ke pakoꞌa papiauꞌi maꞌoai kekaigugu, aloꞌi agaꞌomo emia eꞌi amu agaꞌo agaꞌo epoꞌiai kepipeni. ");
INSERT INTO mek_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ke kina isaꞌiai, pakoꞌa papiauꞌi isaꞌi eꞌi ago, amu fou keꞌafaꞌafalainiꞌi. Egaꞌina moniꞌi keafiiꞌi papiau agaꞌo agaꞌo pika anina keani auga iꞌopoga mo kefakeisa kepeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ke kina maꞌoai Deo ega eꞌa alogai maꞌoai aloꞌi agaꞌomogai kekaigugu. Ke kina isaꞌiai aufa eꞌi gopu eꞌaꞌiai isafa kekaigugu. Egae Iesu ega mae keopolaga kemegamega, aloꞌi koꞌagai gafegafeai guaniai foꞌama agaꞌo agaꞌo kepipeni, ke aloꞌi egama alogaina. ");
INSERT INTO mek_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ke Deo keau afagaina. Ega koa kekapaisa aisama, Ierusaleme taoninai papiau keagu auꞌi maꞌoai, pakoꞌa papiauꞌi eꞌi laomaisai agaꞌo agaꞌo aniꞌi keani alogaina auga fouga keifania. Ke aufa kina Deo papiau kaniaꞌi eagamauga pakoꞌa papiauꞌi eꞌi gopu alogai epakokoꞌi. ");
INSERT INTO mek_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kina agaꞌogai gapigapi, Iudea papiauꞌi eꞌi megamega kina maaga 3 oꞌclock aisama, Peto, Ioane auniꞌi Deo ega eꞌa alogai kegamegamega keoma kelao. ");
INSERT INTO mek_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Egaꞌina kinaꞌiai papiau isaꞌi kina maꞌoai au agaꞌo mauniai ife emelo auga kepuaisa kelao Deo ega eꞌa paꞌafina kepafaala ‘Paꞌafi Felo Ipauma’ keoma auga akegai kepaagua. Isa egaꞌina afugai eaguagu, papiau megamega keoma kemai auꞌi eeꞌiai moni egoinia. ");
INSERT INTO mek_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ke isa Peto, Ioane auniꞌi paꞌafi akegai kegakoko keoma alogai eisaꞌi aisama, egoiniꞌi moni kegapenia eoma. ");
INSERT INTO mek_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ke Peto Ioane auniꞌi keapakipo au maaga alo ipauma keisa kai Peto eifa einaka, “Lai moisamai!” eoma. ");
INSERT INTO mek_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ega puo au egaꞌina eakae isa maaꞌi eisa ke epamia kapa agaꞌo akepenia eoma. ");
INSERT INTO mek_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kai Peto eifa einaka, “Lai eemaisai silifa o gold laaꞌi kai kapaꞌina eemaisai ekae auga agapenio. Nasareta auga Iesu Kristo aka isapugai, mofelo moꞌue mopea,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Peto egaꞌina eifania afegai, melo auga ima kainai eafi epaꞌuegenia. Ega aisama fiakoa mo, ife auniꞌi fofouga keagauka keꞌopai. ");
INSERT INTO mek_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ke isa egopoꞌuege eapa epea aisoge. Ke isa Peto Ioane auniꞌi fou Deo ega eꞌa alogai kekoko aisama, epea egopokae Deo eau afagaina epealaina. ");
INSERT INTO mek_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Papiau egae keapa auꞌi maꞌoai melo auga epea Deo eau afagaina auga keisa. ");
INSERT INTO mek_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ega aisama kelogo kefiaisakoa mo egaꞌina auga paꞌafi kepafaala ‘Felo Ipauma’ keoma auga akegai eagu moni egoigoina auga. Ke isa faagagai kapaꞌina emia auga keisa puo, kekauai alogaina keopofua. ");
INSERT INTO mek_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Egaꞌina auga Peto Ioane auniꞌi faagaꞌiai eafiau fou Deo ega eꞌai peapea afuga aka Solomon ega Aꞌama keoma auga afugai keapa. Ke egae keapa papiauꞌi isa keisa aisama, kekauai alogaina kepiau eeꞌi kelao. ");
INSERT INTO mek_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peto papiau isa eeꞌi kemai eisaꞌi aisama epainiꞌi einaka, “Israel aumi, oi iꞌina auga efelo oisa auga folokauai foloopofua. Ke lai maamai alo ipauma foloisa. Oi oopolaga lai ifomai emai isapuai akapaisa ooma, o Deo maagai au felomai kainai iꞌina auga apafelo epea ooma ma? Laaꞌi ipauma! ");
INSERT INTO mek_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kai Abraham, Aisak, Iakobo, ke ufuꞌa apaꞌa eꞌi Deo ega pinauga auga Iesu Kristo epamaunimue, isapu epeniia Lopia epamia. Kai oi egaꞌina Lopiaga papiau apalaꞌi imaꞌiai opaaua, kegaaupugua ooma. Ke Pilato alafai gaoma isa gapapealaisa eoma mo ganinagai, oi Pilato agogai isa opuniaiaina. ");
INSERT INTO mek_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ega koa okapaisa, oi Iesu Deo ega Pinauga Auga Deo maagai alo elolofa auga, ke alo opai auga opuniaiaina. Ke Pilato ogoinia auau auga gapapealaisa oi eemi gafai ooma. ");
INSERT INTO mek_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ke mauni gome Lopiaga oaupugua. Kai Deo isa maeai epamaunimue. Lai Iesu egaꞌina emaunimue auga ifomai maamaisai aisa aumai, fouga pau koꞌa mo aifafoua. ");
INSERT INTO mek_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ke lai Iesu egaꞌina apakoꞌania kainai, aka isapugai melo auga ife eagauka eꞌopai. Koꞌa ipauma lai Iesu apakoꞌania ke aka isapugai au iꞌina felo ipauma emia, pau oi agomiai eapae oisa. ");
INSERT INTO mek_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ke aau akiu, pau lau lalogo, oi Iesu kaisau auga alologo felo kainai ega koa okapaisa. Ke emi lopia isafa oi koa iꞌopomi akelogo felo kainai kekapaisa. ");
INSERT INTO mek_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kai egaꞌina okapaisa auga, ufainagai Deo ega profeta maꞌoai epalogoniꞌi akeꞌiai eifafou kakaua eifa, Isa Gauga Mesaia agekiekie agemae eoma. Pau egaꞌina iifaga emai ekoꞌa. ");
INSERT INTO mek_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ega puo oi emi laomai apalaꞌi amoumakalainiꞌi Lopia amoaipenia. Ega koa Lopia eegai Deo ega Spiritu oi fepakapulanimi auga kina agemai aisama, Deo oi emi laomai apalaꞌi maꞌoai laaꞌi fepamiaꞌi laoma. ");
INSERT INTO mek_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ke ufainagai oi faumiai Mesaia ekinaga auga, Iesu Kristo feulaisa oi eemi fefai laoma. ");
INSERT INTO mek_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Iesu egaꞌina auga ufai feagu mo felao, muni Deo kapa maꞌoai mamaꞌi agepagamaꞌi kinagai kai agemai. Egaꞌina iifaga auga ufainagai profeta Deo maagai aloꞌi elolofa auꞌi epakoꞌania epalogoniꞌi akeꞌiai eifafoua. ");
INSERT INTO mek_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Gome ufainagai Moses Iudea papiauꞌi maaꞌiai iina eifa oma einaka: ‘Iꞌa aꞌa Lopia Deo, oi aami akimi fou epomiai profeta agaꞌo lau koa iꞌopou ageulaisa. Ke profeta egaꞌina kapa maꞌoai maamiai ageifaniꞌi auꞌi aina fologo. ");
INSERT INTO mek_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ke kaisau isa aina afaeafia auga, Deo ega papiau epoꞌiai isa agepalifu afeꞌaina,’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Ke pau kapaꞌina emia auga, profeta Samuel eꞌina eifania, ke profeta maꞌo alogaina isa muninai kemai auꞌi isafa keifania. ");
INSERT INTO mek_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Oi egaꞌina profetaꞌi gauꞌi. Ke Deo ufainagai Abraham epainia einaka, “Oi okomuai muni akemai auꞌi fauꞌiai, Lau agofaꞌa fofouga papiauꞌi kapa feloꞌi alapeniꞌi,” eoma. Egaꞌina auga, Deo pakoꞌa kapula niniꞌanina isa eeꞌiai ekapaisa. Ke iꞌa ufuꞌa apaꞌa eeꞌiai isafa ega koa iꞌopoga ekapaisa. Ke oi isafa egaꞌina iifaga oafiia apumi opamia. ");
INSERT INTO mek_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Deo oi fepalagainimi emi laomai apalaꞌi foumakalainiꞌi auga anina eani alogaina. Ega puo ega pinauga auga Iesu maeai epamaunimue eemiai eulai kakaua. Ega koa kapa feloꞌi eemiai gakapaꞌi eoma. Ega kainai oi emi laomai apalaꞌi amoumakalainiꞌi Deo mo amoaipenia,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peto Ioane auniꞌi papiau maaꞌiai keniniꞌani laolao kai sakedote auꞌi, Deo ega eꞌa eꞌima lopiaga, ke Saduseo auꞌi fou isa eeꞌi kemai. ");
INSERT INTO mek_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Isa aloꞌi elifu, gome apostolo papiau maaꞌiai Iesu emae ke emaunimue auga fouga keifafoua. Ke Iesu emaunimue koa iꞌopoga, mae auꞌi isafa akemaunimue auga papiau kepamaleleniꞌi. ");
INSERT INTO mek_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Isa kemai Peto, Ioane auniꞌi keafiiꞌi, iifa fekepakaisa keoma. Kai tipula eꞌagai kefau apuꞌi, fegani kai iifa fekepakaisa keoma, gome egapi efua. ");
INSERT INTO mek_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Isa kepatipulaniꞌi mo ganinagai, papiau apostolo eꞌi iifa aꞌo kelogonia auꞌi maꞌo Iesu kepakoꞌania. Ke Iesu kepakoꞌania papiauꞌi epoꞌiai, au mo kepaauniꞌi auga, auꞌi maꞌoai mo 5000 koa iꞌopoga. ");
INSERT INTO mek_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Egani aisama, Iudea ago keꞌima lopiaꞌi, Iudea auꞌi akaikiꞌaꞌi, ke Moses ega iifa pamalelega auꞌi fofouga, Ierusaleme taoninai kekaigugu. ");
INSERT INTO mek_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Egaꞌina laꞌafouga alogai Anas sakedote lopia faꞌa, ega ikupu papiauꞌi maꞌo, ke sakedote auꞌi oiso, Kaiafas, Ioane, ke Aleksanda isafa kemai egae keagu. ");
INSERT INTO mek_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Egae kai Peto Ioane auniꞌi kemaiseiniꞌi laꞌafouai kepaapalaiꞌi aisama kepaꞌani peniꞌi keinaka, “Oi isapu kapagai o kaisau akagai iꞌina kapaꞌi okapaꞌi?” keoma. ");
INSERT INTO mek_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ega aisama Peto Deo ega Spiritu alo epogu ke eifa einaka, “Eꞌu lopia Iudea ago oꞌima aumi, ke au akaikiꞌami Israel papiauꞌi oꞌimaꞌi aumi! ");
INSERT INTO mek_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Pau kapa felo melo auga faagagai akapaisa, ke ala koa melo auga apafelo auga paꞌanina opaꞌani. ");
INSERT INTO mek_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Oi lai opaꞌani penimai koa aisama, oi maꞌoai ke Israel papiauꞌi maꞌoai iꞌina iifaga fologo. Iesu Kristo Nasareta auga oi kolotiai oauꞌuꞌua emae kai Deo isa maeai epamaunimue. Isa aka isapugai iꞌina auga felo emia efua pau agomiai eapae oisa. ");
INSERT INTO mek_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iesu fouga, Deo ega iifa pukagai iina kepapua oma: “‘Oi eꞌa ipaapa aumi kepo uuꞌuga oumakalaina auga, pau egaꞌina kepo eꞌa egaꞌinagai kiuga uuꞌuga kapula ipauma emia.’ Ega koa iꞌopoga, Iesu auga oi kepo oumakalaina auga koa iꞌopoga kai, Deo isa Au Akaikiꞌa epamia. ");
INSERT INTO mek_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Ke kai agaꞌo akagai papiau kaniaꞌi ageisagamau afaekaina. Gome Deo agofaꞌa alogai kaniaꞌa isagamauga isapuga kai agaꞌo aepenia. Kai Iesu mo aka isapugai kaniaꞌa ageagamauga agekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Laꞌafouai papiau maꞌoai, Peto Ioane auniꞌi akemaniꞌi keniniꞌani kapula alogaina keisa. Ke isa eꞌi niniꞌani aꞌo kelogonia auga au aageꞌi, malele ikifaga auꞌi laaꞌi. Ega aisama kekauai alogaina, paukai kelogo isa Iesu fou kelao kemaimai auga keopolaga. ");
INSERT INTO mek_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ke au felo emia auga Peto Ioane fou keapa keisaꞌi puo, iifa agaꞌo fekepamue auga aekainia. ");
INSERT INTO mek_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kai Peto Ioane auniꞌi iifa ipakaina afugai kepapealaiꞌi aisama, ifoꞌi mo epoꞌiai keniniꞌani. ");
INSERT INTO mek_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ke eꞌi niniꞌaniai keinaka, “Iꞌina auꞌi faagaꞌiai kapaꞌina agakapa? Gome Ierusaleme taoninai keagu papiauꞌi maꞌoai maaꞌi ipaumagai isa mirakulo kekapaisa keisa. Ke iꞌa agapuniai afaekaina. ");
INSERT INTO mek_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kai iꞌina kapa papiau epoꞌiai fefoufaꞌa, papiau mamaꞌi maꞌo fekelogo auga anina alaani. Ega puo amapamaniꞌiniꞌi kegaapakipo, pau agelao muni auga Iesu keoma auga aka fakeifania pugu,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Isa keniniꞌani efua aisama Peto Ioane auniꞌi keifaniꞌi kekoko kemai pugu. Ke kemai agoꞌiai keapa aisama, kepaini kapulaniꞌi Iesu akagai fakepamalele, ke fouga fakeifafoua pugu keoma. ");
INSERT INTO mek_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kai Peto Ioane auniꞌi iifa kepamue keinaka, “Oi ainami amaafia o Deo aina amaafia? Oi ifomi Deo maagai kapaꞌina felo auga amoopolaga. ");
INSERT INTO mek_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Gome lai kapaꞌina maamaisai aisa, ke aꞌo alogonia auga agaifania afalaapakipo,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ega puo kepamaniꞌi kakauꞌi koa iꞌopoga kai, pau auga kepamaniꞌi kapulaniꞌi, ke kepaini kapulaniꞌi mo pugu kai kepapealaiꞌi. Ke papiau fauꞌiai isa auniꞌi afa ala fekepeni omaꞌi auga keagaga agaꞌo akekapulaisa, gome papiau maꞌoai kapaꞌina emia keisa auꞌi Deo au akaikiꞌa kepamia. ");
INSERT INTO mek_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Gome au egaꞌina mirakuloai felo emia auga, inipoga 40 epagai. ");
INSERT INTO mek_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Peto Ioane auniꞌi kepealai aisama, ifoꞌi eꞌi papiau eeꞌi kelao. Egae kai sakedote lopiaꞌi, ke au akaikiꞌaꞌi fou kapaꞌina isa auniꞌi maaꞌiai keifania auga, eꞌi papiau maaꞌiai keifafoua. ");
INSERT INTO mek_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ega puo pakoꞌa papiauꞌi iꞌina iifaga aꞌo kelogonia aisama, maꞌoai aloꞌi agaꞌomogai ainaꞌi akaikiꞌagai Deo kemegamega penia keinaka, “Oi Lopia Akaikiꞌa Aumu! Ufa, aagoa, aꞌu fou lopagamaꞌi, ke aloꞌiai amu maꞌoai lopagama afeꞌainiꞌi aumu. ");
INSERT INTO mek_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ke oi emu Spirituai emu pinauga auga, lai ufumai apamai Davide lopalogo akegai eifa einaka, “‘Kapa puo Deo akelogonia papiauꞌi keꞌeꞌefa alogaina, ke kapa agaꞌo afakepagama kapaꞌi auꞌi keopola aageniꞌi mo? ");
INSERT INTO mek_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ke aagoa kiniꞌi afuꞌi keafiia keapa, ke ago keꞌimaꞌi auꞌi maꞌoai kekaigugu Lopia ke ega Mesaia fou kegapipaini keoma.’ ");
INSERT INTO mek_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Iifa egaꞌina koꞌa ipauma. Gome Herod, Pontio Pilato auniꞌi Iudea papiauꞌi laaꞌi auꞌi, ke Iudea papiauꞌi fou iꞌina taoninai kekaigugu oi emu pinauga auga Iesu alo elolofa, ke lokinaga Mesaia lopamia auga akekua kepaꞌaua. ");
INSERT INTO mek_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Isa ega kekapa oma, gome ufainagai oi emu isapuai ke logoai kapaꞌina lokapaisa efua fegama looma auga pau egama efua. ");
INSERT INTO mek_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ke Lopia, pau isa lai eemaisai kepamaniꞌi ke keafi apalanimai auꞌi moisaꞌi. Agoinio Oi emu pinauga aumai kapula mopenimai ke falamaniꞌi Oi emu iifa amaifa kapulania. ");
INSERT INTO mek_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ke imamu mokalaisa emu isapu mopenimai. Ega koa Oi emu pinauga auga maamuai alo elolofa auga Iesu akagai emu isapu gouga mirakuloai amakapa ke isafa papiauꞌi amapafeloꞌi aoma,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ke kemegamega efua aisama kekaigugu afuga epigugu, ke Deo ega Spiritu eake aloꞌi epapogua, ke aimaniꞌiꞌi mo Deo ega iifa keifafou kapulania. ");
INSERT INTO mek_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Pakoꞌa papiauꞌi maꞌoai opoꞌi aloꞌi agaꞌomo emia. Ke ifoꞌi epoꞌiai eꞌi amu kepipeni. Ke kai agaꞌo ega amu akekua aepaꞌaua aeifa isa apuga aeoma. ");
INSERT INTO mek_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ke apostolo isapu akaikiꞌagai, Lopia Iesu maeai emaunimue auga fouga keifafoua. Ke Deo ega gafegafe akaikiꞌa isa maꞌoai epeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ke epoꞌiai kai agaꞌo kapa agaꞌo eegai aeafiꞌafu. Gome kina isaꞌi ago ke eꞌa inagomeꞌi auꞌi eꞌi ago, eꞌa fou keꞌafaꞌafalainiꞌi, ke moniꞌi keafiiꞌi kemaiseiniꞌi. ");
INSERT INTO mek_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ke egaꞌina moniꞌi apostolo ifeꞌi foꞌinai keogeiꞌi. Egae kai isa kefakeisa papiau agaꞌo agaꞌo moni pika anina keani auga kepeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Au agaꞌo aka Iosepa, Lefi ikupuga auga apostolo keifaga Banabas keoma auga Saiprus keleipuagai emai. Banabas iꞌa malaꞌaisai auga magogo kapula ipenina auga gauga. ");
INSERT INTO mek_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Iꞌina auga ifo ega ago eꞌafaꞌafalaina. Ke egaꞌina monina eafiia emai apostolo ifeꞌi foꞌinai eogeisa. ");
INSERT INTO mek_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kai au agaꞌo aka Ananias akafa Safira auniꞌi eꞌi ago agaꞌo keꞌafaꞌafalaina monina keafiia. ");
INSERT INTO mek_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ke isa moni afa eafiapia auga akafa isafa elogo. Kai moni isa mo elaoaina apostolo ifeꞌi foꞌinai eogeisa. ");
INSERT INTO mek_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ega aisama Peto einaka, “Ananias, kapa puo Satani alomu epogu Deo ega Spiritu lofogeisa? Oi emu ago loꞌafaꞌafalaina, ke moni isa loafiapia kai iisa auga moni fofouga koa iꞌopoga lomaiseina. ");
INSERT INTO mek_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ago aloꞌafalaisa koa kai, oi ifomu apumu laaꞌi ma? Ke pau loꞌafalaisa aisama, egaꞌina monina faagagai kapaꞌina fokapa auga oi ifomu emu isapuai mo fokapa. Kai kapa puo oi alomuai egaꞌina kapa loopolaga. Oi papiau alofogeꞌi kai Deo lofogeisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias iꞌina iifaga aꞌo elogonia aisama, fiakoa mo eꞌualai emae. Ke papiau maꞌoai Ananias faagagai kapaꞌina emia aꞌo kelogonia auꞌi kemaniꞌi alogaina. ");
INSERT INTO mek_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Egae kai au aguꞌaꞌi isaꞌi keꞌue kelao Ananias imaauga kemokaisa keafiia la kelaoaina kefufunia. ");
INSERT INTO mek_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kina maaga oiso koa iꞌopoga afegai, Ananias akafa, Safira isafa ekoko emai. Isa akafa faagagai kapaꞌina emia auga oko aelogo. ");
INSERT INTO mek_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ke Peto isa epaꞌani penia einaka, “Oi moifa, Ananias aunimi ago oꞌafaꞌafalaina auga monina fofouga inamoꞌe ma?” eoma. Safira einaka, “E, fofouga egamoꞌe.” ");
INSERT INTO mek_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ega aisama Peto isa epainia einaka, “Ala koa iꞌopoga oi akafamu aunimi opakoꞌania, Lopia ega Spiritu oꞌopo ooma? Egaꞌina afa agoafia auga fologo kai alologo. Moisa! Oi akafamu kefufuga auꞌi kemai pau paꞌafi akegai keapae. Oi isafa akeafio akelaoainio,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ega aisama fiakoa mo Safira Peto ife foꞌinai eꞌualai emae. Ke au aguꞌaꞌi egaꞌina isa akafa kefufuga auꞌi kekoko kemai, Safira emae keisa. Ega puo isa isafa imaauga keafiia la kelaoaina akafa eegai kefufunia. ");
INSERT INTO mek_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Papiau maꞌoai ke Iesu kepakoꞌania papiauꞌi isafa Ananias Safira auniꞌi kepifoge kainai kemae auga fouga kelogo aisama, kemaniꞌi alogaina. ");
INSERT INTO mek_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apostolo papiau epoꞌiai mirakulo ke isapu gouꞌi maꞌo kekapaiꞌi. Ke pakoꞌa papiauꞌi maꞌoai aloꞌi opoꞌi agaꞌomo kepamia kemai Deo ega eꞌai peapea afuga aka Solomon ega Aꞌama keoma afugai kekaigugu. ");
INSERT INTO mek_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pakoꞌa laaꞌi papiauꞌi maꞌoai, pakoꞌa papiauꞌi eeꞌiai iifa feloꞌi keifaniꞌi. Kai kemaniꞌi puo kai agaꞌo pakoꞌa papiauꞌi eꞌi laꞌafou alogai aekoko. ");
INSERT INTO mek_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Egaꞌina emia mo ganinagai au ke papie maꞌo Lopia Iesu kepakoꞌania. Ke pakoꞌa papiauꞌi auꞌi maꞌo emia aefuafua. ");
INSERT INTO mek_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Papiau apostolo mirakulo maꞌo kekapaiꞌi auga keisa. Ega puo isafa auꞌi keagai ileai ke petiai fou kepakalaꞌi, Peto epea aisama feafi opogainiꞌi feloꞌi fekemia keoma. Ke kapaꞌi ageafi opogainiꞌi afaekaina auꞌi epoꞌiai isaꞌi Peto ogogai mo feloꞌi fekemia keoma. ");
INSERT INTO mek_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ke taoni maꞌo Ierusaleme taonina eegai taoniꞌi papiauꞌi isafa kekaigugu kelaꞌafou, ke isafa auꞌi ke tiapolo apalaꞌi aloꞌiai keagu kepalifuꞌi auꞌi, apostolo eeꞌi kemaiseiniꞌi maꞌoai kepafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kai sakedote lopia faꞌa ke ega Saduseo ikupuga auꞌi maꞌoai fou kepinauga auꞌi apostolo eeꞌiai kepikupa alogaina. ");
INSERT INTO mek_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ke apostolo keafiiꞌi laꞌafou tipulaga eꞌa alogai kepaaguꞌi. ");
INSERT INTO mek_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kai gapiai Deo ega agelo agaꞌo elao, tipula paꞌafiꞌi epaagalaiꞌi epapealaiꞌi kai, eifa einaka: ");
INSERT INTO mek_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Amolao Deo ega eꞌa alogai amoapa, Deo mauni mamaga, Iesu kepakoꞌania papiauꞌi agepeniꞌi auga iifaꞌi maꞌoai papiau maaꞌiai amoifafoua,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ke isa iꞌina iifaga aꞌo kelogonia aisama, egani amagai ipauma iꞌina iifaga kainai kelao Deo ega eꞌa alogai kekoko, kapaꞌina agelo eifania auga papiau kepamaleleniꞌi. Kai sakedote lopia faꞌa ega papiau fou kemai kansolo papiauꞌi ke Iudea papiauꞌi eꞌi au akaikiꞌaꞌi maꞌoai fou keifaniꞌi kekaigugu. Egae kai papiau isaꞌi keulaiꞌi tipula eꞌa kelao apostolo kegamaiseiniꞌi keoma. ");
INSERT INTO mek_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kai egaꞌina auꞌi kelao tipula afugai apostolo egae laaꞌi keisa aisama, kemue isa maaꞌiai keifafoua keinaka: ");
INSERT INTO mek_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Iifa gome, lai tipula paꞌafina ekupu, kai agaꞌo fekoko faekaina auga aisa. Ke imaꞌima auꞌi paꞌafi akegai keapa auꞌi isafa afu keꞌima felo. Kai paꞌafi apaagalaisa aisama, kai agaꞌo tipula eꞌa alogai alaisa,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Deo ega eꞌa iꞌima lopiaga ke sakedote lopiaꞌi fou iꞌina iifaga aꞌo kelogonia aisama, opoꞌi egea apostolo faagaꞌiai kapaꞌina egama auga akelogo, ke muni kapaꞌina agegama auga isafa akelogo. ");
INSERT INTO mek_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Egaꞌina keopopolaga kai au agaꞌo emai eifa einaka, “Amoisa, oi opatipulaniꞌi auꞌi Deo ega eꞌai keapae papiau kepamaleleniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ega aisama Deo ega eꞌa iꞌima lopiaga ega papiau isaꞌi fou kelao apostolo keafiiꞌi pugu. Kai kepapea feloꞌi kelaoainiꞌi iifa ipakaina afugai kepakokoꞌi. Gome papiau isa kepoai afekefoupuguꞌi auga maniꞌina kepaꞌaua. ");
INSERT INTO mek_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ke isa kemaiseiniꞌi aisama, iifa ipakaina auꞌi maꞌoai agoꞌiai kepaapalaiꞌi kai sakedote lopia faꞌa isa epainiꞌi einaka: ");
INSERT INTO mek_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Lai oi alapaini kapulanimi Iesu akagai folopamalele pugu alaoma ma? Amoisa! Oi Ierusaleme taoninai Iesu fouga oifafoua papiau maꞌoai kelogo. Ega koa okapa, alomi koꞌagai Iesu ifa efaka auga puo lai opapuoimai,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ega aisama Peto ke apostolo isa fou keinaka, “Lai Deo aina agaafi kakaua kai papiau aumauni ainaꞌi agaafia. ");
INSERT INTO mek_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ainami amopaaua! Oi Iesu kolotiai oauꞌuꞌua emae kai, iꞌa ufuꞌa apaꞌa eꞌi Deo isa maeai epamaunimue. ");
INSERT INTO mek_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Israel papiauꞌi eꞌi laomai apalaꞌi fekeumakalainiꞌi auga Deo anina eani alogaina. Egae kai Deo isa eꞌi laomai apala ageꞌagegeainiꞌi eoma. Ega puo Deo Iesu ufai eꞌagauaina kaina kainai epaagua, Lopia isapuga epeniia, ke kaniaꞌa isagamauga Lopiaga epamia. ");
INSERT INTO mek_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Lai iꞌina iifaga aꞌo alogonia, ke kapaꞌina emia maamaisai aisa puo koꞌa mo aifafoua. Ke kaisau Deo aina eafiia auga ega Spiritu epeniia. Ke Spiritu egaꞌina isafa, iꞌina iifaga koꞌa auga epalogoniꞌa,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Iifa ipakaina papiauꞌi iꞌina iifaga aꞌo kelogonia aisama, guaꞌi ekupu alogaina. Ega puo kepakoꞌania apostolo kegaaupuguiꞌi keoma. ");
INSERT INTO mek_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kai Faliseo auga agaꞌo aka Kamaliel, Moses ega iifa pamalelega auga, Iudea papiauꞌi maꞌoai aina kepakoꞌania, au akaikiꞌa kepamia auga, isa epoꞌiai eꞌue, iifa ipakaina auꞌi epainiꞌi, apostolo kegapapealaiꞌi eoma. ");
INSERT INTO mek_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Apostolo kepapealaiꞌi afegai aisama, isa iifa ipakaina papiauꞌi epainiꞌi einaka, “Israel papiaumi, iꞌina auꞌi faagaꞌiai kapaꞌina amokapa ooma auga foopola felo kai fokapa. ");
INSERT INTO mek_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Gome inipo pika koa kelao efua kai, kapaꞌina kemia auꞌi oi ologo felo. Au agaꞌo aka Teudas emai papiau epoꞌiai ifo au akaikiꞌa epamia. Ke papiau 400 koa iꞌopoga isa muninai kepea kai papiau isa keaupugua. Ega aisama aina keafia muninai kepea auꞌi kekani okaoka, ke pau egaꞌina ikupuga laaꞌi emia. ");
INSERT INTO mek_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Egaꞌina afegai census kinagai Kalilea auga aka Judas epifoge papiau isa muninai kepea. Kai papiau isa isafa keaupugua ke aina keafia muninai kepea auꞌi kekani okaoka, ega ikupu efua pau laaꞌi emia. ");
INSERT INTO mek_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ega puo pau kapaꞌina emia auga eegai ainami lapalogo. Au iꞌina amopuaꞌafuniꞌi! Gome isa kapaꞌina kekapa auga papiau aumauni eꞌi logoai, o eeꞌiai emai koa aisama laaꞌi agemia. ");
INSERT INTO mek_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kai isa Deo ega logoai eꞌi pinauga kekapa koa aisama, kapaꞌina kekapa auga agopaapakipoꞌi afaekaina. Gome oi isa agopaapakipoꞌi koa aisama, oi Deo fou agopipaini. ");
INSERT INTO mek_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Iifa ipakaina papiauꞌi maꞌoai Kamaliel kapaꞌina eifania auga felo keoma puo aina keafiia. Ke apostolo keifaniꞌi kekoko kemai, ke au isaꞌi kepainiꞌi apostolo kegapukiꞌi ke kepaini kapulaniꞌi keifa, Iesu aka fakeifania pugu keoma. Egae kai kepapealaiꞌi kelao. ");
INSERT INTO mek_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apostolo iifa ipakaina afuga kepuaꞌafuga aisama, Iesu isa fauꞌiai faaga kepakiekie koa iꞌopoga, isa isafa Iesu faugai faagaꞌi ekiekie auga keopolaga, Deo maagai felo mo keoma. Ega puo kegapukiꞌi auga akemeagai kai aloꞌi egama alogaina. ");
INSERT INTO mek_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ke aufa kina apostolo Deo ega eꞌa alogai, ke papiau eꞌi eꞌai kekoko iifa faunina Iesu Mesaia auga fouga papiau maaꞌiai keifafoua ke kepamalele aefuafua. ");
INSERT INTO mek_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Egaꞌina kinaꞌiai Iesu kepakoꞌania papiauꞌi auꞌi maꞌo emia elaoaina. Ega aisama Iudea papiauꞌi Grik malagai keniniꞌani auꞌi, ke Hibru mala ipaumagai keniniꞌani auꞌi, epoꞌiai akekua emia. Hibru mala papiauꞌi kina maꞌoai foꞌama kefakeisa aisama, Grik mala afuafuꞌi akeopolaniꞌi akepeniꞌi puo, Grik mala papiauꞌi keifa mugumugu. ");
INSERT INTO mek_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ega aisama apostolo 12 auꞌi isa muniꞌiai kepea auꞌi maꞌoai keifaniꞌi kemai kai kepainiꞌi keinaka, “Lai emai pinauga auga, Deo ega iifa aifafoua. Ke foꞌama ifake mo puogai, iꞌina pinauga agaoge meꞌe koa aisama, Deo maagai felo laaꞌi. ");
INSERT INTO mek_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ega puo aau akiu, au auꞌi imagea kuagai gua, oi ologo feloꞌi, Deo ega Spiritu aloꞌi ke ikifa aloꞌi epogu auꞌi fokinaniꞌi, isa foꞌama ifake pinauga agapeniꞌi. ");
INSERT INTO mek_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kai lai ifomai auga alomai opomai fofouga megamega ke Deo ega iifa faifafoua eegai faoge aoma,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Laꞌafou fofouga apostolo eꞌi opola aꞌo kelogonia aloꞌi egama. Ke isa Stefano pakoꞌa kapula auga, ke Deo ega Spiritu alo epogu auga kekinaga. Ke Filip, Prokoros, Nikanor, Timon, Parmenas, ke Nikolas, Antiok agogai emai, Iudea auga laaꞌi kai Iudea eꞌi kagakaga kainai epea auga fou kekinaniꞌi. ");
INSERT INTO mek_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Iꞌina auꞌi apostolo agoꞌiai kepaapalaiꞌi, ke apostolo imaꞌi isa kaniaꞌi laagai keogeaua kemegamega. ");
INSERT INTO mek_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ke Deo ega iifa afu maꞌoai epeaisa, ke Ierusaleme taoninai Iesu kepakoꞌania papiauꞌi auꞌi maꞌo emia aefua. Ke sakedote maꞌo isafa Deo ega iifa aꞌo kelogonia kepakoꞌania ke kainai kepea. ");
INSERT INTO mek_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Au auꞌi imagea kuagai gua epoꞌiai Stefano auga Deo ega gafegafe akaikiꞌa ke ega isapu alo epogu. Isa papiau maꞌo epoꞌiai mirakulo, isapu gouga akaikiꞌaꞌi ekapaiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kai kina agaꞌogai papiau isaꞌi, Iudea papiauꞌi kelaꞌafou Deo keau afagaina afuga kemai. Egaꞌina auꞌi, ‘Peaage’ ikupuga keoma auꞌi, Sairene, ke Aleksandria taoniꞌiai kemai. Isa ke Silisia, Asia agoꞌiai kemai papiauꞌi fou keapafou kai Stefano fou keakekua. ");
INSERT INTO mek_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kai Deo ega Spiritu Stefano ikifa epeniia. Isa egaꞌina ikifagai eniniꞌani puo niniꞌaniai fou keakekua kai aekainiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ega aisama Stefano iifa ipakaina pifogegai fekepaagu fofoua keoma. Ke papiau isaꞌi ogefakeai keꞌafaiꞌi iina fekeifa oma keoma, “Stefano, Moses Deo auniꞌi eeꞌiai eifa apala aina alogonia,” fekeoma keoma. ");
INSERT INTO mek_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ega koa kekapaisa, isa papiau ke au akaikiꞌaꞌi auꞌi, Moses ega iifa pamalelega auꞌi guaꞌi kepafaugaina guaꞌi kepakupua. Ke isa kemai Stefano keafiia kelaoaina kansolo auꞌi agoꞌiai kepaapa. ");
INSERT INTO mek_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ke pifoge auꞌi kemaiseiniꞌi niniꞌani pifogeꞌi keifaniꞌi keinaka, “Iꞌina auga Deo ega eꞌa iꞌina, ke Moses ega iifa fou eeꞌiai eifa apala aefuafua. ");
INSERT INTO mek_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Gome lai isa Iesu Nasareta auga, iꞌina afuga agepalifua, ke Moses eegai kagakaga kemai auꞌi isafa ageoge pagainiꞌi eoma aina alogonia,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ke egae kansolo keagu auꞌi maꞌoai Stefano kua maaga keisa aisama, agelo iisa eaea koa iꞌopoga keisa. ");
INSERT INTO mek_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Stefano eegai keifa apala efua aisama, sakedote lopia faꞌa Stefano epainia einaka, “Papiau iꞌina niniꞌaniꞌi keifaniꞌi auꞌi koꞌaꞌi ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ega aisama Stefano einaka: ");
INSERT INTO mek_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“Amau aumi, ke aau akiu aumi ainau amologo! Ufainagai iꞌa ufuꞌa apaꞌa Abraham Mesopotamia agogai eagu. Ke isa Haran taonina aelao koa kai, Lopia Deo akaikiꞌa eaea ke isapu gome auga Abraham eapakina penia epainia einaka, ‘Oi emu ago, emu ikupu papiauꞌi fou fopuaꞌafuniꞌi ago alapakinaiso ago folao,’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Abraham Deo ega iifa kainai Mesopotamia agogai, Kaldaios papiauꞌi keagu afuga epuaꞌafuga elao afu aka Haran. Isa ama emae afegai Deo isa epapealaisa emai pau oi oagu agogai eagu. ");
INSERT INTO mek_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ke Deo Abraham ago eꞌele mo ganinagai agaꞌo aepenia apuga aemia. Ke egaꞌina kinaꞌiai Abraham gauga laaꞌi ganinagai, Deo Abraham maagai epakoꞌania eifa egaꞌina ago isa agepenia, ke isa okogai akemai auꞌi isafa iꞌina ago pau oi oague auga agepeniꞌi eoma. ");
INSERT INTO mek_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kai Deo Abraham iina epaini oma einaka: ‘Oi okomuai akemai papiauꞌi, ago iꞌoinagai au aꞌiꞌi akemia. Ke ago inagomeꞌi isa pinauga meauga akepeniꞌi, inipo 400 alogai egae akekalaꞌafi. ");
INSERT INTO mek_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kai lau eꞌu papiau kalaꞌafi akepamiaꞌi agofaꞌa auga afa apala alapeniꞌi. Egae kai okomuai akemai papiauꞌi, ago egaꞌinagai akepealai akemai iꞌina agogai Lau akeau afagainiau,’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Egae kai Deo pakoꞌa niniꞌanina kapula gouga Abraham epeniia. Egaꞌina auga au maguaeꞌi faaga iifalaina gouga. Abraham gauga Aisak emauni kina imagea kuagai oiso aisama, Abraham Aisak faagagai egaꞌina pakoꞌaga gouga ekapaisa. Egaꞌina afegai Aisak Iakobo epamauga. Isa isafa ega koa iꞌopoga faagagai emia. Egaꞌina afegai Iakobo gauga 12 kemauni ke isa iꞌa ufuꞌa apaꞌa kemia. ");
INSERT INTO mek_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ke iꞌa ufuꞌa apaꞌa Iosepa aaga auꞌi Iosepa eegai kepikupa kainai kalaꞌafi koa iꞌopoga keꞌafaꞌafalaina. Ke afaꞌafa auꞌi Iosepa keafiia Isipto kelaoaina. Kai kina maꞌoai Deo Iosepa eegai eagu epalagaina. ");
INSERT INTO mek_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ega kainai Isiptoai kelele akaikiꞌaꞌi maꞌo aloꞌiai eapauka femae koa iꞌopoga kai, Deo isa egaꞌina keleleꞌi maꞌoai eeꞌiai epapealaisa. Ke Deo Iosepa epaikifania kainai, Isiptoai kin Faro isa anina eani alogaina. Faro, Iosepa eikifa alogaina eisa puo ega eꞌa fofouga ke Isipto ago kafanaga epamia. ");
INSERT INTO mek_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Egaꞌina kinaꞌiai Isipto ke Kanaan agoꞌi fofougai magea apala eꞌue aisama, ago fofouga alogai foꞌama laaꞌi emia. Ega puo iꞌa ufuꞌa apaꞌa foꞌama agaꞌo eꞌi agoai akekapulaisa inaeꞌi ekimu, kekiekie keulalu alogaina. ");
INSERT INTO mek_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kai Iakobo Isipto agogai foꞌama eka fouga elogo aisama, gauga iꞌa ufuꞌa apaꞌa auꞌi eulaiꞌi Isipto kelaoꞌina. ");
INSERT INTO mek_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ke kepamue kelao pugu aisama, Iosepa ifo fouga aaga maaꞌiai eifafoua. Ke isa ega famili fofouga fouꞌi efoufaꞌa aisama, Faro Iosepa ega famili fouꞌi elogo. ");
INSERT INTO mek_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Egae kai Iosepa iifa eulaisa ama Iakobo ke ega famili auꞌi 75 maꞌoai fekemai Isipto eoma. ");
INSERT INTO mek_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ega puo Iakobo ega famili maꞌoai kelao Isiptoai keagu egae ufuꞌa apaꞌa gauga fou kemae. ");
INSERT INTO mek_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Egae kai papiau isa imaauꞌi keafiiꞌi kemue kelaoainiꞌi Abraham ufainagai au aka Hamor gauga imaꞌiai ago agaꞌo aka Sekem afa akaikiꞌagai eꞌafaisa auga agogai kefufuniꞌi. ");
INSERT INTO mek_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Kai Deo Abraham maagai pakoꞌa niniꞌanina kapula ekapaisa auga kina emai ekai aliꞌali aisama, iꞌa aꞌa papiau Isiptoai keagu auꞌi, auꞌi maꞌo emia kealogai alogaina. ");
INSERT INTO mek_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ke egaꞌina kinaꞌiai Isiptoai kin mamaga Iosepa fouga aelogo auga Isipto ago eꞌimaisa. ");
INSERT INTO mek_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Isa iꞌa aꞌa papiau efogeiꞌi eafi apalaniꞌi. Ke epamaniꞌiniꞌi epaafiꞌi imoi uꞌuai auꞌi eꞌa afegai fekeogelaiꞌi feaupuguꞌi eoma. Ega koa iꞌa aꞌa papiau maꞌoai feaupuguꞌi eoma. ");
INSERT INTO mek_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Egaꞌina kinaꞌiai Deo ega logoai Moses emauni ke Deo maagai isa auga imoi aage laaꞌi. Ke isa afegai akepuaꞌafuga kai gafa oiso alogai ifo ama ega eꞌai keꞌimaisa. ");
INSERT INTO mek_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kai imoi fekeꞌima mo felao auga aekainia puo, afegai kepuaꞌafuga. Ega aisama Faro gauga ifiaoga isa eisa eafiia elao epafaꞌa gauga epamia. ");
INSERT INTO mek_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ke Moses eminifaꞌa emalele Isipto eꞌi ikifa maꞌoai elogo, ega niniꞌani ke ega pinauga ekapula alogai. ");
INSERT INTO mek_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Kai Moses inipoga 40 emia aisama, kina agaꞌogai aaga akina Israel papiauꞌi eopolaniꞌi gaisaꞌi eoma puo eeꞌi elao. ");
INSERT INTO mek_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kai elao aisama, Isipto auga agaꞌo Israel auga eafi apalania eisa. Ega aisama elao Israel auga iina eogeisa Isipto auga egaꞌina eaupugua. Moses ega koa ekapaisa Isipto auga ega laomai apala afa eogeisa. ");
INSERT INTO mek_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Gome Moses ega koa ekapaisa auga, eopolaga Deo isa agepalagaina, ega papiau kaniaꞌi ageagamauga auga aaga akina fekelogo eoma. Kai isa oko akelogo. ");
INSERT INTO mek_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ke egani Moses Israel papiauꞌi eeꞌi elao pugu, ke Israel auꞌi auniꞌi kepipaini eisaꞌi. Ke epoꞌiai gagao gamia eoma puo eifa einaka, ‘Oi aunimi! Oi auga aami akimi kai kapa puo opipaini?’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Kai au agaꞌo isa aaga akina eegai apala ekapa auga Moses ekoni meꞌe, ke epainia einaka, ‘Kaisau oi lai emai imaꞌima aumu epamiaiso, ke lai felo o apala akapa auga maamaisai foifania aumu epamiaiso? ");
INSERT INTO mek_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Faai oi Isipto auga loaupugua koa iꞌopoga, pau lau isafa moaupuguisau ma looma?’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses iꞌina iifaga aꞌo elogonia aisama emaniꞌi puo, epiau Midian ago elao au aꞌina koa egae eagu. Ke egae eamage gauga auniꞌi kemauni. ");
INSERT INTO mek_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Moses Midian agogai eagu inipo 40 elao afegai, Sinai ikuga niegai ago maininai au gagauꞌi laaꞌi kai agaꞌi mo kekaania kefai kelaoaina auꞌi epoꞌiai lo eufa eisa. Ke lo egaꞌina alogai agelo Moses eapakina penia. ");
INSERT INTO mek_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses egaꞌina eisa aisama ekauai alogaina. Ke gaisa felo eoma epeakua lo eega elaolao kai, Lopia iina eifa oma aina elogonia: ");
INSERT INTO mek_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Lau auga ufumu apamu, Abraham, Aisak, ke Iakobo eꞌi Deo,’ eoma. Ke Moses lo alogai kaisau eniniꞌani auga gaisa eoma kai emaniꞌi epigugu alogai puo aekainia. ");
INSERT INTO mek_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ke Lopia isa epainia pugu einaka, ‘Oi ifemu kamataga moafilaisa. Gome oi loapae aꞌisaga auga aꞌisa lolofaga. ");
INSERT INTO mek_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Iifa gome Isipto agogai Israel papiauꞌi kalaꞌafi kepamiaiꞌi auga laisaꞌi. Ke isa kekiekie ke keagaga auga isafa aꞌo lalogo. Ke Lau isa egaꞌina kiekie eegai mapapealaiꞌi laoma puo laake lamai. Pau oi alaulaiso alomue Isipto alolao pugu,’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Kai Israel papiauꞌi Moses egaꞌina auga keumakalaina kepainia keinaka, ‘Kaisau oi lai emai imaꞌima aumu epamiaiso, ke lai felo o apala akapa auga foifania aumu epamiaiso!’ keoma. Kai Deo isa Israel papiauꞌi eꞌi imaꞌima auga femia, ke Isipto agogai ipapealaiꞌi auga femia eoma. Ke ega koa ekapaisa auga, ega agelo eulaisa, Moses au lo eufa auga alogai eapakina penia. ");
INSERT INTO mek_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ke isa Isipto agogai, ke Aꞌu pitogai, ke inipo 40 ago maininai mirakulo isapuꞌi akaikiꞌaꞌi gouꞌi ekapaiꞌi afegai aisama epapealaiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Ke Moses egaꞌina iꞌina iifaga Israel papiauꞌi maaꞌiai eifania einaka ‘Lopia oi emi Deo profeta agaꞌo lau koa iꞌopou, oi ifomi emi papiau epoꞌiai ageulaisa agemai. Oi isa aina foafia,’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ke isa Sinai ikugai agelo fou keniniꞌani. Ke isa iꞌa ufuꞌa apaꞌa fou ago maininai keagu kelao kemai aisama, Deo ega agu pagai niniꞌaniꞌi agelo eegai eafiiꞌi auga iꞌa fepeni pagainiꞌa eoma. Ega puo isa egaꞌina iifaꞌi iꞌa ufuꞌa apaꞌa epeni pagainiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Kai iꞌa ufuꞌa apaꞌa Moses aina akeafia ke keumakalaina. Kai guaꞌi alogai auga kegamue Isipto kegalao keoma. ");
INSERT INTO mek_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Isa Aaron kepainia keinaka, ‘Moses Isiptoai epapealaimai auga eegai kapaꞌina emia auga alalogo. Pau lai ifomai emai deo agomaisai akepea akepapeaimai auꞌi mokapaꞌi mopenimai,’ keoma. ");
INSERT INTO mek_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ke egaꞌina kinagai pifoge deoga, iisa polomakau gauga koa iꞌopoga kekapaisa. Ke aꞌo keaupuguꞌi ifoꞌi imaꞌiai eꞌi deo kekapaisa auga kepalao penia, ke keau afagaina kemiamialaina. ");
INSERT INTO mek_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ega aisama Deo isa emuniiꞌi epuaꞌafuniꞌi ufa guagai kina, gafa, miꞌimiꞌi ke kapa maꞌoai epalao peniꞌi keau afagainiꞌi. Ke isa egaꞌina kekapaisa auga Deo ega iifa pukagai profeta iina kepapua oma koa iꞌopoga mo emia: “‘Israel papiaumi! Oi inipo ouꞌaga pani alogai ago maininai aꞌo oaupuguiꞌi opalao peniau auga, lau alopalao peniau kai, ufa deoꞌi pifogeꞌi auꞌi opalao peniꞌi. ");
INSERT INTO mek_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Oi Molok keoma auga ega eꞌa opuaisa, ke emi deo pifoge Rapan keoma auga isafa ega miꞌimiꞌi opuaisa. Ega koa okapaisa lau aloau afagainiau kai, oi imamiai deo okapaꞌi auꞌi oau afagainiꞌi. Ega puo Lau oi emi agoai alapapealaimi, alaulaimi Babilon ago apie, aaka ipauma agolao,’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Iꞌa ufuꞌa apaꞌa epoꞌiai Deo eague auga gouga, ega eꞌa isafa kepuaisa, ago maini alogai kepea. Egaꞌina eꞌa auga Deo Moses epainia fekekapa eoma auga. Ega puo Deo Moses epakina koa iꞌopoga mo, ega papiau fou kekapaisa. ");
INSERT INTO mek_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Egae kai ufuꞌa apaꞌa muniꞌiai kemai auꞌi Deo ega eꞌa keafiia eeꞌiai eka. Ke Deo Kanaan ago ekinaga, papiau egae keagu auꞌi fepapealaiꞌi ke egaꞌina ago iꞌa ufuꞌa apaꞌa fepeniꞌi eoma. Ega kainai egaꞌina agogai kekoko aisama, Josua isa eꞌimaiꞌi Deo ega eꞌa egaꞌina kepuaisa kelao. Ke eꞌa egaꞌina egae mo eka elao Davide lopia emia kinagai. ");
INSERT INTO mek_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ke Davide egaꞌina auga Deo ega gafegafe eafiia. Ke isa Deo egoinia ufuꞌa apaꞌa Iakobo okogai kemai auꞌi, Deo akeau afagaina afuga Deo faugai fepaapa eoma. ");
INSERT INTO mek_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kai Davide Deo ega eꞌa fekapa auga Deo eumaka kai, isa gauga Solomon elogoaina eꞌa ekapaisa. ");
INSERT INTO mek_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Kai Deo Auꞌoniai Ipauma Auga, papiau aumauni eꞌa kekapa auga alogai aeagu. Ke egaꞌina fouga profeta Aisaea ufainagai Deo kapa eoma auga fouga eifania einaka: ");
INSERT INTO mek_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“‘Lopia eifa, “Ufa auga Lau eꞌu aguagu afuga, ke agofaꞌa auga Lau ifeu ipaapa afuga. Ega puo fauai eꞌa kapa agokapa, ke eꞌu laagai afuga kapai agemia? Iifa gome laifania, lau eꞌu eꞌa oi agokapa afaekaina. ");
INSERT INTO mek_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Gome ufai ke agofaꞌai kapa maꞌoai Lau ifou imauai lapagamaꞌi, ke maꞌoai mo Lau apu,’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Ke pau oi lau Deo ega eꞌa, ke Moses ega iifa fou eeꞌiai laifa apala ooma, iifa ipakainai opaapaisau. Kai oi auga ainafua, ke gua inoka papiaumi! Oi kina maꞌoai Deo ega Spiritu opafiulaisa aefuafua. Ke oi ufumi apami kekapaisa koa iꞌopoga, oi isafa iꞌopoga mo okapa. ");
INSERT INTO mek_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ke oi ufumi apami aufa kina profeta maꞌoai keafi apalaniꞌi. Ke alo opai ipauma auga agemai fouga keifania auꞌi isafa keaupuguꞌi. Ke pau oi isafa alo opai ipauma auga egaꞌina oꞌafaꞌafalaina, oafi apalania, ke oaupugua. ");
INSERT INTO mek_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Oi aumi, Deo ega iifa agelo Moses epeniia auga ufumi apami epeniiꞌi. Oi egaꞌina iifaꞌi isafa oafiiꞌi kai kaiꞌiai alopea,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Iifa ipakaina alogai papiau maꞌoai, Stefano iꞌina iifaꞌi eifaniꞌi aꞌoꞌi kelogonia aisama, guaꞌi ekupu alogaina, aꞌiꞌi keagaisa, keꞌeꞌefa alogaina. ");
INSERT INTO mek_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kai Stefano alo Deo ega Spiritu epapogua, ke maaga eakae ufai Deo ega eaea ke isapu akaikiꞌa, ke Iesu Deo kaina kainai eapa auga eisa. ");
INSERT INTO mek_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ke eifa einaka, “Amoisa! Ufa eagalai, Papiau Aumauni Gauga, Iesu Deo kaina kainai eapae laisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ega aisama papiau egae keapa auꞌi maꞌoai mo ainaꞌi kefau apua, aisoꞌi gomegai keagaga Stefano kepiau penia. ");
INSERT INTO mek_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ke kelao keafiia, kelaꞌa pupuge, taoni afe kelaoaina. Ke ifoꞌi afeꞌi tiapuꞌi keafilaiꞌi, au aguꞌa agaꞌo aka Saulo ife foꞌinai keogeiꞌi kai kepo keafiiꞌi Stefano kefounia. ");
INSERT INTO mek_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Papiau Stefano kepoai kefounia alogai emegamega einaka, “Lopia, Iesu lalau moafia!” eoma. ");
INSERT INTO mek_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ke eanifeꞌu kai eagaga einaka, “Lopia, eꞌi laomai apalaꞌi moꞌagegeainiꞌi!” eoma. Iꞌina eifania efua aisama emae. ");
INSERT INTO mek_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Egaꞌina alogai Saulo egae eapa, Stefano emae auga eisa eopolaga felo mo eoma. Ega kinagai Ierusaleme taoninai afi apala akaikiꞌa iifi eꞌa pakoꞌa papiauꞌi faagaꞌiai emia. Ke pakoꞌa papiauꞌi maꞌoai kekani okaoka kelao, Iudea ke Samaria agoꞌiai keagu. Kai apostolo auꞌi Ierusaleme taoninai mo keagu. ");
INSERT INTO mek_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Kai egaꞌina aemia koa kai, aloꞌi koꞌagai Deo keau afagaina auꞌi isaꞌi kelao Stefano emae auga imaauga keafiia kelao kefufunia. Ke isa Stefano gua keaniia faugai keapepe alogaina. ");
INSERT INTO mek_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Kai Saulo auga, eꞌina iifi eꞌa pakoꞌa papiauꞌi maꞌoai eauokaꞌi. Isa elao eꞌa agaꞌo agaꞌogai ekoko, pakoꞌa auꞌi ke papieꞌi fou elaꞌalaiꞌi elaoainiꞌi epatipulaniꞌi. ");
INSERT INTO mek_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ega puo pakoꞌa papiauꞌi kekani okaoka afu agaꞌo agaꞌo kelao auꞌi, iifa faunina Iesu fouga keinogonia. ");
INSERT INTO mek_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Egaꞌina alogai Filip elao Samaria agogai taoni agaꞌogai ekoko egae papiau maaꞌiai Iesu Mesaia auga fouga einogonia. ");
INSERT INTO mek_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ke laꞌafou papiauꞌi Filip aina kelogonia, ke mirakulo isapuꞌi gouꞌi ekapaiꞌi keisaꞌi aisama, ainaꞌi kepaau felo kapaꞌina eifania auga aꞌo kelogonia. ");
INSERT INTO mek_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Gome Filip ega pinauga ekapula alogaina, papiau aloꞌiai tiapolo apalaꞌi maisagagaꞌi mo epapealaiꞌi. Ke apoke ipauma papiauꞌi, ke melo papiauꞌi maꞌo fou epafeloꞌi. ");
INSERT INTO mek_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ke egaꞌina taoninai papiau aloꞌi egama alogaina. ");
INSERT INTO mek_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Egaꞌina kinaꞌiai au agaꞌo aka Saimon Samaria taoninai eagu. Isa ugauga ekapaisa Samaria papiauꞌi epakauai alogainiꞌi. Ke isa eainaꞌau ifo eau afagaina, au akaikiꞌa ipauma epamia. ");
INSERT INTO mek_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Egae lopia ke ulalu papiauꞌi maꞌoai isa kapaꞌina ekapaisa auga maaꞌiai keisa ke aina kainai kepea. Isa aina kainai kepea auꞌi keifa keinaka, “Iꞌina auga isapu akaikiꞌa auga deo ega isapu aoma auga koa iꞌopoga eafiia,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Isa kina maꞌo ugaugai pifoge isapuꞌiai ega koa ekapaiꞌi papiau epakauai alogainiꞌi puo muninai kepea. ");
INSERT INTO mek_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kai Filip einogo iifa faunina Deo ega agofaꞌa fouga ke Iesu Kristo aka eifania aisama, au papie fou Filip eifania auga kepakoꞌania ke baptismo keafiia. ");
INSERT INTO mek_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ke Saimon ifo isafa epakoꞌania baptismo eafiia. Ke Filip mirakulo isapuꞌi gouꞌi akaikiꞌaꞌi ekapaiꞌi eisaꞌi aisama ekauai alogaina. Ega puo kina maꞌoai Filip ala elao aisama muninai epea. ");
INSERT INTO mek_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria papiauꞌi Deo ega iifa aꞌo kelogonia, ke kepakoꞌania auga apostolo, Ierusaleme taoninai keagu auꞌi fouga kelogo. Ega aisama, Peto, Ioane auniꞌi keulaiꞌi isa eeꞌi Samaria kelao. ");
INSERT INTO mek_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ke auniꞌi Samaria taoninai kekoko aisama, egaꞌina papiauꞌi fauꞌiai fekemegamega, ega koa Deo ega Spiritu fekeafia keoma. ");
INSERT INTO mek_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Gome Deo ega Spiritu isa agaꞌo laaꞌiai aeake. Kai isa Lopia Iesu Kristo akagai baptismo mo keafiia. ");
INSERT INTO mek_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ega puo Peto Ioane auniꞌi imaꞌi isa kaniaꞌiai keogeaua kemegamega aisama, isa Deo ega Spiritu keafiia. ");
INSERT INTO mek_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon, apostolo imaꞌi papiau kaniaꞌiai keogeaua, Deo ega Spiritu eake peniꞌi auga eisa. Ega aisama apostolo moni epeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Egae kai epainiꞌi einaka, “Lau anina laani imau papiau kaniaꞌiai alaogeaua aisama, maꞌoai Deo ega Spiritu fekeafia laoma. Ega puo egaꞌina logo isapuga isafa amopeniau,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kai Peto einaka, “Oi emu moni moafia fou amogea. Gome oi loopolaga emu moniai Deo ega ipeni Spirituga aloꞌafa agekaina looma. ");
INSERT INTO mek_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Oi alomu auga Deo maagai apala ipauma! Ega puo Deo ega pinauga iinaꞌi auga oi emu pinauga laaꞌi, ke apumu isafa laaꞌi. ");
INSERT INTO mek_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Oi iꞌina laoꞌi maiꞌi apalaꞌi ipaumaꞌi foumakalainiꞌi kai, Lopia fomegamega penia. Laopolaga Deo oi guamuai apala ega koa loopolaga lokapaisa auga afeꞌagegeaina isafa. ");
INSERT INTO mek_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gome oi laisao auga apala alomu epogu, ke laomai apalaꞌi oi kegopeisa,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saimon iꞌina aꞌo elogonia aisama Peto epainia einaka, “Fauai Lopia momegamega penia oi loifaniꞌi kapaꞌi auꞌi agaꞌo faagauai faemia,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Egaꞌina afegai Peto Ioane auniꞌi Lopia Iesu Kristo fouga koꞌa ipauma auga, papiau maaꞌiai keifafou kapulania. Egae kai kemue Ierusaleme taonina kelao. Ke kelao alogai Samaria taonina eegai paguaꞌi papiauꞌi maꞌo maaꞌiai isafa iifa faunina Iesu fouga keinogonia. ");
INSERT INTO mek_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kina agaꞌogai Deo ega agelo Filip epainia einaka, “Moꞌue, Ierusaleme taonina keaga South elao ago maininai epagai Kasa taonina elao auga moafia molao,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ega puo Filip eꞌue keaga egaꞌina eafiia elao. Elao aisama keagai Etiopia auga eisa. Ke egaꞌina auga au akaikiꞌa, Etiopia kuinina aka Kandas ega amuꞌamu eꞌimaꞌi auga. Isa elao Ierusaleme taoninai Deo eau afagaina efua pau pulietai eaguka emue ega eꞌa elao. ");
INSERT INTO mek_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Elao alogai Aisaea profeta ega puka ekuapinia elaoaina. ");
INSERT INTO mek_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Filip egaꞌina auga eisa aisama, Deo ega Spiritu isa epainia einaka, “Molao pulieta molaisaoga,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ega puo Filip epiau elao pulieta elaisaoga aisama, au egaꞌina Aisaea profeta ega puka ekuapinia aina elogonia. Ega aisama epaꞌani penia einaka, “Kapaꞌina lokuapina auga oko lologo ma?” eoma. ");
INSERT INTO mek_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ke isa einaka, “Aufalao agaꞌo maauai oko afaepakaisa koa aisama, ala koa iꞌopoga alalogo?” eoma. Ega puo isa Filip eifa koko gaꞌagaukae gamai fou kegaagu eoma. ");
INSERT INTO mek_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Au egaꞌina Deo ega iifa pukagai iꞌina iifaga ekuapinia: “Papiau isa sipi koa iꞌopoga keafiia kelaoaina keaupugua. Ke sipi gauga faaga puina kepaepe aꞌoaꞌo agaꞌo aekapa koa iꞌopoga, isa isafa iifa ipakainai iifa agaꞌo aeifania. ");
INSERT INTO mek_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Iifa ipakainai papiau isa kepameagaina, pifoge keifania, iifa ipakaina koꞌagai akepea. Agofaꞌai papiau isa kepamaea efua, kai agaꞌo aeagu puo, kai agaꞌo isa okogai akemai auꞌi fouꞌi ageifania afaekaina.” ");
INSERT INTO mek_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ke au egaꞌina Filip epaꞌani penia einaka, “Iꞌina iifaga kaisau fouga eifania? Profeta egaꞌina ifo, o papiau iꞌoina agaꞌo fouga eifania?” eoma. ");
INSERT INTO mek_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ega aisama Filip, profeta Aisaea ega iifa gomegai eꞌina, iifa faunina Iesu fouga eifania. ");
INSERT INTO mek_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Ke keagai kelao alogai fei afuga agaꞌo keisa. Ega aisama Etiopia auga eifa einaka, “Fei inamoꞌe moisa. Baptismo alopeniau agekaina koa aisama mopeniau,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Egae kai Etiopia auga ega papiau epainiꞌi, pulieta keagai kepaapakipo. Ke Filip Etiopia auga auniꞌi keake kelao feisai baptismo epeniia. ");
INSERT INTO mek_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Isa auniꞌi feisai keꞌagaukae aisama, Deo ega Spiritu Filip eafiia epagea puo Etiopia auga Filip aeisa pugu. Kai isa Filip aeisa mo ganinagai, alo egama alogaina puo aeopopo ekailai afuga elao. ");
INSERT INTO mek_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Kai Filip auga Deo ega Spiritu isa Asotus taoninai epaapafokia. Egae kai Sisarea taonina elao alogai taoni maꞌoai aloꞌiai ekoko iifa faunina Iesu fouga einogo aefua elao mo Sisarea taonina. ");
INSERT INTO mek_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kai Saulo Ierusaleme taoninai eagu auga, Lopia ega papiau epamaniꞌiniꞌi, ke gaaupuguꞌi paisa eoma puo elao sakedote lopia faꞌa eegai. ");
INSERT INTO mek_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ke egoinia malele agaꞌo fepapua feafia felao, Damaskus taoninai Iudea papiauꞌi eꞌi laꞌafou afugai, au akaikiꞌaꞌi fepeniꞌi eoma. Ega koa isa fekepalagaina au papie fou Iesu ega iifa kainai kepea auꞌi ageisaꞌi aisama, fegopeꞌi femaiseiniꞌi Ierusaleme taoninai eoma. Sakedote lopia faꞌa egaꞌina malelega epapua efua aisama, Saulo malele eafiia Damaskus taonina elao. ");
INSERT INTO mek_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ke Saulo elao alogai emai Damaskus taonina eegai aisama, fiakoa mo eaea akaikiꞌa ufai egefaopu eake eailofe. ");
INSERT INTO mek_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ega aisama maaga eꞌumina eꞌualai aꞌisaai, ke aufalao agaꞌo iina eifa oma aina elogonia, “Saulo! Saulo! Kapa puo lau loafi apalaniau?” eoma. ");
INSERT INTO mek_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ke Saulo einaka, “Lopia, oi kaisau?” eoma. Ke Lopia einaka, “Lau Iesu, loafi apalaniau au. ");
INSERT INTO mek_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Pau moꞌue Damaskus taonina alogai mokoko. Egae oi kapaꞌina fokapa auga maamuai akeifania,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ke Saulo fou kelao auꞌi isafa, egae keapa aꞌoaꞌo kelogonia kai, kai agaꞌo akeisa puo kekauai alogaina iifa agaꞌo akeifania. ");
INSERT INTO mek_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Egae kai Saulo aꞌisaai eꞌue ke maaga epakiakaea aisama kapa agaꞌo aeisa. Kai fou kelao auꞌi isa imagai keafi kepapea Damaskus taonina alogai kekoko. ");
INSERT INTO mek_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ke egae Saulo kina oiso alogai maaga ekimiꞌi eagu, ke kapa agaꞌo aeania ke aeinu. ");
INSERT INTO mek_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Egaꞌina kinaꞌiai Iesu epakoꞌania auga agaꞌo aka Ananias Damaskus taoninai eagu. Lopia laulauai isa eifaga einaka, “Ananias!” eoma. Ke Ananias einaka, “Lopia, lau inamoꞌe,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ke Lopia isa epainia einaka, “Moꞌue keaga aka Opaina keoma auga keagaga moafia molao egae Judas ega eꞌai Tarsus auga aka Saulo fopaꞌaniaina. Gome isa pau eague emegamega. ");
INSERT INTO mek_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ke ega megamegai maaga elaulau au aka Ananias eisa elao ima faagagai eogeaua ega koa maaga efelo afu eisa pugu eoma.” ");
INSERT INTO mek_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ega aisama Ananias einaka, “Lopia, papiau maꞌo eeꞌiai iꞌina auga Ierusaleme taoninai oi emu papiau ala epalifu omaꞌi auga fouga lalogo. ");
INSERT INTO mek_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ke sakedote lopiaꞌi isa isapu kepeniia, papiau inae oi akamu keifania auꞌi maꞌoai fegopeꞌi keoma,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kai Lopia isa epainia einaka, “Molao. Gome isa lau fauai lakinaga eꞌu pinauga agekapa. Isa afu iꞌoiꞌi iꞌoiꞌi agelao akelogoniau papiauꞌi, ke eꞌi kin ke Israel papiauꞌi isafa maaꞌiai lau akau ageifafoua. ");
INSERT INTO mek_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Gome isa lau akau kainai ala fekiekie oma auga alapakina,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ega puo Ananias elao Saulo eagu eꞌagai ekoko. Ke ima Saulo faagagai eogeaua kai einaka, “Akiu Saulo, oi iina lomai alogai Lopia Iesu oi keagai eapakina penio auga eulaisau lamai. Ega koa oi afu foisa pugu ke Deo ega Spiritu alomu fepogu eoma.” ");
INSERT INTO mek_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ega aisama fiakoa mo Saulo maagai maꞌa oga koa iꞌopoꞌi keꞌualai ke afu eisa pugu. Ke eꞌue Ananias isa baptismo epeniia. ");
INSERT INTO mek_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ke isa foꞌama eaniia aisama, ega kapula eafimue pugu. Saulo kina pika koa iꞌopoga Damaskus taoninai pakoꞌa papiauꞌi fou keagu. ");
INSERT INTO mek_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Egaꞌina alogai fiakoa mo Iudea papiauꞌi eꞌi laꞌafou afuga elao, Mesaia fouga einogonia, ke eifa Mesaia auga Deo Gauga eoma. ");
INSERT INTO mek_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ega aisama papiau maꞌoai isa aina kelogonia auꞌi kekauai alogaina, ke keinaka, “Iꞌina auga Ierusaleme taoninai Iesu aka keifania papiauꞌi epalifuꞌi. Ke isa egaꞌina fekapa eoma puogai, iina emai ega koa iꞌina papiauꞌi fegopeꞌi, sakedote lopiaꞌi eeꞌi felaoainiꞌi eoma. Kai ala koa pau eapae Iesu fouga eifafoua?” keoma. ");
INSERT INTO mek_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kai Saulo ega inogo kapulaga euki elaoaina, ke Iesu Mesaia auga koꞌa ipauma mo papiau maaꞌiai eifafoua. Ega koa ekapaisa Iudea papiauꞌi Damaskus taoninai keagu auꞌi aloꞌi epamaꞌo alogaina, kapaꞌina fekekapa auga akelogo. ");
INSERT INTO mek_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ke kina maꞌo kelao afegai, Iudea papiauꞌi iifa kepaapa Saulo kegaaupugua keoma. ");
INSERT INTO mek_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ke isa kinai ke gapiai Damaskus taonina paꞌafina akegai keapa keꞌimaisa aefuafua, fekeaupugua keoma. Kai Saulo isa fekeaupugua iifaga kepaapa auga fouga elogo. ");
INSERT INTO mek_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ega aisama Saulo muninai kepea auꞌi, gapiai Saulo keafiia, kokoꞌeai keukaisa, pou inegai kepaake. Ke isa Damaskus taoninai epealai, Ierusaleme taonina pea epea. ");
INSERT INTO mek_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ke Saulo emai Ierusaleme taoninai ekoko aisama, egae pakoꞌa papiauꞌi fou kegamia eoma. Kai egaꞌina papiauꞌi maꞌoai, isa alo koꞌagai Iesu epakoꞌania auga akepakoꞌania puo, kemaniꞌiaina. ");
INSERT INTO mek_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kai Banabas Saulo eafiia apostolo eeꞌi elaoaina. Ke Saulo Damaskus taonina keagagai maagai Lopia ala koa eisa, ke Lopia isa maagai eniniꞌani auga fouga apostolo maaꞌiai eifania. Ke isa Damaskus taoninai aimaniꞌina mo Iesu akagai ala einogo kapula oma auga isafa fouga maaꞌiai eifania. ");
INSERT INTO mek_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ega puo pakoꞌa papiauꞌi Saulo akemaniꞌiaina, fou Ierusaleme taoninai keagu. Ke Saulo Ierusaleme taoninai elao emai aisama, kai agaꞌo isa aekaisapua, ke aimaniꞌina mo Lopia Iesu akagai einogo kapula alogaina. ");
INSERT INTO mek_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kina agaꞌogai Saulo, Iudea papiauꞌi Grik malagai keniniꞌani auꞌi fou niniꞌaniai keakekua. Ega puo isa keoge Saulo kegaaupugua keoma. ");
INSERT INTO mek_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kai pakoꞌa papiauꞌi iꞌina fouga kelogo aisama, Saulo keafiia Sisarea taonina kelaoaina, ke egae keulaisa Tarsus taonina elao. ");
INSERT INTO mek_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Egaꞌina afegai Iudea, Kalilea, ke Samaria agoꞌi fofouga pakoꞌa papiauꞌi maꞌoai gagaoai keagu. Ke Deo ega Spiritu isa epalagainiꞌi eꞌi pakoꞌa epakapulania, ke Deo kemaniꞌiaina keau afagaina, ke ega ikupu akaikiꞌa emia. ");
INSERT INTO mek_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Egaꞌina kinaꞌiai Peto afu maꞌoai epeaiꞌi alogai, elao Deo ega papiau Lida taoninai keagu auꞌi isafa eeꞌiai. ");
INSERT INTO mek_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Egae au agaꞌo aka Aeneas faaga fofouga emae auga inipo imagea kuagai gua petiai ekaaka mo auga eisa. ");
INSERT INTO mek_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ke Peto isa epainia einaka, “Aeneas, Iesu Kristo epafeloiso moꞌue emu peti mokapa felo,” eoma. Ke isa fiakoa mo felo emia eꞌuegekae. ");
INSERT INTO mek_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lida taonina ke Saron agogai keagu auꞌi maꞌoai Aeneas efelo keisa, ke isa Lopia keaipenia. ");
INSERT INTO mek_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ke Joppa taoninai pakoꞌa papiega agaꞌo aka Tabita eagu. (Isa Grik malagai keifaga Dorkas keoma.) Egaꞌina papiega kina maꞌoai papiau eeꞌiai pinauga felo mo ekapaiꞌi, ke ulalu papiauꞌi isafa epapalagainiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kai egaꞌina kinagai eisafa emae. Ke papiau isa imaauga kepauepia efua aisama, keafiia eꞌa auꞌoni agaꞌogai kepakala. ");
INSERT INTO mek_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ke Joppa taonina ke Lida taonina fou epoꞌi agoma laaꞌi kainai, pakoꞌa papiauꞌi, Peto Lida taoninai eagu auga fouga kelogo. Ke isa au gua keulaiꞌi kelao Peto kegoinia keinaka, “Mogafegafe mopaafiafi fou emai taoni alao,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ega aisama Peto eꞌue isa fou Joppa taonina kelao. Ke kelao eꞌai kekoko aisama, Peto kepapea keꞌagauaina eꞌa auꞌoniai Tabita eka afugai kekoko. Ke afuafu maꞌoai Peto keapa lofe keapepe, ke Tabita eagu miagai afeꞌi tiapuꞌi iꞌoiꞌi iꞌoiꞌi maꞌoai ekainiꞌi auꞌi keafiiꞌi kepakina. ");
INSERT INTO mek_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Egae kai Peto eꞌa alogai papiau maꞌoai epapealaiꞌi kai, eanifeꞌu emegamega. Ke Tabita emae auga imaauga eaipenia eifa einaka, “Tabita moꞌue,” eoma. Ke Tabita maaga epakiakaea Peto eisa aisama eꞌuegekae eagu. ");
INSERT INTO mek_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ke Peto isa epalagaina imagai eafi epaꞌuegenia eapa. Egae kai Deo ega papiau ke afuafu fou eifaniꞌi kemai epamaunimue auga epakinaꞌi. ");
INSERT INTO mek_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Peto iꞌina ekapaisa auga fouga Joppa taoninai efoufaꞌa. Ke papiau maꞌo Lopia Iesu kepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ke Peto kina maꞌo Joppa taoninai, au agaꞌo aka Saimon, aꞌo faagaꞌi eafiiꞌi tiapu ekapakapa auga ega eꞌai fou keagu. ");
INSERT INTO mek_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Roma auga agaꞌo aka Konelius, Roma ifani auꞌi 100 eꞌimaꞌi lopiaga Sisarea taoninai eagu. Ifani auꞌi egaꞌina keifaniꞌi Itali ifani auꞌi keoma. ");
INSERT INTO mek_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Konelius ke ega famili maꞌoai fou, Deo kemaniꞌiaina, ke Isa mo keopolaga, keau afagaina, ke ega iifa kainai kepea. Isa ega gafegafe akaikiꞌagai ulalu auꞌi epalaganiꞌi, ke Deo emegamega penia aefuafua. ");
INSERT INTO mek_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kina agaꞌo gapigapi 3 oꞌclock aisama, Konelius maaga elaulau alogai Deo ega agelo eisa koꞌania. Ke agelo isa eapakina penia auga isa eifaga einaka, “Konelius,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konelius agelo eisa felo aisama, emaniꞌi ke eifa einaka, “Lopia, kapaꞌina?” eoma. Agelo einaka, “Oi aufa kina lomegamega, ke ulalu logafeiꞌi auga Deo eopolaniꞌi puo, eulaisau lamai. ");
INSERT INTO mek_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Pau au isaꞌi moulaiꞌi, Joppa taonina kegalao, au aka Saimon, Peto keoma auga kegamaiseina. ");
INSERT INTO mek_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Isa au agaꞌo aka Saimon aꞌo faagaꞌi eafiꞌi tiapu ekapa auga fou keague. Ke Saimon ega eꞌa auga aꞌu niegai,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Agelo Konelius epainia efua elao aisama, Konelius au auniꞌi ega eꞌai kepinauga auꞌi, ke ega pipalagai auꞌi epoꞌiai, ifani auga agaꞌo Deo maagai alo koꞌagai ega pinauga ekapa auga fou eifaniꞌi kemai. ");
INSERT INTO mek_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ke maaꞌiai kapaꞌina emia auga maꞌoai eifania efua aisama, eulaiꞌi Joppa taonina kelao. ");
INSERT INTO mek_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ke egani atiafa eafiia aisama, egaꞌina auꞌi kelao Joppa taonina eegai. Egaꞌina kina maagai, Peto gamegamega eoma puo eꞌagaukae laagai afugai eꞌa ofaofagai. ");
INSERT INTO mek_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ega aisama inaega ekimu alogaina kapa agaꞌo gaania eoma. Kai papiau foꞌama kegakugakuga laolao kai isa maaga elaulau. ");
INSERT INTO mek_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ke laulau egaꞌina alogai ufa eagalai, ke kapa agaꞌo tiapu akaikiꞌa koa iꞌopoga, kiuga pani apaꞌuai koa iꞌopoga kegopeiꞌi eake emai eegai aꞌisaai eisa. ");
INSERT INTO mek_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ke egaꞌina tiapuga alogai aagoa aꞌoꞌi iꞌoiꞌi iꞌoiꞌi ifeꞌiai imaꞌiai kepea auꞌi, guaꞌiai keku auꞌi fou, ke ufa ineꞌi iꞌoiꞌi iꞌoiꞌi egae keka eisaꞌi. ");
INSERT INTO mek_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ke aufalao agaꞌo aina emai einaka, “Peto moꞌue egaꞌina amuꞌi moaupuguꞌi moaniꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kai Peto einaka, “Lopia afaekaina. Gome lau egaꞌina amuꞌi apalaꞌi, ofu amuꞌi alaanianiꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kai aufalao agaꞌo aina emai isa ipainina gua epamia einaka, “Deo kapa maꞌoai feloꞌi eoma auga oi apalaꞌi ofuꞌi folooma,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ega koa iꞌopoga oiso emia afegai aisama, Lopia egaꞌina tiapuga ufai eꞌagauaina pugu. ");
INSERT INTO mek_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Peto laulau eisa auga kapaꞌina eifania auga eopopolaga kai Konelius au eulaiꞌi auꞌi Saimon ega eꞌa kekapulaisa paꞌafina akegai keapa. ");
INSERT INTO mek_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ke keifalao Saimon Peto keoma auga egae ma eague auga paꞌanina kepaꞌani. ");
INSERT INTO mek_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peto egaꞌina laulauga kapaꞌina eifania auga eopopolaga kai Deo ega Spiritu isa epainia einaka, “Moisa, au oiso oi kekapunio. ");
INSERT INTO mek_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ega puo moꞌue moake ke opomu folopamaꞌo isa fou folao. Gome lau egaꞌina auꞌi laulaiꞌi iina kemai,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Egae kai Peto eake emai, ke egaꞌina auꞌi epainiꞌi einaka, “Amoisa. Oi au okapuga auga lau inamoꞌeu. Kapa puo iina omai?” eoma. ");
INSERT INTO mek_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ke isa keinaka, “Konelius, Roma ifani auꞌi 100 eꞌimaꞌi lopiaga eulaimai. Isa Deo maagai alo opai auga, ke Deo emaniꞌiaina, Isa mo eopolaga. Iudea papiauꞌi maꞌoai isa ega koa ekapa auga kelogo puo aina keafia. Ke Deo ega agelo alo elolofa auga agaꞌo emai isa epainia, iifa feulaisa oi fomai isa ega eꞌai, ke isa oi kapaꞌina aloifania auga aꞌo felogo eoma,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Egae kai Peto egaꞌina auꞌi eꞌai epakokoꞌi, gapi agaꞌomo fou egae kefeu. Egani aisama, Peto egaꞌina auꞌi fou keꞌue kelao ke Joppa taoninai Peto aaga akina pakoꞌa auꞌi isaꞌi isafa isa keisaoga fou Sisarea taonina kelao. ");
INSERT INTO mek_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ke egani aisama Sisarea taoninai kekoko. Egaꞌina alogai Konelius aaga akina ipaumaꞌi, ke ekefaꞌa ipaumaꞌi auꞌi fou eifaniꞌi ega eꞌai kekaigugu, Peto ke egaꞌina auꞌi fou keꞌimaiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ke Peto emai eꞌa paꞌafina akegai ekoko alogai, Konelius elao Peto auniꞌi kepiaogai. Ke Konelius Peto ife foꞌinai eꞌualai eomukipo eau afagaina. ");
INSERT INTO mek_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kai Peto isa epaꞌuegenia kai epainia einaka, “Moꞌue, lau ifou isafa papiau aumauni oi koa iꞌopomu,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ke Peto isa auniꞌi keniniꞌani kepealaina eꞌa alogai kekoko. Ke egae papiau maꞌo kelaꞌafou eisaꞌi. ");
INSERT INTO mek_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ega aisama Peto isa epainiꞌi einaka, “Moses ega iifa kainai lai Iudea papiaumai, Deo akelogonia auꞌi fou faniniꞌani, faaniani, ke fou faagu auga ala eifa apu oma auga ologo felo. Kai lau maau elaulau alogai, Deo kapa maꞌoai epagamaꞌi auꞌi feloꞌi moaꞌina auga epakinaisau. Ega koa iꞌopoga papiau isafa, Deo akelogonia mo folooma aloꞌi eofu, o aloꞌi apala folopamiaꞌi eoma. ");
INSERT INTO mek_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ega puo oi iifa loulaisa famai looma aisama, niniꞌani kapa agaꞌo laaꞌi, lau lamai mo. Ega puo lau lapaꞌani, kapa puo iifa loulaisa lamai?” eoma. ");
INSERT INTO mek_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ke Konelius einaka, “Kina pani elao efua, ke egaꞌina kinagai iꞌina kina maagai 3 oꞌclock gapigapi, lau eꞌu eꞌa alogai lamegamega. Moisa, egaꞌina alogai fiakoa mo au agaꞌo tiapu keloga ipauma eaea eailofe auga eiꞌiuka agouai eapa laisa. ");
INSERT INTO mek_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ke isa einaka, “Konelius! Oi aufa kina lomegamega auga Deo aꞌo elogonia, ke ulalu logafeiꞌi auga Deo eopolaga. ");
INSERT INTO mek_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Oi au isaꞌi moulaiꞌi Joppa taonina kegalao, egae au aka Saimon, Peto keoma auga kegamaiseina eoma. Isa au aka Saimon aꞌo faagaꞌi eafiꞌi tiapu ekapa auga fou keague. Egaꞌina auga ega eꞌa aꞌu niegai eoma. ");
INSERT INTO mek_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ega puo fiakoa mo, iifa laulaisa oi iina fomai laoma. Ke oi iina lomai auga felo ipauma lokapaisa. Ke Deo kapaꞌina oi maamuai eifa kapulania auga maꞌoai lai maamaisai mogafegafe moifafou afeꞌainiꞌi. Lai egaꞌina aꞌo amalogo aoma puo, pau maꞌoai iina amai Deo agogai akaigugu aꞌimaiso,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ega aisama Peto ake epaagalaisa eniniꞌani einaka, “Iifa koꞌa, pau lalogo felo Deo papiau agaꞌomo afegai aeaulao. ");
INSERT INTO mek_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kai ago agaꞌo agaꞌo alogai papiau kapaꞌi Isa kemaniꞌiaina, ke maagai laomai opaiꞌi mo kekapaꞌi auꞌi isafa eafiꞌi ega papiau epamiaꞌi. ");
INSERT INTO mek_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Oi Deo ega iifa Israel papiauꞌi eeꞌiai eulaisa auga ologo felo. Egaꞌina fouga auga, Deo Iesu Kristo eulaisa, ke Iesu kainai papiau Isa fou fekegagao eoma. Ke Iesu auga Israel papiauꞌi mo eꞌi Lopia laaꞌi kai, agofaꞌa fofouga papiauꞌi isafa eꞌi Lopia. ");
INSERT INTO mek_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Iesu egaꞌina ega pinauga aeꞌina koa kai Kalilea agogai Ioane eꞌina einogo papiau eꞌi laomai apalaꞌi fekeumakalainiꞌi, ke baptismo fekeafia eoma auga fouga ologo. ");
INSERT INTO mek_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Egaꞌina afegai Iesu Nasareta auga ega pinauga eꞌina. Ke Deo ega Spiritu efakeopua, isa isapu epeniia. Ke isa Iudea agogai pagua maꞌoai elao aisama, kapa feloꞌi maꞌo ekapaiꞌi ke papiau tiapolo ega isapuai keagu auꞌi epafeloꞌi. Gome Deo Iesu fou keagu. Ke Deo Iudea ago fofouga alogai iina epinauga oma, kapa maꞌoai kegama auꞌi, oi aꞌoꞌi ologoniꞌi efua. ");
INSERT INTO mek_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Isa Iudea agogai, ke Ierusaleme taonina fofouga alogai, kapa maꞌoai ekapaiꞌi auga lai ifomai maamaisai aisaꞌi, ke pau koꞌa mo aifafoua. Papiau isa kolotiai keauꞌuꞌua kepamaea. ");
INSERT INTO mek_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Kai kina oiso aisama, Deo isa maeai epamaunimue. Egaꞌina afegai Deo isa lai epakinaimai. ");
INSERT INTO mek_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ke papiau maꞌoai isa akeisa. Kai Deo ega logoai lai ekina kakaumai, ke maeai emaunimue afegai fou aaniani aumai mo isa aisa. ");
INSERT INTO mek_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ke Deo lai eifa kapula penimai, Deo isa ekinaga mae auꞌi, ke maaꞌi maunina auꞌi fou, eꞌi laomai felo, o apala afa agepeniꞌi auga papiau maꞌoai maaꞌiai fainogonia, ke koꞌa mo auga faifafoua eoma. ");
INSERT INTO mek_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ke profeta maꞌoai koꞌa mo keifafou kakaua keinaka, isa akagai kaisau mo isa akepakoꞌania auꞌi, Deo isa eꞌi laomai apalaꞌi ageꞌagegeainiꞌi eoma.” ");
INSERT INTO mek_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Peto egaꞌina iifaꞌi eifaifaniꞌi kai, Deo ega Spiritu papiau maꞌoai isa ega iifa aꞌo kelogonia auꞌi eake peniꞌi. ");
INSERT INTO mek_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ke Iudea pakoꞌa papiauꞌi maguaeꞌi faaga iifalaina emia auꞌi, Peto fou kemai egae auꞌi, Deo ega Spiritu ega ipeni Iudea papiauꞌi laaꞌi auꞌi mo ganinagai epeniiꞌi keisa aisama, kekauai alogaina. ");
INSERT INTO mek_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Gome isa Iudea papiauꞌi laaꞌi auꞌi, mala iꞌoina iꞌoinagai kemegamega Deo keau afagaina ainaꞌi kelogonia. ");
INSERT INTO mek_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ega aisama Peto eifa einaka, “Iꞌina papiauꞌi, lai koa iꞌopomai, Deo ega Spiritu keafiia efua. Ega puo feisai baptismo alapeniꞌi auga kai agaꞌo ageifa apua afaekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ke Peto pakoꞌa papiauꞌi eifa kapula peniꞌi, Lopia akagai baptismo fekeafia eoma. Ke baptismo keafiia efua aisama, Peto kepainia kina pika koa mo fou fekeagu keoma. ");
INSERT INTO mek_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Iudea ago fofouga alogai apostolo, ke pakoꞌa papiauꞌi, Iudea papiauꞌi laaꞌi auꞌi isafa Deo ega iifa keafiia auga fouga kelogo. ");
INSERT INTO mek_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ega puo Peto emue Ierusaleme taonina emai aisama, Iudea pakoꞌa papiauꞌi, maguaeꞌi faaga iifalaina emia auꞌi Peto keifa apala penia. ");
INSERT INTO mek_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ke keinaka, “Oi au maguaeꞌi faaga iifalaina gouga akeafia auꞌi eꞌi eꞌai lokoko fou oaniani,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kai Peto faagagai kapa maꞌoai kemia auga gomegai eꞌina okogai epakaisa isa maaꞌiai eifania einaka: ");
INSERT INTO mek_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Lau Joppa taoninai laagu lamegamega. Ke eꞌu megamegai maau elaulau, ke kapa agaꞌo tiapu akaikiꞌa koa iꞌopoga, kiuga pani apaꞌuai koa kegopeisa ufai eake emai eeuai. ");
INSERT INTO mek_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ke lau maau elao laisa felo aisama, aagoa aꞌoꞌi iꞌoiꞌi iꞌoiꞌi ifeꞌiai imaꞌiai kepea auꞌi, guaꞌiai keku auꞌi fou, ke ufa ineiꞌi iꞌoiꞌi iꞌoiꞌi egaꞌina tiapuga alogai keka laisaꞌi. ");
INSERT INTO mek_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ke aufalao agaꞌo lau iina epaini omaisau aina lalogonia, ‘Peto moꞌue moaupuguꞌi moaniꞌi,’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Kai lau lainaka, ‘Lopia, afaekaina! Gome kapa agaꞌo apala, o ofuga auga lau akeu aekuiku opogaina’ laoma. ");
INSERT INTO mek_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Kai aufalao agaꞌo ufai eifa pugu einaka, ‘Deo kapa maꞌoai ekapaiꞌi feloꞌi eoma auga oi apalaꞌi ofuꞌi folooma,’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ega koa iꞌopoga oiso emia afegai, Lopia kapa maꞌoai ufai eꞌagauainiꞌi pugu. ");
INSERT INTO mek_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Ega aisama pau mo Sisarea taoninai au oiso keulaiꞌi auꞌi, lau laagu eꞌa paꞌafina akegai keapakipo. ");
INSERT INTO mek_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ke Deo ega Spiritu epainiau, fou agalao auga eegai opou falapamaꞌo eoma. Ke lau aau akiu pakoꞌa auꞌi imagea iꞌina auꞌi keisaoniau fou Sisarea taonina alao Konelius ega eꞌai akoko. ");
INSERT INTO mek_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Egae kai Konelius ega eꞌai agelo isa ala eapakina peni oma, ke kapaꞌina eifania auga, lai maamaisai eifafoua einaka, ‘Papiau isaꞌi moulaiꞌi Joppa taonina kegalao au aka Saimon Peto keoma auga fekemaiseina. ");
INSERT INTO mek_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ke isa oi ke emu famili papiauꞌi maꞌoai fou maamiai Deo ega iifa ageifafoua. Ke egaꞌina iifaga oi kaniami ageagamauga,’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Ke egae laꞌina laniniꞌani aisama, Deo ega Spiritu eꞌina lai eake penimai koa iꞌopoga, isa isafa eake peniꞌi. ");
INSERT INTO mek_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ega aisama Lopia ega iifa maamaisai iina eifa oma auga laopolaga, ‘Ioane iifa koꞌa feisai baptismo epipeni kai, oi auga Deo ega Spirituai baptismo agoafia,’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ega puo lai Lopia Iesu Kristo apakoꞌania aisama, Deo ega ipeni Spirituga epeniimai koa iꞌopoga, isa isafa Iesu kepakoꞌania aisama, Deo ega ipeni Spirituga epeniiꞌi. Ega koa aisama, lau auga kai puo Deo ago alakaina? Iifa gome lau Deo ago alakaina afaekaina,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Iudea pakoꞌa papiauꞌi iꞌina iifaga aꞌo kelogonia aisama, komo mo keoma. Ke Deo keau afagaina keinaka, “Iifa gome Deo ega Spiritu Iudea papiauꞌi laaꞌi auꞌi isafa eulai peniꞌi, ke isa eꞌi laomai apalaꞌi keumakalainiꞌi, ke mauni mamaga isafa epeniꞌi,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Pau papiau Ierusaleme taoninai pakoꞌa papiauꞌi keafi apalaniꞌi, ke Stefano kepoai kefoupugua auga faagagai, pakoꞌa papiauꞌi kekani okaoka. Isa isaꞌi kelao mo Fenisia agogai, ke isaꞌi kelao mo Saiprus keleipuagai, ke isaꞌi kelao mo Antiok taoninai. Ke isa iifa faunina Iesu fouga kai agaꞌo aage maagai akeinogonia kai, Iudea papiauꞌi mo maaꞌiai keinogonia. ");
INSERT INTO mek_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kai epoꞌiai au isaꞌi auga Saiprus keleipuaga, ke Sairene ago auꞌi. Isa kelao Antiok taoninai aisama, Iudea papiauꞌi Grik malagai keniniꞌani auꞌi isafa maaꞌiai, iifa faunina Lopia Iesu fouga keinogonia. ");
INSERT INTO mek_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ke Lopia ega isapu eeꞌiai eka epalagainiꞌi, ke papiau maꞌo aloꞌi eponi Iesu kepakoꞌania keaipenia. ");
INSERT INTO mek_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Iꞌina iifaga efoufaꞌa Ierusaleme taoninai pakoꞌa papiauꞌi fouga kelogo, ke isa Banabas keulaisa felao mo Antiok taoninai keoma. ");
INSERT INTO mek_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ke isa elao Antiok taoninai aisama, Deo ega gafegafe akaikiꞌa isa isafa epeniiꞌi eisa, ke alo egama alogaina. Ke magogo kapula epeniiꞌi, maꞌoai aloꞌi guaꞌi fofougai Lopia fekepakoꞌania fekeagu felo faefuafua eoma. ");
INSERT INTO mek_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Gome Banabas auga au felo ipauma, Deo ega Spiritu alo epogu, ke alo koꞌagai Deo epakoꞌania. Ke papiau maꞌo paisa Lopia kepakoꞌania, ke pakoꞌa papiauꞌi auꞌi maꞌo emia. ");
INSERT INTO mek_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Egae kai Banabas Saulo ikapuga Tarsus taonina elao. ");
INSERT INTO mek_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ke elao Tarsus taoninai Saulo eisa aisama, eafiia fou kemue Antiok taonina kelao. Egae Banabas Saulo auniꞌi inipo agaꞌo fofouga keagu, pakoꞌa papiauꞌi maꞌo paisa fou kekaigugu, ke papiau maꞌo kepamaleleniꞌi. Ke egae Antiok taoninai papiau iꞌoiꞌi pakoꞌa papiauꞌi aka mamaga kepeniiꞌi keꞌina keifaniꞌi ‘Kristiano’ keoma. ");
INSERT INTO mek_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Egaꞌina kinaꞌi alogai, profeta isaꞌi Ierusaleme taoninai kemai, ke kelao Antiok taoninai kekoko. ");
INSERT INTO mek_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Isa epoꞌiai au agaꞌo aka Akabus eꞌue eapa Roma papagai keagu agofaꞌa fofouga alogai, magea akaikiꞌa agemia auga fouga Deo ega Spiritu epaopolaga puo eifafoua. (Sisa Klaudius papiau eꞌimaꞌi kinagai iꞌina mageaga Akabus eifania koa iꞌopoga mo emia.) ");
INSERT INTO mek_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ega aisama Antiok taoninai pakoꞌa papiauꞌi agaꞌo agaꞌo eꞌi agu kainai, Iudea ago pakoꞌa papiauꞌi eeꞌiai moni fekeulaisa fekepalagainiꞌi keoma auga iifaga kepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ke kepakoꞌania koa iꞌopoga, pakoꞌa papiauꞌi eꞌi pipalagai monina kepakai guguaina, Saulo Banabas auniꞌi imaꞌiai kepaaua keafiia kelaoaina Ierusaleme taoninai au akaikiꞌaꞌi pakoꞌa papiauꞌi keꞌimaꞌi auꞌi kepeniiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Pau egaꞌina kinaꞌiai kin Herod, pakoꞌa papiauꞌi gaafi apalaniꞌi eoma puo, ega papiau eulaiꞌi, pakoꞌa papiauꞌi epoꞌiai isaꞌi keafiiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ke Herod ega iifai, apostolo agaꞌo Ioane aaga, James ifani aꞌifagai aiso kefoua emae. ");
INSERT INTO mek_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ke Herod iꞌina laoga mainai Iudea papiau aloꞌi epagama auga eisa kainai, ealogai Peto isafa gaafia eoma. Egaꞌina auga Iudea eꞌi miamia aka ‘Pasover,’ palafa iuma mulamula laaꞌi kai, palafa mainiꞌi mo keania kinagai emia. ");
INSERT INTO mek_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herod ega au auꞌi kelao Peto keafiia kemaiseina aisama, isa eafiia tipulai epaagua. Ke ega ifani auꞌi 16 eulaiꞌi pani pani aufa eꞌi kina maagai kemai Peto keꞌimaisa. Ega koa ekapaisa eopolaga, egaꞌina miamiaga agefua afegai kai, Peto papiau agoꞌiai iifa fepakaisa eoma. ");
INSERT INTO mek_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ega puo Peto tipula eꞌagai mo kepaagua. Kai pakoꞌa papiauꞌi auga, isa faugai aloꞌi koꞌagai Deo kemegamega peni kapulania. ");
INSERT INTO mek_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ke Herod agegani aisama, Peto papiau agoꞌiai iifa fepakaisa eoma. Egaꞌina kina gapiai, tipulai tieini auniꞌi keafiiꞌi Peto ima agaꞌo ifani auga agaꞌo imagai kepaaga. Ke ima apie ifani auga agaꞌo imagai kepaaga kai, auniꞌi epoꞌiai efeu. Ke imaꞌima auꞌi isafa tipula paꞌafina akegai keapa keꞌimaꞌima. ");
INSERT INTO mek_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Egaꞌina alogai fiakoa mo Deo ega agelo emai Peto eegai eapa. Ega aisama eaea akaikiꞌa tipula alo epogu. Ke agelo Peto mape ekoninia epagonia einaka, “Moꞌue fiakoa,” eoma. Ke Peto imagai tieini keꞌualai. ");
INSERT INTO mek_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ke agelo Peto epainia einaka, “Emu tiapu moiꞌiukaꞌi ifemu kamataga mogafauka,” eoma. Ke Peto agelo eifa koa ekapaisa. Ke agelo eifa pugu einaka, “Oi afemu tiapuga moapuga muniuai mai,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ega puo Peto agelo muninai epea auniꞌi tipula afugai kepealai. Ke agelo kapaꞌina ekapaisa auga koꞌa ipauma kai, Peto aelogo, eopolaga maaga elaulau eoma. ");
INSERT INTO mek_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ke agelo Peto auniꞌi kemai imaꞌima auꞌi keapaufai auꞌi kepeaꞌegainiꞌi. Ke imaꞌima auꞌi muniai keapa auꞌi isafa kepeaꞌegainiꞌi. Ke kemai taoni keagaga emai, auli paꞌafina akegai aisama, paꞌafi ifo eagalai kepealai. Ke agelo Peto fou kelao keaga kiuga agaꞌogai kepealai aisama, agelo fiakoa mo Peto epuaꞌafuga. ");
INSERT INTO mek_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ke Peto kapaꞌina faagagai emia auga elogo aisama, ifo alogai einaka, ‘Herod feaupuguisau eoma, ke Iudea papiauꞌi kapaꞌina agemia fekeisa keoma. Kai paukai lalogo iifa gome Deo ega agelo eulaisa kaniau eagamauga,’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ke kapaꞌina emia auga elogo aisama, opainai elao Ioane, aka Mako keoma auga ina Maria ega eꞌai. Egae papiau maꞌo kekaigugu kemegamega. ");
INSERT INTO mek_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ke Peto egaꞌina eꞌa afe paꞌafina eꞌinipia alogai, kalaꞌafi ifiaoga aka Roda emai paꞌafi gapaagalaisa eoma. ");
INSERT INTO mek_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kai isa Peto aina elogonia aisama, alo egama alogaina puo, paꞌafi ipaagalaina eꞌagege, epiaukoko eꞌa alogai kelaꞌafou kemegamega auꞌi epainiꞌi einaka, “Peto eꞌa afegai eapae,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Kai isa ifiao kepainia keinaka, “Oi lokafoꞌo!” keoma. Kai isa aeapakipo eifa kapula einaka, “Koꞌa ipauma!” eoma. Ega puo isa keinaka, “Lai aopolaga isa ega agelo maꞌe!” keoma. ");
INSERT INTO mek_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Kai Peto paꞌafi eꞌinipia aeapakipo. Ega puo isa kelao paꞌafi kepaagalaisa Peto keisa aisama kekauai alogaina. ");
INSERT INTO mek_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Kai Peto ima eafiakae komo kegaoma eoma. Egae kai Lopia isa tipula eꞌagai ala epapealai oma auga fouga maaꞌiai eifafoua. Ke egaꞌina eifaniꞌi efua aisama epainiꞌi einaka, “Folao James, ke pakoꞌa papiauꞌi fou maaꞌiai iꞌina fouga foifafoua,” eoma. Egaꞌina eifania afegai epuaꞌafuniꞌi, afu iꞌoina elao. ");
INSERT INTO mek_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Egani aisama ifani auꞌi Peto akeisa puo ifoꞌi mo epoꞌiai kepaꞌani, “Peto faagagai kapaꞌina emia,” keoma. Kai kapaꞌina emia auga akelogo puo, ifoꞌi mo epoꞌiai aꞌoaꞌo akaikiꞌa ipauma eꞌuegekae. ");
INSERT INTO mek_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Kai Herod ifani auꞌi eifa kapula peniꞌi, afu maꞌoai fekelao Peto fekekapuga eoma. Ke isa afu maꞌoai kelao Peto kekapunia kai akeisa aisama, Herod imaꞌima auꞌi epagagaꞌi. Kai isa kapaꞌina emia auga akelogo puo, gua ekupu alogaina, ega iifai isa fekemae eoma. Egae kai Herod Iudea ago epuaꞌafuga Sisarea taonina elao egae eagu. ");
INSERT INTO mek_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ega kinaꞌiai Herod Taire ke Sidoni taoniꞌi papiauꞌi eeꞌiai gua ekupu alogaina. Kai isa maꞌoai kemai kekaigugu kai eega kelao. Ke isa kelao Blastus, Herod epakoꞌania ega eꞌa epaꞌima auga fou kepaekefaꞌa puogai, isa eega kelao kaukau, kegoinia Herod fou fekegagao keoma. Gome egaꞌina papiauꞌi eꞌi foꞌama, kin Herod ega agoai keafiia. ");
INSERT INTO mek_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ega puo Herod kina agaꞌo ekinaga kinagai, papiau fou kelaꞌafou, ke isa ega lopia tiapuga eiꞌiuka, ke ega aguagu afugai eagu kai, laꞌafouai papiau maaꞌiai eniniꞌani. ");
INSERT INTO mek_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ega aisama papiau keagaga keinaka, “Iꞌina auga papiau aumauni ainaꞌi laaꞌi kai, deo agaꞌo koa aina,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ega aisama fiakoa mo, Lopia ega agelo agaꞌo isa eauniia, gome papiau isa keau afagaina auga aꞌo elogonia kai, isa egaꞌina au afagaina Deo aepalao penia. Ke Lopia ega isapuai ugeuge Herod keaniia elao mo emae. ");
INSERT INTO mek_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kai egaꞌina kinaꞌiai Deo ega iifa epea efoufaꞌa. ");
INSERT INTO mek_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ke Banabas Saulo auniꞌi Ierusaleme taoninai, pakoꞌa papiauꞌi kepalagainiꞌi efua aisama, Ioane Mako keoma auga isafa keafiia fou kemue Antiok taonina kelao. ");
INSERT INTO mek_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Pau Antiok taoninai pakoꞌa papiauꞌi epoꞌiai, profeta ke pamalele auꞌi isafa keagu. Iꞌina auꞌi auga Banabas, Simion Niker keoma auga, Lusius Sairene taonina auga, Manaen, kin Herod auniꞌi kefaꞌa auga, ke Saulo. ");
INSERT INTO mek_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Isa Lopia keau afagaina, ke keani gopegope kemegamega alogai, Deo ega Spiritu isa epainiꞌi einaka, “Lau eꞌu logoai Banabas ke Saulo auniꞌi lakinaniꞌi efua. Isa oi epomiai amoafilaiꞌi, fekelao eꞌu pinauga alapainiꞌi fekekapaꞌi alaoma auga fekekapaꞌi,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ke keani gopegope, kemegamega, ke Banabas Saulo auniꞌi Deo ega pinauga akekapa faugai, imaꞌi kaniaꞌiai keogeaua afegai aisama, keulaiꞌi kelao. ");
INSERT INTO mek_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ega puo Deo ega Spiritu epapeaꞌi kainai, isa kelao Seleusia. Ke egae lontiai keaguka kepagai kelao Saiprus keleipuagai. ");
INSERT INTO mek_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ke kelao Salamis ufapogai keofau aisama, kelao Iudea papiauꞌi eꞌi laꞌafou afugai Deo ega iifa keinogonia. Egaꞌina kekapaisa alogai, pipalagai auga Ioane Mako keoma auga isafa fou keagu epalagainiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Egaꞌina afegai kepea kelao Pafos taoninai, Saiprus keleipuaga kua apiegai aisama, egae Iudea ugauga auga aka Ba-Iesu profeta fogefoge auga keisa. ");
INSERT INTO mek_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Iꞌina auga kansolo kaniaꞌiai auga aka Serkius Paulus fou keagu. Egaꞌina kansologa eikifa alogaina. Ke isa Deo ega iifa aꞌo galogo eoma puo, Banabas Saulo auniꞌi eeꞌiai iifa eulaisa, isa eega kegamai eoma. ");
INSERT INTO mek_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kai kemai aisama, ugauga egaꞌina Ba-Iesu, ke Grik malagai keifaga Elimas keoma auga isa ekaisapuꞌi. Ega koa ekapaisa keaga agaꞌo ekapunia kansolo egaꞌina gakaisapua, Deo ega iifa aꞌo faelogo, Iesu faepakoꞌania gamunia eoma. ");
INSERT INTO mek_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ega aisama Saulo, keifaga Paulo keoma auga, Deo ega Spiritu alo epogu, isa maaga alo ipauma eisa, ke eifa einaka: ");
INSERT INTO mek_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Oi tiapolo gauga! Oi pifoge kapaꞌi iꞌoiꞌi iꞌoiꞌi alomu epogu. Ke kina maꞌoai alo opai laoꞌi maiꞌi kekapakapa auꞌi lokaisapuꞌi. Ega puo kina maꞌoai Deo ega iifa lokaisapua, pifogeai lopafaefania aefuafua. ");
INSERT INTO mek_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Moisa, pau Lopia ima isapugai afa apala agepenio, maamu agepakimiꞌinia, kina eaea afoloisa, agelao Deo emu apala ageꞌagegeainiꞌi afegai kai,” eoma. Ke fiakoa mo ama ke umina akaikiꞌa apuapu koa iꞌopoga isa maaga ekaisapua afu aeisa. Ke eafi gapunini papiau agaꞌo imagai gaafi gapalagaina eoma. ");
INSERT INTO mek_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kansolo egaꞌina ugauga auga faagagai kapaꞌina emia eisa aisama, Lopia epakoꞌania. Gome isa Lopia ega pamalele aꞌo elogonia ekauai alogaina. ");
INSERT INTO mek_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo ke ega au fou Pafos taonina kepuaꞌafuga lontiai kepagai Pamfilia ago Perka taonina kelao. Egae Ioane Mako keoma auga isa epuaꞌafuniꞌi emue Ierusaleme taonina elao. ");
INSERT INTO mek_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Egae kai Perka taonina kepuaꞌafuga kelao, Pisidia ago Antiok taoninai kepealai. Egae Iudea papiauꞌi Deo keau afagaina kinagai, Paulo Banabas auniꞌi kelao laꞌafou afugai kekoko keagukipo. ");
INSERT INTO mek_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ke egae Deo ega iifa puka kekuapinia, agaꞌo Moses ega iifa ke agaꞌo auga profeta eꞌi iifa kekuapinia. Egaꞌina pukaꞌi kekuapiniꞌi efua aisama, laꞌafou afuga keꞌima auꞌi au agaꞌo keulaisa elao Paulo Banabas auniꞌi epainiꞌi einaka, “Aamai akimai Iudea aumi, iꞌa aꞌa papiau fauꞌiai, emi magogo akaikiꞌa fepakapulaniꞌi auga agaꞌo ekaega koa, amogafegafe amoifania,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ega puo Paulo eꞌue eapa aina kegalogo eoma puo ima eafiakae ke einaka, “Israel papiaumi ke Iudea papiaumi laaꞌi aumi, Deo oau afagaina aumi ainau amologo! ");
INSERT INTO mek_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel papiauꞌi eꞌi Deo lai ufumai apamai ekinaniꞌi Isiptoai au aꞌiꞌi koa iꞌopoꞌi kemia keagu aisama, epakaisogoniꞌi eafiakaeꞌi. Ega puo isa auꞌi maꞌo emia. Egae kai ega isapu kapula ipaumagai Isiptoai epapealaiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Egaꞌina afegai inipo 40 ago maininai kepea aisama, Deo aina akeafia, kapa maꞌo apalaꞌi Deo eegai kekapaiꞌi. Kai Deo isa eꞌi laomai apalaꞌi eafiapiꞌi mo. ");
INSERT INTO mek_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ke isa Kanaan agogai, ago imagea kuagai gua papiauꞌi eauokaꞌi afegai aisama, egaꞌina agoꞌi eꞌeaisa Isa ega papiau auꞌi apuꞌi epamia. ");
INSERT INTO mek_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Isa Isiptoai kepealai Kanaan agoꞌi keafiiꞌi ke inipo 450 alogai egae keagu. “Egae kai Deo egaꞌina papiauꞌi, eꞌi imaꞌima auꞌi epeniiꞌi isa keꞌimaꞌi mo elao profeta Samuel eagu miagai. ");
INSERT INTO mek_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ke profeta Samuel isa eꞌimaiꞌi alogai, papiau Samuel kepainia kin agaꞌo gapeniꞌi gaꞌimaꞌi keoma. Ega puo Deo Benjamin ikupuga auga aka Kis gauga Saulo ekinaga epeniiꞌi. Ke Saulo inipo 40 isa eꞌimaꞌi. ");
INSERT INTO mek_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kai Deo kin Saulo epaapaꞌaua afegai aisama, Davide ekinaga isa eꞌi kin epamia. Ke Deo Davide fouga iina eifa oma, ‘Lau Jese gauga Davide, Lau maauai au felo ipauma, anina laani alogaina auga lakapulaisa. Ke Lau kapa maꞌoai aniꞌi laani fekapaꞌi laoma auga agekapaꞌi,’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Deo pakoꞌa iifaga ekapaisa koa iꞌopoga, Davide okogai Israel papiauꞌi kaniaꞌi isagamauga auga, Iesu eulaisa emai. ");
INSERT INTO mek_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kai Iesu aemai koa kai, Ioane Israel papiauꞌi maꞌoai einogoniꞌi, eꞌi laomai apalaꞌi fekeumakalainiꞌi, ke baptismo fekeafia eoma. ");
INSERT INTO mek_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ke Ioane ega pinauga afaꞌagamo epafua alogai, Israel papiauꞌi iina epaini omaꞌi einaka, ‘Oi oopolaga lau kaisau ooma? Oi oꞌima auga lau laaꞌi. Kai amoisa, isa auga lau muniuai agemai. Ke lau isa ife kamataga alagupuka afaekaina’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Aau akiu, Abraham okogai omai aumi, ke Iudea papiaumi laaꞌi kai Deo oau afagaina, ega iifa kainai opea aumi, Deo iꞌa kaniaꞌa isagamauga iifaga eulaisa oi eemi emai. ");
INSERT INTO mek_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Gome Ierusaleme taoninai keagu papiauꞌi eꞌi lopia auꞌi fou, Iesu kaisau auga oko akelogo. Ke profeta kapaꞌina keifania auga aufa kina Deo keau afagaina kinaꞌiai kekuapiniꞌi mo ganinagai, oko akelogo kainai isa faagaꞌiai Iesu femae keoma iifaga auga koꞌa mo emia. ");
INSERT INTO mek_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ke egaꞌina papiauꞌi isa femae auga gome ipauma auga akekapulaisa mo ganinagai, isa Pilato kegoinia fekeaupugua keoma. ");
INSERT INTO mek_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ke isa fouga Deo ega iifa pukagai kepapuaꞌi auꞌi faagagai kekapa afeꞌainiꞌi afegai aisama, kolotiai keafiopua laai keogeisa. ");
INSERT INTO mek_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Kai Deo isa maeai epamaunimue. ");
INSERT INTO mek_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Egae kai kina maꞌo alogai papiau Kalilea ago kepuaꞌafuga, isa fou Ierusaleme taoninai kemai auꞌi eapakina peniꞌi. Pau isa iꞌa aꞌa papiau maaꞌiai Iesu fouga koꞌa auga keifafoua. ");
INSERT INTO mek_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Ke pau iifa faunina Iesu fouga oi maamiai aifafoua. Egaꞌina auga ufainagai Deo iꞌa ufuꞌa apaꞌa maaꞌiai Iesu maeai agepamaunimue auga epakoꞌania eifania. ");
INSERT INTO mek_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Deo pau pakoꞌa iifaga egaꞌina iꞌa ufuꞌa apaꞌa egaꞌina okoꞌiai amai auꞌa, fauꞌaisai koꞌa mo epamia, Iesu maeai epamaunimue. Egaꞌina emia auga Isa ega iifa pukagai Sam 2 alogai iina eifa oma koa iꞌopoga mo emia: “‘Oi Lau Gau, pau Lau oi Amamu lamia,’ eoma ");
INSERT INTO mek_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Deo Iesu epamaunimue, ke imaauga aepuaꞌafuga aefoka auga fouga Deo ega iifa pukagai iina eifa oma: “‘Ufainagai Davide maagai lapakoꞌania laifania, isa okogai akemai auꞌi eꞌu pipeni fauniꞌi alapeniꞌi laoma. Ega koa iꞌopoga pau Lau Gau, oi faagamuai alakapa,’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ega puo Sam pukagai afu agaꞌogai isafa Iesu maeai emaunimue auga fouga iina eifa oma: “‘Oi ainamu eafia maamuai Alo Elolofa Auga imaauga afolopuaꞌafuga afaefoka,’ eoma. ");
INSERT INTO mek_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Gome Deo ega logoai anina eani, Davide eagu miagai papiau keagu auꞌi eꞌi pinauga fekapa eoma auga ekapaisa efua afegai emae. Ke isa imaauga keafiia ufuga apa kefufuniꞌi auꞌi eeꞌiai kefufunia, ke isa imaauga efoka. ");
INSERT INTO mek_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kai Deo Iesu maeai epamaunimue, imaauga aefoka. ");
INSERT INTO mek_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Ega kainai aau akiu, oi kapaꞌina fologo laoma auga alaifania. Isa faagagai Deo oi emi laomai apalaꞌi ageꞌagegeainiꞌi auga fouga maamiai aifafoua. ");
INSERT INTO mek_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ke oi Moses ega iifa maꞌoai kaiꞌiai fopea alo opai aumi fomia auga aekainia. Kai kaisau isa kepakoꞌania auꞌi, isa faagagai alo opai auꞌi kemia. ");
INSERT INTO mek_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ega puo foꞌima feloimi ega koa ufainagai profeta iina keifa oma auga oi faagamiai faemia: ");
INSERT INTO mek_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“‘Amoisa! Oi Lau kapaꞌina laifania auga eegai oifa apala, opamafua aumi! Oi emi aguagu kina alogai eemiai kapa agaꞌo apala ipauma alakapa. Ke faagamiai apala ipauma agemia aisama, agoisa agokauai alogaina agomae. Gome oi emi agu kinagai kapa agaꞌo alakapa, ke aufalao agaꞌo egaꞌina iifaga oi maamiai ageifafoua mo ganinagai, afolopapakoꞌania,’” eoma. ");
INSERT INTO mek_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulo einogo efua Banabas auniꞌi Iudea papiauꞌi eꞌi laꞌafou afuga kepuaꞌafuga kelao. Egaꞌina alogai papiau isa kepainiꞌi, Deo keau afagaina kina agaꞌogai fekemai pugu, egaꞌina iifaꞌi fekeinogoainiꞌi pugu keoma. ");
INSERT INTO mek_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Egaꞌina laꞌafouga ekani aisama, Iudea papiauꞌi maꞌo ke Iudea papiau laaꞌi kai Iudea eꞌi kagakaga muninai kepea auꞌi fou, Paulo Banabas auniꞌi muniꞌiai kepea. Ke Paulo Banabas auniꞌi isa fou keniniꞌani, magogo kapula kepeniiꞌi kina maꞌoai Deo ega gafegafe akaikiꞌa isapugai fekeagu felo keoma. ");
INSERT INTO mek_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","“Ke iifi agaꞌo elao afegai, Deo keau afagaina kinagai aisama, Antiok taoninai papiau fofouga koa iꞌopoga kemai laꞌafou afugai kekaigugu Deo ega iifa aꞌo kegalogo keoma. ");
INSERT INTO mek_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kai Iudea papiauꞌi laꞌafou akaikiꞌa keisa aisama, aloꞌi pikupa epogu. Ke Paulo kapaꞌina eifania auꞌi eeꞌiai keifa apala. ");
INSERT INTO mek_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ega aisama Paulo Banabas auniꞌi aloꞌi eaipa ke keifa keinaka, “Lai Deo ega iifa, oi Iudea papiaumi maamiai faifa kakaua auga ekainia puo aifania. Kai oi iꞌina oumakalaina, ke agu pagai maunina foafia auga ifomi oisami aekainimi ooma. Ega kainai amoisa, lai Iudea papiau laaꞌi auꞌi aaipeniꞌi. ");
INSERT INTO mek_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Gome Lopia lai epaini kapulanimai iina eifa oma: “‘Lau oi Iudea papiauꞌi laaꞌi auꞌi fauꞌiai eaea lapamiaimi. Ega koa oi agofaꞌa fofouga papiauꞌi eeꞌi folao kaniaꞌi foagamauga,’” eoma. ");
INSERT INTO mek_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ke Iudea papiauꞌi laaꞌi auꞌi iꞌina iifaga aꞌo kelogonia aisama aloꞌi egama alogaina. Ke Lopia ega iifa kapa akaikiꞌa kepamia. Ke Deo ega logoai ekinaniꞌi agu pagai maunina afuga epeniiꞌi auꞌi maꞌoai Iesu kepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ke Lopia Iesu fouga egaꞌina ago fofouga epeaisa. ");
INSERT INTO mek_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kai Iudea papiauꞌi kelao Antiok taonina keꞌima auꞌi, ke Iudea papiauꞌi eꞌi kagakaga kainai kepea auꞌi akaikiꞌaꞌi auꞌi akafaꞌi fou eeꞌiai. Ke aloꞌi keaniia kepaafiꞌi Paulo Banabas auniꞌi keafi apalaniꞌi, ke agoai kepapealaiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ega puo Paulo Banabas auniꞌi, isa iifa faunina Iesu fouga keumakalaina kainai kemuni apuꞌi, afakemai pugu gouga kekapaisa ifeꞌi aeapuga keauopuaina. Egae kai Antiok taonina kepuaꞌafuga Ikonium taonina kelao. ");
INSERT INTO mek_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kai Antiok taoninai Iesu kepakoꞌania papiauꞌi, Deo ega Spiritu aloꞌi epogu, ke aloꞌi egama alogaina. ");
INSERT INTO mek_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Paulo, Banabas auniꞌi kelao Ikonium taoninai aisama, aufa kina kekapakapa koa iꞌopoga kekapaisa, kelao Iudea papiauꞌi eꞌi laꞌafou afugai kekoko. Egae Deo ega isapuai Deo ega iifa papiau maaꞌiai keifa kapulania. Ega puo Iudea papiauꞌi ke Iudea papiau laaꞌi auꞌi maꞌo paisa Iesu kepakoꞌania. ");
INSERT INTO mek_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kai Iudea papiauꞌi isaꞌi Iesu akepakoꞌania auꞌi kelao Iudea papiauꞌi laaꞌi auꞌi aloꞌi keaniia. Ega koa kekapaisa, Iudea papiau laaꞌi auꞌi opoꞌi kepalifu alogaina. Ega puo Ikonium taoninai Iudea papiauꞌi laaꞌi auꞌi Iesu kepakoꞌania papiauꞌi, ke Paulo, Banabas auniꞌi fou keumakalainiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ega puo Paulo Banabas auniꞌi kina maꞌo egaꞌina taoninai keagu. Ke egae keagu alogai aimaniꞌiꞌi mo Lopia Iesu fouga papiau maaꞌiai keifafoua. Ke Lopia isa epalagainiꞌi puo mirakulo ke isapu gouꞌi akaikiꞌaꞌi kekapaiꞌi. Ega koa kekapaisa, Deo ega gafegafe pipenina isa epeniiꞌi auga fouga koꞌa mo emia. ");
INSERT INTO mek_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kai Ikonium taoninai papiau ifoꞌi keꞌeaiꞌi, isaꞌi Iudea papiauꞌi afeꞌiai keaulao, ke isaꞌi auꞌi apostolo afeꞌiai keaulao. ");
INSERT INTO mek_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ega aisama Iudea papiauꞌi, Iudea papiau laaꞌi auꞌi, ke isa keꞌimaꞌi auꞌi fou epoꞌiai iifa kepaapa apostolo fekeafi apalaniꞌi kepoai fekefoupuguꞌi keoma. ");
INSERT INTO mek_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kai apostolo iꞌina iifaga fouga kelogo puo, kepiaukoko Likaonia ago akaikiꞌa kelao. Ke kelao egae aisama, Listra ke Derbe taoniꞌiai kekoko, ke egae kai kelao egaꞌina taoniꞌi afeꞌiai isafa aloꞌiai kekoko. ");
INSERT INTO mek_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ke egae papiau maaꞌiai iifa faunina Iesu fouga keinogonia. ");
INSERT INTO mek_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Paulo Banabas auniꞌi Listra taoninai keagu, iifa faunina Iesu fouga keinogonia alogai, au agaꞌo mauniai ife emelo aepeapea auga isafa egae eagu. ");
INSERT INTO mek_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Egaꞌina auga Paulo eniniꞌani auga aina elogonia. Ke Paulo maaga elao melo auga eisa, ke au egaꞌina epakoꞌania felo agemia auga eisa elogo. ");
INSERT INTO mek_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ega aisama eifa akaikiꞌa einaka, “Moꞌue ifemuai moapa opai,” eoma. Ke fiakoa mo melo auga egopoꞌuege eꞌina epea. ");
INSERT INTO mek_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pau laꞌafou papiauꞌi Paulo kapaꞌina ekapaisa auga keisa aisama, Likaonia malagai aisoꞌi gomegai keagaga keinaka, “Deo iꞌa papiau aumauni koa iꞌopoꞌa emia eake emai eeꞌaisai,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ke Banabas kepafaala, isa eꞌi deo akagai Seus keoma. Kai Paulo isa eꞌi deo akagai kepafaala, Hermes keoma. Gome isa niniꞌani auga. ");
INSERT INTO mek_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Egae kai sakedote Seus keau afagaina eꞌa taoni afegai eapa auga eꞌagai epinauga auga agaꞌo ke kelaꞌafou papiauꞌi fou aꞌo keauniiꞌi, eꞌi deo fekepaꞌa peniꞌi keoma puo, polomakau ke salusalu fou eafiiꞌi emaiseiniꞌi taoni paꞌafina akegai. ");
INSERT INTO mek_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kai apostolo Banabas Paulo auniꞌi fou iꞌina aꞌoaꞌo kelogonia aisama, afeꞌi tiapuꞌi keꞌiꞌiokaꞌi, laꞌafou alogai kepiaukoko keagaga keinaka: ");
INSERT INTO mek_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Au, oi kapa puo iꞌina kapaꞌi okapaꞌi? Lai isafa papiau aumauni oi koa iꞌopomi. Kai lai oi maamiai ainogo ega koa oi iꞌina kapaꞌi kapa agaꞌo afakepagama auꞌi fomuniꞌi kai Deo eague aoniamo, ufa, aagoa, aꞌu, ke kapa maꞌoai aloꞌiai epagamaꞌi auga foaipenia aoma. ");
INSERT INTO mek_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ufainagai Deo agofaꞌa maꞌoai epuaꞌafuniꞌi ifoꞌi kapaꞌina anina keani auga mo kekapaiꞌi. ");
INSERT INTO mek_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ega mo ganinagai Isa koꞌa eague auga papiau epakinaꞌi aefuafua. Isa ega gafegafe iꞌa epakinaiꞌa, ufai imu epaꞌaua, ke foꞌama iꞌoiꞌi iꞌoiꞌi aufa eꞌi kinai epeniꞌa. Deo ega koa ekapa foꞌama maꞌo iꞌa epeniꞌa aloꞌa epagama,” eoma. ");
INSERT INTO mek_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Isa egaꞌina iifaga keifania mo ganinagai, laꞌafou kegapaapakipoꞌi aꞌo isa fakepaꞌa peniꞌi keoma auga eꞌinoka alogaina. Kai fuagai kepaapakipoꞌi. ");
INSERT INTO mek_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Egae kai Iudea papiauꞌi isaꞌi Antiok ke Ikonium taoniꞌiai kemai auꞌi, papiau laꞌafou alogai aloꞌi keaniia kelaꞌa pagainiꞌi isa fou kemia. Ke egaꞌina papiauꞌi Paulo kepoai kefounia. Ke kefounia afegai keopolaga emae keoma puo kelaꞌalaisa taoni afe kelaoaina. ");
INSERT INTO mek_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kai Iesu kepakoꞌania auꞌi kelao Paulo keapa lofe aisama, eꞌuegekae taoni alogai ekoko pugu. Ke egani aisama, Banabas auniꞌi Listra taonina kepuaꞌafuga Derbe taonina kelao. ");
INSERT INTO mek_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ke isa Derbe taoninai kekoko iifa faunina Iesu fouga keinogonia, ke egaꞌina papiauꞌi maꞌo paisa kelaꞌa pagainiꞌi Iesu kepakoꞌania afegai aisama, kemue Listra, Ikonium, ke Pisidia ago Antiok taonina kelao pugu. ");
INSERT INTO mek_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ke egaꞌina taoniꞌiai kekoko aisama, pakoꞌa papiauꞌi magogo kapula kepeniiꞌi, Deo fekepakoꞌania ega iifai fekeagu felo keoma. Ke kepainiꞌi keinaka, “Deo ega agofaꞌai amakoko aoma koa aisama, kina maꞌo Iesu faugai papiau akeafi apalaniꞌa, agakiekie kakaua kai, Deo ega agofaꞌai agakoko agekaina,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Egae kai Paulo Banabas auniꞌi egaꞌina taoniꞌiai pakoꞌa papiauꞌi epoꞌiai iifi eꞌa au akaikiꞌaꞌi auꞌi kekinaniꞌi, pakoꞌa papiauꞌi fekeꞌimaꞌi keoma. Ke kekinaniꞌi aisama, keani gopegope, imaꞌi kaniaꞌiai keogeiꞌi ke Deo kepakoꞌania auga kemegamega penia isa fepalagainiꞌi egaꞌina pinauga fekekapa felo keoma. ");
INSERT INTO mek_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ke Pisidia ago kepeaisa efua afegai aisama, kepuaꞌafuga Pamfilia ago kelao. ");
INSERT INTO mek_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ke egae Perka taoninai iifa faunina Iesu fouga keinogonia afegai aisama, kekailai Atalia taonina kelao. ");
INSERT INTO mek_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Atalia taoninai lontiai kemue, Siria ago Antiok taonina kelao pugu. Antiok taonina egaꞌina auga, ufainagai Deo anina eani Paulo, Banabas auniꞌi, Isa Ega pinauga fekekapa eoma. Ega puo pakoꞌa papiauꞌi, Paulo Banabas auniꞌi kekinaniꞌi Deo ega pinauga kepeniiꞌi, Deo ega gafegafe akaikiꞌagai fekekapa keoma. Pau egaꞌina pinauga kepeniiꞌi auga kepafua aisama, kemue kelao egaꞌina afugai pugu. ");
INSERT INTO mek_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ke kemai egaꞌina afugai kekoko aisama, pakoꞌa papiauꞌi keifa kaiguguꞌi. Ke maaꞌiai Deo isa auniꞌi faagaꞌiai kapaꞌina ekapaiꞌi, ke ala koa Deo paꞌafi epaagalaisa Iudea papiau laaꞌi auꞌi Lopia kepakoꞌania auga fouga keifafoua. ");
INSERT INTO mek_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ke egae Iesu kepakoꞌania papiauꞌi fou kina maꞌo keagu. ");
INSERT INTO mek_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Iudea auꞌi isaꞌi Ierusaleme taoninai kemai auꞌi kelao Siria ago Antiok taonina, pakoꞌa papiauꞌi kepamaleleniꞌi keinaka, “Oi Moses ega kagakaga kainai au maguaeꞌi faaga iifalaina gouga faagamiai afolokapa koa aisama, Deo kaniami afaeagamauga,” keoma. ");
INSERT INTO mek_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Iꞌina aꞌoaꞌo puogai Paulo Banabas auniꞌi keꞌue, egaꞌina papiauꞌi kepagagaꞌi ke keakekua alogaina. Ega puo Antiok taoninai pakoꞌa papiauꞌi, Paulo Banabas auniꞌi kekinaniꞌi, ke pakoꞌa papiauꞌi isaꞌi fou fekeulaiꞌi, Ierusaleme taonina fekelao keoma. Ke egae apostolo, ke pakoꞌa papiauꞌi epoꞌiai au akaikiꞌaꞌi auꞌi fekeisaꞌi, iꞌina aꞌoaꞌo fouga maaꞌiai fekeifania keoma. ");
INSERT INTO mek_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ke Antiok taoninai pakoꞌa papiauꞌi, Paulo Banabas auniꞌi, ke pakoꞌa papiauꞌi isaꞌi fou keulaiꞌi kelao alogai, Fenisia ufapoga, ke Samaria agogai kepea pagai. Ke ega mo kelao alogai, pakoꞌa papiauꞌi maaꞌiai Iudea papiauꞌi laaꞌi auꞌi aloꞌi eponi, Deo kepakoꞌania auga keifafoua. Ke pakoꞌa papiauꞌi egaꞌina aꞌo kelogonia aisama, maꞌoai aloꞌi egama alogaina. "