﻿USE sofia;
DROP TABLE IF EXISTS sofia.mee_vpl;
CREATE TABLE mee_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mee_vpl WRITE;
INSERT INTO mee_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Panganana inaekia ke panana te Iesus Karais sisiukia memena. Iesus ka i ae Revit sivuna, ba ka i ae Abaram sivuna. Ba panganana e te Iesus sisiukia memename kinung ke loa minakai roma: ");
INSERT INTO mee_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abaram ka i ae Aisak tamana, bae Aisak ka i ae Iekop tamana, bae Iekop tuna te nge Iura kala nga tataokia bae teiteikia memena, ");
INSERT INTO mee_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","bae Iura ka i ae Peres bae Sera tamarea, bae Peres bae Sera ka nareame nge Tamar, bae Peres ka i ae Esron tamana, bae Esron ka i ae Ram tamana, ");
INSERT INTO mee_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","bae Ram ka i ae Aminarap tamana, bae Aminarap ka i ae Nason tamana, bae Nason ka i ae Salamon tamana, ");
INSERT INTO mee_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","bae Salamon ka i ae Boas tamana, bae Boas ka naname nge Reap, bae Boas ka i ae Obet tamana, bae Obet ka naname nge Rut, bae Obet ka i ae Iesi tamana, ");
INSERT INTO mee_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","bae Iesi ka i ae Revit a i a kelangpatali tamana. Bae Revit ka i ae Solomon tamana, bae Solomon ka naname nga avale laeala a i a Uria napengana pala, ");
INSERT INTO mee_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","bae Solomon ka i ae Reoboam tamana, bae Reoboam ka i ae Abia tamana, bae Abia ka i ae Asa tamana, ");
INSERT INTO mee_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","bae Asa ka i ae Ieosapat tamana, bae Ieosapat ka i ae Ioram tamana, bae Ioram ka i ae Usia tamana, ");
INSERT INTO mee_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","bae Usia ka i ae Iotam tamana, bae Iotam ka i ae Eas tamana, bae Eas ka i ae Esekia tamana, ");
INSERT INTO mee_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","bae Esekia ka i ae Manase tamana, bae Manase ka i ae Amon tamana, bae Amon ka i ae Iosaia tamana, ");
INSERT INTO mee_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","bae Iosaia ka i ae Iekonaia bae teiteikia memena tamarea. Ba ka kae nginngina ka inae Iosaia bae Iekonaia ke momo, na kelangpatali e ngae Babilon ke ravupatali ka Israelme ta maga ae i. ");
INSERT INTO mee_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ngarume, ka inae Israelme ke momo ngae Babilon tale, nae Iekonaia napengana ke toapisigia goe apanung a giana nge Salatiel, bae Salatiel ka i ae Serubabel tamana. Ba nga kae rae Serubabel, nae Israel palume keke galiu tae Israel. ");
INSERT INTO mee_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Bae Serubabel ka i ae Abiut tamana, bae Abiut ka i ae Eliakim tamana, bae Eliakim ka i ae Asor tamana, ");
INSERT INTO mee_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","bae Asor ka i ae Sarok tamana, bae Sarok ka i ae Akim tamana, bae Akim ka i ae Eliut tamana, ");
INSERT INTO mee_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","bae Eliut ka i ae Eleasar tamana, bae Eleasar ka i ae Matan tamana, bae Matan ka i ae Iekop tamana, ");
INSERT INTO mee_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","bae Iekop ka i ae Iosep tamana a i ae Maria natale, bae Maria ka i avale ore toapisigia Iesus, a ri ke patoe kae Karais. ");
INSERT INTO mee_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Minmina nae Iesus sisiukia memena reke paturu nge Abaram ta ke lele nge Revit ka ri pana tangulelu ba tugulu, ba reke paturu nge Revit ta ke lele ka ina kelangapatali e ngae Babilon ravupatali ka Israelme ka ri pana tangulelu ba tugulu, ba reke paturu ka inae Israelme ke momo ngae Babilon ta ke lele nga kae rae Karais ka ri pana tangulelu ba tugulu muni. ");
INSERT INTO mee_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nae Iesus Karais naname toangapisigingana kia ke lele minakai roma: Ka ineke parokale naname ae Maria ta i kamangpitakama kae Iosep, ava pala ta ri pana lua momong kinung, na i ka lonamatana roma ka siana ka Kannu E Tupu ginggingngana. ");
INSERT INTO mee_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Bae natale ae Iosep ka i a agau a baingana tupu ba ka sana omona ta pangavalenge Maria, minmina na i ke bai ta kange gome mana. ");
INSERT INTO mee_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ava ka inae Iosep bai ta kumangng minmina, na anggelo te orae Avolau kanna ke lele nge i nga minga, na ke role kia roma, “Iosep, Revit sivuna, maningsa mataunga ta ravunge Maria ta i a avale ae one, ta oru e lele ngallo nge i ke lele kurumea Kannu E Tupu kumangngana. ");
INSERT INTO mee_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ba i ke la toangapisiginge goe a panung, na ngo patoe giana kae Iesus kurumea, i ke la ravunglelenge ragau rae i nga baingarea reke sosoali.” ");
INSERT INTO mee_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ba oru nginngina kinung keke lele ta baina pangamologa a Avolau kanna a i tunge ta agau e toe kaona pala nge lele mannangana ine role roma: ");
INSERT INTO mee_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ngaka kele, avale ore sane keno kala nga apanung tale ka la siana, na i ke la toangapisiginge goe a panung. Na keke la patonge giana kae Emanuel,” a mirana roma, “Nutu ke momo kala nge ita.” ");
INSERT INTO mee_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Na ka inae Iosep lala kia, na i ke loakurumea anggelo ae Avolau bangapagangana kia, na ke rave Maria ta i a napengana. ");
INSERT INTO mee_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ava ke sane keno kala nge i ta ke lele nga ine toapisigia goe a panung. Na ke patoe giana kae Iesus. ");
INSERT INTO mee_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ngarume, ka inae Iesus naname toapisigia ngae Betleem ngallo ngae Iurea tapu, na ravollalau ra lomatanakana keke lele ngae Ierusalem. Ka ri ra ragau reke pa nga bava nga ina kae lele ngia. Ba oru nginngina keke lele ka kae nginngina inae Eroto ka i a kelangpatali. ");
INSERT INTO mee_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Na ra lomatanakana nginngina keke ballage ragau roma, “Elama eke toapisigia ta i a kelangpatali ae Iurame ka i ae? Ta mangng ka kele kana mata nga ina kae lele ngia, ikia baina mangng ka atu ta kalangapagange.” ");
INSERT INTO mee_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Na ka inae kelangpatali ae Eroto longe pangamologa laeala, na i kala nga re nga Ierusalem kinung ka loreapupu. ");
INSERT INTO mee_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ba ka ine kiukinungtape re kapunu nga pirisme kinung ba ragau kinung ra pangalomatanakana nga bangapagame, na ke ballaga rea roma, “Elama aka patoe kae Karais naname ke la toangapisiginge nga ine ngaetai?” ");
INSERT INTO mee_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Na ri keke ale roma, “I ke la toangapisiginge ngae Betleem ngallo ngae Iurea kurumea pangamologa ora agau e toe Nutu kaona paꞌe pala roma, ");
INSERT INTO mee_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ba one a Betleem a mogalo ae Iura, ko bollau raumana ngaliua nga galiau re ngae Iura kurumea, kelangpatali te ke la leleng nge one, ba i ke la kelanga ta ragau rae iau re ngae Israel ma agau e ellapatali ta sipsipme.’” ");
INSERT INTO mee_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nae Eroto ke kiugomea ra lomatanakana nginngina ravolau ba ke ballagapita rea, na keke ture kae mannangana ina mata lele ngia te i. ");
INSERT INTO mee_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Na i ke ba rea tae Betleem ka rolengana kerea roma, “Ngaka loa, na ngaka silimasi ta goe laeala. Ba ka ina miau ngaka kalipa kia tapu, na ngaka turu te iau nga baina iau nga loa ba nga kalapage bole.” ");
INSERT INTO mee_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ka ineke longe pangamologa ra kelangpatali kanna tapu, na keke kutapu eke loa. Ba mata laeala a ri ke kele nga bava a kae lele ngia ke taoamugmuga ngamuga nge ri ta ke lele ba ke momo ngailu nga malle a Goe momo ngia. ");
INSERT INTO mee_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ba ka ineke kele mata laeala, na ri ka loreasereng raumana. ");
INSERT INTO mee_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ba ka ineke lele, na keke loalu ta bale na keke kele Goe laeala kala nga naname ae Maria. Na keke toarau ba keke kalapagpage. Na keke kipole oru ra kanrea re nga ulonge oru ra kunreame ke bollau ngi, na keke tunge tunga nga ri ra gol ba onra koirea lolo te i. ");
INSERT INTO mee_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ava ka ineke bai ta kangagaliu ta maga pupuna ae ri, na keke tao nga pamau tetoto kurumea, Nutu ke tunge pangamologa e gingging te ri nga minga ta ri sane ngeke kagaliu muni te Eroto. ");
INSERT INTO mee_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Na ngarume nga ra lomatanakana nginngina ravolau loangarea, na anggelo te orae Avolau kanna ke lele nge Iosep nga minga, na ke role kia roma, “Ngo sigipaga ba ngo rave goe laekolong kala nga naname, na ngo ka tae Isip. Ba ngo momo nga inaeala ta nge lele nga ina iau nga turu pakone, ta Eroto ke la siling ta Goe laekolong ta baina i samungpununge.” ");
INSERT INTO mee_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ka bainae Iosep ke sigipaga na ke rave Goe laeala kala nga naname ka ina rigo tale, na keke kutapu tae Isip. ");
INSERT INTO mee_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Na keke momo nga inaeala ta ke lele nga kae a Eroto mate. Ba ollaeala ke lele minmina ta baina pangamologa a Avolau kanna a i tunge ta agau e toe kaona pala nge lele mannangana ine role roma, “Iau ka kiumalage Tugu lagapotu ngae Isip.” ");
INSERT INTO mee_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Na ka inae Eroto lonamatana roma, ra lomatanakana nginngina ravolau keke goaꞌe, na i ka iukia raumana. Na ke baꞌe ragau ta ri samungpununge goe reke sisina onra panung kinung ngallo ngae Betleem ba nga ina reke momo kokoro. Ke sapune goe reke sisina onra panung kinung ra sana karea ka pesingmatana mologi tale kurumea lomatana laeala a i rave nga ra lomatanakana nginngina ineke ture kae ina mata lele kia te i. ");
INSERT INTO mee_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Minmina na pangamologa a agau e toe Nutu kaona a giana nge Ieremaia rolea pala ke lele mannangana ine role roma, ");
INSERT INTO mee_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Keke longe kaling te ngae Rama, ka i a taning ba lotani ore bollau raumana. Resel ke tantania goe rae i, ba ka sana omona ta rakia memena pangalopenge lona, ta goe rae i keke mate tapu.” ");
INSERT INTO mee_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ngarume, ka inae Eroto mate tapu, na anggelo te orae Avolau kanna ke lele nge Iosep nga minga ine momo ngae Isip, na ke role kia roma, ");
INSERT INTO mee_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Ngo sigipaga ba ngo rave Goe laekolong kala nga naname, na ngaka loalu ta mogalo ae Israel, ta ragau ramreke bai ta samungpununge Goe laekolong keke mate tapu.” ");
INSERT INTO mee_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ka bainae Iosep ke sigipaga na ke rave Goe laeala kala nga naname, na keke loalu ta mogalo ae Israel. ");
INSERT INTO mee_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ava ka ine longe pangamologa inae Arakelaus a i ae Eroto tuna rave tamana mallena nga kelangpatali ngae Iurea, na i ke matau ta loanga ta inaeala. Ba ka inae Nutu role kia nga minga ta i nge kela masi te ri, na i ke kutapu ta ina re ngallo ngae Galili. ");
INSERT INTO mee_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Na i ke loa ba ke momo nga maga kunna e bollau eke patoe kae Nasaret. Minmina na pangamologa a ragau reke toe Nutu kaona ke rolea pala ke lele mannangana ineke role roma: “Keke la patonge kae Nasaret te.” ");
INSERT INTO mee_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ka kae nginngina nae Ion E Nga Pangamagoe ke atu, ba ke pulimalaglage pangamologa nga ina a sana ragau ngia ngae Iurea, ba ke rorole ka ragau roma, ");
INSERT INTO mee_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Ngaka pulivalakale baingamiau reke sosoali ba ngaka tunge lomiaumatenganame te Nutu kurumea, Nutu kelangpatalingana nga tava ke lele kokoro.” ");
INSERT INTO mee_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Bae Ion ka i a agau laeala ama agau e toe Nutu kaona a giana nge Aisaia role te pala ine role roma, “Agau te kalingngana ke kurkura nga ina a sana ragau ngia roma, ‘Ngaka kalitupe pamau ae Avolau, ba ngaka patupe pamaume ta i taonga ngi.’” ");
INSERT INTO mee_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Bae Ion ke lupage lungapaga eke kuma kia ka posi a kamele bulvunna, ba ka kana ka ligongpita a bulmakau patuna nga luana. Ba sisime ba miso a pinolo ka ri ra kaning rae i. ");
INSERT INTO mee_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Na ragau re ngae Ierusalem, ba ragau re nga iname kinung ngallo ngae Iurea, ba ragau re nga iname kinung reke momo kokoro ta Me Ae Ioran keke lola te i. ");
INSERT INTO mee_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Na keke umma ta turungnanange baingarea reke sosoali, bae Ion ke pamagoegoe rea nga Me Ae Ioran. ");
INSERT INTO mee_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Avae ka inae Ion kele ragau papatu ra ri ra Parisiome bae Sarusime ineke tatu te i ta i pangamagoe rea, na i ke role kerea roma, “Miau ra mue ra koatali goe rae ri, tai ke role kamiau ta miau kanga nga iu e la leleng? ");
INSERT INTO mee_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Miau kaka rorole roma, ‘Mangng ka pulivalakale baingamangng reke sosoali ba mangng ka tunge lomangngmatenganame te Nutu tapu.’ Ke pe, ava ngaroma miau ngaka kuma minmina ka kaomanna, na ngaka bavaia bainga ra ragau reke pulivalakale baingarea reke sosoali mannangana ke bavai rea. ");
INSERT INTO mee_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ba sana nga lomiaugomgome roma, ‘Mangng ka pe tapu nge Nutu raguna, ta mangng ka sisiukamangng nge Abaram.’ Ta iau nga role kamiau roma, Nutu ka kana ka gingginga ta kamongpiliunge lollo kokorai ta ri leleng Abaram sisivuna memena. ");
INSERT INTO mee_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Pemo ke momalla ta telenge begame ngape nga purea. Minmina na keke la telengpisiginge bega re sane ke piaupiaue kanrea reke pepe, na keke la raunga rea nga sia.” ");
INSERT INTO mee_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Bae Ion ke role kerea bole roma, “Iau ka pamagoegoe miau ka me ta pangakosining ka pulingvalakala ngamiaungana ka baingamiau reke sosoali ba tungamiaungana ka lomiaumatenganame te Nutu. Ava agau e la atung ngarume nge iau ka i ngailu nge iau. Ba ka sana iau a agau te mannangana ta iau nga rusulage kesingsilagi ngae i. I ke la pangamagoe miau kae Kannu E Tupu ba ka sia. ");
INSERT INTO mee_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ba i ke la kalingnanange ragau ma agau e kamopite pirangapaga a kanna nga kamana ta i paerange pailli rae i kanreame. Ba i ke la rongapatapu ka kumangngana laeala nga paeranga. Na nge pulikinunge pailli miraname nga kana bale, ava pailli gaulename i nge rau rea nga sia e sane la ronga.” ");
INSERT INTO mee_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nae Iesus ke pa ngae Galili ba ke lele nga Me Ae Ioran. Na ke loa te Ion ta baina Ion nge pamagoea. ");
INSERT INTO mee_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Avae Ion ke rome ava ta kamongpiliunge Iesus gilina bagana ka rolengana kia roma, “Ke meimia na ko bai ta iau pangamagoe one? One ngo pamagoe iau!” ");
INSERT INTO mee_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Avae Iesus ke ale roma, “Ngo ngata ta one pangamagoe iau sonrau, ta nga kumangngara laekia ita ala ka kuma kurumea bainga reke tupu nge Nutu raguna.” Minmina nae Ion ke ngata ta i pangamagoenge. ");
INSERT INTO mee_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ka inae Ion pamagoea Iesus tapu, nae Iesus ke lelemalaga nga me. Ba ka panna laeala mana, na tava ke pulapatali, ba i ke kele Kannu Ae Nutu ine lopisigsigi ma i a manu a sinna ma kulao, ine lo te i. ");
INSERT INTO mee_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na kaling te ore pa nga tava ke role roma, “Aekolong ka i ae Tugu a iau materaumane. Ba ka logupe kia raumana.” ");
INSERT INTO mee_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nae Kannu Ae Nutu ke taoamuga kae Iesus lakallo ta ina a sana ragau ngia, ta bainae Satan nge ave. ");
INSERT INTO mee_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ba ka inae Iesus kuri ta kaning ka kaeme ka ri giaukaina lua ba rigome ka ri giaukaina lua tapu, na i ka mate kana. ");
INSERT INTO mee_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nae Satan ke loa te i, na ke role kia roma, “Ngaroma one ae Nutu tuna, na ngo role ka lollo kokorai ta ri leleng ri ra beret.” ");
INSERT INTO mee_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Avae Iesus ke ale roma, “Keke paꞌe pangamologa nga Lau Ae Nutu Kanna e role roma, ‘Ke sana nga agau nge mauli ka beret mana. Ke sa. I nge mauli ka pangamologame kinung reke lelemalaga nga Nutu kaona.’” ");
INSERT INTO mee_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ngarume nae Satan ke loa kia tae Ierusalem, ba ke role ta i meising ngailu nga tempel kunna tomona, ");
INSERT INTO mee_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","na ke role kia roma, “Ngaroma one ae Nutu tuna, na ngo tugutaopisigi lagape ta keke paꞌe pangamologa nga Lau Ae Nutu Kanna e role roma, ‘I ke la bange anggelo rae i ta ri kelanga masi te one’, ba ‘Ri keke la sipanga one ka kamareame nga baina sano ngo pagitukole kaeng puna nga lollo te.’” ");
INSERT INTO mee_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nae Iesus ke ale roma, “Ava keke paꞌe pangamologa pattoto nga Lau Ae Nutu Kanna e role roma, ‘Maningsa avange Avolau a i ae Nutu ae one.’” ");
INSERT INTO mee_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ngarume muni, nae Satan ke loa kae Iesus lakailu ta kapangnga te e gavili raumana, na ke pakosininge ka kelangpatalime kinung onre nga mogalo laekia e ngape kala nga karea kavingtulume. ");
INSERT INTO mee_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ba i ke role kia roma, “Ngaroma one ngo parovanu te iau ba ngo kalapaga iau, na iau ka la tungnge oru nginngina kinung te one.” ");
INSERT INTO mee_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nae Iesus ke role kia roma, “Satan, lo ngo lao! Ta keke paꞌe pangamologa nga Lau Ae Nutu Kanna e role roma, ‘One ngo kalapage Avolau a i ae Nutu ae one, ba ngo kuma ka kumangng a kanna mana.’” ");
INSERT INTO mee_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nae Satan ke kaꞌe, na anggelome keke loa te i ba keke kalaue. ");
INSERT INTO mee_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ka inae Iesus longe pangamologa ineke pulia Ion nga pulangkala, na i ke galiu ta ine re ngae Galili. ");
INSERT INTO mee_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Na ke kaꞌe maga kunna e bollau ae Nasaret, ba ke loa e momo ngae Kaperneam. Ka i maga kunna e momo nga me a sivoli kaona nga inaeala kokoro tae Sebulun bae Naptali. ");
INSERT INTO mee_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","I ke kuma minmina ta baina pangamologa a agau e toe Nutu kaona a giana nge Aisaia rolea pala nge lele mannangana ine role roma, ");
INSERT INTO mee_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Miau raka momo nga mogalo ae Sebulun ba mogalo ae Naptali, miau raka momo nga pamau ore ta me a sivoli nga Me Ae Ioran bavana tetoto, miau raka momo ngae Galili orae ragau ra sana ri ra Iura— ");
INSERT INTO mee_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","miau raka tattara nga osuguna kaka kele olamana e bollau; ba olamana ke lele nge miau raka tattara nga mogalo e momo nga mateng kana nunule.” ");
INSERT INTO mee_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ka kae laeala nae Iesus ke paturu ta pulingmalagange pangamologa ba ta roleng ka ragau roma, “Ngaka pulivalakale baingamiau reke sosoali ba ngaka tunge lomiaumatenganame te Nutu, ta Nutu kelangpatalingana nga tava ke lele kokoro.” ");
INSERT INTO mee_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ka inae Iesus tatao nga Sivoli Ae Galili kaona, na i ke kele pana lua ra kolingana. Ke kele Saimon oreke patoe kae Pita kala nga teiteikia ae Anru ka ineke tantamali ka po nga sivoli, ta ka ri ra maengekana. ");
INSERT INTO mee_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Na i ke role kerea roma, “Ngaka atu kurume iau, na nga bai ka miau ta miau ra maengekana reke raravu ragau.” ");
INSERT INTO mee_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Na ka panna laeala mana, na keke kaꞌe po ngae ri ba keke loa kurumea Iesus. ");
INSERT INTO mee_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ka ine tao lagamuga muni nga inaeala, na ke kele pana lua pattoto ra koli. Ke kele Iems a i ae Sepeti tuna bae teiteikia ae Ion nga manang kala nga tamarea ineke saisaia po ngae ri. Na i ke kiu rea. ");
INSERT INTO mee_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ba ka panna laeala mana na keke kaꞌe manang kala nga tamarea, na keke loa kurumea Iesus. ");
INSERT INTO mee_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nae Iesus ke lola ta iname kinung ngallo ngae Galili, ba ke palomatantana ngallo nga sinagog ngae ri. Ba i ke pulimalaglage pangamologa e pe e ta Nutu kelangpatalingana, ba ke umma ta pangapenge ragau ra karea ka soaling matantaname kinung. ");
INSERT INTO mee_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Minmina nae Iesus kana turung ke sasa ta iname kinung ngallo ngae Siria. Na keke loa ka ragau kinung ra karea ka soalingme te i. Keke lola ka ragau ra karea ka soaling matantana ba laling matantana, ba ragau ra kannu reke sosoali ke lupaga rea, ba ragau reke baigaugau, ba ragau ra gireame ke mate, nae Iesus ke pape rea. ");
INSERT INTO mee_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ba malua reke bollalau re ngae Galili, bae Rekapolis, bae Ierusalem, bae Iurea, ba re nga iname nga Me Ae Ioran bavana tetoto keke lola kurumea Iesus. ");
INSERT INTO mee_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Na ka inae Iesus kele maluame, na i ke loapatae ta kapangng te na ke tara. Na barangalele ra kanna keke loa te i, ");
INSERT INTO mee_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ba i ke paturu ta pangalomatana rea ka rolengana kerea roma, ");
INSERT INTO mee_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ragau reke kelapatokona roma, keke moro raumana ta bainga ra Nutu mate rea nga loreasereng, ta Nutu kelangpatalingana nga tava ka orae ri. ");
INSERT INTO mee_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ragau ra loreatani nga loreasereng, ta Nutu ke la pangalopea loreame. ");
INSERT INTO mee_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ragau reke umma ta ulongpisigia ri muni nga loreasereng, ta Nutu ke la tungnge oru ra i patokala ta i tunga rea te ri. ");
INSERT INTO mee_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ragau ra mate karea bainga reke tupu nge Nutu raguna nga loreasereng, ta Nutu ke la pangaponu rea. ");
INSERT INTO mee_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ragau ra lonanakana nga loreasereng, ta Nutu ka la lonananna rea. ");
INSERT INTO mee_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ragau ra loreame ke lelle nga loreasereng, ta ri keke la kelange Nutu. ");
INSERT INTO mee_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ragau reke umma ta pangataramasinge ragau nga loreasereng, ta Nutu ke la patongo rea ka goe rae i. ");
INSERT INTO mee_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ragau ra ragau pattoto ke pamiralalali rea ineke lola kurumea bainga reke tupu nge Nutu raguna nga loreasereng, ta Nutu kelangpatalingana nga tava ka orae ri. ");
INSERT INTO mee_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Miau ra ragau ke rorolebainga kamiau, beke pamiralalali miau, beke patpato miau ka pangamologa matantana reke sosoali ra goanga kurumea atungamiaungana kurume iau, nga lomiausereng. ");
INSERT INTO mee_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nga lomiausereng raumana ba nga lomiaumannmanna, ta alanga ae miau e pe nga Nutu mallena nga tava ke bollau raumana kurumea, ri keke pamiralalia ragau reke toe Nutu kaona onreke momo pala nge miau minmina bole. ");
INSERT INTO mee_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Miau ra lomiaupatokona te iau ka tongamiau kena ma poae e pamannmannapaꞌe ragau re nga mogalo laekia e ngape. Ava ngaroma poae mannmannangana nge rongo, na ka la mannmannangana muni mina ngaetai? Ke la leleng ma birasi mana. Minmina na ngeke saumalaga kia, na ragau ngeke kesipite ka kaereame. ");
INSERT INTO mee_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Miau ka tongamiau kena ma olamana e nga mogalo laekia e ngape. Maga kunna e bollau a ri ke kuma kia ngailu nga kapoponga sane nge ko. ");
INSERT INTO mee_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ba bole, ragau reke tonge lama sane ngeke pakompite ka otte. Ke sa. Ri keke la pangatarapainge nga malle oreke ulopaipaia lama kia, na ke la tungnge olamana ta ragau kinung reke momo nga bale. ");
INSERT INTO mee_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Minmina mana, na miau ngaka kosining ka olamana ae miau nga ragau ragureame, nga baina ri ngeke kele baingamiau reke pepe, na ngeke kalapage Tamamiau e momo nga mallena nga tava. ");
INSERT INTO mee_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Sana nga lomiauvavai roma, iau a atu ta osungrurunge Bangapagame ba pangamologa ra ragau reke toe Nutu kaona kanrea. Ke sa. Ka sana atu ta osungruru rea. Iau ka atu ta kumangng ka oru ra ri ke rorole tao. ");
INSERT INTO mee_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ta iau nga role kamiau ka kaomannmannangana roma, ka sana la Bangapaga isunte la saningrea ta nge lele nga tava ba mogalo rongarea. Ka sana la pangamologa isunte la saningrea ta nge lele nga ina oru ra bangapagame ke rorole tao ngeke lele mannangana. ");
INSERT INTO mee_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Minmina na agau e karitaue bangapaga nginngina te ore sina mana ba ke palomatantane ragau pattoto ta ri kumangng minmina bole, agau laeala giana nge sina raumana nga Nutu kelangpatalingana nga tava. Ava agau e lolakurumea bangapaga nginngina ba ke palomatantane ragau ki, agau laeala giana nge bollau raumana nga Nutu kelangpatalingana nga tava. ");
INSERT INTO mee_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ta iau nga role kamiau roma, ngaroma baingamiau reke tupu sane nge papatu nga ra pangalomatanakana nga bangapagame ba Parisiome baingarea reke tupu, na ka sana ka la loangalu ta Nutu kelangpatalingana nga tava. ");
INSERT INTO mee_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Miau kaka longe pangamologa eke role ka ragau kia pala nganige roma, ‘Sano ngo sapune agau te.’ Ba miau kaka longe pangamologa e role roma, ‘Agau e sapune agau tetoto keke la loanga kia ta kalingnana.’ ");
INSERT INTO mee_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ava iau nga role kamiau roma, agau a iukia ka kolingana keke la loanga kia ta kalingnana. Ba agau e rolepu ka kolingana keke la loanga kia ta kalingnana e bollau nga ravollalau ragureame. Ba agau e role ka agau tetoto roma, ‘Ka sana ramang!’ ke momo kokoro ta i loanga ta malle a sia e pamiralali passavele. ");
INSERT INTO mee_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Minmina na, ngaroma ngo momo nga altara ta tungnge tunga ae one te Nutu, ba nga longgaliu ta oru e soali a one kuma kia ta kolingang, ");
INSERT INTO mee_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","na ngo kaꞌe tunga ae one nangina ngamuga nga altara. Na ngo legepitakao kala nga kolingang laeala kapunu. Na ngarume na ngo kagaliu ba ngo tunge tunga ae one te Nutu. ");
INSERT INTO mee_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ngo legepitakao bolvole kala nga agau e lola kone ta kalingnana ka ina onemea ngaka tatao tale nga pamau, ta baina agau laeala sane nge puli one nga akalingnanakana kamana. Na ngarume na akalingnanakana nge role ka akurtalingling ae i e tungtunge alanga, na i nge pullu one nga pulangkala. ");
INSERT INTO mee_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Iau nga role kone ka kaomannmannangana roma, one ko sono la lelengmalaga nga inaeala ta nge lele nga ina one ngo tunge kuru rongana mannangana.” ");
INSERT INTO mee_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Miau kaka longe pangamologa eke rolea pala roma, ‘Sano ngo keno kala nga avale a sana i a ningpengana.’ ");
INSERT INTO mee_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ava iau nga role kamiau roma, agau e kele avale ba ke matea ta i kenong kala nge i ke baia bainga e nga kenong kala nga avale a sana i a napengana ngallo nga lona tapu. ");
INSERT INTO mee_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ngaroma matang kanna e pe nge utu one ta one bainge bainga e soali nge Nutu raguna. Na ngo kalalage ba ngo tamali kia balakala kurumea, pangasanreangang ka mirang inte ke pe raumana nga ine ngeke tamalilu ka mirang iname karolu lakallo ta malle a sia e pamiralali passavele. ");
INSERT INTO mee_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ba ngaroma kamang e pe nge utu one ta one bainge bainga e soali nge Nutu raguna. Na ngo saꞌvatote ba ngo sau kia balakala kurumea, pangasanreangang ka mirang inte ke pe raumana nga ine ngeke tamalilu ka mirang iname karolu lakallo ta malle a sia e pamiralali passavele. ");
INSERT INTO mee_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ba pala, na keke role roma, ‘Agau e bai ta pelenge napengana nge tunge lau e ture palingravung rea rongana te i.’ ");
INSERT INTO mee_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ava iau nga role kamiau roma, ngaroma agau napengana sane nge keno kala nga apanung tetoto ava natale nge pelea, na agau laeala e pelea napengana ke bai kia ta i a avale e kumkuma ka bainga e nga kenong kala nga apanung a sana i a natale. Ba agau e kamapitakama ka avale ora natale pelea ke kumkuma ka bainga e nga kenong kala nga avale a sana i a napengana. ");
INSERT INTO mee_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ba muni, miau kaka longe pangamologa eke role ka ragau kia pala nganige roma, ‘Sano ngo goga ino patokala ngailu ta one kumangng ka otte, ba ka ino patokala ngailu te Nutu i ae Avolau, na ngo kuma kurumea patongkala rae one te i.’ ");
INSERT INTO mee_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ava iau nga role kamiau roma, sana ngaka patokala ngailu ta otte bavakena. Sana ngaka patokala ngailu ka Nutu mallena nga tava, ta ka i a tarang ae Nutu e nga kelangpatali. ");
INSERT INTO mee_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ba sana ngaka patokala ngailu ka mogalo laekia e ngape bole, ta ka i a patangapaikala ae Nutu. Ba sana ngaka patokala ngailu kae Ierusalem, ta ka i a maga kunna e bollau orae Nutu a i ae Kelangapatali e bollau raumana. ");
INSERT INTO mee_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ba sano ngo patokala ngailu ka kurung, ta ka sana kanga gingginga ta bainge giling bulvunna te ta i kavauvaunga o ta i saisainga. ");
INSERT INTO mee_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ava nga ino ngo role roma, ‘Iii.’ na iii laeala nga kaomannmannangana kia. Ba nga ino ngo role roma, ‘Ke sa.’ na ke sa laeala nga kaomannmannangana kia bole. Pangamologa pattoto ra ri ke ulopai rea nga pangamologa nginngina ka onreke sosoali reke pa nge Satan mana. ");
INSERT INTO mee_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Miau kaka longe pangamologa eke rolea pala roma, ‘Agau e baisoalia agau tetoto matana kanna ngeke baisoalia i bole matana kanna, ba agau e baikole agau tetoto ngingina ngeke baikole i bole ngingina.’ ");
INSERT INTO mee_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ava iau nga role kamiau roma, sana ngaka balikale agau e baia bainga e soali. Ngaroma agau te nge tavala one nga piskone e pe, na ngo kampiliue piskone te muni te i bole. ");
INSERT INTO mee_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ba ngaroma agau te nge bai ta loanga kone ta kalingnana ta ravunge lungapaga ae one e ngallo, na ngo ngata ta i ravunge lungapaga ae one e ngapotu bole. ");
INSERT INTO mee_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ba ngaroma agau te nge role ka kaonaginapitangana kone ta one taonga kala nge i ka pamau bena kena, na ngo tao kala nge i ka pamau bena lua. ");
INSERT INTO mee_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ngo tunge oru a agau ballaga te nge one, ba sano ngo bali ka ging ta agau e bai ta pulinge rinao nge one. ");
INSERT INTO mee_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Miau kaka longe pangamologa eke rolea pala roma, ‘One ngo materaumane kolingang, ba ngo baiꞌiu ka reke baiꞌiu kone.’ ");
INSERT INTO mee_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ava iau nga role kamiau roma, miau ngaka materaumane reke baiꞌiu kamiau. Ba ngaka kave Nutu ta i kavingtulunge reke umma ta pangamiralali miau. ");
INSERT INTO mee_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Miau ngaka bai minmina ta baina miau ngaka lele miau ra goe rae Tamamiau e momo nga mallena nga tava. Iau ka role minmina kurumea, i ke bavaia kae ae i ore loapataetae nga tava ta i tungnge olamana ta reke sosoali ba reke pepe kinung. Ba ke bavaꞌe kue ta ra baingareame ke tupu ba ra baingareame ke sane ke tupu kinung. ");
INSERT INTO mee_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ngaroma miau ngaka materaumane reke materaumana miau, na kaka la ravunge alanga e pe a taru? Ta ragau ra baingareame ke soali basema ragau reke raravukinunge takisme keke umma minmina bole. ");
INSERT INTO mee_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ba ngaroma miau ngaka sinro ka kolingamiau memena mana, na ka sana ka kuma ka bainga e bollau nga ragau pattoto baingareame. Ta ragau ra sana ri ra Iura keke umma minmina bole. ");
INSERT INTO mee_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Minmina na sana ngaka panna ta bainge bainga reke pepe, basema Tamamiau ngailu nga mallena nga tava ine sane pannpanna ta bainge bainga reke pepe. ");
INSERT INTO mee_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ngaka ella miau masi, ba sana ngaka kumkuma ka bainga reke tupu nga ragau ragureame ta baina ri ngeke kela rea. Ngaroma ngaka kuma minmina, na ka sana ka la ravunge alanga e pe nge Tamamiau e momo nga tava. ");
INSERT INTO mee_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Minmina na ka ina one ngo tunge otte ta ra sillolo, na tungang sana nga tongana kena ma ra goangakana tungarea. Ri keke tuturulomatana ka tungarea ka isongarea ka tarampetme ngallo nga sinagogme ba nga pamau bavaname ta baina ragau ngeke kinpataea giareame. Iau nga role kamiau ka kaomannmannangana roma, ri keke rave alang ae ri tapu ba ke sane ke la ravunge te muni. ");
INSERT INTO mee_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ava ka ino ngo bai ta tungnge otte ta ra sillolo, na sano ngo ture ta ragau. ");
INSERT INTO mee_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ngo tungugomea mana, minmina nae Tamang e elle oru ra ragau ke ummagome ki ke la tungnge alanga e pe te one. ");
INSERT INTO mee_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ba ka ina miau ngaka kavkava te Nutu, na kavangamiau sana nga tongana kena ma ra goangakana kavangarea. Ta ri keke matea ta maising ba kavang ngallo nga sinagogme ba nga pamau bavaname ta baina ragau ngeke kela rea. Iau nga role kamiau ka kaomannmannangana roma, ri keke rave alang ae ri tapu ba ke sane ke la ravunge te muni. ");
INSERT INTO mee_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ava ka ino ngo bai ta kavang, na ngo lu ta bale bilingana ae one e ngallo ba ngo bapite biunga, na ngo kave Tamang ore ko nga ragau matarea kanname. Minmina nae Tamang ore elle oru ra ragau ke ummagome ki ke la tungnge alanga e pe te one. ");
INSERT INTO mee_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ba ka ina miau nga kavkava, na sana ngaka tagavilvilia pangamologa onra sana mirarea basema ragau ra sana ri ra Iura ineke umma minmina. Iau ka role minmina kurumea, ri ka loreangana roma, Nutu ke la longakala rea kurumea pangamologangarea ra ri papatu. ");
INSERT INTO mee_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sana nga tongamiau me ri kurumea, pala ta miau balinglagange Tamamiau ka orume, na i ka lonamatana tapu ka oru re nga kalaunga miau. ");
INSERT INTO mee_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Minmina na ngaka kava minakai roma, “‘Tamamangng o momo nga malleng nga tava, Mangng ka lomangngmatana roma, ka one o tupu mannangana. ");
INSERT INTO mee_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ngo pakosining ka kelangpatalingang nakai ngape. Reke momo nga mogalo laekia e ngape ngeke lolakurumea longanganame, ma ina reke momo nga malleng nga tava ke lolakurume rea. ");
INSERT INTO mee_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ngo tunge kaning ra mangng ka kaninni rea ka kae kenakena te mangng sonrau ka kae laekia. ");
INSERT INTO mee_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ba ngo osurure bainga reke sosoali ra mangng bavai rea te one, basema ina mangng bole ka osururu tape bainga reke sosoali ra ragau ke bai rea te mangng. ");
INSERT INTO mee_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ba sono ngo taoamuga ka mangng lakallo ta avangame, ava ngo ravumalaga mangng patali nga oru reke sosoali.’ ");
INSERT INTO mee_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Miau ngaka osurure bainga reke sosoali ra ragau ke bavai rea te miau kurumea, ngaroma miau ngaka osurure ragau baingarea reke sosoali, nae Tamamiau e momo nga mallena nga tava nge osurure baingamiau reke sosoali bole. ");
INSERT INTO mee_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ava ngaroma miau sana ngaka osurure ragau baingarea reke sosoali, nae Tamamiau sane nge osurure baingamiau reke sosoali. ");
INSERT INTO mee_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ba ka ina miau ngaka kuriri ta kaning, na sana ngaka kelaragumate basema ra goangakana ineke umma minmina. Ri keke kelaragumate ta baina pangakosininge kuringarea ta ragau. Iau nga role kamiau ka kaomannmannangana roma, ri keke rave alang ae ri tapu ba ke sane ke la ravunge te muni. ");
INSERT INTO mee_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ava ka ino ngo bai ta kuringa ta kaning, na ngo ule saulang nga kurung base saulangang ka kurung ka kaeme kinung, ba ngo saulapaꞌe ragung, ");
INSERT INTO mee_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ngo kuma minmina ta baina ragau sane ngeke kelapote kuringang. Nga kana kae Tamang kasikena mana ore ko nga ragau matarea kanname nge kele. Minmina nae Tamang ore elle oru ra ragau ke ummagome ki ke la tungnge alanga e pe te one. ");
INSERT INTO mee_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Sana ngaka umma ta pulingkinung kanmiau kilipu nga mogalo laekia e ngape. Mogalo laekia ka i a malle ora kupeme ba roso ke baisolalia orume ngia, ba ka i a malle a ragolongkana ke taolulu ba keke golgolo ngia. ");
INSERT INTO mee_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ava miau ngaka umma ta pulingkinung kanmiau kilipu nga Nutu mallena nga tava. Nutu mallena nga tava ka i a malle ora kupeme ba roso ke sane baisolalia orume ngia, ba ka i a malle a ragolongkana ke sane ke taolulu ba ke sane ke golgolo ngia. ");
INSERT INTO mee_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Iau ka role minmina kurumea, malle a one umma ta pulingkinung kaning kilipu ngia, ka i a malle ora longmatengana ke la momong ngia bole. ");
INSERT INTO mee_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Matang kanna ka i a lama ore nga mirang. Ngaroma matang kanna nge kuma masi, na olamana nge ponu nga mirang iname karolu. ");
INSERT INTO mee_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ava ngaroma matang kanna nge soali, na osuguna nge ponu nga mirang iname kinung. Minmina na ngaroma olamana e momo ngallo nge one nga i a osuguna, na osuguna laeala ke bollau raumana. ");
INSERT INTO mee_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Agau a i a akumangngatulu sane nge kuma nga ravollalaume ka ri lua, ta i nge baiꞌiu ka te ba nge materaumane te. O i nge loatunanne te ba nge malaipatantalia te. Ba miau ka tongamiau kena mana ma ollaeala. Ka sana ka gingginga ta kumangng nge Nutu kala nga oru re nga mogalo laekia e ngape kinung. ");
INSERT INTO mee_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Minmina na iau nga role kamiau roma, sana nga lomiaupupu ta momong ngamiaungana roma, ‘Ita kaka la kaninge taru?’, o ‘Ita kaka la inunge taru?’. Ba bole sana nga lomiaupupu ta oru nga miramiaume roma, ‘Ita kaka la sisilinge taru?’. Iau ka role minmina kurumea, momong ngamiaunganame keke bollau raumana nga kaning. Ba miramiaume keke bollau raumana nga lungapagame. ");
INSERT INTO mee_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ngaka kele manu reke lolo nga tava. Ri ke sane ke tota karea kaning, ba ke sane ke umma ta lalanga rea. Ba ke sane ke umma ta pulingkinung kaning nga baleme bole. Avae Tamamiau e momo nga mallena nga tava ke pakankani rea. Ba miau kaka bollau raumana nge ri. ");
INSERT INTO mee_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ba tai e nge miau ka kana ka gingginga ta pulingale kae kena mana ta momongana gaviling ka lonapungana? ");
INSERT INTO mee_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ke meimia na ka lomiaupupu ta lungapagame? Ngaka kele gaivame ineke umma ta leleng nga mogalo. Ri ke sane ke kumkuma ba ke sane ke saisaia lungapagame bole. ");
INSERT INTO mee_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ava iau nga role pakamiau roma, ka inae Solomon kanserengea mirana raumana, na kaningserengngana laeala ka sana tongana ma te nga gaiva nginngina. ");
INSERT INTO mee_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Miau ra kamiau ka lopatokona e sina, ngaroma Nutu nge kuma minmina ka pangalupagangana ka bega ba oru re nga mogalo reke momo sonrau ava me ngangaila na ngeke tamalilu ki ta sia, na i ke la pangalupaga miau mannangana. ");
INSERT INTO mee_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Minmina na sana nga lomiaupupu roma, ‘Ita kaka la kaninge taru?’, o ‘Ita kaka la inunge taru?’, o ‘Ita kaka la lungapagange tarume?’ ");
INSERT INTO mee_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Iau ka role minmina kurumea, ra sana ri ra Iura keke tangtange oru nginngina kinung, bae Tamamiau ka lonamatana tapu roma, oru palu nga oru nginngina keke bollau raumana nge miau bole. ");
INSERT INTO mee_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ava kapunu na miau ngaka tange oru re nga Nutu kelangpatalingana ba bainga reke tupu nga raguna, ba i ke la tungnge oru nginngina kinung te miau bole. ");
INSERT INTO mee_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Minmina na, sana nga lomiaupupu ta kae e ngangaila, ta kae e ngangaila ka i toto nga ne sonrau. Kae kenakena ka la kana ka maenang. ");
INSERT INTO mee_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Sana nga lomiaukananne ragau pattoto. Ngaroma miau ngaka bavai minmina, nae Nutu ke la i kalingnana miau bole. ");
INSERT INTO mee_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ta Nutu ke la kalingnana miau kurumea baingamiau e nga lomiaukalingnanange ragau pattoto baingarea. Ba bainga ra miau ka lomiaukananne ragau pattoto ki, Nutu la kalingnana miau ki bole. ");
INSERT INTO mee_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ke meimia na one ko kela paka bega pinsina e sina e momo nga kolingang matana kanna, ava ko sano kela paka bega ine bollau e lengkale matang kanna? ");
INSERT INTO mee_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ko la one roleng mina ngaetai ta kolingang roma, ‘Iau ka bai ta pirangmalagange bega pinsina isu laekolong nga matang kanna,’ ava one muni ko sano kela paka bega ine bollau e lengkale matang kanna? ");
INSERT INTO mee_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ka one a goangakana. Kapunu, na ngo piramalage bega ine bollau e lengkale matang kanna, na ngarume, na ko la kelanga masi ta pirangmalagange isure sina e momo nga kolingang matana kanna. ");
INSERT INTO mee_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Sana ngaka tunge oru e tupu ta gauneme, ba sana ngaka tamali ka oru rae miau reke pepe raumana ta gieme. Ta ngaroma ngaka kuma minmina na ri keke la patangavuvunu rea ngape nga kaerea sianame, na ngeke kampiliu rea ba ngeke pallamo pattoto kamiau. ");
INSERT INTO mee_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ngaka ballage Nutu, na i ke la tungnge oru ra miau ka ballage tao. Ngaka tange Nutu, na kaka la kaling pakia. Ngaka tute biunga, nae Nutu ke la pulangpatalinge. ");
INSERT INTO mee_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ta Nutu ke la tungnge oru ta agau e ballage te, ba agau e tange Nutu ke la kaling pakia. Bae Nutu ke la pulangpatalinge biunga ta agau e tute. ");
INSERT INTO mee_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Palu nge miau ka nerea ka goeme. Na ngaroma te e nge ri nge ballaga rea ta kana beret te, na ri sane ngeke tunge lollo te i. Ke sa. ");
INSERT INTO mee_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O ngaroma i nge ballaga ta kana lea te, na ri sane ngeke tunge mue te i. Ke sa. ");
INSERT INTO mee_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Miau ra lomiaume ke sosoali ka lomiaumatana ta tungnge oru reke pepe ta goe rae miau. Bae Tamamiau e momo nga mallena nga tava ke pe raumana nga tama e nga mogalo laekia e ngape. Minmina na i ke la tungnge oru e pe ta ragau reke ballage te ka kaomannmannangana. ");
INSERT INTO mee_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Minmina na bainga ra miau ka matea ragau ta ri bainga rea te miau, miau bole ngaka bai rea te ri kurumea, kumangng laeala ke lola kurumea oru ra Bangapagame ba ragau reke toe Nutu kaona ke role tao mannangana. ");
INSERT INTO mee_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ngaka lu lakallo nga biunga e pitu kurumea, biunga e nga raunga ke bollau, ba kana pamau ke uapapa, ba ragau reke lulu kia ka ri papatu. ");
INSERT INTO mee_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ava biunga e nga mauling ke sina, ba kana pamau ke pitu, ba ragau reke umma ta kaling pakia ka ri tutuna mana. ");
INSERT INTO mee_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ngaka ella miau masi ta poropet ra goanga. Ri keke la atung te miau ka lungapagangarea ka sipsipme baingarea, ava ngallo nge ri ka ri ra gaune onra saililikerea. ");
INSERT INTO mee_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Miau kaka la kelangapatokona rea kurumea kumangngareame. Ragau ke sane ke rarave gerepeme nga oalooalo ra matarea. Ba ke sane ke rarave bega ra pik kanna nga kauila lomona bole. ");
INSERT INTO mee_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ba otte muni, bega reke pepe keke piaupiaue kanrea reke pepe, ava bega reke sosoali keke piaupiaue kanrea reke sosoali. ");
INSERT INTO mee_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Bega reke pepe sane ngeke piaupiaue kanrea reke sosoali, ba bega reke sosoali sane ngeke piaupiaue kanrea reke pepe bole. ");
INSERT INTO mee_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Keke telpalpisigi ka begame kinung re saneke piaupiaue kanrea reke pepe, ba keke tantamalilu ki lakallo ta sia. ");
INSERT INTO mee_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Minmina na miau kaka la kelangapatokona rea nga kanreame. ");
INSERT INTO mee_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ragau reke patpato iau kae Avolau, ri kinung ke sane ke la lunga lakallo ta Nutu kelangapatalingana nga tava. Ke sa. Ragau reke lolakurumea Tamau e momo nga mallena nga tava lonanganame mana keke la lunga lakallo. ");
INSERT INTO mee_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ka kae laeala na, ragau papatu keke la roleng kau roma, ‘Avolau, mangng ama pulimalage pangamologa nga giang, ba mangng ama taomalage kannu reke sosoali nga ragau ba ka kuma ka killa papatu reke bollalau nga giang.’ ");
INSERT INTO mee_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Na iau ka la roleng kerea nga karakarangana roma, ‘Ka sana laumatana ka miau ka kae te. Miau ra longasakana te Nutu, ka kapatali iau.’ ");
INSERT INTO mee_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Minmina na ragau reke longe pangamologa ra kanau beke lolakurume rea ka tongarea kena mana ma agau a lomatanakana ore kumapai ka bale ae i nga lollo. ");
INSERT INTO mee_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ngarume na kue ke tugu ba me potungana e bollau ke lele, ba bovole reke bollalau keke iso na keke isomatagtage bale laeala. Ava bale laeala ke sane pupu, ta ke maispaikalle nga lollo. ");
INSERT INTO mee_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ava ragau reke longe pangamologa ra kanau, ava ke sane ke lolakurume rea nga tongarea kena mana ma agau a sana ramana ore kumapai ka bale ae i nga bai. ");
INSERT INTO mee_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ngarume na kue ke tugu ba me potungana e bollau ke lele, ba bovole reke bollalau keke iso na keke isomatagtage bale laeala. Na bale laeala ke pupu, ba ke gitupalvai kia.” ");
INSERT INTO mee_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Minmina na ka inae Iesus rongo ka pangamologa nginngina tapu, na maluame keke kallo raumana nga pangalomatananganame ");
INSERT INTO mee_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kurumea, pangalomatananganame ka sana tongarea kena ma ragau rae ri ra pangalomatanakana nga bangapagame. Ke sa. I ke palomatantana rea ma agau a kana ka gingginga. ");
INSERT INTO mee_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Na ka inae Iesus sopisigi nga kapangng tapu, na malua reke bollalau keke loakurumea. ");
INSERT INTO mee_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ba agau te ora kana ka soaling a kalangamugmugu ke loa te i. Na ke parovanu ngamuga nge i ba ke role roma, “Avolau, one ka kanga ka gingginga ta pangalellepa iau. Ngaroma nga longangana, na ngo palellepa iau.” ");
INSERT INTO mee_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nae Iesus ke kalaꞌe kamana ba ke kali kia, na ke role roma, “Ka logungana. Ngo lelle.” Ba ka panna laeala mana na soaling ae i a kalangamugmugu ke rongo. ");
INSERT INTO mee_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nae Iesus ke role kia roma, “Ngo longo nasai. Sano ngo turu ta agau te, ava ngo loa ba ngo pakosining kone ta piris. Na ngo tunge tunga laeala ae Moses bapage ragau ta ri tungnge pala, nga baina ragau nga loreamatana roma soaling ae one ke rongo tapu.” ");
INSERT INTO mee_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ka inae Iesus loalu tae Kaperneam, na kelangapatali te nga ra balingkana ke loa te i, na ke ballage ta i kalaunge. ");
INSERT INTO mee_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ba ke role kia roma, “Avolau, akumangngatulu a kanau ke kenkeno a maga ka giname matengareangana, ba ke kanimaimaia miralali e bollau raumana.” ");
INSERT INTO mee_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nae Iesus ke role kia roma, “Iau ka la loanga na nga papea.” ");
INSERT INTO mee_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ava kelangapatali laeala ke ale roma, “Avolau, ka sana iau a agau e pe ta one ngo atu ta bale ae iau, ava one ngo role mana, na akumangngatulu ae iau nge pe. ");
INSERT INTO mee_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Iau ka role minmina ta ka iau a agau e momo ngape nga reke kelapatali te iau bole. Ba ka ra balingkana reke momo ngape nge iau. Minmina na ngaroma iau nga role ka te roma, ‘Ngo loa!’ na i nge longo mana. Ba nga role ka tetoto roma, ‘Ngo atu!’ na i nge atu. Ba ngaroma iau nga role ka akumangngatulu ae iau te roma, ‘Ngo kuma ka ollaekia!’ na i nge kuma kia.” ");
INSERT INTO mee_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Na ka inae Iesus longe pangamologa a kelangpatali laeala kanna, na pangamologa laeala ke pamagioe raumana. Minmina na i ke role ka ragau reke tataokurumea roma, “Iau nga role kamiau ka kaomannmannangana roma, iau ka sana kalipa ka te nga re ngae Israel ora lopatokona ae i bollau me aekia. ");
INSERT INTO mee_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ba nga role kamiau roma, ragau papatu re nga iname kinung keke la atung, na keke la ravunge mallerea kala nge Abaram, bae Aisak, bae Iekop nga kaning e bollau ngallo nga Nutu kelangpatalingana nga tava. ");
INSERT INTO mee_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ava ragau nginngina rae Nutu role pala ta ri momong nga kelangpatalingana keke la tamaling kerea lagapotu lakallo ta osuguna e ngapotu, nga malle laeala a ragau ke la taning ba ke la tanaginge ngingireame ngia.” ");
INSERT INTO mee_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nae Iesus ke role ka kelangapatali laeala nga ra balingkana roma, “Lo ngo loa ta maga. Oru a one matea ke la leleng basema ina one longopatokona te.” Na kelangpatali laeala akumangngatulu ae i ke pe ka panna laeala mana. ");
INSERT INTO mee_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Na ka inae Iesus lu ta Pita bale ae i, na i ke kele Pita lonapengana ine kenkeno nga nia ka soaling te a mira isongpangana. ");
INSERT INTO mee_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Na avale laeala ke kali ka avale laeala nga kamana na mira isongpangana ke kaꞌe. Na i ke sigipaga ba ke paturu ta tuvanga Iesus kana kaning. ");
INSERT INTO mee_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ba ka ina kae barelu tapu, na keke atu ka ragau papatu ra kannu reke sosoali ke lupaga rea te Iesus. Na i ke taomalage kannu nginngina ka pangamologangana. Ba ke papea ragau kinung ra karea ka soaling. ");
INSERT INTO mee_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","I ke kuma minmina ta baina pangamologa a agau e toe Nutu kaona a giana nge Aisaia rolea pala nge lele mannangana ine role roma, “I ke rave mirarame likisa ngareanganame, ba ke tolea soaling rae ita.” ");
INSERT INTO mee_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Na ka inae Iesus kele malua reke bollalau ineke taliutotokale, na i ke role ka barangalele ra kanna ta ri ngeke loa ta sivoli bavana tetoto kala nge i. ");
INSERT INTO mee_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Na agau te a i a apangalomatanakana nga bangapagame ke loa te Iesus na ke role kia roma, “Apangalomatanakana, iau ka la loangakurume one ta ina nge ngaetai ra one la loanga tao.” ");
INSERT INTO mee_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nae Iesus ke ale roma, “Gauve ra pinolo ka karea mallerea ta ri momong ngi, ba manu reke lolo nga tava ka ginureame, avae Agau Tuna ka sana mallena ta i pakenonge kunna ngia.” ");
INSERT INTO mee_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Na barangalele te muni ke role kia roma, “Avolau, iau nga loa nga baina nga talue tamau ngana.” ");
INSERT INTO mee_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Avae Iesus ke role kia roma, “One ngo atukurume iau. Ragau reke mate ngeke talue ragau rae ri muni reke mate.” ");
INSERT INTO mee_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Na ka inae Iesus taepatae nga manang, na barangalele ra kanna keke taekurumea. ");
INSERT INTO mee_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ba ngarume, ka ineke tatao ka manang, na sauu e bollau ke lelekala rea nga me a sivoli, ba miniuame keke balikolointe manang. Avae Iesus ke kenrau suru. ");
INSERT INTO mee_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na keke loa eke pangoe ka rolengarea roma, “Avolau, ngo ravulele ita! Ita kaka marannrale!” ");
INSERT INTO mee_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Na i ke role kerea roma, “Miau ra lomiaupatokona sina, kaka meimia aka matautau?” Na ke sigipaga ba ke baullupite sauu ba miniuame, na keke malo bavakena. ");
INSERT INTO mee_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Na barangalele ra kanna keke kallo ba keke palirole kerea roma, “Agau matana e meimia ikia? I ke role mana, na sauu ba pelau keke longo te i.” ");
INSERT INTO mee_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ka ine lele nga sivoli bavana tetoto nga ine ngae Gararame, na ke kele ragau lua ra kannu reke sosoali ke lupaga rea ineke lelemalaglaga nga baveng reke tatalue reke mate ngi. Ba pana lua nginngina ka ri ra ragau ra baingaꞌiukana raumana. Minmina na ragau keke matau ta ri kavesinge inaeala nga pamau laeala. ");
INSERT INTO mee_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ka ineke kele Iesus, na keke reli kaligi roma, “Nutu Tuna, ko bai ta maingamia kamangng? Ko atu ta pangamiralali mangng pala nga kae e nga kalingnana?” ");
INSERT INTO mee_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na gie barana te keke kaninni nga inte e sane ngatauga raumana nga inaeala. ");
INSERT INTO mee_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Minmina na kannu nginngina reke sosoali keke tanikale Iesus roma, “Ngaroma ngo bai ta bangamalaga mangng, na ngo balu mangng lakallo ta gie barana laeala.” ");
INSERT INTO mee_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nae Iesus ke role kerea roma, “Ka loa!” Minmina na keke lelemalaga patali nga ragau lua nginngina, ba keke luia gieme, na gie barana laeala ke tumvalivu maling nga ina i a mantapu, na ke toarallu kerea nga sivoli ba keke mate nga me. ");
INSERT INTO mee_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Na reke ellapatantali ta gie nginngina keke ka, ba keke loalu ta maga kunna e bollau. Na keke ture orume kinung reke lele. Ba keke ture ollaeala e lele nga pana lua ra kannu reke sosoali ke lupaga rea bole. ");
INSERT INTO mee_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Minmina na ragau kinung re nga maga kunna laeala e bollau keke lelemalaga eke loa ta kelange Iesus. Ba ka ineke kele, na keke tanikale ta i kange inaeala ae ri. ");
INSERT INTO mee_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nae Iesus ke taepatae nga manang, na ke ulutote me a sivoli. Na ke lele nga maga kunna ae i e bollau. ");
INSERT INTO mee_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ngarume na ragau palu keke atu ka agau te a giname ke mate te Iesus. Ba agau laeala ke kenkeno nga nia. Ka inae Iesus kele lopatokona ae ri, na ke role ka agau a giname ke mate roma, “Tugu, maningsa mataunga. Iau ka osurure baingang reke sosoali.” ");
INSERT INTO mee_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na ka ina ragau palu ra ri ra pangalomatanakana nga bangapagame ke longe pangamologa laeala, na ri ka loreagomgome roma, “Aekia ke rorolebainga kae Nutu!” ");
INSERT INTO mee_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Avae Iesus ka lonamatana tapu ka ore momolu ngallo nga ramareame, minmina na i ke role kerea roma, “Kaka meimia na lovaingana reke sosoali ke umma ngallo nga lomiaume? ");
INSERT INTO mee_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Pangamologa a taru nge ate ta iau rolenge? Ngaroma iau nga role kae aekia roma, ‘Aekolong, iau ka osurure baingangame reke sosoali’? O ngaroma iau nga role kia roma, ‘Sigipaga na ngo tao’? Te miau sonrau, nga pangamologa lua nginngina na taru ke ate ta iau rolenge? ");
INSERT INTO mee_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ava nga baina miau ngaka kelapatokona roma, Agau Tuna ka kana ka gingginga nakai nga mogalo laekia ngape ta i osungrurunge ragau baingarea reke sosoali” —na i ke role ka agau laeala a giname ke mate roma—, “Sigipaga, na ngo rave nia ae one ba ngo loa te one ta bale.” ");
INSERT INTO mee_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Na agau laeala ke sigipaga, ba ke loa ta bale ae i. ");
INSERT INTO mee_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ba ka ina maluame ke kele ollaeala, na keke kallo raumana. Ba keke kalapage Nutu e tunge gingginga matana laeala ta ragau. ");
INSERT INTO mee_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ka inae Iesus kaꞌe malle laeala be lola, na i ke kele agau a giana nge Matiu ine tattara nga mallena e nga ravungkinunge takisme. Na i ke role kia roma, “Ngo atukurume iau!” Minmina na i ke sigipaga, na ke loakurumea Iesus. ");
INSERT INTO mee_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ngarume, nae Iesus ke tattara ka bongapaikalanganakia ta kaning nga pala ngallo nga bale ae Matiu. Ba ragau papatu reke raravukinunge takisme ba ragau pattoto ra Iurame ke pato rea ka ra baingareame ke soali keke atu bole, na keke kani kala nge Iesus ba barangalele ra kanna. ");
INSERT INTO mee_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ka inae Parisiome ke kele ollaeala, na keke role ka barangalele rae Iesus kanna roma, “Ke meimia nae Apangalomatanakana ae miau ke kani kala nga reke raravukinunge takisme ba ra baingareame ke soali?” ");
INSERT INTO mee_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ava ka inae Iesus longe pangamologa laeala, na i ke role roma, “Ragau ra sana karea soaling ke sane ke lola ta apangapemirakana. Ke sa. Ragau ra karea ka soaling mana keke lola. ");
INSERT INTO mee_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ava ngaka loa, na ngaka rave lomatana nga pangamologa laeala nga Lau Ae Nutu Kanna ore role roma, ‘Iau ka matea lonana. Ka sana matea posi onreke bali rea beke tungu rea ma tungame.’ Minmina na miau ka la lomiaumatana roma, iau ka sana atu ta kiunge ragau ra baingareame ke tupu. Ke sa. Iau ka atu ta kiunge ragau ra baingareame ke soali.” ");
INSERT INTO mee_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nae barangalele rae Ion kanna keke atu te Iesus, na keke ballage roma, “Mangng bae Parisiome ka kuriri ta kaning, ava ke meimia na barangalele ra kaning ke sane ke kuma minmina?” ");
INSERT INTO mee_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nae Iesus ke ala rea ka pangateningkalangana ka pangamologa roma, “Ragau reke maispage apanung ka kae e nga palingravung rea sana nga loreatani ina apanung laeala e kamapitakama momo kala nge ri tale. Ke sa. Ava ngarume, ka ineke ravupatali ka apanung e kamapitakama nge ri tapu, na keke la kuringa ta kaning ka kae nginngina. ");
INSERT INTO mee_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ke sana agau te nge saipite malo ina pau nga lungapaga a kasana, ta inaeala a pau nge utupatali nga lungapaga, na lungapaga laeala maraengana nge bollau muni nga ne pala. ");
INSERT INTO mee_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ba ragau sane ngeke pullue uain a pau lakallo ta uain bagana ra kasarea bole. Ngaroma ri ngeke kuma minmina na uain a pau nge poagolue uain bagana nginngina onreke kuma ki ka meme patuna, na uain nge maling lagapotu. Ba uain patuname keke la soaling. Ragau sane ngeke kuma minmina. Ke sa. Ri keke la pulinge uain a pau lakallo ta uain patuna onra pau, na uain ba patuna kinung keke la momong masi.” ");
INSERT INTO mee_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ka inae Iesus rorole kerea ka oru nginngina tale, na agau te a i a kelangpatali nga bale e nga sinagog ke loa te i. Na ke parovanu ngamuga nge i ba ke role kia roma, “Gialgiala mana nae tugu piau ke mate, ava ngo atu na ngo ulopaia kamang nge i, na ke la i momong mauli muni.” ");
INSERT INTO mee_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nae Iesus ke sigipaga, na ke loa kala nge i. Ba barangalele ra kanna keke loa bole. ");
INSERT INTO mee_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ka ineke tatao eke lola, na avale te ore tattara ka luvo ka kaeme kinung ka pesingmataname ka ri tangulelu ba lua ke lele kokoro te Iesus nga gina. Na i ke kali ka lungapaga ae i sigina matana. ");
INSERT INTO mee_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","I ke bai minmina kurumea i ke rorole ngallo nge i muni roma, “Ngaroma iau nga kali ka lungapaga ae i mana, na iau ka la penga.” ");
INSERT INTO mee_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nae Iesus ke kampiliu na ke kele, na ke role kia roma, “Tugu piau, sano ngo matau. Lopatokona ae one ke pape one.” Ba ka panna laeala mana, na avale laeala ke pe. ");
INSERT INTO mee_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ba ka inae Iesus lu lakallo ta bale ae agau laeala e kelapatali nga sinagog, na i ke kele ragau reke insoe isongo e nga olengkannu ba ke kele malua reke lavoalla. ");
INSERT INTO mee_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Na ke role kerea roma, “Ngaka lelemalaga. Malaui laekia ke sane mate. Ke kenrau.” Ava ri keke malilia Iesus. ");
INSERT INTO mee_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ka ineke bamalage maluame lagapotu tapu, nae Iesus ke lu lakallo na ke rapite malaui laeala nga kamana, na i ke sigipaga. ");
INSERT INTO mee_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ba turunglomatana re ta Iesus kumangngana laeala ke sasa ta magame kinung nga inaeala. ");
INSERT INTO mee_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ka inae Iesus umma ta kange inaeala ba ke tatao e lola, na rapanung lua ra matasu keke lolakurumea ba keke kiu kaligi ka rolengarea roma, “Revit Sivuna, nga longnana mangng!” ");
INSERT INTO mee_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ba ka inae Iesus lu lakallo ta bale te tapu, na pana lua nginngina ra matasu keke loa te i. Nae Iesus ke ballaga rea roma, “Ka lomiaupatokona roma, iau a kau ka gingginga ta pangapenge onemea?” Na keke ale roma, “Iii Avolau.” ");
INSERT INTO mee_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Na i ke kali ka matarea kanname ba ke role roma, “Kaka la penga kurumea lopatokona ae miau.” ");
INSERT INTO mee_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na matarea kanname keke pepe. Bae Iesus ke role kerea gingging roma, “Sana ngaka ture ollaekia ta agau te.” ");
INSERT INTO mee_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ava ri keke lelemalaga ba keke turupalisi ka turunglomatana re te Iesus nga iname kinung. ");
INSERT INTO mee_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ba ka ineke umma ta lelengmalaga nga bale laeala, na ragau palu keke atu ka apanung a i a kumba ora kannu e soali luia te Iesus. ");
INSERT INTO mee_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ba ka inae Iesus taomalage kannu laeala e soali tapu, na agau laeala a i a kumba ke pamologa. Na maluame keke kallo raumana ba keke role roma, “Ka sana agau te kele otte minakai ngae Israel ka kae te.” ");
INSERT INTO mee_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Avae Parisiome keke rorole roma, “I ke taomalaglage kannu reke sosoali ka kelangpatali ae ri ginggingngana.” ");
INSERT INTO mee_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Bae Iesus ke lola ta magame kinung reke bollalau ba ne ngeke sisina, ba ke palomatantane ragau ngallo nga sinagog rae ri. Ba ke pulimalaglage pangamologa e pe e ta Nutu kelangpatalingana, ba ke umma ta pangapenge soaling matantaname kinung. ");
INSERT INTO mee_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ba ka ine kele maluame, na i ka lonavavai te ri raumana kurumea, ri ka tongarea kena ma sipsip ra loreapalilli ba loreapupu. Ri ka tongarea kena ma sipsip ra sana karea kelangpatali. ");
INSERT INTO mee_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Na i ke role ka barangalele ra kanna roma, “Ka kaning papatu nga ura ta lalanga rea, ava ka sana barangalele papatu ta pulingkinungu rea. ");
INSERT INTO mee_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Minmina na miau ngaka kava te Nutu a i a ura tamana ta i bange barangalele ta ri lalang nga ura ae i.” ");
INSERT INTO mee_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nae Iesus ke kiue barangalele ra kanna ka ri tangulelu ba lua te i, ba ke tunge giana ginggingngana te ri ta ri taongamalagange kannu reke sosoali. Ba ke tunge gingginga te ri ta pangapenge soaling matantaname kinung. ");
INSERT INTO mee_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ba pana tangulelu ba lua nginngina onra ri ra aposelme ka giareame rikai: Ne kapunu nge Saimon eke patoe kae Pita, bae teiteikia ae Anru; bae Iems a i ae Sepeti tuna, bae teiteikia ae Ion; ");
INSERT INTO mee_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","bae Pilip bae Bartolomiu; bae Tomas bae Matiu a i a aravungkinung takiskana; bae Iems te muni a i ae Alpaeus tuna, bae Tarius; ");
INSERT INTO mee_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","bae Saimon te muni eke patoe kae “Selot”, bae Iuras Iskariot a i a agau laeala ame pulia Iesus nga reke baisoalia kamareame. ");
INSERT INTO mee_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nae Iesus ke baꞌe pana tangulelu ba lua nginngina ka potongana kerea roma, “Miau sana ngaka loa ta ragau ra sana ri ra Iura, ba sana ngaka lu ta maga kunna te e bollau orae Sameriame. ");
INSERT INTO mee_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ava ngaka loa ta ragau re ngae Israel onreke basema sipsip reke taopa. ");
INSERT INTO mee_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ba ka ina miau ngaka tatao ta iname, na ngaka pulimalaglage pangamologa roma, ‘Nutu kelangpatalingana nga tava ke lele kokoro.’ ");
INSERT INTO mee_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ngaka papea ragau ra karea ka soalingme, ba ngaka pasigipage reke mate, ba ngaka palellepaꞌe ragau ra karea ka soaling a kalangamugmugu, ba ngaka taomalage kannu reke sosoali. Miau kaka ravumane orume nge Nutu, minmina na miau bole ngaka tungumane orume ta ragau. ");
INSERT INTO mee_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Sana ngaka paue gol, o siliva, o lollokanna matana palu nga ligongpita rae miau raka pulpuli lollokanna ngi. ");
INSERT INTO mee_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ba bole sana ngaka paue bising e nga taongamiau, o lungapaga te muni, o kesingsilagime, o to e nga kalaunge taongamiaungana. Sana ngaka paue oru nginngina kurumea, barangalele e kumkuma ke la ravunge oru ra kanna re nga kalaunge nga ragau ra i kalau rea. ");
INSERT INTO mee_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ba nga ina miau ngaka lu ta maga kunna te e bollau o maga kunna te e sina, na ngaka kela ta agau e pe nga maga laeala. Na ngaka momo nga bale ae agau laeala ta nge lele nga kae ina miau ka la kange malle laeala. ");
INSERT INTO mee_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ba ka ina miau ngaka taolulu ta bale laeala, na ngaka tagukama ka reke momo nga bale. ");
INSERT INTO mee_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ngaroma reke momo nga bale laeala nga ri ra ragau reke pepe, na lomannmanna ae miau nge momo nge ri. Ava nge sa, na lomannmanna laeala nge galiu muni te miau. ");
INSERT INTO mee_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ba ngaroma ragau sana nga loreangatakala miau, o ngaroma ri sana nga omorea ta longa ta pangamologa rae miau, na ngaka lulupatali ka magavusa nga kaemiau sianame nga ina miau ngaka kaꞌe bale laeala o maga kunna laeala e bollau. ");
INSERT INTO mee_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Iau nga role kamiau ka kaomannmannangana roma, nga kae e nga kalingnana ngarume, na re nga maga laeala ra sana loreangatakala miau keke la ravunge miralali e bollau raumana nga miralali a ragau re ngae Sorom ba re ngae Gomora ke la ravunge. ");
INSERT INTO mee_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ngaka longo nasai! Iau ka bava miau lagapotu ma sipsip reke momo ngaliua nga gauve ra pinolo. Minmina na ngaka lele ma mue ra loreamatana masi ka ragau taongareame. Ba ngaka lele ma manu ra kulao ra baingareame ke tupu ka kaeme kinung. ");
INSERT INTO mee_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Ngaka ella miau masi ta ragau kurumea, ri keke la loanga ka miau ta kalingnaname. Ba keke la sapingi miau nga sinagog rae ri. ");
INSERT INTO mee_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ba keke la pangamaisi miau nga gavaname ba kelangpatalime ragureame kurumea loangakurume ngamiaungana kau. Ri keke la kumangng minmina ta baina miau ngaka turupote lopatokona ae miau te iau te ri ba ta ragau ra sana ri ra Iura. ");
INSERT INTO mee_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ava nga ina ri ngeke loa ka miau ta kalingnana, na sana nga lomiaupupu roma, ‘Ita kaka la maingamia ka rolengara, ba ita kaka la roleng mina ngaetai?’ Sana nga lomiaupupu ta nga kae laeala mana, nae Nutu ke la tungnge pangamologa ra miau ka la rolenge rea. ");
INSERT INTO mee_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Iau ka role minmina kurumea, miau ka sana ka la pangamologa. Ke sa. Kannu ae Tamamiau ke la pangamologa nga kaomiaume. ");
INSERT INTO mee_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ba apanung kolingana ke la ulonge ta ragau ta ri samungpununge. Ba goe tamana ke la kumangng minmina ka goe laeala ae i. Ba goeme keke la sigingpagakalange tamarea ba nareamemena na keke la ulongo rea ta ragau ta ri samungpunu rea. ");
INSERT INTO mee_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ba ragau kinung keke la baingaꞌiu kamiau kurumea lopatokona ae miau te iau. Ava agau e momo gingging ta nge lele nga kae a ronga ka la i a agau a Nutu la ravunglelenge. ");
INSERT INTO mee_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nga ina ri ngeke pamiralali miau nga maga kunna te e bollau, na ngaka ka ta maga kunna tetoto e bollau. Iau nga role kamiau ka kaomannmannangana roma, miau ka sana ka la ronga ka taongamiau ta maga kunna re bollau re ngae Israel tale, nae Agau Tuna ke la atung. ");
INSERT INTO mee_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Apangalomatanakana goe a kanna ke sane momo ngailu nga apangalomatanakana ae i. Ba agau a i a akumangngatulu ke sane momo ngailu nga avolaukia bole. ");
INSERT INTO mee_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Apangalomatanakana goe a kanna nge matea ta i leleng basema apangalomatanakana ae i. Ba agau a i a akumangngatulu nge matea ta i leleng basema avolaukia. Ri keke patoe bale tamana kae Beelsebul. Minmina na keke la rolengsoali ka ragau re nga bale laeala raumana bole. ");
INSERT INTO mee_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Minmina na miau sana ngaka matau rea kurumea, ngarume, nae Nutu ke la pangapotange orume kinung ra ragau ke talu rea sonrau. Ba orume kinung ra ragau ke pako rea sonrau keke la leleng nga karakarangana ngarume. ");
INSERT INTO mee_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Oru ra iau role kamiau ki nga osuguna ngaka role rea nga olamana. Ba oru ra iau rolegome rea nga longamiaume ngaka kura ki nga karakarangana. ");
INSERT INTO mee_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ba sana ngaka mataue ragau reke sapunpune miramiaume, ava ka sana karea ka gingginga ta samungpununge kannumiau. Sana ngaka matau rea. Ke sa. Ngaka mataue Nutu a kana ka gingginga ta raunge kannumiaume ba miramiaume kinung nga malle a sia e pamiralali passavele. ");
INSERT INTO mee_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ragau kinung ka loreamatana roma, ngaroma agau te ngaliua nge miau nge bai ta banga ka manu palu reke sisina, na i ke sane la ravunge lollokanna papatu ki. Ava miau sana nga lomiauvavai roma, Nutu lonapoge manu nginngina te. ");
INSERT INTO mee_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nutu ka lonamatana ka orume kinung ba ke sisitape gilimiau bulvunna reke momo nga kurumiaume. ");
INSERT INTO mee_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Minmina na sana ngaka matau. Miau kaka bollau raumana nga manume nge Nutu raguna. ");
INSERT INTO mee_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Minmina na ngaroma ragau ngeke turupote lopatokona ae ri te iau nga ragau ragureame sonrau, na iau ka la turungpota rea nge Tamau e momo nga mallena nga tava raguna ngarume bole. ");
INSERT INTO mee_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ava ngaroma agau te nge kausikala iau nga ragau ragureame sonrau, na iau ka la kausingkale nge Tamau e momo nga mallena nga tava raguna ngarume. ");
INSERT INTO mee_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Sana nga lomiauvavai roma, iau ka atu ta pangataramasinge ragau re nga mogalo laekia e ngape. Iau ka sana atu ta pangataramasinge ragau. Ke sa. Ka atu ka resalla ta kalingpala rea. ");
INSERT INTO mee_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Iau ka role minmina kurumea, iau ka atu ta kalingpalange “‘apanung nge tamana, ba goe avale nge naname, ba avale nge lonapengana; ");
INSERT INTO mee_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ba ragau reke momo nga bale ae agau te keke la baingaꞌiu ka agau laeala.’ ");
INSERT INTO mee_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Agau e matea tamana o naname raumana nge iau ka sana i a barangalele a kanau. Ba agau e matea tuna o tunapiau raumana nge iau ka sana i a barangalele a kanau. ");
INSERT INTO mee_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ba agau e sane tolea maiskovu ae i be lolakurume iau ka sana i a barangalele a kanau. ");
INSERT INTO mee_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Agau e bai ta kamongpitange maulingngana ke la pangasanrea kia. Ba agau e pasanrea ka maulingngana kurumea loangakurumengana kau ke la kaling pakia. ");
INSERT INTO mee_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Agau a lonangatakala miau ka lonangatakala iau. Ba agau a lonangatakala iau ka lonangatakale Nutu e ba iau. ");
INSERT INTO mee_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ngaroma agau te nga lonangatakale agau e toe Nutu kaona kurumea ka i a agau e toe Nutu kaona, na agau laeala ke la ravunge alanga e pe orae agau e toe Nutu kaona. Ba ngaroma agau te nga lonangatakale agau a baingana tupu kurumea ka i a agau a baingana tupu, na agau laeala ke la ravunge alanga e pe orae agau a baingana tupu. ");
INSERT INTO mee_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ba iau nga role kamiau ka kaomannmannangana roma, ngaroma agau te nga lonangatakale barangalele te a kanau e sina ba nge tunge me e marusu isunte mana ta i inunge kurumea ka i a barangalele a kanau, na agau laeala ke la ravunge alanga ae i e pe.” ");
INSERT INTO mee_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ka inae Iesus rongotapu ka tungngana ka potongome ta barangalele ra kanna ka ri pana tangulelu ba lua, na i ke kaꞌe inaeala ba ke loa ta pangalomatana ba pulingmalagange pangamologa nga maga kunna rae ri reke bollalau. ");
INSERT INTO mee_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nae Ion ke momo nga pulangkala, ba ka ine longe oru rae Karais kumkuma ki, na i ke baꞌe barangalele palu rae i ");
INSERT INTO mee_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ta ri balinglagange Iesus roma, “Ka one a agau laeala ae Nutu role pala ta i atung, o mangng nga ella ta tetoto?” ");
INSERT INTO mee_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nae Iesus ke ale pangamologa ta barangalele nginngina ra Ion kanna roma, “Ngaka loa, na ngaka turu te Ion ka oru ra miau ka longlongo rea ba oru ra miau ka kelkela rea roma: ");
INSERT INTO mee_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ragau ra matarea kanname ke su keke kelkela, ba ra kaereame ke mate keke tatao, ba reke mate keke mauli muni, ba ragau keke pulimalaglage pangamologa e pe ta ra sillolo. ");
INSERT INTO mee_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ba agau e sane kaꞌe lonapatokonangana te iau nga ine kele kumangng ra kanau nga lonasereng.” ");
INSERT INTO mee_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Na ka ina barangalele nginngina rae Ion kanna ke lola, nae Iesus ke ture Ion ta maluame roma, “Ka ina miau ka loa ta kelange Ion nga ina a sana ragau ngia, na miau kaka loa ta kelange taru? Kaka loa ta kelange agau te e sane gingging basema pailli launa ina bovole isomatagtage ae? ");
INSERT INTO mee_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ngaroma nge sa, na miau kaka loa ta kelange taru? Kaka loa ta kelange agau te e lupage lungapaga reke pepe raumana ae? Ngaka kele. Ragau reke lupage lungapaga reke pepe raumana keke mommo nga bale nga kelangpatalime. ");
INSERT INTO mee_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ava miau kaka loa ta kelange taru mannangana? Kaka loa ta kelange agau e toe Nutu kaona ae? Iii, iau nga role kamiau roma, miau kaka loa ta kelange agau e toe Nutu kaona. Ba kaka kele agau e bollau raumana nga agau e toe Nutu kaona. ");
INSERT INTO mee_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ion ka i a agau laeala ameke paꞌe pangamologa te nga Lau Ae Nutu Kanna pala ore role roma: ‘Ngaka kele. Iau ka la bange agau te pala nge one ta i pulingmalagange pangamologa a kanau, ba i ke la kalingtupunge pamau ae one.’ ");
INSERT INTO mee_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Iau nga role kamiau roma, nga mogalo laekia e ngape Ion E Nga Pangamagoe giana ke bollau raumana nga ragau kinung giareame. Ava agau a giana sina bavakena nge Nutu kelangpatalingana nga tava ke bollau nge Ion.” ");
INSERT INTO mee_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ba nga kae rae Ion E Nga Pangamagoe ta ke lele ikia e sonrau, nae Nutu kelangpatalingana nga tava ke umma ta taonga kaligi, ba ragau keke umma kaligi ta kamongpitange. ");
INSERT INTO mee_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Iau ka role minmina kurumea ragau kinung reke toe Nutu kaona ba bangapaga rae Moses kanna keke pulimalaglage pangamologa rae Nutu kanna ta ke lele nga kae rae Ion. ");
INSERT INTO mee_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ba ngaroma miau ngaka bai ta ngatangngkale pangamologa ra kanrea, na miau kaka la kelangapatokone Ion roma, ka i ae Ilaia laeala ameke role pala ta i atung. ");
INSERT INTO mee_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ngaroma agau te nga omona ta longa, na i nge longe pangamologa laekia. ");
INSERT INTO mee_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ava iau ka la maingamia ka tongau ka ragau reke momomauli sonrau? Ri ka tongarea kena ma ragoeme reke tattara nga malle nga banga ka kaning beke kikiu ta goe pattoto ");
INSERT INTO mee_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ka rolengarea kerea roma, “‘Mangng ka isoe isongome ta miau pesing, ava miau ka sana ka bai ta pesing. Ba mangng ka baue baunga te e nga lotaningngana, ava ka sana lomiautani!’ ");
INSERT INTO mee_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Iau ka role minmina kurumea, ka inae Ion atu na i ke kuriri ta kaning ba ke sane innue uain. Na ri keke roma, ‘Kannu e soali te ke momo nge i!’ ");
INSERT INTO mee_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nae Agau Tuna ke atu ba i ke kaninnia kaning ba ke innue uain. Ba ri keke rorole roma, ‘Ngaka kele agau laeala! Ka i agau a kaningkana ba inung uainkana. Ba ka i a ragau reke raravungkinunge takis ba ragau re sane ke lolakurumea bangapagame kolingngarea te.’ Ava iau nga role kamiau roma, ragau ra loreamatana ka lomatana e pe keke la pangakosining ka lomatana laeala ae ri ka baingareame.” ");
INSERT INTO mee_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Iesus ke kuma ka killa papatu reke bollalau nga maga kunna palu reke bollalau, ava ragau re nga maga nginngina ka sana omorea ta ri pulingvalakalange baingarea reke sosoali ba tungnge loreamatenganame te Nutu. Minmina nae Iesus ke rolea pangamologa reke gingging ta maga kunna nginngina roma, ");
INSERT INTO mee_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Oru reke sosoali raumana keke la leleng nge one ae Korasin! Bae Betsaira, one bole! Iau ka role minmina kurumea, taroma Nutu kumangngana reke gingging ra miau ka kela rea teke lele ngae Taia bae Sairon, na ri teke kampiliue baingareangana nganige. Ba teke lupage lungapaga re nga lotaningngana ba teke tara nga sia puna ka loreataningana ta baingarea reke sosoali. ");
INSERT INTO mee_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ava iau nga role kamiau roma, nga kae e nga kalingnana ngarume, na miau kaka la ravunge miralali e bollau raumana nga miralali laeala a re ngae Taia bae Sairon ke la ravunge. ");
INSERT INTO mee_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Bae one ae Kaperneam, ko roma one la ravunge malle a alangpaga e pe e ngailu raumana ae? Ke sa. One ko la loanga ta malle nga reke mate e momo ngape bavakena. Iau ka role minmina kurumea, taroma Nutu kumangngana reke gingging ra miau ka kela rea teke lele ngae Sorom, na maga kunna laeala te momo sonrau tale. ");
INSERT INTO mee_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ava iau nga role kamiau roma, nga kae e nga kalingnana ngarume, na miau kaka la ravunge miralali e bollau raumana nga miralali laeala a re ngae Sorom ke la ravunge.” ");
INSERT INTO mee_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ka kae laeala, nae Iesus ke role kae Nutu roma, “Tamau, ka one ae Nutu A I A Kelangpatali ngailu nga tava ba ngape nga mogalo. Sonrau na iau ka kalapaga one. Iau ka kalapaga one kurumea kumangngang ino pakoea oru kokorai nga ragau re nga mogalo laekia e ngape reke roma ri ra lomatanakana, ava ko pakosining ki ta ragau ra loreamatana ma goe reke sisina. ");
INSERT INTO mee_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iii, Tamau, ko kuma minmina ta, kumangng laeala ke pe raumana nga ragung.” ");
INSERT INTO mee_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nae Iesus ke role ka ragau nginngina reke momo ka kae laeala roma, “Nutu a i ae Tamau ke kalatape orume kinung te iau. Ba ka sana agau te lonamatana kae Nutu Tuna, kana kae Tamana kasikena mana. Ba bole ka sana agau te lonamatana kae Nutu, kana kae Nutu Tuna ba ragau rae Tuna bai ta pangapotange Tamana te ri.” ");
INSERT INTO mee_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Miau ra likimiausa ba ka tololea bangapaga reke maena raumana ngaka atu te iau, na iau ka la tungnge pannang te miau. ");
INSERT INTO mee_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ngaka ngatakale taongamugangaungana kamiau, ba ngaka rave lomatana nge iau. Ngaka bai minmina kurumea, ka iau a agau e kalaumasia ragau ba agau e ulopisigia i muni ngallo nge i. Minmina na miau kaka la kaling paka pannangamiau. ");
INSERT INTO mee_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Iau ka role minmina kurumea, pamau a iau taoamuga kamiau kia ke ate, ba oru ra iau ballaga miau ta tolonga rea keke alaleng.” ");
INSERT INTO mee_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ka kae te nae Iesus ke tatao ngallo nga ura e nga pailli matana eke patoe ka “giren”. Na barangalele ra kanna ka mate karea, minmina na ri keke umma ta utungtotonge giren kunna palu ba keke kaninnia kanreame. ");
INSERT INTO mee_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ava ka inae Parisio palu ke kele ollaeala na keke role kae Iesus roma, “Ngo kele, barangalele ra kaning ke sane ke lolakurumea bangapaga e nga kae a Sabat.” ");
INSERT INTO mee_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Avae Iesus ke ala rea roma, “Miau ka sana ka kele pangamologa laeala eke paꞌe pala ore ta Revit kumangngana ina i kala nga ragau rae i matekarea ae? ");
INSERT INTO mee_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","I ke loalu lakallo ta bale ae Nutu, na ke rave beret laeala ore nga tungnge te Nutu, na ri keke kania. Ba beret laeala ke parototokala ta i kala nga ragau rae i kaninge. Kana ka pirisme mana. ");
INSERT INTO mee_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ba miau ka sana ka kele pangamologa nga Bangapagame ae? Ke role ta ina piris reke umma nga tempel ke umma ta karingtaonge bangapaga e nga Sabat, ava bainga laeala ke sane soali nge Nutu raguna. ");
INSERT INTO mee_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ba iau nga role kamiau roma, otte e bollau raumana nga tempel ikia. ");
INSERT INTO mee_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ngaroma miau nga lomiaumatana masi ka pangamologa laeala mirana ore role roma, ‘Iau ka matea lonana. Ka sana matea posi onreke bali rea beke tungu rea ma tungame,’ na miau ala sana taka kalinane ragau onre sane ke bavaia bainga e soali nge Nutu raguna. ");
INSERT INTO mee_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Iau ka role minmina kurumea, Agau Tuna ka i a Avolau e nga kae a Sabat.” ");
INSERT INTO mee_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nae Iesus ke kaꞌe malle laeala, na ke loalu lakallo ta sinagog ae ri. ");
INSERT INTO mee_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ba agau te a kamana mate ke momo ka kae laeala bole. Minmina na keke ballage Iesus roma, “Bangapagame keke parototokala ita ta pangapenge agau te ka kae a Sabat, o ke sa?” Ri keke ballage minmina ta baina ri ngeke kalipa ka pamau te ta ri turungpaga Iesus kana. ");
INSERT INTO mee_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nae Iesus ke ale pangamologa te ri roma, “Ngaroma agau te e nge miau sipsip ae i nge pupulu nga lulu e lakallo ka kae a Sabat, na i nge rapite ba nge utupataea lagapotu, o ke sa? ");
INSERT INTO mee_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Agau ke bollau raumana nga sipsip nge Nutu raguna! Minmina na bangapagame ke sane ke parototokala ita ta bainge bainga e pe ka kae a Sabat.” ");
INSERT INTO mee_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nae Iesus ke role ka agau laeala a kamana mate roma, “Ngo kalaꞌe kamang.” Na i ke kalaꞌe kamana, na kamana laeala ke pe bavakena, basema kamana tetoto. ");
INSERT INTO mee_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Avae Parisiome keke lelemalaga nga sinagog, na keke potolulu Iesus kana ta ri samungpununge. ");
INSERT INTO mee_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Avae Iesus ka lonamatana ineke bai ta samungpununge, minmina na i ke kaꞌe malle laeala. Na ragau papatu keke loakurumea, na i ke papea ragau kinung re nge ri ra karea ka soaling. ");
INSERT INTO mee_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ba i ke tunge pangamologa e gingging te ri ta ri nga manereasa turunge ta ragau roma, ka i a tai. ");
INSERT INTO mee_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","I ke kuma minmina ta baina pangamologa ae Nutu kanna a agau e toe kaona a giana nge Aisaia rolea pala nge lele mannangana ine role roma, ");
INSERT INTO mee_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Aekia ka i a barangalele a iau tore. Ka i a agau a iau materaumane, ba ka i a agau a baingana pe raumana nga ragugu. Iau ka la ulonge Kannu ae iau nge i, na i ke la pulingmalagange pangamologa e ta kalingnana ae iau e tupu e ngarume ta ragau ra sana ri ra Iura. ");
INSERT INTO mee_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Barangalele laekia a kanau ke sane la palingtete ka pangamologa, ba ke sane la bauluung; ba ragau ke sane ke la longnge kalingngana nga pamaume. ");
INSERT INTO mee_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","I ke la kalaunge ragau re sane ke gingging, ba ke la kalaunge ragau ra likireasa ta kalaunga rea muni. I ke la kumangng minmina ta nge lele nga kae laeala ina iau la pangapotange kalingnana ae iau e tupu e ngarume. ");
INSERT INTO mee_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ba ragau re nga iname kinung keke la momongkala te i ta i ravunglele rea.” ");
INSERT INTO mee_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ngarume, na ri keke rave apanung te a kannu e soali luia, na keke loa kia te Iesus. Agau laeala matana kanname ke su ba ka i a kumba. Nae Iesus ke papea kumba laeala, na i ke pamologa ba matana kanname keke kela. ");
INSERT INTO mee_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Na ragau kinung keke kallo raumana ba keke role roma, “Aekia ka i ae Revit Sivuna laeala ameke paꞌe pangamologa te i pala ae?” ");
INSERT INTO mee_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ava ka inae Parisiome ke longe pangamologa laeala, na keke role roma, “Agau laeala ke taomalaglage kannu reke sosoali ka Beelsebul a i a kannu reke sosoali kelangpatali ae ri ginggingngana mana.” ");
INSERT INTO mee_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Bae Iesus ka lonamatana tapu ka oru reke momo ngallo nga gilirea baganame, minmina na i ke role kerea roma, “Ngaroma ragau reke momo ngape nga kelangpatali te ngeke palikalipala rea muni, na agau laeala kelangpatalingana ke la soaling bavakena. Ba ngaroma ragau re nga maga kunna te o balekaina te ngeke palikalipala rea muni, na balekaina laeala ke sane la meising. ");
INSERT INTO mee_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ngaroma Satan nge taomalage i muni barangalele ra kanna, na i ke umma ta kalingpalange ba sanangkale i muni. Minmina na kelangpatalingana ke la maising gingging mina ngaetai? ");
INSERT INTO mee_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ba ngaroma iau nga taomalaglage kannu reke sosoali ka Beelsebul ginggingngana, na barangalele ra kanmiau keke taomalaglaga rea ka tai ginggingngana? Minmina na barangalele rae miau muni keke pakosining roma, pangamologa a kanmiau ka sana kaomanna kia. ");
INSERT INTO mee_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ava ngaroma iau nga taomalaglage kannu reke sosoali ka Kannu Ae Nutu ginggingngana, na ollaeala ke pakosining roma, Nutu kelangpatalingana ke lele nge miau tapu. ");
INSERT INTO mee_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ba muni, agau te nge taolu ta bale ae agau a likina raumana basema Beelsebul, ba nge ka ka oru nga kanna mina ngaetai? I nge samapite agau laeala a likina raumana pala, na ngarume na i nge taolu ba nge ka ka orume kinung reke momo nga bale ae i. ");
INSERT INTO mee_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Agau e sane kumkuma kala nge iau ke umma ta sanangkala iau. Ba agau e sane pulikinunge ragau kala nge iau ke umma ta taoange pallua nga ragau. ");
INSERT INTO mee_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Minmina na iau nga role kamiau roma, Nutu ke la osungrurunge bainga reke sosoali kinung ba pangamologame kinung ra ragau ke rolebainga kae Nutu ki. Ava ngaroma agau te nge rolebainga kae Kannu ae Nutu, nae Nutu ke sane la osungrurunge bainga laeala e soali. ");
INSERT INTO mee_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ba ngaroma agau te nge patoe pangamologa e soali te Agau Tuna, nae Nutu ke la osungrurunge bainga laeala e soali. Ava ngaroma agau te nge patoe pangamologa e soali te Kannu E Tupu, nae Nutu ke sane la osungrurunge bainga laeala e soali. Ke sane la osungrurunge bainga laeala e soali ka kae kakai re sonrau ba ka kae re ngarume bole. ");
INSERT INTO mee_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ngaroma bega nga i a bega e pe, na bega laeala kanname ngeke pepe bole. O ngaroma bega nga i a bega e soali, na bega laeala kanname ngeke sosoali bole. Iau ka role minmina kurumea, ragau keke kelapatokone bega nga kanname. ");
INSERT INTO mee_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Miau ra mue ra koatali, bainga reke sosoali keke ponu nge miau. Minmina na miau kaka la rolenge onreke pepe mina ngaetai? Iau ka role minmina kurumea, agau kaona ke rorolea taru e momo ngallo nga lona. ");
INSERT INTO mee_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Agau e pe ka nena ka bainga reke pepe keke momo ngallo nga lona, minmina na i ke pamalaglage oru reke pepe. Ba agau e soali ka nena ka bainga reke sosoali keke momo ngallo nga lona, minmina na i ke pamalaglage oru reke sosoali. ");
INSERT INTO mee_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ba iau ka la roleng kamiau roma, nga kae laeala nga kalingnana e ngarume, nae Nutu ke la kalingnanange ragau kurumea pangamologangareame kinung ra ri sane ke kelamasi tao. ");
INSERT INTO mee_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Iau ka role minmina ta, Nutu ke la patongo one ka agau e tupu kurumea pangamologangangme. Ba ke la patongo one ka agau e soali kurumea pangamologangangme bole.” ");
INSERT INTO mee_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nae ra pangalomatanakana nga bangapagame bae Parisio palu keke role kae Iesus roma, “Apangalomatanakana, mangng ka matea ta one kumangng ka killa te e bollau ta baina mangng nga kele.” ");
INSERT INTO mee_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Avae Iesus ke ala rea roma, “Ragau reke momo sonrau baingareame ke soali raumana, ba lokalasa ngareangana te Nutu ke bollau raumana. Keke matea raumana ta ri kelange killa te e bollau. Avae Nutu ke sane la tungnge killa te ri, ava kana ka killa amae agau e toe Nutu kaona ae Iona mana. ");
INSERT INTO mee_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Iau ka role minmina kurumea, Iona momongana ngallo nga lea e bollau siana ka kaeme ka ri mologi ba ka rigome ka ri mologi pala ka tongana kena mana ma inae Agau Tuna ke la momong ngallo nga mogalo e ngape ka kaeme ka ri mologi ba ka rigome ka ri mologi. ");
INSERT INTO mee_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ragau re ngae Niniva keke la maising nga kalingnana e bollau ngarume kala nga ragau reke momo sonrau. Na re ngae Niniva keke la turungpaga reke momo sonrau karea kurumea, ri keke pulivalakale baingarea reke sosoali ba keke tunge loreamatenganame te Nutu ka inae Iona pulimalaglage pangamologa te ri. Ba ngaka kele, agau e bollau raumana nge Iona ikia e momo sonrau. ");
INSERT INTO mee_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ba avale a i a kelangpatali pala ngae Siba ke la maising nga kalingnana e bollau ngarume kala nga ragau reke momo sonrau. Na i ke la turungpaga karea kurumea, i ke pa nga mogalo lisina ta longnge lomatana e pe ae Solomon. Ba ngaka kele, agau a lonamatana raumana nge Solomon ikia e momo sonrau. ");
INSERT INTO mee_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ka ina kannu te e soali nge lelemalagapatali nga agau te, na i nge tatao nga malle reke galgalangngpa ba nge sissilia mallena te e nga pannang. Ava ke sane kalipa ka malle te. ");
INSERT INTO mee_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Minmina na i nge role roma, ‘Iau nga galiu ta bale a iau momo ngia pala.’ Na ka ine nge lele, na nga kelangana ka agau laeala a i kaꞌe pala i ka tongana kena ma bale a sana agau momo ngia oreke sakalolellepaꞌe ba keke pulia orume nga pulingtupungareame. ");
INSERT INTO mee_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Minmina na i nge loa, na nge ngalue kannu reke sosoali raumana nge i ka ri lima ba lua muni. Na ri keke kinung ngeke rave malle ngallo nga agau laeala. Ba momongolungarea nga agau laeala nge soali raumana nga kannu kena e soali momongana ngallo nge i pala. Ragau reke momo sonrau onra baingareame ke sosoali ka la tongarea kena mana ma ollaeala.” ");
INSERT INTO mee_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ka inae Iesus pamolloga ta maluame tale, nae naname bae teiteikia memena keke maisinsi nga potu nga bale, ba ri keke matea ta pangamologa kala nge i. ");
INSERT INTO mee_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Minmina na agau te ke role kae Iesus roma, “Name bae teiteikone memena keke maisinsi io ngapotu, ba keke matea ta ri pangamologa kala nge one.” ");
INSERT INTO mee_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Avae Iesus ke ale agau laeala roma, “Tai ka i ae nau, ba taime ka ri rae teiteikau memena?” ");
INSERT INTO mee_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Na i ke papanau ta barangalele ra kanna ba ke role roma, “Ngaka kele, nau bae teiteikau memena ri korai! ");
INSERT INTO mee_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Iau ka role minmina kurumea, agau e lolakurumea Tamau e momo nga mallena nga tava lonangana ka i a teiteikau bae ligupiau bae nau.” ");
INSERT INTO mee_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ka kae laeala mana, nae Iesus ke lelemalaga lagapotu nga bale na ke tara nga me a sivoli kaona. ");
INSERT INTO mee_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ba ragau reke katukala te i ka ri papatu raumana. Minmina na i ke taepatae nga manang te na ke tara ngia, ba ragau karolu keke maisinsi nga me a sivoli kaona. ");
INSERT INTO mee_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Na i ke role kerea ka oru papatu ka pangateningkalame roma: “Ka kae te na agau te ke loa ta tapunge pailli matana te kanname nga ura ae i. ");
INSERT INTO mee_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ba ka ine taptapu rea nga mogalo, na palu keke pupu nga pamau bavana. Na manume keke atu ba keke kani rea. ");
INSERT INTO mee_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ba pailli kanna palu muni keke pupu nga mogalo ina i a lollo, ba inaeala ka sana mogalo kia raumana. Na pailli kanna nginngina keke kalapa bolvole kurumea, mogalo ke sane lu lakallo raumana. ");
INSERT INTO mee_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ava ka ina kae loapatae, na i ke sina rea na keke mate kurumea, kulareame ke sane ke sigilu lakallo ta mogalo. ");
INSERT INTO mee_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ba pailli kanna palu muni keke pupu ngaliua nga oalo ra matarea. Na oalome ba paillime keke lele kinung, ava oalome keke kalipalipita ka pailli nginngina, na keke mate. ");
INSERT INTO mee_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ava pailli kanna palu keke pupai nga mogalo ine pe. Na keke lele bollau ba keke piau masi. Ba kenakena ka kanna papatu raumana. Palu ka kanrea ka ri giaukaina lima, ba palu ka kanrea ka ri giaukaina mologi, ba palu ka kanrea ka ri giaukaina ba tangulelu. ");
INSERT INTO mee_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ngaroma agau te nga omona ta longa, na i nge longe pangamologa laekia.” ");
INSERT INTO mee_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na barangalele rae Iesus kanna keke loa te i, na keke ballage roma, “Ke meimia na ko umma ta pangamologa ta ragau ka pangateningkalame?” ");
INSERT INTO mee_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Na i ke ala rea roma, “Nutu ke tunge lomatana te miau ta baina nga lomiaumatana ka oru re ta kelangpatalingana nga tava onreke kolulu. Ava ke sane tunge lomatana laeala te ri. ");
INSERT INTO mee_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Iau ka role minmina kurumea, Nutu ke la tungnge lomatana papatu muni ta agau a kana lomatana nga baina i nga kana lomatana papatu raumana. Ava nga agau a sana kana lomatana, Nutu ke la ravungpatali ka lomatana ae i e sina nga baina i sana nga kana lomatana bavakena. ");
INSERT INTO mee_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Minmina na iau ka pamolloga ta ragau pattoto ka pangateningkalame kurumea: “Ri keke kelkela, ava ke sane ke kelapatokona; ba keke longlongo, ava ke sane ke longopatokona ba ka sana loreamatana. ");
INSERT INTO mee_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Minmina na pangamologa a agau e toe Nutu kaona ae Aisaia rolea pala ke lele mannangana ine rolea Nutu pangamologangana te ri roma: “‘Miau ngaka longlongo ta ngaka longlongo, ava sana la lomiaumatana; ba ngaka kelkela ta ngaka kelkela, ava ka sana ka la kelangapatokona. ");
INSERT INTO mee_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ta ragau kokorong loreame keke rutukala; ba keke ponrutukale longareame, ba keke pulakale matarea kanname; Ngaroma matarea kanname ngeke kelkela, ba ngeke longlongo ka longareame, ba loreame nga loreamatana, na ri ngeke kampiliugaliu, na iau ae Nutu nga pape rea.’ ");
INSERT INTO mee_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Avae kavingtulu ke momo nga matamiau kanname kurumea, keke kele oru ra iau kumkuma ki. Ba kavingtulu ke momo nga longamiaume kurumea, keke longe oru ra iau palomatantane ragau ki. ");
INSERT INTO mee_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ta iau ka la roleng kamiau ka kaomannmannangana roma, pala na ragau papatu reke toe Nutu kaona ba ragau papatu reke tupu keke bai ta ri kelange oru nga miau ka kelkela rea, ava ke sane ke kela rea. Ba ri keke bai ta longnge oru nga miau ka longlongo rea, ava ke sane ke longo rea.” ");
INSERT INTO mee_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Nae Iesus ke role kerea roma, “Ngaka longo nasai na ngaka rave lomatana ta pangateningkala laeala ore ta agau e taptapue pailli kanname minakai roma: ");
INSERT INTO mee_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ka ina agau te nge longe pangamologa e ta Nutu kelangpatalingana ava ka sana lonamatana kia, nae Satan nge atu na nge ravupatali ka pangamologa laeala a Nutu toaꞌe ngallo nga agau laeala lona. Agau laeala ka tongana kena ma mogalo inaeala nga pamau bavana ora ura tamana tapue pailli kanname ngia. ");
INSERT INTO mee_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ba mogalo inaeala i a lollo ora pailli kanname ke pupai ngia ka i a pangateningkala e ta agau e longe pangamologa ae Nutu kanna ba ka lonangatakale bolvole ka lonaserengngana. ");
INSERT INTO mee_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ava i ke kamopite ka panna inte mana kurumea, i ka tongana kena ma pailli ra kulareame ke sane ke sigilu lakallo ta mogalo. Ba ka ina maenangme ke lele o ka ina ragau ke pamiralalia kurumea lonapatokonangana ta pangamologa ae Nutu kanna, na i ke kaꞌe lopatokona ae i bolvole mana. ");
INSERT INTO mee_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ba mogalo inaeala a pailli kanname ke pupu ngaliua nga oalo ra matarea ngia ka i a pangateningkala e ta agau e longe pangamologa ae Nutu kanna, ava i ka lonavavai raumana ta oru re nga mogalo laekia e ngape. Ba i ke matea ta ravunge lollokanna raumana, na lollokanna laeala ke gogaꞌe. I ke umma minmina na oru nginngina keke kalipite ma oalo ra matarea, na pangamologa laeala a Nutu toaꞌe ngallo nga lona ke sane piau. ");
INSERT INTO mee_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ba mogalo inaeala a pailli kanname ke pupai nga mogalo e pe kia ka i a pangateningkala e ta agau e longe pangamologa ae Nutu kanna ba ka lonamatana kia. Minmina na i ka tongana kena ma bega reke piaue kanrea papatu raumana muni. Palu keke piaue kanreame ka ri base ma giaukaina lima, ba palu keke piaue kanreame ka ri giaukaina mologi, ba palu muni keke piaue kanreame ka ri giaukaina ba tangulelu.” ");
INSERT INTO mee_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nae Iesus ke rolea pangateningkala te muni te ri roma, “Iau nga toe Nutu kelangpatalingana nga tava ka agau e toaꞌe pailli kanna onreke pepe nga ura ae i. ");
INSERT INTO mee_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ava ka ina ragau kinung ke kenrarau, na agau a baingaꞌiukana ka ura tamana ke loa, na ke toaꞌe pailli kanna onreke sosoali ra sinrea ma uit ngaliua nga pailli ra uit, na ke lao. ");
INSERT INTO mee_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ngarume, ka ina pailli ra uit ke lele ba kunreame keke umma ta leleng bollau, na pailli onreke sosoali keke paturu ta ri leleng bole. ");
INSERT INTO mee_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Na ra kumangngatulu ra ura tamana kanna keke loa te i, na keke role kia roma, ‘Avolau, one ko toaꞌe pailli kanna onreke pepe nga ura ae one, ava ke meimia na ne ngeke sosoali keke umma ta leleng kala nga ne ngeke pepe?’ ");
INSERT INTO mee_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Na ura tamana laeala ke role kerea roma, ‘Agau a baingaꞌiukana kau ke kuma ka kumangng laeala!’ Na ra kumangngatulu ra kanna keke role kia roma, ‘Ko bai ta mangng loanga ta lagangapa rea, o ke sa?’ ");
INSERT INTO mee_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Na i ke ala rea roma, ‘Ke sa. Ta ka ina miau ngaka lagapapaꞌe pailli reke sosoali, na kaka la lagangapaꞌe ne ngeke pepe bole. ");
INSERT INTO mee_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ngeke momo minmina mana, na ri lua ngeke lele kinung ta nge lele nga kae e nga lalang. Na nga kae laeala iau ka la roleng ka ra lalangkana roma, “Ngaka pulikinunge pailli onreke sosoali pala. Na ngaka ligovuta ki ta raunga rea. Ava ngaka ravukinunge pailli ra uit, na ngaka pullu rea lakallo ta bale ae iau nga pulingkinung oru ngia.” ’” ");
INSERT INTO mee_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Na i ke rolea pangateningkala te muni te ri roma, “Nutu kelangpatalingana nga tava ka tongana kena ma bega kanna e sina raumana ora agau rave, na ke toaꞌe nga ura ae i. ");
INSERT INTO mee_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ba bega kanna laeala ke sina raumana nga bega kanname kinung. Ava nga ine nge lele bollau tapu, na ke la bolinglaunga raumana nga bega onreke tota rea nga ura. Ba ke la leleng i a bega nga baina manu reke lolo nga tava ngeke loa, na ngeke kumapai ka ginureame nga kamaname.” ");
INSERT INTO mee_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Na i ke rolea pangateningkala muni te ri roma, “Nutu kelangpatalingana nga tava ka tongana kena ma isi isunte ora avale te rave, na ke kampiliue kala nga plaua ine bollau ta ke lele ina isi isu laeala paluvapaꞌe beret karolu.” ");
INSERT INTO mee_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesus ke rolea oru nginngina kinung ta maluame ka pangateningkalame mana. Ba ke sane rolea pangamologa te a sana i a pangateningkala. ");
INSERT INTO mee_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","I ke kuma minmina ta baina pangamologa a agau e toe Nutu kaona rolea pala nge lele mannangana ine role roma, “Iau ka la pangamologa ka pangateningkalame. Ka la rolenge oru reke ko nganige ta ke lele ikia sonrau.” ");
INSERT INTO mee_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nae Iesus ke kaꞌe maluame, na ke lu lakallo ta bale te. Na barangalele ra kanna keke loa te i, ba keke role kia roma, “Pangateningkala laeala e ta pailli onreke sosoali ra agau toa rea nga ura ka mirana mina laetai? Onto panane te mangng.” ");
INSERT INTO mee_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nae Iesus ke ala rea roma, “Agau laeala e toaꞌe pailli kanna reke pepe ka i a pangateningkala e te Agau Tuna, ");
INSERT INTO mee_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ba ura ka i a ragau re nga mogalo laekia e ngape. Pailli kanna reke pepe ka i a pangateningkala e ta ragau re nga Nutu kelangpatalingana. Ba pailli kanna reke sosoali ra sinrea ma uit ka ri ra ragau rae Satan kanna. ");
INSERT INTO mee_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ba agau a baingaꞌiukana ka ura tamana ore toaꞌe pailli kanna reke sosoali nga ura ka i a Satan. Kae e nga lalang ka i a pangateningkala e ta kae a ronga, ba ra lalangkana ka ri ra anggelome. ");
INSERT INTO mee_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Minmina na kumangng laeala ineke ravukinunge pailli onreke sosoali ba ke rau rea nga sia ka la tongana kena ma oru e la leleng ka kae a ronga. ");
INSERT INTO mee_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nga kae laeala nae Agau Tuna ke la bange anggelo rae i, na ri keke la ravungmalagapatali ka ragau reke sosoali nga Agau Tuna kelangpatalingana. Keke la ravungmalagapatali ka ragau reke bavaia ragau ta ri kumangng ka bainga reke sosoali nge Nutu raguna, ba keke la ravungmalagange ragau reke longosasa te Nutu. ");
INSERT INTO mee_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Na keke la tamaling kerea lakallo ta sia e sane la ronga, nga malle laeala a ragau ke la taning ba ke la tanaginge ngingireame ngia. ");
INSERT INTO mee_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Na ragau ra baingareame ke tupu ka la lamarea ma kae nga Tamarea kelangpatalingana. Ngaroma agau te nga omona ta longa, na i nge longe pangamologa laekia. ");
INSERT INTO mee_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Nutu kelangpatalingana nga tava ka tongana kena ma oru e pe raumana a agau te pakoea nga mogalo pala. Ngarume na agau tetoto ke kalipa kia, ba i ka lonasereng raumana. Minmina na i ke talue nga mogalo muni, na ke loa ba ke ba ka oru rae i kinung, na ke kolia mogalo inaeala. ");
INSERT INTO mee_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ba muni, Nutu kelangpatalingana nga tava ka tongana kena ma agau e tange lollo ra kunreame ke bollau. ");
INSERT INTO mee_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ba ka ine kalipa ka lollo te ora kunna bollau raumana, na i ke loa ba ke ba ka oru rae i kinung, na ke kolia lollo laeala. ");
INSERT INTO mee_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ba muni, Nutu kelangpatalingana nga tava ka tongana kena ma po a ragau ke toatape lakallo ta pelau lona ta launge lea matantana kia. ");
INSERT INTO mee_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ba ka ina leame ke ponu nga po laeala tapu, na keke utulelea lagape ta pelau kaona. Na keke tara ba keke kintatape lea reke pepe nga po, na keke ulo rea nga toangalaume. Ava keke sau ka lea onreke sosoali. ");
INSERT INTO mee_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ba ollaeala ka la tongana kena ma oru e la leleng ka kae a ronga. Nga kae laeala na anggelome keke la lelengmalaga, na keke la ravungmalagapatali ka ragau ra baingareame ke sosoali reke momo ngaliua nga ragau ra baingareame ke tupu. ");
INSERT INTO mee_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Na keke la tamaling kerea lakallo ta sia e sane la ronga, nga malle laeala a ragau ke la taning ba ke la tanaginge ngingireame ngia.” ");
INSERT INTO mee_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nae Iesus ke ballage barangalele ra kanna roma, “Miau ka lomiaumatana ka oru kokorai ra iau role kamiau ki, o ke sa?” Na ri keke ale roma, “Iii, mangng ka lomangngmatana ki.” ");
INSERT INTO mee_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Na i ke role kerea roma, “Ngaroma minmina, na miau ka la lomiaumatana ina iau la roleng kamiau roma, agau alomatanakana ka bangapagame ore lele i a barangalele e nga Nutu kelangpatalingana ka tongana kena ma bale tamana ore rave onra pau ba onra kasana kinung nga sasaipuna ae i.” ");
INSERT INTO mee_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ka inae Iesus rongo ta roleng kerea ka pangateningkala nginngina tapu, na i ke kaꞌe inaeala. ");
INSERT INTO mee_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ba ka ine lele nga magapuna ae i, na i ke lu lakallo ta sinagog ae ri, ba ke paturu ta pangalomatanange ragau. Ba ka ineke longe pangamologangana, na ri keke magio raumana, ba keke palirorole kerea roma, “Agau laekia ke rave lomatana laekia e pe ngae tai? Ba tai ke tunge gingginga laekia te i ta i kumangng ka killa kakong reke bollalau? ");
INSERT INTO mee_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ka i a popongpita laeala tuna mana. Ba naname ka i a avale laeala eke patoe kae Maria, ba ka teiteikia memena nge Iems, bae Iosep, bae Saimon, bae Iuras. ");
INSERT INTO mee_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ba liuna piau memena kinung keke momo ikia nga maga kunna ae ita. Ava i ke rave lomatana laekia ngae tai? Ba tai ke tunge gingginga laekia te i ta i kumangng ka killa kakong reke bollalau?” ");
INSERT INTO mee_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Minmina na ri ka sana loreapatokona te i. Avae Iesus ke role kerea roma, “Ragau re nga magame kinung keke la tungnge alangpaga ta agau e toe Nutu kaona, ava ragau re nga magapuna ae i ba ragau re nga balekaina ae i muni, ke sa.” ");
INSERT INTO mee_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Minmina nae Iesus ke sane kuma ka killa papatu reke bollalau nga inaeala ta ri ka sana loreapatokona te i. ");
INSERT INTO mee_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ka kae nginngina, nae Eroto a i e kapunu nga gavaman e ngae Rom nga inaeala ke longe Iesus kana turung. ");
INSERT INTO mee_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Na i ke role ka ra kumangngatulu rae i roma, “Agau laeala e kumkuma ka oru nginngina ka i ae Ion E Nga Pangamagoe. I ke mate ava ke sigipaga nga mateng! Minmina na gingginga reke bollalau raumana keke umma ta leleng nge i.” ");
INSERT INTO mee_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Pala, nae Eroto ke rave i muni tataokia napengana a giana kae Erorias. Nae Ion ke rorole kia roma, “Ke parototokala ta one ravunge avale laeala.” Minmina nae Eroto ke baꞌe ra balingkana ta ri launge Ion, na keke samapite ba keke ule nga pulangkala. ");
INSERT INTO mee_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Bae Eroto ke bai ta i samungpununge Ion, ava ke mataue maluame kurumea, ri keke role roma, Ion ka i a agau te e toe Nutu kaona. ");
INSERT INTO mee_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ava ka kae te, nae Eroto ke baia kaning te ta pangaserengkalange kae a naname toapisigia. Ba ka kae laeala nae, Erorias tuna piau a malaui ke pesi ngamuga nga ragau reke momo nga kaning laeala. Na malaui laeala ke paserengea Eroto raumana. ");
INSERT INTO mee_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Minmina na i ke patokala ngailu ta i tungnge taru a malaui laeala matea te i. ");
INSERT INTO mee_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ba ka ine ballage naname, na naname ke role kia ta i roleng kae Eroto roma, “Iau ka matea ta one ulonge Ion E Nga Pangamagoe kunna nga raliu te, na ngo atu kia nasai te iau.” ");
INSERT INTO mee_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Na ka inae Eroto a i a kelangpatali longe pangamologa laeala, na i ka ragunaso. Ava pala na i ke patokala ngailu ka pangamologanganame, ba reke tattara ta kaning kala nge i keke longe patongkalangana nginngina. Minmina na i ke ngata ta i tunge ollaeala a malaui laeala ballage te te i. ");
INSERT INTO mee_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ka baina i ke baꞌe ra balingkana palu ta pulangkala ta ri telengtotonge Ion ganna. ");
INSERT INTO mee_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Na keke ule kunna nga raliu te, na keke atu kia ba keke tunge ta malaui laeala. Na i ke loa kia ta naname. ");
INSERT INTO mee_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Na barangalele rae Ion kanna keke atu, na keke rave Ion mirana na keke talue. Na keke loa ba keke turu pakae Iesus. ");
INSERT INTO mee_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Na ka inae Iesus longe ollaeala e lele nge Ion, na i ke taepatae nga manang ba ke kaꞌe inaeala ta loanga ta inte a sana ragau ngia, ta baina i nge momo mana me i. Ava ka ina maluame ke longe pangamologa e ta Iesus kangana, na keke lelemalaga nga maga kunna reke bollalau, ba keke tao ta ri loangakurumea. ");
INSERT INTO mee_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Na ka inae Iesus solele nga me a sivoli kaona ba ke kele maluame, na i ka lonavavai te ri ba ke papea ragau re nge ri ra karea ka soaling. ");
INSERT INTO mee_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ba ka ina kae barelulu, na barangalele ra kanna keke loa te i na keke role kia roma, “Ka sana kaning nga malle laekia ba kae ke barelulu tapu. Minmina na ngo baꞌe maluame ta ri loangalu ta magame ta koling karea kaning.” ");
INSERT INTO mee_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Avae Iesus ke ala rea roma, “Ke meimia aka bai ta banga rea? Miau ngaka tungu karea kaning.” ");
INSERT INTO mee_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Na barangalele ra kanna keke ale roma, “Ka kamangnga bereteme ka ri lima ba lea lua mana rikorai.” ");
INSERT INTO mee_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nae Iesus ke role kerea roma, “Ngaka atu ki nasai.” ");
INSERT INTO mee_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Na i ke role ka ragau ta ri tarang nga pailli. Na ke rave bereteme ka ri lima ba lea lua nginngina, na ke kelapatae, ba ke kalapage Nutu. Na ke regipale bereteme, ba ke tungu rea ta barangalele ra kanna ta ri tavoanga ki nga ragau. ");
INSERT INTO mee_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Na ragau kinung keke kani ba keke rongo ka loreanganame ka kaning laeala. Na barangalele rae Iesus kanna keke ravukinunge kaning kaloname reke kanilele rea, na keke paponue guratame ka ri tangulelu ba lua ki. ");
INSERT INTO mee_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ba ragau reke kani ka kae laeala ka ri basema ra panung ka ri 5,000, ba ka ravale ba goeme keke momo bole. ");
INSERT INTO mee_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ka panna isunte ngarume, nae Iesus ke role ka barangalele ra kanna ta ri taengapatae nga manang te. Na ke ba rea ta ri loanga pala nge i ta me a sivoli bavana tetoto. Avae Iesus ke momo nga baina i nge baꞌe maluame ngeke lao. ");
INSERT INTO mee_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ka ine baꞌe maluame eke loa tapu, na i kasikena ke loapatae ta kapangng ta i kavang. Ba ka ina kae barelu, na i ke momo mana me i. ");
INSERT INTO mee_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ava manang laeala a barangalele ra kanna ke momo ngia ke momo ngatauga nga me a sivoli kaona tapu. Ba miniuame keke balvalia manang ka balingkolopita ngareangana kia kurumea, bovole ke sanangkalkale manang taongana. ");
INSERT INTO mee_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na ka rigo luana, nae Iesus ke loa te ri ka taongapaingana nga me a sivoli. ");
INSERT INTO mee_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ba ka ina barangalele ra kanna ke kele ine tataopai nga me a sivoli, na keke matau raumana. Ba keke reli kaligi ka mataungarea roma, “Ka i a kannu te!” ");
INSERT INTO mee_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ava bolvole mana nae Iesus ke role kerea roma, “Ngaka momo masi! Iau ikia. Sana ngaka matau.” ");
INSERT INTO mee_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nae Pita ke ale roma, “Avolau, ngaroma one ikolong, na ngo role kau ta iau taonga te one nga me.” ");
INSERT INTO mee_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nae Iesus ke role kia roma, “Ngo atu.” Ka bainae Pita ke somalaga nga manang, na ke tatao e lola te Iesus ka taongapaingana nga me. ");
INSERT INTO mee_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ava ka ine kelapa ka bovole, na i ke matau. Ba ka ine paturu ta maraleng, na i ke reli kaligi roma, “Avolau, ngo ravulele iau!” ");
INSERT INTO mee_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ka pannasa mana, nae Iesus ke kalaꞌe kamana, na ke ravupite. Ba ke role kia roma, “One a kang ka lopatokona e sina, ke meimia na ka long lualua?” ");
INSERT INTO mee_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ba ka ineke taepatae nga manang, na bovole ke mate. ");
INSERT INTO mee_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Na reke momo nga manang keke kalapage Iesus ka rolengarea roma, “Ka one ae Nutu Tuna ka kaomannmannangana.” ");
INSERT INTO mee_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ba ka ineke ulutote me a sivoli tapu, na keke lele nga ine ngae Genesaret. ");
INSERT INTO mee_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ba ka ina ragau re nga inaeala ke kelapatokone Iesus, na ri keke ba ka pangamologa ta magame kinung reke momotaliue inaeala. Na ragau keke atu ka ragau kinung ra karea soaling te i. ");
INSERT INTO mee_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ba keke tanikalkale ta i ngatangng ta ra karea soaling ngeke kali ka lungapaga ae i sigina matana mana. Ba ragau kinung reke kali kia mirareame keke pepe. ");
INSERT INTO mee_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nae Parisio palu ba ragau palu ra pangalomatanakana nga bangapagame keke pa ngae Ierusalem, na keke loa te Iesus, ba keke ballage roma, ");
INSERT INTO mee_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ke meimia na barangalele ra kaning keke longosasa ta sisiukita memena baingareame? Ke sane ke palellepapaꞌe kamareame pala ta ri kaninge beret kurumea sisiukita memena baingareame.” ");
INSERT INTO mee_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nae Iesus ke ala rea roma, “Ba miau bole, ke meimia na miau kaka longlongo raumana ta sisiukamiau memena baingareame, ava kaka longosasa ta bangapaga rae Nutu kanna? ");
INSERT INTO mee_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Iau ka role minmina kurumea, Nutu ke role roma, ‘One ngo alapage tamang bae name.’ Ba ke role bole roma, ‘Ngeke sapune agau e rolesolali ka tamana o naname.’ ");
INSERT INTO mee_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ava miau kaka rorole roma, ngaroma agau nge role ka tamana o naname roma, ‘Oru ra kanau ra miau ka bai ta ravunge kalaungapaga ki ka ri ra tunga re nga tungnga rea te Nutu mana,’ ");
INSERT INTO mee_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","na i nga manenasa kalaunge tamana o naname ka oru nginngina. Minmina na miau kaka balvali ka gimiaume ta bangapaga rae Nutu kanna ka loangakurume ngamiaungana ka bainga ra miau ka ravu rea nga sisiukamiau memena. ");
INSERT INTO mee_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Miau ra goangakana, Nutu pangamologangana onra agau e toe kaona ae Aisaia role rea pala keke turupote baingamiaume mannangana ine role roma, ");
INSERT INTO mee_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Ragau kokorai keke alapagpaga iau ka kaoreame, ava loreame keke momo ngatauga nge iau. ");
INSERT INTO mee_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Keke kalapagpaga iau ka mirarea ina nge ngapotu mana. Keke palomatantane ragau ka lomatana ae ri muni, na keke role roma, lomatana laeala ke pa nge iau.’” ");
INSERT INTO mee_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nae Iesus ke kiue maluame te i, na ke role kerea roma, “Ngaka longo nasai nga baina nga lomiaumatana masi. ");
INSERT INTO mee_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Oru e lu lakallo ta agau te kaona sane totorong ta pangamukune agau laeala nge Nutu raguna. Ke sa. Oru reke lelemalaglaga nga kaona, oru nginngina keke pamukunkune nge Nutu raguna.” ");
INSERT INTO mee_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Na barangalele rae Iesus kanna keke atu te i, na keke role kia roma, “Ka longmatana roma, pangamologa laeala a kaning ke bairaguso ka Parisiome?” ");
INSERT INTO mee_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nae Iesus ke ala rea roma, “Tamau e momo nga mallena nga tava ke la lagangapage begame kinung ra i sane toa rea. ");
INSERT INTO mee_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Sana nga lomiauvavai raumana ta Parisio nginngina. Ri ka tongarea kena ma ra matasu reke amva ta taongamuga ka ra matasu pattoto. Ba ngaroma agau a matasu nge ava ta taongamuga ka matasu tetoto, na ri pana lua kinung keke la pupungalu lakallo ta lulu te.” ");
INSERT INTO mee_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nae Pita ke role kae Iesus roma, “Into panana mangng ka pangateningkala laeala e ta oru e pamukune agau.” ");
INSERT INTO mee_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nae Iesus ke ballage barangalele ra kanna roma, “Ba miau bole, ka sana lomiaumatana ae?” ");
INSERT INTO mee_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ngaka kele. Oru reke lulu lakallo ta agau kaona keke taolulu ta siana, na ngarume na keke lelemalaglaga ta malle a gusali. ");
INSERT INTO mee_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ava oru reke lelemalaglaga nga agau kaona keke pa nga lona, ba oru nginngina keke pamukunkune agau laeala nge Nutu raguna. ");
INSERT INTO mee_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Iau ka role minmina kurumea, oru reke momo ngallo nga agau lona ava keke lelemalaglaga ka onreke sosoali raumana basema: lovaingana reke sosoali, ba bainga re nga samungpununge ragau, ba bainga re nga kenong kala nga agau a sana i a agau laeala napengana o natale, ba bainga re nga kenong kala nga rapanung o ravale kalaoka, ba bainga re nga golong, ba bainga re nga turung goang, ba bainga re nga rolengsoali ka ragau pattoto. ");
INSERT INTO mee_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Oru nginngina keke pamukunkune agau te nge Nutu raguna. Ava agau e sane palellepaꞌe kamaname pala ta i kaning ke sane pamukunkune i muni nge Nutu raguna. ");
INSERT INTO mee_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nae Iesus ke kaꞌe inaeala, na ke loa ta ine re ngae Taia bae Sairon. ");
INSERT INTO mee_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na avale te e ngae Kenan ke lelemalaga nga inaeala, na ke loa te Iesus ka kiungana te i roma, “Avolau, one ae Revit sivuna, nga longnana iau! Kannu reke sosoali keke luia tugu piau, ba keke umma ta baingasoalinge raumana.” ");
INSERT INTO mee_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Avae Iesus ke sane alakale avale laeala ka pangamologa inte. Minmina na barangalele ra kanna keke loa te i, na keke role kia gingging roma, “Baꞌe nge lao, ta i ke tataokurumea ita ba ke umma ta lavongkala ita raumana ka taningkalangana.” ");
INSERT INTO mee_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Avae Iesus ke ala rea roma, “Nutu ke ba iau ta ragau re ngae Israel mana ra ri ra ragau reke basema sipsip reke taopa.” ");
INSERT INTO mee_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ava avale laeala ke loa te Iesus, na ke parovanu ngamuga nge i ka rolengana kia roma, “Avolau, ngo kalau iau!” ");
INSERT INTO mee_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nae Iesus ke ale roma, “Ke sane pe ta ravunge beret ae bale tamana goe rae i na tamaling ki ta gauneme.” ");
INSERT INTO mee_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ava avale laeala ke role kia roma, “Ka kaomanna Avolau, ava gauneme bole keke kaninnia kaning mamauna reke pupisigi nga tamarea pala ae i.” ");
INSERT INTO mee_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nae Iesus ke role kia roma, “Avale, lopatokona ae one ke bollau raumana! Iau ka la tungnge ollaeala a one ballaga iau te te one.” Ba ka panna laeala mana, na avale laeala tuna piau ke pe. ");
INSERT INTO mee_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nae Iesus ke kaꞌe inaeala, ba ke tao kurumea Sivoli Ae Galili kaona. Na ke loapatae nga kapangng te, ba ke tara nangina. ");
INSERT INTO mee_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Na malua reke bollalau keke loa te i ka paungarea ka ragau ra kaereame ke soali, ba ragau ra kaereame ke mate, ba ragau ra matarea kanname ke su, ba ragau ra kaoreame ke sane ke pamolloga, ba ragau pattoto ra ri papatu bole. Na keke pakeno rea kokoro nge Iesus kaename. Na i ke pape rea. ");
INSERT INTO mee_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Na malua nginngina keke kallo raumana ineke kele ragau ra kaoreame ke sane ke pamolloga pala ineke pamolloga, ba ragau ra kaereame ke soali pala ineke pepe muni, ba ragau ra kaereame ke mate ineke tatao, ba ragau ra matarea kanname ke su pala ineke kelkela. Ba ri keke kalapagpage Nutu orae Israel. ");
INSERT INTO mee_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nae Iesus ke kiue barangalele ra kanna te i, na ke role kerea roma, “Iau ka lauvavai raumana ta maluame kurumea, ri keke momo kala nge iau ka kaeme ka ri mologi tapu ba ka sana karea kaning. Ba ngaroma iau nga ba rea ngeke lao ka mateng kareangana, na likisa ngareangana nge bai kerea ta ri pupunga ineke tatao nga pamau.” ");
INSERT INTO mee_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Na barangalele ra kanna keke role kia roma, “Ita kaka momo nga malle a sana kaning ngia ba ragau kokorai ka ri papatu raumana, minmina na ita kaka la ravunge beret ngaetai nga baina ri kinung ngeke kani?” ");
INSERT INTO mee_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nae Iesus ke ballaga rea roma, “Ka kamiau beret pia rikorong?” Na keke ale roma, “Ka ri lima ba lua, ba ka lea tutuna reke sisina rikai.” ");
INSERT INTO mee_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ka bainae Iesus ke role ka malua ta ri tarang ngape nga mogalo. ");
INSERT INTO mee_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Na i ke rave beret nginngina ka ri lima ba lua ba lea nginngina, ba ka ine kalapage Nutu tapu, na i ke regipale bereteme ba ke kole leame. Na ke tungu rea ta barangalele ra kanna ta ri tavoanga ki nga ragau. ");
INSERT INTO mee_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Na ragau kinung keke kani ba keke rongo ka loreanganame ka kaning laeala. Na barangalele rae Iesus kanna keke ravukinunge kaning kaloname reke kanilele rea, ba keke paponue gurata reke bollalau ka ri lima ba lua ki. ");
INSERT INTO mee_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ba ragau reke kani ka kae laeala ka ri basema ra panung ka ri 4,000, ba ka ravale ba goeme bole. ");
INSERT INTO mee_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ba ka inae Iesus baꞌe malua eke loa tapu, na i ke taepatae nga manang te, na ke loa ta ine re ngae Magaran. ");
INSERT INTO mee_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Na ra pangalomatanakana nga bangapagame bae Parisio palu keke loa te Iesus, ba keke bai ta avange. Minmina keke ballage ta i kumangng ka killa te e bollau, ta baina i nge pakosining rea roma, i ke kumkuma nga Nutu ginggingngana ka kaomannmannangana. ");
INSERT INTO mee_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ava i ke ala rea roma, “Nga ina kae nge barelulu, na miau ngaka role roma, ‘Kae e ngangaila ke la penga, ta tava ke tente.’ ");
INSERT INTO mee_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ava nga sinro na miau kaka la roleng roma, ‘Kue ke la tugung, ta tava ke tente ba ke saisainga.’ Miau ka lomiaumatana ta kelangapatokonange oru reke lele nga tava, ava ka sana lomiaumatana ta kelangapatokonange oru rae Nutu kumkuma ki ka kae re sonrau. ");
INSERT INTO mee_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ragau reke momo sonrau baingareame ke soali raumana, ba lokalasa ngareangana te Nutu ke bollau raumana. Keke matea raumana ta ri kelange killa te e bollau. Avae Nutu ke sane la tungnge killa te ri. Ke sa. Ke la pangakosining rea ka killa laeala ame pakosining kia pala nga agau e toe Nutu kaona ae Iona mana.” Nae Iesus ke kaꞌe rea, na ke lao. ");
INSERT INTO mee_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Na ri keke ulutote me a sivoli na keke lele nga bavana tetoto, ava barangalele rae Iesus kanna ka loreapogo ta loanga ka beret kurume rea. ");
INSERT INTO mee_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nae Iesus ke role kerea roma, “Miau ngaka ella miau masi ta isi orae Parisiome ba ra pangalomatanakana nga bangapagame.” ");
INSERT INTO mee_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Na ri keke sissilia pangamologangana laeala mirana, ba keke palirorole kerea roma, “I ke role minmina kurumea, ita ka sana ka atu ka beret kurume ita.” ");
INSERT INTO mee_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Avae Iesus ka lonamatana ka taru a ri ke pamolloga te, minmina na i ke ballaga rea roma, “Miau ra kamiau ka lopatokona e sina, kaka meimia aka pamolloga ngaliua nge miau ta ina sana kamiau beret? ");
INSERT INTO mee_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Miau ka sana lomiaumatana tale ae? Ka ina ragau nginngina ka ri 5000 ke kania beret nginngina ka ri lima, na amaka paponue guratame ka ri pia? ");
INSERT INTO mee_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","O ka ina ragau nginngina ka ri 4000 ke kania beret nginngina ka ri lima ba lua, na amaka paponue guratame ka ri pia? ");
INSERT INTO mee_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kaka meimia na miau ka sana lomiaumatana roma, pangamologa laeala e ta isi ama role pakamiau kia ke sane pamologa ta beret? Ke sa. Nga pangamologa laeala, iau ka rorole kamiau ta miau ngaka ella miau masi ta isi orae Parisiome ba ra pangalomatanakana nga bangapagame.” ");
INSERT INTO mee_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Na barangalele rae Iesus kanna ka loreamatana roma, i ke sane rorole kerea ta ri ngeke ella masi ta isi laeala a ragau ke pulia nga bereteme. Ke sa. I ke rorolea pangamologa ore ta Parisiome ba ra pangalomatanakana nga bangapagame pangalomatanangareame. ");
INSERT INTO mee_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ka inae Iesus lele nga ine ngae Sisaria Pilipai, na i ke ballage barangalele ra kanna roma, “Ragau keke rorole roma, iau ae Agau Tuna ka iau a tai?” ");
INSERT INTO mee_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Na ri keke ale roma, “Palu keke rorole roma, Ion E Nga Pangamagoe ame mate ave mauli muni. Ba pattoto keke rorole romae, Ilaia. Ba palu muni keke rorole romae Ieremaia o agau te e toe Nutu kaona ore mate pala ave mauli muni.” ");
INSERT INTO mee_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nae Iesus ke ballaga rea bole roma, “Ava miau kakorong, kaka role roma, iau a tai?” ");
INSERT INTO mee_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nae Pita ke ale roma, “Ka one ae Karais a i a Nutu e momo mauli Tuna.” ");
INSERT INTO mee_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nae Iesus ke ale roma, “Saimon, one ae Iona tuna, Nutu ke kavitulu one raumana. Iau ka role minmina kurumea, one ko sano rave lomatana laeala nga agau te. Ke sa. Tamau e momo nga mallena nga tava ke tunge lomatana laeala te one. ");
INSERT INTO mee_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ba bole iau nga role kone roma, giang nge Pita ora mirana roma ‘lollo’, ba iau ka la kumangngpai ka ra lopatokonakana te iau ginungarea nga lollo laekia. Ba mateng sana nga kana gingginga ta ulongpisigia. ");
INSERT INTO mee_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ba iau ka la tungnge Nutu kelangpatalingana nga tava kana kingapolame te one. Minmina na taru ra one sano ngatakala rea nga mogalo laekia e ngape, Nutu sane la ngatangngkala rea nga mallena nga tava. Ba taru ra one ngatakala rea nga mogalo laekia e ngape, Nutu ke la ngatangngkala rea nga mallena nga tava bole.” ");
INSERT INTO mee_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nae i ke tunge pangamologa e gingging ta barangalele ra kanna ta ri nga manereasa turunge ta ragau roma, ka i ae Karais. ");
INSERT INTO mee_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ka kae nginngina nae Iesus ke paturu ta turunge matengana nga kae te e ngarume ta barangalele ra kanna. I ke ture ine la loanga tae Ierusalem, nae Iurame ravollalaukerea memena, ba re kapunu nga pirisme, ba ra pangalomatanakana nga bangapagame keke la bainge oru matantana ta ri pangamiralalia. Na keke la samungpununge, ava ka kae a mologi ngarume nga matengana, nae Nutu ke la pangasigingpagange nga mateng. Na i ke la mauling muni. ");
INSERT INTO mee_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nae Pita ke rave Iesus balakala ba ke paturu ta mologang kia roma, “Ke sa Avolau, Nutu sane la ngatangng ta ollaeala! Ollaeala nga manenasa leleng nge one.” ");
INSERT INTO mee_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Avae Iesus ke kampiliu, na ke role kae Pita roma, “Satan, lo ngo loa lagarume ta gigu! Ko bai ta bongatotokala iau, ta one ko sano matea oru rae Nutu mate rea. Ke sa. Ko matea oru ra ragau ke mate rea.” ");
INSERT INTO mee_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nae Iesus ke role ka barangalele ra kanna roma, “Ngaroma agau te nge bai ta atung kurume iau, na i nge bali ka gina ta i muni lonamatenganame ba nge rave maiskovu ae i. Na nge tataokurume iau. ");
INSERT INTO mee_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Iau ka role minmina kurumea, agau e bai ta ravunglelenge i muni maulingngana ke la pangasanrea kia. Ava agau e pasanrea ka i muni maulingngana kurumea taongakurumengana kau ke la kalingpa ka maulingngana. ");
INSERT INTO mee_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Iau ka role minmina kurumea, agau ke la ravunge taru, ngaroma i nge rave orume kinung reke pepe nga mogalo laekia e ngape sonrau, ava ngarume na i muni maulingngana nge sanrea? O agau nge totorong ta tungnge taru ta ravung galiunge i muni maulingngana ngaroma i nge sanrea tapu? ");
INSERT INTO mee_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Iau ka role minmina kurumea, Agau Tuna ke la atung kala nga anggelo rae i nga olamana e toakala orae Tamana. Na i ke la tungnge agau kenakena alang ae i kurumea agau laeala bainganame. ");
INSERT INTO mee_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Iau nga role kamiau ka kaomannmannangana roma, palu nge miau raka meisinsi ikia ke sane ke la mateng ta nge lele nga ina ri ke la kelange Agau Tuna ine la leleng ta kelangpatali nga kelangpatali ae i.” ");
INSERT INTO mee_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ngarume, ka ina kaeme ka ri lima ba kena ke rongo tapu, nae Iesus ke loa kae Pita, bae Iems, bae Iems teiteikia ae Ion kala nge i, na ri kasikerea keke loapatae nga kapangng te e gavili. ");
INSERT INTO mee_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nae Iesus mirana ka kelangana toto nga ragureame, ba raguna ke toa ma kae e momo nga tava. Ba lungapaga rae i keke kavauvaunga raumana ma olamana. ");
INSERT INTO mee_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ba ka panna laeala mana, na ri keke kele Moses bae Ilaia ineke lele beke pamolloga kala nge Iesus. ");
INSERT INTO mee_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nae Pita ke role kae Iesus roma, “Avolau, ke pe ta mangng momong nakai. Ngaroma ngo matea, na iau ka la kumangng ka mannsalalame ka ri mologi, nga baina nga ningi te, bae Moses nga nena te, bae Ilaia nga nena te bole.” ");
INSERT INTO mee_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ka inae Pita pamolloga tale, na mukmukua te a lamana ke gasipita rea. Na kaling te ke lelemalaga nga mumukua laeala ka pangamologangana roma, “Aekolong ka i ae Tugu ora iau materaumane ba ka laupe kia raumana. Miau ngaka longo te i!” ");
INSERT INTO mee_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ka ina barangalele rae Iesus kanna ke longe ollaeala, na keke toarau lagape ka ragureame ta mogalo ka mataungarea. ");
INSERT INTO mee_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Avae Iesus ke loa te ri, na ke kali kerea ba ke role kerea roma, “Ngaka sigipaga, ba sana ngaka matau.” ");
INSERT INTO mee_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ba ka ineke ilapaga, na ke sane ke kele agau te, avae Iesus mana me i. ");
INSERT INTO mee_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na ka ineke soinsigi nga kapangng, nae Iesus ke role kerea gingging roma, “Sana ngaka ture kelanga laeala a miau ka kele ta agau te ta nge lele nga inae Agau Tuna nge sigipaga tapu nga mateng.” ");
INSERT INTO mee_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Na barangalele ra kanna keke ballage roma, “Ngaroma minmina, na ke meimia na ra pangalomatanakana nga bangapagame keke rorole roma, ka i ae Nutu lonangana ta Ilaia nge atu kapunu nge Mesaia?” ");
INSERT INTO mee_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nae Iesus ke ala rea roma, “Ilaia ke la atung ka kaomannmannangana, na i ke la pulinggaliunge orume kinung muni. ");
INSERT INTO mee_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ava iau nga role kamiau roma, Ilaia ke atu tapu ba ri ke sane ke kelapatokone, ava keke kuma kia kurumea loreangana mana ka baingasoali ngareangana kia. Ba ollaeala ka tongana kena mana ma ina ri ke la pangamiralalia Agau Tuna ngarume.” ");
INSERT INTO mee_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ka inae Iesus rolea pangamologa laeala e ta Ilaia te ri, na barangalele ra kanna ka loreamatana roma, i ke rorolea pangamologa e ta Ion E Nga Pangamagoe. ");
INSERT INTO mee_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Na ka inae Iesus kala nga pana mologi nginngina ke lele nga maluame, na agau te ke loa te Iesus, ba ke parovanu ngamuga nge i, na ke role kia roma, ");
INSERT INTO mee_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Avolau, nga longnanne tugu ta i ke baigaugau ba ke soali raumana. Ka kae papatu, na i ke umma ta pupungapai nga sia, ba ke umma ta pupungalu ta me ka kae papatu bole. ");
INSERT INTO mee_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ba iau ka atu kia ta barangalele ra kaning, ava ri ka sana karea gingginga ta pangapenge.” ");
INSERT INTO mee_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nae Iesus ke role kerea roma, “Miau ra ragau raka momo sonrau, ka sana lopatokona nge miau, ba lomiaume ke sane ke tupu. Iau ka la momong kala nge miau pa pia muni? Ba ka la kalaungapaga miau pa pia? Ngaka atu ka goe laekolong nasai te iau.” ");
INSERT INTO mee_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nae Iesus ke sanggipite kannu laeala e soali, na i ke lelemalagapatalia goe laeala, ba ka panna laeala mana na goe laeala a panung ke pe. ");
INSERT INTO mee_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ngarume na barangalele rae Iesus kanna keke loagome te Iesus ine momo mana me i, na keke ballage roma, “Ke meimia na mangng ka sana kamangng gingginga ta taongamalagange kannu laeala e soali?” ");
INSERT INTO mee_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nae Iesus ke ala rea roma, “Ka sana kamiau gingging ta taongamalagange kannu laeala e soali kurumea, lopatokona ae miau ke sina raumana. Ta iau nga role kamiau ka kaomannmannangana roma, taroma lopatokona ae miau nge sina raumana ma bega a more kanna te mana, na miau taka role ka kapangng laeo roma, ‘Ngo sigipaga na ngo loa ta inaeala,’ na i nge longo mana te miau. Ba orume kinung ra miau ka bai ta kumangng ki kaka la kumangng ki mana.  ");
INSERT INTO mee_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ava nga kannu matana laeala e soali, miau kaka la taongamalagange ka kavanga ba kuringa ta kaning mana. Ka sana pamau tetoto ta taongamalagange.” ");
INSERT INTO mee_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Na ngarume, ka ina ri ke katukala kinung ngae Galili, nae Iesus ke role kerea roma, “Ragau keke la ulonge Agau Tuna nga reke bai ta baingasoalinge kamareame. ");
INSERT INTO mee_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Na ri keke la samungpununge, ava nga kae a mologi ngarume nga matengana, nae Nutu ke la pangasigingpagange nga mateng.” Na ka ina barangalele rae Iesus kanna ke longe pangamologa laeala, na ri ka loreatani raumana. ");
INSERT INTO mee_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ka ineke lele ngae Kaperneam, na ragau reke raravukinunge takis e nga tempel keke loa te Pita, na keke ballage roma, “Apangalomatanakana ae miau ke tungtunge takis e nga tempel, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nae Pita ke ala rea roma, “Iii, i ke tungtunge.” Ngarume, ka inae Pita lu lakallo ta bale a ri ke momo ngia, ba pala ta i balinglagapitange Iesus ta takis laeala, nae Iesus muni ke ballage roma, “Saimon, one ka longvavai mina ngaetai? Kelangpatali re nga mogalo laekia e ngape keke rarave takisme ba lollokanna matana nginngina nge taime? Keke raravu rea nga goe rae ri muni, o keke raravu rea nga ragau pattoto?” ");
INSERT INTO mee_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nae Pita ke ale roma, “Keke raravu rea nga ragau pattoto nanguni.” Nae Iesus ke role kia roma, “Ka kaomanna ka pangamologa a kaning. Minmina na goe rae ri muni sane ngeke tungtunge takis nginngina. ");
INSERT INTO mee_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ba nga takis e nga tempel, ka i a oru eke tungtunge ta bale ae Nutu ba ka iau ae Nutu Tuna. Ava ita ngaka tunge, nga baina ita sana ngaka bairaguso ka ragau nginngina ameke ballaga one ta takis e nga tempel. Minmina na ngo loa, na ngo toatape oalo ta me a sivoli. Na ngo rave lea e kapunu a one laue, na ngo bivipole kaona. Na one ko la kalingpa ka lollokanna te ngallo. Ngo rave lollokanna laeala, na ngo tunge te ri ta kolinge takis ae itaua.” ");
INSERT INTO mee_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ka kae nginngina na barangalele rae Iesus kanna keke loa te i, na keke ballage roma, “Tai ka i e kapunu nga Nutu kelangpatalingana nga tava?” ");
INSERT INTO mee_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nae Iesus ke kiue goe te e sina te i, na ke pamaisia ngaliua nge ri. ");
INSERT INTO mee_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Na i ke role kerea roma, “Iau nga role kamiau ka kaomannmannangana roma, ngaroma miau sana ngaka kamopiliu na ngaka lele ma goe reke sisina, na ka sana ka la loangalu ta Nutu kelangpatalingana nga tava. ");
INSERT INTO mee_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Minmina na, agau e ulopisigia i muni basema goe laekia e sina ka i e kapunu nga Nutu kelangpatalingana nga tava. ");
INSERT INTO mee_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Ba agau a lonangatakale goe te basema goe tulaekia nga giau ka lonangatakala iau. ");
INSERT INTO mee_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ava ngaroma agau te nge taoamuga ka goe te nga goe kokorai reke sisina ra loreapatokona te iau ta i kumangng ka bainga e soali nge Nutu raguna. Na agau laeala kana alang e soali ke la bolinglaunga raumana nga alang orae agau a ri ke konapita ka lollo taneke tatamugmuge uit kanna kia nga ganna. Na keke tamalilu kia lakallo ta pelau lona ta i mateng. ");
INSERT INTO mee_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Oru reke sosoali raumana keke la leleng nga re nga mogalo laekia e ngape onreke taoamuga ka ragau pattoto ta ri kumangng ka bainga reke sosoali! Iau ka role minmina kurumea, oru reke bai ka ragau ta ri pupunga nga bainga reke sosoali keke la atung, ava oru reke sosoali raumana keke la leleng nga agau a i a pamau nga oru nginngina. ");
INSERT INTO mee_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ngaroma kamang o kaeng nge utu one ta kumangng ka bainga e soali nge Nutu raguna, na ngo saꞌvatote ba ngo sau kia balakala. Ke pe ta one loangalu ta mauling e momo passavele ka kamang kena o ka kaeng kena. Ava ke soali raumana ngaroma nga kamangme ka ri lua o nga kaengme ka ri lua ava te nge utu one ta kumangng ka bainga e soali, na ngeke tamalilu ka mirang iname karolu lakallo ta malle a sia e pamiralali passavele. ");
INSERT INTO mee_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ba ngaroma matang kanna nge utu one ta kumangng ka bainga e soali nge Nutu raguna, na ngo kalalage ba ngo tamali kia balakala. Ke pe ta one loangalu ta mauling e momo passavele ka matang kanna kena. Ava ke soali raumana ngaroma nga matang kanname ka ri lua ava te nge utu one ta kumangng ka bainga e soali, na ngeke tamalilu ka mirang iname karolu lakallo ta malle a sia e pamiralali passavele. ");
INSERT INTO mee_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Miau ngaka ella miau masi ta baina miau sana ngaka kele goe te nga goe kokorai reke sisina ra loreapatokona te iau ma i a mosmosi mana. Ta iau ka la roleng kamiau roma, anggelo rae ri reke momo nga Tamau mallena nga tava keke kelkela ta Tamau raguna palimule.  ");
INSERT INTO mee_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Iau ka role minmina kurumea, Agau Tuna ke atu ta ravunglelenge ragau reke taopa. ");
INSERT INTO mee_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Miau ka lomiauvavai mina ngaetai? Ngaroma agau te nga kana ka sipsip ra marana ka ri 100 ava te e nge ri nge taopa, na i ke la maingamia? Kaka roma, i sane nge kaꞌe na nginngina ka ri 99 nga kapopongame, na nge loa ta i silinge sipsip laeala e taopa ae? ");
INSERT INTO mee_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ke sa, i ke la loanga ta kalingpa kia. Ba iau nga role kamiau ka kaomannmannangana roma, ngaroma i nge kalipa kia, na lonaserengngana ka sipsip kena laeala ke la bolinglaunga raumana nga lonaserengngana ka sipsip nginngina ka ri 99 re sane ke taopa. ");
INSERT INTO mee_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Minmina mana nae Tamamiau e momo nga mallena nga tava sana omona ta te e nga goe kokorai reke sisina ta i nge sanrea. ");
INSERT INTO mee_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ngaroma alopatokonakana tetoto nge baia bainga e soali te one, na ngo loa te i ine momo mana me i na ngo patupe baingana. Ngaroma i nga omona ta longa ta pangamologa a kaning, na alo ravugaliue kolingang tapu. ");
INSERT INTO mee_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ava ngaroma i sana nga omona ta longa ta pangamologa a kaning, na ngo rave pana kena o pana lua muni ta loanga kala nge one, ta baina miau ngaka kuma kurumea pangamologa nga Lau Ae Nutu Kanna ine role roma, ‘Pana lua o pana mologi ngeke momo ta turunge agau te bainganame ta baina ri ngeke paginggingia pangamologa onra kaomannmannangana ki.’ ");
INSERT INTO mee_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ava ngaroma alopatokonakana laeala sana nga omona ta longa ta pana lua o pana mologi nginngina pangamologa ra kanrea, na ngo ture ta ra lopatokonakana reke katualla kinung. Ba ngaroma i sana nga omona ta longa ta pangamologa ra kanrea bole, na nga kelangang kia ngo kele ma i a osugunakana te o araravukinung takiskana te. ");
INSERT INTO mee_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Iau nga role kamiau ka kaomannmannangana roma, taru ra miau sana ka ngatakala rea nga mogalo laekia e ngape, Nutu ke sane la ngatangngkala rea nga mallena nga tava. Ba taru ra miau ka ngatakala rea nga mogalo laekia e ngape, Nutu ke la ngatangngkala rea nga mallena nga tava bole. ");
INSERT INTO mee_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ba muni, iau nga role kamiau roma, ngaroma pana lua nge miau nakai nga mogalo laekia e ngape nga siareakena ta ri balinglage Tamau e momo nga mallena nga tava ka otte, na i ke la tungnge ollaeala te ri. ");
INSERT INTO mee_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Iau ka role minmina kurumea, ngaroma pana lua o pana mologi ngeke katukala kinung nga giau nga inte, na iau ka la momong ngaliua nge ri nga inaeala.” ");
INSERT INTO mee_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nae Pita ke loa te Iesus, na ke ballage roma, “Avolau, nga ina alopatokonakana tetoto nge baia bainga e soali te iau, na iau ka la osungrurunge baingana e soali pa pia? Ko roma, iau nga osurure pa lima ba lua?” ");
INSERT INTO mee_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nae Iesus ke ale roma, “Iau nga role kone roma, sano ngo osurure pa lima ba lua mana. Ke sa. Ngo osurure pa lima ba lua, ba nge lola, ba nge lola, ba sana la rongana. ");
INSERT INTO mee_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Minmina mana na iau ka la tonge Nutu kelangpatalingana nga tava ka kelangpatali te ore kiue ra kumangngatulu ra kanna ta ri atung te i, nga baina ri ngeke patupe rinao ra ri ke puli rea nge i pala. ");
INSERT INTO mee_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ba ka ine paturu ta pangatupunge rinao nginngina, na keke atu ka agau te ora kanna ka rinao tane bollau raumana, ore basema lollokanname ka ri 10 milion. ");
INSERT INTO mee_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ava agau laeala ka sana kanna lollokanna ta i alanggaliunge rinao laeala. Minmina na avolaukia ke role ka barangaleleme ta ri ngeke ba ka agau laeala kala nga napengana ba goe rae i, ba orume kinung nga kanna, ta baina ri ngeke rave lollokanna ta alanggaliunge rinao laeala. ");
INSERT INTO mee_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ka ina akumangngatulu laeala longe pangamologa laeala, na i ke toarau ka kalangapitangana ka raguna nga mogalo ngamuga nga avolaukia, na ke tanikale roma, ‘One ngo momokala iau ngana, na ka la alanggaliunge lollokanna ra kaning kinung te one.’ ");
INSERT INTO mee_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Minmina na akumangngatulu laeala avolaukia ka lonanane ba ke osurure rinao laeala a kanna, na ke baꞌe e lao. ");
INSERT INTO mee_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ava akumangngatulu laeala ke lelemalaga, na ke kalipa ka kumangngkena ae i te ore pulia rinao tune sina nge i, ore basema lollokanname ka ri tangulelu mana. Na i ke kamopite kumangngkena laeala ba ke roge, na ke role kia gingging roma, ‘Ngo alagaliue rinao amo pulia nge iau.’ ");
INSERT INTO mee_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Minmina na kumangngkena laeala ae i ke pupu lagape ta mogalo, na ke tanikale roma, ‘One ngo momokala iau ngana, na ka la alanggaliunge te one.’ ");
INSERT INTO mee_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ava akumangngatulu laeala ka sana omona. I ke loa, na ke rave ragau palu ta ri parongolu ka kumangngkena laeala ae i nga pulangkala ta nge lele nga ina i nge alagaliue rinao laeala te i. ");
INSERT INTO mee_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Na ka ina kumangngkena rae i ke kele ollaeala e lele, na ri ka loreatani raumana. Na keke loa, ba keke ture oru nginngina kinung reke lele ta avolaukerea. ");
INSERT INTO mee_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Na akumangngatulu laeala avolaukia ke kiue te i, na ke role kia roma, ‘Ka one a akumangngatulu e soali raumana. Iau ka osurure rinao ra kaning kinung ino tanikala iau ta osungruru rea. ");
INSERT INTO mee_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ke meimia na ka sana longnane kumangngkena ae one base ina iau launana one?’ ");
INSERT INTO mee_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Na avolaukia ka iukia kia, na ke ule nga ra kurtalingling kamareame ta ri pangamiralalia ta nge lele nga ina i nge alagaliue rinaome kinung te i. ");
INSERT INTO mee_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Nae Tamau e momo nga mallena nga tava ke la kumangng minmina mana nge miau, ngaroma kenakena nge miau sane nge osurure ra lopatokonakana pattoto baingarea reke soali ngallo nga lomiaume.” ");
INSERT INTO mee_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ka inae Iesus rongo ka pangamologa nginngina, na i ke kaꞌe ine ngae Galili ba ke loa ta Me Ae Ioran bavana tetoto nga ine ngae Iurea. ");
INSERT INTO mee_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ba malua reke bollalau keke loakurumea, na i ke pape rea nga inaeala. ");
INSERT INTO mee_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nae Parisio palu keke loa te i ta baina ri avange. Minmina na keke ballage roma, “Bangapagame keke ngatakale agau te ta i pelenge napengana kurumea lonangana, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nae Iesus ke ala rea roma, “Ke meimia, miau ka sana ka kele pangamologa ameke paꞌe nga Lau Ae Nutu Kanna ae? Ke role roma, kapunu mannangana, na ‘i ke kuma ka agau apanung ba navale.’ ");
INSERT INTO mee_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ba ke role roma, ‘Kurumea ollaeala mana, na apanung nge kaꞌe tamana bae naname, na i nge pagiu kala nge napengana, na ri pana lua ka la ri ra mira kena mana’. ");
INSERT INTO mee_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Minmina na ri pana lua ka sana ri pana lua muni. Ke sa. Ka ri ra mira kena mana. Minmina na agau te sane nge saꞌvatote oru ae Nutu pagaotue.” ");
INSERT INTO mee_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nae Parisio nginngina keke ballage roma, “Ngaroma minmina, na ke meimia nae Moses ke rolea bangapaga laeala pala ore role roma, ‘Agau e bai ta pelenge napengana nge tunge lau e ture palingravung rea rongana te napengana, na nge baꞌe na nge lao?’” ");
INSERT INTO mee_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nae Iesus ke ala rea roma, “Ka miau ra longasakana raumana, minmina nae Moses ke ngata ta miau pelenge namiaupengana memena. Ava kapunu mannangana, na bainga laeala ke sane momo. ");
INSERT INTO mee_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ba iau nga role kamiau roma, agau ora napengana sane keno kala nga apanung tetoto ava i ke pelea na ke kamapitakama ka avale tetoto, agau laeala e pelea napengana ke baia bainga e nga kenong kala nga avale a sana i a napengana.” ");
INSERT INTO mee_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ka ina barangalele rae Iesus kanna ke longe pangamologa laeala, na ri keke loa te i na keke role kia roma, “Ngaroma nge isopa minmina ta apanung pelenge napengana, na ke pe ta ragau momong ma ri ra taulai mana.” ");
INSERT INTO mee_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nae Iesus ke ala rea roma, “Ava ke isopa ta ragau palu ta ri loangakurumea pangamologa laekolong. Ragau rae Nutu tunge gingginga laeala te ri mana. ");
INSERT INTO mee_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Iau ka role minmina kurumea, ka ragau matantana re sane ke kamapitakama. Palu ka ri ra ragau matana laeala onra lovaingana e ta ravale ke sane momo nge ri ina nareamemena ke toapisigi rea. Ba palu nge ri ka ri ra ragau onreke toto rea ta baina sana nga karea goe. Ba palu muni keke parototokala rea muni ta ri nga manereasa kamangpitakama ta baina ri ngeke kumkuma ka kumangng e nga Nutu kelangpatalingana nga tava. Ngaroma agau te nge totorong ta i loangakurumea pangamologa laeala, na i nge loakurumea.” ");
INSERT INTO mee_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Na ragau palu keke atu ka goe reke sisina te Iesus ta baina i nge ulopaia kamana nge ri ba nge kava te Nutu te ri. Ava barangalele ra kanna keke sanggipita rea. ");
INSERT INTO mee_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Avae Iesus ke role ka barangalele ra kanna roma, “Ka ule ragoeme ngeke atu te iau, ba manemiausa bongakala rea ta Nutu kelangpatalingana nga tava ka orae ragau reke ulopisigi rea muni ma goe kokorai.” ");
INSERT INTO mee_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ba ka ine ulopaia kamana nge ri tapu, na i ke kutapu ba ke kaꞌe inaeala. ");
INSERT INTO mee_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ka kae te na agau te ke loa te Iesus, na ke ballage roma, “Apangalomatanakana, iau nga kuma ka bainga e pe a taru ta ravunge mauling e momo passavele?” ");
INSERT INTO mee_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nae Iesus ke ale roma, “Ko meimia o ballaga iau ta bainga a taru ke pe? Ka sana agau te pe, avae Nutu kasikena mana. Ava ngaroma ngo bai ta lunga lakallo ta mauling, na ngo taokurumea bangapaga rae Nutu kanna.” ");
INSERT INTO mee_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Na agau laeala a taulai ke ballage roma, “Ava iau nga taokurumea bangapaga ra taru?” Nae Iesus ke role kia roma, “One ko sano ngo sapune agau te, ba ko sano ngo keno kala nga avale a sana i a ningpengana, ba ko sano ngo golo, ba ko sano ngo turu goang, ");
INSERT INTO mee_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ba one ngo alapagpage tamang bae name, ba ngo materaumane agau tetoto basema ino materaumana one muni.” ");
INSERT INTO mee_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Na taulai laeala ke role kae Iesus roma, “Iau ka tataokurumea bangapaga kokorong kinung tapu. Ava iau ka moro ta taru tale?” ");
INSERT INTO mee_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nae Iesus ke role kia roma, “Ngaroma ngo bai ta leleng tupu mannangana, na ngo loa ba ngo ba ka oru ra kaning, nga baina one ngo rave lollokanna ki. Na ngo tavoa ka lollokanna nginngina ta ra sillolo. Na one ka la kanga ka oru reke pepe re nga Nutu mallena nga tava. Na ngo atukurume iau.” ");
INSERT INTO mee_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ava ka ina taulai laeala longe pangamologa laeala, na i ke lao ka lonataningana kurumea, ka i a agau ora kana ka oru papatu raumana. ");
INSERT INTO mee_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nae Iesus ke role ka barangalele ra kanna roma, “Iau nga role kamiau ka kaomannmannangana roma, agau a kilipukana ka baingana lilli raumana ta lunga lakallo ta Nutu kelangpatalingana nga tava. ");
INSERT INTO mee_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ba nga role kamiau muni roma, posi a kamele te lungana nga bulongpita ore nga sainga masina ke ate raumana nga agau a kilipukana te lungana nga Nutu kelangpatalingana.” ");
INSERT INTO mee_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ka ina barangalele ra kanna ke longe pangamologa laeala, na ri keke magio raumana ba keke ballage roma, “Ngaroma minmina, nae Nutu ke la ravunglelenge tai mannangana?” ");
INSERT INTO mee_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nae Iesus ke kela te ri na ke role kerea roma, “Ragau ka sana likirea ta kumangng ka oraeala bavakena, avae Nutu ka kana ka gingginga ta kumangng ka orume kinung.” ");
INSERT INTO mee_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nae Pita ke role kia roma, “Mangng ka kaꞌe orume kinung ta loangakurume one, minmina na ka la mangng ravunge taru?” ");
INSERT INTO mee_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nae Iesus ke role kerea roma, “Iau nga role kamiau ka kaomannmannangana roma, ngarume, nga ina orume kinung nge lele pau inae Agau Tuna la tarang nga tarang ae i e nga kelangpatali ore ngailu raumana, na miau raka loakurumea iau kaka la tarang nga tarangame ka ri tangulelu ba lua re nga kelangpatali bole. Na kaka la kelangpatali ta galiau re ngae Israel ra ri tangulelu ba lua. ");
INSERT INTO mee_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ba ragau kinung reke kaꞌe bale rae ri, o tataokerea memena, o teiteikerea memena, o liurea piau memena, o tamarea memena, o nareamemena, o goe rae ri, o ura rae ri ta ri loanga kurume iau keke la ravunge karea oru papatu ngailu muni nga oru nginngina. Ba ri keke la ravunge mauling e momo passavele bole. ");
INSERT INTO mee_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ava ragau papatu ra ri re kapunu sonrau, ka la ngarume na ri re ngarume. Ba ragau papatu re ngarume sonrau, ka la ngarume na ri re kapunu. ");
INSERT INTO mee_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Iau ka role minmina kurumea, Nutu kelangpatalingana nga tava ka tongana kena ma agau te a kana ka mogalo ina papatu ore loa lagapotu ka sinro luluna ta kolinge barangaleleme ta ri kumangng nga ura ae i. ");
INSERT INTO mee_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ka ine kalipa ka ragau palu, na i ke ngata ta kolinge kenakena kumangngana ka kae laeala ka lollokanna kena a masina. Na ke ba rea ta ura ta ri kumangng. ");
INSERT INTO mee_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ngarume isura, ka kae matana basema lima ba tugulu ka sinro, na i ke loa lagapotu muni ta malle nga koling kaning, na ke kele ragau pattoto reke meisinsi mana nga inaeala. Ba ri ke sane ke kumkuma ka otte. ");
INSERT INTO mee_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Na ke role ka ragau nginngina roma, ‘Miau ngaka loa na ngaka kuma nga ura ae iau bole, na iau ka la koling miau kurumea kumangng ngamiaungana.’ ");
INSERT INTO mee_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Minmina na ri keke loa ta kumangng nga ura ae i bole. “Ba ka pula ba ka kae matana basema mologi ka laio, na i ke loa muni na ke kalipa ka ragau pattoto ta ri kumangng nga ura ae i bole. ");
INSERT INTO mee_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ba ka kae matana basema lima ka laio, na i ke loa muni, na ke kalipa ka ragau pattoto muni reke meisinsi mana, ba ke ballaga rea roma, ‘Kaka maimia aka meisinsi mana nakai ka kae laekia bavakena?’ ");
INSERT INTO mee_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Na ri keke ale roma, ‘Ka sana agau te koli mangng ta kumangng, minmina na mangng ka maisinsi mana nakai.’ “Na i ke role kerea roma, ‘Miau ngaka loa, na ngaka kuma nga ura ae iau bole.’ ");
INSERT INTO mee_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Na ka laio ina kae rongo tapu, na ura tamana laeala ke role ka barangalele a kanna e kapunu roma, ‘Ngo kiue barangalele reke umma nga ura, na ngo koli rea. Ngo paturu nga ne ngeke lele ngarume bavakena, na ngo kolia kenakena nge ri. Ba ngarume na ngo kuma minmina ta ngo lele nga ne ngeke pature kumangng kapunu mannangana.’ ");
INSERT INTO mee_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Minmina na reke pature kumangng ngarume bavakena keke atu, na kenakena nge ri ke rave lollokanna kena a masina. ");
INSERT INTO mee_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ba ka ina ragau ra ura tamana koli rea kapunu mannangana keke atu, na ri ka loreangana roma, ri keke la ravunge lollokanna palu muni. Ava ke sa. Kenakena nge ri ke rave lollokanna kena a masina bole. ");
INSERT INTO mee_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ba ka ineke rave lollokanna laeala, na keke loa ka kaoreame ka ura tamana ");
INSERT INTO mee_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","roma, ‘Ragau ngakong reke lele ngarume bavakena keke kuma ka kae matana kena mana. Ba one ko koli rea basema ri keke tolea kumangng e bollau ba kae mammangana base mangnga mana.’ ");
INSERT INTO mee_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ava ura tamana laeala ke alakale te e nge ri roma, ‘Koli, iau ka sana kuma ka otte e soali nge one. Pala na itaua amaka ngata kinung ta lollokanna kena a masina, o ke sa? ");
INSERT INTO mee_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ngo rave kurung na ngo loa. Ava iau ka bai ta tungnge kuru ora tongana kena mana ma kurung ta agau laekia e pature kumangng ngarume bavakena. ");
INSERT INTO mee_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ke meimia, ke parototokala ta iau kumangng kurumea laungana mana ka lollokanna a kanau ae? O baingau ina iau a atungakana ke bai one ta busing ae?’” ");
INSERT INTO mee_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nae Iesus ke rongo ka pangateningkala laeala roma, “Minmina mana na ragau re ngarume sonrau, ka la ngarume na ri re kapunu. Ba ragau re kapunu sonrau, ka la ngarume na ri re ngarume.” ");
INSERT INTO mee_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ka inae Iesus lolapatae tae Ierusalem, na i ke ngaluvalakale Pana Tangulelu Ba Lua, na ke role kerea roma, ");
INSERT INTO mee_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ita kaka la loangapatae tae Ierusalem, na agau te ke la pulinge Agau Tuna ta re kapunu nga pirisme ba ra pangalomatanakana nga bangapagame kamareame. Na ri keke la kalingnanange, ba keke la roleng ta i nge mate. ");
INSERT INTO mee_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Na keke la pulinge ta ragau ra sana ri ra Iura kamareame ta ri rolengpagalising kia, ba sapinge, ba katungpitange nga maiskovu. Na i ke la mateng. Ava nga kae a mologi ngarume nga matengana, nae Nutu ke la pangasigingpage nga mateng.” ");
INSERT INTO mee_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nae Sepeti napengana kala nge tuna memena ra barangalele lua rae Iesus kanna keke loa te Iesus. Na avale laeala ke parovanu, ba ke bai ta balinglagange Iesus ta otte. ");
INSERT INTO mee_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nae Iesus ke ballage roma, “Ko matea taru?” Na avale laeala ke role kia roma, “Iau ka matea ta one ngo role, na goe lua rae iau ngeke tara kokoro nge one nga kelangpatalingang ngarume. Te nge tara nga bavang e pe ba te nge tara nga bavang a laeva.” ");
INSERT INTO mee_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Avae Iesus ke role kerea roma, “Miau ka sana lomiaumatana ka taru a miau ka balaglaga iau te. Kaka totorong ta inung nga gato a iau la inung ngia ae?” Na ri pana lua keke ale roma, “Mangng ka totorong.” ");
INSERT INTO mee_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nae Iesus ke role kerea roma, “Onemea kaka la inung nga gato ae iau. Ava ka sana kumangng a kanau ta roleng ta miau tarang nga bavau e pe ba nga bavau a laeva. Tamau ke kalitupe malle nginngina ta ragau ra i mate rea ta ri momong ngi.” ");
INSERT INTO mee_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ka ina barangalele rae Iesus kanna ka ri tangulelu ke longe balinglaga a pana lua nginngina ra koli kanrea, na balinglaga laeala a kanrea ke sane tani masi nge ri. ");
INSERT INTO mee_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Avae Iesus ke kiu rea te i, na ke role kerea roma, “Miau ka lomiaumatana roma, re kapunu nga ra sana ri ra Iura keke umma ta bongatalala rea kalaoka ka kaoreaginapitangana kerea, ba ravollalaukerea memena keke umma ta barangalele rea ka ginggingngarea. ");
INSERT INTO mee_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ava miau sana ngaka bai minmina. Ke sa. Agau e bai ta leleng i a avolau ngaliua nge miau nga i a akumangngatulu ae miau. ");
INSERT INTO mee_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ba agau e bai ta i e kapunu ngaliua nge miau nge momo ma i a agau te a miau ka baralellea ta i kumangng ka kumangng a kanmiau mana. ");
INSERT INTO mee_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ollaeala ka tongana kena mana ma inae Agau Tuna sane atu ta agau te kumangng ka kumangnga te te i. Ke sa. I ke atu ta kalaunge ragau, ba ta i tungnge maulingngana ta kolinglelenge ragau papatu nga pulangkala e nga kumangng ka bainga reke sosoali nge Nutu raguna.” ");
INSERT INTO mee_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ka inae Iesus kala nga barangalele ra kanna ke lelemalaglaga ngae Ieriko, na malua e bollau keke lolakurumea. ");
INSERT INTO mee_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ba rapanung lua ra matarea kanname ke su keke tattara nga pamau laeala bavana. Ba ka ineke longo roma, Iesus ke umma ta kavesinglele rea, na keke reli kaligi roma, “Avolau, One ae Revit Sivuna, nga longnana mangng!” ");
INSERT INTO mee_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Na maluame keke sanggipita rea ka pangarulung ngareangana kerea. Ava ri keke reli kaligi ka reling e bollau muni roma, “Avolau, One ae Revit Sivuna, nga longnana mangng!” ");
INSERT INTO mee_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nae Iesus ke maisi ba ke kiu te ri roma, “Onemea kaka matea ta iau maingamia kamiau?” ");
INSERT INTO mee_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Na ri pana lua keke role kia roma, “Mangng ka matea ta matamangng kanname ngeke kela.” ");
INSERT INTO mee_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nae Iesus ka lonananna rea, na ke kali ka matarea kanname. Ba ka pannasa mana, na matarea kanname ke pe. Na ri keke loakurumea Iesus. ");
INSERT INTO mee_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Na ka inae Iesus kala nga barangalele ra kanna ke lele kokoro tae Ierusalem, ba keke lele ngae Betage a i a maga kunna e momo ngae Kapoponga Nga Bega Ra Oliv, nae Iesus ke baꞌe barangalele lua ra kanna ");
INSERT INTO mee_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ka potongana kerea roma, “Onemea ngaka loa ta maga kunna laeala e ngamuga nge onemea. Ba nga ina miau nga lu ngia, na ka panna laeala mana na kaka la kalingpa ka ronki eke samapite nga inaeala kala nga goekia. Ngaka luva rea, na ngaka atu ki nasai te iau. ");
INSERT INTO mee_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ba ngaroma agau te nge role kamiau ka pangamologa te, na ngaka role kia roma, ‘Avolau ka kanna ka kumangng ki,’ ba i ke la bangagaliu rea bolvole.” ");
INSERT INTO mee_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Na ollaeala ke lele ta baina pangamologa a agau e toe Nutu kaona rolea pala nge lele mannangana ine role roma, ");
INSERT INTO mee_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ngaka role kae Saion tuna piau roma, ‘Ngo kele, kelangpatali ae one ikolong e tatu te one, ke tatu ka tarangapaingana nga ronki te ma i a agau a sana giana. Ke tattarapai nga ronki te a lumangngapau. Ke tattarapaia nga ronki goekia.’” ");
INSERT INTO mee_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Minmina na barangalele lua nginngina rae Iesus kanna keke loa, na keke kuma kurumea Iesus potongana kerea. ");
INSERT INTO mee_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Na keke atu ka ronki laeala kala nga goekia te Iesus. Na keke unapaia lungapaga ngae ri re ngapotu nga ronki gireame. Nae Iesus ke tarapai ngi. ");
INSERT INTO mee_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Na ragau papatu keke unasilagi ka lungapaga ngae ri re ngapotu nga pamau, ba pattoto keke savaꞌe bega kamaname, na keke una rea kurumea pamau. ");
INSERT INTO mee_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ba malua reke tatao ngamuga nge i, ba ne nge ngarume keke kikiu kaligi roma, “Osana te Revit Sivuna!” “Nutu ke kavitulu raumane aekia e atu nge Nutu Avolau giana!” “Osana te Nutu e momo ngailu raumana!” ");
INSERT INTO mee_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nae Iesus lungana lakallo tae Ierusalem ke bai ka maimai e bollau ngaliua nga ragau kinung reke momo nga maga kunna laeala e bollau. Ba ri keke balaglaga roma, “Agau laekolong ka i a tai mannangana?” ");
INSERT INTO mee_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Na maluame keke role roma, “Aekia ka i ae Iesus a i a agau laeala e toe Nutu kaona e ngae Nasaret ngallo ngae Galili.” ");
INSERT INTO mee_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nae Iesus ke loalu ta tempel, na ke taomalage ragau kinung reke kolkoli beke bava ka orume ngallo nga inaeala. Ba ke bapalipisigi ka pala onrae ragau reke tungugaliliue lollokanna. Ba ke bapalipisigi ka tarang onrae ragau reke bava ka manu ra kulao. ");
INSERT INTO mee_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ba i ke role kerea roma, “Keke paꞌe Nutu pangamologangana pala ore role roma, ‘Keke la patonge bale ae iau ka bale ore nga kavang,’ ava miau kaka bavai kia ma i a ‘malle a ragolongkana ta ri katungkala.’” ");
INSERT INTO mee_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na ragau ra matarea kanname ke su, ba ragau ra kaereame ke mate keke atu te i ngallo nga tempel, na i ke pape rea. ");
INSERT INTO mee_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ava ka ina re kapunu nga pirisme ba ra pangalomatanakana nga bangapagame ke kele oru reke pepe raumana ra i kuma ki, ba ka ineke longe ragoeme ineke kikiu nga ina re nga tempel roma, “Osana te Revit Sivuna,” na oru nginngina ke sane ke tara masi ngallo nge ri. ");
INSERT INTO mee_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Na keke ballage Iesus roma, “Ko meimia, ko sano longe goe kokorai pangamologa ra kanrea ae?” Nae Iesus ke ala rea roma, “Iii, iau ka longe. Ke meimia, miau ka sana ka kele pangamologa laeala eke paꞌe pala nga Lau Ae Nutu Kanna ae? Ke role roma, “‘One ko bai ka pangamologa onreke kalapagpaga one ta ri lelengmalaga nga goe reke sisina ba nga goe ra nareame mena ke pasisiu rea kaoreame’.” ");
INSERT INTO mee_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nae Iesus ke ka rea, na ke lelemalaga ngae Ierusalem ba ke loa tae Betani. Na i ke momo nga maga laeala ka rigo laeala. ");
INSERT INTO mee_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ka sinro luluna, nae Iesus ke galiliu tae Ierusalem muni, ba i ka mate kana. ");
INSERT INTO mee_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Na i ke kele bega te a pik ore maisi mana me i nga pamau bavana. Na i ke loa ta bega laeala, ava ke sane kalipa ka kanna te. Ke sa. Ka lalauname mana. Na i ke role ka bega laeala roma, “Ke sane ke la kaning nge one ka kae te muni!” Ba ka pannasa mana, na bega laeala ke manani. ");
INSERT INTO mee_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ba ka ina barangalele rae Iesus kanna ke kele ollaeala e lele nga bega laeala, na ri keke kallo raumana ba keke ballage roma, “Bega laeala a pik ke manani bolvole mina ngaetai?” ");
INSERT INTO mee_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nae Iesus ke ala rea roma, “Iau nga role kamiau ka kaomannmannangana roma, ngaroma miau nga lomiaupatokona, ba sana nga lomiau lualua, na miau ka sana ka la kumangng ka kumangng laekia a iau kuma kia nga bega a pik mana. Ke sa. Miau kaka la totorong ta roleng ka kapangng laeo roma, ‘Ngo sigipaga na ngo tugutao lakallo ta pelau,’ na ollaeala ke la leleng mana. ");
INSERT INTO mee_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ba ngaroma nga lomiaupatokona ina miau ka kavkava, na kaka la ravunge taru ra miau ka ballaga tao.” ");
INSERT INTO mee_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ba ka inae Iesus lu lakallo ta tempel, na re kapunu nga pirisme bae Iurame ravollalaukerea memena palu keke loa te i ine palomatantane ragau, na keke ballage roma, “One ko rave gingginga ta one kumangng ka oru kokorai mina ngaetai? Ba tai ke tunge gingginga laekolong te one?” ");
INSERT INTO mee_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nae Iesus ke ala rea roma, “Iau nga ballaga miau ka balinglaga te bole. Ba ngaroma miau ngaka alamasia balinglaga a kanau, na iau bole ka la turung te miau ka tai ke tunge gingginga ta iau kumangng ka oru kokorai. ");
INSERT INTO mee_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ion kumangngana e nga pangamagoe ka puna mina ngaetai? Ka puna nge Nutu e momo nga mallena nga tava, o ka puna nga ragau?” Na ri keke paturu ta palingpangamologa ngaliua nge ri muni roma, “Ngaroma ita ngaka role roma, ‘Ka puna nge Nutu e momo nga mallena nga tava,’ na i nge ballaga ita roma, ‘Minmina na, ke meimia na ka sana lomiaupatokona te i?’ ");
INSERT INTO mee_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ava ngaroma ita ngaka role roma, ‘Ka puna nga ragau,’ na ita ngaka mataue ragau kurumea, ri ka loreapatokona roma, Ion ka i a agau te e toe Nutu kaona.” ");
INSERT INTO mee_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Minmina na ri keke ale Iesus roma, “Mangng ka sana lomangngmatana.” Nae Iesus ke role kerea roma, “Iau bole, ka sana la turung te miau ka tai ke tunge gingginga ta iau kumangng ka oru kokorai. ");
INSERT INTO mee_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ava miau ka lomiauvavai mina ngaetai? Ka agau te ora kana ka goe lua ra panung ke momo. Ka kae te na i ke loa ta ne kapunu na ke role kia roma, ‘Tugu, ngo loa na ngo kuma nga ura sonrau.’ ");
INSERT INTO mee_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Na i ke ale tamana roma, ‘Iau sana nga loa,’ ava ngarume na i ke kampiliue ramana na ke loa. ");
INSERT INTO mee_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ngarume na ri pana lua tamarea ke loa ta na lua, na ke role kia roma, ‘Tugu, ngo loa na ngo kuma nga ura sonrau.’ Na goe laeala ae i a lua ke ale roma, ‘Avolau, ka la iau loanga,’ ava ke sane loa. ");
INSERT INTO mee_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Na iau nga ballaga miau roma, tai nga goe lua nginngina ke longo te tamana?” Na reke longlonge pangateningkala laeala a Iesus kanna keke ale roma, “Ne kapunu.” Nae Iesus ke role kerea roma, “Iau nga role kamiau ka kaomannmannangana roma, ragau reke raravukinunge takisme ba ravale ra pamau luana keke la lunga lakallo ta Nutu kelangpatalingana pala nge miau. ");
INSERT INTO mee_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Iau ka role minmina kurumea, Ion ke atu te miau ta pangapanau miau ka pamau ore ta leleng tupu nge Nutu raguna, ava ka sana lomiaupatokona te i. Ava reke raravukinunge takisme ba ravale ra pamau luana ka loreapatokona te i. Ba bole miau kaka kele ineke kuma minmina, ava ngarume na ka sana ka bali ka gimiau ta baingamiau reke sosoali ba ka sana lomiaupatokona te i. ");
INSERT INTO mee_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Miau ngaka longe pangateningkala te muni. Ka agau te a kana ka mogalo ina papatu ke momo. Ba i ke kuma ka ura te eke toaꞌe gerepeme ngia. Na ke kavitotokale ura laeala ka savanau a i a lollo. Ba ngallo nga ura laeala i ke kilia lulu te ore nga paꞌtangapelange gerepeme ba kumangng ka uain ngia. Ngarume na i ke kuma ka bale e loa lakailu ore nga agau e ellapatali ta ura laeala. Ka ine kuma ka oru nginngina tapu, na i ke paꞌtaloe ragau palu ta ri kelangpatali ta ura laeala. Na ke loa ta maga te e ngatauga. ");
INSERT INTO mee_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ngarume, ka ina kae e nga lalang ke kokoro, na i ke baꞌe ra kumangngatulu ra kanna ta ragau nginngina ra i paꞌtalo rea, ta baina ri ngeke tunge kana kaning palu. ");
INSERT INTO mee_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ava ra nginngina ra i paꞌtalo rea keke rave ra kumangngatulu ra kanna, na keke balia te, ba keke sapune tetoto, ba keke tamalipune na mologi ka lollome. ");
INSERT INTO mee_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Na ura laeala tamana ke baꞌe ra kumangngatulu ra kanna palu muni. Ka ri papatu muni nga ra kumangngatulu nginngina ra i ba rea pala. Ava ra nginngina ra i paꞌtalo rea keke balia ra kumangngatulu nginngina bole. ");
INSERT INTO mee_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ngarume muni, na ura tamana laeala ke baꞌe tuna te ri ka rolengana roma, ‘Ri keke la longa te tugu.’ ");
INSERT INTO mee_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ava ka ina ragau nginngina ra i paꞌtalo rea ke kele tuna, na ri keke palirole kerea roma, ‘Aekia ka i a ura tamana tuna. Ita ngaka sapune nga baina nga kara ka ura laekia.’ ");
INSERT INTO mee_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Minmina na keke gulaemalaga kia nga ura, na keke sapune.” ");
INSERT INTO mee_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nae Iesus ke ballage reke longlonge pangateningkala laeala roma, “Minmina na, ka ina ura tamana nge atu, na i ke la maingamia ka ragau nginngina ra i paꞌtalo rea?” ");
INSERT INTO mee_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Na reke longlonge keke ale roma, “I ke la baingasoalinge ragau nginngina reke sosoali raumana, na nge paꞌtaloe ragau pattoto ka ura laeala. Ke la pangatalonge ragau onreke la tungnge kana kaning nga kae e nga lalang.” ");
INSERT INTO mee_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nae Iesus ke role kerea roma, “Ke meimia, miau ka sana ka kele pangamologa laeala eke paꞌe pala nga Lau Ae Nutu Kanna ae? Ke role roma, “‘Lollo ama ra popongpita ke tangulelea ke lele i a lollo kena a kana ka gingginga ma maisi e maisgingging ka bale; Nutu a i a Avolau ke kuma ka ollaeala, na mangng ka kele, na ke pe raumana.’ ");
INSERT INTO mee_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Minmina na iau nga role kamiau roma, Nutu ke la ravungpatali ka kelangpatalingana nge miau, na ke la tungnge ta ragau barana te onre la kumangng kurumea lonangana. ");
INSERT INTO mee_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ngaroma agau te nge pupai nga lollo laeala, na i ke la gitungpalikolo kia. Ava ngaroma lollo laeala nge pupai nga agau te, na lollo laeala ke la popongpalgamung ka agau laeala.” ");
INSERT INTO mee_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na ka ina re kapunu nga pirisme ba Parisiome ke longe pangateningkala nginngina rae Iesus kanna, na ri keke kelapatokona roma, i ke rorolea pangamologa re te ri mana. ");
INSERT INTO mee_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Minmina na ri keke sissilia pamau ta ri launge, ava keke mataue maluame kurumea, ri ka loreapatokona roma, Iesus ka i a agau te e toe Nutu kaona. ");
INSERT INTO mee_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nae Iesus ke role kerea muni ka pangateningkalame roma: ");
INSERT INTO mee_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Nutu kelangpatalingana nga tava ka tongana kena ma kelangpatali te ore bai ta bainge kaning e bollau ta pangaserengkalange tuna ine la kamangpitakama. ");
INSERT INTO mee_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ba pala ta kaning laeala e bollau nga palingravung rea, na i ke baꞌe ra kumangngatulu ra kanna ta ri kiunge ragau ra i mate rea ta ri atung ka kae laeala. Ava ra nginngina ka sana omorea ta ri atung. ");
INSERT INTO mee_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ngarume na i ke baꞌe ra kumangngatulu pattoto ka rolengana kerea roma, ‘Miau ngaka loa, na ngaka role ka ra ngama ra iau ba te ri ta ri atung roma, “Ngaka longo, iau ka kalitupe kaning ae iau tapu. Iau ka balia bulmakaume ba posi reke panro kinung, ba ka kalitupe orume kinung tapu. Ngaka atu ta kaning e bollau e nga palingravung rea.” ’ ");
INSERT INTO mee_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ava ra nginngina ra i ba te ri pala ke sane ke longo ta ra kumangngatulu ra kanna. Ke sa. Keke loa ta iname kalaoka kurumea loreangana mana. Te ke loa ta kumangng nga ura ae i, ba tetoto ke loa ta kumangng a kanna e nga ravung lollokanna. ");
INSERT INTO mee_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ba pattoto nge ri keke rave ra kumangngatulu ra kelangapatali laeala kanna, na keke pamiralali rea ba keke sapunu rea. ");
INSERT INTO mee_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Na kelangpatali laeala ka iukia raumana. Minmina na i ke baꞌe galiau rae i re nga baling, na keke loa eke balipune ra nginngina reke sapune ra kumangngatulu ra kanna. Ba keke tune maga kunna ae ri e bollau. ");
INSERT INTO mee_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Na i ke role ka ra kumangngatulu ra kanna roma, ‘Iau ka kalitupe kaning e bollau nga palingravung rea tapu, ava ragau ra iau ba te ri ta ri atung ka sana ri ra ragau reke pepe ta ri atung ta kaning laekia. ");
INSERT INTO mee_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Minmina na ngaka loa ta pamau reke bollalau, na ngaka role ta ragau kinung ra miau ka kalipa kerea nga ina nginngina ta ri atung ta kaning e bollau nga palingravung rea.’ ");
INSERT INTO mee_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ka baina ra kumangngatulu nginngina keke loa lagatauga ta pamaume, na keke ravukinunge ragau kinung ra ri ke kalipa kerea. Keke rave ragau reke pepe, ba ragau reke sosoali kinung. Na bale laeala eke katukala ngia ta pangaserengkalange palingravung rea ke ponu ka ragau. ");
INSERT INTO mee_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ava ka ina kelangpatali laeala lu lakallo ta kelange ragau reke tattara nga kaning laeala, na i ke kelapa ka apanung te ore sane lupage nena ka lungapaga matana eke lupagpaga rea ka kae e nga palingravung rea. ");
INSERT INTO mee_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Minmina na i ke ballage apanung laeala roma, ‘Koli, ko sano lupage ning ka lungapaga matana eke lupagpaga rea ka kae e nga palingravung rea, ava ko lu lakallo ta malle laekia mina ngaetai?’ Ava apanung laeala ka sana kanna pangamologa. ");
INSERT INTO mee_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Na kelangpatali laeala ke role ka ra kumangngatulu ra kanna roma, ‘Ngaka samapite apanung laekia kaename ba kamaname, na ngaka tamalimalaga kia lakallo ta osuguna e ngapotu, nga malle laeala a ragau ke la taning ba ke la tanaginge ngingireame ngia.’” ");
INSERT INTO mee_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nae Iesus ke rongo ka pangateningkala laeala roma, “Iau ka role minmina kurumea, ragau rae Nutu ba te ri ta ri atung ka ri papatu, ava i ke tore tutuna mana.” ");
INSERT INTO mee_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nae Parisiome keke loa, na keke potopita ta ri launge Iesus ka pangamologanganame. ");
INSERT INTO mee_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Minmina na ri keke baꞌe barangalele palu ra kanrea kala nga ragau palu onreke pato rea ka Erotome ta ri avange Iesus ka balinglagame. Na keke ballage Iesus roma, “Apangalomatanakana, mangng ka lomangngmatana roma, pangamologa ra kaning ka kaomannmannangana ki, ba one ko palomatantane ragau kurumea Nutu lonangana mannangana. Ba ka lomangngmatana roma, one ko sano matautaue agau te ta ko sano pulia te ngailu nga tetoto. ");
INSERT INTO mee_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Minmina na ngo turupaga mangng, one ka longvavai mina ngaetai? Bangapagame keke parototokala ita ta tungnge takisme te Sisa, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Avae Iesus ka lonamatana ka ineke bai ta baingasoalinge, minmina na i ke role kerea roma, “Miau ra goangakana, kaka maimia aka amva ta patugungtao iau? ");
INSERT INTO mee_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ngaka pakosi iau ka lollokanna te aka takiskis kia. Na ri keke kosi ka lollokanna te te i.” ");
INSERT INTO mee_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Na i ke ballaga rea roma, “Tai ka kannuna ba giana ikia?” ");
INSERT INTO mee_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Na keke ale roma, “Orae Sisa.” Na i ke role kerea roma, “Minmina mana na miau ngaka ale oru rae Sisa kanna te Sisa, ba ngaka ale oru rae Nutu kanna te Nutu.” ");
INSERT INTO mee_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ka ina ri ke longe pangamologa laeala, na keke kallo raumana. Minmina na ri keke kaꞌe, na keke lao. ");
INSERT INTO mee_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ka kae laeala mana, nae Sarusi palu keke atu te Iesus ta ri balinglagange ka balinglaga te. Ka ri ra ragau ra sana loreapatokona roma, reke mate keke la sigingpaga nga mateng muni. Minmina na ri keke role kae Iesus roma, ");
INSERT INTO mee_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Apangalomatanakana, pala nae Moses ke role roma, ‘Ngaroma apanung te nge matepatalia napengana ba ka sana nerea goe, na apanung laeala tataokia o teiteikia nge ravupaga ka avale laeala ta baina apanung laeala e mate nga nena goe nge i.’ ");
INSERT INTO mee_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na ngo kele. Ka pana lima ba lua onra panung ra ri ra koli keke momo kala nge mangng. Ba ri ka tamarea kena. Na ne kapunu ke kamapitakama ka avale te, ava ke mate. Ba ri pana lua ka sana nerea goe. Minmina na apanung laeala e mate ke kaꞌe napengana nge kolingana. ");
INSERT INTO mee_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Na na lua ke ravupaga ka avale laeala, ava ke mate. Na ngarume na na mologi ke rave, ava i ke mate bole. Minmina na mateng ke rongo ka pana lima ba lua nginngina ra koli kinung. ");
INSERT INTO mee_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Na ngarume bavakena, na avale laeala ke mate bole. ");
INSERT INTO mee_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Minmina na nga kae e nga sigingpaga nga mateng, na tai mannangana nge ri ka la napengana nga avale laeala kurumea, ri pana lima ba lua ra koli kinung keke kamapitakama kia?” ");
INSERT INTO mee_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Avae Iesus ke role kerea roma, “Miau ka sana lomiaumatana ka pangamologa reke momo nga Lau Ae Nutu Kanna, ba ka sana lomiaumatana kae Nutu ginggingngana bole. Minmina na miau kaka taopa. ");
INSERT INTO mee_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Iau ka role minmina kurumea, ngarume, nga ina reke mate ke la sigingpaga nga mateng, na ri ke sane ke la kamangpitakama. Ba ke sane ke la palingtunga rea ta ri kamangpitakama bole. Ke sa. Ri ka la tongarea kena ma anggelo reke momo nga Nutu mallena nga tava. ");
INSERT INTO mee_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ava nga sigingpaga nga mateng, miau ka sana ka kele pangamologa laeala a Nutu kanna eke paꞌe pala ae? Ke role roma, ");
INSERT INTO mee_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ka iau ae Nutu ae Abaram, bae Aisak, bae Iekop.’ Minmina na ka sana i ae Nutu orae ragau reke mate. Ke sa. Ka i ae Nutu orae ragau reke mauli.” ");
INSERT INTO mee_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ka ina maluame ke longe Iesus pangamologangana laeala, na ri keke kallo raumana ka pangalomatana ra kanna. ");
INSERT INTO mee_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ka inae Parisiome ke longe inae Iesus parule Sarusime minmina, na ri keke katukala kinung te i. ");
INSERT INTO mee_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Na te e nge ri a i a alomatanakana ka bangapagame ke bai ta avange Iesus ka balinglaga te. Minmina na i ke ballage roma, ");
INSERT INTO mee_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Apangalomatanakana, bangapaga a taru ke bollau raumana nga bangapagame kinung?” ");
INSERT INTO mee_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nae Iesus ke ale roma, “One ngo materaumane Avolau a i ae Nutu ae one ka long iname kinung, ba ka longmatenganame kinung, ba ka longmatananganame kinung. ");
INSERT INTO mee_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Bangapaga laeala ka i a bangapaga e kapunu ba bangapaga e bollau nga bangapagame kinung. ");
INSERT INTO mee_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ba bangapaga a lua ka tongana kena ma naeala e kapunu roma, ‘One ngo materaumane agau tetoto basema ino materaumana one muni.’ ");
INSERT INTO mee_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bangapagame kinung ba pangamologame kinung ra reke toe Nutu kaona kanrea keke maispai nga bangapaga lua nginngina.” ");
INSERT INTO mee_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ka inae Parisiome ke katukala kinung minmina, nae Iesus ke ballaga rea ");
INSERT INTO mee_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","roma, “Ka lomiauvavai te Karais mina ngaetai? Ka i a tai sivuna?” Na ri keke ale roma, “Ka i ae Revit sivuna.” ");
INSERT INTO mee_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ka bainae Iesus ke ballaga rea roma, “Ngaroma minmina, na ke meimia nae Revit ke patoe Karais kae ‘Avolau’ kurumea Kannu Ae Nutu taongamugangana kia? Iau ka role minmina kurumea pala, nae Revit ke role roma, ");
INSERT INTO mee_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Nutu a i ae Avolau ke role kae Avolaukau roma: “Ngo tara nga bava nga kamau e pe nga malle a alangpaga ta nge lele nga kae laeala ina iau la ulopisiginge reke baiꞌiu kone ngape nga kaeng sianame.” ’ ");
INSERT INTO mee_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Revit muni ke patoe agau laeala kae Avolaukia. Minmina nae Karais ka i ae Revit sivuna mana mina ngaetai?” ");
INSERT INTO mee_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ka inae Iesus rolea pangamologa laeala, na ka sana agau te totorong ta alanggaliue ka pangamologa inte mana. Ba ngarume nga kae laeala, na ragau kinung keke matau ta ri balinglagange Iesus ka balinglaga te muni. ");
INSERT INTO mee_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nae Iesus ke role ka maluame kala nga barangalele ra kanna ");
INSERT INTO mee_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","roma, “Ra pangalomatanakana nga bangapagame bae Parisiome keke rave malle e nga taongamuga nge Moses. ");
INSERT INTO mee_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Minmina na miau ngaka longlongo te ri, ba ngaka lolakurumea pangamologame kinung ra ri ke tungu rea te miau. Ava sana ngaka lolakurumea baingareame. Iau ka role minmina kurumea, ri keke rorolea orume, ava ri muni ke sane ke lolakurumea oru nginngina. ");
INSERT INTO mee_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Keke ligoe ligongpita reke maena raumana na keke patololoea ragau ki, ava ri muni ka sana omorea ta kalange kamarea ririna te mana ta paunga rea. ");
INSERT INTO mee_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Orume kinung ra ri ke kumkuma ki keke kuma ki ta baina ragau ngeke kela rea, na ngeke kinpataea giareame. Keke umma ta pangavolaunge oru re nga pulinglunge pangamologa rae Nutu kanna ngi onreke samapitpita rea nga ramareame. Ba keke umma ta ulonge oalo reke gavili nga lungapaga nga ri sigirea mataname. Keke kumkuma ka oru nginngina ta baina ragau nga loreavavai roma, ka ri ra ragau reke lolakurumea Nutu lonangana mannangana. ");
INSERT INTO mee_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Keke materaumane malle a alangpaga nga kaning reke bollalau, ba keke materaumane taranga ra ravollalau ngallo nga sinagogme. ");
INSERT INTO mee_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Keke materaumane ragau ta ri kalangapaga rea ka ineke lele nge ri nga malle re nga banga ka kaning. Ba keke materaumane ragau ta ri patongo rea kae ‘Apangalomatanakana.’ ");
INSERT INTO mee_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ava nge miau, sana ngaka matea ta ragau patongo miau kae ‘Apangalomatanakana.’ Iau ka role minmina kurumea, ka kamiau ka Apangalomatanakana kena mana, ba miau kinung ka miau ra koli. ");
INSERT INTO mee_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ba sana ngaka patoe agau te e nga mogalo laekia e ngape ka tamamiau. Iau ka role minmina kurumea, ka Tamamiau kena mana, ba i ke momo nga mallena nga tava. ");
INSERT INTO mee_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ba sana ngaka matea ta ragau patongo miau ka re kapunu. Iau ka role minmina kurumea, ka kamiau ka agau kena mana e kapunu, a i ae Karais. ");
INSERT INTO mee_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Agau a i a avolau ngaliua nge miau nga i a akumangngatulu ae miau. ");
INSERT INTO mee_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ba agau e kinpataetaea i muni giana sonrau ka sana la giana ngarume. Ava agau e ulopisigsigia i muni giana sonrau ke la ravunge gia e bollau ngarume. ");
INSERT INTO mee_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Oru reke sosoali raumana keke la leleng nge miau ra pangalomatanakana nga bangapagame ba miau ra Parisiome. Ka miau ra goangakana. Miau kaka bototalle ragau ta ri manereasa lunga ta Nutu kelangpatalingana nga tava. Miau muni ka sana ka taolulu, ba kaka umma ta lengatotokale ragau pattoto reke bai ta lunga bole.  ");
INSERT INTO mee_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Oru reke sosoali raumana keke la leleng nge miau ra pangalomatanakana nga bangapagame ba miau ra Parisiome. Ka miau ra goangakana. Miau ka kaomiauginapitpite ravale ra nareatale memena ke matepatali rea ta ravunge bale nga ri. Kaka umma minmina ka ina miau ka bavaia kavang reke gavili ta panaunga roma, miau raka momo ngailu nga ragau pattoto. Minmina nae Nutu ke la nameng kamiau raumana, ba nameng laeala nge bollau raumana nga ragau pattoto onre sane ke kuma minmina. ");
INSERT INTO mee_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Oru reke sosoali raumana keke la leleng nge miau ra pangalomatanakana nga bangapagame ba miau ra Parisiome. Ka miau ra goangakana. Miau kaka tatao kalaoveka nga pelau ba nga mogalo ta kalingpa ka agau te ta baina nga i a agau e lolakurume miau te. Ba ka ine nge lele i a agau a miau te, na miau kaka bai kia ta i kumangng ka bainga reke sosoali raumana muni nge miau. ");
INSERT INTO mee_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Oru reke sosoali raumana keke la leleng nge miau. Ka miau ra ragau ra matarea kanname ke su onreke amva ta taongamuga ka ragau pattoto. Kaka umma ta roleng roma, ‘Ngaroma agau te nge patokala ngailu ka tempel, na ka sana otte nga ollaeala. Ava ngaroma agau te nge patokala ngailu ka gol e momo nga tempel, na i nge kuma kurumea patongkalangana laeala.’ ");
INSERT INTO mee_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ka miau ra ragau ra sana ramarea ba ragau ra matarea kanname ke su. Taru ke bollau raumana nge Nutu raguna, gol e momo nga tempel o tempel ore bai ka gol ta i a oru e tupu? ");
INSERT INTO mee_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ba miau kaka umma ta roleng bole roma, ‘Ngaroma agau te nge patokala ngailu ka altara, na ka sana otte nga ollaeala. Ava ngaroma agau te nge patokala ngailu ka tunga e momopai nga altara, na i nge kuma kurumea patongkalangana laeala.’ ");
INSERT INTO mee_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ka miau ra ragau ra matarea kanname ke su. Taru ke bollau raumana nge Nutu raguna, tunga e momopai nga altara o altara ore bai ka tunga ta i a oru e tupu? ");
INSERT INTO mee_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Minmina na agau e patokala ngailu ka altara ke patokala ngailu ka altara ba oru reke momopai kia kinung. ");
INSERT INTO mee_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ba agau e patokala ngailu ka tempel ke patokala ngailu ka tempel bae Nutu e momo ngia kinung. ");
INSERT INTO mee_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ba agau e patokala ngailu ka Nutu mallena nga tava ke patokala ngailu ka tarang ae Nutu e nga kelangpatali bae Nutu e tarapai ngia kinung. ");
INSERT INTO mee_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Oru reke sosoali raumana keke la leleng nge miau ra pangalomatanakana nga bangapagame ba miau ra Parisiome. Ka miau ra goangakana. Miau kaka lolakurumea bangapaga rae Nutu kanna palu mana. Kaka tungtunge oru kenakena nga tangulelu nga oru reke sisina te Nutu, basema lau re nga pangamannmannange kaning. Ava kaka umma ta ulongvalakale bangapaga reke bollalau raumana basema: bainga e nga kalingnana e tupu, ba bainga e nga lonana, ba bainga e nga lokalangana. Ke pe ta miau loangakurumenge bangapaga reke sisina, ava sana ngaka ulovalakale bangapaga nginngina reke bollalau. ");
INSERT INTO mee_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ka miau ra ragau ra matarea kanname ke su onreke amva ta taongamuga ka ragau pattoto. Miau ka tongamiau kena ma agau e kele posi tune sina nga kaning ae i, na ke paeralelepatalia. Ava ke sane kele posi te ora mirana e bollau raumana e momo nga kaning laeala, na ke sonia bavakena. ");
INSERT INTO mee_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Oru reke sosoali raumana keke la leleng nge miau ra pangalomatanakana nga bangapagame ba miau ra Parisiome. Ka miau ra goangakana. Miau kaka palellepaꞌe gato e nga inung ba kato ina nge ngapotu, ava golong ba bainga e nga loangakurumea lomiaungana mana keke ponu ngallo nge ri. ");
INSERT INTO mee_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Miau ra Parisiome ka miau ra ragau ra matarea kanname ke su. Kapunu na miau ngaka palellepaꞌe gato ba kato ina nge ngallo nga baina ina nge ngapotu ngeke lelle bole. ");
INSERT INTO mee_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Oru reke sosoali raumana keke la leleng nge miau ra pangalomatanakana nga bangapagame ba miau ra Parisiome. Ka miau ra goangakana. Miau ka tongamiau kena mana ma baveng nga reke mate ra ragau ke buvunipita rea ka buvuningpita e kavauvaunga raumana, ba keke kela masi raumana nga ina nge ngapotu. Ava reke mate gireame ba orume kinung ra mukurea raumana keke ponu ngallo nge ri. ");
INSERT INTO mee_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Miau ka tongamiau kena minmina mana kurumea, nga miramiau ina nge ngapotu ka miau ra ragau reke tupu raumana nga ragau kelangareangana, ava goanga ba longasa te Nutu keke ponu ngallo nge miau. ");
INSERT INTO mee_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Oru reke sosoali raumana keke la leleng nge miau ra pangalomatanakana nga bangapagame ba miau ra Parisiome. Ka miau ra goangakana. Miau kaka kumkuma ka baveng nga ragau reke toe Nutu kaona reke mate pala ta ri leleng ma baveng ra pau. Ba kaka umma ta kavingtulunge lulu nga reke tupu onreke mate pala. ");
INSERT INTO mee_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ba kaka rorole roma, ‘Taroma mangng ta momomauli nga kae rae sisiukamangng memena, na mangng sana ta kalau rea ta samungpununge ragau reke toe Nutu kaona.’ ");
INSERT INTO mee_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Minmina mana na miau muni kaka umma ta turungpaga kamiau ina miau ka patpato miau ka reke sapune ragau reke toe Nutu kaona sivurea memena. ");
INSERT INTO mee_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ngaka loa nga ravuale sisiukamiau memena baingarea reke sosoali. ");
INSERT INTO mee_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Miau ra mue ra koatali, miau ra mue ra koatali goe rae ri, miau kaka la kangapatali nga kalingnana kana alang e nga momong nga malle a sia e pamiralali passavele mina ngaetai? ");
INSERT INTO mee_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Minmina na iau ka la bange reke toe Nutu kaona te miau. Ba ka la bange ragau ra karea ka lomatana e pe, ba ragau ra pangalomatanakana. Na miau kaka la samungpununge palu nge ri, ba kaka la katungpite palu nga maiskovume. Ba kaka la sapinge palu nga sinagog rae miau. Ba kaka la taonga rea. Ba nga ine ngeke kaꞌe maga kunna te e bollau, na kaka la loanga kurume rea, na kaka la pangamiralali rea nga maga kunna tetoto e bollau. ");
INSERT INTO mee_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Miau kaka la kumangng minmina ta baina alang nga reke tupu kinung totorea e rava nga mogalo laekia e ngape nge momopai nge miau. Ke la pangaturu nge Abel abaingana tupu totona, na nge atu te Berekia tuna ae Sekaraia totona a i a agau ameke sapune ngaliua nga tempel ba altara. ");
INSERT INTO mee_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Iau nga role kamiau ka kaomannmannangana roma, Nutu ke la alange oru nginngina kinung nga ragau reke momo sonrau.” ");
INSERT INTO mee_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nae Iesus ke pamologa ta maga kunna e bollau ae Ierusalem roma, “Kooe Ierusalem. Re nge one keke sapune ragau reke toe Nutu kaona, ba keke tamalipune ragau rae Nutu ba rea te one! Ka kae papatu, nae iau ka bai ta lengakale goe rae one ma kukulega e ballapite goekiame ngape nga papaname. Ava ka sana omong. ");
INSERT INTO mee_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ngo kele, Nutu ke sane la momong nge one muni. ");
INSERT INTO mee_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ta iau ka la roleng kone roma, ngarume na one ko sano la kelanga iau muni ta nge lele nga kae laeala ina one la roleng roma, ‘Nutu ke kavitulu raumane aekia e atu nge Nutu a i ae Avolau giana.’” ");
INSERT INTO mee_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nae Iesus ke lelemalaga nga tempel. Ba ka ine umma ta kange inaeala, na barangalele ra kanna keke loa te i ba keke umma ta pangapanaunge ka bale re nga tempel. ");
INSERT INTO mee_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Na i ke role kerea roma, “Kaka kelapa ka oru papaena ngakarai kinung reke pepe ae? Iau nga role kamiau ka kaomannmannangana roma, ngarume na ka sana la lollo te nakai nge kenopai nga tetoto. Keke la gulaengapisigi ki kinung lagape.” ");
INSERT INTO mee_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ngarume, ka inae Iesus tattara nga Kapoponga Nga Bega Ra Oliv, na barangalele ra kanna keke loa te ine momo mana me i, na keke role kia roma, “Onto role paka mangng, oru nginngina ramo role tao pala ke la leleng nga pia? Ba mangng ka la kelange killa a taru, na nga lomangngmatana roma atungang ba momong gunguna keke tatu kokoro?” ");
INSERT INTO mee_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nae Iesus ke ala rea roma, “Ngaka ella miau masi ta baina agau te sane nge pataopa miau. ");
INSERT INTO mee_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Iau ka role minmina kurumea, ragau papatu keke la ri atung nga giau, na keke la kumangng ta roleng roma, ‘Ka iau ae Karais.’ Ba keke la pangataopange ragau papatu. ");
INSERT INTO mee_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ba miau kaka la longnge maimai re nga baling reke bollalau, ba kaka la longnge pangamologa re kalaoka re ta baling reke bollalau. Ava sana ngaka matau. Ka kaomannmannangana, oru nginngina keke la leleng, ava ollaeala ka sana la mirana roma, momong gunguna ke lele tapu. ");
INSERT INTO mee_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Iau ka role minmina kurumea, galiau te ke la loanga ta baling kala nga galiau tetoto, ba re nga kelangpatali te keke la loanga ta baling kala nga re nga kelangpatali tetoto. Ba ka la oru giongana tatana reke bollalau, ba osangana reke bollalau nga iname bole. ");
INSERT INTO mee_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ava oru nginngina kinung ka la ri ra oru pangaturungana mana ma ina avale te nge paturu ta kaningmainge mirana lalinganame ine bai ta toangapisiginge goe. ");
INSERT INTO mee_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Na keke la ri ulongo miau nga reke la pangamiralali miau kamareame, ba keke la samungpunu miau. Ba re nga iname kinung keke la baingaꞌiu kamiau kurumea loangakurume ngamiaungana kau. ");
INSERT INTO mee_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ba ka kae nginngina na ragau papatu ra loreapatokona te iau keke la kange lopatokona ae ri. Ba keke la ulonge ra lopatokonakana pattoto nga reke bai ta baingasoali rea kamareame. Ba keke la ri baingaꞌiu ka ra lopatokonakana pattoto. ");
INSERT INTO mee_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ba poropet ra goanga papatu keke la leleng, na keke la pangataopange ragau papatu. ");
INSERT INTO mee_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ba bainga re nga longasa te Nutu keke la ri leleng papatu raumana. Minmina na ragau ke sane ke la matengraumanange Nutu, ba ke sane ke la matengraumanange ragau pattoto bole. ");
INSERT INTO mee_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ava agau e momo gingging ta nge lele nga kae a ronga ka la i a agau a Nutu la ravunglelenge. ");
INSERT INTO mee_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ba ragau keke la pulingmalagange pangamologa laekia e pe e ta Nutu kelangpatalingana nga iname kinung nga mogalo laekia e ngape ta baina ragau re ngae iname kinung ngeke longe. Na kae a ronga ke la leleng. ");
INSERT INTO mee_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Minmina na miau kaka la kelange ollaeala a mukuna raumana amae agau e toe Nutu kaona ae Raniel role te pala. Kaka la kelange ‘ollaeala a mukuna raumana ore baia iu nge Nutu ne bai kia ta i baingasoalinge tempel.’ Kaka la kelange ine nge maisinsi nga malle e tupu ngallo nga tempel. Na agau e kele pangamologa laeala ae Raniel kanna nga lonamatana masi. ");
INSERT INTO mee_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Na ragau reke momo ngae Iurea nga kae laeala ngeke ka ta kapangngme. ");
INSERT INTO mee_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ba agau e momo nga bale bilingana e ngailu sane nge sopisigi ta bale bilingana e ngape ta ravunge oru nga kanna reke momo nga malle laeala. Ke sa. Nge ka bolvole. ");
INSERT INTO mee_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ba agau e momo nga ura sane nge kagaliu ta bale ae i ta ravunge lungapaga ae i e ngapotu. ");
INSERT INTO mee_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kae nginngina keke la ri isongpa raumana ta ravale ra siarea ba ta ravale reke pasisiue goe rae ri ra lagalaga. ");
INSERT INTO mee_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ava ngaka kava te Nutu ta kangamiaungana sane nge lele nga kae reke marusu, o nga kae a Sabat. ");
INSERT INTO mee_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Iau ka role minmina kurumea, maenang laeala ore la leleng nga kae nginngina ka la i a maenang tanakena. Ke la bolinglaunga raumana nga maenangme kinung paturu ka ina mogalo laekia e ngape lele pau ta ke lele nga kae laekia e sonrau. Ba ngarume nga maenang laeala, na ka sana la maenang te e bollau muni nga naeala bole. ");
INSERT INTO mee_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ba taroma Nutu sane te pamore kae nginngina re ngarume, na ragau kinung teke sanrea. Ava i ka la lonananne ragau rae i ra i toro rea te i, minmina na i ke la pangamoronge kae nginngina. ");
INSERT INTO mee_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Na ngaroma agau te nge role kamiau nga kae nginngina roma, ‘Ngaka kele, Karais ikia!’ o ‘Ngaka kele, Karais iala!’ na sana nga lomiaupatokona ta pangamologa a kanna. ");
INSERT INTO mee_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Iau ka role minmina kurumea, Karais ra goanga ba poropet ra goanga keke la leleng ka kae nginngina. Ba ri keke la kosining ka killa ba kumangng reke bollalau raumana ta baina ri ngeke pataope ragau. Avae Nutu sane la ngatangngkale kumangng nginngina ta ri pangataopange ragau rae i ra i toro rea te i. ");
INSERT INTO mee_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ngaka longo masi, iau ka umma ta turunglomatana pakamiau ta oru nginngina pala ta ri leleng. ");
INSERT INTO mee_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Minmina na ngaroma ragau ngeke role kamiau roma, ‘Ngaka kele, i ke momo nga inaeala a sana ragau ngia,’ na sana ngaka loa ta inaeala ta kelanga te i. O ngaroma ri ngeke role kamiau roma, ‘Ngaka kele, i ke momo nga bale bilingana re ngallo,’ na sana nga lomiaupatokona ta pangamologa nga kanrea. ");
INSERT INTO mee_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Iau ka role minmina kurumea, kae laeala e nga Agau Tuna atungngana ngarume ka la tongana kena ma saia ine nge killama nga ina kae lele ngia, na lamanangana nge sasa bavakena ta ina kae barelulu ngia.” ");
INSERT INTO mee_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Na i ke role kerea ka pangateningkala te roma, “Manu reke kaninnia onreke bona keke la ginunga nga malle a oru e bona momo ngia.” ");
INSERT INTO mee_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Na nga ina maenang reke la leleng nga kae nginngina ngeke rongo tapu na bolvole mana na, “‘Kae matana ka la osuguna, ba inna ke sane la talanga muni; ba matame keke la pupungpisigi nga tava lagape, bae Nutu ke la baingamatagange oru reke gingging raumana reke momo nga tava.’ ");
INSERT INTO mee_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Nae Agau Tuna kana killa ke la leleng nga tava. Na ragau re nga iname kinung nga mogalo laekia e ngape ka la loreatani. Ba ri keke la kelange Agau Tuna ine nge tatu nga mukmukua reke momo nga tava ka ginggingngana e bollau ba olamana ae i e bollau raumana ore toakala. ");
INSERT INTO mee_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Na tarampet ka la maina kaligi, na i ke la bange anggelo rae i ta ravungkinunge ragau rae i ra i toro rea onreke momo nga iname kinung ngape nga tava. ");
INSERT INTO mee_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ngaka rave lomatana nga bega a pik minakai roma: nga ina bega a pik supungana ba launa ra pau ngeke lele tapu, na nga lomiaumatana roma, kaepa ke kokoro. ");
INSERT INTO mee_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Minmina mana, na nga ina miau ngaka kele oru nginngina kinung ama iau role tao, na nga lomiaumatana roma, Agau Tuna atungana ke lele kokoro. Ke atu kokoro mannangana. ");
INSERT INTO mee_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Iau nga role kamiau ka kaomannmannangana roma, ragau reke momomauli sonrau keke la momongmauli tale, na keke la kelange oru nginngina kinung ama iau role tao lelengarea. ");
INSERT INTO mee_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tava ba mogalo keke la ronga, ava pangamologa ra kanau ke sane ke la ronga. ");
INSERT INTO mee_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ava sana agau te lonamatana ka kae a taru ba kae matana a taru ina oru nginngina ke la leleng. Anggelo reke momo nga Nutu mallena nga tava ka sana loreamatana, bae Nutu Tuna ka sana lonamatana bole. Avae Nutu kasikena ka lonamatana. ");
INSERT INTO mee_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Iau ka role minmina kurumea, oru reke la leleng nga Agau Tuna atungngana ngarume ka la tongarea kena ma oru reke lele pala ka kae rae Noa. ");
INSERT INTO mee_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Iau ka role minmina kurumea, pala ka kae nginngina ina me potungana e bollau sane lele tale, na ragau keke kaninni, ba keke innu, ba keke paliraravu rea ta ke lele nga kae laeala a Noa kala nga balekaina ae i ke lu lakallo ta mono. ");
INSERT INTO mee_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ba ri ka sana loreamatana ka taru e la leleng ta ke lele ina me potungana e bollau ke lele, na ke ravupatali ka ri kinung. Ollaeala ka tongana kena mana ma oru reke la leleng nga Agau Tuna atungngana ngarume. ");
INSERT INTO mee_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nga kae laeala na rapanung lua keke la kumangng kinung nga ura, nae Nutu ke la ravunge te nge ri pana lua nginngina, ava te ke la momong. ");
INSERT INTO mee_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ba bole ravale lua keke la naunga lamasi kinung, nae Nutu ke la ravunge te nge ri pana lua nginngina, ava te ke la momong. ");
INSERT INTO mee_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Minmina na miau ngaka momo ba ngaka kelkela kurumea, ka sana lomiaumatana ka kae a Avolaukamiau la atung kia. ");
INSERT INTO mee_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ava nga lomiaumatana roma: Taroma bale tamana ta lonamatana ka kae matana a taru ka rigo a agolongkana la atung kia, na i te ella ba sane te ngatakale agolongkana ta i taongalu ta bale ba golonge orume. ");
INSERT INTO mee_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Minmina na miau bole ngaka momo ba ngaka ella kurumea, Agau Tuna ke la atung ka kae matana te a miau ka lomiauvavai roma, ke sane la atung kia. ");
INSERT INTO mee_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Akumangngatulu e loatunanne avolaukia ba ka kana ka lomatana e pe ke meimia ka baingana? Ka i a agau matana a avolaukia nge pulia ta i kelangpatali ta ra kumangngatulu reke momo nga bale ae i ba ta i tunga karea kaning ka kae matana e nga kaning. ");
INSERT INTO mee_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Akumangngatulu laeala nga lonasereng raumana ngaroma avolaukia nge lele, na nge kalipa kia ine umma minmina. ");
INSERT INTO mee_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Iau nga role kamiau ka kaomannmannangana roma, avolaukia ke la pulinge ta i kelangapatali ta oru ra i kinung. ");
INSERT INTO mee_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ava ngaroma akumangngatulu laeala nga i a akumangngatulu e soali ba nge role ngallo nge i muni roma, ‘Avolaukau ke la momong ka panna tane gavili nanguni,’ ");
INSERT INTO mee_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","na i nge paturu ta balinge kumangngkena rae i, ba nge kaninni ba nge innu kala nga ra inungkana. ");
INSERT INTO mee_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Na akumangngatulu laeala avolaukia ke la atung ka kae te a akumangngatulu laeala lonavavai roma i ke sane la atung kia, ba ka kae matana te a i sana lonamatana kia. ");
INSERT INTO mee_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na i nge sapipatoto kia ba nge pulia ta i momong kala nga ragau ra goangakana nga malle laeala a ragau ke la taning ba ke la tanaginge ngingireame ngia.” ");
INSERT INTO mee_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ba ka kae laeala e nga Agau Tuna atungngana ngarume, nae Nutu kelangpatalingana nga tava ka la tongana kena ma ra malaui ka ri tangulelu onreke rave lama ra kanrea, na keke lelemalaga ta pangaserengkale apanung ore tatu ta kamangpitakama ka avale te. ");
INSERT INTO mee_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lima nga malaui nginngina ka onra sana ramarea, ba lima ka karea ka lomatana e pe. ");
INSERT INTO mee_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ba ka ina ra sana ramarea ke rave lama nga kanrea, na ke sane ke rave me e nga lamame kurume rea. ");
INSERT INTO mee_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ava malaui ra karea ka lomatana e pe keke rave lama nga ri, ba keke rave gato onra me momo ngi bole. ");
INSERT INTO mee_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na keke momalle apanung laeala e tatu ta kamangpitakama, ava ke sane lele bolvole. Minmina na matarea kanname keke rurulu, na keke kenrau eke momo. ");
INSERT INTO mee_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ava ka rigo luana na agau te ke reli roma, ‘Apanung ame la kamangpitakama ikolong e lele! Ita ngaka loa ta pangaserengkale nga pamau.’ ");
INSERT INTO mee_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Na malaui nginngina kinung keke sigipaga, na keke katupe lama nga ri. ");
INSERT INTO mee_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ba malaui onra sana ramarea keke role ka nanga karea ka lomatana e pe roma, ‘Ngaka tunge kanmangng me ina palu nge miau ta lama nga mangng keke bai ta mateng.’ ");
INSERT INTO mee_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ava malaui nginngina ra karea ka lomatana e pe keke ala rea roma, ‘Ke sa. Me ina ra kanmangng keke moro ta kalaunga mangng ba miau, ava mangnga mana. Ngaka loa ta reke bava ka me, na ngaka kolia kanmiau me ina panu.’ ");
INSERT INTO mee_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ava ka ina malaui nginngina ra sana ramarea ke lola ta kolinge me, na apanung laeala e bai ta kamangpitakama ke lele. Na malaui nginngina reke kalitupu tapu keke lu lakallo ta kaning kala nge i nga kaning e bollau e nga palingravung. Na ragau keke pulakale bale kaona. ");
INSERT INTO mee_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ngarume na malaui nginngina onra sana ramarea keke lele bole, na keke meisinsi ngapotu ba keke kikiu roma, ‘Avolau, avolau, ngo pulapatalia balkaona te mangng.’ ");
INSERT INTO mee_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ava i ke ala rea roma, ‘Iau nga role kamiau ka kaomannmannangana roma, iau ka sana laumatana kamiau.’” ");
INSERT INTO mee_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nae Iesus ke rongo ka pangateningkala laeala roma, “Minmina na miau ngaka momo ba ngaka ella kurumea, ka sana lomiaumatana ka kae a Agau Tuna la atung kia. Ba ka sana lomiaumatana ka kae matana a i la leleng kia bole.” ");
INSERT INTO mee_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Nae Iesus ke role kerea ka pangateningkala te muni roma, “Ba muni, iau nga toe Nutu kelangpatalingana nga tava ka agau te a bollau e bai ta loanga ta maga te e ngatauga. Minmina na i ke kiukinunge ra kumangngatulu ra kanna, na ke paꞌtalo rea ka oru nga kanna. ");
INSERT INTO mee_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","I ke tunge lollokanname ka ri lima ta akumangngatulu te, ba ke tunge lollokanname ka ri lua ta te, ba ke tunge lollokanna kena ta te. Ke tunge lollokanna nginngina te ri kurumea kenakena likinangana. Na ke ka rea e loa ta maga laeala e ngatauga. ");
INSERT INTO mee_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Na akumangngatulu e rave lollokanname ka ri lima ke loa bolvole na ke pakumane lollokanna nginngina. Na ke rave lollokanname ka ri lima muni. ");
INSERT INTO mee_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ba akumangngatulu e rave lollokanname ka ri lua ke kuma minmina bole, na ke rave lollokanname ka ri lua muni. ");
INSERT INTO mee_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ava akumangngatulu e rave lollokanna kena ke loa, na ke kilia lulu te nga mogalo ba ke talue lollokanna laeala a avolaukia kanna. ");
INSERT INTO mee_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ngarume, ka ina kae papatu ke rongo tapu, na akumangngatulu nginngina avolaukerea ke galiu. Na i ke kiukinungu rea ta baina i nga lonamatana ka kenakena pangakamongana ka lollokanname. ");
INSERT INTO mee_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na naeala e rave lollokanname ka ri lima ke loa ka lollokanname ka ri lima muni, na ke role ka avolaukia roma, ‘Avolau, one ko paꞌtalo iau ka lollokanname ka ri lima. Ba ngo kele, iau ka rave lollokanname ka ri lima muni.’ ");
INSERT INTO mee_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Na avolaukia ke role kia roma, ‘Ko kuma masi, ka one a akumangngatulu e pe ba akumangngatulu a lokalakana. One ka longkala ka oru tutuna, minmina na iau ka la puling one ta one kelangpatali ta oru papatu. Ngo atu, na nga longsereng kala nge iau.’ ");
INSERT INTO mee_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Na akumangngatulu e rave lollokanname ka ri lua ke loa ta avolaukia bole, na ke role kia roma, ‘Avolau, one ko paꞌtalo iau ka lollokanname ka ri lua. Ba ngo kele, iau ka rave lollokanname ka ri lua muni.’ ");
INSERT INTO mee_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Na avolaukia ke role kia roma, ‘Ko kuma masi, ka one a akumangngatulu e pe ba akumangngatulu a lokalakana. One ka longkala ka oru tutuna, minmina na iau ka la puling one ta one kelangpatali ta oru papatu. Ngo atu, na nga longsereng kala nge iau.’ ");
INSERT INTO mee_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ngarume na akumangngatulu e rave lollokanna kena ke loa ta avolaukia bole, na ke role kia roma, ‘Avolau, iau ka laumatana roma, ka one a avolau te ore isopa. One ko umma ta lagange kaning a agau tetoto toaꞌe. Ba ko raravukinunge kaning nga ina ra ragau pattoto ke toaꞌe kaning ngi. ");
INSERT INTO mee_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Minmina na iau ka matau one. Ka baina iau ka loa na ka talue lollokanna a kaning nga mogalo. Ngo kele, lollokanna ama kaning ikia.’ ");
INSERT INTO mee_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Na akumangngatulu laeala avolaukia ke ale roma, ‘Ka one a akumangngatulu e sane pe, ba akumangngatulu a omosalilikana. Ka longmatana tapu roma, iau ka umma ta lagange kaning a agau tetoto toaꞌe, ba ka raravukinunge kaning nga ina ra ragau pattoto ke toaꞌe kaning ngi. ");
INSERT INTO mee_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na ke meimia na one ko sano pulia lollokanna a kanau nga malle e ta i pangakumana ngia nga baina iau nga galiu na nga rave lollokanna a kanau ba palu ngailu muni?’ ");
INSERT INTO mee_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Minmina na avolaukia ke role ka barangaleleme roma, ‘Miau ngaka ravugaliue lollokanna kena laeala nge aekolong, na ngaka tunge ta akumangngatulu laeala a kanna ka lollokanname ka ri tangulelu. ");
INSERT INTO mee_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Iau ka role minmina kurumea, iau ka la tungnge oru papatu muni ta agau a kana oru nga baina i nga kana oru papatu raumana. Ava nga agau a sana kana oru, iau ka la ravungpatali ka ottutunna rae i nga baina i sana nga kana oru bavakena. ");
INSERT INTO mee_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ba ngaka tamalimalaga ka akumangngatulu laekia ore soali lakallo ta osuguna nga malle laeala a ragau ke la taning ba ke la tanaginge ngingireame ngia.’” ");
INSERT INTO mee_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nae Iesus ke role kerea roma, “Ngarume, ka inae Agau Tuna la atung nga olamana ae i e toakala kala nga anggelo rae i kinung, na i ke la tarang nga tarang ae i e nga kelangpatali ora lamana toakala. ");
INSERT INTO mee_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na keke la ravungkinunge ragau re nga iname kinung ta ri maising nga raguna. Na i ke la kalingpala rea ma agau e ellapatantali ta sipsipme ine nge kalipale posi ra marana, na nge ule sipsipme nga inte ba posi ra meme nga inte toto. ");
INSERT INTO mee_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Agau Tuna ke la kumangng minmina bole, ba i ke la ulonge sipsipme nga bavana e pe ba posi ra meme nga bavana a laeva. ");
INSERT INTO mee_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Nae Agau Tuna a i a Kelangpatali ke la roleng ka ragau reke momo nga bavana e pe roma, ‘Miau rae Tamau kavitulu miau ramana ngaka atu, nae Tamau ke la tungnge kavingtulu re nga kelangpatalingana te miau. Ka ri ra kavingtulu ra i kalitupu rea pala nganige ka ina mogalo laekia e ngape sane lele tale. Ke kalitupu rea ta tunga rea te miau. ");
INSERT INTO mee_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Iau ka role minmina kurumea, pala ka ina matekau, na miau kaka tung kau kaning. Ba ka ina matekau me, na kaka tung kau me. Ba ka ina iau a agau te e nga maga tetoto, na miau kaka ravu iau ta bale rae miau. ");
INSERT INTO mee_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ba ka ina sana kau lungapaga, na kaka tung kau lungapaga. Ba ka ina kau ka soaling, na kaka atu ta kelanga iau. Ba ka ina iau momo nga pulangkala, na kaka atu te iau.’ ");
INSERT INTO mee_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Na ra nginngina ra baingareame ke tupu reke momo nga Kelangpatali bavana e pe keke la alange roma, ‘Avolau, mangng ka kela one ina matekang, na mangng ka tung kang kaning nga pia? O mangng ka kela one ina matekang me, na mangng ka tung kang me nga pia? ");
INSERT INTO mee_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ba mangng ka kela one ka ina one a agau te e nga maga tetoto, na mangng ka ravu one ta bale rae mangng nga pia? O mangng ka kela one ina sana kanga lungapaga, na mangng ka tung kanga lungapaga nga pia? ");
INSERT INTO mee_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ba mangng ka kela one ka ina kanga ka soaling o ka ina one momo nga pulangkala, na mangng ka loa te one nga pia?’ ");
INSERT INTO mee_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Nae Kelangpatali ke la alange pangamologa ra kanrea roma, ‘Iau nga role kamiau ka kaomannmannangana roma, ka ina miau ka kuma ka oru nginngina ta te mana nga barangalele kokorai ra kanau ora sana giana, na miau alaka kuma ki te iau.’ ");
INSERT INTO mee_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Na i ke la roleng ka ragau reke momo nga bavana a laeva roma, ‘Miau ra Nutu la tungnge alang e soali te miau ngaka kapatali iau. Na ngaka loa ta sia e sane matmate ora Nutu kalitupe ta Satan kala nga anggelo rae i. ");
INSERT INTO mee_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Iau ka role minmina kurumea, pala ka ina matekau, na miau ka sana ka tung kau kaning. Ba ka ina matekau me, na ka sana ka tung kau me. ");
INSERT INTO mee_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ba ka ina iau a agau te e nga maga tetoto, na miau ka sana ka ravu iau ta bale rae miau. Ba ka ina sana kau lungapaga, na ka sana ka tung kau lungapaga. Ba ka ina kau ka soaling, ba ka ina iau momo nga pulangkala, na ka sana ka atu ta kelanga iau.’ ");
INSERT INTO mee_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Na ri bole keke la alange roma, ‘Avolau, mangng ka kela one ina matekang, o ina matekang me, o ka ina one a agau te e nga maga tetoto, o ina sana kanga lungapaga, o ina kang ka soaling, o ka ina one momo nga pulangkala, ava mangng ka sana kela te one nga pia?’ ");
INSERT INTO mee_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Nae Kelangpatali ke la alange pangamologa ra kanrea roma, ‘Iau nga role kamiau ka kaomannmannangana roma, ka ina miau ka sana ka kuma ka oru nginngina ta te nga barangalele kokorai ra kanau ora sana giana, na miau ala sana ka kuma ki te iau.’ ");
INSERT INTO mee_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Na ragau nginngina keke la loanga lakallo ta malle e nga ravunge alanga e soali passavele. Ava ragau ra baingareame ke tupu keke la loanga ta malle e nga momong mauli passavele.” ");
INSERT INTO mee_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ka inae Iesus rolea pangamologa nginngina kinung tapu, na i ke role ka barangalele ra kanna roma, ");
INSERT INTO mee_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Miau ka lomiaumatana tapu roma, ngarume nga kae lua, na Paska ke la leleng. Na ri keke la ulonge Agau Tuna nga ragau kamareame ta ri katungpitange nga maiskovu.” ");
INSERT INTO mee_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na re kapunu nga pirisme ba Iura ravollalaukerea memena keke katukala kinung ngallo nga malle e ngapotu nga bale ae piris e kapunu a giana nge Kaiapas. ");
INSERT INTO mee_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Na keke potolu Iesus kana ta ri ngeke laugomea, na ngeke samupune. ");
INSERT INTO mee_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ava keke palirorole kerea roma, “Ita sana ngaka kuma kia ka kae re nga Kaning E Bollau. Ta ngaroma ita ngaka kuma kia ka kae nginngina na reke momo nga Kaning E Bollau keke la kelange, na keke la ri kumangng ka lavongkala e bollau.” ");
INSERT INTO mee_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ka inae Iesus mommo nga maga kunna ae Betani nga bale ae Saimon te eke patoe ka akalangamugmugukana, ");
INSERT INTO mee_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","na avale te ke rave gato a lollo ora saulang a koina lolo ba a kunna bollau raumana ke momolu ngia, na ke loa te Iesus. Na i ke kelingia saulang laeala nge Iesus kunna ine tattara ka bongapaikalanganakia ta kaning nga pala. ");
INSERT INTO mee_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ava ka ina barangalele rae Iesus kanna ke kele ollaeala, na ri ka sana siareakena ka kumangng laeala. Ba keke palibalaglaga rea roma, “Ke meimia, na ke rongomana ka saulang laeala? ");
INSERT INTO mee_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Taroma ita taka ba kia, na taka rave lollokanna papatu ta tunga rea ta ra sillolo.” ");
INSERT INTO mee_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Avae Iesus ka lonamatana ka taru a ri ke pamolloga te, minmina na i ke pavokala rea roma, “Kaka meimia aka umma ta mologang ka avale laekia? I ke kuma ka bainga e pe te iau. ");
INSERT INTO mee_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Iau ka role minmina kurumea, ra sillolo keke mommo kala nge miau ka kaeme kinung, ava iau sana la momong kala nge miau ka kaeme kinung. ");
INSERT INTO mee_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ka ina avale laekia kelingia saulang laekia a koina lolo nga mirau, na i ke kuma ka ollaeala ta kalingtupu iau nga talungau. ");
INSERT INTO mee_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Iau nga role kamiau ka kaomannmannangana roma, nga iname kinung nga mogalo laekia e ngape reke la pulingmalagange pangamologa laekia e pe e te iau ngi ngarume, keke la turunglomatana ta avale laekia kumangngana bole ta baina ragau nga loreagaliu te i.” ");
INSERT INTO mee_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Na te e nga Pana Tangulelu Ba Lua, ora giana nge Iuras Iskariot, ke loa ta piris re kapunu. ");
INSERT INTO mee_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Na i ke ballaga rea roma, “Ngaroma nga tunge Iesus te miau, na miau kaka la tungnge taru te iau?” Na ri keke sisia lollokanna onra siliva ka ri giaukaina ba tangulelu, na keke tungu rea te i. ");
INSERT INTO mee_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ba ngarume nga kae laeala, nae Iuras ke ella ta pamau te ta i ulonge Iesus nga kamareame. ");
INSERT INTO mee_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na ka kae e kapunu nga kae re nga Kaning E Bollau E Nga Berete A Sana Kana Isi, na barangalele rae Iesus kanna keke loa te i, na keke ballage roma, “Ko matea ta mangng kalingtupunge orume ta one kaninge kaning e nga Paska nga ine ngaetai?” ");
INSERT INTO mee_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Na i ke ala rea roma, “Ngaka taolu tae Ierusalem, na kaka la kalingpa ka apanung te. Na ngaka role kia roma, ‘Apangalomatanakana ke role roma, “Kae ae iau ke lele kokoro. Iau ka la kaninge kaning e nga Paska nga bale ae one kala nga barangalele ra kanau.” ’” ");
INSERT INTO mee_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Na barangalele rae Iesus kanna keke kuma kurumea Iesus pangamologangana te ri. Na keke kalitupe orume ta ri kaninge kaning e nga Paska. ");
INSERT INTO mee_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ka ina kae barelu tapu, nae Iesus ke tattara ka bongapaikalanganakia ta kaning nga pala kala nga barangalele ra kanna. ");
INSERT INTO mee_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ba ka ineke kaninni, na i ke role kerea roma, “Iau nga role kamiau ka kaomannmannangana roma, te e nge miau ke la ulongo iau nga reke la baingasoali iau kamareame.” ");
INSERT INTO mee_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ka ineke longe pangamologangana laeala, na ri ka loreatani raumana. Na kenakena nge ri ke paturu ta balinglagange roma, “Avolau, iau ke sa ae?” ");
INSERT INTO mee_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nae Iesus ke ala rea roma, “Ne kalalue kamana nga kato kala nge iau ke la ulongo iau nga reke la baingasoali iau kamareame. ");
INSERT INTO mee_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ka kaomanna. Agau Tuna ke la mateng kurumea pangamologa e te i a ri ke paꞌe pala, ava oru reke sosoali raumana keke la leleng nga agau laeala e ule nga reke bai ta baingasoalinge kamareame! Te pe nga apanung laeala taroma naname sane te toapisigia.” ");
INSERT INTO mee_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nae Iuras, a i a agau laeala e la ulonge Iesus nga reke bai ta baingasoalinge kamareame, ke role roma, “Rabai, iau ke sa ae?” Nae Iesus ke ale roma, “One muni ko rolea.” ");
INSERT INTO mee_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ka ineke kaninni, nae Iesus ke rave beret palu, na ke kalapage Nutu ba ke regipale beret laeala. Na ke tunge ta barangalele ra kanna ka rolengana kerea roma, “Ngaka rave, na ngaka kania. Beret laekolong ka i a mirau.” ");
INSERT INTO mee_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Na i ke rave gato te e ponu ka uain, ba ka ine kalapage Nutu tapu, na i ke tunge gato laeala te ri ka rolengana kerea roma, “Ngaka inu nga gato laekolong, miau kinung. ");
INSERT INTO mee_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Iau ka role minmina kurumea, uain nga gato laekolong ka i a totogu ore nga piunga ba bonga a Nutu la kumangng kia. I ke la kengalingia totogu ta kalaungapage ragau papatu. Ke la kengalingia ta kumangng ka pamau ta i osungrurunge baingarea reke sosoali nga raguna. ");
INSERT INTO mee_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Iau nga role kamiau roma, iau ka sana la inunge uain laekia muni ta nge lele nga kae laeala nga inungau a pau ka uain kala nge miau nga Tamau kelangpatalingana ngarume.” ");
INSERT INTO mee_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ba ka ineke baue baunga te a kalangapaga tapu, na keke lelemalaga nga maga kunna e bollau na keke loa ta Kapoponga Nga Bega Ra Oliv. ");
INSERT INTO mee_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nae Iesus ke role kerea roma, “Ka rigo laekia mana, na miau kinung kaka la kanga iau nga ina miau nga kele oru reke la leleng nge iau. Iau ka role minmina ta pala, na ri keke paꞌe pangamologa e role roma: “‘Iau ka la balinge kelangapatali ae sipsipme, na sipsip rae i keke la kanga kalaoveka.’ ");
INSERT INTO mee_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ava ngarume, ka ina iau nga sigipaga nga mateng tapu, na iau ka la loanga pala nge miau tae Galili.” ");
INSERT INTO mee_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Avae Pita ke ale roma, “Ngaroma ragau kinung ngeke ka one nga ineke kele oru reke lele nge one, na iau sana la kanga one.” ");
INSERT INTO mee_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nae Iesus ke role kae Pita roma, “Iau nga role kone ka kaomannmannangana roma, ka rigo laekia mana pala ta kukulega toangako, na one ko la kaulingkala iau pa mologi.” ");
INSERT INTO mee_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nae Pita ke role kae Iesus roma, “Ngaroma otte nge bai kau ta mateng kala nge one, ollaeala bole ke sane la bainga kau ta kaulingkala one.” Ba barangalele rae Iesus kanna kinung keke role minmina bole. ");
INSERT INTO mee_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nae Iesus ke loa kala nga barangalele ra kanna ta malle te eke patoe kae Getsemani. Na ke role kerea roma, “Miau ngaka tara nakai, ava iau nga loa ta kavang te Nutu naꞌina.” ");
INSERT INTO mee_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Na i ke rave Pita kala nge Sepeti tuna memena ka ri lua kurumea. Na ke paturu ta kaningmainge lotaningngana e bollau ba maenang ngallo nge i. ");
INSERT INTO mee_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Na ke role kerea roma, “Iau ka kanimaimaia lotaningngana e bollau raumana ore bavai kau kokoro ta mateng. Miau ngaka momo nakai, ba ngaka ella kala nge iau.” ");
INSERT INTO mee_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Na i ke loa lagatauga isura nge ri, na ke pupisigi ka raguna nga mogalo ba ke kava te Nutu roma, “Tamau, ngaroma nga pamau te, na ngo ravupatali ka gato laekia a miralali nge iau. Ava ka sana matea ta one kumangng kurumea laungana. Ke sa. Ka matea ta one kumangng kurumea longangana.” ");
INSERT INTO mee_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Na i ke loa ta barangalele nginngina ra kanna ka ri mologi, ava ka ine lele nge ri na keke kenrarau. Minmina na i ke role kae Pita roma, “Miau ka sana ka gingging ta kelanga kala nge iau ka panna inte mana ae? ");
INSERT INTO mee_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ngaka ella ba ngaka kava te Nutu ta baina miau sana ngaka lele nga avangme. Agau kannuna ka omona, ava mirana ka likinasa.” ");
INSERT INTO mee_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nae Iesus ke ka rea ka kangana kerea a lua, ba ke kava te Nutu roma, “Tamau, ngaroma sana nga pamau tetoto, ba ngaroma one ngo matea ta iau inung nga gato laekia a miralali, na iau ka matea ta one kumangng kurumea longangana.” ");
INSERT INTO mee_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Na i ke galiu muni te ri, ba ke ine lele nge ri na keke kenrarau kurumea, matarea kanname keke rurulu. ");
INSERT INTO mee_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Na i ke ka rea muni. Na ke loa ba ke kava te Nutu ka kavangana a mologi. Ba kavangana laeala ka tongana kena ma ine kava pala. ");
INSERT INTO mee_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Na i ke loa ta barangalele ra kanna, na ke role kerea roma, “Miau kaka kenrarau baka pannpanna kamiau tale ae? Ngaka kele, panna ina ae iau ke lele kokoro ba agau te ke kumkuma gialgiala mana ta i ulonge Agau Tuna nga ra baingareame ke soali kamareame. ");
INSERT INTO mee_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ka sigipaga nga ita lola. Agau e la ulongo iau nga reke la baingasoali iau kamareame ikolong e tatu!” ");
INSERT INTO mee_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ka inae Iesus pamolloga tale, nae Iuras, a i a te e nga Pana Tangulelu Ba Lua, ke lele. Ba malua e bollau onreke kamopitpite resalla ra matareame ka ri lua ba butume keke momo kala nge i. Ka ri ra ragau ra piris re kapunu ba Iurame ravollalaukerea memena ke ba rea. ");
INSERT INTO mee_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ba agau laeala ore bai ta ulonge Iesus nga kamareame ke tunge killa te te ri pala roma, “Agau a iau la tagungkao kia ka i a agau a miau ka matea. Ngaka laue agau laeala.” ");
INSERT INTO mee_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Minmina nae Iuras ke loa tupu te Iesus, na ke role kia roma, “Rabai, rigo e pe!” Na ke tagukao kae Iesus. ");
INSERT INTO mee_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nae Iesus ke role kia roma, “Koli, ngo kuma ka ollaeala a one atu ta kumangng kia.” Na reke atu kala nge Iuras keke loa te Iesus, na keke laue. ");
INSERT INTO mee_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ava ka ina reke lolakurumea Iesus ke kele ollaeala e lele, na te i nge ri ke ravumalage resalla a kanna a mataname ka ri lua. Na ke magala kia nga akumangngatulu ora piris e kapunu kanna, ba ke saꞌvatote longana. ");
INSERT INTO mee_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Avae Iesus ke role kia roma, “Pulgaliue resalla a kaning lakallo ta mallena! Ragau reke rarave resallame ta baling ki keke la mateng ka resalla bole. ");
INSERT INTO mee_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","One ko roma, iau ka sana totorong ta kiunge Tamau ta i bange galiaume ka ri tangulelu ba lua ba papatu muni ra anggelo ta ri atung ta kalaunga iau bolvole ae? ");
INSERT INTO mee_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ava ngaroma iau nga kuma minmina, na pangamologa ra ri ke pa rea pala nga Lau Ae Nutu Kanna keke la leleng mannangana mina ngaetai? Pangamologa nginngina keke role roma, oru kokorai reke umma ta leleng nge iau keke la leleng kurumea Nutu lonangana.” ");
INSERT INTO mee_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ka panna laeala nae Iesus ke role ka maluame roma, “Kaka meimia aka atu ta launga iau ka resallame ba butume ma iau a agolongkana te? Ka kaeme kinung, na iau ka tattara ba palomatantana ngallo nga tempel, ba miau ka sana ka lau iau. ");
INSERT INTO mee_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ava oru kokorai kinung keke lele ta baina pangamologa ra reke toe Nutu kaona ke pa rea pala nga Lau Ae Nutu Kanna ngeke lele mannangana.” Na barangalele rae Iesus kanna kinung keke kaꞌe ba keke ka. ");
INSERT INTO mee_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Na ra nginngina reke laue Iesus keke loa kia te Kaiapas, a i a piris e kapunu. Ba ra pangalomatanakana nga bangapagame kala nga Iurame ravollalaukerea memena keke katukala kinung nga inaeala bole. ");
INSERT INTO mee_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ba pala, ka ineke lola kae Iesus nae Pita ke lolakurume rea bole, ava ke momo ngatauga nge ri isura. Minmina na i ke loakurume rea ta ke lele nga malle ngallo nga savanau ore nga bale ae piris e kapunu. Na ke taolu lakallo ta malle laeala, ba ke tara kala nga kurtalinglingme nga baina i nge kele taru e la leleng nge Iesus. ");
INSERT INTO mee_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na re kapunu nga pirisme kala nga ra nginngina kinung reke taoamugmuga kae Iurame keke kikiue ra turunggoangakana ta ri atung ta turungpaga Iesus kana. Keke kumkuma minmina ta baina ngeke kalipa ka otte ta turungpaga Iesus kana kia, na ngeke sapune. ");
INSERT INTO mee_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Minmina na ra turunggoangakana papatu keke atu ta pangamologa, ava ri ke sane ke kalipa ka otte ta turungpaga Iesus kana kia. Ava ngarume na pana lua keke atu, ");
INSERT INTO mee_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","na keke role roma, “Agau laekolong ke role roma, ‘Iau ka totorong ta rurunge tempel ae Nutu ba ta kumangngamuni kia ka kaeme ka ri mologi.’” ");
INSERT INTO mee_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Na piris e kapunu ke maisi ba ke ballage Iesus roma, “Ko la alange pangamologa laeala a kanrea, o ke sa? Pangamologa laekia a ra kokorai ke turupaga kang kia ka kaomannmannangana kia, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Avae Iesus ke rulu mana. Na piris e kapunu ke role kia roma, “Iau nga ballaga one nga Nutu e momomauli giana roma: Ngo role kamangng. Ka one ae Mesaia a i ae Nutu Tuna, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nae Iesus ke ale roma, “One muni ko rolea. Ava iau nga role kamiau roma, ngarume na miau kaka la kelange Agau Tuna ine nge tattara nga Nutu a kana ka ginggingame kinung kamana e pe. Ba kaka la kelange ine nge tatupai nga mukmukua reke momo nga tava.” ");
INSERT INTO mee_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Na ka ina piris e kapunu longe pangamologa laeala, na i ke pallamoe lungapaga rae i muni re ngapotu ka iukiangana ba ke role roma, “I ke rolebainga kae Nutu! Ke meimia na ita kaka sissilia ragau palu muni ta ri turupotange agau laekia bainganame? Ngaka kele, miau muni kaka longe gialgiala ine rolebainga kae Nutu. ");
INSERT INTO mee_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ka lomiauvavai mina ngaetai?” Na keke ale roma, “Bainganame keke soali raumana. Ngeke balia na nge mate.” ");
INSERT INTO mee_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Na keke untutaoe raguna, ba keke name kia ka kamareame. Ba palu nge ri keke tavalvale ");
INSERT INTO mee_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ka rolengarea kia roma, “One o roma one ae Karais, onto bai ma agau e toe Nutu kaona, na ngo role kamangng, tai ke tavala one?” ");
INSERT INTO mee_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nae Pita ke tattara ngapotu nga malle e ngallo nga bale laeala kana savanau. Ba malaui te akumangngatulu ke loa te i na ke role kia roma, “One ko momo kala nge Iesus e ngae Galili pala bole.” ");
INSERT INTO mee_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Avae Pita ke kaulikale malaui laeala pangamologangana nga ragau kinung reke mommo nga inaeala ragureame roma, “Iau ka sana laumatana ka taru a one rorole te.” ");
INSERT INTO mee_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ba ngarume, ka inae Pita lelemalaga ta bale laeala kana savanau kaona, na malaui te muni ora kumangngatulu ke kele, na ke role ka ragau reke mommo nga inaeala roma, “Agau laekolong ke momo kala nge Iesus e ngae Nasaret pala.” ");
INSERT INTO mee_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Avae Pita ke kaulikale muni ka patongkalangana ngailu roma, “Iau ka sana laumatana ka agau laeala.” ");
INSERT INTO mee_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ngarume isura, na reke meisinsi nga inaeala keke loa te Pita, na keke role kia roma, “Ka one a agau te e nge ri ka kaomannmannangana ta mangng ka longopatokone kalingngang taningana.” ");
INSERT INTO mee_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nae Pita ke paturu ta kaulingkala ka kaona ginangana ba patongkalangana ngailu roma, “Iau ka sana laumatana ka agau laeala!” Ba ka panna laeala mana, na kukulega te ke toako. ");
INSERT INTO mee_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nae Pita ka lonagaliu ta pangamologa ae Iesus kanna ine role kia pala roma, “Pala ta kukulega toangako, na one ko la kaulingkala iau pa mologi.” Nae Pita ke lelemalaga lagapotu ba ke tani raumana. ");
INSERT INTO mee_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ka sinro luluna, na ragau kinung re kapunu nga pirisme ba ragau reke taoamugmuga ka Iurame ka kanrea pangamologa kena mana ta ri ulonge Iesus ta i mateng. ");
INSERT INTO mee_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Minmina na keke samapite, na keke loa kia ta ulonge nge Pilatus kamana a i e kapunu nga gavaman e ngae Rom nga inaeala. ");
INSERT INTO mee_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na ka inae Iuras, a i a agau e ule Iesus nga reke bai ta baingasoalinge kamareame, ke kele ineke baꞌe Iesus ta i mateng, na i ka lonatantani kurumea lonagaliungana ta kumangngana laeala e pala. Na ke tungugaliue lollokanna nginngina onra siliva ka ri giaukaina ba tangulelu ta re kapunu nga pirisme ba Iurame ravollalaukerea memena ka rolengana kerea roma, ");
INSERT INTO mee_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Iau ka baia bainga e soali nge Nutu raguna kurumea, agau laeala a iau ule nga kamamiaume ke sane baia bainga te e soali.” Ava ri keke ale roma, “Ollaeala ka sana ora kanmangng. Ka ora kaning mana.” ");
INSERT INTO mee_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nae Iuras ke tamali ka lollokanna nginngina lakallo ta tempel. Na ke lao ba ke kone i muni. ");
INSERT INTO mee_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Na re kapunu nga pirisme keke rave lollokanna nginngina onra siliva, na keke role roma, “Lollokanna kokorai ka ri ra kuru ore nga samungpununge agau. Minmina na bangapagame keke parototokala ita ta ulongo rea nga malle e nga pulinglunge lollokanname ngia ngallo nga tempel.” ");
INSERT INTO mee_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Keke role minmina, na ka kanrea pangamologa kena mana ta ri kolinge mogalo inte ka lollokanna nginngina. Ka i a mogalo inte orae agau e kumkuma ka gato ba orume ka mogalo. Ba keke kolia ta nga i a o ore nga talunge ragau re nga maga re ngatauga ngia. ");
INSERT INTO mee_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Minmina na keke patpatoe mogalo inaeala ka Mogalo A Toto ta ke lele ikia e sonrau kurumea, ka i a mogalo eke kolia ka lollokanna ameke tungulu Iesus kana ki. ");
INSERT INTO mee_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Na pangamologa a agau laeala e toe Nutu kaona ae Ieremaia rolea pala ke lele mannangana ine role roma, “Keke rave lollokanna nginngina ra siliva ka ri giaukaina ba tangulelu onra ragau re ngae Israel ke tungulu apanung laeala kana ki, ");
INSERT INTO mee_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","na keke kolia mogalo inte orae agau e kumkuma ka gato ba orume ka mogalo kurumea pangamologa a Avolau rolea pala te iau.” ");
INSERT INTO mee_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nae Iesus ke maisi ngamuga nga gavana raguna, ba gavana ke ballage roma, “Ka one a kelangpatali ae Iurame, o ke sa?” Nae Iesus ke ale roma, “Ke base ino role.” ");
INSERT INTO mee_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ba re kapunu nga pirisme kala nga Iurame ravollalaukerea memena keke turupagpaga Iesus kana, ava i ke sane ala rea. ");
INSERT INTO mee_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Minmina nae Pilatus ke ballage roma, “One ko longlonge oru papatu reke turupagpaga kang ki, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Avae Iesus ke sane ale. Ke sane ale pangamologa inte mana eke turupaga kana kia. Ba ka ina gavana kele ollaeala, na i ke magio raumana. ");
INSERT INTO mee_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na ka pesingmatana re pala nga kaning laeala e bollau, na gavana ke lolakurumea baingana te na ke ulomalaglage apulangkala kena a maluame ke matea te ri. ");
INSERT INTO mee_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ba ka kae laeala na agau te a giana e soali raumana eke patoe kae Barabas ke momo nga pulangkala. ");
INSERT INTO mee_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Minmina na ka ina maluame ke katukala kinung tapu, nae Pilatus ke ballaga rea roma, “Miau kaka matea ta iau ulongmalagange tai te miau? Kaka matea Barabas, o kaka matea Iesus eke patoe kae Karais?” ");
INSERT INTO mee_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatus ke role minmina kurumea, i ka lonamatana roma, ri keke kelalelea Iesus, minmina na keke ule Iesus nga kamana. ");
INSERT INTO mee_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ba bole, pala, ka inae Pilatus tattara nga tarang e nga kalingnana, na napengana ke ba ka pangamologa te i ore role roma, “Sono ngo bai ka otte nga apanung laeala a baingana tupu kurumea, ngalla ka rigo, na iau ka lausoali raumana ina rave minga te i.” ");
INSERT INTO mee_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ava re kapunu nga pirisme bae Iurame ravollalaukerea memena keke pasigipage maluame siareame ta ri balinglagange Pilatus ta i ulongmalagange Barabas ava nge pulia Iesus ta i mateng. ");
INSERT INTO mee_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ava gavana ke ballaga rea roma, “Kaka matea ta iau ulongmalagange tai nge ri pana lua te miau?” Na keke ale roma, “Ngo ulomalage Barabas.” ");
INSERT INTO mee_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nae Pilatus ke ballaga rea roma, “Ava iau nga meimia kae Iesus eke patoe kae Karais?” Na ri kinung keke ale roma, “Ngo katupite nga maiskovu!” ");
INSERT INTO mee_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nae Pilatus ke ballaga rea roma, “Ta ke meimia? I ke kuma ka bainga a taru e soali?” Ava ri keke rereli kaligi raumana muni roma, “Ngo katupite nga maiskovu!” ");
INSERT INTO mee_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ka inae Pilatus kelapatokona roma, ke sane ke la longa te i, ava lavongkala e bollau raumana ke umma ta pangaturu, na i ke rave me inte. Na ke mume kamaname nga maluame ragureame ka rolengana kerea roma, “Apanung laekia totona kengalingngana sana la puna nge iau. Ke sa. Ka la puna nge miau mana!” ");
INSERT INTO mee_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Na ragau nginngina kinung keke ale roma, “Totona nge momo nge mangng ba nga goe rae mangng!” ");
INSERT INTO mee_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Minmina nae Pilatus ke ulomalage Barabas te ri, ava ke role ka ra balingkana ta ri sapinge Iesus. Na ke ule nga kamareame ta ri katungpitange nga maiskovu. ");
INSERT INTO mee_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Na ra balingkana ra gavana kanna keke rave Iesus lakallo ta bale te ora gavaman e ngae Rom. Na ra balingkana kinung re ngae Rom reke momo nga inaeala keke katukala kinung nge i. ");
INSERT INTO mee_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Na keke palale lungapaga rae i, ba keke palupage ka lungapaga e ngapotu ore belveloga. ");
INSERT INTO mee_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Na keke lule oalo a matana ma i a kurung orae kelangpatali te, na keke patutale nga kunna. Ba keke ule bega kalkanna te ma i a to ora kelangpatali te kanna nga kamana e pe. Na keke umma ta parongvanu ngamuga nge i, ba keke rorolepagalising kia roma, “One ae Kelangpatali ae Iurame, ko ngailu raumana!” ");
INSERT INTO mee_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Na keke untutaoe, ba keke rave bega kalkanna laeala na keke paturu ta balinge nga gilina bagana kia. ");
INSERT INTO mee_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ba ngarume, ka ineke rolepagalising kia tapu, na keke palale lungapaga laeala e ngapotu ore belveloga, na keke palupage ka lungapaga rae i muni. Na keke loa kia ta katungpitange nga maiskovu. ");
INSERT INTO mee_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Na ka ineke lelemalaglaga nga maga kunna laeala e bollau, na keke kalipa ka apanung te ore ngae Sairin a giana nge Saimon. Na keke rave ka kaoreaginapitangana kia ta i paunge maiskovu ae Iesus. ");
INSERT INTO mee_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ba ka ineke lele nga malle te eke patoe kae Golgota, a mirana roma Malle A Agau Gilina Bagana, ");
INSERT INTO mee_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","na keke tunge uain eke kampiliue kala nga oru e mamaoga te Iesus. Ava ke ine kanimaia, na ka sana omona ta i inunge. ");
INSERT INTO mee_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ba ka ineke katupite nga maiskovu tapu, na keke kintoto ta tavoanga ka lungapaga rae i ngaliua nge ri muni. ");
INSERT INTO mee_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Na keke tattara, ba keke kelalelepatantalia nga inaeala. ");
INSERT INTO mee_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ba keke ule pangamologa eke turupaga Iesus kana kia nga maiskovu ngailu nga kunna ore role roma: ");
INSERT INTO mee_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ba keke katupite ra golongkana lua nga maiskovume ka kae laeala bole. Keke katupite te nga maiskovu e momo nga Iesus kamana e pe, ba keke katupite te nga maiskovu nga Iesus kamana a laeva. ");
INSERT INTO mee_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ba ragau reke kavesillelea inaeala keke rorolebainga kia. Keke lulumatagtage kunreame te i, ");
INSERT INTO mee_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ba keke rorole kia roma, “One amo role roma, one la rurunge tempel ba kumangngamuni kia ka kaeme ka ri mologi, onto ravulele one muni! Ngaroma one ae Nutu Tuna, na ngo atupisigi nga maiskovu!” ");
INSERT INTO mee_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ba re kapunu nga pirisme kala nga ra pangalomatanakana nga bangapagame ba Iurame ravollalaukerea memena keke umma minmina bole ka rolengpagalising ngareangana kia roma, ");
INSERT INTO mee_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“I ke ravulelea ragau pattoto, ava ka sana likina ta ravunglelenge i muni. Ka i a Kelangpatali ore ngae Israel. Minmina na i nge atupisigi nga maiskovu gialgiala, na ita ka la lorapatokona te i. ");
INSERT INTO mee_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“I ka lonapatokona te Nutu. Ngaroma Nutu nga lonasereng kia, na i nge ravulelea ta i muni ke role roma, ‘Ka iau ae Nutu Tuna.’” ");
INSERT INTO mee_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ba ra golongkana nginngina onreke katupita rea nga maiskovume kala nge i keke rorolebainga kia ka rolengbainga kena laeala. ");
INSERT INTO mee_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na paturu nga pula ta ke lele nga kae matana a mologi ka laio, na osuguna ke gasipite inaeala bavakena. ");
INSERT INTO mee_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ba ka kae matana basema kae matana a mologi ka laio, nae Iesus ke kiu kaligi roma, “Eli, Eli, lama sabaktani?”, a mirana roma, “Nutu ae iau, Nutu ae iau, ko maimia o ka iau?” ");
INSERT INTO mee_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Na ka ina palu re nga ra nginngina reke meisinsi nga inaeala ke longe Iesus pangamologangana laeala, na keke role roma, “Apanung laeala ke kikiu te Ilaia.” ");
INSERT INTO mee_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Na te i nge ri ke pira bolvole, na ke rave otte ba ke parume uain e mamaoga kia. Ba ka ina ollaeala ponu ka uain tapu, na i ke paupite nga bega kamana te ba ke kalapataea lakailu te Iesus ta i inunge. ");
INSERT INTO mee_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ava pattoto nge ri keke role roma, “Ita ngaka kelapita roma, Ilaia ke la atung ta ravunglelenge, o ke sa.” ");
INSERT INTO mee_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nae Iesus ke kiu kaligi muni, na ke ngata ta kannuna kange mirana. ");
INSERT INTO mee_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ba ka panna laeala mana, na malo laeala e bollau eke kone ma i a lengakala ngallo nga tempel ke marae ka rina lua ngailu bavakena ta ina e ngape. Ba mogalo laekia e ngape ke mataga, ba lollo reke bollalau keke mapala. ");
INSERT INTO mee_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ba baveng onreke talue reke mate ngi keke pulapatali, na ragau papatu rae Nutu reke tupu onreke mate pala mirareame keke sigipaga. ");
INSERT INTO mee_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ba ngarume nga Iesus sigingpagangana nga mateng, na keke lelemalaga nga baveng nginngina onreke talu rea ngi. Na keke lu ta maga kunna laeala e bollau ore tupu. Ba ragau papatu keke kela rea. ");
INSERT INTO mee_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ka ina abalingkana e ngae Rom ba ra nginngina reke momo kala nge i ta kelangalelepatali te Iesus keke kele oru giongana ba oru reke umma ta leleng, na keke matau raumana. Ba keke role roma, “Agau laekia ka i a Nutu Tuna ka kaomannmannangana!” ");
INSERT INTO mee_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ba ravale papatu keke momo nga inaeala bole. Keke meisinsi ngatauga isuru ba keke elle oru nginngina reke lele. Ka ri ra ravale reke atukurumea Iesus ine kaꞌe Galili be atu tae Ierusalem. Keke atukurumea ta baina ngeke kalaue ka orume. ");
INSERT INTO mee_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Te e nge ri ka i ae Maria Magaralene, ba te ka i ae Maria a i ae Iems riluae Iosep nareame, ba te ka i Sepeti tuna memena nareame. ");
INSERT INTO mee_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ka laio ina kae matana barelulu, na apanung te a kilipukana ore ngae Arimatea a giana nge Iosep ke atu. Ka i a agau ore lele i a barangalele te ae Iesus kanna pala bole. ");
INSERT INTO mee_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Apanung laeala ke loa te Pilatus, na ke palonge ta i ravunge Iesus lavusakia. Nae Pilatus ke bapage ra balingkana ta ri tunge Iesus lavusakia te Iosep. ");
INSERT INTO mee_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nae Iosep ke rave, ba ke lulupite ka malo te ore lelle. ");
INSERT INTO mee_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Na ke pakenoe ngallo nga baveng a pau ae i muni ore nga talunge agau e mate ngia. Ka i a baveng ore sane ke pulluia lavusa te ngia pala a ri ke kuma kia lakallo nga lollo. Ka ine pakenoe Iesus lavusakia ngallo nga baveng laeala tapu, na i ke patate lollo e bollau ta patangapite baveng kaona kia. Na ke lao. ");
INSERT INTO mee_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Bae Maria Magaralene kala nga Maria laeala a i ae Iems riluae Iosep nareame keke momo nga inaeala bole. Keke tattara kokoro ta malle laeala eke pulluia lavusa ngia. ");
INSERT INTO mee_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Me ngangaila, ka kae e ngarume nga kae orae Iurame nga kalingtupunge oru re nga kae a Sabat, na re kapunu nga pirisme bae Parisiome keke loa te Pilatus. ");
INSERT INTO mee_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Na keke role kia roma, “Avolau, mangng ka lomangnggaliu roma, ka ine momo mauli tale, na agoangakana laeala ke role roma, ‘Ngarume nga kaeme ka ri mologi, na iau ka la sigingpaga muni.’ ");
INSERT INTO mee_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Minmina na one ngo role ka ragau ra kaning ta ri pulangkalamasinge malle laeala eke pulluia lavusa ngia ta nge loa te nge lele nga kae a mologi ngarume. Ngo kuma minmina ta baina barangalele ra kanna sane ngeke loa na ngeke golopatali kia ba ngeke role ka ragau roma, ‘I ke sigipaga nga mateng.’ Ngaroma ri ngeke kuma minmina, na goanga laeala e ngarume ke la bolinglaunga muni nga goanga laeala e pala ine patoe i muni kae Mesaia ae Nutu.” ");
INSERT INTO mee_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nae Pilatus ke role kerea roma, “Miau ngaka rave ra balingkana palu, na ngaka loa ba ngaka kuma ka orume kinung ra miau lomiaumatana ki ta pulangkalamasinge malle laeala.” ");
INSERT INTO mee_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ka baina keke loa, na keke pulakalamasia baveng laeala ka ulongareangana ka killa te nga lollo e patapite kaona. Killa laeala ke parototokale agau te ta i nga manenasa pulangpatalia malle laeala. Ba keke ule ra balingkana palu ta ri kelangalelepatali ta malle laeala bole. ");
INSERT INTO mee_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Na ka ina kae a Sabat rongo tapu ba kae ke paturu ta magolung ka kae e kapunu nga kumangng maina laeala, nae Maria Magaralene kala nga Maria laeala a i ae Iems riluae Iosep nareame keke loa ta ri kelange malle laeala eke pullue Iesus ngia. ");
INSERT INTO mee_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Na oru giongana tane bollau ke lele ina anggelo te orae Nutu kanna sopisigi nga tava, na ke loa ba ke patalele patali ka lollo laeala e bollau. Na ke tarapai ngia. ");
INSERT INTO mee_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ba anggelo laeala sinna ka tongana kena ma saia ine killama. Ba lungapaga ae i ke kavauvaunga raumana. ");
INSERT INTO mee_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ba ra balingkana nginngina reke kelalelepatantali ta malle laeala keke mammalu ka mataungareangana kia, na keke lele ma ragau reke mate. ");
INSERT INTO mee_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ava anggelo laeala ke role ka ravale lua nginngina roma, “Sana ngaka matau kurumea, iau ka laumatana roma, onemea kaka atu ta kelanga te Iesus orame ke katupite nga maiskovu. ");
INSERT INTO mee_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","I ke sane momo ikia. Ke sigipaga tapu kurumea pangamologa a i rolea pala. Ngaka atu, na ngaka kele malle laeala a i keno ngia pala. ");
INSERT INTO mee_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na ngaka loa bolvole ba ngaka turu paka barangalele ra kanna roma, ‘I ke sigipaga nga mateng tapu, na iale lola pala nge miau lakallo tae Galili. Kaka la kelange nga inaeala.’” Na anggelo laeala ke role ka ravale lua nginngina roma, “Iala mana. Iau ka turu te onemea tapu.” ");
INSERT INTO mee_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ka baina ravale nginngina keke kutapu bolvole eke kaꞌe baveng laeala ka mataungarea ba loreasereng ngareangana e bollau raumana. Na keke pira ta turung paka barangalele rae Iesus kanna. ");
INSERT INTO mee_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ka ineke pirpira na ka pannasa mana nae Iesus ke kalipa kerea nga pamau ba ke sinro kerea. Na keke loa te i na keke kapite nga kaena puname, ba keke kalapagpage. ");
INSERT INTO mee_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nae Iesus ke role kerea roma, “Sana ngaka matau. Ngaka loa, na ngaka role ka kolingau memena ta ri loanga tae Galili. Na keke la kelanga iau nga inaeala.” ");
INSERT INTO mee_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ka ina ravale nginngina ke lola tale, na ra balingkana palu ramreke kelalelepatali ta baveng keke loalu lakallo ta maga kunna laeala e bollau, na keke ture orume kinung reke lele ta re kapunu nga pirisme. ");
INSERT INTO mee_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ba ka ina re kapunu nga pirisme bae Iurame ravollalaukerea memena ke katukala kinung ba keke palipotopita tapu, na keke tunge lollokanna papatu ta ra balingkana nginngina ");
INSERT INTO mee_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ka rolengarea kerea roma, “Miau ngaka role roma, ‘Barangalele ra kanna keke atu ka rigo, na keke golopatali kia ina mangng ka kenrau.’ ");
INSERT INTO mee_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ba ngaroma gavana nge longe pangamologa laeala, na mangng nga patupe pangamologa kala nge i ta baina i sane nge tunge alang e soali te miau.” ");
INSERT INTO mee_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ka baina ra balingkana nginngina keke rave lollokanna nginngina, na keke kuma kurumea reke taoamugmuga kae Iurame pangamologangarea te ri. Na pangamologa laeala ke sasa ta iname kalaoveka ngaliua nga Iurame, ba ke tatu ta ke tatu ta ke lele ka kae laekia e sonrau. ");
INSERT INTO mee_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na barangalele rae Iesus kanna ka ri tangulelu ba kena keke loa tae Galili ta kapangng laeala ae Iesus role kerea ta ri loanga te. ");
INSERT INTO mee_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ba ka ineke kele Iesus, na keke kalapage. Ava palu nge ri ka lorea lualua. ");
INSERT INTO mee_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nae Iesus ke loa te ri, na ke role kerea roma, “Nutu ke tunge gia bolinglaungana te iau ta iau kelangpatali ta orume kinung re nga Nutu mallena nga tava ba re nga mogalo laekia e ngape. ");
INSERT INTO mee_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Minmina na miau ngaka loa, na ngaka bai ka ragau re nga iname kinung ta ri leleng ra barangalele ra kanau. Ba ngaka pamagoe rea nga Tamau giana ba nga Tuna giana ba nga Kannu E Tupu giana. ");
INSERT INTO mee_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ba ngaka palomatana rea ta ri loangakurumea orume kinung ra iau bapaga miau ki. Ba iau nga role kamiau ka kaomannmannangana roma, iau ka la momong kala nge miau passavele. Ka la momong kala nge miau ta nge lele nga kae a ronga.” ");
INSERT INTO mee_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Pangamologa laekia ka i a pangamologa e pe e te Iesus Karais a i ae Nutu Tuna. ");
INSERT INTO mee_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Pala na agau e toe Nutu kaona a giana nge Aisaia ke paꞌe Nutu pangamologangana e te Tuna ore role roma, “Ngo kele. Iau ka la bange agau e loa ka pangamologa a kanau, na i ke la loanga pala nge one ta kalingtupunge pamau ae one.” ");
INSERT INTO mee_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Agau te kalingngana ke kurkura ngallo nga ina a sana ragau ngia roma, ‘Ngaka kalitupe pamau ae Avolau, ba ngaka patupe pamaume ta i taonga ngi.’” ");
INSERT INTO mee_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Minmina nae Ion ke lele, na ke pamagoegoea ragau ngallo nga ina a sana ragau ngia. Ba ke pulimalaglage pangamologa e ta pangamagoe te ri ore role roma, ngaroma ri ngeke pulivalakale baingarea reke sosoali, nae Nutu nge osurure baingarea nginngina reke sosoali. ");
INSERT INTO mee_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ka baina ragau re nga iname kinung ngallo ngae Iurea, ba ragau kinung re ngae Ierusalem keke lelemalaglaga ba keke lola te Ion. Na keke umma ta turungnanange baingarea reke sosoali nge Nutu raguna, bae Ion ke pamagoegoe rea nga Me Ae Ioran. ");
INSERT INTO mee_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Bae Ion ke lupage lungapaga eke kuma kia ka posi a kamele bulvunna, ba ka kana ka ligongpita a bulmakau patuna nga luana. Ba sisime ba miso a pinolo ka ri ra kaning rae i. ");
INSERT INTO mee_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ba i ke pulimalaglage pangamologa roma, “Ngarume nge iau na agau te ke la atung ba i ka i ngailu nge iau. Ba ka sana iau a agau te mannangana ta iau nga magolo na nga pole oalo nge nga kesingsilagi ngae i. ");
INSERT INTO mee_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Iau ka pamagoegoe miau ka me mana, ava i ke la pangamagoe miau kae Kannu E Tupu.” ");
INSERT INTO mee_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ka kae nginngina nae Iesus ke kaꞌe Nasaret ngallo ngae Galili, na ke loa te Ion. Nae Ion ke pamagoea nga Me Ae Ioran. ");
INSERT INTO mee_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na ka inae Iesus kaꞌe me ave lolele, na ke kele tava ine sagitoto, nae Kannu E Tupu ke lomaling te i basema manu a kulao. ");
INSERT INTO mee_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na kaling te ke pa nga Nutu mallena nga tava, na ke role roma, “Ka one ae Tugu a iau materaumana one. Ba ka laupe kone raumana.” ");
INSERT INTO mee_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Na ka pannasa nae Kannu E Tupu ke baꞌe Iesus ta i loangamalaga ta ina a sana ragau ngia. ");
INSERT INTO mee_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Na i ke mommo nga inaeala ka kaeme ka ri giaukaina lua, bae Satan ke amve. Ke mommo kala nga posi ra pinolo, ba anggelome keke ella te i. ");
INSERT INTO mee_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ka ina re ngae Rom ke pulakale Ion nga pulakala tapu, nae Iesus ke loalu lakallo tae Galili ba ke pulimalaglage pangamologa e pe ae Nutu kanna. ");
INSERT INTO mee_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Na ke rorole roma, “Kae ae Nutu pulia pala ikia e lele tapu bae Nutu kelangpatalingana ke lele kokoro. Minmina na miau ngaka pulivalakale baingamiau reke sosoali nge Nutu raguna, na nga lomiaupatokona ta pangamologa e pe e ta Nutu kelangpatalingana.” ");
INSERT INTO mee_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ka inae Iesus tatao nga Sivoli Ae Galili kaona, na i ke kele Saimon kala nga teiteikia ae Anru ka ineke tantamali ka po nga sivoli, ta ka ri ra maengekana. ");
INSERT INTO mee_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Nae Iesus ke role kerea roma, “Onemea ngaka atu kurume iau, na nga bai ka miau ta miau ra maengekana reke raravu ragau.” ");
INSERT INTO mee_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na ka panna laeala mana na ri keke kaꞌe pome ba keke loa kurumea Iesus. ");
INSERT INTO mee_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ka ine tao lagamuga muni nga inaeala, na ke kele Iems a i ae Sepeti tuna bae teiteikia ae Ion nga manang kala nga tamarea ineke saisaia pome. ");
INSERT INTO mee_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Na ka pannasa mana nae Iesus ke kiu rea. Na keke kaꞌe tamarea ae Sepeti nga manang kala nga ra kumangngatulu ra i kolkoli rea, na keke loa kurumea Iesus. ");
INSERT INTO mee_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Na ri keke loalu ta maga kunna e bollau ae Kaperneam. Ba ka ina kae a Sabat lele, nae Iesus ke lu lakallo ta sinagog ba ke paturu ta pangalomatanange ragau reke momo nga inaeala. ");
INSERT INTO mee_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ba ka ineke longe pangalomatana ra kanna, na ri keke kallo raumana kurumea, Iesus ke sane palomatantana rea ma ra pangalomatanakana nga bangapagame. Ke sa. I ke palomatantana rea ma agau a kana ka gingginga mannangana. ");
INSERT INTO mee_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ka kae laeala na agau te ora kannu e soali lupage ke mommo ngallo nga sinagog ae ri, ba i ke reli ka rolengana roma, ");
INSERT INTO mee_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Aekolong ae Iesus e ngae Nasaret! Ko bai ta maingamia ka mangng? Ko atu ta baingasoali mangng? Ka laumatana kone, ka one a agau e tupu orae Nutu baꞌe.” ");
INSERT INTO mee_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Avae Iesus ke sanggipite roma, “Rulu! Kaꞌe aekolong bo lelemalagapatalia!” ");
INSERT INTO mee_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na kannu laeala e soali ke lulumatage agau laeala kaligi, na ke lelemalagapatalia ka relingana. ");
INSERT INTO mee_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ba ragau kinung reke kele ollaeala keke kallo, na keke palibalaglaga rea roma, “Tar ikia? Ka i a pangalomatana a pau ora kana ka gingginga raumana! I ke bapage kannu reke sosoali, na keke longo te i mana.” ");
INSERT INTO mee_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Minmina nae Iesus kana turung ke loa bolvole ta iname kinung reke momo ngallo ngae Galili. ");
INSERT INTO mee_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ka ineke lelemalaga nga sinagog tapu, na ka panna laeala mana, na keke loa kala nge Iems bae Ion, na keke lu lakallo ta bale ae Saimon riluae Anru. ");
INSERT INTO mee_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nae Saimon lonapengana ke enno ka soaling a mira isongpangana. Ba keke turu pakae Iesus ta avale laeala. ");
INSERT INTO mee_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ka bainae Iesus ke loa te i, na ke rapite nga kamana ba ke kalaue ta i sigingpaga. Na mira isongpangana ke kaꞌe, ba i ke silae rea. ");
INSERT INTO mee_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ka laio, ka ina kae barelu tapu, na keke atu ka ragau kinung ra karea soaling ba ragau ra kannu reke sosoali ke lupaga rea te Iesus. ");
INSERT INTO mee_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ba ragau kinung re nga maga kunna laeala e bollau keke katukala nga bale laeala kaona. ");
INSERT INTO mee_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nae Iesus ke papea ragau papatu ra karea soaling matantana, ba ke taomalage kannu papatu reke sosoali nga ragau. Ba kannu nginngina reke sosoali ka loreamatana roma, Iesus ka i a tai. Minmina na i ke parototokala rea ta ri nga manereasa pangamologa. ");
INSERT INTO mee_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ka sinro luluna ka ina osuguna tale, nae Iesus ke sigipaga e kaꞌe bale, na ke loa ta inte ta i momong mana me i. Ba ke kavkava te Nutu nga inaeala. ");
INSERT INTO mee_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nae Saimon kala nga balingana memena keke sissilia. ");
INSERT INTO mee_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ba ka ineke kalipa kia, na keke role kia roma, “Ragau kinung keke sissili one.” ");
INSERT INTO mee_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nae Iesus ke ala rea roma, “Ita ngaka loa ta inte toto—ta maga reke momo kokoro ta baina iau nga pulimalage pangamologa nga maga nginngina bole. Ta iau ka atu ta kumangng ka kumangng laeala.” ");
INSERT INTO mee_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Minmina na i ke tao ta iname kinung ngallo ngae Galili, ba ke pulimalaglage pangamologa nga sinagog rae ri. Ba ke taomalaglage kannu reke sosoali nga ragau. ");
INSERT INTO mee_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Na agau te a kana ka soaling a kalangamugmugu ke atu te Iesus, na i ke pupu ka banungkiame ngamuga nge Iesus ba ke tanikale roma, “Ngaroma nga longangana, na one ka kanga ka gingginga ta pangalellepa iau.” ");
INSERT INTO mee_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nae Iesus ka lonananne raumana. Minmina na i ke kalaꞌe kamana ba ke kali kia, na ke role kia roma, “Ka laungana. Ka palellepa one.” ");
INSERT INTO mee_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ba ka panna laeala mana, na soaling a kalangamugmugu ke kaꞌe ba mirana ke lelle. ");
INSERT INTO mee_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nae Iesus ke baꞌe ta i loanga bolvole ka pangamologangana e gingging te i roma, ");
INSERT INTO mee_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Sono ngo ture ollaekia e lele nge one ta agau te, ava ngo loa na ngo pakosining kone ta piris. Na ngo tunge tunga e nga mirang pengana base inae Moses bapage ragau re pala. Ngo kuma minmina ta baina ragau nga loreamatana roma, soaling ae one ke rongo tapu.” ");
INSERT INTO mee_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ava agau laeala ke sane longo te Iesus. Ke sa. I ke loa, na ke paturu ta turunge ollaeala e lele nge i ta ragau karolu re nga iname kalaoveka. Minmina nae Iesus ke sane totorong ta i taongalu ta maga kunna te e bollau nga ragau ragureame muni. Ke sa. Ke mommo ngapotu nga ina ra ragau ke sane momo ngi. Ba ragau keke pa nga iname kinung, na keke tatu te i. ");
INSERT INTO mee_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ka kae palu ngarume nga oru nginngina ka inae Iesus loalu muni tae Kaperneam, na ragau keke longe ine momo nga bale ae i. ");
INSERT INTO mee_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Na ragau papatu raumana keke katukala kinung. Minmina na ka sana malle te bavakena. Ka sana malle te kokoro ta bale kaona bole. Bae Iesus ke pulimalaglage pangamologa rae Nutu kanna te ri. ");
INSERT INTO mee_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Na rapanung ka ri tugulu reke paue agau a giname ke mate keke atu, ba keke bai ta loanga kia te Iesus. ");
INSERT INTO mee_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ava ragau keke ponu raumana. Minmina na ke sane ke totorong ta ri loanga ka agau laeala kokoro te Iesus. Ka baina keke loapatae lakailu ta bale kunna ine karapap. Na keke rusulage bale kunna inte e ngailu nge Iesus. Ba ka ineke kalalage inaeala tapu, na keke toatape nia a agau a giname ke mate kenopai ngia lagape. ");
INSERT INTO mee_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Na ka inae Iesus kele lopatokona ae ri, na i ke role ka agau laeala a giname ke mate roma, “Tugu, iau ka osurure baingang reke sosoali.” ");
INSERT INTO mee_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ava ka ra pangalomatanakana palu nga bangapagame ke tattara nga inaeala, ba ri ka loreagomgome ngallo nga loreame roma, ");
INSERT INTO mee_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ke meimia na agau laekia ke role minmina? I ke rorolebainga kae Nutu. Ka sana agau te kana ka gingginga ta i osungrurunge bainga reke sosoali. Ke sa. Nutu kasikena mana.” ");
INSERT INTO mee_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Na ka pannasa mana, nae Iesus ka lonamatana ngallo nga kannuna ka ina ri loreavavai minmina ngallo nge ri muni. Minmina na i ke role kerea roma, “Kaka meimia aka kumkuma ka lovainganame ta oru kokorai ngallo nga lomiaume? ");
INSERT INTO mee_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Pangamologa a taru nge ate ta iau roleng ka agau laekia a giname ke mate? Ngaroma iau nga role kia roma, ‘Aekolong, iau ka osurure baingang reke sosoali,’ o ngaroma iau nga role kia roma, ‘Sigipaga, ngo rave nia ae one na ngo tao’. Te miau sonrau, nga pangamologa lua nginngina na taru ke ate ta iau rolenge? ");
INSERT INTO mee_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ava iau ka bai ta miau lomiaumatanangana roma, Agau Tuna ka kana ka gingginga nga mogalo laekia e ngape ta i osungrurunge ragau baingarea reke sosoali.” Minmina nae Iesus ke role ka agau laeala a giname ke mate roma, ");
INSERT INTO mee_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Iau nga role pakone roma, ngo sigipaga, na ngo rave nia ae one ba ngo loa te one ta bale.” ");
INSERT INTO mee_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na ka pannasa mana, na agau laeala a giname ke mate ke sigipaga na ke rave nia, ba ke lelemalaga nga ragau kinung reke momo nga inaeala ragureame. Minmina na ri kinung keke kallo ba keke kinpataetaea Nutu giana ka rolengarea roma, “Ita ka sana ka kele otte minakai ka kae te.” ");
INSERT INTO mee_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ngarume nae Iesus ke lelemalaga nga maga kunna e bollau ba ke tatao muni nga me a sivoli kaona. Na malua e bollau ke loa te i, ba i ke palomatantana rea. ");
INSERT INTO mee_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ka ine tatao e lola, na i ke kele Livai a i ae Alpaeus tuna ine tattara nga malle e nga ravungkinunge takisme. Na ke role kia roma, “Ngo atukurume iau.” Nae Livai ke sigipaga, na ke loa kurumea Iesus. ");
INSERT INTO mee_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ba ngarume, ka inae Iesus tattara ta kaning nga bale ae Livai, na ragau papatu reke raravukinunge takisme ba ragau papatu ra Iurame ke patpato rea ka “ra baingareame ke sosoali” keke tattara ta kaning kala nge i ba barangalele ra kanna. Keke tattara kala nge i kurumea, papatu nga ragau matana nginngina keke tataokurumea. ");
INSERT INTO mee_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na ka ina ra pangalomatanakana nga bangapagame ba Parisiome ke kele Iesus ine kaninni kala nga ragau nginngina reke patpato rea ka “ra baingareame ke sosoali” ba ragau reke raravukinunge takisme, na keke ballage barangalele rae Iesus kanna roma, “Ke meimia na ke kaninni ba ke innu kala nga ragau reke raravukinunge takisme ba ragau ra baingareame ke sosoali?” ");
INSERT INTO mee_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ka inae Iesus longe pangamologa laeala, na i ke role kerea roma, “Ragau ra sana karea soaling ke sane ke lola ta apangapemirakana. Ke sa. Ragau ra karea ka soaling mana keke lola. Iau ka sana atu ta kiunge ragau ra baingareame ke tupu. Ke sa. Ka atu ta kiunge ragau ra baingareame ke sosoali.” ");
INSERT INTO mee_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Na barangalele rae Ion kanna ba Parisiome keke kuriri ta kaning. Minmina na ragau palu keke atu te Iesus na keke ballage roma, “Ke meimia na barangalele rae Ion kanna ba Parisiome keke kuriri ta kaning, ava barangalele ra kaning ke sane ke kuriri ta kaning?” ");
INSERT INTO mee_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nae Iesus ke ala rea roma, “Ka ina apanung e bai ta kamangpitakama momo kala nge ri tale, na ragau reke maispage apanung laeala ka kae e nga palingravung keke kuriri ta kaning, o ke sa? Ke sa. Ke sane ke kuriri ta kaning ka ina apanung laeala e bai ta kamangpitakama momo kala nge ri tale. ");
INSERT INTO mee_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ava kae te ke la atung nga ineke la ravungpatali ka apanung e bai ta kamangpitakama nge ri, ba nga kae laeala na ri keke la kuringa ta kaning. ");
INSERT INTO mee_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ka sana agau te nge saipite malo ine rara nga lungapaga e putputung. Ngaroma i nge kuma minmina na ne rara ke la maraengapatali nga ne putputung, na maraenga e momo pala ke la bolinglaunga muni. ");
INSERT INTO mee_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ba ka sana agau te nge pullue uain a pau nga uain bagana ra kasana. Ngaroma i nge kuma minmina na uain a pau nge poagolue uain bagana nginngina onreke kuma ki ka meme patuna, na uain nge sanrea. Ba uain patuname keke la soaling bole. Ava i ke sane la kumangng minmina. Ke sa. I ke la pulinglunge uain a pau nga uain patuna ra pau.” ");
INSERT INTO mee_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ka kae te a i a kae a Sabat, nae Iesus ke tataopale ura re nga pailli matana eke patoe ka “giren”. Ba ka ina barangalele ra kanna ke tatao eke lola, na keke umma ta utungtotonge giren kunna palu. ");
INSERT INTO mee_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Minmina nae Parisiome keke ballage Iesus roma, “Ngo kele. Ke meimia na keke kumkuma ka ore parototokala ka kae a Sabat?” ");
INSERT INTO mee_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nae Iesus ke ala rea roma, “Miau ka sana ka kele pangamologa laeala eke paꞌe pala ore ta Revit kumangngana ine moro ta kaning ba i kala nga ra balingkana rae i matekarea ae? ");
INSERT INTO mee_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ka kae re pala inae Abiatar ka i a piris e kapunu, nae Revit ke loalu lakallo ta bale ae Nutu na ke rave beret laeala ore ta tungnge te Nutu, na ke kania. Ava ke parototokala ta agau te mana kaninge beret laeala. Kana ka pirisme mana. Bae Revit ke tungu ra balingkana rae i karea bole.” ");
INSERT INTO mee_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nae Iesus ke role kerea roma, “Nutu ke pulia kae a Sabat ta kalaunge ragau. Ke sane koipage ragau ta kalaunge kae a Sabat. ");
INSERT INTO mee_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Minmina nae Agau Tuna ka i a Avolau e nga kae a Sabat bole.” ");
INSERT INTO mee_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ngarume, ka kae a Sabat tetoto, nae Iesus ke loalu lakallo ta sinagog ba agau te ke momo nga inaeala ora kamana mate. ");
INSERT INTO mee_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ba palu nga ragau reke momo ka kae laeala keke sissilia pamau ta ri turungpaga Iesus kana. Minmina na keke ella te i roma, “Aekia ke la i pangapenge agau laeala ka kae laekia e nga pannang, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nae Iesus ke role ka agau laeala a kamana mate roma, “Ngo atu bo maisi ngamuga nga ragau.” ");
INSERT INTO mee_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nae Iesus ke ballage ragau reke momo roma, “Bangapagame keke parototokala ita ta kumangng ka bainga a taru ka kae a Sabat? Keke parototokala ita ta kumangng ka bainga e pe o ta kumangng ka bainga e soali, ta ravunglelenge agau maulingngana o ta samungpununge?” Ava reke momo ke sane ke ale. Ke sa. Keke rulu mana. ");
INSERT INTO mee_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nae Iesus ke kelataliu te ri ka iukiangana ba i ka lonatani kurumea, loreame keke rutu raumana. Na ke role ka agau laeala roma, “Ngo kalaꞌe kamang.” Na agau laeala ke kalaꞌe kamana, ba kamana ke pe muni. ");
INSERT INTO mee_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nae Parisiome keke lelemalaga nga sinagog ba keke paturu ta potongpita kala nga ragau palu reke pato rea kae Erotome ta kalingpa ka pamau ta ri samungpununge Iesus. ");
INSERT INTO mee_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nae Iesus ke kutapu kala nga barangalele ra kanna ta me a sivoli, ba malua e bollau e ngae Galili ke loakurumea. ");
INSERT INTO mee_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ka ina ragau ke longe kumangng rae Iesus kumkuma ki, na papatu re ngae Iurea, bae Ierusalem, bae Irumea, ba re nga ina reke momo nga Me Ae Ioran bavana tetoto, ba re ngae ina reke momo kokoro tae Taia bae Sairon keke loa te i. ");
INSERT INTO mee_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Na ragau nginngina reke momo nga inaeala kala nge i ka ri papatu raumana. Minmina na i ke role ka barangalele ra kanna ta ri kalingpa ka manang te ta baina i nge taepatae ngia ngaroma ragau ngeke pavivia raumana. ");
INSERT INTO mee_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iesus ke role kerea minmina kurumea, pala na i ke papea ragau papatu. Minmina na ragau kinung ra karea ka soalingme keke pavivitaliue ta baina ri ngeke kali kia. ");
INSERT INTO mee_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ba nga ina kannu reke sosoali nge kele, na keke la pupungapisigi ngamuga nge i ka relingarea roma, “Ka one ae Nutu Tuna.” ");
INSERT INTO mee_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Avae Iesus ke tunge pangamologa e gingging te ri ta ri nga manereasa turunge ta ragau roma, ka i a tai. ");
INSERT INTO mee_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ngarume nae Iesus ke loapatae ta kapangng, na ke kiue ragau palu ra i toro rea, na keke loa te i. ");
INSERT INTO mee_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Na i ke pulia pana tangulelu ba lua ta ri ra aposelme ta baina ri ngeke momo kala nge i. Ke puli rea ta baina i nge bamalaga rea ta ri pulingmalagange pangamologa, ");
INSERT INTO mee_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ba nga karea gingginga ta taongamalagange kannu reke sosoali nga ragau. ");
INSERT INTO mee_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ke pulia pana tangulelu ba lua ra giareame nge: Saimon (orae Iesus patoe kae Pita); ");
INSERT INTO mee_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","bae Iems a i ae Sepeti tuna, bae Ion a i ae Iems teiteikia (ka ri ra pana lua nginngina ra koli onrae Iesus pato rea kae Boanerges a mirana roma “Ragau ra tongarea kena ma saia ruruna”); ");
INSERT INTO mee_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ba ke pulia Anru, bae Pilip, bae Bartolomiu, bae Matiu, bae Tomas, bae Iems a i ae Alpaeus tuna, bae Tarius, bae Saimon tetoto eke patoe kae “Selot”; ");
INSERT INTO mee_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","bae Iuras Iskariot a i a agau laeala e la ulonge Iesus nga reke bai ta baingasoalinge kamareame bole. ");
INSERT INTO mee_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nae Iesus ke loalu ta bale te, ba ragau papatu keke katukala muni te i. Minmina na i kala nga barangalele ra kanna ka sana karea panna inte ta ri kaning. ");
INSERT INTO mee_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ba ka ina rakia memena ke longe ollaeala, na keke loa ta ravunggaliunge ta maga kurumea, keke rorole roma, “I ke baigaugau.” ");
INSERT INTO mee_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ba ra pangalomatanakana nga bangapagame onreke atupisigi ngae Ierusalem keke rorole roma, “Beelsebul ke lupage,” ba “i ke taomalaglage kannu reke sosoali ka kannu reke sosoali kelangpatali ae ri ginggingngana mana.” ");
INSERT INTO mee_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ka bainae Iesus ke kiu rea te i, na ke role kerea ka pangateningkalame roma: “Satan ka kana ka gingginga ta taongamalagange Satan mina ngaetai? ");
INSERT INTO mee_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ba ngaroma ragau reke momo ngape nga kelangpatali te ngeke palikalipala rea muni, na agau laeala kelangpatalingana ke sane la meising. ");
INSERT INTO mee_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ba ngaroma ragau re nga balekaina te ngeke palikalipala rea muni, na balekaina laeala ka sana la kana ka gingginga ta i meising. ");
INSERT INTO mee_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ba ngaroma Satan nge sanangkalkale i muni ba nge kalipalpale i muni, na i ka sana la kana ka gingginga ta i meising. Ke sa. Ale rongo tapu. ");
INSERT INTO mee_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ava ka sana agau te totorong ta i taongalu ta bale ae agau a likina raumana basema Beelsebul ba ta kangamana ka oru nga kanna. Ke sa. I nge samapite agau laeala a likina raumana pala, na ngarume na i nge taolu ba nge ka ka orume kinung reke momo nga bale ae i. ");
INSERT INTO mee_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Iau nga role kamiau ka kaomannmannangana roma, Nutu ke la osungrurunge bainga reke sosoali kinung ba pangamologame kinung ra ragau ke rolebainga kae Nutu ki. ");
INSERT INTO mee_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ava ngaroma agau te nge rolebainga kae Kannu ae Nutu, nae Nutu ke sane la osungrurunge bainga laeala e soali. Ke sa. Agau laeala ke kuma ka bainga e soali ore la momong passavele.” ");
INSERT INTO mee_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesus ke role minmina kurumea, ri keke rorole roma, “Kannu e soali ke lupage.” ");
INSERT INTO mee_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nae Iesus naname ba teiteikia memena keke lele ba keke maisinsi ngapotu nga bale, na keke balue agau te ta i kiunga te Iesus. ");
INSERT INTO mee_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ba ragau papatu reke tattara taliukale keke role kia roma, “Name bae teiteikone memena rio a potu ba keke bai ta kelanga one.” ");
INSERT INTO mee_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Avae Iesus ke ala rea roma, “Taime ka ri rae nau bae teiteikau memena?” ");
INSERT INTO mee_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Na i ke kelataliu ta ragau reke tattara taliukale, na ke role roma, “Ngaka kele. Nau bae teiteikau memena rikai. ");
INSERT INTO mee_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Iau ka role minmina kurumea, agau e lolakurumea Nutu lonangana ka i a teiteikau ba ligupiau ba nau.” ");
INSERT INTO mee_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nae Iesus ke paturu ta pangalomatanange ragau muni nga me a sivoli kaona. Ba ragau reke katukala te i ka ri papatu raumana. Minmina na i ke taepatae nga manang e manmana nga me a sivoli, na ke tara. Ba ragau karolu keke momo nga baipuna nga me a sivoli kaona. ");
INSERT INTO mee_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ba i ke palomatantana rea ka oru papatu ka pangateningkalame, na ke role kerea ka pangalomatanangana roma: ");
INSERT INTO mee_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ngaka longo nasai! Ka kae te na agau te ke loa ta tapunge pailli matana te kanname nga ura ae i. ");
INSERT INTO mee_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ba ka ine taptapu rea nga mogalo, na palu keke pupu nga pamau bavana, na manume keke atu ba keke kani rea. ");
INSERT INTO mee_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ba pailli kanna palu muni keke pupu nga mogalo ina i a lollo, ba inaeala ka sana mogalo kia raumana. Na pailli kanna nginngina keke kalapa bolvole kurumea, mogalo ke sane lu lakallo raumana. ");
INSERT INTO mee_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ava ka ina kae loapatae, na i ke sina rea na keke mate kurumea, kulareame ke sane ke sigilu lakallo ta mogalo. ");
INSERT INTO mee_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ba pailli kanna palu muni keke pupu ngaliua nga oalo ra matarea. Na oalome ba paillime keke lele kinung, ava oalome keke kalipalipita ka paillime na paillime keke mate. Ba ke sane ke piau. ");
INSERT INTO mee_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ava pailli kanna palu keke pullu lakallo ta mogalo ine pe. Na keke lele bollau ba keke piau masi. Ba kenakena ka kanna papatu raumana. Palu ka kanreame ka ri giaukaina ba tangulelu, ba palu ka kanreame ka ri giaukaina mologi, ba palu ka kanreame ka ri giaukaina lima.” ");
INSERT INTO mee_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nae Iesus ke role kerea roma, “Ngaroma agau te nga omona ta longa, na i nge longe pangamologa laekia.” ");
INSERT INTO mee_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ngarume, ka inae Iesus momo mana me i, na ragau palu reke tataokurumea kala nga Pana Tangulelu Ba Lua keke ballage ta pangateningkala ra kanna mirareame. ");
INSERT INTO mee_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Na i ke role kerea roma, “Nutu ke tunge lomatana te miau ta baina nga lomiaumatana ka oru re ta kelangpatalingana onreke kolulu. Ava ke tungtunge orume kinung ta ragau re ngapotu ka pangateningkalame mana. ");
INSERT INTO mee_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nutu ke kumkuma minmina ta baina, “‘ri ngeke kelkela ava ke sane ke la kelangapatokona, ba ngeke longlongo ava ka sana la loreamatana; ngaroma ri nga loreamatana, na ngeke pulivalakale baingarea reke sosoali nae Nutu nge osurure baingarea nginngina reke sosoali.’” ");
INSERT INTO mee_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nae Iesus ke ballaga rea roma, “Miau ka lomiaumatana ka pangateningkala laeala ore ta agau e taptapue pailli kanname mirana, o ke sa? Ngaroma nge sa, na ala nga lomiaumatana ka pangateningkala pattoto mirarea mina ngaetai? ");
INSERT INTO mee_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Agau laeala e taptapue pailli kanname ka tongana kena ma agau e kumkuma ta toange pangamologa ae Nutu kanna nga ragau. ");
INSERT INTO mee_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ba ragau palu ka tongarea kena ma pailli kanna nginngina reke pupu nga pamau bavana. Ka ri ra ragau ra agau te kumkuma ta toange pangamologa ae Nutu kanna ngallo nge ri. Ava nga ine ngeke longe pangamologa laeala, na ka panna laeala mana, nae Satan nge atu na nge ravupatali ka pangamologa laeala a agau toaꞌe ngallo nge ri. ");
INSERT INTO mee_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Minmina mana na ragau pattoto ka tongarea kena ma pailli kanna nginngina ra agau e taptapue pailli kanname tapu rea nga mogalo ina i a lollo. Ka ri ra ragau onreke sereng raumana nga ineke longe pangamologa ae Nutu kanna pau. ");
INSERT INTO mee_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ava ri ka tongarea kena ma bega onra kulareame ke sane ke sigilu lakallo ta mogalo. Keke momo ka panna inte mana. Ba nga ine ngeke kanimaia maenangme o ragau ngeke pamiralali rea kurumea loangakurume ngareangana ka pangamologa ae Nutu kanna, na keke kaꞌe lopatokona ae ri bolvole. ");
INSERT INTO mee_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ba ragau palu muni ka tongarea kena ma pailli kanna nginngina onreke pupu ngaliua nga oalo ra matarea. Ka ri ra ragau onreke longe pangamologa ae Nutu kanna, ");
INSERT INTO mee_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ava loreapupungana re ta oru re nga mogalo laekia e ngape, ba kilipu goangana, ba loreamatengana ka oru pattoto keke atu, na keke kalipalipita ka pangamologa laeala ae Nutu kanna a ri ke longe. Na pangamologa laeala ke sane piau ngallo nge ri. ");
INSERT INTO mee_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ava ragau palu ka tongarea kena ma pailli kanna nginngina ra agau e taptapue pailli kanname tapu rea nga mogalo ine pe. Ri keke longe pangamologa ae Nutu kanna ba ka loreangatakale. Na keke piau masi. Palu ka kanreame ka ri giaukaina ba tangulelu, ba palu ka kanreame ka ri giaukaina mologi, ba palu ka kanreame ka ri giaukaina lima.” ");
INSERT INTO mee_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nae Iesus ke role kerea roma, “Agau nge atu ka lama na ke sane nge pakompite ka otte, o ke sane nge pasasalue ta nia siana. Ke sa. I nge patarapaia nga pangatara ae i. ");
INSERT INTO mee_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Iau ka role minmina kurumea, ngarume nae Nutu ke la pangapotange orume kinung ra ragau ke pako rea sonrau. Ba orume kinung ra ragau ke talu rea sonrau keke la leleng nga olamana ngarume. ");
INSERT INTO mee_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ngaroma agau te nga omona ta longa, na i nge longe pangamologa laekia.” ");
INSERT INTO mee_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ba i ke role kerea bole roma, “Ngaka ella masi ta oru ra miau ka longlongo rea. Ngaroma nga omomiau ta longnge oru tutuna mana, nae Nutu ke la tungnge oru tutuna mana te miau. Ava ngaroma nga omomiau ta longnge oru papatu, nae Nutu ke la tungnge oru papatu raumana muni te miau. ");
INSERT INTO mee_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Iau ka role minmina kurumea, Nutu ke la tungnge lomatana papatu muni ta agau a kana lomatana. Ava nga agau a sana kana lomatana, Nutu ke la ravungpatali ka lomatana ae i e sina nga baina i sana nga kana lomatana bavakena.” ");
INSERT INTO mee_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nae Iesus ke role kerea roma, “Nutu kelangpatalingana ka tongana kena ma agau e tapue pailli kanna nga mogalo. ");
INSERT INTO mee_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","I nge kenrarau ka rigome ba nge sigipagpaga ka kaeme ba pailli kanna laeala a i tapue nga mogalo nge kalapa ba nge lele bollau. Ava agau laeala sana nga lonamatana roma, pailli kanna laeala ke lele mina ngaetai. ");
INSERT INTO mee_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ke sa. Mogalo muni nge bai ka pailli kanna ta i leleng. Kapunu na launa nge lele, na nga kunna, na ngarume na kanname ngeke matua ngallo nga kunna. ");
INSERT INTO mee_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ava nga ina pailli kanna reke momo nga kunreame ngeke matua tapu, ka kae laeala mana, na agau laeala e tapue pailli kanname pala nge sapia pailli nginngina ka resalla kurumea, kae e nga lalang ke lele tapu.” ");
INSERT INTO mee_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nae Iesus ke ballaga rea roma, “Ita kaka la tonge Nutu kelangpatalingana ka taru, o ita kaka la panganana te i ka pangateningkala a taru? ");
INSERT INTO mee_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","I ka tongana kena ma bega kanna ore sina raumana nga bega kanna pattoto ra miau ka tota rea nga mogalo. ");
INSERT INTO mee_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ava nga ina agau te nge toaꞌe, na nge lele ba nge lele bollau raumana nga bega pattoto reke momo nga ura. Ba nge pulia kamana reke bollalau raumana. Minmina na manu reke lolo nga tava ngeke momo nga bega laeala kana nunule.” ");
INSERT INTO mee_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Bae Iesus ke rorolea pangamologa re ta Nutu kelangpatalingana te ri ka pangateningkala matana nginngina. I ke kuma minmina kurumea ginggingngarea ta ri loreamatanangana ka oru ra i rorole tao. ");
INSERT INTO mee_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ba ke sane role kerea ka pangamologa te a sana i a pangateningkala. Ava ke turupotpote pangateningkalame kinung mirarea ta barangalele ra kanna ka ina ragau pattoto ke sane ke momo kala nge ri. ");
INSERT INTO mee_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na ka kae laeala mana ina kae barelu tapu, nae Iesus ke role ka barangalele ra kanna roma, “Ita ngaka loa ta me a sivoli bavana tetoto.” ");
INSERT INTO mee_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ka baina ri keke rave Iesus kala nge ri nga manang laeala ame tattara ngia, na keke kaꞌe maluame nga me a sivoli kaona. Ba manang palu muni keke momo kala nge ri. ");
INSERT INTO mee_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ba ka ineke tatao eke lola, na sauu e bollau raumana ke lelekala rea nga me a sivoli ba miniuame keke balikolointe manang. Minmina na me ke ponu raumana ngallo nga manang laeala. ");
INSERT INTO mee_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Avae Iesus ke mommo nga manang ine ngarume ba ke kenrarau ka ulongpaingana ka kunna nga talingloa te. Na barangalele ra kanna keke pangoe ba keke ballage roma, “Apangalomatanakana, ka sana longsoali nga ina ita la maraleng?” ");
INSERT INTO mee_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ka bainae Iesus ke sigipaga, na ke baullupite sauu ba ke role ka miniuame roma, “Ka rulu! Ngaka malo!” Na sauu ke rongo ba miniuame keke malo bavakena. ");
INSERT INTO mee_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nae Iesus ke ballage barangalele ra kanna roma, “Kaka meimia aka matautau? Ka ma sana lomiaupatokona?” ");
INSERT INTO mee_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na keke matau raumana ba keke palirole kerea roma, “Tai ikia nge aekia? I ke role ka sauu ba miniuame na keke longo te i mana.” ");
INSERT INTO mee_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nae Iesus kala nga barangalele ra kanna keke lele nga me a sivoli bavana tetoto nga ine ngae Gerasenesme. ");
INSERT INTO mee_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ba ka inae Iesus solele nga manang tapu, na ka pannasa mana na agau te ke lelemalaga nga baveng reke tatalue reke mate ngi, na ke loa te Iesus. Ka i a agau ora kannu e soali lupage, ");
INSERT INTO mee_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ba malle a i momo ngia ke momo ngaliua nga baveng reke tatalue ragau reke mate ngi. Ba ka sana agau te totorong ta i samangpitange agau laeala tale. Ke sane ke totorong ta samangpitange ka oalo a ene bole ");
INSERT INTO mee_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","kurumea, keke samapitpite kamaname ba kaename ka oalo ra sene ka kae papatu tapu. Ava i ke burumotmotue oalo nginngina ra sene ba ke baimakolkole ene onreke samapitpite kaename ki. Ba ka sana agau te gingging ta i launge. ");
INSERT INTO mee_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ba ka rigome kinung ba ka kaeme kinung ka ine mommo ngaliua nga baveng nga reke mate ba nga kapangngme, na i ke rereli ba ke lilia i muni ka lollo ra matarea. ");
INSERT INTO mee_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ka ina agau laeala kelapa kae Iesus ine momo ngatauga tale, na i ke pira te i ba ke parovanu ngamuga nge i. ");
INSERT INTO mee_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Na ke reli kaligi roma, “Iesus, Nutu E Ngailu Raumana Tuna, one ko bai ta maingamia kau? Ka tanikala one nga Nutu giana ta one sano ngo pamiralali iau!” ");
INSERT INTO mee_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","I ke role minmina kurumea, pala nae Iesus ke role ka kannu e soali e momo ngallo nga agau laeala roma, “Kannu e soali, ngo lelemalaga patali nga agau laekolong!” ");
INSERT INTO mee_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nae Iesus ke ballage roma, “Giang nge tai?” Na i ke ale roma, “Giau nge Barana ta ka mangng papatu.” ");
INSERT INTO mee_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ba kannu laeala e soali ke tanikalkale Iesus ta i sane nge bamalaga rea nga inaeala. ");
INSERT INTO mee_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na ka gie barana e bollau ke kaninni nga inaeala nga kapangng. ");
INSERT INTO mee_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Minmina na kannu nginngina reke sosoali keke tanikale Iesus roma, “One ngo balu mangng lakallo ta gie nginngina ta baina mangng nga lu rea.” ");
INSERT INTO mee_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ba ka inae Iesus ngatakala rea, na kannu nginngina reke sosoali keke lelemalaga patali nga agau laeala ba keke lue gieme. Na gie barana laeala, ka ri basema 2000, ke tumvalivu maling nga ina i a mantapu, na ke toarallu kerea nga me a sivoli. Na keke marale ba keke mate nga me a sivoli. ");
INSERT INTO mee_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ba ka ina ragau reke ellapatantali ta gie nginngina ke kele ollaeala e lele, na keke kaꞌe inaeala. Na keke ture ngallo nga maga kunna e bollau ba nga iname kalaoveka nga inaeala. Na ragau reke longe keke atu ta kelange ollaeala e lele. ");
INSERT INTO mee_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ba ka ineke lele nge Iesus, na keke kele agau laeala e pala na kannu reke sosoali ke momolu nge i. Ava sonrau na ramana ke pe ba i ke tattara ka lungapaga. Ka i a agau laeala mana ore pala ne kannu barana reke sosoali ke momolu nge i. Ba ka ina ragau nginngina reke atu ke kele, na keke matau raumana. ");
INSERT INTO mee_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na ragau reke kele inae Iesus taomalage kannu nginngina reke sosoali keke ture oru reke lele ta ragau reke atu. Ke ture oru reke lele nga agau laeala a kannu reke sosoali ke momolu ngia pala, ba keke ture oru reke lele nga gieme bole. ");
INSERT INTO mee_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Na keke paturu ta taningkalange Iesus ta i kange inaeala ae ri. ");
INSERT INTO mee_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Na ka inae Iesus taepataetae lakallo ta manang, na agau laeala a kannu reke sosoali ke momolu ngia pala ke tanikale Iesus ta i loanga kurumea. ");
INSERT INTO mee_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Avae Iesus ke malai ka rolengana kia roma, “Ngo galiu ta maga ae one ba ta rakone memena, na ngo ture oru reke bollalau raumana rae Nutu kuma ki te one te ri. Ba ngo turu ta ina lonanana one.” ");
INSERT INTO mee_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ka baina agau laeala ke loa, na ke paturu ta turung nga ina re kalaoveka ngae Rekapolis ka oru rae Iesus kuma ki te i. Ba ragau karolu keke kallo raumana. ");
INSERT INTO mee_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nae Iesus ke ulutote me a sivoli muni ka manang, na ke lele nga bavana tetoto. Ba ragau papatu keke taliutotokale ka ine meisinsi nga me a sivoli kaona. ");
INSERT INTO mee_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Na agau te a giana nge Iairus a i a kelangpatali te nga bale a sinagog ke atu ta inaeala. Ba ka ine kele Iesus, na ke pupisigi kokoro ta Iesus kaena puna, ");
INSERT INTO mee_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ba ke tanikale kaligi roma, “Tugu piau e sina ke kokoro ta i mateng. One ngo atu ba ngo pulipaia kamangme nge i ta baina i nge pe ba nge mauli.” ");
INSERT INTO mee_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Minmina nae Iesus ke loa kala nge i. Ba ragau papatu keke tatao kurumea Iesus ba keke pavimvi rea nge i. ");
INSERT INTO mee_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na avale te ke momo nga inaeala kala nge ri. Ka i a avale ore tattara ka luvo ka kaeme kinung ka pesingmataname ka ri tangulelu ba lua tapu. ");
INSERT INTO mee_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ba ke kanimaia miralali papatu nga ra pangapemirakana papatu kamareame, ba ke rongo ka lollokanna ra kanna kinung, ava ke sane ke kalaue. Ke sa. Soaling ae i ke bollau muni. ");
INSERT INTO mee_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ka ina avale laeala longe turung e te Iesus, na i ke loa kokoro te i nga gina ina ragau ke taliutotokale, na ke kali ka lungapaga ae i. ");
INSERT INTO mee_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","I ke kuma minmina kurumea, i ka lonavavai roma, “Ngaroma nga kali ka lungapaga rae i mana, na iau ka la penga.” ");
INSERT INTO mee_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ba ka pannasa mana, na totona taongana ke rongo. Ba i ke kanimaia soaling ine rongo nga mirana. ");
INSERT INTO mee_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Na ka pannasa mana nae Iesus ka lonamatana roma, gingginga palu keke lelemalaga nge i. Minmina na i ke kampiliugaliu nga maluame na ke ballaga roma, “Tai ke kali ka lungapaga rae iau?” ");
INSERT INTO mee_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Na barangalele ra kanna keke ale roma, “Ragau papatu keke pavimvi rea nge one. Ko meimia na ko ballaga roma, tai ke kali kone?” ");
INSERT INTO mee_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Avae Iesus ke kelkela kalaoka ta kelange avale laeala e kuma ka ollaeala. ");
INSERT INTO mee_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ava avale laeala ka lonamatana ka taru e lele nge i. Minmina na i ke loa te Iesus ka mirana mammalungana ba mataungana, na ke pupisigi ngamuga nge i ba ke turupote orume kinung te i. ");
INSERT INTO mee_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nae Iesus ke role kia roma, “Tugu piau, lopatokona ae one ke pape one. Ngo loa ka lomannmannangana. Mirang lalingana sane la pulangkala one muni.” ");
INSERT INTO mee_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ka ine pamolloga tale, na ragau palu keke pa nga bale ae agau laeala a i a kelangpatali te nga bale a sinagog, na keke role roma, “Sano ngo ballage apangalomatanakana ta i loanga muni, ta tungu piau ke mate tapu.” ");
INSERT INTO mee_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ava ka inae Iesus longe pangamologangarea, na i ke role ka agau laeala a i a kelangpatali nga sinagog roma, “Sano ngo matau. Nga longopatokona mana te iau.” ");
INSERT INTO mee_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nae Iesus ka sana lonangatakale agau te ta i loangakurumea, kana kae Pita bae Iems bae Ion a i a Iems teiteikia mana. ");
INSERT INTO mee_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ba ka ineke lele nga bale ae agau laeala a i a kelangpatali nga sinagog, nae Iesus ke kele ragau ineke lavoalla beke ollekannu ta goe laeala. ");
INSERT INTO mee_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Na i ke lu lakallo ta bale ba ke role kerea roma, “Kaka meimia aka bavaia lavongkala baka tantani? Goe laekia ke sane mate, ava ke kenrarau.” ");
INSERT INTO mee_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Na keke malilia. Ava i ke bamalage ri kinung lagapotu ba ke rave goe laeala tamana ba naname kala nge i muni balingana memena, na ke lu lakallo ta bale bilingana a goe laeala momo ngia. ");
INSERT INTO mee_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Na ke kampite goe laeala avale kamana ba ke role kia roma, “Talita kum!” a mirana roma, “Goe avale, nga role kone, ngo sigipaga!” ");
INSERT INTO mee_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ba ka pannasa mana na goe laeala avale ke sigipaga ba ke paturu ta taonga, ta i ka nena pesingmataname ka ri tangulelu ba lua tapu. Ba ka ina ragau reke momo kala nge i ke kele ollaeala, na keke kallo bavakena. ");
INSERT INTO mee_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nae Iesus ke tunge pangamologa e gingging te ri ta ri nga manereasa turunge ollaeala ta agau te. Ba ke role kerea ta ri tunga goe laeala avale kana kaning. ");
INSERT INTO mee_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nae Iesus ke kaꞌe inaeala na ke loa ta magapuna ae i, ba barangalele ra kanna keke loakurumea. ");
INSERT INTO mee_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ba ka ina kae a Sabat lele, na i ke paturu ta pangalomatanange ragau nga bale a sinagog. Na ragau papatu reke longe keke kallo raumana ba keke palibalaglaga rea roma, “Agau laekia ke rave pangalomatana kokorai ngae tai, ba tai ke tunge lomatana laekia e pe raumana te i? Ba tai ke tunge gingginga laekia te i ta i kumangng ka killa kakong reke bollalau? ");
INSERT INTO mee_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ka i a popongpita laeala tuna mana. Ka i ae Maria tuna, ba ka teiteikia memena nge Iems, bae Iosep, bae Iuras, bae Saimon. Ba liuna piau memena kinung keke momo ikia nga maga kunna ae ita. Ka i a agau baseme ita mana.” Minmina na ri ka sana loreapatokona te i. ");
INSERT INTO mee_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nae Iesus ke role kerea roma, “Ragau re nga magame kinung keke la tungnge alangpaga ta agau e toe Nutu kaona, ava ragau re nga magapuna ae i, ba rakia memena, ba ragau re nga balekaina ae i muni, ke sa.” ");
INSERT INTO mee_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Minmina nae Iesus ke sane totorong ta i kumangng ka killa te nga maga laeala. Ke sa. Ke papea ragau tutuna mana ra karea ka soaling ine ulopaia kamana nge ri. ");
INSERT INTO mee_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ba i ke kallo ine kele loreakalasa ngareangana. Nae Iesus ke taliliu ta magame ba ke palomatantane ragau. ");
INSERT INTO mee_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ba i ke kiue Pana Tangulelu Ba Lua te i, na ke bamalaga rea ka lualua. Ba ke tunge giana ginggingngana te ri ta ri taongamalagange kannu reke sosoali. ");
INSERT INTO mee_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ba pala ta ri loanga, na i ke tunge potong palu te ri minakai roma: “Miau sana ngaka loa ka oru re nga taonga basema kaning, ba bising, ba lollokanna nga ligongpita rae miau. Ngaka loa ka to e nga kalaunge taongamiaungana mana. ");
INSERT INTO mee_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ngaka kaliale kesingsilagime, ava ngaka lupage lungapaga kena mana. ");
INSERT INTO mee_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ba nga ina miau ngaka lu nga bale te, na ngaka momo nga bale laeala ta nge lele ina miau ngaka kaꞌe maga kunna laeala. ");
INSERT INTO mee_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ba ngaroma ragau re nga maga te sane ngeke ravu miau ta bale nga ri o sane ngeke longo te miau, na ngaka lulupatali ka magavusa nga kaemiau sianame nga ina miau ngaka kaꞌe maga laeala. Ka la i a killa a panaunga te ri roma, keke baia bainga e soali.” ");
INSERT INTO mee_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Minmina na keke kutapu eke lola, na keke pulimalaglage pangamologa ta ragau ta ri ngeke pulivalakale baingarea reke sosoali na ngeke tunge loreamatenganame te Nutu. ");
INSERT INTO mee_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ba keke taomalaglage kannu papatu reke sosoali, ba keke pulpulia saulang nga ragau papatu ra karea ka soaling na keke pape rea. ");
INSERT INTO mee_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nae Eroto a i a kelangpatali nga gavaman e ngae Rom nga inaeala ke longe Iesus kana turung kurumea, ragau papatu ka loreamatana ka Iesus kumangnganame. Ba palu nge ri keke rorolea pangamologa re te Iesus roma, “Nutu ke pasigipage Ion E Nga Pangamagoe nga mateng, minmina na gingginga kokorai reke bollalau raumana keke kumkuma ngallo nge i.” ");
INSERT INTO mee_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ava pattoto keke rorole roma, “Ka i ae Ilaia.” Ba pattoto muni keke rorole roma, “Ka i a agau e toe Nutu kaona ora tongana kena ma te e nga reke toe Nutu kaona ka kae re pala.” ");
INSERT INTO mee_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ava ka inae Eroto longe pangamologa nginngina, na i ke rorole roma, “Ka i ae Ion ama battote ganna pala ave sigipaga nga mateng!” ");
INSERT INTO mee_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Eroto ke role minmina kurumea, pala na i muni ke baꞌe ragau ta ri launge Ion ba samangpitange, na keke ule nga pulangkala. I ke kuma minmina kurumea, pala na i ae Eroto ke rave tataokia ae Pilip napengana a giana nge Erorias, na ke kamapitakama kia. ");
INSERT INTO mee_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Bae Eroto ke pulakale Ion kurumea, pala nae Ion ke rorole kia roma, “Ke parototokala ta one ravunge tataokone napengana.” ");
INSERT INTO mee_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Minmina nae Erorias ka iukia kae Ion, ba i ke bai ta samungpununge. Ava ke sane totorong ta kumangng ka ollaeala ");
INSERT INTO mee_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kurumea, natale ae Eroto ke matautaue Ion ba ke lengetotokalkale. Ta i ka lonamatana roma, Ion ka i a agau a bainganame ke pe ba agau e tupu. Ba ka ine longlonge Ion pangamologanganame, na i ka lonatangtang ava ke matea ta longe Ion ine pamolloga. ");
INSERT INTO mee_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ava ngarume nae Erorias ke kalipa ka pamau ta i samungpununge Ion minakai roma: Ka kae te a i a kae e nga lonagaliungana ta kae ae Eroto naname toapisigia, nae Eroto ke baia kaning e bollau ta pangaserengkale ragau ravollalau ra kanna, ba re kapunu nga ra balingkana kala nga ragau reke taoamugmuga ka ragau re ngae Galili. ");
INSERT INTO mee_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ba ka ineke kaninni, nae Erorias tuna piau ke lu lakallo ta kaning laeala, na ke pespesi. Ba malaui laeala ke paserengea Eroto kala nga ragau reke tattara ta kaning kala nge i raumana. Minmina nae Eroto ke role ka malaui laeala roma, “Ngo ballaga iau ta taru a one matea, na nga tunge te one.” ");
INSERT INTO mee_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ba i ke patokala ngailu te i roma, “Taru a one ballaga iau te ka la tungnge te one. Ngaroma ngo matea, na iau ka la kalingpalange kelangpatalingau ta rina lua, na ka la tungnge inte nga ina lua nginngina te one.” ");
INSERT INTO mee_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Na malaui laeala ke lelemalaga, na ke ballage naname roma, “Iau ka la balinglage ta taru?” Na naname ke ale roma, “Ngo role ta one ravunge Ion E Nga Pangamagoe kunna.” ");
INSERT INTO mee_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na ka pannasa mana, na avale laeala a malaui ke galiu bolvole ta kelangapatali, na ke role kia roma, “Gialgiala mana, na ka matea ta one pulinge Ion E Nga Pangamagoe kunna nga raliu te, na ngo atu kia ba ngo tunge te iau.” ");
INSERT INTO mee_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Na ka inae Eroto a i a kelangpatali longe pangamologa laeala, na i ka ragunaso. Ava pala na i ke patokala ngailu ka pangamologanganame, ba reke tattara ta kaning kala nge i keke longe patongkalangana nginngina. Minmina na i ka sana omona ta malainga ka malaui laeala balinglagangana. ");
INSERT INTO mee_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ka baina ka pannasa mana, na i ke baꞌe agau e saꞌvatonto ragau, na ke bapage ta i atung ka Ion E Nga Pangamagoe kunna. Na agau laeala ke loa, na ke battote Ion ganna ngallo nga pulangkala, ");
INSERT INTO mee_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ba ke ulopaia kunna nga raliu te. Na ke atu kia ba ke tunge ta malaui laeala. Ba ngarume na malaui laeala ke tunge te naname. ");
INSERT INTO mee_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ba ka inae barangalele rae Ion kanna ke longe ollaeala e lele, na keke atu. Na keke rave Ion mirana, ba keke pakenoe nga baveng e nga agau e mate. ");
INSERT INTO mee_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na ka ina aposelme ke galiu tapu, na keke katukala kinung te Iesus. Na keke turu pakia ka orume kinung ra ri ke kuma ki beke palomatana ki. ");
INSERT INTO mee_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Na ragau papatu raumana keke tatu te ri ba keke lola. Bae Iesus kala nga barangalele ra kanna ka sana karea panna inte ta ri kaning. Minmina na i ke role kerea roma, “Miau kasikemiau ngaka atu, na ita ngaka loa ta malle a misalong ngia. Na ngaka panna kamiau.” ");
INSERT INTO mee_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Minmina na ri kasikerea keke taepatae nga manang te, na keke loa ta malle a sana ragau ngia. ");
INSERT INTO mee_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ava ragau keke kele Iesus ba barangalele ra kanna ka ineke ka, ba papatu nge ri keke kelapatokona rea. Minmina na ragau nginngina keke lelemalaga nga magame kinung, na keke pira kinung ka kaereame ta ri leleng pala nge Iesusme. ");
INSERT INTO mee_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Na ka inae Iesus so ba ke kele ragau nginngina ra ri papatu raumana, na i ka lonananna rea kurumea, ri ka tongarea kena ma sipsip ra sana karea agau e ellapatantali te ri. Ka baina i ke paturu ta pangalomatana rea ka oru papatu. ");
INSERT INTO mee_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ba ka ina kae barelulu, na barangalele ra kanna keke loa te i na keke role kia roma, “Ka sana kaning nga malle laekia ba kae ke barelulu tapu. ");
INSERT INTO mee_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Minmina na ngo baꞌe ragau kokorai ta ri loanga ta maga reke momo nga inaekia ta baina ngeke koli karea kaning.” ");
INSERT INTO mee_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Avae Iesus ke ala rea roma, “Miau ngaka tungu karea kaning.” Na barangalele ra kanna keke role kia roma, “Ava ka ri papatu raumana. Agau te nge kuma basema inname ka ri lima ba mologi ta ravunge lollokanna ta koling karea kaning. Ko rorole roma, mangng nga loa na nga tamali ka lollokanna minmina ta koling karea kaning ae?” ");
INSERT INTO mee_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nae Iesus ke ballaga rea roma, “Ka kamiau beret pia? Ngaka loa na ngaka kela.” Ba ka ina ri loreamatana tapu, na keke role kia roma, “Ka bereteme ka ri lima ba lea lua rikorai.” ");
INSERT INTO mee_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nae Iesus ke role kerea ta ri roleng ka ragau ta ri tarang nga ginungame nga pailli reke kerkerangng. ");
INSERT INTO mee_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ka baina ragau keke tattara nga ginunga matana lua. Ginunga palu ka ragau ka ri giaukaina lima, ba palu ka ragau ka ri giaukaina lua ba tangulelu. ");
INSERT INTO mee_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nae Iesus ke rave beret nginngina ka ri lima ba lea nginngina ka ri lua, na ke kelapatae ta tava ba ke kalapage Nutu. Na ke regipale bereteme ba ke kole leame. Na ke tungu rea ta barangalele ra kanna ta ri tavoanga ki nga ragau karolu. ");
INSERT INTO mee_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Na ri kinung keke kani ba keke rongo ka loreanganame ka kaning laeala. ");
INSERT INTO mee_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Na barangalele rae Iesus kanna keke ravukinunge bereteme ba leame kaloreame reke kanilele rea, na keke paponue guratame ka ri tangulelu ba lua ki. ");
INSERT INTO mee_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ba rapanung reke kani ka kae laeala ka ri 5000. ");
INSERT INTO mee_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ba ka pannasa mana, nae Iesus ke role ka barangalele ra kanna ta ri taengapatae nga manang te ta baina ngeke loa pala nge i tae Betsaira ore momo nga me a sivoli bavana tetoto. Avae Iesus ke momo nga baina i nge baꞌe maluame ngeke lao. ");
INSERT INTO mee_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ba ka ine ba rea tapu, na i ke kutapu ta kapangng ta i kavang te Nutu. ");
INSERT INTO mee_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Na ka ina kae barelu tapu, na manang laeala a barangalele rae Iesus kanna ke momo ngia ke momo ngatauga nga me a sivoli kaona tapu. Avae Iesus ke momo mana me i ngape tale. ");
INSERT INTO mee_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ba i ke kele barangalele ra kanna ka ineke tumvugvugu ta oteng kurumea, bovole ke sanangkalkala rea. Na ka rigo luana, nae Iesus ke loa te ri ka taongapaingana nga me a sivoli. Ba i ke bai ta kavesinglele rea. ");
INSERT INTO mee_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ava ka ineke kele ine tataopai nga me a sivoli, na ka loreangana roma, ka i a kannu te. Minmina na keke reli kaligi. ");
INSERT INTO mee_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Keke reli kaligi kurumea, ri kinung keke kele ba keke matautau. Ava ka pannasa, nae Iesus ke role kerea roma, “Ngaka momo masi! Iau ikia. Sana ngaka matau.” ");
INSERT INTO mee_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Na i ke taelu lakallo ta manang kala nge ri, na bovole ke mate bavakena. Ba ri keke kallo raumana. ");
INSERT INTO mee_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Keke kallo raumana kurumea, pala na keke kele ine pakania ragau nginngina ra ri papatu raumana ka beret tutuna mana, ava ka sana loreamatana roma, ka i a tai tale. Ke sa. Loreame keke rutukala. ");
INSERT INTO mee_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ka ineke ulutote me a sivoli tapu, na keke lele nga ine ngae Genesaret, ba keke kone manang nga inaeala. ");
INSERT INTO mee_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ba ka ineke solele nga manang, na ka pannasa mana, na ragau reke momo nga inaeala keke kelapatokone Iesus. ");
INSERT INTO mee_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Na keke loa bolvole ta iname kinung nga inaeala, na keke rave ragau ra karea ka soalingme. Ba nga ina ri ngeke longe roma, Iesus ke momo nga inte, na ngeke paue ragau nginngina ra karea ka soalingme ka nia rae ri ta inaeala ae Iesus momo ngia. ");
INSERT INTO mee_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ba ka inae Iesus nge taolu lakallo ta magame, o ta maga kunna reke bollalau, o ta ina re ngapotu nga magame, na ri ngeke pakenoe ragau ra karea ka soalingme nga malle re nga koling kaning. Na ngeke tanikale Iesus ta i ngatangng ta ra nginngina ra karea ka soalingme ta ri kaling ka lungapaga ae i sigina matana mana. Ba ragau reke kali kia soaling ae ri nge rongo mana. ");
INSERT INTO mee_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ka kae te, na Parisiome ba ragau palu ra pangalomatanakana nga bangapagame onreke pa ngae Ierusalem keke katukala kinung te Iesus. ");
INSERT INTO mee_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Na keke kele barangalele palu rae Iesus kanna ka ineke kaninnia kaning ka kamarea ra ri sane ke palellepa rea kurumea sisiukerea memena baingareame. Ke sane ke palellepaꞌe kamareame pala ta ri kaning. ");
INSERT INTO mee_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Na Parisiome ba ragau kinung ra Iura ke sane ke kaninni ka kamarea ra ri sane ke palellepa rea. Ke sa. Keke palellepapaꞌe kamareame pala ta ri kaning kurumea sisiukerea memena baingareame. ");
INSERT INTO mee_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ba ka ineke pa nga malle e nga koling kaning, na ri ke sane ke kaninni pala ta ri pangalellepa rea muni kurumea sisiukerea memena baingareame. Ke sa. Ba keke lolakurumea sisiukerea memena baingarea pattoto ra ri papatu bole basema, bainga re nga pangalellepaꞌe gato reke sisina ba ne ngeke bollalau.) ");
INSERT INTO mee_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Na Parisio nginngina ba ragau nginngina ra pangalomatanakana nga bangapagame keke ballage Iesus roma, “Ke meimia na barangalele ra kaning ke sane ke tataokurumea sisiukita memena baingareame, ava keke kaninnia kaning ae ri ka kamarea onre sane ke palellepa rea?” ");
INSERT INTO mee_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nae Iesus ke ala rea roma, “Miau ra goangakana, Nutu pangamologangana onra agau e toe kaona ae Aisaia role rea pala keke turupote baingamiaume mannangana ine role roma: “‘Ragau kokorai keke alapagpaga iau ka kaoreame, ava loreame keke momo ngatauga nge iau. ");
INSERT INTO mee_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Keke kalapagpaga iau ka mirarea ina nge ngapotu mana. Keke palomatantane ragau ka lomatana ae ri muni, na keke role roma, lomatana laeala ke pa nge iau.’ ");
INSERT INTO mee_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Miau kaka gingging raumana ta loangakurumea ragau baingareame, ava kaka bali ka gimiaume ta bangapaga rae Nutu kanna.” ");
INSERT INTO mee_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Bae Iesus ke role kerea bole roma, “Miau ka lomiausereng ta ulongvalakalange bangapaga rae Nutu kanna ta baina miau ngaka lolakurumea sisiukamiau memena baingareame. ");
INSERT INTO mee_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Iau ka role minmina kurumea, pala nae Moses ke role roma, ‘One ngo alapagpage tamang bae name.’ Ba ke role bole roma, ‘Ngeke sapune agau e rolesolali ka tamana o naname.’ ");
INSERT INTO mee_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ava miau kaka rorole roma, ngaroma agau nge role ka tamana o naname roma, ‘Oru ra kanau ra miau ka bai ta ravunge kalaungapaga ki ka ri ra tunga re nga tungnga rea te Nutu mana,’ ");
INSERT INTO mee_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","na i nga manenasa kalaunge tamana o naname ka oru nginngina. ");
INSERT INTO mee_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Minmina na miau kaka balvali ka gimiaume ta bangapaga rae Nutu kanna ka loangakurume ngamiaungana ka bainga ra miau ka ravu rea nga sisiukamiau memena. Ba kaka kumkuma ka kumangng matana nginngina raumana.” ");
INSERT INTO mee_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ngarume nae Iesus ke kiue maluame muni, na ke role kerea roma, “Ngaka longo nasai nga baina nga lomiaumatana masi. ");
INSERT INTO mee_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Otte e momo ngapotu nga agau te ke sane totorong ta pangamukune agau laeala nge Nutu raguna ine nge loalu ta siana. Ke sa. Oru reke lelemalaglaga nga agau te kaona, oru nginngina keke pamukunkune nge Nutu raguna. ");
INSERT INTO mee_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ngaroma agau te nga omona ta longa, na i nge longe pangamologa laekia.” ");
INSERT INTO mee_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ka inae Iesus kaꞌe maluame tapu ba ke lu lakallo ta bale, na barangalele ra kanna keke ballage ta pangateningkala laeala e ta oru e pamukune agau. ");
INSERT INTO mee_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Na i ke ballaga rea roma, “Ba miau bole, ka sana lomiaumatana ae? Oru e momo ngapotu nga agau te ave lu lakallo ta siana sane totorong ta pangamukune agau laeala nge Nutu raguna. ");
INSERT INTO mee_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Iau ka role minmina kurumea, ollaeala ke sane lulu lakallo ta lona. Ke sa. Ke lulu lakallo ta siana, na ngarume na ke lelemalaglaga ta malle a gusali.” (Minmina nae Iesus ke role roma, kaningme kinung keke “lelle” nge Nutu raguna.) ");
INSERT INTO mee_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ba i ke rorole kerea roma, “Oru reke lelemalaglaga nga agau te, oru nginngina keke pamukunkune nge Nutu raguna. ");
INSERT INTO mee_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Iau ka role minmina kurumea, lovaingana reke sosoali raumana keke mommolu nga ragau loreame ava keke lelemalaglaga basema: bainga re nga kenong kala nga rapanung o ravale kalaoka, ba bainga re nga golong, ba bainga re nga samungpununge ragau, ba bainga re nga kenong kala nga agau a sana i a agau laeala napengana o natale, ");
INSERT INTO mee_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ba bainga re nga kelangalele, ba bainga re nga baingasoalinge ragau pattoto, ba bainga re nga goanga, ba bainga re nga matengraumanange rapanung o ravale mirareame, ba bainga re nga busing, ba bainga re nga rolengsoali ka ragau pattoto, ba ragau baingarea re nga kiningpataenge ri muni giareame, ba bainga matantana ra sana purea. ");
INSERT INTO mee_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Oru nginngina kinung keke momolu ngallo nga agau lona ava keke lelemalaglaga ba keke pamukunkune agau laeala nge Nutu raguna.” ");
INSERT INTO mee_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nae Iesus ke kaꞌe inaeala, na ke loa ta ina reke momo kokoro ta maga kunna e bollau ae Taia. Ba ke ine taolu ta bale te, na i ke sane matea agau te ta lonamatanangana roma, i e momo. Ava ke sane totorong ta talunge ollaeala kurumea, ragau kinung ka loreamatana kia tapu. ");
INSERT INTO mee_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ava avale te ke longe ine momo. Ka i a avale ora kannu e soali lupage tuna piau e sina. Minmina na avale laeala ke loa te Iesus bolvole, na ke pupisigi kokoro ta kaena puna. ");
INSERT INTO mee_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Na avale laeala ka sana i a Iura te. Ke sa. Ka i a agau ora naname toapisigia ngae Siria Ponisia. Ba i ke tanikalkale Iesus ta i taongamalagange kannu laeala e soali nga tuna piau. ");
INSERT INTO mee_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Avae Iesus ke role kia roma, “Goe rae bale tamana ngeke ravu karea kaning pala, ta ke sane pe ta ravunge beret ae bale tamana goe rae i na tamaling ki ta gauneme.” ");
INSERT INTO mee_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Na avale laeala ke ale Iesus pangamologangana roma, “Ka kaomanna Avolau, ava gauneme bole keke kaninnia kaning mamauna rae goe nginngina nga pala siana.” ");
INSERT INTO mee_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nae Iesus ke role kia roma, “Ko ala iau masi. Minmina na ngo loa. Kannu laeala e soali ke kapatali tapu nge tung piau.” ");
INSERT INTO mee_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Na avale laeala ke galiu ta bale ae i, na ke kele goe ae i ine kenkeno nga nia. Ba kannu laeala e soali ke ka tapu. ");
INSERT INTO mee_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nae Iesus ke kaꞌe inaeala e momo kokoro tae Taia, na ke taopale maga kunna e bollau ae Sairon ba ke sopisigi ta Sivoli Ae Galili ta ine ngae Rekapolis. ");
INSERT INTO mee_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Na ragau palu keke atu ka agau te te Iesus. Ka i a agau ora longaname ke rutu ba kaona ke sane pamolloga masi. Na keke tanikale Iesus ta i ulongpainge kamana nga agau laeala ta pangapenge. ");
INSERT INTO mee_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Minmina nae Iesus ke rave agau laeala, na ri pana lua keke kaꞌe ragau ta ri momong mana me ri. Nae Iesus ke kalalue kamana ririname ta agau laeala longaname. Ba ka ine ripi nga kamana ririna te tapu, na i ke kali ka agau laeala tengtengkia. ");
INSERT INTO mee_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nae Iesus ke kelapatae ta tava ba ke unale matuena, na ke role ka agau laeala longaname ba kaona ka i muni kalingngana roma, “Epata!” a mirana roma, “Ngaka pulapatali!” ");
INSERT INTO mee_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na agau laeala longaname keke pulapatali ba oru e rutukale tengtengkia pala ke rongo, na i ke paturu ta pangamologa masi. ");
INSERT INTO mee_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nae Iesus ke role gingging ka ragau ta ri nga manereasa turunge ollaeala ta agau te. Ava nga ine nge role gingging ta ri nga manereasa turunge kumangngana, na ri keke turupotpota raumana muni. ");
INSERT INTO mee_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ba keke kallo raumana na keke rorole roma, “I ke kumamasi ka orume kinung. Ba bole, i ke bavai ka ragau ra longareame ke rutu ta ri longa, ba ragau ra kaoreame ke sane ke pamolloga ta ri pangamologa.” ");
INSERT INTO mee_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ka kae nginngina na ragau papatu keke katukala muni te Iesus, ba ragau nginngina ka sana karea kaning. Minmina nae Iesus ke kiue barangalele ra kanna te i, na ke role kerea roma, ");
INSERT INTO mee_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Iau ka lauvavai raumana ta ra kokorai kurumea, ri keke momo kala nge iau ka kaeme ka ri mologi tapu ba ka sana karea kaning. ");
INSERT INTO mee_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ba ngaroma iau nga ba rea ta ri kangagaliu ta maga nge ri ka mateng kareangana, na likisa ngareangana nge bai kerea ta ri pupunga ineke tatao nga pamau. Ba palu nge ri keke pa nga ine nge ngatauga raumana.” ");
INSERT INTO mee_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Na barangalele rae Iesus kanna keke ale roma, “Ita kaka momo nga malle a sana kaning ngia ba ragau kokorai ka ri papatu raumana, minmina na agau te ke la ravunge beret ngaetai nga baina ri kinung ngeke kani?” ");
INSERT INTO mee_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nae Iesus ke ballage barangalele ra kanna roma, “Ka kamiau beret pia rikorong?” Na keke ale roma, “Ka ri lima ba lua.” ");
INSERT INTO mee_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ka bainae Iesus ke role ka malua ta ri tarang ngape nga mogalo. Na i ke rave beret nginngina ka ri lima ba lua, ba ka ine kalapage Nutu tapu, na i ke regipala rea ba ke tungu rea ta barangalele ra kanna ta ri tavoanga ki nga ragau. Na keke tungu rea ta ragau karolu. ");
INSERT INTO mee_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ba ri ka karea ka lea tutuna reke sisina bole. Minmina na ka inae Iesus kalapage Nutu tapu, na i ke role ka barangalele ra kanna ta ri tavoanga ka lea nginngina ta ragau bole. ");
INSERT INTO mee_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na ragau kinung keke kani ba keke rongo ka loreanganame ka kaning laeala. Na barangalele rae Iesus kanna keke ravukinunge kaning kaloname reke kanilele rea, ba keke paponue gurata reke bollalau ka ri lima ba lua ki. ");
INSERT INTO mee_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ba ragau reke momo ka kae laeala ka ri basema 4,000. Ba ka inae Iesus ba rea eke loa tapu, ");
INSERT INTO mee_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","na ka pannasa mana, na i kala nga barangalele ra kanna keke taepatae nga manang te, na keke loa ta ine ngae Ralmanuta. ");
INSERT INTO mee_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nae Parisiome keke atu te Iesus, na keke paturu ta palingtete ka pangamologa kala nge i. Ba keke bai ta avange. Minmina na keke ballage ta i kumangng ka killa te e bollau ta pangakosining roma, i ke pa nge Nutu. ");
INSERT INTO mee_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ava i ke unale matuena ngallo nge i kurumea kelangana ka loreakalasa ngareangana, na ke role kerea roma, “Ke meimia na miau raka momo sonrau kaka balaglaga ta kelange killa e bollau? Iau nga role kamiau ka kaomannmannangana roma, iau ka sana la pangakosining ka killa te e bollau te miau raka momo sonrau.” ");
INSERT INTO mee_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Na i ke ka rea ba ke taepatae nga manang muni, na ke loa ta me a sivoli bavana tetoto. ");
INSERT INTO mee_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na barangalele rae Iesus kanna ka loreapogo ta loanga ka beret kurumea rea nga manang. Ka karea ka beret kena mana. ");
INSERT INTO mee_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Bae Iesus ke rorole kerea gingging roma, “Ngaka ella miau masi ta isi orae Parisiome bae Eroto.” ");
INSERT INTO mee_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Minmina na barangalele ra kanna keke palibalaglaga rea roma, “Ke meimia na ke role kita ta ita ngaka ella ita masi ta isi orae Parisiome bae Eroto? Ke loakurumea ina sana kara beret nanguni.” ");
INSERT INTO mee_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Avae Iesus ka lonamatana ineke palibalaglaga rea minmina, ka baina i ke role kerea roma, “Ke meimia aka palirorole kamiau ina sana kamiau beret? Ka sana lomiaumatana tale ba ka sana lomiaupatokona tale ae? ");
INSERT INTO mee_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ka matamiau kanname, ava ka sana ka kelkela ae? Ka longamiaume, ava ka sana ka longlongo ae? Ba ka lomiaupogo ae? ");
INSERT INTO mee_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ka ina iau regipale beret nginngina ka ri lima ba ka tavoa ki ta pana 5000, na miau kaka paponue gurata pia ka kaning kaloname?” Na keke ale roma, “Tangulelu ba lua.” ");
INSERT INTO mee_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ba ka ina iau regipale beret nginngina ka ri lima ba lua ba ka tavoa ki ta pana 4000, na miau kaka paponue gurata reke bollalau pia ka kaning kaloname?” Na keke ale roma, “Lima ba lua.” ");
INSERT INTO mee_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Na i ke ballaga rea roma, “Ka sana lomiaumatana tale ae?” ");
INSERT INTO mee_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Na keke loa eke lele ngae Betsaira. Na ragau palu keke atu ka agau a matana kanname ke su ba keke tanikale Iesus ta i kaling kia. ");
INSERT INTO mee_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Minmina nae Iesus ke kapita ka matasu laeala kamana, na ke loa kia lagapotu nga maga. Ba ka ine ripi nga matana kanname tapu, na i ke ulopaia kamaname nge i ba ke ballage roma, “Ko kele otte, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Na agau laeala ke kelapatae, na ke role roma, “Ka kele ragau palu. Ka kelangarea ma bega reke tatao.” ");
INSERT INTO mee_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nae Iesus ke ulopaia kamaname nga agau laeala matana kanname muni, na matana kanname keke pepe muni. Ba i ke paturu ta kelange orume kinung masi. ");
INSERT INTO mee_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nae Iesus ke baꞌe ta bale ae i ka rolengana kia roma, “Sano ngo loalu ta maga.” ");
INSERT INTO mee_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nae Iesus kala barangalele ra kanna keke tatao eke lola ta maga reke momo nga ine ngae Sisaria Pilipai. Ba ka ineke tatao, na i ke ballaga rea roma, “Ragau keke rorole roma, ka iau a tai?” ");
INSERT INTO mee_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Na ri keke ale roma, “Palu keke rorole roma, Ion E Nga Pangamagoe ame mate ave mauli muni. Ba pattoto keke rorole romae, Ilaia. Ba palu muni keke rorole roma, agau te e toe Nutu kaona ore mate pala ave mauli muni.” ");
INSERT INTO mee_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nae Iesus ke ballaga rea bole roma, “Ava miau kakorong, kaka role roma, iau a tai?” Nae Pita ke ale roma, “Ka one ae Karais amae Nutu patokala pala ta i bange.” ");
INSERT INTO mee_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nae Iesus ke parototokala rea ta ri manereasa turunge ta agau te. ");
INSERT INTO mee_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Na i ke paturu ta pangalomatanange barangalele ra kanna roma, i ae Agau Tuna ke la kaningmainge miralali papatu. Ba ke turu te ri inae Iurame ravollalaukerea memena, ba re kapunu nga pirisme, ba ra pangalomatanakana nga bangapagame keke la tangunglelenge. Na keke la samungpununge. Ava ka kae a mologi ngarume nga matengana, na i ke la sigingpaga nga mateng. ");
INSERT INTO mee_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ba i ke turupotpote oru nginngina nga karakarangana. Nae Pita ke rave Iesus balakala ba ke paturu ta mologang kia. ");
INSERT INTO mee_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ava ka inae Iesus kampiliu ba ke kele barangalele ra kanna, nae i ke sanggipite Pita roma, “Satan, lo ngo loa lagarume ta gigu! One ko sano matea oru rae Nutu mate rea. Ke sa. Ko matea oru ra ragau ke mate rea.” ");
INSERT INTO mee_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nae Iesus ke kiue malua kala nga barangalele ra kanna ta ri atung te i, na ke role kerea roma, “Ngaroma agau te nge bai ta atung kurume iau, na i nge bali ka gina ta i muni lonamatenganame ba nge rave maiskovu ae i. Na nge tataokurume iau. ");
INSERT INTO mee_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Iau ka role minmina kurumea, agau e bai ta ravunglelenge i muni maulingngana ke la pangasanrea kia. Ava agau e pasanrea ka i muni maulingngana kurumea taongakurumengana kau ba pangamologa e pe e te iau, agau laeala ke la ravunglelenge maulingngana. ");
INSERT INTO mee_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Iau ka role minmina kurumea, agau ke la ravunge taru, ngaroma i nge rave orume kinung reke pepe nga mogalo laekia e ngape sonrau, ava ngarume na i muni maulingngana nge sanrea? ");
INSERT INTO mee_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","O agau nge totorong ta tungnge taru ta ravung galiunge i muni maulingngana ngaroma i nge sanrea tapu? ");
INSERT INTO mee_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Iau ka role minmina kurumea, agau a balenglengea ta turungpotange lopatokona ae i te iau ba ta pangamologa ra kanau nga momongana ngaliua nga ragau reke momo sonrau onreke kesipitpita iau beke kumkuma ka bainga reke sosoali, Agau Tuna ka la balenglengea ta agau laeala ngarume nga ine nge atu ngallo nga Tamana ba anggelo reke tupu lamarea e toakala.” ");
INSERT INTO mee_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Bae Iesus ke role kerea roma, “Iau nga role kamiau ka kaomannmannangana roma, palu nge miau raka meisinsi ikia ke sane ke la mateng ta nge lele nga ina ri ke la kelange Nutu kelangpatalingana atungana ka gingginga e bollau raumana.” ");
INSERT INTO mee_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ngarume, ka ina kaeme ka ri lima ba kena ke rongo tapu, nae Iesus ke rave Pita, bae Iems, bae Ion kala nge i, na ri kasikerea keke loapatae nga kapangng te e gavili. Nae Iesus mirana ka kelangana toto nga ragureame. ");
INSERT INTO mee_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ba lungapaga rae i ka lamarea raumana ba keke kavauvaunga raumana. Ba ka sana agau te nga mogalo laekia e ngape totorong ta mumunge lungapaga te ta i nge kavauvaunga minmina. ");
INSERT INTO mee_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nae Ilaia kala nge Moses keke lele nga ragureame, ba keke pamolloga kala nge Iesus. ");
INSERT INTO mee_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nae Pita ke role kae Iesus roma, “Rabai, ke pe ta mangng momong nakai. Mangng ka la pangamaisinge balvaleme ka ri mologi nga baina nga ningi te, bae Moses nga nena te, bae Ilaia nga nena te bole.” ");
INSERT INTO mee_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Pita ke role minmina kurumea, ri keke matau raumana. Minmina na i ka sana lonamatana roma, i nge pamologa mina ngaetai.) ");
INSERT INTO mee_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Na mumukua te ke lele ba ke gasipita rea. Na kaling te ke lelemalaga nga mumukua laeala ba ke role roma, “Aekolong ka i ae Tugu a iau materaumane. Miau ngaka longo te i!” ");
INSERT INTO mee_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Na bolvole mana, na keke kela kalaoveka ba ke sane ke kele agau te kala nge ri muni, avae Iesus kasikena. ");
INSERT INTO mee_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ba ka ineke soinsigi nga kapangng, nae Iesus ke role kerea gingging ta ri nga manereasa turunge ollaeala a ri ke kele ta agau te ta nge lele nga inae Agau Tuna nge sigipaga tapu nga mateng. ");
INSERT INTO mee_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Na ri keke malopite ollaeala mana nge ri, ava keke palibalaglaga rea roma, “Pangamologangana ine role roma ‘Iau ka la sigingpaga nga mateng.’ ka mirana mina ngaetai?” ");
INSERT INTO mee_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na keke ballage Iesus roma, “Ngaroma minmina, na ke meimia na ra pangalomatanakana nga bangapagame keke rorole roma, ka i ae Nutu lonangana ta Ilaia nge atu kapunu nge Mesaia?” ");
INSERT INTO mee_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nae Iesus ke ala rea roma, “Ilaia ke la atung kapunu ka kaomannmannangana, na i ke la pulinggaliunge orume kinung muni. Ba iau nga ballaga miau roma, ke meimia na keke paꞌe pangamologa e te Agau Tuna pala ore role roma, I ke la kaningmainge miralali papatu ba ragau keke la tangunglelenge? ");
INSERT INTO mee_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ava iau nga role kamiau roma, Ilaia ke atu tapu, ava ragau keke kuma kia kurumea loreangana mana ka baingasoali ngareangana kia kurumea pangamologa re te i onreke pa rea pala nga Lau Ae Nutu Kanna.” ");
INSERT INTO mee_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na ka ineke galiu ta barangalele rae Iesus kanna, na keke kele malua e bollau ineke meistaliu rea. Ba keke kele ragau palu ra pangalomatanakana nga bangapagame ineke pantente kala nge ri. ");
INSERT INTO mee_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ba ka ina ragau nginngina ke kele Iesus, na keke kallo raumana ba keke pira ta ri serengkalange. ");
INSERT INTO mee_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nae Iesus ke ballage barangalele ra kanna roma, “Miau kaka pantente kala nga ra pangalomatanakana nga bangapagame ta taru?” ");
INSERT INTO mee_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Na agau te ngaliua nga malua ke ale roma, “Apangalomatanakana, iau ka atu ka tugu ora kannu e soali lupage te one. Ka i a kannu e soali e rutukalkale pangamologangana. ");
INSERT INTO mee_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ba ka ina kannu laeala e soali nge rapite, na i nge tamali kia lagape ta mogalo. Na kaona mena e kavauvaunga nge olle, ba i nge tanagnagia nginginame, ba mirana nge totole bavakena. Ba iau ka ballage barangalele ra kaning ta ri taongamalagange kannu laeala e soali, ava ka sana karea gingginga.” ");
INSERT INTO mee_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nae Iesus ke role kerea roma, “Miau ra ragau raka momo sonrau, ka sana lopatokona ngallo nge miau. Iau ka la momong kala nge miau pa pia muni? Ba ka la kalaungapaga miau pa pia? Ngaka atu ka goe laekolong nasai te iau.” ");
INSERT INTO mee_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Minmina na keke atu ka goe laeala apanung te Iesus. Ba ka ina kannu laeala e soali kelapa kae Iesus, na ka panna laeala mana, na i ke paturu ta lulungmatagange goe laeala. Na goe laeala ke pupisigi lagape ta mogalo, na ke tanta kalaoveka ba kaona mena e kavauvaunga ke olle. ");
INSERT INTO mee_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nae Iesus ke ballage goe laeala tamana roma, “Goe laekia ke momo minmina ka kae o ka pesingmatana pia?” Na goe laeala tamana ke ale roma, “Ke paturu ine sina tale. ");
INSERT INTO mee_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ba kannu laeala e soali ke tantamali kia lakallo ta sia ta baingasoalinge ka kae papatu tapu. Ba ke tantamali kia lakallo ta me ka kae papatu bole. Ava ngaroma nga kanga ka gingginga ta kumangng ka otte, na nga longnanna mangng ba ngo kalau mangng.” ");
INSERT INTO mee_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nae Iesus ke role kia roma, “Ko meimia na one ko role roma, ‘Ngaroma nga kanga ka gingginga’? Nutu ka kana ka gingginga ta kumangng ka orume kinung ta agau a lonapatokona te i.” ");
INSERT INTO mee_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Na ka pannasa mana, na goe laeala apanung tamana ke role kaligi roma, “Iau ka laupatokona. Ngo kalau iau ta ulongpisiginge laukalasangana!” ");
INSERT INTO mee_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ba ka inae Iesus kele ina malua ke katukalkala bolvole, na i ke sanggipite kannu laeala e soali ka rolengana kia roma, “One a kannu e soali o bavai ka ragau ta ri manereasa longa ba pangamologa, ka role kone gingging ta ngo lelemalagapatalia goe laekolong. Ba sano ngo luia ka kae te muni.” ");
INSERT INTO mee_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Na ka ina kannu laeala e soali reli kaligi ba ke lulumatage goe laeala gingging raumana, na i ke lelemalagapatalia. Na goe laeala apanung ka kelangana ma agau e mate. Minmina na ragau papatu reke kele ollaeala keke role roma, “I ke mate tapu.” ");
INSERT INTO mee_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Avae Iesus ke kampite goe laeala kamana, na ke pamaisia. Na goe laeala apanung ke maisi. ");
INSERT INTO mee_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ngarume, ka inae Iesus lu lakallo ta bale tapu, na barangalele ra kanna keke loa te i ine momo mana me i, na keke ballage roma, “Ke meimia na mangng ka sana kamangng gingginga ta taongamalagange kannu laeala e soali?” ");
INSERT INTO mee_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Na i ke ala rea roma, “Ka pamau kena mana ta taongamalagange kannu matana laeala e soali. Agau nge kava te Nutu nae Nutu nge taomalage.” ");
INSERT INTO mee_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nae Iesus kala nga barangalele ra kanna keke kaꞌe inaeala, na keke taopalpale Galili. Bae Iesus ka sana omona ta agau te nga lonamatana roma, keke momo aetai. ");
INSERT INTO mee_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ka sana omona ta agau nga lonamatana roma keke momo aetai kurumea, i ke palomatantane barangalele ra kanna roma, “Ngarume, na agau te ke la ulonge Agau Tuna nga reke bai ta baingasoalinge kamareame, na keke la samungpununge. Ava nga kae a mologi ngarume nga matengana, na i ke la sigingpaga.” ");
INSERT INTO mee_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ava barangalele ra kanna ka sana loreamatana ka pangamologangana laeala mirana. Ba keke matautau ta ri balinglagapitange. ");
INSERT INTO mee_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nae Iesus kala nga barangalele ra kanna keke lele ngae Kaperneam. Ba ka ine momo nga bale, na i ke ballaga rea roma, “Miau kaka pantente ta taru ina ita ka tatao nga pamau?” ");
INSERT INTO mee_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ava ri keke rulu mana kurumea, ka ineke tatao na keke pantente ta tai e nge ri ka i e kapunu. ");
INSERT INTO mee_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Minmina nae Iesus ke tara, na ke kiue Pana Tangulelu Ba Lua te i ba ke role kerea roma, “Ngaroma te e nge miau nge matea ta i e kapunu, na nga i e ngarume bavakena ba nga i a akumangngatulu ae miau kinung.” ");
INSERT INTO mee_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Na i ke rave goe apanung ore sina, na ke pamaisia ngamuga nge ri. Na i ke laupite goe laeala te i ba ke role kerea roma, ");
INSERT INTO mee_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Agau a lonangatakale agau a sana giana basema goe tulaekia e sina a lonapatokona ta giau ka lonangatakala iau. Ba agau a lonangatakala iau ka sana lonangatakala iau mana. Ke sa. I ka lonangatakale Nutu e ba iau bole.” ");
INSERT INTO mee_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nae Ion ke role kae Iesus roma, “Apangalomatanakana, mangng ka kele agau te ore taomalaglage kannu reke sosoali ka gianga, ava i ke sane tatao kala nge mangng kurume one. Minmina na mangng ka role kia ta i nga manenasa kumangng ka ollaeala.” ");
INSERT INTO mee_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Avae Iesus ke role kerea roma, “Manemiausa bongakalange kurumea, agau e kuma ka kumangng e bollau raumana ka giau ke sane totorong ta i kamongpiliu bolvole ba bainga ka pangamologa e soali te iau. ");
INSERT INTO mee_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Iau ka role minmina kurumea, agau e sane sanangkalkala ita ke kalaulau ita. ");
INSERT INTO mee_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ba iau nga role kamiau ka kaomannmannangana roma, ngaroma agau te nge tunge me isunte mana ta miau inunge kurumea ka miau ra ragau rae Karais kanna, na agau laeala ke la ravunge alanga ae i e pe.” ");
INSERT INTO mee_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Bae Iesus ke role kerea bole roma, “Ngaroma agau te nge taoamuga ka goe te nga goe kokorai reke sisina ra loreapatokona te iau ta i kumangng ka bainga e soali nge Nutu raguna. Na agau laeala kana alang e soali ke la bolinglaunga raumana nga alang orae agau a ri ke konapita ka lollo taneke tatamugmuge uit kanna kia nga ganna, na keke tamalilu kia lakallo ta pelau lona ta i mateng. ");
INSERT INTO mee_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ba ngaroma kamang nge utu one ta kumangng ka bainga e soali nge Nutu raguna, na ngo saꞌvatote. Ke pe ta one loangalu ta mauling e momo passavele ka kamang kena. Ava ke soali raumana ngaroma nga kamangme ka ri lua ava te nge utu one ta kumangng ka bainga e soali, na mirang iname karolu ngeke loalu lakallo ta malle a sia e pamiralali passavele.  ");
INSERT INTO mee_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Nga malle laeala a seme ke sane ke matmate ba sia e pamiralalalia ragau ke sane rongrongo. ");
INSERT INTO mee_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ba ngaroma kaeng nge utu one ta kumangng ka bainga e soali nge Nutu raguna, na ngo saꞌvatote. Ke pe ta one loangalu ta mauling e momo passavele ka kaeng kena. Ava ke soali raumana ngaroma nga kaengme ka ri lua ava te nge utu one ta kumangng ka bainga e soali, na ngeke tamalilu ka mirang iname karolu lakallo ta malle a sia e pamiralali passavele.  ");
INSERT INTO mee_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Nga malle laeala a seme ke sane ke matmate ba sia e pamiralalalia ragau ke sane rongrongo. ");
INSERT INTO mee_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ba ngaroma matang kanna nge utu one ta kumangng ka bainga e soali nge Nutu raguna, na ngo tamali kia balakala. Ke pe ta one loangalu ta Nutu kelangpatalingana ka matang kanna kena. Ava ke soali raumana ngaroma nga matang kanname ka ri lua ava te nge utu one ta kumangng ka bainga e soali, na ngeke tamalilu ka mirang iname karolu lakallo ta malle a sia e pamiralali passavele. ");
INSERT INTO mee_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","“‘Nga malle laeala a seme ke sane ke matmate ba sia e pamiralalalia ragau ke sane rongrongo.’ ");
INSERT INTO mee_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nutu ke la ulonge sia nga ragau kinung base ina agau te nge ule poae nga kaning. ");
INSERT INTO mee_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Poae ka ore pe, ava ngaroma mannmannangana nge rongo, na ka la mannmannangana muni mina ngaetai? Miau nga tongamiau kena ma poae e pamannmannapaꞌe kaning, na ngaka palimomomasi kamiau.” ");
INSERT INTO mee_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nae Iesus ke sigipaga ba ke kaꞌe inaeala, na ke loa ta Me Ae Ioran bavana tetoto nga ine ngae Iurea. Ba ragau papatu keke katukala muni te i. Minmina na i ke palomatantana rea kurumea baingana ka kae re pala. ");
INSERT INTO mee_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nae Parisio palu keke atu te i ba keke bai ta avange. Minmina na keke ballage roma, “Bangapagame keke ngatakale agau te ta i pelenge napengana, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nae Iesus ke ala rea roma, “Moses ke tunge pangamologa a taru te miau?” ");
INSERT INTO mee_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nae Parisio nginngina keke role kia roma, “Moses ke ngatakale agau ta i tungnge lau e ture palingravung rea rongana te napengana, na nge baꞌe na nge lao.” ");
INSERT INTO mee_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Avae Iesus ke role kerea roma, “Ka miau ra longasakana raumana, minmina nae Moses ke paꞌe bangapaga laeala. ");
INSERT INTO mee_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ava kapunu mannangana ka inae Nutu koipage orume kinung, na ‘i ke kuma ka agau apanung ba navale’. ");
INSERT INTO mee_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Kurumea ollaeala mana, na apanung nge kaꞌe tamana bae naname, na i nge pagiu kala nge napengana, ");
INSERT INTO mee_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na ri pana lua ka la ri ra mira kena mana’. Minmina na ri pana lua ka sana ri pana lua muni. Ke sa. Ka ri ra mira kena mana. ");
INSERT INTO mee_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Minmina na agau te sane nge saꞌvatote oru ae Nutu pagaotue.” ");
INSERT INTO mee_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ba ka ineke loalu ta bale muni, na barangalele rae Iesus kanna keke ballagapite ta pangamologa laeala mirana. ");
INSERT INTO mee_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Na i ke ala rea roma, “Agau e pelea napengana ave kamapitakama ka avale tetoto ke kumkuma ka bainga e nga kenong kala nga avale a sana i a napengana. ");
INSERT INTO mee_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ba ngaroma avale laeala nge pelea natale ba nge kamapitakama ka apanung tetoto, na i ke kumkuma ka bainga e nga kenong kala nga apanung a sana i a natale.” ");
INSERT INTO mee_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Na ragau keke tatu ka ragoeme te Iesus ta baina i nge ulopaia kamaname nge ri ba nge kava te Nutu te ri. Na barangalele rae Iesus kanna keke role ka ragau nginngina reke tatu ka ragoeme te Iesus ta ri nga manereasa kumangng ka ollaeala. ");
INSERT INTO mee_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ava ka inae Iesus kele oraeala, na ka sana lonape ka barangalele ra kanna ba ke role kerea roma, “Ka ule ragoeme ngeke atu te iau, ba manemiausa bongakala rea. Ta Nutu kelangpatalingana ka orae ragau reke ulopisigi rea muni ma goe kokorai. ");
INSERT INTO mee_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Iau nga role kamiau ka kaomannmannangana roma, ngaroma agau te sane nge ngatakale Nutu kelangpatalingana ma goe te, na agau laeala ke sane la lunga lakallo ngia bavakena.” ");
INSERT INTO mee_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nae Iesus ke laupite goe nginngina te i, na ke ulopaia kamaname nge ri ba ke ballage Nutu te i kavingtulu rea. ");
INSERT INTO mee_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ka inae Iesus pature taongana muni e lola, na agau te ke pira te i ba ke parovanu ngamuga nge i. Na ke ballage roma, “Apangalomatanakana e pe, iau nga meimia ka baingau ta ravunge mauling e momo passavele?” ");
INSERT INTO mee_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nae Iesus ke role kia roma, “Ko meimia o pato iau roma, iau a pe? Ka sana agau te pe, avae Nutu kasikena mana. ");
INSERT INTO mee_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","One ka longomatana ka bangapagame. Keke role roma: ‘One ko sano ngo sapune agau te, ba ko sano ngo keno kala nga avale a sana i a ningpengana, ba ko sano ngo golo, ba ko sano ngo turu goang, ba one sano ngo goaꞌe agau te ta ravunge oru ra kanna, ba one ngo alapagpage tamang bae name.’” ");
INSERT INTO mee_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Na agau laeala ke ale Iesus roma, “Apangalomatanakana, iau ka tataokurumea bangapaga kokorong kinung ka ina sina ta ke lele ikia e sonrau.” ");
INSERT INTO mee_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nae Iesus ke kela te i ka matengraumanangana kia, na ke role kia roma, “Ke pe, ava one ko moro ta oru kena tale. Ngo loa na ngo ba ka oru rae one kinung nga baina one ngo rave lollokanna ki. Na ngo tunge lollokanna nginngina ta ra sillolo. Na one ka la kanga ka oru reke pepe re nga Nutu mallena nga tava. Na ngo atukurume iau.” ");
INSERT INTO mee_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ava ka ina agau laeala longe pangamologa nginngina, na raguna ke so. Na i ke kaꞌe Iesus e loa ka lonataningana ta ka i a akilipukana raumana. ");
INSERT INTO mee_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nae Iesus ke kela ta barangalele ra kanna ba ke role kerea roma, “Ra kilipukana ka baingarea lilli raumana ta ri lunga lakallo ta Nutu kelangpatalingana!” ");
INSERT INTO mee_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na ka ina barangalele ra kanna ke longe Iesus pangamologangana nginngina, na ri keke magio raumana. Avae Iesus ke role kerea muni roma, “Goe rae iau, agau ka baingana lilli raumana ta lunga lakallo ta Nutu kelangpatalingana. ");
INSERT INTO mee_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Posi a kamele te lungana nga bulongpita ore nga sainga masina ke ate raumana nga agau a kilipukana te lungana nga Nutu kelangpatalingana.” ");
INSERT INTO mee_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Na barangalele ra kanna keke magio raumana muni ba keke ballage roma, “Ngaroma minmina, nae Nutu ke la ravunglelenge tai mannangana?” ");
INSERT INTO mee_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nae Iesus ke kela te ri ba ke role kerea roma, “Ragau ka sana likirea ta kumangng ka oraeala bavakena, avae Nutu ke sa. Ta i ka kana ka gingginga ta kumangng ka orume kinung.” ");
INSERT INTO mee_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nae Pita ke role kia roma, “Mangng ka kaꞌe orume kinung ta loangakurume one.” ");
INSERT INTO mee_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nae Iesus ke ale roma, “Iau nga role kamiau ka kaomannmannangana roma, agau e kaꞌe bale ae i, o tataokia memena, o teiteikia memena, o liuna piau memena, o naname, o tamana, o goe rae i, o ura rae i ta loangakurume iau ba pangamologa e pe e te iau, ");
INSERT INTO mee_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ke la ravunge kana oru papatu ngailu muni nga oru nginngina ka kae kokorai re sonrau. Ke la ravunge baleme, ba tataome, ba teiteime, ba liupiaume, ba nameme, ba goeme, ba urame kala nga ragau pangamiralali ngareangana kia. Ba i ke la ravunge mauling e momo passavele ngarume bole. ");
INSERT INTO mee_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ava ragau papatu ra ri re kapunu sonrau, ka la ngarume na ri re ngarume. Ba ragau papatu re ngarume sonrau, ka la ngarume na ri re kapunu.” ");
INSERT INTO mee_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nae Iesus kala nga barangalele ra kanna keke tatao nga pamau patae tae Ierusalem, bae Iesus ke tatao ngamuga nge ri. Ba barangalele ra kanna keke kallo raumana, ba ragau pattoto reke tataokurume rea keke matautau. Nae Iesus ke rave Pana Tangulelu Ba Lua balakala muni. Na i ke paturu ta turung pakerea ka oru reke la leleng nge i ngarume ");
INSERT INTO mee_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ka rolengana kerea roma, “Ita kaka la loangapatae tae Ierusalem, na agau te ke la pulinge Agau Tuna ta re kapunu nga pirisme ba ra pangalomatanakana nga bangapagame kamareame. Na ri keke la kalingnanange, ba keke la roleng ta i nge mate. Na keke la pulinge ta ragau ra sana ri ra Iura kamareame. ");
INSERT INTO mee_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Na ragau nginngina ra sana ri ra Iura keke la rolengpagalising kia, ba utungtaonge, ba sapinge, ba samungpununge. Ava nga kae a mologi ngarume nga matengana, na i ke la sigingpaga nga mateng.” ");
INSERT INTO mee_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nae Iems riluae Ion onra ri ra goe lua ra panung rae Sepeti keke loa te Iesus, na keke role kia roma, “Apangalomatanakana, omea ka matea ta one ngo kuma ka taru a omea la balinglaga one te.” ");
INSERT INTO mee_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nae Iesus ke ballage ri pana lua roma, “Onemea kaka matea ta iau kumangng ka taru te miau?” ");
INSERT INTO mee_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Na keke ale roma, “Omea ka matea ta one ngatangng ta mangng tarang kala nge one nga malleng e nga kelangpatali ngarume. Te nge tara nga bavang e pe ba te nge tara nga bavang a laeva.” ");
INSERT INTO mee_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Avae Iesus ke role kerea roma, “Onemea ka sana lomiaumatana ka taru a miau ka balaglaga iau te. Kaka totorong ta inung nga gato a iau la inung ngia ae? O kaka totorong ta ravunge pangamagoe a iau la ravunge ae?” ");
INSERT INTO mee_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Na ri pana lua keke ale roma, “Mangng ka totorong.” Nae Iesus ke role kerea roma, “Onemea kaka la inung nga gato a iau la inung ngia. Ba kaka la ravunge pangamagoe a iau la ravunge. ");
INSERT INTO mee_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ava ka sana kumangng a kanau ta roleng ta miau tarang nga bavau e pe ba nga bavau a laeva. Tamau ke kalitupe malle nginngina ta ragau ra i mate rea ta ri momong ngi.” ");
INSERT INTO mee_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na ka ina barangalele pattoto rae Iesus kanna ka ri tangulelu ke longe ollaeala, na ri ka sana loreape kae Iems bae Ion. ");
INSERT INTO mee_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nae Iesus ke kiue ri kinung te i, na ke role kerea roma, “Miau ka lomiaumatana roma, ragau ra ra sana ri ra Iura ke pato rea ka kelangpatali rae ri keke umma ta bongatalala rea kalaoka ka kaoreaginapitangana kerea. Ba ravollalaukerea memena keke umma ta barangalele rea ka ginggingngarea. ");
INSERT INTO mee_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ava miau sana ngaka bai minmina. Ke sa. Agau e bai ta leleng i a avolau ngaliua nge miau nga i a akumangngatulu ae miau. ");
INSERT INTO mee_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ba agau e bai ta i e kapunu ngaliua nge miau nge momo ma i a agau te a miau kinung ka baralellea ta i kumangng ka kumangng a kanmiau mana. ");
INSERT INTO mee_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Iau ka role minmina kurumea, ollaeala ka tongana kena mana ma inae Agau Tuna sane atu ta baina ragau ngeke kalaue. Ke sane atu ta agau te kumangng ka kumangnga te te i. Ke sa. I ke atu ta kalaunge ragau, ba ta i tungnge maulingngana ta kolinglelenge ragau papatu nga pulangkala e nga kumangng ka bainga reke sosoali nge Nutu raguna.” ");
INSERT INTO mee_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nae Iesus kala nga barangalele ra kanna keke lele nga maga kunna e bollau ae Ieriko. Ba ngarume, ka ineke lelemalaglaga nga maga kunna laeala kala nga ragau papatu, na agau te akangalungakana lollokanna a giana nge Baratimeus a i a Timeus tuna ke tattara nga pamau bavana. ");
INSERT INTO mee_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ba ka ine longe roma, Iesus e ngae Nasaret ke la kavesinglelea, na i ke paturu ta kiunga kaligi roma, “Iesus! One ae Revit Sivuna! Nga longnanna iau!” ");
INSERT INTO mee_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Na ragau papatu keke mologa kia ba keke role kia ta i rulung. Ava i ke kikiu kaligi raumana muni roma, “One ae Revit Sivuna! Nga longnanna iau!” ");
INSERT INTO mee_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nae Iesus ke maisi ba ke role ka ragau roma, “Ka kiue nasong.” Minmina na keke kiue matasu laeala ka rolengarea kia roma, “Nga longsereng bo sigipaga! I ke kiu one ta loanga te i!” ");
INSERT INTO mee_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Na matasu laeala ke tamalipatali ka lungapaga ae i e ngapotu ba ke tugutaopatae, na ke atu te Iesus. ");
INSERT INTO mee_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nae Iesus ke ballage roma, “Ko bai ta iau maingamia kone?” Na matasu laeala ke role kia roma, “Rabai, iau ka bai ta kelanga muni!” ");
INSERT INTO mee_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nae Iesus ke role kia roma, “Longo loa. Lopatokona ae one te iau ke pape one.” Ba ka pannasa mana na, matana kanname keke pepe, na i ke paturu ta loangakurumea Iesus nga pamau. ");
INSERT INTO mee_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Na ka inae Iesus kala nga barangalele ra kanna ke lele kokoro tae Ierusalem, ba keke lele ngae Betage bae Betani onra ri ra maga kunna lua reke momo kokoro tae Kapoponga Nga Bega Ra Oliv, nae Iesus ke baꞌe barangalele lua ra kanna ");
INSERT INTO mee_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ka potongana kerea roma, “Onemea ngaka loa ta maga kunna laeala e ngamuga nge onemea. Ba nga ina miau nga taolu ngia, na ka panna laeala mana, na kaka la kalingpa ka ronki te a lumangngapau ora agau te sane tarapai kia tale. Ngaka luve, na ngaka atu kia nasai te iau. ");
INSERT INTO mee_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ba ngaroma agau te nge role kamiau roma, ‘Kaka meimia aka luvluve ronki laekolong?’ na miau ngaka role kia roma, ‘Avolau ka kanna ka kumangng kia, ava i ke la bangagaliue nasai bolvole.’” ");
INSERT INTO mee_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ka bainga keke loa, na keke kalipa ka ronki a lumangngapau eke samapite nga bale te kaona kokoro ta pamau. Ba ka ine luvluve, ");
INSERT INTO mee_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","na ragau palu reke meisinsi nga inaeala keke ballaga rea roma, “Kaka meimia aka luvluve ronki laekolong?” ");
INSERT INTO mee_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Na keke ala rea kurumea pangamologa laeala ae Iesus role kerea kia pala, na ragau nginngina keke ngata ta ri ravunge ronki laeala. ");
INSERT INTO mee_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Na keke atu ka ronki laeala a lumangngapau te Iesus. Ba ka ineke palale lungapaga nga ri re ngapotu tapu, na keke unapai rea nga ronki laeala gina. Nae Iesus ke tarapai kia. ");
INSERT INTO mee_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na ragau papatu keke unasilagi ka lungapaga rae ri re ngapotu nga pamau. Ba pattoto keke unasilagi ka bega kamana ra lalaureame onra ri ke saꞌva rea nga urame. ");
INSERT INTO mee_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Na ragau reke tatao ngamuga nge i, ba ne nge ngarume keke kikiu kaligi roma, “Osana!” “Nutu ke kavitulu raumane aekia e atu nge Nutu Avolau giana!” ");
INSERT INTO mee_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Nutu ke kavitulu raumane Revit a sisiukita kelangpatalingana ore tatu!” “Osana te Nutu e momo ngailu raumana!” ");
INSERT INTO mee_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nae Iesus ke lu tae Ierusalem, na ke loalu lakallo ta tempel. Ava kae ke barelulu. Minmina na ka ine kele orume kinung reke momo ngallo nga tempel tapu, na i ke lelemalaga ba ke loa tae Betani kala nga pana tangulelu ba lua. ");
INSERT INTO mee_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Me ngangaila ka ineke kakaꞌe Betani, nae Iesus ka mate kana. ");
INSERT INTO mee_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Na i ke kela lagatauga, na ke kele bega a pik ora lalauname. Minmina na i ke loa ta bega laeala ta kelanga roma, bega laeala ka kanna o ke sa. Ava ka ine lele nga bega laeala, na ke sane kalipa ka kanna panu. Ke sa. Ka lalauname mana kurumea, kae nginngina ka sana ri ra kae re nga bega ra pik ta ri piaunga. ");
INSERT INTO mee_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nae Iesus ke role ka bega laeala roma, “Agau te sane la kaning nge one ka kae te muni!” Ba barangalele ra kanna keke longlonge ine role minmina. ");
INSERT INTO mee_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ba ka ineke lele ngae Ierusalem, nae Iesus ke taolu ta ina re nga tempel na ke paturu ta taongamalagange ragau reke kolkoli beke bava ka orume ngallo nga inaeala. Ba ke bapalipisigi ka pala onrae ragau reke tungugaliliue lollokanna. Ba ke bapalipisigi ka tarang onrae ragau reke bava ka manu ra kulao. ");
INSERT INTO mee_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Na i ke parototokale ragau kinung ta ri nga manereasa atung ka oru reke bava ki lakallo ta ina re nga tempel. ");
INSERT INTO mee_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ba ke paturu ta pangalomatanange ragau ka rolengana kerea roma, “Keke paꞌe Nutu pangamologangana pala ore role roma: “‘Keke la patonge bale ae iau ka bale ora ragau re nga iname kinung ta ri kavang ngia’ Ava miau kaka bai kia ma i a ‘malle a ragolongkana ta ri katungkala.’” ");
INSERT INTO mee_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na ka ina re kapunu nga pirisme ba ra pangalomatanakana nga bangapagame ke longe Iesus pangamologangana laeala, na ri keke paturu ta kelanga ta pamau te ta ri samungpununge ta keke matau. Keke matau kurumea, ka ina maluame ke longe Iesus pangalomatananganame, na keke kallo raumana. ");
INSERT INTO mee_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Na nga ina kae nge barelulu, nae Iesus kala nga barangalele ra kanna ngeke lelemalaglaga nga maga kunna laeala e bollau. ");
INSERT INTO mee_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Me ngangaila ka sinro ka ineke tatao eke lola, na keke kele bega laeala a pik amae Iesus role kia pala. Ba bega laeala ke manani paturu nga kulaname lakailu bavakena ta kunna. ");
INSERT INTO mee_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nae Pita ka lonagaliu ba ke role kae Iesus roma, “Rabai, ngo kele! Bega a pik amo rolea pangamologa e gingging te i ke manani bavakena!” ");
INSERT INTO mee_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nae Iesus ke ale ka rolengana kerea roma, “Nga lomiaupatokona te Nutu. ");
INSERT INTO mee_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Iau nga role kamiau ka kaomannmannangana roma, ngaroma agau te nge role ka kapangng laeo roma, ‘Ngo sigipaga na ngo tugutao lakallo ta pelau,’ ba i sana nga lona lualua ava nga lonapatokona roma, pangamologa laeala a i rolea ke la leleng mannangana, nae Nutu ke la kumangng kia te i. ");
INSERT INTO mee_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Minmina na iau nga role kamiau roma, ngaroma miau nga lomiaupatokona roma, kaka ravutape taru a miau ka ballage Nutu te nga kavang ae miau te i. Na kaka la ravunge ollaeala a miau ka ballage te. ");
INSERT INTO mee_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ba nga ina miau ngaka meisinsi baka kavkava te Nutu ba nga lomiaugaliu ta bainga e soali a agau te kuma kia te miau. Na ngaka osurure agau laeala baingana e soali. Ngaka kuma minmina ta bainae Tamamiau e momo nga mallena nga tava nge osurure bainga re nga longasa te i ra miau ka kumkuma ki bole.  ");
INSERT INTO mee_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ava ngaroma miau sana ngaka osurunre ragau pattoto baingarea reke sosoali, nae Tamamiau e momo nga mallena nga tava sane la osungrurunge bainga re nga longasa ra miau ka kumkuma ki te i bole.” ");
INSERT INTO mee_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nae Iesus kala nga barangalele ra kanna keke lele ngae Ierusalem muni. Ba ka inae Iesus taliliu nga ina re nga tempel, na re kapunu nga pirisme, ba ra pangalomatanakana nga bangapagame kala nga Iurame ravollalaukerea memena palu keke loa te i. ");
INSERT INTO mee_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Na keke ballage roma, “One ko rave gingginga ta one kumangng ka oru kokorai mina ngaetai? Ba tai ke tunge gingginga laekolong te one?” ");
INSERT INTO mee_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nae Iesus ke ala rea roma, “Iau nga ballaga miau ka balinglaga te bole. Ba ngaroma miau ngaka alamasia balinglaga a kanau, na iau bole ka la turung te miau ka tai ke tunge gingginga ta iau kumangng ka oru kokorai. ");
INSERT INTO mee_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ion kumangngana e nga pangamagoe ka puna mina ngaetai? Ka puna nge Nutu e momo nga mallena nga tava, o ka puna nga ragau? Inta role pakau.” ");
INSERT INTO mee_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Na ri keke paturu ta palingpangamologa ngaliua nge ri muni roma, “Ngaroma ita ngaka role roma, ‘Ka puna nge Nutu e momo nga mallena nga tava,’ na i nge ballaga ita roma, ‘Minmina na, ke meimia na ka sana lomiaupatokona te i?’ ");
INSERT INTO mee_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ava ngaroma ita ngaka role roma, ‘Ka puna nga ragau, na’ ....” (Na ravollalau nginngina keke matautaue maluame kurumea, maluame ka loreapatokona roma, Ion ka i a agau te e toe Nutu kaona mannangana.) ");
INSERT INTO mee_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Minmina na ri keke ale Iesus roma, “Mangng ka sana lomangngmatana.” Nae Iesus ke role kerea roma, “Iau bole, ka sana la turung te miau ka tai ke tunge gingginga ta iau kumangng ka oru kokorai.” ");
INSERT INTO mee_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nae Iesus ke paturu ta pangamologa te ri ka pangateningkalame minakai roma: “Ka agau te ke momo, ba i ke kuma ka ura te eke toaꞌe gerepeme ngia. Na ke kavitotokale ura laeala ka savanau a i a lollo. Ba ngallo nga ura laeala i ke kilia lulu te ore nga paꞌtangapelange gerepeme ba kumangng ka uain ngia. Ngarume na i ke kuma ka bale e loa lakailu ore nga agau e ellapatali ta ura laeala. Ka ine kuma ka oru nginngina tapu, na i ke paꞌtaloe ragau palu ta ri kelangpatali ta ura laeala. Na ke loa ta maga te e ngatauga. ");
INSERT INTO mee_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ngarume, ka ina kae e nga lalang ke lele, na i ke baꞌe akumangngatulu te a kanna ta ragau nginngina ra i paꞌtalo rea, ta baina ri ngeke tunge kana kaning palu nga ura laeala. ");
INSERT INTO mee_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ava ra nginngina ra i paꞌtalo rea keke balia akumangngatulu laeala, na keke bagaliumane ka kamana. ");
INSERT INTO mee_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ba ngarume muni na ura tamana laeala ke baꞌe akumangngatulu a kanna te muni, na ke loa. Na keke balia akumangngatulu laeala nga kunna ba keke pavalengea. ");
INSERT INTO mee_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Na i ke baꞌe te muni, na keke sapune akumangngatulu laeala. Minmina na i ke baꞌe ra kumangngatulu papatu, na keke name ka palu ba keke sapune pattoto. ");
INSERT INTO mee_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Na ura laeala tamana ka kanna ka agau kena muni ta i bange. Ka i tuna a i materaumane. Minmina na i ke baꞌe tuna ngarume bavakena te ri ka rolengana roma, ‘Ri keke la longa te tugu.’ ");
INSERT INTO mee_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ava ka ina ragau nginngina ra i paꞌtalo rea ke kele tuna, na ri keke palirole kerea roma, ‘Aekia ka i a ura tamana tuna. Ita ngaka sapune nga baina nga kara ka ura laekia.’ ");
INSERT INTO mee_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Minmina na keke sapune, na keke gulaemalaga kia nga ura.” ");
INSERT INTO mee_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nae Iesus ke ballage reke longlonge pangateningkala laeala roma, “Minmina na, ura tamana ke la maingamia ka ragau nginngina ra i paꞌtalo rea? I ke la atung, na ke la samungpunu rea. Na ke la tungnge ura laeala ta ragau pattoto. ");
INSERT INTO mee_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ke meimia, miau ka sana ka kele pangamologa laeala eke paꞌe pala nga Lau Ae Nutu Kanna ae? Ke role roma, “‘Lollo ama ra popongpita ke tangulelea ke lele i a lollo kena a kana ka gingginga ma maisi e maisgingging ka bale; ");
INSERT INTO mee_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nutu a i a Avolau ke kuma ka ollaeala, na mangng ka kele, na ke pe raumana.’” ");
INSERT INTO mee_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Na ra pangalomatanakana nga bangapagame ba re kapunu nga pirisme ka loreamatana roma, nga pangateningkala laeala i ke rorolea pangamologa e te ri mana. Minmina na keke sissilia pamau ta ri launge ka panna inaeala mana. Ava keke matautaue maluame. Ka baina keke kaꞌe eke lao. ");
INSERT INTO mee_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ngarume na ri keke baꞌe Parisio palu kala nga ragau palu onreke pato rea kae Erotome ta ri launge Iesus ka pangamologanganame. ");
INSERT INTO mee_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Minmina na ragau nginngina keke loa te Iesus, na keke role kia roma, “Apangalomatanakana, mangng ka lomangngmatana roma, pangamologa ra kaning ka kaomannmannangana ki, ba one ko sano matautaue agau te ta ko sano pulia te ngailu nga tetoto. Ke sa. One ko palomatantane ragau kurumea Nutu lonangana mannangana. Minmina na ngo turupaga mangng, one ka longvavai mina ngaetai? Bangapagame keke parototokala ita ta tungnge takisme te Sisa, o ke sa? ");
INSERT INTO mee_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ita ngaka tungtungu rea, o ke sa?” Avae Iesus ka lonamatana roma, keke gogaꞌe ta launge ka pangamologangana mana. Minmina na i ke ballaga rea roma, “Ke maimia aka amva ta launga iau ka balinglaga a kanmiau? Ka atu ka lollokanna te nasorong, nga iau kele.” ");
INSERT INTO mee_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Na keke atu ka lollokanna te te i. Na i ke ballaga rea roma, “Tai ka kannuna ba giana ikia?” Na keke ale roma, “Orae Sisa.” ");
INSERT INTO mee_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nae Iesus ke role kerea roma, “Ngaka ale oru rae Sisa kanna te Sisa, ba ngaka ale oru rae Nutu kanna te Nutu.” Na ka ineke longe Iesus alangana laeala, na keke kallo raumana. ");
INSERT INTO mee_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nae Sarusi palu keke atu te Iesus ta ri balinglagange ka balinglaga te. Ka ri ra ragau ra sana loreapatokona roma, reke mate keke la sigingpaga nga mateng muni. Minmina na ri keke role kae Iesus roma, ");
INSERT INTO mee_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Apangalomatanakana, pala nae Moses ke paꞌe pangamologa ore role kamangng roma, ngaroma apanung te tataokia nge matepatalia napengana ba ka sana nerea goe, na apanung laeala teiteikia nge ravupaga ka avale laeala ta baina tataokia nga nena ka goe nge i. ");
INSERT INTO mee_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na ngo kele. Ka pana lima ba lua ra panung ra ri ra koli keke momo. Ba ri ka tamarea kena. Na ne kapunu ke kamapitakama ka avale te, ava ri pana lua ka sana nerea goe. Ngarume na apanung laeala ke mate. ");
INSERT INTO mee_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Na ngarume na, na lua ke ravupaga ka avale laeala, ava ri pana lua ka sana nerea goe. Na apanung laeala ke mate. Na na mologi ka tongana kena mana. ");
INSERT INTO mee_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Minmina na mateng ke rongo ka pana lima ba lua nginngina ra koli kinung, ba ri kinung ka sana nerea goe. Na ngarume bavakena, na avale laeala ke mate bole. ");
INSERT INTO mee_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Minmina na nga kae e nga sigingpaga nga mateng ngarume, na tai mannangana ka la napengana nga avale laeala kurumea, ri pana lima ba lua ra koli kinung keke kamapitakama kia?” ");
INSERT INTO mee_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nae Iesus ke role kerea roma, “Miau ka sana lomiaumatana ka pangamologa reke momo nga Lau Ae Nutu Kanna, ba ka sana lomiaumatana kae Nutu ginggingngana bole. Minmina na miau kaka taopa. ");
INSERT INTO mee_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Iau ka role minmina kurumea, ngarume, nga ina reke mate ke la sigingpaga nga mateng, na ri ke sane ke la kamangapitakama. Ba ke sane ke la palingtunga rea ta ri kamangapitakama bole. Ke sa. Ri ka la tongarea kena ma anggelo reke momo nga Nutu mallena nga tava. ");
INSERT INTO mee_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ava nga sigingpaga nga mateng, miau ka sana ka kele pangamologa laeala nga lau ae Moses paꞌe pala ae? Nga pangamologa inaeala ore role ta bega a sia lele ngia Nutu ke role kae Moses roma, ‘Ka iau ae Nutu ae Abaram, bae Aisak, bae Iekop.’ ");
INSERT INTO mee_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Minmina na ka sana i ae Nutu orae ragau reke mate. Ke sa. Ka i ae Nutu orae ragau reke mauli. Miau kaka taopa bavakena!” ");
INSERT INTO mee_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na agau te apangalomatanakana nga bangapagame ke atu, na ke longe Iesus kala nga Sarusime ka ineke pantente ka pangamologa. Ba i ke kelapatokone inae Iesus alamasia pangamologa ra kanrea. Minmina na i ke ballage Iesus roma, “Bangapaga a taru ke bollau raumana nga bangapagame kinung?” ");
INSERT INTO mee_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nae Iesus ke ale roma, “Bangapaga e bollau raumana ka i a bangapaga laeala inae Moses role pala roma, ‘Miau re ngae Israel, ngaka longo nasai! Avolau a i ae Nutu ae ita ka i kena mana. Ka sana Avolau te muni. ");
INSERT INTO mee_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Minmina na one ngo materaumane Avolau a i ae Nutu ae one ka long iname kinung, ba ka longmatenganame kinung, ba ka longmatananganame kinung, ba ka gingging ngangame kinung.’ ");
INSERT INTO mee_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ba na lua ke role minakai roma, ‘One ngo materaumane agau tetoto basema ino materaumana one muni.’ Ka sana bangapaga te bollau muni nga bangapaga lua nginngina.” ");
INSERT INTO mee_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Na agau laeala apangalomatanakana nga bangapagame ke ale Iesus roma, “Apangalomatanakana, pangamologa laeala a kaning ka kaomannmannangana kia ino role roma, Nutu ka i kena mana ba ka sana Nutu te muni. ");
INSERT INTO mee_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ba agau nge materaumane ka lona iname kinung, ba ka lonamatananganame kinung, ba ka ginggingnganame kinung, ba nge materaumane agau tetoto basema ine materaumane i muni. Bangapaga lua nginngina keke bollau raumana nga tungame kinung ra ragau ke raupitpita rea ba posime kinung onreke balvali rea beke tungtungu rea ma tunga te Nutu.” ");
INSERT INTO mee_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Na ka inae Iesus kele ina agau laeala ale basema agau a lonamatanakana, na i ke role kia roma, “One ko sano momo ngatauga nga Nutu kelangpatalingana.” Ba ngarume nga kae laeala, na ragau kinung keke matau ta ri balinglagange Iesus ka balinglaga palu muni. ");
INSERT INTO mee_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Na ka inae Iesus palomatantane ragau nga ina re nga tempel, na i ke ballaga rea roma, “Ke meimia, na ra pangalomatanakana nga bangapagame keke patpatoe Karais roma i ae Revit sivuna? ");
INSERT INTO mee_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pala nae Revit muni ke role kurumea Kannu E Tupu taongamugangana kia roma: “‘Nutu a i ae Avolau ke role kae Avolaukau roma: “One ngo tara nga bava nga kamau e pe nga malle a alangpaga ta nge lele nga kae laeala ina iau la ulongpisiginge reke baiꞌiu kone ngape nga kaeng sianame.” ’ ");
INSERT INTO mee_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Revit muni ke patoe agau laeala kae Avolaukia. Minmina nae Karais ka i ae Revit sivuna mana mina ngaetai?” Iesus ke role minmina, ba malua laeala e bollau ka loreasereng raumana ta longnge pangamologanganame. ");
INSERT INTO mee_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ba ka inae Iesus palomatantane ragau, na i ke rorole kerea roma, “Ngaka ella miau masi ta ra pangalomatanakana nga bangapagame. Ri keke materaumana ta taongataliunga ka lungapaga re ngapotu onreke gavili ta roleng roma, keke ngailu nga ragau pattoto. Ba keke matea ta ragau alangapaga rea nga malle nge nga katungkala. ");
INSERT INTO mee_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ba keke matea ta tarang nga tarangapai re kapunu ngallo nga bale nga sinagog ba nga malle re nga alangpaga nga kaning reke bollalau. ");
INSERT INTO mee_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ba ri ka kaoreaginapitpite ra bale ra nareatale memena ke matepatali rea ta ravunge bale nga ri. Ba keke bavai ka kavanga reke gavili ta baina ragau pattoto ngeke longo rea na ngeke kinpataea giareame. Minmina nae Nutu ke la tungnge alang e soali raumana te ri. Ba alang e soali laeala ke la bolinglaunga raumana nga alanga e soali orae ragau pattoto onre sane ke kuma minmina.” ");
INSERT INTO mee_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nae Iesus ke tara kokoro ta malle a ragau ke pullulue lollokanna re nga tunga rea te Nutu ngia ngallo nga tempel. Na i ke elle malua ineke pullulue lollokanna ra kanrea nga malle laeala. Ba ra kilipukana papatu keke pullulue lollokanna papatu. ");
INSERT INTO mee_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Na avale te a sillolo ora natale matepatalia ke atu, na i ke pullue lollokanna lua ra kopa onreke sisina. Ba lollokanna nginngina kunrea ke sina raumana. ");
INSERT INTO mee_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Minmina nae Iesus ke kiue barangalele ra kanna te i, na ke role kerea roma, “Iau nga role kamiau ka kaomannmannangana roma, avale laeala a sillolo ora natale matepatalia ke pullue lollokanna papatu raumana nga ragau kinung onreke pullue lollokanna nga malle e nga pulinglunge lollokanna ngia. ");
INSERT INTO mee_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Iau ka role minmina kurumea, ri ka kanrea lollokanna papatu ba keke tunge palu mana, ava kanrea lollokanna papatu keke momo tale. Ava avale laeala ka kanna lollokanna tutuna nga koling kaning ba ke pullue ri kinung.” ");
INSERT INTO mee_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Na ka inae Iesus lelemalaglaga nga tempel, na te e nga barangalele ra kanna ke role kia roma, “Apangalomatanakana, ngo kele lollo reke bollalau raumana ba bale papaena reke pepe raumana!” ");
INSERT INTO mee_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nae Iesus ke ale roma, “One ko kelapa ka bale kokorai reke pepe beke bollalau raumana ae? Ngarume na ka sana la lollo te nakai nge kenopai nga tetoto. Keke la gulaengapisigi ki kinung lagape.” ");
INSERT INTO mee_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ngarume, ka inae Iesus tattara nga Kapoponga Nga Bega Ra Oliv ba ke kelkela ta tempel ore momo nga ruvu bavana tetoto, nae Pita bae Iems bae Ion kala nge Anru keke loa te i ine momo mana me i, na keke ballage roma, ");
INSERT INTO mee_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Onto role paka mangng, oru nginngina ramo role tao pala ke la leleng nga pia? Ba mangng ka la kelange killa a taru, na nga lomangngmatana roma oru nginngina keke kokoro ta ri leleng mannangana?” ");
INSERT INTO mee_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nae Iesus ke ala rea roma, “Ngaka ella miau masi ta baina agau te sane nge pataopa miau. ");
INSERT INTO mee_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Iau ka role minmina kurumea, ragau papatu keke la ri atung nga giau, na keke la kumangng ta roleng roma, ‘Ka iau a agau laeala ae Nutu patokala pala ta i bange.’ Ba keke la pangataopange ragau papatu. ");
INSERT INTO mee_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ba nga ina miau ngaka longe maimai re nga baling reke bollalau ba pangamologa re kalaoka re ta baling reke bollalau, na sana ngaka matau. Ka kaomannmannangana, oru nginngina keke la leleng, ava ollaeala ka sana la mirana roma, momong gunguna ke lele tapu. ");
INSERT INTO mee_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Iau ka role minmina kurumea, galiau te ke la loanga ta baling kala nga galiau tetoto, ba re nga kelangpatali te keke la loanga ta baling kala nga re nga kelangpatali tetoto. Ba ka la oru giongana tatana reke bollalau, ba osangana reke bollalau nga iname bole. Ava oru nginngina kinung ka la ri ra oru pangaturungana mana ma ina avale te nge paturu ta kaningmainge mirana lalinganame ine bai ta toangapisiginge goe. ");
INSERT INTO mee_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ava miau ngaka ella masi te miau kurumea, ragau keke la ri ulongo miau nga kalingnaname, ba keke la sapingi miau ngallo nga sinagogme. Ba miau kaka la maising ngamuga nga gavaname ba kelangpatalime kurumea loangakurume ngamiaungana kau. Kaka la kumangng minmina ta baina miau ngaka turupote lopatokona ae miau te iau te ri. ");
INSERT INTO mee_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ragau rae iau keke la pulingmalagange pangamologa e pe e te iau ta ragau re nga iname kinung tapu, na momong gunguna ke la leleng. ");
INSERT INTO mee_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ba nga ina ri ngeke lau miau ba ngeke loa kamiau ta kalingnana, na pala ta miau loanga na sana ngaka lomiaupupu roma, ‘Ita ka la maingamia ka rolengara?’ Ke sa. Ngaka rolea taru ae Kannu E Tupu tunge te miau ka panna laeala ta miau ka sana ka la pangamologa. Ke sa. Kannu E Tupu ke la pangamologa. ");
INSERT INTO mee_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ba apanung kolingana ke la ulonge ta ragau ta ri samungpununge. Ba goe tamana ke la kumangng minmina ka goe laeala ae i. Ba goeme keke la sigingpagakalange tamarea ba nareamemena na keke la ulongo rea ta ragau ta ri samungpunu rea. ");
INSERT INTO mee_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ba ragau kinung keke la baingaꞌiu kamiau kurumea lopatokona ae miau te iau. Ava agau e momo gingging ta nge lele nga kae a ronga ka la i a agau a Nutu la ravunglelenge. ");
INSERT INTO mee_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ava nga ina miau ngaka kele ‘ollaeala a mukuna raumana ore baia iu nge Nutu ne bai kia ta i baingasoalinge tempel’ ine nge maisinsi nga malle e parototokala ta i momong ngia, na agau e kele pangamologa laeala ameke paꞌe pala nga lonamatana masi. Na ragau reke momo ngae Iurea nga kae laeala ngeke ka ta kapangngme. ");
INSERT INTO mee_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ba agau e momo nga bale bilingana e ngailu sane nge sopisigi ta bale bilingana e ngape ta ravunge oru nga kanna reke momo nga malle laeala. Ke sa. Nge ka bolvole. ");
INSERT INTO mee_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ba agau e momo nga ura sane nge kagaliu ta bale ae i ta ravunge lungapaga ae i e ngapotu. ");
INSERT INTO mee_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kae nginngina keke la ri isongpa raumana ta ravale ra siarea ba ta ravale reke pasisiue goe rae ri ra lagalaga. ");
INSERT INTO mee_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ava ngaka kava te Nutu ta oru soalingana laeala sane nge lele nga kae reke marusu. ");
INSERT INTO mee_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Iau ka role minmina kurumea, maenang laeala ore la leleng nga kae nginngina ka la i a maenang tanakena. Ke la bolinglaunga raumana nga maenangme kinung paturu ka inae Nutu koipage mogalo laekia e ngape pau ta ke lele nga kae laekia e sonrau. Ba ngarume nga maenang laeala, na ka sana la maenang te e bollau muni nga naeala bole. ");
INSERT INTO mee_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ba taroma Nutu sane te pamore kae nginngina re ngarume, na ragau kinung teke sanrea. Ava i ka la lonananne ragau rae i ra i toro rea te i, minmina na i ke la pangamoronge kae nginngina. ");
INSERT INTO mee_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Na ngaroma agau te nge role kamiau nga kae nginngina roma, ‘Ngaka kele, Karais ikia!’ o ‘Ngaka kele, Karais iala!’ na sana nga lomiaupatokona ta pangamologa a kanna. ");
INSERT INTO mee_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Iau ka role minmina kurumea, Karais ra goanga ba poropet ra goanga keke la leleng ka kae nginngina. Ba ri keke la kosining ka killa ba kumangng reke bollalau raumana ta baina ri ngeke pataope ragau. Avae Nutu sane la ngatangngkale kumangng nginngina ta ri pangataopange ragau rae i ra i toro rea te i. ");
INSERT INTO mee_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Minmina na ngaka ella masi te miau. Iau ka umma ta turunglomatana pakamiau ta orume kinung pala ta ri leleng. ");
INSERT INTO mee_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ava nga ina maenang reke la leleng nga kae nginngina ngeke rongo tapu na, “‘Kae matana ka la osuguna, ba inna ke sane la talanga muni; ");
INSERT INTO mee_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ba matame keke la pupungpisigi nga tava lagape, bae Nutu ke la baingamatagange oru reke gingging raumana reke momo nga tava.’ ");
INSERT INTO mee_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Na ri keke la kelange Agau Tuna ine nge tatu nga mukmukua ka ginggingngana e bollau ba olamana ae i e bollau raumana ore toakala. ");
INSERT INTO mee_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Na i ke la bange anggelo rae i ta ravungkinunge ragau rae i ra i toro rea onreke momo nga iname kinung ngape nga tava. ");
INSERT INTO mee_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ngaka rave lomatana nga bega a pik minakai roma: nga ina bega a pik supungana ba launa ra pau ngeke lele tapu, na nga lomiaumatana roma, kaepa ke kokoro. ");
INSERT INTO mee_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Minmina mana, na nga ina miau ngaka kele oru nginngina kinung rama iau role tao, na nga lomiaumatana roma, Agau Tuna atungana ke lele kokoro. Ke atu kokoro mannangana. ");
INSERT INTO mee_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Iau nga role kamiau ka kaomannmannangana roma, ragau reke momomauli sonrau keke la momongmauli tale, na keke la kelange oru nginngina kinung ama iau role tao lelengarea. ");
INSERT INTO mee_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tava ba mogalo keke la ronga, ava pangamologa ra kanau ke sane ke la ronga. ");
INSERT INTO mee_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ava sana agau te lonamatana ka kae a taru ba kae matana a taru ina oru nginngina ke la leleng. Anggelo reke momo nga Nutu mallena nga tava ka sana loreamatana, bae Nutu Tuna ka sana lonamatana bole. Avae Nutu kasikena ka lonamatana. ");
INSERT INTO mee_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Minmina na miau ngaka momo ba ngaka kelkela kurumea, ka sana lomiaumatana roma, kae ae Nutu pulia ta i kumangng ka oru nginngina ke la leleng nga pia. ");
INSERT INTO mee_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ollaeala ka tongana kena ma agau avolau e bai ta taonga ta inte ngatauga. Ba pala ta i kange bale ae i, na i ke pulia ra kumangngatulu ra kanna ta ri kelangpatali ta orume. Ke tunge kenakena kumangng a kanna te i, ba ke role gingging ka agau e ella ta bale kaona ta i nge ella masi. ");
INSERT INTO mee_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Minmina mana na miau bole ngaka momo ba ngaka kelkela kurumea, ka sana lomiaumatana roma, bale tamana ke la atung nga pia. Ka sana lomiaumatana roma, i ke la atung ka laio, o ka rigo luana, o nga ina kukulega nge toako, o ka sinro luluna, o ke sa. Ka sana lomiaumatana. ");
INSERT INTO mee_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ke sane pe ngaroma i nge lelepita miau bolvole, na nge kalipa kamiau ina miau ka kenrarau. ");
INSERT INTO mee_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Iau nga role ka ragau kinung ka pangamologa a iau rorole kamiau kia roma, ‘Ngaka momo ba ngaka kelkela!’” ");
INSERT INTO mee_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Na kae reke bollalau onreke pato rea ka Paska ba Kaning E Bollau E Nga Berete A Sana Kana Isi keke lele kokoro. Ba ka kae lua pala nga kae nginngina reke bollalau, na re kapunu nga pirisme kala nga ra pangalomatanakana nga bangapagame keke sissilia pamau ta ri launge Iesus gome mana ba samungpununge. ");
INSERT INTO mee_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Keke bai ta launge gome mana kurumea, keke rorole roma, “Ita sana ngaka laue ka kae re nga kaning e bollau ta ragau ngeke baiꞌiu kalaoveka.” ");
INSERT INTO mee_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ba ka inae Iesus mommo nga maga kunna ae Betani nga bale ae Saimon te eke patoe ka akalangamugmugukana, ba ke tattara ka bongapaikalanganakia ta kaning nga pala, na avale te ke rave gato a lollo ora saulang a koina lolo ba a kunna bollau raumana ke momolu ngia, na ke loa te Iesus. Ka i a saulang eke kuma kia ka bega oreke patoe ka “nara”. Na avale laeala ke golue gato laeala ba ke kelingia saulang nge Iesus kunna. ");
INSERT INTO mee_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ava ka ina ragau palu reke momo ke kele ollaeala, na ri ka sana loreape ka kumangng laeala. Ba keke palibalaglaga rea roma, “Ke meimia, na ke rongomana ka saulang laeala? ");
INSERT INTO mee_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Taroma te ba kia, na te rave lollokanname ka ri 300 ba palu muni ta tunga rea ta ra sillolo.” Ba keke umma ta mologang ka avale laeala. ");
INSERT INTO mee_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Avae Iesus ke pavokala rea roma, “I momo. Kaka meimia aka umma ta mologang kia? I ke kuma ka bainga e pe te iau. ");
INSERT INTO mee_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Iau ka role minmina kurumea, ra sillolo keke mommo kala nge miau ka kaeme kinung ta miau kalaunga rea kurumea lomiaungana mana, ava iau sana la momong kala nge miau ka kaeme kinung. ");
INSERT INTO mee_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Avale laekia ke matea ta kalaunga iau. Minmina na i ke kelingia saulang laekia a koina lolo nga mirau ta kalingtupu iau nga talungau. ");
INSERT INTO mee_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Iau nga role kamiau ka kaomannmannangana roma, nga iname kinung nga mogalo laekia e ngape reke la pulingmalagange pangamologa laekia e pe e te iau ngi ngarume, keke la turunglomatana ta avale laekia kumangngana bole ta baina ragau nga loreagaliu te i.” ");
INSERT INTO mee_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Na te e nga Pana Tangulelu Ba Lua, ora giana nge Iuras Iskariot, ke loa ta piris re kapunu ba ke role kerea ta i nge ule Iesus nga kamareame. ");
INSERT INTO mee_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na ka ina piris nginngina ke longe Iuras pangamologangana laeala, na ri ka loreasereng raumana. Ba keke patokala ta ri tungnge lollokanna palu te i. Minmina nae Iuras ke ella ta pamau te ta i ulonge Iesus nga kamareame. ");
INSERT INTO mee_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na ka kae e kapunu nga kae re nga Kaning E Bollau E Nga Berete A Sana Kana Isi ineke balvalia sipsip goekia e nga Paska, na barangalele rae Iesus kanna keke loa te i, na keke ballage roma, “Ko matea ta mangng kalingtupunge orume ta one kaninge kaning e nga Paska nga ine ngaetai?” ");
INSERT INTO mee_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nae Iesus ke baꞌe barangalele lua ra kanna ka rolengana kerea roma, “Onemea ngaka taolu tae Ierusalem, na kaka la kalingpa ka apanung te e paupaue gato ora me momolu ngia. Ngaka loakurumea apanung laeala ");
INSERT INTO mee_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ba nga ine nge lu lakallo ta bale te, na onemea ngaka role ka bale laeala tamana roma, ‘Apangalomatanakana ke ballaga roma: Bale bilingana ore nga iau kaninge kaning e nga Paska kala nga barangalele ra kanau ka i aetai?’ ");
INSERT INTO mee_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Na bale laeala tamana ke la pangapanaunge onemea ka bale bilingana te e bollau e momo ngailu oreke kalitupe oru re nga tarang ba kaning ngia tapu. Ngaka kalitupe orume ta ita kaning nga inaeala.” ");
INSERT INTO mee_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na barangalele nginngina rae Iesus kanna keke loa, na keke kelapa ka orume ina tongarea kena mana ma inae Iesus role kerea pala. Minmina na keke kalitupe kaning e nga Paska nga inaeala. ");
INSERT INTO mee_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ka ina kae barelu tapu, nae Iesus kala nga Pana Tangulelu Ba Lua keke lele. ");
INSERT INTO mee_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ba ka ineke tattara ka bongapaikalangarea kerea ta kaning nga pala, na i ke role kerea roma, “Iau nga role kamiau ka kaomannmannangana roma, te e nge miau ke la ulongo iau nga reke la baingasoali iau kamareame—ka i a te e nge miau raka kaninni kala nge iau.” ");
INSERT INTO mee_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ka ineke longe pangamologangana laeala, na ri ka loreatani raumana. Na kenakena nge ri ke ballage roma, “Avolau, iau ke sa ae?” ");
INSERT INTO mee_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nae Iesus ke ala rea roma, “Ka i a te e nge miau ra Pana Tangulelu Ba Lua. Ka i a te e nge miau raka kalalue beret nga kato kala nge iau. ");
INSERT INTO mee_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ka kaomanna. Agau Tuna ke la mateng kurumea pangamologa e te i a ri ke paꞌe pala, ava oru reke sosoali raumana keke la leleng nga agau laeala e ule nga reke bai ta baingasoalinge kamareame! Te pe nga apanung laeala taroma naname sane te toapisigia.” ");
INSERT INTO mee_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ka ineke kaninni, nae Iesus ke rave beret, na ke kalapage Nutu ba ke regipale beret laeala. Na ke tunge te ri ka rolengana kerea roma, “Ngaka rave. Beret laekolong ka i a mirau.” ");
INSERT INTO mee_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Na i ke rave gato te e ponu ka uain, ba ka ine kalapage Nutu tapu, na i ke tunge gato laeala te ri. Na ri kinung keke inu nga gato laeala. ");
INSERT INTO mee_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Na i ke role kerea roma, “Uain nga gato laekolong ka i a totogu ore nga piunga ba bonga a Nutu la kumangng kia. I ke la kengalingia totogu ta kalaungapage ragau papatu. ");
INSERT INTO mee_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Iau nga role kamiau ka kaomannmannangana roma, iau ka sana la inunge uain muni ta nge lele nga kae laeala nga inungau a pau ka uain nga Nutu kelangpatalingana ngarume.” ");
INSERT INTO mee_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ba ka ineke baue baunga te a kalangapaga tapu, na keke lelemalaga nga maga kunna e bollau ba keke loa ta Kapoponga Nga Bega Ra Oliv. ");
INSERT INTO mee_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nae Iesus ke role kerea roma, “Miau kinung kaka la kanga iau. Iau ka role minmina ta pala, na ri keke paꞌe pangamologa e role roma: “‘Iau ka la balinge kelangapatali ae sipsipme, na sipsip rae ae i keke la kanga kalaoveka.’ ");
INSERT INTO mee_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ava ngarume, ka ina iau nga sigipaga nga mateng tapu, na iau ka la loanga pala nge miau tae Galili.” ");
INSERT INTO mee_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Avae Pita ke ale roma, “Ngaroma ragau kinung ngeke ka one, na iau sana la kanga one.” ");
INSERT INTO mee_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nae Iesus ke role kae Pita roma, “Iau nga role kone ka kaomannmannangana roma, ka rigo laekia mana pala ta kukulega toangako pa lua, na one muni ko la kaulingkala iau pa mologi.” ");
INSERT INTO mee_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Avae Pita ke rorole gingging roma, “Ngaroma otte nge bai kau ta mateng kala nge one, ollaeala bole ke sane la bainga kau ta kaulingkala one.” Ba barangalele rae Iesus kanna kinung keke role minmina bole. ");
INSERT INTO mee_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nae Iesus kala nga barangalele ra kanna keke loa ta malle te eke patoe kae Getsemani. Na i ke role kerea roma, “Miau ngaka tara nakai ta nga rongo ka kavangaungana te Nutu.” ");
INSERT INTO mee_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Na i ke rave Pita bae Ion bae Iems kurumea, na ke paturu ta kaningmainge lotaningngana e bollau ba maenang ngallo nge i. ");
INSERT INTO mee_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Na ke role kerea roma, “Iau ka kanimaimaia lotaningngana e bollau raumana ore bavai kau kokoro ta mateng. Miau ngaka momo nakai, ba ngaka ella kala nge iau.” ");
INSERT INTO mee_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Na i ke loa lagatauga isura nge ri, na ke pupisigi nga mogalo ba ke kava te Nutu roma, ngaroma nga pamau te, na i nge ngata ta miralali e tatu nge kavesilelea. ");
INSERT INTO mee_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ba i ke role roma, “Abba! Tamau! One ka kanga ka gingginga ta kumangng ka orume kinung. Minmina na ngo ravupatali ka gato laekia a miralali nge iau. Ava ka sana matea ta one kumangng kurumea laungana. Ke sa. Ka matea ta one kumangng kurumea longangana.” ");
INSERT INTO mee_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Na i ke loa ta barangalele nginngina ra kanna ka ri mologi, ava ka ine lele nge ri na keke kenrarau. Minmina na i ke role kae Pita roma, “Saimon, ko kenrarau ae? One ko sano gingging ta kelanga kala nge iau ka panna inte mana ae? ");
INSERT INTO mee_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ngaka ella ba ngaka kava te Nutu ta baina miau sana ngaka lele nga avangme. Agau kannuna ka omona, ava mirana ka likinasa.” ");
INSERT INTO mee_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nae Iesus ke loa muni ta i kavang te Nutu, ba kavangana laeala ka tongana kena ma ine kava pala. ");
INSERT INTO mee_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Na i ke galiu muni te ri, ba ka ine lele nge ri na keke kenrarau kurumea, matarea kanname keke rurulu. Ba ri ka sana loreamatana roma, keke la alange mina ngaetai. ");
INSERT INTO mee_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nae Iesus ke loa ka loangana a mologi ta kavang, ba ka ine galiu muni te ri na ke role kerea roma, “Miau kaka kenrarau baka pannpanna kamiau tale ae? Ka rong kenangangarau. Ngaka kele, agau te ke kumkuma gialgiala mana ta i ulonge Agau Tuna nga ra baingareame ke soali kamareame. ");
INSERT INTO mee_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ka sigipaga nga ita lola. Agau e la ulongo iau nga reke la baingasoali iau kamareame ikolong e tatu!” ");
INSERT INTO mee_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ka inae Iesus pamolloga tale, na ka panna laeala mana nae Iuras, a i a te e nga Pana Tangulelu Ba Lua, ke lele. Ba malua e bollau onreke kamopite resalla ra matareame ka ri lua ba butume keke momo kala nge i. Ka ri ra ragau ra piris re kapunu ba ra pangalomatanakana nga bangapagame kala nga Iurame ravollalaukerea memena ke ba rea. ");
INSERT INTO mee_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na agau laeala ore bai ta ulonge Iesus nga kamareame ke tunge killa te te ri pala roma, “Agau a iau la tagungkao kia ka i a agau a miau ka matea. Ngaka laue agau laeala na ngaka loa kia ba ngaka kelalelepatali masi te i.” ");
INSERT INTO mee_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Minmina nae Iuras ke loa tupu te Iesus, na ke role kia roma, “Rabai!” Na ke tagukao kae Iesus. ");
INSERT INTO mee_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Na keke pulia kamareame nge Iesus na keke laue. ");
INSERT INTO mee_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ava ka ina reke lolakurumea Iesus ke kele ollaeala e lele, na te i nge ri ore maisinsi nga inaeala ke ravumalage resalla a kanna a mataname ka ri lua, na ke magala kia nga akumangngatulu ora piris e kapunu kanna. Ba ke saꞌvatote longana. ");
INSERT INTO mee_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nae Iesus ke role ka reke atu ta launge roma, “Kaka meimia aka atu ta launga iau ka resallame ba butume ma iau a agolongkana te? ");
INSERT INTO mee_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ka kaeme kinung, na iau ka mommo kala nge miau ngallo nge tempel ba ka palomatantana, ba miau ka sana ka lau iau. Ava oraekia ke lele ta baina pangamologa reke pa rea pala nga Lau Ae Nutu Kanna ngeke lele mannangana.” ");
INSERT INTO mee_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Na barangalele rae Iesus kanna kinung keke kaꞌe ba keke ka. ");
INSERT INTO mee_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Na agau te a taulai ore sisilipite mirana ka malo mana ke lola kurumea Iesus. Ba ka ineke rapite taulai laeala, ");
INSERT INTO mee_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","na i ke kaꞌe malo ae i, na ke ka ka losokia. ");
INSERT INTO mee_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Na ra nginngina reke laue Iesus keke loa kia ta piris e kapunu. Ba piris re kapunu kinung ba Iurame ravollalaukerea memena kala nga ra pangalomatanakana nga bangapagame keke katukala kinung nga inaeala bole. ");
INSERT INTO mee_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ba pala, ka ineke lola kae Iesus nae Pita ke lolakurume rea bole, ava ke momo ngatauga nge ri isura. Minmina na i ke loakurume rea ta ke lele nga malle ngallo nga savanau ore nga bale ae piris e kapunu. Na ke taolu lakallo ta malle laeala, ba ke tattara kala nga kurtalinglingme. Ba ke mallmallu nga sia. ");
INSERT INTO mee_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na re kapunu nga pirisme kala nga ra nginngina kinung reke taoamugmuga kae Iurame keke kikiue ra turunggoangakana ta ri atung ta turungpaga Iesus kana. Keke kumkuma minmina ta baina ngeke kalipa ka otte ta turungpaga Iesus kana kia, na ngeke sapune. Ava ke sane ke kalipa ka otte. ");
INSERT INTO mee_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Minmina na ra turunggoangakana papatu keke atu ta turungpaga Iesus kana, ava pangamologa nga kanrea ka sana tongarea kena. ");
INSERT INTO mee_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Na ra turunggoangakana panu keke maisi ta turungpaga Iesus kana ba keke role roma, ");
INSERT INTO mee_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Mangng ka longe agau laekolong ine role roma, ‘Iau ka la rurunge tempel laekia ora ragau kamareame ke kuma kia, na nga kaeme ka ri mologi na iau ka la kumangng ka tetoto. Ava ragau kamareame ke sane ke la kumangng ka tempel laeala.’” ");
INSERT INTO mee_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ava pangamologa laeala a kanrea ka sana tongarea kena bole. ");
INSERT INTO mee_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Na piris e kapunu ke maisi ngamuga nge ri, na ke ballage Iesus roma, “Ko la alange pangamologa laeala a kanrea, o ke sa? Pangamologa laekia a ra kokorai ke turupaga kang kia ka kaomannmannangana kia, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Avae Iesus ke rulu mana, ba ke sane ale ka pangamologa inte. Na piris e kapunu ke ballage muni roma, “Ka one ae Mesaia a i ae Nutu e ngailu raumana Tuna, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nae Iesus ke ale roma, “Ka iau a i laeala, ba ngarume na miau kaka la kelange Agau Tuna ine nge tattara nga Nutu a kana ka ginggingame kinung kamana e pe. Ba kaka la kelange ine nge tatupai nga mukmukua reke momo nga tava.” ");
INSERT INTO mee_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Na ka ina piris e kapunu longe pangamologa laeala, na i ke pallamoe lungapaga rae i muni re ngapotu ka iukiangana ba ke ballaga rea roma, “Ke meimia na ita kaka sissilia ragau palu muni ta ri turupotange agau laekia bainganame? ");
INSERT INTO mee_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Miau muni kaka longe gialgiala ine rolebainga kae Nutu. Ka lomiauvavai mina ngaetai?” Na ri kinung ka kanrea pangamologa kena mana roma, “Bainganame keke soali raumana. Ngeke balia na nge mate.” ");
INSERT INTO mee_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Na palu nge ri keke paturu ta utungtaonge. Na keke kangkale matana kanname ka malo inte, ba keke name kia ka kamareame. Na keke rorole kia roma, “Onto bai ma agau e toe Nutu kaona!” Na kurtalinglingme keke rave, na keke tavalvale nga raguna. ");
INSERT INTO mee_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Na ka inae Pita tattara nga malle e ngape ngallo nga bale laeala kana savanau, na malaui te a i a akumangngatulu orae piris e kapunu kanna ke atu. ");
INSERT INTO mee_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ba ka ine kele Pita ine mallmallu, na ke kelananne ba ke role kia roma, “Aekolong, pala na one ko momo kala nge Iesus e ngae Nasaret bole.” ");
INSERT INTO mee_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Avae Pita ke kaulikale ka rolengana roma, “Iau ka sana laumatana ka taru a one rorole te.” Na i ke lelemalaga ta bale laeala kana savanau kaona. ");
INSERT INTO mee_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ba ka ina malaui laeala kele nga inaeala, na i ke role muni ka reke maisinsi nga inaeala roma, “Agau laekolong ka i te e nge ri!” ");
INSERT INTO mee_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nae Pita ke kaulikale muni. Na ka goamomong, na ragau reke meisinsi kokoro keke role kae Pita roma, “Ka one a agau te e nge ri ka kaomannmannangana ta ka one a agau e ngae Galili bole.” ");
INSERT INTO mee_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nae Pita ke paturu ta kaulingkala ka kaona ginangana ba patongkalangana ngailu roma, “Iau ka sana laumatana ka agau laeala a miau ka rorole te!” ");
INSERT INTO mee_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ba ka panna laeala mana, na kukulega te ke toako ka toangakongana a lua. Nae Pita ka lonagaliu ta pangamologa ae Iesus kanna ine role kia pala roma, “Pala ta kukulega toangako pa lua, na one ko la kaulingkala iau pa mologi.” Nae Pita ke tani raumana. ");
INSERT INTO mee_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na ka sinro luluna, na piris re kapunu, ba Iurame ravollalau kerea memena, ba ra pangalomatanakana nga bangapagame kala nga ragau kinung reke taoamugmuga ka Iurame keke palipotopita. Na keke samapite Iesus, na keke loa kia ta ulonge nge Pilatus kamana. ");
INSERT INTO mee_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ba ka ine meisi ngamuga nge Pilatus, nae Pilatus ke ballage roma, “Ka one a kelangpatali ae Iurame, o ke sa?” Nae Iesus ke ale roma, “Ke base ino role.” ");
INSERT INTO mee_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ba re kapunu nga pirisme keke turupagpaga Iesus kana ka pangamologa papatu. ");
INSERT INTO mee_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Minmina nae Pilatus ke ballage roma, “Ko la alanga rea, o ke sa? Ngo kele, keke turupagpaga kang ka oru papatu.” ");
INSERT INTO mee_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Avae Iesus ke sane ale. Ba ka inae Pilatus kele ollaeala, na i ke magio raumana. ");
INSERT INTO mee_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na ka pesingmatana re pala nga kaning laeala e bollau, nae Pilatus ke lolakurumea baingana te na ke ulomalaglage apulangkala kena a maluame ke matea te ri. ");
INSERT INTO mee_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Na agau te eke patoe kae Barabas ke momo nga pulangkala kala nga ragau palu ra sana siareakena ka re kapunu nga gavaman e ngae Rom beke bai ka baling e bollau ngallo nga maga kunna laeala e bollau ka kae te e pala. Bae Barabas a i a te e nge ri ke sapune agau te nga baling laeala. ");
INSERT INTO mee_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Na maluame keke loa te Pilatus, na keke ballage ta i kumangng ka bainga laeala a i kumkuma kia ka pesingmatana re pala te ri. ");
INSERT INTO mee_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Na i ke ballaga rea roma, “Kaka matea ta iau ulongmalagange kelangpatali ae Iurame te miau ae?” ");
INSERT INTO mee_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","I ke role minmina kurumea, i ka lonamatana roma, piris re kapunu keke kelalelea Iesus. Minmina na ri keke ule Iesus nga kamana. ");
INSERT INTO mee_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ava re kapunu nga pirisme keke pasigipage maluame siareame ta ri balinglagange Pilatus ta i ulongmalagange Barabas, avae Iesus nge sa. ");
INSERT INTO mee_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Minmina nae Pilatus ke ballaga rea roma, “Ava iau nga maimia ka agau laekia aka patoe ka kelangpatali ae Iurame?” ");
INSERT INTO mee_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Na ri keke ale ka relingarea roma, “Ngo katupite nga maiskovu!” ");
INSERT INTO mee_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nae Pilatus ke ballaga rea roma, “Ta ke meimia? I ke kuma ka bainga a taru e soali?” Ava ri keke rereli kaligi raumana muni roma, “Ngo katupite nga maiskovu!” ");
INSERT INTO mee_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nae Pilatus ke matea ta loangakurumea maluame loreangana, minmina na i ke ulomalage Barabas te ri. Na ke role ka ra balingkana ta ri sapinge Iesus. Ba ka ineke sapia tapu, na i ke ule nga kamareame ta ri katungpitange nga maiskovu. ");
INSERT INTO mee_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Na ra balingkana keke rave Iesus lakallo ta bale te orae gavaman e ngae Rom (eke patoe kae Praetorium). Na keke kiue ra balingkana kinung re ngae Rom reke momo nga inaeala ta ri katungkala kinung. ");
INSERT INTO mee_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Na keke palupage Iesus ka lungapaga e ngapotu ore belveloga. Ba ka ineke lule oalo a matana ma i a kurung orae kelangpatali te tapu, na keke patutale nga kunna. ");
INSERT INTO mee_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Na keke paturu ta rolengpagalising kia roma, “One ae Kelangpatali ae Iurame, ko ngailu raumana!” ");
INSERT INTO mee_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Na keke balvalia gilina bagana ka bega kalkanna te, ba keke untutaoe. Ba keke parovanvanu ngamuga nge i. ");
INSERT INTO mee_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ba ngarume, ka ineke rolepagalising kia tapu, na keke palale lungapaga laeala e ngapotu ore belveloga, ba keke palupage ka lungapaga rae i muni. Na keke loa kia ta katungpitange nga maiskovu. ");
INSERT INTO mee_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Na ka ineke tatao eke lola, na apanung te e ngae Sairin a giana nge Saimon (a i ae Aleksanrer riluae Rupas tamarea) ke bai ta kavesing rea nga pamau. Ka i a agau ore pa nga ine ngapotu nga maga kunna laeala e bollau ave taolulu ngia. Ba ka ina ra balingkana ke kele, na keke rave ka kaoreaginapitangana kia ta i paunge maiskovu ae Iesus. ");
INSERT INTO mee_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Na ra balingkana nginngina keke loa kae Iesus ta malle te eke patoe kae Golgota (ora mirana roma Malle A Agau Gilina Bagana). ");
INSERT INTO mee_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na keke ava ta tungnge uain eke kampiliue kala nga oru e nga pangamatenge miralali te Iesus. Ava i ke sane inue. ");
INSERT INTO mee_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Na keke katupite nga maiskovu. Ba ka ineke kintoto ta kelanga roma, kenakena nge ri nge rave lungapaga a taru, na keke tavoa ka lungapaga rae Iesus ngaliua nge ri muni. ");
INSERT INTO mee_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Keke katupite Iesus nga maiskovu ka kae matana a lima ba tugulu ka sinro. ");
INSERT INTO mee_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ba keke paꞌe pangamologa eke turupaga kana kia ore role roma: ");
INSERT INTO mee_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ba keke katupite ra golongkana lua nga maiskovume ka kae laeala bole. Keke katupite te nga maiskovu e momo nga Iesus kamana e pe, ba keke katupite te nga maiskovu nga Iesus kamana a laeva.  ");
INSERT INTO mee_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Minmina na pangamologa eke paꞌe pala nga Lau Ae Nutu Kanna ke lele mannangana ine role roma, “Keke pulia kala nga ragau reke longosa ta bangapagame.” ");
INSERT INTO mee_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ba ragau reke kavesillelea inaeala keke rorolebainga kia. Keke lulumatagtage kunreame te i, ba keke rorole kia roma, “Nga! One amo role roma, one la rurunge tempel ba kumangngamuni kia ka kaeme ka ri mologi, ");
INSERT INTO mee_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","onto ravulele one muni ba ngo atupisigi nga maiskovu!” ");
INSERT INTO mee_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ba re kapunu nga pirisme kala nga ra pangalomatanakana nga bangapagame keke kumkuma minmina bole. Keke rorolepagalising kia ngaliua nge ri muni roma, “I ke ravulelea ragau pattoto, ava ka sana likina ta ravunglelenge i muni. ");
INSERT INTO mee_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mesaia laekia a i a kelangpatali e ngae Israel nge atupisigi nga maiskovu gialgiala ta baina ita ngaka kele na nga lorapatokona te i!” Ba ra golongkana nginngina onreke katupita rea nga maiskovume kala nge i keke rorolebainga kia ka rolengbainga kena laeala. ");
INSERT INTO mee_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Na ka ina pula, na osuguna ke gasipite maga iname kinung. Na ka osuguna bavakena ta ke lele nga kae matana a mologi ka laio. ");
INSERT INTO mee_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ba ka kae matana a mologi ka laio, nae Iesus ke kiu kaligi roma, “Eloi, Eloi, lama sabaktani?”, a mirana roma, “Nutu ae iau, Nutu ae iau, ko maimia o ka iau?” ");
INSERT INTO mee_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ba ka ina palu nga ragau nginngina reke meisinsi nga inaeala ke longe Iesus pangamologangana laeala, na keke role roma, “Ke kikiu te Ilaia.” ");
INSERT INTO mee_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Na agau te ke pira, na ke rave otte ba ke parume uain e mamaoga kia. Ba ka ina ollaeala ponu ka uain tapu, na i ke paupite nga bega kamana te. Ba ke kalapataea lakailu te Iesus ta i inunge ka rolengana roma, “Ita ngaka kelapita roma, Ilaia ke la atung ta ravunge lagape, o ke sa.” ");
INSERT INTO mee_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nae Iesus ke kiu kaligi, na ke mate. ");
INSERT INTO mee_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Na malo laeala e bollau eke kone ma i a lengakala ngallo nga tempel ke marae ka rina lua ngailu bavakena ta ina e ngape. ");
INSERT INTO mee_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ba ka ina abalingkana e ngae Rom ore maisinsi ngamuga nge Iesus ke longe Iesus kiungana ba ke kele matengana, na i ke role roma, “Agau laekia ka i a Nutu Tuna ka kaomannmannangana!” ");
INSERT INTO mee_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ba ravale palu keke meisinsi ngatauga isuru ba keke elle oru nginngina reke lele. Te e nge ri ka i ae Maria Magaralene, ba te ka i ae Maria a i ae Iems a taulai riluae Ioses nareame, ba te ka i ae Salome. ");
INSERT INTO mee_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ka ri ra ravale onreke tataokurumea Iesus beke kalaulaue ka orume ka ine momo ngae Galili pala. Ba ravale pattoto ra ri papatu onreke loakurumea Iesus patae tae Ierusalem keke momo nga inaeala bole. ");
INSERT INTO mee_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Na kae laeala ka i a kae orae Iurame nga kalingtupunge oru re nga kae a Sabat. Minmina na ka ina kae barelulu, ");
INSERT INTO mee_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","nae Iosep e ngae Arimatea a i a avolau te e nga reke taoamugmuga ka Iurame ba agau e momalle Nutu kelangapatalingana atungana bole ke kanimaipite mataunga. Na ke loa te Pilatus ba ke palonge ta i ravunge Iesus lavusakia. ");
INSERT INTO mee_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Avae Pilatus ke magio ine longe roma, Iesus ke mate tapu. Minmina na i ke kiue abalingkana e kelalelepatali te Iesus, na ke ballage roma, “Agau laeala ke mate tapu ae?” ");
INSERT INTO mee_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ba ka ina abalingkana laeala turulomatana te i roma, Iesus ke mate tapu, na i ke ngata ta Iosep ravunge lavusa. ");
INSERT INTO mee_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Minmina nae Iosep ke rave malo matana ore pe raumana, na ke ravupisigia Iesus nga maiskovu ba ke lulupite ka malo laeala. Na ke pakenoe ngallo nga baveng e nga talunge agau e mate ngia a ri ke kuma kia lakallo nga lollo. Na i ke patate lollo e bollau ta patangapite baveng kaona kia. ");
INSERT INTO mee_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Bae Maria Magaralene kala nga Maria laeala a i ae Ioses naname keke kele inaeala ae Iosep pakenoe Iesus ngia. ");
INSERT INTO mee_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Na ka ina kae a Sabat rongo tapu, nae Maria Magaralene, bae Maria laeala a i ae Iems naname kala nge Salome keke rave oru ra koirea lolo ta baina ri ngeke saule Iesus lavusakia ki. ");
INSERT INTO mee_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ba ka sinro luluna ina kae lele tapu ka kae e kapunu nga kumangnga maina laeala, na keke tatao eke lola ta baveng. ");
INSERT INTO mee_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ba keke palibalaglaga rea roma, “Tai ke la kalaunga ita ta patangalele patali ka lollo laeala nga baveng kaona?” ");
INSERT INTO mee_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ava ka ineke lele, na keke kele lollo laeala ore bollau raumana eke patapite baveng kaona kia pala ine patalele patali tapu nga baveng kaona. ");
INSERT INTO mee_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ba ka ineke taolu kerea ta baveng lona, na keke kele agau a taulai ine tattara nga bava e ta kamarea e pe. Ba i ka nena ka lungapaga e gavili ore kavauvaunga. Na keke kallo raumana. ");
INSERT INTO mee_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Na i ke role kerea roma, “Sana ngaka matau. Iau ka laumatana roma, miau kaka sissilia Iesus e ngae Nasaret a ri ke katupite nga maiskovu. Ava ke sane momo nakai. Ke sigipaga tapu nga mateng. Ngaka kele malle eke pakenoe ngia pala. ");
INSERT INTO mee_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ava ngaka loa, na ngaka turu paka barangalele ra kanna bae Pita roma, ‘Iesus iale lola pala nge miau lakallo tae Galili. Kaka la kelange nga inaeala base ine role paka miau pala.’” ");
INSERT INTO mee_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Minmina na ravale nginngina keke lelemalaga, na keke kaꞌe baveng laeala ka mammalu ngareangana ba kalinglo ngareangana. Ba ke sane ke ture ollaeala a ri ke kele ta agau te ta keke matau. ");
INSERT INTO mee_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na ka inae Iesus sigipaga nga mateng ka sinro luluna ka kae e kapunu nga kumangnga maina laeala, nae Maria Magaralene ka i a agau e kapunu ta kelange. Ka i a avale laeala orae Iesus taomalage kannume ka ri lima ba lua reke sosoali nge i ka kae te e pala. ");
INSERT INTO mee_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nae Maria ke loa ta ra nginngina reke momo kala nge Iesus pala, ba i ke kalipa kerea ineke tantania Iesus ba ka loreavavai te i, na ke turulomatana te ri. ");
INSERT INTO mee_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ava ka ine turu pakerea roma, Iesus ke mauli ba i ke kele, na ri ka sana loreapatokona ta pangamologangana. ");
INSERT INTO mee_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ba ngarume, nae Iesus ke lele nga pana lua nge ri ka ineke tatao eke lola ta ina e ngapotu nga maga kunna laeala e bollau. Ava mirana ka kelangana toto. ");
INSERT INTO mee_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Na pana lua nginngina keke galiu ta balingarea memena na keke ture ollaeala te ri. Ava ri ka sana loreapatokona ta pangamologangarea bole. ");
INSERT INTO mee_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ba ngarume, nae Iesus ke lele nga Pana Lua Ba Tangulelu ka ineke tattara ka bongapaikalangarea kerea nga pala ta kaning. Na i ke mologa kerea kurumea ina sana loreapatokona ba sana omorea ta longa ta pangamologa rae ra nginngina reke kele ngarume nga sigingpagangana nga mateng. ");
INSERT INTO mee_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ba i ke role kerea roma, “Miau ngaka loa ta iname kinung nga mogalo laekia e ngape, na ngaka pulimalage pangamologa e pe e te iau ta ragau kinung. ");
INSERT INTO mee_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Bae Nutu ke la ravunglelenge ragau kinung ra loreapatokona te iau beke rave pangamagoe. Ava ragau ra sana loreapatokona te iau keke la ravunge alang e soali. ");
INSERT INTO mee_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ba ragau ra loreapatokona te iau keke la kumangng ka killa reke bollalau minakai roma: Keke la taongamalagange kannu reke sosoali nga ragau ka giau; ba keke la pangamologa ka kaling ra ri sana loreamatana ki pala; ");
INSERT INTO mee_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ba keke la ravungpita ka mueme ka kamareame; ba ngaroma ri ngeke inue me a koatali e nga pangamate, na me laeala ke sane la baingasoali rea bavakena; ba keke la ulongpainge kamareame nga ragau ra karea ka soaling, na ragau nginngina keke la penga.” ");
INSERT INTO mee_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ba ka inae Iesus Avolau role kerea minmina tapu, nae Nutu ke ravupataea ta mallena nga tava. Na i ke tara nga Nutu bavana nga kamana e pe. ");
INSERT INTO mee_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Na barangalele rae Iesus kanna keke lelemalaga nga maga laeala e bollau, na keke pulimalage pangamologa rae Nutu kanna ta ragau re nga iname kinung. Bae Iesus Avolau ke kalaulau rea ka ginggingngana. Ba ke pakosining roma, pangamologa laeala ae Nutu kanna a ri ke pulimalaglage ka kaomannmannangana kia ka killa reke bollalau ra ri ke kumkuma ki. ");
INSERT INTO mee_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teopailus, one avolau, ke pala na ragau papatu keke ava ta pallange orume lelengarea ngaliua nge mangnga. ");
INSERT INTO mee_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Keke paꞌe oru nginngina kurumea ragau reke kela rea nga pangaturungarea ka matarea kanname, na keke pulimalage pangamologa. ");
INSERT INTO mee_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Avolau, iau muni ka kelakokore oru nginngina nga pangaturungarea, minmina na iau ka bai ta pallange panganana te te one bole. ");
INSERT INTO mee_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Iau ka paꞌe minmina nga baina one nga longmatana roma, panganana laekia eke panana one kia ka kaomannmannangana kia. ");
INSERT INTO mee_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ka inae Eroto kelapatali ta inaeala eke patoe kae Iurea, na piris te a giana nge Sekaraia ke momo. Ka i a piris e nga galiau ae Abia. Ba napengana ka i e nga ravale barana ae Aron a giana nge Elisabet. ");
INSERT INTO mee_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nge Nutu kelangana ri pana lua momongareangana ke pe. Ba keke loakurumea bangapaga rae i kala nga lonanganame. Ba ragau ke sane ke kele baingarea palu reke sosoali. ");
INSERT INTO mee_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ava ri pana lua ke sana nerea goe kurumea, Elisabet ke sumpi ba bole keke papisigi tapu. ");
INSERT INTO mee_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ka kae te, na galiau ae Sekaraia ke lele ta ri kumangng ka kumangng e nga piris. Ka bainae Sekaraia ke baia kumangng e nga piris nge Nutu raguna bole. ");
INSERT INTO mee_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Na ri keke kumakurumea baingarea e nga kiningtoto ta baina ngeke pulia te e nge ri nga i kapunu nga kumangng. Keke kuma minmina, nae Sekaraia giana ke kenopai ta i lunga ta “tempel” ae Nutu, ba ta i tonge oru ra koirea lolo nga altara. ");
INSERT INTO mee_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na ka ina i patutue sia, na ragau papatu keke katukala nga bale bilingana e ngapotu ba keke kavkava. ");
INSERT INTO mee_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ka kae laeala nae Sekaraia ke kele anggelo ae Nutu ine maisi nga altara e nga tonge oru ra koirea lolo bavana nga kama e pe. ");
INSERT INTO mee_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nae Sekaraia ka lonatangtang ka ine kele, ba ke matau. ");
INSERT INTO mee_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ava anggelo laeala ke role kia roma, “Sekaraia Nutu ke longe kavanga ae one tapu minmina na sono ngo matau. Ba ningpengana ae Elisabet ke la ravunge goe a panung, na ngo patoe giana kae Ion. ");
INSERT INTO mee_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Minmina na nga longsereng ba nga longmarapaga, ba ragau papatu ke la serenga te i nga ine nge lele ");
INSERT INTO mee_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ta giana nge bollau nge Nutu raguna. Ba i nge bai ta loangakurumenge Nutu lonangana, minmina na i ke sene la inunge uain kala nga inungu matantana reke gingging. Bae Kannu E Tupu ginggingngana nge lu nge i nga ine momo ngallo nga naname siana tale. ");
INSERT INTO mee_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ba i ke la ravunggaliunge ragau papatu re ngae Israel te Nutu. ");
INSERT INTO mee_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ba i nge taoamuga nga agau ae Nutu la bange ngarume kurumea Ilaia bainganame ba ginggingngana. Na i nge kampiliue goeme tamarea memena ta loreagaliu ta goe rae ri. Ba i nge kampiliue ra longasakana nga baina ri ngeke loakurumea ra baingareame ke tupu. I ke la kumangng minmina ta i kalingtupunge ragau ta baina ri momongkalange agau laeala atungngana.” ");
INSERT INTO mee_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nae Sekaraia ke ballage roma, “Ava iau ka la laumatanangana ka pangamologa laekolong mina ngaetai roma, pangamologa ka kaomannmannangana kia? Ngo kele, ka iau avolau ba naupengana ka i a pingina tapu.” ");
INSERT INTO mee_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Minmina na anggelo ke ale pangamologa te i roma, “Giau nge Gebriel ba iau ka maisinsi nge Nutu raguna, avae i ke ba iau ta turung pakone ba ulonge pangamologa laekia e pe nge one. ");
INSERT INTO mee_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ava one ka sana longopatokona ta pangamologa ae iau e la leleng mannangana. Na alo ngo rurulu ba sano la pangamologa bavakena ta nge lele nga kae laeala nga ina ollaeala nge lele mannangana.” ");
INSERT INTO mee_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ka ina ragau ke momalle Sekaraia, na ri ka loreatangtang roma, taru ke lele ka baina aekia ke menakinkini ngallo nga tempel. ");
INSERT INTO mee_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ngarume nae Sekaraia ke lelemalaga, ava i ke sane pamolloga. Na sinrea ke kavi roma, aekia ke kele otte ngallo nga tempel ikia baina i ke pamologa ka kamongpiliungana ka kamaname mana. Ba ke sane pamolloga ka kaona. ");
INSERT INTO mee_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ka ine rongo ka kumangng a kanna nga tempel, na ke galiu ta bale ae i. ");
INSERT INTO mee_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ngarume nga kae nginngina na napengana ae Elisabet ka siana, ava i ke momolulu mana ta ka nena inna lima. ");
INSERT INTO mee_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ba i ke rorole roma, “Nutu ka lonananna iau. Na i ke bai kau minakai ta osungrurunge balenga ae iau nga ragau ragurea.” ");
INSERT INTO mee_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet ka nena inna lima ba kena tapu, nae Nutu ke baꞌe anggelo Gebriel ta maga kunna te ngallo ngae Galili a giana nge Nasaret. ");
INSERT INTO mee_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ke loa ka turung te ta avale e sane loa ta apanung te tale a giana nge Maria. Oreke parokale nga apanung a giana nge Iosep a i ae Revit sivuna. Bae Revit ka i a kelangapatali te ngae Israel pala. ");
INSERT INTO mee_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anggelo laeala ke loa te Maria na ke role kia roma, “Nga longmarapaga ta Nutu ke pulia lona te one, ba i ke momo kala nge one.” ");
INSERT INTO mee_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Avae Maria ka lonapalilli raumana, ba ka lonatangtang roma, “Assii! Aekia ke meimia ka rolengana te iau ikia?” ");
INSERT INTO mee_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Na anggelo ke role kia muni roma, “Maria, Nutu ka lonape kone minmina na sano ngo matau. ");
INSERT INTO mee_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","One ka la siang, na ko la toangapisiginge goe a i a panung. Na ngo patoe giana kae Iesus. ");
INSERT INTO mee_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Na ka la giana bolinglaunga, ba keke la patonge kae E Ngailu Raumana tuna. Bae Nutu Avolau ke la tungnge kelangpatali ae sisiukia ae Revit te i. ");
INSERT INTO mee_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ba i ke la kelangapatali ta re ngae Israel passavele, ba kelangapatalingana ka sana nga lisina.” ");
INSERT INTO mee_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nae Maria ke ballage anggelo laeala roma, “Ava ka la nau goe mina laetai ta ka iau a malaui tale?” ");
INSERT INTO mee_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Na anggelo ke ale roma, “Kannu E Tupu ke la atung te one, bae E Ngailu Raumana ginggingngana kana nunule ke la gasingpita one. Minmina mana na goe laeala ta i leleng ngeke patoe ka i a torong. Ba ngeke patoe kae Nutu tuna. ");
INSERT INTO mee_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ba ka longmatana kae Elisabet, ame pala na keke role roma ka i a pingina ba sana la nena goe muni. Ava sonrau na inna lima ba kena rae i keke rongo tapu. ");
INSERT INTO mee_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ke sana otte lilli nge Nutu ta i kumangng kia.” ");
INSERT INTO mee_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Minmina nae Maria ke ale pangamologa te aeala roma, “Iau ka puli iau nga Nutu kamana base ino turu.” Na anggelo ke kaꞌe. ");
INSERT INTO mee_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Na ka kae nginngina nae Maria ke tutapu bolvole mana ta maga te e bollau nga kapopongame ngallo ngae Iurea. ");
INSERT INTO mee_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Na ke lu nga bale ae Sekaraia ba ke serengkale Elisabet. ");
INSERT INTO mee_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Na ka inae Elisabet longe serengakala laeala, na goe ngallo nga siana ke baimataga. Nae Kannu E Tupu ke paponue Elisabet, ");
INSERT INTO mee_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","na ke kiu kaligi roma, “Ka ooo aekolong! Nutu ke kavingtulu one raumana nga ravale pattoto. Ba i ke kavitule goe laekolong ore la leleng nga siang raumana bole. ");
INSERT INTO mee_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Baingau ke meimia ba ka iau a avale e meimia ka bainae Kelangpatali ae iau naname ke atu te iau? ");
INSERT INTO mee_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Na nga turu pakone, ka ina iau longe serengkala ae one maina nga longau, na goe laekia ngallo nga siau ke baimataga ka serenga. ");
INSERT INTO mee_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","One avale ngo sereng, ta ka longpatokona ta ora Nutu turu ta i pangapotange nge one.” Elisabet ke role minmina. ");
INSERT INTO mee_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nae Maria ke role ka serengngana roma: “Ngallo nga logu ke kinangge Nutu giana. ");
INSERT INTO mee_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ba kannugu ke marapagpaga te Nutu a i ae Aravunglelekana ae iau. ");
INSERT INTO mee_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Iau ka sana iau a agau mannangana, avae i ka lona te iau ba ka lonananna iau. Minmina na sonrau ba ngarume bole na ragau kinung ke la ri turunge pangamologa inae Nutu tunge serenga e bollau te iau. ");
INSERT INTO mee_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ta Nutu ora kana ka ginggingame kinung ke kuma ka oru e bollau te iau. Ba giana ka i a torong. ");
INSERT INTO mee_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Lonana ae i ke momo nga ragau reke mataue ka baina keke bai ta longa te i. Ba lonana ae i ke momo nga ra nginngina goe rae ri ba sivurea memena lagarume. ");
INSERT INTO mee_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kumangng reke gingging ke lele nga kamana, ba i ke taoe ragau reke pulia longasa ngallo nga lorea kalaoveka; ");
INSERT INTO mee_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","I ke pulipisigia kelangpatalime, ba ke kinpataea ragau ra sana giarea; ");
INSERT INTO mee_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","I ke paponue ragau ra matekarea siareame ka oru reke pepe, ba ragau ra kilipukana ke ba ala rea ka kamareame mana; ");
INSERT INTO mee_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","I ke kalaue ragau rae i re ngae Israel, ba ka lonagaliu ta lonana ae i, ");
INSERT INTO mee_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","basema ine role ka sisiukita memena pala roma, ‘Ala nga launane Abaram kala nga sivuna memena lagarume passavele.’” ");
INSERT INTO mee_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nae Maria ke momo kala nge Elisabet ka inna mologi, na ngarume ke galiu ta maga ae i. ");
INSERT INTO mee_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Panganana e ngae Ion lelengana ke loa minakai roma: Ka inae Elisabet toapisigi, na ka nena ka goe ora i a panung. ");
INSERT INTO mee_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na ragau re nga maga kunna ae Elisabet ba ragau rae i keke longe pangamologa inae Nutu lonananne, na keke sereng kala nge i. ");
INSERT INTO mee_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ngarume nga ina kaeme ka ri lima ba mologi ke rongo tapu, na keke atu ta ri totongtaliunge goe mirana. Ri keke bai minmina, na ragau ke bai ta ri patonge giana kae Sekaraia base tamana giana. ");
INSERT INTO mee_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ava naname ke bokala ka rolengana kerea roma, “Ke sa. Ita ngaka patoe kae Ion.” ");
INSERT INTO mee_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Na keke role kae Elisabet roma, “Ke sane ke patoe matakone te ka gia laekia tale.” ");
INSERT INTO mee_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Minmina na keke panana ka kamarea te tamana roma, i ke matea gia a taru ta goe. ");
INSERT INTO mee_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Na i ke panana ka kamana ta ri ravunge otte, ta baina nge paꞌe tuna giana. Na ri kinung keke kallo raumana ine paꞌe roma “Giana nge Ion.” ");
INSERT INTO mee_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ka pannasa, nae Sekaraia kaona ke panga ba tengtengkia ke baimantaga muni. Na ke paturu ta pangamologa ba ke kinpataea Nutu giana. ");
INSERT INTO mee_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na ragau re nga maga ae i keke kele ollaeala e lele, na keke matau. Ba pangamologa nga oru nginngina kinung ke loa ta maga nge nga kapopongame ngae Iurea. ");
INSERT INTO mee_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ragau kinung keke longe pangamologa laeala na ka loreamatana roma, gingginga ae Nutu ke momo kala nga goe laeala. Ava keke ballaga roma, “Ngarume na goe laekia ka la i a agau matana e meimia?” ");
INSERT INTO mee_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ka bainae Kannu E Tupu ke paponue goe laeala tamana ae Sekaraia, na i ke pulimalage pangamologa basema i a agau e toe Nutu kaona. Na ke role roma: ");
INSERT INTO mee_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ita ngaka kinpataea Nutu Avolau a i a Nutu orae Israel. Ta i ke atu ta ravunggaliunge ragau rae i. ");
INSERT INTO mee_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ba i ke pamalage Aravunglelekana a ginggingngana raumana te ita ba ka i ae Revit sivuna te; ");
INSERT INTO mee_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","base Nutu ine role pala nga ragau rae kanna kaoreame roma: ");
INSERT INTO mee_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘I ke role ta i ravunglele ita nga reke baisolali ita kamarea ba nga ragau ra siarealalali kita.’ ");
INSERT INTO mee_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Bae Nutu ka lonananna ita base ine role pala ta sisiukita memena, ba i ka lonagaliu ta piunga ba bonga ae i ore tupu mannangana. ");
INSERT INTO mee_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ba i ke patokala te Abaram a sisiukita ta i kumangng kita base ine role. ");
INSERT INTO mee_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ba i ke bai ta ravunggaliu ita nga reke baisolali ita nga kamareame, minmina na ita ra kumangngatulu rae Nutu ngaka kuma ka kumangng a kanna ba ita sana ngaka matau. ");
INSERT INTO mee_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Minmina na nga momongara ka kaeme kinung nga maulingarame, na ita ngaka lolakurumea bainga ngeke pepe nge Nutu raguna. Ba bainga reke pepe ra i mate rea ngeke momo nge ita. ");
INSERT INTO mee_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Minmina na one a goe, ngarume na keke la patongo one ka agau e toe Nutu E Ngailu Raumana kaona. Ta one ko la taoangamuga ka agau ae Nutu la bange ngarume ta salange pamau ae i. ");
INSERT INTO mee_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ba one ko la pangalomatanange ragau rae Nutu, na nga loreamatana roma Nutu ke la ravunglele rea ine nge osurure baingarea reke sosoali. ");
INSERT INTO mee_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nutu ka lonananna ita raumana base avale ora lonananne goe ae i. Minmina na i ke la bange aravunglelekana te te ita, na olamana nge lele nge ita base ma kae lelengana nga tava. ");
INSERT INTO mee_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nutu ke la kumangng minmina ta tungnge olamana ta ragau reke tattara nga osuguna ba nga mateng kana nunule, ta baina ita nga loramatana ka pamau ore nga momongmasi kala nge Nutu.” ");
INSERT INTO mee_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ngarume na goe laeala ke lele bollau ba ke ravumasia potong. Na i ke loa, na ke momo nga ina a sana ragau ngia ta ke lele nga kae laeala nga ina i la lelengmalaga nga Israelme ragurea. ");
INSERT INTO mee_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ka kae nginngina ngarume ngae Ion E Nga Pangamagoe lelengana, na agau e kapunu ngae Rom a giana kae Sisa Augustas ke pulia bangapaga te ta baina gavaman nge rave ragau re nga magame kinung giareame. ");
INSERT INTO mee_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Ollaeala ka i a kae e kapunu ta ri pange ragau giarea nga inaeala. Ba ke lele ka inae Kiurinias kelapatali ta Porovins ae Siria.) ");
INSERT INTO mee_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Minmina na ragau kinung keke kapaligaliu ta maga kunna nga ri ta baina gavaman nge paꞌe giareame. ");
INSERT INTO mee_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nae Iosep ke mommo ngae Nasaret nga ine ngae Galili, ava i ka i e nga balekaina ae kelangapatali te pala ngae Israel a giana nge Revit. Ba magapuna ae Revit a giana nge Betleem ke momo nga ine ngae Iurea. Minmina nae Iosep ke tutapu e kaꞌe maga kunna ae i na ke loa tae Betleem. ");
INSERT INTO mee_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","I ke loa kala nga parongkala ae i ae Maria nga baina gavaman nge paꞌe ri pana lua giarea. Bae Maria ka siana tapu ka kae laeala. ");
INSERT INTO mee_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ka ina ri pana lua keke mommo tale ngae Betleem, na kae ae Maria ta i toangapisiginge goe ae i ke lele. ");
INSERT INTO mee_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Na i ke rave nena ka goe ora i a panung. Ava bale a ragau ke mommo ngia ke ponu tapu. Minmina na i ke lulupite goe laeala ka malome. Na ke pakenoe ngallo nga malle te eke pakankania posi ra marana ngia. ");
INSERT INTO mee_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ba bole, ngapotu nga maga kunna e bollau ngae Betleem ragau palu keke ellapatali ta sipsip nga ri ka rigo. ");
INSERT INTO mee_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Na anggelo te ae Nutu ke atu, minmina nae Nutu lamana ke taliu rea, na ka loreasoali raumana. ");
INSERT INTO mee_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ava anggelo laeala ke role kerea roma, “Sana ngaka matau. Ngaka kele. Iau ka atu ta turunge pangamologa e pe te miau. Ka i a pangamologa ore nga pangaserenge ragau karolu. ");
INSERT INTO mee_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Iau ka role minmina kurumea sonrau, na avale te ke toapisigia Aravunglelekana te miau. Ka i ae Karais a i a Avolau. ");
INSERT INTO mee_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Minmina na miau kaka la kelange killa te roma, miau ngaka kalipa ka bavo te eke lulpite ka malome na keke pakenoe nga malle te eke pakankania maraname ngia.” ");
INSERT INTO mee_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ka pannasa na galiau te e bollau e nga baling onra ri ra anggelo nge Nutu mallena nga tava keke lele eke momo kala nga anggelo laeala. Na keke kinpataea Nutu giana roma, ");
INSERT INTO mee_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ngaka kinpataea Nutu e momo nga malle e ngailu raumana, ba ragau reke momo nakai nga mogalo laekia e ngape nga loreape ta Nutu ka lonape kerea.” ");
INSERT INTO mee_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ngarume nga ina anggelome ke ka rea galiu ta Nutu mallena nga tava, na reke ellapatali ta sipsipme keke palirole kerea roma, “Aiinee! Ka ita loa bolvole tae Betleem nga baina ita ngaka kele ollaeala e lele ae Nutu papanau ita kia tapu.” ");
INSERT INTO mee_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ka baina keke loa bolvole na keke kela pakae Maria ri luae Iosep kala nga bavo ine keno nga malle eke pakankania maraname ngia. ");
INSERT INTO mee_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Na ka ineke kele na keke papote pangamologa a anggelo turu pakerea e ta goe laekia. ");
INSERT INTO mee_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ba ragau karolu reke longe pangamologa keke kallo ina reke ellapatali ta sipsipme ke turu te ri. ");
INSERT INTO mee_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nae Maria ke longe pangamologa nginngina ba ka lonagomgome rea. ");
INSERT INTO mee_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ngarume na reke ellapatali ta sipsipme keke galiu na ka loreamarakale Nutu. Ba keke kinpataea Nutu giana ka oru nginngina reke longo rea beke kela rea ineke lele ma ina anggelo turu pakerea. ");
INSERT INTO mee_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na keke atu ka goe laeala ae Iesus ta ri totongotaliunge mirana ka ina kana kaeme ka ri lima ba mologi tapu kurumea baingarea te. Minmina na keke patoe giana kae Iesus kurumea anggelo patongana ka giana ka ine naname sane siane tale. ");
INSERT INTO mee_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Na ka kae nge nga pangalellepa rea base bangapaga ae Moses ine role keke rong, na tamana ae Iosep ba naname ae Maria keke lopatae kae goe ae Iesus ta tempel ngae Ierusalem ta ri pakelange te Nutu. ");
INSERT INTO mee_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Goe laeala tamana bae naname keke loa kurumea bangapaga ineke paꞌe nga bangapaga ae Nutu kanna roma, “Goe ba posi re kapunu ra panung ra narea memena ke ravu rea ngeke toro rea ta ri kumangng ka kumangng ae Nutu kanna.” ");
INSERT INTO mee_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ba bole, ngeke loa ka manu lua ra kulao o manu matana lua pattoto ra lumangngapau. Ka ri ra posi re nga balingi rea nga baina ngeke tungu rea ma tunga te Nutu kurumea bangapaga a kanna ine role. ");
INSERT INTO mee_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na ka ineke atu ka goe ta tempel na agau te a giana nge Simeon ke momo ngae Ierusalem. Ka i a agau te a bainganame ke tupu, ba ke lola kurumea Nutu lonangana. Ba bole, i ke umma ta momongkalange aravunglelekana ae Israelme. Nae Kannu E Tupu ke lopai nge i ");
INSERT INTO mee_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ba ke rolepage lona tapu roma, pala nga matengana, na i ke la kelange Karais ae Nutu. ");
INSERT INTO mee_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ka bainae Kannu E Tupu ke taoamuga kia, na ke lu lakallo ta tempel. Na ka ina goe laeala ae Iesus tamana bae naname ke lu kia, ");
INSERT INTO mee_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","nae Simeon ke balle ba ke kinpataea Nutu giana roma: ");
INSERT INTO mee_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","“Iala nae Nutu matau kanname keke kele aravunglelekana ae one tapu, ora one role te roma, ragau re nga mira matantaname kinung keke la kelange. Minmina na ke pe ta iau a akumangngatulu ae one mateng nga baina lau nge marapaga base ma ino role pala. ");
INSERT INTO mee_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ka i a olamana te e la tungnge lomatana ta ragau ra sana ri ra Israelme roma, Nutu ikia. Ba ri ngeke kelapatokona roma, Nutu ke kavitule Israelme raumana.” ");
INSERT INTO mee_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nae Iesus tamana bae naname keke longe pangamologa laeala ae Simeon rolea te ri, na keke kallo. ");
INSERT INTO mee_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ka bainae Simeon ke kavitulu rea, na ke role kae Maria a i a goe naname roma, “Ngo long. Nutu ke pulia goe laekia ta pangapunge Israelme papatu, ba pangasigipagange papatu bole. I ke la momong base ma killa te, ba ragau papatu ngeke ketepalele kia. ");
INSERT INTO mee_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ba oru reke kolu ngallo nga ragau papatu lorea keke la leleng nga karakarangana. Ba lolali e base ma resalla a matana ke la paronge long bole.” ");
INSERT INTO mee_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ba bole, avale te orae Nutu kaona a giana nge Ana ke momo. Ka i ae Panuel tuna piau e nga galiau ae Aser. Na avale laeala ka i a pingina ba ke kamapitakama ka ina i a malaui tale. I ke momo kala nge natale ka pesingmatana lima ba lua, na natale ke matepatalia. ");
INSERT INTO mee_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ka baina i ke momo bagaru ta ka nena pesingmataname ka ri giaukaina tugulu ba tugulu. Na pingina laeala ae Ana ke lola ta tempel ka kaeme kinung, ba ke kuriri ta kaning. Ba i ke kavkava e momo, ba ke kalapagpage Nutu ka kaeme ba rigome. ");
INSERT INTO mee_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ka kae laeala bole, na i ke lu ta tempel ba ke atu kokoro ta goe laeala ae Iesus. Na ke kalapage Nutu ba ke pulimalage pangamologa e ta goe laeala ta ragau kinung reke momalle Nutu ta ravunglelenge Ierusalem. ");
INSERT INTO mee_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Na ka inae Iesus tamana bae naname ke kuma ka orume kinung base ma bangapaga ae Nutu ine role tapu, na keke galiu tae Galili ta maga kunna ae ri ae Nasaret. ");
INSERT INTO mee_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na goe laeala ke lele bollau ba ke lele gingging. Ba i ka nena ka lomatana papatu reke pepe, bae Nutu ke materaumane bole. ");
INSERT INTO mee_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ka pesingmataname kinung, na goe a panung ae Iesus tamana bae naname keke lola ta kaning te e bollau ngae Ierusalem. Ba keke patoe kaning laeala kae Kaning E Bollau E Nga Paska. ");
INSERT INTO mee_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Minmina na ka inae Iesus kana pesingmatana tangulelu ba lua, na keke loa ta kaning laeala kurumea baingarea re pala. ");
INSERT INTO mee_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ngarume nga kaning rongngana na keke kapaligaliu ta maga, avae Iesus ke momo tale ngae Ierusalem. ");
INSERT INTO mee_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nae tamana bae naname ka loreangana roma, i e tatao kala nga ragau. Ava ka kae kena tapu, na ri keke sissilia ngaliua nga kolingarea memena ba ragau rae ri. ");
INSERT INTO mee_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ri pana lua keke sissilia, ava ke sane ke kela pakia. Minmina na keke galiu muni tae Ierusalem ta kelanga te i. ");
INSERT INTO mee_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Na ri pana lua keke sissilia ka kae lua tapu, ava kae a mologi na ri keke kela pakia nga ine momolu nga tempel. Keke kele nga ine tattara ngaliua nga ra pangalomatanakana. Ba i ke longlonge pangamologa nga kanrea ba ke umma ta balinglaga rea bole. ");
INSERT INTO mee_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ka ina ragau ke longe pangamologa nga kanna, na keke magio raumana nga lonamatanangana ba alangana ka balinglaga ra kanrea. ");
INSERT INTO mee_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ba ka ina tamana bae naname ke kele, na keke magio raumana bole. Na naname ke ballage roma, “Tugu, ko meimia o kuma ka omea tamang minakai? Ba ko sano turulomatana te omea? Omea tamang ka lomangngsoali raumana te one, ikia baina omea ka atu ta kelanga te one.” ");
INSERT INTO mee_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Minmina nae Iesus ke ale pangamologa ka rolengana kerea masi roma, “Ke meimia, na onemea kaka sissili iau? Ka sana lomiaumatana nanguni roma, iau ka la momong nga bale ae Tamau ae?” ");
INSERT INTO mee_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ava ri pana lua ka sana loreamatana ka pangamologa laeala e patoe te ri mirana. ");
INSERT INTO mee_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ale bainae Iesus ale galiupisigi kurumea tamana bae naname tae Nasaret, ba i ke longlongo te ri ka kaeme kinung. Nae naname ke kele oru nginngina ba ka lonagomgome rea. ");
INSERT INTO mee_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Minmina nae Iesus ke lele bollau, ba lonamatanangana ke lele masi bole. Nae Nutu ba ragau bole keke matea raumana. ");
INSERT INTO mee_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Na ka inae Taibirias Sisa ke momo a i a kelangpatali ngae Rom ka pesingmatana tangulelu ba lima tapu; bae Pontius Pilatus ka i a e kapunu nga gavaman e ngae Rom ngae Iurea; bae Eroto ka i a e kapunu ngae Galili; bae kolingana ae Pilip ka i a e kapunu nga ine ngae Iturea bae Tarakonaitis; bae Laisanias ka i a e kapunu ngae Abilene. ");
INSERT INTO mee_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ba muni ka inae Anas ri luae Kaiapas ka ri lua re kapunu nga pirisme re ngae Iurame. Nae Nutu ke ba ka pangamologa a kanna te Sekaraia tuna ae Ion ine momo nga ina a sana ragau ngia. ");
INSERT INTO mee_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Minmina na i ke loa ta iname kinung re ngae Me Ae Ioran. Na ke kurkura ta ragau ravunge pangamagoe e nga pulingvalakalange baingarea reke sosoali ba tungnge loreamatenganame te Nutu, ta bainae Nutu nge osurure baingarea reke sosoali nga raguna. ");
INSERT INTO mee_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ke loakurumea pangamologa a agau e toe Nutu kaona a giana nge Aisaia paꞌe pala ore role roma: “Agau te kalingngana ke kurkura nga ina a sana ragau ngia roma, ‘Ngaka kalitupe pamau ae Avolau, ba ngaka patupe pamaume ta i taonga ngi. ");
INSERT INTO mee_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ruvume kinung keke la ponung, ba kapangngme kinung reke bollalau ba ne ngeke sisina keke la tarurung, ba malle reke balo keke la tupung, ba pamau reke patemaling keke la kenongotupu; ");
INSERT INTO mee_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","minmina na ragau kinung keke la kelange Nutu ravunglelengana.’” ");
INSERT INTO mee_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Na ragau papatu keke lola te Ion ta i pangamagoe rea, ava i ke role kerea roma, “Miau ra mue ra koatali goe rae ri, tai ke role kamiau ta miau kanga nga iu e la leleng? ");
INSERT INTO mee_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Miau kaka rorole roma, ‘Mangng ka pulivalakale baingamangng reke sosoali ba mangng ka tunge lomangngmatenganame te Nutu tapu.’ Ke pe, ava ngaroma miau kaka kuma minmina ka kaomanna, na ngaka bavaia bainga ra ragau reke pulivalakale baingarea reke sosoali mannangana ke bavai rea. Ba sana nga lomiaugomgome roma, ‘Mangng ka pe tapu nge Nutu raguna, ta mangnga ka sisiukamangng nge Abaram.’ Iau nga role kamiau roma, Nutu ka kana ka gingginga ta kamongpiliunge lollo kokorai ta ri leleng Abaram sisivuna memena. ");
INSERT INTO mee_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Pemo ke momalla ta telenge begame ngape nga purea. Minmina na keke la telengpisiginge bega re sane ke piaupiaue kanrea reke pepe, na keke la raunga rea nga sia.” ");
INSERT INTO mee_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ka ine role minmina na ragau kinung keke ballage roma, “Mangng ka la maingamia?” ");
INSERT INTO mee_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Na i ke ale balinglaga a kanrea roma, “Agau a nena ka lungapaga lua nge tunge te ta agau a sana nena. Ba agau a kana ka kaning nge kuma minmina bole.” ");
INSERT INTO mee_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Na ragau palu reke raravukinunge takisme keke loa te i ta i pangamagoe rea bole, na keke ballage roma, “Apangalomatanakana, mangng ka la maingamia?” ");
INSERT INTO mee_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Na i ke role kerea roma, “Ngaka raravumasi kurumea bangapaga e nga ravungkinunge takisme mana.” ");
INSERT INTO mee_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ba galiau re nga baling palu bole keke ballage roma, “Mangng ka la maingamia?” Na i ke role kerea roma, “Miau ka sana ngaka kamopite ragau ka lulungmataga ngamiaungana kerea ta utunge lollokanna nga kanrea. Ba ke sana ngaka ute lollokanna nga ragau kanrea nga kalingnana nga goanga. Ba miau ngaka momomasi kala nga lollokanna nga kanmiau mana.” ");
INSERT INTO mee_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na ragau re ngae Israel keke momalle agau a ravunglelekana, minmina na ri ka loreangana roma, “Karais ikia nge Ion nanguni.” ");
INSERT INTO mee_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nae Ion ke rolepota te ri roma, “Iau ka pamagoe miau ka me mana. Ava ngarume, na agau te ke la atung ba i ka i ngailu nge iau. Ba ka sana iau a agau te mannangana ta iau nga pole oalo nge nga kesingsilagi ngae i. I ke la pangamagoe miau kae Kannu E Tupu ba ka sia. ");
INSERT INTO mee_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ba i ke la kalingnanange ragau ma agau e kampite pirangapaga a kanna nga kamana ta i paerange pailli rae i kanreame. Ba i ke la rongapatapu ka kumangngana laeala nga paeranga. Na i nge pulikinunge pailli miraname nga kana bale, ava pailli gaulename i nge rau rea nga sia e sane la ronga.” ");
INSERT INTO mee_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Bae Ion ke tagatue pangamologa pattoto reke pepe bole ta baina i pangalokalipage ragau ki. ");
INSERT INTO mee_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nae Eroto i a kelangpatali ngae Galili ke baia bainga e soali nga ine rave tataokia napengana a giana kae Erorias. Ba ke baia bainga pattoto reke sosoali bole, minmina nae Ion ke sanggipite. ");
INSERT INTO mee_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Bae Eroto ke patavale bainga tetoto e soali nga bainga nginngina ka ine pullue Ion nga pulangkala. ");
INSERT INTO mee_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pala te Ion loanga ta pulangkala, na i ke pamagoegoea ragau. Ka ine rongo tapu ta pangamagoenge ragau, na i ke pamagoea Iesus bole. Ngarume nae Iesus ke kavkava ba tava ke sagitoto. ");
INSERT INTO mee_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nae Kannu E Tupu ke lomaling te i ma i a manu a sinna ma kulao. Ba kaling te e pa nga tava ke role roma, “Ka one ae Tugu a iau materaumana one. Ba ka laupe kone raumana.” ");
INSERT INTO mee_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Bae Iesus ka kana ka pesingmatana keke basema giaukaina ba tangulelu ine pature kumangng a kanna. Minmina na nga ragau kelangareangana keke roma: Iesus ka i ae Iosep tuna bae Iosep ka i ae Eli tuna, ");
INSERT INTO mee_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","bae Eli ka i ae Matat tuna, bae Matat ka i ae Livai tuna, bae Livai ka i ae Melki tuna, bae Melki ka i ae Ianai tuna, bae Ianai ka i ae Iosep tuna, ");
INSERT INTO mee_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","bae Iosep ka i ae Matatias tuna, bae Matatias ka i ae Amos tuna, bae Amos ka i ae Naum tuna, bae Naum ka i ae Esli tuna, bae Esli ka i ae Nagai tuna, ");
INSERT INTO mee_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","bae Nagai ka i ae Mat tuna, bae Mat ka i ae Matatias tuna, bae Matatias ka i ae Semen tuna, bae Semen ka i ae Iosek tuna, bae Iosek ka i ae Iora tuna, ");
INSERT INTO mee_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","bae Iora ka i ae Ioanan tuna, bae Ioanan ka i ae Resa tuna, bae Resa ka i ae Serubabel tuna, bae Serubabel ka i ae Sealtiel tuna, bae Sealtiel ka i ae Neri tuna, ");
INSERT INTO mee_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","bae Neri ka i ae Melki tuna, bae Melki ka i ae Ari tuna, bae Ari ka i ae Kosam tuna, bae Kosam ka i ae Elmaram tuna, bae Elmaram ka i ae Er tuna, ");
INSERT INTO mee_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","bae Er ka i ae Iosua tuna, bae Iosua ka i ae Elieser tuna, bae Elieser ka i ae Iorim tuna, bae Iorim ka i ae Matat tuna, bae Matat ka i ae Livai tuna, ");
INSERT INTO mee_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","bae Livai ka i ae Simeon tuna, bae Simeon ka i ae Iura tuna, bae Iura ka i ae Iosep tuna, bae Iosep ka i ae Ionam tuna, bae Ionam ka i ae Eliakim tuna, ");
INSERT INTO mee_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","bae Eliakim ka i ae Melea tuna, bae Melea ka i ae Mena tuna, bae Mena ka i ae Matata tuna, bae Matata ka i ae Natan tuna, bae Natan ka i ae Revit tuna, ");
INSERT INTO mee_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","bae Revit ka i ae Iesi tuna, bae Iesi ka i ae Obet tuna, bae Obet ka i ae Boas tuna, bae Boas ka i ae Salamon tuna, bae Salamon ka i ae Nason tuna, ");
INSERT INTO mee_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","bae Nason ka i ae Aminarap tuna, bae Aminarap ka i ae Atmin tuna, bae Atmin ka i ae Arani tuna, bae Arani ka i ae Esron tuna, bae Esron ka i ae Peres tuna, bae Peres ka i ae Iura tuna, ");
INSERT INTO mee_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","bae Iura ka i ae Iekop tuna, bae Iekop ka i ae Aisak tuna, bae Aisak ka i ae Abaram tuna, bae Abaram ka i ae Tera tuna, bae Tera ka i ae Naor tuna, ");
INSERT INTO mee_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","bae Naor ka i ae Seruk tuna, bae Seruk ka i ae Reu tuna, bae Reu ka i ae Pelek tuna, bae Pelek ka i ae Eber tuna, bae Eber ka i ae Sela tuna, ");
INSERT INTO mee_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","bae Sela ka i ae Kainan tuna, bae Kainan ka i ae Arapakat tuna, bae Arapakat ka i ae Siem tuna, bae Siem ka i ae Noa tuna, bae Noa ka i ae Lamek tuna, ");
INSERT INTO mee_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","bae Lamek ka i ae Metusela tuna, bae Metusela ka i ae Enok tuna, bae Enok ka i ae Iaret tuna, bae Iaret ka i ae Maalalel tuna, bae Maalalel ka i ae Kenan tuna, ");
INSERT INTO mee_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","bae Kenan ka i ae Enos tuna, bae Enos ka i ae Set tuna, bae Set ka i ae Aram tuna, bae Aram ka i a agau ae Nutu koipage. ");
INSERT INTO mee_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ngarume ngae Iesus pangamagoengana nga Me Ae Ioran, na i ke galiu bae Kannu E Tupu ke ponu nge i. Minmina nae Kannu E Tupu ke taoamuga kia ta ina a sana ragau ngia. ");
INSERT INTO mee_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Na i ke momo nga inaeala ka kaeme ka ri giaukaina lua, nae Satan ke amve ta i pupunga nga avanga. Ba i ke sane kaninnia otte ka kae nginngina, na ka matekana. ");
INSERT INTO mee_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nae Satan ke role kia roma, “Ngaroma one ae Nutu tuna, na ngo role ka lollo laekia ta i leleng i a beret.” ");
INSERT INTO mee_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Avae Iesus ke ale pangamologa te i roma, “Keke paꞌe pangamologa nga Lau Ae Nutu Kanna e role roma, ‘Ke sana nga agau nge mauli ka beret mana.’” ");
INSERT INTO mee_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nae Satan ke taoamuga kia lakailu ta ina e ngailu raumana, na ke pakosininge bolvole mana ka kelangpatalime kinung onre nga mogalo laekia e ngape. ");
INSERT INTO mee_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ba i ke role kia roma, “Iau ka la tungnge kelangpatalime ginggingngareame ba kelangareangana reke pepe raumana te one. Oru kokorai kinung ka oru nga iau tapu. Minmina na ka la tunga rea te tai a iau matea ta tunga rea te i. ");
INSERT INTO mee_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Minmina na ngaroma one ngo kalapaga iau, na oru kokorai nga kang ki kinung.” ");
INSERT INTO mee_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nae Iesus ke ale pangamologa te i roma, “Keke paꞌe pangamologa nga Lau Ae Nutu Kanna e role roma, ‘One ngo kalapage Avolau a i ae Nutu ae one, ba ngo kuma ka kumangng a kanna mana.’” ");
INSERT INTO mee_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nae Satan ke taoamuga kia, ba ke role ta i meising nga tempel kunna tomona. Na ke role kia roma, “Ngaroma one ae Nutu tuna, na ngo tugutaopisigi lagape ");
INSERT INTO mee_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ta keke paꞌe pangamologa nga Lau Ae Nutu Kanna e role roma, ‘I ke la bange anggelo rae i ta ri kelanga masi te one’, ");
INSERT INTO mee_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ba ‘Ri keke la sipanga one ka kamareame nga baina sano ngo pagitukole kaeng puna nga lollo te.’” ");
INSERT INTO mee_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nae Iesus ke ale pangamologa te i roma, “Keke role roma, ‘Maningsa avange Avolau a i ae Nutu ae one.’” ");
INSERT INTO mee_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Na ka inae Satan rongo ta avange Iesus ka avanga matantana tapu, na i ke kaꞌe ka lonatunagomengana roma, “Ngarume ka kae tetoto, na iau ka la avange muni.” ");
INSERT INTO mee_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nae Iesus ke galiu ta ine ngae Galili, ba Kannu E Tupu ginggingngana ke momo nge i. Minmina na kana turung ke loa kalaoveka nga inaeala bavakena. ");
INSERT INTO mee_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Na i ke palomatantana nga sinagogme, ba ragau kinung keke kalapagpage giana. ");
INSERT INTO mee_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ngarume na i ke loa ta magapuna ae i ae Nasaret. Ba ka kae a Sabat, na i ke lu lakallo ta sinagog kurumea Iurame baingareangana te. Na ke maisi ta patonge pangamologame nga Lau Ae Nutu Kanna. ");
INSERT INTO mee_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ba ka ina akalaungapagakana nga sinagog tunge lau a agau e toe Nutu kaona ae Aisaia paꞌe pala te i, na i ke sasapole ba ke kalipa ka malle nga pangamologa ore role roma: ");
INSERT INTO mee_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kannu E Tupu ke puli iau, minmina na i ke momo kala nge iau. Ke puli iau ta pulingmalagange pangamologa reke pepe ta ra sillolo. Ba i ke ba iau ta turunge pangamologa ta reke momo nga pulangkala nga baina ri ngeke kaꞌe pulangkala, ba ta ragau ra matarea kanname ke su nga baina ri ngeke kela muni. Ba i ke ba iau ta ravunglelenge ragau ra ri ke baisolali rea, ");
INSERT INTO mee_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ba ta turunglomatana roma, pesingmatana orae Nutu matea ragau kia ke lele tapu.” ");
INSERT INTO mee_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Minmina nae Iesus ke lulugaliue lau ta tungagaliunge ta barangalele, na ke tara. Ba ragau reke momolu nga sinagog keke kelananne. ");
INSERT INTO mee_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Na i ke paturu ta pangamologa te ri roma, “Ka iau a pangamologa laekia ae miau ka longe sonrau mirana mannangana.” ");
INSERT INTO mee_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Minmina na keke pamologa masi te i, ba keke magio nga pangamologa reke pepe nga ine pulimalaga rea nga kaona. Ba keke role roma “Aekia ka i ae Iosep tuna, ava ke meimia na i ke role ta i bainge oru nginngina reke bollalau?” ");
INSERT INTO mee_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Minmina na i ke role kerea roma, “Miau kaka la baingarolenge kau roma, ‘Apangapemirakana, one mana me one ngo pape one! One ngo kuma nakai nga magapuna ae one ta mangng ka longotape kumangng a one kuma kia ngae Kaperneam.’” ");
INSERT INTO mee_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ba i ke role kerea bole roma, “Iau nga role kamiau ka kaomannmannangana roma, ragau re nga magapuna ae agau e toe Nutu kaona keke la tangunglelenge pangamologa ra kanna. ");
INSERT INTO mee_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ka la roleng kamiau ka kaomannmannangana roma, ka kae laeala pala e nga agau e toe Nutu kaona ae Ilaia, na ragau papatu ra ri ra bagaru keke momo ngae Israel. Ba bole, ka kae laeala na kue ke sane tugu ka pesingmatana mologi ba inna lima ba kena. Ba osangana e bollau ke lele. ");
INSERT INTO mee_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Avae Nutu ke sane baꞌe Ilaia ta i kalaunge agau te ae ngae Israel. Ke sa. I ke baꞌe ta avale te mana a i a bagaru e balakala ngae Serepat nga ine ngae Sairon. ");
INSERT INTO mee_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Minmina bole ka kae e nga agau e toe Nutu kaona ae Elaisa, na ragau papatu ra soaling a kalangamugmugu lele nge ri keke momo ngae Israel. Ava te e nge ri ke sana soaling ae i rongo. Kana kae Neman mana me i e ngae Siria.” ");
INSERT INTO mee_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na ka ina ragau karolu reke momo ngallo nga sinagog ke longe pangamologa laeala, na keke mate ka iukereangana kia. ");
INSERT INTO mee_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Na keke sigipaga, na keke taomalage nga maga kunna laeala e momo nga manumautuna te nga ina i a mantapu, ta baina ri bongapisiginge lagape. ");
INSERT INTO mee_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ava ke sa, i ke tao ngaliua nge ri mana na ke loa. ");
INSERT INTO mee_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ngarume nae Iesus ke tuttapupisigi tae Kaperneam, ka i a maga kunna te e bollau nga ine ngae Galili. Na i ke potpote ragau ka kae e nga pannang eke patoe ka “Sabat”. ");
INSERT INTO mee_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ba pangamologangana ka kana ka gingginga, minmina na ragau keke longe ba keke kallo raumana. ");
INSERT INTO mee_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na agau te ora kannu e soali momolu nge i ke mommo ngallo nga bale a sinagog, ba i ke reli ka rolengana roma, ");
INSERT INTO mee_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aekolong ae Iesus e ngae Nasaret! Ko bai ta maingamia ka mangng? Ko atu ta baingasoali mangng? Ka laumatana kone, ka one a agau e tupu orae Nutu baꞌe.” ");
INSERT INTO mee_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Avae Iesus ke sanggipite roma, “Rulu! Kaꞌe aekolong bo lelemalagapatalia!” Na ka ina kannu e soali tamalipisigi ka agau laeala ngaliua nga ragau, na i ke lelemalagapatalia ba ke sane meimia tekia. ");
INSERT INTO mee_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Minmina na ragau kinung keke kallo raumana ba keke palibalaglaga rea roma, “Pangalomatana ba gingginga matana e meimia ikia ka baina agau laekia ke role ka kannu e soali na ke lelemalaga?” ");
INSERT INTO mee_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Minmina nae Iesus kana turung ke loa kalaoveka ta iname kinung. ");
INSERT INTO mee_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ngarume nae Iesus ke sigipaga ba ke kaꞌe sinagog, na ke loa e lu nga bale ae Saimon. Nae Saimon lonapengana ke soali ka soaling a mira isongpangana, ba keke ballage Iesus ta i kalaunge avale laeala. ");
INSERT INTO mee_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Minmina nae Iesus ke silopite maling ba ke sanggipite soaling laeala, na soaling ke kapatalia. Ba ka pannasa, na avale laeala ke sigipaga na ke silae rea. ");
INSERT INTO mee_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na ka ina kae baretapu, na ragau keke atu ka ra karea ka soaling matmatana te Iesus. Na i ke pulipaia kamana nga ri kinung kenakena ba ke pape rea. ");
INSERT INTO mee_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ba ragau papatu ra kannu reke sosoali ke momolu nge ri, kannu nginngina keke lelemalagapatali rea. Ba kannu nginngina ka loreamatana roma Iesus ka i ae Karais, minmina na keke rereli ka rolengarea roma, “Ka one ae Nutu Tuna!” Avae Iesus ke sanggipita rea ta manereasa pangamologa. ");
INSERT INTO mee_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ngarume, ka kae tetoto ka kae marara, nae Iesus ke kaꞌe inaeala ba ke loa ta malle a oruvolo ngia ta baina i kavang. Minmina na ragau keke sissilia ta keke lele nga inaeala a i momo ngia. Na keke avarole kia ta i manenasa kanga rea. ");
INSERT INTO mee_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ava i ke role kerea roma, “Iau nga pulimalage pangamologa e pe ore ta Nutu kelangapatalingana nga maga kunna pattoto bole, ta Nutu ke ba iau nasai ta kumangng ka kumangnga laeala.” ");
INSERT INTO mee_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Minmina na i ke pulimalaglage pangamologa nga sinagogme kinung nga porovins e ngae Iurea. ");
INSERT INTO mee_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ka kae te, ka inae Iesus maisi nga me a sivoli ae Genesaret kaona, na ragau papatu keke loa eke maistaliutotokale. Ba keke longlonge ine pulimalaglage pangamologa ae Nutu kanna. ");
INSERT INTO mee_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Minmina nae Iesus ke kele manang lua rae reke laulau lea nga sivoli kaona. Ba ra nginngina keke alapataea manangme ba keke mumme po nga ri. ");
INSERT INTO mee_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Minmina nae Iesus ke taepatae nga manang lua nginngina te, ka i a manang orae Saimon. Na i ke tarapai ngia ba ke role kae Saimon ta i kalangapataenge ka manang na nge kaꞌe taona isura. Minmina nae Iesus ke palomatantane ragau kinung ka ine tarapai nga manang. ");
INSERT INTO mee_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Na ka ine rongo ka pangamologa tapu, na ke role kae Saimon roma, “Ka otepatae ta mali, na ngaka toatape pome nga baina ngaka lau lea.” ");
INSERT INTO mee_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Avae Saimon ke role kae Iesus roma, “Avolau, mangng ka kuma kaligi ka rigo ava ke sana mangng rave otte! Ava ko role minmina na iau ala nga toatape pome lagape.” ");
INSERT INTO mee_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ka ineke kuma minmina, na keke laue lea papatu ramana ba pome keke bai ta maraenga. ");
INSERT INTO mee_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ka baina keke bali ka kamareame ta kolingareame nga manang tetoto, na keke atu ta kalaunga rea. Na ka ineke lele nge ri tapu, na keke gongge pome ba keke kintatape leame ta manang lua nginngina. Ava manangme keke ponu raumana ka leame ba keke kokoro ta maraleng. ");
INSERT INTO mee_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Na ka inae Saimon a giana te nge Pita kele oru nginngina, na i ke toarau mana nge Iesus kaena puna. Ba ke pamologa ka kalingngana mammalungana te Iesus roma, “Avolau, ngo ka balakala iau, ta ka iau a agau a bainganame ke sane ke pepe!” ");
INSERT INTO mee_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","I ke role minmina kurumea, i kala nga kolingana memena keke kallo nga kelangarea ba laungareangana ka leame. ");
INSERT INTO mee_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Bae Sepeti tuna memena ra giarea nge Iems bae Ion, onra ri ra kumangngkena rae Saimon, keke kallo raumana bole. Nae Iesus ke role kae Saimon roma, “Sono ngo matau. Sonrau na ko laue lea, ava one ko la launga ragau nasai te iau ngarume.” ");
INSERT INTO mee_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ka baina keke oteso ka manang nga ri ta taona, na keke tulupatae rea. Minmina na ri keke kaꞌe oru nga kanrea kinung, na keke loakurumea Iesus. ");
INSERT INTO mee_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ka kae te, ka inae Iesus momo nga maga kunna te e bollau, na agau te ora soaling a kalangamugmugu gaspalpita ka mirana ke lele nge i. Ba ka ine kele Iesus, na i ke toarau ka kalangapitangana ka raguna nga mogalo ba ke tanikale Iesus roma, “Avolau, one ka kanga ka gingginga ta pangalellepa iau. Ngaroma nga longangana, na ngo palellepa iau.” ");
INSERT INTO mee_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nae Iesus ke kalaꞌe kamana ba ke kali kia, na ke role roma, “Ka logungana. Ngo lelle.” Ba ka panna laeala mana na soaling a kalangamugmugu ke kapatalia. ");
INSERT INTO mee_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nae Iesus ke role gingging ta i manenasa turung ta agau te, ba ke role kia roma, “Ava ngo loa ba ngo pakosining kone ta piris. Na ngo tunge tunga e nga mirang pengana base inae Moses bapage ragau re pala. Ngo kuma minmina ta baina ragau nga loreamatana roma, soaling ae one ke rongo tapu.” ");
INSERT INTO mee_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ava panganana re ta Iesus kumangngana keke lola kalaoveka tale. Ba malua reke bollalau raumana keke katukala kinung ta ri longnge pangamologangana, ba ta i pangapenge soaling rae ri. ");
INSERT INTO mee_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ava ka kae papatu, nae Iesus ke lola ta kavang nga ina a sana ragau ngia. ");
INSERT INTO mee_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ka kae te, nae Parisiome keke tattara ka inae Iesus palomatantane ragau. Ba palu ra ri ra pangalomatanakana nga bangapagame keke tattara bole. Ka ri ra ragau re nga maga kunna e bollau ngae Ierusalem, ba magame kinung nga ina ngae Galili ba ngae Iurea. Nae Nutu ginggingngana ke momo nge Iesus, ba i ke papepea ragau ra karea ka soaling. ");
INSERT INTO mee_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Minmina na ragau palu keke atu ka paunga ngareangana ka agau te a giname ke mate ka nia ta baina ri pakenonge ngamuga nge Iesus ngallo nga bale. ");
INSERT INTO mee_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ava keke baililli ta ri lunga kia kurumea, ragau keke ponu ngallo nga bale lona. Minmina na keke loapatae lakailu ta bale kunna ine karapap. Na keke kalalage bale kunna inte ta baina ri toangatapunge ka nia ngaliua nga ragau. Keke kuma minmina, na agau laeala ke keno ngamuga nge Iesus. ");
INSERT INTO mee_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Na ka inae Iesus kele lopatokona ae ri, na ke role roma, “Koli, iau ka osurure baingang reke sosoali.” ");
INSERT INTO mee_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nae Parisiome ba ra pangalomatanakana nga bangapagame keke longo, ba ka loreagomgome roma, “Nutu mana nge osurure ragau baingarea reke sosoali, ava tai ikia nge aekia e rorolebainga kae Nutu?” ");
INSERT INTO mee_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Avae Iesus ka lonamatana ka oru reke momolu nga ramareame, minmina na i ke ala rea ka balinglagangana kerea roma, “Kaka meimia aka kumkuma ka lovainganame ngallo nga lomiaume? ");
INSERT INTO mee_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Pangamologa a taru nge ate ta iau rolenge? Ngaroma iau nga role kae aekia roma, ‘Aekolong, iau ka osurure baingang reke sosoali,’ o ngaroma iau nga role kia roma, ‘Sigipaga na ngo tao’. Te miau sonrau, nga pangamologa lua nginngina na taru ke ate ta iau rolenge? ");
INSERT INTO mee_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ava iau ka bai ta miau lomiaumatanangana roma, Agau Tuna ka kana ka gingginga nga mogalo laekia e ngape ta i osungrurunge ragau baingarea reke sosoali.” Minmina nae Iesus ke role ka agau laeala a giname ke mate roma, “Iau nga role pakone roma, ngo sigipaga, na ngo rave nia ae one ba ngo loa te one ta bale.” ");
INSERT INTO mee_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ka pannasa mana, na agau laeala a giname ke mate ke sigipaga nga ragau ragureame. Na ke rave nia laeala a i keno ngia pala, na ke loa ta bale ae i, ba ke kalapagpage Nutu. ");
INSERT INTO mee_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Na ragau kinung keke kallo raumana ba keke kalapagpage Nutu. Ba ri ka loreasoali raumana ka rolengarea roma, “Sonrau na ita kaka kele oru reke bollalau raumana.” ");
INSERT INTO mee_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ngarume nga oru nginngina, nae Iesus ke lelemalaga nga maga kunna e bollau. Na i ke kele agau te e raravukinunge takisme a giana nge Livai ine tattara nga mallena nga kumangng. Nae Iesus ke role kia roma, “Ngo atukurume iau.” ");
INSERT INTO mee_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Minmina na i ke kelavalakale kumangng a kanna, na ke kutapu e loakurumea Iesus. ");
INSERT INTO mee_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ba ngarume, ka kae tetoto, nae Livai ke baia kaning te e bollau nga bale ae i. Na ragau papatu reke raravukinunge takisme ba ragau pattoto bole keke tattara kala nge ri nga kaning laeala. ");
INSERT INTO mee_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nae Parisiome kala nga ragau rae ri ra pangalomatanakana nga bangapagame keke loa ka kaorea kae Iesus barangalele ra kanna. Ba keke ballaga rea roma, “Kaka meimia aka kaninni ba ka innu kala nga reke raravukinunge takisme ba ra baingareame ke soali?” ");
INSERT INTO mee_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nae Iesus ke ala rea roma, “Ragau ra sana karea soaling ke sane ke lola ta apangapemirakana. Ke sa. Ragau ra karea ka soaling mana keke lola. ");
INSERT INTO mee_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iau ka sana atu ta kiunge ragau ra baingareame ke tupu. Ke sa. Ka atu ta kiunge ragau ra baingareame ke soali ta ri pulingvalakalange baingarea reke sosoali ba tungnge loreamatenganame te Nutu.” ");
INSERT INTO mee_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ka kae te na ragau keke role kae Iesus roma, “Barangalele rae Ion kanna keke kuriri ta kaning, ba keke kavkava ka kae papatu. Ba barangalele rae Parisiome kanrea keke umma minmina bole. Ava ke meimia na barangalele ra kaning keke kaninni beke innu?” ");
INSERT INTO mee_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nae Iesus ke ala rea ka pangateningkalangana ka pangamologa roma, “Miau kaka roma i e pe ta pangakuringe ragau reke maispage apanung e bai ta kamangpitakama ka kae e nga palingravung ina apanung laeala momo kala nge ri tale, o ke sa? Ke sa. Ke sane pe. ");
INSERT INTO mee_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ava kae te ke la atung nga ineke la ravungpatali ka apanung e bai ta kamangpitakama nge ri, ba nga kae laeala na ri keke la kuringa ta kaning.” ");
INSERT INTO mee_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ba i ke role kerea ka pangateningkalangana ka pangamologa bole roma, “Ka sana agau te nge baimaraea malo inte nga lungapaga a pau na nge saipite nga lungapaga a kasana. Ngaroma i nge kuma minmina na ale baimaraea lungapaga laeala a pau tapu, ba bole malo inaeala a i rave nga lungapaga a pau sana nga tongana kena ma lungapaga a kasana. ");
INSERT INTO mee_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ba ka sana agau te nge pullue uain a pau nga uain bagana ra kasarea. Ngaroma i nge kuma minmina na uain a pau nge poagolue uain bagana nginngina onreke kuma ki ka meme patuna, na uain nge maling lagapotu. Ba uain patuname keke la soaling. ");
INSERT INTO mee_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ava ragau keke la pulinge uain a pau lakallo ta uain patuna onra pau. ");
INSERT INTO mee_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ba bole agau e inue uain a kasana ke sane matea ta inunge uain a pau ta i nge roma, ‘Neala a kasana ke loa nga laungana tapu.’” ");
INSERT INTO mee_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ka kae te a i a kae a Sabat, nae Iesus ke tataopale ura re nga pailli matana eke patoe ka “giren”. Na barangalele ra kanna keke umma ta utungtotonge giren kunna palu ba keke kaninnia kanreame. ");
INSERT INTO mee_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Avae Parisio palu keke kela rea na keke role roma, “Ke meimia na kaka kumkuma ka ore parototokala ka kae a Sabat?” ");
INSERT INTO mee_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nae Iesus ke ale pangamologa te ri roma, “Miau ka sana ka kele pangamologa laeala eke paꞌe pala ore ta Revit kumangngana ina i ba ra balingkana rae i matekarea ae? ");
INSERT INTO mee_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","I ke loalu lakallo ta bale ae Nutu, na ke rave beret laeala ore ta tungnge te Nutu, na ke kania. Ava ke parototokala ta agau te mana kaninge beret laeala. Kana ka pirisme mana. Bae Revit ke tungu ra balingkana rae i karea bole.” ");
INSERT INTO mee_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nae Iesus ke role kerea roma, “Agau Tuna ka i a Avolau e nga kae a Sabat.” ");
INSERT INTO mee_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ngarume, ka kae a Sabat tetoto, nae Iesus ke loalu lakallo ta sinagog, na ke palomatantane ragau. Na agau te a kamana e pe mate ke momo ka kae laeala bole. ");
INSERT INTO mee_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bae Parisiome kala nga ra pangalomatanakana nga bangapagame keke sissilia pamau ta ri turungpaga Iesus kana. Minmina na keke ella te i roma, “Aekia ke la i pangapenge agau laeala ka kae laekia e nga pannang, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Avae Iesus ka lonamatana ka taru e momo ngallo nga lorea tapu, na ke role ka agau laeala a kamana mate roma, “Ngo atu bo maisi ngamuga nga ragau.” Minmina na agau laeala ke sigipaga be loa na ke maisi ngamuga nga ragau. ");
INSERT INTO mee_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nae Iesus ke role kerea roma, “Iau ka bai ta balinglaga miau roma, bangapagame ke parototokala ita ta kumangng ka bainga a taru ka kae a Sabat? Keke parototokala ita ta kumangng ka bainga e pe o ta kumangng ka bainga e soali, ta ravunglelenge agau maulingngana o ta baingasoalinge?” ");
INSERT INTO mee_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Minmina na i ke kelataliu te ri kinung, na ke role ka agau laeala roma, “Ngo kalaꞌe kamang.” Na agau laeala ke longo te Iesus ba kamana ke pe muni. ");
INSERT INTO mee_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ava ri ka iukerea raumana kae Iesus, na keke palipamologa te ri roma, “Ita kaka la maingamia ka agau laekia?” ");
INSERT INTO mee_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ka kae nginngina nae Iesus ke loa ta kapangng ta baina i kavang. Na i ke kavkava te Nutu ka rigo laeala bavakena ta kae ke mara. ");
INSERT INTO mee_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ba ka ina kae marara tapu, na i ke kiue barangalele ra kanna te i, ba ke tore pana tangulelu ba lua ta ri ra aposel rae i. ");
INSERT INTO mee_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","I ke tore Saimon ae Iesus patoe kae Pita, bae teiteikia ae Anru, bae Iems, bae Ion, bae Pilip, bae Bartolomiu, ");
INSERT INTO mee_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","bae Matiu, bae Tomas, bae Iems te muni a i ae Alpaeus tuna, bae Saimon eke patoe kae “Selot”, ");
INSERT INTO mee_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","bae Iuras a i ae Iems tuna, bae Iuras Iskariot a i a agau laeala e la ulonge Iesus nga reke bai ta baingasoalinge kamareame. ");
INSERT INTO mee_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nae Iesus ke somaling kala nga aposel rae i, na keke meisi nga mogalo ina i a kavu kala nga barangalele ra kanna ra maluame. Ba ri keke mommo kala nga ragau papatu re ngae Iurea, ba Ierusalem, ba re nga pelau bavana e ngae Taia bae Sairon. Keke mommo ta ri longe Iesus pangamologangana ba ta i ronga ka soaling nga ri. ");
INSERT INTO mee_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Minmina na i ke papea ragau ra kannu reke sosoali ke baisoali rea. ");
INSERT INTO mee_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ba ragau keke bai ta ri ngeke kali mana ka mirana ta baina ginggingngana nge lelemalaga nge i na nge papea ri kinung. ");
INSERT INTO mee_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nae Iesus ke ilapaga ta barangalele ra kanna na ke role kerea roma: “Miau raka moro raumana ta orume nga lomiausereng, ta Nutu kelangpatalingana ka orae miau. ");
INSERT INTO mee_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Miau ra mate kamiau sonrau nga lomiausereng, ta ngarume nae Nutu ke la pangaponu miau. Miau raka tantani sonrau nga lomiausereng, ta ngarume na miau kaka la mangaliling. ");
INSERT INTO mee_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nga ina ragau ngeke baiꞌiu kamiau ba ngeke ulovalakala miau, ba nga ine ngeke rorolebainga kamiau, ba ngeke baisolalia giamiaume kurumea atungamiaungana kurumea Agau Tuna, na nga lomiausereng, ");
INSERT INTO mee_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Nga lomiaumannmanna ka kae laeala, ba ngaka sigitataopatae ka serenga, ta alanga ae miau e pe nga Nutu mallena nga tava ke bollau raumana kurumea, pala na tamarea memena keke kuma ka ragau reke toe Nutu kaona minmina bole. ");
INSERT INTO mee_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ava miau ra kilipukana sonrau, ragumiaume ngeke mate, ta miau kaka rave sereng ngamiaungana tapu. ");
INSERT INTO mee_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Miau ra kaningi ponu nge miau sonrau, ragumiaume ngeke mate, ta miau ka sana la kamiau kaning ngarume. Miau raka malili sonrau, ragumiaume ngeke mate, ta miau ka la lomiautani ba kaka la taungapununge matamiau kanna mename ngarume. ");
INSERT INTO mee_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Miau ra ragau kinung ke ulopataetaea giamiaume sonrau, ragumiaume ngeke mate, ta pala na sisiukerea memena keke kuma minmina ta poropet ra goanga.” ");
INSERT INTO mee_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Bae Iesus ke role kerea bole roma, “Ava iau nga role kamiau raka longlonge pangamologa nga kanau: Miau ngaka materaumane ragau reke baisolali miau. Ba ngaka legemasia ra siarealalali kamiau. ");
INSERT INTO mee_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ngaroma ragau palu ngeke bai ta baingasoali miau, na miau ngaka ballage Nutu ta i nge pe kerea. Ba ngaka kave Nutu ta i nge legemasia ragau reke baiꞌiu kamiau. ");
INSERT INTO mee_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ngaroma agau te nge bali one nga piskone, na one ngo tunge piskone te muni ta i balinge bole. Ba ngaroma agau te nge rave lungapaga ae one e ngapotu, na i nge rave kala nga ne ngallo bole. ");
INSERT INTO mee_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ngaroma agau te nge tanikala one ta kana oru nge one, na sano ngo balipaga ta ollaeala. Ba ngaroma agau te nge sagia oru nga kaning, na sano ngo role kia ta i tungagaliu rea. ");
INSERT INTO mee_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bainga ra miau ka matea ragau ta ri bainga rea te miau, miau bole ngaka bai rea te ri. ");
INSERT INTO mee_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ba ngaroma miau ngaka materaumane reke materaumana miau, na ka sana otte. Ra baingareame ke sosoali keke umma minmina bole. ");
INSERT INTO mee_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ba ngaroma miau ngaka legemasia reke pepe ka miau. Na ka sana otte. Ra baingareame ke sosoali keke umma minmina bole. ");
INSERT INTO mee_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ba ngaroma miau ngaka tungumane otte ta ragau ra miau ka roma, ri keke la alange te mangng muni. Na ka sana otte. Iau ka role minmina kurumea, ra baingareame ke sosoali keke tungumane oru palu ta kolingarea ra baingareame ke sosoali na keke role roma, ri keke la alanga rea te mangng muni. ");
INSERT INTO mee_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ava miau ngaka materaumane ragau reke baisolali miau ba ngaka legemasi rea. Ba nga ina miau ngaka tungumane otte ta agau, na sana nga lomiaukala roma i nge ale te miau. Ngaroma miau ngaka kuma minmina na alanga ae miau ore pe nge bollau raumana, ba miau ngaka base ma goe rae E Ngailu Raumana. Ta i ke pe ka ra loreakalasa ba ra sana loreamannmanna ka oru ra i tungu rea te ri. ");
INSERT INTO mee_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Miau nga lomiaunanne ragau pattoto me Tamamiau nga ina i lonananne ragau kinung. ");
INSERT INTO mee_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Sana ngaka kalinanne ragau pattoto, nae Nutu sane nge kalinanna miau. Ba sana ngaka kinimata ka ragau pattoto, nae Nutu sane nge kinimata kamiau. Ba miau ngaka osurure ragau pattoto baingarea reke sosoali ra ri ke bai rea te miau, nae Nutu nge osurure baingamiau reke sosoali bole. ");
INSERT INTO mee_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ngaroma one a agau a tungakana, nae Nutu ke la tunga te one bole. Ba i nge umma ta pangaponung one bole base ma oru reke paponu rea beke ponutalao. Ngarume na ngeke lulumataga rea muni na oru nge ngallo ngeke pu kalaoveka, na baina ngeke paponu rea muni na ngeke ponutalao ba oru nge ngallo ngeke pu kalaoveka muni. Ngaroma one a agau a tungakana te ragau pattoto, nae Nutu ke la tunga te one bole. Ba ngaroma one a omosakana ta tunga ta ragau pattoto, nae Nutu ke sane la tunga te one bole.” ");
INSERT INTO mee_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ba bole Iesus ke patenikala ka pangamologa te ri roma, “Agau te a matana kanname ke su ke sane nge taoamugmuga ka agau tetoto a matana kanname ke su, ta ri pana lua kinung keke la pupungalu lakallo ta lulu te. ");
INSERT INTO mee_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ba apangalomatanakana goe a kanna te ke sane momo ngailu nga apangalomatanakana ae i. Ke sa. Ava nga ine nge rave lonamatanangana tapu, na i nga tongana kena mana ma apangalomatanakana ae i. ");
INSERT INTO mee_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ke meimia na ko kela paka bega pinsina e sina e momo nga kolingang matana kanna, ava ko sano kela paka bega ine bollau e momo nga matang kanna? ");
INSERT INTO mee_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ko la one roleng mina ngaetai ta kolingang roma, ‘Kolingau, iau ka bai ta pirangmalagange bega pinsina isu laekolong nga matang kanna,’ ava one muni ko sano kela paka bega ine bollau e momo nga matang kanna? Ka one a goangakana. Kapunu, na ngo piramalage bega ine bollau e momo nga matang kanna, na ngarume na ko la kelanga masi ta pirangmalagange isure sina e momo nga kolingang matana kanna. ");
INSERT INTO mee_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Bega reke pepe ka sana kanreame ke sosoali, ba bega reke sosoali ka sana kanreame ke pepe. ");
INSERT INTO mee_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ba keke kelapatokone bega mirana nga bega kanna. Ke sane ke rarave bega ra pik kanna nga oalooalo ra matarea. Ba ke sane ke rarave gerepeme nga kauila lomona bole. ");
INSERT INTO mee_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Agau e pe ka nena ka bainga reke pepe keke momo ngallo nga lona, minmina na i ke pamalaglage oru reke pepe. Ba agau e soali ka nena ka bainga reke sosoali keke momo ngallo nga lona, minmina na i ke pamalaglage oru reke sosoali. Agau kaona ke rorolea taru e momo ngallo nga lona. ");
INSERT INTO mee_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ke meimia na miau kaka patpato iau kae Avolau, ava ka sana ka lolakurumea pangamologa ra kanau? ");
INSERT INTO mee_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Agau e atu te iau, ba ke longe pangamologa ra kanau, ba ke lolakurume rea iau ka la pangakosininge te miau. ");
INSERT INTO mee_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Agau laeala ka baingana ma agau e bai ta kumangng ka bale te. Pala na i nge kilia lulu lakallo, na nge pulia bale puna ginggingngana lakallo ta lollo tatana reke bollalau. Ngarume na me potungana e bollau nge lele na nge pagitue bale laeala. Ava ke sane nge potusisia kurumea, bale laeala ke maispaikalle nga mogalo lona. ");
INSERT INTO mee_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ava agau e longe pangamologa ra kanau ava ke sane lolakurume rea ka tongana kena ma agau e ulopaimane bale ae i nga mogalo, ba ke sane kuma masi ka bale kaena puna. Ngarume na me potungana e bollau ke pagitue bale laeala. Na bale laeala ke masisi bolvole mana, na ke soali bavakena.” ");
INSERT INTO mee_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Na ka inae Iesus rongo ka pangamologa nga oru nginngina, na i ke taolu ta maga kunna e bollau ae Kaperneam. ");
INSERT INTO mee_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na kelangpatali te e ngae Rom nga ra balingkana ka ri giaukaina lima ke momo nga maga laeala. Ba kelangpatali laeala akumangngatulu a kanna a i matea raumana ke soali, ba ke kokoro ta i mateng. ");
INSERT INTO mee_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Na ka ine longe pangamologa e ta Iesus momongana nga maga, na i ke baꞌe Iurame ravollalaukerea palu te i ta ri roleng kia ta baina i atung na pangapenge akumangngatulu ae i. ");
INSERT INTO mee_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Minmina na ri keke loa eke lele nge Iesus, na keke tanikale roma, “Kelangpatali laeo ka i a agau e pe ta ngo kalaue. ");
INSERT INTO mee_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","I ke matea Israelme kinung ba ke pamaisia sinagog ae mangng.” ");
INSERT INTO mee_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ka bainae Iesus ke loa kala nge ri. Avae Iesus ke sane lele kokoro ta bale tale, na kelangpatali laeala ke baꞌe kolinganame ka pangamologa te Iesus roma, “Avolau, sono ngo punu one raumana ta ka sana iau a agau e pe ta one atung ta bale ae iau. ");
INSERT INTO mee_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ba ka sana iau a agau e pe ta iau atung te one bole. Ava one ngo role mana, na akumangngatulu ae iau nge pe. ");
INSERT INTO mee_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Iau ka role minmina ta ka iau a agau e momo ngape nga reke kelapatali te iau bole. Ba ka ra balingkana reke momo ngape nge iau. Minmina na ngaroma iau nga role ka te roma, ‘Ngo loa!’ na i nge longo mana. Ba nga role ka tetoto roma, ‘Ngo atu’ na i nge atu. Ba ngaroma iau nga role ka akumangngatulu ae iau te roma, ‘Ngo kuma ka ollaekia!’ na i nge kuma kia.” ");
INSERT INTO mee_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Na ka inae Iesus longe pangamologa a kelangpatali laeala kanna, na pangamologa laeala ke pamagioe raumana. Minmina na i ke kelapiliu ba ke role ka maluame reke tataokurumea roma, “Iau nga role kamiau roma, iau ka sana kalipa ka te nga re ngae Israel ora lopatokona ae i bollau me aekia.” ");
INSERT INTO mee_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ngarume na kelangpatali kolingana memena keke galiu ta bale, na keke kele kelangpatali akumangngatulu ae i ine pe tapu. ");
INSERT INTO mee_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Na ngarume isura nga kae nginngina, nae Iesus kala nga barangalele ra kanna ba maluame keke loa ta maga kunna te e bollau a giana nge Nen. ");
INSERT INTO mee_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Na ka ineke lele kokoro nga biunga e nga savanau e taliue maga kunna laeala e bollau, na ragau palu keke paupaue agau e mate lagapotu ta baina ri talunge. Agau laeala e mate naname ka nena goe kena mana, ba natale ke matepatalia bole. Na malua reke bollau keke ollekannu ka taningarea ba keke tatao kala nga avale ba tuna laeala e mate. ");
INSERT INTO mee_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ka inae Iesus kela rea, na i ka lonananne bagaru laeala ba ke role kia roma, “Sono ngo tani.” ");
INSERT INTO mee_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Minmina na i ke loa kokoro na ke kali ka oreke pakenolue lavusa ngia, ba reke paue lavusa keke maisisavele. Nae Iesus ke role roma “Goe laekolong a taulai, sigipaga!” ");
INSERT INTO mee_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na goe laeala e mate ke sigipaga, na ke tara ba ke pamologa. Ka bainae Iesus ke baꞌe te naname ka maulingngana. ");
INSERT INTO mee_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Minmina na ragau kinung keke kallo ba keke kalapage Nutu ka rolengareangana roma, “Agau te e toe Nutu kaona e bollau raumana ikia e lele ngaliua nge ita!” Ba keke role bole roma, “Nutu ke atu ta ravunglelenge ragau rae i!” ");
INSERT INTO mee_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Minmina nae Iesus kana turung ke loa kalaoveka nga Iurame mogalo nga ri ba ta ina pattoto bole. ");
INSERT INTO mee_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Na barangalele rae Ion kanna keke loa te i ka ine momo nga pulangkala, na keke turu pakia ka oru nginngina rae Iesus kumkuma ki. Nae Ion ke baꞌe barangalele rae i ");
INSERT INTO mee_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ta ri balinglagange Iesus roma, “Ka one a agau laeala ae Nutu role pala ta i atung, o mangng nga ella ta tetoto?” ");
INSERT INTO mee_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Na ka ina pana lua nginngina ke lele nge Iesus na keke role kia roma, “Ion E Nga Pangamagoe ke baꞌe omea ta balinglaga one roma, ‘Ka one a agau laeala ae Nutu role pala ta i atung, o mangng nga ella ta tetoto?’” ");
INSERT INTO mee_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na ka kae laeala a ri pana lua ke lele nge Iesus, ka kae laeala bole nae Iesus ke papepea ragau ra karea ka soaling matantana, ba ra kannu reke sosoali ke momo nge ri. Ba i ke papea ra matarea kanname ke su, na keke kela muni. ");
INSERT INTO mee_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Minmina nae Iesus ke ale pangamologa ta ragau lua rae Ion roma, “Onemea ngaka loa, na ngaka turu te Ion ka oru kokorai ra iau kuma ki. Ngaka ture oru raka kela rea ba ka longo rea te i roma: Ragau ra matarea kanname ke su keke kelkela, ba ra kaereame ke mate keke tataotupu. Ba ragau ra kalangamugmugu lele nge ri keke pepe, ba ragau ra longareame ke rutu keke longlongo. Ba reke mate keke mauli muni, ba ragau ra sillolo keke longlonge pangamologa e pe. ");
INSERT INTO mee_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ba agau e sane kaꞌe lonapatokonangana te iau nga ine kele kumangng ra kanau nga lonasereng.” ");
INSERT INTO mee_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Na ka ina ragau lua nginngina rae Ion ke loa ka pangamologa alangana te Ion tapu, nae Iesus ke ture Ion ta maluame roma, “Ka ina miau ka loa ta kelange Ion nga ina a sana ragau ngia, na miau kaka loa ta kelange taru? Kaka loa ta kelange agau te e sane gingging basema pailli launa ina bovole isomatagtage ae? ");
INSERT INTO mee_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ngaroma nge sa, na miau kaka loa ta kelange taru? Kaka loa ta kelange agau e lupage lungapaga e pe raumana ae? Ke sa. Ngaka kele. Ragau reke lupage lungapaga reke pepe raumana ba ragau reke tamali ka lollokanna papatu kurumea oru ra sana purea keke mommo nga bale nga kelangpatalime. ");
INSERT INTO mee_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ava kaka loa ta kelange taru mannangana? Kaka loa ta kelange agau te e toe Nutu kaona ae? Iii, iau nga role kamiau roma, miau kaka loa ta kelange agau te e toe Nutu kaona. Ba kaka kele agau te e bollau raumana nga agau te e toe Nutu kaona. ");
INSERT INTO mee_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ion ka i a agau laeala a ri ke paꞌe pangamologa te nga Lau Ae Nutu Kanna pala ore role roma: ‘Ngaka kele. Iau ka la bange agau te pala nge one ta i pulingmalagange pangamologa a kanau, ba i ke la kalingtupunge pamau ae one.’ ");
INSERT INTO mee_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Iau nga role kamiau roma, nga mogalo laekia e ngape Ion giana ke bollau raumana nga ragau kinung giareame. Ava agau a giana sina bavakena nge Nutu kelangpatalingana nga tava ke bollau nge Ion.” ");
INSERT INTO mee_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Na ka ina ragau kinung ba ragau reke raravukinunge takisme ke longe Iesus pangamologangana laeala, na keke role roma “Nutu baingana ke pe.” Ri keke role minmina kurumea, pala na ri keke loa te Ion ta i pangamagoe rea. ");
INSERT INTO mee_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Avae Parisiome ba ra lomatanakana ka bangapagame ba bainga rae Iurame ka sana omorea ta Ion nge pamagoe rea. Ba ollaeala ke pakosining roma, ri ke sane ke matea Nutu kumangngana nge ri. ");
INSERT INTO mee_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Bae Iesus ke role bole roma, “Iau ka la maingamia ka tongau ka ragau reke momomauli sonrau? Ba ka baingarea ma taru? ");
INSERT INTO mee_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ri ka tongarea kena ma ragoeme reke tattara nga malle nga banga ka kaning, ba keke kikiu ta goe pattoto ka rolengarea kerea roma, “‘Mangng ka isoe isongome ta miau pesing, ava miau ka sana ka bai ta pesing. Ba mangng ka baue baunga te e nga lotaningngana, ava miau ka sana ka bai ta taning.’ ");
INSERT INTO mee_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Iau ka role minmina kurumea, ka inae Ion E Nga Pangamagoe atu, na i ke kuriri ta kaning ba ke sane innue uain. Na miau kaka roma, ‘Kannu e soali te ke momo nge i!’ ");
INSERT INTO mee_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Sonrau nae Agau Tuna ke atu ba ke kaninnia kaning ba ke innue uain. Na miau kaka rorole roma, ‘Ngaka kele agau laeala! Ka i agau a kaningkana ba inung uainkana. Ba ka i a raravungkinung takismekana ba ragau re sane ke lolakurumea bangapagame kolingngarea te.’ ");
INSERT INTO mee_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ava iau nga role kamiau roma, ragau ra loreamatana ka lomatana e pe keke la pangakosining ka lomatana laeala ae ri ka baingareame.” ");
INSERT INTO mee_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ka kae te, nae Parisio a giana nge Saimon ke ba te Iesus ta i atung ta kaning. Minmina nae Iesus ke loa ta bale ae i, na ke tara ka bongapaikalanganakia ta kaning. ");
INSERT INTO mee_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na avale te a pamau luana ke mommo nga maga kunna laeala e bollau. ");
INSERT INTO mee_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ba avale laeala ke longe inae Iesus mommo be kaninni nga bale ae Parisio. Minmina na i ke loa ka saulang a koina lolo. Na ke lu ta bale ba ke maisi ngarume nge Iesus kaename. Na i ke tantani ba matana kanna mena ke pupupai nge Iesus kaename. Minmina na i ke taupunpunu rea ka gilina bulvunna ba ke kalapitpite kaona nga ri be lingilolo rea ka saulang a koina lolo. ");
INSERT INTO mee_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ava ka inae Parisio laeala e ba te Iesus kele ollaeala, na i ka lonagomello roma, “Ngaroma aekia nga i a agau te e toe Nutu kaona, na i nga lonamatana roma tai ke kali kia. Ba nga lonamatana roma ka i a avale matana a baingana maimia.” ");
INSERT INTO mee_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nae Iesus ka lonamatana ka lonagomellongana, na ke ale ka rolengana kia roma, “Saimon, iau ka bai ta roleng kone ka otte.” Ka bainae Saimon ke role roma, “Apangalomatanakana, on to rolea te iau.” ");
INSERT INTO mee_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nae Iesus ke panana te i roma, “Ka kae te pala na ragau lua keke rave lollokanna palu nga agau te a kanna ka lollokanname. Te ke rave lollokanna ka ri giaukaina lima, ba te ke rave tangulelu mana. Na agau laeala a kanna ka lollokanname ke momalla ta alangareangana. ");
INSERT INTO mee_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ava ka sana kanrea lollokanna ta ri pana lua alanga rea te i. Minmina na agau laeala ke osurure lollokanna nginngina ra ri pana lua ke ravu rea nge i. Ava ka bai ta balinglaga one roma, tai e nge ri pana lua sonrau ke materaumane agau laeala a kanna ka lollokanname?” ");
INSERT INTO mee_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nae Saimon ke ale balinglagangana roma, “Iau ka roma, agau eke osurure kanna ka lollokanna e bollau nanguni.” Nae Iesus ke ale roma, “Ko alamasia pangamologa.” ");
INSERT INTO mee_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ka bainae Iesus ke kelapiliu ta avale laeala na ke role kae Saimon roma, “Ko kele avale laekia? Iau ka lu ta bale ae one. Na one ko sano tunge me ta mumunge kaegu kurumea bainga ae ita, ava avale laekia ke mume kaegu ka matana kanna mena. Ba i ke taupunu rea ka gilina bulvunna. ");
INSERT INTO mee_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ba one ko sano tagukao kau nga ragugu kurumea bainga ae ita, ava ngo kele avale laekia ke kalapitpite kaona nga kaegume tale. ");
INSERT INTO mee_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ba bole one ko sano lingilole kurugu ka saulang kurumea bainga ae ita e nga silaenga, ava avale laekia ke lingilole kaegume ka saulang a koina lolo. ");
INSERT INTO mee_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Minmina na iau nga role kone roma, avale laekia matengraumanangana e bollau ke pakosining roma, Nutu ke osurure baingana papatu reke sosoali tapu. Ava agau a Nutu osurure baingana tutuna reke sosoali ka kana ka matengraumanangana e sina mana.” ");
INSERT INTO mee_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nae Iesus ke role ka avale laeala roma, “Iau ka osurure baingangame reke sosoali.” ");
INSERT INTO mee_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Na ragau pattoto reke tattara nga pala keke palirole kerea roma, “Tai ikia, ka baina i ke roma i e osurure bainga reke sosoali?” ");
INSERT INTO mee_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Avae Iesus ke role ka avale laeala roma, “Lopatokona ae one ke ravulele one, minmina na ngo loa ka longopengana.” ");
INSERT INTO mee_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ngarume isura nga oru nginngina, nae Iesus ke tutapu ta taliunga nga maga kunna reke bollalau ba nga maga reke sisina bole. Na i ke pulimalaglage pangamologa e pe ore ta Nutu kelangpatalingana ba Pana Tangulelu Ba Lua keke tatao kala nge i. ");
INSERT INTO mee_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ba ravale palu ra i taomalage kannu reke sosoali pala nge ri, ba ravale palu ra i papea soaling nga ri keke tataokurume rea bole. Ravale nginngina giareame nge: Maria eke patoe kae Magaralene e pala nae Iesus ke taomalage kannu reke sosoali ka ri lima ba lua nge i; ");
INSERT INTO mee_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","bae Ioana a natale nge Kusa a i a barangalele te nga bale ae kelangpatali ae Eroto; ba avale tetoto a giana nge Susana kala nga ravale pattoto bole. Na ravale nginngina keke kalaulaue Iesus kala nga barangalele ra kanna ka oru nga kanrea. ");
INSERT INTO mee_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Na ragau karolu nge nga maga kunna papatu keke atu te Iesus. Ba ka ina malua e bollau katukala kinung, nae Iesus ke role ka pangateningkalangana kerea roma: ");
INSERT INTO mee_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ka kae te na agau te ke loa ta tapunge pailli matana te kanname nga ura ae i. Ba ka ine taptapu rea nga mogalo, na palu keke pupu nga pamau bavana. Na ragau keke paꞌta innta rea ba manu reke lolo nga tava keke kani rea. ");
INSERT INTO mee_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ba palu keke pupu nga mogalo ina i a lollo, ava ka ineke kalapa, na keke manani bolvole mana kurumea, mogalo inaeala ke galgalangngpa. ");
INSERT INTO mee_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ba pailli kanna palu muni keke pupu ngaliua nga oalo ra matarea. Na oalome ba paillime keke lele kinung, ava oalome keke kalipalipita ka pailli nginngina, na keke mate. ");
INSERT INTO mee_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ava pailli kanna palu keke pupai nga mogalo ine pe. Na keke lele bollau ba keke piau masi. Ba kenakena ka kanna papatu raumana.” Ka inae Iesus rorolea oru nginngina, na i ke kikiu roma, “Ngaroma agau te nga omona ta longa, na i nge longe pangamologa laekia.” ");
INSERT INTO mee_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Na barangalele ra kanna keke paturu ta balinglagange Iesus ka pangateningkala laeala puna. ");
INSERT INTO mee_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Minmina na i ke role kerea roma, “Nutu ke tunge lomatana te miau ta baina nga lomiaumatana ka oru re ta Nutu kelangpatalingana nga tava onreke kolulu. Ava iau nga patenikale pangamologa ta ragau pattoto ta baina: “‘ri ngeke kelkela, ava ke sane ngeke kelapatokona; ba ngeke longo, ava ka sana nga loreamatana.’ ");
INSERT INTO mee_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Pangateningkala laeala ore ta agau e taptapue pailli kanname nga ura ka mirana minakai roma: Pailli kanname ka ri ra pangamologa rae Nutu kanna. ");
INSERT INTO mee_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ba pailli kanna reke pupu nga pamau ka i a pangateningkala e ta ragau reke longe pangamologa ae Nutu kanna, ava ngarume nae Satan nge atu na nge kapatali ka pangamologa laeala nga lorea. I nge bai minmina ta baina ri manereasa loreapatokona, nae Nutu ke sane nge ravulele rea. ");
INSERT INTO mee_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ba pailli kanna reke pupu nga mogalo ina i a lollo ka i a pangateningkala e ta ragau reke longe pangamologa ae Nutu kanna, na keke kampite ba keke sereng te. Ava ri ka tongarea kena ma pailli kanna a kulana sane sigilu lakallo ta mogalo. Ri ka loreapatokona ta pangamologa ae Nutu kanna ka kae palu, ava ka ina avangame ke lele na keke kaꞌe lopatokona laeala ae ri. ");
INSERT INTO mee_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ba pailli kanna reke pupu ngaliua nga oalo ra matarea ka i a pangateningkala e ta ragau reke longe pangamologa ae Nutu kanna, ava oru re nga mogalo laekia e ngape ra ri ka loreavavai tao, ba oru re nga mogalo laekia e ngape reke pepe beke kelamasi ra ri ke mate rea keke kalipita rea, na ke sane ke matua. ");
INSERT INTO mee_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ava pailli kanna reke pupu nga mogalo ine pe ka i a pangateningkala e ta ragau reke longe pangamologa ae Nutu kanna, na keke kampite nga lorea reke pepe. Ba ka loreasoalipite, minmina na ri ka tongarea kena ma bega e meisgingging be piau masi ba ka kanna papatu.” ");
INSERT INTO mee_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nae Iesus ke role ka pangateningkalangana bole roma, “Agau nge tonge lama na ke sane nge pakompite ka otte. O ke sane nge pasasalue ta nia siana. Ke sa. I nge patarapaia nga pangatara te ta baina reke lu ngeke kela nga olamana. ");
INSERT INTO mee_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Iau ka role minmina kurumea, ngarume nae Nutu ke la pangapotange orume kinung ra ragau ke pako rea sonrau. Ba orume kinung ra ragau ke talu rea sonrau keke la leleng nga olamana ngarume. ");
INSERT INTO mee_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Minmina na miau ngaka longo masi nasai. Nutu ke la tungnge lomatana papatu muni ta agau a kana lomatana nga baina i nga kana lomatana papatu raumana. Ava nga agau a sana kana lomatana, Nutu ke la ravungpatali ka lomatana ae i e sina nga baina i sana nga kana lomatana bavakena.” ");
INSERT INTO mee_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nae Iesus naname ba teiteikia memena keke atu ta ri kelange, ava maluame ka ri papatu raumana. Minmina na ri keke baililli ta loanga kokoro te i. ");
INSERT INTO mee_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Na agau te ke role kae Iesus roma, “Name bae teiteikone memena keke maisinsi io ngapotu, ba keke matea ta ri kelanga one.” ");
INSERT INTO mee_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Avae Iesus ke ale agau laeala ka rolengana ka ragau reke momo roma, “Nau bae teiteikau memena ka ri ra ragau reke longe pangamologa ae Nutu kanna beke lolakurumea.” ");
INSERT INTO mee_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ka kae te nae Iesus ke role ka barangalele ra kanna roma, “Ita ngaka loa ta me a sivoli bavana tetoto.” Minmina na ri keke taepatae nga manang te na keke kalapatae. ");
INSERT INTO mee_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ba ka ineke lola, nae Iesus ke kenrarau. Na sauu e bollau ke lelekala rea nga me a sivoli, ba maliliugame keke tugutatao ta manang lona. Minmina na manang ke bai ta i maraleng kerea. ");
INSERT INTO mee_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na keke loa eke pangoe ka rolengarea roma, “Avolau, Avolau. Ita kaka marannrale!” Minmina na i ke sigipaga na ke baullupite sauu ba miniuame reke balikolkolo, na keke malo bavakena. ");
INSERT INTO mee_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Na ke ballage barangalele ra kanna roma, “Ka ma sana lomiaupatokona?” Ka ina barangalele ra kanna ke kele ollaeala e lele, na keke matau ba keke kallo. Na keke palirole kerea roma, “Tai ikia nge aekia? I ke bapage sauu ba miniuame na keke longo te i mana.” ");
INSERT INTO mee_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Na keke loa eke lele nga ine ngae Gerasenesme e momo nga sivoli bavana tetoto ngae Galili. ");
INSERT INTO mee_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ba ka inae Iesus solele nga manang, na agau ora kannu reke sosoali ke momo nge i ba ka i a agau te e nga maga kunna laeala e bollau ke atu te i. Na agau laeala ke sane sisinsilia malo, ba i ke sane momo innta nganige nga bale. I ke mommo mana nga bavengeme reke tatalue ragau reke mate ngi. ");
INSERT INTO mee_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Na ka ina agau laeala kele Iesus, na i ke reli kaligi ka toangaraungana nge Iesus kaena puna. Ba ke tanikale Iesus roma, “Iesus, Nutu E Ngailu Raumana Tuna, one ko bai ta maingamia kau? Ka tanikala one ta one sano ngo pamiralali iau!” ");
INSERT INTO mee_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","I ke tanikala minmina kurumea, pala nae Iesus ke bapage kannu laeala e soali ta i lelengmalaga patali nga agau laeala. Ka kae papatu, na kannu laeala e soali ke luluia mirana ba ke pasigsigia. Ba ragau keke samapitpite kamaname ba kaename ka oalo ra sene, ba keke ellapatantali te i. Ava i ke burumotmotue oalo nginngina ba kannu laeala e soali ke kaka kia ta ina nga sana ragau ngi. ");
INSERT INTO mee_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ka bainae Iesus ke ballage roma, “Giang nge tai?” Na i ke ale roma, “Barana.” I ke role minmina kurumea, kannu barana reke sosoali keke luia mirana. ");
INSERT INTO mee_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ba kannu nginngina reke sosoali keke tanikalkale Iesus ta i sane nge balu rea ta lulu a sana puna. ");
INSERT INTO mee_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na ka gie barana te ke kaninni nga inaeala nga kapangng. Minmina na kannu nginngina reke sosoali keke tanikale Iesus ta i nge balu rea lakallo ta gie barana laeala. Nae Iesus ke ngatakala rea. ");
INSERT INTO mee_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Na ka ina kannu reke sosoali ke lelemalaga patali nga agau laeala, na keke luia gie nginngina. Ba gie barana laeala ke tumvalivu maling nga ina i a mantapu, na ke toarallu kerea nga me a sivoli. Na keke marale ba keke mate. ");
INSERT INTO mee_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na ka ina ragau reke ellapatantali ta gie nginngina ke kele ollaeala e lele, na keke kaꞌe inaeala. Na keke ture ngallo nga maga kunna e bollau ba nga iname kalaoveka nga inaeala. ");
INSERT INTO mee_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Na ragau reke longe keke atu ta kelange ollaeala e lele. Ba ka ineke lele nge Iesus, na keke kele agau laeala e pala na kannu reke sosoali ke momolu nge i. Ava sonrau na ramana ke pe ba ke tattara ka lungapaga kokoro nge Iesus kaena puna. Ba ka ina ragau nginngina reke atu ke kele, na keke matau raumana. ");
INSERT INTO mee_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na ragau reke kele inae Iesus taomalage kannu reke sosoali keke ture oru reke lele ta ragau reke atu. Keke turu ta inae Iesus papea agau laeala ora kannu reke sosoali ke momolu ngia pala. ");
INSERT INTO mee_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Na ragau kinung re nga ine ngae Gerasenesme ka loreasoali, na keke ballage Iesus ta i nge ka rea. Nae Iesus ke taepatae nga manang ta i kangagaliu. ");
INSERT INTO mee_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Na agau laeala a kannu reke sosoali ke kapatalia ke botu ta i loangakurumea Iesus, avae Iesus ke bokale ka rolengana roma, ");
INSERT INTO mee_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ngo galiu ta maga na ngo ture taru rae Nutu kuma ki nge one.” Minmina na agau laeala ke loa, na ke turu kalaoveka nga maga kunna e bollau ka taru rae Iesus kuma ki nge i. ");
INSERT INTO mee_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na maluame keke momalle Iesus nga me a sivoli bavana a i momo ngia pala, minmina na ka ine galiu na keke tagukama kia. ");
INSERT INTO mee_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Na agau te a giana nge Iairus a i a kelangpatali nga bale a sinagog ke momo. Ba agau laeala tuna piau a nena pesingmatana tangulelu ba lua ke kokoro ta i mateng. Minmina na i ke loa te Iesus ba ke pupu kokoro ta kaena puna, na ke tanikale Iesus ta i loangakurumea ta bale ae i. Ba ka inae Iesus tatao e lola, na ragau papatu keke pavimvi rea nge i. ");
INSERT INTO mee_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na avale te ke momo nga inaeala kala nge ri. Ka i a avale ore tattara ka luvo ka kaeme kinung ka pesingmataname ka ri tangulelu ba lua, ava ka sana agau te ora kana ka gingginga ta i pangapenge soaling laeala ae i. ");
INSERT INTO mee_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Na avale laeala ke loa kokoro te Iesus nga gina, na ke kali ka lungapaga ae i sigina matana. Ba ka panna laeala mana, na totona taongana ke rongo. ");
INSERT INTO mee_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nae Iesus ke ballaga roma, “Tai ke kali kau?” Ba ka ina ragau kinung ke kauli, nae Pita ke role roma, “Avolau, malua ke ponu ba keke pavimvi rea nge one.” ");
INSERT INTO mee_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Avae Iesus ke role roma, “Ke sa. Agau te ke kali kau ta gingginga palu keke lelemalaga nge iau ta pangapenge agau laeala.” ");
INSERT INTO mee_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na avale laeala ka lonamatana roma, i ke sane la konga. Minmina na i ke atu ka mirana mammalungana, na ke pupisigi ngamuga nge Iesus. Na i ke turupota nga ragau kinung ragurea ka ine kali kae Iesus na mirana ke pe. ");
INSERT INTO mee_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nae Iesus ke role kia roma, “Tugu piau, lopatokona ae one ke pape one. Ngo loa ka lomannmannangana.” ");
INSERT INTO mee_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ba ka inae Iesus pamolloga tale, na agau te e pa nga bale ae Iairus a i a kelangpatali nga sinagog ke lele. Na agau laeala ke role roma, “Sano ngo ballage apangalomatanakana ta i loanga muni, ta tungu piau ke mate tapu.” ");
INSERT INTO mee_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ava ka inae Iesus longe ollaeala, na ke role kae Iairus roma, “Sano ngo matau. Nga longopatokona mana te iau, na i ke la penga.” ");
INSERT INTO mee_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ka ina ri ke lele nga bale ae Iairus, nae Iesus ka sana omona ta agau te nge lukurumea, kana kae Pita, bae Ion, bae Iems, ba goe tamana bae naname mana. ");
INSERT INTO mee_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na ragau kinung keke tantani beke ollekannu ta goe laeala. Minmina nae Iesus ke role kerea roma, “Manemiausa taning ta i ke sane mate, ava ke kenrarau.” ");
INSERT INTO mee_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Na ka inae Iesus role minmina, na ri keke malilia ta ka loreamatana roma, goe laeala ke mate tapu. ");
INSERT INTO mee_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Avae Iesus ke kampite goe laeala avale kamana, na ke role kia roma, “Tugu piau, ngo sigipaga!” ");
INSERT INTO mee_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Minmina na goe laeala kannuna ke lupage muni, na ke sigipaga bolvole. Nae Iesus ke role kerea ta ri tunga kana kaning ta baina goe laeala nge kani. ");
INSERT INTO mee_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na goe laeala tamana bae naname keke kallo, avae Iesus ke parototokala rea ta ri nga manereasa turung ta agau te ka taru e lele. ");
INSERT INTO mee_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nae Iesus ke kiukinunge Pana Tangulelu Ba Lua, na ke tunge gingginga ba giana ginggingngana te ri ta baina ri ngeke taomalage kannu reke sosoali nga ragau ba ngeke rongo ka soaling matantana. ");
INSERT INTO mee_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ba i ke ba rea ta pulingmalagange pangamologa e ta Nutu kelangapatalingana ba ta ri pangapenge ragau ra karea ka soaling. ");
INSERT INTO mee_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ba pala ta ri loanga, na i ke role kerea roma: “Miau sana ngaka loa ka oru re nga taonga basema: to e nga kalaunge taongamiaungana, ba bising, ba kaning, ba lollokanna. Ba sana ngaka paue lungapaga tetoto. ");
INSERT INTO mee_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Na nga ina miau ngaka lu nga bale te, na ngaka momo nga bale laeala ta nge lele ina miau ngaka kaꞌe maga kunna laeala e bollau. ");
INSERT INTO mee_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ava ngaroma ragau ke sane ngeke tagukama kamiau, na ngaka lulupatali ka magavusa nga kaemiau sianame nga ina miau ngaka kaꞌe maga kunna laeala e bollau. Ka la i a killa a panaunga te ri roma, keke baia bainga e soali.” ");
INSERT INTO mee_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ka baina barangalele rae Iesus kanna keke tutapu ta maga kenakena, ba keke pulimalaglage pangamologa ae Nutu kanna e pe. Ba keke papepea ragau nga iname kinung. ");
INSERT INTO mee_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nae Eroto a i e kapunu nga gavaman e ngae Rom nga inaeala ke longe pangamologa re ta oru nginngina rae Iesus ba barangalele ra kanna ke kumkuma ki. Ba i ka lonatangtang raumana kurumea, ragau palu keke rorole roma, Ion E Nga Pangamagoe ke sigipaga nga mateng na ke kumkuma ka oru nginngina. ");
INSERT INTO mee_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ba palu keke rorole roma, Ilaia ame mate pala ava ke lele muni. Ba palu muni keke rorole roma, agau te e toe Nutu kaona e mate pala ava ke mauli muni. ");
INSERT INTO mee_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Avae Eroto ke role roma, “Iau ka battote Ion ganna tapu. Ava tai ikia mannangana a iau longlonge oru kokorai ra i umma ki?” Minmina na i ke amva ta i kelange Iesus. ");
INSERT INTO mee_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na ka ina aposel rae Iesus ke galiu, na keke ture oru ra ri ke kuma ki te Iesus. Na i ke loa kerea, ba keke kaꞌe maluame, na keke loa ta maga kunna e bollau a giana ngae Betsaira. ");
INSERT INTO mee_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ava maluame ka loreamatana ka loangarea, na keke kutapu kurume rea. Nae Iesus ke tagukama kerea, ba ke pulimalage pangamologa e ta Nutu kelangapatalingana te ri. Ba i ke papea ragau re nge ri ra karea ka soaling. ");
INSERT INTO mee_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Na ka laio ina kae barelulu, na Pana Tangulelu Ba Lua keke loa te Iesus, na keke role kia roma, “Ngo baꞌe maluame ngeke loa nga baina ri ngeke sili karea kaning kalaoka ba mallerea nga kenong nga maga nginngina, ta ita kaka momo nga malle a sana kaning ngia.” ");
INSERT INTO mee_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Avae i ke ala rea roma, “Miau ngaka tungu karea kaning.” Na keke ale roma, “Ngaroma mangng sana nga loa ta koling maluame karea kaning, na ita ka la maingamia ta ka kamangnga bereteme ka ri lima ba lea lua mana rikorai?” ");
INSERT INTO mee_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Ba ka kae laeala na ke kela basema ra panung ka ri 5,000 keke momo.) Nae Iesus ke role ka barangalele ra kanna roma, “Ngaka role kerea, na pana giaukaina lua ba tangulelu ngeke tara nga ginunga kenakena.” ");
INSERT INTO mee_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ka baina barangalele ra kanna keke kuma minmina, na ri kinung keke tara. ");
INSERT INTO mee_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nae Iesus ke rave bereteme ka ri lima ba lea lua nginngina, na ke kelapatae ba ke kalapage Nutu. Na i ke regipale bereteme ba ke kole leame. Na ke tungu rea ta barangalele ra kanna ta ri tavoanga ki nga ragau. ");
INSERT INTO mee_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Na ragau kinung keke kani ba keke rongo ka loreanganame ka kaning laeala. Na barangalele rae Iesus kanna keke ravukinunge kaning kaloname reke kanilele rea, na keke paponue guratame ka ri tangulelu ba lua ki. ");
INSERT INTO mee_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ka kae te, na barangalele rae Iesus kanna keke momo kala nge i ka ina i kavkava mana me i. Minmina na i ke ballaga rea roma, “Maluame keke rorole roma, iau a tai?” ");
INSERT INTO mee_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Na ri keke ale roma, “Palu keke rorole roma, Ion E Nga Pangamagoe ame mate ave mauli muni. Ba pattoto keke rorole romae Ilaia. Ba palu muni keke rorole roma, agau te e toe Nutu kaona ore mate pala ave mauli muni.” ");
INSERT INTO mee_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nae Iesus ke ballaga rea bole roma, “Ava miau kakorong, kaka role roma, iau a tai?” Nae Pita ke ale roma, “Ka one ae Karais laeala orae Nutu baꞌe.” ");
INSERT INTO mee_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nae Iesus ke tunge pangamologa e gingging te ri ta ri nga manereasa turunge ollaeala ta ragau. ");
INSERT INTO mee_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ba ke role bole roma, “Agau Tuna ke la kaningmainge miralali papatu. Bae Iurame ravollalaukerea memena, ba re kapunu nga pirisme, ba ra pangalomatanakana nga bangapagame, ri nginngina kinung keke la tangunglelenge. Ba ragau ngeke balia, na nge mate. Ava nga kae a mologi ngarume nga matengana, na i ke la sigingpaga muni.” ");
INSERT INTO mee_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Na i ke role ka barangalele ra kanna ba ta ragau kinung bole roma, “Ngaroma agau te nge bai ta atung kurume iau, na i nge bali ka gina ta i muni lonamatenganame ba nge rave maiskovu ae i ka kaeme kinung, na nge tataokurume iau. ");
INSERT INTO mee_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Iau ka role minmina kurumea, agau e bai ta ravunglelenge i muni maulingngana ke la pangasanrea kia. Ava agau e pasanrea ka i muni maulingngana kurumea taongakurumengana kau ke la ravunglelenge maulingngana. ");
INSERT INTO mee_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Iau ka role minmina kurumea, agau ke la ravunge taru, ngaroma i nge rave orume kinung reke pepe nga mogalo laekia e ngape sonrau, ava ngarume na i muni nge sanrea? ");
INSERT INTO mee_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Iau ka role minmina kurumea, agau a balenglengea ta turungpotange lopatokona ae i te iau ba ta pangamologa ra kanau sonrau, Agau Tuna ka la balenglengea ta agau laeala ngarume nga ine nge atu ngallo nga olamana ae i e toakala kala nga Tamana ba anggelo reke tupu lamarea e toakala. ");
INSERT INTO mee_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ava iau nga role kamiau ka kaomannmannangana roma, palu nge miau raka meisinsi ikia ke sane ke la mateng ta nge lele nga ina ri ke la kelange Nutu kelangpatalingana.” ");
INSERT INTO mee_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Na ka kaeme ka ri basema lima ba mologi ngarume nga Iesus pangamologangana nginngina, na i ke rave Pita, bae Ion, bae Iems kala nge i. Na ke loapatae nga kapangng te ta i kavang te Nutu. ");
INSERT INTO mee_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ba ka ine kavkava, na mirana ka kelangana toto. Ba lungapaga rae i keke kavauvaunga raumana ba ka lamarea raumana. ");
INSERT INTO mee_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na rapanung lua keke lele nga olamana e toakala, na keke pamolloga kala nge Iesus. Ba pana lua nginngina te ka i ae Moses ba te ka i ae Ilaia. ");
INSERT INTO mee_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Keke pamolloga ta isura, nae Iesus la kange mogalo laekia e ngape nga ine nge mate ngae Ierusalem. ");
INSERT INTO mee_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nae Pita kala nga balingana memena keke kenrarau. Ava ka ineke lala kerea, na keke kele Iesus lamanangana ba pana lua ineke maisinsi kala nge i. ");
INSERT INTO mee_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Na ka ina pana lua nginngina ke bai ta kange Iesus, nae Pita ke role kia roma, “Avolau, ke pe ta mangng momong nakai. Mangng ka la pangamaisinge balvaleme ka ri mologi nga baina nga ningi te, bae Moses nga nena te, bae Ilaia nga nena te bole.” (Avae Pita ka sana lonamatana ka taru a i rorolea.) ");
INSERT INTO mee_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ba ka ine pamolloga tale, na mumukua te ke lele ba ke gasipita rea. Ba keke matau ka ineke taolu kerea nga mumukua laeala. ");
INSERT INTO mee_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na kaling te ke lelemalaga nga mumukua laeala ka pangamologangana roma, “Aekolong ka i ae Tugu ora iau tore. Ngaka longo te i!” ");
INSERT INTO mee_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ka ina kaling laeala lele tapu, na keke kele Iesus ine momo mana me i. Na barangalele rae Iesus kanna keke malopite ollaeala mana nge ri, ba ke sane ke ture ollaeala a ri ke kele ta agau te ka kae nginngina. ");
INSERT INTO mee_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Me ngangaila, nae Iesus kala nga pana mologi nginngina keke sopisigi nga kapangng. Na malua e bollau keke atu te i. ");
INSERT INTO mee_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na apanung te ngaliua nga malua laeala ke kiu te Iesus roma, “Apangalomatanakana, iau ka tanikala one ta ngo kalaue tugu, ta ka i a goe kena mana ae iau. ");
INSERT INTO mee_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ka kae papatu na kannu te e soali ke umma ta ravungpitange, ba ka ina kannu laeala e soali nge rapite, na i nge reli bolvole. Ba kannu laeala nge tamali kia ka lulungmatagangana kia, na kaona mena e kavauvaunga nge olle. Ba kannu laeala e soali ke sane kakaꞌe, ba ke umma ta baingasoalinge raumana. ");
INSERT INTO mee_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ba iau ka tanikale barangalele ra kaning ta ri taongamalagange, ava ka sana karea gingginga.” ");
INSERT INTO mee_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nae Iesus ke ale roma, “Miau ra ragau raka momo sonrau, ka sana lopatokona nge miau, ba lomiaume ke sane ke tupu. Iau ka la momong kala nge miau pa pia muni? Ba ka la kalaungapaga miau pa pia? Atu ka tung nasai.” ");
INSERT INTO mee_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ka ina goe laeala lola te Iesus tale, na kannu e soali ke tamali kia ta mogalo ka lulungmatagangana kia. Avae Iesus ke sanggipite kannu laeala e soali, na goe laeala a panung ke pe. Nae Iesus ke tungugaliue te tamana. ");
INSERT INTO mee_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ba ragau kinung keke kallo ka kelangareangana ka Nutu ginggingngana. Ava ka ina ragau kinung ke umma ta magionga raumana ta oru nginngina rae Iesus kuma ki, na i ke role ka barangalele ra kanna roma, ");
INSERT INTO mee_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ngaka longo masi ta pangamologa laekia a iau la roleng ka miau kia. Ragau keke la ulonge Agau Tuna nga reke bai ta baingasoalinge kamareame.” ");
INSERT INTO mee_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ava barangalele ra kanna ka sana loreamatana ka pangamologangana laeala mirana. Ka sana loreamatana kurumea, Nutu ke pakoea nge ri ta baina ri sane ngeke longopatokone. Ba keke matautau ta ri balinglagapitange Iesus. ");
INSERT INTO mee_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Na palingtete te ke lele ngaliua nga barangalele rae Iesus kanna ore ta tai e nge ri ka la i e kapunu. ");
INSERT INTO mee_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Avae Iesus ka lonamatana ka lovaingana matana a taru ke momo ngallo nge ri. Minmina na i ke rave goe apanung ore sina, na ke pamaisia nga bavana. ");
INSERT INTO mee_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Na ke role kerea roma, “Agau a lonangatakale agau a sana giana basema goe tulaekia e sina ka lonangatakala iau. Ba agau a lonangatakala iau ka lonangatakale Nutu e ba iau bole. Agau e ulopisigia i muni ngape be kalaulaue miau kinung, agau laeala ka i e kapunu nge miau.” ");
INSERT INTO mee_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nae Ion ke role roma, “Avolau, mangng ka kele agau te ore taomalaglage kannu reke sosoali ka gianga, ava i ke sane tatao kala nge mangng kurume one. Minmina na mangng ka role kia ta i nga manenasa kumangng ka ollaeala.” ");
INSERT INTO mee_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Avae Iesus ke ale roma, “Manemiausa bongakalange kurumea, agau e sane sanangkalkala miau ke kalaulau miau.” ");
INSERT INTO mee_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na kae e ta Nutu ravungpataenge Iesus ta mallena nga tava ke lele kokoro, minmina na i ka lonangana mannangana ta i loanga tupu tae Ierusalem. ");
INSERT INTO mee_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ka baina i ke baꞌe ragau ka pangamologa pala ta maga kunna te e bollau ae ngae Sameriame ta baina ri kalingtupunge orume. ");
INSERT INTO mee_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ava ragau re nga maga kunna laeala ke sane ke rave kurumea, i ka lonangana ta loanga tae Ierusalem. ");
INSERT INTO mee_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Na ka ina barangalele lua ra kanna ae Iems bae Ion ke kele ollaeala, na ri pana lua keke ballage roma, “Avolau, ko matea ta mangnga nga bapage sia e ngailu nga tava, na nge atupisigi ta tonge ra kokorai?” ");
INSERT INTO mee_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Avae Iesus ke kampiliu, na ke sanggipite barangalele ra kanna nginngina. ");
INSERT INTO mee_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Na ri keke loa ta maga kunna tetoto. ");
INSERT INTO mee_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Na ka ineke tataokurumea pamau, na agau te ke role kae Iesus roma, “Iau ka la loangakurume one ta ina nge ngaetai ra one la loanga tao.” ");
INSERT INTO mee_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nae Iesus ke ale roma, “Gauve ra pinolo ka karea malle ta ri momong ngi, ba manu reke lolo ka ginureame, avae Agau Tuna ka sana mallena ta pakenonge kunna ngia.” ");
INSERT INTO mee_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ba i ke role ka agau tetoto roma, “Atukurume iau.” Ava agau laeala ke role roma, “Avolau, iau nga loa nga baina nga talue tamau ngana.” ");
INSERT INTO mee_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Avae Iesus ke role kia roma, “Ragau reke mate ngeke talue ragau rae ri muni reke mate, ava one ngo loa na ngo pulimalage pangamologa e ta Nutu kelangpatalingana.” ");
INSERT INTO mee_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ba tetoto ke role roma, “Avolau, iau ka la loangakurume one, ava iau nga loa nga baina nga kelatape re nga balekaina ae iau ngana.” ");
INSERT INTO mee_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nae Iesus ke ale ka pangateningkala roma, “Agau e loa ta kumangng ave kelkela lagarume tale, agau laeala ke sana sinakala ta i kumangng nga Nutu kelangpatalingana.” ");
INSERT INTO mee_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ngarume nga pangamologa nginngina nae Iesus ke tore pana giaukaina mologi ba tangulelu ba lua ta ri loanga pala nge i ta maga kunna reke bollau ba ne ngeke sina bole ra i la loanga tao. ");
INSERT INTO mee_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ba i ke role ka pangateningkalangana kerea roma, “Ka kaning papatu nga ura ta lalanga rea, ava ka sana barangalele papatu ta ravungkinungu rea. Minmina na miau ngaka kava te Nutu a i a ura tamana ta i bange barangalele ta ri lalang nga ura ae i. ");
INSERT INTO mee_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ngaka longo! Iau ka bava miau lagapotu ma sipsip goekia reke momo ngaliua nga gauve ra pinolo. ");
INSERT INTO mee_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ava miau sana ngaka paue bising e sina, o ne bollau, o kesingsilagi palu muni. Ba sana ngaka maenakinkini nga ina miau ka kele agau te nga pamau. ");
INSERT INTO mee_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ba pala ta miau lunga ta bale, na ngaka role ka tagungkama ngamiaungana roma, ‘Nutu ka lonamannmanna ka ragau reke momo nga bale laekia.’ ");
INSERT INTO mee_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na ngaroma agau a kana ka lomannmannangana nge momo nangina, na lomannmanna ae miau nge momo nge i. Ava nge sa, na lomannmanna laeala nge galiu muni te miau. ");
INSERT INTO mee_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Miau ngaka momo mana nga bale laeala, ba ngaka kani, ba ngaka inue taru eke tungu rea te miau kurumea, oru nginngina ka ri ra kumangng a kanmiau alangana. Ba miau sana ngaka liuapaga kalaoka ta baleme. ");
INSERT INTO mee_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ba nga ina miau nga loalu ta maga kunna te e bollau ba ragau reke momo nga maga laeala ngeke ravu miau, na ngaka kania taru ra ri ke silae miau ki. ");
INSERT INTO mee_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ba miau ngaka papea ragau ra karea ka soalingme reke momo nga inaeala. Na ngaka role kerea roma, ‘Nutu kelangpatalingana ke atu kokoro te miau.’ ");
INSERT INTO mee_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ava nga ina miau nga loalu ta maga kunna te e bollau ba ragau reke momo nga maga laeala ke sane ngeke ravu miau, na ngaka taolu ta maga liuakia. Na ngaka role kerea roma, ");
INSERT INTO mee_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mangng ka taupunulole magavusa laekia e nga maga kunna ae miau nga kaemangngme. Taungapunulolo laekia ka i a killa a panaunga te miau. Na miau nga lomiaumatana alle roma, Nutu kelangpatalingana ke atu kokoro te miau ava miau ka sana ka ngatakale.’” ");
INSERT INTO mee_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Bae Iesus ke role ka ragau nginngina ra i ba rea bole roma, “Iau nga role kamiau roma, nga kae e nga kalingnana ngarume, na re nga maga laeala e sane ravu miau keke la ravunge miralali e bollau raumana nga miralali a ragau re ngae Sorom ke la ravunge.” ");
INSERT INTO mee_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Nae Iesus ke rolea pangamologa reke gingging ta maga kunna palu reke bollalau roma, “Oru reke sosoali raumana keke la leleng nge one ae Korasin! Bae Betsaira, one bole! Iau ka role minmina ta taroma Nutu kumangngana reke gingging ra miau ka kela rea teke lele ngae Taia bae Sairon, na teke kampiliue baingarea nganige. Ba teke lupage lungapaga re nga lotaningngana ba teke tara nga sia puna ka loreataningana ta baingarea reke sosoali. ");
INSERT INTO mee_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ava nga kae e nga kalingnana ngarume, na miau kaka la ravunge miralali e bollau raumana nga miralali laeala a re ngae Taia bae Sairon ke la ravunge. ");
INSERT INTO mee_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Bae one ae Kaperneam, ko roma one la ravunge malle a alangpaga e pe e ngailu raumana ae? Ke sa. One ko la loanga ta malle nga reke mate e momo ngape bavakena.” ");
INSERT INTO mee_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Bae Iesus ke role ka ragau nginngina ra i ba rea muni roma, “Agau e longo te miau ke longo te iau. Ba agau e tangulele miau ke tangulele iau bole. Ba agau e tangulele iau ke tangulelea Nutu e ba iau.” ");
INSERT INTO mee_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Na ragau nginngina ka ri giaukaina mologi ba tangulelu ba lua keke galiu te Iesus ka serengarea, na keke role roma, “Avolau, ka ina mangng ka patoe giang, na kannu reke sosoali keke longo mana te mangng.” ");
INSERT INTO mee_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Na i ke ala rea roma, “Ka kaomanna, iau ka kele Satan ginggingngana ke magogosavele nga gingging ngamiaungana, ba ginggingngana ke pupisigi base saia lamana e killama nga tava lagape. ");
INSERT INTO mee_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Iala na iau ka tunge gingginga a kanau te miau, minmina na miau kaka la taongapai nga mue ra koatali ba onreke unu. Ba ka tunge gingginga a kanau te miau ta baina miau ngaka parurupisigia Satan ginggingnganame kinung. Ba ke sana nga otte nge pamiralali miau. ");
INSERT INTO mee_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ava miau sana ngaka sereng nga ina kannu reke sosoali ke longo te miau mana. Miau ngaka sereng roma, Nutu ke pulia mallemiaume tapu nga mallena nga tava.” ");
INSERT INTO mee_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ka kae laeala nae Kannu E Tupu ke paserenge Iesus, na i ke role kae Nutu roma, “Tamau ka one ae Nutu A I A Kelangpatali ngailu nga tava ba ngape nga mogalo. Sonrau na iau ka kalapaga one. Iau ka kalapagpaga one kurumea ino pakoea oru kokorai nga ragau re nga mogalo laekia e ngape reke roma ri ra lomatanakana, ava ko pakosining rea ta ragau ra loreamatana ma goe reke sisina. Iii, Tamau, ko kuma minmina kurumea, kumangng laeala ke pe raumana nga ragung.” ");
INSERT INTO mee_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Bae Iesus ke role ka ragau muni roma, “Tamau ke kalatape orume kinung te iau. Ba ka sana agau te lonamatana kae Nutu Tuna, kana kae Tamana kasikena mana. Ba bole ka sana agau te lonamatana kae Nutu, kana kae Nutu Tuna mana ba ragau rae Tuna mate rea ta pangapotange Tamana te ri.” ");
INSERT INTO mee_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Na i ke ilapaga ta barangalele ra kanna, na ke role kerea mana roma, “Ragau reke kelkele oru nga miau ka kelkela rea nga loreasereng. ");
INSERT INTO mee_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ta iau ka la roleng kamiau ka kaomannmannangana roma, pala na ragau papatu reke toe Nutu kaona ba kelangpatali papatu keke bai ta ri kelange oru nga miau ka kelkela rea, ava ke sane ke kela rea. Ba ri keke bai ta longnge oru nga miau ka longlongo rea, ava ke sane ke longo rea.” ");
INSERT INTO mee_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ka kae te na agau a lomatanakana ka bangapagame ke maisi ta i avange Iesus. Na ke ballage roma, “Apangalomatanakana, iau nga meimia ka baingau, nga baina nga rave mauling e momo passavele?” ");
INSERT INTO mee_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nae Iesus ke ballage roma, “Keke paꞌe bangapaga rae Nutu kanna mina ngaetai? Ba ko meimia ka patongang ki?” ");
INSERT INTO mee_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Na agau laeala ke ale roma, “Keke role roma, ‘One ngo materaumane Avolau a i ae Nutu ae one ka long iname kinung, ba ka longmatenganame kinung, ba ka ginggingangame kinung, ba ka longmatananganame kinung.’ Ba, ‘One ngo materaumane agau tetoto basema ino materaumana one muni.’” ");
INSERT INTO mee_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nae Iesus ke role kia roma, “Ko ala masia pangamologa. Ngo kuma minmina, na ko la momong mauli passavele.” ");
INSERT INTO mee_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ava agau laeala ke bai ta turungpatokona roma i e pe raumana. Minmina na i ke ballage Iesus roma, “Taime ra ragau nga ita ngaka materaumana rea?” ");
INSERT INTO mee_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nae Iesus ke ale ka pangateningkala te i roma, “Ka kae te na agau te ke pa ngae Ierusalem na ke tataopisigi tae Ieriko. Na ka ine tatao nga pamau, na ra golongkana palu keke kokale ba keke toalale lungapaga ngae i. Na keke balia ba keke kaꞌe agau laeala ka mateng lalangana. ");
INSERT INTO mee_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ngarume na piris te ke tataokurumea pamau laeala. Ava ka ine kele agau laeala, na i ke kavesilelea nga pamau bavana tetoto. ");
INSERT INTO mee_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Na ka goamomong, na Iura te e nga galiau ae Livai ke lele nga inaeala ba ke kele agau laeala, ava i bole ke kavesilelea nga pamau bavana tetoto. ");
INSERT INTO mee_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Na agau te e ngae Sameria ke tatao e lola nga pamau laeala bole, na ke lele nga ina agau laeala momo ngia. Nae Sameria laeala ke kele soa laeala ine keno nga pamau ba ka lonananne. ");
INSERT INTO mee_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Minmina na i ke loa te i, na ke mume bisoname ba ke isi rea. Ngarume na i ke patarapaia nga posi ae i a marana eke patoe ka ‘ronki’. Na ke kutapu kia ta bale e nga kenong, ba i ke ellapatali ta agau laeala. ");
INSERT INTO mee_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ngarume ka kae tetoto ine bai ta kange bale laeala, nae Sameria laeala ke rave lollokanname ka ri lua na ke tungu rea ta bale laeala tamana. Ba i ke role kia roma, ‘Ngo ella ta agau laekia, ava iau nga galiu ngarume muni na nga ulopai munia oru nga one alakale ki.’” ");
INSERT INTO mee_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nae Iesus ke ballage agau a lonamatanakana nga bangapaga rae Nutu kanna muni roma, “Na ragau mologi keke lele nga agau laeala, ava tai e nge ri pana mologi nginngina ke matea agau laeala a ragolongkana ke balia?” ");
INSERT INTO mee_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Na agau a lonamatanakana nga bangapaga rae Nutu kanna ke ale roma, “Agau laeala a lonananne.” Nae Iesus ke role kia roma, “Ngo loa na ngo umma base agau laeala baingana.” ");
INSERT INTO mee_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ka inae Iesus kala nga barangalele ra kanna ke tatao eke lola, na keke lele nga maga kunna te e bollau. Na avale a giana nge Marta ke momo nga maga laeala. Minmina na i ke ballaga ta ri loanga ta bale ae i nga baina i nge silaekala rea. ");
INSERT INTO mee_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Bae Marta ka teiteikia te ora malaui a giana nge Maria. Nae Maria ke tara nga Iesus kaena puna ba ke longlonge Iesus ine pamolloga. ");
INSERT INTO mee_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Avae Marta ka lonavavai ta oru nga i kalituptupu rea ta silaengakala, ka baina i ke loa te Iesus ka loangana ka kaona kae Maria, ba ke ballage Iesus roma, “Avolau, ko roma i e pe ta teiteikau kange kumangngame kinung nge iau kasikegu? Ngo role kia nge kalau iau!” ");
INSERT INTO mee_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Avae Iesus ke ale ka patongana ba ke roma, “Marta, Marta, ka longvavai ba ka longpupu ta oru papatu raumana ngallo nga longo, ");
INSERT INTO mee_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ava oru kena mana nga longvavai te. Ngo kele. Maria ke tore ore pe raumana ba agau te sane nge rave nge i.” ");
INSERT INTO mee_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ka kae te nae Iesus ke kavkava nga malle te. Na ka ina i rongo kavanga tapu, na barangalele a kanna te ke ballage roma, “Avolau, one ngo poto mangng ka bainga e nga kavang base me Ion ine pote barangalele ra kanna.” ");
INSERT INTO mee_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ka baina i ke role kerea roma, “Ka ina miau ngaka kava te Nutu, na ngaka kava minakai roma: “‘Tamamangng, ragau nga loreamatana roma ka one o tupu mannangana. Ngo kuma ka kelangpatalingang nakai ngape. ");
INSERT INTO mee_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ngo tunge kaning ra mangng ka kaninni rea ka kae kenakena te mangng ka kae kenakena. ");
INSERT INTO mee_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ba ngo osurure baingamangng reke sosoali, ta mangng muni ka umma ta osungrurunge bainga reke sosoali ra ragau kinung ke bavai rea te mangng bole. Ba sono ngo taoamuga ka mangng lakallo ta avangame.’” ");
INSERT INTO mee_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Na i ke role ka pangateningkalangana kerea roma, “Ngaroma agau te ngaliua nge miau nga balingana te e tao ka taongana ave lele. Na agau laeala nge loa ta bale a kolingana tetoto ka rigo tamarakia ba nge role roma, ‘Koli, atu ka kau kaning mologi, ");
INSERT INTO mee_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ta balingau te e tao ka taongana ke atu, na ka sana kau otte ta silaenge.’ ");
INSERT INTO mee_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Na kolingana laeala e momo ngallo nge ale roma, ‘Sono ngo pasigipaga iau kurumea, biunga ke pulakala tapu ba mangng keke goe rae iau ka keno tapu nga nia. Ba ka omogusa ta sigingpaga ta tunge kaning te one.’ ");
INSERT INTO mee_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ngaka longo. Gia a koli ke sane gingging ta i sigingpaga ba tunga kaning ta agau e momo ngapotu ka rigo. Ava ka ina agau laeala ngapotu kaona gingina, na i nge sigipaga ba nge tungu raumana kaning kurumea agau laeala lonangana. ");
INSERT INTO mee_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ba iau nga role kamiau roma: Ngaka ballage Nutu, na i ke la tungnge oru a miau ka ballage te; ngaka tange Nutu, na kaka la kaling pakia; ngaka tute biunga, nae Nutu ke la pulangpatalinge. ");
INSERT INTO mee_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ta Nutu ke la tungnge oru ta agau e ballage te, ba agau e tange Nutu ke la kaling pakia. Bae Nutu ke pulangpatalinge biunga ta agau e tute. ");
INSERT INTO mee_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Palu nge miau ka nerea ka goeme. Na ngaroma te e nge ri nge ballaga miau ta kana lea te, na miau sana ngaka tunge mue a koatali te i. Ke sa. ");
INSERT INTO mee_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O ngaroma i nge ballaga ta kana kukulega katona, na miau sana ngaka tunge oru e tonge ragau ma ore unu te i. Ke sa. ");
INSERT INTO mee_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Miau ra lomiaume ke sosoali ka lomiaumatana ta tungnge ore pe ta goe rae miau. Bae Tamamiau e momo nga mallena nga tava ke pe raumana nga tama e nga mogalo laekia e ngape. Minmina na i ke la tungnge Kannu E Tupu ta ragau reke ballage te ka kaomannmannangana.” ");
INSERT INTO mee_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nae Iesus ke taomalaglage kannu te e soali. Ba kannu laeala e soali ke bai ka agau a i luia ta i a kumba. Na ka ina kannu laeala e soali kaꞌe agau laeala, na agau laeala a kumba ke pamolloga. Ba maluame keke kallo raumana. ");
INSERT INTO mee_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ava palu nge ri keke role roma, “I ke taomalaglage kannu reke sosoali ka gingginga ae Beelsebul a i a kannu reke sosoali kelangpatali ae ri.” ");
INSERT INTO mee_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ba ragau palu bole keke bai ta avange. Minmina na keke ballage ta i kumangng ka killa te e bollau ta pangakosining roma, i ke pa nge Nutu. ");
INSERT INTO mee_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Avae Iesus ka lonamatana ka oru reke momo ngallo nga gilirea baganame, minmina na i ke role kerea roma, “Ngaroma ragau reke momo ngape nga kelangpatali te ngeke palikalipala rea muni, na agau laeala kelangpatalingana ke la soaling bavakena. Ba ngaroma ragau re nga balekaina te ngeke palikalipala rea muni, na balekaina laeala ke la pupunga. ");
INSERT INTO mee_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ngaroma Satan nge kalipalpale i muni, na kelangpatalingana ke la meising mina ngaetai? Iau ka role minmina kurumea, miau kaka rorole roma, iau ka taomalaglage kannu reke sosoali ka Beelsebul ginggingngana. ");
INSERT INTO mee_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ba ngaroma iau nga taomalaglage kannu reke sosoali ka Beelsebul ginggingngana, na barangalele ra kanmiau keke taomalaglaga rea ka tai ginggingngana? Minmina na barangalele ra kanmiau keke pakosining roma, pangamologa a kanmiau ka sana kaomanna kia. ");
INSERT INTO mee_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ava ngaroma iau nga taomalaglage kannu reke sosoali ka Nutu ginggingngana, na ollaeala ke pakosining roma, Nutu kelangpatalingana ke lele nge miau tapu. ");
INSERT INTO mee_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ka ina agau a likina nge kampite oru ra kanna nga baling ma akurtalingling nga bale ae i, na ke sana nga otte nge baisoalia oru nga kanna. ");
INSERT INTO mee_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ava ka ina agau tetoto a likina raumana nga agau laeala nge ulopisigia ka likinangana, na agau laeala a likina raumana nge i nge ka ka oru nge nga baling ra i pulia likinangana ki. Ba agau laeala a likina raumana nge tavoa ka oru nginngina nga ragau rae i. ");
INSERT INTO mee_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Agau e sane kumkuma kala nge iau ke umma ta sanangkala iau. Ba agau e sane pulikinunge ragau kala nge iau ke umma ta taoange pallua nga ragau. ");
INSERT INTO mee_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ka ina kannu te e soali nge lelemalagapatalia agau, na i nge tatao nga malle reke galgalangngpa ba nge sissilia mallena te e nga pannang. Ava ke sane kalipa ka malle te. Minmina na i nge role roma, ‘Iau nga galiu ta bale a iau momo ngia pala.’ ");
INSERT INTO mee_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na ka ine nge lele, na nga kelangana ka agau laeala a i kaꞌe pala i ka tongana kena ma bale a ri ke sakalolellepaꞌe ba keke pulia orume nga pulingtupungareame. ");
INSERT INTO mee_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Minmina na i nge loa, na nge ngalue kannu reke sosoali raumana nge i ka ri lima ba lua muni. Na ri keke kinung ngeke rave malle ngallo nga agau laeala. Ba momongolungarea nga agau laeala nge soali raumana nga kannu kena e soali momongana ngallo nge i pala.” ");
INSERT INTO mee_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ka inae Iesus pamolloga ta oru nginngina tale, na avale te ngaliua nga maluame ke kiu roma, “Avale e toapisigi one be pasiu one nga lonasereng.” ");
INSERT INTO mee_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Avae Iesus ke role roma, “Ke pe, ava losereng mannangana ke momo ngallo nga ragau reke longe pangamologa rae Nutu kanna beke loakurume rea.” ");
INSERT INTO mee_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Na ka ina maluame ke katukala raumana te Iesus, na i ke role muni roma, “Ragau reke momo sonrau baingareame keke sosoali raumana. Keke matea raumana ta ri kelange killa te e bollau. Avae Nutu ke sane la tungnge killa te ri, ava kana ka killa amae Iona mana. ");
INSERT INTO mee_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Iau ka role minmina kurumea, Iona lelengana ma killa te ta ragau re ngae Niniva pala ka tongana kena mana ma inae Agau Tuna ka la i a killa te ta ragau reke momo sonrau. ");
INSERT INTO mee_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Avale a i a kelangpatali pala ngae Siba ke la maising nga kalingnana e bollau ngarume kala nga ragau reke momo sonrau. Na i ke la turungpaga karea kurumea, i ke pa nga mogalo lisina ta longnge lomatana e pe ae Solomon. Ba ngaka kele, agau a lonamatana raumana nge Solomon ikia e momo sonrau. ");
INSERT INTO mee_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ba ragau re ngae Niniva keke la maising nga kalingnana e bollau ngarume kala nga ragau reke momo sonrau. Na re ngae Niniva keke la turungpaga reke momo sonrau karea kurumea, ri keke pulivalakale baingarea reke sosoali ba keke tunge loreamatenganame te Nutu ka inae Iona pulimalaglage pangamologa te ri. Ba ngaka kele, agau e bollau raumana nge Iona ikia e momo sonrau.” ");
INSERT INTO mee_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nae Iesus ke role bole roma, “Agau nge tonge ore tunge olamana, na i ke sane nge talue nga ina i a osuguna ba ke sane nge pakompite bole. Ke sa. I nge patarapaia nga mallena e ngailu ta baina reke lu lakallo ngeke kela nga olamana. ");
INSERT INTO mee_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matang kanna ka i a lama ore nga mirang. Ngaroma matang kanna nge kuma masi, na olamana nge ponu nga mirang iname kinung. Ava ngaroma matang kanna nge soali, na osuguna nge ponu nga mirang bole. ");
INSERT INTO mee_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Minmina na ngaka ella miau masi ta baina olamana e momo ngallo nge miau sana nga i a osuguna. ");
INSERT INTO mee_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Minmina na ngaroma olamana nge ponu nga mirang iname kinung, ba ka sana nga inte i a osuguna, na mirang iname karolu nga lamarea paliala. Nga tongana kena ma ina oru a lamana tungtunge olamana te one.” ");
INSERT INTO mee_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ka inae Iesus rongo ka pangamologa ta oru nginngina, nae Parisio te ke ballage ta i kaning kala nge i nga bale ae i. Ka baina i ke lu, na ke tara ka bongapaikalanganakia ta kaning nga pala. ");
INSERT INTO mee_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ava pala ta kaning nae Iesus ke sane mume kamaname kurumea Iurame baingareangana, nae Parisio laeala ke magio nga kelangana. ");
INSERT INTO mee_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nae Iesus ke ale Parisio laeala kelangana ka pangateningkala roma, “Sonrau ikia, na miau ra Parisiome kaka umma ta pangalellepaꞌe gato e nga inung ba kato ina nge ngapotu, ava golong ba oru reke sosoali raumana keke ponu ngallo nge miau. ");
INSERT INTO mee_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Miau ra sana ramamiau! Nutu ke koipage mira ine ngapotu, ava ke sane koipage mira ine ngallo bole ae? ");
INSERT INTO mee_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ava miau ngaka tunge oru reke momolu ngallo nga gato nge nga inung ba oru reke momolu ngallo nga kato rae miau ta ra kononi nga baina orume kinung ngeke lelle te miau. ");
INSERT INTO mee_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Oru reke sosoali raumana keke la leleng nge miau ra Parisiome. Miau kaka lolakurumea bangapaga rae Nutu kanna palu mana. Kaka tungtunge oru kenakena nga tangulelu nga oru reke sisina te Nutu, basema lau re nga pangamannmannange kaning ba kaning nge nga ura. Ava kaka umma ta ulongvalakale oru reke bollalau raumana basema: bainga e nga kalingnana e tupu, ba bainga e nga matengraumanange Nutu. Ke pe ta miau loangakurumenge bangapaga reke sisina, ava sana ngaka ulovalakale bangapaga nginngina reke bollalau. ");
INSERT INTO mee_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Oru reke sosoali raumana keke la leleng nge miau ra Parisiome. Miau kaka materaumane taranga re nga ravollalau nga sinagogme. Ba miau kaka materaumane ragau pangamologangarea re nga alangapaga miau ka ineke lele nge miau nga malle re nga banga ka kaning bole. ");
INSERT INTO mee_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Oru reke sosoali raumana keke la leleng nge miau. Miau ka tongamiau kena mana ma baveng nga reke mate ra ragau ke sane ke kela rea, na keke taopai ngailu ngi. Ba bole ri ka sana loreamatana roma, ri keke momo kokoro nga baveng reke ponu ka oru reke bona.” ");
INSERT INTO mee_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Na agau te a lomatanakana ka bangapagame ke ale roma, “Apangalomatanakana, ka ino role minakong, na ko rolesillolo ka mangng bole.” ");
INSERT INTO mee_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nae Iesus ke ale roma, “Ba miau ra lomatanakana ka bangapagame, oru reke sosoali raumana ngeke lele nge miau bole. Miau kaka patolea ragau ka bangapaga reke maena raumana, na keke kalilli ta ri paunga rea. Ava miau muni ka sana ka kalaꞌe kamamiau ririna te mana ta miau kalaunga rea.” ");
INSERT INTO mee_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Oru reke sosoali raumana keke la leleng nge miau. Miau kaka kuma ka baveng nga ragau reke toe Nutu kaona reke mate pala. Ava sisiukamiau memena mana keke samupunu rea. ");
INSERT INTO mee_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Minmina mana na baingamiaume keke pakosining roma, miau kaka ngatakale onra sisiukamiau memena ke kuma kia. Ri keke samupune ragau reke toe Nutu kaona, ba miau kaka kuma ka baveng ngae ri. ");
INSERT INTO mee_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kurumea ollaeala mana, na keke paꞌe Nutu lonamatana e pe ine role roma, ‘Iau ka la bange ragau reke toe kaogu ba aposel rae iau te ri. Na keke la samungpununge palu, ba keke la pangamiralalia palu bole.’ ");
INSERT INTO mee_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ri keke la kumangng minmina ta baina alang nga reke toe Nutu kaona totorea e rava ka kae ngangina nganige ta ke lele ikia e sonrau nge momopai nga ragau reke momo sonrau. ");
INSERT INTO mee_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ke la pangaturu nge Abel totona, na nge atu ta Sekaraia totona a i a agau laeala eke balia ngaliua nga altara ba bale ae Nutu. Iau nga role kamiau ka kaomannmannangana roma, Nutu ke la alange oru nginngina nga ragau reke momo sonrau. ");
INSERT INTO mee_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Oru reke sosoali raumana keke la leleng nge miau ra lomatanakana ka bangapagame. Miau kaka kapatali ka kingapola ore kipole pamau e ta lomatana e te Nutu ora kaomannmannangana kia. Miau muni ka sana ka taolulu, ba kaka lengetotokalkale ragau reke bai ta lunga bole.” ");
INSERT INTO mee_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ngarume nga kae laeala ae Iesus lelemalaga nga bale ae Parisio laeala, nae Parisiome kala nga ra pangalomatanakana nga bangapagame keke paturu ta toangakininge ka balinglaga reke gingging, ");
INSERT INTO mee_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ta baina ri ngeke laue nga pangamologangana palu. ");
INSERT INTO mee_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ka ina malua papatu raumana ke katukala ba keke palipaketelalla rea nga ina Iesus momo ngia, nae Iesus ke role pala ka barangalele ra kanna roma, “Miau ngaka ella miau masi ta isi a goanga orae Parisiome.” ");
INSERT INTO mee_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ba i ke role bole roma, “Oru ra ri ke pako rea ke sane ke la konga. Ba oru ra ri ke kanggomepita rea keke la potanga ta baina ragau nga loreamatana ki. ");
INSERT INTO mee_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Oru ra miau ka patpato rea ka rigo keke la pulingmalaglaga rea ka kae. Ba oru ra miau ka magungunu ki nga bale ina nga miau ka enno ngi keke la kuranga ki ngapotu. ");
INSERT INTO mee_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ba iau nga role paka miau ra kolingau memena roma, miau ka sana ngaka mataue ragau reke sapune miramiaume, ava ngarume na ri ka sana karea ka gingginga ta bainge otte muni. ");
INSERT INTO mee_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ava iau nga papanau miau mannangana ka tai a miau ngaka mataue. Ngaka mataue Nutu a kana ka gingginga ta samungpununge miramiaume ba tamaling kamiau lakallo ta malle a sia e pamiralali passavele. Iau nga role kamiau ka kaomannmannangana roma, ngaka mataue Nutu.” ");
INSERT INTO mee_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Bae Iesus ke role bole ta lonana ae Nutu roma, “Ragau kinung ka loreamatana roma, ngaroma agau te ngaliua nge miau nge bai ta banga ka manu palu reke sisina, na i ke sane la ravunge lollokanna papatu ki. Ava miau sana nga lomiauvavai roma, Nutu lonapoge manu nginngina te. ");
INSERT INTO mee_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nutu ka lonamatana ka orume kinung ba ke sisitape gilimiau bulvunna reke momo nga kurumiaume. Minmina na sana ngaka matau. Miau kaka bollau raumana nga manume nge Nutu raguna. ");
INSERT INTO mee_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Iau nga role kamiau roma, ngaroma ragau ngeke turupote lopatokona ae ri te iau nga ragau ragureame sonrau, nae Agau Tuna ke la turungpota rea nga anggelo rae Nutu ragureame ngarume bole. ");
INSERT INTO mee_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ava ngaroma agau te nge kausikala iau nga ragau ragureame sonrau, na iau ka la kausingkale nga anggelo rae Nutu ragureame ngarume. ");
INSERT INTO mee_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ba ngaroma agau te nge patoe pangamologa e soali te Agau Tuna, nae Nutu ke la osungrurunge bainga laeala e soali. Ava ngaroma agau te nge rolebainga kae Kannu E Tupu, nae Nutu ke sane la osungrurunge bainga laeala e soali.” ");
INSERT INTO mee_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Bae Iesus ke role kerea bole roma, “Ka ina miau ngaka tatukurume iau, na ri keke la loanga ka miau ta kalingnana ngallo nga sinagogme. Ba ngeke pamaisi miau nga reke kelapatali ba reke bollau ragureame. Ava miau ka sana nga lomiaupupu ka kae laeala roma, ‘Ita ka la maingamia ka rolengara ba ita ka la roleng mina ngaetai?’ ");
INSERT INTO mee_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sana nga lomiaupupu ta ka kae laeala mana, nae Kannu E Tupu ke la pangalomatana miau ka pangamologa ra miau ka la rolenge rea.” ");
INSERT INTO mee_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Na agau te nga maluame ke role kae Iesus roma, “Apangalomatanakana, Tamau ke matepatali mangng. Minmina na ngo role ka tataokau ta i nge tavoa ka oru ra tamamangng kanna nge omea.” ");
INSERT INTO mee_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Avae Iesus ke ale roma, “Aekolong, tai ke puli iau ta baina iau nga kanana ngaliua nge onemea ba ta tavoanga ka oru nga kanimiau?” ");
INSERT INTO mee_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ba i ke role ka barangalele ra kanna roma, “Ngaka ella miau, miau ka sana nga lomiaumakaꞌe oru nge nga mogalo laekia e ngape. Ta ngaroma agau nga kanna oru papatu o nga ri tutuna mana, na maulingngana ka sana la likinangana ka oru nginngina ra kanna mana.” ");
INSERT INTO mee_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ba i ke role pakerea ka pangateningkala laekia bole roma, “Na ka ina agau a kilipukana ura ae i ponu ka kaning ka kae te, ");
INSERT INTO mee_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","na i ke role ka i muni roma, ‘Iau ka la maingamia ta sana kau malle ta alangavaikinunge kaning ra iau?’ ");
INSERT INTO mee_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Minmina na i ke role roma, ‘Iau nga kalaruse bale kokorai ra iau pullue kaning ra iau ngi, na nga balipage ne nge bollau nga baina iau nga pullue oru nga iau ba kaning ra iau kinung ngallo.’ ");
INSERT INTO mee_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ba iau nga role te iau muni roma, ‘Ka kang oru papatu reke pepe keke enno ngape ta leleng nga pesingmatana papatu nge ngarume. Minmina na one ngo panna, ba ngo kani, ba ngo inu, ba nga longsereng mana.’ ");
INSERT INTO mee_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Avae Nutu ke la roleng kia roma, ‘One ka sana ramang! Sonrau mana ka rigo, na iau ka la ravunggaliunge matueng. Ava tai ke la ravunge oru kokorong ra one kalitupu rea te one muni?’” ");
INSERT INTO mee_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nae Iesus ke role ka pangateningkala rongngana roma, “Ngaroma ragau ngeke alakinunge oru nga ri muni nge nga mogalo laekia e ngape sonrau ava ke sane ke alakinunge oru reke pepe nge Nutu raguna, na ri nga tongarea kena ma agau laekia a sana ramana.” ");
INSERT INTO mee_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Minmina nae Iesus ke role ka barangalele ra kanna roma, “Iau nga role kamiau roma, sana nga lomiaupupu ta momong ngamiaungana roma, ‘Ita kaka la kaninge taru?’. Ba bole sana nga lomiaupupu ta oru nga miramiaume roma, ‘Ita kaka la sisilinge taru?’. ");
INSERT INTO mee_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Momong ngamiaunganame keke bollau raumana nga kaning, ba miramiaume keke bollau raumana nga lungapagame. ");
INSERT INTO mee_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ngaka kele manu ra kaokato, ri ke sane ke tota karea kaning ba ke sane ke umma ta lalanga rea bole. Ba ka sana kanrea ka malle o bale ta ri pulingkinunge kaningme ngi, avae Nutu ke pakankani rea. Ba ka miau ra oru reke bollau raumana nga manume! ");
INSERT INTO mee_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ba tai e nge miau ka kana ka gingginga ta pulingale kae kena mana ta momongana gaviling ka lonapungana? ");
INSERT INTO mee_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Minmina na ngaroma ka sana kamiau gingginga ta kumangng ka otu laeala mana, ke meimia na ka lomiaupupu ta oru ka sausauna? ");
INSERT INTO mee_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ngaka kele gaivame ineke umma ta leleng. Ri ke sane ke kumkuma ba ke sane ke saisaia lungapagame bole. Ava iau nga role pakamiau roma, ka inae Solomon kanserengea mirana raumana, na kaningserengngana laeala ka sana tongana ma te nga gaiva nginngina. ");
INSERT INTO mee_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Miau ra lomiaupatokona sina, ngaroma Nutu nge kuma minmina ka pangalupagangana ka bega ba oru re nga mogalo reke momo sonrau ava me ngangaila na ngeke tamalilu ki ta sia, na i ke la pangalupaga miau mannangana. ");
INSERT INTO mee_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Minmina na sana ngaka ella raumana ta oru re nga kaningi rea ba oru re nga inungu rea, ba sana nga lomiaupupu. ");
INSERT INTO mee_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ta ra sana ri ra Iura keke tangtange oru nginngina kinung. Bae Tamamiau ka lonamatana tapu roma, oru palu nga oru nginngina keke bollau raumana nge miau bole. ");
INSERT INTO mee_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ava miau ngaka tange oru re nga Nutu kelangpatalingana, ba i ke la tungnge oru nginngina te miau bole. ");
INSERT INTO mee_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Miau tutuna kokorong, ka sana ngaka matau ta Tamamiau ka lonamannmanna ta miau kelangapatali kala nge i ngallo nga kelangapatalingana ngarume. ");
INSERT INTO mee_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ngaka ba ka oru nga miau nga baina ngaka tunge lollokanname ta ra sillolo. Ba ngaka kuma ka bising re sane la lavusangng nga ri ra sasaipuna ore nga pulunge oru re nga Nutu mallena nga tava ngi. Ba nga ri ra sasaipuna ore nga pulinglunge oru re sane ke la ronga, ba kupeme ke sane ngeke kani rea, ba agolongkana te ke sane nge loa ta golongo rea bole. ");
INSERT INTO mee_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Iau ka role minmina kurumea, malle a miau ka umma ta pulingkinung kanmiau kilipu ngia, ka i a malle a lomiaungana ke la momong ngia bole.” ");
INSERT INTO mee_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Bae Iesus ke role ka barangalele ra kanna ka pangateningkala bole roma, “Miau ngaka momo ka lungapaga ngamiaungana ka lungapaga rae miau, ba lama rae miau reke toto. ");
INSERT INTO mee_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nga tongamiau kena ma ragau reke momalla ta avolaukerea kangagaliungana nga kaning te ore nga palingravung rea. Keke kuma minmina ta baina nga ine nge tute biunga, na ri ngeke pulapatalia biunga bolvole te i, na i nge lu. ");
INSERT INTO mee_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Minmina na ke pe raumana ngaroma avolaukerea nge lelepite ra kumangngatulu nginngina ra kanna nga ina ri ke momo beke kelkela ta atungngana. Iau nga role kamiau ka kaomannmannangana roma, avolaukerea laeala nge bai ka sisilingana ma i a akumangngatulu a kanrea. Ba nge patara rea nga pala ta baina i nge silaekala rea ka kaning. ");
INSERT INTO mee_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ngaroma avolaukerea laeala nge lele ka rigo luana, o pala ta kae marara, o ka kae mana, na ke pe raumana ngaroma i nge lelepite ra kumangngatulu nginngina ra kanna nga ina ri ke kalitupe orume tapu beke kelkela te i. ");
INSERT INTO mee_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ava nga lomiaumatana roma: Taroma bale tamana ta lonamatana ka kae matana a taru a agolongkana la atung kia, na i sane te ngatakale agolongkana ta i taongalu ta bale ba golonge orume. ");
INSERT INTO mee_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Minmina na miau bole ngaka momo ba ngaka kelkela kurumea, Agau Tuna ke la atung ka kae matana te a miau ka lomiauvavai roma, ke sane la atung kia.” ");
INSERT INTO mee_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nae Pita ke ballage Iesus roma, “Avolau, ko rolea pangateningkala laekolong te mangnga mana, o ta ragau kinung?” ");
INSERT INTO mee_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nae Iesus a i ae Avolau ke ale ka pangateningkala te muni roma, “Akumangngatulu e loatunanne avolaukia ba kana ka lomatana e pe ke meimia ka baingana? Ka i a agau matana a avolaukia nge pulia ta i kelangpatali ta ra kumangngatulu rae i ba ta i tunga karea kaning ka kae matana e nga kaning. ");
INSERT INTO mee_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Akumangngatulu laeala nga lonasereng raumana ngaroma avolaukia nge lele, na nge kalipa kia ine umma minmina. ");
INSERT INTO mee_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Iau nga role kamiau ka kaomannmannangana roma, avolaukia ke la pulinge ta i kelangapatali ta oru ra i kinung. ");
INSERT INTO mee_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ava ngaroma akumangngatulu laeala nge role ngallo nge i muni roma, ‘Avolaukau ke la momong ka panna tane gavili nanguni,’ na i nge paturu ta balinge ra panung ra kumangngatulu ba ra bale ra kumangngatulu, ba nge kaninni ba nge innu, ba nge bemve. ");
INSERT INTO mee_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Na kumangngatulu laeala avolaukia ke la atung ka kae te a akumangngatulu lonavavai roma i ke sane la atung kia, ba ka kae matana te a i sana lonamatana kia. Na i nge sapipatoto kia ba nge pulia ta i momong kala nga ragau ra loreakalasa. ");
INSERT INTO mee_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ba akumangngatulu laeala a lonamatana ka avolaukia lonangana ava ke sane kalitupe orume o ke sane kuma kurumea avolaukia lonangana ke la ravunge saping papatu. ");
INSERT INTO mee_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ava akumangngatulu a sana lonamatana ka avolaukia lonangana ba ke kuma ka bainga reke sosoali ra karea ka alang ke la ravunge saping tutuna mana. Agau e rave oru papatu ke la tungagaliue oru papatu bole. Ba keke la balinglage agau eke tunge oru papatu te i ta i tungagaliue oru papatu muni.” ");
INSERT INTO mee_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Bae Iesus ke role ka barangalele ra kanna bole roma, “Iau ka atu ta patungapage sia nga mogalo laekia, ba ka matea ta i leleng bolvole! ");
INSERT INTO mee_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ava pala ka kau ka pangamagoe e nga taongalu nga miralali ma agau eke bolue ka ine ngeke pamagoea. Ba kaningmai ngaungana ke maena raumana nge iau ka ina iau la momongkalange pangamagoe laeala rongana! ");
INSERT INTO mee_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Sana nga lomiauvavai roma, iau ka atu ta pangataramasinge ragau re nga mogalo laekia e ngape. Iau nga role kamiau roma, iau ka sana atu ta pangataramasinge ragau. Ke sa. Iau ka atu ta kalingpala rea. ");
INSERT INTO mee_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ngarume nga kae laekia, na pana lima re nga balekaina kena ngeke palikalipala rea. Pana mologi ngeke kalipala rea nga pana lua, ba pana lua ngeke kalipala rea nga pana mologi. ");
INSERT INTO mee_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ri ngeke palikalipala rea. Goe a panung nge kalipala nge tamana, ba goe a panung tamana nge kalipala nga goe ae i a panung. Ba bole goe a bale naname nge kalipala nga goe ae i a bale, ba goe a bale nge kalipala nge naname. Ba avale lonapiau bole nge kalipala nge goenapiau, ba goenapiau nge kalipala nge lonapiau.” ");
INSERT INTO mee_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nae Iesus ke role bole ka maluame roma, “Ka ina miau ngaka kele mumuka ine kalapallpaga nga bava a kae barelulu ngia, na bolvole mana na miau ngaka role roma, ‘Kue ke la tugung.’ Na nge tugu. ");
INSERT INTO mee_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ba ka ina bovole e pa nga bava te ke inso, na miau nga role roma, ‘Kae ka la mammanangana.’ Na nga mammana. ");
INSERT INTO mee_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Miau ra goangakana! Ka lomiaumatana ta kelangpatokonange oru reke lele nga mogalo ba nga tava. Ava ke meimia na miau ka sana lomiaumatana ta kelangpatokonange oru rae Nutu kumkuma ki ka kae laekia e sonrau? ");
INSERT INTO mee_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ba ke meimia na miau muni ka sana lomiaukali paka bainga e pe ta miau loangakurumenge? ");
INSERT INTO mee_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ke base ina one ngo lola kala nga agau a iukia kone ta akalingnanakana. Na ka ina onemea ngaka tatao tale nga pamau, na one ngo ava ta legengepitakao. Ngaroma one sano ngo kuma minmina, na i nge utupallala kone kaligi ta akalingnanakana kamana. Na akalingnanakana nge role ka akurtalingling ae i e tungtunge alanga, na i nge pullu one nga pulangkala. ");
INSERT INTO mee_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Iau nga role kone ka kaomannmannangana roma, one ko sono la lelengmalaga ta nge lele nga ina one ngo tunge kuru rongana mannangana.” ");
INSERT INTO mee_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na ragau palu reke momo ka kae laeala keke turu pakae Iesus inae Pilatus baꞌe ragau ta ri samungpununge ragau palu re ngae Galili ka ineke balipunpune posime nga tempel ta tunga rea ma ri ra tungame te Nutu. ");
INSERT INTO mee_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nae Iesus ke ala rea roma, “Miau kaka roma baling laeala ka i a pangakosining roma ra nginngina ngae Galili baingareame ke sosoali raumana nga Galili pattoto ae? ");
INSERT INTO mee_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nga role te miau, ke sana minmina! Ba ngaroma miau sana ngaka pulivalakale baingamiau reke sosoali ba tunge lomiaumatenganame te Nutu, na miau bole kaka la basanga rea. ");
INSERT INTO mee_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ba miau kaka roma, pana tangulelu ba lima ba mologi reke mate ka ina bale e loa lakailu pupupita rea baingareame ke sosoali raumana nga ragau pattoto reke momo ngae Ierusalem ae? ");
INSERT INTO mee_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nga role te miau, ke sana minmina! Ba ngaroma miau sana ngaka pulivalakale baingamiau reke sosoali ba tunge lomiaumatenganame te Nutu, na miau bole kaka la basanga rea.” ");
INSERT INTO mee_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Na i ke rolea pangateningkala te muni roma: “Bega te e piaupiau ke maisi nga ura a agau te. Ka kae te na bega laeala tamana ke loa ta baina i kelanga roma, bega ka kanna palu o ke sa. Ava bega laeala ae i ke sane piaupiau. ");
INSERT INTO mee_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Minmina na ura tamana laeala ke role ka agau e ellapatali ta ura ae i roma, ‘Koee! Iau ka pune atung ba kelang ta bega laekia kanna ka pesingmatana mologi tapu, ava ke sane piaupiau. Minmina na ke sane pe ta i nge maispalikovauu mana nga ura. Ngo telepatalipisigi kia!’ ");
INSERT INTO mee_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Na agau e ellapatali ta ura ke ale roma, ‘Avolau, ke pe roma ita ngaka kela te muni ka pesingmatana kena, ba iau nga kakalopita masia puna muni. ");
INSERT INTO mee_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ngaroma sane nge piau ka pesingmatana e ngarume, na iau nga telepisigia. Ava ngaroma nge piaupiau, na ke pe ta i momong.’” ");
INSERT INTO mee_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ka kae te a Sabat, nae Iesus ke palomatantana ngallo nga sinagog te. ");
INSERT INTO mee_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na ka kae laeala, na avale a kannu e soali pasigikole gina ka pesingmatana tangulelu ba lima ba mologi ke momo. Na avale laeala gina ke sikolo na ke sana sinakala ta i pangatupunge gina bavakena. ");
INSERT INTO mee_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ava ka inae Iesus kele na i ke kiue avale laeala lagamuga te i, na ke role kia roma, “Soa avale, iau ka polalelepatali one nga soalingang.” ");
INSERT INTO mee_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Na i ke pulipaia kamana nga avale laeala, na ka pannasa mana na avale laeala ke patupe gina. Na i ke paturu ta kalangapage Nutu. ");
INSERT INTO mee_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ava agau e kelapatali ta sinagog ke sana lonamannmanna ka inae Iesus papea avale laeala ka kae a Sabat. Minmina na i ke role ka ragau roma, “Ka kaeme ka ri lima ba kena re nga kumangng, na ngaroma miau ngaka matea ta pangapenge miramiaume na ngaka atu ka kae nginngina. Ka sana ngaka atu ka kae a Sabat.” ");
INSERT INTO mee_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Avae Iesus ke ale roma, “Ka miau ra goangakana! Agau te e nge miau sane nge kuma ka kumangng e nga polange posi ae i a marana ta baina i nge loa kia ta inung kana me ka kae a Sabat ae? ");
INSERT INTO mee_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ngaka kele avale laekia, ka i ae Abaram sivuna piau ba bole Satan ke piupite ka pesingmatana tangulelu ba lima ba mologi tapu. Na miau kaka roma i e sane pe ta iau polangalelepatalinge ka ollaekia e piupite ka kae a Sabat ae?” ");
INSERT INTO mee_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ka ine role minmina na ragau reke rolebainga kia ka balenglenge rea, ava maluame ka loreasereng raumana ta oru reke pepe ra i kuma ki. ");
INSERT INTO mee_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nae Iesus ke ballaga rea roma, “Nutu kelangpatalingana ka tongana kena ma taru, ba iau nga toe ma taru?” ");
INSERT INTO mee_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Na i muni ke ale balinglaga ra kanna roma, “Nutu kelangpatalingana ka tongana kena ma bega kanna e sina raumana ora agau rave, na ke toaꞌe nga ura ae i. Ba ngarume na bega kanna laeala ke lele, na ka i a bega. Na manu reke lolo nga tava keke momo nga kamaname.” ");
INSERT INTO mee_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ba i ke ballaga rea muni roma, “Iau nga meimia ka tongau ka Nutu kelangpatalingana ka taru? ");
INSERT INTO mee_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","I ka tongana kena ma isi isunte ora avale te rave, na ke kampiliue kala nga plaua ine bollau ta ke lele ina isi isu laeala paluvapaꞌe beret karolu.” ");
INSERT INTO mee_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nae Iesus ke taolu nga maga kunna palu reke bollalau ba maga tutuna palu bole, na i ke palomatantane ragau ka ine tatao tae Ierusalem. ");
INSERT INTO mee_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ba agau te ke ballage roma, “Avolau, Nutu ke la ravunglelenge ragau tutuna mana ae?” Na i ke role kerea ka pangateningkala roma, ");
INSERT INTO mee_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ngaka kuma kaligi ta lunga lakallo nga biunga e pitu. Ta iau nga role kamiau roma, ragau papatu keke la matenge ta ri lunga, ava ke sane ke la totorong ta ri lunga. ");
INSERT INTO mee_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Na ka ina nga bale tamana nge sigipaga ba nge pulakale bale kaona, na miau ala ngaka maisinsi ngapotu ka tutungamiaungana ka bale kaona ba taningkala ngamiaungana roma, ‘Avolau, pulapatalia balkaona te mangng.’ “Ava i nge ala miau roma, ‘Iau ka sana laumatana roma, ka miau re nga ina ngaetai.’ ");
INSERT INTO mee_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Na miau kaka la roleng roma, ‘Mangng ama kani ba inu kala nge one, ba one amo palomatantane ragau nga maga kunna nga mangng.’ ");
INSERT INTO mee_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ava i nge ale pangamologangamiau roma, ‘Iau nga role kamiau roma, ka sana laumatana roma, ka miau re ngaetai. Miau raka bavaia bainga reke sosoali raumana, ka kapatali iau.’ ");
INSERT INTO mee_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Na miau kaka la kelange Abaram, bae Aisak, bae Iekop, kala nga ragau reke toe Nutu kaona nga ina ri ke momo ngallo nga Nutu kelangpatalingana. Ava miau ala ngaka tantani nga malle laeala ba ngingimiaume ngeke tanagnagi ka iukamiaungana nga ina miau ngaka kele momongamiaungana ngapotu. ");
INSERT INTO mee_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ba ragau re nga iname kinung keke la atung, na keke la ravunge mallerea nga kaning e bollau ngallo nga Nutu kelangpatalingana. ");
INSERT INTO mee_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Iau nga role ka kaomannmannangana roma, ragau palu re ngarume sonrau, ka la ngarume na ri re kapunu. Ba ragau palu re kapunu sonrau, ka la ngarume na ri re ngarume.” ");
INSERT INTO mee_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ka kae laeala nae Parisio palu keke atu te Iesus na keke role kia roma, “Ngo kaꞌe inaekia, na ngo loa ta inte toto, ta Eroto ke bai ta samungpunu one.” ");
INSERT INTO mee_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ava i ke ala rea roma, “Ngaka loa ka pangamologa ra kanau ta apatugungtaokana laeala roma, ‘Iau ka la taongamalagange kannu reke sosoali ba nga papepea ragau sonrau ba ngangaila, ava nga kae a mologi na iau ka la ronga ka kumangng ra kanegu.’ ");
INSERT INTO mee_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ava iau ka la taonga sonrau, ba ngangaila, ba nga bongalua bole kurumea, ke sane pe ngaroma agau te e toe Nutu kaona nge mate nga inte e ngapotu ngae Ierusalem.” ");
INSERT INTO mee_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Na i ke rolea pangamologa ta ragau re ngae Ierusalem roma, “Kooe miau re ngae Ierusalem. Miau kaka sapune ragau reke toe Nutu kaona, ba kaka tamalipune ragau rae Nutu ba rea te miau! Ka kae papatu, nae iau ka bai ta ravungkinunge goe rae miau ma kukulega e ravukinunge goekia ngape nga papaname. Ava ka sana omomiau. ");
INSERT INTO mee_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ngaka kele. Nutu ke sane la momong nga maga kunna laekia e bollau ae miau tale. Ba iau ka la roleng kamiau roma, miau ka sana ka la kelanga iau muni ta nge lele nga kae laeala ina miau ka la roleng roma, ‘Nutu ke kavitulu raumane aekia e atu nge Nutu a i ae Avolau giana.’” ");
INSERT INTO mee_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ka kae te a Sabat, nae Iesus ke momo ta kaning nga bale a agau te e kapunu e kelapatali ta Parisiome. Na Parisio laeala kala nga kolingana memena keke ella te Iesus ta baina ri turungpaga kana ngaroma i nge baia otte e soali nga ragureame. ");
INSERT INTO mee_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ka kae laeala na agau te a kana ka soaling a mira lungana ke momo bole ngamuga nge Iesus raguna. ");
INSERT INTO mee_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Minmina nae Iesus ke ballage Parisiome kala nga ra lomatanakana ka bangapagame roma, “Ke parototokala ta pangapenge agau ka kae a Sabat, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ava ri keke rulu mana, ka bainae Iesus ke pulipaia kamana nga agau laeala ba ke papea mirana. Na ke baꞌe e lao. ");
INSERT INTO mee_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Na ke ballaga rea roma, “Ngaroma agau te e nge miau goe ae i o posi ae i a marana nge pullu lakallo ta lulu lona ka kae a Sabat, na agau laeala ke la loanga bolvole ta utungpataenge, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na ri ke sane ke rolea inte. ");
INSERT INTO mee_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Bae Iesus ke kele ragau ineke rarave malle ra alangpaga nga pala, na i ke role kerea ka pangateningkala laekia roma: ");
INSERT INTO mee_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nga ina agau nge baia kaning e bollau e nga palingravung rea, na one sano ngo tara nga tarangapai a alangpaga. Ta nga sana longmatana roma, kaning tamana ke ba bole ta agau e bollau raumana nge one, o ke sa. ");
INSERT INTO mee_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Na ngaroma minmina na agau e ba te one nge atu na nge role kone roma, ‘Ngo tunge tarangapai laekolong te aekia.’ Na one ala nga balenglenge one nga ina one tara ngape. ");
INSERT INTO mee_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ava ka ina agau nge ba te one, na one ngo tara ngape nga baina kaning tamana laeala nge atu na nge role kone roma, ‘Koli, ngo tarapai lakailu ta tarangapai e pe.’ Minmina na ala nga one a alangpaga nga kolingang pattoto. ");
INSERT INTO mee_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Agau a i muni ulopataea giana sonrau, nae Nutu ke la ulongpisiginge ngarume. Ba bole agau e ulopisigia i muni giana sonrau, nae Nutu ke la ulongpataenge ngarume.” ");
INSERT INTO mee_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nae Iesus ke role ka agau laeala e ba te i ta kaning roma, “Nga ina one ngo baia kaning e ka kae luana o ka laio, na sano ngo ba ta kolingang memena, ba tataokone memena, ba teiteikone memena, ba rakone memena, ba ta ra kilipukana. Ngaroma one ngo kuma minmina ba ngaroma ri ngeke bagaliu te one, na one alo rave kurung tapu. ");
INSERT INTO mee_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ava nga ina one ngo baia kaning e bollau, na ngo ba ta ragau ra sillolo, ba ra mirareame ke soali, ba ra mirareame ke mate, ba ta ragau ra matarea kanreame ke su, ");
INSERT INTO mee_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","nga bainae Nutu nge kavitulu one. Ka kaomanna, ri ka sana karea kaning ta ri alange kaning ae one sonrau. Ava ngarume, ka kae a reke mate ra baingareame ke tupu ngeke sigipaga nga mateng, na nga kae laeala mana nae Nutu ke la tungnge alanga e pe te one.” ");
INSERT INTO mee_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Na ka ina agau te e tattara kala nge Iesus nga pala ke longe pangamologa laeala na i ke role kae Iesus roma, “Ragau reke la kaning nga kaning e bollau ngallo nga Nutu kelangpatalingana nga loreasereng.” ");
INSERT INTO mee_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nae Iesus ke ale ka pangateningkala roma, “Ka agau te ore bai ta kumangng ka kaning e bollau, ba i ke ba ta ragau papatu ta ri atung ta kaning laeala. ");
INSERT INTO mee_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Na ka ina kae e nga kaninge kaning laeala e bollau lele, na i ke baꞌe akumangngatulu a kanna ta roleng ka ra nginngina ra i ba ta ri atung roma, ‘Ngaka atu, ta iau ka kalitupe orume kinung tapu.’ ");
INSERT INTO mee_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ava ra nginngina kinung keke paturu ta kalangatotokala. Minmina na ne kapunu ke role roma, ‘Ke pe, ava iau ka kolia ura te ba ka bai ta kelanga te. Minmina na ngo role ka avolaukone roma, i ke bai ta atung ava ka kana ka kumangng.’ ");
INSERT INTO mee_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ba te muni ke role roma, ‘Ke pe, ava iau ka kolia bulmakaume ka ri tangulelu onre nga kumangng nga ura ba ka bai ta kelangapalipita ka kumangngarea. Minmina na ngo role ka avolaukone roma, i ke bai ta atung ava ka kana ka kumangng.’ ");
INSERT INTO mee_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ba te muni ke role roma, ‘Koli, iau ka kamapitakama gialgiala mana, minmina na ke isopa ta iau loanga.’ ");
INSERT INTO mee_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Na akumangngatulu laeala ke galiu ta avolaukia ba ke ture ina ragau nginngina ra i ba te ri ka sana omorea ta atung. Na ka ina kaning tamana laeala longe pangamologa laeala, na i ka iukia ba ke role ka akumangngatulu a kanna roma, ‘Ngo loa bolvole ta iname kinung ngallo nga maga kunna laekia e bollau, na ngo atu ka ra sillolo, ba ra kaereame ke soali, ba ra matarea kanname ke su, ba ra kaereame ke mate nasai.’ ");
INSERT INTO mee_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ngarume na akumangngatulu laeala ke galiu ta avolaukia na ke role kia roma, ‘Avolau, iau ka kuma base ino role kau tapu, ava bale ke sane ponu tale.’ ");
INSERT INTO mee_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Na avolau laeala ke role ka akumangngatulu laeala a kanna roma, ‘Ngo loa ta pamau reke bollalau ba pamau reke tao ta iname, na ngo role ka ragau ta ri atung nga baina bale ae iau nge ponu ka ragau. ");
INSERT INTO mee_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ta iau ka la roleng kone roma, ka sana te nga ra nginngina ra iau ba te ri pala ta ri atung ke la kaningmainge kaning inte mana nga kaning e bollau ae iau.’” ");
INSERT INTO mee_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Na malua reke bollau keke tatao kala nge Iesus, na i ke kampiliu te ri ba ke role kerea roma, ");
INSERT INTO mee_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ngaroma agau te nge atu te iau ba nge bai ta i a barangalele a kanau, na i nge pulia Nutu lonamatengana ngailu nga tamana lonamatengana, ba naname lonamatengana, ba napengana lonamatengana, ba goe rae i loreamatengana, ba teiteikia memena loreamatengana, ba liuna piau memena loreamatengana, ba bole i nge pulia Nutu lonamatengana ngailu nga i muni lonamatengana. Na ngaroma i sane nge bai minmina, na i ka sana la i a barangalele a kanau. ");
INSERT INTO mee_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ba bole agau e sane tolea maiskovu ae i ta baina i atungkurume iau ka sana la i a barangalele a kanau. ");
INSERT INTO mee_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ba ngaroma agau te nge miau nge bai ta pangamaisinge bale te e bollau, na nge meimia? I nge tara pala na nge potopita roma, i ka kanna ka lollokanna papatu ta rongapatapu ka bale laeala, o ke sa. ");
INSERT INTO mee_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ngaroma i nge sane kuma minmina, na i nge pature bale kaena puna likinangana, ava ngarume na i nge besa ta rongapatapu kia. Na ragau kinung reke kele bale laeala ngeke rolepagalising kia roma, ");
INSERT INTO mee_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Aekolong ke pature bale laeala, ava i ke besakale.’ ");
INSERT INTO mee_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ba bole ngaroma kelangpatali te nge rome bai ta loanga ta baling kala nga kelangpatali tetoto, na nge meimia? I nge tara pala na nge potopita roma, galiau ae i nga baling ke bollau, ava i nga likina ta ulongpisiginge galiau laeala e bollau raumana muni nge i, o ke sa. ");
INSERT INTO mee_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ngaroma nge sa, na i nge baꞌe ragau ka pangamologa a legengepitakao ka ina galiau laeala e bollau momo ngatauga tale. ");
INSERT INTO mee_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ka tongana kena ina agau nge bai ta i a barangalele a kanau, na agau laeala nge potopita pala ba nge kelavalakale oru ra i kinung.” ");
INSERT INTO mee_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Bae Iesus ke rolea pangateningkala te bole roma, “Ngaroma poae mannmannangana nge rongo, na ka la mannmannangana muni mina ngaetai? ");
INSERT INTO mee_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ke sane ke la kalaungapage mogalo kia, ba ka sana la kana kumangng kia bole. Minmina na keke la saunga kia mana. “Ngaroma agau te nga omona ta longa, na i nge longe pangamologa laekia.” ");
INSERT INTO mee_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ka kae te, na ragau reke raravukinunge takisme kala nga ragau ra Iurame ke pato rea ka “ra baingareame ke soali” keke katukala taliue Iesus, ta baina ri ngeke longe pangamologangana. ");
INSERT INTO mee_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Avae Parisiome ba ra pangalomatanakana nga bangapagame keke rolepu kia roma, “Aekia ka lonangatakalkale ra baingareame ke soali, ba ke kaninni kala nge ri bole.” ");
INSERT INTO mee_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nae Iesus ke role kerea ka pangateningkala laekia roma: ");
INSERT INTO mee_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ngaroma agau te e nge miau nga kana ka sipsip ra marana ka ri 100 ava te e nge ri nge taopa, na i ke la maingamia? Kaka roma, i sane nge kaꞌe na nginngina ka ri 99 nga malle a i a karakarangana, na nge loa ta i silinge sipsip laeala e taopa ae? Ke sa. I ke la loanga ta kalingpa kia. ");
INSERT INTO mee_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ba ka ine nge kalipa kia, na nge tolea ka serengngana nga singiname ");
INSERT INTO mee_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","galiu muni ta maga. Ba i nge ba ta kolingana memena ba ragau rae i ta ri katungkala. Na nge role kerea roma, ‘Nga lomiausereng kala nge iau ta iau ka kalipa ka sipsip ae iau e taopa.’” ");
INSERT INTO mee_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nae Iesus ke role kerea ka pangateningkala laeala rongngana roma, “Ba ollaeala ka tongana kena mana ka ina reke momo nga Nutu mallena nga tava nga loreasereng raumana nga ina agau a bainganame ke soali nge pulivalakale baingana reke sosoali ba nge tunge lonamatenganame te Nutu. Iau nga role kamiau roma, loreaserengngana laeala ka agau laeala e taopa pulingvalakalangana nge bollau raumana nga loreaserengngana ka ragau nginngina ra ri 99 reke roma baingareame ke pe tapu.” ");
INSERT INTO mee_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nae Iesus ke role ka pangateningkala bole roma, “Ba ka tongana kena ma avale te a kanna ka lollokanna iname ka ri tangulelu, ava kena a kunna ngailu raumana ke sanrea. Na avale laeala nge meimia? I nge tonge ore tunge olamana, ba nge sakalo, ba nge silia ta nge kalipa kia. ");
INSERT INTO mee_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na nga ina i nge kalipa kia, na nge ba ta kolingana memena ba ragau rae i ta ri katungkala. Ba i nge role kerea roma, ‘Nga lomiausereng kala nge iau, ta iau ka kalipa ka lollokanna kena ama kanau tapu e sanrea.’ ");
INSERT INTO mee_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nga role mannangana te miau roma, ollaeala ka tongana kena mana ka ina reke momo nga Nutu mallena nga tava nga loreasereng raumana nga ina agau a bainganame ke sosoali nge pulivalakale baingana reke sosoali be tunge lonamatenganame te Nutu.” ");
INSERT INTO mee_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Bae Iesus ke rorole tale ka pangateningkala muni roma, “Agau te a nena ka goe lua ra panung ke momo. ");
INSERT INTO mee_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ka kae te na goe a i a lua a taulai ke role ka tamarea roma, ‘Tamau, one ngo tunge tavoanga rae iau nga oru nga kaning nga iau la ravungu rea ngarume nga matengang te iau sonrau.’ Minmina na tamarea ke tavoa ka oru ngae i ngaliua nga ri rae tataokia. ");
INSERT INTO mee_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Ka kae te ngarume nga kae laeala, na goe laeala a i a lua ke ravukinunge oru ngae i kinung ba ke kutapu ta ine ngatauga. Na nga inaeala a i momo ngia i ke rongomana ka lollokanna nga kanna ka kumangngana ka bainga onre sane ke pepe. ");
INSERT INTO mee_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ngarume nga ina lollokanna nga kanna kinung ke rongo tapu, na osangana e bollau ke lele nga ragau kinung nga inaeala. Na goe laeala a taulai matengkanangana ke punuraumane. ");
INSERT INTO mee_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Minmina na i ke loa ta kumangngpagakana nga agau te e momo nga inaeala. Na agau laeala ke bapage ta i nge umma ta pangakaninge gieme nga ura ae i. ");
INSERT INTO mee_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Na nga ina goe laeala pakaninte gieme, na i ka lonamateraumane kaning mamauna ra gieme ina i sana kana kaning. Ba ka sana agau te tunge kaningi palu te i ta baina i nge kani rea bole. ");
INSERT INTO mee_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ngarume na nia ke lia goe laeala lona galiu roma, ‘Kama matengkaungana punu iau nakai, ba ka Tamau pia ra karea kaning ba karea kaning kalona papatu bole? ");
INSERT INTO mee_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Iau nga sigipaga, na nga galiu muni te Tamau ba nga role te i roma, “Tamau, iau ka baia bainga e soali te Nutu ba te one. ");
INSERT INTO mee_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Minmina na ka sana iau a pe ta one ngo kava iau ka tung; ngo puli iau ma akumangngatulu a kaning te mana.” ’ ");
INSERT INTO mee_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ka baina i ke sigipaga na ke galiu muni te tamana. “Ava ka ine tatu ngatauga tale, na tamana ke kela pakia ba ka lonananne. Minmina na i ke pira ta goe laeala ae i, na ke kambago ka loserengngana ka tuna. ");
INSERT INTO mee_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Na tuna ke role kia roma, ‘Tamau, iau ka baia bainga e soali te Nutu ba te one. Minmina na ka sana iau a pe muni ta baina one ngo kava iau ka tung.’ ");
INSERT INTO mee_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ava tamana ke role ka ra kumangngatulu ra kanna roma, ‘Ngaka rave lungapaga e pe raumana bolvole, na ngaka palupage kia. Ba ngaka rave oru e nga patungtala, na ngaka kaliale nga kamana ririna ba ngaka kaliale kesingsilagime nga kaename. ");
INSERT INTO mee_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ba ngaka rave kaning ra ita reke pepe raumana, nga baina ita ngaka baia kaning e bollau ore nga pangaserenga. ");
INSERT INTO mee_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ta goe laekia ae iau ke mate ava ke mauli muni; ba i ke taopa, ava ke taopamalaga.’ Minmina na ri keke paturu ta tuvangataonge. ");
INSERT INTO mee_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ava ka ineke kalituptupe oru nginngina, na goe a agau laeala e kapunu ke mommo nga ura. Na ka ine atu kokoro ta bale, na i ke longe baunga ba pesing. ");
INSERT INTO mee_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ka baina i ke kiue akumangngatulu te, na ke ballage roma, ‘Taru iala?’ ");
INSERT INTO mee_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Na ke ale roma, ‘Teiteikone ke atu ta maga muni, na tamamiau ke bavaia kaning e bollau ta i ke ravulelea tuna.’ ");
INSERT INTO mee_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ava goe laeala e pala ne taopa tataokia ka iukia, na i ka sana omona ta i lunga. Ka baina tamana ke lelemalaga na ke toapulia lona ta i loanga ta kaning. ");
INSERT INTO mee_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ava i ke loa ka kaona ka tamana kumangngana kae teiteikia, ba ke role kae tamana roma, ‘Ngo kele! Ka pesingmataname kinung, na iau ka umma ma barangalele ae one, ba iau ka sana longosasa te one. Ava one ko sano baia kaning tunnte e sina mana ta iau pangasereng kala nga kolingau memena isura. ");
INSERT INTO mee_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Na ka ina goe laekia ae one e osemana ka oru nga kaning kala nga ravale ra pamau luana atu, na ko baia kaning e bollau raumana ta tuvangataonge!’ ");
INSERT INTO mee_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Na tamana ke ale roma, ‘Tugu, one ko pune momong kala nge iau ka kaeme kinung, ba oru nga iau kinung ka oru ra one. ");
INSERT INTO mee_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ava ita ngaka paserengea teiteikone laeala lelengana ta i ke base ma i e mate ava ikia e mauli muni, ba ke taopa ava ke taopamalaga muni.’” ");
INSERT INTO mee_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nae Iesus ke role ka pangateningkala te ta barangalele ra kanna roma, “Ka barangalele a sisinglollokannakana te ke momo. Ba ragau keke turupaga kana roma, i e osipatele ka oru ra avolaukia a i a kilipukana kanna. ");
INSERT INTO mee_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Minmina na avolaukia ke kiulue, na ke ballage roma, ‘Ka longe tarume ko kuma ki? Iau ka bai ta kelange oru ra one kuma ki nga oru ra kanegu, ta ka sana la one a asisinglollokannakana ae iau muni.’ ");
INSERT INTO mee_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Minmina na asisinglollokannakana laeala ke role ngallo nga lona roma, ‘Avolaukau ke rong kau nga kumangng a kanegu, ava sonrau na iau ka la maingamia ka momongau? Iau ka besakale kumangng e nga kilingi mogalo, ba ka balenglenge iau ta kangalunga kanau lollokanna.’ ");
INSERT INTO mee_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Na i ka lonagomgome roma, ‘Ka laumatana ka ora iau la kumangng kia nga ina avolaukau nge tao iau nga kumangng laekia. Iau ka la kumangng ka bivingtao te ta baina reke sane ke ale avolaukau lollokanna ra kanna tale ngeke ravu iau ta bale nga ri.’ ");
INSERT INTO mee_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Minmina na i ke kikiue kenakena re sane ke ale avolaukia lollokanna ra kanna tale. Na ke ballage ne kapunu roma, ‘One ko rave avolaukau oru ra kanna pia?’ ");
INSERT INTO mee_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Na agau laeala ke ale roma, ‘Saulang reke papone gatome ka ri 800 ki.’ “Minmina na asisinglollokannakana laeala ke role kia roma, ‘Ngo rave lau a kaning nga alange orume ba ngo tara bolvole, na ngo osurure 400, ava ngo alamane 400.’ ");
INSERT INTO mee_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ngarume na ke ballage agau a lua roma, ‘One ko rave avolaukau oru ra kanna pia?’ “Na agau laeala ke ale roma, ‘Pailli kanna bising kiame ka ri 1000.’ “Minmina na asisinglollokannakana laeala ke role kia roma, ‘Ngo rave lau a kaning nga alange orume, na ngo osurure 200, ava ngo alamane 800.’ ");
INSERT INTO mee_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Na asisinglollokannakana laeala avolaukia ke kinpataea asisinglollokannakana laeala giana kurumea kumangngana ina i lonakanana masia ragau loreavainganame. Iau ka role minmina kurumea, ragau re nga mogalo laekia e ngape sonrau ka loreamatana masi ta loreakananna masia ragau ra tongarea me ri muni loreavainganame. Ba lomatana laeala ae ri ke bollau nga ragau re nga olamana loreamatanangana ka kumangng laeala. ");
INSERT INTO mee_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Minmina na iau nga role kamiau roma, nga lomiaukanana masia lollokanna ba oru re nga mogalo laekia e ngape re ke la ronga mana. Na ngaka tungumana rea ta ra sillolo nga baina Nutu nge ravu miau ta malle reke momo passavele ngarume. ");
INSERT INTO mee_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Agau a lonakala ka kumangngana e sina ka la lonakala ka ne bollau bole. Ba agau a lonakalasa ka kumangngana e sina ka la lonakalasa ka ne bollau bole. ");
INSERT INTO mee_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Minmina na ngaroma miau nga lomiaukalasa ka lollokanna ba oru re nga mogalo laekia e ngape, nae Nutu sana la lonakala kamiau ka oru reke pepe reke momo passavele. ");
INSERT INTO mee_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ba ngaroma miau nga lomiaukalasa ka oru ra sana ri ra oru ra kanimiau, na tai nge tungu kanmiau oru te miau? ");
INSERT INTO mee_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Agau a i a akumangngatulu sane nge kuma nga ravollalaume ka ri lua. Ta i nge baiꞌiu ka te ba nge materaumane te. O i nge loatunanne te ba nge malaipatantalia te. Ba miau ka tongamiau kena mana ma ollaeala. Ka sana kamiau gingginga ta kumangng te Nutu kala nga oru re nga mogalo laekia e ngape kinung.” ");
INSERT INTO mee_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Na Parisiome ra ri ra matengraumana lollokannakana keke longe pangamologa laeala na keke kelapagalising kae Iesus. ");
INSERT INTO mee_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Na i ke role kerea roma, “Ka miau ra ragau raka ulopatae miau nga ragau ragureame roma baingamiaume ke pepe, avae Nutu ka lonamatana ka lomiaume. Iau ka role minmina kurumea, oru ra ragau ke alapaga rea ka koirea bona nge Nutu raguna.” ");
INSERT INTO mee_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Bae Iesus ke role ka potong palu muni roma, “Keke pulimalage bangapaga rae Moses kanna ba pangamologa ra ragau reke toe Nutu kaona kanrea ta ke lele nga kae rae Ion. Ba nga kae rae Ion ta ke lele ikia e sonrau, na keke pulimalaglage pangamologa e pe e ta Nutu kelangpatalingana. Ba ragau papatu keke kalilli ta ri lunga ngia. ");
INSERT INTO mee_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ke ate ta tava ba mogalo laekia ronga, ava ka baingana lilli raumana ta ronga ka pangamologa isunte e sina mana nga bangapaga nginngina rae Nutu kanna. ");
INSERT INTO mee_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Agau e pelea napengana ave kamapitakama ka avale tetoto, agau laeala ke baia bainga e nga kenong ka avale a sana i a napengana. Ba agau e kamapitakama ka avale e pelea natale ke baia bainga laeala bole.” ");
INSERT INTO mee_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ka agau te ora i a kilipukana e lupage nena ka lungapaga reke pepe, ba i ke baia kaning reke bollau ka kaeme kinung ke momo. ");
INSERT INTO mee_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na agau te e kalunglung ta lollokanna a giana nge Lasarus ora bisvisome ke ponu nga mirana ke tattara ka kenongpaikalangana nga bale kaona ae agau laeala a kilipukana. ");
INSERT INTO mee_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ba i ka mate kana raumana, na ke bai ta reke umma nga bale ngeke tunge kana ka kaning mamauna ngae akilipukana. Ba gauneme keke tatu ba keke lemlemia bisoname bole. ");
INSERT INTO mee_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ka kae a soa laeala mate, na anggelome keke paupataea ta sisiukita ae Abaram e mate pala bavana. Ngarume na akilipukana ke mate bole, na keke talue. ");
INSERT INTO mee_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Na ka ine kanimaimaia miralali nga malle nga reke mate e momo ngape bavakena, na ke kela lakailu ba ke kele Abaram nga ine momo ngatauga. Ba i ke kele Lasarus ine momo nga Abaram bavana. ");
INSERT INTO mee_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ka baina i ke kave Abaram roma, ‘Tamau ae Abaram, nga longnanna iau ba ngo baꞌe Lasarus ta i nge bolue kamana ririna nga me ba nge pamaruse tengtengkau kia, ta iau ka kanimaimaia miralali e bollau ikia allo a sia laekia.’ ");
INSERT INTO mee_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Avae Abaram ke ale roma, ‘Tugu, nga longgaliu ta ino mauli tale, na ko rave oru reke pepe ba aekia ae Lasarus ke rave oru reke sosoali. Ava sonrau na i ka lonamannmanna ikia ba one ko kanimaimaia miralali e bollau. ");
INSERT INTO mee_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ba otte bole, ngaliua nge one bae mangng ka rugu e bollau raumana ke kavitotokala tapu, ta baina reke momo nakai ke sane ngeke lotao ta inaekolong. Ba re nga inaekolong ke sane ngeke lotao nasai te mangng.’ ");
INSERT INTO mee_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Na i ke ale roma, ‘Tamau, iau ka tanikala one ta one ngo baꞌe Lasarus ta balekaina ae iau ");
INSERT INTO mee_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ta ka teiteikau memena ka ri lima keke momo tale. Minmina na i nge piratotokala rea ta baina ri nge sane ngeke atu bole ta inaekia e pamiralali.’ ");
INSERT INTO mee_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Nae Abaram ke ale roma, ‘Ke sa. Pangamologa eke paꞌe nga bangapaga rae Moses kanna ba nga lau nga ragau reke toe Nutu kaona kanrea keke momo ta baina ri longa tao.’ ");
INSERT INTO mee_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ava i ke ale roma, ‘Ke sa Tamau ae Abaram. Ri ke sane la longa tao. Ava ngaroma agau te e mate nge loa te ri, na ngeke pulivalakale bainga reke sosoali ba keke la tungnge loreamatenganame te Nutu.’ ");
INSERT INTO mee_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Avae Abaram ke ale muni roma, ‘Ngaroma ri sane ngeke longo ta bangapaga rae Moses kanna ba lau nga ragau reke toe Nutu kaona kanrea, na ri ke sane ke la longa ta agau e sigipaga nga mateng bole.’” ");
INSERT INTO mee_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nae Iesus ke role ka barangalele ra kanna roma, “Oru reke bai ka ragau ta ri pupunga nga bainga reke sosoali nge Nutu raguna keke la leleng, ava oru reke sosoali raumana keke la leleng nga agau a i a pamau nga oru nginngina. ");
INSERT INTO mee_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ngaroma i nge taoamuga ka goe te nga goe kokorai reke sisina ta i kumangng ka bainga e soali nge Nutu raguna. Na agau laeala kana alang e soali ke la bolinglaunga raumana nga alang orae agau a ri ke konapita ka lollo taneke tatamugmuge uit kanna kia nga ganna. Na keke tamalilu kia lakallo ta pelau lona ta i mateng. ");
INSERT INTO mee_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Minmina na ngaka ella miau masi bole. “Ngaroma alopatokonakana tetoto nge kuma ka bainga e soali, na ngaka patupe. Ba ngaroma i nge pulivalakale baingana laeala e soali ba nge tunge lonamatenganame te Nutu, na ngaka osurure baingana laeala e soali. ");
INSERT INTO mee_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ngaroma i nge kuma ka bainga e soali te one pa papatu nga kae kena mana, ba i nge galiu muni te one pa papatu bole ka rolengana roma, ‘Iau ka pulivalakale baingau e soali ba ka tunge laumatenganame te Nutu.’ Na one ngo osurure baingana nginngina reke sosoali.” ");
INSERT INTO mee_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Na aposelme keke role roma, “Ngo paginggingia lopatokona ae mangng te one!” ");
INSERT INTO mee_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Na i ke ala rea roma, “Taroma lopatokona ae miau nge sina raumana ma bega a more kanna mana, na miau taka role ka bega laekolong a kulaname ke kalipita ngallo nga mogalo roma, ‘Ngo lagasisi one muni, na ngo toa one nga pelau.’ Na i nge longo mana te miau. ");
INSERT INTO mee_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ngaroma agau te ngaliua nge miau ka kana ka akumangngatulu ore umma nga ura ae i, o ellapatali ta posi ra marana, na nge meimia? I nge role kia na nge kani ka ine malagapau nga ura? ");
INSERT INTO mee_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ke sa. Avolau laeala nge role kia roma, ‘Aekolong, ngo lupage lungapaga ae one ore nga akumangngatulu na ngo kalitupe kaning rae iau. Ba ngo silae iau nga baina iau nga kani ba nga inu. Ngarume na ngo kani ba ngo inu kang.’ ");
INSERT INTO mee_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Na akumangngatulu avolaukia laeala ke sane nge kalapage ine longomana te i. Ke sa. ");
INSERT INTO mee_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ke base miau bole, nga ina miau ka kuma ka kumangng ra kanimiau, na miau ngaka role roma, ‘Ke sana otte ba ragau sane ngeke alapaga mangng, ta mangng ka kuma ka kumangng ra kanmangng mana.’” ");
INSERT INTO mee_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na ka inae Iesus tatao e lola tae Ierusalem, na ke tao ngaliua nga Sameria ba Galili karea raunga. ");
INSERT INTO mee_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Minmina na ke taolu ta maga te, na ragau ra karea ka soaling a kalangamugmugu ka ri tangulelu keke lele nge i. Ava keke maisi ngatauga ");
INSERT INTO mee_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ba keke kura kaligi roma, “Iesus, Avolau, nga longnana ba ngo palellepa mangng!” ");
INSERT INTO mee_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ka ina i kela rea, na ke ba rea roma, “Miau ngaka loa, na ngaka pakosininge miramiaume ta pirisme kurumea pangamologa rae Moses kanna pala nga baina pirisme nga loreamatana roma, miramiaume keke pepe tapu.” Na ka ina ri ke tatao tale, na mirareame keke lelle. ");
INSERT INTO mee_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ava te e nge ri ke kele mirana ine lelle, na ke galiu ka kurangana ba kalangpagangana kae Nutu. ");
INSERT INTO mee_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Minmina na i ke toarau kokoro nge Iesus kaename ka kalangapagangana kia. Ba bole, agau laeala ka i a Sameria te. ");
INSERT INTO mee_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nae Iesus ke ballaga roma, “Iau ka palellepaꞌe ragau ka ri pana tangulelu kinung mirareame, ava pana lima ba tugulu keke momo aetai? ");
INSERT INTO mee_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kana ka aekia mana a sana i a Iura te ke galiu ta kalangpagange Nutu?” ");
INSERT INTO mee_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Na i ke role ka agau laeala roma, “Sigipaga, na ngo loa ta lopatokona ae one e te Nutu pangapengana kone ke palellepa one.” ");
INSERT INTO mee_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ka kae te, nae Parisio palu keke ballage Iesus roma, “Nutu kelangpatalingana ke la atung nga pia?” Na i ke ala rea roma, “Nutu kelangpatalingana ke sane la atung ma oru a ragau ke kele ka matarea kanname. ");
INSERT INTO mee_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ba ragau ke sane ke la roleng roma, ‘Ngaka kele. Ke momo ikia!’ o ‘Ke momo a inaeala!’ Iau ka role minmina kurumea, Nutu kelangpatalingana ke momo ngaliua nge miau.” ");
INSERT INTO mee_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Na i ke role ka barangalele ra kanna roma, “Kaeme keke la leleng ngarume nga ina miau kaka la mateng raumana ta kelange kae te ae Agau Tuna. Ava ka sana ka la kelange. ");
INSERT INTO mee_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ba ragau keke la roleng kamiau roma, ‘Ngaka kele, Karais iala!’ o ‘Ngaka kele, Karais ikia!’ ava sana ngaka pira kurume rea. ");
INSERT INTO mee_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Iau ka role minmina kurumea, kae laeala e nga Agau Tuna ngarume ka la tongana kena ma saia ine nge killama, na lamanangana nge sase tava iname karolu. ");
INSERT INTO mee_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ava pala nga kae laeala lelengana, na i ke la kaningmainge miralali papatu ba ragau reke momo sonrau keke la tangunglelenge. ");
INSERT INTO mee_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ba oru reke la leleng nga kae rae Agau Tuna ngarume ka la tongarea kena ma oru reke lele pala nga kae rae Noa. ");
INSERT INTO mee_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ka kae nginngina, na ragau keke kaninni, ba keke innu, ba keke paliraravu rea ta ke lele ina kae laeala a Noa kala nga balekaina ae i ke lu lakallo ta mono. Ngarume na me potungana e bollau ke lele, na ke kauupite ragau kinung re sane ke momo ngallo nga mono. ");
INSERT INTO mee_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Oru nginngina keke lele pala nga kae rae Lot bole. Ragau keke kaninni, ba keke innu, ba keke bava ka orume, ba keke kolkoli rea, ba keke tota kaning, ba keke umma ka baleme. ");
INSERT INTO mee_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ava ka kae laeala ae Lot kaꞌe maga kunna a Sorom, nae Nutu ke bapisigi ka sia ba lollo reke toto nga tava, na keke kauupita rea karolu. ");
INSERT INTO mee_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ka la tongana kena mana ma kae laeala ae Agau Tuna la potang ngia. ");
INSERT INTO mee_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nga kae laeala na agau e momo nga bale bilingana e ngailu sane nge sopisigi ta bilingana e ngape ta ravunge oru nga kanna nga bale. Ke sa. Nge ka bolvole. Ba bole, agau e momo nga ura sane nge kagaliu ta maga ta ravunge oru nga kanna. ");
INSERT INTO mee_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nga lomiaugaliu te Lot napengana! ");
INSERT INTO mee_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Agau e ava ta kamongpitange maulingngana ke la pangasanrea kia. Ba agau e pasanrea ka maulingngana ke la bainga ka maulingngana ta i momong masi. ");
INSERT INTO mee_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ba iau nga role kamiau roma, rapanung lua keke la kenong nga nia ka rigo ka kae laeala, nae Nutu ke la ravunge te nge ri pana lua, ava te ke la momong. ");
INSERT INTO mee_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ba bole ravale lua keke la naunga lamasi kinung, nae Nutu ke la ravunge te nge ri pana lua nginngina, ava te ke la momong.  ");
INSERT INTO mee_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","“Ba rapanung lua keke la kumangng kinung nga ura, nae Nutu ke la ravunge te nge ri pana lua nginngina, ava te ke la momong.” ");
INSERT INTO mee_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Na keke ballage roma, “Avolau, oru nginngina keke la leleng nga ine ngaetai?” Na i ke ala rea ka pangateningkala te roma, “Manu reke kaninnia onreke bona keke la ginunga nga malle a oru e bona momo ngia.” ");
INSERT INTO mee_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ka kae te, nae Iesus ke rolepage barangalele ra kanna lorea ka pangateningkala te ta baina ri sana nga omoreasa ta kavang te Nutu, ava ngeke kavkava ka kaeme karolu. ");
INSERT INTO mee_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Minmina na i ke role kerea roma, “Ka agau te a kalingnanakana ke momo nga maga kunna te e bollau. Ba agau laeala ke sane mataue Nutu ba ke sane matea ragau bole. ");
INSERT INTO mee_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na nga maga kunna laeala ka avale te a bagaru e tatu ta akalingnanakana laeala ka kaeme kinung ke momo bole. Ba i ke tanialle akalingnanakana roma, ‘Aisii! Aekolong, ngo lengetotokala iau nga agau e bai ta baingasoali iau.’ ");
INSERT INTO mee_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Ka kae palu, na akalingnanakana laeala ke sane longokale, ava ngarume na ka lonagomello roma, ‘Iau ka sana mataue Nutu ba ka sana matea ragau bole, ");
INSERT INTO mee_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ava ka omogusa ka avale laekia a bagaru atungngana ba kaona ginangana. Minmina na iau nga lengetotokale nga baina i sane nge baimatalali kau ka atungngana palimule!’” ");
INSERT INTO mee_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ka bainae Iesus ke turupote pangateningkala roma, “Ngaka longe akalingnanakana laeala e sane tupu pangamologangana. ");
INSERT INTO mee_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ngaka kele. Nutu ka i a akalingnanakana e tupu. Ava ke meimia? Kaka roma, i ke sane nge kananatupe ragau rae i ra i toro rea te i ka ineke tanialle ka kavangarea ka kaeme karolu? Ba i ke la kelangavalakala rea bole? ");
INSERT INTO mee_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ke sa. Iau nga role kamiau roma, i ke la longakala rea bolvole mana. Ava ka inae Agau Tuna nge atu muni, na i ke la kaling paka ragau ra loreapatokona tale te i nga mogalo laekia e ngape, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Bae Iesus ke panane pangateningkala te e ta ragau ra loreapatokona ngallo nga lorea roma baingareame ke pepe, minmina na ri keke kanpea ragau pattoto. Na i ke patenikala roma, ");
INSERT INTO mee_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ka pana lua keke loalu ta tempel ta ri kavang. Te ka i a Parisio, ba te ka i a aravungkinung takiskana. ");
INSERT INTO mee_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Na Parisio laeala ke maisi, na i muni ke kava roma, ‘Nutu, iau ka laupe kone roma baingau ka sana tongana kena ma ragau pattoto reke golgolo, ba ra loreakalasa, ba reke bavaia bainga reke soali nga ravale ra sana ri ra nereapengana memena. Ba iau ka sana tongau kena ma aravungkinung takiskana laeala bole. ");
INSERT INTO mee_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ba otte muni, iau ka kuriri ta kaning ka kae lua nga kumangnga maina kenakena. Ba iau ka kalipalpale oru ngae iau kinung ta rina tangulelu, na ka tatu ka inte nga tangulelu nginngina ma i a tunga nasai ta tempel.’ ");
INSERT INTO mee_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ava aravungkinung takiskana laeala ke maisi balakala, na ke kelapisigi ka balenga. Ba i ke tute mautuna ka lonataningana ba rolengana roma, ‘Nutu, one nga longnanna iau a baingau soali.’” ");
INSERT INTO mee_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Minmina nae Iesus ke role muni roma, “Iau nga role kamiau roma, nga ri pana lua nginngina aravungkinung takiskana laeala ke loa ta bale ae i ka pengana nge Nutu raguna. Ava Parisio laeala, ke sa. Ta agau a i muni ulopataea giana sonrau, nae Nutu ke la ulongpisiginge ngarume. Ba bole agau a i muni ulopisigia giana sonrau, nae Nutu ke la ulongpataenge ngarume.” ");
INSERT INTO mee_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ba ragau palu keke lola ka goe rae ri reke sisina te Iesus ta baina i nge ulopaia kamana nge ri ba nge kava te Nutu te ri. Ava ka ina barangalele ra kanna ke kele ollaeala, na keke sanggipita rea. ");
INSERT INTO mee_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Avae Iesus ke kiue goe nginngina te i, na ke role roma, “Ka ule ragoeme ngeke atu te iau, ba manemiausa bongakala rea ta Nutu kelangpatalingana ka orae ragau reke ulopisigi rea muni ma goe kokorai. ");
INSERT INTO mee_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Iau ka la roleng kamiau ka kaomannmannangana roma, ngaroma agau te sane nge rave Nutu kelangpatalingana ma goe te, na agau laeala ke sane la lunga lakallo ngia bavakena.” ");
INSERT INTO mee_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Na agau te a i a kelangpatali ke ballage Iesus roma, “Apangalomatanakana e pe, iau nga meimia ka baingau ta ravunge mauling e momo passavele?” ");
INSERT INTO mee_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nae Iesus ke role kia roma, “Ko meimia o pato iau roma, iau a pe? Ka sana agau te pe, avae Nutu kasikena mana. ");
INSERT INTO mee_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","One ka longmatana ka bangapaga rae Nutu kanna roma: ‘One ko sano ngo keno kala nga avale a sana i a ningpengana, ba one ko sano ngo sapune agau te, ba one ko sano ngo golo, ba one ko sano ngo turu goang, ba one ngo alapagpage tamang bae name.’” ");
INSERT INTO mee_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Na agau laeala ke ale roma, “Iau ka tataokurumea bangapaga kokorong kinung ka ina sina ta ke lele ikia e sonrau.” ");
INSERT INTO mee_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ka inae Iesus longe pangamologangana laeala, na i ke role kia roma, “Ke pe, ava one ko moro ta oru kena tale. Ngo ba ka oru rae one kinung nga baina one ngo rave lollokanna ki. Na ngo tavoa ka lollokanna nginngina ta ra sillolo. Na one ka la kanga ka oru reke pepe re nga Nutu mallena nga tava. Na ngo atukurume iau.” ");
INSERT INTO mee_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ava ka ina agau laeala longe Iesus pangamologangana laeala, na raguna ke so ta ka i a akilipukana raumana. ");
INSERT INTO mee_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nae Iesus ke kela te i, na ke role ka barangalele ra kanna roma, “Ra kilipukana ka baingarea lilli raumana ta ri lunga lakallo ta Nutu kelangpatalingana! ");
INSERT INTO mee_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Iau ka role minmina kurumea, posi a kamele te lungana nga bulongpita ore nga sainga masina ke ate raumana nga agau a kilipukana te lungana nga Nutu kelangpatalingana.” ");
INSERT INTO mee_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Na ragau reke longe pangamologa laeala keke ballage roma, “Ngaroma minmina, nae Nutu ke la ravunglelenge tai mannangana?” ");
INSERT INTO mee_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nae Iesus ke ala rea roma, “Nutu ka kana ka gingginga ta kumangng ka oru ra ragau sana likirea bavakena ta kumangng ki.” ");
INSERT INTO mee_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nae Pita ke role kia roma, “Mangng ka kaꞌe orume kinung rae mangng ta loangakurume one.” ");
INSERT INTO mee_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nae Iesus ke role kerea roma, “Iau nga role kamiau ka kaomannmannangana roma, agau e kaꞌe bale ae i, o napengana, o tataokia memena, o teiteikia memena, o liuna piau memena, o tamana, o naname, o goe rae i, ta i kumangng ka kumangng e nga Nutu kelangpatalingana, ");
INSERT INTO mee_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ke la ravunge kana oru papatu ngailu muni nga oru nginngina ka kae kokorai re sonrau. Ba i ke la ravunge mauling e momo passavele ngarume bole.” ");
INSERT INTO mee_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nae Iesus ke ngaluvalakale Pana Tangulelu Ba Lua, na ke role kerea roma “Ita kaka la loangapatae tae Ierusalem, na orume kinung re te Agau Tuna onra ragau reke toe Nutu kaona ke pa rea pala keke la leleng mannangana. ");
INSERT INTO mee_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ragau palu keke la ri pulinge ta ragau ra sana ri ra Iura kamareame ta ri rolengpagalising kia, ba rolengbainga kia, ba utungtaonge. ");
INSERT INTO mee_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ba nga ineke la sapinge tapu, na keke la samungpununge. Ava nga kae a mologi ngarume nga matengana, na i ke la sigingpaga nga mateng.” ");
INSERT INTO mee_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ava barangalele ra kanna ka sana loreamatana ka pangamologa nga oru nginngina kurumea, pangamologa laeala mirana ke ko nge ri. Ba ri ka sana loreamatana roma, i ke rorole ta taru. ");
INSERT INTO mee_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ka inae Iesus lele kokoro ta maga kunna ae Ieriko, na agau te a matana kanname ke su ke tattara nga pamau bavana. Ba i ke tanialle ragau ta ri tunga kanna lollokanna. ");
INSERT INTO mee_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Na ka ine longe maluame ineke kavesilelea, na i ke ballaga rea roma, “Taru iala e lele?” ");
INSERT INTO mee_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Na keke turu pakia roma, “Iesus e ngae Nasaret ke la kavesing one.” ");
INSERT INTO mee_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Minmina na i ke kiu roma, “Iesus! One ae Revit Sivuna! Nga longnanna iau!” ");
INSERT INTO mee_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Na ragau reke taoamugmuga ka maluame keke role kia gingging ta i rulung, ava i ke kikiu kaligi raumana muni roma, “One Ae Revit Tuna! Nga longnanna iau!” ");
INSERT INTO mee_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nae Iesus ke maisi na ke role ta ri atung ka matasu laeala te i. Ba ka ine atu kokoro, nae Iesus ke ballage roma, ");
INSERT INTO mee_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ko bai ta iau maingamia kone?” Na i ke role roma, “Avolau, iau ka bai ta kelanga muni.” ");
INSERT INTO mee_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nae Iesus ke role kia roma, “Ko la kelanga. Lopatokona ae one te iau ke pape one.” ");
INSERT INTO mee_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ba ka pannasa mana na, matana kanname keke pepe. Na i ke loakurumea Iesus ka kalangapagangana kae Nutu. Ba ka ina ragau ke kele ollaeala e lele, na ri bole keke kalapage Nutu. ");
INSERT INTO mee_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ngarume, nae Iesus kala nga barangalele ra kanna keke tataopale maga kunna ae Ieriko. ");
INSERT INTO mee_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na agau te a giana nge Sakias ke momo. Ka i a avolau nga reke raravukinunge takisme ba ka i a akilipukana bole. ");
INSERT INTO mee_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Na agau laeala ke bai ta kelange Iesus, ava ka baingana lilli kurumea, kaina ke moro ba maluame ka ri papatu. ");
INSERT INTO mee_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Minmina na i ke pira lagamuga, na ke taepatae nga bega ta baina i nge kele Iesus nga ine nge tatu ta kavesinge nga inaeala. ");
INSERT INTO mee_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ka inae Iesus lele nga bega laeala a Sakias taepatae ngia puna, na i ke kelapatae ba ke role kia roma, “Sakias, ngo sopisigi bolvole ta iau ka la momong isura nga bale ae one sonrau.” ");
INSERT INTO mee_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ka baina Sakias ke sopisigi bolvole ba ke ngalue Iesus ka lonaserengngana ta bale ae i. ");
INSERT INTO mee_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Na ragau keke kele Iesus ine lolakurumea Sakias, ba keke rorole ka rolengtunanangarea roma, “Ke meimia, na aekia ke loa ta i a agasila a agau a bainganame ke sosoali?” ");
INSERT INTO mee_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ngarume, nae Sakias ke maisi na ke role kae Iesus roma, “Avolau, ngo long! Iau ka la kalingpalange oru nga iau kinung ngaliua, na ka la tungnge bavana te ta ra sillolo. Ba iau ka la alange oru nga ragau ra kaoguginapita rea pala pa tugulu te ri muni.” ");
INSERT INTO mee_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nae Iesus ke role kia roma, “Sonrau, nae Nutu ke ravulelea balekaina laekia ta agau laekia ka i ae Abaram sivuna bole. ");
INSERT INTO mee_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Iau ka role minmina kurumea, Agau Tuna ke atu ta silinge reke sanrea ba ta ravunglele rea.” ");
INSERT INTO mee_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na ragau reke momo keke longlongo ta Iesus pangamologangana, ba inaeala e i momo ngia ke kokoro isura tae Ierusalem. Minmina na ragau keke roma, Nutu kelangpatalingana ke la i leleng bolvole mana. Ka bainae Iesus ke role kerea ka pangateningkalangana roma, ");
INSERT INTO mee_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Ka agau te avolau ke momo. Ba agau laeala ka lonavavai ta i loanga ta maga te e ngatauga ta baina ri ngeke pulia ta i a kelangpatali. Ngarume nga ine nge rave mallena tapu, na i ke la kangagaliu ta maga kunna ae i muni. ");
INSERT INTO mee_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ava pala ta i loanga, na i ke kiukinunge ra kumangngatulu ra kanna ka ri tangulelu, na ke pasisia kenakena ka lollokanna kena. Na ke role kerea roma, ‘Ngaka pakamo ka lollokanna kokorai nga ina iau nga momo nga inaeala tale.’ ");
INSERT INTO mee_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Na ragau re nga maga ae i ka siarealali kia. Minmina na keke baꞌe ragau ka pangamologa ta inaeala e i loa te ta baina ri ngeke role roma, ‘Mangng ka sana omomangng ka agau laekia ta i kelangpatali te mangng.’ ");
INSERT INTO mee_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ava avolau laeala ke rave mallena e nga kelangpatali na ke galiu ta maga ae i. Na i ke kiukinunge ra kumangngatulu ra kanna ra i pasisi rea ka lollokanname pala ta ri ngeke atu te i nga baina i nga lonamatana ka kenakena pangakamongana ka lollokanname. ");
INSERT INTO mee_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Minmina na ne kapunu ke atu, na ke role roma, ‘Avolau, lollokanna kena ama kaning ke pakamoe tangulelu muni.’ ");
INSERT INTO mee_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ka baina avolau laeala ke role kia roma, ‘Ko kuma masi, ba ka one a akumangngatulu e pe! One ka longkala ka ore sina, minmina na iau ka la puling one ta kelangpatali ta maga kunna tangulelu reke bollalau.’ ");
INSERT INTO mee_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Na akumangngatulu a lua ke atu, na ke role roma, ‘Avolau, lollokanna kena ama kaning ke pakamoe lima muni.’ ");
INSERT INTO mee_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Na avolaukia ke ale roma, ‘One ko la kelangpatali ta maga kunna lima reke bollalau.’ ");
INSERT INTO mee_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ngarume na akumangngatulu tetoto ke atu, na ke role roma, ‘Avolau, lollokanna a kaning ikia. Ka lulupite ka malo, na ke momo masi. ");
INSERT INTO mee_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ka kuma minmina ta iau ka matau one kurumea, ka one a avolau te e isopa. One ko raravumane ora agau tetoto kanna, ba ko umma ta lagange kaning a agau tetoto toaꞌe.’ ");
INSERT INTO mee_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Na avolaukia ke ale roma, ‘Ka one a akumangngatulu ore sane pe! Pangamologangang muni ke la puling one nga kalingnana! Ka longmatana tapu roma, ka iau a agau e isopa. Iau ka raravumane ora agau tetoto kanna ba ka umma ta lagange kaning a agau tetoto toaꞌe. ");
INSERT INTO mee_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ke meimia na one ko sano pulia lollokanna a kanau nga malle e ta i pangakamo ngia nga baina iau nga galiu na nga rave lollokanna a kanau ba palu ngailu muni?’ ");
INSERT INTO mee_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ngarume na avolaukia ke role ka ragau reke maisinsi nga inaeala roma, ‘Miau ngaka ravugaliue lollokanna laekolong nge i, na ngaka tunge ta akumangngatulu laeala a kanna ka lollokanname ka ri tangulelu.’ ");
INSERT INTO mee_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Na ri keke role ka magiongangarea roma, ‘Ava aekolong ka kanna tangulelu tapu!’ ");
INSERT INTO mee_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Na avolaukerea ke ala rea roma, ‘Iau nga role kamiau roma, iau ka la tungnge oru papatu muni ta agau a kana oru nga baina i nga kana oru papatu raumana. Ava nga agau a sana kana oru, iau ka la ravungpatali ka ottutunna rae i nga baina i sana nga kana oru bavakena. ");
INSERT INTO mee_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ava nga ra nginngina reke baiꞌiu kau ba ka sana omorea ta iau kelangpatali te ri—ngaka atu kerea nasai na ngaka sapunu rea nga ragugu.’” ");
INSERT INTO mee_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ba ka inae Iesus rolea pangamologa nginngina tapu, na i ke taoamuga kerea patae tae Ierusalem. ");
INSERT INTO mee_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ba ka ineke lele kokoro tae Betage bae Betani ngae Kapoponga Nga Bega Ra Oliv, nae Iesus ke baꞌe barangalele lua ra kanna ka potongana kerea roma, ");
INSERT INTO mee_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Onemea ngaka loa ta maga kunna laeala e ngamuga nge onemea. Ba nga ina miau nga lu ngia, na kaka la kalingpa ka ronki te a lumangngapau eke samapite. Ka la i a ronki ora agau te sane tarapai kia tale. Ngaka luve, na ngaka atu kia nasai. ");
INSERT INTO mee_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ba ngaroma agau te nge ballaga miau roma, ‘Kaka meimia aka luvluve ronki laekolong?’ Na ngaka role kia roma, ‘Avolau ka kanna ka kumangng kia.’” ");
INSERT INTO mee_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ka baina barangalele lua nginngina ra i ba rea keke loa, na kelangareangana ka tongana kena mana ma Iesus pangamologangana te ri. ");
INSERT INTO mee_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ba ka ineke luvluve ronki laeala, na ra ronki ae ri keke ballage ri pana lua roma, “Ke meimia aka luvluve ronki laekolong?” ");
INSERT INTO mee_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Na keke ala rea roma, “Avolau ka kanna ka kumangng kia.” ");
INSERT INTO mee_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Na keke loa kia te Iesus. Ba ka ineke palale lungapaga nga ri re ngapotu tapu, na keke unapai rea nga ronki laeala a lumangngapau gina. Nae Iesus ke tarapai kia. ");
INSERT INTO mee_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ba ka inae Iesus tatao e lola ka ronki laeala, na ragau keke unasilaglagi ka lungapaga ngae ri re ngapotu nga pamau. ");
INSERT INTO mee_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ba ka inae Iesus lele kokoro tae Ierusalem nga malle a pamau sopisigi ngia nga Kapoponga Nga Bega Ra Oliv, na barangalele ra kanna ba maluame kinung keke paturu ta kalangapagange Nutu ka kiungareangana kaligi kurumea killa reke bollalau ra ri ke kela rea ka matarea kanname roma: ");
INSERT INTO mee_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Nutu ke kavitulu raumane aekia a i a kelangpatali e atu nge Nutu a i ae Avolau giana!” “Momongpengana nge momo nga Nutu mallena nga tava ba ita ngaka kinpataea Nutu E Ngailu Raumana giana!” ");
INSERT INTO mee_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nae Parisio palu reke momo ngallo nga maluame keke role kae Iesus roma, “Apangalomatanakana, ngo parule barangalele ra kaning.” ");
INSERT INTO mee_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Avae Iesus ke ala rea roma, “Iau ka la roleng kamiau roma, ngaroma ragau kokorai ngeke rulu na lollome keke la ri reling.” ");
INSERT INTO mee_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ba ka inae Iesus lele kokoro tae Ierusalem ba ke kele maga kunna laeala, na i ke tania maga kunna laeala ka rolengana roma, ");
INSERT INTO mee_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Te pe taroma ragau reke momo ngallo nge one sonrau teke kelapatokone pamau mannangana e nga momongmasi kala nge Nutu. Ava sonrau na pamau laeala ke ko nga matarea kanname. ");
INSERT INTO mee_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Iau ka role minmina kurumea, ngarume na kaeme keke la leleng nge one nga ina ragau reke baiꞌiu kone keke la kavingtaliutotokala one; ba keke la maisingtotokala one ta baina ragau rae one nga manereasa lunga ba lelengmalaga; ba keke la ri sanangkalataliu one nga bavangame kinung. ");
INSERT INTO mee_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Na keke la ri kauunga one ba samungpununge ragau reke momo ngallo nge one. Ba ke sene ke la kange lollo te ngallo nge one ta i maisingpai nga tetoto. Oru nginngina keke la leleng nge one kurumea, one ko sano kelapatokone kae ae Nutu atu te one.” ");
INSERT INTO mee_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nae Iesus ke loalu ta ine nga tempel, na ke paturu ta taongamalagange ragau reke bava ka orume ngallo nga inaeala. ");
INSERT INTO mee_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Na i ke role kerea roma, “Keke paꞌe Nutu pangamologangana pala ore role roma, ‘Bale ae iau ka la i a bale ore nga kavang’; ava miau kaka bai kia ma i a ‘malle a ragolongkana ta ri katungkala.’” ");
INSERT INTO mee_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ka kae nginngina kinung, nae Iesus ke lola ta tempel ta pangalomatanange ragau. Ba re kapunu nga pirisme, ba ra pangalomatanakana nga bangapagame, ba reke taoamugmuga ka ragau keke amva ta ri balingpununge. ");
INSERT INTO mee_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ava ke sane ke kalipa ka pamau te ta ri kumangng minmina kurumea, ragau kinung keke matea pangamologa ra kanna raumana. ");
INSERT INTO mee_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ka kae te, ka inae Iesus palomatantane ragau ngallo nga tempel ba ke pulimalaglage pangamologa e pe ae Nutu kanna te ri, na re kapunu nga pirisme, ba ra pangalomatanakana nga bangapagame kala nga Iurame ravollalaukerea memena palu keke loa te i, na keke ballage roma, ");
INSERT INTO mee_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Ngo role kamangng, one ko rave gingginga ta one kumangng ka oru kokorai mina ngaetai? Ba tai ke tunge gingginga laekolong te one?” ");
INSERT INTO mee_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Na i ke ala rea roma, “Ba iau bole ka bai ta balinglaga miau roma: ");
INSERT INTO mee_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ion kumangngana ore nga pangamagoe ke pa nga Nutu mallena nga tava, o ke atu nga ragau?” ");
INSERT INTO mee_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Na ri keke palipamologa ngaliua nge ri muni roma, “Ngaroma ita ngaka role roma, ‘Ka ore nga Nutu mallena nga tava,’ na i nge ballaga ita roma, ‘Minmina na ke meimia na ka sana lomiaupatokona te?’ ");
INSERT INTO mee_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ava ngaroma ita ngaka role roma, ‘Ka ore nga ragau,’ na ragau ngeke tamali ita ka lollome kurumea, ri ka loreapatokona roma, Ion ka i a agau te e toe Nutu kaona mannangana.” ");
INSERT INTO mee_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Minmina na ri keke ale roma, “Mangng ka sana lomangngmatana roma, ke pa ngaetai.” ");
INSERT INTO mee_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nae Iesus ke role kerea roma, “Iau bole ka sana la turung te miau ka tai ke tunge gingginga ta iau kumangng ka oru kokorai.” ");
INSERT INTO mee_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Na i ke rolea pangateningkala laekia ta ragau reke momo nga tempel roma, “Ka agau te a kana ka ura te ke momo. Ba i ke toaꞌe kaning eke kuma ka uain kia nga ura laeala. Ba ka kae te, na i ke paꞌtaloe ragau palu ta ri kelangpatali ta ura laeala, na ke loa ta inte toto. Ba i ke momo nga inaeala ka panna te e gavili. ");
INSERT INTO mee_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ngarume, ka kae e nga lalang, na i ke baꞌe akumangngatulu a kanna te ta ragau nginngina ra i paꞌtalo rea ta baina ri ngeke tunge kana kaning palu. Ava ra nginngina ra i paꞌtalo rea keke balia akumangngatulu laeala, na keke bagaliumane ka kamana. ");
INSERT INTO mee_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Na ura tamana laeala ke baꞌe akumangngatulu a kanna te muni, na ke loa. Ava keke balia akumangngatulu laeala bole ba keke pavalengea. Na keke bagaliumane ka kamana. ");
INSERT INTO mee_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Na i ke baꞌe na mologi e loa. Na keke name kia ba keke gulaemalaga kia. ");
INSERT INTO mee_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ngarume na ura tamana laeala ke role roma, ‘Iau ka la kumangng mina ngaetai? Iau ka la bange tugu a iau materaumane, na ri keke la longa te i nanguni.’ ");
INSERT INTO mee_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ava ka ina ragau nginngina ra i paꞌtalo rea ke kele tuna, na ri keke palirole kerea roma, ‘Aekia ka i a ura tamana tuna. Ita ngaka sapune nga baina nga kara ka ura laekia.’ ");
INSERT INTO mee_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Minmina na keke gulaemalaga kia nga ura, na keke sapune.” Nae Iesus ke ballage reke longlonge pangateningkala laeala roma, “Minmina na ura tamana ke la maingamia kerea? ");
INSERT INTO mee_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","I ke la atung, na ke la samungpununge ra pangatalo nginngina, na ke la tungnge ura laeala ta ragau pattoto.” Na ka ina ragau reke momo nga tempel ke longe pangamologa laeala, na keke role roma, “Ke sa. Ollaeala nga manenasa leleng!” ");
INSERT INTO mee_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nae Iesus ke kelanana rea ba ke ballaga rea roma, “Ava pangamologa laeala ameke paꞌe pala nga Lau Ae Nutu Kanna ka mirana mina ngaetai ineke pa roma, ‘Lollo ama ra popongpita ke tangulelea ke lele i a lollo kena a kana ka gingginga ta maisinggingging ka bale’?” ");
INSERT INTO mee_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Bae Iesus ke role roma, “Ngaroma agau te nge pupai nga lollo laeala, na i ke la gitungpalikolo kia. Ava ngaroma lollo laeala nge pupai nga agau te, na lollo laeala ke la popongpalgamung ka agau laeala.” ");
INSERT INTO mee_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Na ra pangalomatanakana nga bangapagame ba re kapunu nga pirisme ka loreamatana roma, nga pangateningkala laeala i ke rorolea pangamologa e te ri mana. Minmina na keke sissilia pamau ta ri launge ka panna inaeala mana. Ava keke matautaue ragau. ");
INSERT INTO mee_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Na ri keke ella te Iesus. Ba keke baꞌe ragau ra kelangatotokana reke goga roma keke tupu ta baina ri ngeke laue Iesus ka pangamologangana inte. Keke kuma minmina ta baina ri ngeke ule Iesus nga gavana e ngae Rom kamana. ");
INSERT INTO mee_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Na ra goangakana nginngina keke ballage Iesus roma, “Apangalomatanakana, mangng ka lomangngmatana roma, pangamologa ra kaning ba pangalomatana ra kaning keke tupu. Ba ko sano pulia agau te ngailu nga tetoto, ava ko palomatantane ragau kurumea Nutu lonangana mannangana. ");
INSERT INTO mee_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Minmina na ngo role kamangng, bangapagame keke parototokala ita ta tungnge takisme te Sisa, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Avae Iesus ka lonamatana ka ineke bai ta patugungtaonge. Minmina na i ke role kerea roma, ");
INSERT INTO mee_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ngaka pakosi iau ka lollokanna te. Tai kannuna ba giana ke momo nga lollokanna laekolong?” ");
INSERT INTO mee_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Na keke ale roma, “Orae Sisa.” Na i ke role kerea roma, “Minmina mana na miau ngaka ale oru rae Sisa kanna te Sisa, ba ngaka ale oru rae Nutu kanna te Nutu.” ");
INSERT INTO mee_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Minmina na ri keke baililli ta launge ka pangamologanganame nga ragau ragureame. Ba keke kallo raumana kurumea alangagaliungana kerea. Na keke rulu mana. ");
INSERT INTO mee_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ka kae te nae Sarusi palu onra ri ra ragau ra sana loreapatokona roma, reke mate keke la sigingpaga nga mateng muni, keke atu te Iesus ka balinglaga te. Na keke role kia roma, ");
INSERT INTO mee_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Apangalomatanakana, pala nae Moses ke paꞌe pangamologa ore role kamangng roma, ngaroma apanung te tataokia nge matepatalia napengana ba ka sana nerea goe, na apanung laeala teiteikia nge ravupaga ka avale laeala ta baina tataokia nga nena ka goe nge i. ");
INSERT INTO mee_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na ngo kele. Ka pana lima ba lua ra panung ra ri ra koli keke momo. Ba ri ka tamarea kena. Na ne kapunu ke kamapitakama ka avale te, ava ri pana lua ka sana nerea goe. Ngarume na apanung laeala ke mate. ");
INSERT INTO mee_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Na ngarume na na lua ke ravupaga ka avale laeala, ava ke mate. ");
INSERT INTO mee_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Na ngarume muni na na mologi ke ravupaga ka avale laeala, ava i ke mate bole. Minmina na mateng ke rongo ka pana lima ba lua nginngina ra koli kinung, ba ri kinung ka sana nerea goe. ");
INSERT INTO mee_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Na ngarume bavakena, na avale laeala ke mate bole. ");
INSERT INTO mee_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Minmina na nga kae e nga sigingpaga nga mateng ngarume, na tai mannangana ka la napengana nga avale laeala kurumea, ri pana lima ba lua ra koli kinung keke kamapitakama kia?” ");
INSERT INTO mee_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nae Iesus ke ala rea roma, “Ragau reke momomauli sonrau keke paliraravu rea. ");
INSERT INTO mee_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Ava ra bale ba ra panung rae Nutu role ta ri sigingpaga nga mateng nga kae laeala e ngarume ke sane ke la mateng muni kurumea, ri ka la tongarea kena ma anggelome. Ba bole, ke sane ke la palingravungu rea. ");
INSERT INTO mee_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Bae Moses bole ke turupatokona roma, reke mate keke la sigingpaga nga mateng. I ke turupota minmina nga Lau Ae Nutu Kanna nga pangamologa inaeala ore role ta bega a sia lele ngia ine patoe Nutu a i ae Avolau kae ‘Nutu ae Abaram, bae Aisak, bae Iekop.’ ");
INSERT INTO mee_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Minmina nae Nutu ka sana i ae Nutu orae reke mate. Ke sa. Ka i ae Nutu orae reke mauli kurumea, te i ri kinung keke mauli.” ");
INSERT INTO mee_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Na ra pangalomatanakana palu nga bangapagame keke ale Iesus pangamologangana laeala roma, “Apangalomatanakana, ko pamologa masi!” ");
INSERT INTO mee_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Minmina na ka sana agau te ballage muni ka balinglaga te bavakena. ");
INSERT INTO mee_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nae Iesus ke role kerea roma, “Ke meimia, na ra pangalomatanakana nga bangapagame keke patpatoe Karais roma i ae Revit sivuna? ");
INSERT INTO mee_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ngallo nga Lau Ae Nutu Kanna nga ineke patoe ka Baunga Re Nga Kalangpaga nae Revit muni ke role roma: “‘Nutu a i ae Avolau ke role kae Avolaukau roma: “One ngo tara nga bava nga kamau e pe nga malle a alangpaga ");
INSERT INTO mee_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ta nge lele nga kae laeala ina iau la ulongpisiginge reke baiꞌiu kone ngape nga kaeng sianame.” ’ ");
INSERT INTO mee_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Revit muni ke patoe agau laeala kae Avolaukia. Minmina nae Karais ka i ae Revit sivuna mana mina ngaetai?” ");
INSERT INTO mee_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ka ina ragau ke longlonge Iesus pangamologanganame, na i ke role ka barangalele ra kanna roma, ");
INSERT INTO mee_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ngaka ella miau masi ta ra pangalomatanakana nga bangapagame. Ri keke materaumana ta taongataliunga ka lungapaga re ngapotu onreke gavili ta roleng roma, keke ngailu nga ragau pattoto. Ba keke matea ta ragau alangapaga rea nga malle nge nga katungkala. Ba keke matea ta tarang nga tarangapai re kapunu ngallo nga bale nga sinagog ba nga malle re nga alangpaga nga kaning reke bollalau. ");
INSERT INTO mee_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ba ri ka kaoreaginapitpite ra bale ra nareatale memena ke matepatali rea ta ravunge bale nga ri. Ba keke bavai ka kavanga reke gavili ta baina ragau pattoto ngeke longo rea na ngeke kinpataea giareame. Minmina nae Nutu ke la tungnge alang e soali raumana te ri. Ba alang e soali laeala ke la bolinglaunga raumana nga alanga e soali orae ragau pattoto onre sane ke kuma minmina.” ");
INSERT INTO mee_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ka inae Iesus palomatantane ragau ngallo nga tempel, na i ke kele ra kilipukana ineke pullulue lollokanna nga malle e nga tungnga rea te Nutu. ");
INSERT INTO mee_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ba i ke kele avale a sillolo ora natale matepatalia ine pullulue lollokanna lua ra kopa onreke sisina bole. ");
INSERT INTO mee_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nae Iesus ke role ka barangalele ra kanna roma, “Iau nga role kamiau ka kaomannmannangana roma, avale laeala a sillolo ora natale matepatalia ke pullue lollokanna papatu raumana nga ragau nginngina ra kilipukana. ");
INSERT INTO mee_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Iau ka role minmina kurumea, ri ka kanrea lollokanna papatu ba keke tunge palu mana, ava kanrea lollokanna papatu keke momo tale. Ava avale laeala ka kanna lollokanna tutuna nga koling kaning ba ke pullue ri kinung.” ");
INSERT INTO mee_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Na barangalele rae Iesus kanna palu keke kele lollo reke pepe ba oru nga ragau ke tungu rea te Nutu ta ri kumangng ka bale ra tempel ki. Na keke umma ta pangamologa ta bale laeala kelangana e pe raumana. ");
INSERT INTO mee_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Avae Iesus ke role kerea roma, “Nga kae te e ngarume, na oru kokorai ra miau ka kela rea ka matamiau kanname ke sane ke la momong basema inaka kela rea sonrau. Ba ka sana la lollo te nge kenopai nga tetoto. Keke la gulaengapisigi ki kinung lagape.” ");
INSERT INTO mee_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Na barangalele ra kanna keke ballage roma, “Apangalomatanakana, oru nginngina ramo role tao pala keke la leleng nga pia? Ba mangng ka la kelange killa a taru, na nga lomangngmatana roma oru nginngina keke tatu kokoro?” ");
INSERT INTO mee_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nae Iesus ke ala rea roma, “Ngaka ella miau masi ta baina agau te sane nge taoamuga soali kamiau. Iau ka role minmina kurumea, ragau papatu keke la ri atung nga giau, na keke la kumangng ta roleng roma, ‘Ka iau ae Karais.’ Ba keke la roleng roma, ‘Kae e nga Karais atungngana ke lele kokoro.’ Ava miau sana ngaka loakurume rea. ");
INSERT INTO mee_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ba nga ina miau ngaka longe pangamologa re ta baling reke bollalau, ba ta ragau ra sana siareape ka ragau reke kelapatali te ri, na sana ngaka matau. Ka kaomannmannangana, oru nginngina keke la leleng, ava ka sana la mirana roma momong gunguna ke lele kokoro.” ");
INSERT INTO mee_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Bae Iesus ke role kerea bole roma, “Galiau te ke la loanga ta baling kala nga galiau tetoto, ba re nga kelangpatali te keke la loanga ta baling kala nga re nga kelangpatali tetoto. ");
INSERT INTO mee_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ba ka la oru giongana tatana reke bollau, ba osangana reke bollalau. Ba soaling matantana reke bollalau keke la baingasoalinge ragau, na papatu keke la mateng nga iname bole. Ba ragau keke la kelange oru reke bavai ka mataunga, ba keke la magionga ka kelangareangana ka oru reke la leleng nga tava. ");
INSERT INTO mee_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ava pala ta oru nginngina leleng, na ragau keke la ri launga miau ra barangalele ra kanau, ba keke la kumangng ka bainga reke sosoali te miau. Ri keke la loanga ka miau ta kalingnana nga sinagogme, ba keke la pulingi miau nga pulangkala. Ba muni, keke la pangamaisi miau nga kelangpatalime ba nga gavaname ragureame kurumea loangakurume ngamiaungana kau. ");
INSERT INTO mee_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ri keke la kumangng minmina ta baina miau ngaka turupote lopatokona ae miau te iau te ri. ");
INSERT INTO mee_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ava pala ta miau loanga ta kalingnana, na sana nga lomiautangtang raumana ta pangamologa re nga maisingtotokalange balinglaga nga kanrea. Ke sa. ");
INSERT INTO mee_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Iau ka role minmina kurumea, iau ka la tungnge pangamologa ba lomatana reke pepe raumana te miau, na reke balvali miau ka pangamologame sana nga ginggingngarea ta ri maisingkala miau. Ba ri sana nga ginggingngarea ta malainga ka pangamologa nga kanmiau. ");
INSERT INTO mee_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Na tamamiau ba namiau memena, ba kolingamiau memena, ba raka miau memena, ba balingamiau memena keke la ulongo miau nga reke bai ta baingasoaling miau kamareame. Ba keke la samungpununge palu nge miau. ");
INSERT INTO mee_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ba ragau kinung keke la baingaꞌiu kamiau kurumea, ka miau ra ragau rae iau. ");
INSERT INTO mee_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ava miau ka la momong masi ba ka sana la gilimiau bulvunna te la saningrea. ");
INSERT INTO mee_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Miau ngaka maisi gingging nga maenangme nga baina miau ngaka rave mauling e momo passavele.” ");
INSERT INTO mee_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nga kae laeala ina miau ngaka kele galiau re nga baling ine ngeke maistotokale Ierusalem, na miau nga lomiaumatana roma, maga kunna laekia soalingana ke lele kokoro. ");
INSERT INTO mee_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na ragau reke momo ngae Iurea nga kae laeala ngeke ka ta kapangngme. Ba ragau reke momo ngallo nga maga kunna laekia ae Ierusalem ngeke kaꞌe. Ba ragau reke momo nga iname reke kokoro ngae Ierusalem sane ngeke taopallu lakallo bole. ");
INSERT INTO mee_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Iau ka role minmina kurumea, kae nginngina ka la ri ra kae re nga alanga nga baina pangamologame kinung ra ri ke pa rea pala nga Lau Ae Nutu Kanna ngeke lele mannangana. ");
INSERT INTO mee_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ba kae nginngina keke la ri isongpa raumana ta ravale ra siarea ba ta ravale reke pasisiue goe rae ri ra lagalaga. Iau ka role minmina kurumea, maenang reke bollalau keke la leleng nga mogalo laekia, bae Nutu alangana ke la pungapai nga ragau reke momo ngia. ");
INSERT INTO mee_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Minmina na reke baisolali rea keke la telengpununge palu ka resallame. Ba keke la launge palu, na keke la loanga kerea ta maga re kalaoveka nga iname kinung. Na Ierusalem ke la momong nga ragau ra sana ri ra Iura kamarea ta nge lele nga kae laeala a Nutu pulia ta i ronga ka momongareangana nga inaekia.” ");
INSERT INTO mee_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Nae Iesus ke role kerea roma, “Nga kae nginngina, na killame keke la leleng nga kae, ba nga inna, ba nga matame bole. Ba nga mogalo laekia e ngape pelau ke la soaling raumana ka miniuame reke bollalau, na ragau keke la mataunga ka loreapalilli ngareangana. ");
INSERT INTO mee_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ba mata reke momo ngailu nga tava ngeke matagtaga, na ragau keke la mataunga ka matenglala ngareame nga ineke momalle oru ngeke lele nga iname kinung nga mogalo laekia e ngape. ");
INSERT INTO mee_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Minmina na ragau keke la kelange Agau Tuna ine la atung ngallo nga mumuka ka gingginga tane bollau ba olamana e toakala. ");
INSERT INTO mee_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na nga ina oru nginngina ngeke lele, na miau ngaka maisi ba ngaka kelapatae kurumea, kae a Nutu la ravungulele miau ke lele kokoro.” ");
INSERT INTO mee_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ba i ke role kerea ka pangateningkala laekia roma, “Ngaka kele bega a pik ba bega pattoto bole. ");
INSERT INTO mee_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nga ina bega nginngina laureame ngeke lelepau, na nga lomiaumatana roma, kaepa ke lele kokoro. ");
INSERT INTO mee_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Minmina mana, na nga ina miau ngaka kele killa nginngina nga tava ba mogalo ama role tao, na nga kelapatokona roma, Nutu kelangpatalingana ke lele kokoro. ");
INSERT INTO mee_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Iau nga role kamiau ka kaomannmannangana roma, ragau reke momomauli sonrau keke la momongmauli tale, na keke la kelange oru nginngina kinung ama iau role tao lelengarea. ");
INSERT INTO mee_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tava ba mogalo keke la saningrea, ava pangamologa ra kanau ke sane ke la saningrea. ");
INSERT INTO mee_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ava miau ngaka ella miau masi. Ke sane pe ngaroma miau ngaka tungtunge lomiaumatenganame raumana ta bainga re nga inunge inung reke gingging, ba bainge kaning reke bollau, ba bainga e nga loangakurumenge oru reke momo nga mogalo laekia e ngape. Ngaroma miau ngaka kuma minmina, na kae laeala ae iau la leleng ngia ke la launga miau basema mata te. ");
INSERT INTO mee_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ta kae laeala ke la leleng nga ragau karolu re nga iname kinung nga mogalo laekia e ngape. ");
INSERT INTO mee_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Minmina nae miau ngaka ella masi te miau ka kaeme kinung. Ba ngaka kavkava ta miau maisingginggingkale maenangme ineke la leleng nge miau, nga baina miau sana nga balenglenge miau nga kae laeala e ngarume nga inae Agau Tuna la kalingnanange ragau kinung.” ");
INSERT INTO mee_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ka kae kenakena, nae Iesus ke palomatantane ragau ngallo nga tempel. Ava ka laiome, na i ke lelemalaga ba ke momo ka rigo nga kapoponga eke patoe ka Kapoponga Nga Bega Ra Oliv. ");
INSERT INTO mee_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ba ragau karolu keke tatu ka sinro luluname te i ta baina ri longnge pangamologangana ngallo nga tempel. ");
INSERT INTO mee_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na kae re nga kaning e bollau reke pato rea ka “Kaning E Bollau E Nga Berete A Sana Kana Isi” ba oreke pato rea ka “Paska” keke lele kokoro. ");
INSERT INTO mee_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na re kapunu nga pirisme ba ra pangalomatanakana nga bangapagame keke matautaue ragau, minmina na keke tangtange pamau matana te nga baina ngeke sapune Iesus. Ba ri ka sana omorea ta agau te nga lonamatana kia. ");
INSERT INTO mee_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nae Satan ke lupage Iuras a giana tetoto nge Iskariot, a i a agau te nga Pana Tangulelu Ba Lua. ");
INSERT INTO mee_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ka bainae Iuras ke loa, na ke pamologa kala nga re kapunu nga pirisme ba re kapunu nga ra kurtalingling nga tempel. Keke pamolloga ta Iuras pulingana kae Iesus ta ri baingasoalinge. ");
INSERT INTO mee_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ba ra nginngina ka loreasereng raumana ta pangamologangana laeala, na keke ngata ta ri kolinge Iuras ka lollokanna. ");
INSERT INTO mee_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Minmina nae Iuras ke ngatakale pangamologangarea, na ke kelkela ta kalingpa ka pamau te ta i ulonge Iesus nga kamareame. Ba i ke ella ta kae te ta baina ri ngeke laue Iesus nga ina maluame sane ngeke momo kala nge i. ");
INSERT INTO mee_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na kae laeala ore nga balinge sipsip goekia e nga kaninge ka Paska ke tatu. Ba kae laeala ke momo ngaliua nga kae nginngina reke pato rea ka Kaning E Bollau E Nga Berete A Sana Kana Isi. ");
INSERT INTO mee_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Minmina nae Iesus ke baꞌe Pita bae Ion ka rolengana roma, “Ngaka loa, na ngaka kalitupe kaning ae ita ore nga Paska.” ");
INSERT INTO mee_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Na keke ballage roma, “Ita kaka la kumangng kia nga ine ngaetai?” ");
INSERT INTO mee_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nae Iesus ke ala rea roma, “Ina ngaka taolu tae Ierusalem, na onemea ka la kelange apanung te ore kukure me bagana te. Na miau ngaka loakurumea ta bale a i la taongalu ngia. ");
INSERT INTO mee_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ba ngaka role ka bale laeala tamana roma, ‘Apangalomatanakana ke ballaga roma, bale bilingana ore nga i kala nga barangalele ra kanna kaninge kaning e nga Paska ngia, ka i aetai?’ ");
INSERT INTO mee_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Na bale tamana laeala ke la pangapanau miau ka bale bilingana e momo ngailu a kana ka oru nga tarang ta kaning. Minmina na ngaka kalitupe kaning nga inaeala.” ");
INSERT INTO mee_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Minmina na ri pana lua ke kutapu eke loa, na keke kalipa ka oru rae Iesus role kerea tao base ma ina i role. Ka baina ri keke kalitupe kaning e nga Paska. ");
INSERT INTO mee_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Na ka ina kae matana e nga kaninge kaning e nga Paska ke lele, nae Iesus ke tara nga mallena nga pala kala nga aposel rae i. ");
INSERT INTO mee_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Na i ke role kerea roma, “Ka matea raumana ta iau kaninge kaning e nga Paska laekia kala nge miau pala ta iau ravunge miralali e nga mateng. ");
INSERT INTO mee_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ta iau nga role kamiau roma, iau ka sana la kaninge kaning e nga Paska laekia kala nge miau muni ta nge lele nga kae laeala e ngarume nga ina Paska mirana mannangana nge lele nga Nutu kelangpatalingana.” ");
INSERT INTO mee_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Minmina na i ke rave gato e ponu ka uain, na ke kalapage Nutu ba ke role kerea roma, “Ngaka palitunge paka miau, na ngaka inue. ");
INSERT INTO mee_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ta iau nga role kamiau roma, iau ka sana la inunge uain laekia muni ta nge lele nga inae Nutu kelangpatalingana nge lele ngarume.” ");
INSERT INTO mee_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Na i ke rave beret inte, na ke kalapage Nutu ba ke regipale. Na ke tunge te ri ka rolengana kerea roma, “Mirau ikia, iau ka la tungnge te Nutu ta pangapenge ragau kia. Nga kae nge ngarume, na miau ngaka kuma minakai ka beret ta baina miau nga lomiaugaliu muni te iau.” ");
INSERT INTO mee_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ngarume nga kaning, na i ke rave gato ame tunge te ri pala. Na ke kuma ma ine kuma ka beret pala ka rolengana roma, “Uain nga gato laekolong ka i a piunga ba bonga ora pau a Nutu la kumangng kia ka totogu. I ke la kengalingia totogu ta kalaungapaga miau. ");
INSERT INTO mee_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ava agau laeala ore la ulongo iau nga reke la baingasoali iau kamareame ke momo kala nge iau nga pala laekia. ");
INSERT INTO mee_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Agau Tuna ke la mateng kurumea pangamologa a Nutu rolea pala, ava oru reke sosoali raumana keke la leleng nga agau laeala e ule nga reke bai ta baingasoalinge kamareame.” ");
INSERT INTO mee_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ka inae Iesus role minmina, na ri keke paturu ta palingbalinglaga rea roma, “Tai e nge ita ke la kumangng ka bainga laeala?” ");
INSERT INTO mee_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na barangalele rae Iesus kanna keke paturu ta ri palingvaling ka balinglagangarea roma, “Tai e nge ita ka i e kapunu?” ");
INSERT INTO mee_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nae Iesus ke role kerea roma, “Ragau re kapunu nga ra sana ri ra Iura keke umma ta bongatalala rea ka kaoreaginapitangana kerea ba keke rorole roma, ‘Mangng kasikemangng ka kamangng ka ginggingame kinung.’ ");
INSERT INTO mee_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ava miau sana ngaka bai minmina. Ke sa. Re kapunu nge miau ngeke lele ma ri ra reke sisina, base ragoeme. Ba agau e taoamuga kapunu nge miau nge lele ma i a akumangngatulu ae miau. ");
INSERT INTO mee_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ka ina ragau ke tara ta kaning ba ra kumangngatulu keke momo ta tuvang karea kaning, na tai e nge ri giana ke ngailu? Agau e tara ta kaning, o agau a i a akumangngatulu? Miau kaka roma, agau e tara ta kaning nanguni. Ava iau ka momo kala nge miau ma agau akumangngatulu. ");
INSERT INTO mee_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ka miau ra ragau reke momopita kala nge iau ina maenangme ke ravu iau. ");
INSERT INTO mee_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tamau ke tunge kelangpatali te te iau minmina na iau ka tunge te miau, ");
INSERT INTO mee_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","nga baina miau ngaka tara ta kaning ba inung nga pala laeala ae iau ngallo nga kelangapatalingau. Ba miau kaka la tarang nga tarang re nga kelangpatali, na miau kaka la kelangpatali ta galiau re ngae Israel ra ri tangulelu ba lua.” ");
INSERT INTO mee_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nae Iesus ke role kae Pita roma, “Saimon, Saimon, one ngo longo masi. Satan ke ballaga ta iau ngatangng ta i avanga miau basema agau ine nge lulumatagtage pailli kanname na mamaureame ngeke pupu balakala. ");
INSERT INTO mee_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ava iau ka kava te Nutu tapu ta i kalaunga one ta baina lopatokona ae one nga manenasa ronga. Ba nga ino one ngo kampiliu muni, na ngo paginggingia kolingang memena.” ");
INSERT INTO mee_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Avae Pita ke ale roma, “Avolau, iau ka momo ta loanga ta pulangkala ba ta mateng kala nge one.” ");
INSERT INTO mee_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nae Iesus ke ale ka rolengana kia roma, “Pala ta kukulega toangako sonrau, na one ko la kaulingkala iau pa mologi roma, ona sana longmatana kau.” ");
INSERT INTO mee_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nae Iesus ke ballage barangalele ra kanna roma, “Ka kae laeala a iau ba miau pala ina miau ka sana paue bising e sina o ne bollau ba ka sana ka paue kesingsilagi palu, na miau kaka moro ta otte, o ke sa?” Na keke ale roma, “Ke sa. Mangng ka sana moro ta otte.” ");
INSERT INTO mee_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Na i ke role kerea roma, “Ava sonrau agau a kanna ka bising e sina o ne bollau na nge paue. Ba ngaroma agau a sana kanna resalla, na nge ba ka lungapaga ae i ore ngapotu na nge kolia kanna resalla te. ");
INSERT INTO mee_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ta iau nga role kamiau roma, pangamologa laeala reke paꞌe pala nga Lau Ae Nutu Kanna ore role roma: ‘Keke pulia kala nga ragau reke longosa ta bangapagame’ ke la leleng nge iau. Ba orume kinung reke pa rea te iau pala nga Lau Ae Nutu Kanna keke la leleng ka kaomannmannangana.” ");
INSERT INTO mee_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Minmina na barangalele ra kanna keke role kia roma, “Avolau, kela nasong, ka kanmangng ka resallame ka ri lua rikorai.” Nae Iesus ke role kerea roma, “Ka malo!” ");
INSERT INTO mee_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nae Iesus kala nga barangalele ra kanna keke lelemalaga lagapotu ngae Ierusalem, na keke loa ta Kapoponga Nga Bega Ra Oliv kurumea baingareame re ka kaeme. ");
INSERT INTO mee_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ba ka ine lele nga inaeala, na i ke role kerea roma, “Ngaka kavkava te Nutu, ba ngaka ballage ta i sane nge ulo miau nga avangme.” ");
INSERT INTO mee_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Na i ke loa lagatauga isura nge ri ma agau tamalingana ka lollo, na ke parovanu ba ke kava te Nutu roma, ");
INSERT INTO mee_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tamau, ngaroma nga longangana, na ngo ravupatali ka gato laekia a miralali nge iau. Ava ka sana matea ta one kumangng kurumea laungana. Ke sa. Ka matea ta one kumangng kurumea longangana.” ");
INSERT INTO mee_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Na anggelo te e pa nga Nutu mallena nga tava ke lele ba ke paginggingia. ");
INSERT INTO mee_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ba i ke kanimaimaia maenang e bollau ngallo nge i, minmina na ke kavkava kaligi muni. Ba menanakia a sinna ma toto ke pupu lagape ta mogalo. ");
INSERT INTO mee_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ka ine rongo ka kavangana ba ke sigipaga, na ke galiu ta barangalele ra kanna. Ava ka ine lele nge ri, na keke kenrarau ka loreataningana. ");
INSERT INTO mee_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Minmina na i ke role kerea roma, “Kaka meimia aka kenrarau? Ka sigipaga, na ngaka kava te Nutu ta baina miau sana ngaka lele nga avangme.” ");
INSERT INTO mee_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ka ine pamolloga ta barangalele ra kanna tale, na malua e bollau ke lele nge ri. Ba agau laeala eke patoe kae Iuras, a i a te e nga Pana Tangulelu Ba Lua, ke taoamugmuga kerea. Na i ke loa te Iesus ta tagungkao kia. ");
INSERT INTO mee_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Avae Iesus ke ballage roma, “Iuras, ko la ulonge Agau Tuna nga reke bai ta baingasoalinge kamareame ka tagungkaongang kia ae?” ");
INSERT INTO mee_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Na ka ina barangalele rae Iesus kanna loreamatana roma, ra nginngina keke la launge Iesus, na keke ballage roma, “Avolau, ko matea ta mangnga telenge rea ka resalla kakai?” ");
INSERT INTO mee_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Minmina na te e nge ri ke magala ka resalla nga akumangngatulu ora piris e kapunu kanna. Ba ke saꞌvatote longana nga bavana e pe. ");
INSERT INTO mee_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Avae Iesus ke ala rea roma, “Sana ngaka kuma ka bainga laekolong!” Na i ke kali ka agau laeala longana ba ke papea muni. ");
INSERT INTO mee_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nae Iesus ke ballage re kapunu nga pirisme, ba re kapunu nga kurtalingling nga tempel, ba Iurame ravollalaukerea memena ineke atu ta launge roma, “Kaka meimia aka atu ta ravungu iau ka resallame ba butume? Kaka roma iau a ragolongkana kelangpatali ae ri ae? ");
INSERT INTO mee_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ka kaeme kinung, na iau ka momo kala nge miau nga malle re nga tempel, ba miau ka sana ka kalaꞌe kamamiaume ta launga iau. Ava kae laekia ba osuguna ginggingngana ka onrae miau.” ");
INSERT INTO mee_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nae keke laue Iesus, ba keke loa kia lakallo ta bale ae piris e kapunu. Bae Pita ke lolakurume rea bole, ava ke momo ngatauga nge ri isura. ");
INSERT INTO mee_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Na kurtalinglingme keke patue sia ngaliua nga malle e ngallo nga savanau ore nga bale laeala, ba keke tattarataliue. Bae Pita ke tara kala nge ri bole. ");
INSERT INTO mee_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Na malaui te akumangngatulu ke kele Pita ine tattara nga sia lamana, na ke kelananne ba ke role roma, “Pala na agau laekolong ke momo kala nge Iesus bole.” ");
INSERT INTO mee_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Avae Pita ke kaulikala ka rolengana roma, “Avale laekolong, iau ka sana laumatana kia.” ");
INSERT INTO mee_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ngarume muni, na agau tetoto ke kela pakae Pita ba ke role kia roma, “One ko loakurumea Iesus bole.” Avae Pita ke ale roma, “Ke sa!” ");
INSERT INTO mee_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ka panna isura ngarume, na agau tetoto ke role ka kaona ginangana roma, “Ka kaomanna, aekia ke momo kala nge Iesus bole ta ka i a agau ore ngae Galili.” ");
INSERT INTO mee_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nae Pita ke ale roma, “Agau laekolong, iau ka sana laumatana ka taru a one rorole te!” Ka ine pamolloga minmina tale, na kukulega te ke toako. ");
INSERT INTO mee_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nae Avolau ke kampiliu ba ke kela tupu te Pita. Nae Pita ka lonagaliu ta pangamologa ae Avolau kanna ine role kia pala roma: “Pala ta kukulega toangako sonrau, na one ko la kaulingkala iau pa mologi roma ona sana longmatana kau.” ");
INSERT INTO mee_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nae Pita ke lelemalaga lagapotu ba ke tani raumana. ");
INSERT INTO mee_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na ra kurtalingling keke paturu ta rolengpagalising kae Iesus ba balinge. ");
INSERT INTO mee_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ba keke kangkale matana kanname ka malo inte, na keke balaglage roma, “Onto bai ma agau e toe Nutu kaona! Tai ke bali one?” ");
INSERT INTO mee_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ba keke rorolebainga kia ka pangamologa matantana roma i a agau e sane pe. ");
INSERT INTO mee_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ka ina kae sigipaipatae, nae Iurame ravollalaukerea memena keke katukala kinung. Re kapunu nga pirisme keke momo nga katungkala laeala. Ba ragau ra lomatanakana ka bangapagame keke momo bole. Na ra kurtalingling keke loa kae Iesus ta pangamaisinge ngamuga nga ragureame. ");
INSERT INTO mee_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Na keke role kia roma, “Ngaroma one ae Mesaia, na ngo turu te mangng.” Nae Iesus ke ala rea roma, “Ngaroma nga role kamiau, na sana la lomiaupatokona te iau. ");
INSERT INTO mee_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ba ngaroma nga ballaga miau, na ka sana ka la alanga iau bole. ");
INSERT INTO mee_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ava ngarume nga kae laekia, nae Agau Tuna ke la tarang nga Nutu a kana ka ginggingame kinung kamana e pe.” ");
INSERT INTO mee_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Na ri karolu keke ballage roma, “Minmina na ko roma, Nutu ka tuna nge one ae?” Na i ke ala rea roma, “Iii, ka iau ae Nutu Tuna.” ");
INSERT INTO mee_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Na keke role roma, “Ke meimia, na ita kaka sissilia ragau palu muni ta ri turunge agau laekia bainganame? Ita muni kaka longotape pangamologa ine lelemalaga nga kaona.” ");
INSERT INTO mee_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Na ra nginngina kinung keke sigipaga ba keke loa kae Iesus ta pangamaisinge nge Pilatus raguna. ");
INSERT INTO mee_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ba keke paturu ta turungpaga kana ka pangamologangarea roma, “Mangng ka kelapa ka agau laekia ine amva ta taongamugasoali ka ragau rae mangng. Ke roma ta mangng manemangngsa tungnge lollokanna ta gavaman e ngae Rom. Ba ke roma i ae Karais a i a kelangpatali te.” ");
INSERT INTO mee_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ka bainae Pilatus ke ballage Iesus roma, “Ka one a kelangpatali ae Iurame, o ke sa?” Nae Iesus ke ale roma, “Ke base ino role.” ");
INSERT INTO mee_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nae Pilatus ke role ka re kapunu nga pirisme kala nga maluame roma, “Iau ka sana kalipa ka otte e soali nga agau laekia.” ");
INSERT INTO mee_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ava ri keke role kaligi muni roma, “Pangalomatanangana ke baipage iu ngaliua nga ragau re ngae Iurea. Ke pature ngae Galili ta ke atu kia bavakena ta inaekia.” ");
INSERT INTO mee_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Na ka inae Pilatus longe pangamologa laeala, na i ke ballaga rea roma, “Aekia ka i e ngae Galili ae?” ");
INSERT INTO mee_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na ka inae Pilatus lonamatana roma, Iesus ka i e ngae Galili nga inae Eroto kelapatali ngia, na ke baꞌe Iesus te Eroto. Ba ka kae laeala, nae Eroto ke mommo ngae Ierusalem bole. ");
INSERT INTO mee_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nae Eroto ka lonasereng raumana ine kele Iesus ta i ke momalla ta kelange ka panna tana kena tapu. Bae Eroto ke longe pangamologa papatu ta Iesus kumangnganame. Minmina nae i ke bai ta kelange Iesus ine nge kumkuma ka oru palu reke bollau. ");
INSERT INTO mee_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Na i ke balaglage Iesus ka balinglaga papatu, avae Iesus ke sane ala rea. ");
INSERT INTO mee_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ba re kapunu nga pirisme kala nga ra pangalomatanakana nga bangapagame keke maisi, na keke turupagpaga kana ka pangamologangarea bole. ");
INSERT INTO mee_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nae Eroto kala nga galiau rae i re nga baling keke bai kae Iesus ma i a agau e sane pe. Ba keke rolepagalising kia ka palungapagangarea kia ka lungapaga matana a kelangpatalime. Ngarume na keke bagaliue te Pilatus muni. ");
INSERT INTO mee_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ba pala nae Eroto riluae Pilatus keke palilegesolali rea, ava ka kae laeala mana na ri pana lua keke paturu ta palingkavanga rea ka koli. ");
INSERT INTO mee_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nae Pilatus ke kiukinunge re kapunu nga pirisme kala nga Iurame ravollalaukerea memena. ");
INSERT INTO mee_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Na ke role kerea roma, “Miau kaka atu ka agau laekia te iau ba kaka roma i e amva ta taongamugasoali ka ragau rae miau. Minmina na iau ka kalinane, ava ka sana kalipa ka turungpaga ngamiaume purea. ");
INSERT INTO mee_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Bae Eroto ke sane kalipa ka oru nginngina bole, na ke bagaliue muni te mangng. Ngaka kele, i ke sane baia otte ta ita balinge na nge mate. ");
INSERT INTO mee_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Minmina na iau ka la bangapagange ragau rae iau ta ri sapinge, na nga ule nge loa.”  ");
INSERT INTO mee_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Na ka pesingmatana re pala nga kaning laeala e bollau, na i ke kumkuma kurumea baingana te na ke ulomalaglage apulangkala kena te ri. ");
INSERT INTO mee_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ava ri keke relikinung roma, “Ngaka sapune! Ngaka ulomalage Barabas te mangng!” ");
INSERT INTO mee_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Na ka kae te pala, na ragau palu ka sana siareakena ka re kapunu nga gavaman e ngae Rom, minmina na ri keke bai ka baling e bollau ngallo nga maga kunna laeala e bollau. Ba te e nge ri a giana nge Barabas ke sapune agau te nga baling laeala. Minmina na keke tamalilu kia lakallo ta pulangkala.) ");
INSERT INTO mee_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nae Pilatus ke bai ta ulongmalagange Iesus, minmina na i ke role kerea base ma ine role kerea pala. ");
INSERT INTO mee_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ava ri keke rereli kaligi roma, “Ngo katupite nga maiskovu! Ngo katupite nga maiskovu!” ");
INSERT INTO mee_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ka bainae Pilatus ke role kerea ka rolengana a mologi roma, “Ta ke meimia? Apanung laekia ke kuma ka bainga a taru e soali? Iau ka sana kalipa ka otte a i bai kia ta ita balinge na nge mate. Ava iau ka la bangapagange ragau rae iau ta ri sapinge, na nga ule nge loa.” ");
INSERT INTO mee_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ava keke gingging raumana ka relingarea kaligi ta Pilatus nge katupite Iesus nga maiskovu. Na kaoreaginangarea ke rave ora ri ke matea. ");
INSERT INTO mee_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ka bainae Pilatus ke loakurumea loreangana. ");
INSERT INTO mee_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Na ke ulomalage agau laeala ameke ballaga te. Ka i a agau e sapune agau be bali nga maga kunna, na keke ullue nga pulangkala. Ava i ke tunge Iesus ta kamarea ta ri kumangng kia kurumea loreangana. ");
INSERT INTO mee_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ka ina ra balingkana ke tatao eke lola kae Iesus, na keke pagiu paka agau te ore ngae Sairin a giana nge Saimon ine pa nga ine ngapotu ngae Ierusalem ba ke taolulu lakallo ta maga kunna. Na keke kampite, ba keke patoloea ka maiskovu. Na keke bapage ta i paunge kurumea Iesus. ");
INSERT INTO mee_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na ragau papatu keke lolakurume rea, ba ravale palu nge ri keke tantania Iesus kaligi. ");
INSERT INTO mee_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ka bainae Iesus ke kampiliu te ri na ke role kerea roma, “Ravale re ngae Ierusalem, sana ngaka tani iau. Ava miau ngaka tani miau ba goe rae miau. ");
INSERT INTO mee_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Iau ka role minmina kurumea, ngarume na kaeme keke la leleng nga ina miau ka la roleng roma, ‘Ravale reke sumpi, ba ravale re sane ke toapisigia goe, ba ravale re sane ke pasiu goe nga loreasereng.’ ");
INSERT INTO mee_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ka kae nginngina, na ragau “keke la roleng ka kapangngame roma, ‘Ngaka pupupai nge mangng!’ Ba keke la roleng ka kapopongame roma, ‘Ngaka gasipita mangnga!’” ");
INSERT INTO mee_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Ngaka kele, ri keke kumasoali kau a agau a sana baia bainga te e soali. Minmina na keke la maingamia ka ragau ra baingareame ke sosoali?” ");
INSERT INTO mee_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Na ra balingkana keke loa ka ragau lua reke longosa ta gavaman ta baina ngeke loa kerea ta ri mateng kala nge Iesus. ");
INSERT INTO mee_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ka ineke lele nga malle te oreke patoe kae Agau Gilina Bagana, na keke katupite Iesus nga maiskovu. Ba keke katupite pana lua nginngina reke longosa ta gavaman nga maiskovume bole. Keke katupite te nga maiskovu e momo nga Iesus kamana e pe, ba keke katupite te nga maiskovu nga Iesus kamana a laeva. ");
INSERT INTO mee_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nae Iesus ke role roma, “Tamau, ngo osurure baingarea reke soali ta ri ka sana loreamatana ka ora ri ke kumkuma kia.” Ba ragau ra balingkana keke kintoto ta tavoanga ka lungapaga rae i ngaliua nge ri. ");
INSERT INTO mee_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Na ragau keke maisinsi eke elle. Ba re kapunu ngae Iurame keke rorolepagabainga kia ka rolengarea roma, “One ko ravulelea ragau pattoto. Na ngaroma one ae Karais a agau ae Nutu tore ka kaomannmannangana, na inta one ngo ravulele one muni.” ");
INSERT INTO mee_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ba ra balingkana keke rorolepagalising kia bole. Na keke kalapataea uain ore mamaoga te i ka rolengpagalising kia. ");
INSERT INTO mee_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ba keke role kia roma, “Ngaroma one a agau e kapunu ngae Iurame, na inta one ngo ravulele one muni.” ");
INSERT INTO mee_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na keke katupite turunglomatana te nga maiskovu ngailu nga Iesus kunna ore role roma: ");
INSERT INTO mee_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Na te nge ri pana lua reke longosa ta gavaman eke katupite nga maiskovu kokoro te Iesus ke patoe pangamologa reke sosoali te Iesus roma, “Ka one ae Karais ae? Into ravulele ita!” ");
INSERT INTO mee_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ava tetoto nge ri pana lua reke longosa ta gavaman ke parule ka balinglagangana kia roma, “Ko sano mataue Nutu kurumea ita kinung kaka rarave alanga matana kena mana ae? ");
INSERT INTO mee_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Itaua kaka rave alanga kurumea baingarame re sosoali, ava aekia ke sana kuma ka bainga te e soali.” ");
INSERT INTO mee_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Na i ke role kae Iesus roma, “Iesus, nga longgaliu te iau nga ino ngo lele nga kelangpatalingang ngarume.” ");
INSERT INTO mee_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nae Iesus ke role kia roma, “Iau nga role kone ka kaomannmannangana roma, sonrau na one ko la momong kala nge iau nga malle orae ragau reke tupu.” ");
INSERT INTO mee_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ba ollaeala ke lele ka kae matana basema pula. Na osuguna ke gasipite inaeala bavakena ta ke lele nga kae matana a mologi ka laio. ");
INSERT INTO mee_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ka osuguna kurumea, kae ka sana lamana. Ba malo laeala e bollau eke kone ma i a lengakala ngallo nga tempel ke marae ka rina lua. ");
INSERT INTO mee_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nae Iesus ke kiu kaligi roma, “Tamau, nga ulo iau nga kamang.” Ka ine role minmina tapu, na i ke mate. ");
INSERT INTO mee_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Na ka ina agau laeala e kapunu nga ra balingkana kele ollaeala e lele, na i ke kalapage Nutu ka rolengana roma, “Ka kaomannmannangana, aekia ke sane baia otte e soali ta ri samungpununge.” ");
INSERT INTO mee_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ba ka ina ragau reke katukala kinung ta kelange ragau katungpitangarea nga maiskovu ke kele ollaeala e lele, na keke galiu ta maga nga ri ba keke tunte mauturea ka taning ngareangana. ");
INSERT INTO mee_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na ragau ra loreamatana kae Iesus, kala nga ravale reke tatao kurumea ka kae re pala, keke meisinsi ngatauga isuru ba keke elle oru nginngina reke lele. ");
INSERT INTO mee_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Na agau a giana nge Iosep ke momo. Ka i a agau te nga re kapunu ngae Iurame, ba ka i a agau ora baingana pe. ");
INSERT INTO mee_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ba agau laeala ke sane ngatakala rea ineke bai ta samungpununge Iesus. Ba ka i e nga maga kunna te a giana ngae Arimatea ngallo ngae Iurea. Ba bole agau laeala ke momalle Nutu kelangpatalingana lelengana. ");
INSERT INTO mee_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Minmina na i ke loa te Pilatus, na ke palonge ta i ravunge Iesus lavusakia. ");
INSERT INTO mee_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Na ke ravupisigia lagape nga maiskovu, ba ke lulupite ka malo. Na ke pulluia lakallo nga baveng ore nga talunge agau e mate ngia eke kuma kia lakallo nga lollo. Ka i a baveng ore sane ke pulluia lavusa te ngia pala. ");
INSERT INTO mee_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ba kae laeala ka i a kae orae Iurame nga kalingtupunge oru re nga kae a Sabat. Ba ka ineke pullue Iesus lavusakia lakallo ta baveng, na kae a Sabat ke kokoro ta i pangaturu. ");
INSERT INTO mee_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na ravale reke atukurumea Iesus ine lelemalaga ngae Galili keke loakurumea Iosep, na keke kele ine pullue Iesus nga baveng. ");
INSERT INTO mee_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Minmina na ri keke galiu ta bale ra ri ke momo ngi ngae Ierusalem, na keke kalitupe oru ra koirea lolo ta baina ngeke saule lavusa ki. Ava keke panna ka kae a Sabat kurumea bangapaga ae Nutu kanna ine role. ");
INSERT INTO mee_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ka sinro luluna ka kae e kapunu nga kumangnga maina laeala, na ravale nginngina keke rave oru nginngina ra koirea lolo ra ri ke kalitupu rea pala. Na keke loa ki ta baveng laeala eke pullue Iesus ngia. ");
INSERT INTO mee_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ba ka ineke lele, na keke kele lollo e bollau eke patapite baveng kaona kia pala ine patalele patali tapu nga baveng kaona. ");
INSERT INTO mee_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Minmina na keke taolu kerea lakallo, ava ke sane ke kalipa kae Iesus lavusakia. ");
INSERT INTO mee_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Na ka ineke maisinsi ka loreapalilli ngarea tale, na pana lua ra karea ka lungapaga ra lamarea ka tongarea kena ma saia ine killama keke pamagioe ravale nginngina ka lelengareangana. ");
INSERT INTO mee_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Na ravale nginngina keke toatula ta mogalo ka mataungarea, ava pana lua nginngina keke role kerea roma, “Ke meimia aka sissilia agau e mauli nga malle a reke mate? ");
INSERT INTO mee_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","I ke sane momo nakai. Ke sa. Ke sigipaga nga mateng tapu. Nga lomiaugaliu ta pangamologangana ine role kamiau ngae Galili roma: ");
INSERT INTO mee_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Iau ae Agau Tuna ka la loanga ta ragau ra baingareame ke sosoali kamareame, ba keke la katungpita iau nga maiskovu. Ava nga kae a mologi na iau ka la sigingpaga nga mateng.’” ");
INSERT INTO mee_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Na ravale nginngina ka loreagaliu ta pangamologa rae Iesus kanna. ");
INSERT INTO mee_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ka ineke galiu nga baveng, na ri keke ture oru nginngina ra ri ke kela rea ta Pana Tangulelu Ba Kena ba ta barangalele rae Iesus kanna reke momo kala nge ri. ");
INSERT INTO mee_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Na nga ravale nginngina reke turu paka aposelme, te ka giana nge Maria Magaralene, ba te ka giana nge Ioana, ba te ka giana nge Maria a i ae Iems naname, ba ka ravale palu keke momo kala nge ri bole. ");
INSERT INTO mee_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ava nga barangalele rae Iesus kanna longareangana ravale nginngina pangamologangarea ka sana mirana. Minmina na ri ka sana loreapatokona ta pangamologa laeala. ");
INSERT INTO mee_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Avae Pita ke sigipaga, na ke pira ta baveng. Na ka ine lele, na ke magolo ka kelangana lakallo; ba ke kele malo oreke lulupite Iesus kia mana ine momo. Minmina na i ke lao ka lonatangtang ngana ka ollaeala e lele. ");
INSERT INTO mee_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ka kae laeala mana, na barangalele lua rae Iesus kanna keke tatao eke lola ta maga te oreke patoe kae Emeus. Ba maga laeala ke momo lagatauga ngae Ierusalem basema pamau bena iname ka ri lima ba lua. ");
INSERT INTO mee_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Na ri pana lua keke palipamolloga te ri ta oru nginngina reke lele. ");
INSERT INTO mee_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ba ka ineke pamolloga beke palirorole kerea tale, nae Iesus muni ke lele nge ri ba ke tao kala nge ri. ");
INSERT INTO mee_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ava otte ke lengetotokale matarea kanname, na ke sane ke kelapatokone. ");
INSERT INTO mee_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Minmina na i ke ballaga rea roma, “Onemea kaka palirorole kamiau ta taru inaka tatao?” Na ri pana lua keke meisi ka ragureasongana, ");
INSERT INTO mee_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","na te a giana kae Kleopas ke ballage Iesus roma, “One kasikeng nge ita ra ragasila ngae Ierusalem ka sana longmatana ka oru nginngina reke lele nga maga kunna laeala ka kae kokorai ae?” ");
INSERT INTO mee_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Na i ke ballaga rea roma, “Tarume?” Na keke ale roma, “Oru nginngina re te Iesus e ngae Nasaret mana. Ka i a agau e toe Nutu kaona. Ba nge Nutu raguna ba ragau ragureame bole i ka kana ka gingginga ngallo nga pangamologanganame ba nga kumangnganame. ");
INSERT INTO mee_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ava re kapunu nga pirisme kala nga re kapunu nge ita keke ule ta kelangapatali e ngae Rom kamana ta baina i nge baꞌe ta i mateng. Ngarume na keke katupite nga maiskovu. ");
INSERT INTO mee_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pala na mangng ka lomangng ngana roma, i la ravunggaliunge re ngae Israel ngae Rom kamana, ava sonrau ka i a kae a mologi ngarume nga oru nginngina lelengareangana. ");
INSERT INTO mee_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ba otte bole, mangng ka magio raumana ka ina ravale palu re nge mangng keke loa ka sinro luluna ta baveng, ");
INSERT INTO mee_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ava ri ke sane ke kali pakae Iesus lavusakia. Minmina na keke galiu na keke turu pakamangng ka ina ri ke kele anggelome. Ba keke role bole roma anggelo nginngina keke turu pakerea roma, Iesus ke momomauli. ");
INSERT INTO mee_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ngarume, na ragau palu nge mangng keke loa ta baveng ba kelangareangana ka tongana kena ma ravaleme turungarea. Ava ri ke sane ke kele Iesus.” ");
INSERT INTO mee_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nae Iesus ke role kerea roma, “Ka miau ra ragau ra sana loreamatana, ba lopatokona ae miau ke baililli ta ravunge oru ra ragau reke toe Nutu kaona pala ke rorole tao. ");
INSERT INTO mee_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Taroma miau ta lomiaupatokona ta pangamologa nginngina, na miau ta lomiaumatana ka pangamologa laeala e role roma, Karais ke la kaningmainge miralali nginngina na ngarume na i ke la lunga lakallo ta mallena a kana ka olamana e toakala.” ");
INSERT INTO mee_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Minmina nae Iesus ke turu pakerea ka pangamologa reke role te i muni ngallo nga Lau Ae Nutu Kanna. Ke paturu nga pangamologa rae Moses kanna ba na nga ragau reke toe Nutu kaona kinung kanrea. ");
INSERT INTO mee_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ka ineke lele kokoro nga maga kunna laeala eke lola te, nae Iesus ke bai ma i la taonga lagamuga tale. ");
INSERT INTO mee_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Minmina na keke pavokale ka kaoreaginangana roma, “Momo kala nge mangng ta ka laio tapu.” Ka baina i ke loakurume rea ta momong kala nge ri. ");
INSERT INTO mee_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ka ine tara kala nge ri nga pala ta kaning, na i ke rave beret ba ke kalapage Nutu. Na ke regipale beret laeala ba ke paturu ta tungnge pakerea. ");
INSERT INTO mee_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ba ka panna laeala mana, na keke kelapatokone ka matarea kanname. Na i ke sanrea mana nga ragurea. ");
INSERT INTO mee_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Minmina na ri pana lua keke palirorole pakerea roma, “Nga loragaliu ta loramannmannangana ka iname tunge pangamologa be tuturu pakita ka Lau Ae Nutu Kanna naꞌina nga pamau.” ");
INSERT INTO mee_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Na keke sigipaga bolvole ba keke galiu tae Ierusalem. Na keke kali pakae Pana Tangulelu Ba Kena kala nga ragau reke momo kala nge ri nga inaeala eke momo ngia. ");
INSERT INTO mee_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Na ra nginngina keke turu pakae ri pana lua roma, “Ka kaomannmannangana, Iesus ke sigipaga nga mateng ba i ke pakosining ka i muni te Saimon!” ");
INSERT INTO mee_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Na ri pana lua keke ture oru e lele nge ri nga pamau e loa tae Emeus ba ka ineke kelapatokone Iesus ine regipale beret. ");
INSERT INTO mee_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ka ineke pamolloga minmina tale, na ka panna laeala mana, nae Iesus muni ke meisi ngaliua nge ri, ba ke role kerea roma, “Momongpengana nge momo kala nge miau.” ");
INSERT INTO mee_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Na keke magio ka mataungarea roma, i a kannu te. ");
INSERT INTO mee_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ka baina i ke role kerea roma, “Ke meimia, na ka lomiausoali ba ka lomiau lualua? ");
INSERT INTO mee_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ngaka kele kamaume ba kaegume. Iau mana ikia! Ngaka kali kau, na nga lomiaumatana roma iau ka mirau ba ka gigu. Ka sana iau a kannu te ta kannu ka sana mirana ba gina.” ");
INSERT INTO mee_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ka ine role kerea minmina, na i ke kosining ka kamaname ba kaename te ri. ");
INSERT INTO mee_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ava ri ka sana loreapatokona ta oru reke kela rea ka matarea kanname tale kurumea, loreaserengngana ba kalinglongarea ke bollau raumana. Minmina na i ke ballaga rea roma, “Ka kamiau otte ikolong ta kaninge?” ");
INSERT INTO mee_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Na keke tunge lea inte oreke tuve tapu te i, ");
INSERT INTO mee_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ba keke kele ine kaninnia nga ragurea. ");
INSERT INTO mee_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Na i ke role kerea roma, “Oru kakarai keke lele basema inama iau role pakamiau pala ka ina iau tatao kala nge miau tale. Iau ama role roma, orume kinung reke pa rea te iau pala nga Bangapaga Rae Moses Kanna, ba nga lau ra ragau reke toe Nutu kaona kanrea, ba nga Baunga Re Nga Kalangapaga keke la leleng basema ineke role.” ");
INSERT INTO mee_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Minmina na i ke paginggingi rea ta baina ri nga loreamatana ka oru ra ragau ke pa rea pala ngallo nga Lau Ae Nutu Kanna. ");
INSERT INTO mee_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ke role kerea roma, “Keke paꞌe pangamologa minakai roma: Karais ke la kaningmainge miralali papatu, na ke la mateng. Ba nga kae a mologi ngarume nga matengana, na i ke la sigingpaga. ");
INSERT INTO mee_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ba Lau Ae Nutu Kanna ke role bole roma, barangalele rae Karais kanna keke la taonga ka Karais ginggingngana, na keke la pulingmalagange pangamologa ta ragau roma, ‘Miau ngaka pulivalakale baingamiau reke sosoali ba ngaka tunge lomiaumatenganame te Nutu, nae Nutu ke la osungrurunge baingamiau reke sosoali.’ Ri ngeke paturu ta pulingmalagange pangamologa laekia ngae Ierusalem pala, ba ngarume na pangamologa laekia nge loa ta ragau nga iname kinung. ");
INSERT INTO mee_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Miau ngaka ture oru nginngina ra miau ka kela rea ta ragau kinung. ");
INSERT INTO mee_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ba iau ka la bange Kannu E Tupu ae Tamau patokala ta i tungnge. Ava ngaka momo mana ngallo ngae Ierusalem ta nge lele nga kae laeala nga inae Kannu E Tupu nge palupaga miau ka gingginga e pa nge Nutu mallena nga tava.” ");
INSERT INTO mee_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ka ine ngalue barangalele ra kanna ta inte e kokoro ta maga kunna ae Betani, na i ke kinpataea kamaname ba ke ballage Nutu ta kavingtulu rea. ");
INSERT INTO mee_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ba ka ine balaglage Nutu tale ta kavingtulu rea, na i ke ka rea ba ke loapatae lakailu ta tava. ");
INSERT INTO mee_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Minmina na ri keke kalapagpage Iesus, na keke galiu tae Ierusalem ka loreaserengngana. ");
INSERT INTO mee_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Na keke lola palimule ta tempel, ba keke kinpataetaea Nutu giana. ");
INSERT INTO mee_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pala nganige, ka ina orume ke sane ke lele tale, nae Pangamologa ke momo. Pangamologa laeala ke momo kala nge Nutu, bae Pangamologa laeala ka i ae Nutu. ");
INSERT INTO mee_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Pala nganige, ka ina orume ke sane ke lele tale, nae i ke momo kala nge Nutu. ");
INSERT INTO mee_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Orume kinung keke lele nge Pangamologa laeala, ba ka sana otte lele balakala nge i. ");
INSERT INTO mee_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mauling ka puna nge i, ba mauling laeala ke tunge olamana ta ragau kinung. ");
INSERT INTO mee_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Olamana laeala ka lamana nga osuguna, ba osuguna ka sana kana gingginga ta ulongpite. ");
INSERT INTO mee_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Na agau te a Nutu baꞌe ke atu ora giana nge Ion. ");
INSERT INTO mee_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","I ke atu ta i a aturungpotakana ta turungpotange olamana laeala, ta baina ragau kinung nga loreapatokona kurumea pulingmalagangana ka pangamologa. ");
INSERT INTO mee_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","I muni ka sana i a olamana laeala. Ke sa. I ke atu ta i turungpotange olamana laeala. ");
INSERT INTO mee_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Olamana a kaomannmannangana kia ore tunge olamana ta ragau kinung ke atu ta mogalo laekia e ngape. ");
INSERT INTO mee_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","I ke momo nga mogalo laekia e ngape, ba oru re nga mogalo laekia keke lele nge i, ava re nga mogalo laekia ke sane ke kelapatokone. ");
INSERT INTO mee_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","I ke atu ta ragau rae i, ava ragau rae i ka sana loreangatakale. ");
INSERT INTO mee_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ava ta ragau ra loreangatakale ba loreapatokona te i, ri keke rave Nutu patongana kerea ka goe rae i. ");
INSERT INTO mee_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ava ka sana ri ra goe rae Nutu kurumea lelengareangana nga agau te, o kurumea agau lonangana o avale natale lonangana. Ke sa. Keke lele nge Nutu mana. ");
INSERT INTO mee_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Bae Pangamologa laeala ke lele i a agau, na ke momo ngaliua nge mangng. Ba mangng ka kele lamanangana e toakala. Ka i a Tamana goe kena mana ae i lamanangana. Ba ka i a lama ora lopengana ae Nutu a i tungumane ba pangamologa a kaomannmannangana keke ponu nge i. ");
INSERT INTO mee_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ion ke role ka turungpotangana e ta Pangamologa laeala e lele i a agau, ba ke kiu roma, “Aekia ka i ae aelama a iau rorole te roma, ‘Agau e la atung ngarume nge iau ke ngailu nge iau, ta i ke momo pala nge iau.’” ");
INSERT INTO mee_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ba lonana ae i ke ponutalao, minmina na ita kinung kaka rave lonana raumana muni. ");
INSERT INTO mee_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ta ragau ravungareangana ka bangapagame ke lele kurumea Nutu tungngana ka bangapaga nginngina te Moses. Ava ragau ravungareangana ka lopengana ae Nutu a i tungumane ba ragau ravungareangana ka pangamologa a kaomannmannangana ke lele kurumea Nutu tungngana kae Iesus Karais. ");
INSERT INTO mee_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ka sana agau te kele Nutu ka kae te, avae Nutu Tuna a i kena mana ore momo nge Tamana bavana ke papote Nutu. ");
INSERT INTO mee_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Na ka inae Iura re ngae Ierusalem ke baꞌe pirisme ba Livaime ta ri balinglage roma, “Ka one a tai?” nae Ion ke panane i muni. ");
INSERT INTO mee_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","I ke sane kauli ava ke turupota roma, “Ka sana iau ae Karais.” ");
INSERT INTO mee_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Na ri keke ballage roma, “Ava, ka one a tai? Ka one ae Ilaia?” Nae Ion ke role roma, “Ka sana iau ae Ilaia.” Ba keke ballage muni roma, “Ka one a agau e toe Nutu kaona a i role pala ta i bange?” Nae Ion ke ale balinglaga nga kanrea roma, “Ke sa.” ");
INSERT INTO mee_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Na keke ballage muni roma, “Ka one a tai? Ngo turu te mangng nga baina mangng nga loagaliu ka pangamologa alangana ta reke ba mangng. Ko role mina ngaetai kone?” ");
INSERT INTO mee_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nae Ion ke ala rea ka pangamologa a Aisaia a i a agau e toe Nutu kaona paꞌe pala roma, “Ka iau a agau e kurkura kalingngana nga ina a sana ragau ngia roma, ‘Ngaka patupe pamau ae Avolau.’” ");
INSERT INTO mee_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ka baina Parisio palu ra ri ke ba rea ");
INSERT INTO mee_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","keke ballage roma, “Ngaroma sana one ae Karais, o Ilaia, o agau laeala e toe Nutu kaona, na ke meimia na one ko pamagoegoea ragau?” ");
INSERT INTO mee_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nae Ion ke ala rea roma, “Iau ka pamagoegoea ragau ka me, ava ka agau te ke momo ngaliua nge miau ora sana lomiaumatana kia. ");
INSERT INTO mee_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","I ka i a agau e atu ngarume nge iau, ba ka sana iau a agau e pe ta iau polange oalo nge nga kesingsilagi ngae i.” ");
INSERT INTO mee_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Na oru nginngina keke lele ngae Betani nga Me Ae Ioran bavana tetoto, nga inaeala ae Ion pamagoegoea ragau ngia. ");
INSERT INTO mee_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Me ngangaila, nae Ion ke kele Iesus ine tatu, na ke role roma, “Ngaka kele. Sipsip Goekia ae Nutu ore atu ta ravunglelepatali ka re nga mogalo laekia e ngape nga baingarea reke sosoali ikolong e tatu! ");
INSERT INTO mee_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Aekia ka i a agau ama iau rorole te roma, ‘Agau e la atung ngarume nge iau ke ngailu nge iau, ta i ke momo pala nge iau.’ ");
INSERT INTO mee_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Iau muni ka sana kelapatokone, ava iau ka atu ba ka pamagoegoea ragau ta baina ragau re ngae Israel nga loreamatana kia.” ");
INSERT INTO mee_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nae Ion ke role ka turungpotangana roma: “Iau ka kele Kannu Ae Nutu ke atupisigi nga tava ma i a manu a kulao ba ke mommo nge i. ");
INSERT INTO mee_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Taroma i e ba iau ta pangamagoenge ragau ka me sane te role kau ka pangamologa pala, na iau ala sana ta kelapatokone. Ava i ke role kau pala roma, ‘Agau a one kele Kannu ae iau ine atupisigi be mommo nge i ka i a agau e la pangamagoenge ragau kae Kannu E Tupu.’ ");
INSERT INTO mee_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ba iau ae Ion ka kele tapu, ba ka turupota roma, agau laeala ka i ae Nutu Tuna.” ");
INSERT INTO mee_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ka kae tetoto muni, nae Ion ke meisinsi kala nga barangalele lua ra kanna. ");
INSERT INTO mee_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Na i ke kele Iesus ine tatao na ke role roma, “Ngaka kele. Sipsip Goekia ae Nutu iala e tatao.” ");
INSERT INTO mee_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Na ka ina barangalele lua rae Ion kanna ke longe ine role minmina, na keke loakurumea Iesus. ");
INSERT INTO mee_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Minmina nae Iesus ke kampiliu, na ke kela rea ineke tataokurumea, na ke ballaga rea roma, “Kaka meimia?” Na keke role roma, “Rabai” (a mirana roma Apangalomatanakana), “one ko mommo nga ine ngaetai?” ");
INSERT INTO mee_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nae Iesus ke ala rea roma, “Ka atu, na ngaka kele.” Minmina na ri keke loa ba keke kele ina i mommo ngia. Na keke momo kala nge i ka kae laeala. Ba kae ke pa basema kae matana a tangulelu ka sinro. ");
INSERT INTO mee_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nae Saimon Pita teiteikia ae Anru ka i a te nga pana lua nginngina reke longe Ion pangamologangana beke loakurumea Iesus. ");
INSERT INTO mee_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ba oru e kapunu ta i kumangng kia, i ke loa ta kalingpa ka tataokia ae Saimon ba ta roleng kia roma, “Mangng ka kalipa ka agau a i ae Mesaia” (ora mirana roma Karais). ");
INSERT INTO mee_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ngarume na i ke loa kae Saimon te Iesus. Nae Iesus ke kela te i, na ke role kia roma, “Ka one ae Saimon a i ae Ion tuna. Giang nge Sipas” (eke patoe kae Pita). ");
INSERT INTO mee_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ka kae tetoto nae Iesus ke bai ta kulungtapu tae Galili. Na i ke kalipa kae Pilip, na ke role kia roma, “Atu kurume iau.” ");
INSERT INTO mee_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Bae Pilip kala nge Anru bae Pita ka ri re nga maga kunna e bollau ae Betsaira. ");
INSERT INTO mee_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nae Pilip ke kalipa kae Nataniel, na ke role kia roma, “Mangng ka kalipa ka agau amae Moses pa te pala ngallo nga Bangapagame. Ba ka i a agau ama ragau reke toe Nutu kaona ke pa te bole. Ka i ae Iesus e ngae Nasaret a i ae Iosep tuna.” ");
INSERT INTO mee_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nae Nataniel ke magio, na ke ballaga galiu roma, “Koee! Ka otte e pe ke pa nge Nasaret?” Nae Pilip ke ale roma, “Atu, ngo kele.” ");
INSERT INTO mee_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ka inae Iesus kele Nataniel ine tatu te i, na ke role roma, “Ngaka kele. Israel te mannangana ora sana otte a goanga momo nge i.” ");
INSERT INTO mee_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Minmina nae Nataniel ke ballage roma, “Ko maimia ka longmatanangang kau?” Nae Iesus ke ale roma, “Pala, ka ino momo nga bega a pik siana inae Pilip sane kiu te one tale, na iau ka kela one.” ");
INSERT INTO mee_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nae Nataniel ke ale roma, “Rabai, ka one ae Nutu Tuna. Ba ka one a Kelangpatali ae Israel.” ");
INSERT INTO mee_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Nae Iesus ke role kia roma, “Lopatokona ae one ke lele kurumea longang ngana ka pangamologangau ina iau role kone roma, ka kela one ino momo nga bega a pik siana. Ava ngarume na one ko la kelange oru reke bollau raumana nga ollaeala.” ");
INSERT INTO mee_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Bae Iesus ke role bole roma, “Iau nga role kamiau ka kaomannmannangana roma, ngarume na miau kaka la kelange tava ine nge pulapatali, ba anggelo rae Nutu ine ngeke lopataetae ba ngeke somalingling te Agau Tuna.” ");
INSERT INTO mee_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Na ka kae a mologi, na kaning e bollau e nga palingravung ke lele nga maga kunna e bollau a giana nge Kena ngallo ngae Galili. Bae Iesus naname ke momo nga kaning laeala e bollau, ");
INSERT INTO mee_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ba ri keke ba te Iesus kala nga barangalele ra kanna ta ri momong nga palingravung laeala bole. ");
INSERT INTO mee_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ngarume, ka ina uain rongo tapu, nae Iesus naname ke role kia roma, “Ka sana karea uain muni.” ");
INSERT INTO mee_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nae Iesus ke role kia roma, “Avale laekolong, ke meimia o ulosivala iau nga ollaekia? Kae ae iau ke sane lele tale.” ");
INSERT INTO mee_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nae naname ke role ka ra kumangngatulu roma, “Ngaka kuma mana kurumea ine nge role ta taru.” ");
INSERT INTO mee_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na nga inaeala ka me bagana reke bollalau ra ri ke kuma ki ka lollo, ba ka ri lima ba kena keke momo. Ka ri ra me bagana nga pasinunge me ngi ore nga pangalellepaꞌe ragau mirareame kurumea Iurame baingarea te. Ba kenakena ponungana ke basema litame ka ri 100. ");
INSERT INTO mee_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nae Iesus ke role ka ra kumangngatulu roma, “Ngaka paponue me baganame ka me.” Minmina na ri keke paponu rea ka me savele ta kaoreame. ");
INSERT INTO mee_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ngarume nae i ke role kerea roma, “Ngaka kiaulelea inte, na ngaka loa kia ta kaning tamana.” Na ri keke kuma minmina, ");
INSERT INTO mee_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","na kaning tamana ke ave me laeala e kampiliu ne lele i a uain. Ba i ka sana lonamatana roma, uain laeala ke meimia ka lelengana. Ava ra kumangngatulu reke kiaulelea me ka loreamatana. Minmina na kaning tamana ke kiuvala ka apanung e kamapitakama, ");
INSERT INTO mee_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","na ke role kia roma, “Ragau kinung keke lelemalaga ka uain e pe kapunu, ba ngarume, ka ina ragau ke bemve tapu, na ri ngeke tavoa ka uain a sana kunna e bollau. Ava one ko talulelea nekia e pe, ava ikia na ko ulomalage. Na bainga laeala ke pe.” ");
INSERT INTO mee_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ba killa laekia ae Iesus kuma kia nga maga kunna e bollau ae Kena nga ina ngae Galili ka i a killa e kapunu a i kuma kia. Ba nga kumangng laeala i ke pakosining ka gingginga ae i e bollau raumana. Minmina na barangalele ra kanna ka loreapatokona te i. ");
INSERT INTO mee_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ngarume nga ollaeala nae Iesus kala nge naname, bae teiteikia memena, ba barangalele ra kanna keke taopisigi tae Kaperneam. Na keke momo nga inaeala ka kae palu. ");
INSERT INTO mee_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ka ina kaning e bollau ae Iurame eke patoe kae Paska ke lele kokoro, nae Iesus ke loapatae tae Ierusalem. ");
INSERT INTO mee_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ba ka ine taolu ta malle re ngapotu nga bale a tempel, na i ke kele ragau reke bava ka bulmakaume, ba sipsipme, ba manu ra kulao. Ba ke kele ragau reke tattara ba keke rarave lollokanna ra Romme kanrea beke tungugaliliue lollokanna ra Iurame kanrea. ");
INSERT INTO mee_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Minmina nae i ke kuma ka sapingi te ka oalo iname, na ke taomalage ragau kinung kala nga sipsip ba bulmakau ngae ri lagapotu nga ina re nga tempel. Ba i ke kasilole lollokanna ra reke tungugaliliue lollokanna nga kanrea, ba ke bapalipisigi ka pala ngae ri. ");
INSERT INTO mee_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Na i ke role ka reke bava ka manu ra kulao roma, “Ka kapatali ka oru kakai lagapotu nga inaekia! Manemiausa bainga ka bale ae Tamau ta i a malle e nga banga ka orume!” ");
INSERT INTO mee_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Na barangalele ra kanna ka loreagaliu ta pangamologa a ragau ke paꞌe pala nga Lau Ae Nutu Kanna roma: “Logumatengana ta bale ae one ke tonge siau raumana.” ");
INSERT INTO mee_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nae Iurame keke ale ka kiungasiling ngareangana kia roma, “Tai ke tunge gia bolinglaungana te one ta one kumangng ka oru kakai? Ko la pangakosining ka killa e bollau a taru te mangng, nga baina mangng nga lomangngmatana roma ko rave gia bolinglaungana ngae tai?” ");
INSERT INTO mee_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nae Iesus ke ala rea roma, “Ngaroma ngaka rure tempel laekia, na iau ka la kumangngamuni kia ka kaeme ka ri mologi.” ");
INSERT INTO mee_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nae Iurame keke ale roma, “Tempel laekia ke rave pesingmatana ka ri 46 ta ri kumangng kia, ba one ko la pangamaisinge muni ka kae mologi mana. Ke sa bavakena.” ");
INSERT INTO mee_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Avae Iesus ke sane rorole ta tempel laeala. Ke sa. I ke rorole ta i muni mirana. ");
INSERT INTO mee_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ba ngarume, ka inae Nutu pasigipage nga mateng tapu, na barangalele rae i ka loreagaliu ta pangamologangana ine role minmina pala. Na ri ka loreapatokona ta pangamologa nga Lau Ae Nutu Kanna, ba ka loreapatokona ta pangamologa a Iesus rolea. ");
INSERT INTO mee_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ba ragau papatu keke kele killa reke bollalau ra i kumkuma ki ine mommo ngae Ierusalem nga Kaning E Bollau E Nga Paska. Minmina na ri ka loreapatokona te i. ");
INSERT INTO mee_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ava nge Iesus muni, i ka sana lonakalkala kerea kurumea, i ka lonamatana tapu ka ragau kinung. ");
INSERT INTO mee_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","I ke sane momalle agau te ta i turunglomatana te i ka ragau baingareanganame kurumea, i ka lonamatana tapu ka oru reke momo ngallo nga ragau. ");
INSERT INTO mee_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Na agau te a giana nge Nikoremus a i a Parisio te ke momo. Ka i a agau te a bollau ngaliua nga reke taoamugmuga ka Iurame. ");
INSERT INTO mee_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ka rigo te na i ke loa te Iesus, na ke role kia roma, “Rabai, mangng ka lomangngmatana roma, ka one a apangalomatanakana orae Nutu baꞌe. Ta taroma Nutu sane te momo kala nga agau te, na i sane te kuma ka killa reke bollalau ra one kumkuma ki.” ");
INSERT INTO mee_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nae Iesus ke ale ka rolengana kia roma, “Iau nga role kone ka kaomannmannangana roma, ngaroma agau sane nge lele muni nga toangapisigi, na i sane nge kele Nutu kelangpatalingana.” ");
INSERT INTO mee_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nae Nikoremus ke role kia roma, “Ava agau nge meimia ka toangapisigingana ka ine papisigi tapu? Ka sana nga lungana a lua nga naname siana nga baina naname nge toapisigia muni.” ");
INSERT INTO mee_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nae Iesus ke ale roma, “Iau nga role kone ka kaomannmannangana roma, ngaroma agau sane nge lele muni nga me ba kannu toangapisigi ngareangana kia, na i ke sane la lunga nga Nutu kelangpatalingana. ");
INSERT INTO mee_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Oru a agau mirana toapisigia ka i a mira, ba oru a Kannu ae Nutu toapisigia ka i a kannu. ");
INSERT INTO mee_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Sono ngo magio nga ina iau role kone roma, ‘Ngo lele muni nga toangapisigi.’ ");
INSERT INTO mee_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Bovole ke inso ba ke tatao kurumea lonangana mana. Ko longe maina ava ka sana longmatana roma ke pa ngaetai, ba ka sana longmatana roma ke lola aetai. Ragau ra Kannu ae Nutu toapisigi rea ka tongarea kena mana ma ollaeala.” ");
INSERT INTO mee_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nae Nikoremus ka ballage Iesus roma, “Ava oru nginngina keke la leleng mina ngaetai?” ");
INSERT INTO mee_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nae Iesus ke ale ka balinglagangana kia roma, “Ka one a agau e palomatantane Israelme. Ke meimia na one ka sana longmatana ka oru nginngina? ");
INSERT INTO mee_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Iau nga role kone ka kaomannmannangana roma, mangng ka pamolloga ta oru ra mangng ka lomangngmatana ki. Ba mangng ka turulomatana ta ora mangng ka kele, ava miau ka sana lomiaungatakalkale oru ra mangng ka tuturulomatana ki. ");
INSERT INTO mee_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Iau ka role kamiau ta oru re nga mogalo laekia e ngape ava ka sana lomiaupatokona. Na ka la lomiaupatokona mina ngaetai ngaroma iau nga role kamiau ta oru re nga Nutu mallena nga tava? ");
INSERT INTO mee_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ka sana agau te loapatae be lu lakallo ta Nutu mallena nga tava. Agau Tuna kasikena ore atupisigi nga Nutu mallena nga tava, i mana ka lonamatana ka inaeala. ");
INSERT INTO mee_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pala, ka inae Moses bae Israelme ke momo nga ina a sana ragau ngia, nae Moses ke pulia mue laeala a i kuma kia nga bega inte. Ba ke kinpataea lakailu ta baina ragau reke kela ta mue laeala sane ngeke mate. Ba ollaeala ka tongana kena mana ma ina ragau ke la kiningpataenge Agau Tuna lakailu nga bega, ");
INSERT INTO mee_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ta baina ragau ra loreapatokona te i ngeke rave mauling e momo passavele. ");
INSERT INTO mee_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Iau ka role minmina kurumea, Nutu matengraumanangana ka ragau re nga mogalo laekia e ngape ke bollau raumana. Minmina na i ke tunge Tuna a i a goe kena mana ae i, ta baina ragau ra loreapatokona te i sane ngeke sanrea, ava ngeke rave mauling e momo passavele. ");
INSERT INTO mee_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Iau ka role minmina kurumea, Nutu ke sane baꞌe Tuna ta mogalo laekia ta kalingnanange ragau. Ke sa. Ke baꞌe Tuna ta baina i nge ravulele rea ka Tuna matengana. ");
INSERT INTO mee_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Agau a lonapatokona te Nutu Tuna ke sane la ravunge kalingnana kana alang e soali. Ava agau a sana lonapatokona te i ke rave kalingnana kana alang e soali tapu kurumea, i ka sana lonapatokona te Nutu Tuna giana a i a goe kena mana ae Nutu. ");
INSERT INTO mee_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Bae Nutu kalingnanangana ka ragau ke lele minakai roma: Olamana ke atupisigi ta mogalo laekia e ngape tapu. Ava ragau baingareame keke soali, minmina na ri keke matea osuguna raumana nga olamana. ");
INSERT INTO mee_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Iau ka role minmina kurumea, agau e bavaia bainga reke sosoali ka sana omona ka olamana. Ba i ka sana omona ta taongalu ta olamana kurumea, ngaroma i nge taolu, na bainganame ngeke pota. ");
INSERT INTO mee_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ava agau e tatao kurumea pangamologa ora kaomannmannangana kia ke loalu ta olamana, ta baina kumangngana ka bainganame ka Nutu ginggingngana nge lele nga karakarangana.” ");
INSERT INTO mee_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ngarume nga ollaeala nae Iesus kala nga barangalele ra kanna keke loa lagapotu ta ine ngae Iurea. Na i ke momo kala nge ri nga inaeala ka kae palume, ba keke pamagoegoea ragau ka me. ");
INSERT INTO mee_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Bae Ion ke pamagoegoea ragau bole. Ke pamagoegoe rea nga inte kokoro tae Salim a ri ke patoe ka Ainon, ta ka liu papatu keke momo nga inaeala. Ba ragau papatu keke lola ta ri ravunge pangamagoe. ");
INSERT INTO mee_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Oru nginngina keke lele inae Eroto sane pulia Ion nga pulangkala tale. ");
INSERT INTO mee_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Na palingtete ke lele ngaliua nga barangalele palu rae Ion kanna kala nga Iura te. Ri keke palivali ka pangamologa ore ta Iurame baingarea te nga mumung ta pangalellepaꞌe ragau mirareame. ");
INSERT INTO mee_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Minmina na keke loa te Ion, na keke ballage roma, “Rabai, agau laeala e pala ne momo kala nge one nga Me Ae Ioran bavana tetoto ama one turupotpote, i ke pamagoegoea ragau ba ri kinung keke lola te i.” ");
INSERT INTO mee_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nae Ion ke ala rea roma, “Orume kinung ra agau raravu rea keke papa nga Nutu mallena nga tava mana. ");
INSERT INTO mee_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Miau muni ka lomiaumatana tapu ka pangamologangau ina iau role roma, ‘Ka sana iau ae Karais. Ke sa. Ka iau a agau a Nutu baꞌe ngamuga nge Karais.’” ");
INSERT INTO mee_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Bae Ion ke role ka pangateningkalangana e te i bae Karais roma, “Ka kae e nga palingravung rea, na avale e kamapitakama ka orae apanung laeala e kamapitakama kia. Apanung e kamapitakama kolingana e meisinsi be longlonge pangamologangana ka lonasereng raumana ine longe apanung e kamapitakama kalingngana. Ba sonrau na loserenga laeala ke lele nge iau ae Ion a iau a apanung e kamapitakama kolingana, ba loserenga laeala ke ponu raumana. ");
INSERT INTO mee_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ngarume na giana nge umma ta leleng bollau raumana, ava giau nge soinsigi. ");
INSERT INTO mee_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Agau e pa ngailu ke ngailu nga ragau kinung. Agau e nga mogalo ka orae mogalo, ba i ke rorole ma i a agau e nga mogalo. Agau e pa nga Nutu mallena nga tava ke ngailu nga ragau kinung. ");
INSERT INTO mee_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","I ke umma ta turungpotange oru ra i kela rea be longo rea, ava ka sana agau te lonangatakalkale turungpotangana. ");
INSERT INTO mee_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Agau a lonangatakale ke papote lonamatanangana roma, Nutu pangamologa ra kanna ka kaomannmannangana ki. ");
INSERT INTO mee_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Iau ka role minmina kurumea, agau a Nutu baꞌe ke rorolea pangamologa rae Nutu kanna, ta Nutu tungngana ka kannu ae i ta agau laeala ka sana lisina. ");
INSERT INTO mee_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nutu ke materaumane Tuna, ba i ke ulopaia orume kinung nga kamana. ");
INSERT INTO mee_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Agau a lonapatokona te Nutu Tuna ke ravutape mauling e momo passavele. Ava agau e sane longo te Nutu Tuna ke sane la kelange mauling kurumea, Nutu iukiangana ke mommopai nga agau laeala.” ");
INSERT INTO mee_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nae Parisiome keke longe inae Iesus pangamagoengana ba ravungngana ka barangaleleme ke umma ta leleng bollau nga Ion kumangngana ka oru nginngina. ");
INSERT INTO mee_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Avae Iesus muni ke sane pamagoegoea ragau. Ke sa. Barangalele ra kanna keke pamagoe rea.) ");
INSERT INTO mee_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ka inae Iesus lonamatana ka ollaeala, na i ke kaꞌe Iurea ba ke galiu muni tae Galili. ");
INSERT INTO mee_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Na ke tao kurumea pamau e tao ngaliua ngae Sameria. ");
INSERT INTO mee_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Na ke lele nga maga kunna te e bollau ngallo ngae Sameria eke patoe kae Saikar, kokoro ta mogalo inae Iekop tunge ta tuna ae Iosep pala. ");
INSERT INTO mee_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Na lulu e nga olenge me eke patoe ka oleng orae Iekop ke momo nga inaeala. Bae Iesus taongana ke baia likisangana nga mirana. Minmina na i ke tara kokoro nga oleng laeala. Ba kae ke pa basema kae matana lima ba kena ka laio. ");
INSERT INTO mee_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ka ina avale te e ngae Sameria ke lele ta oleng kana me, nae Iesus ke role kia roma, “Atu ka me, ta iau ka bai ta inung kau.” ");
INSERT INTO mee_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(I ke kalungu me kurumea, barangalele ra kanna ke sane ke momo. Keke loa ta koling kaning nga maga kunna e bollau.) ");
INSERT INTO mee_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Na avale laeala e ngae Sameria ke role kae Iesus roma, “Ka one a Iura te ba ka iau a avale te e ngae Sameria. Ke meimia na ko role kau ta tunga kanga me?” (Avale laeala ke role minmina kurumea, Iurame ke sane ke palipulikinungnung rea kala nge Sameriame.) ");
INSERT INTO mee_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nae Iesus ke ale roma, “Taroma one ta longmatana ka tunga a Nutu tungtunge, ba tai e rorole kone roma, ‘Atu ka me, ta iau ka bai ta inung kau,’ na one to ballage na i te tunge me e mauli te one.” ");
INSERT INTO mee_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Na avale laeala ke role kia roma, “Avolau, ka sana kaning otte ta olenge me kia, ba oleng laekia ke lu lakallo raumana. Ko la ravunge me laeala ore nga mauling aetai? ");
INSERT INTO mee_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ko roma one ka kang ka gingginga e bollau nga sisiukamangng ae Iekop e tunge oleng laekia te mangng ae? Ba i muni kala nga goe rae i ba bulmakau rae i keke inu ngia bole.” ");
INSERT INTO mee_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nae Iesus ke ale roma, “Agau e innue me nga oleng laekia ka la matengkana me muni. ");
INSERT INTO mee_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ava agau e innue me a iau la tungnge te i ka sana la matengkana me muni. Ke sa. Me a iau la tungnge te i ke la leleng ngallo nge i ma me e pollolomalaga ta i a mauling e momo passavele.” ");
INSERT INTO mee_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Na avale laeala ke role kia roma, “Avolau, ngo tunge me laeala te iau nga baina sana nga matekau me muni. Ba sana nga tatu ta olenge me nga inaekia e ngatauga muni.” ");
INSERT INTO mee_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nae Iesus ke role kia roma, “Loa ngo kiue ningtale, na onemea ngaka galiu.” ");
INSERT INTO mee_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Na i ke ale roma, “Ka sana nautale te.” Nae Iesus ke role kia roma, “Ko role masi ino role roma, ka sana ningtale te, ");
INSERT INTO mee_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ta pala na ka ningtaleme ka ri lima. Ba apanung a one momo kala nge i sonrau ka sana i a ningtale. Oru a one rolea ka kaomannmannangana kia.” ");
INSERT INTO mee_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Na avale laeala ke role kia roma, “Avolau, iau ka kela one roma, ka one a agau te e toe Nutu kaona. ");
INSERT INTO mee_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Sisiukamangng memena keke kalapage Nutu nga kapangng laekia, ava miau ra Iurame kaka roma, maga mannangana ta kalangapage Nutu ngia ka i a Ierusalem.” ");
INSERT INTO mee_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nae Iesus ke role kia roma, “Avale, nga longpatokona ta pangamologangau roma, kae a miau ka sana ka la kalangapagange Tamau nga kapangng laekia o ngae Ierusalem ke tatu. ");
INSERT INTO mee_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Miau ra Sameriame kaka kalapagpage oru a sana lomiaumatana kia. Mangng ra Iurame ka kalapagpage oru a mangng lomangngmatana kia kurumea, Nutu ravunglelengana ka ragau ka puna nge mangng ra Iurame. ");
INSERT INTO mee_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ava kae ke tatu ba ke lele ina ragau reke kalapagpaga mannangana keke la kalangapagange Tamau ngallo nga kannu ba nga pangamologa ora kaomannmannangana kia. Iau ka role minmina kurumea, ragau matana laeala ka ri ra ra kalangapagakana rae Tamau kelkela tao. ");
INSERT INTO mee_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nutu ka i a kannu, minmina na ragau reke bai ta kalangapagange mannangana keke la kalangapagange ngallo nga kannurea ba nga pangamologa ora kaomannmannangana kia.” ");
INSERT INTO mee_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Na avale laeala ke role kae Iesus roma, “Iau ka laumatana roma agau a i ae Mesaia (a ri ke patoe kae Karais) ke tatu. Ka ine nge atu na i nge pananamasia orume kinung te mangng.” ");
INSERT INTO mee_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Nae Iesus ke role kia roma, “Ka iau a i laeala mana ikia e pamolloga te one.” ");
INSERT INTO mee_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ka panna laeala mana na barangalele rae Iesus kanna keke lele. Ba keke magio raumana ka ineke kalipa kae Iesus ine pamolloga kala nga avale te. Ava ka sana te e nge ri ballaga roma, “Ko matea taru?” o “Ko meimia o pamolloga kala nga avale laekolong?” ");
INSERT INTO mee_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Na avale laeala ke kaꞌe me bagana ae i, ba ke galiu ta maga kunna e bollau. Na ke role ka ragau roma, ");
INSERT INTO mee_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ka atu ngaka kele agau te ore ture baingaume kinung re pala te iau. Ka i ae Karais nanguni.” ");
INSERT INTO mee_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Minmina na ri keke lelemalaga nga maga kunna e bollau, na keke lola ta ri kelange Iesus. ");
INSERT INTO mee_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ka panna laeala a ragau sane ke lele tale, na barangalele rae Iesus kanna keke role kia roma, “Rabai, ngo kania kanga kaning inte.” ");
INSERT INTO mee_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ava i ke role kerea roma, “Ka kau ka kaning ore ta iau kaninge a miau sana lomiaumatana kia.” ");
INSERT INTO mee_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Na barangalele ra kanna keke paliballaga rea roma, “Agau te ke atu ka kana kaning te tapu ae?” ");
INSERT INTO mee_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nae Iesus ke role kerea roma, “Kaning ae iau minakai roma, iau ka la kumangng kurumea i e ba iau lonamatenganame. Ba iau ka la rongatapu ka kumangng a kanna. ");
INSERT INTO mee_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Sana ngaka role roma, ‘Ka inna tugulu muni na kae e nga lalang kaning nge lele.’ Iau ka la roleng kamiau roma, ngaka kele. Ngaka kalatare galimiaume na ngaka kele urame. Kaka la kelange kaning reke matua tapu beke momalla ta ragau lalanga rea. ");
INSERT INTO mee_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Agau e nga lalange kaning ke umma ta ravunge kumangngana kunna tapu. Ba i ke umma ta ravungkinunge kaning e nga momong mauli passavele, ta baina agau e toea kaning ba agau e lale nga loreasereng kinung. ");
INSERT INTO mee_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Minmina na pangamologa a ri ke patpatoe ka kaomanna kia ine role roma, ‘Te ke totoea kaning, ba tetoto ke umma ta lalange.’ ");
INSERT INTO mee_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Iau ka ba miau ta lalange kaning a miau ka sana ka kuma kia. Ragau pattoto keke kuma ka kumangng e bollau tapu, ba miau kaka lale kaning a ri ke kume.” ");
INSERT INTO mee_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nae Sameria papatu re nga maga kunna laeala e bollau keke lele ra lopatokonakana kurumea avale laeala pangamologangana e te Karais ine role roma, “I ke ture baingaume kinung re pala te iau.” ");
INSERT INTO mee_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ka baina ka inae Sameriame ke atu te Iesus, na keke ballage ta i momong kala nge ri. Na i ke momo kala nge ri ka kae lua. ");
INSERT INTO mee_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ba ragau papatu muni nge ri keke lele ra lopatokonakana ka ineke longe pangamologanganame. ");
INSERT INTO mee_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ba keke rorole ka avale laeala roma, “Mangng ka sana lomangngpatokona kurumea rolengang ka pangamologa mana. Ke sa. Ta sonrau na mangng ka longotape pangamologa a kanna ka mangng muni longamangngme. Ba ka lomangngmatana roma, agau laekia ka i ae Aravunglelekana orae ragau re nga mogalo laekia e ngape mannangana.” ");
INSERT INTO mee_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ngarume, ka ina kae lua nginngina rae Iesus momo kala nge Sameriame ke rongo tapu, na i ke kutapu ta loanga tae Galili. ");
INSERT INTO mee_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Iau ka role minmina kurumea pala, nae Iesus ke turulomatana ka pangamologa e role roma, ragau re nga maga kunna ae agau e toe Nutu kaona sana nga loreangatakale pangamologa a kanna.) ");
INSERT INTO mee_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ka ine lele ngae Galili na re ngae Galili keke serengkale kurumea, pala na ri keke kele oru ra i kuma ki kinung ine momo ngae Ierusalem nga kaning e bollau e nga Paska. Ta ri keke momo ngae Ierusalem nga kaning laeala bole. ");
INSERT INTO mee_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Minmina na i ke lele ngae Kena ngae Galili ka lelengana a lua. Ka i a inaeala e pala na i ke kampiliue me na ke lele i a uain. Ba kelangpatali barangalele ae i ora tuna ka kana ka soaling ke momo nga maga kunna e bollau ae Kaperneam. ");
INSERT INTO mee_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ba ka ina agau laeala longe inae Iesus lelemalaga ngae Iurea ba ke loa e lele ngae Galili, na i ke loa te i. Ba ke tanikale ta i loanga ta maga ae i ba pangapenge tuna, ore kokoro ta i mateng. ");
INSERT INTO mee_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Minmina nae Iesus ke patoe pangamologa ore isopa te i roma, “Miau ra ragau lopatokona ae miau ke lolakurumea kelang ngamiaungana ka killa ba kumangng reke bollalau mana.” ");
INSERT INTO mee_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Na kelangpatali barangalele laeala ae i ke role kae Iesus roma, “Avolau, atupisigi bolvole ta tugu ke kokoro ta i mateng.” ");
INSERT INTO mee_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nae Iesus ke ale roma, “Lo ngo kagaliu. Tung ke momo mauli.” Na agau laeala ka lonapatokona ta pangamologa ae Iesus kanna, ba i ke lao. ");
INSERT INTO mee_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ba ka ine tataopisigi tale, na ra kumangngatulu ra kanna keke kalipa kia nga pamau na keke turu pakia roma, “Tung ke momo mauli.” ");
INSERT INTO mee_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Minmina na i ke ballaga rea ka kae matana a tuna paturu ta i penga kia. Na keke ale roma, “Ngalla ka kae matana a lima ba lua ka laio na mirana mammangana ke kaꞌe.” ");
INSERT INTO mee_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Na goe laeala tamana ka lonamatana roma, ka kae matana laeala mana nae Iesus ke role kia roma, “Tung ke momo mauli.” Minmina na i kala nga ragau kinung reke momo nga bale ae i ka loreapatokona te Iesus. ");
INSERT INTO mee_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ba ollaeala ka i a killa e bollau a lua ae Iesus kuma kia ngae Galili ine lelemalaga tapu ngae Iurea. ");
INSERT INTO mee_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ka kae palu ngarume, nae Iesus ke loapatae tae Ierusalem ta i momong nga kaning te e bollau ae Iurame. ");
INSERT INTO mee_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na ka liu te ke momo ngae Ierusalem. Ba liu laeala ke momo kokoro ta maga kunna e bollau kana savanau kaona te a ri ke patoe ka Biunga E Nga Sipsipme. Liu laeala a ri ke patoe kae Betesra nga kaling ae Iurame ka kana ka malleme ka ri lima reke meistaliue onre nga ragau tarangalu ngi. ");
INSERT INTO mee_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ba ragau papatu ra karea ka soaling matantana keke kenkeno nga malle nginngina. Ka ri ra ragau ra matarea kanname ke su, ba ragau ra kaereame ke mate, ba ragau ra gireame ke mate. Ba ri keke momalle me nga liu ta i baingamaliliu. ");
INSERT INTO mee_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ta nga kae palu na anggelo te ae Avolau kanna nge solu ta liu laeala na nge bai maliliua nga me. Minmina na agau e kapunu ta i loangalu ta liu laeala ina anggelo nge bai maliliua tapu nga me, na soaling a taru e momo nge i nge rongo. ");
INSERT INTO mee_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na ka agau te ke momo nga inaeala, ba soaling ae i ke momo ka pesingmataname ka ri 38 tapu. ");
INSERT INTO mee_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nae Iesus ke kele ine kenkeno nga inaeala, ba i ka lonamatana roma i ke soali ka pesingmatana papatu tapu. Minmina na i ke role kia roma, “Ko matea ta one penga?” ");
INSERT INTO mee_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Na soa laeala ke ale roma, “Avolau, ka sana agau te ta i ulongo iau lakallo ta liu nga ina me nge bai maliliu. Ka ina iau nga amva ta songapisigi ta me, na agau tetoto nge kavesilele iau na nge sopisigi pala nge iau.” ");
INSERT INTO mee_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nae Iesus ke role kia roma, “Sigipaga, ba ngo rave nia ae one, na ngo tao.” ");
INSERT INTO mee_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Na ka pannasa mana, na agau laeala mirana ke pe. Ba i ke rave nia ae i, na ke tao. Na kae laeala ae Iesus papea agau laeala ka i a kae a Sabat. ");
INSERT INTO mee_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Minmina na Iurame keke rorole ka agau laeala ae Iesus papea roma, “Sonrau ka i a kae a Sabat, ba bangapagame keke parototokala one ta paunge nia ae one.” ");
INSERT INTO mee_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ava i ke ala rea roma, “Agau e pape iau ke role kau roma, ‘Ngo rave nia ae one, na ngo tao.’” ");
INSERT INTO mee_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ka baina ri keke ballage roma, “Tai ka i a agau laeala e role kone roma, ‘Ngo rave nia ae one, na ngo tao?’” ");
INSERT INTO mee_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ava agau a Iesus papea ka sana lonamatana ka tai e kuma ka ollaeala kurumea, Iesus ke taolu ngaliua nga maluame, na ke loa. ");
INSERT INTO mee_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ngarume nae Iesus ke kalipa kia nga tempel ba ke role kia roma, “Ngo kele, ko pe tapu. Sano ngo baia bainga e soali muni, ta baina otte e soali raumana nga soaling ae one e pala sane nge lele nge one.” ");
INSERT INTO mee_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Na agau laeala ke loa ba ke turu te Iurame roma, “Iesus ka i a agau e pape iau.” ");
INSERT INTO mee_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Minmina nae Iurame keke umma ta pangamiralalia Iesus kurumea, i ke kumkuma ka oru nginngina ka kae a Sabat. ");
INSERT INTO mee_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Avae Iesus ke ala rea roma, “Tamau ke kumkuma ta ke lele nga kae laekia e sonrau, ba iau ka kumkuma bole.” ");
INSERT INTO mee_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Na nga Iurame kelangareangana kae Iesus i ke sane kumkuma ka bainga kena mana e soali. Ke sa. Ke kumkuma ka bainga lua reke sosoali. Ne kapunu roma, i ke karitaue bangapaga e nga Sabat. Ba na lua roma, ke patpatoe Nutu kae i muni tamana. Ba nga pangamologangana laeala i ke pulia i muni kala nge Nutu roma, ka tongarea kena mana. Minmina na ri keke sissili raumana ta kaling paka pamau ta ri samungpununge. ");
INSERT INTO mee_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Minmina nae Iesus ke ala rea ka rolengana kerea roma, “Iau nga role kamiau ka kaomannmannangana roma, Nutu Tuna ke sane nge kuma ka otte kurumea i muni lonangana. Ke sa. I nge kumkuma mana ka kumangng ra i kela rea nge Tamana ine kumkuma ki. Ta oru rae Tamana kumkuma ki, Nutu Tuna ke kumkuma ki bole. ");
INSERT INTO mee_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Iau ka role minmina ta Nutu ke materaumane Tuna, ba i ke umma ta pangakosininge orume kinung ra i kumkuma ki te i. Ba i ke la pangakosining ka kumangng reke bollalau raumana nga kumangng nginngina ta baina miau magionga. ");
INSERT INTO mee_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nutu kumangngana ine pasigipagpage reke mate be tungtunge mauling te ri ka tongana kena mana ma inae Nutu Tuna tungtunge mauling ta tai a i matea ta tungnge te i. ");
INSERT INTO mee_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ba bole, Nutu ke sane umma ta kalingnanange ragau. Ke sa. I ke tunge kumangngme kinung nga kalingnana te Tuna. ");
INSERT INTO mee_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","I ke kuma minmina ta baina ragau kinung kalangpaga ngareangana kae Nutu Tuna nga tongana kena mana ma kalangpaga ngareangana kae Tamana. Agau e sane kalapagpage Nutu Tuna ke sane kalapage Tamana e baꞌe. ");
INSERT INTO mee_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Iau nga role kamiau ka kaomannmannangana roma, agau e longlonge pangamologa a kanau ba lonapatokona te i e ba iau ke ravutape mauling e momo passavele. Ba agau laeala ke sane la ravunge alanga e soali nga kalingnana e bollau ngarume. Ke sa. I ke bagitaue mateng ba ke lele nga mauling tapu. ");
INSERT INTO mee_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Iau nga role kamiau ka kaomannmannangana roma, kae a reke mate ta ri longnge Nutu Tuna kalingngana ke tatu. Ba reke longe keke la mauling. Ba kae laeala ke lele ikia tapu. ");
INSERT INTO mee_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nutu ka kana ka mauling ngallo nge i muni. Minmina na i ke matea ta Tuna nga kana ka mauling ngallo nge i bole. ");
INSERT INTO mee_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Bae Nutu ke tunge gingginga te Tuna ta i kalingnanange ragau kurumea, i ka i ae Agau Tuna. ");
INSERT INTO mee_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Sana ngaka kallo nga ollaeala, ta kae a ragau kinung reke mate beke momo nga lulu ngae ri ta ri longnge Nutu Tuna kalingngana ke tatu. ");
INSERT INTO mee_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ba ri keke la lelengmalaga nga lulu ngae ri. Ragau reke baia bainga reke pepe keke la sigingpaga ta ri momong mauli passavele. Ava reke baia bainga reke sosoali keke la sigingpaga ta ri ravunge alanga e soaling nga kalingnana e bollau. ");
INSERT INTO mee_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Iau ka sana kumkuma ka otte kurumea iau muni logungana. Ke sa. Iau ka kumkuma ka kumangng e nga kalingnana kurumea pangamologa ra iau longlongo rea nge Tamau mana. Ba kalingnana a kanau ke tupu, ta iau ka sana amva ta kumangng ka oru ra iau mate rea, ava oru ra i e ba iau mate rea. ");
INSERT INTO mee_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Taroma iau kasikegu ta turu iau, na turungau sana ta kaomanna kia. ");
INSERT INTO mee_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ka tetoto ke momo ore turu iau. Ba iau ka laumatana roma, turungana kau ka kaomanna kia. ");
INSERT INTO mee_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Miau kaka baꞌe ragau te Ion, na i ke turupota ta pangamologa ora kaomannmannangana kia. ");
INSERT INTO mee_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ava turungpota e turupota iau ke sane pa nga agau te. Ava iau ka rorolea pangamologa kokorai ta baina nga lomiaupatokona ta Ion pangamologangana re te iau, nae Nutu nge ravunglele miau. ");
INSERT INTO mee_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ion ka i a olamana ore toto be tungtunge olamana, ba miau ka lomiausereng ta momong nga olamana ae i ka kae palu. ");
INSERT INTO mee_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ava turungpota e turupota iau ke bollau raumana nga Ion turungpotangana kau. Iau ka role minmina ta kumangng rae Tamau tungu rea ta iau kumangng ba ronga ki keke turupotpota roma, Tamau ke ba iau. ");
INSERT INTO mee_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Bae Tamau e ba iau, i muni ke turupota iau. Miau ka sana ka longe kalingngana bavakena, ba ka sana ka kele sinna bavakena. ");
INSERT INTO mee_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ba pangamologa a kanna ke sane momo ngallo nge miau bole kurumea, miau ka sana lomiaupatokona ta agau a Tamau baꞌe. ");
INSERT INTO mee_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Miau kaka kumkuma raumana ta ravunge lomatana nga pangamologa reke momo nga Lau Ae Nutu Kanna kurumea, miau kaka roma kaka kalipa ka mauling e momo passavele tapu nga pangamologa nginngina. Ba pangamologa nginngina mana ka oru reke turupotpota iau. ");
INSERT INTO mee_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ava miau ka sana omomiau ta atung te iau ta ravunge mauling. ");
INSERT INTO mee_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Iau ka sana matea gia pangavolaungana a ragau ke tunge, ");
INSERT INTO mee_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ava iau ka laumatana kamiau tapu. Iau ka laumatana roma, bainga e nga matengraumanange Nutu ke sane momo nga lomiaume. ");
INSERT INTO mee_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Iau ka atu nge Tamau giana, ava miau ka sana lomiaungatakala iau. Ava ngaroma agau tetoto nge atu nge i muni giana, na miau kaka la bolvoling ta lomiaungatangngkale agau laeala. ");
INSERT INTO mee_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Miau kaka umma ta palingpangavolaunge giamiaume, ava ka sana omomiau ta ravunge gia pangavolaungana e pa nge Nutu a i kena mana. Minmina na ka la lomiaupatokona mina ngaetai? ");
INSERT INTO mee_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Sana ngaka roma, iau ka la turungpaga kamiau nga Tamau raguna. Ke sa. Agau e turupagpaga kamiau ka i ae Moses, a miau ka roma ka lomiaupatokona te. ");
INSERT INTO mee_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ngaroma nga lomiaupatokona ta pangamologa rae Moses kanna ka kaomanna, na nga lomiaupatokona te iau kurumea, Moses ke paꞌe pangamologa re te iau. ");
INSERT INTO mee_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ava miau ka sana lomiaupatokona ta pangamologa ra i pa rea. Minmina na miau ka la lomiaupatokona ta pangamologa ra iau role rea mina ngaetai?” ");
INSERT INTO mee_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ka kae palu ngarume nga ollaeala, nae Iesus ke ulutote Sivoli Ae Galili (a ri ke patoe ka Taibirias), na ke lele nga bavana tetoto. ");
INSERT INTO mee_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ba malua e bollau ke loakurumea, ta ri keke kele killa reke bollalau ra i kuma ki nga ragau ra karea ka soalingme. ");
INSERT INTO mee_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ngarume, nae Iesus ke loapatae ta kapangng te, na ke tara kala nga barangalele ra kanna. ");
INSERT INTO mee_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ba Kaning E Bollau E Nga Paska ke lele kokoro. ");
INSERT INTO mee_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ka inae Iesus ilapaga ba ke kele malua e bollau e tatu te i, na i ke role kae Pilip roma, “Ita kaka la koling ra kokorai karea beret aetai ta ri kaningi rea?” ");
INSERT INTO mee_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Na i ka lonamatana tapu ka kumangng a i la kumangng kia, ava ke ballaga ka balinglaga laeala ta avange Pilip mana. ");
INSERT INTO mee_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nae Pilip ke ale roma, “Ngaroma ita ngaka kolia beret ka lollokanna papatu, na beret laeala sane la totorong ta pangakaninge ri karolu. Palu keke la kaning, ba palu sana la karea.” ");
INSERT INTO mee_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Na barangalele tetoto ae i a giana nge Anru a i ae Saimon Pita teiteikia ke role roma, ");
INSERT INTO mee_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Goe laekia a panung ka kana ka beret ka ri lima onra bali ba leame ka ri lua, ava ka ri tutuna raumana ta pangakaninge ragau kokorai kurumea, ka ri papatu raumana.” ");
INSERT INTO mee_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nae Iesus ke role roma, “Ngaka role ka ragau ta ri tarang.” Na ka pailli ina papatu keke momo nga malle inaeala. Minmina na ri keke tara, ba ka kae laeala na ke kela basema ra panung ka ri 5,000 keke momo. ");
INSERT INTO mee_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ngarume nae Iesus ke rave beret nginngina ba ke kalapage Nutu, na ke tavoa ki ta reke tattara. Na i ke kuma minmina ka lea nginngina bole, ba ragau keke rarave kaning nginngina kurumea kenakena lonamatengana. ");
INSERT INTO mee_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ka ina ri kinung ke ponu tapu, nae Iesus ke role ka barangalele ra kanna roma, “Ngaka ravukinunge kaning kaloname ta baina sana nga inte nge sanrea.” ");
INSERT INTO mee_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Minmina na ri keke ravukinunge kaning kalona nga beret lima nginngina rae Iesus tavoa ki ta ragau pala. Na keke paponue guratame ka ri tangulelu ba lua ki. ");
INSERT INTO mee_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ka ina ragau ke kele killa laeala e bollau ae Iesus kuma kia, na keke role roma, “Aekia ka i a agau laeala mannangana e toe Nutu kaona a i role pala ta i bange ta mogalo laekia e ngape.” ");
INSERT INTO mee_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Minmina na ka inae Iesus lonamatana roma, ri keke bai ta ginggingapitange ta i a kelangpatali ae ri, na i ke kutapu ta kapangng muni ta baina i nge momo mana me i. ");
INSERT INTO mee_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ka laio ina oru balunnu, na barangalele rae Iesus kanna keke loa lagape ta sivoli. ");
INSERT INTO mee_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ba ka ina ri ke taepatae nga manang te tapu, na keke kutapu ta ri otengtote sivoli tae Kaperneam. Ba ka osuguna tapu, avae Iesus ke sane lele nge ri tale. ");
INSERT INTO mee_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Na me ke paturu ta i kurungpalpaga kurumea, bovole e bollau ke inso. ");
INSERT INTO mee_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ngarume, ka ina ri ke loa lagatauga basema pamau bena iname ka ri lima o lima ba kena tapu, na keke kele Iesus ine tataopai nga me be lele kokoro te ri nga manang. Ba keke matau raumana. ");
INSERT INTO mee_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Avae i ke role kerea roma, “Iau mana ikia, ka sana ngaka matau.” ");
INSERT INTO mee_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Minmina na ri keke bai ta i taenga nga manang, ba ka pannasa mana na manang ke lele nga inaeala nga me kaona a ri ke loa te. ");
INSERT INTO mee_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Me ngangaila, na maluame keke meisinsi nga sivoli bavana laeala a barangalele rae Iesus kanna ke kaꞌe ka kae e pala. Ri keke momo ka ina barangalele rae Iesus kanna ke taepatae nga manang ba ke lao, ba ka loreamatana roma ka manang kena mana ke momo nga taona. Ba ri ka loreamatana inae Iesus sane taepatae nga manang laeala kala nga barangalele rae i. Ri kasikerea keke taepatae nga manang, na keke lao. ");
INSERT INTO mee_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ngarume na manang palu reke pa ngae maga kunna e bollau ae Taibirias keke lele, na keke so kokoro ta inaeala a ragau ke kania beret ngia. Ka i a inaeala ae Avolau kalapage Nutu, na ke tunge beret ta ragau ngia. ");
INSERT INTO mee_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Minmina na ka ina maluame ke kele inae Iesus kala nga barangalele rae i ke sane ke momo, na ri keke taepatae nga manang nginngina. Ba keke loa tae Kaperneam ta ri kelanga te Iesus. ");
INSERT INTO mee_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ka ina ragau ke kalipa kae Iesus nga sivoli bavana tetoto, na keke ballage roma, “Rabai, ko atu nasai nga pia?” ");
INSERT INTO mee_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nae Iesus ke ala rea roma, “Iau nga role kamiau ka kaomannmannangana roma, miau kaka sissili iau, ava ka sana ka sissili iau kurumea kelang ngamiaungana ka killa reke bollalau ra iau kuma ki. Ke sa. Miau kaka sissili iau kurumea kaning ngamiaungana ka bereteme, ba ponung ngamiaungana ki. ");
INSERT INTO mee_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Sana ngaka umma ta ravunge kaning e lavusvusa. Ngaka umma ta ravunge kaning e mommo ta i a mauling e momo passavele, orae Agau Tuna la tungnge te miau. Ta i ka i a agau ae Tamau a i ae Nutu baꞌe mannangana ta kumangng ka kumangng a kanna.” ");
INSERT INTO mee_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Minmina na keke ballage roma, “Mangng ka la maingamia ka kumangng ngamangng, ta baina mangng nga kumkuma ka kumangng rae Nutu mate rea?” ");
INSERT INTO mee_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nae Iesus ke ala rea roma, “Kumangng ae Nutu kanna minakai roma: Miau nga lomiaupatokona ta agau a Nutu baꞌe.” ");
INSERT INTO mee_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Minmina na ri keke ballage roma, “Ko la kumangng ka killa e bollau a taru ta baina mangng nga kele ba nga lomangngpatokona te one? Ko la kumangng ka kumangng a taru? ");
INSERT INTO mee_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mangng ka bai ta kelange killa a tongana kena ma killa e lele pala nge sisiukamangng memena ineke kania beret a ri ke patoe ka mana nga ina a sana ragau ngia. Ollaeala ke loakurumea pangamologa a ri ke paꞌe pala nga Lau Ae Nutu Kanna e role roma, ‘I ke tunge beret e pa nga Nutu mallena nga tava ta ri kaninge.’” ");
INSERT INTO mee_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nae Iesus ke role kerea roma, “Iau nga role kamiau ka kaomannmannangana roma, ka sana Moses tunge beret e pa nga Nutu mallena nga tava te miau. Ke sa. Tamau ke tungtunge beret mannangana ore pa nga mallena nga tava te miau. ");
INSERT INTO mee_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Iau ka role minmina ta beret a Nutu tungtunge ka i a i e atupisigi nga Nutu mallena nga tava, be tungtunge mauling ta ragau re nga mogalo laekia e ngape.” ");
INSERT INTO mee_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Minmina na ri keke role kia roma, “Avolau, ngo tunge beret laeala te mangng sonrau ba ka kae re ngarume bole.” ");
INSERT INTO mee_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Nae Iesus ke role kerea roma, “Ka iau a beret e tunge mauling. Agau e atu te iau ka sana la mateng kana ngana. Ba agau a lonapatokona te iau ka sana la mateng kana ngana me. ");
INSERT INTO mee_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ava iau ka role kamiau tapu roma, kaka kela iau tapu ava ka sana lomiaupatokona te iau. ");
INSERT INTO mee_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ragau kinung rae Tamau tungtungu rea te iau keke la atung te iau. Ba iau ka sana la taongamalagange agau te e atu te iau. Iau ka sana la kumangng minmina bavakena. ");
INSERT INTO mee_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Iau ka role minmina ta iau ka sana atupisigi nga Nutu mallena nga tava ta loangakurumea iau muni laungana. Ke sa. Iau ka atupisigi nasai ta loangakurumea i e ba iau lonangana. ");
INSERT INTO mee_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ba i e ba iau lonangana minakai roma: iau sana la pangasanrea mana ka te nga ragau kinung ra i tungu rea te iau. Ke sa. Iau ka la pangasigipaga rea ka kae a ronga. ");
INSERT INTO mee_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ta ka i ae Tamau lonangana mannangana ta ragau kinung reke kele Tuna ba ra loreapatokona te i ngeke rave mauling e momo passavele. Ba iau muni ka la pangasigingpaga rea ka kae a ronga.” ");
INSERT INTO mee_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Minmina na reke taoamugmuga kae Iurame keke lola ka kaorea kae Iesus kurumea rolengana ka pangamologa roma, “Ka iau a beret e atupisigi nga Nutu mallena nga tava.” ");
INSERT INTO mee_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ba keke rorole roma, “Aekia ka i ae Iesus a i ae Iosep tuna, ba ita ka loramatana ka tamana bae naname. Ke meimia, na i ke role sonrau roma, i e atupisigi nga Nutu mallena nga tava?” ");
INSERT INTO mee_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nae Iesus ke ala rea ka rolengana kerea roma, “Sana ngaka lola ka kaomiau kau ngaliua nge miau. ");
INSERT INTO mee_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ngaroma Tamau e ba iau nge ute agau te pala, na i ale nge atu te iau. Ava nge sa, na agau laeala sana nga omona ta i atung. Ava ngaroma i nge atu, na iau ka la pangasigingpagange ka kae a ronga. ");
INSERT INTO mee_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Pala na ragau reke toe Nutu kaona keke paꞌe pangamologa ore role roma: ‘Ri kinung keke la ravunge lomatana kurumea Nutu pangalomatanangana kerea.’ Ba iau nga role kamiau roma, ragau kinung reke longe Tamau pangamologangana beke rave lomatana nge i keke tatu te iau. ");
INSERT INTO mee_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ka sana agau te kele Tamau. I mana e pa nge Nutu; i kasikena ke kele Tamau. ");
INSERT INTO mee_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Iau nga role kamiau ka kaomannmannangana roma, agau a lonapatokona te iau ka kana ka mauling e momo passavele. ");
INSERT INTO mee_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ka iau a beret e tunge mauling. ");
INSERT INTO mee_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Sisiukamiau memena keke kania beret laeala a ri ke patoe ka ‘mana’ nga ina a sana ragau ngia, na ngarume na keke mate. ");
INSERT INTO mee_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ava beret laekia a iau rorole te ka i a beret ore atupisigi nga Nutu mallena nga tava. Ba agau e kania beret laekia sane nge mate. ");
INSERT INTO mee_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ka iau a beret e momomauli ore atupisigi nga Nutu mallena nga tava. Agau e kania beret laekia ke la momong mauli passavele. Ba beret laekia ka i a mirau, a iau la tungnge ta baina ragau re nga mogalo laekia e ngape ngeke momomauli.” ");
INSERT INTO mee_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nae Iurame keke paturu ta ri palingtete ngaliua nge ri muni ka rolengarea kerea roma, “Aekia ke la tungnge mirana ta ita kaninge mina ngaetai?” ");
INSERT INTO mee_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Minmina nae Iesus ke role kerea roma, “Iau nga role kamiau ka kaomannmannangana roma, ngaroma miau sana ngaka kania Agau Tuna mirana, ba ngaroma sana ngaka inue totona, na ka sana nga kamiau mauling ngallo nge miau. ");
INSERT INTO mee_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Agau e kania mirau be inue totogu ka kana ka mauling e momo passavele, ba iau ka la pangasigingpagange ka kae a ronga. ");
INSERT INTO mee_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Iau ka role minmina kurumea, mirau ka i a kaning mannangana, ba totogu ka i a inung mannangana. ");
INSERT INTO mee_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Agau e kania mirau be inue totogu ke mommo ngallo nge iau, ba iau ka mommo ngallo nge i. ");
INSERT INTO mee_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tamau e mauli ke ba iau, ba iau ka mauli kurumea Tamau ke matea ta iau nga kau ka mauling ngallo nge iau. Ba agau e kaninni iau ka tongana kena mana ma ollaeala. Ba agau laeala ke la mauling kurumea, iau ka matea ta i nga kana ka mauling ngallo nge i bole. ");
INSERT INTO mee_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Beret laekia a iau rorole te ka i a beret e atupisigi nga Nutu mallena nga tava. Sisiukamiau memena keke kania beret laeala a ri ke patoe ka mana, na ngarume na keke mate. Ava agau e kaninnia beret laekia ke la momong mauli passavele.” ");
INSERT INTO mee_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Pangamologa nginngina ka ri ra pangamologa rae Iesus role rea ine palomatantane ragau ngallo nga sinagog nga maga kunna e bollau ae Kaperneam. ");
INSERT INTO mee_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ka ina barangalele rae Iesus kanna ke longe pangamologa nginngina, na papatu nge ri keke role roma, “Pangalomatana laekia ke isopa. Tai ka likina ta longakone?” ");
INSERT INTO mee_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bae Iesus ka lonamatana ina barangalele ra kanna ke lola ka kaorea kia ka pangamologangana nginngina. Minmina na i ke role kerea roma, “Pangamologangau nginngina keke papu miau ae? ");
INSERT INTO mee_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kaka la maingamia ngaroma ngaka kele Agau Tuna ine loapataetae ta inaeala a i momo ngia pala? ");
INSERT INTO mee_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ka i a Kannu ae Nutu ore tungtunge mauling. Agau mirana ke sane bavai ka otte. Pangamologa nginngina ra iau role kamiau ki ka ri ra oru rae Kannu ae Nutu, ba ka ri ra mauling. ");
INSERT INTO mee_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ava ka palu nge miau ra sana loreapatokona.” Iesus ke role minmina ta i ka lonamatana pala nga orume pangaturu ngareangana ka ragau re nge ri ra sana loreapatokona te i, ba agau e la ulonge nga reke bai ta baingasoalinge kamareame. ");
INSERT INTO mee_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ba i ke role bole roma, “Iau ka laumatana tapu ka miau, minmina na iau ama role kamiau pala roma, ngaroma Tamau nge pasigipage agau lona ta i atung te iau, na i ale nge atu te iau. Ava nge sa, na agau laeala sana nga omona ta i atung.” ");
INSERT INTO mee_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ngarume nga kae laeala, na barangalele papatu rae Iesus kanna keke galiu, ba ka sana omorea ta ri taongakurumenge Iesus muni ");
INSERT INTO mee_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Minmina nae Iesus ke ballage Pana Tangulelu Ba Lua roma, “Kaka bai ta kanga iau bole ae?” ");
INSERT INTO mee_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nae Saimon Pita ke ale roma, “Avolau, mangng nga loa te tai muni? One ka kang ka pangamologa reke tunge mauling e momo passavele. ");
INSERT INTO mee_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mangng ka lomangngpatokona ba ka lomangngmatana roma, ka one a E Tupukana ae Nutu.” ");
INSERT INTO mee_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Nae Iesus ke ala rea roma, “Iau muni ka toro miau Pana Tangulelu Ba Lua. Ava te e nge miau ka i a kannu e soali te.” ");
INSERT INTO mee_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Ka inae Iesus rolea pangamologa laeala na i ke rorolea pangamologa e te Iuras, a i ae Saimon Iskariot tuna. Ka i a te e nge Pana Tangulelu Ba Lau, ava ka kae e ngarume na i ke pulia Iesus nga reke bai ta baingasoalinge kamareame.) ");
INSERT INTO mee_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ngarume nga ollaeala, nae Iesus ke tatao nga ine ngae Galili. Ava i ka sana omona ta taonga ngae Iurea, ta Iura re nga inaeala keke sissilia pamau ta ri samungpununge. ");
INSERT INTO mee_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na kaning e bollau ae Iurame a ri ke patoe ka Kaning E Bollau E Nga Balvaleme ke lele kokoro. ");
INSERT INTO mee_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Minmina nae Iesus teiteikia memena keke role kia roma, “Ngo kaꞌe inaekia ba ngo loa tae Iurea, nga baina barangalele ra kaning ngeke kele killa reke bollalau ra one umma ki bole. ");
INSERT INTO mee_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ngaroma agau te nge bai ta ragau loreamatanangana kia, na i ke sane nge pakokoea kumangng a kanna. Ko kumkuma ka oru nginngina, minmina na ngo pakosining kone ta re nga mogalo laekia e ngape.” ");
INSERT INTO mee_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ri keke rorole minmina, ta ri ka sana loreapatokona te i bole. ");
INSERT INTO mee_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Minmina nae Iesus ke role kerea roma, “Kae ae iau mannangana ke sane lele tale, ava kaeme kinung ka ri ra kae rae miau mana. ");
INSERT INTO mee_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ragau re nga mogalo laekia e ngape ke sane ngeke baiꞌiu kamiau. Ava keke baiꞌiu kau, ta iau ka turupote baingarea reke sosoali ra ri ke umma ki. ");
INSERT INTO mee_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Miau ngaka loapatae ta kaning e bollau, ava iau sana nga loapatae ngana, ta kae ae iau mannangana ke sane lele tale.” ");
INSERT INTO mee_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ka ine role kerea minmina tapu, na ke momo ka kae palu ngae Galili. ");
INSERT INTO mee_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ava ngarume, ka inae teiteikia memena ke loapatae ta kaning e bollau tapu, na i ke loapatae bole. Ava i ke sane tao nga karakarangana, ta i ka sana omona ta ragau papatu kelange. ");
INSERT INTO mee_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Minmina nae Iurame keke kelatonto te i nga kaning e bollau, ba keke balaglaga roma, “Agau laeala ka i aetai?” ");
INSERT INTO mee_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Na maluame keke palivalikala rea ka pangamologa. Palu nge ri keke rorole roma, “Ka i a agau e pe.” Ava pattoto keke rorole roma, “Ke sa. Ke pataoptaopaꞌe ragau.” ");
INSERT INTO mee_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ava ri ke sane ke rorolea pangamologa e te i nga karakarangana kurumea, keke matautaue reke taoamugmuga kae Iurame. ");
INSERT INTO mee_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ava ngarume, ka ina Kaning E Bollau E Nga Balvaleme ke pa ngaliua, nae Iesus ke loapatae, ba ke lu lakallo ta malle re nga tempel. Na i ke paturu ta pangalomatane ragau. ");
INSERT INTO mee_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Na Iurame keke magio raumana ba keke rorole roma, “Agau laekia ke sane loa ta pangalomatana, ava ke rave lonamatanangana ta Lau Ae Nutu Kanna mina ngaetai?” ");
INSERT INTO mee_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Minmina nae Iesus ke ala rea roma, “Pangalomatana a iau palomatantane ragau kia ka sana orae iau. Ke sa. Ke pa nge i e ba iau. ");
INSERT INTO mee_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ngaroma agau te nga omona ta i loangakurumea Nutu lonanganame, na i ka la lonamatana ka pangalomatana laekia puna. I ka la lonamatana roma, ke pa nge Nutu, o iau ka patomane ka laumatanangana. ");
INSERT INTO mee_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Agau e patomane pangamologa ka i muni lonamatanangana ke bai ta kiningpataenge i muni giana, ava agau e umma ta kiningpataenge i e baꞌe giana ka ora kaomannmannangana kia, ba ka sana bainga te e soali nge i. ");
INSERT INTO mee_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses ke tunge bangapagame te miau, ava ka sana te e nge miau lolakurume rea. Ke meimia, na kaka amva ta samungpunu iau?” ");
INSERT INTO mee_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nae maluame keke ale roma, “Kannu e soali ke lu one. Ka sana agau te amva ta samungpunu one.” ");
INSERT INTO mee_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nae Iesus ke role kerea roma, “Iau ama kuma ka killa kena, na miau kinung amaka kallo. ");
INSERT INTO mee_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Iau ka papea agau mirana ba bainga e nga totongtaliu a Moses tunge te miau ke kuma minmina bole. (Ava ka sana Moses e tunge bainga e nga totongtaliu. Ke sa. Ke pa nge sisiukita memena). Ba miau kaka umma ta totongtaliunge ragau ka kae a Sabat bole. ");
INSERT INTO mee_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Miau kaka tototaliue agau te ka Sabat ta baina sana ngaka karitaue bangapaga ae Moses kanna. Ke meimia, na ka iukamiau kau ka ina iau papea agau mirana iname karolu ka kae a Sabat? ");
INSERT INTO mee_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Sana ngaka kalinana kurumea oru re ngapotu ra miau ka kela rea ka matamiau kanname. Ngaka kalinana kurumea kalingnana ore tupu.” ");
INSERT INTO mee_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Minmina na ragau palu re ngae Ierusalem keke balaglaga roma, “Aekia ka i a agau laeala mana ameke bai ta samungpununge, o ke sa? ");
INSERT INTO mee_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ngaka kele. I ke umma ta pangamologa nga ragau kinung ragureame, ava ri ke sane ke rorole kia ka inte. Reke taoamugmuga ka ragau keke roma ka i ae Karais nanguni. ");
INSERT INTO mee_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ava nge aekia, ita ka loramatana tapu ka ine pa ngia. Ava ka inae Karais nge atu, na ka sana nga agau te la lonamatana roma ke pa nga ina ngaetai.” ");
INSERT INTO mee_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Minmina nae Iesus ke palomatantane ragau nga malle re nga tempel, ba ke pamologa kaligi te ri roma, “Miau ka lomiaumatana kau, ba ka lomiaumatana bole roma ka iau e nga ina ngaetai. Iau ka sana atu nasai ka logungana mana. Ke sa. I a kaomannmannangana kia ke ba iau. Ba miau ka sana lomiaumatana kia. ");
INSERT INTO mee_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Iau ka laumatana kia, ta iau ka pa nge i, ba i ke ba iau.” ");
INSERT INTO mee_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ka ina ragau ke longe Iesus pangamologangana laeala, na ri keke bai ta launge. Ava ka sana agau te boea kamana te i, ta kae ae i ke sane lele tale. ");
INSERT INTO mee_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ava papatu nga maluame ka loreapatokona te i, ba keke rorole roma, “Ka inae Karais nge atu, na i sane la kumangng ka killa papatu reke bollalau nga agau laekia. Ka i ae Karais tapu ikia nanguni.” ");
INSERT INTO mee_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na ka inae Parisiome ke longe maluame ineke magungunu ka pangamologa nginngina re te Iesus, na ri kala nga piris re kapunu keke baꞌe ra kurtalingling re nga tempel ta ri launge. ");
INSERT INTO mee_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Nae Iesus ke role roma, “Iau ka la momong kala nge miau ka panna inte tale, na ngarume na iau ka la loanga te i e ba iau. ");
INSERT INTO mee_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Miau kaka la kelang te iau, ava ka sana ka la kalingpa kau. Ba ina iau la momong ngia, miau ka sana la loanga te.” ");
INSERT INTO mee_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nae Iurame keke palibalaglaga rea roma, “Ke meimia na ita sana ngaka kalipa kae aekia. I ke la loanga ta ina ngaetai? I nge loa te Iura reke momo nga iname kalaoka nga Girikme, ba nge palomatane Girikme ae? ");
INSERT INTO mee_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Pangamologanganame ine role roma, ‘Miau kaka la kelang te iau, ava ka sana ka la kalingpa kau,’ ba ‘Ina iau la momong ngia, miau ka sana la loanga te’ ka mirarea mina ngaetai?” ");
INSERT INTO mee_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ka kae a ronga a i a kae e bollau raumana nga kae re nga Kaning E Bollau E Nga Balvaleme, nae Iesus ke maisi ba ke pamologa kaligi ta ragau roma, “Ngaroma agau nga mate kana me, na i nge atu te iau na nge inu. ");
INSERT INTO mee_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Na me reke potpotu beke mauli keke la potungmalaga nga agau a lonapatokona te iau lona. Ollaeala ke loakurumea pangamologa ra ri ke pa rea pala nga Lau Ae Nutu Kanna.” ");
INSERT INTO mee_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ka inae Iesus role minmina na i ke rorolea pangamologa e ta Kannu Ae Nutu a ragau ra loreapatokona te i keke la ravunge ngarume. Ta Nutu ke sane tunge Kannu ae i kurumea, Iesus ke sane loagaliu ta Nutu mallena nga tava tale. ");
INSERT INTO mee_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ka ina ragau ke longe Iesus pangamologangana nginngina, na palu nge ri keke role roma, “Ka kaomannmannangana, aekia ka i agau laeala e toe Nutu kaona a i role pala ta i bange.” ");
INSERT INTO mee_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ba palu keke role roma, “Ka i ae Karais.” Ba palu muni keke role roma, “Karais sane nge pa ngae Galili, ");
INSERT INTO mee_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ta pangamologa a ri ke paꞌe pala nga Lau Ae Nutu Kanna ke role roma, Karais ke la leleng nge Revit sivuna memena. Ba ke role roma, i ke la panga nga maga kunna e bollau ae Betleem, a i ae Revit magapuna ae i.” ");
INSERT INTO mee_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Minmina na ragau pangamologangarea re te Iesus keke bai ka kalingpala ngaliua nge ri. ");
INSERT INTO mee_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ba palu keke bai ta launge, ava ka sana agau te boea kamana te i. ");
INSERT INTO mee_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Minmina na ra kurtalingling re nga tempel keke galiu ta piris re kapunu ba Parisiome, na ra nginngina keke ballage ra kurtalingling roma, “Ke meimia na ka sana ka atu kia te mangng?” ");
INSERT INTO mee_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Na ra kurtalingling keke ala rea roma, “Ka sana agau te pamologa basema agau laeo ka kae te.” ");
INSERT INTO mee_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Minmina na Parisiome keke ala rea roma, “Ke pataopa miau bole ae? ");
INSERT INTO mee_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ngaka kele. Ka sana te nga reke taoamugmuga ba nga Parisiome ora lonapatokona te i. Ke sa. ");
INSERT INTO mee_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Malua kokorong mana ra sana loreamatana ka bangapagame. Ka ri ra ragau rae Nutu la tungnge alanga e soali te ri.” ");
INSERT INTO mee_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nae Nikoremus, a i a agau ame pala ne loa te Iesus ba ka i a Parisio te bole, ke ballaga rea roma, ");
INSERT INTO mee_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Bangapaga rae ita ke sane ngeke kalinane agau ba nge tunge alang te i pala, ba ngarume na nge longe pangamologangana ba nga lonamatana ka oru ra i bavai rea. Ke sa.” ");
INSERT INTO mee_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Na keke ale ka mologangarea kia roma, “Ka one e ngae Galili bole ikolong ae? Ngo kela nga Lau Ae Nutu Kanna, na ka la longmatana roma, ka sana agau te e toe Nutu kaona ore pa ngae Galili.” ");
INSERT INTO mee_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ngarume na kenakena nge ri ke lao ta bale ae i. ");
INSERT INTO mee_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Avae Iesus ke loa ta Kapoponga Nga Bega Ra Oliv. ");
INSERT INTO mee_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ka sinro luluna na i ke lu lakallo ta malle re nga tempel muni, ba ragau kinung keke lola te i. Minmina na i ke tara ba ke paturu ta pangalomatana rea. ");
INSERT INTO mee_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ngarume, na ra pangalomatanakana nga bangapagame bae Parisiome keke atu ka avale a ri ke kalipa kia ine keno kala nga apanung a sana i a natale. Ba ka ina ri ke pamaisia ngamuga nga ragau tapu, ");
INSERT INTO mee_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","na keke role kae Iesus roma, “Apangalomatanakana, keke kalipa ka avale laekia ine keno kala nga apanung a sana i a natale. ");
INSERT INTO mee_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nga Bangapagame Moses ke role ta mangng nga tamalipune avale matana laekia ka lollo. Ava one ko role mina ngaetai?” ");
INSERT INTO mee_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ava ri keke ballage minmina ta avange nga baina ngeke kalipa ka pangamologangana te, na ngeke turupaga kana kia. Avae Iesus ke magolo lagape, na ke paꞌe pangamologa nga mogalo ka kamana ririna. ");
INSERT INTO mee_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ava ka ina ri ke umma ta balinglagange tale, na i ke meisi muni ba ke role kerea roma, “Agau e nge miau ora sana baingana te e soali nga i kapunu ta tamalinge avale laekolong ka lollo te.” ");
INSERT INTO mee_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Na i ke magolo lagape muni, ba ke paꞌe pangamologa nga mogalo. ");
INSERT INTO mee_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ka ine kuma minmina, na kenakena nga reke longe pangamologangana keke paturu ta laonga. Ba ragau re kapunu ta ri laonga ka ri ra ravollalaukerea memena. Minmina nae Iesus kasikena ke momo, ba avale laeala ke meisinsi nga inaeala a ri ke pamaisia ngia pala. ");
INSERT INTO mee_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nae Iesus ke meisi muni, ba ke role ka avale laeala roma, “Avale laekolong, ra ngama reke turupaga kang ka ri aetai? Ke meimia, ka sana agau te e nge ri momo ta tungnge alanga te te one?” ");
INSERT INTO mee_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Na avale laeala ke ale roma, “Avolau, ka sana agau te.” Nae Iesus ke role kia roma, “Iau bole sana la tungnge alanga te one. Ava ngo loa, na sano ngo baia bainga te e soali muni.” ");
INSERT INTO mee_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nae Iesus ke role ka ragau muni roma, “Ka iau a olamana e tungtunge olamana ta ragau re nga mogalo laekia e ngape. Agau e atu kurume iau ke sane la taonga nga osuguna. Ke sa. I ka la kana ka olamana e tunge mauling.” ");
INSERT INTO mee_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ka ine role minmina nae Parisiome keke role kia roma, “One muni ko turupotpota one, minmina na turungpotangang kone ka sana kaomanna kia.” ");
INSERT INTO mee_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nae Iesus ke ala rea roma, “Ngaroma iau nga turupotpota iau, na turungpotangau kau ka kaomanna kia kurumea, iau ka laumatana ka ina iau atu ngia. Ba ka laumatana ka ina iau la loanga te. Ava miau ka sana lomiaumatana ka ina iau atu ngia, ba ka sana lomiaumatana ka ina iau la loanga te bole. ");
INSERT INTO mee_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Miau kaka kalinanne agau te kurumea ragau loreamatana ngareangana mana, ava iau ka sana kalinanne agau te. ");
INSERT INTO mee_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ava ngaroma iau nga kalinana, na kalingnana ae iau ke tupu kurumea, iau kasikegu ka sana kalinana. Ke sa. Iau bae Tamau e ba iau, omea ka kalinana kinung. ");
INSERT INTO mee_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Keke paꞌe pangamologa nga Bangapaga ae miau muni ore role roma, ngaroma ragau lua ngeke turupota kinung ka pangamologa te, na pangamologa laeala a kanrea ka kaomannmannangana kia ");
INSERT INTO mee_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ka iau e kapunu ta turungpota iau, bae Tamau e ba iau ka i a aturungpotakana a lua.” ");
INSERT INTO mee_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Minmina na ri keke ballage roma, “Tamang ka i aetai?” Nae Iesus ke ala rea roma, “Miau ka sana lomiaumatana kau, ba ka sana lomiaumatana kae Tamau bole. Taroma miau ta lomiaumatana kau, na ta lomiaumatana kae Tamau bole.” ");
INSERT INTO mee_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesus ke rolea pangamologa nginngina ka ine palomatantane ragau nga malle re nga tempel kokoro ta inaeala a ragau ke tungtunge tungame ngia. Ava ka sana agau te laue kurumea, kae ae i ke sane lele tale. ");
INSERT INTO mee_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nae Iesus ke role kerea muni roma, “Iau ka la loanga, na miau kaka la silingi iau, ba kaka la momong nga bainga ae miau e soali ta nge lele ina miau nga mate. Ina iau la loanga te, ka sana ka la loanga te.” ");
INSERT INTO mee_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ka ina Iurame ke longe pangamologangana laeala, na keke palibalaglaga rea roma, “Ke meimia, i ke la samungpununge i muni ae? Minmina na i ke rolea pangamologa laekia roma, ina i la loanga te, ita ka sana ka la loanga te ae?” ");
INSERT INTO mee_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Bae Iesus ke role kerea bole roma, “Miau, ka miau re ngape, ava iau, ka iau e ngailu. Ka miau re nga mogalo laekia e ngape, ava ka sana iau e nga mogalo laekia e ngape. ");
INSERT INTO mee_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Minmina na iau ka role kamiau roma, kaka la momong nga bainga rae miau reke sosoali ta nge lele ina miau nga mate. Ngaroma miau sana nga lomiaupatokona roma, ka iau a agau amae Nutu patokala pala ta i bange, na miau kaka la momong nga bainga rae miau reke sosoali ta nge lele ina miau nga mate.” ");
INSERT INTO mee_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Na keke ballage roma, “Ka one a tai?” Nae Iesus ke ala rea roma, “Ama role kamiau ka pangamologa a taru pala? ");
INSERT INTO mee_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Iau ka kanau ka pangamologa papatu re ta kalingnana miau ki. Ava ka sana ri ra pangamologa ra kanegu mana. Ke sa. I e ba iau ka kaomannmannangana kia, ba iau ka longe pangamologame nge i. Ba ka ri ra pangamologa nginngina mana ra iau tuturu rea ta ragau re nga mogalo laekia e ngape.” ");
INSERT INTO mee_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ava ragau nginngina reke longlonge Iesus pangamologangana ka sana loreamatana roma, i ke rorole kerea te Tamana. ");
INSERT INTO mee_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Minmina nae Iesus ke role roma, “Nga ina miau ngaka kinpataea Agau Tuna lakailu nga maiskovu tapu, na miau ka la lomiaumatana roma ka iau a agau amae Nutu patokala pala ta i bange. Ba ka la lomiaumatana roma iau ka sana bavaia otte kurumea iau muni laumatanangana, ava ka rorolea pangamologa rae Tamau palomatana iau ki mana. ");
INSERT INTO mee_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ba i e ba iau ke momo kala nge iau. Ke sane ka mana iau, ta iau ka kumkuma palimule ka oru ra i mate rea.” ");
INSERT INTO mee_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ka inae Iesus umma ta rolenge pangamologa nginngina tale, na ragau papatu ka loreapatokona te i. ");
INSERT INTO mee_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Minmina nae Iesus ke role kae Iura ra loreapatokona te i roma, “Ngaroma ngaka kamopite pangalomatanangau, na ka miau ra barangalele ra kanau mannangana. ");
INSERT INTO mee_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Na ka la lomiaumatana ka pangamologa ora kaomannmannangana kia, ba pangamologa ora kaomannmannangana kia ke la ulongmalaga miau nga oru reke bai ka miau ta miau ra kumangngatulu.” ");
INSERT INTO mee_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Na keke ale roma, “Ka mangng rae Abaram sivuna memena ba ka sana mangng ra kumangngatulu ra agau te kanna ka kae te. Ke meimia na ko role roma, mangng nga kapatali nga oru reke bai ka mangng ta mangng ra kumangngatulu?” ");
INSERT INTO mee_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nae Iesus ke role kerea roma, “Iau nga role kamiau ka kaomannmannangana roma, agau e bavaia bainga e soaling ka i a akumangngatulu ora bainga e soali kanna. ");
INSERT INTO mee_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ba akumangngatulu ka sana mallena mannangana nga balekaina. Ava balekaina tamana tuna ka mallena nga balekaina ore momo passavele. ");
INSERT INTO mee_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Minmina na ngaroma Nutu Tuna nge ulomalaga miau, na miau ngaka kapatali mannangana nga oru reke bai miau ta miau ra kumangngatulu. ");
INSERT INTO mee_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Iau ka laumatana kamiau roma, ka miau rae Abaram sivuna memena. Ava kaka bai ta samungpunu iau kurumea, pangamologa a kanau ke sane momo ngallo nge miau. ");
INSERT INTO mee_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Iau ka rorolea oru ra iau kela rea ina iau momo kala nge Tamau, ba miau kaka kumkuma ka oru ra miau ka longo rea nge tamamiau.” ");
INSERT INTO mee_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Na ri keke ale roma, “Ka tamamangng nge Abaram.” Nae Iesus ke ala rea roma, “Ngaroma nga miau rae Abaram sivuna memena ka kaomannmannangana, na ngaka kumkuma ka bainga rae Abaram kuma ki. ");
INSERT INTO mee_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ava miau ka sana kumkuma minmina. Ke sa. Kaka bai ta samungpunu iau a agau e role kamiau ka pangamologa ora kaomannmannangana kia a iau longe nge Nutu. Abaram ke sane kuma minmina. ");
INSERT INTO mee_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Miau kaka kumkuma ka tamamiau bainganame.” Na ri keke kauli ka rolengareangana kia roma, “Mangng ka sana lele nga avale a siana lau nga pamau. Ke sa. Ka tamamangng nge Nutu mana.” ");
INSERT INTO mee_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nae Iesus ke role kerea roma, “Ngaroma nga tamamiau nge Nutu ka kaomannmannangana, na miau ngaka materaumana iau, ta iau ka pa nge Nutu na ka momo ikia. Iau ka sana atu mana ka laungana. Ke sa. I ke ba iau. ");
INSERT INTO mee_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Miau ka sana lomiaumatana ka oru ra iau rorole rea kurumea, miau kaka longpalikovauu ka pangamologangau. ");
INSERT INTO mee_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ka miau ra goe rae tamamiau ae Satan, ba kaka bai ta kumangng ka oru ra tamamiau mate rea. I ka i a abalingpunukana pala nga orume pangaturu ngareangana. Ba ke sane kamopitpite pangamologa ora kaomannmannangana kia kurumea, ka sana pangamologa ora kaomannmannangana kia inte momo ngallo nge i. Ka ine goga na i ke turupotpote oru reke momo ngallo nge i. Ta i ka i a agoangakana ba ka i a goangame tamarea. ");
INSERT INTO mee_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ava miau ka sana lomiaupatokona ta pangamologangau kurumea, iau ka rorolea pangamologa ora kaomannmannangana kia. ");
INSERT INTO mee_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Miau rigau te nge pakosining ka baingau te e soali. Ngaroma pangamologangau nga kaomannmannangana kia, na ke meimia na miau ka sana lomiaupatokona te? ");
INSERT INTO mee_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Agau ae Nutu ke longlonge onrae Nutu rorole rea. Ava miau ka sana ka longlongo rea, ta ka sana miau ra ragau rae Nutu.” ");
INSERT INTO mee_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nae Iurame keke ale roma, “Mangng ka role ka kaomanna roma, ka one ae Sameria te ba kannu e soali ke lu one.” ");
INSERT INTO mee_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nae Iesus ke ala rea roma, “Kannu e soali ke sane lu iau. Ke sa. Iau ka kalapagpage Tamau, ava miau kaka rorolebainga kau. ");
INSERT INTO mee_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ba iau ka sana amva ta kiningpataenge giau, ava ka te ore kinpataetaea, ba i ka i a akalingnanakana. ");
INSERT INTO mee_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Iau nga role kamiau ka kaomannmannangana roma, agau a lonapatokona be lolakurumea pangamologangau ke sane la kelange mateng.” ");
INSERT INTO mee_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ka ine role minmina nae Iurame keke role kia roma, “Ikia na ka lomangngmatana mannangana roma kannu e soali ke lu one. Abaram ke mate, ba ragau reke toe Nutu kaona keke mate bole. Ava one ko role roma, agau a lonapatokona be lolakurumea pangamologangang ke sane la kaningmainge mateng. ");
INSERT INTO mee_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ko roma one a bollau nga tamamangng ae Abaram ae? I ke mate ba ragau reke toe Nutu kaona keke mate bole. Ko roma one a tai mannangana ikolong?” ");
INSERT INTO mee_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nae Iesus ke ala rea roma, “Ngaroma iau nga kinpataetaea giau, na kiningpataengau laeala ka sana puna. Avae Tamau, a miau ka role roma ka i ae Nutu ae miau, i muni ka i e kinpataetaea giau. ");
INSERT INTO mee_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Miau ka sana lomiaumatana kia, ava iau ka laumatana kia. Ba ngaroma iau nga role roma iau ka sana laumatana kia, na nga iau a goangkana baseme miau. Ava iau ka laumatana kia ka kaomannmannangana, ba ka lolakurumea pangamologa a kanna. ");
INSERT INTO mee_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tamamiau ae Abaram ke momalle kae ae iau ka serengngana, ba i ke kele na ke serengkale.” ");
INSERT INTO mee_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Minmina na Iurame keke role kia roma, “Ka sana kang pesingmataname ka ri 50 tale, ava ko role roma one ko kele Abaram ae?” ");
INSERT INTO mee_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nae Iesus ke ala rea roma, “Iau nga role kamiau ka kaomannmannangana roma, pala, ka inae Abaram naname sane toapisigia tale, na iau ka momo tapu.” ");
INSERT INTO mee_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ka ine role minmina, na ri keke rave lollome ta ri tamalinge ki. Avae Iesus ke ko nge ri, na ke lelemalaga nga tempel. ");
INSERT INTO mee_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ka inae Iesus tatao, na i ke kele apanung te e pala na naname ke toapisigia ka matana kanna sungana. ");
INSERT INTO mee_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Na barangalele ra kanna keke ballage roma, “Rabai, tai ke baia bainga e soali, na apanung laekia naname ke toapisigia ka matana kanna sungana? Ka puna nge tai, apanung laekia o tamana bae naname?” ");
INSERT INTO mee_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nae Iesus ke ala rea roma, “Ka sana apanung laekia baia bainga e soali, ba ka sana tamana bae naname bole. Ke sa. Ollaekia ke lele ta baina kumangng rae Nutu kanna ngeke pota nge i. ");
INSERT INTO mee_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ita ngaka kumkuma ka kumangnga rae i e ba iau kanna ka ina kae momo tale. Osuguna ke la atung, na agau sane la kumangng. ");
INSERT INTO mee_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ka ina iau mommo nga mogalo laekia, na ka iau a olamana e tungtunge olamana ta re nga mogalo laekia e ngape.” ");
INSERT INTO mee_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ka ine role minmina tapu, na i ke utupai nga mogalo ba ke kuma ka mogalo a nala ka kaona mena. Na ke pulia nga apanung laeala matana kanname. ");
INSERT INTO mee_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Na i ke role kia roma, “Ngo loa, na ngo magoe kang nga liu ae Siloam” (Siloam ka mirana roma, keke Baꞌe). Minmina na apanung laeala ke loa ba ke magoe, na ke galiu ta bale ae i ka kelangana. ");
INSERT INTO mee_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Na ragau reke momo nga baleme kokoro te i, ba ragau reke kelkele ina i a akangalunga lollokannakana pala keke palibalaglaga rea roma, “Aekia ame tattara be kalunglung ta lollokanna ae?” ");
INSERT INTO mee_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Na palu nge ri keke role roma, “Iii, aeala mana gai.” Ba pattoto keke role roma, “Ke sa. Ka sinna me i mana.” Ava apanung laeala muni ke umma ta roleng roma, “Iau laeala mana ikia.” ");
INSERT INTO mee_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Minmina na keke balaglage roma, “Ava matang kanname keke pe mina ngaetai?” ");
INSERT INTO mee_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Na i ke ala rea roma, “Agau laeala eke patoe kae Iesus ke kuma ka nala na ke ule nga matau kanname. Na ke role kau roma, ‘Ngo loa tae Siloam, na ngo magoe kang.’ Minmina na iau ka loa ba ka magoe, na matau kanname keke kela.” ");
INSERT INTO mee_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Na keke ballage roma, “Ava agau laeala ke momo aetai?” Na i ke ala rea roma, “Ka sana laumatana.” ");
INSERT INTO mee_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ngarume na keke loa ka apanung laeala e pala na matana kanname ke su te Parisiome. ");
INSERT INTO mee_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na kae laeala ae Iesus kuma ka nala, ne papea apanung laeala matana kanname ka i a kae a Sabat. ");
INSERT INTO mee_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Minmina nae Parisiome keke balaglage apanung laeala bole roma, “Ko kela mina ngaetai?” Na i ke ala rea roma, “Agau laeala ke ule nala nga matau kanname, ba iau ka magoe, na sonrau iau ka kela.” ");
INSERT INTO mee_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nae Parisio palu keke palirorole kerea ka rolengtunanangarea kae Iesus roma, “Agau laeala ke sane pa nge Nutu, ta i ke sane lolakurumea bangapaga e nga pannang nga kae a Sabat.” Ava pattoto keke role roma, “Ava agau a baingana soali sana nga likina ta kumangng ka killa reke bollalau ra agau laeala kumkuma ki.” Minmina na kalingpala ke lele ngaliua nge ri. ");
INSERT INTO mee_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ka baina keke role muni ka apanung laeala e pala na matana kanname ke su roma, “One ko roma, agau laeala ke papea matang kanname. Minmina na nga kelangang kia, ka i a agau matana e meimia?” Na i ke role kerea roma, “Ka i a agau te e toe Nutu kaona.” ");
INSERT INTO mee_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ava Iurame ka sana loreapatokona roma, apanung laeala matana kanname ke su pala, ba ngarume na i kela. Minmina na ri keke kiue apanung laeala ae Iesus papea matana kanname tamana bae naname ta ri atung, ta baina ri nga loreamatana roma, ollaeala ka kaomanna o ke sa. ");
INSERT INTO mee_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Na keke ballage tamana bae naname roma, “Apanung laekia ka i a tumiau amaka role roma, matana kanname ke su ina naname toapisigi ae? Ava ke meimia na i ke kelkela sonrau?” ");
INSERT INTO mee_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nae tamana bae naname keke ala rea roma, “Ka lomangngmatana roma, apanung laekia ka i a tumangng. Ba ka lomangngmatana roma, matana kanname keke su ina naname toapisigia. ");
INSERT INTO mee_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ava ka sana lomangngmatana roma, ke meimia ka kelangana sonrau, ba tai ke papea matana kanname. Ngaka ballage, ta i ke bollau tapu, ba i nge ture i muni.” ");
INSERT INTO mee_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ri keke role minmina kurumea, keke mataue reke taoamugmuga kae Iurame. Ta reke taoamugmuga kae Iurame keke potopita tapu roma, ngaroma agau te nge turupote lonapatokonangana te Iesus roma ka i ae Karais, na ri ngeke pulimalage lagapotu nga sinagog. ");
INSERT INTO mee_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Minmina nae tamana bae naname keke role roma, “Miau ngaka ballage, ta i ke bollau tapu.” ");
INSERT INTO mee_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ngarume nae Parisiome keke kiu muni ka apanung laeala e pala na matana kanname ke su, na keke role kia roma, “Ngo role ka kaomannmannangana nge Nutu raguna. Mangng ka lomangngmatana roma, agau laeala ka i a agau a baingana soali.” ");
INSERT INTO mee_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Na i ke ala rea roma, “Iau ka sana laumatana, ka i a agau a baingana soali o ke sa. Iau ka laumatana ka oru kena mana roma, pala na matau kanname ke su ava sonrau na iau ka kelkela.” ");
INSERT INTO mee_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ka baina ri keke ballage roma, “Ke kuma ka taru nge one? Ke papea matang kanname mina ngaetai?” ");
INSERT INTO mee_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Na i ke ala rea roma, “Ka role paka miau tapu ava ka sana ka longo. Ke meimia na kaka bai ta longa muni? Kaka bai ta leleng miau ra barangalele ra kanna bole ae?” ");
INSERT INTO mee_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ka ina ri ke longe pangamologangana nginngina na keke rolebainga kia ba keke role kia roma, “Ka one a barangalele a kanna, ava ka mangng ra barangalele rae Moses kanna. ");
INSERT INTO mee_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mangng ka lomangngmatana roma Nutu ke pamologa te Moses, ava agau laeala, ka sana lomangngmatana roma i ke pa nga ine ngaetai.” ");
INSERT INTO mee_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Na apanung laeala ke ala rea roma, “Ka magio kau raumana nga oraekia! Miau ka sana lomiaumatana ka ine pa ngia, ava i ke papea matau kanname. ");
INSERT INTO mee_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ita ka loramatana roma, Nutu ke sane longlongo ta ragau ra baingareame ke sosoali. Ke sa. Ke longlongo ta agau e matautaue be lolakurumea lonangana. ");
INSERT INTO mee_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ka sana ragau ke longe pangamologa te minakai pala ina agau te papea agau matana kanname ora naname toapisigia ka matana kanna sungana. ");
INSERT INTO mee_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Taroma agau laeala sane te pa nge Nutu, na ale sane te kuma ka otte.” ");
INSERT INTO mee_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ka ine role minmina, na ri keke role kia ka iukereangana kia roma, “Bainga reke sosoali keke ponu nge one inae name toapisigi one, ba ko roma ono bai ta pangalomatana mangng ae? Ke sa bavakena!” Na keke pulimalage lagapotu. ");
INSERT INTO mee_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nae Iesus ke longe ineke pulimalage apanung laeala lagapotu. Ba ka ine kalipa kia, na i ke role kia roma, “Ka longopatokona te Agau Tuna, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Na apanung laeala ke ballage roma, “Avolau, tai ka i ae Agau Tuna a one rorole te? Onto panana kia, nga baina nga laupatokona te i.” ");
INSERT INTO mee_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nae Iesus ke role kia roma, “Ikia o elle gialgiala, ba bole i ke pamolloga te one.” ");
INSERT INTO mee_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Na apanung laeala ke role roma, “Avolau, ka laupatokona te one!” Na i ke umma ta parong banu ka kiningpataengana kae Iesus giana. ");
INSERT INTO mee_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Bae Iesus ke role roma, “Iau ka atupisigi ta mogalo laekia e ngape ta kumangng ka kalingnana, ta baina ragau ra matarea kanname ke su ngeke kelkela ba ragau ra matarea kanname ke kelkela ngeke lele ra matasu.” ");
INSERT INTO mee_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ka inae Parisio palu reke momo kala nge i ke longe pangamologangana nginngina, na keke ballage roma, “Ko rorole roma, ka mangng ra matasu bole ae?” ");
INSERT INTO mee_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Nae Iesus ke ala rea roma, “Ngaroma matamiau kanname ngeke su, na baingamiaume sane ngeke sosoali. Ava sonrau na kaka role roma, kaka kelkela. Minmina na baingamiaume reke sosoali keke momo tale.” ");
INSERT INTO mee_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Nae Iesus ke role kerea roma, “Iau nga role kamiau ka kaomannmannangana roma, agau e sane lu nga savanau e nga sipsipme kana biunga, ava nge taetao nga inte toto, agau laeala ka i a agolongkana ba agau e kaka ka onra ragau kanrea. ");
INSERT INTO mee_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ava agau e lu nga biunga ka i a sipsipme kelangpatali ae ri. ");
INSERT INTO mee_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ka i a agau ora agau e ella ta savanau kana biunga nge pulapatalia biunga te i. Ba ka i a agau ora sipsipme ke longopatokonkone kalingngana. I ke patpatoe sipsip kenakena ae i giana, ba ke taoamugmuga kerea lagapotu. ");
INSERT INTO mee_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ka ina i nge lelemalaga tapu ka sipsip rae i kinung, na i ke la taongamuga kerea. Ba ri ngeke lolakurumea, ta ri keke longopatokone kalingngana tapu. ");
INSERT INTO mee_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ava ri ke sane ke la loangakurumea agau a pau a ri sana loreamatana kia. Ke sa. Keke la kanga nge i, ta ri ke sane ke longopatokone agau a pau kalingngana.” ");
INSERT INTO mee_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesus ke pamologa ka pangateningkala laekia, ava ragau ka sana loreamatana ka taru a i rorole kerea te. ");
INSERT INTO mee_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Minmina nae Iesus ke role kerea muni roma, “Iau nga role kamiau ka kaomannmannangana roma, ka iau a biunga ae sipsipme. ");
INSERT INTO mee_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ragau kinung reke atu pala nge iau ka ri ra ragolongkana ba ragau reke kaka ka onra ragau kanrea. Ava sipsipme ke sane ke longlongo te ri. ");
INSERT INTO mee_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ka iau a biunga. Agau e lu lakallo nge iau ke la penga. Ba i nge lulu ba nge lelemalaglaga, ba ke la kalingpa ka kaning e pe raumana. ");
INSERT INTO mee_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Agau agolongkana ke atu mana ta i golongo, ba samungpunu, ba ta i baingasoalinge sipsipme. Ava iau ka atu ta baina ri ngeke rave mauling, ba ngeke rave mauling e ponutalao. ");
INSERT INTO mee_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ka iau a sipsipme kelangpatali ae ri ore pe. Sipsipme kelangpatali ae ri e pe nge tunge i muni maulingngana ta mateng ta kalaunge sipsipme. ");
INSERT INTO mee_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Agau e kumamana ta kuru ava sana i a kelangpatali ae sipsipme mannangana, ba ka sana ri ra sipsip rae i, nge kele gauve a pinolo ine tatu, na nge kaꞌe sipsipme ba nge kaka. Minmina na gauve a pinolo nge pira ta korange sipsipme, na nge bai rea ta ri kanga kalaoveka. ");
INSERT INTO mee_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Agau laeala ke la kanga ta i ke kumkuma mana ta kuru, ba sipsipme ka sana ri ra otte te i. ");
INSERT INTO mee_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Ka iau a sipsipme kelangpatali ae ri e pe. Iau ka laumatana ka sipsip rae iau, ba sipsip rae iau ka loreamatana kau. ");
INSERT INTO mee_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ollaeala ka tongana kena ma inae Tamau ka lonamatana kau, ba iau ka laumatana kae Tamau. Ba iau nga tunge maulingau ta mateng ta kalaunge sipsipme. ");
INSERT INTO mee_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Iau ka kau ka sipsip pattoto bole ra sana ri ra sipsip re nga sipsip barana laekia. Iau ka la atung kerea bole, ba ri keke la longa ta kalingau. Ba keke la ginunga kala nga sipsip barana laekia ta ri leleng barana kena a kana ka kelangpatali kena. ");
INSERT INTO mee_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tamau ke materaumana iau ta iau ka lolakurumea lonangana. Minmina na iau nga tunge maulingau ta mateng, ta baina nga ravugaliue maulingau muni. ");
INSERT INTO mee_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ka sana agau te kapatali ka maulingau. Ke sa. Iau nga tunge kurumea iau muni laungana. Iau ka kau ka gingginga ta tungnge, ba ka kau ka gingginga ta ravunggaliunge muni. Iau ka rave bangapaga laeala nge Tamau.” ");
INSERT INTO mee_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ka ina Iesus rolea pangamologa nginngina, na kalingpala ke lele muni ngaliua nga Iurame. ");
INSERT INTO mee_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Na papatu nge ri keke rorole roma, “Kannu e soali ke luia, na ke baigaugau. Sana ngaka longo te i.” ");
INSERT INTO mee_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ava pattoto keke rorole roma, “Agau a kannu e soali luia sane nge pamolloga minmina. Ka sana kannu te e soali kana ka gingginga ta pangapenge agau a matasu matana kanname.” ");
INSERT INTO mee_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ngarume, na kaning e bollau a ri ke patoe ka Anaka ke lele ngae Ierusalem. ");
INSERT INTO mee_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Keke baia kaning laeala e bollau ka kae reke marusu. Bae Iesus ke tatao nga malle re nga tempel, na ke taolu nga malle te ora ragau ke tattaralu ngia, a ri ke patoe kae Tarangalu Ae Solomon. ");
INSERT INTO mee_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Minmina nae Iurame keke maistaliue, na keke role kia roma, “Ko la baingalopalilli kamangng pa pia? Ngaroma one ae Karais, na ngo role paka mangng nga karakarangana gialgiala.” ");
INSERT INTO mee_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nae Iesus ke ala rea roma, “Iau ka role kamiau tapu, ava ka sana lomiaupatokona ta pangamologangau. Kumangng rae iau kumkuma ki nge Tamau giana, kumangng nginngina mana keke turupotpota iau. ");
INSERT INTO mee_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ava miau ka sana lomiaupatokona te iau kurumea, ka sana miau ra sipsip rae iau. ");
INSERT INTO mee_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipsip rae iau keke longlongo ta kalingau. Iau ka laumatana kerea, ba ri keke tatukurume iau. ");
INSERT INTO mee_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Iau ka tungtunge mauling e momo passavele te ri, ba ke sane ke la saningrea. Ba sana nga agau te nge saipita kerea nga kamau lagapotu. ");
INSERT INTO mee_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tamau e tungu rea te iau ke bollau raumana nga orume kinung. Sana nga agau te nge saipita kerea nge Tamau kamana lagapotu. ");
INSERT INTO mee_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Iau bae Tamau ka mangng pana kena.” ");
INSERT INTO mee_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ka ine role minmina nae Iurame keke rave lollome muni ta ri tamalinge ki. ");
INSERT INTO mee_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Avae Iesus ke role kerea roma, “Iau ka pakosining miau ka killa papatu reke bollalau rae Tamau tungu rea ta iau kumangng ki. Kaka bai ta tamaling iau ka lollome kurumea kelang ngamiaungana ka killa a taru nga killa nginngina?” ");
INSERT INTO mee_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nae Iurame keke ale roma, “Mangng sana la tamaling one ka lollome kurumea kumangngang ka killa nginngina. Ke sa. Mangng ka la tamaling one kurumea rolebaingang kae Nutu, nga ina one a agau mana ko bai one muni ma one ae Nutu.” ");
INSERT INTO mee_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nae Iesus ke ala rea roma, “Keke paꞌe Nutu pangamologangana nga Bangapaga ae miau e role roma, ‘Iau ka role roma, ka miau ra nutume.’ ");
INSERT INTO mee_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nga pangamologa laeala Nutu ke patoe ragau reke rave pangamologa a kanna ka ‘nutume’ (ba pangamologa reke momo nga Lau Ae Nutu Kanna ka sana nga inte ngeke osurure). ");
INSERT INTO mee_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Minmina na sana ngaka role ka agau ae Tamau tore be bapisigia ta mogalo laekia e ngape roma, ‘Ko rolebainga kae Nutu,’ kurumea rolengau ka pangamologa laeala roma, ‘Ka iau ae Nutu Tuna’. ");
INSERT INTO mee_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ngaroma iau sana nga kumkuma ka kumangng rae Tamau kanna, na sana nga lomiaupatokona ta pangamologa ra kanegu. ");
INSERT INTO mee_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ava ngaroma iau nga kumkuma ki, ba ngaroma nge baililli ta miau lomiaupatokona ta pangamologa ra kanegu, na nga lomiaupatokona ta kumangng nginngina rae iau kumkuma ki. Nga lomiaupatokona ta baina ngaka rave lomatana. Ba nga lomiaumatana mannangana roma, Tamau ke momo ngallo nge iau ba iau ka momo ngallo nge Tamau.” ");
INSERT INTO mee_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ka inae Iesus role minmina na keke ava muni ta ri launge. Ava i ke kavesilele rea na ke lao. ");
INSERT INTO mee_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ngarume nae Iesus ke galiu muni ta Me Ae Ioran bavana tetoto, ta inaeala e kapunu ae Ion pamagoegoea ragau ngia pala. Na i ke momo nga inaeala, ");
INSERT INTO mee_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ba ragau papatu keke loa te i. Na keke rorole roma, “Ion ke sane kuma ka killa te e bollau, ava pangamologanganame kinung re ta agau laekia ka kaomannmannangana ki.” ");
INSERT INTO mee_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ba nga inaeala ragau papatu ka loreapatokona te Iesus. ");
INSERT INTO mee_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Na ka apanung te a giana nge Lasarus ke soali. Ka i e nga maga ae Betani. Ba Betani ka i a maga ae Maria bae tataokia ae Marta. ");
INSERT INTO mee_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Bae Maria laekia, a liuna ae Lasarus kana ka soaling, ka i a avale laeala ame pala ne kelingia saulang a koina masi nge Iesus kaename ba ke taupunu rea ka gilina bulvunna. ");
INSERT INTO mee_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Minmina nae liuna piau memename keke ba ka pangamologa te Iesus roma, “Avolau, agau ama one materaumane ke soali.” ");
INSERT INTO mee_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ava ka inae Iesus longe pangamologa laeala, na i ke role roma, “Soaling laekia ke sane lele ta baina apanung laeala nge mate mana. Ke sa. Ke lele ta pangavolaunge Nutu giana, ta baina Nutu Tuna nge rave gia bolinglaungana kia.” ");
INSERT INTO mee_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nae Iesus ke materaumane Marta bae teiteikia ae Maria bae Lasarus. ");
INSERT INTO mee_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ava ka ine longe pangamologa laeala e ta Lasarus soalingana, na i ke momo ka kae lua muni nga inaeala a i momo ngia. ");
INSERT INTO mee_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ngarume na i ke role ka barangalele ra kanna roma, “Ita ngaka galiu tae Iurea.” ");
INSERT INTO mee_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Na ri keke ale roma, “Rabai, ngallao mana nae Iurame ameke bai ta tamaling one ka lollome. Ko meimia na ko bai ta galiunga ta inaeala muni?” ");
INSERT INTO mee_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nae Iesus ke ala rea roma, “Kae ka lamana ka kae mataname ka ri tangulelu ba lua mana. Agau e tatao nga kae lamana sane nge pupu, ta i ke tatao nga mogalo laekia e ngape kana olamana. ");
INSERT INTO mee_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ava agau e tatao ka rigo ke umma ta pupunga kurumea, sana olamana ngallo nge i.” ");
INSERT INTO mee_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ka inae Iesus role minmina tapu, na i ke role kerea roma, “Kolingara ae Lasarus ke kenrau, ava iau ka la loanga ta pangonge.” ");
INSERT INTO mee_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Na barangalele ra kanna keke ale roma, “Avolau, ngaroma i nge kenrau, na i ke la penga.” ");
INSERT INTO mee_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Avae Iesus ke sane rorole ta Lasarus kenangaraungana. Ke sa. I ke rorole ta Lasarus matengana, ava barangalele ra kanna ka loreangana roma i e rorole ta agau e kenrau mana. ");
INSERT INTO mee_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Minmina nae Iesus ke papote pangamologangana mirana nga karakarangana roma, “Lasarus ke mate tapu. ");
INSERT INTO mee_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ba ka lausereng nga ina sana momo nga inaeala, ta ollaekia ke la pangagingginge lopatokona ae miau te iau. Ava ita ngaka loa te i.” ");
INSERT INTO mee_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nae Tomas (a ri ke patoe kae Ririmas) ke role ka kolingana memena ra ri kinung ra barangalele rae Iesus kanna roma, “Ita ngaka loa bole, nga baina ita ngaka mate kala nge i.” ");
INSERT INTO mee_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ka inae Iesus lele, na i ke longe pangamologa e te Lasarus ine momo nga malle a reke mate ka kaeme ka ri tugulu tapu. ");
INSERT INTO mee_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bae Betani ke momo lagapotu ngae Ierusalem basema pamau bename ka ri mologi mana. ");
INSERT INTO mee_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Minmina nae Iura papatu keke loa te Marta bae Maria ta ri pangalopenge loreame kurumea ri lua loreataningana kae liurea. ");
INSERT INTO mee_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ka inae Marta longe inae Iesus tatu, na ke loa te i. Avae Maria ke momo nga bale. ");
INSERT INTO mee_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ba ka inae Marta lele nge Iesus, na i ke role kia roma, “Avolau, taroma one to momo nakai, nae ligu sane te mate. ");
INSERT INTO mee_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ava ka laumatana roma, ngaroma one ngo ballage Nutu ta i kumangng ka otte gialgiala bole, na i nge tunge te one.” ");
INSERT INTO mee_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Nae Iesus ke role kia roma, “Liung ke la sigingpaga muni.” ");
INSERT INTO mee_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nae Marta ke ale roma, “Iau ka laumatana roma, i ke la sigingpaga muni ina reke mate ke la sigingpaga nga mateng ka kae a ronga.” ");
INSERT INTO mee_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nae Iesus ke role kia roma, “Ka iau a sigingpaga nga mateng puna, ba ka iau a mauling puna. Agau a lonapatokona te iau ave mate ke la mauling. ");
INSERT INTO mee_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ba agau e momomauli ba lonapatokona te iau ke sane la mateng. One ka longpatokona ta pangamologa laeala, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nae Marta ke ale roma, “Iii Avolau, iau ka laupatokona roma, ka one ae Karais. Ba ka laupatokona roma, ka one ae Nutu Tuna ae Nutu baꞌe ta mogalo laekia e ngape.” ");
INSERT INTO mee_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ka inae Marta role minmina tapu, na i ke kagaliu ba ke kiue teiteikia ae Maria balakala. Na ke role kia roma, “Apangalomatanakana iale tatu, ba i ke balaglaga te one.” ");
INSERT INTO mee_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ka inae Maria longe pangamologa laeala, na i ke sigipaga bolvole na ke lola te Iesus. ");
INSERT INTO mee_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Avae Iesus ke sane lele nga maga tale. I ke momo tale nga inaeala ae Marta kalipa kia ngia. ");
INSERT INTO mee_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ba ka inae Iura reke momo nga bale kala nge Maria beke umma ta pangalopenge lona keke kele ine sigipaga bolvole be lelemalaga, na keke loakurumea. Ta ri ka loreangana roma, i e lola ta malle a reke mate ta taning nga inaeala. ");
INSERT INTO mee_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Na ka inae Maria lele nga inae Iesus momo ngia, na i ke loa te i ba ke pupu nga kaena puna. Na ke role kia roma, “Avolau, taroma one to momo nakai, nae ligu sane te mate.” ");
INSERT INTO mee_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ka inae Iesus kele Maria ine tantani bae Iura reke atu kurumea Maria ineke tantani bole, na i ka lonatani ba ke kanimaia maenang ngallo nge i. ");
INSERT INTO mee_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Na ke ballaga rea roma, “Kaka pakenoe nga ine ngaetai?” Na keke ale roma, “Avolau, atu ngo kele.” ");
INSERT INTO mee_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nae Iesus ke tani. ");
INSERT INTO mee_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Minmina nae Iurame keke role roma, “Ngaka kele. I ke matea Lasarus raumana!” ");
INSERT INTO mee_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ava palu nge ri keke role roma, “Aekia ame pala ne papea agau a matasu matana kanname, ava ke meimia na i ka sana likina ta bainga ka apanung laekia ta i nga manenasa mateng?” ");
INSERT INTO mee_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Minmina nae Iesus ke kanimaia maenang muni ngallo nge i, na ke lele nga malle a agau e mate. Ka i a baveng eke biukale kaona ka lollo te. ");
INSERT INTO mee_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nae Iesus ke role kerea roma, “Ngaka patalele patali ka lollo laekolong.” Avae Marta a i a agau e mate liuna piau ke role kae Iesus roma, “Avolau, ala koina bona ta ka kana kae tugulu tapu.” ");
INSERT INTO mee_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nae Iesus ke ale roma, “Iau ama role kone tapu roma, ngaroma nga longopatokona, na ko la kelange Nutu ginggingngana.” ");
INSERT INTO mee_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Minmina nae keke patalele patali ka lollo. Nae Iesus ke kela lakailu ba ke role roma, “Tamau, iau ka kinpataetaea giang kurumea ino longe pangamologangau. ");
INSERT INTO mee_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Iau ka laumatana tapu roma, ko longlonge pangamologangau ka kaeme kinung. Ava iau ka role minmina ta baina reke meisinsi ikia ngeke longo, na nga loreapatokona roma one ko ba iau.” ");
INSERT INTO mee_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ka ine rolea pangamologa nginngina tapu, na i ke kiu kaligi roma, “Lasarus, ngo lelemalaga.” ");
INSERT INTO mee_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Na agau laeala e mate ke lelemalaga ka piungapita ngareangana ka kamaname ba kaename ka malo iname, ba ka rugungpita ngareangana ka raguna ka malo inte. Minmina nae Iesus ke role kerea roma, “Ngaka luvarure malo iname ta baina nge tao.” ");
INSERT INTO mee_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Minmina na ragau papatu nga Iura nginngina reke loa ta kelange Maria beke kele killa laeala e bollau ae Iesus kuma kia ka loreapatokona te i. ");
INSERT INTO mee_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ava palu nge ri keke loa te Parisiome, na keke ture oru rae Iesus kuma ki. ");
INSERT INTO mee_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Minmina na piris re kapunu bae Parisiome keke kiukinunge Iurame ravollalaukerea memena, na keke role kerea roma, “Ita ka sana ka kumkuma ka oru palu. Ngaka kele. Agau laeala ke kumkuma ka killa papatu reke bollalau. ");
INSERT INTO mee_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ngaroma ita ngaka kelapalikovauu kia mana ine umma minmina, na ragau kinung nga loreapatokona te i. Bae Romme ngeke atu, na ngeke ravupatali ka tempel ae ita kala nga ragau rae ita.” ");
INSERT INTO mee_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ava te e nge ri a giana nge Kaiapas a i a piris e kapunu ka pesingmatana laeala ke role kerea roma, “Miau ka sana lomiaumatana ka otte bavakena! ");
INSERT INTO mee_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ba ka sana ka kelapatokonkona roma, ke pe ta miau tunge agau kena ta i mateng ta kalaunge ragau rae ita nga baina ri kinung sane ngeke kauu.” ");
INSERT INTO mee_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ka ine role minmina na i ke sane rolea oru e lelemana nga i muni lonamatanangana. Ke sa. Ka i a piris e kapunu ka pesingmatana laeala. Minmina na nga pangamologa laeala i ke tokale Iesus matengana ngarume ta kalaunge ragau rae ri. ");
INSERT INTO mee_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ba matengana sane nge kalaue ragau rae ri mana. Ke sa. I ke la mateng ta baina i nge pulikinunge goe rae Nutu reke momo nga ina re kalaoka ta ri momong nga ginunga kena mana. ");
INSERT INTO mee_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Minmina na, ngarume nga kae laeala, na reke taoamugmuga nge Iurame keke potolulu Iesus kana ta ri samungpununge. ");
INSERT INTO mee_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Minmina nae Iesus ke sane tatao nga Iurame ragurea tale. Ava ke kaꞌe inaeala, na ke loa ta inte kokoro ta ina a sana ragau ngia, ta maga kunna te e bollau eke patoe kae Ipriam. Na i ke momo nga inaeala kala nga barangalele ra kanna. ");
INSERT INTO mee_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na kaning e bollau ae Iurame a ri ke patoe kae Paska ke lele kokoro. Minmina na ragau papatu keke lelemalaga nga ina re ngapotu ngae Ierusalem, na keke loapatae tae Ierusalem ta ri leleng pala nga Paska. Keke loapataetae ta ri kumangng kurumea baingarea te nga pangalellepaꞌe ri muni. ");
INSERT INTO mee_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ka ina ragau ke lele ngae Ierusalem tapu, na keke ella te Iesus. Ba ke meisinsi nga malle re nga tempel, na keke palibalaglaga rea roma, “Ka lomiauvavai mina ngaetai? I ke la atung ta Kaning E Bollau, o ke sa?” ");
INSERT INTO mee_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ba piris re kapunu bae Parisiome keke role gingging ka ragau roma, ngaroma agau te nga lonamatana ka malle a Iesus momo ngia, na nge ture nga baina ngeke laue. ");
INSERT INTO mee_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ka kae a lima ba kena pala nga Paska, nae Iesus ke lele ngae Betani. Ka i a maga ae Lasarus amae Iesus pasigipage nga mateng pala. ");
INSERT INTO mee_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Na ri keke baia kaning e te Iesus nga inaeala, bae Marta ke umma ta silaenge ragau. Avae Lasarus ka i a te e nga ragau reke tattara ka bongapaikalangarea kerea ta kaning nga pala kala nge Iesus. ");
INSERT INTO mee_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Minmina nae Maria ke rave saulang inte a koina lolo ora kunna bollau, na ke kelingia nge Iesus kaena puname. Ba ke taupunu rea ka gilina bulvunna. Na saulang laeala koina lolongana ke paponue bale. ");
INSERT INTO mee_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ava barangalele te ae Iesus kanna a giana nge Iuras Iskariot e ngarume ne pulia Iesus nga reke bai ta baingasoalinge kamareame ke role roma, ");
INSERT INTO mee_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ke meimia na ke sane ke ba ka saulang laekolong ta ravunge kana lollokanna, nga baina ngeke tungu rea ta ra sillolo? Ta saulang laekolong kunna ke rave kuru ra ragau ke rarave ka pesingmatana kena bavakena.” ");
INSERT INTO mee_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Avae Iuras ke sane role minmina kurumea lonataningana ta ra sillolo. Ke sa. I ke role minmina ta i ka i a agolongkana te, ba ke kelapatantali ta bising ore nga puling lollokanna. Ba ka kae palu, na i ke golgole lollokanna ra ri ke ulo rea ngia. ");
INSERT INTO mee_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nae Iesus ke ale roma, “Sono ngo bokale, ta i ke kuma minmina ta baina nge kampite saulang laekia ta nge lele nga kae e nga talung iau. ");
INSERT INTO mee_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ra sillolo keke mommo kala nge miau ka kaeme kinung, ava iau sana la momong kala nge miau ka kaeme kinung.” ");
INSERT INTO mee_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na malua e bollau ra Iurame keke longe inae Iesus momo nga inaeala, na keke atu. Ava ke sane ke atu ta kelange Iesus mana. Keke atu ta baina ri ngeke kele Lasarus ae Iesus pasigipage nga mateng bole. ");
INSERT INTO mee_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Minmina na piris re kapunu keke potopita ta ri samungpununge Lasarus bole ");
INSERT INTO mee_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kurumea, Iura ra ri papatu keke umma ta kange reke taoamugmuga kerea lopatokona ae ri. Na keke umma ta ri leleng ra lopatokonakana te Iesus kurumea kelangareangana ka kumangngana ine pasigipage Lasarus nga mateng. ");
INSERT INTO mee_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Me ngangaila, na ragau papatu reke atu ta Kaning E Bollau E Nga Paska keke longe inae Iesus tatu tae Ierusalem. ");
INSERT INTO mee_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Minmina na keke rave pagao kamaname, na keke lelemalaga ta ri serengakalange Iesus ine taolulu. Na keke rereli roma, “Osana!” “Nutu ke kavitulu raumane aekia e atu nge Nutu a i ae Avolau giana!” “Nutu ke kavitule Kelangpatali Ae Israelme raumana!” ");
INSERT INTO mee_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nae Iesus ke kalipa ka posi a ronki goekia ba ke tarapai ngia kurumea pangamologa nga Lau Ae Nutu Kanna ore role roma, ");
INSERT INTO mee_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Miau re ngae Saion, sana ngaka matau. Ngaka kele. Kelangpatali ae miau ikolong e tatu, ka tarangapaingana nga posi a ronki goekia.” ");
INSERT INTO mee_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ava barangalele rae Iesus kanna ka sana loreamatana ka oru nginngina mirarea ka kae laeala a ragau ke paserengalle Iesus. Ava ngarume, ka inae Iesus galiu te Nutu mallena nga tava tapu, na ri ka loreagaliu ta pangamologa nga Lau Ae Nutu Kanna reke role ta oru nginngina. Ba ri ka loreagaliu ta ina ragau ke kuma kia minmina. ");
INSERT INTO mee_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ba malua reke momo kala nge i ine kiue Lasarus lagapotu nga baveng be pasigipage nga mateng, keke turulomatantana kia ta ragau. ");
INSERT INTO mee_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Minmina na ragau papatu keke lelemalaga ta serengakale Iesus kurumea ineke longe pangamologa e ta kumangngana ine kuma ka killa laeala e bollau. ");
INSERT INTO mee_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nae Parisiome keke palirorole kerea roma, “Pangamologangara ke sane kuma ka otte. Ngaka kele. Ragau kinung keke kampa kurumea tapu!” ");
INSERT INTO mee_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na Girik palu keke momo ngaliua nga ragau reke loapatae ta kavang ngae Ierusalem nga kaning laeala e bollau e nga Paska. ");
INSERT INTO mee_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ba Girik nginngina keke loa te Pilip, a i e ngae Betsaira ngae Galili, na keke role kia roma, “Avolau, mangng ka bai ta kelange Iesus.” ");
INSERT INTO mee_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Minmina nae Pilip ke loa te Anru, na ke ture Girik nginngina pangamologangarea te i. Ba ngarume nae Anru riluae Pilip keke loa te Iesus, na keke turu rea te i. ");
INSERT INTO mee_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nae Iesus ke ala rea roma, “Kae e ta Agau Tuna ravunge gia bolinglaungana ikia e lele tapu. ");
INSERT INTO mee_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Iau nga role kamiau ka kaomannmannangana roma, ngaroma uit kanna te ke sane nge pupu lakallo ta mogalo ba nge mate, na i nge momo mana me i. Ava ngaroma nge mate, na nge lele bollau, ba nge piaue kanna papatu. ");
INSERT INTO mee_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ba agau e materaumane maulingngana ke la pangasanrea kia. Ava agau e sane materaumane maulingngana nga mogalo laekia e ngape ke la kamongpitange maulingngana. Na maulingngana nge momo passavele. ");
INSERT INTO mee_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ngaroma agau te nge matea ta i a akumangngatulu a kanau, na i nge atu kurume iau. Ba ina iau momo ngia, akumangngatulu a kanau nge momo nga inaeala bole. Ngaroma agau te nga i a akumangngatulu a kanau, nae Tamau nge kalapage. ");
INSERT INTO mee_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Sonrau na iau ka kanimaimaia maenang ngallo nge iau. Na iau nga role mina ngaetai? Iau nga role roma, ‘Tamau, ngo ravulele iau lagapotu nga kae laekia e nga miralali.’ Ava iau ka lele nga kae laekia ta baina iau nga rave miralali laekia. ");
INSERT INTO mee_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ngana Tamau, ngo pavolaue giang!” Ka inae Iesus role minmina tapu, na kaling te ke pa nga tava roma, “Iau ka pavolaue tapu, ba ka la pangavolaunge muni.” ");
INSERT INTO mee_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Na malua palu reke momo nga inaeala beke longe kaling laeala keke rorole roma, saia ke ruru. Ava pattoto nge ri keke rorole roma, “Anggelo te ke pamologa te i.” ");
INSERT INTO mee_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nae Iesus ke role kerea roma, “Kaling laeala ke sane kiu ta baina iau nga longe. Ke sa. Ke kiu ta baina miau ngaka longe. ");
INSERT INTO mee_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Sonrau nae Nutu kalingnanangana ke lelekale ragau re nga mogalo laekia e ngape. Ba sonrau nae Nutu ke la gulaengamalaga ka kelangpatali ore nga mogalo laekia e ngape. ");
INSERT INTO mee_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ava nge iau, ri keke la kiningpatae iau lakailu ta maiskovu, na iau ka la oleng ka ragau kinung te iau.” ");
INSERT INTO mee_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Nga pangamologa laeala Iesus ke tuture mateng matana a i la mateng kia. ");
INSERT INTO mee_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Minmina na maluame keke role kia roma, “Mangng ka longe pangamologa nga Bangapaga onreke rolea pangamologa e te Karais roma, i ke la momong passavele. Ava ke meimia na one ko role roma, ‘Ri keke la kiningpataenge Agau Tuna lakailu ta maiskovu? Tai ka i ae Agau Tuna laekolong a one rorole te?’” ");
INSERT INTO mee_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nae Iesus ke role kerea roma, “Olamana ke la momong kala nge miau isura tale. Ngaka tao ka ina olamana ke momo kala nge miau tale ta baina osuguna sane nge lelepita miau. Agau e tatao nga osuguna ka sana lonamatana ka ina i lola te. ");
INSERT INTO mee_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nga lomiaupatokona ta olamana ine momo kala nge miau tale ta baina nga miau ra goe rae olamana.” Ka inae Iesus role minmina tapu, na i ke ka rea ka pakongana ka i muni nga ragurea. ");
INSERT INTO mee_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iesus ke kuma ka killa papatu reke bollalau, ava Iurame lokalasa ngareangana te i ke momo gingging tale. ");
INSERT INTO mee_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ba lokalasa ngareangana laeala ke lele ta baina pangamologa a agau e toe Nutu kaona a giana nge Aisaia paꞌe pala nge lele mannangana ine role roma: “Avolau, tai ka lonapatokona ta pangamologa a mangng ka pulimalage? Ba tai ke kelapatokone Avolau ginggingngana?” ");
INSERT INTO mee_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ba iau ae Ion nga role roma, pangamologa pattoto rae Aisaia kanna ke turupote Iurame lokalasa ngareangana puna ine role roma: ");
INSERT INTO mee_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nutu ke pasue matarea kanname ta baina ri manereasa kelang. Ba ke parutukale loreame ta baina ri sana nga loreamatana. Ta ngaroma ri ngeke kela ba loreame nga loreamatana, na ri ngeke bali ka girea ta baingarea reke sosoali, na iau nga pape rea.” ");
INSERT INTO mee_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia ke role minmina kurumea ine kele Karais ginggingngana pala na ke rorole te i. ");
INSERT INTO mee_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ka kae nginngina nae Iura papatu lokalasa ngareangana te Iesus ke momo gingging tale, ava Iura palu ka loreapatokona te Iesus. Ba papatu ra loreapatokona te i ka ri ra Iurame ravollalaukerea memena. Ava ri ke sane ke turupotpote lopatokona laeala ae ri ta keke matau roma, Parisiome keke la ulongmalaga rea lagapotu nga sinagog. ");
INSERT INTO mee_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ri ke sane ke turupotpote lopatokona ae ri te Iesus kurumea, ri ke sane ke materaumane Nutu kiningpataengana ka giareame. Ke sa. Keke materaumane ragau kiningpatae ngareangana ka giareame. ");
INSERT INTO mee_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ngarume nae Iesus ke pamologa kaligi roma, “Agau a lonapatokona te iau ka sana lonapatokona te iau mana. Ke sa. I ka lonapatokona te i e ba iau. ");
INSERT INTO mee_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ba agau e kelkela iau ke kelkele i e ba iau. ");
INSERT INTO mee_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Iau ka atupisigi ta mogalo laekia e ngape ma iau a olamana, ta baina agau a lonapatokona te iau sane nge momo tale nga osuguna. ");
INSERT INTO mee_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Iau ka sana kalinane agau e longlonge pangamologa ra kanegu ave sane kamopitpita rea. Iau ka sana kalinane kurumea, iau ka sana atu ta kalingnanange ragau re nga mogalo laekia e ngape. Ke sa. Iau ka atu ta ravunglele rea. ");
INSERT INTO mee_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ava akalingnanakana te ke momo, ba i ke la kalingnanange agau e tangulele iau be sane longo ta pangamologa ra kanau. Ka i a pangamologa nginngina ra kanau mana onra ri ke la kalingnanange agau laeala nga kae a ronga. ");
INSERT INTO mee_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Iau ka role minmina ta pangamologa nginngina ra kanau ke sane ke lele kurumea iau muni laumatanangana. Ke sa. Tamau e ba iau ke bapaga iau ta rolenge pangamologa ra iau pulimalaga rea. ");
INSERT INTO mee_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ba iau ka laumatana roma, bangapaga rae Tamau kanna keke tungtunge mauling e momo passavele. Minmina na orume kinung ra iau pulimalaga rea keke loakurumea pangamologa ra Tamau role kau ta iau roleng rea.” ");
INSERT INTO mee_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Na kae mannangana e nga kaninge Kaning E Bollau E Nga Paska ke lele kokoro. Minmina nae Iesus ka lonamatana roma, kae e ta i kange mogalo laekia e ngape ba loanga te Tamana ke lele tapu. Ka kae re pala kinung, na i ke umma ta matengraumanange ragau rae i re nga mogalo laekia e ngape ta ke lola, ta ke lele nga kae ae i a ronga. ");
INSERT INTO mee_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Minmina na ri keke tara ta kaning ka laio. Bae Satan ke pasipagatape Iuras Iskariot, a i ae Saimon te tuna, ta i ulonge Iesus nga reke bai ta baingasoalinge kamareame. ");
INSERT INTO mee_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Avae Iesus ka lonamatana roma, Tamana ke ule orume kinung nga kamana tapu. Ba ka lonamatana roma i ke pa nge Nutu, na nge galiu muni te Nutu. ");
INSERT INTO mee_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ka baina i ke sigipaga nga kaning, ba ke palale lungapaga ae i e ngapotu, na ke sisilia malo e nga taungapunu nga luana. ");
INSERT INTO mee_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Na i ke kelingia me lakallo ta kato te, na ke paturu ta mumunge barangalele ra kanna kaerea puname. Ba ke taupunpunu rea ka taungapunu e sisilia nga luana. ");
INSERT INTO mee_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ka ine lele nge Saimon Pita, nae Saimon Pita ke ballage roma, “Avolau, ko la mumunge kaegu puname?” ");
INSERT INTO mee_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nae Iesus ke ale roma, “Sonrau na ka sana longmatana ka taru a iau umma kia. Ava ka la longmatana kia ngarume.” ");
INSERT INTO mee_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Nae Pita ke role ka bongakalangana kia roma, “Manengsa mumunge kaegu puname!” Avae Iesus ke ale roma, “Ngaroma sana nga magoe one, na sana la one a agau ae iau te.” ");
INSERT INTO mee_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nae Saimon Pita ke ale roma, “Avolau, ngaroma minmina na sano ngo mume kaegu puname mana. Ngo mume kamaume ba kurugu bole!” ");
INSERT INTO mee_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nae Iesus ke ale roma, “Agau e magoe tapu nge mume kaena puname mana, ta mirana ina pattoto keke lelle tapu. Ba miau kaka lelle, ava ka sana miau kinung.” ");
INSERT INTO mee_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesus ke role minmina kurumea, i ka lonamatana tapu ka tai e la ulonge nga reke bai ta baingasoalinge kamareame. Minmina na i ke role roma, “Miau kaka lelle, ava ka sana miau kinung.” ");
INSERT INTO mee_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Na ka ine mume kaerea puname tapu, na i ke lupage lungapaga ae i e ngapotu, na ke galiu ta mallena nga pala. Na ke ballaga rea roma, “Ka lomiaumatana ka taru a iau kuma kia te miau? ");
INSERT INTO mee_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Miau kaka patpato iau ka Apangalomatanakana ba Avolau, ba pangamologa ngamiau nginngina ka kaomanna ki. Ta ka iau a Apangalomatanakana ae miau ba Avolaukamiau. ");
INSERT INTO mee_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Sonrau na iau ae Avolau bae Apangalomatanakana ka mume kaemiau puname. Minmina na miau bole ngaka palimumme kaemiaume. ");
INSERT INTO mee_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Iau ka pakosining miau ka kumangng laekia ikia ta baina miau ngaka palikumkuma ka miau minakai ngarume. ");
INSERT INTO mee_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Iau nga role kamiau ka kaomannmannangana roma, akumangngatulu ke sane bollau nga avolaukia. Ba agau e loa ka pangamologa ke sane bollau nga agau e baꞌe ka pangamologa. ");
INSERT INTO mee_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sonrau na miau ka lomiaumatana ka oru kokorai. Minmina na ka la lomiauserenga ngaroma ngaka lolakurume rea. ");
INSERT INTO mee_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Pangamologa laeala a kanau ke sane rave miau kinung. Iau ka laumatana ka ragau ra iau toro rea. Ava ollaekia ke la leleng ta baina pangamologa a ri ke paꞌe pala nga Lau Ae Nutu Kanna nge lele mannangana ine role roma, ‘Agau e kaninnia beret ae iau kala nge iau ke kinpataea kaena, na ke kesipita iau.’ ");
INSERT INTO mee_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Sonrau na iau ka rorole paka miau ka orume pala ta ri leleng, ta baina nga ine ngeke lele, na nga lomiaupatokona roma, ka iau a agau amae Nutu patokala pala ta i bange. ");
INSERT INTO mee_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Iau nga role kamiau ka kaomannmannangana roma, agau a lonangatakale tai a iau baꞌe ka lonangatakala iau. Ba agau a lonangatakala iau ka lonangatakale i e ba iau.” ");
INSERT INTO mee_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ka inae Iesus role minmina tapu, na i ke kanimaia maenang ngallo nge i ba ke role roma, “Iau nga role kamiau ka kaomannmannangana roma, te e nge miau ke la ulongo iau nga reke la baingasoali iau kamareame.” ");
INSERT INTO mee_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Na barangalele ra kanna keke palikela te ri, ba ka sana loreamatana roma i ke rorole te tai. ");
INSERT INTO mee_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ba barangalele ae Iesus kanna te ae Iesus materaumane ke tattara ka bongapaikalanganakia nga pala kokoro nge Iesus. ");
INSERT INTO mee_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Minmina nae Saimon Pita ke kini ta barangalele laeala, na ke role kia roma, “Into ballage roma, ke rorole te tai.” ");
INSERT INTO mee_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Minmina na barangalele laeala ke pakenopaia kunna nge Iesus mautuna, na ke ballage roma, “Avolau, ko rorole te tai?” ");
INSERT INTO mee_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nae Iesus ke ale roma, “Ka i a agau a iau la bongalunge beret inaekia lakallo ta kato, na nga tunge te i.” Minmina na i ke bolue beret inte nga kato, na ke tunge te Iuras Iskariot, a i ae Saimon te tuna. ");
INSERT INTO mee_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ka inae Iuras rave beret tapu, nae Satan ke luia. Nae Iesus ke role kia roma, “Ora one bai ta kumangng kia, ngo kuma kia bolvole.” ");
INSERT INTO mee_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ava ka sana te nga reke momo nga kaning laeala lonamatana roma, ke meimia na ke role kae Iuras minmina. ");
INSERT INTO mee_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Palu ka loreangana roma, Iesus ke rorole ta i kolinge oru nge nga Kaning E Bollau, o ke rorole ta i tungnge oru palu ta ra sillolo kurumea, Iuras ka i a agau e kelapatantali ta bising ore nga puling lollokanna. ");
INSERT INTO mee_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Minmina na, ka inae Iuras rave beret inaeala tapu, na i ke lelemalaga lagapotu. Ba ka rigo tapu. ");
INSERT INTO mee_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ka inae Iuras loa tapu, nae Iesus ke role roma, “Sonrau nae Agau Tuna ke la ravunge gia bolinglaungana, bae Nutu ke la ravunge gia bolinglaungana nge i. ");
INSERT INTO mee_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ba ngaroma Nutu nge rave gia bolinglaungana nge Agau Tuna, na i nge pavolaue Tuna giana nge i muni bole. Ba ke la pangavolaunge gialgiala mana. ");
INSERT INTO mee_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Goe ra kanau, iau ka la momong kala nge miau ka panna inte tale. Ngarume na kaka la siling te iau, ba pangamologa ama role ka reke taoamugmuga kae Iurame kia pala, iau ka la roleng ka miau kia gialgiala bole roma, ‘Ina iau la loanga te, ka sana ka la loanga te.’ ");
INSERT INTO mee_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Iau nga tunge bangapaga a pau te miau gialgiala roma, ngaka palimateraumana miau. Iau ka materaumana miau, minmina na ngaka palimateraumana miau. ");
INSERT INTO mee_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ngaroma ngaka palimateraumana miau, na ragau kinung nga loreamatana roma ka miau ra barangalele ra kanau.” ");
INSERT INTO mee_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Nae Saimon Pita ke ballage roma, “Avolau, ko la loanga laetai?” Nae Iesus ke ale roma, “Ina iau la loanga te, sono la loanga kurume iau te sonrau. Ava ngarume na ko la loanga kurume iau ta inaeala.” ");
INSERT INTO mee_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Nae Pita ke ballage roma, “Avolau, ke meimia na iau sana la loanga kurume one sonrau ka inaekia? Iau ka la tungnge maulingau ta mateng ta kalaunga one.” ");
INSERT INTO mee_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nae Iesus ke ale roma, “On ko roma, one ko la tungnge maulingang ta mateng ta kalaunga iau ae? Iau nga role kone ka kaomannmannangana roma, pala ta kukulega toangako, na one ko la kausingkala iau pa mologi. ");
INSERT INTO mee_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Ka sana nga lomiau soali. Nga lomiaupatokona te Nutu, ba nga lomiaupatokona te iau bole. ");
INSERT INTO mee_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ngallo nga bale ae Tamau ka bale bilingana papatu. Taroma pangamologa laeala sana ta kaomanna na iau ta role paka miau. Ta iau ka lola ta kalingtupunge malle rae miau. ");
INSERT INTO mee_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ba ngaroma nga loa ba nga kalitupe malle rae miau, na nga galiu ba nga ravu miau ta momong kala nge iau, ta baina miau bole ngaka momo nga inaeala a iau momo ngia. ");
INSERT INTO mee_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Miau ka lomiaumatana ka inaeala a iau lola te, ba ka lomiaumatana ka pamau e lola ta inaeala.” ");
INSERT INTO mee_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nae Tomas ke role kae Iesus roma, “Avolau, mangng ka sana lomangngmatana ka ino la loanga te. Minmina na ka la lomangngmatana ka pamau e loa ta inaeala mina ngaetai?” ");
INSERT INTO mee_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Nae Iesus ke ale roma, “Ka iau a pamau e loa te Nutu, ba pangamologa a kaomannmannangana kia, ba mauling e momo passavele puna. Nge iau mana, na agau nge loa te Tamau. ");
INSERT INTO mee_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Taroma miau ta lomiaumatana kau, na ta lomiaumatana kae Tamau bole. Sonrau na miau ka lomiaumatana kia ba kaka kele tapu.” ");
INSERT INTO mee_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nae Pilip ke role kia roma, “Avolau, onto pakosining mangng kae Tamang, na mangng nga lomangngmatana.” ");
INSERT INTO mee_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nae Iesus ke ale roma, “Pilip, iau ka momo kala nge miau ka panna e gavili tapu, ava ka sana longmatana kau tale ae? Agau e kela iau ke kele Tamau tapu. Ke meimia na one ko role kau roma, ‘Onto pakosining mangng kae Tamang’? ");
INSERT INTO mee_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ka sana longpatokona roma, iau ka momo ngallo nge Tamau ba Tamau ke momo ngallo nge iau ae? Pangamologa ra iau rorole kamiau ki ke sane ke lola kurumea iau muni laungana. Ke sa. Tamau e mommo ngallo nge iau ke kumkuma ka kumangng ra kanna nge iau. ");
INSERT INTO mee_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nga lomiaupatokona ta pangamologangau ina iau role roma, iau ka momo ngallo nge Tamau, ba Tamau ke momo ngallo nge iau. Ngaroma nge sa, na nga lomiaupatokona kurumea kelang ngamiaungana ka kumangng ra iau kumkuma ki. ");
INSERT INTO mee_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Iau nga role kamiau ka kaomannmannangana roma, agau a lonapatokona te iau ke la kumangng ka kumangng ra iau kumkuma ki bole. Ba i ke la kumangng ka kumangng reke bollau nga kumangng kokorai kurumea loangau te Tamau. ");
INSERT INTO mee_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ba taru a miau ka ballaga te nga giau iau ka la kumangng kia, ta baina Tamau nge rave gia bolinglaungana nge Tuna. ");
INSERT INTO mee_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Orume kinung ra miau ka ballaga iau tao nga giau iau ka la kumangng ki. ");
INSERT INTO mee_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ngaroma miau ngaka materaumana iau, na ngaka longo ta bangapaga ra kanau. ");
INSERT INTO mee_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ba iau nga ballage Tamau, na i nge tunge Akalaungapaga tetoto ta i momong kala nge miau passavele. ");
INSERT INTO mee_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iau ka rorolea pangamologa e ta Kannu a kaomannmannangana kia ora ragau re nga mogalo laekia e ngape ke sane ke ngatakale. Ta ri ke sane ke kelkele, ba ka sana loreamatana kia bole. Ava miau ka lomiaumatana kia kurumea, i ke mommo kala nge miau, ba ke la momong ngallo nge miau. ");
INSERT INTO mee_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Iau sana nga ka miau ta miau momong mana me miau base goe ra sana tamarea ba nareamemena. Ke sa. Iau ka la atung te miau. ");
INSERT INTO mee_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Isura mana na re nga mogalo laekia e ngape sane ngeke kela iau, ava miau kaka la kelanga iau. Iau ka la momong mauli, minmina na miau kaka la momong mauli bole. ");
INSERT INTO mee_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nga kae laeala na miau ka la lomiaumatana roma, iau ka momo ngallo nge Tamau, ba miau kaka momo ngallo nge iau, ba iau ka momo ngallo nge miau. ");
INSERT INTO mee_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Agau a lonamatana ka bangapaga ra kanau be lolakurume rea ke materaumana iau. Ba agau e materaumana iau, Tamau ke la matengraumanange. Ba iau bole ka la matengraumanange, ba ka la pangakosining iau te i.” ");
INSERT INTO mee_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ngarume nae Iuras tetoto (a sana i ae Iuras Iskariot) ke role roma, “Avolau, pangakosiningang laeala ino la pangakosining one te mangng ava sano la pangakosining one ta ragau pattoto re nga mogalo laekia e ngape ke la leleng mina ngaetai?” ");
INSERT INTO mee_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nae Iesus ke ale roma, “Ngaroma agau nge materaumana iau, na i nge lolakurumea pangamologa ra kanau. Nae Tamau ke la matengraumane agau laeala ba omea Tamau ka la atung te i, na mangng ka la momong kala nge i. ");
INSERT INTO mee_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Agau e sane materaumana iau ke sane lolakurumea pangamologa ra kanau. Ba pangamologa kokorai ra miau ka longlongo rea nge iau ka sana pangamologa ra kanau. Ke sa. Ka ri ra pangamologa rae Tamau e ba iau kanna. ");
INSERT INTO mee_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Iau ka role kamiau ka oru kokorai ka ina iau mommo kala nge miau tale. ");
INSERT INTO mee_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Avae Akalaungapaga, a i ae Kannu E Tupu ae Tamau la bange nga giau, i ke la pangalomatana miau ka orume kinung. Ba ke la rolengpage lomiaume ta pangamologame kinung ra iau role kamiau ki. ");
INSERT INTO mee_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ala ulle momongpengana nge miau. Ala tungtunge momongpengana ae i te miau. Ava tungaungana kia ka sana tongana kena ma re nga mogalo laekia e ngape tungarea ka momongpengana. Ke sa. Sana nga lomiausoali ba sana ngaka matau. ");
INSERT INTO mee_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Miau kaka longo ina iau role roma, ‘Iau ka la kanga miau, ava ka la galiunga muni te miau.’ Ngaroma miau ngaka materaumana iau, na nga lomiaumarapaga kurumea loangau te Tamau. Iau ka role minmina kurumea, Tamau ke bollau nge iau. ");
INSERT INTO mee_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Sonrau na iau ka role paka miau ka orume pala ta ri leleng, ta baina nga ine ngeke lele, na nga lomiaupatokona. ");
INSERT INTO mee_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Iau sana nga pamologa raumana kala nge miau ka panna inaekia, ta kelangapatali e nga mogalo laekia e ngape ke tatu. I ka sana kana gingginga ta bainga ka otte nge iau. ");
INSERT INTO mee_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ava orume ngeke lele nga baina ragau re nga mogalo laekia e ngape nga loreamatana roma iau ka materaumane Tamau, ba ka kuma kurumea oru rae Tamau bangapaga iau ki mana. “Ka sigipaga nga ita lola. ");
INSERT INTO mee_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ka iau a bega ora kaomannmannangana kia e piaupiau nga ura, bae Tamau ka i a ura tamana. ");
INSERT INTO mee_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ngaroma kama te e kalapita nge iau sane nge piaupiau, na i nge saꞌvapatali kia. Ava i ke umma ta pangalellepaꞌe kama reke piaupiau ka paerangpatalingana ki ta baina ri ngeke piau raumana muni. ");
INSERT INTO mee_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Miau kaka momo lelle tapu kurumea pangamologa ra iau role kamiau ki. ");
INSERT INTO mee_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ngaka kalapita nge iau, ba iau nga kalapita nge miau. Bega kamana te sane nge piau mana me i. Ke sa. Nge kalapita nga bega na nge piau. Ba miau ka tongamiau kena mana ma ollaeala kurumea, ngaroma miau sana ngaka kalapita nge iau, na miau ka sana ka la piaunga. ");
INSERT INTO mee_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ka iau a bega kaina, ba ka miau ra bega laeala kamaname. Ngaroma agau nge kalapita nge iau, ba iau nga kalapita nge i, na i ke la piaunga masi raumana. Iau ka role minmina kurumea, miau ka sana kamiau gingging ta kumangng ka otte balakala nge iau. ");
INSERT INTO mee_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ngaroma agau te sane nge kalapita nge iau, na i nga tongana kena ma bega kamana eke tamali kia, na ke manani. Ba ngarume na ngeke ravukinunge bega kamana nginngina reke manani, na ngeke tamalilu ki lakallo ta sia ta raunga rea. ");
INSERT INTO mee_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ngaroma miau ngaka kalapita nge iau ba pangamologa ra kanau ngeke kalapita nge miau, na ngaka ballaga ta taru a miau ka matea. Minmina na kaka la ravunge ollaeala. ");
INSERT INTO mee_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ngaroma miau ngaka piau masi raumana, nae Tamau nge rave gia bolinglaungana, ba miau ngaka pakosining ka miau roma, ka miau ra barangalele ra kanau. ");
INSERT INTO mee_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Tamau matengraumanangana kau ka tongana kena mana ma matengraumana ngaungana kamiau. Minmina na ngaka kalapita nga matengraumana ngaungana ka miau. ");
INSERT INTO mee_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ngaroma miau ngaka longo ta bangapaga ra kanau, na kaka la kalangapita nga matengraumana ngaungana kamiau. Ollaeala ka tongana kena mana ma ina iau longo ta bangapaga rae Tamau kanna, ba ka kalapita nga matengraumanangana kau. ");
INSERT INTO mee_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Iau ka role kamiau ka oru kokorai, nga baina lomarapaga ae iau nge momo ngallo nge miau. Ba lomarapaga laeala e momo ngallo nge miau nge ponutalao. ");
INSERT INTO mee_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Bangapaga ama tunge te miau minakai roma: Ngaka palimateraumana miau base ina iau materaumana miau. ");
INSERT INTO mee_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ka sana matengraumana te bollau nga matengraumana orae agau e tunge maulingngana ta mateng ta kalaunge kolingana memena. ");
INSERT INTO mee_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ngaroma miau ngaka lolakurumea oru ra iau bapaga miau ki, na ka miau ra kolingau memena. ");
INSERT INTO mee_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Iau ka sana pato miau ka ra kumangngatulu tale, ta akumangngatulu ka sana lonamatana ka oru ra avolaukia kumkuma ki. Iau ka patpato miau ka kolingau memena kurumea, orume kinung ra iau longo rea nge Tamau ka turu pakamiau ki. ");
INSERT INTO mee_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Miau ka sana ka toro iau. Ke sa. Iau ka toro miau. Ba ka puli miau ta baina ngaka loa ba ngaka lele ma bega reke piaupiaue kanrea reke momo passavele, nga baina taru ra miau ka ballage Tamau tao nga giau, i nge tungu rea te miau. ");
INSERT INTO mee_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Bangapaga ama tunge te miau minakai roma: Ngaka palimateraumana miau. ");
INSERT INTO mee_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ngaroma re nga mogalo laekia e ngape ngeke baiꞌiu ka miau, na ala nga lomiaumatana roma iukereangana kau keke ulopaia nge miau. ");
INSERT INTO mee_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Taroma miau ra ragau re nga mogalo laekia e ngape, na teke materaumana miau ma ragau rae ri muni. Ava ka sana miau ra ragau re nga mogalo laekia e ngape. Ke sa. Ka miau ra ragau ra iau toro rea nga ragau re nga mogalo laekia e ngape. Minmina na re nga mogalo laekia e ngape keke la baingaꞌiu kamiau. ");
INSERT INTO mee_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nga lomiaugaliu ta pangamologa ramra iau role kamiau ki pala roma, ‘Akumangngatulu ke sane bollau nga avolaukia.’ Ngaroma ri ngeke pamiralali iau, na keke la pangamiralali miau bole. Ngaroma ri ngeke longo ta pangamologa ra kanau, na keke la longa ta pangamologa ra kanmiau bole. ");
INSERT INTO mee_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ava ri keke la kumangng ka oru kokorai nge miau kurumea lopatokona ae miau ta giau, ta ri ka sana loreamatana kae Tamau e ba iau. ");
INSERT INTO mee_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Taroma iau sana ta atu ta pangamologa te ri, na ri sana ta baingarea reke sosoali. Ava keke longe pangamologa ra kanau tapu, minmina na ri sana la kanrea pangamologa nga ina agau te nge turupote baingarea reke sosoali. ");
INSERT INTO mee_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Agau e baiꞌiu kau, ke baiꞌiu kae Tamau bole. ");
INSERT INTO mee_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Taroma iau sana ta kuma ka kumangng ra agau te sane kuma ki pala ngaliua nge ri, na ri sana ta baingarea reke sosoali. Ava keke kele kumangng nginngina tapu. Keke kela rea, ava keke baiꞌiu kae omea Tamau kinung. ");
INSERT INTO mee_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ava ri keke kuma minmina ta baina pangamologa a ri ke paꞌe pala ngallo nga Bangapaga rae ri nge lele mannangana ineke role roma: “Baingaꞌiungarea kau ka sana puna.” ");
INSERT INTO mee_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Akalaungapaga ama iau la bange te miau be pa nge Tamau ke la atung. Ka i ae Kannu a kaomannmannangana kia ore pa nge Tamau. Ka ine nge atu, na i ke la turungpota iau. ");
INSERT INTO mee_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Bae miau kaka la turungpota iau bole, ta miau kaka momo pala kala nge iau nga orume pangaturungarea ta ke lele ikia e sonrau. ");
INSERT INTO mee_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Iau ka role kamiau ka oru kokorai ta baina miau sana ngaka pupu. ");
INSERT INTO mee_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Keke la pulingmalaga miau lagapotu nga sinagog. Ba nga kae te e tatu ngarume, na ragau reke samupunu miau nga loreangana roma, keke kumkuma kurumea Nutu lonangana nga ineke samupunu miau. ");
INSERT INTO mee_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ri ka sana loreamatana kae Tamau ba ka sana loreamatana kau bole, minmina na keke la kumangng ka oru nginngina. ");
INSERT INTO mee_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ava iau ka role paka miau ka oru kokorai pala ta ri leleng, ta baina nga ina kae nga oru kokorai ngeke lele, na nga lomiaugaliu ta pangamologangau ina iau role kamiau ta oru kokorai. Pala ina iau momo kala nge miau tale, na ka sana role kamiau ta oru kokorai. ");
INSERT INTO mee_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ikia na iau ka lola te i e ba iau. Ba ka sana te e nge miau ballaga iau roma, ‘On ko lolae tai?’ ");
INSERT INTO mee_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ba siamiaume keke maena kurumea oru kokorai ra iau role rea paka miau. ");
INSERT INTO mee_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ava iau nga role kamiau ka kaomannmannangana roma, kanga ngaungana ka miau ka i a oru e nga kalaunga miau. Ta ngaroma iau sana nga loa, nae Akalaungapaga sane nge atu te miau. Ava ngaroma iau nga loa, na iau nga baꞌe na i ke la atung te miau. ");
INSERT INTO mee_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ba ka ine nge atu, na i ke la pangapotange ragau re nga mogalo laekia e ngape baingareame. Ke la pangapotange baingarea reke sosoali, ba baingarea reke sane ke tupu, ba kalingnanangarea reke sane ke tupu. ");
INSERT INTO mee_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","I ke la pangapotange baingarea reke sosoali kurumea, ri ka sana loreapatokona te iau. ");
INSERT INTO mee_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ba ke la pangapotange baingarea reke sane ke tupu kurumea, iau ka lola te Tamau na miau ka sana la kelanga iau nga mogalo laekia e ngape. ");
INSERT INTO mee_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ba ke la pangapotange kalingnanangarea reke sane ke tupu kurumea, kelangpatali ore nga mogalo laekia e ngape ke la ravunge alanga e soali. ");
INSERT INTO mee_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ka kanau oru papatu muni ta roleng ka miau ki, ava ke isopa ta miau longa rea sonrau. ");
INSERT INTO mee_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ava ngarume inae Kannu a kaomannmannangana kia nge atu, na i nge taoamuga ka miau lakallo ta orume kinung ra kaomannmannangana ki. Ta i ke sane la pangamologa kurumea i muni lonangana. Ke sa. I ke la pangamologa ka pangamologa ra i longo rea mana. Ba ke la turunglomatana paka miau ta oru reke la leleng ngarume. ");
INSERT INTO mee_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","I ke la pangavolaunge giau, ta i ke la ravunge oru ra kanau na nge pakela miau ki. ");
INSERT INTO mee_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Orume kinung rae Tamau ka oru rae iau. Minmina na iau ka role roma, Kannu E Tupu ke la ravunge oru ra kanau na nge pakela miau ki. ");
INSERT INTO mee_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Isura mana na miau sana la kelanga iau, ava ngarume muni na kaka la kelanga iau.” ");
INSERT INTO mee_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Minmina na barangalele palu rae Iesus kanna keke palirole kerea roma, “Pangamologangana ine role roma, ‘Isura mana na miau sana la kelanga iau, ava ngarume muni na kaka la kelanga iau’, ka mirana laetai? Ba pangamologa laeala ine role roma, ‘Ta iau ka lola te Tamau’ ka mirana laetai?” ");
INSERT INTO mee_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ba keke palirorole kerea roma, “Pangamologangana ine role roma, ‘isura mana’ ke rorole ta taru? Mangng ka sana lomangngmatana ka taru a i rorole te.” ");
INSERT INTO mee_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Avae Iesus ka lonamatana ina ri ke bai ta balinglagapitange, minmina na i ke role kerea roma, “Kaka maimia aka palibalaglaga miau ta pangamologangau mirana ina iau role roma, ‘Isura mana na miau sana la kelanga iau, ava ngarume muni na miau kaka la kelanga iau’? ");
INSERT INTO mee_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Iau nga role kamiau ka kaomannmannangana roma, miau kaka la taning ba nga lomiautani, ava re nga mogalo laekia e ngape nga loreasereng. Miau nga lomiautani, ava ngarume na lotaningngana laeala ae miau ke la kamongpiliu, na nge lele i a lomarapaga. ");
INSERT INTO mee_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Avale e bai ta toangapisiginge goe ke la kaningmainge miralali ka kae e nga toangapisigi. Ava ka ine nge toapisigi tapu, na i ka la lonapoge miralali laeala ba ka la lonamarapaga kurumea goe ae i lelengana nga mogalo laekia e ngape. ");
INSERT INTO mee_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Minmina mana na sonrau na miau ka lomiautani, ava ngarume na iau ka la kelanga miau muni, na lomiaume keke la serenga raumana. Ba ka sana nga agau te nge ravupatali ka lomiauserengngana laeala nge miau. ");
INSERT INTO mee_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ba nga kae laeala na miau ka sana ka la balinglaga iau ka otte. Iau nga role kamiau ka kaomannmannangana roma, Tamau ke la tungnge taru a miau ka ballage te nga giau. ");
INSERT INTO mee_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Pala na miau ka sana ka balaglaga ta otte nga giau. Ava sonrau na ngaka ballaga na kaka la ravunge taru ra miau ka ballaga tao ta baina lomarapaga ae miau nge ponutalao. ");
INSERT INTO mee_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Iau ka role paka miau ka oru kokorai ka pangateningkalame, ava nga kae te ngarume na iau sana la pangamologa te miau ka pangateningkalame. Ke sa. Iau ka la turungpote Tamau te miau nga karakarangana. ");
INSERT INTO mee_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ka kae laeala na miau kaka la balinglaga nga giau. Iau ka sana rorole roma, iau ka la balinglage Tamau te miau. ");
INSERT INTO mee_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ke sa. Ta Tamau muni ke materaumana miau. Miau kaka materaumana iau ba ka lomiaupatokona roma, iau ka pa nge Tamau. Minmina nae Tamau ke materaumana miau. ");
INSERT INTO mee_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Iau ka pa nge Tamau, na ka atu pisigi ta mogalo laekia e ngape. Ba sonrau na iau ka kakaꞌe mogalo laekia e ngape, na ka lola te Tamau.” ");
INSERT INTO mee_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Na barangalele ra kanna keke role kia roma, “Gialgiala, na one ko pamollogapota, ba ko sano patenikalkala. ");
INSERT INTO mee_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Gialgiala na mangng ka kelapatokona roma, one ka longmatana ka orume kinung. Na ka sana agau te a lonamatanakana ta i balinglaga one ka otte. Minmina mana na mangng ka lomangngpatokona roma, one ko pa nge Nutu.” ");
INSERT INTO mee_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nae Iesus ke ala rea roma, “Gialgiala na miau ka roma lomiaupatokona?” ");
INSERT INTO mee_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ngaka longo. Kae te ke tatu ina miau ka la kanga iau ta iname kalaoveka. Ba kae laeala ikia e lele tapu. Ba kenakena nge miau ke la kanga ta bale ae i, na iau ka la momong mana me iau. Avae iau sana la momong mana me iau ta Tamau ke la momong kala nge iau tale. ");
INSERT INTO mee_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Iau ka role paka miau ka oru kokorai, ta baina ngaka kalapita nge iau, na momongpengana nge momo ngallo nga lomiaume. Miau kaka la kaningmainge maenangme ina miau ka mommo nga mogalo laekia e ngape. Ava ngaka meisgingging, ta iau ka ulopisigia oru re nga mogalo laekia e ngape tapu.” ");
INSERT INTO mee_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ka inae Iesus role minmina tapu, na i ke kela lakailu ta tava, na ke kava roma: “Tamau, kae ae iau ke lele tapu. Ngo pavolaue tung giana ta baina tung nge pavolaue giang. ");
INSERT INTO mee_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ngo pavolaue tung giana base ino tunge gingginga te i ta i momong ngailu nga ragau kinung, ta baina i nge tunge mauling e momo passavele ta ragau kinung ra one tungu rea te i. ");
INSERT INTO mee_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ba mauling e momo passavele minakai roma: Ri ala nga loreamatana kone a one ae Nutu a i kena mana a kaomannmannangana kia. Ba ri ala nga loreamatana kae Iesus Karais a one baꞌe. ");
INSERT INTO mee_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Iau ka rongotapu ka kumangng a one tunge ta iau kumangng kia. Minmina na iau ka pavolaue giang nga mogalo laekia e ngape. ");
INSERT INTO mee_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tamau, sonrau na ngo pavolaue giau nga ragung ka giau bolinglaungana laeala e momo pala kala nge one ina mogalo laekia e ngape sane lele tale. ");
INSERT INTO mee_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Iau ka papote giang ta ragau ra one tungu rea te iau. Ka ri ra ragau ra one toro rea nga ragau re nga mogalo laekia e ngape. Pala ka ri ra ragau rae one, na ko tungu rea te iau, ba keke longo ta pangamologa ra kaning. ");
INSERT INTO mee_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sonrau na ri ka loreamatana roma, orume kinung ra one tungu rea te iau keke pa nge one. ");
INSERT INTO mee_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Minmina na iau ka tunge pangamologa ra one tungu rea te iau te ri. Na ri keke ngatakala rea ba ka loreamatana mannangana roma, iau ka pa nge one. Ba ri ka loreapatokona roma, one ko ba iau. ");
INSERT INTO mee_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Iau ka kavkava one te ri. Ka sana kavkava one ta ragau pattoto re nga mogalo laekia e ngape. Ke sa. Iau ka kavkava one ta ragau ra one tungu rea te iau kurumea, ka ri ra ragau rae one. ");
INSERT INTO mee_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Oru rae iau kinung ka ri ra oru rae one. Ba oru rae one kinung ka ri ra oru rae iau, ba keke tunge gia bolinglaungana te iau. ");
INSERT INTO mee_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Iau ala sana la momong nga mogalo laekia e ngape, ava ri keke la momong tale. Iau ka la loanga te one. Tamau E Tupu, ngo lengtotokala rea ka giang a one tunge te iau. Ngo lengtotokala rea ka giang, ta baina ri kinung nga ri pana kena base itaua ra ita pana kena mana. ");
INSERT INTO mee_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ka ina iau mommo tale kala nge ri, na ka lengtotokalkala rea ka giang a one tunge te iau. Ba iau ka kelapatantali masi te ri. Ba ka sana te e nge ri sanrea, ava kena mana a i a agau a one la raunge kurumea pangamologa eke paꞌe pala nga Lau A Kaning. ");
INSERT INTO mee_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ava sonrau, na iau ka lola te one. Ba iau ka rorole ta oru kokorai ka ina iau momo tale nga mogalo laekia e ngape, nga baina loserengngana ae iau nge paponue loreame raumana. ");
INSERT INTO mee_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Iau ka tunge pangamologa a kaning te ri, ba ragau re nga mogalo laekia e ngape keke baiꞌiu kerea. Ri ka tongarea kena me iau mana. Ka sana ri ra ragau re nga mogalo laekia e ngape, minmina na re nga mogalo laekia e ngape keke baiꞌiu kerea. ");
INSERT INTO mee_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Iau ka sana balaglaga one ta ravungmalaga rea nga mogalo laekia e ngape. Ke sa. Ka balaglaga one ta lengatotokala rea ta bainae Satan sane nge baisoali rea. ");
INSERT INTO mee_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ri ka tongarea kena me iau mana. Ka sana ri ra ragau re nga mogalo laekia e ngape. ");
INSERT INTO mee_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ngo toro rea ka pangamologa a kaomannmannangana kia. Pangamologa a kaning ka kaomannmannangana kia. ");
INSERT INTO mee_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Pala, na one ko ba iau ta ragau re nga mogalo laekia e ngape. Minmina na iau ka ba rea ta ragau re nga mogalo laekia e ngape bole. ");
INSERT INTO mee_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kumangngau e nga torongo iau muni ta kumangng kurumea longmatengana, iau ka kuma kia te ri, ta baina ri ngeke tore ri muni mannangana ta kumangng kurumea longmatengana bole. ");
INSERT INTO mee_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Iau ka sana kavkava one te ri kasikerea. Iau ka kavkava one ta ragau ra ri ke la loreapatokona te iau kurumea ragau kokorong pulingmalaga ngareangana ka pangamologa. ");
INSERT INTO mee_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tamau, iau ka matea ta ri kinung nga ri pana kena base itaua. Ka la tongarea kena me itaua ina one momo ngallo nge iau ba iau ka momo ngallo nge one. Iau ka matea ta ri bole ngeke momo ngallo nge ita ta baina ragau re nga mogalo laekia e ngape nga loreapatokona roma, one ko ba iau. ");
INSERT INTO mee_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Iau ka tunge gia bolinglaungana a one tunge te iau te ri ta baina nga ri pana kena base itaua ra pana kena. ");
INSERT INTO mee_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Iau ka momo ngallo nge ri, ba one ko momo ngallo nge iau. Iau ka matea ta nga ri pana kena mannangana ta baina re nga mogalo laekia e ngape nga loreamatana roma, one ko ba iau. Ba nga loreamatana roma, one ko materaumane ragau kokorong base ino materaumana iau. ");
INSERT INTO mee_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tamau, iau ka matea ta ragau kokorong ra one tungu rea te iau ngeke momo kala nge iau nga ina iau la momong ngia, ta baina ri ngeke kele gia bolinglaungana a one tunge te iau. Ta one ko materaumana iau. Ba ko materaumana iau pala bole ka ina oru re nga mogalo laekia e ngape ke sane ke lele tale. ");
INSERT INTO mee_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tamau a baingang tupu, ragau re nga mogalo laekia e ngape ka sana loreamatana kone, ava iau ka laumatana kone. Ba ragau kokorong ka loreamatana roma one ko ba iau. ");
INSERT INTO mee_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Iau ka papote giang te ri. Ba iau ka la pangapotange tale ta baina matengraumanangang kau nge momo ngallo nge ri, ba iau muni nga momo ngallo nge ri.” ");
INSERT INTO mee_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ka inae Iesus kava minmina tapu, na i kala nga barangalele ra kanna keke kutapu, ba keke taotote ruvu te a ri ke patoe kae Kiron. Na keke taolu lakallo ta ura te nga bega ra oliv ore momo nga ruvu bavana laeala. ");
INSERT INTO mee_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Bae Iuras, a i a agau laeala e la ulonge Iesus nga reke bai ta baingasoalinge kamareame, ka lonamatana ka inaeala bole kurumea, ka i a inte ae Iesus ba barangalele ra kanna keke katualla ngia ka kae papatu tapu. ");
INSERT INTO mee_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Minmina nae Iuras ke rave ra balingkana palu, kala barangalele palu ra piris re kapunu kanrea, ba Parisiome ravollalaukerea palu, na ke taoamuga kerea ta inaeala. Ba ri keke paupaue guneme, ba olamaname, kala nga oru re nga baling. ");
INSERT INTO mee_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Avae Iesus ka lonamatana tapu ka orume kinung reke la leleng nge i ngarume. Minmina na i ke loa te ri ba ke ballaga rea roma, “Kaka ella te tai?” ");
INSERT INTO mee_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Na keke ale roma, “Mangng ka ella te Iesus e ngae Nasaret.” Nae Iesus ke role roma, “Iau a i.” Bae Iuras, a i agau e umma ta ulonge Iesus ta kamareame, ke meisinsi kala nge ri nga inaeala bole. ");
INSERT INTO mee_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ka inae Iesus role roma, “Iau a i,” na keke agatapu ba keke pupisigi nga mogalo. ");
INSERT INTO mee_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Minmina nae Iesus ke ballaga muni roma, “Kaka ella te tai?” Na keke role roma, “Iesus e ngae Nasaret.” ");
INSERT INTO mee_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Bae Iesus ke ala rea roma, “Ka role kamiau tapu roma, ka iau a i. Ngaroma ngaka ella te iau, na ngaka baꞌe ra kokorai reke momo kala nge iau ngeke lao.” ");
INSERT INTO mee_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Iesus ke role minmina ta baina pangamologa ame role kae Tamana kia pala nge lele mannangana ine role roma, “Iau ka sana pasanrea ka agau te nga ragau ra one tungu rea te iau.” ");
INSERT INTO mee_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nae Saimon Pita ke rave kanna ka resalla ore nga baling, na ke magala kia nga akumangngatulu ora piris e kapunu kanna, ba ke saꞌvatote longana e nga bavana e pe. (Ba akumangngatulu laeala ka giana nge Malakus.) ");
INSERT INTO mee_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Avae Iesus ke role kae Pita roma, “Pulgaliue resalla a kaning lakallo ta bagana! Iau ka la inung nga gato e nga miralali a Tamau tunge te iau.” ");
INSERT INTO mee_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ka baina ra balingkana ba kelangpatali ae ri, kala nga Iurame ravollalaukerea nginngina keke laue Iesus ba keke sampite. ");
INSERT INTO mee_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Na keke loa kia kapunu ta Iurame avolaukerea te a giana nge Anas. Ta Anas ka i a piris e kapunu a giana nge Kaiapas laona. Bae Kaiapas ka i a piris e kapunu ka pesingmatana laeala. ");
INSERT INTO mee_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ba bole Kaiapas ka i a agau laeala ame pala ne tokale pangamologa ta reke taoamugmuga kae Iurame roma, ke pe ngaroma agau kena nge mate ta kalaunge ragau rae ri. ");
INSERT INTO mee_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Nae Saimon Pita kala nga barangalele tetoto ae Iesus kanna keke lolakurumea Iesus. Ba piris e kapunu ka lonamatana ka barangalele laeala e tatao kala nge Pita. Minmina na barangalele laeala ke loalu kurumea Iesus lakallo ta savanau e maistaliue bale ae piris e kapunu. ");
INSERT INTO mee_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Avae Pita ke meisinsi ngapotu nga savanau kana biunga. Ka baina barangalele laeala ora piris e kapunu lonamatana kia ke galiu, na ke role ka avale e ella ta savanau kana biunga ba ke ravulue Pita lakallo. ");
INSERT INTO mee_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Na avale a akumangngatulu ore ella ta biunga ke role kae Pita roma, “Ka one a barangalele a agau laeala te bole nanguni.” Nae Pita ke ale roma, “Iau, ke sa.” ");
INSERT INTO mee_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ba kae laeala ke marusu, minmina na ra kumangngatulu ba barangalele ra piris re kapunu kanrea keke meistaliliue sia eke patue ta mallunga kia. Bae Pita ke meisinsi kala nge ri bole, na ke mallmallu. ");
INSERT INTO mee_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ka ina ri ke meisinsi beke mallmallu, na piris e kapunu ke ballagapitpite Iesus ta barangalele ra kanna. Ba ke ballagapitpite ta pangalomatana ra i palomatane ragau ki. ");
INSERT INTO mee_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Nae Iesus ke ale roma, “Ka ina iau pamolloga ta ragau re nga mogalo laekia e ngape, na ka rorolea pangamologame nga karakarangana. Iau ka palomatantana palimule nga sinagogme, ba ka palomatana nga tempel nga malle rae Iurame kinung ke katualla ngi. Ka sana pakokoea pangamologangau. ");
INSERT INTO mee_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ke meimia na ko ballaga iau? Ngo ballage reke longe pangamologa ra kanau. Ri ka loreamatana ka pangamologa ra iau role rea.” ");
INSERT INTO mee_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ka inae Iesus role minmina, na barangalele te a piris re kapunu kanrea ore meisinsi kokoro ke tavale nga raguna, ba ke mologa kia roma, “Manengsa pangamologa ta piris e kapunu minakong.” ");
INSERT INTO mee_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nae Iesus ke ale roma, “Ngaroma iau nga rolea otte e soali, na ngo papote oraeala e soali. Ava ngaroma iau nga role masi, na ke meimia na ko tavala iau?” ");
INSERT INTO mee_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Minmina nae Anas ke baꞌe ka samangpitangana te Kaiapas a i a piris e kapunu. ");
INSERT INTO mee_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nae Saimon Pita ke meisinsi ba ke mallmallu tale, minmina na reke meisinsi kala nge i keke ballage roma, “Ka one a barangalele a kanna te bole ae?” Nae i ke kausikala ka rolengana roma, “Iau, ke sa.” ");
INSERT INTO mee_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ngarume na akumangngatulu a piris e kapunu kanna, a i a agau ae Pita saꞌvatote longana akia te, ke role kia roma, “Iau ka kela one kala nge i nga ura nga bega ra oliv.” ");
INSERT INTO mee_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nae Pita ke kausikala muni, ba ka panna laeala mana na kukulega ke toako. ");
INSERT INTO mee_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ngarume, ka sinro luluna, na ri keke ngalue Iesus lagapotu nga bale ae Kaiapas. Na keke loa kia ta bale ae agau e kapunu nga gavaman e ngae Rom nga porovins laeala. Avae Iurame ke sane ke loalu lakallo ta bale laeala, ta keke matea ta ri kaninge kaning e nga Paska. Ba lopatokona ae ri ke role roma ngaroma ri ngeke lu nga bale ae agau laeala na nge pamukuna rea. ");
INSERT INTO mee_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Minmina nae Pilatus ke lelemalaga te ri, na ke ballaga rea roma, “Bainga ra taru reke sosoali nga kalinane aekia ki?” ");
INSERT INTO mee_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Na keke ale roma, “Taroma sana ta i a agau a baingana soali, na mangng sana ta atu kia te one.” ");
INSERT INTO mee_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Minmina nae Pilatus ke role kerea roma, “Miau ngaka rave, na ngaka tunge kalingnana kana alang te i kurumea bangapaga rae miau muni.” Avae Iurame keke ketea roma, “Ke parototokala ta mangng samungpununge agau te.” ");
INSERT INTO mee_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ri keke role minmina ta baina pangamologa a Iesus rolea pala nge lele mannangana ine role ta mateng matana a i la mateng kia. ");
INSERT INTO mee_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Minmina nae Pilatus ke taogaliu lakallo ta bale muni, na ke baꞌe ragau ta ri atung kae Iesus te i. Na ke ballage roma, “Ka one ae Kelangpatali orae Iurame ae?” ");
INSERT INTO mee_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nae Iesus ke ale ka balinglagangana kia roma, “Lomatana laeala ka orae one, o ragau palu keke turupaga kau te one?” ");
INSERT INTO mee_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Avae Pilatus ke ale ka iukiangana roma, “Ka sana iau ae Iura te. Ragau rae one muni kala nga piris re kapunu rae miau keke ulo one nga kamaume. Ko baia taru?” ");
INSERT INTO mee_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nae Iesus ke ale roma, “Kelangpatali ngaungana ka sana ore nga mogalo laekia e ngape. Taroma minmina, na barangalele rae iau teke balvali ta baina reke taoamugmuga kae Iurame sane ngeke ravu iau. Ava kelangapatali ngaungana ka sana ore nga mogalo laekia i ngape. Ke sa. Ka ore nga inte toto.” ");
INSERT INTO mee_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Minmina nae Pilatus ke ballage roma, “Na ka one a kelangapatali ae?” Nae Iesus ke ale roma, “One ko role masi roma ka iau a kelangpatali. Nga ollaeala mana na nau ke toapisigi iau. Ba nga ollaeala mana na iau ka atu ta mogalo laekia e ngape, ta baina iau nga turulomatana ta ragau ka pangamologa a kaomannmannangana kia. Ragau kinung reke momo nga pangamologa a kaomannmannangana kia keke longlonge kalingau.” ");
INSERT INTO mee_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nae Pilatus ke ballage roma, “Pangamologa a kaomannmannangana kia ka i a taru?” Ka ine role minmina tapu, na ke lelemalaga muni te Iurame ba ke role kerea roma, “Iau ka sana kalipa ka otte e soali nge i. ");
INSERT INTO mee_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ava ka i a baingamiau te ta iau ulongmalagange apulangkala te ka kae e nga Paska, na nge lao. Minmina na kaka matea taru? Kaka matea ta iau ulongmalagange Kelangapatali ae Iurame, na nge lao?” ");
INSERT INTO mee_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Na keke reli kaligi roma, “Ke sa, ka sana nga i, avae Barabas.” Bae Barabas laeala a ri ke rorole te ka i a agau a maganna soali. ");
INSERT INTO mee_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Minmina nae Pilatus ke rave Iesus, na ke role ta ri sapinge. ");
INSERT INTO mee_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ngarume na ra balingkana keke lule oalo a matana ma i a kurung orae kelangpatali te, na keke patutale nga kunna. Na keke palupage ka lungapaga e ngapotu ore belveloga. ");
INSERT INTO mee_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Na keke lola te i ba keke rorolepagalising kia roma, “One ae Kelangpatali ae Iurame, ko ngailu raumana!” Na keke tavalvale nga raguna. ");
INSERT INTO mee_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ngarume nae Pilatus ke lelemalaga muni, na ke role ka reke taoamugmuga kae Iurame roma, “Ngaka longo nasai, iau ka la lelengmalaga kia lagapotu te miau ta baina nga lomiaumatana roma, iau ka sana kalipa ka otte e soali nge i.” ");
INSERT INTO mee_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Minmina nae Iesus ke lelemalaga ka kurungana ka kurung a i a oalo a matana ba lungapagangana ka lungapaga e belveloga. Nae Pilatus ke role kerea ka rolengbaingana kae Iesus roma, “Ngaka kele, agau mannangana ikia!” ");
INSERT INTO mee_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ka ina piris re kapunu ba barangalele ra kanrea ke kele Iesus, na keke reli kaligi roma, “Ngo katupite nga maiskovu! Ngo katupite nga maiskovu!” Avae Pilatus ke role kerea roma, “Miau muni ngaka rave ba ngaka katupite nga maiskovu, ta iau ka sana kalipa ka otte e soali nge i.” ");
INSERT INTO mee_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nae reke taoamugmuga kae Iurame keke ale pangamologa te i roma, “Ka kamangng ka bangapaga te, ba bangapaga laeala ke role ta i nge mate kurumea pangamologangana ine patoe i muni kae Nutu Tuna.” ");
INSERT INTO mee_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ka inae Pilatus longe pangamologangarea laeala, na ke matau raumana. ");
INSERT INTO mee_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Na ke lu lakallo muni ta bale ba ke ballagapite Iesus roma, “One ko pa nge tai?” Avae Iesus ke sane ale pangamologa inte te i. ");
INSERT INTO mee_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Minmina nae Pilatus ke role kia ka iukiangana roma, “Ka sana omong ta alange pangamologa inte te iau ae? Ka sana longmatana nanguni roma, ka kau ka gingginga ta ulongo one na ngo lao. Ba ka kau ka gingginga ta katungpita one nga maiskovu bole.” ");
INSERT INTO mee_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nae Iesus ke ale roma, “Taroma Nutu e ngailu sane te tunge gingginga te one, na sana ta kang ka gingginga ta kumangng ka otte nge iau. Minmina na agau e ulo iau ta kamang baingana e soali ke bollau nga baingang e soali.” ");
INSERT INTO mee_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nae Iesus pangamologangana laeala ke bai kae Pilatus ta i avanga ta ulonge Iesus na nge lao. Ava reke taoamugmuga kae Iurame keke rereli kaligi roma, “Ngaroma one ngo ule agau laekia na nge lao, nae Sisa ka sana kolingana nge one. Agau e patoe i muni ka kelangpatali ke ketketea Sisa.” ");
INSERT INTO mee_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ka inae Pilatus longe pangamologa nginngina, na i ke atu kae Iesus lagapotu nga bale. Na ke tarapai nga taranga e nga kalingnana nga malle a ri ke patoe kae Ina I A Lollo, ava nga kaling ae Iburume keke patoe kae Gabata. ");
INSERT INTO mee_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na kae laeala ka i a kae e nga kalingtupu nga Paska, ba kae ke pa basema kae matana lima ba kena ka sinro. Nae Pilatus ke role kae Iurame roma, “Ngaka kele, kelangpatali ae miau ikia!” ");
INSERT INTO mee_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ava keke rereli kaligi roma, “Rave! Rave! Ngo katupite nga maiskovu!” Nae Pilatus ke ballaga rea roma, “Kaka matea ta iau katungpitange kelangapatali ae miau nga maiskovu?” Na piris re kapunu keke ale roma, “Ka sana i a kelangpatali ae mangng. Ke sa. Kelangpatali ae mangng ka i ae Sisa mana.” ");
INSERT INTO mee_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ka baina nae Pilatus ke pulia Iesus te ri ta katungpitange nga maiskovu. Minmina na ra balingkana keke rave Iesus. ");
INSERT INTO mee_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nae Iesus ke loa ka tolongana ka maiskovu ae i ta malle a ri ke patoe kae Malle A Agau Gilina Bagana, ba oreke patoe nga kaling ae Iburume kae Golgota. ");
INSERT INTO mee_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Na keke katupite nga maiskovu nga inaeala. Ba pana lua keke katupita rea nga maiskovume kala nge i. Keke katupite te nga bava e pe ba te nga bava a laeva, bae Iesus ka i ngaliua. ");
INSERT INTO mee_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ba keke katupite turunglomatana te nga maiskovu ae Pilatus paꞌe pala ore role roma: ");
INSERT INTO mee_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ba inaeala a ri ke katupite Iesus nga maiskovu ngia ke momo kokoro ta maga kunna e bollau. Ba keke paꞌe turunglomatana laeala a ri ke katupite nga maiskovu nga kaling ae Iburume, ba kaling ae ra balingkana re nga Rom eke patoe ka Latin, ba kaling ae Girikme. Nae Iura papatu keke kele. ");
INSERT INTO mee_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Minmina na piris re kapunu rae Iurame keke loa te Pilatus, na keke role kia roma, “Sono ngo paꞌe roma, ‘Kelangpatali ae Iurame’. Ngo paꞌe pangamologa a i rolea roma, ‘Ka iau a Kelangpatali ae Iurame.’” ");
INSERT INTO mee_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Avae Pilatus ke ala rea roma, “Pangamologa a iau pulia ke momo tapu.” ");
INSERT INTO mee_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ka ina ra balingkana ke katupite Iesus nga maiskovu tapu, na keke rave lungapaga rae i re ngapotu ba keke tavoa ki nga rina tugulu. Pana kenakena nge ri ke rave ina kena. Bae Iesus lungapaga ae i e ngallo ke momo bole. Ka i a lungapaga te a sana kana saingapita, a ri ke kuma kia ka malo ina kena mana. ");
INSERT INTO mee_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Minmina na ra balingkana nginngina keke palirole kerea roma, “Ita sana ngaka pallamoe. Ke sa. Ita ngaka kintoto ta kelange tai ke la ravunge lungapaga laekolong.” Ba ollaeala ke lele ta baina pangamologa a ri ke paꞌe pala nga Lau Ae Nutu Kanna nge lele mannangana ine role roma, “Keke tavoa ka lungapaga ae iau re ngapotu ngaliua nge ri, ba keke kintoto ta kelange tai ke la ravunge lungapaga ae iau.” Ka baina na ra balingkana keke kuma minmina. ");
INSERT INTO mee_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nae Iesus naname, bae naname teiteikia, bae Maria tetoto a i ae Kilopas napengana, bae Maria Magaralene kala nga ragau pattoto keke meisinsi kokoro nga maiskovu ae Iesus bole. ");
INSERT INTO mee_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Minmina na ka inae Iesus kele naname kala nga barangalele laeala a kanna a i materaumane ineke meisinsi kokoro, na i ke paꞌtaloe naname roma, “Avale laekolong, tung ikolong.” ");
INSERT INTO mee_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Na ke paꞌtaloe barangalele laeala roma, “Name ikolong nge aekolong.” Ba ngarume nga kae laeala, nae Iesus naname ke mommo nga barangalele laeala bale ae i. ");
INSERT INTO mee_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ngarume, ka inae Iesus lonamatana roma, kumangngme kinung rae Nutu tungu rea ta i kumangng ki keke rongo tapu, na i ke role roma, “Ka mate kau me.” I ke role minmina ta baina pangamologa eke paꞌe pala nga Lau Ae Nutu Kanna nge lele mannangana. ");
INSERT INTO mee_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ba ka me bagana te eke pasinue ka uain e mamaoga ke meisi nga inaeala. Minmina na keke bolue otte nga me bagana laeala, na keke parume uain kia. Na keke paupite ollaeala nga bega eke patoe ka isop kamana, ba keke kalapataea lakailu ta Iesus kaona. ");
INSERT INTO mee_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ka ine inue uain laeala tapu, na ke role roma, “Kumangng ke rong!” Na ke toatula, ba ke ngata ta kannuna kange mirana. ");
INSERT INTO mee_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Na kae laeala e Iesus mate ka i a kae e nga kalingtupu nga Paska. Ba kae e ngarume nga kae laeala ka la i a Sabat te e bollau raumana. Minmina na reke taoamugmuga kae Iurame keke ballage Pilatus ta i roleng ka ra balingkana ta sapingkole reke momo nga maiskovume kaereame, ba ta ri ravungpisiginge lavusakereame lagape ta baina sane ngeke momo nga maiskovume ka kae a Sabat. ");
INSERT INTO mee_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Minmina na ra balingkana keke loa ta agau e kapunu a ri ke katupite nga maiskovu kala nge Iesus na keke sapikole agau laeala kaename. Na keke loa ta na lua na keke sapikole kaename bole. ");
INSERT INTO mee_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ava ka ina ri ke lele ngae Iesus, na keke kele ine mate tapu. Minmina na ke sane ke sapikole kaename. ");
INSERT INTO mee_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ke sane ke sapikole kaename ava abalingkana te ke pare Iesus nga bavana ka gio. Na ka pannasa mana na totona kala nga me keke potumalaga. ");
INSERT INTO mee_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ba agau e meisi be kele ollaeala ke turulomatana ta oru ra i kela rea, ba turunglomatanangana ka kaomannmannangana kia. I ka lonamatana roma i ke rorole ka kaomannmannangana, ba ke turulomatantana nga baina miau nga lomiaupatokona bole. ");
INSERT INTO mee_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Oru nginngina keke lele ta baina pangamologa a ri ke paꞌe pala nga Lau Ae Nutu Kanna nge lele mannangana ine role roma, “Ka sana nga gina te ngeke sapikole.” ");
INSERT INTO mee_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ba pangamologa tetoto a ri ke paꞌe pala nga Lau Ae Nutu Kanna ke role bole roma, “Ri keke la kelange agau a ri ke paroe.” ");
INSERT INTO mee_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ngarume nga oru nginngina, nae Iosep e ngae Arimatea, a i a barangalele ae Iesus kanna te ava ke pakokoea lopatokona laeala ae i kurumea mataungana ka reke taoamugmuga kae Iurame, ke loa te Pilatus na ke palonge ta i ravunge Iesus lavusakia. Ka inae Pilatus ngata, nae Iesop laeala ke loa, na ke rave Iesus lavusakia. ");
INSERT INTO mee_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Bae Nikoremus, a i a agau laeala ame pala ne loa te Iesus ka rigo, ke loa ta ravunge Iesus lavusakia kala nge i. Ke loa ka oru lua ra koirea lolo onreke kuma ki nga begame. Ba oru lua nginngina maenangarea ke base agau te avolau mirana maenangana ka luana. ");
INSERT INTO mee_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Minmina na pana lua nginngina keke rave Iesus lavusakia. Na keke lulupite ka malo iname kala nga oru nginngina ra koirea lolo kurumea Iurame baingarea nga talunge agau e mate. ");
INSERT INTO mee_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na nga inaeala a ri ke katupite Iesus nga maiskovu ngia, ka ura ore nga begame ke momo. Ba baveng ore nga talunge agau e mate ngia ke momo ngallo nga ura laeala. Ka i a baveng ore sane ke pullue agau e mate ngia tale. ");
INSERT INTO mee_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Minmina na keke pullue Iesus nga malle laeala, ta kae laeala ka i a kae ae Iurame e nga kalingtupu nga Paska. Ba baveng laeala ke momo kokoro bole. ");
INSERT INTO mee_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ka sinro luluna ka kae e kapunu nga kumangnga maina ina osuguna tale, nae Maria Magaralene ke loa ta bavang a ri ke pullue Iesus lavusakia ngia. Na ke kele lollo ine sane momo tale nga baveng kaona. ");
INSERT INTO mee_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Minmina na i ke pira te Saimon Pita riluae barangalele laeala ae Iesus materaumane, na ke role kerea roma, “Keke ravumalaga patali kae Avolau nga baveng. Ba ka sana lomangngmatana roma, keke pulia nga ine ngaetai.” ");
INSERT INTO mee_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ka bainae Pita kala nga barangalele laeala ae Iesus materaumane keke kutapu eke lola ta baveng. ");
INSERT INTO mee_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ri pana lua keke pirpira kinung, ava barangalele laeala ae Iesus materaumane ke kavesia Pita, na ka i pala ta baveng. ");
INSERT INTO mee_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Na ke magolo ka tangkepangana lakallo ta baveng. Na ke kele malo ina reke lulupite Iesus lavusakia ki ineke kenkeno nangina ngallo, ava i ke sana lu lakallo. ");
INSERT INTO mee_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ngarume isura, nae Saimon Pita e loa kurumea ke lele na ke lu lakallo ta baveng. Ba i ke kele malo iname ineke keno nangina. ");
INSERT INTO mee_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ba ke kele malo eke rugupite Iesus kunna kia ine sane keno kala nga malo ina reke lulupite Iesus lavusakia ki. Ke momo mana me i ka kiningngana nga inte toto. ");
INSERT INTO mee_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Minmina na barangalele laeala ae Iesus materaumane ore lele kapunu nga baveng ke lu lakallo bole. Na i ke kela na ka lonapatokona. ");
INSERT INTO mee_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ta ri ke sane ke ravu lomatana tale ta pangamologa nga Lau Ae Nutu Kanna ore role ta inae Iesus la sigingpaga nga mateng. ");
INSERT INTO mee_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ka baina na barangalele lua nginngina rae Iesus kanna keke galiu. ");
INSERT INTO mee_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Avae Maria Magaralene ke meisinsi apotu nga baveng laeala ba ke tantani, ba ke magolo ka tangkepangana lakallo ta baveng. ");
INSERT INTO mee_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Na ke kele anggelome ka ri lua ra karea ka lungapaga reke kavauvaunga keke tattara nga inaeala ae Iesus lavusakia keno ngia pala. Te ke tara nga malle a kunna keno ngia, ba te ke tara nga malle a kaena puname ke keno ngia. ");
INSERT INTO mee_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Na keke ballage roma, “Avale laekolong, ko meimia o tantani?” Na i ke ala rea roma, “Keke ravupatali kae Avolau ae iau, ba ka sana laumatana roma, keke pulia nga ine ngaetai.” ");
INSERT INTO mee_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ke ine role minmina tapu, na i ke kampiliu ba ke kele Iesus ine meisinsi nga inaeala. Ava i ka sana lonamatana roma, ka i ae Iesus. ");
INSERT INTO mee_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nae Iesus ke role kia roma, “Avale laekolong, ko meimia o tantani? Ko sissilia tai?” Nae Maria ka lonavavai roma, ka i a agau e ellapatali ta ura laeala. Minmina na i ke role kia roma, “Apanung laekolong, ngaroma ngo ravupatali kia, na ngo turu pakau ka ina one ule ngia. Na nga rave.” ");
INSERT INTO mee_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Nae Iesus ke role kia roma, “Maria!” Nae Maria ke kampiliu ba ke role kia nga kaling ae Iburume roma, “Raboni!” (ka mirana roma, Apangalomatanakana). ");
INSERT INTO mee_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nae Iesus ke role kia roma, “Ko sano ngo kali kau, ta iau ka sana loapatae te Tamau tale. Ava ngo loa ta kolingau memena, na ngo role kerea ka pangamologangau laekia roma, ‘Iau ka galiliu te Tamau bae Tamamiau. Ka galiliu te Nutu ae iau bae Nutu ae miau.’” ");
INSERT INTO mee_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Minmina nae Maria Magaralene ke loa ta barangalele rae Iesus kanna, na ke turulomatana te ri roma, “Iau ka kele Avolau.” Ba ke turu pakerea ka oru nginngina rae Iesus role pakia ki. ");
INSERT INTO mee_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ka laio, ka kae laeala e kapunu nga kumangng maina, na barangalele rae Iesus kanna keke katukala kinung. Ba keke matautaue reke taoamugmuga kae Iurame, minmina na keke bilagipite bale a ri ke katukala ngia kana biungame tapu. Ka panna laeala, nae Iesus ke loa, na ke maisi ngaliua nge ri. Na ke role kerea roma, “Momongpengana nge momo kala nge miau.” ");
INSERT INTO mee_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ba ka ine role minmina tapu, na i ke pakosining rea ka kamaname. Ba ke pakosining rea ka bavana bole. Minmina na ri ka loreasereng raumana ineke kele Avolau. ");
INSERT INTO mee_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nae Iesus ke role kerea muni roma, “Iau ka tungtunge momongpengana te miau. Pala nae Tamau ke ba iau, minmina na iau bole ka bava miau.” ");
INSERT INTO mee_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ka ine role minmina tapu, na ke isoe kaona bovonna ba ke role kerea roma, “Iau ka tungtunge Kannu E Tupu te miau. ");
INSERT INTO mee_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ngaroma miau ngaka osurure ragau baingarea reke sosoali, na ngeke rongo. Ngaroma sana ngaka osururu rea, na ale ngeke momo tale.” ");
INSERT INTO mee_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Avae Tomas, a i a te e nga pana tangulelu ba lua a ri ke patoe kae Ririmas, ke sane momo ka inae Iesus loa te ri. ");
INSERT INTO mee_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Minmina na barangalele rae Iesus kanna reke momo ka kae laeala keke rorole kia roma, “Mangng ka kele Avolau!” Avae Tomas ke role kerea roma, “Ngaroma iau sana nga kele parongpitame mallerea nga kamaname, ba sana nga pullue kamau ririna lakallo ta parongpitame mallerea, ba sana nga pullue kamau lakallo ta bavana, na ka sana la laupatokona.” ");
INSERT INTO mee_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ngarume, ka ina kae ka ri lima ba mologi ke rongo tapu, na barangalele rae Iesus kanna keke momo ngallo nga bale muni. Bae Tomas ke momo kala nge ri bole. Minmina na, ka ina ri ke bilagipite biungame tapu, nae Iesus ke loa e maisi ngaliua nge ri. Na ke role roma, “Momongpengana nge momo kala nge miau.” ");
INSERT INTO mee_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Na ke role kae Tomas roma, “Atu ngo kalaꞌe kamang ririna nakai. Ngo kele kamaume. Ngo kalaꞌe kamang nasai, na ngo pullue lakallo ta bavau. Ba sana nga longkalasa, ava nga longpatokona.” ");
INSERT INTO mee_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nae Tomas ke role kia roma, “Ka one ae Avolau ae iau bae Nutu ae iau!” ");
INSERT INTO mee_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nae Iesus ke role kia roma, “One ka longpatokona kurumea kelangang kau. Ragau re sane ke kela iau ava ka loreapatokona nga loreasereng.” ");
INSERT INTO mee_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Bae Iesus ke kuma ka killa pattoto reke bollalau nga barangalele ra kanna ragureame bole. Ba iau ae Ion ka sana paꞌe ri kinung nga lau laekia. ");
INSERT INTO mee_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ava iau ka paꞌe na kokorai ta baina miau nga lomiaupatokona roma, Iesus ka i ae Karais, ba ka i ae Nutu Tuna. Ka paꞌe na kokorai ta baina miau nga lomiaupatokona minmina, na ngaka rave mauling e momo passavele kurumea lomiaupatokonangana te i. ");
INSERT INTO mee_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ngarume nga oru nginngina, nae Iesus ke lele muni nga barangalele ra kanna nga Sivoli Ae Taibirias. Ba ollaeala ke lele minakai roma: ");
INSERT INTO mee_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, bae Tomas a ri ke patoe kae Ririmas, bae Nataniel e ngae Kena ngae Galili, bae Sepeti tuna memena, kala nga barangalele lua pattoto rae Iesus kanna keke momo kinung. ");
INSERT INTO mee_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nae Saimon Pita ke role kerea roma, “Iau ka lola launga lea ka po.” Na keke role kia roma, “Mangng nga loa kala nge one.” Ka baina keke taepatae nga manang na keke loa. Ava ka rigo laeala na ri ke sane ke laue lea te. ");
INSERT INTO mee_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ngarume, ka sinro luluna, nae Iesus ke maisi nga taona. Ava barangalele ra kanna ke sane ke kelapatokone roma, ka i ae Iesus. ");
INSERT INTO mee_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Minmina nae Iesus ke kiu te ri roma, “Koli memena, ka sana kamiau lea ae?” Na keke ale roma, “Iii.” ");
INSERT INTO mee_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Na ke role kerea roma, “Ngaka toatape po nga manang bavana e pe na ngaka rave palu.” Ka ineke kuma minmina, na ka sana likirea ta ri utungpataenge po lakailu kurumea, i ke ponu raumana ka leame. ");
INSERT INTO mee_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Na barangalele laeala ae Iesus kanna ae Iesus materaumane ke role kae Pita roma, “Ka i ae Avolau.” Ka inae Saimon Pita longe pangamologa laeala, na i ke lupage lungapaga ae i e ngapotu ora i palale pala ta kumangng. Na ke tugutao lakallo ta me ba ke goeinsigi ta taona. ");
INSERT INTO mee_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ava barangalele pattoto rae Iesus kanna keke loa kurumea Saimon Pita ka manang, ta ri ke sane ke momo ngatauga raumana nga taona. Ba keke kuma kaligi ta utunglalange po e ponu ka leame kurume rea. ");
INSERT INTO mee_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Minmina na ka ineke so nga taona tapu, na keke kele sia e tuvtuve leame. Ba keke kele beret palu. ");
INSERT INTO mee_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Nae Iesus ke role kerea roma, “Ngaka atu ka lea palu ra miau ka lau rea nasai.” ");
INSERT INTO mee_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Minmina nae Saimon Pita ke taepatae nga manang, na ke utulelea po ta taona. Ba po ke ponu ka leame ka ri 153 reke bollalau. Leame ka ri papatu raumana, ava po ke sane marae. ");
INSERT INTO mee_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Nae Iesus ke role kerea roma, “Ka atu ngaka kani kamiau.” Na keke kallo raumana, minmina na ka sana barangalele te ballage roma, “Ka one a tai?” Ta ri ka loreamatana tapu roma, ka i ae Iesus Avolau. ");
INSERT INTO mee_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nae Iesus ke loa ba ke rave beret, na ke tunge te ri. Ba ke kuma minmina ka leame bole. ");
INSERT INTO mee_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ollaeala ka i ae Iesus lelengana a mologi nga barangalele ra kanna ragureame ngarume nga sigingpagangana nga mateng. ");
INSERT INTO mee_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Minmina na, ka ineke kani tapu, nae Iesus ke ballage Saimon Pita roma, “Ion tuna ae Saimon, matengraumanangang kau ke bollau nga ra kokorai matengraumana ngareangana kau?” Nae Pita ke ale roma, “Iii Avolau, one ka longmatana roma, iau ka materaumana one.” Nae Iesus ke role kia roma, “Ngo pakania sipsip goekia rae iau.” ");
INSERT INTO mee_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nae Iesus ke ballage Pita ka balinglagangana kia a lua roma, “Ion tuna ae Saimon, one ko materaumana iau?” Nae Pita ke ale roma, “Iii Avolau, one ka longmatana roma, iau ka materaumana one.” Nae Iesus ke role kia roma, “Ngo kelapatali masi ta sipsip rae iau reke sisina.” ");
INSERT INTO mee_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nae Iesus ke ballage Pita ka balinglagangana kia a mologi roma, “Ion tuna ae Saimon, one ko materaumana iau?” Nae Iesus balinglagangana kae Pita ine ballage pa mologi roma, “One ko materaumana iau?” ke bai ka lotani ngallo nge Pita. Minmina na i ke role kae Iesus roma, “Avolau, one ka longmatana ka orume kinung. Ka longmatana roma, iau ka materaumana one.” Nae Iesus ke role kia roma, “Ngo pakania sipsip rae iau reke sisina. ");
INSERT INTO mee_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Iau nga role kone ka kaomannmannangana roma, pala, ka ina one a taulai tale, na one ko umma ta ligong one muni. Ba ko tatao ta iname kurumea longngana mana. Ava ka ino ngo papisigi, na ko la kalange kamangme, na agau tetoto ke la ligong one. Na ke la loanga kone ta ina nga one sano bai ta loanga te.” ");
INSERT INTO mee_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ka inae Iesus role minmina, na i ke rorole ta mateng matana ae Pita la pangavolaunge Nutu giana kia. Nae Iesus ke role kae Pita roma, “Ngo atu kurume iau!” ");
INSERT INTO mee_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nae Pita ke kampiliu ba ke kele barangalele laeala ae Iesus materaumane ine tatao kurume rea. Ka i a agau ame pala ne pakenopaia kunna nge Iesus mautuna nga kaning, na ke ballage roma, “Avolau, tai ke la ulongo one ta reke la baingasoali one kamareame?” ");
INSERT INTO mee_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ka inae Pita kele, na i ke ballage Iesus roma, “Avolau, taru ke la leleng nge aekolong?” ");
INSERT INTO mee_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Nae Iesus ke ale roma, “Ngaroma iau nga matea ta i momong ta nge lele nga ina iau nga atu, ka sana ora kaning. One ngo atu kurume iau.” ");
INSERT INTO mee_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ngarume na pangamologa te ke tao kalaoka ngaliua nga ra lopatokonakana roma, barangalele laeala ke sane la mateng. Avae Iesus ke sane role kia roma, ke sane la mateng. Ke sa. I ke rolea pangamologa laekia mana roma, “Ngaroma iau nga matea ta i momong ta nge lele nga ina iau nga atu, ka sana ora kaning.” ");
INSERT INTO mee_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ka i a barangalele laeala mana e turulomatantana ta oru kokorai, ba i ke pa rea nga lau. Ba ita ka loramatana roma, turunglomatanangana ka kaomannmannangana kia. ");
INSERT INTO mee_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ka oru pattoto ba ka ri papatu onrae Iesus kuma ki bole. Ava ngaroma ri ngeke ava ta pange lau reke pamologa ta oru nginngina kinung, na nga kelangaungana, mogalo laekia e ngape ka sana nga malle ta pulinge lau nginngina kinung ngi. ");
INSERT INTO mee_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teopailus, nga lau ora iau paꞌe pala iau ka paꞌe orume kinung rae Iesus kuma ki be palomatana ki ka ina i pature kumangngana ");
INSERT INTO mee_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ta ke lele nga kae ae Nutu ravupataea lakailu. Ba pala ta Nutu ravungpataenge lakailu nae Kannu E Tupu ke paginggingia Iesus ka ine tunge potongana ta aposel rae i ra i toro rea. ");
INSERT INTO mee_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ngarume nga matengana na i ke pakosininge ragau nginngina ka i muni ba ke kuma ka oru matantana nga matarea kanname ta baina ri nga loreapatokona roma, i ke momomauli ka kaomannmannangana. Ka panna a kaeme ka ri giaukaina lua na i ke lele nga matarea kanname ba ke tuture Nutu kelangpatalingana. ");
INSERT INTO mee_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ba ka kae te ka ine kaninni kala nge ri, na i ke tunge bangapaga laekia te ri roma: “Miau ka sana ngaka kaꞌe Ierusalem ava ngaka momalla ta tunga ama iau role te orae Tamau patokala ta i tunge. ");
INSERT INTO mee_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ta Ion ke pamagoegoe ka me ava nga kae te e ngarume isura nae Nutu ke la pangamagoe miau kae Kannu ae i E Tupu.” ");
INSERT INTO mee_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ka baina ka ineke katukala na ri keke ballage Iesus roma, “Avolau, ko la pulinge re ngae Israel ta baina ri kelangpatali ta ragau muni gai?” ");
INSERT INTO mee_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Na i ke ala rea roma, “Ka sana ora kanimiau ta nga lomiaumatana ka toe rae Tamau puli rea kurumea lonanganame. ");
INSERT INTO mee_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Avae miau kaka la ravunge gingginga nga inae Kannu E Tupu nge atupai nge miau. Na miau ala ngaka turulomatana kau ta ragau ngae Ierusalem, ba nga ina nge ngae Iurea ba Sameria, ba nga iname karolu nga mogalo laekia e ngape.” ");
INSERT INTO mee_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ka ine role minmina tapu, nae Nutu ke ravupataetaea lakailu nga matarea kanname ta keke kelasangsangue nga mumuka. ");
INSERT INTO mee_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ka ineke kelkela lakailu ta tava tale na ka panna laeala mana na pana lua ra karea ka lungapaga reke kavauvaunga keke meisi kala nge ri. ");
INSERT INTO mee_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Na ri pana lua keke ballaga rea roma, “Miau re ngae Galili, kaka meimia aka meisinsi ba ka kelkela lakailu ta tava? Iesus laekia ae Nutu ravupatali miau kia ta tava ke la kangagaliu muni basema kelang ngamiaungana kia ine lopatae ta tava.” ");
INSERT INTO mee_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Na keke kele oru nginngina ka ina ri ke meisinsi nga Kapoponga Nga Bega Ra Oliv. Ba kapoponga laeala ke momo ngatauga isura ngae Ierusalem. Ka baina keke kaꞌe inaeala na keke galiu ta maga kunna. ");
INSERT INTO mee_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ba ka ineke lele, na keke loa lakailu ta bale te bilingana e ngailu. Na keke momo. Ragau nginngina giareame roma: Pita, bae Ion, bae Iems kala nge Anru; bae Pilip, bae Tomas, bae Bartolomiu kala nge Matiu; bae Iems te muni ka i ae Alpaeus tuna, bae Iuras ka i ae Iems tuna kala nge Saimon eke patoe kae “Selot”. ");
INSERT INTO mee_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ra nginngina ba ravale palu kala nge Iesus naname ae Maria bae Iesus kolingana memena keke katukala kinung ba keke kavkava palimule te Nutu. ");
INSERT INTO mee_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ka kae te ngarume isura, na ra lopatokonakana keke katukala kinung. Ba ri keke basema ragau ka ri giaukaina lima ba kena. Minmina nae Pita ke meisi ");
INSERT INTO mee_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","na i ke pamologa roma, “Kolingau memena, Kannu E Tupu ke pulimalage pangamologa e te Iuras nga Revit kaona nga Lau Ae Nutu Kanna pala. Ba pangamologa laeala ke lele ka kaomannmannangana kurumea Nutu lonangana. Bae Iuras ka i a agau e taoamuga ka ragau reke laue Iesus ba ka i agau te ngaliua nge ita kurumea, Iesus ke pulia ta i taonga kala nge ita bole.” ");
INSERT INTO mee_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pita ke role minmina bae iau ae Luk ka bai ta turunglomatana kae Iuras bole ine rave lollokanna nga baingana e soali na ke kolia mogalo inte kia. Ngarume na i ke pupu ka matengana nga mogalo inaeala ae i kolia, na maganna iname keke lelemalaga. ");
INSERT INTO mee_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Minmina na ragau kinung reke momo ngae Ierusalem keke longe ollaeala, na keke patoe mogalo inaeala kae Akelarama nga kaling ae ri. Ba Akelarama ka mirana roma, “Mogalo A Toto.” ");
INSERT INTO mee_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Bae Pita ke rolea pangamologa palu muni re te Iuras roma, “Iau ka role minmina ta pala na keke paꞌe pangamologa nga Lau A Baunga Re Nga Kalangpaga ore role roma, “‘Bale ae i nge momopalikovauu mana, ba ke sana nga agau te nge momolu ngia,’ ba bole ri keke paꞌe pangamologa ore role roma, “‘Agau tetoto nge rave mallena ngaliua nga reke taoamugmuga ka ragau.’ ");
INSERT INTO mee_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Minmina nae ita ngaka pulia apanung te kala nge ita ta i turunglomatana kae Iesus sigingpagangana nga mateng. Agau laeala nga i a agau e mommo ngaliua nge ita ka kaeme kinung ka inae Iesus Avolau tatao kala nge ita. Ba bole agau laeala momongana kala nge ita nge paturu ngae Ion kumangngana e ta pangamagoe ba nge loa bavakena ta kae laeala ae Nutu ravupatali ita kae Iesus ta tava.” ");
INSERT INTO mee_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ka baina keke rave pana lua: Te ka giana nge Matias ba agau te muni ka giana nge Iosep eke patoe kae Barasavas ba a giana te muni nge Iastus. ");
INSERT INTO mee_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Na keke kava roma, “Avolau, ka longomatana ka oru reke momo ngallo nga ragau kinung loreame. Minmina na one ngo papanau mangng ka te a one tore nga pana lua kakai ");
INSERT INTO mee_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ta baina i nge rave Iuras mallena nga kumangng a kaning. Na nga i a aposel te ta Iuras ke kaꞌe mallena na ke loa ta malle e nga alange baingana e soali.” ");
INSERT INTO mee_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ka baina keke kintoto nae Matias giana ke ulopai. Minmina na i ka i a aposel te kala nga pana tangulelu ba kena nginngina. ");
INSERT INTO mee_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ka kae e bollau orae Iurame eke patoe kae Pentekos na ra lopatokonakana keke katukala kinung nga malle te. ");
INSERT INTO mee_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ba ka pannasa mana na oru a maina ma sauu e bollau ke atupisigi nga tava ba ke paponue iname karolu ngallo nga bale a ri ke tattaralu ngia. ");
INSERT INTO mee_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ba ri keke kele oru reke base ma sia miminname ra sinrea ma ragau tengtengkereame. Na miminna nginngina keke palitavao kerea ba keke loa eke tara nga agau kenakena. ");
INSERT INTO mee_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Minmina na ri kinung keke ponu kae Kannu E Tupu. Na keke paturu ta pangamologa ka kaling re nga galiau pattoto kurumea Kannu E Tupu pangaginggingngana kerea. ");
INSERT INTO mee_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ba ka kae laeala e ngae Pentekos nae Iura papatu keke momo nga maga kunna laeala ae Ierusalem. Ba ra nginngina ka ri ra kavangkana palimule ba keke pa nga magame kinung ngape nga tava. ");
INSERT INTO mee_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ka ineke longe oru maina laeala, na maluame keke katukala kinung ka loreapalilli ngarea kurumea, kenakena nga ra nginngina keke longlonge ra lopatokonakana ineke pamolloga nga kaling orae malua kenakena. ");
INSERT INTO mee_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Na keke ballaga ka kalinglo ngareangana roma: “Ra kakai ka ri re ngae Galili ");
INSERT INTO mee_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ava ke meimia na ita kaka longlonge ineke pamolloga ka kaling a ita kenakena? ");
INSERT INTO mee_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ka ita re ngae Partia, bae Miria, bae Elam; ba ngae Mesopotemia, bae nga ina ngae Iurea, bae Kaparosia; ba ngae Pontus bae Esia, ");
INSERT INTO mee_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ba ngae Peragia bae Pampilia, ba ngae Isip ba ina nge ngae Libia kokoro ngae Sairin. Ba palu nge ita ka ri re ngae Rom; ");
INSERT INTO mee_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ba ka ita ra Iura kala nga ra sana ri ra Iura aveke rave lopatokona orae Iurame; ba palu re ngae ita bole ka ri re ngae Kiriti ba ngae Arebia—ava ita kinung kaka longo rea nga kaling a ita kenakena ineke pamolloga ta oru reke bollau ra Nutu kuma ki!” ");
INSERT INTO mee_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Na keke palibalaglaga rea ka loreapungana ba kalinglo ngareangana roma, “Taru ke lele ikia ba ka puna mina ngaetai?” ");
INSERT INTO mee_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ava palu nge ri keke baipagalising kerea roma, “Keke inue uain raumana.” ");
INSERT INTO mee_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nae Pita ke meisi kala nge Pana Tangulelu Ba Kena na i ke kura kaligi ta maluame roma, “Miau ra kolingau memena ra Iura ba miau kinung raka momo ngallo ngae Ierusalem. Ngaka longo nasai te iau, ta iau ka la turunge ollaekia e lele nakai puna minmina: ");
INSERT INTO mee_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ra kokorai ke sane ke inu base ina miau ka role. Ka kae matana a lima ba tugulu gialgiala mana ka sinro! ");
INSERT INTO mee_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ke sana minmina. Ava ke pala na agau e toe Nutu kaona ae Ioel ke pamologa ta ollaekia roma: ");
INSERT INTO mee_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Nutu ke role roma, ‘Nga momong gunguna, na iau ka la kengalinge Kannu ae iau nga ragau kinung. Na goe rae miau ra panung ba na ra bale keke la pulingmalagange pangamologa a kanau ta ragau, ba goe rae miau ra ri ra taulai keke la kelange kelanga rae Nutu pakosining rea ki, bae Nutu ke la pakenongminge ravollalau kamiau memena reke papisigi tapu. ");
INSERT INTO mee_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ba muni, nga barangalele ra kanau ra panung ba na ra bale bole, iau ka la kengalinge Kannu ae iau nge ri ka kae nginngina, na ri keke la pulingmalagange pangamologa a kanau ta ragau. ");
INSERT INTO mee_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ba iau ka la kosining ka oru reke bollalau ngailu nga tava, ba killa reke bollalau ngape nga mogalo, toto ba poi ba sia kaina reke bollalau. ");
INSERT INTO mee_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kae e momo nga tava ke la kamongpiliu, na nga i a osuguna, ba inna nga i a toto pala nga kae laeala e bollau raumana ore nga Avolau atungngana. ");
INSERT INTO mee_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Bae Avolau ke la ravunglelenge ragau kinung reke kiu te i.’” ");
INSERT INTO mee_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Nae Pita ke role bole roma, “Miau re ngae Israel ngaka longo nasai! Ka inae Iesus e ngae Nasaret kumkuma ka kumangng reke bollalau, ba oru reke gingging, ba killa reke bollalau ngaliua nge miau, na kumangngana nginngina keke pakosining miau roma Nutu ke baꞌe. Miau ka lomiaumatana tapu ka oru nginngina. ");
INSERT INTO mee_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Bae Nutu ke pulia lona tapu ta i ulonge Iesus nga kamamiaume. Ba i ke potopita ngallo nge i muni ba ka lonamatana pala tapu ka oru ra miau ka la kumangng ki nge Iesus. Minmina na miau kaka bupage ragau reke sosoali lorea. Na ri keke balia e mate ka katungpita ngareangana kia nga maiskovu. ");
INSERT INTO mee_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Avae Nutu ke pasigipage nga mateng. Mateng ka sana kana gingginga ta kamongpitange, minmina na i ke ravulelea nga mateng samangpitangana kia. ");
INSERT INTO mee_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Iau ka role minmina kurumea, pala nae Revit ke bai ka rolengana e te Iesus roma: “‘Iau ka kele Avolau ngamuga nge iau ka kaeme kinung. I ke momo ta kalaunga iau ta baina iau ka sana nga mammalu ka mataunga. ");
INSERT INTO mee_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Minmina na iau ka logumannmanna ba pangamologangau ke ponu ka serenga; ba mirau nge momomasi ba nge momalle Nutu bole. ");
INSERT INTO mee_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ta One Ae Nutu ko sano la kangamana iau nga malle nga reke mate e momo ngape bavakena, ba bole One ko sano la ulonge Agau Ae One E Tupu ta i bonang. ");
INSERT INTO mee_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","One ko papanau iau ka pamau reke loa ta mauling; ba momongang kala nge iau ke la paponung iau ka serenga.’” ");
INSERT INTO mee_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pita ke role minmina tapu na ke role muni roma, “Kolingau memena, iau nga turupota te miau ka sisiukita ae Revit. I ke mate na keke talue ba o ae i ikolong tale. ");
INSERT INTO mee_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ava ka i a agau e toe Nutu kaona. Minmina na i ka lonamatana ka taru ora Nutu patokala kia te i roma, i ke la pulinge sivuna te nga tarang ae i ore nga kelangpatali ngarume. ");
INSERT INTO mee_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Revit ke kele taru orae Nutu ke la kumangng kia ngarume, minmina na i ke role ta Karais sigingpagangana nga mateng ine role roma, ‘Nutu ke sane kamane nga malle nga reke mate e momo ngape bavakena, ba mirana ke sane bona bole.’ ");
INSERT INTO mee_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Nutu ke pasigipage Iesus laekia nga mateng ba mangng ka kele ollaeala ka matamangng kanname mannangana. ");
INSERT INTO mee_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ba i ke ravupataea ta bavana e pe ba ke tunge Kannu E Tupu te i base inae Nutu a i ae Tamana patokala te i pala. Na oru nginngina ra miau ka kela rea ba longo rea gialgiala mana ka i a tunga ora i kelingia nge mangng. ");
INSERT INTO mee_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Revit muni ke sane lopatae lakailu ta tava, ava i ke role roma, “‘Nutu a i ae Avolau ke role kae Avolaukau roma: “Ngo tara nga bava nga kamau e pe nga malle a alangpaga ");
INSERT INTO mee_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ta nge lele nga kae laeala a iau la ulopisiginge reke baiꞌiu kone ngape nga kaeng sianame.” ’ ");
INSERT INTO mee_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Minmina na Israelme kinung nga loreamatana ka kaomannmannangana roma: Nutu ke pulia Iesus laeala a miau ka katupite nga maiskovu ta i nga giana ngailu nga giame kinung ba ta i ae Karais bole.” ");
INSERT INTO mee_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na ka ina ragau nginngina ke longo minmina, na pangamologa laeala ke pare lorea mannangana. Minmina na keke ballage Pita kala nga kolingana memena ra ri ra aposel roma, “Kolime, ita kaka la maingamia?” ");
INSERT INTO mee_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ka bainae Pita ke ala rea roma, “Miau kenakena ngaka pulivalakale baingamiau reke sosoali na ngaka tunge lomiaumatenganame te Nutu. Ba ngaka rave pangamagoe nga Iesus Karais giana ta baina Nutu nge osurure baingamiau reke sosoali. Nae Nutu ke la tungnge tunga a i ae Kannu E Tupu te miau. ");
INSERT INTO mee_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ta Nutu ke patokala ta i tunge ollaeala te miau kala nga goe rae miau ba ta ragau kinung reke momo nga ina re ngatauga. Patongkala laeala ke pulisivale ragau kinung rae Nutu ba ta ri atung te i.” ");
INSERT INTO mee_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Bae Pita ke tunge pangamologa pattoto reke gingging bole ta baina ri kangapatali roma: “Miau ngaka ravulele miau ta baina miau ngaka kapatali nga alanga e la atungpai nga ra baingareame ke sosoali.” ");
INSERT INTO mee_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ka kae laeala na ragau papatu ka ri base ma 3,000 keke ngatakale Pita pangamologangana. Na keke rave pangamagoe ba keke momosivala kinung kala nga ra lopatokonakana te Karais. ");
INSERT INTO mee_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Na ra lopatokonakana te Karais keke matea raumana ina aposelme ke palomatantana rea. Ba bole keke palitungtungu karea oru, ba keke kaninni ba keke kavkava kinung. ");
INSERT INTO mee_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ba aposelme keke kumkuma ka kumangng reke bollalau ba oru reke gingging. Na ragau kinung keke kallo. ");
INSERT INTO mee_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ba ra lopatokonakana keke momo kinung ba orume ka oru nga kanrea kinung. ");
INSERT INTO mee_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Keke bava ka oru nga kanrea na keke tavova ka lollokanna ngaliua nge ri kurumea kenakena lonamatengana ka oru. ");
INSERT INTO mee_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ka kaeme kinung na keke katualla kinung ngallo nga tempel ba keke kaninni kinung nga bale nga ri ka serengarea ba loreapengana. ");
INSERT INTO mee_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Keke kalapagpage Nutu ba ragau karolu ka loreape ka ra lopatokonakana. Ba ka kae kenakena nae Nutu ke pulisivalvale ragau pattoto ra i raravulele rea kala nga ra lopatokonakana nginngina. ");
INSERT INTO mee_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ka kae te ka laio nae Pita bae Ion keke lolapatae ta tempel ka kae matana a mologi. Ka i a kae matana ore nga kavang. ");
INSERT INTO mee_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ba ka panna laeala na ragau keke paue agau te a kaename ke mate ka ina naname toapisigia ta ri pulinge nga tempel kaona eke patoe ka Pemannmana. Keke pulpulia agau laeala nga inaeala ka kaeme kinung ta baina i nge kalunglung kana oru nga ragau reke taolulu ta tempel. ");
INSERT INTO mee_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Na ka ina kaemate laeala kele Pita bae Ion ineke taolulu, na i ke ballaga rea ta lollokanna. ");
INSERT INTO mee_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Minmina nae Pita riluae Ion ke kelatupu te i. Nae Pita ke role kia roma, “Kela nasong te mangng!” ");
INSERT INTO mee_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ka baina agau laeala a kaenamate ke kelkela ta ri pana lua roma ri ke la tunga kana oru. ");
INSERT INTO mee_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nae Pita ke role kia roma, “Ka sana kanau lollokanna ora siliva o ora gol bole, ava ka la tungnge ore momo nge iau te one. Nga Iesus Karais e ngae Nasaret giana, ngo tao.” ");
INSERT INTO mee_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nae Pita ke rapite nga kamana e pe ba ke pasipage. Na bolvole mana na agau laeala kaename ba kaena bukuname keke lele gingging. ");
INSERT INTO mee_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Minmina na kaemate laeala ke tugutao ka kaename ba ke paturu ta i taonga. Ngarume na i ke taolu kurume rea lakallo ta tempel bilinganame ka taongana ba tugungtaongana ba kalangpagangana kae Nutu. ");
INSERT INTO mee_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Na ka ina ragau ke kele kaemate laeala ine tatao be kalapagpage Nutu, ");
INSERT INTO mee_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","na keke kelapatokone roma, pala na ka i a agau laeala e tattara be kalunglung kana oru nga tempel kaona eke patoe ka Pemannmana. Na keke kallo raumana nga ollaeala e lele nge i. ");
INSERT INTO mee_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Na agau laeala akangalunga lollokannakana ke loakurumea Pita bae Ion ba ragau kinung keke magio raumana. Na keke lola ka pirangareangana te ri lakallo ta malle eke patoe kae Tarangalu Ae Solomon. ");
INSERT INTO mee_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Na ka inae Pita kele ollaeala na i ke role kerea roma, “Miau re ngae Israel, ke meimia a ollaekia pamagio miau? Ba ke meimia ae miau ka kelkela te mangng? Kaka roma, gingging ngamangng ba momongamangng reke pepe nge Nutu raguna ke papea agau laekia ta i taonga ae? ");
INSERT INTO mee_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nutu a i ae Nutu ae Abaram bae Aisak bae Iekop, ba ka i a Nutu ae sisiukita memena ke pulipataea barangalele a kanna ae Iesus giana raumana. Ava miau kaka ule ta mateng ba kaka kaulikale nga Pilatus raguna. Pilatus ke bai ta bange ta i loanga ava miau kaka gingginga raumana ta bainga kia minmina tale. ");
INSERT INTO mee_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Miau kaka tangulelea Agau Orae Nutu Tore Ta I Kumangng Ka Kumangng A Kanna ba ka i a Agau A Bainganame Ke Tupu. Na kaka matea ta Pilatus nge ulomalage agau te a i a abalingpunu ragaukana. ");
INSERT INTO mee_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Miau kaka sapune agau a i a mauling puna, avae Nutu ke pasigipage nga mateng. Na mangng ka kele ollaeala ka matamangng kanname mannangana. ");
INSERT INTO mee_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nga gingginga nga Iesus giana mana na agau laekia kaename keke gingging. Ollaekia a miau ka kele ba lomiaumatana kia ka puna nga lopatokona e te Iesus giana. Lopatokona e te Iesus ke papea nga miau kinung matamiau kanname. ");
INSERT INTO mee_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Kolingau memena, iau ka laumatana tapu roma, miau kala nga reke taoamuga kamiau ka sana lomiaumatana ka taru a miau ka kumkuma kia mirana. ");
INSERT INTO mee_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ava oru ra miau ka bai kia nge Iesus ke loakurumea oru rae Nutu turulomatana tao pala nga ragau kinung reke toe kaona pangamologangarea ineke role roma, Karais ae Nutu ke la ravunge miralali. ");
INSERT INTO mee_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Minmina na miau ngaka pulivalakale baingamiau reke sosoali na ngaka tunge lomiaumatengana te Nutu. Ba ngaka kampiliu te Nutu ta baina i nge osurure baingamiau reke sosoali na ala i a kae ora Nutu panne maulingamiaungana. ");
INSERT INTO mee_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Na i nge baꞌe Iesus a i ae Karais ore tore pala ta i tungnge te miau. ");
INSERT INTO mee_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","I nge momo ngallo nga Nutu mallena nga tava ta nge lele nga kae rae Nutu la kumangnggaliu ka orume kinung base ine patokala nga ragau reke toe Nutu kaona re tupu pala. ");
INSERT INTO mee_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ke loakurumea pangamologa a Moses rolea pala ine role roma, ‘Avolau a i ae Nutu ke la pangamaisinge agau e toe Nutu kaona base me iau ngaliua nga ragau rae miau muni. Ba miau ngaka longo ta oru ra i la turung rea pakamiau. ");
INSERT INTO mee_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ngaroma agau te sane nge longo te i, nae Nutu nge katotopatalia nga ragau rae Nutu.’ ");
INSERT INTO mee_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Ba bole ragau reke toe Nutu kaona kinung pangaturu nge Samuel nasai, ri kinung reke pulimalage pangamologa ae Nutu kanna keke rorole pala ta kae kakai rae sonrau. ");
INSERT INTO mee_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ri ka ri ra sisiukamiau memena ba piunga ba bonga laeala ora Nutu kuma kia kala nga tamamiau memena ka orae miau kinung. Nutu ke role te sisiukamiau ae Abaram roma, ‘Iau ka la kavingtulunge ragau kinung re nga mogalo laekia e ngape nge sivung te.’ ");
INSERT INTO mee_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nutu ke baꞌe Barangalele A Kanna ae Iesus ora i pasigipage te miau kapunu ta i kavingtulu miau ka kamongpiliungana ka miau kenakena nga baingamiau reke sosoali.” ");
INSERT INTO mee_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Na pirisme ba agau e kapunu nga ra kurtalingling nga tempel kala nga Sarusime keke loa te Pita rae Ion ka ineke pamolloga tale ta ragau. ");
INSERT INTO mee_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ba ri ka sana siareape ka ina aposelme ke palomatantane ragau ba keke pulimalage pangamologa roma, Nutu ke la pangasigingpagange ragau ra loreapatokona te Iesus nga mateng. ");
INSERT INTO mee_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Minmina na keke laue Pita bae Ion, na keke pullue ri pana lua nga pulangkala ta momongkalange kae e ngarume ta ka laio tapu. ");
INSERT INTO mee_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ava ragau papatu reke longe pangamologangarea ka loreapatokona te Iesus. Minmina na ra lopatokonakana kinung keke lele basema ragau ka ri 5,000. ");
INSERT INTO mee_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Me ngangaila, na re kapunu nga Iurame ba ravollalaukerea memena kala nga ra pangalomatanakana nga bangapagame keke katukala kinung ngae Ierusalem. ");
INSERT INTO mee_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas a i a piris e kapunu, bae Kaiapas, bae Ion, bae Aleksanrer kala nga ragau palu re nga balekaina ae piris e kapunu keke momo bole. ");
INSERT INTO mee_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Na keke role ta ri atung kae Pita bae Ion ta pangamaisi rea nga ragurea. Na keke paturu ta balinglaga rea roma, “Kaka meimia ka kumangng ngamiau ka ollaekia? Gingginga a taru ke momo nge onemea, o kaka kumkuma nga tai giana?” ");
INSERT INTO mee_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nae Kannu E Tupu ke ponu nge Pita ba i ke role kerea roma, “Miau re kapunu nga ragau ba miau ra bollalau! ");
INSERT INTO mee_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ngaroma miau ngaka ballaga mangnga sonrau ka ore pe a mangng kuma kia nga agau a kaenamate ba ke meimia ka pengana. ");
INSERT INTO mee_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Na miau kala nga ragau kinung re ngae Israel nga lomiaumatana roma: Nga gingginga nge Iesus Karais e ngae Nasaret giana a i a agau ora miau ka katupite nga maiskovu ave Nutu ke pasigipage muni nga mateng, nga gingginga nga gia laeala mana agau laekia e meisinsi ngamuga nga ragumiau mirana ke pe bavakena. ");
INSERT INTO mee_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iesus ka i a “‘Lollo ama miau ra popongpita ka tangulelea, ba ka i a lollo e lele i a lollo kena a kana ka gingginga ma mais e maisgingging ka bale.’” ");
INSERT INTO mee_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ka sana agau te muni a kana ka gingginga ta i ravunglelenge ragau, ta ke sana gia te muni ngape nga tava ora Nutu tunge ngaliua nga ragau ta ita patonge ta baina ita ngaka kapatali nga alang e soali. ");
INSERT INTO mee_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Na ra nginngina keke kele Pita bae Ion ine sane ke matau ka ineke pamolloga. Ba keke kelapatokona rea roma, ka ri ra ragau mana. Ke sane ke rave pangalomatana. Minmina na keke magio ba keke kelapatokona rea roma, pala na keke tatao kala nge Iesus. ");
INSERT INTO mee_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ava ra nginngina ka sana kanrea pangamologa kurumea, keke kele agau laeala a mirana pe ine meisinsi kala nge ri. ");
INSERT INTO mee_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ka baina keke role ta Pita bae Ion ngeke lelemalagapatalia Ginunga Nga Reke Taoamugmuga Ka Iurame. Na keke palibalaglaga rea roma, ");
INSERT INTO mee_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ita kaka la maingamia ka ri pana lua? Ragau kinung re ngae Ierusalem ka loreamatana roma, ri pana lua keke kuma ka oru e bollau raumana ba ita ka sana ngaka kaulikale. ");
INSERT INTO mee_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ava ita ngaka parototokala rea ta ri manereasa pangamologa ta agau te muni ka gia laekia. Minmina na ollaekia ke sane nge loa lagatauga ta ragau.” ");
INSERT INTO mee_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Na keke kiulu ka ri pana lua muni. Na keke role gingging kerea ta ri manereasa pangamologa ta ragau te Iesus ba ta ri manereasa pangalomatanange ragau ta ri loreamatanangana kae Iesus. ");
INSERT INTO mee_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Avae Pita bae Ion keke ala rea roma, “Miau nga lomiaukanana roma, taru ke pe nge Nutu raguna. Ta mangnga longa te miau o ta mangnga longa te Nutu? ");
INSERT INTO mee_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ava mangng ka bai ta roleng kamiau roma, ke isopa raumana ta mangng kaulingkalange oru ra mangng ka kela rea ba longo rea.” ");
INSERT INTO mee_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Minmina na ka ina ri ke role gingging kae Pita bae Ion muni, na keke ba rea eke lao. Ka sana kanrea pangamologa kena ta tungnge alanga te ri pana lua kurumea, ragau kinung keke kalapagpage Nutu kurumea oraeala e lele nga agau laeala a kaenamate. ");
INSERT INTO mee_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ba agau laeala a kumangnga e bollau lele nge i ta pangapenge mirana ka kana pesingmataname ka ri giaukaina lua tapu. ");
INSERT INTO mee_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Na ka inae Pita bae Ion ke lelemalaga nga kalingnana tapu, na keke galiu ta ragau rae ri ba keke ture orume kinung ra re kapunu nga pirisme ba ravollalau ke role kerea ki. ");
INSERT INTO mee_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Na ka ina ra lopatokonakana ke longe oru nginngina, na ri keke pagiu kinung ka kavangarea te Nutu roma, “One A Avolau E Bollau, ko pulia maga ba tava ba pelau ba oru reke momo ngi. ");
INSERT INTO mee_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ba one muni ko role ngallo nga Kannu E Tupu pangamologangana ka sisiukamangng ae Revit a i a barangalele ae one kaona ka ine role roma, “‘Ke meimia na ra sana ri ra Iura ka iukerea raumana; ba ke meimia na ragau keke palipotopita rea ta ri bainge ore soali te Nutu ava ri ka sana karea gingginga ta kumangng ka ollaeala? ");
INSERT INTO mee_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kelangpatali re nga mogalo laekia e ngape ba re kapunu nga ragau keke kalitupu rea ka sagaga ba keke palipulikinungu rea ta ri sanangkalange Nutu A I A Avolau kala nge Karais ae i orae i pulia ta kumangng ka kumangng a kanna.’ ");
INSERT INTO mee_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ollaeala ke lele ka kaomannmannangana ka inae Eroto bae Pontius Pilatus ba ragau ra sana ri ra Iura kala nga re ngae Israel keke katukala kinung nga maga kunna laekia ta baina ri potongolu barangalele e tupu ae One ae Iesus kana orae One pulia ta i kumangng ka kumangng a kaning. ");
INSERT INTO mee_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ra nginngina keke pulikinung ka kumangngarea ngallo nga orume kinung ra One potopita pala ngallo nge one muni kurumea gingginga ba lomatengana ae one. ");
INSERT INTO mee_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Minmina nae Nutu One Avolau E Bollau, one ngo kelalomatana ka ineke roleꞌiu kamangng. Na ngo paginggingi mangng ra barangalele rae one ta baina mangng sana nga matautau ka ina mangng pulimalage pangamologa a kaning. ");
INSERT INTO mee_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ngo kalaꞌe kamang ta pangapenge ragau ba ngo kuma ka killa reke bollalau ba kumangng reke bollalau ka gingginga ae Iesus a i a barangalele ae one e tupu.” ");
INSERT INTO mee_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ka ina ri ke rongo ka kavanga tapu na malle laeala a ri ke katukala ngia ke matagakalle. Ba ri kinung keke ponu kae Kannu E Tupu. Minmina na ke sane ke matau ka ineke pulimalage pangamologa ae Nutu kanna. ");
INSERT INTO mee_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Na ra lopatokonakana kinung ka ramarea kena ba ka lorea kena mana. Ka sana agau te e nge ri nge role roma, orae i ka orae i mana. Ke sa. Ri karolu keke palitungtungu karea oru. ");
INSERT INTO mee_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nga gingginga e bollau na aposelme keke pulimalaglage pangamologa e te Iesus Avolau ine sigipaga nga mateng. Bae Nutu ke kelingia kavingtulu reke bollau te ri kinung. ");
INSERT INTO mee_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ba ka sana te e nge ri moro ta kana otte. Ta nga kae palu na ragau rae ri ra karea ka mogalo o baleme ngeke ba ki, na ngeke rave lollokanna. ");
INSERT INTO mee_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Na ngeke tunge lollokanna nginngina ta aposelme, na ri ngeke tavoa ki nga ra lopatokonakana ta kalaunge kenakena a sana kana oru. ");
INSERT INTO mee_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ka kae te, nae Iura te a giana kae Iosep e nga galiau ae Livai ora naname toapisigia ngae Saipras, ba ka i a agau a aposelme ke patoe kae Barnavas (a mirana roma apangaginggingakana tuna), ");
INSERT INTO mee_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ke ba ka mogalo ae i. Na ke atu ka lollokanna nginngina ba ke tungu rea ta aposelme. ");
INSERT INTO mee_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Na agau te a giana nge Ananaias kala nga napengana a giana kae Sapaira keke ba ka mogalo inae ri inte bole. ");
INSERT INTO mee_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ba i kala nge napengana keke palingatakala rea ta natale nge kampite ka lollokanna bavana inte. Minmina na natale ke loa na ke tunge inte mana ta aposelme. ");
INSERT INTO mee_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nae Pita ke role kia roma, “Ananaias, ke meimia o ngatakale Satan ta i taongamuga kone ka baina ko goaꞌe Kannu E Tupu ka ino bolo ka lollokanna ra kaning ina palu ra one ravu rea nga mogalo ae one? ");
INSERT INTO mee_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Pala ta one banga ka mogalo ae one, na mogalo laeala ka ora kaning. Ba ka ino ba kia na lollokanna laeala ka ora kaning bole. Ke meimia na ko kuma ka oru matana laekia minakai? Ko sano gogaꞌe ragau. Ke sa. Ko gogaꞌe Nutu!” ");
INSERT INTO mee_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ka inae Ananaias longe ollaeala na i ke pupu lagape na ke mate. Na ragau kinung reke longe ollaeala e lele keke matau raumana. ");
INSERT INTO mee_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Minmina na ragau ra taulai keke lu lakallo, ba keke gasipite mirana. Na keke paue lagapotu ba keke talue. ");
INSERT INTO mee_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ka panna isunte ngarume na napengana ke lu, ava i ka sana lonamatana ka oraeala e lele. ");
INSERT INTO mee_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nae Pita ke ballage roma, “Into role pakau. Lollokanna ra onemea ningtale ka ravu rea nga mogalo ae miau, ri kinung ri korai mana ae?” Ka baina avale laeala ke ale Pita roma, “Iii, ri kinung ri korong tapu.” ");
INSERT INTO mee_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Minmina nae Pita ke role kia roma, “Ke meimia a onemea ningtale ka palingatakala miau ta avange Kannu E Tupu Ae Avolau? Ngo kela! Reke talue ningtale ialeke meisinsi ba ri keke la paunga one lagapotu bole.” ");
INSERT INTO mee_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ka panna laeala mana na avale laeala ke pupu lagape nge Pita kaena puna, na ke mate. Na ra nginngina ra taulai keke atulu lakallo, na keke kele nga ine mate. Minmina na keke paue lagapotu, ba keke talue nga natale bavana. ");
INSERT INTO mee_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Na ragau karolu ra loreapatokona te Karais onreke katualla kinung ba ragau pattoto reke longe oru nginngina reke lele keke matau raumana. ");
INSERT INTO mee_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na aposelme keke kuma ka killa papatu reke bollalau ba kumangng papatu reke bollalau ngaliua nga ragau. Ba bole ra lopatokonakana karolu keke katualla kinung nga Tarangalu Ae Solomon. ");
INSERT INTO mee_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ragau re ngae Ierusalem ra sana ri ra ra lopatokonakana keke kalapagpaga rea ava ka sana te pagiu kala nge ri. ");
INSERT INTO mee_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ava ka ragau papatu raumana bole ra panung ba ra bale ra lopatokonakana te Iesus keke pulisivala kala nge ri. ");
INSERT INTO mee_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ba aposelme kumangng ra kanrea keke bollau raumana. Minmina na ragau keke paupaue reke sosoali, na keke pakenkeno rea nga niame ba tagome nga pamau bavaname ta bainae Pita nge tatao mana. Na nunulekia nge toa ta palu nge ri nga ine nge kavesilele rea. ");
INSERT INTO mee_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ba bole maluame reke momo nga maga kunna reke kokoro ngae Ierusalem ke tatu ka reke sosoali ba ragau ra kannu reke sosoali ke lupaga rea. Minmina na ra nginngina kinung keke pepe muni. ");
INSERT INTO mee_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ngarume na piris e kapunu kala nga kolingana reke momo nga ginunga orae Sarusime keke kele oru nginngina, na keke paturu ta kelangalele raumanange aposelme. ");
INSERT INTO mee_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Minmina na keke lau rea na keke pullu rea nga bale ore nga pulangkala a i a pulangkala a ragau kinung. ");
INSERT INTO mee_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ava ka rigo laeala, na anggelo ae Nutu ke pulapatalia savanau kaoname, ba ke taoamuga ka aposelme lagapotu. Na ke role kerea roma, ");
INSERT INTO mee_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Miau ngaka loa na ngaka meisi ngallo nga tempel. Ba ngaka pulimalage pangamologame kinung re ta mauling laekia a pau a miau ka rave kurumea lopatokona ae miau te Iesus.” ");
INSERT INTO mee_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Na aposelme keke longo mana na ka sinro luluna keke taolu ta tempel, ba keke paturu ta pangalomatanange ragau. Na ka ina piris e kapunu kala nga kolingnganame ke kiukinunge Ginunga Nga Reke Taoamugmuga Ka Iurame, na keke role ta ri atung ka aposelme te ri. ");
INSERT INTO mee_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ava ka ina ra kurtalingling ke lele, na ke sane ke kalipa ka aposelme nga bale e nga pulangkala. Ka baina ri keke galiu ta ravollalau nga katungkala na keke turu pakerea roma, ");
INSERT INTO mee_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ka ina mangnga lele nga bale e nga pulangkala na mangng ka kele roma ri ke pulakale gingging, ba ra kurtalingling keke meisinsi gingging ka kelangpatalingarea nga savanau kaoname. Ava ka ina mangng pulapatalia savanau kaoname, na mangng ka sana kela paka agau te ngallo.” ");
INSERT INTO mee_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na ka ina agau e kapunu nga ra kurtalingling nga tempel ba piris re kapunu keke longe ollaeala, na ri ka loreatangtang roma, “Ollaekolong ka puna mina ngaetai?” ");
INSERT INTO mee_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Na agau te ke taolu ba ke turu pakerea roma, “Ngaka longo nasai! Ragau ra miau ka puli rea nga pulangkala iala eke palomatantane ragau ngallo nga tempel.” ");
INSERT INTO mee_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Minmina na agau e kapunu nga ra kurtalingling ke loa kala nga balinganame, na keke ravugaliue aposelme ta reke taoamugmuga ka Iurame mallerea muni. Ava ke sane ke loa kerea ka kaoreaginapitangana kerea kurumea, keke matau roma ragau ngeke tamali rea ka lollome. ");
INSERT INTO mee_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ka ina ri ke rave aposelme lakallo, na keke pamaisi rea ngamuga nga Ginunga Nga Reke Taoamugmuga Ka Iurame. Na agau e kapunu nga pirisme ke role kerea roma, ");
INSERT INTO mee_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Mangng ama role gingging ta manemiausa pangalomatanange ragau kae Iesus giana, ava ngaka kele ora miau ka kuma kia. Kaka pulimalage pangamologa ngamiau nga iname kinung ngallo ngae Ierusalem ba miau kaka bai ta ulongopainge Iesus matengana nge mangng.” ");
INSERT INTO mee_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nae Pita kala nga aposelme keke ale roma, “Mangng sana nga longo ta ragau, mangng nga longo te Nutu mana! ");
INSERT INTO mee_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nutu a i ae Nutu ae sisiukita memena ke pasigipage Iesus nga mateng nga ina miau ka sapune ka katungpita ngamiaungana kia nga maiskovu. ");
INSERT INTO mee_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nae Nutu ke pasigipage ta malle e nga alangpaga nga bavana e pe ta i a Ataongamugakana bae Aravunglelekana, ta baina re ngae Israel nga karea gingginga ta ri pulingvalakale baingarea reke sosoali ba tunge loreamatengana te Nutu. Minmina nae Nutu nge osurure baingarea reke sosoali. Na mangng ka kele oru nginngina ka matamangng kanname. ");
INSERT INTO mee_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Bae Kannu E Tupu orae Nutu tunge ta reke longo te i ke pakosininge oru nginngina bole.” ");
INSERT INTO mee_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Na ka ina ravollalau ke longe ollaeala na ka iukerea raumana, ba keke bai ta balinge aposelme ta ri mateng. ");
INSERT INTO mee_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ava Parisio a giana nge Gamaliel a i a apangalomatanakana nga bangapagame, ba ka i a agau te ora ragau karolu ke pulipataea raumana ke meisi nga Ginunga Nga Reke Taoamugmuga Ka Iurame. Na ke role ta ri ngeke rave aposelme ba ngeke lelemalaga kerea lagapotu isurangana. ");
INSERT INTO mee_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ngarume na i ke ninpage ravollalau nginngina lorea roma, “Miau re ngae Israel, ngaka kela masi mannangana ta oru ra miau ka bai ta kumangng ki nga ra kakai. ");
INSERT INTO mee_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nga lomiaugaliu ta agau ama giana kae Tiuras e lele ka kae re pala ba i ame rorole roma i a agau te a bollau, ba ragau ka ri base ma 400 keke pagiu kala nge i. Ava ragau palu keke balia na ke mate, ba reke lolakurumea keke kaka kalaoka. Na taonganame keke rongo bavakena. ");
INSERT INTO mee_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Na ngarume nge i na ka agau te muni a giana nge Iuras e ngae Galili ke lele ka kae re nga ravung gia. Na i ke taoamuga ka ragau palu ta ri sanangkalange gavaman e ngae Rom. Ava keke balia na ke mate bole, ba reke lolakurumea keke kaka kalaoka. ");
INSERT INTO mee_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Minmina na iau ka bai ta roleng kamiau masi ka ollaekolong sonrau roma: Ngaka ule ra kokorong ba ka ba rea ngeke lao! Ta ngaroma kumangng laekia ka ora kanrea mana na nge pupu. ");
INSERT INTO mee_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ava ngaroma ke atu nge Nutu na ka sana kamiau gingginga ta miau bongatotokala rea. Ba bole miau alaka amva ta sanangkalange Nutu.” ");
INSERT INTO mee_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nae pangamologa ae Gamaliel kanna ke ravugaliue lorea. Minmina na keke kiulu ka aposelme, ba keke role ta ragau ngeke sapipatoto kerea. Na keke role gingging ta ri manereasa pangamologa ta ragau nga Iesus giana. Na keke ba rea eke lao. ");
INSERT INTO mee_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Na aposelme keke kaꞌe Ginunga Nga Reke Taoamugmuga Ka Iurame ka loreaserengngana kurumea, Nutu ke kinpataea giareame ka ine ngata ta ri ngeke rave balenga kurumea lopatokona ae ri te Iesus. ");
INSERT INTO mee_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Na ka kaeme kinung ngallo nga tempel ba ngallo nga ragau bale nga ri, na aposelme ke sane ke rongo ta pangalomatanange ragau ba pulingmalagange pangamologa e pe e role te Iesus roma, ka i ae Karais. ");
INSERT INTO mee_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ka kae palu ngarume ka ina ra lopatokonakana ke umma ta ri leleng papatu, na iu ore nga pangavolo ke lele ngaliua nga Iura reke pamolloga ka kaling ae Girik ba Iura pattoto. Iura reke pamolloga ka kaling ae Girik keke pavolo kurumea, ravale re ngae ri ra matengpatali ke sane ke ravu karea kaning onreke tavova ki ka kae kenakena. ");
INSERT INTO mee_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Minmina na aposelme ka ri tangulelu ba lua keke kiukinunge ra lopatokonakana na keke role kerea roma, “Ke sane pe ngaroma kumangng e nga kelangpatali ta kaning nge ravupita mangng ra aposel, na kumangng a kanmangng ore nga pulingmalagange pangamologa ae Nutu kanna nge magogo. ");
INSERT INTO mee_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Minmina na kolingamangng memena, miau ngaka pulia pana lima ba lua nge miau onreke ponu kae Kannu E Tupu ba ka karea ka lomatana e pe. Na mangng nga puli rea nga baina ri ngeke kelapatali ta kumangnga laeala. ");
INSERT INTO mee_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ava mangnga ra aposel nga momogingging nga kumangnga ore nga kavanga ba pulingmalagange pangamologa ae Nutu kanna.” ");
INSERT INTO mee_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Na ri kinung keke ngatakale pangamologa laeala. Minmina na keke pulia ra lopatokonakana te Karais ra giareame roma: Stepan a i e ponu kae Kannu E Tupu ba lopatokona, bae Pilip, bae Prokorus, bae Nikanor, bae Timon, bae Parmenas kala nge Nikolas. Bae Nikolas ka i a agau e ngae Antiok ore kaꞌe lopatokona ae ragau rae i, na ngarume na i ke loakurumea lopatokona ae Iurame. ");
INSERT INTO mee_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Na keke loa ka ra nginngina ta aposelme. Na aposelme keke pulipaia kamarea nge ri ba keke kave Nutu te ri. ");
INSERT INTO mee_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ka baina pangamologa ae Nutu kanna ke sasa ba ra lopatokonakana keke lele papatu raumana ngallo ngae Ierusalem. Ba piris papatu bole keke longe pangamologa ae Nutu kanna na ka loreapatokona te. ");
INSERT INTO mee_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nae Stepan ka i a agau e ponu ka kavingtulu ae Nutu, ba ke ponu ka gingginga. Ba i ke kuma ka killa reke bollalau ba kumangng reke gingging ngaliua nga ragau. ");
INSERT INTO mee_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ava ragau palu re ngae sinagog eke patoe ka Sinagog orae Pulangleleme keke toakiki kae Stepan. Ka ri ra Iura re ngae Sairin bae Aleksanria ba porovins re ngae Silisia bae Esia. Ra nginngina keke paturu ta ri palingtete kala nge Stepan, ");
INSERT INTO mee_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","avae Kannu E Tupu ke tunge lomatana e pe te Stepan ta baina ka ine nge pamologa na ke sane ngeke pulipisigia pangamologangana. ");
INSERT INTO mee_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Minmina na keke bivitaoe ragau palu ta ri rolenge roma, “Mangng ka longe Stepan ine rolebainga kae Moses bae Nutu.” ");
INSERT INTO mee_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Na goangarea laeala ke pasigipage ragau ba reke taoamuga kerea kala nga ra pangalomatanakana nga bangapagame. Minmina na keke laue Stepan, na keke loa kia ta i maising ngamuga nga Ginunga Nga Reke Taoamugmuga Ka Iurame. ");
INSERT INTO mee_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ngarume na keke atu ka ragau palu muni ta ri goanga roma, “Agau laekia ke rorolebainga ka tempel ae ita e tupu kala nga bangapaga rae Moses kanna. ");
INSERT INTO mee_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mangng ka longe ine role roma, Iesus e ngae Nasaret ke la rurunge tempel ba ke la kamongpiliunge bainga rae Moses tungu rea te ita.” ");
INSERT INTO mee_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Na ra nginngina kinung reke tattara ngallo nga Ginunga Nga Reke Taoamugmuga Ka Iurame keke kelatupu te Stepan, na keke kele raguna ina tongana kena ma anggelo te raguna. ");
INSERT INTO mee_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ka baina piris e kapunu ke ballage Stepan roma, “Ka kaomanna ka pangamologa kakai?” ");
INSERT INTO mee_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nae Stepan ke ale roma, “Kolingaume ba Tamau memena, ngaka longo te iau! Pala ta sisiukita ae Abaram momongana ngae Aran ba ka ine mommo ngae Mesopotemia tale, nae Nutu a kana ka olamana e toakala ke lele nge i. ");
INSERT INTO mee_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Na ke role kia roma, ‘Ngo kaꞌe magapuna ae one ba ragau rae one, na ngo loa ta mogalo a iau la pangapanaunga one kia.’ ");
INSERT INTO mee_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Minmina na i ke kaꞌe mogalo ae Kalriame na ke tara ngae Aran. Ba ngarume nga tamana matengana nae Nutu ke baꞌe ta i momong nga inaekia a miau ka tara ngia sonrau. ");
INSERT INTO mee_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ka kae nginngina nae Nutu ke sane tunge mogalo laekia inte te Abaram. Ke sa. Ke sane tunge isunte e sina mana te i. Avae Nutu ke patokala ta ngarume na i nge tunge mogalo laekia te i ba nga i a mogalo a Abaram sivuna memena re ngarume. Ka inae Abaram sana nena goe tale nae Nutu ke patokala minmina te i. ");
INSERT INTO mee_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Bae Nutu ke role kia roma, ‘Sisivungu memena ka la ri ra ragasila nga maga kunna a sana i a maga kunna ae ri. Na ka la ri ra barangaleleme ba ragau keke la baingasoali rea ka pesingmatana ka ri 400. ");
INSERT INTO mee_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ava iau ka la kalingnanange ra nginngina reke bai kerea minmina, ba ngarume na sisivungu memena keke la lelengmalaga nga maga kunna laeala. Na keke la kavanga te iau nga maga laekia ikia.’ ");
INSERT INTO mee_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nae Nutu ke tunge bainga e nga totongtaliu a i a piunga ba bonga kala nge Nutu te Abaram. Ka bainae Abaram ka tuna nge Aisak ba ke tototaliue mirana ka ina kana kaeme ka ri lima ba mologi ke rongo tapu. Na ngarume nae Aisak ka tuna nge Iekop, ba ngarume muni nae Iekop ka tuna memena nge sisiukita memena ka ri pana tangulelu ba lua. ");
INSERT INTO mee_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Nae Iekop tuna pattoto keke kelalelea teiteikerea ae Iosep, ka baina keke ba kia ta i a barangalele ngae Isip. Avae Nutu ke momo kala nge i ");
INSERT INTO mee_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ba ke ravulelea nga maenangme kinung reke lele nge i. Ba ka inae Iosep meisi ngamuga nga kelangpatali e ngae Isip eke patoe kae Pero raguna, nae Nutu ke tunge lomatana e pe raumana te Iosep. Na nga kelangpatali laeala kelangana kae Iosep ka i a agau ore pe. Minmina na i ke pulia Iosep ta i nge kelapatali tae Isip ba ta i nge kelapatali ta bale rae i. ");
INSERT INTO mee_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ngarume na osangana ke lele nga ina re ngae Isip bae Kenan, ba ka i a maenang e bollau raumana. Na sisiukita memena ka sana karea kaning. ");
INSERT INTO mee_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Na ka inae Iekop longe kaning ine momo ngae Isip, na i ke baꞌe sisiukita memena ta inaeala ka taongarea e kapunu. ");
INSERT INTO mee_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ba ka taongarea a lua nae Iosep ke turupote i muni ta tataokia memena, nae Pero ka lonamatana kae Iosep balekaina ae i. ");
INSERT INTO mee_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ngarume nae Iosep ke ba te tamana ae Iekop kala nga balekaina ae i kinung ta ri atung te i tae Isip. Ra nginngina kinung ka ri pana 75. ");
INSERT INTO mee_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Minmina nae Iekop ke loapisigi tae Isip, na ke momo nga inaeala ta ke lele nga kae ra mateng rave i kala nga sisiukita memena. ");
INSERT INTO mee_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ngarume na keke loa ka lavusakereame galiu tae Sekam. Na keke talu rea nga o a i a lollo masina a sisiukita ae Abaram kolia nga goe rae Amor ngae Sekam ka lollokanna palu. ");
INSERT INTO mee_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Na ka ina kae rae Nutu puli rea ta i kumangng kurumea patongkala laeala ae i tunge te Abaram ke lele kokoro, na ragau rae ita keke umma ta ri leleng papatu raumana ngae Isip. ");
INSERT INTO mee_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Na ngarume, ka inae Iosep mate tapu na kelangpatali te a sana lonamatana kae Iosep ke paturu ta i a kelangpatali ngae Isip. ");
INSERT INTO mee_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kelangpatali laeala ke patutaoe ragau rae ita ka goangana. Ba ke pamiralalia sisiukita memena ka kaonaginapitangana kerea ta ri saunga ka goe rae ri ra lagalaga lagapotu nga bale nga ri, ta baina ri ngeke mate. ");
INSERT INTO mee_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Na ka kae nginngina nae Moses naname ke toapisigia, ba ka i a goe tuna paenakena nge Nutu raguna. Ba keke pangngamasia nga bale ae tamana ka inname ka ri mologi. ");
INSERT INTO mee_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ka ineke pulia lagapotu nga bale ae i, nae Pero tunapiau ke rave ta pangnge ma i a tuna. ");
INSERT INTO mee_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ngarume na re ngae Isip keke palomatane Moses ka lomatana kinung nga ri. Ba i ke lele ma i a agau a kana ka gingginga raumana nga pangamologangana ba nga bainganame. ");
INSERT INTO mee_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ka inae Moses kana pesingmatana ka ri giaukaina lua na i ke bai ta loanga ta kelange ragau rae i re ngae Israel. ");
INSERT INTO mee_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ba ka ine loa na i ke kele agau te e ngae Isip ine balvalia agau te nge ri. Ka bainae Moses ke loa ta kalaunge ba ke balia Isip laeala na ke mate. ");
INSERT INTO mee_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses ka lonangana roma, ragau rae i nga loreamatana roma i ka i a agau a Nutu baꞌe ta ravungulele rea. Ava ri ke sane ke kelapatokone ollaeala. ");
INSERT INTO mee_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Me ngangaila, nae Moses ke lele nga Israelme ka ri lua ka ineke palivalvali rea, na i ke ava ta kangalele kerea ka pangamologangana roma, ‘Rapanung, ka onemea kinung ra koli ava kama ka palivalvali miau?’ ");
INSERT INTO mee_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Ava te e nge ri pana lua a i a baling puna ke botalale Moses, na ke role kia roma, ‘Tai ke puli one ta one kelanga te mangng ba kalingnana nge mangng? ");
INSERT INTO mee_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Alo bai ta sapingpunu iau base ino sapune Isip laeala ngalla ae?’ ");
INSERT INTO mee_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Na ka inae Moses longe pangamologa laeala na i ke kaꞌe Isip ba ke loa e lele ma i a agasila nga mogalo eke patoe kae Miria. Ngarume na i ka nena ka goe lua ra panung nga inaeala. ");
INSERT INTO mee_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ngarume ka ina pesingmatana giaukaina lua ke rongo tapu, na anggelo te ke lele nge Moses ngallo nga bega a matana ora sia toto ngia nga ina a sana ragau ngia kokoro nga kapangnga eke patoe kae Sainai. ");
INSERT INTO mee_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ka inae Moses kele ollaeala na i ke kallo raumana nga kelangana. Ba ka ine loa kokoro ta inaeala ta baina i nge kelamasia, na i ke longe Nutu kalingngana ine role roma, ");
INSERT INTO mee_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ka iau ae Nutu orae sisiukone memena ae Abaram bae Aisak bae Iekop ke kavkave.’ Minmina nae Moses mirana ke mammalu ka mataungana ba i ke matau ta kelangatupu ta inaeala. ");
INSERT INTO mee_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Nae Nutu ke role kia roma, ‘Ngo rusulage kesingsilagi rae one, ta malle laekolong a one maisi kia ka i a mogalo e tupu. ");
INSERT INTO mee_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Iau ka kele re ngae Isip ineke tunge miralali reke bollau ta ragau rae iau. Iau ka longokale taningarea, na ka atu lagape ta ravungmalaga rea. Iala na one ngo atu nasai ta iau ka la bangagaliu one tae Isip.’ ");
INSERT INTO mee_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses laekia ka i a agau laeala mana orama Israelme ke tangulelea ka balinglagangarea kia roma, ‘Tai ke puli one ta one kelanga te mangng ba kalingnana nge mangng?’ Ka i a agau ae Nutu muni baꞌe ta i nge kelapatali te ri ba nge ravulele rea ka gingginga ae anggelo e lele nge i nga bega a sia toto ngia. ");
INSERT INTO mee_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses laekia ke ngalu rea malaga ngae Isip, ba ke kuma ka kumangng reke gingging ba killa reke bollalau ngae Isip, ba nga Pelau E Tente, ba ngallo nga ina a sana ragau ngia ka pesingmatana ka ri giaukaina lua. ");
INSERT INTO mee_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Moses laekia a iau rorole te ka i ae Moses laeala mana ame pala ne role ka Israelme roma, ‘Nutu ke la bange agau e toe kaona e base me iau ba ka la i e nge miau te.’ ");
INSERT INTO mee_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ka i a agau e momo kala nga Israelme ka ineke katukala nga ina a sana ragau ngia. I ke momo nga inaeala kala nga sisiukita memena, ba ke momo kala nga anggelo e pamologa te i nga Kapangnga Ae Sainai. Ba ke rave pangamologa rae Nutu kanna reke momo passavele ta i kalangavasa rea te ita. ");
INSERT INTO mee_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Avae sisiukita memena keke longosa te i. Keke tangulelea ba ngallo nga lorea keke bai ta kangagaliu tae Isip muni. ");
INSERT INTO mee_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ka inae Moses mome panna te tale nga kapangng na keke role kae teiteikia ae Aron roma, ‘Ngo kuma ka nutu palu ta ri taongamuga kamangng ta mangng ka sana lomangngmatana ka taru e lele nge Moses laeala e ravumalaga mangng ngae Isip.’ ");
INSERT INTO mee_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kae laeala ka i a kae a ri ke kuma ka nutu te a goanga a sinna ma bulmakau. Na keke balia posime ba keke tungu rea ma tungame te nutu a goanga laeala. Ba keke baia kaning a alangpaga ore nga oraeala a ri muni ke kuma kia ka kamareame. ");
INSERT INTO mee_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Avae Nutu ke bali ka gina te ri, ba ke tungu rea ta baingarea reke sosoali ta ri kavang ta mata reke momo ngailu nga tava. Ke loa kurumea pangamologa ineke paꞌe nga lau ae ragau reke toe Nutu kaona roma, “‘Ragau re ngae Israel! Ka ina miau ka momo ngallo nga ina a sana ragau ngia ka pesingmatana ka ri giaukaina lua, na miau ka sana ka balia posime ta tunga rea ma tungame te iau. Ke sa. ");
INSERT INTO mee_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Miau kaka paue balvale orae nutu aka patoe kae Malak, ba kaka paue oru a sinna ma mata nga tava orae nutu ae miau aka patoe kae Rampa; ka ri ra nutu ra goanga ra miau ka kuma ki ta kavanga tao. Minmina na iau ka la bange ragau ta ri ravungpatali ka miau ta ina nge ngae Babilon bavana tetoto.’ ");
INSERT INTO mee_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ava balvale ore nga Turungpota ke momo kala nge sisiukita memena nga ina a sana ragau ngia. Ba ri keke kuma kia basema inae Nutu panana kia te Moses kurumea Nutu pakosiningngana kia te i. ");
INSERT INTO mee_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ngarume nae sisiukita memena reke rave balvale laeala nga tamarea memena keke paue kala nge ri ineke loakurumea Iosua. Ba keke paue kala nge ri ka ineke rave mogalo nga ragau ra Nutu taomalaga rea nga mallereame ine taoamugmuga kerea. Balvale laeala ke momo nga inaeala ta ke lele nga kae ae Revit ");
INSERT INTO mee_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","a i a agau ae Nutu materaumane. Ba ka i a agau e ballage Nutu ta i nge kuma ka bale te orae Nutu ae sisiukia ae Iekop kavkave. ");
INSERT INTO mee_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ava tuna ae Solomon ka i a agau ore kuma ka bale orae Nutu. ");
INSERT INTO mee_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Avae Nutu E Ngailu Raumana ke sane momolu nga bale ra ragau ke kuma ki ka kamareame. Ba ollaeala ke loakurumea pangamologa a agau e toe Nutu kaona rolea pala e role roma, ");
INSERT INTO mee_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Nutu ke role roma, ‘Tarang ae iau nga kelangpatali ke momo nga tava, ba mogalo e ngape ka i a patangapaikala orae kaegu. Minmina na miau ka sana kamiau gingginga ta kumangng ka bale ae iau, ba ka sana kamiau gingginga ta kumangng ka mallegu e nga pannang kia. ");
INSERT INTO mee_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ta iau muni ka kuma ka oru nginngina.’” ");
INSERT INTO mee_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Nae Stepan ke role ka ra nginngina reke tattara ngallo nga Ginunga Nga Reke Taoamugmuga Ka Iurame roma, “Ka miau ra longasakana! Lomiaume keke tangulelea Nutu palimule ba longamiaume keke rutukala ta pangamologa a kanna. Miau ka tongamiau kena mana ma sisiukamiau memena ra sana omorea ta ri loangakurumea Kannu E Tupu. ");
INSERT INTO mee_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Sisiukamiau memena keke pamiralalia ragau reke toe Nutu kaona kinung. Ba bole keke sapune reke tuture Barangalele ae Nutu kanna e Tupu atungngana e ngarume. Ba sonrau na miau kaka potulu kana ba kaka balia e mate. ");
INSERT INTO mee_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ka miau ra ragau raka rave bangapaga rae Nutu kanna ra anggelome ke atupisigi ki, ava miau ka sana ka longo tao.” ");
INSERT INTO mee_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ka ina ravollalau nginngina ke longe pangamologa laeala, na ri ka iukerea kia raumana ba keke tampite ngingireame te i ka siarealalingana. ");
INSERT INTO mee_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Avae Stepan ke ponu kae Kannu E Tupu ba ke kelapatae ta tava. Na ke kele olamana ae Nutu e toakala bae Iesus ine maisi nga Nutu bavana e pe. ");
INSERT INTO mee_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Na i ke role roma, “Ngaka kela! Iau ka kele tava ke pulapatali bae Agau Tuna ke maisinsi nge Nutu bavana e pe.” ");
INSERT INTO mee_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Na ra nginngina kinung keke tangakale longareame ka kamarea, ba keke lavoalla kaligi ka kalingngareame. Na keke piraguru kinung te Stepan ");
INSERT INTO mee_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ba keke utulale lagapotu nga maga kunna laeala e bollau. Na keke tamalia ka lollome. Ba reke kuma ka ollaeala keke ule lungapaga ngae ri re ngapotu nga agau a taulai a giana nge Sol kaena puname. ");
INSERT INTO mee_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ka ineke tantamalia Stepan tale na i ke kiu te Avolau roma, “Iesus One A Bollau, ngo rave kannugu.” ");
INSERT INTO mee_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Na i ke pupu ka banungkiame ba ke kiu kaligi roma, “Avolau, ko sono ngo ale baingarea laekia e soali te ri.” Ka ine role minmina tapu na matana kanname keke balipunu ka matengana. ");
INSERT INTO mee_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Bae Sol ka sianakena kala nge ri ta Stepan nge mate. Ba ka kae laeala na ragau keke paturu ta pangamiralalinge ra lopatokonakana te Karais reke momo ngae Ierusalem. Minmina na ra lopatokonakana kinung keke ka kalaoveka ta ina nge ngae Iurea bae Sameria. Nae Aposelme kasikerea keke momo ngae Ierusalem. ");
INSERT INTO mee_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ba ragau palu reke kave Nutu palimule keke talue Stepan ba ka loreatania raumana. ");
INSERT INTO mee_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Avae Sol ke paturu ta baingasoalinge ra lopatokonakana. Ke lola ta baleme na ke utupallala ka rapanung ba ravale ra lopatokonakana ta pulinglu rea nga pulangkala. ");
INSERT INTO mee_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Minmina na ra lopatokonakana reke ka kalaoveka keke pulimalaglage pangamologa e te Iesus nga iname kinung ra ri ke loa tao. ");
INSERT INTO mee_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Bae Pilip ke loa lagape ta maga kunna te ngallo ngae Sameria na ke pulimalage Karais giana nangina. ");
INSERT INTO mee_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ka ina maluame ke longe Pilip pangamologangana ba keke kele killa reke bollalau ra i kuma ki, na keke balimasi ka longareame ta pangamologangana. ");
INSERT INTO mee_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kannu reke sosoali keke kamalaga patalia ragau papatu ka relinglagangarea. Ba ragau papatu ra mirareame ke mate ba ragau ra kaereame ke mate keke pepe. ");
INSERT INTO mee_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Minmina na serenga e bollau ke lele ngallo nga maga kunna laeala. ");
INSERT INTO mee_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na ka apanung te a giana nge Saimon ke